﻿USE sofia;
DROP TABLE IF EXISTS sofia.bco_vpl;
CREATE TABLE bco_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bco_vpl WRITE;
INSERT INTO bco_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Tamindeya mo꞉mo꞉dakiyo꞉, Gode eyo꞉ akin o꞉lia꞉ henfelo꞉ o꞉lia꞉ dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Hen misido꞉wo꞉ aundo꞉ma a꞉la꞉ta꞉ga꞉ fo꞉fo꞉dolo꞉ ko꞉lo꞉ elen. Ho꞉na꞉yo꞉ heno꞉ go꞉lula꞉fo꞉labikiyo꞉, tambo sololiya elen. A꞉la꞉ta꞉ga꞉ Godeya꞉ ene Mamayo꞉ ho꞉n wa꞉l a꞉na sia꞉len. ");
INSERT INTO bco_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Gode eyo꞉ a꞉la꞉sio꞉, “Ho꞉wo꞉ fa꞉la꞉doma” a꞉la꞉sa꞉labiki, ho꞉wo꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Gode eyo꞉ ho꞉ a꞉no꞉ nafa ba꞉dabikiyo꞉, ho꞉ o꞉lia꞉ sololi a꞉no꞉lia꞉yo꞉ a꞉na alobanala꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ ho꞉ a꞉no꞉ “Ho꞉len” wikilaki, sololi a꞉no꞉ “Nulu” wikilo꞉. Ho꞉leno꞉ a꞉la꞉ga꞉ sololiabiki, ho꞉len agelo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","7","Gode eyo꞉ a꞉la꞉sio꞉, “Ho꞉n we aloba꞉dakiyo꞉, ho꞉ndo꞉ ka꞉ma꞉no꞉ kelego꞉wo꞉ usamio꞉ fa꞉la꞉doma.” A꞉la꞉sa꞉labiki a꞉naka fa꞉la꞉dowo꞉. Ho꞉ndo꞉ ka꞉lan kelego꞉wo꞉ dia꞉tabiki, ho꞉no꞉ usa alobanala꞉. Ho꞉n nowo꞉ iwalu ta꞉taki, ho꞉n nowo꞉ ha꞉ga ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ho꞉ndo꞉ aloba꞉dan kelego꞉ a꞉no꞉ Gode eyo꞉ “akin” wikilo꞉. Ho꞉leno꞉ a꞉la꞉ga꞉ sololiabiki, ho꞉len andebo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Akin ha꞉g amio꞉, hen kalaido꞉wo꞉ fa꞉la꞉doma꞉ki, ho꞉no꞉ nowa kegenema.” A꞉la꞉sa꞉labiki a꞉la꞉ka fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Kalaido꞉ a꞉no꞉ Gode eyo꞉ “hen” wikilo꞉. Ho꞉n kegenelia꞉ga꞉lo꞉ dowo꞉ a꞉no꞉ “so꞉lu ho꞉n” wikilo꞉. Gode eyo꞉ dimida꞉sa꞉ga꞉ ta꞉fo꞉ ko꞉lo꞉ nafa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Hen amilo꞉ fa꞉la꞉ba꞉no꞉ kelego꞉ a꞉no꞉ tambo fa꞉la꞉doma. I ko꞉li ko꞉lilo꞉ o꞉lia꞉, e ko꞉li ko꞉lilo꞉ o꞉lia꞉ a꞉no꞉ tambo fowo꞉ enedo꞉leko꞉ helema꞉ki fa꞉la꞉doma.” A꞉la꞉sa꞉labiki a꞉la꞉ka fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Henfelo꞉ amilo꞉ fa꞉la꞉ndan kelego꞉, i ko꞉li ko꞉lilo꞉ o꞉lia꞉, e ko꞉li ko꞉lilo꞉ o꞉lia꞉yo꞉ tambo fa꞉la꞉ne. A꞉no꞉ tambo fowo꞉ enedo꞉leko꞉ helema꞉ki ta꞉fo꞉. A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉no꞉ nafa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ho꞉leno꞉ a꞉la꞉ga꞉ sololiabiki, ho꞉len asolo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Akin a꞉namio꞉ ho꞉len o꞉lia꞉ nulu o꞉lia꞉yo꞉ alobanama꞉ki, ho꞉lo꞉ doma꞉no꞉wo꞉ tambo fa꞉la꞉doma. Ho꞉ a꞉ma꞉yo꞉ ele ba꞉ba꞉no꞉ dowakiyo꞉, ho꞉leno꞉, donayo꞉, ta꞉no꞉, imo꞉wo꞉ a꞉ma꞉ aloba꞉da꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","A꞉la꞉ta꞉ga꞉ ho꞉ akin amilo꞉ ta꞉fo꞉ a꞉ma꞉yo꞉ henfelo꞉mo꞉wo꞉ ho꞉wo꞉ dimina.” A꞉la꞉sa꞉labiki a꞉la꞉ka fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Gode eyo꞉ ho꞉wo꞉ alan a꞉la꞉ ko꞉lo꞉ dimido꞉. Ho꞉ mada alan a꞉ma꞉yo꞉ ho꞉leno꞉ e bo꞉fo꞉melea꞉ki dimido꞉. Ho꞉ alandego꞉ a꞉ma꞉yo꞉ nuluwo꞉ e bo꞉fo꞉melea꞉ki dimido꞉. A꞉la꞉ta꞉ga꞉ tamino꞉lo꞉ dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","I a꞉no꞉ akina ta꞉taki, ho꞉wo꞉ henfelo꞉mo꞉wo꞉ dimia꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Ho꞉ i a꞉ma꞉yo꞉ ho꞉len o꞉lia꞉ nulu o꞉lia꞉yo꞉ bo꞉fo꞉liki aloba꞉da꞉melea꞉ki ta꞉fo꞉. Gode eyo꞉ a꞉no꞉ dimida꞉sa꞉ga꞉ ta꞉fo꞉ ko꞉lo꞉ nafa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Ho꞉leno꞉ a꞉la꞉ga꞉ sololiabiki, ho꞉len fa꞉la꞉lamelo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Ho꞉n amio꞉lo꞉ mela꞉no꞉lo꞉ a꞉lab ko꞉li ko꞉lilo꞉ a꞉no꞉ ililifoma. A꞉la꞉ta꞉ga꞉ o꞉ba꞉ ko꞉li ko꞉lilo꞉ a꞉no꞉ tambo iwaluwo꞉ dalolia꞉ sima꞉ki fa꞉la꞉doma” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","A꞉la꞉go꞉ko꞉lo꞉ ka꞉ mada alan ho꞉na꞉ usamilo꞉ sano꞉lo꞉, mela꞉no꞉lo꞉ a꞉lab kelego꞉ ko꞉li ko꞉lilo꞉ ho꞉na꞉ usamilo꞉ dalale san a꞉no꞉lo꞉ tambo, a꞉la꞉ta꞉ga꞉ o꞉ba꞉yo꞉lo꞉, tambowo꞉ inin misido꞉ sugusula꞉melea꞉ki, Gode eyo꞉ dimida꞉sa꞉ga꞉ ta꞉fo꞉ ko꞉lo꞉ nafa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Gode eyo꞉ iyo꞉ halaido꞉ doma꞉ki a꞉la꞉sio꞉, “Gio꞉ inso꞉wo꞉ modo꞉ sugusulakiyo꞉, ho꞉no꞉ tambo ilila꞉bi. A꞉la꞉ta꞉ga꞉ o꞉ba꞉ gio꞉lo꞉ uso꞉ modo꞉ segesela꞉la꞉ga꞉ gula꞉sa꞉ga꞉yo꞉, henfelo꞉ we ilili alita꞉bi” a꞉la꞉dinali salifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Ho꞉leno꞉ a꞉la꞉ga꞉ sololiabiki, ho꞉len biyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","A꞉la꞉dimida꞉sa꞉ga꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Hen wenamio꞉ no꞉ ko꞉li ko꞉lilo꞉ a꞉lab a꞉no꞉ tambo, no꞉ kaluwa꞉lo꞉ fofano꞉lo꞉, no꞉ ilaboda꞉lo꞉ sano꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, inin misido꞉le ko꞉li ko꞉lilo꞉ a꞉no꞉ fa꞉la꞉dota꞉ga꞉ mela꞉no꞉ doma.” A꞉la꞉sa꞉labiki a꞉la꞉ka fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Gode eyo꞉ hen wenamilo꞉ no꞉ ko꞉li ko꞉lilo꞉ a꞉lab a꞉no꞉ tambo, no꞉ kaluwa꞉lo꞉ fofano꞉lo꞉, no꞉ ilaboda꞉lo꞉ sano꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, inin misido꞉le ko꞉li ko꞉lilo꞉ a꞉no꞉ Gode eyo꞉ dimida꞉sa꞉ga꞉ ta꞉fo꞉ ko꞉lo꞉ nafa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","A꞉la꞉dimidalita꞉ga꞉yo꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ kaluka꞉isaleyo꞉ dimidakiyo꞉, ninin misido꞉ o꞉ngo꞉ doma꞉ki, a꞉la꞉ta꞉ga꞉ ninin asulo꞉ o꞉ngo꞉ doma꞉ki dimidama꞉niki. Kaluka꞉isale wema꞉yo꞉ ka꞉ ho꞉n amilo꞉ sano꞉lo꞉, o꞉ba꞉ iwalulo꞉ sano꞉lo꞉, no꞉ fofano꞉lo꞉, a꞉la꞉ta꞉ga꞉ no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, henfelo꞉ amilo꞉ a꞉lab we tambo imo꞉ bo꞉fo꞉melea꞉ki ta꞉fa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isaleyo꞉ asulo꞉ o꞉lia꞉ misido꞉ o꞉lia꞉yo꞉ Godeya꞉ enen o꞉ngo꞉ dimido꞉. Inin misido꞉ o꞉ngo꞉ dimido꞉ a꞉namio꞉, kalu o꞉lia꞉ ga o꞉lia꞉ ko꞉lo꞉ ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Gode eyo꞉ iyo꞉ halaido꞉ nafa mesea꞉kiyo꞉, towo꞉ a꞉la꞉sio꞉, “Giliyo꞉ so꞉wayo꞉ sa꞉la꞉la꞉i ha꞉nakiyo꞉, modo꞉ fa꞉la꞉dowaki, henfelo꞉ we tambo ilila꞉bi. A꞉la꞉ta꞉ga꞉ henfelo꞉ we tambo gili bo꞉fo꞉lubi. Ka꞉ ho꞉n amilo꞉ sano꞉lo꞉, o꞉ba꞉ dalolia꞉ga꞉lo꞉ siano꞉lo꞉, no꞉ fofano꞉lo꞉, a꞉la꞉ta꞉ga꞉ no꞉ kelego꞉ galin hen amilo꞉ dalale sano꞉lo꞉, a꞉no꞉ tambo gili bo꞉fo꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉sa꞉lakiyo꞉, “Henfelo꞉ amilo꞉ e folo꞉ hedan o꞉lia꞉, i folo꞉ hedan o꞉lia꞉ a꞉no꞉ tambo gimo꞉ maiya꞉ki dimio꞉l. ");
INSERT INTO bco_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","No꞉ hen amilo꞉ sano꞉lo꞉, o꞉ba꞉ iwalulo꞉ dalolia꞉ga꞉lo꞉ siano꞉lo꞉, a꞉la꞉ta꞉ga꞉ no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, kelego꞉ tambo mela꞉no꞉lo꞉ a꞉lab i a꞉no꞉ i fo꞉s o꞉lia꞉ fugus o꞉lia꞉yo꞉ imo꞉ maiya꞉ki dimio꞉l.” A꞉la꞉sa꞉labiki a꞉la꞉ka fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Kelego꞉ tambo enedo꞉ dimido꞉ a꞉no꞉, Gode eyo꞉ mada nafale ba꞉ba꞉. Ho꞉leno꞉ a꞉la꞉ga꞉ sololiabiki, ho꞉len do꞉go꞉feyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","A꞉la꞉fo꞉ko꞉lo꞉ akin o꞉lia꞉ henfelo꞉ o꞉lia꞉, a꞉la꞉ta꞉ga꞉ kelego꞉ a꞉namilo꞉ da꞉lab a꞉no꞉lia꞉yo꞉ tambo dimida꞉sa꞉ga꞉ ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Gode eyo꞉ ene nanogo꞉ dia꞉i ya꞉la꞉ga꞉ eletakiyo꞉, ho꞉len dom amio꞉ e ha꞉fo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ ho꞉len dom a꞉no꞉ malilo꞉le da꞉fe alitaki, ho꞉len dom a꞉ma꞉yo꞉ kaluka꞉isaleyo꞉ nafale mesea꞉ki, halaido꞉ dimidalifa꞉. Mo꞉wo꞉ Gode eyo꞉ henfelo꞉ wenamilo꞉ fa꞉la꞉doma꞉kilo꞉ nanog dia꞉len a꞉no꞉ kedela꞉sa꞉ga꞉ eletakiyo꞉, ho꞉len dom a꞉namio꞉ e ha꞉fo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Gode elo꞉ akin o꞉lia꞉ henfelo꞉ o꞉lia꞉ dimido꞉ malolo꞉wo꞉ o꞉m. Gode Yawe a꞉ma꞉yo꞉ akin o꞉lia꞉ henfelo꞉ o꞉lia꞉ dimido꞉ amio꞉, ");
INSERT INTO bco_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","egelo꞉ amilo꞉ e kelego꞉wo꞉ musug ko꞉li ko꞉lilo꞉wo꞉ semo꞉fa꞉la꞉dowo꞉, a꞉la꞉ta꞉ga꞉ ilaboda꞉lo꞉ inin asulo꞉lo꞉ fa꞉la꞉dowan a꞉no꞉lo꞉ o꞉semo꞉fa꞉la꞉dowo꞉. Mo꞉wo꞉ Gode Yawe a꞉ma꞉yo꞉ henfelo꞉ amio꞉ ho꞉no꞉ timena꞉kiyo꞉ mo꞉ta꞉fo꞉. A꞉la꞉ta꞉ga꞉ elo꞉ gelakilo꞉ nanogdo꞉ dia꞉no꞉ kaluwo꞉ aundo꞉ma. ");
INSERT INTO bco_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Ko꞉sega ho꞉len a꞉namio꞉ kola꞉ mumus ko꞉lo꞉ fa꞉la꞉dowab a꞉ma꞉yo꞉, henfelo꞉wo꞉ tambo ho꞉na꞉ agolo꞉ alita꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","A꞉lalitakiyo꞉ Gode Yawe eyo꞉ heno꞉ dia꞉ga꞉ kaluwo꞉ a꞉na dimida꞉sa꞉ga꞉, ene migiya mela꞉no꞉ meho꞉wo꞉ folo alitabiki, kaluwo꞉ mela꞉no꞉wo꞉ a꞉na dia꞉sa꞉ga꞉, mo꞉mo꞉da asifo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","A꞉la꞉dimida꞉sa꞉ga꞉ Gode Yawe a꞉ma꞉yo꞉ egelo꞉ nowo꞉ ofdo꞉ yan doba꞉da꞉ a꞉na gele alifa꞉. Hena꞉ wi a꞉no꞉ Ida꞉n. Egelo꞉ a꞉namio꞉ kalu elo꞉ dimido꞉ a꞉no꞉ a꞉na ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Hen a꞉namio꞉ i ko꞉li ko꞉lilo꞉, i nafalo꞉ ba꞉ba꞉no꞉ o꞉lia꞉ i fo nafa nan o꞉lia꞉yo꞉, Gode Yawe eyo꞉ a꞉na fa꞉la꞉doma꞉ki dimido꞉. Egelo꞉ us amio꞉ mela꞉no꞉lo꞉ dimia꞉sen iyo꞉ a꞉na elen. A꞉la꞉ta꞉ga꞉ i nowo꞉, asulo꞉ nafa o꞉lia꞉ mogago꞉ o꞉lia꞉lo꞉ alobana wida꞉sen i a꞉no꞉lo꞉ a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ho꞉n nowo꞉ Ida꞉n egelo꞉ us a꞉na a꞉la꞉ta꞉ga꞉ ha꞉nakiyo꞉, egelo꞉ a꞉no꞉ ho꞉n a꞉ma꞉ agolo꞉wo꞉ dimia꞉sen. Ho꞉n a꞉no꞉ egelo꞉wo꞉ ta꞉ta꞉ga꞉ kini a꞉no꞉ ha꞉nakiyo꞉ fa꞉la꞉da꞉in dage fufudo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","12","Ho꞉n agelo꞉ wiyo꞉ Bison. Ho꞉n a꞉no꞉ Habila hen us a꞉na ha꞉na꞉ni ane. Habila hen a꞉namio꞉ u nafa nowo꞉ ene wiyo꞉ go꞉l, a꞉na delen. A꞉la꞉ta꞉ga꞉ u nafa momado꞉ ko꞉li ko꞉lilo꞉ nolo꞉lo꞉ a꞉na delen. A꞉la꞉ta꞉ga꞉ hen a꞉namio꞉ i ko꞉li nowo꞉, i mak mundo꞉ nafalo꞉ da꞉dan a꞉no꞉ a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ho꞉n andebo꞉ wiyo꞉ Gihon. Ho꞉n a꞉no꞉ Kus hen us a꞉na ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ho꞉n asolo꞉ wiyo꞉ Taigilis. Ho꞉n a꞉no꞉ Asilia hen ofdo꞉ yan doba꞉da꞉ a꞉na ha꞉na꞉ni ane. A꞉la꞉ta꞉ga꞉ ho꞉n fa꞉la꞉lamelo꞉ wiyo꞉ Yufuletis. ");
INSERT INTO bco_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","A꞉la꞉ta꞉ga꞉yo꞉ Gode Yawe eyo꞉ kalu elo꞉ dimido꞉ a꞉no꞉ dia꞉sa꞉ga꞉, Ida꞉n egelo꞉ us a꞉na nanogo꞉ dia꞉liki bo꞉fo꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","17","Gode Yawe eyo꞉ kalumo꞉wo꞉ towo꞉ halaido꞉ sa꞉laki, “Egelo꞉ wenamio꞉ i fo a꞉lab a꞉no꞉ tambowo꞉ o꞉li ma꞉ib ko꞉sega, asulo꞉ nafa o꞉lia꞉ mogago꞉ o꞉lia꞉lo꞉ alobana wida꞉sen i a꞉ma꞉ fowo꞉ na꞉so꞉bo. Mo꞉wo꞉ i fo a꞉no꞉ nalega, ho꞉len a꞉namio꞉ ge mada soma꞉ib.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","A꞉la꞉ta꞉ga꞉ Gode Yawe eyo꞉ a꞉la꞉sio꞉, “Kalu we ina꞉li mela꞉no꞉wo꞉ mo꞉ililo꞉ ko꞉lo꞉, elo꞉ egema꞉no꞉ nowo꞉ dimidama꞉nigo꞉l. A꞉ma꞉yo꞉ e tilidowaki asuwa꞉fa꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Gode Yawe a꞉ma꞉yo꞉ heno꞉ dia꞉sa꞉ga꞉, no꞉ ilaboda꞉lo꞉ san o꞉lia꞉ o꞉ba꞉ dalalelia꞉ga꞉lo꞉ sian o꞉lia꞉ a꞉no꞉ tambo dimida꞉sa꞉ga꞉ ta꞉fo꞉. Gode eyo꞉ no꞉ a꞉no꞉ kaluwa꞉lo꞉ wi wikilab a꞉no꞉ ba꞉ba꞉no꞉ a꞉la꞉ta꞉ga꞉ tililia꞉mio꞉. A꞉la꞉ta꞉ga꞉ kaluwa꞉lo꞉ no꞉ o꞉lia꞉ o꞉ba꞉ o꞉lia꞉ wikili alifelab a꞉no꞉ inin wiyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","A꞉la꞉gabiki o꞉ba꞉ dalalelia꞉ siano꞉lo꞉, no꞉ ko꞉li ko꞉lilo꞉, fofan o꞉lia꞉ ilaboda꞉ no꞉ o꞉lia꞉ a꞉no꞉ tambo wikili alifelo꞉. Ko꞉sega no꞉ i a꞉ma꞉yo꞉ kalu asuwa꞉takilo꞉, ege doma꞉no꞉wo꞉ imilo꞉wo꞉ mo꞉dowo꞉ ");
INSERT INTO bco_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","A꞉la꞉fo꞉ko꞉lo꞉ Gode Yawe eyo꞉ kaluwo꞉ mida꞉iyo꞉ dimiabiki kogodo꞉. Kalu a꞉no꞉ kogolofolabiki, kalu a꞉ma꞉ tidif imilig nowo꞉ galilia꞉sa꞉ga꞉, do꞉go꞉fo꞉ a꞉ma꞉la꞉ hinsili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Gode Yawe eyo꞉ kaluwa꞉ tidif a꞉na a꞉la꞉ta꞉ga꞉yo꞉ gayo꞉ a꞉na dimido꞉. Ga dimido꞉ a꞉no꞉ kalulo꞉wa tililia꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kaluwa꞉ sa꞉laki, “Wiso꞉, mada o꞉m, Ki a꞉no꞉, ki nino꞉, Do꞉mo꞉ a꞉no꞉, do꞉mo꞉ nino꞉. E kalu neya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowab, Ko꞉lo꞉ e ‘Ga’ a꞉la꞉sa꞉la꞉mela꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Gayo꞉ kaluwa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉ a꞉na ilikiyo꞉, kaluwa꞉yo꞉ iya o꞉lia꞉ ano o꞉lia꞉yo꞉ ta꞉ta꞉ga꞉, ene inga o꞉lia꞉ asulo꞉ imilise dowaki, a꞉la꞉yo꞉ do꞉mo꞉ imilise doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","A꞉la꞉ta꞉ga꞉ kalu o꞉lia꞉ inga o꞉lia꞉yo꞉ hagulabo elen ko꞉sega, a꞉la꞉ amio꞉ sendelowo꞉wo꞉ aundo꞉ma dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Gode Yawe eyo꞉ no꞉ a꞉no꞉ tambo dimido꞉ ko꞉sega, sowa꞉ e amio꞉ dikilima꞉no꞉ asulo꞉wo꞉ alan ko꞉lo꞉, asulo꞉ a꞉na ilikiyo꞉ no꞉ nolo꞉ e tinio꞉ ko꞉lo꞉lab. Sowa꞉ eyo꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “ ‘Egelo꞉ usamilo꞉ i fo da꞉lab a꞉no꞉ tambo na꞉so꞉bo’ a꞉la꞉do꞉ Godeya꞉lo꞉ sio꞉wo꞉ hendeyo꞉?” ");
INSERT INTO bco_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Ga a꞉ma꞉yo꞉ sowa꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉no꞉ egelo꞉ usamio꞉ i fowo꞉ o꞉li ma꞉no꞉ ko꞉sega, Gode eyo꞉ na꞉nbo꞉wo꞉ a꞉la꞉sio꞉, ‘Egelo꞉ usamilo꞉ i imilise a꞉lab a꞉ma꞉ fowo꞉ na꞉so꞉bo. A꞉la꞉ta꞉ga꞉ fo a꞉no꞉ gola꞉so꞉bo. A꞉la꞉dimidalega ge soma꞉ib.’ ” ");
INSERT INTO bco_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","A꞉la꞉sa꞉labiki sowa꞉ eyo꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “Ge mada mo꞉soma꞉ika꞉! ");
INSERT INTO bco_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Mo꞉wo꞉ Gode eyo꞉ a꞉la꞉asulab, ge i fo a꞉no꞉ nalega, ho꞉len a꞉namio꞉ gi siyo꞉ fage alitalikiyo꞉, Godeyo꞉ o꞉ngo꞉ dowaki, mogago꞉ o꞉lia꞉ nafa o꞉lia꞉yo꞉ aloba꞉daki a꞉la꞉ba꞉ba꞉ib,” sowa꞉ eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","A꞉la꞉fo꞉ko꞉lo꞉ ga a꞉ma꞉yo꞉ i a꞉no꞉ nafale ba꞉da꞉sa꞉ga꞉, fo elo꞉ a꞉no꞉ nalikiyo꞉ nudo꞉wo꞉ nafa doma꞉ib a꞉la꞉asulo꞉. A꞉la꞉ta꞉ga꞉ i fo a꞉no꞉ nalikiyo꞉ asulo꞉wo꞉ nafale dia꞉no꞉ a꞉no꞉ eyo꞉ dimo꞉losa꞉ a꞉lakiyo꞉, ga a꞉ma꞉yo꞉ i fo a꞉no꞉ tula꞉sa꞉ga꞉ mo꞉no꞉. Ino꞉ e o꞉lia꞉ elen ko꞉lo꞉, ga a꞉ma꞉yo꞉ i fowo꞉ inbo꞉wo꞉ dimiabiki, elo꞉ mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","A꞉la꞉yo꞉ i fo a꞉no꞉ na꞉sa꞉ga꞉ dowabiki, a꞉la꞉ma꞉ asulo꞉wo꞉ kolaetabiki ba꞉ba꞉ amio꞉, a꞉la꞉yo꞉ hagulabo elena ba꞉ba꞉. A꞉la꞉fo꞉ko꞉lo꞉ alona꞉ fo꞉so꞉ alula꞉sa꞉ga꞉, a꞉na ko꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ga꞉lo dowabikiyo꞉, a꞉la꞉ma꞉yo꞉ Gode Yawe e egelo꞉ usamio꞉ sia꞉labiki dabu ko꞉lo꞉, Gode eyo꞉ a꞉la꞉yo꞉ ba꞉dabena꞉ki, egelo꞉ usamio꞉ i a꞉laba wo꞉no꞉le mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Ko꞉sega Gode Yawe eyo꞉ kaluwo꞉ ho꞉idaki a꞉la꞉sio꞉, “Ge o꞉ba eleya?” ");
INSERT INTO bco_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Kaluwa꞉ a꞉ma꞉la꞉ sa꞉laki, “Ge egelo꞉ usamilo꞉ ha꞉nabo꞉ da꞉da꞉sa꞉ga꞉, ne hagulabo ko꞉lo꞉ tagilabiki wo꞉no꞉le mesa꞉ni ane.” ");
INSERT INTO bco_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","A꞉la꞉sa꞉labiki Gode Yawe eyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge hagulabo dowo꞉ a꞉la꞉bo꞉ abe sio꞉wo꞉? Ge i fo nilo꞉ na꞉so꞉boka꞉ a꞉la꞉do꞉ halaido꞉ sio꞉wo꞉ mo꞉no꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kaluwa꞉ a꞉ma꞉la꞉ sa꞉laki, “Ga gilo꞉ nemo꞉lo꞉ ta꞉fo꞉ wema꞉yo꞉ i fowo꞉ nemo꞉ tu meabiki, niyo꞉ mo꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","A꞉la꞉sa꞉labiki Gode Yawe eyo꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ dimido꞉ we, waingo꞉wa꞉le?” A꞉la꞉dabu ba꞉dabiki, gaya꞉ a꞉ma꞉la꞉ sa꞉laki, “Sowa꞉ya꞉ ne dikili sio꞉ ko꞉lo꞉, niyo꞉ mo꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","A꞉la꞉ta꞉ga꞉ Gode Yawe a꞉ma꞉yo꞉ sowa꞉mo꞉ sa꞉laki, “Giyo꞉ a꞉la꞉dimido꞉ ko꞉lo꞉, falasilo꞉ gilo꞉wo꞉ no꞉ fofan o꞉lia꞉ no꞉ ilaboda꞉ san o꞉lia꞉ma꞉lo꞉wo꞉ gilo꞉ diab a꞉ma꞉ tininima꞉ib. Gelo꞉ dowa꞉i ha꞉na꞉mela꞉no꞉ amio꞉, ge kufa꞉ ha꞉na꞉mela꞉ib, a꞉la꞉ta꞉ga꞉ hena꞉mu na꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","A꞉la꞉ta꞉ga꞉ ge o꞉lia꞉ ga o꞉lia꞉yo꞉ gis dowa꞉i ha꞉na꞉melea꞉ki ta꞉to꞉l. Gilo꞉ inso꞉ sugusula꞉li ha꞉nab i o꞉lia꞉, gaya꞉lo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉nab o꞉lia꞉yo꞉ gis dowa꞉mela꞉ib. Gaya꞉lo꞉ so꞉wa sa꞉la꞉la꞉likilo꞉ ha꞉nab iliyo꞉ ge misa꞉ya sa꞉ndalikiyo꞉, giyo꞉ ili giba꞉ doma ma꞉buluma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","A꞉la꞉ta꞉ga꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “Ge so꞉wa silikiyo꞉, hida꞉yo꞉ alan doma꞉ib a꞉la꞉ta꞉ga꞉, gelo꞉ so꞉walo꞉ sa꞉la꞉liab amio꞉, nagalo꞉wo꞉ alan fa꞉la꞉doma꞉ib. Giyo꞉ kalu gilo꞉wo꞉ alan asula꞉mela꞉ib, ko꞉sega kalu gilo꞉ma꞉yo꞉ elo꞉ asulab au dimidama꞉kiyo꞉ ge mada halaido꞉ bo꞉fo꞉mela꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Gode eyo꞉ kalu emo꞉wo꞉ a꞉la꞉sio꞉, “Ge gaya꞉ to sio꞉wo꞉ da꞉da꞉sa꞉ga꞉, i fo nilo꞉ na꞉so꞉boka꞉ a꞉la꞉do꞉ sio꞉ a꞉no꞉ mo꞉no꞉ ko꞉lo꞉, to we gemo꞉ sa꞉ma꞉nigo꞉l. “Gilo꞉ dimido꞉ a꞉na ilikiyo꞉, niyo꞉ henfelo꞉ welo꞉ falasila꞉ma꞉no꞉. Ho꞉leno꞉ tambowo꞉ ma꞉no꞉ ma꞉no꞉ gema꞉nikiyo꞉, ge nanogo꞉ halaido꞉ dimida꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Hena꞉ inino꞉ me olo꞉wo꞉lo꞉, kis mogago꞉wo꞉lo꞉ gilo꞉ amio꞉ fa꞉la꞉do alifa꞉ib. A꞉la꞉ta꞉ga꞉ ge i fo꞉s hena꞉ usamilo꞉ a꞉lab a꞉no꞉ ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ge nanogo꞉ halaido꞉ diakiyo꞉, ha꞉fa꞉fo꞉ ha꞉na꞉sa꞉ga꞉, ma꞉no꞉wo꞉ a꞉na dia꞉b. Ge nanogo꞉ a꞉la꞉dimida꞉i ha꞉na꞉la꞉ga꞉, gelo꞉ sowaba elema꞉ib ko꞉lo꞉, ge hena a꞉ma꞉la꞉ ha꞉na꞉ib. Mo꞉wo꞉ ge hen a꞉na a꞉la꞉ta꞉ga꞉ fa꞉la꞉do alifa꞉. Ge hena dimido꞉ ko꞉lo꞉ ge a꞉ma꞉la꞉ hen doma꞉ ha꞉na꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Kalu a꞉ma꞉yo꞉ inga a꞉no꞉ “If” wikilo꞉. Mo꞉wo꞉ ga we mela꞉no꞉lo꞉ a꞉lab kaluka꞉isale tambowa꞉ ini anowo꞉ e dowab. ");
INSERT INTO bco_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","A꞉la꞉ta꞉ga꞉ Gode Yawe eyo꞉ no꞉ do꞉go꞉fo꞉ dubia꞉sa꞉ga꞉, kalu o꞉lia꞉ inga o꞉lia꞉ya kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","A꞉la꞉ta꞉ga꞉ Gode Yawe eyo꞉ a꞉la꞉sio꞉, “Bo꞉ba! Kalu we i fo nowo꞉ na꞉sa꞉ga꞉yo꞉, e nafa o꞉lia꞉ mogago꞉ o꞉lia꞉ ele ba꞉ba꞉no꞉wo꞉ e asulo꞉ ko꞉lo꞉, e nio꞉ o꞉ngo꞉ dowo꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ mela꞉no꞉lo꞉ dimia꞉sen i fo a꞉no꞉lo꞉ tula꞉sa꞉ga꞉ na꞉lalega, e ko꞉ngo꞉ mela꞉no꞉ mela꞉ib ko꞉lo꞉, eyo꞉ fo a꞉no꞉ diabena꞉ki, niliyo꞉ ka꞉ma꞉niki.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","A꞉la꞉fo꞉ko꞉lo꞉ Gode Yawe eyo꞉ Ida꞉n egelo꞉ amilo꞉ elen a꞉no꞉ e ha꞉la꞉ya o꞉luga꞉fo꞉. Kalu a꞉no꞉ hena a꞉la꞉ta꞉ga꞉ fa꞉la꞉do alifa꞉ ko꞉lo꞉ e hen a꞉na nanogo꞉ dima꞉ki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","A꞉la꞉yo꞉ ha꞉la꞉ya o꞉luga꞉sa꞉ga꞉yo꞉, ofdo꞉ yan doba꞉da꞉lo꞉ tog egelo꞉ amilo꞉ ya꞉sen a꞉namio꞉, Godeya꞉ ene ma꞉mula꞉ kalu nolo꞉ ili wiyo꞉ ka꞉lub ko꞉lo꞉ a꞉na ta꞉felo꞉. A꞉la꞉ta꞉ga꞉ helebe sambo de wa꞉sowalo꞉ dowo꞉ a꞉no꞉ a꞉na mumagola꞉li sia꞉melea꞉ki ta꞉fo꞉. Ma꞉mula꞉ kalu o꞉lia꞉ helebe sambo o꞉lia꞉yo꞉ i mela꞉no꞉lo꞉ dimia꞉lab a꞉namilo꞉ ha꞉na꞉sen tog a꞉namio꞉ yabena꞉ki yasisen. ");
INSERT INTO bco_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Adamo꞉ inga If o꞉lia꞉ alila꞉len ko꞉lo꞉, If e so꞉wayo꞉ a꞉na alela꞉sa꞉ga꞉, kalu so꞉wa ko꞉lo꞉ sa꞉la꞉li. Ifa꞉yo꞉ towo꞉ a꞉la꞉sio꞉, “Yawe eyo꞉ ne asufa꞉ ko꞉lo꞉, niyo꞉ kalu so꞉wayo꞉ dio꞉l.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ so꞉wa a꞉no꞉ “Ka꞉in” wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tif amio꞉ If eyo꞉ Ka꞉ina꞉ aowo꞉ sa꞉la꞉lia꞉sa꞉ga꞉, “A꞉ibol” wikilo꞉. A꞉la꞉yo꞉ analia꞉sa꞉ga꞉yo꞉, A꞉ibol e sibilo꞉ bo꞉fo꞉mela꞉no꞉ kalu dowo꞉, a꞉la꞉ta꞉ga꞉ Ka꞉in e egela꞉mela꞉no꞉ kalu dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ho꞉len no amio꞉, Ka꞉in eyo꞉ egelo꞉ amio꞉ fowo꞉ dia꞉sa꞉ga꞉, hebo꞉ Yawemo꞉ boba dimi. ");
INSERT INTO bco_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","A꞉la꞉ta꞉ga꞉ A꞉ibol eyo꞉lo꞉ sibi inso꞉ wa꞉la꞉b imilig nowo꞉ noba꞉iya꞉sa꞉ga꞉, heb nafale safdo꞉ a꞉lab a꞉no꞉ Yawemo꞉ boba dimi. A꞉la꞉dimidabiki Yawe eyo꞉ A꞉ibol o꞉lia꞉ ene boba dimiab o꞉lia꞉mo꞉wo꞉ sagalo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Ko꞉sega Yawe eyo꞉ Ka꞉in o꞉lia꞉ ene boba dimiab o꞉lia꞉mo꞉wo꞉ mo꞉sagalo꞉. A꞉la꞉fo꞉ko꞉lo꞉ Ka꞉in e mada gadiakiyo꞉, ene wo꞉lokano꞉ hida꞉lia꞉ga꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","A꞉la꞉gabiki Yawe eyo꞉ Ka꞉inbo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge wangabi gadiaya? Ge wo꞉lokano꞉ hida꞉liab ko mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ge man nafa dimidalega, niyo꞉ gemo꞉wo꞉ o꞉li sagalema꞉no꞉. Ko꞉sega ge man nafayo꞉ mo꞉dimidalega, man mogago꞉ a꞉ma꞉yo꞉ ge golula꞉ma꞉niki toga yasisab. Mogago꞉ a꞉ma꞉yo꞉ ge bo꞉fo꞉mela꞉nigab ko꞉sega, giyo꞉ mogago꞉ a꞉no꞉ wa꞉la꞉ sa꞉ndaki tiginila꞉bi.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","A꞉la꞉ta꞉ga꞉ Ka꞉in eyo꞉ ene ao A꞉ibolbo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉no꞉ egelo꞉wa ho꞉no꞉ka꞉.” A꞉la꞉ta꞉ga꞉ a꞉la꞉yo꞉ egelo꞉wa ha꞉na꞉sa꞉ga꞉ ilikiyo꞉, Ka꞉in eyo꞉ ao o꞉lia꞉yo꞉ babuma꞉no꞉wo꞉ mo꞉mo꞉da꞉sa꞉ga꞉, ao A꞉ibolo꞉ a꞉na sana sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Tif amio꞉ Yawe eyo꞉ Ka꞉inbo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gao A꞉ibolo꞉ ha꞉?” A꞉la꞉dabu ba꞉dabiki, Ka꞉in eyo꞉, “Ne babalab. Ne naolo꞉ bo꞉fo꞉mela꞉no꞉ kalu dowo꞉ma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","A꞉la꞉ta꞉ga꞉ Yawe eyo꞉ Ka꞉inbo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ mogago꞉ dimido꞉wo꞉ mo꞉wo꞉ ha꞉? Gaowa꞉ ho꞉bo꞉ hen amilo꞉ tulo꞉ a꞉no꞉ ya꞉la꞉likiyo꞉, ho꞉bo꞉ a꞉ma꞉yo꞉ mogago꞉ gilo꞉ dimido꞉ a꞉no꞉ ko꞉lo꞉ ho꞉ida꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","12","A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ niyo꞉ gemo꞉ towo꞉ halaido꞉ dinali sa꞉ma꞉nigo꞉l. Dagi gilo꞉ma꞉yo꞉ gaowo꞉ sana sowaki, ho꞉bo꞉wo꞉ hen amio꞉ tulo꞉ ko꞉lo꞉, gilo꞉ dimido꞉ a꞉ma꞉yo꞉ o꞉go꞉ hena꞉yo꞉ ge mo꞉asuwa꞉ta꞉mela꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ eyo꞉ gelalikiyo꞉, hen a꞉ma꞉yo꞉ hendeyo꞉ nafaleyo꞉ mo꞉hele alifa꞉ib. Ge hendo꞉ma dowakiyo꞉, ge mageso꞉ kalu sia꞉mela꞉ib.” Yawe eyo꞉ a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Ka꞉ino꞉ Yawe elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, a꞉ma꞉la꞉ sa꞉laki, “Gilo꞉ falasilo꞉ nemo꞉lo꞉ dimiab we mada alan ko꞉lo꞉, ne o꞉lia꞉yo꞉ mo꞉lilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","O꞉go꞉ ne hen wilo꞉ doma꞉no꞉wo꞉lo꞉ a꞉la꞉ta꞉ga꞉ ge o꞉lia꞉lo꞉ doma꞉no꞉wo꞉, giyo꞉ ne o꞉lusa꞉ndab ko꞉lo꞉, giyo꞉ ne ba꞉ba꞉no꞉ asulo꞉wo꞉ mo꞉doma꞉ib. Ne heno꞉ aundo꞉ma dowakiyo꞉, mageso꞉ kalu o꞉ngo꞉ iliki henfelo꞉ we tambo sia꞉mela꞉no꞉. A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ne galilialega, ne sana soma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","A꞉la꞉sa꞉labiki Yawe eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “A꞉la꞉bo꞉ mo꞉auma꞉ib. Kalu noma꞉yo꞉ Ka꞉ino꞉ sa꞉ndalega, niyo꞉ kalu o꞉mo꞉wo꞉ wa꞉dia꞉lowo꞉wo꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ dimia꞉no꞉” Gode eyo꞉ a꞉la꞉saeta꞉ga꞉yo꞉, kalu noma꞉yo꞉ Ka꞉ino꞉ ba꞉da꞉sa꞉ga꞉ sanaetabena꞉kiyo꞉, ele ba꞉ba꞉no꞉ imilig nowo꞉ Ka꞉in eya difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","A꞉la꞉fo꞉ko꞉lo꞉ Ka꞉in e Yawe o꞉lia꞉lo꞉ dofo꞉leno꞉ ta꞉ta꞉sa꞉ga꞉, hen nowa doma꞉ni ane. Hen a꞉no꞉ ene wiyo꞉ Nod. Nod hen a꞉no꞉ Ida꞉n hen ofdo꞉ yan doba꞉da꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ka꞉ino꞉ inga o꞉lia꞉ alila꞉len ko꞉lo꞉, so꞉wayo꞉ a꞉na alela꞉sa꞉ga꞉, kalu so꞉wa ko꞉lo꞉ sa꞉la꞉li. Ene wiyo꞉ Inog. A꞉la꞉ta꞉ga꞉ eyo꞉ amisa꞉n nowo꞉ dimidakiyo꞉, ene inso꞉wa꞉ wi ko꞉ wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Inog eyo꞉ kalu so꞉wa sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Ilad wikilo꞉. A꞉la꞉ta꞉ga꞉ Ilada꞉ inso꞉wo꞉ Mehuyael. Mehuyaela꞉ inso꞉wo꞉ Ma꞉tusael. Ma꞉tusaela꞉ inso꞉wo꞉ Lameg. ");
INSERT INTO bco_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","A꞉la꞉ta꞉ga꞉ Lameg e gayo꞉ a꞉la꞉ di. Ga nowo꞉ Ada, nowo꞉ Sila. ");
INSERT INTO bco_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada eyo꞉ Yabal ko꞉lo꞉ sa꞉la꞉li. Helebeso꞉g aya ilikilo꞉ no꞉ fofan man a꞉no꞉ Yabal e ho꞉gi asulo꞉ ko꞉lo꞉ man a꞉no꞉ e mo꞉mo꞉do꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yabala꞉ ene aowa꞉ wiyo꞉ Yubal. Yubal e uluna sa꞉ndan o꞉lia꞉ folan o꞉lia꞉yo꞉ e asulo꞉ ko꞉lo꞉ man a꞉no꞉ e mo꞉mo꞉do꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","A꞉la꞉ta꞉ga꞉ Sila eyo꞉ kalu so꞉wa, Tubal Ka꞉in ko꞉lo꞉ sa꞉la꞉li. Tubal Ka꞉in e go꞉fo꞉ ki amilo꞉ kelego꞉ ko꞉li ko꞉lilo꞉lo꞉ dimidano꞉ e. Tubal Ka꞉ina꞉ ene adowa꞉ wiyo꞉ Nama. ");
INSERT INTO bco_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Lamega꞉ ene inga a꞉la꞉mo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, Ada o꞉lia꞉ Sila o꞉lia꞉ ga꞉go꞉ nilo꞉ to so꞉lo꞉l we dabuma. Ga꞉go꞉, ni to we tilida꞉da꞉sa꞉ga꞉ asulufo꞉lubi. Kalu noma꞉yo꞉ ne yamilabikiyo꞉, niyo꞉ e sana sowo꞉. Hendele kalu so꞉wa a꞉ma꞉yo꞉ ne sa꞉ndabikiyo꞉, niyo꞉ e sana sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kalu noma꞉yo꞉ Ka꞉ino꞉ ko꞉lo꞉ sana sowalega, kalu emo꞉wo꞉ falasila꞉lowo꞉wo꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ wa꞉dema꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ kalu noma꞉yo꞉ ne sana sowalega, kalu emo꞉wo꞉ falasila꞉lowo꞉wo꞉ do꞉la꞉fo꞉ dom a꞉la꞉ta꞉ga꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ wa꞉dema꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Tif amio꞉ Adama꞉ ene inga o꞉lia꞉ wa꞉ka alila꞉sa꞉ga꞉, kalu so꞉wa nowo꞉ sa꞉la꞉li. Eyo꞉ so꞉wa a꞉no꞉ Sa꞉d wikilo꞉. If eyo꞉ a꞉la꞉sio꞉, “Ka꞉in eyo꞉ A꞉ibolo꞉ sana sowo꞉ ko꞉lo꞉, A꞉ibol dowalu aumbo꞉, so꞉wa we Godeya꞉ nemo꞉ dimi.” ");
INSERT INTO bco_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","A꞉la꞉ta꞉ga꞉ Sa꞉d eyo꞉ kalu so꞉wa nowo꞉ sa꞉la꞉li ko꞉lo꞉ eyo꞉ Inos wikilo꞉. Ho꞉len a꞉namio꞉ kaluka꞉isaleyo꞉ Yaweya꞉ wiyo꞉ a꞉na mo꞉mo꞉da dulugu sa꞉laki wabulu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adama꞉ eso꞉lo꞉wa꞉ wi agelo꞉wo꞉ we. Gode eyo꞉ kaluka꞉isale dimidakiyo꞉, ene misido꞉ o꞉ngo꞉ dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Kalu o꞉lia꞉ ga o꞉lia꞉yo꞉ dimido꞉ ko꞉lo꞉, ho꞉len a꞉namio꞉ iyo꞉ “kaluka꞉isale” a꞉la꞉bo꞉ wikili alitakiyo꞉, iyo꞉ nafale mesea꞉kiyo꞉ towo꞉ dinali salifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam e donayo꞉ 130 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, kalu so꞉wa nowo꞉ a꞉na sa꞉la꞉li. So꞉wa a꞉no꞉ asulo꞉ o꞉lia꞉ misido꞉ o꞉lia꞉yo꞉ Adama꞉ enen o꞉ngo꞉ dowo꞉. A꞉la꞉ta꞉ga꞉ so꞉wa a꞉no꞉ Sa꞉d wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sa꞉do꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Adam e donayo꞉ 800 a꞉la꞉fo꞉wo꞉ o꞉siliki, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","A꞉la꞉fo꞉ko꞉lo꞉ Adam e donayo꞉ dikudu agelo꞉wo꞉ 930 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sa꞉d e donayo꞉ 105 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Inoso꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","A꞉la꞉ta꞉ga꞉ Inoso꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Sa꞉d e donayo꞉ 807 a꞉la꞉fo꞉ a꞉no꞉ o꞉siliki, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","A꞉la꞉fo꞉ko꞉lo꞉ Sa꞉d e donayo꞉ dikudu agelo꞉wo꞉ 912 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Inos e donayo꞉ 90 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Kenano꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","A꞉la꞉ta꞉ga꞉ Kenan sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Inos e donayo꞉ 815 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","A꞉la꞉fo꞉ko꞉lo꞉ Inos e donayo꞉ dikudu agelo꞉wo꞉ 905 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan e donayo꞉ 70 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Mahalalelo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","A꞉la꞉ta꞉ga꞉ Mahalalelo꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Kenan e donayo꞉ 840 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","A꞉la꞉fo꞉ko꞉lo꞉ Kenan e donayo꞉ dikudu agelo꞉wo꞉ 910 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel e donayo꞉ 65 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Yaledo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","A꞉la꞉ta꞉ga꞉ Yaledo꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Mahalalel e donayo꞉ 830 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","A꞉la꞉fo꞉ko꞉lo꞉ Mahalalel e donayo꞉ dikudu agelo꞉wo꞉ 895 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaled e donayo꞉ 162 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Inogo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","A꞉la꞉ta꞉ga꞉ Inogo꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Yaled e donayo꞉ 800 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","A꞉la꞉fo꞉ko꞉lo꞉ Yaled e donayo꞉ dikudu agelo꞉wo꞉ 962 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Inog e donayo꞉ 65 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Metuselayo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","A꞉la꞉ta꞉ga꞉ Metuselayo꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Inog e Gode o꞉lia꞉ ege dowaki, Godeya꞉lo꞉ asulab au kudu ha꞉na꞉leno꞉, donayo꞉ 300 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉ siliki a꞉namio꞉, kalu so꞉wayo꞉, ka꞉isale so꞉wayo꞉ nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","A꞉la꞉fo꞉ko꞉lo꞉ Inog e donayo꞉ dikudu agelo꞉wo꞉ 365 a꞉no꞉ ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Inog e Gode o꞉lia꞉ ege dowaki, Godeya꞉lo꞉ asulab au kudu ha꞉na꞉len ko꞉lo꞉, Gode eyo꞉ e tililia꞉ ha꞉nabiki, Inog e henfelo꞉ wiyo꞉ wa꞉kabiyo꞉ mo꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela e donayo꞉ 187 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Lamego꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","A꞉la꞉ta꞉ga꞉ Lamego꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Metusela e donayo꞉ 782 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉lo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","A꞉la꞉fo꞉ko꞉lo꞉ Metusela e donayo꞉ dikudu agelo꞉wo꞉ 969 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lameg e donayo꞉ 182 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, kalu so꞉wayo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lameg eyo꞉ a꞉la꞉sio꞉, “Gode Yawe eyo꞉ henfelo꞉ wemo꞉wo꞉ towo꞉ halaido꞉ sa꞉laki mogagila꞉ ko꞉lo꞉, niliyo꞉ ma꞉no꞉ dia꞉nikiyo꞉, odo꞉ sia꞉la꞉ga꞉ nanogo꞉ halaido꞉ dia꞉lo꞉l. A꞉la꞉fo꞉ ko꞉sega kalu so꞉wa wema꞉yo꞉ ha꞉fo꞉ doma꞉no꞉wo꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉doma꞉ib” A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa a꞉no꞉ “Noa” wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","A꞉la꞉ta꞉ga꞉ Noayo꞉ sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Lameg e donayo꞉ 595 a꞉la꞉fo꞉ o꞉siliki, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","A꞉la꞉fo꞉ko꞉lo꞉ Lameg e donayo꞉ dikudu agelo꞉wo꞉ 777 a꞉no꞉ ta꞉ta꞉ga꞉yo꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa e donayo꞉ 500 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, kalu so꞉wa otaleno꞉ sa꞉la꞉li. So꞉wa a꞉no꞉ wiyo꞉ Sa꞉m, nowo꞉ Ham, nowo꞉ Yafa꞉d. ");
INSERT INTO bco_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Tif amio꞉ kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉dowakiyo꞉, henfelo꞉ wenamio꞉ ililima꞉niki mo꞉mo꞉do꞉. A꞉la꞉ta꞉ga꞉ iliyo꞉ ka꞉isale so꞉wayo꞉lo꞉ sa꞉la꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ho꞉len a꞉namio꞉ Hebene sowa꞉ i nolo꞉ tinda꞉sa꞉ga꞉, henfelo꞉ gayo꞉ ba꞉da꞉sa꞉ga꞉, ga a꞉no꞉ gesego꞉ nafale ba꞉dabiki, inido꞉ asulab au dialifelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","A꞉la꞉gabiki Gode Yawe eyo꞉ towo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale i we henfelo꞉ a꞉ma꞉no꞉ ko꞉lo꞉, nilo꞉ i amilo꞉ mela꞉no꞉ mama ta꞉fo꞉ a꞉no꞉, i amio꞉ ho꞉leno꞉ tambowo꞉ mo꞉ta꞉fo꞉mela꞉no꞉. O꞉g wena mo꞉mo꞉dakiyo꞉, iyo꞉ donayo꞉ 120 a꞉la꞉fo꞉ a꞉nako꞉ mesa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","O꞉g ho꞉len wena a꞉la꞉ta꞉ga꞉ tif amio꞉lo꞉, Hebene so꞉wa i a꞉ma꞉yo꞉ henfelo꞉ gayo꞉ dialifelo꞉ ko꞉lo꞉, so꞉wayo꞉ a꞉na sa꞉la꞉la꞉. So꞉wa ililo꞉ sa꞉la꞉la꞉ i a꞉no꞉ Na꞉filim a꞉la꞉sa꞉lan a꞉la꞉ta꞉ga꞉ iyo꞉ halaido꞉ kilo꞉ di ko꞉lo꞉ wabulun kalu tamin amilo꞉ eleno꞉ i o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","6","Henfelo꞉ wenamio꞉ kaluka꞉isaleyo꞉ mogago꞉wo꞉ alan dimida꞉lab, a꞉la꞉ta꞉ga꞉ iyo꞉ ho꞉leno꞉ tambo mogago꞉ dimidama꞉no꞉ asulo꞉ a꞉no꞉ko꞉ ha꞉na꞉lab. Yawe eyo꞉ mogago꞉ dimida꞉len a꞉no꞉ alan ba꞉da꞉ga꞉, eyo꞉ a꞉la꞉asulo꞉, “Siya꞉, niyo꞉ kaluka꞉isaleyo꞉ mo꞉dimidaluwo꞉ go꞉.” A꞉la꞉asulakiyo꞉ e nofolo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Yawe eyo꞉ towo꞉ a꞉la꞉sio꞉, “Niyo꞉ kelego꞉wo꞉ tambo dimida꞉la꞉ga꞉ ta꞉fo꞉ ko꞉sega, ha꞉iyo꞉ niyo꞉ mo꞉dimido꞉ kibo꞉bowo꞉ o꞉li domabe. A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ kaluka꞉isaleyo꞉lo꞉, no꞉wo꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, o꞉ba꞉ iwalulo꞉ sano꞉lo꞉, henfelo꞉ amilo꞉ a꞉lab we tambo yasa danelaki dila꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Ko꞉sega Yawe e Noa ba꞉da꞉ga꞉yo꞉, sagalo꞉wo꞉ alan dowaki Noa e kanulo꞉ alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa elo꞉ dimido꞉ malolo꞉wo꞉ we. Godeya꞉ siwa꞉l amio꞉, Noa e mada digalo꞉ kalu ko꞉lo꞉, e Gode o꞉lia꞉ ege dowaki, Godeya꞉lo꞉ asulab au kudu ha꞉na꞉len. Gode eyo꞉ Noa o꞉lia꞉, kaluka꞉isale e o꞉lia꞉lo꞉ sen i a꞉no꞉ ba꞉ba꞉ amio꞉, halalo꞉ mo꞉dimida꞉sen kaluwo꞉ imilig, Noa eko꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noayo꞉ kalu so꞉wa otalen ko꞉lo꞉ sa꞉la꞉li. Nowo꞉ Sa꞉m, nowo꞉ Ham, nowo꞉ Yafa꞉d. ");
INSERT INTO bco_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Godeya꞉ siwa꞉l amio꞉, henfelo꞉ kaluka꞉isaleyo꞉ mogago꞉ dimida꞉mela꞉no꞉wo꞉ a꞉la꞉ta꞉ga꞉ babuma꞉no꞉wo꞉ alan fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Henfelo꞉ amio꞉ kaluka꞉isale iliyo꞉ man mogago꞉wo꞉ kudu ha꞉na꞉len ko꞉lo꞉, Gode eyo꞉ henfelo꞉ we mada mogago꞉le elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ Noamo꞉wo꞉ a꞉la꞉sio꞉, “Henfelo꞉ wenamio꞉ kaluka꞉isaleyo꞉ egelebo꞉ babuma꞉no꞉ man a꞉no꞉ ililitab ko꞉lo꞉, niyo꞉ a꞉no꞉ aloba꞉da꞉sa꞉ga꞉ kaluka꞉isaleyo꞉ kedela꞉ma꞉nigo꞉l a꞉la꞉asulakiyo꞉, niyo꞉ henfelo꞉wo꞉ mogagilaki, kaluka꞉isaleyo꞉ tambo yasa danela꞉ma꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Giyo꞉ i nafayo꞉ dia꞉ga꞉, ho꞉n ko꞉suwo꞉ a꞉ma꞉ dimida꞉bi. Ho꞉n ko꞉su usamio꞉ gala tandea꞉bi. A꞉la꞉ta꞉ga꞉ ho꞉no꞉ ko꞉su usamio꞉ tinabena꞉ki i maga꞉yo꞉ ha꞉la꞉ amio꞉lo꞉, us amio꞉lo꞉ mulula꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ho꞉n ko꞉su dimidakiyo꞉, giyo꞉ a꞉la꞉dimida꞉bi. Osolodo꞉ alu wa꞉la꞉la꞉likilo꞉ agelo꞉wo꞉ 300 a꞉la꞉fo꞉, a꞉la꞉ta꞉ga꞉ onolodo꞉ alu wa꞉la꞉ agelo꞉wo꞉ 50 a꞉la꞉fo꞉, a꞉la꞉ta꞉ga꞉ alolodo꞉ alu wa꞉la꞉ da꞉feyo꞉wo꞉ 30 a꞉la꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","A꞉la꞉ta꞉ga꞉ a ko꞉lo꞉ fofoloma꞉no꞉wo꞉ otalen ko꞉lo꞉ fofoda꞉bi, nowo꞉ ha꞉ga, nowo꞉ usa, nowo꞉ wa꞉la, a꞉la꞉dimida꞉bi. Ge afugakiyo꞉, o꞉fo꞉f bo꞉lo꞉ amio꞉ diga꞉dibo꞉ alula꞉so꞉bo. Fogo꞉ gulu alita꞉ga꞉ alula꞉bi. A꞉la꞉ta꞉ga꞉ togo꞉ imilise ko꞉lo꞉ ha꞉la꞉ya dimida꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","No꞉no꞉n niyo꞉ henfelo꞉ wenamio꞉ ho꞉n dia꞉ alano꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉, ho꞉n a꞉ma꞉yo꞉ ha꞉fo꞉lo꞉ sa꞉la꞉lab kelego꞉ tambo henfelo꞉ a꞉namilo꞉ sabo꞉lo꞉, iwalulo꞉ sabo꞉lo꞉ tambo yasala꞉ma꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ henfelo꞉ wenamilo꞉ mela꞉no꞉lo꞉ da꞉labo꞉ tambo soma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ko꞉sega a꞉la꞉bo꞉ gilo꞉ amio꞉ fa꞉la꞉dowabena꞉ki, niyo꞉ ge o꞉lia꞉ to ho꞉giyo꞉ dinali saeto꞉l. Go꞉no꞉no꞉ a꞉la꞉ta꞉ga꞉ ge so꞉wa otaleno꞉lo꞉, ge gayo꞉lo꞉, ga꞉su otaleno꞉lo꞉, gio꞉ tambo ho꞉n ko꞉su usa tina꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Henfelo꞉ amilo꞉ mela꞉no꞉lo꞉ a꞉lab a꞉no꞉ o꞉ta꞉i hamana꞉kiyo꞉, giyo꞉ a꞉la꞉, a꞉la꞉ a꞉la꞉bo꞉ tililia꞉ga꞉, ge o꞉lia꞉ ho꞉n ko꞉su us a꞉na tina꞉bi. O꞉ba꞉ ko꞉li ko꞉lilo꞉, no꞉ ko꞉li ko꞉lilo꞉, a꞉la꞉ta꞉ga꞉ no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nan ko꞉li ko꞉lilo꞉ a꞉no꞉ tambo, de o꞉lia꞉ mala o꞉lia꞉yo꞉ gi tililia꞉ tina꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","A꞉la꞉ta꞉ga꞉ ma꞉no꞉ ko꞉li ko꞉lilo꞉ gilo꞉ ma꞉no꞉wo꞉lo꞉, no꞉ ko꞉li ko꞉lilo꞉wa꞉lo ma꞉no꞉wo꞉lo꞉, tambo kegenelia꞉ga꞉ dia꞉ta꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","A꞉la꞉fo꞉ko꞉lo꞉ Godeya꞉lo꞉ emo꞉lo꞉ dimidama꞉kilo꞉ sio꞉ o꞉leaumbo꞉ Noa eyo꞉ tambo dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yawe eyo꞉ Noamo꞉wo꞉ a꞉la꞉sio꞉, “Ni siwa꞉l amio꞉, kaluka꞉isale o꞉g wenamilo꞉ sen us amio꞉, mada digalo꞉ kaluwo꞉ imilig ge fa꞉la꞉dowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ ho꞉n ko꞉su usamio꞉ ge o꞉lia꞉ ge so꞉lo꞉ a꞉no꞉ko꞉ tambo tina꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","3","No꞉ ko꞉li ko꞉lilo꞉ a꞉no꞉ henfelo꞉ wenamio꞉ sugusula꞉liki mo꞉danelima꞉ki, giyo꞉ a꞉la꞉ga꞉bi. O꞉ba꞉ o꞉lia꞉ no꞉ ko꞉li ko꞉lilo꞉, kaluwa꞉lo꞉ o꞉li nan i a꞉no꞉ tambo amio꞉, deyo꞉ doma꞉la꞉fo꞉, malayo꞉lo꞉ doma꞉la꞉fo꞉ a꞉no꞉ ge o꞉lia꞉ ko꞉su usa tililia꞉ tina꞉bi. A꞉la꞉ta꞉ga꞉ no꞉ kalumo꞉lo꞉ na꞉so꞉bo a꞉la꞉do꞉ saefa꞉ i a꞉no꞉ tambo amio꞉, deyo꞉ imilig, malayo꞉ imilig o꞉leau tililia꞉ tina꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Gilo꞉ a꞉la꞉do꞉ dimidama꞉no꞉wo꞉ mo꞉wo꞉ we. Ho꞉len dom a꞉la꞉fo꞉wo꞉ kedetalikiyo꞉, niyo꞉ ho꞉no꞉ henfelo꞉ amio꞉ tinda꞉melea꞉ki ta꞉fa꞉no꞉. A꞉la꞉ta꞉ga꞉ ho꞉leno꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in, nuluwo꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉namio꞉, ho꞉no꞉ tinda꞉mela꞉ib ko꞉lo꞉, nilo꞉ mela꞉no꞉lo꞉ dimido꞉ ta꞉fo꞉ a꞉no꞉ tambo yasa danelaki dila꞉ma꞉no꞉.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Noa e to a꞉no꞉ da꞉da꞉sa꞉ga꞉, Yawe elo꞉ to sio꞉ aumbo꞉ dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa e donayo꞉ 600 dowabiki, henfelo꞉ wenamio꞉ ho꞉no꞉ galusana mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ho꞉n galusanayab a꞉ma꞉yo꞉ iyo꞉ mo꞉kanda soma꞉kiyo꞉, Noayo꞉, ingayo꞉, inso꞉ otaleno꞉ a꞉la꞉ta꞉ga꞉ inso꞉wa꞉ inga otaleno꞉, iyo꞉ ho꞉n ko꞉su usa tiane. ");
INSERT INTO bco_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Noayo꞉ ho꞉n ko꞉suwa ha꞉nabikiyo꞉, no꞉ kaluwa꞉lo꞉ o꞉li nano꞉lo꞉, no꞉ kalumo꞉lo꞉ na꞉so꞉bo a꞉la꞉do꞉ saefa꞉ i a꞉no꞉lo꞉, o꞉ba꞉yo꞉lo꞉ a꞉la꞉ta꞉ga꞉ no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉ tambo, de o꞉lia꞉ mala o꞉lia꞉yo꞉ Noa o꞉lia꞉ a꞉la꞉, a꞉la꞉ ho꞉n ko꞉su usa tiane. Godeya꞉lo꞉ Noamo꞉lo꞉ sio꞉ au ka fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Iyo꞉ ho꞉n ko꞉su usa amilo꞉ seno꞉, ho꞉len dom a꞉la꞉fo꞉ kedetabiki, ho꞉no꞉ a꞉na galusana mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noa e donayo꞉ 600 a꞉la꞉fo꞉ dowabiki, eleyo꞉ andeb dowab amio꞉ ho꞉leno꞉ do꞉la꞉ta꞉ga꞉ doma꞉la꞉fo꞉ fa꞉la꞉dowabiki, ho꞉n hena꞉ ha꞉g amilo꞉ delen a꞉no꞉ togolia꞉ga꞉ fa꞉la꞉nda꞉b, a꞉la꞉ta꞉ga꞉ ho꞉n akin halomilo꞉ delen a꞉no꞉lo꞉ ololo togolia꞉ga꞉ tindaki a꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","A꞉la꞉ta꞉ga꞉ ho꞉no꞉ henfelo꞉ amilo꞉ tinda꞉leno꞉, ho꞉leno꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉la꞉ta꞉ga꞉ nuluwo꞉lo꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉nami tinda꞉len. ");
INSERT INTO bco_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ho꞉len ho꞉ndo꞉ mo꞉mo꞉da tindab a꞉naka, Noayo꞉, ingayo꞉lo꞉, inso꞉ otalen, Sa꞉m, Ham, Yafa꞉do꞉lo꞉, a꞉la꞉ta꞉ga꞉ inso꞉wa꞉ inga otaleno꞉lo꞉, iyo꞉ tambo ho꞉n ko꞉suwa tiane. ");
INSERT INTO bco_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","I o꞉lia꞉ no꞉ ko꞉li ko꞉lilo꞉, no꞉ fofan ko꞉li ko꞉lilo꞉wo꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nan ko꞉li ko꞉lilo꞉wo꞉lo꞉, o꞉ba꞉ ko꞉li ko꞉lilo꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ kelego꞉ a꞉fuldo꞉ dowo꞉ a꞉no꞉ tambo ho꞉n ko꞉suwa tiane. ");
INSERT INTO bco_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Ha꞉fo꞉lo꞉ sa꞉la꞉len kelego꞉ tambo a꞉no꞉ a꞉la꞉ a꞉la꞉ a꞉la꞉bo꞉ Noalo꞉wa ha꞉nakiyo꞉ ho꞉n ko꞉su usa tiane. ");
INSERT INTO bco_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Godeya꞉lo꞉ Noamo꞉lo꞉ saefa꞉ o꞉leaumbo꞉, mela꞉no꞉lo꞉ a꞉lab kelego꞉ a꞉namio꞉ de o꞉lia꞉ mala o꞉lia꞉ tiane. A꞉la꞉ta꞉ga꞉ tambo tina꞉la꞉ga꞉ edabikiyo꞉, Yawe eyo꞉ togo꞉ a꞉na ifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","A꞉la꞉dimida꞉sa꞉ga꞉ henfelo꞉ wenamio꞉ ho꞉no꞉ tindaki galu fa꞉la꞉nda꞉sa꞉ga꞉lo꞉ eleno꞉, ho꞉leno꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in dowo꞉ ko꞉lo꞉, ho꞉n ko꞉su a꞉no꞉ ho꞉na꞉yo꞉ ha꞉le ta꞉li dofo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","A꞉la꞉ta꞉ga꞉ ho꞉no꞉ modo꞉ galulia꞉ fa꞉la꞉ndakiyo꞉, ho꞉n ko꞉suwo꞉ ha꞉lelia꞉ga꞉ fa꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Hen misio꞉ toda꞉ ko꞉lo꞉ henfelo꞉ wilo꞉ da꞉lab a꞉no꞉ tambo go꞉lu hala꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tinini haletakiyo꞉, ho꞉n ko꞉lo꞉ a꞉galululia꞉ fa꞉laniyo꞉, alu wa꞉la꞉ da꞉feyo꞉wo꞉ do꞉la꞉ta꞉ga꞉ bila꞉fo꞉ ko꞉lo꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","22","A꞉la꞉go꞉ko꞉lo꞉ henfelo꞉ amilo꞉ dalale san kelego꞉ a꞉no꞉ tambo ho꞉na꞉ kanda sowo꞉. O꞉ba꞉yo꞉lo꞉, no꞉ fofano꞉lo꞉, no꞉ ilaboda꞉lo꞉ sano꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, a꞉la꞉ta꞉ga꞉ kaluka꞉isaleyo꞉ tambo a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ Gode eyo꞉ henfelo꞉ wenamilo꞉ mela꞉no꞉lo꞉ a꞉lab a꞉no꞉ tambo yasa danelaki dila꞉. Kaluka꞉isale o꞉lia꞉, no꞉ o꞉lia꞉, o꞉ba꞉ o꞉lia꞉ a꞉la꞉ta꞉ga꞉ no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nan a꞉no꞉ tambo henfelo꞉ wena yasa danela꞉. Mo꞉yasala꞉yo꞉ Noayo꞉, a꞉la꞉ta꞉ga꞉ e o꞉lia꞉lo꞉ ho꞉n ko꞉su usamilo꞉ sab a꞉no꞉ko꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Henfelo꞉ we ho꞉na꞉lo꞉ galusanafo꞉leno꞉, ho꞉leno꞉ 150 a꞉la꞉fo꞉ ko꞉lo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","A꞉la꞉dimido꞉ ko꞉sega, Gode eyo꞉ Noayo꞉ a꞉la꞉ta꞉ga꞉ no꞉ ilaboda꞉ sano꞉lo꞉, no꞉ fofano꞉lo꞉, ho꞉n ko꞉su usamilo꞉ e o꞉lia꞉lo꞉ sen a꞉no꞉ tambo o꞉asulo꞉ka꞉. A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ fa꞉fa꞉so꞉ henfelo꞉ amio꞉ fofa꞉sa꞉ melea꞉ki ta꞉fo꞉, ko꞉lo꞉ fa꞉fa꞉so꞉ folabikiyo꞉, ho꞉no꞉ a꞉ma꞉la꞉ mo꞉mo꞉da tugula꞉i tiane. ");
INSERT INTO bco_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ho꞉n hena꞉ ha꞉g amilo꞉ deleno꞉ togolia꞉ga꞉lo꞉ ya꞉len a꞉no꞉ kalitaki, a꞉la꞉ta꞉ga꞉ ho꞉n akin halomilo꞉ tinda꞉len a꞉no꞉lo꞉ kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","A꞉la꞉gabiki ho꞉no꞉ a꞉ma꞉la꞉ elo꞉ delena ha꞉nabikiyo꞉, ololo tugula꞉i tiane. Ho꞉no꞉ tugula꞉likilo꞉ ti ha꞉na꞉leno꞉, ho꞉leno꞉ 150 a꞉la꞉fo꞉ us a꞉namio꞉ ho꞉no꞉ tugula꞉li tiane. ");
INSERT INTO bco_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Ho꞉len a꞉no꞉ kedeta꞉ga꞉yo꞉ ele dom amio꞉, ho꞉len agelo꞉wo꞉ do꞉la꞉ta꞉ga꞉ dom amio꞉, ho꞉n ko꞉su a꞉no꞉ tinda꞉ga꞉, Alalat misio꞉wa ti ali. ");
INSERT INTO bco_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","A꞉la꞉ta꞉ga꞉ ho꞉no꞉ ele otaleno꞉ o꞉tugula꞉i tina꞉len ko꞉lo꞉, ele do a꞉na ho꞉len agel amio꞉ hen misio꞉ nolo꞉ kalaba fa꞉la꞉dowabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","A꞉la꞉ta꞉ga꞉ misio꞉wo꞉ ba꞉da꞉ga꞉lo꞉ yasiseno꞉, ho꞉len do꞉la꞉fo꞉ fa꞉la꞉da꞉ino꞉ ta꞉ta꞉ga꞉, Noa eyo꞉ ho꞉n ko꞉su amilo꞉ ho꞉ ko꞉lo꞉ tamin amilo꞉ gulu a꞉no꞉ koda꞉sa꞉ga꞉, salage nowo꞉ iliga꞉fo꞉. O꞉ba꞉ a꞉no꞉ ho꞉n ko꞉su amio꞉ a꞉ma꞉la꞉yo꞉ mo꞉yaki, ho꞉no꞉ semo꞉ suguli amio꞉ e iwalu ha꞉lelia꞉ sia꞉len. ");
INSERT INTO bco_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","A꞉la꞉ta꞉ga꞉ a꞉ma꞉ fa꞉s amio꞉, Noa eyo꞉ ho꞉no꞉ henfelo꞉ amio꞉ mada suguliya꞉le a꞉la꞉bo꞉ asuluma꞉ni, o꞉ba꞉ hiyo꞉ a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ko꞉sega henfelo꞉ wiyo꞉ ho꞉no꞉ o꞉delen ko꞉lo꞉, o꞉ba꞉ hi a꞉no꞉ elo꞉ mesa꞉no꞉wo꞉ mo꞉ba꞉dabiki, Noalo꞉wa a꞉ma꞉la꞉ yabiki, Noaya꞉ dagiyo꞉ tandola꞉sa꞉ga꞉, o꞉ba꞉ hiyo꞉ ta꞉ulia꞉ga꞉, ko꞉su usa a꞉ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","A꞉la꞉fo꞉ko꞉lo꞉ Noayo꞉ ho꞉len dom a꞉la꞉fo꞉wo꞉ o꞉yasisa꞉ga꞉, o꞉ba꞉ hi a꞉no꞉ wa꞉ka iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Ga꞉lowo꞉ o꞉ba꞉ hi a꞉no꞉ a꞉ma꞉la꞉ dalolia꞉ yakiyo꞉, o꞉lif i fo꞉s hondo꞉wo꞉ ma꞉lifo꞉ mio꞉ ko꞉lo꞉, Noa eyo꞉ ho꞉no꞉ henfelo꞉ amio꞉ sugulilo꞉b a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","A꞉la꞉ta꞉ga꞉ Noa e ho꞉leno꞉ doma꞉la꞉fo꞉ o꞉yasisa꞉ga꞉, o꞉ba꞉ hi a꞉no꞉ wa꞉ka iliga꞉fo꞉ ko꞉sega, o꞉ba꞉ a꞉no꞉ a꞉ma꞉la꞉bo꞉ wa꞉kabiyo꞉ mo꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noa e donayo꞉ 601 ta꞉ta꞉sa꞉ga꞉, ele agel a꞉na, ho꞉len agela꞉ dowabiki, henfelo꞉ amio꞉ ho꞉no꞉ suguli ko꞉lo꞉, Noa eyo꞉ ho꞉n ko꞉su wa꞉l amilo꞉ go꞉lo꞉wo꞉ hugula꞉sa꞉ga ba꞉ba꞉ amio꞉, ho꞉no꞉ hendele suguliya ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ele andeb amilo꞉ ho꞉len agelo꞉wo꞉ do꞉la꞉fo꞉ a꞉la꞉ a꞉la꞉ta꞉ga꞉ dom a꞉la꞉fo꞉ a꞉namio꞉ heno꞉ kalalilia꞉sa꞉ga꞉, halaido꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Gode eyo꞉ Noamo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉ ga o꞉lia꞉, ga꞉ so꞉wa otaleno꞉ a꞉la꞉ta꞉ga꞉ ingala꞉la꞉yo꞉, gio꞉ tambo ha꞉la꞉ya hamana. ");
INSERT INTO bco_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Mela꞉no꞉lo꞉ a꞉lab kelego꞉ ho꞉n ko꞉su amilo꞉ disa꞉ a꞉no꞉ tambo, o꞉ba꞉yo꞉lo꞉, no꞉ fofano꞉lo꞉, no꞉ ilaboda꞉ sano꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, ge o꞉lia꞉ a꞉ma꞉la꞉ ha꞉la꞉ya tililia꞉ga꞉ handaloma. A꞉la꞉do꞉ dimido꞉ a꞉ma꞉yo꞉, iyo꞉ henfelo꞉wa ha꞉na꞉sia꞉sa꞉ga꞉, inso꞉wo꞉ mo꞉lilo꞉ sugusula꞉i ha꞉naki, henfelo꞉ we ililila꞉ma꞉ki go꞉.” Godeya꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","A꞉la꞉sa꞉labiki Noayo꞉, ingayo꞉, inso꞉ otaleno꞉ a꞉la꞉ta꞉ga꞉ inso꞉wa꞉ ingala꞉la꞉yo꞉ ha꞉la꞉ya ua handalowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","A꞉la꞉ta꞉ga꞉ no꞉ henfelo꞉ amilo꞉ dalale san a꞉no꞉ tambo, no꞉ fofano꞉lo꞉, no꞉ ilaboda꞉ sano꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, o꞉ba꞉yo꞉lo꞉, tambo ho꞉n ko꞉suwa a꞉la꞉ta꞉ga꞉ inin misili alifelo꞉ a꞉no꞉ ua ele handalowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉, Noa eyo꞉ Yaweya꞉ ene wi duludaki boba so꞉kugulu mea꞉nikiyo꞉, uwo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉, imili alifa꞉. No꞉ o꞉lia꞉ o꞉ba꞉ o꞉lia꞉, kaluwa꞉lo꞉ o꞉li nan i a꞉no꞉ imilida꞉lo꞉wo꞉ dia꞉sa꞉ga꞉, u wa꞉l ami Yawemo꞉ so꞉kugulu me. ");
INSERT INTO bco_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","No꞉ mundo꞉ nafa ko꞉lo꞉ kugulu so꞉da꞉lab a꞉no꞉ Yawe eyo꞉ da꞉da꞉sa꞉ga꞉, ene asulo꞉ amio꞉ towo꞉ a꞉la꞉dinali sa꞉laki, “Ho꞉leno꞉ tambowo꞉ kaluka꞉isaleyo꞉ o꞉so꞉waya a꞉la꞉ta꞉ga꞉ ha꞉nakiyo꞉, asulo꞉ inido꞉ma꞉yo꞉ mogago꞉le dimida꞉mela꞉no꞉ asula꞉sen. Ko꞉sega kaluwa꞉lo꞉ mogago꞉ dimido꞉ a꞉no꞉ wa꞉deakiyo꞉, henfelo꞉ we wa꞉kabiyo꞉ mo꞉mogagila꞉ma꞉no꞉. A꞉la꞉ta꞉ga꞉ nilo꞉ o꞉gdo꞉ mela꞉no꞉lo꞉ a꞉labo꞉ tambo yasala꞉ aumbo꞉, wa꞉kabiyo꞉ mada mo꞉dimidama꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Henfelo꞉ we o꞉dofo꞉lalikiyo꞉, egema꞉no꞉ ho꞉leno꞉lo꞉, hende dia꞉no꞉ ho꞉leno꞉lo꞉ fa꞉la꞉dowa꞉mela꞉ib. Hido꞉ ho꞉leno꞉lo꞉, ofo꞉ ho꞉leno꞉lo꞉ fa꞉la꞉dowa꞉mela꞉ib. Ta꞉no꞉lo꞉, imowo꞉lo꞉, donayo꞉lo꞉ fa꞉la꞉dowa꞉mela꞉ib. Ho꞉lenowo꞉lo꞉, nuluwo꞉lo꞉ fa꞉la꞉dowa꞉mela꞉ib. Kelego꞉ a꞉no꞉ mo꞉edaki, fa꞉la꞉dowa꞉mela꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Gode eyo꞉ Noa o꞉lia꞉ inso꞉ otalen o꞉lia꞉yo꞉ nafale mesea꞉ki, towo꞉ imo꞉wo꞉ a꞉la꞉dinali sio꞉, “Giliyo꞉ so꞉wayo꞉ sa꞉la꞉la꞉i ha꞉nakiyo꞉, modo꞉ fa꞉la꞉dowaki, henfelo꞉ we tambo ilila꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","No꞉ ilaboda꞉lo꞉ a꞉lab ko꞉li ko꞉lilo꞉wo꞉lo꞉, o꞉ba꞉ iwalulo꞉ a꞉labo꞉lo꞉, no꞉ kelego꞉ galin hen amilo꞉ dalolia꞉ ha꞉nano꞉lo꞉, a꞉la꞉ta꞉ga꞉ ka꞉ ho꞉n amilo꞉ a꞉labo꞉lo꞉, tambowo꞉ ge ba꞉da꞉ga꞉yo꞉ tagi doma꞉ib ko꞉lo꞉, iyo꞉ gi halaido꞉ a꞉ma꞉ ha꞉ga doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Tamin amio꞉ i fo꞉s gemo꞉lo꞉ maiya꞉kilo꞉ dimi o꞉leaumbo꞉, o꞉go꞉ no꞉ henfelo꞉ amilo꞉ dalale san a꞉no꞉ tambo gi na꞉melea꞉ki ta꞉to꞉l. ");
INSERT INTO bco_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ko꞉sega ho꞉bo꞉ a꞉namio꞉ mela꞉no꞉wo꞉ a꞉lab ko꞉lo꞉, no꞉ ho꞉bo꞉lo꞉ a꞉lab a꞉no꞉ na꞉so꞉boka꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Noma꞉yo꞉ gio꞉ nowo꞉ ho꞉bo꞉wo꞉ tulaki sana sowalega, elo꞉ hala dimido꞉ amilo꞉ wa꞉l dia꞉ib a꞉no꞉ ni da꞉fema꞉no꞉. No꞉wa꞉le, kaluwa꞉le, ge sana sowalega, e wa꞉dema꞉no꞉wo꞉ ni da꞉fema꞉no꞉. Hendele, kaluka꞉isale abeyo꞉ kalu nowo꞉ ko꞉lo꞉ sana sowalega, wa꞉l elo꞉ dia꞉no꞉ a꞉no꞉ ni da꞉fema꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Kaluka꞉isaleyo꞉ Gode eyo꞉ inin misido꞉ dimido꞉. A꞉la꞉fo꞉ko꞉lo꞉ kalu abeyo꞉ kaluka꞉isale nowo꞉ ko꞉lo꞉ sana sowalega, kalu a꞉no꞉lo꞉ sanala꞉bi a꞉la꞉saeto꞉l. ");
INSERT INTO bco_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","A꞉la꞉ta꞉ga꞉ giliyo꞉ so꞉wayo꞉ sa꞉la꞉la꞉i ha꞉nakiyo꞉, modo꞉ fa꞉la꞉dowaki, henfelo꞉ we tambo ilila꞉bi.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Gode eyo꞉ Noa o꞉lia꞉ inso꞉ otalen o꞉lia꞉mo꞉wo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Dabuma! O꞉go꞉ niyo꞉ gi o꞉lia꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉no꞉ o꞉lia꞉mo꞉wo꞉, to nowo꞉ dinali saefa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","To a꞉no꞉ henfelo꞉ amilo꞉ mela꞉no꞉lo꞉ kelego꞉ gi o꞉lia꞉lo꞉ a꞉lab a꞉no꞉, o꞉ba꞉yo꞉lo꞉, no꞉ fofano꞉lo꞉, no꞉ ilaboda꞉lo꞉ sano꞉lo꞉ a꞉no꞉ tambo ho꞉n ko꞉su usa a꞉la꞉ta꞉ga꞉ ge o꞉lia꞉ handalowo꞉ ko꞉lo꞉, to saeto꞉l we uaya꞉no꞉ ko꞉lo꞉ saeto꞉l. ");
INSERT INTO bco_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Niyo꞉ to we gi o꞉lia꞉ saetakiyo꞉ a꞉la꞉so꞉lo꞉l. Niyo꞉ henfelo꞉ amio꞉ mela꞉no꞉lo꞉ a꞉lab a꞉no꞉ tambo ho꞉na꞉yo꞉ wa꞉kabiyo꞉ mo꞉yasa danela꞉ma꞉no꞉. A꞉la꞉ta꞉ga꞉ henfelo꞉ wiyo꞉ ho꞉no꞉ galusana yakiyo꞉, wa꞉kabiyo꞉ mo꞉mogagila꞉ma꞉ib.” Gode eyo꞉ a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","A꞉la꞉saeta꞉ga꞉yo꞉ Gode eyo꞉ wa꞉ka a꞉la꞉sio꞉, “To saefa꞉ a꞉no꞉ gi o꞉lia꞉, gililo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab o꞉lia꞉yo꞉lo꞉, a꞉la꞉ta꞉ga꞉ mela꞉no꞉lo꞉ a꞉lab kelego꞉ gi o꞉lia꞉lo꞉ a꞉lab a꞉no꞉lia꞉yo꞉lo꞉ tambo dinali saefa꞉ a꞉no꞉, o꞉go꞉lo꞉ tif amio꞉lo꞉ dowa꞉i ha꞉na꞉mela꞉ib ko꞉lo꞉ ele ba꞉da꞉mela꞉no꞉wo꞉ we. ");
INSERT INTO bco_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ne o꞉lia꞉ henfelo꞉ o꞉lia꞉yo꞉ towo꞉ saeto꞉l ko꞉lo꞉, gio꞉ ele ba꞉da꞉melea꞉kiyo꞉, niyo꞉ kola꞉ us amio꞉ sowa꞉silo꞉wo꞉ dia꞉to꞉l. ");
INSERT INTO bco_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Henfelo꞉ amio꞉ niyo꞉ kolo꞉ iliga꞉takiyo꞉, sowa꞉silo꞉wo꞉ kola꞉ us amio꞉ fa꞉la꞉dowalikiyo꞉, no꞉no꞉ndo꞉ gi o꞉lia꞉ a꞉la꞉ta꞉ga꞉ henfelo꞉ amilo꞉ mela꞉no꞉lo꞉ a꞉lab o꞉lia꞉mo꞉lo꞉ to dinali saefa꞉ a꞉no꞉ niyo꞉ asula꞉mela꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ henfelo꞉ wiyo꞉ ho꞉no꞉ galu sana yakiyo꞉, mela꞉no꞉lo꞉ a꞉lab a꞉no꞉ wa꞉kabiyo꞉ mo꞉yasa danela꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kol amio꞉ sowa꞉silo꞉wo꞉ ba꞉dakiyo꞉, no꞉no꞉ndo꞉ i o꞉lia꞉lo꞉ to dinali saefa꞉ a꞉no꞉ a꞉na a꞉asuluma꞉no꞉. To a꞉no꞉ ne o꞉lia꞉ henfelo꞉ amilo꞉ mela꞉no꞉wo꞉ a꞉lab o꞉lia꞉ tambo saefa꞉ ko꞉lo꞉ to a꞉no꞉ ko꞉ngo꞉ dowa꞉i ha꞉na꞉mela꞉ib.” Gode eyo꞉ a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ Noamo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ henfelo꞉ amilo꞉ mela꞉no꞉lo꞉ a꞉lab kelego꞉ o꞉lia꞉lo꞉ tambo to dinali saefa꞉ a꞉no꞉ ele ba꞉da꞉mela꞉no꞉wo꞉ o꞉m.” ");
INSERT INTO bco_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noaya꞉ ene inso꞉, e o꞉lia꞉lo꞉ ho꞉n ko꞉suwa a꞉la꞉ta꞉ga꞉lo꞉ handalowo꞉ a꞉no꞉ we, Sa꞉m, Ham, Yafa꞉d. Ham eyo꞉ Ka꞉ina꞉n ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isale henfelo꞉ amilo꞉ ta꞉i ha꞉nab we, tambo Noaya꞉ inso꞉ otalen a꞉na a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa e, elo꞉ gela꞉mela꞉no꞉ kalu dowo꞉. Eyo꞉ me fo nolo꞉ wain ho꞉n dimidama꞉niki, gela꞉la꞉ga꞉ bo꞉fo꞉len. A꞉la꞉do꞉ dimidama꞉no꞉wo꞉ e mo꞉mo꞉do꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tif amio꞉ Noa e wain ho꞉no꞉ na꞉la꞉ga꞉ no꞉nolaki, ene so꞉g a usa hagulabo alifo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","A꞉la꞉dimida꞉sa꞉ga꞉ elena, Ka꞉ina꞉na꞉ iya Hamo꞉ ya꞉sa꞉ga꞉, iyayo꞉ hagulabo alifo꞉leno꞉ ba꞉da꞉sa꞉ga꞉, ene ao a꞉la꞉mo꞉wo꞉ ha꞉la꞉ya sa꞉ma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ko꞉sega Sa꞉m o꞉lia꞉ Yafa꞉d o꞉lia꞉ma꞉yo꞉ helebeso꞉go꞉ fa꞉s doba꞉da꞉ go꞉lufo꞉ ha꞉na꞉ga꞉, iya ko꞉lo꞉ hagulabolo꞉ da꞉lab a꞉no꞉ helebeso꞉g a꞉ma꞉ go꞉lu alifa꞉. A꞉la꞉fo꞉ko꞉lo꞉ a꞉la꞉yo꞉ milifo꞉ iyalo꞉ doba꞉da꞉yo꞉ mo꞉ta꞉fo꞉ ko꞉lo꞉, iya hagulabolo꞉ da꞉lab a꞉no꞉ mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Noa e no꞉nolo꞉ alifo꞉len a꞉no꞉ a꞉sikaga ga꞉ta꞉ga꞉yo꞉, inso꞉ tifa꞉lo꞉ emo꞉lo꞉ dimido꞉ a꞉no꞉ asulakiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","“Hida꞉yo꞉ alano꞉ Ka꞉ina꞉n e dia꞉ib. E mada wilo꞉ma dowaki, ene ao iya꞉ madali nanog dian kalu doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","A꞉la꞉ta꞉ga꞉ Noa eyo꞉ to nowo꞉ a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Niyo꞉ Sa꞉ma꞉ Gode, Yawe emo꞉wo꞉ mada wabudaki so꞉lo꞉l. Ka꞉ina꞉n e Sa꞉ma꞉ ene nanog dia꞉no꞉ kalu doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Yafa꞉da꞉ eso꞉lo꞉wo꞉ modo꞉ doma꞉ki, niyo꞉ Godemo꞉ dulugu so꞉lo꞉l. Yafa꞉da꞉ eso꞉lo꞉ a꞉no꞉, Sa꞉ma꞉ eso꞉lo꞉ o꞉lia꞉yo꞉ nafale mesea꞉ki so꞉lo꞉l. A꞉la꞉ta꞉ga꞉ Ka꞉ina꞉n e Yafa꞉da꞉ madali nanog dia꞉no꞉ kalu doma꞉ki so꞉lo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","A꞉la꞉fo꞉ko꞉lo꞉ ho꞉na꞉lo꞉ galu sana mio꞉ a꞉na a꞉la꞉ta꞉ga꞉yo꞉, Noayo꞉ dona nolo꞉ 350 a꞉la꞉fo꞉ ko꞉lo꞉ gulula꞉. ");
INSERT INTO bco_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa e henfelo꞉ wenamilo꞉ seno꞉ donayo꞉ dikudu agelo꞉wo꞉ 950 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, e a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ho꞉no꞉ galusana ya꞉sa꞉ga꞉, tif amio꞉ Noaya꞉ inso꞉ otaleno꞉, Sa꞉m, Ham, Yafa꞉d, a꞉ma꞉lo꞉ so꞉wa sa꞉la꞉la꞉i aneyo꞉ we. ");
INSERT INTO bco_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Yafa꞉da꞉lo꞉ so꞉wa sa꞉la꞉la꞉yo꞉ wiyo꞉ we, Gomal, Magog, Madai, Yafan, Tubal, Mesa꞉g, Tilas. ");
INSERT INTO bco_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","A꞉la꞉ta꞉ga꞉ Gomaya꞉ inso꞉wo꞉ wiyo꞉ we, Askenas, Lifad, Togama. ");
INSERT INTO bco_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","A꞉la꞉ta꞉ga꞉ Yafana꞉ inso꞉wo꞉ wiyo꞉ we, Elisa, Tasis, Saibulu kalu o꞉lia꞉ Dodan kalu. ");
INSERT INTO bco_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yafa꞉da꞉ insiso꞉iyo꞉ so꞉lu ho꞉n doba꞉da꞉ hen ko꞉li ko꞉lilo꞉wa sa꞉i ane ko꞉lo꞉, ini so꞉lo꞉wo꞉ aloba꞉da꞉sa꞉ga꞉yo꞉, inin towo꞉lo꞉, ini mo꞉mio꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ inin heno꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Hama꞉ so꞉wa sa꞉la꞉la꞉yo꞉ wiyo꞉ we, Kus, Isib, Libia, Ka꞉ina꞉n. ");
INSERT INTO bco_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","A꞉la꞉ta꞉ga꞉ Kusa꞉ inso꞉wo꞉ wiyo꞉ we, Seba, Hafila, Sabada, Lama, Sabteka. A꞉la꞉ta꞉ga꞉ Lamaya꞉ inso꞉wo꞉ we, Seba o꞉lia꞉ Dedan. ");
INSERT INTO bco_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusa꞉yo꞉ so꞉wa nowo꞉ sa꞉la꞉li, ene wiyo꞉ Nimlod. Nimlod e henfelo꞉ wiyo꞉ wabulun kalu fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yawe ene siwa꞉l amio꞉ Nimlod e no꞉lo꞉ bulula꞉sen kalu halaido꞉ dowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ ho꞉len a꞉namio꞉ kaluka꞉isaleya꞉yo꞉ a꞉la꞉sa꞉laki, “Kalu wema꞉yo꞉, Nimlod elo꞉ no꞉ bululan aumbo꞉, eyo꞉lo꞉ halaido꞉ dimidab” a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimlod e halaido꞉ wabulun kalu fa꞉la꞉dowa꞉sa꞉ga꞉, hen alano꞉ bo꞉fo꞉likiyo꞉, amisa꞉n modo꞉ nolo꞉ a꞉na dia꞉i ane. Tamin amilo꞉ amisa꞉n elo꞉ dio꞉ we, Babilon, Elek, Akad a꞉la꞉ta꞉ga꞉ Kaina. Amisa꞉n a꞉no꞉ hen alan Sinal us a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Amisa꞉n a꞉no꞉ dia꞉sa꞉ga꞉yo꞉, Nimlod e Asilia hen a꞉namida꞉ ha꞉na꞉sa꞉ga꞉, amisa꞉n nolo꞉ a꞉na dimido꞉. Amisa꞉n a꞉no꞉ wiyo꞉ we, Ninifa, Lehobot, Kala a꞉la꞉ta꞉ga꞉ Lesen. Ninifa amisa꞉no꞉ nol a꞉la꞉ta꞉ga꞉ Kala amisa꞉no꞉ nol a꞉lo꞉ us a꞉na amisa꞉n alan Lesen a꞉no꞉ a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","A꞉la꞉ta꞉ga꞉ Isib e so꞉wa sa꞉la꞉lia꞉sa꞉ga꞉, inso꞉ a꞉ma꞉yo꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉wo꞉ we. Lud kaluka꞉isaleyo꞉lo꞉, Anam kaluka꞉isaleyo꞉lo꞉, Lehab kaluka꞉isaleyo꞉lo꞉, Natu kaluka꞉isaleyo꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Batalus kaluka꞉isaleyo꞉lo꞉, Kaslu kaluka꞉isaleyo꞉lo꞉, a꞉la꞉ta꞉ga꞉ Kilit kaluka꞉isaleyo꞉lo꞉. (Filistia kaluka꞉isale i a꞉ma꞉ ema꞉muwo꞉ Kilit kaluka꞉isale i o꞉m.) ");
INSERT INTO bco_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ka꞉ina꞉n elo꞉ so꞉wa ko꞉lo꞉ sa꞉la꞉la꞉yo꞉, wa꞉la꞉bo꞉ wiyo꞉ Saido꞉n, a꞉la꞉ta꞉ga꞉ so꞉wayo꞉ nowo꞉ Hit. ");
INSERT INTO bco_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","A꞉la꞉ta꞉ga꞉ Ka꞉ina꞉n e so꞉wa nolo꞉lo꞉ sa꞉la꞉la꞉la꞉ga꞉yo꞉, insiso꞉i a꞉ma꞉lo꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉wo꞉ we. Ya꞉bus kaluka꞉isaleyo꞉lo꞉, Amol kaluka꞉isaleyo꞉lo꞉, Giligas kaluka꞉isaleyo꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hifi kaluka꞉isaleyo꞉lo꞉, Alaga kaluka꞉isaleyo꞉lo꞉, Sini kaluka꞉isaleyo꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Alabad kaluka꞉isaleyo꞉lo꞉, Semal kaluka꞉isaleyo꞉lo꞉, a꞉la꞉ta꞉ga꞉ Hamad kaluka꞉isaleyo꞉lo꞉. So꞉lo꞉ ko꞉li ko꞉lilo꞉ a꞉na dowaki, wi tambowa꞉yo꞉ “Ka꞉ina꞉n kaluka꞉isale” a꞉la꞉wikilo꞉. Tif amio꞉ Ka꞉ina꞉n kaluka꞉isaleyo꞉ hen ko꞉li ko꞉lilo꞉ kandaya꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Ka꞉ina꞉n hen o꞉lia꞉ eleyo꞉ aneyo꞉, Saido꞉n a꞉la꞉ta꞉ga꞉ ololo ha꞉nakiyo꞉, Gela doba꞉da꞉yo꞉ Gasa amisa꞉n a꞉na edo꞉. A꞉la꞉ta꞉ga꞉ andolob eda꞉i ha꞉nakiyo꞉ Sodomo꞉lo꞉, Gomolayo꞉lo꞉, Admayo꞉lo꞉, Seboiyo꞉lo꞉ amisa꞉n a꞉no꞉ tambo Ka꞉ina꞉n hen usa ta꞉laki, Lasa amisa꞉n a꞉na o꞉go꞉so꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hama꞉ ene ema꞉mu ima꞉ so꞉lo꞉wo꞉ o꞉m. So꞉lo꞉ a꞉no꞉ inin towo꞉lo꞉, ini mo꞉mio꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ inin heno꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉ iyo꞉ a꞉la꞉ mesea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","A꞉la꞉ta꞉ga꞉ Yafa꞉da꞉ ao wa꞉la꞉b Sa꞉m, eyo꞉lo꞉ so꞉wayo꞉ sa꞉la꞉la꞉. Ebela꞉ inso꞉wa꞉yo꞉ Sa꞉mo꞉ ema꞉mu. ");
INSERT INTO bco_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","A꞉la꞉ta꞉ga꞉ Sa꞉m elo꞉ so꞉wa sa꞉la꞉la꞉yo꞉ wiyo꞉ we, Elam, Asul, Alabasad, Lud, a꞉la꞉ta꞉ga꞉ Alam. ");
INSERT INTO bco_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Alam elo꞉ so꞉wa sa꞉la꞉la꞉yo꞉ wiyo꞉ we, Us, Hul, Gedel, a꞉la꞉ta꞉ga꞉ Mas. ");
INSERT INTO bco_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Alabasad eyo꞉ Sela sa꞉la꞉li ko꞉lo꞉, Sela eyo꞉ Ebel sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","A꞉la꞉ta꞉ga꞉ Ebel eyo꞉ so꞉wayo꞉ a꞉la꞉ sa꞉la꞉lia꞉sa꞉ga꞉, so꞉wayo꞉ nowo꞉ Beleg wikilo꞉, mo꞉wo꞉, Beleg elo꞉ elen ho꞉len a꞉namio꞉ henfelo꞉ we a꞉na alobo꞉no꞉. A꞉la꞉ta꞉ga꞉ Belega꞉ ao, ene wiyo꞉ Yokdan. ");
INSERT INTO bco_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yokdan elo꞉ so꞉wa sa꞉la꞉la꞉yo꞉ wiyo꞉ we, Amodad, Seleb, Hasamafed, Yela, ");
INSERT INTO bco_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadolam, Usal, Digala, ");
INSERT INTO bco_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimel, Seba, ");
INSERT INTO bco_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofil, Hafila, a꞉la꞉ta꞉ga꞉ Yobab. Kalu i we tambo Yokdana꞉ sa꞉la꞉la꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kalu i wema꞉lo꞉ ta꞉i ha꞉nakilo꞉ hen ko꞉lo꞉ di a꞉no꞉ we. Mesa amisa꞉na a꞉la꞉ta꞉ga꞉ ta꞉i ha꞉nakiyo꞉, Sefal amisa꞉n, hen misio꞉lo꞉ dosdo꞉ ofdo꞉ yan doba꞉da꞉ a꞉na ta꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sa꞉ma꞉ ene ema꞉mu ima꞉ so꞉lo꞉wo꞉ o꞉m. So꞉lo꞉ a꞉no꞉ inin towo꞉lo꞉, ini mo꞉mio꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ inin heno꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉ iyo꞉ a꞉la꞉ mesea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Noaya꞉ ene ema꞉mu ima꞉ so꞉lo꞉ aneyo꞉ o꞉m. Ho꞉no꞉ galusana ya꞉sa꞉ga꞉ dowabikiyo꞉, kaluka꞉isale i we henfelo꞉ we tambo amio꞉ ta꞉i ha꞉nakiyo꞉, amisa꞉n ko꞉li ko꞉lilo꞉wo꞉ a꞉na fa꞉la꞉do alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Tamin amio꞉ henfelo꞉ kaluka꞉isale tambo towo꞉ imilise elen. ");
INSERT INTO bco_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Kaluka꞉isaleyo꞉ ofdo꞉ yan doba꞉da꞉ ta꞉i ha꞉na꞉sa꞉ga꞉, hen fua꞉lo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉, a꞉na asifo꞉. Hen a꞉ma꞉ wiyo꞉ Sinal. ");
INSERT INTO bco_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Iyo꞉ a꞉na silikiyo꞉, egele nenelakiyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ ko꞉fo꞉ tamo dola꞉sa꞉sa꞉ga꞉, halaido꞉ fa꞉la꞉doma꞉ki, deya so꞉fa꞉niki” a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ ayo꞉ uwa꞉yo꞉ mo꞉dia꞉no꞉ dowabiyo꞉, ko꞉fa꞉yo꞉ ayo꞉ a꞉na dimido꞉. A꞉la꞉ta꞉ga꞉ ko꞉f so꞉fa꞉ a꞉no꞉ kuduma꞉kiyo꞉, oga꞉dan kelego꞉ nowo꞉ di. ");
INSERT INTO bco_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Iliyo꞉ a꞉la꞉sio꞉, “Nini amisa꞉no꞉ dimidama꞉niki. Us a꞉namio꞉, a alan badio꞉ nowo꞉, walala꞉li dia꞉i fa꞉la꞉ ha꞉na꞉la꞉ga꞉ akina fa꞉la꞉doma꞉niki. Henfelo꞉ amio꞉ hen ko꞉li ko꞉lilo꞉ amio꞉ dalale ha꞉nabena꞉ki, nio꞉ wabulun wilo꞉ mesa꞉niki, niliyo꞉ nanogo꞉ a꞉la꞉dimidama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Gode Yawe eyo꞉ henfelo꞉ kaluka꞉isaleya꞉lo꞉ amisa꞉n o꞉lia꞉ a alan badio꞉ o꞉lia꞉ diab a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉ni mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Yawe eyo꞉ ba꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Amayo꞉, kaluka꞉isale wema꞉yo꞉ so꞉lo꞉wo꞉ imilise a꞉la꞉ta꞉ga꞉ towo꞉ imilise dowab. A꞉la꞉ta꞉ga꞉ ililo꞉ nanogo꞉ dimidab we, mo꞉mo꞉da꞉sa꞉ga꞉yo꞉ semo꞉ kedefo꞉ ko꞉lo꞉, tif amio꞉ inido꞉ dimidama꞉no꞉ saetab a꞉no꞉ tambo dimida꞉i ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","A꞉la꞉gabo꞉lo꞉biki, nio꞉ tina꞉sa꞉ga꞉yo꞉, egeledo꞉ to sa꞉lab a꞉no꞉ babale doma꞉ki, ililo꞉ to sa꞉lab a꞉no꞉ niliyo꞉ to ko꞉li ko꞉lilo꞉ dia꞉fa꞉no꞉.” Yawe eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ Yawe eyo꞉ iyo꞉ alobandakiyo꞉, henfelo꞉ amio꞉ hen ko꞉li ko꞉lilo꞉wa hamana꞉ki iliga꞉fo꞉ ko꞉lo꞉, amisa꞉n ilido꞉ dimida꞉len a꞉no꞉ ka ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","A꞉la꞉fo꞉ko꞉lo꞉ amisa꞉n a꞉no꞉ “Babel” a꞉la꞉wikilo꞉. A꞉la꞉do꞉ sio꞉wo꞉ mo꞉wo꞉ we. Amisa꞉n a꞉namio꞉ Yawe eyo꞉ kaluka꞉isaleya꞉ towo꞉ babale alifa꞉. Hen a꞉na a꞉la꞉ta꞉ga꞉yo꞉, Yawe eyo꞉ kaluka꞉isaleyo꞉ henfelo꞉ amilo꞉ hen ko꞉li ko꞉lilo꞉wa ta꞉i hamana꞉ki iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sa꞉ma꞉ eso꞉lo꞉wa꞉ wi agelo꞉wo꞉ we. Ho꞉n galusana mio꞉wo꞉ dona a꞉la꞉yo꞉ ta꞉ta꞉ga꞉yo꞉, Sa꞉m e donayo꞉ 100 fa꞉la꞉dowabiki, Alabasad e a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","A꞉la꞉ta꞉ga꞉ Alabasad e sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Sa꞉m e donayo꞉ 500 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Alabasad e donayo꞉ 35 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Sa꞉la a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","A꞉la꞉ta꞉ga꞉ Sa꞉la sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Alabasad e donayo꞉ 403 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sa꞉la e donayo꞉ 30 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Ebel a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","A꞉la꞉ta꞉ga꞉ Ebel sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Sa꞉la e donayo꞉ 403 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebel e donayo꞉ 34 a꞉la꞉fo꞉ ta꞉ta꞉ga꞉, Beleg a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","A꞉la꞉ta꞉ga꞉ Beleg sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Ebel e donayo꞉ 430 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Beleg e donayo꞉ 30 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Leu a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","A꞉la꞉ta꞉ga꞉ Leu sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Beleg e donayo꞉ 209 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Leu e donayo꞉ 32 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Selug a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","A꞉la꞉ta꞉ga꞉ Selug sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Leu e donayo꞉ 207 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Selug e donayo꞉ 30 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Nahol a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","A꞉la꞉ta꞉ga꞉ Nahol sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Selug e donayo꞉ 200 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Nahol e donayo꞉ 29 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Tela a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","A꞉la꞉ta꞉ga꞉ Tela sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Nahol e donayo꞉ 119 a꞉la꞉fo꞉ a꞉no꞉ o꞉silikiyo꞉, kalu so꞉wa, ka꞉isale so꞉wa nolo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tela e donayo꞉ 70 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, kalu so꞉wa otaleno꞉ sa꞉la꞉li. So꞉wa a꞉no꞉ wiyo꞉ Ablam, nowo꞉ Nahol, nowo꞉ Halan. ");
INSERT INTO bco_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","A꞉la꞉ta꞉ga꞉ Telaya꞉ eso꞉lo꞉wa꞉ wi agelo꞉wo꞉ we. Tela eyo꞉ so꞉wayo꞉ otalen ko꞉lo꞉ sa꞉la꞉li, Ablam, Nahol, Halan. Halan eyo꞉ Lod ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Telayo꞉ o꞉sabikiyo꞉, inso꞉ Halan a꞉no꞉ ene hen Ul amisa꞉n, Kaldia hen a꞉na sen ami sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ablam o꞉lia꞉ Nahol o꞉lia꞉yo꞉ gayo꞉ di. Ablam eyo꞉ Sa꞉lai di. Nahol eyo꞉ Milka di. Milka o꞉lia꞉ Iska o꞉lia꞉yo꞉ Halana꞉ ida꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","A꞉la꞉fo꞉ko꞉lo꞉ Sa꞉lai e fain dowaki, so꞉wayo꞉ mo꞉sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Tela eyo꞉ eso꞉lo꞉wo꞉ hen nowa tililia꞉gane. Telayo꞉, ene so꞉wa Ablamo꞉, e ma꞉mu Lod, Halana꞉ inso꞉wo꞉, ena꞉su Sa꞉lai, Ablama꞉ ingayo꞉, egele Ul Kaldia hen a꞉no꞉ ka ta꞉ta꞉ga꞉, Ka꞉ina꞉n hena hamana꞉ki tililia꞉gane. Ko꞉sega iyo꞉ ha꞉na꞉ga꞉yo꞉, Ka꞉ina꞉n amio꞉ mo꞉tigini fa꞉la꞉dowo꞉ ko꞉lo꞉, iyo꞉ Halan amisa꞉n a꞉na fa꞉la꞉dota꞉ga꞉ asifo꞉. ");
INSERT INTO bco_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tela e donayo꞉ 205 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, Tela e Halan amisa꞉n a꞉naka siliki sowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yawe eyo꞉ Ablam emo꞉wo꞉ a꞉la꞉sio꞉, “Ge go꞉no꞉n hen o꞉lia꞉, go꞉no꞉n mo꞉mio꞉ o꞉lia꞉, go꞉no꞉n so꞉lo꞉ o꞉lia꞉yo꞉ ta꞉taki, hen ko꞉li nilo꞉ gemo꞉lo꞉ walama꞉nigo꞉l a꞉na mesa꞉ni hamana. ");
INSERT INTO bco_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Niyo꞉ geya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉ gilo꞉ amio꞉ kaluka꞉isaleyo꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉. A꞉la꞉ta꞉ga꞉ ge nafale mesea꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉ ge wabulun doma꞉ib. Giyo꞉ kalu nolo꞉ dinafa ta꞉i hamana꞉kiyo꞉, halaido꞉wo꞉ dimia꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kalu abeyo꞉ ge nafale mesea꞉kilo꞉ sa꞉lab i a꞉no꞉ niyo꞉ iyo꞉ nafale mesea꞉ki ta꞉fa꞉no꞉. A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ge wa꞉la꞉ sa꞉ndakilo꞉ sa꞉lab i a꞉no꞉, niyo꞉ iyo꞉ mogagila꞉ma꞉ki ta꞉fa꞉no꞉. Henfelo꞉ amilo꞉ so꞉lo꞉ sab a꞉no꞉ tambo geya a꞉la꞉ta꞉ga꞉yo꞉ nafale mesea꞉ki ta꞉fa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Ablam e donayo꞉ 75 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, Yawe elo꞉ emo꞉lo꞉ sa꞉lab au dimidaki, e Halan amisa꞉no꞉ ta꞉ta꞉sa꞉ga꞉ ane. A꞉la꞉ta꞉ga꞉ Lodo꞉lo꞉ e o꞉lia꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ablam e, ene inga Selaiyo꞉ a꞉la꞉ta꞉ga꞉ aowa꞉ inso꞉ Lodo꞉lo꞉, ili nanogdo꞉ dia꞉sen kaluka꞉isale Halando꞉ di a꞉no꞉lo꞉ tililiaki, a꞉la꞉ta꞉ga꞉ ili kelego꞉wo꞉ tambo dia꞉ha꞉na꞉ga꞉, Ka꞉ina꞉n hen a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Iyo꞉ Ka꞉ina꞉n hen us a꞉na ha꞉na꞉la꞉ga꞉, i alan amilo꞉ wabulu sa꞉la꞉sendo꞉ a꞉lab a꞉na fa꞉la꞉dowo꞉. I a꞉no꞉ Sekem amisa꞉n aniba, Mola hen a꞉na a꞉lab. Ho꞉len a꞉namio꞉ Ka꞉ina꞉n kaluka꞉isaleyo꞉ Ka꞉ina꞉n hen a꞉namio꞉ o꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yawe e Ablam elo꞉wa fa꞉la꞉dowaki a꞉la꞉sio꞉, “Niyo꞉ hen we tambo ge ma꞉muimo꞉ dimia꞉no꞉” a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ Ablam eyo꞉ Yawe elo꞉ amilo꞉ fa꞉la꞉dowab o꞉mo꞉ dulugu sa꞉laki boba so꞉kugulu mea꞉nikiyo꞉, eyo꞉ uwo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉, imili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","A꞉ma꞉ fa꞉s amio꞉, Ablam e Sekemo꞉ ta꞉ta꞉ga꞉, Ka꞉ina꞉n hen us a꞉na ha꞉na꞉ga꞉ ha꞉nakiyo꞉, hen misio꞉lo꞉ doba꞉da꞉ ha꞉na꞉ni ane. Betel amisa꞉no꞉ ofdo꞉ tinan doba꞉da꞉ ta꞉fo꞉ a꞉la꞉ta꞉ga꞉ Ai amisa꞉no꞉ ofdo꞉ yan doba꞉da꞉ ta꞉ta꞉b, a꞉la꞉ta꞉ga꞉ us a꞉na fa꞉la꞉dowakiyo꞉, eyo꞉ helebeso꞉g ayo꞉ dia꞉sa꞉ga꞉ a꞉na sen. A꞉na silikiyo꞉ eyo꞉ uwo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉ imili alitakiyo꞉, Yawe ene wiyo꞉ alan a꞉la꞉wabudaki, a꞉na dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","A꞉ma꞉ fa꞉s amio꞉ Ablam e hen a꞉no꞉ ta꞉ta꞉ga꞉, hena꞉ usa alila꞉li ha꞉nakiyo꞉, Negeb hen a꞉na ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ho꞉len a꞉namio꞉ hen Ablam elo꞉ sen amio꞉, ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉ma dowaki, maiyo꞉wo꞉ alan dowo꞉ ko꞉lo꞉, Ablam e Isib hen a꞉na o꞉mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Isibo꞉ fa꞉la꞉doma꞉nikiyo꞉, Ablam eyo꞉ inga Selaimo꞉wo꞉ a꞉la꞉sio꞉, “Ge gayo꞉ gesego꞉ bo꞉do꞉l ko꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Isib kaluwa꞉yo꞉ ge ba꞉dakiyo꞉, iliyo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Ga we ene ingalo꞉b’ a꞉la꞉asulakiyo꞉, ne sana sowaki, ge o꞉mesea꞉ki ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ ne mo꞉sana soma꞉kiyo꞉, giyo꞉ ne ‘na꞉ naoka꞉’ a꞉la꞉sa꞉la꞉bi. Giyo꞉ a꞉la꞉sa꞉lalega, iliyo꞉ ge ko꞉lo꞉ asulakiyo꞉, ne dinafa tili dowaki, o꞉mesea꞉ki ta꞉fa꞉ib.” Ablam eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","A꞉la꞉saeta꞉ga꞉yo꞉ Ablam e Isib a꞉na fa꞉la꞉dowabikiyo꞉, Isib kaluwa꞉yo꞉ ga a꞉no꞉ mada gesego꞉ ko꞉lo꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Isib misa꞉ kalu, Fa꞉lo꞉wa꞉, ene nanogdo꞉ dian kaluwa꞉yo꞉ ga a꞉no꞉ ba꞉da꞉sa꞉ga꞉, Fa꞉lo꞉mo꞉wo꞉ “Ga gesego꞉wo꞉ ya꞉sa꞉ga꞉ sab” a꞉la꞉sio꞉ ko꞉lo꞉, ga a꞉no꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉ Fa꞉lo꞉wa꞉ aya ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","A꞉la꞉fo꞉ko꞉lo꞉ Fa꞉lo꞉ eyo꞉ ga a꞉no꞉ Ablama꞉ ado a꞉la꞉asulaki, Ablam e sagalema꞉kiyo꞉, kelego꞉ modo꞉wo꞉ emo꞉ dimi. Sibiyo꞉lo꞉, kaowo꞉lo꞉, donkiyo꞉lo꞉, donki malayo꞉lo꞉, ka꞉molo꞉lo꞉, nanogdo꞉ dian kaluka꞉isaleyo꞉lo꞉, Ablam emo꞉ tambo dimi. ");
INSERT INTO bco_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","A꞉la꞉fo꞉ ko꞉sega Fa꞉lo꞉ elo꞉ Ablama꞉ inga, Sa꞉lai, diab a꞉ma꞉ ilikiyo꞉, Yawe eyo꞉ hida꞉yo꞉ ko꞉li ko꞉lilo꞉wo꞉ Fa꞉lo꞉ o꞉lia꞉ kaluka꞉isale ene ayamilo꞉ sab ilo꞉wa iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","A꞉la꞉gabiki Fa꞉lo꞉ eyo꞉ Ablamo꞉ ho꞉ida꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Giyo꞉ nemo꞉lo꞉ dimido꞉ we waga dimidaya? Giyo꞉ ga꞉ gaka꞉ a꞉la꞉bo꞉ tamin amio꞉ nemo꞉wo꞉ mo꞉sio꞉wo꞉, mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ga a꞉no꞉ nemo꞉ dima꞉kiyo꞉, giyo꞉ Selaiyo꞉ ‘Na꞉ nadoka꞉’ a꞉la꞉do꞉ sio꞉wo꞉, waga asulaki sio꞉wo꞉? A꞉la꞉fo꞉ko꞉lo꞉ go꞉no꞉n gayo꞉ we ko꞉lo꞉ tililia꞉ga꞉ hamana.” Fa꞉lo꞉ eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","A꞉la꞉gabiki Fa꞉lo꞉ eyo꞉ kalu nolbo꞉wo꞉ towo꞉ sio꞉ ko꞉lo꞉, iliyo꞉ Ablamo꞉, inga o꞉lia꞉, ene kelego꞉wo꞉ tambo dia꞉ga꞉ hamana꞉kiyo꞉, halaido꞉ dibodaki sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Ho꞉len a꞉namio꞉ Ablam eyo꞉ silba mole o꞉lia꞉, go꞉l o꞉lia꞉, a꞉la꞉ta꞉ga꞉ no꞉ fofo꞉wo꞉lo꞉ modo꞉ elen. Ablam e Isib heno꞉ ta꞉ta꞉ga꞉ ha꞉nakiyo꞉, ene ingayo꞉lo꞉, Lodo꞉lo꞉, a꞉la꞉ta꞉ga꞉ ene kelego꞉ tambo tililia꞉ga꞉, Negeb hen a꞉namida꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","A꞉la꞉ta꞉ga꞉ iyo꞉ Negebo꞉ ta꞉ta꞉ga꞉ ha꞉nakiyo꞉, hena꞉ usa alila꞉li aneyo꞉, Betel hen a꞉na fa꞉la꞉dowo꞉. Betel amisa꞉no꞉ nol, Ai amisa꞉no꞉ nol, a꞉lo꞉ us a꞉na, tamin amilo꞉ elo꞉ sen a꞉na fa꞉la꞉dota꞉ga꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Hen a꞉no꞉ tamin amilo꞉ elo꞉ ulo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉ imili alitakilo꞉ Yawe ene wilo꞉ dulugu sio꞉wo꞉ o꞉m ko꞉lo꞉, Ablam eyo꞉ Yawe ene wiyo꞉ hen a꞉naka wa꞉ka dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ho꞉len a꞉namio꞉ Lod e Ablam o꞉lia꞉ sia꞉len. Lod eyo꞉lo꞉ kaluka꞉isale ene ayamilo꞉ sen a꞉no꞉ modo꞉ fa꞉la꞉dowaki, sibi o꞉lia꞉ kao o꞉lia꞉yo꞉ modo꞉ fofo꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ko꞉sega a꞉la꞉yo꞉ ua silikiyo꞉, no꞉ fofo꞉wo꞉ modo꞉ ko꞉lo꞉, hen a꞉namilo꞉ fugus o꞉lia꞉ ho꞉n ma꞉no꞉ o꞉lia꞉yo꞉ mo꞉lilo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","A꞉la꞉fo꞉ko꞉lo꞉ Ablama꞉ ene nanog dian kalu i o꞉lia꞉ Loda꞉ ene nanog dian kalu i o꞉lia꞉yo꞉ gadiaki kego꞉. A꞉la꞉ta꞉ga꞉ ho꞉len a꞉namio꞉ Ka꞉ina꞉n kaluka꞉isale o꞉lia꞉ Beles kaluka꞉isale o꞉lia꞉yo꞉ hen a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","A꞉la꞉go꞉ko꞉lo꞉ Ablam eyo꞉ Lodbo꞉ sa꞉laki, “Na꞉no꞉ so꞉lo꞉ imilise ko꞉lo꞉, na꞉n usamio꞉ mo꞉kegema꞉niki a꞉la꞉ta꞉ga꞉ nain nanog dian kalu egelebo꞉lo꞉ mo꞉kegema꞉ki asulab. ");
INSERT INTO bco_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ge bo꞉ba! Hen alan hono ga꞉li a꞉lab ko꞉lo꞉, na꞉no꞉ aloba꞉da꞉sa꞉ga꞉ mesa꞉niki. Ge halomida꞉ ha꞉nalega, ne kini doba꞉da꞉ ha꞉na꞉no꞉. Ge kini doba꞉da꞉ ha꞉nalega, ne halomida꞉ mesa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","A꞉la꞉ta꞉ga꞉ Lod e kagafo꞉liki, heno꞉ tambo sigida꞉liki ba꞉ba꞉ amio꞉, e Yodan fua꞉lo꞉ hen a꞉namida꞉yo꞉lo꞉, Soa amisa꞉n doba꞉da꞉yo꞉lo꞉, hen o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ tambo nafa ko꞉lo꞉ ba꞉ba꞉. Hen a꞉no꞉, Isib hen nafa o꞉lia꞉ Yawe ene egelo꞉, Ida꞉n hen o꞉lia꞉yo꞉ o꞉leo꞉ngo꞉ ba꞉ba꞉. (O꞉g ho꞉len a꞉namio꞉ Sodom amisa꞉n o꞉lia꞉ Gomola amisa꞉n o꞉lia꞉yo꞉ a꞉na sen, mo꞉wo꞉ Yawe eyo꞉ amisa꞉n a꞉la꞉ a꞉no꞉ o꞉semo꞉ mogagilaki mo꞉yasala꞉.) ");
INSERT INTO bco_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Lod e Yodan fua꞉lo꞉ hen a꞉namida꞉yo꞉ nafa ba꞉da꞉sa꞉ga꞉, hen a꞉no꞉ e dia꞉no꞉ da꞉fea꞉sa꞉ga꞉yo꞉, e Ablamo꞉ ta꞉ta꞉ga꞉, ofdo꞉ yan doba꞉da꞉ a꞉na mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","A꞉la꞉fo꞉ko꞉lo꞉ Ablam e Ka꞉ina꞉n hen a꞉naka sen. A꞉la꞉ta꞉ga꞉ Lod e hen fua꞉lo꞉ amisa꞉n noldo꞉ a꞉lab us a꞉na silikiyo꞉, eyo꞉ helebeso꞉g ayo꞉ ho꞉len no amio꞉ nowa dia꞉liki a꞉la꞉li aneyo꞉, Sodom amisa꞉n aniba fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodom kaluka꞉isaleyo꞉ tambo Yawe ene siwa꞉l amio꞉ man mogago꞉le ko꞉li ko꞉lilo꞉ dimida꞉li elen. ");
INSERT INTO bco_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","15","Lod e ha꞉na꞉sa꞉ga꞉ dowabiki, Yawe eyo꞉ Ablambo꞉ a꞉la꞉sio꞉, “Ge heno꞉ tambo sigida꞉likiyo꞉, hen ofdo꞉ yan doba꞉da꞉yo꞉lo꞉, ofdo꞉ tinan doba꞉da꞉yo꞉lo꞉, eleb doba꞉da꞉yo꞉lo꞉, kini doba꞉da꞉yo꞉lo꞉ sigida꞉li bo꞉ba. Mo꞉wo꞉ hen gilo꞉ o꞉gdo꞉ ba꞉dab a꞉no꞉ tambo gemo꞉ dimia꞉no꞉. A꞉la꞉ta꞉ga꞉ gi so꞉waya꞉lo꞉ sa꞉la꞉lab a꞉no꞉lo꞉, hen a꞉no꞉ ho꞉leno꞉ tambo ilino꞉ dowa꞉i ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tif amio꞉ niyo꞉ so꞉wa gilo꞉ma꞉lo꞉ sa꞉la꞉lab a꞉no꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉, iyo꞉ sa꞉ mu o꞉ngo꞉ fa꞉la꞉doma꞉ib. Kaluwa꞉yo꞉ sa꞉yo꞉ o꞉li agelan kibo꞉bowo꞉, so꞉wa gilo꞉ma꞉lo꞉ sa꞉la꞉la꞉i ha꞉nab a꞉no꞉lo꞉ o꞉li agelemabe. ");
INSERT INTO bco_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","A꞉la꞉fo꞉ko꞉lo꞉ ge dasila꞉sa꞉ga꞉, sia꞉li bebeakiyo꞉, hen we tambo hegela꞉bi. Mo꞉wo꞉ hen we niyo꞉ gemo꞉ dimia꞉no꞉.” Yawe eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","A꞉la꞉sa꞉labiki Ablam e Betel hen a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nakiyo꞉, Heblon amisa꞉n anib a꞉namida꞉, Mameleya꞉ i ba꞉lo꞉ gelo꞉ anib a꞉na, Ablam eyo꞉ so꞉g a elo꞉wo꞉ dia꞉ga꞉ sen. A꞉na silikiyo꞉, eyo꞉ uwo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉, Yawe ene wiyo꞉ ko꞉lo꞉ dulugu sa꞉ma꞉niki dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Ho꞉len a꞉namio꞉, Elam misa꞉ kalu Kedelomel o꞉lia꞉, Sinal misa꞉ kalu Amafel o꞉lia꞉, Elasal misa꞉ kalu Aliog o꞉lia꞉, Goim misa꞉ kalu Tidal, misa꞉ kalu fa꞉la꞉da꞉in i a꞉ma꞉yo꞉, misa꞉ kalu bila꞉fo꞉ nol o꞉lia꞉ babuma꞉ni ane. Misa꞉ kalu bila꞉fo꞉ a꞉no꞉lia꞉lo꞉ bubo꞉wo꞉ we, Sodom misa꞉ kalu Belayo꞉, Gomola misa꞉ kalu Bilsayo꞉, Adma misa꞉ kalu Sinabo꞉, Seboim misa꞉ kalu Semebelo꞉ a꞉la꞉ta꞉ga꞉ Bela misa꞉ kaluwo꞉, i o꞉m. (Bela amisa꞉n a꞉no꞉ wi nowo꞉ Soa a꞉la꞉sa꞉la꞉sen.) ");
INSERT INTO bco_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Bubo꞉wo꞉ fa꞉la꞉doma꞉nigabikiyo꞉, misa꞉ kalu bila꞉fo꞉ i a꞉no꞉ Sidim hen fua꞉lo꞉ a꞉na ua babuma꞉ni kegeo꞉. (hen fua꞉lo꞉ Sidim a꞉la꞉do꞉ sa꞉lab a꞉no꞉, hen fua꞉lo꞉ so꞉lu ho꞉ndo꞉ a꞉labo꞉ o꞉m.) ");
INSERT INTO bco_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Tamin amio꞉, donayo꞉ kugula꞉fo꞉ us a꞉namio꞉ misa꞉ kalu a꞉no꞉ tambo Kedelomel e ha꞉ga dofo꞉len. Ko꞉sega dona dagaso꞉ dowabikiyo꞉, amisa꞉n bila꞉fo꞉ a꞉ma꞉yo꞉ Kedelomel elo꞉ bo꞉fo꞉lab a꞉no꞉ mo꞉beakiyo꞉ a꞉la꞉iyo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","A꞉la꞉fo꞉ko꞉lo꞉ dona ka꞉la꞉n a꞉namio꞉, Kedelomel e asuwa꞉takilo꞉ babuma꞉no꞉ misa꞉ kalu otalen a꞉no꞉ babuma꞉niki kegeo꞉. Iyo꞉ kegea꞉sa꞉ga꞉yo꞉, Astelo-Kanaim amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉, Lefa kaluka꞉isale a꞉no꞉lia꞉ bubakiyo꞉, ili tinio꞉. A꞉la꞉ta꞉ga꞉ iyo꞉ Ham amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉, Sus kaluka꞉isale a꞉no꞉lia꞉ bubakiyo꞉, ili tinio꞉. A꞉la꞉ta꞉ga꞉ iyo꞉ Kiliataim fua꞉lo꞉ a꞉na ha꞉na꞉sa꞉ga꞉, Em kaluka꞉isale a꞉no꞉lia꞉ bubakiyo꞉, ili tinio꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","A꞉la꞉ta꞉ga꞉ iyo꞉ Seil misio꞉ doba꞉da꞉ ha꞉na꞉sa꞉ga꞉, Hol kaluka꞉isale a꞉no꞉lia꞉lo꞉ buba꞉likilo꞉ aneyo꞉, ili tinio꞉. Iyo꞉ a꞉la꞉do꞉ buba꞉likilo꞉ aneyo꞉, El Balan a꞉na fa꞉la꞉dota꞉ga꞉, kalulo꞉ma heno꞉ ko꞉na꞉ma dowabiki, a꞉na edo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Iyo꞉ a꞉na eleta꞉ga꞉yo꞉, a꞉ma꞉la꞉ ha꞉nakiyo꞉, En-Misibad amisa꞉n a꞉na fa꞉la꞉dowo꞉. (Amisa꞉n a꞉no꞉ mo꞉luwo꞉ Kades a꞉la꞉sa꞉la꞉sen.) Iyo꞉ a꞉na fa꞉la꞉dota꞉ga꞉yo꞉, Amaleg hen amilo꞉ kandayo꞉ kaluka꞉isale a꞉no꞉lia꞉ bubakiyo꞉, ili tinio꞉. A꞉la꞉ta꞉ga꞉ iyo꞉ Hasason Temal amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉, Amol kaluka꞉isale a꞉no꞉lia꞉ buba꞉i aneyo꞉, ili tinio꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Bubo꞉ a꞉no꞉ ili tinia꞉sa꞉ga꞉yo꞉, Sodom misa꞉ kaluwo꞉lo꞉, Gomola misa꞉ kaluwo꞉lo꞉, Adma misa꞉ kaluwo꞉lo꞉, Seboim misa꞉ kaluwo꞉lo꞉, a꞉la꞉ta꞉ga꞉ Bela ene wi nowo꞉ Soa, misa꞉ kalu elo꞉wo꞉lo꞉ a꞉la꞉ta꞉ga꞉ ame kalu inido꞉wo꞉lo꞉ tambo Sidim hen fua꞉lo꞉ a꞉na babuma꞉ni kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Misa꞉ kalu bila꞉fo꞉ a꞉no꞉ a꞉na kegea꞉sa꞉ga꞉yo꞉, Elam misa꞉ kalu Kedelomel, Sinal misa꞉ kalu Amafel, Elasal misa꞉ kalu Aliog, a꞉la꞉ta꞉ga꞉ Goim misa꞉ kalu Tidal, misa꞉ kalu fa꞉la꞉da꞉in i a꞉no꞉lo꞉ kegea꞉sa꞉ga꞉, misa꞉ kalu bila꞉fo꞉ o꞉lia꞉ bubo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidim hen fua꞉lo꞉ a꞉namio꞉, oga꞉dan kelego꞉wo꞉ hen alu a꞉namio꞉ modo꞉ ko꞉lo꞉ wa꞉lifo꞉len. Iyo꞉ buba꞉i ha꞉nakiyo꞉, Sodom buban kalu a꞉no꞉lo꞉ Gomola buban kalu a꞉no꞉lo꞉ tagi dalaidakiyo꞉, nolo꞉ hen alu a꞉na sulufo꞉ tinaki, a꞉na oga꞉di alifelo꞉, a꞉la꞉ta꞉ga꞉ nolo꞉ hen misio꞉wa nai ane. ");
INSERT INTO bco_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","A꞉la꞉fo꞉ko꞉lo꞉ bubo꞉wo꞉ Kedelomel e tinia꞉sa꞉ga꞉yo꞉, e o꞉lia꞉lo꞉ dowakilo꞉ buban kalu i a꞉no꞉lo꞉, Sodom o꞉lia꞉ Gomola amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉, kelego꞉wo꞉lo꞉, ma꞉no꞉wo꞉lo꞉ tambo ili dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","A꞉la꞉ta꞉ga꞉ Ablama꞉ aowa꞉ inso꞉, Lodo꞉, e Sodom amisa꞉n a꞉na sen ko꞉lo꞉ buban kalu iliyo꞉ Lodo꞉ a꞉la꞉ta꞉ga꞉ ene kelego꞉ o꞉lia꞉ tambo ta꞉lia꞉sa꞉ga꞉ tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","A꞉la꞉dimidabiki kalu nowo꞉ ba꞉da꞉sa꞉ga꞉, tagilaki nai ha꞉na꞉sa꞉ga꞉, Hibulu kalu Ablam elo꞉wa fa꞉la꞉dowakiyo꞉ emo꞉ sa꞉laki, “Gis kaluwa꞉yo꞉ gawayo꞉ ta꞉lia꞉sa꞉ga꞉ tililia꞉gane” a꞉la꞉ malolo꞉ me. Ho꞉len a꞉namio꞉ Ablam e Mameleya꞉ ba꞉ ilo꞉ gelo꞉ anib a꞉na sen. Mamele e Amol kalu ko꞉lo꞉ e o꞉lia꞉ ene ao a꞉la꞉, Eskol o꞉lia꞉ Anel, kalu otalen i a꞉no꞉ Ablam e fa꞉s bo꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","15","A꞉la꞉fo꞉ko꞉lo꞉ Ablama꞉ enawa Lodo꞉, Kedelomel e tililia꞉ganeka꞉ a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, eyo꞉ elo꞉ gasa ilikilo꞉ sa꞉la꞉li kalu a꞉no꞉ kegeo꞉. Kalu i a꞉no꞉ halaido꞉lo꞉ buba꞉sen kalu ko꞉lo꞉, iyo꞉ 318 a꞉la꞉fo꞉ a꞉no꞉ kegea꞉sa꞉ga꞉yo꞉, iliyo꞉ Kedelomel o꞉lia꞉ babuma꞉ni kuda꞉i ane. Iyo꞉ ua kuda꞉i aneyo꞉, Dan hen a꞉na fa꞉la꞉dowakiyo꞉, Ablam eyo꞉ nulu a꞉namio꞉ ene buban kalu a꞉no꞉ usa alobo꞉no꞉. Iliyo꞉ giso꞉ banagalia꞉fo꞉liki a꞉na buba꞉sa꞉ga꞉, iliyo꞉ tinio꞉. A꞉la꞉fo꞉ko꞉lo꞉ gis kalu i a꞉no꞉ ili o꞉lusa꞉nda꞉i aneyo꞉, Damaskas amisa꞉no꞉ tinia꞉sa꞉ga꞉, Hoba amisa꞉n a꞉namida꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Kedelomel o꞉lia꞉ ene buban kalu ililo꞉ kelego꞉ dia꞉gane a꞉no꞉ Ablam eyo꞉ tambo a꞉ma꞉la꞉ a꞉dia꞉mio꞉. A꞉la꞉ta꞉ga꞉ Ablam eyo꞉ enawa Lod o꞉lia꞉ ene kelego꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ kaluka꞉isale enedo꞉wo꞉lo꞉, tambo a꞉ma꞉la꞉ tililia꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Kedelomel o꞉lia꞉ elo꞉ asufa꞉ misa꞉ kalu otalen a꞉no꞉lia꞉lo꞉ bubo꞉wo꞉, Ablam e tinio꞉ ko꞉lo꞉, e a꞉ma꞉la꞉ ya꞉ga꞉, Sodom misa꞉ kalu a꞉no꞉ Safe hen fua꞉lo꞉ a꞉na galima꞉ni ane. (Safe hen fua꞉lo꞉ a꞉no꞉ wi nowo꞉ we, “Misa꞉ Kaluwa꞉ fua꞉lo꞉ hen” a꞉la꞉sa꞉la꞉sen.) ");
INSERT INTO bco_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","A꞉la꞉go꞉ko꞉lo꞉ Salem misa꞉ kalu Melekisedeg elo꞉ ya꞉ga꞉, ma꞉n dowo꞉fa꞉ o꞉lia꞉ wain ho꞉n o꞉lia꞉yo꞉ Ablambo꞉ dimia꞉niki dia꞉mio꞉. Ma꞉kisedeg e, Gode Iwalulo꞉ A꞉lab o꞉mo꞉lo꞉ bobalo꞉ so꞉mea꞉sen kalu nowo꞉ e. ");
INSERT INTO bco_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Ma꞉kisedeg Ablamdo꞉wa ya꞉ga꞉, Ablam e nafale mesea꞉ki towo꞉ a꞉la꞉sio꞉, “Gode Iwalulo꞉ A꞉lab haloma꞉yo꞉ Hebene o꞉lia꞉ henfelo꞉ o꞉lia꞉yo꞉ e dimido꞉ ko꞉lo꞉, Eyo꞉ ge nafale doma꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Gode eyo꞉ gis kaluwo꞉ gi tininima꞉ki, gi dagiya ta꞉fo꞉. Eyo꞉ ge nafale mesea꞉ki halaido꞉ ta꞉fo꞉ ko꞉lo꞉, niliyo꞉ Gode Iwalulo꞉ A꞉lab a꞉no꞉ wabudaki dulugu sa꞉ma꞉niki.” Melekisedeg eyo꞉ a꞉la꞉sa꞉labiki, Ablam eyo꞉ kelego꞉ elo꞉ dia꞉mio꞉ a꞉no꞉ heb do꞉la꞉fo꞉wo꞉ aloba꞉da꞉sa꞉ga꞉, heb imilise nowo꞉ Melekisedegbo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ablam eyo꞉ a꞉la꞉dimida꞉sa꞉ga꞉ dowabiki, Sodom misa꞉ kaluwa꞉ emo꞉ sa꞉laki, “Kaluka꞉isale nilo꞉wo꞉ gilo꞉ tililia꞉mio꞉ a꞉no꞉ nemo꞉ dimina. Ko꞉sega kelego꞉ nilo꞉wo꞉ gilo꞉ dia꞉mio꞉ a꞉no꞉ ge tambo dima” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Ko꞉sega Ablam eyo꞉ emo꞉ sa꞉laki, “Yawe, Gode Iwalulo꞉ A꞉lab a꞉ma꞉yo꞉ Hebene o꞉lia꞉ henfelo꞉ o꞉lia꞉yo꞉ e dimido꞉ ko꞉lo꞉, niyo꞉ emo꞉wo꞉ halaido꞉ a꞉la꞉dinali sio꞉, ‘Gi kelego꞉wo꞉ imilise nowo꞉ niyo꞉ mo꞉dia꞉no꞉. Budi amilo꞉ me o꞉lia꞉ dubian me, ha꞉lu kelego꞉ o꞉ngo꞉wo꞉lo꞉ niyo꞉ mada mo꞉dia꞉no꞉. Tif amio꞉ giyo꞉ “Ablam e kelego꞉wo꞉ modo꞉ dowab a꞉no꞉ ne dimido꞉” a꞉la꞉ sa꞉labena꞉kiyo꞉, niyo꞉ kelego꞉ gilo꞉wo꞉ imilise nowo꞉ mada mo꞉dia꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Kalu otalen nelo꞉ asufa꞉yo꞉ we, Mamele, Anel, Eskol, iliyo꞉ heb a꞉no꞉ o꞉li dia꞉ib. A꞉la꞉ta꞉ga꞉ ni nanogdo꞉ dian kaluwa꞉lo꞉ mo꞉no꞉ hebda꞉su a꞉no꞉ niyo꞉ o꞉li di ko꞉sega, kelego꞉ imilise nowo꞉ mada mo꞉dia꞉no꞉.” Ablam eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Tif amio꞉ Ablam e ho꞉le ba꞉dakiyo꞉, Yawe eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ablam ge tagila꞉so꞉bo! Gelo꞉ dimisima꞉no꞉ bio꞉wo꞉ ne. Wa꞉l kelego꞉ gilo꞉ dia꞉no꞉wo꞉, mada alan nafale doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Ko꞉sega Ablam eyo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Wiso꞉, Alan Yawe, ne so꞉walo꞉ma ko꞉lo꞉, ni dabun kelego꞉wo꞉ Eliesa, Damaskas kalu e dia꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ wa꞉l kelego꞉ gilo꞉ nemo꞉lo꞉ dimia꞉no꞉ a꞉no꞉ ni so꞉lo꞉ amio꞉ mo꞉dowa꞉i ha꞉naliki, ne mo꞉asuwa꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Giyo꞉ so꞉wayo꞉ nemo꞉wo꞉ mo꞉dimi ko꞉lo꞉, ni nanogdo꞉ dian kaluwa꞉lo꞉ so꞉wa sa꞉la꞉liab a꞉ma꞉ ni dabuno꞉ dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Ablam eyo꞉ towo꞉ sa꞉la꞉sa꞉ga꞉ edabiki, Yawe eyo꞉ Ablam emo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Kalu a꞉ma꞉yo꞉ dabun gilo꞉wo꞉ mo꞉dia꞉ib. Ko꞉sega go꞉no꞉n ho꞉bo꞉leya a꞉la꞉ta꞉ga꞉lo꞉ sa꞉la꞉liab a꞉ma꞉yo꞉, dabun gilo꞉wo꞉ ene dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","A꞉la꞉sa꞉la꞉sa꞉ga꞉ dowabiki Gode eyo꞉ Ablam e ha꞉la꞉ya tililia꞉ ha꞉na꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Ge akin halo bo꞉ba. Tamin gego꞉ a꞉no꞉, giyo꞉ agelema꞉no꞉ o꞉liyo꞉? Geya a꞉la꞉ta꞉ga꞉lo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉nab a꞉no꞉, tamin gego꞉ o꞉leo꞉ngo꞉ doma꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ablam e Yawe elo꞉ to sa꞉lab a꞉no꞉ hendele tilida꞉dabiki, Yawe eyo꞉ elo꞉ tilida꞉dab a꞉na ba꞉da꞉ga꞉, e digalo꞉ kalu a꞉la꞉bo꞉ a꞉na aloba꞉da꞉sa꞉ga꞉ da꞉feyo꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","A꞉la꞉ta꞉ga꞉ Yawe eyo꞉ emo꞉wo꞉ wa꞉ka sa꞉laki, “Ne Yawe. Ge Ul amisa꞉n, Kaldia hen a꞉na sabikiyo꞉, niyo꞉ hen we gemo꞉ dimia꞉sa꞉ga꞉ biso꞉wo꞉ ge doma꞉ki, wena tililia꞉ mio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Ko꞉sega Ablam eyo꞉ towo꞉ a꞉ma꞉la꞉ sa꞉laki, “Wiso꞉ Alan Yawe, hen we biso꞉wo꞉ hendele ne doma꞉no꞉lo꞉b a꞉la꞉bo꞉, waga asuluma꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","A꞉la꞉fo꞉ko꞉lo꞉ Yawe eyo꞉ emo꞉ a꞉ma꞉la꞉ sa꞉laki, “Kelego꞉ nolo꞉ nelo꞉wa dia꞉mena. Kao mala o꞉lia꞉ goudi mala o꞉lia꞉ sibi de o꞉lia꞉ dona otalendo꞉ gulula꞉ a꞉no꞉ a꞉la꞉ta꞉ga꞉ o꞉ba꞉ hi o꞉lia꞉ o꞉ba꞉ susu ha꞉lu o꞉lia꞉yo꞉ nelo꞉wa dia꞉mena,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","A꞉la꞉sa꞉labiki Ablam eyo꞉ no꞉ a꞉no꞉ elo꞉wa tambo dia꞉ya꞉sa꞉ga꞉, a꞉na noba꞉nela꞉sa꞉ga꞉yo꞉, noba꞉n nodowo꞉ nodo dila꞉, a꞉la꞉ta꞉ga꞉ nodowo꞉ nodo dila꞉. Ko꞉sega o꞉ba꞉ a꞉la꞉ a꞉no꞉ mo꞉noba꞉iyaki, ka dila꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","No꞉ noba꞉nela꞉ a꞉no꞉ dila꞉sa꞉ga꞉ dowabiki, usulage a꞉ma꞉ ma꞉ni tinda꞉labikiyo꞉, Ablam eyo꞉ o꞉lusanaga꞉fela꞉len. ");
INSERT INTO bco_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ga꞉lo ofo꞉ tinabiki, Ablam e mada alan alifo꞉len ko꞉lo꞉, sololiya꞉yo꞉ e go꞉lula꞉fo꞉labiki, e tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","A꞉la꞉fo꞉labiki Yawe eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “To nilo꞉ so꞉lo꞉l we, hendele fa꞉la꞉doma꞉ib a꞉la꞉bo꞉ giyo꞉ mada asululia꞉bi. So꞉wa gilo꞉ sa꞉la꞉la꞉likilo꞉ ha꞉na꞉lab i a꞉no꞉, hen noma꞉lo꞉wa mageso꞉ kalu ko꞉lo꞉ mio꞉ san o꞉ngo꞉ mesa꞉ib. Donayo꞉ 400 a꞉la꞉fo꞉ a꞉na silikiyo꞉, iyo꞉ madali nanog dian kalu dowaki, hendo꞉ biso꞉ iliyo꞉ iyo꞉ dikidi sa꞉ndamela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ko꞉sega tif amio꞉, ilo꞉ madali nanog dima꞉kilo꞉ ta꞉fo꞉ kalu i a꞉no꞉ niyo꞉ falasila꞉ma꞉no꞉. A꞉ma꞉ fa꞉s amio꞉ so꞉wa gililo꞉ sa꞉la꞉la꞉i ane a꞉no꞉ a꞉ma꞉la꞉ yakiyo꞉, kelego꞉wo꞉ modo꞉ dia꞉mia꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ko꞉sega Ablam, ge ha꞉fa꞉nolo ta꞉i ha꞉na꞉la꞉ga꞉, anaso꞉ dota꞉ga꞉, ge a꞉na sowaliki dali alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ko꞉sega Amol kaluka꞉isale hen wenamilo꞉ sab i a꞉ma꞉lo꞉ mogago꞉ dimida꞉len a꞉no꞉ alano꞉ semo꞉fa꞉la꞉dowo꞉ ko꞉lo꞉, i wa꞉dema꞉no꞉ ho꞉lendeyo꞉ semo꞉fa꞉la꞉dowab. A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ane a꞉no꞉ a꞉ma꞉la꞉bo꞉ bo꞉bo꞉gebo꞉ mo꞉mia꞉ib. So꞉lo꞉ ha꞉nab agelo꞉wo꞉ fa꞉la꞉da꞉in dowa꞉sa꞉ga꞉, iyo꞉ a꞉namio꞉ a꞉ma꞉la꞉yo꞉ a꞉na mia꞉ib.” Yawe eyo꞉ a꞉la꞉dinali saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ofo꞉ tina꞉sa꞉ga꞉ sololiabiki, no꞉lo꞉ noba꞉nela꞉ dila꞉ us a꞉namio꞉, go꞉fo꞉ amilo꞉ de ho꞉mo꞉ndo꞉ dowo꞉ a꞉no꞉lia꞉, gele ho꞉ a꞉no꞉lia꞉ handalota꞉ga꞉, us a꞉na tinia꞉li ane. ");
INSERT INTO bco_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","O꞉g a꞉namio꞉, Yawe eyo꞉ Ablam o꞉lia꞉ towo꞉ dinali saetaki a꞉la꞉sio꞉, “Hen we so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉nab o꞉mo꞉ dimi ko꞉lo꞉, hen we Isib ho꞉n a꞉na mo꞉mo꞉dalia꞉sa꞉ga꞉, eda꞉li aneyo꞉ ho꞉n alan Yufuletisdo꞉ a꞉lab a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Hen a꞉namilo꞉ kaluka꞉isale o꞉gdo꞉ sabo꞉ we. Kin kaluwo꞉, Kenas kaluwo꞉, Katmon kaluwo꞉, ");
INSERT INTO bco_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hit kaluwo꞉, Beles kaluwo꞉, Lefa kaluwo꞉, ");
INSERT INTO bco_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amol kaluwo꞉, Ka꞉ina꞉n kaluwo꞉, Giligas kaluwo꞉ a꞉la꞉ta꞉ga꞉ Ya꞉bus kaluwo꞉. Hen a꞉no꞉ so꞉wa gilo꞉mo꞉ dimi.” Yawe eyo꞉ a꞉la꞉dinali saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ablam ene inga Sa꞉lai eyo꞉ so꞉wayo꞉ Ablambo꞉wo꞉ mo꞉sa꞉la꞉me. Selaiya꞉ ene nanogdo꞉ dian ka꞉isale nowo꞉ ene wiyo꞉ Ha꞉ga, e Isib ka꞉isale ko꞉lo꞉ e o꞉lia꞉ elen. ");
INSERT INTO bco_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","A꞉la꞉fo꞉ko꞉lo꞉ Sa꞉lai eyo꞉ Ablambo꞉wo꞉ a꞉la꞉sio꞉, “Ge asuluma. Yawe eyo꞉ ne so꞉wayo꞉ mo꞉sa꞉la꞉lima꞉ki, faino ga ta꞉fo꞉. A꞉la꞉go꞉ko꞉lo꞉ ge ni nanog ka꞉isalelo꞉wa ha꞉na꞉sa꞉ga꞉, e o꞉lia꞉ alila꞉bi. A꞉la꞉dimidalega so꞉wa nilo꞉ sa꞉la꞉lialu aumbo꞉, Ha꞉ga eyo꞉ so꞉wa nolo꞉ sa꞉la꞉ mea꞉nigaba꞉le?” Sa꞉lai elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, Ablam eyo꞉ asulo꞉wo꞉ imilise dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","A꞉la꞉go꞉ko꞉lo꞉ Sa꞉lai eyo꞉ Isib ga Ha꞉ga, ene nanogdo꞉ dian a꞉no꞉ tililia꞉ga꞉, in Ablama꞉ ene inga doma꞉ki dimi. Ho꞉len a꞉namio꞉, Ablam e Ka꞉ina꞉n hen a꞉namilo꞉ seno꞉ donayo꞉ do꞉la꞉fo꞉wo꞉ gulula꞉ ");
INSERT INTO bco_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","A꞉la꞉fo꞉ko꞉lo꞉ Ablam e Ha꞉ga o꞉lia꞉ ali ko꞉lo꞉, Ha꞉ga e alelo꞉. E alelab a꞉la꞉bo꞉ asula꞉sa꞉ga꞉yo꞉, eyo꞉ Sa꞉lai ba꞉dakiyo꞉, e o꞉ngo꞉malo꞉ngo꞉ a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","A꞉la꞉fo꞉ko꞉lo꞉ Sa꞉lai eyo꞉ Ablambo꞉wo꞉ a꞉la꞉sio꞉, “Ni nanog ka꞉isaleyo꞉ gemo꞉ dimi ko꞉sega, e alelabo꞉lo꞉b a꞉la꞉bo꞉ eneno꞉ asulakiyo꞉, eyo꞉ ne o꞉ngo꞉malo꞉ngo꞉ a꞉la꞉ba꞉ba꞉. A꞉la꞉fo꞉ko꞉lo꞉ nelo꞉ amilo꞉ hida꞉yo꞉ fa꞉la꞉dowab a꞉no꞉, hala dimido꞉wo꞉ geya doma꞉ib. Yawe eyo꞉ na꞉n usamio꞉ halabo꞉ abe dimido꞉wa꞉le a꞉la꞉bo꞉ aloba꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ko꞉sega Ablam eyo꞉ Selaimo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉no꞉n nanog ka꞉isale a꞉no꞉ ge o꞉lo꞉ biso꞉ ko꞉lo꞉, go꞉no꞉ndo꞉ asulab aumbo꞉, giyo꞉ emo꞉ dimida꞉bi.” Ablam eyo꞉ a꞉la꞉sa꞉labiki, Sa꞉lai eyo꞉ Ha꞉ga emo꞉wo꞉ gadia꞉liki hida꞉yo꞉wo꞉ dimia꞉len ko꞉lo꞉ Ha꞉ga e Sa꞉lai ta꞉ta꞉ga꞉ nai ane. ");
INSERT INTO bco_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","E kalulo꞉ma hen a꞉na ha꞉na꞉sa꞉ga꞉, Sul amisa꞉ndo꞉ ha꞉na꞉sen tog anib a꞉na, ho꞉n silo꞉ a꞉lab a꞉nami sen ko꞉lo꞉, Yawe ene ma꞉mul kaluwo꞉ a꞉na galili. ");
INSERT INTO bco_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ma꞉mul kalu eyo꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “Ha꞉ga, Selaiya꞉ ene nanogdo꞉ dian ga, ge o꞉ba a꞉la꞉ta꞉ga꞉ mio꞉wo꞉? Ge o꞉bamida꞉ ha꞉naya?” A꞉la꞉dabu ba꞉dabiki, Ha꞉ga e a꞉ma꞉la꞉ sa꞉laki, “Ne, ni misa꞉ ga Selaiyo꞉ ta꞉ta꞉ga꞉ ho꞉no꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","A꞉la꞉ta꞉ga꞉ Yawe ene ma꞉mul kaluwa꞉ a꞉ma꞉la꞉ sa꞉laki, “Ge a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, go꞉no꞉n misa꞉ ga elo꞉ to sa꞉lab au dimidaki, ha꞉ga doma꞉ni ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","A꞉la꞉ta꞉ga꞉ ma꞉mul kaluwa꞉ a꞉sa꞉lakiyo꞉, “Gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉nab i a꞉no꞉ modo꞉ fa꞉la꞉doma꞉ki dimidama꞉no꞉ ko꞉lo꞉, kaluwa꞉yo꞉ i agelema꞉no꞉wo꞉ babalema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Eyo꞉ to nolo꞉ a꞉kudu sa꞉laki, “Hendele, ge o꞉go꞉ alelo꞉ a꞉lab ko꞉lo꞉, Giyo꞉ kalu so꞉wa sa꞉la꞉lia꞉ib. Gilo꞉ hida꞉yo꞉ a꞉no꞉ Yawe eyo꞉ dabu ko꞉lo꞉, Gilo꞉ so꞉wa sa꞉la꞉lia꞉nigab a꞉no꞉ ‘Ismael’ wikila꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","“So꞉wa gilo꞉wo꞉ igo꞉ o꞉ngo꞉ dowaki, E kaluka꞉isale tambo o꞉lia꞉ gis dimidaliki, Kaluka꞉isale i a꞉no꞉ e o꞉lia꞉yo꞉ gis dia꞉ib. A꞉la꞉ta꞉ga꞉ ene so꞉lo꞉ o꞉lia꞉yo꞉lo꞉ ha꞉fa꞉nolo꞉bo꞉ mo꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ha꞉ga eyo꞉ to sio꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, a꞉la꞉sio꞉ “Gode nelo꞉ ba꞉da꞉sen a꞉no꞉, o꞉go꞉ niyo꞉ hendele ba꞉ba꞉.” A꞉la꞉asula꞉sa꞉ga꞉, eyo꞉ Yawe ene wi ho꞉gi wikilakiyo꞉ a꞉la꞉sio꞉, “Nelo꞉ Ba꞉da꞉seno꞉ Gode ge.” ");
INSERT INTO bco_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","A꞉la꞉go꞉ko꞉lo꞉ kaluka꞉isaleyo꞉ ho꞉n si a꞉no꞉ a꞉la꞉wikilo꞉, “Bil Lahai Loi.” Ho꞉n si a꞉no꞉ Kades amisa꞉n a꞉no꞉ nol, Beled hen a꞉no꞉ nol a꞉lo꞉ us a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","A꞉ma꞉ fa꞉s amio꞉ Ha꞉ga eyo꞉ Ablama꞉ ene kalu so꞉wayo꞉ sa꞉la꞉liabikiyo꞉, Ablam eyo꞉ “Ismael” wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Ha꞉ga eyo꞉ Ablama꞉ so꞉wa Ismaeldo꞉ sa꞉la꞉liab ho꞉len a꞉namio꞉, Ablam e donayo꞉ do꞉la꞉fo꞉ o a꞉la꞉ta꞉ga꞉ do꞉go꞉fela꞉fo꞉ ko꞉lo꞉ gulula꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ablam e donayo꞉ do꞉la꞉fo꞉ agado꞉ a꞉la꞉ta꞉ga꞉ agado꞉la꞉fo꞉ a꞉no꞉ gulula꞉sa꞉ga꞉yo꞉, Yaweyo꞉ elo꞉wa handalowaki a꞉la꞉sio꞉, “Ne Gode Halaido꞉lelo꞉ A꞉labo꞉ Ne. Ge ni si wa꞉l amio꞉ hala dimido꞉wo꞉ mo꞉bo꞉ba꞉kiyo꞉, man digalo꞉ kudu ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Gemo꞉lo꞉ to dinali saeto꞉l we, niyo꞉ hendele dimidama꞉no꞉ ko꞉lo꞉, niyo꞉ ge so꞉lo꞉wo꞉ mada modo꞉le fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, Ablam e hena gulalu misa꞉fu ali. A꞉la꞉ta꞉ga꞉ Gode eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Nilo꞉ to sa꞉ma꞉nigo꞉l we, ge o꞉lia꞉yo꞉ dinali sa꞉laki saefa꞉nigo꞉l. Ge so꞉lo꞉ ko꞉li ko꞉lilo꞉ modo꞉ a꞉ma꞉ iya fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ge wiyo꞉ Ablam a꞉la꞉bo꞉ wa꞉kabiyo꞉ mo꞉sa꞉ma꞉ib. Ko꞉sega o꞉g wena a꞉la꞉ta꞉ga꞉yo꞉, ge wi wikilo꞉lo꞉ Ablaham. Mo꞉wo꞉ ge so꞉lo꞉ ko꞉li ko꞉lilo꞉ modo꞉ a꞉ma꞉ iya doma꞉ki ta꞉to꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","“Niyo꞉ so꞉wa gililo꞉ sa꞉la꞉la꞉i ha꞉nab a꞉no꞉ modo꞉ fa꞉la꞉do alitaki, i a꞉na a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉wo꞉ mada modo꞉le fa꞉la꞉doma꞉ki ta꞉to꞉l. A꞉la꞉ta꞉ga꞉ so꞉wa gililo꞉ sa꞉la꞉la꞉i ha꞉nab a꞉no꞉ nolo꞉ misa꞉ kalu alan fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","To saefa꞉ we, gemo꞉wo꞉ dinali so꞉lo꞉l a꞉la꞉ta꞉ga꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉nab o꞉mo꞉wo꞉lo꞉ dinali so꞉lo꞉l ko꞉lo꞉, to saefa꞉ we dowa꞉i ha꞉na꞉mela꞉no꞉ ha꞉na꞉mela꞉ib. A꞉la꞉go꞉ko꞉lo꞉ ne Gode gino꞉ doma꞉no꞉ a꞉la꞉ta꞉ga꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉nab i a꞉ma꞉ Godeyo꞉lo꞉ ne doma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Ka꞉ina꞉n hen amio꞉ gelo꞉ mageso꞉lo꞉ sia꞉lab a꞉no꞉, niyo꞉ ge o꞉lia꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉nab o꞉lia꞉mo꞉ tambo dimia꞉no꞉. Hen a꞉no꞉ ilino꞉ dowa꞉i ha꞉na꞉mela꞉ib. A꞉la꞉ta꞉ga꞉ ne Gode ilino꞉ doma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ Ablahambo꞉wo꞉ to nowo꞉ wa꞉ka sa꞉laki, “Gilo꞉ dimidama꞉kilo꞉ asulo꞉wo꞉, niyo꞉ gemo꞉ sa꞉ma꞉nigo꞉l. Ge o꞉lia꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab o꞉lia꞉ma꞉yo꞉ to nilo꞉ dinali saeto꞉l we dinafa kudu ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Nilo꞉ to saefa꞉ a꞉no꞉, ge o꞉lia꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab o꞉lia꞉ma꞉lo꞉ kudu ha꞉na꞉no꞉wo꞉ we, kaluwo꞉ tambo do꞉go꞉fo꞉ hege gedea꞉lubi. ");
INSERT INTO bco_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Giliyo꞉ a꞉la꞉dimidalikiyo꞉, nilo꞉ ge o꞉lia꞉lo꞉ to saefa꞉ a꞉no꞉ ko꞉lo꞉ ele ba꞉ba꞉no꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Kalu so꞉wa sa꞉la꞉liab a꞉no꞉ tambo ho꞉len o a꞉la꞉fo꞉wo꞉ ta꞉takiyo꞉, do꞉go꞉fo꞉ a꞉na hege gedea꞉lubi. So꞉wa gililo꞉ sa꞉la꞉la꞉i ha꞉nab i a꞉no꞉lo꞉ a꞉la꞉dimida꞉lubi. A꞉la꞉ta꞉ga꞉ nanog kalu gi ayamilo꞉ sab a꞉no꞉lo꞉ tambo a꞉la꞉dimida꞉lubi. Gi nanog kaluwa꞉lo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉nab a꞉no꞉lo꞉ a꞉la꞉ta꞉ga꞉ nanog kalu amisa꞉n ko꞉li ko꞉lilo꞉ gilo꞉ kilili a꞉no꞉lo꞉ tambo do꞉go꞉fo꞉ hege gedea꞉lubi. ");
INSERT INTO bco_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Nanog kaluwo꞉ tambo go꞉no꞉n ayamilo꞉ elen a꞉no꞉lo꞉, kalu gilo꞉ moleya꞉lo꞉ kilili a꞉no꞉lo꞉, do꞉go꞉fo꞉ hege gedea꞉lubi. A꞉la꞉go꞉ko꞉lo꞉ giliyo꞉ nilo꞉ to saefa꞉ a꞉no꞉ hendele kudu ha꞉nabo꞉lo꞉b a꞉la꞉ ele bo꞉ba꞉kiyo꞉, gili do꞉mo꞉wa dimidalifa꞉no꞉ ko꞉lo꞉ to saefa꞉ a꞉no꞉ dowa꞉i ha꞉na꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ko꞉sega kalu nowo꞉ do꞉go꞉fo꞉ mo꞉hege gedealega, kalu a꞉no꞉ ene so꞉lo꞉ o꞉lia꞉yo꞉ mo꞉gasa dowaki, e gede ga꞉fa꞉ib. Mo꞉wo꞉ kalu a꞉no꞉ nilo꞉ to saefa꞉ a꞉no꞉ mo꞉kudu ha꞉naki, e a꞉la꞉iyab.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ Ablahambo꞉ sa꞉laki, “Ga꞉ ga, Sa꞉lai, e amilo꞉ dimidama꞉no꞉wo꞉ we. Ene wiyo꞉ Sa꞉lai a꞉la꞉bo꞉ wa꞉kabiyo꞉ sa꞉la꞉so꞉bo. O꞉go꞉ ene wi ho꞉gi wikilo꞉lo꞉, Sa꞉la, a꞉la꞉sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Niyo꞉ e nafale mesea꞉ki ta꞉fa꞉no꞉. Hendele niyo꞉ kalu so꞉wa nowo꞉ gemo꞉ dimia꞉no꞉ ko꞉lo꞉, so꞉wa a꞉no꞉ Sa꞉la eya a꞉la꞉ta꞉ga꞉ gemo꞉ sa꞉la꞉mea꞉ib. A꞉la꞉ta꞉ga꞉ niyo꞉ e wa꞉ka sagale alitaki nafale dimidakiyo꞉, so꞉lo꞉ ko꞉li ko꞉lilo꞉ nolo꞉lo꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉do alifa꞉no꞉. A꞉la꞉ta꞉ga꞉ misa꞉ kalu alan nolo꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","A꞉la꞉sa꞉labiki Ablaham e hena gulalu misa꞉fu alifo꞉liki, e o꞉gaki enena꞉ma꞉la꞉yo꞉ a꞉la꞉asulo꞉, “Ne donayo꞉ do꞉la꞉lowo꞉wo꞉ do꞉la꞉fo꞉ gulula꞉ ko꞉lo꞉, ne anaso꞉ dowo꞉ wenamio꞉ so꞉wayo꞉ ka sa꞉la꞉lia꞉nigaba꞉le? A꞉la꞉ta꞉ga꞉ Sa꞉la e donayo꞉ do꞉la꞉lowo꞉ agado꞉ a꞉la꞉fo꞉ gulula꞉ ko꞉lo꞉, e so꞉wayo꞉ mada mo꞉sa꞉la꞉lia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ablaham eyo꞉ a꞉la꞉asulakiyo꞉, Godemo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ nemo꞉lo꞉ to dinali sio꞉ a꞉no꞉, Ismaelbo꞉ dimina꞉ki, niyo꞉ a꞉la꞉asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ablaham eyo꞉ a꞉la꞉sa꞉labiki, Gode eyo꞉ emo꞉ sa꞉laki, “A, a꞉la꞉bo꞉ mo꞉dimidama꞉no꞉. Ga꞉ ga Sa꞉la eyo꞉ kalu so꞉wayo꞉ gemo꞉ sa꞉la꞉mea꞉ib ko꞉lo꞉, giyo꞉ so꞉wa a꞉no꞉ Aisa꞉g wikila꞉bi. Nilo꞉ to saefa꞉ a꞉no꞉ e o꞉lia꞉ dimidaki, a꞉la꞉ta꞉ga꞉ so꞉wa elo꞉ sa꞉la꞉la꞉i ha꞉nab a꞉no꞉lia꞉yo꞉lo꞉ dimida꞉i ha꞉na꞉mela꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Niyo꞉ Ismael emo꞉lo꞉ dimidama꞉no꞉wo꞉ we. To gilo꞉ sio꞉wo꞉ ne dabu ko꞉lo꞉, niyo꞉ Ismael e nafale mesea꞉ki ta꞉takiyo꞉, so꞉wayo꞉ modo꞉ sa꞉la꞉la꞉ma꞉ki, a꞉la꞉ta꞉ga꞉ ene so꞉lo꞉wo꞉lo꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉. Eyo꞉ kalu so꞉wa kugula꞉fo꞉wo꞉ sa꞉la꞉lia꞉sa꞉ga꞉, i a꞉no꞉ tambo wabulun kalu doma꞉ib. A꞉la꞉ta꞉ga꞉ niyo꞉ eya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉ elo꞉ amio꞉ kaluka꞉isaleyo꞉ mada modo꞉le fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ko꞉sega nilo꞉ to saefa꞉ a꞉no꞉, Aisa꞉g o꞉lia꞉ dimidama꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ dona no hononamio꞉, ho꞉len wengalikiyo꞉, Sa꞉la eyo꞉ Aisa꞉g e a꞉na sa꞉la꞉lia꞉ib.” Gode eyo꞉ a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Godeyo꞉ Ablaham o꞉lia꞉lo꞉ tola꞉leno꞉ eleta꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","A꞉la꞉ta꞉ga꞉ ho꞉len a꞉namio꞉, Godeya꞉lo꞉ sio꞉ au dimidaki, Ablaham eyo꞉ Ismael o꞉lia꞉, ene nanogdo꞉ dian kaluwa꞉lo꞉ so꞉wa sa꞉la꞉la꞉ a꞉no꞉lo꞉, nanog kalu amisa꞉n ko꞉li ko꞉lilo꞉ elo꞉ moleya꞉lo꞉ kilili i a꞉no꞉lo꞉, a꞉la꞉ta꞉ga꞉ kalu e ayamilo꞉ sab a꞉no꞉ tambo do꞉go꞉fo꞉ hege gegedo꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ablaham e donayo꞉ do꞉la꞉lowo꞉wo꞉ agado꞉ a꞉la꞉ta꞉ga꞉ agado꞉la꞉fo꞉ dowabiki, e do꞉go꞉fo꞉ a꞉na hege gedeo꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","A꞉la꞉ta꞉ga꞉ inso꞉ Ismaelo꞉ donayo꞉ dagas a꞉la꞉fo꞉wo꞉ dowabiki, elo꞉ do꞉go꞉fo꞉ a꞉na hege gedeo꞉. ");
INSERT INTO bco_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Ho꞉len imilig a꞉nakabi, Ablaham o꞉lia꞉ Ismael o꞉lia꞉ ene nanog kaluwa꞉lo꞉ so꞉wa sa꞉la꞉la꞉ a꞉no꞉lo꞉, nanog kalu amisa꞉n ko꞉li ko꞉lilo꞉ elo꞉ moleya꞉lo꞉ kilili a꞉no꞉lo꞉, a꞉la꞉ta꞉ga꞉ kalu e ayamilo꞉ sab a꞉no꞉lo꞉ tambo, do꞉go꞉fo꞉ a꞉na hege gegedo꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Disi ofo꞉ halaido꞉ ta꞉ndabiki, Ablaham e Mameleya꞉ ba꞉ ilo꞉ gelo꞉ anib a꞉namio꞉, ene helebeso꞉g a toga꞉meya sen amio꞉, Yaweyo꞉ elo꞉wa fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ablaham e ba꞉ba꞉ amio꞉, kalu otaleno꞉ e milif doba꞉da꞉ a꞉na kagafo꞉lena ba꞉ba꞉. Iyo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, e ene ayamilo꞉ sen a꞉no꞉ ta꞉ta꞉ga꞉, ilo꞉wa nai ha꞉na꞉ga꞉yo꞉, hena gulalu misa꞉fu alilakiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","“Ni misa꞉ kalu, ge nemo꞉wo꞉ sagalalega, gi nanog dian kaluwo꞉ ne ko꞉lo꞉ tinia꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ni asulo꞉wa꞉yo꞉, gio꞉ i ha꞉g wena saliki, kalu nowo꞉ ho꞉no꞉ wasulia꞉ga꞉, gili gibo꞉ to꞉go꞉dema꞉ki, gio꞉ ha꞉fo꞉la꞉su mesea. ");
INSERT INTO bco_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Ne gili nanogdo꞉ dian kalu. Gio꞉ nelo꞉wa mio꞉ ko꞉lo꞉, gio꞉ ha꞉fo꞉ saliki, ma꞉no꞉wo꞉ na꞉sa꞉ga꞉ halaido꞉wo꞉ dima꞉ki, niyo꞉ ma꞉nda꞉suwo꞉ gimo꞉ dia꞉ mia꞉no꞉. Gio꞉ a꞉no꞉ na꞉sa꞉ga꞉yo꞉, o꞉li ha꞉na꞉bi, niyo꞉ a꞉la꞉asulo꞉l.” Ablaham eyo꞉ a꞉la꞉sa꞉labiki, iliyo꞉ a꞉ma꞉la꞉ sa꞉laki, “A꞉, gilo꞉ sa꞉lab au dimidama” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","A꞉la꞉fo꞉ko꞉lo꞉ Ablaham e helebeso꞉g aya bo꞉bo꞉ge ha꞉na꞉sa꞉ga꞉, Selamo꞉ sa꞉laki, “Bo꞉bo꞉ge! Ge falawa nafale wo꞉fa꞉ imilig nowo꞉ dia꞉sa꞉ga꞉, wo꞉gela꞉sa꞉ga꞉yo꞉, ma꞉no꞉wo꞉ so꞉da꞉bi” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","A꞉la꞉ta꞉ga꞉ Ablaham e kaolo꞉ fofan hen a꞉na nai ha꞉na꞉sa꞉ga꞉, kao kalofo nafale imilise nowo꞉ dia꞉sa꞉ga꞉, ene nanog kalumo꞉ dimiabiki, eyo꞉ bo꞉bo꞉ge dimidalia꞉ga꞉ so꞉fa꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","A꞉la꞉fo꞉ko꞉lo꞉ Ablaham eyo꞉ kao howo꞉lo꞉, bo ibo꞉lo꞉, ma꞉no꞉ nowo꞉lo꞉ dia꞉ga꞉, kalu i o꞉mo꞉ dimi. Iyo꞉ ma꞉no꞉ na꞉li sabiki, Ablaham e ili aniba, i ha꞉ga kagafo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","A꞉la꞉ta꞉ga꞉ iliyo꞉ Ablahambo꞉ dabu ba꞉daki a꞉la꞉sio꞉, “Ga꞉ ga Selayo꞉, o꞉ba saba?” Ablaham eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “E helebeso꞉g aya sab.” ");
INSERT INTO bco_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Kalu imilig noma꞉yo꞉ a꞉la꞉sio꞉, “Dona no honona ho꞉len wengalikiyo꞉, ne mada gelo꞉ amio꞉ a꞉mia꞉no꞉ ko꞉lo꞉, ga꞉ ga Sa꞉la eyo꞉ kalu so꞉wayo꞉ sa꞉la꞉lia꞉sa꞉ga꞉ elena doma꞉ib.” Eyo꞉ Ablaham o꞉lia꞉ a꞉la꞉sa꞉la꞉lab amio꞉, helebeso꞉g ayo꞉ e fa꞉sa elen ko꞉lo꞉, Sa꞉la e toga꞉meya kagafo꞉liki da꞉da꞉len. ");
INSERT INTO bco_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Ablaham o꞉lia꞉ Sa꞉la o꞉lia꞉yo꞉ donayo꞉ modo꞉ gulula꞉ ko꞉lo꞉ anaso꞉ dowo꞉. A꞉la꞉ta꞉ga꞉ Sa꞉la e so꞉wa sa꞉la꞉lia꞉no꞉ ho꞉leno꞉ edo꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","A꞉la꞉fo꞉ko꞉lo꞉ Sa꞉la e ene asulo꞉ amio꞉ o꞉ga꞉liki a꞉la꞉asulo꞉, “Kalu nilo꞉wo꞉lo꞉, nelo꞉ anaso꞉ dowab ko꞉lo꞉, ne wa꞉ka sagale alifa꞉nigaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","A꞉la꞉ta꞉ga꞉ Yawe eyo꞉ Ablahambo꞉ dabu ba꞉daki, “Sa꞉la e o꞉ga꞉li sa꞉laki, ‘Ne anaso꞉ dowab amio꞉, so꞉wa sa꞉la꞉lia꞉no꞉wo꞉ mada aundo꞉ma’ a꞉la꞉do꞉ sa꞉lab a꞉no꞉ waga sa꞉laba꞉le? Ne halaido꞉lo꞉ma a꞉laki gaba꞉le? ");
INSERT INTO bco_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","A꞉la꞉ba! Ne amio꞉ mo꞉dimidama꞉no꞉ kelego꞉ imilig nowo꞉ mada aundo꞉ma. Niyo꞉ kelego꞉wo꞉ tambo niyo꞉ o꞉li dimidama꞉no꞉. Dona no hononamio꞉, ho꞉len da꞉feyo꞉wo꞉ fa꞉la꞉dowaliki, ne gelo꞉ amio꞉ a꞉mia꞉no꞉ ko꞉lo꞉, Sa꞉la eyo꞉ kalu so꞉wayo꞉ sa꞉la꞉lia꞉sa꞉ga꞉ elena doma꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ko꞉sega Sa꞉la e tagi dowo꞉ ko꞉lo꞉, eyo꞉ do꞉lo꞉le sa꞉laki, “Ne mo꞉o꞉go꞉” a꞉la꞉sio꞉. Ko꞉sega Yawe e a꞉ma꞉la꞉ sa꞉laki, “A, hendele ge o꞉gale” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Kalu otalen a꞉no꞉ dasila꞉sa꞉ga꞉ ha꞉nabiki, Ablaham e i o꞉lia꞉ o꞉luma꞉la꞉lia꞉ga꞉ ha꞉nakiyo꞉, iyo꞉ Sodom amisa꞉no꞉ ololo bebeya꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","18","Iyo꞉ ha꞉nakiyo꞉, Yawe eyo꞉ a꞉la꞉sio꞉, “Nilo꞉ dimidama꞉no꞉wo꞉, Ablahambo꞉wo꞉ mo꞉wo꞉no꞉le dia꞉fa꞉no꞉. Mo꞉wo꞉ Ablaham eya a꞉la꞉ta꞉ga꞉yo꞉ kaluka꞉isaleyo꞉ modo꞉ fa꞉la꞉dowaki, so꞉lo꞉wo꞉ halaido꞉ doma꞉ib. A꞉la꞉ta꞉ga꞉ henfelo꞉ amilo꞉ so꞉lo꞉ sab a꞉no꞉ tambo eya a꞉la꞉ta꞉ga꞉yo꞉ nafale mesea꞉ki ta꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nilo꞉ e asulakilo꞉ da꞉fe alifa꞉ a꞉no꞉ mo꞉wo꞉ we. Eyo꞉ ene so꞉wa o꞉lia꞉ kaluka꞉isale e ayamilo꞉ sa꞉sen o꞉lia꞉mo꞉wo꞉, Yawe ene mano꞉ kudu hamana꞉ki, Ablaham eyo꞉ walama꞉ib ko꞉lo꞉, iyo꞉ Godeya꞉ siwa꞉l amilo꞉ man digalo꞉ a꞉no꞉lia꞉, kaluka꞉isale o꞉lia꞉lo꞉ nafa dimidan man a꞉no꞉lia꞉yo꞉, tambo kudu ha꞉na꞉mela꞉ib. Iliyo꞉ a꞉la꞉dimidalikiyo꞉, Yawe eyo꞉ Ablaham emo꞉lo꞉ dinali sio꞉ a꞉no꞉ tambo hendele o꞉li fa꞉la꞉doma꞉ki dimidama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","A꞉la꞉ta꞉ga꞉ Yawe eyo꞉ to nowo꞉ wa꞉ka a꞉sio꞉, “Sodom o꞉lia꞉ Gomola kaluka꞉isaleya꞉lo꞉ man mogago꞉le ko꞉li ko꞉lilo꞉ dimida꞉lab a꞉no꞉ ilikiyo꞉, kaluka꞉isale nolo꞉ mo꞉beaki, ililo꞉ nemo꞉lo꞉ ho꞉le sa꞉la꞉sen a꞉no꞉ ne dabu. ");
INSERT INTO bco_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","A꞉la꞉fo꞉ko꞉lo꞉ ne tina꞉sa꞉ga꞉, ililo꞉ man mogago꞉ dimida꞉lab a꞉no꞉ alobanama꞉no꞉ ko꞉lo꞉, nelo꞉ dabu aumbo꞉ hendele dimida꞉laba꞉le a꞉la꞉likiyo꞉, niyo꞉ ba꞉ba꞉no꞉.” Yawe eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","A꞉la꞉ta꞉ga꞉ kalu a꞉la꞉ nowo꞉ Sodom doba꞉da꞉ alobanaga꞉ta꞉ga꞉ ane. Ko꞉sega Yawe e Ablaham o꞉lia꞉ a꞉naka o꞉elen. ");
INSERT INTO bco_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ablaham e Yawe elo꞉wa ha꞉na꞉ga꞉yo꞉, a꞉la꞉dabu ba꞉ba꞉, “Giyo꞉ mogago꞉ kalu a꞉no꞉ yasalakiyo꞉, digalo꞉ kaluwo꞉lo꞉ yasala꞉ma꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Digalo꞉ kaluka꞉isale do꞉la꞉fo꞉ bila꞉fo꞉wo꞉ amisa꞉n a꞉namio꞉ alabo꞉lalega, giyo꞉ tambo yasala꞉ma꞉no꞉wa꞉le? Giyo꞉ digalo꞉ kaluwo꞉ asulakiyo꞉, amisa꞉n a꞉no꞉ o꞉li mesea꞉ki ta꞉fa꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Digalo꞉ kalu o꞉lia꞉ mogago꞉ kalu o꞉lia꞉yo꞉ giyo꞉ ua yasala꞉ma꞉no꞉ a꞉la꞉bo꞉ dimida꞉so꞉boka꞉! Giyo꞉ ko꞉lo꞉ a꞉la꞉dimidalega, kalu nafa o꞉lia꞉ mogago꞉ a꞉no꞉lia꞉yo꞉ falasilo꞉wo꞉ ua imilo꞉ dimia꞉ib. Ko꞉sega giyo꞉ man a꞉la꞉bo꞉ mada mo꞉dimida꞉sen. Henfelo꞉ amilo꞉ man aloba꞉dano꞉ ge ko꞉lo꞉, giyo꞉ kaluwa꞉lo꞉ man dimidab a꞉na ilikiyo꞉, wa꞉lo꞉ enedo꞉leyo꞉ aloba꞉da꞉sa꞉ga꞉ dimia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ablaham eyo꞉ a꞉la꞉sa꞉labiki, Yawe eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Digalo꞉ kalu do꞉la꞉fo꞉ bila꞉fo꞉wo꞉ Sodom amisa꞉n amio꞉ ba꞉dalega, niyo꞉ i a꞉no꞉ ko꞉lo꞉ asulakiyo꞉, kaluka꞉isaleyo꞉ tambo o꞉li mesea꞉ki ta꞉fa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ wa꞉ka a꞉la꞉sio꞉, “Ne ba o꞉ngo꞉malo꞉ngo꞉ kalu ko꞉sega, niyo꞉ Kalu Alanbo꞉wo꞉ towo꞉ sa꞉la꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Sodom amisa꞉n amio꞉, digalo꞉ kaluwo꞉ do꞉la꞉fo꞉ bila꞉fo꞉wo꞉ mo꞉dowaki, giyo꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉la꞉ta꞉ga꞉ bila꞉fo꞉ a꞉no꞉ko꞉ elena ba꞉dalega, tambo yasala꞉ma꞉no꞉wa꞉le?” A꞉la꞉dabu ba꞉dabiki, Yawe eyo꞉ a꞉ma꞉la꞉ a꞉la꞉sio꞉, “Do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉la꞉ta꞉ga꞉ bila꞉fo꞉ko꞉ a꞉lalega, niyo꞉ mo꞉yasala꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ wa꞉ka dabu ba꞉dakiyo꞉, “Do꞉la꞉fo꞉ fa꞉la꞉da꞉in dowalega, wagama꞉no꞉wo꞉?” “Do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉no꞉ko꞉ dowalega, niyo꞉ mo꞉dimidama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ wa꞉ka sio꞉, “Niyo꞉ wa꞉ka sa꞉ma꞉nigo꞉l ko꞉lo꞉, Kalu Alan giyo꞉ nemo꞉wo꞉ gadia꞉so꞉bo. Digalo꞉ kaluwo꞉ do꞉la꞉fo꞉ otalen ba꞉dalega, o꞉b dimidama꞉no꞉wo꞉?” Eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Do꞉la꞉fo꞉ otalen ba꞉dalega, niyo꞉ mo꞉dimidama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ a꞉la꞉sio꞉, “Kalu Alan gimo꞉wo꞉ niyo꞉ towo꞉ wa꞉ka a꞉sa꞉ma꞉nigo꞉l. Digalo꞉ kaluwo꞉ do꞉la꞉fo꞉ a꞉la꞉ ba꞉dalega, waima꞉no꞉wo꞉?” A꞉la꞉dabu ba꞉dabiki, eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Kalu do꞉la꞉fo꞉ a꞉la꞉ ba꞉dalega, niyo꞉ mo꞉yasala꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ wa꞉ka a꞉sa꞉laki, “Kalu Alan, niyo꞉ to imilise nowo꞉ ka sa꞉ma꞉nigo꞉l ko꞉lo꞉ ge gadia꞉so꞉bo. Digalo꞉ kaluwo꞉ do꞉la꞉fo꞉ a꞉no꞉ko꞉ ba꞉dalega, o꞉b dimidama꞉no꞉wo꞉?” Eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Digalo꞉ kaluwo꞉ do꞉la꞉fo꞉ eleno꞉lalega, niyo꞉ i asulakiyo꞉, tambowo꞉ mo꞉yasala꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yaweyo꞉ e o꞉lia꞉lo꞉ tola꞉leno꞉ eletakiyo꞉ ane. A꞉la꞉ta꞉ga꞉ Ablaham elo꞉ a꞉ma꞉la꞉ ene aya ane. ");
INSERT INTO bco_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","2","Lod e Sodom amisa꞉n amilo꞉ kegea꞉sendo꞉ tog anib a꞉na sen. Ga꞉lo dowabiki, ma꞉mula꞉ kalu a꞉la꞉ nowo꞉ ya꞉ga꞉, Sodom amisa꞉n a꞉na fa꞉la꞉dowo꞉. Lod e, a꞉la꞉ yab a꞉no꞉ ba꞉da꞉ga꞉yo꞉, e dasilia꞉ga꞉ a꞉la꞉yo꞉ galima꞉ni ane. E hena gulalu misa꞉fu alilaki, eyo꞉ a꞉la꞉sio꞉, “Ni kalu alan ga꞉go꞉, go꞉no꞉n nanog dian kaluwo꞉ ne ko꞉lo꞉, ga꞉go꞉ ni aya ya꞉ga꞉, gib ko꞉le to꞉go꞉da꞉sa꞉ga꞉, alima꞉ni mena. Alila꞉sa꞉ga꞉, kea꞉fole dasila꞉sa꞉ga꞉, ha꞉na꞉ni ha꞉na꞉bi.” Lod eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉ ko꞉sega a꞉la꞉ma꞉ sa꞉laki, “A, na꞉no꞉ mo꞉ha꞉na꞉no꞉. Na꞉no꞉ kegea꞉sen hen, ba wena alima꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Ko꞉sega Lod eyo꞉ halaido꞉ susia꞉la꞉ga꞉, a꞉la꞉yo꞉ e o꞉lia꞉ ha꞉na꞉ga꞉ ene aya tiane. A꞉la꞉ta꞉ga꞉ Lod eyo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ alan dimidaliaki, a꞉la꞉ta꞉ga꞉ falawa yisdo꞉ mo꞉difa꞉ a꞉no꞉lo꞉ soda꞉sa꞉ga꞉, a꞉la꞉mo꞉ maiya꞉ki dimi. ");
INSERT INTO bco_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","A꞉la꞉yo꞉ ma꞉no꞉wo꞉ na꞉sa꞉ga꞉, mo꞉ ali o꞉sen ami, Sodom amisa꞉n kalu so꞉wayo꞉lo꞉, kalu ko꞉go꞉dego꞉wo꞉lo꞉ tambo ya꞉sia꞉sa꞉ga꞉, a ilo꞉ sen a꞉no꞉ hege galifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Iliyo꞉ a a꞉no꞉ hege galia꞉takiyo꞉, Lodbo꞉wo꞉ a꞉la꞉ ho꞉le sio꞉, “Kalu a꞉la꞉, o꞉g ga꞉lolo꞉ gelo꞉ amilo꞉ yab a꞉no꞉ o꞉bamida꞉ saba? Kalu a꞉la꞉ a꞉no꞉ nilo꞉ da꞉ dimia꞉no꞉ asulab ko꞉lo꞉ ha꞉la꞉ wena tililia꞉ mena.” ");
INSERT INTO bco_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","A꞉la꞉sa꞉labiki Lod e ha꞉la꞉ya handalota꞉ga꞉, tog a꞉no꞉ e fa꞉s doba꞉da꞉ asida꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Niasi, man mogago꞉ wengo꞉wo꞉ dimida꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kalu a꞉la꞉ we, no꞉no꞉n tili dofo꞉lo꞉l ko꞉lo꞉, giliyo꞉ a꞉la꞉ wemo꞉wo꞉ mogago꞉ nowo꞉ dimida꞉so꞉bo! Ko꞉sega gio꞉ bo꞉ba. Ni na꞉la꞉ bolo꞉ a꞉la꞉ we, kalu o꞉lia꞉yo꞉ o꞉semo꞉ ali ko꞉lo꞉, gilido꞉ asulab au dimidama꞉ki, niyo꞉ gilo꞉wa tililia꞉ mia꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Ko꞉sega Sodom kalu iliyo꞉ Lodbo꞉wo꞉ a꞉la꞉sio꞉, “Ge fogo꞉ dimina! Ge hen nowo꞉ a꞉la꞉ta꞉ga꞉ mio꞉ ko꞉lo꞉, nio꞉ aloba꞉da꞉so꞉bo. Niliyo꞉ a꞉la꞉mo꞉lo꞉ dimidama꞉no꞉ o꞉leaumbo꞉, gemo꞉wo꞉ mada alande dimidama꞉nigo꞉l.” A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, iliyo꞉ Lodo꞉ a꞉ma꞉la꞉ kanilia꞉ga꞉, tog ifa꞉ya anilaki, togo꞉ bidima꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Ko꞉sega kalu a꞉la꞉ a usamilo꞉ sen a꞉ma꞉yo꞉ togo꞉ kolataki, Lod e dagiya susululia꞉ga꞉, a usa tandola꞉sa꞉ga꞉, togo꞉ a꞉na ifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","A꞉la꞉gabiki kalu tog amilo꞉ elen ili si a꞉no꞉ ko꞉ne alifelema꞉ki, a꞉la꞉ma꞉yo꞉ a꞉na dimido꞉ ko꞉lo꞉, so꞉wa iyo꞉lo꞉ ko꞉go꞉do꞉wo꞉lo꞉ tambo a togo꞉ keda꞉la꞉ga꞉ mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Kalu a꞉la꞉ma꞉yo꞉ Lodbo꞉ a꞉la꞉sio꞉, “Ge so꞉lo꞉ nolo꞉ amisa꞉n us wenamio꞉ elo꞉ saba꞉le? Kalu so꞉wa gilo꞉wo꞉lo꞉, ka꞉isale so꞉wayo꞉lo꞉, ge a꞉suwo꞉lo꞉, a꞉la꞉ta꞉ga꞉ so꞉lo꞉ nol gilo꞉wo꞉lo꞉ amisa꞉n wenamilo꞉ sab a꞉no꞉ tambo tililia꞉sa꞉ga꞉, hen we ta꞉ta꞉ga꞉ hamana. ");
INSERT INTO bco_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Mo꞉wo꞉ naino꞉ amisa꞉n we tambo yasala꞉ma꞉nigo꞉l. Kaluka꞉isaleya꞉lo꞉ man mogago꞉le ko꞉li ko꞉lilo꞉ dimida꞉lab a꞉na ilikiyo꞉, kaluka꞉isale nolo꞉ mo꞉beaki, ililo꞉ ho꞉le sa꞉la꞉len a꞉no꞉ Yawe e da꞉da꞉sa꞉ga꞉, amisa꞉n we na꞉nbo꞉ yasala꞉ma꞉ki iliga꞉fo꞉.” A꞉la꞉ma꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","A꞉la꞉fo꞉ko꞉lo꞉ Lodo꞉ e ha꞉na꞉sa꞉ga꞉, kalu so꞉wa ida꞉ a꞉la꞉lo꞉ same o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Yawe eyo꞉ amisa꞉n we yasala꞉ma꞉nigab ko꞉lo꞉, ga꞉go꞉ dasila꞉sa꞉ga꞉, hen we ta꞉ta꞉ga꞉ hamana.” Lod elo꞉ sa꞉lab a꞉no꞉ a꞉la꞉yo꞉ da꞉da꞉sa꞉ga꞉, i o꞉lia꞉ henema꞉niki sa꞉laba꞉le a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Kea꞉fo ho꞉letabiki, ma꞉mula꞉ kaluwa꞉yo꞉ Lodbo꞉wo꞉ susiaki a꞉la꞉sio꞉, “Ge o꞉lia꞉, ga꞉ ga o꞉lia꞉, ga꞉la꞉ a꞉la꞉ o꞉lia꞉, o꞉g a wenamilo꞉ sab a꞉no꞉ bo꞉bo꞉ge dasila꞉sa꞉ga꞉ hamana. Amisa꞉n wilo꞉ falasilo꞉ fa꞉la꞉doma꞉nigab a꞉ma꞉yo꞉ gi o꞉lia꞉ uwa yasalabena꞉ki, gio꞉ hamana.” ");
INSERT INTO bco_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ko꞉sega Lod e kele asulaki, bo꞉bo꞉gebo꞉ mo꞉ane. A꞉la꞉gabiki Yawe eyo꞉ e nofolakiyo꞉, ma꞉mula꞉ kalu a꞉la꞉ma꞉yo꞉ Loda꞉ dagiyo꞉lo꞉, ene ingaya꞉ dagiyo꞉lo꞉, ida꞉ a꞉la꞉ma꞉ dagiyo꞉lo꞉, iyo꞉ tambo gasilia꞉ga꞉, amisa꞉n ha꞉la꞉ya tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Iyo꞉ ha꞉la꞉ya handalotabiki, kalu imilig noma꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ sowabena꞉ki, bo꞉e nai hamana! Gio꞉ a꞉ma꞉la꞉bo꞉ bale ba꞉da꞉so꞉bo. A꞉la꞉ta꞉ga꞉ gio꞉ hen fua꞉lo꞉ usamio꞉ mo꞉saki ha꞉na꞉sa꞉ga꞉, misio꞉wa mesa꞉ni hamana. Gio꞉ a꞉la꞉dimidalega, mo꞉yasala꞉ma꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Ko꞉sega Lod eyo꞉ a꞉la꞉sio꞉, “Yagiliyo꞉! Gaino꞉ nemo꞉wo꞉ sagalakiyo꞉, mano꞉ mada nafale dimido꞉ ko꞉lo꞉, ne mo꞉soma꞉ki, giyo꞉ ne a꞉na asuwa꞉fa꞉ni mio꞉. Ko꞉sega misio꞉ a꞉no꞉ ko꞉na꞉ ko꞉lo꞉, ne a꞉namio꞉ semo꞉fa꞉la꞉dowo꞉ o꞉ a꞉laliki, Sodom a꞉no꞉ mogagakiyo꞉, ne o꞉lia꞉ mogaima꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Gaino꞉ bo꞉ba. Amisa꞉n ha꞉lula꞉su hono ko꞉na꞉ma a꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ ne sowabena꞉kiyo꞉, ne na꞉i ha꞉na꞉sa꞉ga꞉ a꞉namio꞉ ga꞉li mesa꞉no꞉ ko꞉lo꞉, ne amisa꞉n ba ha꞉lula꞉su a꞉na hamana꞉ki ta꞉foma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","A꞉la꞉ta꞉ga꞉ imilig noma꞉yo꞉ Lod emo꞉wo꞉ a꞉ma꞉la꞉ sa꞉laki, “Gilo꞉ dabu ba꞉dab a꞉no꞉, niyo꞉ o꞉li dimidama꞉no꞉. Amisa꞉n gilo꞉ da꞉feab a꞉no꞉ mo꞉mogagaki ga꞉li doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Gio꞉ amisa꞉n a꞉na bo꞉e nai hamana. Mo꞉wo꞉ ge a꞉namio꞉ o꞉semo꞉fa꞉la꞉dowo꞉ amio꞉, niyo꞉ nanogo꞉ nowo꞉ semo꞉ dimidama꞉no꞉.” Ma꞉mul kalu eyo꞉ a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ amisa꞉n a꞉no꞉ wiyo꞉ Soa a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ofo꞉ fa꞉la꞉dowabiki, Lod e Soa amisa꞉n a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","E a꞉na fa꞉la꞉dowabiki, akin halona a꞉la꞉ta꞉ga꞉ de o꞉lia꞉ u hudo꞉ o꞉lia꞉yo꞉ Yawe eyo꞉ Sodom o꞉lia꞉ Gomola o꞉lia꞉lo꞉ a꞉lab a꞉na timena꞉ki dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Amisa꞉n a꞉la꞉ a꞉no꞉lo꞉, hen fua꞉lo꞉ a꞉no꞉lo꞉, kaluka꞉isale amisa꞉n a꞉namilo꞉ seno꞉lo꞉, hen amilo꞉ fa꞉la꞉ndan kelego꞉ a꞉no꞉lo꞉ tambo mogagilaki yasala꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ko꞉sega Loda꞉ ingayo꞉, e tifa kuda꞉i yakiyo꞉, e a꞉ma꞉la꞉ bale ba꞉dabiki, so꞉lu dowaki, halaido꞉ u o꞉ngo꞉ dasi dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kea꞉fo a꞉naka Ablaham e dasila꞉sa꞉ga꞉, tamin amilo꞉ Yawe e o꞉lia꞉lo꞉ tola꞉len hen a꞉na a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","E a꞉na kagafo꞉likiyo꞉, fua꞉lo꞉ hen, Sodom o꞉lia꞉ Gomola o꞉lia꞉ a꞉no꞉ ololo ba꞉ba꞉ amio꞉, de ho꞉mo꞉no꞉ alan badio꞉ fa꞉la꞉dowabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ kaluka꞉isale hen fua꞉lo꞉ a꞉namilo꞉ sen a꞉no꞉ tambo yasalab amio꞉, Gode eyo꞉ Ablahamo꞉ asulaki, Lod e asufa꞉. Amisa꞉n hen us a꞉namilo꞉ eleno꞉ tambo yasala꞉ma꞉no꞉ dowabiki, Lod e mo꞉sanama꞉ki, e hen nowa iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lod e Soa amisa꞉n amilo꞉ mesa꞉no꞉wo꞉ tagilabiki, e o꞉lia꞉ ene ida꞉ a꞉la꞉ o꞉lia꞉yo꞉ misio꞉wa ha꞉na꞉sa꞉ga꞉, u aya sen. ");
INSERT INTO bco_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Iyo꞉ a꞉na siliki, ida꞉ wa꞉la꞉ba꞉yo꞉ ene ado tifbo꞉ sa꞉laki, “Henfelo꞉ wema꞉ mano꞉ kaluwo꞉ ga o꞉lia꞉ alila꞉sen ko꞉sega, a꞉la꞉do꞉ dimidama꞉no꞉wo꞉ kalu na꞉n o꞉lia꞉ alima꞉no꞉wo꞉ aundo꞉ma. A꞉la꞉ta꞉ga꞉ nain dowo꞉lo꞉ anaso꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","A꞉la꞉go꞉ko꞉lo꞉ nain so꞉lo꞉wo꞉ mo꞉edaki, dowa a꞉la꞉ta꞉ga꞉yo꞉ dowa꞉i ha꞉na꞉melea꞉ki, naino꞉ wain ho꞉no꞉ domo꞉ dimia꞉sa꞉ga꞉, na꞉no꞉ e o꞉lia꞉yo꞉ a꞉na alima꞉niki.” ");
INSERT INTO bco_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, o꞉g nulu a꞉namio꞉ wain ho꞉no꞉ iyamo꞉ maiya꞉ki dimi ko꞉lo꞉, iyayo꞉ na꞉sa꞉ga꞉ asugdo꞉ma dowabiki, ida꞉ wa꞉la꞉bo꞉ e o꞉lia꞉ ali. Ko꞉sega ida꞉ a꞉no꞉ e o꞉lia꞉ alilab a꞉la꞉bo꞉, Lod e mo꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ho꞉len no amio꞉ wa꞉la꞉ba꞉yo꞉ ene ado tifbo꞉ sa꞉laki, “Ali nuluwo꞉ ne do o꞉lia꞉ ali ko꞉lo꞉, nain dowa a꞉la꞉ta꞉ga꞉yo꞉ nain so꞉lo꞉wo꞉ mo꞉edaki dowa꞉i ha꞉na꞉melea꞉ki, o꞉g nuluwo꞉lo꞉ naino꞉ wain ho꞉no꞉ domo꞉ dimia꞉sa꞉ga꞉, ge e o꞉lia꞉ a꞉na alila꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, o꞉g nulu a꞉namio꞉lo꞉, wain ho꞉no꞉ iyamo꞉ maiya꞉ki dimi ko꞉lo꞉, ida꞉ tifo꞉ iyalo꞉wa ha꞉na꞉sa꞉ga꞉, e o꞉lia꞉ ali. Ko꞉sega ida꞉ a꞉no꞉ e o꞉lia꞉ alilab a꞉la꞉bo꞉, Lod e mo꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","A꞉la꞉dimida꞉sa꞉ga꞉ ida꞉ a꞉la꞉ a꞉no꞉ iya o꞉lia꞉ ali ko꞉lo꞉ a꞉la꞉yo꞉ a꞉na alelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Wa꞉la꞉ba꞉yo꞉ kalu so꞉wa ko꞉lo꞉ sa꞉la꞉lia꞉sa꞉ga꞉, ene wiyo꞉ Moab wikilo꞉. So꞉wa Moab a꞉na a꞉la꞉ta꞉ga꞉yo꞉, tif amio꞉ kaluka꞉isaleyo꞉ modo꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉, iyo꞉ o꞉go꞉ Moab kaluka꞉isale a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","A꞉la꞉ta꞉ga꞉ ado tifa꞉yo꞉lo꞉, kalu so꞉wa ko꞉lo꞉ sa꞉la꞉lia꞉sa꞉ga꞉, ene wiyo꞉ Ben-Ami wikilo꞉. So꞉wa Ben-Ami a꞉na a꞉la꞉ta꞉ga꞉yo꞉, tif amio꞉ kaluka꞉isale modo꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉, iyo꞉ o꞉go꞉ Amon kaluka꞉isale a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ablaham e Mamele hen a꞉namilo꞉ seno꞉ ta꞉ta꞉sa꞉ga꞉, Negeb hena ha꞉nakiyo꞉, Sul heno꞉ nol, Kades amisa꞉no꞉ nol a꞉lo꞉ us a꞉na sa꞉sen. Tif amio꞉ e Gela amisa꞉n a꞉namio꞉ mageso꞉ kalu o꞉ngo꞉ doma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Hen a꞉na silikiyo꞉, Ablaham eyo꞉ kaluka꞉isalemo꞉ sa꞉laki, “Sa꞉la we, ne nado” a꞉la꞉sa꞉la꞉sen. A꞉la꞉sio꞉ ko꞉lo꞉ Gela misa꞉ kalu, Abimeleg eyo꞉ Selayo꞉ e dia꞉no꞉ a꞉laki towo꞉ saga꞉fo꞉ ko꞉lo꞉, nolba꞉yo꞉ Selayo꞉ tililia꞉ yabiki a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","A꞉la꞉dimido꞉ ko꞉lo꞉ nulu no amio꞉, Abimeleg e ofolakiyo꞉, Godeyo꞉ elo꞉wa fa꞉la꞉dowaki a꞉la꞉sio꞉, “Ga gilo꞉ dia꞉no꞉ ko꞉lo꞉ tililia꞉mio꞉ ko, e o꞉ma kaluwa꞉yo꞉ di ko꞉lo꞉, ge mada soma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Ko꞉sega Abimeleg e Sa꞉la o꞉lia꞉yo꞉ semo꞉ ali ko꞉lo꞉ eyo꞉ a꞉la꞉sio꞉, “Kalu Alan, kaluwa꞉yo꞉ man mogago꞉wo꞉ mo꞉dimidalega, giyo꞉ kalu a꞉no꞉lia꞉ ene iasi kaluka꞉isale o꞉lia꞉yo꞉ sana soma꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ablaham eneno꞉sa a꞉la꞉sio꞉, ‘Ga we ne nado.’ A꞉la꞉ta꞉ga꞉ ga eyo꞉lo꞉ a꞉la꞉sio꞉, ‘Kalu we na꞉ nao.’ A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ ga we diakiyo꞉, no꞉no꞉n asulo꞉wo꞉ digalo꞉le dofo꞉liki, man digalo꞉le dimido꞉ a꞉la꞉asulo꞉l.” Abimeleg eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Abimeleg e ofolab us a꞉namio꞉, Godeya꞉ emo꞉ sa꞉laki, “Gi asulo꞉wo꞉ digalo꞉le dofo꞉liki dimido꞉ a꞉la꞉bo꞉ niyo꞉ asulo꞉. A꞉la꞉ta꞉ga꞉ ni siwa꞉l amio꞉lo꞉ man mogago꞉wo꞉ mo꞉dimidama꞉kiyo꞉, niyo꞉ ge ga we o꞉lia꞉yo꞉ mo꞉alima꞉ki go꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ ga we inbo꞉ a꞉ma꞉la꞉ iliga꞉ta꞉bi. Ablaham e Godeya꞉ tolo꞉ dinali sa꞉lan kalu ko꞉lo꞉, eyo꞉ ge dulugu sa꞉lalikiyo꞉, ge o꞉li mesa꞉ib. Ko꞉sega giyo꞉ ga we inbo꞉wo꞉ mo꞉iliga꞉talega, gelo꞉ a꞉la꞉ta꞉ga꞉ giasi kaluka꞉isaleyo꞉ tambo mada soma꞉ib.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Kea꞉fole Abimeleg e dasila꞉sa꞉ga꞉, ene nanog dian kaluwo꞉ ho꞉le kegea꞉sa꞉ga꞉, elo꞉ ofolo꞉ ba꞉ba꞉ a꞉no꞉ a꞉na malolabikiyo꞉, iyo꞉ a꞉no꞉ ko꞉lo꞉ da꞉dakiyo꞉ tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","A꞉la꞉ta꞉ga꞉yo꞉ Abimeleg eyo꞉ Ablahamo꞉ ho꞉lelia꞉ga꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ nimo꞉wo꞉ hala dimido꞉ka꞉! Ne mogago꞉ nowo꞉ gemo꞉lo꞉ mo꞉dimido꞉ ko꞉lo꞉, giyo꞉ hida꞉yo꞉ alan we ne o꞉lia꞉ niasi kaluka꞉isale o꞉lia꞉mo꞉lo꞉ dia꞉mio꞉wo꞉ mo꞉wo꞉ ha꞉? Man kaluwa꞉lo꞉ mo꞉dimidan a꞉no꞉ giyo꞉ nimo꞉ dimido꞉.” Abimeleg eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","A꞉la꞉ta꞉ga꞉ Abimeleg eyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gilo꞉ dimido꞉ a꞉no꞉, giyo꞉ waga asulaki dimido꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","A꞉la꞉dabu ba꞉dabiki Ablaham eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Nilo꞉ dimido꞉wo꞉ mo꞉wo꞉ we. Amisa꞉n wiyo꞉ Godeyo꞉ mo꞉tagila꞉sen ko꞉lo꞉, ne sana sowaki, ni gayo꞉ ili dia꞉ib a꞉la꞉bo꞉ no꞉no꞉no꞉ asulaki sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","A꞉la꞉ta꞉ga꞉ nilo꞉ sio꞉ a꞉no꞉, niyo꞉ hendele sio꞉. Mo꞉wo꞉ na꞉no꞉ dowo꞉ imilise, ko꞉sega e anowo꞉ ko꞉li ko꞉lo꞉, niyo꞉ e a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ne gayo꞉ dia꞉sa꞉ga꞉ elen amio꞉, Godeya꞉ nemo꞉ sa꞉lakiyo꞉, ‘Ge go꞉la꞉ heno꞉ kata꞉fo꞉ hamana’ a꞉la꞉sio꞉ ko꞉lo꞉, na꞉no꞉ ha꞉nakiyo꞉, niyo꞉ Selamo꞉wo꞉ a꞉la꞉sio꞉, ‘Hen o꞉bamida꞉ya꞉le na꞉ndo꞉ ha꞉nab a꞉namio꞉, giyo꞉ ne ha꞉fo꞉ disa꞉laki, a꞉la꞉sa꞉la꞉bi, “Kalu we ni nao.” ’ ” ");
INSERT INTO bco_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimeleg eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, sibiyo꞉lo꞉ kaowo꞉lo꞉ nanog dian kaluka꞉isale o꞉lia꞉ a꞉no꞉ Ablahambo꞉ dimiaki a꞉la꞉ta꞉ga꞉, ene inga Selayo꞉lo꞉ a꞉ma꞉la꞉ iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","A꞉la꞉dimidakiyo꞉ Abimeleg eyo꞉ Ablahambo꞉wo꞉ a꞉la꞉sio꞉, “Ge bo꞉ba. Hen we tambo nino꞉ ko꞉lo꞉, ge go꞉ndo꞉ asulab au ta꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","A꞉la꞉ta꞉ga꞉ eyo꞉ Selamo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ silba mole 1,000 a꞉no꞉ gi gaomo꞉ dimi. A꞉la꞉go꞉ko꞉lo꞉ kaluka꞉isale ge o꞉lia꞉lo꞉ sen a꞉ma꞉yo꞉, ge mogago꞉ imilise nowo꞉ mo꞉dimido꞉ a꞉la꞉bo꞉ ele bo꞉ba꞉kiyo꞉, niyo꞉ mole we a꞉na dimio꞉l ko꞉lo꞉, ge sendelowa꞉so꞉bo” Abimeleg eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Ablaham eyo꞉ Godemo꞉ dulugu sio꞉ ko꞉lo꞉, Gode eyo꞉ Abimelego꞉lo꞉, ingayo꞉lo꞉, ene nanogdo꞉ dian ka꞉isaleyo꞉lo꞉ tambo falele alifa꞉ ko꞉lo꞉ iyo꞉ so꞉wayo꞉ wa꞉ka o꞉li sa꞉la꞉la꞉ma꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Mo꞉wo꞉ tamin amio꞉ Abimeleg eyo꞉ Ablahama꞉ ene inga Selayo꞉ diabikiyo꞉, Yawe eyo꞉ Abimeleg e o꞉lia꞉lo꞉ sa꞉sen ka꞉isaleyo꞉ tambo so꞉walo꞉ mo꞉sa꞉la꞉lima꞉ki dimidalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yawe eyo꞉ Selayo꞉ sagale alitaki ya꞉sa꞉ga꞉yo꞉, tamin amilo꞉ enedo꞉ dinali sio꞉ a꞉no꞉ hendele dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","A꞉la꞉go꞉ko꞉lo꞉ Godeya꞉lo꞉ da꞉fe sio꞉ ho꞉len a꞉no꞉ fa꞉la꞉dowabiki, Ablaham e anaso꞉ dowa꞉sen ami, Sa꞉la e alela꞉sa꞉ga꞉, kalu so꞉wayo꞉ emo꞉ sa꞉la꞉me. ");
INSERT INTO bco_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Sa꞉la elo꞉ so꞉wa sa꞉la꞉me a꞉no꞉, Ablaham eyo꞉ ene wiyo꞉ Aisa꞉g wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","So꞉walo꞉ sa꞉la꞉li a꞉na a꞉la꞉ta꞉ga꞉ ho꞉len agelo꞉wo꞉ o fa꞉la꞉dowabikiyo꞉, Godeya꞉lo꞉ emo꞉lo꞉ saefa꞉ au dimidaki, eyo꞉ so꞉wa a꞉no꞉ do꞉go꞉fo꞉ hege gedeo꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aisa꞉gdo꞉ sa꞉la꞉li ho꞉len a꞉namio꞉, Ablaham e donayo꞉ do꞉la꞉lowo꞉wo꞉ do꞉la꞉fo꞉ ko꞉lo꞉ gulula꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","A꞉la꞉ta꞉ga꞉ Sa꞉la eyo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ ne sagale alitaki o꞉gema꞉ki ta꞉fo꞉ ko꞉lo꞉, kaluka꞉isale nolba꞉yo꞉ Godeya꞉lo꞉ dimido꞉ a꞉no꞉ da꞉da꞉ga꞉yo꞉, ne o꞉lia꞉yo꞉ sagalaki o꞉gema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","A꞉la꞉ta꞉ga꞉ eyo꞉ towo꞉ a꞉kudu sa꞉laki, “Tamin amio꞉ kaluka꞉isaleya꞉ sa꞉lakiyo꞉, ‘Sa꞉la e Ablaham emo꞉wo꞉ so꞉wayo꞉ mo꞉sa꞉la꞉meaki, bowo꞉lo꞉ mada mo꞉mea꞉ib’ a꞉la꞉asulaki sa꞉la꞉len. Ko꞉sega Ablaham e anaso꞉ dowa꞉sen ami, niyo꞉ kalu so꞉wayo꞉ emo꞉wo꞉ sa꞉la꞉me” Sa꞉la eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","A꞉la꞉ta꞉ga꞉ Aisa꞉g e anayaki bo na꞉leno꞉ edabikiyo꞉, Ablaham eyo꞉ kaluka꞉isaleyo꞉ tambo kegea꞉sa꞉ga꞉, ma꞉no꞉wo꞉ alan dowo꞉taki sagala꞉li mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Isib ka꞉isale, Ha꞉ga elo꞉ Ablahambo꞉lo꞉ so꞉wa sa꞉la꞉me a꞉ma꞉yo꞉ Aisa꞉g emo꞉lo꞉ dio꞉ge sa꞉lab a꞉no꞉ Selayo꞉ da꞉da꞉sa꞉ga꞉, eyo꞉ Ablahambo꞉wo꞉ a꞉la꞉sio꞉, “Nanog dian ka꞉isaleya꞉ inso꞉ a꞉no꞉, ni so꞉wa Aisa꞉g o꞉lia꞉yo꞉ dabuno꞉ mo꞉alobanama꞉ki asulab ko꞉lo꞉, giyo꞉ nanog dian ka꞉isale o꞉lia꞉ ene inso꞉ a꞉no꞉lia꞉yo꞉ ta꞉taki, ko꞉na꞉ iliga꞉foma” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Sa꞉la elo꞉ to sio꞉ a꞉no꞉ Ablaham e da꞉da꞉sa꞉ga꞉, ene so꞉wa asulakiyo꞉, e mo꞉beaki kele asulo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Ko꞉sega Gode eyo꞉ Ablaham emo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ nanog dian ga o꞉lia꞉ ene so꞉wa o꞉lia꞉ a꞉no꞉ mo꞉beakiyo꞉ kele asula꞉so꞉bo. Sa꞉la elo꞉ gemo꞉lo꞉ sa꞉lab o꞉leau dimidama. Mo꞉wo꞉ Aisa꞉g eya a꞉la꞉ta꞉ga꞉yo꞉ gi so꞉lo꞉wo꞉ a꞉na fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","A꞉la꞉ta꞉ga꞉ niyo꞉ nanog ka꞉isaleya꞉ so꞉wa eya a꞉la꞉ta꞉ga꞉yo꞉lo꞉, kaluka꞉isaleyo꞉ modo꞉ fa꞉la꞉doma꞉ki dimidama꞉no꞉, mo꞉wo꞉ so꞉wa a꞉no꞉ geya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Kea꞉fole dowabiki, Ablaham e dasila꞉sa꞉ga꞉, ma꞉no꞉ o꞉lia꞉ no꞉ do꞉go꞉f amilo꞉ ho꞉n wasu o꞉lia꞉yo꞉ Ha꞉ga e kelena ga꞉li alitakiyo꞉, so꞉wa a꞉no꞉ e o꞉lia꞉ hamana꞉ki iliga꞉fo꞉. A꞉la꞉yo꞉ ha꞉nakiyo꞉, Bilsiba kalulo꞉ma hen a꞉na nodola꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","A꞉la꞉yo꞉ sia꞉labiki, no꞉ do꞉go꞉f amilo꞉ ho꞉n wasu a꞉no꞉ kedefo꞉ ko꞉lo꞉, eyo꞉ so꞉wa a꞉no꞉ i galindo꞉ a꞉lab ha꞉g a꞉na ta꞉fo꞉. So꞉wayo꞉ a꞉na ta꞉taki, eyo꞉ a꞉la꞉asulo꞉, “No꞉no꞉no꞉ so꞉wa sowab a꞉no꞉ mo꞉ba꞉ba꞉no꞉” a꞉la꞉asulakiyo꞉, e o꞉fina꞉sa꞉ga꞉ ina꞉li mesa꞉ni ane. E a꞉na siliki ya꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Gode eyo꞉ kalu so꞉wa a꞉ma꞉lo꞉ ya꞉lab a꞉no꞉ dabu ko꞉lo꞉, Godeya꞉ ene ma꞉mul kalu a꞉ma꞉yo꞉ Hebene a꞉la꞉ta꞉ga꞉ Ha꞉ga emo꞉wo꞉ a꞉la꞉sio꞉, “Ha꞉ga, ge waigo꞉wo꞉? Ge tagila꞉so꞉bo! Kalu so꞉wa honona silikilo꞉ ya꞉la꞉lab a꞉no꞉ Gode eyo꞉ dabu. ");
INSERT INTO bco_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","E sowabena꞉kiyo꞉, ge dasilia꞉ ha꞉na꞉ga꞉, so꞉wa a꞉ma꞉ ene dagiya gasilia꞉ga꞉ e asulo꞉wo꞉ halale alifoma. Niyo꞉ eya a꞉la꞉ta꞉ga꞉yo꞉ kaluka꞉isaleyo꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","A꞉la꞉salitakiyo꞉ Gode eyo꞉ Ha꞉gaya꞉ ene siyo꞉ kolaetabikiyo꞉, e ho꞉n daido꞉wo꞉ a꞉na ba꞉ba꞉. Ba꞉da꞉ga꞉yo꞉ e ha꞉na꞉ga꞉, ho꞉no꞉ no꞉ do꞉go꞉fa wasulia꞉ga꞉, inso꞉mo꞉ maiya꞉ki dimi. ");
INSERT INTO bco_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ so꞉wa a꞉no꞉ tili dowabikiyo꞉, e a꞉na anayo꞉. E kalulo꞉ma hen a꞉na ilikiyo꞉, e da꞉lo꞉ sandima꞉no꞉ asulo꞉ kalu fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","E Balan kalulo꞉ma hen a꞉na silikiyo꞉, ene anowa꞉yo꞉ e Isib ga dima꞉ki nenela꞉sa꞉ga꞉, tili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ho꞉len no amio꞉, Abimeleg o꞉lia꞉ ene ame misa꞉ kaluwo꞉, Fikol o꞉lia꞉ma꞉yo꞉ Ablahambo꞉wo꞉ a꞉la꞉sio꞉, “Godeyo꞉ ge o꞉lia꞉ a꞉lab ko꞉lo꞉, kelego꞉ tambo gilo꞉ dimida꞉lab a꞉no꞉ nafale fa꞉la꞉dowa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ nemo꞉wo꞉lo꞉, ni so꞉wamo꞉wo꞉lo꞉, ni ma꞉mu imo꞉wo꞉lo꞉, dikidan man mo꞉dimida꞉mela꞉no꞉ a꞉la꞉likiyo꞉, giyo꞉ Godeya꞉ siwa꞉l amio꞉ nemo꞉wo꞉ dinali salifo꞉ma꞉ki asulo꞉l. Ko꞉sega nilo꞉ gemo꞉lo꞉ ha꞉fo꞉ disa꞉lan aumbo꞉, giyo꞉lo꞉ nimo꞉wo꞉lo꞉ ha꞉fo꞉wo꞉ a꞉la꞉disa꞉la꞉lubi. A꞉la꞉ta꞉ga꞉ hen wenamio꞉ ge mageso꞉ kalu o꞉ngo꞉ sen ko꞉lo꞉, giyo꞉ kaluka꞉isale hen wenamilo꞉ sab imo꞉wo꞉lo꞉ ha꞉fo꞉ disa꞉la꞉lubi. Giyo꞉ a꞉la꞉dinali sama” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","A꞉la꞉sa꞉labiki Ablaham eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Niyo꞉ a꞉la꞉dimidama꞉no꞉,” a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ko꞉sega Abimelega꞉ ene nanogdo꞉ dian kalu nolo꞉ ya꞉ga꞉, Ablahama꞉ ho꞉n daido꞉ imilig nowo꞉ ili bo꞉fo꞉mela꞉niki di ko꞉lo꞉, eyo꞉ Abimelegbo꞉wo꞉ towo꞉ hida꞉gi sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimelegbo꞉wo꞉ hida꞉gi sa꞉labiki, eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Giyo꞉ tamin amio꞉ nemo꞉wo꞉ mo꞉sio꞉ ko꞉lo꞉ ne mada mo꞉dabu eleno꞉, o꞉gka do꞉do꞉l. O꞉lo꞉ dimido꞉wo꞉lo꞉ ne babalab” Abimeleg eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","A꞉la꞉sa꞉labiki Ablaham eyo꞉ sibi o꞉lia꞉ kao o꞉lia꞉yo꞉ dia꞉ga꞉, Abimelegbo꞉ dimiabiki, a꞉la꞉yo꞉ asulo꞉wo꞉ imilise dowaki, towo꞉ a꞉na dinali saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Towo꞉ saeta꞉ga꞉yo꞉, Ablaham eyo꞉ sibi mala kalofo dom a꞉la꞉fo꞉ nolo꞉ aloba꞉da꞉sa꞉ga꞉, nodowa ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Sibi a꞉no꞉ ba꞉dakiyo꞉, Abimeleg eyo꞉ Ablahambo꞉wo꞉ a꞉la꞉dabu ba꞉daki, “Gilo꞉ sibi nolo꞉ aloba꞉da꞉sa꞉ga꞉lo꞉ ta꞉fo꞉ hono, mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ablaham eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ho꞉n we ni daido꞉ ko꞉lo꞉, kaluka꞉isaleya꞉yo꞉ hendele na꞉no꞉lo꞉b a꞉la꞉asuluma꞉ki, sibi kalofo dom a꞉la꞉fo꞉ we, ge dima” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","A꞉la꞉go꞉ko꞉lo꞉ a꞉la꞉ma꞉yo꞉ towo꞉ hen a꞉na dinali saefa꞉ ko꞉lo꞉ hen a꞉no꞉ wiyo꞉ Bilsiba a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","A꞉la꞉yo꞉ Bilsiba hen a꞉namio꞉ dinali saeta꞉ga꞉yo꞉, Abimeleg o꞉lia꞉ ene ame misa꞉ kalu Fikol o꞉lia꞉yo꞉, Filistia kaluka꞉isaleya꞉ hen a꞉na a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","A꞉la꞉yo꞉ a꞉ma꞉la꞉ ha꞉nabiki, Ablaham eyo꞉ i nowo꞉ Bilsiba a꞉na gelo꞉ ko꞉lo꞉, eyo꞉ Yawemo꞉ dulugu sa꞉laki, ene wiyo꞉ “Gode Mela꞉no꞉ Mela꞉no꞉ A꞉lab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","A꞉la꞉fo꞉ko꞉lo꞉ Ablaham e Filistia hen a꞉namio꞉, ho꞉leno꞉ modo꞉wo꞉ a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","A꞉ma꞉ fa꞉s amio꞉ Gode eyo꞉ Ablahamo꞉ da꞉fe ba꞉daki, emo꞉wo꞉ a꞉la꞉sio꞉, “Ablaham!” A꞉la꞉ho꞉idabiki Ablaham eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “O꞉ba, ne weko꞉” ");
INSERT INTO bco_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ a꞉la꞉sio꞉, “Giyo꞉ so꞉wayo꞉ imilig, Aisa꞉g a꞉no꞉ ge mada alan asula꞉sen ko꞉lo꞉, giyo꞉ so꞉wa a꞉no꞉ Molaya hen a꞉na tililia꞉ ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowalikiyo꞉, niyo꞉ misio꞉ nowo꞉ gemo꞉ walama꞉no꞉. Gemo꞉lo꞉ walama꞉no꞉ misio꞉ a꞉na ha꞉na꞉sa꞉ga꞉, giyo꞉ so꞉wa a꞉no꞉ nemo꞉ boba so꞉meaki dimia꞉bi.” Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ho꞉le bidabikiyo꞉, Ablaham e ha꞉na꞉no꞉wo꞉ donkiyo꞉ dimidalia꞉ga꞉, so꞉mea꞉no꞉ de hi a꞉no꞉ a꞉na basalela꞉. Eyo꞉ basalilia꞉sa꞉ga꞉yo꞉, ene so꞉wa Aisa꞉g o꞉lia꞉ ene nanogdo꞉ dian kalu a꞉la꞉ o꞉lia꞉yo꞉ tililia꞉sa꞉ga꞉, iyo꞉ hen Godeya꞉lo꞉ emo꞉lo꞉ sio꞉ a꞉na ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Iyo꞉ ho꞉len a꞉la꞉yo꞉ ha꞉na꞉la꞉ga꞉, ho꞉len asol dowabikiyo꞉, Ablaham eyo꞉ sigiliga꞉fo꞉ amio꞉, hen elo꞉ ha꞉na꞉no꞉ a꞉no꞉ ko꞉na꞉ elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","A꞉la꞉gabiki Ablaham eyo꞉ ene nanogdo꞉ dian kalu a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ donkiyo꞉ bo꞉fo꞉liki, wena yasi sa꞉bi. So꞉wa na꞉no꞉ halona ha꞉na꞉sa꞉ga꞉, Godemo꞉ wabudaki, ene wiyo꞉ dulugu sa꞉la꞉sa꞉ga꞉yo꞉, na꞉no꞉ a꞉ma꞉la꞉ mia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Ablaham eyo꞉ so꞉mea꞉no꞉ de hi a꞉no꞉ dia꞉sa꞉ga꞉, ene inso꞉ Aisa꞉gbo꞉ dima꞉ki dimi. A꞉la꞉ta꞉ga꞉ eneno꞉ helebesi o꞉lia꞉ de kudulia꞉gane o꞉lia꞉ a꞉no꞉ dia꞉sa꞉ga꞉, ida꞉ni ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","A꞉la꞉yo꞉ ha꞉na꞉ga꞉ ha꞉nakiyo꞉, Aisa꞉g eyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “Dowa.” A꞉la꞉sa꞉labiki “O꞉ba, ne weko꞉” a꞉la꞉sio꞉. Aisa꞉g eyo꞉ a꞉la꞉dabu ba꞉daki, “De kudulia꞉ mio꞉ o꞉lia꞉ de hi o꞉lia꞉yo꞉ welo꞉ka꞉, ko꞉sega sibi kalofo bobalo꞉ so꞉mea꞉no꞉ a꞉no꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","A꞉la꞉dabu ba꞉dabiki, Ablaham eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Ni so꞉wa, Godemo꞉lo꞉ boba so꞉mea꞉no꞉ sibi kalofo a꞉no꞉ Godeya꞉ ene dimia꞉ib.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ a꞉la꞉yo꞉ ha꞉na꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","A꞉la꞉yo꞉ ha꞉na꞉sa꞉ga꞉, Godeya꞉lo꞉ hen emo꞉lo꞉ sio꞉ a꞉na fa꞉la꞉dowakiyo꞉, Ablaham eyo꞉ uwo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉, imili alitakiyo꞉, de hiyo꞉ wa꞉la difa꞉. A꞉la꞉ta꞉ga꞉ ene inso꞉ Aisa꞉go꞉ meya꞉ mela꞉sa꞉ga꞉, ulo꞉ dibido꞉ a꞉na de hi wa꞉la difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ ene inso꞉wo꞉ sana soma꞉niki, dagiyo꞉ talagala꞉sa꞉ga꞉, helebesiyo꞉ a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ko꞉sega Yawe ene ma꞉mul kaluwa꞉yo꞉ Hebene halona ho꞉idaki a꞉la꞉sio꞉, “Ablaham, Ablaham.” “O꞉ba, ne weko꞉” Ablaham eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","A꞉la꞉ta꞉ga꞉ ma꞉mul kaluwa꞉ sa꞉laki, “Giyo꞉ so꞉wako sana sowa꞉so꞉bo. Emo꞉wo꞉ mogago꞉ imilise nowo꞉ dimida꞉so꞉bo! Mo꞉wo꞉ giyo꞉ so꞉wa imilise a꞉no꞉ mo꞉kidiaki, nemo꞉wo꞉ o꞉li dimi ko꞉lo꞉, ge Godeyo꞉ tagilaki, mada hendele kudu ha꞉nabo꞉lo꞉b a꞉la꞉bo꞉ niyo꞉ o꞉go꞉ asulo꞉l” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","A꞉la꞉sa꞉labiki Ablaham e sigili ba꞉ba꞉ amio꞉, yagilio꞉, sibi de imilise nowo꞉, biso꞉ i ha꞉lu nowa kowa꞉gila꞉fo꞉lena ba꞉ba꞉. A꞉no꞉ ba꞉da꞉ga꞉yo꞉, e ha꞉na꞉sa꞉ga꞉ sibi a꞉no꞉ dia꞉ga꞉, ene so꞉wayo꞉ mo꞉sana sowaki, eyo꞉ sibi de a꞉no꞉ Godemo꞉wo꞉ so꞉kugulu me. ");
INSERT INTO bco_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","A꞉la꞉fo꞉ko꞉lo꞉ Ablaham eyo꞉ hen a꞉no꞉ “Yawe Yaile” a꞉la꞉wikilo꞉. To a꞉ma꞉ ha꞉go꞉ we, “Yawe eyo꞉ dimia꞉ib.” A꞉la꞉ta꞉ga꞉ o꞉g a꞉namio꞉ kaluka꞉isale iliyo꞉ a꞉la꞉sa꞉la꞉sen, “Yawe ene misio꞉ a꞉namio꞉ dimia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","17","A꞉la꞉ta꞉ga꞉ Yaweya꞉ ene ma꞉mul kalu a꞉ma꞉yo꞉ Hebene a꞉la꞉ta꞉ga꞉ wa꞉ka ho꞉idakiyo꞉ a꞉la꞉sio꞉, “Ni wi Yawe a꞉na ilikiyo꞉, niyo꞉ a꞉la꞉dinali so꞉lo꞉l. Giyo꞉ ga꞉ so꞉wa imilise a꞉no꞉ mo꞉kidiaki, a꞉la꞉ka dimido꞉ ko꞉lo꞉, niyo꞉ gemo꞉ mada sagale alitakiyo꞉, gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉lab a꞉no꞉ akin amilo꞉ tamin gego꞉ o꞉ngo꞉ a꞉la꞉ta꞉ga꞉ ho꞉n amilo꞉ sa꞉ o꞉ngo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉. A꞉la꞉ta꞉ga꞉ gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉lab a꞉ma꞉yo꞉ gis kalu ilido꞉wo꞉ tiginilakiyo꞉, amisa꞉n ililo꞉wo꞉lo꞉ dima꞉ki ta꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉lab i a꞉na a꞉la꞉ta꞉ga꞉yo꞉, henfelo꞉ amilo꞉ so꞉lo꞉wo꞉ tambo nafale mesea꞉ki ta꞉fa꞉no꞉. Giyo꞉ ni towo꞉ kudu ane ko꞉lo꞉, niyo꞉ a꞉la꞉dimidama꞉no꞉.” Yawe eyo꞉ a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","A꞉la꞉go꞉ko꞉lo꞉ Ablaham e ene nanog kalu a꞉la꞉lo꞉wa a꞉ma꞉la꞉ ha꞉na꞉ga꞉, iyo꞉ egele Bilsiba a꞉na ha꞉na꞉ni ane. A꞉la꞉ta꞉ga꞉ e Bilsiba a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Tif amio꞉ kalu noma꞉yo꞉ Ablahambo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Gao Nahol ene inga Milka eyo꞉ kalu so꞉wayo꞉ modo꞉ ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","23","Wa꞉la꞉bo꞉ Us wikilo꞉, a꞉la꞉ta꞉ga꞉ a꞉ma꞉ fa꞉so꞉, Bus. Nowo꞉ Kemuel, nowo꞉ Kesed, nowo꞉ Haso, nowo꞉ Bildas, nowo꞉ Ya꞉dlab, a꞉la꞉ta꞉ga꞉ tifo꞉ Betuel” a꞉la꞉sio꞉. Milka eyo꞉ Ablahama꞉ ao Nahol emo꞉wo꞉ kalu so꞉wa ola꞉fo꞉ a꞉no꞉ ko꞉lo꞉ sa꞉la꞉me. Tif amio꞉ Kemuel eyo꞉ Alam ko꞉lo꞉ sa꞉la꞉li, a꞉la꞉ta꞉ga꞉ Betuel eyo꞉ La꞉ba꞉ga ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","A꞉la꞉ta꞉ga꞉ tif amio꞉ Nahol eyo꞉ ene nanog dian ga nowo꞉ ene a꞉di. Ga a꞉ma꞉ wiyo꞉ Leuma. Eyo꞉ Nahol emo꞉wo꞉ kalu so꞉wayo꞉ fa꞉la꞉da꞉in ko꞉lo꞉ sa꞉la꞉me. Wa꞉la꞉bo꞉ Teba, nowo꞉ Gaham, nowo꞉ Tahas, a꞉la꞉ta꞉ga꞉ tifo꞉ Maka ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Sa꞉la e donayo꞉ 127 a꞉la꞉fo꞉ a꞉no꞉ dota꞉ga꞉ sowo꞉. Ho꞉len a꞉namio꞉ e Ka꞉ina꞉n hen a꞉na sen ami, Kiliat Alba amisa꞉n, nowo꞉ wiyo꞉ Heblon, e a꞉na elena sowo꞉. E sowabikiyo꞉, Ablaham e kuo꞉ya꞉lab a꞉na tina꞉sa꞉ga꞉ nofolaki ya꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","4","E a꞉namilo꞉ ya꞉la꞉likilo꞉ sen a꞉no꞉ dasilia꞉sa꞉ga꞉ ha꞉nakiyo꞉, Hit kalu imo꞉wo꞉ a꞉la꞉sio꞉, “Ne mageso꞉ kaluwo꞉ o꞉ngo꞉ ya꞉ga꞉ gi o꞉lia꞉ sen ko꞉lo꞉, ni ga sowo꞉ we hen no꞉no꞉ndo꞉ kililiabde a꞉na dalima꞉no꞉ ko꞉lo꞉, hen heb gilo꞉wo꞉ nelo꞉ kililia꞉niki dimina,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Hit kalu iliyo꞉ Ablahambo꞉ a꞉ma꞉la꞉ sa꞉laki, “Kalu alan, ge nilido꞉ sa꞉ma꞉nigo꞉l we dabuma. Niliyo꞉ ina꞉lila꞉bo꞉ dalima꞉no꞉ hen nolo꞉ dimidaefa꞉ da꞉lab. Ni us wenamio꞉ ge wabulun kalu ko꞉lo꞉, giyo꞉ dalima꞉no꞉ hen nafale gilo꞉ ba꞉dab a꞉na daida꞉bi. Gi ga sowo꞉ a꞉no꞉, heno꞉ o꞉bamida꞉ya꞉le go꞉no꞉ndo꞉ dalima꞉no꞉ asulabde a꞉na dalima꞉no꞉ dowalega, hendo꞉ biso꞉ kalu a꞉ma꞉yo꞉ mo꞉ka꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","A꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉ga꞉yo꞉, Ablaham e dasila꞉sa꞉ga꞉, Hit hendo꞉ biso꞉ kalu iyo꞉ sagalema꞉ki, e misa꞉yo꞉ a꞉na gulu. ");
INSERT INTO bco_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ hendele a꞉naka dalima꞉ki asulalega, gio꞉ ha꞉na꞉sa꞉ga꞉ Sohal inso꞉ Eflon emo꞉wo꞉ dabu ba꞉ba꞉ni hamana. ");
INSERT INTO bco_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Makbela hen a꞉namio꞉, Eflona꞉ ene egelo꞉ anib amio꞉, ene u ayo꞉ nowo꞉ a꞉lab ko꞉lo꞉, hen a꞉no꞉ nemo꞉ dimina꞉ki, giliyo꞉ emo꞉ dabu ba꞉da꞉bi. Eyo꞉ nemo꞉wo꞉ dimialikiyo꞉, hen a꞉namilo꞉ mole elo꞉ da꞉feab aumbo꞉, niyo꞉ gili siwa꞉l amio꞉ a꞉na kililia꞉no꞉ ko꞉lo꞉, ni ga sowo꞉ a꞉no꞉ a꞉na dalima꞉no꞉” ");
INSERT INTO bco_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ablaham eyo꞉ a꞉la꞉sa꞉labikiyo꞉, Hit kalu Eflon elo꞉ kegeo꞉ us a꞉namio꞉ elen. Hit kalu o꞉lia꞉ kaluka꞉isale amisa꞉n toga꞉me a꞉namilo꞉ kegeo꞉ sen i a꞉ma꞉ si wa꞉l amio꞉, Eflon eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“A, a꞉la꞉ba. Kalu alan, ni to we dabuma. Niyo꞉ egelo꞉ hen o꞉lia꞉ u a o꞉lia꞉yo꞉ gemo꞉ madali dimio꞉l. Ni so꞉lo꞉wa꞉ si wa꞉l amio꞉ gemo꞉ ka dimio꞉l ko꞉lo꞉, sowo꞉ gilo꞉ a꞉no꞉ o꞉li dalima꞉ib.” Eflon eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ablaham eyo꞉ to a꞉no꞉ ko꞉lo꞉ da꞉dakiyo꞉, eyo꞉ hendo꞉ biso꞉ kalu kegeo꞉ imo꞉wo꞉ ene misa꞉yo꞉ wa꞉ka gulu. ");
INSERT INTO bco_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ hendo꞉ biso꞉ kalu kegeo꞉ a꞉no꞉ tambo dabuma꞉ki, Ablaham eyo꞉ Eflonbo꞉wo꞉ a꞉la꞉sio꞉, “To nilo꞉ sa꞉ma꞉nigo꞉l we, giyo꞉ dinafa dabuma. Nilo꞉ hen kililia꞉no꞉ mole ililo꞉ da꞉lab a꞉no꞉ gemo꞉ dimia꞉nigo꞉l ko꞉lo꞉, giyo꞉ o꞉li dia꞉ib a꞉la꞉asulo꞉l. Niyo꞉ heno꞉ kililia꞉sa꞉ga꞉yo꞉, sowo꞉ a꞉no꞉ a꞉na dalima꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","A꞉la꞉sa꞉labiki Eflona꞉ a꞉ma꞉la꞉ sa꞉laki, “Kalu alan, nilo꞉ so꞉lo꞉l we ge dabuma. Hen we silba mole 400 a꞉la꞉fo꞉ a꞉ma꞉ kililia꞉no꞉ dowo꞉, ko꞉sega na꞉no꞉ mole to nenela꞉mela꞉no꞉wo꞉ ka ta꞉foma. Ge sowo꞉wo꞉ ka daida꞉bi.” Eflon eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","A꞉la꞉fo꞉ko꞉lo꞉ Eflon elo꞉ Hit kaluwa꞉ si wa꞉l amilo꞉ to sio꞉ a꞉no꞉ Ablaham eyo꞉ kudu ha꞉naki, silba mole 400 a꞉la꞉fo꞉ a꞉no꞉ hendele dinafa aloba꞉da꞉sa꞉ga꞉, mole a꞉no꞉ emo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","A꞉la꞉fo꞉ko꞉lo꞉ Hit kalu o꞉lia꞉ kaluka꞉isale amisa꞉n toga꞉me a꞉namilo꞉ kegeo꞉ sen i a꞉ma꞉ si wa꞉l amio꞉, Eflon eyo꞉ Makbela hen us a꞉namilo꞉ egelo꞉wo꞉lo꞉, i a꞉namilo꞉ a꞉labo꞉lo꞉, a꞉la꞉ta꞉ga꞉ u ayo꞉lo꞉, a꞉no꞉ tambo Ablahambo꞉ dimi. Makbela hen a꞉no꞉, Mamele hen doba꞉da꞉yo꞉ ko꞉na꞉ma dowo꞉ ko꞉lo꞉, hen usamilo꞉ a꞉no꞉ Ablaham e kilili. ");
INSERT INTO bco_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","A꞉la꞉fo꞉ko꞉lo꞉ Ka꞉ina꞉n hen us a꞉namio꞉, Heblon amisa꞉n anib amio꞉, Mamele hen doba꞉da꞉, Makbela hen a꞉no꞉ Ablaham eyo꞉ dia꞉sa꞉ga꞉, inga Selayo꞉ u a usa a꞉nami daida꞉sa꞉ga꞉ difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tamin amio꞉ egelo꞉ o꞉lia꞉, u a a꞉no꞉lia꞉yo꞉ Hit kalu ilino꞉ dowo꞉ ko꞉sega Ablaham e kililia꞉sa꞉ga꞉ di. ");
INSERT INTO bco_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Ho꞉len a꞉namio꞉ Ablaham e mada anaso꞉ ulula꞉li. A꞉la꞉ta꞉ga꞉ kelego꞉ tambo elo꞉ dimida꞉i mio꞉ a꞉no꞉, Yawe eyo꞉ emo꞉wo꞉ sagale alitaki, nafale fa꞉la꞉doma꞉ki ta꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","3","Ablahama꞉ ene nanog dian kalu nowo꞉, e o꞉lia꞉lo꞉ eleno꞉ donayo꞉ modo꞉ gulula꞉ ko꞉lo꞉, ene kelego꞉wo꞉ tambo kalu emo꞉ bo꞉fo꞉melea꞉ki ta꞉ta꞉sen. A꞉la꞉ta꞉ga꞉ Ablaham eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gi dagiyo꞉ ni fe ha꞉ga golofo꞉laliki, Yawe Hebenelo꞉ biso꞉ o꞉lia꞉ henfelo꞉lo꞉ bo꞉fo꞉lab o꞉lia꞉ma꞉ ene si wa꞉l amio꞉, giyo꞉ mada a꞉la꞉dinali sa꞉la꞉bi. Giyo꞉ Aisa꞉go꞉ gayo꞉ dima꞉kiyo꞉, hen nelo꞉ so꞉l Ka꞉ina꞉n ga we, giyo꞉ mo꞉nenela꞉ma꞉no꞉ a꞉la꞉likiyo꞉ dinali sama. ");
INSERT INTO bco_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ko꞉sega giyo꞉ no꞉no꞉n amisa꞉ndeya ha꞉na꞉ga꞉, no꞉no꞉n so꞉lo꞉le us a꞉namio꞉, ni so꞉wa Aisa꞉ga꞉ ene gayo꞉ nenela꞉sa꞉ga꞉ sametakiyo꞉, ga a꞉no꞉ ko꞉lo꞉ tililia꞉ mia꞉no꞉, a꞉la꞉dinali sama.” ");
INSERT INTO bco_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","A꞉la꞉sa꞉labiki nanog kaluwa꞉ emo꞉wo꞉ a꞉ma꞉la꞉ dabu ba꞉daki, “Ga nilo꞉ nenela꞉sa꞉ga꞉lo꞉ same a꞉no꞉ ne o꞉lia꞉yo꞉ hen wilo꞉ mia꞉no꞉wo꞉ mo꞉bealega, niyo꞉ gi so꞉wayo꞉ go꞉no꞉n hen gilo꞉ ta꞉fo꞉ mio꞉ a꞉na a꞉ma꞉la꞉ tililia꞉ ha꞉na꞉niyo꞉?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ablahama꞉ a꞉ma꞉la꞉ sa꞉laki, “A, so꞉wa nilo꞉wo꞉ no꞉no꞉n hen a꞉namio꞉ a꞉ma꞉la꞉yo꞉ tililia꞉ ha꞉na꞉so꞉boka꞉! ");
INSERT INTO bco_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Yawe, Hebenelo꞉ a꞉lab Gode a꞉ma꞉yo꞉ ne dia꞉sa꞉ga꞉, ni dowa꞉ a o꞉lia꞉ so꞉lo꞉wa꞉ hen o꞉lia꞉ a꞉na a꞉la꞉ta꞉ga꞉ ne wena tililia꞉ yakiyo꞉, nemo꞉wo꞉ a꞉la꞉dinali sio꞉, ‘Niyo꞉ hen we so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab o꞉mo꞉ dimia꞉no꞉’ a꞉la꞉dinali sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ Gode imilise a꞉ma꞉yo꞉ ene ma꞉mul kaluwa꞉yo꞉ ge asuwa꞉foma꞉kiyo꞉ tamina iliga꞉fa꞉ib ko꞉lo꞉, giyo꞉ ni so꞉waya꞉ ga a꞉no꞉ o꞉li tililia꞉ mia꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ko꞉sega ga a꞉no꞉ ge o꞉lia꞉lo꞉ mia꞉no꞉wo꞉ mo꞉bealega, gilo꞉ nemo꞉lo꞉ dinali sio꞉ a꞉ma꞉yo꞉, ge mo꞉ta꞉liaki ga꞉li doma꞉ib. Ko꞉sega giyo꞉ ni so꞉wayo꞉ a꞉ma꞉la꞉bo꞉ no꞉no꞉n hen amio꞉ mada tililia꞉ ha꞉na꞉so꞉boka꞉!” Ablaham eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","A꞉la꞉gabiki nanog kaluwa꞉ dagiyo꞉ ene misa꞉ kalu, Ablahama꞉ fe ha꞉ga golofo꞉liki, elo꞉ to sio꞉ a꞉no꞉ tambo o꞉li dimidama꞉no꞉ a꞉la꞉li dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nanog kalu eyo꞉ dinali sa꞉la꞉sa꞉ga꞉yo꞉, Ablahama꞉ ene ka꞉mol do꞉la꞉fo꞉ nolo꞉ dia꞉b a꞉la꞉ta꞉ga꞉ ga fudo꞉ mea꞉no꞉ kelego꞉ nafale ko꞉li ko꞉lilo꞉ Ablaham elo꞉ dimidaefa꞉ a꞉no꞉ tambo dia꞉sa꞉ga꞉, nanog dian kalu e Mesobotemia hen ami Naholdo꞉ sen amisa꞉n a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","E a꞉na ha꞉na꞉sa꞉ga꞉, ga꞉lo amio꞉ ka꞉isalelo꞉ ho꞉ndo꞉ wa꞉fa꞉ yan ho꞉len a꞉no꞉ dowabiki, e amisa꞉n ha꞉la꞉ya ho꞉n daido꞉lo꞉ a꞉lab a꞉na fa꞉la꞉dowakiyo꞉, eyo꞉ ka꞉molo꞉ a꞉na fufulufo꞉melea꞉ki ta꞉ta꞉ga꞉ sen. ");
INSERT INTO bco_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","A꞉na silikiyo꞉, eyo꞉ Godemo꞉ dulugu sa꞉laki, “Wiso꞉ Yawe, ni misa꞉ Ablahama꞉ Godeyo꞉ ge ko꞉lo꞉, giyo꞉ ni misa꞉ Ablaham emo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉lakiyo꞉, nilo꞉ o꞉gdo꞉ nanog dimidama꞉nigo꞉l we nafa fa꞉la꞉doma꞉ki, ne asuwa꞉ta꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ne o꞉go꞉ ho꞉n daido꞉ anib wena kagafo꞉lo꞉l ko꞉lo꞉, amisa꞉n ka꞉isale iyo꞉ ho꞉n wa꞉fa꞉ mea꞉nigab. ");
INSERT INTO bco_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","A꞉la꞉ta꞉ga꞉ niyo꞉ ga bolo꞉ imilig o꞉mo꞉wo꞉ a꞉la꞉sa꞉ma꞉no꞉, ‘Go꞉fo꞉ gilo꞉ amilo꞉ ho꞉n wasu a꞉no꞉ nelo꞉ ma꞉ni dimena,’ a꞉la꞉dabu ba꞉ba꞉no꞉ ko꞉lo꞉, ga abeya꞉le a꞉ma꞉la꞉ sa꞉laki, ‘A꞉ ho꞉n we gelo꞉ maiya,’ a꞉la꞉ta꞉ga꞉ ‘Gi ka꞉mol o꞉mo꞉wo꞉lo꞉ ho꞉no꞉ maiya꞉ki mea꞉nigo꞉l’ ga abeya꞉le a꞉la꞉sa꞉lalega, ga a꞉no꞉ Gode gilo꞉ Aisa꞉g e dia꞉ib a꞉la꞉do꞉ da꞉feyo꞉wo꞉ elo꞉b a꞉la꞉asuluma꞉no꞉. Giyo꞉ a꞉la꞉dimidalega, giyo꞉ ni misa꞉ kalu Ablaham emo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉labo꞉lo꞉b a꞉la꞉asuluma꞉no꞉.” Nanog kalu eyo꞉ a꞉la꞉dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","E a꞉no꞉ ko꞉lo꞉ dulugu sa꞉la꞉len amio꞉, La꞉ba꞉ga e ho꞉ndo꞉ wa꞉fa꞉no꞉ go꞉fo꞉wo꞉ kelena dia꞉ga꞉ mio꞉. Ga bolo꞉ a꞉no꞉ Betuela꞉ ida꞉. Betuel a꞉no꞉ Milkaya꞉ so꞉wa. Milka e Nahola꞉ inga. Nahola꞉ ene aowo꞉ Ablaham. ");
INSERT INTO bco_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Ga bolo꞉ a꞉no꞉ mada gesego꞉ ko꞉lo꞉, e kaluwo꞉ semo꞉ ane. Gayo꞉ ho꞉n daido꞉wa tina꞉sa꞉ga꞉, ho꞉no꞉ go꞉fo꞉wa wasulia꞉ga꞉, kelena dia꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Dia꞉ fa꞉la꞉ndabikiyo꞉, nanogdo꞉ dian kalu a꞉no꞉ nai ha꞉na꞉ga꞉ galilia꞉ga꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gi go꞉fo꞉ amilo꞉ ho꞉n wasu ko, ha꞉lu nelo꞉ ma꞉ni dimina.” ");
INSERT INTO bco_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","A꞉la꞉dabu ba꞉dabikiyo꞉, ga a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “A꞉, kalu alan gelo꞉ maiya.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ e ho꞉n wasu a꞉no꞉ bo꞉bo꞉ge dia꞉ga꞉, elo꞉ maiya꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ga a꞉ma꞉yo꞉ emo꞉wo꞉ ho꞉no꞉ dimita꞉ga꞉yo꞉, a꞉la꞉sio꞉, “Gi ka꞉mol iyo꞉lo꞉ ho꞉no꞉ o꞉li maiya꞉kiyo꞉, ni wa꞉fa꞉ sala꞉mela꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","A꞉la꞉sa꞉la꞉sa꞉ga꞉ e bo꞉bo꞉ge ho꞉n wasu a꞉no꞉ isolo꞉wa koloda꞉sa꞉ga꞉, ho꞉n wa꞉fa꞉ni a꞉ma꞉la꞉ nai tiane. E ho꞉no꞉ wa꞉fa꞉ sala꞉leno꞉, ka꞉molo꞉ tambo na꞉li o꞉li dowabiki, a꞉na ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Ga a꞉ma꞉yo꞉ a꞉la꞉dimida꞉labikiyo꞉, nanog kalu e towo꞉ mo꞉sa꞉laka mobo꞉fo꞉liki, nanog elo꞉ dimidama꞉kilo꞉ iliga꞉fo꞉ a꞉no꞉ Yawe eyo꞉ a꞉no꞉ nafale ta꞉taba꞉le a꞉la꞉li asula꞉len. ");
INSERT INTO bco_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ka꞉mol iyo꞉ ho꞉no꞉ na꞉la꞉ga꞉ kedetabikiyo꞉, kalu a꞉ma꞉yo꞉ boba kelego꞉ gamo꞉ dimi. Boba dimi a꞉no꞉ mekalen imilig o꞉lia꞉ tamina a꞉la꞉ dagi amilo꞉ ka꞉ma꞉no꞉ a꞉no꞉ ko꞉lo꞉ dimi. Boba kelego꞉ dimi a꞉no꞉ go꞉la dimido꞉ ko꞉lo꞉ moleyo꞉ alana꞉ di. ");
INSERT INTO bco_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","A꞉la꞉ta꞉ga꞉ nanogdo꞉ dian kalu eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge go꞉lo꞉ o꞉ba? Go꞉la꞉ a amio꞉, ni welo꞉ alima꞉no꞉ fogo꞉ da꞉laba?” ");
INSERT INTO bco_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","A꞉la꞉dabu ba꞉dabiki, ga a꞉ma꞉ sa꞉laki, “Ni dowo꞉ Betuel, e Nahol o꞉lia꞉ Milka o꞉lia꞉ma꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Nili ayamio꞉ kalulo꞉ alima꞉no꞉ galala꞉yo꞉, a꞉la꞉ta꞉ga꞉ no꞉lo꞉ alima꞉no꞉ o꞉lia꞉ ma꞉no꞉ mea꞉no꞉ o꞉lia꞉yo꞉ da꞉lab.” ");
INSERT INTO bco_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","A꞉la꞉sa꞉labiki kalu a꞉no꞉ hena gulalu siliki, Yawe emo꞉wo꞉ sagalakiyo꞉ wabulu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Eyo꞉ dulugu sa꞉laki a꞉la꞉sio꞉, “Ni misa꞉ kalu Ablaham ene Gode Yawe emo꞉wo꞉ ne mada sagalo꞉. Mo꞉wo꞉ eyo꞉ ni misa꞉ kalumo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉la꞉sen a꞉la꞉ta꞉ga꞉ elo꞉ dinali sa꞉lab a꞉no꞉ hendele dimida꞉sen. A꞉la꞉ta꞉ga꞉ Yawe eyo꞉ nelo꞉ asuwa꞉takiyo꞉, ni misa꞉ kaluwa꞉ eso꞉lo꞉wa꞉ a wena dinafa tililia꞉ga꞉ ta꞉fa꞉ni mio꞉ ko꞉lo꞉, ne mada sagalab.” Eyo꞉ a꞉la꞉dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","A꞉la꞉fo꞉ko꞉lo꞉ ga bolo꞉ a꞉no꞉ nai ha꞉na꞉sa꞉ga꞉, e so꞉lo꞉lo꞉ sena malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","La꞉ba꞉ga eyo꞉ ene aowo꞉ Laban ko꞉lo꞉ e mekalen o꞉lia꞉ tamina La꞉ba꞉gaya꞉ dagi o amilo꞉ kalifa꞉ a꞉no꞉ ba꞉da꞉b, a꞉la꞉ta꞉ga꞉ kaluwa꞉lo꞉ La꞉ba꞉gamo꞉lo꞉ to sio꞉ a꞉no꞉lo꞉ da꞉da꞉la꞉ga꞉yo꞉, e bo꞉bo꞉ge ha꞉na꞉sa꞉ga꞉, ho꞉n daido꞉lo꞉wa kalu a꞉no꞉ ba꞉ba꞉ni ane. A꞉na fa꞉la꞉dowaki ba꞉ba꞉yo꞉, kalu a꞉no꞉ ene ka꞉mol o꞉lia꞉ kagafo꞉lena ba꞉da꞉ga꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","“Yawe eyo꞉ ge nafale mesea꞉ki ta꞉fo꞉ ko꞉lo꞉ ge mena. Gelo꞉ alima꞉no꞉ o꞉lia꞉ ka꞉moldo꞉ mesa꞉no꞉ o꞉lia꞉yo꞉ niyo꞉ dimidaefa꞉ ko꞉lo꞉, ge wenamio꞉ kagafo꞉lowa꞉so꞉bo. Ge mena.” ");
INSERT INTO bco_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","A꞉la꞉sa꞉labiki kalu a꞉no꞉ aya ane. Aya fa꞉la꞉dowabikiyo꞉, Laban eyo꞉ kelego꞉ ka꞉mol wa꞉l amilo꞉ difa꞉ a꞉no꞉ hena dila꞉sa꞉ga꞉, ka꞉moldo꞉ alima꞉no꞉ o꞉lia꞉ ma꞉no꞉ ma꞉no꞉ o꞉lia꞉yo꞉ a꞉na wido꞉. A꞉la꞉ta꞉ga꞉ Laban eyo꞉ ho꞉no꞉ wasulia꞉ ya꞉ga꞉, Ablahama꞉ ene nanog kalu o꞉lia꞉ e o꞉lia꞉lo꞉ mio꞉ kalu i o꞉lia꞉ma꞉ gido꞉fo꞉wo꞉ to꞉go꞉dema꞉ki dimi. ");
INSERT INTO bco_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","A꞉la꞉ta꞉ga꞉ ma꞉no꞉ so꞉fa꞉yo꞉ dia꞉ya꞉sa꞉ga꞉, imo꞉ maiya꞉ki dimi ko꞉sega, nanog kalu eyo꞉ ma꞉no꞉wo꞉ semo꞉nakiyo꞉ towo꞉ a꞉la꞉sio꞉, “O꞉gdo꞉ na꞉ mio꞉ we gimo꞉ ko꞉le fanda sa꞉la꞉sa꞉ga꞉, ma꞉no꞉ we a꞉na ma꞉no꞉.” Laban eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “O꞉li, giyo꞉ sama.” ");
INSERT INTO bco_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ a꞉la꞉sio꞉, “Ne Ablahama꞉ ene nanog kaluwo꞉ ne. ");
INSERT INTO bco_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yawe eyo꞉ ni misa꞉ kaluwo꞉ nafale mesea꞉ki ta꞉takiyo꞉, e wilo꞉ wabulun kalu fa꞉la꞉dowo꞉. Yawe eyo꞉ Ablahambo꞉wo꞉ kaowo꞉lo꞉, sibiyo꞉lo꞉, moleyo꞉lo꞉, ka꞉molo꞉lo꞉, donkiyo꞉lo꞉, nanog kaluka꞉isaleyo꞉lo꞉, emo꞉wo꞉ modo꞉ ko꞉lo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","A꞉la꞉ta꞉ga꞉ Ablahama꞉ ene inga Selayo꞉ anaso꞉ dowakiyo꞉, kalu so꞉wa imiligo꞉ sa꞉la꞉li ko꞉lo꞉, Ablaham eyo꞉ kelego꞉wo꞉ tambo ene so꞉wa o꞉mo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ni misa꞉ kalu Ablaham e Ka꞉ina꞉n hena sen ko꞉sega, niyo꞉ ene inso꞉wa꞉yo꞉ Ka꞉ina꞉n gayo꞉ mo꞉dia꞉no꞉ a꞉lakiyo꞉, niyo꞉ dinali sama꞉kiyo꞉ nemo꞉wo꞉ halale sio꞉. Ho꞉len a꞉namio꞉ eyo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉, ‘Nilo꞉ so꞉l Ka꞉ina꞉n hen wilo꞉ ka꞉isale so꞉wa sab we, na꞉ so꞉wa Aisa꞉gbo꞉wo꞉ samea꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ne so꞉lo꞉leyo꞉ ko꞉na꞉ sab, ko꞉sega ge a꞉na a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉yo꞉, ni so꞉waya꞉lo꞉ ga dia꞉no꞉wo꞉ a꞉na nenela꞉sa꞉ga꞉ samea꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","A꞉la꞉sa꞉labiki niyo꞉ emo꞉wo꞉ a꞉ma꞉la꞉ dabu ba꞉dakiyo꞉, ‘Ga nilo꞉ nenela꞉sa꞉ga꞉lo꞉ same a꞉no꞉ ne o꞉lia꞉yo꞉ hen wilo꞉ mia꞉no꞉wo꞉ mo꞉bealega, wama꞉no꞉wa꞉le?’ ");
INSERT INTO bco_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","A꞉la꞉dabu ba꞉ba꞉ amio꞉, eyo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉, ‘Ne Yawe towo꞉ kudu ha꞉na꞉sen ko꞉lo꞉, ge ha꞉nalikiyo꞉ ene ma꞉mul kaluwo꞉ ge o꞉lia꞉ iliga꞉fa꞉ib ko꞉lo꞉, eyo꞉ nilo꞉ nanog gemo꞉ dimidama꞉kilo꞉ iliga꞉to꞉l a꞉no꞉ nafale fa꞉la꞉do alifa꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ ni so꞉waya꞉ gayo꞉, no꞉no꞉n mo꞉mio꞉wa a꞉la꞉ta꞉ga꞉ no꞉no꞉n so꞉lo꞉ a꞉na a꞉la꞉ta꞉ga꞉yo꞉ o꞉li ka tililia꞉ mia꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ko꞉sega ge no꞉no꞉n mo꞉mio꞉lo꞉wa ha꞉na꞉ga꞉ fa꞉la꞉dowalikiyo꞉, iliyo꞉ Aisa꞉gbo꞉wo꞉ gayo꞉ mo꞉mia꞉no꞉ dowalega, gilo꞉ nemo꞉lo꞉ dinali sio꞉ a꞉ma꞉yo꞉ ge mo꞉ta꞉lia꞉b.’ Ablaham eyo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ ne ho꞉n daido꞉lo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉ silikiyo꞉, niyo꞉ a꞉la꞉dulugu sio꞉, ‘Ni misa꞉ Ablahama꞉ Godeyo꞉ ge ko꞉lo꞉, Yawe giyo꞉ nanog ni misa꞉ kalu elo꞉ nemo꞉ dimidama꞉kilo꞉ iliga꞉fo꞉ we nafa fa꞉la꞉doma꞉ki, ne asuwa꞉ta꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ne o꞉go꞉ ho꞉n daido꞉ anib wena so꞉l ko꞉lo꞉, amisa꞉n ga bolo꞉ nowo꞉ ho꞉n wa꞉fa꞉ni yalikiyo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉no꞉, “Go꞉fo꞉ gilo꞉ amilo꞉ ho꞉n wasu a꞉no꞉ nelo꞉ ma꞉ni dimena.” ");
INSERT INTO bco_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","A꞉la꞉ta꞉ga꞉ ga abeya꞉le a꞉ma꞉la꞉ sa꞉laki, “A꞉ ho꞉n we gelo꞉ maiya, a꞉la꞉ta꞉ga꞉ gi ka꞉mol o꞉mo꞉wo꞉lo꞉ ho꞉no꞉ maiya꞉ki mea꞉nigo꞉l” a꞉la꞉sa꞉lalega, ga a꞉no꞉ Yawe gilo꞉ Aisa꞉g e dia꞉ib a꞉la꞉do꞉ da꞉feyo꞉wo꞉ elo꞉b a꞉la꞉asuluma꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ne no꞉no꞉ asulo꞉ usamio꞉ Godemo꞉ a꞉la꞉dulugu sa꞉la꞉li elena, La꞉ba꞉ga e go꞉fo꞉wo꞉ kelena wa꞉la dia꞉ya꞉lena ba꞉ba꞉. E ho꞉n daido꞉lo꞉wa ti ha꞉na꞉sa꞉ga꞉, ho꞉no꞉ go꞉fo꞉wa wasulia꞉ fa꞉la꞉ndabiki, niyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ‘Ho꞉n gilo꞉ wasu ko, nelo꞉ ma꞉ni mena.’ ");
INSERT INTO bco_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","A꞉la꞉dabu ba꞉dabiki, ga a꞉ma꞉yo꞉ ho꞉n wasu kelen amilo꞉ dia꞉mio꞉ a꞉no꞉ bo꞉bo꞉ge dia꞉ta꞉ga꞉, nemo꞉ maiya꞉ki dimiakiyo꞉ a꞉la꞉sio꞉, ‘A꞉, gelo꞉ maiya. A꞉la꞉ta꞉ga꞉ gi ka꞉mol iyo꞉lo꞉ ho꞉no꞉ maiya꞉ki wasu mea꞉nigo꞉l.’ A꞉la꞉fo꞉ko꞉lo꞉ ne ho꞉no꞉ na꞉sa꞉ga꞉yo꞉, eyo꞉ ka꞉mol imo꞉wo꞉lo꞉ maiya꞉ki dimi. ");
INSERT INTO bco_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","A꞉la꞉gabiki niyo꞉ emo꞉wo꞉ ‘Ge abe ida꞉yo꞉?’ a꞉la꞉dabu ba꞉ba꞉ amio꞉, eyo꞉ nemo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, ‘Ni dowo꞉ Betuel, e Nahol o꞉lia꞉ Milka o꞉lia꞉ma꞉ inso꞉.’ Eyo꞉ a꞉la꞉sa꞉labiki, niyo꞉ mekaleno꞉ ene migiya kalitaki a꞉la꞉ta꞉ga꞉ taminayo꞉ dagi elo꞉wa kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","“A꞉la꞉ alitakiyo꞉ ne hena gulalu siliki, Yawemo꞉wo꞉ ne sagala꞉liki wabulu sio꞉. Ni misa꞉ kaluwa꞉ so꞉waya꞉ gayo꞉ dima꞉kiyo꞉, Yawe eyo꞉ toga digalo꞉leya tililia꞉ga꞉, ni misa꞉ kaluwa꞉ ene so꞉lo꞉lo꞉wa fa꞉la꞉doma꞉ki ta꞉fo꞉. A꞉la꞉fo꞉ko꞉lo꞉ ni misa꞉ kalu Ablahama꞉ ene Gode Yawe, emo꞉wo꞉ ne mada sagalo꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ ni misa꞉ kalu emo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉lan man o꞉lia꞉ man nafale o꞉lia꞉yo꞉ dimidaki gayo꞉ samena꞉ki asulalega, giliyo꞉ nemo꞉wo꞉ sama. Ko꞉sega gio꞉ nilo꞉ sio꞉ a꞉no꞉ mo꞉bealega, a꞉no꞉lo꞉ nemo꞉wo꞉ sama. Gililo꞉ sa꞉labo꞉ da꞉da꞉sa꞉ga꞉yo꞉, niyo꞉ waga dimidama꞉no꞉wa꞉le fanda asuluma꞉no꞉.” Ablaham ene nanog kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laban o꞉lia꞉ Betuel o꞉lia꞉ma꞉yo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Kelego꞉ o꞉gdo꞉ fa꞉la꞉dowab we Yawe enedo꞉ asulab au dimidabo꞉lo꞉biki, niliyo꞉ to nowo꞉ mo꞉sa꞉ma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Yawe elo꞉ wido꞉ aumbo꞉, La꞉ba꞉gayo꞉ we ko꞉lo꞉ gi misa꞉ kaluwa꞉ inso꞉ Aisa꞉ga꞉ ene inga doma꞉ki, tililia꞉ ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ablahama꞉ ene nanog kalu a꞉ma꞉yo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉, Yawe e wabuluma꞉ki hena gulalu asi. ");
INSERT INTO bco_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","A꞉la꞉ta꞉ga꞉ Ablahama꞉ ene nanog kalu a꞉ma꞉yo꞉ helebeso꞉g o꞉lia꞉ momadan kelego꞉ nafaleyo꞉, go꞉l o꞉lia꞉ silba o꞉lia꞉ dimido꞉ a꞉no꞉, La꞉ba꞉gamo꞉ dimia꞉sa꞉ga꞉yo꞉, boba kelego꞉ nafale nolo꞉ ene ao o꞉lia꞉ ano o꞉lia꞉mo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Bobayo꞉ dimia꞉sa꞉ga꞉yo꞉, Ablahama꞉ ene nanog kalu o꞉lia꞉ kalu e o꞉lia꞉lo꞉ mio꞉ i a꞉no꞉lo꞉ ma꞉no꞉wo꞉ na꞉sa꞉ga꞉, a꞉na ali. Kea꞉fowo꞉ iyo꞉ dasila꞉sa꞉ga꞉yo꞉, eyo꞉ a꞉la꞉sio꞉, “Nio꞉ misa꞉ kalulo꞉wa a꞉ma꞉la꞉ ha꞉na꞉nigo꞉l ko꞉lo꞉, giliyo꞉ ne hamana꞉ki ta꞉foma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Ko꞉sega La꞉ba꞉gaya꞉ ao o꞉lia꞉ ano o꞉lia꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ho꞉len do꞉la꞉fo꞉ a꞉no꞉ ninin o꞉lia꞉ o꞉dowa꞉sa꞉ga꞉yo꞉, La꞉ba꞉ga e a꞉na hamana꞉ki asulo꞉.” ");
INSERT INTO bco_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","A꞉la꞉sa꞉labiki eyo꞉ a꞉ma꞉la꞉ a꞉la꞉sio꞉, “Yawe eyo꞉ nelo꞉ nanog ni misa꞉ kalu elo꞉ nemo꞉ dimidama꞉kilo꞉ iliga꞉fo꞉ a꞉no꞉ nafale fa꞉la꞉do alifa꞉ ko꞉lo꞉ giliyo꞉ ni ha꞉na꞉no꞉wo꞉ ka꞉la꞉so꞉bo. Ne misa꞉lo꞉ amio꞉ hamana a꞉la꞉sama.” ");
INSERT INTO bco_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","A꞉la꞉sa꞉labiki, iliyo꞉ a꞉la꞉sio꞉, “Gaya꞉ ene towo꞉ da꞉ba꞉niki, ho꞉lema.” ");
INSERT INTO bco_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Iliyo꞉ La꞉ba꞉ga ho꞉lelia꞉sa꞉ga꞉, enebo꞉ dabu ba꞉ba꞉, “Ge kalu we o꞉lia꞉yo꞉ ha꞉na꞉nigaya?” “A꞉, ne ha꞉na꞉no꞉ka꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","A꞉la꞉fo꞉ko꞉lo꞉ La꞉ba꞉gayo꞉, elo꞉ ha꞉lu amilo꞉ fofo꞉ ka꞉isale a꞉no꞉lia꞉ dimidalia꞉sa꞉ga꞉, Ablahama꞉ nanog kalu o꞉lia꞉ e o꞉lia꞉lo꞉ mio꞉ a꞉no꞉ ha꞉na꞉ni dowabikiyo꞉, La꞉ba꞉gaya꞉ so꞉lo꞉ a꞉ma꞉yo꞉ “ha꞉na꞉biyo꞉” a꞉la꞉liki towo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Iliyo꞉ e sagala꞉li hamana꞉ki a꞉la꞉sio꞉, “Ni nado, geya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉wo꞉ mada alan fa꞉la꞉dowa꞉i hamana꞉ki asulab. So꞉lo꞉ gilo꞉ma꞉yo꞉ gis kalu nol ko꞉lo꞉ tinia꞉ mela꞉no꞉wo꞉ halaido꞉ dowa꞉melea꞉ki asulab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","La꞉ba꞉ga o꞉lia꞉ ene nanog ka꞉isale so꞉wa i o꞉lia꞉yo꞉ dasila꞉sa꞉ga꞉, ka꞉mol wa꞉la kandaya꞉sa꞉ga꞉yo꞉, Ablahama꞉ ene nanog kaluwo꞉ kudu ha꞉na꞉ni ane. A꞉la꞉dimidaki nanog kalu eyo꞉ La꞉ba꞉gayo꞉ dia꞉sa꞉ga꞉, a꞉ma꞉la꞉ tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Iyo꞉ a꞉ma꞉la꞉ ya꞉ga꞉ yabikiyo꞉, Aisa꞉g e Bil Lahai Loi amisa꞉no꞉ ta꞉ta꞉ga꞉, Negeb hen a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","A꞉na silikiyo꞉, ho꞉len nowo꞉ ga꞉lo dowabiki, e egelo꞉wa sia꞉liki, osolo ba꞉ba꞉ amio꞉ ka꞉mol nolo꞉ yabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","La꞉ba꞉ga eyo꞉lo꞉ sigiliga꞉takiyo꞉, Aisa꞉go꞉ ba꞉ba꞉ amio꞉ ka꞉mol wa꞉l amilo꞉ seno꞉ hena ho꞉luta꞉ga꞉yo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","“Kalu nilo꞉ galima꞉ findab a꞉no꞉ o꞉ba?” a꞉la꞉liki Ablahama꞉ nanog kalumo꞉ dabu ba꞉ba꞉. Nanog kaluwa꞉yo꞉ a꞉la꞉sio꞉, “Kalu a꞉no꞉ ni misa꞉ kaluwo꞉ o꞉m” a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ kalu a꞉ma꞉yo꞉ e migiyo꞉ ba꞉dabena꞉ki, La꞉ba꞉gaya꞉ ene migiyo꞉ helebeso꞉ga꞉ go꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Iyo꞉ gida꞉sa꞉ga꞉yo꞉, nanogdo꞉ dian kaluwa꞉yo꞉ elo꞉ dimida꞉i aneyo꞉ tambo Aisa꞉gbo꞉ malolome. ");
INSERT INTO bco_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","A꞉no꞉ da꞉da꞉sa꞉ga꞉, Aisa꞉g eyo꞉ La꞉ba꞉gayo꞉ anowa꞉ so꞉g aya tililia꞉gane. A꞉la꞉ta꞉ga꞉ La꞉ba꞉gayo꞉ a꞉na di. A꞉la꞉fo꞉ko꞉lo꞉ Aisa꞉g eyo꞉ ingayo꞉ alan asula꞉sa꞉ga꞉, emo꞉wo꞉ ha꞉fo꞉ disa꞉. A꞉la꞉ta꞉ga꞉ Aisa꞉ga꞉ anowo꞉ sota꞉ga꞉lo꞉ elen amilo꞉ kele asulo꞉ a꞉no꞉, La꞉ba꞉ga eyo꞉ Aisa꞉go꞉ ege alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ablaham eyo꞉ ga nowo꞉ di, ene wiyo꞉ Kedula. ");
INSERT INTO bco_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kedula a꞉ma꞉yo꞉lo꞉ kalu so꞉wa sa꞉la꞉la꞉yo꞉ we. Wa꞉la꞉bo꞉ Similan, nowo꞉ Yogsan, nowo꞉ Medan, nowo꞉ Midian, nowo꞉ Isbag, nowo꞉ Sua. Kalu so꞉wa elo꞉ sa꞉la꞉la꞉yo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yogsana꞉ ene kalu so꞉wayo꞉ Seba o꞉lia꞉ Dedan ko꞉lo꞉ sa꞉la꞉li. Dedan eya a꞉la꞉ta꞉ga꞉lo꞉ so꞉lo꞉ fa꞉la꞉dowo꞉wo꞉ Asul kaluka꞉isale, nowo꞉ Letus kaluka꞉isale, nowo꞉ Leum kaluka꞉isale. ");
INSERT INTO bco_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midiana꞉ ene kalu so꞉wayo꞉ Efa, nowo꞉ Efel, nowo꞉ Hanog, nowo꞉ Abida, nowo꞉ Elda ko꞉lo꞉ sa꞉la꞉li. Kalu i we tambo Kedula eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ablaham eyo꞉ ene dabuno꞉ tambo Aisa꞉g e dima꞉ki saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ko꞉sega Ablaham e o꞉silikiyo꞉, nanog dian ga a꞉la꞉ elo꞉ di a꞉ma꞉lo꞉ kalu so꞉wa sa꞉la꞉li i o꞉mo꞉wo꞉ boba kelego꞉wo꞉ sagalifa꞉. A꞉la꞉ta꞉ga꞉ ene so꞉wa Aisa꞉gbo꞉wo꞉ fogo꞉ dimina꞉kiyo꞉, Ablaham eyo꞉ iyo꞉ ofdo꞉ yan doba꞉da꞉ hen a꞉na iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Ablaham e donayo꞉ 175 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, elo꞉ ta꞉i mio꞉wo꞉ nafale ko꞉lo꞉, soma꞉no꞉ au sowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ e iasi dane ane sab o꞉lia꞉ galima꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","E sowabiki, ene so꞉wa Aisa꞉g dia꞉ Ismael dia꞉ma꞉yo꞉ ene do꞉mo꞉wo꞉ dia꞉ha꞉na꞉sa꞉ga꞉, Mamele hen anib a꞉namio꞉, Makbela amilo꞉ u a us a꞉na difa꞉. Tamin amio꞉ hen a꞉no꞉ Eflon eno꞉. E Hit kalu Sohala꞉ inso꞉ ko꞉lo꞉, Ablahama꞉ ingayo꞉ sowabi a꞉na dalima꞉no꞉ a꞉la꞉ta꞉ga꞉ kilili. A꞉la꞉fo꞉ko꞉lo꞉ Selalo꞉ daido꞉wa, Ablahamo꞉lo꞉ a꞉na daido꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Ablaham e sowa꞉sa꞉ga꞉ dowabikiyo꞉, ene so꞉wa Aisa꞉g e Gode eyo꞉ nafale mesea꞉ki ta꞉fo꞉len. Ho꞉len a꞉namio꞉ Aisa꞉g eyo꞉ Bil Lahai Loi hen aniba sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismaela꞉ ene eso꞉lo꞉ ta꞉i ane malolo꞉wo꞉ we. Ismael e Ha꞉gaya꞉ inso꞉. Ha꞉ga e Isib ka꞉isale ko꞉lo꞉ Selaya꞉ nanog dia꞉sen gayo꞉ e. Ablaham eyo꞉ e dia꞉sa꞉ga꞉yo꞉, Ismael ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","16","Ismaela꞉ inso꞉ a꞉la꞉ta꞉ga꞉ so꞉lo꞉ i amilo꞉ fa꞉la꞉dowo꞉ wi agelo꞉wo꞉ we. Wa꞉la꞉bo꞉ Nebayod, a꞉ma꞉ fa꞉so꞉ Kedal, a꞉ma꞉ fa꞉so꞉ Atabel, a꞉ma꞉ fa꞉so꞉ Mibsam, a꞉ma꞉ fa꞉so꞉ Misma, a꞉ma꞉ fa꞉so꞉ Duma, a꞉ma꞉ fa꞉so꞉ Masa, a꞉ma꞉ fa꞉so꞉ Hadad, a꞉ma꞉ fa꞉so꞉ Tema, a꞉ma꞉ fa꞉so꞉ Yedul, a꞉ma꞉ fa꞉so꞉ Nafis, a꞉la꞉ta꞉ga꞉ tifo꞉ Kedema. Wi sadelab a꞉no꞉ Ismaela꞉ inso꞉wo꞉ o꞉m. A꞉la꞉ta꞉ga꞉ wi a꞉no꞉ ili amisa꞉n o꞉lia꞉ hen ilo꞉ sa꞉sen a꞉no꞉lia꞉ a꞉no꞉ko꞉ wikilo꞉. A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa wena a꞉la꞉ta꞉ga꞉lo꞉ so꞉lo꞉ kugula꞉fo꞉ fa꞉la꞉dowo꞉wo꞉ wiyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael e donayo꞉ 137 a꞉la꞉fo꞉ a꞉no꞉ ta꞉ta꞉ga꞉ sowo꞉ ko꞉lo꞉, e iasi dane ane sab o꞉lia꞉ galima꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismaela꞉ ema꞉mu ilo꞉ mesa꞉ni aneyo꞉, Hafila a꞉na a꞉la꞉ta꞉ga꞉lo꞉ ta꞉i aneyo꞉ Sul hen a꞉na edo꞉. Isib a꞉la꞉ta꞉ga꞉ Asilia hena ha꞉nakiyo꞉, Sul hen a꞉no꞉ Isib o꞉lia꞉ eleya a꞉lab. A꞉la꞉ta꞉ga꞉ so꞉lo꞉ i a꞉no꞉ ao o꞉lia꞉yo꞉ egelebo꞉ ha꞉fa꞉nolowo꞉ mo꞉sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ablahama꞉ inso꞉ Aisa꞉g ene eso꞉lo꞉ ta꞉i ane malolo꞉wo꞉ we. Ablaham eyo꞉ Aisa꞉g sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Aisa꞉go꞉ donayo꞉ 40 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉sa꞉ga꞉, La꞉ba꞉gayo꞉ a꞉na di. La꞉ba꞉gaya꞉ iyayo꞉ Betuel a꞉la꞉ta꞉ga꞉ ene aowo꞉ Laban. Betuel o꞉lia꞉ Laban o꞉lia꞉yo꞉ Alam kalu ko꞉lo꞉ Mesobotemia a꞉na sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Aisa꞉ga꞉ ingayo꞉ fain dowabiki, e asuwa꞉foma꞉ki Yawemo꞉ dulugu sio꞉. Eyo꞉ a꞉la꞉gabiki, Yawe eyo꞉ elo꞉ to sio꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, La꞉ba꞉gayo꞉ asuwa꞉tabiki, a꞉na alelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","23","La꞉ba꞉ga e alela꞉likiyo꞉, so꞉wa ko꞉lo꞉ kufa꞉ us amilo꞉ sab a꞉no꞉ ida꞉nino꞉ ani tandelabiki, eyo꞉ a꞉la꞉asulo꞉, “Ni kufa꞉ usamilo꞉ dimidab we, wangaki gaba꞉le?” A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ a꞉la꞉asulakiyo꞉, Yawemo꞉ dabu ba꞉dabiki, Yawe eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gi kufa꞉ usamilo꞉ so꞉wa a꞉la꞉ sab koma꞉yo꞉, tif amio꞉ so꞉lo꞉ a꞉la꞉ alobanala꞉fa꞉ib. So꞉lo꞉ nowo꞉ halaido꞉ dowaki, nowo꞉ tiginila꞉ma꞉ib a꞉la꞉ta꞉ga꞉ wa꞉la꞉bo꞉ tifa꞉ nanog dian kalu doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","So꞉wa sa꞉la꞉lia꞉no꞉ ho꞉lende dowab a꞉namio꞉, hendele so꞉wayo꞉ a꞉la꞉ sab a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Kalu so꞉wa wa꞉la꞉b sa꞉la꞉liab a꞉no꞉ mada genelo꞉ a꞉la꞉ta꞉ga꞉ do꞉la꞉ma꞉ fo꞉ndo꞉ dowo꞉ ko꞉lo꞉, e Iso꞉ wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","A꞉ma꞉ fa꞉s amio꞉ ene aowo꞉ handalowakiyo꞉, eyo꞉ Iso꞉wa꞉ gido꞉fo꞉ doma ta꞉lidota꞉ga꞉ handalowo꞉ ko꞉lo꞉, so꞉wa a꞉no꞉ Ya꞉kob wikilo꞉. La꞉ba꞉ga eyo꞉ so꞉wa a꞉la꞉ a꞉no꞉ sa꞉la꞉liabikiyo꞉, Aisa꞉g e donayo꞉ 60 a꞉la꞉fo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","So꞉wa a꞉la꞉yo꞉ anaya꞉sa꞉ga꞉yo꞉, Iso꞉ e hena꞉ usa sia꞉liki, no꞉lo꞉ buluma꞉no꞉ kalu dowo꞉. Ko꞉sega Ya꞉kob e so꞉g a ka siliki, ha꞉fa꞉nolo dowa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisa꞉g e, Iso꞉ elo꞉ no꞉ bululakilo꞉ ho dia꞉yab a꞉no꞉ ma꞉no꞉wo꞉ alan asulab ko꞉lo꞉, eyo꞉ Iso꞉wo꞉ mada alan asulo꞉. Ko꞉sega La꞉ba꞉ga eyo꞉ Ya꞉kobo꞉ mada alan asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ho꞉len no amio꞉, Ya꞉kob eyo꞉ ma꞉no꞉ so꞉da꞉len amio꞉, Iso꞉ e hena꞉ usa a꞉la꞉ta꞉ga꞉ a꞉ma꞉la꞉ mio꞉. E halaido꞉lo꞉ma dowaki, maiyo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Iso꞉ eyo꞉ Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “Ne mada maiyab ko꞉lo꞉ ma꞉no꞉ gilo꞉ so꞉fa꞉ genelo꞉ ko, nelo꞉ dimina.” (Eyo꞉ a꞉la꞉sio꞉ ko꞉lo꞉, Iso꞉ ene wiyo꞉ nowo꞉ Idom.) ");
INSERT INTO bco_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ma꞉no꞉ we gemo꞉ o꞉li dimia꞉no꞉ ko꞉sega giyo꞉ kelego꞉ nowo꞉ nemo꞉ ko꞉le dimina. Ge wa꞉la꞉b ko꞉lo꞉, dowa꞉ dabun nafaleyo꞉ wa꞉la꞉ba꞉ dian. Ko꞉sega o꞉go꞉ giyo꞉ ‘wa꞉la꞉bo꞉ ge dowab’ a꞉la꞉sa꞉lalega, niyo꞉ ma꞉no꞉ we gemo꞉wo꞉ a꞉na mea꞉no꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Iso꞉ eyo꞉ a꞉la꞉sio꞉, “Ne maiyo꞉wo꞉ alan dowaki, soma꞉no꞉wo꞉ o꞉ngo꞉ dowab ko꞉lo꞉, ne maiyo꞉ sowalega, wa꞉la꞉b so꞉wa wi a꞉ma꞉yo꞉ waga asuwa꞉fa꞉iba?” ");
INSERT INTO bco_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ya꞉kob eyo꞉ towo꞉ a꞉la꞉sio꞉, “Ge tamina Godeya꞉ si wa꞉l amio꞉ dinali saefoma.” A꞉la꞉fo꞉ko꞉lo꞉ Iso꞉ eyo꞉ dinali sa꞉la꞉sa꞉ga꞉ dimiabiki, Ya꞉kob e wa꞉la꞉b o꞉ngo꞉wo꞉ a꞉na dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","A꞉la꞉dinali sa꞉la꞉sa꞉ga꞉, Ya꞉kob eyo꞉ falawa so꞉fa꞉ o꞉lia꞉ ta꞉ya꞉la꞉ so꞉fa꞉ ho꞉n wo꞉gelo꞉ o꞉lia꞉yo꞉ Iso꞉ e maiya꞉ki dimi. E ma꞉no꞉ a꞉no꞉ ho꞉n o꞉lia꞉ na꞉la꞉ga꞉, a꞉na ane. A꞉la꞉go꞉ko꞉lo꞉ Iso꞉ e iyayo꞉ sowakilo꞉ dabun kelego꞉ emo꞉lo꞉ dimia꞉no꞉ a꞉no꞉ mo꞉beaki, eyo꞉ o꞉ngo꞉malo꞉ngo꞉ a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ho꞉len no amio꞉, Ka꞉ina꞉n hen amio꞉ maiyo꞉wo꞉ alan fa꞉la꞉dowo꞉. Tamin amilo꞉ Ablaham ho꞉len amilo꞉ fa꞉la꞉dowo꞉ o꞉ngo꞉ dowabiki, Aisa꞉go꞉ Gela amisa꞉na ha꞉na꞉sa꞉ga꞉, Filistia misa꞉ kalu Abimelego꞉ ba꞉ba꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","E a꞉na sab amio꞉, Yaweyo꞉ elo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉, to nowo꞉ a꞉la꞉sio꞉, “Ge Isib hen a꞉namio꞉ ha꞉na꞉so꞉bo! Niyo꞉ hen gelo꞉ mesa꞉no꞉wo꞉ dinali sa꞉ma꞉no꞉ ko꞉lo꞉, ge hen wena dowa꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Ge hen wena mio꞉ kalu o꞉ngo꞉ o꞉ta꞉bi. Ge wenamilo꞉ sab a꞉namio꞉, niyo꞉ ge o꞉lia꞉ dowaki, nafale mesea꞉ki ta꞉fa꞉no꞉. Hen we tambo niyo꞉ ge o꞉lia꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab i o꞉mo꞉ dimia꞉no꞉. Nilo꞉ go꞉l Ablahambo꞉lo꞉ dinali sio꞉ o꞉leau dimidama꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉lab i a꞉no꞉ akin amilo꞉ tamin gego꞉ o꞉ngo꞉ fa꞉la꞉doma꞉ki ta꞉takiyo꞉, hen we tambo imo꞉ dimia꞉no꞉. I a꞉na a꞉la꞉ta꞉ga꞉yo꞉, henfelo꞉ amilo꞉ so꞉lo꞉ mesa꞉ib a꞉no꞉ tambo nafale mesea꞉ki ta꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Mo꞉wo꞉ Ablaham eyo꞉ nilo꞉ to sio꞉wo꞉ da꞉da꞉ga꞉, nilo꞉ asulab a꞉no꞉lo꞉, man nilo꞉ widab a꞉no꞉lo꞉, nilo꞉ to saefa꞉ a꞉no꞉lo꞉, nilo꞉ ele difa꞉ a꞉no꞉lo꞉, eyo꞉ tambo kudu ane.” Yawe eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","A꞉la꞉sa꞉labikiyo꞉ Aisa꞉g e Gela hen a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Amisa꞉n kaluwa꞉yo꞉ La꞉ba꞉ga we o꞉b gaya꞉le a꞉la꞉liki dabu ba꞉dabiki, Aisa꞉g eyo꞉ a꞉la꞉sio꞉, “Ga we na꞉ nado.” Mo꞉wo꞉ La꞉ba꞉ga e gesego꞉ ko꞉lo꞉, “e ni ga” a꞉la꞉sa꞉lalega, amisa꞉n kaluwa꞉yo꞉ e sa꞉nda꞉sa꞉ga꞉, La꞉ba꞉gayo꞉ ili dia꞉ib a꞉la꞉asula꞉sa꞉ga꞉, Aisa꞉g e tagilaki dikili sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Aisa꞉g e ho꞉len modo꞉wo꞉ a꞉naka o꞉sen ko꞉lo꞉, tif amio꞉ Filistia misa꞉ kalu, Abimelego꞉ ene aya silikiyo꞉, ho꞉guluwa ololo ba꞉ba꞉ amio꞉, Aisa꞉g dia꞉ La꞉ba꞉ga o꞉lia꞉yo꞉ inga o꞉lia꞉lo꞉ ege dowan o꞉leau heya꞉labi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","A꞉la꞉dimida꞉labi ba꞉da꞉sa꞉ga꞉, Abimeleg eyo꞉ Aisa꞉go꞉ ho꞉lelia꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “La꞉ba꞉gako, ga꞉ galo꞉bo꞉ka꞉! Giyo꞉ ‘na꞉ nado’ a꞉la꞉bo꞉ waga dikili sio꞉wo꞉?” A꞉la꞉sa꞉labiki Aisa꞉g eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu noma꞉yo꞉ La꞉ba꞉gayo꞉ e dia꞉no꞉ asulakiyo꞉, ne sa꞉ma꞉ib a꞉la꞉asula꞉sa꞉ga꞉, ne tagilaki a꞉na dikili sio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, Abimeleg eyo꞉ a꞉la꞉sio꞉, “Man gilo꞉ dimido꞉ a꞉no꞉, mogago꞉ dimido꞉. Mo꞉wo꞉ kalu noma꞉yo꞉ ga gilo꞉ ko hendele tililia꞉ga꞉ e o꞉lia꞉ ali kibo꞉bowo꞉, gilo꞉ hala dimido꞉ a꞉na ilikiyo꞉, ni amio꞉ mogago꞉wo꞉ o꞉li fa꞉la꞉domabe,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","A꞉la꞉fo꞉ko꞉lo꞉ Abimeleg eyo꞉ towo꞉ kalaba saetaki, “Kalu abeyo꞉ kalu we o꞉lia꞉ ene inga o꞉lia꞉yo꞉ golalega, kalu a꞉no꞉ sana soma꞉no꞉ka꞉,” a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","13","Aisa꞉g eyo꞉ hen a꞉namio꞉ eyo꞉ gelo꞉ ko꞉lo꞉ dona imilig a꞉namio꞉ eyo꞉ fa꞉la꞉nda꞉sa꞉ga꞉ hendeyo꞉ modo꞉ hedakiyo꞉, Aisa꞉g eyo꞉ ma꞉no꞉wo꞉ hendeyo꞉ mada modo꞉ di. Yawe eyo꞉ Aisa꞉go꞉ nafale mesea꞉ki ta꞉fo꞉ ko꞉lo꞉, e wilo꞉ kalu alan dowo꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ kelego꞉ modo꞉ nolo꞉ dia꞉ha꞉na꞉sa꞉ga꞉ e wilo꞉ kalu alan fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","15","Aisa꞉g eyo꞉ sibiyo꞉lo꞉, kaowo꞉lo꞉, no꞉ fofo꞉wo꞉lo꞉ a꞉la꞉ta꞉ga꞉ ene nanog dian kaluka꞉isaleyo꞉lo꞉ modo꞉ fa꞉la꞉losoda꞉i ane. Filistia kalu iliyo꞉ kelego꞉ elo꞉ a꞉no꞉ nafale fa꞉la꞉dowab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, eteyo꞉wo꞉ e o꞉lia꞉yo꞉ alan fa꞉la꞉dowo꞉. A꞉la꞉go꞉ko꞉lo꞉ iliyo꞉ ene ho꞉n daido꞉ a꞉no꞉ tambo hena꞉ dali ko꞉ne alifelo꞉. Ho꞉n daido꞉ tadowo꞉la꞉i ha꞉nab a꞉no꞉ tamin amio꞉ Ablahama꞉ ene nanog kaluwa꞉ dali alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abimeleg eyo꞉ Aisa꞉gbo꞉wo꞉ a꞉la꞉sio꞉, “Ge mada kalu halaido꞉ fa꞉la꞉dowaki, nio꞉ mada ge tiniab ko꞉lo꞉ ge nio꞉ ta꞉ta꞉ga꞉, hen nowa mesa꞉ni hamana꞉ki asulab.” ");
INSERT INTO bco_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","A꞉la꞉sa꞉labikiyo꞉ Aisa꞉g eyo꞉ hen a꞉no꞉ ta꞉ta꞉ga꞉, Gela fua꞉lo꞉ hen a꞉na mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Hen a꞉namio꞉ Ablaham elo꞉ ho꞉n dali alifelo꞉ nolo꞉ dowo꞉. Ablaham e sowabikiyo꞉ Filistia kalu iliyo꞉ ho꞉n daido꞉ a꞉no꞉ tambo hena꞉ ko꞉ne alifelo꞉. Ko꞉sega Aisa꞉g eyo꞉ a꞉ma꞉la꞉ dali alifelo꞉. A꞉ma꞉la꞉ dali alitakiyo꞉, ho꞉n daido꞉ a꞉no꞉ iyaya꞉lo꞉ wikilo꞉ o꞉leaumbo꞉ wa꞉ka wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","A꞉la꞉ta꞉ga꞉ Aisa꞉ga꞉ no꞉lo꞉ bo꞉fo꞉lowan kalu iliyo꞉ Gela fua꞉lo꞉ hen a꞉nami daida꞉sa꞉ga꞉, ho꞉n si nowo꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Ko꞉sega Gela amisa꞉na꞉ no꞉lo꞉ bo꞉fo꞉lowan kalu iyo꞉ ya꞉sa꞉ga꞉, ho꞉n si a꞉no꞉ inino꞉ a꞉laki balaido꞉. A꞉la꞉gabiki Aisa꞉ga꞉ ene no꞉lo꞉ bo꞉fo꞉lowan kalu i o꞉lia꞉ ho꞉n si a꞉no꞉ tadowo꞉laki kego꞉ ko꞉lo꞉, Aisa꞉g eyo꞉ ho꞉n si a꞉no꞉ Eseg a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","A꞉ma꞉ fa꞉s amio꞉ Aisa꞉ga꞉ ene nanog kalu iliyo꞉ ho꞉n si nowo꞉ daido꞉ ko꞉sega, Gela kalu iliyo꞉ wa꞉ka tadowo꞉labiki, Aisa꞉ga꞉yo꞉ ho꞉n daido꞉ a꞉no꞉ Sitna a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","A꞉la꞉go꞉ko꞉lo꞉ Aisa꞉g eyo꞉ ho꞉n daido꞉ a꞉no꞉ ka ta꞉ta꞉ga꞉, ho꞉n si nowo꞉ daido꞉ amio꞉, amisa꞉n kaluwa꞉yo꞉ e o꞉lia꞉yo꞉ mo꞉kegaki ka ta꞉fo꞉ ko꞉lo꞉, ho꞉n daido꞉ a꞉no꞉ Lehobot a꞉la꞉wikilo꞉. Eyo꞉ a꞉la꞉sio꞉, “Yawe eyo꞉ o꞉go꞉ nimo꞉wo꞉ fogo꞉ dimiabo꞉lo꞉biki, nio꞉ hen wenamio꞉ siliki nanogo꞉ dialikiyo꞉, nafa fa꞉la꞉doma꞉ib” Aisa꞉g eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Tif amio꞉ hen a꞉no꞉ ta꞉ta꞉ga꞉, Aisa꞉g e Bilsiba hen a꞉na mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","O꞉g elo꞉ fa꞉la꞉dowo꞉ nulu a꞉namio꞉ Yawe e elo꞉wa fa꞉la꞉dowaki a꞉la꞉sio꞉, “Ne gi go꞉l Ablahama꞉ Godeyo꞉ ne. Ne ge o꞉lia꞉ dowo꞉l ko꞉lo꞉, ge tagila꞉so꞉bo! Niyo꞉ ge nafa mesea꞉ki ta꞉fa꞉no꞉, a꞉la꞉ta꞉ga꞉ gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉mela꞉ib a꞉no꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉. Niyo꞉ ni nanog kalu Ablaham e alan asulo꞉ ko꞉lo꞉, niyo꞉ gemo꞉wo꞉ a꞉la꞉ka dimidama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yawe eyo꞉ a꞉la꞉saeta꞉sa꞉ga꞉, Aisa꞉g eyo꞉ bo꞉ba so꞉mea꞉niki uwo꞉ dibida꞉i fa꞉la꞉nda꞉la꞉ga꞉ ilili alitaki, Yaweya꞉ wiyo꞉ a꞉na dulugu sio꞉. E helebeso꞉g ayo꞉ a꞉na dia꞉sa꞉ga꞉, ene nanog kaluwa꞉yo꞉ ho꞉no꞉ a꞉na daido꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ho꞉len no amio꞉ Abimeleg e Gela a꞉la꞉ta꞉ga꞉ Aisa꞉gdo꞉wa fa꞉la꞉dowo꞉. Abimeleg o꞉lia꞉ ene asulo꞉lo꞉ dimian kalu Ahusat o꞉lia꞉, ene ame misa꞉ kalu Fikol, i otalen a꞉no꞉ elo꞉wa fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Aisa꞉g eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Tamin amio꞉ ne gili hena sen amio꞉, giliyo꞉ nemo꞉wo꞉ mo꞉beaki o꞉luso꞉no꞉ ko꞉lo꞉, gi ko꞉lo꞉ mio꞉ we, mo꞉wo꞉ o꞉ba?” ");
INSERT INTO bco_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Iliyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Yaweyo꞉ ge o꞉lia꞉ iliki asuwa꞉ta꞉lab a꞉la꞉bo꞉ nio꞉ fanda asulo꞉ ko꞉lo꞉, nili asulakiyo꞉, ge ni o꞉lia꞉yo꞉ towo꞉ dinali saetaki ua mesa꞉no꞉ asulaki mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Tamin amio꞉ niliyo꞉ ge dinafa tili dofo꞉la꞉ga꞉, ge ha꞉na꞉nigabikiyo꞉, na꞉no꞉ ko꞉lo꞉ ege dowo꞉ aumbo꞉ ge sagala꞉li iliga꞉fo꞉. A꞉la꞉ta꞉ga꞉ o꞉go꞉ Yawe eyo꞉ gemo꞉wo꞉ nafale mesea꞉ki ta꞉tab. A꞉la꞉fo꞉ko꞉lo꞉ nililo꞉ gemo꞉lo꞉ mo꞉hidalifa꞉ o꞉leaumbo꞉, giyo꞉lo꞉ nimo꞉wo꞉ mo꞉hidalifa꞉no꞉ a꞉la꞉liki dinali saefoma.” ");
INSERT INTO bco_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","A꞉la꞉sa꞉labiki Aisa꞉g eyo꞉ ma꞉no꞉wo꞉ alan dowo꞉ta꞉sa꞉ga꞉, kalu i mio꞉ o꞉mo꞉wo꞉ maiya꞉ki dimiabikiyo꞉, iliyo꞉ ma꞉n o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ a꞉na mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Kea꞉fole dasila꞉sa꞉ga꞉yo꞉, iyo꞉ egelebo꞉ ege doma꞉no꞉ a꞉la꞉li towo꞉ halaido꞉ dinali saefa꞉. Aisa꞉g eyo꞉ iyo꞉ a꞉ma꞉la꞉ hamana꞉ki iliga꞉tabiki, iyo꞉ sagala꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Iyo꞉ ha꞉nabikiyo꞉, Aisa꞉ga꞉ ene nanog kalu nolo꞉ elo꞉wa ya꞉ga꞉ a꞉la꞉sio꞉, “Niliyo꞉ hen nowo꞉ daido꞉ amio꞉ ho꞉n siyo꞉ fa꞉la꞉dowo꞉.” ");
INSERT INTO bco_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Iliyo꞉ a꞉la꞉sa꞉labiki, Aisa꞉g eyo꞉ ho꞉n daido꞉ a꞉no꞉ “Siba” wikilo꞉. A꞉la꞉fo꞉ko꞉lo꞉ o꞉g wiyo꞉lo꞉, amisa꞉n a꞉no꞉ Bilsiba a꞉la꞉sa꞉la꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso꞉ e donayo꞉ 40 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, Hit kalu Beliya꞉ ida꞉, Yudi ko꞉lo꞉ di. A꞉la꞉ta꞉ga꞉ Hit kalu nowo꞉ Elona꞉ ida꞉, Basemat ko꞉lo꞉ wa꞉ka a꞉di. ");
INSERT INTO bco_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Ga a꞉la꞉ma꞉yo꞉ ena꞉su Aisa꞉g o꞉lia꞉ La꞉ba꞉ga o꞉lia꞉yo꞉ dinafa mesea꞉kiyo꞉ mo꞉sagale alita꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Aisa꞉g e anaso꞉ siyo꞉ funa꞉lia꞉ga꞉ siliki, inso꞉ wa꞉la꞉b Iso꞉wo꞉ elo꞉wa mena꞉ki ho꞉ida꞉sa꞉ga꞉, a꞉la꞉sio꞉, “Ni so꞉wa” a꞉la꞉sa꞉labiki, Iso꞉ eyo꞉ “O꞉ba? Ne weko꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","3","Aisa꞉g eyo꞉ a꞉la꞉sio꞉, “Ne anaso꞉ soma꞉no꞉wo꞉ ko꞉na꞉ma dowab ko꞉lo꞉, ge da꞉yo꞉ dia꞉sa꞉ga꞉, hena꞉ usa no꞉wo꞉ buluma꞉ hamana. ");
INSERT INTO bco_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","No꞉wo꞉ o꞉lalikiyo꞉, no꞉ ho nilo꞉ nab amilo꞉ nudo꞉ nafalo꞉ doma꞉no꞉ a꞉no꞉ so꞉da꞉sa꞉ga꞉, nelo꞉wa dia꞉ya꞉bi. Ne a꞉no꞉ na꞉sa꞉ga꞉yo꞉, niyo꞉ ge nafale mesea꞉ki dinali sa꞉ma꞉no꞉. Ne o꞉silikiyo꞉, to nafa a꞉no꞉ gemo꞉ dinali sa꞉ma꞉no꞉ asulab.” ");
INSERT INTO bco_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Aisa꞉g eyo꞉ Iso꞉bo꞉wo꞉ a꞉la꞉sa꞉la꞉labikiyo꞉, to sa꞉lab a꞉no꞉ La꞉ba꞉ga e da꞉da꞉len. A꞉la꞉go꞉ko꞉lo꞉ Iso꞉wo꞉ no꞉wo꞉ buluma꞉ ha꞉nabiki, La꞉ba꞉ga eyo꞉ ene so꞉wa Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “O꞉go꞉ go꞉la꞉yo꞉ Iso꞉mo꞉wo꞉ towo꞉ sa꞉la꞉labiyo꞉ ne dabu. ");
INSERT INTO bco_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Elo꞉ to sio꞉wo꞉ we, ‘Ne o꞉silikiyo꞉, ge nafale mesea꞉ki, Yaweya꞉ si wa꞉l amio꞉ gemo꞉wo꞉ towo꞉ dinali sa꞉ma꞉no꞉ ko꞉lo꞉, ge no꞉wo꞉ o꞉lalikiyo꞉, no꞉ ho nilo꞉ nab amilo꞉ nudo꞉ nafalo꞉ doma꞉no꞉ a꞉no꞉ so꞉da꞉sa꞉ga꞉, nemo꞉ dia꞉ya꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","A꞉la꞉sa꞉laiba꞉ ko꞉lo꞉, ge nilo꞉ to sa꞉ma꞉nigo꞉l we ko꞉le dinafa da꞉da꞉sa꞉ga꞉ kudu ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Go꞉la꞉lo꞉ no꞉ ho ma꞉no꞉ asulab aumbo꞉ ni dimidalia꞉ga꞉ so꞉fa꞉no꞉ ko꞉lo꞉, ge no꞉ fofo꞉lo꞉ sab a꞉na ha꞉na꞉ga꞉, goudi kalofo nafa a꞉la꞉yo꞉ nelo꞉wa sanalia꞉ ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Go꞉lo꞉ o꞉silikiyo꞉, ge nafa mesea꞉ki towo꞉ gemo꞉wo꞉ sama꞉kiyo꞉, no꞉ ho so꞉fa꞉ a꞉no꞉ giyo꞉ go꞉lbo꞉wo꞉ maiya꞉ki dimia꞉bi,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ anomo꞉wo꞉ a꞉la꞉sio꞉, “Ko꞉sega Iso꞉ e do꞉mo꞉ amio꞉ do꞉la꞉ma꞉ fo꞉no꞉ tambo dowo꞉, ko꞉sega ne do꞉mo꞉wo꞉ malilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Niyo꞉ a꞉la꞉dimido꞉lo꞉ga, dowa꞉yo꞉ ni do꞉mo꞉wo꞉ golo kedab amio꞉, e ni dikidabo꞉lo꞉b a꞉la꞉asula꞉sa꞉ga꞉, ne dinafa mesea꞉kiyo꞉ mo꞉sa꞉laki, ne mogago꞉ mesea꞉ki sa꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ya꞉kob eyo꞉ a꞉la꞉sa꞉labiki, anowa꞉yo꞉ a꞉la꞉sio꞉, “Ni so꞉wa, ge kele asula꞉so꞉bo. Gelo꞉ mogagi alifa꞉no꞉ to sa꞉ma꞉ib a꞉no꞉ ni dia꞉no꞉ ko꞉lo꞉, o꞉gdo꞉ nilo꞉ so꞉lo꞉l we au kudu ha꞉naki, ge ha꞉na꞉sa꞉ga꞉, no꞉ a꞉no꞉ nemo꞉ dia꞉ya꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kobo꞉ ha꞉na꞉sa꞉ga꞉, goudi a꞉la꞉ a꞉no꞉ sanalia꞉ga꞉, anolo꞉wa dia꞉yabiki, La꞉ba꞉ga eyo꞉ no꞉ ho nafa nudo꞉lo꞉ a꞉no꞉ Aisa꞉ga꞉lo꞉ ma꞉no꞉ asulab o꞉leau so꞉fa꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","La꞉ba꞉gaya꞉ ene ayamio꞉, ene so꞉wa wa꞉la꞉b Iso꞉wa꞉ helebeso꞉g nafa nolo꞉ delen ko꞉lo꞉, La꞉ba꞉ga eyo꞉ helebeso꞉g a꞉no꞉ dia꞉sa꞉ga꞉, ene so꞉wa tif Ya꞉koba kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Helebeso꞉go꞉ kalita꞉sa꞉ga꞉, eyo꞉ Ya꞉koba꞉ dagi o꞉lia꞉ dagas o꞉lia꞉yo꞉ goudi do꞉go꞉fo꞉ a꞉na mele alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Goudi do꞉go꞉fo꞉ mele alita꞉sa꞉ga꞉, falawa so꞉fa꞉ o꞉lia꞉ no꞉ ho nudo꞉lo꞉ nafa so꞉fa꞉ a꞉no꞉ ene so꞉wa Ya꞉kobo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ya꞉kob eyo꞉ dia꞉ga꞉, iyalo꞉wa dia꞉fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Do.” Aisa꞉g eyo꞉ a꞉la꞉sio꞉, “Ni so꞉wa, ge o꞉ba꞉le?” ");
INSERT INTO bco_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","A꞉la꞉dabu ba꞉dabiki, Ya꞉kob eyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “Gi so꞉wa wa꞉la꞉b Iso꞉wo꞉ ne. To gilo꞉ nemo꞉lo꞉ dimidama꞉kilo꞉ sio꞉ a꞉no꞉ niyo꞉ dimido꞉. Nilo꞉ no꞉ buluma꞉ni ane ho so꞉fa꞉ we ma꞉niki dasima. Na꞉sa꞉ga꞉yo꞉, ne dinafa mesea꞉kiyo꞉ giyo꞉ nemo꞉ dinali salifoma.” ");
INSERT INTO bco_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ko꞉sega Aisa꞉g eyo꞉ ene inso꞉mo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giyo꞉ no꞉ we waga bo꞉e diyo꞉?” A꞉la꞉dabu ba꞉dabiki, Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Gi Gode Yawe a꞉ma꞉yo꞉ ne mada asufa꞉ ko꞉lo꞉ dia꞉ yo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Aisa꞉g eyo꞉ Ya꞉kobo꞉ a꞉la꞉sio꞉, “Ge hendele ni so꞉wa Iso꞉ deya꞉le a꞉la꞉liki goma꞉nigo꞉l ko꞉lo꞉ ge nelo꞉wa mena.” ");
INSERT INTO bco_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","A꞉la꞉sa꞉labiki, Ya꞉kobo꞉ iyalo꞉wa ha꞉na꞉ga꞉ dowabiki, Aisa꞉g eyo꞉ e dagiya ta꞉liakiyo꞉ a꞉la꞉sio꞉, “To elo꞉wo꞉ Ya꞉koba꞉ dagan do꞉do꞉l ko꞉sega, gi dagi ko꞉lo꞉ golo꞉ amio꞉ Iso꞉ dowabo꞉lo꞉b.” ");
INSERT INTO bco_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Aisa꞉g eyo꞉ dagi elo꞉wo꞉ ao Iso꞉wa꞉ dagi do꞉la꞉ma꞉ fo꞉ndo꞉ o꞉ngo꞉wa golo꞉ ko꞉lo꞉, Ya꞉kobo꞉lo꞉b a꞉la꞉bo꞉ mo꞉asulo꞉. A꞉la꞉fo꞉ko꞉lo꞉ Aisa꞉g eyo꞉ e nafale mesea꞉ki towo꞉ sa꞉ma꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Aisa꞉g eyo꞉ emo꞉wo꞉ wa꞉ka a꞉dabu ba꞉ba꞉, “Hendele ni so꞉wa Iso꞉wo꞉ geya꞉le?” Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “A꞉, ne Iso꞉ka꞉.” ");
INSERT INTO bco_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","A꞉la꞉sa꞉labiki Aisa꞉g eyo꞉ a꞉la꞉sio꞉, “Ni so꞉wa, ge nafale mesea꞉ki dinali sa꞉ma꞉nigo꞉l ko꞉lo꞉, gilo꞉ no꞉ ho so꞉fa꞉ a꞉no꞉ ma꞉ni dimina.” A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ ho so꞉fa꞉ a꞉no꞉ iyamo꞉ dimiabiki, eyo꞉ mo꞉no꞉. Na꞉sa꞉ga꞉yo꞉ wain ho꞉no꞉lo꞉ dimiabiki, eyo꞉ a꞉no꞉lo꞉ mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Na꞉sa꞉ga꞉yo꞉ eyo꞉ a꞉la꞉sio꞉, “Na꞉ so꞉wa, mimila꞉ma꞉ni mena.” ");
INSERT INTO bco_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ya꞉kob eyo꞉ iyayo꞉ mimilabikiyo꞉, Aisa꞉g eyo꞉ Ya꞉koba꞉lo꞉ so꞉g ko꞉lo꞉ mun a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, inso꞉ a꞉no꞉ e nafale mesea꞉kiyo꞉, eyo꞉ a꞉la꞉dinali sio꞉, “Ni so꞉wa mun ge amilo꞉ dabu a꞉no꞉ Egelo꞉ Yawe elo꞉ nafale fa꞉la꞉doma꞉kilo꞉ ta꞉fo꞉ a꞉ma꞉ mun o꞉leo꞉ngo꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Eleya꞉ ba꞉ ko꞉lo꞉ Godelo꞉wa a꞉la꞉ta꞉ga꞉lo꞉ fa꞉la꞉dowab a꞉no꞉ gelo꞉ amio꞉ dimia꞉melea꞉ki a꞉la꞉ta꞉ga꞉, Ma꞉no꞉ modo꞉ fa꞉la꞉doma꞉no꞉ hen heyo꞉ nafaleyo꞉ gemo꞉ dimina꞉ki a꞉la꞉ta꞉ga꞉ ma꞉no꞉ hende o꞉lia꞉ wain ho꞉n o꞉lia꞉yo꞉ ge amio꞉ modo꞉ nafale fa꞉la꞉nda꞉melea꞉ki, Godemo꞉ dulugu so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","A꞉la꞉ta꞉ga꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ henfelo꞉ amilo꞉ sab we, gi nanog dian kalu dowaki, iyo꞉ gi ha꞉ga dowa꞉i ha꞉na꞉mela꞉ib. Ge misa꞉ dowaki, gao iyo꞉ gi ha꞉ga dowa꞉mela꞉ib. Iliyo꞉ gelo꞉wa gulalu siliki, ge ko꞉lo꞉ wabulu sa꞉la꞉mela꞉ib. Kalu abeyo꞉ ge mogagila꞉ma꞉no꞉ towo꞉ sa꞉lalega, kalu a꞉ma꞉ inin ko꞉ mogaima꞉ib. Kalu abeyo꞉ ge nafale mesea꞉ki, Godemo꞉ dulugu sa꞉lalega, kalu i a꞉no꞉ nafale mesea꞉ki ta꞉fa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aisa꞉g eyo꞉ Ya꞉kobo꞉ nafale mesea꞉kiyo꞉ dinali sa꞉la꞉sa꞉ga꞉, Ya꞉kobo꞉ ha꞉nabiki, Iso꞉ e no꞉ bulula꞉leno꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Iso꞉ eyo꞉lo꞉ no꞉ ho nudo꞉ nafayo꞉ so꞉da꞉sa꞉ga꞉, iyamo꞉ dia꞉ya꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Nilo꞉ no꞉ buluma꞉ni ane ho so꞉fa꞉ we ma꞉niki dasima. Na꞉sa꞉ga꞉yo꞉, ne dinafa mesea꞉ki, do giyo꞉ nemo꞉ dinali salifoma.” ");
INSERT INTO bco_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Ko꞉sega ene iya Aisa꞉g eyo꞉ a꞉la꞉sio꞉, “Ge o꞉ba?” a꞉la꞉sio꞉. “Gi so꞉wa wa꞉la꞉b Iso꞉wo꞉ ne.” ");
INSERT INTO bco_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","A꞉la꞉sa꞉labikiyo꞉ Aisa꞉go꞉ iliga꞉sa꞉ga꞉, kiyo꞉ bibiaki a꞉la꞉sio꞉, “Hendele ge Iso꞉ a꞉lalega, tamin amilo꞉ no꞉lo꞉ buluma꞉ ha꞉na꞉sa꞉ga꞉lo꞉ nemo꞉lo꞉ maiya꞉kilo꞉ dimiabo꞉ o꞉ba꞉le? Ge o꞉mia꞉no꞉ a꞉labikiyo꞉, nemo꞉wo꞉ dia꞉yabiki na꞉sa꞉ga꞉, e nafale mesea꞉ki, Godemo꞉ dulugu sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ e hendele nafale mesa꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Iso꞉ e iyaya꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉, e mada halaido꞉ ya꞉lakiyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “Dowa, nelo꞉ nafale mesea꞉kiyo꞉ dinali sama.” ");
INSERT INTO bco_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ko꞉sega Aisa꞉g eyo꞉ a꞉la꞉sio꞉, “Gaowo꞉ ya꞉sa꞉ga꞉ dikido꞉ ko꞉lo꞉, to gemo꞉lo꞉ dinali sa꞉ma꞉no꞉ sio꞉ a꞉no꞉ Ya꞉kob e dia꞉gane.” ");
INSERT INTO bco_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","A꞉la꞉sa꞉labiki Iso꞉ eyo꞉ a꞉la꞉sio꞉, “Nao eyo꞉ ne ho꞉len a꞉la꞉ dikidakiyo꞉, tamin amio꞉ nilo꞉ wa꞉la꞉ba꞉ dabuno꞉ e di. A꞉la꞉ta꞉ga꞉ o꞉go꞉lo꞉ nemo꞉lo꞉ nafa mesea꞉kilo꞉ dinali sa꞉ma꞉no꞉ to sio꞉ a꞉no꞉lo꞉ e diab. A꞉la꞉go꞉ko꞉lo꞉ wi Ya꞉kob a꞉no꞉ e amio꞉ mada ililab. Ko꞉sega giyo꞉ nafale mesa꞉no꞉ to nowo꞉ nemo꞉lo꞉ dimia꞉no꞉wo꞉ o꞉da꞉laba?” ");
INSERT INTO bco_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","A꞉la꞉dabu ba꞉dabiki Aisa꞉g eyo꞉ Iso꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Gaowo꞉ gi misa꞉ kalu doma꞉ki ta꞉takiyo꞉, ene ao i a꞉no꞉ ene nanog dian kalu doma꞉ki ta꞉fo꞉. A꞉la꞉ta꞉ga꞉ e amio꞉ ma꞉n o꞉lia꞉ wain ho꞉n o꞉lia꞉yo꞉ modo꞉ fa꞉la꞉doma꞉ki, niyo꞉ emo꞉ dinali saefa꞉. A꞉la꞉go꞉ko꞉lo꞉ gemo꞉lo꞉ dinali sa꞉ma꞉no꞉ kelego꞉ nowo꞉ aundo꞉ma.” ");
INSERT INTO bco_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Iso꞉ eyo꞉ iyamo꞉ ha꞉iyakiyo꞉ a꞉la꞉sio꞉, “Do giyo꞉ dinali sio꞉ imilig ko꞉ma꞉le? Do giyo꞉ nelo꞉ nafale mesa꞉no꞉wo꞉ dinali sama.” Iso꞉ eyo꞉ to a꞉no꞉ sa꞉la꞉sa꞉ga꞉yo꞉, e alan ya꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Aisa꞉ga꞉yo꞉ inso꞉bo꞉wo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Ma꞉no꞉ modo꞉lo꞉ fa꞉la꞉doma꞉no꞉ hen heyo꞉ nafale a꞉namio꞉ ge mo꞉mesa꞉ib, a꞉la꞉ta꞉ga꞉ Eleya꞉ ba꞉ ko꞉lo꞉ Godelo꞉wa a꞉la꞉ta꞉ga꞉lo꞉ fa꞉la꞉dowab a꞉no꞉ gelo꞉ amio꞉ mo꞉fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Giyo꞉ hen o꞉lia꞉ ma꞉no꞉ o꞉lia꞉ dia꞉nikiyo꞉, buba꞉i ha꞉na꞉la꞉ga꞉ a꞉na dia꞉ib. A꞉la꞉ta꞉ga꞉ ge gaowa꞉ nanog kalu dowa꞉i ha꞉na꞉mela꞉ib. Ko꞉sega tif amio꞉ ge mo꞉bealiki, ene halaido꞉ ha꞉g amio꞉ mo꞉doma꞉niki, giyo꞉ susia꞉la꞉ga꞉, handalowakiyo꞉ ga꞉li doma꞉ib.” Aisa꞉g eyo꞉ emo꞉wo꞉ a꞉la꞉dinali salifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso꞉ emo꞉lo꞉ dinali sa꞉ma꞉no꞉ to a꞉no꞉ ao Ya꞉kob eyo꞉ dikida꞉sa꞉ga꞉ di, ko꞉lo꞉ Iso꞉ eyo꞉ Ya꞉kobo꞉wo꞉ mada kulufa꞉yakiyo꞉ eneno꞉ a꞉la꞉kele asulo꞉, “Dowo꞉ soma꞉no꞉wo꞉ ko꞉na꞉ma dofo꞉lab ko꞉lo꞉, e sowaliki kuo꞉ya꞉la꞉ga꞉ ilikiyo꞉, niyo꞉ Ya꞉kobo꞉ a꞉na sanala꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","43","Iso꞉wa꞉lo꞉ Ya꞉kobo꞉lo꞉ dimidama꞉no꞉ sio꞉wo꞉, kalu nolba꞉ da꞉da꞉sa꞉ga꞉, La꞉ba꞉gamo꞉ sio꞉ ko꞉lo꞉, La꞉ba꞉ga eyo꞉ Ya꞉kobo꞉ ho꞉ida꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Dabuma, gao Iso꞉wa꞉yo꞉ ge wa꞉deaki sanala꞉ma꞉no꞉ dimidaliab ko꞉lo꞉, ge nilo꞉ sa꞉ma꞉nigo꞉l we ko꞉lo꞉ kudu ha꞉na꞉bi. Ni so꞉wa, ge Halan hen a꞉na nai ha꞉na꞉sa꞉ga꞉, nao Laban elo꞉wa wo꞉no꞉le mesa꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","45","Ge Laban o꞉lia꞉ o꞉a꞉la꞉ga꞉, gilo꞉ Iso꞉ ko꞉lo꞉ dikido꞉ a꞉no꞉ Iso꞉ eyo꞉ ga꞉lila꞉sa꞉ga꞉, kulufa꞉yo꞉ elo꞉ a꞉no꞉ aundo꞉ma dowaliki, niyo꞉ kalu nowo꞉ ge tililia꞉ mena꞉ki iliga꞉fa꞉no꞉. Mo꞉wo꞉ gaowa꞉ ge sa꞉ndaliki nolba꞉yo꞉ e wa꞉dealega, ne ga꞉go꞉ asulakiyo꞉ ho꞉len imilise a꞉namio꞉ nofolo꞉wo꞉ alan fa꞉la꞉doma꞉ib ko꞉lo꞉ a꞉la꞉bo꞉ fa꞉la꞉dowabena꞉kiyo꞉, ge o꞉go꞉ hamana.” ");
INSERT INTO bco_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, La꞉ba꞉ga eyo꞉ Aisa꞉gbo꞉wo꞉ a꞉la꞉sio꞉, “Hit ga a꞉la꞉ Iso꞉ elo꞉ di a꞉ma꞉lo꞉ man dimidab a꞉no꞉ ne ba꞉ba꞉yo꞉ kulufa꞉yaki mo꞉beab ko꞉lo꞉, Ya꞉kob elo꞉ Hit ga weko꞉ dialega, ne mada mo꞉bea꞉la꞉ga꞉, ne doma꞉no꞉wo꞉ mada mogagila꞉ma꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","A꞉la꞉fo꞉ko꞉lo꞉ Aisa꞉g eyo꞉ Ya꞉kobo꞉ ho꞉ida꞉sa꞉ga꞉, emo꞉wo꞉ nafale mesa꞉no꞉ towo꞉ sa꞉la꞉sa꞉ga꞉yo꞉, to halaido꞉ nowo꞉ sa꞉laki a꞉la꞉sio꞉, “Ge Ka꞉ina꞉n ga we, mada dia꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ko꞉sega ge Mesobotemia hena a꞉ma꞉la꞉ ha꞉na꞉ga꞉, ge ma꞉mu Betuel amisa꞉n a꞉namio꞉, ge babo꞉ Labana꞉ ida꞉ nowo꞉ ge dia꞉ni ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Ga gilo꞉ dia꞉nigab a꞉no꞉ mada nafale dowaki, so꞉wayo꞉ modo꞉ ko꞉lo꞉ sa꞉la꞉la꞉i ha꞉nakiyo꞉, so꞉lo꞉wo꞉ modo꞉ fa꞉la꞉doma꞉ki a꞉la꞉li, Gode Halaido꞉le A꞉lab o꞉mo꞉ dulugu so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Godeya꞉lo꞉ Ablahambo꞉lo꞉ dinali sio꞉ a꞉no꞉ ge dia꞉sa꞉ga꞉, ge ma꞉mu ima꞉yo꞉lo꞉ dia꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ hen gelo꞉ mageso꞉lo꞉ sia꞉len welo꞉, ge tambo dia꞉sa꞉ga꞉ bo꞉fo꞉mela꞉ib, mo꞉wo꞉ tamin amio꞉ Gode eyo꞉ Ablahambo꞉ dimi.” Aisa꞉g eyo꞉ Ya꞉kobo꞉ a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","A꞉la꞉sa꞉la꞉sa꞉ga꞉, Aisa꞉g eyo꞉ Ya꞉kob e Mesobotemia hen a꞉na, Labando꞉wa melea꞉ki iliga꞉fo꞉. Laban e Alam kalu Betuel inso꞉, a꞉la꞉ta꞉ga꞉ La꞉ba꞉gaya꞉ ene aowo꞉ e. ");
INSERT INTO bco_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Aisa꞉g eyo꞉ Ya꞉kob e nafa mesea꞉kilo꞉ to sio꞉ a꞉no꞉ a꞉la꞉ta꞉ga꞉ Ya꞉kob e gayo꞉ a꞉na dima꞉kiyo꞉ Mesobotemia hena iliga꞉fo꞉lo꞉b a꞉la꞉bo꞉, Iso꞉ e da꞉da꞉ga꞉ asulo꞉. A꞉la꞉ta꞉ga꞉ Aisa꞉g eyo꞉ Ya꞉kobo꞉ nafa mesea꞉ki towo꞉ sa꞉lab amio꞉, e Ka꞉ina꞉n ga we dia꞉so꞉boka꞉ a꞉lakilo꞉ sio꞉ a꞉no꞉ Iso꞉wo꞉ dabu. ");
INSERT INTO bco_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","A꞉la꞉ta꞉ga꞉ Ya꞉kob e iyalia꞉ anolia꞉ma꞉lo꞉ to sio꞉ a꞉no꞉ kudu ha꞉nakiyo꞉ Mesobotemia hen aneka꞉ a꞉la꞉do꞉ sio꞉wo꞉ Iso꞉ e dabu. ");
INSERT INTO bco_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","To sio꞉ a꞉no꞉ asulakiyo꞉, iya Aisa꞉g eyo꞉ Ka꞉ina꞉n gaya꞉ mano꞉ mo꞉beakigo꞉lo꞉b a꞉la꞉bo꞉ Iso꞉ e a꞉na fanda asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","A꞉la꞉fo꞉ko꞉lo꞉ Iso꞉ eyo꞉ ga nowo꞉ a꞉dia꞉ni, Ablahama꞉ inso꞉ Ismaela꞉ e so꞉lo꞉lo꞉wa ha꞉na꞉sa꞉ga꞉yo꞉, Ismaela꞉ ida꞉ Nebayoda꞉ ado Mahalad e a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ya꞉kob eyo꞉ Bilsiba a꞉na ta꞉ta꞉ga꞉ Halan ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ha꞉na꞉leno꞉ nudabiki, us a꞉namio꞉ alima꞉no꞉ hen nafa nowo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, u nowo꞉ e misa꞉yo꞉ a꞉na dia꞉taki ali. ");
INSERT INTO bco_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","E a꞉na alifo꞉liki, ofola ba꞉ba꞉ amio꞉ wo꞉lo꞉ hen wena a꞉la꞉ta꞉ga꞉ Hebene halona ka dowalifo꞉liki, Godeya꞉ ene ma꞉mula꞉ kaluwo꞉ wo꞉l a꞉na tinda꞉liki, nolo꞉ fa꞉la꞉na꞉liki a꞉la꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yawe eyo꞉ Ya꞉kob elo꞉ alifo꞉lab aniba kagafo꞉liki a꞉la꞉sio꞉, “Ne Yawe, Ablahama꞉ Godeyo꞉ ne, a꞉la꞉ta꞉ga꞉ Aisa꞉ga꞉ Godeyo꞉ ne ko꞉lo꞉, hen gelo꞉ alifo꞉lab we, ge o꞉lia꞉ ge ma꞉mu i o꞉lia꞉mo꞉ dimia꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","So꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab a꞉no꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉, iyo꞉ hena꞉ mu o꞉ngo꞉ fa꞉la꞉doma꞉ib. Iyo꞉ ta꞉i ha꞉nakiyo꞉, hen ofdo꞉ yan doba꞉da꞉yo꞉lo꞉, ofdo꞉ tinan doba꞉da꞉yo꞉lo꞉, eleb doba꞉da꞉yo꞉lo꞉, kini doba꞉da꞉yo꞉lo꞉ modo꞉ ta꞉i ha꞉na꞉ib. A꞉la꞉ta꞉ga꞉ henfelo꞉ amilo꞉ so꞉lo꞉ sab a꞉no꞉ tambo ge o꞉lia꞉ so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉na꞉lab a꞉na a꞉la꞉ta꞉ga꞉yo꞉ nafale mesea꞉ki ta꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ge hen o꞉bamida꞉ya꞉le ha꞉nalega, ne ge o꞉lia꞉ sia꞉liki bo꞉fo꞉mela꞉no꞉. A꞉la꞉ta꞉ga꞉ tif amio꞉ niyo꞉ ge hen wena a꞉ma꞉la꞉ tililia꞉ mia꞉no꞉. Niyo꞉ ge mo꞉ta꞉fa꞉no꞉ ko꞉lo꞉, to no꞉no꞉ndo꞉ gemo꞉lo꞉ dinali sio꞉ aumbo꞉ niyo꞉ dimidama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ya꞉kob e ali a꞉no꞉ ko꞉lo꞉ dasilakiyo꞉ a꞉la꞉sio꞉, “Ne mo꞉asulo꞉ ko꞉sega, Yawe e hen wenamio꞉ hendele a꞉lab.” ");
INSERT INTO bco_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","A꞉la꞉sa꞉la꞉sa꞉ga꞉ e tagilaki a꞉la꞉sio꞉, “Hen we mada ko꞉lilo꞉b Hen we Godeya꞉ ene a, a꞉la꞉ta꞉ga꞉ Hebene togo꞉ wena a꞉lab ko꞉lo꞉ ne mada molo asulab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Kea꞉fole a꞉namio꞉, Ya꞉kob eyo꞉ u elo꞉ misase ali a꞉no꞉ da꞉ga꞉lia꞉ga꞉, hen a꞉na gele alifa꞉. Gele alitakiyo꞉ wa ho꞉no꞉ a꞉na tulu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tamin amio꞉ hen a꞉no꞉ “Lus” a꞉la꞉sa꞉la꞉sen ko꞉sega o꞉go꞉ Ya꞉koba꞉yo꞉ hen a꞉no꞉ “Betel” wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","A꞉la꞉dimida꞉sa꞉ga꞉ Ya꞉kob eyo꞉ a꞉la꞉dinali sio꞉, “Gode giyo꞉ ne o꞉lia꞉ dowaki, nemo꞉wo꞉ helebeso꞉g o꞉lia꞉ ma꞉no꞉ o꞉lia꞉ dimiaki a꞉la꞉ta꞉ga꞉, nelo꞉ ha꞉na꞉labo꞉ gi bo꞉fo꞉la꞉ga꞉ aneyo꞉, ne a꞉ma꞉la꞉ dowa꞉ hen ami ga꞉li tililia꞉ ha꞉nalega, Yawe ge, ni Gode doma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Nilo꞉ u ko꞉lo꞉ gele alito꞉l we, Gode gi ayo꞉ we a꞉la꞉liki da꞉fe alito꞉l. A꞉la꞉ta꞉ga꞉ kelego꞉ Gode gilo꞉ nemo꞉lo꞉ dimiab a꞉no꞉ tambo, niyo꞉ do꞉la꞉fo꞉ aloba꞉da꞉sa꞉ga꞉, heb imilig nowo꞉ Godemo꞉ dimia꞉no꞉.” Ya꞉kob eyo꞉ a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ya꞉kobo꞉ ha꞉na꞉sa꞉ga꞉, kaluka꞉isale ofdo꞉ yan doba꞉da꞉lo꞉ sa꞉sen ili hen a꞉namida꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","E ha꞉na꞉ga꞉ ha꞉naki sigili ba꞉ba꞉ amio꞉, ho꞉n daido꞉ nowo꞉ a꞉na ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ ho꞉n daido꞉ anib a꞉namio꞉ sibi gulubido꞉ otalen a꞉no꞉ a꞉na a꞉labiki ba꞉ba꞉. Sibi a꞉no꞉ ho꞉n ma꞉no꞉la꞉liki, fufulufo꞉liki yasisen. Ho꞉n daido꞉ me a꞉no꞉ u alana꞉ go꞉lu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Sibilo꞉ bo꞉fo꞉lowan kalu ililo꞉ dimida꞉seno꞉ we. Sibiyo꞉ tambo tililia꞉ga꞉ fa꞉la꞉dowab amio꞉, sibilo꞉ bo꞉fo꞉lowan iliyo꞉ u a꞉no꞉ ua fo꞉fo꞉goloa꞉taki, ho꞉no꞉ sibimo꞉wo꞉ a꞉na mean. A꞉la꞉ta꞉ga꞉ ho꞉no꞉ mea꞉sa꞉ga꞉yo꞉, u alan a꞉no꞉ a꞉ma꞉la꞉ go꞉lu alita꞉sen. Iliyo꞉ a꞉la꞉dimida꞉sen ko꞉lo꞉, o꞉g a꞉namio꞉ nolo꞉ o꞉mena꞉ki yasisab. ");
INSERT INTO bco_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ya꞉kob e a꞉na fa꞉la꞉dowakiyo꞉, imo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ni nao, gio꞉ o꞉bamida꞉ a꞉la꞉ta꞉ga꞉ mio꞉wo꞉?” A꞉la꞉dabu ba꞉dabiki, iliyo꞉ a꞉la꞉sio꞉, “Nio꞉ Halan sa꞉sen ko꞉lo꞉ mio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Nahol e ma꞉mu Laban a꞉no꞉, gio꞉ asulo꞉wo꞉?” “A꞉, nio꞉ asulo꞉ka꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","A꞉la꞉ta꞉ga꞉ Ya꞉kobo꞉ wa꞉ka dabu ba꞉daki, “E o꞉li saba꞉le?” “A꞉, e nafale sab. Bo꞉ba, ene ida꞉ Lesolo꞉, sibiyo꞉ ho꞉no꞉ mea꞉ni tililia꞉ yab.” ");
INSERT INTO bco_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","A꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉ Ya꞉kob eyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ho꞉len disi o꞉a꞉lab wenamio꞉, sibiyo꞉ ilif amilo꞉ to꞉loma꞉no꞉wo꞉ o꞉semo꞉dowo꞉ ko꞉lo꞉lab. Giliyo꞉ sibi we ho꞉no꞉ mea꞉sa꞉ga꞉ fuguso꞉ maiya꞉kiyo꞉ a꞉ma꞉la꞉bo꞉ mo꞉tililia꞉ ha꞉nab ko wangabi gaya?” ");
INSERT INTO bco_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","A꞉la꞉dabu ba꞉dabiki, sibilo꞉ bo꞉fo꞉lowan kaluwa꞉yo꞉ a꞉ma꞉la꞉ sa꞉laki, “Nili mano꞉ we. Sibilo꞉ bo꞉fo꞉lowan o꞉lia꞉ sibiyo꞉ tambo wena kegeneliab amio꞉, uwo꞉ ua fo꞉fo꞉gola꞉sa꞉ga꞉, ho꞉no꞉ a꞉na mea꞉sen ko꞉lo꞉, niliyo꞉ nolo꞉ kegenema꞉ki yasiso꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Lesolo꞉ iyaya꞉ sibiyo꞉ e bo꞉fo꞉lowa꞉sen ko꞉lo꞉, iyo꞉ a꞉na tola꞉lena eyo꞉ sibiyo꞉ tililia꞉ga꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ya꞉kob eyo꞉ e babo Labana꞉ ida꞉ Lesol o꞉lia꞉ ene sibi o꞉lia꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉, eyo꞉ sibiyo꞉ ho꞉no꞉ maiya꞉kiyo꞉, ho꞉n daido꞉wa ha꞉na꞉sa꞉ga꞉, u ko꞉lo꞉ ifa꞉ a꞉no꞉ fo꞉fo꞉gola꞉sa꞉ga꞉, ho꞉no꞉ e babo Labana꞉ sibi o꞉mo꞉ me. ");
INSERT INTO bco_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","12","A꞉la꞉ta꞉ga꞉ Ya꞉kob eyo꞉ Lesolo꞉ mimilaki ya꞉la꞉likiyo꞉, Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Go꞉la꞉ e babo꞉wo꞉ nowo꞉ ne. Gi gan La꞉ba꞉gaya꞉ so꞉wayo꞉ neka꞉” a꞉laki Lesolbo꞉wo꞉ sio꞉ ko꞉lo꞉, Lesol e bo꞉bo꞉ge nai ha꞉na꞉sa꞉ga꞉, iyamo꞉ sa꞉ma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","14","Laban e adowa꞉ inso꞉ Ya꞉kobo꞉ mio꞉ka꞉ a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, e nai ha꞉na꞉sa꞉ga꞉, Ya꞉kobo꞉ galiliakiyo꞉, e babowo꞉ fafula꞉fo꞉liki mimila꞉sa꞉ga꞉, ene aya tililia꞉gane. Ya꞉kob e aya fa꞉la꞉dowakiyo꞉, elo꞉ dimido꞉wo꞉ Laban emo꞉ malolo꞉ meabi, Laban eyo꞉ emo꞉ a꞉la꞉sio꞉, “Ge ne babo꞉, nadoleya꞉ inso꞉wo꞉ ge” a꞉la꞉sio꞉. Ya꞉kobo꞉ e babo o꞉lia꞉lo꞉ seno꞉ ele imiligo꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ele imiligo꞉ dufula꞉sa꞉ga꞉yo꞉, Laban eyo꞉ Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “Ge ni so꞉lo꞉le ko꞉sega, niyo꞉ ge nanogo꞉ madali dima꞉kiyo꞉ mo꞉asulo꞉ ko꞉lo꞉, gilo꞉ nanog diab konamio꞉, ge o꞉biba꞉sa꞉ kililia꞉niyo꞉?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laban e ida꞉yo꞉ a꞉la꞉, wa꞉la꞉bo꞉ Lea, a꞉ma꞉ fa꞉so꞉ Lesol ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leaya꞉ ene siyo꞉ nafa dowo꞉ ko꞉sega Lesol e mada nafa gesego꞉le dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ya꞉kob eyo꞉ Lesolo꞉ alan asulo꞉ ko꞉lo꞉, Labanbo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉la꞉ tif Lesolo꞉ ni dia꞉no꞉ ko꞉lo꞉, dona dom a꞉la꞉fo꞉wo꞉ ne gi nanog dia꞉mela꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","A꞉la꞉sa꞉labiki Laban eyo꞉ a꞉la꞉sio꞉, “A꞉, gilo꞉ to sa꞉lab a꞉no꞉ o꞉li. Niyo꞉ na꞉la꞉ we kalu nolbo꞉ mea꞉no꞉wo꞉ mo꞉beaki, gemo꞉ mea꞉no꞉wo꞉ sagalab. Ge ni o꞉lia꞉ wena mesa꞉no꞉.” Laban eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob e Lesola꞉ fudo꞉ o꞉ngo꞉ kililiakiyo꞉, dona dom a꞉la꞉fo꞉wo꞉ nanogo꞉ a꞉na dia꞉li elen. Ko꞉sega Ya꞉kob eyo꞉ Lesolo꞉ e dia꞉no꞉wo꞉ mada alan asulo꞉ ko꞉lo꞉, dona dom a꞉la꞉fo꞉ a꞉no꞉ o꞉ngo꞉mal sa꞉lab a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Dona a꞉no꞉ kedeta꞉ga꞉yo꞉, Ya꞉kob eyo꞉ Labanbo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ dona dinali sio꞉wo꞉ kedetab ko꞉lo꞉, ne e o꞉lia꞉ alima꞉niki, o꞉go꞉ ni gayo꞉ tililia꞉ mena.” ");
INSERT INTO bco_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","A꞉la꞉sa꞉labiki Laban eyo꞉ kaluka꞉isale hen a꞉namilo꞉ seno꞉ tambo ho꞉le kegea꞉sa꞉ga꞉, ma꞉no꞉ alan dowo꞉ta꞉sa꞉ga꞉ mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ko꞉sega nulu dowabikiyo꞉, Laban eyo꞉ Leayo꞉ tililia꞉ga꞉, Ya꞉kobo꞉ ta꞉fo꞉ ko꞉lo꞉ e ga a꞉no꞉lia꞉ ali. ");
INSERT INTO bco_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","A꞉la꞉ta꞉ga꞉ Laban eyo꞉ ene nanog ka꞉isale Silbayo꞉, Leaya꞉ nanog dia꞉melea꞉ki emo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Kea꞉fo dasila꞉sa꞉ga꞉yo꞉, Ya꞉kob e ga a꞉no꞉ Lealo꞉biki ba꞉ba꞉. E ba꞉da꞉sa꞉ga꞉yo꞉, Labando꞉wa ha꞉na꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Giyo꞉ we waga asulaki dimido꞉wo꞉? Ne Lesol dia꞉no꞉ a꞉la꞉liki, dona dom a꞉la꞉fo꞉wo꞉ nanogo꞉ a꞉na di ko꞉lo꞉, giyo꞉ ne wangabi dikido꞉wo꞉?” Ya꞉kob eyo꞉ a꞉la꞉ gadi sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","A꞉la꞉sa꞉labiki Laban eyo꞉ a꞉la꞉sio꞉, “Nili man amio꞉ tif so꞉wayo꞉ wa꞉la꞉bo꞉ mo꞉tinian ko꞉lo꞉ a꞉na go꞉ka꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","So꞉agelo꞉ imilig wenamio꞉, ga tili alitakilo꞉ sagalo꞉ a꞉no꞉ ge ga we o꞉lia꞉ kedetalikiyo꞉, ga nowo꞉lo꞉ gemo꞉wo꞉ a꞉na sili alifa꞉no꞉. A꞉la꞉ta꞉ga꞉ ga fudo꞉ mean aumbo꞉, ge dona dom a꞉la꞉fo꞉ nowo꞉ ni nanogo꞉ wa꞉ka a꞉dia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ a꞉la꞉dimidama꞉no꞉ dowo꞉. Lealo꞉ sili alifa꞉ sagalo꞉ ho꞉len a꞉no꞉ kedeta꞉ga꞉yo꞉, Laban eyo꞉ ene ida꞉ Lesolo꞉ emo꞉wo꞉ a꞉na sili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lesol sili alitakiyo꞉, Laban eyo꞉ ene nanog ka꞉isale Bilha, Lesola꞉ nanog dia꞉melea꞉ki emo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob e Lesol o꞉lia꞉yo꞉lo꞉ ali. Eyo꞉ Lesolo꞉ mada alan asulo꞉ ko꞉sega Leayo꞉ mo꞉dinafa asulo꞉. A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob e dona dom a꞉la꞉fo꞉ nowo꞉ Labana꞉ nanog dia꞉len. ");
INSERT INTO bco_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ya꞉kob eyo꞉ Leamo꞉lo꞉ mo꞉beab a꞉no꞉ Yawe ba꞉da꞉ga꞉, Lea e so꞉wayo꞉ sa꞉la꞉lima꞉ki ta꞉fo꞉ ko꞉sega, Lesol e fain dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","A꞉la꞉gabiki Leayo꞉ alela꞉sa꞉ga꞉, kalu so꞉wa sa꞉la꞉li. Lea eyo꞉ so꞉wa a꞉no꞉ sa꞉la꞉liakiyo꞉ a꞉la꞉sio꞉, “Ne kele asulakilo꞉ hida꞉yab a꞉no꞉ Yawe eyo꞉ ba꞉ba꞉ ko꞉lo꞉ o꞉go꞉ ne kaluwa꞉yo꞉ nemo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉ma꞉ib.” Lea eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, so꞉wa a꞉no꞉ Luben wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lea e wa꞉ka alela꞉sa꞉ga꞉, kalu so꞉wa nowo꞉ sa꞉la꞉liakiyo꞉, eyo꞉ a꞉la꞉sio꞉, “Kalu nilo꞉ma꞉yo꞉ ne ko꞉lo꞉ mo꞉beo꞉ a꞉no꞉ Yawe eyo꞉ dabu ko꞉lo꞉, kalu so꞉wa nowo꞉ wa꞉ka a꞉dimiab.” A꞉la꞉sa꞉la꞉sa꞉ga꞉, so꞉wa a꞉no꞉ Simeon wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","A꞉la꞉ta꞉ga꞉ Leayo꞉ wa꞉ka alela꞉sa꞉ga꞉, kalu so꞉wa nowo꞉ sa꞉la꞉liakiyo꞉ a꞉la꞉sio꞉, “Niyo꞉ kalu so꞉wa otalen we Ya꞉kobo꞉ sa꞉la꞉me ko꞉lo꞉, o꞉g wenamio꞉ eyo꞉ ne alan asulaliki, ne o꞉lia꞉yo꞉ mada oga꞉dima꞉ib.” A꞉la꞉sa꞉la꞉sa꞉ga꞉, so꞉wa a꞉no꞉ Libai wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","A꞉la꞉ta꞉ga꞉ Leayo꞉ wa꞉ka alela꞉sa꞉ga꞉, kalu so꞉wa nowo꞉ a꞉sa꞉la꞉liakiyo꞉ a꞉la꞉sio꞉, “O꞉go꞉ niyo꞉ Yawe ene wiyo꞉ wabudaki dulugu sa꞉ma꞉nigo꞉l” a꞉la꞉sa꞉la꞉sa꞉ga꞉, so꞉wa a꞉no꞉ Yuda wikilo꞉. Yuda sa꞉la꞉lia꞉sa꞉ga꞉yo꞉, Lea eyo꞉ so꞉wayo꞉ wa꞉kabiyo꞉ mo꞉sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Lesol e so꞉wayo꞉ mo꞉sa꞉la꞉lia꞉no꞉ dowabiki, adomo꞉ kulufa꞉ya꞉sa꞉ga꞉, Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ so꞉wayo꞉ nemo꞉wo꞉ mo꞉dimialega, ne soma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ya꞉kob eyo꞉ Lesolmo꞉wo꞉ gadia꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Giyo꞉ ne Gode a꞉la꞉asulaya? Godeya꞉ eneno꞉ ge so꞉wayo꞉ mo꞉sa꞉la꞉lima꞉ki faino ga ta꞉fo꞉lab.” ");
INSERT INTO bco_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","A꞉la꞉sa꞉labiki Lesol e sa꞉laki, “Niyo꞉ na꞉ nanog ka꞉isale Bilha a꞉no꞉ gemo꞉ dimia꞉nigo꞉l. So꞉wa elo꞉ sa꞉la꞉liab a꞉no꞉ ne ta꞉uma꞉no꞉ ko꞉lo꞉, ge e o꞉lia꞉ alila꞉bi. A꞉la꞉dimidalega eya a꞉la꞉ta꞉ga꞉yo꞉, so꞉wa nilo꞉wo꞉ fa꞉la꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","5","A꞉la꞉fo꞉ko꞉lo꞉ Lesol eyo꞉ ene nanog ka꞉isale Bilha a꞉no꞉ Ya꞉koba꞉ inga doma꞉ki ta꞉tabiki, Ya꞉kob e Bilha o꞉lia꞉ alila꞉la꞉ga꞉, so꞉wayo꞉ alelo꞉ ko꞉lo꞉ eyo꞉ kalu so꞉wayo꞉ sa꞉la꞉me. ");
INSERT INTO bco_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Sa꞉la꞉liabiki Lesol eyo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ nilo꞉ man dimida꞉sen a꞉no꞉ aloba꞉da꞉sa꞉ga꞉, eyo꞉ nemo꞉wo꞉ o꞉li dimidabo꞉lo꞉b a꞉la꞉asulo꞉ ko꞉lo꞉, nilo꞉ dabu ba꞉ba꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, kalu so꞉wayo꞉ nemo꞉wo꞉ dimiab.” Lesol eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, so꞉wa a꞉no꞉ Dan wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","A꞉ma꞉ fa꞉s amio꞉, Bilhayo꞉ wa꞉ka alela꞉sa꞉ga꞉, kalu so꞉wa nowo꞉ Ya꞉kobo꞉ sa꞉la꞉me. ");
INSERT INTO bco_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Sa꞉la꞉liabiki, Lesol eyo꞉ a꞉la꞉sio꞉, “Ne nado o꞉lia꞉ eteyo꞉wo꞉ alan dowa꞉len a꞉no꞉, o꞉go꞉ niyo꞉ tinio꞉l.” A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa a꞉no꞉ Nabtali wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","10","Leayo꞉ e so꞉wayo꞉ wa꞉kabiyo꞉ mo꞉sa꞉la꞉lia꞉no꞉ dowabiki, ene nanog ka꞉isale Silba a꞉no꞉ Ya꞉koba꞉ inga doma꞉ki ta꞉fo꞉ ko꞉lo꞉, Silba eyo꞉ kalu so꞉wa nowo꞉ Ya꞉kobo꞉ sa꞉la꞉me. ");
INSERT INTO bco_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","So꞉wa a꞉no꞉ sa꞉la꞉liabikiyo꞉, Lea eyo꞉ a꞉la꞉sio꞉, “Mada o꞉m, nemo꞉wo꞉ nafale dimidab.” A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ so꞉wa a꞉no꞉ Gad wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","13","A꞉ma꞉ fa꞉s amio꞉, Leaya꞉ ene nanog ka꞉isale Silbayo꞉ kalu so꞉wa nowo꞉ wa꞉ka sa꞉la꞉liabiki, Lea eyo꞉ a꞉la꞉sio꞉, “Ne mada sagalo꞉ alan dowab ko꞉lo꞉, ka꞉isale nolba꞉yo꞉ ‘E sagalo꞉ dowab’ a꞉la꞉sa꞉ma꞉ib.” A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ so꞉wa a꞉no꞉ Asel wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Da꞉si wit folo꞉ tuma꞉no꞉ ho꞉len a꞉no꞉ fa꞉la꞉dowabiki, Lubeno꞉ egelo꞉wa sia꞉likiyo꞉, mendeg hende nolo꞉ walilia꞉sa꞉ga꞉, ano Lea emo꞉wo꞉ dia꞉gane. A꞉la꞉ta꞉ga꞉ Lesol eyo꞉ Leamo꞉wo꞉ a꞉la꞉sio꞉, “Mendeg hende ko꞉lo꞉ gi so꞉waya꞉lo꞉ dia꞉yab a꞉no꞉ nolo꞉ nelo꞉ mena.” ");
INSERT INTO bco_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Ko꞉sega Lea eyo꞉ emo꞉wo꞉ gadi sa꞉lakiyo꞉, “Kalu nilo꞉wo꞉ gi afale dio꞉go꞉le ko꞉sega, man a꞉no꞉ o꞉ngo꞉malo꞉ngo꞉ a꞉la꞉asulakiyo꞉, o꞉go꞉ mendeg hende ni so꞉waya꞉lo꞉ a꞉no꞉lo꞉ gi afale dia꞉nigaya?” A꞉la꞉sa꞉labiki Lesol eyo꞉ a꞉la꞉sio꞉, “Giyo꞉ mendeg hende we nemo꞉wo꞉ dimialega, o꞉g nuluwo꞉ Ya꞉kobo꞉ ge o꞉lia꞉ alima꞉ hamana a꞉la꞉sa꞉ma꞉no꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","A꞉la꞉go꞉ko꞉lo꞉ ga꞉lowo꞉ Ya꞉kobo꞉ egelo꞉wa a꞉la꞉ta꞉ga꞉ ya꞉len ami, Lea eyo꞉ e galilia꞉ga꞉ a꞉la꞉sio꞉, “O꞉go꞉ ni so꞉waya꞉lo꞉ mendeg hende dia꞉mio꞉ a꞉ma꞉yo꞉ ge o꞉ma kilili ko꞉lo꞉, o꞉g nuluwo꞉ ge ne o꞉lia꞉ alima꞉no꞉.” A꞉la꞉sa꞉labiki o꞉g nulu a꞉namio꞉ Lea o꞉lia꞉ ali. ");
INSERT INTO bco_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Lea elo꞉ asulo꞉ a꞉no꞉ Gode eyo꞉ ba꞉ba꞉ ko꞉lo꞉, e so꞉wayo꞉ alela꞉sa꞉ga꞉, kalu so꞉wa biyo꞉ Ya꞉kobo꞉ a꞉na sa꞉la꞉me. ");
INSERT INTO bco_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Sa꞉la꞉liakiyo꞉ Lea eyo꞉ a꞉la꞉sio꞉, “Ni nanog ka꞉isaleyo꞉ kalu nilo꞉mo꞉ dimi ko꞉lo꞉, Gode eyo꞉ nemo꞉wo꞉ sagalakiyo꞉, wa꞉lo꞉ dimiab.” A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ so꞉wa a꞉no꞉ Isaka wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","20","A꞉ma꞉ fa꞉s amio꞉, Leayo꞉ wa꞉ka alela꞉sa꞉ga꞉, kalu so꞉wa do꞉go꞉feyo꞉ a꞉na Ya꞉kobo꞉ sa꞉la꞉me ko꞉lo꞉ eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ kalu so꞉wa do꞉go꞉fela꞉fo꞉ we Ya꞉kob emo꞉ sa꞉la꞉me. Gode eyo꞉ boba nafale a꞉no꞉ nemo꞉ dimiabo꞉lo꞉biki, o꞉go꞉ kalu nilo꞉ma꞉yo꞉ ne wabuluma꞉ib.” Eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, so꞉wa a꞉no꞉ Sebulun wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tif amio꞉, Lea eyo꞉ ka꞉isale so꞉wa imilig nowo꞉ a꞉na sa꞉la꞉lia꞉sa꞉ga꞉, Daina wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ Lesolo꞉ wa꞉ka asulabikiyo꞉, elo꞉ dulugu sio꞉ a꞉no꞉ Godeyo꞉ da꞉da꞉sa꞉ga꞉, Lesol e so꞉wayo꞉ o꞉li sa꞉la꞉lima꞉ki dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","A꞉la꞉dimidabiki Lesol e so꞉wayo꞉ alelo꞉ ko꞉lo꞉, kalu so꞉wayo꞉ a꞉na sa꞉la꞉lia꞉sa꞉ga꞉, eyo꞉ a꞉la꞉sio꞉, “Ne ko꞉lo꞉ sendelowa꞉sen a꞉no꞉ Gode eyo꞉ dila꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Lesol eyo꞉ to nowo꞉ a꞉sa꞉lakiyo꞉, “Yawe eyo꞉ kalu so꞉wa nowo꞉ nemo꞉wo꞉ wa꞉ka a꞉dimina꞉ki asulo꞉l.” A꞉la꞉sio꞉ ko꞉lo꞉ so꞉wa a꞉no꞉ Yosa꞉b wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Lesol eyo꞉ Yosa꞉bo꞉ sa꞉la꞉lia꞉sa꞉ga꞉ dowabikiyo꞉, Ya꞉kob eyo꞉ Labanbo꞉wo꞉ a꞉la꞉sio꞉, “Ne o꞉go꞉ no꞉no꞉n hena ha꞉na꞉no꞉ asulab ko꞉lo꞉ giyo꞉ ne iliga꞉foma. ");
INSERT INTO bco_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Niyo꞉ ga o꞉lia꞉ so꞉wa o꞉lia꞉ kililiakiyo꞉, nanog gilo꞉wo꞉ halaido꞉ dimida꞉len. Nanog a꞉no꞉ tambo ditandale ko꞉lo꞉, o꞉go꞉ giyo꞉ ni ga o꞉lia꞉ so꞉wa o꞉lia꞉ a꞉no꞉ nemo꞉ tililia꞉ hamana꞉ki ta꞉foma.” ");
INSERT INTO bco_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","A꞉la꞉sa꞉labiki Laban eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Tamin amio꞉ niyo꞉ to nowo꞉ gemo꞉ ko꞉le sa꞉ma꞉nigo꞉l. Niyo꞉ fofa dimidan mamamo꞉wo꞉ dabu ba꞉ba꞉ amio꞉, iliyo꞉ fanda asuluma꞉no꞉ we nemo꞉ wido꞉. Ge ne o꞉lia꞉lo꞉ dofo꞉len a꞉na ilikiyo꞉, niyo꞉ Yawe eyo꞉ ne nafale mesea꞉ki ta꞉fo꞉labo꞉lo꞉b a꞉la꞉bo꞉ ele ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","A꞉la꞉fo꞉ko꞉lo꞉ ge wenaka o꞉salega, nanog gilo꞉ diab amilo꞉ kililia꞉no꞉ a꞉no꞉, kelego꞉ gilo꞉ asulakilo꞉ sa꞉lab aumbo꞉, niyo꞉ gemo꞉wo꞉ o꞉li dimia꞉no꞉ ko꞉lo꞉lab.” ");
INSERT INTO bco_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","A꞉la꞉sa꞉labiki, Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ne dona modo꞉wo꞉ gi nanogo꞉ nafale dia꞉len a꞉la꞉bo꞉ ge asulab. A꞉la꞉ta꞉ga꞉ no꞉ fofo꞉ gilo꞉wo꞉ niyo꞉ dinafa bo꞉fo꞉len ko꞉lo꞉ nafale fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ne wilo꞉ o꞉semo꞉ mio꞉ amio꞉, ge kelego꞉ a꞉la꞉se ko꞉lo꞉ elen, ko꞉sega nilo꞉ bo꞉fo꞉len amio꞉ kelego꞉ gilo꞉ a꞉no꞉ modo꞉ ko꞉lo꞉ analifa꞉. Niyo꞉ nanogdo꞉ dia꞉len amio꞉ Yawe eyo꞉ ne asuwa꞉takiyo꞉, ge nafale mesea꞉ki ta꞉fo꞉lab. Ko꞉sega so꞉lo꞉ nilo꞉ we abe asuwa꞉fa꞉iba? O꞉go꞉ no꞉no꞉n so꞉lo꞉wo꞉ ko꞉lo꞉ tilidoma꞉no꞉ asulab.” ");
INSERT INTO bco_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","A꞉la꞉sa꞉labiki Laban eyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge wenamio꞉ o꞉mesa꞉nikiyo꞉, niyo꞉ gemo꞉wo꞉ kelego꞉ o꞉b ko꞉lo꞉ dimina꞉ki asulaya?” Ya꞉kobo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉, a꞉ma꞉la꞉ sa꞉laki, “A, giyo꞉ kelego꞉wo꞉ nemo꞉wo꞉ dimia꞉so꞉bo. Ko꞉sega giyo꞉ nemo꞉wo꞉ to nowo꞉ dinali sa꞉lalega, gi no꞉ fofan a꞉no꞉ niyo꞉ wa꞉ka a꞉bo꞉fo꞉mela꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","O꞉go꞉ ne ha꞉na꞉sa꞉ga꞉yo꞉, sibi o꞉lia꞉ goudi o꞉lia꞉ gilo꞉ a꞉no꞉ ni aloba꞉daki, sibi o꞉lia꞉ goudi o꞉lia꞉ momado꞉le a꞉no꞉, a꞉la꞉ta꞉ga꞉ sibi inso꞉ henela꞉ a꞉no꞉lo꞉ aloba꞉da꞉sa꞉ga꞉, ni nanog diab amilo꞉ kililian aumbo꞉, a꞉no꞉ tambo ne dia꞉no꞉ asulo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Niyo꞉ digale dimido꞉wa꞉le a꞉la꞉likiyo꞉, giyo꞉ tif amio꞉ bebema꞉ yakiyo꞉, goudi mo꞉momado꞉ nowo꞉ a꞉la꞉ta꞉ga꞉ sibi inso꞉ mo꞉henela꞉ nowo꞉ ko꞉lo꞉ no꞉ nilo꞉ usamio꞉ ba꞉dalega, giyo꞉ ni afale dilo꞉b a꞉la꞉asuluma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ya꞉kob elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, Laban eyo꞉ a꞉la꞉sio꞉, “O꞉li ko꞉m. Gilo꞉ sa꞉lab au dimidama꞉niki.” ");
INSERT INTO bco_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","36","Ko꞉sega o꞉g a꞉namio꞉ Laban e ha꞉na꞉ga꞉, goudi mala o꞉lia꞉ de o꞉lia꞉ momadela꞉le a꞉no꞉ a꞉la꞉ta꞉ga꞉ sibi inso꞉ henela꞉ a꞉no꞉lo꞉ tambo aloba꞉da꞉sa꞉ga꞉, Laban o꞉lia꞉ ene inso꞉ o꞉lia꞉ma꞉yo꞉ no꞉ a꞉no꞉ tililia꞉ ha꞉nakiyo꞉, ho꞉len otalen alita꞉ga꞉, ene so꞉wamo꞉ bo꞉fo꞉melea꞉ki a꞉na ta꞉fo꞉. A꞉la꞉dimida꞉labikiyo꞉, Ya꞉kob e amisa꞉n a꞉naka siliki, Labana꞉ no꞉ fofo꞉ nolo꞉ e bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Ya꞉kob eyo꞉ no꞉ nolo꞉ bo꞉fo꞉likiyo꞉, i ko꞉li ko꞉lilo꞉ a꞉ma꞉ ele nolo꞉ gedea꞉sa꞉ga꞉, i ele a꞉namio꞉ ho꞉lo꞉ fa꞉la꞉doma꞉kiyo꞉, do꞉go꞉f nolo꞉ sili alifela꞉sa꞉ga꞉ dila꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Eyo꞉ i ele momado꞉ a꞉no꞉ no꞉wa꞉lo꞉ ho꞉ndo꞉ na꞉sen i solo꞉ us a꞉na difa꞉. A꞉la꞉do꞉ dimido꞉ a꞉ma꞉yo꞉, no꞉wa꞉yo꞉ ho꞉no꞉ ma꞉ni yakiyo꞉, i ele momado꞉ a꞉no꞉ ili milifa doma꞉ki go꞉. Mo꞉wo꞉ no꞉wo꞉ ho꞉n ma꞉ni yakiyo꞉, iyo꞉ a꞉na ga꞉gila꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","A꞉la꞉dimidalifa꞉ ko꞉lo꞉ no꞉wo꞉ i ele momado꞉ a꞉no꞉ bo꞉fo꞉liki ga꞉la꞉lab ko꞉lo꞉, inso꞉wo꞉ tambo momado꞉le segesela꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ya꞉kob eyo꞉ sibi inso꞉ momadela꞉ a꞉no꞉ aloba꞉da꞉sa꞉ga꞉, egelese mesea꞉ki ta꞉fo꞉. A꞉la꞉ta꞉ga꞉ no꞉ malalo꞉ ga꞉lab ho꞉len a꞉namio꞉, Ya꞉kob eyo꞉ no꞉ malayo꞉ no꞉ momado꞉ a꞉no꞉ ko꞉lo꞉ bo꞉fo꞉liki ga꞉la꞉melea꞉ki ta꞉fo꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ no꞉ momado꞉le silia꞉ta꞉len a꞉no꞉ alobanalia꞉ ta꞉felo꞉ ko꞉lo꞉, Labana꞉ no꞉ o꞉lia꞉ Ya꞉koba꞉ ene no꞉ a꞉no꞉lia꞉yo꞉ mo꞉gasa dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","No꞉ mala halaido꞉ a꞉no꞉ ga꞉lima꞉no꞉ ho꞉len dowab amio꞉, Ya꞉kob eyo꞉ i ele momado꞉ a꞉no꞉ no꞉wa꞉lo꞉ ho꞉ndo꞉ na꞉sen i solo꞉ us a꞉na dia꞉ta꞉sen. A꞉la꞉dimido꞉ a꞉ma꞉yo꞉ no꞉ malaya꞉lo꞉ ga꞉la꞉lab amio꞉, i ele a꞉no꞉ ini milifa doma꞉ki go꞉. ");
INSERT INTO bco_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ko꞉sega no꞉ mala halaido꞉lo꞉ma a꞉no꞉ ga꞉lima꞉no꞉ ho꞉len dowab amio꞉, i ele a꞉no꞉ mo꞉dia꞉ta꞉sen. A꞉la꞉go꞉ko꞉lo꞉ no꞉ inso꞉ halaido꞉lo꞉ma dowab a꞉no꞉ Laban eno꞉ ta꞉taki, no꞉ inso꞉ halaido꞉lo꞉ dowab a꞉no꞉ Ya꞉kob e di. ");
INSERT INTO bco_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","A꞉la꞉dimida꞉labikiyo꞉, Ya꞉kob e wilo꞉ kalu mada alan fa꞉la꞉dowakiyo꞉, no꞉ fofo꞉ enedo꞉ a꞉no꞉lo꞉, nanog dian kaluka꞉isaleyo꞉lo꞉, donkiyo꞉lo꞉, a꞉la꞉ta꞉ga꞉ ka꞉mol o꞉lia꞉yo꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Labana꞉ inso꞉wa꞉yo꞉ egele nenelai a꞉la꞉sio꞉, “Kelego꞉ dowa꞉lo꞉ da꞉lab a꞉no꞉ tambo Ya꞉koba꞉ afale dia꞉sa꞉ga꞉, e wilo꞉ kalu dowab” a꞉la꞉do꞉ nenelo꞉ a꞉no꞉ Ya꞉kobo꞉ dabu. ");
INSERT INTO bco_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","A꞉la꞉ta꞉ga꞉ a꞉no꞉ da꞉da꞉ga꞉ elena, Ya꞉kob eyo꞉ Labana꞉lo꞉ tamin amilo꞉ emo꞉lo꞉ sagala꞉sen aumbo꞉ mo꞉dimidaki, o꞉go꞉ emo꞉wo꞉ mo꞉beabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","A꞉la꞉go꞉ko꞉lo꞉ Yawe eyo꞉ Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “O꞉go꞉ ge go꞉la꞉ hendeya ha꞉na꞉ga꞉, go꞉no꞉n so꞉lo꞉lo꞉ sabdo꞉ a꞉na a꞉ma꞉la꞉ ha꞉na꞉bi. Ne ge o꞉lia꞉ doma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","O꞉g a꞉namio꞉ Ya꞉kob e no꞉ fo꞉fo꞉ enedo꞉ a꞉no꞉ ilaboda꞉ siliki bo꞉fo꞉len ko꞉lo꞉, inga a꞉la꞉ Lesol o꞉lia꞉ Lea o꞉lia꞉yo꞉ elo꞉wa mena꞉ki saga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","A꞉la꞉yo꞉ elo꞉ elen a꞉na fa꞉la꞉dowabiki, inga a꞉la꞉mo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Go꞉la꞉yo꞉ tamin amilo꞉ nemo꞉lo꞉ sagala꞉sen aumbo꞉ mo꞉dimidaki, o꞉go꞉ nemo꞉wo꞉ mo꞉beabo꞉lo꞉b a꞉la꞉asulo꞉. Ko꞉sega dowa꞉ Godeyo꞉ ne o꞉lia꞉ dowa꞉i ya꞉sen ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Niyo꞉ go꞉la꞉ nanog diakiyo꞉, halaido꞉ dia꞉len a꞉la꞉bo꞉ ga꞉go꞉lo꞉ asulo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Ko꞉sega go꞉la꞉yo꞉ ne dikidakiyo꞉, nilo꞉ nanog di amilo꞉ kililian a꞉no꞉ ko꞉li ko꞉lile a꞉la꞉nodola꞉i aneyo꞉, wa꞉ka wa꞉ka dimidaki do꞉la꞉fo꞉ fa꞉la꞉dowab. Ko꞉sega elo꞉ ne mogagima꞉kilo꞉ dimido꞉ a꞉no꞉ Gode eyo꞉ kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Tamin amio꞉ go꞉la꞉yo꞉ nemo꞉ dinali sa꞉lakiyo꞉, ‘Gilo꞉ nanog di amilo꞉ kililia꞉no꞉wo꞉ we. Goudi bobeyo꞉ momadela꞉le segeselab a꞉no꞉ tambo gi dia꞉bi,’ A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ goudi inso꞉wo꞉ tambo bobeyo꞉ momadela꞉le a꞉no꞉ ko꞉lo꞉ segesela꞉i ya꞉lab. Go꞉la꞉yo꞉ a꞉la꞉do꞉ fa꞉la꞉dowab a꞉no꞉ ba꞉da꞉ga꞉yo꞉, enedo꞉ dinali sio꞉ a꞉no꞉ a꞉nodolakiyo꞉, nemo꞉wo꞉ a꞉la꞉sio꞉, ‘O꞉go꞉ gilo꞉ nanog di amilo꞉ kililia꞉no꞉wo꞉ we. Goudi sidi alifelakilo꞉ momadela꞉le segeselab a꞉no꞉ tambo gi dia꞉bi.’ A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ goudi inso꞉wo꞉ tambo sidi alifelakilo꞉ momadela꞉le a꞉no꞉ ko꞉lo꞉ segesela꞉i ya꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","A꞉la꞉do꞉ go꞉ a꞉na ilikiyo꞉, Gode eneno꞉ no꞉ fofo꞉ go꞉la꞉lo꞉ a꞉no꞉ dila꞉sa꞉ga꞉, nemo꞉wo꞉ a꞉na dimi. ");
INSERT INTO bco_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“A꞉la꞉ta꞉ga꞉ no꞉ ga꞉labdo꞉ ho꞉len a꞉namio꞉, ne ofowo꞉ a꞉la꞉ba꞉ba꞉. Goudi de momadela꞉le ko꞉li ko꞉lilo꞉ a꞉ma꞉yo꞉ malayo꞉ ga꞉la꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ne ofolakiyo꞉, Godeya꞉ ma꞉mul kaluwa꞉yo꞉ nemo꞉wo꞉, ‘Ya꞉kob.’ A꞉la꞉ho꞉idabiki niyo꞉, ‘O꞉ba, ne weko꞉,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Eyo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉, ‘Ge bo꞉ba! Goudi de ga꞉la꞉labdo꞉ a꞉no꞉ tambo momadela꞉le ko꞉li ko꞉lilo꞉ ko꞉lo꞉lab. Laban elo꞉ gemo꞉lo꞉ dimidab a꞉no꞉ ne ba꞉ba꞉ ko꞉lo꞉ niyo꞉ a꞉la꞉dimida꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Gode gilo꞉ Betel hen a꞉namilo꞉ galili a꞉no꞉ ne. Hen a꞉namio꞉ giyo꞉ u nowo꞉ gele alitakiyo꞉, wa ho꞉no꞉ a꞉na tulu alifa꞉. A꞉la꞉ta꞉ga꞉ giyo꞉ towo꞉ nemo꞉wo꞉ dinali saefa꞉. A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ ge hen we ta꞉ta꞉ga꞉, go꞉no꞉n hendeya a꞉ma꞉la꞉ hamana.’ Ma꞉mul kaluwa꞉yo꞉ a꞉la꞉sio꞉ ko꞉lo꞉, niyo꞉ ga꞉gbo꞉wo꞉ a꞉na malolo meo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, Lesol o꞉lia꞉ Lea o꞉lia꞉ma꞉yo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Dowa꞉ dabun kelego꞉wo꞉ naindo꞉ mo꞉dia꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Dowa꞉yo꞉ na꞉no꞉ kelego꞉wo꞉ o꞉ngo꞉ asula꞉sa꞉ga꞉, mole dia꞉no꞉ a꞉lakiyo꞉, na꞉no꞉lo꞉ a꞉la꞉kililia꞉saga꞉yo꞉, mole elo꞉ di a꞉no꞉ tambo e mo꞉no꞉. A꞉la꞉do꞉ dimido꞉ a꞉ma꞉yo꞉ dowa꞉yo꞉ na꞉no꞉ ene ida꞉malo꞉ngo꞉ gola ba꞉daki ta꞉tab. ");
INSERT INTO bco_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Kelego꞉ dowa꞉lo꞉ ko꞉lo꞉ Godeya꞉lo꞉ gemo꞉lo꞉ dimi a꞉no꞉, na꞉no꞉lo꞉, nain so꞉wayo꞉lo꞉ nilino꞉ dowab. A꞉la꞉fo꞉ko꞉lo꞉ gemo꞉lo꞉ Godeya꞉lo꞉ sio꞉ au dimidama.” A꞉la꞉ma꞉yo꞉ inbo꞉wo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Ya꞉kob eyo꞉ dasila꞉sa꞉ga꞉, ingayo꞉lo꞉, ene so꞉wayo꞉lo꞉ tambo ka꞉mol wa꞉la kandata꞉ga꞉yo꞉, kelego꞉ elo꞉ a꞉namilo꞉ di a꞉no꞉ tambo dimidalia꞉sa꞉ga꞉ ha꞉nakiyo꞉, Mesobotemia a꞉namilo꞉ no꞉ fofo꞉ di a꞉no꞉ tambo o꞉sa꞉liki, ene iya Aisa꞉ga꞉ hen Ka꞉ina꞉n a꞉na ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Iyo꞉ ha꞉na꞉nikiyo꞉, Labano꞉ sibi fo꞉no꞉ gedea꞉liki ko꞉na꞉ sabiki, Lesol eyo꞉ iyaya꞉ madali gode mama momado꞉ i a꞉no꞉ afale dia꞉sa꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","A꞉la꞉ta꞉ga꞉ Ya꞉kob e ha꞉na꞉nikiyo꞉, e ha꞉na꞉nigo꞉lka꞉ a꞉la꞉bo꞉ ena꞉so Labanbo꞉wo꞉ mo꞉sa꞉laki, e dikida꞉sa꞉ga꞉ wo꞉no꞉le ane. ");
INSERT INTO bco_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob eyo꞉ kelego꞉ enedo꞉wo꞉ tambo dia꞉sa꞉ga꞉, hen a꞉na mesa꞉no꞉wo꞉ mo꞉bea꞉sa꞉ga꞉ ha꞉nakiyo꞉, Labana꞉ heno꞉ ta꞉ta꞉ga꞉, Yufuletis ho꞉no꞉ ta꞉nota꞉ga꞉, Gilead misio꞉lo꞉ doba꞉da꞉ ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ho꞉len otaleno꞉ ta꞉ta꞉ga꞉yo꞉, Laban e Ya꞉kobo꞉ hen wena mesa꞉no꞉ mo꞉beaki aneka꞉ a꞉la꞉bo꞉ a꞉na dabu. ");
INSERT INTO bco_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Eyo꞉ da꞉da꞉sa꞉ga꞉yo꞉, ene eso꞉lo꞉ nolo꞉ kegea꞉sa꞉ga꞉, iyo꞉ Ya꞉kobo꞉ kudu ane. Kudu ha꞉na꞉la꞉ga꞉, ho꞉len dom a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, Ya꞉kobo꞉ Gilead misio꞉ hen a꞉na ha꞉na꞉lena galili. ");
INSERT INTO bco_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Laban e Ya꞉kobo꞉ o꞉galima꞉ni kudu ha꞉nakiyo꞉, nulu ali amio꞉, Alam kalu Laban e ofolakiyo꞉, Godeyo꞉ elo꞉wa fa꞉la꞉dowaki a꞉la꞉sio꞉, “Giyo꞉ Ya꞉kobo꞉wo꞉ ha꞉nolo꞉ to o꞉lia꞉ tagima꞉no꞉ to o꞉lia꞉yo꞉ sa꞉la꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ya꞉kob e Gilead misio꞉ a꞉namio꞉ helebeso꞉g ayo꞉ dia꞉sa꞉ga꞉ sen ami, Laban eyo꞉ Ya꞉kobo꞉ a꞉na galilia꞉ga꞉yo꞉, Ya꞉koba꞉lo꞉ alo꞉ di anib a꞉na Laban ene eso꞉lo꞉ mio꞉ a꞉ma꞉yo꞉lo꞉ helebeso꞉g ayo꞉ a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","A꞉la꞉ta꞉ga꞉ Laban eyo꞉ Ya꞉kobo꞉ towo꞉ a꞉la꞉sio꞉, “Gi mio꞉ we, wangabi go꞉wo꞉? Giyo꞉ ne dikida꞉sa꞉ga꞉yo꞉, gis kaluwa꞉lo꞉ amisa꞉no꞉ bidila꞉sa꞉ga꞉lo꞉ ka꞉isaleyo꞉ tililia꞉ ha꞉nan aumbo꞉, giyo꞉ na꞉la꞉ a꞉la꞉ welo꞉ tililia꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Giyo꞉ ne dikidakilo꞉, ne ho꞉no꞉lka꞉ a꞉la꞉bo꞉ nemo꞉wo꞉ mo꞉sa꞉lakilo꞉ mio꞉ a꞉no꞉ wangabi go꞉wo꞉? Gio꞉ ha꞉na꞉nikiyo꞉ nemo꞉wo꞉ sio꞉ kibo꞉bowo꞉, niyo꞉ ma꞉no꞉ alan dowo꞉ta꞉sa꞉ga꞉, sagalaki a꞉namio꞉ gita o꞉lia꞉ sologa o꞉lia꞉yo꞉ dia꞉ga꞉, gisalo꞉wo꞉ sa꞉la꞉b a꞉la꞉ta꞉ga꞉yo꞉ gio꞉ ebea꞉sa꞉ga꞉ hamana꞉ki iliga꞉fo꞉lo. ");
INSERT INTO bco_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Giyo꞉ nemo꞉wo꞉ na꞉la꞉la꞉yo꞉ a꞉la꞉ta꞉ga꞉ ni ma꞉mui a꞉no꞉lo꞉ mimila꞉sa꞉ga꞉ iliga꞉foma꞉kiyo꞉, mo꞉sio꞉ a꞉no꞉ mo꞉wo꞉ ha꞉? Ge mada hala dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Niyo꞉ ge o꞉li mogagila꞉ma꞉no꞉ dowo꞉ ko꞉sega, ali nuluwo꞉ Gode go꞉la꞉lo꞉wo꞉ nelo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉, towo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉, ‘Giyo꞉ Ya꞉kobo꞉wo꞉ ha꞉nolo꞉ to o꞉lia꞉ tagima꞉no꞉ to o꞉lia꞉yo꞉ sa꞉la꞉so꞉bo,’ Gode eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","A꞉la꞉fo꞉ko꞉lo꞉ ge go꞉no꞉n hendeya ha꞉na꞉no꞉wo꞉ mada alan asulabo꞉lo꞉b a꞉la꞉bo꞉ ni asulab, ko꞉sega no꞉no꞉n godeya꞉ mama momado꞉ i a꞉no꞉, giyo꞉ waga afale dia꞉mio꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Giyo꞉ ga꞉la꞉ a꞉la꞉yo꞉ go꞉no꞉na꞉ma꞉la꞉ asulia꞉ib a꞉la꞉bo꞉ a꞉la꞉asula꞉sa꞉ga꞉ ne tagi dowo꞉ ko꞉lo꞉, niyo꞉ gemo꞉wo꞉ mo꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Ko꞉sega go꞉no꞉n godeya꞉ mama ko꞉lo꞉ momado꞉ i a꞉no꞉ ni us wenamio꞉ imilig noma꞉yo꞉ ta꞉liseno꞉lalega, e mada sana soma꞉no꞉. Giyo꞉ ni us wenamio꞉ kelego꞉ gilo꞉ nolo꞉ a꞉laba꞉le a꞉lalikiyo꞉, ninin so꞉lo꞉ wema꞉ siwa꞉l amio꞉ keda꞉i hamana. Gi kelego꞉wo꞉ ba꞉dalega, go꞉no꞉na꞉ma꞉la꞉ dia꞉bi.” Ya꞉kob elo꞉ a꞉la꞉do꞉ sio꞉ a꞉no꞉, Lesol elo꞉ iyaya꞉ gode momado꞉ ko꞉lo꞉ afalelo꞉ dia꞉mio꞉ a꞉no꞉ mo꞉asulaki sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","A꞉la꞉fo꞉ko꞉lo꞉ tamin amio꞉ Laban eyo꞉ Ya꞉koba꞉ helebeso꞉g aya tina꞉sa꞉ga꞉ kedo꞉. A꞉la꞉ta꞉ga꞉yo꞉ Leaya꞉ ayamio꞉lo꞉ a꞉na kedo꞉. A꞉la꞉ta꞉ga꞉ nanog ka꞉isale a꞉la꞉ma꞉ ayamio꞉ tina꞉sa꞉ga꞉ kedo꞉. Edakiyo꞉, Lesola꞉ a usa tiane. ");
INSERT INTO bco_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","35","Lesol eyo꞉ iyaya꞉ godeyo꞉ ko꞉lo꞉ dia꞉mio꞉ i a꞉no꞉, ene helebeso꞉g a usa tamina dia꞉ tina꞉sa꞉ga꞉, ka꞉mol wa꞉l amilo꞉ sa꞉sen kelego꞉ a꞉ma꞉ us a꞉na wo꞉no꞉le difa꞉ ko꞉lo꞉, e a꞉ma꞉ wa꞉la asifo꞉. Laban eyo꞉ ene a a꞉no꞉ tambo kelelia꞉sa꞉ga꞉ mo꞉ba꞉dabikiyo꞉, Lesol eyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “A, do ge nemo꞉wo꞉ gadia꞉so꞉bo. Ne ele walaf dowo꞉ ko꞉lo꞉ mo꞉dasima꞉no꞉ so꞉l” a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ Laban eyo꞉ ayo꞉ tambo keda꞉i ane ko꞉sega e mada mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Kelego꞉ a꞉no꞉ mo꞉ba꞉dabiki, Ya꞉kob eyo꞉ Labanbo꞉wo꞉ alan kulufa꞉ya꞉sa꞉ga꞉, emo꞉wo꞉ gadiaki a꞉la꞉sio꞉, “Gilo꞉ ne ko꞉lo꞉ kudulia꞉ mio꞉ we, niyo꞉ mogago꞉wo꞉ o꞉b ko꞉lo꞉ dimido꞉lo꞉bi ba꞉daya? ");
INSERT INTO bco_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Kelego꞉ nililo꞉wo꞉ tambo giyo꞉ keleli ko꞉lo꞉, kelego꞉ gilo꞉wo꞉ o꞉bo꞉ngo꞉ ko꞉lo꞉ ba꞉ba꞉yo꞉? Kelego꞉ gilo꞉ ba꞉ba꞉ a꞉no꞉, gi so꞉lo꞉ o꞉lia꞉ ni so꞉lo꞉ o꞉lia꞉ma꞉ si wa꞉l amio꞉ kalaba dia꞉foma. Dia꞉taliki ba꞉da꞉sa꞉ga꞉, iliyo꞉ na꞉n us a꞉namio꞉ alobana sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ne donayo꞉ do꞉la꞉fo꞉ a꞉la꞉yo꞉ gi nanog dia꞉likilo꞉ elen a꞉namio꞉, no꞉ mala gilo꞉wo꞉ mo꞉safalaki inso꞉wo꞉ segesela꞉len, a꞉la꞉ta꞉ga꞉ sibi de gilo꞉ a꞉no꞉ ni sanalia꞉ga꞉yo꞉ mo꞉mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","No꞉ fofo꞉ gilo꞉ a꞉no꞉ saila gasaya꞉ sa꞉ndab amio꞉, niyo꞉ gemo꞉wo꞉ mo꞉sa꞉laki, no꞉ fofo꞉ nilo꞉wo꞉ gino꞉ a꞉ta꞉ta꞉li a꞉la꞉dimida꞉sen. Giyo꞉ nemo꞉wo꞉ towo꞉ halaido꞉ sa꞉lakiyo꞉, ‘Nuluwo꞉lo꞉ ho꞉lenowo꞉lo꞉ no꞉ fofo꞉ sulu ha꞉nab a꞉no꞉ tambo a꞉ma꞉la꞉ dugu mea꞉bi’ a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ne gi nanog dia꞉likiyo꞉, disiyo꞉ ne ofa꞉yo꞉ so꞉da꞉sen a꞉la꞉ta꞉ga꞉ nuluwo꞉ hido꞉wo꞉ alan dowaki, niyo꞉ mo꞉alila꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ne dona do꞉la꞉fo꞉ a꞉la꞉ us a꞉namio꞉ gi nanogo꞉ dia꞉i ya꞉len. Niyo꞉ ga꞉la꞉ a꞉la꞉ma꞉ fudo꞉ a꞉no꞉ ko꞉lo꞉ kililian augakiyo꞉, dona babola꞉fo꞉ a꞉namio꞉ nanog gilo꞉wo꞉ madali dimida꞉len. A꞉la꞉ta꞉ga꞉ dona do꞉go꞉fela꞉fo꞉ no amio꞉ ne no꞉ dia꞉no꞉ a꞉laki, gi no꞉wo꞉ a꞉na bo꞉fo꞉len. A꞉la꞉go꞉ ko꞉sega giyo꞉ modo꞉ dikidakiyo꞉, nilo꞉ nanog di amilo꞉ kililian a꞉no꞉ ko꞉li ko꞉lile a꞉la꞉nodola꞉i aneyo꞉, wa꞉ka wa꞉ka dimidaki do꞉la꞉fo꞉ fa꞉la꞉dowab. ");
INSERT INTO bco_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ni ma꞉mu Ablahama꞉ Gode, do Aisa꞉ga꞉lo꞉ wabuda꞉sen a꞉ma꞉yo꞉ ne mo꞉asufa꞉ kibo꞉bowo꞉, giyo꞉ ne no꞉no꞉n hen amio꞉ a꞉ma꞉la꞉yo꞉ madali iliga꞉fabe. Ko꞉sega nilo꞉ nanog halaido꞉ dia꞉len o꞉lia꞉ hida꞉yo꞉ gilo꞉ nemo꞉lo꞉ dimia꞉len a꞉no꞉lia꞉yo꞉ Gode e ba꞉da꞉sa꞉ga꞉, e ali nuluwo꞉ gelo꞉ amio꞉ ofowo꞉ a꞉na fa꞉la꞉dowakiyo꞉, gemo꞉wo꞉ hagugo꞉ to sio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laban eyo꞉ Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “Ga we ni na꞉la꞉, inso꞉ we ne ma꞉mui, a꞉la꞉ta꞉ga꞉ no꞉ fofo꞉ welo꞉ na꞉no꞉. Gi siya꞉lo꞉ o꞉gdo꞉ ba꞉dab a꞉no꞉ tambo na꞉no꞉ ko꞉lo꞉lab. Ko꞉sega niyo꞉ na꞉la꞉la꞉ o꞉lia꞉ so꞉wa ililo꞉ sa꞉la꞉la꞉ i o꞉lia꞉yo꞉ mo꞉ta꞉limesa꞉no꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","A꞉la꞉fo꞉ko꞉lo꞉ ne o꞉lia꞉ ge o꞉lia꞉yo꞉ o꞉g wena a꞉la꞉ta꞉ga꞉yo꞉ ha꞉sa mesa꞉niki, o꞉go꞉ na꞉no꞉ towo꞉ dinali saefa꞉no꞉. To saefa꞉no꞉ a꞉no꞉ ko꞉lo꞉ naino꞉ asula꞉ melea꞉kiyo꞉, uwo꞉ wena dibalima꞉niki.” ");
INSERT INTO bco_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","A꞉la꞉sa꞉labikiyo꞉ to saefa꞉no꞉ a꞉no꞉ tif amio꞉ asula꞉mela꞉no꞉ ko꞉lo꞉ Ya꞉kob eyo꞉ u sambo nowo꞉ a꞉na gele alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Gele alita꞉sa꞉ga꞉yo꞉, ene so꞉lo꞉wo꞉ uwo꞉ kegea꞉sa꞉ga꞉ a꞉na dibalima꞉ki sio꞉. Uwo꞉ dibida꞉sa꞉ga꞉yo꞉, ulo꞉ dibido꞉ aniba siliki, iyo꞉ ma꞉no꞉wo꞉ a꞉na mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","U dibido꞉ a꞉no꞉ wikilakiyo꞉, Laban eyo꞉ ene to sa꞉laki, Yega-Sahaduda a꞉la꞉wikilabiki, Ya꞉kob eyo꞉lo꞉ ene to sa꞉laki, Galed a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","A꞉la꞉ta꞉ga꞉ Laban eyo꞉ a꞉la꞉sio꞉, “O꞉gdo꞉ naindo꞉ to saefa꞉nikilo꞉ u dibido꞉l we, tif amio꞉ asula꞉mela꞉no꞉ ko꞉lo꞉ dibido꞉l.” A꞉la꞉fo꞉ko꞉lo꞉ hen a꞉no꞉ Galed wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","A꞉la꞉ta꞉ga꞉ Laban eyo꞉ to nowo꞉ a꞉la꞉sio꞉, “Na꞉no꞉ dagela꞉sa꞉ga꞉lo꞉ dowab a꞉namio꞉, Yawe e usa iliki, na꞉no꞉ ba꞉da꞉mela꞉ib.” A꞉la꞉fo꞉ko꞉lo꞉ hen wi nowo꞉ Misba a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban eyo꞉ towo꞉ kudu sa꞉laki a꞉la꞉sio꞉, “Tif amio꞉ giyo꞉ na꞉la꞉mo꞉wo꞉ mogago꞉ dimida꞉b o꞉ ga nowo꞉ dia꞉b a꞉lalega, noma꞉yo꞉ mo꞉ba꞉dalikiyo꞉, Gode eyo꞉ na꞉no꞉ ba꞉da꞉mela꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","“U sambo gele alifa꞉ a꞉no꞉lo꞉, u dibido꞉ a꞉no꞉lo꞉ ge asuluma. U a꞉no꞉ wena dofo꞉mela꞉ib ko꞉lo꞉, naindo꞉ dinali saetakilo꞉ u dibido꞉l we ge o꞉lia꞉ ne o꞉lia꞉yo꞉ ele dia꞉taki go꞉l. A꞉la꞉fo꞉ko꞉lo꞉ ge u we tinia꞉sa꞉ga꞉yo꞉, ne o꞉lia꞉ mo꞉babuma꞉ib. Niyo꞉lo꞉ u we tinia꞉sa꞉ga꞉yo꞉, ge o꞉lia꞉ mo꞉babuma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ablahamo꞉, ene ao Nahol o꞉lo꞉, a꞉la꞉ta꞉ga꞉ a꞉la꞉ma꞉ iya Telayo꞉lo꞉, ili Gode a꞉ma꞉yo꞉ na꞉nbo꞉wo꞉ alobana wida꞉mela꞉ib.” Laban eyo꞉ Ya꞉kobo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, Ya꞉kob eyo꞉ to a꞉no꞉ hendele kudu ha꞉na꞉no꞉ a꞉lakiyo꞉, iya Aisa꞉g a꞉ma꞉lo꞉ wabulu sa꞉la꞉sen Gode a꞉ma꞉ wiya iliki, towo꞉ a꞉na dinali saefa꞉. ");
INSERT INTO bco_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","A꞉la꞉saeta꞉ga꞉yo꞉ Ya꞉kob eyo꞉ misio꞉lo꞉ a꞉lab a꞉na siliki, Godemo꞉ bobayo꞉ so꞉mea꞉sa꞉ga꞉, ene so꞉lo꞉wo꞉ kegeaki, ma꞉no꞉wo꞉ dowo꞉ta꞉sa꞉ga꞉ a꞉na mo꞉no꞉. Ma꞉no꞉wo꞉ na꞉sa꞉ga꞉, misio꞉ a꞉na ali. ");
INSERT INTO bco_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kea꞉fo nuluwo꞉, Laban e dasila꞉sa꞉ga꞉, ida꞉ a꞉la꞉yo꞉ a꞉la꞉ta꞉ga꞉ e ma꞉muiyo꞉ mimila꞉sa꞉ga꞉, sagalo꞉ towo꞉ imo꞉wo꞉ sa꞉la꞉sa꞉ga꞉, e a꞉ma꞉la꞉ ene hena ane. ");
INSERT INTO bco_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ya꞉kob e hen a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉na꞉sena, Godeya꞉ ma꞉mula꞉ kalu iyo꞉ ya꞉ga꞉, Ya꞉kobo꞉ a꞉na galili. ");
INSERT INTO bco_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Ya꞉kob eyo꞉ ma꞉mula꞉ kalu ba꞉dakiyo꞉ a꞉la꞉sio꞉, “Hena꞉ usamilo꞉ Godelo꞉ dowa꞉sen heno꞉ wilo꞉ka꞉.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ hen a꞉no꞉ Mahanaim wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ho꞉len a꞉namio꞉ Iso꞉ e Seil hen, Idom hen us a꞉na sen ko꞉lo꞉, Ya꞉kob eyo꞉ tolo꞉ sa꞉ma꞉no꞉ kalu nolo꞉ ene ao Iso꞉lo꞉wa iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","5","Ya꞉kob eyo꞉ aomo꞉wo꞉ sa꞉ma꞉ni hamana꞉kiyo꞉, kalu i o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ ha꞉na꞉sa꞉ga꞉, ni misa꞉ kalu Iso꞉wo꞉ galiliakiyo꞉, to we ni nao wa꞉la꞉bo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘Gi nanogdo꞉ dian kalu Ya꞉kob eyo꞉ towo꞉ a꞉la꞉saga꞉fo꞉, “Ne Labando꞉wa mageso꞉ ha꞉na꞉ga꞉lo꞉ seno꞉, o꞉go꞉ a꞉ma꞉la꞉ yo꞉l. Niyo꞉ sibiyo꞉lo꞉ goudiyo꞉lo꞉, kaowo꞉lo꞉, donkiyo꞉lo꞉, a꞉la꞉ta꞉ga꞉ nanog kaluka꞉isaleyo꞉lo꞉ modo꞉ tililia꞉ yo꞉l ko꞉lo꞉, ni misa꞉ kalu giyo꞉ nemo꞉wo꞉ sagalo꞉ doma꞉ki, niyo꞉ to we gemo꞉ saga꞉to꞉l.”’ Gio꞉ a꞉la꞉sa꞉la꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","To a꞉no꞉ sama꞉kiyo꞉ iyo꞉ iliga꞉fo꞉ ko꞉lo꞉, iyo꞉ a꞉ma꞉la꞉ ya꞉ga꞉yo꞉, Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ gi gao Iso꞉lo꞉ ba꞉ba꞉ni ane ko꞉lo꞉, e gelo꞉ ba꞉ba꞉ni yaki a꞉la꞉ta꞉ga꞉ e o꞉lia꞉yo꞉ kaluwo꞉ 400 a꞉la꞉fo꞉ a꞉no꞉lo꞉ yab.” ");
INSERT INTO bco_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ya꞉kobo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉, e mada kele asulaki, tagio꞉ alan dowo꞉ ko꞉lo꞉, ene so꞉lo꞉wo꞉lo꞉, sibiyo꞉lo꞉, kaowo꞉lo꞉, ka꞉molo꞉lo꞉ tambo usa aloba꞉da꞉sa꞉ga꞉, hen a꞉la꞉ya ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Mo꞉wo꞉ eyo꞉ a꞉la꞉asulo꞉, “Iso꞉ e ya꞉ga꞉yo꞉, alobanalia꞉ difa꞉ so꞉lo꞉ no o꞉lia꞉ bubalega, nowo꞉ dalale hamana꞉ki” a꞉la꞉asula꞉sa꞉ga꞉ alobo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","A꞉la꞉ta꞉ga꞉ Ya꞉kob eyo꞉ a꞉la꞉dulugu sio꞉, “Yawe, ni ma꞉mu Ablaham o꞉lia꞉ ni do Aisa꞉g o꞉lia꞉ma꞉ Godeyo꞉ ge ko꞉lo꞉, tamin amio꞉ giyo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉, ‘O꞉go꞉ ge go꞉la꞉ hendeya ha꞉na꞉ga꞉, go꞉no꞉n so꞉lo꞉lo꞉ sab a꞉na a꞉ma꞉la꞉ ha꞉na꞉bi. A꞉la꞉gakiyo꞉ niyo꞉ ge nafale mesea꞉ki ta꞉fa꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Ne nafa kaluma, ko꞉sega giyo꞉ ha꞉fo꞉ disa꞉lan man o꞉lia꞉ man nafale a꞉no꞉lia꞉yo꞉ nemo꞉wo꞉ dimida꞉sen. Ne no꞉no꞉n heno꞉ ta꞉fo꞉ ha꞉naki, ho꞉n Yodan a꞉no꞉ ta꞉notakiyo꞉, i dom ko꞉ dia꞉sa꞉ga꞉ ane ko꞉sega, giyo꞉ ne asufa꞉ ko꞉lo꞉, o꞉go꞉ ne a꞉ma꞉la꞉ yakiyo꞉, kelego꞉wo꞉ modo꞉ ko꞉lo꞉ a꞉la꞉ aloba꞉da꞉sa꞉ga꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","12","Tamin amio꞉ giyo꞉ nemo꞉wo꞉ dinali sa꞉lakiyo꞉, ‘Niyo꞉ ge asuwa꞉taki, gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉lab i a꞉no꞉ ho꞉n amilo꞉ sa꞉ o꞉ngo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉, iyo꞉ mo꞉agelema꞉ib.’ Giyo꞉ a꞉la꞉dinali sio꞉ ko꞉lo꞉, o꞉go꞉ niyo꞉ gemo꞉wo꞉ a꞉na dulugu so꞉lo꞉l. Nao Iso꞉ e yakiyo꞉, nelo꞉, ga nilo꞉wo꞉lo꞉, so꞉wagalin o꞉lia꞉yo꞉ babuma꞉ni mia꞉nigab a꞉no꞉ ne tagilab ko꞉lo꞉, Yawe giyo꞉ ne asuwa꞉taki gasilia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ya꞉kob eyo꞉ Godemo꞉wo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, hen a꞉naka ali. Kea꞉fo dowabiki, ao Iso꞉mo꞉ boba dimia꞉no꞉ a꞉la꞉liki, no꞉ fofo꞉ elo꞉ tililia꞉ mio꞉ a꞉no꞉ alobo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","16","Boba a꞉no꞉ ko꞉lo꞉ dimidaliakiyo꞉, goudi malayo꞉ 200 a꞉la꞉fo꞉, goudi deyo꞉ do꞉la꞉fo꞉ a꞉la꞉, sibi malayo꞉ 200 a꞉la꞉fo꞉, sibi deyo꞉ do꞉la꞉fo꞉ a꞉la꞉, ka꞉mol mala bolo꞉ na꞉seno꞉ inso꞉ o꞉lia꞉yo꞉ 30 a꞉la꞉fo꞉, kao malayo꞉ 40 a꞉la꞉fo꞉, kao deyo꞉ do꞉la꞉fo꞉, donki malayo꞉ do꞉la꞉fo꞉ a꞉la꞉, a꞉la꞉ta꞉ga꞉ donki deyo꞉ do꞉la꞉fo꞉ a꞉no꞉ aloba꞉da꞉la꞉ga꞉, no꞉ ko꞉li ko꞉lilo꞉ a꞉no꞉ nanogdo꞉ dian kalu ko꞉li ko꞉lilo꞉ o꞉mo꞉ tili dofo꞉melea꞉ki, alobanalifa꞉. Ya꞉kob eyo꞉ nanogdo꞉ dian kalu imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ no꞉wo꞉ tamin doba꞉da꞉ tililia꞉ga꞉ ha꞉nakiyo꞉, no꞉ ko꞉li ko꞉lilo꞉ us a꞉namio꞉ fogo꞉ dia꞉ta꞉liki a꞉la꞉ga꞉i ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","18","Ya꞉kob eyo꞉ no꞉lo꞉ tamin amilo꞉ tililia꞉ga꞉lo꞉ ha꞉nab kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Iso꞉wo꞉ ge galiliakiyo꞉, eyo꞉ gemo꞉wo꞉ dabu ba꞉dalikiyo꞉, ‘Ge abe nanog kaluwo꞉? No꞉ fofo꞉ we abeno꞉wo꞉? A꞉la꞉ta꞉ga꞉ no꞉ we o꞉ba tililia꞉ ha꞉naya?’ a꞉la꞉bo꞉ gemo꞉wo꞉ dabu ba꞉dalikiyo꞉, giyo꞉ emo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘No꞉ fofo꞉ we tambo gi nanog dian kalu Ya꞉kob eno꞉ ko꞉lo꞉, gemo꞉ boba ge dima꞉ki iliga꞉fo꞉ ko꞉lo꞉, Ya꞉kob e ni fa꞉sa yab’ a꞉la꞉sa꞉la꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ya꞉kob eyo꞉ tamin amilo꞉ no꞉lo꞉ tililia꞉ ha꞉nab kalumo꞉wo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, kalu a꞉ma꞉ fa꞉s amilo꞉ ha꞉na꞉li, ha꞉na꞉li a꞉la꞉lab i o꞉mo꞉wo꞉lo꞉, “Iso꞉wo꞉ galiliakiyo꞉, to imilise weno꞉ko꞉ sa꞉la꞉i ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","A꞉la꞉ta꞉ga꞉ to a꞉la꞉do꞉ sa꞉ma꞉no꞉wo꞉ giliyo꞉ ga꞉lila꞉so꞉bo, ‘Gi nanog dian kalu, Ya꞉kob e ni fa꞉sa yab’ a꞉la꞉ salita꞉ga꞉ ha꞉na꞉bi,” a꞉la꞉sio꞉. Mo꞉wo꞉ Ya꞉kob eyo꞉ a꞉la꞉asulo꞉, “Boba kelego꞉ we e ko꞉le ba꞉dakiyo꞉, kulufa꞉yo꞉wo꞉ ga꞉lilaki sagalema꞉ib ko꞉lo꞉, na꞉no꞉ galiliakiyo꞉ sifo꞉fo꞉go꞉ kolalaki sagalema꞉iba꞉le?” Ya꞉kob eyo꞉ a꞉la꞉asulaki dimidalia꞉ga꞉ iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","A꞉la꞉dimidalia꞉ga꞉, boba kelego꞉ Iso꞉mo꞉lo꞉ dimia꞉no꞉ a꞉no꞉ tamina iliga꞉ta꞉ga꞉yo꞉, e o꞉g a꞉namio꞉ a꞉naka ali. ");
INSERT INTO bco_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","O꞉g nulu us a꞉namio꞉, Ya꞉kobo꞉ dasila꞉sa꞉ga꞉, inga a꞉la꞉yo꞉lo꞉, nanog ga a꞉la꞉ elo꞉ di a꞉no꞉lo꞉, kalu so꞉wa kelen a꞉la꞉fo꞉ a꞉no꞉lo꞉ tambo tililia꞉sa꞉ga꞉, ene kelego꞉ tambo a꞉no꞉lia꞉yo꞉ Yabog ho꞉n a꞉no꞉ ta꞉noma꞉ki iliga꞉takiyo꞉, Ya꞉kob e ina꞉li a꞉naka dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","25","Ya꞉kob e nulu a꞉namio꞉ ina꞉li dowabikiyo꞉, kalu nowo꞉ elo꞉wa fa꞉la꞉dowakiyo꞉, e ta꞉lia꞉sa꞉ga꞉ fafula꞉fo꞉liki ani tandea꞉leno꞉, ho꞉lema꞉no꞉wo꞉ ko꞉na꞉ma dowabiki, kalu a꞉ma꞉yo꞉ Ya꞉kobo꞉ mo꞉tininima꞉no꞉ dowabi, eyo꞉ Ya꞉koba꞉ kola꞉kiya golabiki, kola꞉kiyo꞉ a꞉na helefo dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Ho꞉le bidab ko꞉lo꞉, giyo꞉ ne fagega꞉foma.” Ko꞉sega Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Niyo꞉ ge o꞉semo꞉ fagega꞉fa꞉no꞉. Giyo꞉ ne nafale mesea꞉ki dinali sa꞉lalikiyo꞉, niyo꞉ ge a꞉na fagega꞉fa꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","A꞉la꞉sa꞉labiki kalu a꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge wiyo꞉ o꞉ba꞉le?” Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ne Ya꞉kob.” ");
INSERT INTO bco_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","A꞉la꞉sa꞉labiki kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Ge Gode o꞉lia꞉ kalu i o꞉lia꞉lo꞉ ani tandea꞉leno꞉ gi tinio꞉ ko꞉lo꞉, ge wiyo꞉ Ya꞉kob a꞉la꞉bo꞉ wa꞉kabiyo꞉ mo꞉sa꞉ma꞉ib. O꞉go꞉ gi wiyo꞉ Isolael wikili alito꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Kalu Alan, gi wiyo꞉ sa꞉ma꞉no꞉wo꞉ o꞉liyo꞉?” A꞉la꞉sa꞉labiki kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Wi nilo꞉wo꞉ waima꞉ni dabu ba꞉daya?” A꞉la꞉ta꞉ga꞉ kalu a꞉ma꞉yo꞉ Ya꞉kobo꞉ e nafale mesea꞉kiyo꞉, a꞉na dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","A꞉la꞉go꞉ko꞉lo꞉ Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Ne Godeyo꞉ migi kudu ba꞉ba꞉, ko꞉sega ne mo꞉sowo꞉.” A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ hen a꞉no꞉ Beniel wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ofo꞉ fa꞉la꞉dowabikiyo꞉, Ya꞉kob e Beniel hen a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nakiyo꞉, e kowo꞉ giliga꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","A꞉la꞉go꞉ko꞉lo꞉ Isolael kaluka꞉isale iliyo꞉, o꞉g nulu a꞉namilo꞉ kalu a꞉ma꞉lo꞉ Ya꞉koba꞉ kola꞉ki amilo꞉ moma kudu alifelo꞉ amilo꞉ golo꞉ a꞉no꞉ asulakiyo꞉, iliyo꞉ no꞉ kola꞉ki amilo꞉ moma kudu alifelo꞉ a꞉no꞉ mo꞉na꞉sen ko꞉lo꞉, o꞉go꞉lo꞉ iliyo꞉ man a꞉no꞉ ko꞉lo꞉ kudu ha꞉naki mo꞉na꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ya꞉kob e ha꞉na꞉sa꞉ga꞉, sigili ba꞉ba꞉ amio꞉, Iso꞉wo꞉ a꞉la꞉ta꞉ga꞉ kalu e o꞉lia꞉lo꞉ mio꞉ 400 a꞉la꞉fo꞉ i a꞉no꞉ e galima꞉ni yabi ba꞉ba꞉. Eyo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, so꞉wa enedo꞉wo꞉ aloba꞉dakiyo꞉, enen ano o꞉lia꞉ ta꞉fela꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","3","Nanog ka꞉isale a꞉la꞉ ko꞉lo꞉ ga di a꞉no꞉ a꞉la꞉ta꞉ga꞉ ene inso꞉ o꞉lia꞉ tamina ta꞉fo꞉. A꞉la꞉ta꞉ga꞉ a꞉ma꞉ fa꞉s amio꞉, Leayo꞉ a꞉la꞉ta꞉ga꞉ ene inso꞉wo꞉ a꞉na doma꞉ki ta꞉fo꞉. Tifdeyo꞉ Lesol o꞉lia꞉ inso꞉ Yosa꞉bo꞉ doma꞉ki ta꞉takiyo꞉, Ya꞉kobo꞉ ene so꞉lo꞉wo꞉ fa꞉sa ta꞉ta꞉ga꞉, enen tamita꞉ga꞉ galima꞉ni ane. E aolo꞉ doba꞉ finda꞉ga꞉ ha꞉nakiyo꞉, e Iso꞉wo꞉ wabudakiyo꞉, dom a꞉la꞉fo꞉ ko꞉lo꞉ gumisi alila꞉li fiane. ");
INSERT INTO bco_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Iso꞉wo꞉ ao Ya꞉kobo꞉ ba꞉da꞉ga꞉yo꞉, e galima꞉ni nai ya꞉sa꞉ga꞉ fafula꞉fo꞉liki, a꞉na mimilo꞉. A꞉la꞉yo꞉ sagalo꞉wo꞉ alan dowaki, a꞉na ya꞉fodo꞉. ");
INSERT INTO bco_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Iso꞉ eyo꞉ mimila꞉sa꞉ga꞉, osolo ba꞉ba꞉yo꞉, ka꞉isale o꞉lia꞉ so꞉wagalin o꞉lia꞉yo꞉ a꞉na ba꞉da꞉sa꞉ga꞉yo꞉, a꞉la꞉dabu ba꞉ba꞉, “Ka꞉isale o꞉lia꞉ so꞉wagalin o꞉lia꞉ ge o꞉lia꞉lo꞉ mio꞉ a꞉no꞉ o꞉ba?” Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Nao, gi nanog kaluwo꞉ ne ko꞉lo꞉, Gode eyo꞉ ne sagale alitaki, so꞉wagalin a꞉no꞉ nemo꞉ dimi ko꞉lo꞉ yab.” ");
INSERT INTO bco_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","A꞉la꞉sa꞉la꞉sa꞉ga꞉ nanog ka꞉isale a꞉la꞉ elo꞉ di a꞉no꞉ a꞉la꞉ta꞉ga꞉ a꞉la꞉ma꞉ so꞉wagalin a꞉no꞉lia꞉yo꞉ finda꞉ga꞉, Iso꞉lo꞉ elen a꞉na gumisi fufudo꞉. ");
INSERT INTO bco_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","A꞉ma꞉ fa꞉s amio꞉, Leayo꞉ o꞉lia꞉ ene so꞉wagalin a꞉no꞉lia꞉yo꞉ a꞉na finda꞉ga꞉, gumisi fufudo꞉. Tifde amio꞉, Lesol o꞉lia꞉ Yosa꞉b o꞉lia꞉yo꞉ a꞉na finda꞉ga꞉, gumisi fufudo꞉. ");
INSERT INTO bco_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Iliyo꞉ a꞉la꞉bo꞉ dimida꞉sa꞉ga꞉, Iso꞉ eyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ne yakilo꞉ no꞉ fofo꞉ modo꞉ ko꞉lo꞉ gido꞉ a꞉no꞉ waima꞉no꞉wo꞉?” A꞉la꞉dabu ba꞉dabiki, Ya꞉kob eyo꞉ a꞉ma꞉la꞉ a꞉la꞉sio꞉, “Ni misa꞉ kalu, ge sagalema꞉ki, boba kelego꞉ a꞉no꞉ gemo꞉ dimi.” ");
INSERT INTO bco_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ko꞉sega Iso꞉ eyo꞉ a꞉la꞉sio꞉, “Nao, niyo꞉ kelego꞉wo꞉ o꞉li da꞉lab ko꞉lo꞉ kelego꞉ gilo꞉ we go꞉no꞉n ka bo꞉fo꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “A, a꞉la꞉bo꞉ ga꞉so꞉bo. Ge ne ba꞉da꞉ga꞉yo꞉, sifo꞉fo꞉go꞉ nemo꞉wo꞉ mo꞉dia꞉taki, sagalo꞉wo꞉ alan dowaliki ba꞉ba꞉. Niyo꞉ ge wo꞉lokan ko꞉lo꞉ ba꞉ba꞉yo꞉, Godeya꞉ wo꞉lokan ba꞉dan o꞉ngo꞉ ko꞉lo꞉, ge nemo꞉wo꞉ sagalalega, giyo꞉ boba kelego꞉ we dia꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Niyo꞉ kelego꞉wo꞉ modo꞉ da꞉lab. Mo꞉wo꞉ Gode eyo꞉ ne mada alan asufa꞉ ko꞉lo꞉, kelego꞉ nilo꞉ gemo꞉lo꞉ dima꞉kilo꞉ alobaname a꞉no꞉, ge dima.” Ya꞉kob eyo꞉ aomo꞉wo꞉ dima꞉ki, ha꞉nolo sa꞉la꞉i ha꞉nabiki, Iso꞉ eyo꞉ kelego꞉wo꞉ a꞉no꞉ di. ");
INSERT INTO bco_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","A꞉la꞉ta꞉ga꞉ Iso꞉ eyo꞉ a꞉la꞉sio꞉, “Nio꞉ ha꞉na꞉niki. Nelo꞉ gi o꞉lia꞉ ua ha꞉na꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","14","Ko꞉sega Ya꞉kob eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ni misa꞉ kalu, ne so꞉wayo꞉ halaido꞉lo꞉ma dowab a꞉la꞉ta꞉ga꞉ ne no꞉ fofo꞉ inso꞉wo꞉ ho꞉gi segesela꞉ a꞉lab a꞉no꞉ ko꞉lo꞉ kele asulo꞉l. Ho꞉len imilise a꞉namio꞉ no꞉ fofo꞉ a꞉no꞉ bo꞉bo꞉ge hamana꞉ki o꞉salega, iyo꞉ tambo soma꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ ge tamika hamana. Niyo꞉ gi fa꞉sa, so꞉wagalin o꞉lia꞉ no꞉ fofo꞉ o꞉lia꞉ma꞉lo꞉ yab au ha꞉sa ya꞉la꞉ga꞉, ni misa꞉ kalu ge Seil hen a꞉na galima꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ya꞉kob eyo꞉ a꞉la꞉sa꞉labiki, Iso꞉ eyo꞉ a꞉la꞉sio꞉, “A꞉la꞉ma꞉no꞉lalega, niyo꞉ no꞉no꞉n nanog kalu nolo꞉ gio꞉ tililia꞉ mena꞉ki, iyo꞉ yata꞉fo꞉ ha꞉na꞉nigo꞉l.” A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Ni misa꞉ kalu, gilo꞉ to sa꞉lab a꞉no꞉ nafa ko꞉sega, no꞉no꞉n nanog kaluwa꞉yo꞉ o꞉lika tililia꞉ mia꞉ib ko꞉lo꞉, gio꞉ tambo ka ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","A꞉la꞉fo꞉ko꞉lo꞉ o꞉g a꞉naka Iso꞉wo꞉ a꞉ma꞉la꞉ Seil hena ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Ko꞉sega Ya꞉kob e hen nowa ha꞉na꞉ga꞉ fa꞉la꞉dowakiyo꞉, ene a o꞉lia꞉ no꞉ fofo꞉wa꞉ a ha꞉lu nol o꞉lia꞉yo꞉ a꞉na dialifela꞉sa꞉ga꞉, iyo꞉ a꞉na yasi ali ko꞉lo꞉, hen a꞉no꞉ Sukot wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Sukot hen a꞉no꞉ ta꞉ta꞉ga꞉, Ya꞉kobo꞉ Ka꞉ina꞉n hen a꞉na ga꞉li fa꞉la꞉dowakiyo꞉, Sekem amisa꞉n doba꞉da꞉ helebeso꞉g ayo꞉ a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ya꞉kob e alo꞉ di hen a꞉no꞉, Sekema꞉ iya꞉ Hamol e so꞉lo꞉wa꞉no꞉ ko꞉lo꞉, eyo꞉ silba mole 100 a꞉la꞉fo꞉ a꞉ma꞉ Hamol ene so꞉wa imo꞉ dimia꞉sa꞉ga꞉ kilili. ");
INSERT INTO bco_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ya꞉kob e heno꞉ a꞉na kililia꞉sa꞉ga꞉ silikiyo꞉, eyo꞉ Godeyo꞉ wabuluma꞉niki, uwo꞉ dibida꞉i fa꞉la꞉nda꞉sa꞉ga꞉ ta꞉fo꞉ ko꞉lo꞉ hen a꞉no꞉ El Elohe Isolael a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Ho꞉len no amio꞉ Ya꞉kob o꞉lia꞉ Lea o꞉lia꞉ma꞉ ida꞉, Daina e amisa꞉n a꞉namilo꞉ ta꞉sen ka꞉isale nolo꞉ ba꞉ba꞉ni ha꞉na꞉sa꞉ga꞉, ili amisa꞉na ane. ");
INSERT INTO bco_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","E a꞉na fa꞉la꞉dowo꞉ amio꞉, Hibi hendo꞉ biso꞉, Hamol ene inso꞉ Sekem e Dainayo꞉ ba꞉da꞉sa꞉ga꞉, ga a꞉no꞉ e diboda꞉sa꞉ga꞉, afale di. ");
INSERT INTO bco_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekem eyo꞉ Ya꞉koba꞉ ida꞉, Dainayo꞉ mada alan asula꞉sa꞉ga꞉, Daina eyo꞉ e ko꞉lo꞉ asuluma꞉ki a꞉la꞉ta꞉ga꞉ to nafaleyo꞉ emo꞉ ha꞉nolo sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ ene iya Hamolbo꞉wo꞉ ga a꞉no꞉ ne dia꞉no꞉ ko꞉lo꞉, ga a꞉ma꞉ ene iyamo꞉wo꞉ dabu ba꞉da꞉bika꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sekem elo꞉ Dainayo꞉ mogai alifa꞉ a꞉no꞉ Ya꞉kob e dabu ko꞉sega, ene inso꞉wo꞉ no꞉ fofo꞉ bo꞉fo꞉mela꞉niki ha꞉la꞉ doba꞉da꞉ ane ko꞉lo꞉, Ya꞉kob e ina꞉li ilikiyo꞉, towo꞉ mo꞉dinafa fanda sa꞉laki, inso꞉wo꞉ a꞉ma꞉la꞉ yaliki, a꞉na nenelema꞉no꞉ a꞉la꞉li yasisen. ");
INSERT INTO bco_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Sekem eyo꞉ ga a꞉no꞉ dia꞉no꞉ asulabiki, iya Hamol e Ya꞉kob o꞉lia꞉ nenelema꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","A꞉la꞉ta꞉ga꞉ Ya꞉koba꞉ insiso꞉i iliyo꞉ kelego꞉ fa꞉la꞉dowo꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, wigibo a꞉naka iyo꞉ a꞉ma꞉la꞉ mio꞉. Sekem eyo꞉ Ya꞉koba꞉ ida꞉yo꞉ dibodaki afa di amio꞉, Isolaela꞉ so꞉lo꞉wo꞉ mada sendelo alifa꞉ ko꞉lo꞉ iyo꞉ mada mo꞉bea꞉sa꞉ga꞉, kulufa꞉yo꞉wo꞉ alan dowo꞉. Mo꞉wo꞉ Isolael ili man amio꞉, a꞉la꞉bo꞉ mo꞉dimidan. ");
INSERT INTO bco_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Ko꞉sega Hamol eyo꞉ i o꞉lia꞉ nenelakiyo꞉ a꞉la꞉sio꞉, “Ne so꞉wa Sekem ene asulo꞉wo꞉ ga꞉la꞉ya dowo꞉ ko꞉lo꞉, ge ga꞉la꞉ ko ni so꞉wamo꞉ mena꞉ki asulab. ");
INSERT INTO bco_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","A꞉la꞉ta꞉ga꞉ tif amio꞉ sowaso꞉ gililo꞉wo꞉ nimo꞉ dimia꞉liki, a꞉la꞉ta꞉ga꞉ sowaso꞉ nililo꞉wo꞉ giliyo꞉ dia꞉liki, a꞉la꞉mela꞉no꞉ asulab. ");
INSERT INTO bco_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","A꞉la꞉dimida꞉likiyo꞉, gio꞉ negele dowaki, hen gilo꞉ mesa꞉no꞉ asulab a꞉naka mesa꞉ib. Gio꞉ hen wenamio꞉ kelego꞉wo꞉ o꞉lika kililia꞉liki mesa꞉ib. A꞉la꞉ta꞉ga꞉ hen go꞉no꞉do꞉wo꞉lo꞉ o꞉li kililia꞉ib.” Hamol eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","A꞉la꞉sa꞉labikiyo꞉, Sekem eyo꞉ Dainaya꞉ iya o꞉lia꞉ ao o꞉lia꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ nilo꞉ dabu bo꞉do꞉l we o꞉lika꞉ a꞉lalega, ga fudo꞉ gilo꞉ sa꞉lab aumbo꞉ niyo꞉ dimia꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ga we ne dia꞉no꞉ asulo꞉ ko꞉lo꞉, giliyo꞉ ga we nemo꞉ dimina꞉ki asulo꞉l. A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ ga fudo꞉ o꞉bibesa꞉le a꞉la꞉ta꞉ga꞉ bo꞉ba kelego꞉ nolo꞉lo꞉ agelalega, niyo꞉ gililo꞉ asulab aumbo꞉ tambo dimia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","14","Ko꞉sega Ya꞉koba꞉ inso꞉wo꞉ Sekem elo꞉ adomo꞉lo꞉ dimido꞉ a꞉no꞉ iyo꞉ asula꞉sa꞉ga꞉, iliyo꞉ Sekem o꞉lia꞉ iya Hamol o꞉lia꞉yo꞉ dikilima꞉no꞉ asulakiyo꞉, towo꞉ a꞉la꞉sio꞉, “Gilo꞉ tolo꞉ sa꞉lab a꞉no꞉ mo꞉dimidama꞉no꞉. Mo꞉wo꞉ nili nadowo꞉ kalu do꞉go꞉fo꞉ mo꞉hege gedeo꞉ o꞉mo꞉wo꞉ mo꞉dima a꞉la꞉ma꞉no꞉. Niliyo꞉ a꞉la꞉dimidalega, nio꞉ sendeloma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","16","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ nanog imilise nowo꞉ dimidalega, niliyo꞉ ga a꞉no꞉ gemo꞉wo꞉ a꞉na mea꞉no꞉. Gio꞉ tamin amio꞉ kaluleyo꞉ ni o꞉ngo꞉ dowaki, kalu gi amio꞉ tambo do꞉go꞉fo꞉ hege gedealega, sowaso꞉ nililo꞉wo꞉ gimo꞉wo꞉ a꞉na meaki, a꞉la꞉ta꞉ga꞉ sowaso꞉ gilido꞉wo꞉lo꞉ a꞉na dia꞉lilema꞉no꞉. A꞉la꞉dimida꞉likiyo꞉, nio꞉ ua siliki, ege mesa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ko꞉sega to nililo꞉ so꞉lo꞉l we mo꞉kudu ha꞉naki, do꞉go꞉fo꞉ mo꞉hege gedealega, niliyo꞉ Dainayo꞉ a꞉ma꞉la꞉ tililia꞉ ha꞉na꞉no꞉.” Ya꞉koba꞉ inso꞉wa꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","19","Sekem o꞉lia꞉ Hamol o꞉lia꞉ma꞉yo꞉ to ilido꞉ sa꞉lab a꞉no꞉ o꞉li a꞉la꞉asula꞉sa꞉ga꞉, Sekem e ga a꞉no꞉ dia꞉no꞉ a꞉la꞉asulaki, to ililo꞉ sa꞉lab a꞉no꞉ mo꞉ta꞉fa꞉no꞉ a꞉la꞉ta꞉ga꞉ nanogo꞉ bo꞉bo꞉ge dimidama꞉ni ane. Hamola꞉ ene so꞉lo꞉ us a꞉namio꞉ Sekem e wabulun kalu iliki, nolo꞉ e tinio꞉ ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","21","A꞉la꞉go꞉ko꞉lo꞉ Hamol o꞉lia꞉ Sekem o꞉lia꞉yo꞉ ene amisa꞉n amilo꞉ kegea꞉sen hen a꞉na ha꞉na꞉sa꞉ga꞉, amisa꞉n kalumo꞉wo꞉ a꞉la꞉sio꞉, “Kalu i a꞉no꞉ nili mili nafalo꞉biki, iyo꞉ ni o꞉lia꞉ mesa꞉no꞉ asulab. Nili hen we alan ko꞉lo꞉, iyo꞉ ni o꞉lia꞉ siliki, kelego꞉wo꞉ o꞉lika kililia꞉liki mesea꞉ki ta꞉fa꞉no꞉. A꞉la꞉ta꞉ga꞉ sowaso꞉ ililo꞉wo꞉ nili diaki, sowaso꞉ nililo꞉wo꞉ imo꞉wo꞉ dimia꞉li a꞉la꞉li mesa꞉niki. ");
INSERT INTO bco_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Iyo꞉ negele ua siliki, ege mesa꞉no꞉ asulab ko꞉sega, tamin amio꞉ nio꞉ nanogo꞉ imilig nowo꞉ dimidama꞉no꞉. Ni usamio꞉ kaluwo꞉ tambo do꞉go꞉fo꞉ hege gegeda꞉sa꞉ga꞉ i o꞉ngo꞉ dowalikiyo꞉, iyo꞉ ni o꞉lia꞉yo꞉ o꞉li mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Niliyo꞉ a꞉la꞉dimidalega, kelego꞉ nafa ililo꞉wo꞉ a꞉la꞉ta꞉ga꞉ no꞉ fofo꞉ ililo꞉wo꞉lo꞉ tambo nili dia꞉no꞉ ko꞉lo꞉, iyo꞉ ni o꞉lia꞉yo꞉ mesa꞉ mena꞉kiyo꞉, ililo꞉ to sa꞉lab a꞉no꞉ niliyo꞉ kudu ha꞉na꞉niki.” ");
INSERT INTO bco_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Hamol o꞉lia꞉ Sekem o꞉lia꞉ma꞉lo꞉ to sa꞉lab a꞉no꞉ amisa꞉n kaluwo꞉ tambo da꞉da꞉la꞉ga꞉yo꞉, iliyo꞉ o꞉li sa꞉labo꞉lo꞉b asula꞉sa꞉ga꞉, iyo꞉ tambo do꞉go꞉fo꞉ hege gegedo꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Gedea꞉sa꞉ga꞉ ho꞉len asol fa꞉la꞉dowabiki, kalu do꞉go꞉fdo꞉ gedeo꞉ a꞉no꞉ nagalo꞉ o꞉delena, Dainaya꞉ ao a꞉la꞉, Ya꞉koba꞉ inso꞉ Simeon o꞉lia꞉ Libai o꞉lia꞉yo꞉ helebeyo꞉ dia꞉sa꞉ga꞉, amisa꞉na ane. Amisa꞉n kaluwa꞉yo꞉ a꞉la꞉ma꞉yo꞉ a꞉la꞉dimidama꞉nigab a꞉la꞉bo꞉ mo꞉asulo꞉ elen ko꞉lo꞉, a꞉la꞉ma꞉yo꞉ kaluwo꞉ tambo yasala꞉. ");
INSERT INTO bco_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","A꞉la꞉ma꞉yo꞉ Hamol o꞉lia꞉ ene inso꞉ Sekem o꞉lia꞉yo꞉ helebeya꞉ sana sowa꞉sa꞉ga꞉, Dainayo꞉ Sekema꞉ ayamilo꞉ seno꞉ a꞉ma꞉la꞉ tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ya꞉koba꞉ inso꞉ nolo꞉ ha꞉na꞉sa꞉ga꞉yo꞉, amisa꞉n kalu sowo꞉lo꞉ da꞉lab a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, amisa꞉n kaluwa꞉lo꞉ Daina mogai alifa꞉ a꞉no꞉ ko꞉lo꞉ wa꞉deakiyo꞉, kelego꞉ amisa꞉n amilo꞉ nafale delen a꞉no꞉ ili dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Iliyo꞉ sibi o꞉lia꞉ donki o꞉lia꞉ no꞉ fofo꞉ nolo꞉lo꞉ tililia꞉b, a꞉la꞉ta꞉ga꞉ amisa꞉n us amilo꞉ delen kelego꞉ a꞉no꞉lo꞉, egelo꞉ kelego꞉wo꞉lo꞉ tambo dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Amisa꞉n a꞉namilo꞉ kelego꞉ nafaleyo꞉ tambo dia꞉b, ayamilo꞉ kelego꞉ delen a꞉no꞉lo꞉ tambo dia꞉b a꞉la꞉ta꞉ga꞉ ka꞉isale o꞉lia꞉ so꞉wagalin o꞉lia꞉yo꞉ ili tambo tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Tif amio꞉ Ya꞉kob eyo꞉ Simeon o꞉lia꞉ Libai o꞉lia꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Gaindo꞉ dimido꞉ wema꞉yo꞉ nemo꞉wo꞉ hida꞉yo꞉ dimiab. Ka꞉ina꞉n hendo꞉ biso꞉ kalu o꞉lia꞉ Beles kalu o꞉lia꞉ma꞉yo꞉ ne mogago꞉ kalu a꞉la꞉asulakiyo꞉, iyo꞉ ua gasaya꞉sa꞉ga꞉, ni o꞉lia꞉ bubalikiyo꞉, nio꞉ kaluwo꞉ modo꞉ma ko꞉lo꞉ ne o꞉lia꞉ so꞉lo꞉ nilo꞉ o꞉lia꞉yo꞉ tambo yasala꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Ko꞉sega Ya꞉kob elo꞉ sa꞉lab a꞉no꞉ a꞉la꞉ma꞉yo꞉ da꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Giyo꞉ waga asulaya? Sekem eyo꞉ nado nililo꞉ we uwo꞉ dian gayo꞉ o꞉ngo꞉ ba꞉da꞉sa꞉ga꞉ afa di. A꞉no꞉ o꞉liyo꞉?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Gode eyo꞉ Ya꞉kobo꞉wo꞉ a꞉la꞉sio꞉, “Ge dasila꞉sa꞉ga꞉, a꞉ma꞉la꞉ Betel hen a꞉na mesa꞉ni ha꞉na꞉bi. Tamin amio꞉ ge Iso꞉ tagila꞉sa꞉ga꞉ nai ane amio꞉ Gode e Betel hen a꞉namio꞉ gelo꞉wa fa꞉la꞉dowo꞉. O꞉go꞉ ge a꞉ma꞉la꞉ a꞉na ha꞉na꞉sa꞉ga꞉yo꞉, boba so꞉mea꞉no꞉wo꞉ giyo꞉ uwo꞉ dibida꞉sa꞉ga꞉ imili alita꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ ene eso꞉lo꞉wo꞉ a꞉la꞉ta꞉ga꞉ kaluka꞉isale nol e o꞉lia꞉lo꞉ sen o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Madali gode gililo꞉ dia꞉fo꞉lab ko tambo dia꞉sa꞉ga꞉ sandifoma. A꞉la꞉ta꞉ga꞉ Godeya꞉ siwa꞉l amio꞉ malilo꞉ dowab a꞉la꞉widakiyo꞉, ginin a꞉ma꞉la꞉yo꞉ to꞉go꞉da꞉sa꞉ga꞉ helebeso꞉g nafayo꞉ kagedelema. ");
INSERT INTO bco_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Gio꞉ a꞉la꞉dimida꞉sa꞉ga꞉yo꞉, nio꞉ hen we ta꞉ta꞉sa꞉ga꞉, Betel a꞉na ha꞉na꞉no꞉. Betel hen a꞉namio꞉, niyo꞉ uwo꞉ dibida꞉i fa꞉la꞉nda꞉ga꞉ imili alitakiyo꞉, Godemo꞉wo꞉ a꞉na dulugu sa꞉ma꞉no꞉. Mo꞉wo꞉ nelo꞉ hida꞉yo꞉lo꞉ ba꞉ba꞉ amio꞉, Gode eyo꞉ ne asufa꞉, a꞉la꞉ta꞉ga꞉ nelo꞉ sia꞉len amio꞉ e ne o꞉lia꞉ elen.” Ya꞉kob eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","A꞉la꞉fo꞉ko꞉lo꞉ madali godeyo꞉ ililo꞉ ta꞉lisen a꞉no꞉lia꞉ ili ka꞉la꞉n amilo꞉ kali dehesedo꞉ a꞉no꞉lia꞉yo꞉ tambo Ya꞉kob emo꞉ dimiabiki, Ya꞉kob eyo꞉ kelego꞉ a꞉no꞉ tambo Sekem amisa꞉n ha꞉la꞉ amilo꞉ ba꞉mo꞉ a꞉na dali alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ya꞉koba꞉ eso꞉lo꞉wo꞉ tambo hen a꞉no꞉ ta꞉ta꞉ga꞉, ha꞉na꞉ga꞉ ha꞉nab amio꞉ Gode eyo꞉ amisa꞉n ilo꞉ ha꞉nab amilo꞉ ko꞉na꞉malo꞉ kandaya꞉i ane a꞉no꞉ tambo tagi alitabiki, iyo꞉ Ya꞉koba꞉ so꞉lo꞉mo꞉wo꞉ mo꞉mogaima꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Iyo꞉ ha꞉na꞉sa꞉ga꞉yo꞉, Ya꞉kob o꞉lia꞉ kaluka꞉isale e o꞉lia꞉lo꞉ sen a꞉no꞉ tambo Lus amisa꞉n, Ka꞉ina꞉n hen a꞉na fa꞉la꞉dowo꞉. Lus amisa꞉n a꞉no꞉ o꞉go꞉ Betel a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ya꞉kobo꞉ a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, Godemo꞉wo꞉ boba so꞉mea꞉nikiyo꞉ uwo꞉ dibida꞉sa꞉ga꞉ imili alifa꞉. Eyo꞉ hen a꞉no꞉ El Betel wikilo꞉, mo꞉wo꞉ Ya꞉kob e Iso꞉ tagila꞉sa꞉ga꞉ nai ane amio꞉, Gode eneno꞉ emo꞉wo꞉ a꞉na kalaba wido꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Iyo꞉ a꞉na sen amio꞉, Debola, La꞉ba꞉ga elo꞉ ha꞉lu amilo꞉ fofo꞉ ka꞉isale a꞉no꞉ sowabiki, Betel hen a꞉namio꞉ ba꞉mo꞉wa dali alifa꞉. A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ ba꞉ a꞉no꞉ Alon Bakut a꞉la꞉wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","10","Ya꞉kob e Mesobotemia hen a꞉na a꞉la꞉ta꞉ga꞉ a꞉ma꞉la꞉ fa꞉la꞉dowabikiyo꞉, Godeyo꞉ elo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉, e nafale mesea꞉ki towo꞉ a꞉la꞉sio꞉, “Gi wiyo꞉ Ya꞉kob ko꞉sega Ge Ya꞉kob a꞉la꞉bo꞉ wa꞉kabiyo꞉ mo꞉sa꞉ma꞉ib. O꞉go꞉ ge Isolael wikilo꞉l.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ Gode eyo꞉ Ya꞉kobo꞉ Isolael a꞉la꞉wikili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ to nolo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ne Gode Halaido꞉lo꞉ A꞉labo꞉ Ne. Gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉nab a꞉no꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉, Geya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉wo꞉ alan fa꞉la꞉doma꞉ib a꞉la꞉ta꞉ga꞉ so꞉lo꞉wo꞉ modo꞉ fa꞉la꞉doma꞉ib. Geya a꞉la꞉ta꞉ga꞉yo꞉ misa꞉ kalu nolo꞉ fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Hen nilo꞉ tamin amilo꞉ Ablaham o꞉lia꞉ Aisa꞉g o꞉lia꞉mo꞉lo꞉ dimi we, gemo꞉wo꞉lo꞉ a꞉no꞉ko꞉ dimio꞉l ko꞉lo꞉, so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉nab o꞉mo꞉wo꞉lo꞉ hen weno꞉ko꞉ dimia꞉mela꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Godeyo꞉ Ya꞉kob o꞉lia꞉lo꞉ tolo꞉ nenela꞉len hen a꞉no꞉ ta꞉ta꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Ya꞉kob elo꞉ Gode o꞉lia꞉lo꞉ tola꞉len hen a꞉namio꞉, eyo꞉ u sambowo꞉ da꞉ga꞉lia꞉sa꞉ga꞉ hen a꞉na gele alifa꞉. Godemo꞉lo꞉ bo꞉ba dimian aumbo꞉, eyo꞉ wain ho꞉n o꞉lia꞉ wa ho꞉n o꞉lia꞉yo꞉ u wa꞉la tulu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","A꞉la꞉fo꞉ko꞉lo꞉ Godeya꞉lo꞉ Ya꞉kob o꞉lia꞉lo꞉ tola꞉len hen a꞉no꞉, Ya꞉kob eyo꞉ Betel wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ya꞉kob o꞉lia꞉ ene so꞉lo꞉ o꞉lia꞉yo꞉ Betel amisa꞉n a꞉no꞉ ta꞉ta꞉ga꞉, A꞉fla꞉ta hen a꞉namio꞉ o꞉fa꞉la꞉doma꞉no꞉ ha꞉na꞉ga꞉ ha꞉nakiyo꞉, Lesol e so꞉wayo꞉ sa꞉la꞉lia꞉no꞉ dowabiki, do꞉mo꞉ elo꞉wo꞉ nagalo꞉wo꞉ halaido꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","E nagalo꞉wo꞉ mada alan fa꞉la꞉dowabikiyo꞉, ka꞉isale elo꞉ bale ane a꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge tagila꞉so꞉bo! Ge kalu so꞉wa nowo꞉ sa꞉la꞉lia꞉nigab.” ");
INSERT INTO bco_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Lesol e so꞉wayo꞉ sa꞉la꞉lia꞉sa꞉ga꞉ soma꞉nikiyo꞉, eyo꞉ so꞉wa a꞉no꞉ wiyo꞉ Benoni wikilo꞉. Ko꞉sega iya Ya꞉kob eyo꞉ Ba꞉nsamen wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","A꞉la꞉go꞉ko꞉lo꞉ Lesol e sowabiki, A꞉fla꞉ta ha꞉na꞉sen tog anib a꞉na dali alifa꞉. A꞉fla꞉ta amisa꞉n a꞉no꞉ o꞉go꞉ Ba꞉diliha꞉m a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Dali alita꞉sa꞉ga꞉, Ya꞉kob eyo꞉ Lesol daido꞉ a꞉no꞉ asula꞉ mela꞉niki, u sambo nowo꞉ da꞉ga꞉lia꞉sa꞉ga꞉ a꞉na gele alifa꞉. A꞉la꞉ta꞉ga꞉ u a꞉no꞉ o꞉g wiyo꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Isolael eyo꞉ hen a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉na꞉la꞉ga꞉yo꞉, Migdal Edel a꞉na ta꞉ta꞉ga꞉yo꞉, helebeso꞉g ayo꞉ a꞉na di. ");
INSERT INTO bco_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Isolael e hen a꞉na silikiyo꞉, Isolaela꞉lo꞉ nanog ga Bilha ko꞉lo꞉ di a꞉no꞉ Luben eyo꞉ a꞉na afa di ko꞉lo꞉ Isolael e dabu. Ya꞉kob eyo꞉ kalu so꞉wayo꞉ kugula꞉fo꞉ ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea elo꞉ so꞉wa sa꞉la꞉liyo꞉ we. Ya꞉koba꞉ so꞉wa wa꞉la꞉bo꞉ Lubeno꞉, a꞉ma꞉ fa꞉so꞉ Simeon, a꞉ma꞉ fa꞉so꞉ Libai, a꞉ma꞉ fa꞉so꞉ Yuda, a꞉ma꞉ fa꞉so꞉ Isaka, tifo꞉ Sebulun. ");
INSERT INTO bco_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","A꞉la꞉ta꞉ga꞉ Lesol elo꞉ so꞉wa sa꞉la꞉liyo꞉ we, Yosa꞉b o꞉lia꞉ Ba꞉nsamen. ");
INSERT INTO bco_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","A꞉la꞉ta꞉ga꞉ Lesola꞉ nanog ga Bilha ko꞉lo꞉ di a꞉ma꞉lo꞉ sa꞉la꞉liyo꞉ we, Dan o꞉lia꞉ Nabtali. ");
INSERT INTO bco_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","A꞉la꞉ta꞉ga꞉ Leaya꞉ nanog ga Silba ko꞉lo꞉ di a꞉ma꞉lo꞉ sa꞉la꞉liyo꞉ we, Gad o꞉lia꞉ Asel. Ya꞉kob e Mesobotemia hen a꞉na silikiyo꞉, kalu so꞉wa kugula꞉fo꞉ we a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob e Heblon hen a꞉na ha꞉na꞉sa꞉ga꞉, ene iya Aisa꞉gdo꞉wa fa꞉la꞉dowo꞉. Hen a꞉no꞉ wi nowo꞉ Mamele, a꞉la꞉ta꞉ga꞉ wi nowo꞉ Kiliat Alba. Ablaham o꞉lia꞉ Aisa꞉g o꞉lia꞉yo꞉ tamin amio꞉ hen a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Ya꞉kobo꞉ a꞉na silikiyo꞉, Aisa꞉g e donayo꞉ 180 a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, elo꞉ ta꞉i mio꞉wo꞉ nafale ko꞉lo꞉, soma꞉no꞉ au sowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ e iasi dane ane sab o꞉lia꞉ galima꞉ni ane. A꞉la꞉ta꞉ga꞉ ene so꞉wa a꞉la꞉, Iso꞉ o꞉lia꞉ Ya꞉kob o꞉lia꞉ma꞉yo꞉ e a꞉na dali alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso꞉wa꞉ ene wiyo꞉ nowo꞉ Idom ko꞉lo꞉, ene eso꞉lo꞉ ta꞉i ane malolo꞉wo꞉ we. ");
INSERT INTO bco_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso꞉ eyo꞉ Ka꞉ina꞉n gayo꞉ a꞉la꞉ ko꞉lo꞉ di. Nowo꞉ Ada, e Hit kalu Elona꞉ ida꞉ ko꞉lo꞉ di. Nowo꞉ Oholibama ko꞉lo꞉ di. Oholibamaya꞉ ene iyayo꞉ Ana, a꞉la꞉ta꞉ga꞉ Anaya꞉ ene iyayo꞉ Hifi kalu, Sibeon. ");
INSERT INTO bco_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","A꞉la꞉ta꞉ga꞉ ga elo꞉ di nowo꞉ Basemat, Ismaela꞉ ida꞉, Nebayoda꞉ ado. Ga otalen a꞉no꞉ Iso꞉wa꞉ di. ");
INSERT INTO bco_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada eyo꞉ Elifas ko꞉lo꞉ sa꞉la꞉li, a꞉la꞉ta꞉ga꞉ Basemat eyo꞉ Luel ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholibama eyo꞉ Yeus, Yalam, o꞉lia꞉ Kola sa꞉la꞉li. Iso꞉ e Ka꞉ina꞉n hen a꞉na siliki, kalu so꞉wa we a꞉na sa꞉la꞉la꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","7","Iso꞉wa꞉ no꞉ fofo꞉ o꞉lia꞉ Ya꞉koba꞉ no꞉ fofo꞉ o꞉lia꞉yo꞉ imili ka mesa꞉no꞉wo꞉ heno꞉ mo꞉ililabiki, a꞉la꞉yo꞉ a꞉na aloba꞉da꞉sa꞉ga꞉, Iso꞉ e hen nowa mesa꞉ni ane. Iso꞉ e inga o꞉lia꞉, inso꞉ o꞉lia꞉, ida꞉la꞉la꞉ o꞉lia꞉, egeledo꞉ sen kaluka꞉isale tambo a꞉la꞉ta꞉ga꞉, kao o꞉lia꞉ no꞉ fofo꞉wo꞉ tambo a꞉la꞉ta꞉ga꞉, kelego꞉ tambo elo꞉ Ka꞉ina꞉n hen a꞉namilo꞉ di a꞉no꞉lia꞉yo꞉ dimidalia꞉sa꞉ga꞉yo꞉, Ya꞉kobo꞉ ta꞉ta꞉sa꞉ga꞉, e heno꞉ ko꞉na꞉ mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","A꞉la꞉fo꞉ko꞉lo꞉ Iso꞉ e Ya꞉kobo꞉ ta꞉ta꞉sa꞉ga꞉, Seil hen misio꞉ doba꞉da꞉ mesa꞉ni ane. Iso꞉ ene wi nowo꞉ Idom a꞉la꞉sa꞉lan. ");
INSERT INTO bco_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso꞉ ene eso꞉lo꞉ ta꞉i ane malolo꞉wo꞉ we. Iso꞉ e Seil hena siliki, Idom kaluka꞉isaleyo꞉ a꞉na mo꞉mo꞉da fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso꞉wa꞉ insiso꞉iya꞉ wiyo꞉ we. Elifas, Iso꞉wa꞉ inga Adaya꞉ inso꞉ a꞉la꞉ta꞉ga꞉ Luel, Iso꞉wa꞉ inga Basemata꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifasa꞉ inso꞉wo꞉ Teman, Omal, Sefo, Gatam, a꞉la꞉ta꞉ga꞉ Kenas. ");
INSERT INTO bco_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Iso꞉wa꞉ inso꞉ Elifas eyo꞉ ene nanog dian ga, Timna di ko꞉lo꞉, Timna eyo꞉ kalu so꞉wa, Amaleg sa꞉la꞉li. A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa i a꞉no꞉ Iso꞉wa꞉ inga, Ada eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","A꞉la꞉ta꞉ga꞉ Luela꞉ inso꞉wo꞉ we. Nahat, Sa꞉la, Sama, a꞉la꞉ta꞉ga꞉ Misa. So꞉wa i wema꞉ inuwo꞉ Iso꞉wa꞉ inga, Basemat. ");
INSERT INTO bco_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Iso꞉wa꞉ inga Oholibamaya꞉ iyayo꞉ Ana a꞉la꞉ta꞉ga꞉ Anaya꞉ iyayo꞉ Sibeon. Oholibamaya꞉ inso꞉wo꞉ we. Yeus, Yalam o꞉lia꞉ Kola. ");
INSERT INTO bco_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","So꞉lo꞉ ko꞉li ko꞉lilo꞉ Iso꞉wa꞉ inso꞉wa fa꞉la꞉dowo꞉ a꞉ma꞉ wiyo꞉ we. Iso꞉wa꞉ inga Adaya꞉ ene so꞉wa wa꞉la꞉bo꞉ Elifas, a꞉na a꞉la꞉ta꞉ga꞉yo꞉ Teman kaluka꞉isaleyo꞉, Omal kaluka꞉isaleyo꞉, Sefo kaluka꞉isaleyo꞉, Kenas kaluka꞉isaleyo꞉, Kola kaluka꞉isaleyo꞉, Gatam kaluka꞉isaleyo꞉, a꞉la꞉ta꞉ga꞉ Amaleg kaluka꞉isaleyo꞉. Kaluka꞉isale i a꞉no꞉ Idom hen a꞉na sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","A꞉la꞉ta꞉ga꞉ Iso꞉wa꞉ inga Basemat ene so꞉wa Luel a꞉na a꞉la꞉ta꞉ga꞉yo꞉, so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ a꞉ma꞉ wiyo꞉ we. Nahat kaluka꞉isaleyo꞉, Sa꞉la kaluka꞉isaleyo꞉, Sama kaluka꞉isaleyo꞉, a꞉la꞉ta꞉ga꞉ Misa kaluka꞉isaleyo꞉. Kaluka꞉isale i a꞉no꞉lo꞉ Idom hen a꞉na sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso꞉wa꞉ inga Oholibama a꞉no꞉ Anaya꞉ ene ida꞉ ko꞉lo꞉, ga eya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ a꞉ma꞉ wiyo꞉ we. Yeus kaluka꞉isaleyo꞉, Yalam kaluka꞉isaleyo꞉, a꞉la꞉ta꞉ga꞉ Kola kaluka꞉isaleyo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Kaluka꞉isale so꞉lo꞉ ko꞉li ko꞉lilo꞉ kandayo꞉ a꞉ma꞉ ema꞉muwo꞉ Iso꞉. A꞉la꞉ta꞉ga꞉ Iso꞉wa꞉ ene wi nowo꞉ Idom. ");
INSERT INTO bco_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Iso꞉ e Idom hen a꞉namilo꞉ fa꞉la꞉dowab ho꞉len a꞉namio꞉, Hol kalu nowo꞉ Seil e a꞉na sa꞉sen. Seila꞉ ene inso꞉wo꞉ hendo꞉ biso꞉ ko꞉lo꞉ ili wiyo꞉ we. Lotan, Sobal, Sibeon, Ana, Dison, Esel o꞉lia꞉ Disan. Kalu i a꞉na a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉ iyo꞉ Idom hen a꞉na silikiyo꞉, ini so꞉lo꞉wo꞉ us a꞉namio꞉ misa꞉ kalu ina꞉li ina꞉lile fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotana꞉ inso꞉wo꞉ Holi o꞉lia꞉ Heman. Lotana꞉ ene adowo꞉ Timna. ");
INSERT INTO bco_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobal inso꞉wo꞉ Alban, Manahat, Ebal, Sefo, o꞉lia꞉ Onam. ");
INSERT INTO bco_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sibeona꞉ inso꞉wo꞉ Aia o꞉lia꞉ Ana. Anayo꞉ kalulo꞉ma hena iyaya꞉ donki bo꞉fo꞉liki, ho꞉n si ofo꞉ a꞉no꞉ e ko꞉le ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anaya꞉ inso꞉wo꞉ wiyo꞉ we Dison, a꞉la꞉ta꞉ga꞉ ida꞉yo꞉ Oholibama. ");
INSERT INTO bco_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disona꞉ insiso꞉ima꞉ wiyo꞉ we, Hemdan, Esban, Itlan, o꞉lia꞉ Kelan. ");
INSERT INTO bco_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Esela꞉ insiso꞉ima꞉ wiyo꞉ we, Bilhan, Safan, o꞉lia꞉ Akan. ");
INSERT INTO bco_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disana꞉ inso꞉ a꞉la꞉yo꞉ we, nowo꞉ Us, nowo꞉ Alan. ");
INSERT INTO bco_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","A꞉la꞉fo꞉ko꞉lo꞉ Seil hen amilo꞉, Hol kaluka꞉isale iya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ a꞉ma꞉ wiyo꞉ we, Lotan, Sobal, Sibeon, Ana, Dison, Esel, o꞉lia꞉ Disan. ");
INSERT INTO bco_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Isolael kaluka꞉isale a꞉no꞉ misa꞉ kalu alan noma꞉lo꞉ mo꞉bo꞉fo꞉len ho꞉len amio꞉, Idom hen amilo꞉ misa꞉ kalu alan fa꞉la꞉dowo꞉wo꞉ we. ");
INSERT INTO bco_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, Beola꞉ inso꞉ a꞉no꞉ Idom kaluka꞉isaleya꞉ misa꞉ kaluwo꞉ e dowo꞉. Ene amisa꞉n wiyo꞉ Dihaba. ");
INSERT INTO bco_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bela e sowabikiyo꞉, Bosla amisa꞉n kalu Selaya꞉ inso꞉ Yobab e misa꞉ kalu ko꞉lo꞉ a꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobab e sowabikiyo꞉, Teman kalu Husam e misa꞉ kalu a꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Husam e sowabikiyo꞉, Bedada꞉ inso꞉ Hadad e misa꞉ kalu a꞉dowo꞉ ko꞉lo꞉, ene amisa꞉n wiyo꞉ Afit. Bedad e Moab hen a꞉namilo꞉ Midian kalu o꞉lia꞉lo꞉ bubo꞉ amio꞉, e tinio꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadad e sowabikiyo꞉, Maseleka kalu Samla e misa꞉ kalu a꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samla e sowabikiyo꞉, So꞉l e misa꞉ kalu dowo꞉. So꞉l e Lehobod amisa꞉n, Yufuletis ho꞉n doba꞉da꞉ sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","So꞉l e sowabikiyo꞉, Agbola꞉ inso꞉, Bal Hanan e misa꞉ kalu dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Agbola꞉ inso꞉ Bal Hanan e sowabikiyo꞉, Hadal e misa꞉ kalu dowo꞉. Hadal ene amisa꞉n wiyo꞉ Bau a꞉la꞉ta꞉ga꞉ ene ingaya꞉ wiyo꞉ Mehetabel. Mehetabela꞉ anowo꞉ Mateled a꞉la꞉ta꞉ga꞉ ene inuwo꞉ Mesahab. ");
INSERT INTO bco_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","A꞉la꞉fo꞉ko꞉lo꞉ Iso꞉ eya a꞉la꞉ta꞉ga꞉yo꞉, so꞉lo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowo꞉ a꞉ma꞉ wiyo꞉ we. Timna kaluka꞉isale, Alba kaluka꞉isale, Yehed kaluka꞉isale, Oholibama kaluka꞉isale, Ela kaluka꞉isale, Binon kaluka꞉isale, Kenas kaluka꞉isale, Teman kaluka꞉isale, Mibsal kaluka꞉isale, Magdiel kaluka꞉isale, a꞉la꞉ta꞉ga꞉ Ilam kaluka꞉isale. So꞉lo꞉ ina꞉lilo꞉ amilo꞉ wi a꞉no꞉ tambo, so꞉lo꞉ a꞉ma꞉ misa꞉ kaluwa꞉ wiyo꞉ o꞉m. So꞉lo꞉ ko꞉li ko꞉lilo꞉ i a꞉no꞉ hen inido꞉ a꞉na silikiyo꞉, iyo꞉ tambo Idom hen a꞉na sa꞉sen. A꞉la꞉ta꞉ga꞉ Idom kaluka꞉isaleyo꞉ tambo Iso꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ya꞉kobo꞉ Ka꞉ina꞉n hen, iya Aisa꞉gdo꞉ mageso꞉ ya꞉ga꞉lo꞉ sen a꞉naka asifo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ya꞉koba꞉ ene eso꞉lo꞉wa꞉ malolo꞉wo꞉ we. Yosa꞉b e dona do꞉la꞉ta꞉ga꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ dota꞉ga꞉yo꞉, Ya꞉koba꞉ nanogdo꞉ dian ga, Bilha o꞉lia꞉ Silba o꞉lia꞉ma꞉lo꞉ so꞉wa sa꞉la꞉la꞉ a꞉no꞉ Yosa꞉ba꞉ ene ao i ko꞉lo꞉, iyo꞉ egele siliki, no꞉ fofo꞉wo꞉ a꞉na bo꞉fo꞉len. Ene ao i a꞉ma꞉lo꞉ hala dimidabo꞉, Yosa꞉b eyo꞉ iyamo꞉wo꞉ malolome. ");
INSERT INTO bco_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ya꞉kob e anaso꞉ dofo꞉liki, Yosa꞉b e a꞉na sa꞉la꞉li ko꞉lo꞉, emo꞉wo꞉ ha꞉fo꞉wo꞉ alan disa꞉. Ko꞉sega Yosa꞉ba꞉ ao i nolbo꞉wo꞉ a꞉la꞉bo꞉ mo꞉go꞉ ko꞉lo꞉, Ya꞉kob eyo꞉ helebeso꞉g sambo nafa momado꞉wo꞉ dimida꞉sa꞉ga꞉, Yosa꞉bo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Iyaya꞉yo꞉ Yosa꞉b emo꞉lo꞉ ha꞉fo꞉ alan disa꞉lab a꞉no꞉, ao i nolba꞉ asulakiyo꞉, i o꞉lia꞉yo꞉ ha꞉fo꞉wo꞉ mo꞉disa꞉lab a꞉la꞉asulaki, iliyo꞉ Yosa꞉bo꞉wo꞉ mo꞉bea꞉sa꞉ga꞉, e o꞉lia꞉yo꞉ dinafalo꞉ mo꞉tola꞉len. ");
INSERT INTO bco_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","A꞉la꞉go꞉ko꞉lo꞉ ho꞉len no amio꞉ Yosa꞉b elo꞉ ofolo꞉ ba꞉ba꞉ a꞉no꞉ ao imo꞉ malolo꞉ meabiki, iliyo꞉ emo꞉wo꞉ asulo꞉wa꞉yo꞉ mo꞉beo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Yosa꞉b eyo꞉ ao imo꞉wo꞉ a꞉la꞉sio꞉, “Ofolo꞉ nilo꞉ ba꞉ba꞉yo꞉ gimo꞉wo꞉ maloloma꞉nigo꞉l ko꞉lo꞉ gio꞉ dabuma. ");
INSERT INTO bco_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nio꞉ tambo egelo꞉wa iliki, wito꞉ kegene bobodola꞉li dibida꞉len amio꞉, wit bobodo꞉ nilo꞉wo꞉ dasi hagale dowo꞉ a꞉no꞉ko꞉ iliki, wit bobodola꞉ gililo꞉wo꞉ nilo꞉wa kegea꞉sa꞉ga꞉, wa꞉sesefa꞉ya ba꞉ba꞉.” ");
INSERT INTO bco_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Yosa꞉b eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉ dowabiki, iliyo꞉ emo꞉ dabu ba꞉dakiyo꞉ a꞉la꞉sio꞉, “Ge nili misa꞉ kalu dowaki, nio꞉ hendele gi bo꞉fo꞉mela꞉no꞉, asulaki sa꞉laya?” A꞉la꞉go꞉ko꞉lo꞉ Yosa꞉b elo꞉ ofolo꞉ ba꞉ba꞉ a꞉no꞉ ao imo꞉ malolo꞉ meabikiyo꞉, iliyo꞉ emo꞉wo꞉ asulo꞉wa꞉yo꞉ mo꞉beo꞉wo꞉ alan a꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","A꞉la꞉ta꞉ga꞉ Yosa꞉b e wa꞉ka a꞉ofolo꞉ ko꞉lo꞉, eyo꞉ ao imo꞉wo꞉ malolakiyo꞉ a꞉la꞉sio꞉, “Niyo꞉ wa꞉ka ofolo꞉ ko꞉lo꞉ maloloma꞉nigo꞉l. Ofo꞉, eleyo꞉, a꞉la꞉ta꞉ga꞉ tamin kelen a꞉la꞉fo꞉ a꞉no꞉ nemo꞉ wabudaki, ni ha꞉ga elena ba꞉ba꞉.” ");
INSERT INTO bco_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yosa꞉b elo꞉ ofolo꞉ a꞉no꞉ iya o꞉lia꞉ ao o꞉lia꞉mo꞉wo꞉ malolo meabikiyo꞉, iyaya꞉yo꞉ emo꞉wo꞉ halalelaki a꞉la꞉sio꞉, “Ofolo꞉ gilo꞉ koma꞉yo꞉ o꞉bo꞉ngo꞉ fa꞉la꞉doma꞉ib ko꞉lo꞉ malolaya? Nelo꞉, go꞉wo꞉lo꞉, gao iyo꞉lo꞉ hendele gelo꞉wa ya꞉ga꞉ gulalu siliki misa꞉fu alilaki, gemo꞉wo꞉ a꞉na wabuluma꞉ib ko꞉lo꞉ sa꞉laya?” ");
INSERT INTO bco_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Yosa꞉ba꞉ ao ima꞉yo꞉ emo꞉wo꞉ asulo꞉wa꞉yo꞉ gadio꞉ dowo꞉ ko꞉sega, iyaya꞉yo꞉ ofolo꞉ malolo꞉ a꞉no꞉ asulufo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Ho꞉len no amio꞉, Yosa꞉ba꞉ ao iyo꞉ Sekem hena ha꞉na꞉ga꞉, iyaya꞉ no꞉ fofo꞉wo꞉ ko꞉lo꞉ bo꞉fo꞉mela꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ao iyo꞉ a꞉na sabiki, Ya꞉kob eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Gao iyo꞉ no꞉wo꞉ Sekem hen a꞉na bo꞉fo꞉lab ko꞉lo꞉, niyo꞉ ge a꞉na iliga꞉fa꞉nigo꞉l.” A꞉la꞉sa꞉labiki Yosa꞉b eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Ne o꞉lika ha꞉na꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","15","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gao o꞉lia꞉ no꞉ fofo꞉ o꞉lia꞉yo꞉ o꞉li saba꞉le a꞉la꞉bo꞉ ba꞉ba꞉ni ha꞉na꞉sa꞉ga꞉yo꞉, nelo꞉ amio꞉ sa꞉ma꞉ ya꞉bi.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ Yosa꞉b e iliga꞉tabiki, e Heblon hen a꞉no꞉ ta꞉ta꞉ga꞉, Sekem hen a꞉na ha꞉na꞉ni ane. Yosa꞉b e Sekem fa꞉la꞉dota꞉ga꞉ keda꞉li sia꞉lab amio꞉, kalu noma꞉yo꞉ ba꞉da꞉ga꞉, Yosa꞉bo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge o꞉b ko꞉lo꞉ kedaya?” ");
INSERT INTO bco_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","A꞉la꞉dabu ba꞉dabiki Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Ne nao iyo꞉ no꞉ fofo꞉lo꞉ bo꞉fo꞉lab i a꞉no꞉ kedo꞉l ko꞉lo꞉, giyo꞉ ilo꞉ sabo꞉ nelo꞉ walama.” ");
INSERT INTO bco_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","A꞉la꞉dabu ba꞉dabiki kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Iyo꞉ wena sa꞉ga꞉ ha꞉na꞉nikilo꞉ to nenelo꞉wo꞉ ne dabu. ‘Nio꞉ Dotan hen a꞉na ha꞉na꞉nigo꞉l’ a꞉la꞉do꞉ sio꞉wo꞉ ne dabu ko꞉lo꞉ iyo꞉ a꞉na sab.” A꞉la꞉sa꞉labiki Yosa꞉b e ene ao i ane o꞉leau kudu ha꞉na꞉ga꞉, iyo꞉ Dotan hen a꞉na sena galili. ");
INSERT INTO bco_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Yosa꞉b e ko꞉na꞉ yabiki, ao iya꞉yo꞉ e ba꞉da꞉sa꞉ga꞉, towo꞉ egelebo꞉ nenelakiyo꞉, e sana soma꞉niki a꞉la꞉li nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","20","Iliyo꞉ nenelakiyo꞉ a꞉la꞉sio꞉, “Ofolo꞉ ba꞉dan kaluwo꞉ yab ko꞉lo꞉, niliyo꞉ e sa꞉nda꞉sa꞉ga꞉, hen daido꞉ tiane a꞉na to꞉loma꞉niki. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ niliyo꞉ a꞉la꞉sa꞉ma꞉no꞉, ‘E no꞉ igo꞉lesena꞉ so꞉no꞉ka꞉’ a꞉la꞉sa꞉ma꞉no꞉. A꞉la꞉galega ene ofolo꞉ a꞉no꞉ o꞉ngo꞉malo꞉ngo꞉ doma꞉ib,” a꞉la꞉liki nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ilido꞉ to nenelab a꞉no꞉ Luben e da꞉da꞉la꞉ga꞉yo꞉, iliyo꞉ Yosa꞉bo꞉ mo꞉sanama꞉ki, eyo꞉ Yosa꞉bo꞉ asuwa꞉fa꞉no꞉ asulaki a꞉la꞉sio꞉, “Mela꞉no꞉ elo꞉wo꞉ niliyo꞉ mo꞉walema꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","E sanala꞉so꞉bo. Kalulo꞉ma hen wenamio꞉, niliyo꞉ e hen daido꞉ tiane alan wena to꞉lo alita꞉ga꞉ ta꞉fo꞉ mela꞉niki. Ko꞉sega e sa꞉nda꞉so꞉bo.” Luben eyo꞉ a꞉la꞉do꞉ sio꞉ a꞉no꞉ mo꞉wo꞉, ene ao i nolba꞉yo꞉ Yosa꞉bo꞉ mo꞉sanama꞉ki, eyo꞉ ao a꞉no꞉ gasilia꞉sa꞉ga꞉, a꞉ma꞉la꞉ iyalo꞉wa iliga꞉fa꞉no꞉ asulaki sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","A꞉la꞉nenela꞉sa꞉ga꞉ elena, Yosa꞉b e a꞉na fa꞉la꞉dowabiki, iliyo꞉ e ta꞉lia꞉sa꞉ga꞉, helebeso꞉g sambo nafale momado꞉ elo꞉ kafo꞉ mio꞉ a꞉no꞉ dugulia꞉sa꞉ga꞉, Yosa꞉b e hen daido꞉ tiane a꞉lab a꞉na to꞉lo alifa꞉. Hen daido꞉ tiane a꞉no꞉ ho꞉no꞉ aundo꞉mo꞉ delen. ");
INSERT INTO bco_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ iyo꞉ ma꞉no꞉ ma꞉niki mesa꞉ni ane. Ma꞉no꞉wo꞉ na꞉liki sen ami, iyo꞉ ololo ba꞉ba꞉yo꞉, Ismael kaluwo꞉ modo꞉ ko꞉lo꞉ ka꞉mol o꞉lia꞉ ya꞉lena ba꞉ba꞉. Ismael kaluwo꞉ i ho꞉n mundo꞉ nafalo꞉ dowan kelego꞉ ko꞉li ko꞉lilo꞉ a꞉no꞉ Gilead hen a꞉na a꞉la꞉ta꞉ga꞉ Isib kililia꞉ni ha꞉na꞉len. ");
INSERT INTO bco_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","I yab a꞉no꞉ ba꞉da꞉ga꞉yo꞉, Yuda eyo꞉ ao imo꞉wo꞉ a꞉la꞉sio꞉, “Niliyo꞉ nao nowo꞉ sa꞉nda꞉sa꞉ga꞉ do꞉lo꞉lelalega, nio꞉ a꞉ma꞉yo꞉ waga asuwa꞉fa꞉iba? ");
INSERT INTO bco_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","28","A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉ nao e da꞉ibo꞉ kalu doma꞉ki, Ismael kalumo꞉ moleya꞉ kililia꞉niki. Mo꞉wo꞉ nio꞉ ho꞉bo꞉wo꞉ imiliselo꞉biki, niliyo꞉ mo꞉sa꞉ma꞉no꞉.” Yuda eyo꞉ a꞉la꞉sa꞉labiki, ao i nolba꞉yo꞉lo꞉ asulo꞉wo꞉ imilise dowa꞉sa꞉ga꞉ elena, Midian kaluwo꞉ a꞉na fa꞉la꞉dowabiki, iliyo꞉ Yosa꞉b e hen daido꞉ amilo꞉ to꞉lo alifo꞉len a꞉no꞉ a꞉ma꞉la꞉ sila꞉sa꞉ga꞉, Ismael kalumo꞉ silba mole do꞉la꞉fo꞉ a꞉la꞉ a꞉ma꞉ kilili ko꞉lo꞉, Yosa꞉b e Ismael kaluwa꞉ tililia꞉ga꞉, Isib hena ane. ");
INSERT INTO bco_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Luben e a꞉ma꞉la꞉ ya꞉ga꞉, Yosa꞉bdo꞉ to꞉lo alifo꞉lendo꞉ a꞉na ba꞉ba꞉ni ane. Ko꞉sega Yosa꞉bo꞉ a꞉namilo꞉ mo꞉elenalo꞉bi ba꞉da꞉sa꞉ga꞉yo꞉, e iligo꞉. E ba꞉da꞉ga꞉ nofolakiyo꞉, helebeso꞉g enedo꞉wo꞉ bidila꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","E a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, ao ilo꞉wa fa꞉la꞉dowaki a꞉la꞉sio꞉, “So꞉wa a꞉no꞉ hen daido꞉ a꞉namilo꞉ mo꞉elena ba꞉ba꞉ ko꞉lo꞉, niyo꞉ waga dimidama꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","A꞉la꞉go꞉ko꞉lo꞉ iliyo꞉ goudi nowo꞉ sa꞉nda꞉sa꞉ga꞉, Yosa꞉ba꞉ helebeso꞉g sambo nafale momado꞉ a꞉no꞉ ho꞉bo꞉ a꞉na degelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","A꞉la꞉ta꞉ga꞉ iliyo꞉ helebeso꞉g a꞉no꞉ dia꞉ga꞉, iyalo꞉wa handalowakiyo꞉ a꞉la꞉sio꞉, “Helebeso꞉g we hena꞉ usa deleno꞉lo꞉biki nili ba꞉ba꞉ ko꞉lo꞉, helebeso꞉g we gi so꞉waya꞉ nowa꞉le a꞉la꞉liki, dinafa bo꞉ba” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Iyaya꞉yo꞉ dinafa ba꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “A꞉, we ni so꞉waya꞉ helebeso꞉g o꞉mo꞉lo꞉b. No꞉ igo꞉la꞉sen noma꞉ sa꞉nda꞉sa꞉ga꞉ tabodo mo꞉no꞉lo꞉b” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Ya꞉kob e nofolo꞉wo꞉ alan dowaki, helebeso꞉g enedo꞉wo꞉ bidila꞉sa꞉ga꞉, dabale mogago꞉ a꞉no꞉ ko꞉lo꞉. A꞉la꞉fo꞉ko꞉lo꞉ ene so꞉wa a꞉no꞉ ko꞉lo꞉ asulakiyo꞉, e ho꞉leno꞉ modo꞉ nofola꞉li sen. ");
INSERT INTO bco_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ya꞉koba꞉ insiso꞉i o꞉lia꞉ ida꞉ o꞉lia꞉ma꞉yo꞉ iyayo꞉ sagalema꞉ki, towo꞉ ha꞉nolo sa꞉ma꞉ni mio꞉ ko꞉sega, Ya꞉kob elo꞉ nofolo꞉ a꞉no꞉ mo꞉ta꞉fa꞉no꞉ asulakiyo꞉ eyo꞉ a꞉la꞉sio꞉, “Nilo꞉ so꞉wa sowo꞉ nofolo꞉ we dowa꞉i ha꞉na꞉la꞉ga꞉yo꞉, ne sowa꞉sa꞉ga꞉, dane ane hen a꞉na ni so꞉wa o꞉lia꞉ doma꞉ni ha꞉nalikiyo꞉ a꞉na elema꞉no꞉” Ya꞉kob eyo꞉ a꞉la꞉sa꞉la꞉likiyo꞉, ya꞉lifo꞉ko꞉ elen. ");
INSERT INTO bco_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","O꞉g ho꞉len a꞉namio꞉, Midian kaluwa꞉yo꞉ Yosa꞉b e dia꞉ga꞉, Isib hena tililia꞉gane. Isib misa꞉ kalu Fa꞉lo꞉wa꞉ ene da꞉la꞉diya꞉ misa꞉ kalu Botifa a꞉ma꞉yo꞉, ene nanog kalu doma꞉ki, Yosa꞉bo꞉ kilili. ");
INSERT INTO bco_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ho꞉len a꞉namio꞉, Yudayo꞉ ao iyo꞉ ta꞉ta꞉ga꞉, Adulam amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉, Hila o꞉lia꞉ mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","E a꞉na siliki, Ka꞉ina꞉n kalu Suaya꞉ ida꞉yo꞉ ko꞉lo꞉ dia꞉sa꞉ga꞉yo꞉, e o꞉lia꞉ alila꞉sa꞉ga꞉ dotabiki so꞉wayo꞉ alelo꞉. So꞉wa a꞉no꞉ sa꞉la꞉lia꞉sa꞉ga꞉, Yuda eyo꞉ Ea ko꞉lo꞉ wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","A꞉la꞉ta꞉ga꞉ e wa꞉ka alela꞉sa꞉ga꞉, so꞉wa nowo꞉ a꞉na sa꞉la꞉lia꞉sa꞉ga꞉, Onan wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tif amio꞉ eyo꞉ so꞉wa nowo꞉ wa꞉ka sa꞉la꞉lia꞉sa꞉ga꞉, Sa꞉la wikilo꞉. O꞉g ho꞉len a꞉namio꞉ Yuda e Kesib amisa꞉n a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","A꞉la꞉fo꞉ko꞉lo꞉ so꞉wayo꞉ analiabikiyo꞉, Yuda eyo꞉ inso꞉ wa꞉la꞉b Eayo꞉, ga Temalo꞉ nenela꞉sa꞉ga꞉ tili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ko꞉sega Yudaya꞉ ene wa꞉la꞉b so꞉wa, Ea e Yaweya꞉ siwa꞉l amio꞉ man mogago꞉ dimida꞉labiki, Yawe eyo꞉ e sanala꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ea e sowabiki, Yuda eyo꞉ Onan emo꞉wo꞉ a꞉la꞉sio꞉, “Nili mana꞉yo꞉ aowo꞉ so꞉walo꞉ma ka sowab amio꞉, ene gayo꞉ ene ao noma꞉ a꞉dia꞉sa꞉ga꞉, so꞉wayo꞉ ao sowo꞉ a꞉ma꞉lo꞉wo꞉ sa꞉la꞉mean ko꞉lo꞉, gaowa꞉ so꞉wayo꞉ a꞉na sa꞉la꞉mea꞉niki, ge ka꞉la꞉n sa꞉ba꞉lo꞉ we go꞉no꞉n dima.” Yuda eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","A꞉la꞉sa꞉labiki Onan e di ko꞉sega, so꞉wayo꞉ sa꞉la꞉lialikiyo꞉, so꞉wa a꞉no꞉ eno꞉ma doma꞉no꞉lo꞉b a꞉la꞉asulaki, e ga o꞉lia꞉ alila꞉likiyo꞉, aowa꞉ so꞉wa a꞉no꞉ sa꞉la꞉liabena꞉kiyo꞉, ho꞉bo꞉ elo꞉wo꞉ ha꞉la꞉ya wala꞉len. ");
INSERT INTO bco_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ko꞉sega Onan elo꞉ dimida꞉len a꞉no꞉, Yawe siwa꞉l amio꞉ mada mogago꞉ dimida꞉labiki, Yawe eyo꞉ elo꞉ sanala꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","A꞉la꞉gabiki Yuda eyo꞉ ena꞉su Temal emo꞉wo꞉ a꞉la꞉sio꞉, “Ge ni so꞉wa Selayo꞉ o꞉anayab amio꞉, ge go꞉la꞉ aya o꞉mesa꞉ hamana.” Yuda eyo꞉ a꞉la꞉do꞉ sio꞉ a꞉no꞉ mo꞉wo꞉ inso꞉ Sa꞉la eyo꞉, ao a꞉la꞉ sowo꞉ o꞉leau soma꞉iba꞉le a꞉la꞉asula꞉sa꞉ga꞉, e tagilaki sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ Temal eyo꞉ ene iyaya꞉ aya mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Dona nolo꞉ ta꞉ta꞉sa꞉ga꞉, Yudaya꞉ inga Suaya꞉ ida꞉ a꞉no꞉ sowabiki, Yuda e kuo꞉ya꞉la꞉ga꞉ dotakiyo꞉, e o꞉lia꞉ Adulam amisa꞉n kalu ene mili Hila o꞉lia꞉yo꞉, Timna amisa꞉na ha꞉na꞉sa꞉ga꞉, Yudaya꞉ ene nanog kaluwa꞉lo꞉ sibi fo꞉ndo꞉ gedea꞉labo꞉ ba꞉ba꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Noma꞉yo꞉ Temal emo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉suwo꞉ ene sibi fo꞉n gedema꞉ni, o꞉go꞉ Timna ha꞉na꞉lab.” ");
INSERT INTO bco_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","A꞉la꞉fo꞉ko꞉lo꞉ Temal eyo꞉ sa꞉ba꞉ so꞉g go꞉lo꞉ a꞉no꞉ hagola꞉sa꞉ga꞉, so꞉g ko꞉li nowo꞉ ko꞉lo꞉ sa꞉ga꞉la꞉sa꞉ga꞉, so꞉g nowo꞉ migiya go꞉lo꞉. A꞉la꞉ta꞉ga꞉ togo꞉ Timna a꞉la꞉ta꞉ga꞉lo꞉ ha꞉na꞉sen a꞉no꞉, Enaim amisa꞉n us a꞉na delen ko꞉lo꞉, Temal e ha꞉na꞉sa꞉ga꞉, Enaim amisa꞉n tog aniba yasilo꞉. Mo꞉wo꞉ Yudaya꞉ inso꞉ Selayo꞉ anali ko꞉sega, e Sa꞉la inga a꞉la꞉bo꞉ mo꞉sa꞉ma꞉ mio꞉ ko꞉lo꞉, e a꞉na ha꞉na꞉sa꞉ga꞉ yasilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yuda e a꞉na ya꞉ga꞉, ga a꞉no꞉ galilia꞉ga꞉yo꞉, ene migiyo꞉ helebeso꞉g ha꞉lu noma꞉ go꞉lo꞉ ko꞉lo꞉ Yuda eyo꞉ e uwo꞉lo꞉ dian ga a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","A꞉la꞉fo꞉ko꞉lo꞉ Yuda eyo꞉ ga a꞉no꞉ ena꞉su a꞉la꞉bo꞉ mo꞉asulo꞉ ko꞉lo꞉, elo꞉wa ha꞉na꞉sa꞉ga꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge ne o꞉lia꞉ alima꞉ni ho꞉no꞉l.” Yuda eyo꞉ a꞉la꞉sa꞉labiki, ga a꞉ma꞉ a꞉ma꞉la꞉ sa꞉laki, “Ge ne o꞉lia꞉yo꞉ alilalega, giyo꞉ nemo꞉wo꞉ o꞉b dimia꞉nigaya?” ");
INSERT INTO bco_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Eyo꞉ a꞉la꞉dabu ba꞉dabiki, Yuda eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ goudi inso꞉ nowo꞉ gemo꞉ dimia꞉no꞉.” A꞉la꞉sa꞉labiki ga a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Giyo꞉ hendele dinali sio꞉lo꞉b a꞉la꞉do꞉ ele ba꞉ba꞉no꞉wo꞉, o꞉go꞉ giyo꞉ kelego꞉ nowo꞉ nemo꞉wo꞉ o꞉b dimia꞉nigaya? Goudi inso꞉ gilo꞉wo꞉ fa꞉la꞉dowalikiyo꞉, kelego꞉ a꞉no꞉ go꞉no꞉nbo꞉wo꞉ a꞉ma꞉la꞉ dimia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yuda eyo꞉ a꞉la꞉sio꞉, “Ge kelego꞉ o꞉b dimina꞉ki asulaya?” A꞉la꞉sa꞉labiki Temal eyo꞉ a꞉la꞉sio꞉, “Ele ba꞉ba꞉no꞉ momado꞉ kelego꞉ gi dagas amilo꞉ difa꞉ a꞉no꞉lia꞉ i dom gilo꞉ dia꞉sia꞉sen o꞉lia꞉yo꞉ nemo꞉ dimina.” A꞉la꞉sa꞉labiki, Yuda eyo꞉ kelego꞉ a꞉no꞉ emo꞉ dimia꞉sa꞉ga꞉, ida꞉nino꞉ ali ko꞉lo꞉, Temal e a꞉na alelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Alila꞉sa꞉ga꞉yo꞉ Temal e ha꞉na꞉sa꞉ga꞉, migi amilo꞉ so꞉g go꞉lo꞉ a꞉no꞉ kolala꞉sa꞉ga꞉, sa꞉ba꞉ so꞉g a꞉no꞉ ko꞉lo꞉ a꞉ko꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","A꞉la꞉ta꞉ga꞉ Yuda eyo꞉ kelego꞉ elo꞉ gamo꞉lo꞉ dimi a꞉no꞉ a꞉ma꞉la꞉ dia꞉mena꞉ki, ene mili Hilayo꞉ goudi inso꞉wo꞉ ga o꞉mo꞉ dia꞉hamana꞉ki dimi. Hila e goudi inso꞉wo꞉ dia꞉ha꞉na꞉sa꞉ga꞉, ga a꞉no꞉ kedo꞉ ko꞉sega mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Eyo꞉ mo꞉ba꞉dabiki, amisa꞉n kalumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Tog ga nowo꞉, Enaim amisa꞉n tog anib amilo꞉ sabilo꞉ ba꞉ba꞉ a꞉no꞉ o꞉bamida꞉ saba?” A꞉la꞉li dabu ba꞉dabiki, iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Uwo꞉ dian ga nowo꞉ wiyo꞉ aundo꞉ma.” ");
INSERT INTO bco_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","A꞉la꞉fo꞉ko꞉lo꞉ e Yudalo꞉wa a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Niyo꞉ ga a꞉no꞉ mo꞉galiliabiki, amisa꞉n kalu imo꞉ dabu ba꞉ba꞉ amio꞉, iliyo꞉, ‘Uwo꞉ dian ga imilig nowo꞉ wiyo꞉ mo꞉sa꞉sen.’” ");
INSERT INTO bco_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","A꞉la꞉ta꞉ga꞉ Yuda eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ goudi inso꞉wo꞉ iliga꞉fo꞉ ko꞉sega, giyo꞉ ga a꞉no꞉ mo꞉ba꞉ba꞉ ko꞉lo꞉, na꞉no꞉ kaluka꞉isale nolba꞉yo꞉ dio꞉gelabena꞉ki, kelego꞉ gamo꞉lo꞉ dimi a꞉no꞉ eka dima꞉ki ta꞉foma.” Yuda eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Ele otaleno꞉ ta꞉ta꞉sa꞉ga꞉, kalu nolba꞉yo꞉ Yudalo꞉wa ya꞉ga꞉ a꞉la꞉sio꞉, “Ga꞉su Temal e uwo꞉ dia꞉labiki, so꞉wa sab.” Yuda e to a꞉no꞉ da꞉da꞉sa꞉ga꞉, eyo꞉ towo꞉ halale sa꞉laki, “E deya sana so꞉fa꞉ni tililia꞉ ya꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Iliyo꞉ ga a꞉no꞉ tililia꞉ ya꞉ga꞉ yakiyo꞉, ga a꞉ma꞉yo꞉ towo꞉ ena꞉sumo꞉ tamina saga꞉taki a꞉la꞉sio꞉, “Ne amilo꞉ so꞉wa sab we, nemo꞉lo꞉ kelego꞉lo꞉ dimi kalu wema꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ ele ba꞉ba꞉no꞉ kelego꞉ dagas amilo꞉ difa꞉ o꞉lia꞉ i dom dia꞉sia꞉sen o꞉lia꞉ we, kalu abeno꞉wa꞉le a꞉la꞉liki dinafa ba꞉da꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","To a꞉no꞉ saga꞉fo꞉ ko꞉lo꞉ Yuda eyo꞉ kelego꞉ a꞉no꞉ eno꞉lo꞉b a꞉la꞉bo꞉ dinafa ba꞉da꞉sa꞉ga꞉yo꞉, a꞉la꞉sio꞉, “Ni so꞉wa Sa꞉la eyo꞉ mo꞉dima꞉kiyo꞉, togo꞉ niyo꞉ ko꞉lo꞉ ko꞉lo꞉, ga wema꞉yo꞉ halayo꞉ mo꞉dimido꞉ ko꞉sega man mogago꞉wo꞉ ni dimido꞉.” Yuda eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, e Temal o꞉lia꞉yo꞉ wa꞉kabiyo꞉ mo꞉alila꞉len. ");
INSERT INTO bco_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Temal e so꞉wayo꞉ sa꞉la꞉liab amio꞉, eyo꞉ so꞉wayo꞉ a꞉la꞉ ko꞉lo꞉ sa꞉la꞉lia꞉nigabo꞉lo꞉b a꞉la꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","A꞉la꞉ta꞉ga꞉ e so꞉wayo꞉ sa꞉la꞉liabikiyo꞉, so꞉wa nowo꞉ dagi ko꞉le handalowabiki, bale ane ga a꞉ma꞉yo꞉ me genelo꞉wo꞉ dagiya sunu alitakiyo꞉ a꞉la꞉sio꞉, “So꞉wa we wa꞉la꞉b sa꞉la꞉liab.” ");
INSERT INTO bco_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Ko꞉sega so꞉wa a꞉ma꞉ dagiyo꞉ a꞉ma꞉la꞉ gendeliabiki, ene ao no ko꞉le sa꞉la꞉li. A꞉la꞉gabiki bale ane ga a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “So꞉wa ge ko꞉le dibodaki handalowab,” a꞉la꞉sa꞉laki, so꞉wa a꞉no꞉ Beles wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","A꞉la꞉ta꞉ga꞉yo꞉, ene ao me genelo꞉wa꞉lo꞉ dagi amilo꞉ suwo꞉ a꞉no꞉ sa꞉la꞉liabiki, e Sa꞉la wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yosa꞉bo꞉ Ismael kaluwa꞉ tililia꞉sa꞉ga꞉, Isib fa꞉la꞉dowabiki, Botifaya꞉ ene nanog kalu doma꞉ki kilili. Isib misa꞉ kalu Fa꞉lo꞉wa꞉ ene da꞉la꞉diya꞉ misa꞉yo꞉, Botifa e ko꞉lo꞉, Yosa꞉bo꞉ eyo꞉ kilili. ");
INSERT INTO bco_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yosa꞉b e Botifaya꞉ da꞉ibo꞉ kalu silikiyo꞉, Yawe e Yosa꞉b o꞉lia꞉ iliki, nanog Yosa꞉b elo꞉ dimida꞉len a꞉no꞉ nafale fa꞉la꞉dowo꞉ ko꞉lo꞉, Yosa꞉b e ene misa꞉ kalu Botifaya꞉ a a꞉naka sa꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yaweyo꞉ Yosa꞉b eya ilikiyo꞉, elo꞉ nanog dimida꞉lab a꞉no꞉ Yawe eyo꞉ nafale ta꞉ta꞉len a꞉no꞉ ene misa꞉ kalu Botifa e ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","A꞉la꞉fo꞉ko꞉lo꞉ Botifa eyo꞉ Yosa꞉bo꞉wo꞉ sagala꞉sa꞉ga꞉, nanog enedo꞉leyo꞉ ko꞉lo꞉ dima꞉ki ta꞉takiyo꞉, ene a o꞉lia꞉ kelego꞉ usamilo꞉ da꞉lab a꞉no꞉ tambo, Yosa꞉bo꞉ bo꞉fo꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Ho꞉len Yosa꞉b elo꞉ Botifaya꞉ a o꞉lia꞉ ene kelego꞉ tambo o꞉lia꞉lo꞉ bo꞉fo꞉melea꞉kilo꞉ da꞉feab a꞉na a꞉la꞉ta꞉ga꞉yo꞉, Yawe eyo꞉ Isib kalu Botifa emo꞉wo꞉ sagalaki, kelego꞉ Botifaya꞉ ayamilo꞉ delen a꞉no꞉lia꞉, ene egelo꞉wo꞉lo꞉ tambo nafale fa꞉la꞉doma꞉ki ta꞉fo꞉. Mo꞉wo꞉ Yawe e Yosa꞉b o꞉lia꞉ iliki go꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","A꞉la꞉fo꞉ko꞉lo꞉ Botifa eyo꞉ nanog elo꞉wo꞉ Yosa꞉bo꞉ bo꞉fo꞉melea꞉ki ta꞉fo꞉likiyo꞉, Yosa꞉ba꞉lo꞉ bo꞉fo꞉lab a꞉no꞉ e mo꞉kele asulaki, ma꞉no꞉ enedo꞉ nab a꞉no꞉ ko꞉lo꞉ asulo꞉. Yosa꞉b e mada nafa gesego꞉le, kalu halaido꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","tif amio꞉ Botifaya꞉ inga eyo꞉ Yosa꞉bo꞉ mesela꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “Ge ne o꞉lia꞉ alima꞉ni mena” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Ko꞉sega Yosa꞉b e mo꞉bea꞉sa꞉ga꞉ a꞉la꞉iyakiyo꞉, ene misa꞉ kaluwa꞉ ingamo꞉wo꞉ a꞉la꞉sio꞉, “Ni misa꞉ kalu Botifa eyo꞉ kelego꞉ elo꞉wo꞉ tambo nemo꞉ bo꞉fo꞉melea꞉ki ta꞉takiyo꞉, e mo꞉kele asulo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","A we ko꞉lo꞉ bo꞉fo꞉mela꞉no꞉ a꞉namio꞉, ni misa꞉ kaluwa꞉ to o꞉lia꞉ ni to o꞉lia꞉yo꞉ halaido꞉wo꞉ imilo꞉ ko꞉lo꞉lab. A꞉la꞉ta꞉ga꞉ kelego꞉ a usamilo꞉ da꞉labo꞉ tambo, Botifa eyo꞉ nemo꞉ bo꞉fo꞉melea꞉ki, ni dagiya difa꞉. Ko꞉sega ga enedo꞉wo꞉ ge ko꞉lo꞉, nemo꞉wo꞉ gola꞉so꞉boka꞉ a꞉la꞉liki salifa꞉ ko꞉lo꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ man mada mogago꞉le gilo꞉ sa꞉lab ko aumbo꞉ mada mo꞉dimidama꞉no꞉. A꞉la꞉bo꞉ dimidalega Godeya꞉ ene eleyo꞉ o꞉go꞉sema꞉ib.” Yosa꞉b eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Ho꞉leno꞉ tambowo꞉ Botifaya꞉ inga a꞉ma꞉yo꞉ Yosa꞉bo꞉ e o꞉lia꞉ alima꞉ mena꞉ki dabu ba꞉da꞉len, ko꞉sega, Yosa꞉b e ga a꞉ma꞉lo꞉ dabu ba꞉da꞉len a꞉no꞉ e mo꞉beaki mo꞉kudu ha꞉na꞉len ko꞉lo꞉, e o꞉lia꞉yo꞉ mo꞉ege dowa꞉len. ");
INSERT INTO bco_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","12","Ho꞉len no amio꞉, Yosa꞉b e ene nanog dia꞉ni a usa tiane amio꞉, kalu nolo꞉ aundo꞉ma elen ko꞉lo꞉, Botifa inga a꞉ma꞉yo꞉ Yosa꞉ba꞉ so꞉g ko꞉lo꞉wa ta꞉liakiyo꞉ a꞉la꞉sio꞉, “Ge ne o꞉lia꞉ alima꞉ni mena!” A꞉la꞉sa꞉labiki Yosa꞉b eyo꞉ ga elo꞉ so꞉g ta꞉liakilo꞉ susudab a꞉no꞉ emo꞉ ka ta꞉ta꞉ga꞉, e ha꞉la꞉ya nai ane. ");
INSERT INTO bco_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","15","Ga a꞉ma꞉yo꞉ Yosa꞉ba꞉ so꞉g ko꞉lo꞉wo꞉ emo꞉ ta꞉ta꞉ga꞉ ha꞉la꞉ amilo꞉ ha꞉nab a꞉no꞉ asula꞉sa꞉ga꞉, eyo꞉ ene nanog dian kalu nolo꞉ dabuma꞉kiyo꞉, ganagiliaki ho꞉ida꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Dabuma! Ne kaluwa꞉lo꞉ Hibulu kalu ko꞉lo꞉ nilo꞉ amilo꞉ tililia꞉mio꞉ a꞉ma꞉yo꞉ nio꞉ wa꞉la sa꞉ndaki sendelo alitab ko꞉lo꞉, o꞉go꞉ kalu a꞉no꞉ ne o꞉lia꞉ alima꞉ni ya꞉sa꞉ga꞉, ne ganagiliab amio꞉, e nilo꞉ ganagiliyo꞉wo꞉ da꞉da꞉sa꞉ga꞉, ene so꞉g a꞉no꞉ nelo꞉wa ta꞉ta꞉ga꞉, ha꞉la꞉ya nai ane.” ");
INSERT INTO bco_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","17","Ga eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, Yosa꞉ba꞉ so꞉g a꞉no꞉ elo꞉ ka dia꞉fo꞉leno꞉, Yosa꞉ba꞉ ene misa꞉ kaluwo꞉ ene aya a꞉ma꞉la꞉ yabiki, ga a꞉ma꞉yo꞉ emo꞉wo꞉ malolo꞉ meaki a꞉la꞉sio꞉, “Hibulu kalu ko꞉lo꞉ gilo꞉ nilo꞉ amilo꞉ tililia꞉mio꞉ a꞉ma꞉yo꞉ ne wa꞉la꞉ sa꞉ndaki sendelo alifa꞉nikiyo꞉, nelo꞉wa mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ne ganagiliyo꞉liki, eyo꞉ ene helebeso꞉go꞉ ne aniba kata꞉ta꞉ga꞉, ha꞉la꞉ya nai ane.” Botifa ingayo꞉ a꞉la꞉malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Botifa inga a꞉ma꞉yo꞉ inbo꞉wo꞉ malolo꞉ meaki a꞉la꞉sio꞉, “Gi nanog dian kalu a꞉ma꞉yo꞉ nemo꞉wo꞉ we au dimido꞉” a꞉la꞉liki malolabikiyo꞉, Yosa꞉ba꞉ misa꞉ kaluwo꞉ da꞉da꞉sa꞉ga꞉, e gadio꞉wo꞉ mada alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","A꞉la꞉go꞉ko꞉lo꞉ eyo꞉ Yosa꞉bo꞉ tililia꞉sa꞉ga꞉, Isib misa꞉ kaluwa꞉ ene dibolo kalulo꞉ disa꞉la꞉sen a a꞉na disalitabiki, Yosa꞉bo꞉ a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Ko꞉sega Yawe eyo꞉ Yosa꞉b o꞉lia꞉ elen ko꞉lo꞉, Yosa꞉b emo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉laki, Yawe eyo꞉ asulo꞉ nafayo꞉ dibolo alo꞉ bo꞉fo꞉lowan kalumo꞉ dimi ko꞉lo꞉ eyo꞉ Yosa꞉bo꞉ alan asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","A꞉la꞉fo꞉ko꞉lo꞉ kalu a꞉ma꞉yo꞉ Yosa꞉b eyo꞉ dibolo kalu nolo꞉ a꞉bo꞉fo꞉melea꞉ki ta꞉tabiki, dibolo a usamilo꞉ nanog ko꞉li ko꞉lilo꞉ fa꞉la꞉dowab a꞉no꞉ tambo, Yosa꞉b e bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Yawe e Yosa꞉b o꞉lia꞉ iliki, nanog Yosa꞉b elo꞉ dimidab a꞉no꞉ tambo nafale fa꞉la꞉do alifa꞉ ko꞉lo꞉, dibolo alo꞉ bo꞉fo꞉lowan kaluwo꞉ a꞉no꞉ ba꞉da꞉ga꞉yo꞉, Yosa꞉b elo꞉ nanog dia꞉lab a꞉no꞉, eyo꞉ mo꞉bebea꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Yosa꞉b e ho꞉leno꞉ modo꞉wo꞉ dibolowa sa꞉ga꞉ elen amio꞉, Isib misa꞉ kalu alan, Fa꞉lo꞉wa꞉ ene nanog kaluwo꞉ a꞉la꞉, nowo꞉ misa꞉ kalumo꞉lo꞉ wain ho꞉ndo꞉ wasu mia꞉sen, nowo꞉ misa꞉ kaluwa꞉ ma꞉ndo꞉ so꞉da꞉sen ko꞉sega, a꞉la꞉ma꞉yo꞉ misa꞉ kaluwa꞉lo꞉ mo꞉asulo꞉ au dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","3","A꞉la꞉dimido꞉ ko꞉lo꞉ Fa꞉lo꞉ eyo꞉ a꞉la꞉mo꞉wo꞉ mada gadia꞉sa꞉ga꞉, ene da꞉la꞉diya꞉ misa꞉ kaluwa꞉ dibolo a, Yosa꞉bdo꞉ sen a꞉na, a꞉la꞉yo꞉lo꞉ a꞉na to꞉lo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","A꞉la꞉gabikiyo꞉ da꞉la꞉diya꞉ misa꞉ kalu a꞉ma꞉yo꞉, a꞉la꞉ a꞉no꞉ Yosa꞉bo꞉ bo꞉fo꞉melea꞉ki ta꞉fo꞉ ko꞉lo꞉, a꞉la꞉yo꞉ dibolo a a꞉namilo꞉ seno꞉ ho꞉leno꞉ modo꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","A꞉na silikiyo꞉, waindo꞉ wasu mia꞉sen kalu o꞉lia꞉ ma꞉ndo꞉ so꞉da꞉sen kalu o꞉lia꞉ma꞉yo꞉, nulu imilig no amio꞉ a꞉la꞉ma꞉yo꞉ ofolo꞉. Noma꞉yo꞉ ofowo꞉ ko꞉li ba꞉ba꞉, noma꞉yo꞉lo꞉ ko꞉li ba꞉ba꞉ ko꞉lo꞉, ofolo꞉ noma꞉lo꞉wo꞉ ha꞉go꞉ ko꞉li, noma꞉lo꞉wo꞉lo꞉ ha꞉go꞉ ko꞉lilo꞉ ko꞉lo꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yosa꞉b e kea꞉fole a꞉la꞉lo꞉wa handalowaki ba꞉ba꞉ amio꞉, a꞉la꞉yo꞉ kele asula꞉li sena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Fa꞉lo꞉wa꞉ nanog kalu a꞉la꞉ a꞉no꞉ Yosa꞉ba꞉ misa꞉ kaluwa꞉ ene dibolo a a꞉namio꞉, Yosa꞉b o꞉lia꞉ sen ko꞉lo꞉, Yosa꞉b eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ga꞉go꞉ o꞉go꞉ mo꞉sagalako꞉, o꞉b kele asula꞉leya?” ");
INSERT INTO bco_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","A꞉la꞉dabu ba꞉dabiki, a꞉la꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉no꞉ o꞉go꞉ ofola꞉sa꞉ga꞉, o꞉lo꞉ fanda sa꞉ma꞉no꞉wo꞉ aundo꞉ma ko꞉lo꞉, na꞉no꞉ kele asula꞉li so꞉l.” A꞉la꞉sa꞉labiki Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ ofolo꞉ tambowo꞉ mo꞉wo꞉ fanda asulo꞉ ko꞉lo꞉, gaindo꞉ ofolo꞉wo꞉ nemo꞉ malolo꞉ mena” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","A꞉la꞉fo꞉ko꞉lo꞉ misa꞉ kalumo꞉lo꞉ wain ho꞉ndo꞉ wasu mia꞉sen kalu a꞉ma꞉yo꞉ ofolo꞉ elo꞉wo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉malolo꞉ me. “Ne ofolakiyo꞉, wain iyo꞉ ne milifa elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","A꞉la꞉ta꞉ga꞉ wain i a꞉namio꞉, eleyo꞉ otalen iliki, musugo꞉ a꞉na fa꞉la꞉dota꞉ga꞉, mamowo꞉ heda꞉sa꞉ga꞉yo꞉, fowo꞉ a꞉na heda꞉sa꞉ga꞉, gen dowabiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Misa꞉ kaluwa꞉ ho꞉ndo꞉ na꞉sen go꞉fo꞉wo꞉ ni dagiya꞉ ta꞉li sen ko꞉lo꞉, niyo꞉ wain fo a꞉no꞉ tulia꞉sa꞉ga꞉, ho꞉no꞉ go꞉fo꞉wa timana꞉ki, dagiya꞉ digibasi to꞉lola꞉sa꞉ga꞉, wain ho꞉n a꞉no꞉ Fa꞉lo꞉mo꞉ dimia꞉lena ba꞉ba꞉.” ");
INSERT INTO bco_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","A꞉la꞉malolo꞉ meabikiyo꞉, Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Gilo꞉ ofolo꞉ a꞉no꞉ mo꞉wo꞉ we. Wain ele otalen a꞉no꞉, ho꞉len otaleno꞉ ko꞉lo꞉ da꞉feyo꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Ho꞉len asol fa꞉la꞉dowalikiyo꞉, Fa꞉lo꞉wa꞉yo꞉ ge sili alita꞉sa꞉ga꞉, go꞉no꞉n nanogo꞉ a꞉ma꞉la꞉ dima a꞉la꞉ma꞉ib ko꞉lo꞉, gilo꞉ tamin amilo꞉ wain ho꞉n ko꞉lo꞉ Fa꞉lo꞉mo꞉lo꞉ dimia꞉sen aumbo꞉, wa꞉ka a꞉dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ko꞉sega ge sili alita꞉sa꞉ga꞉ ga꞉li dowakiyo꞉, ne giyo꞉ ga꞉lila꞉so꞉bo. Nelo꞉ dibolo ayo꞉ sili alifoma꞉kiyo꞉, giyo꞉ ne asuwa꞉taki, Fa꞉lo꞉mo꞉wo꞉ sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Mo꞉wo꞉ ne tamin amio꞉ Hibulu hena sen amio꞉, kalu nolba꞉yo꞉ ne madali susululia꞉ga꞉, Isib tililia꞉mio꞉. A꞉la꞉ta꞉ga꞉ ne Isib sen amio꞉, mogago꞉wo꞉ mo꞉dimido꞉ ko꞉sega, iliyo꞉ ne dibolo a wena madali tolo꞉ alifo꞉lab ko꞉lo꞉, giyo꞉ ne asuwa꞉ta꞉bi.” Yosa꞉b eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","A꞉la꞉ta꞉ga꞉ ma꞉ndo꞉ so꞉da꞉sen kalu elo꞉ ofolo꞉ malolo꞉ me a꞉ma꞉ ha꞉go꞉ nafale malolo꞉ meabo꞉lo꞉b a꞉la꞉asula꞉sa꞉ga꞉yo꞉, elo꞉ ofolo꞉ a꞉no꞉lo꞉ Yosa꞉bo꞉wo꞉ malolo꞉ meaki a꞉la꞉sio꞉, “Niyo꞉lo꞉ ofolo꞉ ko꞉lo꞉ maloloma꞉nigo꞉l. Ne ofolakiyo꞉, fafowo꞉ otalen amio꞉ ma꞉n dowo꞉fa꞉ fo꞉fo꞉lela꞉yo꞉ ni misa꞉ wa꞉la delena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Fafo wa꞉l amio꞉ ma꞉n dowo꞉fa꞉ ko꞉li ko꞉lilo꞉ fo꞉fo꞉lo꞉ a꞉no꞉ misa꞉ kalu, Fa꞉lo꞉ eno꞉ ko꞉sega, ma꞉n fo꞉fo꞉lo꞉ a꞉no꞉ o꞉ba꞉ya꞉ na꞉lena ba꞉ba꞉.” ");
INSERT INTO bco_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","A꞉la꞉malolo꞉ meabiki, Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Gilo꞉ ofolo꞉ a꞉no꞉ mo꞉wo꞉ we. Fafo otalen a꞉no꞉, ho꞉len otaleno꞉ ko꞉lo꞉ da꞉feyo꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Ho꞉len asol fa꞉la꞉dowalikiyo꞉, Fa꞉lo꞉ eyo꞉ gi misa꞉yo꞉ gedela꞉sa꞉ga꞉, gi do꞉mo꞉wo꞉ iya sunu hele alitaliki, gi howo꞉ o꞉ba꞉ya꞉ ma꞉ib.” Yosa꞉b eyo꞉ emo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","A꞉la꞉ta꞉ga꞉yo꞉, ho꞉len otaleno꞉ fa꞉la꞉dowabikiyo꞉, Fa꞉lo꞉ elo꞉ sa꞉la꞉li ho꞉leno꞉ dowo꞉ ko꞉lo꞉, ene nanog kalu i o꞉lia꞉ sagalema꞉niki, eyo꞉ ma꞉no꞉ alan dowo꞉fa꞉. Iyo꞉ sagalakiyo꞉, nanog kaluwa꞉ siwa꞉l amio꞉, waindo꞉ wasu mia꞉sen kalu o꞉lia꞉ ma꞉ndo꞉ so꞉da꞉sen kalu o꞉lia꞉ dibolo ayamilo꞉ eleno꞉ sili alita꞉sa꞉ga꞉ tililia꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","A꞉la꞉ta꞉ga꞉ waindo꞉ wasu mia꞉sen kalu a꞉no꞉ Fa꞉lo꞉wa꞉yo꞉ nanog enedo꞉ tamin amilo꞉ dia꞉sen a꞉no꞉ enebo꞉ dima꞉ki dimi ko꞉lo꞉, kalu a꞉ma꞉yo꞉ wain ho꞉no꞉ Fa꞉lo꞉mo꞉wo꞉ wa꞉ka wasume. ");
INSERT INTO bco_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Ko꞉sega Fa꞉lo꞉ eyo꞉ ma꞉ndo꞉ so꞉da꞉sen kaluwa꞉ do꞉mo꞉wo꞉ iwalu sunu hele alifa꞉. A꞉la꞉do꞉ go꞉ a꞉no꞉ Yosa꞉b elo꞉ a꞉la꞉mo꞉lo꞉ sio꞉ o꞉leaumbo꞉ hendele fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Ko꞉sega waindo꞉ Fa꞉lo꞉mo꞉lo꞉ wasu mia꞉sen kalu a꞉ma꞉yo꞉ e nanog diakiyo꞉, Yosa꞉bo꞉ mo꞉asulaki ga꞉lila꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Dona a꞉la꞉yo꞉ gulula꞉sa꞉ga꞉ dotabiki, Fa꞉lo꞉ e ofolakiyo꞉, e Nail ho꞉n aniba elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Ho꞉n sa꞉ a꞉na iliki ba꞉ba꞉ amio꞉, kao dom a꞉la꞉fo꞉ toda꞉le nafale ko꞉lo꞉ ho꞉na a꞉la꞉ta꞉ga꞉ ha꞉la꞉ya fa꞉la꞉dota꞉ga꞉, fuguso꞉ a꞉na nabiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","A꞉ma꞉ fa꞉s amio꞉, Nail ho꞉n a꞉nakabiyo꞉, kao dom a꞉la꞉fo꞉ nolo꞉, mogago꞉ kagane alifelo꞉ ko꞉lo꞉ fa꞉la꞉dota꞉ga꞉, Nail ho꞉n sa꞉ya kao toda꞉lo꞉ a꞉lab anib a꞉na ya꞉ga꞉ kagayabiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","A꞉na kagayakiyo꞉, kao mogago꞉ kagane alifelo꞉ a꞉ma꞉yo꞉ kao nafale toda꞉ dom a꞉la꞉fo꞉ a꞉no꞉ ili tambo na꞉liki kedelabiki, Fa꞉lo꞉ e a꞉na iligi dasi. ");
INSERT INTO bco_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Fa꞉lo꞉ e wa꞉ka a꞉ali amio꞉, e ofolo꞉ nowo꞉ a꞉ba꞉dakiyo꞉, wida꞉ buwo꞉ imilig fa꞉la꞉ne a꞉namio꞉, to꞉m dom a꞉la꞉fo꞉ elen ko꞉lo꞉, fowo꞉ mada toda꞉le hedo꞉ elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","A꞉ma꞉ fa꞉s amio꞉, to꞉m dom a꞉la꞉fo꞉ nowo꞉ wa꞉ka ba꞉ba꞉, ko꞉sega molofayo꞉ alan dowo꞉ ko꞉lo꞉, fo elo꞉wo꞉ galin hedo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Fo a꞉no꞉ hedabiki, fo safale hedo꞉ a꞉ma꞉yo꞉ fo toda꞉le hedo꞉ a꞉no꞉ na꞉liki kedelabiki, Fa꞉lo꞉ e iligi dasila꞉sa꞉ga꞉, ofo ba꞉ba꞉lo꞉b a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Kea꞉fowo꞉ Fa꞉lo꞉ e kele asulo꞉wo꞉ alan dowabiki, Isib amilo꞉ ho꞉le ba꞉dan kalu o꞉lia꞉ asulo꞉lo꞉ di kalu o꞉lia꞉yo꞉, elo꞉wa mena꞉ki ho꞉ido꞉. Iyo꞉ elo꞉wa fa꞉la꞉dowabiki, Fa꞉lo꞉ elo꞉ ofolo꞉ ba꞉ba꞉ a꞉no꞉ imo꞉wo꞉ malolo꞉ me. Ko꞉sega iliyo꞉ ha꞉go꞉ mo꞉asulo꞉ ko꞉lo꞉ mo꞉fanda sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","A꞉la꞉gabiki wain ho꞉ndo꞉ wasu mia꞉sen kalu a꞉ma꞉yo꞉ Fa꞉lo꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Nilo꞉ hala dimido꞉wo꞉ o꞉go꞉ wa꞉ka a꞉asulabiki foga꞉le sa꞉ma꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Tamin amio꞉ giyo꞉ ne o꞉lia꞉ ma꞉ndo꞉ so꞉da꞉sen kalu o꞉lia꞉mo꞉wo꞉ gadia꞉sa꞉ga꞉, na꞉no꞉ da꞉la꞉diya꞉ misa꞉ kaluwa꞉ dibolo aya disa꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Nulu imilig no amio꞉ na꞉no꞉ ofolakiyo꞉, niyo꞉ ko꞉li ba꞉ba꞉, eyo꞉lo꞉ ko꞉li ba꞉ba꞉ ko꞉lo꞉, ofolo꞉ a꞉ma꞉ ha꞉go꞉ ko꞉lilo꞉ ko꞉lo꞉ da꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Dibolo a a꞉namio꞉ Hibulu da꞉ibo꞉ so꞉wa nowo꞉ elen. Gi da꞉la꞉diya꞉ misa꞉ kalu Botifa ene da꞉ibo꞉ ko꞉lo꞉ e na꞉n o꞉lia꞉ dibolo aya sen. Naindo꞉ ofolo꞉ a꞉no꞉ emo꞉ malolo꞉ me amio꞉, eyo꞉ na꞉nbo꞉wo꞉ ofolo꞉ a꞉ma꞉ ha꞉go꞉, nilo꞉wo꞉ ko꞉li, elo꞉wo꞉ ko꞉li a꞉la꞉fanda sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","A꞉la꞉ta꞉ga꞉ elo꞉ fanda sio꞉ aumbo꞉, hendele fa꞉la꞉dowo꞉. Nanog nilo꞉ tamin amilo꞉ dia꞉sen a꞉no꞉, giyo꞉ nemo꞉wo꞉ wa꞉ka dimi ko꞉sega, giyo꞉ ma꞉ndo꞉ so꞉da꞉sen kaluwa꞉ do꞉mo꞉wo꞉ iwalu sunu hele alifa꞉.” ");
INSERT INTO bco_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","A꞉la꞉sa꞉labiki Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉ mena꞉ki ho꞉idabiki, dibolo alo꞉ bo꞉fo꞉lowan kalu i a꞉ma꞉yo꞉ e bo꞉bo꞉ge sili alita꞉sa꞉ga꞉ ami, Yosa꞉b e ma꞉sa꞉no꞉ hunda꞉b, helebeso꞉go꞉ ka꞉la꞉b a꞉la꞉ta꞉ga꞉, Fa꞉lo꞉lo꞉wa mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Ne ofolo꞉ ko꞉sega, kalu nolo꞉ ofolo꞉ a꞉ma꞉ ha꞉go꞉ mo꞉fanda asulo꞉. Ko꞉sega ofolo꞉wo꞉ gemo꞉wo꞉ malolo꞉ mealikiyo꞉, giyo꞉ o꞉li ka fanda sa꞉ma꞉ika꞉, a꞉la꞉bo꞉ nemo꞉wo꞉ a꞉la꞉sa꞉labi dabu.” ");
INSERT INTO bco_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","A꞉la꞉sa꞉labiki Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Ofolab a꞉ma꞉ ha꞉go꞉ niyo꞉ fanda sa꞉ma꞉no꞉wo꞉ mo꞉ililo꞉ ko꞉sega, ge ha꞉sa mesea꞉kiyo꞉, Gode eyo꞉ gilo꞉ ofolo꞉ ko꞉ o꞉lika fanda walama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","A꞉la꞉sa꞉labiki Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉malolo꞉, “Ne ofolakiyo꞉, ne Nail ho꞉n aniba elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Ho꞉n sa꞉ a꞉na iliki ba꞉ba꞉ amio꞉, kao dom a꞉la꞉fo꞉ toda꞉ nafale ko꞉lo꞉ ho꞉na a꞉la꞉ta꞉ga꞉ ha꞉la꞉ya fa꞉la꞉dota꞉ga꞉, fuguso꞉ a꞉na nabiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","20","A꞉ma꞉ fa꞉s amio꞉, ho꞉n a꞉nakabiyo꞉, kao dom a꞉la꞉fo꞉ nolo꞉, mogago꞉ kagane alifelo꞉ ko꞉lo꞉ fa꞉la꞉dota꞉ga꞉, kao a꞉ma꞉yo꞉ kao toda꞉ nafale dom a꞉la꞉fo꞉ a꞉no꞉ ili tambo na꞉labiki ba꞉ba꞉. Isib hen us wenamio꞉ ne tamin amio꞉ kao mogago꞉le o꞉leo꞉ngo꞉wo꞉ mo꞉ba꞉da꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Kao kagane alifelo꞉ a꞉ma꞉yo꞉, kao toda꞉ a꞉no꞉ tambo mo꞉no꞉ ko꞉sega, iyo꞉ tamin amilo꞉ kagane alifelo꞉ o꞉ngo꞉ka dowabiki ba꞉da꞉ga꞉, ne a꞉na iligi dasi. ");
INSERT INTO bco_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","A꞉la꞉ta꞉ga꞉ ne wa꞉ka a꞉ali amio꞉, ofolo꞉ nowo꞉ a꞉ba꞉dakiyo꞉, wida꞉ buwo꞉ imilig fa꞉la꞉ne a꞉namio꞉, to꞉m dom a꞉la꞉fo꞉ a꞉lab ko꞉lo꞉ fowo꞉ mada toda꞉le hedo꞉ elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","A꞉ma꞉ fa꞉s amio꞉, to꞉m dom a꞉la꞉fo꞉ nolo꞉ wa꞉ka ba꞉ba꞉, ko꞉sega molofayo꞉ alan dowo꞉ ko꞉lo꞉, fo elo꞉wo꞉ mula꞉niliaki, galin hedo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Fo a꞉no꞉ hedabiki, fo galin hedo꞉ a꞉ma꞉yo꞉ fo nafale doma꞉la꞉fo꞉ a꞉no꞉ na꞉liki kedelabiki ba꞉ba꞉. Nilo꞉ ofolo꞉ a꞉no꞉ ho꞉le ba꞉dan kalu imo꞉wo꞉ malolo꞉ me ko꞉sega, kalu imilig noma꞉yo꞉ ha꞉go꞉ nemo꞉wo꞉ mo꞉fanda sio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉malolo꞉ meabiki, Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Ofolo꞉ a꞉la꞉ gilo꞉ ba꞉ba꞉ a꞉ma꞉ ha꞉go꞉ imilo꞉ ko꞉lo꞉lab. Gode elo꞉ dimidama꞉no꞉ a꞉no꞉ gemo꞉ wido꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Kao dom a꞉la꞉fo꞉ toda꞉le nafa a꞉no꞉ dona dom a꞉la꞉fo꞉ da꞉feaki a꞉la꞉ta꞉ga꞉ to꞉m nafale dom a꞉la꞉fo꞉ a꞉no꞉lo꞉ dona dom a꞉la꞉fo꞉ da꞉feaki go꞉. Ofolo꞉ a꞉la꞉ a꞉no꞉ imilo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","A꞉la꞉ta꞉ga꞉ kao mogago꞉ kagane alifelo꞉ a꞉no꞉lia꞉ to꞉m dom a꞉la꞉fo꞉ ko꞉lo꞉ fowo꞉ mula꞉niliakilo꞉ galin hedo꞉ a꞉no꞉lia꞉yo꞉, dona dom a꞉la꞉fo꞉ amilo꞉ ma꞉no꞉wo꞉ mo꞉fa꞉la꞉ndalikilo꞉, maiyo꞉ mesa꞉no꞉ a꞉no꞉ ko꞉lo꞉ da꞉feaki go꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Nilo꞉ gemo꞉lo꞉ mo꞉mo꞉da so꞉lo꞉l aumbo꞉, Gode eyo꞉ elo꞉ dimidama꞉no꞉ a꞉no꞉ gemo꞉ wido꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Dona dom a꞉la꞉fo꞉ amio꞉ Isib hen a꞉namio꞉, ma꞉no꞉ gelo꞉wo꞉ nafale fa꞉la꞉dowaki, ma꞉no꞉ ma꞉no꞉wo꞉ modo꞉ ko꞉lo꞉ walele ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","A꞉ma꞉ fa꞉s amio꞉, dona dom a꞉la꞉fo꞉ no amio꞉, ma꞉no꞉ egelo꞉wo꞉ mo꞉fa꞉la꞉ndaliki, maiyo꞉wo꞉ alan fa꞉la꞉doma꞉ib. Isib kaluka꞉isaleyo꞉ maiyo꞉wo꞉ alan dowakiyo꞉, dona dom a꞉la꞉fo꞉ a꞉namilo꞉ ma꞉no꞉ wala꞉likilo꞉ na꞉len a꞉no꞉ babalela꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Molofayo꞉ alan badio꞉ fa꞉la꞉dowaliki, kaluka꞉isaleyo꞉ ma꞉no꞉ walelelakilo꞉ na꞉len a꞉no꞉ wa꞉kabiyo꞉ mo꞉asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Gilo꞉ ofolo꞉ a꞉la꞉gali ba꞉ba꞉ a꞉ma꞉yo꞉, Gode eyo꞉ mada hendele fa꞉la꞉do alifa꞉ib, a꞉la꞉ta꞉ga꞉ kelego꞉ a꞉no꞉ ko꞉na꞉ma fa꞉la꞉do alifa꞉nigab a꞉la꞉liki widaki go꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","A꞉la꞉ma꞉ib ko꞉lo꞉ kalu imilig nowo꞉ Isib hen wenamio꞉ bo꞉fo꞉melea꞉ki, giyo꞉ asulo꞉ nafalelo꞉ di kalu imilig nowo꞉, da꞉fea꞉sa꞉ga꞉ ta꞉ta꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","A꞉la꞉ta꞉ga꞉yo꞉ kalu a꞉ma꞉ ha꞉g amilo꞉ dowakilo꞉ bo꞉fo꞉mela꞉no꞉wo꞉, giyo꞉ hen ko꞉li ko꞉lilo꞉ amio꞉ da꞉fea꞉sa꞉ga꞉ ta꞉fela꞉bi. A꞉la꞉bo꞉ ta꞉fela꞉sa꞉ga꞉yo꞉, kalu i a꞉ma꞉ bo꞉fo꞉likiyo꞉, dona doma꞉la꞉fo꞉ a꞉namio꞉ ma꞉no꞉ nafayo꞉ fa꞉la꞉dowalikiyo꞉, iliyo꞉ fo tulakiyo꞉ heb bila꞉fo꞉wo꞉ aloba꞉da꞉sa꞉ga꞉, heb imilig nowo꞉ gamanimo꞉ dimialiki, ili bo꞉fo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","A꞉la꞉dimidalikiyo꞉, dona nafa a꞉namilo꞉ ma꞉no꞉ heb nolo꞉ gamanimo꞉lo꞉ alobana mia꞉ib a꞉no꞉ gi wiya ilikiyo꞉, bo꞉fo꞉lowan kalu iliyo꞉ ma꞉no꞉ a꞉no꞉ kegenea꞉ta꞉bi. A꞉la꞉ta꞉ga꞉ ma꞉no꞉ a꞉no꞉ amisa꞉n amilo꞉ ma꞉no꞉lo꞉ dila꞉sen a a꞉na dila꞉sa꞉ga꞉yo꞉, kalu nolba꞉yo꞉ afalebo꞉ diabena꞉ki, imo꞉ bo꞉fo꞉melea꞉ki ta꞉ta꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","A꞉la꞉fo꞉ko꞉lo꞉ dona dom a꞉la꞉fo꞉ us a꞉namio꞉, Isib hen amio꞉ maiyo꞉ alan fa꞉la꞉dowalikiyo꞉, bo꞉fo꞉lowan kaluwa꞉lo꞉ ma꞉no꞉ ko꞉lo꞉ dila꞉ a꞉no꞉ kaluka꞉isaleyo꞉ maiyo꞉ daiyabena꞉ki, iliyo꞉ ma꞉no꞉ a꞉no꞉ a꞉na alobana meya꞉mela꞉ib.” Yosa꞉b eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yosa꞉b elo꞉ imo꞉lo꞉ dimidama꞉kilo꞉ sa꞉lab a꞉no꞉, Fa꞉lo꞉ o꞉lia꞉ ene nanogdo꞉ bo꞉fo꞉lowan kalu o꞉lia꞉ma꞉yo꞉ da꞉da꞉sa꞉ga꞉, asulo꞉wo꞉ imilise difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Asulo꞉ imilise dowaki, Fa꞉lo꞉ eyo꞉ ene nanogdo꞉ bo꞉fo꞉lowan kalu imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu we Godeya꞉ Mamayo꞉ dowo꞉ ko꞉lo꞉, kalu we o꞉ngo꞉ nowo꞉ da꞉fema꞉no꞉wo꞉ aundo꞉ma.” ");
INSERT INTO bco_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","A꞉la꞉sa꞉la꞉sa꞉ga꞉, Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ asulo꞉ we gemo꞉ wido꞉ ko꞉lo꞉, kalu asulo꞉lo꞉ di nafale nowo꞉, ge o꞉ngo꞉wo꞉ wiyo꞉ aundo꞉ma. ");
INSERT INTO bco_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Giyo꞉ ni heno꞉ tambo bo꞉fo꞉laliki, gilo꞉ to sa꞉lab a꞉no꞉ Isib kaluka꞉isaleya꞉yo꞉ kudu hamana꞉kiyo꞉, ge ni ta꞉fa꞉nigo꞉l. Ne Isib misa꞉ kalu alan ko꞉lo꞉, gelo꞉ bo꞉fo꞉mela꞉ibo꞉ imilise ne. ");
INSERT INTO bco_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ niyo꞉ ge Isib heno꞉ tambo bo꞉fo꞉melea꞉ki, misa꞉ kalu ta꞉to꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Fa꞉lo꞉ eyo꞉ a꞉la꞉saetakiyo꞉, ene dagi gasa amilo꞉ go꞉fo꞉ ki dia꞉tan a꞉no꞉ dugulia꞉ga꞉, Yosa꞉ba꞉ dagi gasaya sa꞉ga꞉le alifa꞉. A꞉la꞉ta꞉ga꞉ helebeso꞉g nafaleya꞉ Yosa꞉b e momade alitakiyo꞉, go꞉l amilo꞉ sa꞉ni a꞉no꞉ ene dagasa kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","A꞉la꞉ta꞉ga꞉ Fa꞉lo꞉ eyo꞉ wi alano꞉ Yosa꞉bo꞉ dimiaki, ene ho꞉s amilo꞉ i fofodo꞉ kalulo꞉ dia꞉ha꞉na꞉sen a꞉no꞉, Yosa꞉bo꞉ a꞉na asita꞉ga꞉ sia꞉melea꞉ki iliga꞉fo꞉. Yosa꞉b e a꞉na ha꞉na꞉ga꞉ ha꞉nabikiyo꞉, Fa꞉lo꞉wa꞉ ene nanog kalu iyo꞉ tamin doba꞉da꞉ ha꞉na꞉ga꞉ ha꞉naki, kaluka꞉isalemo꞉wo꞉, “Gio꞉ gulalu mesea” a꞉la꞉sa꞉la꞉i ane. A꞉la꞉gabiki Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉ Isib heno꞉ tambo bo꞉fo꞉melea꞉ki, misa꞉ kalu ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Isiba꞉ misa꞉ kalu alano꞉, Fa꞉lo꞉ ne. Isib kaluka꞉isaleyo꞉ inido꞉ asulo꞉ aumbo꞉ nanog nowo꞉ mo꞉dimidama꞉ib. A꞉la꞉ba. Giyo꞉ ‘O꞉lika꞉’ a꞉la꞉bo꞉ mo꞉sa꞉lalega, Isib hen tambo us a꞉namio꞉ kaluka꞉isale iliyo꞉ nanog nowo꞉ mo꞉dimidama꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Fa꞉lo꞉ eyo꞉ Yosa꞉ba꞉ wi ho꞉gi wikilo꞉wo꞉ we, Safenat Banea. A꞉la꞉ta꞉ga꞉ On amisa꞉n a꞉namilo꞉ gulugululo꞉ alo꞉ bo꞉fo꞉lowan kalu Botifelaya꞉ ida꞉, Asenat a꞉no꞉ Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉ dima꞉ki sili alifa꞉. Yosa꞉b eyo꞉ Fa꞉lo꞉wa꞉ nanogdo꞉ mo꞉mo꞉da dilo꞉ ho꞉len a꞉namio꞉, Yosa꞉b e donayo꞉ do꞉la꞉fo꞉ otaleno꞉ gulula꞉. A꞉la꞉ta꞉ga꞉ Yosa꞉b e Fa꞉lo꞉wa꞉ aya silikiyo꞉, e Isib heno꞉ tambo sia꞉liki ililo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Dona dom a꞉la꞉fo꞉ ho꞉len a꞉namio꞉, ma꞉no꞉wo꞉ nafale ko꞉lo꞉ hedo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Isib hen amio꞉ dona doma꞉la꞉fo꞉ ma꞉no꞉wo꞉ modo꞉lo꞉ fa꞉la꞉dowab us a꞉namio꞉, Yosa꞉b eyo꞉ ma꞉no꞉ walelelab a꞉no꞉ tambo kegeaki, amisa꞉n ko꞉li ko꞉lilo꞉ a꞉namilo꞉ ma꞉no꞉ ini egelo꞉ amilo꞉ a꞉no꞉ dia꞉sa꞉ga꞉, ini ma꞉no꞉lo꞉ dila꞉sen a a꞉na tambo dila꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yosa꞉b eyo꞉ ma꞉no꞉ a꞉la꞉do꞉ kegenela꞉leno꞉, modo꞉ sa꞉ mu o꞉ngo꞉ fa꞉la꞉dowo꞉ ko꞉lo꞉, elo꞉ da꞉feakilo꞉ alobana ba꞉ba꞉no꞉wo꞉ mo꞉lilo꞉ ko꞉lo꞉ ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Maiyo꞉ ho꞉leno꞉ o꞉fa꞉la꞉doma꞉nigabikiyo꞉, Yosa꞉ba꞉ inga Asenat eyo꞉ kalu so꞉wa a꞉la꞉ ko꞉lo꞉ sa꞉la꞉li. Asenat e On amisa꞉n a꞉namilo꞉ gulugululo꞉ alo꞉ bo꞉fo꞉lowan kalu Botifelaya꞉ ene ida꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","So꞉wa wa꞉la꞉bo꞉ sa꞉la꞉liabikiyo꞉, Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ ne hida꞉yo꞉ o꞉lia꞉ ni dowa꞉ so꞉lo꞉ o꞉lia꞉yo꞉ ga꞉lila꞉ma꞉ki ta꞉fo꞉.” A꞉la꞉sa꞉la꞉likiyo꞉ so꞉wa a꞉no꞉ Manasa wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","A꞉ma꞉ fa꞉s amio꞉ so꞉wa nowo꞉ a꞉sa꞉la꞉liakiyo꞉, Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Nelo꞉ hida꞉ya꞉lo꞉ di hen a꞉namio꞉ Gode eyo꞉ so꞉wayo꞉ nemo꞉ dimi.” A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ so꞉wa a꞉no꞉ A꞉flam wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Isib hen amio꞉ dona dom a꞉la꞉fo꞉ ma꞉no꞉lo꞉ wala꞉len a꞉no꞉ kedetabiki, Yosa꞉b elo꞉ sio꞉ o꞉li aumbo꞉ dona dom a꞉la꞉fo꞉ nowo꞉ ma꞉no꞉lo꞉ mo꞉fa꞉la꞉ma꞉no꞉ a꞉no꞉ fa꞉la꞉dowabiki, maiyo꞉wo꞉ alan dowo꞉. Hen tambo nol amio꞉ ma꞉no꞉wo꞉ aundo꞉ma dowaki maiyo꞉wo꞉ alan dowo꞉ ko꞉sega, Isib hen a꞉namio꞉ ma꞉no꞉wo꞉ o꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Isib kaluka꞉isaleyo꞉ maiyo꞉wo꞉ fa꞉la꞉dowabikiyo꞉, ma꞉no꞉wo꞉ Fa꞉lo꞉mo꞉ ha꞉iyaki dabu ba꞉ba꞉. Iliyo꞉ emo꞉ ha꞉iyabiki, Fa꞉lo꞉ eyo꞉ a꞉la꞉sio꞉, “Gio꞉ Yosa꞉bdo꞉wa ha꞉na꞉sa꞉ga꞉, to elo꞉ gimo꞉lo꞉ sa꞉lab aumbo꞉ kudu ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Isib hen a꞉namio꞉, maiyo꞉wo꞉ alan dowaki tambo ililabikiyo꞉, Yosa꞉b eyo꞉ ma꞉no꞉lo꞉ dila꞉sen a a꞉no꞉ kolaefa꞉ ko꞉lo꞉, Isib kaluka꞉isale iliyo꞉ ma꞉no꞉wo꞉ a꞉na kililia꞉ ya꞉len. ");
INSERT INTO bco_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","A꞉la꞉ta꞉ga꞉ henfelo꞉ tambo nol amio꞉lo꞉, maiyo꞉wo꞉ alan fa꞉la꞉dowa꞉i ane ko꞉lo꞉ iyo꞉lo꞉ Isib hen a꞉na ya꞉sa꞉ga꞉, Yosa꞉b elo꞉wa ma꞉no꞉ kililia꞉ni ya꞉len. ");
INSERT INTO bco_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ho꞉len a꞉namio꞉ Ya꞉kob e Isibo꞉ ma꞉no꞉wo꞉ alan da꞉laka꞉ a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, insiso꞉imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ madali nolko꞉ ba꞉da꞉likilo꞉ saetko, wangabiki gaya? ");
INSERT INTO bco_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Niyo꞉ ma꞉no꞉ alano꞉ Isib hen amio꞉ da꞉laka꞉ a꞉la꞉bo꞉ dabu ko꞉lo꞉, nio꞉ mo꞉sowaki o꞉mela꞉niki, gio꞉ a꞉na ha꞉na꞉sa꞉ga꞉, ma꞉no꞉ a꞉no꞉ nilo꞉ kililia꞉ni hamana.” ");
INSERT INTO bco_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","A꞉la꞉sa꞉labiki Yosa꞉ba꞉ ao i do꞉la꞉fo꞉ a꞉no꞉ Isib hena tina꞉sa꞉ga꞉, ma꞉no꞉ kililia꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ko꞉sega Ya꞉kob eyo꞉ Ba꞉nsameno꞉ iliga꞉talega, tog amio꞉ hida꞉yo꞉ nowo꞉ eyamio꞉ fa꞉la꞉doma꞉iba꞉le a꞉la꞉asula tagilaki, Yosa꞉ba꞉ aole Ba꞉nsamen e, ao nol o꞉lia꞉yo꞉ mo꞉iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Ka꞉ina꞉n hen a꞉namio꞉lo꞉ maiyo꞉wo꞉ alan fa꞉la꞉dowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ kalu nolo꞉ ma꞉no꞉ kililia꞉ni Isib a꞉na ha꞉nabiki, Isolaela꞉ insiso꞉iyo꞉lo꞉ egele a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ho꞉len a꞉namio꞉ Yosa꞉b e Isib amio꞉ gamani misa꞉ iliki, Isib kaluka꞉isale ma꞉no꞉lo꞉ dia꞉yab o꞉mo꞉lo꞉ kililia꞉seno꞉ e ko꞉lo꞉ dofo꞉len. A꞉la꞉fo꞉ko꞉lo꞉ Yosa꞉ba꞉ ao iyo꞉ elo꞉wa fa꞉la꞉dowakiyo꞉, iyo꞉ Yosa꞉ba꞉ milifa gulalu siliki misa꞉fu ali. ");
INSERT INTO bco_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yosa꞉b eyo꞉ ene ao ilo꞉b a꞉la꞉bo꞉ fanda ba꞉ba꞉ ko꞉sega, eyo꞉ ao iyo꞉ mo꞉asulo꞉ ilikilo꞉ dimidan au, eyo꞉ towo꞉ imo꞉wo꞉ halale sa꞉lakiyo꞉, “Kalu gi we o꞉bamida꞉ a꞉la꞉ta꞉ga꞉ mio꞉wo꞉?” A꞉la꞉dabu ba꞉dabiki iliyo꞉ a꞉la꞉sio꞉, “Nio꞉ Ka꞉ina꞉n hena a꞉la꞉ta꞉ga꞉ ma꞉no꞉ kililia꞉ni mio꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yosa꞉b eyo꞉ ao ilo꞉b a꞉la꞉bo꞉ asulo꞉ ko꞉sega ao i a꞉ma꞉yo꞉ we Yosa꞉b a꞉la꞉bo꞉ mo꞉ele ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Yosa꞉b eyo꞉ enedo꞉ tamin amilo꞉ ofolo꞉ ba꞉ba꞉ a꞉no꞉ a꞉asula꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ bo꞉bo꞉lema꞉ni mio꞉ka! Gio꞉ amisa꞉n ko꞉li ko꞉lilo꞉ wenamio꞉ halaido꞉lo꞉ mo꞉a꞉lab a꞉no꞉ ko꞉lo꞉ bo꞉bo꞉lema꞉ni mio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Yosa꞉b eyo꞉ a꞉la꞉sa꞉labiki, ao i a꞉ma꞉yo꞉ a꞉ma꞉la꞉ sa꞉laki, “A, kalu alan, ni mio꞉ we o꞉ngo꞉ma. Nio꞉ gi ha꞉ga dowaki, ma꞉no꞉ gilo꞉ we nilo꞉ kililia꞉ni mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nio꞉ kalu imilig noma꞉ so꞉wa i ko꞉lo꞉, nio꞉ bo꞉bo꞉lema꞉niki mio꞉ma. Nio꞉ to hendelelo꞉ sa꞉lan kalu ko꞉lo꞉ mio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","A꞉la꞉sa꞉labiki Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “A, o꞉ngo꞉ma. Gio꞉ amisa꞉n wenamio꞉ halaido꞉lo꞉ mo꞉a꞉lab a꞉no꞉ ko꞉lo꞉ bo꞉bo꞉lema꞉ni mio꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ko꞉sega iliyo꞉ a꞉la꞉sio꞉, “Nio꞉ Ka꞉ina꞉n kalu imilig noma꞉ sa꞉la꞉la꞉ ko꞉lo꞉, so꞉lo꞉ nio꞉ kugula꞉fo꞉ ko꞉sega nao tifo꞉ do o꞉lia꞉ o꞉sab a꞉la꞉ta꞉ga꞉ nao nowo꞉ kelege dowo꞉.” ");
INSERT INTO bco_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","15","A꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, Yosa꞉b eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gimo꞉wo꞉ o꞉ma sio꞉ ko꞉lo꞉, niyo꞉ gio꞉ bo꞉bo꞉lema꞉ni mio꞉lo꞉b a꞉la꞉asulo꞉. A꞉la꞉fo꞉ko꞉lo꞉ to gililo꞉ sa꞉lab ko hendelelo꞉b a꞉la꞉do꞉ nilo꞉ ele ba꞉ba꞉no꞉wo꞉ we. Fa꞉lo꞉wa꞉ wiya a꞉la꞉ta꞉ga꞉yo꞉ niyo꞉ to we gimo꞉wo꞉ dinali so꞉lo꞉l. Giliyo꞉ gao tifo꞉ wenamio꞉ mo꞉tililia꞉ mio꞉lo꞉biki, gio꞉ hen we mo꞉ta꞉fo꞉ ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","A꞉la꞉fo꞉ko꞉lo꞉ gao tif a꞉no꞉ wena tililia꞉ mena꞉ki, gio꞉ imilig nowo꞉ a꞉ma꞉la꞉ iliga꞉takiyo꞉, nolo꞉ dibolo a wenaka mesa꞉ib. To gililo꞉ sa꞉lab a꞉no꞉ hendele sa꞉lab a꞉la꞉asuluma꞉no꞉ ko꞉lo꞉ a꞉la꞉dimidama. Ko꞉sega gio꞉ ne dikido꞉lalega, gio꞉ hendele bo꞉bo꞉lema꞉ni mio꞉ a꞉la꞉asuluma꞉no꞉. Fa꞉lo꞉wa꞉ wiya a꞉la꞉ta꞉ga꞉yo꞉, niyo꞉ gimo꞉wo꞉ dinali saeto꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Yosa꞉b eyo꞉ towo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, i a꞉no꞉ ho꞉len otaleno꞉ dibolo aya mesea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ho꞉len otaleno꞉ dowabikiyo꞉, Yosa꞉b eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Nelo꞉ Godeyo꞉ tagilaki, e ha꞉ga dowa꞉sen kalu ko꞉lo꞉, gio꞉ nilo꞉ to sa꞉lab a꞉no꞉ dimidalega, gio꞉ o꞉li mesea꞉ki ta꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Gio꞉ to hendelelo꞉ sa꞉lan kalulalega, gao imilise nowo꞉ dibolo a wenaka ta꞉ta꞉ga꞉, gio꞉ ma꞉no꞉wo꞉ dia꞉sa꞉ga꞉, a꞉ma꞉la꞉ go꞉no꞉n so꞉lo꞉lo꞉wa ma꞉no꞉wo꞉ maiya꞉ki dia꞉ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","A꞉la꞉ta꞉ga꞉yo꞉, gio꞉ a꞉ma꞉la꞉ yakiyo꞉, gao tif a꞉no꞉ nelo꞉ wena tililia꞉ ya꞉bi. Gio꞉ a꞉la꞉dimidalega, gililo꞉ to sio꞉ a꞉no꞉ hendele a꞉la꞉li widalikiyo꞉, gio꞉ mo꞉soma꞉ib.” Iliyo꞉ Yosa꞉b elo꞉ sio꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, “niliyo꞉ a꞉la꞉dimidama꞉no꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Iliyo꞉ egele nenelakiyo꞉ a꞉la꞉sio꞉, “Nili naomo꞉lo꞉ hala dimido꞉ a꞉na ilikiyo꞉, o꞉go꞉ nimo꞉wo꞉lo꞉ wa꞉deab. Mo꞉wo꞉ niliyo꞉ emo꞉wo꞉ hida꞉yo꞉ dimiabikiyo꞉, e asuwa꞉foma꞉ki nimo꞉lo꞉ ha꞉nolo sio꞉ a꞉no꞉ niliyo꞉ mo꞉dabu. O꞉gdo꞉ hida꞉yo꞉ nilo꞉ amio꞉ fa꞉la꞉dowab we a꞉na gab.” ");
INSERT INTO bco_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Iliyo꞉ a꞉la꞉nenela꞉likiyo꞉, Luben eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ so꞉wa a꞉no꞉ mogagabena꞉ki, gimo꞉wo꞉ towo꞉ sio꞉ ko꞉sega, giliyo꞉ ni towo꞉ mo꞉dabu. A꞉la꞉go꞉ko꞉lo꞉ o꞉go꞉ nio꞉ e sowo꞉ a꞉ma꞉ wa꞉l ko꞉lo꞉ dio꞉l” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yosa꞉b eyo꞉ ao imo꞉ sa꞉lakiyo꞉, eyo꞉ Isib to sa꞉labiki, tolo꞉ nodo sa꞉ma꞉no꞉wa꞉yo꞉ Hibulu to nodola sio꞉ ko꞉lo꞉, to ilido꞉ nenelab a꞉no꞉ Yosa꞉b e da꞉dab a꞉la꞉bo꞉ iyo꞉ mo꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yosa꞉b e to a꞉no꞉ da꞉da꞉la꞉ga꞉yo꞉, e iyo꞉ ta꞉ta꞉ga꞉ ha꞉na꞉ga꞉ ya꞉lo꞉. E ya꞉liga꞉ta꞉ga꞉ a꞉ma꞉la꞉ ya꞉ga꞉, towo꞉ imo꞉wo꞉ wa꞉ka a꞉kudu sio꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ Simeono꞉ tililia꞉ ya꞉sa꞉ga꞉, ao ima꞉ siwa꞉l amio꞉ melo꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yosa꞉b eyo꞉ ene nanog kalumo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ masi ilido꞉wo꞉ dia꞉sa꞉ga꞉, ma꞉no꞉ disa꞉la꞉la꞉ga꞉ wa꞉li alita꞉ga꞉yo꞉, silba mole ilido꞉ ma꞉no꞉lo꞉ kililia꞉ni mio꞉ a꞉no꞉ a꞉ma꞉la꞉ masi usa disa꞉ alifela꞉bi. A꞉la꞉ta꞉ga꞉ iyo꞉ hena꞉ usa ha꞉nakilo꞉ ma꞉no꞉ na꞉i ha꞉na꞉no꞉wo꞉lo꞉ aloba꞉da꞉sa꞉ga꞉ dimia꞉bi.” Yosa꞉b elo꞉ dinali sa꞉lab aumbo꞉, ene nanog kaluwa꞉yo꞉ a꞉la꞉dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","A꞉la꞉dimida꞉sa꞉ga꞉, iliyo꞉ masi ma꞉ndo꞉ disa꞉ a꞉no꞉ donki wa꞉la dila꞉sa꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Iyo꞉ ha꞉na꞉ga꞉, ilo꞉ alima꞉no꞉wa fa꞉la꞉dota꞉ga꞉yo꞉, ao imilig noma꞉yo꞉ ene donkimo꞉ ma꞉no꞉ dimia꞉niki, masi ko꞉lo꞉ silimelo꞉ a꞉no꞉ fagelaki ba꞉ba꞉yo꞉, ene ma꞉no꞉lo꞉ kilili mole a꞉no꞉ meya delena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Eyo꞉ ba꞉da꞉ga꞉yo꞉, ao imo꞉wo꞉ a꞉la꞉sio꞉, “Mole nilo꞉wo꞉ masiya a꞉ma꞉la꞉ disalifa꞉ welo꞉ka꞉.” Iyo꞉ to a꞉no꞉ da꞉dakiyo꞉, mologa꞉ta꞉ga꞉ tagila bibitodaki, egelebo꞉ a꞉la꞉nenelo꞉, “Gode eyo꞉ nimo꞉wo꞉ waga dimidaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","30","Iyo꞉ Ka꞉ina꞉n hena ha꞉na꞉sa꞉ga꞉ Ya꞉kobdo꞉wa fa꞉la꞉dowakiyo꞉, kelego꞉ ilo꞉ amilo꞉ fa꞉la꞉dowo꞉ a꞉no꞉ iyamo꞉wo꞉ tambo malolo꞉ meaki a꞉la꞉sio꞉, “Isibdo꞉ bo꞉fo꞉lowan kaluwa꞉yo꞉ nimo꞉wo꞉ halale sa꞉laki, nio꞉ ili heno꞉ bo꞉bo꞉lema꞉ni mio꞉lo꞉b a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","32","Ko꞉sega niliyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ‘Nio꞉ bo꞉bo꞉lema꞉ni mio꞉ma. Nio꞉ to hendelelo꞉ sa꞉lan kalu ko꞉lo꞉ mio꞉. Nio꞉ so꞉wa kugula꞉fo꞉ ko꞉lo꞉ kalu imilig noma꞉ sa꞉la꞉la꞉ ko꞉sega, nao nowo꞉ kelege dowo꞉ a꞉la꞉ta꞉ga꞉ nao tifo꞉ do o꞉lia꞉ Ka꞉ina꞉n hena o꞉sab.’ ");
INSERT INTO bco_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Niliyo꞉ a꞉la꞉so꞉lo꞉likiyo꞉, Isib hendo꞉ bo꞉fo꞉lowan kalu alan a꞉ma꞉yo꞉ nimo꞉wo꞉ a꞉la꞉sio꞉, ‘To gililo꞉ sa꞉labo꞉ hendele sa꞉lab a꞉la꞉asuluma꞉niki, gao imilig nowo꞉ nelo꞉wa ta꞉ta꞉ga꞉, gio꞉ ma꞉no꞉wo꞉ dia꞉sa꞉ga꞉, a꞉ma꞉la꞉ go꞉no꞉n so꞉lo꞉ maiyo꞉ sab a꞉no꞉ maiya꞉ki dia꞉ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","A꞉la꞉ta꞉ga꞉ gio꞉ a꞉ma꞉la꞉ yakiyo꞉, gao tif a꞉no꞉ nelo꞉ wena tililia꞉ ya꞉bi. Giliyo꞉ a꞉la꞉dimidalega, gio꞉ bo꞉bo꞉lema꞉ni mio꞉ kalumalo꞉b a꞉la꞉asula꞉sa꞉ga꞉, gao dibolo amilo꞉ sen a꞉no꞉ a꞉ma꞉la꞉ ginibo꞉ sili alita꞉ga꞉, hen wenamio꞉ gio꞉ o꞉lika ya꞉liki ma꞉no꞉wo꞉ kililia꞉mela꞉ib.’” Iliyo꞉ iyamo꞉wo꞉ a꞉la꞉malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","A꞉la꞉ta꞉ga꞉yo꞉ iliyo꞉ masi ma꞉no꞉lo꞉ disa꞉ a꞉no꞉ kolodo꞉ alifela꞉i ane amio꞉, inin moleyo꞉ masi ililo꞉wa disalifelo꞉wa ba꞉ba꞉. Mole a꞉ma꞉la꞉lo꞉ disa꞉ a꞉no꞉ iyo꞉lo꞉ ba꞉ba꞉, a꞉la꞉ta꞉ga꞉ iyayo꞉lo꞉ ba꞉ba꞉ ko꞉lo꞉, iyo꞉ tambo tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Iyaya꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “So꞉wa nilo꞉wo꞉ gili tililia꞉ ha꞉na꞉ga꞉ kelegela꞉sen. Yosa꞉bo꞉ kelege dowo꞉. Simeono꞉lo꞉ kelege dowab ko꞉lo꞉, o꞉go꞉ giliyo꞉ Ba꞉nsameno꞉ tililia꞉ ha꞉na꞉no꞉ asulab. Hida꞉yo꞉ mogago꞉ we nelo꞉wa fa꞉la꞉dowab.” ");
INSERT INTO bco_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","A꞉la꞉sa꞉labiki Luben eyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ Ba꞉nsameno꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉yo꞉, a꞉ma꞉la꞉yo꞉ mada tililia꞉ mia꞉no꞉ ko꞉lo꞉, giyo꞉ nemo꞉ bo꞉fo꞉melea꞉ki ta꞉ta꞉bi. Niyo꞉ e a꞉ma꞉la꞉yo꞉ gelo꞉ amio꞉ mo꞉tililia꞉ yalega, ni so꞉wa a꞉la꞉ a꞉no꞉ giyo꞉ o꞉li sanala꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Luben eyo꞉ a꞉la꞉dinali saefa꞉ ko꞉sega, Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Ni so꞉wayo꞉ ge o꞉lia꞉yo꞉ hamana꞉kiyo꞉ mo꞉iliga꞉fa꞉no꞉. Mo꞉wo꞉ ene aoleyo꞉ sowo꞉ ko꞉lo꞉, e ina꞉li a꞉lab. Ne anaso꞉ dowo꞉ ko꞉lo꞉, gilo꞉ Isibdo꞉ tililia꞉ ha꞉nab a꞉namio꞉ hida꞉yo꞉ nowo꞉ eyamio꞉ fa꞉la꞉dowalega, giyo꞉ ne nofolo꞉ alan dima꞉ki dimia꞉ib ko꞉lo꞉ ne sowakiyo꞉, dane ane hen a꞉na ha꞉na꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Ka꞉ina꞉n hen a꞉namio꞉ molofayo꞉ alan dowaki, ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉ma dowo꞉ ko꞉lo꞉, iliyo꞉ ma꞉no꞉ Isibdo꞉ dia꞉mio꞉ a꞉no꞉ kedetabiki, Ya꞉kob eyo꞉ insiso꞉imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ Isib a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, ma꞉no꞉ ma꞉no꞉ nolo꞉ wa꞉ka kililia꞉ni hamana.” ");
INSERT INTO bco_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Ko꞉sega Yuda eyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “Isib bo꞉fo꞉lowan kaluwa꞉yo꞉ nimo꞉wo꞉ hagugu sa꞉lakiyo꞉ a꞉la꞉dinali saefa꞉, ‘Gio꞉ a꞉ma꞉la꞉ yakiyo꞉, gao tif a꞉no꞉ mo꞉tililia꞉ yalega, gio꞉ nelo꞉ amio꞉ mo꞉mena꞉ki ka꞉ma꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Isibdo꞉ bo꞉fo꞉lowana꞉yo꞉ a꞉la꞉sio꞉ ko꞉lo꞉, giyo꞉ Ba꞉nsameno꞉ ni o꞉lia꞉ hamana꞉ki iliga꞉talega, niliyo꞉ ma꞉no꞉ gilo꞉wo꞉ kililia꞉ni ha꞉na꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Ko꞉sega giyo꞉ nao tifko mo꞉hamana a꞉lalega, nio꞉ mo꞉ha꞉na꞉no꞉. Mo꞉wo꞉ Isibdo꞉ bo꞉fo꞉lowan kaluwa꞉yo꞉ a꞉la꞉sio꞉, ‘Gio꞉ gao tif a꞉no꞉ mo꞉tililia꞉ yalega, gio꞉ nelo꞉ amio꞉ mo꞉mena꞉ki ka꞉ma꞉no꞉’ eyo꞉ a꞉la꞉sio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Yuda eyo꞉ a꞉la꞉sa꞉labiki, Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Giliyo꞉ Isibdo꞉ bo꞉fo꞉lowan kalumo꞉ sa꞉lakilo꞉, gao nowo꞉ o꞉sab a꞉la꞉do꞉ sio꞉ a꞉ma꞉ ilikiyo꞉ hida꞉yo꞉wo꞉ nemo꞉ dimi ko꞉lo꞉ giliyo꞉ waga asulaki sio꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","A꞉la꞉dabu ba꞉dabiki, ao i a꞉ma꞉yo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Eyo꞉ nili so꞉lo꞉wo꞉ dinafa dabu kedakiyo꞉ a꞉la꞉sio꞉, ‘Go꞉lo꞉ o꞉saba?’ A꞉la꞉ta꞉ga꞉ ‘Gao nowo꞉ o꞉saba?’ a꞉la꞉li dabu kedo꞉ ko꞉lo꞉, niliyo꞉ a꞉na sio꞉. Niliyo꞉ gaowo꞉ tililia꞉ ya꞉bi a꞉la꞉do꞉ sa꞉ma꞉nigab a꞉no꞉ babale dowaki sio꞉.” ");
INSERT INTO bco_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","A꞉la꞉ta꞉ga꞉ Yuda eyo꞉ iya Isolael emo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ Ba꞉nsameno꞉ ni o꞉lia꞉ iliga꞉foma. A꞉la꞉dimidalega so꞉wagalin nililo꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ gelo꞉ mo꞉sowaki o꞉mela꞉niki, nio꞉ ma꞉no꞉wo꞉ kililia꞉ni ha꞉na꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","So꞉wako no꞉no꞉n bo꞉fo꞉mela꞉no꞉ ko꞉lo꞉, niyo꞉ so꞉wako gilo꞉ amio꞉ a꞉ma꞉la꞉bo꞉ mo꞉tililia꞉ yalega, hida꞉yo꞉ a꞉no꞉ ho꞉leno꞉ tambo ne o꞉lia꞉ dofo꞉ ha꞉na꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nio꞉ to we nenela꞉li ha꞉nakiyo꞉ ho꞉leno꞉ sambowo꞉ mo꞉walai kibo꞉bowo꞉, nio꞉ Isib hen a꞉namio꞉ a꞉la꞉gali ha꞉na꞉sa꞉ga꞉ mio꞉wa domabe.” Yuda eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","A꞉la꞉ta꞉ga꞉ Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Gio꞉ Ba꞉nsamen o꞉lia꞉ hendele ha꞉nalega, giliyo꞉ a꞉la꞉dimida꞉bi. Hen wenamilo꞉ boba kelego꞉ nafaleyo꞉, wa ho꞉no꞉lo꞉, kola꞉ ho꞉no꞉lo꞉, i fo nan nafa a꞉no꞉lo꞉, i mak mundo꞉ nafa a꞉no꞉lo꞉ dia꞉b a꞉la꞉ta꞉ga꞉ kalu o꞉mo꞉ dimia꞉ni, masiya disa꞉la꞉sa꞉ga꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","A꞉la꞉ta꞉ga꞉ mole ilido꞉ gili masi me amilo꞉ disa꞉la꞉sa꞉ga꞉, a꞉ma꞉la꞉do꞉ iliga꞉fo꞉ a꞉no꞉, iyo꞉ ga꞉lilaki go꞉wa꞉le babalab ko꞉lo꞉, gio꞉ o꞉go꞉ mole a꞉no꞉ a꞉ma꞉la꞉ dia꞉ha꞉nakiyo꞉, ma꞉no꞉ wa꞉kabilo꞉ kililia꞉no꞉ mole a꞉no꞉lo꞉ dia꞉ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","A꞉la꞉ta꞉ga꞉ giliyo꞉ gaowo꞉lo꞉ tililia꞉ga꞉, Isibdo꞉ bo꞉fo꞉lowan elo꞉wa fa꞉la꞉doma꞉ hamana. ");
INSERT INTO bco_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Isibdo꞉ bo꞉fo꞉lowan kaluwa꞉yo꞉ gimo꞉wo꞉ alan sagalakiyo꞉, gao Simeon o꞉lia꞉ Ba꞉nsamen o꞉lia꞉yo꞉ a꞉ma꞉la꞉ gi o꞉lia꞉ iliga꞉foma꞉ki, niyo꞉ Gode Halaido꞉lo꞉ A꞉lab o꞉mo꞉wo꞉ dulugu sa꞉ma꞉nigo꞉l. Ni so꞉wayo꞉ tambo soma꞉no꞉ a꞉lalega, a꞉la꞉ka fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉. Gode eyo꞉ so꞉wa nilo꞉wo꞉ tambo sulu ha꞉na꞉melea꞉ki asulalega, niyo꞉ o꞉li a꞉la꞉asuluma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Ya꞉kob eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, ao iyo꞉ boba kelego꞉ o꞉lia꞉ mole a꞉la꞉ a꞉no꞉lia꞉yo꞉ dia꞉sa꞉ga꞉yo꞉, Ba꞉nsameno꞉ tililia꞉ ha꞉na꞉ga꞉, Isib a꞉na fa꞉la꞉dowakiyo꞉, iyo꞉ Yosa꞉ba꞉ milifa kagayo꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yosa꞉b eyo꞉ Ba꞉nsamen o꞉lia꞉ ao o꞉lia꞉yo꞉ ba꞉da꞉ga꞉yo꞉, ene alo꞉ bo꞉fo꞉lowan kalumo꞉wo꞉ a꞉la꞉sio꞉, “Kalu i we ni a usa tililia꞉ mena. Iyo꞉ o꞉g disiyo꞉ ma꞉no꞉wo꞉ ne o꞉lia꞉ siliki ma꞉no꞉ ko꞉lo꞉, no꞉ nowo꞉ sa꞉nda꞉sa꞉ga꞉ dimidalia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Nanog kaluwa꞉yo꞉ Yosa꞉b elo꞉ sio꞉ au dimidaki, ao iyo꞉ Yosa꞉ba꞉ ene a usa tililia꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ao iyo꞉ Yosa꞉ba꞉ ene aya tililia꞉ ha꞉nab amio꞉, iyo꞉ tagilaki a꞉la꞉sio꞉, “Nio꞉ a wenamilo꞉ tililia꞉ ha꞉nab wema꞉yo꞉, iliyo꞉ tamin amilo꞉ mole ko꞉lo꞉ nili masi amilo꞉ a꞉ma꞉la꞉ disa꞉ a꞉no꞉ asulakigab. Iliyo꞉ nio꞉ inin nanog kalu doma꞉ki, iliyo꞉ nio꞉ banagalia꞉taki, yame tandea꞉sa꞉ga꞉ ta꞉lia꞉nigab. A꞉la꞉ta꞉ga꞉ nili donkiyo꞉lo꞉ ili dia꞉nigab.” A꞉la꞉asulakiyo꞉ iyo꞉ tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","21","A꞉la꞉go꞉ko꞉lo꞉ iyo꞉ Yosa꞉ba꞉ a toga꞉ meya fa꞉la꞉dowakiyo꞉, alo꞉ bo꞉fo꞉lowan kalumo꞉wo꞉ a꞉la꞉sio꞉, “Kalu alan, nio꞉ tamin amio꞉ ma꞉no꞉lo꞉ kililia꞉ni ya꞉ga꞉ a꞉ma꞉la꞉ ha꞉nakiyo꞉, hena꞉ usa ali amio꞉, masi meyo꞉ tambo koda꞉sa꞉ga꞉ ba꞉ba꞉ amio꞉, mole ma꞉no꞉lo꞉ kilili a꞉no꞉ tambo masi meya disalifelo꞉wa ba꞉ba꞉ ko꞉lo꞉, o꞉go꞉ mole a꞉no꞉ a꞉ma꞉la꞉ dia꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","A꞉la꞉ta꞉ga꞉ wa꞉kabilo꞉ ma꞉ndo꞉ kililia꞉no꞉ mole nolo꞉ a꞉dia꞉mio꞉. Ko꞉sega tamin amilo꞉ nili masi amilo꞉ mole a꞉ma꞉la꞉ disalifelo꞉ a꞉no꞉ abe disa꞉ya꞉le nio꞉ babalab.” ");
INSERT INTO bco_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Iliyo꞉ a꞉la꞉sa꞉labiki, eyo꞉ a꞉la꞉sio꞉, “Gio꞉ tagila꞉so꞉bo. Ma꞉no꞉lo꞉ kilili mole a꞉no꞉ niyo꞉ di ko꞉lo꞉, gili Gode o꞉lia꞉ ge ma꞉muwa꞉ Gode a꞉ma꞉yo꞉ gio꞉ asuwa꞉taki, mole nolo꞉ gili masiya disalifelo꞉lo꞉b.” Eyo꞉ towo꞉ a꞉la꞉sata꞉ga꞉yo꞉, Simeono꞉ ilo꞉wa tililia꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Eyo꞉ iyo꞉ Yosa꞉ba꞉ a usa tililia꞉ tina꞉ga꞉, gibo꞉ to꞉go꞉dema꞉ki, ho꞉no꞉ wasulia꞉ dia꞉tabiki, iliyo꞉ gibo꞉ a꞉na to꞉go꞉do꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ ili donkimo꞉ ma꞉no꞉wo꞉ a꞉na me. ");
INSERT INTO bco_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ao iyo꞉ Yosa꞉b o꞉lia꞉yo꞉ disilo꞉ ma꞉no꞉ ma꞉no꞉ sio꞉wo꞉ dabu ko꞉lo꞉, iliyo꞉ emo꞉lo꞉ boba dimia꞉no꞉ a꞉no꞉ ko꞉lo꞉ dimidali. ");
INSERT INTO bco_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yosa꞉b e aya a꞉ma꞉la꞉ yabikiyo꞉, boba kelego꞉ ililo꞉ dia꞉mio꞉ a꞉no꞉ emo꞉wo꞉ a꞉na dimiaki, iyo꞉ Yosa꞉ba꞉ milifa gulalu siliki misa꞉fu ali. ");
INSERT INTO bco_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ giyo꞉ o꞉li seya a꞉la꞉liki dabu ba꞉dakiyo꞉ a꞉la꞉sio꞉, “Tamin amio꞉ go꞉l sulo꞉ sa꞉lalo꞉ o꞉li saba?” ");
INSERT INTO bco_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","A꞉la꞉dabu ba꞉dabiki, iliyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “A꞉, e o꞉li sab.” A꞉la꞉sa꞉la꞉sa꞉ga꞉, iliyo꞉ Yosa꞉bo꞉ wabudaki, elo꞉wa gulalu siliki misa꞉fu ali. ");
INSERT INTO bco_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yosa꞉b eyo꞉ aole Ba꞉nsameno꞉ ba꞉da꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Tamin amilo꞉ gao tifka꞉ a꞉la꞉do꞉ nemo꞉lo꞉ sa꞉lalo꞉ weyo꞉?” A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ Ba꞉nsamenbo꞉wo꞉ a꞉la꞉sio꞉, “Ni so꞉wa ge, Gode eyo꞉ o꞉li tilidofo꞉melea꞉ki asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yosa꞉b eyo꞉ aoleyo꞉ ba꞉da꞉sa꞉ga꞉, e fo꞉g kagayaki ya꞉lima꞉no꞉ dowabiki, ao i a꞉no꞉ bo꞉e ta꞉ta꞉ga꞉, ene galala꞉ya ha꞉na꞉sa꞉ga꞉ ya꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","E ya꞉lisa꞉ga꞉yo꞉, migiyo꞉ ho꞉na꞉ hala꞉sa꞉ga꞉, a꞉ma꞉la꞉ ya꞉ga꞉ halale kagatakiyo꞉, nanog kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ma꞉no꞉ alobanama.” ");
INSERT INTO bco_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","A꞉la꞉sa꞉labiki iliyo꞉ ma꞉no꞉wo꞉ aloba꞉dakiyo꞉, Yosa꞉b elo꞉wo꞉ ina꞉li difa꞉. A꞉la꞉ta꞉ga꞉ ao i a꞉ma꞉lo꞉wo꞉ ko꞉li nowa difa꞉. A꞉la꞉ta꞉ga꞉ Isib kalu ililo꞉wo꞉lo꞉ nowa difa꞉. Mo꞉wo꞉ Isib kaluka꞉isaleyo꞉ Hibulu kalu o꞉lia꞉lo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ mada mo꞉bea꞉sen ko꞉lo꞉ ualo꞉ mo꞉nan. ");
INSERT INTO bco_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Nanog kalu eyo꞉ ao i a꞉no꞉ ina꞉li ina꞉lile a꞉la꞉mesea꞉ki da꞉feyo꞉ ko꞉lo꞉, ao iyo꞉ Yosa꞉ba꞉ milifa kandayakiyo꞉, ao wa꞉la꞉ba a꞉la꞉ta꞉ga꞉lo꞉ ta꞉i aneyo꞉ tifbo꞉ dimi. Ao iyo꞉ a꞉la꞉do꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ma꞉no꞉ ko꞉lo꞉ Yosa꞉b eno꞉ alobanaefa꞉ a꞉no꞉, iliyo꞉ dia꞉sa꞉ga꞉ ao i nolbo꞉ fo꞉fo꞉le mea꞉i ane. Ao i nolbo꞉wo꞉ dinali fo꞉fo꞉le me ko꞉sega Ba꞉nsamen emo꞉wo꞉ kalu bila꞉fo꞉wa꞉lo꞉ nan au fo꞉fo꞉la꞉sa꞉ga꞉ dimi. Iyo꞉ Yosa꞉b o꞉lia꞉ silikiyo꞉, ma꞉no꞉ o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ alan naki sagalo꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Iyo꞉ ma꞉no꞉wo꞉ na꞉sa꞉ga꞉yo꞉, Yosa꞉b eyo꞉ ene alo꞉ bo꞉fo꞉lowan kalumo꞉wo꞉ wo꞉no꞉lebo꞉ a꞉la꞉sio꞉, “Giyo꞉ ma꞉no꞉ ililo꞉ dia꞉ha꞉na꞉no꞉ o꞉leaumbo꞉, ini masiyo꞉ wa꞉li alifela꞉sa꞉ga꞉, ini moleyo꞉ a꞉ma꞉la꞉ masi meya disalifela꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","A꞉la꞉ta꞉ga꞉ ao tifa꞉ masi amio꞉, ene mole o꞉lia꞉ no꞉no꞉n silba kab a꞉no꞉lo꞉, ene masi meya disalita꞉bi,” a꞉la꞉sio꞉. Yosa꞉b elo꞉ sio꞉ aumbo꞉, ene nanog kaluwa꞉yo꞉ a꞉la꞉ka dimido꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kea꞉fo nulu ho꞉idabiki, ao i a꞉no꞉ ini donki o꞉lia꞉ hamana꞉ki iliga꞉tabiki iyo꞉ ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Amisa꞉no꞉ semo꞉ sadega꞉fo꞉ amio꞉, Yosa꞉b eyo꞉ ene alo꞉ bo꞉fo꞉lowan kalumo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ kalu i a꞉no꞉ kudu ha꞉na꞉sa꞉ga꞉ galiliakiyo꞉, imo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘Niliyo꞉ gimo꞉wo꞉ man nafa dimidaki sagale alifa꞉, ko꞉sega, gililo꞉ nimo꞉lo꞉ mogago꞉ dimido꞉wo꞉ mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ni misa꞉ kaluwa꞉ ene kab nafaleyo꞉ waga afale diyo꞉? Kab wema꞉yo꞉ ho꞉no꞉ a꞉na na꞉sen a꞉la꞉ta꞉ga꞉ kab wema꞉ halaido꞉ a꞉na ilikiyo꞉, eyo꞉ ho꞉le ba꞉dan. Man gililo꞉ we, mada hala dimido꞉.’” ");
INSERT INTO bco_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Yosa꞉b eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉ ko꞉lo꞉, kalu a꞉no꞉ ha꞉na꞉sa꞉ga꞉, iyo꞉ galilia꞉sa꞉ga꞉yo꞉, to a꞉no꞉ imo꞉wo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, iliyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Kalu alan, giyo꞉ to we waga asulaki sa꞉laya? To gilo꞉ sa꞉lab ko aumbo꞉, niliyo꞉ mada mo꞉dimida꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Dabuma. Nio꞉ Ka꞉ina꞉n a꞉la꞉ta꞉ga꞉ a꞉ma꞉la꞉ Isib wena yakiyo꞉, gililo꞉ mole ko꞉lo꞉ nili masi meya disa꞉ a꞉no꞉ a꞉ma꞉la꞉ ginibo꞉ dimia꞉niki dia꞉mio꞉. Ge a꞉no꞉ asulo꞉ ko꞉lo꞉, gi misa꞉ kaluwa꞉ silba, go꞉l kelego꞉ ayamilo꞉ da꞉lab a꞉no꞉ niliyo꞉ mada mo꞉afale dia꞉no꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ nili masi usamio꞉ kab a꞉no꞉ delena ba꞉dalega, giyo꞉ kalu kabdo꞉ disa꞉ a꞉no꞉ sana sowa꞉sa꞉ga꞉, nio꞉ gi madali nanog dian kalu doma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Iliyo꞉ a꞉la꞉sa꞉labiki, eyo꞉ a꞉la꞉sio꞉, “Gilo꞉ sa꞉lab au dimidama꞉no꞉, ko꞉sega kalu kabdo꞉ disa꞉ a꞉no꞉ko꞉ ni nanog kalu dia꞉no꞉ dowaki, nol gio꞉ ga꞉li ha꞉na꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","12","A꞉la꞉do꞉ sa꞉lab a꞉no꞉ ao iyo꞉ da꞉da꞉sa꞉ga꞉, iyo꞉ inin masiyo꞉ hena bo꞉bo꞉ge sagasela꞉sa꞉ga꞉ kolalifelabikiyo꞉, kalu a꞉ma꞉yo꞉ wa꞉la꞉ba a꞉la꞉ta꞉ga꞉lo꞉ keda꞉likilo꞉ aneyo꞉, Ba꞉nsamen elo꞉wa kedo꞉ amio꞉, kab a꞉no꞉ Ba꞉nsamena꞉ masiya delena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Ao iyo꞉ a꞉no꞉ ba꞉da꞉ga꞉yo꞉, iyo꞉ nofolaki, inin helebeso꞉g ko꞉lo꞉wo꞉ bidila꞉sa꞉ga꞉yo꞉, kelego꞉ ililo꞉wo꞉ donki wa꞉la dila꞉sa꞉ga꞉, a꞉ma꞉la꞉ Isib amisa꞉na ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yuda o꞉lia꞉ ene ao i o꞉lia꞉yo꞉ Yosa꞉ba꞉ aya fa꞉la꞉dowabikiyo꞉, Yosa꞉b e a ka o꞉sen ko꞉lo꞉, iyo꞉ elo꞉wa gumisi fufudo꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosa꞉b eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ o꞉b dimido꞉wo꞉? Kalu ne o꞉ngo꞉ dowab wema꞉yo꞉, kelego꞉ wo꞉no꞉ledo꞉ delen a꞉no꞉ ho꞉le ba꞉da꞉sen a꞉la꞉bo꞉ giyo꞉ mo꞉asulaya?” ");
INSERT INTO bco_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yosa꞉b eyo꞉ a꞉la꞉sa꞉labiki, Yuda eyo꞉ a꞉la꞉sio꞉, “Ni misa꞉ kalu, to nililo꞉ sa꞉ma꞉no꞉ nowo꞉ aundo꞉ma. Nio꞉ mogago꞉lo꞉ mo꞉dimido꞉ a꞉lakilo꞉ sa꞉ma꞉no꞉wo꞉ mada halaido꞉. Hendele, nililo꞉ hala dimida꞉sen a꞉no꞉ Gode eyo꞉ kalaba widab ko꞉lo꞉, kaluwa꞉ ene masi amilo꞉ kabdo꞉ delendo꞉ ba꞉ba꞉ a꞉no꞉lia꞉, nio꞉ tambo gi madali nanog dian kalu doma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Ko꞉sega Yosa꞉b eyo꞉ a꞉ma꞉la꞉ a꞉la꞉sio꞉, “Gilo꞉ sa꞉lab o꞉leaumbo꞉, niyo꞉ mada mo꞉dimidama꞉no꞉. Kalu masi amilo꞉ kabdo꞉ delen amilo꞉ ba꞉ba꞉ a꞉no꞉ko꞉ ni madali nanog dian kalu dowaki, nol gio꞉ go꞉ldo꞉wa ga꞉li ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","A꞉la꞉sa꞉labiki Yuda eyo꞉ Yosa꞉bdo꞉wa kagayaki a꞉la꞉sio꞉, “Ni misa꞉ kalu, halaido꞉ gilo꞉wo꞉ Fa꞉lo꞉wa꞉lo꞉ o꞉ngo꞉ ko꞉sega, niyo꞉ gemo꞉wo꞉ towo꞉ sa꞉ma꞉nigo꞉l ko꞉lo꞉, giyo꞉ nemo꞉wo꞉ gadia꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nio꞉ tamin amilo꞉ wilo꞉ mio꞉ amio꞉, giyo꞉ nimo꞉wo꞉ a꞉la꞉dabubadale, ‘Gio꞉ go꞉l o꞉lia꞉ gao nowo꞉lia꞉yo꞉ o꞉saba?’ ");
INSERT INTO bco_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","A꞉la꞉dabu ba꞉dalikiyo꞉, niliyo꞉ gemo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, ‘Do sulo꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ nao tif, dowa꞉lo꞉ anaso꞉ dowakilo꞉ sa꞉la꞉liyo꞉ o꞉sab. Ko꞉sega tif so꞉wa a꞉ma꞉ ene aoleyo꞉ sowo꞉ ko꞉lo꞉, anowa꞉lo꞉ sa꞉la꞉li imilise e o꞉sabiki, iyaya꞉yo꞉ e mada alan asula꞉sen’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Giyo꞉ to nilo꞉ sio꞉ a꞉no꞉ da꞉da꞉ga꞉yo꞉, giyo꞉ ‘Gao a꞉no꞉ nelo꞉ ba꞉ba꞉ni tililia꞉ ya꞉bi’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ko꞉sega niliyo꞉ gemo꞉wo꞉ a꞉la꞉sio꞉, ‘So꞉wa a꞉no꞉ iyayo꞉ mo꞉ta꞉fo꞉ ha꞉na꞉sen. E iyayo꞉ ta꞉fo꞉ ha꞉nalega, iyayo꞉ soma꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ko꞉sega gi sa꞉lakiyo꞉, ‘Gao tif a꞉no꞉ mo꞉tililia꞉ yalega, gio꞉ nelo꞉ amio꞉ mo꞉mena꞉ki, a꞉la꞉liki eleyo꞉ dia꞉fa꞉no꞉’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","A꞉la꞉fo꞉ko꞉lo꞉ nio꞉ a꞉ma꞉la꞉ dolo꞉wa ha꞉na꞉sa꞉ga꞉, gilo꞉ to sio꞉ o꞉leaumbo꞉ emo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“A꞉la꞉ta꞉ga꞉ dowa꞉yo꞉ a꞉la꞉sio꞉, ‘Gio꞉ a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, ma꞉no꞉ ha꞉lu nolo꞉ a꞉kililia꞉ni hamana.’ ");
INSERT INTO bco_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Ko꞉sega nio꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ‘Nao tif we ni o꞉lia꞉ mo꞉ha꞉nalega, Isibdo꞉ bo꞉fo꞉lowan kalu a꞉ma꞉yo꞉ nio꞉ mo꞉ba꞉ba꞉no꞉ a꞉la꞉sio꞉ ko꞉lo꞉, nao tif ko mo꞉ha꞉nalega nio꞉ a꞉ma꞉la꞉yo꞉ mo꞉ha꞉na꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","28","A꞉la꞉so꞉lo꞉liki, dowa꞉yo꞉ nimo꞉wo꞉ a꞉la꞉sio꞉, ‘Ni ga, Lesol eyo꞉ kalu so꞉wa a꞉la꞉ sa꞉la꞉li, gio꞉ a꞉no꞉ asulo꞉. So꞉wa nowo꞉ kelege dowab amio꞉, niyo꞉ “E no꞉ igo꞉la꞉sena꞉yo꞉ hendele gegedelia꞉gane,” a꞉la꞉asulo꞉ ko꞉lo꞉, e wa꞉kabiyo꞉ niyo꞉ mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","A꞉la꞉ta꞉ga꞉ ne anaso꞉ dowo꞉ ko꞉lo꞉, no꞉no꞉n so꞉wa tif ko꞉lo꞉ ne o꞉lia꞉lo꞉ a꞉lab welo꞉ giliyo꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉, hida꞉yo꞉ nowo꞉ eyamio꞉ fa꞉la꞉dowalega, giyo꞉ ne nofolo꞉ alan dima꞉ki dimia꞉ib ko꞉lo꞉ ne sowakiyo꞉, dane ane hen a꞉na ha꞉na꞉ib.’ Dowa꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉ dolo꞉ amio꞉ a꞉ma꞉la꞉yo꞉ mo꞉tililia꞉ga꞉ fa꞉la꞉dowalega, dowa꞉yo꞉ so꞉wa a꞉no꞉ mo꞉mio꞉lo꞉b a꞉la꞉asulakiyo꞉, e kele asulaki soma꞉ib. Mo꞉wo꞉ do o꞉lia꞉ so꞉wa we o꞉lia꞉yo꞉ mada kudo꞉ ko꞉lo꞉ so꞉wayo꞉ o꞉salikiyo꞉, dowo꞉lo꞉ o꞉mesa꞉ib. Ko꞉sega so꞉wa we sowalega, dowo꞉lo꞉ soma꞉ib. A꞉la꞉galikiyo꞉ niliyo꞉ do sulo꞉mo꞉wo꞉ nofolo꞉ alan dima꞉ki dimia꞉ib ko꞉lo꞉, e sowa꞉sa꞉ga꞉, dane ane hen a꞉na hamana꞉kiyo꞉, nili dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Mo꞉wo꞉ niyo꞉ domo꞉wo꞉ dinali sa꞉lakiyo꞉, ‘So꞉wa we niyo꞉ a꞉ma꞉la꞉yo꞉ mo꞉tililia꞉ yalega, mogago꞉ gemo꞉lo꞉ dimiab a꞉no꞉ ho꞉leno꞉ tambo ne o꞉lia꞉ dofo꞉ ha꞉na꞉mela꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Niyo꞉ domo꞉wo꞉ a꞉la꞉dinali sio꞉ ko꞉lo꞉, o꞉go꞉ giyo꞉ so꞉wa we sili alitaki, e ta꞉lian aumbo꞉ ne ko꞉lo꞉ gi nanog kalu doma꞉ki ta꞉foma. A꞉la꞉ta꞉ga꞉ giyo꞉ so꞉wa tif ko ao i o꞉lia꞉ iyalo꞉wa hamana꞉ki ta꞉ta꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mo꞉wo꞉ so꞉wa we ne o꞉lia꞉yo꞉ mo꞉ha꞉nalega, nelo꞉ mada mo꞉ha꞉na꞉no꞉. Nofolo꞉ alan dolo꞉ amilo꞉ fa꞉la꞉doma꞉ib a꞉no꞉ ba꞉ba꞉no꞉wo꞉ ne mada tagilab.” ");
INSERT INTO bco_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosa꞉b e fo꞉g kagalowaki, kaluka꞉isale kegeo꞉ a꞉ma꞉ siwa꞉l amio꞉ ya꞉li hagalema꞉no꞉ dowabiki, ene nanog kalumo꞉wo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale tambo ha꞉la꞉ya hamana꞉ki iliga꞉fo꞉ma,” a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ ene ao i a꞉no꞉ko꞉ e o꞉lia꞉ dotabiki, Yosa꞉b eyo꞉ we neka꞉ a꞉la꞉liki ao imo꞉wo꞉ kalaba fanda wido꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Yosa꞉b e a꞉la꞉bo꞉ wida꞉sa꞉ga꞉yo꞉, e halale ya꞉labikiyo꞉, Isib kaluka꞉isaleyo꞉ elo꞉ ya꞉lo꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉ sa꞉la꞉i aneyo꞉, Fa꞉lo꞉wa꞉ ayamilo꞉ sa꞉sen kaluka꞉isale iyo꞉lo꞉ dabu. ");
INSERT INTO bco_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosa꞉b eyo꞉ ao imo꞉wo꞉ a꞉la꞉sio꞉, “Ne Yosa꞉bka꞉! Ni dowo꞉ o꞉saba?” a꞉la꞉dabu ba꞉ba꞉. Ko꞉sega ao iyo꞉ e hendele fanda ba꞉dakiyo꞉, iyo꞉ iliga꞉sa꞉ga꞉ tagilaki, towo꞉ a꞉ma꞉la꞉bo꞉ mo꞉sa꞉ma꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","A꞉la꞉fo꞉ko꞉lo꞉ Yosa꞉b eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ nelo꞉ wena mena.” Iyo꞉ ma꞉uwo꞉wa ha꞉na꞉ga꞉ dowabiki, eyo꞉ a꞉la꞉sio꞉, “Ne gili gao Yosa꞉b. Giliyo꞉ ne moleya꞉ kilili ko꞉lo꞉, a꞉na ilikiyo꞉ ne Isib hen wenamio꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","A꞉la꞉go꞉ko꞉lo꞉ ne wena kililia꞉ga꞉ iliga꞉fo꞉ a꞉la꞉bo꞉, giliyo꞉ go꞉no꞉n a꞉ma꞉la꞉yo꞉ mo꞉gadiaki, kele asula꞉so꞉bo! Mo꞉wo꞉ kaluka꞉isaleya꞉ mela꞉no꞉wo꞉ tili doma꞉kiyo꞉, Gode eyo꞉ ne tamin wena iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Dona a꞉la꞉ us wenamio꞉ ma꞉no꞉wo꞉ mo꞉fa꞉la꞉ne ko꞉lo꞉, maiyo꞉wo꞉ alan dowab. Dona bila꞉fo꞉ nowo꞉ fa꞉la꞉dowalikiyo꞉, molofa alan dowaki, egelo꞉ amio꞉ eyo꞉ mo꞉gelalikiyo꞉, ma꞉no꞉wo꞉ mo꞉dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gode eyo꞉ so꞉lo꞉ gilo꞉wo꞉ alan asuwa꞉fa꞉no꞉ a꞉lakiyo꞉, gio꞉ daneliabena꞉ki, Gode eyo꞉ ne wena tamina iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","A꞉la꞉go꞉ko꞉lo꞉ giliyo꞉ ne wenami iliga꞉fo꞉ma. Ko꞉sega Gode eyo꞉ ne wena iliga꞉tabiki mio꞉. A꞉la꞉ta꞉ga꞉ Gode eyo꞉ ne Fa꞉lo꞉wa꞉ iya o꞉ngo꞉ ta꞉taki, Fa꞉lo꞉wa꞉ ayo꞉ a꞉la꞉ta꞉ga꞉ Isib heno꞉ tambo nemo꞉ bo꞉fo꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ a꞉ma꞉la꞉ bo꞉bo꞉ge ha꞉na꞉sa꞉ga꞉, dolo꞉wa fa꞉la꞉dowakiyo꞉ a꞉la꞉sa꞉la꞉bi, ‘Gi so꞉wa, Yosa꞉b eyo꞉ gemo꞉wo꞉ a꞉la꞉saga꞉fo꞉, “Gode eyo꞉ ne Isib heno꞉ nemo꞉ bo꞉fo꞉melea꞉ki ta꞉fo꞉ ko꞉lo꞉, giyo꞉ mo꞉amalaki, nelo꞉wa bo꞉e tigini ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gelo꞉, gi so꞉wayo꞉lo꞉, gi ma꞉muwo꞉lo꞉, no꞉ fofo꞉wo꞉lo꞉, gilo꞉ amilo꞉ a꞉lab a꞉no꞉ tambo nelo꞉ so꞉l aniba Gosen hen a꞉na mesa꞉ni ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Gio꞉ hen a꞉na salikiyo꞉, niyo꞉ bo꞉fo꞉mela꞉no꞉. Mo꞉wo꞉ dona bila꞉fo꞉ a꞉namilo꞉ ma꞉no꞉lo꞉ma dowakilo꞉ maiyo꞉ alan doma꞉ib a꞉no꞉ o꞉fa꞉la꞉doma꞉nigab ko꞉lo꞉, gelo꞉ gi so꞉lo꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ gilo꞉ amilo꞉ a꞉lab a꞉no꞉ tambo maiyo꞉wo꞉ mo꞉doma꞉ki, niyo꞉ bo꞉fo꞉mela꞉no꞉.” Giliyo꞉ domo꞉wo꞉ a꞉la꞉sa꞉la꞉bi.’” ");
INSERT INTO bco_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","13","Yosa꞉b eyo꞉ a꞉kudu sa꞉laki a꞉la꞉sio꞉, “O꞉go꞉ ginin siya꞉yo꞉ ne Yosa꞉bo꞉lo꞉b a꞉la꞉bo꞉ fanda ba꞉dab. A꞉la꞉ta꞉ga꞉ naole Ba꞉nsamen gelo꞉ ne Yosa꞉bo꞉lo꞉b a꞉la꞉bo꞉ fanda ba꞉dab ko꞉lo꞉, gio꞉ ha꞉na꞉ga꞉yo꞉ ne Isib amilo꞉ bo꞉fo꞉lowan kalu dowo꞉ a꞉no꞉lia꞉, gili siya꞉lo꞉ ba꞉dab a꞉no꞉ tambo domo꞉wo꞉ fanda sa꞉la꞉sa꞉ga꞉, e bo꞉bo꞉ge wena tililia꞉ ya꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yosa꞉b eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, aole Ba꞉nsameno꞉ fafula꞉fo꞉liki a꞉la꞉yo꞉ ya꞉fodo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ ao i nolo꞉lo꞉ mimilaki, a꞉na ya꞉fodo꞉. A꞉ma꞉ fa꞉s amio꞉ ao iyo꞉ Yosa꞉b o꞉lia꞉yo꞉ a꞉na tola꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","17","Fa꞉lo꞉ o꞉lia꞉ kaluka꞉isale ene ayamilo꞉ sa꞉sen i o꞉lia꞉ma꞉yo꞉, “Yosa꞉ba꞉ ene ao iyo꞉ mio꞉ka꞉” a꞉la꞉bo꞉ da꞉da꞉sa꞉ga꞉yo꞉, Fa꞉lo꞉ o꞉lia꞉ ene nanog kaluka꞉isale iyo꞉ mada sagalaki, Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ gao imo꞉wo꞉ a꞉la꞉saga꞉ta꞉bi, ‘Giliyo꞉ we au dimidama. Gio꞉ kelego꞉lo꞉ dia꞉ha꞉na꞉no꞉ no꞉ a꞉no꞉ dimidalia꞉ga꞉, Ka꞉ina꞉n hen a꞉na a꞉ma꞉la꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","A꞉na fa꞉la꞉dowakiyo꞉, gili go꞉lo꞉lo꞉, gili so꞉lo꞉wo꞉lo꞉ nelo꞉ wena tililia꞉ga꞉ ya꞉bi. Gio꞉ wena fa꞉la꞉dowalikiyo꞉, niyo꞉ Isib hen wenamio꞉ hen nafale nowo꞉ gimo꞉ dimia꞉no꞉ ko꞉lo꞉, giliyo꞉ ma꞉no꞉ nafa hen wenamilo꞉ fa꞉la꞉dowa꞉sen a꞉no꞉ na꞉mela꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","A꞉la꞉ta꞉ga꞉ Yosa꞉b giyo꞉ to welo꞉ a꞉la꞉saga꞉ta꞉bi. ‘Giliyo꞉ we au dimidama. Donkiya꞉lo꞉ i fofodo꞉ susululia꞉ ha꞉na꞉sen Isib hen wilo꞉ da꞉lab a꞉no꞉ giliyo꞉ nolo꞉ Ka꞉ina꞉n hen a꞉na dia꞉ha꞉na꞉sa꞉ga꞉yo꞉, gili so꞉wagalin o꞉lia꞉, ga o꞉lia꞉yo꞉, a꞉la꞉ta꞉ga꞉ go꞉lo꞉lo꞉ iyo꞉ tambo i fofodo꞉ wa꞉l a꞉na kandaya꞉sa꞉ga꞉, a꞉ma꞉la꞉ ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Isib hen amilo꞉ kelego꞉ nafale da꞉lab we niyo꞉ gimo꞉ dimia꞉no꞉ ko꞉lo꞉, kelego꞉ ginido꞉ Ka꞉ina꞉n hen a꞉namilo꞉ da꞉lab a꞉no꞉, giliyo꞉ ka ta꞉fo꞉ ya꞉bi.’ Giyo꞉ gao imo꞉wo꞉ a꞉la꞉sa꞉la꞉bi” Fa꞉lo꞉ eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Fa꞉lo꞉ elo꞉ sio꞉ au, Isolaela꞉ insiso꞉ima꞉yo꞉ a꞉la꞉dimido꞉. Yosa꞉b eyo꞉ Fa꞉lo꞉wa꞉ towo꞉ kudu ha꞉naki, donkiya꞉lo꞉ i fofodo꞉ susululia꞉ ha꞉na꞉sen a꞉no꞉ imo꞉ dimia꞉sa꞉ga꞉, iyo꞉ toga ha꞉na꞉ga꞉ ha꞉nakilo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ a꞉na dimi. ");
INSERT INTO bco_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","A꞉la꞉ta꞉ga꞉ eyo꞉ ao imo꞉wo꞉ helebeso꞉g ho꞉gi ka꞉ma꞉no꞉wo꞉ imilida꞉la꞉ sagalifa꞉. Ko꞉sega eyo꞉ silba mole 300 a꞉la꞉fo꞉ o꞉lia꞉ helebeso꞉g ho꞉gi ka꞉ma꞉no꞉wo꞉ bila꞉fo꞉ o꞉lia꞉yo꞉ Ba꞉nsamen emo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ boba kelego꞉ iyamo꞉lo꞉ dimina꞉kilo꞉ iliga꞉fo꞉wo꞉ we. Isib hen amilo꞉ kelego꞉ nafaleyo꞉ donki do꞉la꞉fo꞉ wa꞉l a꞉na dila꞉la꞉ga꞉ a꞉na iliga꞉fo꞉. A꞉la꞉ta꞉ga꞉ donki mala do꞉la꞉fo꞉ wa꞉l a꞉namio꞉ ma꞉no꞉wo꞉ iyayo꞉ a꞉ma꞉la꞉ Isib hena yaki maiya꞉ki, a꞉na dila꞉sa꞉ga꞉ iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","A꞉la꞉dimida꞉sa꞉ga꞉, Yosa꞉b eyo꞉ ene ao iyo꞉ a꞉ma꞉la꞉ iliga꞉taki a꞉la꞉sio꞉, “Gio꞉ toga ha꞉nakiyo꞉, towa꞉yo꞉ kega꞉likiyo꞉ ha꞉na꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","A꞉la꞉fo꞉ko꞉lo꞉ ao iyo꞉ Isib heno꞉ ta꞉ta꞉sa꞉ga꞉, Ka꞉ina꞉n hen a꞉namio꞉ iya Ya꞉kobdo꞉wa fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Iliyo꞉ iyamo꞉wo꞉ a꞉la꞉sio꞉, “Yosa꞉bo꞉ mo꞉sowo꞉ o꞉sab. Isib heno꞉ tambo e bo꞉fo꞉melea꞉ki, e misa꞉ ta꞉fo꞉lo꞉bo꞉ka꞉!” a꞉la꞉sio꞉. A꞉la꞉sa꞉labiki Ya꞉koba꞉ ene asulo꞉wo꞉ ko꞉ndo꞉feliaki, eyo꞉ mo꞉tilidabu. ");
INSERT INTO bco_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Ko꞉sega Yosa꞉b elo꞉ sio꞉ a꞉no꞉ ao ima꞉yo꞉ iyamo꞉wo꞉ tambo malolo meabiki dabu, a꞉la꞉ta꞉ga꞉ Ya꞉kob e a꞉ma꞉la꞉ Isib mena꞉ki a꞉la꞉ta꞉ga꞉ kelego꞉ donkiya꞉lo꞉ i fofodo꞉ susululia꞉ ha꞉na꞉sen iliga꞉fo꞉ a꞉no꞉ eyo꞉ ba꞉dakiyo꞉, asulo꞉ elo꞉wo꞉ o꞉li a꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","A꞉la꞉ta꞉ga꞉ Isolael eyo꞉ a꞉la꞉sio꞉, “A꞉no꞉ o꞉li. O꞉go꞉ ni so꞉wa Yosa꞉bo꞉ o꞉sab a꞉la꞉tiliasulo꞉l ko꞉lo꞉, ne o꞉soma꞉ni ilikiyo꞉, na꞉ so꞉wa ko꞉le ba꞉ba꞉ni ha꞉na꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","A꞉la꞉fo꞉ko꞉lo꞉ Isolael e kelego꞉wo꞉ tambo dimidalia꞉sa꞉ga꞉ ane. E Bilsiba hen a꞉na fa꞉la꞉dowakiyo꞉, iya Aisa꞉ga꞉ Godemo꞉wo꞉ wabulu sa꞉lakiyo꞉ bobayo꞉ a꞉na so꞉me. ");
INSERT INTO bco_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ nulu a꞉namio꞉ Gode eyo꞉ Isolaelbo꞉wo꞉ ofo fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Ya꞉kob, Ya꞉kob.” A꞉la꞉ho꞉idabikiyo꞉ “O꞉ba, ne weko꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","“Ne Gode, go꞉la꞉ Godeyo꞉ ne ko꞉lo꞉, ge Isibdo꞉ ha꞉na꞉no꞉wo꞉ tagio꞉ dowa꞉so꞉bo! Mo꞉wo꞉ niyo꞉ hen a꞉namio꞉ ge so꞉lo꞉wo꞉ modo꞉ fa꞉la꞉doma꞉ki dimidama꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ne ge o꞉lia꞉ Isib ha꞉na꞉sa꞉ga꞉ dofo꞉la꞉ga꞉yo꞉, tif amio꞉ hendele niyo꞉ so꞉lo꞉ gilo꞉wo꞉ a꞉ma꞉la꞉ hen wena tililia꞉ mia꞉no꞉. Ko꞉sega ge ha꞉sa sena sowaliki, Yosa꞉b e ge o꞉lia꞉ siliki, si gilo꞉wo꞉ go꞉lu alifa꞉ib.” Gode eyo꞉ a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Ya꞉kob e Bilsiba a꞉na ta꞉ta꞉sa꞉ga꞉ ane. Ya꞉koba꞉ so꞉wa iyo꞉, ini so꞉wa iyo꞉lo꞉, ingala꞉la꞉yo꞉lo꞉, a꞉la꞉ta꞉ga꞉ iya Ya꞉kobo꞉, i fofodo꞉ Isiba꞉ misa꞉ kaluwa꞉lo꞉ iliga꞉fo꞉ a꞉na disa꞉la꞉sa꞉ga꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Iyo꞉ Isib a꞉na ha꞉nakiyo꞉, no꞉ fofo꞉ o꞉lia꞉ kelego꞉ nafale Ka꞉ina꞉ndo꞉ di a꞉no꞉lo꞉ tambo Isib dia꞉gane. Ya꞉koba꞉ ene kalu so꞉waleyo꞉lo꞉, ene ida꞉yo꞉lo꞉, ene ema꞉mu iyo꞉lo꞉, i a꞉no꞉lo꞉ tambo enen o꞉lia꞉ Isib ane. ");
INSERT INTO bco_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Ya꞉kob, ene wi nowo꞉ Isolael ko꞉lo꞉ ene insiso꞉i o꞉lia꞉yo꞉ e Isib hen a꞉na ane. Ene so꞉lo꞉ e o꞉lia꞉lo꞉ ane wi agelo꞉wo꞉ we. Ya꞉koba꞉ so꞉wa wa꞉la꞉bo꞉, Luben. ");
INSERT INTO bco_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Lubena꞉ insiso꞉iyo꞉ we. Hanog, Balu, Heslon, o꞉lia꞉ Kami. ");
INSERT INTO bco_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeona꞉ insiso꞉iyo꞉ we. Yemuel, Yamin, Ohat, Yakin, Sohal o꞉lia꞉ So꞉l. So꞉l a꞉ma꞉ ene anowo꞉ Ka꞉ina꞉n ga. ");
INSERT INTO bco_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Libaiya꞉ insiso꞉iyo꞉ we. Geson, Kohat, o꞉lia꞉ Melali. ");
INSERT INTO bco_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudaya꞉ insiso꞉iyo꞉ we. Ea, Onan, Sa꞉la, Beles o꞉lia꞉ Yela. Ko꞉sega Ea o꞉lia꞉ Onan o꞉lia꞉yo꞉ Ka꞉ina꞉n a꞉naka sowo꞉. Belesa꞉ insiso꞉iyo꞉ Heslon o꞉lia꞉ Hamul. ");
INSERT INTO bco_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isakaya꞉ insiso꞉iyo꞉ we. Tola, Fufa, Iob o꞉lia꞉ Simlon. ");
INSERT INTO bco_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sebuluna꞉ insiso꞉iyo꞉ we. Selet, Elon o꞉lia꞉ Yalel. ");
INSERT INTO bco_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Kalu i a꞉no꞉ Lea elo꞉ Ya꞉kobo꞉lo꞉ sa꞉la꞉meo꞉ o꞉m. Lea e Mesobotemia silikilo꞉ so꞉wa sa꞉la꞉la꞉ o꞉lia꞉ e ma꞉mu i o꞉lia꞉yo꞉, a꞉la꞉ta꞉ga꞉ ka꞉isale so꞉wa, Daina a꞉no꞉ tambo agelo꞉wo꞉, do꞉la꞉fo꞉ otalen a꞉la꞉ta꞉ga꞉ otalen dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gada꞉ insiso꞉iyo꞉ we. Sifion, Hagi, Suni, Esbon, Eli, Alodi o꞉lia꞉ Aleli. ");
INSERT INTO bco_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asela꞉ insiso꞉iyo꞉ we. Imina, Isfa, Isfi, Belia a꞉la꞉ta꞉ga꞉ ini adowo꞉ Sa꞉la. Beliaya꞉ kalu so꞉wa a꞉la꞉yo꞉ Hebel o꞉lia꞉ Makiel. ");
INSERT INTO bco_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Kaluka꞉isale do꞉la꞉ta꞉ga꞉ do꞉go꞉fela꞉fo꞉ a꞉no꞉, Silbaya꞉ inso꞉ o꞉lia꞉ inu o꞉lia꞉lo꞉ dikudu agelo꞉wo꞉ o꞉m. Nanog dian ga, Silba a꞉no꞉, Laban eyo꞉ Leamo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ya꞉koba꞉ inga Lesol elo꞉ so꞉wa sa꞉la꞉liyo꞉ we. Yosa꞉b o꞉lia꞉ Ba꞉nsamen. ");
INSERT INTO bco_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Isib a꞉namio꞉, On amisa꞉ndo꞉ gulugululo꞉ alo꞉ bo꞉fo꞉lowan kalu Botifelaya꞉ ida꞉, Asenat e, Yosa꞉b e dia꞉sa꞉ga꞉, kalu so꞉wa a꞉la꞉, Manasa dia꞉ A꞉flam dia꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ba꞉nsamena꞉ insiso꞉iyo꞉ we. Bela, Bekel, Asbel, Gela, Naman, Ehi, Los, Mubim, Hubim o꞉lia꞉ Alda. ");
INSERT INTO bco_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Kalu so꞉wa do꞉la꞉ta꞉ga꞉ fa꞉la꞉da꞉in i a꞉no꞉, Lesola꞉ inso꞉ o꞉lia꞉ inu o꞉lia꞉lo꞉ dikudu agelo꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dan eyo꞉ kalu so꞉wa imilise, Husim ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nabtaliya꞉ insiso꞉iyo꞉ we. Yasel, Guni, Yesel o꞉lia꞉ Silem. ");
INSERT INTO bco_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Kalu i a꞉no꞉ Bilha elo꞉ Ya꞉kobo꞉lo꞉ sa꞉la꞉meo꞉ o꞉m. Bilhaya꞉ inso꞉ o꞉lia꞉ inu o꞉lia꞉lo꞉ dikudu agelo꞉wo꞉ doma꞉la꞉fo꞉ dowo꞉. Nanog dian ga, Bilha a꞉no꞉, Laban eyo꞉ Lesolmo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉koba꞉ ene eso꞉lo꞉le Isibdo꞉ ha꞉na꞉sa꞉ga꞉lo꞉ sen a꞉ma꞉ wi ko꞉lo꞉ dikudu agelo꞉wo꞉, do꞉la꞉lowo꞉ do꞉go꞉fe a꞉la꞉ta꞉ga꞉ do꞉go꞉fela꞉fo꞉ o꞉m. A꞉la꞉fo꞉ ko꞉sega, Ya꞉koba꞉ inso꞉wa꞉ ingala꞉la꞉ a꞉no꞉ mo꞉agelo꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","A꞉la꞉ta꞉ga꞉ Yosa꞉b e Isib silikiyo꞉, so꞉wayo꞉ a꞉la꞉ sa꞉la꞉li. A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉koba꞉ eso꞉lo꞉ ko꞉lo꞉ Isib hen a꞉na ha꞉na꞉sa꞉ga꞉lo꞉ sen a꞉no꞉lia꞉ dikudu agelo꞉wo꞉ do꞉la꞉lowo꞉ dom a꞉la꞉fo꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ya꞉koba꞉ eso꞉lo꞉wo꞉ Isib ha꞉na꞉nikiyo꞉, Gosendo꞉ ha꞉na꞉no꞉ togo꞉ wala sama꞉kiyo꞉, Ya꞉kob eyo꞉ Yudayo꞉ Yosa꞉bdo꞉wa tamina iliga꞉fo꞉. A꞉la꞉gabiki Yuda eyo꞉ togo꞉ imo꞉wo꞉ widabiki, iyo꞉ Gosen hen a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yosa꞉b eyo꞉ ene ho꞉s amilo꞉ i fofodo꞉ kalulo꞉ dia꞉ha꞉na꞉sen a꞉no꞉ dimidalia꞉sa꞉ga꞉, Gosen hen a꞉namio꞉ iya Isolaelo꞉ ba꞉ba꞉ni ane ko꞉lo꞉, iyayo꞉ galiliakiyo꞉, iyaya ta꞉li dofo꞉liki, e a꞉na ya꞉la꞉liki elen. ");
INSERT INTO bco_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Isolael eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “O꞉go꞉ niyo꞉ ge o꞉sabi bo꞉do꞉l ko꞉lo꞉, ne o꞉li o꞉la꞉ga꞉ soma꞉no꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","32","Yosa꞉b eyo꞉ ene ao imo꞉wo꞉ a꞉la꞉ta꞉ga꞉ iyaya꞉ eso꞉lo꞉mo꞉wo꞉lo꞉ a꞉la꞉sio꞉, “Ne Fa꞉lo꞉lo꞉wa ha꞉na꞉sa꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉sa꞉ma꞉no꞉, ‘Nao o꞉lia꞉ dowa꞉ ene eso꞉lo꞉ o꞉lia꞉yo꞉ Ka꞉ina꞉n heno꞉ ta꞉ta꞉ga꞉ nelo꞉wa mio꞉. Kalu i we no꞉ fofo꞉lo꞉ bo꞉fo꞉lowan kalu ko꞉lo꞉ mio꞉. Ini kelego꞉wo꞉ dia꞉b a꞉la꞉ta꞉ga꞉ ini sibiyo꞉lo꞉, kaowo꞉lo꞉ tililia꞉ mio꞉.’ ");
INSERT INTO bco_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Niyo꞉ Fa꞉lo꞉mo꞉wo꞉ a꞉la꞉bo꞉ sa꞉ma꞉nigo꞉l ko꞉lo꞉, eyo꞉ gio꞉ elo꞉wa mena꞉ki ho꞉ida꞉sa꞉ga꞉, ‘Gio꞉ o꞉b nanog diano꞉’ a꞉la꞉dabu ba꞉dalikiyo꞉, giliyo꞉ a꞉ma꞉la꞉ a꞉sa꞉lakiyo꞉, ‘Kalu alan, nio꞉ no꞉lo꞉ fofan kalu. Nio꞉ so꞉wagalina a꞉la꞉ta꞉ga꞉lo꞉ nanogo꞉ a꞉no꞉ko꞉ dia꞉li mio꞉ ko꞉lo꞉ so꞉l. A꞉la꞉ta꞉ga꞉ nili ma꞉muwa꞉lo꞉ a꞉la꞉dimida꞉i ya꞉lowan.’ Giliyo꞉ a꞉la꞉sa꞉lalega, Fa꞉lo꞉ eyo꞉ gio꞉ Gosen hen wenaka sa꞉bika꞉ a꞉la꞉likiyo꞉ dinali sa꞉ma꞉ib, mo꞉wo꞉ Isib kaluka꞉isaleyo꞉ sibilo꞉ fofan kalu o꞉lia꞉lo꞉ mesa꞉no꞉wo꞉ mada mo꞉bea꞉sen ko꞉lo꞉, giyo꞉ wena mesa꞉ib.” Yosa꞉b eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","A꞉la꞉fo꞉ko꞉lo꞉ Yosa꞉b e Fa꞉lo꞉lo꞉wa ha꞉na꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Ni dowo꞉lo꞉, nao iyo꞉lo꞉, ini no꞉ fofo꞉wo꞉lo꞉ a꞉la꞉ta꞉ga꞉ kelego꞉ inido꞉wo꞉lo꞉ tambo, Ka꞉ina꞉n heno꞉ ta꞉ta꞉ga꞉ ya꞉ga꞉, o꞉go꞉ iyo꞉ Gosen hen wena sab.” ");
INSERT INTO bco_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Yosa꞉b eyo꞉ ao i bila꞉fo꞉ nolo꞉ da꞉fea꞉sa꞉ga꞉, Fa꞉lo꞉wa꞉ wo꞉lokana kagama꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","A꞉la꞉ta꞉ga꞉ Fa꞉lo꞉wa꞉yo꞉ ao imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gio꞉ o꞉b nanog dia꞉seno꞉?” A꞉la꞉dabu ba꞉dabiki, iliyo꞉ a꞉la꞉sio꞉, “Kalu alan, tamin amio꞉ nili ma꞉muwo꞉ sibi bo꞉fo꞉lowa꞉sen ko꞉lo꞉ o꞉go꞉ niliyo꞉lo꞉ sibi bo꞉fo꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Nio꞉ hen wenamilo꞉ o꞉mesa꞉ni mio꞉ a꞉no꞉, Ka꞉ina꞉n hen amio꞉ maiyo꞉wo꞉ alan fa꞉la꞉dowabiki go꞉. Hen a꞉namio꞉ no꞉ fofo꞉ nililo꞉wo꞉ fugus ma꞉no꞉wo꞉ aundo꞉ma dowabi mio꞉ ko꞉lo꞉, giyo꞉ o꞉li a꞉la꞉asulalega, gi nanog dian kalu nio꞉, Gosen hen wena o꞉mesea a꞉la꞉sama.” ");
INSERT INTO bco_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","6","A꞉la꞉dabu ba꞉dabiki, Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉l o꞉lia꞉ gao o꞉lia꞉yo꞉ gelo꞉ amio꞉ fa꞉la꞉dowabo꞉lo꞉biki, Isib wiyo꞉ hen nafa imilig nowo꞉ ge asulo꞉ ko꞉lo꞉, iyo꞉ hen nafa a꞉na mesea꞉ki ta꞉ta꞉bi. Iyo꞉ Gosen hen a꞉na mesa꞉no꞉wo꞉ o꞉li ko꞉lo꞉, ge so꞉lo꞉ usamio꞉, no꞉ fofo꞉lo꞉ bo꞉fo꞉lowan kalu nolo꞉ ego꞉le dowo꞉lalega, kalu i a꞉no꞉ ni no꞉ fofo꞉ a꞉no꞉ imo꞉ bo꞉fo꞉melea꞉ki ta꞉ta꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","8","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ iya Ya꞉kobo꞉ tililia꞉ga꞉, Fa꞉lo꞉lo꞉wa fa꞉la꞉dowakiyo꞉, iyayo꞉ Fa꞉lo꞉mo꞉ wido꞉. Ya꞉kob eyo꞉ Fa꞉lo꞉mo꞉ sa꞉lakiyo꞉, “Gode eyo꞉ ge nafale mesea꞉ki ta꞉fa꞉ib” a꞉la꞉sio꞉. A꞉la꞉ta꞉ga꞉ Fa꞉lo꞉ eyo꞉ emo꞉ dabu ba꞉dakiyo꞉ a꞉la꞉sio꞉, “Ge donayo꞉ o꞉biba꞉s gulula꞉yo꞉?” ");
INSERT INTO bco_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","A꞉la꞉dabu ba꞉dabiki, Ya꞉kob eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Ne henfelo꞉ wilo꞉ ta꞉i mio꞉wo꞉ donayo꞉ 130 a꞉la꞉fo꞉ ko꞉lo꞉ gulula꞉. Ne donayo꞉ modo꞉lo꞉ mo꞉dowo꞉ ko꞉sega, ho꞉leno꞉ tambowo꞉ nelo꞉ amio꞉ hida꞉yo꞉wo꞉ modo꞉ fa꞉la꞉dowa꞉len. Ni ma꞉muwo꞉ donayo꞉ modo꞉ elen ko꞉lo꞉, dona nilo꞉wo꞉ ili tinio꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ya꞉kob eyo꞉ Fa꞉lo꞉wo꞉ nafale mesea꞉ki, Godemo꞉ wa꞉ka dulugu sa꞉la꞉sa꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosa꞉b eyo꞉ Fa꞉lo꞉ elo꞉ to sio꞉ a꞉no꞉ ko꞉lo꞉ kudu ha꞉nakiyo꞉, iya o꞉lia꞉ ao o꞉lia꞉yo꞉ Isib hen nafa, Lameses amisa꞉n anib amilo꞉ elen a꞉no꞉ imo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ iya o꞉lia꞉, ao o꞉lia꞉, a꞉la꞉ta꞉ga꞉ ili so꞉lo꞉wo꞉lo꞉ tambo ma꞉no꞉ ma꞉no꞉wo꞉ dimiaki, so꞉lo꞉ enedo꞉ ililo꞉ sab au sa꞉ga꞉li ane. ");
INSERT INTO bco_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Isib hen o꞉lia꞉ Ka꞉ina꞉n hen o꞉lia꞉ a꞉namio꞉, ma꞉no꞉ ma꞉no꞉wo꞉ mada aundo꞉ma dowaki, maiyo꞉wo꞉ alande fa꞉la꞉dowo꞉ ko꞉lo꞉, kaluka꞉isaleyo꞉ tambo mogaila꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Hen a꞉la꞉ a꞉namio꞉, kaluka꞉isaleyo꞉ ma꞉no꞉ kililia꞉ ya꞉labikiyo꞉, mole ililo꞉wo꞉ kedefo꞉. A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ mole a꞉no꞉ kegea꞉sa꞉ga꞉, Fa꞉lo꞉ elo꞉wa dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Isib kaluka꞉isale o꞉lia꞉ Ka꞉ina꞉n kaluka꞉isale o꞉lia꞉yo꞉ moleyo꞉ kedetabiki, iyo꞉ ha꞉na꞉sa꞉ga꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ moleyo꞉ kedefo꞉ ko꞉lo꞉, ma꞉no꞉wo꞉ mo꞉nalega, nio꞉ mada ko꞉na꞉ma soma꞉nigab. A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ ma꞉no꞉wo꞉ nimo꞉wo꞉ dimina.” ");
INSERT INTO bco_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","A꞉la꞉dabu ba꞉dabiki, Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Mole gililo꞉wo꞉ kedefo꞉lo꞉biki, ma꞉no꞉ kililia꞉nikiyo꞉, no꞉ fofo꞉ gililo꞉ a꞉no꞉ nemo꞉ dimia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ sibiyo꞉lo꞉, kaowo꞉lo꞉, goudiyo꞉lo꞉, donkiyo꞉lo꞉, ho꞉so꞉lo꞉ Yosa꞉b elo꞉wa tililia꞉ yabiki, ma꞉no꞉ a꞉no꞉ no꞉ fofo꞉ a꞉ma꞉ kililia꞉len. Dona a꞉namio꞉, iliyo꞉ ma꞉no꞉wo꞉ no꞉ fofo꞉ a꞉ma꞉ kililiya꞉i ha꞉na꞉la꞉ga꞉, no꞉ a꞉no꞉lo꞉ kedefo꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Dona a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, dona nowo꞉ a꞉fa꞉la꞉dowabiki, iyo꞉ Yosa꞉bdo꞉wa ya꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Kalu alan, niliyo꞉ to we gemo꞉wo꞉ mo꞉wo꞉no꞉le dia꞉fa꞉no꞉. Nio꞉ moleyo꞉ kedeta꞉b, a꞉la꞉ta꞉ga꞉ no꞉ fofo꞉wo꞉lo꞉ gemo꞉lo꞉ dimi ko꞉m. Niliyo꞉ ma꞉no꞉ a꞉kililia꞉no꞉wo꞉ kelego꞉ nowo꞉ mada aundo꞉ma, a꞉la꞉bo꞉ giyo꞉ o꞉li fanda ba꞉dab. Ninin do꞉mo꞉ o꞉lia꞉ hen o꞉lia꞉ a꞉no꞉ko꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nio꞉ gio꞉ ba madali bo꞉fo꞉lab amio꞉ sowalega, a꞉no꞉ mo꞉ililo꞉. A꞉la꞉ta꞉ga꞉ nili heno꞉lo꞉ mogagima꞉kiyo꞉ ta꞉ta꞉so꞉bo. A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉ ma꞉no꞉ kililiakiyo꞉, nili hen o꞉lia꞉ ninin do꞉mo꞉ o꞉lia꞉ko꞉ gemo꞉ dimia꞉no꞉. A꞉la꞉galikiyo꞉ nio꞉ Fa꞉lo꞉wa꞉ ene madali nanog dian kaluka꞉isale doma꞉no꞉ a꞉la꞉ta꞉ga꞉ nili heno꞉lo꞉ eno꞉ doma꞉ib. Heno꞉ mogagabena꞉ki a꞉la꞉ta꞉ga꞉ nio꞉ ma꞉no꞉wo꞉ o꞉na꞉li mesea꞉kiyo꞉, giyo꞉ nililo꞉ fo gema꞉no꞉wo꞉ dimina” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","21","A꞉la꞉go꞉ko꞉lo꞉ Isib kaluka꞉isaleyo꞉ maiyo꞉wo꞉ mada alan dowabiki, hen ililo꞉ a꞉no꞉ Yosa꞉bo꞉ tambo kililima꞉ki dimia꞉len. A꞉la꞉dimida꞉labiki, iyo꞉ tambo Fa꞉lo꞉wa꞉ madali nanog dian kaluka꞉isale fa꞉la꞉dowaki, Isib hen a꞉no꞉ tambo Fa꞉lo꞉ eno꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Ko꞉sega Fa꞉lo꞉ eyo꞉ Isib bobalo꞉ so꞉mea꞉sen kalu imo꞉wo꞉ moleyo꞉ dimia꞉sen ko꞉lo꞉, iliyo꞉ ma꞉no꞉wo꞉ o꞉li kililia꞉len. A꞉la꞉fo꞉ko꞉lo꞉ Yosa꞉b eyo꞉ Isib heno꞉ tambo kilili ko꞉sega bobalo꞉ so꞉mea꞉sen kaluwa꞉ hen inido꞉leyo꞉ mo꞉kilili. ");
INSERT INTO bco_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Ho꞉len a꞉namio꞉ Yosa꞉b eyo꞉ kaluka꞉isalemo꞉wo꞉ a꞉la꞉sio꞉, “O꞉go꞉ niyo꞉ gili hen o꞉lia꞉ kaluka꞉isale giyo꞉lo꞉ tambo Fa꞉lo꞉wa꞉ eno꞉ doma꞉ki kilili. A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ fo we gimo꞉ dimio꞉l ko꞉lo꞉, giliyo꞉ a꞉no꞉ ko꞉lo꞉ gela꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Fowo꞉ heda꞉sa꞉ga꞉ nafalialiki tula꞉sa꞉ga꞉yo꞉, giliyo꞉ ma꞉no꞉ tu a꞉no꞉ bila꞉fo꞉ aloba꞉da꞉sa꞉ga꞉, heb imilise nowo꞉ Fa꞉lo꞉mo꞉ dimia꞉bi. A꞉la꞉ta꞉ga꞉ heb fa꞉la꞉da꞉in o꞉dowab a꞉no꞉ go꞉no꞉n dia꞉sa꞉ga꞉, nolo꞉ tifa egema꞉no꞉ dia꞉taki, nolo꞉ ge o꞉lia꞉, gi so꞉wagalino꞉lo꞉, a꞉la꞉ta꞉ga꞉ gi so꞉lo꞉wo꞉lo꞉ tambo na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","A꞉la꞉sa꞉labiki kaluka꞉isale iliyo꞉ a꞉la꞉sio꞉, “Giyo꞉ nio꞉ mo꞉soma꞉ki asufa꞉ ko꞉lo꞉, kalu alan giyo꞉ a꞉la꞉asulalega, nio꞉ Fa꞉lo꞉wa꞉ madali nanog dian doma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Ho꞉len a꞉namio꞉ Yosa꞉b eyo꞉ ele nowo꞉ Isib a꞉na saefa꞉. Fowo꞉ tulakiyo꞉, heb bila꞉fo꞉ aloba꞉da꞉sa꞉ga꞉, imilig nowo꞉ Fa꞉lo꞉mo꞉ dimiaki, fa꞉la꞉da꞉in alobanalifa꞉ a꞉no꞉ kaluka꞉isale inin dia꞉ib. O꞉go꞉ ele a꞉no꞉ o꞉kudu ha꞉na꞉lab. Ko꞉sega bobalo꞉ so꞉mea꞉sen kaluwa꞉ hen ililo꞉wo꞉ Fa꞉lo꞉ eyo꞉ mo꞉di ko꞉lo꞉, i a꞉no꞉ hendo꞉ biso꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Isolaela꞉ eso꞉lo꞉wo꞉ Isib hen a꞉nami, Gosen hen a꞉naka sen. Hen a꞉na silikiyo꞉, iliyo꞉ hen heb nolo꞉ kilili, a꞉la꞉ta꞉ga꞉ iliyo꞉ so꞉wayo꞉ sa꞉la꞉la꞉labikiyo꞉, modo꞉ ko꞉lo꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ya꞉kob e Isib a꞉namilo꞉ seno꞉ donayo꞉ do꞉la꞉ta꞉ga꞉ doma꞉la꞉fo꞉ gulula꞉ ko꞉lo꞉, e dona dikudu agelo꞉wo꞉ 147 a꞉la꞉fo꞉ ko꞉lo꞉ gulula꞉. ");
INSERT INTO bco_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉kob e soma꞉no꞉wo꞉ ko꞉na꞉ma dowabikiyo꞉, eyo꞉ Yosa꞉bo꞉ ho꞉lelia꞉sa꞉ga꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ nemo꞉wo꞉ sagalalega, gi dagiyo꞉ ni fe ha꞉ga golofo꞉liki, nemo꞉wo꞉ a꞉la꞉dinali sama. Ne sowalikiyo꞉ Isib hen wenamio꞉ daida꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Ni do꞉mo꞉wo꞉ ni ma꞉muwa꞉ do꞉mo꞉lo꞉ difa꞉ a꞉na dia꞉foma꞉ki asulab ko꞉lo꞉, ni do꞉mo꞉wo꞉ dia꞉ha꞉na꞉ga꞉ Isib hen we ta꞉ta꞉sa꞉ga꞉, ni ma꞉mulo꞉ difa꞉lo꞉wa dia꞉ta꞉bi. Giyo꞉ a꞉la꞉dimidama꞉no꞉ a꞉la꞉liki dinali sama.” A꞉la꞉sa꞉labikiyo꞉ Yosa꞉b eyo꞉ a꞉la꞉sio꞉, “Gilo꞉ sa꞉lab ko aumbo꞉, niyo꞉ dimidama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","A꞉la꞉ta꞉ga꞉ Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “To a꞉no꞉ halale alitakiyo꞉, Godeya꞉ wi amio꞉ nemo꞉wo꞉ dinali saefoma.” A꞉la꞉sa꞉labiki Yosa꞉b eyo꞉ Godeya꞉ wi amio꞉ dinali sio꞉. A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ Ya꞉kobo꞉ ene uwo꞉ba alifo꞉likiyo꞉, Godemo꞉wo꞉ sagala꞉liki wabulu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ho꞉len nolo꞉ ta꞉ta꞉sa꞉ga꞉, Yosa꞉b eyo꞉ iyayo꞉ walaf da꞉laka꞉ a꞉la꞉da꞉dabiki, eyo꞉ inso꞉ Manasa o꞉lia꞉ A꞉flam o꞉lia꞉yo꞉ tililia꞉sa꞉ga꞉, Ya꞉kobo꞉ ba꞉ba꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yosa꞉bo꞉ mio꞉ka꞉ a꞉la꞉bo꞉ Ya꞉kobo꞉ da꞉da꞉ga꞉, e uwo꞉b amilo꞉ alifo꞉leno꞉ ha꞉sa ka halale dasilia꞉ga꞉ sen. ");
INSERT INTO bco_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","Ya꞉kob eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Gode Halaido꞉lo꞉ A꞉labo꞉ e ko꞉lo꞉ Ka꞉ina꞉n hen amio꞉ Lus amisa꞉n a꞉namio꞉ nelo꞉wa handalota꞉ga꞉, ne halaido꞉ doma꞉ki sa꞉lakiyo꞉ a꞉la꞉sio꞉, ‘Gilo꞉ so꞉wa sa꞉la꞉la꞉i ha꞉nab a꞉no꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉doma꞉ki ta꞉fa꞉no꞉ ko꞉lo꞉, geya a꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉wo꞉ alan fa꞉la꞉doma꞉ib. A꞉la꞉ta꞉ga꞉ hen we gemo꞉wo꞉lo꞉, so꞉wa gilo꞉ sa꞉la꞉la꞉i ha꞉nab o꞉mo꞉wo꞉lo꞉ tambo dimiaki, gio꞉ ho꞉leno꞉ tambo biso꞉lo꞉ dowa꞉i ha꞉na꞉mela꞉ib.’ Gode eyo꞉ nemo꞉wo꞉ a꞉la꞉dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ne Isib hen wiyo꞉ semo꞉mio꞉ amilo꞉ gilo꞉ so꞉wa a꞉la꞉ ko꞉lo꞉ Isibdo꞉ sa꞉la꞉li a꞉no꞉, ne dio꞉l. A꞉flam o꞉lia꞉ Manasa o꞉lia꞉yo꞉ ni so꞉wa Luben o꞉lia꞉ Simeon o꞉lia꞉ o꞉ngo꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ko꞉sega giyo꞉ a꞉la꞉ma꞉ fa꞉s amio꞉ so꞉wa nolo꞉ a꞉sa꞉la꞉lialega, so꞉wa a꞉no꞉ ga꞉no꞉le doma꞉ib ko꞉lo꞉, dabun nilo꞉ aloba꞉dakiyo꞉, iyo꞉ a꞉la꞉ma꞉ ha꞉ga iliki dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Ne Mesobotemia ta꞉ta꞉ga꞉, Ka꞉ina꞉n hen a꞉na ha꞉na꞉ni ha꞉nakiyo꞉, A꞉fla꞉ta amisa꞉n amio꞉ semo꞉ fa꞉la꞉dowo꞉wa, Lesol e a꞉na sowo꞉. E sowabikiyo꞉, Ne nofolo꞉wo꞉ alan dowa꞉sa꞉ga꞉, A꞉fla꞉talo꞉ ha꞉na꞉sen tog anib a꞉na dali alifa꞉. A꞉fla꞉ta amisa꞉n a꞉no꞉ o꞉go꞉ Ba꞉diliha꞉m a꞉la꞉sa꞉la꞉sen.” Ya꞉kob eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yosa꞉ba꞉ so꞉wa a꞉la꞉ a꞉no꞉ Ya꞉kob eyo꞉ ba꞉da꞉ga꞉yo꞉ a꞉la꞉sio꞉, “So꞉wa we o꞉ba?” ");
INSERT INTO bco_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosa꞉b eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “So꞉wa a꞉la꞉ we, ne wena sen amilo꞉ Godeya꞉lo꞉ nemo꞉lo꞉ dimiyo꞉ we.” A꞉la꞉sa꞉labiki Ya꞉kob eyo꞉ a꞉la꞉sio꞉, “Gi so꞉wa a꞉la꞉ko nafale mesea꞉ki, niyo꞉ Godemo꞉ dulugu sa꞉ma꞉nigo꞉l ko꞉lo꞉, nelo꞉wa tililia꞉ mena,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Ho꞉len a꞉namio꞉ Isolael e anaso꞉ dowakiyo꞉, ene siyo꞉ funa꞉ dowaki mo꞉ba꞉ba꞉no꞉ dowo꞉. A꞉la꞉go꞉ko꞉lo꞉ Yosa꞉b eyo꞉ ene so꞉wa a꞉la꞉ a꞉no꞉ tililia꞉ga꞉, iyaya꞉ anib a꞉na ta꞉tabikiyo꞉, Isolael eyo꞉ a꞉la꞉ a꞉no꞉ fafula꞉fo꞉liki mimilo꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Isolael eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Ne ge misio꞉ wa꞉kabiyo꞉ mo꞉ba꞉ba꞉no꞉ a꞉la꞉asulo꞉ ko꞉sega, Gode eyo꞉ ne asufa꞉ ko꞉lo꞉, o꞉go꞉ ge o꞉lia꞉ gi so꞉wa o꞉lia꞉yo꞉ misio꞉ bo꞉do꞉l.” ");
INSERT INTO bco_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","A꞉la꞉sa꞉labiki inso꞉ a꞉la꞉ Isolaela꞉ gul anib amilo꞉ sen a꞉no꞉ Yosa꞉b eyo꞉ gasilia꞉ga꞉ ha꞉la꞉ doba꞉da꞉ ta꞉ta꞉ga꞉, e iyayo꞉ wabudakiyo꞉, hena gulalu siliki misa꞉fu ali. ");
INSERT INTO bco_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ ene so꞉wa a꞉la꞉yo꞉ tililia꞉ ya꞉ga꞉, iyaya꞉ aniba kagama꞉ yakiyo꞉, A꞉flam e Isolaela꞉ dagi fo꞉fo꞉doloba꞉da꞉ ta꞉taki, Manasa e Isolaela꞉ dagi ilili doba꞉da꞉ ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ko꞉sega Isolael eyo꞉ ene dagiyo꞉ wo꞉ida꞉le dimiakiyo꞉, dagi ililib a꞉no꞉ so꞉wa tif, A꞉flama꞉ misa꞉ya dia꞉taki, dagi fo꞉fo꞉dolobo꞉ so꞉wa wa꞉la꞉b, Manasaya꞉ misa꞉ya difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","A꞉la꞉dimida꞉sa꞉ga꞉ Isolael eyo꞉ Yosa꞉bo꞉ nafale mesea꞉ki, Godemo꞉ dulugu sa꞉laki a꞉la꞉sio꞉, “Ni ma꞉mu Ablaham o꞉lia꞉ do Aisa꞉g o꞉lia꞉ma꞉lo꞉ kudu ha꞉na꞉seno꞉ Gode ge. A꞉la꞉ta꞉ga꞉ ho꞉len nelo꞉ sa꞉la꞉lia a꞉la꞉ta꞉ga꞉ dowa꞉i mio꞉ wenamio꞉, nelo꞉ dinafalo꞉ bo꞉fo꞉lowa꞉seno꞉ Gode ge. ");
INSERT INTO bco_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Hida꞉yo꞉wo꞉ nelo꞉wa fa꞉la꞉dowo꞉ amio꞉, ge ma꞉mula꞉ kalu o꞉ngo꞉ fa꞉la꞉dowaki, ne asuwa꞉ta꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ Gode giyo꞉ so꞉wa a꞉la꞉ we asuwa꞉taki, nafale mesea꞉ki ta꞉ta꞉bi. A꞉la꞉ta꞉ga꞉ ne ma꞉mu Ablahama꞉ wiyo꞉lo꞉, do Aisa꞉ga꞉ wiyo꞉lo꞉, ni wiyo꞉lo꞉ mo꞉sulu hamana꞉ki, a꞉la꞉ma꞉ so꞉wa sa꞉la꞉la꞉i ha꞉na꞉lab a꞉ma꞉yo꞉lo꞉ henfelo꞉ wenamio꞉ modo꞉ fa꞉la꞉doma꞉ki ta꞉ta꞉bi.” Isolael eyo꞉ a꞉la꞉dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","18","Yosa꞉b eyo꞉ iyaya꞉ dagi ililib ko꞉lo꞉ A꞉flama꞉ misa꞉ amilo꞉ dia꞉tab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, e mo꞉beaki, iyaya꞉ dagi a꞉no꞉ Manasaya꞉ misa꞉ya a꞉dia꞉foma꞉ki a꞉na dia꞉ga꞉yo꞉, iyamo꞉wo꞉ a꞉la꞉sio꞉, “Do, giyo꞉ halayo꞉ a꞉la꞉bo꞉ dimida꞉so꞉bo. So꞉wa we wa꞉la꞉b ko꞉lo꞉ gi dagi ililiba꞉yo꞉ e misa꞉ wena dia꞉foma” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Ko꞉sega iyaya꞉yo꞉ Yosa꞉b elo꞉ to sa꞉lab a꞉no꞉ mo꞉da꞉daki, emo꞉wo꞉ a꞉la꞉sio꞉, “Ni so꞉wa, ne mo꞉wo꞉ asulufo꞉liki dimido꞉l. Wa꞉la꞉b so꞉wayo꞉lo꞉ alan dowaki, ene eso꞉lo꞉wo꞉lo꞉ alan fa꞉la꞉doma꞉ib. Ko꞉sega gi so꞉wa tif wema꞉ wiyo꞉ alan dowaki wa꞉la꞉b so꞉waya꞉ wiyo꞉ tininima꞉ib. A꞉la꞉ta꞉ga꞉ so꞉wa elo꞉ sa꞉la꞉la꞉i ha꞉nab a꞉no꞉lo꞉ mada modo꞉ ko꞉lo꞉ fa꞉la꞉dowa꞉i ha꞉na꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","A꞉la꞉ta꞉ga꞉ Isolael eyo꞉ a꞉la꞉yo꞉ Godemo꞉wo꞉ nafale mesea꞉kiyo꞉, towo꞉ a꞉la꞉dulugu sio꞉, “Tif amio꞉ Isolael kaluka꞉isale iliyo꞉ kalu nolo꞉ nafale mesea꞉kiyo꞉ a꞉la꞉sa꞉ma꞉ib, ‘A꞉flam dia꞉ Manasa dia꞉mo꞉lo꞉ Godeya꞉lo꞉ nafa dimido꞉ o꞉leaumbo꞉, o꞉go꞉ gemo꞉wo꞉lo꞉ a꞉la꞉dimida꞉melea꞉ki asulab.’” A꞉la꞉sa꞉lakiyo꞉ Isolael eyo꞉ A꞉flama꞉ wiyo꞉ iwalu dia꞉taki, Manasaya꞉ wiyo꞉ ha꞉ga difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","A꞉la꞉ta꞉ga꞉ Isolael eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Ge dabuma. Ne ko꞉na꞉ma soma꞉nigo꞉l, ko꞉sega Godeyo꞉ ge o꞉lia꞉ dofo꞉ ha꞉na꞉la꞉ga꞉yo꞉, ge ma꞉muwa꞉ hena a꞉ma꞉la꞉ tililia꞉ ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ni heno꞉ na꞉ so꞉wa imo꞉wo꞉ aloba꞉dakiyo꞉, hen heb nolo꞉lo꞉ gemo꞉wo꞉ a꞉dimia꞉no꞉. Tamin amio꞉ niyo꞉ da꞉ inso꞉ o꞉lia꞉ helebe o꞉lia꞉ma꞉ Amol kalu i o꞉lia꞉ buba꞉sa꞉ga꞉, Sekem hen nafa, misio꞉ anib doba꞉da꞉lo꞉ a꞉no꞉ a꞉na di ko꞉lo꞉, o꞉go꞉ hen heb a꞉no꞉ gemo꞉ dimio꞉l.” Ya꞉kob eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ya꞉kob eyo꞉ insiso꞉iyo꞉ ho꞉ida꞉sa꞉ga꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gemo꞉wo꞉ tif amilo꞉ gilo꞉ ta꞉i ha꞉na꞉no꞉wo꞉ ko꞉lo꞉ walama꞉nigo꞉l ko꞉lo꞉, gio꞉ nelo꞉ wena kegenema. ");
INSERT INTO bco_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Gio꞉ tambo Ya꞉koba꞉ insiso꞉i ko꞉lo꞉, gio꞉ ua kegea꞉sa꞉ga꞉ dabuma. Ni wi nowo꞉ Isolael ko꞉lo꞉, go꞉la꞉lo꞉ to sa꞉ma꞉nigo꞉l we dabuma. ");
INSERT INTO bco_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Luben, ni so꞉wa wa꞉la꞉bo꞉ ge. Halaido꞉ nilo꞉wo꞉ geya da꞉lab Ne kalu halaido꞉ ilikilo꞉ so꞉wa tamin amilo꞉ sa꞉la꞉liyo꞉ ge. Gao i nol usamio꞉ ge wilo꞉ tamin dowo꞉wo꞉ ge, a꞉la꞉ta꞉ga꞉ halaido꞉ gilo꞉ma꞉yo꞉ iyo꞉ gi tinio꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ko꞉sega halaido꞉ gilo꞉wo꞉ ho꞉nbu o꞉ngo꞉ dowaki, go꞉no꞉n a꞉ma꞉la꞉yo꞉ mo꞉tilidoma꞉ib ko꞉lo꞉, gi wi tamin dowo꞉ a꞉no꞉ wa꞉kabiyo꞉ mo꞉doma꞉ib. Mo꞉wo꞉ go꞉la꞉ uwo꞉bo꞉ gi bidila꞉sa꞉ga꞉, man mogago꞉ dimidaki, go꞉lo꞉ sendelo alifa꞉. Hendele, giyo꞉ ni uwo꞉bo꞉ bidila꞉. ");
INSERT INTO bco_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Simeon o꞉lia꞉ Libai o꞉lia꞉ma꞉ mano꞉ imilise dowaki, nol o꞉lia꞉yo꞉ helebeya꞉ buba꞉sen. ");
INSERT INTO bco_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","A꞉la꞉yo꞉ gadiakiyo꞉ kalu nolo꞉ sana sowo꞉. A꞉la꞉ma꞉yo꞉ o꞉li go꞉ a꞉la꞉do꞉ sagalo꞉ ba꞉ba꞉no꞉wo꞉, kaomo꞉wo꞉ nagalo꞉wo꞉ madali dimi. A꞉la꞉fo꞉ko꞉lo꞉ ne a꞉la꞉ o꞉lia꞉yo꞉ asulo꞉wo꞉ imiliseyo꞉ mo꞉dowaki, a꞉la꞉ma꞉lo꞉ asulo꞉ aundo꞉ dimidama꞉no꞉ tolo꞉ wo꞉no꞉ledo꞉ nenelab a꞉no꞉, ne a꞉namio꞉ mo꞉doma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","A꞉la꞉ma꞉ gadio꞉ alan a꞉ma꞉yo꞉ ida꞉nina꞉ ko mogaila꞉ma꞉ib. A꞉la꞉ma꞉ kulufa꞉yo꞉ halaido꞉ a꞉ma꞉yo꞉, inin a꞉ma꞉la꞉yo꞉ hida꞉yo꞉wo꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉do alifa꞉ib. Niyo꞉ Ya꞉koba꞉ ene so꞉lo꞉ us a꞉namio꞉ a꞉la꞉yo꞉ aloba꞉da꞉sa꞉ga꞉, Isolael hen a꞉namio꞉ ina꞉li ina꞉lile a꞉la꞉ mesea꞉ki iliga꞉felema꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Yuda ge, gao iya꞉yo꞉ gi wiyo꞉ wabuluma꞉ib. A꞉la꞉ta꞉ga꞉ gis kaluwo꞉ giyo꞉ ta꞉lia꞉ib ko꞉lo꞉, gao i wema꞉yo꞉ gemo꞉ misa꞉ gulumeakiyo꞉, ge wabulu sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yuda e no꞉ laion inso꞉ o꞉ngo꞉ dowo꞉. Ni so꞉wa, e laion inso꞉wa꞉lo꞉ no꞉wo꞉ sa꞉nda꞉sa꞉ga꞉ na꞉la꞉ga꞉ alifo꞉lowan o꞉ngo꞉ dowab. A꞉la꞉fo꞉ko꞉lo꞉ nolba꞉yo꞉ e tagilaki, mo꞉digida꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Yudaya꞉ eso꞉lo꞉wa a꞉la꞉ta꞉ga꞉yo꞉ misa꞉ kalu alano꞉ a꞉na fa꞉la꞉doma꞉ib ko꞉lo꞉, ho꞉leno꞉ tambo ene so꞉lo꞉ amio꞉ kalu nowo꞉ misa꞉ dowa꞉i ha꞉na꞉la꞉ga꞉ dowalikiyo꞉, amisa꞉n nolba꞉yo꞉ kelego꞉ nafa nolo꞉ emo꞉ dia꞉ ya꞉mela꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isaleyo꞉ tambo e ko꞉lo꞉ kudu yaliki, i a꞉no꞉ e bo꞉fo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ene wain iyo꞉ modo꞉ doma꞉ib ko꞉lo꞉, eyo꞉ ene donkiyo꞉ wain i nafaleya galo alifa꞉ib. A꞉la꞉ta꞉ga꞉ ene donki inso꞉wo꞉ wain egelo꞉ nafale us a꞉na ta꞉fa꞉ib. Ene helebeso꞉go꞉ to꞉go꞉dakiyo꞉, wain ho꞉n us ka to꞉lofo꞉liki, to꞉go꞉dema꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Si elo꞉wo꞉ wain ho꞉n genelo꞉ o꞉ngo꞉ doma꞉ib. A꞉la꞉ta꞉ga꞉ bes elo꞉wo꞉ kao bo ib ho꞉lo꞉ o꞉ngo꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Sebulun e so꞉lu ho꞉n aniba mesa꞉ib ko꞉lo꞉, ene hen amio꞉ ho꞉n ko꞉sulo꞉ kagama꞉no꞉wo꞉ hege ane hen nafale doma꞉ib. Hen elo꞉wo꞉ ha꞉na꞉ga꞉, Saido꞉n amisa꞉na elema꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isaka e donki halaido꞉wo꞉ o꞉ngo꞉ dowo꞉. E kelego꞉lo꞉ dia꞉ha꞉nan us a꞉na madali alifo꞉len. ");
INSERT INTO bco_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Eyo꞉ heno꞉ nafale ba꞉daki, a꞉la꞉ta꞉ga꞉ Elo꞉ ha꞉salo꞉ mesa꞉no꞉ hen a꞉no꞉ ego꞉le ba꞉ba꞉. A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ hida꞉yo꞉ kelego꞉wo꞉ ene kelena dia꞉ta꞉ga꞉ ha꞉naki, eyo꞉ madali nanogdo꞉ dian kalu a꞉la꞉ka dowo꞉. ");
INSERT INTO bco_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dana꞉ ene so꞉lo꞉ iliyo꞉ inina꞉ma꞉la꞉ bo꞉fo꞉lalikiyo꞉, ene so꞉lo꞉ a꞉no꞉ Isolael so꞉lo꞉ nol o꞉lia꞉yo꞉ imilo꞉ ka doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan e sowa꞉ kisa꞉wa꞉l o꞉ngo꞉ ko꞉lo꞉, tog aniba delikiyo꞉, hoso a꞉na yab amio꞉, dalolia꞉ ya꞉ga꞉ gesena ma꞉bululaliki, kaluwo꞉ ho꞉s wa꞉l amilo꞉ sen a꞉no꞉ fa꞉sela talulia꞉ga꞉ sandita꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yawe gilo꞉ kaluka꞉isaleyo꞉ asuwa꞉takilo꞉ a꞉ma꞉la꞉ gasilia꞉no꞉ a꞉no꞉ ko꞉lo꞉ niyo꞉ yasilo꞉l. ");
INSERT INTO bco_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Afalo꞉ dian kalu iyo꞉ ya꞉ga꞉ Gad o꞉lia꞉ babuma꞉ib ko꞉sega, eyo꞉ kalu i a꞉no꞉ o꞉lu dalaidaliki, i o꞉lia꞉ babuma꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asela꞉ ene hen amio꞉ ma꞉no꞉ ma꞉no꞉wo꞉ nafale fa꞉la꞉doma꞉ib ko꞉lo꞉, misa꞉ kaluwa꞉lo꞉ ma꞉no꞉ nafale nan a꞉no꞉ eyo꞉ o꞉li gela꞉liki tula꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nabtali e no꞉ sili alitab amilo꞉ ga꞉li dowan o꞉ngo꞉ ko꞉lo꞉ dowab. Eyo꞉ inso꞉wo꞉ nafale ko꞉lo꞉ mada sa꞉la꞉la꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Yosa꞉b e i waina꞉ ele nafaleyo꞉ o꞉ngo꞉ ko꞉lo꞉, ho꞉n si aniba iliki, fo nafaleyo꞉ modo꞉ ko꞉lo꞉ heda꞉lab. Ele a꞉no꞉ tambo ha꞉na꞉sa꞉ga꞉, ilif tolo꞉ a꞉no꞉ a꞉ma꞉ go꞉lufa꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Da꞉ya꞉lo꞉ buban kaluwa꞉yo꞉ e o꞉lia꞉ halaido꞉ bubaki, iyo꞉ gadia꞉sa꞉ga꞉ e da꞉ya꞉ ola꞉len. ");
INSERT INTO bco_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ko꞉sega Ya꞉koba꞉ Gode Halaido꞉lo꞉ A꞉lab a꞉ma꞉yo꞉ emo꞉wo꞉ halaido꞉wo꞉ dimi ko꞉lo꞉, dagi elo꞉ a꞉no꞉ halaido꞉ dowaki, elo꞉ sililiab a꞉no꞉ mo꞉halala꞉sen. Gode a꞉no꞉ Isolaeldo꞉ bo꞉fo꞉lowano꞉ e ko꞉lo꞉, Isolael iyo꞉ ene halaido꞉ usa wo꞉no꞉le elen. ");
INSERT INTO bco_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Go꞉la꞉ Gode a꞉ma꞉yo꞉ ge asuwa꞉fa꞉ib. A꞉la꞉ta꞉ga꞉ Gode Halaido꞉lo꞉ A꞉lab a꞉ma꞉yo꞉ ge nafale mesea꞉ki ta꞉fa꞉ib. Eyo꞉ akin halona a꞉la꞉ta꞉ga꞉yo꞉ ho꞉no꞉ dimia꞉ib. Gi hen amio꞉lo꞉ ho꞉n siyo꞉ modo꞉ fa꞉la꞉do alifa꞉ib. A꞉la꞉ta꞉ga꞉ gi so꞉lo꞉ amilo꞉ ga i a꞉ma꞉yo꞉ so꞉wayo꞉ modo꞉ sa꞉la꞉la꞉ melea꞉ki ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Go꞉la꞉lo꞉ ge ko꞉lo꞉ nafale mesea꞉kilo꞉ dulugu so꞉lo꞉l wema꞉yo꞉, kelego꞉ nafayo꞉ fa꞉la꞉do alitaki, misio꞉wo꞉ go꞉lula꞉sa꞉ga꞉, felesilo꞉ a꞉no꞉lo꞉ o꞉go꞉sema꞉ib. Yosa꞉b giyo꞉ gao i we bo꞉fo꞉lab ko꞉lo꞉, bo꞉ba kelego꞉ gemo꞉lo꞉ dimia꞉no꞉ a꞉no꞉ ko꞉lile ko꞉lo꞉ dia꞉nigab. ");
INSERT INTO bco_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ba꞉nsamen e saila gasa ko꞉lo꞉ maiyo꞉ sia꞉lab o꞉ngo꞉ dowab. Kea꞉fowo꞉ no꞉ ta꞉la꞉iyo꞉ a꞉no꞉ sa꞉nda꞉sa꞉ga꞉ na꞉len. A꞉la꞉ta꞉ga꞉ ga꞉lowo꞉ no꞉ ho da꞉lab a꞉no꞉ aloba꞉da꞉sa꞉ga꞉ dimia꞉len.” ");
INSERT INTO bco_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Isolaela꞉ so꞉lo꞉wo꞉ kugula꞉fo꞉wo꞉ we ko꞉lo꞉, iyaya꞉yo꞉ iyo꞉ halale alifoma꞉ki, to a꞉no꞉ ko꞉lo꞉ dulugu sio꞉. Eyo꞉ towo꞉ insiso꞉imo꞉wo꞉ man ina꞉li ina꞉lilo꞉wa꞉lo꞉ ego꞉ o꞉leau dinali sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","To a꞉no꞉ imo꞉wo꞉ dinali sa꞉la꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Ne ni ma꞉mu i dane ane sab o꞉lia꞉yo꞉ galima꞉ni ha꞉na꞉nigo꞉l ko꞉lo꞉, ni do꞉mo꞉ we Ka꞉ina꞉n hena dia꞉ha꞉na꞉sa꞉ga꞉, ni ma꞉mulo꞉ daido꞉ amilo꞉ difa꞉ amio꞉, Makbela hen, Mamele hen anib amilo꞉ u a a꞉na dia꞉fa꞉ni ha꞉na꞉bi. Tamin amio꞉ hen a꞉no꞉ Hit kalu Eflon eno꞉ ko꞉lo꞉, Ablaham eyo꞉ nilo꞉ dali alita꞉mela꞉no꞉ hen a꞉no꞉ ko꞉lo꞉ kilili. ");
INSERT INTO bco_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ablaham o꞉lia꞉ inga Sa꞉la o꞉lia꞉yo꞉ a꞉na dali alifa꞉. Aisa꞉g o꞉lia꞉ inga La꞉ba꞉ga o꞉lia꞉yo꞉ a꞉no꞉lo꞉ a꞉na dali alifa꞉. A꞉la꞉ta꞉ga꞉ ni ga Leayo꞉lo꞉ niyo꞉ a꞉na dali alifa꞉ ko꞉lo꞉, nelo꞉ a꞉na dali alita꞉bi. ");
INSERT INTO bco_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tamin amio꞉ egelo꞉ hen o꞉lia꞉, u a a꞉namilo꞉ elen a꞉no꞉lia꞉yo꞉ Hit kalu eno꞉ ko꞉lo꞉ Ablaham eyo꞉ kilili.” ");
INSERT INTO bco_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Ya꞉kob eyo꞉ ene insiso꞉imo꞉wo꞉ asuluma꞉no꞉ towo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉ eletakiyo꞉, ene gido꞉fo꞉wo꞉ uwo꞉ba dia꞉ta꞉sa꞉ga꞉ alilakiyo꞉, ha꞉fo꞉ko꞉ siliga꞉taki sowa꞉sa꞉ga꞉, e iasi dane ane sab o꞉lia꞉ galima꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Isolael e sowabiki, Yosa꞉b eyo꞉ iyaya꞉ wa꞉la alifo꞉liki, mimila꞉liki ya꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","A꞉la꞉ta꞉ga꞉yo꞉ Yosa꞉b eyo꞉ iya sowo꞉ a꞉no꞉ bo꞉bo꞉gebo꞉ mo꞉hesema꞉ki, mulumulo꞉lo꞉ asulo꞉ kalu iliyo꞉ Isolaela꞉ do꞉mo꞉ amio꞉ mulumulo꞉wo꞉ dia꞉foma꞉ki sio꞉ ko꞉lo꞉, kalu i a꞉ma꞉yo꞉ do꞉mo꞉wo꞉ mo꞉hesema꞉kilo꞉ mululan a꞉no꞉ a꞉na difa꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Mulumulo꞉lo꞉ mia꞉sen kaluwa꞉yo꞉ sowo꞉ do꞉mo꞉ amio꞉ mulumulo꞉wo꞉ ho꞉len do꞉la꞉fo꞉ fa꞉la꞉da꞉in usa a꞉namio꞉ mulu alita꞉sen ko꞉lo꞉, iliyo꞉ Isolaela꞉ do꞉mo꞉ amio꞉lo꞉ a꞉la꞉dimido꞉. A꞉la꞉ta꞉ga꞉ Isib kaluka꞉isale iyo꞉ kalu kuo꞉ya꞉likilo꞉ seno꞉, ho꞉leno꞉ do꞉la꞉fo꞉ dom a꞉la꞉fo꞉ ko꞉lo꞉ sen. ");
INSERT INTO bco_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","5","Kalu kuo꞉ya꞉leno꞉ edabiki, Yosa꞉b eyo꞉ Fa꞉lo꞉wa꞉ nanog kalumo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ nemo꞉wo꞉ sagalalega, ni to we Fa꞉lo꞉mo꞉wo꞉ sa꞉ma꞉ni ha꞉na꞉sa꞉ga꞉yo꞉ a꞉la꞉sa꞉la꞉bi, ‘Dowo꞉ soma꞉nikiyo꞉, nemo꞉wo꞉ a꞉la꞉sio꞉, “Ne soma꞉nigo꞉l ko꞉lo꞉, ne Ka꞉ina꞉n hen a꞉namio꞉ no꞉no꞉n do꞉mo꞉wo꞉ unanalifa꞉ a꞉na dia꞉fa꞉ni dia꞉ha꞉na꞉bi.” Nemo꞉wo꞉ a꞉la꞉sa꞉labiki, niyo꞉ emo꞉wo꞉ dinali saefa꞉ ko꞉lo꞉, o꞉go꞉ niyo꞉ ene do꞉mo꞉wo꞉ dia꞉ha꞉na꞉sa꞉ga꞉, enedo꞉ u no꞉no꞉ a꞉na dia꞉ta꞉ga꞉yo꞉, ne a꞉ma꞉la꞉ mia꞉no꞉’ a꞉la꞉liki Fa꞉lo꞉mo꞉wo꞉ a꞉la꞉dabu ba꞉da꞉bika꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","A꞉la꞉sa꞉labiki Fa꞉lo꞉ eyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sio꞉, “Giyo꞉ go꞉lbo꞉wo꞉ dinali sio꞉ au dimidaki, go꞉lo꞉ dalima꞉ni hamana” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","8","A꞉la꞉fo꞉ko꞉lo꞉ Yosa꞉b eyo꞉ ene iyayo꞉ dia꞉sa꞉ga꞉, Ka꞉ina꞉n hen a꞉na dalima꞉ni ha꞉nabiki, Fa꞉lo꞉wa꞉ ene nanog dian kalu iyo꞉lo꞉, Fa꞉lo꞉wa꞉ ene ayamilo꞉ misa꞉ kaluwo꞉lo꞉, Isib hen amilo꞉ misa꞉ kaluwo꞉lo꞉, Yosa꞉b ene eso꞉lo꞉wo꞉lo꞉, ao iyo꞉lo꞉, a꞉la꞉ta꞉ga꞉ ene iya sowo꞉ a꞉ma꞉ eso꞉lo꞉wo꞉lo꞉, iyo꞉ tambo Ka꞉ina꞉n hen a꞉na ane. Iyo꞉ ha꞉nakiyo꞉, ini so꞉wagalino꞉ a꞉la꞉ta꞉ga꞉ no꞉ fofo꞉wo꞉lo꞉ Gosen hen a꞉naka ta꞉ta꞉i ane. ");
INSERT INTO bco_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kalu nolo꞉ ho꞉sa꞉ wa꞉la kandayaki, nolo꞉ i fofodo꞉ susululia꞉ ha꞉na꞉sen a꞉nami kandayaki, a꞉la꞉ta꞉ga꞉yo꞉ kaluwo꞉ modo꞉ ko꞉lo꞉ Yosa꞉b o꞉lia꞉ ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Iyo꞉ ha꞉na꞉sa꞉ga꞉, da꞉si bebdo꞉ dila꞉sen hen, Atad, a꞉na fa꞉la꞉dowo꞉. Hen a꞉no꞉ ho꞉n Yodan a꞉no꞉ nodowa a꞉lab. Hen a꞉namio꞉ iyo꞉ ho꞉len dom a꞉la꞉fo꞉wo꞉ ene iyayo꞉ mada alan nofolaki, ogolo ya꞉la꞉liki kuo꞉ya꞉li sen. ");
INSERT INTO bco_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ka꞉ina꞉n kaluka꞉isale a꞉namilo꞉ sen a꞉ma꞉yo꞉, nofolakilo꞉ ya꞉fodab a꞉no꞉ ba꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Isib kaluwo꞉ alan nofolaki ya꞉fodab.” A꞉la꞉gabi ba꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ hen a꞉no꞉ A꞉ibol-Mislaim a꞉la꞉wikilo꞉. Hen a꞉no꞉ ho꞉n Yodan a꞉no꞉ nodowa a꞉lab. ");
INSERT INTO bco_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","A꞉la꞉go꞉ko꞉lo꞉ Ya꞉koba꞉ insiso꞉i iliyo꞉ elo꞉ tamin amilo꞉ imo꞉lo꞉ dinali sio꞉ au dimidaki, iliyo꞉ ene do꞉mo꞉wo꞉ Ka꞉ina꞉n hena a꞉ma꞉la꞉ dia꞉ha꞉na꞉sa꞉ga꞉, Mamele hen doba꞉da꞉, Makbela hen a꞉namio꞉, u a us a꞉nami dali alifa꞉. Tamin amio꞉ hen a꞉no꞉ Hit kalu Eflon eno꞉ ko꞉lo꞉ Ablaham eyo꞉ ilo꞉ dali alita꞉mela꞉no꞉ hen ko꞉lo꞉ kilili. ");
INSERT INTO bco_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yosa꞉b eyo꞉ iyayo꞉ dali alita꞉ga꞉yo꞉, e o꞉lia꞉, ene ao i o꞉lia꞉, a꞉la꞉ta꞉ga꞉ egeledo꞉ ane a꞉no꞉ tambo a꞉ma꞉la꞉ Isib ane. ");
INSERT INTO bco_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ili iyayo꞉ sowa꞉sa꞉ga꞉ dowabikiyo꞉, Yosa꞉ba꞉ ao iyo꞉ egelebo꞉ nenelaki a꞉la꞉sio꞉, “Wai! Yosa꞉bo꞉lo꞉ mogago꞉ nililo꞉ dimido꞉ a꞉no꞉ eyo꞉ o꞉asulufo꞉la꞉ga꞉yo꞉, nimo꞉wo꞉ a꞉ma꞉la꞉yo꞉ wa꞉dema꞉nigaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Iliyo꞉ a꞉la꞉bo꞉ asula꞉sa꞉ga꞉, Yosa꞉b emo꞉wo꞉ towo꞉ a꞉la꞉saga꞉fo꞉, “Go꞉la꞉yo꞉ o꞉soma꞉ni ilikiyo꞉, nimo꞉wo꞉ a꞉la꞉dinali sio꞉, ‘Giliyo꞉ Yosa꞉bo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, “Gao iya꞉lo꞉ gemo꞉lo꞉ hala dimido꞉ a꞉no꞉ giyo꞉ imo꞉wo꞉ foga꞉le sa꞉la꞉sa꞉ga꞉ ga꞉lila꞉bi.”’ Go꞉la꞉yo꞉ a꞉la꞉sio꞉ ko꞉lo꞉, nilido꞉ mogago꞉ gemo꞉lo꞉ dimido꞉ a꞉no꞉ giyo꞉ mada ga꞉lila꞉ma꞉ki asulab.” Yosa꞉b eyo꞉ to ililo꞉ saga꞉fo꞉ a꞉no꞉ da꞉da꞉ga꞉yo꞉ ya꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Da꞉da꞉sa꞉ga꞉ elena, ao iyo꞉ Yosa꞉bdo꞉wa ya꞉ga꞉yo꞉, iyo꞉ hena tulu fufudaki a꞉la꞉sio꞉, “Nio꞉ gi madali nanog dian kaluwo꞉ o꞉li doma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Ko꞉sega Yosa꞉b eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Gio꞉ tagila꞉so꞉bo! Ne Gode o꞉ngo꞉ma ko꞉lo꞉ niyo꞉ giyo꞉ mo꞉wa꞉dema꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Giliyo꞉ ne mogaima꞉no꞉ asulaki dimido꞉ ko꞉sega, gililo꞉ nemo꞉lo꞉ mogago꞉ dimido꞉ a꞉ma꞉yo꞉ Gode eyo꞉ a꞉nodola꞉sa꞉ga꞉ ne amio꞉ nanog nafa fa꞉la꞉doma꞉ki ta꞉fo꞉. Kaluka꞉isale modo꞉wo꞉ sowabena꞉ki, kelego꞉ ko꞉lilo꞉ nelo꞉ elendo꞉ amilo꞉ fa꞉la꞉dosdo꞉ a꞉no꞉ Godeya꞉ ene da꞉fe alifa꞉ ko꞉lo꞉, kelego꞉ o꞉gdo꞉ fa꞉la꞉dosda꞉i mio꞉ a꞉no꞉ gio꞉ ba꞉dab. ");
INSERT INTO bco_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ kele asula꞉so꞉bo. Gio꞉lo꞉ gini so꞉wayo꞉lo꞉ kelego꞉ aundo꞉ma dowab a꞉no꞉ niyo꞉ dimida mea꞉mela꞉no꞉.” A꞉la꞉gakiyo꞉ Yosa꞉b eyo꞉ ao iyo꞉ ha꞉sa mesea꞉ki ha꞉nolo sio꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosa꞉b e Isib hen a꞉naka sen, a꞉la꞉ta꞉ga꞉ iyaya꞉ eso꞉lo꞉wo꞉lo꞉ hen a꞉naka sen. Yosa꞉b e donayo꞉ 110 a꞉la꞉fo꞉ gulula꞉. ");
INSERT INTO bco_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yosa꞉b e ene A꞉flama꞉ inso꞉ o꞉lia꞉ a꞉ma꞉ inso꞉wo꞉lo꞉ ba꞉ba꞉ a꞉la꞉ta꞉ga꞉ Manasaya꞉ inso꞉ Makila꞉ ene inso꞉wo꞉ sa꞉la꞉liab amio꞉, so꞉wa a꞉no꞉ eno꞉le a꞉la꞉widaki, Yosa꞉b eyo꞉ ta꞉ulia꞉ga꞉ fo꞉fo꞉le asi. ");
INSERT INTO bco_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yosa꞉b eyo꞉ ao imo꞉wo꞉ a꞉la꞉sio꞉, “Ne ko꞉na꞉ma soma꞉nigo꞉l ko꞉sega, Gode eyo꞉ gio꞉ asuwa꞉fa꞉ni mia꞉ib ko꞉lo꞉, Ablahambo꞉lo꞉, Aisa꞉gbo꞉lo꞉, Ya꞉kobo꞉lo꞉ dinali sio꞉ hen a꞉na, a꞉ma꞉la꞉ tililia꞉ga꞉ ha꞉na꞉ib.” ");
INSERT INTO bco_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","A꞉la꞉ta꞉ga꞉ Yosa꞉b eyo꞉ Isolael eso꞉lo꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ gio꞉ mada asuwa꞉fa꞉ib ko꞉lo꞉, gio꞉ Isibo꞉ ta꞉ta꞉ga꞉ ha꞉nakiyo꞉, ni kiyo꞉ dia꞉ga꞉ ha꞉na꞉no꞉ a꞉la꞉liki nemo꞉wo꞉ dinali sama.” ");
INSERT INTO bco_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","A꞉la꞉fo꞉ko꞉lo꞉ Yosa꞉b e donayo꞉ 110 a꞉la꞉fo꞉wo꞉ gulula꞉sa꞉ga꞉ sowabiki, ene do꞉mo꞉wo꞉ mo꞉hesema꞉ki, mulumulo꞉wo꞉ e do꞉mo꞉wa mulula꞉sa꞉ga꞉, i bokisi usa disa꞉la꞉sa꞉ga꞉, Isib a꞉na dia꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Kamolo꞉ di kaluwa꞉lo꞉ bo꞉fo꞉len ho꞉len a꞉namio꞉ Isolael kaluka꞉isaleyo꞉ maiyo꞉wo꞉ alan dowo꞉. Kalu nowo꞉ a꞉na elen, ene wiyo꞉ A꞉lema꞉la꞉g. Ingaya꞉ wiyo꞉ Na꞉omi. Inso꞉ a꞉la꞉ma꞉ wiyo꞉ Malon, nowo꞉ Kilion. E so꞉lo꞉ a꞉ma꞉ mo꞉mio꞉wo꞉ A꞉fla꞉ta. Iyo꞉ Yuda hen, Ba꞉diliha꞉m amisa꞉n a꞉na sen amio꞉, maiyo꞉wo꞉ alan dowabiki, Ba꞉diliha꞉m a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, Moab hen a꞉na ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Moab a꞉na sen ami, A꞉lema꞉la꞉go꞉ a꞉na sowo꞉. A꞉lema꞉la꞉g e a꞉na sowabikiyo꞉, Na꞉omiyo꞉ a꞉la꞉ta꞉ga꞉ inso꞉ a꞉la꞉ko꞉ a꞉naka sen. ");
INSERT INTO bco_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","A꞉na silikiyo꞉, inso꞉ a꞉la꞉ma꞉yo꞉ Moab ka꞉isale ko꞉lo꞉ di. Ga wiyo꞉ nowo꞉ Oba, nowo꞉ Lud. ");
INSERT INTO bco_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Gayo꞉ dia꞉sa꞉ga꞉ sena, Malon dia꞉ Kilion dia꞉yo꞉ a꞉na sowo꞉. Iyo꞉ a꞉namilo꞉ seno꞉ donayo꞉ do꞉la꞉fo꞉ ko꞉lo꞉ gulula꞉. Inso꞉ a꞉la꞉ a꞉no꞉ sowabikiyo꞉, Na꞉omiyo꞉ e fo꞉fo꞉dolo alifa꞉, mo꞉wo꞉ ene in o꞉lia꞉ so꞉wa o꞉lia꞉yo꞉ aundo꞉ma. ");
INSERT INTO bco_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Na꞉omiyo꞉ a꞉la꞉ta꞉ga꞉ ena꞉su a꞉la꞉yo꞉ a꞉na sen ami, Na꞉omi e to nowo꞉ a꞉la꞉dabu. Ene hen a꞉namio꞉, Yawe eyo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ alan dimiaka꞉, a꞉la꞉sio꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, iyo꞉ a꞉ma꞉la꞉ Na꞉omiya꞉ hena ha꞉na꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Iyo꞉ ayo꞉ ta꞉ta꞉ga꞉ ha꞉na꞉ga꞉yo꞉, tog alan Yuda hen amilo꞉ ha꞉na꞉sen a꞉na o꞉kagataka, ");
INSERT INTO bco_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","ena꞉su a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Gaino꞉ ge kalu sowo꞉ a꞉la꞉mo꞉wo꞉lo꞉, nemo꞉wo꞉lo꞉ man nafa dimido꞉ ko꞉lo꞉, Yawe eyo꞉ ga꞉gdo꞉ ha꞉nab amio꞉ asuwa꞉taki, nafale mesea꞉ki ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","Ga꞉go꞉ kalu ho꞉giyo꞉ dimia꞉sa꞉ga꞉ nafa mesea꞉kiyo꞉, Yawe emo꞉wo꞉ niyo꞉ dulugu sa꞉la꞉mela꞉no꞉. O꞉go꞉ ne no꞉no꞉n hena ho꞉no꞉l ko꞉lo꞉, ga꞉go꞉lo꞉ wenaka ta꞉bi,” a꞉la꞉sio꞉. A꞉la꞉sa꞉labiki a꞉la꞉yo꞉ Na꞉omiya ta꞉li dofo꞉liki alan ya꞉fodo꞉. ");
INSERT INTO bco_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Ya꞉la꞉likiyo꞉ a꞉la꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Na꞉no꞉ nani ayamio꞉ mo꞉ha꞉na꞉no꞉. Na꞉no꞉ gi so꞉lo꞉lo꞉ sab a꞉na, ua ha꞉na꞉no꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","13","Ko꞉sega Na꞉omiya꞉ ena꞉su a꞉la꞉mo꞉ sa꞉laki, “Ga꞉go꞉, nelo꞉ a꞉kudu ya꞉so꞉bo! Mo꞉wo꞉ ne anaso꞉ ko꞉m. Ga꞉gdo꞉ dia꞉no꞉ kalu so꞉wa nowo꞉, ne aundo꞉ma. Ne kaluwo꞉ a꞉ha꞉na꞉ga꞉, kalu so꞉wa a꞉la꞉ nowo꞉ a꞉na a꞉sa꞉la꞉lia꞉no꞉ kibo꞉bowo꞉, ga꞉go꞉ o꞉yasila꞉ga꞉yo꞉, a꞉na sili alifa꞉no꞉malo꞉ka꞉. Ga꞉go꞉ mada gaina꞉ aya ha꞉na꞉sia꞉bi! Yawe eyo꞉ ne gola ba꞉ba꞉ ko꞉m, ko꞉lo꞉ nilo꞉ halelia꞉sa꞉ga꞉lo꞉ hida꞉yo꞉ dio꞉l we, ga꞉g amio꞉lo꞉ golab.” Na꞉omi eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","A꞉la꞉do꞉ sa꞉lab a꞉no꞉ a꞉la꞉ma꞉yo꞉ da꞉da꞉sa꞉ga꞉, wa꞉ka ya꞉fodo꞉. A꞉la꞉ta꞉ga꞉ Obayo꞉ mimila꞉sa꞉ga꞉ ha꞉nabiki, Ludo꞉ Na꞉omi eya ta꞉li dofo꞉len. ");
INSERT INTO bco_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Na꞉omiya꞉ Lud emo꞉ sa꞉laki, “Obayo꞉ e hen enedo꞉wa, gode enedo꞉wa, a꞉ma꞉la꞉ ha꞉nabo꞉lo꞉ka꞉! Gelo꞉ a꞉ma꞉la꞉ doma꞉ni hamana!” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Ko꞉sega Lud eyo꞉ Na꞉omimo꞉ sa꞉laki, “Giyo꞉ ne ta꞉fo꞉ hamana a꞉la꞉bo꞉, nemo꞉wo꞉ sa꞉la꞉so꞉bo! Nelo꞉, gelo꞉ ha꞉naba mia꞉no꞉” a꞉la꞉sio꞉. “Hen o꞉ba mida꞉iya꞉le, gelo꞉ ha꞉nab a꞉na, nelo꞉ a꞉na mia꞉no꞉. Gode gilo꞉wo꞉, Gode nino꞉ doma꞉ib. Ge Isolael ga ko꞉lo꞉, nelo꞉ Isolael ga doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Gelo꞉ sowa꞉sa꞉ga꞉lo꞉ daidab hen a꞉na nelo꞉ a꞉na dalima꞉ib. Niyo꞉ gemo꞉wo꞉ towo꞉ dinali so꞉lo꞉l. Na꞉n sowakiya, na꞉no꞉ a꞉na aloba꞉ma꞉ib. Ko꞉sega na꞉no꞉ mo꞉ nowa a꞉la꞉ta꞉ga꞉ aloba꞉dalega, Yawe eyo꞉ nemo꞉wo꞉ a꞉ma꞉la꞉ wa꞉dema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Luda꞉lo꞉ dinali sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, Na꞉omi eyo꞉ wa꞉kabiyo꞉ towo꞉ mo꞉kudu sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","A꞉la꞉fo꞉ko꞉lo꞉ a꞉la꞉yo꞉ ha꞉na꞉ni ane. A꞉la꞉yo꞉ ha꞉na꞉sa꞉ga꞉, Ba꞉diliha꞉m hen a꞉na fa꞉la꞉dowo꞉. A꞉na fa꞉la꞉dowabiki, Ba꞉diliha꞉m amisa꞉n kaluka꞉isale a꞉ma꞉yo꞉ iliga꞉sa꞉ga꞉, amisa꞉n ka꞉isale i a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Ga we Na꞉omiya꞉le?” ");
INSERT INTO bco_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","A꞉la꞉sa꞉labiki, Na꞉omiya꞉ imo꞉ a꞉ma꞉la꞉ sa꞉laki, “Giliyo꞉, ne Na꞉omi a꞉la꞉bo꞉ sa꞉la꞉so꞉bo! Ne ‘Mala,’ a꞉la꞉sama. Mo꞉wo꞉ Halaido꞉lo꞉ A꞉lab Gode eyo꞉ hida꞉yo꞉ alano꞉ nemo꞉ dimi ko꞉lo꞉ ne haleli ko꞉lo꞉ yo꞉l.” ");
INSERT INTO bco_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","“Ne tamin amio꞉ Isolael a꞉la꞉ta꞉ga꞉lo꞉ Moab hen a꞉na ha꞉nakiyo꞉, ne ego꞉ ane ko꞉sega, o꞉go꞉ ne a꞉ma꞉la꞉ Isolael wena a꞉fa꞉la꞉doma꞉ni yakiyo꞉, ne fo꞉fo꞉dolo꞉ yo꞉l” a꞉la꞉sio꞉. “Yawe eyo꞉ ne gola ba꞉daki, nemo꞉wo꞉ hida꞉yo꞉ dimi. A꞉la꞉fo꞉ko꞉lo꞉, giliyo꞉ ne ‘Na꞉omi’ a꞉la꞉bo꞉ sa꞉la꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","A꞉la꞉do꞉ fa꞉la꞉dowo꞉ a꞉namio꞉, Na꞉omi e Moab a꞉la꞉ta꞉ga꞉ Ba꞉diliha꞉m amisa꞉na a꞉ma꞉la꞉ mio꞉. A꞉la꞉ta꞉ga꞉ Moab ga ena꞉su Lud elo꞉ e kudu mio꞉ ko꞉lo꞉ fa꞉la꞉dowo꞉. A꞉la꞉lo꞉ fa꞉la꞉dowo꞉ ho꞉len a꞉namio꞉, da꞉si balilo꞉ tuma꞉no꞉ elen. ");
INSERT INTO bco_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ho꞉len a꞉namio꞉ A꞉lema꞉la꞉ga꞉ ene so꞉lo꞉ amilo꞉ wabulun kalu imilig nowo꞉ a꞉na sen. Kalu a꞉ma꞉ wiyo꞉, Boas ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","3","A꞉la꞉ta꞉ga꞉ Moab ga Lud eyo꞉ Na꞉omimo꞉ sa꞉lakiyo꞉, “Kalu abeyo꞉ nelo꞉ asuwa꞉fa꞉no꞉ dowab a꞉no꞉, ne ene egelo꞉wa ha꞉na꞉sa꞉ga꞉, iliyo꞉ da꞉si bali fo a꞉no꞉ tuda꞉sa꞉ga꞉ ha꞉nab amio꞉, ne tifa ha꞉naki, bali fo wa ko꞉lo꞉ sudufa꞉lab a꞉no꞉ ne kegenema꞉no꞉. A꞉no꞉ o꞉liya꞉le?” a꞉la꞉dabu ba꞉ba꞉. Na꞉omi eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, “O꞉lika꞉, ge hamana.” A꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉ga꞉, Ludo꞉ da꞉si balilo꞉ tula꞉labdo꞉ hen a꞉na ha꞉na꞉ni ane. A꞉na ha꞉na꞉ga꞉ fa꞉la꞉dowa ba꞉ba꞉ amio꞉, iyo꞉ da꞉si baliyo꞉ tula꞉li ha꞉nabi ba꞉ba꞉. A꞉la꞉fo꞉ko꞉lo꞉ e ha꞉na꞉sa꞉ga꞉, da꞉si bali wa ta꞉fo꞉ a꞉no꞉ e kegea꞉liki a꞉na elen. Egelo꞉ hen a꞉no꞉, kalu a꞉ma꞉no꞉lo꞉b a꞉la꞉bo꞉, Ludo꞉ e mo꞉asulo꞉. Ko꞉sega hen a꞉no꞉ Boas eno꞉. A꞉lema꞉la꞉ga꞉ ene eso꞉lo꞉ nowo꞉ e. ");
INSERT INTO bco_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Lud e a꞉na kegea꞉liki elen amio꞉, Boas e Ba꞉diliha꞉m a꞉la꞉ta꞉ga꞉yo꞉ ene egelo꞉wa fa꞉la꞉dowo꞉. E fa꞉la꞉dowakiyo꞉, ene nanogdo꞉ dia꞉sen kalu imo꞉wo꞉ sagalo꞉ towo꞉ ho꞉le sa꞉lakiyo꞉, “Yawe eyo꞉ gio꞉ bo꞉fo꞉len.” A꞉la꞉sa꞉labiki, nanogdo꞉ dia꞉sen kalu iliyo꞉ a꞉ma꞉la꞉ sa꞉laki “A꞉, Yawe eyo꞉ gelo꞉ tili dofo꞉mela꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","A꞉la꞉ta꞉ga꞉ Boas eyo꞉ nanogdo꞉ bo꞉fo꞉len kalu o꞉mo꞉ dabu ba꞉ba꞉, “Ga tif amilo꞉ dia꞉lab hoso o꞉ba?” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","To elo꞉ sa꞉lab a꞉no꞉ da꞉da꞉ga꞉, nanogdo꞉ bo꞉fo꞉len kalu a꞉ma꞉ sa꞉laki, “Ga hoso, Moab ga ko꞉lo꞉, Na꞉omi o꞉lia꞉lo꞉ mio꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","E kea꞉fo ya꞉ga꞉, nemo꞉ dabu ba꞉dakiyo꞉ a꞉la꞉sio꞉, ‘Bali wa sulufo꞉sia꞉yo꞉ ne kegenema꞉no꞉wo꞉ o꞉liya꞉le?’ A꞉la꞉dabu ba꞉dabiki, niyo꞉ ‘O꞉lika꞉’ a꞉la꞉sio꞉ ko꞉lo꞉, e a꞉na dia꞉likilo꞉ mio꞉wo꞉, ha꞉fo꞉la꞉su dota꞉ga꞉, nanogo꞉ dia꞉lab.” ");
INSERT INTO bco_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","A꞉no꞉ da꞉da꞉sa꞉ga꞉, Boas e Lud elo꞉wa kagayaka, a꞉la꞉sio꞉, “Ga, ge nanogo꞉ wenaka dia꞉liki ta꞉bi. Ge hen nol amio꞉ da꞉si baliyo꞉ kegenema꞉nikiyo꞉ ha꞉na꞉so꞉bo. Ni nanogdo꞉ dia꞉sen ka꞉isale we o꞉lia꞉ ani dia꞉i ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Ilo꞉ nanogdo꞉ diab hen a꞉no꞉ ba꞉da꞉sa꞉ga꞉, gelo꞉ i a꞉no꞉ ko꞉lo꞉ kudu ha꞉naki, nanogo꞉ a꞉na dia꞉bi. Niyo꞉ na꞉ nanog kalu imo꞉wo꞉ ge amio꞉ gola꞉so꞉boka꞉ a꞉la꞉salifa꞉. A꞉la꞉ta꞉ga꞉, ge ho꞉n maiyalega, ho꞉n wasula꞉ hoso, gelo꞉ ma꞉ ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Boas eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉ dowabiki, Lud e hena misa꞉fu siliki a꞉la꞉sio꞉, “Ne Isolael ka꞉isalema, ne ha꞉la꞉ ga. Giyo꞉ nemo꞉wo꞉ mada nafa dimidab ko, ne waga asula꞉sa꞉ga꞉ gaya?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boas eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Ge kaluwo꞉ sowab amio꞉, go꞉no꞉n heno꞉lo꞉, so꞉lo꞉wo꞉lo꞉ ta꞉taki, o꞉go꞉ ge hen ho꞉gi, gelo꞉ mo꞉ba꞉dan, wena mesa꞉ni mio꞉ ko꞉lo꞉, gilo꞉ man nafale ko꞉lo꞉ ga꞉sumo꞉lo꞉ dimido꞉ a꞉no꞉ ne tambo dabu. A꞉la꞉fo꞉ko꞉lo꞉ a꞉na ilikiyo꞉, niyo꞉ ge asuwa꞉to꞉l. ");
INSERT INTO bco_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Gilo꞉ man nafa dimida꞉len a꞉na ilikiyo꞉, Yawe eyo꞉lo꞉ gemo꞉wo꞉ wa꞉lo꞉ nafa dimina꞉ki asulab. Ge ha꞉fa꞉nolo mesa꞉no꞉ a꞉lakiyo꞉, Isolaela꞉ Gode ene kanulo꞉ a꞉ma꞉yo꞉ ge go꞉lu alitaki tilidoma꞉ki, ge wena mio꞉ ko꞉lo꞉, eyo꞉ wa꞉lo꞉ gemo꞉wo꞉ mada dimia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, Lud eyo꞉ a꞉la꞉sio꞉, “Ne gi nanog dian gama ko꞉sega, giyo꞉ nemo꞉wo꞉ ha꞉fo꞉ disa꞉laki, madali asuwa꞉tab. Gilo꞉ man nafa dimidab a꞉ma꞉yo꞉ ni asulo꞉wo꞉ ko꞉lo꞉ sagale alitakigab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","A꞉la꞉ta꞉ga꞉ iliyo꞉ ma꞉no꞉ ma꞉niki kegeakiyo꞉, Boas eyo꞉ Ludo꞉lo꞉ ho꞉lelia꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Gelo꞉ ya꞉ga꞉ ma꞉no꞉ nakiyo꞉, ma꞉n heb a꞉no꞉ wain ho꞉n wena gelema꞉ni mena.” A꞉la꞉sa꞉labiki Lud e nanog dia꞉leno꞉ ta꞉ta꞉ga꞉, ma꞉no꞉ ma꞉ni ane. Lud e nanogdo꞉ dia꞉len kaluka꞉isale o꞉lia꞉ sabiki, Boas eyo꞉ da꞉si bali dele so꞉fa꞉ a꞉no꞉lo꞉ emo꞉ dimiabiki, a꞉na mo꞉no꞉. Eyo꞉ ma꞉no꞉wo꞉ na꞉i ha꞉na꞉sa꞉ga꞉ o꞉li dowabiki, hebo꞉ ka difa꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Ma꞉no꞉wo꞉ na꞉sa꞉ga꞉, Ludo꞉ nanogo꞉ a꞉ma꞉la꞉ dia꞉ni ha꞉nabiki, Boasa꞉ ene nanogdo꞉ dian kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ga a꞉ma꞉yo꞉ da꞉si bali bobodo꞉ anib amilo꞉ sulufa꞉lab a꞉no꞉ kegealega, giliyo꞉ emo꞉wo꞉ sendeloma꞉no꞉ towo꞉ sa꞉la꞉so꞉bo! ");
INSERT INTO bco_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ko꞉sega giliyo꞉ da꞉si bali fowo꞉ bobodakiyo꞉, gililo꞉ bobodo꞉ us a꞉namio꞉ heb nolo꞉ emo꞉ dima꞉ki, a꞉ma꞉la꞉ suduto꞉lo fela꞉bi. A꞉la꞉ta꞉ga꞉ emo꞉wo꞉ towo꞉ halalebo꞉ sa꞉la꞉so꞉boka꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","18","Lud e nanogo꞉ dia꞉i ha꞉na꞉sa꞉ga꞉, ga꞉lo aya ha꞉na꞉nikiyo꞉, da꞉si bali elo꞉ kegea꞉i mio꞉ a꞉no꞉, fowo꞉ fifi alima꞉ki a꞉na basio꞉. Basia꞉la꞉ga꞉, bali foleyo꞉ a꞉na disa꞉la꞉sa꞉ga꞉, wo꞉fa꞉ imilig ko꞉lo꞉ ga꞉lita꞉ga꞉ amio꞉, ma꞉no꞉ heb elo꞉ difa꞉ a꞉no꞉lo꞉ dia꞉sa꞉ga꞉ ane. E ha꞉na꞉ga꞉, Na꞉omilo꞉ sab amisa꞉n a꞉na fa꞉la꞉dowo꞉. Da꞉si bali wo꞉fa꞉ alan a꞉no꞉ a꞉la꞉ta꞉ga꞉ ma꞉no꞉ heb elo꞉ dia꞉mio꞉ a꞉no꞉, Na꞉omimo꞉ wida꞉sa꞉ga꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Na꞉omi eyo꞉ ba꞉da꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Ge mada nanog we abelo꞉wa dio꞉? Ma꞉no꞉ we abe meabeyo꞉? Kalu gelo꞉ asufa꞉ a꞉no꞉, Gode eyo꞉ emo꞉wo꞉ sagale alifa꞉ib,” a꞉la꞉sio꞉. Luda꞉ ena꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “O꞉go꞉ ne ha꞉na꞉sa꞉ga꞉lo꞉ nanogdo꞉ di we, Boasa꞉ ene egelo꞉wa dia꞉la꞉ga꞉ mio꞉.” A꞉la꞉fo꞉ko꞉lo꞉ Boas elo꞉ dimido꞉wo꞉ tambo, Na꞉omimo꞉ malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Luda꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉, Na꞉omi eyo꞉ a꞉la꞉sio꞉, “Yawe eyo꞉ na꞉ndo꞉ ta꞉i ha꞉na꞉no꞉wo꞉lo꞉, sowo꞉ ta꞉fo꞉ mio꞉ a꞉no꞉lo꞉ asulufo꞉ mela꞉no꞉ a꞉laki go꞉. Gode eyo꞉ kalu welo꞉ dowa꞉i ha꞉na꞉no꞉wo꞉ tif amio꞉ asuwa꞉foma꞉ki asulab. Hendele, kalu a꞉no꞉ nili ho꞉bo꞉wa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉wo꞉ e ko꞉lo꞉, eyo꞉ na꞉no꞉ ko꞉lo꞉ asuwa꞉taki tili dofo꞉mela꞉ib.” Na꞉omi eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","A꞉la꞉sa꞉labiki Lud e sa꞉laki, “Boas eyo꞉ to nowo꞉ nemo꞉wo꞉ a꞉la꞉salabe, ‘Ni nanog dian kaluka꞉isale we o꞉lia꞉ dia꞉i ha꞉na꞉la꞉ga꞉, nanogdo꞉ kedetaba eda꞉bi.’ ” ");
INSERT INTO bco_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","A꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, Na꞉omi eyo꞉ a꞉la꞉sio꞉, “Ge Boasa꞉ ene nanog dian ka꞉isale so꞉wa o꞉lia꞉ dia꞉ni ha꞉na꞉lubi. Kalu nolba꞉yo꞉ ge mogagabena꞉kiyo꞉, egelo꞉ noma꞉lo꞉ amio꞉ dia꞉ni ha꞉na꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","A꞉la꞉fo꞉ko꞉lo꞉ e Boas ene nanog dian ka꞉isale o꞉lia꞉ egele dia꞉i ha꞉na꞉leno꞉, da꞉si bali o꞉lia꞉ da꞉si wit o꞉lia꞉ tula꞉leno꞉ kedetabiki, a꞉na edo꞉. Ho꞉len a꞉namio꞉ Ludo꞉ ena꞉su o꞉lia꞉ sen. ");
INSERT INTO bco_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Ho꞉len imilig no amio꞉, Na꞉omi eyo꞉ a꞉la꞉sio꞉, “Ge nafa mesea꞉ki, kaluwo꞉ ni kelema꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ka꞉isale so꞉wa gegeledo꞉ egelo꞉ amilo꞉ nanogdo꞉ dian i o꞉lo꞉ bo꞉fo꞉lowan kaluwo꞉ Boas ko꞉lo꞉ e nio꞉ so꞉lo꞉ imilise. O꞉g nuluwo꞉, eyo꞉ nanogo꞉ da꞉si bali bebdo꞉ dila꞉mela꞉nikilo꞉ kegea꞉sen hen a꞉na dia꞉nigab. Da꞉si bali beb a꞉no꞉ fa꞉fa꞉sa꞉ dia꞉hamana꞉ki, a꞉na tagu talola꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","A꞉la꞉fo꞉ko꞉lo꞉ ge ho꞉no꞉ mulula꞉b, helebeso꞉g ho꞉giyo꞉ sa꞉ga꞉la꞉b, wa ho꞉no꞉ mulula꞉b, a꞉la꞉ta꞉ga꞉yo꞉ a꞉na handaloma꞉ ha꞉na꞉bi! Boas e ma꞉no꞉wo꞉ mo꞉mo꞉no꞉ ilikiyo꞉, eyo꞉ ge ba꞉dabena꞉ki, ge wo꞉no꞉le ha꞉na꞉ga꞉ dowa꞉bi. ");
INSERT INTO bco_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","E nanogo꞉ dia꞉la꞉ga꞉yo꞉, ma꞉no꞉wo꞉ ho꞉n o꞉lia꞉ na꞉sa꞉ga꞉, e alima꞉ mia꞉ib ko꞉lo꞉, elo꞉ alilabo꞉ giyo꞉ dinafa ba꞉da꞉bi. A꞉la꞉ta꞉ga꞉yo꞉ ge a꞉na ha꞉na꞉ga꞉, elo꞉ so꞉g go꞉lo꞉ a꞉no꞉, gido꞉fo꞉ gasa amilo꞉ a꞉no꞉ da꞉ga꞉ita꞉bi. Da꞉ga꞉itakiyo꞉ ge gido꞉fo꞉ gasalo꞉ doba꞉da꞉ alila꞉bi. Gilo꞉ dimidama꞉no꞉wo꞉, Boas eyo꞉ a꞉na sa꞉ma꞉ib.” Na꞉omi eyo꞉ a꞉la꞉walasio꞉. ");
INSERT INTO bco_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, Luda꞉ a꞉ma꞉la꞉ sa꞉laki, “Gilo꞉ sa꞉lab aumbo꞉ dimidama꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","A꞉la꞉ta꞉ga꞉ ena꞉suwa꞉lo꞉ to sio꞉ aumbo꞉ dimida꞉sa꞉ga꞉, Boas elo꞉ nanogdo꞉ dia꞉labdo꞉ hen a꞉na fa꞉la꞉doma꞉ni ane. A꞉na ha꞉na꞉sa꞉ga꞉yo꞉ e wo꞉no꞉le kagafo꞉len. ");
INSERT INTO bco_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Boas e ma꞉no꞉ o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ dinafa na꞉sa꞉ga꞉, nuluwo꞉ e mida꞉iyabiki, da꞉si bali folo꞉ dibido꞉ anib a꞉na alima꞉ni ane. E alilabiki ba꞉da꞉ga꞉yo꞉, Lud e ha꞉sa ha꞉na꞉ga꞉, Boasa꞉ gido꞉fo꞉ amilo꞉ so꞉g go꞉lo꞉ a꞉no꞉ da꞉ga꞉lia꞉ dia꞉ta꞉ga꞉, Lud e gido꞉fo꞉ gasalo꞉ a꞉na ali. ");
INSERT INTO bco_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Nulu us dowabiki, Boas e emegelaki, iligi dasila꞉sa꞉ga꞉, ga nowo꞉ e gido꞉fo꞉ gasalo꞉wa alifo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Boas e sa꞉laki, “Ge o꞉ba?” A꞉la꞉sa꞉labiki Luda꞉ sa꞉lakiyo꞉, “Ne Lud ko꞉lo꞉ mio꞉. Ge A꞉lema꞉la꞉ga꞉ ene eso꞉lo꞉ ho꞉bo꞉wo꞉ imiliselo꞉biki, ne gi ha꞉ga dowaki giyo꞉ ne dinafa tilidoma꞉ki, gemo꞉ dabu ba꞉ba꞉ni mio꞉ ko꞉lo꞉ so꞉l. A꞉la꞉fo꞉ko꞉lo꞉ so꞉g gilo꞉ go꞉lo꞉ ko hebo꞉ nelo꞉ go꞉lu alifoma.” ");
INSERT INTO bco_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Boas eyo꞉ Luda꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Gilo꞉ tamin amilo꞉ man nafa dimido꞉wo꞉, ne sagalo꞉. A꞉la꞉ta꞉ga꞉ o꞉go꞉ gilo꞉ nemo꞉lo꞉ dimidab ko, ne mada sagalab. Mo꞉wo꞉ ge kalu so꞉wa nafa sab a꞉namio꞉ ge mo꞉ o꞉lu ane. Ge nelo꞉ amilo꞉ mio꞉ we ne sagalab. A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ gelo꞉ dowa꞉i ha꞉nab amio꞉lo꞉, ge asuwa꞉foma꞉ki, asulo꞉l. ");
INSERT INTO bco_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Nelo꞉ wena mio꞉lo꞉biki, gilo꞉ to sa꞉lab ko, niyo꞉ o꞉li dimidama꞉no꞉ ko꞉lo꞉, ge kele asula꞉so꞉bo. Amisa꞉n kalu sab we tambowo꞉ ge digalo꞉ ka꞉isale a꞉la꞉ asulufo꞉lab. ");
INSERT INTO bco_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Gilo꞉ nemo꞉lo꞉ sa꞉lakilo꞉ ho꞉bo꞉wo꞉ imilise a꞉la꞉do꞉ sio꞉ a꞉no꞉ hendele ko꞉sega, ne ha꞉lu heb doba꞉da꞉ dowo꞉. Gelo꞉ tili doma꞉no꞉wo꞉ ge so꞉lo꞉leyo꞉ o꞉sab. ");
INSERT INTO bco_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","A꞉la꞉fo꞉ko꞉lo꞉ ali kea꞉fowo꞉ niyo꞉ emo꞉wo꞉ dabu ba꞉ba꞉ni ha꞉na꞉no꞉. Eyo꞉ ge dia꞉no꞉ka꞉lalega, ge ene bo꞉fo꞉mela꞉ib. Ko꞉sega e mo꞉eka꞉ a꞉lalega, ge mada no꞉no꞉n dia꞉no꞉ ko꞉lo꞉, Yawe ene siwa꞉la gemo꞉ dinali salito꞉l. A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ ge a꞉naka alita꞉ga꞉, ali kea꞉fo ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","A꞉la꞉fo꞉ko꞉lo꞉ nulu a꞉namio꞉, Lud e Boasa꞉ gido꞉fo꞉ gasalo꞉ a꞉naka ali. Kalu nolba꞉yo꞉ Lud e a꞉na mia꞉lo꞉b a꞉la꞉bo꞉ mo꞉bo꞉ba꞉ki, e kea꞉fo nulu dasi. A꞉la꞉ta꞉ga꞉ Boas eyo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale nolbo꞉wo꞉ ge hen wena mio꞉ka꞉ a꞉la꞉bo꞉ malola꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Lud e kea꞉fo nulu dasila꞉sa꞉ga꞉ ha꞉na꞉nigabiki, Boasa꞉ sa꞉laki, “Gi helebeso꞉g wa꞉l amilo꞉ go꞉lo꞉ ko wena fele alifoma.” Lud eyo꞉ helebeso꞉go꞉ a꞉na fele alitabiki, da꞉si baliyo꞉ wo꞉fa꞉ a꞉la꞉yo꞉ o꞉ngo꞉ ko꞉lo꞉ koloda꞉sa꞉ga꞉ dimi. A꞉la꞉ta꞉ga꞉ Ludo꞉ kea꞉fo nulu ha꞉nabiki, Boas elo꞉ Ba꞉diliha꞉m amisa꞉n a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ludo꞉ ha꞉na꞉sa꞉ga꞉, Na꞉omi elo꞉wa fa꞉la꞉dowo꞉. E a꞉na fa꞉la꞉dowabikiyo꞉, Na꞉omi eyo꞉ Ludbo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Boas eyo꞉ gemo꞉wo꞉ waga sa꞉labeyo꞉?” A꞉la꞉dabu ba꞉dabiki, Boas elo꞉ to sio꞉wo꞉ Lud eyo꞉ tambo malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","A꞉la꞉ta꞉ga꞉ Luda꞉ sa꞉laki, “Da꞉si welo꞉, Boasa꞉ nemo꞉ dimiabeka꞉. Boas eyo꞉ nemo꞉wo꞉ a꞉la꞉sio꞉, ‘Ge Na꞉omilo꞉ amio꞉ madali fa꞉la꞉doma꞉ ha꞉na꞉no꞉wo꞉ mogago꞉lo꞉biki, da꞉si bali we o꞉lia꞉ dia꞉ hamana!’ a꞉labiki dia꞉mio꞉.” ");
INSERT INTO bco_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","A꞉la꞉sa꞉labiki Na꞉omiya꞉ sa꞉laki, “We mada o꞉li go꞉. Boas eyo꞉ gilo꞉ asulab a꞉no꞉ e nenelema꞉ni ha꞉na꞉ib. E a꞉ma꞉la꞉ ya꞉ga꞉lo꞉ sa꞉labo꞉ ko꞉lo꞉ da꞉ba꞉niki, ge ha꞉sa yasi ta꞉bi.” ");
INSERT INTO bco_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Ludo꞉ Na꞉omilo꞉wa fa꞉la꞉doma꞉ni ha꞉nabikiyo꞉, Boas e kalu Ludbo꞉lo꞉ sio꞉ a꞉no꞉ ko꞉lo꞉ Ba꞉diliha꞉m amisa꞉n a꞉na kelema꞉ni ane. E kalulo꞉ kegea꞉sen hen a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, kalu a꞉no꞉ a꞉na yasisen. A꞉na yasisen ami, A꞉lema꞉la꞉ga꞉ ene so꞉lo꞉leya a꞉la꞉ta꞉ga꞉lo꞉ ane kalu a꞉no꞉ a꞉na fa꞉la꞉dowo꞉. Kalu a꞉no꞉ a꞉na fa꞉la꞉dowabiki, Boas e sa꞉laki, “Nao, ge towo꞉ nain nenela꞉ma꞉nigo꞉l ko꞉lo꞉, wena mesa꞉ mena.” A꞉la꞉sa꞉labiki kalu a꞉no꞉ elo꞉wa mesa꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","A꞉la꞉ta꞉ga꞉ Boas eyo꞉ amisa꞉n ko꞉go꞉do꞉ kalu do꞉la꞉fo꞉wo꞉ tililia꞉ga꞉, a꞉na mesa꞉ mena꞉ki towo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","4","A꞉la꞉yo꞉ towo꞉ nenelakiyo꞉, Boas eyo꞉ a꞉la꞉sio꞉, “Na꞉omiyo꞉ Moabdo꞉ ane a꞉no꞉ a꞉ma꞉la꞉ mio꞉ ko꞉lo꞉, hen elo꞉wo꞉ kililia꞉no꞉ da꞉lab. Hen a꞉no꞉ nain nao, A꞉lema꞉la꞉g eno꞉ ko꞉lo꞉, go꞉no꞉n dia꞉no꞉ asulaba꞉le a꞉la꞉liki, nenelema꞉ni mio꞉. O꞉go꞉ hen a꞉no꞉ go꞉no꞉n dia꞉no꞉ asulalega, ko꞉go꞉do꞉ kalu i wema꞉ siwa꞉l amio꞉ ‘no꞉no꞉n kililia꞉no꞉ka꞉’ a꞉la꞉bo꞉ dinali sama. Mo꞉wo꞉ na꞉no꞉ A꞉lema꞉la꞉g ene so꞉lo꞉ imilise ko꞉sega, ne ha꞉lu ko꞉na꞉ dowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ gemo꞉wo꞉ tamina dabu bo꞉do꞉l. Ko꞉sega ge mo꞉bealega, nelo꞉ ko꞉na꞉ma dowo꞉ ko꞉lo꞉ ni kililia꞉nigo꞉l.” A꞉la꞉sa꞉labiki kalu a꞉ma꞉ sa꞉laki, “Heno꞉ no꞉no꞉n kililia꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","A꞉la꞉gabiki Boasa꞉ kalu o꞉mo꞉ sa꞉laki, “Heno꞉ gi kililiakiyo꞉, Moab ga sa꞉ba꞉lo꞉, Lud ko꞉lo꞉ mio꞉ a꞉no꞉lo꞉, gi dia꞉ib. Kalu sowo꞉ a꞉ma꞉ heno꞉ ene so꞉lo꞉ us a꞉naka dowaki, ene wiyo꞉ sa꞉la꞉i ha꞉na꞉melea꞉ki, ga sa꞉ba꞉lo꞉ a꞉no꞉ gi dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","A꞉la꞉sa꞉labiki kalu a꞉ma꞉ sa꞉lakiyo꞉, “Hen a꞉no꞉ ni dialega, ni so꞉waya꞉lo꞉ dabun dia꞉no꞉ dowo꞉ a꞉no꞉ mogaima꞉ib ko꞉lo꞉, niyo꞉ hen a꞉no꞉ mada mo꞉dia꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ gi kililima.” ");
INSERT INTO bco_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","8","Kalu a꞉ma꞉yo꞉ “Hen a꞉no꞉ gi ka kililima” a꞉la꞉sa꞉lakiyo꞉, ene budi gido꞉fo꞉ amilo꞉ ko꞉lo꞉ a꞉no꞉ dugu. Budi ko꞉lo꞉ duguwo꞉ mo꞉wo꞉ we. Mo꞉luwo꞉ Isolael iliyo꞉ hen kililia꞉nikiyo꞉, to saefa꞉ a꞉no꞉ wa꞉kabiyo꞉ mo꞉dimidama꞉no꞉ a꞉la꞉li elela꞉ sa꞉lakiyo꞉, kalu a꞉ma꞉ ene gido꞉fo꞉ amilo꞉ budi a꞉no꞉ duda꞉sa꞉ga꞉, kalu o꞉mo꞉ dimian. A꞉la꞉fo꞉ko꞉lo꞉ A꞉lema꞉la꞉g e so꞉lo꞉ a꞉ma꞉yo꞉ a꞉la꞉dimido꞉. ");
INSERT INTO bco_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","A꞉la꞉dimidabiki Boas eyo꞉ a꞉la꞉sio꞉, “Gi kegeo꞉ wema꞉yo꞉ naindo꞉ dimido꞉l we ba꞉dab. O꞉go꞉ A꞉lema꞉la꞉go꞉, ene so꞉wa a꞉la꞉, Malono꞉ Kiliono꞉ ili hen Na꞉omiya꞉lo꞉ bo꞉fo꞉lab a꞉no꞉ ni kililiyo꞉l. ");
INSERT INTO bco_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Kalu sowo꞉ a꞉ma꞉ heno꞉ ene so꞉lo꞉ us a꞉naka dowaki, ene wiyo꞉ sa꞉la꞉i ha꞉na꞉melea꞉ki, Malona꞉ inga sa꞉ba꞉lo꞉, Lud a꞉no꞉lo꞉ ni dia꞉no꞉. A꞉la꞉ta꞉ga꞉ Malona꞉ wi sa꞉sa꞉lo꞉wo꞉ ho꞉lefo꞉ ko꞉ ha꞉na꞉mela꞉ib. O꞉go꞉do꞉ nilido꞉ dimido꞉ we gio꞉lo꞉ ba꞉dab.” ");
INSERT INTO bco_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","A꞉la꞉sa꞉labiki ko꞉go꞉do꞉ kalu o꞉lia꞉ kaluka꞉isale nol a꞉namilo꞉ elen o꞉lia꞉ma꞉ sa꞉lakiyo꞉, “Gililo꞉ dimidab we nio꞉ bo꞉do꞉l. A꞉la꞉fo꞉ko꞉lo꞉ tif amio꞉ to nowo꞉ mo꞉sa꞉ma꞉ib. Tamin amio꞉ Lesol o꞉lia꞉ Lea o꞉lia꞉ma꞉yo꞉ so꞉wayo꞉ modo꞉ sa꞉la꞉la꞉sa꞉ga꞉, Isolael kaluka꞉isaleyo꞉ a꞉na fa꞉la꞉dowo꞉ ko꞉lo꞉, o꞉go꞉ Yawe eyo꞉ ga gilo꞉ diab wenamio꞉lo꞉ o꞉leau fa꞉la꞉do alifoma꞉ki asulo꞉l. A꞉la꞉ta꞉ga꞉ Ba꞉diliha꞉m amisa꞉n amio꞉ gi wiyo꞉lo꞉ mada alan doma꞉ki asulo꞉l. A꞉fla꞉ta so꞉lo꞉ gililo꞉ a꞉namio꞉ gi wiyo꞉ wabulun wa꞉la꞉b fa꞉la꞉doma꞉ki asulo꞉l. ");
INSERT INTO bco_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Yuda o꞉lia꞉ Temal o꞉lia꞉ma꞉ inso꞉, Beles e so꞉lo꞉ amilo꞉ kaluka꞉isale modo꞉ ko꞉lo꞉ fa꞉la꞉dowo꞉ auma꞉ib, Yawe eyo꞉ Boas gilo꞉ ga diab wenamio꞉lo꞉ so꞉lo꞉wo꞉ alan fa꞉la꞉dowa꞉i ha꞉na꞉melea꞉ki asulo꞉l.” Iliyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","A꞉la꞉fo꞉ko꞉lo꞉ Boas eyo꞉ Ludo꞉ di. Ludo꞉ dia꞉sa꞉ga꞉ sen amio꞉, Gode eyo꞉ Lud e ege alifa꞉ ko꞉lo꞉, Lud e so꞉wayo꞉ a꞉na alelo꞉. Alela꞉sa꞉ga꞉ kalu so꞉wayo꞉ a꞉na sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","So꞉wa sa꞉la꞉li a꞉no꞉ ba꞉da꞉ga꞉, amisa꞉n ka꞉isale nolba꞉yo꞉ Na꞉omimo꞉ sa꞉laki, “Niliyo꞉ Godeya꞉ wiyo꞉ dulugu sa꞉ma꞉niki, mo꞉wo꞉ Kalu Alana꞉yo꞉ so꞉lo꞉ gilo꞉lo꞉ bo꞉fo꞉mela꞉no꞉ so꞉wayo꞉ gemo꞉ sa꞉la꞉ meab. Isolael hen a꞉namio꞉ so꞉wa we wilo꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Eyo꞉ ge sagalo꞉ mesea꞉ki ta꞉fa꞉ib a꞉la꞉ta꞉ga꞉ ge anaso꞉ ulula꞉li dowalikiyo꞉, eyo꞉ ge tili dofo꞉mela꞉ib. Ga꞉su Lud a꞉ma꞉yo꞉ ge mada alan asula꞉sa꞉ga꞉, so꞉wa we gemo꞉wo꞉ a꞉na sa꞉la꞉meab. Giyo꞉ kalu so꞉wa doma꞉la꞉fo꞉ sa꞉la꞉li kibo꞉bowo꞉, ge sagalemabe. Ko꞉sega ga Lud wema꞉lo꞉ma꞉ tiginilab.” ");
INSERT INTO bco_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","A꞉la꞉fo꞉ko꞉lo꞉ Na꞉omi eyo꞉ so꞉wa a꞉no꞉ fo꞉fo꞉lelia꞉ga꞉ ta꞉li silikiyo꞉, dinafa bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Amisa꞉n ka꞉isale nolba꞉ sa꞉laki a꞉la꞉sio꞉, “Na꞉omiya꞉ ene so꞉waleyo꞉ sa꞉la꞉li ko꞉lo꞉ diab.” A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa a꞉no꞉ Obed wikili alifa꞉. Obed eyo꞉ Ya꞉si ko꞉lo꞉ sa꞉la꞉li. Ya꞉si eyo꞉ Da꞉ibido꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","A꞉la꞉fo꞉ko꞉lo꞉ Belesa꞉ eso꞉lo꞉ mo꞉mio꞉wo꞉ we. Belesa꞉ inso꞉wo꞉, Heslon. ");
INSERT INTO bco_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Heslona꞉ inso꞉wo꞉, Lam. Lama꞉ inso꞉wo꞉, Aminadab. ");
INSERT INTO bco_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Aminadaba꞉ inso꞉wo꞉, Nason. Nasona꞉ inso꞉wo꞉, Salamon. ");
INSERT INTO bco_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salamona꞉ inso꞉wo꞉, Boas. Boasa꞉ inso꞉wo꞉, Obed. ");
INSERT INTO bco_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obeda꞉ inso꞉wo꞉, Ya꞉si. Ya꞉siya꞉ inso꞉wo꞉ Da꞉ibid. E so꞉lo꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ya꞉su Keliso e Da꞉ibid eya a꞉la꞉ta꞉ga꞉ Ablahama꞉ so꞉lo꞉wa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. Ya꞉su Kelisowa꞉ ene so꞉lo꞉ mio꞉wo꞉ we. ");
INSERT INTO bco_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ablahama꞉ inso꞉wo꞉ Aisa꞉g, ");
INSERT INTO bco_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yudaya꞉ inso꞉wo꞉ Beles o꞉lia꞉ Sa꞉la o꞉lia꞉. A꞉la꞉ wema꞉ anowo꞉ Tema. Belesa꞉ inso꞉wo꞉ Heslon, Heslona꞉ inso꞉wo꞉ Lam. ");
INSERT INTO bco_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lama꞉ inso꞉wo꞉ Aminadab, Aminadaba꞉ inso꞉wo꞉ Nason, Nasona꞉ inso꞉wo꞉ Salamon. ");
INSERT INTO bco_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salamona꞉ inso꞉wo꞉ Boas, a꞉la꞉ta꞉ga꞉ Boasa꞉ anowo꞉ Lehab. Boasa꞉ inso꞉wo꞉ Obed a꞉la꞉ta꞉ga꞉ Obeda꞉ anowo꞉ Lud. Obeda꞉ inso꞉wo꞉ Ya꞉si. ");
INSERT INTO bco_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ya꞉siya꞉ inso꞉wo꞉ Da꞉ibid, e misa꞉ kalu alan fa꞉la꞉dowo꞉. A꞉la꞉ta꞉ga꞉ Da꞉ibida꞉ inso꞉wo꞉ Solomon. Solomona꞉ ano a꞉no꞉ tamin amio꞉ Ulayaya꞉ ene inga ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomona꞉ inso꞉wo꞉ Lehoboam, Lehoboama꞉ inso꞉wo꞉ Abiya, Abiyaya꞉ ene inso꞉wo꞉ Asa, ");
INSERT INTO bco_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asaya꞉ inso꞉wo꞉ Yehosafat, Yehosafata꞉ ene inso꞉wo꞉ Yeholam, Yeholama꞉ inso꞉wo꞉ Usaya ");
INSERT INTO bco_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usaya ene inso꞉wo꞉ Yotam, Yotama꞉ inso꞉wo꞉ Ahas, Ahasa꞉ inso꞉wo꞉ Ha꞉sekaya, ");
INSERT INTO bco_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ha꞉sekaya ene inso꞉wo꞉ Manasa, Manasaya꞉ inso꞉wo꞉ Amon, Amona꞉ inso꞉wo꞉ Yosaya ");
INSERT INTO bco_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosayaya꞉ ene inso꞉wo꞉ Yehoiakin o꞉lia꞉ ene ao nolo꞉lo꞉. Ho꞉len a꞉namio꞉ Babilon kalu iliyo꞉ bubo꞉wo꞉ tinia꞉sa꞉ga꞉yo꞉, Isolael kaluka꞉isaleyo꞉ Babilon ili hena a꞉ma꞉la꞉ tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","A꞉la꞉ta꞉ga꞉ iyo꞉ Babilon tililia꞉gane ho꞉len a꞉namio꞉, Yehoiakin eyo꞉ ene inso꞉wo꞉ Seadiel a꞉na sa꞉la꞉li. Seadiela꞉ inso꞉wo꞉ Selubabel. ");
INSERT INTO bco_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Selubabela꞉ inso꞉wo꞉ Abiud, Abiuda꞉ inso꞉wo꞉ Eliakim, Eliakima꞉ inso꞉wo꞉ Asol, ");
INSERT INTO bco_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asola꞉ inso꞉wo꞉ Sadog, Sadoga꞉ inso꞉wo꞉ Akim, Akima꞉ inso꞉wo꞉ Eliud, ");
INSERT INTO bco_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliuda꞉ inso꞉wo꞉ Eliesa, Eliesaya꞉ inso꞉wo꞉ Matan, Matana꞉ inso꞉wo꞉ Ya꞉kob. ");
INSERT INTO bco_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Ya꞉koba꞉ inso꞉wo꞉ Yosa꞉b, ko꞉lo꞉ Maliaya꞉ ino꞉ e. Malia eyo꞉ Ya꞉su ko꞉lo꞉ sa꞉la꞉li. Ene wiyo꞉ nowo꞉ Keliso a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","A꞉la꞉fo꞉ko꞉lo꞉ so꞉lo꞉ agela꞉i mio꞉wo꞉, Ablahama a꞉la꞉ta꞉ga꞉ Da꞉ibid elo꞉ fa꞉la꞉dowo꞉ ho꞉len a꞉namio꞉ so꞉lo꞉ agelo꞉wo꞉ do꞉la꞉ta꞉ga꞉ fa꞉la꞉da꞉in fa꞉la꞉dowo꞉. A꞉la꞉ta꞉ga꞉ Da꞉ibid eya a꞉la꞉ta꞉ga꞉ Isolael kaluka꞉isale ko꞉lo꞉ Babilon hen a꞉namilo꞉ tililia꞉gane a꞉no꞉lo꞉ so꞉lo꞉ agelo꞉wo꞉ do꞉la꞉ta꞉ga꞉ fa꞉la꞉da꞉in fa꞉la꞉dowo꞉. A꞉la꞉ta꞉ga꞉ Babilon hen a꞉namilo꞉ tililia꞉gane a꞉na a꞉la꞉ta꞉ga꞉ Keliso elo꞉ fa꞉la꞉dowo꞉ ho꞉len a꞉namio꞉lo꞉ so꞉lo꞉ agelo꞉wo꞉ do꞉la꞉ta꞉ga꞉ fa꞉la꞉da꞉in fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ya꞉su Keliso sa꞉la꞉liyo꞉ we au fa꞉la꞉dowo꞉. Ene ano Malia a꞉no꞉ Yosa꞉bo꞉ samefo꞉len. A꞉la꞉yo꞉ semo꞉ sili alifa꞉ a꞉lab a꞉namio꞉, Godeya꞉ Mamaya꞉ halaido꞉wa a꞉la꞉ta꞉ga꞉yo꞉ Malia e so꞉wayo꞉ alelabo꞉lo꞉b a꞉la꞉bo꞉ iyo꞉ a꞉na ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Elo꞉ samefo꞉len kalu Yosa꞉bo꞉ mada digalo꞉ kalu ko꞉lo꞉, eyo꞉ ga a꞉no꞉ kalab amio꞉ sendelo alifa꞉no꞉wo꞉ mo꞉asulaki, eyo꞉ ga a꞉no꞉ ha꞉sa ta꞉fa꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ko꞉sega Yosa꞉b e a꞉no꞉ ko꞉lo꞉ kele asula꞉liki elen amio꞉, Kalu Alana꞉ ma꞉mul kalu nowo꞉ elo꞉ amio꞉ ofo fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Yosa꞉b gi ma꞉muwo꞉ Da꞉ibid. Giyo꞉ ga we dia꞉no꞉wo꞉ tagila꞉so꞉bo. Mo꞉wo꞉ Malia e so꞉wa sab a꞉no꞉ Godeya꞉ Mamaya꞉ eya fa꞉la꞉do alifa꞉ ko꞉lo꞉ ge tagila꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Eyo꞉ kalu so꞉wa sa꞉la꞉lia꞉ib ko꞉lo꞉, giyo꞉ so꞉wa a꞉no꞉ wiyo꞉ Ya꞉su wikila꞉bi. A꞉la꞉do꞉ so꞉lo꞉lo꞉ mo꞉wo꞉ we. So꞉wa a꞉ma꞉yo꞉ kaluka꞉isale enedo꞉ma꞉lo꞉ mogago꞉ dimida꞉lab a꞉no꞉ halaki, iyo꞉ asuwa꞉taki a꞉ma꞉la꞉ gasilia꞉ib.” Ma꞉mul kalu eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Kelego꞉ fa꞉la꞉dowo꞉ a꞉ma꞉yo꞉, tamin amilo꞉ Kalu Alana꞉lo꞉ ene tolo꞉ dinali sa꞉lan kaluwa a꞉la꞉ta꞉ga꞉lo꞉ sio꞉ a꞉no꞉ kolo꞉ ilili alitakigab. Dinali sio꞉ to a꞉no꞉ we. ");
INSERT INTO bco_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ga we, kalu o꞉lia꞉yo꞉ mo꞉ali amio꞉ so꞉wayo꞉ alela꞉sa꞉ga꞉, kalu so꞉wa sa꞉la꞉lia꞉ib ko꞉lo꞉, iliyo꞉ so꞉wa a꞉no꞉ Imanuel wikilima꞉ib.” To wema꞉ ha꞉go꞉ we, Godeyo꞉ ni o꞉lia꞉ dofo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yosa꞉b e dasilia꞉ga꞉yo꞉, Alana꞉ ene ma꞉mul kaluwa꞉lo꞉ to saefa꞉ o꞉leauka kudu ane. Eyo꞉ Maliayo꞉ ene aya tililia꞉ga꞉ ane, ");
INSERT INTO bco_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ko꞉sega Malia eyo꞉ sowa꞉yo꞉ semo꞉ sa꞉la꞉li amio꞉, Yosa꞉b e Malia o꞉lia꞉yo꞉ do꞉mo꞉ imiligo꞉ modo꞉wo꞉. A꞉la꞉ta꞉ga꞉ Malia eyo꞉ kalu so꞉wa a꞉no꞉ sa꞉la꞉liabikiyo꞉, Yosa꞉b eyo꞉ so꞉wa a꞉no꞉ Ya꞉su wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ha꞉lod e misa꞉ kalu alan elen amio꞉, Ya꞉su e Ba꞉diliha꞉m amisa꞉n, Yudia hen a꞉nami sa꞉la꞉li. Ho꞉len nolo꞉ ta꞉ta꞉ga꞉yo꞉, tamin halonamilo꞉ asulo꞉lo꞉ di kalu nolo꞉ ofdo꞉ yan doba꞉da꞉ a꞉la꞉ta꞉ga꞉ Ya꞉lusalem a꞉na fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Yuwa꞉ misa꞉ alan doma꞉ib so꞉wa a꞉no꞉ o꞉bamida꞉ sa꞉la꞉liyo꞉? Nio꞉ tamin elo꞉wo꞉ fa꞉la꞉dowabi ba꞉ba꞉ ko꞉lo꞉, nio꞉ e ko꞉lo꞉ wabudaki dulugu sa꞉ma꞉ni mio꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Misa꞉ kalu alan Ha꞉lod e ililo꞉ to sio꞉ a꞉no꞉ da꞉dakiyo꞉, e mada kele asulabiki, Ya꞉lusalem kaluka꞉isale iyo꞉lo꞉ mada kele asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu iyo꞉lo꞉, elelo꞉ wida꞉sen kaluwo꞉lo꞉ tambo a꞉na ho꞉le kegea꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Godeya꞉lo꞉ da꞉feyo꞉ kalu e o꞉bamida꞉ sa꞉la꞉lia꞉iba?” ");
INSERT INTO bco_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “E Ba꞉diliha꞉m amisa꞉n, Yudia hen us wena sa꞉la꞉lia꞉ib. Godeya꞉ tolo꞉ dinali sa꞉lan kaluwa꞉lo꞉ to ko꞉lo꞉ sa꞉sa꞉lifa꞉ da꞉labo꞉ we, ");
INSERT INTO bco_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Ba꞉diliha꞉m amisa꞉n, Yuda hen amio꞉lo꞉ a꞉lab ge, wilo꞉ma dowo꞉. Amisa꞉n alan Yuda hen a꞉namilo꞉ a꞉lab a꞉no꞉ gi tiniab. Mo꞉wo꞉ tif amio꞉ bo꞉fo꞉mela꞉no꞉ kalu nowo꞉ geya a꞉la꞉ta꞉ga꞉ fa꞉la꞉doma꞉ib ko꞉lo꞉, eyo꞉ Isolael kaluka꞉isale nilo꞉ we, dinafa tililia꞉ ha꞉na꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ha꞉lod eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, tamin halonamilo꞉ asulo꞉lo꞉ di kalu i a꞉no꞉ wo꞉no꞉le ho꞉lelia꞉ga꞉, tamin a꞉no꞉ ho꞉leno꞉ mada iga꞉sa fa꞉la꞉dowabiyo꞉ a꞉la꞉liki dinafa fanda dabu ba꞉da꞉sa꞉ga꞉yo꞉, e asulo꞉wo꞉ a꞉na di. ");
INSERT INTO bco_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ i a꞉no꞉ Ba꞉diliha꞉m a꞉na iliga꞉takiyo꞉ a꞉la꞉sio꞉, “Gio꞉ so꞉wa a꞉no꞉ mada dinafa keda꞉i ha꞉na꞉bi. Giliyo꞉ so꞉wa a꞉no꞉ ba꞉da꞉ga꞉yo꞉, nelo꞉ elo꞉wa ha꞉na꞉sa꞉ga꞉ ene wiyo꞉ wabulu sa꞉ma꞉no꞉ ko꞉lo꞉ nelo꞉ amio꞉ bo꞉bo꞉ge sa꞉ma꞉ni ya꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Misa꞉ kaluwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉ga꞉yo꞉, iyo꞉ ha꞉na꞉ni ane. A꞉la꞉ta꞉ga꞉yo꞉ tamin ilo꞉ tamin amilo꞉ fa꞉ladowabilo꞉ ba꞉ba꞉ a꞉ma꞉yo꞉, iyo꞉ tililia꞉ ha꞉na꞉ga꞉, so꞉wa tuo꞉lundo꞉ da꞉lab imilide a꞉na kagayo꞉. ");
INSERT INTO bco_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Iyo꞉ tamin ko꞉lo꞉ kagayab a꞉no꞉ ba꞉da꞉ga꞉yo꞉, iyo꞉ mada sagalo꞉wo꞉ alan dowo꞉ ");
INSERT INTO bco_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Iyo꞉ a usa tiane amio꞉, so꞉wa a꞉no꞉lia꞉ ano Malia o꞉lia꞉yo꞉ a꞉na sena ba꞉da꞉ga꞉yo꞉, iyo꞉ a꞉na gulalu misa꞉fu alitaki, emo꞉wo꞉ a꞉na wabulu sio꞉. A꞉la꞉ta꞉ga꞉ ililo꞉ boba kelego꞉ dia꞉mio꞉ a꞉no꞉ segeselia꞉sa꞉ga꞉yo꞉, go꞉l o꞉lia꞉ i mak mun nafalo꞉ da꞉dan kelego꞉ o꞉lia꞉, i ho꞉n mun nafalo꞉ da꞉dan kelego꞉ no o꞉lia꞉yo꞉ emo꞉wo꞉ a꞉na dimi. ");
INSERT INTO bco_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ imo꞉wo꞉ ofolo꞉ meakiyo꞉, iyo꞉ Ha꞉lodo꞉ amio꞉ a꞉ma꞉la꞉bo꞉ ha꞉na꞉so꞉boka꞉ a꞉la꞉likiyo꞉ hagugu sio꞉ ko꞉lo꞉, iyo꞉ tog nodo begele ha꞉na꞉ga꞉, ini hena ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Tamin halonamilo꞉ asulo꞉lo꞉ di kalu i a꞉no꞉ ha꞉na꞉ga꞉ dowabikiyo꞉, Alana꞉ ene ma꞉mul kaluwo꞉ Yosa꞉b dowa ofo fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Ha꞉lod eyo꞉ so꞉wa we sanala꞉ma꞉no꞉ a꞉la꞉liki kelema꞉nigab ko꞉lo꞉, ge dasilia꞉ga꞉, so꞉wa we a꞉la꞉ta꞉ga꞉ ano o꞉lia꞉yo꞉ tililia꞉ga꞉, Isib mesa꞉ni bo꞉bo꞉ge ha꞉na꞉bi. A꞉la꞉ta꞉ga꞉ gio꞉ a꞉na silikiyo꞉, nilo꞉ to sa꞉labo꞉ ko꞉lo꞉ yasi sa꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A꞉la꞉sa꞉labiki Yosa꞉b e dasilia꞉ga꞉, nulu a꞉naka dimadala꞉sa꞉ga꞉yo꞉, so꞉wa o꞉lia꞉ ano o꞉lia꞉yo꞉ tililia꞉ga꞉ Isib a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","A꞉la꞉fo꞉ko꞉lo꞉ Ha꞉lod e soma꞉ki yasilakiyo꞉, iyo꞉ Isib a꞉naka o꞉sen. A꞉la꞉do꞉ gab a꞉na ilikiyo꞉, Kalu Alana꞉ to ko꞉lo꞉ dinali sa꞉lan kaluwa꞉lo꞉ sio꞉ a꞉no꞉ ilili alifa꞉. To sio꞉ a꞉no꞉ we, “Ni kalu so꞉wa ko꞉lo꞉ Isibdo꞉ sab a꞉no꞉, ta꞉fo꞉ mena꞉ki a꞉na ho꞉ido꞉.” ");
INSERT INTO bco_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ha꞉lod eyo꞉ tamindo꞉ asulo꞉lo꞉ kalu iyo꞉ e dikido꞉lo꞉b a꞉la꞉asula꞉sa꞉ga꞉, e mada gadia꞉sa꞉ga꞉ kulufa꞉yabiki, ene da꞉la꞉di kalu nolo꞉ Ba꞉diliha꞉m amisa꞉n a꞉na iliga꞉takiyo꞉ a꞉la꞉sio꞉, “Ba꞉diliha꞉m amisa꞉n amio꞉lo꞉, ha꞉la꞉ doba꞉da꞉lo꞉ sab a꞉namio꞉lo꞉, kalu so꞉wa donayo꞉ otaleno꞉ o꞉semo꞉ gulula꞉ a꞉no꞉ tambo yasala꞉bi.” Ha꞉lod eyo꞉ tamin a꞉no꞉ ho꞉len iga꞉sa mada fa꞉la꞉dowabeyo꞉ a꞉la꞉bo꞉, asulo꞉lo꞉ di kalu imo꞉wo꞉ dinafa fanda dabu ba꞉ba꞉ ko꞉lo꞉, ho꞉len a꞉namilo꞉ kalu so꞉wa sa꞉la꞉lia꞉lab a꞉no꞉ eyo꞉ yasala꞉ma꞉no꞉ a꞉la꞉asulaki go꞉. ");
INSERT INTO bco_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A꞉la꞉fo꞉ko꞉lo꞉ Godeya꞉ to ko꞉lo꞉ dinali sa꞉lan kalu Ya꞉limaya elo꞉ sio꞉ a꞉no꞉ hendele ilili alifa꞉. To a꞉no꞉ we, ");
INSERT INTO bco_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Lama amisa꞉n a꞉namio꞉ nofolakiyo꞉ sae ya꞉labiki dabu. Lesola꞉ inso꞉wo꞉ tambo yasala꞉ ko꞉lo꞉, emo꞉lo꞉ ha꞉nolo sa꞉lab a꞉no꞉ mo꞉da꞉daki, ya꞉lifo꞉ko꞉ elen.” ");
INSERT INTO bco_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","20","Ha꞉lod e sowa꞉sa꞉ga꞉ dowabikiyo꞉, Yosa꞉b e Isib a꞉na sen amio꞉ e ofolaki, Alana꞉ ene ma꞉mul kaluwo꞉ elo꞉wa fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “So꞉walo꞉ sana soma꞉no꞉ togdo꞉ keda꞉len kalu i a꞉no꞉ sowo꞉ ko꞉lo꞉, ge dasilia꞉ga꞉, so꞉wa we o꞉lia꞉ ano o꞉lia꞉yo꞉ tililia꞉ga꞉, Isolael hen a꞉na a꞉ma꞉la꞉ hamana.” ");
INSERT INTO bco_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","A꞉la꞉sa꞉labiki da꞉da꞉sa꞉ga꞉yo꞉, eyo꞉ so꞉wa o꞉lia꞉ ano o꞉lia꞉yo꞉ tililia꞉ga꞉, Isolael hen a꞉na a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ko꞉sega Ha꞉loda꞉ ene so꞉wa Akelaus a꞉no꞉ iyaya꞉ heno꞉ ene diaki, Yudia hen a꞉ma꞉ misa꞉ kalu dowo꞉ka꞉ a꞉la꞉bo꞉ Yosa꞉b e da꞉da꞉sa꞉ga꞉yo꞉, e a꞉na ha꞉na꞉no꞉wo꞉ tagi dowo꞉. A꞉la꞉ta꞉ga꞉ e ofolakiyo꞉, Gode eyo꞉ e a꞉namio꞉ ha꞉na꞉so꞉boka꞉ a꞉la꞉liki hagugu sio꞉ ko꞉lo꞉, iyo꞉ Ga꞉lili hen a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","A꞉na ha꞉na꞉ga꞉yo꞉, iyo꞉ Nasala꞉t amisa꞉n a꞉na mesa꞉ni ane. Tamin amio꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu iliyo꞉ towo꞉ a꞉la꞉sio꞉, “E Nasala꞉t kalu a꞉la꞉sa꞉ma꞉ib.” A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ Nasala꞉tdo꞉ mesa꞉ni ane a꞉na ilikiyo꞉, to sio꞉ a꞉no꞉ a꞉na ilili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","2","Dona nolo꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, Yo꞉n ho꞉n amilo꞉ to꞉lolan a꞉ma꞉yo꞉ kalulo꞉ma hen Yudia a꞉namio꞉ wida꞉li sia꞉likiyo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉leno꞉ ko꞉na꞉ma dowab ko꞉lo꞉, kaluka꞉isale gio꞉ mogago꞉ dimida꞉leno꞉ ta꞉ta꞉ga꞉, Godelo꞉wa nodoma” a꞉la꞉wida꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Kalu a꞉no꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu Aisaya elo꞉ sio꞉wo꞉ o꞉m. Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “Kalu imilig nowo꞉ kalulo꞉ma hen a꞉na ho꞉le sa꞉lakiyo꞉, ‘Kalu Alando꞉ mia꞉no꞉ togo꞉ dinafama. Tog a꞉no꞉ digale fadaifoma.’ ” ");
INSERT INTO bco_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yo꞉n elo꞉ so꞉g ko꞉lo꞉wo꞉ no꞉ ka꞉mol fo꞉n ko꞉lo꞉ alula꞉sa꞉ga꞉ ka꞉la꞉sen, a꞉la꞉ta꞉ga꞉ no꞉ do꞉go꞉f nowo꞉ hoda꞉sa꞉ga꞉ yafu difa꞉. Ma꞉no꞉ ko꞉lo꞉ Yo꞉n elo꞉ na꞉seno꞉ sa꞉gema o꞉lia꞉ kola꞉ ho꞉n o꞉lia꞉ na꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ho꞉len a꞉namio꞉ Ya꞉lusalem kaluka꞉isaleyo꞉lo꞉, Yudia hen a꞉namida꞉lo꞉ kaluka꞉isaleyo꞉lo꞉ a꞉la꞉ta꞉ga꞉ ho꞉n Yodan anib amilo꞉ kandayo꞉ a꞉no꞉ tambo Yo꞉n elo꞉wa ya꞉sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kaluka꞉isaleyo꞉ mogago꞉ dimida꞉leno꞉ foga꞉le sa꞉labikiyo꞉, iyo꞉ ho꞉n Yodan amio꞉ Yo꞉na꞉yo꞉ a꞉na to꞉lola꞉len. ");
INSERT INTO bco_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","A꞉la꞉ga꞉likiyo꞉, Fa꞉lisi kalu o꞉lia꞉ Sadusi o꞉lia꞉yo꞉ iyo꞉lo꞉ ho꞉na to꞉lolab amio꞉ modo꞉ ya꞉sia꞉len. Ko꞉sega Yo꞉n eyo꞉ kalu i a꞉no꞉ ba꞉da꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ kisa꞉wa꞉lo꞉ o꞉ngo꞉ dowaka꞉! Godeya꞉lo꞉ gadiakilo꞉ falasila꞉ma꞉nigab a꞉no꞉, gio꞉ begele alita꞉ga꞉ hamana꞉kiyo꞉ abe hagugu sio꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ge Godeya꞉ gadio꞉wo꞉ tininima꞉nikiyo꞉, asulo꞉ nodolo꞉ a꞉ma꞉ fo nafayo꞉, gililo꞉ man dimidan us a꞉namio꞉ fowo꞉ hele alita꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nili ma꞉muwo꞉ Ablaham e ko꞉lo꞉ nio꞉ o꞉li sili alifa꞉no꞉ a꞉la꞉bo꞉ giliyo꞉ asula꞉so꞉bo. Niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Gode eyo꞉ falasilakiyo꞉, gio꞉ tambo yasa danelalega, Gode eyo꞉ Ablahama꞉ ema꞉mu i nolo꞉ u wena a꞉la꞉ta꞉ga꞉yo꞉ o꞉lika fa꞉la꞉do alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Kabiyo꞉ o꞉ma i mo꞉wa dia꞉fo꞉lab ko꞉lo꞉, iyo꞉ tambo fo nafalo꞉ mo꞉hedab a꞉no꞉ gegedelia꞉ga꞉ deya gilima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Gio꞉ hendele asulo꞉wo꞉ nodolo꞉ a꞉lakiyo꞉, niyo꞉ gio꞉ ho꞉ndeya to꞉lola꞉lo꞉l. Ko꞉sega kalu ni fa꞉s amilo꞉ mia꞉nigab a꞉ma꞉ ene halaido꞉wo꞉ alan ko꞉lo꞉, eyo꞉ ne tinio꞉ ko꞉lo꞉lab. Ne wilo꞉ma kalu ko꞉lo꞉, e budiyo꞉ ni dugulia꞉ga꞉ dia꞉no꞉wo꞉ mo꞉ililo꞉. Eyo꞉ gio꞉ Godeya꞉ Mama o꞉lia꞉ de o꞉lia꞉ma꞉yo꞉ a꞉na to꞉loma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Eyo꞉ wit fowo꞉ beseaki, bebo꞉ dila꞉ma꞉no꞉ a꞉la꞉liki, uo꞉fo꞉ e dagi amio꞉ ta꞉li sab. Eyo꞉ wit fo hende a꞉no꞉ kegea꞉sa꞉ga꞉, ene aya dia꞉fa꞉ib. A꞉la꞉ta꞉ga꞉ sebeb mogago꞉ o꞉da꞉lab a꞉no꞉, de mo꞉dalima꞉no꞉ a꞉lab a꞉na gilima꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ho꞉len a꞉namio꞉, Ya꞉su e Ga꞉lili heno꞉ ta꞉ta꞉ga꞉, ho꞉n Yodan a꞉namio꞉ Yo꞉n emo꞉ to꞉loma꞉ki mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yo꞉na꞉yo꞉ Ya꞉su e ho꞉n amio꞉ elo꞉ mo꞉to꞉loma꞉no꞉ asulakiyo꞉ a꞉la꞉sio꞉, “Giyo꞉ ho꞉n amio꞉ ne ko꞉lo꞉ to꞉loma꞉no꞉ dowo꞉. Ko꞉sega ge ho꞉na to꞉loma꞉kiyo꞉ nelo꞉ amio꞉ wagama꞉ni mio꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉ a꞉la꞉sio꞉, “O꞉go꞉ giyo꞉ nilo꞉ so꞉lo꞉l we au ka dimidama. Naindo꞉ nanogo꞉ dimidama꞉no꞉ wema꞉yo꞉, Godeya꞉ ene man digalo꞉ a꞉no꞉ tambo ilili alitakigab.” A꞉la꞉fo꞉ko꞉lo꞉ Yo꞉n eyo꞉ Ya꞉suwa꞉lo꞉ asulab au dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ya꞉suwo꞉ ho꞉na to꞉lota꞉ga꞉ ha꞉la꞉ya fa꞉la꞉dowab a꞉namio꞉, wigibole a꞉naka Hebeneyo꞉ kolaetabikiyo꞉, Godeya꞉ Mamayo꞉ o꞉ba꞉ hi o꞉ngo꞉ ko꞉lo꞉ dalolia꞉ tinda꞉ga꞉, Ya꞉su eya asitabiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","A꞉la꞉ta꞉ga꞉ to nowo꞉ Hebene a꞉la꞉ta꞉ga꞉ sa꞉lakiyo꞉, “So꞉wa nilo꞉ mada alan asulo꞉wo꞉ we. Niyo꞉ emo꞉wo꞉ sagalo꞉wo꞉ alan dowab.” ");
INSERT INTO bco_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ya꞉su e Sa꞉da꞉na꞉ eyo꞉ da꞉fe bo꞉ba꞉ki, Mama eyo꞉ kalulo꞉ma hen a꞉na tililia꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A꞉na silikiyo꞉, Ya꞉su e ma꞉no꞉lo꞉ mo꞉nakilo꞉ eleno꞉, ho꞉len o꞉lia꞉ nulu o꞉lia꞉yo꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉no꞉ eleta꞉ga꞉ dowabikiyo꞉, Ya꞉su e maiyo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Da꞉fe ba꞉ba꞉no꞉lo꞉ kalu Sa꞉da꞉na꞉ e Ya꞉sulo꞉wa fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Ge hendele Godeya꞉ so꞉walelalega, u we ma꞉n fa꞉la꞉doma, giyo꞉ a꞉la꞉sama.” ");
INSERT INTO bco_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Godeya꞉ bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, ‘Ma꞉no꞉leko꞉ na꞉lab a꞉ma꞉yo꞉, mela꞉no꞉ hendeleyo꞉ mo꞉dimia꞉sen. Ko꞉sega Godeya꞉ ene to ko꞉lo꞉ sa꞉lab a꞉ma꞉yo꞉ tambo mela꞉no꞉wo꞉ dia꞉sen.’ ” ");
INSERT INTO bco_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","A꞉la꞉sa꞉labikiyo꞉ Sa꞉da꞉na꞉ eyo꞉ Ya꞉su e malilo꞉ hen Ya꞉lusalem amisa꞉n a꞉na tililia꞉ga꞉, Godeya꞉ ene Malilo꞉ A dog iwalulo꞉ wa꞉l a꞉nami kagama꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","A꞉na kagafo꞉likiyo꞉, Sa꞉da꞉na꞉ eyo꞉ a꞉la꞉sio꞉, “Ge Godeya꞉ ene So꞉walelalega, ge holona ho꞉lufoma. Mo꞉wo꞉ ha꞉, Godeya꞉ bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, ‘Ene ma꞉mula꞉ kalumo꞉wo꞉ ge bo꞉fo꞉melea꞉ki sa꞉ma꞉ib. Uwa꞉yo꞉ gi gibo꞉ mogagilabena꞉kiyo꞉, iliyo꞉ ge ili dagiya꞉ fo꞉fo꞉lelia꞉ib.’ ” ");
INSERT INTO bco_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ya꞉su eyo꞉ Sa꞉da꞉na꞉ emo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Godeya꞉ bugo꞉ amio꞉ to nowo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, ‘Giyo꞉ go꞉no꞉n Gode, Kalu Alan a꞉no꞉ da꞉feakiyo꞉ nodo ba꞉da꞉so꞉bo.’ ” ");
INSERT INTO bco_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","A꞉ma꞉ fa꞉s amio꞉, Sa꞉da꞉na꞉ eyo꞉ Ya꞉suwo꞉ misio꞉ alan nowa tililia꞉ fa꞉la꞉ ha꞉na꞉sa꞉ga꞉ kagayakiyo꞉, henfelo꞉ amilo꞉ amisa꞉n toda꞉ o꞉lia꞉ kelego꞉ nafale amisa꞉n a꞉namilo꞉ da꞉lab a꞉no꞉lia꞉yo꞉ Ya꞉sumo꞉ tambo wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Widakiyo꞉, Sa꞉da꞉na꞉ eyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Ge nemo꞉ gulalu misa꞉fu alitaki wabulu sa꞉lalega, kelego꞉ o꞉go꞉do꞉ gilo꞉ ba꞉dab we niyo꞉ gemo꞉ dimia꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Sa꞉da꞉na꞉ ge hamana. Mo꞉wo꞉ Godeya꞉ bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, ‘Giyo꞉ go꞉no꞉ Gode, Kalu Alan a꞉ma꞉ ha꞉ga dowakiyo꞉, imilig eko꞉ wabudaki dulugu sa꞉la꞉bi.’ ” ");
INSERT INTO bco_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","A꞉la꞉sa꞉labiki Sa꞉da꞉na꞉ eyo꞉ e a꞉na ta꞉fo꞉ ha꞉nabikiyo꞉, ma꞉mula꞉ kalu iyo꞉ ya꞉sa꞉ga꞉, Ya꞉suwo꞉ halale alitaki e a꞉na asufa꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yo꞉no꞉ dibolowa to꞉lolo꞉ka꞉ a꞉labo꞉ Ya꞉suwo꞉ da꞉da꞉ga꞉yo꞉, e a꞉ma꞉la꞉ Ga꞉lili hen a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","E Nasala꞉tdo꞉ tininita꞉ga꞉ aneyo꞉, Kabaniom amisa꞉n a꞉na mesa꞉ni ane. Amisa꞉n a꞉no꞉ Ga꞉lili ho꞉n golo꞉ aniba a꞉lab ko꞉lo꞉, tamin amio꞉ hen a꞉no꞉ Yu kalu Sebuluna꞉ e so꞉lo꞉ o꞉lia꞉ Nabtali ene so꞉lo꞉ o꞉lia꞉mo꞉lo꞉ aloba꞉da꞉sa꞉ga꞉lo꞉ dimiyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","A꞉namilo꞉ mesa꞉ni ane a꞉na ilikiyo꞉, Godeya꞉ tolo꞉ dinali sa꞉lan kalu Aisaya elo꞉ sio꞉ a꞉no꞉ ko꞉lo꞉ ilili alifa꞉ni ane. To sio꞉ a꞉no꞉ we, ");
INSERT INTO bco_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Hen a꞉no꞉ gio꞉ asuluma. Sebulun o꞉lia꞉ Nabtali o꞉lia꞉ma꞉ heno꞉ o꞉m. Ga꞉lili ho꞉n golo꞉ aniba, Yodano꞉ nodowa da꞉lab. Ga꞉lili heno꞉ o꞉m ko꞉lo꞉, Yu kaluka꞉isalema nolo꞉ a꞉na mesa꞉ni mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kaluka꞉isale hen a꞉namilo꞉ sab we sololiya sen ko꞉sega, o꞉go꞉ iyo꞉ ho꞉len alan a꞉no꞉ ba꞉ba꞉. Kaluka꞉isale i a꞉no꞉ sowana꞉ man a꞉ma꞉ go꞉lula꞉folen ko꞉lo꞉, o꞉go꞉ ho꞉leno꞉ ilo꞉ amio꞉ so꞉so꞉lelia꞉ga꞉ fa꞉la꞉dowab.” ");
INSERT INTO bco_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ya꞉suwo꞉ Kabaniomdo꞉ ane ho꞉len a꞉namio꞉, Ya꞉su eyo꞉ to mano꞉ mo꞉mo꞉da widakiyo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ ko꞉na꞉ma fa꞉la꞉doma꞉nigab ko꞉lo꞉, gio꞉ asugo꞉ Godelo꞉ doba꞉da꞉ nodoma.” ");
INSERT INTO bco_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ya꞉suwo꞉ Ga꞉lili ho꞉n golo꞉ aniba ha꞉na꞉ga꞉ ha꞉nakiyo꞉, ao a꞉la꞉ ko꞉lo꞉ ba꞉ba꞉. Nowo꞉ Saimon, Bida a꞉la꞉do꞉ sa꞉labo꞉ o꞉m, a꞉la꞉ta꞉ga꞉ ene ao Andulu o꞉lo꞉ a꞉na gido꞉. A꞉la꞉yo꞉ ka꞉lo꞉ to꞉lolan kalu ko꞉lo꞉, dageyo꞉ ho꞉na to꞉lola꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ ne kudu mena. Gaindo꞉ ka꞉ tili sa꞉la꞉lan aumbo꞉, niyo꞉ ga꞉go꞉ kaluka꞉isale tili sa꞉la꞉ma꞉no꞉ a꞉no꞉ ko꞉lo꞉ walama꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Wigibole a꞉naka a꞉la꞉yo꞉ dageyo꞉ ta꞉ta꞉sa꞉ga꞉, Ya꞉su e ko꞉lo꞉ kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ya꞉su e o꞉fina꞉ga꞉ ha꞉nakiyo꞉, ao a꞉la꞉ nowo꞉ a꞉na ba꞉ba꞉. A꞉la꞉ a꞉no꞉ Sa꞉ba꞉diya꞉ inso꞉, Ya꞉ma꞉s o꞉lia꞉ ene ao Yo꞉n o꞉lia꞉yo꞉ a꞉na ba꞉ba꞉. Ya꞉su e, a꞉la꞉yo꞉ iya Sa꞉ba꞉di o꞉lia꞉ ho꞉n ko꞉suwa siliki, inin dageyo꞉ ko꞉lo꞉ dinafa ya꞉lena ba꞉da꞉sa꞉ga꞉, a꞉la꞉yo꞉ e kudu mena꞉ki ho꞉ido꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Wigibole a꞉naka a꞉la꞉yo꞉, iya o꞉lia꞉ ho꞉n ko꞉su o꞉lia꞉yo꞉ ka ta꞉ta꞉ga꞉, Ya꞉su e ko꞉lo꞉ kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ya꞉suwo꞉ Ga꞉lili hen a꞉na sia꞉likiyo꞉, ili tolo꞉ wida꞉sen ayamio꞉ mano꞉ wida꞉li ha꞉nakiyo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉ma꞉ to nafayo꞉ widaki a꞉la꞉ta꞉ga꞉, walaf ko꞉li ko꞉lilo꞉ kaluka꞉isale amilo꞉ dosdo꞉ a꞉no꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Elo꞉ dimido꞉ a꞉no꞉ Silia heno꞉ tambo dabu ko꞉lo꞉, kaluka꞉isale iliyo꞉ walaf ko꞉li ko꞉lilo꞉lo꞉ dowo꞉ a꞉no꞉ Ya꞉su elo꞉wa tililia꞉ mio꞉. Walaf kalu nagalo꞉ alando꞉ dowo꞉wo꞉, mama mogago꞉lo꞉ dosdo꞉wo꞉lo꞉, da꞉ba꞉da꞉seno꞉lo꞉, ko꞉go꞉neliyo꞉lo꞉, iyo꞉ Ya꞉sulo꞉wa tilili mio꞉ ko꞉lo꞉, eyo꞉ i a꞉no꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaluka꞉isale modo꞉wo꞉ Ya꞉su kudu ane. Iyo꞉ hen ko꞉li ko꞉lilo꞉ amilo꞉ mio꞉ a꞉no꞉ we. Ga꞉lili hen amilo꞉wo꞉lo꞉, Dekabolis hen amilo꞉wo꞉lo꞉, Ya꞉lusalemdo꞉wo꞉lo꞉, Yudia hen amilo꞉wo꞉lo꞉, a꞉la꞉ta꞉ga꞉ Yodano꞉ nodo amio꞉ sa꞉sen a꞉no꞉lo꞉ tambo e kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ya꞉su e kaluka꞉isale modo꞉ kegeo꞉ a꞉no꞉ ko꞉lo꞉ ba꞉da꞉ga꞉yo꞉, e do꞉mo꞉wa fa꞉la꞉ ha꞉na꞉ga꞉, a꞉na sen amio꞉, enedo꞉ tili wida꞉sen kaluka꞉isale iyo꞉ elo꞉ amio꞉ a꞉na ya꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ imo꞉wo꞉ towo꞉ a꞉na mo꞉mo꞉da widakiyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kaluka꞉isale mama amilo꞉ wilo꞉ma dowab a꞉no꞉ iyo꞉ ego꞉le sab. Mo꞉wo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉wo꞉ us a꞉namio꞉ iyo꞉ wilo꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kaluka꞉isale nofolakilo꞉ ya꞉la꞉lab a꞉no꞉, iyo꞉ ego꞉le sab. Mo꞉wo꞉ Gode eyo꞉ iyo꞉ sagale alitaki, ha꞉nolo alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kaluka꞉isale enena꞉ma꞉la꞉lo꞉ ha꞉ga dowakilo꞉, ha꞉sa dowab a꞉no꞉, iyo꞉ ego꞉le sab. Mo꞉wo꞉ Gode eyo꞉ hen inido꞉leyo꞉ dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kaluka꞉isale digalo꞉ mando꞉ bulu meselakilo꞉ dowab a꞉no꞉, iyo꞉ ego꞉le sab. Mo꞉wo꞉ Gode eyo꞉ imo꞉wo꞉ ilili alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kaluka꞉isale nolo꞉ nofola꞉likilo꞉ asuwa꞉ta꞉lab a꞉no꞉, iyo꞉ ego꞉le sab. Mo꞉wo꞉ Gode eyo꞉ i o꞉mo꞉wo꞉ nofolaki asuwa꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kaluka꞉isale asulo꞉wo꞉ go꞉go꞉do꞉ nafale a꞉lab a꞉no꞉, iyo꞉ ego꞉le sab. Mo꞉wo꞉ iyo꞉ Godeyo꞉ ba꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kaluka꞉isale ha꞉fo꞉ disa꞉ma꞉kilo꞉ dinafalo꞉ go꞉go꞉de sa꞉la꞉lab a꞉no꞉, iyo꞉ ego꞉le sab. Mo꞉wo꞉ Gode eyo꞉ i a꞉no꞉ ene so꞉waka꞉ a꞉la꞉sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kaluka꞉isale man nafa digalo꞉le kudu ha꞉na꞉len amio꞉, nolba꞉yo꞉ mogago꞉ ko꞉lilo꞉ imo꞉lo꞉ dimida꞉lab i a꞉no꞉ ego꞉le sab. Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉no꞉ ilino꞉ kolo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Gio꞉ neya dowab amilo꞉ nolba꞉lo꞉ gimo꞉lo꞉ dio꞉ge sa꞉lab a꞉no꞉, hida꞉yo꞉wo꞉ dimiab a꞉no꞉, a꞉la꞉ta꞉ga꞉ to ko꞉li ko꞉lilo꞉ gimo꞉lo꞉ diga꞉li sa꞉lab a꞉no꞉, gio꞉ ego꞉le dowabikigab. ");
INSERT INTO bco_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Hebene a꞉namio꞉ wa꞉l gililo꞉ dia꞉no꞉wo꞉ alan yasisab ko꞉lo꞉, gio꞉ iligi sagalema. Mo꞉wo꞉ o꞉go꞉do꞉ man dimidab we, tamin amilo꞉ dinali sa꞉lan kalu ko꞉lo꞉ dikidiakilo꞉ eteyo꞉ o꞉le o꞉ngab. ");
INSERT INTO bco_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Gio꞉ henfelo꞉ wema꞉ so꞉lu ko꞉sega, so꞉luwa꞉ nudo꞉ a꞉no꞉ aundo꞉ma fa꞉la꞉dowalega, so꞉luwa꞉ nudo꞉ a꞉no꞉ nafa a꞉fa꞉la꞉doma꞉kiyo꞉, mada mo꞉dimidama꞉ib. So꞉lu a꞉no꞉ nanogo꞉ aundo꞉ma ko꞉lo꞉, ha꞉la꞉ya sanditalikiyo꞉, kaluwa꞉yo꞉ mo꞉asulaki, ka wa꞉la꞉la꞉i ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gio꞉ henfelo꞉ wema꞉ ho꞉len ko꞉lo꞉lab. Amisa꞉n misio꞉ amilo꞉ a꞉lab a꞉no꞉ mada wo꞉no꞉lebo꞉ mo꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kaluwa꞉yo꞉ nafayo꞉ do꞉lia꞉ga꞉yo꞉ fafowa꞉yo꞉ wo꞉no꞉lebo꞉ mo꞉go꞉lu alitan. Iliyo꞉ nafa a꞉no꞉ do꞉lia꞉ga kalaba dia꞉tab ko꞉lo꞉, ho꞉len a꞉ma꞉yo꞉ ayamilo꞉ sen a꞉no꞉ tambowo꞉ ho꞉lea꞉tan. ");
INSERT INTO bco_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","A꞉la꞉do꞉ dimidan o꞉leaumbo꞉, gio꞉ ho꞉len gililo꞉wo꞉ kaluka꞉isale siwa꞉l amio꞉ do꞉ifoma. A꞉la꞉galikiyo꞉ iyo꞉ gililo꞉ man nafa dimido꞉wo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ Do Gode, Hebenelo꞉ a꞉lab a꞉ma꞉ wiyo꞉ ko꞉lo꞉ wabulu sa꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉, “Mo꞉sa꞉sa꞉ ele difa꞉ o꞉lia꞉ dinali sa꞉lana꞉lo꞉ to difa꞉ a꞉no꞉lia꞉yo꞉ niyo꞉ dila꞉ma꞉ mio꞉ a꞉la꞉bo꞉ giliyo꞉ asula꞉so꞉bo. Ne kolo꞉ mio꞉ we, to a꞉no꞉ kolo꞉ ilili alifa꞉ni mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Niyo꞉ to we gimo꞉wo꞉ hendele so꞉lo꞉l. Akin o꞉lia꞉ henfelo꞉ o꞉lia꞉yo꞉ semo꞉ kelege dowab amio꞉, Godeya꞉ ele to difa꞉ a꞉namio꞉ to ha꞉lula꞉su heb sa꞉sa꞉lo꞉ nowo꞉ mada mo꞉kelege doma꞉ib. To a꞉no꞉ tambo o꞉semo꞉ ilili alitab amio꞉ o꞉dofo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","A꞉la꞉go꞉ko꞉lo꞉ kalu abeyo꞉ ele difa꞉ a꞉namio꞉ to ha꞉lula꞉su nowo꞉ o꞉go꞉sa꞉sa꞉ga꞉, kalu nolo꞉lo꞉ to a꞉no꞉ o꞉go꞉sema꞉ki widalega, kalu a꞉no꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉namio꞉ e wilo꞉ma doma꞉ib. Ko꞉sega kalu abeyo꞉ ele to difa꞉ a꞉no꞉ dinafa kudu ha꞉na꞉ga꞉, nolbo꞉wo꞉ dinafa wida꞉lalega, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉namio꞉ e wi alan dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Man digalo꞉ gililo꞉ dimida꞉lab a꞉ma꞉yo꞉, Fa꞉lisi kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ma꞉lo꞉ man digalo꞉ dimida꞉lab a꞉no꞉ mo꞉tininilalega, gio꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉namio꞉ mada mo꞉tiha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Tamin amilo꞉ gili ma꞉mumo꞉lo꞉ to saefa꞉ a꞉no꞉ gio꞉ dabu ko꞉lo꞉ to a꞉no꞉ we, ‘Kalu nowo꞉ sana sowa꞉so꞉bo. Kaluka꞉isale abeyo꞉ nowo꞉ sana sowab a꞉no꞉, e mo꞉walila꞉sa꞉ga꞉ hida꞉yo꞉ dia꞉ib’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko꞉sega niyo꞉ towo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Kaluka꞉isale abeyo꞉ ene ao nowo꞉mbo꞉lo꞉ kulufa꞉yab a꞉no꞉ elo꞉ mo꞉walila꞉sa꞉ga꞉ hida꞉yo꞉ dia꞉ib. A꞉la꞉ta꞉ga꞉ to nowo꞉ a꞉la꞉so꞉lo꞉l. Kaluka꞉isale abeyo꞉ ene ao nowo꞉mbo꞉lo꞉ towo꞉ fisa꞉le sa꞉lab a꞉no꞉, ganisolowa꞉ siwa꞉la kagama꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isale abeyo꞉ ene ao nowo꞉mbo꞉lo꞉ wa꞉la꞉ sana sa꞉lab a꞉no꞉ de hena sandifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“A꞉la꞉fo꞉ko꞉lo꞉ ge Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen mu gulu a꞉namio꞉ boba kelego꞉wo꞉ Godemo꞉ dimia꞉no꞉ dowa꞉sena, gao noma꞉lo꞉ gilo꞉ emo꞉lo꞉ hala dimido꞉wo꞉ o꞉a꞉la꞉b a꞉la꞉bo꞉ asulalega, ge boba kelego꞉wo꞉ a꞉naka dia꞉ta꞉ga꞉ hamana. Ge gaomo꞉wo꞉ tamin amio꞉ o꞉ko꞉le sa꞉ma꞉ ha꞉na꞉sa꞉ga꞉, e o꞉lia꞉ digalela꞉sa꞉ga꞉ go꞉go꞉dela꞉bi. Go꞉go꞉dela꞉sa꞉ga꞉yo꞉, ge a꞉ma꞉la꞉ ya꞉ga꞉ Godemo꞉wo꞉ bobayo꞉ a꞉na dimea꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kalu noma꞉yo꞉ ge mo꞉walilima꞉no꞉ a꞉la꞉ta꞉ga꞉ tililia꞉ ha꞉nalega, toga o꞉ha꞉na꞉ga꞉ ha꞉nakiyo꞉, giyo꞉ e o꞉lia꞉yo꞉ bo꞉bo꞉ge dinafala꞉bi. A꞉la꞉bo꞉ mo꞉dimidalega eyo꞉ aloba꞉dan kaluwa꞉ dagiya dia꞉fa꞉ib. A꞉la꞉galikiyo꞉, aloba꞉dan kalu eyo꞉ da꞉la꞉di kaluwa꞉ dagiya dia꞉fa꞉ib. A꞉la꞉ta꞉ga꞉ da꞉la꞉di kaluwa꞉yo꞉ ge dibolowa to꞉loma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Niyo꞉ gemo꞉wo꞉ hendele so꞉lo꞉l. Ge dibolo a kabilo꞉ seno꞉, su mole da꞉fe sio꞉ a꞉no꞉ tambo semo꞉ kedetalikiyo꞉, ge mada mo꞉sili alifa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ya꞉suwa꞉ to heb a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Gili ma꞉mu ima꞉lo꞉ to saefa꞉ a꞉no꞉ gio꞉ dabu ko꞉lo꞉, to nowo꞉ we, ‘Uwo꞉wo꞉ dia꞉so꞉bo.’ ");
INSERT INTO bco_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ko꞉sega niyo꞉ gimo꞉wo꞉ towo꞉ a꞉la꞉so꞉lo꞉l. Kalu abeyo꞉ ga nowo꞉ ba꞉da꞉sa꞉ga꞉, ga a꞉no꞉ nelo꞉ afa dimo꞉losa꞉ a꞉la꞉bo꞉ asulalega, kalu a꞉ma꞉yo꞉ ga a꞉no꞉ ene asulo꞉ amio꞉ o꞉ma afa di ko꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","A꞉la꞉fo꞉ko꞉lo꞉ gi si ililib a꞉ma꞉yo꞉, Godeya꞉ digalo꞉ man kudu ha꞉na꞉no꞉wo꞉ ka꞉lalega, si a꞉no꞉ dugulia꞉ga꞉ sandifoma. Do꞉mo꞉ gilo꞉ ko꞉ de hen amio꞉ tambo sanditabena꞉kiyo꞉, do꞉mo꞉ heb nowo꞉ dilalega a꞉no꞉ o꞉li doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","A꞉la꞉ta꞉ga꞉ gi dagi ililiba꞉yo꞉ Godeya꞉ digalo꞉ man kudu ha꞉na꞉no꞉wo꞉ ka꞉lalega, dagi a꞉no꞉ gedelia꞉ga꞉ sandifoma. Do꞉mo꞉ gilo꞉ ko de hen amio꞉ tambo ha꞉nabena꞉kiyo꞉, do꞉mo꞉ heb nowo꞉ gedelalega, a꞉no꞉ o꞉li doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ya꞉suwa꞉ to heb a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Gili ma꞉muwa꞉yo꞉ a꞉la꞉saefa꞉, ‘Kalu abeyo꞉ ga di enedo꞉ a꞉no꞉ ta꞉fa꞉nikiyo꞉, eyo꞉ “Niyo꞉ ga we ta꞉fo꞉” a꞉la꞉bo꞉ mo꞉fo꞉s sa꞉sa꞉lo꞉wo꞉ gedea꞉sa꞉ga꞉yo꞉, gamo꞉wo꞉ dimiaki ta꞉ta꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ko꞉sega niyo꞉ gimo꞉wo꞉ towo꞉ a꞉la꞉so꞉lo꞉l. Kalu abeyo꞉ ingayo꞉ uwo꞉ dia꞉nikiyo꞉ mo꞉ane ko꞉sega, eyo꞉ ga a꞉no꞉ ka ta꞉talega, kalu a꞉ma꞉yo꞉ inga a꞉no꞉ uwo꞉wo꞉ dima꞉ki ta꞉takigab. A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ga ta꞉fo꞉ elen a꞉no꞉ ko꞉lo꞉ a꞉dialega, e uwo꞉ dia꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ya꞉suwa꞉ to heb a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉. “Tamin amilo꞉ gili ma꞉mumo꞉lo꞉ to saefa꞉ a꞉no꞉ gio꞉ dabu ko꞉lo꞉ to nowo꞉ we. ‘Giliyo꞉ wo꞉lokano꞉ golakiyo꞉, Godemo꞉ dinali sa꞉lalega, giliyo꞉ towo꞉ madaliyo꞉ sa꞉la꞉so꞉bo. To gililo꞉ Kalu Alanbo꞉lo꞉ dinali sio꞉ aumbo꞉ hendele dimidaki kudu ha꞉na꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ko꞉sega niyo꞉ gimo꞉wo꞉ towo꞉ a꞉la꞉so꞉lo꞉l. Nolba꞉yo꞉ to gilo꞉ sa꞉lab a꞉no꞉ hendele a꞉la꞉tili asuluma꞉kiyo꞉, giliyo꞉ kelego꞉ wi no amio꞉ halale alitakiyo꞉, dinali sa꞉la꞉so꞉bo. Giliyo꞉ towo꞉ halale alitaki Hebene wi sa꞉lakiyo꞉, dinali sa꞉la꞉so꞉bo. Mo꞉wo꞉ Hebene a꞉no꞉ Godelo꞉ mesa꞉no꞉ i fofodo꞉ halaido꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","A꞉la꞉ta꞉ga꞉ giliyo꞉ towo꞉ halale alitaki henfelo꞉ wema꞉ wi sa꞉lakiyo꞉, dinali sa꞉la꞉so꞉bo. Mo꞉wo꞉ henfelo꞉ we Godeya꞉ eno꞉ ko꞉lo꞉, ene gido꞉fo꞉lo꞉ dia꞉fo꞉labo꞉ o꞉m. Ya꞉lusalema꞉ wi sa꞉lakiyo꞉, dinali sa꞉la꞉so꞉bo. Mo꞉wo꞉ Ya꞉lusalem a꞉no꞉ Misa꞉ Kalu Alana꞉ ene amisa꞉no꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","A꞉la꞉ta꞉ga꞉ wo꞉lokano꞉ golakiyo꞉ towo꞉ dinali sa꞉la꞉so꞉bo. Mo꞉wo꞉ gi misa꞉ a꞉namio꞉, misa꞉ fo꞉n ko heyo꞉wa꞉le ululo꞉wa꞉le fa꞉la꞉doma꞉kiyo꞉ giyo꞉ mada mo꞉dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Towo꞉ sa꞉lakiyo꞉, ‘A꞉’ a꞉lalega, o ‘A’ a꞉lalega, to a꞉no꞉ko꞉ hende sa꞉laki auma꞉ib. To nol ko꞉lo꞉ a꞉kudu sa꞉lab a꞉no꞉ mogago꞉lo꞉ dimida꞉sen Sa꞉da꞉na꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowab.” ");
INSERT INTO bco_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Gili ma꞉mu ima꞉ to saefa꞉ a꞉no꞉ gio꞉ dabu ko꞉lo꞉ to nowo꞉ we, ‘Kalu abeyo꞉ noma꞉ siyo꞉ mogagilalega, si elo꞉wo꞉lo꞉ mogagila꞉bi. Kalu abeyo꞉ noma꞉ beso꞉ dugulalega, bes elo꞉wo꞉lo꞉ dugula꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko꞉sega niyo꞉ towo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Mogago꞉ kaluwa꞉yo꞉ gemo꞉wo꞉ hida꞉yo꞉ dimialega, a꞉ma꞉la꞉bo꞉ wa꞉dea꞉so꞉bo. Kalu abeyo꞉ gi babo꞉ ililiba bolalega, babo꞉ nodowo꞉lo꞉ emo꞉ wida꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kalu noma꞉yo꞉ so꞉g gilo꞉ wa꞉l amilo꞉ sa꞉ga꞉la꞉sen a꞉no꞉ dia꞉no꞉ a꞉laki mo꞉walilima꞉no꞉ asulalega, so꞉g a꞉no꞉ dimia꞉sa꞉ga꞉yo꞉, so꞉g nol gilo꞉ sa꞉ga꞉la꞉sen a꞉no꞉lo꞉ emo꞉ dimia꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kalu noma꞉yo꞉ e kelego꞉wo꞉ hena꞉ fog a꞉na gemo꞉ dia꞉hamana꞉ki dibodalega, giyo꞉ hena꞉ fog nowo꞉ o꞉dia꞉ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kalu noma꞉yo꞉ kelego꞉ no꞉wo꞉ gemo꞉wo꞉ ha꞉iyalega, giyo꞉ kelego꞉ elo꞉ ha꞉iyab a꞉no꞉ dimea꞉bi. Kalu abeyo꞉ kelego꞉ gilo꞉wo꞉ eyo꞉ dia꞉sa꞉ga꞉ a꞉ma꞉la꞉ dimia꞉no꞉ ko꞉lo꞉ dabu ba꞉dalega, giyo꞉ e gola ba꞉da꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Gili ma꞉mu ima꞉ to saefa꞉ a꞉no꞉ gio꞉ dabu ko꞉lo꞉ to nowo꞉ we. ‘Giliyo꞉ giasi kaluka꞉isale o꞉lia꞉yo꞉ ha꞉fo꞉wo꞉ disa꞉laki, gili gis kalumo꞉wo꞉ mo꞉bea꞉bi’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko꞉sega niyo꞉ gimo꞉wo꞉ towo꞉ a꞉la꞉so꞉lo꞉l. Giliyo꞉ gis kalumo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉la꞉bi. A꞉la꞉ta꞉ga꞉ gimo꞉lo꞉ dikidiab kalu i a꞉no꞉ Gode eyo꞉ kanulu alifoma꞉ki dulugu sa꞉la꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Giyo꞉ a꞉la꞉dimidalikiyo꞉, gio꞉ Do Hebenelo꞉ a꞉lab a꞉ma꞉ ene so꞉wale fa꞉la꞉doma꞉ib. Mo꞉wo꞉ Gode eyo꞉ mogago꞉ kaluka꞉isale o꞉lia꞉ nafa kaluka꞉isale o꞉lia꞉mo꞉wo꞉ ofo꞉ ta꞉mena꞉ki ta꞉ta꞉sen. A꞉la꞉ta꞉ga꞉ Gode eyo꞉ man digalo꞉lo꞉ dimida꞉sen kaluka꞉isale imo꞉wo꞉ a꞉la꞉ta꞉ga꞉ man digalo꞉lo꞉ mo꞉dimida꞉sen kaluka꞉isalemo꞉wo꞉lo꞉ ho꞉no꞉ timena꞉ki ta꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kaluka꞉isale gimo꞉lo꞉ ha꞉fo꞉lo꞉ disa꞉lab o꞉mo꞉wo꞉ giliyo꞉lo꞉ imo꞉wo꞉ ha꞉fo꞉ disa꞉lalega, mewa꞉l dia꞉no꞉ hendeleyo꞉ o꞉mba. Takis molelo꞉ dian kalu iliyo꞉lo꞉ man o꞉leauka dimida꞉li sab. ");
INSERT INTO bco_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Gio꞉ gaomo꞉wo꞉ disiyo꞉ a꞉la꞉bo꞉ ka sa꞉laki, ko꞉sega nolbo꞉wo꞉ mo꞉sa꞉lalega, man gilo꞉ dimidab a꞉ma꞉yo꞉, gio꞉ nolo꞉ waga tininima꞉nigaya? Ha꞉la꞉ kalu ililo꞉ dimidab o꞉leau giliyo꞉lo꞉ a꞉la꞉ka dimidab. ");
INSERT INTO bco_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","A꞉la꞉fo꞉ko꞉lo꞉ gili Go꞉l ko꞉lo꞉ Hebenelo꞉ a꞉lab a꞉ma꞉lo꞉ ha꞉fo꞉ disa꞉lakilo꞉ ego꞉le sab o꞉leaumbo꞉, gio꞉lo꞉ ha꞉fo꞉ disa꞉laki, ego꞉le dowa꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉. “Gio꞉ dinafa dowa꞉bi. Giliyo꞉ Godeya꞉ siwa꞉l amilo꞉ man digalo꞉ a꞉no꞉ dimida꞉likiyo꞉, kaluka꞉isaleya꞉ siwa꞉l amio꞉ bo꞉ba꞉kiyo꞉ dimida꞉so꞉bo. Giliyo꞉ a꞉la꞉dimidalega, Go꞉l Hebenelo꞉ sab a꞉ma꞉lo꞉ wa꞉l dimia꞉ib a꞉no꞉ sulu ha꞉nab. ");
INSERT INTO bco_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“A꞉la꞉gab ko꞉lo꞉ giliyo꞉ wa꞉feyo꞉ kaluwo꞉ asuwa꞉taki dimiakiyo꞉, kaluka꞉isale nolo꞉ bo꞉ba꞉kiyo꞉ dimida꞉so꞉bo. Kalu nolba꞉yo꞉ e nafa dimidabo꞉lo꞉b a꞉la꞉bo꞉ba꞉kilo꞉ asuwa꞉ta꞉sen o꞉leaumbo꞉ giliyo꞉ dimida꞉so꞉bo. Iliyo꞉ tolo꞉ wida꞉sen ayamio꞉lo꞉, to so꞉go꞉f a꞉namio꞉lo꞉, kaluka꞉isale nolba꞉yo꞉ inin man nafa dimidabo꞉lo꞉b a꞉la꞉ba꞉da꞉sa꞉ga꞉ ene wiyo꞉ wabuluma꞉ki, iliyo꞉ mada ho꞉le sa꞉lakiyo꞉, wa꞉feyo꞉ kaluwo꞉ a꞉na asuwa꞉ta꞉sen. Kalu a꞉la꞉do꞉ dimidab a꞉ma꞉yo꞉, wa꞉lo꞉ inino꞉ o꞉ma diab ko꞉m. ");
INSERT INTO bco_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Giyo꞉ wa꞉feyo꞉ kaluka꞉isaleyo꞉ asuwa꞉takiyo꞉, dagi ililiba꞉lo꞉ dimiab a꞉no꞉ dagi fo꞉fo꞉dolo a꞉no꞉ mo꞉asuluma꞉ki dimida꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","A꞉la꞉galega, gilo꞉ dimidab a꞉no꞉ wo꞉no꞉le doma꞉ib. A꞉la꞉ta꞉ga꞉ gilo꞉ wo꞉no꞉lelo꞉ dimidabo꞉, Go꞉l eyo꞉ ba꞉dab ko꞉lo꞉, gemo꞉wo꞉ wa꞉lo꞉ mada dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Kalu nolba꞉lo꞉, iyo꞉ nafalo꞉b a꞉la꞉bo꞉ba꞉kilo꞉ dulugu sa꞉lan aumbo꞉, giliyo꞉ dulugu sa꞉la꞉so꞉bo. Iliyo꞉ tolo꞉ wida꞉sen ayamio꞉lo꞉, to so꞉go꞉f a꞉namio꞉lo꞉ kagayaki, kaluka꞉isale nolba꞉yo꞉ inino꞉ nafa dimidabo꞉lo꞉b a꞉la꞉bo꞉ba꞉ki, Godemo꞉ dulugu sa꞉la꞉sen. Giliyo꞉ Godemo꞉ dulugu sa꞉lakiyo꞉, ililo꞉ dulugu sa꞉lan aumbo꞉ dimida꞉so꞉bo. Niyo꞉ towo꞉ hendele so꞉lo꞉l. Kalu i a꞉no꞉ wa꞉lo꞉ o꞉ma di ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ko꞉sega giyo꞉ dulugu sa꞉lakiyo꞉, go꞉no꞉n galala꞉ya tina꞉ga꞉, togo꞉ uludufo꞉liki, Go꞉l wo꞉no꞉lelo꞉ a꞉lab emo꞉ dulugu sa꞉la꞉bi. A꞉la꞉galikiyo꞉ Go꞉l wo꞉no꞉lelo꞉ da꞉labdo꞉ ba꞉dan eyo꞉ gemo꞉wo꞉ wa꞉lo꞉ dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Giliyo꞉ Godemo꞉ dulugu sa꞉lakiyo꞉, Yu kaluka꞉isalema i a꞉ma꞉lo꞉ towo꞉ madalilo꞉ modo꞉ kudu sa꞉la꞉likilo꞉ sa꞉lan o꞉leaumbo꞉ sa꞉la꞉so꞉bo. Ili asulakiyo꞉, ililo꞉ to modo꞉ ko꞉lo꞉ sa꞉la꞉lab a꞉no꞉ Gode eyo꞉ mada da꞉ba꞉ib a꞉laki ga꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Gio꞉ i o꞉leo꞉ngo꞉wo꞉ dowa꞉so꞉bo. Mo꞉wo꞉ giliyo꞉ o꞉semo꞉ dabu ba꞉ba꞉ o꞉a꞉lab a꞉naka, kelego꞉ gililo꞉ asulab a꞉no꞉ Go꞉la꞉yo꞉ o꞉ma asululi ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ towo꞉ a꞉la꞉dulugu sa꞉la꞉bi. “Do Gode, Hebenelo꞉ a꞉labo꞉ ge, Gi wiyo꞉ mada malilo꞉le dofo꞉lab ko꞉lo꞉ kaluka꞉isale iliyo꞉ gi wi a꞉no꞉ wabuluma꞉ki ta꞉foma. ");
INSERT INTO bco_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gi kaluka꞉isalelo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ fa꞉la꞉doma꞉ki ta꞉foma. Go꞉no꞉n asulo꞉ ko꞉lo꞉ Hebene amilo꞉ fa꞉la꞉do alifa꞉ o꞉leaumbo꞉, henfelo꞉ wenamio꞉lo꞉ kaluka꞉isaleyo꞉ gilo꞉ asulab au kudu mena꞉ki ta꞉foma. ");
INSERT INTO bco_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","O꞉gdo꞉ nililo꞉ ma꞉no꞉wo꞉ aumbo꞉ dimina꞉ki so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Mogago꞉ nolba꞉lo꞉ nimo꞉lo꞉ dimida꞉lab amilo꞉ nililo꞉ ga꞉lila꞉sen o꞉leaumbo꞉, giyo꞉ mogago꞉ nililo꞉ dimido꞉wo꞉lo꞉ hala꞉sa꞉ga꞉ ga꞉lilema. ");
INSERT INTO bco_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nio꞉ mogago꞉lo꞉ dimidama꞉no꞉ a꞉namida꞉yo꞉ ha꞉nabena꞉ki, giyo꞉ nio꞉ tili dowa꞉bi. Mogago꞉lelo꞉ dimida꞉sen Sa꞉da꞉na꞉ eyo꞉ nio꞉ yasa danela꞉ma꞉ib ko꞉lo꞉, giyo꞉ nio꞉ sili alifoma. Godemo꞉ towo꞉ a꞉la꞉dulugu sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Gio꞉ kalu noma꞉ gemo꞉lo꞉ mogago꞉ dimido꞉ a꞉no꞉ ga꞉lilalega, Go꞉l Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉lo꞉ gi mogago꞉ a꞉no꞉ halaki ga꞉lila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko꞉sega gio꞉ kalu noma꞉ gemo꞉lo꞉ mogago꞉ dimido꞉ a꞉no꞉ mo꞉ga꞉lilalega, Go꞉l eyo꞉ gili mogago꞉wo꞉lo꞉ mo꞉ga꞉lila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Godemo꞉ sa꞉ma꞉nikiyo꞉ kalu nolba꞉yo꞉ ma꞉no꞉wo꞉ ele dia꞉tab a꞉namio꞉, kaluka꞉isale nolba꞉yo꞉ iyo꞉ ba꞉da꞉sa꞉ga꞉ ini wiyo꞉ wabuluma꞉ki, wo꞉lokan ililo꞉wo꞉ heselia꞉ga꞉ dowa꞉sen. Giliyo꞉ a꞉la꞉bo꞉ ga꞉so꞉bo. Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Kalu a꞉la꞉do꞉ gab a꞉ma꞉yo꞉ wa꞉lo꞉ tambo o꞉ma diab ko꞉m. ");
INSERT INTO bco_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ko꞉sega gio꞉ ma꞉no꞉ ma꞉no꞉ elelo꞉ dia꞉tab a꞉namio꞉, kaluka꞉isale iliyo꞉ gio꞉ mo꞉bulubo꞉ba꞉kiyo꞉, wo꞉lokano꞉ hala꞉sa꞉ga꞉, misa꞉ fo꞉no꞉ suda꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Gilo꞉ dimido꞉wo꞉ kalu nolo꞉ mo꞉asuluma꞉kiyo꞉ a꞉la꞉dimida꞉bi. Ko꞉sega Go꞉l wo꞉no꞉lelo꞉ elen eyo꞉ ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ Go꞉l wo꞉no꞉lelo꞉ da꞉labdo꞉ ba꞉dan eyo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, gemo꞉wo꞉ wa꞉lo꞉ mada dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Henfelo꞉ wenamio꞉ kelego꞉ nafa gililo꞉wo꞉ eyayaki, a꞉la꞉ta꞉ga꞉ waliba꞉ mogaila꞉sen. A꞉la꞉ta꞉ga꞉ afalo꞉ dian kaluwa꞉yo꞉ ayo꞉ bidila꞉sa꞉ga꞉, kelego꞉ a꞉no꞉ afale dia꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ kelego꞉ nafaleyo꞉ henfelo꞉ wenamio꞉ kegene dila꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ko꞉sega giliyo꞉ kelego꞉ nafayo꞉ ho꞉leno꞉ tambo Hebene doba꞉da꞉ kegene dila꞉ melea. Mo꞉wo꞉ Hebene hen a꞉namio꞉ kelego꞉ nafayo꞉ mo꞉eyayaki, a꞉la꞉ta꞉ga꞉ waliba꞉yo꞉ mo꞉mogaila꞉sen. A꞉la꞉ta꞉ga꞉ afa dian kaluwa꞉yo꞉ mo꞉bidilan ko꞉lo꞉ afalo꞉ mo꞉dia꞉sen ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Gili kelego꞉ nafalelo꞉ da꞉lab a꞉namio꞉, asulo꞉ alan gililo꞉wo꞉lo꞉ a꞉na doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Gi siko, do꞉mo꞉wa꞉ ho꞉len ko꞉lo꞉lab. Si gilo꞉wo꞉ nafa dowalega, gi do꞉mo꞉wo꞉ tambo ho꞉lea꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ko꞉sega si gilo꞉wo꞉ mogago꞉ dowalega, gi do꞉mo꞉wo꞉ tambo sololiab. A꞉la꞉fo꞉ko꞉lo꞉ gi do꞉mo꞉wa꞉ ho꞉len a꞉no꞉ sololi dowalega, sololi wema꞉yo꞉ mada alan doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nanog dian kalu imili nowo꞉ bo꞉fo꞉lowan kalu a꞉la꞉ya꞉ ha꞉g amio꞉ mo꞉doma꞉ib. A꞉la꞉galega, eyo꞉ bo꞉fo꞉lowan kalu nowo꞉mbo꞉wo꞉ ha꞉fo꞉ disa꞉laki, no o꞉lia꞉yo꞉ mo꞉bema꞉ib. Bo꞉fo꞉lowan kalu nowo꞉ ko꞉lo꞉ kudu ha꞉naki, nowo꞉ gola ba꞉ba꞉ib. O꞉leaumbo꞉ Gode asuluma꞉no꞉ tog o꞉lia꞉ mole alan asuluma꞉no꞉ tog a꞉no꞉lia꞉yo꞉ giliyo꞉ mada mo꞉kudu ha꞉na꞉no꞉ dowo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Gio꞉ tog a꞉la꞉yo꞉ mo꞉kudu ha꞉na꞉ib ko꞉lo꞉, go꞉no꞉n doma꞉no꞉wo꞉ alano꞉ kele asula꞉so꞉bo. Gio꞉ ma꞉no꞉ o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ o꞉b ma꞉no꞉wa꞉le a꞉la꞉bo꞉ asula꞉so꞉bo. A꞉la꞉ta꞉ga꞉ do꞉mo꞉ amio꞉ o꞉b ka꞉ma꞉no꞉wa꞉le a꞉la꞉bo꞉ mada kele asula꞉so꞉bo. Mo꞉wo꞉ Mela꞉no꞉ wa꞉la꞉b kelego꞉wo꞉ ma꞉no꞉ na꞉seno꞉ ko꞉mba. A꞉la꞉ta꞉ga꞉ do꞉mo꞉ amilo꞉ so꞉g sa꞉ga꞉lema꞉no꞉wo꞉ wa꞉la꞉b kelego꞉wo꞉ o꞉mba. ");
INSERT INTO bco_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gio꞉ o꞉ba꞉ iwalulo꞉ dalale sab a꞉no꞉ asuluma! Iliyo꞉ e gelakiyo꞉ mo꞉tili dowan. A꞉la꞉ta꞉ga꞉ iliyo꞉ fowo꞉ tula꞉sa꞉ga꞉yo꞉ ayamio꞉ mo꞉kegene dila꞉sen. Ko꞉sega Go꞉l Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ imo꞉wo꞉ maiya꞉kiyo꞉ mea꞉sen. A꞉la꞉fo꞉ ko꞉sega Godeya꞉ siwa꞉l amio꞉ o꞉ba꞉yo꞉ kaluka꞉isale gili mada tinio꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Gilo꞉ kele asulab a꞉ma꞉yo꞉, gi mela꞉no꞉ a꞉namio꞉ ofa꞉si imilig nowo꞉ gigili dia꞉fa꞉iba꞉le? ");
INSERT INTO bco_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Giliyo꞉ so꞉go꞉ o꞉b ka꞉ma꞉no꞉wa꞉le a꞉la꞉likilo꞉ kele asulait ko mo꞉wo꞉ ha꞉? Gio꞉ mamo fa꞉la꞉dowa꞉lab a꞉no꞉ asuluma! Iyo꞉ nanogo꞉ mo꞉dian, a꞉la꞉ta꞉ga꞉ ene helebeso꞉g ka꞉ma꞉no꞉wo꞉lo꞉ mo꞉dubia꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tamin amio꞉ misa꞉ kalu alan Solomon e ego꞉le dowaki, helebeso꞉go꞉ nafale momada꞉sen. Ko꞉sega mamo momado꞉ nafale a꞉ma꞉yo꞉, Solomona꞉lo꞉ momado꞉ a꞉no꞉ mada tininila꞉. ");
INSERT INTO bco_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mamo a꞉no꞉ ho꞉leno꞉ abolda꞉su dota꞉ga꞉ onaliab amio꞉, deya sandifa꞉ib. Ko꞉sega Gode eyo꞉ mamo a꞉no꞉ momade alitaki tili dowa꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ gio꞉lo꞉ dinafa momade alitaki tili dofo꞉mela꞉ib. Tilidabu gililo꞉wo꞉ mada ha꞉lu ko꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ we aumbo꞉ kele asula꞉so꞉bo. ‘Nio꞉ ma꞉n o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ o꞉ba dia꞉sa꞉ga꞉ ma꞉no꞉wa꞉le? A꞉la꞉ta꞉ga꞉ nio꞉ so꞉go꞉ waga dia꞉ga꞉ ka꞉ma꞉no꞉wa꞉le?’ A꞉la꞉bo꞉ kele asula꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ha꞉la꞉ kaluka꞉isale iliyo꞉ kelego꞉ a꞉no꞉ ko꞉lo꞉ dia꞉no꞉ a꞉la꞉likiyo꞉ kele sab. Ko꞉sega kelego꞉ gililo꞉ kele dowab a꞉no꞉ Go꞉l Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ o꞉ma asululi ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ko꞉sega kelego꞉wo꞉ giliyo꞉ mada dimo꞉losa꞉ a꞉la꞉do꞉ mada asula꞉ma꞉no꞉ wa꞉la꞉bo꞉ we. Giliyo꞉ Godeya꞉ enedo꞉ bo꞉fo꞉lab a꞉ma꞉ ha꞉ga dowaki, ene man digalo꞉le a꞉no꞉ ko꞉lo꞉ asulaki kudu hamana. A꞉la꞉dimidalikiyo꞉ ma꞉no꞉ ma꞉no꞉ o꞉lia꞉ so꞉g ka꞉ma꞉no꞉ o꞉lia꞉yo꞉lo꞉ gimo꞉wo꞉ mada dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","“A꞉la꞉fo꞉ko꞉lo꞉ alilo꞉ dia꞉no꞉ a꞉no꞉ kele asula꞉so꞉bo. Alilo꞉ a꞉no꞉, ali a꞉ma꞉no꞉ doma꞉ib. Hida꞉yo꞉ ho꞉len imilig a꞉ma꞉lo꞉wo꞉, ho꞉len a꞉ma꞉no꞉ ka doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Giliyo꞉ nolba꞉ man dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, e mogago꞉ kalu a꞉la꞉bo꞉ aloba꞉da꞉so꞉bo. A꞉la꞉dimidalega Gode eyo꞉ gio꞉lo꞉ a꞉la꞉ka aloba꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Kalu nolba꞉ man ko꞉lo꞉ gililo꞉ aloba꞉dab o꞉leaumbo꞉, Gode eyo꞉ gili mano꞉lo꞉ o꞉leauka aloba꞉ma꞉ib. Gililo꞉ nolbo꞉lo꞉ man dimidab aumbo꞉, gimo꞉wo꞉lo꞉ wa꞉lo꞉ o꞉leo꞉ngo꞉ ka dimia꞉ib ");
INSERT INTO bco_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Go꞉no꞉n si amilo꞉ i dafen alan da꞉lab a꞉no꞉ mo꞉asulaki ta꞉fo꞉likiyo꞉, giyo꞉ gao noma꞉ si amilo꞉ hena꞉ mula꞉su da꞉lab a꞉no꞉ waga kele asulaya? ");
INSERT INTO bco_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Go꞉no꞉n si amio꞉ i dafeno꞉ o꞉delikiyo꞉, nao gi si amilo꞉ hena꞉ mula꞉su da꞉lab ko, ni dila꞉ma꞉nigo꞉l a꞉la꞉bo꞉ giyo꞉ waga sa꞉ma꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","To gililo꞉ sa꞉lab a꞉no꞉, gililo꞉ dimida꞉sen a꞉no꞉lia꞉yo꞉ mo꞉imilab. Tamin amio꞉ i dafen alan go꞉no꞉n si amilo꞉ da꞉lab a꞉no꞉ ko꞉le dila꞉bi. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉, ge siyo꞉ o꞉li dinafa ba꞉dakiyo꞉, gao noma꞉ si amilo꞉ hena꞉ mula꞉su da꞉lab a꞉no꞉ giyo꞉ a꞉namio꞉ o꞉li dila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Kelego꞉ Godeya꞉no꞉ da꞉fe alifa꞉ a꞉no꞉ giliyo꞉ dia꞉sa꞉ga꞉yo꞉ gasamo꞉wo꞉ mea꞉so꞉bo. A꞉la꞉dimialega iyo꞉ nodola꞉sa꞉ga꞉yo꞉ gio꞉ ma꞉buluma꞉ib. A꞉la꞉ta꞉ga꞉ giliyo꞉ soma nafale ginido꞉wo꞉ kabomo꞉wo꞉ dimia꞉so꞉bo. Mo꞉wo꞉ iliyo꞉ madali wa꞉la꞉ sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Giliyo꞉ dabu ba꞉da꞉bi. Dabu ba꞉dalikiyo꞉ gimo꞉wo꞉ dimia꞉ib. Giliyo꞉ keda꞉bi. Kedalikiyo꞉ giliyo꞉ ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ giliyo꞉ tog amio꞉ godogodola꞉ma. Godogodolalikiyo꞉ gimo꞉wo꞉ kolalia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Mo꞉wo꞉ kaluka꞉isale tambo Godemo꞉lo꞉ dabu ba꞉dab i a꞉ma꞉yo꞉ dia꞉sen. Kaluka꞉isale abeyo꞉ keda꞉lab, iliyo꞉ mada ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isale abeyo꞉ tog amilo꞉ godogodolab imo꞉wo꞉ Gode eyo꞉ togo꞉ kolalia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“So꞉wa gilo꞉ a꞉ma꞉yo꞉ gemo꞉wo꞉ ma꞉no꞉ dimena꞉ki dabu ba꞉dalikiyo꞉, giyo꞉ uwo꞉ emo꞉wo꞉ dimia꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","A꞉la꞉ta꞉ga꞉ so꞉wa gilo꞉ma꞉yo꞉ gimo꞉wo꞉ ka꞉yo꞉ dimena꞉ki ha꞉iyalikiyo꞉, giyo꞉ kisa꞉wa꞉lo꞉ dimia꞉no꞉wa꞉le? A a꞉la꞉bo꞉ mo꞉gan. ");
INSERT INTO bco_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","So꞉walo꞉ iya giliyo꞉ man mogago꞉wo꞉ dimida꞉sen ko꞉sega, kelego꞉ nafaleyo꞉ gini so꞉wamo꞉lo꞉ dimian man a꞉no꞉ gio꞉ asulo꞉. A꞉la꞉fo꞉ko꞉lo꞉ Go꞉l Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ kaluka꞉isale abeyo꞉ emo꞉lo꞉ dabu ba꞉dab i o꞉mo꞉wo꞉ kelego꞉ nafaleyo꞉ mada hendele dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“A꞉la꞉fo꞉ko꞉lo꞉ man nafa kalu nolba꞉lo꞉ gemo꞉lo꞉ dimidama꞉kilo꞉ asulab o꞉leaumbo꞉, giyo꞉lo꞉ nolbo꞉wo꞉ a꞉la꞉ka dimida꞉lubi. Man a꞉no꞉ Mo꞉sa꞉sa꞉ ele saefa꞉ o꞉lia꞉ dinali sa꞉lan kaluwa꞉lo꞉ to wido꞉ o꞉lia꞉ a꞉ma꞉ mo꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mogagila꞉ma꞉no꞉ doba꞉da꞉lo꞉ tog gulu a꞉no꞉ bamo, a꞉la꞉ta꞉ga꞉ tog a꞉no꞉ ho꞉la꞉lia꞉gane ko꞉lo꞉, kaluka꞉isale modo꞉wo꞉ tog gulu a꞉na ti ha꞉na꞉lab. Ko꞉sega gio꞉ tog gulu ha꞉lula꞉su a꞉na mada ti hamana. ");
INSERT INTO bco_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mela꞉no꞉lo꞉ dia꞉no꞉ tog gulu a꞉no꞉ ha꞉lula꞉su ko꞉lo꞉, tog a꞉namilo꞉ kudu ha꞉na꞉no꞉wo꞉ mada halaido꞉ ko꞉lo꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ tog a꞉no꞉ kaluka꞉isale imilida꞉lo꞉wa꞉ ba꞉da꞉ga꞉ kudu ha꞉na꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Gio꞉ madali tolo꞉ widan kaluwo꞉ dinafa bo꞉fo꞉lubi. Gi ko꞉lo꞉ dikidakiyo꞉, iyo꞉ ha꞉salo꞉ dowan kalu o꞉ngo꞉ dota꞉ga꞉ gilo꞉wa ya꞉lab ko꞉sega, asulo꞉ ililo꞉wo꞉ saila gasa elo꞉ o꞉ngo꞉ dowo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","To ililo꞉ widab a꞉no꞉ fo gelan o꞉ngo꞉ ko꞉lo꞉, fo a꞉na a꞉la꞉ta꞉ga꞉yo꞉ ma꞉no꞉ fa꞉la꞉dowab a꞉no꞉ giliyo꞉ da꞉fe ba꞉da꞉sa꞉ga꞉, iyo꞉ madali tolo꞉ widan kalulo꞉b a꞉la꞉bo꞉ a꞉na asuluma꞉ib. Kaluwa꞉yo꞉ do꞉mo me amio꞉ waina꞉ fowo꞉ tuma꞉iba꞉le? A꞉la꞉ta꞉ga꞉ kalu iliyo꞉ alona꞉ fo a꞉no꞉ fugus mogago꞉ a꞉na a꞉la꞉ta꞉ga꞉yo꞉ tuma꞉iba꞉le? A a꞉la꞉do꞉ mo꞉gan. ");
INSERT INTO bco_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","I nafa a꞉ma꞉yo꞉ fowo꞉ tambo nafa heda꞉sen. A꞉la꞉ta꞉ga꞉ i mogago꞉ a꞉ma꞉yo꞉ fowo꞉ mogago꞉ heda꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I nafa a꞉ma꞉yo꞉ fo mogago꞉wo꞉ a꞉namio꞉ mada mo꞉helema꞉ib. A꞉la꞉ta꞉ga꞉ i mogago꞉wa꞉yo꞉ fo nafayo꞉ mada mo꞉helema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","I fowo꞉ nafalelo꞉ mo꞉hedab a꞉no꞉ tambo gegedelia꞉sa꞉ga꞉ deya sandita꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","A꞉la꞉fo꞉ko꞉lo꞉ to ilido꞉ wido꞉ amilo꞉ ma꞉no꞉ fa꞉la꞉dowab a꞉no꞉ da꞉fe ba꞉dakiyo꞉, giliyo꞉ kalu i a꞉no꞉ madali tolo꞉ widan kalulo꞉b a꞉la꞉asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kaluka꞉isale nemo꞉lo꞉, ‘Ni Misa꞉ Alan’ a꞉la꞉do꞉ sa꞉lab a꞉no꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ us a꞉namio꞉ nolo꞉ mo꞉tina꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ Do Hebenelo꞉ a꞉lab elo꞉ asulab aundo꞉ kudu ha꞉na꞉lab i a꞉no꞉ko꞉ ti ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Godeya꞉lo꞉ mo꞉walilima꞉no꞉ ho꞉len a꞉namio꞉, kaluka꞉isale modo꞉wa꞉yo꞉ nemo꞉wo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Ni Misa꞉ Alan, niliyo꞉ gi wiya a꞉la꞉ta꞉ga꞉yo꞉ Godeya꞉ towo꞉ wida꞉len. Gi wi amio꞉ mama mogago꞉wo꞉ o꞉luga꞉fela꞉len. A꞉la꞉ta꞉ga꞉ niliyo꞉ gi wi amio꞉ molo ha꞉na꞉no꞉wo꞉ modo꞉ ko꞉lo꞉ dimida꞉len.’ ");
INSERT INTO bco_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Iliyo꞉ a꞉la꞉sa꞉lalikiyo꞉, niyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sa꞉ma꞉no꞉, ‘Ne gio꞉ mada mo꞉ba꞉da꞉len. Mogago꞉lo꞉ dimida꞉len kaluka꞉isale gio꞉ nelo꞉ wiyo꞉ dowa꞉so꞉bo. Gio꞉ hamana.’ ");
INSERT INTO bco_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Kalu abeyo꞉ ni to we da꞉da꞉sa꞉ga꞉lo꞉ kudu ha꞉na꞉lab a꞉no꞉ e asugdo꞉ di kaluwa꞉lo꞉ a halaido꞉ di o꞉ngo꞉ dowab. Kalu a꞉ma꞉yo꞉ a diakiyo꞉, heno꞉ dali alifela꞉i tina꞉sa꞉ga꞉, aiko꞉ halaido꞉wo꞉ a꞉na gego꞉. ");
INSERT INTO bco_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Eyo꞉ ayo꞉ halaido꞉ di alifo꞉len amio꞉, ho꞉no꞉ tindaki ho꞉n dia꞉yo꞉ alan mio꞉ a꞉la꞉ta꞉ga꞉ fufayo꞉ halaido꞉ yakiyo꞉ ayamio꞉ bo꞉lo꞉. Ko꞉sega kalu elo꞉ a halaido꞉ di a꞉no꞉ mo꞉dugu ali. ");
INSERT INTO bco_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko꞉sega kalu abeyo꞉ ni to we da꞉da꞉sa꞉ga꞉lo꞉ mo꞉kudu ha꞉nab a꞉no꞉ asugdo꞉ma kaluwa꞉lo꞉ sa꞉ wa꞉l amilo꞉ a di o꞉ngo꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ho꞉no꞉ tindaki, ho꞉n dia꞉yo꞉ alan mio꞉ a꞉la꞉ta꞉ga꞉ fufayo꞉ halaido꞉ ba꞉labikiyo꞉, a a꞉no꞉ dugu alilaki, tambo bidi ane.” ");
INSERT INTO bco_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Ya꞉su eyo꞉ towo꞉ wida꞉la꞉ga꞉ eletabikiyo꞉, kaluka꞉isale modo꞉ ko꞉lo꞉ kegeo꞉ i a꞉no꞉ mada iligo꞉. ");
INSERT INTO bco_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mo꞉wo꞉ ha꞉, elo꞉ wido꞉ a꞉no꞉, elelo꞉ wida꞉sen kaluwa꞉lo꞉ wida꞉sen o꞉leau wido꞉ma. E wilo꞉ di kaluwa꞉lo꞉ halaido꞉ sa꞉lan au wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ya꞉suwo꞉ misio꞉wa a꞉la꞉ta꞉ga꞉ ololo tindabiki, kaluka꞉isaleyo꞉ mada modo꞉le ko꞉lo꞉ e kudu mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","A꞉la꞉ta꞉ga꞉ kalu aintalo꞉ dowo꞉ imilig nowo꞉ ya꞉sa꞉ga꞉, gulalu misa꞉fu alilakiyo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Kalu Alan, nelo꞉ falele alifa꞉no꞉ halaido꞉wo꞉ geya a꞉lab ko꞉lo꞉, giyo꞉ o꞉lila꞉ asulalega, ne amilo꞉ ainta we imulu alitaki, nafale ta꞉foma꞉ki asulab.” ");
INSERT INTO bco_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ dagiyo꞉ talagala꞉sa꞉ga꞉, kalu a꞉ma꞉ do꞉mo꞉wa golaki a꞉la꞉sio꞉, “Niyo꞉ o꞉li dimidama꞉nigo꞉l. Ge nafale doma.” Wigibo a꞉naka kalu amilo꞉ ainta sen a꞉no꞉ imulu alitaki, e nafale ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ge amilo꞉ dimido꞉l we kaluka꞉isale nolbo꞉wo꞉ mada sa꞉la꞉so꞉boka꞉. Ko꞉sega ge bobalo꞉ so꞉mea꞉sen kalulo꞉wa ha꞉na꞉sa꞉ga꞉, emo꞉ wida꞉bi. A꞉la꞉ta꞉ga꞉ Mo꞉sa꞉s elo꞉ boba dimia꞉no꞉ ele saefa꞉ o꞉leau dimia꞉bi. Giyo꞉ a꞉la꞉dimidalikiyo꞉, kaluka꞉isale iliyo꞉ ge falelo꞉lo꞉b a꞉la꞉asuluma꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Ya꞉suwo꞉ Kabaniom amisa꞉na fa꞉la꞉dowakiyo꞉, Loma꞉ ame kalulo꞉ bo꞉fo꞉lowan misa꞉ kalu noma꞉yo꞉ e asuwa꞉foma꞉ki dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kalu Alan, ni nanogdo꞉ dian kalu nowo꞉ do꞉mo꞉wo꞉ ko꞉go꞉neliaki, nagalo꞉wo꞉ alan dowo꞉ ko꞉lo꞉, ene ayami uwo꞉ba alifo꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ne ya꞉ga꞉yo꞉, ko꞉go꞉neli kalu ko falele alifa꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","A꞉la꞉sa꞉labikiyo꞉, ame misa꞉ kalu eyo꞉ a꞉la꞉sio꞉, “Alan, ne wilo꞉ma kalu ko꞉lo꞉, ge ni a usa mia꞉no꞉wo꞉ mo꞉ililo꞉. Ko꞉sega ge konaka iliki, giyo꞉ to ko꞉ sa꞉lalega, ni nanogdo꞉ dian kalu a꞉no꞉ o꞉li falele alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Niyo꞉ a꞉la꞉tili asulo꞉ mo꞉wo꞉, no꞉no꞉n ne, misa꞉ kalu noma꞉ bo꞉fo꞉labikiyo꞉, niyo꞉lo꞉ ame kalu nolo꞉ bo꞉fo꞉lo꞉l. Niyo꞉ ‘Hamana’ a꞉lab amio꞉, iyo꞉ ha꞉na꞉sen, a꞉la꞉ta꞉ga꞉ ‘Mena’ a꞉lab amio꞉, iyo꞉ ya꞉sen. Ni nanogdo꞉ dian kalumo꞉wo꞉ ‘Dimidama’ a꞉la꞉sa꞉lab amio꞉, iliyo꞉ dimida꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ya꞉suwo꞉ to a꞉no꞉ da꞉da꞉ga꞉ modakiyo꞉, kaluka꞉isale elo꞉ kudu ya꞉len o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Kalu wema꞉ tilidabuwo꞉ hendele alan dowo꞉ ko꞉lo꞉, Isolael hen wenamio꞉ ne kaluka꞉isaleya꞉ tilidabu we o꞉ngo꞉wo꞉ mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Kaluka꞉isaleyo꞉ ofdo꞉ yan doba꞉da꞉yo꞉lo꞉, ofdo꞉ tinan doba꞉da꞉yo꞉lo꞉ kegenelia꞉sa꞉ga꞉, Ablahamo꞉, Aisa꞉go꞉, Ya꞉kobo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen us a꞉namio꞉ ua sagala꞉li silikiyo꞉, ma꞉no꞉wo꞉ a꞉na na꞉li mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ko꞉sega kaluka꞉isale Godeya꞉ ene hena mesea꞉kilo꞉ tamin amilo꞉ da꞉feyo꞉ i a꞉no꞉, Gode eyo꞉ ha꞉la꞉ amilo꞉ sololi a꞉lab a꞉na sandifa꞉ib. Iyo꞉ a꞉no꞉ siliki, kulufa꞉yakiyo꞉ ya꞉foda꞉li mesa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ ame kalulo꞉ bo꞉fo꞉lowan misa꞉ kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ge a꞉ma꞉la꞉ hamana. Go꞉no꞉ndo꞉ tili asulab o꞉leau ka gelo꞉wa fa꞉la꞉doma꞉ib.” A꞉la꞉fo꞉ko꞉lo꞉ ene nanogdo꞉ dian kalu a꞉no꞉ wigibo a꞉naka falele alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ya꞉suwo꞉ Bidaya꞉ aya tina꞉sa꞉ga꞉ Bidaya꞉ ingaya꞉ anowo꞉, ofo꞉ walaf bo꞉lo꞉ ko꞉lo꞉, ene uwo꞉ba alifo꞉lena ba꞉ba꞉ ");
INSERT INTO bco_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ya꞉su eyo꞉ ga a꞉ma꞉ dagiya golabiki, wigibo a꞉naka ofo꞉wo꞉ bulutaki, walaf a꞉no꞉ falelabiki, e dasilia꞉ga꞉ ma꞉no꞉wo꞉ dia꞉sa꞉ga꞉ Ya꞉sumo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","A꞉la꞉ta꞉ga꞉ ga꞉lole a꞉namio꞉, kaluka꞉isale mama mogago꞉lo꞉ dowo꞉wo꞉ modo꞉ elo꞉wa tililia꞉ mio꞉. Ya꞉suwa꞉ to halaido꞉ a꞉ma꞉yo꞉ mama mogago꞉ a꞉no꞉ o꞉luga꞉felo꞉. A꞉la꞉ta꞉ga꞉ kaluka꞉isale walafdo꞉ bo꞉lo꞉ ko꞉lo꞉ elo꞉ amilo꞉ tililia꞉ mio꞉ a꞉no꞉ eyo꞉ tambo falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ya꞉su elo꞉ dimido꞉ a꞉ma꞉yo꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu Aisaya, eya a꞉la꞉ta꞉ga꞉lo꞉ to sio꞉ a꞉no꞉ ko꞉lo꞉ ilili alifa꞉. To saefa꞉ a꞉no꞉ we, “Ni amilo꞉ walaf dowab a꞉no꞉ ene dila꞉sa꞉ga꞉ dia꞉gane,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ya꞉su eyo꞉ kaluka꞉isale modo꞉wo꞉ e kuduyakilo꞉ kegeo꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, eyo꞉ enedo꞉ tiliwida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ Ga꞉lili ho꞉n golo꞉ we ta꞉nota꞉ga꞉ nodo honona ha꞉na꞉niki,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","To a꞉no꞉ sa꞉labikiyo꞉, elelo꞉ wida꞉sen kalu nowo꞉ ya꞉sa꞉ga꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, gelo꞉ siab amio꞉, ne ge kudu sia꞉mela꞉no꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ya꞉su eyo꞉ kalu emo꞉wo꞉ a꞉ma꞉la꞉ sa꞉laki, “Saila gasalo꞉ mesa꞉no꞉wo꞉ hen aluwo꞉ a꞉lab, a꞉la꞉ta꞉ga꞉ o꞉ba꞉yo꞉lo꞉ us silia꞉fa꞉no꞉wo꞉ ayo꞉ a꞉lab. Ko꞉sega Kalule Dowo꞉ e, a enedo꞉leyo꞉ mada aundo꞉ma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","A꞉la꞉ta꞉ga꞉ elo꞉ kudu sia꞉len kalu noma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ne ge kudu mia꞉no꞉ ko꞉sega, tamin amio꞉ ni amisa꞉na a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, do sowo꞉ ko꞉le dali alita꞉ga꞉yo꞉, ge a꞉na kudu mia꞉no꞉wo꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ko꞉sega Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale ne amilo꞉ mo꞉tilida꞉dab a꞉no꞉ sowo꞉ o꞉ngo꞉ sab ko꞉lo꞉, kaluka꞉isale i a꞉ma꞉yo꞉ iasi sowo꞉ a꞉no꞉ ini dalima꞉ki ta꞉foma. Ge ne kudu mena.” ");
INSERT INTO bco_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ya꞉suwo꞉ ho꞉n ko꞉suwa disa꞉labiki, enedo꞉ tiliwida꞉sen kaluwo꞉lo꞉ e kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Iyo꞉ ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉ ho꞉n golo꞉ usa dowabiki, fufa halaido꞉wo꞉ ya꞉sa꞉ga꞉, ho꞉n ko꞉su a꞉na ba꞉labikiyo꞉, ho꞉no꞉ do꞉lilia꞉ga꞉ tinaki, ho꞉n ko꞉suwo꞉ ho꞉na tina꞉no꞉wo꞉ ko꞉na꞉ma dowo꞉. Ko꞉sega fufalo꞉ ya꞉lab a꞉namio꞉ Ya꞉suwo꞉ alifo꞉len. ");
INSERT INTO bco_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Enedo꞉ tiliwida꞉sen kaluwa꞉yo꞉ Ya꞉suwo꞉ digida꞉yaki, “Alan nio꞉ soma꞉nigab ko꞉lo꞉, giyo꞉ nio꞉ asuwa꞉foma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Gio꞉ tilidabuwo꞉ ha꞉lula꞉sulo꞉b. Gio꞉ tagio꞉ mada alan dowabko꞉ mo꞉wo꞉ ha꞉?” A꞉la꞉sa꞉la꞉sa꞉ga꞉ Ya꞉su e dasilia꞉ga꞉, fufa o꞉lia꞉ ho꞉n golo꞉ o꞉lia꞉mo꞉wo꞉ bulufoma꞉kiyo꞉ towo꞉ halaido꞉ sa꞉labiki, fufa o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ a꞉na bulufo꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Enedo꞉ tiliwida꞉sen kalu iyo꞉ dimidab a꞉no꞉ ba꞉dakiyo꞉, molo tandeaki egelebo꞉ a꞉la꞉sio꞉, “Fufa o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ elo꞉ to sio꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉ kudu ha꞉nab we, kalu we o꞉bo꞉ngo꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iyo꞉ ho꞉no꞉ ta꞉nota꞉ga꞉ Gadala hen a꞉na fa꞉la꞉dowakiyo꞉, kalu a꞉la꞉ mama mogago꞉lo꞉ dowo꞉ a꞉no꞉ sowo꞉ kalulo꞉ dali alifela꞉sena a꞉la꞉ta꞉ga꞉ ya꞉sa꞉ga꞉, Ya꞉suwo꞉ a꞉na gido꞉. Kalu a꞉la꞉ a꞉ma꞉ halaido꞉wa꞉yo꞉ kalu nolo꞉ yasala꞉ma꞉no꞉ dowa꞉sen ko꞉lo꞉, kaluka꞉isaleyo꞉ tog a꞉namida꞉yo꞉ mo꞉ha꞉na꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A꞉la꞉ma꞉yo꞉ ganagilia ho꞉le sa꞉laki, “Godeya꞉ So꞉wa giyo꞉ nimo꞉wo꞉ o꞉b dimidama꞉nigaya? Da꞉feyo꞉ ho꞉len a꞉no꞉ o꞉semo꞉fa꞉la꞉dowo꞉ amio꞉, giyo꞉ nimo꞉wo꞉ nagalo꞉wo꞉ waga dimia꞉nigaya? Wangabiki mogagila꞉ma꞉nigaya?” ");
INSERT INTO bco_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ko꞉na꞉ma a꞉namio꞉ kabo fofo꞉wo꞉ modo꞉ ko꞉lo꞉ ma꞉no꞉ na꞉li sen. ");
INSERT INTO bco_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Mama mogago꞉ i a꞉ma꞉yo꞉ Ya꞉sumo꞉ ha꞉nolo sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Giyo꞉ nio꞉ o꞉lusa꞉ma꞉no꞉ a꞉lalega, nio꞉ kabo fofo꞉ honona ti hamana꞉ki ta꞉foma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ya꞉su eyo꞉ imo꞉wo꞉ “Hamana” a꞉la꞉sa꞉labiki, iyo꞉ ha꞉la꞉ya sili alita꞉ga꞉yo꞉, kabo sen a꞉na tiane. A꞉la꞉ta꞉ga꞉ kabo i a꞉no꞉ do꞉mo꞉ gede to꞉lolo꞉ a꞉na nai tina꞉sa꞉ga꞉, ho꞉n golo꞉wa tina꞉siaki, kanda sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kalu kabolo꞉ bo꞉fo꞉lowa꞉sen a꞉no꞉ nai ha꞉na꞉sa꞉ga꞉, inin amisa꞉n a꞉na fa꞉la꞉dowakiyo꞉ kabo amilo꞉ dimido꞉ a꞉no꞉lia꞉ kalu a꞉la꞉ amilo꞉ mama mogago꞉ o꞉luso꞉no꞉ a꞉no꞉ tambo malola꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","A꞉la꞉fo꞉ko꞉lo꞉ amisa꞉n kaluka꞉isale tambowo꞉ Ya꞉suwo꞉ galima꞉ni ane. Iyo꞉ Ya꞉suwo꞉ galilia꞉sa꞉ga꞉yo꞉, e hen ililo꞉ a꞉no꞉ ta꞉fo꞉ hamana꞉ki towo꞉ halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ya꞉suwo꞉ ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉yo꞉, Ga꞉lili ho꞉n golo꞉ a꞉no꞉ ta꞉nota꞉ga꞉ ene amisa꞉na fa꞉la꞉dowo꞉ ");
INSERT INTO bco_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kalu nolba꞉yo꞉ kalu nowo꞉ do꞉mo꞉wo꞉ ko꞉go꞉neli ko꞉lo꞉ sesegasulia꞉ga꞉ Ya꞉sulo꞉wa mio꞉. Ya꞉su eyo꞉ inin tilidabu a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, ko꞉go꞉neli kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ni so꞉wa, gi asulo꞉wo꞉ halale doma! Man mogago꞉ gilo꞉ dimida꞉sen a꞉no꞉ halaki dilo꞉ka꞉.” ");
INSERT INTO bco_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ho꞉len a꞉namio꞉ elelo꞉ wida꞉sen kalu nolo꞉ a꞉na sen ko꞉lo꞉, iliyo꞉ egelebo꞉ a꞉la꞉nenelo꞉, “Kalu we Godeya꞉ heno꞉ e diaki sa꞉lakigab.” ");
INSERT INTO bco_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ya꞉su eyo꞉ ililo꞉ kele asulab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Asulo꞉ mogago꞉ gi amio꞉ fa꞉la꞉dowab ko mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Gi asulo꞉wo꞉ mo꞉da꞉galitaki, niyo꞉ to o꞉b ko꞉lo꞉ sa꞉ma꞉no꞉wa꞉le? Niyo꞉ o꞉go꞉ a꞉la꞉so꞉lo꞉l, ‘Man mogago꞉ gilo꞉ dimida꞉sen a꞉no꞉ halaki dilo꞉ka꞉.’ To o꞉leo꞉ngo꞉ma꞉yo꞉ gi asulo꞉wo꞉ o꞉li da꞉galifa꞉iba꞉le? A꞉la꞉ta꞉ga꞉ to nowo꞉ we ‘Ge dasilia꞉ga꞉ hamana!’ a꞉la꞉do꞉ sa꞉lab a꞉ma꞉yo꞉ gi asulo꞉wo꞉ o꞉li da꞉galifa꞉iba꞉le? Giliyo꞉ waga asulaya? ");
INSERT INTO bco_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ko꞉sega Kalule Dowo꞉ ne henfelo꞉ wena ilikiyo꞉, mogago꞉wo꞉ halakilo꞉ ga꞉lila꞉ma꞉no꞉ a꞉no꞉ ne amio꞉ halaido꞉wo꞉ a꞉labo꞉lo꞉b a꞉la꞉bo꞉ giliyo꞉ asuluma꞉kiyo꞉ walama꞉nigo꞉l.” A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, ko꞉go꞉neli kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ge dasilia꞉ga꞉, sesegasu we dia꞉ga꞉, go꞉no꞉n aya hamana,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","A꞉la꞉fo꞉ko꞉lo꞉ kalu a꞉no꞉ dasila꞉sa꞉ga꞉ ene aya ane. ");
INSERT INTO bco_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kaluka꞉isale kegeo꞉ a꞉no꞉ dimidab a꞉no꞉ ba꞉dakiyo꞉, iyo꞉ tagi dowo꞉. Gode eyo꞉ halaido꞉ wengo꞉wo꞉ kalumo꞉wo꞉ dimilo꞉b a꞉la꞉asulakiyo꞉, iliyo꞉ Godeyo꞉ wiyo꞉ wabulu sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ya꞉suwo꞉ a꞉na a꞉la꞉ta꞉ga꞉ ha꞉na꞉ga꞉ ha꞉nakiyo꞉, kalu nowo꞉ ba꞉ba꞉. Ene wiyo꞉ Madiyu ko꞉lo꞉, e takis molelo꞉ dian a usa sena ba꞉ba꞉. Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge ne kudu mena.” A꞉la꞉sa꞉labiki Madiyu e dasila꞉sa꞉ga꞉ Ya꞉su kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tif amio꞉ Ya꞉su e Madiyuwa꞉ aya ma꞉no꞉ ma꞉ni ane ko꞉lo꞉, e ma꞉no꞉ na꞉likiyo꞉, takis molelo꞉ dian kalu nol o꞉lia꞉ mogago꞉lo꞉ dimida꞉sen kalu nolo꞉lo꞉ ya꞉sia꞉sa꞉ga꞉, Ya꞉su o꞉lia꞉ enedo꞉ tiliwida꞉sen kalu i o꞉lia꞉ ma꞉no꞉wo꞉ ua na꞉li sen. ");
INSERT INTO bco_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Fa꞉lisi kaluwo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉lo꞉ tiliwida꞉sen kalumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu gililo꞉ ko, takis molelo꞉ dia꞉sen kalu o꞉lia꞉ mogago꞉lo꞉ dimida꞉sen kalu i o꞉lia꞉ uwa silikilo꞉ ma꞉no꞉wo꞉ nab we mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ko꞉sega Ya꞉su eyo꞉ ililo꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Mulumulo꞉lo꞉ mean kaluwa꞉yo꞉ walafdo꞉ma kaluka꞉isale ilo꞉ a꞉namio꞉ mo꞉ha꞉nan. Ko꞉sega mulumulo꞉lo꞉ mean kaluwa꞉yo꞉ walafdo꞉ bo꞉lo꞉ kaluka꞉isale ilo꞉wa ha꞉nan. ");
INSERT INTO bco_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","To we Godeya꞉ bugo꞉ amio꞉ sa꞉sa꞉lifa꞉ da꞉lab, ‘Gililo꞉ no꞉ ko꞉lo꞉ nemo꞉lo꞉ bo꞉ba so꞉mea꞉lab a꞉no꞉ wa꞉la꞉bo꞉ o꞉mba. Gio꞉ nol o꞉lia꞉yo꞉ nofolakilo꞉ ha꞉fo꞉ disa꞉lab a꞉no꞉ ne mada alan asulab.’ Giliyo꞉ to a꞉ma꞉ ha꞉go꞉ fanda asuluma꞉niki keda꞉bi. A꞉la꞉go꞉ko꞉lo꞉ ne digalo꞉ kaluwo꞉ ko꞉lo꞉ ho꞉lema꞉ni mio꞉ma. Ne mogago꞉lo꞉ dimida꞉lab kaluwo꞉ ko꞉lo꞉ ho꞉lema꞉ni mio꞉,” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ho꞉len a꞉namio꞉ Yo꞉na꞉lo꞉ tili widan kalu nolo꞉ ya꞉sa꞉ga꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Fa꞉lisi kaluwa꞉yo꞉lo꞉, niliyo꞉lo꞉ ho꞉len nol amio꞉ ma꞉no꞉ ma꞉no꞉wo꞉ eleta꞉ga꞉ sa꞉sen. Ko꞉sega tili wida꞉sen kalu gilo꞉ wema꞉yo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ ho꞉len nolo꞉ mo꞉eletakilo꞉ na꞉lab a꞉no꞉ mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ bale sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Ga tili alitakilo꞉ kalu kegeo꞉ a꞉namio꞉, iyo꞉ mo꞉nofolaki, ma꞉no꞉wo꞉ sagala꞉liki ma꞉ib, mo꞉wo꞉ galo꞉ in a꞉no꞉ i o꞉lia꞉ a꞉lab. Ko꞉sega ho꞉len tif amio꞉, galo꞉ in a꞉no꞉ iyo꞉ ta꞉ta꞉ga꞉ ha꞉nab a꞉namio꞉, kalu kegeo꞉ a꞉no꞉ nofolakiyo꞉, ma꞉no꞉ ma꞉no꞉wo꞉ ho꞉len a꞉na eleta꞉ga꞉ mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kalu noma꞉yo꞉ helebeso꞉g ho꞉giyo꞉ o꞉semo꞉ gendeli amio꞉ dia꞉sa꞉ga꞉yo꞉, mo꞉luwo꞉ bidifo꞉ wa꞉l amio꞉ mo꞉dubinima꞉ib. Kalu a꞉ma꞉yo꞉ a꞉la꞉bo꞉ dubialega, helebeso꞉g ho꞉gi a꞉no꞉ gendelakiyo꞉, mo꞉luwo꞉ a꞉no꞉ tambo bidima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","A꞉la꞉ta꞉ga꞉ bale sa꞉ma꞉no꞉wo꞉ nowo꞉ we. Kalu noma꞉yo꞉ wain ho꞉n ho꞉gi a꞉no꞉ no꞉ do꞉go꞉f dubio꞉ mo꞉luwo꞉ us a꞉namio꞉ mo꞉guma꞉ib. A꞉la꞉dimidalega, wain ho꞉gi a꞉ma꞉ ho ha꞉na꞉no꞉wo꞉ ko꞉ndo꞉feaki, no꞉ do꞉go꞉f mo꞉luwo꞉ a꞉no꞉ bidi buluga꞉talikiyo꞉, wain ho꞉n a꞉no꞉ hena walaki, no꞉ do꞉go꞉f dubio꞉ a꞉no꞉lo꞉ mogago꞉ doma꞉ib. A꞉la꞉gan ko꞉lo꞉ wain ho꞉n ho꞉gi a꞉no꞉ no꞉ do꞉go꞉f dubio꞉ ho꞉gi a꞉na guma꞉ib ko꞉lo꞉, wain o꞉lia꞉ no꞉ do꞉go꞉f dubio꞉ a꞉no꞉lo꞉ o꞉li doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ya꞉su e Yo꞉na꞉lo꞉ tili widan kalumo꞉wo꞉ to a꞉no꞉ sa꞉la꞉len amio꞉, Yuwa꞉ misa꞉ kalu nowo꞉ ya꞉sa꞉ga꞉, Ya꞉sulo꞉wa gulalu misa꞉fu alilaki a꞉la꞉sio꞉, “Ni na꞉la꞉yo꞉ o꞉g wigibo wenaka sowab ko꞉lo꞉, ge ya꞉sa꞉ga꞉ dagiyo꞉ e do꞉mo꞉wa goma꞉ni mena. Giyo꞉ a꞉la꞉dimidalikiyo꞉, e a꞉ma꞉la꞉ dasima꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ya꞉suwo꞉ dasila꞉sa꞉ga꞉ kalu a꞉no꞉lia꞉ ha꞉nabiki, enedo꞉ tiliwida꞉sen kaluwo꞉lo꞉ e kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hen a꞉namio꞉ ga nowo꞉ donayo꞉ kugula꞉fo꞉ us a꞉namio꞉ tin hoda꞉liki elen ko꞉lo꞉, iyo꞉ a꞉na ha꞉nabiki ga a꞉no꞉ Ya꞉suwa꞉ fa꞉s doba꞉da꞉ ya꞉sa꞉ga꞉, Ya꞉suwa꞉ so꞉g sa꞉ga꞉lo꞉ migif a꞉na golo꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ga a꞉ma꞉ eneno꞉ a꞉la꞉asulo꞉, “Niyo꞉ Ya꞉suwa꞉ so꞉g migif wenaka golalega, ne falele alitaki o꞉li doma꞉ib,” a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ya꞉suwo꞉ nodola꞉sa꞉ga꞉, ga a꞉no꞉ ba꞉da꞉ga꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉la꞉, gi asulo꞉wo꞉ halale doma. Go꞉no꞉n tilidabu koma꞉yo꞉ ge o꞉li falele alitab.” A꞉la꞉sa꞉labiki, wigibole a꞉naka ga a꞉no꞉ falelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ya꞉suwo꞉ o꞉ha꞉na꞉la꞉ga꞉, misa꞉ kaluwa꞉ aya fa꞉la꞉dowaki ba꞉ba꞉yo꞉, kaluka꞉isaleyo꞉ sowo꞉ a꞉no꞉ kuo꞉ya꞉lena ba꞉ba꞉. Nolo꞉ uluna tolaki, nolo꞉ towo꞉ halale tandea꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ hamana. Ga we sowo꞉ma, e mida꞉iyo꞉ alifo꞉lab.” Iliyo꞉ Ya꞉suwa꞉lo꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉ o꞉go꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ko꞉sega kaluka꞉isale kegeo꞉ a꞉no꞉ ha꞉la꞉ya iliga꞉ta꞉ga꞉ sabikiyo꞉, Ya꞉suwo꞉ a usa tiha꞉na꞉sa꞉ga꞉, ka꞉isale so꞉wa a꞉no꞉ dagiya gasiliabikiyo꞉, e a꞉na dasili. ");
INSERT INTO bco_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ya꞉su elo꞉ dimido꞉ a꞉no꞉ malola꞉li ha꞉nabiyo꞉, hen a꞉namida꞉yo꞉ tambo da꞉da꞉li ane. ");
INSERT INTO bco_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ya꞉suwo꞉ hen a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nabikiyo꞉, siyo꞉ ko꞉n kalu a꞉la꞉ nowo꞉ e ko꞉lo꞉ kudu yaki, emo꞉wo꞉ ogolo ho꞉le sa꞉la꞉likiyo꞉, “Da꞉ibida꞉ ema꞉mu giyo꞉ na꞉no꞉ nofolaki asuwa꞉foma,” a꞉la꞉sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ya꞉suwo꞉ a usa tina꞉sa꞉ga꞉ elena, siyo꞉ ko꞉n kalu a꞉la꞉ a꞉no꞉ elo꞉wa yabikiyo꞉, eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ga꞉go꞉ niyo꞉ o꞉li falele alifa꞉ib a꞉la꞉bo꞉ tili asulaya?” A꞉la꞉dabu ba꞉dabiki, a꞉la꞉ma꞉yo꞉, “A꞉, Kalu Alan, naino꞉ tili asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉ma꞉ siya golakiyo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ hendele tilidabu o꞉leo꞉ngo꞉ ka fa꞉la꞉doma.” ");
INSERT INTO bco_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","A꞉la꞉sa꞉labiki, a꞉la꞉ma꞉ siyo꞉ kolaetabiki, o꞉li ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ to hagugo꞉wo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale nolo꞉ asulo꞉wo꞉ diabena꞉ki, mada sa꞉la꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ko꞉sega a꞉la꞉yo꞉ ha꞉na꞉siakiyo꞉, Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ hen a꞉namida꞉yo꞉ tambo malola꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kalu a꞉la꞉yo꞉ ayo꞉ ta꞉ta꞉ga꞉ ha꞉nabikiyo꞉, kalu mama mogago꞉ dowakilo꞉ do꞉fo꞉f dowo꞉wo꞉ Ya꞉sulo꞉wa tililia꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Mama mogago꞉ a꞉no꞉ o꞉lusanaga꞉ta꞉ga꞉yo꞉, kalu do꞉fo꞉f elen a꞉no꞉ towo꞉ a꞉sa꞉labiki, kaluka꞉isale kegeo꞉ a꞉no꞉ molo tandeaki a꞉la꞉sio꞉, “Nio꞉ dimido꞉ wengo꞉wo꞉ Isolael hen wenamio꞉ mada mo꞉ba꞉ba꞉.” ");
INSERT INTO bco_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ko꞉sega Fa꞉lisi kalu ili sa꞉lakiyo꞉, “Kalu ko, Mama mogago꞉ elo꞉ o꞉lusa꞉ndab a꞉no꞉, mama mogago꞉wa꞉ misa꞉ a꞉ma꞉ halaido꞉ a꞉na iliki dimidab.” ");
INSERT INTO bco_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ya꞉suwo꞉ hen alan amio꞉lo꞉, amisa꞉n a꞉namio꞉lo꞉ sia꞉likiyo꞉, ili tolo꞉ wida꞉sen ayamio꞉ mano꞉ wida꞉li ha꞉nakiyo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉ma꞉ to nafayo꞉ kalaba wida꞉len. A꞉la꞉ta꞉ga꞉ walaf ko꞉li ko꞉lilo꞉ kaluka꞉isale a꞉namilo꞉ dosdo꞉ a꞉no꞉ tambo falele alifela꞉i sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ya꞉su eyo꞉ kalu kegeo꞉ a꞉no꞉ ba꞉dakiyo꞉, i a꞉no꞉ no꞉ sibi ko꞉lo꞉ bo꞉fo꞉lowano꞉ aundo꞉malo꞉ngo꞉ ba꞉ba꞉. Iyo꞉ kele asulo꞉wo꞉ alan dowaki, enena꞉ma꞉la꞉ asuwa꞉fa꞉no꞉wo꞉ mo꞉dowo꞉ ko꞉lo꞉ Ya꞉su eyo꞉ i a꞉no꞉ mada nofolo꞉. ");
INSERT INTO bco_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ enedo꞉ tiliwida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Egelo꞉ amilo꞉ fowo꞉ nafaliabdo꞉ tuma꞉no꞉wo꞉ modo꞉ dowab ko꞉sega, kalu o꞉lo꞉ tuma꞉no꞉wo꞉ a꞉la꞉se dowab. ");
INSERT INTO bco_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ egelo꞉lo꞉ biso꞉mo꞉ dulugu sa꞉lakiyo꞉, eyo꞉ fowo꞉ nafaliab o꞉lo꞉ tuma꞉no꞉ kaluwo꞉ modo꞉ iliga꞉foma꞉ki dabu ba꞉da꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ya꞉su eyo꞉ tiliwida꞉sen kalu kugula꞉fo꞉ a꞉no꞉ ene ho꞉le kegenelia꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ mama mogago꞉wo꞉ o꞉lusanaga꞉felema꞉ki, a꞉la꞉ta꞉ga꞉ walaf ko꞉li ko꞉lilo꞉ tambo falele alifelema꞉kiyo꞉, Ya꞉su eyo꞉ halaido꞉wo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Enedo꞉ tiliwida꞉sen kalu kugula꞉fo꞉ i a꞉ma꞉ wiyo꞉ we. Agelo꞉ Saimon, ene wiyo꞉ nowo꞉ Bida, a꞉la꞉ta꞉ga꞉ ene ao Andulu, a꞉la꞉ta꞉ga꞉ Sa꞉ba꞉diya꞉ inso꞉ Ya꞉ma꞉s o꞉lia꞉ ene ao Yo꞉n. ");
INSERT INTO bco_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Nowo꞉ Filib, nowo꞉ Batolomiyu, nowo꞉ Tomas, nowo꞉ Madiyu, takis molelo꞉ dian kalu, nowo꞉ Aofiusa꞉ inso꞉ Ya꞉ma꞉s, nowo꞉ Tadius. ");
INSERT INTO bco_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Nowo꞉ Saimon, e gamani ho꞉giyo꞉ dimo꞉losa꞉ a꞉lakilo꞉ asula꞉seno꞉ e a꞉la꞉ta꞉ga꞉ kalu nowo꞉ Yudas Iskaliot, Ya꞉sulo꞉ teledowo꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ya꞉su eyo꞉ kalu kugula꞉fo꞉ i a꞉no꞉ iliga꞉fa꞉nikiyo꞉, ililo꞉ dimidama꞉no꞉wo꞉ asulufo꞉ hamana꞉ki, imo꞉ widaki a꞉la꞉sio꞉, “Yu kaluka꞉isalema ilo꞉ amio꞉ ha꞉na꞉so꞉bo. A꞉la꞉ta꞉ga꞉ Samalia kaluwa꞉ amisa꞉n a꞉namida꞉yo꞉lo꞉ ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isolael kaluka꞉isaleyo꞉ no꞉ sibi sulu aneyo꞉ o꞉ngo꞉ ko꞉lo꞉lab ko꞉lo꞉, gio꞉ ilo꞉leya ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gio꞉ ha꞉nakiyo꞉, ‘Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ ko꞉na꞉ma dowab’ a꞉la꞉wida꞉li ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Giliyo꞉ walaf kaluka꞉isaleyo꞉ falele alifela꞉bi. Sowo꞉ kaluka꞉isaleyo꞉lo꞉ a꞉ma꞉la꞉ dasi alita꞉bi. Aintalo꞉ dosdo꞉wo꞉ imulu alifela꞉bi. Mama mogago꞉lo꞉ dosdo꞉wo꞉ o꞉luga꞉fela꞉bi. Giliyo꞉ mo꞉kililiaki, madali di ko꞉lo꞉, nolbo꞉wo꞉lo꞉ madali dimia꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Giliyo꞉ go꞉l, silba, ko꞉ba moleyo꞉ mole as amio꞉ disa꞉ta꞉ga꞉yo꞉ ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","As amilo꞉ sa꞉la꞉ alano꞉ dia꞉ha꞉na꞉so꞉bo. Helebeso꞉g o꞉lia꞉ budi nowo꞉ a꞉bata꞉ga꞉yo꞉ dia꞉ha꞉na꞉so꞉bo. A꞉la꞉ta꞉ga꞉ ido꞉mo꞉lo꞉ dia꞉ha꞉na꞉so꞉bo. Mo꞉wo꞉ kalu abeyo꞉ nanogdo꞉ diab a꞉ma꞉yo꞉ nanog di a꞉na ilikiyo꞉, ma꞉no꞉wo꞉ o꞉li dia꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Gio꞉ amisa꞉n amiya꞉le, hen alan amiya꞉le fa꞉la꞉dowakiyo꞉, gilo꞉ tilidoma꞉no꞉ kalu nafa nowo꞉ keda꞉sa꞉ga꞉ ba꞉dalikiyo꞉, a elo꞉ a꞉naka sa꞉ga꞉, hen a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nakiyo꞉, a a꞉no꞉ a꞉na ta꞉fo꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gio꞉ a usa tina꞉ga꞉yo꞉, sagalo꞉ towo꞉ alo꞉ biso꞉mo꞉ ko꞉le sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kalu a꞉namilo꞉ sen a꞉ma꞉yo꞉ gilo꞉ tilidoma꞉no꞉wo꞉ o꞉li ego꞉ dowalega, gio꞉ i o꞉lia꞉yo꞉ ha꞉sa siliki a꞉naka dowa꞉bi. Ko꞉sega iliyo꞉ gilo꞉ tilidoma꞉no꞉wo꞉ o꞉liyo꞉ mo꞉dowalega, ha꞉salo꞉ doma꞉no꞉wo꞉ go꞉no꞉nka dota꞉ga꞉, ka ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kalu nolba꞉yo꞉ gio꞉ a a꞉namio꞉ mo꞉tililialega, o꞉ kalu nolba꞉yo꞉ to gililo꞉ widabo꞉ mo꞉da꞉dalega, gili gido꞉fo꞉ amilo꞉ hena꞉mu bo꞉lo꞉ a꞉no꞉ a꞉naka fifila꞉sa꞉ga꞉ ta꞉fo꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Godeya꞉ kaluka꞉isalelo꞉ mo꞉walilab ho꞉len a꞉namio꞉, amisa꞉n wenamilo꞉ hida꞉yo꞉ fa꞉la꞉doma꞉ib a꞉ma꞉yo꞉, hida꞉yo꞉ Sodom dia꞉ Gomola dia꞉ma꞉lo꞉ dia꞉ib a꞉no꞉ tininima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Gio꞉ dabuma! Sibi ko꞉lo꞉ saila gasalo꞉ sab amilo꞉ ha꞉nan aumbo꞉, niyo꞉ gio꞉ sibi o꞉ngo꞉ ko꞉lo꞉ iliga꞉to꞉l. A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ sia꞉likiyo꞉, asulo꞉ nafale diaki, ha꞉sa dowa꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Gio꞉ dinafa dowa꞉bi. Kalu nolba꞉yo꞉ gio꞉ ta꞉lia꞉sa꞉ga꞉, ini ganisololo꞉wa mo꞉walilima꞉ib. A꞉la꞉ta꞉ga꞉ ili tolo꞉ wida꞉sen ayamio꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉ yame tandema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ne wiya a꞉la꞉ta꞉ga꞉yo꞉, nolba꞉yo꞉ gio꞉ tililia꞉ga꞉ gamani bo꞉fo꞉lowan kalulo꞉ amio꞉lo꞉, a꞉la꞉ta꞉ga꞉ misa꞉ kalu alando꞉ a꞉namio꞉lo꞉ mo꞉walilima꞉niki tililia꞉ ha꞉na꞉ib. A꞉la꞉ta꞉ga꞉ ililo꞉ gi ko꞉lo꞉ mo꞉walilab a꞉na ilikiyo꞉, gio꞉ ne o꞉lia꞉ sia꞉likilo꞉ ba꞉da꞉len o꞉lia꞉ da꞉da꞉len o꞉lia꞉ a꞉no꞉ misa꞉ kalumo꞉wo꞉lo꞉, ha꞉la꞉ kalu imo꞉wo꞉lo꞉ kalaba sama꞉ki gab. ");
INSERT INTO bco_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ko꞉sega iliyo꞉ gio꞉ mo꞉walilalega, giliyo꞉ a꞉ma꞉la꞉bo꞉ o꞉b sa꞉ma꞉no꞉wa꞉le, waga sa꞉ma꞉no꞉wa꞉le a꞉la꞉bo꞉ kele asula꞉so꞉bo. Ho꞉len a꞉naka gililo꞉ a꞉ma꞉la꞉ sa꞉ma꞉no꞉wo꞉ gimo꞉wo꞉ dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mo꞉wo꞉ to a꞉no꞉ ginin ka sa꞉ma꞉iba. Ko꞉sega Dowa꞉ Mama eyo꞉ giya a꞉la꞉ta꞉ga꞉ sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","“Gio꞉ ni wiyo꞉ ta꞉lisab ko꞉lo꞉, kaluka꞉isale tambowa꞉yo꞉ gimo꞉wo꞉ kulufa꞉yo꞉wo꞉ alan doma꞉ib. Ho꞉len a꞉namio꞉ kalu noma꞉yo꞉ ene aoleyo꞉ sana soma꞉ki teledoma꞉ib. Iyaya꞉yo꞉ ene inso꞉wo꞉ sana soma꞉ki teledoma꞉ib. A꞉la꞉ta꞉ga꞉ so꞉wa iliyo꞉ iya o꞉lia꞉ ano o꞉lia꞉mo꞉wo꞉ a꞉la꞉iyaki, iyo꞉ sana soma꞉ki teledoma꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ hida꞉yo꞉ a꞉namio꞉ halaido꞉ dofo꞉ko꞉ ha꞉na꞉la꞉ga꞉ eleya edalega, Gode eyo꞉ iyo꞉ asuwa꞉takiyo꞉ a꞉ma꞉la꞉ gasilia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Hen imilig no amio꞉ gimo꞉wo꞉ hida꞉yo꞉ ko꞉li ko꞉lilo꞉ dimialega, hen nowa bo꞉bo꞉ge ha꞉na꞉bi. A꞉la꞉do꞉ so꞉lo꞉lo꞉ mo꞉wo꞉ we. Gio꞉ sia꞉likiyo꞉, Isolael hen usamilo꞉ amisa꞉no꞉ tambo semo꞉ ililila꞉ elena, Kalule Dowo꞉ e a꞉naka mia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Kaluka꞉isaleya꞉ siwa꞉l amio꞉, tili wida꞉sen kaluwa꞉ wi a꞉ma꞉yo꞉ ilo꞉ widan kaluwa꞉ wi a꞉no꞉ mo꞉tininima꞉ib. A꞉la꞉ta꞉ga꞉ nanogdo꞉ dian kaluwa꞉ wi a꞉ma꞉yo꞉, ini misa꞉ kaluwa꞉ wi a꞉no꞉ mo꞉tininima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Tili wida꞉sen kalu iyo꞉ ini widan kalu o꞉leo꞉ngo꞉ doma꞉no꞉wo꞉ o꞉li. A꞉la꞉ta꞉ga꞉ nanogdo꞉ dian kalu iliyo꞉ ini misa꞉ kalu o꞉ngo꞉ doma꞉no꞉wo꞉ o꞉li. Alo꞉ biso꞉mo꞉wo꞉, ‘Mama mogago꞉wa꞉ misa꞉ kalu, Bia꞉sabul a꞉no꞉ geka꞉’ a꞉la꞉sio꞉lalega, iliyo꞉ a a꞉namilo꞉ sa꞉sen kalu imo꞉wo꞉lo꞉ mada mogagi sa꞉laki gab. ");
INSERT INTO bco_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Giliyo꞉ kalu i a꞉no꞉ tagila꞉so꞉bo. Mo꞉wo꞉ kelego꞉ go꞉lula꞉fo꞉likilo꞉ da꞉lab a꞉no꞉, tif amio꞉ tambo kalaba fa꞉la꞉doma꞉ib. A꞉la꞉ta꞉ga꞉ kelego꞉ wo꞉no꞉lelo꞉ delen a꞉no꞉ kaluka꞉isaleyo꞉ tambo asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","To nilo꞉ gimo꞉lo꞉ sololi amilo꞉ sio꞉ a꞉no꞉ giliyo꞉ ho꞉lena sa꞉la꞉bi. A꞉la꞉ta꞉ga꞉ nilo꞉ gimo꞉lo꞉ ka꞉la꞉n amilo꞉ wo꞉no꞉lelo꞉ sio꞉ a꞉no꞉, giliyo꞉ kalaba kagafo꞉liki kaluka꞉isalemo꞉wo꞉ ho꞉le sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kalu i a꞉ma꞉yo꞉ gi do꞉mo꞉wo꞉ o꞉li sana soma꞉ib, ko꞉sega gi mela꞉no꞉ mama o꞉lo꞉ mo꞉goma꞉ib ko꞉lo꞉, kalu i a꞉no꞉ tagila꞉so꞉bo. Ko꞉sega gio꞉ Godeyo꞉ ko꞉lo꞉ tagila꞉bi. Mo꞉wo꞉ mama mela꞉no꞉ o꞉lia꞉ do꞉mo꞉ o꞉lia꞉yo꞉ de hen ami ta꞉takilo꞉ mogagila꞉ma꞉no꞉ a꞉no꞉ halaido꞉wo꞉ eya a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","O꞉ba꞉ galin a꞉no꞉ o꞉ngo꞉malo꞉ngo꞉ dowo꞉ ko꞉lo꞉, magede a꞉namio꞉ o꞉ba a꞉la꞉yo꞉ mole us imiliseya꞉ kililia꞉sen. Ko꞉sega o꞉ba꞉ galin dalale sab a꞉namio꞉ imilig nowo꞉ hena sulufo꞉ ti ha꞉na꞉lalega, Go꞉la꞉yo꞉ o꞉ba꞉ a꞉no꞉ mada ba꞉da꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","O꞉ba꞉ galin modo꞉ sab a꞉no꞉ gili tinio꞉ ko꞉lo꞉, Gode eyo꞉ gio꞉ mada dinafa ba꞉da꞉lab. A꞉la꞉ta꞉ga꞉ Gode eyo꞉ gili misa꞉ fo꞉no꞉ tambo agelelia꞉sa꞉ga꞉yo꞉ asululi ko꞉lo꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ tagila꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isale abeyo꞉ ‘Ne Kelisoka꞉’ a꞉la꞉bo꞉ ko꞉lo꞉ kaluka꞉isaleya꞉ siwa꞉la sa꞉lalega, niyo꞉lo꞉ Hebene halonamio꞉ Dowa꞉ siwa꞉l amio꞉ ‘E nino꞉ka꞉’ a꞉la꞉bo꞉ sa꞉ma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ko꞉sega kaluka꞉isale abeyo꞉ kaluka꞉isaleya꞉ siwa꞉l amio꞉ ne gola ba꞉daki, ni wiyo꞉ mo꞉sa꞉lalega, Hebene amio꞉ Dowa꞉ siwa꞉l amio꞉ niyo꞉lo꞉ e gola ba꞉daki, e wiyo꞉lo꞉ mo꞉sa꞉ma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Giliyo꞉ ne mio꞉ we, sagalo꞉ ha꞉salo꞉ mesa꞉no꞉ ko꞉lo꞉ dia꞉ mio꞉lo꞉b a꞉la꞉bo꞉ asula꞉so꞉bo. Ne wena yakiyo꞉ ha꞉salo꞉ mesa꞉no꞉ dia꞉ mio꞉ma. Ko꞉sega niyo꞉ helebesi o꞉lia꞉ dia꞉ mia꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ne mio꞉ we, “ ‘so꞉wayo꞉ ene iya o꞉lia꞉yo꞉ gis dimidama꞉ki a꞉la꞉ta꞉ga꞉, ka꞉isale so꞉wayo꞉ ene ano o꞉lia꞉yo꞉ gis dimidama꞉ki a꞉la꞉ta꞉ga꞉, ano o꞉lia꞉ inso꞉wa꞉ inga o꞉lia꞉yo꞉ gis dimidama꞉ki mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Gis kalulo꞉ fa꞉la꞉doma꞉ibo꞉ ene so꞉lo꞉lema꞉ fa꞉la꞉doma꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Kalu abeyo꞉ e iya o꞉lia꞉ ano o꞉lia꞉yo꞉ mada alan asulakilo꞉, nelo꞉ mo꞉dinafa asulab a꞉no꞉, ni so꞉lo꞉ doma꞉no꞉wo꞉ mo꞉ililo꞉. Kalu abeyo꞉ ene ida꞉ o꞉lia꞉ inso꞉ o꞉lia꞉yo꞉ mada alan asulakilo꞉, nelo꞉ mo꞉dinafa asulab a꞉no꞉, ni so꞉lo꞉ doma꞉no꞉wo꞉ mo꞉ililo꞉. ");
INSERT INTO bco_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kalu abeyo꞉ ene i malano꞉ eneno꞉ dia꞉sa꞉ga꞉yo꞉ ne mo꞉kudu yalega, ni so꞉lo꞉ doma꞉no꞉wo꞉ mo꞉ililo꞉. ");
INSERT INTO bco_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kaluka꞉isale abeyo꞉ ene mela꞉no꞉wo꞉ kanulu ta꞉li dofo꞉lalega, ene mela꞉no꞉ a꞉no꞉ sulu ha꞉na꞉ib. Kaluka꞉isale abeyo꞉ ne wiya a꞉la꞉ta꞉ga꞉ ene mela꞉no꞉wo꞉ walalega, ene mela꞉no꞉wo꞉ dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Kalu o꞉ba꞉le gililo꞉ sagala꞉likilo꞉ tili dowab a꞉no꞉, nemo꞉ sagala꞉liki tili dowab. A꞉la꞉ta꞉ga꞉ kalu nelo꞉ sagala꞉likilo꞉ tili dowab a꞉no꞉, nelo꞉ iliga꞉fo꞉ o꞉mo꞉wo꞉lo꞉ sagala꞉liki tili dowab. ");
INSERT INTO bco_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Kalu abeyo꞉ ‘kalu we dinali sa꞉lan kalulo꞉b’ a꞉la꞉asula꞉liki, kalu a꞉no꞉ sagala꞉liki tilidowalega, emo꞉wo꞉ wa꞉l kililiakiyo꞉, dinali sa꞉lan kalu o꞉mo꞉lo꞉ kililian auka kililia꞉ib. A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ‘we digalo꞉ kalulo꞉b’ a꞉la꞉asula꞉liki, kalu a꞉no꞉ sagala꞉liki tilidowalega, emo꞉wo꞉ wa꞉l kililiakiyo꞉, digalo꞉ kalu o꞉mo꞉lo꞉ kililian auka kililia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","A꞉la꞉fo꞉ko꞉lo꞉ kalu abeyo꞉ wilo꞉ma kalu nowo꞉ ba꞉da꞉ga꞉yo꞉, ‘e Kelisolo꞉b’ a꞉la꞉ asula꞉sa꞉ga꞉yo꞉, hido꞉ ho꞉no꞉ emo꞉ wasu mealega, kalu a꞉ma꞉ ene wa꞉l dia꞉no꞉wo꞉ mada mo꞉sulu ha꞉na꞉no꞉, hendeleyo꞉ ko꞉lo꞉ dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ya꞉su eyo꞉ to a꞉no꞉ enedo꞉ tiliwida꞉sen kalu kugula꞉fo꞉ o꞉mo꞉ wida꞉la꞉ga꞉yo꞉, hen a꞉no꞉ ta꞉ta꞉ga꞉ e aneyo꞉, Galili a꞉namilo꞉ amisa꞉n alan dosdo꞉ a꞉na sia꞉liki, Godeya꞉ mano꞉ a꞉na wida꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yo꞉no꞉ dibolo aya silikiyo꞉, Ya꞉suwa꞉lo꞉ dimidab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, eyo꞉ dabu ba꞉ba꞉no꞉ dowabikiyo꞉, enedo꞉ tiliwida꞉sen kalu i a꞉no꞉ Ya꞉sulo꞉wa hamana꞉ki iliga꞉fo꞉ ko꞉lo꞉, iyo꞉ ha꞉na꞉sa꞉ga꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, ");
INSERT INTO bco_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Niliyo꞉ kalu nowo꞉ mia꞉ib a꞉la꞉do꞉ sio꞉ a꞉no꞉ yasila꞉len ko꞉lo꞉ kalu a꞉no꞉ geya꞉le? Mo꞉ niliyo꞉ kalu nowo꞉ o꞉yasilima꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉yo꞉, o꞉gdo꞉ gililo꞉ ba꞉dab o꞉lia꞉ da꞉dab a꞉no꞉lia꞉yo꞉ Yo꞉nbo꞉wo꞉ tambo malolo꞉ mea꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Siyo꞉ ko꞉n kalu iyo꞉ o꞉li a꞉ba꞉daki, gibo꞉ ko꞉go꞉neli kalu iyo꞉ o꞉li ha꞉na꞉lab. Aintalo꞉ dowo꞉ i a꞉no꞉ imulu alitaki, ka꞉la꞉no꞉ ko꞉lo꞉ i a꞉no꞉ o꞉li da꞉da꞉lab. Sowo꞉ kaluka꞉isale nolo꞉lo꞉ a꞉ma꞉la꞉ dasi alifela꞉lab. A꞉la꞉ta꞉ga꞉ wa꞉feyo꞉ kaluka꞉isaleyo꞉ Godeya꞉ to nafalo꞉ wida꞉lab a꞉no꞉ da꞉da꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Kalu abeyo꞉ nilo꞉ dimidab we ba꞉da꞉ga꞉yo꞉, ene tilidabuwo꞉ mo꞉ta꞉fo꞉ ha꞉nalega, e ego꞉le dowab.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yo꞉na꞉lo꞉ tiliwida꞉sen kalu i a꞉no꞉ a꞉ma꞉la꞉ ha꞉na꞉ga꞉ dowabikiyo꞉, Ya꞉su eyo꞉ Yo꞉na꞉lo꞉ dimida꞉sen a꞉no꞉ kaluka꞉isale kegeo꞉ imo꞉ widaki a꞉la꞉sio꞉, “Gio꞉ kalulo꞉ma hen a꞉namio꞉ o꞉b ba꞉ba꞉ni aneyo꞉? Gio꞉ fa꞉fa꞉sa꞉lo꞉ da꞉fa꞉ ida꞉la꞉likilo꞉ madalilo꞉ foda꞉lab a꞉no꞉ ko꞉lo꞉ da꞉ba꞉ni aneyo꞉? ");
INSERT INTO bco_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O꞉ngo꞉ma ko꞉lo꞉, gio꞉ a꞉namio꞉ o꞉b ba꞉ba꞉ni aneya꞉le? Giliyo꞉ wilo꞉ kalu ko꞉lo꞉ so꞉g nafa kafo꞉labiki ba꞉ba꞉ni aneya꞉le? A! So꞉g nafalelo꞉ kagedo꞉ kalu iyo꞉ misa꞉ kaluwa꞉ aya sena ba꞉da꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","A꞉la꞉ga꞉sen ko꞉lo꞉, gio꞉ kalulo꞉ma hen a꞉namio꞉ o꞉b ba꞉ba꞉ni aneyo꞉? Gio꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu a꞉no꞉ko꞉ ba꞉ba꞉ni ane. A꞉no꞉ hendele, a꞉la꞉ta꞉ga꞉ dinali sa꞉lan kalu gilo꞉ ba꞉ba꞉ a꞉ma꞉yo꞉, dinali sa꞉lan kalu nolo꞉ e tininila꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Godeya꞉lo꞉ to sa꞉sa꞉lo꞉ a꞉namio꞉, kalu we ko꞉lo꞉ da꞉feakiyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Ge semo꞉fa꞉la꞉dowo꞉ amio꞉, niyo꞉ no꞉no꞉n tolo꞉ sa꞉ma꞉no꞉ kalu nowo꞉ tamina iliga꞉fa꞉no꞉ ko꞉lo꞉, gelo꞉ mia꞉no꞉ tog a꞉no꞉ e fadama꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Niyo꞉ hendele so꞉lo꞉l. Henfelo꞉ kaluka꞉isaleyo꞉ tambo ho꞉n amilo꞉ to꞉lolan kalu Yo꞉n e tinio꞉ ko꞉lo꞉lab. Ko꞉sega Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉namio꞉, wilo꞉ma kalu dowab a꞉ma꞉yo꞉ Yo꞉n e tinio꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Yo꞉n elo꞉ nanogdo꞉ mo꞉mo꞉da dia a꞉la꞉ta꞉ga꞉ mio꞉wo꞉, o꞉g wenamio꞉lo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉ma꞉yo꞉ alan fa꞉la꞉doma꞉ki halaido꞉ dibodabikiyo꞉, kalu mogago꞉ iliyo꞉ a꞉no꞉ mo꞉anama꞉ki ka꞉laki bubab. ");
INSERT INTO bco_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yo꞉ndo꞉ semo꞉fa꞉la꞉dowo꞉ a꞉namio꞉, Mo꞉sa꞉sa꞉ ele difa꞉ a꞉no꞉lia꞉ dinali sa꞉lan kalu i o꞉lia꞉ma꞉yo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ ko꞉lo꞉ wida꞉i mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Gio꞉ da꞉ba꞉no꞉ asulalega, to we dabuma. Tamin amilo꞉ ‘Elaiya e mia꞉ib’ a꞉la꞉do꞉ sio꞉ kalu a꞉no꞉ Yo꞉n ho꞉n amilo꞉ to꞉lolano꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kaluka꞉isale ka꞉la꞉ndo꞉ a꞉lab gio꞉, to we dinafa da꞉da꞉sa꞉ga꞉ tili asula꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","17","“Kaluka꞉isale o꞉gdo꞉ sab wema꞉ man a꞉no꞉ fanda widakiyo꞉, niyo꞉ o꞉ba da꞉fe sa꞉ma꞉no꞉wa꞉le? Iyo꞉ so꞉wagalina꞉lo꞉ amisa꞉n ami baya silikilo꞉, ini mili nolo꞉ ho꞉ido꞉wo꞉ a꞉ngab. “ ‘Niliyo꞉ ulunayo꞉ folo꞉, ko꞉sega gio꞉ sagalakiyo꞉ mo꞉ya꞉bale. Ho꞉len no amio꞉ niliyo꞉ nofolo꞉ gisalo꞉wo꞉ mo꞉lo꞉, ko꞉sega gio꞉ mo꞉ya꞉lale.’ Kaluka꞉isale henfelo꞉ wilo꞉ o꞉gdo꞉ sab we so꞉wa i o꞉leo꞉ngo꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nilo꞉ a꞉la꞉do꞉ so꞉lo꞉l a꞉no꞉ mo꞉wo꞉ we. Yo꞉no꞉ ya꞉sa꞉ga꞉yo꞉, e wain ho꞉n o꞉lia꞉ ma꞉no꞉ o꞉lia꞉yo꞉ eleyo꞉ dia꞉ta꞉ga꞉ a꞉labikiyo꞉, giliyo꞉ ‘E mama mogago꞉ dowab’ a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","A꞉la꞉ta꞉ga꞉ Kalule Dowo꞉ ne gilo꞉wa ya꞉ga꞉yo꞉, ma꞉n o꞉lia꞉ wain ho꞉n o꞉lia꞉yo꞉ na꞉lab amio꞉, giliyo꞉ ne gola ba꞉da sa꞉lakiyo꞉, ‘Kalu we ma꞉no꞉wo꞉ besagali naki a꞉la꞉ta꞉ga꞉, wain ho꞉no꞉ na꞉sa꞉ga꞉ no꞉nolab. E takis molelo꞉ dia꞉sen kalu o꞉lia꞉ mogago꞉lo꞉ dimida꞉sen kalu o꞉lia꞉yo꞉ mili dowab’ a꞉la꞉sa꞉la꞉lab. Ko꞉sega tif amio꞉ nanogo꞉ ne o꞉lia꞉ Yo꞉n o꞉lia꞉ma꞉lo꞉ dimido꞉ a꞉ma꞉ fowo꞉ hedalikiyo꞉, naino꞉ nafale asulaki dimido꞉lo꞉b a꞉la꞉walama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ya꞉su elo꞉ molo ha꞉na꞉no꞉ modo꞉lo꞉ dimido꞉ hen alan a꞉namio꞉, kaluka꞉isale iyo꞉ asulo꞉wo꞉ mo꞉nodolo꞉ ko꞉lo꞉, o꞉g ho꞉len a꞉namio꞉ Ya꞉su eyo꞉ amisa꞉n kaluka꞉isale imo꞉ sa꞉lakiyo꞉ towo꞉ halaido꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Wai, Kolasin amisa꞉n kaluka꞉isale gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. A꞉la꞉ta꞉ga꞉ Besaida amisa꞉n kaluka꞉isale gilo꞉ amio꞉lo꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. Gilo꞉ amio꞉ molo ha꞉na꞉no꞉wo꞉ modo꞉ dimido꞉. Molo ha꞉na꞉no꞉ wengo꞉wo꞉ Taya amisa꞉n o꞉lia꞉ Saido꞉n amisa꞉n a꞉na dimido꞉ kibo꞉bowo꞉, iliyo꞉ asulo꞉wo꞉ o꞉li nodomabe. A꞉la꞉ta꞉ga꞉ iyo꞉ nodolo꞉ka꞉ a꞉la꞉widakiyo꞉ nofolo꞉ so꞉g a꞉no꞉ sa꞉ga꞉la꞉sa꞉ga꞉, dufuna꞉yo꞉ mulumabe. ");
INSERT INTO bco_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ko꞉sega niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Godeya꞉ kaluka꞉isalelo꞉ mo꞉walilab ho꞉len a꞉namio꞉, Taya o꞉lia꞉ Saido꞉n kaluka꞉isaleya꞉lo꞉ hida꞉yo꞉ ba꞉ba꞉ib a꞉no꞉, gilo꞉ falasilakilo꞉ hida꞉yo꞉ dia꞉ib a꞉ma꞉ tininima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","A꞉la꞉ta꞉ga꞉ Kabaniom kaluka꞉isale gio꞉lo꞉, Gode eyo꞉ gili wiyo꞉ Hebene halomio꞉ duluba꞉iba꞉le? A꞉la꞉do꞉ mo꞉auma꞉ib. Gio꞉ mada dane ane hen a꞉na ti ha꞉na꞉ib. Mo꞉wo꞉ molo ha꞉na꞉no꞉ gilo꞉ amilo꞉ dimido꞉ aumbo꞉, Sodom hen alan a꞉na dimido꞉ kibo꞉bowo꞉, amisa꞉n a꞉no꞉ o꞉dofo꞉melebabe. ");
INSERT INTO bco_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ko꞉sega niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Godeya꞉ kaluka꞉isalelo꞉ mo꞉walilab ho꞉len a꞉namio꞉, Sodom kaluka꞉isaleya꞉lo꞉ hida꞉yo꞉ ba꞉ba꞉ib a꞉no꞉, gilo꞉ falasilakilo꞉ hida꞉yo꞉ dia꞉ib a꞉ma꞉ tininima꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","O꞉g ho꞉len a꞉namio꞉ Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Do Gode, Hebene o꞉lia꞉ henfelo꞉ we o꞉lia꞉lo꞉ biso꞉wo꞉ ge. Giyo꞉ nanog nilo꞉ dimida꞉ma꞉no꞉ man a꞉no꞉ asulo꞉lo꞉ di kaluka꞉isalemo꞉wo꞉ wo꞉no꞉le dia꞉taki, kaluka꞉isale so꞉wala꞉su o꞉ngo꞉ dowab o꞉mo꞉wo꞉ kalab amio꞉ wida꞉sen ko꞉lo꞉, niyo꞉ ge wabulu sa꞉laki dulugu so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Hendele Do gilo꞉ dimido꞉ a꞉no꞉, go꞉no꞉n ge sagalema꞉no꞉wo꞉ au dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Dowa꞉yo꞉ kelego꞉wo꞉ tambo ni dagiya difa꞉. Kaluka꞉isaleyo꞉ tambo ene So꞉wayo꞉ mo꞉asulo꞉ ko꞉sega, Iya Gode imilig eneno꞉ ene So꞉wayo꞉ asulo꞉ ko꞉lo꞉lab. A꞉la꞉ta꞉ga꞉ kaluka꞉isaleyo꞉ tambo Iyayo꞉ mo꞉asulo꞉ ko꞉sega, So꞉wa eneno꞉ a꞉la꞉ta꞉ga꞉ kaluka꞉isale So꞉waya꞉lo꞉ kalab amilo꞉ walama꞉no꞉ asulab i a꞉ma꞉yo꞉lo꞉, Iyayo꞉ asulufo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Kaluka꞉isale modaki bone alifelo꞉ sab gio꞉ a꞉la꞉ta꞉ga꞉ hida꞉yo꞉ alando꞉ ga꞉lifo꞉lab gio꞉lo꞉ nelo꞉wa mena. Niyo꞉ gimo꞉wo꞉ ha꞉fo꞉ mesa꞉no꞉wo꞉ dimia꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ne mada ha꞉fa꞉nolo dowano꞉ ne, a꞉la꞉ta꞉ga꞉ ne no꞉no꞉n a꞉ma꞉la꞉yo꞉ ha꞉ga dowa꞉sen ko꞉lo꞉, gio꞉ ni ha꞉ga dowaki, nanog nilo꞉wo꞉ gili diakiyo꞉, asulo꞉wo꞉ ne ami dia꞉sa꞉ga꞉ a꞉na dia꞉li ha꞉na꞉lubi. A꞉la꞉dimida꞉lalikiyo꞉, gili mela꞉no꞉ mama a꞉no꞉ ha꞉sa dofo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Mo꞉wo꞉ nanog nilo꞉ gemo꞉lo꞉ dimia꞉nigo꞉l a꞉no꞉ halaido꞉ma a꞉la꞉ta꞉ga꞉ kelego꞉ nilo꞉ gemo꞉lo꞉ dia꞉hamana꞉kilo꞉ dimia꞉nigo꞉l a꞉no꞉ fo꞉fo꞉ido꞉ doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","O꞉g a꞉nami, Ha꞉fo꞉lo꞉ Dowan ho꞉len no amio꞉, Ya꞉suwo꞉ wit egelo꞉ us a꞉na ha꞉nakiyo꞉, enedo꞉ tili wida꞉sen kaluwo꞉ maiyabiki, wit fo nolo꞉ ili ma꞉no꞉ a꞉la꞉ta꞉ga꞉ tudu sa꞉la꞉la꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fa꞉lisi kalu iliyo꞉, ililo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Bo꞉ba! Gilo꞉ tiliwida꞉sen kalu ililo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len wenamilo꞉ dimidab wema꞉yo꞉ ele saefa꞉ nowo꞉ ili o꞉go꞉sab.” ");
INSERT INTO bco_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Tamin amilo꞉ Da꞉ibido꞉ a꞉la꞉ta꞉ga꞉ e o꞉lia꞉lo꞉ sia꞉lowan kalu i a꞉no꞉ maiyabikilo꞉ dimido꞉ sa꞉sa꞉lo꞉wo꞉, giliyo꞉ mo꞉agela꞉seno꞉? ");
INSERT INTO bco_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Da꞉ibid e Godeya꞉ aya tiha꞉na꞉sa꞉ga꞉, ma꞉no꞉ Godeya꞉ siwa꞉l amilo꞉ dia꞉ta꞉sen a꞉no꞉, e dia꞉sa꞉ga꞉ mo꞉no꞉. A꞉la꞉ta꞉ga꞉ ma꞉no꞉ heb a꞉no꞉ egeledo꞉ sia꞉lowan kalumo꞉wo꞉lo꞉ maiya꞉ki dimi. Ko꞉sega eleya꞉ saetakiyo꞉, ma꞉n a꞉no꞉ Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen kalu ili ma꞉ib. Madali kalu nolba꞉yo꞉ na꞉so꞉bo a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","A꞉la꞉ta꞉ga꞉ to nowo꞉ we. Godeya꞉ ele difa꞉ a꞉namio꞉, towo꞉ a꞉la꞉sa꞉sa꞉lo꞉. Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen kalu iliyo꞉ Godeya꞉ malilo꞉ a bo꞉fo꞉likiyo꞉, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉nami nanogo꞉ dimidab amio꞉, iliyo꞉ eleyo꞉ o꞉go꞉sab ko꞉sega, Godeya꞉ siwa꞉l amio꞉ halayo꞉ mo꞉dimida꞉sen. A꞉la꞉bo꞉ giliyo꞉ mo꞉agela꞉seno꞉? ");
INSERT INTO bco_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Godeya꞉ ene malilo꞉ a a꞉no꞉ alandeyo꞉ o꞉m ko꞉sega, kalu o꞉gdo꞉ gilo꞉ amilo꞉ a꞉lab wema꞉yo꞉ malilo꞉ a a꞉no꞉ mada tinio꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","To we Godeya꞉ bugo꞉ amio꞉ sa꞉sa꞉lifa꞉ ko꞉lo꞉ da꞉lab, ‘Gililo꞉ boba kelego꞉ ko꞉lo꞉ nemo꞉lo꞉ so꞉kugulu meab a꞉no꞉ ne mo꞉beab. Gio꞉ nol o꞉lia꞉yo꞉ nofolakilo꞉ ha꞉fo꞉ disa꞉lab a꞉no꞉ ne mada alan asulab.’ Giliyo꞉ to wema꞉ ha꞉g a꞉no꞉ fanda asulai kibo꞉bowo꞉, giliyo꞉ halalo꞉ mo꞉dimido꞉ kaluka꞉isalemo꞉wo꞉ mo꞉diga꞉li sa꞉mabe. ");
INSERT INTO bco_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kalule Dowo꞉ ne, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉ma꞉ biso꞉wo꞉ ne ko꞉lo꞉, man dimidama꞉no꞉ a꞉no꞉ no꞉no꞉no꞉ o꞉li sa꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ya꞉suwo꞉ hen a꞉no꞉ ta꞉ta꞉ga꞉ nowa ha꞉nakiyo꞉, ili tolo꞉ wida꞉sen aya tiane. ");
INSERT INTO bco_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","A us a꞉namio꞉ dagiyo꞉ ga꞉ga꞉nuli kalu nowo꞉ a꞉na elen. Fa꞉lisi kalu iliyo꞉ Ya꞉su e hala dimidab a꞉la꞉likilo꞉ mo꞉walilima꞉no꞉ togo꞉ keda꞉len ko꞉lo꞉, iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ele difa꞉ a꞉ma꞉yo꞉, walaf kaluwo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namio꞉ falele alifa꞉no꞉wo꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namio꞉ gili sibiyo꞉ alu nowa sulufo꞉ tinalega, giliyo꞉ ta꞉lia꞉sa꞉ga꞉yo꞉ susudana꞉le? A꞉ a꞉la꞉bo꞉ dimidan. ");
INSERT INTO bco_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ko꞉sega sibi a꞉no꞉ kaluwa꞉ tinio꞉ ko꞉lo꞉ a꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ ha꞉fo꞉lo꞉ dowan ho꞉len a꞉namio꞉ man nafa dimidama꞉no꞉wo꞉ mada o꞉li.” ");
INSERT INTO bco_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","A꞉la꞉ta꞉ga꞉ eyo꞉ kalu o꞉mo꞉ sa꞉laki, “Dagiyo꞉ talagalema!” A꞉la꞉sa꞉labiki, kalu a꞉ma꞉yo꞉ a꞉la꞉dimido꞉ ko꞉lo꞉, dagi a꞉no꞉ nafa nodolo꞉ o꞉ngo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ko꞉sega Fa꞉lisi kalu iyo꞉ tolo꞉ wida꞉sen aya a꞉la꞉ta꞉ga꞉ a꞉ma꞉la꞉ ha꞉la꞉ya handalota꞉ga꞉ ha꞉nakiyo꞉, Ya꞉su sa꞉mba꞉no꞉wo꞉ wo꞉no꞉le nenela꞉sa꞉ga꞉ saefa꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ko꞉sega Ya꞉suwo꞉ ililo꞉ dimidab a꞉no꞉ bulu ba꞉da꞉sa꞉ga꞉, hen a꞉no꞉ a꞉na ta꞉fo꞉gane. Kalu modo꞉wo꞉ e kudu yabiki, eyo꞉ walaf ililo꞉wo꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ya꞉suwa꞉yo꞉ imo꞉wo꞉ hagugu sa꞉lakiyo꞉, “Niyo꞉ a꞉la꞉dimido꞉ka꞉ a꞉la꞉likiyo꞉ malola꞉so꞉bo,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu Aisaya eya a꞉la꞉ta꞉ga꞉lo꞉ to sio꞉ a꞉no꞉ ko꞉lo꞉ ilili alitaki dimido꞉. Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Kalu we, ni nanogdo꞉ dian kalu fa꞉la꞉doma꞉ki da꞉feyo꞉. Niyo꞉ e alan asula꞉sa꞉ga꞉, sagalo꞉wo꞉ emo꞉wo꞉ alan dowo꞉l. No꞉no꞉n mamayo꞉ eya dia꞉fa꞉no꞉ ko꞉lo꞉, eyo꞉ digale aloba꞉dakilo꞉ bo꞉fo꞉lowan man a꞉no꞉ henfelo꞉ kaluka꞉isale tambomo꞉wo꞉ walama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","E towo꞉ mo꞉kegema꞉ib a꞉la꞉ta꞉ga꞉ mo꞉gadi ho꞉le sa꞉ma꞉ib. Kaluka꞉isaleya꞉yo꞉ e baya ilikilo꞉ to halale sio꞉wo꞉ mo꞉da꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Da꞉fa꞉ ko꞉lo꞉ gasele dowab a꞉no꞉ eyo꞉ mo꞉gulula꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ ason ko꞉lo꞉ dalifa꞉no꞉ dowab a꞉no꞉lo꞉ eyo꞉ mo꞉dalila꞉ma꞉ib. Eyo꞉ kaluka꞉isale nolba꞉lo꞉ wa꞉la꞉ sa꞉nda꞉lab i a꞉no꞉ asuwa꞉ta꞉li ha꞉na꞉la꞉ga꞉, man digalo꞉ a꞉ma꞉yo꞉ tininima꞉ki dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Henfelo꞉ kaluka꞉isale ko꞉li ko꞉lilo꞉ we, asuwa꞉fa꞉no꞉ a꞉no꞉ ilo꞉wa fa꞉la꞉doma꞉kiyo꞉, ene wiya tili asulaki yasilima꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ho꞉len a꞉namio꞉ kalu nowo꞉ mama mogago꞉ dowaki, e sio꞉ ko꞉n a꞉la꞉ta꞉ga꞉ do꞉fo꞉f dofo꞉len. Kalu a꞉no꞉ Ya꞉sulo꞉wa tililia꞉ yabikiyo꞉, Ya꞉su eyo꞉ e falele alitaki, e towo꞉ a꞉tola꞉b, a꞉la꞉ta꞉ga꞉ sio꞉ kolaetabiki a꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaluka꞉isaleyo꞉ Ya꞉suwa꞉lo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, molo tandeaki a꞉la꞉sio꞉, “Da꞉ibid eya a꞉la꞉ta꞉ga꞉lo꞉ so꞉wa ko꞉lo꞉ nimo꞉lo꞉ iliga꞉fa꞉no꞉ dinali sio꞉ kaluwo꞉ weya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ko꞉sega Fa꞉lisi kalu iliyo꞉ Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Kalu we, mama mogago꞉wa꞉lo꞉ bo꞉fo꞉lowan misa꞉ kalu, Bia꞉sabul a꞉ma꞉ halaido꞉wa iliki, mama mogago꞉wo꞉ a꞉na o꞉luga꞉fela꞉lab,” a꞉la꞉diga꞉li sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ya꞉su eyo꞉ ililo꞉ asulab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Amisa꞉n imilig no amio꞉ kaluwo꞉ aloba꞉da꞉sa꞉ga꞉ egele bubalega, amisa꞉n a꞉no꞉ mada mogaila꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ so꞉lo꞉ imilig nowo꞉ egelebo꞉ aloba꞉da꞉sa꞉ga꞉ gis dialega, so꞉lo꞉ a꞉no꞉ mo꞉dinafa mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sa꞉da꞉na꞉ya꞉ so꞉lo꞉ noma꞉yo꞉ Sa꞉da꞉na꞉ya꞉ ene so꞉lo꞉ nowo꞉ o꞉lusa꞉ndalega, e inina꞉ma꞉la꞉ usa aloba꞉dab ko꞉lo꞉, iyo꞉ waga dinafa mesa꞉iba? ");
INSERT INTO bco_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Niyo꞉ mama mogago꞉wo꞉ o꞉lusa꞉ndab amio꞉, giliyo꞉ towo꞉ nemo꞉ diga꞉li sa꞉laki, ‘ne Bia꞉sabul a꞉ma꞉ halaido꞉wa iliki dimidab’ a꞉la꞉sio꞉. Ko꞉sega gilo꞉ wida꞉sen kalu iliyo꞉ mama mogago꞉wo꞉ o꞉lusa꞉nda꞉sen ko꞉lo꞉, a꞉la꞉dimidalikiyo꞉ giliyo꞉ to o꞉leo꞉ngo꞉wo꞉ imo꞉wo꞉lo꞉ diga꞉li sa꞉ma꞉no꞉wa꞉le? A꞉la꞉bo꞉ mo꞉sa꞉ma꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ gililo꞉ tili wida꞉sen kaluwa꞉lo꞉ dimidab a꞉ma꞉yo꞉, gililo꞉ to sa꞉lab a꞉no꞉ hendelemaka꞉ a꞉labo꞉ kalaba widakigab. ");
INSERT INTO bco_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ko꞉sega niyo꞉ Godeya꞉ Mamaya꞉ halaido꞉wa iliki, mama mogago꞉wo꞉ a꞉na o꞉lusa꞉nda꞉sen ko꞉lo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ ya꞉sa꞉ga꞉ gi amio꞉ dowab a꞉la꞉liki widakigab. ");
INSERT INTO bco_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Bale sio꞉ to nowo꞉ we. Afalo꞉ dian kalu noma꞉yo꞉ halaido꞉ kalu a꞉ma꞉ aya tina꞉sa꞉ga꞉ kelego꞉wo꞉ afale dia꞉no꞉ asulakiyo꞉, eyo꞉ waga dimidama꞉iba? Eyo꞉ halaido꞉ kalu a꞉no꞉ ko꞉le melea꞉takiyo꞉, kelego꞉wo꞉ a꞉namio꞉ o꞉li dia꞉ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Kaluka꞉isale abeyo꞉ ne o꞉lia꞉yo꞉ mo꞉ege dowab a꞉no꞉, ne o꞉lia꞉yo꞉ gis dowakigab. Kalu abeyo꞉ kaluka꞉isale nolo꞉ ne o꞉lia꞉lo꞉ mo꞉kegene alita꞉lab a꞉ma꞉yo꞉, kaluka꞉isale a꞉no꞉ ko꞉lo꞉ o꞉luga꞉felakigab. ");
INSERT INTO bco_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Kaluka꞉isaleya꞉lo꞉ man mogago꞉ dimida꞉sen o꞉lia꞉ Godemo꞉lo꞉ dio꞉ge sa꞉lan o꞉lia꞉, Gode eyo꞉ tambo o꞉li hala꞉sa꞉ga꞉ ga꞉lila꞉ma꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ Godeya꞉ Mamamo꞉wo꞉ dio꞉ge sa꞉lalega, Gode eyo꞉ kalu elo꞉ hala dimidab a꞉no꞉ mo꞉ga꞉lila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Kaluka꞉isale abeyo꞉ Kalule Dowo꞉ o꞉mo꞉wo꞉ mogagi sa꞉lalega, kalu elo꞉ hala dimidab a꞉no꞉ Gode eyo꞉ o꞉li hala꞉sa꞉ga꞉ ga꞉lila꞉ma꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ Godeya꞉ Mamamo꞉wo꞉ mogagi sa꞉lalega, Gode eyo꞉ kalu elo꞉ hala dimidab a꞉no꞉ o꞉gdo꞉wo꞉lo꞉, tif amio꞉lo꞉ mada mo꞉ga꞉lila꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“I ko꞉lo꞉ ele ba꞉ba꞉no꞉wo꞉, fowa꞉ sa꞉ma꞉ib. I nafa a꞉ma꞉yo꞉ fowo꞉ nafale helema꞉ib. A꞉la꞉ta꞉ga꞉ i mogago꞉ a꞉ma꞉yo꞉ fowo꞉ mogago꞉ helema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kalu gio꞉ kisa꞉wa꞉la꞉ inso꞉ o꞉ngo꞉ dowab. Asulo꞉ usamilo꞉ da꞉lab a꞉no꞉ mego꞉f amio꞉ kalaba sahandalowa꞉lab. Gili asulo꞉wo꞉ mogago꞉le da꞉lab ko꞉lo꞉, giliyo꞉ to nafayo꞉ mo꞉sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Kalu nafa eyo꞉, asulo꞉ nafa e amilo꞉ dila꞉len a꞉no꞉ kalaba sahandalowakiyo꞉, man nafale a꞉no꞉ ko꞉lo꞉ dimida꞉mela꞉ib. Kalu mogago꞉ eyo꞉, asulo꞉ mogago꞉ e amilo꞉ dila꞉len a꞉no꞉ kalaba sahandalowakiyo꞉, man mogago꞉ a꞉no꞉ ko꞉lo꞉ dimida꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ko꞉sega niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Godeya꞉lo꞉ mo꞉walilima꞉no꞉ ho꞉len a꞉namio꞉, kaluka꞉isale tambowa꞉yo꞉ ililo꞉ madali to ko꞉li ko꞉lilo꞉ sa꞉la꞉len a꞉no꞉ tambo Godeya꞉ siwa꞉l amio꞉ kalaba sa handalowaki sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Gode eyo꞉ go꞉no꞉ndo꞉ to sa꞉la꞉len a꞉na ilikiyo꞉, ge digalo꞉ kalu a꞉la꞉sa꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ go꞉no꞉ndo꞉ to sa꞉la꞉len a꞉na ilikiyo꞉, ge mogago꞉ kalu a꞉la꞉sa꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ho꞉len no amio꞉ Fa꞉lisi kalu nol o꞉lia꞉ elelo꞉ wida꞉sen kalu nol o꞉lia꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, niliyo꞉ ge Godelo꞉wa a꞉la꞉ta꞉ga꞉ mio꞉lo꞉b a꞉la꞉asuluma꞉kiyo꞉, giyo꞉ nimo꞉wo꞉ molo ha꞉na꞉no꞉ nowo꞉ walama,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale o꞉g ho꞉len wenamilo꞉ sab we, gio꞉ hendele mogago꞉le ko꞉lo꞉, gio꞉ Gode o꞉lia꞉yo꞉ mo꞉ege dowab. Gio꞉ ele ba꞉ba꞉no꞉wo꞉ Godelo꞉wa a꞉la꞉ta꞉ga꞉lo꞉ fa꞉la꞉dowab a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉no꞉ asulab. Ko꞉sega gio꞉ ele ba꞉ba꞉no꞉ nowo꞉ mo꞉ba꞉ba꞉ib. Dinali sa꞉lan kalu Yona elo꞉ amilo꞉ fa꞉la꞉dowo꞉ a꞉no꞉ko꞉ ba꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Yona e ho꞉len otaleno꞉ a꞉la꞉ta꞉ga꞉ nulu otaleno꞉ ka꞉ ila꞉muwa delen. A꞉la꞉do꞉ fa꞉la꞉dowo꞉ o꞉leaumbo꞉ Kalule Dowo꞉ e ho꞉leno꞉ otalen a꞉la꞉ta꞉ga꞉ nulu otalen a꞉no꞉ hena꞉ usde holona doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Godeya꞉lo꞉ henfelo꞉ kaluka꞉isalelo꞉ mo꞉walilima꞉no꞉ ho꞉len a꞉namio꞉, Ninifa kalu iyo꞉ gi o꞉lia꞉ kagafo꞉liki, gililo꞉ hala dimido꞉ a꞉no꞉ iliyo꞉ kalaba fanda sa꞉ma꞉ib. Mo꞉wo꞉ Yona eyo꞉ kaluka꞉isalemo꞉wo꞉ wida꞉labikiyo꞉, iyo꞉ asulo꞉wo꞉ nodolo꞉. O꞉go꞉ gio꞉ bo꞉ba! Yona elo꞉ tinio꞉ kalu nowo꞉ o꞉go꞉ wena sab. ");
INSERT INTO bco_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Godeya꞉lo꞉ henfelo꞉ kaluka꞉isalelo꞉ mo꞉walilima꞉no꞉ ho꞉len a꞉namio꞉, Seba hen amilo꞉ misa꞉ ka꞉isale e, gi o꞉lia꞉ kagafo꞉liki, gililo꞉ hala dimido꞉ a꞉no꞉ eyo꞉lo꞉ kalaba fanda sa꞉ma꞉ib. Mo꞉wo꞉ mo꞉luwo꞉ e Solomona꞉ ene asulo꞉ nafale a꞉no꞉ da꞉ba꞉no꞉ yakiyo꞉, heno꞉ ko꞉na꞉ a꞉la꞉ta꞉ga꞉ mio꞉. O꞉g wenamio꞉ gio꞉ bo꞉ba! Solomona꞉ asulo꞉lo꞉ tinio꞉ kalu nowo꞉ o꞉go꞉ wena sab.” ");
INSERT INTO bco_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","“Mama mogago꞉wo꞉ kalu amilo꞉ elen a꞉no꞉ handalota꞉ga꞉ ha꞉nakiyo꞉, mama mogago꞉ a꞉no꞉ elo꞉ ha꞉salo꞉ mesa꞉no꞉ hen a꞉no꞉ kedaki, kalaleli hena sia꞉mela꞉ib. Ko꞉sega elo꞉ mesa꞉no꞉ hen nafa nowo꞉ mo꞉ba꞉dalikiyo꞉, eyo꞉ a꞉la꞉sa꞉ma꞉ib, ‘A nelo꞉ tamin amilo꞉ sen a꞉na a꞉ma꞉la꞉ ha꞉na꞉nigo꞉l.’ A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, e a꞉ma꞉la꞉ ya꞉ga꞉ ba꞉ba꞉ amio꞉, a a꞉no꞉ tabe alitaki, momade alifa꞉ ko꞉sega kalulo꞉ma ba꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","A꞉la꞉fo꞉ko꞉lo꞉ ayo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, e ha꞉na꞉sa꞉ga꞉, mama mogago꞉ doma꞉la꞉fo꞉ nolo꞉ a꞉tililia꞉ mia꞉ib. Mama mogago꞉ doma꞉la꞉fo꞉ a꞉ma꞉ ini man dimidano꞉ mada mogago꞉le ko꞉lo꞉lab. A꞉la꞉ta꞉ga꞉ iyo꞉ tambo a a꞉na mesa꞉ni tina꞉ib. Tamin amio꞉ kalu a꞉no꞉ hida꞉yo꞉wo꞉ dowo꞉ ko꞉sega, o꞉g a꞉namio꞉ hida꞉yo꞉wo꞉ mada alande a꞉fa꞉la꞉dowab. Man elo꞉ amilo꞉ fa꞉la꞉dowab o꞉leaumbo꞉, kaluka꞉isale mogago꞉ o꞉gdo꞉ sab wenamio꞉lo꞉ a꞉la꞉ka fa꞉la꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ya꞉su eyo꞉ kalu kegeo꞉ o꞉mo꞉wo꞉ towo꞉ o꞉wida꞉labikiyo꞉, Ya꞉suwa꞉ ano o꞉lia꞉ ao i o꞉lia꞉ a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, Ya꞉sumo꞉ towo꞉ sa꞉ma꞉no꞉ a꞉la꞉ta꞉ga꞉ ha꞉la꞉ya kagafo꞉len. ");
INSERT INTO bco_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kalu noma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉ o꞉lia꞉ gao o꞉lia꞉yo꞉ ha꞉la꞉ya kagafo꞉liki, towo꞉ gemo꞉ sa꞉ma꞉no꞉ a꞉la꞉ta꞉ga꞉ yasisab.” ");
INSERT INTO bco_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ emo꞉lo꞉ sio꞉ kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ni no꞉ o꞉lia꞉ ni nao o꞉lia꞉yo꞉ o꞉ba?” ");
INSERT INTO bco_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ya꞉su eyo꞉ enedo꞉ tiliwida꞉sen kalu i a꞉no꞉ ko꞉lo꞉ dagi kudu sa꞉laki, “Ni no꞉ o꞉lia꞉ nao i o꞉lia꞉yo꞉ kaluka꞉isale i sab we. ");
INSERT INTO bco_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Kaluka꞉isale abeyo꞉ Do Hebenelo꞉ sab ene mando꞉ tilida꞉da꞉sa꞉ga꞉lo꞉ kudu ha꞉na꞉lab a꞉no꞉, naoleyo꞉, nadoleyo꞉, no꞉leyo꞉ i o꞉m.” ");
INSERT INTO bco_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ho꞉len imilig a꞉namio꞉ Ya꞉suwo꞉ ha꞉la꞉ya handalota꞉ga꞉, ho꞉n golo꞉ aniba mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ elo꞉wa kegea꞉sa꞉ga꞉ dowabiki, e ho꞉n ko꞉su usa disa꞉la꞉sa꞉ga꞉ asitabikiyo꞉, kaluka꞉isaleyo꞉ sa꞉ wa꞉la kagayo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ya꞉su eyo꞉ imo꞉wo꞉ towo꞉ modo꞉ ko꞉lo꞉ bale malola꞉i ane. To nowo꞉ eyo꞉ imo꞉ a꞉la꞉sio꞉, “Elo꞉ gelan kaluwa꞉yo꞉ fowo꞉ egelo꞉wa fifa꞉li ane. ");
INSERT INTO bco_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E fowo꞉ fifa꞉li ha꞉nab amio꞉, fo nolo꞉ tog wa꞉la꞉la꞉sena tiali ko꞉lo꞉, o꞉ba꞉yo꞉ ya꞉sia꞉sa꞉ga꞉ tambo mo꞉no꞉ ");
INSERT INTO bco_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Fo nolo꞉ ulo꞉ elena ti ali. Hen a꞉no꞉ abeyo꞉ ko꞉lo꞉ musug a꞉no꞉ bo꞉bo꞉ge fa꞉la꞉ne ko꞉sega, musug a꞉ma꞉ tef tina꞉no꞉wo꞉ uwa midiaki, ofo꞉ ta꞉ndabikiyo꞉, da꞉si musug a꞉no꞉ onaliaki sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Fo nolo꞉ do꞉molo꞉ a꞉laba ti ali. Musug a꞉no꞉ fa꞉la꞉ne ko꞉sega, do꞉mo fo a꞉no꞉ bo꞉bo꞉ge fa꞉la꞉ndaki, musug a꞉no꞉ mele fafululiabiki olali. ");
INSERT INTO bco_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Fo nolo꞉ hen solo꞉ nafaya ti ali ko꞉lo꞉, musugo꞉ nafa fa꞉la꞉nda꞉sa꞉ga꞉, fowo꞉ nafale hedo꞉. Fo hedakiyo꞉, nolo꞉ fudo꞉ otalen hedo꞉, nolo꞉ fudo꞉ a꞉la꞉ hedo꞉, a꞉la꞉ta꞉ga꞉ nolo꞉ fudo꞉ imilig hedo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kaluka꞉isale ka꞉la꞉ndo꞉ a꞉lab gio꞉, to we dinafa da꞉da꞉sa꞉ga꞉ fanda asula꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Tiliwida꞉sen kaluwo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giyo꞉ kaluka꞉isalemo꞉wo꞉ to widakiyo꞉, bale sa꞉lakilo꞉ to widako mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉ma꞉ to wo꞉no꞉le delen a꞉no꞉, o꞉go꞉ gio꞉ o꞉li fanda asuluma꞉ki ta꞉tab. Ko꞉sega Gode eyo꞉ asulo꞉ a꞉no꞉ kaluka꞉isale nolba꞉yo꞉ fanda asuluma꞉kiyo꞉, mo꞉ta꞉tab. ");
INSERT INTO bco_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kalu abeyo꞉ asulo꞉wo꞉ hebo꞉ dowalega, Gode eyo꞉ emo꞉wo꞉ asulo꞉ nolo꞉ a꞉dimia꞉ib ko꞉lo꞉, e asulo꞉wo꞉ alande doma꞉ib. Ko꞉sega kalu abeyo꞉ asugdo꞉ma dowab a꞉no꞉, asulo꞉ ha꞉lu e amilo꞉ delen a꞉no꞉, tambo a꞉ma꞉la꞉ dila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nilo꞉ to widakilo꞉ bale sa꞉la꞉seno꞉ mo꞉wo꞉ we. Si inido꞉ma꞉yo꞉ ba꞉da꞉lab ko꞉sega, hendeleyo꞉ mo꞉ba꞉dab. Iliyo꞉ to sio꞉wo꞉ da꞉da꞉lab ko꞉sega, iliyo꞉ hendeleyo꞉ mo꞉tilida꞉daki, ha꞉go꞉ mo꞉fanda asulab. ");
INSERT INTO bco_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kaluka꞉isale o꞉gdo꞉ sab wema꞉yo꞉, dinali sa꞉lan kalu Aisaya elo꞉ to sio꞉wo꞉ ilili alitab. Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Gio꞉ ni towo꞉ mada da꞉da꞉mela꞉ib ko꞉sega, hendeleyo꞉ mada mo꞉fanda asuluma꞉ib. Gio꞉ nilo꞉ dimidabo꞉ ba꞉da꞉mela꞉ib ko꞉sega, ha꞉go꞉ mada mo꞉dinafa asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Mo꞉wo꞉ kaluka꞉isale i a꞉ma꞉ asulo꞉wo꞉ halaido꞉ dowaki, ka꞉la꞉no꞉ kagedeliaki, a꞉la꞉ta꞉ga꞉ iliyo꞉ ini siyo꞉ suguli. A꞉la꞉bo꞉ mo꞉ngai kibabeyo꞉, ili siyo꞉ kolaetaliki o꞉li ba꞉babe, ka꞉la꞉no꞉ togo alitaliki o꞉li da꞉babe, a꞉la꞉ta꞉ga꞉ asulo꞉wo꞉ kolaetaliki o꞉li asulumabe. Iyo꞉ nelo꞉ doba꞉da꞉ nodolalikiyo꞉, niyo꞉ iyo꞉ falele alifo꞉lo.’ Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ko꞉sega si ginido꞉ma꞉yo꞉ fanda ba꞉dab a꞉la꞉ta꞉ga꞉, ka꞉la꞉n ginido꞉ma꞉yo꞉ digale da꞉dab ko꞉lo꞉ gio꞉ ego꞉le sab. ");
INSERT INTO bco_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Niyo꞉ gimo꞉wo꞉ to we hendele so꞉lo꞉l. Mo꞉luwo꞉ Godeya꞉ dinali sa꞉lan kalu o꞉lia꞉ ene digalo꞉ kalu modo꞉ o꞉lia꞉ma꞉yo꞉, gililo꞉ o꞉go꞉do꞉ ba꞉dab we, iliyo꞉lo꞉ bo꞉bo꞉losa꞉ a꞉la꞉li yasila꞉len ko꞉sega mo꞉ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ gililo꞉ o꞉gdo꞉ da꞉dab we iliyo꞉lo꞉ mada da꞉ba꞉no꞉ a꞉la꞉li yasila꞉len ko꞉sega mo꞉dabu.” ");
INSERT INTO bco_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Da꞉si fo amilo꞉ bale sio꞉ a꞉ma꞉ ha꞉go꞉ we ko꞉lo꞉ dinafa dabuma. ");
INSERT INTO bco_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Kaluka꞉isale abeyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ to nafayo꞉ da꞉da꞉sa꞉ga꞉lo꞉ mo꞉fanda asululiab a꞉no꞉, mogago꞉lelo꞉ dimida꞉sen Sa꞉da꞉na꞉ eyo꞉ ya꞉sa꞉ga꞉, ili asulo꞉ usamilo꞉ gelab a꞉no꞉ bo꞉bo꞉ge dila꞉lab. Kaluka꞉isale a꞉no꞉ fo ko꞉lo꞉ tog wa꞉la꞉la꞉sen amilo꞉ ti ali a꞉la꞉do꞉ sa꞉labo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Fo ko꞉lo꞉ ulo꞉ elena ti ali a꞉la꞉do꞉ sa꞉lab a꞉ma꞉ ha꞉go꞉ we. Kaluka꞉isaleyo꞉ Godeya꞉ to nafa a꞉no꞉ iligi da꞉da꞉sa꞉ga꞉, sagala꞉li diab. ");
INSERT INTO bco_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ko꞉sega ili asulo꞉ us amio꞉ towo꞉ mo꞉tefele ane ko꞉lo꞉, ili tilidabuwo꞉ ho꞉len abolda꞉su doma꞉ib. Ini tilidabuwo꞉ da꞉feab amio꞉ a꞉la꞉ta꞉ga꞉ hida꞉yo꞉ fa꞉la꞉dowab amio꞉lo꞉, iyo꞉ bo꞉bo꞉ge sulufo꞉ tindab. ");
INSERT INTO bco_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Fo ko꞉lo꞉ do꞉mo fo alaba ti ali a꞉la꞉do꞉ sa꞉labo꞉ we. Kaluka꞉isale a꞉no꞉ Godeya꞉ to nafa a꞉no꞉ dabu ko꞉sega, henfelo꞉ wilo꞉ dimidama꞉no꞉ kele asulo꞉wo꞉ i amio꞉ dowa꞉lab a꞉la꞉ta꞉ga꞉ mole alan dia꞉no꞉ asulo꞉wa꞉yo꞉ iyo꞉ dikidaki susuda꞉lab ko꞉lo꞉, man a꞉la꞉ a꞉ma꞉yo꞉ Godeya꞉ towo꞉ go꞉lulaki, iyo꞉ mo꞉halale dowo꞉ ko꞉lo꞉ fowo꞉ mo꞉hedab. ");
INSERT INTO bco_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko꞉sega fo ko꞉lo꞉ hen solo꞉ nafaya ti ali a꞉la꞉do꞉ sa꞉labo꞉ we. Kaluka꞉isale i a꞉no꞉ Godeya꞉ to nafa a꞉no꞉ dinafa da꞉da꞉sa꞉ga꞉ fanda asululiab. I amio꞉ fowo꞉ nafa modo꞉ hedakiyo꞉, nolo꞉ fudo꞉ otalen, nolo꞉ fudo꞉ a꞉la꞉, a꞉la꞉ta꞉ga꞉ nolo꞉ fudo꞉ imilig a꞉la꞉hedo꞉.” ");
INSERT INTO bco_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ya꞉su eyo꞉ bale sio꞉ nowo꞉ imo꞉wo꞉ a꞉la꞉malolo꞉ me. “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉, we o꞉ngo꞉ dowab ko꞉lo꞉ so꞉lo꞉l. Kalu noma꞉yo꞉ wit fo nafayo꞉ ene egelo꞉wa fifa꞉li ane. ");
INSERT INTO bco_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ko꞉sega e o꞉lia꞉ ene nanogdo꞉ dian kalu iyo꞉lo꞉ tambo nuluwo꞉ fufulufo꞉labikiyo꞉, gis kalu nowo꞉ ya꞉sa꞉ga꞉yo꞉, egelo꞉ imilig a꞉naka fugus mogago꞉wa꞉ fowo꞉ fifa꞉la꞉ga꞉ ta꞉fo꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit fo nafa a꞉no꞉ musugo꞉ fa꞉la꞉nda꞉sa꞉ga꞉yo꞉ fowo꞉ hedabikiyo꞉, fugus mogago꞉wo꞉lo꞉ a꞉naka fa꞉la꞉neya ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nanog dian kalu iyo꞉ egelo꞉lo꞉ biso꞉lo꞉wa ya꞉sa꞉ga꞉, a꞉la꞉dabu ba꞉ba꞉, ‘Kalu alan, gi egelo꞉ amio꞉ fo nafale gelo꞉ ko꞉lo꞉, fugus mogago꞉ o꞉lia꞉ a꞉fa꞉la꞉ndab we, waga fa꞉la꞉dowo꞉wa꞉le?’ ");
INSERT INTO bco_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Egelo꞉lo꞉ biso꞉ eyo꞉ a꞉la꞉sio꞉, ‘Gis kalu noma꞉ dimido꞉lo꞉ka꞉.’ A꞉la꞉sa꞉labiki, ene nanog kalu iliyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, ‘Nio꞉ ha꞉na꞉sa꞉ga꞉ fugus mogago꞉ a꞉no꞉ dogasela꞉ma꞉ki asulaya?’ ");
INSERT INTO bco_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Egelo꞉lo꞉ biso꞉ eyo꞉ a꞉la꞉sio꞉, ‘Giliyo꞉ a꞉la꞉bo꞉ dimida꞉so꞉bo. Wit nafa a꞉ma꞉ tef o꞉lia꞉yo꞉ ida꞉niase dugulabena꞉kiyo꞉, fugus mogago꞉ a꞉no꞉ o꞉go꞉ dogasela꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","O꞉go꞉ egeleka o꞉fa꞉la꞉nda꞉melea꞉ki ta꞉ta꞉bi. Hendelo꞉ tuma꞉no꞉ ho꞉len a꞉namio꞉, niyo꞉ nanog dian kalumo꞉wo꞉ a꞉la꞉sa꞉ma꞉no꞉, “Tamin amio꞉ fugus mogago꞉wo꞉ gegedela꞉sa꞉ga꞉, kegene bobodola꞉sa꞉ga꞉yo꞉, deya gilima꞉no꞉ dia꞉ta꞉bi. A꞉la꞉ta꞉ga꞉yo꞉ wit hende nafale a꞉no꞉ kegene bobodola꞉sa꞉ga꞉, no꞉no꞉n ma꞉no꞉lo꞉ dila꞉sen aya dia꞉ta꞉bi.” ’ ” ");
INSERT INTO bco_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ya꞉su eyo꞉ bale sio꞉ nowo꞉ imo꞉wo꞉ a꞉la꞉malolakiyo꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ mased fo fifo꞉ amilo꞉ fa꞉la꞉ndab o꞉ngo꞉ dowab. Kaluwa꞉yo꞉ fo a꞉no꞉ egelo꞉wa fifo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fo a꞉no꞉ ha꞉lula꞉su dowo꞉ ko꞉lo꞉, fo tambo nol a꞉ma꞉yo꞉ e tiginila꞉. Ko꞉sega e fa꞉la꞉ndakiyo꞉, alan dowaki egelo꞉ amilo꞉ fa꞉la꞉ne a꞉no꞉ e tiginila꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ eleyo꞉ alan tagalega꞉felab amio꞉, o꞉ba꞉yo꞉ ya꞉ga꞉ ayo꞉ a꞉na dia꞉sa꞉ga꞉ alila꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ya꞉su eyo꞉ bale sio꞉ nowo꞉ imo꞉wo꞉ a꞉la꞉malolo꞉ me. “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ falawalo꞉ anayan kelego꞉ yis o꞉ngo꞉ dowo꞉. Ga noma꞉yo꞉ yis ha꞉lu a꞉no꞉ falawa wo꞉fa꞉ otalen a꞉no꞉lia꞉ wo꞉gele alitalikiyo꞉, yiso꞉ mo꞉ba꞉ba꞉ib ko꞉sega falawa a꞉no꞉ tambo anama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ya꞉su eyo꞉ kaluka꞉isalemo꞉wo꞉ man widakiyo꞉, eyo꞉ mo꞉tigini widaki, tambowo꞉ bale sio꞉wa꞉ wida꞉li ane. ");
INSERT INTO bco_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Elo꞉ a꞉la꞉do꞉ dimido꞉ a꞉ma꞉yo꞉, Godeya꞉ tolo꞉ dinali sa꞉lan kalu eya a꞉la꞉ta꞉ga꞉lo꞉ to sio꞉ a꞉no꞉ ko꞉lo꞉ ilili alifa꞉. To a꞉no꞉ a꞉la꞉sa꞉sa꞉lo꞉, “Niyo꞉ gimo꞉wo꞉ bale sa꞉laki walama꞉no꞉. Henfelo꞉ welo꞉ mo꞉mo꞉da dimido꞉wa a꞉la꞉ta꞉ga꞉lo꞉ mio꞉ amio꞉, wo꞉no꞉le asulo꞉ amilo꞉ delen a꞉no꞉ o꞉go꞉ gimo꞉wo꞉ kalaba sa꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ya꞉suwo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ ta꞉ta꞉ga꞉, aya ane. Enedo꞉ tiliwida꞉sen kaluwo꞉ ya꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Fugus mogago꞉ amilo꞉ bale sio꞉ a꞉ma꞉ ha꞉go꞉ nimo꞉wo꞉ fanda sa꞉ma꞉no꞉wo꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Fo nafalo꞉ gelo꞉ kalu a꞉no꞉, Kalule Dowo꞉ ne. ");
INSERT INTO bco_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Egelo꞉ a꞉no꞉ henfelo꞉wo꞉ o꞉m. A꞉la꞉ta꞉ga꞉ fo nafa ko꞉lo꞉ fa꞉la꞉ne a꞉no꞉, Godeya꞉ enedo꞉ bo꞉fo꞉lab kaluka꞉isaleyo꞉ o꞉m. Fugus mogago꞉ a꞉no꞉, mogago꞉lelo꞉ dimida꞉sen Sa꞉da꞉na꞉ya꞉ ene kaluka꞉isaleyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Fo mogago꞉lo꞉ gema꞉nikilo꞉ gis kalu mio꞉ a꞉no꞉, Sa꞉da꞉na꞉yo꞉ o꞉m. Hendelo꞉ tuma꞉no꞉ ho꞉len a꞉no꞉, henfelo꞉ welo꞉ elema꞉no꞉ ho꞉leno꞉ o꞉m. A꞉la꞉ta꞉ga꞉ folo꞉ tulan nanog dian kaluka꞉isale a꞉no꞉, ma꞉mula꞉ kaluwo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ta꞉i mio꞉ ho꞉leno꞉ eletalikiyo꞉, fugus mogago꞉ ko꞉lo꞉ dogasela꞉sa꞉ga꞉lo꞉ de amilo꞉ gido꞉ auma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kalule Dowo꞉ a꞉ma꞉yo꞉ ene ma꞉mula꞉ kaluwo꞉ iliga꞉fa꞉ib ko꞉lo꞉, iliyo꞉ mogago꞉lo꞉ dimidama꞉kilo꞉ sendea꞉lab kaluka꞉isale o꞉lia꞉ mogago꞉lo꞉ dimida꞉lab kaluka꞉isale a꞉no꞉lia꞉yo꞉, Godeya꞉ bo꞉fo꞉mela꞉no꞉ man amio꞉ mo꞉melea꞉ki dila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ma꞉mula꞉ kalu iliyo꞉ kaluka꞉isale i a꞉no꞉ de wa꞉sowa alando꞉ a꞉lab a꞉na sandifa꞉ib. Hen a꞉namio꞉ kaluka꞉isaleyo꞉ kulufa꞉yakiyo꞉, ya꞉foda꞉li mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","A꞉la꞉ta꞉ga꞉ digalo꞉ kaluka꞉isaleyo꞉, Iyaya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hena silikiyo꞉, iyo꞉ ofa꞉lo꞉ bumalo꞉ o꞉ngo꞉ so꞉so꞉lelia꞉ga꞉ dofo꞉mela꞉ib. Kaluka꞉isale ka꞉la꞉ndo꞉ a꞉lab gio꞉, to we dinafa da꞉da꞉sa꞉ga꞉ fanda asula꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ we o꞉ngo꞉ dowab. Kalu noma꞉yo꞉ mole alan ko꞉lo꞉ hen amilo꞉ wo꞉no꞉lelo꞉ delen a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, mole a꞉no꞉ hena꞉ a꞉go꞉lu alifa꞉. E sagalo꞉wo꞉ alan dowaki, kelego꞉ enedo꞉ delen a꞉no꞉ nolbo꞉ kililia꞉sa꞉ga꞉yo꞉, mole di a꞉ma꞉yo꞉ hen a꞉no꞉ a꞉na a꞉kilili. ");
INSERT INTO bco_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“A꞉la꞉ta꞉ga꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ we o꞉ngo꞉ dowab. Kelego꞉lo꞉ kililia꞉sen kalu noma꞉yo꞉ gaba nafayo꞉ keda꞉liki sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eyo꞉ gaba mada nafale imilig nowo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, kelego꞉ enedo꞉ delen a꞉no꞉ tambo kalu nolbo꞉ kililia꞉sa꞉ga꞉, mole ko꞉lo꞉ di a꞉ma꞉yo꞉ gaba a꞉no꞉ kililia꞉ni ane.” ");
INSERT INTO bco_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉, dage ko꞉lo꞉ ho꞉n golo꞉wa to꞉lolab amilo꞉ ka꞉ ko꞉li ko꞉lilo꞉ a꞉namilo꞉ walalano꞉ o꞉ngo꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ka꞉ ko꞉li ko꞉lilo꞉wo꞉ dage a꞉na walala꞉li ha꞉na꞉la꞉ga꞉ ililitab amio꞉, kalu iliyo꞉ dage a꞉no꞉ tililia꞉ ya꞉ga꞉, sa꞉wa꞉la difa꞉. Iyo꞉ a꞉na asita꞉ga꞉yo꞉, ka꞉yo꞉ ili aloba꞉dakiyo꞉, ka꞉ nafale a꞉no꞉ asa disa꞉laki, a꞉la꞉ta꞉ga꞉ ka꞉ mogago꞉wo꞉ sandifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ta꞉i mio꞉ ho꞉len we edalikiyo꞉, a꞉la꞉dimidama꞉ib. Ma꞉mula꞉ kaluwo꞉ ya꞉sa꞉ga꞉yo꞉, mogago꞉ kalu o꞉lia꞉ digalo꞉ kalu o꞉lia꞉yo꞉ aloba꞉da꞉sa꞉ga꞉, mogago꞉ kaluka꞉isale a꞉no꞉ de wa꞉sowa alando꞉ a꞉lab a꞉na sandifa꞉ib ko꞉lo꞉, hen a꞉namio꞉ iyo꞉ kulufa꞉yakiyo꞉, ya꞉foda꞉li mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“Gio꞉ to so꞉lo꞉l we tambo dinafayo꞉ fanda asulaya?” Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉dabiki, iliyo꞉, “A꞉ nio꞉ tambo asulab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","A꞉la꞉ta꞉ga꞉ eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “A꞉la꞉go꞉ko꞉lo꞉ elelo꞉ wida꞉sen kalu o꞉ba꞉le, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ mando꞉ asululi kalu i a꞉no꞉, alo꞉ biso꞉wo꞉ o꞉ngo꞉ dowab. Alo꞉ biso꞉ a꞉ma꞉yo꞉, ene ayamilo꞉ kelego꞉ ko꞉li ko꞉lilo꞉ tamin amilo꞉ difa꞉ a꞉no꞉, mo꞉luwo꞉ kelego꞉wo꞉lo꞉, ho꞉gi kelego꞉wo꞉lo꞉ kalaba dia꞉ handalowaki walama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Ya꞉su eyo꞉ to a꞉no꞉ wida꞉sa꞉ga꞉yo꞉, e hen a꞉no꞉ ta꞉ta꞉ga꞉, elo꞉ anayo꞉ hen, Nasala꞉t amisa꞉n a꞉na ane. E hen a꞉na fa꞉la꞉dowakiyo꞉, ili tolo꞉ wida꞉sen a a꞉na widabikiyo꞉, kaluka꞉isale iliyo꞉ e towo꞉ da꞉da꞉sa꞉ga꞉, molo asulaki, a꞉la꞉nenelo꞉. “Kalu we asulo꞉ nafa o꞉lia꞉ molo ha꞉na꞉no꞉ dimidama꞉no꞉ halaido꞉ we o꞉ba diya꞉le? ");
INSERT INTO bco_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","E alo꞉ dian kaluwa꞉ so꞉wa, a꞉no꞉ hendeleya꞉le? Ene anowo꞉ Malia, a꞉no꞉lo꞉ hendeleya꞉le? A꞉la꞉ta꞉ga꞉ ene ao iyo꞉ Ya꞉ma꞉so꞉, Yosa꞉bo꞉, Saimono꞉ a꞉la꞉ta꞉ga꞉ Yudas i o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ene ado i a꞉no꞉ tambo ni o꞉lia꞉ wena so꞉lka꞉. A꞉la꞉fo꞉ko꞉lo꞉ kalu wema꞉yo꞉ asulo꞉ nafa o꞉lia꞉ halaido꞉ a꞉no꞉lia꞉yo꞉ o꞉ba a꞉la꞉ta꞉ga꞉ diya꞉le?” Iliyo꞉ a꞉la꞉nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iliyo꞉ Ya꞉suwo꞉ mo꞉beaki gola ba꞉dabiki, Ya꞉su e ba꞉da꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Dinali sa꞉lan kalu a꞉ma꞉yo꞉ hen nowa ha꞉na꞉sa꞉ga꞉ widab amio꞉, kaluka꞉isaleya꞉yo꞉ e wabuluma꞉ib. Ko꞉sega ene amisa꞉n kaluka꞉isale iliyo꞉lo꞉, ene so꞉lo꞉ sab a꞉ma꞉yo꞉lo꞉, emo꞉wo꞉ mo꞉wabulu sa꞉la꞉sen.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amisa꞉n a꞉namio꞉ kaluka꞉isaleyo꞉ e amio꞉ mo꞉tilidabu ko꞉lo꞉, Ya꞉su eyo꞉ molo ha꞉na꞉no꞉ modo꞉wo꞉ a꞉namio꞉ mo꞉dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ho꞉len a꞉namio꞉ Ga꞉lili hen o꞉lo꞉ bo꞉fo꞉lowan kalu Ha꞉lod e, Ya꞉su elo꞉ nanogo꞉ halaido꞉ dimida꞉lab malolo꞉ a꞉no꞉ dabu. ");
INSERT INTO bco_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ha꞉lod eyo꞉ ene nanogdo꞉ dia꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Kalu we Yo꞉n, ho꞉n amilo꞉ to꞉lola꞉leno꞉ o꞉m. E sowa꞉sa꞉ga꞉, nolba꞉yo꞉ e a꞉ma꞉la꞉ dasi alifa꞉ ko꞉lo꞉, o꞉go꞉ molo ha꞉na꞉no꞉lo꞉ dimidama꞉no꞉ halaido꞉ alano꞉ e amio꞉ da꞉lab.” Ha꞉lod eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Tamin amio꞉, Ha꞉lod eyo꞉ ene ao Filiba꞉ inga Ha꞉lodias, e asulia꞉ga꞉ a꞉diabiki, Yo꞉na꞉yo꞉, “Gilo꞉ dimidab wema꞉yo꞉ ele saefa꞉yo꞉ o꞉go꞉sab.” A꞉la꞉sa꞉labikiyo꞉ Ha꞉lod eyo꞉ Yo꞉no꞉ ta꞉lia꞉sa꞉ga꞉ dibolowa to꞉lo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ha꞉lod eyo꞉ Yo꞉no꞉ sana soma꞉no꞉ asulo꞉ ko꞉sega, kaluka꞉isale iliyo꞉ Yo꞉n e dinali sa꞉lan kalulo꞉b a꞉la꞉tili asulo꞉ ko꞉lo꞉, Ha꞉lod eyo꞉ Yo꞉no꞉ sana soma꞉no꞉wo꞉ tagilabiki, ka ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","7","Ko꞉sega Ha꞉lodo꞉ sa꞉la꞉li ho꞉leno꞉ fa꞉la꞉dowabiki, ma꞉no꞉ alan sagalaki na꞉liki sen amio꞉, Ha꞉lodiasa꞉ ida꞉ a꞉ma꞉yo꞉ momada꞉sa꞉ga꞉, kalu kegeo꞉ us a꞉namio꞉ gulo꞉ gulabiki, Ha꞉lod e sagalo꞉ alan dowo꞉. A꞉la꞉go꞉ko꞉lo꞉ Ha꞉lod eyo꞉ Godeya꞉ siwa꞉l amio꞉ a꞉la꞉dinali saefa꞉, “Giyo꞉ nemo꞉wo꞉ kelego꞉ o꞉ba꞉le dabu ba꞉dalega, go꞉ndo꞉ sa꞉lab aumbo꞉ dimia꞉nigo꞉l,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ha꞉lodias eyo꞉ ida꞉mo꞉wo꞉ asulo꞉wo꞉ dimi ko꞉lo꞉, ida꞉ a꞉ma꞉yo꞉ Ha꞉lodbo꞉wo꞉ a꞉la꞉sio꞉, “Yo꞉na꞉ misa꞉yo꞉ gedea꞉sa꞉ga꞉ go꞉fo꞉ wa꞉la dia꞉ta꞉ga꞉ nemo꞉ dimia꞉bi,” a꞉la꞉sio꞉ ");
INSERT INTO bco_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Misa꞉ kalu alan Ha꞉lod e to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, e kele asulaki nofolo꞉wo꞉ alan dowo꞉. Ko꞉sega eyo꞉ kalu ma꞉no꞉lo꞉ ma꞉ni mio꞉ a꞉ma꞉ si wa꞉l amio꞉ dinali saefa꞉ ko꞉lo꞉, eyo꞉ ene nanog kaluwa꞉yo꞉ misa꞉yo꞉ ga o꞉mo꞉ dimina꞉ki towo꞉ halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eyo꞉ Yo꞉na꞉ dagaso꞉ gedema꞉ki ene nanog kaluwo꞉ dibolo aya iliga꞉fo꞉ ");
INSERT INTO bco_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","A꞉la꞉fo꞉ko꞉lo꞉ Yo꞉na꞉ misa꞉yo꞉ gedelea꞉sa꞉ga꞉, go꞉fo꞉ wa꞉la dia꞉ta꞉ga꞉, ga o꞉mo꞉ dimiabikiyo꞉, eyo꞉ dia꞉sa꞉ga꞉ anomo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","A꞉la꞉ta꞉ga꞉ Yo꞉na꞉lo꞉ tili wida꞉sen kalu iyo꞉ ya꞉sa꞉ga꞉, Yo꞉na꞉ do꞉mo꞉wo꞉ dia꞉ha꞉na꞉sa꞉ga꞉ dali alitakiyo꞉, iyo꞉ ha꞉na꞉sa꞉ga꞉ Ya꞉sumo꞉ sa꞉ma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ya꞉su e Yo꞉no꞉ sana sowo꞉ka꞉ a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, e hen a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, e ina꞉li o꞉dofa꞉no꞉ a꞉laki, ho꞉n ko꞉suwa disa꞉ta꞉ga꞉, kalulo꞉ma hen a꞉na ha꞉na꞉ni ane. Ko꞉sega kaluka꞉isale amisa꞉n a꞉namilo꞉ kandayo꞉ a꞉ma꞉yo꞉ elo꞉ dimido꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ ho꞉n golo꞉ aniba ha꞉nakiyo꞉, Ya꞉suwo꞉ ko꞉lo꞉ galima꞉ni ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ya꞉suwo꞉ ho꞉n ko꞉suwa ha꞉na꞉ga꞉yo꞉, ha꞉la꞉ya sili alita꞉ga꞉ ba꞉ba꞉ amio꞉, kaluka꞉isale modo꞉ kegenefo꞉lena ba꞉ba꞉ ko꞉lo꞉, eyo꞉ i a꞉no꞉ alan nofolaki, i amilo꞉ kaluka꞉isale walafdo꞉ dosdo꞉ a꞉no꞉ tambo falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ga꞉lo dowabiki, Ya꞉suwa꞉lo꞉ tili wida꞉sen kaluwo꞉ elo꞉wa ya꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Hen we ma꞉no꞉lo꞉ dia꞉no꞉wo꞉ aundo꞉ma, a꞉la꞉ta꞉ga꞉ ga꞉lo dowabo꞉lo꞉biki, giyo꞉ kaluka꞉isale kegeo꞉ we ma꞉no꞉ ma꞉no꞉wo꞉ ini kililima꞉ki, amisa꞉na iliga꞉felema,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale kegeo꞉ we a꞉ma꞉la꞉bo꞉ waga iliga꞉fa꞉no꞉wo꞉? Ma꞉no꞉ ma꞉no꞉wo꞉ gili dimina.” ");
INSERT INTO bco_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","A꞉la꞉sa꞉labiki, iyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ falawa dowo꞉fa꞉yo꞉ bila꞉fo꞉, a꞉la꞉ta꞉ga꞉ ka꞉ a꞉la꞉ a꞉no꞉ko꞉ da꞉lab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“A꞉no꞉ nelo꞉ wena dia꞉mena.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ya꞉su eyo꞉ kaluka꞉isaleyo꞉ fugusa꞉ wa꞉la kandama꞉ki sa꞉la꞉sa꞉ga꞉yo꞉, falawa dowo꞉fa꞉ bila꞉fo꞉ o꞉lia꞉ ka꞉ a꞉la꞉ dia꞉sa꞉ga꞉, akino꞉ alolo bo꞉fo꞉liki, Godemo꞉ mada o꞉m a꞉la꞉dulugu sio꞉. A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ eyo꞉ falawa dowo꞉fa꞉ a꞉no꞉ a꞉na goda꞉sa꞉ga꞉, ene tiliwida꞉sen kalumo꞉ dimiabiki, iliyo꞉ kaluka꞉isalemo꞉wo꞉ a꞉na so꞉go꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Kaluka꞉isale kegeo꞉ a꞉no꞉ tambo ma꞉no꞉wo꞉ o꞉li na꞉sa꞉ga꞉ ililitabiki, ma꞉no꞉ heb ta꞉felab a꞉no꞉ enedo꞉ tili wida꞉sen kalu iliyo꞉ kegeo꞉ amio꞉ fafowo꞉ kugula꞉fo꞉ ko꞉lo꞉ wa꞉litabi difa꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma꞉no꞉ o꞉lo꞉ mo꞉no꞉, kalule agelo꞉wo꞉ daosen bila꞉fo꞉ ko꞉lo꞉ sen (5,000.) Ko꞉sega ka꞉isale o꞉lia꞉ so꞉wagalin o꞉lia꞉yo꞉ mo꞉agelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","O꞉g a꞉nakabiyo꞉ Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalu a꞉no꞉ ko꞉suwa disa꞉la꞉sa꞉ga꞉, ho꞉n golo꞉ nodowa tamina hamana꞉kiyo꞉, imo꞉wo꞉ halale sio꞉. Iyo꞉ iliga꞉takiyo꞉, Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉lo꞉ a꞉ma꞉la꞉ iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iyo꞉ iliga꞉takiyo꞉ ina꞉li misio꞉wa fa꞉la꞉ ha꞉na꞉sa꞉ga꞉, Godemo꞉ dulugu sa꞉ma꞉ni ane. Sola꞉ga꞉ yabikiyo꞉ e ina꞉li ka elen. ");
INSERT INTO bco_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A꞉la꞉ta꞉ga꞉ ho꞉n ko꞉suwo꞉ ho꞉n sa꞉ a꞉no꞉ ta꞉ta꞉sa꞉ga꞉ aneyo꞉, ho꞉n golo꞉ usa dowabikiyo꞉, fufayo꞉ alan ilo꞉ ha꞉na꞉no꞉ doba꞉da꞉ a꞉la꞉ta꞉ga꞉ yakiyo꞉, ma꞉feyo꞉ alan a꞉ma꞉yo꞉ iyo꞉ nodoma꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ho꞉lema꞉no꞉wo꞉ ko꞉na꞉ma dowabikiyo꞉, Ya꞉suwo꞉ ho꞉n fa꞉sa꞉ wa꞉la wa꞉la꞉la꞉li ha꞉na꞉ga꞉, ilo꞉wa fa꞉la꞉dowo꞉ ");
INSERT INTO bco_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Tiliwida꞉sen kaluwa꞉yo꞉ Ya꞉suwo꞉ ho꞉na꞉ wa꞉la yabiki ba꞉ba꞉ amio꞉, iyo꞉ mada iligo꞉. A꞉la꞉ta꞉ga꞉ iyo꞉ tagilaki a꞉la꞉ho꞉le sio꞉, “Sowo꞉ mama ko꞉lo꞉ yabolo꞉ka꞉!” ");
INSERT INTO bco_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ towo꞉ imo꞉wo꞉ bo꞉bo꞉ge sio꞉, “Gio꞉ tagila꞉so꞉bo. We neka꞉! Gili asulo꞉wo꞉ halale doma,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bidaya꞉ sa꞉lakiyo꞉, “Kalu Alan hendele gelalega, ne gelo꞉ amio꞉ ho꞉na꞉ wa꞉la menalema,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ya꞉su eyo꞉ “Ge mena!” a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ Bida e ko꞉suwa a꞉la꞉ta꞉ga꞉ ho꞉na꞉ wa꞉la tibo꞉lota꞉ga꞉, Ya꞉sulo꞉wa ane. ");
INSERT INTO bco_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ko꞉sega Bida e fufa alan a꞉no꞉ ba꞉dakiyo꞉ e tagi dowo꞉ ko꞉lo꞉, e ho꞉n amio꞉ mo꞉mo꞉da tinabikiyo꞉, Ya꞉suwo꞉ ho꞉idaki a꞉la꞉sio꞉, “Kalu Alan, ne gasilima.” ");
INSERT INTO bco_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Wigibo a꞉naka Ya꞉su eyo꞉ Bidayo꞉ gasiliakiyo꞉, “Gi tilidabuwo꞉ ha꞉lulo꞉b. Ge asulo꞉wo꞉ a꞉la꞉ dowabko꞉ mo꞉wo꞉ ha꞉?” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","A꞉la꞉ta꞉ga꞉ a꞉la꞉yo꞉ ko꞉suwa a꞉disa꞉tabiki, fufa ya꞉len a꞉no꞉ a꞉na bulufo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Kalu ko꞉su amilo꞉ sen i a꞉ma꞉yo꞉ Ya꞉su e wabudaki a꞉la꞉sio꞉, “Ge mada hendele Godeya꞉ So꞉walelo꞉ka꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Iyo꞉ ho꞉n golo꞉ nodowa ta꞉nota꞉ga꞉yo꞉, Genesalet hen a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Genesalet amisa꞉n kalu iliyo꞉ Ya꞉suwo꞉ fanda ba꞉da꞉sa꞉ga꞉yo꞉, towo꞉ amisa꞉n ta꞉i ane o꞉mo꞉wo꞉ tambo saga꞉felo꞉ ko꞉lo꞉, walaf kaluka꞉isale amisa꞉n a꞉namida꞉lo꞉ sab a꞉no꞉ tambo Ya꞉sulo꞉wa tililia꞉ ya꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kaluka꞉isale iliyo꞉ Ya꞉sumo꞉ susiakiyo꞉ a꞉la꞉sio꞉, “Ni walaf kalu wema꞉yo꞉ gi helebeso꞉g migif kona goma꞉no꞉wo꞉ o꞉liya꞉le?” A꞉la꞉ta꞉ga꞉ walaf kaluka꞉isale abeyo꞉ ene so꞉g amilo꞉ golab a꞉no꞉, e falelab. ");
INSERT INTO bco_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ho꞉len no amio꞉, Fa꞉lisi kalu nolo꞉lo꞉ a꞉la꞉ta꞉ga꞉ elelo꞉ wida꞉sen kalu nol o꞉lia꞉yo꞉, Ya꞉lusalem a꞉la꞉ta꞉ga꞉ yakiyo꞉, iyo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉yo꞉, e o꞉lia꞉ towa꞉ kegakiyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Gilo꞉ tili wida꞉sen kalu iliyo꞉ ma꞉no꞉ ma꞉nikiyo꞉, dagiyo꞉ tamin amio꞉ mo꞉to꞉go꞉dab ko꞉lo꞉, nili ma꞉muwa꞉ mano꞉ ili mo꞉kudu ha꞉nab a꞉no꞉ mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉lo꞉ to o꞉leauka imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Giliyo꞉ gi ma꞉muwa꞉lo꞉ dimidan man a꞉no꞉ ka kudu ha꞉naki, ko꞉sega Godeya꞉ ele difa꞉ a꞉no꞉ gililo꞉ o꞉go꞉sa꞉lab ko mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Gode eyo꞉ ele we saefa꞉, ‘Gio꞉ go꞉lo꞉ go꞉wo꞉ alano꞉ o꞉m a꞉la꞉asulaki, ili ha꞉ga dowa꞉lubi.’ A꞉la꞉ta꞉ga꞉ ele nowo꞉ we, ‘So꞉wa abeyo꞉ iyalia꞉ anolia꞉mo꞉wo꞉ to mogago꞉wo꞉ sa꞉lalega, e mada sana sowa꞉bi,’ a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Ko꞉sega giliyo꞉ towo꞉ a꞉la꞉sa꞉la꞉sen, ‘Kalu abeyo꞉ iyalia꞉ anolia꞉mo꞉ sa꞉lakiyo꞉, “Kelego꞉ we gemo꞉ dimia꞉no꞉ ko꞉sega, niyo꞉ kelego꞉ we Godemo꞉ dimia꞉no꞉ da꞉fe alifa꞉ ko꞉lo꞉ ge mo꞉asuwa꞉fa꞉no꞉,” towo꞉ o꞉leo꞉ngo꞉ sa꞉lalega, kalu iyayo꞉ mo꞉wabudaki gab a꞉no꞉ giliyo꞉ o꞉ligab a꞉la꞉sa꞉la꞉sen. Gilido꞉ a꞉la꞉do꞉ ga꞉lab a꞉na ilikiyo꞉, Godeya꞉ ele a꞉no꞉ anilakiyo꞉ o꞉ngo꞉malo꞉ngo꞉ ta꞉taki, gi ma꞉muwa꞉ man a꞉no꞉ wabudaki wa꞉la꞉bo꞉ a꞉no꞉ ko꞉lo꞉ ta꞉lisab. ");
INSERT INTO bco_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","To mosowa꞉lo꞉ widan kaluwo꞉ gi we. Dinali sa꞉lan kalu Aisaya eyo꞉ man gilido꞉ a꞉no꞉ hendele da꞉feakiyo꞉, to we a꞉na dinali saefa꞉, ");
INSERT INTO bco_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Kaluka꞉isale i wema꞉ mego꞉f mosowa꞉yo꞉ ni wiyo꞉ ko꞉lo꞉ wabudan, ko꞉sega inin asulo꞉wo꞉ ne o꞉lia꞉yo꞉ mo꞉imilo꞉, ko꞉na꞉ dofo꞉likigab. ");
INSERT INTO bco_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Iliyo꞉ ma꞉muwa꞉ man ko꞉lo꞉ widakiyo꞉, Godeya꞉ ene man a꞉no꞉ ko꞉lo꞉ wido꞉l a꞉la꞉sa꞉la꞉sen. Iliyo꞉ ne wi duludakilo꞉ to sa꞉la꞉lab a꞉no꞉ o꞉ngo꞉malo꞉ngo꞉ dowab.’ ” ");
INSERT INTO bco_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","A꞉la꞉gabiki, Ya꞉suwa꞉yo꞉ kaluka꞉isaleyo꞉ elo꞉wa mena꞉ki ho꞉ida꞉sa꞉ga꞉yo꞉, towo꞉ imo꞉wo꞉ a꞉la꞉sio꞉. “Gio꞉ to we dinafa da꞉da꞉sa꞉ga꞉ asula꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kelego꞉ kaluwa꞉ mego꞉f amilo꞉ ti ha꞉nab a꞉ma꞉yo꞉, Godeya꞉ siwa꞉l amio꞉ e heyo꞉wo꞉ doma꞉kiyo꞉ mo꞉dimidama꞉ib. Ko꞉sega kalu a꞉ma꞉ ene mego꞉fa a꞉la꞉ta꞉ga꞉lo꞉ handalowab a꞉ma꞉yo꞉sa, e heyo꞉wo꞉ doma꞉ki ta꞉fa꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tif amio꞉ Ya꞉suwa꞉lo꞉ tili wida꞉sen kalu iyo꞉ elo꞉wa ya꞉ga꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Fa꞉lisi kalu iyo꞉ to gilo꞉ sio꞉ a꞉no꞉ da꞉da꞉likiyo꞉, iyo꞉ to a꞉ma꞉yo꞉ gemo꞉wo꞉ mo꞉bea꞉sa꞉ga꞉, gola ba꞉daki gab, a꞉la꞉bo꞉ ge asulaya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","14","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Giliyo꞉ a꞉no꞉ asula꞉so꞉bo. Ini kabi ta꞉ta꞉bi. Ni Do Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉, fo enedo꞉ mo꞉gelo꞉ a꞉no꞉ tambo dugula꞉ma꞉ib. Fa꞉lisi kalu iliyo꞉ kaluka꞉isaleyo꞉ tililia꞉ ha꞉naki bo꞉fo꞉mela꞉no꞉ asulab ko꞉sega, iyo꞉ siyo꞉ ko꞉n kalu o꞉ngo꞉ dowab. Siyo꞉ ko꞉n kalu noma꞉yo꞉, siyo꞉ ko꞉n kalu nowo꞉ tililia꞉ ha꞉nalega, a꞉la꞉yo꞉ ida꞉niase daido꞉wa mada ho꞉lufa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ko꞉sega Bidaya꞉ emo꞉ sa꞉laki, “Giyo꞉ bale sio꞉ we nimo꞉wo꞉ fanda sama.” ");
INSERT INTO bco_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ o꞉semo꞉ asulo꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kelego꞉ o꞉ba꞉le mego꞉f amilo꞉ ti ha꞉nab a꞉no꞉ tambo kufa꞉ usamio꞉ ti ha꞉na꞉sa꞉ga꞉, a꞉ma꞉la꞉ baya ha꞉na꞉sen. Giliyo꞉ a꞉la꞉bo꞉ mo꞉asulo꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ko꞉sega kelego꞉ asulo꞉wa a꞉la꞉ta꞉ga꞉lo꞉ mego꞉f amilo꞉ fa꞉la꞉dowab a꞉ma꞉yo꞉, kaluwo꞉ heyo꞉wo꞉ doma꞉ki ta꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Mo꞉wo꞉ kaluwa꞉ asulo꞉ usamilo꞉ mogago꞉ ko꞉lilo꞉ fa꞉la꞉dowa꞉lab a꞉no꞉ we. Asulo꞉ mogago꞉wo꞉, kalu sana soma꞉no꞉ mano꞉, kalu galeso꞉ o꞉lia꞉ ga indo꞉ o꞉lia꞉ma꞉lo꞉ afa dian mano꞉, uwo꞉ dian mano꞉, afa dian mano꞉, nowo꞉mbo꞉lo꞉ diga꞉li sa꞉lan mano꞉, a꞉la꞉ta꞉ga꞉ sada꞉dan mano꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Godeya꞉ siwa꞉l amio꞉ kaluwo꞉ heyo꞉lo꞉ dowa꞉labo꞉ man wema꞉ gelab. Ko꞉sega dagiyo꞉ mo꞉to꞉go꞉dakilo꞉ mano꞉ nan man a꞉ma꞉yo꞉, e amio꞉ heyo꞉wo꞉ mada mo꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","A꞉la꞉ta꞉ga꞉ Ya꞉suwo꞉ hen a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, e Taya o꞉lia꞉ Saido꞉n hen a꞉namida꞉ ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ka꞉ina꞉n ga nowo꞉ a꞉na elen. Ga a꞉no꞉, Isolael gama ko꞉sega e Ya꞉sulo꞉wa yakiyo꞉, emo꞉wo꞉ halale sa꞉laki a꞉la꞉sio꞉, “Kalu Alan, Da꞉ibida꞉ so꞉wa, giyo꞉ ne nofolaki asuwa꞉foma. Ni na꞉la꞉yo꞉ mama mogago꞉ dowaki mada mogagila꞉lab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ to nowo꞉ emo꞉wo꞉ mada mo꞉sio꞉. Enedo꞉ tili wida꞉sen kalu iyo꞉ elo꞉wa ya꞉sa꞉ga꞉, emo꞉wo꞉ towo꞉ susiaki a꞉la꞉sio꞉, “Ga we nili fa꞉sa yakiyo꞉ towo꞉ halale sa꞉la꞉i yab ko꞉lo꞉, e a꞉ma꞉la꞉ iliga꞉foma.” ");
INSERT INTO bco_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ya꞉su eyo꞉ towo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Isolael kaluka꞉isaleyo꞉ sibi sulu ane o꞉ngo꞉ ko꞉lo꞉, i a꞉no꞉ko꞉ asuwa꞉foma꞉ki, ne a꞉na iliga꞉fo꞉.” ");
INSERT INTO bco_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ko꞉sega ga a꞉no꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉ gulalu misa꞉fu alilakiyo꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “Kalu Alan, giyo꞉ ne asuwa꞉foma.” ");
INSERT INTO bco_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ya꞉su eyo꞉ towo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉ a꞉la꞉sio꞉, “So꞉wagalina꞉ ma꞉no꞉wo꞉ asulia꞉ga꞉yo꞉, gasamo꞉ sandifa꞉no꞉wo꞉ mada mo꞉ililo꞉.” ");
INSERT INTO bco_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A꞉la꞉sa꞉labiki ga a꞉ma꞉ sa꞉lakiyo꞉, “Kalu Alan, gilo꞉ to sa꞉lab ko mada hendele. Ko꞉sega gasalo꞉ biso꞉wa꞉ i fofodo꞉ ha꞉g ami siliki, ma꞉n muda꞉yo꞉ sudufelab a꞉no꞉ ko꞉lo꞉ na꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ya꞉su eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “Ga ge, tili dabu gilo꞉wo꞉ mada alan ko꞉lo꞉, kelego꞉ gilo꞉ fa꞉la꞉domabesa꞉ a꞉la꞉do꞉ asulab a꞉no꞉, hendele fa꞉la꞉doma꞉ki ta꞉to꞉l.” A꞉la꞉ta꞉ga꞉ wigibo a꞉naka gaya꞉ ida꞉yo꞉ hendele falelab. ");
INSERT INTO bco_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ya꞉suwo꞉ hen a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, Ga꞉lili ho꞉n golo꞉ anib a꞉na ha꞉na꞉ni ane. A꞉na ha꞉nakiyo꞉, Ya꞉su e misio꞉wa fa꞉la꞉ ha꞉na꞉sa꞉ga꞉ a꞉na mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","A꞉la꞉ta꞉ga꞉ kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ elo꞉wa mio꞉. Iliyo꞉ ko꞉go꞉neli kaluka꞉isaleyo꞉lo꞉, siyo꞉ ko꞉no꞉lo꞉, giligisen kaluka꞉isaleyo꞉lo꞉, mego꞉fo꞉ do꞉fo꞉fo꞉lo꞉, a꞉la꞉ta꞉ga꞉ walaf kalu nolo꞉lo꞉ modo꞉ tililia꞉ga꞉, Ya꞉suwa꞉ gib anib a꞉na ta꞉felabikiyo꞉, eyo꞉ i a꞉na falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","A꞉la꞉fo꞉ko꞉lo꞉ mego꞉fo꞉ do꞉fo꞉f dowo꞉wo꞉ tola꞉b, a꞉la꞉ta꞉ga꞉ giligiseno꞉lo꞉ o꞉li dowa꞉b, gibo꞉ ko꞉go꞉neliyo꞉lo꞉ o꞉li ha꞉na꞉b, a꞉la꞉ta꞉ga꞉ siyo꞉ ko꞉no꞉lo꞉ wa꞉ka a꞉ba꞉da꞉b a꞉la꞉gabiki kaluka꞉isale iyo꞉ dimidab a꞉no꞉ ba꞉dakiyo꞉, iyo꞉ mo꞉lo꞉ asulaki, Isolael kaluwa꞉ Gode inido꞉ a꞉ma꞉ wiyo꞉ ko꞉lo꞉ wabudaki dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kaluwo꞉ elo꞉wa mena꞉ki ho꞉ida꞉sa꞉ga꞉yo꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ne kaluka꞉isale kegeo꞉ i we mada nofolab. Iyo꞉ ho꞉len otaleno꞉ ne o꞉lia꞉ wena sen ko꞉lo꞉, o꞉go꞉ ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉ma dowabiki, iyo꞉ maiyo꞉wo꞉ alan dowab. Iyo꞉ kilo꞉ma dowaki toga tulu alilabena꞉kiyo꞉, niyo꞉ mo꞉iliga꞉fa꞉no꞉ a꞉la꞉asulo꞉.” ");
INSERT INTO bco_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Enedo꞉ tili wida꞉sen kalu iliyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ ma꞉no꞉loma hena so꞉l a꞉la꞉ta꞉ga꞉ kalu kegeo꞉wo꞉ modo꞉lo꞉biki, ma꞉no꞉ modo꞉wo꞉ o꞉bami dia꞉sa꞉ga꞉ maiya꞉ki dimia꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Falawa dowo꞉fa꞉yo꞉ giliyo꞉ o꞉biba꞉s da꞉laba?” Iliyo꞉ emo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Dom a꞉la꞉fo꞉ a꞉la꞉ta꞉ga꞉ ka꞉ galin nolo꞉lo꞉ da꞉lab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","36","Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ hena mesea꞉ki sa꞉la꞉sa꞉ga꞉yo꞉, eyo꞉ falawa dowo꞉fa꞉ dom a꞉la꞉fo꞉ o꞉lia꞉ ka꞉ o꞉lia꞉yo꞉ dia꞉sa꞉ga꞉, Godemo꞉ mada o꞉m a꞉la꞉sio꞉. Dulugu sa꞉la꞉sa꞉ga꞉yo꞉, ma꞉no꞉wo꞉ goda꞉sa꞉ga꞉, enedo꞉ tili wida꞉sen kalumo꞉ dimiabiki, iliyo꞉ kaluka꞉isale kegeo꞉ o꞉mo꞉wo꞉ a꞉na so꞉go꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kaluka꞉isale iyo꞉ ma꞉no꞉wo꞉ na꞉la꞉ga꞉ o꞉li dowabiki, ma꞉no꞉ heb ta꞉felo꞉ a꞉no꞉ ko꞉lo꞉ kegeo꞉wo꞉, fafowo꞉ dom a꞉la꞉fo꞉ wa꞉li tandeo꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma꞉no꞉ o꞉lo꞉ mo꞉no꞉wo꞉, kalule agelo꞉wo꞉ daosen fa꞉la꞉da꞉in ko꞉lo꞉ sen (4,000.) Ko꞉sega ka꞉isale o꞉lia꞉ so꞉wagalin o꞉lia꞉yo꞉ mo꞉agelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ iliga꞉takiyo꞉, e ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉, Magadan hen a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fa꞉lisi kalu i o꞉lia꞉ Sadusi kalu i o꞉lia꞉yo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, e ko꞉lo꞉ da꞉fe ba꞉dakiyo꞉, iliyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ele ba꞉ba꞉no꞉ nowo꞉, Hebene halonamilo꞉ a꞉lab Gode a꞉na a꞉la꞉ta꞉ga꞉lo꞉ fa꞉la꞉dowab a꞉no꞉ nio꞉ ba꞉ba꞉nigo꞉l ko꞉lo꞉ walama,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Ga꞉lo dowaki akino꞉ genelab amio꞉, ‘Aliyo꞉ molofama꞉nigabo꞉lo꞉ka꞉,’ giliyo꞉ a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","A꞉la꞉ta꞉ga꞉ kea꞉fo ami akino꞉ genelaki a꞉la꞉ta꞉ga꞉ kolo꞉ heyo꞉ dowab amio꞉, ‘O꞉go꞉ fufa o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ doma꞉nigab,’ giliyo꞉ a꞉la꞉sa꞉la꞉sen. A꞉ hendele, giliyo꞉ akin amilo꞉ fa꞉la꞉dowab a꞉no꞉ ko꞉lo꞉ ele ba꞉da꞉sa꞉ga꞉ a꞉na fanda asula꞉sen. Ko꞉sega o꞉g ho꞉len wenamilo꞉ kelego꞉ ho꞉gi fa꞉la꞉doma꞉nigab a꞉no꞉ ko꞉lo꞉ ele ba꞉ba꞉no꞉wo꞉ giliyo꞉ mo꞉fanda asulo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kaluka꞉isale o꞉g wenamilo꞉ sab we, iyo꞉ hendele mogago꞉le ko꞉lo꞉, iyo꞉ Gode o꞉lia꞉yo꞉ mo꞉ege dowab. Iyo꞉ ele ba꞉ba꞉no꞉ Godelo꞉wa a꞉la꞉ta꞉ga꞉lo꞉ fa꞉la꞉dowab a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉no꞉ asulab. Ko꞉sega ele ba꞉ba꞉no꞉ nowo꞉ mo꞉widalikiyo꞉, iyo꞉ dinali sa꞉lan kalu Yona elo꞉ amilo꞉ fa꞉la꞉dowo꞉ o꞉leo꞉ngo꞉ka ba꞉ba꞉ib.” A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ Ya꞉su eyo꞉ iyo꞉ ta꞉ta꞉sa꞉ga꞉ ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ya꞉suwa꞉ enedo꞉ tili wida꞉sen kalu iyo꞉ ho꞉n golo꞉ a꞉no꞉ ta꞉nota꞉ga꞉ nodowa fa꞉la꞉dowakiyo꞉, iliyo꞉ ma꞉no꞉ dia꞉no꞉wo꞉ ga꞉lila꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ Fa꞉lisi o꞉lia꞉ Sadusi o꞉lia꞉ma꞉ falawalo꞉ anayan kelego꞉ yis a꞉no꞉ dinafa yasi dowaki bo꞉fo꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tili wida꞉sen iliyo꞉, towo꞉ egele nenelakiyo꞉ a꞉la꞉sio꞉, “Elo꞉ sa꞉lab a꞉no꞉, nio꞉ ma꞉no꞉wo꞉ mo꞉dia꞉mio꞉ a꞉no꞉ ko꞉lo꞉ sa꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ko꞉sega Ya꞉su eyo꞉ ililo꞉ nenelab a꞉no꞉ asula꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gio꞉ ma꞉no꞉wo꞉ aundo꞉malo꞉b a꞉la꞉do꞉ nenelab ko, mo꞉wo꞉ ha꞉? Gili tilidabuwo꞉ mada ha꞉lula꞉su dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gio꞉ o꞉semo꞉ fanda asulaya? Nilo꞉ falawa dowo꞉fa꞉ bila꞉fo꞉wo꞉ goda꞉sa꞉ga꞉, kalu 5,000 a꞉la꞉fo꞉mo꞉lo꞉ dimi a꞉no꞉, giliyo꞉ ga꞉lilaki mo꞉fanda asulo꞉wo꞉? Giliyo꞉ fafowo꞉ o꞉biba꞉s ko꞉lo꞉ wa꞉li tandeo꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","A꞉la꞉ta꞉ga꞉ giliyo꞉ falawa dowo꞉fa꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ kalu 4,000 a꞉la꞉fo꞉ i a꞉ma꞉lo꞉ mo꞉no꞉ a꞉no꞉ asuluma. Giliyo꞉ na꞉sa꞉ga꞉yo꞉, fafowo꞉ o꞉biba꞉s ko꞉lo꞉ wa꞉li tandeo꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Niyo꞉ ma꞉no꞉ kele asulakiyo꞉ mo꞉sio꞉. Gio꞉ a꞉la꞉bo꞉ mo꞉fanda asulo꞉wo꞉ mo꞉wo꞉ ha꞉? Niyo꞉ wa꞉ka sa꞉ma꞉nigo꞉l. Giliyo꞉ Fa꞉lisi o꞉lia꞉ Sadusi o꞉lia꞉ma꞉ yiso꞉ dinafa yasi dowaki bo꞉fo꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iliyo꞉ to elo꞉ sa꞉lab a꞉no꞉ ko꞉lo꞉ da꞉dakiyo꞉, iyo꞉ o꞉li fanda asulo꞉. Ya꞉su eyo꞉ ma꞉ndo꞉ anayan kelego꞉ yis a꞉no꞉ ko꞉lo꞉ sio꞉malo꞉b. Fa꞉lisi o꞉lia꞉ Sadusi o꞉lia꞉ma꞉lo꞉ to widab a꞉no꞉ ko꞉lo꞉ bale sa꞉labo꞉lo꞉b a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ya꞉suwo꞉ Sesalia Filibai hen a꞉na ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowakiyo꞉, eyo꞉ enedo꞉ tili wida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ne Kalule Dowo꞉ ko꞉sega kaluka꞉isale iliyo꞉, ‘Ne kalu o꞉b’ a꞉la꞉asulaki sa꞉laba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","A꞉la꞉sa꞉labiki iliyo꞉ a꞉la꞉sio꞉, “Nolba꞉yo꞉ Yo꞉n ho꞉n amilo꞉ to꞉lolano꞉ ge. Nolba꞉yo꞉ ge Elaiya. A꞉la꞉ta꞉ga꞉ nolba꞉yo꞉ Ya꞉limayaya꞉le o꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu imilig nowo꞉ geya꞉le a꞉la꞉sa꞉la꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Kaluka꞉isale iliyo꞉ a꞉la꞉sa꞉la꞉sen ko꞉sega, giliyo꞉ ne o꞉b a꞉la꞉sa꞉ma꞉nigaya?” ");
INSERT INTO bco_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Bidaya꞉ a꞉ma꞉la꞉ sa꞉laki, “Ge Keliso, Mela꞉no꞉lo꞉ A꞉lab Godeya꞉ So꞉wayo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A꞉la꞉sa꞉labikiyo꞉ Ya꞉suwa꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Saimon, Yo꞉na꞉ya꞉ inso꞉ ge mada ego꞉lelo꞉b. Asulo꞉ gilo꞉ a꞉no꞉, henfelo꞉ kaluwa꞉yo꞉ mo꞉wido꞉. Do Hebenelo꞉ a꞉lab haloma꞉yo꞉ gemo꞉ wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ towo꞉ gemo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Bida, ge wi a꞉ma꞉ ha꞉go꞉ u ko꞉lo꞉, niyo꞉ no꞉no꞉n sa꞉s a꞉no꞉ u wa꞉l wena di alifa꞉no꞉. A꞉la꞉ta꞉ga꞉ sowana꞉ halaido꞉wa꞉yo꞉ sa꞉s o꞉lia꞉ bubakiyo꞉ mo꞉bidila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kaluka꞉isaleyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉namilo꞉ tina꞉liki, mo꞉tina꞉liki a꞉la꞉mela꞉no꞉ halaido꞉ a꞉no꞉ gemo꞉ dimia꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isale tiha꞉na꞉mela꞉no꞉ gilo꞉ kalitab a꞉no꞉, Gode Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ o꞉ma kalifa꞉ ko꞉lo꞉lab. A꞉la꞉ta꞉ga꞉ kaluka꞉isale tiha꞉na꞉mela꞉no꞉ gilo꞉ kolaetab a꞉no꞉, Gode Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ o꞉ma kolaefa꞉ ko꞉lo꞉lab.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉suwa꞉yo꞉ enedo꞉ tiliwida꞉sen kalumo꞉wo꞉ halaido꞉ sa꞉lakiyo꞉, nolbo꞉wo꞉ ne Keliso, Godeya꞉ Da꞉feyo꞉ Kalu a꞉la꞉bo꞉ sa꞉la꞉so꞉bo a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","O꞉g ho꞉len a꞉namio꞉, Ya꞉su eyo꞉ enedo꞉ tiliwida꞉sen kalu imo꞉wo꞉ e amilo꞉ fa꞉la꞉doma꞉ib a꞉no꞉ ko꞉lo꞉ mo꞉mo꞉da sio꞉. E Ya꞉lusalem ha꞉na꞉sa꞉ga꞉ silikiyo꞉, Yu ko꞉go꞉dego꞉ kaluwa꞉yo꞉lo꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉yo꞉lo꞉, a꞉la꞉ta꞉ga꞉ elelo꞉ wida꞉sen kaluwa꞉yo꞉lo꞉ iliyo꞉ nagalo꞉wo꞉ alan emo꞉ dimiaki, e sana soma꞉ib a꞉la꞉likiyo꞉ imo꞉wo꞉ kalaba sio꞉. A꞉la꞉ta꞉ga꞉ ho꞉len otaleno꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, mela꞉no꞉wo꞉ a꞉dia꞉sa꞉ga꞉, a꞉ma꞉la꞉ dasi alifa꞉ib a꞉la꞉liki sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bidayo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, eyo꞉ Ya꞉suwo꞉ ha꞉la꞉ya tililia꞉ ha꞉na꞉sa꞉ga꞉, emo꞉wo꞉ gadi sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Alan, a꞉la꞉bo꞉ sa꞉la꞉so꞉bo. Kelego꞉ a꞉no꞉ gelo꞉ amio꞉ mada mo꞉fa꞉la꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ya꞉suwo꞉ a꞉ma꞉la꞉ nodola꞉sa꞉ga꞉yo꞉, Bida emo꞉wo꞉ a꞉la꞉sio꞉, “Sa꞉da꞉na꞉, ge ni fa꞉s doba꞉da꞉ hamana. Tog nilo꞉wo꞉ gi ka꞉lab. Mo꞉wo꞉ ge Godeya꞉lo꞉ asulab aumbo꞉ mo꞉kudu ha꞉nab. Ko꞉sega ge kaluwa꞉lo꞉ asulab au kudu ha꞉nab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalu imo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale abeyo꞉ ne kudu mia꞉no꞉ asulalega, eyo꞉ enen asulano꞉ ka ta꞉ta꞉ga꞉, i malano꞉ ene dia꞉ha꞉naki, soma꞉no꞉wo꞉ o꞉lika꞉ a꞉laki, ne a꞉na kudu ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Mo꞉wo꞉ kaluka꞉isale abeyo꞉, ene mela꞉no꞉wo꞉ kanulu ta꞉li dofo꞉lalega, ene mela꞉no꞉ a꞉no꞉ sulu ha꞉na꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ ne kudu yakiyo꞉, ene mela꞉no꞉wo꞉ walalega, ene mela꞉no꞉wo꞉ a꞉dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mo꞉wo꞉ e kelego꞉ henfelo꞉ wilo꞉ da꞉lab a꞉no꞉ ko꞉lo꞉ tambo asula꞉sa꞉ga꞉ kegenela꞉len amio꞉, mela꞉no꞉le elo꞉wo꞉ sulu ha꞉nalega, kelego꞉ a꞉ma꞉yo꞉ e waga asuwa꞉fa꞉iba? Kalu a꞉ma꞉yo꞉ ene mela꞉no꞉leyo꞉ a꞉ma꞉la꞉ kililiakiyo꞉, wa꞉lo꞉ o꞉b ko꞉lo꞉ dimea꞉iba꞉le? A꞉la꞉bo꞉ mo꞉dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Kalule Dowo꞉ e yakiyo꞉, Iyaya꞉ ho꞉len alan a꞉ma꞉ momade alitalikiyo꞉, ene ma꞉mula꞉ kalu o꞉lia꞉ mia꞉nigab. Ho꞉len a꞉namio꞉ kaluka꞉isale ini man enedo꞉ dimida꞉len o꞉leaumbo꞉, wa꞉lo꞉ inibo꞉ dimea꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Niyo꞉ to we hendele gimo꞉ so꞉lo꞉l. Kaluka꞉isale nol wilo꞉ kagafo꞉lab we, iyo꞉ o꞉semo꞉sowo꞉ elen amio꞉, Kalule Dowo꞉wo꞉, misa꞉ kalu ko꞉lo꞉ yan o꞉leau yaliki ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ho꞉len do꞉go꞉fela꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, Ya꞉suwa꞉yo꞉ Bidayo꞉, Ya꞉ma꞉so꞉ a꞉la꞉ta꞉ga꞉ ene ao Yo꞉no꞉, iyo꞉ egelese mesa꞉niki misio꞉wa tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ho꞉len a꞉namio꞉ Ya꞉suwa꞉ do꞉mo꞉wo꞉ nodola꞉sa꞉ga꞉, ko꞉li fa꞉la꞉dowabiki ba꞉ba꞉. Ene wo꞉lokan amio꞉ ho꞉leno꞉ of ko꞉lo꞉ so꞉so꞉lelia꞉ga꞉ fa꞉la꞉dowan o꞉ngo꞉ ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ ene so꞉go꞉ ho꞉lo꞉ fo꞉fo꞉lesodo꞉ o꞉ngo꞉ fa꞉la꞉dowabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Tili wida꞉sen kalu otalen iyo꞉ bo꞉fo꞉len amio꞉, Mo꞉sa꞉s o꞉lia꞉ Elaiya o꞉lia꞉yo꞉ a꞉na fa꞉la꞉dota꞉ga꞉, Ya꞉su o꞉lia꞉ tola꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bidayo꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉su emo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Alan, nio꞉ wilo꞉ dowo꞉wo꞉ mada nafale. Giyo꞉ ko꞉lo꞉ a꞉la꞉asulalega, niyo꞉ a ha꞉lu otaleno꞉ dialifa꞉no꞉. Nowo꞉ gino꞉, nowo꞉ Mo꞉sa꞉s eno꞉, nowo꞉ Elaiya eno꞉.” ");
INSERT INTO bco_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Bidayo꞉ to a꞉no꞉ o꞉sa꞉la꞉labikiyo꞉, iyo꞉ kol ho꞉lo꞉ fo꞉fo꞉lesodo꞉ ho꞉len a꞉ma꞉ ga꞉lula꞉. Kola꞉ us a꞉namio꞉, to nowo꞉ a꞉la꞉sio꞉, “We no꞉no꞉ so꞉wale ko꞉lo꞉, niyo꞉ e mada alan asulo꞉. Gio꞉ to elo꞉ sa꞉lab a꞉no꞉ dabuma.” ");
INSERT INTO bco_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tili wida꞉sen kalu iliyo꞉ to a꞉no꞉ da꞉dakiyo꞉, iyo꞉ wo꞉lokano꞉ hena gumisi fufudakiyo꞉, tagio꞉ mada alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ya꞉suwo꞉ ilo꞉wa ya꞉ga꞉, iyo꞉ golakiyo꞉ a꞉la꞉sio꞉, “Gio꞉ dasima. Gio꞉ tagila꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Iyo꞉ alolo ba꞉ba꞉ amio꞉, kalu nowo꞉ a꞉namio꞉ mo꞉elen ko꞉sega, iliyo꞉ Ya꞉suwo꞉ ko꞉lo꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Iyo꞉ misio꞉wa a꞉la꞉ta꞉ga꞉ tindakiyo꞉, Ya꞉su eyo꞉ imo꞉wo꞉ halale sa꞉laki, “Kalule Dowo꞉ ne sowa꞉sa꞉ga꞉ a꞉ma꞉la꞉yo꞉ o꞉semo꞉ dasi a꞉namio꞉, gililo꞉ ho꞉le ba꞉ba꞉ we malola꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","A꞉la꞉ta꞉ga꞉ enedo꞉ tili wida꞉sen kalu iliyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Elelo꞉ wida꞉sen kalu iliyo꞉ a꞉la꞉wida꞉sen, ‘Godeya꞉lo꞉ Da꞉feyo꞉ Kalu e semo꞉fa꞉la꞉dowo꞉ amio꞉, Elaiya e ko꞉le tamina mea꞉ib.’ Ililo꞉ a꞉la꞉do꞉ widab a꞉no꞉ mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Hendele, Elaiya e ko꞉le tamina ya꞉sa꞉ga꞉yo꞉, eyo꞉ kelego꞉wo꞉ tambo nafale dimidalia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko꞉sega niyo꞉ towo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Elaiya e o꞉ma mio꞉ ko꞉lo꞉lab, ko꞉sega kaluka꞉isale iliyo꞉ e mo꞉fanda asulo꞉. Iliyo꞉ inido꞉ asulab au kudu ha꞉nakiyo꞉, man ko꞉li ko꞉lilo꞉wo꞉ emo꞉ dimido꞉. Man o꞉leaumbo꞉, kalu nolba꞉yo꞉ Kalule Dowo꞉ nemo꞉wo꞉lo꞉ nagalo꞉wo꞉ a꞉la꞉ka dimia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ya꞉su eyo꞉ to a꞉no꞉ imo꞉wo꞉ sa꞉labikiyo꞉, iliyo꞉ a꞉no꞉ Yo꞉n ho꞉n amilo꞉ to꞉lolano꞉ ko꞉lo꞉ sa꞉labo꞉lo꞉b a꞉la꞉bo꞉ a꞉na fanda asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu otalen o꞉lia꞉yo꞉, kalu modo꞉lo꞉ kegenefo꞉labdo꞉ a꞉na fa꞉la꞉doma꞉ni ane ko꞉lo꞉, kalu nowo꞉ elo꞉wa ya꞉sa꞉ga꞉, gulalu misa꞉fu ali. ");
INSERT INTO bco_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Kalu a꞉ma꞉ sa꞉laki, “Alan, giyo꞉ ni so꞉wayo꞉ nofolaki asuwa꞉foma. E da꞉ba꞉da꞉sen ko꞉lo꞉, do꞉mo꞉ elo꞉wo꞉ mada mogago꞉le ko꞉lo꞉ a꞉lab. Ho꞉len modo꞉ amio꞉ e da꞉ba꞉dakiyo꞉, deya tina꞉liki, a꞉la꞉ta꞉ga꞉ ho꞉na tina꞉liki a꞉la꞉ga꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Niyo꞉ e tililia꞉ga꞉, gilo꞉ tili wida꞉sen ilo꞉ amio꞉ ane ko꞉sega, iliyo꞉ e ko꞉lo꞉ falele alifa꞉no꞉wo꞉ mo꞉ililo꞉.” ");
INSERT INTO bco_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ towo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale gio꞉ tilidabuwo꞉ aundo꞉ma iliki, togo꞉ hala kudu ha꞉na꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ ne gi o꞉lia꞉yo꞉ ho꞉len o꞉biba꞉s doma꞉no꞉wa꞉le? Ne gio꞉ asulo꞉wo꞉ nodoma꞉kiyo꞉ ho꞉len o꞉biba꞉s yasilima꞉no꞉wa꞉le? So꞉wa ko, nelo꞉ wena tililia꞉ mena.” ");
INSERT INTO bco_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ya꞉su eyo꞉ mama mogago꞉ o꞉mo꞉wo꞉ gadi sa꞉labikiyo꞉, mama mogago꞉ a꞉ma꞉yo꞉ so꞉wa a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nabiki, wigibole a꞉naka walaf elo꞉ a꞉no꞉ a꞉na falelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","A꞉ma꞉ fa꞉s amio꞉, kaluka꞉isale nolo꞉ mo꞉a꞉labiki, tili wida꞉sen kalu iyo꞉ Ya꞉sulo꞉wa ya꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Niliyo꞉ mama mogago꞉wo꞉ mo꞉ o꞉lusa꞉ma꞉no꞉ dowab we, mo꞉wo꞉ wangabiki gaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gili tili dabuwo꞉ mada ha꞉lula꞉sule ko꞉lo꞉, gi o꞉lia꞉yo꞉ mo꞉ililo꞉. Niyo꞉ to we hendele so꞉lo꞉l. Tilidabu gililo꞉wo꞉, kiwo꞉lo fo ha꞉lula꞉su o꞉ngo꞉ dowalega, giliyo꞉ misio꞉ wemo꞉ sa꞉lakiyo꞉, ‘Ge dasilia꞉ga꞉ honona hamana,’ a꞉la꞉sa꞉lalikiyo꞉, e o꞉li ka ha꞉na꞉ib. A꞉la꞉ta꞉ga꞉ nanog imilig gililo꞉ mo꞉dimidama꞉no꞉ dowo꞉ nowo꞉ aundo꞉ma.” ");
INSERT INTO bco_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ Ga꞉lili a꞉na kegeakiyo꞉, eyo꞉ imo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Kalule Dowo꞉ e, kalu noma꞉ teledowaki, gis kalumo꞉ dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Iliyo꞉ e sana sowalikiyo꞉, ho꞉len otaleno꞉ dota꞉ga꞉, e a꞉ma꞉la꞉ dasi alifa꞉ib.” Tili wida꞉sen kalu iyo꞉ to a꞉no꞉ da꞉dakiyo꞉, ili asulo꞉wo꞉ mada alan hida꞉li. ");
INSERT INTO bco_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","A꞉ma꞉ fa꞉s amio꞉, Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ Kabaniom a꞉na fa꞉la꞉doma꞉ni ane. Godeya꞉ ayamilo꞉ takis molelo꞉ kegea꞉sen kalu iyo꞉ Bida elo꞉wa ya꞉sa꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu gililo꞉ma꞉yo꞉ Godeya꞉ a o꞉mo꞉lo꞉ takis mole dimia꞉no꞉wo꞉ to꞉lola꞉sena꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A꞉la꞉sa꞉labiki Bida eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “A꞉” a꞉la꞉sio꞉. A꞉la꞉ta꞉ga꞉ Bida e a usa a꞉ma꞉la꞉ ti ha꞉na꞉ga꞉yo꞉, to nowo꞉ eyo꞉ o꞉semo꞉ sio꞉ a꞉labikiyo꞉, Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Saimon giyo꞉ waga asulaya? Misa꞉ kalu henfelo꞉ wilo꞉ a꞉ma꞉yo꞉, takis mole a꞉no꞉ o꞉ba a꞉la꞉ta꞉ga꞉ diaba꞉le? Iliyo꞉ ini so꞉waya a꞉la꞉ta꞉ga꞉ diaba꞉le, o꞉ kaluka꞉isale nola a꞉la꞉ta꞉ga꞉ dia꞉laba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Bida eyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Kaluka꞉isale nola a꞉la꞉ta꞉ga꞉ dia꞉sen.” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ Bida emo꞉wo꞉ a꞉la꞉sio꞉, “A꞉la꞉fo꞉ko꞉lo꞉ misa꞉ kaluwa꞉ so꞉wa inido꞉ma꞉yo꞉ takis moleyo꞉ mo꞉to꞉lolaki, ga꞉li sab. ");
INSERT INTO bco_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","O꞉leo꞉ngo꞉ ko꞉lo꞉, Godeya꞉ ayamilo꞉ takis mole kililia꞉no꞉wo꞉ nio꞉lo꞉ ga꞉li so꞉l. Ko꞉sega molelo꞉ kegenela꞉sen kalu iyo꞉ mo꞉gadima꞉kiyo꞉, ge ho꞉n golo꞉ holona ha꞉na꞉sa꞉ga꞉, gimiyo꞉ a꞉na to꞉lola꞉sa꞉ga꞉yo꞉, gilo꞉ ka꞉ tamin amilo꞉ silab a꞉no꞉, giyo꞉ dia꞉sa꞉ga꞉ mego꞉fo꞉ tagalalikiyo꞉, mole us nowo꞉ a꞉na delena ba꞉ba꞉ib. Giyo꞉ takis mole naindo꞉ to꞉loma꞉no꞉ ililo꞉ o꞉leaumbo꞉, mole a꞉no꞉ ko꞉lo꞉ dia꞉sa꞉ga꞉ imo꞉ dimia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ho꞉len a꞉namio꞉ tili wida꞉sen kalu iyo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉namilo꞉, wi alando꞉ a꞉labo꞉ o꞉ba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","A꞉la꞉dabu ba꞉dabiki Ya꞉su eyo꞉ so꞉wala꞉su nowo꞉ mena꞉ki ho꞉ida꞉sa꞉ga꞉yo꞉, ili milifa kagama꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉, “Niyo꞉ to we hendele gimo꞉ so꞉lo꞉l. Gio꞉ asulo꞉wo꞉ nodola꞉sa꞉ga꞉yo꞉, so꞉wala꞉su o꞉ngo꞉wo꞉ ko꞉lo꞉ mo꞉fa꞉la꞉dowalega, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉namio꞉ mada mo꞉tina꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Kaluka꞉isale abeyo꞉ enena꞉ma꞉la꞉yo꞉ ha꞉ga dowaki, so꞉wala꞉su wengo꞉ dowab a꞉no꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉namio꞉ e wi alan doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Kaluka꞉isale abeyo꞉, so꞉wala꞉su wilo꞉ma we o꞉ngo꞉ dowab a꞉no꞉ ko꞉lo꞉ ni wiya a꞉la꞉ta꞉ga꞉ tilidowalega, eyo꞉ ne ko꞉lo꞉ tili dowan a꞉ngab. ");
INSERT INTO bco_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ko꞉sega kaluka꞉isale abeyo꞉ so꞉wagalin we o꞉ngo꞉ma꞉ tili dabuwo꞉ sulufo꞉ timana꞉kilo꞉ dimidalega, Gode eyo꞉ emo꞉wo꞉ wa꞉deakiyo꞉ hida꞉yo꞉ alande dimia꞉ib. Giliyo꞉ u alano꞉ kalu a꞉ma꞉ dagasa sunda꞉sa꞉ga꞉ kanda soma꞉ki, so꞉lu ho꞉na sanditai kibo꞉bowo꞉, falasilakilo꞉ wa꞉deab a꞉no꞉ ha꞉lu domabe. ");
INSERT INTO bco_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Wai, kaluka꞉isaleya꞉ tilidabuwo꞉ sulufo꞉ ti hamana꞉kilo꞉ susuda꞉lab man a꞉ma꞉yo꞉ henfelo꞉ we tambowo꞉ mogagila꞉lab. Kaluka꞉isaleya꞉ tilidabuwo꞉ sulufo꞉ timana꞉kilo꞉ susuda꞉mela꞉no꞉ man ko꞉li ko꞉lilo꞉ a꞉no꞉ hendele mada fa꞉la꞉doma꞉ib. Ko꞉sega kalu abeyo꞉ noma꞉ tilidabuwo꞉ sulufo꞉ timana꞉kilo꞉ susuda꞉lab o꞉mo꞉wo꞉ hida꞉yo꞉wo꞉ alan dimiaki wa꞉dema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","A꞉la꞉fo꞉ko꞉lo꞉ gi dagiya꞉le, giba꞉ya꞉le ge susululia꞉ga꞉ mogago꞉ dimidama꞉no꞉ dowalega, giyo꞉ a꞉no꞉ gedea꞉sa꞉ga꞉ sandita꞉bi. Mo꞉wo꞉ giyo꞉ dagi o꞉lia꞉ gibo꞉ o꞉lia꞉yo꞉ mulun siliki, ko꞉ngo꞉ mela꞉no꞉ mela꞉no꞉lalega, a꞉no꞉ o꞉li. Ko꞉sega ge dagi a꞉la꞉ a꞉la꞉ta꞉ga꞉ gib a꞉la꞉ elena, de mela꞉no꞉ mela꞉no꞉lo꞉ a꞉lab a꞉na sanditalega, a꞉no꞉ mada halaido꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","A꞉la꞉ta꞉ga꞉ si gilo꞉ma꞉yo꞉ ge susululia꞉ga꞉ mogago꞉ dimidama꞉no꞉ dowalega, giyo꞉ si a꞉no꞉ dugulia꞉ga꞉ sandita꞉bi. Mo꞉wo꞉ giyo꞉ si imilise iliki, ko꞉ngo꞉ mela꞉no꞉ mela꞉no꞉lalega, a꞉no꞉ o꞉li. Ko꞉sega ge siyo꞉ a꞉la꞉ elena, de hen a꞉na sanditalega, a꞉no꞉ mada halaido꞉ doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Giliyo꞉ so꞉wagalin wengo꞉wo꞉ o꞉ngo꞉malo꞉ngo꞉ a꞉la꞉bo꞉ asula꞉so꞉bo. Niyo꞉ gimo꞉ so꞉lo꞉l. Hebene a꞉namio꞉ so꞉wagalina꞉ ene ma꞉mula꞉ kaluwo꞉ ho꞉len tambo gio꞉ bo꞉fo꞉likiyo꞉, Do Godeya꞉ ene wo꞉lokana dowa꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Giliyo꞉ waga asulaya? Kalu noma꞉yo꞉ sibiyo꞉ do꞉la꞉lowo꞉wo꞉ do꞉la꞉fo꞉ elen ko꞉lo꞉, sibi imilig nowo꞉ kelege dowalega, kalu a꞉ma꞉yo꞉ mo꞉kelema꞉iba꞉le? A꞉la꞉ba, eyo꞉ sibi do꞉la꞉lowo꞉ agado꞉ a꞉la꞉ta꞉ga꞉ agado꞉la꞉fo꞉ nolo꞉ hen misio꞉ a꞉naka melea꞉ki ta꞉takiyo꞉, sibi imilig kelege dowo꞉ a꞉no꞉ mada kelema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Niyo꞉ to we hendele gimo꞉ so꞉lo꞉l. Eyo꞉ sibi a꞉no꞉ a꞉ba꞉dalega, e sagalo꞉wo꞉ mada alan doma꞉ib. Eyo꞉ sibi do꞉la꞉lowo꞉ agado꞉ a꞉la꞉ta꞉ga꞉ agado꞉la꞉fo꞉ nol o꞉mo꞉wo꞉ sagalema꞉ib. Ko꞉sega sibi kelege dowo꞉ ko꞉lo꞉ a꞉ma꞉la꞉do꞉ a꞉ba꞉ba꞉ o꞉mo꞉wo꞉ mada sagalo꞉wo꞉ alan doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","A꞉la꞉do꞉ go꞉ aumbo꞉, Do Gode Hebenelo꞉ a꞉lab eyo꞉ so꞉wagalin i we nowo꞉ mada mo꞉sulufoma꞉ki asulab.” ");
INSERT INTO bco_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉, “Tilidabu kaluka꞉isale nolba꞉yo꞉ mogago꞉wo꞉ gemo꞉ dimidalega, giyo꞉ e ba꞉ba꞉ni ha꞉na꞉sa꞉ga꞉ gainsele iliki, elo꞉ hala dimido꞉ a꞉no꞉ enebo꞉ wida꞉bi. Eyo꞉ ko꞉lo꞉ gi towo꞉ da꞉dalega, ge o꞉lia꞉ gao a꞉no꞉lia꞉yo꞉ wa꞉kabiyo꞉ ha꞉fo꞉ disa꞉laki ege doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ko꞉sega eyo꞉ gi towo꞉ mo꞉da꞉dalega, giyo꞉ kaluka꞉isale imiliga꞉le, a꞉la꞉ya꞉le ge o꞉lia꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉, elo꞉ hala dimido꞉ gilo꞉ sa꞉lab a꞉no꞉, iliyo꞉ hendele sa꞉lab a꞉la꞉sama꞉kiyo꞉, iyo꞉ gi tililia꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ko꞉sega eyo꞉ ko꞉lo꞉ to ililo꞉wo꞉ mo꞉da꞉ba꞉no꞉ dowalega, giyo꞉ tilidabu kaluka꞉isale kegeo꞉ us a꞉namio꞉ imo꞉ sa꞉la꞉bi. A꞉la꞉go꞉ ka, eyo꞉ tilidabu kaluka꞉isale ili towo꞉ mada mo꞉da꞉ba꞉no꞉ dowalega, giliyo꞉ e ha꞉la꞉ya ta꞉takiyo꞉, ha꞉la꞉ kalu o꞉lia꞉ takis molelo꞉ dia꞉sen kalu o꞉lia꞉mo꞉lo꞉ ga꞉sen o꞉leauka, emo꞉wo꞉lo꞉ a꞉la꞉dimida꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Niyo꞉ to we gimo꞉wo꞉ hendele so꞉lo꞉l. Henfelo꞉ wenamilo꞉ gililo꞉ kalitab a꞉no꞉, Gode Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ o꞉ma a꞉la꞉ka kalifa꞉ ko꞉lo꞉lab. A꞉la꞉ta꞉ga꞉ henfelo꞉ wenamilo꞉ gililo꞉ kolaetab a꞉no꞉, Gode Hebenelo꞉ a꞉lab a꞉ma꞉yo꞉ o꞉ma a꞉la꞉ka kolaefa꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Niyo꞉ towo꞉ gimo꞉wo꞉ wa꞉ka sa꞉ma꞉nigo꞉l. Henfelo꞉ wenamio꞉ kaluka꞉isale a꞉la꞉ nowo꞉, asulo꞉wo꞉ imilise dowa꞉sa꞉ga꞉ Godemo꞉ asuwa꞉foma꞉ki dabu ba꞉dalega, a꞉la꞉ma꞉lo꞉ dabu ba꞉dab a꞉no꞉ Do Hebenelo꞉ a꞉lab eyo꞉ dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mo꞉wo꞉ kaluka꞉isale a꞉la꞉ya꞉le, otalena꞉le ne wiya a꞉la꞉ta꞉ga꞉ kegenema꞉ni yalega, no꞉no꞉n ne i o꞉lia꞉ usami doma꞉no꞉.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ho꞉len o꞉g a꞉namio꞉ Bidayo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Alan, ni naowa꞉yo꞉ mogago꞉wo꞉ nemo꞉ dimidafo꞉ko꞉ ha꞉na꞉lalega, niyo꞉ elo꞉ hala dimido꞉ a꞉no꞉ ho꞉leno꞉ o꞉biba꞉s ga꞉lila꞉ma꞉no꞉wa꞉le? Dom a꞉la꞉fo꞉ ga꞉lilalega, a꞉no꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Dom a꞉la꞉fo꞉wo꞉ mo꞉ililo꞉ ko꞉lo꞉lab. Ko꞉sega gio꞉ ga꞉lilakiyo꞉, ho꞉leno꞉ do꞉la꞉lowo꞉wo꞉ dom a꞉la꞉ta꞉ga꞉ dom a꞉la꞉fo꞉ a꞉no꞉ ga꞉lila꞉sa꞉ga꞉yo꞉, a꞉la꞉bo꞉ wa꞉ka wa꞉ka a꞉ga꞉lilalega, a꞉no꞉ nafa doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Dabuma, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉, we o꞉ngo꞉ dowab ko꞉lo꞉ bale sa꞉ma꞉nigo꞉l. Misa꞉ kalu nowo꞉ elen ko꞉lo꞉, eyo꞉ ene nanog dian kalu i o꞉lia꞉yo꞉ mewa꞉lo꞉ dinafama꞉no꞉ asulab. ");
INSERT INTO bco_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eyo꞉ mewa꞉l a꞉no꞉ mo꞉mo꞉da digala꞉len amio꞉, nanog dian kalu nowo꞉ elo꞉wa tililia꞉ga꞉ mio꞉ ko꞉lo꞉, kalu a꞉ma꞉yo꞉ misa꞉ kalumo꞉wo꞉ mewa꞉lo꞉ alan badio꞉, mo꞉agelema꞉no꞉ dowo꞉ ko꞉lo꞉ delen. ");
INSERT INTO bco_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nanog dian kalu a꞉ma꞉yo꞉ mewa꞉l dugu mea꞉no꞉wo꞉ moleyo꞉ aundo꞉ma dowo꞉ ko꞉lo꞉, misa꞉ kalu a꞉ma꞉yo꞉ mewa꞉lo꞉ dugu mea꞉nikiyo꞉, kalu a꞉no꞉, ingayo꞉, ene so꞉wagalin a꞉no꞉ tambo, kalu noma꞉ ene madali nanog dian kalu doma꞉ki, moleya꞉ kililia꞉bi a꞉la꞉sio꞉. A꞉la꞉ta꞉ga꞉ ene kelego꞉ tambo a꞉no꞉lo꞉ kililia꞉bi a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nanogdo꞉ dian kalu eyo꞉, misa꞉ kaluwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, e misa꞉ kalu a꞉ma꞉ gido꞉fo꞉ aniba gulalu misa꞉fu alilaki, emo꞉wo꞉ ha꞉nolo sa꞉laki a꞉la꞉sio꞉, ‘Niyo꞉ ge digalema꞉no꞉ ko꞉lo꞉ giyo꞉ ne mada o꞉yasilima. Niyo꞉ mewa꞉l gilo꞉ ko꞉lo꞉ di a꞉no꞉, tambo a꞉ma꞉la꞉ go꞉no꞉nbo꞉ dugu mea꞉no꞉,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","A꞉la꞉sa꞉labiki misa꞉ kalu eyo꞉ ene nanog dian kalu a꞉no꞉ mada nofola꞉sa꞉ga꞉, e ga꞉li mesea꞉ki ka ta꞉takiyo꞉, mewa꞉l elo꞉ a꞉no꞉lo꞉ tambo ga꞉lila꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","A꞉la꞉gabiki nanogdo꞉ dian kalu a꞉no꞉ ha꞉la꞉ya ha꞉nakiyo꞉, nanogo꞉ ida꞉nido꞉ dia꞉sen kalu nowo꞉ a꞉na ba꞉ba꞉. Kalu no a꞉ma꞉yo꞉ mewa꞉l ha꞉lu emo꞉lo꞉ dugu mea꞉no꞉ nowo꞉ delen ko꞉lo꞉, eyo꞉ nanogo꞉ ida꞉nido꞉ dia꞉sen a꞉no꞉ dagasa halale ta꞉lia꞉sa꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉sio꞉, ‘Gilo꞉ mewa꞉l nilo꞉ ko꞉lo꞉ gilo꞉ di a꞉no꞉, tambo a꞉ma꞉la꞉ dugu mena,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Nanogo꞉ ida꞉nido꞉ dia꞉sen a꞉ma꞉yo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, e gulalu misa꞉fu alilakiyo꞉ emo꞉wo꞉ ha꞉nolo sa꞉laki a꞉la꞉sio꞉, ‘Giyo꞉ ne mada nofolaki o꞉yasilima. Niyo꞉ mewa꞉l gilo꞉ ko꞉lo꞉ di a꞉no꞉ tambo, a꞉ma꞉la꞉ go꞉no꞉nbo꞉ dugu mea꞉no꞉,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ko꞉sega kalu a꞉ma꞉yo꞉ a꞉la꞉ dimidama꞉no꞉wo꞉ mo꞉beakiyo꞉, nanogo꞉ ida꞉nido꞉ dia꞉sen kalu a꞉no꞉ mewa꞉lo꞉ semo꞉dugu me amio꞉, e dibolo a a꞉naka o꞉mesea꞉ki to꞉lo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“E o꞉lia꞉lo꞉ nanogdo꞉ dian kalu nolo꞉, kalu a꞉ma꞉lo꞉ man dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ emo꞉wo꞉ mada kele asulo꞉ ko꞉lo꞉, iyo꞉ ha꞉na꞉sa꞉ga꞉yo꞉, nanogdo꞉ dian kalu a꞉ma꞉ man dimido꞉wo꞉ tambo ini misa꞉ kalumo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","A꞉la꞉go꞉ko꞉lo꞉ ene misa꞉ kalu eyo꞉ nanogdo꞉ dian kalu a꞉no꞉ ho꞉ida꞉sa꞉ga꞉yo꞉, emo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, ‘Ge nanog dian kalu mogago꞉. Tamin amio꞉ giyo꞉ nemo꞉ ha꞉nolalikiyo꞉, niyo꞉ mewa꞉l gilo꞉ a꞉no꞉ tambo ga꞉lilaki ka ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nilo꞉ gemo꞉lo꞉ mada nofolakilo꞉ ta꞉fo꞉ o꞉leaumbo꞉, giyo꞉ nanogo꞉ gaindo꞉ dia꞉sen kalu emo꞉wo꞉lo꞉ nofoloma꞉no꞉ dowo꞉ ko꞉sega, a꞉la꞉bo꞉ mo꞉dimido꞉lo꞉b.’ ");
INSERT INTO bco_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ misa꞉ kalu e kulufa꞉yakiyo꞉, nolba꞉yo꞉ kalu a꞉no꞉ falasilaki yame tandema꞉ki, dibolo aya tolo꞉ alifa꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ mewa꞉lo꞉ semo꞉dugu mealikiyo꞉, e a꞉naka o꞉mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","A꞉la꞉go꞉ko꞉lo꞉ ni Do Hebenelo꞉ a꞉lab haloma꞉yo꞉, gaowa꞉lo꞉ mogago꞉ gemo꞉lo꞉ dimido꞉ a꞉no꞉, giyo꞉ hendele mo꞉ga꞉lilalikiyo꞉, eyo꞉lo꞉ gemo꞉wo꞉ mano꞉ o꞉leo꞉ngo꞉ ka dimidama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Ya꞉su eyo꞉ to a꞉no꞉ sa꞉la꞉sa꞉ga꞉ eletakiyo꞉, Ga꞉lili heno꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, e ho꞉n Yodano꞉ ta꞉nota꞉ga꞉, hen nodo a꞉namida꞉ ha꞉na꞉ga꞉, Yudia hen a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","A꞉na sia꞉lab amio꞉ kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ e kudu mio꞉. Eyo꞉ walaf i amilo꞉ elen a꞉no꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fa꞉lisi kalu iyo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, e dikili ba꞉daki a꞉la꞉dabu ba꞉ba꞉, “Kaluwa꞉yo꞉ ene ga di a꞉no꞉ ta꞉fa꞉no꞉ asulalega, nili man amio꞉ a꞉no꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ towo꞉ a꞉la꞉sio꞉, “Godeya꞉ bugo꞉ amilo꞉ to ko꞉lo꞉ sa꞉sa꞉lo꞉ a꞉no꞉, gio꞉ mo꞉agelo꞉wa꞉le? To a꞉namio꞉ a꞉la꞉sa꞉sa꞉lo꞉, ‘Taminde amio꞉ Gode eyo꞉ kaluka꞉isale ho꞉gi dimidakiyo꞉, kalu o꞉lia꞉ ga o꞉lia꞉ fa꞉la꞉doma꞉ki ta꞉fo꞉.’ ");
INSERT INTO bco_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A꞉la꞉ta꞉ga꞉ Gode eyo꞉ towo꞉ a꞉la꞉sio꞉, ‘A꞉la꞉go꞉ko꞉lo꞉ kaluwa꞉yo꞉ iya o꞉lia꞉ ano o꞉lia꞉yo꞉ ta꞉ta꞉ga꞉, ene inga o꞉lia꞉ asulo꞉wo꞉ imilise dowaki, a꞉la꞉yo꞉ do꞉mo꞉ imilise doma꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tamin amilo꞉ do꞉mo꞉ a꞉la꞉ elen a꞉no꞉ ta꞉ta꞉ga꞉, o꞉go꞉ a꞉la꞉yo꞉ do꞉mo꞉ imilise fa꞉la꞉dowab. A꞉la꞉fo꞉ko꞉lo꞉ Godeya꞉lo꞉ a꞉la꞉ ida꞉nido꞉ kudu alifa꞉ a꞉no꞉ kaluwa꞉yo꞉ mada gedea꞉so꞉bo!” ");
INSERT INTO bco_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Fa꞉lisi kalu iliyo꞉ Ya꞉su emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “A꞉la꞉go꞉ko꞉lo꞉ Mo꞉sa꞉sa꞉ ele nimo꞉lo꞉ dimi a꞉na sa꞉lakiyo꞉, ‘Kalu eyo꞉ ga dio꞉ ta꞉fa꞉nikiyo꞉, mo꞉fo꞉so꞉ sa꞉sa꞉la꞉sa꞉ga꞉ gamo꞉ dimiaki, e dugulakiyo꞉ o꞉li iliga꞉tab’ a꞉la꞉do꞉ sa꞉sa꞉lo꞉ a꞉no꞉ mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Gio꞉ a꞉la꞉iyabiki, Mo꞉sa꞉s eyo꞉ gio꞉ gayo꞉ ta꞉fa꞉no꞉wo꞉ o꞉lika꞉ a꞉la꞉bo꞉ a꞉na saefa꞉. Ko꞉sega taminde amio꞉ man wengo꞉wo꞉ mada aundo꞉ma elen. ");
INSERT INTO bco_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Niyo꞉ towo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Kalu abeyo꞉ ingayo꞉ uwo꞉ mano꞉ mo꞉dimido꞉ ko꞉sega, kalu a꞉ma꞉yo꞉ ga a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, ga ko꞉li nowo꞉ ko꞉lo꞉ dialega, kalu a꞉ma꞉ eneno꞉ uwo꞉ man dimidakigab.” ");
INSERT INTO bco_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tili wida꞉sen kalu iliyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉. “Kaluwo꞉ gayo꞉ dia꞉sa꞉ga꞉lo꞉ dowan man o꞉leo꞉ngo꞉ dowalega, niliyo꞉ ga dia꞉no꞉wo꞉ ka ta꞉fa꞉niki.” ");
INSERT INTO bco_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “To gilo꞉ dimidama꞉no꞉ sa꞉lab a꞉no꞉, kalu nolba꞉yo꞉ kudu ha꞉na꞉no꞉wo꞉ mo꞉dimidama꞉no꞉ dowab. Ko꞉sega man a꞉no꞉ ko꞉lo꞉ kudu ha꞉na꞉no꞉wo꞉, Gode eyo꞉ kalu nolbo꞉wo꞉ halaido꞉wo꞉ dimi ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Kalu sa꞉le gayo꞉ mo꞉diab a꞉no꞉, i amio꞉ mo꞉wo꞉ ko꞉li ko꞉lilo꞉ da꞉lab. Kalu nolo꞉ ho꞉len anowa꞉ ilo꞉ sa꞉la꞉liab amio꞉, do꞉mo꞉wo꞉ mogago꞉ ko꞉lo꞉ iyo꞉ gayo꞉ mo꞉dia꞉no꞉ dowab. A꞉la꞉ta꞉ga꞉ kalu nolo꞉ kalu noma꞉yo꞉ i towo꞉ dugu ko꞉lo꞉, iyo꞉ gayo꞉ mo꞉dian. A꞉la꞉ta꞉ga꞉ kalu nolo꞉ Godeya꞉ ene nanogde a꞉no꞉leko꞉ dia꞉no꞉ asulakiyo꞉, iyo꞉ gayo꞉ mo꞉diaki kata꞉fo꞉. Kalu abeyo꞉ to we o꞉li kudu ha꞉naki, dia꞉no꞉ dowalega, e o꞉li dia꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ho꞉len a꞉namio꞉ kaluka꞉isale iliyo꞉ Ya꞉suwa꞉ ene dagiyo꞉ ili so꞉wagalino꞉ golofo꞉liki dulugu sama꞉ki, so꞉wagalin a꞉no꞉ elo꞉wa tililia꞉ga꞉ ya꞉sio꞉. Tili wida꞉sen kalu iliyo꞉ kaluka꞉isale imo꞉wo꞉ gadi sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ko꞉sega Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Giliyo꞉ so꞉wagalin ko, nelo꞉wa mena꞉ki ta꞉foma. Giliyo꞉ iyo꞉ mada ka꞉la꞉so꞉bo. Mo꞉wo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉, kaluka꞉isaleyo꞉ so꞉wagalin we o꞉ngo꞉ dowab a꞉ma꞉no꞉ ko꞉lo꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Ya꞉suwa꞉ ene dagiyo꞉ so꞉wagalina gola꞉sa꞉ga꞉yo꞉, i a꞉no꞉ ta꞉ta꞉ga꞉ e ane. ");
INSERT INTO bco_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kalu nowo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu, nilo꞉ mela꞉no꞉ mela꞉no꞉ dia꞉no꞉ a꞉no꞉, man nafayo꞉ o꞉bo꞉ngo꞉ dimidali dia꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Giyo꞉ ‘man nafaleyo꞉ o꞉ba꞉le’ a꞉la꞉do꞉ dabu ba꞉ba꞉ ko nemo꞉wo꞉ wangabiki dabu ba꞉daya? Nafale a꞉labo꞉, imilise ko꞉lo꞉lab. Ko꞉sega ge mela꞉no꞉ mela꞉no꞉ a꞉no꞉ dia꞉no꞉ asulalega, ge Godeya꞉ eleyo꞉ mada kudu ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","A꞉la꞉sa꞉labiki kalu a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gilo꞉ eleka꞉ a꞉la꞉do꞉ sa꞉lab ko ho꞉bo꞉ko꞉ma꞉le?” Ya꞉suwa꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Kaluwo꞉ sana sowa꞉so꞉bo. Uwo꞉wo꞉ dia꞉so꞉bo. Afayo꞉ dia꞉so꞉bo. Diga꞉li sa꞉la꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Gio꞉ go꞉lo꞉ go꞉wo꞉ alano꞉ o꞉m a꞉la꞉asulaki, ili ha꞉ga dowa꞉lubi. A꞉la꞉ta꞉ga꞉ gio꞉ go꞉no꞉n asulan o꞉leaumbo꞉, giasi kaluka꞉isale nolo꞉lo꞉ a꞉la꞉asulaki ha꞉fo꞉wo꞉ disa꞉la꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kalu a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ ele we tambo kudu ha꞉na꞉sen ko꞉lo꞉, nilo꞉ man o꞉dimidama꞉no꞉wo꞉ o꞉bo꞉mo꞉lo꞉bo꞉?” ");
INSERT INTO bco_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge ko꞉lo꞉ mada ego꞉le doma꞉no꞉ asulalega, ge ha꞉na꞉sa꞉ga꞉ kelego꞉ go꞉no꞉ndo꞉wo꞉ tambo kililia꞉sa꞉ga꞉, mole a꞉namilo꞉ diab a꞉no꞉, giyo꞉ mada wa꞉feyo꞉ kalumo꞉ dimea꞉bi. Giyo꞉ ko꞉lo꞉ a꞉la꞉dimidalikiyo꞉, kelego꞉ nafale gilo꞉wo꞉ Hebene a꞉namio꞉ doma꞉ib. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ ge ne a꞉na kudu mena.” ");
INSERT INTO bco_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kalu a꞉ma꞉yo꞉ kelego꞉wo꞉ modo꞉ delen ko꞉lo꞉, to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, asulo꞉ elo꞉wo꞉ hida꞉liabiki ane. ");
INSERT INTO bco_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","A꞉la꞉ta꞉ga꞉ Ya꞉suwa꞉ enedo꞉ tili wida꞉sen kalu imo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Niyo꞉ to we hendele gimo꞉ sa꞉ma꞉nigo꞉l. Kalu kelego꞉wo꞉ modo꞉lo꞉ da꞉lab a꞉no꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉na tina꞉no꞉wo꞉, mada halaido꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Niyo꞉ to we wa꞉ka gimo꞉wo꞉ a꞉so꞉lo꞉l. No꞉ alan nowo꞉ ene wiyo꞉ ka꞉mol ko꞉lo꞉, e helebeso꞉gdo꞉ dubian ho꞉la꞉su a꞉namio꞉ o꞉lika tina꞉iba꞉le? A꞉la꞉do꞉ mo꞉tinan aumbo꞉, kalu kelego꞉wo꞉ modo꞉lo꞉ da꞉lab a꞉no꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉na tina꞉no꞉wo꞉, mada halaido꞉le doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tili wida꞉sen kalu iyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉ iligaki molo asulo꞉ ko꞉lo꞉, iliyo꞉ towo꞉ a꞉la꞉sio꞉, “O꞉leo꞉ngo꞉lalega, mela꞉no꞉ mela꞉no꞉ a꞉no꞉ abe dia꞉iba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ko꞉sega Ya꞉su eyo꞉ iyo꞉ tigini ba꞉da꞉sa꞉ga꞉yo꞉ towo꞉ a꞉la꞉sio꞉, “Kaluwa꞉yo꞉ mada mo꞉ililo꞉. Ko꞉sega Gode eyo꞉ kelego꞉ tambowo꞉ o꞉li dimida꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ya꞉su eyo꞉ towo꞉ a꞉la꞉sa꞉labikiyo꞉, Bida eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Asuluma! Nio꞉ kelego꞉wo꞉ tambo ta꞉ta꞉sa꞉ga꞉, ge ko꞉lo꞉ kudu yo꞉l. A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉ kelego꞉wo꞉ o꞉b dia꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ya꞉su eyo꞉ towo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ to we gimo꞉wo꞉ hendele so꞉lo꞉l. Henfelo꞉ we tambo ho꞉gile fa꞉la꞉dowalikiyo꞉, Kalule Dowo꞉ e wi alano꞉ dia꞉sa꞉ga꞉, halaido꞉ alan enedo꞉ma꞉lo꞉ bo꞉fo꞉lab a꞉namio꞉, kalu nelo꞉ kudu ya꞉len gio꞉lo꞉ bo꞉fo꞉mela꞉no꞉ halaido꞉wo꞉ dia꞉sa꞉ga꞉, Isolael so꞉lo꞉ kugula꞉fo꞉ a꞉no꞉, mada gili bo꞉fo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kaluka꞉isale abeyo꞉ ni wiya doma꞉no꞉ asulalikiyo꞉, ene ayo꞉, aowo꞉, adowo꞉, iyayo꞉, anowo꞉, so꞉wagalino꞉, a꞉la꞉ta꞉ga꞉ ene heno꞉ ka ta꞉ta꞉ga꞉lo꞉ ha꞉nab i a꞉ma꞉yo꞉, mewa꞉lo꞉ do꞉la꞉lowo꞉wo꞉ do꞉la꞉fo꞉ ko꞉lo꞉ dia꞉ib. A꞉la꞉ta꞉ga꞉ iyo꞉ mela꞉no꞉ mela꞉no꞉ nafa a꞉no꞉ mada dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ko꞉sega kaluka꞉isale nol o꞉gdo꞉ tamin amilo꞉ a꞉lab a꞉no꞉, tifa doma꞉ib. A꞉la꞉ta꞉ga꞉ kalu nol o꞉gdo꞉ tifamilo꞉ a꞉lab a꞉no꞉, iyo꞉ tamina mada doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ya꞉su eyo꞉ to heb a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Niyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ widakiyo꞉, bale sio꞉ we ko꞉lo꞉ sa꞉ma꞉nigo꞉l. Hendo꞉ biso꞉ kalu imilig noma꞉yo꞉ kea꞉fole ha꞉na꞉sa꞉ga꞉yo꞉, nanog dia꞉no꞉ kaluwo꞉ ene wain egelo꞉ a꞉na dima꞉ki kelema꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nanogdo꞉ dia꞉no꞉ kaluwo꞉ ba꞉da꞉sa꞉ga꞉, i kililia꞉no꞉wo꞉ silba mole imilise a꞉ma꞉ kililia꞉no꞉ a꞉la꞉bo꞉ i o꞉lia꞉ saeta꞉sa꞉ga꞉yo꞉, iyo꞉ ene egelo꞉wa nanog dima꞉ki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ofa꞉siyo꞉ agado꞉wa dowabiki, hendo꞉ biso꞉ kalu e ma꞉no꞉lo꞉ kililia꞉sen hen a꞉na ha꞉na꞉sa꞉ga꞉yo꞉, kalu nolo꞉ ba madali kagafo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, ‘Gio꞉lo꞉ ha꞉na꞉sa꞉ga꞉, nanogo꞉ ni wain egelo꞉ a꞉na dialikiyo꞉, niyo꞉ nanog gililo꞉ di a꞉no꞉ digale kililia꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","A꞉la꞉fo꞉ko꞉lo꞉ kalu iyo꞉lo꞉ nanog dia꞉ni ane. Ofa꞉siyo꞉ disi dowabiki, hendo꞉ biso꞉ kaluwo꞉ ma꞉no꞉lo꞉ kililia꞉sen hen a꞉na ha꞉na꞉sa꞉ga꞉yo꞉, eyo꞉ tamin amilo꞉ dimida꞉sen o꞉leau wa꞉ka dimido꞉. A꞉la꞉ta꞉ga꞉ ofa꞉siyo꞉ asola dowabikiyo꞉lo꞉, eyo꞉ wa꞉ka a꞉la꞉ka dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ga꞉lo ofa꞉siyo꞉ biya dowabiki, e ha꞉nakiyo꞉, kalu nolo꞉ madali kagafo꞉lena ba꞉ba꞉ ko꞉lo꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, ‘Gio꞉ o꞉g ho꞉len wenamio꞉ madali wilo꞉ kagafo꞉leyo꞉ mo꞉wo꞉ ha꞉?’ ");
INSERT INTO bco_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Iliyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, ‘Kalu imilig noma꞉yo꞉ nanogo꞉ nimo꞉wo꞉ mo꞉dimi.’ A꞉la꞉sa꞉labiki biso꞉ kaluwa꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, ‘Gio꞉lo꞉ ni wain egelo꞉wa dia꞉ni hamana,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ga꞉lo dowabikiyo꞉, hendo꞉ biso꞉ kalu a꞉ma꞉yo꞉, ene nanog diabdo꞉ bo꞉fo꞉lowan kalu emo꞉ sa꞉lakiyo꞉, ‘Giyo꞉ nanogdo꞉ dian kaluwo꞉ tambo ho꞉ida꞉sa꞉ga꞉, moleyo꞉ inibo꞉ dimina. Giyo꞉ tifamilo꞉ mio꞉ a꞉na mo꞉mo꞉da kililia꞉i ya꞉la꞉ga꞉, ami tamin amilo꞉ mio꞉ i a꞉no꞉ edaki kililia꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","A꞉la꞉go꞉ko꞉lo꞉ kalu ofa꞉siyo꞉ bi amilo꞉ mo꞉mo꞉do꞉ iyo꞉, silba moleyo꞉ imilig, imilig, a꞉la꞉ di. ");
INSERT INTO bco_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Kililia꞉i ya꞉la꞉ga꞉yo꞉, tamin amilo꞉ nanogdo꞉ mo꞉mo꞉do꞉ kalu iyo꞉ tifa yakiyo꞉, iliyo꞉ moleyo꞉ modo꞉ ko꞉lo꞉ dia꞉nigo꞉l a꞉la꞉asulo꞉. Ko꞉sega a꞉la꞉ba, iliyo꞉lo꞉ silba mole imilig, imilig a꞉la꞉ka dia꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Iliyo꞉ mole enedo꞉ di a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, hendo꞉ biso꞉mo꞉wo꞉ mo꞉beakiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nio꞉ kea꞉fole a꞉la꞉ta꞉ga꞉ nanogo꞉ dia꞉i mio꞉ a꞉namio꞉, ofa꞉yo꞉ nio꞉ halaido꞉ sa꞉ndaki, odo꞉ ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ kalu tif amilo꞉ mio꞉ i a꞉no꞉, nanogo꞉ ofa꞉si imilise ami di ko꞉sega giyo꞉ nimo꞉lo꞉ kilili o꞉leau, imo꞉wo꞉lo꞉ a꞉la꞉ka kilili.’ ");
INSERT INTO bco_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Hendo꞉ biso꞉ kalu eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, nanogdo꞉ dian kalu nowo꞉mbo꞉wo꞉ a꞉la꞉sio꞉, ‘Ne mili, niyo꞉ gemo꞉wo꞉ halayo꞉ mo꞉dimido꞉. Tamin amio꞉ naino꞉ silba mole imilig dia꞉no꞉ a꞉la꞉liki da꞉fe sio꞉ a꞉no꞉ hendeleya꞉le? ");
INSERT INTO bco_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Giyo꞉ mole gemo꞉lo꞉ kilili a꞉no꞉ dia꞉sa꞉ga꞉ hamana. Niyo꞉ gemo꞉lo꞉ kilili o꞉leaumbo꞉, kalu tif amilo꞉ mio꞉ o꞉mo꞉wo꞉lo꞉ imilo꞉ kililia꞉no꞉ asulab. ");
INSERT INTO bco_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","A꞉no꞉ kelego꞉ na꞉no꞉ ko꞉lo꞉, niyo꞉ no꞉no꞉ndo꞉ asulab o꞉leaumbo꞉ kudu ha꞉naki, o꞉li aloba꞉ma꞉no꞉wa꞉le? Niyo꞉ kelego꞉ no꞉no꞉ndo꞉wo꞉ mo꞉kanulaki, kalu nolbo꞉wo꞉ sagala꞉li sa꞉ga꞉sen ko꞉lo꞉, ge a꞉na mo꞉beaya?’ ");
INSERT INTO bco_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","O꞉leauka kaluka꞉isale o꞉gdo꞉ tifamilo꞉ a꞉lab a꞉no꞉ tamina doma꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isale o꞉gdo꞉ tamin amilo꞉ a꞉lab a꞉no꞉ tifa doma꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ya꞉suwo꞉ Ya꞉lusalem halona ha꞉na꞉no꞉ ha꞉nakiyo꞉, eyo꞉ enedo꞉ tili wida꞉sen kalu kugula꞉fo꞉ a꞉no꞉leko꞉ tog anidoba꞉da꞉ tililia꞉ga꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Gio꞉ dabuma. O꞉go꞉ nio꞉ Ya꞉lusalem halona ho꞉no꞉l ko꞉lo꞉, kalu noma꞉yo꞉ Kalule Dowo꞉wo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ elelo꞉ wida꞉sen kalu i o꞉lia꞉mo꞉wo꞉ gasi mea꞉ib. A꞉la꞉ta꞉ga꞉ iliyo꞉ e mo꞉walila꞉sa꞉ga꞉yo꞉, sana soma꞉no꞉ a꞉la꞉liki towo꞉ saefa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Iliyo꞉ e ha꞉la꞉ kalumo꞉wo꞉ gasi mealikiyo꞉, kalu i a꞉ma꞉yo꞉ e dio꞉ge sa꞉laki, meya꞉ yame tandeakiyo꞉, i malan amio꞉ a꞉na alu alifa꞉ib. A꞉la꞉ta꞉ga꞉ ho꞉len asol dowalikiyo꞉, e a꞉ma꞉la꞉ a꞉dasi alifa꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","O꞉g a꞉namio꞉ Sa꞉ba꞉diya꞉ ingaya꞉yo꞉ ene kalu so꞉wa a꞉la꞉yo꞉ tililia꞉ga꞉, Ya꞉sulo꞉wa mio꞉ ko꞉lo꞉, eyo꞉ Ya꞉sumo꞉wo꞉ kelego꞉ imilig nowo꞉ dabu ba꞉ba꞉nikiyo꞉, elo꞉wa gulalu misa꞉fu asifo꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","A꞉la꞉gabiki Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge o꞉b asulakigaya?” A꞉la꞉dabu ba꞉dabikiyo꞉, ga a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Ni so꞉wa a꞉la꞉ we gilo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉namio꞉, nowo꞉ dagi ililib doba꞉da꞉ a꞉la꞉ta꞉ga꞉ nowo꞉ dagi fo꞉fo꞉dolo doba꞉da꞉ a꞉na siliki bo꞉fo꞉melea꞉ki ta꞉ta꞉bi a꞉la꞉asulo꞉.” ");
INSERT INTO bco_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ya꞉su eyo꞉ to a꞉no꞉ da꞉dakiyo꞉, a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Gililo꞉ nemo꞉lo꞉ dabu ba꞉dab we, gio꞉ a꞉no꞉ mo꞉dinafa fanda asulo꞉ ko꞉lo꞉lab. Nilo꞉ hida꞉yo꞉ dia꞉nigo꞉l a꞉no꞉, ho꞉n halo꞉ dia꞉sa꞉ga꞉lo꞉ nan o꞉leo꞉ngo꞉ ko꞉lo꞉ ga꞉ino꞉lo꞉ a꞉no꞉ o꞉li ma꞉no꞉wa꞉le?” A꞉la꞉ma꞉ Ya꞉sumo꞉ sa꞉lakiyo꞉, “Naino꞉ o꞉li ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Hendele, ho꞉n halo꞉ nilo꞉ ma꞉nigo꞉l a꞉no꞉ ga꞉go꞉lo꞉ ma꞉ib. Ko꞉sega ni dagi ililib doba꞉da꞉lo꞉ mesa꞉no꞉wo꞉ a꞉la꞉ta꞉ga꞉ dagi fo꞉fo꞉dolo doba꞉da꞉lo꞉ mesa꞉no꞉ a꞉no꞉ niyo꞉ mo꞉da꞉fema꞉no꞉ dowo꞉. Dowa꞉lo꞉ kalu wema꞉ dia꞉ib a꞉la꞉likilo꞉ da꞉fefa꞉ a꞉lab a꞉ma꞉ dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ya꞉suwa꞉yo꞉ a꞉la꞉sa꞉labikiyo꞉, tili wida꞉sen kalu do꞉la꞉fo꞉ iliyo꞉, ao a꞉la꞉ma꞉lo꞉ Ya꞉sumo꞉lo꞉ to dabu ba꞉dab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ a꞉la꞉mo꞉wo꞉ mo꞉bea꞉sa꞉ga꞉ gadio꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ko꞉sega Ya꞉su eyo꞉ iyo꞉ tambo kegenelia꞉sa꞉ga꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Yu kaluma us a꞉namio꞉ misa꞉ kalu alan iliyo꞉ kaluka꞉isaleyo꞉ dibodaki wa꞉la꞉ sa꞉nda꞉sen. A꞉la꞉ta꞉ga꞉ kalu alan ililo꞉ma꞉yo꞉ mada halaido꞉ bo꞉fo꞉lowan. Gio꞉ a꞉no꞉ o꞉ma fanda ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ko꞉sega gi usamio꞉ man wengo꞉wo꞉ mada dowa꞉so꞉bo. Kalu abeyo꞉ e gi usamio꞉ kalu alan doma꞉no꞉ asulalikiyo꞉, e gilo꞉ asuwa꞉fa꞉no꞉ kalu ko꞉le dowa꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A꞉la꞉ta꞉ga꞉ kalu abeyo꞉, e tamina doma꞉no꞉ asulalikiyo꞉, e gili madali nanog dian kalu dowa꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nilo꞉ gimo꞉lo꞉ so꞉lo꞉l o꞉leau, Kalule Dowo꞉ eyo꞉lo꞉ a꞉la꞉dimido꞉. E mio꞉ we, kaluwa꞉yo꞉ e ko꞉lo꞉ asuwa꞉foma꞉ki mio꞉ma. Ko꞉sega eyo꞉ kaluka꞉isale modo꞉wo꞉ asuwa꞉fa꞉ni mio꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ ene mela꞉no꞉wo꞉ walaki, ili mogago꞉ a꞉ma꞉ wa꞉lo꞉ e diakiyo꞉, iyo꞉ sili alifa꞉ni mio꞉.” ");
INSERT INTO bco_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ya꞉su o꞉lia꞉ enedo꞉ tiliwida꞉sen kalu o꞉lia꞉yo꞉, Ya꞉liko amisa꞉no꞉ ta꞉ta꞉sa꞉ga꞉ ha꞉nabikiyo꞉, kaluka꞉isale modo꞉wo꞉ Ya꞉su e ko꞉lo꞉ kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Siyo꞉ ko꞉n kalu a꞉la꞉ nowo꞉ tog aniba silikiyo꞉, Ya꞉suwo꞉ tiginima꞉ni yab a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, a꞉la꞉ma꞉yo꞉ halaido꞉ ho꞉idakiyo꞉, “Kalu Alan, Da꞉ibida꞉ inso꞉, giyo꞉ na꞉no꞉ mada nofola꞉sa꞉ga꞉, asuwa꞉foma!” ");
INSERT INTO bco_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaluka꞉isale kegeo꞉ iliyo꞉ a꞉la꞉ma꞉lo꞉ ho꞉idab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, a꞉la꞉mo꞉wo꞉ halale tandeaki, “Ga꞉go꞉ tola꞉so꞉bo!” Ko꞉sega a꞉la꞉ma꞉yo꞉ halale a꞉ho꞉idakiyo꞉, “Kalu Alan Da꞉ibida꞉ inso꞉, giyo꞉ na꞉no꞉ mada nofola꞉sa꞉ga꞉ asuwa꞉foma!” ");
INSERT INTO bco_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ya꞉suwo꞉ ha꞉na꞉leno꞉ a꞉na kagatakiyo꞉, a꞉la꞉yo꞉ ho꞉ida꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Niyo꞉ ga꞉gbo꞉wo꞉ waga dimidama꞉ki asulaya?” ");
INSERT INTO bco_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","A꞉la꞉ma꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Kalu Alan, giyo꞉ nanin siyo꞉ fage alifoma꞉ki asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ya꞉su eyo꞉ a꞉la꞉yo꞉ mada nofolakiyo꞉, ene dagiya꞉yo꞉ a꞉la꞉ma꞉ siya golabikiyo꞉, wigibole a꞉naka a꞉la꞉ma꞉ siyo꞉ o꞉li fagela꞉sa꞉ga꞉ ba꞉ba꞉ ko꞉lo꞉, a꞉la꞉yo꞉ Ya꞉suwo꞉ a꞉na kudu ane. ");
INSERT INTO bco_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ Ya꞉lusalemo꞉ ko꞉na꞉ma fa꞉la꞉doma꞉nikiyo꞉, iyo꞉ O꞉lif misio꞉lo꞉ a꞉lab anib a꞉namilo꞉ Befage amisa꞉n a꞉na fa꞉la꞉dowo꞉. A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ tili wida꞉sen kalu a꞉la꞉ nowo꞉ tamina hamana꞉ki iliga꞉fa꞉nikiyo꞉, a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ tamina ha꞉na꞉sa꞉ga꞉, amisa꞉n ga꞉gdo꞉ ha꞉na꞉no꞉ doba꞉da꞉ a꞉na ti ha꞉nakiyo꞉, wigibole a꞉namio꞉ gaino꞉ donkiyo꞉, ene inso꞉ kalofo o꞉lia꞉ elen ko꞉lo꞉, galo alifo꞉lena ba꞉ba꞉ib. Gaino꞉ a꞉la꞉ a꞉no꞉ fagela꞉sa꞉ga꞉yo꞉, a꞉la꞉ka nelo꞉wa tililia꞉ ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kalu noma꞉yo꞉ ga꞉gbo꞉wo꞉ dabu ba꞉dalega, gaino꞉ towo꞉ emo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘Kalu Alana꞉yo꞉ donki a꞉la꞉ we nanog dia꞉no꞉wo꞉ dowab.’ A꞉la꞉sa꞉labiki eyo꞉ donki a꞉la꞉ a꞉no꞉ bo꞉bo꞉ge iliga꞉fa꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Dimido꞉ fa꞉la꞉dowab wema꞉yo꞉, Godeya꞉ tolo꞉ dinali sa꞉lan kalu eya a꞉la꞉ta꞉ga꞉lo꞉ to sio꞉ a꞉no꞉ ko꞉lo꞉ ilili alitakigab. Godeya꞉ tolo꞉ dinali sa꞉lan kaluwa꞉yo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saion amisa꞉n kaluka꞉isalemo꞉wo꞉ to we a꞉la꞉sama. ‘Bo꞉ba, misa꞉ kalu ginido꞉wo꞉ o꞉go꞉ gilo꞉wa yab. E enena꞉ma꞉la꞉yo꞉ ha꞉ga dowaki, donki wa꞉la asita꞉ga꞉ a꞉na yab. E donki kalofo wa꞉la asita꞉ga꞉ yab.’ ” ");
INSERT INTO bco_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tili wida꞉sen kalu a꞉la꞉ a꞉no꞉ ha꞉na꞉sa꞉ga꞉, Ya꞉suwa꞉lo꞉ a꞉la꞉mo꞉lo꞉ to sio꞉ au dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A꞉la꞉ma꞉yo꞉ donki o꞉lia꞉ ene inso꞉ kalofo o꞉lia꞉yo꞉ Ya꞉sulo꞉wa tililia꞉ ya꞉sa꞉ga꞉, so꞉g a꞉la꞉ma꞉lo꞉ wa꞉l amilo꞉ sa꞉ga꞉lan a꞉no꞉ donki a꞉la꞉ma꞉ fa꞉sa꞉ wa꞉la fele alitabiki, Ya꞉suwo꞉ a꞉na asifo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kalu kegeo꞉ nolba꞉yo꞉ ini so꞉g wa꞉l amilo꞉ sa꞉ga꞉lan a꞉no꞉ elo꞉ yab tog a꞉na fela꞉i ane. A꞉la꞉ta꞉ga꞉ nolba꞉yo꞉ wani fo꞉so꞉ gegedelia꞉sa꞉ga꞉ toga fela꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kaluka꞉isale modo꞉ Ya꞉su o꞉lia꞉lo꞉ ha꞉nab a꞉no꞉, nolo꞉ tamina a꞉la꞉ta꞉ga꞉, nolo꞉ tifa ha꞉nakiyo꞉, iliyo꞉ Ya꞉suwo꞉ wabudaki, a꞉la꞉ ho꞉le sio꞉, “Da꞉ibida꞉ inso꞉mo꞉wo꞉ mada sagalema꞉niki. Kalu we, Gode Alana꞉ wiya a꞉la꞉ta꞉ga꞉ mio꞉ ko꞉lo꞉, niliyo꞉ sagala꞉liki, Godemo꞉ mada o꞉m a꞉la꞉so꞉lo꞉l. Gode Iwalulo꞉ A꞉lab a꞉no꞉ wabuluma꞉niki.” ");
INSERT INTO bco_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iyo꞉ ha꞉na꞉sa꞉ga꞉, Ya꞉suwo꞉ Ya꞉lusalem usa tinabikiyo꞉, amisa꞉n kaluka꞉isaleyo꞉ tambo iligakiyo꞉, a꞉la꞉dabu kedo꞉, “Kalu we hendele mada o꞉ba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kaluka꞉isale Ya꞉su o꞉lia꞉lo꞉ mio꞉ i a꞉ma꞉ sa꞉lakiyo꞉, “Kalu we Ya꞉su. E Godeya꞉ tolo꞉ dinali sa꞉lan kalu nowo꞉ e ko꞉lo꞉, Ga꞉lili hen ami Nasala꞉t amisa꞉na a꞉la꞉ta꞉ga꞉ mio꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ya꞉su e Godeya꞉ Malilo꞉ Alo꞉ a꞉lab amilo꞉ ilif tolo꞉ us a꞉na ti ha꞉na꞉ga꞉yo꞉, kaluka꞉isale kelego꞉lo꞉ kililia꞉likilo꞉ sen a꞉no꞉ tambo ha꞉la꞉ya o꞉luga꞉felo꞉. Kalu nolba꞉yo꞉ hen nowa a꞉la꞉ta꞉ga꞉lo꞉ mole dia꞉mio꞉ a꞉no꞉ Yu mole a꞉nodo dia꞉len ko꞉lo꞉, i fofodo꞉ ilido꞉wo꞉ Ya꞉su eyo꞉ nodolia꞉ga꞉ buluga꞉felo꞉. A꞉la꞉ta꞉ga꞉ kaluwa꞉ o꞉ba꞉lo꞉ kililia꞉likilo꞉ i fofodo꞉ ta꞉sen a꞉no꞉lo꞉ nodolia꞉ga꞉ buluga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Tamin amio꞉ Godeya꞉ bugo꞉ amio꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, ‘Ni a we nemo꞉lo꞉ dulugu sa꞉la꞉mela꞉no꞉ a a꞉la꞉sa꞉ma꞉ib.’ Ko꞉sega giliyo꞉ a we afalo꞉ dian kaluwa꞉ a o꞉ngo꞉ dimidakigab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ya꞉suwo꞉ Godeya꞉ Malilo꞉ A baya a꞉labikiyo꞉, siyo꞉ ko꞉no꞉ a꞉la꞉ta꞉ga꞉ gido꞉fo꞉wo꞉ mogago꞉wo꞉ elo꞉wa ya꞉siabiki, eyo꞉ iyo꞉ a꞉na falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko꞉sega bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉, elelo꞉ wida꞉sen kalu i o꞉lia꞉ma꞉yo꞉, Ya꞉suwa꞉lo꞉ mo꞉lo꞉ ha꞉na꞉no꞉ dimida꞉lab a꞉no꞉ ba꞉dakiyo꞉ mo꞉beab. A꞉la꞉ta꞉ga꞉ Godeya꞉ Malilo꞉ Abayamio꞉ so꞉wagalin ili sa꞉lakilo꞉, “Da꞉ibida꞉ inso꞉ we niliyo꞉ wabuluma꞉niki!” a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉dakiyo꞉, iliyo꞉ mada mo꞉beo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “So꞉wagalina꞉lo꞉ to sa꞉la꞉lab a꞉no꞉ ge dabuwa꞉le?” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “A꞉ ne dabu. Gio꞉ Godeya꞉ to we mo꞉agela꞉sena꞉le? Gisalo bugo꞉ amio꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Gode giyo꞉, so꞉wa tuo꞉lun o꞉lia꞉ so꞉wa bolo꞉ mea꞉sen o꞉lia꞉ma꞉yo꞉ Ge ko꞉lo꞉ wabuluma꞉ki dimidaitaki ta꞉fo꞉.’ ” ");
INSERT INTO bco_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ Ya꞉su eyo꞉ iyo꞉ ta꞉ta꞉ga꞉, Ya꞉lusalem amisa꞉n ha꞉la꞉ya handalota꞉ga꞉yo꞉, Ba꞉tani amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉, nuluwo꞉ e a꞉na dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ya꞉suwo꞉ kea꞉fole a꞉ma꞉la꞉ Ya꞉lusalem amisa꞉na ha꞉na꞉ni ane amio꞉, e maiyo꞉wo꞉ a꞉na dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Eyo꞉ alona꞉ iyo꞉ tog aniba eleno꞉lo꞉biki ba꞉da꞉sa꞉ga꞉, a꞉na ane ko꞉sega, fowo꞉ mo꞉hedaki, i fo꞉sde elena ba꞉ba꞉. A꞉la꞉go꞉ko꞉lo꞉ eyo꞉ alona꞉ imo꞉ sa꞉lakiyo꞉, “Ge wa꞉kabiyo꞉ fowo꞉ mada mo꞉helema꞉ib.” A꞉la꞉sa꞉labikiyo꞉ wigibole a꞉naka alona꞉ iyo꞉ a꞉na ulula꞉li. ");
INSERT INTO bco_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Tili wida꞉sen kalu iyo꞉ dimidab a꞉no꞉ ba꞉da꞉ga꞉ iligakiyo꞉ towo꞉ a꞉la꞉nenelo꞉, “Alona꞉ i ko꞉lo꞉ bo꞉bo꞉gedo꞉ ulula꞉liab we wangabiki gaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉ a꞉la꞉sio꞉, “Niyo꞉ gimo꞉wo꞉ to hendele sa꞉ma꞉nigo꞉l. Gio꞉ asulo꞉ a꞉la꞉yo꞉ mo꞉dowaki, tilidabuwo꞉ hendele dowalega, nilo꞉ alona꞉ i amilo꞉ dimido꞉l we aumbo꞉, giliyo꞉lo꞉ a꞉la꞉ka dimidama꞉ib. Ko꞉sega imilise a꞉no꞉ ko꞉mba. Giliyo꞉ misio꞉ wemo꞉ sa꞉lakiyo꞉, ‘Ge go꞉no꞉na꞉ma꞉la꞉yo꞉ duda꞉sa꞉ga꞉, so꞉lu ho꞉na ti hamana’ a꞉la꞉sa꞉lalikiyo꞉, gililo꞉ sa꞉lab a꞉no꞉ a꞉la꞉ka fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Gio꞉ tilidabuwo꞉ dowalega, gililo꞉ Godemo꞉lo꞉ dulugu sa꞉lakilo꞉ dabu ba꞉dab a꞉no꞉, Gode eyo꞉ dimidama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ya꞉suwo꞉ Godeya꞉ Malilo꞉ A tolo꞉ us a꞉na tina꞉sa꞉ga꞉, eyo꞉ kaluka꞉isalemo꞉ wida꞉labikiyo꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu ko꞉go꞉dego꞉ kalu i o꞉lia꞉yo꞉ elo꞉wa ya꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Nanog gilo꞉ dimidab we, abe wiya iliki dimidaya? Ge nanogo꞉ we dima꞉kiyo꞉ abe da꞉feabeyo꞉?” ");
INSERT INTO bco_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ya꞉su eyo꞉ to ililo꞉ sa꞉lab a꞉no꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Niyo꞉lo꞉ to nowo꞉ gimo꞉wo꞉ dabu ba꞉ba꞉nigo꞉l. Giliyo꞉ ko꞉lo꞉ a꞉ma꞉la꞉yo꞉ nemo꞉wo꞉ sa꞉lalega, nanog we nemo꞉ dima꞉kilo꞉ da꞉feyo꞉ a꞉no꞉lo꞉ gimo꞉wo꞉ sa꞉ma꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Yo꞉na꞉lo꞉ ho꞉n amilo꞉ to꞉lola꞉len man a꞉no꞉, eyo꞉ o꞉ba a꞉la꞉ta꞉ga꞉ diya꞉le? A꞉no꞉ Hebene a꞉la꞉ta꞉ga꞉ mio꞉wa꞉le, mo꞉ kaluwa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉wa꞉le?” Ya꞉su eyo꞉ a꞉la꞉sa꞉labiki, iliyo꞉ a꞉ma꞉la꞉bo꞉ waga sa꞉ma꞉no꞉wa꞉le a꞉la꞉liki egele nenelakiyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ ‘Man a꞉no꞉ Hebene a꞉la꞉ta꞉ga꞉ mio꞉’ a꞉la꞉sa꞉lalega, Ya꞉su eyo꞉ nimo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉ib, ‘Gio꞉ e amio꞉ waga mo꞉tili dabuwo꞉?’ a꞉la꞉sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ko꞉sega kaluka꞉isale tambowo꞉ Yo꞉n e dinali sa꞉lan kalu a꞉la꞉bo꞉ tili asulufo꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉, ‘Man a꞉no꞉ kaluwa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉’ a꞉la꞉bo꞉ sa꞉lalega, kaluka꞉isaleya꞉yo꞉ gadima꞉ib ko꞉lo꞉, niliyo꞉ a꞉la꞉sa꞉ma꞉no꞉wo꞉ tagilab.” ");
INSERT INTO bco_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Nio꞉ babalab.” A꞉la꞉sa꞉labikiyo꞉ Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “A꞉la꞉galega, niyo꞉lo꞉ nanog we nemo꞉ dima꞉kilo꞉ da꞉feyo꞉ a꞉no꞉ gimo꞉wo꞉ mo꞉sa꞉ma꞉no꞉.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ waga asulaya꞉le? Kalu noma꞉yo꞉ so꞉wayo꞉ a꞉la꞉ ko꞉lo꞉ elen. Kalu a꞉no꞉ ene so꞉wa wa꞉la꞉bdo꞉wa ha꞉na꞉sa꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉sio꞉, ‘Ni so꞉wa, o꞉go꞉ ge ha꞉na꞉sa꞉ga꞉ nanogo꞉ wain egelo꞉wa dia꞉ni hamana.’ ");
INSERT INTO bco_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","A꞉la꞉sa꞉labiki, so꞉wa a꞉ma꞉yo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, ‘Ne mo꞉beab,’ a꞉la꞉sio꞉. Ko꞉sega tif amio꞉ e asulo꞉wo꞉ a꞉dia꞉sa꞉ga꞉, nanogo꞉ a꞉na dia꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","A꞉la꞉ta꞉ga꞉ iyayo꞉ so꞉wa enedo꞉ nolo꞉wa ha꞉na꞉sa꞉ga꞉, wa꞉la꞉bo꞉lo꞉ to sio꞉ o꞉leau ka sio꞉. So꞉wa a꞉ma꞉yo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, ‘A꞉ dowa, ne ha꞉na꞉no꞉,’ a꞉la꞉sio꞉ ko꞉sega e mo꞉ane. ");
INSERT INTO bco_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","A꞉la꞉fo꞉ko꞉lo꞉ so꞉wa a꞉la꞉ a꞉ma꞉yo꞉ iyaya꞉lo꞉ asulab aundo꞉ kudu aneyo꞉ o꞉ba꞉le?” Iliyo꞉, “So꞉wa wa꞉la꞉b.” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉ sa꞉laki, “Niyo꞉ gimo꞉wo꞉ to hendele sa꞉ma꞉nigo꞉l. Takis molelo꞉ dian kalu o꞉lia꞉ uwo꞉lo꞉ dian ga o꞉lia꞉ma꞉yo꞉ gio꞉ tiginita꞉ga꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man us a꞉namio꞉ i ko꞉le tiha꞉nab. ");
INSERT INTO bco_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Mo꞉wo꞉ we, ho꞉n amilo꞉ to꞉lolan kalu Yo꞉n e, gilo꞉ amio꞉ fa꞉la꞉dowakiyo꞉, tog digalo꞉leyo꞉ gimo꞉wo꞉ wido꞉ ko꞉sega, gio꞉ e amio꞉ mo꞉tilidabu. Ko꞉sega takis molelo꞉ dia꞉sen kalu o꞉lia꞉ uwo꞉lo꞉ dia꞉sen ga o꞉lia꞉yo꞉ e amio꞉ tilidabu. A꞉la꞉ta꞉ga꞉ tilidabu ilido꞉wo꞉ gio꞉ ba꞉ba꞉ ko꞉sega, asulo꞉ gililo꞉wo꞉ mo꞉nodolaki, e amio꞉ mo꞉tilidabu.” ");
INSERT INTO bco_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Ya꞉su eyo꞉ towo꞉ a꞉la꞉wido꞉, “Gio꞉ bale sio꞉ to nowo꞉ dabuma. Hendo꞉ biso꞉ kalu noma꞉yo꞉ waina꞉ fowo꞉ gela꞉sa꞉ga꞉yo꞉, ilifo꞉ tolofa꞉. Egelo꞉ us a꞉namio꞉, fowo꞉ basia꞉sa꞉ga꞉lo꞉ wain ho꞉ndo꞉ guma꞉no꞉ ho꞉wo꞉ nanala꞉sa꞉ga꞉yo꞉, wain egelo꞉ o꞉lo꞉ bo꞉fo꞉likilo꞉ mesa꞉no꞉ ayo꞉ iwalu dialifa꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ egelo꞉ a꞉no꞉ ko꞉lo꞉ kalu nolbo꞉ ene wiya iliki bo꞉fo꞉melea꞉ki, ili dagiya dia꞉ta꞉sa꞉ga꞉, hendo꞉ biso꞉ kalu a꞉no꞉ hen nowa ko꞉na꞉ ane. ");
INSERT INTO bco_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Waina꞉ folo꞉ tuma꞉no꞉ ho꞉leno꞉ ko꞉na꞉ma fa꞉la꞉dowabikiyo꞉, hendo꞉ biso꞉ kalu eyo꞉ ene nanogdo꞉ dian kalu nolo꞉ waina꞉ fo tola꞉sa꞉ga꞉lo꞉ difa꞉, heb a꞉no꞉ dia꞉ni hamana꞉ki iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Nanogdo꞉ dian kaluwo꞉ a꞉na fa꞉la꞉dowo꞉ ko꞉sega, egelo꞉lo꞉ bo꞉fo꞉len kalu iliyo꞉ kalu i a꞉no꞉ ta꞉lia꞉sa꞉ga꞉, nowo꞉ yame tandeaki, nowo꞉ sana sowaki a꞉la꞉ta꞉ga꞉ nowo꞉ uwa꞉ agodaki a꞉la꞉dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","A꞉la꞉go꞉ko꞉lo꞉ hendo꞉ biso꞉ kaluwa꞉yo꞉ nanogdo꞉ dian kalu nolo꞉ ilo꞉ a꞉na iliga꞉fo꞉. Eyo꞉ kalu mada modo꞉ nolo꞉ a꞉ iliga꞉takiyo꞉, tamin amilo꞉ elo꞉ iliga꞉fo꞉ a꞉no꞉ a꞉ma꞉ tinio꞉. Ko꞉sega egelo꞉lo꞉ bo꞉fo꞉len kalu iliyo꞉ man tamin amilo꞉ dimido꞉ o꞉leaumbo꞉ imo꞉wo꞉lo꞉ a꞉la꞉ka dimido꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Edakiyo꞉ hendo꞉ biso꞉ kaluwa꞉ ene so꞉waleyo꞉ ilo꞉ a꞉na iliga꞉fo꞉. Eyo꞉ a꞉la꞉asulo꞉, ‘Iliyo꞉ ni so꞉waya꞉ towo꞉ hendele da꞉ba꞉ib,’ a꞉la꞉asulaki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko꞉sega egelo꞉lo꞉ bo꞉fo꞉len kalu iliyo꞉ so꞉wa ko꞉lo꞉ yabo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, egele nenelakiyo꞉ a꞉la꞉sio꞉, ‘Ene so꞉wa imilig yab wema꞉yo꞉, iyayo꞉ sowalikiyo꞉ dabuno꞉ e tambo dia꞉ib. Hen elo꞉ a꞉no꞉ nili dia꞉nikiyo꞉, niliyo꞉ e sana soma꞉niki,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","A꞉la꞉go꞉ko꞉lo꞉ iliyo꞉ e ta꞉lia꞉sa꞉ga꞉yo꞉, egelo꞉ ha꞉la꞉ya susululia꞉ ha꞉na꞉sa꞉ga꞉ ami a꞉na sana sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Giliyo꞉ waga asulaya? Tif amio꞉ hendo꞉ biso꞉ kalu e ya꞉ga꞉yo꞉, egelo꞉lo꞉ bo꞉fo꞉len kalu imo꞉wo꞉ mano꞉ waga dimidama꞉iba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Eyo꞉ kalu mogago꞉ i a꞉no꞉ mada mogagila꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ wain egelo꞉ we eyo꞉ kalu ko꞉li nolbo꞉ bo꞉fo꞉melea꞉ki dimia꞉ib ko꞉lo꞉, folo꞉ tulab ho꞉len a꞉namio꞉, kalu i a꞉ma꞉yo꞉ fo a꞉no꞉ aloba꞉da꞉sa꞉ga꞉ heb elo꞉ dia꞉no꞉ aumbo꞉ emo꞉ dimea꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iliyo꞉ a꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ Godeya꞉ ene bugo꞉ amilo꞉ to da꞉lab a꞉no꞉ mo꞉agela꞉sena꞉le? To we o꞉leo꞉ngo꞉, “ ‘ U ko꞉lo꞉ alo꞉ dian ililo꞉ mo꞉beakilo꞉ sandifo꞉ a꞉no꞉, o꞉go꞉ ayo꞉ halaido꞉ dofo꞉melea꞉kilo꞉ u wa꞉la꞉b ko꞉lo꞉ fa꞉la꞉dowo꞉wo꞉ o꞉m. Alana꞉ ene dimida꞉sa꞉ga꞉ fa꞉la꞉do alifa꞉ ko꞉lo꞉, niliyo꞉ a꞉no꞉ mada nafale ba꞉ba꞉.’ ");
INSERT INTO bco_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Gode eyo꞉ enedo꞉ bo꞉fo꞉mela꞉no꞉ hen ko꞉lo꞉ gili dagi amilo꞉ da꞉lab a꞉no꞉ dila꞉sa꞉ga꞉yo꞉, kaluka꞉isale fo nafalo꞉ hele alita꞉sen imo꞉ dimea꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kaluka꞉isale o꞉ba꞉le u a꞉na ifikidakilo꞉ u wa꞉l amilo꞉ tulu alilab a꞉no꞉ e kiyo꞉ go꞉go꞉bela꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isale o꞉ba꞉le u we tinda꞉ga꞉ e wa꞉la ti alilalikiyo꞉, u a꞉ma꞉yo꞉ e tambo mula꞉la꞉ma꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Fa꞉lisi kalu i o꞉lia꞉ma꞉yo꞉, bale sio꞉ a꞉no꞉ da꞉dakiyo꞉, Ya꞉su eyo꞉ iyo꞉ ko꞉lo꞉ sa꞉lab a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A꞉la꞉go꞉ko꞉lo꞉ iliyo꞉ Ya꞉suwo꞉ ta꞉lia꞉no꞉ asulo꞉ ko꞉sega, kaluka꞉isale kegeo꞉ a꞉no꞉ ko꞉lo꞉ tagilaki mo꞉ta꞉li. Mo꞉wo꞉ kaluka꞉isale a꞉ma꞉yo꞉ Ya꞉su e Godeya꞉lo꞉ tolo꞉ dinali sa꞉lan kalu a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ya꞉su eyo꞉ kaluka꞉isalemo꞉ wa꞉ka bale sa꞉lakiyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉, we o꞉ngo꞉ dowab ko꞉lo꞉ bale sa꞉ma꞉nigo꞉l. Misa꞉ kalu alan nowo꞉ elen ko꞉lo꞉, eyo꞉ so꞉waya꞉lo꞉ ga tilili alitakilo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ dimidaefa꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ho꞉leno꞉ fa꞉la꞉dowabikiyo꞉, kaluka꞉isale tamin amilo꞉ saga꞉ifelo꞉ i a꞉no꞉ mena꞉ki, ene nanogdo꞉ dian kaluwo꞉ sa꞉ma꞉ni hamana꞉ki iliga꞉fo꞉. Ko꞉sega kaluka꞉isale iyo꞉ mo꞉mia꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","A꞉la꞉gabiki eyo꞉ ene nanogdo꞉ dian kalu nolo꞉ wa꞉ka iliga꞉fa꞉nikiyo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, ‘Gio꞉ kaluka꞉isale tamin amilo꞉ saga꞉ifelo꞉ ilo꞉ a꞉na ha꞉na꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉sa꞉la꞉be, “Niyo꞉ ma꞉no꞉ ma꞉no꞉ kelego꞉wo꞉ tambo dimidalia꞉ga꞉ difa꞉. Niyo꞉ kao o꞉lia꞉ kao kalofo o꞉lia꞉yo꞉ yasala꞉sa꞉ga꞉, o꞉ma ufalifa꞉ ko꞉lo꞉, gio꞉ galo꞉ tililiakilo꞉ ma꞉no꞉lo꞉ nab a꞉namio꞉ mena,” a꞉la꞉sa꞉la꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ene nanogdo꞉ dian kaluwa꞉yo꞉ a꞉la꞉dimido꞉ ko꞉sega tamin amilo꞉ saga꞉ifelo꞉ kaluka꞉isale iyo꞉ mo꞉beaki, inido꞉ asulab au ha꞉na꞉sio꞉. Kalu nowo꞉ ene egelo꞉wa ane, nowo꞉ mole nanog dimidama꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","A꞉la꞉ta꞉ga꞉ kaluka꞉isale nolba꞉yo꞉ misa꞉ kaluwa꞉ nanogdo꞉ dian kalu i a꞉no꞉ ta꞉lia꞉sa꞉ga꞉yo꞉, iyo꞉ dikidia꞉sa꞉ga꞉ yame tandeaki, sana sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","A꞉la꞉fo꞉ko꞉lo꞉ misa꞉ kalu a꞉no꞉ e mada kulufa꞉ya꞉sa꞉ga꞉yo꞉, ene nanogdo꞉ dian kalulo꞉ yasala꞉ kalu i a꞉no꞉, ene ame kalumo꞉ yasala꞉ma꞉ki iliga꞉fo꞉. A꞉la꞉ta꞉ga꞉ amisa꞉n inido꞉wo꞉lo꞉ deya gilima꞉ki a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","A꞉la꞉ta꞉ga꞉ misa꞉ kalu a꞉ma꞉yo꞉ ene nanogdo꞉ dian kalu imo꞉wo꞉ a꞉la꞉sio꞉, ‘Niyo꞉ ga tililiakilo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ dimidali, ko꞉sega nilo꞉ mena꞉kilo꞉ ho꞉ido꞉ kaluka꞉isale i a꞉no꞉, ini mano꞉ mogago꞉ ko꞉lo꞉ mea꞉no꞉wo꞉ mo꞉ililo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","A꞉la꞉fo꞉ko꞉lo꞉ o꞉go꞉ gio꞉ ha꞉na꞉sa꞉ga꞉ tog alana yasilaki, kalu gilido꞉ galiliab a꞉no꞉ giliyo꞉ ma꞉no꞉lo꞉ ma꞉no꞉ wena tililia꞉ ya꞉bi,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A꞉la꞉sa꞉labiki ene nanogdo꞉ dian kalu iyo꞉ ha꞉na꞉sa꞉ga꞉, tog alana fa꞉la꞉dota꞉ga꞉ yasilakiyo꞉, kalu nafayo꞉lo꞉ mogago꞉wo꞉lo꞉, kaluka꞉isale ilido꞉ gidab a꞉no꞉ tambo kegea꞉sa꞉ga꞉ tililia꞉ mio꞉ ko꞉lo꞉, ma꞉ndo꞉ ma꞉no꞉ ayo꞉ mada ililifo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ko꞉sega misa꞉ kalu eneno꞉ ha꞉na꞉sa꞉ga꞉ kalu kegeo꞉ a꞉no꞉ sigiliga꞉fo꞉ amio꞉, kalu nowo꞉ ga tililiakilo꞉ so꞉g nafale sa꞉ga꞉lan a꞉no꞉ mo꞉sa꞉ga꞉lo꞉wa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Misa꞉ kalu eyo꞉ kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, ‘Ne mili, ge ga tililiakilo꞉ so꞉g ka꞉lano꞉ mo꞉ko꞉lo꞉ amio꞉, ge waga tia꞉yo꞉?’ A꞉la꞉sa꞉labiki kalu a꞉no꞉ towo꞉ mada mo꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","A꞉la꞉fo꞉ko꞉lo꞉ misa꞉ kalu a꞉ma꞉yo꞉ ene nanogdo꞉ dian kalumo꞉ sa꞉lakiyo꞉, ‘Kalu wema꞉ dagi o꞉lia꞉ gib o꞉lia꞉yo꞉ mela꞉sa꞉ga꞉, ha꞉la꞉ amilo꞉ sololi a꞉lab a꞉na sandifoma. Hen a꞉namio꞉ kaluka꞉isaleyo꞉ kulufa꞉yakiyo꞉, ya꞉foda꞉li mesa꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Dabuma, Gode eyo꞉ kaluka꞉isaleyo꞉ modo꞉ mena꞉ki ho꞉leli ko꞉sega, kaluka꞉isale imilida꞉ imilida꞉lo꞉wa꞉ timana꞉ki da꞉fe alifa꞉ ko꞉lo꞉lab.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A꞉ma꞉ fa꞉s amio꞉, Fa꞉lisi kalu iyo꞉ ua kegea꞉sa꞉ga꞉ nenelakiyo꞉, Ya꞉su elo꞉ to sa꞉lab a꞉no꞉ dehege sa꞉la꞉sa꞉ga꞉ Ya꞉suwo꞉ a꞉na mo꞉walilima꞉no꞉ a꞉la꞉ta꞉ga꞉ togo꞉ kedo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","A꞉la꞉dimidama꞉kiyo꞉ iliyo꞉ inido꞉ tili wida꞉sen kalu nolo꞉ Ya꞉sulo꞉wa iliga꞉tabiki, iyo꞉ Ha꞉lodo꞉ kudu sian kalu nol o꞉lia꞉yo꞉ Ya꞉sulo꞉wa ane. Kalu i a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, niliyo꞉ ge to hendelelo꞉ sa꞉lan kaluwo꞉ ge a꞉la꞉asula꞉sen. Godeya꞉ mano꞉ widakiyo꞉, giyo꞉ to hendeleyo꞉ ko꞉lo꞉ wida꞉sen. Wilo꞉ kalumo꞉wo꞉lo꞉, wilo꞉ma kalumo꞉wo꞉lo꞉, giyo꞉ to mano꞉ imilo꞉ ko꞉ngo꞉ ka widakiyo꞉, ililo꞉ asulab a꞉no꞉ giyo꞉ mo꞉kele asula꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉ gemo꞉wo꞉ we au dabu ba꞉ba꞉nigo꞉l. Loma꞉ gamani misa꞉ kalu alan, Sisa o꞉mo꞉lo꞉ takis mole dimia꞉no꞉ a꞉no꞉ niliyo꞉ o꞉li dimia꞉no꞉wa꞉le? O꞉ mo꞉dimia꞉no꞉wa꞉le, giyo꞉ waga asulaya?” ");
INSERT INTO bco_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ ililo꞉ emo꞉lo꞉ man mogago꞉ dimidama꞉nikilo꞉ dimidaliab a꞉no꞉ asula꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “To mosowa꞉lo꞉ widan kalu giliyo꞉, ne dikidakilo꞉ bale kedako, mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","20","Takis kililia꞉sen mole us nowo꞉ nelo꞉ walama,” a꞉la꞉sio꞉. Iliyo꞉ mole us a꞉no꞉ Ya꞉sulo꞉ bo꞉ba꞉ki dimiabikiyo꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Mole wema꞉ wa꞉l amio꞉ abe wo꞉lokano꞉lo꞉bo꞉? A꞉la꞉ta꞉ga꞉ mole wa꞉l amio꞉ abe wi ko꞉lo꞉ sa꞉sa꞉lo꞉lo꞉bo꞉?” ");
INSERT INTO bco_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","A꞉la꞉dabu ba꞉dabiki, ili a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Sisa eno꞉.” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “A꞉la꞉fo꞉ko꞉lo꞉ kelego꞉ Sisa elo꞉wo꞉, a꞉ma꞉la꞉ Sisamo꞉ dimia꞉bi. A꞉la꞉ta꞉ga꞉ kelego꞉ Gode elo꞉wo꞉, a꞉ma꞉la꞉ Godemo꞉ dimia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iyo꞉ Ya꞉suwa꞉lo꞉ to nafa a꞉ma꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, iyo꞉ molo asulo꞉. A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ Ya꞉suwo꞉ ta꞉ta꞉sa꞉ga꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sadusi kalu iliyo꞉ tili asulakiyo꞉, sowo꞉ kaluwo꞉ a꞉ma꞉la꞉yo꞉ mada mo꞉dasima꞉ib a꞉la꞉asula꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ o꞉g ho꞉lende a꞉namio꞉ Sadusi kalu nolo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉ a꞉la꞉dabu ba꞉ba꞉, ");
INSERT INTO bco_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Widan kalu, mo꞉luwo꞉ Mo꞉sa꞉sa꞉ ele nimo꞉lo꞉ sa꞉sa꞉li me a꞉ma꞉yo꞉ a꞉la꞉sio꞉, So꞉lo꞉ usamio꞉ kalu nowo꞉ so꞉walo꞉ mo꞉sa꞉la꞉li ka sowalega, kalu sowo꞉ a꞉ma꞉ ga sa꞉ba꞉lo꞉ a꞉no꞉, ene ao a꞉ma꞉ dia꞉ib. A꞉la꞉ta꞉ga꞉ kalu sowo꞉ a꞉ma꞉ wiyo꞉ mo꞉elema꞉ki, aowa꞉ inga sa꞉ba꞉lo꞉ a꞉no꞉ ene dia꞉sa꞉ga꞉ so꞉wa wa꞉la꞉b sa꞉la꞉liab a꞉no꞉, ao sowo꞉ a꞉ma꞉no꞉ doma꞉ib. Mo꞉sa꞉s eyo꞉ a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Niliyo꞉ a꞉no꞉ ko꞉lo꞉ da꞉feaki maloloma꞉nigo꞉l. Tamin amio꞉ ao i dom a꞉la꞉fo꞉wo꞉ ni o꞉lia꞉ sen. Ao wa꞉la꞉bo꞉ gayo꞉ di, ko꞉sega e so꞉wayo꞉ mo꞉sa꞉la꞉li ka sowo꞉. A꞉la꞉fo꞉ko꞉lo꞉ ga sa꞉ba꞉lo꞉ a꞉no꞉ wa꞉la꞉ba꞉ fa꞉sa꞉ a꞉di. ");
INSERT INTO bco_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Elo꞉ so꞉walo꞉ mo꞉sa꞉la꞉li ka sowo꞉. Ao asol a꞉ma꞉yo꞉ a꞉la꞉ka dimido꞉. Ao i a꞉no꞉ tambo a꞉la꞉dimida꞉i aneyo꞉, ao doma꞉ a꞉dia꞉sa꞉ga꞉ sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","A꞉la꞉ta꞉ga꞉ a꞉ma꞉ fa꞉s amio꞉, ga sa꞉ba꞉lo꞉ a꞉no꞉lo꞉ a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kalu doma꞉la꞉fo꞉ a꞉ma꞉yo꞉ ga imilig a꞉no꞉ko꞉ dia꞉i ane. A꞉la꞉fo꞉ko꞉lo꞉ kalu sowo꞉lo꞉ a꞉ma꞉la꞉ dasi alifelab ho꞉len a꞉namio꞉, ga a꞉ma꞉ indeyo꞉ o꞉b doma꞉iba?” Sadusi kalu iliyo꞉ Ya꞉sumo꞉ dehege kedakiyo꞉ a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ko꞉sega Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Godeya꞉ to sa꞉sa꞉lo꞉ o꞉lia꞉, Godeya꞉ halaido꞉ o꞉lia꞉yo꞉ gio꞉ mo꞉fanda asulo꞉ ko꞉lo꞉, giliyo꞉ mada babale asula꞉sa꞉ga꞉ ha꞉na꞉len. ");
INSERT INTO bco_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kalu sowo꞉lo꞉ a꞉ma꞉la꞉ dasi alifelab ho꞉len a꞉namio꞉, iyo꞉ ga dian man o꞉lia꞉ kalu ha꞉nan man a꞉no꞉lia꞉yo꞉ i amio꞉ mo꞉doma꞉ib. Ko꞉sega iyo꞉ Hebenelo꞉ ma꞉mula꞉ kalu sab o꞉leo꞉ngo꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","32","Sowo꞉ kalu ko꞉lo꞉ a꞉ma꞉la꞉ dasima꞉ib a꞉la꞉liki, Godeya꞉lo꞉ to ko꞉lo꞉ gimo꞉lo꞉ sio꞉ a꞉no꞉, ge mo꞉agelo꞉wo꞉? To a꞉namio꞉ a꞉la꞉sa꞉sa꞉lo꞉, ‘Ablahama꞉ Godeyo꞉ Ne, Aisa꞉ga꞉ Godeyo꞉ Ne, a꞉la꞉ta꞉ga꞉ Ya꞉koba꞉ Godeyo꞉ Ne.’ Gode e sowo꞉ kalu a꞉ma꞉no꞉ma. E kalu mela꞉no꞉lo꞉ a꞉lab a꞉ma꞉ Gode.” ");
INSERT INTO bco_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kaluka꞉isale kegeo꞉ i a꞉ma꞉yo꞉ Ya꞉suwa꞉lo꞉ to widab a꞉no꞉ da꞉dakiyo꞉, iyo꞉ iligaki molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadusi kalu iliyo꞉ Ya꞉suwo꞉ da꞉fe ba꞉dabikiyo꞉, Ya꞉suwa꞉lo꞉ to imo꞉lo꞉ a꞉ma꞉la꞉ sa꞉lab a꞉ma꞉yo꞉, iyo꞉ towo꞉ mo꞉sama꞉ki kalifa꞉ ko꞉lo꞉, Fa꞉lisi kalu iyo꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ Ya꞉sumo꞉wo꞉ wa꞉ka dabu ba꞉ba꞉no꞉ a꞉laki kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fa꞉lisi kalu nowo꞉ elelo꞉ doba꞉da꞉yo꞉ asulo꞉wo꞉ di ko꞉lo꞉, eyo꞉ Ya꞉suwo꞉ da꞉fe ba꞉dakiyo꞉, emo꞉wo꞉ a꞉la꞉ dehege dabu ba꞉ba꞉, ");
INSERT INTO bco_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Widan kalu, Godeya꞉ ele modo꞉ difa꞉ us a꞉namio꞉, ele imilig mada alandeyo꞉ o꞉ba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Go꞉no꞉n Gode Alano꞉ mada alan asulaki, go꞉no꞉n kufa꞉ us o꞉lia꞉, go꞉no꞉n mama o꞉lia꞉, go꞉no꞉n asulo꞉ o꞉lia꞉ma꞉yo꞉ tambo Godemo꞉wo꞉ ha꞉fo꞉ disa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ele we mada alandeyo꞉ o꞉m ko꞉lo꞉, ele nolo꞉ tambo tinio꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","A꞉la꞉ta꞉ga꞉ ele andeb a꞉no꞉lo꞉ imilo꞉ ko꞉ngo꞉ da꞉lab ko꞉lo꞉ to a꞉no꞉ we, Gio꞉ go꞉no꞉n asulan o꞉leaumbo꞉, giasi kaluka꞉isale nolo꞉lo꞉ a꞉la꞉asulaki ha꞉fo꞉wo꞉ disa꞉la꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ele a꞉la꞉ a꞉no꞉, Mo꞉sa꞉sa꞉lo꞉ ele difa꞉ da꞉lab o꞉lia꞉ dinali sa꞉lan kaluwa꞉lo꞉ to wido꞉ a꞉no꞉lia꞉ma꞉ mo꞉wo꞉ o꞉m ko꞉lo꞉, nolo꞉ a꞉ma꞉ go꞉lu alifa꞉ ko꞉lo꞉lab.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fa꞉lisi kalu nolo꞉ kegenelia꞉ga꞉ a꞉labiki, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, ");
INSERT INTO bco_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gililo꞉ Godeya꞉lo꞉ da꞉feyo꞉ kalu a꞉la꞉do꞉ sa꞉lab a꞉no꞉, giliyo꞉ waga asulaya? E so꞉wa abeno꞉wo꞉?” A꞉la꞉dabu ba꞉dabiki, iliyo꞉, “Da꞉ibida꞉ inso꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “A꞉la꞉go꞉ amio꞉, Godeya꞉ Mama eyo꞉ Da꞉ibid emo꞉ asulo꞉wo꞉ dimiabikiyo꞉, Da꞉ibid eyo꞉ Godeya꞉lo꞉ da꞉feyo꞉ kalu a꞉no꞉ ko꞉lo꞉ sa꞉laki a꞉la꞉sio꞉, ‘Ni Alanka꞉.’ Kalu a꞉no꞉ Da꞉ibida꞉ inso꞉lalega, Da꞉ibid eyo꞉ ‘ni Kalu Alan’ a꞉la꞉bo꞉ waga asulaki sio꞉wo꞉? Da꞉ibid eyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Gode eyo꞉ ni Alanbo꞉wo꞉ a꞉la꞉sio꞉, “Ge ni dagi ililiba mesa꞉ni mena. Niyo꞉ gis kalu gilo꞉wo꞉ gi ha꞉g amio꞉ semo꞉ difa꞉ amio꞉, a꞉na o꞉sa꞉bi.” ’ ");
INSERT INTO bco_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Da꞉ibid eyo꞉ Godeya꞉lo꞉ Da꞉feyo꞉ kalu a꞉no꞉, ‘Alan nilo꞉wo꞉ weka꞉’ a꞉la꞉sio꞉ ko꞉lo꞉, giliyo꞉ kalu a꞉no꞉ Da꞉ibida꞉ inso꞉ a꞉la꞉do꞉ sio꞉wo꞉ mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ya꞉suwa꞉lo꞉ dabu ba꞉dab a꞉no꞉, Fa꞉lisi kalu kegeo꞉ tambowa꞉yo꞉ a꞉ma꞉la꞉ towo꞉ mada mo꞉sa꞉ma꞉no꞉ dowo꞉. O꞉g ho꞉len a꞉na a꞉la꞉ta꞉ga꞉yo꞉, iyo꞉ tagilaki Ya꞉sumo꞉wo꞉ wa꞉kabiyo꞉ mo꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ho꞉len a꞉namio꞉ Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉mo꞉wo꞉ towo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Elelo꞉ wida꞉sen kalu i o꞉lia꞉ Fa꞉lisi kalu i o꞉lia꞉yo꞉ Mo꞉sa꞉sa꞉ mego꞉fo꞉ ili dia꞉sa꞉ga꞉, Mo꞉sa꞉sa꞉ ele a꞉no꞉ ko꞉lo꞉ wida꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ to ililo꞉ widab a꞉no꞉ tili da꞉da꞉sa꞉ga꞉ kudu ha꞉na꞉lubi. Ko꞉sega nanog ililo꞉ dimida꞉sen a꞉no꞉ gio꞉ kudu ha꞉na꞉so꞉bo. Mo꞉wo꞉ iliyo꞉ to mosowa꞉ sa꞉laki, inido꞉ to widab a꞉no꞉ inino꞉ mo꞉kudu ha꞉na꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Iliyo꞉ ele ko꞉li ko꞉lilo꞉wo꞉ kaluka꞉isaleyo꞉ kudu hamana꞉ki dia꞉takiyo꞉, hida꞉yo꞉ alan a꞉no꞉ imo꞉ dimia꞉sen. Ko꞉sega kaluka꞉isaleya꞉ hida꞉yo꞉ dia꞉ha꞉na꞉no꞉ a꞉no꞉, iliyo꞉ mada mo꞉asuwa꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ililo꞉ nanog dimida꞉sen a꞉no꞉ tambo, kaluka꞉isaleyo꞉ bo꞉ba꞉ki dimido꞉. Kaluka꞉isale iliyo꞉ i a꞉no꞉ Godeya꞉no꞉lo꞉b a꞉la꞉asuluma꞉ki, iliyo꞉ Godeya꞉ towo꞉ sa꞉sa꞉la꞉sa꞉ga꞉ kambola꞉sa꞉ga꞉yo꞉, ini misa꞉ amio꞉lo꞉, dagi amio꞉lo꞉ sunu alifela꞉sen. A꞉la꞉ta꞉ga꞉ kaluka꞉isale iliyo꞉ i a꞉no꞉ Godemo꞉lo꞉ tolo꞉ dulugu sa꞉lano꞉lo꞉b a꞉la꞉ bo꞉ba꞉kiyo꞉, iliyo꞉ me sambowo꞉ dia꞉sa꞉ga꞉ inin helebeso꞉g ko꞉lo꞉ migifa sunu alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Iliyo꞉ ma꞉no꞉ alan ma꞉niki kegeakiyo꞉, iyo꞉ kalu alando꞉ sa꞉sena mesa꞉no꞉ asulab. Godeya꞉lo꞉ tolo꞉ wida꞉sen ayamio꞉lo꞉, ilo꞉ mesa꞉no꞉ i fofodo꞉wo꞉ ko꞉li nafale nowa mesa꞉no꞉ asulab. ");
INSERT INTO bco_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Kaluka꞉isaleya꞉yo꞉ iyo꞉ galilia꞉sa꞉ga꞉ sagalakiyo꞉, widan kalu a꞉la꞉sama꞉ki, iyo꞉ kegea꞉sen hen a꞉namio꞉ ho꞉leno꞉ tambo ha꞉na꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ko꞉sega kalu noma꞉yo꞉ ge ‘widan kalu’ a꞉la꞉sama꞉kiyo꞉ dowa꞉so꞉bo. A꞉la꞉ba, mo꞉wo꞉ widan kalu gililo꞉wo꞉ imilise ko꞉lo꞉lab, a꞉la꞉ta꞉ga꞉ gio꞉ tambo gaole dowaki, imilo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","A꞉la꞉ta꞉ga꞉ henfelo꞉ wiyo꞉ giliyo꞉ kalu imilig nowo꞉ go꞉l a꞉la꞉bo꞉ sa꞉la꞉so꞉bo. Mo꞉wo꞉ gili go꞉ldeyo꞉ imilig ko꞉lo꞉lab. E Gode Hebenelo꞉ a꞉labo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","A꞉la꞉ta꞉ga꞉ kalu noma꞉yo꞉ ge wiyo꞉ duludaki, misa꞉ kalu a꞉la꞉sama꞉kiyo꞉ dowa꞉so꞉bo. Mo꞉wo꞉ ge misa꞉ kaluwo꞉ imilig ko꞉lo꞉lab. E Godeya꞉lo꞉ Da꞉feyo꞉ kaluwo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Gi usamio꞉ misa꞉ kalu a꞉lab a꞉ma꞉yo꞉ gili nanogdo꞉ dian kalu dowa꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kaluka꞉isale abeyo꞉ enen wiyo꞉ wabudab a꞉no꞉, Gode eyo꞉ e ha꞉ga ta꞉fa꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ enena꞉ma꞉la꞉yo꞉ ha꞉g amilo꞉ dowab a꞉no꞉, Gode eyo꞉ ene wiyo꞉ wabuluma꞉ki ta꞉fa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Wai, elelo꞉ widan kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. To mosowa꞉lo꞉ widan kalu gio꞉ dinafaka꞉. Kaluka꞉isaleyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉namilo꞉ tina꞉no꞉ tog a꞉no꞉ gili kalita꞉lab. Ginino꞉lo꞉ tog a꞉namio꞉ mo꞉tinaki, kaluka꞉isale a꞉namilo꞉ tiha꞉na꞉no꞉ asulab a꞉no꞉ togo꞉ gili ka꞉la꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Wai, elelo꞉ widan kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. To mosowa꞉lo꞉ widan kalu gio꞉ dinafaka꞉. Gio꞉ henfelo꞉ amio꞉lo꞉, so꞉lu ho꞉n a꞉namio꞉lo꞉ sia꞉likiyo꞉, kalu imilig nowo꞉ gili tili wida꞉sen kalu fa꞉la꞉doma꞉ki, keda꞉li sia꞉sen. Gio꞉ de hen a꞉ma꞉ so꞉wa dowo꞉ ko꞉lo꞉, kalu a꞉no꞉ gili tili widan kalu fa꞉la꞉dowalikiyo꞉, elo꞉ de hen a꞉ma꞉ so꞉wa doma꞉ki ta꞉takiyo꞉, mogago꞉ elo꞉ dimidan a꞉ma꞉yo꞉ mogago꞉ gilo꞉wo꞉ tiginila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Wai, giliyo꞉ kaluka꞉isaleyo꞉ tililia꞉ ha꞉naki bo꞉fo꞉mela꞉no꞉ asulab ko꞉sega, gio꞉ siyo꞉ ko꞉n kalu o꞉ngo꞉ dowab. Giliyo꞉ a꞉la꞉sa꞉lan, ‘Kalu abeyo꞉ ene towo꞉ halale alitakiyo꞉, Godeya꞉ malilo꞉ a a꞉no꞉ ko꞉lo꞉ da꞉fe sa꞉lalega, to elo꞉ sa꞉lab a꞉no꞉ halaido꞉lo꞉ma dowab. Ko꞉sega kalu abeyo꞉ ene towo꞉ halale alitakiyo꞉, go꞉l mole, Godeya꞉ malilo꞉ a amilo꞉ da꞉lab a꞉no꞉ ko꞉lo꞉ da꞉fe sa꞉lalega, to elo꞉ sa꞉lab a꞉no꞉ halaido꞉ dowab ko꞉lo꞉ eyo꞉ mada hendele dimidama꞉no꞉ doma꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gio꞉ asugdo꞉ma dowaki, siyo꞉ ko꞉n kalu dowo꞉. Godeya꞉ siwa꞉l amio꞉ kelego꞉ halaido꞉le wilo꞉wo꞉ o꞉b ko꞉lo꞉ doma꞉iba? Go꞉l mole a꞉no꞉ halaido꞉le wa꞉la꞉bo꞉ o꞉doma꞉iba꞉le? Mo꞉ Godeya꞉ malilo꞉ ayo꞉ nafale wa꞉la꞉bo꞉ o꞉doma꞉iba? Giliyo꞉ a꞉la꞉asuluma. Godeya꞉ malilo꞉ a a꞉ma꞉yo꞉ go꞉l a꞉namilo꞉ da꞉lab a꞉no꞉ Godeya꞉ eno꞉ a꞉la꞉liki fa꞉la꞉do alifa꞉ ko꞉lo꞉, go꞉l a꞉no꞉ halaido꞉wo꞉ a꞉na a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","A꞉la꞉ta꞉ga꞉ giliyo꞉ a꞉la꞉sa꞉lan, ‘Kalu abeyo꞉ ene towo꞉ halale alitakiyo꞉, Godemo꞉lo꞉ so꞉mea꞉sen i fofodo꞉ da꞉lab a꞉no꞉ ko꞉lo꞉ da꞉fe sa꞉lalega, to elo꞉ sa꞉lab a꞉no꞉ halaido꞉lo꞉ma dowab. Ko꞉sega kalu abeyo꞉ ene towo꞉ halale alitakiyo꞉, boba kelego꞉ so꞉mea꞉sen i fofodo꞉ wa꞉l a꞉namilo꞉ da꞉lab a꞉no꞉ ko꞉lo꞉ da꞉fe sa꞉lalega, kalu a꞉ma꞉lo꞉ to sa꞉lab a꞉no꞉ halaido꞉ dowab ko꞉lo꞉, eyo꞉ mada hendele dimidama꞉no꞉ doma꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Sio꞉ ko꞉n kalu giliyo꞉, Godeya꞉ siwa꞉l amio꞉ kelego꞉ halaido꞉le wilo꞉wo꞉ o꞉b ko꞉lo꞉ doma꞉iba? Godemo꞉lo꞉ boba kelego꞉ dimiab a꞉no꞉ halaido꞉le wa꞉la꞉bo꞉ o꞉doma꞉iba꞉le? Mo꞉ Godemo꞉lo꞉ so꞉mea꞉sen i fofodo꞉ a꞉no꞉ halaido꞉le wa꞉la꞉bo꞉ doma꞉iba꞉le? Giliyo꞉ a꞉la꞉asuluma. Godemo꞉lo꞉ so꞉mea꞉sen i fofodo꞉ a꞉ma꞉yo꞉, boba kelego꞉ a꞉no꞉ Godeya꞉ eno꞉ a꞉la꞉liki fa꞉la꞉do alifa꞉ ko꞉lo꞉, bo꞉ba kelego꞉ halaido꞉wo꞉ a꞉na a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","A꞉la꞉fo꞉ko꞉lo꞉ kalu noma꞉yo꞉ ene towo꞉ halale alitakiyo꞉, Godemo꞉lo꞉ so꞉mea꞉sen i fofodo꞉ a꞉no꞉ da꞉feaki sa꞉lalega, kalu a꞉ma꞉yo꞉ Godemo꞉lo꞉ so꞉mea꞉sen i fofodo꞉ a꞉no꞉lia꞉, boba kelego꞉ wa꞉l amilo꞉ da꞉lab a꞉no꞉lia꞉ ko꞉lo꞉ da꞉feaki sa꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ene towo꞉ halale alitakiyo꞉, Godeya꞉ malilo꞉ a a꞉no꞉ da꞉fe sa꞉lalega, kalu a꞉ma꞉yo꞉ Godeya꞉ malilo꞉ a a꞉no꞉lia꞉, Gode malilo꞉ ayamilo꞉ dowa꞉sen a꞉no꞉lia꞉ ko꞉lo꞉ da꞉feaki sa꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ene towo꞉ halale alitakiyo꞉, Hebene hen a꞉no꞉ ko꞉lo꞉ da꞉fe sa꞉lalega, kalu a꞉ma꞉yo꞉ Godelo꞉ sa꞉sen i fofodo꞉ a꞉no꞉lia꞉, Gode i fofodo꞉ a꞉namilo꞉ sab a꞉no꞉lia꞉yo꞉ ko꞉lo꞉ da꞉feaki sa꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Wai, elelo꞉ widan kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. To mosowa꞉lo꞉ widan kalu gio꞉ dinafaka꞉. Mo꞉wo꞉ giliyo꞉ egelo꞉ amio꞉ siabulu fo꞉g o꞉lia꞉ i fo꞉s galin nol o꞉lia꞉yo꞉ kililia꞉sa꞉ga꞉yo꞉, molela꞉su diab a꞉no꞉ do꞉la꞉fo꞉ aloba꞉da꞉sa꞉ga꞉, heb imilise nowo꞉ Godeya꞉ enebo꞉ dimian. Ko꞉sega Godeya꞉ ele amio꞉ wa꞉la꞉b to a꞉no꞉ giliyo꞉ mo꞉kudu ha꞉naki, ka ta꞉ta꞉sen. Ele difa꞉ amilo꞉ wa꞉la꞉b to da꞉labo꞉ we, digalo꞉ aloba꞉dan mano꞉, nofolan mano꞉, a꞉la꞉ta꞉ga꞉ Gode amilo꞉ tilida꞉dan mano꞉ o꞉m. Giliyo꞉ ele saefa꞉ galin nolo꞉lo꞉ mo꞉ga꞉lilaki, wa꞉la꞉b man a꞉no꞉ ko꞉lo꞉ mada dimida꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Giliyo꞉ kaluka꞉isaleyo꞉ tililia꞉ ha꞉naki bo꞉fo꞉mela꞉no꞉ asulab ko꞉sega, gio꞉ siyo꞉ ko꞉n kalu o꞉ngo꞉ dowab. Ho꞉n nakiyo꞉, kiso ha꞉lula꞉su nowo꞉ usa ba꞉dab amio꞉, giliyo꞉ dinafa dila꞉sen. Ko꞉sega no꞉ ka꞉mol alan ho꞉n us amilo꞉ da꞉lab a꞉no꞉, giliyo꞉ tambo ka gamuga꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Wai, elelo꞉ widan kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. To mosowa꞉lo꞉ widan kalu gio꞉ dinafaka꞉. Mo꞉wo꞉ giliyo꞉ kab o꞉lia꞉ disi o꞉lia꞉yo꞉ ha꞉la꞉yo꞉ dinafa to꞉go꞉da꞉sen ko꞉sega, us a꞉namio꞉ man mogago꞉wo꞉ wa꞉lifo꞉ ko꞉lo꞉lab. Man mogago꞉ dimidan a꞉no꞉ we, go꞉no꞉na꞉ma꞉la꞉yo꞉ sagalakiyo꞉, kelego꞉ noma꞉lo꞉wo꞉ asu sa꞉la꞉la꞉lowan. ");
INSERT INTO bco_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fa꞉lisi gio꞉ sio꞉ ko꞉n kalu dowab. Kab ha꞉la꞉yo꞉ nafa fa꞉la꞉doma꞉kiyo꞉, giliyo꞉ tamin amio꞉ kab usami ko꞉le to꞉go꞉da꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Wai, elelo꞉ widan kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. Madali tolo꞉ sa꞉lan kalu gio꞉ dinafaka꞉. Giliyo꞉ kalu daido꞉ ha꞉la꞉ amio꞉ dinafa momada꞉sen, ko꞉sega usamio꞉ sowo꞉ ki o꞉lia꞉ do꞉mo꞉ heseyo꞉ o꞉lia꞉yo꞉ wa꞉lifo꞉lab. Gio꞉ o꞉leo꞉ngo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kalu nolba꞉yo꞉ gi do꞉mo꞉ ba꞉dakiyo꞉, ge digalo꞉ kalu a꞉la꞉asuluma꞉ib. Ko꞉sega gili asulo꞉ usamio꞉ dikidan man o꞉lia꞉ ele o꞉go꞉san man o꞉lia꞉yo꞉ wa꞉lifo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Wai, elelo꞉ widan kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. To mosowa꞉lo꞉ widan kalu gio꞉ dinafaka꞉. Giliyo꞉ dinali sa꞉lan kalu sowo꞉lo꞉ daido꞉ wa꞉l a꞉namio꞉ ayo꞉ nafale dialitaki, digalo꞉ kalu sowo꞉lo꞉ daido꞉ a꞉no꞉lo꞉ nafale momade alita꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Giliyo꞉ towo꞉ a꞉la꞉sa꞉la꞉sen, ‘Nio꞉ ni ma꞉mu ima꞉ ho꞉len a꞉na elen kibo꞉bowo꞉, nio꞉ i o꞉lia꞉ dowakiyo꞉, dinali sa꞉lan kaluwo꞉ mada mo꞉sana somo꞉lo.’ ");
INSERT INTO bco_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","To wema꞉yo꞉ ginina꞉ma꞉la꞉yo꞉ a꞉la꞉widab. Gio꞉ dinali sa꞉lan kalulo꞉ sana sowa꞉sen i a꞉ma꞉ so꞉wayo꞉ gika꞉ a꞉la꞉widakigab. ");
INSERT INTO bco_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","A꞉la꞉go꞉ko꞉lo꞉ gio꞉ ha꞉na꞉sa꞉ga꞉, sana sowa꞉sen man gi ma꞉mu ima꞉lo꞉ mo꞉mo꞉da dimido꞉ a꞉no꞉, giliyo꞉ ilili alifa꞉niki hamana. ");
INSERT INTO bco_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gio꞉ sowa꞉ mogago꞉, kisa꞉wa꞉la꞉ inso꞉ o꞉ngo꞉ dowab. Gode eyo꞉ gio꞉ mo꞉walila꞉sa꞉ga꞉, de hena hamana a꞉la꞉sa꞉ma꞉ib ko꞉lo꞉, giliyo꞉ a꞉no꞉ waga begelema꞉iba? ");
INSERT INTO bco_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ dabuma! Niyo꞉ dinali sa꞉lan kaluwo꞉lo꞉, asulo꞉ nafalo꞉ di kaluwo꞉lo꞉, a꞉la꞉ta꞉ga꞉ elelo꞉ widan kalu o꞉lia꞉yo꞉ gilo꞉wa iliga꞉to꞉l. Ko꞉sega giliyo꞉ kalu i a꞉no꞉ nolo꞉ sana sowaki, i malana aluma꞉ib. Nolo꞉ Godeya꞉ tolo꞉ wida꞉sen a us a꞉na yame tandema꞉ib. A꞉la꞉ta꞉ga꞉ nolo꞉ amisa꞉n nowa nowa a꞉la꞉ o꞉lusa꞉nda꞉i ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","A꞉la꞉go꞉ko꞉lo꞉ henfelo꞉ we ho꞉gi dimido꞉ a꞉na a꞉la꞉ta꞉ga꞉lo꞉ mio꞉ a꞉namio꞉, digalo꞉ kalu ko꞉lo꞉ ililo꞉ yasala꞉likilo꞉ ho꞉bo꞉ tulo꞉ a꞉ma꞉ wa꞉lo꞉ tambo gili dia꞉ib. A꞉iboldo꞉ sana sowo꞉ a꞉na a꞉la꞉ta꞉ga꞉lo꞉ mio꞉wo꞉, Belekia so꞉wa Sekalaya elo꞉ sana sowab a꞉na edakiyo꞉, wa꞉lo꞉ tambo gi dia꞉ib. Giliyo꞉ bobalo꞉ so꞉mea꞉no꞉ u dibido꞉ a꞉no꞉ nol a꞉la꞉ta꞉ga꞉ Godeya꞉ malilo꞉ ayo꞉ nol a꞉lo꞉ us a꞉namio꞉ Sekalaya e a꞉na sana sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Niyo꞉ to we hendele gimo꞉ sa꞉ma꞉nigo꞉l. Man mogago꞉wa꞉ wa꞉l dimea꞉no꞉ a꞉no꞉ tambo, kaluka꞉isale o꞉gdo꞉ sab wema꞉ dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Ya꞉su eyo꞉ to heb a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉. “Ha꞉iyo꞉ Ya꞉lusalem, Ya꞉lusalem. Giliyo꞉ dinali sa꞉lan kaluwo꞉ sana sowa꞉sen. A꞉la꞉ta꞉ga꞉ Godeya꞉ tolo꞉ dia꞉ya꞉lab kalu i a꞉no꞉lo꞉ uwa꞉ agoda꞉sa꞉ga꞉ sana sowa꞉sen. Gogonowa꞉lo꞉ inso꞉wo꞉ ene a꞉fula꞉ ha꞉g amilo꞉ kegenelia꞉ga꞉ galalan o꞉leaumbo꞉, niyo꞉ Ya꞉lusalem kaluka꞉isale gio꞉ a꞉la꞉kegenelia꞉ga꞉ galama꞉no꞉ a꞉la꞉ asula꞉len ko꞉sega, gio꞉ nemo꞉wo꞉ a꞉la꞉dimidama꞉kiyo꞉ mo꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Bo꞉ba! Godeya꞉ ene ayo꞉ gi dagiya dia꞉ta꞉ga꞉ ta꞉fo꞉gane, ko꞉sega o꞉go꞉ a a꞉no꞉ awafi elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Gio꞉ ne misio꞉ wa꞉kabiyo꞉ mo꞉ba꞉ba꞉ib. Ko꞉sega giliyo꞉ towo꞉ a꞉la꞉sa꞉lalikiyo꞉, ‘Kalu we, Gode Alana꞉ wiya a꞉la꞉ta꞉ga꞉ mio꞉ ko꞉lo꞉, niliyo꞉ sagala꞉liki, Godemo꞉ mada o꞉m a꞉la꞉so꞉lo꞉l’ to a꞉no꞉ sa꞉lalikiyo꞉, ho꞉len a꞉nami o꞉isa, ne wa꞉ka ba꞉ba꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ya꞉su e Godeya꞉ malilo꞉ a a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nab amio꞉, enedo꞉ tili wida꞉sen kaluwo꞉ elo꞉wa ya꞉ga꞉, Godeya꞉ malilo꞉ ayamilo꞉ a nafale ko꞉li ko꞉lilo꞉ a꞉no꞉ e bo꞉ba꞉ki da꞉feyo꞉. ");
INSERT INTO bco_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ko꞉sega Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ a di a꞉no꞉ tambo ba꞉ba꞉ya꞉le? Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Gililo꞉ o꞉gdo꞉ ba꞉dab we, tif amio꞉ a we tambo bidi ha꞉naki, u noma꞉ wa꞉l amilo꞉ dinafa a꞉lab we aumbo꞉, mada mo꞉da꞉lena ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ya꞉suwo꞉ O꞉lif misio꞉wa sen amio꞉, enedo꞉ tili wida꞉sen kaluwo꞉ egelese elo꞉wa fa꞉la꞉dowakiyo꞉, iliyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gilo꞉ sa꞉lab we ho꞉leno꞉ iga꞉sa fa꞉la꞉doma꞉iba? Ge nilo꞉ amio꞉ fa꞉la꞉doma꞉nigabo꞉lo꞉b a꞉la꞉do꞉ asuluma꞉no꞉wo꞉, niliyo꞉ waga ele ba꞉ba꞉no꞉wo꞉? A꞉la꞉ta꞉ga꞉ ta꞉i mio꞉ ho꞉len we elema꞉nigabo꞉lo꞉b a꞉la꞉do꞉ asuluma꞉no꞉wo꞉, niliyo꞉ waga ele ba꞉ba꞉no꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Madali tolo꞉ sa꞉lan kaluwa꞉yo꞉ gio꞉ dikidabena꞉ki, giliyo꞉ to sa꞉labo꞉ dinafa alobana ba꞉da꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Mo꞉wo꞉ kalu modo꞉wo꞉ ne wiya a꞉la꞉ta꞉ga꞉ ya꞉siakiyo꞉, ‘Godeya꞉lo꞉ Da꞉feyo꞉ kaluwo꞉ neka꞉’ a꞉la꞉sa꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ iliyo꞉ kaluka꞉isale modo꞉wo꞉ a꞉la꞉ dikili sa꞉lakiyo꞉, hala tililia꞉ ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Henfelo꞉ wenamio꞉ bubo꞉wo꞉ fa꞉la꞉dowalikiyo꞉lo꞉, bubaka꞉ a꞉la꞉do꞉ sio꞉wo꞉ fowo꞉ da꞉dalikiyo꞉lo꞉, gio꞉ kele asulakiyo꞉ tagila꞉so꞉bo. Mo꞉wo꞉ dimido꞉ we tamina fa꞉la꞉doma꞉ib, ko꞉sega elema꞉no꞉wo꞉ semo꞉fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Henfelo꞉ wenamio꞉ hen alan no o꞉lia꞉ hen alan no o꞉lia꞉yo꞉ gis diaki bubo꞉wo꞉ alan fa꞉la꞉dowa꞉i ha꞉na꞉ib. A꞉la꞉ta꞉ga꞉ misa꞉ kalu no o꞉lia꞉ no o꞉lia꞉yo꞉ babuma꞉ib. Hen nol amio꞉ hiniyo꞉ alan tima꞉ib a꞉la꞉ta꞉ga꞉ hen nol amio꞉ egelo꞉wo꞉ mo꞉fa꞉la꞉ndaliki, kaluka꞉isaleyo꞉ maiyo꞉wo꞉ alan doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Hida꞉yo꞉ a꞉no꞉ fa꞉la꞉dowalikiyo꞉, gaya꞉lo꞉ so꞉wa sa꞉la꞉lia꞉nikilo꞉ nagalo꞉ tamin amilo꞉ mo꞉mo꞉da ba꞉dan au fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Kalu nolba꞉yo꞉ gio꞉ teledowaki ta꞉lia꞉sa꞉ga꞉yo꞉, yamelaki sana soma꞉ib. Gio꞉ ni wiyo꞉ ta꞉lisab ko꞉lo꞉ kaluka꞉isale tambowa꞉yo꞉ gimo꞉wo꞉ kulufa꞉yo꞉wo꞉ alan doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","A꞉la꞉ta꞉ga꞉ ho꞉len a꞉namio꞉ kaluka꞉isale ne amilo꞉ tilidabu a꞉no꞉ modo꞉wo꞉ ta꞉ta꞉sa꞉ga꞉ ha꞉na꞉ib. Iliyo꞉ egelebo꞉ mo꞉bea꞉sa꞉ga꞉yo꞉, nolo꞉ teledowaki gis kaluwa꞉ dagiya dia꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Madalilo꞉ dinali sa꞉lan kaluwo꞉ ya꞉siakiyo꞉, iliyo꞉ kaluka꞉isale modo꞉wo꞉ dikidaki, hala tililia꞉ ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Henfelo꞉ wiyo꞉ man mogago꞉wo꞉ mada alan fa꞉la꞉dowalikiyo꞉, kaluka꞉isale nol o꞉lia꞉lo꞉ ha꞉fo꞉ disa꞉lan man a꞉no꞉ ti ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko꞉sega kalu abeyo꞉ hida꞉yo꞉ a꞉namio꞉ halaido꞉ dofo꞉ko꞉ ha꞉na꞉la꞉ga꞉ eleya edalega, Gode eyo꞉ e asuwa꞉takiyo꞉ a꞉ma꞉la꞉ gasilia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kaluka꞉isaleyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉ma꞉ to nafa a꞉no꞉ dabuma꞉kiyo꞉, to a꞉no꞉ henfelo꞉ amio꞉ tambo wida꞉li ha꞉na꞉ib. A꞉la꞉ta꞉ga꞉ a꞉ma꞉ fa꞉s amio꞉, ta꞉i mio꞉ ho꞉len we ko꞉lo꞉ elema꞉no꞉wo꞉ a꞉na fa꞉la꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","“Tamin amilo꞉ dinali sa꞉lan kalu Da꞉niol elo꞉ sio꞉ a꞉no꞉ giliyo꞉ fa꞉la꞉dowaliki ba꞉ba꞉ib. Godeya꞉ malilo꞉ ayamio꞉, kelego꞉ mogago꞉le nowo꞉ a꞉na fa꞉la꞉dowaliki, ayo꞉ mo꞉mesa꞉no꞉ doma꞉ib ko꞉lo꞉, a a꞉no꞉ o꞉ngo꞉malo꞉ngo꞉ dowaki gab. Giliyo꞉ to we agelakiyo꞉, dinafa asula꞉bi. Gio꞉ kelego꞉ a꞉no꞉ ba꞉dalikiyo꞉, Yudia hen amilo꞉ sen kaluka꞉isale a꞉no꞉ tambo, gio꞉ misio꞉ doba꞉da꞉ dalalelia꞉ga꞉ ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kalu ene a wa꞉l amilo꞉ sen a꞉no꞉ tina꞉sa꞉ga꞉yo꞉, a꞉ma꞉la꞉ a usamio꞉ kelego꞉wo꞉ dia꞉ni ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","A꞉la꞉ta꞉ga꞉ kalu egelo꞉ amilo꞉ elen a꞉no꞉, ene helebeso꞉g sambo ayamilo꞉ da꞉lab a꞉no꞉ e a꞉ma꞉la꞉yo꞉ dia꞉ni ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Wai, ho꞉len a꞉namio꞉ ka꞉isale so꞉walo꞉ alela꞉sen o꞉lia꞉ so꞉wamo꞉lo꞉ bolo꞉ mea꞉lab ka꞉isale a꞉no꞉lia꞉yo꞉ mada halaido꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Gilo꞉ dalalema꞉no꞉ ho꞉len a꞉no꞉, ta꞉n ho꞉len a꞉namiya꞉le, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namiya꞉le fa꞉la꞉dowabena꞉ki, Godemo꞉ dulugu sa꞉la꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mo꞉wo꞉ o꞉g ho꞉len a꞉namio꞉ hida꞉yo꞉wo꞉ mada alan badio꞉ fa꞉la꞉doma꞉nigab. Henfelo꞉ we ho꞉gi mo꞉mo꞉do꞉wa a꞉la꞉ta꞉ga꞉lo꞉ mio꞉ a꞉namio꞉, hida꞉yo꞉ wengo꞉wo꞉ mo꞉fa꞉la꞉dowa꞉i mio꞉. A꞉la꞉ta꞉ga꞉ tifamio꞉lo꞉ hida꞉yo꞉ wengo꞉wo꞉ wa꞉kabiyo꞉ mo꞉fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Hida꞉yo꞉ ho꞉len a꞉no꞉ Gode eyo꞉ mo꞉abolda꞉la꞉ kibo꞉bowo꞉, kaluka꞉isaleyo꞉ mo꞉gasiliaki, tambo yasalemabe. Ko꞉sega Gode eyo꞉ kaluka꞉isale enedo꞉ da꞉fe alifa꞉ a꞉no꞉ asulakiyo꞉, hida꞉yo꞉ ho꞉len a꞉no꞉ abolda꞉su doma꞉ki ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ho꞉len a꞉namio꞉ kalu noma꞉yo꞉ gimo꞉ sa꞉lakiyo꞉, ‘Gio꞉ bo꞉ba! Godeya꞉lo꞉ da꞉feyo꞉ kaluwo꞉ wena sab’ a꞉la꞉ta꞉ga꞉ kalu noma꞉ sa꞉lakiyo꞉, ‘Godeya꞉lo꞉ da꞉feyo꞉ kaluwo꞉ honona sab’ a꞉la꞉sa꞉lalega, giliyo꞉ to a꞉no꞉ tilida꞉da꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Mo꞉wo꞉ ho꞉len a꞉namio꞉, madali Keliso o꞉lia꞉ madalilo꞉ dinali sa꞉lan kaluwo꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉dowakiyo꞉, molo ha꞉na꞉no꞉ alandeyo꞉ ko꞉li ko꞉lilo꞉wo꞉ dimidama꞉ib. Iliyo꞉ Godeya꞉lo꞉ da꞉fe alifa꞉ kaluka꞉isale a꞉no꞉ ko꞉lo꞉ dikilima꞉no꞉laki auma꞉ib ko꞉sega iliyo꞉ mo꞉ililima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Asuluma! Niyo꞉ dimido꞉ we o꞉fa꞉la꞉doma꞉nigabiki, to we gimo꞉wo꞉ hagugu so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ gimo꞉ sa꞉lakiyo꞉, ‘Keliso e kalaleli hena a꞉laka꞉’ a꞉la꞉sa꞉lalega, gio꞉ a꞉namio꞉ ha꞉na꞉so꞉bo. A꞉la꞉ta꞉ga꞉ ili sa꞉lakiyo꞉, ‘Keliso e a us wena sab,’ a꞉la꞉sa꞉lalega, gio꞉ to ililo꞉ sa꞉lab a꞉no꞉ tilida꞉da꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mo꞉wo꞉ ofdo꞉ yan doba꞉da꞉ a꞉la꞉ta꞉ga꞉ ofdo꞉ tinan doba꞉da꞉ a꞉namilo꞉ wabelego꞉ tililakilo꞉ ho꞉lea꞉tan o꞉leaumbo꞉, Kalule Dowo꞉ ko꞉lo꞉ mia꞉nigab a꞉no꞉ o꞉leo꞉ngo꞉ fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Giyo꞉ o꞉ba꞉ salageyo꞉ akina hega꞉lena ba꞉dalikiyo꞉, us a꞉namio꞉ no꞉ heseyo꞉ nowo꞉ a꞉na da꞉laliki auma꞉ib a꞉la꞉asula꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ko꞉sega ho꞉len a꞉namio꞉, hida꞉yo꞉ a꞉no꞉ fa꞉la꞉dowa꞉sa꞉ga꞉ edalikiyo꞉, “ ‘Ofo꞉ sololiakiyo꞉, ele hego꞉ mo꞉doma꞉ib. Tamin akin amilo꞉ a꞉no꞉ dogaselia꞉ tina꞉ib, a꞉la꞉ta꞉ga꞉ Akin amilo꞉ halaido꞉lo꞉ a꞉lab kelego꞉ a꞉no꞉ ida꞉li alifelema꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","A꞉la꞉do꞉ dimidab ho꞉len a꞉namio꞉, Kalule Dowo꞉ e ko꞉lo꞉ ele ba꞉ba꞉no꞉wo꞉ akina fa꞉la꞉dowaliki ba꞉ba꞉ib ko꞉lo꞉, henfelo꞉ kaluka꞉isaleyo꞉ tambo nofolaki ya꞉lima꞉ib. A꞉la꞉ta꞉ga꞉ Kalule Dowo꞉wo꞉ ene halaido꞉ o꞉lia꞉ ho꞉len fo꞉fo꞉lesodo꞉ alan o꞉lia꞉ kola꞉ wa꞉la fa꞉la꞉dowalikiyo꞉, kaluka꞉isaleya꞉yo꞉ ini siya꞉ ba꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","A꞉la꞉ta꞉ga꞉ olo buluwo꞉ folalikiyo꞉, eyo꞉ ene ma꞉mula꞉ kaluwo꞉ henfelo꞉ we tambo, ofdo꞉ fa꞉la꞉dowan do꞉wa a꞉la꞉ta꞉ga꞉ ofdo꞉ tinana iliga꞉felema꞉ib. Iyo꞉ ha꞉nakiyo꞉, Godeya꞉lo꞉ da꞉fe alifelo꞉ kaluka꞉isale a꞉no꞉ tambo kegenema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Gio꞉ asulo꞉wo꞉ alona꞉ iya dia꞉bi. Alona꞉ i amio꞉ musugo꞉ fa꞉la꞉dota꞉ga꞉ fo꞉so꞉ imolo꞉ dowalikiyo꞉, imo ho꞉leno꞉ ko꞉na꞉ma fa꞉la꞉doma꞉nigab a꞉la꞉asula꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","A꞉la꞉do꞉ gan o꞉leaumbo꞉, nilo꞉ tambolo꞉ so꞉lo꞉l a꞉no꞉ hendele fa꞉la꞉dowaliki ba꞉dakiyo꞉, giliyo꞉ e ko꞉na꞉ma fa꞉la꞉doma꞉niki, toga꞉ meya kagayab a꞉la꞉asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Kaluka꞉isale o꞉gdo꞉ sab we semo꞉sowo꞉ o꞉elenka, nilo꞉ tambolo꞉ so꞉lo꞉l a꞉no꞉ hendele fa꞉la꞉doma꞉nigab. ");
INSERT INTO bco_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Henfelo꞉ o꞉lia꞉ akin o꞉lia꞉yo꞉ kelege doma꞉ib, ko꞉sega ni towo꞉ mada mo꞉kelegema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nilo꞉ so꞉lo꞉l a꞉no꞉ ko꞉lo꞉ fa꞉la꞉doma꞉no꞉wo꞉, ho꞉len o꞉lia꞉ ofa꞉si o꞉lia꞉yo꞉ kaluka꞉isaleyo꞉ tambowa꞉yo꞉ mo꞉asulo꞉ ko꞉lo꞉lab. Ma꞉mula꞉ kalu Hebenelo꞉ a꞉labo꞉lo꞉, Godeya꞉ So꞉wayo꞉lo꞉ ho꞉len a꞉no꞉ mo꞉asulo꞉ ko꞉sega, Do Godeya꞉ ina꞉li asulufo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noa ho꞉len amilo꞉ dimida꞉len o꞉leaumbo꞉, Kalule Dowo꞉lo꞉ fa꞉la꞉doma꞉nigab ho꞉len a꞉namio꞉lo꞉ a꞉la꞉ka dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Noa ho꞉len amio꞉ ho꞉n dia꞉yo꞉ o꞉semo꞉ mio꞉ amio꞉, kaluka꞉isaleyo꞉ ma꞉no꞉ na꞉liki, ho꞉no꞉ na꞉liki, gayo꞉ dia꞉liki, inso꞉mo꞉wo꞉ gayo꞉ tili alita꞉liki aneyo꞉, Noayo꞉ ho꞉n ko꞉suwa tinab amio꞉lo꞉, iliyo꞉ a꞉la꞉ka dimida꞉li ha꞉na꞉len. ");
INSERT INTO bco_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kaluka꞉isale iliyo꞉ fa꞉la꞉doma꞉nigab a꞉no꞉ mo꞉asulufo꞉liki elena, ho꞉n galusana yakiyo꞉, i a꞉no꞉ tambo yasa danela꞉. A꞉la꞉do꞉ dimido꞉ o꞉leaumbo꞉, Kalule Dowo꞉ elo꞉ fa꞉la꞉dowab a꞉namio꞉lo꞉ a꞉la꞉ka dimidama꞉nigab. ");
INSERT INTO bco_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ho꞉len a꞉namio꞉, kalu a꞉la꞉ nowo꞉ egelo꞉wa elena, nowo꞉ diaki, nowo꞉ ka ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ga a꞉la꞉ nowo꞉ ida꞉ni ma꞉n besea꞉lena, nowo꞉ diaki, nowo꞉ ka ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“A꞉la꞉fo꞉ko꞉lo꞉ gili Kalu Alando꞉ mia꞉no꞉ ho꞉len a꞉no꞉ mo꞉asulo꞉ ko꞉lo꞉, giliyo꞉ yasi siliki bo꞉fo꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ko꞉sega gio꞉ to we asuluma. Alo꞉ biso꞉ a꞉ma꞉yo꞉ afalo꞉ dian kalu mia꞉no꞉wo꞉ ofa꞉siyo꞉ asulo꞉ kibo꞉bowo꞉, e sikaga siliki bo꞉fo꞉len ko꞉lo꞉, afalo꞉ dian eyo꞉ a a꞉no꞉ bidila꞉sa꞉ga꞉ usa timana꞉kiyo꞉ mo꞉ta꞉fabe. ");
INSERT INTO bco_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","A꞉la꞉fo꞉ko꞉lo꞉ gio꞉lo꞉ mada dimidalia꞉sa꞉ga꞉ yasi dowa꞉lubi. Mo꞉wo꞉ Kalule Dowo꞉wo꞉ gilido꞉ e mo꞉mia꞉ib a꞉la꞉do꞉ asulufo꞉len ho꞉len a꞉nami mia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Nanogdo꞉ dian kalu nafa a꞉no꞉ niyo꞉ gimo꞉ walama꞉nigo꞉l. E asulo꞉wo꞉ nafa diaki, ene misa꞉ kaluwa꞉lo꞉ to sa꞉lab a꞉no꞉ tilida꞉da꞉sa꞉ga꞉ dimida꞉sen. Misa꞉ kalu a꞉ma꞉yo꞉ kalu o꞉leo꞉ngo꞉wo꞉ da꞉fealikiyo꞉, nanogdo꞉ dian kalu a꞉ma꞉yo꞉ nanogdo꞉ dian kalu nolo꞉ bo꞉fo꞉liki, ho꞉lende amio꞉ ma꞉no꞉wo꞉ imo꞉wo꞉ sa꞉ga꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Misa꞉ kaluwo꞉ a꞉ma꞉la꞉ yaki ba꞉ba꞉ amio꞉, ene nanogdo꞉ dian kalu a꞉no꞉ ko꞉lo꞉ nanogo꞉ nafale a꞉la꞉ dia꞉lena ba꞉dalikiyo꞉ emo꞉wo꞉ sagale alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Niyo꞉ gimo꞉wo꞉ hendele sa꞉ma꞉nigo꞉l. Misa꞉ kalu eyo꞉ ene kelego꞉ a꞉no꞉ tambo bo꞉fo꞉melea꞉ki, nanogdo꞉ dian kalu a꞉no꞉ko꞉ da꞉fe alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","49","Ko꞉sega nanogdo꞉ dian kalu nowo꞉ mogago꞉lalega, eyo꞉ ‘Ni misa꞉ kaluwo꞉ bo꞉ebo꞉ mo꞉mia꞉nigab’ a꞉la꞉asulakiyo꞉, nanogdo꞉ dian kalu nolo꞉ e yame tandeaki a꞉la꞉ta꞉ga꞉ e ma꞉no꞉ o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ no꞉nola꞉sen kalu o꞉lia꞉ siliki ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","A꞉la꞉galikiyo꞉ misa꞉ kalulo꞉ a꞉ma꞉la꞉ mia꞉nigab a꞉no꞉, nanogdo꞉ dian kalu e ho꞉leno꞉ mo꞉dimidalia꞉ga꞉ elena a꞉la꞉ta꞉ga꞉ ofa꞉siyo꞉lo꞉ e mo꞉asulo꞉ elen a꞉nami, misa꞉ kaluwo꞉ a꞉na mia꞉ib. A꞉la꞉ta꞉ga꞉ misa꞉ kalu eyo꞉ ene nanogdo꞉ dian kalu a꞉no꞉ alan falasilakiyo꞉, madali tolo꞉ sa꞉lan kalu a꞉no꞉lia꞉ mesea꞉ki ta꞉fa꞉ib. Hen a꞉namio꞉ iyo꞉ kulufa꞉yakiyo꞉, ya꞉foda꞉li mesa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Ya꞉su eyo꞉ bale sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ walama꞉nikiyo꞉, niyo꞉ ga bolo꞉ do꞉la꞉fo꞉ a꞉no꞉ ko꞉lo꞉ bale sa꞉ma꞉nigo꞉l. Iliyo꞉ ini nafayo꞉ do꞉lia꞉sa꞉ga꞉, kalu so꞉wa galo꞉ tili alifa꞉no꞉lo꞉ yab a꞉no꞉ galima꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ga bolo꞉ bila꞉fo꞉ nolo꞉ asugdo꞉ma ka꞉isale, a꞉la꞉ta꞉ga꞉ ga bolo꞉ bila꞉fo꞉ nolo꞉ asulo꞉lo꞉ di nafa ka꞉isale. ");
INSERT INTO bco_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Asugdo꞉ma ga bila꞉fo꞉ a꞉ma꞉yo꞉ nafa moso ko꞉ diaki, wa ho꞉no꞉ mo꞉dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ko꞉sega asulo꞉lo꞉ di ka꞉isale iliyo꞉ nafayo꞉ diaki, wa ho꞉n nowo꞉lo꞉ wasuliaki a꞉la꞉ta꞉ga꞉ inin o꞉lia꞉ dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kalu so꞉wa galo꞉ dia꞉no꞉ a꞉no꞉ bo꞉ebo꞉ mo꞉mio꞉ dowabikiyo꞉, ga bolo꞉ do꞉la꞉fo꞉ a꞉no꞉ tambo mida꞉iyaki alima꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ko꞉sega iyo꞉ alifo꞉labikiyo꞉, nulu us a꞉namio꞉ ho꞉ido꞉ nowo꞉ a꞉na fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, ‘Kalu so꞉wa galo꞉ tili alifa꞉no꞉wo꞉ e o꞉go꞉ mio꞉ka꞉! E galima꞉ni handalota꞉ga꞉ meno꞉.’ ");
INSERT INTO bco_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","A꞉la꞉gabiki ga bolo꞉ i a꞉no꞉ tambo dasila꞉sa꞉ga꞉, nafa inido꞉wo꞉ dinafa kedo꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Asugdo꞉ma ka꞉isale a꞉ma꞉yo꞉ asulo꞉lo꞉ di i o꞉mo꞉wo꞉ a꞉la꞉sio꞉, ‘Giliyo꞉ wa ho꞉n nolo꞉ nilo꞉ dimena. Nili wa ho꞉no꞉ kedetaki, ho꞉leno꞉ dalifa꞉nigab,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ko꞉sega asugdo꞉ di a꞉ma꞉yo꞉ a꞉ma꞉la꞉ sa꞉laki a꞉la꞉sio꞉, ‘Nililo꞉ a꞉no꞉ko꞉ negele ka guma꞉no꞉wo꞉ mo꞉ililo꞉ ko꞉lo꞉, gio꞉ a꞉ma꞉la꞉ ha꞉na꞉ga꞉ wa ho꞉n o꞉lo꞉ dia꞉sendo꞉ a꞉na a꞉kililia꞉ni hamana,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ wa ho꞉n a꞉no꞉ o꞉kililia꞉no꞉ a꞉la꞉ta꞉ga꞉ ha꞉na꞉labikiyo꞉, galo꞉ same kalu a꞉no꞉ mio꞉ ko꞉lo꞉, e o꞉lia꞉ dimidalia꞉ga꞉ elen ka꞉isale i o꞉lia꞉yo꞉ ma꞉no꞉ ma꞉niki a usa tina꞉sa꞉ga꞉yo꞉, togo꞉ uludu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Tif amio꞉ ga bolo꞉ nol i a꞉no꞉ ya꞉ga꞉ fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, ‘Kalu Alan, Kalu Alan togo꞉ nilo꞉ kolama.’ ");
INSERT INTO bco_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ko꞉sega eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, ‘Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Ne gio꞉ mo꞉asulo꞉.’ ");
INSERT INTO bco_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ Kalu Alando꞉ fa꞉la꞉doma꞉nigab ho꞉len o꞉lia꞉ ofa꞉si o꞉lia꞉yo꞉ mo꞉asulo꞉ ko꞉lo꞉, giliyo꞉ yasi dofo꞉liki, dinafa bo꞉fo꞉melea.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ya꞉su eyo꞉ wa꞉ka bale sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ walama꞉nikiyo꞉, niyo꞉ bale sa꞉ma꞉nigo꞉l. Kalu nowo꞉ hen ko꞉na꞉ nowa sia꞉mela꞉no꞉ ha꞉na꞉nikiyo꞉, ene nanogdo꞉ dian kaluwo꞉ ho꞉le kegea꞉sa꞉ga꞉, e ko꞉na꞉ hen nowa sab a꞉namio꞉ ene kelego꞉ a꞉no꞉ iliyo꞉ bo꞉fo꞉melea꞉ki, imo꞉ dia꞉ta꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Kalu a꞉ma꞉yo꞉ nanogdo꞉ dian kaluwa꞉ asulo꞉wo꞉ da꞉fe ba꞉da꞉sa꞉ga꞉, ina꞉li ina꞉li a꞉la꞉do꞉ ililo꞉ au aloba꞉da꞉i ane. Kalu nowo꞉mbo꞉wo꞉ moleyo꞉ daosen bila꞉fo꞉ ko꞉lo꞉ dimi. Kalu nowo꞉mbo꞉wo꞉ moleyo꞉ daosen a꞉la꞉ ko꞉lo꞉ dimi. A꞉la꞉ta꞉ga꞉ kalu nowo꞉mbo꞉wo꞉ moleyo꞉ daosen imilig ko꞉lo꞉ dimi. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ e ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kalu mole daosen bila꞉fo꞉lo꞉ di a꞉ma꞉yo꞉ o꞉g ho꞉len a꞉naka dia꞉ha꞉na꞉ga꞉yo꞉, mole a꞉ma꞉yo꞉ nanogo꞉ dimido꞉ kolo꞉, mole daoseno꞉ bila꞉fo꞉ nowo꞉ a꞉di. ");
INSERT INTO bco_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","A꞉la꞉ta꞉ga꞉ kalu daosen a꞉la꞉lo꞉ di a꞉ma꞉yo꞉lo꞉ a꞉la꞉ka dimido꞉ kolo꞉, eyo꞉lo꞉ daosen a꞉la꞉ nowo꞉ wa꞉ka a꞉di. ");
INSERT INTO bco_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko꞉sega kalu daosen imiligdo꞉ di a꞉ma꞉yo꞉ mole a꞉no꞉ dia꞉ha꞉na꞉sa꞉ga꞉yo꞉, ene misa꞉ kaluwa꞉ mole a꞉no꞉ heno꞉ daida꞉sa꞉ga꞉ wo꞉no꞉le difa꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“A꞉la꞉fo꞉ko꞉lo꞉ ho꞉len modo꞉wo꞉ a꞉la꞉ga꞉yo꞉, misa꞉ kaluwo꞉ a꞉ma꞉la꞉ ya꞉ga꞉, ene nanogdo꞉ dian kalu i o꞉lia꞉ siliki, mole imo꞉lo꞉ dimi a꞉no꞉ nanogo꞉ waga dimido꞉wa꞉le a꞉la꞉liki dinafa alobana kedo꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kalu daoseno꞉ bila꞉fo꞉lo꞉ di a꞉no꞉, mole daoseno꞉ bila꞉fo꞉ nowo꞉ elo꞉ a꞉di a꞉no꞉lia꞉ dia꞉ga꞉, misa꞉ kalulo꞉wa yakiyo꞉ a꞉la꞉sio꞉, ‘Kalu alan, giyo꞉ nemo꞉wo꞉ daosen bila꞉fo꞉ dimi ko꞉lo꞉, niyo꞉ daosen bila꞉fo꞉ nowo꞉ a꞉fa꞉la꞉do alifa꞉ a꞉no꞉lo꞉ we.’ ");
INSERT INTO bco_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","A꞉la꞉sa꞉labiki ene misa꞉ kalu a꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ‘Ge nanogdo꞉ dian kalu mada nafa ko꞉lo꞉, nilo꞉ to sa꞉labo꞉ giyo꞉ kudu ha꞉naki dimida꞉sen. Giyo꞉ kelego꞉ a꞉la꞉seyo꞉ dinafa tili doma꞉no꞉lo꞉biki, niyo꞉ kelego꞉ modo꞉wo꞉ gi bo꞉fo꞉melea꞉ki ta꞉fa꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ gelo꞉ ne o꞉lia꞉ sagalema꞉ni mena.’ ");
INSERT INTO bco_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“A꞉la꞉gabiki kalu daosen a꞉la꞉lo꞉ di a꞉ma꞉yo꞉lo꞉ dia꞉ya꞉ga꞉ kagayakiyo꞉ a꞉la꞉sio꞉, ‘Misa꞉ kalu gio꞉ nemo꞉wo꞉ mole daosen a꞉la꞉ dimi ko꞉lo꞉, niyo꞉ daosen a꞉la꞉ nowo꞉ a꞉fa꞉la꞉do alifa꞉ a꞉no꞉lo꞉ we,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ene misa꞉ kalu a꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ‘Ge nanogdo꞉ dian kalu mada nafa ko꞉lo꞉, nilo꞉ to sa꞉labo꞉ giyo꞉ kudu ha꞉naki dimida꞉sen. Giyo꞉ kelego꞉ a꞉la꞉se a꞉no꞉ dinafa tili doma꞉no꞉lo꞉biki, niyo꞉ kelego꞉ modo꞉ nolo꞉ gi bo꞉fo꞉melea꞉ki ta꞉fa꞉no꞉. A꞉la꞉fo꞉ko꞉lo꞉ gelo꞉ ne o꞉lia꞉ sagalema꞉ni mena.’ ");
INSERT INTO bco_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“A꞉la꞉ta꞉ga꞉ kalu daosen imiligdo꞉ di a꞉no꞉lo꞉ ya꞉ga꞉ kagayaki a꞉la꞉sio꞉, ‘Misa꞉ kalu, ge mada halaido꞉ kalu a꞉la꞉asulo꞉. Eyo꞉ gilo꞉ mo꞉gelo꞉ a꞉namio꞉ hendeyo꞉ ge dia꞉sen. Fowo꞉ gilo꞉ mo꞉fifo꞉ a꞉namio꞉, ge tia꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","A꞉la꞉fo꞉ko꞉lo꞉ ne mada tagilaki, mole daosen gilo꞉ a꞉no꞉ hena wo꞉no꞉le difa꞉. O꞉go꞉ mole go꞉no꞉ndo꞉ a꞉no꞉ko꞉ a꞉dia꞉mio꞉wo꞉ we.’ ");
INSERT INTO bco_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“A꞉la꞉sa꞉labiki ene misa꞉ kalu a꞉ma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, ‘Ge bo꞉sulo꞉ kalu. Nanogdo꞉ dian kalu mogago꞉wo꞉ ge. Giyo꞉ a꞉la꞉asulo꞉, eyo꞉ nilo꞉ mo꞉gelo꞉ a꞉namio꞉ hendeyo꞉ ne dia꞉sen. A꞉la꞉ta꞉ga꞉ fowo꞉ nilo꞉ mo꞉fifo꞉ a꞉namio꞉, ne tia꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","A꞉la꞉gasen ko꞉lo꞉, mole wema꞉yo꞉ nanogo꞉ ba꞉ng amio꞉ dimidaliki, mole nolo꞉lo꞉ a꞉fa꞉la꞉doma꞉kilo꞉ mo꞉difa꞉yo꞉ wangabi go꞉wo꞉? Giyo꞉ a꞉la꞉bo꞉ dimido꞉ kibo꞉bowo꞉, mole we o꞉lia꞉ mole nol o꞉lia꞉yo꞉ a꞉dimo꞉lo. ");
INSERT INTO bco_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ mole daosen imilig kalu wema꞉lo꞉ ta꞉lisab a꞉no꞉ asula꞉sa꞉ga꞉, kalu daosen do꞉la꞉fo꞉lo꞉ da꞉lab o꞉mo꞉ dimiaki, elo꞉wa gasalifoma. ");
INSERT INTO bco_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mo꞉wo꞉ kalu abeyo꞉ asulo꞉wo꞉ hebo꞉ dowalega, emo꞉wo꞉ asulo꞉ nolo꞉ a꞉dikudu alifa꞉ib ko꞉lo꞉, e asulo꞉wo꞉ alande doma꞉ib. Ko꞉sega kalu abeyo꞉ asugdo꞉ma dowab a꞉no꞉, asulo꞉ ha꞉lu e amilo꞉ delen a꞉no꞉, tambo a꞉ma꞉la꞉ dila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","A꞉la꞉go꞉ko꞉lo꞉ nanogdo꞉ mo꞉dimidama꞉no꞉ dowo꞉ kalu we ha꞉la꞉ amilo꞉ sololi a꞉lab a꞉na sandifoma. Hen a꞉namio꞉ eyo꞉ kulufa꞉yakiyo꞉, ya꞉foda꞉li mesa꞉ib.’ ” ");
INSERT INTO bco_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kalule Dowo꞉ e yakiyo꞉, ene halaido꞉ fo꞉fo꞉lesodo꞉ o꞉lia꞉ ene ma꞉mula꞉ kalu o꞉lia꞉ tambo ya꞉sa꞉ga꞉yo꞉, misa꞉ kalu alando꞉ mesa꞉no꞉ fofodo꞉ nafale enedo꞉ a꞉na siliki bo꞉fo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","E a꞉na silikiyo꞉, henfelo꞉ kaluka꞉isaleyo꞉ tambo e siwa꞉la kegenema꞉ib. A꞉la꞉ta꞉ga꞉ bo꞉fo꞉lowan kaluwa꞉lo꞉ sibi o꞉lia꞉ goudi o꞉lia꞉ ko꞉lo꞉ aloba꞉dan o꞉leaumbo꞉, eyo꞉ kaluka꞉isale a꞉no꞉ tambo aloba꞉dakiyo꞉, nolo꞉ nodowa, nolo꞉ nodowa a꞉la꞉ ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eyo꞉ a꞉la꞉dimidakiyo꞉, sibi a꞉no꞉ ene dagi ililiba ta꞉fa꞉ib. Ko꞉sega goudi a꞉no꞉ ene dagi fo꞉fo꞉doloba ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ Misa꞉ Kalu Alan a꞉ma꞉yo꞉ dagi ililib amilo꞉ a꞉lab imo꞉wo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Ni Dowa꞉lo꞉ sagalema꞉kilo꞉ ilili alifa꞉, gio꞉ mena. Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉no꞉ gio꞉ dia꞉ni mena. Henfelo꞉ we ho꞉gi dimidakiyo꞉, gio꞉ dabun a꞉no꞉ dima꞉ki, Gode eyo꞉ tamina dimidalia꞉ga꞉ difa꞉. ");
INSERT INTO bco_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mo꞉wo꞉ ne maiyo꞉ elen amio꞉, giliyo꞉ nemo꞉wo꞉ ma꞉no꞉ dimiale. Ne ho꞉n maiyo꞉ elen amio꞉, gio꞉ ho꞉no꞉ wasu meale. Ne mageso꞉ mio꞉ amio꞉, giliyo꞉ ne sagala꞉liki tilidowale. ");
INSERT INTO bco_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ne helebeso꞉g do꞉ma elen amio꞉, giliyo꞉ helebeso꞉go꞉ kalitale. Ne walaf elen amio꞉, giliyo꞉ ne asuwa꞉tale. Ne dibolo aya sen amio꞉, gio꞉ ne ba꞉ba꞉yale.’ ");
INSERT INTO bco_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Misa꞉ Kalu eyo꞉ a꞉la꞉sa꞉labiki, digalo꞉ kaluka꞉isale iliyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Kalu Alan niliyo꞉ ge maiyo꞉ sabikiyo꞉, ma꞉no꞉wo꞉ iga꞉sa dimiyo꞉lowa꞉le? Ge ho꞉n maiyo꞉ sabikiyo꞉, ho꞉no꞉ iga꞉sa wasu meo꞉lowa꞉le? ");
INSERT INTO bco_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","A꞉la꞉ta꞉ga꞉ ge mageso꞉ yab amio꞉ niliyo꞉ ge iga꞉sa tilidowo꞉wa꞉le? Ge helebeso꞉g do꞉ma elen amio꞉, niliyo꞉ helebeso꞉go꞉ o꞉ba kalito꞉lowa꞉le? ");
INSERT INTO bco_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A꞉la꞉ta꞉ga꞉ ge walaf delen amio꞉, o꞉ ge dibolo aya sen amio꞉, niliyo꞉ o꞉ba ba꞉ba꞉yo꞉lowa꞉le?’ ");
INSERT INTO bco_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Iliyo꞉ a꞉la꞉dabu ba꞉dabiki, Misa꞉ Kalu Alan a꞉ma꞉yo꞉ imo꞉wo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Niyo꞉ gimo꞉wo꞉ hendele sa꞉ma꞉nigo꞉l. Wilo꞉ma kaluka꞉isale i we ni nao i ko꞉lo꞉, gililo꞉ imo꞉lo꞉ asufa꞉ a꞉no꞉ nemo꞉ asuwa꞉tale.’ ");
INSERT INTO bco_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“A꞉la꞉ta꞉ga꞉ Misa꞉ Kalu eyo꞉ kaluka꞉isale ene dagi fo꞉fo꞉dolo꞉ amilo꞉ a꞉lab imo꞉wo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Godeya꞉ ene gadio꞉wo꞉ gi amio꞉ da꞉lab ko꞉lo꞉, gio꞉ nelo꞉ wenamio꞉ ta꞉ta꞉ga꞉ hamana. De ko꞉ngo꞉ mela꞉no꞉ a꞉lab a꞉no꞉ Sa꞉da꞉na꞉ o꞉lia꞉ ene ma꞉mula꞉ kalu o꞉lia꞉ma꞉no꞉ dimidaefa꞉ ko꞉lo꞉, gio꞉lo꞉ a꞉na hamana! ");
INSERT INTO bco_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mo꞉wo꞉ ne maiyo꞉ so꞉likiyo꞉, giliyo꞉ ne ma꞉no꞉wo꞉ mo꞉miale. Ne ho꞉n maiyo꞉ so꞉likiyo꞉, ho꞉no꞉ maiya꞉kiyo꞉ mo꞉wasumeale. ");
INSERT INTO bco_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ne mageso꞉ yo꞉likiyo꞉, gio꞉ ne mo꞉tilidowale. Ne helebeso꞉g do꞉ma so꞉likiyo꞉, gio꞉ helebeso꞉go꞉ ne amio꞉ mo꞉kalitale. Ne walaf delen amio꞉, gio꞉ ne mo꞉ba꞉ba꞉yale. A꞉la꞉ta꞉ga꞉ ne dibolo aya sen amio꞉lo꞉, gio꞉ ne mo꞉ba꞉ba꞉yale.’ ");
INSERT INTO bco_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","A꞉la꞉sa꞉lalikiyo꞉ iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Kalu Alan, ge maiyo꞉wa꞉le, o꞉ ho꞉n maiyo꞉wa꞉le, mageso꞉ mio꞉wa꞉le, helebeso꞉g do꞉ma elena꞉le, o꞉ walaf delena꞉le, o꞉ ge dibolowa sena꞉le, niliyo꞉ a꞉no꞉ o꞉ba ba꞉da꞉sa꞉ga꞉ mo꞉asuwa꞉taleyo꞉?’ ");
INSERT INTO bco_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","A꞉la꞉sa꞉lalikiyo꞉ Misa꞉ Kalu eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Niyo꞉ gimo꞉wo꞉ hendele sa꞉ma꞉nigo꞉l. Gililo꞉ wilo꞉ma kaluka꞉isale wemo꞉lo꞉ mo꞉asufa꞉ a꞉ma꞉yo꞉, nemo꞉wo꞉lo꞉ mo꞉asuwa꞉taki gab.’ ");
INSERT INTO bco_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isale i we ko꞉ngo꞉ mela꞉no꞉ falasilab a꞉na mesa꞉ni ha꞉na꞉ib. Ko꞉sega digalo꞉ kaluka꞉isale i a꞉no꞉, ko꞉ngo꞉ mela꞉no꞉ mela꞉no꞉ us a꞉na mesa꞉ni tina꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ya꞉su eyo꞉ to a꞉no꞉ sa꞉la꞉la꞉ga꞉ eletakiyo꞉, enedo꞉ tili wida꞉sen kalumo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gio꞉ asulo꞉ ko꞉lo꞉lab. Ho꞉len a꞉la꞉yo꞉ ta꞉takiyo꞉, Tinio꞉ Asulo꞉ Ma꞉no꞉ ho꞉len a꞉no꞉ fa꞉la꞉doma꞉nigab ko꞉lo꞉, o꞉g a꞉namio꞉ Kalule Dowo꞉ e i malana sana soma꞉ki, gis kaluwa꞉ dagiya gasi mia꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ho꞉len a꞉namio꞉ Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu ko꞉go꞉do꞉ kaluwo꞉lo꞉ iyo꞉ tambo bobalo꞉ so꞉mea꞉sen misa꞉ kalu, Kaiafasa꞉ ene aya kegea꞉sa꞉ga꞉, towo꞉ a꞉na nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Iliyo꞉ Ya꞉suwo꞉ dikidaki ta꞉lia꞉sa꞉ga꞉lo꞉ sana soma꞉no꞉ tog a꞉no꞉ kedaki nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ko꞉sega iliyo꞉ a꞉la꞉nenelo꞉, “Niliyo꞉ Tinio꞉ Asulo꞉lo꞉ Ma꞉no꞉ ho꞉len a꞉namio꞉ Ya꞉suwo꞉ mo꞉ta꞉lia꞉no꞉, mo꞉wo꞉ ho꞉len a꞉na ta꞉lialega, kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ gadiaki, towo꞉ alan kegema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ya꞉suwo꞉ Ba꞉tani amisa꞉na ilikiyo꞉, Saimon, aintalo꞉ ta꞉len kalu a꞉ma꞉ aya sen. ");
INSERT INTO bco_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","E a꞉na sabiyo꞉, ga imilig nowo꞉ elo꞉wa ya꞉sa꞉ga꞉, wa ho꞉n mudo꞉ nafa, u ho꞉lo꞉ nafale no꞉no꞉ a꞉namilo꞉ wasu a꞉no꞉ dia꞉mio꞉. Wa ho꞉n a꞉no꞉ moleyo꞉ alana꞉ kilili ko꞉lo꞉, Ya꞉suwo꞉ ma꞉no꞉ na꞉li sabikiyo꞉, ga a꞉ma꞉yo꞉ wa ho꞉n a꞉no꞉, Ya꞉suwa꞉ misa꞉ wa꞉l a꞉na tulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ya꞉suwa꞉ tili wida꞉sen kaluwo꞉ ga a꞉ma꞉lo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉ mo꞉beaki, egelebo꞉ a꞉la꞉sio꞉, “Ga wema꞉lo꞉ wa ho꞉n mudo꞉ nafa wasu walab we mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Wa ho꞉n a꞉no꞉ mo꞉walai kibo꞉bowo꞉, wa ho꞉n a꞉no꞉ kalu nolbo꞉wo꞉ moleyo꞉ alana꞉ kililia꞉sa꞉ga꞉, mole a꞉no꞉ wa꞉feyo꞉ kalumo꞉wo꞉ o꞉li dimibabe.” ");
INSERT INTO bco_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ya꞉su eyo꞉ to ilido꞉ nenelab a꞉no꞉ asula꞉sa꞉ga꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ ga wemo꞉lo꞉ mo꞉beo꞉ to sio꞉wo꞉ mo꞉wo꞉ ha꞉? Ga wema꞉yo꞉ nemo꞉wo꞉ man nafale dimidab. ");
INSERT INTO bco_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Wa꞉feyo꞉ kaluwo꞉ ho꞉leno꞉ tambo gi o꞉lia꞉ mela꞉ib, ko꞉sega ne ho꞉leno꞉ tambo gi o꞉lia꞉yo꞉ mo꞉mela꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ga wema꞉lo꞉ wa ho꞉n ko꞉lo꞉ ni do꞉mo꞉ amilo꞉ mulu alitab we, nelo꞉ sowa꞉sa꞉ga꞉lo꞉ a꞉le alifa꞉no꞉ a꞉no꞉ ko꞉lo꞉ dimidaitaki gab. ");
INSERT INTO bco_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ to we gimo꞉wo꞉ hendele sa꞉ma꞉nigo꞉l. Henfelo꞉ o꞉bamida꞉ya꞉le Godeya꞉ to nafa a꞉no꞉ henfelo꞉ amio꞉ widalikiyo꞉, ga wema꞉lo꞉ dimidab a꞉no꞉ mo꞉ga꞉lilaki, sa꞉la꞉li ha꞉na꞉mela꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Yudas Iskalioto꞉, Ya꞉suwa꞉lo꞉ tili wida꞉sen kalu kugula꞉fo꞉ nowo꞉ e ko꞉lo꞉, e ha꞉na꞉sa꞉ga꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalulo꞉wa fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ Ya꞉suwo꞉ teledowaki, gili dagiya dia꞉talega, giliyo꞉ nemo꞉wo꞉ o꞉b dimia꞉no꞉wo꞉?” A꞉la꞉sa꞉labikiyo꞉ iliyo꞉ silba moleyo꞉ do꞉la꞉fo꞉ otalen a꞉la꞉fo꞉ko꞉lo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ho꞉len a꞉na a꞉la꞉ta꞉ga꞉yo꞉, Yudas eyo꞉ Ya꞉sulo꞉ teledoma꞉no꞉ ho꞉lende a꞉no꞉ fa꞉la꞉doma꞉ki togo꞉ keda꞉li elen. ");
INSERT INTO bco_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Falawa Mosolo꞉ Dowo꞉fa꞉ sagala꞉sen ho꞉len a꞉no꞉ mo꞉mo꞉da fa꞉la꞉dowabiki, ho꞉len agel a꞉namio꞉ Ya꞉suwa꞉ ene tili wida꞉sen kaluwo꞉ elo꞉wa ya꞉ga꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giyo꞉ Tinio꞉ Asulo꞉lo꞉ Ma꞉no꞉ ma꞉nikiyo꞉, niliyo꞉ o꞉ba ha꞉na꞉sa꞉ga꞉ dimidaefoma꞉ki asulaya?” ");
INSERT INTO bco_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Gio꞉ Ya꞉lusalem tina꞉sa꞉ga꞉yo꞉, kalu nowo꞉ a꞉na ba꞉ba꞉ib ko꞉lo꞉, gio꞉ emo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘Widan kaluwa꞉yo꞉ a꞉la꞉sa꞉labe, “Ni ho꞉lendeyo꞉ ko꞉na꞉ma ililima꞉nigab ko꞉lo꞉, ne o꞉lia꞉ no꞉no꞉n tili wida꞉sen kalu i o꞉lia꞉yo꞉ Tinio꞉ Asulo꞉ Ma꞉no꞉ a꞉no꞉ gi aya siliki ma꞉no꞉.” ’ ” ");
INSERT INTO bco_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ya꞉suwa꞉lo꞉ imo꞉lo꞉ sio꞉ aumbo꞉ iyo꞉ kudu ha꞉naki, Tinio꞉ Asulo꞉ Ma꞉no꞉ ma꞉no꞉wo꞉ a꞉na dimidala꞉li sen. ");
INSERT INTO bco_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","21","Ga꞉lo dowabiki, Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu kugula꞉fo꞉ o꞉lia꞉yo꞉ a꞉na siliki ma꞉no꞉ na꞉likiyo꞉, Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉, “Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Gio꞉ imilig noma꞉yo꞉ ne teledoma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ya꞉suwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, ili asulo꞉wo꞉ mada hida꞉liaki emo꞉wo꞉ a꞉la꞉sio꞉, “Kalu Alan, neya꞉le?” A꞉la꞉tandeaki Ya꞉sumo꞉ dabu kedo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu ni dagi o꞉lia꞉lo꞉ fafo amilo꞉ ma꞉no꞉lo꞉ gele nab a꞉ma꞉yo꞉sa ne teledoma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Godeya꞉lo꞉ tolo꞉ dinali sa꞉lan kaluwa꞉lo꞉ to saetakilo꞉ sa꞉sa꞉lo꞉ o꞉leauka, Kalule Dowo꞉wo꞉ tog a꞉no꞉ko꞉ kudu ha꞉na꞉no꞉. A꞉la꞉fo꞉ ko꞉sega wai, elo꞉ teledowab kalu a꞉no꞉ hida꞉yo꞉wo꞉ alan dia꞉ib. Kalu a꞉no꞉ anowa꞉yo꞉ mo꞉sa꞉la꞉li kibo꞉bowo꞉ o꞉li domabe.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudas, Ya꞉sulo꞉ teledoma꞉no꞉ kalu eyo꞉lo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu giyo꞉ ne ko꞉lo꞉ sa꞉laya꞉le?” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉no꞉ndo꞉ sa꞉lab ko꞉m.” ");
INSERT INTO bco_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Iyo꞉ ma꞉no꞉ na꞉likiyo꞉, Ya꞉su eyo꞉ ma꞉n so꞉fa꞉ nowo꞉ dia꞉sa꞉ga꞉, Godemo꞉ mada o꞉m a꞉la꞉sa꞉la꞉sa꞉ga꞉ ma꞉n a꞉no꞉ enedo꞉ tili wida꞉sen kalumo꞉ goloso꞉go꞉. A꞉no꞉ dimiakiyo꞉ a꞉la꞉sio꞉, “Ma꞉n we no꞉no꞉n do꞉mo꞉ ko꞉lo꞉, giliyo꞉ dia꞉sa꞉ga꞉ maiya.” ");
INSERT INTO bco_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","A꞉la꞉ta꞉ga꞉ eyo꞉ kab amilo꞉ wain ho꞉n wasu a꞉no꞉ dia꞉sa꞉ga꞉, Godemo꞉ mada o꞉m a꞉la꞉sa꞉la꞉sa꞉ga꞉, imo꞉ maiya꞉ki dimiakiyo꞉ a꞉la꞉sio꞉, “Gio꞉ tambo dia꞉sa꞉ga꞉ maiya. ");
INSERT INTO bco_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ho꞉n wasu we, no꞉no꞉n ho꞉bo꞉wo꞉ o꞉m. Ni ho꞉bo꞉ ko꞉lo꞉ kaluka꞉isaleya꞉ mogago꞉ hama꞉kilo꞉ tulu alifelab wema꞉yo꞉, Godeya꞉lo꞉ to dinali saefa꞉ a꞉no꞉ halale alitakigab. ");
INSERT INTO bco_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Niyo꞉ gimo꞉wo꞉ so꞉lo꞉l. Ne wain ho꞉no꞉ wa꞉kabiyo꞉ mo꞉mo꞉no꞉ka a꞉la꞉ga꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man ho꞉gi us a꞉namio꞉, ne gi o꞉lia꞉ siliki a꞉na wa꞉ka ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iyo꞉ ma꞉no꞉wo꞉ na꞉sa꞉ga꞉ eletakiyo꞉, gisalo꞉ imilig nowo꞉ a꞉na mo꞉la꞉sa꞉ga꞉ handalowakiyo꞉, iyo꞉ hen misio꞉ O꞉lif a꞉namida꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “O꞉g nulu wenamio꞉ gio꞉ tambo ne gola ba꞉daki ha꞉la꞉ya ha꞉na꞉ib. Mo꞉wo꞉ tamin amio꞉ Godeya꞉ bugo꞉ amio꞉ towo꞉ sa꞉sa꞉lakiyo꞉ a꞉la꞉sio꞉, “ ‘Niyo꞉ sibilo꞉ bo꞉fo꞉lowano꞉ sana soma꞉no꞉ ko꞉lo꞉, kabo sibiyo꞉ a꞉na dalalelia꞉ga꞉ ha꞉na꞉sima꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ko꞉sega ne a꞉ma꞉la꞉ dasi alitalikiyo꞉, Ga꞉lili hen amio꞉ ne ko꞉le tamina ha꞉na꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bida eyo꞉ Ya꞉suwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu nolo꞉ tambo ge gola ba꞉daki, ha꞉la꞉ya ha꞉na꞉ib, ko꞉sega imilise niyo꞉ ge mada mo꞉gola ba꞉ba꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ Bidamo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gemo꞉wo꞉ hendele so꞉lo꞉l. O꞉g nulu wenakabiyo꞉, gogonowo꞉ o꞉ganama꞉no꞉ o꞉lalikiyo꞉, giyo꞉ ne mo꞉asulo꞉ a꞉la꞉bo꞉ otalen sa꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ko꞉sega Bida eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ a꞉la꞉bo꞉ mada mo꞉sa꞉ma꞉no꞉. Ne ge o꞉lia꞉ soma꞉no꞉ dowo꞉lalega, niyo꞉ ge mo꞉asulo꞉ a꞉la꞉bo꞉ mada mo꞉sa꞉ma꞉no꞉.” Bida eyo꞉ a꞉la꞉sa꞉labiki, tili wida꞉sen kalu nolba꞉yo꞉lo꞉ to imilise a꞉no꞉ko꞉ sa꞉la꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ya꞉su o꞉lia꞉ ene tili wida꞉sen kalu i o꞉lia꞉yo꞉ hen Ga꞉sa꞉ma꞉ni a꞉la꞉do꞉ sa꞉lab a꞉na ha꞉na꞉ni ane. A꞉na fa꞉la꞉dowakiyo꞉, Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ wena ta꞉bi. Ne honona Godemo꞉ sa꞉ma꞉ni ho꞉no꞉l.” ");
INSERT INTO bco_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","38","A꞉la꞉sa꞉la꞉sa꞉ga꞉ eyo꞉ Bida o꞉lia꞉ Sa꞉ba꞉di inso꞉ Ya꞉ma꞉so꞉, Yo꞉no꞉ a꞉no꞉ko꞉ tililia꞉ fina꞉sa꞉ga꞉yo꞉, Ya꞉su e hida꞉liaki kele asulakiyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ni asulo꞉wo꞉ hida꞉yo꞉ alan dowaki, ne tilialila soma꞉no꞉ o꞉ngo꞉ dowab. Gio꞉ wena siliki ne o꞉lia꞉ bo꞉fo꞉melea.” ");
INSERT INTO bco_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ya꞉su eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, e heb doba꞉da꞉ o꞉fina꞉sa꞉ga꞉yo꞉, hena gulalu misa꞉fu siliki, Godemo꞉ dulugu sa꞉lakiyo꞉ a꞉la꞉sio꞉. “Dowa, we au dimidama꞉no꞉wo꞉ o꞉li dowo꞉lalega, ho꞉n halo꞉ go꞉fo꞉ amilo꞉ wasu ko꞉lo꞉ nemo꞉lo꞉ mea꞉nigab a꞉no꞉, ne mo꞉maiya꞉ki dila꞉bi. Ko꞉sega nilo꞉ asulab aumbo꞉ dimida꞉so꞉bo. Gode gilo꞉ asulab aumbo꞉ dimidama.” ");
INSERT INTO bco_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","To a꞉no꞉ dulugu sa꞉la꞉sa꞉ga꞉yo꞉, enedo꞉ tili wida꞉sen kalulo꞉wa ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowaki ba꞉ba꞉ amio꞉, iyo꞉ mida꞉iyo꞉ fufulufo꞉lena ba꞉ba꞉. E ba꞉da꞉sa꞉ga꞉, Bidamo꞉wo꞉ a꞉la꞉sio꞉, “Saimon, gio꞉ ofa꞉si imilig nowo꞉ ne o꞉lia꞉ yasilakiyo꞉ mo꞉sikaga seno꞉lo꞉ka꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Gio꞉ da꞉fe ba꞉dab amio꞉ sulufo꞉ tinabena꞉ki, gio꞉ sikaga siliki, Godemo꞉ dulugu sa꞉la꞉lubi. Gili mamaya꞉yo꞉ dimidama꞉no꞉wo꞉ asulab ko꞉sega, gili do꞉mo꞉wo꞉ halaido꞉lo꞉ma dowab.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ to andebo꞉ wa꞉ka dulugu sa꞉ma꞉ni fina꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Do Gode, ho꞉n wasu we dila꞉ma꞉no꞉wo꞉ tog nowo꞉ mo꞉dowalega, ne o꞉li ma꞉no꞉. Gilo꞉ asulab au dimidama.” ");
INSERT INTO bco_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","A꞉la꞉dulugu sa꞉la꞉sa꞉ga꞉yo꞉, e wa꞉ka a꞉ma꞉la꞉ ya꞉ga꞉ ba꞉ba꞉ amio꞉, iyo꞉ mida꞉iyo꞉ alifo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, e asolo꞉ wa꞉ka dulugu sa꞉ma꞉ni ha꞉na꞉sa꞉ga꞉, Godemo꞉lo꞉ to tamin amilo꞉ sio꞉ o꞉leauka wa꞉ka sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Eyo꞉ dulugu sa꞉la꞉sa꞉ga꞉ eletakiyo꞉, enedo꞉ tili wida꞉sen kalulo꞉wa a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Gio꞉ alifo꞉mela꞉no꞉ ko꞉ alifo꞉leya? Bo꞉ba! Ofa꞉sileyo꞉ o꞉ma fa꞉la꞉dowab ko꞉lo꞉, Kalule Dowo꞉wo꞉ mogago꞉lo꞉ dimidan kalumo꞉ teledowaki gasimia꞉nigab. ");
INSERT INTO bco_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Dasima! Nelo꞉ teledoma꞉ibo꞉ weyako bo꞉ba. Nio꞉ e galima꞉niki, ha꞉na꞉n.” ");
INSERT INTO bco_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ya꞉suwo꞉ to a꞉no꞉ ko꞉lo꞉ sa꞉la꞉lena, enedo꞉ tiliwida꞉sen kalu imilig nowo꞉ Yudas e a꞉na fa꞉la꞉dowo꞉. Yudasa꞉ fa꞉s amio꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu ko꞉go꞉dego꞉ kalu o꞉lia꞉ma꞉lo꞉ wati kaluwo꞉ modo꞉ mio꞉. Kalu i a꞉ma꞉yo꞉ ko꞉lo꞉dowo꞉lo꞉, helebesi sambowo꞉lo꞉ diadela꞉sa꞉ga꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Tamin amio꞉ Yudas eyo꞉ wati kalumo꞉wo꞉ a꞉la꞉sio꞉. “Kalu nilo꞉ mimilab a꞉no꞉ o꞉m ko꞉lo꞉, giliyo꞉ e ta꞉lia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","A꞉la꞉fo꞉ko꞉lo꞉ Yudas e Ya꞉sulo꞉ka tigini ha꞉na꞉sa꞉ga꞉ kagayaki a꞉la꞉sio꞉, “Widan kalu, ge nulu nafa.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ ami Ya꞉suwo꞉ a꞉na mimilo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ni mili, gilo꞉ dimidama꞉no꞉ asulo꞉ mio꞉wo꞉ dimidama.” A꞉la꞉sa꞉labiki gis kaluwa꞉yo꞉ Ya꞉suwo꞉ a꞉na ta꞉li. ");
INSERT INTO bco_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ya꞉su e ta꞉liabiki, kalu e anib amilo꞉ kagafo꞉len imilig noma꞉yo꞉, ene helebesi sambowo꞉ sililia꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉ nanog dian kalu a꞉no꞉ helebesi a꞉ma꞉ yamelabiki, ka꞉la꞉na꞉ fo꞉so꞉ a꞉na gede to꞉lolo꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ya꞉su eyo꞉ kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉no꞉n helebesi sambo ko a꞉ma꞉la꞉ disa꞉ma. Mo꞉wo꞉ kalu abeyo꞉ helebesi o꞉lia꞉ma꞉lo꞉ buba꞉sen a꞉no꞉, helebesi a꞉ma꞉yo꞉ inino꞉lo꞉ tambo yasala꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Niyo꞉ Domo꞉wo꞉ dulugu sa꞉laki dabu ba꞉dalega, eyo꞉ ma꞉mula꞉ kalu daosen daosen mo꞉agela꞉ma꞉no꞉ dowo꞉ a꞉no꞉ ne asuwa꞉foma꞉kiyo꞉ o꞉li iliga꞉fa꞉ib. Giyo꞉ a꞉la꞉bo꞉ mo꞉asulaya? ");
INSERT INTO bco_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ko꞉sega niyo꞉ a꞉la꞉dimidai kibo꞉bowo꞉, Godeya꞉ bugo꞉ amilo꞉ to saefa꞉ o꞉leaumbo꞉ mo꞉ililimabe. Mo꞉wo꞉ Godeya꞉ to a꞉ma꞉yo꞉ kelego꞉ we ne amio꞉ mada fa꞉la꞉doma꞉ib a꞉la꞉sa꞉sa꞉lo꞉ da꞉lab,” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ kalu kegeo꞉ i o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ helebesi o꞉lia꞉ ko꞉lo꞉do o꞉lia꞉yo꞉ dia꞉sa꞉ga꞉, ne ta꞉lia꞉ni mio꞉lo꞉b. Gililo꞉ a꞉la꞉dimido꞉ a꞉no꞉, afalo꞉ dian kalu ko꞉lo꞉ ta꞉lia꞉no꞉ yakilo꞉ gan o꞉leo꞉ngo꞉lo꞉ka꞉. Giliyo꞉ ne kalu we o꞉ngo꞉ka꞉ a꞉la꞉asulo꞉ kibo꞉bowo꞉, ho꞉leno꞉ tambowo꞉ ne Godeya꞉ malilo꞉ ayami tolo꞉ wida꞉len amio꞉, giliyo꞉ ne wangabiki mo꞉ta꞉liyo꞉? ");
INSERT INTO bco_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko꞉sega o꞉gdo꞉ fa꞉la꞉dowab wema꞉yo꞉, Godeya꞉ tolo꞉ dinali sa꞉lan kaluwa꞉lo꞉ to sa꞉sa꞉lifa꞉ a꞉no꞉ ko꞉lo꞉ ilili alitakigab.” Ya꞉su eyo꞉ a꞉la꞉sa꞉labiki, enedo꞉ tili wida꞉sen kalu iyo꞉ tambo e ta꞉ta꞉sa꞉ga꞉ dalale ane. ");
INSERT INTO bco_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Elelo꞉ widan kalu iyo꞉lo꞉ Yu ko꞉go꞉do꞉ kaluwo꞉lo꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kalu alan, Kaiafasa꞉ ene aya ya꞉sa꞉ga꞉ a꞉na kegenefo꞉len ko꞉lo꞉, Ya꞉sulo꞉ ta꞉li kalu iliyo꞉, Ya꞉suwo꞉ a a꞉na tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ya꞉suwo꞉ tililia꞉ ha꞉na꞉ga꞉ ha꞉nabikiyo꞉, Bidayo꞉ Ya꞉suwa꞉ fa꞉sa gulu dowa꞉liki ha꞉na꞉gane. Bidayo꞉ ha꞉na꞉sa꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉ ayamilo꞉ tolo꞉ us a꞉na tina꞉sa꞉ga꞉yo꞉, Ya꞉su amilo꞉ dimidabo꞉ ko꞉lo꞉ ba꞉ba꞉no꞉ a꞉laki, e da꞉la꞉di kalu o꞉lia꞉ a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu amilo꞉ ganisolo kalu i a꞉no꞉lo꞉ tambo Ya꞉suwo꞉ sana soma꞉no꞉ a꞉la꞉liki, Ya꞉suwa꞉lo꞉ mogago꞉ dimido꞉ nowo꞉ kaluka꞉isaleyo꞉ madali sama꞉ki, iyo꞉ ho꞉ido꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","61","Madali tolo꞉ sa꞉ma꞉no꞉ kaluka꞉isale modo꞉wo꞉ ilo꞉wa mio꞉ ko꞉sega, Ya꞉sulo꞉ sana soma꞉kilo꞉ mo꞉walilima꞉no꞉ to a꞉no꞉, imilig noma꞉yo꞉ mo꞉sio꞉. A꞉la꞉ta꞉ga꞉ tif amio꞉ kalu a꞉la꞉ nowo꞉ ya꞉ga꞉yo꞉, towo꞉ a꞉la꞉sio꞉, “Kalu wema꞉yo꞉ a꞉la꞉sio꞉, ‘Godeya꞉ ene malilo꞉ ayo꞉ niyo꞉ o꞉li bidila꞉sa꞉ga꞉, ho꞉len otalen a꞉namio꞉ a꞉ma꞉la꞉ dialifa꞉no꞉,’ a꞉la꞉sa꞉labe.” ");
INSERT INTO bco_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","To a꞉no꞉ da꞉dakiyo꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwo꞉ kagafo꞉liki, Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ililo꞉ gemo꞉lo꞉ to sa꞉lab we, giyo꞉ a꞉ma꞉la꞉bo꞉ mo꞉sa꞉ma꞉no꞉lo꞉bo꞉?” ");
INSERT INTO bco_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉ towo꞉ mo꞉sio꞉. A꞉la꞉ta꞉ga꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu eyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ Mela꞉no꞉lo꞉ A꞉lab Gode, ene wiya iliki so꞉lo꞉l ko꞉lo꞉, giyo꞉ nimo꞉wo꞉ kalaba fanda sama. Godeya꞉ enedo꞉ Da꞉feyo꞉ Kaluwo꞉ geya꞉le? A꞉la꞉ta꞉ga꞉ Godeya꞉ ene so꞉wa a꞉no꞉ geya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","A꞉la꞉dabu ba꞉dabiki, Ya꞉suwa꞉ sa꞉laki, “Go꞉no꞉n gio꞉sa sa꞉lale. Ko꞉sega niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. O꞉g a꞉la꞉ta꞉ga꞉lo꞉ aneyo꞉, gio꞉ Kalule Dowo꞉ e, Gode Halaido꞉lelo꞉ A꞉lab a꞉ma꞉ dagi ililiba sena ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ gio꞉ e akin halona kola꞉ wa꞉la fa꞉la꞉dowaliki ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ya꞉suwa꞉yo꞉ a꞉la꞉sa꞉labiki da꞉da꞉sa꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉yo꞉ e kulufa꞉yaki, ene so꞉g kafo꞉len a꞉no꞉ bidilaki, eyo꞉ towo꞉ a꞉la꞉sio꞉, “Kalu wema꞉yo꞉ Godeyo꞉ dio꞉ge sio꞉ ko꞉lo꞉, niliyo꞉ kalu nolbo꞉wo꞉ a꞉dabu keda꞉so꞉bo. Elo꞉ dio꞉ge sa꞉lab to a꞉no꞉ gio꞉ tambo dabu. ");
INSERT INTO bco_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ waga asulaya?” A꞉la꞉dabu ba꞉dabiki, iyo꞉ tambowa꞉yo꞉ a꞉la꞉sio꞉, “Kalu we soma꞉no꞉ dowo꞉ au soma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","68","A꞉la꞉ta꞉ga꞉ iliyo꞉ ene wo꞉lokan ami kodofela꞉sa꞉ga꞉ yamelaki, kalu nolba꞉yo꞉ ene babowa sa꞉ndaki a꞉la꞉sio꞉, “Ge Godeya꞉ Da꞉feyo꞉ kalu ko꞉lo꞉, nimo꞉wo꞉ dinali sama. Kalu gelo꞉ sa꞉ndab ko giyo꞉ ho꞉le ba꞉daki wiyo꞉ sama.” ");
INSERT INTO bco_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Bidayo꞉ a baya o꞉sen amio꞉, nanog dian ka꞉isale nowo꞉ elo꞉wa ya꞉sa꞉ga꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉lili kalu Ya꞉su o꞉lia꞉lo꞉ dowa꞉seno꞉ nowo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ko꞉sega Bida eyo꞉ kalu kegeo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ sa꞉lab ko ne babalab.” ");
INSERT INTO bco_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Bida eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, ilif tolo꞉ a꞉ma꞉ tog aniba ha꞉na꞉sa꞉ga꞉yo꞉, nanog dian ka꞉isale noma꞉yo꞉ Bidayo꞉ a꞉na ba꞉ba꞉ ko꞉lo꞉, eyo꞉ kalu kagafo꞉lab i o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Kalu we, e Nasala꞉t kalu Ya꞉su o꞉lia꞉ dowa꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","A꞉la꞉sa꞉labiki Bida eyo꞉ ene towo꞉ halale alitakiyo꞉ wo꞉lokana golaki a꞉la꞉sio꞉, “Mada hendele, ne kalu ko mada mo꞉asulo꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ha꞉lu o꞉a꞉la꞉ga꞉, kalu kagafo꞉len nol a꞉ma꞉yo꞉ Bidalo꞉wa ya꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Dagan gilo꞉ sa꞉lab koma꞉yo꞉, ge hendele Ya꞉su o꞉lia꞉lo꞉ sia꞉seno꞉ nowo꞉ gelo꞉b.” ");
INSERT INTO bco_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Bida eyo꞉ wa꞉sa꞉le sa꞉la꞉sa꞉ga꞉, to we a꞉la꞉sio꞉, “Niyo꞉ do꞉lo꞉idalega, Gode eyo꞉ nemo꞉wo꞉ hida꞉yo꞉ nagalo꞉ mada dimia꞉ib. Kalu gilo꞉ sa꞉labko, ne mada mo꞉asulo꞉ka꞉!” Wigibo a꞉nakabiyo꞉, gogonowo꞉ a꞉na go꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gogonowo꞉ ganalabiki, Bidayo꞉ Ya꞉suwa꞉lo꞉ to tamin amilo꞉ sio꞉ a꞉no꞉ a꞉na asulo꞉. To sio꞉ a꞉no꞉ we, “Gogonowo꞉ o꞉ganama꞉no꞉ o꞉lalikiyo꞉, giyo꞉ ne mo꞉asulo꞉ a꞉la꞉bo꞉ otalen sa꞉ma꞉ib.” Bida eyo꞉ a꞉no꞉ kele asulaki, e ha꞉la꞉ya handalota꞉ga꞉ ha꞉nakiyo꞉, mada ya꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kea꞉fole dowabikiyo꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu ko꞉go꞉dego꞉ kalu i o꞉lia꞉ tambo kegea꞉sa꞉ga꞉, iliyo꞉ Ya꞉suwo꞉ sana soma꞉no꞉ togo꞉ nenela꞉sa꞉ga꞉ saefa꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ Ya꞉suwo꞉ mela꞉sa꞉ga꞉yo꞉, tililia꞉ga꞉, gamani misa꞉ kalu Failatbo꞉ dimia꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ililo꞉ Ya꞉su sana soma꞉no꞉ saetab a꞉no꞉ Yudas eyo꞉ da꞉da꞉sa꞉ga꞉yo꞉, e kele asula꞉sa꞉ga꞉ asugo꞉ nodolakiyo꞉, silba mole do꞉la꞉fo꞉ otalen ililo꞉ emo꞉lo꞉ dimi a꞉no꞉ dia꞉sa꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kalu o꞉lia꞉ Yu ko꞉go꞉dego꞉ kalu i o꞉lia꞉mo꞉ a꞉ma꞉la꞉ dimia꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A꞉na ha꞉na꞉sa꞉ga꞉yo꞉, Yudas eyo꞉ towo꞉ a꞉la꞉sio꞉, “Digalo꞉ kalu ko꞉lo꞉ nilo꞉ teledowo꞉ a꞉no꞉ giliyo꞉ sana sowaki, ene ho꞉bo꞉wo꞉ hena tuma꞉ib ko꞉lo꞉ ne mada mogago꞉ dimido꞉.” Ko꞉sega iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “A꞉no꞉ nilino꞉ma. A꞉no꞉ gilo꞉ asulab au dimido꞉ ko꞉m,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","A꞉la꞉gabiki Yudas eyo꞉ silba mole a꞉no꞉ Godeya꞉ malilo꞉ aya sandifela꞉sa꞉ga꞉, iyo꞉ a꞉na ta꞉fo꞉gane. A꞉la꞉ta꞉ga꞉ e ha꞉na꞉sa꞉ga꞉yo꞉, enena꞉ma꞉la꞉ kola꞉fo silisa꞉nda꞉sa꞉ga꞉, a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ko꞉sega bobalo꞉ so꞉mea꞉sen misa꞉ kalu iliyo꞉ mole a꞉no꞉ dia꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Mole wema꞉yo꞉, kalu sana sowaki ho꞉bo꞉ tuluma꞉ki kilili ko꞉lo꞉, nili ele saefa꞉ a꞉ma꞉yo꞉ mole we, Godeya꞉ malilo꞉ a a꞉ma꞉ mole o꞉lia꞉yo꞉ gasaya꞉so꞉bo a꞉la꞉saefa꞉.” ");
INSERT INTO bco_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ towo꞉ nenela꞉sa꞉ga꞉ saetakiyo꞉, Go꞉fo꞉lo꞉ Dimidan kalu a꞉ma꞉ hen heb nowo꞉ ko꞉lo꞉ kilili. Kalu ko꞉na꞉lo꞉ yab sowalikilo꞉ daida꞉mela꞉no꞉ hen a꞉no꞉ ko꞉lo꞉ ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","A꞉la꞉fo꞉ko꞉lo꞉ ho꞉len a꞉na a꞉la꞉ta꞉ga꞉lo꞉ mio꞉wo꞉, o꞉go꞉lo꞉, kaluka꞉isaleya꞉yo꞉ hen a꞉no꞉ Ho꞉bo꞉lo꞉ Tulo꞉ Hen a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Ililo꞉ dimido꞉ a꞉no꞉, dinali sa꞉lan kalu Ya꞉limaya elo꞉ to sio꞉ a꞉no꞉ ilili alitaki hendele fa꞉la꞉dowo꞉. Eyo꞉ towo꞉ a꞉la꞉sio꞉, “Isolael kaluka꞉isale iliyo꞉ kalu ko ko꞉lo꞉ kililima꞉kiyo꞉ silba mole do꞉la꞉fo꞉ otaleno꞉ da꞉feyo꞉ ko꞉lo꞉, iliyo꞉ mole a꞉no꞉ dia꞉sa꞉ga꞉, Go꞉fo꞉lo꞉ Dimidan kaluwa꞉ hen a꞉no꞉ ko꞉lo꞉ kilili. Ililo꞉ dimido꞉ a꞉no꞉ Godeya꞉ tamin amilo꞉ nemo꞉lo꞉ sio꞉ o꞉leau dimido꞉.” ");
INSERT INTO bco_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ya꞉suwo꞉ gamani misa꞉ kalu Failata꞉ milifa kagafo꞉labiki, Failat eyo꞉ Ya꞉sumo꞉wo꞉ dabu ba꞉ba꞉, “Yu kaluka꞉isaleya꞉ misa꞉ kalu alano꞉ geya꞉le?” Ya꞉suwa꞉ a꞉ma꞉la꞉ sa꞉laki, “Go꞉no꞉n gio꞉sa sa꞉lale,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ko꞉sega bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yuwa꞉ ko꞉go꞉do꞉ kalu i o꞉lia꞉ma꞉yo꞉ Ya꞉sumo꞉ diga꞉li sa꞉lab amio꞉, Ya꞉suwa꞉yo꞉ a꞉ma꞉la꞉ towo꞉ mada mo꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","A꞉la꞉gabiki Failat eyo꞉ Ya꞉sumo꞉wo꞉ wa꞉ka dabu ba꞉ba꞉, “Ililo꞉ to ko꞉li ko꞉lilo꞉ gemo꞉lo꞉ sa꞉lab hono ge mo꞉da꞉daya?” ");
INSERT INTO bco_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A꞉la꞉go꞉ ko꞉sega Ya꞉su eyo꞉ emo꞉lo꞉ to diga꞉li sa꞉lab a꞉no꞉ a꞉ma꞉la꞉bo꞉ to nowo꞉ mo꞉sa꞉ma꞉no꞉ dowabiki, Failat e mada molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Donayo꞉ tambo amio꞉, Tinio꞉ Asulo꞉lo꞉ Ma꞉no꞉ ma꞉no꞉ ho꞉leno꞉ fa꞉la꞉dowab amio꞉, gamani misa꞉ kalu eyo꞉ dibolo amilo꞉ sen kalu imilig nowo꞉ sili alita꞉sen. Kaluka꞉isale ililo꞉ asulab aundo꞉ da꞉feab a꞉no꞉ ko꞉lo꞉ sili alita꞉sen. ");
INSERT INTO bco_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","O꞉g ho꞉len a꞉namio꞉, kalu nowo꞉ mada mogago꞉le ko꞉lo꞉ dibolowa sen, ene wiyo꞉ Balabas. ");
INSERT INTO bco_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isale modo꞉wo꞉ Failata꞉ aya kegenelia꞉sa꞉ga꞉ dowabiki, Failat eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giliyo꞉ niyo꞉ o꞉b ko꞉lo꞉ sili alifoma꞉ki asulaya? Niyo꞉ Balabas a꞉no꞉ ko꞉lo꞉ sili alito꞉lo꞉, o꞉ Ya꞉su, Godeya꞉lo꞉ Da꞉feyo꞉ kalu a꞉la꞉do꞉ sa꞉lab a꞉no꞉ ko꞉lo꞉ sili alifoma꞉ki asulaya?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Failat elo꞉ a꞉la꞉do꞉ dabu ba꞉ba꞉ a꞉no꞉, mo꞉wo꞉ eyo꞉ a꞉la꞉asulo꞉. Yu misa꞉ kalu iliyo꞉ Ya꞉su o꞉lia꞉yo꞉ mo꞉beaki gadia꞉sa꞉ga꞉, Ya꞉suwo꞉ emo꞉ tililia꞉ mio꞉lo꞉b a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","A꞉la꞉ta꞉ga꞉ Failat e mo꞉walila꞉sendo꞉ i fofodo꞉ wa꞉l a꞉na sen amio꞉, ingaya꞉yo꞉ to nowo꞉ emo꞉wo꞉ a꞉la꞉saga꞉fo꞉, “O꞉g nuluwo꞉ niyo꞉ kalu we o꞉lia꞉ mogai ofolo꞉. Kalu we digalo꞉ kalu ko꞉lo꞉, giyo꞉ emo꞉wo꞉ mogago꞉ imili nowo꞉ dimida꞉so꞉bo.” Eyo꞉ towo꞉ a꞉la꞉saga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ko꞉sega bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu ko꞉go꞉dego꞉ kalu iliyo꞉ kaluka꞉isale kegeo꞉ a꞉ma꞉ asulo꞉wo꞉ digidalifelakiyo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ Balabaso꞉ sili alitaki, Ya꞉suwo꞉ sanama꞉ki Failatbo꞉wo꞉ dabu ba꞉da꞉bi,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","A꞉la꞉go꞉ko꞉lo꞉ Failat eyo꞉ kaluka꞉isale kegeo꞉ imo꞉wo꞉ wa꞉ka dabu ba꞉dakiyo꞉, “Giliyo꞉ niyo꞉ kalu a꞉la꞉ we o꞉b ko꞉lo꞉ sili alifoma꞉ki asulaya?” A꞉la꞉dabu ba꞉dabiki, kalu kegeo꞉ a꞉ma꞉ sa꞉lakiyo꞉, “Balabaso꞉ sili alifoma” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Failat eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ a꞉la꞉dimidalikiyo꞉, Ya꞉su Godeya꞉lo꞉ Da꞉feyo꞉ kalu a꞉la꞉do꞉ sa꞉lab a꞉no꞉, giliyo꞉ niyo꞉ e waga dimidama꞉ki asulaya?” A꞉la꞉sa꞉labiki, iliyo꞉ tambo a꞉la꞉sio꞉, “E i malana aluma.” ");
INSERT INTO bco_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Iliyo꞉ a꞉la꞉sa꞉labiki, Failat eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Mo꞉wo꞉ ha꞉? Eyo꞉ mogago꞉wo꞉ o꞉b dimido꞉lo꞉bo꞉?” A꞉la꞉dabu ba꞉ba꞉ ko꞉sega kaluka꞉isale kegeo꞉ i a꞉ma꞉yo꞉ halaido꞉ ho꞉le sa꞉lakiyo꞉, “E i malana aluma” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Kaluka꞉isale ili asulo꞉wo꞉ mo꞉tinakilo꞉ egeledo꞉ babuma꞉no꞉ dowab a꞉no꞉ Failat eyo꞉ asula꞉sa꞉ga꞉yo꞉, eyo꞉ ho꞉no꞉ dia꞉sa꞉ga꞉, ene dagiyo꞉ kaluka꞉isale kegeo꞉ siwa꞉l a꞉na to꞉go꞉do꞉. Eyo꞉ dagiyo꞉ to꞉go꞉dakiyo꞉ a꞉la꞉sio꞉, “Digalo꞉ kalu wema꞉ ho꞉bo꞉ tuma꞉nigab we, mo꞉wo꞉ ne amio꞉ aundo꞉ma. Hala dimido꞉ a꞉no꞉ giya dowab.” ");
INSERT INTO bco_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Kaluka꞉isale tambo iliyo꞉ a꞉ma꞉la꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Kalu sana sowakilo꞉ ho꞉bo꞉ tulab we ninin ami a꞉la꞉ta꞉ga꞉ nini so꞉waya doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","A꞉la꞉fo꞉ko꞉lo꞉ Failat eyo꞉ Balabaso꞉ kaluka꞉isalelo꞉wa hamana꞉ki sili alita꞉sa꞉ga꞉, ene da꞉la꞉di kaluwa꞉yo꞉ Ya꞉suwo꞉ meya꞉ sanama꞉ki ta꞉fo꞉. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉, eyo꞉ Ya꞉suwo꞉ i malana sana soma꞉ki, ene da꞉la꞉di kaluwa꞉ dagiya difa꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gamani misa꞉ kalu a꞉ma꞉ ene da꞉la꞉di kalu iliyo꞉ Ya꞉suwo꞉ gamani hen a꞉na tililia꞉ tina꞉sa꞉ga꞉yo꞉, da꞉la꞉di kaluwo꞉ tambo a꞉na ho꞉le kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Iliyo꞉ Ya꞉suwa꞉ helebeso꞉go꞉ hagola꞉sa꞉ga꞉, helebeso꞉g ho꞉mo꞉solo꞉ sambo nowo꞉ Ya꞉suwa kalifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","A꞉la꞉ta꞉ga꞉ misa꞉ kalu alan ene misa꞉ amilo꞉ sa꞉ga꞉lan o꞉ngo꞉ dimida꞉sa꞉ga꞉, iliyo꞉ me olo꞉ a꞉no꞉ hega꞉sa꞉ga꞉, Ya꞉suwa꞉ misa꞉ya sa꞉ga꞉li alifa꞉. Iliyo꞉ bibulu nowo꞉ Ya꞉suwa꞉ dagi ililiba dia꞉takiyo꞉, iyo꞉ elo꞉wa gulalu misa꞉fu alilaki, e a꞉na dio꞉ge sa꞉lakiyo꞉, “Ge Yu kaluka꞉isaleya꞉ misa꞉yo꞉ ge ko꞉lo꞉, niliyo꞉ gi wiyo꞉ duludo꞉l,” a꞉la꞉sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","A꞉la꞉ta꞉ga꞉ iliyo꞉ e kodofa꞉ fugalakiyo꞉, da꞉fa꞉ a꞉no꞉ dia꞉ga꞉, Ya꞉suwa꞉ misa꞉ya yame tandeo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","A꞉la꞉ digagade o꞉ga꞉ sa꞉la꞉sa꞉ga꞉yo꞉, so꞉g Ya꞉su amilo꞉ kalifa꞉ a꞉no꞉ dugulia꞉ga꞉ dia꞉takiyo꞉, so꞉g enedo꞉leyo꞉ a꞉na kalifa꞉. A꞉la꞉ta꞉ga꞉yo꞉ Ya꞉suwo꞉ i malana alula꞉sa꞉ga꞉ sana soma꞉ki ha꞉la꞉ya tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Iyo꞉ Ya꞉su o꞉lia꞉ amisa꞉n ha꞉la꞉ya ha꞉na꞉len ami, Sailini kalu nowo꞉ ene wiyo꞉ Saimon ko꞉lo꞉, toga ya꞉len ami galilia꞉sa꞉ga꞉, Ya꞉suwa꞉ i malan a꞉no꞉ emo꞉ dia꞉hamana꞉ki dibodo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Iliyo꞉ Ya꞉suwo꞉ tililia꞉ ha꞉na꞉ga꞉, Golgoda a꞉la꞉do꞉ sa꞉lab hen a꞉na fa꞉la꞉dowo꞉. Golgoda a꞉la꞉do꞉ sa꞉lab mo꞉wo꞉ we, hen misa꞉ki. ");
INSERT INTO bco_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Iliyo꞉ wain ho꞉n o꞉lia꞉ mulumulo꞉ halan o꞉lia꞉yo꞉ wo꞉gela꞉sa꞉ga꞉, Ya꞉sumo꞉ maiya꞉ki dimi, ko꞉sega eyo꞉ nola ba꞉da꞉sa꞉ga꞉ mo꞉ma꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","A꞉la꞉ta꞉ga꞉ da꞉la꞉di kalu iliyo꞉ e i malana alula꞉sa꞉ga꞉yo꞉, helebeso꞉g elo꞉ sa꞉ga꞉la꞉sen ko꞉lo꞉ duda꞉sa꞉ga꞉lo꞉ difa꞉ a꞉no꞉, da꞉la꞉di kalu noma꞉yo꞉ abe dia꞉nigaba꞉le a꞉la꞉liki, iyo꞉ ibuwo꞉ a꞉na heyakiyo꞉, helebeso꞉g a꞉no꞉ egele so꞉go꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Da꞉la꞉di kalu iyo꞉ a꞉na siliki, Ya꞉su a꞉namilo꞉ dimidabo꞉ ko꞉lo꞉ bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iliyo꞉ e mo꞉walilakilo꞉ sana sowab a꞉ma꞉ mo꞉ a꞉no꞉ ko꞉lo꞉ sa꞉sa꞉lakiyo꞉, Kalu we Ya꞉su. Yu kaluka꞉isaleya꞉ Misa꞉ Kalu Alandeyo꞉ we a꞉la꞉liki sa꞉sa꞉lo꞉ ko꞉lo꞉, iliyo꞉ Ya꞉suwa꞉ misa꞉ wa꞉l doba꞉da꞉ i malana alu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ya꞉su e o꞉lia꞉yo꞉ afalo꞉ dia꞉sen kalu a꞉la꞉ nowo꞉ e aniba alu. Nowo꞉ ililib doba꞉da꞉, nowo꞉ fo꞉fo꞉doloba꞉da꞉, a꞉la꞉alu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","40","Kaluka꞉isale iyo꞉ Ya꞉sulo꞉ alu alifa꞉ a꞉na tinia꞉likiyo꞉, mogago꞉ towo꞉ Ya꞉sumo꞉ sa꞉la꞉liki tinia꞉len. Iliyo꞉ misa꞉yo꞉ mumalola꞉liki, dio꞉ge sa꞉lakiyo꞉, “Giyo꞉ Godeya꞉ malilo꞉ ayo꞉ bidila꞉sa꞉ga꞉, ho꞉len otalen amio꞉ ho꞉gi dialifa꞉no꞉ a꞉la꞉sio꞉ ko꞉lo꞉, go꞉no꞉na꞉ma꞉la꞉yo꞉ asuwa꞉foma. Ge Godeya꞉ ene so꞉walelalega, go꞉no꞉no꞉ i malan a꞉no꞉ ta꞉ta꞉ga꞉ timina,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","42","Ililo꞉ dimido꞉ o꞉leauka, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwo꞉lo꞉, elelo꞉ widan kaluwo꞉lo꞉, a꞉la꞉ta꞉ga꞉ Yu ko꞉go꞉dego꞉ kaluwo꞉lo꞉ iliyo꞉ Ya꞉sumo꞉wo꞉ dio꞉ge sa tandeakiyo꞉ a꞉la꞉sio꞉, “Eyo꞉ kalu nolo꞉ asuwa꞉ta꞉sen ko꞉sega, enena꞉ma꞉la꞉yo꞉ mo꞉asuwa꞉tabo꞉lo꞉ka꞉. E Isolael kaluka꞉isaleya꞉ misa꞉ kalu alan ko꞉lo꞉, e enena꞉ma꞉la꞉yo꞉ i malano꞉ ta꞉ta꞉ga꞉ tindalega, nio꞉ e amio꞉ a꞉na tilida꞉ba꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eyo꞉sa a꞉la꞉sio꞉, ‘Ne Godeya꞉ ene so꞉wa ko꞉lo꞉, Gode eyo꞉ ne mada bo꞉fo꞉mela꞉ib,’ a꞉la꞉sio꞉. A꞉la꞉fo꞉ko꞉lo꞉ Gode eyo꞉ e hendele asulalega, o꞉go꞉ e o꞉li asuwa꞉fa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A꞉la꞉ta꞉ga꞉ afalo꞉ dia꞉sen kalu a꞉la꞉ e o꞉lia꞉lo꞉ alu alifa꞉ a꞉ma꞉yo꞉lo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉ka dio꞉ge sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Disi dowabiki, hen a꞉no꞉ tambo sololiya꞉ go꞉lula꞉ta꞉ga꞉lo꞉ eleno꞉, ga꞉lo ofa꞉siyo꞉ asola dowabi edo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ofa꞉siyo꞉ asola dowabiki, Ya꞉su eyo꞉ ogolo halale ho꞉idaki, a꞉la꞉ho꞉ido꞉, “Eloi, Eloi, lama sabag tani.” To wema꞉ ha꞉go꞉ we, “Ni Gode, ni Gode, giyo꞉ ne wangabiki gola ba꞉daya?” ");
INSERT INTO bco_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kaluka꞉isale nol anib amilo꞉ kagafo꞉len a꞉ma꞉yo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Kalu we Elaiyayo꞉ ho꞉idab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kalu nowo꞉ bo꞉bo꞉ge nai ha꞉na꞉ga꞉, so꞉g gedeo꞉ heb a꞉no꞉ dia꞉sa꞉ga꞉, wain ho꞉n sesedo꞉ a꞉no꞉ ho꞉na gelelia꞉ga꞉yo꞉, ibuwa mela꞉sa꞉ga꞉ Ya꞉sumo꞉ maiya꞉ki dimi. ");
INSERT INTO bco_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kalu nolba꞉yo꞉ a꞉la꞉sio꞉, “Elaiya e ya꞉ga꞉yo꞉ asuwa꞉fa꞉nigaba꞉le, nio꞉ o꞉bo꞉fo꞉mela꞉niki,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ wa꞉ka ogolo halale ho꞉ida꞉sa꞉ga꞉ ami ha꞉fo꞉wo꞉ a꞉na siliga꞉taki sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","O꞉g a꞉namio꞉ helebeso꞉g ko꞉lo꞉ Godeya꞉ malilo꞉ ayamilo꞉ dehedo꞉ a꞉no꞉ iwalu halona a꞉la꞉ta꞉ga꞉ usa ba꞉da꞉i tinda꞉ga꞉ asula꞉. A꞉la꞉ta꞉ga꞉ henfelo꞉ wenamio꞉ hinio꞉ tilaki a꞉la꞉ta꞉ga꞉ u nolo꞉ usa basale ane. ");
INSERT INTO bco_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","A꞉la꞉ta꞉ga꞉ sowo꞉ kalu dali alifelo꞉ me a꞉no꞉lo꞉ kolaetabiki, kaluka꞉isale modo꞉ Gode amilo꞉ tili dabu ko꞉lo꞉ dane ane a꞉no꞉ mela꞉no꞉wo꞉ dia꞉sa꞉ga꞉ dasi alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","A꞉la꞉ta꞉ga꞉ Ya꞉suwo꞉ dasila꞉sa꞉ga꞉ a꞉labiki, kaluka꞉isale dasi alifelo꞉ i a꞉no꞉ daido꞉ hen a꞉no꞉ ta꞉ta꞉sa꞉ga꞉ Ya꞉lusalem malilo꞉ amisa꞉n a꞉na tiha꞉nabikiyo꞉, kaluka꞉isale modo꞉wa꞉yo꞉ i a꞉no꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Da꞉la꞉dilo꞉ bo꞉fo꞉lowan misa꞉ kalu o꞉lia꞉ ene da꞉la꞉di kalu Ya꞉sulo꞉ bo꞉fo꞉lab i o꞉lia꞉ma꞉yo꞉ hini tilab o꞉lia꞉ kelego꞉ nol fa꞉la꞉dowab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ mada tagilaki a꞉la꞉sio꞉, “Hendele, kalu we Godeya꞉ ene kalu so꞉walelo꞉ka꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ka꞉isale nolo꞉ Ya꞉suwo꞉ asuwa꞉ta꞉liki, Ga꞉lili a꞉na a꞉la꞉ta꞉ga꞉ Ya꞉su kudu mio꞉ ko꞉lo꞉, o꞉g a꞉namio꞉ ka꞉isale modo꞉ i a꞉no꞉ ha꞉lu ko꞉na꞉ kagafo꞉liki bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ka꞉isale i a꞉namilo꞉ elen a꞉no꞉ nowo꞉ Magdala amisa꞉n ga Malia, nowo꞉ Malia, Ya꞉ma꞉s o꞉lia꞉ Yosa꞉b o꞉lia꞉ma꞉ anowo꞉, a꞉la꞉ta꞉ga꞉ nowo꞉ Sa꞉ba꞉diya꞉ inso꞉ a꞉la꞉ma꞉ anowo꞉ ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ga꞉lo dowabiki, Alimatea amisa꞉n wilo꞉ kalu nowo꞉ ene wiyo꞉ Yosa꞉b e a꞉na mio꞉. Ya꞉suwa꞉lo꞉ tili wida꞉sen kalu nowo꞉ e. ");
INSERT INTO bco_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E Failatdo꞉wa ha꞉na꞉sa꞉ga꞉, Ya꞉suwa꞉ do꞉mo꞉wo꞉ tagama꞉nigo꞉ka꞉ a꞉la꞉liki dabu ba꞉ba꞉. A꞉la꞉gabiki Failat eyo꞉ da꞉la꞉di kalu imo꞉ sa꞉lakiyo꞉, Ya꞉suwa꞉ do꞉mo꞉wo꞉ emo꞉ dimina a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iliyo꞉ dimiabikiyo꞉, Yosa꞉b eyo꞉ Ya꞉suwa꞉ do꞉mo꞉wo꞉ dia꞉sa꞉ga꞉yo꞉ helebeso꞉g nafaleya꞉ bobodo꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","A꞉la꞉ta꞉ga꞉ eyo꞉ do꞉mo꞉ a꞉no꞉ dia꞉ha꞉na꞉sa꞉ga꞉yo꞉, enedo꞉ u no꞉no꞉ ho꞉gi dimido꞉ a꞉na difa꞉. Eyo꞉ u bamo alan nowo꞉ fo꞉fo꞉gola꞉i ya꞉sa꞉ga꞉, toga꞉meya asibalitakiyo꞉, e a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Malia Magdala o꞉lia꞉ Malia no o꞉lia꞉yo꞉, a꞉la꞉yo꞉ daido꞉ me imilib a꞉na siliki bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namilo꞉ dimidaefa꞉no꞉ ho꞉len a꞉no꞉ eletabikiyo꞉, ali kea꞉fo a꞉namio꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Fa꞉lisi kalu i o꞉lia꞉yo꞉ Failatdo꞉ ba꞉ba꞉ni ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Iliyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Kalu alan, niliyo꞉ madalilo꞉ sa꞉lan kalu wema꞉lo꞉ e o꞉silikilo꞉ to sio꞉ a꞉no꞉ asulufo꞉lo꞉l. Eyo꞉, ‘Ne ho꞉len otaleno꞉ ta꞉ta꞉sa꞉ga꞉yo꞉ a꞉ma꞉la꞉ dasima꞉no꞉,’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ da꞉la꞉di kalumo꞉wo꞉ daido꞉ a꞉no꞉ ho꞉len otalen a꞉namio꞉ dinafa bo꞉fo꞉lubika꞉ a꞉la꞉sa꞉la꞉bi. A꞉la꞉bo꞉ mo꞉dimidalega, enedo꞉ tili wida꞉sen kalu iyo꞉ ya꞉sa꞉ga꞉, ene do꞉mo꞉wo꞉ afale dia꞉ha꞉nakiyo꞉, kaluka꞉isalemo꞉wo꞉ e a꞉ma꞉la꞉ dasilia꞉gane ka꞉ a꞉la꞉sa꞉ma꞉ib. A꞉la꞉galikiyo꞉ ililo꞉ to ho꞉gi madalilo꞉ sa꞉lab a꞉ma꞉yo꞉, to elo꞉ tamin amilo꞉ madalilo꞉ sio꞉ a꞉no꞉, a꞉ma꞉ tininima꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Iliyo꞉ a꞉la꞉sa꞉labikiyo꞉, Failat eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ da꞉la꞉di kalu we dia꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ daido꞉ a꞉no꞉ dinafa bo꞉fo꞉melea a꞉la꞉sa꞉la꞉bi. Gio꞉ ha꞉na꞉sa꞉ga꞉ daido꞉ toga꞉me a꞉no꞉ mada halale uludu alifa꞉no꞉ dimida꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","A꞉la꞉sa꞉labikiyo꞉ iyo꞉ ha꞉na꞉sa꞉ga꞉ daido꞉ toga꞉me a꞉namio꞉ kalu nowo꞉ tinabena꞉ki, ele ba꞉ba꞉no꞉ kelego꞉ nowo꞉ dia꞉taki uludu alifa꞉ ko꞉lo꞉, da꞉la꞉di kalu nolo꞉ dia꞉sa꞉ga꞉ a꞉na bo꞉fo꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ha꞉fo꞉lo꞉ Dowan ho꞉leno꞉ eletabiki, doma꞉ kea꞉fo ho꞉letabikiyo꞉, Malia Magdala o꞉lia꞉ Malia no o꞉lia꞉yo꞉ daido꞉ ba꞉ba꞉no꞉ a꞉la꞉ta꞉ga꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Wigibole a꞉naka hini alano꞉ a꞉na tilabikiyo꞉, Alana꞉ ene ma꞉mul kalu a꞉no꞉ Hebene a꞉la꞉ta꞉ga꞉ tinda꞉sa꞉ga꞉, daido꞉ melo꞉ a꞉na fa꞉la꞉dowakiyo꞉, u alana꞉lo꞉ asi alifa꞉ a꞉no꞉ fo꞉fo꞉golowa꞉taki, e wa꞉l a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ma꞉mul kalu a꞉ma꞉ ene wo꞉lokano꞉, wabeleg ho꞉ o꞉ngo꞉ ko꞉lo꞉ ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ ene helebeso꞉go꞉lo꞉ kol ho꞉lo꞉ o꞉ngo꞉ ko꞉lo꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Da꞉la꞉di kaluwo꞉ a꞉no꞉ ba꞉dakiyo꞉, iyo꞉ tagilaki bibisoda꞉sa꞉ga꞉yo꞉, hena tulufufuda꞉sa꞉ga꞉ habayo꞉ sowaki, sowo꞉ kalu o꞉ngo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ko꞉sega ma꞉mul kalu eyo꞉ ga a꞉la꞉ o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ mada tagila꞉so꞉bo. Ga꞉go꞉ Ya꞉su i malan amilo꞉ alu a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉ni mio꞉lo꞉b niyo꞉ a꞉la꞉asulo꞉l. ");
INSERT INTO bco_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","E wilo꞉ mo꞉a꞉lab. Tamin amilo꞉ enedo꞉ sio꞉ a꞉la꞉gaki dasilia꞉gane. A꞉la꞉go꞉ko꞉lo꞉ ga꞉go꞉ ene do꞉mo꞉lo꞉ delen we ba꞉ba꞉ni mena. ");
INSERT INTO bco_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","A꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, ga꞉go꞉ bo꞉bo꞉ge ha꞉na꞉sa꞉ga꞉ enedo꞉ tili wida꞉sen kalu imo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘E sowa꞉sa꞉ga꞉, a꞉ma꞉la꞉ dasilia꞉gane ko꞉lo꞉lab. A꞉la꞉go꞉ko꞉lo꞉, e tamin doba꞉da꞉ Ga꞉lili ha꞉nab ko꞉lo꞉, giliyo꞉ e a꞉na elena ba꞉ba꞉ib.’ Ne to we ko꞉lo꞉ gimo꞉ sa꞉ma꞉ni mio꞉.” Ma꞉mul kalu eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ka꞉isale a꞉la꞉ a꞉no꞉ tagio꞉lo꞉ dowo꞉ ko꞉sega, sagalo꞉wo꞉lo꞉ mada alan dowakiyo꞉, daido꞉ a꞉no꞉ bo꞉bo꞉ge ta꞉ta꞉sa꞉ga꞉, dalalelia꞉ ha꞉na꞉sa꞉ga꞉yo꞉, enedo꞉ tili wida꞉sen kalu imo꞉ sa꞉ma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wigibole a꞉naka, Ya꞉su eyo꞉ a꞉la꞉yo꞉ toga gidakiyo꞉, sagalo꞉ towo꞉ a꞉la꞉mo꞉wo꞉ sio꞉. A꞉la꞉yo꞉ elo꞉wa ma꞉uwa꞉ya ya꞉sa꞉ga꞉, e giba ta꞉li dofo꞉liki, emo꞉ gulugululo꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A꞉la꞉gabiki Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ mada tagila꞉so꞉bo. Ga꞉go꞉ ha꞉na꞉sa꞉ga꞉ ni nao imo꞉wo꞉ Ga꞉lili hamana a꞉la꞉sa꞉la꞉bi. Iliyo꞉ ne a꞉na elena ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ka꞉isale a꞉la꞉ a꞉no꞉ toga o꞉ha꞉na꞉labikiyo꞉, da꞉la꞉di kalu nol daido꞉lo꞉ bo꞉fo꞉len i a꞉no꞉ amisa꞉n usa ti ha꞉na꞉sa꞉ga꞉yo꞉, kelego꞉ a꞉namilo꞉ fa꞉la꞉dowo꞉ a꞉no꞉, iliyo꞉ so꞉mea꞉sen misa꞉ kalumo꞉ tambo sio꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","13","Bobalo꞉ so꞉mea꞉sen misa꞉ kaluwo꞉lo꞉, Yu ko꞉go꞉do꞉ kalu i o꞉lia꞉ kegeaki nenela꞉sa꞉ga꞉yo꞉, egelebo꞉ towo꞉ saefa꞉. Iliyo꞉ moleyo꞉ modo꞉ ko꞉lo꞉ da꞉la꞉di kalumo꞉ dimiakiyo꞉ a꞉la꞉sio꞉, “Giliyo꞉ kaluka꞉isalemo꞉wo꞉ mada a꞉la꞉sa꞉la꞉bi, ‘Nio꞉ alifo꞉lo꞉liki, enedo꞉ tili wida꞉sen kaluwo꞉ nulu ya꞉sa꞉ga꞉, ene do꞉mo꞉wo꞉ afale dia꞉gane.’ ");
INSERT INTO bco_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tif amio꞉ gamani kalu alan eyo꞉ gio꞉ alifo꞉lenka꞉ a꞉la꞉bo꞉ to malolab a꞉no꞉ da꞉dalega, niliyo꞉ to a꞉no꞉ e o꞉lia꞉ digalalikiyo꞉, gio꞉ hida꞉yo꞉wo꞉ aundo꞉ma doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Imo꞉wo꞉ a꞉la꞉sa꞉labikiyo꞉, da꞉la꞉di kalu iliyo꞉ mole a꞉no꞉ dia꞉sa꞉ga꞉yo꞉, imo꞉lo꞉ to sio꞉ a꞉no꞉ ko꞉lo꞉ kudu ane. A꞉la꞉ta꞉ga꞉ madali to ililo꞉ malolab a꞉no꞉ sa꞉labikiyo꞉, Yu kaluka꞉isaleyo꞉ da꞉da꞉i ane ko꞉lo꞉, o꞉go꞉lo꞉ Yuda iliyo꞉ to a꞉no꞉ o꞉safo꞉ko꞉ ha꞉na꞉lab. ");
INSERT INTO bco_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","A꞉la꞉fo꞉ko꞉lo꞉ enedo꞉ tili wida꞉sen kalu kelen a꞉la꞉fo꞉ i a꞉no꞉ Ga꞉lili ha꞉na꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉lo꞉ hen misio꞉ imo꞉lo꞉ ha꞉na꞉bika꞉ a꞉la꞉do꞉ sio꞉ a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Iliyo꞉ Ya꞉su e ba꞉da꞉sa꞉ga꞉yo꞉, e a꞉na wabudaki gulugululo꞉. Ko꞉sega nolo꞉ asulo꞉wo꞉ a꞉la꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","A꞉la꞉gabikiyo꞉, Ya꞉su e ma꞉uwa꞉ya ya꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ kelego꞉ Hebenelo꞉ o꞉lia꞉ henfelo꞉ amilo꞉ o꞉lia꞉yo꞉ nemo꞉ bo꞉fo꞉melea꞉kiyo꞉, wi alan o꞉lia꞉ halaido꞉ o꞉lia꞉yo꞉ nemo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ ha꞉na꞉siakiyo꞉, henfelo꞉ wenamilo꞉ so꞉lo꞉ ko꞉li ko꞉lilo꞉ tambo amio꞉, nilo꞉ tili wida꞉sen kaluka꞉isale fa꞉la꞉doma꞉ki ta꞉ta꞉lubi. A꞉la꞉dimida꞉likiyo꞉ Dowa꞉ wi ami, Ene So꞉waya꞉ wi ami, a꞉la꞉ta꞉ga꞉ Mamaya꞉ wi ami, giliyo꞉ i a꞉no꞉ ho꞉n amio꞉ a꞉na to꞉lola꞉bi. ");
INSERT INTO bco_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","A꞉la꞉ta꞉ga꞉ ni to ko꞉lo꞉ gimo꞉lo꞉ tambo wida꞉i mio꞉ a꞉no꞉, giliyo꞉ iyo꞉ kudu ha꞉na꞉melea꞉ki wida꞉lubi. Dabuma, ho꞉len ta꞉i mio꞉ we semo꞉ edalikiyo꞉, ne gi o꞉lia꞉ ho꞉leno꞉ tambo dowa꞉i ha꞉na꞉mela꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Godeya꞉ ene So꞉wa, Ya꞉su Kelisowa꞉ ene to nafalo꞉ mo꞉mo꞉do꞉wo꞉ we. ");
INSERT INTO bco_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Godeya꞉ tolo꞉ dinali sa꞉lan kalu, Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉ da꞉lab, “ Ge semo꞉fa꞉la꞉dowo꞉ amio꞉, tolo꞉ sa꞉ma꞉no꞉ kalu nowo꞉ tamina iliga꞉takiyo꞉, gelo꞉ mia꞉no꞉ tog a꞉no꞉ e fadama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Kalu imilig nowo꞉ kalulo꞉ma kalaleli hen a꞉na iliki ho꞉le sa꞉lakiyo꞉, ‘Kalu Alando꞉ mia꞉no꞉ togo꞉ dinafama. Tog a꞉no꞉ digale fadaifoma.’ ” ");
INSERT INTO bco_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","A꞉la꞉fo꞉ko꞉lo꞉ Yo꞉n e kalaleli hen a꞉na fa꞉la꞉dota꞉ga꞉ widakiyo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ gili mogago꞉ dimida꞉len a꞉no꞉ hala꞉ma꞉ki, gio꞉ asulo꞉wo꞉ nodola꞉sa꞉ga꞉ foga꞉le sama. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉ ho꞉na to꞉loma꞉ni ya꞉bi” a꞉la꞉sa꞉la꞉liki wida꞉i ane. A꞉la꞉ta꞉ga꞉ eyo꞉ iyo꞉ ho꞉n amio꞉ a꞉na to꞉lola꞉len. ");
INSERT INTO bco_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Yudia hen us a꞉namilo꞉ sa꞉sen o꞉lia꞉, Ya꞉lusalemdo꞉ sa꞉sen kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ Yo꞉n elo꞉wa tambo kegenema꞉ni ane. I a꞉namilo꞉ kegenema꞉nikilo꞉ ane a꞉no꞉ mogago꞉ dimida꞉leno꞉ foga꞉le sa꞉labikiyo꞉, iyo꞉ ho꞉n Yodan amio꞉ Yo꞉na꞉yo꞉ a꞉na to꞉lolo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yo꞉n elo꞉ helebeso꞉g ko꞉lo꞉ sa꞉ga꞉la꞉seno꞉ ka꞉mol fo꞉n ko꞉lo꞉ alula꞉sa꞉ga꞉ ka꞉la꞉sen. A꞉la꞉ta꞉ga꞉ no꞉ do꞉go꞉f nowo꞉ hoda꞉sa꞉ga꞉ yafu difa꞉. Elo꞉ ma꞉no꞉ ko꞉lo꞉ na꞉seno꞉ sa꞉gema o꞉lia꞉ kola꞉ ho꞉n o꞉lia꞉ ko꞉lo꞉ na꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A꞉la꞉fo꞉ko꞉lo꞉ elo꞉ to man sa꞉ma꞉ni mio꞉wo꞉ we. “Kalu ni fa꞉s amilo꞉ mia꞉nigab a꞉ma꞉ ene halaido꞉wo꞉ alan ko꞉lo꞉, ne e tinio꞉. Ne wilo꞉ma kalu ko꞉lo꞉, niyo꞉ e budi sa꞉ga꞉lo꞉ a꞉namilo꞉ me melealifa꞉ a꞉no꞉ ne gulalu siliki fagela꞉ma꞉no꞉wo꞉ mo꞉ililo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Niyo꞉ gio꞉ ho꞉ndeya to꞉lola꞉lo꞉l ko꞉sega, eyo꞉ gio꞉ Godeya꞉ Mamaya꞉ to꞉loma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ho꞉len a꞉namio꞉ Ya꞉suwo꞉ Nasala꞉t, Ga꞉lili hen a꞉na a꞉la꞉ta꞉ga꞉ Yo꞉ndo꞉wa fa꞉la꞉dowabiki, Yo꞉n eyo꞉ e Yodan amio꞉ a꞉na to꞉lolo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ya꞉suwo꞉ ho꞉na ti ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowabikiyo꞉, Hebeneyo꞉ kolaetaki, Mamayo꞉ o꞉ba꞉ hi o꞉ngo꞉ ko꞉lo꞉ tinda꞉ga꞉, eya mesa꞉ni yabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","A꞉na asitabiki, to nowo꞉ Hebene a꞉la꞉ta꞉ga꞉ sa꞉lakiyo꞉, “Ge no꞉no꞉n so꞉wa ha꞉fo꞉lo꞉ disa꞉yo꞉ ge ko꞉lo꞉, niyo꞉ ge mada alan asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ya꞉suwo꞉ ho꞉na to꞉lola꞉sa꞉ga꞉yo꞉, kalulo꞉ma kalaleli hen a꞉na, Mamaya꞉ tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","E ho꞉leno꞉ do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉no꞉ ilaboda꞉ no꞉ o꞉lia꞉ sia꞉lab amio꞉, ma꞉mula꞉ kaluwa꞉ bo꞉fo꞉len. E a꞉na sia꞉len amio꞉, Sa꞉da꞉na꞉ eyo꞉ Ya꞉suwo꞉ mogago꞉ dimidama꞉ki, a꞉la꞉ta꞉ga꞉ da꞉fe ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yo꞉n e dibolo a usa to꞉lola꞉sa꞉ga꞉ a꞉labiki, Ya꞉suwo꞉ Ga꞉lili hen a꞉namio꞉ Godeya꞉ to nafayo꞉ a꞉na walama꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Eyo꞉ a꞉la꞉wido꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉lendeyo꞉ ko꞉na꞉ma dowab. A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ o꞉go꞉ asulo꞉wo꞉ nodola꞉sa꞉ga꞉, to nafa we tilidabuma. Ho꞉lendeyo꞉ o꞉gdo꞉ fa꞉la꞉dowabo꞉ we.” ");
INSERT INTO bco_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ya꞉suwo꞉ Ga꞉lili ho꞉n golo꞉ aniba sia꞉lena, ka꞉lo꞉ to꞉lolan kalu a꞉la꞉, Saimon dia꞉ ene ao Andululia꞉yo꞉ dage to꞉lola꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","A꞉la꞉ a꞉no꞉ galilia꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉yo꞉ a꞉la꞉sio꞉, “Niyo꞉ ga꞉go꞉ kalu tili sa꞉la꞉lan man a꞉no꞉ ko꞉lo꞉ walama꞉no꞉. Ga꞉go꞉ ne kudu mena.” ");
INSERT INTO bco_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Wigibole a꞉naka a꞉la꞉yo꞉ dageyo꞉ ta꞉ta꞉sa꞉ga꞉, Ya꞉su e ko꞉lo꞉ kudu ane. ");
INSERT INTO bco_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ya꞉suwo꞉ heb doba꞉da꞉ o꞉fina꞉sa꞉ga꞉yo꞉, Sa꞉ba꞉diya꞉ inso꞉ a꞉la꞉, Ya꞉ma꞉s o꞉lia꞉ ene ao Yo꞉no꞉, ho꞉n ko꞉su usa iliki, dage digala꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","A꞉la꞉ a꞉no꞉ Ya꞉su eyo꞉ ba꞉da꞉sa꞉ga꞉, elo꞉wa mena꞉ki ho꞉ido꞉. Ho꞉idabiki a꞉la꞉ma꞉yo꞉ iya Sa꞉ba꞉di sulo꞉wo꞉ a꞉la꞉ta꞉ga꞉ ene nanog dian kalu o꞉lia꞉yo꞉ ho꞉n ko꞉su ka ta꞉ta꞉ga꞉, Ya꞉su kudu ane. ");
INSERT INTO bco_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Iyo꞉ Kabaniom ha꞉na꞉sa꞉ga꞉ sen amio꞉, Ha꞉fo꞉lo꞉ Dowan ho꞉leno꞉ a꞉na fa꞉la꞉dowabiki, Ya꞉suwo꞉ ha꞉na꞉sa꞉ga꞉ Godeya꞉ mano꞉ tolo꞉ wida꞉sen ayamio꞉ a꞉na mo꞉mo꞉da wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kaluka꞉isale iyo꞉ to man elo꞉ widab a꞉no꞉ da꞉da꞉sa꞉ga꞉ mada molo dabu. Mo꞉wo꞉ elelo꞉ wida꞉sen kalu i a꞉ma꞉yo꞉ noma꞉lo꞉ sa꞉sa꞉lo꞉ a꞉no꞉ agela꞉sa꞉ga꞉ wido꞉. Ko꞉sega Ya꞉su eyo꞉ elelo꞉ wida꞉sen kaluwa꞉lo꞉ wido꞉ aumbo꞉ mo꞉widaki, eyo꞉ ene halaido꞉ o꞉lia꞉ iliki widabiki, iyo꞉ molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ya꞉suwo꞉ a꞉na wida꞉len amio꞉, kalu mama mogago꞉lo꞉ dowa꞉sen nowo꞉ tolo꞉ wida꞉sen aya sen ko꞉lo꞉, e Ya꞉su elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, Ya꞉suwo꞉ dabuma꞉ki ho꞉ido꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Ya꞉su, Nasala꞉t kalu ge, nilo꞉ wiyo꞉ wagama꞉ni mio꞉wo꞉? Ge nio꞉ ko꞉lo꞉ mogaila꞉ma꞉ni mio꞉wo꞉? Ne ge asulab. Godeya꞉ ene Malilo꞉ kaluwo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ko꞉sega Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge tola꞉so꞉bo! Ge kalu ko ta꞉ta꞉ga꞉, ha꞉la꞉ya handaloma!” ");
INSERT INTO bco_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","A꞉la꞉fo꞉ko꞉lo꞉ mama mogago꞉wa꞉yo꞉ kalu a꞉no꞉ mada alan bibisadoma꞉ki dimida꞉sa꞉ga꞉yo꞉, e gana gilia꞉sa꞉sa꞉ga꞉ a꞉na sili alifo꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ iligi ba꞉da꞉sa꞉ga꞉ egelebo꞉ nenelaki, “We waga dimidaba꞉le? Man halaido꞉ we, nio꞉ ho꞉gi widabiki bo꞉do꞉l. Mo꞉wo꞉ kalu wema꞉yo꞉ mama mogago꞉mo꞉wo꞉ towo꞉ halaido꞉ sa꞉labiki, iyo꞉ kudu ha꞉naki dimidab.” ");
INSERT INTO bco_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ bo꞉bo꞉ge malola꞉likilo꞉ aneyo꞉, Ga꞉lili hen a꞉no꞉ tambo da꞉da꞉i aneyo꞉ ililo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ya꞉suwo꞉, Ya꞉ma꞉so꞉, Yo꞉no꞉ iyo꞉ tolo꞉ wida꞉sen ayo꞉ ta꞉ta꞉sa꞉ga꞉, egele Saimon dia꞉ Andululia꞉ma꞉ aya ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","A꞉la꞉ta꞉ga꞉ Saimona꞉ ingaya꞉ anowo꞉ ofo꞉ walaf ba꞉la꞉sa꞉ga꞉ uwo꞉ba da꞉labiki, iliyo꞉ e bo꞉ba꞉ki Ya꞉sumo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Iliyo꞉ a꞉la꞉sa꞉labiki, Ya꞉suwo꞉ ga a꞉ma꞉ uwo꞉ba ba꞉ba꞉ni ha꞉na꞉sa꞉ga꞉, ene dagiya ta꞉li dota꞉ga꞉ ta꞉galifa꞉. A꞉la꞉dimidabiki ofo꞉ walaf e amilo꞉ deleno꞉ wigibo a꞉naka e falelabiki, ga a꞉ma꞉yo꞉ iyo꞉ asuwa꞉takiyo꞉, ma꞉no꞉wo꞉ imo꞉ maiya꞉ki so꞉fa꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","O꞉g ga꞉lo a꞉namio꞉, walaf nolo꞉lo꞉, mama mogago꞉lo꞉ dowo꞉ a꞉no꞉lo꞉ Ya꞉sumo꞉ falelema꞉ki a꞉la꞉ta꞉ga꞉ tilili mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","A꞉la꞉fo꞉ko꞉lo꞉ amisa꞉n kaluka꞉isaleyo꞉ tambo Ya꞉sulo꞉ sen a toga꞉me a꞉na kegeabiki, ");
INSERT INTO bco_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ya꞉su eyo꞉ kalu walaf ko꞉li ko꞉lilo꞉lo꞉ dowo꞉lo꞉ ya꞉sio꞉ a꞉no꞉ modo꞉ ko꞉lo꞉ falele alifelo꞉. Eyo꞉ mama mogago꞉wo꞉ kalu amilo꞉ dosdo꞉ elen a꞉no꞉ tambo o꞉luga꞉felo꞉. A꞉la꞉ta꞉ga꞉ mama mogago꞉ iliyo꞉ e Gode Inso꞉ a꞉la꞉bo꞉ asulo꞉ ko꞉lo꞉, Eyo꞉ mamamo꞉wo꞉ towo꞉ sama꞉kiyo꞉ fogo꞉ mo꞉dimi. ");
INSERT INTO bco_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kea꞉fo nulu sololi olabiki, Ya꞉suwo꞉ dasila꞉sa꞉ga꞉, ayo꞉ ta꞉ta꞉sa꞉ga꞉, ina꞉lilo꞉ Godemo꞉lo꞉ tolo꞉ sa꞉la꞉sen hen a꞉na sa꞉ma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimon, e o꞉lia꞉lo꞉ sa꞉sen kalu a꞉no꞉ Ya꞉suwo꞉ keda꞉li ha꞉na꞉sa꞉ga꞉yo꞉, ");
INSERT INTO bco_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ya꞉suwo꞉ galiliakiyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Kaluka꞉isaleyo꞉ tambo ge ba꞉ba꞉no꞉ a꞉la꞉ta꞉ga꞉ kedab.” ");
INSERT INTO bco_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ya꞉suwa꞉ a꞉ma꞉la꞉ sa꞉laki, “Niliyo꞉ amisa꞉n nol anib amilo꞉ sab a꞉na walama꞉ni ha꞉na꞉n. Mo꞉wo꞉ ne wilo꞉ mio꞉wo꞉ o꞉m.” ");
INSERT INTO bco_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","A꞉la꞉fo꞉ko꞉lo꞉ e mano꞉ Ga꞉lili anib amilo꞉ amisa꞉n kandayo꞉ a꞉no꞉ tambo wida꞉liki ha꞉nakiyo꞉, mama mogago꞉lo꞉ dosdo꞉wo꞉ o꞉luga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Aintalo꞉ dowo꞉ kalu nowo꞉ Ya꞉sulo꞉wa ya꞉ga꞉, gulalu misa꞉fu alilaki ha꞉iyakiyo꞉ a꞉la꞉sio꞉, “Kalu Alan giyo꞉ ne asuwa꞉fa꞉no꞉ asulalega, ne falele alifoma.” ");
INSERT INTO bco_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kalu a꞉ma꞉lo꞉ dimidab a꞉no꞉ Ya꞉su eyo꞉ nofola꞉sa꞉ga꞉, e dagiyo꞉ talagaki, kalu a꞉ma꞉ do꞉mo꞉wa golakiyo꞉ a꞉la꞉sio꞉, “Niyo꞉ ge o꞉li asuwa꞉fa꞉nigo꞉l ko꞉lo꞉, do꞉mo꞉ gilo꞉wo꞉ nafale ta꞉to꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Wigibole a꞉naka, aintalo꞉ dowo꞉ kalu a꞉no꞉ imula꞉sa꞉ga꞉, do꞉mo꞉ elo꞉wo꞉ nafale dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ya꞉su eyo꞉ kalu a꞉no꞉ o꞉g a꞉naka iliga꞉taka, emo꞉wo꞉ towo꞉ halaido꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ge ko꞉lo꞉ falele alito꞉l we kalu nolbo꞉wo꞉ mada sa꞉la꞉so꞉bo. Kaluka꞉isale tambowa꞉yo꞉ gi ogen ko falelo꞉lo꞉b a꞉la꞉asuluma꞉ki, ge bobalo꞉ so꞉mea꞉sen kalumo꞉wo꞉ walama꞉ni ha꞉na꞉sa꞉ga꞉, Mo꞉sa꞉sa꞉ ele saefa꞉ a꞉no꞉ kudu ha꞉nakiyo꞉, Godemo꞉ boba so꞉kugulu mea꞉niki hamana” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ko꞉sega a꞉la꞉bo꞉ mo꞉dimidaki, e amilo꞉ dimido꞉ a꞉no꞉ kalaba malola꞉li sia꞉len. A꞉la꞉fo꞉ko꞉lo꞉ to sa꞉la꞉i ane a꞉na ilikiyo꞉, Ya꞉suwo꞉ amisa꞉n usamilo꞉ mia꞉no꞉wo꞉ mo꞉mio꞉. A꞉la꞉gabiki e ha꞉la꞉ka sia꞉len ko꞉sega, amisa꞉n kaluka꞉isale ko꞉li ko꞉lilo꞉ iliyo꞉ e keda꞉i ya꞉sa꞉ga꞉ elo꞉ sena fa꞉la꞉dowa꞉len. ");
INSERT INTO bco_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ho꞉len nolo꞉ ta꞉ta꞉sa꞉ga꞉, Ya꞉suwo꞉ a꞉ma꞉la꞉ Kabaniom a꞉na fa꞉la꞉dowo꞉. Kaluka꞉isaleyo꞉ Ya꞉suwo꞉ a꞉ma꞉la꞉ mio꞉wo꞉ da꞉da꞉sa꞉ga꞉, ");
INSERT INTO bco_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","iyo꞉ a꞉na kegeakiyo꞉, a usamilo꞉ gala tandeo꞉wo꞉ wa꞉lifo꞉. A꞉la꞉ta꞉ga꞉ ha꞉la꞉ amio꞉lo꞉ modo꞉ kegeaki, tog amilo꞉ tina꞉no꞉wo꞉ kafo꞉labiki, Ya꞉su eyo꞉ to nafayo꞉ a꞉na wida꞉len. ");
INSERT INTO bco_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ya꞉su eyo꞉ mano꞉ wida꞉labikiyo꞉, kalu fa꞉la꞉da꞉ina꞉yo꞉ kalu gido꞉fo꞉wo꞉ ko꞉go꞉neli nowo꞉ Ya꞉sumo꞉ bo꞉ba꞉ki sesegasulia꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Iliyo꞉ kalu sesegasu a꞉no꞉ dia꞉ga꞉, Ya꞉sulo꞉wa dia꞉ ti ha꞉na꞉no꞉ asulo꞉ ko꞉sega, togo꞉ mo꞉gulabiki, iyo꞉ a fa꞉sa꞉ wa꞉la fa꞉la꞉ ha꞉na꞉sa꞉ga꞉, Ya꞉sulo꞉ a꞉lab imilib amilo꞉ a fugo꞉ a꞉no꞉ nolo꞉ da꞉ga꞉sula꞉sa꞉ga꞉, kalu sesegasulo꞉ ti ha꞉na꞉no꞉wo꞉ ho꞉wo꞉ dowabiki, iliyo꞉ kalu sesegasu a꞉no꞉ko꞉lia꞉ Ya꞉sulo꞉wa to꞉lolo꞉. ");
INSERT INTO bco_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ya꞉su eyo꞉ ililo꞉ tilidabu a꞉no꞉ ba꞉da꞉sa꞉ga꞉, ko꞉go꞉neli kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ni so꞉wa, gi mogago꞉ ko hala꞉sa꞉ga꞉ ga꞉lilo꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","A꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉ Fa꞉lisi kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ma꞉yo꞉ kele asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Mogago꞉wo꞉ hala꞉sa꞉ga꞉lo꞉ ga꞉lilan man a꞉no꞉ Gode imilig e dimida꞉sen. Kalu wema꞉lo꞉ a꞉la꞉do꞉ sa꞉lab we, waga sa꞉laigaba꞉le? Godeya꞉ heno꞉ e diaki sa꞉laigaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","I a꞉no꞉ kele asulabiki, Ya꞉suwa꞉yo꞉ asulo꞉ ililo꞉wo꞉ ba꞉da꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gililo꞉ kele asulo꞉wo꞉ alan dowaiko, waga asulaki gadi? ");
INSERT INTO bco_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","To sa꞉ma꞉no꞉wo꞉ halaido꞉leyo꞉ ho꞉bo꞉ko꞉mo꞉? Niyo꞉ tamin amio꞉ a꞉la꞉sio꞉, ‘Mogago꞉ da꞉labko o꞉go꞉ Godeya꞉ ga꞉lilab’ a꞉la꞉bo꞉, henfelo꞉ kaluwa꞉yo꞉ o꞉li sa꞉lano꞉? A꞉la꞉ta꞉ga꞉ to nowo꞉ we ‘Ge geo꞉ndo꞉ felo꞉wo꞉ kambola꞉sa꞉ga꞉ dasima!’ a꞉la꞉do꞉ sa꞉lab a꞉no꞉, henfelo꞉ kaluwa꞉yo꞉ o꞉li sa꞉lano꞉? ");
INSERT INTO bco_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ko꞉sega Kalule Dowo꞉ ne henfelo꞉ wena ilikiyo꞉, mogago꞉lo꞉ halakilo꞉ ga꞉lila꞉ma꞉no꞉ a꞉no꞉ ne amio꞉ halaido꞉wo꞉ a꞉labo꞉lo꞉b a꞉la꞉bo꞉ gio꞉ asuluma꞉kiyo꞉ walama꞉nigo꞉l.” A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ ko꞉go꞉neli kalumo꞉wo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Niyo꞉ gemo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Ge dasilia꞉ga꞉, sesegasu we dia꞉ga꞉, go꞉no꞉n aya hamana.” ");
INSERT INTO bco_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wigibole a꞉naka ko꞉go꞉neli kalu a꞉no꞉ dasilia꞉sa꞉ga꞉, geo꞉ndo꞉wo꞉ dia꞉b a꞉la꞉ta꞉ga꞉ ha꞉la꞉ya handalota꞉ga꞉ ha꞉nabikiyo꞉, kaluka꞉isale tambo inin siya꞉ ba꞉ba꞉. Iliyo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, molo asulaki, Godeya꞉ wiyo꞉ dulugu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Nio꞉ dimido꞉ wengo꞉wo꞉ mo꞉ba꞉da꞉sen ko꞉lo꞉ bo꞉do꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ho꞉len imilig nowo꞉ Ya꞉suwo꞉ wa꞉ka ho꞉n golo꞉ aniba ane. E a꞉na ha꞉na꞉gane amio꞉, kaluwo꞉ modo꞉ ko꞉lo꞉ elo꞉wa kegeabiki, imo꞉wo꞉ mano꞉ wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","E a꞉na ha꞉na꞉len amio꞉, Libai, Aofiusa꞉ ene so꞉wayo꞉ a꞉na ba꞉ba꞉. Libai e takis molelo꞉ dia꞉seno꞉ nowo꞉ e. Libai e ene nanogdo꞉ dia꞉sen aya sena ba꞉ba꞉. Ya꞉su eyo꞉ e ba꞉da꞉ga꞉ a꞉la꞉sio꞉, “Ge ne kudu mena.” A꞉la꞉sa꞉la꞉sa꞉ga꞉ ha꞉nabiki, Libai elo꞉ dasila꞉sa꞉ga꞉, Ya꞉su kudu ane. ");
INSERT INTO bco_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ya꞉su o꞉lia꞉ ene tiliwida꞉sen o꞉lia꞉yo꞉, Libaiya꞉ aya ha꞉na꞉sa꞉ga꞉ ma꞉no꞉ nakiyo꞉, takis molelo꞉ dia꞉sen kalu nolo꞉lo꞉, mogago꞉lo꞉ dimidan kaluwo꞉lo꞉, iyo꞉ tambo Ya꞉suwo꞉ kudu ane ko꞉lo꞉ ma꞉no꞉wo꞉ egele siliki na꞉len. ");
INSERT INTO bco_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","E ma꞉no꞉wo꞉ mogago꞉ kalu a꞉no꞉lia꞉ siliki na꞉labiki, Fa꞉lisi kalu elelo꞉ wida꞉sen nolba꞉yo꞉, enedo꞉ tiliwida꞉senbo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “E takis molelo꞉ dia꞉sen kalu o꞉lia꞉ mogago꞉lo꞉ dimida꞉sen o꞉lia꞉yo꞉ egelebo꞉ ma꞉no꞉wo꞉ waga naba?” ");
INSERT INTO bco_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","To a꞉no꞉ da꞉da꞉ga꞉, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Mulumulo꞉lo꞉ mean kaluwa꞉yo꞉ kalu do꞉mo꞉wo꞉ nafale sab a꞉no꞉ mo꞉asuwa꞉ta꞉sen. Ko꞉sega walafdo꞉ kaluwo꞉ asuwa꞉ta꞉sen. O꞉leaumbo꞉, ne digalo꞉ kalu sab o꞉lo꞉wa mio꞉ma. Ne mogago꞉lo꞉ dimida꞉lab kalu ko꞉lo꞉ ho꞉lema꞉ni mio꞉.” ");
INSERT INTO bco_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ho꞉len no amio꞉, Yo꞉n elo꞉ tili wida꞉sen kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉yo꞉ ma꞉no꞉ mo꞉nakilo꞉ san man a꞉no꞉ ko꞉lo꞉ kudu ha꞉naki sen. A꞉la꞉dimida꞉labiki, kalu nolba꞉yo꞉ ya꞉sa꞉ga꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Fa꞉lisi tili wida꞉sen kalu o꞉lia꞉ Yo꞉n elo꞉ tili wida꞉sen kalu o꞉lia꞉ma꞉yo꞉ ma꞉no꞉ mo꞉nan man a꞉no꞉ ko꞉lo꞉ kudu ha꞉na꞉liki sab. Ko꞉sega gilo꞉ tili wida꞉sen kalu wema꞉yo꞉ waingo꞉ ko꞉lo꞉ mo꞉dimidaba?” ");
INSERT INTO bco_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ya꞉su eyo꞉ a꞉ma꞉la꞉ bale sa꞉laki a꞉la꞉sio꞉, “Giliyo꞉ kaluwa꞉lo꞉ galo꞉ diab a꞉namilo꞉ ma꞉no꞉ dowo꞉tab a꞉no꞉ kalu kegeo꞉ a꞉ma꞉yo꞉ na꞉so꞉boka꞉ a꞉la꞉bo꞉ mo꞉sa꞉lan. O꞉leaundo꞉ mo꞉sa꞉lan ko꞉lo꞉, kalu galo꞉ diab a꞉no꞉ i o꞉lia꞉ dofo꞉liki, kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ ma꞉no꞉wo꞉ tambowo꞉ a꞉na nalega, o꞉li doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko꞉sega tif amio꞉ galo꞉ diab kalu e, iasi kalu o꞉lia꞉lo꞉ mo꞉dowab ho꞉len a꞉namio꞉, iliyo꞉ ma꞉n ma꞉no꞉wo꞉ a꞉namio꞉ o꞉li ka꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ to nowo꞉ a꞉bale sa꞉lakiyo꞉, “Kalu noma꞉yo꞉ so꞉g gedeo꞉ ho꞉gi a꞉no꞉ dia꞉sa꞉ga꞉yo꞉, helebeso꞉g mo꞉luwo꞉ wa꞉l amio꞉ mo꞉dubinima꞉ib. Kaluwa꞉yo꞉ a꞉la꞉bo꞉ dubialega, helebeso꞉g ho꞉gi dubio꞉ a꞉no꞉ halaliki gendelalikiyo꞉, so꞉g mo꞉luwo꞉ a꞉no꞉ alan a꞉bidia꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","A꞉la꞉ta꞉ga꞉ kalu noma꞉yo꞉ wain ho꞉n ho꞉gi a꞉no꞉ no꞉ do꞉go꞉f dubio꞉ mo꞉luwo꞉ us a꞉namio꞉ mo꞉guma꞉ib. A꞉namio꞉ gulalega, wain ho꞉gi a꞉ma꞉ ho ha꞉na꞉no꞉wo꞉ halaido꞉ ko꞉lo꞉ ko꞉ndo꞉feakiyo꞉, no꞉ do꞉go꞉f mo꞉luwo꞉ a꞉no꞉ bidi ha꞉nalikiyo꞉, no꞉ do꞉go꞉f o꞉lia꞉ wain ho꞉n o꞉lia꞉ a꞉no꞉ wala꞉ma꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ wain ho꞉n ho꞉gi a꞉no꞉ no꞉ do꞉go꞉f ho꞉gi halaido꞉ a꞉na gulan.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ha꞉fo꞉lo꞉ Dowan ho꞉len no amio꞉, Ya꞉suwo꞉ da꞉si egelo꞉ usa ha꞉nakiyo꞉, enedo꞉ tili wida꞉sen kaluwa꞉yo꞉ da꞉si fo nolo꞉ ili ma꞉no꞉ a꞉la꞉ta꞉ga꞉ tudu sa꞉la꞉la꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ko꞉sega Fa꞉lisi kalu nolba꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Iliyo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len wenamilo꞉ ma꞉no꞉ tulab a꞉ma꞉yo꞉ ele saefa꞉ a꞉no꞉ o꞉go꞉sab ko꞉lo꞉, iliyo꞉ waga dimidaba?” ");
INSERT INTO bco_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Iliyo꞉ a꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Da꞉ibido꞉ a꞉la꞉ta꞉ga꞉ e o꞉lia꞉lo꞉ sia꞉lowan kalu iyo꞉ maiyabikilo꞉ dimido꞉ sa꞉sa꞉lo꞉wo꞉, giliyo꞉ mo꞉agelo꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiata e Godemo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu elen ho꞉len a꞉namio꞉, Da꞉ibid e maiyabiki, Godeya꞉ aya ha꞉na꞉sa꞉ga꞉, ma꞉no꞉ Godeya꞉ siwa꞉l amilo꞉ dia꞉ta꞉sen a꞉no꞉ e dia꞉sa꞉ga꞉ mo꞉no꞉. A꞉la꞉ta꞉ga꞉ ma꞉no꞉ heb a꞉no꞉ egeledo꞉ sia꞉lowan kalumo꞉ maiya꞉ki dimi. Ele a꞉ma꞉ sa꞉lakiyo꞉, ma꞉n a꞉no꞉ Godemo꞉ bobalo꞉ so꞉mea꞉sen kalu ilika ma꞉ib, a꞉la꞉saefa꞉.” ");
INSERT INTO bco_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ to nolo꞉ a꞉la꞉sio꞉, “Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉no꞉ Gode eyo꞉ dimido꞉ ko꞉lo꞉, kaluka꞉isaleyo꞉ asuwa꞉foma꞉ki dimido꞉. Ko꞉sega Godeya꞉lo꞉ kaluka꞉isale dimido꞉ we, ele a꞉no꞉ ko꞉lo꞉ asuwa꞉foma꞉ki dimido꞉ma. ");
INSERT INTO bco_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","A꞉la꞉fo꞉ko꞉lo꞉ Kalule Dowo꞉ ne, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉ma꞉ biso꞉wo꞉ ne ko꞉lo꞉, no꞉no꞉n bo꞉fo꞉lo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ho꞉len no amio꞉ Ya꞉suwo꞉ tolo꞉ wida꞉sen aya ha꞉na꞉sa꞉ga꞉, dagiyo꞉ ga꞉ga꞉nuli kalu nowo꞉ a꞉na sena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Kalu nolba꞉yo꞉ Ya꞉su e hala dimidab a꞉la꞉likilo꞉ mo꞉walilima꞉no꞉ togo꞉ kedo꞉ ko꞉lo꞉, iliyo꞉ Ya꞉su eyo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namio꞉ dagiyo꞉ ga꞉ga꞉nuli kalu a꞉no꞉ falele alitaba꞉le a꞉la꞉liki bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","A꞉la꞉gabiki Ya꞉su eyo꞉ dagiyo꞉ ga꞉ga꞉nuli kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ge dasilia꞉ga꞉, kalu kegeo꞉ siwa꞉l wena kagama꞉ni mena.” ");
INSERT INTO bco_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kalu a꞉no꞉ dasilia꞉ga꞉ kagatabiki, Ya꞉suwa꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ele saetakiyo꞉, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namio꞉ o꞉b ko꞉lo꞉ dimidama꞉no꞉ saefa꞉yo꞉? Man nafaleyo꞉ o꞉li dimidama꞉no꞉wa꞉le? Mo꞉ man mogago꞉wo꞉ o꞉li dimidama꞉no꞉wa꞉le? Sana soma꞉no꞉wa꞉le? Mo꞉ mela꞉no꞉wo꞉ a꞉ma꞉la꞉ gasiliakilo꞉ asuwa꞉fa꞉no꞉wa꞉le? Ele saefa꞉ a꞉no꞉ ho꞉bo꞉ko꞉mo꞉lo꞉bo꞉?” A꞉la꞉dabu ba꞉ba꞉ ko꞉sega iliyo꞉ a꞉ma꞉la꞉yo꞉ mo꞉sa꞉laki heela꞉li. ");
INSERT INTO bco_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iyo꞉ asulo꞉wo꞉ halaido꞉ ko꞉lo꞉, Ya꞉suwa꞉yo꞉ iyo꞉ sigili ba꞉da꞉sa꞉ga꞉ imo꞉wo꞉ gadiaki, dagiyo꞉ ga꞉ga꞉nuli kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ge dagiyo꞉ talagalema.” A꞉la꞉sa꞉labiki kalu a꞉ma꞉yo꞉ a꞉la꞉dimidaki, dagi a꞉no꞉ e elen o꞉ngo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fa꞉lisi kalu iliyo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, ha꞉la꞉ya ha꞉nakiyo꞉, i o꞉lia꞉ Ha꞉lodo꞉ kudu sian kalu o꞉lia꞉ma꞉yo꞉ Ya꞉su sa꞉ma꞉no꞉ towo꞉ o꞉g a꞉na mo꞉mo꞉da nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ Ga꞉lili ho꞉n golo꞉ seya ha꞉nabiki, kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ e kudu ane. Kaluka꞉isale i a꞉no꞉ Ga꞉lili kaluka꞉isaleyo꞉lo꞉, Yudiayo꞉lo꞉, Ya꞉lusalemo꞉lo꞉, Idomeayo꞉lo꞉, Yodano꞉ nodo amilo꞉ sano꞉lo꞉, Tayayo꞉lo꞉ ami Saido꞉n kaluka꞉isale iyo꞉ Ya꞉suwa꞉lo꞉ dimidab a꞉no꞉ da꞉da꞉sa꞉ga꞉, tambo Ya꞉sulo꞉wa ya꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Eyo꞉ kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ falele alifelabiki, walafdo꞉ dosdo꞉ nolo꞉ ya꞉siakiyo꞉, e goma꞉no꞉ a꞉la꞉ta꞉ga꞉ ani tandeo꞉. Kaluka꞉isaleyo꞉ Ya꞉sulo꞉ amio꞉ modo꞉ kegeakiyo꞉, e mo꞉ani tandema꞉ki a꞉la꞉ta꞉ga꞉ Ya꞉suwa꞉yo꞉ enedo꞉ tili wida꞉senbo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ ho꞉n ko꞉su nowo꞉ bo꞉bo꞉li alifa꞉ni hamana.” ");
INSERT INTO bco_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mama mogago꞉ a꞉ma꞉yo꞉ e ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉sulo꞉ a꞉lab a꞉na gumisi fufuda꞉sa꞉ga꞉ a꞉na ho꞉le sa꞉laki, “Ge mada Godeya꞉ ene So꞉wa” a꞉la꞉sa꞉la꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko꞉sega e kalu o꞉mka꞉ a꞉la꞉bo꞉ mo꞉fanda sama꞉kiyo꞉, mama mogago꞉mo꞉wo꞉ towo꞉ halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ya꞉suwo꞉ hen misio꞉ doba꞉da꞉ halona ha꞉na꞉no꞉ ha꞉nakiyo꞉, kalu enedo꞉ da꞉fema꞉no꞉ asulo꞉le a꞉no꞉ko꞉ ho꞉leliabiki, iyo꞉ Ya꞉sulo꞉wa ane. ");
INSERT INTO bco_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A꞉la꞉ta꞉ga꞉ Ya꞉suwa꞉yo꞉ enen o꞉lia꞉ sia꞉mela꞉no꞉ a꞉la꞉ta꞉ga꞉ mando꞉ walama꞉kilo꞉ iliga꞉felema꞉no꞉, kalu kugula꞉fo꞉ a꞉no꞉ko꞉ da꞉feyo꞉. A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉suwa꞉yo꞉ i a꞉no꞉ iliga꞉felo꞉ kalu wikilo꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","A꞉la꞉gabiki iliyo꞉ mano꞉ widalikiyo꞉, mama mogago꞉wo꞉ i a꞉ma꞉yo꞉ o꞉luga꞉felema꞉ki, halaido꞉wo꞉ imo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Elo꞉ kalu kugula꞉fo꞉ da꞉feyo꞉wo꞉ we. Nowo꞉ Saimon, Saimon e Ya꞉suwa꞉lo꞉ wi ho꞉gi wikilo꞉wo꞉ Bida. ");
INSERT INTO bco_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Nowo꞉ Ya꞉ma꞉s, Sa꞉ba꞉diya꞉ inso꞉, ene ao nowo꞉ Yo꞉n. Ao a꞉la꞉ a꞉no꞉ Ya꞉suwa꞉lo꞉ wi ho꞉gi wikilo꞉wo꞉ Boana꞉ga꞉s. Boana꞉ga꞉s a꞉la꞉do꞉ sa꞉lab a꞉ma꞉ ha꞉go꞉ we, guna꞉ so꞉wa. ");
INSERT INTO bco_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Nowo꞉ Andulu, nowo꞉ Filib, nowo꞉ Batolomiyu, nowo꞉ Madiyu, nowo꞉ Tomas, nowo꞉ Ya꞉ma꞉s, Aofiusa꞉ inso꞉, nowo꞉ Tadius, nowo꞉ Saimon, gamani ho꞉giyo꞉ e dimo꞉losa꞉ a꞉lakilo꞉ asula꞉seno꞉ e ko꞉lo꞉, Sa꞉la꞉t kalu a꞉la꞉sa꞉lan, ");
INSERT INTO bco_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Nowo꞉ Yudas Iskaliot, Ya꞉sulo꞉ teledowo꞉wo꞉ e. ");
INSERT INTO bco_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ya꞉suwa꞉yo꞉ kalu kugula꞉fo꞉ a꞉no꞉ da꞉fea꞉sa꞉ga꞉yo꞉, e a꞉ma꞉la꞉ aya ane. Iyo꞉ aya ha꞉na꞉sa꞉ga꞉ sen amio꞉, kaluka꞉isaleyo꞉ modo꞉ wa꞉ka kegeabiki, ma꞉no꞉ ma꞉no꞉wo꞉ fogo꞉ mo꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Elo꞉ dimida꞉len a꞉no꞉ e so꞉lo꞉wa꞉ da꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ e no꞉nolo꞉ dowab a꞉la꞉asula꞉sa꞉ga꞉, e bo꞉fo꞉melea꞉ki mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ya꞉lusalem a꞉la꞉ta꞉ga꞉lo꞉ elelo꞉ wida꞉sen kalu i mio꞉ a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Bia꞉sabul, mama mogago꞉lo꞉ bo꞉fo꞉lowan a꞉no꞉ eya dowa꞉sen ko꞉lo꞉, ene halaido꞉ a꞉na ilikiyo꞉ mama mogago꞉ nolo꞉ eyo꞉ o꞉luga꞉fela꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ya꞉su eyo꞉ kalu i a꞉no꞉ ho꞉le kegea꞉sa꞉ga꞉, towo꞉ a꞉na bale sio꞉, “Sa꞉da꞉na꞉ eyo꞉, Sa꞉da꞉na꞉ eneno꞉ waga o꞉luga꞉felano꞉? ");
INSERT INTO bco_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Amisa꞉n imilig no amio꞉ ko꞉lo꞉ aloba꞉da꞉sa꞉ga꞉ bubalega, amisa꞉n a꞉no꞉ mo꞉dinafa halale mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","A꞉la꞉ta꞉ga꞉yo꞉ so꞉lo꞉ imilig nowo꞉ egele aloba꞉da꞉sa꞉ga꞉ gis dialega, so꞉lo꞉ a꞉no꞉ mo꞉dinafa mesa꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","O꞉leaumbo꞉, Sa꞉da꞉na꞉ eyo꞉ enena꞉ma꞉la꞉yo꞉ aloba꞉da꞉sa꞉ga꞉ bubalega, e halaido꞉wo꞉ mo꞉dowaliki, e kelegema꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","A꞉la꞉ta꞉ga꞉ Ya꞉su e halaido꞉ kaluka꞉ a꞉lakiyo꞉, eyo꞉ bale sio꞉ to nowo꞉ a꞉la꞉sio꞉. “Afalo꞉ dian kalu noma꞉yo꞉ halaido꞉ kalu a꞉ma꞉ aya tina꞉sa꞉ga꞉ kelego꞉wo꞉ afale dia꞉no꞉ asulakiyo꞉, eyo꞉ waga dimidama꞉iba? Eyo꞉ halaido꞉ kalu a꞉no꞉ ko꞉le melea꞉takiyo꞉, kelego꞉wo꞉ a꞉namio꞉ o꞉li dia꞉ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Niyo꞉ gemo꞉wo꞉ hendele so꞉lo꞉l. Mogago꞉lo꞉ dimida꞉sen o꞉lia꞉ Godemo꞉lo꞉ dio꞉ge sio꞉wo꞉lo꞉, Gode eyo꞉ o꞉li ga꞉lila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko꞉sega kalu abeyo꞉ Mama Malilo꞉mo꞉wo꞉ dio꞉ge sa꞉lalega, mogago꞉ elo꞉ sa꞉lab a꞉no꞉ mada mo꞉ga꞉lila꞉ma꞉ib. Enedo꞉ hala dimido꞉ a꞉no꞉ mela꞉no꞉ mela꞉no꞉ mela꞉ib,” Ya꞉suwa꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ya꞉suwa꞉lo꞉ to sio꞉ a꞉no꞉ mo꞉wo꞉ we. Ili sa꞉lakiyo꞉, “Ya꞉su e amio꞉ mama mogago꞉wo꞉ dofo꞉lab,” a꞉la꞉sio꞉ ko꞉lo꞉ eyo꞉ to a꞉no꞉ imo꞉wo꞉ a꞉na sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ya꞉suwa꞉ ano o꞉lia꞉ ao o꞉lia꞉yo꞉ a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉yo꞉, ha꞉la꞉ya kagafo꞉liki, kalu nowo꞉ Ya꞉suwo꞉ a usa ba꞉ba꞉ni ha꞉na꞉sa꞉ga꞉, ilo꞉wa mena꞉ki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","A꞉la꞉ta꞉ga꞉ kalu modo꞉wo꞉ Ya꞉su e o꞉lia꞉ silikiyo꞉, iliyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉ o꞉lia꞉ gao o꞉lia꞉ma꞉yo꞉ ge keda꞉liki, ha꞉la꞉ya a꞉lab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Ni no꞉wo꞉, ni naowo꞉ o꞉ba꞉le?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kaluka꞉isale ko꞉lo꞉ e anib amilo꞉ kandayo꞉ a꞉no꞉ eyo꞉ sigiliga꞉takiyo꞉ a꞉la꞉sio꞉, “A us amilo꞉ sab we ni no꞉leyo꞉ a꞉la꞉ta꞉ga꞉ ni naoleyo꞉ i o꞉m. ");
INSERT INTO bco_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kaluka꞉isale abeyo꞉ Godeya꞉ mando꞉ tilida꞉da꞉sa꞉ga꞉lo꞉ kudu ha꞉na꞉lab a꞉no꞉, naoleyo꞉ nadoleyo꞉ no꞉leyo꞉ i o꞉m,” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ya꞉suwo꞉ ho꞉n golo꞉ aniba silikiyo꞉, mano꞉ wa꞉ka mo꞉mo꞉da widabiki, kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ elo꞉wa kegeo꞉. Kegeo꞉wo꞉ alan dowabiki, e ho꞉n ko꞉su usa tina꞉sa꞉ga꞉, ho꞉n us honona asitabiki, kaluka꞉isaleyo꞉ ho꞉n sa꞉ aniba ho꞉ndo꞉ ya꞉sa꞉ga꞉lo꞉ edo꞉wa siliki da꞉da꞉len. ");
INSERT INTO bco_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Eyo꞉ towo꞉ bale sa꞉la꞉likiyo꞉, man ko꞉li ko꞉lilo꞉ a꞉no꞉ imo꞉wo꞉ a꞉na walasio꞉. Bale sio꞉ nowo꞉ Ya꞉su eyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Gio꞉ dabuma! Elo꞉ gelan kalu nowo꞉ ha꞉nakiyo꞉, da꞉si fowo꞉ egelo꞉wa fifa꞉li ane. ");
INSERT INTO bco_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E da꞉si fowo꞉ egelo꞉wa fifa꞉li ha꞉nab amio꞉, fo nolo꞉ tog wa꞉la꞉la꞉sena ti ali ko꞉lo꞉, o꞉ba꞉yo꞉ ya꞉sia꞉sa꞉ga꞉, da꞉si fo a꞉no꞉ mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Fo nolo꞉ ulo꞉ elena ti ali. Hen a꞉no꞉ abeyo꞉ ko꞉lo꞉ musug a꞉no꞉ bo꞉bo꞉ge fa꞉la꞉ne ko꞉sega, musug a꞉ma꞉ tef tina꞉no꞉wo꞉ uwa midiyo꞉ ko꞉lo꞉, ofo꞉ ta꞉ndabikiyo꞉, da꞉si musug a꞉no꞉ onaliaki sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Fo nolo꞉ do꞉molo꞉ a꞉laba ti ali. Da꞉si musug a꞉no꞉ fa꞉la꞉ne ko꞉sega, do꞉mo a꞉no꞉ bo꞉bo꞉ge fa꞉la꞉ndaki, da꞉si musug a꞉no꞉ mele fafululi ko꞉lo꞉, fo nafayo꞉ mo꞉hedo꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Da꞉si fo nolo꞉ hen nafa solo꞉wa ti ali ko꞉lo꞉, musugo꞉ nafa fa꞉la꞉nda꞉sa꞉ga꞉, fowo꞉ nafale mada hedo꞉. Hen nafale amilo꞉ fa꞉la꞉ne a꞉ma꞉yo꞉, fo hedakiyo꞉ nolo꞉ fudo꞉ otalen hedo꞉, nolo꞉ fudo꞉ a꞉la꞉ hedo꞉, nolo꞉ fudo꞉ imilig hedo꞉.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Bale sio꞉ we sa꞉la꞉sa꞉ga꞉, Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale ka꞉la꞉ndo꞉ a꞉lab gio꞉, to we dinafa da꞉da꞉sa꞉ga꞉ fanda asula꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kaluka꞉isale nolo꞉ ha꞉na꞉ga꞉ a꞉labikiyo꞉, enedo꞉ tili wida꞉sen kalu kugula꞉fo꞉ a꞉no꞉lia꞉ kalu nol a꞉namilo꞉ o꞉sen i a꞉ma꞉yo꞉, elo꞉ bale sio꞉ a꞉ma꞉ ha꞉go꞉ fanda sama꞉ki emo꞉wo꞉ dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Dabu ba꞉dabiki, Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ to wo꞉no꞉lelo꞉ delen a꞉no꞉ o꞉go꞉ gio꞉ o꞉li asuluma꞉ki fogo꞉ dimi ko꞉lo꞉lab. Ko꞉sega Godeya꞉lo꞉ dinali sio꞉ to sa꞉sa꞉lo꞉ a꞉no꞉ kalaba fa꞉la꞉doma꞉kiyo꞉, niyo꞉ ha꞉la꞉ kalumo꞉wo꞉ mobale sio꞉. Godeya꞉ to a꞉no꞉ a꞉la꞉sa꞉sa꞉lo꞉, ");
INSERT INTO bco_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","“‘Iliyo꞉ ba꞉ba꞉ib ko꞉sega, hendeyo꞉ mo꞉ba꞉ba꞉ib. Iliyo꞉ to sio꞉wo꞉ da꞉ba꞉ib ko꞉sega, ha꞉go꞉ mo꞉fanda asuluma꞉ib. Iliyo꞉ dinafayo꞉ asulo꞉ kibo꞉bowo꞉, iyo꞉ asugo꞉ nodola꞉sa꞉ga꞉ dowaliki, Gode eyo꞉ ililo꞉ mogago꞉ dimido꞉ a꞉no꞉ ga꞉lila꞉mabe.’” ");
INSERT INTO bco_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ imo꞉ a꞉la꞉sio꞉, “Gio꞉ bale sio꞉ we ha꞉go꞉ mo꞉dinafa asulaya? Bale sio꞉ we ha꞉go꞉ gio꞉ mo꞉asulait ko꞉lo꞉, bale sio꞉ nolo꞉ giliyo꞉ waga asuluma꞉no꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Elo꞉ gelan kalu a꞉ma꞉lo꞉ da꞉si fo fifo꞉ o꞉leaumbo꞉, Godeya꞉ towo꞉ walasa꞉la꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kaluka꞉isale nolo꞉ da꞉si fo ko꞉lo꞉ tog wa꞉la꞉la꞉sen amilo꞉ ti ali o꞉leo꞉ngo꞉ dowab. Godeya꞉ to nafa wida꞉lab amio꞉, kalu i a꞉ma꞉yo꞉ dabu ko꞉sega, Sa꞉da꞉na꞉yo꞉ ya꞉sa꞉ga꞉ to nafa widab a꞉no꞉ e dila꞉sa꞉ga꞉ ha꞉na꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Kaluka꞉isale nolo꞉ fo ulo꞉ elen wa꞉l amilo꞉ ti ali o꞉leo꞉ngo꞉ dowab. Iliyo꞉ Godeya꞉ to nafa a꞉no꞉ iligi da꞉da꞉sa꞉ga꞉, sagala꞉li diab. ");
INSERT INTO bco_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Kalu i a꞉no꞉ tilidabu ko꞉sega, ili asulo꞉ us amio꞉ towo꞉ mo꞉tefele ane ko꞉lo꞉, ili tilidabuwo꞉ ho꞉len abolda꞉su dowab. Hida꞉yo꞉ ko꞉li ko꞉lilo꞉ fa꞉la꞉dowab amio꞉, iyo꞉ bo꞉e sulufo꞉ tina꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Kaluka꞉isale nolo꞉ da꞉si fo kisdo꞉ a꞉lab a꞉namilo꞉ fifa꞉li ane o꞉leo꞉ngo꞉ dowab. Kaluka꞉isale a꞉no꞉ Godeya꞉ towo꞉ dabu ko꞉sega, henfelo꞉ wilo꞉ dimidama꞉no꞉ kele asulo꞉ o꞉lia꞉, mole alan dia꞉no꞉ asulo꞉ kelego꞉ ko꞉li ko꞉lilo꞉ meselo꞉ alan fa꞉la꞉dowab a꞉ma꞉yo꞉ tilidabu kalu a꞉ma꞉lo꞉wo꞉ go꞉lulaliki, nafalelo꞉ mo꞉dowaki, fowo꞉ mo꞉helema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Kalu nolo꞉ hen solo꞉ nafa amilo꞉ ti ali o꞉leo꞉ngo꞉ dowab. Iliyo꞉ to man a꞉no꞉ da꞉da꞉sa꞉ga꞉ tilidabu ko꞉lo꞉, fowo꞉ nafale hedakiyo꞉, nolo꞉ fowo꞉ fudo꞉, nolo꞉ fowo꞉ fudo꞉ a꞉la꞉, nolo꞉ fudo꞉ otalen o꞉leo꞉ngo꞉ hedo꞉.” Ya꞉suwa꞉yo꞉ imo꞉wo꞉ a꞉la꞉walasio꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ya꞉su eyo꞉ towo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ nafayo꞉ do꞉lia꞉ga꞉yo꞉, fafo ha꞉g amio꞉ go꞉lu alitano꞉? O꞉ wo꞉no꞉le kugun amio꞉ dia꞉tano꞉? A꞉la꞉bo꞉ mo꞉gan ko꞉lo꞉ giliyo꞉ nafayo꞉ do꞉lia꞉ga꞉yo꞉, kalaba iwalu dialita꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","A꞉la꞉do꞉ gan aumbo꞉, wo꞉no꞉lelo꞉ delen a꞉no꞉, tif amio꞉ tambo kalaba fa꞉la꞉doma꞉ib. A꞉la꞉ta꞉ga꞉ wo꞉no꞉lelo꞉ delen a꞉no꞉ tambo kalaba fa꞉la꞉dowalikiyo꞉, kaluka꞉isaleyo꞉ tambo fanda asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kaluka꞉isale abeyo꞉ ge ka꞉la꞉no꞉ a꞉labo꞉lalega, giyo꞉ to we dinafa da꞉da꞉sa꞉ga꞉ tili asula꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ya꞉su eyo꞉ towo꞉ a꞉kudu sa꞉laki, “To gilo꞉ da꞉dab ko dinafa asula꞉bi. Gilo꞉ nolbo꞉lo꞉ ege meab aumbo꞉, gemo꞉wo꞉ wa꞉lo꞉ o꞉leo꞉ngo꞉ ka dimia꞉ib a꞉la꞉ta꞉ga꞉ heb nolo꞉lo꞉ wa꞉ka ba꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kalu abeyo꞉ asulo꞉wo꞉ hebo꞉ dowalega, Gode eyo꞉ emo꞉wo꞉ asulo꞉ nolo꞉ a꞉dimia꞉ib. Ko꞉sega kalu abeyo꞉ asugdo꞉ma dowab a꞉no꞉, asulo꞉ ha꞉lu e amilo꞉ delen a꞉no꞉, tambo a꞉ma꞉la꞉ dila꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ a꞉no꞉ kaluwa꞉ halaido꞉wa꞉yo꞉ mo꞉fa꞉la꞉do alifa꞉ib a꞉la꞉liki, Ya꞉su eyo꞉ bale sio꞉. “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉no꞉ wengaliki fa꞉la꞉doma꞉ib. Kaluwa꞉yo꞉ egelo꞉ amio꞉ fowo꞉ fifa꞉sa꞉ga꞉ ta꞉fo꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Kalu a꞉no꞉ nuluwo꞉ alila꞉liki, a꞉la꞉ta꞉ga꞉ kea꞉fowo꞉ dasila꞉liki, a꞉la꞉ga꞉likiyo꞉ ho꞉len nolo꞉ ane ko꞉lo꞉, fo fifo꞉ a꞉no꞉ musugo꞉ po a꞉la꞉ta fa꞉la꞉ne. A꞉la꞉ta꞉ga꞉ kalu a꞉ma꞉yo꞉ fo a꞉no꞉ waga fa꞉la꞉neya꞉le, a꞉la꞉bo꞉ e mo꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Mo꞉wo꞉ henfelo꞉ wema꞉ ene halaido꞉wa꞉yo꞉ fo a꞉no꞉ a꞉na fa꞉la꞉do alitan. Tamina musug ko꞉le fa꞉la꞉dowan. A꞉ma꞉ fa꞉s amio꞉ fo꞉s fa꞉la꞉dowan. A꞉la꞉ta꞉ga꞉yo꞉ fowo꞉ a꞉na hedan. ");
INSERT INTO bco_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Fowo꞉ heda꞉sa꞉ga꞉ nafaliab amio꞉ kalu a꞉ma꞉yo꞉ o꞉g a꞉na bo꞉bo꞉ge tulan. Mo꞉wo꞉ ma꞉no꞉lo꞉ kegenema꞉no꞉ ho꞉leno꞉ a꞉na fa꞉la꞉dowaliki auma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ a꞉widakiyo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ o꞉bo꞉ngo꞉ ko꞉lo꞉ da꞉laba? Gio꞉ asuluma꞉ki bale sa꞉laki maloloma꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ a꞉no꞉ mased fo fifo꞉ amilo꞉ fa꞉la꞉ndab o꞉ngo꞉ dowab. Fo a꞉no꞉ hena fifalikiyo꞉, e mada ha꞉lula꞉su ti alilan. ");
INSERT INTO bco_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ko꞉sega fo a꞉no꞉ alan fa꞉la꞉ndakiyo꞉, eleyo꞉ tagalalikiyo꞉, o꞉ba꞉ iliyo꞉ ayo꞉ ha꞉la꞉s a꞉na dia꞉sen.” Ya꞉suwa꞉yo꞉ a꞉la꞉ bale sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ya꞉su eyo꞉ kaluka꞉isalemo꞉wo꞉ bale sa꞉lakiyo꞉, mano꞉ o꞉leo꞉ngo꞉ ko꞉lo꞉ wido꞉. Heb ililo꞉ o꞉li asuluma꞉no꞉ a꞉no꞉, Ya꞉su eyo꞉ a꞉na wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Eyo꞉ imo꞉wo꞉ mo꞉tigini widaki, mobale sio꞉. Ko꞉sega enedo꞉ tiliwida꞉sen kalu o꞉lia꞉ egelese dotakiyo꞉, to ha꞉g hendeleyo꞉ imo꞉wo꞉ a꞉na fanda wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ga꞉lo a꞉namio꞉, Ya꞉su eyo꞉ enedo꞉ tili wida꞉senbo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ ho꞉n golo꞉ we nodo honona ha꞉na꞉n.” ");
INSERT INTO bco_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","A꞉la꞉sa꞉labiki, kalu kegeo꞉ a꞉no꞉ kata꞉ta꞉ga꞉, enedo꞉ tili wida꞉sen kalu iyo꞉, ho꞉n ko꞉su Ya꞉sulo꞉ elen us a꞉na disa꞉la꞉sa꞉ga꞉ ane. A꞉la꞉ta꞉ga꞉ ho꞉n ko꞉su nolo꞉lo꞉ ilo꞉ ha꞉naba kudu mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ha꞉na꞉len amio꞉, fufayo꞉ halaido꞉ yakiyo꞉, ho꞉n golo꞉ a꞉no꞉ ma꞉feaki, ho꞉no꞉ do꞉lilia꞉ga꞉, ho꞉n ko꞉su usa tinaki wa꞉ido꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Fufa alando꞉ ya꞉lab a꞉namio꞉, Ya꞉suwo꞉ ho꞉n ko꞉su seba, imisaseyo꞉ dia꞉taki, a꞉na alifo꞉len. A꞉la꞉ta꞉ga꞉ iliyo꞉ Ya꞉suwo꞉ digida꞉yakiyo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu, giyo꞉ nio꞉ kanda soma꞉ki asulaya?” ");
INSERT INTO bco_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Iliyo꞉ a꞉la꞉sa꞉la꞉liki digida꞉yabiki, Ya꞉suwo꞉ dasila꞉sa꞉ga꞉, fufa ya꞉len o꞉mo꞉ towo꞉ halaido꞉ sa꞉lakiyo꞉, “Ge buluta꞉sa꞉ga꞉, ga꞉li doma!” A꞉la꞉sa꞉labiki, fufa ya꞉len a꞉no꞉ a꞉naka bulutakiyo꞉, ho꞉n ma꞉feya꞉len a꞉no꞉lo꞉ ka bulufo꞉. ");
INSERT INTO bco_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Bulutabiyo꞉ Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ tagio꞉ alano꞉ waga dowaya? Gi amio꞉ tilidabuwo꞉ aundo꞉malo꞉?” ");
INSERT INTO bco_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Iyo꞉ Ya꞉suwa꞉lo꞉ dimidab a꞉no꞉ molo ba꞉da꞉sa꞉ga꞉ tagilakiyo꞉, egelebo꞉ nenelaki a꞉la꞉sio꞉, “Fufa o꞉lia꞉ ho꞉n ma꞉feya꞉len o꞉lia꞉ we elo꞉ sio꞉leko꞉ kudu ha꞉na꞉sa꞉ga꞉ bulutab ko꞉lo꞉, kalu we o꞉bo꞉ngo꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iyo꞉ ho꞉no꞉ nodowa ha꞉nakiyo꞉, Gelasa kalulo꞉ sa꞉sen doba꞉da꞉ a꞉na ha꞉na꞉sa꞉ga꞉, ho꞉n golo꞉ aniba fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Fa꞉la꞉dowa꞉sa꞉ga꞉yo꞉, Ya꞉suwo꞉ ho꞉n ko꞉suwa a꞉la꞉ta꞉ga꞉ tibo꞉lowakiyo꞉, kalu mama mogago꞉lo꞉ dowo꞉wo꞉ a꞉na galili. ");
INSERT INTO bco_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","4","Kalu we a꞉ido꞉lo꞉wa sia꞉sen ko꞉lo꞉ mio꞉. Tamin amio꞉ sa꞉niya꞉ dagi o꞉lia꞉ gib o꞉lia꞉yo꞉ melea꞉ta꞉sen ko꞉sega, ene halaido꞉wa꞉yo꞉ gegedela꞉sa꞉ga꞉ ha꞉nab amio꞉, kaluwa꞉ ta꞉lia꞉sa꞉ga꞉lo꞉ a꞉melea꞉fa꞉no꞉wo꞉ mo꞉dowa꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ e sa꞉nia꞉yo꞉ wa꞉kabiyo꞉ mo꞉melefa꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","E nuluwo꞉lo꞉ ho꞉lenowo꞉lo꞉ tambo kalu a꞉ido꞉lo꞉wa a꞉la꞉ta꞉ga꞉ hen misio꞉ a꞉nami nai sia꞉liki, enena꞉ma꞉la꞉ ene do꞉mo꞉wo꞉ uwa꞉ yame tandea꞉liki, ya꞉lilia꞉ sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Eyo꞉ Ya꞉su yabo꞉ ko꞉na꞉ka iliki ba꞉da꞉sa꞉ga꞉, nai ya꞉ga꞉, Ya꞉su e ko꞉lo꞉ wabuluma꞉niki, Ya꞉suwa꞉ gido꞉fo꞉lo꞉wa gumisi ali. ");
INSERT INTO bco_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ya꞉su eyo꞉ kalu mogago꞉lo꞉ dowo꞉ o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Mama mogago꞉ ge, ha꞉la꞉ya hamana” a꞉la꞉sio꞉. Kalu a꞉ma꞉yo꞉ a꞉ma꞉la꞉bo꞉ towo꞉ halale sa꞉laki, “Ya꞉su, Gode Alan Iwalulo꞉ a꞉lab a꞉ma꞉ so꞉wa giyo꞉, nemo꞉wo꞉ waga dimidama꞉ni mio꞉wo꞉? Godeya꞉ wiya ilikiyo꞉, ne mogagima꞉no꞉ towo꞉ nemo꞉wo꞉ sa꞉la꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A꞉la꞉gabiki, Ya꞉suwa꞉ sa꞉laki, “Ge wiyo꞉ o꞉ba?” “Ne wiyo꞉ Modo꞉, mo꞉wo꞉ mama mogago꞉ niasiyo꞉ modo꞉ agelema꞉no꞉wo꞉ babalo꞉ ko꞉lo꞉ sab.” ");
INSERT INTO bco_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Kalu a꞉ma꞉yo꞉ Ya꞉sumo꞉ ha꞉nolo sa꞉lakiyo꞉, “Nio꞉ hen no amio꞉ mada iliga꞉ta꞉so꞉bo” a꞉la꞉sa꞉laki susio꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Misio꞉ anib a꞉namio꞉, kabo fofo꞉wo꞉ modo꞉ ko꞉lo꞉ ma꞉no꞉ na꞉liki sen. ");
INSERT INTO bco_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A꞉la꞉ta꞉ga꞉ mama mogago꞉wa꞉yo꞉ Ya꞉sumo꞉wo꞉ susiaki a꞉la꞉sio꞉, “Nio꞉ kabowa doma꞉ hamana꞉ki, giyo꞉ nio꞉ a꞉na iliga꞉foma.” ");
INSERT INTO bco_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉suwa꞉yo꞉ mama mogago꞉mo꞉wo꞉ o꞉lika꞉ a꞉la꞉sa꞉labiki, mama mogago꞉ kalu amilo꞉ sen a꞉no꞉ ha꞉la꞉ya sili alifela꞉sa꞉ga꞉, kabowa tiane. Kabo a꞉no꞉ daosen a꞉la꞉ sen ko꞉lo꞉, iyo꞉ dalalelia꞉ga꞉ do꞉mo꞉wa tina꞉sa꞉ga꞉, ho꞉na tambo ho꞉lufa꞉la꞉sa꞉ga꞉ kanda sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kabolo꞉ bo꞉fo꞉len kalu i a꞉no꞉ nai ha꞉na꞉sa꞉ga꞉, amisa꞉n kaluka꞉isale noldo꞉ sen amio꞉lo꞉, ha꞉la꞉ doba꞉da꞉lo꞉ kandaya꞉i ane i o꞉mo꞉wo꞉lo꞉ dimido꞉ a꞉no꞉ bo꞉bo꞉ge malola꞉i ha꞉nabiki, kaluka꞉isaleyo꞉ dimidab a꞉no꞉ ilo꞉ ba꞉ba꞉ni Ya꞉sulo꞉wa mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Iyo꞉ ya꞉sa꞉ga꞉yo꞉, kalu mama mogago꞉ modo꞉lo꞉ dowo꞉ a꞉no꞉ o꞉li dowo꞉ ko꞉lo꞉, Ya꞉suwa꞉ aniba sena ba꞉ba꞉. Kalu a꞉no꞉ asulo꞉ elo꞉wo꞉ nafale dowabiki, e helebeso꞉g ka꞉la꞉liki elena ba꞉da꞉sa꞉ga꞉, iyo꞉ tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mama mogago꞉lo꞉ dofo꞉len kalu amilo꞉ fa꞉la꞉dowo꞉ a꞉no꞉ kaluka꞉isale iliyo꞉ ba꞉ba꞉ ko꞉lo꞉, nolbo꞉wo꞉ malolo꞉ mea꞉liki ane. A꞉la꞉ta꞉ga꞉ kabo amilo꞉ dimido꞉ a꞉no꞉lo꞉ nolbo꞉wo꞉ malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","A꞉la꞉do꞉ dimidab a꞉no꞉ ba꞉da꞉ga꞉, Ya꞉suwo꞉ ili heno꞉ ta꞉fo꞉ hamana꞉ki, towo꞉ halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ya꞉suwo꞉ ho꞉n ko꞉suwa disa꞉labikiyo꞉, kalu mama mogago꞉lo꞉ dowo꞉ ko꞉lo꞉ o꞉luga꞉felo꞉ a꞉no꞉ Ya꞉su o꞉lia꞉ ha꞉na꞉no꞉ susio꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ya꞉su eyo꞉ e mena a꞉la꞉bo꞉ mo꞉sio꞉ ko꞉sega, eyo꞉ emo꞉ sa꞉lakiyo꞉, “Ge a꞉ma꞉la꞉ go꞉no꞉n so꞉lo꞉lo꞉wa ha꞉na꞉ga꞉, Godeya꞉lo꞉ gemo꞉lo꞉ dimido꞉ a꞉no꞉, imo꞉wo꞉ malolo꞉ mea꞉ni hamana. Gode eyo꞉ ge asulaki nofolo꞉ alifa꞉ ko꞉lo꞉, giyo꞉ a꞉no꞉ malola꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","A꞉la꞉fo꞉ko꞉lo꞉ kalu a꞉ma꞉yo꞉ ha꞉na꞉sa꞉ga꞉, Dekabolis hen us a꞉namilo꞉ sa꞉sen kaluka꞉isalemo꞉wo꞉ Ya꞉suwa꞉lo꞉ e amilo꞉ dimido꞉ a꞉no꞉ kalaba wida꞉len ko꞉lo꞉, tambowo꞉ dabulia꞉sa꞉ga꞉yo꞉, molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ya꞉suwo꞉ a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, ho꞉n golo꞉ a꞉no꞉ nodowa a꞉ta꞉nota꞉ga꞉ elen amio꞉, kaluka꞉isale modo꞉wo꞉ ho꞉n anib a꞉na kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Tolo꞉ wida꞉sen alo꞉ bo꞉fo꞉lowan kalu nowo꞉, Yailes elo꞉ a꞉namio꞉ elen. E Ya꞉suwo꞉ galilia꞉sa꞉ga꞉, Ya꞉suwa꞉ gido꞉fo꞉lo꞉wa gumisi asifo꞉liki, emo꞉wo꞉ a꞉la꞉sio꞉, “Ni ka꞉isale so꞉wayo꞉ soma꞉nigab ko꞉lo꞉, ge ni aya ya꞉ga꞉ gi dagiya꞉ golalikiyo꞉ falelema꞉ib ko꞉lo꞉, ge ni aya mena. Giyo꞉ ko꞉lo꞉ a꞉la꞉dimidalega, e o꞉li doma꞉ib,” a꞉la꞉sa꞉laki susio꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ya꞉suwo꞉ Yailesa꞉ sendelia꞉ga꞉ ha꞉nabiki, kaluka꞉isale modo꞉ kegeo꞉ a꞉no꞉ ko꞉lo꞉ ha꞉na꞉siakiyo꞉, anitandeya꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ga imili nowo꞉ tin hoda꞉likilo꞉ eleno꞉, donayo꞉ kugula꞉fo꞉ ko꞉lo꞉ gulula꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ho꞉leno꞉ tambo ga a꞉no꞉ mulumulo꞉lo꞉ mean kaluwa꞉yo꞉ e ba꞉da꞉sa꞉ga꞉ dinafa ya꞉len ko꞉sega, emo꞉wo꞉ hida꞉yo꞉ dimiaki, e amilo꞉ tin hoda꞉len a꞉no꞉ mo꞉falelaki, mole elo꞉wo꞉ tambo wala꞉len. ");
INSERT INTO bco_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ e dabu ko꞉lo꞉, Ya꞉suwo꞉ kaluka꞉isale kegeo꞉ a꞉lab us a꞉na yabiki, e Ya꞉suwa꞉ fa꞉sa ha꞉na꞉sa꞉ga꞉, ene so꞉g sa꞉ga꞉lo꞉ a꞉na golo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","A꞉la꞉do꞉ go꞉ a꞉no꞉ ga a꞉ma꞉ asulakiyo꞉, “Niyo꞉ ko꞉lo꞉ ene so꞉g sa꞉ga꞉lo꞉ a꞉na golo꞉loga, ne falelema꞉ib” a꞉la꞉asula꞉sa꞉ga꞉, a꞉na golo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Golabiki wigibo a꞉naka, tin hoda꞉len a꞉no꞉ bulutabikiyo꞉, eneno꞉ walaf e amilo꞉ elen a꞉no꞉ tambo falelabo꞉lo꞉b a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ga a꞉ma꞉yo꞉ Ya꞉suwa golab amio꞉, Ya꞉suwa꞉ halaido꞉wo꞉ a꞉ma꞉la꞉ susululia꞉ga꞉ ha꞉nano꞉ a꞉ngabiki, kalu noma꞉yo꞉ e amio꞉ golabo꞉lo꞉b a꞉la꞉asula꞉sa꞉ga꞉, a꞉ma꞉la꞉ bale ba꞉dakiyo꞉ a꞉la꞉sio꞉, “Ni helebeso꞉g amio꞉ abe golo꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","A꞉la꞉dabu ba꞉dabiki, enedo꞉ tili wida꞉sen kaluwa꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Kaluka꞉isaleyo꞉ modo꞉ yab wema꞉ anilaki gab ko꞉lo꞉, giyo꞉ ‘Ne abe golaba?’ a꞉la꞉do꞉ sa꞉lab ko wangabiki sa꞉laya?” ");
INSERT INTO bco_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ko꞉sega Ya꞉su eyo꞉ e amio꞉ abe golo꞉wa꞉le a꞉la꞉liki, sigili keda꞉li ane. ");
INSERT INTO bco_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ya꞉suwa꞉lo꞉ dabu ba꞉dab a꞉no꞉ ga a꞉ma꞉yo꞉ ha꞉go꞉ asula꞉sa꞉ga꞉, e tagilakiyo꞉ bibisoda꞉liki, Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, a꞉na gumisi alifo꞉liki, e amilo꞉ dimido꞉wo꞉ a꞉na fanda sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ya꞉su eyo꞉ ga o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉la꞉, ge go꞉no꞉n tilidabu koma꞉yo꞉, ge falele alifa꞉. Walaf ge amilo꞉ elen ko ga꞉li dowab ko꞉lo꞉, ge ha꞉sa mesa꞉ni ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ya꞉suwo꞉ to a꞉no꞉ ko꞉lo꞉ gamo꞉ sa꞉la꞉lena, kalu nolo꞉ Yailesa꞉ aya a꞉la꞉ta꞉ga꞉ ya꞉ga꞉, Yailes emo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉la꞉yo꞉ sowo꞉ ko꞉m. Gilo꞉ widan kalu we tililia꞉ ha꞉na꞉no꞉wo꞉, mo꞉wo꞉ aundo꞉malo꞉ka꞉.” ");
INSERT INTO bco_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ya꞉su eyo꞉lo꞉ to a꞉no꞉ da꞉dakiyo꞉, Yailesbo꞉wo꞉ a꞉la꞉sio꞉, “Ge iligi da꞉da꞉so꞉bo. Ge neka tilida꞉da꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉su eyo꞉ kaluka꞉isale nolo꞉ a꞉na kagafo꞉melea꞉ki ta꞉takiyo꞉, Bidayo꞉, Ya꞉ma꞉so꞉, Ya꞉ma꞉sa꞉ ao Yo꞉no꞉, i a꞉no꞉leko꞉ tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Iyo꞉ Yailesa꞉ aya fa꞉la꞉dowo꞉ amio꞉, kaluka꞉isaleyo꞉ tambo kegea꞉sa꞉ga꞉ ya꞉fowo꞉ modo꞉ elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ya꞉suwo꞉ a usa tina꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ waga ya꞉fodaya? So꞉wa we sowo꞉lema. E ba mida꞉iyo꞉ alifo꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉ iyo꞉ o꞉gabiki, Ya꞉su eyo꞉ iyo꞉ ha꞉la꞉ya iliga꞉fo꞉. A꞉la꞉go꞉ko꞉lo꞉ so꞉walo꞉ iya o꞉lia꞉, ano o꞉lia꞉yo꞉ a꞉la꞉ta꞉ga꞉ tili wida꞉sen kalu otalen, i a꞉no꞉ko꞉ sowo꞉lo꞉ da꞉lab galala꞉ a꞉na tiane. ");
INSERT INTO bco_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iyo꞉ a꞉na ti ha꞉na꞉sa꞉ga꞉, eyo꞉ gala꞉su a꞉ma꞉ dagiya ta꞉li dotakiyo꞉ a꞉la꞉sio꞉, “Talita kum.” A꞉la꞉do꞉ sa꞉lab a꞉ma꞉ ha꞉go꞉ we, “Ka꞉isale so꞉wa, ge dasima.” ");
INSERT INTO bco_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wigibo a꞉naka ka꞉isale so꞉wa a꞉no꞉ a꞉na dasilia꞉ga꞉ sia꞉len. Ka꞉isale so꞉wa a꞉no꞉ donayo꞉ kugula꞉fo꞉ gulula꞉. Iyo꞉ dimidab a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉ amio꞉ molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ya꞉su eyo꞉ imo꞉wo꞉ halale sa꞉laki, “Dimido꞉ we kalu nolbo꞉wo꞉ kalab amio꞉ malola꞉i ha꞉na꞉so꞉bo!” A꞉la꞉ta꞉ga꞉ ma꞉no꞉wo꞉ ka꞉isale so꞉wa o꞉mo꞉wo꞉ maiya꞉ki dimina Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ya꞉su e hen a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, enedo꞉ tili wida꞉sen kalu o꞉lia꞉ ene amisa꞉n amio꞉ egele ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ha꞉fo꞉lo꞉ Dowan ho꞉leno꞉ fa꞉la꞉dowabikiyo꞉, eyo꞉ tolo꞉ wida꞉sen ayamio꞉ mano꞉ mo꞉mo꞉da widabiki, to elo꞉ walasa꞉la꞉lab a꞉no꞉ kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ iligi da꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Asulo꞉ nafa elo꞉ we, o꞉ba a꞉la꞉ta꞉ga꞉ dia꞉le? Ene halaido꞉ molo ha꞉na꞉no꞉ dimida꞉li a꞉lab we, abe dimi ko꞉lo꞉ gaba꞉le? ");
INSERT INTO bco_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kalu we Maliaya꞉ so꞉wa ko꞉lo꞉, ene aowo꞉ Ya꞉ma꞉so꞉, Yosa꞉bo꞉, Yudaso꞉, Saimono꞉ a꞉la꞉ta꞉ga꞉ ene ado iyo꞉ negele wena so꞉l ko꞉sega, kalu we o꞉bo꞉ngo꞉ ko꞉lo꞉ iligaba? E ba alo꞉ dia꞉seno꞉, e malo꞉.” A꞉la꞉sa꞉lakiyo꞉ Ya꞉suwo꞉ iliyo꞉ a꞉na gola ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","A꞉la꞉sa꞉la꞉labiki Ya꞉su eyo꞉ towo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Dinali sa꞉lan kalu a꞉ma꞉yo꞉ hen nowa ha꞉na꞉sa꞉ga꞉ widab a꞉namio꞉ kaluka꞉isaleya꞉yo꞉ wabuluma꞉ib, ko꞉sega ene amisa꞉n kalulo꞉ sab us a꞉namio꞉lo꞉, ene so꞉lo꞉ sab a꞉namio꞉lo꞉, elo꞉ to dinali sa꞉la꞉lab a꞉no꞉ mo꞉tilida꞉da꞉sen,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","A꞉la꞉fo꞉ko꞉lo꞉ amisa꞉n a꞉namio꞉, eyo꞉ molo ha꞉na꞉no꞉wo꞉ mo꞉dimido꞉. Ko꞉sega kalu a꞉la꞉se walafdo꞉ bo꞉lo꞉ a꞉no꞉ e dagiya꞉ golab amio꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kaluka꞉isaleya꞉lo꞉ mo꞉tilida꞉dab a꞉na ilikiyo꞉, Ya꞉su eyo꞉ mada molo asulo꞉. A꞉la꞉ta꞉ga꞉ Ya꞉su e amisa꞉n nowa a꞉la꞉i ha꞉nakiyo꞉, towo꞉ wida꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enedo꞉ tili wida꞉sen kalu kugu a꞉la꞉fo꞉ a꞉no꞉ elo꞉wa mena꞉ki ho꞉lelia꞉sa꞉ga꞉, mama mogago꞉wo꞉ o꞉lusanaga꞉felema꞉ki, imo꞉wo꞉ halaido꞉wo꞉ dimi. A꞉la꞉ta꞉ga꞉ iyo꞉ amisa꞉n ko꞉lilo꞉wa a꞉la꞉, a꞉la꞉, a꞉la꞉ iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Iliga꞉takiyo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ ha꞉nakiyo꞉ kelego꞉ nolo꞉ dia꞉ha꞉na꞉so꞉bo, ido꞉m imilise ko dia꞉sa꞉ga꞉ ha꞉na꞉bi. Ma꞉no꞉wo꞉, aso꞉, moleyo꞉ giliyo꞉ dia꞉ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Giliyo꞉ budi ko꞉ sa꞉ga꞉laki ko꞉sega, so꞉go꞉ a꞉la꞉yo꞉ giliyo꞉ sa꞉ga꞉lefo꞉ ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Gio꞉ ha꞉na꞉sa꞉ga꞉, amisa꞉na fa꞉la꞉dowa꞉sa꞉ga꞉yo꞉, gio꞉ a gelo꞉ fa꞉la꞉dowab a꞉naka seno꞉, gio꞉ amisa꞉n a꞉no꞉ ta꞉fo꞉ ha꞉naki, eda꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Gio꞉ ha꞉na꞉sia꞉sa꞉ga꞉ amisa꞉n nowa fa꞉la꞉dowo꞉ amio꞉, gio꞉ ko꞉lo꞉ migi widaki, gililo꞉ to sio꞉wo꞉lo꞉ mo꞉tilida꞉da꞉b a꞉lalega, giliyo꞉ amisa꞉n a꞉no꞉ mogago꞉ da꞉fe alitakiyo꞉, gili gido꞉fo꞉ amilo꞉ hena꞉mu a꞉no꞉ a꞉naka fifila꞉sa꞉ga꞉ ha꞉na꞉bi.” Ya꞉su eyo꞉ enedo꞉ tili wido꞉mo꞉wo꞉ a꞉la꞉wida꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉ ha꞉na꞉ga꞉yo꞉, Godeya꞉ mano꞉ a꞉la꞉wido꞉, “Kaluka꞉isale gio꞉ asugo꞉ nodoma” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Iliyo꞉ mama mogago꞉wo꞉ o꞉luga꞉felaki, a꞉la꞉ta꞉ga꞉ walaf kalu modo꞉ a꞉namilo꞉ seno꞉, wa ho꞉no꞉ iya tulu alifelabiki, iyo꞉ a꞉na falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kaluka꞉isale modo꞉wa꞉yo꞉ Ya꞉su eyo꞉ nafa dimidab a꞉la꞉liki malolabiki, misa꞉ kalu alan Ha꞉lod e dabu. Kalu nolba꞉yo꞉ a꞉la꞉sio꞉, “Kalu we Yo꞉n ho꞉n amilo꞉ to꞉lola꞉seno꞉ o꞉m. E sowa꞉sa꞉ga꞉yo꞉, a꞉ma꞉la꞉ a꞉dasi ko꞉lo꞉, o꞉go꞉ eyo꞉ halaido꞉wo꞉ diaki, molo ha꞉na꞉no꞉wo꞉ a꞉na dimida꞉lab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Kaluka꞉isale nolba꞉yo꞉ a꞉la꞉sio꞉, “Kalu we Elaiya.” A꞉la꞉ta꞉ga꞉ nolba꞉yo꞉ a꞉la꞉sio꞉, “Kalu we, Godeya꞉ tolo꞉ dinali sa꞉lan kaluwo꞉ we. Tamin amilo꞉ Godeya꞉ tolo꞉ dinali sa꞉la꞉sen kalu o꞉ngo꞉ ko꞉lo꞉ a꞉lab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ko꞉sega misa꞉ kalu Ha꞉lod e da꞉da꞉sa꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Yo꞉n nilo꞉ dagasdo꞉ gedela꞉yo꞉, e mada a꞉ma꞉la꞉ dasi,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Mo꞉wo꞉ tamin amio꞉, Ha꞉lod eyo꞉ ene ao Filiba꞉ inga Ha꞉lodiaso꞉ asulia꞉ga꞉ a꞉diabikiyo꞉, Yo꞉n eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ dimidab wema꞉yo꞉ ele saefa꞉yo꞉ o꞉go꞉sab.” A꞉la꞉sa꞉labikiyo꞉, Ha꞉lod eyo꞉ Yo꞉no꞉ mela꞉sa꞉ga꞉ dibolowa to꞉lo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A꞉la꞉ta꞉ga꞉ Ha꞉lodias eyo꞉ Yo꞉nbo꞉wo꞉ kulufa꞉ya꞉sa꞉ga꞉, Yo꞉no꞉ sana soma꞉no꞉ asulo꞉ ko꞉sega, elo꞉ asulo꞉ aumbo꞉ mo꞉dimidama꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Mo꞉wo꞉ Ha꞉lod eyo꞉ Yo꞉n e digalo꞉ kalu a꞉la꞉ta꞉ga꞉ Godeya꞉ ene nanogdo꞉ dian kalu nowo꞉ e a꞉la꞉asula꞉sa꞉ga꞉ tagilaki, eyo꞉ e bo꞉fo꞉len. Ha꞉lodo꞉ Yo꞉na꞉lo꞉ to man wida꞉lab a꞉no꞉ da꞉da꞉likiyo꞉, e kele asula꞉sen, ko꞉sega elo꞉ to nol sa꞉lab a꞉no꞉ iligi da꞉da꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tif amio꞉ Ha꞉lodias eyo꞉ Yo꞉ndo꞉ sana soma꞉no꞉ ho꞉len nafa nowo꞉ a꞉na fa꞉la꞉dowo꞉. Ha꞉lod elo꞉ sa꞉la꞉li ho꞉leno꞉ fa꞉la꞉dowabiki, ma꞉no꞉wo꞉ alan dowo꞉fa꞉. A꞉la꞉fo꞉ko꞉lo꞉ gamani misa꞉ kaluwo꞉lo꞉, da꞉la꞉di kalu misa꞉ dosdo꞉wo꞉lo꞉, Ga꞉lili amilo꞉ wabulun kaluwo꞉lo꞉ tambo a꞉na kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kegeo꞉ siwa꞉l amio꞉ Ha꞉lodiasa꞉ ida꞉ a꞉no꞉ ya꞉sa꞉ga꞉, e bo꞉ba꞉ki gulo꞉ a꞉na gulakiyo꞉ sosomayo꞉ a꞉na dowo꞉. Ha꞉lodo꞉ amilo꞉ kalu kegeo꞉ a꞉ma꞉yo꞉lo꞉ sosoma dowab a꞉no꞉ ba꞉da꞉ga꞉, mada asulabiki, Ha꞉lod eyo꞉ ga bolo꞉ o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ dia꞉no꞉ asulo꞉ ko꞉lo꞉ nemo꞉lo꞉ dabu ba꞉dab a꞉no꞉, niyo꞉ gemo꞉wo꞉ hendele dimia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Eyo꞉ ga bolo꞉ o꞉mo꞉wo꞉ kalu kegeo꞉ siwa꞉la dinali sa꞉lakiyo꞉, “Giyo꞉ kelego꞉ o꞉ba꞉le nemo꞉lo꞉ dabu ba꞉dab a꞉no꞉, niyo꞉ gemo꞉wo꞉ hendele dimia꞉no꞉ka꞉. Hen nilo꞉wo꞉ usa aloba꞉da꞉sa꞉ga꞉ nemo꞉ dimina a꞉lalega, niyo꞉ gemo꞉wo꞉ o꞉li dimia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A꞉la꞉sa꞉labiki, ga bolo꞉ a꞉no꞉ ha꞉na꞉sa꞉ga꞉, anomo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Niyo꞉ kelego꞉ o꞉b ko꞉lo꞉ ha꞉nima꞉no꞉wa꞉le?” Anomo꞉wo꞉ a꞉la꞉dabu ba꞉dabiki, eyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “‘Yo꞉n, ho꞉n amilo꞉ to꞉lolan kaluwa꞉ misa꞉ gedeo꞉wo꞉ ko꞉lo꞉ dimina’ a꞉la꞉sa꞉la꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, misa꞉ kalu Ha꞉lod elo꞉ amio꞉ bo꞉bo꞉ge ha꞉na꞉sa꞉ga꞉ a꞉la꞉sio꞉, “O꞉go꞉ giyo꞉ Yo꞉na꞉ misa꞉yo꞉ gedea꞉sa꞉ga꞉, fafo usa fo꞉fo꞉la꞉sa꞉ga꞉ nemo꞉ dimina” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ha꞉lod e to a꞉no꞉ da꞉da꞉sa꞉ga꞉, e mada nofolo꞉wo꞉ alan dowo꞉, ko꞉sega eyo꞉ tamin amilo꞉ dinali sio꞉ a꞉no꞉ kalu kegeo꞉ iyo꞉ dabu ko꞉lo꞉ elo꞉ dinali sio꞉ a꞉no꞉ mo꞉ta꞉fa꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","A꞉la꞉fo꞉ko꞉lo꞉ wigibo a꞉naka eyo꞉ ene da꞉la꞉di kaluwo꞉ Yo꞉na꞉ misa꞉yo꞉ gedelia꞉ga꞉ mena꞉ki, eyo꞉ iyo꞉ a꞉na iliga꞉fo꞉. Da꞉la꞉di kaluwo꞉ dibolo aya ha꞉na꞉sa꞉ga꞉, Yo꞉na꞉ misa꞉yo꞉ gedelia꞉ga꞉, fafowa fo꞉fo꞉lelia꞉ga꞉yo꞉, ga bolo꞉ o꞉mo꞉ dimiabiki, eyo꞉ anomo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yo꞉na꞉lo꞉ tili wida꞉sen kalu iliyo꞉ dimido꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ ya꞉sa꞉ga꞉, Yo꞉na꞉ do꞉mo꞉ a꞉no꞉ dia꞉sa꞉ga꞉ u no꞉no꞉ usa difa꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iliga꞉felo꞉ kaluwo꞉ a꞉ma꞉la꞉ Ya꞉sulo꞉wa kegeakiyo꞉, ililo꞉ dimido꞉wo꞉lo꞉, wido꞉wo꞉lo꞉ a꞉no꞉ tambo emo꞉ malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kaluka꞉isaleyo꞉ modo꞉ kegeo꞉ ko꞉lo꞉ nolo꞉ ha꞉na꞉liki, nolo꞉ ya꞉liki a꞉lai ko꞉lo꞉, iyo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ fogo꞉ mo꞉dowo꞉. A꞉la꞉gabiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ kalulo꞉mala ha꞉na꞉sa꞉ga꞉, ha꞉fo꞉ mesa꞉ni ha꞉na꞉n” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","A꞉la꞉ta꞉ga꞉ iyo꞉ egelese ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉, kalulo꞉ma hena ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ko꞉sega amisa꞉n ko꞉li ko꞉lilo꞉ amilo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ Ya꞉sulo꞉ iyo꞉ ha꞉nabikiyo꞉ ini siya꞉ ba꞉da꞉sa꞉ga꞉, iyo꞉ bo꞉bo꞉ge nai ha꞉na꞉sia꞉sa꞉ga꞉, ilo꞉ fa꞉la꞉doma꞉no꞉lo꞉ a꞉na yasisen. ");
INSERT INTO bco_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ya꞉suwo꞉ ho꞉n ko꞉suwa ya꞉sa꞉ga꞉ kagayo꞉ amio꞉, kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ kegenefo꞉lena ba꞉ba꞉. I a꞉no꞉ ba꞉da꞉sa꞉ga꞉, Ya꞉su eyo꞉ nofolo꞉wo꞉ alan dowakiyo꞉ a꞉la꞉asulo꞉, iyo꞉ sibi ko꞉lo꞉ bo꞉fo꞉lowano꞉ aundo꞉malo꞉ngo꞉ma꞉ gabiki, eyo꞉ imo꞉wo꞉ Godeya꞉ to mano꞉ modo꞉ ko꞉lo꞉ walasio꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ga꞉lo dowabiki, tiliwida꞉sen kaluwo꞉ Ya꞉sulo꞉wa sa꞉ma꞉ni ya꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Nio꞉ ma꞉no꞉loma hena siliki ko꞉lo꞉, ma꞉no꞉wo꞉ mo꞉mo꞉no꞉ka nudab. ");
INSERT INTO bco_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isaleyo꞉ ma꞉no꞉wo꞉ ini kililia꞉sa꞉ga꞉ maiya꞉ki, amisa꞉n kandayo꞉lo꞉ a꞉na tambo iliga꞉felema.” ");
INSERT INTO bco_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ma꞉no꞉ ililo꞉ ma꞉no꞉wo꞉ gili dimina.” A꞉la꞉sa꞉labiki iliyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ele ola꞉fo꞉ amilo꞉ mole nanog di o꞉ngo꞉ma꞉, kaluka꞉isale wemo꞉wo꞉ ma꞉no꞉wo꞉ kililia꞉sa꞉ga꞉ mealiki, iyo꞉ ma꞉no꞉wo꞉ a꞉na ililima꞉no꞉lo꞉ka꞉. Niliyo꞉ mo꞉ililo꞉.” ");
INSERT INTO bco_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Falawa dowo꞉fa꞉yo꞉ iliyo꞉ o꞉biba꞉s da꞉laba꞉le kelema꞉ni hamana.” Iliyo꞉ falawa dowo꞉fa꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Niliyo꞉ falawa dowo꞉fa꞉ bila꞉fo꞉, a꞉la꞉ta꞉ga꞉ ka꞉ a꞉la꞉ ko꞉lo꞉ da꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ kaluka꞉isaleyo꞉ aloba꞉da꞉sa꞉ga꞉, fudo꞉ imilise a꞉la꞉ta꞉ga꞉ fudo꞉ a꞉la꞉, a꞉la꞉bo꞉ fugusa꞉ wa꞉la kandama a꞉la꞉sio꞉. A꞉la꞉sa꞉labiki kaluka꞉isale iyo꞉ aloba꞉da꞉sa꞉ga꞉, a꞉la꞉ta꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ya꞉su eyo꞉ falawa dowo꞉fa꞉ bila꞉fo꞉ o꞉lia꞉ ka꞉ a꞉la꞉yo꞉ dia꞉sa꞉ga꞉, akino꞉ alolo bo꞉fo꞉liki, Godemo꞉ mada o꞉m a꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, falawa dowo꞉fa꞉ a꞉no꞉ a꞉na godo꞉. A꞉na goda꞉sa꞉ga꞉yo꞉, kaluka꞉isalemo꞉ sagama꞉ki, enedo꞉ tiliwida꞉sen kalumo꞉ dimi. A꞉la꞉ta꞉ga꞉ ka꞉ a꞉la꞉ a꞉no꞉lo꞉ taboda꞉sa꞉ga꞉, kaluka꞉isalemo꞉ so꞉go꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Kaluka꞉isale kegeo꞉ a꞉no꞉ ma꞉no꞉wo꞉ tambo o꞉li na꞉sa꞉ga꞉ ililitabiki, falawa dowo꞉fa꞉ go꞉go꞉bela꞉ o꞉lia꞉ ka꞉ o꞉lia꞉ ko꞉lo꞉ heb ta꞉felab a꞉no꞉, enedo꞉ tili wida꞉sen kalu iliyo꞉ kegeo꞉ amio꞉ fafowo꞉ kugula꞉fo꞉ ko꞉lo꞉ wa꞉litabi difa꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ho꞉len a꞉namio꞉ kaluka꞉isaleyo꞉ ma꞉no꞉wo꞉ mada modo꞉ ko꞉lo꞉ mo꞉no꞉, ko꞉sega kalu ko꞉go꞉do꞉ agelo꞉wo꞉, daosen bila꞉fo꞉ ko꞉lo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","O꞉g a꞉nakabiyo꞉ Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalu a꞉no꞉ ko꞉suwa bo꞉bo꞉ge disa꞉la꞉sa꞉ga꞉, ho꞉n golo꞉ nodowa Besaida a꞉na tamina hamana꞉ki iliga꞉ta꞉ga꞉yo꞉, Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉lo꞉ a꞉ma꞉la꞉ iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","A꞉la꞉ta꞉ga꞉yo꞉ eyo꞉ iyo꞉ ta꞉ta꞉sa꞉ga꞉, ina꞉li misio꞉wa ha꞉na꞉ga꞉, Godemo꞉ dulugu sa꞉ma꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Sola꞉ga꞉ yabikiyo꞉ ho꞉n ko꞉suwo꞉ ho꞉n golo꞉ usa o꞉ha꞉na꞉ga꞉ ha꞉nabi, Ya꞉su e ina꞉li a꞉naka elen. ");
INSERT INTO bco_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Fufayo꞉ alan yakiyo꞉, ho꞉n ko꞉suwa ba꞉labiki, tiliwida꞉sen iyo꞉ kolama꞉no꞉wo꞉ halaido꞉ dowo꞉. Ililo꞉ dimidab a꞉no꞉ Ya꞉suwo꞉ ba꞉ba꞉. Nulu us dowabikiyo꞉, e ha꞉na꞉ga꞉ ho꞉n fa꞉s wa꞉la fina꞉ga꞉ ha꞉nakiyo꞉, iyo꞉ nodo begele ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ko꞉sega iyo꞉ Ya꞉su ko꞉lo꞉ ho꞉n fa꞉s wa꞉l amilo꞉ yab a꞉no꞉ ba꞉da꞉ga꞉yo꞉, iyo꞉ tagi ganafo꞉daki, we sowo꞉ mama ko꞉lo꞉ yab a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Iliyo꞉ e ba꞉da꞉sa꞉ga꞉ mada tagio꞉ alan dowabiki, Ya꞉su eyo꞉ wigibo a꞉naka imo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Gio꞉ tagila꞉so꞉bo. We neka꞉! Gili asulo꞉wo꞉ halale doma.” ");
INSERT INTO bco_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ya꞉su e i o꞉lia꞉ ho꞉n ko꞉su usa disa꞉la꞉sa꞉ga꞉ dowab amio꞉, fufa ya꞉len a꞉no꞉ a꞉naka bulutabiki, iyo꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉ mada alan iligaki molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mo꞉wo꞉ iyo꞉ Ya꞉suwa꞉lo꞉ kaluka꞉isalemo꞉lo꞉ ma꞉no꞉ dimiyo꞉ ba꞉ba꞉ ko꞉sega, iyo꞉ ha꞉go꞉ mo꞉dinafa asulaki, ili asulo꞉ uso꞉ halaido꞉ dowaki, babalela꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iyo꞉ ho꞉n golo꞉ a꞉no꞉ ta꞉nota꞉ga꞉, Genesalet hen a꞉na fa꞉la꞉dowakiyo꞉, ho꞉n ko꞉suwo꞉ a꞉na galo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Iyo꞉ ho꞉n ko꞉suwa a꞉la꞉ta꞉ga꞉ ha꞉la꞉ya handalowab amio꞉, kaluka꞉isale iliyo꞉ we Ya꞉sulo꞉b a꞉la꞉fanda ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Kaluka꞉isale iliyo꞉ Ya꞉suwo꞉ wena a꞉lab a꞉la꞉da꞉da꞉ga꞉yo꞉, iyo꞉ ini amisa꞉n amilo꞉ walaf kalu delen a꞉no꞉ ga꞉lima꞉ni nai ha꞉na꞉sio꞉. Walaf kalu a꞉no꞉ geo꞉ndo꞉ wa꞉la bobodolia꞉ga꞉, Ya꞉sulo꞉ a꞉lab a꞉na dia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","A꞉la꞉ta꞉ga꞉ amisa꞉n elo꞉ ha꞉na꞉ga꞉ ha꞉nab amio꞉, walafdo꞉ dosdo꞉ elen a꞉no꞉ kalulo꞉ kegea꞉sen hen a꞉na dia꞉mio꞉. Walafdo꞉ dowo꞉ iliyo꞉ Ya꞉sumo꞉ susiakiyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ gi helebeso꞉g migif kona goma꞉no꞉wo꞉ o꞉liya꞉le?” A꞉la꞉ta꞉ga꞉ walaf kaluka꞉isale abeyo꞉ Ya꞉suwa꞉ so꞉g ko꞉lo꞉ amilo꞉ golab a꞉no꞉ falela꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Elelo꞉ wida꞉sen kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉yo꞉ Ya꞉lusalem a꞉na a꞉la꞉ta꞉ga꞉ ya꞉sa꞉ga꞉, Ya꞉sulo꞉wa kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Iyo꞉ a꞉na silikiyo꞉, Ya꞉suwa꞉lo꞉ tiliwida꞉sen kaluwo꞉ dagi heyo꞉wo꞉ mo꞉to꞉go꞉do꞉ka ma꞉no꞉wo꞉ na꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Yu kalu o꞉lia꞉ Fa꞉lisi kalu o꞉lia꞉ma꞉yo꞉ dagiyo꞉ mo꞉to꞉go꞉dalega, ma꞉no꞉wo꞉ mo꞉nan. Mo꞉wo꞉ inin ma꞉muwa꞉ man a꞉ma꞉yo꞉ a꞉la꞉dimidan. ");
INSERT INTO bco_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","A꞉la꞉ta꞉ga꞉ iyo꞉ ma꞉no꞉lo꞉ kililia꞉sen hen a꞉na ha꞉na꞉sa꞉ga꞉ yakiyo꞉, ma꞉no꞉ a꞉no꞉ o꞉semo꞉naki, ho꞉n ko꞉le mululan. A꞉la꞉ta꞉ga꞉ inin ma꞉muwa꞉ man nolo꞉ kudu ha꞉nakiyo꞉, kelego꞉ nolo꞉ fafowo꞉, bana꞉so꞉go꞉wo꞉, go꞉fo꞉wo꞉, kelego꞉ o꞉ngo꞉wo꞉ tambo to꞉go꞉dan. ");
INSERT INTO bco_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A꞉la꞉fo꞉ko꞉lo꞉ Fa꞉lisi kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gilo꞉ tiliwida꞉sen kalu koma꞉yo꞉ nili ma꞉muwa꞉lo꞉ ele saefa꞉ a꞉no꞉ mo꞉kudu ha꞉naki, ma꞉no꞉wo꞉ dagiyo꞉ mo꞉to꞉go꞉do꞉ kabilo꞉ nab we, mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Madalilo꞉ dikili sa꞉lan kalu o꞉go꞉do꞉ gi ko꞉lo꞉ dowab we, tamin amio꞉ Godeya꞉ tolo꞉ dinali sa꞉lan kalu Aisaya eyo꞉ hendele gi we ko꞉lo꞉ sa꞉lakiyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Kaluka꞉isale i wema꞉yo꞉ to mosowa꞉yo꞉ ni wiyo꞉ ko꞉lo꞉ duludan, ko꞉sega inin asulo꞉wo꞉ ne o꞉lia꞉yo꞉ mo꞉imilo꞉, ko꞉na꞉ dofo꞉likigab. ");
INSERT INTO bco_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Iliyo꞉ henfelo꞉wa꞉ eleyo꞉ ko꞉lo꞉ widakiyo꞉, Godeya꞉ ene ele a꞉no꞉ ko꞉lo꞉ wido꞉l a꞉la꞉sa꞉la꞉sen. Iliyo꞉ hendele nelo꞉ mo꞉duludaki, madali mo꞉lo꞉ma a꞉no꞉ ko꞉lo꞉ duluda꞉lab.’ Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Giliyo꞉ Godeya꞉ ene ele saefa꞉ a꞉no꞉ ta꞉ta꞉ga꞉, ginido꞉ mo꞉lulo꞉ ele dimidan man a꞉no꞉ ko꞉lo꞉ ta꞉li siliki kudu ha꞉na꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ya꞉suwa꞉ to nowo꞉ a꞉la꞉sio꞉, “Gio꞉ mo꞉lulo꞉ ele dimidan a꞉no꞉ ko꞉lo꞉ kudu ha꞉na꞉no꞉ asulaki, Godeya꞉ ele saefa꞉ a꞉no꞉ giliyo꞉ nodola꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mo꞉sa꞉sa꞉ ele difa꞉ a꞉ma꞉ sa꞉laki a꞉la꞉sio꞉, ‘Gio꞉ go꞉lo꞉ go꞉wo꞉ alano꞉ o꞉m a꞉la꞉asulaki, ili ha꞉ga dowa꞉lubi.’ A꞉la꞉ta꞉ga꞉ ‘so꞉wa abeyo꞉ iya anolia꞉mo꞉wo꞉ to mogago꞉wo꞉ sa꞉lalega, giliyo꞉ e mada sana sowa꞉bi.’ ");
INSERT INTO bco_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ko꞉sega giliyo꞉ ele ho꞉gileyo꞉ ko꞉lo꞉ widan. Kalu abeyo꞉ kelego꞉ nafa elo꞉wo꞉ deliki ko꞉sega, eyo꞉ iya anolia꞉mo꞉wo꞉ a꞉la꞉sa꞉lakiyo꞉, ‘Kelego꞉ we gemo꞉wo꞉ dimia꞉no꞉ ko꞉sega, kelego꞉ a꞉no꞉ Godemo꞉ dimia꞉no꞉ da꞉fefa꞉ ko꞉lo꞉ gemo꞉wo꞉ mo꞉dimia꞉no꞉.’ ");
INSERT INTO bco_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","So꞉wa a꞉ma꞉yo꞉ a꞉la꞉sa꞉lalega, giliyo꞉ so꞉wa a꞉ma꞉yo꞉ iyalia꞉ anolia꞉ asuwa꞉fa꞉no꞉wo꞉ kalaki auma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","A꞉la꞉fo꞉ko꞉lo꞉ ginin man kudu ha꞉nab a꞉ma꞉ ilikiyo꞉, Godeya꞉ ene man nafa a꞉ma꞉ halaido꞉wo꞉ ko꞉lo꞉ dilaki dimida꞉lab. Giliyo꞉ man wengo꞉wo꞉ ko꞉li ko꞉lilo꞉ dimida꞉sen.” ");
INSERT INTO bco_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","To a꞉no꞉ sa꞉la꞉sa꞉ga꞉yo꞉, eyo꞉ kaluka꞉isaleyo꞉ a꞉kegea꞉sa꞉ga꞉, imo꞉ sa꞉laki, “Dabuma. Giliyo꞉ to nilo꞉ we dinafa tili asuluma. ");
INSERT INTO bco_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Kelego꞉ ha꞉la꞉ amilo꞉ ko꞉lo꞉ kalu kufa꞉ us amilo꞉ tinab a꞉ma꞉yo꞉, kaluwo꞉ mo꞉henema꞉ib. Ko꞉sega kaluwa꞉ asulo꞉ us amilo꞉ delen ko꞉lo꞉ ha꞉la꞉ amilo꞉ sa handalowab a꞉ma꞉ henema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Kaluka꞉isale kegeo꞉ a꞉no꞉ a꞉naka ta꞉ta꞉ga꞉, Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ a usa ti ha꞉na꞉sa꞉ga꞉, iliyo꞉ bale sio꞉ a꞉ma꞉ ha꞉go꞉ Ya꞉sumo꞉ dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ ha꞉go꞉ mo꞉asulaba? Kaluwa꞉ ma꞉no꞉ nab a꞉ma꞉yo꞉ e mo꞉mogaima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mo꞉wo꞉ ma꞉no꞉ a꞉no꞉ kaluwa꞉ asulo꞉ usamio꞉ mo꞉ha꞉nab. Ma꞉no꞉ a꞉no꞉ kufa꞉ usa ha꞉na꞉sa꞉ga꞉, a꞉ma꞉la꞉ ha꞉la꞉ya ha꞉nab.” (Ya꞉suwa꞉ to sio꞉ wema꞉yo꞉, ma꞉no꞉ ko꞉li ko꞉lilo꞉ we tambo o꞉lika na꞉bika꞉ a꞉laki sio꞉.) ");
INSERT INTO bco_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Mogago꞉ ko꞉li ko꞉lilo꞉ kaluwa꞉ asulo꞉ usa a꞉la꞉ta꞉ga꞉lo꞉ ha꞉la꞉ amilo꞉ sahandalowa꞉lab a꞉ma꞉, kaluwa꞉ asulo꞉wo꞉ heya꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Mogago꞉wo꞉ kaluwa꞉ asulo꞉ usamilo꞉ delen ko꞉lo꞉ ha꞉la꞉ amilo꞉ fa꞉la꞉dowa꞉labo꞉ we. Asulo꞉ mogago꞉, uwo꞉ dian, kelego꞉ afale dian, kalu sana sowan, kalu galeso꞉ o꞉lia꞉ ga indo꞉ o꞉lia꞉ma꞉ afa dian, ");
INSERT INTO bco_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","meselan, mogago꞉ ko꞉li ko꞉lilo꞉ dimidan, dikidan, sada꞉dan, no꞉no꞉n ne alan a꞉la꞉asulan, yo꞉le dowan. ");
INSERT INTO bco_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Man mogago꞉ dimidan ko꞉lo꞉ sa꞉lab we, kaluwa꞉ asulo꞉ usa a꞉la꞉ta꞉ga꞉ ha꞉la꞉ amilo꞉ handalowab a꞉ma꞉yo꞉ kaluwo꞉ mada mogagila꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ya꞉suwo꞉ Godeya꞉ man a꞉no꞉ wida꞉sa꞉ga꞉yo꞉, hen a꞉no꞉ ka ta꞉ta꞉sa꞉ga꞉, e Taya hen heb doba꞉da꞉ a꞉na ha꞉na꞉ni ane. E ha꞉na꞉sa꞉ga꞉ a꞉na fa꞉la꞉dota꞉ga꞉yo꞉, e a usa wo꞉no꞉le mesa꞉ni ane ko꞉sega, kalu nolba꞉yo꞉ e a꞉na mio꞉lo꞉b a꞉la꞉bo꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ga nowo꞉ ida꞉la꞉suwo꞉ mama mogago꞉lo꞉ dowo꞉ a꞉no꞉ a꞉na sen ko꞉lo꞉, Ya꞉su mio꞉wo꞉ da꞉da꞉sa꞉ga꞉, wigibole a꞉naka ga a꞉no꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, Ya꞉suwa꞉ gibdo꞉ a꞉na gumisi ali. ");
INSERT INTO bco_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ga a꞉no꞉ Gilig to sa꞉lan, e Fonisia amisa꞉n, Silia hen a꞉na sa꞉la꞉li. Eyo꞉ mama mogago꞉ ida꞉ amilo꞉ dowo꞉ a꞉no꞉, Ya꞉sumo꞉ o꞉luma꞉ki mada ha꞉nolo sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉sio꞉, “So꞉wagalino꞉ ma꞉no꞉wo꞉ tamina mea꞉sa꞉ga꞉ o꞉li dowaliki ta꞉ta꞉bi. So꞉wagalina꞉ ma꞉no꞉wo꞉ asulia꞉ga꞉yo꞉, gasamo꞉ sandifa꞉no꞉wo꞉ mada mo꞉ililo꞉.” ");
INSERT INTO bco_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, ga a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Kalu alan, giyo꞉ hendele sa꞉lab ko꞉sega, so꞉wagalina꞉lo꞉ ma꞉no꞉ nakilo꞉ muda꞉yo꞉ sudufelab a꞉no꞉, gasaya꞉yo꞉ ka ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A꞉la꞉sa꞉labiki eyo꞉ ga o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “To nafa gilo꞉ sa꞉lab a꞉na ilikiyo꞉, ga꞉la꞉ amilo꞉ mama mogago꞉ dofo꞉lab a꞉no꞉ e ta꞉fo꞉ ha꞉nab ko꞉lo꞉, ge a꞉ma꞉la꞉ aya ba꞉ba꞉ni hamana.” ");
INSERT INTO bco_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","A꞉la꞉sa꞉labiki ga a꞉no꞉ ene aya a꞉ma꞉la꞉ ha꞉na꞉ga꞉ ba꞉ba꞉yo꞉, ida꞉ amilo꞉ mama mogago꞉ dofo꞉len a꞉no꞉ ta꞉fo꞉gane ko꞉lo꞉, e ga꞉li uwo꞉ba alifo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","A꞉la꞉ga꞉sa꞉ga꞉yo꞉ Ya꞉suwo꞉ Tayalo꞉ elen a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, Saido꞉n hen a꞉no꞉ tininita꞉ga꞉, Ga꞉lili ho꞉n golo꞉ doba꞉da꞉, Dekabolis hen a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","E a꞉na fa꞉la꞉dowo꞉ amio꞉, ka꞉la꞉no꞉ ko꞉lo꞉ a꞉la꞉ta꞉ga꞉ tolo꞉ mo꞉dinafa sa꞉lan kalu nowo꞉ a꞉na sen. Kalu nolba꞉yo꞉ e gasilia꞉sa꞉ga꞉, Ya꞉suwa꞉ dagiya꞉yo꞉ e do꞉mo꞉wa goloma꞉ki dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ya꞉su eyo꞉ kalu a꞉no꞉ tililia꞉ga꞉, kegeo꞉ aniba kagataki, Ya꞉suwa꞉ dagiyo꞉ ka꞉la꞉n alu a꞉la꞉ya golo꞉. A꞉la꞉ta꞉ga꞉ mekowayo꞉ dagiya kodofela꞉sa꞉ga꞉, kalu a꞉ma꞉ eana golo꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A꞉la꞉dimida꞉sa꞉ga꞉ Ya꞉su eyo꞉ akino꞉ alolo bo꞉fo꞉la꞉ga꞉ ha꞉ a꞉la꞉ga꞉takiyo꞉, kalu o꞉mo꞉wo꞉ “A꞉fata” a꞉la꞉sio꞉. To wema꞉ ha꞉go꞉ we, “Togo alifoma.” ");
INSERT INTO bco_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","A꞉la꞉sa꞉labiki kalu a꞉ma꞉ ka꞉la꞉no꞉ togo꞉ alitaki, eano꞉lo꞉ a꞉ma꞉la꞉ nodo alitabiki, e towo꞉ nafa tola꞉. ");
INSERT INTO bco_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ kalu nolbo꞉wo꞉ sa꞉la꞉so꞉boka꞉ a꞉la꞉liki halaido꞉ sio꞉. Ko꞉sega iliyo꞉ Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ko꞉ malola꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kaluka꞉isaleyo꞉ mada iligi ba꞉dakiyo꞉ a꞉la꞉sio꞉, “Eyo꞉ mada tambo man nafale dimido꞉. Ya꞉su eyo꞉ ka꞉la꞉no꞉ ko꞉lo꞉ kaluka꞉isale a꞉no꞉ a꞉ma꞉la꞉ togo꞉ alitabiki, o꞉li da꞉dab. A꞉la꞉ta꞉ga꞉ eyo꞉ do꞉fo꞉f kaluka꞉isale a꞉no꞉ eano꞉ a꞉ma꞉la꞉ nodo alitabikiyo꞉, o꞉li tolab.” ");
INSERT INTO bco_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ho꞉len a꞉namio꞉ kaluka꞉isale nolo꞉lo꞉ Ya꞉sulo꞉wa kegeo꞉. Iyo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉ma dowo꞉ ko꞉lo꞉, Ya꞉su eyo꞉ enedo꞉ tiliwida꞉sen kaluwo꞉ elo꞉wa mena꞉ki ho꞉ida꞉sa꞉ga꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Kalu kegeo꞉ we ho꞉len otaleno꞉ ne o꞉lia꞉ wena sen ko꞉lo꞉, iyo꞉ ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉ma ko꞉lo꞉, iyo꞉ ne mada nofolab. ");
INSERT INTO bco_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Niyo꞉ iyo꞉ a꞉ma꞉la꞉yo꞉ maiyo꞉ a꞉naka iliga꞉to꞉loga, iyo꞉ hena꞉ usamio꞉ maiyakiyo꞉ halaido꞉wo꞉ aundo꞉ma dowaki habaya soma꞉ib. Mo꞉wo꞉ kalu nolo꞉ heno꞉ ko꞉na꞉ a꞉la꞉ta꞉ga꞉ ya꞉sio꞉ ko꞉lo꞉ a꞉lab.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Enedo꞉ tili wida꞉sena꞉yo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Nio꞉ ma꞉no꞉loma hena so꞉l ko꞉lo꞉, niliyo꞉ kalu kegeo꞉ wemo꞉wo꞉ ma꞉no꞉wo꞉ o꞉ba dia꞉sa꞉ga꞉ mea꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Falawa so꞉fa꞉ ko꞉lo꞉ gililo꞉ da꞉lab ko o꞉biba꞉so꞉?” Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉dabiki, iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Dom a꞉la꞉fo꞉ ko꞉lo꞉ da꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ hena mesea a꞉la꞉sio꞉. Falawa so꞉fa꞉ dom a꞉la꞉fo꞉ a꞉no꞉ e dia꞉sa꞉ga꞉, Godemo꞉ mada o꞉m a꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, falawa so꞉fa꞉ a꞉no꞉ Ya꞉suwa꞉ goda꞉sa꞉ga꞉, kaluka꞉isale kegeo꞉ o꞉mo꞉ sagama꞉ki enedo꞉ tiliwida꞉sen kalumo꞉ dimi. A꞉la꞉ta꞉ga꞉ iliyo꞉ dia꞉sa꞉ga꞉, kaluka꞉isalemo꞉ so꞉go꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","A꞉la꞉gabiki iliyo꞉ ka꞉ galin nolo꞉ delen ko꞉lo꞉, emo꞉ dimiabiki, Godemo꞉ mada o꞉m a꞉la꞉sa꞉la꞉sa꞉ga꞉, ka꞉ a꞉no꞉lo꞉ sagama꞉ki, enedo꞉ tiliwida꞉sen kalumo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Iyo꞉ tambo ma꞉no꞉wo꞉ na꞉la꞉ga꞉ o꞉li dowabiki, ma꞉no꞉ heb ta꞉fa꞉lab a꞉no꞉ tiliwida꞉sen kalu ili a꞉kegea꞉sa꞉ga꞉, fafowo꞉ dom a꞉la꞉fo꞉ a꞉no꞉ wa꞉li tandeo꞉ ko꞉lo꞉ difa꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Ma꞉no꞉ o꞉lo꞉ mo꞉no꞉wo꞉, kalule agelo꞉wo꞉ daosen fa꞉la꞉da꞉in ko꞉lo꞉ sen. Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ a꞉ma꞉la꞉ iliga꞉ta꞉ga꞉, enen o꞉lia꞉ enedo꞉ tiliwida꞉sen kalu o꞉lia꞉yo꞉ ho꞉n ko꞉su usa disa꞉la꞉sa꞉ga꞉, Damanuta doba꞉da꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Iyo꞉ a꞉na fa꞉la꞉dowabikiyo꞉, Fa꞉lisi kaluwo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉, e o꞉lia꞉ towa꞉yo꞉ kego꞉. Ya꞉su e ko꞉lo꞉ da꞉fe ba꞉dakiyo꞉, Fa꞉lisi kalu iliyo꞉ a꞉la꞉sio꞉, “Ge hendele Godelo꞉wa a꞉la꞉ta꞉ga꞉ mio꞉ a꞉la꞉liki widakiyo꞉, molo ha꞉na꞉no꞉ nowo꞉ dimidama” a꞉la꞉likiyo꞉, emo꞉ dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ya꞉suwo꞉ ha꞉ a꞉la꞉ga꞉ta꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “O꞉g ho꞉len wenamilo꞉ kaluka꞉isale sab wema꞉lo꞉ molo ha꞉na꞉no꞉ a꞉kedab we mo꞉lilo꞉. Niyo꞉ hendele so꞉lo꞉l, kaluka꞉isale o꞉gdo꞉ sab wema꞉yo꞉ molo ha꞉na꞉no꞉wo꞉ mada mo꞉ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","To a꞉no꞉ wida꞉la꞉ga꞉yo꞉, Ya꞉su e Fa꞉lisi kalu i a꞉no꞉ a꞉naka ta꞉ta꞉ga꞉yo꞉, ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉, ho꞉n golo꞉ a꞉no꞉ ta꞉nota꞉ga꞉, nodowa ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ma꞉n dowo꞉fa꞉ dila꞉ a꞉no꞉ dia꞉no꞉wo꞉ enedo꞉ tili wida꞉sen kalu a꞉ma꞉yo꞉ ga꞉lila꞉ ko꞉sega, ma꞉n dowo꞉fa꞉ imiliseyo꞉ ho꞉n ko꞉su usamio꞉ delen. ");
INSERT INTO bco_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ya꞉su eyo꞉ imo꞉wo꞉ hagugu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Fa꞉lisi kaluwa꞉lo꞉ falawalo꞉ anayan kelego꞉wo꞉, a꞉la꞉ta꞉ga꞉ Ha꞉lod elo꞉ falawalo꞉ anayan kelego꞉ a꞉no꞉ dinafa ba꞉da꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","A꞉la꞉sa꞉labiki enedo꞉ tili wida꞉sen kaluwa꞉yo꞉ egelebo꞉ to a꞉no꞉ nenelakiyo꞉ a꞉la꞉sio꞉, “Nio꞉ ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉ma dowo꞉ ko꞉lo꞉, to we eyo꞉ a꞉na sa꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ililo꞉ nenelab a꞉no꞉ Ya꞉su e da꞉da꞉sa꞉ga꞉, e mo꞉beaki imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gio꞉ ma꞉no꞉ ma꞉no꞉wo꞉ aundo꞉malo꞉ka꞉ a꞉la꞉likiyo꞉ waga nenelaya? Gio꞉ o꞉semo꞉ fanda asulaya? Asulo꞉ gililo꞉wo꞉ babale dowaya? ");
INSERT INTO bco_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Gi amio꞉ siyo꞉ a꞉lab, ko꞉sega giliyo꞉ mo꞉dinafa ba꞉dab. Gi amio꞉ ka꞉la꞉no꞉ a꞉lab, ko꞉sega giliyo꞉ mo꞉dinafa da꞉da꞉lab. Nilo꞉ dimido꞉ a꞉no꞉ giliyo꞉ ga꞉lila꞉yo꞉? ");
INSERT INTO bco_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nilo꞉ falawa so꞉fa꞉yo꞉ bila꞉fo꞉ a꞉no꞉ goda꞉sa꞉ga꞉, kalu daosen bila꞉fo꞉mo꞉lo꞉ dimi a꞉no꞉, gio꞉ fanda asuluma꞉no꞉wo꞉ ga꞉lila꞉yo꞉? Gili na꞉la꞉ga꞉lo꞉ ma꞉no꞉ heb ko꞉lo꞉ fafo amilo꞉ wa꞉li alifelo꞉wo꞉ o꞉biba꞉so꞉?” Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉dabiki, iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Fafowo꞉ kugula꞉fo꞉ ko꞉lo꞉ wa꞉li alifelo꞉.” ");
INSERT INTO bco_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu daosen fa꞉la꞉da꞉inbo꞉lo꞉ falawa so꞉fa꞉ ko꞉lo꞉, goloso꞉go꞉ amio꞉ ma꞉n mo꞉no꞉ heb ta꞉fa꞉lab a꞉no꞉ kegea꞉sa꞉ga꞉lo꞉ fafo ko꞉lo꞉ wa꞉lifa꞉yo꞉ o꞉biba꞉so꞉?” A꞉la꞉dabu ba꞉dabiki iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Fafowo꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ wa꞉li alifa꞉.” ");
INSERT INTO bco_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Dimido꞉ a꞉no꞉ gio꞉ ba꞉ba꞉ ko꞉sega, gio꞉ o꞉semo꞉ fanda asulo꞉.” ");
INSERT INTO bco_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Iyo꞉ Besaida a꞉na ya꞉sa꞉ga꞉ fa꞉la꞉dowabiki, kalu nolba꞉yo꞉ siyo꞉ ko꞉n kalu nowo꞉ Ya꞉sumo꞉ falele alifoma꞉ki, a꞉na tililia꞉ mio꞉ ko꞉lo꞉, emo꞉ goloma꞉ki a꞉na susio꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ya꞉su eyo꞉ siyo꞉ ko꞉n kalu a꞉no꞉ dagiya gasilia꞉ga꞉, amisa꞉n ha꞉la꞉ya ha꞉na꞉sa꞉ga꞉ ami, siya kodofela꞉sa꞉ga꞉, dagi a꞉la꞉ma꞉yo꞉ eya golofo꞉liki, Ya꞉suwa꞉yo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge kelego꞉ nolo꞉ o꞉li ba꞉daya?” ");
INSERT INTO bco_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Kalu a꞉ma꞉yo꞉ sigili ba꞉da꞉ga꞉ a꞉la꞉sio꞉, “Niyo꞉ kalu ha꞉na꞉siabo꞉ ba꞉dai, ko꞉sega kaluwo꞉ i o꞉ngo꞉ ko꞉lo꞉ funa꞉ bo꞉do꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ya꞉su eyo꞉ wa꞉kabiyo꞉ kalu a꞉ma꞉ si amio꞉ dagi a꞉la꞉ma꞉ golabikiyo꞉, kalu a꞉ma꞉yo꞉ si kudu ba꞉dabiki, si a꞉no꞉ mada falele alita꞉ga꞉, kelego꞉wo꞉ tambo dinafa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","A꞉la꞉dimida꞉sa꞉ga꞉ Ya꞉su eyo꞉ e ene aya hamana꞉ki iliga꞉takiyo꞉ a꞉la꞉sio꞉, “Amisa꞉n kaluka꞉isale iliyo꞉ ge ba꞉dabena꞉ki, ge o꞉go꞉ amisa꞉n amio꞉ ha꞉na꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ya꞉suwo꞉ a꞉la꞉ta꞉ga꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ Sesalia Filibai hen amilo꞉ amisa꞉n nol a꞉na sia꞉len. Iyo꞉ a꞉na sia꞉likiyo꞉, Ya꞉su eyo꞉ imo꞉wo꞉ dabu ba꞉ba꞉. “Kaluka꞉isale iliyo꞉ ne ko꞉lo꞉ sa꞉lakiyo꞉, ne kalu o꞉bka꞉ a꞉la꞉sa꞉la꞉seno꞉?” ");
INSERT INTO bco_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Nolba꞉yo꞉ Yo꞉n ho꞉n amilo꞉ to꞉lolano꞉ ge. Nolba꞉yo꞉ ge Elaiya. A꞉la꞉ta꞉ga꞉ nolba꞉yo꞉ ge Godeya꞉ tolo꞉ dinali sa꞉lan kalu nowo꞉ ge, a꞉la꞉sio꞉.” ");
INSERT INTO bco_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Ko꞉sega gi wema꞉yo꞉, ne o꞉bka꞉ a꞉la꞉sa꞉laya?” Ya꞉suwa꞉ a꞉la꞉dabu ba꞉dabiki, Bida eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ge Keliso, Godeya꞉lo꞉ da꞉feyo꞉ kaluwo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ to a꞉no꞉ kaluka꞉isale nolbo꞉wo꞉ mada sa꞉la꞉so꞉boka꞉ a꞉la꞉liki hagugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A꞉la꞉sa꞉la꞉sa꞉ga꞉ eyo꞉ imo꞉wo꞉ a꞉la꞉wido꞉, “Kalule Dowo꞉ nemo꞉wo꞉ hida꞉yo꞉ alan dimia꞉ib. Godemo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ Yu ko꞉go꞉do꞉ kalu i o꞉lia꞉ma꞉yo꞉ tambo gola ba꞉dakiyo꞉, ne sana soma꞉ib. A꞉la꞉ta꞉ga꞉ ho꞉len otaleno꞉ ta꞉ta꞉sa꞉ga꞉, ne a꞉ma꞉la꞉ dasima꞉no꞉,” a꞉la꞉liki Ya꞉su eyo꞉ wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Eyo꞉ to a꞉no꞉ kalaba fanda sa꞉labiki, Bida eyo꞉ Ya꞉suwo꞉ ha꞉la꞉ya tililia꞉ ha꞉na꞉ga꞉ a꞉la꞉sio꞉, “Giyo꞉ ‘Ne soma꞉no꞉’ a꞉la꞉bo꞉ sa꞉la꞉so꞉bo,” a꞉la꞉liki Bida eyo꞉ emo꞉wo꞉ hida꞉gi sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To a꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, Ya꞉suwo꞉ nodola꞉sa꞉ga꞉, enedo꞉ tili wida꞉sen kaluwo꞉ a꞉na ba꞉ba꞉ amio꞉, Bidamo꞉wo꞉ hida꞉gi sio꞉, “Sa꞉da꞉na꞉, ge ni fa꞉s doba꞉da꞉ hamana. Tog nilo꞉wo꞉ gi ka꞉lab. Mo꞉wo꞉ ge Godeya꞉lo꞉ asulab aumbo꞉ mo꞉kudu ha꞉nab. Ko꞉sega ge kaluwa꞉lo꞉ asulab au kudu ha꞉nab,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","A꞉la꞉ta꞉ga꞉ eyo꞉ kaluka꞉isale o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ a꞉na ho꞉le kegenelia꞉ga꞉ towo꞉ a꞉la꞉sio꞉, “Kalu abeyo꞉ ne kudu mia꞉no꞉ asulalega, eyo꞉ enen asulano꞉ ka ta꞉ta꞉sa꞉ga꞉, i malano꞉ ene dia꞉ha꞉naki o꞉li soma꞉no꞉ka꞉ a꞉lakiyo꞉, ne a꞉na kudu ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Mo꞉wo꞉ kaluka꞉isale abeyo꞉ ene mela꞉no꞉wo꞉ halale ta꞉li dofo꞉lalega, ene mela꞉no꞉ a꞉no꞉ sulu ha꞉na꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ ne kudu yakiyo꞉, ene mela꞉no꞉wo꞉ walalega, e mela꞉no꞉leyo꞉ a꞉na dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Gio꞉ kelego꞉ henfelo꞉ wilo꞉ da꞉lab a꞉no꞉ ko꞉lo꞉ tambo asula꞉sa꞉ga꞉ kegenela꞉len amio꞉, mela꞉no꞉ gilo꞉wo꞉ sulu ha꞉nalega, kelego꞉ a꞉ma꞉yo꞉ ge waga asuwa꞉fa꞉iba? ");
INSERT INTO bco_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Kelego꞉ a꞉ma꞉yo꞉ ene mela꞉no꞉ a꞉no꞉ o꞉li kililia꞉iba꞉le? ");
INSERT INTO bco_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kaluka꞉isale ho꞉len wilo꞉ sab we man mogago꞉le dimida꞉lab ko꞉lo꞉, kalu imilise nowo꞉ i o꞉lia꞉ siliki, ni wi sa꞉ma꞉no꞉ o꞉lia꞉ ni to walama꞉no꞉ a꞉no꞉ sendelowa꞉lalega, tif amio꞉ Kalule Dowo꞉ ne o꞉lia꞉ ma꞉mula꞉ kalu malilo꞉ o꞉lia꞉yo꞉, akina a꞉la꞉ta꞉ga꞉ Godeya꞉ ene ho꞉len alan us a꞉na dota꞉ga꞉ yakiyo꞉, niyo꞉lo꞉ e wi sa꞉ma꞉no꞉wo꞉ sendeloma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “To we niyo꞉ hendele sa꞉ma꞉nigo꞉l. Kalu nol wilo꞉ kagafo꞉lab we gio꞉ o꞉semo꞉sowo꞉ o꞉elenka, henfelo꞉ we Godeya꞉ halaido꞉wa꞉lo꞉ bo꞉fo꞉mela꞉ni mia꞉nigab a꞉no꞉, gio꞉ ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ho꞉len do꞉go꞉fela꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, Ya꞉suwa꞉yo꞉ Bidayo꞉, Ya꞉ma꞉so꞉, Yo꞉no꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉, egelese hen misio꞉ alana mesa꞉ni ha꞉na꞉sio꞉. Iyo꞉ ha꞉na꞉sa꞉ga꞉, hen misio꞉ a꞉na siliki bo꞉fo꞉len amio꞉, Ya꞉suwa꞉ ene do꞉mo꞉ dowa꞉seno꞉ mada ko꞉li nodola꞉sa꞉ga꞉ elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ene helebeso꞉g ko꞉lo꞉ a꞉no꞉ tambo ho꞉lo꞉ fa꞉la꞉dowaki, siyo꞉ mada bumalo꞉ elena ba꞉ba꞉. Henfelo꞉ wilo꞉ kalu imilig noma꞉yo꞉ helebeso꞉g halab amio꞉, ho꞉lo꞉ o꞉ngo꞉wo꞉ mada mo꞉fa꞉la꞉dowa꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iyo꞉ a꞉no꞉ ko꞉lo꞉ bo꞉fo꞉len amio꞉, Elaiya o꞉lia꞉ Mo꞉sa꞉s o꞉lia꞉yo꞉ a꞉naka fa꞉la꞉dowa꞉sa꞉ga꞉, Ya꞉su o꞉lia꞉ tola꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bida eyo꞉ a꞉no꞉ ba꞉da꞉ga꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, nio꞉ wilo꞉ dowo꞉wo꞉ mada o꞉li go꞉ ko꞉lo꞉, niliyo꞉ a ha꞉lu otaleno꞉ dia꞉niki. Nowo꞉ gino꞉, nowo꞉ Elaiya eno꞉, nowo꞉ Mo꞉sa꞉s eno꞉.” ");
INSERT INTO bco_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tiliwida꞉sen kalu iliyo꞉ tagio꞉ alan dowo꞉ ko꞉lo꞉, Bida eyo꞉ to weno꞉ ko꞉lo꞉ so꞉lo꞉l a꞉la꞉bo꞉, babale dowaki a꞉na sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","A꞉la꞉ta꞉ga꞉ elen amio꞉ kolo꞉ tinda꞉sa꞉ga꞉, iyo꞉ go꞉lulabikiyo꞉, to nowo꞉ kola꞉ us a꞉na a꞉la꞉ta꞉ga꞉ sa꞉labiki dabu. “We no꞉no꞉ so꞉wale ko꞉lo꞉, niyo꞉ e mada alan asulo꞉l. Gio꞉ to elo꞉ sa꞉lab a꞉no꞉ da꞉da꞉bi” a꞉la꞉sa꞉labiki dabu. ");
INSERT INTO bco_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Wigibole a꞉naka, iliyo꞉ kalu nolo꞉ a꞉namio꞉ aundo꞉malo꞉biki, Ya꞉suwo꞉ ina꞉li elena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Iyo꞉ misio꞉wa a꞉la꞉ta꞉ga꞉ tindakiyo꞉, Ya꞉su eyo꞉ towo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kalule Dowo꞉ ne sowa꞉sa꞉ga꞉ a꞉ma꞉la꞉yo꞉ o꞉semo꞉ dasi a꞉namio꞉, gililo꞉ ba꞉ba꞉ we malola꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iliyo꞉ Ya꞉suwa꞉lo꞉ to sa꞉lab a꞉no꞉, inin asulo꞉ usa dia꞉ta꞉ga꞉, egele nenelo꞉. Sowa꞉sa꞉ga꞉ a꞉ma꞉la꞉do꞉ dasima꞉no꞉ a꞉lab a꞉no꞉ wagama꞉no꞉ ko꞉lo꞉ sa꞉laba꞉le a꞉la꞉liki ha꞉go꞉ kedo꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kedakiyo꞉ iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Elelo꞉ wida꞉sen kalu iliyo꞉ a꞉la꞉wido꞉, ‘Godeya꞉lo꞉ Da꞉feyo꞉ Kalu e semo꞉fa꞉la꞉dowo꞉ amio꞉, Elaiya e ko꞉le tamina mia꞉ib.’ Ililo꞉ a꞉la꞉do꞉ widab a꞉no꞉ mo꞉wo꞉ ha꞉?” ");
INSERT INTO bco_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Hendele, Elaiya e ko꞉le tamina ya꞉sa꞉ga꞉yo꞉, eyo꞉ kelego꞉wo꞉ tambo nafale dimidalia꞉ib. Ko꞉sega Godeya꞉ ene bugo꞉ amilo꞉ to sa꞉sa꞉lo꞉ a꞉no꞉ giliyo꞉ asuluma. To a꞉no꞉ we, ‘Kaluka꞉isale nolba꞉yo꞉ nagalo꞉ halaido꞉wo꞉ Kalule Dowo꞉ nemo꞉ dimiaki a꞉la꞉ta꞉ga꞉ ne gola ba꞉ba꞉ib’ a꞉la꞉sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ko꞉sega niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l, ‘Hendele Elaiya e o꞉ma mio꞉ ko꞉lo꞉, kaluka꞉isale iliyo꞉ inido꞉ asulab aumbo꞉ emo꞉ dimido꞉.’ Tamin amilo꞉ bugo꞉ amilo꞉ sa꞉sa꞉lifa꞉ aumbo꞉, imilo꞉ fa꞉la꞉dowo꞉.” ");
INSERT INTO bco_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iyo꞉ a꞉ma꞉la꞉ ya꞉ga꞉ ba꞉ba꞉ amio꞉, tili wida꞉sen kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu i o꞉lia꞉yo꞉ towa꞉ kega꞉labikiyo꞉, kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ hegea꞉fo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ya꞉suwo꞉ a꞉na fa꞉la꞉dowabikiyo꞉, kaluka꞉isale kegeo꞉ a꞉no꞉ Ya꞉su e ba꞉da꞉ga꞉ iligakiyo꞉, iyo꞉ Ya꞉suwo꞉ ko꞉lo꞉ galima꞉no꞉ a꞉la꞉ta꞉ga꞉ elo꞉wa nai ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gio꞉ towo꞉ o꞉b sa꞉la꞉liki kega꞉leno꞉?” ");
INSERT INTO bco_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","A꞉la꞉dabu ba꞉dabiki kalu kegeo꞉ imilig noma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Wida꞉sen kalu, ni kalu so꞉wayo꞉ mama mogago꞉wo꞉ eya dofo꞉likiyo꞉, towo꞉ mo꞉tolaki do꞉fo꞉f a꞉lab ko꞉lo꞉, e falele alifoma꞉ki tililia꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","So꞉wa a꞉no꞉ mama mogago꞉ dofo꞉likiyo꞉, hena besea꞉liki, mego꞉f amio꞉ mesuba꞉so꞉ ya꞉b, a꞉la꞉ta꞉ga꞉ besa꞉ hageno꞉ giliyaka, so꞉so꞉golaki halaleliabiki go꞉l. Niyo꞉ tililia꞉sa꞉ga꞉, gilo꞉ tiliwida꞉sen kalumo꞉wo꞉ mama mogago꞉ a꞉no꞉ o꞉lusanama꞉ki dabu ba꞉ba꞉ ko꞉sega, iliyo꞉ mo꞉o꞉luga꞉fa꞉no꞉ dowab.” Kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Ha꞉iyo꞉, kaluka꞉isale o꞉g wilo꞉ sab gio꞉ tilidabuwo꞉ aundo꞉ma. Ne gi o꞉lia꞉yo꞉ ho꞉leno꞉ tambowo꞉ mo꞉mela꞉nigo꞉l. Ne gio꞉ asulo꞉wo꞉ nodoma꞉kiyo꞉, ho꞉len o꞉biba꞉s yasilima꞉no꞉wa꞉le? So꞉wa ko nelo꞉ wena tililia꞉ mena.” ");
INSERT INTO bco_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","A꞉la꞉sa꞉labiki iliyo꞉ so꞉wa a꞉no꞉ elo꞉wa tililia꞉mio꞉. Wigibo a꞉naka mama mogago꞉ a꞉ma꞉yo꞉ Ya꞉suwo꞉ ba꞉da꞉sa꞉ga꞉, so꞉wa a꞉no꞉ talulia꞉ga꞉ hena beseakiyo꞉, so꞉so꞉golaki mesuba꞉s o꞉lia꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ya꞉su eyo꞉ so꞉walo꞉ iyamo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “So꞉wa welo꞉ da꞉ba꞉da꞉leno꞉ ho꞉leno꞉ o꞉biba꞉so꞉?” Eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “So꞉wa we ha꞉lula꞉suka a꞉la꞉ta꞉ga꞉ mo꞉mo꞉do꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","E da꞉ba꞉dakiyo꞉, de o꞉lia꞉ ho꞉n o꞉lia꞉ya ti ha꞉na꞉no꞉ a꞉lakiyo꞉, enenoma꞉la꞉ sana soma꞉no꞉ dowa꞉sen ko꞉lo꞉, giyo꞉ o꞉li dimidama꞉no꞉lalega, ne nofolakiyo꞉ mada asuwa꞉foma.” ");
INSERT INTO bco_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Giyo꞉ ‘o꞉li dimidama꞉no꞉lalega’ a꞉la꞉do꞉ sa꞉lab ko mo꞉wo꞉ ha꞉? Kalu abeyo꞉ hendele tilida꞉dab a꞉ma꞉yo꞉ kelego꞉ tambowo꞉ o꞉li ka dimidama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, so꞉walo꞉ iya a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Tilidabu nilo꞉wo꞉ ha꞉lu ko꞉lo꞉lab ko꞉lo꞉, giyo꞉ ni tilidabuwo꞉ halale alifoma!” ");
INSERT INTO bco_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉su eyo꞉ kaluka꞉isale nolo꞉ elo꞉wa kegeabiki ba꞉da꞉sa꞉ga꞉, eyo꞉ mama mogago꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Mama mogago꞉ ka꞉la꞉n o꞉lia꞉ mego꞉f o꞉lia꞉ do꞉fo꞉fdo꞉ dowan ge, so꞉wa ko ta꞉ta꞉ga꞉ hamana. A꞉la꞉ta꞉ga꞉ wa꞉kabiyo꞉ so꞉wa wenamio꞉ a꞉tina꞉so꞉bo!” ");
INSERT INTO bco_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Mama mogago꞉ e halale ganagiliaki, mama mogago꞉wa꞉yo꞉ so꞉wa a꞉no꞉ so꞉so꞉goloma꞉ki ta꞉takiyo꞉, e a꞉na handalota꞉ga꞉ ane. So꞉wa a꞉no꞉ sowo꞉ o꞉ngo꞉ dowabiki, kaluka꞉isale modo꞉wa꞉yo꞉ “So꞉wa we sowaka꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko꞉sega Ya꞉su eyo꞉ so꞉wa a꞉ma꞉ dagiya ta꞉lidota꞉ga꞉ gasiliabiki, so꞉wa a꞉no꞉ e a꞉na dasilia꞉ga꞉ kagayo꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","A꞉la꞉ta꞉ga꞉ Ya꞉su o꞉lia꞉ enedo꞉ tiliwida꞉sen o꞉lia꞉yo꞉ a usa ti ha꞉na꞉ga꞉, iliyo꞉ emo꞉wo꞉ wo꞉no꞉le dabu ba꞉daki a꞉la꞉sio꞉, “Mama mogago꞉ ko꞉lo꞉ nili sio꞉ amilo꞉ mo꞉ane a꞉no꞉ wangabiki go꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Eyo꞉ a꞉la꞉sio꞉, “Mama mogago꞉ o꞉ngo꞉ ko꞉lo꞉ o꞉luma꞉nikiyo꞉, Godemo꞉ dulugu sa꞉laliki a꞉na ha꞉na꞉ib. Giliyo꞉ Godemo꞉wo꞉ mo꞉dulugu sa꞉lalega, mo꞉ha꞉na꞉ib.” Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","A꞉la꞉ta꞉ga꞉yo꞉ iyo꞉ hen ilo꞉ sen a꞉no꞉ ta꞉ta꞉ga꞉, Ga꞉lili hen a꞉no꞉ o꞉go꞉saki ha꞉na꞉sio꞉. Ko꞉sega kaluka꞉isale nolba꞉yo꞉ e a꞉na ha꞉nab a꞉la꞉bo꞉ mo꞉asuluma꞉ki, iyo꞉ us amio꞉ mo꞉kagayaki, tigini ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Mo꞉wo꞉ Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalumo꞉wo꞉ fanda widakiyo꞉ towo꞉ a꞉la꞉sio꞉. “Kalule Dowo꞉ ne, gis kalumo꞉ sana soma꞉ki, kalu noma꞉yo꞉ teledoma꞉ib. Iliyo꞉ ne sana soma꞉ib ko꞉lo꞉, ho꞉len otaleno꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, ne a꞉ma꞉la꞉ dasima꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉ ko꞉sega, iliyo꞉ to elo꞉ sa꞉lab a꞉no꞉ ha꞉go꞉ mo꞉fanda asulo꞉ ko꞉lo꞉, iyo꞉ tagilaki, emo꞉wo꞉ a꞉ma꞉la꞉yo꞉ mo꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A꞉la꞉ta꞉ga꞉ iyo꞉ Kabaniom a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, iyo꞉ a usa siliki eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gio꞉ toga yakilo꞉ to nenelo꞉ a꞉no꞉, giliyo꞉ towo꞉ o꞉b sio꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","A꞉la꞉dabu ba꞉ba꞉ ko꞉sega iyo꞉ toga yakiyo꞉, kalu alandeyo꞉ o꞉ba꞉le a꞉la꞉liki nenela꞉i mio꞉ ko꞉lo꞉, iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉ma꞉la꞉ sa꞉ma꞉no꞉wo꞉ wanadota꞉ga꞉, towo꞉ mo꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ya꞉suwo꞉ asita꞉ga꞉yo꞉, tili wida꞉sen kalu iyo꞉ elo꞉wa mena a꞉la꞉ta꞉ga꞉ eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu ge alande doma꞉no꞉lalega, ge kalu nolba꞉ ha꞉ga dota꞉ga꞉, nol ko꞉le asuwa꞉ta꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Eyo꞉ so꞉wala꞉su nowo꞉ e dagiya gasilia꞉ga꞉, ilo꞉ sab a꞉na ta꞉ulia꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Kalu abeyo꞉ ne wiya a꞉la꞉ta꞉ga꞉yo꞉, so꞉wala꞉su wengo꞉wo꞉ sagala꞉sa꞉ga꞉ tili dowalega, eyo꞉ ne ko꞉lo꞉ tili dowaki auma꞉ib. A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ne ko꞉lo꞉ tili dowalega, eyo꞉ neko꞉ tili dowaba, kalu nelo꞉ iliga꞉fo꞉ a꞉no꞉ ko꞉lo꞉ tili dowaki auma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yo꞉n eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, niliyo꞉ kalu noma꞉yo꞉ gi wiya a꞉la꞉ta꞉ga꞉ mama mogago꞉wo꞉ o꞉luga꞉felabi ba꞉ba꞉ ko꞉lo꞉, ni o꞉lia꞉lo꞉ mo꞉dowa꞉sen a꞉ma꞉ gab ko꞉lo꞉, niliyo꞉ emo꞉wo꞉ dimida꞉so꞉boka꞉ a꞉la꞉liki ele alifa꞉.” ");
INSERT INTO bco_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Elo꞉ dimidab a꞉no꞉ ka꞉la꞉so꞉bo. Kalu abeyo꞉ ni wiya a꞉la꞉ta꞉ga꞉ molo ha꞉na꞉no꞉ dimida꞉lab a꞉no꞉, tif amio꞉ ne wi a꞉no꞉ mo꞉mogagi sa꞉ma꞉no꞉ a꞉la꞉liki gab. A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ kalu a꞉no꞉ ka꞉lakiyo꞉ eleyo꞉ dia꞉ta꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Mo꞉wo꞉ kalu abeyo꞉ ni o꞉lia꞉yo꞉ giso꞉ mo꞉dowab a꞉no꞉ nilino꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","To we niyo꞉ gemo꞉wo꞉ mada hendele sa꞉ma꞉nigo꞉l. Kalu abeyo꞉ ge Kelisowa dowo꞉ a꞉la꞉asula꞉sa꞉ga꞉, ho꞉no꞉ wasulia꞉ga꞉ gemo꞉ maiya꞉ki dimialega, kalu a꞉no꞉ wa꞉l enedo꞉wo꞉ nafale dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ya꞉su eyo꞉ to nowo꞉ a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Kalu abeyo꞉ tilidabu so꞉wala꞉su nowo꞉ mogago꞉ dimidama꞉ki susululalega, Gode eyo꞉ emo꞉wo꞉ halaido꞉ wa꞉dema꞉ib. Kalu a꞉no꞉ tamin amio꞉ u alano꞉ dagasa sunda꞉sa꞉ga꞉, so꞉lu ho꞉na sandifo꞉ kibo꞉bowo꞉, a꞉no꞉ o꞉li domabe. ");
INSERT INTO bco_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Gi dagi koma꞉yo꞉ ko꞉lo꞉ susululia꞉ga꞉, ge mogago꞉wo꞉ dimidalega, dagi a꞉no꞉ gedela꞉bi. Mo꞉wo꞉ ge dagilo꞉ma iliki, ko꞉ngo꞉ mela꞉no꞉ mela꞉no꞉lalega, a꞉no꞉ o꞉li. Ko꞉sega dagiyo꞉ a꞉la꞉ elen amio꞉, mo꞉dalilia꞉no꞉ de hen a꞉na ha꞉nalega, mada halaido꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","A꞉la꞉ta꞉ga꞉ gi gib koma꞉yo꞉ ko꞉lo꞉ susululia꞉ga꞉, ge mogago꞉wo꞉ dimidalega, gib a꞉no꞉ gedela꞉bi. Ge gib nowo꞉ aundo꞉ma iliki, gio꞉ Gode o꞉lia꞉ ko꞉ngo꞉ mela꞉no꞉ doma꞉no꞉lalega, a꞉no꞉ o꞉li. Ko꞉sega gibo꞉ a꞉la꞉ iliki, de hena ha꞉nalega, a꞉no꞉ mada halaido꞉. ");
INSERT INTO bco_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","A꞉la꞉ta꞉ga꞉ gi si koma꞉yo꞉ ko꞉lo꞉ susululia꞉ga꞉, ge mogago꞉wo꞉ dimidalega, si a꞉no꞉ dugula꞉bi. Mo꞉wo꞉ si nowo꞉ ko꞉n iliki, Godeya꞉lo꞉ bo꞉fo꞉lab hen a꞉namio꞉ mesa꞉ ha꞉nalega, a꞉no꞉ o꞉li. Ko꞉sega siyo꞉ a꞉la꞉ elen amio꞉ de hena ha꞉nalega, a꞉no꞉ mada halaido꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","De hen a꞉namio꞉, “ ‘ibiya꞉yo꞉ do꞉mo꞉wo꞉ na꞉lalikiyo꞉ mo꞉soma꞉ib a꞉la꞉ta꞉ga꞉, de wa꞉sowa a꞉no꞉ mo꞉dalima꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tamin amio꞉ kaluka꞉isale iliyo꞉ Godemo꞉ boba so꞉meakiyo꞉, Godeya꞉ siwa꞉l amio꞉ boba a꞉no꞉ digalo꞉ bo꞉ba꞉ki, iliyo꞉ so꞉luwo꞉ bobalo꞉ dimiab a꞉na fifa꞉sen. O꞉leaundo꞉ dimidan aumbo꞉ giliyo꞉ mogago꞉wo꞉ dimidabena꞉kiyo꞉, hida꞉yo꞉wo꞉ deyo꞉ o꞉ngo꞉ ko꞉lo꞉ gilo꞉ amio꞉ fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“So꞉luwo꞉ nafa ko꞉sega, so꞉luwa꞉ nudo꞉wo꞉ aundo꞉ma dowalega, so꞉luwa꞉ nudo꞉ a꞉no꞉ nafa a꞉fa꞉la꞉doma꞉kiyo꞉, niliyo꞉ mo꞉dimidama꞉ib. Ginino꞉ so꞉luwo꞉ o꞉ngo꞉ dofo꞉liki, ha꞉sa dowakiyo꞉ gegelebo꞉ ha꞉fo꞉wo꞉ disa꞉la꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ya꞉suwo꞉ hen elo꞉ elen a꞉no꞉ ta꞉ta꞉ga꞉, Yudia hen a꞉na ha꞉nakiyo꞉, ho꞉n Yodan a꞉no꞉ ta꞉nota꞉ga꞉ a꞉na ane. E a꞉na fa꞉la꞉dowo꞉ amio꞉, kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ elo꞉wa kegeabikiyo꞉, Ya꞉su eyo꞉ enedo꞉ tamin amilo꞉ wida꞉sen aumbo꞉, kaluka꞉isale kegeo꞉ o꞉mo꞉wo꞉ to mano꞉ imo꞉wo꞉ a꞉na wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Fa꞉lisi kalu nolo꞉ ya꞉sa꞉ga꞉, Ya꞉suwo꞉ dikili ba꞉dakiyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ele saefa꞉ a꞉ma꞉yo꞉ kaluwa꞉lo꞉ ga di a꞉no꞉ ta꞉fa꞉no꞉wo꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Mo꞉sa꞉sa꞉ ele sa꞉sa꞉lo꞉ a꞉ma꞉yo꞉ ga di ta꞉fa꞉no꞉ a꞉no꞉ gimo꞉wo꞉ waga sio꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu abeyo꞉ ga di a꞉no꞉ ta꞉fa꞉nikiyo꞉, mo꞉fo꞉s sa꞉sa꞉lo꞉ amio꞉ gayo꞉ ta꞉to꞉ka꞉ a꞉la꞉ ko꞉le sa꞉sa꞉la꞉sa꞉ga꞉yo꞉, o꞉lika ta꞉ta꞉bi a꞉la꞉liki, Mo꞉sa꞉s eyo꞉ a꞉na saefa꞉.” ");
INSERT INTO bco_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ko꞉sega Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Isolael kalu, gio꞉ a꞉la꞉iyabiki, Mo꞉sa꞉s eyo꞉ ele a꞉no꞉ a꞉na sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko꞉sega Gode eyo꞉ tamin amio꞉ henfelo꞉ welo꞉ dimido꞉ amio꞉, ‘eyo꞉ kalu o꞉lia꞉ ga o꞉lia꞉ a꞉no꞉ dimida꞉sa꞉ga꞉ ta꞉fo꞉.’ ");
INSERT INTO bco_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","‘A꞉la꞉go꞉ko꞉lo꞉ kaluwa꞉yo꞉ iya o꞉lia꞉ ano o꞉lia꞉yo꞉ ta꞉ta꞉ga꞉, ene inga o꞉lia꞉ asulo꞉wo꞉ imilise dowaki, a꞉la꞉yo꞉ do꞉mo꞉ imilise doma꞉ib.’ A꞉la꞉ a꞉no꞉ nowo꞉ ko꞉li nowo꞉lo꞉ ko꞉li a꞉la꞉ elen, ko꞉sega o꞉go꞉ a꞉la꞉yo꞉ mada imilise doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","A꞉la꞉fo꞉ko꞉lo꞉ a꞉la꞉ a꞉no꞉ Gode eyo꞉ ida꞉ni kudu alifa꞉ ko꞉lo꞉, kaluwa꞉yo꞉ a꞉la꞉ a꞉no꞉ mada gedea꞉so꞉bo!” Ya꞉suwa꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ ha꞉na꞉sa꞉ga꞉, a usa tina꞉sa꞉ga꞉ siliki, to a꞉no꞉ Ya꞉sumo꞉wo꞉ wa꞉ka dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu abeyo꞉ ga enedo꞉wo꞉ ta꞉ta꞉sa꞉ga꞉lo꞉ ga nowo꞉ a꞉diab a꞉no꞉, e uwo꞉ dia꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","A꞉la꞉ta꞉ga꞉ ga abeyo꞉ ino꞉ ta꞉ta꞉ga꞉, kalu nowa ha꞉nalega, ga a꞉ma꞉yo꞉lo꞉ uwo꞉ dia꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Kaluka꞉isale iliyo꞉ so꞉wagalino꞉ Ya꞉sumo꞉ goloma꞉ki, elo꞉wa tililia꞉ ya꞉sio꞉. Ko꞉sega enedo꞉ tili wida꞉sen kaluwa꞉yo꞉ so꞉wagalino꞉ Ya꞉sulo꞉ amio꞉ tililia꞉ ya꞉so꞉boka꞉ a꞉la꞉liki halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ililo꞉ dimidab a꞉no꞉ Ya꞉su eyo꞉ ba꞉da꞉sa꞉ga꞉, e mo꞉sagalabiki imo꞉wo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉no꞉ so꞉wa i we o꞉ngo꞉ma꞉no꞉ da꞉lab ko꞉lo꞉, giliyo꞉ so꞉wa i we nelo꞉ amio꞉ mena꞉ki ka꞉la꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","To we niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Kaluka꞉isale abeyo꞉ so꞉wagalin we o꞉ngo꞉ma꞉lo꞉ Godeya꞉ ha꞉g amilo꞉ dowab o꞉leaumbo꞉ mo꞉dowalega, iyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ us a꞉namio꞉ mada mo꞉tina꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","To a꞉no꞉ imo꞉wo꞉ sa꞉la꞉sa꞉ga꞉, so꞉wagalin i a꞉no꞉ ta꞉ulia꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉ dagiyo꞉ so꞉wagalina golaki, iyo꞉ nafale mesea꞉ki dulugu salifelo꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ya꞉suwo꞉ ha꞉na꞉no꞉ dowa꞉sena, kalu nowo꞉ nai ya꞉sa꞉ga꞉, elo꞉wa gulalu misa꞉fu alilakiyo꞉ a꞉la꞉sio꞉, “Widan kalu nafaleyo꞉ ge, nilo꞉ mela꞉no꞉ mela꞉no꞉ dia꞉no꞉ a꞉no꞉ waga dimidaliki dia꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ nemo꞉lo꞉ ‘Ge nafaleka꞉’ a꞉la꞉do꞉ sa꞉lab ko mo꞉wo꞉ ha꞉? Gode imilise e mada nafale ko꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Godeya꞉ ele difa꞉ da꞉lab a꞉no꞉ ge asulo꞉. Kaluwo꞉ sana sowa꞉so꞉bo. Uwo꞉wo꞉ dia꞉so꞉bo. Afayo꞉ dia꞉so꞉bo. Diga꞉li sa꞉la꞉so꞉bo. Kalu noma꞉ kelego꞉wo꞉ dia꞉nikiyo꞉ dikida꞉so꞉bo. Gio꞉ go꞉lo꞉ go꞉wo꞉ alano꞉ o꞉m a꞉la꞉asulaki, ili ha꞉ga dowa꞉lubi.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Widan kalu, gilo꞉ to sa꞉lab ko ne so꞉walo꞉ elen a꞉na a꞉la꞉ta꞉ga꞉yo꞉ kudu mio꞉ ko꞉m.” ");
INSERT INTO bco_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ e si kudu ba꞉da꞉sa꞉ga꞉, e mada alan asulakiyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Gilo꞉ mo꞉dimido꞉ nowo꞉ o꞉a꞉lab. Kelego꞉ gilo꞉ da꞉lab a꞉no꞉ kililia꞉sa꞉ga꞉, mole a꞉no꞉ kelego꞉lo꞉ma dowab kalu i o꞉mo꞉ sa꞉ga꞉bi. A꞉la꞉galega, Hebene a꞉namilo꞉ kelego꞉ nafale sagalema꞉no꞉ da꞉lab a꞉no꞉ ge dia꞉ib. A꞉la꞉dimida꞉sa꞉ga꞉yo꞉, ge ne a꞉na kudu ya꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","To a꞉no꞉ da꞉da꞉sa꞉ga꞉, kalu a꞉ma꞉ wo꞉lokano꞉ hesega꞉fo꞉. Mo꞉wo꞉ e kelego꞉wo꞉ mada modo꞉ delen ko꞉lo꞉ sa꞉labiki, e a꞉ma꞉la꞉ ha꞉nakiyo꞉ asulo꞉wo꞉ hida꞉liabiki ane. ");
INSERT INTO bco_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ya꞉su eyo꞉ sigiliga꞉ta꞉ga꞉, enedo꞉ tili wida꞉sen kalu imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu kelego꞉wo꞉ modo꞉lo꞉ da꞉lab a꞉no꞉, e Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉na tina꞉no꞉wo꞉ mada halaido꞉ ko꞉lo꞉ a꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Tili wida꞉sen kalu iyo꞉ Ya꞉suwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉ iligabiki, eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉ so꞉wagalin, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉namilo꞉ tina꞉no꞉wo꞉ mada halaido꞉ ko꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","No꞉ alan nowo꞉ ene wiyo꞉ ka꞉mol ko꞉lo꞉, e helebeso꞉gdo꞉ dubian ho꞉la꞉su a꞉nami tina꞉no꞉wo꞉ halaido꞉. Ko꞉sega kalu kelego꞉wo꞉ modo꞉lo꞉ da꞉lab a꞉no꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉na tina꞉no꞉wo꞉, mada halaido꞉le doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Enedo꞉ tili wida꞉sen kalu iliyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, mada iliga꞉sa꞉ga꞉ modaki, egelebo꞉ a꞉la꞉nenelo꞉, “A꞉la꞉go꞉lo꞉biki mela꞉no꞉ mela꞉no꞉ a꞉no꞉ kaluka꞉isale abe dia꞉nigaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ya꞉su eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉, iyo꞉ sigiliga꞉ta꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Kaluwa꞉ ene halaido꞉wa꞉ dimidama꞉no꞉wo꞉ mada mo꞉ililo꞉ ko꞉sega, Gode eyo꞉ kelego꞉wo꞉ tambowo꞉ o꞉li ka dimidan ko꞉lo꞉, eyo꞉ o꞉li dimidama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","A꞉la꞉ta꞉ga꞉ Bida eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Asuluma! Nio꞉ ninin kelego꞉wo꞉ tambo ka ta꞉ta꞉sa꞉ga꞉, ge ko꞉lo꞉ kudu yo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ to hendele so꞉lo꞉l. Kalu abeyo꞉ ne asula꞉sa꞉ga꞉ ni towo꞉ ko꞉lo꞉ walama꞉ni ha꞉nakiyo꞉, kelego꞉ elo꞉wo꞉ tambo ka ta꞉ta꞉ga꞉ ha꞉nalega, tif amio꞉ kalu a꞉ma꞉yo꞉ mada kelego꞉wo꞉ modo꞉le dia꞉ib. Kalu a꞉no꞉ ne wiya a꞉la꞉ta꞉ga꞉yo꞉ hida꞉yo꞉wo꞉ dia꞉li mesa꞉ib. A꞉la꞉ta꞉ga꞉ amisa꞉no꞉, aowo꞉, adowo꞉, anowo꞉, iyayo꞉, so꞉wayo꞉, hen enedo꞉wo꞉, kelego꞉ o꞉ngo꞉wo꞉ kata꞉ta꞉ga꞉ ha꞉nalega, elo꞉ henfelo꞉ wilo꞉ kelego꞉ ta꞉tab aumbo꞉ a꞉ma꞉la꞉yo꞉ mada modo꞉ a꞉dia꞉ib. A꞉la꞉ta꞉ga꞉ tif amio꞉, e mela꞉no꞉ mela꞉no꞉wo꞉ dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Kaluka꞉isale o꞉gdo꞉ tamin amilo꞉ a꞉lab a꞉no꞉ tifa doma꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isale o꞉gdo꞉ tif amilo꞉ elen a꞉no꞉, tamina a꞉doma꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ya꞉suwa꞉ tamita꞉ga꞉, iyo꞉ Ya꞉lusalem toga ha꞉nakiyo꞉, enedo꞉ tiliwida꞉sen kaluwo꞉ molo asula꞉li ha꞉nabiki, kaluka꞉isale nol kudu mio꞉ a꞉ma꞉yo꞉ tagila꞉li ya꞉sio꞉. Ya꞉su eyo꞉ tili wida꞉sen kalu kugula꞉fo꞉ a꞉no꞉ ha꞉la꞉ doba꞉da꞉ tililia꞉ga꞉ kagayakiyo꞉, kelego꞉ e amilo꞉ fa꞉la꞉doma꞉nigab a꞉no꞉ imo꞉wo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","“O꞉go꞉ nio꞉ Ya꞉lusalem halona ho꞉no꞉l ko꞉lo꞉, kalu noma꞉yo꞉ Kalule Dowo꞉wo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉, elelo꞉ wida꞉sen kalu i o꞉lia꞉mo꞉wo꞉ gasimea꞉ib. A꞉la꞉ta꞉ga꞉ iliyo꞉ e mo꞉walila꞉sa꞉ga꞉yo꞉, sana soma꞉no꞉ a꞉la꞉liki towo꞉ saefa꞉ib. Iliyo꞉ e ha꞉la꞉ kalumo꞉wo꞉ gasimealikiyo꞉, kalu i a꞉ma꞉yo꞉ e dio꞉ge sa꞉laki, mekowaya꞉ fugala꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ iliyo꞉ meya꞉ yame tandea꞉sa꞉ga꞉ sana soma꞉ib. Ko꞉sega ho꞉len asol dowalikiyo꞉, e a꞉ma꞉la꞉ a꞉dasi alifa꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sa꞉ba꞉diya꞉ inso꞉, Ya꞉ma꞉so꞉ o꞉lia꞉ Yo꞉no꞉ o꞉lia꞉yo꞉ Ya꞉sulo꞉wa ya꞉ga꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “Widan Kalu ge, nililo꞉ gemo꞉lo꞉ dabu ba꞉dab aumbo꞉, giyo꞉ mada dimidama꞉ki asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Niyo꞉ ga꞉gbo꞉wo꞉ o꞉b dimidama꞉ki asulaya?” Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","A꞉la꞉ma꞉yo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Ge ho꞉ alan o꞉lia꞉ tinda꞉sa꞉ga꞉lo꞉ tambolo꞉ bo꞉fo꞉mela꞉no꞉ a꞉namio꞉, na꞉n we nowo꞉ ililib doba꞉da꞉, nowo꞉ fo꞉fo꞉doloba꞉da꞉ siliki, ua bo꞉fo꞉mela꞉no꞉ asulab.” ");
INSERT INTO bco_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉sio꞉, “To gaindo꞉ nemo꞉lo꞉ dabu ba꞉dab ko, ga꞉go꞉ mo꞉wo꞉ mo꞉dinafa fanda asulab. Nilo꞉ hida꞉yo꞉ dia꞉no꞉wo꞉, ga꞉go꞉lo꞉ o꞉li dia꞉nigaba꞉le? A꞉la꞉ta꞉ga꞉ ne soma꞉no꞉ aumbo꞉, ga꞉go꞉lo꞉ o꞉li soma꞉iba?” ");
INSERT INTO bco_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","A꞉la꞉ma꞉yo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Gilo꞉ sa꞉labko, naino꞉ o꞉li dimidama꞉no꞉.” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Hida꞉yo꞉ nilo꞉ dia꞉no꞉wo꞉, ga꞉go꞉lo꞉ dia꞉ib, a꞉la꞉ta꞉ga꞉ ne soma꞉no꞉ aumbo꞉, ga꞉go꞉lo꞉ soma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko꞉sega ga꞉go꞉ dagiyo꞉ ililib o꞉lia꞉ fo꞉fo꞉dolo꞉b a꞉namilo꞉ mesa꞉no꞉wo꞉, niyo꞉ ga꞉gbo꞉wo꞉ o꞉lika꞉ a꞉la꞉bo꞉ mo꞉sa꞉ma꞉no꞉. Mo꞉wo꞉ a꞉namilo꞉ mesa꞉no꞉ a꞉no꞉, kalu Godeya꞉ eno꞉le a꞉la꞉ta꞉ga꞉lo꞉ dimidaefa꞉ a꞉ma꞉ mesa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tili wida꞉sen kalu do꞉la꞉fo꞉ nol a꞉ma꞉yo꞉ to sio꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, Ya꞉ma꞉s o꞉lia꞉ Yo꞉n o꞉lia꞉mo꞉wo꞉ mo꞉bea꞉sa꞉ga꞉ gadio꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","A꞉la꞉gabiki Ya꞉su eyo꞉ i a꞉no꞉ tambo elo꞉wa mena꞉ki ho꞉lelia꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Yu kaluma us a꞉namio꞉ misa꞉ kalu alan iliyo꞉ kaluka꞉isaleyo꞉ dibodaki wa꞉la꞉ sa꞉nda꞉sen. A꞉la꞉ta꞉ga꞉ kalu alan ililo꞉ma꞉yo꞉ mada halaido꞉ bo꞉fo꞉lowan. Gio꞉ a꞉no꞉ o꞉ma fanda ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","A꞉la꞉gab ko꞉sega gi usamio꞉ man wengo꞉wo꞉ mada dowa꞉so꞉bo. Kalu abeyo꞉ e gi usamio꞉ kalu alan doma꞉no꞉ asulalikiyo꞉, e gili madali nanog dian kalu ko꞉le dowa꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ e wabulun kalu doma꞉no꞉ asulalega, e madali nanog dian kalu ko꞉le doma. ");
INSERT INTO bco_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Mo꞉wo꞉ Kalule Dowo꞉ nelo꞉ mio꞉ we, kaluwa꞉yo꞉ ne ko꞉lo꞉ asuwa꞉foma꞉ki mio꞉ma, ko꞉sega niyo꞉ kaluka꞉isaleyo꞉ asuwa꞉fa꞉ni mio꞉ ko꞉lo꞉, niyo꞉ ili mogago꞉wa꞉ wa꞉l diaki, ni mela꞉no꞉ a꞉no꞉ wala꞉ma꞉niki mio꞉.” ");
INSERT INTO bco_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Iyo꞉ Ya꞉liko a꞉na ane ko꞉lo꞉, Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉ a꞉la꞉ta꞉ga꞉ kaluka꞉isale elo꞉ kudu mio꞉ a꞉no꞉lia꞉yo꞉ Ya꞉liko amisa꞉no꞉ ta꞉ta꞉ga꞉ ha꞉nab amio꞉, Ya꞉liko tog anib a꞉namio꞉ siyo꞉ ko꞉n kalu nowo꞉, Timiasa꞉ inso꞉ Batimias, e moleyo꞉ elo꞉ mena꞉ki a꞉na siliki ha꞉iya꞉len. ");
INSERT INTO bco_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nasala꞉t kalu, Ya꞉suwo꞉ a꞉namilo꞉ yab a꞉no꞉ e da꞉da꞉sa꞉ga꞉, Batimias eyo꞉ towo꞉ ho꞉idaki a꞉la꞉sio꞉, “Ya꞉su, Da꞉ibida꞉ inso꞉, giyo꞉ ne mada nofola꞉sa꞉ga꞉ asuwa꞉foma!” ");
INSERT INTO bco_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kalu nolba꞉yo꞉ siyo꞉ ko꞉n kalu a꞉no꞉ halalelakiyo꞉ a꞉la꞉sio꞉, “Ge tola꞉so꞉bo!” A꞉la꞉sio꞉ ko꞉sega, kalu a꞉ma꞉yo꞉ towo꞉ halale ho꞉ida꞉liki a꞉la꞉sio꞉, “Da꞉ibida꞉ so꞉wa, giyo꞉ ne mada nofola꞉sa꞉ga꞉ asuwa꞉foma!” ");
INSERT INTO bco_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ya꞉suwo꞉ ha꞉na꞉leno꞉ a꞉na kagatakiyo꞉ a꞉la꞉sio꞉, “Kalu a꞉no꞉ wena mena꞉ki ho꞉lema.” A꞉la꞉gabiki kalu nolba꞉yo꞉ siyo꞉ ko꞉n a꞉no꞉ mena꞉ki ho꞉idaki a꞉la꞉sio꞉, “Ge kele asula꞉so꞉bo. Ya꞉su eyo꞉ ge elo꞉wa mena꞉ki sio꞉ ko꞉lo꞉, ge dasima.” ");
INSERT INTO bco_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Siyo꞉ ko꞉n a꞉ma꞉yo꞉ da꞉da꞉sa꞉ga꞉yo꞉, so꞉g wa꞉l amilo꞉ sa꞉ga꞉lo꞉ a꞉no꞉ hagola꞉sa꞉ga꞉, ho꞉lu yabalakiyo꞉ Ya꞉sulo꞉wa ane. ");
INSERT INTO bco_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gemo꞉wo꞉ waga dimidama꞉ki asulaya?” A꞉la꞉dabu ba꞉dabiki, siyo꞉ ko꞉n kalu a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Widan Kalu, ne siyo꞉ fage alifoma꞉ki asulab.” ");
INSERT INTO bco_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Go꞉no꞉ndo꞉ tilidabu koma꞉yo꞉ ge falelab ko꞉lo꞉ ge mada ga꞉li ha꞉na꞉bi.” Ya꞉su eyo꞉ a꞉la꞉sa꞉labiki, wigibole a꞉naka ene siyo꞉ falela꞉sa꞉ga꞉, e tog a꞉na ha꞉naki Ya꞉su kudu ane. ");
INSERT INTO bco_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ Ya꞉lusalem a꞉na fa꞉la꞉doma꞉no꞉ ha꞉nakiyo꞉, O꞉lif misio꞉lo꞉ a꞉lab anib a꞉namilo꞉ Ba꞉tani o꞉lia꞉ Befage o꞉lia꞉ amisa꞉n a꞉la꞉ a꞉na fa꞉la꞉dowo꞉. E a꞉na fa꞉la꞉dowakiyo꞉, enedo꞉ tili wida꞉sen kalu a꞉la꞉ nowo꞉ tamina hamana꞉ki iliga꞉fa꞉nikiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ga꞉go꞉ tamina ha꞉na꞉sa꞉ga꞉, amisa꞉n ga꞉gdo꞉ ha꞉na꞉no꞉ doba꞉da꞉ a꞉na ti ha꞉nakiyo꞉, donki kalofo nowo꞉, kaluwo꞉ wa꞉l a꞉namilo꞉ o꞉semo꞉ sa꞉sen a꞉no꞉ a꞉na galo alifo꞉lena ba꞉ba꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ ga꞉go꞉ donki a꞉no꞉ fagela꞉sa꞉ga꞉, tililia꞉ ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Kalu nolba꞉yo꞉ ‘Ga꞉go꞉ donki kalofo ko wagama꞉ni fagelaya?’ a꞉la꞉sa꞉lalega, gaino꞉ ‘Kalu alana꞉yo꞉ nanog dia꞉no꞉wo꞉ dowabiki tililia꞉ ho꞉no꞉l ko꞉lo꞉, a꞉ma꞉la꞉yo꞉ bo꞉bo꞉ge tililia꞉ mia꞉no꞉ka꞉’ a꞉la꞉sa꞉la꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","A꞉la꞉fo꞉ko꞉lo꞉ a꞉la꞉yo꞉ a꞉naka tigini ha꞉na꞉sa꞉ga꞉ ba꞉ba꞉ amio꞉, donki kalofowo꞉ aiko꞉wa galolo꞉ alifa꞉ ko꞉lo꞉, tog aniba kagafo꞉lena ba꞉ba꞉. Donki galolo꞉ a꞉no꞉ fagelabikiyo꞉, kalu nol kagafo꞉len a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉, donki ko꞉lo꞉ galolo꞉ ko o꞉b dia꞉ni fagelaya?” ");
INSERT INTO bco_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","A꞉la꞉dabu ba꞉dabiki, a꞉la꞉ma꞉yo꞉ Ya꞉suwa꞉lo꞉ sio꞉ aumbo꞉ imo꞉wo꞉ a꞉ma꞉la꞉ sa꞉labiki, a꞉la꞉mo꞉ ka fagelia꞉ hamana꞉ki, towo꞉ a꞉ma꞉la꞉bo꞉ mo꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","A꞉la꞉ma꞉yo꞉ donki kalofo a꞉no꞉ Ya꞉sulo꞉wa tililia꞉ ya꞉sa꞉ga꞉, so꞉g wa꞉l amilo꞉ sa꞉ga꞉lan a꞉no꞉ donki fa꞉sa꞉ wa꞉la fele alitabiki, Ya꞉su e a꞉na asita꞉ga꞉ ane. ");
INSERT INTO bco_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kalu modo꞉wa꞉yo꞉ ini so꞉g wa꞉l amilo꞉ sa꞉ga꞉lan a꞉no꞉ elo꞉ yab tog a꞉na fela꞉li ha꞉nabiki, nolba꞉yo꞉ fasi fo꞉s ko꞉lo꞉ gegedo꞉ a꞉no꞉ ko꞉lo꞉ fela꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","A꞉la꞉ga꞉li yabikiyo꞉, kaluka꞉isale nolo꞉ tamina ha꞉naki a꞉la꞉ta꞉ga꞉ nolo꞉ tifa yakiyo꞉, iyo꞉ sagalaki gisalo꞉wo꞉ mo꞉la꞉i ane. “Godeya꞉ wiyo꞉ wabuluma꞉niki. Kalu we, Gode Alana꞉ wiya a꞉la꞉ta꞉ga꞉ mio꞉ ko꞉lo꞉, niliyo꞉ sagala꞉liki, Godemo꞉ mada o꞉m a꞉la꞉so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ni ma꞉muwo꞉ Da꞉ibid elo꞉ bo꞉fo꞉lowan aumbo꞉, kalu wema꞉ bo꞉fo꞉mela꞉ni yab ko꞉lo꞉, Godeyo꞉ e mada nafaleyo꞉ e. Gode iwalulo꞉ sab a꞉no꞉ ko꞉lo꞉ wabuluma꞉niki.” ");
INSERT INTO bco_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ya꞉su e Ya꞉lusalem fa꞉la꞉dota꞉ga꞉yo꞉, e Godeya꞉ Malilo꞉ aya tiane. A꞉na tina꞉sa꞉ga꞉, a usa sia꞉liki, kelego꞉ tambo a꞉namilo꞉ da꞉lab a꞉no꞉ bebea꞉len. Ko꞉sega ga꞉lo dowabiki, iyo꞉ a꞉ma꞉la꞉ Ba꞉tani ane. ");
INSERT INTO bco_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ba꞉tani alita꞉ga꞉, kea꞉fo a꞉ma꞉la꞉ ha꞉nakiyo꞉, Ya꞉suwo꞉ maiyo꞉wo꞉ a꞉na dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","E a꞉na ha꞉nakiyo꞉, alona꞉ i fo꞉so꞉ nafale ko꞉lo꞉ ko꞉na꞉ a꞉labiki ba꞉da꞉ga꞉, alon a꞉namio꞉ fowo꞉ hedo꞉wa꞉le a꞉la꞉li mo꞉wa ba꞉ba꞉ni ane. E i mo꞉ a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉ ba꞉ba꞉ amio꞉, fowo꞉ mo꞉hedaki, i fo꞉sde elena ba꞉ba꞉, mo꞉wo꞉ ho꞉len a꞉no꞉ i folo꞉ hedan gima ko꞉lo꞉ fo꞉s moso ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","I a꞉no꞉ fowo꞉ mo꞉hedo꞉ ko꞉lo꞉, eyo꞉ i o꞉mo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Ge fowo꞉ wa꞉kabiyo꞉ mada mo꞉helema꞉ib.” Ya꞉su eyo꞉ towo꞉ a꞉la꞉sa꞉labikiyo꞉, enedo꞉ tili wida꞉sen kalu mio꞉ a꞉no꞉ tambo dabu. ");
INSERT INTO bco_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Iyo꞉ Ya꞉lusalem a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉yo꞉, Ya꞉su e Godeya꞉ Malilo꞉ a isagena ti ha꞉na꞉ga꞉yo꞉, kaluka꞉isaleyo꞉ no꞉ Godemo꞉lo꞉ boba dimia꞉no꞉ a꞉no꞉ kililia꞉liki a꞉la꞉ta꞉ga꞉, mole ililo꞉ hen nowa a꞉la꞉ta꞉ga꞉lo꞉ dia꞉mio꞉ a꞉no꞉ ho꞉gi a꞉dia꞉li sena ba꞉ba꞉. Ya꞉su eyo꞉ kaluka꞉isale malilo꞉ ayamilo꞉ kelego꞉lo꞉ kililia꞉likilo꞉ sen a꞉no꞉ tambo ha꞉la꞉ya o꞉lusanaga꞉ta꞉ga꞉, molelo꞉ delen i fofodo꞉ a꞉no꞉lia꞉, o꞉ba꞉lo꞉ kililia꞉likilo꞉ kalulo꞉ ta꞉sen i fofodo꞉ a꞉no꞉lia꞉yo꞉ kolodolia꞉ga꞉ sandifo꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ Godeya꞉ alilo꞉ a isagen amio꞉ kaluka꞉isaleyo꞉ kelego꞉ kililia꞉nikiyo꞉, wenamio꞉ tinia꞉so꞉boka꞉ a꞉la꞉liki halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ya꞉su eyo꞉ a꞉la꞉dimida꞉sa꞉ga꞉, imo꞉wo꞉ a꞉na wido꞉, “Tamin amio꞉ Godeya꞉ bugo꞉ amio꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Ni a we henfelo꞉ kaluka꞉isale tambowa꞉ nemo꞉lo꞉ dulugu sa꞉la꞉mela꞉no꞉ a doma꞉ib. Ko꞉sega giliyo꞉ a we afalo꞉ dian kaluwa꞉ a o꞉ngo꞉ dimidakigab.’” ");
INSERT INTO bco_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ya꞉suwa꞉lo꞉ to wido꞉ a꞉no꞉ kaluka꞉isale kegeo꞉ iliyo꞉ molo dabu ko꞉lo꞉, Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ elelo꞉ wida꞉sen kalu i o꞉lia꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ kele asulaki mo꞉beo꞉. A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, iliyo꞉ Ya꞉su e sana soma꞉no꞉ a꞉la꞉liki togo꞉ kedo꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ga꞉lo dowabiki, Ya꞉su o꞉lia꞉ enedo꞉ tili wida꞉sen kalu o꞉lia꞉yo꞉ amisa꞉n a꞉no꞉ ta꞉ta꞉ga꞉, ha꞉la꞉ya a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Iyo꞉ kea꞉fo nulu tog a꞉na a꞉ma꞉la꞉ yakiyo꞉, alona꞉ i a꞉no꞉ duna a꞉la꞉ta꞉ga꞉ tefa꞉ mo꞉ a꞉no꞉ tambo o꞉lalia ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bidayo꞉ Ya꞉suwa꞉lo꞉ to sio꞉wo꞉ asulufo꞉len ko꞉lo꞉, alona꞉ i olali a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, aliyo꞉ giyo꞉ alona꞉ imo꞉lo꞉ fowo꞉ mo꞉helema꞉ib a꞉la꞉do꞉ sa꞉lalo꞉, o꞉go꞉ alona꞉ iyo꞉ olali a꞉no꞉ ge bo꞉ba.” ");
INSERT INTO bco_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ge Godeyo꞉ mada tili da꞉da꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Niyo꞉ gemo꞉wo꞉ hendele so꞉lo꞉l. Kaluka꞉isale abeyo꞉ asulo꞉ a꞉la꞉lo꞉ mo꞉iliki, elo꞉ Godemo꞉lo꞉ to sio꞉ a꞉no꞉ hendele fa꞉la꞉doma꞉ib a꞉la꞉tili asulakiyo꞉ Godemo꞉ dulugu sa꞉lalega, to elo꞉ sio꞉ a꞉no꞉ ka hendele fa꞉la꞉doma꞉ib. Kalu o꞉ngo꞉ma꞉yo꞉ hen misio꞉mo꞉ sa꞉laki, ‘Ge go꞉no꞉na꞉ma꞉la꞉yo꞉ duda꞉sa꞉ga꞉, so꞉lu ho꞉na ti hamana’ a꞉la꞉sa꞉lalega, a꞉no꞉ hendele fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","A꞉la꞉fo꞉ko꞉lo꞉ ge hendele tilidabu iliki, Godemo꞉wo꞉ kelego꞉ imilise nowo꞉ dimidama꞉ki dabu ba꞉dalega, Gode eyo꞉ mada hendele gilo꞉ sa꞉lab a꞉no꞉ dimidama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","A꞉la꞉ta꞉ga꞉ ge kagafo꞉liki, Godemo꞉ dulugu sa꞉lakiyo꞉, Go꞉l Hebenelo꞉ sab haloma꞉yo꞉lo꞉ gi mogago꞉wo꞉ hala꞉sa꞉ga꞉ ga꞉lila꞉ma꞉ki, giyo꞉ kalu nolba꞉lo꞉ mogago꞉ gemo꞉lo꞉ dimido꞉ a꞉no꞉ asulufo꞉la꞉lalega, giyo꞉ a꞉no꞉ko꞉le ga꞉lila꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Iyo꞉ ya꞉sa꞉ga꞉ Ya꞉lusalem a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉yo꞉, Ya꞉su e Godeya꞉ Malilo꞉ a isagena sia꞉labikiyo꞉, Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kaluwo꞉lo꞉, elelo꞉ wida꞉sen kaluwo꞉lo꞉, a꞉la꞉ta꞉ga꞉ Yu misa꞉ kalu i o꞉lia꞉yo꞉ Ya꞉sulo꞉wa mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Iyo꞉ a꞉na ya꞉sa꞉ga꞉yo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Nanog gilo꞉ diab we, abe wiya iliki dimidaya? Ge abe iliga꞉tabi dimidaya?” a꞉la꞉liki iliyo꞉ dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gimo꞉wo꞉ to nowo꞉ dabu ba꞉ba꞉nigo꞉l. Giliyo꞉ nilo꞉ gimo꞉lo꞉ sa꞉ma꞉nigo꞉l we ko꞉lo꞉ a꞉ma꞉la꞉bo꞉ sa꞉lalega, niyo꞉ nanog dimido꞉l we, kalu wema꞉ iliga꞉tabi dio꞉ka꞉ a꞉la꞉bo꞉, gimo꞉wo꞉ a꞉na sa꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Yo꞉na꞉lo꞉ ho꞉n amilo꞉ to꞉lola꞉len man a꞉no꞉, eyo꞉ o꞉ba a꞉la꞉ta꞉ga꞉ diya꞉le? A꞉no꞉ Hebene a꞉la꞉ta꞉ga꞉ mio꞉wa꞉le, mo꞉ kaluwa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉wa꞉le? Giliyo꞉ nemo꞉wo꞉ a꞉ma꞉la꞉ sama.” ");
INSERT INTO bco_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ya꞉su eyo꞉ a꞉la꞉sa꞉labiki, iliyo꞉ a꞉ma꞉la꞉bo꞉ waga sa꞉ma꞉no꞉wa꞉le a꞉la꞉liki egele nenelakiyo꞉ a꞉la꞉sio꞉. “Niliyo꞉ ‘Man a꞉no꞉ Hebene a꞉la꞉ta꞉ga꞉ mio꞉’ a꞉la꞉sa꞉lalega, Ya꞉suwa꞉yo꞉ nimo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉ib, ‘Gio꞉ e amio꞉ waga mo꞉tili dabuwo꞉?’ a꞉la꞉sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ko꞉sega kaluka꞉isale tambowa꞉yo꞉ Yo꞉n e dinali sa꞉lan kalu a꞉la꞉bo꞉ asulufo꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉, ‘Man a꞉no꞉ kaluwa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉’ a꞉la꞉bo꞉ sa꞉lalega, kaluka꞉isaleyo꞉ gadima꞉ib ko꞉lo꞉, nio꞉ a꞉la꞉sa꞉ma꞉no꞉wo꞉ tagilab.” ");
INSERT INTO bco_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ babalab.” A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ a꞉ma꞉la꞉bo꞉ nemo꞉wo꞉ mo꞉sa꞉lab ko꞉lo꞉, niyo꞉lo꞉ nanog nilo꞉ dio꞉l we, wema꞉ wiya iliki dimido꞉l a꞉la꞉bo꞉ gimo꞉wo꞉ mo꞉sa꞉ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ya꞉su eyo꞉ Yu misa꞉ kalumo꞉wo꞉ to nowo꞉ bale malolo꞉. “Hendo꞉ biso꞉ kalu noma꞉yo꞉ waina꞉ fowo꞉ gela꞉sa꞉ga꞉, ilifo꞉ tololia꞉ difa꞉. Egelo꞉ us a꞉namio꞉, eyo꞉ waina꞉ folo꞉ basima꞉no꞉ ho꞉wo꞉ daida꞉sa꞉ga꞉yo꞉, wain egelo꞉ o꞉lo꞉ bo꞉fo꞉likilo꞉ mesa꞉no꞉wo꞉ ayo꞉ iwalu dialifa꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ egelo꞉ a꞉no꞉ nanogdo꞉ dia꞉no꞉ kalu nolba꞉ dagiya dia꞉ta꞉sa꞉ga꞉, hendo꞉ biso꞉ kalu a꞉no꞉ hen nowa ko꞉na꞉ ha꞉nakiyo꞉ a꞉la꞉sio꞉, ‘Ge ni egelo꞉ we bo꞉fo꞉lubi. Tif amio꞉ fowo꞉ tulakiyo꞉, nolo꞉ ge diaki, nolo꞉ no꞉no꞉ dia꞉no꞉’ a꞉la꞉salifo꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","A꞉la꞉fo꞉ko꞉lo꞉ folo꞉ tuma꞉no꞉ ho꞉leno꞉ dowabikiyo꞉, kalu bo꞉fo꞉melea꞉kilo꞉ ta꞉fo꞉ i a꞉ma꞉yo꞉ fo nolo꞉ enebo꞉ iliga꞉foma꞉kiyo꞉, hendo꞉ biso꞉ kalu eyo꞉ ene nanogdo꞉ dian kalu nowo꞉ a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Nanog kalu e a꞉na fa꞉la꞉dowo꞉ ko꞉sega, egelo꞉lo꞉ bo꞉fo꞉len kalu iliyo꞉ e ta꞉lia꞉sa꞉ga꞉ yame tandea꞉sa꞉ga꞉, e hendo꞉ biso꞉lo꞉wa a꞉ma꞉la꞉ madali iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","A꞉la꞉ta꞉ga꞉ hendo꞉ biso꞉ eyo꞉ nanog kalu nowo꞉ wa꞉ka iliga꞉fo꞉, ko꞉sega iliyo꞉ kalu a꞉no꞉ misa꞉ya yame tandea꞉sa꞉ga꞉, sasedeaki sendelo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","A꞉la꞉go꞉lo꞉biki eyo꞉ nowo꞉lo꞉ wa꞉ka iliga꞉fo꞉ ko꞉sega, iliyo꞉ kalu a꞉no꞉ sana sowo꞉. Tif amio꞉ kalu modo꞉ nolo꞉ wa꞉ka a꞉iliga꞉fo꞉, ko꞉sega kalu a꞉no꞉ nolo꞉ yame tandeaki, nolo꞉ sana sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“A꞉la꞉gabiki hendo꞉ biso꞉ a꞉ma꞉yo꞉ nanog kalu nowo꞉ a꞉iliga꞉fa꞉no꞉wo꞉ aundo꞉ma dowabiki, ene so꞉wa imilise ha꞉fo꞉lo꞉ disa꞉ a꞉no꞉ko꞉ dowabi iliga꞉fa꞉nikiyo꞉, eneno꞉ a꞉la꞉sio꞉, ‘Iliyo꞉ ne so꞉wa we iligi ba꞉da꞉sa꞉ga꞉, kudu ha꞉na꞉ib.’ A꞉la꞉asula꞉sa꞉ga꞉yo꞉, ene so꞉wa a꞉no꞉ a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ko꞉sega egelo꞉lo꞉ bo꞉fo꞉len kalu iliyo꞉ egele nenelakiyo꞉ a꞉la꞉sio꞉, ‘Ene so꞉wa imilig yab wema꞉yo꞉, iyayo꞉ sowalikiyo꞉ dabuno꞉ e tambo dia꞉ib. Dabun a꞉no꞉ nili dia꞉no꞉ ko꞉lo꞉ e sana soma꞉niki.’ ");
INSERT INTO bco_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","A꞉la꞉fo꞉ko꞉lo꞉ iliyo꞉ e ta꞉lia꞉sa꞉ga꞉ sanaeta꞉ga꞉yo꞉, iliyo꞉ e dia꞉ga꞉ wain egelo꞉ ha꞉la꞉ya sandifo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“A꞉la꞉dimido꞉ ko꞉lo꞉, hendo꞉ biso꞉ a꞉ma꞉yo꞉ egelo꞉lo꞉ bo꞉fo꞉len kalu i o꞉mo꞉wo꞉ waga dimidama꞉iba? Hendo꞉ biso꞉ e ya꞉ga꞉yo꞉, egelo꞉lo꞉ bo꞉fo꞉len kalu a꞉no꞉ tambo yasala꞉sa꞉ga꞉, wain egelo꞉ a꞉no꞉ kalu nolbo꞉ dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Godeya꞉ to ko꞉lo꞉ sa꞉sa꞉lo꞉ we giliyo꞉ agelo꞉wo꞉? Hendele, to a꞉na sa꞉lakiyo꞉ a꞉la꞉sio꞉, “ ‘U ko꞉lo꞉ alo꞉ dian ililo꞉ mo꞉beakilo꞉ sandifo꞉ a꞉no꞉, o꞉go꞉ ayo꞉ halaido꞉ dofo꞉melea꞉kilo꞉ u wa꞉la꞉b ko꞉lo꞉ fa꞉la꞉dowo꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Alana꞉ ene dimida꞉sa꞉ga꞉ fa꞉la꞉do alifa꞉ ko꞉lo꞉, nini siya꞉yo꞉ mada nafa ba꞉ba꞉ ko꞉lo꞉ nio꞉ sagalab.’” ");
INSERT INTO bco_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ya꞉su eyo꞉ a꞉la꞉ malolabikiyo꞉, Yu misa꞉ kalu iliyo꞉ Ya꞉suwa꞉lo꞉ bale sa꞉lab a꞉no꞉ iyo꞉ ko꞉lo꞉ sa꞉lab a꞉la꞉asulo꞉. Ya꞉su eyo꞉ iyo꞉ egelo꞉lo꞉ bo꞉fo꞉len kalu mogago꞉ o꞉ngo꞉ a꞉la꞉liki bale sio꞉ ko꞉lo꞉, iliyo꞉ e ta꞉lia꞉sa꞉ga꞉ emo꞉wo꞉ mo꞉walilima꞉no꞉ a꞉la꞉ta꞉ga꞉ togo꞉ kedo꞉. Ko꞉sega iyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ tagilaki, Ya꞉suwo꞉ a꞉naka ta꞉ta꞉sa꞉ga꞉, iyo꞉ a꞉ma꞉la꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Tif amio꞉ Yu misa꞉ kaluwa꞉yo꞉ Ya꞉suwa꞉lo꞉ to sa꞉labo꞉ ka꞉la꞉gedema꞉ki asulo꞉ ko꞉lo꞉, iliyo꞉ Fa꞉lisi kalu o꞉lia꞉ Ha꞉lodo꞉ kudu sian kalu o꞉lia꞉ nolo꞉ Ya꞉sulo꞉wa iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Iyo꞉ elo꞉wa fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Widan kalu, nili asulakiyo꞉, ge to hendele sa꞉laki wida꞉sen a꞉la꞉asulo꞉. Kalu nolba꞉lo꞉ to sa꞉lab a꞉no꞉ giyo꞉ mo꞉kele asula꞉sen ko꞉lo꞉, giyo꞉ kaluka꞉isale ko꞉li ko꞉lilo꞉mo꞉wo꞉ man imilise a꞉la꞉ka dimida꞉sen. Godeya꞉ mano꞉ giyo꞉ digalo꞉le wida꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ niliyo꞉ gemo꞉wo꞉ we au dabu ba꞉ba꞉nigo꞉l. Loma꞉ gamani misa꞉ kalu alan, Sisa o꞉mo꞉lo꞉ takis mole dimia꞉no꞉ a꞉no꞉ niliyo꞉ o꞉li dimia꞉no꞉wa꞉le? O꞉ mo꞉dimia꞉no꞉wa꞉le, giyo꞉ waga asulaya? ");
INSERT INTO bco_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Niliyo꞉ takis moleyo꞉ dimia꞉no꞉wa꞉le a꞉la꞉bo꞉, giyo꞉ waga sa꞉ma꞉nigaya?” A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ ililo꞉ e ko꞉lo꞉ diga꞉li sa꞉ma꞉nikilo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giliyo꞉ ne dikidakilo꞉ bale kedako, mo꞉wo꞉ ha꞉? Loma꞉ mole us a꞉no꞉ nelo꞉ ba꞉ba꞉nigo꞉l ko꞉lo꞉, nelo꞉ wena dia꞉mena” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Iliyo꞉ mole us a꞉no꞉ Ya꞉sulo꞉ bo꞉ba꞉ki dimia꞉sa꞉ga꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Mole wema꞉ wa꞉l amio꞉ abe wo꞉lokano꞉lo꞉bo꞉? A꞉la꞉ta꞉ga꞉ mole wa꞉l amilo꞉ wi sa꞉sa꞉lo꞉ a꞉no꞉ abeno꞉lo꞉bo꞉?” Iliyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Sisa eno꞉.” ");
INSERT INTO bco_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “A꞉la꞉fo꞉ko꞉lo꞉ kelego꞉ Sisa elo꞉wo꞉, a꞉ma꞉la꞉ Sisamo꞉ dimia꞉bi. A꞉la꞉ta꞉ga꞉ kelego꞉ Gode elo꞉wo꞉, a꞉ma꞉la꞉ Godemo꞉ dimia꞉bi.” Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ towo꞉ nafa sa꞉labi, iyo꞉ iliga꞉sa꞉ga꞉ molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Sadusi kalu iliyo꞉ tili asulakiyo꞉, sowo꞉ kaluwo꞉ a꞉ma꞉la꞉yo꞉ mada mo꞉dasima꞉ib a꞉la꞉asula꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉ a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Widan kalu, tamin amio꞉ Mo꞉sa꞉s elo꞉ ele nimo꞉lo꞉ sa꞉sa꞉li me a꞉ma꞉yo꞉ a꞉la꞉sio꞉, ‘Kalu nowo꞉ so꞉walo꞉ mo꞉sa꞉la꞉li ka sowalega, kalu sowo꞉ a꞉ma꞉ ga sa꞉ba꞉lo꞉ a꞉no꞉, ene aowa꞉ mada dia꞉ib. A꞉la꞉ta꞉ga꞉ kalu sowo꞉ a꞉ma꞉ wiyo꞉ mo꞉elema꞉ki, aowa꞉ inga sa꞉ba꞉lo꞉ a꞉no꞉ ene dia꞉sa꞉ga꞉, so꞉wa sa꞉la꞉liab a꞉no꞉, ao sowo꞉ a꞉ma꞉ no꞉ doma꞉ib.’ Mo꞉sa꞉s eyo꞉ a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Nio꞉ a꞉no꞉ ko꞉lo꞉ da꞉feaki maloloma꞉nigo꞉l. Kalu noma꞉yo꞉ kalu so꞉wayo꞉ doma꞉la꞉fo꞉ ko꞉lo꞉ sa꞉la꞉li. Ao wa꞉la꞉bo꞉ gayo꞉ di, ko꞉sega e so꞉wayo꞉ mo꞉sa꞉la꞉li ka sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","22","Ga sa꞉ba꞉lo꞉ a꞉no꞉ wa꞉la꞉ba꞉ fa꞉s a꞉ma꞉ a꞉di, ko꞉sega elo꞉ so꞉walo꞉ mo꞉sa꞉la꞉li ka sowabiki, ao asol a꞉ma꞉yo꞉lo꞉ a꞉la꞉ka dimido꞉. Ao i doma꞉la꞉fo꞉ a꞉no꞉ tambo ga imilise a꞉no꞉ko꞉ dia꞉li ane ko꞉sega, iyo꞉ tambo so꞉walo꞉ mo꞉sa꞉la꞉li ka danili. Tif amio꞉ ga a꞉no꞉lo꞉ sowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kalu doma꞉la꞉fo꞉ a꞉ma꞉yo꞉ ga imilig a꞉no꞉ko꞉ dia꞉i ane. A꞉la꞉fo꞉ko꞉lo꞉ kalu sowo꞉lo꞉ a꞉ma꞉la꞉ dasi alifelab ho꞉len a꞉namio꞉, ga a꞉ma꞉ indeyo꞉ o꞉b doma꞉iba?” Sadusi kalu iliyo꞉ Ya꞉sumo꞉ dehege kedaki a꞉na dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Godeya꞉ to sa꞉sa꞉lo꞉ o꞉lia꞉ Godeya꞉ halaido꞉ o꞉lia꞉yo꞉ gio꞉ mo꞉fanda asulo꞉ ko꞉lo꞉, giliyo꞉ mada babale asula꞉sa꞉ga꞉ ha꞉na꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Sowo꞉ kaluka꞉isale iyo꞉ a꞉ma꞉la꞉ a꞉dasilalikiyo꞉, kaluwa꞉yo꞉ gayo꞉ mo꞉diaki, gaya꞉lo꞉ kaluwo꞉ mo꞉ha꞉na꞉ib. Ko꞉sega iyo꞉ Hebenelo꞉ ma꞉mula꞉ kalu sab o꞉leo꞉ngo꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","A꞉la꞉ta꞉ga꞉ o꞉go꞉ niyo꞉ gimo꞉wo꞉ kalu sowo꞉ ko꞉lo꞉ a꞉ma꞉la꞉do꞉ dasilan a꞉no꞉ walama꞉nigo꞉l. Godeyo꞉ i usa ilikilo꞉ Mo꞉sa꞉s emo꞉ sa꞉labilo꞉, Mo꞉sa꞉s elo꞉ sa꞉sa꞉lo꞉ a꞉no꞉ gio꞉ mada agelo꞉. Malolo꞉ a꞉namio꞉, Gode eyo꞉ Mo꞉sa꞉sbo꞉wo꞉ a꞉la꞉sio꞉, ‘Ablahama꞉ Godeyo꞉ Ne, Aisa꞉ga꞉ Godeyo꞉ Ne, a꞉la꞉ta꞉ga꞉ Ya꞉koba꞉ Godeyo꞉ Ne.’ ");
INSERT INTO bco_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kalu i a꞉no꞉ sowo꞉ ko꞉sega Godeya꞉ sa꞉lakiyo꞉ i a꞉no꞉ mela꞉no꞉wo꞉ o꞉lab a꞉la꞉sa꞉lab ko꞉lo꞉ Gode e kalu sowo꞉ a꞉ma꞉no꞉ma. E kalu mela꞉no꞉lo꞉ a꞉lab a꞉ma꞉ Gode. A꞉la꞉fo꞉ko꞉lo꞉ gililo꞉ kalu sowo꞉wo꞉ mo꞉dasima꞉ib a꞉la꞉do꞉ asulo꞉ a꞉no꞉, giliyo꞉ hala asula꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Elelo꞉ wida꞉sen kalu imilig nowo꞉ a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, Sadusi kalu o꞉lia꞉ Ya꞉su o꞉lia꞉ kegakilo꞉ nenelab a꞉namio꞉, Ya꞉suwa꞉lo꞉ to nafa a꞉ma꞉la꞉ sa꞉lab a꞉no꞉ e da꞉da꞉sa꞉ga꞉, kalu a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Gode eyo꞉ eleyo꞉ modo꞉ difa꞉ ko꞉sega, nililo꞉ hendele kudu ha꞉na꞉no꞉wo꞉ ele imilig a꞉no꞉ o꞉ba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Gilo꞉ mada kudu ha꞉na꞉no꞉ eleyo꞉ we, ‘Isolael kaluka꞉isale gio꞉ dinafa dabuma. Godeyo꞉ nili misa꞉ Alano꞉ e. Godeyo꞉ imilise ko꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kalu Alano꞉ gi Gode, ge mada asula꞉bi. Gi mela꞉no꞉ o꞉lia꞉ asulo꞉ o꞉lia꞉yo꞉ Godemo꞉ dimia꞉bi. Go꞉no꞉n halaido꞉wa꞉ iliki, Godeyo꞉ a꞉na kudu ha꞉na꞉lubi.’ Ele we tamindeyo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","A꞉la꞉ta꞉ga꞉ ele a꞉ma꞉ fa꞉s amilo꞉ da꞉labo꞉ we, ‘Go꞉no꞉n asulan o꞉leaumbo꞉, giasi kaluka꞉isale nolo꞉lo꞉ a꞉la꞉asulaki ha꞉fo꞉wo꞉ disa꞉la꞉lubi.’ Ele difa꞉ da꞉lab nolba꞉yo꞉ ele a꞉la꞉ we, mo꞉tinio꞉ ko꞉lo꞉ a꞉lab.” Ya꞉su eyo꞉ kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Kalu a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, giyo꞉ nafa sio꞉. Godeyo꞉ imilise ko꞉lo꞉ a꞉lab, a꞉la꞉ta꞉ga꞉ Godeyo꞉ nowo꞉ mada aundo꞉ma a꞉la꞉do꞉ gilo꞉ sa꞉lab a꞉no꞉ hendele. ");
INSERT INTO bco_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Giliyo꞉ Gode emo꞉wo꞉ ha꞉fo꞉ disa꞉laki, go꞉no꞉ndo꞉ asulan o꞉lia꞉, go꞉no꞉n asulo꞉ o꞉lia꞉, go꞉no꞉n halaido꞉ o꞉lia꞉ a꞉na tambo ilikiyo꞉, Gode emo꞉wo꞉ alan asula꞉bi. A꞉la꞉ta꞉ga꞉ gio꞉ go꞉no꞉n asulan o꞉leaumbo꞉, giasi kaluka꞉isale nolo꞉lo꞉ a꞉la꞉asulaki ha꞉fo꞉wo꞉ disa꞉la꞉lubi. Man a꞉la꞉do꞉ dimidab a꞉ma꞉yo꞉ Godeyo꞉ mada sagale alitab ko꞉lo꞉, man a꞉ma꞉yo꞉ Godemo꞉lo꞉ boba dimian o꞉lia꞉ no꞉ so꞉kugulu mean o꞉lia꞉yo꞉ tinio꞉ ko꞉lo꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ya꞉su eyo꞉ kalu elo꞉ a꞉ma꞉la꞉ sa꞉lab a꞉no꞉ nafale da꞉da꞉ga꞉yo꞉, emo꞉wo꞉ a꞉la꞉sio꞉, “Ge Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉namio꞉ semo꞉ tiane ko꞉sega ko꞉na꞉ma dofo꞉lab.” A꞉la꞉sa꞉labiki kaluka꞉isaleyo꞉ tambo Ya꞉sumo꞉lo꞉ dehege dabu kelema꞉no꞉wo꞉ tagilaki, wa꞉kabiyo꞉ mo꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ya꞉suwo꞉ Godeya꞉ malilo꞉ a isagena Godeya꞉ man wida꞉likiyo꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Elelo꞉ wida꞉sen kaluwa꞉lo꞉ Keliso, Godeya꞉lo꞉ Da꞉feyo꞉ kalu a꞉no꞉, Da꞉ibida꞉ inso꞉ a꞉la꞉do꞉ sa꞉la꞉sen a꞉no꞉ mo꞉wo꞉ waga asulaki sio꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Da꞉ibid eyamio꞉ Godeya꞉ Mamaya꞉yo꞉ asulo꞉wo꞉ dimiabikiyo꞉, eyo꞉ a꞉la꞉sio꞉, “Gode eyo꞉ ni Alanbo꞉ sa꞉lakiyo꞉, ‘Niyo꞉ gis kalu gilo꞉wo꞉ gi ha꞉g amio꞉ semo꞉ difa꞉ amio꞉, Nani bo꞉fo꞉mela꞉niki, ge ni dagi ililiba mesa꞉ni mena.’ ");
INSERT INTO bco_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Da꞉ibid eyo꞉ Godeya꞉lo꞉ Da꞉feyo꞉ kalu a꞉no꞉ ‘Alan’ a꞉la꞉ da꞉feyo꞉ ko꞉lo꞉, kalu a꞉no꞉ Da꞉ibida꞉ inso꞉wo꞉ waga dowaba꞉le?” A꞉la꞉widabiki kaluka꞉isale modo꞉ kegeo꞉ iliyo꞉ Ya꞉suwa꞉lo꞉ to widab a꞉no꞉ sagala꞉liki dabu. ");
INSERT INTO bco_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ya꞉su eyo꞉ a꞉no꞉ ko꞉lo꞉ widakiyo꞉ a꞉la꞉sio꞉, “Giliyo꞉ elelo꞉ wida꞉sen kaluwa꞉ man a꞉no꞉ dinafa aloba꞉da꞉sa꞉ga꞉ dinafa dowa꞉bi. Iliyo꞉ helebeso꞉go꞉ mada nafale tigilo꞉ sa꞉ga꞉lela꞉sa꞉ga꞉yo꞉, kalu nolba꞉yo꞉ e momado꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉ iyo꞉ wabuluma꞉ki, ma꞉no꞉lo꞉ kililia꞉sen hen a꞉na ha꞉na꞉no꞉ asula꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Tolo꞉ wida꞉sen ayamio꞉lo꞉, ililo꞉ mesa꞉no꞉ i fofodo꞉wo꞉lo꞉ ko꞉li nafale nowa mesa꞉no꞉ asula꞉sen. A꞉la꞉ta꞉ga꞉ ma꞉no꞉wo꞉ alan ma꞉ni kegeakiyo꞉, iyo꞉ kalu alando꞉ sa꞉sen a꞉na mesa꞉no꞉ asula꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Iliyo꞉ ga sa꞉ba꞉lo꞉ i a꞉no꞉ dikida꞉sa꞉ga꞉, a ililo꞉wo꞉ afale dia꞉sen. Iliyo꞉ a꞉la꞉dimida꞉likiyo꞉, kalu nolba꞉yo꞉ iyo꞉ nafa kalu a꞉la꞉bo꞉ba꞉ki, Godemo꞉ dulugu sa꞉lakiyo꞉, towo꞉ sambo sa꞉la꞉sen. A꞉la꞉fo꞉ko꞉lo꞉ kalu a꞉la꞉do꞉ dimida꞉lab o꞉mo꞉wo꞉ mada alan falasila꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Kaluka꞉isaleyo꞉ modo꞉ ya꞉sia꞉labikiyo꞉, Ya꞉su e molelo꞉ to꞉lola꞉sen go꞉fo꞉ anib a꞉na kagafo꞉liki bo꞉fo꞉len. Kaluka꞉isale moleyo꞉ modo꞉lo꞉ delen iliyo꞉ moleyo꞉ modo꞉ ko꞉lo꞉ to꞉lolo꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ko꞉sega ga sa꞉ba꞉lo꞉ imilig noma꞉yo꞉ e mole nolo꞉ aundo꞉ma ko꞉lo꞉ mole us a꞉la꞉ a꞉no꞉ko꞉ to꞉lolabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Enedo꞉ tili wida꞉sen kalu iyo꞉ elo꞉wa mena a꞉la꞉ta꞉ga꞉, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ to we gimo꞉wo꞉ hendele sa꞉ma꞉nigo꞉l. Ga sa꞉ba꞉lo꞉ wema꞉lo꞉ mole ha꞉lu ko꞉lo꞉ to꞉lolab we, Godeya꞉ si wa꞉l amio꞉ nolba꞉lo꞉ alan dimiab a꞉no꞉ e tinio꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Kaluka꞉isale moleyo꞉ modo꞉lo꞉ delen iliyo꞉, mole ililo꞉wo꞉ alobanalia꞉ga꞉, heb alano꞉ inino꞉ dia꞉taki, heb nolo꞉ a꞉na to꞉lolab. Ko꞉sega ga sa꞉ba꞉lo꞉ eyo꞉, mole ha꞉lula꞉su enedo꞉ ma꞉no꞉ kililia꞉no꞉ delen a꞉no꞉ko꞉ tambo dia꞉sa꞉ga꞉ to꞉lolab.” ");
INSERT INTO bco_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ya꞉su e Godeya꞉ malilo꞉ ayo꞉ ta꞉ta꞉ga꞉ ha꞉nab amio꞉, enedo꞉ tili wida꞉sen kalu noma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Widan kalu, ge bo꞉ba! Uwa꞉lo꞉ a di we, u alan nafaya꞉ di a꞉la꞉ta꞉ga꞉ a we nafale momade alifela꞉sa꞉ga꞉ a꞉lab.” ");
INSERT INTO bco_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ge uwa꞉lo꞉ a nafale di we ba꞉da꞉sa꞉ga꞉ asuluma. Giliyo꞉ nafa ba꞉dab, ko꞉sega tif amio꞉ a we tambo bidi ha꞉naki, u noma꞉ wa꞉l amilo꞉ dinafa a꞉lab we aumbo꞉ mo꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Iyo꞉ Ya꞉lusalemo꞉ ta꞉ta꞉ga꞉, O꞉lif misio꞉ a꞉na fa꞉la꞉ ha꞉na꞉sa꞉ga꞉ dowakiyo꞉, Godeya꞉ malilo꞉ a a꞉no꞉ a꞉ma꞉la꞉ ololo bo꞉fo꞉liki, Bidayo꞉, Ya꞉ma꞉so꞉, Yo꞉no꞉, a꞉la꞉ta꞉ga꞉ Anduluwo꞉, i a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, ");
INSERT INTO bco_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Gilo꞉ to sa꞉lalo꞉, ho꞉leno꞉ iga꞉sa fa꞉la꞉doma꞉iba? Ho꞉len a꞉no꞉ ko꞉na꞉ma fa꞉la꞉doma꞉nigabo꞉lo꞉b a꞉la꞉bo꞉, niliyo꞉ waga ele ba꞉ba꞉no꞉wo꞉? Giyo꞉ nimo꞉wo꞉ walama.” ");
INSERT INTO bco_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu nolba꞉lo꞉ to dikili sa꞉lab a꞉ma꞉yo꞉ gio꞉ hala tililia꞉ ha꞉nabena꞉ki, dinafa bo꞉fo꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Mo꞉wo꞉ ni wiya a꞉la꞉ta꞉ga꞉yo꞉, kaluwo꞉ modo꞉ ya꞉siakiyo꞉ ‘Godeya꞉lo꞉ Da꞉feyo꞉ kaluwo꞉ ne’ a꞉la꞉ dikili sa꞉lalikiyo꞉, kaluka꞉isaleyo꞉ modo꞉ tilida꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Henfelo꞉ wenamio꞉ bubo꞉wo꞉ alan fa꞉la꞉dowalikiyo꞉lo꞉, bubaka꞉ a꞉la꞉do꞉ sio꞉wo꞉ fowo꞉ da꞉dalikiyo꞉lo꞉, gio꞉ iliga꞉so꞉bo. Mo꞉wo꞉ dimido꞉ we tamina fa꞉la꞉doma꞉ib, ko꞉sega henfelo꞉ we semo꞉ elema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Henfelo꞉ wenamio꞉ hen alan no o꞉lia꞉ hen alan no o꞉lia꞉yo꞉, gis diaki bubo꞉wo꞉ alan fa꞉la꞉dowa꞉i ha꞉na꞉ib. A꞉la꞉ta꞉ga꞉ misa꞉ kalu no o꞉lia꞉ no o꞉lia꞉yo꞉ babuma꞉ib. Hen nol amio꞉ hiniyo꞉ alan tima꞉ib, a꞉la꞉ta꞉ga꞉ hen nol amio꞉ egelo꞉wo꞉ mo꞉fa꞉la꞉ndaliki, kaluka꞉isaleyo꞉ maiyo꞉wo꞉ alan doma꞉ib. Hida꞉yo꞉ a꞉no꞉ fa꞉la꞉dowalikiyo꞉, gaya꞉lo꞉ so꞉wa sa꞉la꞉lia꞉nikilo꞉ nagalo꞉ tamin amilo꞉ ba꞉dan au fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Ge asulo꞉wo꞉ dimidalia꞉ga꞉ yasita꞉bi! Mo꞉wo꞉ kalu nolba꞉yo꞉ gio꞉ amisa꞉n misa꞉ kalumo꞉ ta꞉lia꞉sa꞉ga꞉ dimia꞉ib. Iliyo꞉ gio꞉ Godeya꞉lo꞉ tolo꞉ wida꞉sen aya mo꞉walila꞉sa꞉ga꞉, yame tandema꞉ib. A꞉la꞉ta꞉ga꞉ gio꞉ ni wiyo꞉ ta꞉lisab ko꞉lo꞉, gio꞉ tililia꞉ ha꞉na꞉sa꞉ga꞉, gamani misa꞉ kaluwa꞉ siwa꞉la mo꞉walilalikiyo꞉, gili tilidabu a꞉no꞉ imo꞉wo꞉ a꞉na fanda sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Henfelo꞉ we o꞉elema꞉nigalikiyo꞉, Godeya꞉ ene to nafayo꞉ henfelo꞉ kaluka꞉isale tambomo꞉wo꞉ tamina walama꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gelo꞉ ta꞉lia꞉sa꞉ga꞉lo꞉ mo꞉walilab amio꞉, giliyo꞉ a꞉ma꞉la꞉yo꞉ waga sa꞉ma꞉no꞉wa꞉le a꞉la꞉likiyo꞉ kele asula꞉so꞉bo. Gilo꞉ sa꞉ma꞉no꞉wo꞉ Godeya꞉ Mamaya꞉yo꞉ gemo꞉ dimia꞉ib ko꞉lo꞉, Mamaya꞉ to a꞉no꞉ gi mego꞉fa fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ho꞉len a꞉namio꞉ kalu noma꞉yo꞉ ene aoleyo꞉ sana soma꞉ki teledoma꞉ib. Iyaya꞉yo꞉ inso꞉wo꞉ sana soma꞉ki teledoma꞉ib. A꞉la꞉ta꞉ga꞉ so꞉wa iliyo꞉ iya o꞉lia꞉ ano o꞉lia꞉mo꞉wo꞉ a꞉la꞉iyaki, iyo꞉ sana soma꞉ki teledoma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Gio꞉ ni wiyo꞉ ta꞉lisab ko꞉lo꞉, kaluka꞉isale tambowa꞉yo꞉ gimo꞉wo꞉ kulufa꞉yo꞉wo꞉ alan doma꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ hida꞉yo꞉ a꞉namio꞉ halaido꞉ dofo꞉ko꞉ ha꞉na꞉la꞉ga꞉ eleya edalega, Gode eyo꞉ e asuwa꞉takiyo꞉ a꞉ma꞉la꞉ gasilia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Kalu abeyo꞉ to welo꞉ agelab a꞉ma꞉yo꞉ mada dinafa asula꞉bi. Ya꞉su eyo꞉ to nolo꞉ imo꞉wo꞉ a꞉sio꞉, “Giliyo꞉ kelego꞉ mada mogago꞉ imilig nowo꞉ Godeya꞉ Malilo꞉ hen a꞉na delena ba꞉ba꞉ib. Kelego꞉ mogago꞉ a꞉no꞉ Godeyo꞉ ba꞉dalikiyo꞉, e gadia꞉sa꞉ga꞉ ene ayo꞉ ta꞉ta꞉ga꞉ ha꞉na꞉no꞉ asuluma꞉ib. Giliyo꞉ kelego꞉ a꞉no꞉ ba꞉dalikiyo꞉, Yudia hen amilo꞉ sen kaluka꞉isale a꞉no꞉ tambo, gio꞉ mo꞉soma꞉nikiyo꞉, hen misio꞉ nol a꞉namida꞉ nai ha꞉na꞉sia꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kalu ene a wa꞉l amilo꞉ sen a꞉no꞉ tina꞉sa꞉ga꞉yo꞉, a꞉ma꞉la꞉ a usamio꞉ kelego꞉wo꞉ dia꞉ni ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","A꞉la꞉ta꞉ga꞉ kalu egelo꞉ amilo꞉ elen a꞉no꞉lo꞉, ene helebeso꞉g sambo ayamilo꞉ da꞉lab a꞉no꞉ e a꞉ma꞉la꞉yo꞉ dia꞉ni ha꞉na꞉so꞉bo. Ge hen misio꞉wa nai ha꞉na꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ho꞉len a꞉namio꞉ ka꞉isale so꞉walo꞉ alela꞉sen o꞉lia꞉ so꞉wamo꞉lo꞉ bolo꞉ mea꞉lab ka꞉isale a꞉no꞉lia꞉yo꞉ mada halaido꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Gilo꞉ dalalema꞉no꞉ ho꞉len a꞉no꞉ ta꞉na fa꞉la꞉dowabena꞉ki, Godemo꞉ dulugu sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mo꞉wo꞉ ho꞉len a꞉namio꞉ hida꞉yo꞉wo꞉ mada alan doma꞉ib. Henfelo꞉ we ho꞉gi mo꞉mo꞉do꞉wa a꞉la꞉ta꞉ga꞉lo꞉ mio꞉ a꞉namio꞉, hida꞉yo꞉ wengo꞉wo꞉ tamin amio꞉ mo꞉fa꞉la꞉dowa꞉i mio꞉ ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ tif amio꞉lo꞉ hida꞉yo꞉ wengo꞉wo꞉ wa꞉kabiyo꞉ mo꞉fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Hida꞉yo꞉ ho꞉len a꞉no꞉ Gode eyo꞉ mo꞉abolda꞉lai kibo꞉bowo꞉, kaluka꞉isaleyo꞉ mo꞉gasiliaki tambo yasalemabe. Ko꞉sega Gode eyo꞉ kaluka꞉isale enedo꞉ da꞉fe alifa꞉ a꞉no꞉ asulakiyo꞉, hida꞉yo꞉ ho꞉len a꞉no꞉ abolda꞉su doma꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","22","Ho꞉len a꞉namio꞉ madali Kelisowo꞉, a꞉la꞉ta꞉ga꞉ madalilo꞉ dinali sa꞉lan kaluwo꞉ modo꞉ ko꞉lo꞉ fa꞉la꞉dowa꞉sa꞉ga꞉, molo ha꞉na꞉no꞉wo꞉ mada ko꞉li ko꞉lilo꞉ dimidama꞉ib. Iliyo꞉ Godeya꞉lo꞉ da꞉fe alifa꞉ kaluka꞉isale a꞉no꞉ ko꞉lo꞉ dikilima꞉no꞉laki auma꞉ib ko꞉sega, iliyo꞉ mo꞉ililima꞉ib. A꞉la꞉galikiyo꞉ kalu noma꞉yo꞉ gimo꞉ sa꞉laki, ‘Gio꞉ bo꞉ba! Godeya꞉lo꞉ da꞉feyo꞉ kaluwo꞉ wena sab.’ A꞉la꞉ta꞉ga꞉ kalu noma꞉ sa꞉laki, ‘Da꞉daya? Godeya꞉lo꞉ da꞉feyo꞉ kaluwo꞉ honona saka꞉’ a꞉la꞉sa꞉lalega, giliyo꞉ to a꞉no꞉ tilida꞉da꞉so꞉bo! ");
INSERT INTO bco_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ dimido꞉ we o꞉fa꞉la꞉doma꞉nigabiki, tamin amio꞉ to we gimo꞉wo꞉ dinali salito꞉l ko꞉lo꞉, gio꞉ asulo꞉wo꞉ dimidalia꞉ga꞉ kagaya꞉bi. ");
INSERT INTO bco_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“A꞉la꞉fo꞉ko꞉lo꞉ ho꞉len a꞉namio꞉, hida꞉yo꞉ a꞉no꞉ fa꞉la꞉dowa꞉sa꞉ga꞉ edalikiyo꞉, “ ‘Ofo꞉ ho꞉lendo꞉ma dowaki sololia꞉ib, a꞉la꞉ta꞉ga꞉ ele ho꞉wo꞉lo꞉ mo꞉dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Tamin akin amilo꞉ ga꞉go꞉ a꞉no꞉ dogasefo꞉ tindaliki, akin amilo꞉ kelego꞉ da꞉lab a꞉no꞉ tambo ida꞉li alifelema꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“O꞉g ho꞉len a꞉namio꞉ Kalule Dowo꞉ e yakiyo꞉, halaido꞉ alan o꞉lia꞉ ho꞉len fo꞉fo꞉lesodo꞉ o꞉lia꞉ kola꞉ wa꞉la yaliki, kaluka꞉isaleya꞉yo꞉ ini siya꞉ ba꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A꞉la꞉ta꞉ga꞉ Godeya꞉lo꞉ da꞉fe alifa꞉ kaluka꞉isale a꞉no꞉ kegenema꞉ki, niyo꞉ no꞉no꞉n ma꞉mula꞉ kaluwo꞉, henfelo꞉ we tambo ofdo꞉ fa꞉la꞉dowana a꞉la꞉ta꞉ga꞉ ofdo꞉ tinana iliga꞉felema꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Gio꞉ alona꞉i amilo꞉ dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉ asula꞉bi. Alona꞉ i amio꞉ musugo꞉ fa꞉la꞉dota꞉ga꞉ fo꞉so꞉ imolo꞉ dowalikiyo꞉, imo ho꞉leno꞉ ko꞉na꞉ma fa꞉la꞉doma꞉nigab a꞉la꞉asula꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gio꞉ to nilo꞉ so꞉lo꞉l we hendele fa꞉la꞉dowab a꞉no꞉ ba꞉dakiyo꞉, giliyo꞉ Kalule Dowo꞉ e toga꞉ meya kagayab ko꞉lo꞉ ko꞉na꞉ma mia꞉nigab a꞉la꞉asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Kaluka꞉isale o꞉gdo꞉ sab we semo꞉sowo꞉ o꞉elenka, nilo꞉ so꞉lo꞉l we hendele fa꞉la꞉doma꞉nigab. ");
INSERT INTO bco_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Henfelo꞉ o꞉lia꞉ akin o꞉lia꞉yo꞉ kelege doma꞉ib ko꞉sega, ni towo꞉ mo꞉kelegema꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nilo꞉ so꞉lo꞉l a꞉no꞉ ho꞉len o꞉lia꞉ ofa꞉si o꞉lia꞉yo꞉ iga꞉sa fa꞉la꞉doma꞉nigaba꞉le, kaluka꞉isaleyo꞉ tambo mo꞉asulo꞉ ko꞉lo꞉lab. Ma꞉mula꞉ kalu Hebenelo꞉ a꞉labo꞉lo꞉, Godeya꞉ So꞉wayo꞉lo꞉ ho꞉len a꞉no꞉ mo꞉asulo꞉ ko꞉sega, Do Godeya꞉ ina꞉li e asulufo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","A꞉la꞉fo꞉ko꞉lo꞉ gio꞉ asulo꞉wo꞉ dimidalia꞉ga꞉ yasita꞉bi! Mo꞉wo꞉ o꞉lo꞉ fa꞉la꞉doma꞉nigab ho꞉len a꞉no꞉ ge mo꞉asulo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Alo꞉ biso꞉ eneno꞉ mageso꞉ ha꞉nakiyo꞉, e alo꞉ bo꞉fo꞉mela꞉no꞉wo꞉ ene nanog kalumo꞉ nanogo꞉ sagaletaki, togdo꞉ bo꞉fo꞉ta꞉sen kalu o꞉mo꞉wo꞉ a꞉la꞉sio꞉, ‘ge toga bo꞉fo꞉liki yasila꞉lubi’ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","36","“Togdo꞉ bo꞉fo꞉ta꞉sen kaluwa꞉lo꞉ ba꞉da꞉li yasila꞉len aumbo꞉, nelo꞉ a꞉ma꞉la꞉lo꞉ mia꞉no꞉wo꞉ gio꞉ dinafa ba꞉da꞉liki yasila꞉lubi. Mo꞉wo꞉ alo꞉ biso꞉lo꞉ a꞉ma꞉la꞉ mia꞉ibo꞉, ge ho꞉leno꞉ mo꞉asulo꞉ ko꞉lo꞉lab. E ga꞉lo mia꞉iba꞉le, o꞉ nulu mia꞉iba꞉le, o꞉ kea꞉fo ho꞉idaba mia꞉iba꞉le babalo꞉ ko꞉lo꞉, e bo꞉e yakiyo꞉ gio꞉ alifo꞉lena ba꞉dabena꞉ki, gio꞉ dimidalia꞉ga꞉ bo꞉fo꞉lubi. ");
INSERT INTO bco_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","To nilo꞉ gimo꞉lo꞉ so꞉lo꞉l we, kaluka꞉isaleyo꞉ tambomo꞉wo꞉ a꞉la꞉so꞉lo꞉l, ‘Gio꞉ dimidalia꞉ga꞉ bo꞉fo꞉lubi.’” ");
INSERT INTO bco_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tinio꞉ Asulo꞉ Ma꞉no꞉ ho꞉len o꞉lia꞉ Falawa Mosolo꞉ Dowo꞉fa꞉ sagalema꞉no꞉ a꞉no꞉lo꞉, ho꞉len a꞉la꞉ a꞉no꞉ o꞉fa꞉la꞉doma꞉nigabiki, Godemo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉, elelo꞉ wida꞉sen kalu i o꞉lia꞉ma꞉yo꞉, Ya꞉suwo꞉ ta꞉lia꞉sa꞉ga꞉ sa꞉mba꞉niki, togo꞉ wo꞉no꞉le keda꞉len. ");
INSERT INTO bco_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iliyo꞉ e sana soma꞉no꞉wo꞉ togo꞉ kedesa꞉ga꞉ nenelakiyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ Tinio꞉ Asulo꞉lo꞉ Ma꞉no꞉ ho꞉len a꞉namio꞉ Ya꞉su mo꞉ta꞉lia꞉no꞉, mo꞉wo꞉ ho꞉len a꞉na ta꞉lialega, kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ gadiaki, towo꞉ alan kegema꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ya꞉su e Ba꞉tani ilikiyo꞉, Saimon Aintalo꞉ ta꞉sen a꞉ma꞉ aya siliki, ma꞉no꞉wo꞉ a꞉na na꞉len ami, ga imilig nowo꞉ mahen amilo꞉ wa ho꞉n wasuwo꞉ dia꞉sa꞉ga꞉, Ya꞉sulo꞉wa mio꞉. Mahen elo꞉ dia꞉mio꞉ a꞉no꞉ meyo꞉ usa gula꞉sa꞉ga꞉, Ya꞉suwa꞉ misa꞉ wa꞉l a꞉na tambo kolodo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Kalu i a꞉namilo꞉ sen nol a꞉ma꞉yo꞉ ga a꞉ma꞉lo꞉ dimidab a꞉no꞉ ba꞉da꞉ga꞉, iyo꞉ kele asula꞉sa꞉ga꞉ mo꞉beaki, egelebo꞉ a꞉la꞉sio꞉, “Ga we hala dimidab. Wa ho꞉n we madali walab. ");
INSERT INTO bco_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Wa ho꞉n we kililiai kibo꞉bowo꞉, silba mole fudo꞉ agado꞉la꞉fo꞉ a꞉no꞉ dia꞉sa꞉ga꞉, wa꞉feyo꞉ kalumo꞉ o꞉li dimibabe. Ko꞉sega ga wema꞉yo꞉ a꞉la꞉do꞉ mo꞉dimidab” a꞉la꞉sio꞉. A꞉la꞉asulabiki, iliyo꞉ emo꞉wo꞉ sendeloma꞉no꞉ towo꞉ a꞉na sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ililo꞉ gamo꞉lo꞉ sa꞉lab a꞉no꞉ Ya꞉su eyo꞉ da꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Ga we ka ta꞉foma. Giliyo꞉ emo꞉wo꞉ mo꞉beo꞉ towo꞉ sa꞉la꞉so꞉bo! Eyo꞉ nemo꞉wo꞉ mada nafale dimidab. ");
INSERT INTO bco_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Wa꞉feyo꞉ kaluwo꞉ ho꞉len tambo gi o꞉lia꞉ mela꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ gi o꞉lia꞉lo꞉ a꞉lab ho꞉len a꞉nami, giliyo꞉ a꞉namio꞉ asuwa꞉foma꞉ki asulalikiyo꞉, o꞉li asuwa꞉fa꞉ib. Ko꞉sega ne ho꞉leno꞉ tambo gi o꞉lia꞉yo꞉ mo꞉mela꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ga wema꞉yo꞉ imilise enedo꞉ delen aumbo꞉ nemo꞉ walab. Elo꞉ wa ho꞉n delen aumbo꞉ neka kolodo꞉ alitab. Mo꞉wo꞉ e nelo꞉ sowa꞉sa꞉ga꞉lo꞉ a꞉le alifa꞉no꞉ a꞉no꞉ ko꞉lo꞉ dimidaliaki, wa ho꞉n elo꞉ we ni do꞉mo꞉ amio꞉ a꞉na mulu alitab. ");
INSERT INTO bco_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ to we gimo꞉wo꞉ hendele sa꞉ma꞉nigo꞉l. Godeya꞉ to nafa a꞉no꞉ henfelo꞉ amio꞉ widalikiyo꞉, ga wema꞉lo꞉ dimidab a꞉no꞉ mo꞉ga꞉lilaki, wida꞉li ha꞉na꞉mela꞉ib,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yudas Iskaliot e, Ya꞉suwa꞉lo꞉ tili wida꞉sen kalu kugula꞉fo꞉ nowo꞉ e. A꞉la꞉fo꞉ko꞉lo꞉ e ha꞉na꞉sa꞉ga꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalulo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉, Ya꞉suwo꞉ teledoma꞉no꞉ a꞉la꞉liki egele nenelema꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Iliyo꞉ elo꞉ to saetab a꞉no꞉ da꞉da꞉sa꞉ga꞉ sagalakiyo꞉, iliyo꞉ moleyo꞉ emo꞉ dimia꞉no꞉ a꞉la꞉liki dinali salifa꞉. A꞉la꞉ta꞉ga꞉ Yudas eyo꞉ Ya꞉sulo꞉ imo꞉lo꞉ teledoma꞉no꞉wo꞉ togo꞉ keda꞉li elen. ");
INSERT INTO bco_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Falawa Mosolo꞉ Dowo꞉fa꞉ sagala꞉sen ho꞉len a꞉namio꞉, Isolael so꞉lo꞉ tambowa꞉yo꞉ sibiyo꞉ ina꞉li ina꞉lila꞉ sa꞉nda꞉sen ko꞉lo꞉, ho꞉len agelo꞉ a꞉na fa꞉la꞉dowabiki, enedo꞉ tili wida꞉sen kalu iliyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Niliyo꞉ Tinio꞉ Asulo꞉ Ma꞉no꞉ we o꞉ba ha꞉na꞉sa꞉ga꞉ dimidaefoma꞉ki asulaba?” ");
INSERT INTO bco_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ ha꞉na꞉sa꞉ga꞉ Ya꞉lusalem amisa꞉na tinakiyo꞉, kalu nowo꞉ ho꞉no꞉ go꞉fo꞉ ami wasulia꞉ga꞉ dia꞉ha꞉na꞉lena galima꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ga꞉go꞉ e ha꞉nab au kudu ha꞉na꞉sa꞉ga꞉yo꞉, e a usa tinalikiyo꞉, gaino꞉ alo꞉ biso꞉mo꞉wo꞉ a꞉la꞉sa꞉la꞉bi, ‘Widan Kaluwa꞉ sa꞉lakiyo꞉, “Niyo꞉ no꞉no꞉ndo꞉ tili wida꞉sen kalu o꞉lia꞉lo꞉ Tinio꞉ Asulo꞉ Ma꞉no꞉ ma꞉no꞉wo꞉ ayo꞉ galala꞉ o꞉bamida꞉ ma꞉no꞉wa꞉le?” ’ a꞉la꞉dabu ba꞉da꞉bika꞉labe. ");
INSERT INTO bco_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A꞉la꞉sa꞉lalikiyo꞉, eyo꞉ galala꞉ alan wa꞉l amilo꞉ nowo꞉, mesa꞉no꞉ kelego꞉wo꞉ tambolo꞉ da꞉lab a꞉no꞉ ga꞉gbo꞉ walama꞉ib ko꞉lo꞉, ga꞉go꞉ a꞉na dimidalia꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ya꞉suwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, a꞉la꞉yo꞉ amisa꞉n a꞉na ha꞉na꞉sa꞉ga꞉yo꞉, Ya꞉su elo꞉ a꞉la꞉mo꞉lo꞉ sio꞉ aumbo꞉ hendele fa꞉la꞉dowo꞉ ko꞉lo꞉, a꞉la꞉ma꞉yo꞉ Tinio꞉ Asulo꞉ Ma꞉no꞉ ma꞉no꞉wo꞉ a꞉na dimidalia꞉ga꞉ difa꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ga꞉lo dowabiki, Ya꞉su o꞉lia꞉ enedo꞉ tili widan kalu kugula꞉fo꞉ o꞉lia꞉yo꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Iyo꞉ a꞉na siliki, ma꞉no꞉ na꞉likiyo꞉, Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉, “Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Gio꞉ o꞉gdo꞉ ne o꞉lia꞉lo꞉ ma꞉ndo꞉ nab we, imilig noma꞉yo꞉ ne teledoma꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ya꞉su elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, iliyo꞉ asulo꞉wo꞉ hida꞉ya꞉liki emo꞉wo꞉ a꞉la꞉sio꞉, “Neya꞉le?” a꞉la꞉tandeaki Ya꞉sumo꞉ dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Hendele kalu kugula꞉fo꞉ gi us wenamio꞉ imilig noma꞉yo꞉ dimidama꞉nigaka꞉. Kalu ni dagi o꞉lia꞉lo꞉ fafo amilo꞉ ma꞉no꞉lo꞉ gele nab a꞉no꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","A꞉la꞉fo꞉ko꞉lo꞉ Kalule Dowo꞉ ne, to sa꞉sa꞉lo꞉ amilo꞉ saefa꞉ o꞉leauka dimidama꞉ni ha꞉na꞉no꞉. A꞉la꞉fo꞉ ko꞉sega, Kalule Dowo꞉ nelo꞉ teledowab a꞉no꞉ hida꞉yo꞉wo꞉ alan dia꞉ib. Kalu a꞉no꞉ anowa꞉yo꞉ mo꞉sa꞉la꞉li kibo꞉bowo꞉, o꞉li domabe” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma꞉no꞉ na꞉likiyo꞉, Ya꞉su eyo꞉ ma꞉n so꞉fa꞉ nowo꞉ dia꞉sa꞉ga꞉, Godemo꞉ mada o꞉m a꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, ma꞉n a꞉no꞉ enedo꞉ tili wida꞉sen kalumo꞉ goloso꞉go꞉. A꞉no꞉ dimiakiyo꞉ a꞉la꞉sio꞉, “Ma꞉n we no꞉no꞉n do꞉mo꞉ ko꞉lo꞉, giliyo꞉ dia꞉sa꞉ga꞉ maiya.” ");
INSERT INTO bco_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A꞉la꞉ta꞉ga꞉ ami, eyo꞉ kab amilo꞉ wain ho꞉n wasu a꞉no꞉ dia꞉sa꞉ga꞉, Godemo꞉ mada o꞉m sa꞉la꞉sa꞉ga꞉yo꞉, imo꞉ maiya꞉ki dimi. Iliyo꞉ ho꞉n a꞉no꞉ dia꞉sa꞉ga꞉, a꞉na na꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","“Ho꞉n wasu we, no꞉no꞉n ho꞉bo꞉wo꞉ o꞉m. Ni ho꞉bo꞉ ko꞉lo꞉ kaluka꞉isaleyo꞉ tambo asuwa꞉takilo꞉ tulu alifelab wema꞉yo꞉ Godeya꞉lo꞉ to dinali saefa꞉ a꞉no꞉ halale alitakigab. ");
INSERT INTO bco_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Niyo꞉ to we hendele so꞉lo꞉l. Ne wain ho꞉no꞉ wa꞉kabiyo꞉ mo꞉mo꞉no꞉ka a꞉la꞉ga꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉na siliki, ho꞉giyo꞉ a꞉na ma꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iyo꞉ ma꞉no꞉ na꞉sa꞉ga꞉ eletakiyo꞉, gisalo꞉ imilig nowo꞉ a꞉na mo꞉la꞉sa꞉ga꞉yo꞉, dasila꞉sa꞉ga꞉ iyo꞉ hen misio꞉ O꞉lif, a꞉namida꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ tambo ne gola ba꞉daki ha꞉la꞉ya ha꞉na꞉ib. Tamin amio꞉ Godeya꞉ bugo꞉ amio꞉ sa꞉sa꞉lakiyo꞉ a꞉la꞉sio꞉, “ ‘Niyo꞉ sibilo꞉ bo꞉fo꞉lowano꞉ sana soma꞉no꞉ ko꞉lo꞉, kabo sibiyo꞉ a꞉na dalalelia꞉ga꞉ ha꞉na꞉sima꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ko꞉sega ne dasila꞉sa꞉ga꞉yo꞉, Ga꞉lili hen amio꞉ ne ko꞉le tamina ha꞉na꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ya꞉su elo꞉ to sa꞉lab a꞉no꞉, Bida eyo꞉ da꞉da꞉sa꞉ga꞉yo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu nolo꞉ tambo ge gola ba꞉daki ha꞉la꞉ya ha꞉na꞉ib, ko꞉sega imilise ne ge mo꞉ta꞉fo꞉ ha꞉na꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ Bidamo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gemo꞉wo꞉ hendele so꞉lo꞉l. O꞉g nulu wenamio꞉, gogonowo꞉ andebo꞉ semo꞉ go꞉no꞉ o꞉lalikiyo꞉, giyo꞉ ne mo꞉asulo꞉ a꞉la꞉bo꞉ otalen sa꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ko꞉sega Bida eyo꞉ towo꞉ halaido꞉ sa꞉laki a꞉la꞉sio꞉, “A꞉la꞉bo꞉ mada mo꞉dimidama꞉no꞉. Ne ge o꞉lia꞉ soma꞉no꞉ dowo꞉lalega, niyo꞉ ge mada mo꞉gola ba꞉ba꞉no꞉.” Bida eyo꞉ a꞉la꞉sa꞉labiki, tili wida꞉sen kalu nolba꞉yo꞉lo꞉ to imilise a꞉no꞉ko꞉ kudu sa꞉la꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Iyo꞉ hen Ga꞉sa꞉ma꞉ni a꞉la꞉do꞉ sa꞉lab a꞉na ha꞉na꞉ni ane. Fa꞉la꞉dowa꞉sa꞉ga꞉yo꞉, Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Ne hosona ha꞉na꞉sa꞉ga꞉ Godemo꞉ to sa꞉ma꞉ni ho꞉no꞉l ko꞉lo꞉, gio꞉ wenaka o꞉ta꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A꞉la꞉sa꞉la꞉sa꞉ga꞉ eyo꞉ Bidayo꞉, Ya꞉ma꞉so꞉, Yo꞉no꞉ a꞉no꞉ko꞉ tililia꞉sa꞉ga꞉, Godemo꞉ sa꞉ma꞉ni ane, a꞉la꞉ta꞉ga꞉ e amio꞉ molo asulo꞉wo꞉ alan fa꞉la꞉dowabiki a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Ni asulo꞉wo꞉ hida꞉yo꞉ alan dowaki, ne tilialila soma꞉no꞉ o꞉ngo꞉ dowab. Gio꞉ wena siliki bo꞉fo꞉melea” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E heb doba꞉da꞉ o꞉fina꞉sa꞉ga꞉, hena gulalu misa꞉fu alilakiyo꞉ a꞉la꞉sio꞉, hida꞉yo꞉ yab we tininima꞉no꞉ togo꞉ dowo꞉lalega dila꞉ma a꞉lakiyo꞉ Godemo꞉ dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Eyo꞉ dulugu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Dowa, giyo꞉ kelego꞉ tambowo꞉ o꞉li dimidan. A꞉la꞉fo꞉ko꞉lo꞉ go꞉fo꞉ amilo꞉ wasu ko꞉lo꞉ nemo꞉lo꞉ mea꞉nigab a꞉no꞉ giyo꞉ dila꞉bi. Ko꞉sega nilo꞉ asulab aumbo꞉ kudu ha꞉na꞉so꞉bo. Gilo꞉ asulab auka kudu ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","To a꞉no꞉ dulugu sa꞉la꞉sa꞉ga꞉yo꞉, enedo꞉ tili wida꞉sen kalulo꞉wa ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowaki ba꞉ba꞉ amio꞉, iyo꞉ mida꞉iyo꞉ fufulufo꞉lena ba꞉ba꞉. E ba꞉da꞉sa꞉ga꞉, Bidamo꞉wo꞉ a꞉la꞉sio꞉, “Saimon, ge mida꞉iyo꞉ alifo꞉leya? Ge ofa꞉si imilig nowo꞉ ne o꞉lia꞉ sikaga silikiyo꞉ mo꞉yasiseno꞉lo꞉ka꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Gio꞉ da꞉fe ba꞉dab amio꞉ sulufo꞉ tinabena꞉ki, gio꞉ sikaga siliki, Godemo꞉ dulugu sa꞉la꞉ melea. Gili mamaya꞉yo꞉ dimidama꞉no꞉wo꞉ asulab ko꞉sega, gili do꞉mo꞉wo꞉ halaido꞉lo꞉ma dowab,” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A꞉la꞉ta꞉ga꞉ Ya꞉suwo꞉ to tamin amilo꞉ sio꞉ a꞉no꞉ko꞉ wa꞉ka sa꞉ma꞉ni fiane. ");
INSERT INTO bco_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dulugu sa꞉la꞉sa꞉ga꞉, a꞉ma꞉la꞉ ya꞉ga꞉ ba꞉ba꞉yo꞉, iyo꞉ mida꞉iyo꞉ alifo꞉lena ba꞉ba꞉. A꞉la꞉go꞉ko꞉lo꞉ iyo꞉ sendelowaki, towo꞉ mo꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Asolo꞉ wa꞉ka sa꞉ma꞉ ha꞉na꞉sa꞉ga꞉, a꞉ma꞉la꞉ ya꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ a꞉ alifo꞉leno꞉lo꞉ka꞉! O꞉li. Ho꞉lendeyo꞉ o꞉ma fa꞉la꞉dowab. Dabuma, teledowo꞉ kalu a꞉ma꞉yo꞉ Kalule Dowo꞉ ne, mogago꞉lo꞉ dimidan kalumo꞉ gasimia꞉nigab. ");
INSERT INTO bco_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Dasima! Nelo꞉ gasimia꞉nigab kaluwo꞉ weyako bo꞉ba. Nio꞉ e galima꞉niki ha꞉na꞉n” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ya꞉suwo꞉ to a꞉no꞉ ko꞉lo꞉ sa꞉la꞉lena, enedo꞉ tiliwida꞉sen kalu imilig nowo꞉ Yudas, e a꞉na fa꞉la꞉dowo꞉. Yudasa꞉ fa꞉s amio꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ma꞉lo꞉ wati kaluwo꞉ modo꞉ ko꞉lo꞉ mio꞉. Kalu i a꞉ma꞉yo꞉ ko꞉lo꞉lowo꞉lo꞉, helebesi sambowo꞉lo꞉ diadela꞉sa꞉ga꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tamin amio꞉ teledowo꞉ kalu a꞉ma꞉yo꞉ wati kalu imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu nilo꞉ mimilab a꞉no꞉ o꞉m ko꞉lo꞉, giliyo꞉ kalu a꞉no꞉ ta꞉lia꞉sa꞉ga꞉, gasili ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","A꞉la꞉fo꞉ko꞉lo꞉ Yudas e Ya꞉sulo꞉ka tigini ha꞉na꞉ga꞉ kagayaka a꞉la꞉sio꞉, “Widan kalu.” A꞉la꞉sata꞉ga꞉ ami Ya꞉suwo꞉ a꞉na mimilo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Gis kaluwa꞉yo꞉ Ya꞉su e a꞉na ba꞉da꞉sa꞉ga꞉ ta꞉li. ");
INSERT INTO bco_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ya꞉su e ta꞉liabiki, e anib amilo꞉ kalu kagafo꞉len a꞉ma꞉yo꞉, ene helebesi sambowo꞉ sililia꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉ nanog dian kaluwo꞉ helebesi a꞉ma꞉ yamelaki, ka꞉la꞉na꞉ fo꞉so꞉ gede to꞉lolo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Gilido꞉ helebesi sambo o꞉lia꞉ ko꞉lo꞉do o꞉lia꞉ dia꞉mio꞉ we, ne buban kalu o꞉ngo꞉ a꞉la꞉biki ta꞉lia꞉ni mio꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ho꞉leno꞉ tambowo꞉ ne gi o꞉lia꞉ Godeya꞉ Malilo꞉ aya siliki wida꞉len, ko꞉sega giliyo꞉ a꞉namio꞉ ne mo꞉ta꞉liale. Ko꞉sega dimidab wema꞉yo꞉ bugo꞉ amilo꞉ to dinali saefa꞉ o꞉leaumbo꞉ ilili alitakigab.” ");
INSERT INTO bco_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ya꞉su eyo꞉ a꞉la꞉sa꞉labiki, enedo꞉ tili wida꞉sen kalu iyo꞉ tambo e ta꞉ta꞉sa꞉ga꞉ dalaido꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","A꞉la꞉gabiki kalu so꞉wa nowo꞉ helebeso꞉go꞉ nafale imilig a꞉no꞉ko꞉ tigilo꞉ sa꞉ga꞉la꞉sa꞉ga꞉, Ya꞉suwo꞉ a꞉na kudu mio꞉. Ko꞉sega gis kaluwa꞉yo꞉ e ta꞉liabiki, helebeso꞉g elo꞉ ko꞉lo꞉ a꞉no꞉ko꞉ duguliabikiyo꞉, so꞉wa a꞉no꞉ e hagulabo nai ane. ");
INSERT INTO bco_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iliyo꞉ Ya꞉suwo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu alana꞉ ene aya tililia꞉gane. Ya꞉suwo꞉ a꞉na tililia꞉ga꞉ fa꞉la꞉dowabiki, bobalo꞉ so꞉mea꞉sen misa꞉ kalu i a꞉no꞉ tambo, a꞉la꞉ta꞉ga꞉ ko꞉go꞉do꞉ kaluwo꞉lo꞉, elelo꞉ wida꞉sen kaluwo꞉lo꞉, a꞉na kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ya꞉suwo꞉ tililia꞉ga꞉ ha꞉nabiki, Bidayo꞉ Ya꞉suwa꞉ fa꞉sa gulu dowa꞉liki ha꞉na꞉gane. Bidayo꞉ ha꞉na꞉sa꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉ ayamilo꞉ tolo꞉ us a꞉na tiane. Da꞉la꞉di kalu nolo꞉ baya de go꞉la꞉labiki, Bidayo꞉lo꞉ de go꞉la꞉liki, egele a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Bobalo꞉ so꞉mea꞉sen misa꞉ kalu i o꞉lia꞉ Yu misa꞉ kalu i o꞉lia꞉yo꞉ Ya꞉suwo꞉ sana soma꞉no꞉ a꞉la꞉liki, Ya꞉suwa꞉lo꞉ mogago꞉ dimido꞉ nowo꞉ kaluka꞉isaleyo꞉ sama꞉ki, iyo꞉ ho꞉ido꞉. Iliyo꞉ kedo꞉ ko꞉sega, Ya꞉suwa꞉lo꞉ mogago꞉ dimido꞉ imilig nowo꞉ mo꞉ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Mo꞉wo꞉ kaluwo꞉ modo꞉ ya꞉ga꞉, Ya꞉suwa꞉lo꞉ mo꞉dimido꞉wo꞉ sio꞉ ko꞉sega, madali to ililo꞉ sio꞉ a꞉ma꞉yo꞉ mo꞉imilo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","A꞉la꞉ta꞉ga꞉ kalu nolo꞉ kaga dosdofo꞉liki, Ya꞉suwa꞉lo꞉ mo꞉dimido꞉wo꞉ a꞉na sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Ya꞉su eyo꞉ a꞉la꞉sa꞉labikiyo꞉, nio꞉ dabu. To elo꞉ sio꞉wo꞉ we, “Godeya꞉ malilo꞉ a ko꞉lo꞉ kaluka꞉isaleya꞉ dagiya꞉lo꞉ di we, ne bidila꞉sa꞉ga꞉, ho꞉len o꞉talena wa꞉ka dialifa꞉no꞉. Ho꞉gi a꞉dialifa꞉no꞉ a꞉no꞉, kaluka꞉isaleya꞉ dagiya꞉yo꞉ mo꞉dia꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ko꞉sega ililo꞉ to a꞉la꞉do꞉ sio꞉ a꞉ma꞉yo꞉lo꞉ mo꞉imilo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Bobalo꞉ so꞉mea꞉sen misa꞉ kaluwo꞉ milifa kagafo꞉liki, Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ililo꞉ gemo꞉lo꞉ diga꞉li sa꞉lab we, giyo꞉ a꞉ma꞉la꞉bo꞉ mo꞉sa꞉ma꞉no꞉lo꞉bo꞉?” ");
INSERT INTO bco_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ a꞉ma꞉la꞉ towo꞉ mo꞉sio꞉. A꞉la꞉ta꞉ga꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉yo꞉ Ya꞉sumo꞉ wa꞉ka dabu ba꞉daki, “Ge Godeya꞉lo꞉ Da꞉feyo꞉ kalu, nili wabuluna꞉ so꞉wayo꞉ geyo꞉?” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","A꞉la꞉dabu ba꞉dabiki, Ya꞉su e sa꞉lakiyo꞉, “A꞉no꞉ neka꞉! Gio꞉ tif amio꞉ Kalule Dowo꞉ ne, Gode Halaido꞉lelo꞉ a꞉lab a꞉ma꞉ dagi ililiba sena ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ tif amio꞉ akin halona a꞉la꞉ta꞉ga꞉ kola꞉ wa꞉la tindaliki ba꞉ba꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ya꞉suwa꞉yo꞉ a꞉la꞉sa꞉labiki da꞉da꞉sa꞉ga꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉yo꞉ e kulufa꞉yaki, ene so꞉g kafo꞉len a꞉no꞉ gegedela꞉. Eyo꞉ a꞉la꞉sio꞉, “Niliyo꞉ mada kalu nolbo꞉wo꞉ a꞉dabu keda꞉so꞉bo! ");
INSERT INTO bco_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya꞉su eyo꞉, ‘ne Godeya꞉ So꞉waka꞉’ a꞉la꞉sa꞉labiki, eyo꞉ o꞉ma Godeya꞉ wiyo꞉ dio꞉ge sa꞉lab. A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ a꞉no꞉ da꞉da꞉ga꞉yo꞉ waga asulaya?” A꞉la꞉dabu ba꞉dabiki, iyo꞉ tambowa꞉yo꞉ a꞉la꞉sio꞉, “Ya꞉su eyo꞉ Godeyo꞉ o꞉ma dio꞉ge sa꞉lab ko꞉lo꞉ e soma꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","A꞉la꞉ta꞉ga꞉ kalu nolba꞉yo꞉ e kodofela꞉sa꞉ga꞉ ami, e siyo꞉ helebeso꞉ga꞉ mele alita꞉sa꞉ga꞉, e a꞉na sa꞉ndakiyo꞉, “Kalu gelo꞉ sa꞉ndabko giyo꞉ ho꞉le ba꞉daki wiyo꞉ sama” a꞉la꞉sio꞉. A꞉la꞉ta꞉ga꞉ da꞉la꞉di kalu i a꞉namilo꞉ elen a꞉ma꞉yo꞉ e gasilia꞉sa꞉ga꞉ a꞉na sa꞉nda꞉i ane. ");
INSERT INTO bco_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bidayo꞉ baya elen ko꞉lo꞉, bobalo꞉ so꞉mea꞉sen misa꞉ kaluwa꞉ ene nanogdo꞉ dian ka꞉isale nowo꞉ a꞉na ya꞉sa꞉ga꞉, elo꞉wa fa꞉la꞉dowo꞉. E ya꞉sa꞉ga꞉, Bidayo꞉ de go꞉la꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","E dinafa ba꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Gelo꞉ Nasala꞉t kalu, Ya꞉su we o꞉lia꞉lo꞉ eleno꞉ nowo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko꞉sega Bida eyo꞉, “Ko nema. Ne gilo꞉ sa꞉labko mada babalab” a꞉la꞉sio꞉. Eyo꞉ a꞉la꞉sa꞉la꞉sa꞉ga꞉, ha꞉lu heb doba꞉da꞉ ha꞉na꞉ga꞉, tog aniba kagayo꞉. E a꞉na kagayabiki, gogonowo꞉ a꞉na go꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nanogdo꞉ dian ka꞉isale a꞉no꞉, Bida e wa꞉ka ba꞉da꞉sa꞉ga꞉, kalu i kagafo꞉lab nol o꞉mo꞉wo꞉ a꞉la꞉sio꞉, “Kalu we, e Ya꞉su o꞉lia꞉lo꞉ eleno꞉ nowo꞉ e” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bidaya꞉ wa꞉ka sa꞉laki, “Ko nemalo꞉ka꞉!” Ha꞉lu o꞉la꞉ga꞉, Bida o꞉lia꞉lo꞉ kagafo꞉len kalu nol a꞉ma꞉yo꞉ a꞉la꞉sio꞉, “Ge Ga꞉lili kalu ko꞉lo꞉ ge hendele Ya꞉su o꞉lia꞉lo꞉ eleno꞉ nowo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bida eyo꞉ mada a꞉la꞉sio꞉, “Niyo꞉ ko꞉lo꞉ mada do꞉lo꞉idaki sa꞉lalega, nemo꞉wo꞉ hida꞉yo꞉ nagalo꞉wo꞉ dimia꞉ib. Kalu gilo꞉ sa꞉labko, ne mada mo꞉ba꞉da꞉sen. Ko nemalo꞉ka꞉!” ");
INSERT INTO bco_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Wigibo a꞉naka, gogonowo꞉ wa꞉ka go꞉no꞉. Gogonowo꞉ ganalabiki, Bidayo꞉ Ya꞉suwa꞉lo꞉ tamin amilo꞉ emo꞉lo꞉ to sio꞉ a꞉no꞉ a꞉asulo꞉, “Gogonowo꞉ andebo꞉ o꞉ganama꞉nigalikiyo꞉, giyo꞉ ne mo꞉asulo꞉ka꞉ a꞉la꞉bo꞉ otalen sa꞉ma꞉ib” a꞉la꞉sio꞉. Bidayo꞉ a꞉no꞉ ko꞉lo꞉ kele asulakiyo꞉, e a꞉na ya꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kea꞉fole bobalo꞉ so꞉mea꞉sen misa꞉ kaluwo꞉lo꞉, elelo꞉ wida꞉sen kaluwo꞉lo꞉, ko꞉go꞉do꞉ kaluwo꞉lo꞉ kegea꞉sa꞉ga꞉, iyo꞉ nenela꞉i ha꞉na꞉sa꞉ga꞉yo꞉ towo꞉ a꞉na saefa꞉. Iliyo꞉ Ya꞉suwo꞉ mela꞉sa꞉ga꞉yo꞉, tililia꞉ga꞉, Failatbo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Failat eyo꞉ Ya꞉sumo꞉wo꞉, “Ge Yu kaluka꞉isale a꞉ma꞉ misa꞉ kalu alano꞉ geya꞉le?” a꞉la꞉dabu ba꞉ba꞉. Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Go꞉no꞉n gio꞉sa sa꞉lale” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Bobalo꞉ so꞉mea꞉sen misa꞉ kalu a꞉ma꞉yo꞉ diga꞉li sa꞉lakiyo꞉, Ya꞉suwa꞉lo꞉ mo꞉dimido꞉wo꞉ modo꞉ ko꞉lo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Failat eyo꞉ Ya꞉sumo꞉ sa꞉laki, “Ililo꞉ to ko꞉li ko꞉lilo꞉ gemo꞉lo꞉ diga꞉li sa꞉lab hono, giyo꞉lo꞉ a꞉ma꞉la꞉ towo꞉ sa꞉ma꞉nigaya?” ");
INSERT INTO bco_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉ towo꞉ mo꞉sa꞉ma꞉no꞉ dowabiki, Failat e mada iligo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Tinio꞉ Ma꞉no꞉ ma꞉no꞉ ho꞉lendo꞉ dowab a꞉namio꞉, Failat eyo꞉ donayo꞉ tambo amio꞉ mano꞉ we au dimida꞉sen. Dibolo amilo꞉ to꞉lofo꞉len kalu nowo꞉ sili alifoma꞉ki, kaluka꞉isalemo꞉wo꞉ dabu ba꞉da꞉sen ko꞉lo꞉, iliyo꞉ kalu imilig nowo꞉ da꞉fe sa꞉lab amio꞉, da꞉fe sio꞉ kalu a꞉no꞉ ko꞉lo꞉ sili alita꞉sen. ");
INSERT INTO bco_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","O꞉g a꞉namio꞉, kalu nowo꞉ dibolowa sen, ene wiyo꞉ Balabas. E kalu sa꞉nda꞉likilo꞉, gamani kalu o꞉lia꞉lo꞉ gisdo꞉ dia꞉seno꞉ nowo꞉ e. ");
INSERT INTO bco_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","A꞉la꞉fo꞉ko꞉lo꞉ dibolo kalu nowo꞉ ha꞉la꞉ya sili alifoma꞉ki, kaluka꞉isaleya꞉yo꞉ Failatbo꞉ da꞉ba꞉ni mio꞉. “O꞉g ho꞉len wenamio꞉, gilo꞉ dimida꞉sen o꞉leaumbo꞉ dimidama꞉nigaya?” a꞉la꞉liki dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Failat eyo꞉ kaluka꞉isalemo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giliyo꞉ Yu kaluka꞉isale a꞉ma꞉ misa꞉ alan kalu we sili alifoma꞉ki asulaya?” ");
INSERT INTO bco_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Eyo꞉ a꞉la꞉asulo꞉, Ya꞉su o꞉lia꞉lo꞉ gadiab a꞉no꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu a꞉ma꞉ ili gadia꞉sa꞉ga꞉ tililia꞉ mio꞉lo꞉b, a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko꞉sega bobalo꞉ so꞉mea꞉sen misa꞉ kalu iliyo꞉ kaluka꞉isaleya꞉ asulo꞉wo꞉ digidalifelakiyo꞉ a꞉la꞉sio꞉, “Giliyo꞉ Failat emo꞉wo꞉ Balabaso꞉ ko꞉lo꞉ sili alifoma, a꞉la꞉sama.” ");
INSERT INTO bco_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Failat eyo꞉ imo꞉ sa꞉laki, “Yu kaluka꞉isaleya꞉ misa꞉ kaluka꞉ a꞉la꞉do꞉ sa꞉lab emo꞉wo꞉, niyo꞉ waga dimidama꞉ki asuladi?” ");
INSERT INTO bco_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","A꞉la꞉dabu ba꞉dabiki, iliyo꞉ halale sa꞉laki a꞉la꞉sio꞉, “E i malana aluma! E i malana sana soma!” ");
INSERT INTO bco_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","A꞉la꞉sa꞉labiki Failat eyo꞉ imo꞉ dabu ba꞉ba꞉, “Elo꞉ mogago꞉ dimido꞉wo꞉ o꞉ba?” a꞉la꞉dabu ba꞉ba꞉. Ko꞉sega iliyo꞉ ogolo ho꞉le sa꞉laki, “E i malana aluma! E i malana sana soma!” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Failat eyo꞉ kaluka꞉isale kegeo꞉ a꞉no꞉ ko꞉lo꞉ sagalema꞉ki asulakiyo꞉, Balabas e ha꞉la꞉ya sili alita꞉sa꞉ga꞉, Ya꞉suwo꞉ da꞉la꞉di kaluwa꞉ me olo꞉wa꞉ sa꞉nda꞉sa꞉ga꞉, da꞉la꞉di kalu nolbo꞉ i malana sana sowaka aluma꞉ki tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Da꞉la꞉di kalu nol a꞉ma꞉yo꞉ Ya꞉suwo꞉ tililia꞉ga꞉, Failatdo꞉ sen galala꞉ nowa tililia꞉ tiane. (Galala꞉ a꞉ma꞉ wiyo꞉ Ba꞉la꞉toliam.) A꞉na tililia꞉sa꞉ga꞉, da꞉la꞉di kaluwo꞉ tambo ho꞉le kegeo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kegea꞉sa꞉ga꞉yo꞉ iliyo꞉ so꞉g ho꞉mo꞉solo꞉ sambo nowo꞉ Ya꞉suwa kalita꞉sa꞉ga꞉, me olo꞉ a꞉no꞉ hega꞉sa꞉ga꞉, Ya꞉suwa꞉ misa꞉ a꞉na sa꞉ga꞉li alifa꞉. Iliyo꞉ Ya꞉su e misa꞉ kalu a꞉la꞉liki dio꞉ge sio꞉ ");
INSERT INTO bco_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Iliyo꞉ emo꞉wo꞉ dio꞉ge sa꞉laki, “Ge Yu kaluka꞉isaleya꞉ misa꞉yo꞉ ge” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","A꞉la꞉ta꞉ga꞉ iliyo꞉ Ya꞉suwa꞉ misa꞉yo꞉ i bolodowa꞉ bese tandea꞉sa꞉ga꞉, e kodofa꞉ fugalo꞉. A꞉la꞉ta꞉ga꞉ iyo꞉ e milifa gulalu misa꞉fu alilaki, e wiyo꞉ madali wabulu sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","A꞉la꞉dimida꞉la꞉ga꞉ ta꞉takiyo꞉, so꞉g ho꞉mo꞉solo꞉ ko꞉lo꞉ Ya꞉su amilo꞉ kalifa꞉ a꞉no꞉ dugulia꞉ga꞉ dia꞉taki, enedo꞉leyo꞉ a꞉na kalifa꞉. So꞉g a꞉no꞉ kalita꞉sa꞉ga꞉yo꞉, e sa꞉ma꞉niki ha꞉la꞉ya tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Alegsanda dia꞉ Lufus dia꞉ma꞉ iya Saimon, a꞉no꞉ Sailini kalu ko꞉lo꞉, e toga ya꞉len ami, da꞉la꞉di kaluwa꞉yo꞉ e usa galilia꞉sa꞉ga꞉, Ya꞉suwa꞉ i malan a꞉no꞉ emo꞉ dia꞉hamana꞉ki dibodo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ya꞉su e Golgoda hen a꞉na tililia꞉gane. Golgoda a꞉la꞉do꞉ sa꞉lab a꞉ma꞉ ha꞉go꞉ we, Hen Misa꞉ki. ");
INSERT INTO bco_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wain ho꞉n o꞉lia꞉ mulumulo꞉ o꞉lia꞉ wo꞉gela꞉sa꞉ga꞉, nagalo꞉wo꞉ bulufoma꞉ki dimi ko꞉sega, eyo꞉ mo꞉mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","A꞉la꞉ta꞉ga꞉ iliyo꞉ e i malana alu alifa꞉. I malana alula꞉sa꞉ga꞉, helebeso꞉g elo꞉ a꞉no꞉, da꞉la꞉di kalu iliyo꞉ abe dia꞉nigaba꞉le a꞉la꞉liki, iliyo꞉ ibuwo꞉ a꞉na heyo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kea꞉fo ofa꞉siyo꞉ agado꞉wa dowabiki, iliyo꞉ Ya꞉suwo꞉ i malan amio꞉, a꞉na alu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iliyo꞉ e mo꞉walilakilo꞉ sana sowab a꞉ma꞉ mo꞉ a꞉no꞉ ko꞉lo꞉ sa꞉sa꞉lo꞉, Yu kaluka꞉isaleya꞉ Misa꞉ Kalu Alandeyo꞉ we a꞉la꞉liki sa꞉sa꞉lo꞉ ko꞉lo꞉, e misa꞉ wa꞉ldo꞉ a꞉na alu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","A꞉la꞉ta꞉ga꞉ Ya꞉su e o꞉lia꞉yo꞉ mogago꞉ kalu a꞉la꞉ nowo꞉ e aniba alu. Nowo꞉ ililiba, nowo꞉ fo꞉fo꞉doloba a꞉la꞉alu alifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","30","Kaluka꞉isale iyo꞉ Ya꞉sulo꞉ alu alifa꞉ a꞉na tinia꞉likiyo꞉, mogago꞉ towo꞉ Ya꞉sumo꞉ sa꞉la꞉liki tinia꞉len. Iliyo꞉ misa꞉yo꞉ mumalola꞉likiyo꞉ dio꞉ge sio꞉, “Giyo꞉ Godeya꞉ malilo꞉ ayo꞉ bidila꞉sa꞉ga꞉, ho꞉len otalen amio꞉ ho꞉gi dia꞉la꞉ga꞉, disandala꞉ma꞉no꞉ka꞉ a꞉la꞉sio꞉ ko꞉lo꞉, go꞉no꞉na꞉ma꞉la꞉yo꞉ asuwa꞉takiyo꞉, ge timena,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Bobalo꞉ so꞉mea꞉sen misa꞉ kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉yo꞉, egele nenelakiyo꞉ a꞉la꞉dio꞉ge sio꞉, “Eyo꞉ kaluka꞉isale nolo꞉ asuwa꞉ta꞉sen ko꞉sega, enena꞉ma꞉la꞉yo꞉ mo꞉asuwa꞉tabo꞉lo꞉ka꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E hendele Isolael kaluka꞉isaleya꞉ misa꞉, Godeya꞉lo꞉ Da꞉feyo꞉ kaluwo꞉ elalega, e i malan amilo꞉ alu alifo꞉lab a꞉no꞉ ta꞉ta꞉sa꞉ga꞉ timena. Eyo꞉ a꞉la꞉dimidalega, niliyo꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, e amio꞉ o꞉li tili da꞉ba꞉no꞉.” A꞉la꞉ta꞉ga꞉ kalu a꞉la꞉ e o꞉lia꞉lo꞉ alu alifa꞉ a꞉ma꞉yo꞉lo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉ka dio꞉ge sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Disi dowabiki, hen a꞉no꞉ tambo sololiya꞉ go꞉lula꞉ta꞉ga꞉lo꞉ eleno꞉, ga꞉lo ofa꞉siyo꞉ asola dowabi edo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ofa꞉siyo꞉ asola dowabiki, Ya꞉su eyo꞉ ogolo halale ho꞉idakiyo꞉, “Eloi, Eloi, lama sabag tani.” To wema꞉ ha꞉go꞉ we, “Ni Gode, ni Gode, giyo꞉ ne wangabiki gola ba꞉daya?” ");
INSERT INTO bco_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","E anib amilo꞉ kaluka꞉isale nol ko꞉lo꞉ elen a꞉ma꞉yo꞉ to a꞉no꞉ da꞉da꞉ga꞉yo꞉ a꞉la꞉sio꞉, “Dabuma! Eyo꞉ Elaiyayo꞉ ho꞉idab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kalu nowo꞉ nai ha꞉na꞉ga꞉, wain ho꞉n sesedo꞉ a꞉no꞉ igala꞉ gelelia꞉ga꞉, a꞉ma꞉la꞉ ya꞉ga꞉, da꞉fa꞉ya mela꞉sa꞉ga꞉ emo꞉ maiya꞉ki dimi. “E Elaiya eyo꞉ i malan amilo꞉ alu a꞉no꞉ tagalia꞉ tima꞉nigaba꞉le, nio꞉ o꞉bo꞉fo꞉mela꞉niki” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ya꞉suwo꞉ halale ho꞉ida꞉sa꞉ga꞉, ha꞉fo꞉wo꞉ a꞉na siliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Helebeso꞉g ko꞉lo꞉ Godeya꞉ malilo꞉ ayamilo꞉ dehedo꞉ a꞉no꞉ iwalu halona a꞉la꞉ta꞉ga꞉ usa ba꞉da꞉i tia꞉yo꞉, migifde hen amilo꞉ wena asula꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Da꞉la꞉dilo꞉ bo꞉fo꞉lowan kalu Ya꞉suwa꞉ anib amilo꞉ kagafo꞉len a꞉ma꞉yo꞉ Ya꞉suwo꞉ sowakilo꞉ sio꞉wo꞉ da꞉da꞉sa꞉ga꞉, eyo꞉ a꞉la꞉sio꞉, “Hendele, kalu we Godeya꞉ ene so꞉walelo꞉ka꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ka꞉isale nolo꞉ ha꞉lu ko꞉na꞉ kagafo꞉liki, dimidab a꞉no꞉ko꞉ bo꞉fo꞉len. Ka꞉isale egelelo꞉ elen a꞉no꞉ nowo꞉ Malia Magdala, nowo꞉ Ya꞉ma꞉s o꞉so꞉wa o꞉lia꞉ Yose o꞉lia꞉ a꞉la꞉ma꞉ anowo꞉ Malia, nowo꞉ Salome ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ya꞉suwo꞉ Ga꞉lili hen a꞉na sia꞉lab amio꞉, ka꞉isale i a꞉no꞉ e o꞉lia꞉lo꞉ sia꞉likilo꞉ asuwa꞉ta꞉leno꞉ i we. A꞉la꞉ta꞉ga꞉ ka꞉isale nolo꞉ modo꞉ ko꞉lo꞉ Ya꞉su o꞉lia꞉lo꞉ Ya꞉lusalemdo꞉ mio꞉ i a꞉no꞉lo꞉ a꞉na elen. ");
INSERT INTO bco_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Aliyo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉no꞉ fa꞉la꞉doma꞉ib ko꞉lo꞉, o꞉g ho꞉len wenamio꞉, a꞉no꞉ ko꞉lo꞉ dimidaefa꞉no꞉ dowo꞉ ko꞉lo꞉lab. Alimatea kalu, Yosa꞉b e Yu amilo꞉ ganisolo kalu nowo꞉ e ko꞉lo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len fa꞉la꞉dowab a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉no꞉wo꞉ e sagala꞉liki yasisen. A꞉la꞉fo꞉ko꞉lo꞉ ga꞉lowo꞉ o꞉doma꞉nigabiki, e Failatdo꞉wa ha꞉na꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉ do꞉mo꞉wo꞉ tagalia꞉ ha꞉na꞉no꞉ a꞉la꞉liki, dabu ba꞉ba꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Failat e Ya꞉suwo꞉ sowo꞉ka꞉ a꞉la꞉ da꞉da꞉sa꞉ga꞉, mada iliga꞉sa꞉ga꞉, eyo꞉ da꞉la꞉di kalumo꞉wo꞉ a꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Da꞉la꞉di kalu eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “A꞉ hendele, Ya꞉su e sowo꞉ ko꞉m” a꞉la꞉sa꞉labiki, Failat eyo꞉ Yosa꞉bo꞉ sa꞉laki, “Ya꞉suwa꞉ do꞉mo꞉wo꞉ tagama꞉ni hamana” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","A꞉la꞉sa꞉labiki da꞉da꞉sa꞉ga꞉yo꞉, Yosa꞉b eyo꞉ helebeso꞉g nafaleyo꞉ kililia꞉ ha꞉na꞉ga꞉yo꞉, Ya꞉suwa꞉ do꞉mo꞉wo꞉ tagalia꞉ga꞉ dia꞉tia꞉. Do꞉mo꞉wo꞉ helebeso꞉g nafale a꞉ma꞉ bobodolia꞉ga꞉, kalu sowo꞉lo꞉ dia꞉fa꞉no꞉ u no꞉no꞉ usa difa꞉. U no꞉no꞉ usa dia꞉ta꞉sa꞉ga꞉, toga꞉me amio꞉ u bamo alan nowo꞉ fo꞉fo꞉gola꞉i ya꞉sa꞉ga꞉ a꞉na asibalifa꞉. ");
INSERT INTO bco_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ya꞉sulo꞉ dia꞉fa꞉ni ha꞉nab a꞉no꞉, Malia Magdala o꞉lia꞉ Yose ano Malia o꞉lia꞉yo꞉ a꞉no꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","2","Ha꞉fo꞉lo꞉ Dowan ho꞉leno꞉ edabikiyo꞉, Malia Magdalayo꞉, Ya꞉ma꞉sa꞉ ano Maliayo꞉, a꞉la꞉ta꞉ga꞉ Salomeyo꞉ iliyo꞉ wa ho꞉n mundo꞉ nafayo꞉ Ya꞉suwa꞉ do꞉mo꞉wa dia꞉fa꞉no꞉ a꞉la꞉ta꞉ga꞉ kilili ko꞉lo꞉, doma꞉ kea꞉fo, ofo꞉ fa꞉la꞉dota꞉ga꞉ so꞉so꞉labikiyo꞉, iyo꞉ toga ha꞉nakiyo꞉ ");
INSERT INTO bco_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","egelebo꞉ a꞉la꞉sio꞉, “U alana꞉lo꞉ ifa꞉ a꞉no꞉, a꞉ma꞉la꞉bo꞉ abe fo꞉fo꞉goloma꞉nigaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Iyo꞉ ha꞉na꞉sa꞉ga꞉, u no꞉no꞉lo꞉ a꞉no꞉ ko꞉na꞉ma dowaki ba꞉ba꞉ amio꞉, u no꞉no꞉ amilo꞉, u alan a꞉no꞉ fo꞉fo꞉golofa꞉ya ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ba꞉da꞉sa꞉ga꞉, iyo꞉ u no꞉no꞉ us a꞉na tiane. Iyo꞉ a꞉na tiane amio꞉, kalu so꞉wa nowo꞉, helebeso꞉g ho꞉lo꞉wa꞉ momadelia꞉ga꞉, dagi ililiba sena ba꞉ba꞉. Ba꞉da꞉sa꞉ga꞉ iyo꞉ mada iligo꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kalu a꞉ma꞉ sa꞉laki, “Gio꞉ iligakiyo꞉ tagila꞉so꞉bo! Gio꞉ Nasala꞉t Ya꞉su so꞉no꞉ difa꞉ weno꞉ ko꞉lo꞉ ba꞉ba꞉ni mio꞉. Ko꞉sega e o꞉ma dasilia꞉gane. E wilo꞉ma. Elo꞉ difa꞉ we, gio꞉ bo꞉ba. ");
INSERT INTO bco_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ko꞉sega gio꞉ a꞉ma꞉la꞉ ha꞉na꞉ga꞉, Bidayo꞉ a꞉la꞉ta꞉ga꞉ enedo꞉ tiliwida꞉sen kalu nolbo꞉wo꞉lo꞉ a꞉la꞉sa꞉la꞉bi, ‘Ga꞉liliyo꞉ e ko꞉le tamina ha꞉nab ko꞉lo꞉, gio꞉ e a꞉na galima꞉ib. Tamin amilo꞉ enedo꞉ gimo꞉lo꞉ sio꞉ o꞉lea꞉ngab,’” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Iyo꞉ kiyo꞉ bibisoda꞉sa꞉ga꞉, asugo꞉ babale dowabiki, ha꞉la꞉ya handalota꞉ga꞉ dalaido꞉. Iyo꞉ tagi dalaidakiyo꞉, kalu nolbo꞉wo꞉ mo꞉malolome. ");
INSERT INTO bco_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ya꞉suwo꞉ doma꞉ kea꞉fole dasilia꞉ga꞉, Malia Magdala elo꞉ amio꞉ tamina handalowo꞉. Ga a꞉no꞉ tamin amio꞉ mama mogago꞉ dom a꞉la꞉fo꞉wo꞉ eya elen ko꞉lo꞉, Ya꞉su e o꞉luga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A꞉la꞉ta꞉ga꞉ kaluka꞉isale Ya꞉su o꞉lia꞉lo꞉ sia꞉sen a꞉no꞉ nofolaki ya꞉la꞉li sen ami, Malia eyo꞉ Ya꞉suwo꞉ ba꞉ba꞉ ko꞉lo꞉, e ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowakiyo꞉ imo꞉ malolome. ");
INSERT INTO bco_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Malia eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ya꞉suwo꞉ mela꞉no꞉wo꞉ dia꞉sa꞉ga꞉ dasilia꞉ ha꞉nabiki, ni ba꞉ba꞉” a꞉la꞉likiyo꞉, imo꞉wo꞉ malolome ko꞉sega, iliyo꞉ to elo꞉ sio꞉ a꞉no꞉ mo꞉tilidabu. ");
INSERT INTO bco_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tif amio꞉ Ya꞉suwa꞉ enedo꞉ tili wida꞉sen kalu a꞉la꞉yo꞉ ilaboda꞉ ha꞉na꞉len amio꞉, Ya꞉su e do꞉mo꞉wo꞉ ko꞉li dota꞉ga꞉, a꞉la꞉lo꞉ a꞉na handalowo꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","A꞉la꞉yo꞉ a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, Ya꞉suwa꞉ enedo꞉ tili wida꞉sen kalu nolbo꞉wo꞉ sio꞉ ko꞉sega, iliyo꞉ a꞉la꞉ma꞉lo꞉ to sa꞉lab a꞉no꞉lo꞉ mo꞉tilidabu. ");
INSERT INTO bco_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Tif amio꞉ Ya꞉suwo꞉ ha꞉na꞉sa꞉ga꞉, tili wida꞉sen kalu kelen a꞉la꞉fo꞉lo꞉ ma꞉n na꞉likilo꞉ sendo꞉ a꞉naka handalowo꞉. Iliyo꞉ Ya꞉suwo꞉ a꞉ma꞉la꞉ dasika꞉ a꞉la꞉likilo꞉, nolba꞉lo꞉ ba꞉ba꞉ sa꞉lab a꞉no꞉ mo꞉tilidabu ko꞉lo꞉, iyo꞉ mo꞉tilidabu a꞉na ilikiyo꞉, Ya꞉su eyo꞉ mo꞉beo꞉ towo꞉ imo꞉wo꞉ a꞉na sio꞉. ");
INSERT INTO bco_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","To a꞉no꞉ sa꞉la꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ henfelo꞉ we tambo sia꞉likiyo꞉, ni to nafa we kaluka꞉isaleyo꞉ tambo dabuma꞉ki, walasa꞉ma꞉ni hamana! ");
INSERT INTO bco_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Kaluka꞉isale abeyo꞉ to gilo꞉wo꞉ tilida꞉da꞉sa꞉ga꞉ ho꞉na to꞉lolalega, niyo꞉ e a꞉ma꞉la꞉ gasilia꞉no꞉. Ko꞉sega kaluka꞉isale abeyo꞉ to a꞉no꞉ mo꞉tilida꞉dalega, Gode eyo꞉ mo꞉walilaki falasila꞉ma꞉ib ");
INSERT INTO bco_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tilidabu kaluka꞉isale iliyo꞉ nanog dimidalikiyo꞉, e amilo꞉ ele ba꞉ba꞉no꞉wo꞉ we o꞉ngo꞉ fa꞉la꞉doma꞉ib. Iyo꞉ ne wi halaido꞉ a꞉na ilikiyo꞉, mama mogago꞉ dowab a꞉no꞉ o꞉luga꞉felema꞉ib. A꞉la꞉ta꞉ga꞉ to ho꞉gi ko꞉li ko꞉lilo꞉wo꞉ ili mego꞉fa sahandaloma꞉ib. ");
INSERT INTO bco_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Iliyo꞉ kisa꞉wa꞉lo꞉ ga꞉li ta꞉li doma꞉ib. A꞉la꞉ta꞉ga꞉ iso꞉lo ibo꞉ nalikiyo꞉, iyo꞉ mo꞉mogagila꞉ma꞉ib. Iliyo꞉ walaf kaluwa꞉ do꞉mo꞉wa golalikiyo꞉, walafo꞉ falele alita꞉mela꞉ib.” ");
INSERT INTO bco_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Alan Ya꞉su eyo꞉ imo꞉wo꞉ towo꞉ sa꞉la꞉sa꞉ga꞉ dotabiyo꞉, Gode eyo꞉ e Hebene halona dia꞉gane ko꞉lo꞉, Ya꞉su e Godeya꞉ ene dagi ililiba mesa꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","A꞉la꞉ta꞉ga꞉yo꞉ Ya꞉suwa꞉ enedo꞉ tili wida꞉len kaluwo꞉ ha꞉na꞉siakiyo꞉, to nafa a꞉no꞉ heno꞉ tambo amio꞉ wida꞉liki sia꞉len. Iliyo꞉ to nafa a꞉no꞉ widab amio꞉, Alan Ya꞉su eneno꞉ i o꞉lia꞉ dowaki, kaluka꞉isaleyo꞉ ili to a꞉no꞉ hendele tilidabuma꞉kiyo꞉, molo ha꞉na꞉no꞉wo꞉ a꞉na dimida꞉li sia꞉len. ");
INSERT INTO bco_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Gode Elo꞉ o꞉gdo꞉ ni us amilo꞉ hendele fa꞉la꞉do alifelo꞉ a꞉no꞉ Godeya꞉ ene nanog dian kaluwa꞉ inin siya꞉lo꞉ ba꞉da꞉i mio꞉ a꞉no꞉ ko꞉lo꞉ widabiki, kalu nolba꞉yo꞉ towo꞉ a꞉na sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ to tamin amilo꞉ sa꞉la꞉i mio꞉ a꞉no꞉ agele ba꞉da꞉ga꞉yo꞉, niyo꞉ malolo꞉ a꞉no꞉ dinafa sa꞉sa꞉lo꞉ ko꞉lo꞉, kalu alan, Tiofelas giyo꞉ to we agelema꞉ki, gemo꞉ sa꞉sa꞉liga꞉fa꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Gemo꞉lo꞉ to wido꞉ a꞉no꞉ giyo꞉ hendele a꞉la꞉asuluma꞉ki, niyo꞉ to we a꞉na sa꞉sa꞉liga꞉to꞉l. ");
INSERT INTO bco_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ha꞉lod e misa꞉ kalu iliki, Yudia hendo꞉ bo꞉fo꞉len ho꞉len a꞉namio꞉, bobalo꞉ so꞉mea꞉sen kalu nowo꞉, ene wiyo꞉ Sekalaya ko꞉lo꞉ elen. E Abiyaya꞉ eso꞉lo꞉wa a꞉la꞉ta꞉ga꞉ mio꞉ ko꞉lo꞉, nanogo꞉ diakiyo꞉, Abiyaya꞉ eso꞉lo꞉ o꞉lia꞉ egele dia꞉sen. A꞉la꞉ta꞉ga꞉ ene inga Elisabed elo꞉ A꞉lona꞉ ene so꞉lo꞉wa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A꞉la꞉yo꞉ Godeya꞉ ele saefa꞉ o꞉lia꞉ ene to man o꞉lia꞉yo꞉ mada tambo kudu ha꞉na꞉liki, Godeya꞉ si wa꞉l amio꞉ a꞉la꞉yo꞉ digalo꞉ ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ko꞉sega Elisabed e faino dowabiki, a꞉la꞉yo꞉ so꞉walo꞉ma, anaso꞉ ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ho꞉len no amio꞉ Sekalaya e o꞉lia꞉lo꞉ nanogdo꞉ dia꞉sen kalu iyo꞉ nanogo꞉ dimidabikiyo꞉, Sekalaya eyo꞉lo꞉ Godeya꞉ siwa꞉l amio꞉ bobalo꞉ so꞉mea꞉sen nanog a꞉no꞉ dimido꞉. Iliyo꞉ bobalo꞉ so꞉mea꞉sen kaluwa꞉ man a꞉no꞉ ko꞉lo꞉ kudu ha꞉naki, Godeya꞉ malilo꞉ a us a꞉namilo꞉ mundo꞉ so꞉fea꞉no꞉ a꞉no꞉ abe tina꞉nigaba꞉le a꞉la꞉liki, Godemo꞉ da꞉fema꞉ki, iyo꞉ ibuwo꞉ a꞉na goda꞉sa꞉ga꞉ sili ko꞉lo꞉, Sekalaya e tiniabiki, malilo꞉ a usamio꞉ e tiane. ");
INSERT INTO bco_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Mun nafalo꞉ da꞉ba꞉no꞉ ho꞉lendeyo꞉ fa꞉la꞉dowabiki, Isolael kaluka꞉isaleyo꞉ ha꞉la꞉ya kegea꞉sa꞉ga꞉, Godemo꞉ dulugu sa꞉la꞉labikiyo꞉, Sekalaya e mundo꞉ da꞉ba꞉no꞉ a꞉no꞉ so꞉fa꞉ni tiane. ");
INSERT INTO bco_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","E a usa sofea꞉liki ba꞉ba꞉ amio꞉, Godeya꞉ ma꞉mula꞉ kalu imilise nowo꞉, mun nafalo꞉ so꞉mea꞉sen mu gulu ililib doba꞉da꞉ kagafo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekalaya e ba꞉da꞉sa꞉ga꞉ iligakiyo꞉, tagio꞉ alan dowo꞉ ");
INSERT INTO bco_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ko꞉sega ma꞉mul kalu eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Sekalaya, ge tagila꞉so꞉bo! Gilo꞉ Godemo꞉lo꞉ dulugu sio꞉wo꞉ Eyo꞉ dabu ko꞉lo꞉, ga꞉ ga Elisabed eyo꞉ kalu so꞉wayo꞉ sa꞉la꞉lia꞉ib. Giyo꞉ so꞉wa a꞉no꞉ wiyo꞉ Yo꞉n wikila꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","So꞉wa gilo꞉ sa꞉la꞉lia꞉nigab a꞉ma꞉yo꞉, ga꞉go꞉ mada sagale alifa꞉ib. Godeya꞉ si wa꞉l amio꞉ e halaido꞉ doma꞉ib ko꞉lo꞉, e sa꞉la꞉lialikiyo꞉, kaluka꞉isale modo꞉wo꞉ sagalema꞉ib. E wain ho꞉n o꞉lia꞉ aluna꞉ ho꞉n o꞉lia꞉yo꞉ mea꞉so꞉bo. E anowa꞉yo꞉ sa꞉la꞉lialikiyo꞉, Mama Malilo꞉ a꞉no꞉ e amio꞉ wa꞉lifo꞉ a꞉no꞉ko꞉ dofo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A꞉la꞉ta꞉ga꞉ eyo꞉ Isolael kaluka꞉isale modo꞉wo꞉ nodoma꞉ki dimida꞉sa꞉ga꞉, Gode Alan inido꞉le a꞉no꞉ a꞉na tililia꞉ mia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Eyo꞉ Elaiyaya꞉ man o꞉lia꞉ halaido꞉ o꞉lia꞉yo꞉ o꞉ngo꞉ ko꞉lo꞉ dia꞉ga꞉ fa꞉la꞉dowalikiyo꞉, eyo꞉ Alano꞉ mea꞉nigaka꞉ a꞉la꞉likiyo꞉ tamina ha꞉na꞉ib. Yo꞉n eyo꞉ iya ima꞉yo꞉ so꞉wa o꞉lia꞉yo꞉ ha꞉fa꞉nolo mesea꞉ki ta꞉fa꞉ib. A꞉la꞉ta꞉ga꞉ eyo꞉ yo꞉le dosodan kalu nolo꞉ asulo꞉ ilido꞉wo꞉ a꞉ma꞉la꞉ nodo alitalikiyo꞉, iyo꞉ digalo꞉ kaluwa꞉ man a꞉no꞉ ko꞉lo꞉ kudu hamana꞉ki ta꞉fa꞉ib. Kaluka꞉isaleyo꞉ Alan mia꞉nigab a꞉no꞉ ko꞉lo꞉ dimidalima꞉ki, Yo꞉n e a꞉na mia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ma꞉mul kaluwa꞉yo꞉ a꞉la꞉sa꞉labiki, Sekalaya eyo꞉ ma꞉mul kalumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Na꞉no꞉ anaso꞉ ko꞉lo꞉ niyo꞉ to gilo꞉ sa꞉lab ko hendele fa꞉la꞉doma꞉ib a꞉la꞉bo꞉, waga a꞉la꞉ ba꞉ba꞉no꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ma꞉mul kalu eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Ne Ga꞉biol. Ne Godeya꞉ ene wo꞉lokan amilo꞉ dowa꞉seno꞉ ne ko꞉lo꞉, to nafa we ge dabuma꞉ki, Gode eyo꞉ ne wena iliga꞉fo꞉ ko꞉lo꞉ sa꞉ma꞉ni mio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ge nilo꞉ to so꞉lo꞉l we mo꞉tilida꞉dab ko꞉lo꞉, o꞉go꞉ ge do꞉fo꞉f dowaki, towo꞉ mo꞉toma꞉ib. To nilo꞉ so꞉lo꞉l we hendele fa꞉la꞉dowalikiyo꞉, ge towo꞉ a꞉na a꞉tola꞉ma꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","A꞉no꞉ elo꞉wa fa꞉la꞉dowabiki, kaluka꞉isale iliyo꞉ Sekalaya e yasisen ko꞉sega, ofa꞉si modo꞉wo꞉ Sekalaya e malilo꞉ a us a꞉naka o꞉a꞉labiki, iliyo꞉ wangaba꞉le a꞉la꞉liki kele asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sekalaya e ha꞉la꞉ya handalowakiyo꞉, e mego꞉fo꞉ do꞉fo꞉f dowo꞉. Eyo꞉ towo꞉ mo꞉tolaki, imo꞉wo꞉ dagiya꞉ da꞉feabiki, ili asulakiyo꞉, e malilo꞉ a us a꞉namio꞉ kelego꞉ nowo꞉ ho꞉le ba꞉ba꞉lo꞉b a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","A꞉la꞉ta꞉ga꞉ nanog elo꞉ a꞉namilo꞉ dia꞉no꞉wo꞉ kedetabiki, Sekalaya e a꞉ma꞉la꞉ ene hena ane. ");
INSERT INTO bco_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","25","A꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, ene aya sen amio꞉, inga Elisabedo꞉ so꞉wayo꞉ a꞉na alelo꞉. Alela꞉sa꞉ga꞉yo꞉, Elisabed eyo꞉ a꞉la꞉sio꞉, “Kalu Alana꞉yo꞉ hendele nemo꞉wo꞉ nafale dimido꞉. Ne amilo꞉ kaluka꞉isaleya꞉lo꞉ sendelo alifa꞉ a꞉no꞉ ko꞉lo꞉ dilaki go꞉ ko꞉lo꞉, Gode eyo꞉ ne mada sagale alifa꞉.” Eyo꞉ a꞉la꞉asulakiyo꞉, e ele bila꞉fo꞉ a꞉namio꞉ ene a ka sen. ");
INSERT INTO bco_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabed e alelo꞉wo꞉ ele do꞉go꞉fe a꞉la꞉fo꞉wo꞉ dufulabiki, Gode eyo꞉ ma꞉mul kalu Ga꞉biol e amisa꞉n Nasala꞉t, Ga꞉lili hen a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Gode eyo꞉ ma꞉mul kalu e, ga bolo꞉ kalu o꞉lia꞉lo꞉ mo꞉alila꞉sen elo꞉wa iliga꞉fo꞉. Ga a꞉ma꞉ wiyo꞉ Malia ko꞉lo꞉ e kalumo꞉ samefo꞉len. Kalu a꞉ma꞉ wiyo꞉ Yosa꞉b. E Da꞉ibida꞉ ene eso꞉lo꞉wa a꞉la꞉ta꞉ga꞉ mio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ga꞉biolo꞉ ha꞉na꞉sa꞉ga꞉, Malialo꞉wa fa꞉la꞉dowaki a꞉la꞉sio꞉ “Malia, disi nafa. Gode eyo꞉ gemo꞉wo꞉ sagalaki, e ge o꞉lia꞉ sab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maliayo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉ iligakiyo꞉, to we o꞉bo꞉ngo꞉ sa꞉laigabele a꞉la꞉kele asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ko꞉sega ma꞉mul kaluwa꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉ “Malia, ge tagila꞉so꞉bo. Gode eyo꞉ ge o꞉lia꞉yo꞉ sagalo꞉wo꞉ alan dowab. ");
INSERT INTO bco_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ge so꞉wayo꞉ alela꞉sa꞉ga꞉, kalu so꞉wa sa꞉la꞉lia꞉ib. So꞉wa a꞉no꞉ giyo꞉ Ya꞉su wikila꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E kalu halaido꞉ doma꞉ib, a꞉la꞉ta꞉ga꞉ kaluka꞉isale iliyo꞉ e Gode Iwalulo꞉ A꞉lab a꞉ma꞉ so꞉waka꞉, a꞉la꞉sa꞉la꞉mela꞉ib. Gode Alan eyo꞉, e ma꞉mu Da꞉ibid misa꞉ kalu sen o꞉leaumbo꞉, elo꞉ misa꞉ kalu mesea꞉ki, da꞉fe alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ya꞉koba a꞉la꞉ta꞉ga꞉lo꞉ so꞉lo꞉ mio꞉ a꞉no꞉, Ya꞉su E misa꞉ dowaki bo꞉fo꞉mela꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ elo꞉ bo꞉fo꞉likilo꞉ ha꞉nab a꞉no꞉ mo꞉elema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","A꞉la꞉sa꞉labiki, Malia eyo꞉ ma꞉mul kalumo꞉ dabu ba꞉daki, “Ne ga bolo꞉, kaluwo꞉ o꞉semo꞉ ane ko꞉lo꞉, to gilo꞉ sa꞉lab ko waga fa꞉la꞉doma꞉iba꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ma꞉mul kaluwa꞉ a꞉ma꞉la꞉ sa꞉laki a꞉la꞉sio꞉, “Mama Malilo꞉ a꞉no꞉ gelo꞉wa mia꞉ib ko꞉lo꞉, Gode Iwalulo꞉ A꞉lab a꞉ma꞉ halaido꞉wa꞉yo꞉ ge go꞉lu alifa꞉ib. A꞉la꞉fo꞉ko꞉lo꞉ malilo꞉ so꞉wa gilo꞉ sa꞉la꞉liab a꞉no꞉, Godeya꞉ Ene So꞉waleka꞉ a꞉la꞉sa꞉la꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","A꞉la꞉ta꞉ga꞉ ge so꞉lo꞉ amilo꞉ Elisabed, e anaso꞉ dowo꞉ ko꞉sega, o꞉go꞉ e alelo꞉ ko꞉lo꞉ sab. Tamin amio꞉ e fainoka꞉ a꞉la꞉sa꞉la꞉sen ko꞉sega, o꞉go꞉ e alela꞉leno꞉ eleyo꞉ do꞉go꞉fela꞉fo꞉wo꞉ o꞉ma dufula꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Mo꞉wo꞉ Gode eyo꞉ kelego꞉ tambowo꞉ o꞉li dimidama꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","A꞉la꞉sa꞉labiki, Malia eyo꞉ a꞉la꞉sio꞉, “Ne Alana꞉ ene nanogdo꞉ dian ga ko꞉lo꞉, eyo꞉ gilo꞉ sa꞉lab ko aumbo꞉ nemo꞉wo꞉ ka dimidama꞉ib.” A꞉la꞉do꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, ma꞉mul kalu e a꞉na ta꞉fo꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma꞉mul kaluwo꞉ ta꞉ta꞉ga꞉ ho꞉no꞉go꞉labiki, Malia e dimidalia꞉sa꞉ga꞉, Yuda hen misio꞉lo꞉ dosdo꞉ a꞉namida꞉ amisa꞉n nowa bo꞉bo꞉ge ane. ");
INSERT INTO bco_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","E ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowakiyo꞉, Sekalaya ene aya tina꞉sa꞉ga꞉, sagalo꞉ towo꞉ Elisabedmo꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabed e Maliaya꞉lo꞉ sagalo꞉ to sa꞉lab a꞉no꞉ dabu amio꞉, so꞉wa ko꞉lo꞉ kufa꞉ usamilo꞉ sen holoma꞉yo꞉ iligaki nanogo꞉ dimidabiki, Mama Malilo꞉ a꞉no꞉ Elisabed amio꞉ wa꞉lifo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wa꞉lita꞉ga꞉, eyo꞉ towo꞉ halaido꞉ sa꞉laki, “Gode eyo꞉ ge mada sagale alifa꞉ ko꞉lo꞉ ka꞉isale nol sab we tambo, gi tininilab. So꞉wa gilo꞉ sa꞉la꞉lia꞉nigab ko, Gode eyo꞉ mada sagale alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ne mo꞉ililo꞉ ga ko꞉sega ni Kalu Alana꞉ ano ge nelo꞉wa ya꞉sa꞉ga꞉, giyo꞉ ne ko꞉lo꞉ sagale alifa꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sagalo꞉ to gilo꞉ sa꞉lab a꞉no꞉ ne dabu amio꞉, so꞉wa ni kufa꞉ usamilo꞉ sab wema꞉yo꞉ sagalaki iligi dasilab. ");
INSERT INTO bco_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Gode Elo꞉ gemo꞉lo꞉ to sio꞉ a꞉no꞉ hendele dimidama꞉ib a꞉la꞉bo꞉, giyo꞉ mada tilidabu ko꞉lo꞉, ge sagale alifa꞉.” Elisabed eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Malia eyo꞉ a꞉la꞉sio꞉, “Ni asulo꞉wa꞉yo꞉ Gode Alana꞉ ene wiyo꞉ dulugu so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","48","Ne ene nanog dian ga. Ne elo꞉ dianba, ko꞉sega Eyo꞉ ne kanulu alitaki gasili ko꞉lo꞉, No꞉no꞉n mamayo꞉ iliga꞉sa꞉ga꞉, Godemo꞉wo꞉ alan sagalab. O꞉g wena a꞉la꞉ta꞉ga꞉ tif amio꞉lo꞉, kaluka꞉isale ta꞉i ha꞉na꞉no꞉ a꞉ma꞉yo꞉ ne wilo꞉ di a꞉la꞉sa꞉la꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mo꞉wo꞉ Gode Halaido꞉lelo꞉ A꞉lab eyo꞉ ne alan asuwa꞉taki nafale dimido꞉. Ene wiyo꞉ malilo꞉ nafale dofo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Kaluka꞉isale abeyo꞉ Godeyo꞉ tagilakilo꞉ wabulu sa꞉la꞉lab a꞉no꞉, Godeya꞉ ene kanulo꞉ a꞉ma꞉ iyo꞉ go꞉lu alita꞉sen. Kalu i a꞉ma꞉ ini so꞉wamo꞉wo꞉lo꞉, i ma꞉mu i ta꞉i ha꞉na꞉nigab o꞉mo꞉wo꞉lo꞉ a꞉la꞉ka dimida꞉i ha꞉na꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Gode ene dagiya꞉ nanog halaido꞉ dimido꞉. Kalu inina꞉ma꞉la꞉yo꞉ asulo꞉ amio꞉ kailo꞉ dowab a꞉no꞉, Gode eyo꞉ ha꞉la꞉ya o꞉luga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Misa꞉ kalu nolo꞉ enena꞉ma꞉la꞉yo꞉ alan dowab a꞉no꞉, Gode eyo꞉ iyo꞉ ha꞉ga ta꞉felo꞉ ko꞉sega, wilo꞉ma kalu a꞉no꞉ iwalu halona wabulun ta꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Kalu maiyo꞉ alando꞉ a꞉lab i a꞉no꞉, Gode eyo꞉ ilili alifa꞉ ko꞉sega, kalu kelego꞉wo꞉ modo꞉lo꞉ da꞉lab i a꞉no꞉, madalile iliga꞉felo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Eyo꞉ ene nanog dian kaluka꞉isale Isolael a꞉no꞉ ko꞉lo꞉ asufa꞉. Imo꞉wo꞉ nofolo꞉wo꞉ alan wida꞉sen. Dinali sio꞉ a꞉no꞉ Gode eyo꞉ Ablaham o꞉lia꞉ ene eso꞉lo꞉wa a꞉la꞉ta꞉ga꞉lo꞉ ta꞉i ha꞉na꞉mela꞉ib i o꞉mo꞉ sio꞉ ko꞉lo꞉ asuwa꞉ta꞉mela꞉ib.” Malia eyo꞉ a꞉la꞉wabulu sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maliayo꞉ e Elisabed o꞉lia꞉ seno꞉, ele otaleno꞉ dufula꞉sa꞉ga꞉, e a꞉ma꞉la꞉ ene hena ane. ");
INSERT INTO bco_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabed e, so꞉wayo꞉ sa꞉la꞉lia꞉no꞉ ho꞉leno꞉ dowabiki, eyo꞉ kalu so꞉wa ko꞉lo꞉ sa꞉la꞉li. ");
INSERT INTO bco_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A꞉la꞉ta꞉ga꞉ Elisabed ene eso꞉lo꞉ o꞉lia꞉ ene amisa꞉n o꞉lia꞉yo꞉ Gode eyo꞉ emo꞉wo꞉ nofolaki asufa꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉, iliyo꞉ e o꞉lia꞉yo꞉ sagalo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Sa꞉la꞉lia꞉sa꞉ga꞉ a꞉namio꞉, ho꞉len agelo꞉wo꞉ o fa꞉la꞉dowabiki, so꞉wa a꞉no꞉ do꞉go꞉fo꞉ hege gedema꞉ni mio꞉. Iliyo꞉ so꞉wa we iya Sekalaya ko꞉ wikilima꞉no꞉ a꞉la꞉sio꞉ ko꞉sega, ");
INSERT INTO bco_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ene anowa꞉ sa꞉laki, “Iyayo꞉ mo꞉wikilima꞉no. Niliyo꞉ so꞉wa we, Yo꞉n wikilima꞉niki” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Eyo꞉ a꞉la꞉sa꞉labiki, iliyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge so꞉lo꞉ us amio꞉ wi ko꞉ngo꞉wo꞉ tamin amio꞉ mo꞉wikila꞉sen.” ");
INSERT INTO bco_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","A꞉la꞉sa꞉labiki, iyaya꞉ asulo꞉wa꞉yo꞉ so꞉wa we wiyo꞉ o꞉b ko꞉lo꞉ wikilima꞉nigaya a꞉la꞉liki, ene asulo꞉wo꞉ ko꞉lo꞉ dabu ba꞉dakiyo꞉, iliyo꞉ dagiya꞉ da꞉fe kedaka emo꞉wo꞉ a꞉na dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A꞉la꞉ta꞉ga꞉ Sekalaya eyo꞉ mo꞉fo꞉s nowo꞉ dimina꞉ki, dagiya꞉ da꞉feyo꞉ ko꞉lo꞉, mo꞉fo꞉s a꞉namio꞉ a꞉la꞉sa꞉sa꞉lo꞉ “Ene wiyo꞉ Yo꞉n.” A꞉la꞉sa꞉sa꞉labiki, iyo꞉ tambo mada mologa꞉ifelo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Wigibo a꞉naka Sekalaya e do꞉fo꞉f elen a꞉no꞉ kolaetabiki, e towo꞉ tolaki, Godeya꞉ wiyo꞉ a꞉na dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","A꞉la꞉ta꞉ga꞉ ene amisa꞉n kalu iliyo꞉ mada molo asulaki, Yudia hen misio꞉lo꞉ doba꞉da꞉lo꞉ ta꞉i ane a꞉no꞉ dimido꞉ a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ nenela꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kalu dimido꞉ o꞉lo꞉ dabu i a꞉no꞉ tambo kele asulakiyo꞉ a꞉la꞉sio꞉, “Tif amio꞉ kalu so꞉wa we o꞉bo꞉ngo꞉ ko꞉lo꞉ fa꞉la꞉doma꞉nigaba꞉le?” a꞉la꞉asulo꞉. Mo꞉wo꞉ Godeya꞉ ene dagi wa꞉la ta꞉fo꞉liki, so꞉wa we a꞉na tili dofo꞉len. ");
INSERT INTO bco_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Godeya꞉ Mama Malilo꞉wo꞉ Sekalaya e amio꞉ wa꞉lifo꞉liki, eyo꞉ dinali sa꞉lakiyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Isolaela꞉ Gode a꞉ma꞉yo꞉ ene kaluka꞉isalelo꞉wa ya꞉sa꞉ga꞉, niyo꞉ ga꞉li mesea꞉ki gasili ko꞉lo꞉, niliyo꞉ Alana꞉ wiyo꞉ dulugu sa꞉ma꞉niki. ");
INSERT INTO bco_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Gode eyo꞉ nilo꞉ gasilia꞉no꞉ kalu halaido꞉ nowo꞉ nimo꞉ dimi. Kalu a꞉no꞉ Godeya꞉ ene nanog dian kalu Da꞉ibida꞉ ene eso꞉lo꞉wa a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tamina Gode enedo꞉ dinali sa꞉lan kaluwa꞉yo꞉ a꞉la꞉dinali sio꞉ ko꞉lo꞉, o꞉go꞉ to we hendele fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ni o꞉lia꞉lo꞉ gisdo꞉ dimida꞉lab o꞉lia꞉ nimo꞉lo꞉ kulufa꞉yab kalu o꞉lia꞉ma꞉ dagi amilo꞉ elen a꞉no꞉ kalu wema꞉yo꞉ nio꞉ ko꞉lo꞉ asuwa꞉taki, a꞉ma꞉la꞉ gasili. ");
INSERT INTO bco_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Elo꞉ dinali sio꞉ a꞉no꞉ asulufo꞉liki, ene nofolo꞉ a꞉no꞉ nili ma꞉mu imo꞉ widaki go꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Dinali saefa꞉ a꞉no꞉, Gode eyo꞉ nili ma꞉mu Ablaham o꞉lia꞉ dinali saefa꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Nio꞉ gisa꞉ dagi usamilo꞉ elen a꞉no꞉ ko꞉lo꞉ fage alitakiyo꞉, enedo꞉ dinali sio꞉ a꞉la꞉ka go꞉. A꞉la꞉go꞉ko꞉lo꞉ nio꞉ mo꞉tagilaki, ene nanog dia꞉melea꞉ki ta꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nio꞉ nanogo꞉ dimidakiyo꞉, ho꞉leno꞉ tambo malilo꞉ dofo꞉liki, man digalo꞉ a꞉no꞉ ko꞉lo꞉ kudu ha꞉na꞉melea꞉ki ta꞉fo꞉.” ");
INSERT INTO bco_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“A꞉la꞉ta꞉ga꞉ ni so꞉wa Yo꞉n ge, Gode Iwalulo꞉ a꞉ma꞉ dinali sa꞉lan kaluwo꞉ geka꞉ a꞉la꞉sa꞉ma꞉ib. Alano꞉ o꞉mia꞉nigab amio꞉, elo꞉ mia꞉no꞉ tog a꞉no꞉ fadama꞉niki, ge ko꞉le ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Gode eyo꞉ kaluka꞉isale enedo꞉wo꞉ a꞉ma꞉la꞉ gasilima꞉kiyo꞉, mogago꞉ inido꞉ dimida꞉sen a꞉no꞉ ga꞉lila꞉ma꞉ib. Iliyo꞉ a꞉la꞉asuluma꞉kiyo꞉, giyo꞉ wida꞉liki ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Nili Gode eyo꞉ ni o꞉lia꞉yo꞉ ha꞉sa dowaki, nofolo alita꞉sen ko꞉lo꞉, nio꞉ a꞉na a꞉la꞉ta꞉ga꞉ gasili. A꞉la꞉go꞉ko꞉lo꞉ Godeya꞉lo꞉ Da꞉feyo꞉ kalu a꞉no꞉ ofa꞉ ya꞉no꞉ o꞉ngo꞉ ko꞉lo꞉ Hebene halona a꞉la꞉ta꞉ga꞉ ni o꞉lia꞉ mesa꞉no꞉ mia꞉nigab. ");
INSERT INTO bco_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kaluka꞉isale sololi usa siliki, soma꞉no꞉wo꞉ tagilakilo꞉ sab i a꞉no꞉, ho꞉ a꞉ma꞉yo꞉ ho꞉le alifa꞉ib. A꞉la꞉gakiyo꞉ ha꞉salo꞉ mesa꞉no꞉ tog nafa a꞉no꞉ eyo꞉ imo꞉wo꞉ walama꞉ib.” Sekalaya eyo꞉ to a꞉no꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tif amio꞉ so꞉wa a꞉no꞉ kalu alan dowalikiyo꞉, ene mamayo꞉lo꞉ halaido꞉ dowo꞉. E kalulo꞉ma kalaleli hen a꞉na ha꞉na꞉sa꞉ga꞉ silikiyo꞉, Isolael kaluka꞉isaleya꞉ siwa꞉l amilo꞉ fa꞉la꞉doma꞉no꞉ ho꞉len a꞉no꞉ yasilakiyo꞉ a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ho꞉len a꞉namio꞉, Lom misa꞉ kalu alan, Sisa Ogastus, eyo꞉ ele nowo꞉ a꞉la꞉saefa꞉. Kaluka꞉isale Loma꞉ misa꞉ kaluwa꞉lo꞉ bo꞉fo꞉lab hen a꞉namilo꞉ sab a꞉no꞉, wiyo꞉ tambo bugo꞉wa dia꞉fa꞉niki, sa꞉sa꞉lima꞉ni ya꞉bika꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kilinius e Silia hen a꞉na gamani misa꞉ kalu silikiyo꞉, wiyo꞉ a꞉na mo꞉mo꞉da diaki sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isaleyo꞉ tambo ene amisa꞉ndeya wiyo꞉ a꞉na sa꞉sa꞉lima꞉ni ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yosa꞉b e Da꞉ibida꞉ ene eso꞉lo꞉ ko꞉lo꞉, e hen Ga꞉lili a꞉namio꞉ Nasala꞉t amisa꞉n a꞉no꞉ ta꞉ta꞉sa꞉ga꞉, Yudia hen a꞉namio꞉, Da꞉ibida꞉ amisa꞉n Ba꞉diliha꞉m a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ga Yosa꞉bo꞉lo꞉ same, Malia a꞉no꞉ alela꞉len ko꞉lo꞉, a꞉la꞉yo꞉ wiyo꞉ sa꞉sa꞉lima꞉ki ane. ");
INSERT INTO bco_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","A꞉la꞉yo꞉ amisa꞉n a꞉naka o꞉sena, Maliayo꞉ so꞉wa sa꞉la꞉lia꞉no꞉ ho꞉leno꞉ a꞉na fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","A꞉na fa꞉la꞉dowabiki, Malia eyo꞉ kalu so꞉wa wa꞉la꞉bo꞉ sa꞉la꞉li. Amisa꞉n a꞉namio꞉ mageso꞉ ayo꞉ kaluwa꞉ wa꞉lifo꞉ ko꞉lo꞉, eyo꞉ so꞉wa a꞉no꞉ helebeso꞉ga꞉ mela꞉sa꞉ga꞉, kaowa꞉ ma꞉no꞉lo꞉ na꞉sen i fofodo꞉ wa꞉l a꞉na dinafa mali alifa꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hen a꞉namio꞉, sibilo꞉ bo꞉fo꞉lowan kalu nolo꞉ amisa꞉n ha꞉la꞉ya siliki, nulu a꞉namio꞉ sibiyo꞉ bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","A꞉na sen amio꞉, Alana꞉ ene ma꞉mul kaluwo꞉ ilo꞉wa fa꞉la꞉dowakiyo꞉, Alana꞉ ene ho꞉len halaido꞉ fo꞉fo꞉lesodo꞉ a꞉ma꞉yo꞉ iyo꞉ ho꞉lelia꞉ga꞉ dia꞉tabikiyo꞉, iyo꞉ mada tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ko꞉sega ma꞉mul kaluwa꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ tagila꞉so꞉bo! Niyo꞉ to nafa we gimo꞉ sa꞉ma꞉ni mio꞉. To nafa wema꞉yo꞉ kaluka꞉isaleyo꞉ tambo sagale alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","O꞉g ho꞉len wenamio꞉, Da꞉ibida꞉ ene amisa꞉n amio꞉, so꞉wayo꞉ sa꞉la꞉liab. So꞉wa a꞉no꞉ Kalu Alan, Godeya꞉lo꞉ da꞉feyo꞉ kaluwo꞉ o꞉m ko꞉lo꞉, gilo꞉ a꞉ma꞉la꞉do꞉ gasilia꞉no꞉wo꞉ e. ");
INSERT INTO bco_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Giliyo꞉ so꞉wa tuo꞉lun a꞉no꞉ hendelelo꞉b a꞉la꞉do꞉ ele ba꞉ba꞉no꞉ a꞉no꞉ niyo꞉ walama꞉nigo꞉l. So꞉wa tuo꞉lun a꞉no꞉ helebeso꞉ga꞉ mela꞉sa꞉ga꞉, kaowa꞉ ma꞉no꞉lo꞉ na꞉sen fofodo꞉ wa꞉l ami mali alifo꞉lena ba꞉ba꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A꞉la꞉sa꞉la꞉sa꞉ga꞉ edabiki, wigibo a꞉naka ma꞉mula꞉ kalu modo꞉ nolo꞉ Hebene a꞉la꞉ta꞉ga꞉ a꞉na fa꞉la꞉dowa꞉sa꞉ga꞉, Godeya꞉ wiyo꞉ alan dulugu sa꞉laki a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Iwalu halonamio꞉ Gode E mada alan wabulun a꞉lab. Henfelo꞉ kaluka꞉isale Gode elo꞉ asulab i a꞉no꞉, ene ha꞉sa mesea꞉ki ta꞉tab.” ");
INSERT INTO bco_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ma꞉mula꞉ kaluwo꞉ towo꞉ sa꞉la꞉sa꞉ga꞉, a꞉ma꞉la꞉ Hebene halona ha꞉na꞉ga꞉ dotabiki, sibilo꞉ bo꞉fo꞉lowan iliyo꞉ egelebo꞉ a꞉la꞉nenelo꞉. “O꞉gdo꞉ fa꞉la꞉dowab a꞉no꞉, Kalu Alana꞉ nimo꞉ widab ko꞉lo꞉, nio꞉lo꞉ ba꞉ba꞉niki, Ba꞉diliha꞉m hosona ha꞉na꞉n” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ bo꞉bo꞉ge keda꞉i aneyo꞉, Yosa꞉b dia꞉ Malia o꞉lia꞉yo꞉ a꞉na ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ so꞉wa tuo꞉lun a꞉no꞉ kao ma꞉no꞉lo꞉ na꞉sen fofodo꞉ wa꞉la delena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Iliyo꞉ so꞉wa a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, ma꞉mula꞉ kaluwa꞉lo꞉ so꞉walo꞉ doba꞉da꞉lo꞉ sio꞉ a꞉no꞉ kalaba sa꞉la꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kaluka꞉isaleyo꞉ sibilo꞉ bo꞉fo꞉lowana꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ tambo iligi dabu. ");
INSERT INTO bco_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko꞉sega Malia eyo꞉ to sio꞉ a꞉no꞉ tambo ene asulo꞉ usamio꞉ sagala꞉li elen ko꞉lo꞉, to a꞉ma꞉ ha꞉go꞉ o꞉b sa꞉lakigaba꞉le a꞉la꞉asula꞉len. ");
INSERT INTO bco_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","A꞉la꞉ta꞉ga꞉ sibilo꞉ bo꞉fo꞉lowan kalu ililo꞉ dabu o꞉lia꞉ ililo꞉ ba꞉ba꞉ o꞉lia꞉ a꞉no꞉, ma꞉mula꞉ kaluwa꞉lo꞉ to sio꞉ o꞉leaumbo꞉ tambo hendele fa꞉la꞉dowabiki ba꞉ba꞉ ko꞉lo꞉, iliyo꞉ Godeya꞉ ene wiyo꞉ a꞉na dulugu sa꞉la꞉liki a꞉ma꞉la꞉ ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ho꞉len owo꞉ fa꞉la꞉dowabiki, so꞉wa tuo꞉lun a꞉ma꞉ do꞉go꞉fo꞉ hege gedea꞉sa꞉ga꞉, ene wiyo꞉ Ya꞉su wikilo꞉. Wi we, Maliayo꞉ o꞉alela꞉ma꞉no꞉ a꞉labiki, ma꞉mul kaluwa꞉ tamina wikili alifa꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yosa꞉b o꞉lia꞉ Malia o꞉lia꞉yo꞉ Mo꞉sa꞉s elo꞉ ele saefa꞉ a꞉no꞉ kudu ha꞉naki, Godeya꞉ siwa꞉l amilo꞉ malilo꞉ doma꞉no꞉ ho꞉len a꞉no꞉ fa꞉la꞉dowabiki, a꞉la꞉ma꞉yo꞉ so꞉wa a꞉no꞉ ta꞉ulia꞉ga꞉ Godemo꞉ dimia꞉niki, Ya꞉lusalem ane. ");
INSERT INTO bco_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mo꞉wo꞉ Alana꞉ ele difa꞉ a꞉namio꞉ a꞉la꞉sa꞉sa꞉lo꞉, “Kalu so꞉wa wa꞉la꞉b sa꞉la꞉liab a꞉no꞉, Gode Alanbo꞉ tambo dimia꞉bi” a꞉la꞉saefa꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A꞉la꞉ma꞉yo꞉ a꞉la꞉dimidama꞉no꞉ a꞉la꞉ta꞉ga꞉ ha꞉nakiyo꞉, a꞉la꞉yo꞉ Godemo꞉ boba nowo꞉ so꞉mea꞉ni ane. Mo꞉wo꞉ Alana꞉ ele difa꞉ a꞉namio꞉ a꞉la꞉sa꞉sa꞉lo꞉, “O꞉ba꞉ hi a꞉la꞉ya꞉le, mo꞉ o꞉ba꞉ hifun a꞉la꞉ya꞉le a꞉la꞉ dimia꞉bi” a꞉la꞉saefa꞉ ko꞉lo꞉, a꞉la꞉dimidama꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ho꞉len a꞉namio꞉ kalu nowo꞉ Ya꞉lusalem a꞉na sen. Ene wiyo꞉ Simeon. E mada digalo꞉ kalu a꞉la꞉ta꞉ga꞉, Godeya꞉ ene mando꞉ kudu ha꞉na꞉leno꞉ e. Isolael kaluka꞉isaleyo꞉ ha꞉sa mesea꞉kilo꞉ mia꞉nigab a꞉no꞉ ba꞉ba꞉no꞉ ko꞉lo꞉ yasisen. Mama Malilo꞉ a꞉no꞉ e amio꞉ wa꞉lifo꞉ ko꞉lo꞉ ");
INSERT INTO bco_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mamaya꞉ emo꞉wo꞉ widakiyo꞉ a꞉la꞉sio꞉, “Ge o꞉semo꞉sowo꞉ elen ami, Godeya꞉lo꞉ Da꞉feyo꞉ Kalu Alan a꞉no꞉ go꞉no꞉n siya꞉ ba꞉ba꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","A꞉la꞉fo꞉ko꞉lo꞉ Godeya꞉ Mamayo꞉ Simeon amio꞉ wa꞉litabiki, Mama a꞉ma꞉yo꞉ e tililia꞉ga꞉, Godeya꞉ malilo꞉ aya ane. A꞉la꞉ta꞉ga꞉ Yosa꞉b o꞉lia꞉ Malia o꞉lia꞉ma꞉yo꞉ ele saefa꞉ a꞉no꞉ ko꞉lo꞉ kudu ha꞉naki, Ya꞉su tuo꞉lun a꞉no꞉ Godeya꞉ malilo꞉ aya ta꞉ulia꞉gane. A usa ta꞉ulia꞉ga꞉ fa꞉la꞉dowabiki, ");
INSERT INTO bco_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon eyo꞉ so꞉wa tuo꞉lun a꞉no꞉ fo꞉fo꞉lelia꞉ga꞉ ta꞉lidotaki, Godeya꞉ wiyo꞉ dulugu sa꞉lakiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Gode Ge, kelego꞉ tambolo꞉ Biso꞉wo꞉ imilise Ge. Ne gi nanog dian kalu. Gilo꞉ tamin amilo꞉ dinali sio꞉ a꞉no꞉ dimido꞉ ko꞉lo꞉, giyo꞉ ne ha꞉sa mesa꞉ hamana꞉ki fage alifoma. ");
INSERT INTO bco_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Mo꞉wo꞉ nilo꞉ a꞉ma꞉la꞉ gasilia꞉no꞉ kalu, gilo꞉ iliga꞉fo꞉ a꞉no꞉ no꞉no꞉n siya꞉ bo꞉do꞉l. ");
INSERT INTO bco_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Henfelo꞉ kaluka꞉isaleyo꞉ tambo bo꞉ba꞉kiyo꞉, giyo꞉ a꞉na dimidaefa꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","E ho꞉len doma꞉ib ko꞉lo꞉, Yu kaluka꞉isalema iliyo꞉ Godeyo꞉ asuluma꞉kiyo꞉, ho꞉len a꞉ma꞉yo꞉ walama꞉ib. A꞉la꞉ta꞉ga꞉ ho꞉ a꞉ma꞉yo꞉ Isolael kaluka꞉isale go꞉no꞉ndo꞉mo꞉wo꞉ wi alano꞉ ko꞉lo꞉ dimia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","A꞉la꞉sa꞉labiki iya o꞉lia꞉ ano o꞉lia꞉yo꞉ Simeon elo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, a꞉la꞉yo꞉ molo dabu. ");
INSERT INTO bco_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon eyo꞉ iyo꞉ sagale alifoma꞉ki, Godemo꞉ dulugu sa꞉la꞉sa꞉ga꞉yo꞉, to nowo꞉ anomo꞉wo꞉ a꞉la꞉sio꞉. “Dabuma. So꞉wa we, Gode Ene da꞉fea꞉sa꞉ga꞉ iliga꞉fo꞉lo꞉biki, Isolael kaluka꞉isale nolo꞉ hena sana to꞉loma꞉ib ko꞉sega, nolo꞉ gasilia꞉ga꞉ iwalu ta꞉felema꞉ib. E ele ba꞉ba꞉no꞉wo꞉ o꞉ngo꞉ dowaliki, kaluka꞉isale modo꞉ nolba꞉yo꞉ emo꞉wo꞉ mo꞉beaki gadi sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Eyo꞉ kaluka꞉isale ililo꞉ wo꞉no꞉ledo꞉ asulo꞉wo꞉ kalaba walama꞉ki ta꞉fa꞉ib. A꞉la꞉ta꞉ga꞉ nagalo꞉ alan a꞉ma꞉yo꞉ gi asulo꞉ amio꞉ helebe siya꞉lo꞉ olo꞉wo꞉ auma꞉ib.” Simeon eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ho꞉len a꞉namio꞉ Godeya꞉lo꞉ dinali sa꞉lan ga nowo꞉ Ana ko꞉lo꞉ elo꞉ us a꞉na elen. Ene iyayo꞉ Fanuel. Ene so꞉lo꞉ mio꞉wo꞉, Asel. E mada anaso꞉ ulula꞉li. Tamin amio꞉ e kaluwa꞉yo꞉ dia꞉sa꞉ga꞉, dona dom a꞉la꞉fo꞉wo꞉ ta꞉ta꞉ga꞉yo꞉, ene ino꞉ a꞉na sowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ino꞉ sowabikiyo꞉ ga a꞉no꞉ sa꞉ba꞉lo꞉ elen. E donayo꞉ do꞉ a꞉la꞉lowo꞉wo꞉ o a꞉la꞉ta꞉ga꞉ fa꞉la꞉da꞉in gulula꞉ ko꞉lo꞉ elen. E Godeya꞉ malilo꞉ a us a꞉na iliki, ma꞉no꞉wo꞉ mo꞉naki, ho꞉lenowo꞉lo꞉, nuluwo꞉lo꞉ Godemo꞉ dulugu sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simeon eyo꞉ Maliamo꞉ sa꞉la꞉labikiyo꞉, wigibo a꞉naka, Ana elo꞉ ko꞉na꞉ma finda꞉ga꞉ kagayaka, Godemo꞉ mada o꞉m a꞉la꞉sio꞉. Ana eyo꞉ so꞉wa we ko꞉lo꞉ malolakiyo꞉, Godeya꞉lo꞉ Ya꞉lusalem kaluka꞉isaleyo꞉ ga꞉li mesea꞉kilo꞉ sili alifa꞉no꞉ yasila꞉len kaluka꞉isale i o꞉mo꞉wo꞉ malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","A꞉la꞉fo꞉ko꞉lo꞉ iyo꞉ Alana꞉lo꞉ ele to saefa꞉ a꞉no꞉ tambo dimida꞉sa꞉ga꞉ ko꞉m a꞉la꞉takiyo꞉, iyo꞉ ini amisa꞉n Nasala꞉t, Ga꞉lili hen a꞉na a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","A꞉la꞉ta꞉ga꞉ so꞉wa Ya꞉su a꞉no꞉ mada halaido꞉ anayakiyo꞉, asulo꞉lo꞉ di kalu dowabiki, Godeya꞉ kanulo꞉wo꞉ e o꞉lia꞉ elen. ");
INSERT INTO bco_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Donayo꞉ tambo amio꞉ Tinio꞉ Asulo꞉ Ma꞉no꞉ ma꞉no꞉ ho꞉len a꞉no꞉ fa꞉la꞉dowab amio꞉ Ya꞉suwa꞉ ene iya o꞉lia꞉ anolia꞉yo꞉ Ya꞉lusalem a꞉na ha꞉na꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ya꞉suwo꞉ donayo꞉ kugula꞉fo꞉ dowabikiyo꞉, iyo꞉ Yuwa꞉ man ko꞉lo꞉ kudu ha꞉naki, Ya꞉lusalem halona ane. ");
INSERT INTO bco_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tinio꞉ Asulo꞉ Ma꞉no꞉ na꞉i mio꞉wo꞉ a꞉na eda꞉sa꞉ga꞉, a꞉la꞉yo꞉ a꞉ma꞉la꞉ ini amisa꞉na ha꞉nabiki, so꞉wa a꞉no꞉ Ya꞉lusalem a꞉naka sen. Ko꞉sega, a꞉la꞉ma꞉yo꞉ e hende ta꞉fo꞉ mio꞉ a꞉la꞉bo꞉ mada mo꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A꞉la꞉ma꞉yo꞉ e iasi nol o꞉lia꞉ yab a꞉la꞉asulaki, ho꞉len imiligo꞉ ka ha꞉na꞉sa꞉ga꞉ dotabikiyo꞉, a꞉la꞉ma꞉yo꞉ so꞉lo꞉ o꞉lia꞉ iasi kalu i us a꞉namio꞉ mo꞉mo꞉da kedo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A꞉la꞉ma꞉yo꞉ e kedo꞉wo꞉ mo꞉ba꞉dabiki, a꞉la꞉yo꞉ a꞉ma꞉la꞉ Ya꞉lusalem a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ho꞉leno꞉ otalen ta꞉ta꞉ga꞉ ami, e Godeya꞉ malilo꞉ a us a꞉na sena ba꞉ba꞉. A꞉namio꞉ e widan kalu o꞉lia꞉ siliki, ililo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉la꞉ga꞉yo꞉, imo꞉ dabu ba꞉da꞉liki sena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kalu Ya꞉su elo꞉ a꞉ma꞉la꞉ sa꞉labikilo꞉ dabu iliyo꞉ ene asulo꞉wo꞉ ba꞉da꞉ga꞉, tambo molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","A꞉la꞉ma꞉yo꞉ e ba꞉da꞉ga꞉, mada iligo꞉. Ba꞉da꞉sa꞉ga꞉, ene anowa꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉. “Ni so꞉wa, ge na꞉nbo꞉lo꞉ a꞉la꞉do꞉ dimidab ko waga dimidaya? Go꞉l na꞉no꞉ kele asulaki, ge a꞉na kelelia꞉ga꞉ mio꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Eyo꞉ a꞉la꞉sio꞉, “Gaino꞉ ne waga keda꞉i mio꞉wo꞉? Ne dowa꞉ aya sab a꞉la꞉bo꞉, gaino꞉ mo꞉asulo꞉wo꞉?” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko꞉sega elo꞉ to sa꞉lab a꞉no꞉, a꞉la꞉ma꞉yo꞉ ha꞉go꞉ mo꞉fanda asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A꞉la꞉ta꞉ga꞉ e a꞉la꞉ o꞉lia꞉ a꞉ma꞉la꞉ Nasala꞉t holona ha꞉na꞉sa꞉ga꞉ silikiyo꞉, e a꞉la꞉ma꞉ ha꞉ga dowaki, to a꞉la꞉ma꞉lo꞉ sa꞉lab a꞉no꞉ ko꞉lo꞉ kudu ha꞉na꞉len. Ko꞉sega kelego꞉ tambo fa꞉la꞉dowo꞉ a꞉no꞉ Malia eyo꞉ asulo꞉ usa asulufo꞉liki elen. ");
INSERT INTO bco_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ya꞉suwo꞉ analiakiyo꞉, ene asulo꞉wo꞉ nafa halaido꞉ dowabiki, Godeya꞉ si wa꞉l amio꞉lo꞉, kaluka꞉isaleya꞉ ba꞉ba꞉ amio꞉lo꞉, emo꞉wo꞉ sagala꞉ mela꞉no꞉ dowo꞉ ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Sisa Taibelias e Lom misa꞉ kalu bo꞉fo꞉likilo꞉ eleno꞉, donayo꞉ do꞉la꞉ta꞉ga꞉ bila꞉fo꞉ gulula꞉sa꞉ga꞉yo꞉, Fondias Failat e Yudia hen a꞉namio꞉ gamani misa꞉ sen. O꞉g a꞉namio꞉ Ha꞉lod e Ga꞉lili hen a꞉no꞉ e bo꞉fo꞉liki, ene ao Filib e Idulia o꞉lia꞉ Takonitis hen a꞉la꞉ a꞉no꞉ e bo꞉fo꞉len. A꞉la꞉ta꞉ga꞉ Lisanias e Abilene hen a꞉no꞉ e bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kaiafas o꞉lia꞉ Anas o꞉lia꞉yo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu dowab ho꞉len a꞉namio꞉, Sekalayaya꞉ inso꞉ Yo꞉n e kalaleli hen a꞉na sabiki, Godeya꞉ towo꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ ho꞉n Yodan anib doba꞉da꞉lo꞉ amisa꞉n a꞉na wida꞉i sia꞉likiyo꞉, “Gode eyo꞉ gili mogago꞉ dimida꞉sen a꞉no꞉ hala꞉ma꞉ki, gio꞉ asulo꞉wo꞉ nodolaki, ho꞉na to꞉loma” a꞉la꞉sa꞉la꞉liki wida꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Dinali sa꞉lan kalu Aisaya eyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “Kalu imilig nowo꞉ kalaleli hen a꞉na iliki ho꞉le sa꞉lakiyo꞉, ‘Kalu Alando꞉ mia꞉no꞉ togo꞉ dinafama. Tog a꞉no꞉ digale fadaifoma. ");
INSERT INTO bco_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Hen gagodo꞉ a꞉no꞉ tambo ko꞉le alifelaki, hen misio꞉ a꞉no꞉ tambo dali ko꞉nela꞉bi. Tog kowagelo꞉wo꞉ digale imili fadaitaki, tog mogago꞉ a꞉lab a꞉no꞉lo꞉ dinafale fadaita꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","A꞉la꞉dimidalikiyo꞉ Godeya꞉lo꞉ asuwa꞉takilo꞉ gasilian man a꞉no꞉ henfelo꞉ kaluka꞉isaleyo꞉ tambo ba꞉ba꞉ib.’” Aisaya eyo꞉ Yo꞉n elo꞉ nanog dia꞉nigab a꞉no꞉ ko꞉lo꞉ asulaki, to a꞉no꞉ a꞉na sa꞉sa꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaluka꞉isale modo꞉ a꞉no꞉ Yo꞉n elo꞉wa ho꞉na to꞉loma꞉ki mio꞉ ko꞉lo꞉, Yo꞉n eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ kisa꞉wa꞉lo꞉ o꞉ngo꞉ dowo꞉. Godeya꞉lo꞉ mo꞉walilakilo꞉ falasila꞉ma꞉nigab a꞉no꞉, gio꞉ begele alita꞉ga꞉ hamana꞉kiyo꞉ abe hagugu sio꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gio꞉ Godeya꞉ gadio꞉wo꞉ tininima꞉nikiyo꞉, asulo꞉ nodolo꞉ a꞉ma꞉ fo nafayo꞉, gililo꞉ man dimidan us a꞉namio꞉ fowo꞉ hele alita꞉bi. Ablahamo꞉ nili ma꞉mu ko꞉lo꞉ nio꞉ o꞉li sili alifa꞉no꞉ a꞉la꞉likiyo꞉ gegelebo꞉ sa꞉la꞉lowa꞉so꞉bo. Niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Gode eyo꞉ Ablahama꞉ ema꞉mu i nolo꞉ u wena a꞉la꞉ta꞉ga꞉yo꞉ o꞉lika fa꞉la꞉do alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Kabiyo꞉ imo꞉ amio꞉ o꞉ma dia꞉fo꞉lab ko꞉lo꞉, iyo꞉ tambo fo nafalo꞉ mo꞉hedab a꞉no꞉ gegedelia꞉ga꞉ deya gilima꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Yo꞉n eyo꞉ a꞉la꞉sa꞉labiki, kalu kegeo꞉ iliyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “A꞉la꞉go꞉lo꞉biki, niliyo꞉ waga dimidama꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu abeyo꞉ helebeso꞉g ka꞉la꞉seno꞉ a꞉la꞉ da꞉lalega, nowo꞉ kalu aundo꞉ma dowab emo꞉ dimia꞉bi. A꞉la꞉ta꞉ga꞉ kalu ge ma꞉no꞉wo꞉ da꞉lalega, a꞉la꞉ka dimida꞉bi” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","A꞉la꞉ta꞉ga꞉ takis molelo꞉ dia꞉sen kalu nolo꞉ Yo꞉n elo꞉wa ho꞉na to꞉loma꞉ki mio꞉ ko꞉lo꞉, iliyo꞉ Yo꞉nbo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu, niliyo꞉ waga dimidama꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ gamani kaluwa꞉lo꞉ saefa꞉ o꞉leauka dia꞉bi. Moleyo꞉ wa꞉l amio꞉ nolo꞉ bama꞉kiyo꞉ ha꞉iya꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Da꞉la꞉di kalu nolba꞉yo꞉ Yo꞉nbo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Niliyo꞉lo꞉ waga dimidama꞉no꞉wa꞉le?” A꞉la꞉da꞉dabiki eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Mole gimo꞉lo꞉ kililia꞉sen o꞉leauka dia꞉no꞉ sagala꞉bi. Giliyo꞉ mole nolo꞉ dia꞉no꞉ a꞉lakiyo꞉, go꞉no꞉n halaido꞉wa꞉yo꞉ susuda꞉so꞉bo. A꞉la꞉ta꞉ga꞉ dikili sa꞉lakiyo꞉ diga꞉lila꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kaluka꞉isale iyo꞉ sagala꞉liki yasisen ko꞉lo꞉ ili asulo꞉ amio꞉ “Yo꞉n e Godeya꞉lo꞉ Da꞉feyo꞉ Kaluwo꞉ weya꞉le?” a꞉la꞉asula꞉len. ");
INSERT INTO bco_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","A꞉la꞉fo꞉ko꞉lo꞉ Yo꞉n eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gio꞉ ho꞉ndeya to꞉lola꞉lo꞉l. Ko꞉sega kalu ni fa꞉s amilo꞉ mia꞉nigab a꞉ma꞉, ene halaido꞉wo꞉ alan ko꞉lo꞉, ne e tiniab. Ne wilo꞉ma kalu ko꞉lo꞉, niyo꞉ e budi sa꞉ga꞉lo꞉ a꞉namilo꞉ me melealifa꞉ a꞉no꞉ ni fagela꞉ma꞉no꞉wo꞉ mo꞉ililo꞉. Eyo꞉ gio꞉ Mama Malilo꞉ o꞉lia꞉ de o꞉lia꞉ a꞉na to꞉loma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eyo꞉ bebo꞉ dila꞉sa꞉ga꞉, wit fo hende a꞉no꞉ kegenema꞉no꞉ a꞉la꞉liki, uwa꞉fo꞉ e dagi amio꞉ ta꞉li sab. Eyo꞉ wit fo hende a꞉no꞉ kegea꞉sa꞉ga꞉, ene aya dia꞉fa꞉ib. A꞉la꞉ta꞉ga꞉ sebeb mogago꞉ o꞉da꞉lab a꞉no꞉, de mo꞉dalima꞉no꞉ a꞉lab a꞉na gilima꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yo꞉n eyo꞉ to widakiyo꞉, tog ko꞉li ko꞉lilo꞉wa wido꞉. Eyo꞉ kaluka꞉isaleya꞉ asulo꞉wo꞉ digidalitakiyo꞉, Godeya꞉ to nafa a꞉no꞉ a꞉na wida꞉len. ");
INSERT INTO bco_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yo꞉n eyo꞉ gamani misa꞉ kalu Ha꞉lodbo꞉wo꞉ a꞉la꞉sio꞉, “Ge gaowa꞉ inga Ha꞉lodias o꞉lia꞉lo꞉ mogago꞉ dimido꞉ a꞉no꞉ mo꞉lilo꞉.” Ha꞉lod elo꞉ man mogago꞉ ko꞉li ko꞉lilo꞉ nol dimida꞉sen a꞉no꞉lo꞉ tambo Yo꞉n eyo꞉ kalaba sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","A꞉la꞉sa꞉labiki Ha꞉lod elo꞉ mogago꞉ tamin amilo꞉ dimida꞉len a꞉no꞉ wa꞉ka a꞉kudu dimidakiyo꞉, Yo꞉n e dibolo aya to꞉lo alifa꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","22","Ho꞉len no amio꞉ Yo꞉n eyo꞉ kaluka꞉isale modo꞉ nolo꞉ ho꞉na to꞉lola꞉labikiyo꞉, Ya꞉su elo꞉ ho꞉na to꞉lolo꞉. To꞉lola꞉sa꞉ga꞉ Ya꞉su eyo꞉ Godemo꞉ dulugu sa꞉labikiyo꞉, Hebene a꞉no꞉ kolaetabiki, Mama Malilo꞉wo꞉, o꞉ba꞉ hi o꞉ngo꞉ ko꞉lo꞉ Hebene a꞉la꞉ta꞉ga꞉ dalolia꞉ tinda꞉ga꞉, elo꞉wa mio꞉. A꞉la꞉ta꞉ga꞉ to nowo꞉ Hebene a꞉la꞉ta꞉ga꞉ sa꞉lakiyo꞉, “Ge no꞉no꞉n so꞉wa ha꞉fo꞉lo꞉ disa꞉yo꞉ ge. Giyo꞉ ne mada sagale alitakigab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ya꞉su e donayo꞉ do꞉ a꞉la꞉fo꞉wo꞉ otalen a꞉no꞉ gulula꞉sa꞉ga꞉yo꞉, Godeya꞉ towo꞉ a꞉na mo꞉mo꞉da wido꞉. Kaluka꞉isaleya꞉yo꞉ Ya꞉su e Yosa꞉ba꞉ ene inso꞉ a꞉la꞉asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Yosa꞉b e Heliya꞉ inso꞉. Heli e Madada꞉ inso꞉. Madad e Libaiya꞉ inso꞉. Libai e Melkiya꞉ inso꞉. Melki e Yanaiya꞉ inso꞉. Yanai e Yosa꞉ba꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yosa꞉b e Madatiasa꞉ inso꞉. Madatias e A꞉mosa꞉ inso꞉. A꞉mos e Nahuma꞉ inso꞉. Nahum e Hesliya꞉ inso꞉. Hesli e Nagaiya꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai e Mada꞉ inso꞉, Mad e Madatiasa꞉ inso꞉. Madatias e Semena꞉ inso꞉. Semen e Yosega꞉ inso꞉. Yoseg e Yodaya꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yoda e Yoanaya꞉ inso꞉. Yoana e Lesaya꞉ inso꞉. Lesa e Selubabela꞉ inso꞉. Sa꞉lubabel e Seadiela꞉ inso꞉. Seadiel e Neliya꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neli e Melkiya꞉ inso꞉. Melki e Adiya꞉ inso꞉. Adi e Kosama꞉ inso꞉. Kosam e Elmadama꞉ inso꞉. Elmadam e Ela꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","El e Yosuaya꞉ inso꞉. Yosua e Eliesaya꞉ inso꞉. Eliesa e Yolima꞉ inso꞉. Yolim e Madada꞉ inso꞉. Madad e Libaiya꞉ inso꞉ ");
INSERT INTO bco_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Libai e Simeona꞉ inso꞉. Simeon e Yudaya꞉ inso꞉. Yuda e Yosa꞉ba꞉ inso꞉. Yosa꞉b e Yonama꞉ inso꞉. Yonam e Eliakima꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim e Meleaya꞉ inso꞉. Melea e Menaya꞉ inso꞉. Mena e Madadaya꞉ inso꞉. Madada e Natana꞉ inso꞉. Natan e Da꞉ibida꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Da꞉ibid e Ya꞉siya꞉ inso꞉. Ya꞉si e Obeda꞉ inso꞉. Obed e Boasa꞉ inso꞉. Boas e Salamona꞉ inso꞉. Salamon e Nasona꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason e Aminadaba꞉ inso꞉. Aminadab e Admina꞉ inso꞉. Admin e Aniya꞉ inso꞉. Ani e Heslona꞉ inso꞉. Heslon e Belesa꞉ inso꞉. Beles e Yudaya꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuda e Ya꞉koba꞉ inso꞉. Ya꞉kob e Aisa꞉ga꞉ inso꞉. Aisa꞉g e Ablahama꞉ inso꞉. Ablaham e Telaya꞉ inso꞉. Tela e Nahola꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahol e Seluga꞉ inso꞉. Selug e Leuwa꞉ inso꞉. Leu e Belega꞉ inso꞉. Beleg e Ebela꞉ inso꞉. Ebel e Silaya꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila e Ka꞉ina꞉na꞉ inso꞉. Ka꞉ina꞉n e Alafasaga꞉ inso꞉. Alafasag e Sa꞉ma꞉ inso꞉. Sa꞉m e Noaya꞉ inso꞉. Noa e Lamega꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameg e Metuselaya꞉ inso꞉. Metusela e Inoga꞉ inso꞉. Inog e Yaleda꞉ inso꞉. Yaled e Mahalalela꞉ inso꞉. Mahalalel e Ka꞉ina꞉na꞉ inso꞉. ");
INSERT INTO bco_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ka꞉ina꞉n e Enosa꞉ inso꞉. Enos e Sa꞉da꞉ inso꞉. Sa꞉d e Adama꞉ inso꞉. Adam e Godeya꞉ ene so꞉wa. ");
INSERT INTO bco_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ya꞉suwo꞉ ho꞉n Yodan a꞉na to꞉lola꞉sa꞉ga꞉ a꞉ma꞉la꞉ mio꞉ amio꞉, Mama Malilo꞉wo꞉ e amio꞉ wa꞉lifo꞉ ko꞉lo꞉, Mama Malilo꞉ a꞉ma꞉ tililia꞉ga꞉ kalaleli hena ane. ");
INSERT INTO bco_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ya꞉su e ho꞉len do꞉la꞉fo꞉ fa꞉la꞉da꞉in a꞉no꞉ kalaleli hen a꞉na sabiki, Sa꞉da꞉na꞉ eyo꞉ Ya꞉suwo꞉ a꞉na da꞉fe ba꞉da꞉len. Ho꞉len a꞉namio꞉ Ya꞉suwo꞉ ma꞉no꞉wo꞉ mada mo꞉nabikiyo꞉, maiyo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","A꞉la꞉go꞉ko꞉lo꞉ Sa꞉da꞉na꞉ eyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Ge Godeya꞉ so꞉walelalega, u we ma꞉n fa꞉la꞉doma꞉ki sama.” ");
INSERT INTO bco_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ya꞉su eyo꞉ emo꞉ a꞉ma꞉la꞉ sa꞉laki, “Godeya꞉ bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉lab, ‘Ma꞉no꞉leko꞉ na꞉lab a꞉ma꞉yo꞉, mela꞉no꞉ hendeleyo꞉ mo꞉dimia꞉sen.’” ");
INSERT INTO bco_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Sa꞉da꞉na꞉ eyo꞉ Ya꞉suwo꞉ iwalu tililia꞉ga꞉ fa꞉la꞉dowakiyo꞉, wigibole a꞉naka henfelo꞉ amilo꞉ amisa꞉n dila꞉ we tambo emo꞉ widabi ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ba꞉da꞉sa꞉ga꞉ Sa꞉da꞉na꞉ eyo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Henfelo꞉ amilo꞉ amisa꞉n we tambo ge misa꞉ kalu iliki bo꞉fo꞉melea꞉ki, niyo꞉ halaido꞉wo꞉ gemo꞉ dimia꞉no꞉ ko꞉lo꞉, ge wabulun kalu doma꞉ib. Halaido꞉ a꞉no꞉ nemo꞉ dimi ko꞉lo꞉, kalu o꞉bmo꞉wa꞉le dimia꞉no꞉ dowalega, niyo꞉ o꞉lika dimia꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","A꞉la꞉fo꞉ko꞉lo꞉ ge ni ha꞉ga dowaki, ne dulugu sa꞉lalega, niyo꞉ kelego꞉ we tambo gemo꞉ dimia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Godeya꞉ bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, ‘Giyo꞉ go꞉no꞉ Gode, Kalu Alan a꞉ma꞉ ha꞉ga dowakiyo꞉, imilig eko꞉ wabudaki dulugu sa꞉la꞉bi.’ ” ");
INSERT INTO bco_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","A꞉la꞉ta꞉ga꞉ Sa꞉da꞉na꞉ eyo꞉ Ya꞉suwo꞉ tililia꞉sa꞉ga꞉ Ya꞉lusalem a꞉na ha꞉nakiyo꞉, Godeya꞉ Malilo꞉ a doga꞉ wa꞉la fa꞉la꞉ ha꞉na꞉sa꞉ga꞉ kagayaki, emo꞉wo꞉ a꞉la꞉sio꞉. “Ge Godeya꞉ so꞉walelalega, hen holona ho꞉lufoma. ");
INSERT INTO bco_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Mo꞉wo꞉ Godeya꞉ bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉ ko꞉lo꞉ da꞉lab, “‘Gode eyo꞉ ene ma꞉mula꞉ kalumo꞉wo꞉ ge asuwa꞉foma꞉ki sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Gi gibo꞉ u amio꞉ walalabena꞉ki, ili dagi wa꞉la talulia꞉ib.’” ");
INSERT INTO bco_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Godeya꞉ to sa꞉sa꞉lo꞉ a꞉namio꞉ a꞉la꞉sio꞉ ko꞉lo꞉lab, ‘Giyo꞉ go꞉no꞉n Gode, Kalu Alan a꞉no꞉ da꞉feakiyo꞉ nodo ba꞉da꞉so꞉bo.’” ");
INSERT INTO bco_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sa꞉da꞉na꞉ eyo꞉ Ya꞉suwo꞉ da꞉fe ba꞉da꞉i ha꞉na꞉len a꞉no꞉ eda꞉sa꞉ga꞉yo꞉, ho꞉len nafa nowo꞉ fa꞉la꞉dowalikilo꞉ da꞉fema꞉no꞉ a꞉no꞉ ko꞉lo꞉ yasilakiyo꞉, Ya꞉suwo꞉ ta꞉fo꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mama Malilo꞉wa꞉ halaido꞉wo꞉ Ya꞉su e o꞉lia꞉ iliki, e Ga꞉lili a꞉ma꞉la꞉ ane. Ya꞉sulo꞉ doba꞉da꞉lo꞉ malolo꞉ a꞉no꞉ amisa꞉n us a꞉namilo꞉ ta꞉i ane a꞉no꞉ tambo da꞉da꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ho꞉len a꞉namio꞉ Ya꞉su eyo꞉ tolo꞉ wida꞉sen a usa ha꞉na꞉sa꞉ga꞉, mano꞉ a꞉na widabiyo꞉, kaluka꞉isale iliyo꞉ e a꞉na wabuda꞉len. ");
INSERT INTO bco_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","17","A꞉la꞉ga꞉sa꞉ga꞉yo꞉ Ya꞉su e, elo꞉ anayo꞉ hen Nasala꞉t amisa꞉n a꞉na a꞉ma꞉la꞉ ane. Ha꞉fo꞉lo꞉ Dowan ho꞉leno꞉ dowabiki, Ya꞉su e enedo꞉ dimida꞉sen au dimidaki, tolo꞉ wida꞉sen a a꞉na tiane. E Godeya꞉ to sa꞉sa꞉lo꞉ a꞉na agelema꞉no꞉ a꞉la꞉ta꞉ga꞉ dasiliabikiyo꞉, iliyo꞉ dinali sa꞉lan kalu Aisaya elo꞉ sa꞉sa꞉lo꞉ kombo꞉ a꞉no꞉ emo꞉ dimi. Eyo꞉ kombo꞉ a꞉no꞉ a꞉ma꞉la꞉ fagela꞉sa꞉ga꞉, to sa꞉sa꞉lo꞉ we ba꞉da꞉sa꞉ga꞉ a꞉na agelo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Godeya꞉ Mamayo꞉ neya sab. Ne to nafa a꞉no꞉ wa꞉feyo꞉ kalumo꞉wo꞉ walama꞉ki, eyo꞉ ne a꞉na da꞉feyo꞉. Eyo꞉ ne kaluka꞉isalelo꞉wa iliga꞉takiyo꞉, dibolo amilo꞉ sab kalu a꞉no꞉ sili alifoma꞉kiyo꞉, a꞉la꞉ta꞉ga꞉ siyo꞉ ko꞉n kalu sab a꞉no꞉ fagela꞉sa꞉ga꞉ a꞉bo꞉ba꞉kiyo꞉, a꞉la꞉ta꞉ga꞉ kaluka꞉isale nolba꞉lo꞉ wa꞉la꞉ sa꞉ndakilo꞉ sab a꞉no꞉ ga꞉li mesea꞉ki, Ne a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","A꞉la꞉ta꞉ga꞉ o꞉go꞉ Godeya꞉lo꞉ nimo꞉lo꞉ ha꞉fo꞉ disa꞉ma꞉no꞉ ho꞉len a꞉no꞉ fa꞉la꞉dowab a꞉la꞉liki, nemo꞉ sama꞉ki iliga꞉fo꞉.” ");
INSERT INTO bco_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ya꞉su eyo꞉ to a꞉no꞉ agela꞉sa꞉ga꞉, kombo꞉wo꞉ a꞉ma꞉la꞉ kambola꞉sa꞉ga꞉yo꞉, o꞉lo꞉ dia꞉fo꞉len kalu o꞉mo꞉ dimia꞉sa꞉ga꞉, e mesa꞉ni ane. E asitabiki kaluka꞉isale tolo꞉ wida꞉sen ayamilo꞉ sen a꞉no꞉ tambo eko꞉ sikudu ba꞉dabikiyo꞉, ");
INSERT INTO bco_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ya꞉su eyo꞉ imo꞉wo꞉ mo꞉mo꞉da widakiyo꞉ a꞉la꞉sio꞉, “Godeya꞉ to ko꞉lo꞉ gilo꞉ da꞉dab a꞉no꞉ o꞉go꞉ hendele fa꞉la꞉dowab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iliyo꞉ to nafale elo꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉, molo asulaki, “E nafaka꞉” a꞉la꞉duludakiyo꞉, iliyo꞉ “Wai! Kalu we Yosa꞉ba꞉ inso꞉wa꞉le?” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉ “Gio꞉ nemo꞉wo꞉ mada a꞉la꞉sa꞉ma꞉ib, ‘Falela꞉sen kaluwo꞉ ge ko꞉lo꞉ go꞉no꞉na꞉ma꞉la꞉yo꞉ mada falele alifoma!’ Giliyo꞉ nemo꞉ bale sa꞉lakiyo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Kabaniom amisa꞉n amilo꞉ gilo꞉ dimido꞉ a꞉no꞉ nio꞉ dabu ko꞉lo꞉, giyo꞉ go꞉no꞉n amisa꞉n wenamio꞉lo꞉ a꞉la꞉dimidama.’ ");
INSERT INTO bco_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Niyo꞉ mada hendele gimo꞉ so꞉lo꞉l. Dinali sa꞉lan kaluwa꞉yo꞉ towo꞉ ene amisa꞉na widab amio꞉, kaluka꞉isale iliyo꞉ e mo꞉wabuda꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Niyo꞉ to a꞉no꞉ wa꞉ka kudu sa꞉ma꞉nigo꞉l. Dinali sa꞉lan kalu Elaiyalo꞉ elen ho꞉len a꞉namio꞉ dona otalen a꞉la꞉ta꞉ga꞉ ele do꞉go꞉fela꞉fo꞉ us a꞉namio꞉ ho꞉no꞉ mada mo꞉tinda꞉len ko꞉lo꞉, ma꞉n ma꞉no꞉wo꞉ mo꞉fa꞉la꞉ndaki, iyo꞉ maiyo꞉wo꞉ alan dowo꞉. Ho꞉len a꞉namio꞉ ga sa꞉ba꞉lo꞉ modo꞉ nolo꞉ Isolael hen a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ko꞉sega Gode eyo꞉ Isolael ga sa꞉ba꞉la꞉lo꞉ a꞉namio꞉ Elaiya e mo꞉iliga꞉fo꞉. A꞉la꞉ba. Gode eyo꞉ Elaiya e Saido꞉n hen a꞉na iliga꞉taki, ga sa꞉ba꞉lo꞉ nowo꞉ Salefat amisa꞉n amilo꞉ sabdo꞉ a꞉na iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","O꞉leau ka, dinali sa꞉lan kalu Elaisalo꞉ elen ho꞉len amio꞉lo꞉, aintalo꞉ sen kalu modo꞉wo꞉ Isolael hen a꞉na sen ko꞉sega, i amio꞉ imilig noma꞉lo꞉wo꞉ mo꞉falele alifa꞉. A꞉la꞉ba, Silia kalu, Naman eko꞉ falele alifa꞉.” ");
INSERT INTO bco_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ya꞉suwa꞉yo꞉ a꞉la꞉sa꞉labiki, kaluka꞉isale tolo꞉ wida꞉sen ayamilo꞉ sen a꞉no꞉ tambo da꞉da꞉sa꞉ga꞉yo꞉, Ya꞉sumo꞉wo꞉ gadio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Iyo꞉ dasila꞉sa꞉ga꞉ Ya꞉suwo꞉ amisa꞉n ha꞉la꞉ya hamana꞉ki o꞉luga꞉fo꞉. Iliyo꞉ e susululia꞉ga꞉, hen misio꞉lo꞉ buluso꞉no꞉ a꞉na kani to꞉loma꞉no꞉ a꞉la꞉liki tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ko꞉sega eyo꞉ iyo꞉ ka ta꞉takiyo꞉, kaluka꞉isale noldo꞉ a꞉lab us a꞉namio꞉ ga꞉li ane. ");
INSERT INTO bco_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ya꞉su e Ga꞉lili hen Kabaniom amisa꞉n a꞉na tina꞉sa꞉gayo꞉, Ha꞉fo꞉lo꞉ Dowan ho꞉leno꞉ dowabiki, eyo꞉ kaluka꞉isalemo꞉wo꞉ Godeya꞉ towo꞉ a꞉na mo꞉mo꞉da wido꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ya꞉su eyo꞉ towo꞉ halaido꞉ wido꞉ ko꞉lo꞉ iliyo꞉ to a꞉no꞉ molo dabu. ");
INSERT INTO bco_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kalu nowo꞉ mama mogago꞉lo꞉ dowo꞉ a꞉no꞉ tolo꞉ wida꞉sen ayami sen ko꞉lo꞉ eyo꞉ halale sa꞉laki a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“A! Ya꞉su Nasala꞉t kalu ge, nilo꞉ wiyo꞉ wagama꞉ni mio꞉wo꞉? Ge nio꞉ ko꞉lo꞉ mogaila꞉ma꞉ni mio꞉wo꞉? Ne ge asulab. Godeya꞉ ene Malilo꞉ kaluwo꞉ ge.” ");
INSERT INTO bco_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ emo꞉ halaido꞉ sa꞉laki, “Ge tola꞉so꞉bo! Kalu ko ta꞉ta꞉ga꞉, ha꞉la꞉ya handaloma!” A꞉la꞉sa꞉labiki mama mogago꞉wa꞉yo꞉ kalu a꞉no꞉ ta꞉uliaki, ilo꞉ elen milif a꞉na besea꞉sa꞉ga꞉, mama mogago꞉ a꞉no꞉ kaluwo꞉ mo꞉mogagaki ta꞉fo꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kaluka꞉isale tambo molo asula꞉sa꞉ga꞉ egelebo꞉ a꞉la꞉sio꞉, “Wai! Kalu wema꞉lo꞉ to sa꞉lab we waga widakigaba꞉le? E halaido꞉wo꞉ iliki, mama mogago꞉mo꞉wo꞉ towo꞉ halaido꞉ sa꞉labikiyo꞉, iyo꞉ a꞉no꞉ ko꞉lo꞉ kudu ha꞉naki, ha꞉la꞉ya handalota꞉ga꞉ ha꞉na꞉sio꞉.” ");
INSERT INTO bco_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","A꞉la꞉fo꞉ko꞉lo꞉ Ya꞉su elo꞉ dimido꞉ a꞉no꞉ malolabikiyo꞉, kaluka꞉isale us a꞉namilo꞉ ta꞉i ane a꞉no꞉ tambo da꞉da꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ya꞉su e tolo꞉ wida꞉sen ayo꞉ ta꞉ta꞉sa꞉ga꞉, Saimon Bidaya꞉ ene aya ane. Saimona꞉ ingaya꞉ anowo꞉ ofo꞉ walafo꞉ alan bo꞉lo꞉ ko꞉lo꞉, iliyo꞉ Ya꞉sumo꞉ asuwa꞉foma꞉ki dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","A꞉la꞉gabiki Ya꞉su e ga elo꞉ alifo꞉lab anib a꞉na kagayakiyo꞉, walafdo꞉ delen o꞉mo꞉wo꞉ halaido꞉ sio꞉ ko꞉lo꞉, walaf a꞉no꞉ a꞉na bulufo꞉. Wigibo a꞉naka, ga a꞉no꞉ dasilia꞉ga꞉, egeledo꞉ ma꞉n ma꞉no꞉ a꞉no꞉ a꞉na mo꞉mo꞉da so꞉fa꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ofo꞉ tinaki Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉no꞉ elema꞉no꞉ dowabiki, kaluka꞉isale walaf ko꞉li ko꞉lilo꞉lo꞉ dosdo꞉ a꞉no꞉ Ya꞉sulo꞉wa tililia꞉mio꞉. Ya꞉su e dagiyo꞉ kaluka꞉isale ina꞉li ina꞉lilo꞉wa꞉ wa꞉la golabikiyo꞉, iyo꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","A꞉la꞉ta꞉ga꞉ mama mogago꞉wo꞉ kaluka꞉isale modo꞉ a꞉namilo꞉ sen a꞉no꞉ tambo ha꞉na꞉sia꞉likiyo꞉, halale sa꞉laki, “Ge Godeya꞉ ene so꞉waleka꞉” a꞉la꞉sio꞉. Ko꞉sega iyo꞉ towo꞉ mo꞉sama꞉ki, Ya꞉su eyo꞉ imo꞉wo꞉ halaido꞉ sio꞉. Mo꞉wo꞉ iliyo꞉ e Godeya꞉ Da꞉feyo꞉ kalu a꞉labo꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kea꞉fo nulu amio꞉ Ya꞉suwo꞉ ina꞉li mesa꞉niki, kalaleli hen doba꞉da꞉ ane. Kaluka꞉isale iliyo꞉ e keda꞉li ha꞉na꞉sa꞉ga꞉ ba꞉dakiyo꞉, iliyo꞉ Ya꞉su e iyo꞉ mo꞉ta꞉fo꞉ hamana꞉ki susio꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ko꞉sega eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉nigab to nafa a꞉no꞉ amisa꞉n nol amio꞉ wida꞉li sia꞉mela꞉no꞉. Mo꞉wo꞉ Gode eyo꞉ ne nanog a꞉no꞉ ko꞉lo꞉ dimidama꞉ki iliga꞉fo꞉,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","A꞉la꞉fo꞉ko꞉lo꞉ e Yudia hen a꞉naka sia꞉likiyo꞉, tolo꞉ wida꞉sen aya mano꞉ a꞉na wida꞉len. ");
INSERT INTO bco_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ho꞉len no amio꞉ Ya꞉suwo꞉ Genesalet ho꞉n golo꞉ sa꞉ya kagafo꞉liki, kaluka꞉isale modo꞉wo꞉ elo꞉wa kegea꞉sa꞉ga꞉, Godeya꞉ to elo꞉ widab a꞉no꞉ ko꞉lo꞉ da꞉da꞉len. ");
INSERT INTO bco_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ka꞉lo꞉ to꞉lolan kalu nolba꞉yo꞉ ho꞉n ko꞉su a꞉la꞉ a꞉no꞉ sa꞉wa꞉la susululia꞉ga꞉ dia꞉takiyo꞉, iyo꞉ ini dageyo꞉ ko꞉lo꞉ hala꞉liki a꞉labikiyo꞉, Ya꞉su eyo꞉ ho꞉n ko꞉su a꞉la꞉ a꞉no꞉ a꞉na ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","E Saimona꞉ ko꞉suwa asita꞉ga꞉, Saimonbo꞉ ho꞉n mogan hononamida꞉ aniga꞉foma a꞉la꞉sio꞉. E a꞉na siliki, kaluka꞉isale imo꞉ towo꞉ a꞉na wido꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eyo꞉ towo꞉ wida꞉la꞉ga꞉ eletakiyo꞉, Saimonbo꞉wo꞉ a꞉la꞉sio꞉, “Ge ho꞉n ko꞉su we ko꞉lalia꞉ga꞉ ho꞉n golo꞉ us a꞉na ha꞉na꞉sa꞉ga꞉, ka꞉yo꞉ to꞉loma꞉niki, dageyo꞉ fase to꞉lofelema.” ");
INSERT INTO bco_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A꞉la꞉sa꞉labiki, Saimon eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Nio꞉ o꞉g nuluwo꞉ nanogo꞉ halaido꞉ dimidaki, dage to꞉lola꞉len amio꞉ ka꞉ imilig nowo꞉ mada mo꞉di. Ko꞉sega o꞉go꞉ giyo꞉ sa꞉labo꞉lo꞉biki, niliyo꞉ dageyo꞉ ka to꞉loma꞉nigo꞉l.” ");
INSERT INTO bco_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Iliyo꞉ a꞉la꞉dimida꞉sa꞉ga꞉yo꞉, ka꞉yo꞉ modo꞉ walalabiki, dage a꞉no꞉ mada mo꞉mo꞉da gegedo꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","A꞉la꞉go꞉ko꞉lo꞉ iliyo꞉ egeledo꞉ nanogdo꞉ dia꞉sen kalu, ho꞉n ko꞉su no amilo꞉ sab a꞉no꞉ iyo꞉ asuwa꞉fa꞉ mena꞉ki, dagiya꞉ da꞉feaki ho꞉ido꞉. I a꞉no꞉ ya꞉sa꞉ga꞉ ami ka꞉ a꞉no꞉ ko꞉su ilido꞉wa alobana disa꞉labiki, ho꞉n ko꞉su a꞉la꞉ a꞉no꞉ ka꞉ya꞉ hida꞉yaki ho꞉na tina꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Bida e a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉ gido꞉fo꞉lo꞉wa gulalu misa꞉fu alilaki, a꞉la꞉sio꞉, “Kalu Alan, ne mada mogago꞉ kalu ko꞉lo꞉ giyo꞉ ne ta꞉ta꞉sa꞉ga꞉ hamana.” ");
INSERT INTO bco_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Elo꞉ a꞉la꞉do꞉ sio꞉wo꞉ mo꞉wo꞉ we. E o꞉lia꞉ iasi kalu o꞉lia꞉ma꞉yo꞉ ka꞉ modo꞉ di a꞉no꞉ ba꞉da꞉sa꞉ga꞉, iyo꞉ molo tandeo꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","A꞉la꞉ta꞉ga꞉ Saimon o꞉lia꞉lo꞉ nanogo꞉ ualo꞉ dia꞉sen kalu a꞉la꞉ nowo꞉, Sa꞉ba꞉diya꞉ so꞉wa Ya꞉ma꞉s dia꞉ Yo꞉n dia꞉yo꞉lo꞉ ba꞉da꞉sa꞉ga꞉ molo tandeo꞉. A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ Saimonbo꞉wo꞉ a꞉la꞉sio꞉, “Tagila꞉so꞉bo! O꞉g wena a꞉la꞉ta꞉ga꞉ tif amio꞉lo꞉ gilo꞉ ka꞉ dian o꞉leaumbo꞉ kaluka꞉isaleyo꞉ a꞉la꞉dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","A꞉la꞉sa꞉labiki iyo꞉ ho꞉n ko꞉su a꞉la꞉ a꞉no꞉ susululia꞉ga꞉ ha꞉la꞉ya dia꞉ta꞉ga꞉yo꞉, kelego꞉ a꞉no꞉ tambo ta꞉taki, iyo꞉ Ya꞉su kudu ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ya꞉su e amisa꞉n nowa sabikiyo꞉, aintalo꞉ kandayo꞉ kalu nowo꞉ elo꞉wa mio꞉. Kalu a꞉no꞉ Ya꞉suwo꞉ ba꞉da꞉sa꞉ga꞉, Ya꞉suwa꞉ milifdo꞉ a꞉na gumisi alilaki ha꞉nolo sio꞉, “Kalu Alan giyo꞉ ne falele alifa꞉no꞉ asulalega, ne malilo꞉wo꞉ o꞉li ta꞉fa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ya꞉suwa꞉ dagiyo꞉ talagalaki, kalu a꞉ma꞉ do꞉mo꞉wa golakiyo꞉ a꞉la꞉sio꞉, “Niyo꞉ ge o꞉li asuwa꞉fa꞉nigo꞉l ko꞉lo꞉, do꞉mo꞉ gilo꞉wo꞉ falele alitaki malilo꞉ ta꞉to꞉l.” Wigibole a꞉naka, aintalo꞉ sen kalu a꞉no꞉ imula꞉sa꞉ga꞉, do꞉mo꞉ elo꞉wo꞉ nafale dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ya꞉suwa꞉yo꞉ kalumo꞉wo꞉ halaido꞉ sa꞉laki a꞉la꞉sio꞉, “Gelo꞉ falele alitab we, kalu nolbo꞉wo꞉ mada sa꞉la꞉so꞉bo. Kaluka꞉isale tambowa꞉yo꞉ gi ogen ko falelo꞉lo꞉b a꞉la꞉asuluma꞉ki, ge bobalo꞉ so꞉mea꞉sen kalumo꞉wo꞉ walama꞉ni ha꞉na꞉sa꞉ga꞉, Mo꞉sa꞉sa꞉ ele saefa꞉ a꞉no꞉ kudu ha꞉nakiyo꞉, Godemo꞉ boba so꞉kugulu mea꞉niki hamana.” ");
INSERT INTO bco_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ko꞉sega Ya꞉su elo꞉ dimido꞉ a꞉no꞉ mada safoda꞉i ane ko꞉lo꞉, kaluka꞉isale modo꞉wo꞉ elo꞉ widab a꞉no꞉ ba꞉ba꞉no꞉ a꞉la꞉ta꞉ga꞉ i amilo꞉ walafdo꞉ dosdo꞉ a꞉no꞉ falele alifoma꞉ki, Ya꞉sulo꞉wa ya꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ko꞉sega ho꞉len nol amio꞉, e kaluka꞉isaleyo꞉ ta꞉taki kalulo꞉ma hen a꞉na ha꞉na꞉sa꞉ga꞉, Godemo꞉ dulugu sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ho꞉len no amio꞉ Ya꞉suwo꞉ kaluka꞉isalemo꞉ mano꞉ wida꞉len amio꞉, Fa꞉lisi kaluwo꞉lo꞉ Yuwa꞉ elelo꞉ widan kaluwo꞉lo꞉ Ya꞉suwa꞉lo꞉ man wida꞉lab a꞉no꞉ da꞉da꞉liki sen. Iyo꞉ amisa꞉n ko꞉li ko꞉lilo꞉ Ga꞉lili heno꞉lo꞉ Yudia heno꞉lo꞉ a꞉la꞉ta꞉ga꞉ Ya꞉lusalem a꞉na a꞉la꞉ta꞉ga꞉yo꞉lo꞉ mio꞉. A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ walaf kaluwo꞉ falele alifelema꞉ki, Gode Alana꞉ ene halaido꞉wo꞉ e amio꞉ elen. ");
INSERT INTO bco_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kalu nolba꞉yo꞉ ko꞉go꞉neli kalu no꞉wo꞉ sesegasulia꞉ yakiyo꞉, Ya꞉sulo꞉ a꞉lab milif a꞉na a usa dia꞉fa꞉no꞉ a꞉la꞉liki dia꞉mio꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ko꞉sega a uso꞉ kaluwa꞉ wa꞉lifo꞉ ko꞉lo꞉, iliyo꞉ dia꞉ tina꞉no꞉wo꞉ fogo꞉ mo꞉dowabiki, iyo꞉ a fa꞉sa꞉ wa꞉la fa꞉la꞉ ha꞉na꞉sa꞉ga꞉yo꞉, a fugo꞉wo꞉ sudula꞉sa꞉ga꞉, kalu sesegasu a꞉no꞉ kalu kegeo꞉ us a꞉na to꞉lolakiyo꞉, Ya꞉sulo꞉ a꞉lab milif a꞉na ti ali. ");
INSERT INTO bco_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ya꞉su eyo꞉ ililo꞉ tilidabu a꞉no꞉ ba꞉da꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Ni mili, mogago꞉ gilo꞉ dimida꞉sen a꞉no꞉ hala꞉sa꞉ga꞉ ga꞉lilo꞉l,” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","A꞉la꞉gabiki, Fa꞉lisi kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ma꞉yo꞉ a꞉la꞉kele asulo꞉. “Mogago꞉wo꞉ hala꞉sa꞉ga꞉lo꞉ ga꞉lilan a꞉no꞉ Gode eka dimida꞉sen. Kalu wema꞉yo꞉ Godeya꞉ heno꞉ e diaki sa꞉laigaba꞉le? Kalu we o꞉bo꞉ngo꞉ iliki dimidaba꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ya꞉su eyo꞉ ililo꞉ asulab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Gili asulo꞉ us amilo꞉ asulab a꞉no꞉ waga asulakigaya? ");
INSERT INTO bco_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","To sa꞉ma꞉no꞉ halaido꞉leyo꞉ ho꞉bo꞉ko꞉mo꞉? Niyo꞉ tamin amio꞉ a꞉la꞉sio꞉, ‘Mogago꞉ da꞉labko o꞉go꞉ Godeya꞉ ga꞉lilab’ a꞉la꞉bo꞉, henfelo꞉ kaluwa꞉yo꞉ o꞉li sa꞉lano꞉? A꞉la꞉ta꞉ga꞉ to nowo꞉ we ‘Ge dasilia꞉ga꞉ hamana!’ a꞉la꞉do꞉ sa꞉lab a꞉no꞉, henfelo꞉ kaluwa꞉yo꞉ o꞉li sa꞉lano꞉? Giliyo꞉ waga asulaya? ");
INSERT INTO bco_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ko꞉sega Kalule Dowo꞉ ne henfelo꞉ wena ilikiyo꞉, mogago꞉wo꞉ halakilo꞉ ga꞉lila꞉ma꞉no꞉ a꞉no꞉ ne amio꞉ halaido꞉wo꞉ a꞉labo꞉lo꞉b, a꞉la꞉bo꞉ giyo꞉ asuluma꞉kiyo꞉ walama꞉nigo꞉l.” A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉, ko꞉go꞉neli kalumo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ gemo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Ge dasilia꞉ga꞉, sesegasu we dia꞉ga꞉, go꞉no꞉n aya hamana.” ");
INSERT INTO bco_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wigibo a꞉naka kaluka꞉isale ili siwa꞉l amio꞉ e dasilia꞉sa꞉ga꞉, ene geo꞉ndo꞉wo꞉ dia꞉sa꞉ga꞉, a꞉ma꞉la꞉ ene aya ha꞉nakiyo꞉, Godeya꞉ wiyo꞉ duluda꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kalu iyo꞉ tambo molo tandeakiyo꞉, Godeya꞉ wiyo꞉ dulugu sio꞉. Iliyo꞉ iligakiyo꞉, “O꞉go꞉ we nio꞉ mada ko꞉li bo꞉do꞉lka꞉” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","A꞉ma꞉ fa꞉s amio꞉ Ya꞉suwo꞉ ha꞉na꞉sa꞉ga꞉ takis molelo꞉ dia꞉sen kalu nowo꞉, ene nanogdo꞉ dia꞉sen aya sena ba꞉ba꞉. Ene wiyo꞉ Libai ko꞉lo꞉ Ya꞉suwa꞉yo꞉ e ba꞉da꞉ga꞉ a꞉la꞉sio꞉, “Ge ne kudu mena.” ");
INSERT INTO bco_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","A꞉la꞉sa꞉labiki, Libai e dasila꞉sa꞉ga꞉, ene kelego꞉ a꞉no꞉ tambo a꞉naka ta꞉ta꞉ga꞉, Ya꞉suwo꞉ kudu ane. ");
INSERT INTO bco_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Libai eyo꞉ Ya꞉suwo꞉ sagale alitakiyo꞉, ma꞉no꞉ alan a꞉no꞉ e aya dimidali ko꞉lo꞉, takis molelo꞉ dia꞉sen kalu iyo꞉ a꞉la꞉ta꞉ga꞉ kalu nolo꞉ a꞉na Ya꞉su o꞉lia꞉ kegea꞉sa꞉ga꞉, ma꞉no꞉wo꞉ a꞉na ma꞉ni sen. ");
INSERT INTO bco_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ko꞉sega Fa꞉lisi kalu i o꞉lia꞉ elelo꞉ wida꞉sen kalu i o꞉lia꞉ma꞉yo꞉ Ya꞉suwa꞉ enedo꞉ tiliwida꞉sen kalumo꞉wo꞉ eteaki a꞉la꞉sio꞉, “Gio꞉ takis molelo꞉ dia꞉sen kalu o꞉lia꞉ mogago꞉lo꞉ dimida꞉sen kalu nol o꞉lia꞉yo꞉ ua silikiyo꞉, ma꞉no꞉wo꞉ waga naya?” ");
INSERT INTO bco_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ya꞉suwa꞉yo꞉ imo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu walafdo꞉ma a꞉no꞉ mulumulo꞉lo꞉ mean kalulo꞉ amio꞉ mo꞉ha꞉nan. Ko꞉sega kalu walafdo꞉ bo꞉lo꞉ a꞉no꞉ mulumulo꞉lo꞉ mean kalulo꞉ amio꞉ ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","O꞉leaumbo꞉ ne digalo꞉ kalu sab o꞉lo꞉wa mio꞉ma. Ne mogago꞉lo꞉ dimida꞉lab kalu ili asulo꞉wo꞉ nodola꞉sa꞉ga꞉ foga꞉le sama꞉ki mio꞉.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Kalu nolba꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Yo꞉na꞉lo꞉ tiliwida꞉sen kalu iyo꞉ ho꞉len nol amio꞉ ma꞉n ma꞉no꞉wo꞉ eletakiyo꞉, Godemo꞉ dulugu sa꞉la꞉len. A꞉la꞉ta꞉ga꞉ Fa꞉lisiya꞉lo꞉ tiliwida꞉sen kalu iliyo꞉lo꞉ a꞉la꞉ka dimida꞉len. Ko꞉sega gilo꞉ tiliwida꞉sen kalu iliyo꞉ ma꞉n o꞉lia꞉ ho꞉n o꞉lia꞉ko꞉ na꞉lowa꞉sen.” ");
INSERT INTO bco_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","A꞉la꞉sa꞉labiki Ya꞉suwa꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Galo꞉ tili alitakilo꞉ sagalab ho꞉len a꞉namio꞉, kalu galo꞉ dia꞉nigab a꞉no꞉ gi o꞉lia꞉ silikiyo꞉, kalu kegeo꞉ o꞉mo꞉wo꞉ ma꞉no꞉wo꞉ na꞉so꞉boka꞉ a꞉la꞉bo꞉ giliyo꞉ mada mo꞉sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko꞉sega tif amio꞉ gis kaluwa꞉yo꞉ galo꞉ diab kalu e dia꞉sa꞉ga꞉ ha꞉nalikiyo꞉, ma꞉n ma꞉no꞉wo꞉ a꞉na o꞉li elema꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","A꞉la꞉ta꞉ga꞉ Ya꞉suwa꞉yo꞉ imo꞉ bale sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Kalu noma꞉yo꞉ so꞉g sa꞉ga꞉la꞉sen mo꞉luwo꞉ bidi ane a꞉no꞉ dowalega, eyo꞉ so꞉g sa꞉ga꞉la꞉sen ho꞉gi heb nowo꞉ gedea꞉sa꞉ga꞉yo꞉, so꞉g mo꞉luwo꞉ a꞉namio꞉ mo꞉dubinima꞉ib. Mo꞉wo꞉ eyo꞉ a꞉la꞉dimidalega, so꞉g ho꞉gi a꞉no꞉ mogagilaki, a꞉la꞉ta꞉ga꞉ so꞉g mo꞉luwo꞉ a꞉namio꞉, ho꞉gi heb a꞉no꞉lia꞉yo꞉ mo꞉imilo꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","A꞉la꞉ta꞉ga꞉yo꞉ kalu noma꞉yo꞉ wain ho꞉n ho꞉gi a꞉no꞉ no꞉ do꞉go꞉f dubio꞉ mo꞉luwo꞉ us a꞉namio꞉ mo꞉guma꞉ib. A꞉la꞉dimidalega, wain ho꞉gi a꞉ma꞉ ho ha꞉na꞉no꞉wo꞉ ko꞉ndo꞉feaki, no꞉ do꞉go꞉f mo꞉luwo꞉ a꞉no꞉ bidi buluga꞉talikiyo꞉, wain ho꞉n a꞉no꞉ hena walaki, no꞉ do꞉go꞉f dubio꞉ a꞉no꞉ mogago꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","A꞉la꞉go꞉ko꞉lo꞉ wain ho꞉n ho꞉gi a꞉no꞉ no꞉ do꞉go꞉f dubio꞉ ho꞉gi a꞉na guma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ wain ho꞉n mo꞉luwo꞉ a꞉no꞉ nalikiyo꞉, wain ho꞉n ho꞉gi a꞉no꞉ ma꞉no꞉wo꞉ mo꞉asuluma꞉ib. Mo꞉wo꞉ eyo꞉ a꞉la꞉sio꞉, ‘Mo꞉luwo꞉ a꞉no꞉ nafaka꞉’ a꞉la꞉sa꞉ma꞉ib.” Ya꞉su eyo꞉ a꞉la꞉ bale sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ha꞉fo꞉lo꞉ Dowan ho꞉len no amio꞉, Ya꞉suwo꞉ da꞉si wit egelo꞉ usa ha꞉nakiyo꞉, enedo꞉ tili wida꞉sen kaluwa꞉yo꞉ da꞉si fo nolo꞉ tudu sa꞉la꞉la꞉i ha꞉nakiyo꞉, beb a꞉no꞉ dagiya꞉ haboba꞉liki, uso꞉ na꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ko꞉sega Fa꞉lisi kalu nolba꞉yo꞉ a꞉la꞉dabu ba꞉ba꞉, “Giliyo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len wenamilo꞉ ma꞉no꞉ tulab a꞉ma꞉yo꞉ ele saefa꞉ a꞉no꞉ o꞉go꞉sab ko꞉lo꞉, giliyo꞉ waga dimidaya?” ");
INSERT INTO bco_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Tamin amilo꞉ Da꞉ibido꞉ a꞉la꞉ta꞉ga꞉ e o꞉lia꞉lo꞉ sia꞉lowan kalu iyo꞉ maiyabikilo꞉ dimido꞉ sa꞉sa꞉lo꞉wo꞉ giliyo꞉ mo꞉agelo꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Da꞉ibid e Godeya꞉ aya ha꞉na꞉sa꞉ga꞉, ma꞉no꞉ Godeya꞉ siwa꞉la dia꞉ta꞉sen a꞉no꞉, e dia꞉sa꞉ga꞉ mo꞉no꞉. A꞉la꞉ta꞉ga꞉ ma꞉no꞉ heb a꞉no꞉ egeledo꞉ sia꞉lowan kalumo꞉wo꞉lo꞉ maiya꞉ki dimi. Ko꞉sega eleya꞉ saetakiyo꞉, ma꞉n a꞉no꞉ Godemo꞉lo꞉ bobalo꞉ so꞉mea꞉sen kalu ili ma꞉ib. Madali kalu nolba꞉yo꞉ na꞉so꞉bo a꞉la꞉saefa꞉. A꞉la꞉fo꞉ko꞉lo꞉ Da꞉ibid eyo꞉ ele difa꞉yo꞉ o꞉go꞉so꞉.” ");
INSERT INTO bco_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ to nolo꞉ a꞉la꞉sio꞉, “Kalule Dowo꞉ ne, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉ma꞉ biso꞉wo꞉ ne ko꞉lo꞉, no꞉no꞉n bo꞉fo꞉lo꞉l.” ");
INSERT INTO bco_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ha꞉fo꞉lo꞉ Dowan ho꞉len no amio꞉ Ya꞉su e Yuwa꞉ tolo꞉ wida꞉sen aya tina꞉sa꞉ga꞉ widabiki, dagi ililibo꞉ ga꞉ga꞉nuli dowo꞉ kalu nowo꞉ a꞉na sen. ");
INSERT INTO bco_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Fa꞉lisi kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ma꞉yo꞉ Ya꞉su e hala dimidab a꞉la꞉likilo꞉ mo꞉walilima꞉no꞉ togo꞉ keda꞉len ko꞉lo꞉, iliyo꞉ Ya꞉su eyo꞉ Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namio꞉ dagiyo꞉ ga꞉ga꞉nuli kalu a꞉no꞉ falele alitaba꞉le a꞉la꞉liki bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ko꞉sega Ya꞉su eyo꞉ ililo꞉ asulo꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉, dagiyo꞉ ga꞉ga꞉nuli kalumo꞉ sa꞉laki, “Ge dasilia꞉ga꞉ kaluka꞉isale siwa꞉l wena kagama꞉ni mena.” A꞉la꞉sa꞉labiki, kalu a꞉no꞉ dasilia꞉sa꞉ga꞉ a꞉na kagayabiki, ");
INSERT INTO bco_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ele saetakiyo꞉, Ha꞉fo꞉lo꞉ Dowan ho꞉len a꞉namio꞉ o꞉b ko꞉lo꞉ dimidama꞉no꞉ saefa꞉yo꞉? Man nafaleyo꞉ o꞉li dimidama꞉no꞉wa꞉le? Mo꞉ man mogago꞉wo꞉ o꞉li dimidama꞉no꞉wa꞉le? Sana soma꞉no꞉wa꞉le? Mo꞉ mela꞉no꞉ a꞉ma꞉la꞉ gasiliakilo꞉ asuwa꞉fa꞉no꞉wa꞉le? Ele saefa꞉ a꞉no꞉ ho꞉bo꞉ko꞉mo꞉lo꞉bo꞉?” ");
INSERT INTO bco_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Ya꞉su eyo꞉ iyo꞉ sigiliga꞉takiyo꞉, kalu emo꞉wo꞉ a꞉la꞉sio꞉, “Ge dagiyo꞉ talagalema.” A꞉la꞉sa꞉labiki, kalu a꞉ma꞉yo꞉ a꞉la꞉dimidakiyo꞉, dagi a꞉no꞉ elen o꞉ngo꞉ nafale dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ko꞉sega Fa꞉lisi kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu i a꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ kulufa꞉yo꞉wo꞉ alan dowaki, “Niliyo꞉ Ya꞉sumo꞉wo꞉ waga dimidama꞉no꞉wa꞉le” a꞉la꞉liki o꞉g a꞉nami nenelo꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ho꞉len no amio꞉ Ya꞉suwo꞉ misio꞉wa Godemo꞉ dulugu sa꞉ma꞉ni ha꞉na꞉sa꞉ga꞉, nulu a꞉na dulugu sa꞉la꞉len. ");
INSERT INTO bco_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kea꞉fo ho꞉le bidabiki, enedo꞉ tiliwida꞉sen kaluwo꞉ ho꞉le kegenelia꞉ga꞉ ta꞉takiyo꞉, eyo꞉ kalu kugula꞉fo꞉ nowo꞉ enedo꞉ iliga꞉felo꞉ kalu doma꞉ki da꞉feyo꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Elo꞉ kalu kugula꞉fo꞉ da꞉feyo꞉wo꞉ we. Nowo꞉ Saimon, Saimon e Ya꞉suwa꞉lo꞉ wi ho꞉gi wikilo꞉wo꞉ Bida. Nowo꞉ ene ao Andulu, nowo꞉ Ya꞉ma꞉s, nowo꞉ Yo꞉n, nowo꞉ Filib, nowo꞉ Batolomiyu. ");
INSERT INTO bco_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Nowo꞉ Madiyu, nowo꞉ Tomas, nowo꞉ Ya꞉ma꞉s, Aofiusa꞉ inso꞉, nowo꞉ Saimon, e gamani ho꞉giyo꞉ e dimo꞉losa꞉ a꞉lakilo꞉ asula꞉sen ko꞉lo꞉ Sa꞉la꞉t kalu a꞉la꞉sa꞉lan. ");
INSERT INTO bco_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Nowo꞉ Yudas, Ya꞉ma꞉sa꞉ inso꞉, a꞉la꞉ta꞉ga꞉ nowo꞉ Yudas Iskaliot, Ya꞉sulo꞉ teledowo꞉wo꞉ e. ");
INSERT INTO bco_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ya꞉su o꞉lia꞉ ene tiliwida꞉sen kalu o꞉lia꞉yo꞉ a꞉ma꞉la꞉ tina꞉sa꞉ga꞉, hen fua꞉lo꞉ a꞉na kagayo꞉. Elo꞉ kudu sia꞉sen kaluka꞉isale nolo꞉lo꞉ a꞉na kegeo꞉. A꞉la꞉ta꞉ga꞉ kaluka꞉isale modo꞉ nolo꞉, Yudia hen a꞉namilo꞉ kandayo꞉wo꞉lo꞉ Ya꞉lusalemdo꞉wo꞉ a꞉la꞉ta꞉ga꞉ so꞉lu ho꞉n anib amilo꞉ amisa꞉n Taya o꞉lia꞉ Saido꞉n o꞉lia꞉ a꞉namilo꞉ kandayo꞉ a꞉no꞉lo꞉ tambo ya꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kaluka꞉isale i a꞉no꞉ Ya꞉suwa꞉lo꞉ widab a꞉no꞉ da꞉ba꞉no꞉ a꞉la꞉ta꞉ga꞉, i amilo꞉ walafdo꞉ a꞉lab a꞉no꞉lo꞉ falele alifelema꞉ki mio꞉. A꞉la꞉ta꞉ga꞉ Ya꞉suwa꞉yo꞉ kaluka꞉isale mama mogago꞉lo꞉ dowo꞉ a꞉no꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Kaluka꞉isale iliyo꞉ Ya꞉suwo꞉ golabikiyo꞉, halaido꞉wo꞉ eya a꞉la꞉ta꞉ga꞉ fa꞉la꞉dowakiyo꞉, walafdo꞉ dowo꞉ a꞉no꞉ falele alifelo꞉. A꞉la꞉gabiki kaluka꞉isale tambowa꞉yo꞉ e amio꞉ goma꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ya꞉su eyo꞉ enedo꞉ tiliwida꞉sen kaluwo꞉ ba꞉dakiyo꞉ a꞉la꞉sio꞉. “Wa꞉feyo꞉ kaluka꞉isale gio꞉, Gode eyo꞉ sagale alitakiyo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen a꞉no꞉ biso꞉wo꞉ gi ko꞉lo꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Kaluka꞉isale o꞉go꞉ maiyo꞉wo꞉ alando꞉ dowab gio꞉, Gode eyo꞉ sagale alitakiyo꞉, ma꞉no꞉wo꞉ o꞉li ilili alifa꞉ib. Kaluka꞉isale o꞉gdo꞉ ya꞉la꞉lab gio꞉, Gode eyo꞉ sagale alitakiyo꞉, gio꞉ o꞉ga꞉li mesea꞉ki ta꞉fa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Gio꞉ Kalule Dowo꞉ kalu a꞉no꞉ kudu ha꞉nab amio꞉, kalu nolba꞉yo꞉ gimo꞉wo꞉ kulufa꞉yaki dianilalikiyo꞉, Gode eyo꞉ gio꞉ sagale alifa꞉ib. Kalu nolba꞉yo꞉ gimo꞉wo꞉ dio꞉gelaki, gili wiyo꞉ mogai sa꞉lalikiyo꞉, Gode eyo꞉ gio꞉ sagale alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ho꞉len a꞉no꞉ fa꞉la꞉dowalikiyo꞉, gio꞉ sagalaki tiya꞉ba꞉bi. Mo꞉wo꞉ Hebene a꞉namio꞉ wa꞉l dia꞉no꞉ alano꞉ a꞉na da꞉lab. Asuluma. Gimo꞉lo꞉ dimidab o꞉leaumbo꞉, ili ema꞉mu i a꞉ma꞉yo꞉ dinali sa꞉lan kalu imo꞉wo꞉lo꞉ a꞉la꞉ka dimido꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Wai! Kelego꞉wo꞉ modo꞉lo꞉ da꞉lab kalu gio꞉ hida꞉yo꞉wo꞉ dia꞉ib. Gio꞉ ha꞉salo꞉ mesa꞉no꞉ a꞉no꞉ o꞉ma di ko꞉m. ");
INSERT INTO bco_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Wai! O꞉go꞉ ma꞉no꞉wo꞉ modo꞉lo꞉ da꞉lab kalu gio꞉ hida꞉yo꞉wo꞉ dia꞉ib. Gio꞉ maiyo꞉wo꞉ alan doma꞉ib. Wai! O꞉go꞉ sagala꞉likilo꞉ o꞉ga꞉lab gio꞉ hida꞉yo꞉wo꞉ dia꞉ib. Gio꞉ nofolakiyo꞉ ya꞉lima꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Wai! Kalu tambowa꞉yo꞉ ‘ge nafaleka꞉’ a꞉la꞉sa꞉lalikiyo꞉, ge hida꞉yo꞉wo꞉ dia꞉ib. Mo꞉wo꞉ ili ema꞉mu i a꞉ma꞉yo꞉ madalilo꞉ dinali sa꞉lan kalu imo꞉wo꞉lo꞉ a꞉la꞉ka dimido꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Kaluka꞉isale ni sio꞉lo꞉ kudu ha꞉na꞉lab gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Gimo꞉lo꞉ gisdo꞉ dowab kalu imo꞉wo꞉ giliyo꞉ ha꞉fo꞉wo꞉ disa꞉la꞉bi. Gimo꞉lo꞉ kulufa꞉yab kaluka꞉isale imo꞉wo꞉, man nafa dimida꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kaluka꞉isale gimo꞉lo꞉ wa꞉sa꞉le sa꞉lab a꞉no꞉ giliyo꞉ imo꞉wo꞉ sagale alita꞉bi. Kaluka꞉isale gimo꞉lo꞉ dianilab a꞉no꞉, giliyo꞉ i a꞉no꞉ Godemo꞉ asuwa꞉foma꞉ki dulugu sa꞉la꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Kalu noma꞉yo꞉ gi babowa yamilalega, giyo꞉ babo nodowo꞉ emo꞉ a꞉wida꞉bi. Kalu noma꞉yo꞉ so꞉g gilo꞉ wa꞉l amilo꞉ sa꞉ga꞉la꞉sen a꞉no꞉ dia꞉no꞉ a꞉laki mo꞉walila꞉sa꞉ga꞉ dialega, so꞉g nol gilo꞉ sa꞉ga꞉la꞉sen a꞉no꞉lo꞉ emo꞉ dimia꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kaluka꞉isale iliyo꞉ gemo꞉wo꞉ dabu ba꞉dalikiyo꞉, giyo꞉ madali dimia꞉bi. Iliyo꞉ kelego꞉ gilo꞉wo꞉ dialega, giyo꞉ go꞉no꞉na꞉ma꞉la꞉ a꞉dia꞉no꞉ a꞉lakiyo꞉ towo꞉ halaido꞉wo꞉ sa꞉la꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Man nafa kalu nolba꞉lo꞉ gemo꞉lo꞉ dimidama꞉kilo꞉ asulab o꞉leau, giyo꞉lo꞉ nolbo꞉wo꞉ a꞉la꞉ka dimida꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Kaluka꞉isale gimo꞉lo꞉ ha꞉fo꞉lo꞉ disa꞉lab o꞉mo꞉wo꞉ giliyo꞉lo꞉ ha꞉fo꞉wo꞉ disa꞉lalega, a꞉na ilikiyo꞉ gio꞉ wi alano꞉ mo꞉doma꞉ib. Mo꞉wo꞉ kalu nolba꞉yo꞉ mogago꞉lo꞉ dimida꞉sen kalu o꞉mo꞉wo꞉ ha꞉fo꞉wo꞉ disa꞉lalega, mogago꞉ kalu iliyo꞉lo꞉ ha꞉fo꞉wo꞉ imo꞉wo꞉ o꞉li disa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Kaluka꞉isale gimo꞉lo꞉ man nafalo꞉ dimidab o꞉mo꞉wo꞉ giliyo꞉ imo꞉wo꞉lo꞉ man nafa dimidalega, a꞉na ilikiyo꞉ gio꞉ wi alano꞉ mo꞉doma꞉ib. Mo꞉wo꞉ mogago꞉ kalu iliyo꞉lo꞉ a꞉la꞉ka dimida꞉len. ");
INSERT INTO bco_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","A꞉la꞉ta꞉ga꞉ giyo꞉ kalu nolba꞉yo꞉ wa꞉lo꞉ a꞉ma꞉la꞉yo꞉ o꞉li dimia꞉ib a꞉la꞉asulaki dimialega, a꞉na ilikiyo꞉ gio꞉ wi alano꞉ mo꞉doma꞉ib. Mo꞉wo꞉ mogago꞉lo꞉ dimida꞉sen kalu iliyo꞉lo꞉ ‘wa꞉lo꞉ o꞉li dimia꞉ib’ a꞉la꞉asulaki, mogago꞉ kalu nolbo꞉wo꞉ a꞉na dimia꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ko꞉sega gimo꞉lo꞉ gisdo꞉ dowab kalu o꞉mo꞉wo꞉ gio꞉ ha꞉fo꞉wo꞉ disa꞉laki, man nafaleyo꞉ dimida꞉bi. Giliyo꞉ wa꞉lo꞉ a꞉ma꞉la꞉yo꞉ mo꞉dia꞉no꞉ a꞉la꞉asulaki, moleyo꞉ madali dimia꞉bi. Giliyo꞉ a꞉la꞉dimidalega, wa꞉l dia꞉no꞉wo꞉ alan dowaki, gio꞉ Gode Iwalulo꞉ A꞉lab a꞉ma꞉ so꞉wale doma꞉ib. Mo꞉wo꞉ Gode eyo꞉ mogago꞉ kaluka꞉isale o꞉lia꞉ emo꞉lo꞉ mada o꞉m a꞉la꞉sa꞉ma꞉no꞉lo꞉ mo꞉asulab kaluka꞉isale i o꞉mo꞉wo꞉lo꞉, Gode eyo꞉ ha꞉fo꞉wo꞉ disa꞉laki, man nafale dimida꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Dowa꞉lo꞉ kaluka꞉isalemo꞉lo꞉ nofola꞉sen aumbo꞉, giliyo꞉lo꞉ kalu nolo꞉ a꞉la꞉ka nofola꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Giyo꞉ kalu nowo꞉ aloba꞉da꞉so꞉bo. Giyo꞉ a꞉la꞉bo꞉ mo꞉dimidalikiyo꞉, Gode eyo꞉ gelo꞉ mo꞉aloba꞉ma꞉ib. Giyo꞉ kalu nowo꞉ aloba꞉dakiyo꞉, ‘Ge mogago꞉ kalu’ a꞉la꞉bo꞉ sa꞉la꞉so꞉bo. Giyo꞉ a꞉la꞉bo꞉ mo꞉dimidalikiyo꞉, Gode eyo꞉ gemo꞉wo꞉ a꞉la꞉bo꞉ mo꞉dimidama꞉ib. Giyo꞉ kalu noma꞉lo꞉ mogago꞉ dimido꞉wo꞉ ga꞉lilema. Giyo꞉ a꞉la꞉dimidalikiyo꞉, Gode eyo꞉ mogago꞉ gilo꞉ dimido꞉ a꞉no꞉lo꞉ ga꞉lila꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Gilo꞉ kelego꞉wo꞉ nolbo꞉wo꞉ dimia꞉bi. A꞉la꞉dimidalikiyo꞉, giyo꞉lo꞉ dia꞉ib. Gode eyo꞉ gilo꞉ dia꞉nigab a꞉no꞉ ko꞉lo꞉ dimidaliakiyo꞉, kali disa꞉la꞉sa꞉ga꞉ wa꞉litab amilo꞉ o꞉go꞉sab o꞉leau ililibo꞉ gemo꞉ dimia꞉ib. Giyo꞉ kalu nolbo꞉lo꞉ dimiab o꞉leauka, Gode eyo꞉ gimo꞉wo꞉ wa꞉lo꞉ a꞉la꞉ka dimia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ya꞉suwa꞉yo꞉ to nowo꞉ imo꞉ bale sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Siyo꞉ ko꞉n kalu noma꞉yo꞉ siyo꞉ ko꞉n kalu nowo꞉ o꞉li tililia꞉ ha꞉na꞉iba? A, a꞉la꞉dimidalega, a꞉la꞉yo꞉ gana a꞉na sulufo꞉ tina꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Tili wida꞉sen kalu a꞉ma꞉yo꞉ elo꞉ widan kaluwo꞉ mo꞉tininima꞉ib. Ko꞉sega iyo꞉ wida꞉sa꞉ga꞉ eletalikiyo꞉, widan kalu o꞉ngo꞉ fa꞉la꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Go꞉no꞉n si amilo꞉ i dafen alan da꞉lab a꞉no꞉ mo꞉asulaki ta꞉fo꞉likiyo꞉, giyo꞉ gao noma꞉ si amilo꞉ i mu da꞉lab a꞉no꞉ waga kele asulaya? ");
INSERT INTO bco_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Go꞉no꞉n si amilo꞉ i banala꞉ da꞉lab a꞉no꞉ mada mo꞉ba꞉dakiyo꞉, gao nowo꞉mbo꞉wo꞉ a꞉la꞉sa꞉laki, ‘Nao, gi si amilo꞉ i mu da꞉lab ko ni dila꞉ma꞉nigo꞉l’ a꞉la꞉bo꞉ waga sa꞉ma꞉no꞉wo꞉? Madali tolo꞉ sa꞉lan kalu giyo꞉, tamin amio꞉ i banala꞉ go꞉no꞉n si amilo꞉ da꞉lab ko꞉le dila꞉sa꞉ga꞉yo꞉, gaowa꞉ si amilo꞉ i mu dila꞉ma꞉no꞉ a꞉no꞉ o꞉li fanda ba꞉ba꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“I nafa a꞉namio꞉, fo mogago꞉wo꞉ mo꞉helema꞉ib. A꞉la꞉ta꞉ga꞉ i mogago꞉ a꞉namio꞉, fo nafayo꞉ mo꞉helema꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","I fo hedab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, i we o꞉mo꞉lo꞉b a꞉la꞉bo꞉ a꞉na asuluma꞉ib. Na꞉bo i amio꞉ uka fowo꞉ mo꞉tulan. A꞉la꞉ta꞉ga꞉ bilisa꞉ me amio꞉ wain fo a꞉no꞉ mo꞉tulan. ");
INSERT INTO bco_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kalu nafa eyo꞉, asulo꞉ nafa e amilo꞉ dila꞉len a꞉no꞉ kalaba handalowakiyo꞉, man nafale a꞉no꞉ ko꞉lo꞉ dimida꞉mela꞉ib. Kalu mogago꞉ eyo꞉, asulo꞉ mogago꞉ e amilo꞉ dila꞉len a꞉no꞉ kalaba handalowakiyo꞉, man mogago꞉ a꞉no꞉ ko꞉lo꞉ dimida꞉mela꞉ib. Asulo꞉ usamilo꞉ da꞉lab a꞉no꞉, mego꞉f amio꞉ kalaba sahandaloma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Giyo꞉ nemo꞉wo꞉ ‘Ni Misa꞉ Alan’ a꞉la꞉sa꞉la꞉lab ko꞉sega, nilo꞉ to saefa꞉ a꞉no꞉ mo꞉kudu ha꞉nab a꞉no꞉, mo꞉wo꞉ ha꞉? ");
INSERT INTO bco_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kalu abeyo꞉ nelo꞉wa ya꞉ga꞉lo꞉, ni tolo꞉ sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉lo꞉ kudu ha꞉nab a꞉ma꞉ ene mano꞉, niyo꞉ gimo꞉wo꞉ walama꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kalu a꞉no꞉ alo꞉ dian kaluwo꞉ o꞉ngo꞉ dowo꞉. Eyo꞉ a diakiyo꞉, heno꞉ tambo dali alifela꞉sa꞉ga꞉, aiko꞉ halaido꞉wo꞉ a꞉na gego꞉ ko꞉lo꞉ fufa alano꞉ ya꞉sa꞉ga꞉, aya ba꞉labikiyo꞉ mo꞉ida꞉lo꞉. Mo꞉wo꞉ a a꞉no꞉ mada halaido꞉ di. ");
INSERT INTO bco_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ko꞉sega kalu abeyo꞉ ni towo꞉ da꞉da꞉sa꞉ga꞉lo꞉ mo꞉kudu ha꞉nab a꞉no꞉, kaluwa꞉ a diakilo꞉, heno꞉ abol daida꞉sa꞉ga꞉, aiko꞉wo꞉ taiyo꞉ gego꞉wo꞉ o꞉ngo꞉ dowo꞉. A a꞉namio꞉ ho꞉n o꞉lia꞉ fufa o꞉lia꞉yo꞉ ya꞉ga꞉ ba꞉labikiyo꞉, a a꞉no꞉ dugu alilaki, tambo bidi ane.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ya꞉su eyo꞉ kaluka꞉isalemo꞉wo꞉ to a꞉no꞉ wida꞉la꞉ga꞉ eletakiyo꞉, e Kabaniom amisa꞉n a꞉na a꞉ma꞉la꞉ ane. ");
INSERT INTO bco_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Loma꞉ ame kalu nowo꞉, da꞉la꞉di kalu modo꞉lo꞉ bo꞉fo꞉lowa꞉sen a꞉no꞉ a꞉na sen. Enen nanogdo꞉ dian kalu nowo꞉ e mada mo꞉ta꞉fa꞉no꞉ asula꞉sen ko꞉sega, nanogdo꞉ dian kalu a꞉no꞉ walaf dowaki soma꞉no꞉wo꞉ ko꞉na꞉ma dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ame kalu eyo꞉ Ya꞉suwa꞉lo꞉ dimida꞉labo꞉ da꞉da꞉ga꞉yo꞉, eyo꞉ Yu misa꞉ kalu nolo꞉ Ya꞉sulo꞉wa iliga꞉fo꞉. Ya꞉su e elo꞉wa ya꞉sa꞉ga꞉ ene nanogdo꞉ dian kalu a꞉no꞉ falele alifoma꞉ki, kalu i a꞉no꞉ sa꞉ma꞉ni hamana꞉ki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","I a꞉no꞉ Ya꞉sulo꞉wa fa꞉la꞉dowakiyo꞉, Ya꞉suwo꞉ mena꞉ki susiakiyo꞉, towo꞉ a꞉la꞉sio꞉, “Ame kalu we mada nafa ko꞉lo꞉, giyo꞉ e ko꞉lo꞉ asuwa꞉fa꞉no꞉wo꞉ mada o꞉li. Eyo꞉ Yu kaluka꞉isale nio꞉ mada alan asulakiyo꞉, nili tolo꞉ wida꞉sen ayo꞉ e di alifa꞉. E kalu nafa ko꞉lo꞉, giyo꞉ e asuwa꞉fa꞉ mena꞉ki asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","A꞉la꞉dabu ba꞉dabiki, Ya꞉su e i o꞉lia꞉ ane. Ya꞉suwo꞉ ayamio꞉ ko꞉na꞉ma fa꞉la꞉doma꞉ni ha꞉nab amio꞉, amelo꞉ bo꞉fo꞉lowan kalu a꞉ma꞉yo꞉ ene mili kalu nolo꞉ Ya꞉sumo꞉wo꞉ towo꞉ sama꞉ki iliga꞉fo꞉. Iliyo꞉ Ya꞉suwo꞉ galiliakiyo꞉, ame kaluwa꞉ to saga꞉fo꞉wo꞉ we, “Alan, ne wilo꞉ma kalu ko꞉lo꞉, ge ni a usa mia꞉no꞉wo꞉ mo꞉ililo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","A꞉la꞉ta꞉ga꞉, neko꞉ gelo꞉wa mia꞉no꞉wo꞉lo꞉ mo꞉lilo꞉. Ko꞉sega ge konaka iliki, giyo꞉ to ko꞉ sa꞉lalega, ni nanogdo꞉ dian kalu a꞉no꞉ o꞉li falele alifa꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ne a꞉la꞉asulo꞉ mo꞉wo꞉ no꞉no꞉n ne, misa꞉ kalu noma꞉ bo꞉fo꞉labikiyo꞉, niyo꞉lo꞉ ame kalu nolo꞉ bo꞉fo꞉lo꞉l. Niyo꞉ ‘Hamana’ a꞉lab amio꞉, iyo꞉ ha꞉na꞉sen, a꞉la꞉ta꞉ga꞉ ‘Mena’ a꞉lab amio꞉, iyo꞉ ya꞉sen. Ni nanogdo꞉ dian kalumo꞉wo꞉ ‘Dimidama’ a꞉la꞉sa꞉lab amio꞉, iliyo꞉ dimida꞉sen.” ");
INSERT INTO bco_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ya꞉su eyo꞉ to a꞉no꞉ da꞉da꞉sa꞉ga꞉ modakiyo꞉, e nodola꞉sa꞉ga꞉, kaluka꞉isale modo꞉ elo꞉ kudu ya꞉len imo꞉wo꞉ towo꞉ a꞉la꞉sio꞉, “Kalu wema꞉ tilidabuwo꞉ hendele alan dowo꞉ ko꞉lo꞉, Isolael hen tambo us wenamio꞉ ne kaluka꞉isaleya꞉ tilidabu we o꞉ngo꞉wo꞉ mo꞉ba꞉ba꞉” Ya꞉suwa꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ya꞉sulo꞉ amilo꞉ iliga꞉fo꞉ kalu i a꞉no꞉ a꞉ma꞉la꞉ aya ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowaki ba꞉ba꞉ amio꞉, nanogdo꞉ dian kalu a꞉no꞉ falelo꞉wa ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","A꞉ma꞉ fa꞉s amio꞉, Ya꞉suwo꞉ Nain amisa꞉n a꞉na ha꞉nabiki, enedo꞉ tili wida꞉sen kalu o꞉lia꞉, kaluka꞉isale modo꞉ nolo꞉ e o꞉lia꞉ ane. ");
INSERT INTO bco_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Iyo꞉ ha꞉na꞉sa꞉ga꞉, amisa꞉n toga꞉meya ko꞉na꞉ma fa꞉la꞉dowakiyo꞉, iyo꞉ ba꞉ba꞉ amio꞉ amisa꞉n kaluwo꞉ kalu sowo꞉ nowo꞉ i kalulia꞉ga꞉ handalowabi ba꞉ba꞉. Kalu sowo꞉ a꞉ma꞉ anowo꞉ sa꞉ba꞉lo꞉ ko꞉lo꞉, eyo꞉ kalu so꞉wa nowo꞉ mada aundo꞉ma. A꞉la꞉go꞉ko꞉lo꞉ amisa꞉n kaluka꞉isale modo꞉wo꞉ e o꞉lia꞉ ha꞉na꞉len. ");
INSERT INTO bco_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Kalu Alan eyo꞉ ga a꞉no꞉ ba꞉da꞉sa꞉ga꞉, alan nofolakiyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge ya꞉la꞉so꞉bo!” ");
INSERT INTO bco_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E ha꞉na꞉sa꞉ga꞉ dagiyo꞉ i kolo꞉wa golabikiyo꞉, iyo꞉ a꞉naka kagayabiki, eyo꞉ a꞉la꞉sio꞉, “So꞉wa, ge dasima!” ");
INSERT INTO bco_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","A꞉la꞉sa꞉labiki kalu sowo꞉ a꞉no꞉ a꞉ma꞉la꞉ dasi asita꞉ga꞉ mo꞉mo꞉da tolabikiyo꞉, Ya꞉su eyo꞉ anomo꞉wo꞉ a꞉la꞉sio꞉, “Gi so꞉wayo꞉ we.” ");
INSERT INTO bco_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kaluka꞉isale iyo꞉ iligaki tagio꞉ alan dowo꞉ ko꞉lo꞉, Godeyo꞉ wabudaki a꞉la꞉sio꞉, “Dinali sa꞉lan kalu halaido꞉ nowo꞉ nilo꞉ wenamio꞉ fa꞉la꞉dowab. Godeyo꞉ kaluka꞉isale enedo꞉wo꞉ asuwa꞉fa꞉ni mio꞉.” ");
INSERT INTO bco_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ sa꞉la꞉i aneyo꞉, Yudia hen a꞉na a꞉la꞉ta꞉ga꞉ amisa꞉n ko꞉na꞉lo꞉ kandayo꞉ a꞉no꞉ tambo da꞉da꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Yo꞉n elo꞉ tili wida꞉sen kalu iliyo꞉, Ya꞉suwa꞉lo꞉ dimido꞉ a꞉no꞉ tambo emo꞉ malolo꞉ meabiki, Yo꞉n eyo꞉ kalu a꞉la꞉ nowo꞉ da꞉fea꞉sa꞉ga꞉, Ya꞉sumo꞉wo꞉ dabu bo꞉ba꞉ki iliga꞉takiyo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ da꞉feyo꞉ kalu nimo꞉lo꞉ iliga꞉fa꞉no꞉ sio꞉wo꞉ geya꞉le? Mo꞉ niliyo꞉ kalu nowo꞉ o꞉yasilima꞉no꞉wa꞉le?” a꞉la꞉sama꞉ki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","A꞉la꞉yo꞉ Ya꞉sulo꞉wa fa꞉la꞉dowakiyo꞉ a꞉la꞉sio꞉, “Yo꞉n ho꞉n amilo꞉ to꞉lolan a꞉ma꞉yo꞉ na꞉no꞉ gelo꞉wa iliga꞉takiyo꞉, gemo꞉wo꞉ a꞉la꞉dabu ba꞉da꞉bika꞉ a꞉la꞉sio꞉, ‘Godeya꞉lo꞉ da꞉feyo꞉ kalu nimo꞉lo꞉ iliga꞉fa꞉no꞉ sio꞉wo꞉ geya꞉le? Mo꞉ niliyo꞉ kalu nowo꞉ o꞉yasilima꞉no꞉wa꞉le?’ ” a꞉la꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ho꞉len a꞉namio꞉ Ya꞉suwa꞉yo꞉ walaf ko꞉li ko꞉lilo꞉lo꞉ dowo꞉ a꞉no꞉ falele alifelaki a꞉la꞉ta꞉ga꞉ mama mogago꞉lo꞉ dowo꞉ a꞉no꞉ o꞉luga꞉fela꞉b. A꞉la꞉ta꞉ga꞉ sio꞉ ko꞉n dowo꞉ a꞉no꞉lo꞉ fage alifela꞉b a꞉lo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ Yo꞉na꞉lo꞉ tolo꞉ saga꞉fo꞉ kalu o꞉mo꞉wo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ga꞉go꞉ a꞉ma꞉la꞉ ha꞉na꞉ga꞉yo꞉, gaindo꞉ ba꞉dab o꞉lia꞉ da꞉dab a꞉no꞉lia꞉yo꞉ Yo꞉nbo꞉wo꞉ a꞉la꞉malolo꞉ mea꞉bi. Siyo꞉ ko꞉n kalu iyo꞉ o꞉li a꞉ba꞉daki, gibo꞉ ko꞉go꞉neli iyo꞉ o꞉li ha꞉na꞉lab. Aintalo꞉ dowo꞉ i a꞉no꞉ imulu alitaki, ka꞉la꞉no꞉ ko꞉lo꞉ i a꞉no꞉ o꞉li da꞉da꞉lab. Sowo꞉ kaluka꞉isale nolo꞉lo꞉ a꞉ma꞉la꞉ dasi alifela꞉b. A꞉la꞉ta꞉ga꞉ wa꞉feyo꞉ kaluka꞉isaleyo꞉ Godeya꞉ to nafa wida꞉lab a꞉no꞉ da꞉da꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Kalu abeyo꞉ nilo꞉ dimidab we ba꞉da꞉ga꞉yo꞉, ene tilidabuwo꞉ mo꞉ta꞉fo꞉ ha꞉nalega, Gode eyo꞉ e sagale alifa꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yo꞉na꞉ tolo꞉ sa꞉ma꞉ mio꞉ kalu a꞉no꞉ ha꞉na꞉ga꞉ dowabiki, Ya꞉su eyo꞉ Yo꞉na꞉lo꞉ dimida꞉sen a꞉no꞉ ko꞉lo꞉ kaluka꞉isale kegeo꞉ o꞉mo꞉ widaki a꞉la꞉sio꞉, “Gio꞉ kalaleli hen a꞉namio꞉ o꞉b ba꞉ba꞉ni aneyo꞉? Gio꞉ fa꞉fa꞉sa꞉lo꞉ i ida꞉la꞉lab a꞉no꞉ ko꞉lo꞉ ba꞉ba꞉ni aneyo꞉? ");
INSERT INTO bco_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O꞉ngo꞉ma ko꞉lo꞉, gio꞉ a꞉namio꞉ o꞉b ba꞉ba꞉ni aneyo꞉? Kalu nowo꞉ so꞉g nafalelo꞉ kafo꞉labiki ba꞉ba꞉ni aneyo꞉? A! So꞉g nafalelo꞉ ko꞉lo꞉ o꞉lia꞉ kelego꞉ nafa modo꞉lo꞉ da꞉lab a꞉no꞉lo꞉ misa꞉ kaluwa꞉ aya sena ba꞉dan. ");
INSERT INTO bco_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","A꞉la꞉gan ko꞉lo꞉, gio꞉ kalaleli hen a꞉namio꞉ o꞉b ba꞉ba꞉ni aneyo꞉? Gio꞉ dinali sa꞉lan kalu a꞉no꞉ ba꞉ba꞉ni ane. A꞉no꞉ hendele, a꞉la꞉ta꞉ga꞉ dinali sa꞉lan kalu gilo꞉ ba꞉ba꞉ a꞉ma꞉yo꞉, dinali sa꞉lan kalu nolo꞉ e tininila꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Godeya꞉lo꞉ to sa꞉sa꞉lo꞉ a꞉namio꞉, kalu we ko꞉lo꞉ da꞉feakiyo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Ge semo꞉fa꞉la꞉dowo꞉ amio꞉, tolo꞉ sa꞉ma꞉no꞉ kalu nowo꞉ tamina iliga꞉takiyo꞉, gelo꞉ mia꞉no꞉ tog a꞉no꞉ e fadama꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne hendele so꞉lo꞉l. Henfelo꞉ kaluka꞉isaleyo꞉ tambo Yo꞉n e tinio꞉ ko꞉lo꞉lab. Ko꞉sega Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen us a꞉namio꞉, tilidabu kalu wilo꞉ma o꞉ngo꞉ a꞉lab a꞉ma꞉yo꞉ Yo꞉n e tininima꞉ib.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kaluka꞉isale modo꞉ nolo꞉ a꞉la꞉ta꞉ga꞉, takis molelo꞉ dia꞉sen kalu iyo꞉ Yo꞉nbo꞉ ho꞉na to꞉loma꞉ki ane ko꞉lo꞉, Ya꞉suwa꞉lo꞉ to widab a꞉no꞉ da꞉da꞉likiyo꞉, iliyo꞉ Godeya꞉ man a꞉no꞉ hendele a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko꞉sega Fa꞉lisi kalu o꞉lia꞉ elelo꞉ asulo꞉ kalu o꞉lia꞉yo꞉ ho꞉na to꞉loma꞉kiyo꞉, Yo꞉ndo꞉ amio꞉ mo꞉ane ko꞉lo꞉, iyo꞉ Godeya꞉lo꞉ i asulakilo꞉ dimadali a꞉no꞉ gola ba꞉daki, mo꞉kudu ane. ");
INSERT INTO bco_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ya꞉su eyo꞉ a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale o꞉gdo꞉ sab wema꞉ man a꞉no꞉ fanda widakiyo꞉, niyo꞉ waga bale sa꞉ma꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","So꞉wagalin iyo꞉ amisa꞉n baya siliki, egelebo꞉ a꞉la꞉nenelo꞉. “ ‘Niliyo꞉ ga tililiakiyo꞉ ulunayo꞉ folo꞉, ko꞉sega gio꞉ sagalakiyo꞉ mo꞉ya꞉bale. Niliyo꞉ nofolo꞉ gisalo꞉wo꞉ mo꞉lo꞉, ko꞉sega gio꞉ mo꞉ya꞉lale.’ Kaluka꞉isale henfelo꞉ wilo꞉ o꞉gdo꞉ sab we so꞉wagalin ililo꞉ a꞉la꞉do꞉ nenelo꞉ o꞉leo꞉ngo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Mo꞉wo꞉ Yo꞉n ho꞉n amilo꞉ to꞉lolan e ya꞉ga꞉yo꞉, wain ho꞉n o꞉lia꞉ ma꞉n ma꞉no꞉ o꞉lia꞉yo꞉ ka꞉laki mo꞉na꞉sen. Man a꞉no꞉ e kudu ha꞉nabikiyo꞉, giliyo꞉ e gola ba꞉da sa꞉laki, ‘E mama mogago꞉ dowab’ a꞉la꞉sa꞉la꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","A꞉la꞉ta꞉ga꞉ Kalule Dowo꞉ ne gilo꞉wa ya꞉ga꞉yo꞉, ma꞉n o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ no꞉likiyo꞉, giliyo꞉ ne gola ba꞉da sa꞉lakiyo꞉, ‘Kalu we ma꞉no꞉ besagali naki a꞉la꞉ta꞉ga꞉, aluna꞉ ho꞉no꞉ na꞉sa꞉ga꞉ no꞉nolab. E takis molelo꞉ dia꞉sen kalu o꞉lia꞉ mogago꞉lo꞉ dimida꞉sen kalu o꞉lia꞉yo꞉ mili dowab’ a꞉la꞉sa꞉la꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ko꞉sega kaluka꞉isale Godeya꞉lo꞉ asulab aundo꞉ kudu ha꞉na꞉lab i a꞉ma꞉yo꞉ Godeya꞉ mano꞉ hendele digalo꞉, a꞉la꞉widakigab.” Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ho꞉len no amio꞉, Fa꞉lisi kalu noma꞉yo꞉ Ya꞉suwo꞉ ene aya ma꞉no꞉ ma꞉niki mena a꞉la꞉sa꞉labiki, Ya꞉suwo꞉ a usa tina꞉sa꞉ga꞉ hena sen. ");
INSERT INTO bco_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Amisa꞉n a꞉namio꞉, ga nowo꞉ mogago꞉lo꞉ dimida꞉lowano꞉ elen ko꞉lo꞉, Ya꞉suwo꞉ Fa꞉lisi kaluwa꞉ aya sab a꞉la꞉da꞉da꞉ga꞉yo꞉, e wa ho꞉n mundo꞉ nafayo꞉, u ho꞉lo꞉ go꞉fo꞉ amilo꞉ wasu a꞉no꞉ dia꞉sa꞉ga꞉, Ya꞉sulo꞉wa ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ga a꞉no꞉ Ya꞉suwa꞉ fa꞉sa kagafo꞉liki ya꞉la꞉likiyo꞉, Ya꞉suwa꞉ gib a꞉no꞉ si ho꞉na꞉ badala꞉labiki, ene misa꞉ fo꞉n a꞉ma꞉ Ya꞉suwa꞉ gibo꞉ a꞉na hala꞉len. Eyo꞉ gib a꞉no꞉ mimila꞉liki, wa ho꞉n a꞉no꞉ a꞉na tula꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Fa꞉lisi kalu Ya꞉sulo꞉ tililia꞉mio꞉ a꞉ma꞉yo꞉ enena꞉ma꞉la꞉yo꞉ a꞉la꞉asulo꞉. “Kalu we dinali sa꞉lan kalu hendele kibo꞉bowo꞉, eyo꞉ ga we o꞉ngo꞉ma꞉ golabo꞉lo꞉b a꞉la꞉bo꞉ o꞉li fanda asulumabe. Eyo꞉ aloba꞉dakiyo꞉, ga we mogago꞉lo꞉ dimida꞉sen a꞉la꞉bo꞉ o꞉li asulumabe.” ");
INSERT INTO bco_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Fa꞉lisi kalu eyo꞉ a꞉la꞉asulabiki, Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Saimon, niyo꞉ gemo꞉wo꞉ to sa꞉ma꞉no꞉ nowo꞉ da꞉lab.” A꞉la꞉sa꞉labiki, “Widan kalu, nemo꞉wo꞉ sama.” ");
INSERT INTO bco_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Kalu a꞉la꞉ma꞉yo꞉ kalu no amio꞉ moleyo꞉ di ko꞉lo꞉ mewa꞉lo꞉ da꞉lab. Noma꞉yo꞉ mewa꞉lo꞉ silba moleyo꞉ fudo꞉ bila꞉fo꞉ di, a꞉la꞉ta꞉ga꞉ noma꞉yo꞉ silba moleyo꞉ do꞉la꞉fo꞉ bila꞉fo꞉ di. ");
INSERT INTO bco_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kalu a꞉la꞉ma꞉yo꞉ mole wa꞉l a꞉ma꞉la꞉ dimia꞉no꞉wo꞉ aundo꞉ma dowabiki, molelo꞉ biso꞉ a꞉ma꞉ sa꞉laki, ‘Ga꞉go꞉ molelo꞉malo꞉biki, niyo꞉ ga꞉lilo꞉l ko꞉lo꞉ ga꞉go꞉ sagala꞉li ha꞉na꞉bi.’ A꞉la꞉sa꞉lab ko꞉lo꞉ kalu o꞉mo꞉wo꞉ abe mada alan asulaba?” ");
INSERT INTO bco_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉dabiki, Saimon eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kalu moleyo꞉ alando꞉ di ko꞉lo꞉ ta꞉tab e mada alan asuluma꞉ib, niyo꞉ a꞉la꞉asulo꞉l.” A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Ge hendele sa꞉lab.” ");
INSERT INTO bco_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","A꞉la꞉sa꞉laki, Ya꞉su e galo꞉ doba꞉da꞉ nodolakiyo꞉, Saimonbo꞉wo꞉ a꞉la꞉sio꞉, “Ga we ba꞉daya? Ne gi aya mio꞉ amio꞉, giyo꞉ ho꞉no꞉ ni gib to꞉go꞉dema꞉kiyo꞉ mo꞉wasumeale. Ko꞉sega ga wema꞉yo꞉ si ho꞉n enedo꞉ma꞉ ni gibo꞉ to꞉go꞉daki, misa꞉ fo꞉n enedo꞉ma꞉ halifa꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ne gi aya fa꞉la꞉dowab amio꞉, giyo꞉ ne mo꞉mimilale ko꞉sega, ne ho꞉gi fa꞉la꞉dowab amio꞉ ga wema꞉yo꞉ gib nilo꞉ we mimila꞉fo꞉ ko꞉ a꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Giyo꞉ o꞉lif wel ho꞉n a꞉no꞉ ni misa꞉ amio꞉ mo꞉tulu alitale. Ko꞉sega ga wema꞉yo꞉ wa ho꞉n mundo꞉ nafa a꞉no꞉ ni giba tulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ gemo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Ga wema꞉lo꞉ mogago꞉ modo꞉ dimida꞉len a꞉no꞉ niyo꞉ halaki ga꞉lila꞉ ko꞉lo꞉, eyo꞉ ne mada alan asulakigab. Ko꞉sega kalu abeyo꞉ mogago꞉ ha꞉lulo꞉ dimido꞉ a꞉no꞉ halaki ga꞉lilalikiyo꞉, eyo꞉ ne ba ha꞉lu asuluma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","A꞉la꞉sa꞉la꞉sa꞉ga꞉, Ya꞉su eyo꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “Mogago꞉ gilo꞉ dimido꞉wo꞉ tambo halaki ga꞉lilo꞉l ko꞉m.” ");
INSERT INTO bco_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","A꞉la꞉sa꞉labiki, kaluka꞉isale nol ma꞉ndo꞉ na꞉likilo꞉ sen a꞉ma꞉yo꞉ egele nenelaki a꞉la꞉sio꞉, “Mogago꞉ dimido꞉ a꞉no꞉ halaki ga꞉lilo꞉ka꞉, a꞉la꞉do꞉ sa꞉lab a꞉no꞉, kalu we o꞉ba꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ gamo꞉wo꞉ a꞉la꞉sio꞉, “Go꞉no꞉n tilidabu koma꞉ ge a꞉ma꞉la꞉ gasiliab ko꞉lo꞉ ge ha꞉sa dowa꞉i ha꞉na꞉bi.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Tif amio꞉ Ya꞉su e amisa꞉n nowa nowa a꞉la꞉sia꞉likiyo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉nigab to nafa a꞉no꞉ ko꞉lo꞉ wida꞉li sia꞉len. Enedo꞉ tili wida꞉sen kalu kugula꞉fo꞉ a꞉no꞉ e o꞉lia꞉ sia꞉len. ");
INSERT INTO bco_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","A꞉la꞉ta꞉ga꞉ ga nolo꞉lo꞉, nolo꞉ mama mogago꞉lo꞉ dowo꞉ o꞉luso꞉no꞉ a꞉no꞉lo꞉, nolo꞉ walafdo꞉ delen falelo꞉ a꞉no꞉lo꞉ iyo꞉ tambo egele sia꞉len. Ga nowo꞉ wiyo꞉ Malia, e Magdala amisa꞉n ga ko꞉lo꞉, mama mogago꞉ dom a꞉la꞉fo꞉lo꞉ o꞉luso꞉no꞉wo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ga nowo꞉ Yoana. Ene ino꞉ Kusa, Ha꞉loda꞉ ene alo꞉ bo꞉fo꞉lowan kaluwo꞉ e. Ga nowo꞉, Susana, a꞉la꞉ta꞉ga꞉ ka꞉isale nolo꞉lo꞉ egele sia꞉len. Ka꞉isale i a꞉ma꞉yo꞉ mole o꞉lia꞉ kelego꞉ inido꞉ delen a꞉no꞉lia꞉yo꞉ kegea꞉sa꞉ga꞉, egeledo꞉ sia꞉len a꞉no꞉ ko꞉lo꞉ asuwa꞉ta꞉len. ");
INSERT INTO bco_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kaluka꞉isale amisa꞉n ko꞉li ko꞉lilo꞉ amilo꞉ ya꞉sio꞉ a꞉no꞉ modo꞉ kegea꞉sa꞉ga꞉ dowabiki, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉na bale sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Elo꞉ gelan kalu nowo꞉ ha꞉nakiyo꞉, fowo꞉ egelo꞉wa fifa꞉li ane. Eyo꞉ fowo꞉ egelo꞉wa fifa꞉li ha꞉nab amio꞉, fo nolo꞉ tog wa꞉la꞉la꞉sena ti ali. Fo a꞉no꞉ kaluwa꞉ wa꞉la꞉ basiab amio꞉, o꞉ba꞉yo꞉ ya꞉sia꞉sa꞉ga꞉, fo a꞉no꞉ mo꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Fo nolo꞉ ulo꞉ elena ti ali ko꞉lo꞉, musug a꞉no꞉ fa꞉la꞉dowab amio꞉, ho꞉no꞉ aundo꞉ma dowabiki, onaliaki sowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Fo nolo꞉ kisdo꞉ a꞉lab a꞉na ti alilab amio꞉ kis o꞉lia꞉ fa꞉la꞉ne ko꞉lo꞉, e fa꞉la꞉ne a꞉no꞉ ha꞉gulu dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Fo nolo꞉ hen nafa solo꞉wa ti ali ko꞉lo꞉, musugo꞉ nafa fa꞉la꞉nda꞉sa꞉ga꞉, fowo꞉ nafale mada hedakiyo꞉, fudo꞉ otalen o꞉leo꞉ngo꞉ hedo꞉.” Ya꞉su eyo꞉ to a꞉no꞉ sa꞉la꞉sa꞉ga꞉ eletakiyo꞉, eyo꞉ towo꞉ halale sa꞉laki, “Kaluka꞉isale ka꞉la꞉ndo꞉ a꞉lab gio꞉, to we dinafa da꞉da꞉sa꞉ga꞉, fanda asula꞉bi.” ");
INSERT INTO bco_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ya꞉su eyo꞉ to a꞉no꞉ a꞉la꞉sio꞉ ko꞉lo꞉ enedo꞉ tili wida꞉sen kalu iliyo꞉ bale sio꞉ a꞉ma꞉ ha꞉go꞉ fanda sama꞉ki, emo꞉wo꞉ dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Dabu ba꞉dabiki Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ to wo꞉no꞉le delen a꞉no꞉ o꞉go꞉ gio꞉ o꞉li asuluma꞉ki fogo꞉ dimi ko꞉lo꞉lab. Ko꞉sega Godeya꞉lo꞉ dinali sio꞉ to sa꞉sa꞉lo꞉ a꞉no꞉ ililima꞉kiyo꞉, niyo꞉ kalu nolbo꞉wo꞉ mobale sio꞉. Godeya꞉ ene bugo꞉ amio꞉ towo꞉ a꞉la꞉sa꞉sa꞉lo꞉, “ ‘Iliyo꞉ ba꞉ba꞉ib ko꞉sega, hendeyo꞉ mo꞉ba꞉ba꞉ib. Iliyo꞉ to sio꞉wo꞉ da꞉ba꞉ib ko꞉sega, ha꞉go꞉ mo꞉fanda asuluma꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Bale sio꞉ a꞉ma꞉ ha꞉go꞉ we. Fo fifo꞉ a꞉no꞉, Godeya꞉ towo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Kaluka꞉isale nolo꞉, fo ko꞉lo꞉ tog wa꞉la꞉la꞉sen amilo꞉ ti ali o꞉ngo꞉ dowab. Kaluka꞉isale i a꞉no꞉ Godeya꞉ towo꞉ da꞉da꞉labiki, Sa꞉da꞉na꞉ e ya꞉sa꞉ga꞉, ili asulo꞉ amilo꞉ to dabu a꞉no꞉ e dila꞉lab. A꞉la꞉gab amio꞉, iyo꞉ mo꞉tilida꞉daliki, a꞉ma꞉la꞉yo꞉ mo꞉gasilia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Kaluka꞉isale nolo꞉ fo ko꞉lo꞉ ulo꞉ elen wa꞉l amilo꞉ ti ali o꞉ngo꞉ dowab. Kaluka꞉isale a꞉no꞉ Godeya꞉ to nafa a꞉no꞉ iligi da꞉da꞉sa꞉ga꞉, sagala꞉li di. Ko꞉sega ili asulo꞉ us amio꞉ towo꞉ mo꞉tefele ane ko꞉lo꞉, ili tilidabuwo꞉ ho꞉len abolda꞉su dowo꞉. Da꞉fe ba꞉ba꞉yo꞉ fa꞉la꞉dowalikiyo꞉, iyo꞉ bo꞉e sulufo꞉ tina꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Kaluka꞉isale nolo꞉ fo kisdo꞉ a꞉lab a꞉na ti ali o꞉ngo꞉ dowo꞉. Kaluka꞉isale a꞉no꞉ Godeya꞉ towo꞉ dabu ko꞉sega, henfelo꞉ wilo꞉ dimidama꞉no꞉ kele asulo꞉ o꞉lia꞉, mole alan dia꞉no꞉ asulo꞉ o꞉lia꞉, sagalema꞉no꞉ man o꞉lia꞉ma꞉yo꞉ ili tilidabuwo꞉ go꞉lulaki, iyo꞉ mo꞉halale anama꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko꞉sega kaluka꞉isale nolo꞉ fo hen nafa solo꞉wa ti ali o꞉ngo꞉ dowo꞉. Kaluka꞉isale ili mano꞉ nafale dowaki, Godeya꞉ towo꞉ da꞉da꞉sa꞉ga꞉yo꞉, dinafa tilidabu ko꞉lo꞉, iyo꞉ halale kagayaki, fowo꞉ nafale hedo꞉.” Ya꞉suwa꞉yo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ya꞉su eyo꞉ towo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kalu noma꞉yo꞉ nafayo꞉ do꞉lia꞉ga꞉yo꞉, fafowo꞉ wa꞉l amio꞉ mo꞉go꞉lu alitan. A꞉la꞉ta꞉ga꞉ wo꞉no꞉lebo꞉ mo꞉dia꞉tan. A꞉la꞉bo꞉ mo꞉gan ko꞉lo꞉ kalu eyo꞉ nafayo꞉ do꞉lia꞉sa꞉ga꞉yo꞉, kalu a usamilo꞉ yab i a꞉no꞉ ho꞉leno꞉ bo꞉ba꞉ki, kalaba iwalu dia꞉ta꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","A꞉la꞉gab amio꞉, kelego꞉ wo꞉no꞉lelo꞉ delen a꞉no꞉, tif amio꞉ tambo kalaba fa꞉la꞉doma꞉ib. A꞉la꞉ta꞉ga꞉ kelego꞉ wo꞉no꞉lelo꞉ difa꞉ a꞉no꞉ tambo kalaba fa꞉la꞉dowalikiyo꞉, kaluka꞉isaleyo꞉ tambo fanda asuluma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ ni towo꞉ da꞉da꞉likiyo꞉, dinafa dabuma. Kalu abeyo꞉ asulo꞉wo꞉ heb dowalega, Gode eyo꞉ emo꞉wo꞉ asulo꞉ nolo꞉ a꞉dimia꞉ib. Ko꞉sega kalu abeyo꞉ asulo꞉wo꞉ aundo꞉ma da꞉lab a꞉no꞉, asulo꞉ ha꞉lu e amilo꞉ delen a꞉no꞉, tambo a꞉ma꞉la꞉ dila꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","O꞉g a꞉namio꞉ Ya꞉suwa꞉ ano o꞉lia꞉ ao i o꞉lia꞉yo꞉ e ba꞉ba꞉ni mio꞉ ko꞉sega, kaluka꞉isaleyo꞉ modo꞉ Ya꞉sulo꞉wa banagalifa꞉ ko꞉lo꞉, iyo꞉ ma꞉uwa꞉ amio꞉ mo꞉tiane. ");
INSERT INTO bco_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","A꞉la꞉go꞉ko꞉lo꞉ kalu noma꞉yo꞉ Ya꞉sumo꞉ sa꞉laki, “Go꞉ o꞉lia꞉ gao nol o꞉lia꞉yo꞉ ge ba꞉ba꞉no꞉ asulaki, iyo꞉ ha꞉la꞉ya yasisab.” ");
INSERT INTO bco_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale abeyo꞉ Godeya꞉ towo꞉ da꞉da꞉sa꞉ga꞉lo꞉ kudu ha꞉na꞉lab i a꞉no꞉, ni no꞉leyo꞉, ni naoleyo꞉ o꞉m.” ");
INSERT INTO bco_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ho꞉len no amio꞉ Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Nio꞉ ho꞉n golo꞉ we nodo honona ha꞉na꞉n.” A꞉la꞉sa꞉labiki iyo꞉ ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉ a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Iyo꞉ ho꞉n golo꞉ usa ha꞉na꞉labikiyo꞉, Ya꞉su e alifo꞉len. Wigibo a꞉naka fufa alano꞉ ya꞉sa꞉ga꞉, ho꞉n ko꞉su a꞉na ba꞉labikiyo꞉, ho꞉no꞉ do꞉lilia꞉ga꞉ tinaki, ho꞉n ko꞉suwo꞉ ko꞉na꞉ma kandama꞉no꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","A꞉la꞉gabiki tili wida꞉sen kalu iyo꞉ Ya꞉sulo꞉wa ha꞉na꞉sa꞉ga꞉, e digida꞉yakiyo꞉ a꞉la꞉sio꞉, “Kalu Alan, Kalu Alan, nio꞉ mada kanda soma꞉nigab.” A꞉la꞉sa꞉labiki Ya꞉su e dasilia꞉ga꞉, fufa o꞉lia꞉ ho꞉n ma꞉feya꞉len o꞉lia꞉mo꞉wo꞉ bulufoma꞉ki, towo꞉ halaido꞉ sio꞉. A꞉la꞉sa꞉labikiyo꞉ fufa ya꞉len o꞉lia꞉ ho꞉n gon halaido꞉ fa꞉la꞉da꞉len a꞉no꞉lo꞉ a꞉naka bulufo꞉ ");
INSERT INTO bco_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Tilidabu gililo꞉wo꞉ ha꞉?” Iyo꞉ tagilaki, molo asulo꞉ ko꞉lo꞉, egelebo꞉ a꞉la꞉nenelo꞉, “Kalu we o꞉bo꞉ngo꞉wa꞉le? Eyo꞉ halaido꞉ sa꞉labikiyo꞉, fufa o꞉lia꞉ ho꞉n o꞉lia꞉yo꞉ elo꞉ sa꞉lab ko꞉ da꞉da꞉sa꞉ga꞉ kudu ane.” ");
INSERT INTO bco_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iyo꞉ Ga꞉lili hen a꞉no꞉ ta꞉ta꞉ga꞉ ho꞉n ko꞉suwa ha꞉nakiyo꞉, Gelasa kalulo꞉ sa꞉sen hen a꞉namida꞉ ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","A꞉na fa꞉la꞉dota꞉ga꞉yo꞉, Ya꞉su e ho꞉n ko꞉suwa handalota꞉ga꞉ kagayabikiyo꞉, amisa꞉n kalu nowo꞉, mama mogago꞉lo꞉ dowo꞉ a꞉no꞉ Ya꞉sulo꞉wa mio꞉. Kalu a꞉no꞉ ayamio꞉ mo꞉silikiyo꞉, e helebeso꞉go꞉ mo꞉ka꞉laki, kalu daido꞉lo꞉ hen a꞉na dowa꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Ho꞉leno꞉ tambo mama mogago꞉ a꞉no꞉ kalu a꞉namio꞉ ililitab amio꞉, ili bo꞉fo꞉lowa꞉sen. Amisa꞉n kalu iliyo꞉ kalu we sa꞉niya꞉ melea꞉taki bo꞉fo꞉len ko꞉sega, eyo꞉ sa꞉ni a꞉no꞉ gegedela꞉sa꞉ga꞉, mama mogago꞉ a꞉ma꞉ tililia꞉ ha꞉nakiyo꞉, kalulo꞉ma hena ane. Kalu a꞉no꞉ Ya꞉sulo꞉wa ya꞉sa꞉ga꞉yo꞉, Ya꞉su eyo꞉ mama mogago꞉ o꞉mo꞉wo꞉ ha꞉la꞉ya handaloma a꞉la꞉liki sio꞉. A꞉la꞉sa꞉labiki, kalu a꞉no꞉ Ya꞉suwo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, e gib aniba gulalu misa꞉fu alilaki, halaido꞉ gana giliyo꞉, “Ya꞉su, Gode Iwalulo꞉ a꞉lab a꞉ma꞉ So꞉wa giyo꞉ nemo꞉wo꞉ waga dimidama꞉ni gaya? Ne hida꞉yo꞉wo꞉ dimiakiyo꞉ mogaila꞉so꞉bo.” ");
INSERT INTO bco_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","A꞉la꞉go꞉ko꞉lo꞉ Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge wiyo꞉ o꞉ba?” A꞉la꞉sa꞉labiki, “Ne wiyo꞉ Modo꞉” a꞉la꞉sio꞉. Mo꞉wo꞉ mama mogago꞉ modo꞉wo꞉ eya tiane. ");
INSERT INTO bco_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Iyo꞉ hen alu dondo꞉ma a꞉namio꞉ mo꞉iliga꞉foma꞉ki, Ya꞉sumo꞉ susio꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Misio꞉ anib a꞉namio꞉, kabo fofo꞉wo꞉ modo꞉ ko꞉lo꞉ ma꞉no꞉ na꞉li sen. A꞉la꞉ta꞉ga꞉ mama mogago꞉wa꞉yo꞉ Ya꞉sumo꞉wo꞉ ha꞉nolo sa꞉laki, “Nio꞉ kabowa doma꞉ ha꞉na꞉no꞉wo꞉ o꞉liyo꞉?” A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ “O꞉lika꞉” ");
INSERT INTO bco_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","A꞉la꞉gabiki mama mogago꞉ iliyo꞉ kalu a꞉no꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, kabowa tiane ko꞉lo꞉, kabo a꞉no꞉ tambo do꞉mo꞉ gede to꞉lolo꞉ a꞉na nai dalale ha꞉na꞉sa꞉ga꞉, ho꞉n go꞉lo꞉ a꞉na tinabiki kanda sowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kabolo꞉ bo꞉fo꞉len kalu iyo꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ nai ha꞉na꞉ga꞉, amisa꞉n kaluka꞉isale o꞉lia꞉ hena usamilo꞉ sen i o꞉mo꞉wo꞉lo꞉ dimido꞉ a꞉no꞉ malola꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","A꞉la꞉fo꞉ko꞉lo꞉ kaluka꞉isaleyo꞉ dimidab a꞉no꞉ iyo꞉lo꞉ ba꞉ba꞉no꞉ a꞉la꞉ta꞉ga꞉ ane. Iyo꞉ Ya꞉sulo꞉wa fa꞉la꞉dowakiyo꞉, kalu mama mogago꞉ modo꞉lo꞉ dowa꞉sen a꞉no꞉ o꞉li dowo꞉ ko꞉lo꞉, Ya꞉suwa꞉ gib aniba sena ba꞉ba꞉. Kalu a꞉no꞉ asulo꞉ elo꞉wo꞉ nafale dowakiyo꞉, e helebeso꞉g ka꞉la꞉liki elena ba꞉da꞉sa꞉ga꞉, i a꞉no꞉ tagio꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kaluka꞉isale dimido꞉ welo꞉ ba꞉ba꞉ iliyo꞉, kalu we waga falele alifa꞉ya꞉le a꞉la꞉liki kaluka꞉isale nolbo꞉wo꞉ malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gelasa kaluka꞉isale iyo꞉ tagi alan dowabiki, Ya꞉suwo꞉ ili heno꞉ ta꞉ta꞉sa꞉ga꞉ hamana꞉ki, towo꞉ halaido꞉ sio꞉. A꞉la꞉go꞉ko꞉lo꞉ Ya꞉su o꞉lia꞉ ene tiliwida꞉sen kalu o꞉lia꞉yo꞉ ho꞉n ko꞉suwa disa꞉la꞉sa꞉ga꞉, iyo꞉ ta꞉fo꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iyo꞉ semo꞉ ane amio꞉ kalu mama mogago꞉lo꞉ dowo꞉ ko꞉lo꞉ ga꞉li dowo꞉ a꞉no꞉, Ya꞉sulo꞉ ha꞉naba ha꞉na꞉no꞉ a꞉la꞉ta꞉ga꞉ susio꞉. Ko꞉sega Ya꞉su eyo꞉ e iliga꞉fa꞉nikiyo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ge a꞉ma꞉la꞉ go꞉no꞉n aya ha꞉na꞉ga꞉, Godeya꞉lo꞉ gemo꞉lo꞉ dimido꞉ a꞉no꞉ malolo꞉ mea꞉bi.” A꞉la꞉fo꞉ko꞉lo꞉ kalu e ha꞉na꞉sa꞉ga꞉yo꞉, Ya꞉suwa꞉lo꞉ e amilo꞉ dimido꞉ a꞉no꞉ amisa꞉n a꞉na malolo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Kaluka꞉isale modo꞉ a꞉no꞉ Ya꞉su e Ga꞉lili a꞉ma꞉la꞉lo꞉ mia꞉nigab a꞉no꞉ yasila꞉len ko꞉lo꞉, e fa꞉la꞉dowabikiyo꞉, iliyo꞉ e sagala꞉liki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tolo꞉ wida꞉sen alo꞉ bo꞉fo꞉lowan kalu nowo꞉, Yailes elo꞉ a꞉namio꞉ elen. E Ya꞉suwo꞉ galilia꞉sa꞉ga꞉, Ya꞉suwa꞉ gido꞉fo꞉lo꞉wa gumisi asifo꞉liki, Ya꞉suwo꞉ e aya mena꞉ki susio꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Mo꞉wo꞉ ida꞉ imilig a꞉no꞉ donayo꞉ kugula꞉fo꞉ ko꞉lo꞉, e soma꞉no꞉ ko꞉na꞉ma dowo꞉. Ya꞉su e Yailes o꞉lia꞉ ene aya ha꞉nabikiyo꞉, kaluka꞉isale modo꞉wo꞉ e o꞉lia꞉ ha꞉na꞉siakiyo꞉, Ya꞉su e anetandeyo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ga imili nowo꞉ tin hoda꞉likilo꞉ eleno꞉, dona kugula꞉fo꞉ ko꞉lo꞉ gulula꞉fo꞉len. Ga a꞉ma꞉yo꞉ ene moleyo꞉ tambo mulumulo꞉lo꞉ mean kalumo꞉ kililia꞉liki wala꞉ ko꞉sega, walaf elo꞉ a꞉no꞉ mo꞉falele alifa꞉no꞉ dowo꞉ ko꞉lo꞉ elen. ");
INSERT INTO bco_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ga a꞉no꞉ Ya꞉suwa꞉ fa꞉sa ya꞉ga꞉ yakiyo꞉, e so꞉g sa꞉ga꞉lo꞉ migif a꞉na golabikiyo꞉, tin hoda꞉len a꞉no꞉ a꞉na bulufo꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Wigibo a꞉naka Ya꞉su eyo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ne abe golaba?” Kaluka꞉isale iyo꞉ tambo sa꞉laki “Nilo꞉ mo꞉go꞉” a꞉la꞉sa꞉la꞉i ha꞉nabiki, Bida eyo꞉ a꞉la꞉sio꞉, “Kalu Alan, kaluka꞉isaleyo꞉ modo꞉ ya꞉siakiyo꞉, geya anitandeab.” ");
INSERT INTO bco_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ko꞉sega Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Noma꞉yo꞉ ne amio꞉ go꞉lo꞉ka꞉. Halaido꞉ ne amilo꞉ elen a꞉no꞉ ha꞉la꞉ya handalowo꞉ a꞉la꞉asulo꞉l.” ");
INSERT INTO bco_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ga wema꞉yo꞉ e wo꞉no꞉lebo꞉ mo꞉doma꞉nigabo꞉lo꞉b a꞉la꞉asulaki, e bibisoda꞉liki, Ya꞉suwa꞉ gibdo꞉ a꞉na gumisi ali. Kaluka꞉isale kegeo꞉ ili si wa꞉l amio꞉, elo꞉ Ya꞉su ko꞉lo꞉ golo꞉ mo꞉wo꞉ widakiyo꞉, “ne wigibole ka falele alitaka꞉” a꞉la꞉liki imo꞉ wido꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Na꞉la꞉, ge go꞉no꞉n tilidabu koma꞉yo꞉, ge falele alitab ko꞉lo꞉ ha꞉sa dowaki hamana.” ");
INSERT INTO bco_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ya꞉suwo꞉ towo꞉ ga o꞉mo꞉wo꞉ o꞉sa꞉la꞉labikiyo꞉, kalu nowo꞉, tolo꞉ wida꞉sen alo꞉ bo꞉fo꞉lowan kalu Yailesa꞉ aya a꞉la꞉ta꞉ga꞉ sa꞉ma꞉ni yakiyo꞉, Yailes emo꞉wo꞉ a꞉la꞉sio꞉, “Ga꞉la꞉yo꞉ sowo꞉ ko꞉m. Gilo꞉ widan kalu we tililia꞉ ha꞉na꞉no꞉wo꞉, mo꞉wo꞉ aundo꞉malo꞉ka꞉.” ");
INSERT INTO bco_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ya꞉su eyo꞉ to a꞉no꞉ da꞉dakiyo꞉, Yailesbo꞉wo꞉ a꞉la꞉sio꞉, “Ge tagila꞉so꞉bo! Ge neko꞉ tilida꞉da꞉bi. A꞉la꞉galega, ga꞉la꞉ a꞉no꞉ falele alifa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ iyo꞉ ha꞉na꞉ga꞉, Yailesa꞉ aya fa꞉la꞉dowakiyo꞉, kaluka꞉isale kegeo꞉ a꞉no꞉ ya꞉foda꞉li a꞉labiki, Ya꞉suwa꞉yo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Gio꞉ ya꞉la꞉so꞉bo! E sowo꞉lema. E ba mida꞉iyo꞉ alifo꞉lab” Kaluka꞉isale ili asulakiyo꞉ so꞉wa a꞉no꞉ hendele sowo꞉ ko꞉m a꞉laki, Ya꞉suwa꞉lo꞉ to sa꞉lab a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iliyo꞉ e o꞉go꞉. Ya꞉su eyo꞉ kaluka꞉isale nolo꞉ a usamio꞉ mo꞉timena꞉ki ka꞉la꞉sa꞉ga꞉, eyo꞉, Bidayo꞉, Yo꞉no꞉, Ya꞉ma꞉so꞉, a꞉la꞉ta꞉ga꞉ iyalia꞉ anolia꞉ i a꞉no꞉ko꞉ a usa tiane. ");
INSERT INTO bco_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ko꞉sega Ya꞉suwa꞉yo꞉ so꞉wa a꞉ma꞉ dagiya ta꞉li dota꞉ga꞉ sa꞉laki, “Ni so꞉wa, ge dasima.” ");
INSERT INTO bco_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","A꞉la꞉sa꞉labiki so꞉wa a꞉ma꞉ mamayo꞉ a꞉ma꞉la꞉ ya꞉ga꞉ dowabikiyo꞉, wigibole a꞉naka e dasili. A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ so꞉wa o꞉mo꞉wo꞉ ma꞉n ma꞉no꞉wo꞉ dimina꞉ki sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iya o꞉lia꞉ anolia꞉ma꞉yo꞉ mada molo asulo꞉ ko꞉sega, Ya꞉su eyo꞉ a꞉la꞉mo꞉wo꞉ fa꞉la꞉dowab we nolbo꞉wo꞉ sa꞉la꞉so꞉boka꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ho꞉len no amio꞉, Ya꞉su eyo꞉ enedo꞉ tili wida꞉sen kalu kugula꞉fo꞉wo꞉ kegenelia꞉sa꞉ga꞉, iliyo꞉ mama mogago꞉wo꞉ tambo o꞉lusanaga꞉felema꞉ki, a꞉la꞉ta꞉ga꞉ walaf ko꞉li ko꞉lilo꞉lo꞉ a꞉lab a꞉no꞉lo꞉ falele alifelema꞉ki, halaido꞉wo꞉ imo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Iliyo꞉ kaluka꞉isalemo꞉wo꞉ Godeya꞉lo꞉ bo꞉fo꞉mela꞉nigab a꞉no꞉ widaki, a꞉la꞉ta꞉ga꞉ walaf ko꞉li ko꞉lilo꞉ a꞉lab a꞉no꞉ falele alifelema꞉ki iliga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ya꞉su eyo꞉ iyo꞉ iliga꞉takiyo꞉ a꞉la꞉sio꞉, “Gio꞉ ha꞉nakiyo꞉, kelego꞉ nolo꞉ dia꞉ha꞉na꞉so꞉bo. Ido꞉mo꞉, aso꞉, ma꞉no꞉wo꞉, moleyo꞉, a꞉la꞉ta꞉ga꞉ helebeso꞉g sa꞉ga꞉lema꞉no꞉ ko꞉li nowo꞉ dia꞉ha꞉na꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gio꞉ ha꞉na꞉sa꞉ga꞉, amisa꞉na fa꞉la꞉dowakiyo꞉, gio꞉ a gelo꞉ fa꞉la꞉dowab imilig a꞉naka sa꞉ga꞉, gio꞉ amisa꞉n a꞉no꞉ ta꞉ta꞉ga꞉ ha꞉naki a꞉na eda꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ge amisa꞉na fa꞉la꞉dowo꞉ amio꞉, kaluka꞉isale iliyo꞉ gio꞉ migi widalega, giliyo꞉ amisa꞉n a꞉no꞉ mogago꞉ da꞉fe alitakiyo꞉, gili gido꞉fo꞉ amilo꞉ hena꞉mu bo꞉lo꞉ a꞉no꞉ a꞉naka fifila꞉sa꞉ga꞉ ta꞉fo꞉ ha꞉na꞉bi.” ");
INSERT INTO bco_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","A꞉la꞉wida꞉sa꞉ga꞉yo꞉, iyo꞉ ha꞉na꞉siakiyo꞉, Godeya꞉ to nafa a꞉no꞉ amisa꞉n nowa wida꞉liki, nowa wida꞉liki a꞉la꞉i ha꞉nakiyo꞉, kaluka꞉isale walafdo꞉ a꞉lab a꞉no꞉ falele alifela꞉i ane. ");
INSERT INTO bco_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","A꞉la꞉fo꞉ko꞉lo꞉ amisa꞉n a꞉namilo꞉ dimida꞉i ane a꞉no꞉, Ga꞉lili misa꞉ kalu Ha꞉lod e da꞉da꞉sa꞉ga꞉yo꞉ kele asulo꞉. Mo꞉wo꞉ kalu nolba꞉ sa꞉lakiyo꞉, “Yo꞉n ho꞉n amilo꞉ to꞉lolan kalu a꞉no꞉ a꞉ma꞉la꞉ dasi ko꞉lo꞉lab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","A꞉la꞉ta꞉ga꞉ kaluka꞉isale nolba꞉yo꞉ “Elaiya e a꞉ma꞉la꞉ handalowaki dimidab.” A꞉la꞉ta꞉ga꞉ nolba꞉yo꞉ “Godeya꞉ tolo꞉ dinali sa꞉lan kalu, mo꞉lulo꞉ elen a꞉no꞉ ko꞉lo꞉ a꞉ma꞉la꞉ dasilia꞉ga꞉ mio꞉lo꞉b” a꞉la꞉sa꞉la꞉li ane. ");
INSERT INTO bco_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ko꞉sega Ha꞉lod eyo꞉ a꞉la꞉sio꞉, “Niyo꞉ Yo꞉n e ko꞉la꞉fo꞉ gedela꞉ ko꞉m ko꞉lo꞉, to nelo꞉ da꞉dab we abe dimidaba?” Eyo꞉ a꞉la꞉asulakiyo꞉, Ya꞉su e ba꞉ba꞉no꞉ asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iliga꞉felo꞉ kaluwo꞉ a꞉ma꞉la꞉ kegeakiyo꞉, ililo꞉ dimido꞉ a꞉no꞉ tambo Ya꞉sumo꞉ malolo꞉ me. A꞉la꞉ta꞉ga꞉ Ya꞉suwa꞉ enedo꞉ tili wida꞉sen kalu a꞉no꞉ egelese doma꞉ki, iyo꞉ tililia꞉ga꞉ Besaida a꞉na ane. ");
INSERT INTO bco_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ko꞉sega kaluka꞉isale kegeo꞉ a꞉no꞉ Ya꞉sulo꞉ ane a꞉no꞉ da꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ e kudu ha꞉na꞉sio꞉. Elo꞉wa fa꞉la꞉dowabikiyo꞉, Ya꞉su eyo꞉ imo꞉wo꞉ sagalakiyo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉nigab to a꞉no꞉ widaki, a꞉la꞉ta꞉ga꞉ walafdo꞉ a꞉lab kaluka꞉isale a꞉no꞉lo꞉ falele alifelo꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ga꞉lo dowabiki, enedo꞉ tili wida꞉sen kalu kugula꞉fo꞉ a꞉no꞉ elo꞉wa ya꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Nio꞉ kalulo꞉ma hena so꞉bo꞉lo꞉biki, kaluka꞉isale kegeo꞉ we ma꞉no꞉ ma꞉no꞉wo꞉ a꞉la꞉ta꞉ga꞉ a alima꞉no꞉wo꞉ kelema꞉ki, amisa꞉n anib amilo꞉ kandayo꞉ a꞉na iliga꞉felema.” ");
INSERT INTO bco_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ma꞉no꞉ ilido꞉ ma꞉no꞉wo꞉, gili dimina.” Iliyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Niliyo꞉ falawa dowo꞉fa꞉ bila꞉fo꞉ a꞉la꞉ta꞉ga꞉ ka꞉ a꞉la꞉ a꞉no꞉ko꞉ da꞉lab. Kalu modo꞉ kegeo꞉ wema꞉lo꞉ ma꞉no꞉wo꞉ nili kililima꞉ki asulaya?” ");
INSERT INTO bco_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ilido꞉ a꞉la꞉do꞉ sio꞉wo꞉ mo꞉wo꞉ we, kalule kegeo꞉ a꞉no꞉ daosen bila꞉fo꞉ ko꞉lo꞉ sen. Ko꞉sega Ya꞉su eyo꞉ tili wida꞉sen kalumo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ kaluwo꞉ aloba꞉daki a꞉namio꞉, do꞉la꞉fo꞉ bila꞉fo꞉ a꞉la꞉ta꞉li hamana.” ");
INSERT INTO bco_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","A꞉la꞉sa꞉labiki iliyo꞉ a꞉la꞉dimida꞉sa꞉ga꞉, kaluka꞉isaleyo꞉ tambo hena sen. ");
INSERT INTO bco_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ya꞉su eyo꞉ falawa dowo꞉fa꞉ bila꞉fo꞉ o꞉lia꞉ ka꞉ a꞉la꞉ o꞉lia꞉yo꞉ dia꞉sa꞉ga꞉, akino꞉ alolo bo꞉fo꞉liki, mada o꞉m a꞉la꞉dulugu sa꞉la꞉sa꞉ga꞉yo꞉, ma꞉no꞉ a꞉no꞉ aloba꞉da꞉sa꞉ga꞉, kaluka꞉isalemo꞉ sagama꞉ki, enedo꞉ tiliwida꞉sen kalumo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kaluka꞉isale kegeo꞉ a꞉no꞉ ma꞉no꞉wo꞉ tambo o꞉li na꞉sa꞉ga꞉ ililitabiki, ma꞉no꞉ heb ta꞉felab a꞉no꞉ enedo꞉ tili wida꞉sen kalu iliyo꞉ kegeo꞉ amio꞉ fafowo꞉ kugula꞉fo꞉ ko꞉lo꞉ wa꞉litabi difa꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ho꞉len no amio꞉ Ya꞉su e dulugu sa꞉la꞉labiyo꞉, enedo꞉ tili wida꞉sen kalu a꞉no꞉ko꞉ e o꞉lia꞉ ka sen ko꞉lo꞉, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ ne kalu o꞉bka꞉ a꞉la꞉sa꞉laba?” ");
INSERT INTO bco_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Iliyo꞉ a꞉ma꞉la꞉ sa꞉lakiyo꞉, “Kalu nolba꞉yo꞉ ge Yo꞉n ho꞉n amilo꞉ to꞉lolano꞉ ge a꞉la꞉sio꞉. Nolba꞉yo꞉ ge Elaiya a꞉la꞉sio꞉. A꞉la꞉ta꞉ga꞉ nolba꞉yo꞉ ge Godeya꞉ tolo꞉ dinali sa꞉lan kalu, mo꞉lulo꞉ elen ko꞉lo꞉ a꞉ma꞉la꞉ dasilia꞉ga꞉lo꞉ mio꞉wo꞉ ge a꞉la꞉sio꞉.” ");
INSERT INTO bco_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Ko꞉sega gi wema꞉yo꞉ ne kalu o꞉b a꞉la꞉asulaya?” Ya꞉suwa꞉ a꞉la꞉dabu ba꞉dabiki, Bida eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Ge Keliso, Godeya꞉lo꞉ da꞉feyo꞉ kalu.” ");
INSERT INTO bco_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ to a꞉no꞉ kaluka꞉isale nolbo꞉wo꞉ mada sa꞉la꞉so꞉boka꞉ a꞉la꞉liki hagugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ eyo꞉ imo꞉wo꞉ a꞉la꞉wido꞉, “Kalule Dowo꞉ nemo꞉wo꞉ hida꞉yo꞉ alan dimia꞉ib. Godemo꞉ bobalo꞉ so꞉mea꞉sen misa꞉ kalu o꞉lia꞉ elelo꞉ wida꞉sen kalu o꞉lia꞉ Yu ko꞉go꞉do꞉ kalu i o꞉lia꞉ma꞉yo꞉ tambo gola ba꞉dakiyo꞉, ne sana soma꞉ib. A꞉la꞉ta꞉ga꞉ ho꞉len otaleno꞉ ta꞉ta꞉sa꞉ga꞉yo꞉, ne a꞉ma꞉la꞉ dasima꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A꞉la꞉sa꞉la꞉sa꞉ga꞉ Ya꞉su eyo꞉ kaluka꞉isale kegeo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale abeyo꞉ ne kudu mia꞉no꞉ asulalega, eyo꞉ enen asulano꞉ ka ta꞉ta꞉sa꞉ga꞉, ho꞉leno꞉ tambo ene i malano꞉ dia꞉liki soma꞉no꞉wo꞉ o꞉lika꞉ a꞉laki, ne a꞉na kudu ya꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Mo꞉wo꞉ kaluka꞉isale abeyo꞉ ene mela꞉no꞉wo꞉ halale ta꞉li dofo꞉lalega, ene mela꞉no꞉wo꞉ sulu ha꞉na꞉ib. Ko꞉sega kaluka꞉isale abeyo꞉ ne kudu yakiyo꞉, ene mela꞉no꞉wo꞉ walalega, e mela꞉no꞉leyo꞉ dia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Gio꞉ kelego꞉ henfelo꞉ wilo꞉ da꞉lab a꞉no꞉ ko꞉lo꞉ tambo asula꞉sa꞉ga꞉ kegenela꞉len amio꞉, mela꞉no꞉ gilo꞉wo꞉ sulu ha꞉nalega, kelego꞉ a꞉ma꞉yo꞉ gio꞉ waga asuwa꞉fa꞉iba? ");
INSERT INTO bco_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Kaluka꞉isale abeyo꞉ ni wi sa꞉ma꞉no꞉ o꞉lia꞉ ni to walama꞉no꞉ a꞉no꞉lia꞉yo꞉ sendelowalega, tif amio꞉ Kalule Dowo꞉ ne yakiyo꞉, ni ho꞉len fo꞉fo꞉lesodo꞉ o꞉lia꞉, Do Godeya꞉ ene ho꞉len fo꞉fo꞉lesodo꞉ o꞉lia꞉, ma꞉mula꞉ malilo꞉ a꞉ma꞉ ene ho꞉len fo꞉fo꞉lesodo꞉ o꞉lia꞉ yakiyo꞉, niyo꞉lo꞉ e wi sa꞉ma꞉no꞉wo꞉ sendeloma꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Niyo꞉ gimo꞉wo꞉ hendele so꞉lo꞉l. Kaluka꞉isale gi usamio꞉ nolo꞉ o꞉semo꞉sowalikiyo꞉, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉wo꞉ a꞉na ba꞉ba꞉ib.” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Ya꞉su eyo꞉ to a꞉no꞉ sa꞉la꞉sa꞉ga꞉yo꞉, ho꞉len ola꞉fo꞉wo꞉ ta꞉ta꞉ga꞉, eyo꞉ Bida, Ya꞉ma꞉s, Yo꞉n a꞉no꞉ko꞉ tililia꞉ga꞉, Godemo꞉ to sa꞉ma꞉niki, iyo꞉ hen misio꞉wa tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ya꞉su eyo꞉ dulugu sa꞉la꞉lena, ene wo꞉lokano꞉ ko꞉li fa꞉la꞉dowaki, a꞉la꞉ta꞉ga꞉ ene helebeso꞉g ko꞉lo꞉ a꞉no꞉ ho꞉len halaido꞉ fo꞉fo꞉lesodo꞉ fa꞉la꞉dowakiyo꞉, wabeleg sililakilo꞉ ho꞉len o꞉ngo꞉ dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","A꞉la꞉ta꞉ga꞉ Mo꞉sa꞉s dia꞉ Elaiya o꞉lia꞉yo꞉ wigibo a꞉na fa꞉la꞉dowabikiyo꞉, a꞉la꞉ a꞉namio꞉lo꞉ ho꞉len halaido꞉ a꞉no꞉ fo꞉fo꞉lesodo꞉. A꞉la꞉yo꞉ Ya꞉su o꞉lia꞉ tolakiyo꞉, e sowa꞉sa꞉ga꞉lo꞉ ha꞉na꞉no꞉ a꞉no꞉, Ya꞉lusalem a꞉namilo꞉ ko꞉na꞉ma fa꞉la꞉doma꞉nigab a꞉no꞉ ko꞉lo꞉ nenela꞉len. ");
INSERT INTO bco_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","A꞉no꞉ fa꞉la꞉dowab amio꞉, Bida e o꞉lia꞉lo꞉ mio꞉ kalu a꞉no꞉ alifo꞉len ko꞉lo꞉, dasila ba꞉ba꞉ amio꞉, ho꞉len Ya꞉su amilo꞉ fo꞉fo꞉lesodo꞉ a꞉no꞉lia꞉ kalu a꞉la꞉ nowo꞉ e aniba kagafo꞉lena ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kalu a꞉la꞉ a꞉no꞉ Ya꞉suwo꞉ ta꞉ta꞉ga꞉ ha꞉na꞉no꞉ dowabikiyo꞉, Bida eyo꞉ Ya꞉sumo꞉ a꞉la꞉sio꞉, “Kalu Alan, o꞉go꞉ nio꞉ wilo꞉ dowo꞉wo꞉ o꞉li go꞉ ko꞉lo꞉, a ha꞉lu otaleno꞉ dia꞉niki. A nowo꞉ gino꞉, nowo꞉ Mo꞉sa꞉s eno꞉, nowo꞉ Elaiya eno꞉.” Bida eyo꞉ to we ko꞉lo꞉ so꞉lo꞉l a꞉la꞉bo꞉, babale dowaki sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Bida e a꞉no꞉ ko꞉lo꞉ sa꞉la꞉len amio꞉, kolo꞉ tinda꞉sa꞉ga꞉, iyo꞉ go꞉lulabikiyo꞉, tagio꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","To nowo꞉ kola꞉ us a꞉na a꞉la꞉ta꞉ga꞉ sa꞉lakiyo꞉, “Kalu we ni so꞉wa, no꞉no꞉ndo꞉ da꞉feyo꞉wo꞉ we. To elo꞉ sa꞉labo꞉ da꞉da꞉bi.” ");
INSERT INTO bco_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","To a꞉no꞉ sa꞉la꞉sa꞉ga꞉ eletabiyo꞉, iyo꞉ Ya꞉su e ina꞉li elena ba꞉ba꞉. Ko꞉sega o꞉g ho꞉len a꞉namilo꞉ ililo꞉ ba꞉ba꞉ a꞉no꞉ kaluka꞉isale nolbo꞉wo꞉ mada mo꞉malolo꞉ me. ");
INSERT INTO bco_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kea꞉fo iyo꞉ misio꞉ a꞉na a꞉la꞉ta꞉ga꞉ tindabikiyo꞉, kaluka꞉isaleyo꞉ modo꞉ ko꞉lo꞉ Ya꞉suwo꞉ galima꞉ni mio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kegeo꞉ us a꞉namio꞉ kalu noma꞉yo꞉ Ya꞉sumo꞉wo꞉ ho꞉le susiaki a꞉la꞉sio꞉, “Widan kalu, niyo꞉ kalu so꞉wayo꞉ mada imilig we ko꞉lo꞉, giyo꞉ nofolakiyo꞉ o꞉li ba꞉ba꞉no꞉wo꞉? ");
INSERT INTO bco_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mama mogago꞉ nowo꞉ so꞉wa wena ti ha꞉nab amio꞉, so꞉wa we wigibole a꞉naka ganagilia꞉sen. Mama mogago꞉ eyo꞉ e da꞉ba꞉nama꞉ki ta꞉tab amio꞉, mesuba꞉s o꞉lia꞉ fa꞉la꞉dowa꞉sen. Mama mogago꞉ eyo꞉ emo꞉wo꞉ nagalo꞉wo꞉ dimia꞉liki, bo꞉ebo꞉ mo꞉ta꞉fo꞉ ha꞉na꞉sen. ");
INSERT INTO bco_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Niyo꞉ gilo꞉ tiliwida꞉sen kalumo꞉wo꞉ mama mogago꞉ a꞉no꞉ o꞉lusanama꞉kiyo꞉ susio꞉ ko꞉sega, i o꞉lia꞉yo꞉ mo꞉ililo꞉.” ");
INSERT INTO bco_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Ha꞉iyo꞉, o꞉g ho꞉len wenamilo꞉ kaluka꞉isale sab gili asulo꞉wo꞉ babale dowaki, ne amilo꞉ tilidabuwo꞉ aundo꞉ma dowo꞉ ko꞉lo꞉, Ne gi o꞉lia꞉lo꞉ doma꞉no꞉wo꞉ halaido꞉. Ne gio꞉ asulo꞉wo꞉ nodoma꞉kiyo꞉ ho꞉len o꞉biba꞉s yasilima꞉no꞉wa꞉le? Gi so꞉wako꞉ nelo꞉wa tililia꞉ mena” Ya꞉su eyo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","So꞉wa a꞉no꞉ Ya꞉sulo꞉wa yabikiyo꞉, mama mogago꞉ a꞉ma꞉yo꞉ e hena beseakiyo꞉, da꞉ba꞉nama꞉ki ta꞉fo꞉. Ko꞉sega Ya꞉su eyo꞉ mama mogago꞉mo꞉wo꞉ gadi sa꞉la꞉sa꞉ga꞉yo꞉, so꞉wa a꞉no꞉ falele alitaki, a꞉ma꞉la꞉ iyamo꞉ dimi. ");
INSERT INTO bco_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","A꞉la꞉dimidabikiyo꞉ kaluka꞉isale kegeo꞉ a꞉ma꞉yo꞉ Godeya꞉ halaido꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, iyo꞉ molo asulo꞉. Kaluka꞉isale kegeo꞉ a꞉no꞉ Godeya꞉ ene halaido꞉ a꞉no꞉ ba꞉da꞉sa꞉ga꞉ iligo꞉. Iyo꞉ Ya꞉su elo꞉ dimido꞉ a꞉no꞉ molo tandea꞉labikiyo꞉, Ya꞉su eyo꞉ enedo꞉ tiliwida꞉sen kalu imo꞉wo꞉ a꞉la꞉sio꞉, ");
INSERT INTO bco_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“To nilo꞉ sa꞉ma꞉nigo꞉l we, dinafa da꞉da꞉ga꞉, tifa a꞉ asula꞉bi. Kalule Dowo꞉ Ne, kalu noma꞉ teledowaki, gis kalumo꞉ gasimea꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ya꞉suwa꞉yo꞉ a꞉la꞉sio꞉ ko꞉sega, iyo꞉ to a꞉ma꞉ ha꞉go꞉ babale dowo꞉. To a꞉ma꞉ ha꞉go꞉ wo꞉no꞉le delen ko꞉lo꞉ iyo꞉ mo꞉fanda asulo꞉. A꞉la꞉ta꞉ga꞉ iyo꞉ tagilaki, Ya꞉sumo꞉wo꞉ mo꞉dabu ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ya꞉suwa꞉ enedo꞉ tiliwida꞉sen kalu i a꞉no꞉ inina꞉ma꞉la꞉ usa alo꞉ banatakiyo꞉, “ni wenamio꞉ wabulun alandeyo꞉ abe dia꞉nigaba꞉le” a꞉la꞉likiyo꞉ egelebo꞉ towa꞉yo꞉ kego꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Ko꞉sega Ya꞉su eyo꞉ ililo꞉ asulufo꞉lab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, so꞉wala꞉su nowo꞉ tililia꞉ga꞉, e aniba kagafo꞉melea꞉ki ta꞉takiyo꞉, imo꞉wo꞉ a꞉la꞉sio꞉ “Kalu abeyo꞉ ne wiya a꞉la꞉ta꞉ga꞉yo꞉, so꞉wala꞉suwo꞉ sagala꞉liki tili dowalega, eyo꞉ ne ko꞉lo꞉ tili dowakigab. A꞉la꞉ta꞉ga꞉ kalu abeyo꞉ ne sagala꞉liki tili dowalega, eyo꞉ nelo꞉ iliga꞉fo꞉ o꞉mo꞉wo꞉lo꞉ sagalaki tili dowaki auma꞉ib. Gi usamio꞉, kalu abeyo꞉ e o꞉ngo꞉malo꞉ngo꞉ a꞉laki ha꞉ga dowalega, hendele wa꞉la꞉b alano꞉ e dowab.” ");
INSERT INTO bco_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ya꞉su eyo꞉ a꞉la꞉sa꞉labiki, Yo꞉n eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉dabu ba꞉ba꞉, “Widan kalu, niliyo꞉ kalu noma꞉yo꞉ gi wiya a꞉la꞉ta꞉ga꞉ mama mogago꞉wo꞉ o꞉luga꞉felabi ba꞉da꞉ga꞉, nilo꞉ gasalo꞉ mo꞉dowa꞉sena꞉ gab ko꞉lo꞉, niliyo꞉ emo꞉wo꞉ dimida꞉so꞉boka꞉ a꞉la꞉liki ele alifa꞉.” ");
INSERT INTO bco_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","A꞉la꞉sa꞉labiki Ya꞉suwa꞉yo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Elo꞉ dimidab a꞉no꞉ ka꞉la꞉so꞉bo. Mo꞉wo꞉ kalu abeyo꞉ gi o꞉lia꞉lo꞉ gisdo꞉ mo꞉dowab a꞉no꞉, gilino꞉le dowab.” ");
INSERT INTO bco_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya꞉suwo꞉ Hebene a꞉ma꞉la꞉ ha꞉na꞉no꞉ ho꞉leno꞉ ko꞉na꞉ma dowabikiyo꞉, e mada Ya꞉lusalem ha꞉na꞉no꞉ a꞉la꞉ asululi. ");
INSERT INTO bco_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ya꞉su e Samalia hen amisa꞉n nowa alima꞉niki, eyo꞉ amisa꞉n a꞉no꞉ dimidalima꞉kiyo꞉, towo꞉ saga꞉fo꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ko꞉sega iliyo꞉ Ya꞉su e Ya꞉lusalem ha꞉nab a꞉la꞉asulaki, iliyo꞉ e ili amisa꞉na mena꞉kiyo꞉ mo꞉ho꞉leli. ");
INSERT INTO bco_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Tiliwida꞉sen kalu a꞉la꞉, Ya꞉ma꞉s o꞉lia꞉ Yo꞉n o꞉lia꞉yo꞉, ililo꞉ man dimidab a꞉no꞉ ba꞉da꞉sa꞉ga꞉, a꞉la꞉ma꞉yo꞉ Ya꞉sumo꞉wo꞉ dabu ba꞉ba꞉, “Kalu Alan, naino꞉ de Hebene a꞉la꞉ta꞉ga꞉lo꞉ tima꞉no꞉ a꞉ma꞉yo꞉ kaluka꞉isale we tambo yasala꞉ma꞉kiyo꞉, de a꞉no꞉ ho꞉lema꞉ki asulaya?” ");
INSERT INTO bco_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A꞉la꞉dabu ba꞉ba꞉ ko꞉sega, Ya꞉su e a꞉ma꞉la꞉ nodola꞉sa꞉ga꞉, a꞉la꞉ma꞉lo꞉ hala sa꞉lab a꞉no꞉ digalaki halaido꞉ sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ iyo꞉ amisa꞉n nowa ha꞉na꞉ni ane. ");
INSERT INTO bco_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Iyo꞉ toga ha꞉na꞉ga꞉ ha꞉nakiyo꞉, kalu noma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Gelo꞉ ha꞉nab amio꞉, ne ge kudu sia꞉mela꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Saila gasalo꞉ mesa꞉no꞉wo꞉ aluwo꞉ da꞉lab a꞉la꞉ta꞉ga꞉ o꞉ba꞉ya꞉yo꞉ us silia꞉fa꞉no꞉wo꞉ ayo꞉ da꞉lab. Ko꞉sega Kalule Dowo꞉ e, a enedo꞉leyo꞉ mada aundo꞉ma.” ");
INSERT INTO bco_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ kalu nowo꞉mbo꞉wo꞉ a꞉la꞉sio꞉, “Ge ne kudu mena.” Ko꞉sega eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Alan, ni amisa꞉na a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, do sowo꞉ ko꞉le dali alita꞉ga꞉yo꞉, ge a꞉na kudu mia꞉no꞉wo꞉ o꞉liya꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale ne amilo꞉ mo꞉tilida꞉dab a꞉no꞉ sowo꞉ o꞉ngo꞉ sab ko꞉lo꞉ i a꞉no꞉ sowo꞉ egele dalima꞉ki ta꞉foma. Ge Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ man a꞉no꞉ ko꞉lo꞉ walama꞉ni hamana.” ");
INSERT INTO bco_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","A꞉la꞉ta꞉ga꞉ noma꞉yo꞉ Ya꞉sumo꞉wo꞉ a꞉la꞉sio꞉, “Ne ge kudu mia꞉no꞉ asulo꞉ ko꞉sega, ne a꞉ma꞉la꞉ ha꞉na꞉sa꞉ga꞉, so꞉lo꞉mo꞉wo꞉ ta꞉biyo꞉ a꞉la꞉ ko꞉le sa꞉la꞉sa꞉ga꞉ mia꞉no꞉.” ");
INSERT INTO bco_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ya꞉su eyo꞉ a꞉ma꞉la꞉bo꞉ a꞉la꞉sio꞉, “Kaluka꞉isale abeyo꞉, ne mo꞉mo꞉da kudu yakiyo꞉, man tamin amilo꞉ dimida꞉sen a꞉no꞉ a꞉ma꞉la꞉yo꞉ asuluma꞉ ha꞉nalega, e Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ hen us amilo꞉ nanog dimidama꞉no꞉wo꞉ mo꞉ego꞉ doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","A꞉ma꞉ fa꞉s amio꞉ Alan eyo꞉ elo꞉ kudu mio꞉ kalu do꞉la꞉lowo꞉ dom a꞉la꞉ta꞉ga꞉ a꞉la꞉ a꞉no꞉ da꞉fea꞉sa꞉ga꞉, amisa꞉n ko꞉li ko꞉lilo꞉ elo꞉ ha꞉na꞉no꞉ asulab a꞉namida꞉ tamina hamana꞉ki, eyo꞉ kaluwo꞉ a꞉la꞉ a꞉la꞉, a꞉la꞉ iliga꞉felo꞉ ");
INSERT INTO bco_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Iyo꞉ o꞉iliga꞉fa꞉nikiyo꞉, eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Egelo꞉ amilo꞉ fowo꞉ nafaliabdo꞉ tuma꞉no꞉wo꞉ modo꞉ dowab ko꞉sega, kalu o꞉lo꞉ tuma꞉no꞉wo꞉ a꞉la꞉se dowab. A꞉la꞉fo꞉ko꞉lo꞉ giliyo꞉ egelo꞉lo꞉ biso꞉mo꞉ dulugu sa꞉lakiyo꞉, eyo꞉ fowo꞉ nafaliab o꞉lo꞉ tuma꞉no꞉ kaluwo꞉ modo꞉ iliga꞉foma꞉ki dabu ba꞉da꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","O꞉go꞉ gio꞉ ha꞉na꞉nigab ko꞉sega tamin amio꞉ asuluma. Gio꞉ sibi inso꞉ o꞉ngo꞉ ko꞉lo꞉, niyo꞉ saila gasaya꞉lo꞉ gilo꞉ yasala꞉ma꞉no꞉ hen o꞉ngo꞉wa iliga꞉fa꞉nigo꞉l. ");
INSERT INTO bco_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Gio꞉ ha꞉nakiyo꞉, moleyo꞉, budiyo꞉, kelego꞉ nolo꞉ dimida sa꞉la꞉ a꞉no꞉ ka ta꞉ta꞉sa꞉ga꞉ ha꞉na꞉bi. Gio꞉ kalu nolo꞉ tog amio꞉ gidakiyo꞉, i o꞉lia꞉ towo꞉ modo꞉wo꞉ kuda꞉so꞉bo. ");
INSERT INTO bco_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gio꞉ aya fa꞉la꞉dowakiyo꞉, tamin amio꞉ imo꞉wo꞉ sagalo꞉ towo꞉ a꞉la꞉sa꞉la꞉bi, ‘Gode eyo꞉ kaluka꞉isale a wilo꞉ sab a꞉no꞉ ha꞉sa mesea꞉ki ta꞉fa꞉ib.’ ");
INSERT INTO bco_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Gio꞉ a꞉la꞉sa꞉lalikiyo꞉, kalu a a꞉namilo꞉ sa꞉sen a꞉no꞉ ha꞉sa san o꞉lalega, gilo꞉ ha꞉salo꞉ mesa꞉no꞉ to sa꞉lab a꞉no꞉ e amio꞉ doma꞉ib. Ko꞉sega e ha꞉sayo꞉ mo꞉dowa꞉sen o꞉lalega, to a꞉no꞉ a꞉ma꞉la꞉ go꞉no꞉na a꞉doma꞉ mia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","A gilo꞉ fa꞉la꞉dowab a꞉naka dowaki, a nowa a꞉la꞉bo꞉ sia꞉so꞉bo. A a꞉na silikiyo꞉, ma꞉no꞉wo꞉lo꞉, ho꞉no꞉lo꞉ ililo꞉ gimo꞉lo꞉ meab a꞉no꞉ ko꞉lo꞉ na꞉lubi. Mo꞉wo꞉ nanogdo꞉ dian kaluwo꞉ wa꞉lo꞉ o꞉li dian ko꞉lo꞉, gilo꞉ nanog di wa꞉lo꞉ o꞉m. ");
INSERT INTO bco_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Gio꞉ amisa꞉n nowa fa꞉la꞉dowo꞉ amio꞉, iliyo꞉ gio꞉ tilidowalega, ma꞉no꞉wo꞉ ililo꞉ gimo꞉lo꞉ dimiab a꞉no꞉ ko꞉lo꞉ na꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Walaf kaluka꞉isale a꞉namilo꞉ sab a꞉no꞉ giliyo꞉ falele alita꞉bi. A꞉la꞉ta꞉ga꞉ imo꞉wo꞉ towo꞉ a꞉la꞉wida꞉bi, ‘Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ gilo꞉ amio꞉ ko꞉na꞉ma ya꞉ga꞉ a꞉lab.’ ");
INSERT INTO bco_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ko꞉sega gio꞉ amisa꞉n nowa fa꞉la꞉dowo꞉ amio꞉, iliyo꞉ gio꞉ mo꞉tilidowalega, gio꞉ baya kagayakiyo꞉, imo꞉wo꞉ towo꞉ a꞉la꞉sa꞉labi, ");
INSERT INTO bco_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Gililo꞉ hala dimido꞉ a꞉no꞉ widakiyo꞉, gili hen wenamilo꞉ hena꞉mu nili gib amilo꞉ oga꞉do꞉ a꞉no꞉, a꞉ma꞉la꞉ wena fifila꞉sa꞉ga꞉ ha꞉na꞉no꞉. Ko꞉sega gio꞉ to we asuluma. Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ gilo꞉ amio꞉ ko꞉na꞉ma ya꞉ga꞉ a꞉lab.’ ");
INSERT INTO bco_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","A꞉la꞉ta꞉ga꞉ niyo꞉ gimo꞉wo꞉ a꞉la꞉so꞉lo꞉l. Godeya꞉ kaluka꞉isalelo꞉ mo꞉walilab ho꞉len a꞉namio꞉, amisa꞉n kaluka꞉isale we falasilakilo꞉ hida꞉yo꞉ dia꞉nigab a꞉no꞉, Sodom kaluka꞉isaleya꞉lo꞉ hida꞉yo꞉ ba꞉ba꞉ib a꞉no꞉ wema꞉ tininima꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Wai, Kolasin amisa꞉n kaluka꞉isale gilo꞉ amio꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. A꞉la꞉ta꞉ga꞉ Besaida amisa꞉n kaluka꞉isale gilo꞉ amio꞉lo꞉ hida꞉yo꞉wo꞉ alan fa꞉la꞉doma꞉ib. Gilo꞉ amio꞉ molo ha꞉na꞉no꞉wo꞉ modo꞉ dimido꞉. Molo ha꞉na꞉no꞉ wengo꞉wo꞉ Taya amisa꞉n o꞉lia꞉ Saido꞉n amisa꞉n a꞉na dimido꞉ kibo꞉bowo꞉, iliyo꞉ man mogago꞉ dimida꞉len a꞉no꞉ ka ta꞉ta꞉sa꞉ga꞉, asulo꞉wo꞉ nodolo꞉ka꞉ a꞉la꞉widakiyo꞉, iliyo꞉ nofolo꞉ so꞉g a꞉no꞉ sa꞉ga꞉la꞉sa꞉ga꞉, dufuna꞉yo꞉ mulumabe. ");
INSERT INTO bco_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Godeya꞉ kaluka꞉isalelo꞉ mo꞉walilab ho꞉len a꞉namio꞉, Taya o꞉lia꞉ Saido꞉n kaluka꞉isaleya꞉lo꞉ hida꞉yo꞉ ba꞉ba꞉ib a꞉no꞉, gilo꞉ falasilakilo꞉ hida꞉yo꞉ dia꞉ib a꞉ma꞉ tininima꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","A꞉la꞉ta꞉ga꞉ Kabaniom kaluka꞉isale gili wiyo꞉ Gode eyo꞉ iwalu duluba꞉iba꞉le? A꞉la꞉ba, gio꞉ mada dane ane hen a꞉na ti ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Kaluka꞉isale abeyo꞉ gili to sa꞉labdo꞉ dabu a꞉no꞉, ni towo꞉ da꞉dan. Kaluka꞉isale abeyo꞉ gilo꞉ gola ba꞉dab a꞉ma꞉yo꞉ nelo꞉ gola ba꞉dab. A꞉la꞉ta꞉ga꞉ kaluka꞉isale nelo꞉ gola ba꞉dab a꞉ma꞉yo꞉, Gode nelo꞉ iliga꞉fo꞉ a꞉no꞉lo꞉ gola ba꞉dakigab.” ");
INSERT INTO bco_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nanog a꞉no꞉ dimida꞉la꞉ga꞉yo꞉, kalu do꞉la꞉lowo꞉ dom a꞉la꞉ta꞉ga꞉ a꞉la꞉ a꞉no꞉ sagala꞉li a꞉ma꞉la꞉ yakiyo꞉ a꞉la꞉sio꞉, “Alan, niliyo꞉ gi wiya iliki to sa꞉lab amio꞉, mama mogago꞉ iliyo꞉lo꞉ nili to a꞉no꞉ kudu ane.” ");
INSERT INTO bco_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Niyo꞉ Sa꞉da꞉na꞉ e, wabeleg o꞉ngo꞉ ko꞉lo꞉ Hebene halona a꞉la꞉ta꞉ga꞉ sulufo꞉ tindabiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Dabuma. Gio꞉ kisa꞉wa꞉l o꞉lia꞉ ma꞉ilagana o꞉lia꞉yo꞉ wa꞉la꞉ sa꞉nda꞉i hamana꞉ki, a꞉la꞉ta꞉ga꞉ gili gis kalu, Sa꞉da꞉na꞉ya꞉ halaido꞉ a꞉no꞉ tambo gili tininima꞉kiyo꞉, halaido꞉wo꞉ gimo꞉ dimi ko꞉lo꞉, kelego꞉ imilise noma꞉yo꞉ gio꞉ mada mo꞉mogagima꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ko꞉sega mama mogago꞉wa꞉lo꞉ gili to sio꞉ ko꞉lo꞉ kudu ha꞉nab a꞉no꞉, gio꞉ sagala꞉so꞉bo. Hebene a꞉namilo꞉ gili wi sa꞉sa꞉li alifa꞉ a꞉no꞉ ko꞉lo꞉ sagala꞉bi.” Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ho꞉len a꞉naka, Mama Malilo꞉ eyo꞉ Ya꞉suwo꞉ sagalo꞉wa꞉ ililitabiki, Ya꞉su eyo꞉ a꞉la꞉dulugu sio꞉. “Do Gode, Hebene o꞉lia꞉ henfelo꞉ we o꞉lia꞉lo꞉ biso꞉wo꞉ ge. Giyo꞉ to we asulo꞉lo꞉ di kaluka꞉isalemo꞉wo꞉ wo꞉no꞉le dia꞉taki, kaluka꞉isale so꞉wala꞉su o꞉ngo꞉ dowab o꞉mo꞉wo꞉ kalab amio꞉ wida꞉sen ko꞉lo꞉, niyo꞉ ge wabulu sa꞉laki, dulugu so꞉lo꞉l. Hendele Do gilo꞉ dimido꞉ a꞉no꞉, go꞉no꞉n ge sagalema꞉no꞉wo꞉ au dimido꞉. ");
INSERT INTO bco_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Dowa꞉yo꞉ kelego꞉wo꞉ tambo ni dagiya difa꞉. Kaluka꞉isaleyo꞉ tambo ene So꞉wa a꞉no꞉ mo꞉asulo꞉ ko꞉sega, Iya Gode imilig eka So꞉wayo꞉ asulo꞉ ko꞉lo꞉lab. A꞉la꞉ta꞉ga꞉ kaluka꞉isaleyo꞉ tambo Iyayo꞉ mo꞉asulo꞉ ko꞉sega, So꞉wa eneno꞉ a꞉la꞉ta꞉ga꞉ kaluka꞉isale So꞉waya꞉lo꞉ kalab amilo꞉ wido꞉ i a꞉ma꞉yo꞉lo꞉, Iyayo꞉ asulufo꞉lab.” Ya꞉su eyo꞉ a꞉la꞉dulugu sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","A꞉la꞉dulugu sa꞉la꞉sa꞉ga꞉yo꞉, Ya꞉su e nodola꞉sa꞉ga꞉, enedo꞉ tili wida꞉sen kalu imo꞉wo꞉ towo꞉ ha꞉sa sa꞉laki a꞉la꞉sio꞉, “Kalu abeyo꞉ kelego꞉ gilo꞉ ba꞉ba꞉ a꞉no꞉ ba꞉dakiyo꞉, iyo꞉ mada sagalema꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mo꞉luwo꞉ Godeya꞉ dinali sa꞉lan kalu o꞉lia꞉ misa꞉ kalu modo꞉ o꞉lia꞉ma꞉yo꞉, gililo꞉ ba꞉ba꞉ a꞉no꞉ iliyo꞉lo꞉ bo꞉bo꞉losa꞉ a꞉la꞉li yasila꞉len ko꞉sega mo꞉ba꞉ba꞉. A꞉la꞉ta꞉ga꞉ gililo꞉ dabu a꞉no꞉ iliyo꞉lo꞉ mada da꞉ba꞉no꞉ a꞉la꞉li yasi elen ko꞉sega mo꞉dabu.” ");
INSERT INTO bco_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ho꞉len no amio꞉ Ya꞉su e to wida꞉labiki, elelo꞉ asulo꞉ kalu nowo꞉ dasilia꞉sa꞉ga꞉, Ya꞉suwo꞉ da꞉fe ba꞉dakiyo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉. “Widan kalu, nilo꞉ mela꞉no꞉ mela꞉no꞉ dia꞉no꞉ a꞉no꞉, waga dimidaliki dia꞉no꞉wa꞉le?” ");
INSERT INTO bco_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","A꞉la꞉dabu ba꞉dabiki, Ya꞉suwa꞉ a꞉ma꞉la꞉ emo꞉ sa꞉laki, “Godeya꞉ ene to sa꞉sa꞉lo꞉ a꞉ma꞉yo꞉ waga sio꞉wo꞉? Giyo꞉ agelakiyo꞉, ha꞉go꞉ waga asulo꞉wo꞉?” ");
INSERT INTO bco_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Eyo꞉ a꞉ma꞉la꞉ sa꞉laki a꞉la꞉sio꞉, “Go꞉no꞉n Gode Alano꞉ mada alan asulaki, go꞉no꞉n kufa꞉ us o꞉lia꞉, go꞉no꞉n mama o꞉lia꞉, go꞉no꞉n do꞉mo꞉wa꞉ halaido꞉ o꞉lia꞉, go꞉no꞉n asulo꞉ o꞉lia꞉ma꞉yo꞉ tambo Godemo꞉wo꞉ ha꞉fo꞉ disa꞉la꞉bi. A꞉la꞉ta꞉ga꞉ gio꞉ go꞉no꞉n asulan o꞉leaumbo꞉, giasi kaluka꞉isale nolo꞉lo꞉ a꞉la꞉asulaki ha꞉fo꞉wo꞉ disa꞉la꞉lubi.” ");
INSERT INTO bco_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ya꞉su eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Gio꞉ hendele sa꞉lab. Giyo꞉ a꞉la꞉dimidalega, ge mela꞉no꞉ mela꞉no꞉wo꞉ dia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ko꞉sega kalu a꞉ma꞉yo꞉ eneno꞉ mo꞉sendeloma꞉ki, wi duludakiyo꞉, Ya꞉sumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Niasi kaluka꞉isale a꞉la꞉do꞉ sa꞉lab a꞉no꞉ kalu o꞉b ko꞉lo꞉ sa꞉laba?” ");
INSERT INTO bco_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","A꞉la꞉dabu ba꞉dabiki, Ya꞉su eyo꞉ bale sio꞉ we a꞉na malolo꞉ me. “Kalu nowo꞉ Ya꞉lusalemo꞉ ta꞉ta꞉sa꞉ga꞉, Ya꞉liko holona ha꞉na꞉ni ane. E toga ha꞉nab amio꞉, afalo꞉ dian kalu nolo꞉ wo꞉no꞉le banaefo꞉la꞉ga꞉ handalowakiyo꞉, kelego꞉ elo꞉wo꞉ tambo ho꞉go꞉fe sa꞉la꞉la꞉sa꞉ga꞉, e habaya sanaeta꞉ga꞉ a꞉na ha꞉na꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","O꞉g ho꞉len a꞉namio꞉, bobalo꞉ so꞉mea꞉sen kalu nowo꞉ tog a꞉na ti ha꞉na꞉ni ane ko꞉lo꞉, kalu a꞉no꞉ toga sanaefo꞉lena ba꞉da꞉sa꞉ga꞉, e ha꞉la꞉ya begele ane. ");
INSERT INTO bco_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","A꞉ma꞉ fa꞉s amio꞉, Godeya꞉ alo꞉ bo꞉fo꞉lowan kalu nowo꞉ ya꞉sa꞉ga꞉, kalu a꞉no꞉ ba꞉da꞉ga꞉yo꞉, elo꞉ begele ane. ");
INSERT INTO bco_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Ko꞉sega Samalia kalu nowo꞉ toga ha꞉na꞉ga꞉ ha꞉nakiyo꞉, kalu o꞉lo꞉wa fa꞉la꞉dowakiyo꞉ ba꞉da꞉sa꞉ga꞉, e nofolo꞉wo꞉ alan dowo꞉. ");
INSERT INTO bco_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","E elo꞉wa ha꞉na꞉sa꞉ga꞉ fa꞉la꞉dowakiyo꞉, wain ho꞉n o꞉lia꞉ wa ho꞉n o꞉lia꞉yo꞉ yame tandeo꞉ a꞉na mulula꞉sa꞉ga꞉ mebe alifelo꞉. A꞉la꞉ta꞉ga꞉ eyo꞉ kalu a꞉no꞉ fo꞉fo꞉la꞉sa꞉ga꞉, ene donki wa꞉la dia꞉ta꞉ga꞉, mageso꞉ kaluwa꞉ aya dia꞉ha꞉na꞉sa꞉ga꞉, a꞉na bo꞉fo꞉len. ");
INSERT INTO bco_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ho꞉len a꞉ma꞉ fa꞉s amio꞉ e ha꞉na꞉nikiyo꞉, eyo꞉ silba mole a꞉la꞉yo꞉ alo꞉ biso꞉mo꞉ dimiakiyo꞉ a꞉la꞉sio꞉, ‘Kalu we gi bo꞉fo꞉lubi. Giyo꞉ kalu we bo꞉fo꞉len amio꞉, mole we kedeta꞉ga꞉, go꞉ndo꞉ma꞉ kililialega, ne a꞉ma꞉la꞉ yakiyo꞉, wa꞉lo꞉ gemo꞉wo꞉ dimia꞉no꞉.’” ");
INSERT INTO bco_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ya꞉su eyo꞉ malolo꞉ a꞉no꞉ sa꞉la꞉sa꞉ga꞉, elelo꞉ wida꞉sen kalumo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Kalu i otalen us a꞉namio꞉, afalo꞉ dian kaluwa꞉lo꞉ kalu sanaefa꞉ a꞉ma꞉ ene iasileyo꞉ ho꞉bo꞉ko꞉mo꞉lo꞉bo꞉?” ");
INSERT INTO bco_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Elelo꞉ asulo꞉ kalu eyo꞉ a꞉ma꞉la꞉yo꞉ a꞉la꞉sio꞉, “Kalu nofola꞉sa꞉ga꞉lo꞉ asufa꞉ a꞉no꞉, ene iasi kaluwo꞉ o꞉m.” A꞉la꞉sa꞉labiki, Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Ge man o꞉leo꞉ngo꞉ka dimidama꞉ni hamana.” ");
INSERT INTO bco_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ya꞉su o꞉lia꞉ ene tiliwida꞉sen kalu i o꞉lia꞉yo꞉ Ya꞉lusalem o꞉ha꞉na꞉ga꞉ ha꞉nakiyo꞉, iyo꞉ amisa꞉n nowa tiane. Amisa꞉n ga nowo꞉ ene wiyo꞉ Mata ko꞉lo꞉, eyo꞉ Ya꞉suwo꞉ e aya tililia꞉gane. ");
INSERT INTO bco_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mataya꞉ ene adowo꞉ wiyo꞉ Malia. E Ya꞉suwa꞉ gib aniba siliki, Ya꞉suwa꞉lo꞉ to wida꞉lab a꞉no꞉ da꞉da꞉li sen. ");
INSERT INTO bco_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ko꞉sega Mata e ma꞉no꞉ ma꞉no꞉ dimidala꞉likiyo꞉, kele asulo꞉wo꞉ alan dowo꞉. A꞉la꞉gabiki e Ya꞉sulo꞉wa ha꞉na꞉sa꞉ga꞉ a꞉la꞉sio꞉, “Alan, nadowa꞉yo꞉ ma꞉no꞉ dimidalia꞉no꞉ nanog a꞉no꞉ nina꞉li nemo꞉ ta꞉tab a꞉no꞉ giyo꞉ waga asulaba? Ne asuwa꞉foma꞉ki, giyo꞉ emo꞉wo꞉ sama.” ");
INSERT INTO bco_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ a꞉la꞉sio꞉, “Mata, Mata, kelego꞉ ko꞉li ko꞉lilo꞉ amio꞉ ge kele asulo꞉wo꞉ modo꞉ dowab. ");
INSERT INTO bco_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ko꞉sega kelego꞉ imilise nowo꞉ mada alan asulufo꞉ mela꞉no꞉ ko꞉lo꞉lab. Malia elo꞉ asulakilo꞉ dimidab we mada nafale dowo꞉ ko꞉lo꞉, noma꞉yo꞉ elo꞉ asulakilo꞉ dimidab a꞉no꞉ mo꞉dila꞉ma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ho꞉len no amio꞉ Ya꞉suwo꞉ hen nowa siliki, Godemo꞉ dulugu sa꞉la꞉len. Eyo꞉ dulugu sa꞉la꞉la꞉leno꞉ eletabikiyo꞉, enedo꞉ tiliwida꞉sen kalu noma꞉yo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Alan, Yo꞉na꞉ enedo꞉ tili wida꞉sen kalumo꞉lo꞉ dulugu sa꞉lan man wido꞉ o꞉leaumbo꞉, giyo꞉ nimo꞉wo꞉lo꞉ walama.” ");
INSERT INTO bco_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A꞉la꞉sa꞉labiki Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Giliyo꞉ dulugu sa꞉lakiyo꞉ a꞉la꞉sa꞉la꞉bi. “ ‘Dowa, kaluka꞉isaleya꞉yo꞉ ge wiyo꞉ wabuluma꞉ki so꞉lo꞉l. Ge misa꞉ kalu dowakilo꞉, tambolo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉len a꞉no꞉ ko꞉lo꞉ fa꞉la꞉doma꞉ki so꞉lo꞉l. ");
INSERT INTO bco_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Gio꞉ ma꞉no꞉wo꞉ ho꞉leno꞉ tambo nililo꞉ ma꞉no꞉ ililo꞉ aumbo꞉ dimia꞉lubi. ");
INSERT INTO bco_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Mogago꞉ nolba꞉lo꞉ nimo꞉lo꞉ dimida꞉lab amilo꞉ ga꞉lila꞉sen o꞉leaumbo꞉, Giyo꞉lo꞉ mogago꞉ nililo꞉ dimida꞉lo꞉l a꞉no꞉ hala꞉sa꞉ga꞉ ga꞉lila꞉bi. A꞉la꞉ta꞉ga꞉ nio꞉ mogago꞉lo꞉ dimidama꞉no꞉ a꞉namida꞉yo꞉ ha꞉nabena꞉ki, giyo꞉ nio꞉ tili dowa꞉bi.’” ");
INSERT INTO bco_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ Ya꞉su eyo꞉ imo꞉wo꞉ bale sa꞉laki malolo꞉ me. “Kalu nowo꞉ nulu us amio꞉ ene mililo꞉wa ha꞉na꞉ga꞉ fa꞉la꞉dowakiyo꞉ a꞉la꞉sa꞉ma꞉ib, ‘Ni mili, na꞉ mili nowo꞉ sia꞉la꞉ga꞉ o꞉go꞉ nelo꞉wa fa꞉la꞉dowab ko꞉lo꞉, nilo꞉ ma꞉no꞉ emo꞉lo꞉ mea꞉no꞉wo꞉ aundo꞉ma dowab. A꞉la꞉fo꞉ko꞉lo꞉ giyo꞉ ma꞉n dowo꞉fa꞉ otaleno꞉ nemo꞉ dimia꞉no꞉wo꞉ o꞉liyo꞉?’ ");
INSERT INTO bco_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Eyo꞉ a꞉la꞉dabu ba꞉dabiki, kalu a usamilo꞉ elen a꞉ma꞉yo꞉ a꞉la꞉sa꞉ma꞉ib, ‘A, ne digida꞉ya꞉so꞉bo. Togo꞉ o꞉ma uluda꞉sa꞉ga꞉, ne so꞉lo꞉wo꞉ tambo uwo꞉ba alilo꞉l. Ne a꞉dasilia꞉sa꞉ga꞉yo꞉, kelego꞉wo꞉ gemo꞉wo꞉ mada mo꞉dimia꞉no꞉’ a꞉la꞉sa꞉ma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Malolo꞉ a꞉no꞉ gio꞉ asuluma꞉kiyo꞉, niyo꞉ to we gimo꞉ so꞉lo꞉l. Kalu a usamilo꞉ elen a꞉ma꞉yo꞉ ene mili kalu tamina ya꞉sa꞉ga꞉ dabu ba꞉dabikiyo꞉, ma꞉no꞉ mo꞉dimi. Ko꞉sega mili kalu a꞉no꞉ mo꞉sendelowaki, ha꞉nifo꞉ko꞉ dowa꞉labiki, mo꞉wo꞉ a꞉na ilikiyo꞉, kalu a usamilo꞉ elen a꞉no꞉ dasilia꞉ga꞉, elo꞉ dia꞉no꞉ asulab aumbo꞉ emo꞉wo꞉ o꞉li dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“A꞉la꞉fo꞉ko꞉lo꞉ niyo꞉ gimo꞉wo꞉ a꞉la꞉wido꞉l. Giliyo꞉ Godemo꞉ dabu ba꞉da꞉lubi. A꞉la꞉galikiyo꞉ giliyo꞉ dia꞉ib. Giliyo꞉ kelefo꞉ko꞉ dowa꞉lubi. A꞉la꞉galikiyo꞉ giliyo꞉ ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ toga godogodola꞉lubi. A꞉la꞉galikiyo꞉ togo꞉ gimo꞉wo꞉ kolalia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Mo꞉wo꞉ kaluka꞉isale abeyo꞉ Godemo꞉lo꞉ dabu ba꞉dab iliyo꞉ dia꞉ib. Kaluka꞉isale abeyo꞉ keda꞉lab iliyo꞉ mada ba꞉ba꞉ib. A꞉la꞉ta꞉ga꞉ kaluka꞉isale abeyo꞉ tog amilo꞉ godogodolab imo꞉wo꞉ Gode eyo꞉ togo꞉ kolalia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","So꞉walo꞉ iya gio꞉ asuluma. So꞉wa gilo꞉wo꞉ maiyakiyo꞉ ka꞉ ha꞉iyalega, giyo꞉ kisa꞉wa꞉lo꞉ dimia꞉no꞉wa꞉le? ");
INSERT INTO bco_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","A꞉la꞉ta꞉ga꞉ so꞉wa gilo꞉wo꞉ o꞉ba꞉ uso꞉ ha꞉iyalega, giyo꞉ ma꞉ilaganayo꞉ dimia꞉no꞉wa꞉le? A꞉la꞉bo꞉ mo꞉dimia꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mogago꞉ kalu giliyo꞉ go꞉no꞉n so꞉wamo꞉lo꞉ kelego꞉ nafayo꞉ dimia꞉sen a꞉no꞉ ko꞉lo꞉ asuluma. A꞉la꞉fo꞉ko꞉lo꞉ Do Gode Hebenelo꞉ sab a꞉ma꞉yo꞉, kaluka꞉isale emo꞉lo꞉ dabu ba꞉dab o꞉mo꞉wo꞉ Mama Malilo꞉ a꞉no꞉ mada hendele dimia꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kalu nowo꞉ mama mogago꞉ dofo꞉liki, mego꞉fo꞉ do꞉fo꞉f ta꞉fo꞉ ko꞉lo꞉, ho꞉len no amio꞉ Ya꞉suwa꞉ o꞉lusa꞉ndabiki, mama mogago꞉ a꞉no꞉ a꞉na ane. Ha꞉nabikiyo꞉ kalu a꞉no꞉ towo꞉ wa꞉ka tolabiki, kaluka꞉isaleyo꞉ mada molo asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ko꞉sega kaluka꞉isale nolba꞉yo꞉ a꞉la꞉sio꞉, “Kalu we, mama mogago꞉wa꞉lo꞉ bo꞉fo꞉lowan misa꞉ kalu, Bia꞉sabul a꞉ma꞉ halaido꞉wa iliki, mama mogago꞉wo꞉ a꞉na o꞉luga꞉felab” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","A꞉la꞉ta꞉ga꞉ kaluka꞉isale nolba꞉yo꞉ Ya꞉su e ko꞉lo꞉ da꞉fe ba꞉dakiyo꞉, emo꞉wo꞉ a꞉la꞉dabu ba꞉ba꞉, “Ge hendele Godelo꞉wa a꞉la꞉ta꞉ga꞉ mio꞉ a꞉la꞉liki widakiyo꞉, molo ha꞉na꞉no꞉ nowo꞉ dimidama” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ko꞉sega Ya꞉su eyo꞉ ililo꞉ asulab a꞉no꞉ ba꞉da꞉sa꞉ga꞉yo꞉, imo꞉wo꞉ a꞉la꞉sio꞉, “Amisa꞉n imilig no amio꞉ kaluwo꞉ aloba꞉da꞉sa꞉ga꞉ egele bubalega, amisa꞉n a꞉no꞉ mada mogaila꞉ma꞉ib. A꞉la꞉ta꞉ga꞉ so꞉lo꞉ imilig nowo꞉ aloba꞉da꞉sa꞉ga꞉ egele gis dialega, so꞉lo꞉ a꞉no꞉ mada sudu ha꞉na꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","A꞉la꞉do꞉ gan o꞉leaumbo꞉, giliyo꞉ ne Bia꞉sabul a꞉ma꞉ halaido꞉wa iliki, mama mogago꞉wo꞉ o꞉luga꞉felab a꞉la꞉sa꞉lait. Ko꞉sega Sa꞉da꞉na꞉ya꞉ ene so꞉lo꞉wo꞉ usa aloba꞉da꞉sa꞉ga꞉ egele a꞉bubalega, iyo꞉ halaido꞉wo꞉ mo꞉doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Niyo꞉ Bia꞉sabul a꞉ma꞉ halaido꞉wa iliki, mama mogago꞉wo꞉ a꞉na o꞉lusa꞉ndai kibo꞉bowo꞉, gilo꞉ tili wida꞉sen kalu i a꞉ma꞉lo꞉ mama mogago꞉ o꞉lusa꞉nda꞉sen a꞉no꞉, halaido꞉ dowakiyo꞉ abe dimidamabeyo꞉? A꞉la꞉fo꞉ko꞉lo꞉ gilo꞉ to hala sa꞉lab a꞉no꞉, gilo꞉ tiliwida꞉sen kalu iliyo꞉ to a꞉no꞉ hendelemaka꞉ a꞉lakiyo꞉, gimo꞉wo꞉ widakigab. ");
INSERT INTO bco_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ko꞉sega niyo꞉ Godeya꞉ halaido꞉wa꞉ mama mogago꞉wo꞉ a꞉na o꞉luso꞉no꞉lalega, Godeya꞉lo꞉ bo꞉fo꞉mela꞉no꞉ ho꞉leno꞉ o꞉ma fa꞉la꞉dowo꞉ ko꞉lo꞉lab a꞉la꞉li widakigab. ");
INSERT INTO bco_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Kalu halaido꞉ nowo꞉ ene buban kelego꞉ a꞉no꞉ dia꞉sa꞉ga꞉, ene ayo꞉ dinafa yasi dowo꞉lalega, a elo꞉ a꞉no꞉ o꞉li dofo꞉mela꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kalu wema꞉yo꞉ buban kelego꞉ enedo꞉ a꞉no꞉ ko꞉lo꞉ tili asulufo꞉lab. Ko꞉sega kalu halaido꞉lelo꞉ a꞉lab noma꞉yo꞉ elo꞉wa fa꞉la꞉dowa꞉sa꞉ga꞉, e o꞉lia꞉ buba꞉la꞉ga꞉ tinialega, tiniab kalu a꞉ma꞉yo꞉ buban kelego꞉ elo꞉ a꞉no꞉ afale dia꞉b a꞉la꞉ta꞉ga꞉, ayamilo꞉ kelego꞉ delen a꞉no꞉lo꞉ afale dia꞉ha꞉na꞉sa꞉ga꞉ sagama꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kaluka꞉isale abeyo꞉ ne o꞉lia꞉yo꞉ mo꞉ege dowab a꞉no꞉, ne o꞉lia꞉ gis dowakigab. Kaluka꞉isale abeyo꞉ kaluka꞉isale noldo꞉ mo꞉kegene alita꞉lab a꞉ma꞉yo꞉, kaluka꞉isale a꞉no꞉ ko꞉lo꞉ o꞉luga꞉felakigab.” ");
INSERT INTO bco_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","25","Ya꞉su eyo꞉ to heb a꞉kudu sa꞉lakiyo꞉ a꞉la꞉sio꞉, “Mama mogago꞉wo꞉ kalu amilo꞉ elen a꞉no꞉ handalota꞉ga꞉ ha꞉nakiyo꞉, mama mogago꞉ a꞉no꞉ elo꞉ ha꞉salo꞉ mesa꞉no꞉ hen a꞉no꞉ kedaki, kalaleli hena sia꞉len. Ko꞉sega elo꞉ mesa꞉no꞉ hen nafa nowo꞉ mo꞉ba꞉dalikiyo꞉, eyo꞉ a꞉la꞉sa꞉ma꞉ib, ‘A nelo꞉ tamin amilo꞉ sen a꞉na a꞉ma꞉la꞉ ha꞉na꞉nigo꞉l.’ A꞉la꞉sa꞉la꞉sa꞉ga꞉yo꞉ e a꞉ma꞉la꞉ ya꞉ga꞉ ba꞉ba꞉ amio꞉, a a꞉no꞉ tabe alitaki, momade alifo꞉labiki ba꞉ba꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","A꞉la꞉fo꞉ko꞉lo꞉ eyo꞉ ba꞉da꞉sa꞉ga꞉yo꞉, man mogago꞉lo꞉ dimidakilo꞉ tinia꞉sen mama mogago꞉ doma꞉la꞉fo꞉ nolo꞉ tililia꞉sa꞉ga꞉, iyo꞉ tambo a a꞉na mesa꞉ni tiane. Tamin amio꞉ kalu a꞉no꞉ hida꞉yo꞉wo꞉ dowo꞉ ko꞉sega o꞉g a꞉namio꞉ hida꞉yo꞉wo꞉ mada alande dowab.” ");
INSERT INTO bco_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ya꞉su eyo꞉ to a꞉no꞉ sa꞉la꞉labikiyo꞉, kegeo꞉ usamilo꞉ ga imilig noma꞉yo꞉ Ya꞉sumo꞉wo꞉ ho꞉le sa꞉laki a꞉la꞉sio꞉, “Go꞉ gelo꞉ sa꞉la꞉lia꞉sa꞉ga꞉lo꞉ bolo꞉ me o꞉mo꞉wo꞉ Gode eyo꞉ sagale alifa꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","A꞉la꞉sio꞉ ko꞉sega Ya꞉su eyo꞉ a꞉ma꞉la꞉ sa꞉laki, “Kaluka꞉isale abeyo꞉ Godeya꞉ towo꞉ da꞉da꞉sa꞉ga꞉ kudu ha꞉na꞉lab o꞉mo꞉wo꞉ Gode eyo꞉ alan sagale alifa꞉ib” a꞉la꞉sio꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Kaluka꞉isale modo꞉wo꞉ Ya꞉sulo꞉wa o꞉ya꞉sia꞉labiki, Ya꞉su eyo꞉ imo꞉wo꞉ a꞉la꞉sio꞉, “Ho꞉len wenamilo꞉ kaluka꞉isale sab we mada mogago꞉le elen. Iliyo꞉ ne Godelo꞉wa a꞉la꞉ta꞉ga꞉ mio꞉lo꞉b a꞉la꞉ ele ba꞉ba꞉nikiyo꞉, niyo꞉ molo ha꞉na꞉no꞉wo꞉ dimidama꞉ki asulab. Ko꞉sega imo꞉wo꞉ ele ba꞉ba꞉no꞉ nowo꞉ mo꞉widaki, Yona elo꞉ dimido꞉ a꞉no꞉ko꞉ asuluma꞉ki walama꞉no꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Yona elo꞉ amio꞉ fa꞉la꞉dowo꞉ a꞉no꞉, Ninifa kaluka꞉isaleya꞉yo꞉ e hendele Godeya꞉ iliga꞉fo꞉lo꞉b a꞉la꞉ ele bo꞉ba꞉ki a꞉na dimido꞉. A꞉la꞉ta꞉ga꞉ o꞉g wenamio꞉, Kalule Dowo꞉ ne amilo꞉ fa꞉la꞉doma꞉nigab a꞉no꞉, kaluka꞉isale o꞉g wenamilo꞉ a꞉lab a꞉ma꞉yo꞉ ne Godeya꞉ iliga꞉fo꞉lo꞉b a꞉la꞉ ele bo꞉ba꞉ki fa꞉la꞉doma꞉nigab. ");
INSERT INTO bco_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Godeya꞉lo꞉ henfelo꞉ kaluka꞉isalelo꞉ mo꞉walilima꞉no꞉ ho꞉len a꞉namio꞉, Seba hen amilo꞉ misa꞉ ka꞉isale e gi o꞉lia꞉ kagafo꞉liki, gililo꞉ hala dimido꞉ a꞉no꞉ eyo꞉ kalaba walama꞉ib. Mo꞉wo꞉ mo꞉luwo꞉ e Solomona꞉ ene asulo꞉ nafale a꞉no꞉ da꞉ba꞉no꞉ yakiyo꞉, heno꞉ ko꞉na꞉ a꞉la꞉ta꞉ga꞉ mio꞉. A꞉la꞉ta꞉ga꞉ Solomona꞉ asulo꞉lo꞉ tinio꞉ kalu nowo꞉ o꞉go꞉ wena sab ko꞉sega gio꞉ e mo꞉fanda ba꞉dab. ");
INSERT INTO bco_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Godeya꞉lo꞉ henfelo꞉ kaluka꞉isale mo꞉walilima꞉no꞉ ho꞉len a꞉namio꞉, Ninifa kalu iyo꞉ gi o꞉lia꞉ kagafo꞉liki, gililo꞉ hala dimido꞉ a꞉no꞉ iliyo꞉ kalaba fanda sa꞉ma꞉ib. Mo꞉wo꞉ Yona eyo꞉ kaluka꞉isalemo꞉wo꞉ wida꞉labikiyo꞉, ili asulo꞉wo꞉ nodolo꞉. O꞉go꞉ gio꞉ bo꞉ba! Yona elo꞉ tinio꞉ kalu nowo꞉ o꞉go꞉ wena sab.” Ya꞉su eyo꞉ a꞉la꞉wido꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","A꞉la꞉ta꞉ga꞉ Ya꞉su eyo꞉ towo꞉ a꞉la꞉sio꞉, “Kaluka꞉isaleya꞉yo꞉ nafayo꞉ do꞉lia꞉ga꞉yo꞉ wo꞉no꞉lebo꞉ mo꞉dia꞉tan. A꞉la꞉ta꞉ga꞉ nafa a꞉no꞉ fafo usamio꞉ mo꞉go꞉lu alitan. A꞉la꞉bo꞉ mo꞉gan ko꞉lo꞉ nafayo꞉ do꞉lia꞉ga꞉yo꞉, kalu a usamilo꞉ yab i a꞉no꞉ ho꞉leno꞉ bo꞉ba꞉ki, kalaba iwalu dehele alitan. ");
INSERT INTO bco_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Gi siko, do꞉mo꞉wa꞉ ho꞉len ko꞉lo꞉lab. Si gilo꞉wo꞉ nafa dowalega, ho꞉lena꞉yo꞉ gi do꞉mo꞉wo꞉ tambo wa꞉lifo꞉lab. Ko꞉sega si gilo꞉wo꞉ mogago꞉ dowalega, ge do꞉mo꞉wo꞉ tambo sololiab. ");
INSERT INTO bco_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Giyo꞉ ho꞉len ta꞉liso꞉l a꞉la꞉liki, ta꞉lisab amio꞉ sololiyo꞉ ko꞉lo꞉ a꞉ta꞉lisena ba꞉dabena꞉ki, dinafa asululia꞉bi. ");
INSERT INTO bco_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","A꞉la꞉fo꞉ko꞉lo꞉ gi amio꞉ sololi heb nowo꞉ aundo꞉ma dofo꞉liki, ho꞉leno꞉ gi mela꞉no꞉ usamio꞉ tambo wa꞉lifo꞉lalega, nafa ho꞉len so꞉so꞉lesodo꞉ o꞉leo꞉ngo꞉wo꞉, ge amio꞉ ililitakiyo꞉, sololiyo꞉ ge amio꞉ mo꞉doma꞉ib.” ");
INSERT INTO bco_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ya꞉su eyo꞉ towo꞉ wida꞉sa꞉ga꞉ eletabikiyo꞉, Fa꞉lisi kalu noma꞉yo꞉ e o꞉lia꞉yo꞉ ma꞉no꞉ ma꞉ni mena꞉ki sio꞉ ko꞉lo꞉, Ya꞉suwo꞉ a a꞉na tina꞉sa꞉ga꞉ ma꞉no꞉ ma꞉ni asifo꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ya꞉suwa꞉ ene dagiyo꞉ mo꞉to꞉go꞉do꞉ka ma꞉no꞉wo꞉ a꞉na nabiyo꞉, Fa꞉lisi kalu eyo꞉ a꞉no꞉ ba꞉da꞉ga꞉yo꞉ modaki kele asulo꞉. ");
INSERT INTO bco_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","A꞉la꞉go꞉ko꞉lo꞉ Ya꞉su eyo꞉ emo꞉wo꞉ a꞉la꞉sio꞉, “Fa꞉lisi kalu gio꞉, kab o꞉lia꞉ disi o꞉lia꞉yo꞉ ha꞉la꞉ amilo꞉ ka to꞉go꞉da꞉sen o꞉ngo꞉ dowo꞉ ko꞉sega, gili asulo꞉ usamilo꞉ kelego꞉ noma꞉lo꞉ asu sa꞉la꞉lan man o꞉lia꞉ man mogago꞉le dimidan o꞉lia꞉yo꞉ wa꞉lifo꞉ ko꞉lo꞉lab. ");
INSERT INTO bco_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Gio꞉ babale dowo꞉ kalu! Gode eyo꞉ ha꞉la꞉ amilo꞉ da꞉lab a꞉no꞉ dimidaki, a꞉la꞉ta꞉ga꞉ us amio꞉lo꞉ eka dimido꞉. Gio꞉ a꞉no꞉ mo꞉asulaba꞉le? ");
INSERT INTO bco_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Giliyo꞉ kelego꞉ disi usamilo꞉ da꞉lab a꞉no꞉ wa꞉feyo꞉ kaluka꞉isalemo꞉ dimia꞉bi. A꞉la꞉galikiyo꞉ Godeya꞉ siwa꞉l amio꞉ gi do꞉mo꞉wo꞉ tambo go꞉go꞉do꞉ doma꞉ib. ");
INSERT INTO bco_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Wai! Fa꞉lisi kalu gilo꞉ amio꞉ hida꞉yo꞉ alano꞉ fa꞉la꞉doma꞉ib. Giliyo꞉ siabulu fo꞉g ha꞉lu nolo꞉ kililia꞉sa꞉ga꞉yo꞉, molela꞉su diab a꞉no꞉ dinafa aloba꞉da꞉sa꞉ga꞉, heb imilise nowo꞉ Godemo꞉ dimian. Ko꞉sega giliyo꞉ man digalo꞉wo꞉ kalu nolbo꞉wo꞉ mo꞉dimidaki, a꞉la꞉ta꞉ga꞉ Gode asulan man a꞉no꞉lia꞉yo꞉ ka ta꞉ta꞉sen. Giliyo꞉ ele saefa꞉ nol