﻿USE sofia;
DROP TABLE IF EXISTS sofia.bch_vpl;
CREATE TABLE bch_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bch_vpl WRITE;
INSERT INTO bch_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Mugaeai mugaeai tau, Deo ikado bubur ga tano ga iuot. ");
INSERT INTO bch_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Be tano ianun eta mao. Ienono sapaean. Tibur toa ngada oa dodom, be eau kekelen. Be Deo Itautau Tutui iroro gadae ngan eau igogo. ");
INSERT INTO bch_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Idio ta Deo ikeo, “Manta taranga iuot.” Tota taranga iuot. ");
INSERT INTO bch_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Deo igera mambe taranga eiua kemi. Ta idol taranga idio iadag, be dodom idio iadag. ");
INSERT INTO bch_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Deo iuato taranga eine “ado,” be iuato dodom eine “bong.” Io, bong ila, be gaisala iuot. Eine ado ede. ");
INSERT INTO bch_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Ga kus ta Deo ikeo, “Kalakalanga ede manta iuot ta ipoga eau ga idio ngan tibur rua.” ");
INSERT INTO bch_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Io, kalakalanga tota iuot. Deo ikado kalakalanga toa oa ta ipoga eau gadae ga eau gadio ngan kalakalanga. ");
INSERT INTO bch_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Deo iuato kalakalanga toa oa “mariamba.” Io, bong ila, be gaisala iuot. Eine ado rua aea. ");
INSERT INTO bch_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Ga kus ta Deo ikeo, “Eau ienono gadio ngan mariamba, manta ila iluplup ngan tibur kelede, ta tibur mamasa iuot.” Io, tota iuot. ");
INSERT INTO bch_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Deo iuato tibur mamasa eine “tano.” Be eau toa ila iluplup ngan tibur kelede, iuato “tad.” Ta Deo igera gid danga toa oa eine kemi. ");
INSERT INTO bch_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ga kus ta Deo ikeo, “Manta tano ipapot gid abei ga gilgilnga ga annga imata ede ga ede toman ngan ipuapua. Ta gid abei kelede kelede itautau ga iuot toman ngan ipuapua.” Io, tota iuot. ");
INSERT INTO bch_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tano ipapot gid abei ga gilgilnga ga annga imata ede ga ede toman ngan ipuapua. Ga gid abei kelede kelede itautau iuot toman ngan ipuapua. Deo igera gid danga toa oa eine kemi. ");
INSERT INTO bch_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Io, bong ila, be gaisala iuot. Eine ado tol aea. ");
INSERT INTO bch_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Ga kus ta Deo ikeo, “Gid taranga manta titara mariambai ta tikado bong ila ga kus ta ado inasi, ta timan kilala ngan gid rai ga taun ga ado. ");
INSERT INTO bch_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Gid taranga toa oa ga ienono mariambai ta titara ga isulug tanoeai.” Io, tota iuot. ");
INSERT INTO bch_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Deo ikado taranga kapeipei rua. Taranga kapei eine ngan itara ado, be kakauede ngan itara bong. Ga ikado gid gigima pade. ");
INSERT INTO bch_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Ta idol gid taranga toa oa mariambai ta titara ga isulug tanoeai ");
INSERT INTO bch_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ado ga ado ga bong ga bong. Ga tikado tibur meremere iadag ga tibur dodom iadag. Deo igera gid danga toa oa eine kemi. ");
INSERT INTO bch_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Io, bong ila, be gaisala iuot. Eine ado pange aea. ");
INSERT INTO bch_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Ga kus ta Deo ikeo, “Tad manta iuon ngan gid masilau imata ede ga ede matad bibita. Ga gid man pade manta tiuot ga tiroro alele mariambai gadae ngan tano.” ");
INSERT INTO bch_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tota Deo ikado gid masilau kapeipei ga gid masilau padengada tad aea ga eau aea ga tiuot ta tilalala alele tadiai ga eauiai. Ga ikado gid man imata ede ga ede. Deo igera gid danga toa oa eine kemi. ");
INSERT INTO bch_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Idio ta Deo ikado posanga kemi ngan pamatuanga gid ta ikeo, “Gimi masilau tad aea, manta apupulou ga aot busa ta aparangrang tibur toa ngada ne tadiai. Be gimi man, manta aot busa tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Io, bong ila, be gaisala iuot. Eine ado lima aea. ");
INSERT INTO bch_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Ga kus ta Deo ikeo, “Manta tano ipapot gid masilau tibur aea imata ede ga ede matad bibita, ta gid masilau matad mud ga matad saksak, kapeipei ga gereirei tiuot.” Io, tota tiuot. ");
INSERT INTO bch_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Deo ikado gid masilau tibur aea imata ede ga ede, edengada matad mud, padengada matad saksak, kapeipei ga gereirei. Deo igera gid danga toa oa eine kemi. ");
INSERT INTO bch_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Ga kus ta Deo ikeo, “Eine takado eababa ga tiuot mambe gita, ta matad lalaede mambe gita. Ta tadol gid ga timariala ngan tano ga ngan gid ia ga gid man ga gid masilau tibur aea kapeipei ga gereirei ga gid danga toa ngada ne tilalala alele tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tota Deo ikado gid eababa ga tiuot mambe ei. Inasi ei ianun ta ikado gid ga tiuot. Ikado gid ga tiuot arangaranga ga taine. ");
INSERT INTO bch_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Idio ta Deo ikado posanga kemi ngan pamatuanga gid ta ikeo, “Gimi manta apupulou ga aot busa ta aparangrang tibur toa ngada ne tanoeai ta amariala ngan. Manta gimi amadid ga amugamuga ngan gid ia ga man ga masilau tibur aea kapeipei ga gereirei toa ngada ne, ta tidio bagemiai.” ");
INSERT INTO bch_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ga kus ta Deo ikeo, “Ega, gau nabada gid abei ga gilgilnga tanoeai aea imata ede ga ede toman ngan itautau ga ipuapua pagimi, ta gid danga toa ne ga iman gimi ami annga. ");
INSERT INTO bch_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Be nabada gid abei ilaun ga gilgilnga padengada tibur aea iman annga togid masilau tibur aea kapeipei ga gereirei ga togid man ga togid danga toa ngada ne matad bibita.” Io, tota iuot. ");
INSERT INTO bch_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Deo igera gid danga toa ngada oa ikado ga iuot eine kemi tau. Io, bong ila, be gaisala iuot. Eine ado lima ga ede aea. ");
INSERT INTO bch_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Toa bedaoa ta Deo ipasala ele naurata ngan bubur ga tano ga danga toa ngada ne ienono ngan. ");
INSERT INTO bch_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Be ngan ado lima ga rua aea, Deo igera naurata toa ngada oa ipasala ga kus, ta iarai ngan ado toaiua. ");
INSERT INTO bch_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tota Deo ikado posanga kemi ngan pamatuanga ado lima ga rua aea ta idol ele ul ngan ado toa oa. Ikado toa bedaoa ngansa ipasala ele naurata toa ngada oa ga kus, ta iarai ngan ado toaiua. ");
INSERT INTO bch_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Ninipunga ga oaine eine ngan bubur ga tano led otnga ngan ado toaiua Deo ikado gid ga tiuot. Ngan ado toa Maron Deo ikado bubur ga tano ga iuot, ");
INSERT INTO bch_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","gid abei ga gilgilnga tibur aea tipara ga tidae tanoeai maitne. Eine ngansa Maron Deo ikado aoara ga itap tanoeai maitne, be eaba eta imamado ngan kadonga naurata dadangai mao. ");
INSERT INTO bch_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Be gid lelele tiuot tano iloleai ta tipaburisinga tibur toa ngada oa tano igogoeai. ");
INSERT INTO bch_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Idio ta Maron Deo ikapo tano aea kangkanga ga iuot mambe eababa. Ta iuso iaoa uru mata bibita aea ga idudunga eaba inudiai. Tota eaba toa oa imata bibita. ");
INSERT INTO bch_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Be Maron Deo ikado dadanga ede ngan tibur Iden toa ado ele parangai. Toa eoa idol eaba toa ikado. ");
INSERT INTO bch_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Be Maron Deo ikado tano ga ipapot gid abei imata ede ga ede toa tautaudid kemikemi ngan eaneannga ga matad kemikemi. Be rabu ngan dadanga toa oa, abei rua timadmadid. Ede eine abei madonga kemi aea, be ede pade eine abei ibada oatainga ngan gid danga kemikemi ga danga papaeamao. ");
INSERT INTO bch_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Be eau ede iuot ngan tibur Iden ta ipaburisinga dadanga toa oa. Toa iulngai oa imapoga ga iuot eau pange. ");
INSERT INTO bch_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Eau toa iaoa ede ieda Pison. Eine ilele ga ibaliu ngan tibur kapei ieda Avila. Ngan tibur toa oa gol ienono. ");
INSERT INTO bch_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Be gol toa oa kemikemi. Delium ga pat oniks ienono toa eoa pade. ");
INSERT INTO bch_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Be eau toa iaoa ede pade ieda Gion. Eine ilele ga ibaliu ngan tibur kapei ieda Kus. ");
INSERT INTO bch_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Be eau toa iaoa tol aea ieda Taigris. Eine ilele ngan tibur kapei Asiria isaleai toa ado ele parangai. Be eau toa iaoa pange aea ieda Iupretis. ");
INSERT INTO bch_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Idio ta Maron Deo ibada eaba toa oa ta idol ei ga idio imado ngan dadanga Iden, ta ikado naurata ngan ga imariala ngan. ");
INSERT INTO bch_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Idio ta Maron Deo irenren matua pan ta ikeo, “Eao rangrang ngan ean abei toa ngada ne itautau, ");
INSERT INTO bch_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","be abei toa ibada oatainga ngan gid danga kemikemi ga danga papaeamao, eao rangrang ngan ean mao. Ngansa oangga ean, eao ga mate ngan ado toaiua.” ");
INSERT INTO bch_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Idio ta Maron Deo ikeo, “Eaba toa ne ei kekelen imamado, eine kemi mao. Gau ga nakado iarea eta ngan luanga ei.” ");
INSERT INTO bch_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Be mugaeai Maron Deo ikapo tano ta ikado gid masilau tibur aea ga gid man toa ngada oa ga tiuot. Ta ital gid ga tila pan eaba toa oa, ta Deo iuangga igera ei iuatoato gid kelede kelede edad. Tota iuatoato gid masilau mud ga masilau saksak ga gid man toa ngada oa edad. Ta saoa edaeda eaba toa oa iuatoato ngan gid, eiua gid edad. Be Adam igera iarea eta ngan luanga ei mao. ");
INSERT INTO bch_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Idio ta Maron Deo ikado ga eaba toa oa imate ngan enonga. Ei idio ieno, ta Deo inusi ituatua ede ikarkareai. Ga kus ta ipatoi mulian itin kukul. ");
INSERT INTO bch_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Ta Maron Deo ikado taine ede ngan eaba ikarkare ituatua toa ibada. Ta ital ei ga ila pan. ");
INSERT INTO bch_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Eaba igera taine toa oa ta ikeo, “Ta! Patautene gau areag! Ei ituatua iuot ngan gau tuatuag. Be imedameda iuot ngan gau medamedag. Gau ga naoato ei ‘taine,’ ngansa Deo ikado ei ga iuot ngan gau tuatuag.” ");
INSERT INTO bch_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ngan ipu toaine kadonga ga oaine iuotot: Eaba ga itnan itama ga itna ta ila ilup toman ngan iadaoa, ta eine mambe gisirua tinid iuot kelede. ");
INSERT INTO bch_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Be eaba toa oa ga iadaoa tibangabanga, be maeamaea gid mao. ");
INSERT INTO bch_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Maron Deo ikado gid masilau tibur aea toa ngada ne ga tiuot, be eta ngan gid ele oatainga kapei ngan kadonga parumrumnga mambe mota mao. Idio ta mota ibeta taine bedane, “Tautaunga Deo iaoa ikarara gimi ngan eannga abei itautau toa ngada ne dadangai na?” ");
INSERT INTO bch_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Ta taine ikeo pan mota bedane, “Mao. Deo ilongo ngan gai aean abei itautau toa ngada ne dadangai. ");
INSERT INTO bch_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Be iaoa ikarara gai ngan abei kelede mon imadmadid rabu ngan dadanga. Deo ikeo ga gai aean mao ga akisi mao pade, ngan kado ta amate.” ");
INSERT INTO bch_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Be mota ikeo pan taine, “Irangrang ngan gimi amate mao. ");
INSERT INTO bch_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ngansa Deo iuatai, oangga gimirua aean abei toa ne itautau, eine matami ga iualai ta aot mambe ei, ta aoatai ngan danga kemikemi ga danga papaeamao.” ");
INSERT INTO bch_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Io, taine igera abei toa oa itautau imata kemi ngan eaneannga ta ingale. Ta ikeo iloleai bedane, “Kemi ngan naean abei toa ne itautau ta nabada oatainga kemikemi imata ede ga ede.” Tota ibada ta ian. Be ibada ilia ga ila pan iadaoa toa imamado toman ngan ei, ta ei pade ian. ");
INSERT INTO bch_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Io, tota gisirua matad iualai ta tiuatai mambe tibangabanga. Tota tilolodi abei fik ilaun ta tipit ga iman ad malo. ");
INSERT INTO bch_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Idio ta del lailai aea iuot ta gisirua tilongo Maron Deo ilalala dadanga iloleai ga inam. Tota eaba toa oa toman ngan iadaoa timumul ngan Maron Deo imata rabu ngan gid abei dadangai. ");
INSERT INTO bch_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Be Maron Deo ibaba ga ila pan eaba toa oa ta ikeo, “Eao sida?” ");
INSERT INTO bch_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ta ikoli ele posanga bedane, “Gau nalongo eao lalala dadanga iloleai, ta namataud ga namumul, ngansa gau nabangabanga.” ");
INSERT INTO bch_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Ta Deo ibeta ei, “Sai ikeo pago ngan eao bangabanga? Kado eao ean abei itautau toa aoag ikarara go ngan.” ");
INSERT INTO bch_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ta eaba toa oa ikeo, “Taine toa eao bada pagau ne, ei ibada abei itautau toa ne pagau ta naean.” ");
INSERT INTO bch_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Ta Maron Deo ibeta taine bedane, “Eao lem kadonga toa ne madongan?” Ta taine ikeo, “Mota ipakaka gau ta naean.” ");
INSERT INTO bch_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tota Maron Deo ikeo pan mota bedane, “Eao kado kadonga paeamao toa ne, tota “Rabu ngan gid masilau saksak ga masilau mud toa ngada oa, eao kekelego am panasnga paeamao ga paeamao tau. Eao ga rarai ngan gogom ga ean tano aea kangkanga ga ila irangrang ngan lem madonga tanoeai kus. ");
INSERT INTO bch_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Gau nakado ga eao man taine aea isat, ta ei iman eao am isat. Ga eao lem gergeu timan ariapolpol ngan ei ele gergeu. Ede ngan gid ga irau laboram, be eao ga rau iae igub.” ");
INSERT INTO bch_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Be Deo ikeo pan taine bedane, “Ieieinga toa eao naman ngan poponga gergeu, gau ga nakado ga ila kapei ga kapei tau. Eao ga naman ieieinga kapei ngan poponga gergeu. Somisomi lolom ga ila pan adaoam, be eao ga dio ei ibageai.” ");
INSERT INTO bch_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Be Deo ikeo pan Adam bedane, “Eao longo adaoam ilinge ta ean abei itautau toa aoag ikarara gimirua ngan. “Ngan ipu toaine ta napaeabu ngan tano, ta gid annga ga idae kemi mao. Ngansa eao longo lingeg mao. Eao ga naman ieieinga ngan lem naurata kulupu dadangai ga ila irangrang ngan lem madonga tanoeai kus. ");
INSERT INTO bch_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Be gid oaroaro aea gigi ga gid purup papaeamao ga tiparapara ga tidae ta tiluga am dadanga. Ta eao ga la ilo am annga tibur iloleai. ");
INSERT INTO bch_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Eao ga kado naurata kapei ngan badanga am annga, be kasiksiknga ga iuot matameai. Eao ga kakado toa bedaoa ga irangrang ngan lem matenga ta luago mulian tanoeai. Ngansa gau nakado go ga ot ngan tano aea kangkanga, ta eao ga luago mulian tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Idio ta eaba iuato iadaoa Eva, ngansa muriai ei iuot panua matad bibita toa ngada ne tnad. ");
INSERT INTO bch_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Ga kus ta Maron Deo ibada masilau tibur aea tinid kukul ga iman Adam ga iadaoa ad malo ta ipit ngan gisirua. ");
INSERT INTO bch_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Idio ta Maron Deo ikeo, “Ega, labone gid eababa tibada oatainga ngan danga kemikemi ga danga papaeamao ta tiuot mambe gita. Be irangrang ngan talongean gid ta tila boloma ngan abei madonga kemi aea mao. Ngan kado ta tian itautau ta tibada madonga kemi somisomi.” ");
INSERT INTO bch_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tota Maron Deo isere ei ga iadaoa ngan dadanga Iden, ta isula ei ga ila ikado naurata ngan tano toa Deo ikado ei ga iuot ngan. ");
INSERT INTO bch_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Io, isere gisirua ga kus ta idol gid kerubim ta timariala ngan dadanga Iden ngan ado ele parangai. Be toa eoa idol didi kapei paraunga aea pade. Didi toa oa aea dinga irarabal imatai be ipulpul ei alele. Ta ipakala edap ila ngan abei madonga kemi aea. ");
INSERT INTO bch_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Idio ta eaba toa oa ieno toman ngan iadaoa Eva, ta iapa ta ipopo gergeu aranga. Ta Eva ikeo, “Maron ilua gau ta nabada gergeu aranga.” Ta iuato ieda Kain. ");
INSERT INTO bch_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ga kus ta ipopo itar kakau Abel pade. Idio ta gisirua tidae kapeipei ta tikakado led naurata. Abel imariala ngan sipsip, be Kain ikakado dadanga. ");
INSERT INTO bch_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Idio ga muriai, ta gisirua tikado led tenainga ga ila pan Maron. Kain itenai ele annga edengada dadanga aea. ");
INSERT INTO bch_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Be Abel ipamate ele sipsip lautabtabe edengada toa luad kapeipei ta timan ele tenainga. Maron itin igelgel ngan Abel ga ele tenainga. ");
INSERT INTO bch_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Be itin igelgel ngan Kain ga ele tenainga mao. Tota Kain ilolo bake ta imata imirmirianga. ");
INSERT INTO bch_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Ta Maron ikeo pan Kain, “Eao kamado ga lolom bake ga matam imirmirianga? ");
INSERT INTO bch_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Oangga eao kado kadonga kemi, eine ga tinim igelgel, ngansa gau ga nakim lem tenainga. Be oangga eao kado kadonga kemi mao, eine kadonga sat ienono lem atama iaoai ta iuangga ipaeabu ngan go. Kadonga sat ikim tau ngan iasal go, be eao manta uram ta easal kadonga sat.” ");
INSERT INTO bch_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Idio ta Kain ikeo pan itar kakau Abel ngan gisirua tila tiburiai. Gisirua tilalala tiburiai, be Kain irau itar kakau Abel ga imate. ");
INSERT INTO bch_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Ta Maron ibeta Kain bedane, “Tadim kakau Abel sida?” Ta ikeo, “Gau naoatai mao. Ikamado? Eine gau leg naurata ngan matag ikikisi tadig kakau?” ");
INSERT INTO bch_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Ta ikeo, “Eao kado mado? Tadim kakau ising ilele tanoeai, ta nalongo ising itang ga inam pagau! ");
INSERT INTO bch_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tota gau leg panasnga ngan eao bedane: Eao pamate am kakau ta kado ga tano iun ising. Tota gau ga napakala tano ta irangrang ngan eao kado dadanga pade mao. ");
INSERT INTO bch_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Be oangga kado dadanga, eine nakado ga tano imona mao, ta am annga irangrang ngan idaedae kemi mao. Tota eao ga patpat alele ngan tibur ga tibur.” ");
INSERT INTO bch_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kain ikeo pan Maron bedane, “Gau narangrang ngan ag panasnga toa ne mao. Eine kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Ega, eao keo ga nakado dadanga pade mao, be namado aluai ngan eao. Ta eao keo ga napatpat alele tanoeai. Be namataud. Ngan kado ta panua tiuot pagau ta tirau gau ga namate.” ");
INSERT INTO bch_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Be Maron ikeo pan bedane, “Eine mao. Oangga sai ipamate go, eine ga napanas ei kapei tau irangrang ngan palima ga rua.” Tota Maron idol kilala ede ngan Kain, ta oangga eaba eta iuot pan, eine irangrang ngan ipamate ei mao. ");
INSERT INTO bch_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Idio ta Kain itnan Maron ta ilalala ga ila. Ga kus ta ila imado ngan tibur ede ieda Nod toa ado ele parangai ngan dadanga Iden. ");
INSERT INTO bch_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Idio ta Kain ieno toman ngan iadaoa ta ipopo gergeu aranga ta iuato ieda Enok. Idio ga muriai ta Kain ikado tuanga ede, ta idol inat ieda ga idae ngan tuanga toa oa. ");
INSERT INTO bch_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Ga kus ta Enok iadaoa ipopo gergeu aranga ieda Irat. Be Irat iadaoa ipopo gergeu aranga ieda Meujael. Be Meujael iadaoa ipopo gergeu aranga ieda Metusael. Be Metusael iadaoa ipopo gergeu aranga ieda Lamek. ");
INSERT INTO bch_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamek iuai taine rua. Ede ieda Ada, be ede pade ieda Sila. ");
INSERT INTO bch_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Ada ipopo gergeu aranga ieda Iabal. Gid panua timariala ngan bulmakao ga timamado ngan gid palata, gid tiuatoato Iabal eine tibud. ");
INSERT INTO bch_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Be Iabal itar kakau ieda Iubal. Gid panua tikakado baunga ngan arp ga piloli, gid tiuatoato Iubal eine tibud. ");
INSERT INTO bch_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Be Sila ipopo gergeu aranga ieda Tubalkein. Be Tubalkein ikakado gid danga sisid naurata aea ngan bras ga aen. Be Tubalkein iliu ieda Nama. ");
INSERT INTO bch_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Idio ta Lamek ikeo pagid iadadaoa toa rua oa bedane, “Ada ga Sila, gimirua alongo gau. Gimirua adadaoag alongo leg posanga. Eaba ede itapa gau, be napamate ei. Eaba iriau ede ipoda gau, ta narau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Deo ikeo ga oangga eaba eta ipamate Kain, eine ga ibada panasnga kapei irangrang ngan palima ga rua. Be gau nakeo ga oangga eaba eta ipamate gau, eine ga ibada panasnga kapei irangrang ngan sangalima sangaul rua igegea lima ga rua.” ");
INSERT INTO bch_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Idio ta Adam ieno toman ngan iadaoa pade, ta ipopo gergeu aranga. Ta iadaoa ikeo, “Deo ibada gergeu ede pade ga inam pagau ngan badanga Abel imul. Ngansa Kain irau ei ga imate.” Tota iuato ieda Set. ");
INSERT INTO bch_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Muriai Set iadaoa ipopo gergeu aranga ta iuato ieda Enos. Ngan ado toaiua, gid panua timuga ngan oatoatonga Maron ieda, ta tibaba ga ila pan ngan led raring. ");
INSERT INTO bch_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adam aea titnga ga bedane: Ngan ado toaiua Deo ikado gid eababa ga tiuot, eine ikado ga tiuot mambe ei. ");
INSERT INTO bch_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Ikado gid ga tiuot arangaranga ga taine. Ngan ado toaiua ikado gid ga tiuot, ikado posanga kemi ngan pamatuanga gid ta iuato gid “eababa.” ");
INSERT INTO bch_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adam aea rai buno ede sangaul tol (130), be iadaoa ipopo gergeu aranga ga iuot mambe ei. Ta iuato ieda Set. ");
INSERT INTO bch_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam iadaoa ipopo Set ga kus ta Adam imamado irangrang ngan rai buno lima buno tol (800). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Adam aea rai toa ngada oa iuot buno lima buno pange sangaul tol (930), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Set aea rai buno ede igegea lima (105), be iadaoa ipopo gergeu aranga ieda Enos. ");
INSERT INTO bch_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Set iadaoa ipopo Enos ga kus ta Set imamado irangrang ngan rai buno lima buno tol igegea lima ga rua (807). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Set aea rai toa ngada oa iuot buno lima buno pange sangaul ede igegea rua (912), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos aea rai sangalima sangaul pange, be iadaoa ipopo gergeu aranga ieda Kenan. ");
INSERT INTO bch_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Enos iadaoa ipopo Kenan ga kus ta Enos imamado irangrang ngan rai buno lima buno tol sangaul ede igegea lima (815). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enos aea rai toa ngada oa iuot buno lima buno pange igegea lima (905), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenan aea rai sangalima sangaul rua, be iadaoa ipopo gergeu aranga ieda Maalalel. ");
INSERT INTO bch_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenan iadaoa ipopo Maalalel ga kus ta Kenan imamado irangrang ngan rai buno lima buno tol sangaul pange (840). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenan aea rai toa ngada oa iuot buno lima buno pange sangaul ede (910), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Maalalel aea rai sangalima sangaul ede igegea lima, be iadaoa ipopo gergeu aranga ieda Iaret. ");
INSERT INTO bch_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Maalalel iadaoa ipopo Iaret ga kus ta Maalalel imamado irangrang ngan rai buno lima buno tol sangaul tol (830). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Maalalel aea rai toa ngada oa iuot buno lima buno tol sangalima sangaul pange igegea lima (895), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Iaret aea rai buno ede sangalima sangaul ede igegea rua (162), be iadaoa ipopo gergeu aranga ieda Enok. ");
INSERT INTO bch_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Iaret iadaoa ipopo Enok ga kus ta Iaret imamado irangrang ngan rai buno lima buno tol (800). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Iaret aea rai toa ngada oa iuot buno lima buno pange sangalima sangaul ede igegea rua (962), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Enok aea rai sangalima sangaul ede igegea lima, be iadaoa ipopo gergeu aranga ieda Metusela. ");
INSERT INTO bch_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Enok iadaoa ipopo Metusela ga kus ta Enok ilalala toman ngan Deo irangrang ngan rai buno tol. Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enok aea rai toa ngada oa iuot buno tol sangalima sangaul ede igegea lima (365). ");
INSERT INTO bch_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enok ilalala toman ngan Deo. Be Deo ibada ei ga ila, ta panua tigera ei pade mao. ");
INSERT INTO bch_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Metusela aea rai buno ede sangalima sangaul tol igegea lima ga rua (187), be iadaoa ipopo gergeu aranga ieda Lamek. ");
INSERT INTO bch_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Metusela iadaoa ipopo Lamek ga kus ta Metusela imamado irangrang ngan rai buno lima buno rua sangalima sangaul tol igegea rua (782). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metusela aea rai toa ngada oa iuot buno lima buno pange sangalima sangaul ede igegea lima ga pange (969), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamek aea rai buno ede sangalima sangaul tol igegea rua (182), be iadaoa ipopo gergeu aranga ");
INSERT INTO bch_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","ta iuato ieda Noa. Ngansa Lamek ikeo, “Mugaeai Maron ipanas gita ta ipaeabu ngan tano, ta takakado naurata kulupulupu tau dadangai. Be gergeu toa ne ga iaran gita ngan leda naurata kulupulupu.” ");
INSERT INTO bch_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Lamek iadaoa ipopo Noa ga kus ta Lamek imamado irangrang ngan rai buno lima sangalima sangaul pange igegea lima (595). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Lamek aea rai toa ngada oa iuot buno lima buno rua sangalima sangaul rua igegea lima ga rua (777), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noa aea rai buno lima, be iadaoa ipopo gergeu arangaranga tol: Siem ga Am ga Iapet. ");
INSERT INTO bch_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Idio ta gid eababa tiuot busa tanoeai, be tipopo gid gergeu taine. ");
INSERT INTO bch_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Be gid gergeu arangaranga ton Deo tigera gid eababa led gergeu taine toa matad kemikemi tau. Ta tisiosio gid ngan led kimnga ta tiuaioai gid. ");
INSERT INTO bch_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Idio ta Maron ikeo, “Gau nadol Tautaudig Tutui ga ila idio pagid panua ngan kadonga gid ga matad bibita. Be gid mambe danga sapaean tanoeai aea. Tota irangrang ngan nalongean Tautaudig Tutui ga idio pagid mole tau mao. Eine ga nalongean gid ga timamado irangrang ngan ad rai buno ede sangaul rua mon (120). Ga kus ta timate.” ");
INSERT INTO bch_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Ngan ado toaiua ga muriai ga ila, gid panua led tubnga kapeipei timamado tanoeai. Gid eine gergeu togid taine toa tieno toman ngan gid gergeu arangaranga ton Deo. Gid panua toa oa bebed ga urad kapeipei ngan kadonga naurata imata ede ga ede. Tota mugaeai oalud kapei. ");
INSERT INTO bch_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Be Maron igera kadonga sasat togid panua ngan tibur toa ngada oa iuot paeamao tau. Somisomi ado ga ado matad nanan danga papaeamao ga led kimnga papaeamao mon. ");
INSERT INTO bch_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Tota Maron ipul ilolo ta ikeo ga kemi oangga ikado gid eababa ga tiuot mao. Ta ilolo isat kapei. ");
INSERT INTO bch_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tota Maron ikeo, “Gau ga napamukuru gid panua tanoeai toa mugaeai nakado gid ga tiuot. Eine ga napamukuru gid eababa ga masilau kapeipei ga gereirei ga gid man. Eine ngansa mugaeai nakado gid ga tiuot, be labone napul lolog ta nakeo ga kemi oangga nakado gid ga tiuot mao.” ");
INSERT INTO bch_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Be Maron ilolo marum ngan Noa. ");
INSERT INTO bch_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Noa aea titnga ga bedane: Noa ei eaba tutui. Be rabu ngan gid panua padengada ngan ado toaiua, ei ele idil eta paeamao mao. Noa ilalala toman ngan Deo ta somisomi inasnasi Deo ilinge. ");
INSERT INTO bch_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noa ele gergeu tol, Siem ga Am ga Iapet. ");
INSERT INTO bch_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Be Deo igera panua padengada tanoeai led kadonga papaeamao tau. Ngan tibur toa ngada oa panua tangad balbal ta tipaparau. ");
INSERT INTO bch_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Ei imata inasnasi gid panua tanoeai ad be igera mambe gid eine panua papaeamao, ngansa gid toa ngada oa tisio edap kadonga paeamao aea. ");
INSERT INTO bch_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Tota Deo ikeo pan Noa bedane, “Gau ga napamukuru panua toa ngada ne tanoeai, ngansa tibur toa ngada ne iuon ngan led kadonga sasat ga paraunga sapaean. Ega, gau ga napaeabu ngan tano toa ne, ta gid ga tiduaea. ");
INSERT INTO bch_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tota eao manta bada gid abei goper ta kado lem oaga kapei eta. Eao ga kado bobo etangada iloleai ta sama naraelo gadudunga ga gaot ngan. ");
INSERT INTO bch_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Eao ga kado lem oaga ga bedane: Oaga aea mamarae ga iuot sangalima sangaul rua leoa lima. Be aea babanga ga iuot sangaul ede leoa rua aea mana. Be ipao gadae ga isulug, eine ga iuot leoa lima leoa rua aea mana. ");
INSERT INTO bch_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Eao ga kado aea udud. Be oangga did, kado ga ila tung ngan oaga aea udud mao. Be eao manta tal aea batanga kauteta gadae ngan para ta irangrang ngan oaga ilolo meremere. Be gadudunga, kado aea patanonga tol, ede gadae, ede rabu, be ede pade gadio. Ta kado aea atama ede ikarkareai. ");
INSERT INTO bch_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","“Ega, gau ga nakado oanga kapei ga iuot tanoeai. Eine ga ipaeabu ngan danga toa ngada ne matad bibita ga timate. ");
INSERT INTO bch_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Be gau ga narau posanga toman ngan eao ta loloda kelede. Ta gimirua adaoam ga adudunga oagaeai toman ngan lemi gergeu tol ga adadaoad. ");
INSERT INTO bch_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ta eao ga bada masilau ruangada imata ede ga ede ta tidudunga oagaeai, ede aranga, ede taine. Toa bedaoa ta irangrang ngan timate mao. ");
INSERT INTO bch_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Gid man imata ede ga ede ruangada, ga masilau kapeipei ga gereirei imata ede ga ede ruangada, gid ga tinam pago ta tidudunga oagaeai toman ngan eao ta irangrang ngan timate mao. ");
INSERT INTO bch_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Be eao manta bada annga imata ede ga ede ta nonoi oagaeai, ta iman gid masilau ga man ad ga gimi ami.” ");
INSERT INTO bch_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Io, Noa ikado danga toa ngada oa mambe Deo ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Idio ta Maron ikeo pan Noa bedane, “Rabu ngan panua toa ngada ne tanoeai, gau nagera mambe eao kekelego eaba tutui. Tota eao amingada lem gergeu, gimi toa ngada na adudunga oagaeai. ");
INSERT INTO bch_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Be gid masilau toa nakeo ga timan tenainga aea, nakim eao bada arangaranga lima ga rua ga taine lima ga rua. Be gid masilau toa kemikemi ngan tenainga mao, eao bada ruangada, arangaranga ga taine, ta tidae oagaeai toman ngan eao. ");
INSERT INTO bch_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Be gid man imata ede ga ede, nakim eao bada arangaranga lima ga rua, ga taine lima ga rua pade. Eao kado toa bedaoa ta irangrang ngan timate mao, be muriai ga tiuot busa tanoeai pade. ");
INSERT INTO bch_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Muriai ngan ado lima ga rua, eine ga nakado aoara ga itap tanoeai ga irangrang ngan aea ado ga bong sangaul pange. Ngan aoara toa ne, gau ga napamukuru gid danga toa ngada ne tanoeai toa mugaeai nakado gid ga tiuot.” ");
INSERT INTO bch_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Io, Noa ikado danga toa ngada oa mambe Maron ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Noa aea rai buno lima buno ede (600) be oanga kapei iuot tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Ta Noa ga iadaoa ga ele gergeu toman ngan adadaoad tiaoa ngan oanga kapei ta tidudunga oagaeai. ");
INSERT INTO bch_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Gid masilau toa Deo ikeo ga timan tenainga aea, ga gid masilau kemikemi ngan tenainga mao, ga gid man ga gid masilau gereirei, ");
INSERT INTO bch_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","arangaranga ga taine, tila pan Noa ta tidudunga oagaeai, mambe Deo ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Be ado lima ga rua ila ga kus ta oanga kapei iuot ta irobi tano. ");
INSERT INTO bch_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Ngan rai toa oanga kapei iuot, Noa aea rai buno lima buno ede (600). Be oanga kapei iuot ngan rai toa oa aea taiko rua aea, ngan aea ado sangaul igegea lima ga rua aea. Ngan ado toaiua, tano ipokakai ta eau gadio tanoeai ibeula ga idae. Ga gid baba kapeipei mariambai aoad ipokakai ta eau gadae mariambai ilele ga isulug. ");
INSERT INTO bch_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tota aoara itap ga isulug tanoeai irangrang ngan aea ado ga bong sangaul pange. ");
INSERT INTO bch_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tutui ngan ado toaiua, Noa ga iadaoa ga ele gergeu tol, Siem ga Am ga Iapet, asingada adadaoad tidudunga oagaeai. ");
INSERT INTO bch_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Be gid masilau saksak ga masilau mud kapeipei ga gereirei ga gid man imata ede ga ede, gid toa ngada oa tidudunga oagaeai toman ngan Noa masin. ");
INSERT INTO bch_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Gid masilau toa ngada oa matad bibita, aranga ede ga taine ede, tidudunga toa oagaeai oa, mambe Deo ikeo pan Noa ngan. Ga kus ta Maron isaisai atama ngan gid. ");
INSERT INTO bch_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Oanga toa oa iuotot ga ila irangrang ngan aea ado sangaul pange, be eau iuon ga ilalala ga idae ta isoa oaga kapei ga idae gadae ta imomono. ");
INSERT INTO bch_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Eau isum ga idae kapei tau ta irobi tibur toa ngada oa. Be oaga ipatpat gadae ngan eau igogo. ");
INSERT INTO bch_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Be eau isum ga idae kapei ta irobi gid lusi kapeipei toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Eau ilalala ga idae ta iasal gid lusi laborad ga irangrang mambe leoa pange. ");
INSERT INTO bch_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Gid danga toa ngada oa matad bibita tanoeai timukuru. Gid man ga masilau saksak ga masilau mud kapeipei ga gereirei ga gid eababa pade timukuru ga kus. ");
INSERT INTO bch_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Danga toa ngada oa timamado ngan tano mamasa, tiun eau ga timatemate. ");
INSERT INTO bch_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Deo ipamukuru danga toa ngada oa matad bibita tanoeai. Gid eababa ga gid masilau kapeipei ga gereirei ga gid man tiduaea gid ga kus. Be Noa kekelen toman ngan gid toa oagaeai oa tiduaea mao. ");
INSERT INTO bch_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Oanga kapei toa oa irobi tano ga irangrang ngan aea ado buno ede sangalima (150). ");
INSERT INTO bch_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Idio ta Deo imata nanan Noa ga gid masilau saksak ga masilau mud toa ngada oa oagaeai. Ta ikado rai ga ilado gadae ngan eau igogo. Ta eau kos ga isulug. ");
INSERT INTO bch_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Be eau gadio tanoeai ibeula ga idae pade mao. Be gid baba kapeipei mariambai tila gip, ta aoara itap pade mao. ");
INSERT INTO bch_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Tota eau kos ga kos ga isulug. Eau ilalala ga isulug irangrang ngan aea ado buno ede sangalima (150). ");
INSERT INTO bch_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Be ngan rai toa oa aea taiko lima ga rua, ngan aea ado sangaul ga igegea lima ga rua, Noa ele oaga idae tos ngan lusi ilabora ngan tibur Ararat. ");
INSERT INTO bch_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Eau ilalala ga isulug, be ngan rai toa oa aea taiko sangaul, ngan aea ado imuga ngan taiko toa oa, gid lusi laborad tiuotot. ");
INSERT INTO bch_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Be ado sangaul pange ila ga kus ta Noa ibage ipapa ele oaga aea atama kakauede ");
INSERT INTO bch_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","ta ibada man akrok ede ta itado ei ta iroro ga ila. Man akrok toa oa iroro alele ga ila ga inam. Ikakado toa bedaoa ga ila irangrang ngan eau isulug ga tano imamasa. ");
INSERT INTO bch_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Be Noa itado man barur ede ta iroro ga ila, ngansa iuangga iuatai kemi, eau isulug ga tano imamasa, mao maitne. ");
INSERT INTO bch_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Be man barur toa oa iloilo tibur kemi earainga aea ga mao. Ngansa eau irobi tano maitne. Tota iluai mulian pan Noa oagaeai. Noa idol ibage ga iuot, ta man barur itamaroro ga idae ibageai, ta ibada ei ga idudunga mulian. ");
INSERT INTO bch_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Be isanga ado lima ga rua ga kus ta itado man barur toa oa ta iroro ga ila pade. ");
INSERT INTO bch_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Idio ga lailai sagogogo ta man barur iluai mulian. Be iaoai, Noa igera abei oliv ilaun pau ede ienono. Tota Noa iuatai mambe eau ilalala ga isulug tanoeai na. ");
INSERT INTO bch_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Isanga ado lima ga rua ga kus ta isula man barur toa oa ga ila pade, be iluai mulian mao. ");
INSERT INTO bch_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Tano imamasa ngan Noa aea rai buno lima buno ede igegea ede (601). Tano ikado bedaoa ngan taiko imuga ngan rai toa oa, ngan ado imuga ngan taiko toa oa. Tota Noa irepe oaga aea usi idanga tede, ta igera tano iuangga imamasa. ");
INSERT INTO bch_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Be ngan rai toa oa aea taiko rua, ngan aea ado sangaul rua igegea lima ga rua, tano toa ngada oa imamasa. ");
INSERT INTO bch_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Idio ta Deo ikeo pan Noa bedane, ");
INSERT INTO bch_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Io, tota atnan oaga ta asulug tanoeai, eao ga adaoam ga lem gergeu asingada adadaoad. ");
INSERT INTO bch_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Bada gid masilau toa ngada oa ga tisulug toman ngan eao. Gid man ga gid masilau kapeipei ga gereirei, eao bada gid ga tisulug ta tibilin ga tipupulou ta tipakaranga tano toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tota Noa iuot toman ngan iadaoa ga ele gergeu ga adadaoad. ");
INSERT INTO bch_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Be gid masilau kapeipei ga gereirei ga gid man ga gid danga matad bibita toa ngada oa, tiluplup ngan gid iaoa kelede kelede togid ta tiuot ga tisulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Idio ta Noa ikado popou tenainga aea ngan kadonga tenainga ga ila pan Maron. Ta ibada gid masilau ga gid man idanga ede toa Deo ikeo ga timan tenainga aea, ta idol gid ga tidae dingaeai ta dinga inono ga timomout ga kus. Ta iman ele tenainga ga ila pan. ");
INSERT INTO bch_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Maron inud tenainga toa oa iuad kemi ta ikeo iloleai bedane, “Irangrang ngan napaeabu ngan tano pade mao, ngan panasnga gid panua ngan led kadonga sasat. Tautaunga, gid gereirei maitne ga tidae kapeipei, be somisomi matad nanan danga papaeamao ga led kimnga papaeamao mon. Be irangrang ngan napamukuru gid danga matad bibita toa ngada ne pade mao, mambe patautene nakado. ");
INSERT INTO bch_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Oangga tano ienono maitne, earumnga ga kulenga gid annga ga iuotot, be tibur memednga ga oanaoana ga iuotot, be ado aea sau ga aoara lolo ga iuotot, be ado ga bong pade ga iuotot ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Idio ta Deo ikado posanga kemi ngan pamatuanga Noa ga ele gergeu ta ikeo, “Gimi manta apupulou ga aot busa ta aparangrang tibur toa ngada ne tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Gid masilau tibur aea kapeipei ga gereirei ga gid man ga gid ia, gid ga timataud gimi, be nadol gid ga tidae bagemiai. ");
INSERT INTO bch_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Danga toa ngada ne matad bibita tanoeai timan gimi ami masilau. Mugaeai nabada gid sabatnga ga abei itautau pagimi, be labone napan danga toa ngada ne iman ami annga. ");
INSERT INTO bch_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Be danga kelede toa gimi arangrang ngan aean mao, eine masilau imedameda toa ising ienono ngan. Ngansa sing eine mata bibita ipu. ");
INSERT INTO bch_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Be oangga masilau eta, mao eaba eta ipamate gimi, eine ga napanas ei. Tautaunga oangga eaba eta irau eaba ede pade ga imate, eine ga napamadid ei ngan posanga ta napanas ei ngan ele kadonga. ");
INSERT INTO bch_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Eaba ipamate eaba ede pade, ei pade ga imate ngan panua padengada baged, ngansa gau Deo nakado gid eababa ga tiuot mambe gau. ");
INSERT INTO bch_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Be gimi manta apopo gergeu ga aot busa ta ala aparangrang tibur toa ngada ne tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Idio ta Deo ikeo pan Noa ga ele gergeu bedane, ");
INSERT INTO bch_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Ega, labone, narau posanga toman ngan eao ga lem gergeu toa muriai ga tiuotot ta loloda kelede. ");
INSERT INTO bch_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Be narau posanga pade toman ngan gid danga toa ngada ne matad bibita. Narau posanga toman ngan gid man ga gid masilau saksak ga masilau mud. Eine gid toa ngada oa tanoeai ad tisulug oagaeai toman ngan eao. ");
INSERT INTO bch_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Narau posanga toman ngan gimi ga bedane: Naposa tautaunga, irangrang ngan nakado oanga kapei ga iuot ngan pamukurunga gid danga toa matad bibita ne pade mao. Be oanga kapei ga irangrang ngan ipaeabu ngan tano pade mao.” ");
INSERT INTO bch_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Ta Deo ikeo, “Gau nadol leg aoara aea mariluangge ga idio mariambai ngan gid laulau, ta iman kilala ngan leg posanga tautaunga toa narau toman ngan gimi ga gid masilau. Tota aoara aea mariluangge ga oaine, eine kilala ngan posanga tautaunga toa narau toman ngan danga toa ngada ne tanoeai. Leg posanga tautaunga toa ne ga ienono somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Oangga nakado gid laulau ga iuot mariambai, eine aoara aea mariluangge ga iuot pade, ");
INSERT INTO bch_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ta gau ga matag nanan leg posanga tautaunga toa narau toman ngan gimi ga gid masilau imata ede ga ede. Tota irangrang ngan oanga kapei ipaeabu ngan gid danga toa matad bibita ne pade mao. ");
INSERT INTO bch_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Oangga nagera aoara aea mariluangge iuot laulauiai, eine ga matag nanan leg posanga tautaunga toa narau ga ienono rabu ngan gau ga danga toa ngada ne matad bibita tanoeai. Posanga tautaunga toa ne ga ienono somisomi ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ta Deo ikeo pan Noa, “Aoara aea mariluangge toa ne, eine kilala ngan posanga tautaunga toa narau toman ngan danga toa ngada ne matad bibita tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noa ele gergeu toa tisulug oagaeai toman ngan ei, eine Siem ga Am ga Iapet. Be Am eine Kenan itama. ");
INSERT INTO bch_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noa ele gergeu toa tol ne, eine gid panua toa ngada ne tanoeai tibud. ");
INSERT INTO bch_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa ei eaba naurata dadanga aea. Be ei imuga ngan earumnga dadanga oain. ");
INSERT INTO bch_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Ado ede iun ele oain idanga ede, ta ilabora imangamanga. Be aea malo gruk ga isulug ta ieno bangabanga ele palata iloleai. ");
INSERT INTO bch_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Be Am toa, Kenan itama, igera itama ieno bangabanga, ta ila ikeo pagid itar kapeipei toa timadmadid gaot. ");
INSERT INTO bch_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Ta Siem ga Iapet tibada malo ede ta tikisi ga idae kepedeai ta tilalala pan murid ga tidudunga palatai ta tirobi tamad. Be matad kleng ta tigera tamad ibangabanga mao. ");
INSERT INTO bch_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Idio ta Noa idae ta imata iualai mulian pade ta ilongo posanga mambe ele gergeu ketnga tud, Am toa, igera ei ieno bangabanga. ");
INSERT INTO bch_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Ta ikeo, “Kenan ga ibada panasnga paeamao tau! Ei ga iman paeaeanga sapaean togid itar kapeipei.” ");
INSERT INTO bch_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Be Noa ikeo pade bedane, “Be Deo ag Maron ga ikado kemi tau ngan Siem! Kenan ga iuot paeaeanga sapaean ton Siem. ");
INSERT INTO bch_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Be Deo ga ikado Iapet ele gergeu ga tiuot busa ta isarung ad tano ga ila kapei. Eine ga timado kemi toman ngan gid iaoa kelede pan Siem. Be Kenan ga iman ele paeaeanga sapaean.” ");
INSERT INTO bch_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Muriai ngan oanga kapei toa oa, Noa imamado irangrang ngan rai buno tol sangalima (350). ");
INSERT INTO bch_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Noa aea rai toa ngada oa iuot buno lima buno pange sangalima (950), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Noa ele gergeu arangaranga tol, Siem ga Am ga Iapet, ad titnga ga bedane. Gid panua iaoa toaine tiuot muriai ngan oanga kapei. ");
INSERT INTO bch_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Iapet ele gergeu arangaranga edad ga bedane: Gomer ga Magok ga Madai ga Iavan ga Tubal ga Mesek ga Tiras. ");
INSERT INTO bch_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Be Gomer ele gergeu arangaranga edad ga bedane: Askenas ga Ripat ga Togarma. ");
INSERT INTO bch_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Be Iavan ele gergeu arangaranga edad ga bedane: Elisa ga Tarsis. Be gid panua Kit ad ga Dodan ad, gid pade tiuot pan Iavan. ");
INSERT INTO bch_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Gid panua iaoa toaine, led gergeu ga tibutibud timamado labiai ga inuiai. Gid panua iaoa toaine, gid Iapet itubtub. Be gid iaoa kelede kelede togid, tibilin ga tila timado ngan gid kelede kelede ad tano. Be gid iaoa kelede kelede led posanga lalaede mao. ");
INSERT INTO bch_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Am ele gergeu arangaranga edad ga bedane: Kus ga Misraim ga Put ga Kenan. ");
INSERT INTO bch_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Be Kus ele gergeu arangaranga edad ga bedane: Seba ga Avila ga Sapta ga Rama ga Sapteka. Be Rama ele gergeu arangaranga rua: Seba ga Dedan. ");
INSERT INTO bch_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Be Kus ele gergeu aranga ede pade ieda Nimrot. Be Nimrot idae kapei ta iuot eaba paraunga aea ga iura kapei. ");
INSERT INTO bch_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Maron ipamatua ei ta iura kapei ngan ilonga masilau tibur aea pade. Toa bedaoa ta oangga gid panua tigera eaba eta kemi ngan ilonga masilau, eine tipakuru ngan ei bedane, “Maron ipamatua eaba toa ne ta iura kapei ngan ilonga masilau tibur aea mambe Nimrot.” ");
INSERT INTO bch_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrot iman maron kapei ngan tuanga ga gid ne: Babel ga Erek ga Akat ga Kalne. Gid tuanga toa ne tienono ngan tibur kapei Sinar. ");
INSERT INTO bch_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Ga kus ta Nimrot itnan tibur kapei toa oa ta ila ngan tibur kapei Asiria ta ikado tuanga kapeipei ga gid ne: Ninive ga Reobotir ga Kala ");
INSERT INTO bch_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","ga Resin. Resin toa ienono rabu ngan Ninive ga tuanga kapei Kala. ");
INSERT INTO bch_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misraim eine panua ga gid ne tibud: gid Lidia ga gid Anam ga gid Leap ga gid Naptu ");
INSERT INTO bch_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ga gid Patrus ga gid Kaslu ga gid Kaptor. Be gid panua Pilistia, gid iaoa kelede pagid Kaptor. ");
INSERT INTO bch_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Be Kenan ele gergeu lautabe ieda Saidon. Kenan ei panua ga gid ne tibud: gid It ");
INSERT INTO bch_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ga gid Iebus ga gid Amor ga gid Girgas ");
INSERT INTO bch_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ga gid Ivi ga gid Arka ga gid Sini ");
INSERT INTO bch_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","ga gid Arvat ga gid Semar ga gid Amat. Muriai gid iaoa kelede kelede pan Kenan tibilin alele. ");
INSERT INTO bch_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Be gid Kenan ad tano aea but imata ienono ngan tuanga Saidon ga ila irangrang ngan tuanga Gasa boloma ngan tuanga Gerar. Toa eoa ad tano aea but ipol ga ila ado ele parangai ga iuot ngan tuanga Sodom ga Gomora ga Atma ga Seboim ga Lasa. ");
INSERT INTO bch_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Gid panua iaoa toaine, gid Am itubtub. Be gid iaoa kelede kelede togid, tila timado ngan gid kelede kelede ad tano. Be gid iaoa kelede kelede led posanga lalaede mao. ");
INSERT INTO bch_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Be Siem toa, Iapet itar kapei, ei pade ele gergeu. Siem eine gid panua Eber tibud. ");
INSERT INTO bch_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Siem ele gergeu arangaranga edad ga bedane: Elam ga Asur ga Arpaksat ga Lidia ga Aram. ");
INSERT INTO bch_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Be Aram ele gergeu arangaranga edad ga bedane: Us ga Ul ga Geter ga Mas. ");
INSERT INTO bch_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Be Arpaksat ei Sela itama, be Sela ei Eber itama. ");
INSERT INTO bch_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Be Eber ele gergeu arangaranga rua. Ede ieda Pelek. Ngansa ngan taun toaiua gid panua tanoeai timapmapoga alele ga tikado gid iaoa busa. Be Pelek itar kakau ieda Ioktan. ");
INSERT INTO bch_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Be Ioktan eine panua ga gid ne tamad: Almodat ga Selep ga Asarmavet ga Iera ");
INSERT INTO bch_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ga Adoram ga Usal ga Dikla ");
INSERT INTO bch_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ga Obal ga Abimael ga Seba ");
INSERT INTO bch_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ga Opir ga Avila ga Iobap. Gid panua toa ne, gid Ioktan ele gergeu. ");
INSERT INTO bch_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Tibur toa gid panua toa ne timamado ngan, aea but imata ienono ngan tibur Mesa ga ila irangrang ngan tibur Separ ngan tibur aea bereo toa ado ele parangai. ");
INSERT INTO bch_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Gid panua iaoa toaine, gid Siem itubtub. Be gid iaoa kelede kelede togid tila timado ngan gid kelede kelede ad tano. Be gid iaoa kelede kelede led posanga lalaede mao. ");
INSERT INTO bch_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Gid iaoa kelede toa ngada ne, eine gid iaoa kelede kelede pagid Noa ele gergeu. Muriai ngan oanga kapei, Noa ele gergeu tipopo gid iaoa kelede toa ne, be panua toa ngada ne tanoeai tiuot ngan gid ta tibilin ga timado alele. ");
INSERT INTO bch_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Mugaeai panua toa ngada ne tanoeai led posanga kelede mon. ");
INSERT INTO bch_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Gid tilalala alele ngan tibur ado ele parangai ta tiuot ngan tibur ede aea dubu, ieda Sinar, ta tirau tuanga toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Idio ta tiposa pol ngan gid bedane, “Io, gita tabul tano ga takapo gid ta tanono ngan dinga ga ila matua mambe pat, ta iman leda luma aea.” Tota tilalo gid pat matua toa oa ga idae ta tisama ngan kolta ta tikakado led luma ngan. ");
INSERT INTO bch_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tota tikeo, “Io, gita takado leda tuanga kapei eta be takado aea luma mamarae koknga ta isibo mariamba. Toa bedaoa ta panua tigera ta oaluda iuot kapei, ta irangrang ngan tamapoga alele tanoeai mao.” ");
INSERT INTO bch_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Idio ta Maron isulug ga inam ngan geranga gid eababa led tuanga ga luma mamarae toa tikakado. ");
INSERT INTO bch_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Ta Maron ikeo, “Ega, gid panua toaine tiluplup ga tiuot alu kelede ga led posanga kelede mon. Oangga tikado tuanga kapei toa bedane, eine ga tirangrang ngan tikado saoa danga tikim. ");
INSERT INTO bch_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Io, tasulug ga tala tapabuobuo gid ngan led posanga, ta irangrang ngan gid kelede kelede tiuatai ngan oaed ede pade ele posanga mao.” ");
INSERT INTO bch_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Tota Maron ipatabilin gid ta tipakaranga tano toa ngada ne. Tota tikaput ngan kadonga tuanga toa oa. ");
INSERT INTO bch_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ngan ipu toaine tiuato tuanga toa oa ieda Babel. Ngansa toa eoa Maron ipabuobuo gid panua toa ngada ne tanoeai ngan led posanga. Toa eoa Maron ipatabilin gid ta tila ngan tibur toa ngada ne tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Siem aea titnga ga bedane: Rai rua muriai ngan oanga kapei, Siem aea rai iuot buno, be iadaoa ipopo gergeu aranga ieda Arpaksat. ");
INSERT INTO bch_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Siem iadaoa ipopo Arpaksat ga kus ta Siem imamado irangrang ngan rai buno lima. Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksat aea rai sangaul tol igegea lima, be iadaoa ipopo gergeu aranga ieda Sela. ");
INSERT INTO bch_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arpaksat iadaoa ipopo Sela ga kus ta Arpaksat imamado irangrang ngan rai buno pange igegea tol (403). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sela aea rai sangaul tol, be iadaoa ipopo gergeu aranga ieda Eber. ");
INSERT INTO bch_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sela iadaoa ipopo Eber ga kus ta Sela imamado irangrang ngan rai buno pange igegea tol (403). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eber aea rai sangaul tol igegea pange, be iadaoa ipopo gergeu aranga ieda Pelek. ");
INSERT INTO bch_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eber iadaoa ipopo Pelek ga kus ta Eber imamado irangrang ngan rai buno pange sangaul tol (430). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelek aea rai sangaul tol, be iadaoa ipopo gergeu aranga ieda Reu. ");
INSERT INTO bch_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Pelek iadaoa ipopo Reu ga kus ta Pelek imamado irangrang ngan rai buno rua igegea lima ga pange (209). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reu aea rai sangaul tol igegea rua, be iadaoa ipopo gergeu aranga ieda Seruk. ");
INSERT INTO bch_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reu iadaoa ipopo Seruk ga kus ta Reu imamado irangrang ngan rai buno rua igegea lima ga rua (207). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruk aea rai sangaul tol, be iadaoa ipopo gergeu aranga ieda Naor. ");
INSERT INTO bch_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seruk iadaoa ipopo Naor ga kus ta Seruk imamado irangrang ngan rai buno rua (200). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naor aea rai sangaul rua igegea lima ga pange, be iadaoa ipopo gergeu aranga ieda Tera. ");
INSERT INTO bch_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naor iadaoa ipopo Tera ga kus ta Naor imamado irangrang ngan rai buno ede sangaul ede igegea lima ga pange (119). Be ele gergeu arangaranga ga taine padengada. ");
INSERT INTO bch_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tera aea rai sangalima sangaul rua, be iadaoa ipopo Abram ga Naor ga Aran. ");
INSERT INTO bch_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Tera aea titnga ga bedane: Tera ei Abram ga Naor ga Aran tamad. Be Aran ei Lot itama. ");
INSERT INTO bch_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tera imamado maitne, be ele gergeu Aran imate ngan aea tuanga ipu Ur ngan tibur togid panua Kaldia. ");
INSERT INTO bch_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Be Abram ga Naor gisirua tiuai taine. Abram iadaoa ieda Sarai, be Naor iadaoa ieda Milka. Milka ei Naor itar kapei Aran inat taine. Be Aran ei Iska itama pade. ");
INSERT INTO bch_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Be Sarai irangrang ngan ipopo gergeu mao. ");
INSERT INTO bch_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Idio ta Tera ibada inat Abram ga ilaoa taine Sarai toa Abram iadaoa, ga itub Lot toa gergeu ton inat Aran, ta gisingada titnan tuanga Ur ngan tibur togid panua Kaldia, ta tiuangga tila ngan tibur kapei Kenan. Be edap irabuiai tiuot ngan tuanga Aran ta tidio toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Be Tera imamado irangrang ngan aea rai buno rua igegea lima (205), ga kus ta imate ngan tuanga Aran. ");
INSERT INTO bch_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Idio ta Maron ikeo pan Abram bedane, “Eao tnan am tano ga sobosobom ga gid iaoa kelede togo, ta la ngan tano toa gau ga napasolan eao ngan. ");
INSERT INTO bch_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Gau ga nakado ga tibutibum tiuot alu kapei tau, ta gau ga nakado kemi tau ngan eao. Be gau ga nakado ga edam iuot kapei. Ta eao ga kado ta leg kadonga kemi toa ne idae pade ngan gid panua padengada. ");
INSERT INTO bch_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Gau ga nakado kemi ngan gid panua toa tikado kemi ngan eao, be gid panua toa tikado paeamao ngan eao, eine ga nakado paeamao ngan gid pade. Be kadonga kemi toa nakado ngan eao, eine ga iparangrang gid lum ga lum ngan tibur toa ngada ne tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Tota Abram itnan tuanga Aran, mambe Maron ikeo pan ngan, be Lot ila toman ngan ei. Ngan ado toaiua Abram itnan tuanga Aran, ei aea rai sangalima sangaul rua igegea lima. ");
INSERT INTO bch_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ei ibada iadaoa Sarai, ga itar kapei inat Lot, ga led paeaeanga arangaranga ga taine, ga led danga sisid toa ngada oa ienono ngan tuanga Aran. Ta tidae ga tinasi edap ila ngan tibur kapei Kenan. Tila tiuot Kenan ga kus ");
INSERT INTO bch_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","ta tibulou tibur kapei toa oa ga tila irangrang ngan tibur ede ieda More, boloma ngan tuanga Sekem. Tibur toa oa aea abei ouk ede imadmadid. Be ngan ado toaiua, gid panua Kenan timamado maitne ngan tano toa oa. ");
INSERT INTO bch_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Idio ta Maron iuot pan Abram ta ikeo, “Gau ga napan tibur kapei toa ne aea tano ga iman lem gergeu ga tibutibum ad.” Ta Abram ipagun popou tenainga aea toa eoa ta iraring pan Maron toa iuot pan. ");
INSERT INTO bch_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Ga kus ta Abram itnan tibur toa oa ta ila ngan tibur aea bereo toa ado ele parangai ngan tuanga Betel. Ta ikado saupu toa eoa ta ipagun palata. Tibur toa oa ienono rabu ngan tuanga Betel ga tuanga Ai. Betel ienono ado ele dilngai, be Ai ienono ado ele parangai. Toa eoa ipagun popou tenainga aea ton Maron ta ibaba ga ila pan ta isoa ieda. ");
INSERT INTO bch_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ga kus ta itnan tibur toa oa ta ilalala ga ingata tibur kapei ieda Negev. ");
INSERT INTO bch_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Idio ta sapanga kapei iuot ngan tibur toa oa, ta Abram ila imado Isip kautede, ngansa sapanga ngan tibur toa oa paeamao tau. ");
INSERT INTO bch_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tilalala ga tipaboloma Isip, be Abram ikeo pan iadaoa Sarai bedane, “Ega, gau naoatai, eao taine namelapau. ");
INSERT INTO bch_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Be oangga gid Isip tigera eao, eine ga tikeo, ‘Taine toa ne iadaoa eine eaba ga eko.’ Ta gid ga tirau gau ga namate ta tipaeaoa go. ");
INSERT INTO bch_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tota kemi ngan eao keo pagid mambe eao gau liug. Toa bedaoa ta oangga tikim eao, eine ga tikado kemi ngan gau be tipamate gau mao.” ");
INSERT INTO bch_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Idio ta Abram ga Sarai tiuot Isip ga kus ta gid Isip tigera mambe Sarai ei taine namelapau tau. ");
INSERT INTO bch_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Be gid madidnga ton maron kapei Isip aea tigera Sarai ta tipakuru ngan ei toa maron kapei imatai. Ta maron kapei ikeo ga tibada ei ga ila ele lumaeai. ");
INSERT INTO bch_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Maron kapei toa oa igera Sarai ta ikim ei tau. Tota ikado kemi pan Abram ta ipan ele sipsip ga meme ga bulmakao ga donki arangaranga ga taine ga kamel ga gid paeaeanga arangaranga ga taine. ");
INSERT INTO bch_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Be Maron ikado dibala papaeamao edengada ga iuot pan maron kapei Isip aea ga pagid panua toa timamado ele lumaeai. Ngansa ei ibada Abram iadaoa Sarai ga iman ele taine. ");
INSERT INTO bch_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Idio ta maron kapei Isip aea ibaba Abram ga inam pan ta ikeo, “Eao kamado kado bedane ngan gau? Eao kamado palongo gau mao ngan taine toa ne ei eao adaoam? ");
INSERT INTO bch_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Eao kamado keo ga ei lium? Tota nabada ei ga iman adaoag. Ega, bada adaoam ta gimirua ala!” ");
INSERT INTO bch_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Io, maron kapei Isip aea ikeo pagid ele madidnga ta tisere Abram ga iadaoa. Tota tibada led danga sisid toa ngada oa ta tila. ");
INSERT INTO bch_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Idio ta Abram itnan Isip ta ila ngan tibur kapei Negev. Ei ila toman ngan iadaoa ga ele danga sisid toa ngada oa. Be Lot pade ila toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Be Abram ele danga sisid busa tau. Ei ele masilau mud busa ga ele silva ga gol pade. ");
INSERT INTO bch_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Idio ta itnan tibur kapei Negev ta ilalala ga ila be ikakado gid saupu edap irabuiai. Ikakado toa bedaoa ga ila iuot ngan tibur toa ienono rabu ngan tuanga Betel ga Ai. Mugaeai ikado saupu ngan ");
INSERT INTO bch_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","tibur toa oa ta ipagun popou tenainga aea. Ta Abram ibaba ga ila pan Maron ta isoa ieda toa eoa pade. ");
INSERT INTO bch_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Be Lot ilalala toman ngan Abram, ei pade ele meme ga sipsip ga bulmakao ga paeaeanga busa. ");
INSERT INTO bch_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Be tano toa oa irangrang ngan gisirua tilup ga timado ngan mao, ngansa gisirua led danga sisid busa tau. ");
INSERT INTO bch_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Be ado ede gid panua toa timariala ngan Abram ele masilau mud, aoad parau pagid panua toa timariala ngan Lot ele masilau mud. Be ngan ado toaiua, gid panua Kenan ga gid Peres timamado maitne ngan tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tota Abram ikeo pan Lot bedane, “Longo. Gitarua sing kelede. Be kado paraunga iuot rabu ngan gitarua ga leda paeaeanga. ");
INSERT INTO bch_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Gera, tano kapei ienono. Kemi ngan gitarua tamapoga. Oangga eao kim nasi edap ngan bageda angas, eine gau ga nanasi edap ngan bageda oatai. Be oangga eao kim nasi edap ngan bageda oatai, eine gau ga nanasi edap ngan bageda angas.” ");
INSERT INTO bch_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Io, Lot imata isaoe ta igera tibur Iordan aea dubu kapei, be aea eau busa ga ila irangrang ngan tuanga Soar. Tibur toa oa kemi mambe dadanga ton Maron ga mambe tano togid Isip. (Ngan ado toaiua, Maron ipaeabu ngan tuanga Sodom ga Gomora maitne.) ");
INSERT INTO bch_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tota Lot isio dubu toa kapei oa ngan tibur Iordan ga iman ei ele. Ta itnan Abram ta ila ngan tibur toa ado ele parangai. Tota gisirua tilup ga timado pade mao. ");
INSERT INTO bch_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abram idio imado ngan tibur Kenan, be Lot ila imado rabu ngan gid tuanga kapeipei ngan eau Iordan aea dubu kapei. Ta irau ele saupu boloma ngan tuanga Sodom. ");
INSERT INTO bch_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Be gid panua Sodom eine gid panua papaeamao, ta tikakado kadonga sasat paeamao tau Maron imatai. ");
INSERT INTO bch_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot itnan Abram ga ila ga kus ta Maron ikeo pan Abram bedane, “Dae madid ta matam isaoe tibur toa ngada ne ado ele parangai ga ado ele dilngai, pan not ga ila irangrang ngan saut pade. ");
INSERT INTO bch_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Tano toa ngada ne eao gera, eine ga nabada pago ga pagid lem gergeu ga tibutibum. Tano toa ne ga iman gimi ami somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Be gau ga nakado ga lem gergeu ga tibutibum tiuot busa tau mambe riringa tano aea. Ta oangga eaba eta irangrang ngan iuade gid riringa tano aea, eine ga irangrang ngan iuade lem gergeu ga tibutibum pade. ");
INSERT INTO bch_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Io, lalala ga la ta gera tano aea mamarae ga aea babanga, ngansa gau napan ga iman am.” ");
INSERT INTO bch_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Abram itnan saupu toa oa ta ila imado boloma ngan tuanga Ebron, ta irau ele saupu boloma ngan gid abei ouk ton eaba ieda Mamre. Ta ikado popou tenainga aea ngan tibur toa oa ta isoa Maron ieda. ");
INSERT INTO bch_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Ngan ado toaiua, mamaron pange tiluplup ngan kadonga paraunga pagid ad miri itamatama. Gid mamaron toa pange oa edad ga bedane: Kedorlaomer (maron togid Elam) ga Amrapel (maron togid Sinar) ga Ariok (maron togid Elasar) ga Tidal (maron togid Goim). ");
INSERT INTO bch_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Gid mamaron toa pange oa tiuangga tiparau pagid mamaron lima. Mamaron toa lima ne edad ga bedane: Bera (maron ngan tuanga Sodom) ga Birsa (maron ngan tuanga Gomora) ga Sinap (maron ngan tuanga Atma) ga Semeber (maron ngan tuanga Seboim) ga maron ede pade ngan tuanga Bela. (Tuanga Bela toa ieda ede pade Soar.) ");
INSERT INTO bch_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Gid mamaron toa lima oa tila tiluplup ngan dubu kapei ngan tibur Sidim, boloma ngan liu kapei Melak, ta tisanga gid mamaron toa pange oa ngan paraunga. ");
INSERT INTO bch_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Paraunga toa ne iuot ngansa mugaeai gid mamaron toa lima oa tidio Kedorlaomer ibageai ta timan ele paeaeanga sapaean irangrang ngan rai sangaul igegea rua. Be ngan rai sangaul igegea tol, tinid ngan ei mao ta tilongo ilinge pade mao. ");
INSERT INTO bch_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Be ngan rai sangaul ga igegea pange, Kedorlaomer ibaba gid iarerea, mamaron toa tol oa, ta tilua ei ngan paraunga ta tiasal ad miri itamatama padengada. Ad miri itamatama toa oa led tuanga edad ga bedane: gid Repaim ngan tuanga Asterot-Karnaim, ga gid Sus ngan tuanga Am, ga gid Em ngan tibur dubu boloma ngan tuanga Kiriataim, ");
INSERT INTO bch_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ga gid Or ngan gid bereo ngan tibur Seir. Kedorlaomer ga iarerea tibutatan ad miri itamatama toa oa ga tila irangrang ngan tibur ieda Elparan, boloma ngan tibur modamodanga. ");
INSERT INTO bch_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tibutatan gid ga kus ta tiluagid mulian ga tila ngan tuanga Kades. (Kades toa ieda mugamuga eine Enmispat.) Kedorlaomer ga iarerea tiparau ga tiasal ad miri itamatama ngan tibur toa ngada oa togid Amalek, ga tiasal gid Amor toa timamado ngan tuanga Asason-Tamar pade. ");
INSERT INTO bch_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Be gid mamaron lima toa mugaeai tilongo Kedorlaomer ilinge mao, gid tigera mambe ei ikakado paraunga pagid aea miri itamatama, ta tipaluplup led panua paraunga ad ta tisanga ei ngan paraunga ngan dubu kapei ngan tibur Sidim. Gid mamaron toa lima oa led tuanga edad ga bedane: Sodom ga Gomora ga Atma ga Seboim ga Bela toa ieda ede pade Soar. ");
INSERT INTO bch_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Be Kedorlaomer (maron togid Elam) asingada iarerea toa tol oa tinam tiuot ngan dubu kapei toa oa ta timadmadid iadag. Kedorlaomer iarerea toa tol oa edad ga bedane: Tidal (maron togid Goim) ga Amrapel (maron togid Sinar) ga Ariok (maron togid Elasar). Toa eoa mamaron toa pange oa tiparau pagid mamaron toa lima oa. ");
INSERT INTO bch_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Be dubu kapei ngan tibur Sidim aea baba busa iuon ngan kolta. Be ngan ado toaiua, mamaron togid Sodom ga Gomora led panua idanga ede tiaoa ngan paraunga ta titaptap ga tisulug ngan gid baba toa oa. Be gid mamaron padengada toman ngan led panua tiaoa ga tila bereoeai. ");
INSERT INTO bch_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tota Kedorlaomer toman ngan iarerea tol tiasal paraunga ta tipaeaoa danga sisid ga annga toa ngada oa ngan tuanga Sodom ga Gomora. Ga kus ta tila. ");
INSERT INTO bch_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Be Lot, gergeu ton Abram itar kapei, imamado Sodom, ta gid mamaron pange tipaeaoa ei pade toman ngan ele danga sisid ta tila. ");
INSERT INTO bch_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Be eaba ede iaoa ngan paraunga ta ila pan Abram, eaba Ibru aea, ta ikeo pan ngan danga toa ngada oa iuot ngan paraunga. Ngan ado toaiua, Abram ele saupu ienono boloma ngan gid abei ouk ton Mamre. Mamre toa ei eaba Amor aea, be itar kakau rua. Ede ieda Eskol ga ede pade ieda Aner. Gid panua toa tol ne timan Abram ele aluagau ngan paraunga. ");
INSERT INTO bch_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Be Abram ilongo mambe tipaeaoa iua Lot, tota ibaba ele panua paraunga ad buno tol sangaul ede igegea lima ga tol (318). Gid panua toa oa eine Abram ele paeaeanga be tinanale ngan paraunga. Abram imuga ngan gid ga tila tibutatan gid mamaron toa pange oa ga tila irangrang ngan tuanga Dan. ");
INSERT INTO bch_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Toa eoa Abram ipota ele panua paraunga ad ta tiuot iaoa rua. Tisanga bong ta tikado paraunga pagid mamaron toa pange oa. Tota tiasal gid ta tibutatan gid ga tila irangrang ngan tuanga Oba, iadag ngan tuanga kapei Damaskus. ");
INSERT INTO bch_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Toa bedaoa ta Abram ibada mulian gid danga sisid toa ngada oa gid mamaron tipaeaoa, ga ibada mulian iua Lot toman ngan iadaoa masin ga gid taine ga gid paeaeanga ga ele danga sisid. ");
INSERT INTO bch_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abram iasal paraunga toman ngan Kedorlaomer ga iarerea ga kus ta iluai mulian ga inam. Be maron ngan tuanga Sodom inam iuot pan ngan dubu kapei ngan tibur ieda Save. (Tibur toa oa ieda ede pade eine Dubu Kapei Togid Mamaron Kapeipei.) ");
INSERT INTO bch_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Be maron ede pade ieda Melkisedek inama iuot. Ei maron ngan tuanga Salem be ei eaba tenainga aea ton Deo Gadae Tau. Ei ibada bret ga oain ga ila pan Abram ");
INSERT INTO bch_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","ta ikado posanga kemi ngan pamatuanga ei ta ikeo, “Deo Gadae Tau toa ikado bubur ga tano ga iuot, ei ikado kemi tau ngan Abram. ");
INSERT INTO bch_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tasoa Deo Gadae Tau ieda, ngansa ei idol am miri itamatama ga tidae bagemeai.” Be danga sisid toa ngada oa Abram ibada ngan paraunga, eine ipota ga tiuot suknga sangaul. Ga kus ta ipan Melkisedek ele suknga ede. ");
INSERT INTO bch_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Idio ta maron ngan tuanga Sodom ikeo pan Abram bedane, “Danga toa ngada ne eao bada ngan paraunga, kemi ngan idio pago, be gid panua kekelegid, gau nakim tiluagid mulian ga tinam pagau.” ");
INSERT INTO bch_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Be Abram ikeo pan maron Sodom aea bedane, “Be gau nakado posanga tautaunga pan Deo ag Maron Gadae Tau. Ei ikado bubur ga tano ga iuot, be nakado posanga tautaunga ngan ei ieda ga bedane: ");
INSERT INTO bch_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Irangrang ngan nabada lem danga eta mao. Danga eta kakauede mambe salumu aea oaro, mao oaro su aea, eine irangrang ngan nabada mao. Ngan kado ta muriai eao keo bedane, ‘Gau nakado ga Abram ele danga sisid busa.’ ");
INSERT INTO bch_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Tota gau ga nabada danga eta mao. Gid annga toa gaingada leg arangaranga aean ga kus, eine ikaranga. Be gau oaeoaeg toa tol ne, Aner ga Eskol ga Mamre, gid ga tibada anad.” ");
INSERT INTO bch_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Idio ta Abram igera danga ede mambe ianun ta igera Maron ikado posanga pan bedane, “Abram, eao mataud mao. Gau ga napamumul go mambe lem gariau. Am lasunga kapei tau, tota gau ne.” ");
INSERT INTO bch_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Be Abram ikeo, “O Deo ag Maron! Gau leg gergeu eta mao, be lem kadonga kemi pagau ga madongan? Ngansa oangga namate, Elieser Damaskus aea ga ibada leg danga sisid toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Ta Abram ikeo pade bedane, “Ega, eao pan leg gergeu eta mao, tota leg paeaeanga toa ne ga ibada danga toa ngada ne togau.” ");
INSERT INTO bch_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Be mole mao Maron ele posanga iuot pan ta ikeo, “Eaba toa ne irangrang ngan ibada lem danga sisid mao, be gergeu ede iuot ngan eao singim, ei ga ibada mulim ga lem danga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Idio ta ibada ei ga ila gaot, ta ikeo pan bedane, “Eao matam idae ga ila mariambai ta gera gid gigima ta ton oadenga gid. Eao rangrang na? Longo, lem gergeu ga tibutibum ga tiuot busa toa bedaoa.” ");
INSERT INTO bch_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abram ilolo matua ngan Maron, ta ngan ipu toaine ei irau posanga ngan Abram ta iuato ei eaba tutui. ");
INSERT INTO bch_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ta ikeo, “Gau Maron. Gau nabada go ga tnan tuanga Ur ngan tibur togid Kaldia, ta napan tano toa ne ga iman am.” ");
INSERT INTO bch_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Be Abram ikeo, “O Deo ag Maron! Gau ga naoatai madongan mambe tano toa ne ga iman ag?” ");
INSERT INTO bch_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Ta ikeo pan Abram, “Bada danga ga gid ne ga tinam pagau: bulmakao taine ede aea rai tol, ga meme taine ede aea rai tol, ga sipsip aranga ede aea rai tol, ga man ganei ede, ga man barur ede.” ");
INSERT INTO bch_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Io, Abram ibada gid danga toa oa ga ila ta iket gid ga timan ruangada ta ilalo gid ikatinge iadag ga iadag. Be man toa rua oa, iket mao. ");
INSERT INTO bch_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Idio ta man abalem edengada tisulug ta tiuangga tian gid masilau toa oa patid, be Abram isere gid. ");
INSERT INTO bch_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ado iuangga idil, be Abram ieno ga ibalo. Ei ienono ta igera dodom kapei inam irobi ei ta imataud paeamao tau. ");
INSERT INTO bch_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Ta Deo ikeo pan Abram bedane, “Naposa tautaunga pago, eine ga tibutibum tila tidio ngan tano togid panua padengada, ta timan paeaeanga sapaean togid. Gid panua toa oa ga tikado paeamao ngan gid irangrang ngan ad rai buno pange. ");
INSERT INTO bch_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Be gau ga napanas gid panua toa tipaeaea gid. Ga kus ta tibutibum ga titnan tano toa oa, be tinam toman ngan led danga sisid busa. ");
INSERT INTO bch_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Be eao ga mamado lem kemi irangrang ngan ot eaba kapei tau ta mate ga titaian go. ");
INSERT INTO bch_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Be gid gabagabad ga tiluagid mulian toa eko. Irangrang ngan tiluagid mulian manmanae mao, ngansa gau naoangga napanas gid Amor, be led kadonga sasat iuot kapei maitne.” ");
INSERT INTO bch_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Io, ado idil ga tibur dodom, ta ulo ede per ga iuot. Ulo toa oa aea dinga irarabal mambe usi ga aea basu idaedae, be danga toa oa ilalala rabu ngan gid masilau ikatinge. ");
INSERT INTO bch_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Ngan bong toaiua Maron irau posanga toman ngan Abram ta lolod kelede ta ikeo, “Gau napan tano toa ne pagid tibutibum. Tano aea but imata idio ngan tibur Isip aea eau, be aea but iadag ila iuot ngan eau kapei Iupretis. ");
INSERT INTO bch_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Labone alu ga gid ne timamado toa eoa: gid Kin ga gid Kenas ga gid Katmon ");
INSERT INTO bch_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ga gid It ga gid Peres ga gid Repaim ");
INSERT INTO bch_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","ga gid Amor ga gid Kenan ga gid Girgas ga gid Iebus.” ");
INSERT INTO bch_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Be Abram iadaoa Sarai ipopo ele gergeu eta mao. Be Sarai ele taine paeaeanga ede Isip aea ieda Agar. ");
INSERT INTO bch_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ta ado ede Sarai ikeo pan Abram bedane, “Ega, Maron ipakala gau ngan poponga gergeu. Tota kemi ngan eao la eno toman ngan leg paeaeanga, ta oangga irangrang, ei ga ipopo leg gergeu eta.” Io, Abram ilongo Sarai ele posanga. ");
INSERT INTO bch_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sarai ibada ele paeaeanga toa Isip aea, Agar, ga ila pan Abram ta iuot mambe iadaoa. Ngan ado toaiua, Abram imamado Kenan aea rai sangaul. ");
INSERT INTO bch_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abram ieno toman ngan Agar, ta iapa. Idio ta Agar iuatai mambe iapa, ta ilolon ngan aea maron iadaoa pade mao. ");
INSERT INTO bch_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Ta Sarai ikeo pan Abram, “Kadonga kulupu toa iuot ngan gau ne, eine eao lem idil paeamao. Gau nabada leg paeaeanga ga ila pago, ta labone iuatai mambe ei iapa, ta ilolon ngan gau pade mao. Be gau nakim Maron ikeo ga sai ngan gitarua itutui.” ");
INSERT INTO bch_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Ta Abram ikeo pan Sarai bedane, “Ega, lem paeaeanga idio eao bagemeai. Saoa kadonga eao keo ga kemi ngan ei, tota nasi.” Idio ta Sarai ikado kulupu ngan Agar, ta Agar iaoa ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Be anggelo ton Maron iuot pan Agar boloma ngan eaumata ede ngan tibur modamodanga, ngan edap ila ngan tuanga Sur. ");
INSERT INTO bch_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ta ikeo pan bedane, “Agar, paeaeanga ton Sarai, eao mado sida ga nam, be eao la sida?” Ta Agar ikeo, “Gau naeaoa ngan ag maron iadaoa, Sarai.” ");
INSERT INTO bch_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ta anggelo ton Maron ikeo, “Luago ga la pan Sarai, ta mamado ei ibageai ta nasi ilinge.” ");
INSERT INTO bch_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Be anggelo ton Maron ikeo pade bedane, “Gau ga nakado tibutibum ga tiuot busa tau, ta irangrang ngan eaba eta iuade gid mao.” ");
INSERT INTO bch_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ta anggelo ton Maron ikeo pan bedane, “Ega, teta pade eao ga popo gergeu aranga. Ta eao ga oato ieda Ismael. Ngansa kadonga paeamao iuot ngan eao, be Maron ilongo lem tandanga na. ");
INSERT INTO bch_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Be gergeu toa ne ga iuot mambe donki saksak ede, ta irangrang ngan ilongo eaba eta ilinge mao. Ei ga iman panua toa ngada ne ad isat, be gid ga timan ei aea isat pade. Ta irangrang ngan imamado kemi toman ngan isobosobo mao.” ");
INSERT INTO bch_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Agar imata nanan Maron ikado posanga toa oa pan, ta iuato ieda bedane, “Eao Deo toa matam ikikisi gau.” Ngansa ei ikeo, “Gau nagera Deo toa imata kikisi gau.” ");
INSERT INTO bch_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Ngan ipu toaine, gid panua tiuato eaumata aea baba toa oa ieda Ber-Laai-Roi. Eaumata toa oa ienono rabu ngan tuanga Kades ga tibur Beret. ");
INSERT INTO bch_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Idio ta Agar ipopo Abram ele gergeu aranga, ta Abram iuato ieda Ismael. ");
INSERT INTO bch_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram aea rai sangalima sangaul tol igegea lima ga ede, be Agar ipopo Ismael. ");
INSERT INTO bch_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abram aea rai sangalima sangaul pange igegea lima ga pange, be Maron iuot pan ta ikeo, “Gau Deo Matua Soke Tau. Eao manta kado kadonga itutui gau matageai, be irangrang ngan lem idil eta paeamao mao. ");
INSERT INTO bch_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ta gau ga narau posanga toman ngan eao ta loloda kelede. Be gau ga nakado ga lem gergeu ga tibutibum tiuot busa tau.” ");
INSERT INTO bch_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Io, Abram ikor iae ta idol imata ga isulug tanoeai, ta Deo ikeo pan, ");
INSERT INTO bch_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Ega, posanga toa narau toman ngan eao eine ga bedane: Eao ga man gid alu busa tibud. ");
INSERT INTO bch_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Be gau napalele edam. Ta gid panua tirangrang ngan tiuato edam Abram pade mao. Eine ga tiuato edam Abraam, ngansa gau nakado ga eao ot alu busa tibud. ");
INSERT INTO bch_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tibutibum ga tiuot busa tau, ta timan alu busa. Edengada ngan gid ga tiuot mamaron kapeipei. ");
INSERT INTO bch_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Posanga toa narau toman ngan eao ga tibutibum muriai, eine ga ienono somisomi ga ilalala ga ila. Posanga ga bedane: Gau naman am Deo ga Deo togid tibutibum muriai ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Tano Kenan toa labone eao mamado ngan mambe kaluae, eine ga napan ga iman eao togo ga togid tibutibum toa tiuotot muriai. Tano toa ne ga iman gid ad somisomi ga ilalala ga ila. Ta gau ga naman gid ad Deo pade.” ");
INSERT INTO bch_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Idio ta Deo ikeo pan Abraam, “Eao ga lem gergeu ga tibutibum toa tiuotot muriai, manta anasi posanga toa narau toman ngan gimi ne. ");
INSERT INTO bch_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Be gimi manta anasi kilala toa ne ngan posanga toa narau toman ngan eao ga tibutibum muriai. Kilala toa ne ga bedane: Eao manta palu lem arangaranga toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Ngan ami palunga eine ga tiket tinimi kukul ta iman kilala ngan posanga toa narau toman ngan gimi ne. ");
INSERT INTO bch_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Labone ga muriai ga ila, eao manta palu lem arangaranga toa ngada ne. Ado lima ga tol muriai ngan ad poponga ta apalu gid. Be eao ga palu gid lem paeaeanga pade. Lem paeaeanga toa ngada ne tnatnad tipopo gid lem lumaeai, ga gid paeaeanga toa ol gid ngan iaoa ede pade, manta apalu gid. ");
INSERT INTO bch_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Manta palu lem arangaranga toa ngada ne. Gid toa tnatnad tipopo gid lem lumaeai ga gid arangaranga toa eao ol gid ga timan lem paeaeanga, gid toa ngada oa manta tibada palunga. Kilala toa ne manta ienono ngan tinimi. Toa bedaoa ta panua tiuatai mambe posanga toa narau toman ngan gimi, eine ga ienono ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Be eaba sai, oangga ibada palunga ngan itin mao, eine inasi posanga toa narau toman ngan gimi ne mao. Toa bedaoa ta irangrang ngan imamado toman ngan ele panua pade mao. Eine ga tisuk ei ga ila.” ");
INSERT INTO bch_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Be Deo ikeo pan Abraam pade bedane, “Be eao ga oato adaoam ieda Sarai pade mao. Eao ga oato ieda pau Sara. ");
INSERT INTO bch_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Eine ga nakado kemi tau ngan ei ta ipopo lem gergeu aranga ede, ta iuot alu busa tibud taine. Itubtub edengada ga tiuot mamaron kapeipei.” ");
INSERT INTO bch_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abraam ikor iae ga idol ilabora ga isulug tanoeai, be inging ta ikeo iloleai bedane, “Eaba aea rai buno irangrang ngan ipopo gergeu pade? Be Sara aea rai sangalima sangaul pange. Ei ga irangrang ngan ipopo gergeu?” ");
INSERT INTO bch_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ta Abraam ikeo pan Deo bedane, “Kemi ngan matam ikikisi Ismael ta kado kemi ngan ei.” ");
INSERT INTO bch_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ta Deo ikeo, “Tautaunga. Be adaoam Sara, ei pade ga ipopo lem gergeu aranga, ta eao ga oato ieda Aisak. Gau ga narau posanga toman ngan ei ga ele gergeu ga itubtub ta lolomai kelede. Be posanga toa ne ga ienono somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Be Ismael toa eao beta gau ngan matag ikikisi ei, eine ga nakado. Ega, gau ga nakado kemi tau ngan ei ta nakado ga ele gergeu tiuot busa. Ei ga iuot mamaron sangaul igegea rua tamad. Ta nakado ga itubtub tiuot alu kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Be gau ga narau leg posanga toman ngan Aisak. Eine Sara ga ipopo ei rai matadai ngan taiko toaine.” ");
INSERT INTO bch_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Deo iposa toman ngan Abraam ga kus ta itnan ei ta idae ga ila. ");
INSERT INTO bch_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ngan ado toaiua, Abraam ipalu inat Ismael ga ipalu ele paeaeanga arangaranga toa ngada oa. Gid paeaeanga edengada tnatnad tipopo gid Abraam ele lumaeai, be padengada Abraam iuol gid ga timan ele, ipalu gid toa ngada oa. Ipalu gid ngan tinid kukul lalaede mambe Deo ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abraam aea rai sangalima sangaul pange igegea lima ga pange, be tipalu ei pade. ");
INSERT INTO bch_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Be inat Ismael aea rai sangaul igegea tol ngan ado toaiua ibada palunga. ");
INSERT INTO bch_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Tota tipalu Abraam ga inat Ismael ngan ado toa kelede oa. ");
INSERT INTO bch_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Be tipalu Abraam ele arangaranga toa ngada oa pade. Arangaranga edengada tnatnad tipopo gid Abraam ele lumaeai, be padengada Abraam iuol gid ga timan ei ele, gid toa ngada oa tibada palunga toman ngan Abraam ngan ado toaiua. ");
INSERT INTO bch_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Idio ta Maron iuot pan Abraam boloma ngan gid abei ouk ton Mamre. Abraam imamado ele palata aea atama iaoai, be ado ilang kapei. ");
INSERT INTO bch_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Be imata idae ta igera panua tol per ga tiuot ta timadmadid boloma. Igera gid ta itnan ele palata ta ilado manmanae ga ila pagid. Ikor iae ta idol ilabora ga isulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Ta ikeo pagid, “Mamaron, oangga lolomi marum ngan gau, nakim adio pagau kauteta. Be asapir ngan gau ga ala sapaean mao. Gau mambe lemi paeaeanga. ");
INSERT INTO bch_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Gau ga nakeo pan eaba ede ngan ibada eau ga inam ta asigiri aemi ga kus ta aearagimi kauteta abei ibuloloeai. ");
INSERT INTO bch_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Be kemi ngan nabada annga etangada ga inam aean ta ipamatua tinimi. Ga kus ta alalala pade. Ngansa gimi anam pagau ta naoangga nalua gimi.” Ta gid tikeo, “Eine kemi, kado mambe eao keo ngan.” ");
INSERT INTO bch_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tota Abraam manmanae ga ila palata iloleai ta ikeo pan Sara bedane, “Bada tabla kapei eta iuon ngan plaoa, ta bib manmanae ta nono ga iman ad bret.” ");
INSERT INTO bch_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ga kus ta ilado ga ila igera ele bulmakao ipu ta isio bulmakao daenga pau ede itub kapei. Ta ibada ga ila pan ele paeaeanga ta ibage manmanae ngan aea totoinga, ga kus ta ila inono. ");
INSERT INTO bch_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ta Abraam ibada bulmakao itud isul ga sis toman ngan bulmakao imedameda ga ila pagid ta tian. Gid tianean, be Abraam imadmadid abei ibuloloeai boloma pagid. ");
INSERT INTO bch_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Ta tibeta ei bedane, “Adaoam Sara, ei sida?” Ta ikeo, “Ega, imamado palata iloleai.” ");
INSERT INTO bch_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Be ede ngan gid ikeo, “Gau ga naluagau mulian rai matadai ngan taiko toaine, ta Sara ga ikikisi ele gergeu aranga ede.” Be Sara imamado boloma palata iaoai, muriai ngan eaba toa oa, ta ilongolongo ele posanga. ");
INSERT INTO bch_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Be Abraam ga Sara gisirua tiuot kapeipei na, ta Sara aea rai poponga aea ila gid ga kus. ");
INSERT INTO bch_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ta Sara inging mulian ngan ei ta ikeo iloleai bedane, “Gau taine kapei be tinig imogougou na. Be adaoag ei pade eaba kapei. Ta gau ga tinig igelgel bedane madongan?” ");
INSERT INTO bch_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Ta Maron ikeo pan Abraam bedane, “Sara ikamado ga inging ta ikeo, ‘Gau taine kapei, be gau ga napopo gergeu madongan?’ ");
INSERT INTO bch_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Longo! Danga eta ikulupu ngan Maron mao. Gau ga naluagau mulian rai matadai ngan taiko toaine, ta Sara ga ikikisi ele gergeu aranga ede.” ");
INSERT INTO bch_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Be Sara imataud ta ipaisiamo ta ikeo, “Gau nanging mao.” Be ei ikeo, “Mao. Eao nging.” ");
INSERT INTO bch_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Panua tol tidae ga tila, be Abraam iuangga ital gid ga tila edapeai. Be toa eoa matad isulug ta tigera tuanga Sodom aluai tede. ");
INSERT INTO bch_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Be Maron ikeo, “Danga toa naoangga nakado ne, eine ga namudan pan Abraam mao. ");
INSERT INTO bch_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ngansa Abraam itubtub ga tiuot alu kapei ga matua tau. Be kadonga kemi toa nakado ngan ei, eine ga iparangrang gid alu toa ngada ne tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Ngansa gau nasio ei ngan badanga leg posanga ga ila pagid ele gergeu ga itubtub toa tiuotot muriai, ta tinasnasi leg edap ta tikado kadonga kemikemi ga tutui. Toa bedaoa ta gau ga nakado danga toa ngada oa pan mambe nakeo tautaunga pan mugaeai.” ");
INSERT INTO bch_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Ta Maron ikeo, “Gau nalongo selelenga kapei tau ngan gid Sodom ga Gomora led kadonga sasat. Led kadonga sasat papaeamao tau, ");
INSERT INTO bch_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ta naoangga nala nagera kadonga toa tikakado ta naoatai, led kadonga papaeamao mambe selelenga toa nalongo ne, mao madongan?” ");
INSERT INTO bch_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Ga kus ta panua rua tidae ta tilalala ga tila Sodom, be Abraam idio toman ngan Maron. ");
INSERT INTO bch_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ta Abraam ila boloma pan ta ibeta ei bedane, “Be eao ga paeabu ngan panua tututui toman ngan panua papaeamao na? ");
INSERT INTO bch_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Be oangga panua tututui sangalima timamado ngan tuanga toa oa, eine gau madongan? Eao ga paeabu ngan gid pade? Be irangrang ngan matam nanan gid panua tututui toa sangalima oa, ta lolom isat ngan tuanga toa oa ta paeabu ngan gid mao? ");
INSERT INTO bch_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Eao oangga paeabu ngan panua tututui toman ngan panua papaeamao, eine kemi mao. Ngan kado ta lem kadonga pagid panua tututui ga panua papaeamao iuot lalaede. Be eao ga nasi kadonga tutui, na? Ngansa eao madid mambe eaba patutuinga posanga aea ngan gid panua toa ngada ne tanoeai.” ");
INSERT INTO bch_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Ta Maron ikoli ele posanga bedane, “Oangga nagera panua tututui sangalima toa tuangai oa, eine ga matag nanan gid ta lolog isat ngan tuanga aea panua toa ngada oa.” ");
INSERT INTO bch_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ta Abraam ikeo pade bedane, “Ag Maron, ega, gau mambe danga sapaean tanoeai aea, be longean gau ta naposa pade pago. ");
INSERT INTO bch_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Oangga panua tututui dabad imata karanga mao, be gid sangaul pange igegea lima mon timamado, eine gau madongan? Eao ga paeabu ngan tuanga aea panua toa ngada oa oangga gera panua tututui lima timamado mao?” Ta ikeo, “Oangga nagera panua tututui sangaul pange igegea lima, eine ga napaeabu ngan tuanga toa oa mao.” ");
INSERT INTO bch_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ta Abraam ikado posanga pan pade bedane, “Be oangga panua tututui sangaul pange mon timamado, eine gau madongan?” Ta ikeo, “Oangga nagera panua tututui sangaul pange, eine ga napaeabu ngan tuanga toa oa mao.” ");
INSERT INTO bch_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Ta Abraam ikeo, “Ag Maron, eao malmal pagau padam. Be gau ga naposa pade pago. Oangga panua tututui sangaul tol mon timamado, eine gau madongan?” Ta ikeo, “Oangga nagera panua tututui sangaul tol, eine ga napaeabu ngan tuanga toa oa mao.” ");
INSERT INTO bch_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ta Abraam ikeo, “Ag Maron, tautaunga leg posanga pago busa tau, be longean gau ta naposa pade pago. Oangga panua tututui sangaul rua mon timamado, eine gau madongan?” Ta ikeo, “Oangga nagera panua tututui sangaul rua, eine ga napaeabu ngan mao.” ");
INSERT INTO bch_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ta Abraam ikeo pade bedane, “Ag Maron, eao malmal pagau padam, be gau ga naposa pakelede pade. Oangga panua tututui sangaul mon timamado, eine gau madongan?” Ta ikeo, “Oangga nagera panua tututui sangaul, eine ga napaeabu ngan tuanga toa oa mao.” ");
INSERT INTO bch_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Io, Maron iposa toman ngan Abraam ga kus ta itnan ei ga ila, be Abraam iluai mulian ele saupuiai. ");
INSERT INTO bch_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ngan bong toaiua gid anggelo toa rua oa tila tiuot Sodom. Be Lot imamado ngan tibur rourounga aea boloma ngan tuanga aea atama kapei. Ei igera gid ta idae ga ila pagid. Ikor iae ta idol ilabora ga isulug tanoeai ");
INSERT INTO bch_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","ta ikeo, “Ega, mamaron, kemi ngan gimirua anam leg lumaeai. Gau mambe lemi paeaeanga. Kemi ngan gimirua asigiri aemi ta aeno leg lumaeai. Ta gaisala rumaruma, gimirua adae ta alalala pade.” Be gid tikeo, “Mao. Gai ga aeno nene ngan tibur rourounga aea.” ");
INSERT INTO bch_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Be Lot iparpar tau ngan gisirua ta tila ele lumaeai. Tota ikado ad annga ta inono ad bret toa aea yis ienono ngan mao, ta tian. ");
INSERT INTO bch_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Gisirua tila tieno maitne, be gid arangaranga busa ngan tuanga Sodom tinam tibaliu ngan luma toa oa. Gid arangaranga toa ngada oa tinam, gid kapeipei ga kakau iririau pade. ");
INSERT INTO bch_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Ta tibaba ga ila pan Lot bedane, “Panua toa rua na tinam pago labone bong, timamado sida? Bada gid ga tinam pagai ta akado arala ngan gid.” ");
INSERT INTO bch_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Be Lot iuot ga ila ele atama iaoai, ta isaisai ele atama toa imuriai oa, ");
INSERT INTO bch_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","ta ikeo, “Oaeoaeg, akado kadonga paeamao toa ne padam! ");
INSERT INTO bch_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Ega, natug taine blalala rua timamado, tieno toman ngan eaba eta maitne. Gau ga nabada gisirua ga tila pagimi, ta gimi akado saoa danga ngan gid mambe akim. Be arangaranga toa rua ne tinam pagau mambe ag kaluae. Ta gau manta namariala ngan gisirua. Tota akado kadonga eta ngan gisirua mao.” ");
INSERT INTO bch_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Be gid panua Sodom tikeo bedane, “Gera. Eaba patpatnga aea toa ne iuangga iuot mambe ada madidnga patutuinga posanga aea!” Ta tikeo pan Lot, “Eao la aluai! Kadonga paeamao gai ga akado ngan eao, eine ga iasal kadonga toa ga akado ngan gisirua.” Io, tisusuran Lot ta tiuangga tigoro ele atama. ");
INSERT INTO bch_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Be panua rua toa gadudunga oa, baged iuot ta tidada Lot ga idudunga mulian ta tisaisai atama pade. ");
INSERT INTO bch_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ga kus ta tikado panua toa ngada oa gaot ga matad sususu. Gid kapeipei ga gid kakau pade tirangrang ngan tigeragera mao be ikulupu ngan tilo atama ta tidabdab alele. ");
INSERT INTO bch_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Panua toa rua oa tibeta Lot bedane, “Be eao lem panua etangada toa nene pade? Lem gergeu arangaranga ga taine etangada, mao laoalaoam etangada timamado? Manta bada gid ta amingada aeaoa ngan tuanga toa ne. ");
INSERT INTO bch_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ngansa gairua aoangga apaeabu ngan tuanga toa ne. Maron ilongo posanga selelenga kapei tau ngan gid panua toa ne, ta isula gai ga anama apaeabu ngan tuanga toa ne.” ");
INSERT INTO bch_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Be Lot ilaoalaoa rua tiuangga tiuai inat taine toa rua oa. Ta Lot ila pagisirua ta ikeo, “Manmanae, adae ta aeaoa ngan tuanga toa ne, ngansa Maron iuangga ipaeabu ngan.” Be ilaoalaoa toa rua oa tiuangga ei igalgalinge. ");
INSERT INTO bch_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Gaga itakai ta anggelo toa rua oa aoad isensen Lot bedane, “Manmanae! Bada adaoam ga natum taine toa rua ne ta aeaoa ngan tuanga. Ngan kado ta gimi amukuru toman ngan tuanga toa ne aea panua ngan ad panasnga.” ");
INSERT INTO bch_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Be Lot ikado aea gerei. Ta panua toa rua oa tikisi ibage matua toman ngan iadaoa ga inat taine rua baged, ta tibada gid ga tila gaot ngan tuanga, ngansa Maron ilolo isat ngan Lot. ");
INSERT INTO bch_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tibada gid ga tiuot ga kus ta ede ngan gid ikeo, “Aeaoa manmanae! Ngan kado amate. Matami kleng ga iluai mulian mao ga aearagimi ngan tibur eta dubuiai mao pade. Aeaoa ga ala bereoeai. Ngan kado ta amate.” ");
INSERT INTO bch_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Be Lot ikeo pagisirua, “Aiao, mamaron, gau narangrang ngan kadonga bedane mao. ");
INSERT INTO bch_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Ega, lemi luanga ga lolomi isat ngan gau eine kemi, be gau narangrang ngan naeaoa manmanae ga nala bereoeai mao. Gau ga naot bereoeai maitne, be danga paeamao ga ibada gau pade ta namate. ");
INSERT INTO bch_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ega, tuanga ede ga boloma na. Gau narangrang ngan nalado manmanae ga nala ngan. Eine tuanga kakauede. Longo ngan gau nala toa eoa ta nasapir ngan panasnga paeamao toa na.” ");
INSERT INTO bch_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ta ikoli ele posanga bedane, “Goibe. Gau ga nalongo ngan lem posanga toa ne pade, ta napaeabu ngan tuanga kakauede toa na mao. ");
INSERT INTO bch_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Be la manmanae! Ngansa gau ga nakado danga eta mao, ga irangrang ngan gimi aot toa eoa.” Ngan ipu toaine tiuato tuanga toa oa ieda Soar. ");
INSERT INTO bch_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Ado ipara ga idae, ta Lot ila iuot ngan tuanga Soar. ");
INSERT INTO bch_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Be mole mao, Maron ikado dinga ga gid pat kaeau kakatol ga itaptap buburiai ga isulug ngan tuanga Sodom ga Gomora. ");
INSERT INTO bch_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tota ipaeabu ngan gid tuanga toa oa toman ngan aea dubu kapei. Gid panua toa ngada oa timukuru ngan tano toa oa toman ngan gid abei. ");
INSERT INTO bch_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Lot iadaoa inasi ei ga ila, be imata kleng ta imate. Be mole mao ipat iuot mambe sol aea suknga ede ta imadmadid mambe kadanga. ");
INSERT INTO bch_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Be gaisala rumaruma, Abraam idae ta iluai mulian ga ila ngan tibur toa mugaeai iposaposa toman ngan Maron. ");
INSERT INTO bch_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Imata isulug ga ila ta igera basu kapei tau idaedae ngan tuanga Sodom ga Gomora, ngan tibur aea dubu kapei. Basu toa oa kapei mambe suksuknga kapei ede aea basu. ");
INSERT INTO bch_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Toa bedaoa ta Deo ipaeabu ngan gid tuanga ngan dubu kapei toa oa. Mugaeai Lot imamado ngan tuanga toa oa. Be Deo imata nanan Abraam, ta ibada Lot mulian ngan gid tuanga toa timukuru oa. ");
INSERT INTO bch_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Idio ta Lot ga inat taine toa rua oa titnan tuanga Soar ta tila timado bereoeai ngan pat kapei ede aea baba, ngansa Lot imataud ngan madonga Soar. ");
INSERT INTO bch_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Be ado ede taine lautabe ikeo pan itar kakau bedane, “Gera. Tamada ei eaba kapei na. Be tibur toa ne aea eaba eta mao. Tota leda edap eta ngan kadonga mambe panua toa ngada ne tanoeai tikakado ne mao. ");
INSERT INTO bch_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Be kemi ngan tapaun tamada ngan oain ta ilabora imangamanga. Ta taeno toman ngan ei, ta ipapot gergeu pagitarua. Toa bedaoa ta gita iaoa toaine irangrang ngan kus mao.” ");
INSERT INTO bch_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tota ngan bong toaiua tipaun tamad ngan oain ta ilabora imangamanga. Ta gergeu lautabe ila ieno toman ngan ei. Be ei iuatai ngan inat taine ele namanga mao ga ngan ele luainga mao pade. ");
INSERT INTO bch_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ado sae taine lautabe ikeo pan itar kakau bedane, “Ega, made bong naeno toman ngan tamada. Be labone bong tapaun ei pade ta eao la eno toman ngan ei. Toa bedaoa ta ipapot gergeu pagita, ta gita iaoa toaine irangrang ngan kus mao.” ");
INSERT INTO bch_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Io, tipaun tamad ngan oain ta ilabora imangamanga ngan bong toaiua pade. Ta taine toa oa itar kakau, ei pade ila ieno toman ngan tamad. Be Lot iuatai ngan inat taine ele namanga mao ga ngan ele luainga mao pade. ");
INSERT INTO bch_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Toa bedaoa ta Lot inat taine toa rua oa apad pan. ");
INSERT INTO bch_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Idio ta inat taine lautabe ipopo gergeu aranga ta iuato ieda Moap. Ta muriai gergeu toa oa itubtub tiuot alu toa labone taoatoato gid Moap. ");
INSERT INTO bch_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Be Lot inat taine ede pade ipopo gergeu aranga pade ta iuato ieda Benami. Ta muriai gergeu toa oa itubtub tiuot alu toa labone taoatoato gid Amon. ");
INSERT INTO bch_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Idio ta Abraam itnan Mamre ele tuanga ta ila imado ngan tibur kapei Negev, rabu ngan tuanga Kades ga Sur. Be ila imado tede ngan tuanga Gerar. ");
INSERT INTO bch_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Be Abraam ikeo pagid panua Gerar ngan iadaoa Sara ta ikeo ga, “Ei gau liug.” Tota Abimelek, maron kapei togid Gerar, isula ele paeaeanga ga tila tibada Sara ga inam pan. ");
INSERT INTO bch_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Be ngan bong toaiua Abimelek ieno. Ngan ianun Deo ikeo pan bedane, “Ega, taine toa eao bada na, ei oainga. Tota eao ga mate!” ");
INSERT INTO bch_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Be Abimelek ieno toman ngan Sara maitne ta ikeo pan Deo bedane, “Maron, oangga eaba ele idil eta paeamao mao, eao ga paeabu ngan ei toman ngan ele panua pade? ");
INSERT INTO bch_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ngansa ei ikeo pagau mambe Sara ei iliu. Be Sara pade ikeo ga Abraam ei iliu. Gau nabada taine toa ne, be naoangga leg kadonga itutui mon. Leg idil eta paeamao mao.” ");
INSERT INTO bch_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Be Deo ikoli ele posanga ngan ianun bedane, “Gau naoatai, eao oangga lem kadonga itutui ta kado bedane. Tota napakala eao ngan enonga toman ngan ei, ta eao kado kadonga sat matageai mao. ");
INSERT INTO bch_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Be eao manta palua ei ga iluai mulian pan iadaoa. Ngansa eaba toa oa ibabada aoag ga ila pagid panua. Ta ei ga iraring ngan luanga eao ta eao ga mate mao. Be oangga eao palua ei ga iluai mulian mao, eine eao ga mate toman ngan lem panua toa ngada na.” ");
INSERT INTO bch_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Io, gaisala rumaruma ngan ado sae, Abimelek idae ta ibaba ele madidnga toa ngada oa ga tinam pan, ta ikeo pagid ngan Deo ele posanga toa ngada oa. Tota timataud kapei. ");
INSERT INTO bch_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Ta Abimelek ibaba Abraam ga inama ta ibeta ei bedane, “Eao kamado kado bedane ngan gai? Gau leg idil isaoa paeamao pago ta eao kado ta gaingada leg panua toa bagegeai ne lemai kadonga sat kapei bedane? Lem kadonga toa ne itutui mao.” ");
INSERT INTO bch_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ta Abimelek ikeo pan Abraam pade bedane, “Lem ipu isaoa ta kado toa bedane ngan gai?” ");
INSERT INTO bch_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ta Abraam ikoli ele posanga bedane, “Gau nakeo lologeai bedane, ‘Panua ngan tuanga toa ne tilolon ngan Deo mao. Oangga tikim adaoag, eine ga tipaeaoa ei be tipamate gau.’ ");
INSERT INTO bch_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Be tautaunga ei gau liug. Gairua tamamai kelede, be ei itna ede pade, gau tnag ede pade. Be naoai ei. ");
INSERT INTO bch_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Mugaeai, Deo ikeo ga natnan tamag ele luma ta nala alele ngan tibur padengada, be gau nakeo pan Sara bedane, ‘Oangga lolom ikim gau tautaunga, eao keo pagid panua ngan tuanga toa ngada ne mambe eao gau liug.’” ");
INSERT INTO bch_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Idio ta Abimelek ibada Sara ga iluai mulian pan Abraam, ta ipan Abraam ele sipsip ga bulmakao ga paeaeanga arangaranga ga taine. ");
INSERT INTO bch_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Ta Abimelek ikeo, “Ega, tano toa ngada ne togau. Be oangga eao kim dio mado ngan tibur eta, goibe la mado ngan.” ");
INSERT INTO bch_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Be ikeo pan Sara bedane, “Ega, gau napan lium ele pat silva bunoringring. Eine ngan patutuinga idil toa ne ngan eao. Toa bedaoa ta panua toa ngada ne tiuatai, eao lem idil eta paeamao mao.” ");
INSERT INTO bch_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Idio ta Abraam iraring ga ila pan Deo, ta Deo ikado kemi Abimelek ga iadaoa ga ele taine paeaeanga, ta irangrang ngan tipopo gergeu pade. ");
INSERT INTO bch_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Ngansa Maron iuangga ipanas Abimelek ngan ele idil paeamao ngan Abraam iadaoa Sara, ta mugaeai ipakala Abimelek ele taine toa ngada oa ngan poponga gergeu. ");
INSERT INTO bch_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Idio ta Maron imata nanan Sara ngan luanga ei ta ikado kadonga kemi ngan ei lalaede mambe iposa tautaunga ngan mugaeai. ");
INSERT INTO bch_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sara iapa ta ipopo Abraam ele gergeu aranga. Abraam ei eaba kapei, be Sara ipopo ele gergeu tutui ngan taiko toa mugaeai Deo ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ta Abraam iuato gergeu toa iadaoa ipopo oa ieda Aisak. ");
INSERT INTO bch_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Be ado lima ga tol muriai ngan Aisak aea poponga, Abraam ipalu ei mambe Deo ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraam aea rai buno, be iadaoa ipopo inat Aisak. ");
INSERT INTO bch_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ta Sara ikeo, “Deo ikado ga tinig igelgel ta nanging. Ta panua toa ngada ne tilongo bedane, eine ga tinging pade toman ngan gau.” ");
INSERT INTO bch_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ta Sara ikeo pade bedane, “Mugaeai sai irangrang ngan ikeo pan Abraam ngan iadaoa Sara ga ipopo ele gergeu ta ipadud ei? Abraam ei eaba kapei na, be gau napopo ele gergeu aranga!” ");
INSERT INTO bch_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Idio ta Aisak idae kapei ta iaoa tnan tud. Be ngan ado toaiua, Abraam ikado eaneannga kapei ngan imata nanan ele gergeu iaoa tnan tud. ");
INSERT INTO bch_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Be Sara igera gergeu ton Agar, taine Isip aea, igalgalinge paeamao ngan Aisak. ");
INSERT INTO bch_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Tota Sara ikeo pan Abraam bedane, “Suk taine paeaeanga toa ne toman ngan ele gergeu! Ngansa oangga eao mate, irangrang ngan lem danga etangada ila pan gergeu toa oa mao ga mao tau. Gau leg gergeu Aisak ga ibada lem danga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Be posanga toa ne ikado ga Abraam ilolo ede ga ede tau, ngansa Ismael ei pade Abraam ele gergeu. ");
INSERT INTO bch_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Be Deo ikeo pan Abraam bedane, “Eao lolom ede ga ede ngan gergeu toa oa ga itna padam. Saoa posanga Sara ikeo pago ngan, eao kado, ngansa gid gergeu busa toa naposa tautaunga pago ngan, eine ga tiuot ngan Aisak. ");
INSERT INTO bch_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Be gergeu ton taine paeaeanga, gau ga nakado ga itubtub tiuot alu kapei, ngansa ei pade eao lem gergeu.” ");
INSERT INTO bch_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Io, ado sae gaisala rumaruma Abraam ibada annga idanga ede ga meme itin kukul iuon ngan eau, ta idol Agar ikepeai. Ga kus ta isula ei ga inat ga tila. Ta gisirua tilalala alele ngan tibur modamodanga ieda Berseba. ");
INSERT INTO bch_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Idio ta eau toa ienono ngan meme itin kukul oa kus. Tota Agar idol gergeu toa oa ga idio ieno abei kakauede ipuiai. ");
INSERT INTO bch_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Ga kus ta ila ga tedaoa mambe tutupi ele tapnga ta idio imado. Ngansa ikeo iloleai bedane, “Gau tinig ngan geranga leg gergeu ele matenga mao.” Ei idio imado be itangtang kapei. ");
INSERT INTO bch_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Be Deo ilongo gergeu toa oa itangtang, ta anggelo ton Deo toa imamado buburiai ibaba ga ila pan Agar bedane, “Agar, eao kamado? Mataud mao. Lem gergeu toa ienono nena, Deo ilongo ele tandanga na. ");
INSERT INTO bch_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","La soa ei ga idae ta kisi ei ngan bagem. Ngansa gau ga nakado ele gergeu ga itubtub ga tiuot alu kapei.” ");
INSERT INTO bch_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Idio ta Deo ikado ga Agar imata idae ta igera eau ede aea baba. Tota ila ied ngan meme itin kukul ta ibada ga ila pan inat ta iun. ");
INSERT INTO bch_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Idio ta Deo imata kikisi gergeu toa oa ga idae kapei. Ei imamado ngan tibur modamodanga be ele oatainga kapei ngan pandenga aea galgalnga. ");
INSERT INTO bch_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Imamado ngan tibur modamodanga ieda Paran. Be ado ede, itna ibada taine ede Isip aea ga iman iadaoa. ");
INSERT INTO bch_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Ngan ado toaiua, Abimelek toman ngan ele madidnga paraunga aea ieda Pikol tila pan Abraam ta tikeo bedane, “Ngan danga toa ngada ne eao kakado, Deo ilualua go. ");
INSERT INTO bch_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tota nakim eao posa tautaunga Deo imatai, ta irangrang ngan eao kado kadonga eta pakakanga pagau mao, ga pagid leg gergeu ga tibutibug mao pade. Ngansa gau leg kadonga kemi ngan eao. Toa bedaoa ta eao manta kado kadonga kemi pagau ga pagid panua ngan tibur kapei togau pade, mambe gau nakado ngan eao ngan ado toaiua eao nama nene ta mamado mambe kaluae ga irangrang ngan labone.” ");
INSERT INTO bch_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ta Abraam ikeo, “Naposa tautaunga. Gau ga nakado toa bedaoa.” ");
INSERT INTO bch_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ga kus ta Abraam iselele Abimelek, ngansa ele paeaeanga tisio eau aea baba ede ton Abraam ga iman led. ");
INSERT INTO bch_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Ta Abimelek ikeo bedane, “Gau naoatai mao ngan sai ikado kadonga toa oa. Eao keo pagau mugaeai ngan mao. Patautene nalongo posanga toa ne.” ");
INSERT INTO bch_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Ta Abraam ipan Abimelek ele sipsip ga bulmakao edengada, ta gisirua tirau posanga. ");
INSERT INTO bch_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ta Abraam ibada ele sipsip taine gereirei lima ga rua, ta idol gid ga tidio rol ngan sipsip padengada. ");
INSERT INTO bch_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Ta Abimelek ibeta Abraam bedane, “Gid sipsip taine gereirei toa eao dol ga tidio rol ne timan saoa aea?” ");
INSERT INTO bch_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ta ikeo, “Eao bada gid sipsip toa lima ga rua ne. Eine iman kilala ngan pasolannga mambe loloda kelede ngan eau aea baba toa ne, eine gau nalei.” ");
INSERT INTO bch_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ta gisirua tirau posanga ngan tibur toa oa. Tota tiuato tibur toa oa ieda Berseba. ");
INSERT INTO bch_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Gisirua tirau posanga ngan tibur Berseba ga kus ta Abimelek ga ele madidnga paraunga aea, toa Pikol, tiluagid mulian ga tila led tuangai ngan tibur kapei togid Pilistia. ");
INSERT INTO bch_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Idio ta Abraam iarum abei esel ede ngan tibur Berseba, ta ibaba ga ila pan Maron ta isoa ieda. Ngansa ei Deo toa imamado somisomi ne. ");
INSERT INTO bch_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Ta Abraam idio imamado mole tede ngan tibur togid Pilistia. ");
INSERT INTO bch_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Idio ga muriai ta Deo itoba Abraam, ngansa iuangga iuatai ngan ilolo. Ta ikeo, “Abraam!” Ta Abraam ikeo, “Gau ta eko.” ");
INSERT INTO bch_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Ta ikeo, “Gau naoatai, natum toa kelede na Aisak, eao kim ei tau. Be nakim eao bada ei ta gimirua ala ngan tibur ede ieda Moria, ngan bereo ede toa gau ga napasolan pago. Gau nakim eao pamate ei toa eoa ta dol ei ga idae dingaeai ta iman lem tenainga ga inam pagau, ta dinga inono ga imomout ga kus.” ");
INSERT INTO bch_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Io, gaisala rumaruma ngan ado sae Abraam idae ta idol danga tulua aea ga idae donki ipaoeai. Ibada Aisak ga ele paeaeanga rua ta tila toman ngan ei. Ikorkor gid abei dinga aea iman tenainga aea nononga, ga kus ta gisingada tila ngan tibur toa Deo ikeo pan ngan oa. ");
INSERT INTO bch_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Ado tol ila ga kus ta Abraam imata idae ta igera tibur toa oa boloma tede. ");
INSERT INTO bch_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Ta ikeo pagid ele paeaeanga bedane, “Gimirua adio nene toman ngan donki, be gairua natug ga ala ga eoa. Asoa Deo ieda ga kus ta aluagai mulian pagimi.” ");
INSERT INTO bch_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Io, Abraam ibada gid abei dinga aea ta idol ga idae Aisak ikepeai ta ibisi. Be ei ibada dinga ga didi. Ta gisirua tilalala ga tila. ");
INSERT INTO bch_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Be Aisak ikeo pan itama Abraam bedane, “Apa?” Ta ikeo, “Natug, gau ta eko.” Ta Aisak ibeta ei, “Ega, leda dinga ga abei ienono, be sipsip tenainga aea sida?” ");
INSERT INTO bch_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ta Abraam ikeo, “Natug, Deo kekelen ga ipan leda sipsip tenainga aea.” Ta gisirua tilalala ga tila. ");
INSERT INTO bch_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Idio ta tiuot ngan tibur toa Deo ikeo pan ngan oa. Ga kus ta Abraam ipagun popou tenainga aea ta ilalo gid abei ga idae popou ipaoeai. Be ikaukau inat Aisak ta isoa ei ga idae popouiai, gadae ngan gid abei. ");
INSERT INTO bch_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Io, ibage ila ibada didi, ta iuangga ipamate inat. ");
INSERT INTO bch_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Be mao. Anggelo ton Maron ibaba buburiai ga isulug ta ikeo, “Abraam, Abraam!” Ta ikeo, “Gau ta eko.” ");
INSERT INTO bch_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ta anggelo ikeo, “Pamate natum padam. Kado kadonga eta ngan ei mao. Labone gau naoatai, eao lolon ngan Deo kapei. Ngansa eao dangadangan natum toa kelede na pagau mao.” ");
INSERT INTO bch_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Be Abraam imata kleng ta igera sipsip aranga ede aea pelenga kas ngan abei iboga. Ta ila iluku ga inam ta ipamate. Ga kus ta inono ngan dinga. Ta sipsip toa oa ibada inat Aisak imul ta iman ele tenainga ga ila pan Deo. ");
INSERT INTO bch_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Tota Abraam iuato tibur toa oa ieda “Maron ipan leda.” Toa bedaoa ta labone pade panua tikakado posanga idil toa ne, “Ngan bereo ton Maron, ei ga ipan leda.” ");
INSERT INTO bch_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Be anggelo ton Maron ibaba parua aea buburiai ga isulug ta ikeo pan Abraam, ");
INSERT INTO bch_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“Gau Maron, naposa tautaunga ngan gau edag bedane: Eao dangadangan natum toa kelede na pagau mao, ");
INSERT INTO bch_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","tota gau ga nakado kemi tau ngan eao. Ta gau ga nakado ga lem gergeu ga tibutibum tiuot busa mambe gid gigima mariambai ga mambe riringa lab aea. Be tibutibum ga tiasal ad miri itamatama ngan paraunga ta tibada led tuanga ga iman led. ");
INSERT INTO bch_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Be kadonga kemi toa nakado ngan tibutibum, eine ga iparangrang alu toa ngada ne tanoeai, ngansa eao longo lingeg.” ");
INSERT INTO bch_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ga kus ta Abraam ga inat Aisak tiluagid mulian ga tila pagid ele paeaeanga. Ta gisingada tilalala ga tila Berseba. Ta Abraam imamado mole tede toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Idio ga muriai ta Abraam ilongo posanga bedane, “Ega, tadim kakau Naor iadaoa Milka ipopo gergeu edengada.” ");
INSERT INTO bch_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Gid gergeu toa ne edad ga bedane: Us ei lautabe ga itar kakau Bus ga Kemuel, toa Aram itama, ");
INSERT INTO bch_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ga Keset ga Aso ga Pildas ga Jitlap ga Betuel. ");
INSERT INTO bch_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuel ei Rebeka itama. Milka ipopo gid gergeu arangaranga toa lima ga tol ne ton Naor toa Abraam itar kakau. ");
INSERT INTO bch_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Be Naor iuai ele taine paeaeanga ede ieda Reuma. Ta ei ipopo Teba ga Gaam ga Taas ga Maka. ");
INSERT INTO bch_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sara aea rai buno ede sangaul rua igegea lima ga rua (127) ");
INSERT INTO bch_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","ga kus ta imate ngan tuanga Kiriat-Arba ngan tibur kapei Kenan. Tuanga toa oa ieda ede pade Ebron. Tota Abraam ilolo isat ga itangtang ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Ga kus ta itnan Sara ipat ga idio ta idae ga ila iposaposa toman ngan gid It. Ta ikeo, ");
INSERT INTO bch_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Gau tuanga itama mao, be nanam namamado pagimi mambe kaluae. Be adaoag imate, ta gau nakim naol tano idanga tede pagimi ta irangrang ngan nataian ag burua mate.” ");
INSERT INTO bch_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Ta gid panua It tikoli ele posanga bedane, ");
INSERT INTO bch_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Eaba kapei, longo. Eao maron kapei ede rabu ngan gai. Eao taian am burua mate ngan denga kemi eta togai. Eaba eta ngan gai ga idangadangan aea tano pago mao.” ");
INSERT INTO bch_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Io, Abraam idae ta ikor iae ga idol ilabora ga isulug tanoeai ta ilolon ngan gid It. ");
INSERT INTO bch_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Ta ikeo pagid, “Oangga lolomi kemi ngan nataian ag burua mate ngan ami tano, tota alongo leg posanga. Gau nakim gimi abeta Epron, gergeu ton Soar, ");
INSERT INTO bch_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ta pat kapei aea baba toa ienono ngan ele tibur ieda Makpela, gau ga naol pan toa gimi matamiai ga iman leg. Baba toa oa ienono digedige ngan aea tano. Gimi abeta ei ngan gau napan tano toa oa aea olnga dodol ga ila pan, ta iman amai denga aea.” ");
INSERT INTO bch_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Be Epron imamado rabu ngan gid panua It ad toa tirourou ngan tuanga toa oa aea atama iaoa. Ta ikoli Abraam ele posanga toa gid It matadeai bedane, ");
INSERT INTO bch_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Eaba kapei, longo. Eao ol tano toa oa mao. Ngan panua toa ngada ne matad, gau napan sapaean pago. Tano toa oa toman ngan pat kapei aea baba ga iman ami denga aea. Tota taian am burua mate ngan.” ");
INSERT INTO bch_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Io, Abraam ikor iae ga idol ilabora ga isulug tanoeai ta ilolon ngan gid It pade. ");
INSERT INTO bch_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Ta gid tano itamatama matadeai, ei ikeo pan Epron bedane, “Gau nakim eao longo leg posanga. Nakim naol tano toa oa pago. Bada leg pat toa ne, ta gau nataian ag burua mate toa eoa.” ");
INSERT INTO bch_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Ta Epron ikoli Abraam ele posanga bedane, ");
INSERT INTO bch_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Eaba kapei, longo. Tano toa ne aea olnga pat silva buno pange mon. Be ngan gitarua, pat toa ne eine danga sapaean. Taian am burua mate.” ");
INSERT INTO bch_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Io, Abraam ilongo posanga toa ne, ta iuade tano toa oa aea olnga mambe Epron ikeo ngan toa gid It matadeai. Iuade ngan pat lalaede mambe togid panua oalo ad. ");
INSERT INTO bch_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Toa bedaoa ta Abraam ibada tano toa oa ton Epron ga iman ei aea. Tano toa oa ienono ngan tibur Makpela boloma ngan tuanga ton Mamre. Abraam ibada tano toa oa ga pat kapei aea baba toman ngan gid abei toa ngada oa timadmadid ga tibalil ngan tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Gid It toa tirourou ngan tuanga toa aea atama iaoa, tigera Abraam iuol tano toa oa ga iman ei aea. ");
INSERT INTO bch_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ga kus ta Abraam itaian iadaoa Sara ngan pat kapei aea baba, ngan tibur Makpela boloma ngan Mamre ele tuanga Ebron ngan tibur kapei Kenan. ");
INSERT INTO bch_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tota tano toa oa idanga tede togid It toman ngan pat kapei aea baba ienono ngan, iman denga ton Abraam. ");
INSERT INTO bch_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraam ei eaba kapei na. Be Maron ikado danga toa ngada oa iuotot pan kemikemi mon. ");
INSERT INTO bch_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ta Abraam ibaba ele paeaeanga ede toa eaba kapei ga inam pan. Paeaeanga toa oa imariala ngan Abraam ele danga sisid toa ngada oa. Ta Abraam ikeo pan bedane, “Dol bagem ga idio buleg ibuloloeai, ");
INSERT INTO bch_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","ta kado posanga tautaunga ngan Maron Deo ieda. Ei Deo ngan bubur ga tano. Kado posanga tautaunga ngan danga ga oaine. Ngan tano Kenan toa namamado ngan ne, eao rangrang ngan bada taine eta ga iman natug iadaoa mao. ");
INSERT INTO bch_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Be eao manta la ngan ag tuanga ipu pagid sobosobog ta bada natug Aisak iadaoa eta.” ");
INSERT INTO bch_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Be paeaeanga toa oa ibeta ei bedane, “Be oangga taine toa oa itin ngan itnan ele tuanga ga inama nene toman ngan gau mao, eine gau madongan? Eine ga nabada natum ga ila am tuanga ipuiai pade?” ");
INSERT INTO bch_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ta Abraam ikeo, “Eao rangrang ngan bada natug ga ila toa eoa mao. ");
INSERT INTO bch_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Maron toa ei Deo ngan bubur, ibada gau ta natnan tamag ele tuanga ga leg panua ad tano, ta ikado posanga tautaunga pagau bedane, ‘Gau ga napan tano toa ne ga iman tibutibum ad.’ Ei ga isula ele anggelo ta ila imuga ngan eao, ta eao rangrang ngan bada natug iadaoa eta toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Be oangga taine itin ngan inam toman ngan eao mao, goibe, matam sapian posanga tautaunga toa eao kado ne. Be bada natug ga ila ngan ag tuanga ipu padam.” ");
INSERT INTO bch_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tota Abraam ele paeaeanga idol ibage ga idio aea maron Abraam ibule ibuloloeai ta ikado posanga tautaunga ngan nasinga ele posanga toa oa. ");
INSERT INTO bch_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Paeaeanga toa oa ibada aea maron Abraam ele kamel sangaul ga gid gerebo kemikemi ton Abraam, ga kus ta ikakai ga ila Naor ele tuangai ngan tibur kapei Aram-Naaraim. ");
INSERT INTO bch_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ado edengada ga kus ta ei iuot toa eoa ta ikado gid kamel ga tidio tieno boloma ngan eau ede aea baba, boloma tuangai. Eiua lailai ngan ado imata toa gid taine tila ngan ednga eau. ");
INSERT INTO bch_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ta iraring bedane, “O Maron, Deo ton ag maron Abraam, nakim eao lolom isat ngan ag maron, ta kado leg lalalanga labone ga iuot kemi. ");
INSERT INTO bch_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Ega, gau namadmadid eaumata isaleai ne, be gid taine blalala tuangai ad tinam tieded eau. ");
INSERT INTO bch_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Be gau ga nakeo pan taine blala eta ga bedane, ‘Irangrang ngan eao dol lem ulo eau aea ga isulug ta naun teta?’ Be oangga ikeo, ‘Goibe, un, ta gau ga napaun lem kamel pade.’ Io, gau nakim eao sio taine tota nena ga iman lem paeaeanga Aisak iadaoa. Oangga gid danga iuot toa bedaoa, eine ga naoatai mambe eao lolom isat ngan ag maron ta lua ei.” ");
INSERT INTO bch_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Io, ei iraring maitne, be Rebeka ibisi ulo ede eau aea ga inam iuot. Ei Betuel inat taine. Be Betuel ei Naor ga Milka natud. Be Naor ei Abraam itar kakau. ");
INSERT INTO bch_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Be taine toa oa namelapau. Ei ieno toman ngan eaba eta maitne. Ei isulug ga ila eaumatai ta ied eau, ga kus ta idae mulian ga inam. ");
INSERT INTO bch_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Be paeaeanga toa oa ila manmanae pan ta ikeo, “Irangrang ngan naun eau kauteta ngan lem ulo na?” ");
INSERT INTO bch_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Ta ikeo, “Goibe eaba kapei, nam un.” Ta manmanae isoa ulo ga isulug ta ibada pan ta iun. ");
INSERT INTO bch_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Ei iun ga kus ta taine toa oa ikeo, “Gau ga napaun lem kamel pade, ga irangrang ngan tiun ga itara gid.” ");
INSERT INTO bch_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Tota itok eau ngan ulo toa oa manmanae ga ila ngan gid kamel ad golomada. Ga kus ta ilado mulian ga ila ngan eau aea baba toa oa ta ied pade ga irangrang ngan ele kamel toa ngada oa tiun ga itara gid. ");
INSERT INTO bch_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Be eaba toa oa iposa eta mao. Ei imata inono taine toa oa ta iuangga iuatai, Maron ikado ele lalalanga ga iuot kemi, mao madongan. ");
INSERT INTO bch_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Idio ta gid kamel tiun ga kus ta eaba toa oa ibada bangau gol ede ga iuot toman ngan poipoi gol rua. Bangau toa oa aea olnga kapei, be poipoi gol toa rua oa kulupu ga ad olnga kapei pade. ");
INSERT INTO bch_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Ta ibeta ei bedane, “Eao sai inat taine? Be eao gera tamam ele luma irangrang ngan gai pade aeno ngan toa labone bong?” ");
INSERT INTO bch_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Ta ikeo pan bedane, “Gau Betuel inat taine. Betuel ei Naor ga Milka natud.” ");
INSERT INTO bch_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ta ikeo pade bedane, “Gid kamel ad purup ga annga busa ienono, ga lemai luma eine irangrang ngan gimi aeno ngan pade.” ");
INSERT INTO bch_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Io, eaba toa oa ilongo bedaoa ta ikor iae ta idol ilabora ga isulug tanoeai ta isoa Maron ieda. ");
INSERT INTO bch_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Ta ikeo, “Tasoa Maron ieda. Ei Deo ton ag maron Abraam. Ei ilolo isat ngan ag maron ta ikado kadonga mata tutui aea pan. Maron ibada gau ga nanam tutui ngan ag maron isobosobo!” ");
INSERT INTO bch_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Rebeka ilongo toa bedaoa ga kus ta ilado ga ila pan itna masin ta ikeo pagid ngan danga toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Be Rebeka iliu ede ieda Laban. Ei igera bangau gol toa ienono iliu inudiai ga gid poipoi gol ienono ibageai, be ilongo iliu Rebeka ininipu ngan eaba toa oa ele posanga pan. Ta ilado manmanae ga ila igera eaba toa oa imadmadid eaumatai boloma ngan gid kamel. ");
INSERT INTO bch_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ta Laban ikeo pan bedane, “Eaba kapei, Maron ikado kemi tau ngan eao. Eao kamado madmadid toa nene? Nam ta gitarua tala lumaeai. Gau nakemi luma ilolo motean ngan gimi, ga lemi kamel mulid pade.” ");
INSERT INTO bch_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Io, gisirua tila lumaeai, ta Laban ikeo pagid ele paeaeanga ta tisoa gid tulua kamel paodeai ga isulug ta tipan gid kamel ad annga. Ta ikeo pagid pade ta tibada eau ga inam ngan Abraam ele paeaeanga ga ele panua naurata ad tisigiri aed. ");
INSERT INTO bch_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ga kus ta tibada annga ga inam, be Abraam ele paeaeanga ikeo, “Gau ga naean padam ge ga irangrang ngan napalongo ngan leg posanga.” Ta Laban ikeo, “Goibe, posa ge.” ");
INSERT INTO bch_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Ta ikeo, “Gau paeaeanga ton Abraam. ");
INSERT INTO bch_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Maron ikado kemi tau ngan ag maron, ta ele pat ga danga sisid busa. Ipan ele sipsip ga meme ga bulmakao ga silva ga gol ga paeaeanga arangaranga ga taine ga kamel ga donki. ");
INSERT INTO bch_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Be ag maron iadaoa Sara, ngan ado toaiua ei taine kapei, ei ipopo ag maron ele gergeu aranga ede. Ta ag maron ipan ele danga toa ngada oa ga ila pan inat toa oa. ");
INSERT INTO bch_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Be ag maron ikeo matua pagau ta naposa tautaunga ngan danga ga oaine. Ta ikeo, ‘Ngan tano Kenan toa namamado ngan ne, eao rangrang ngan bada taine eta ga iman natug iadaoa mao. ");
INSERT INTO bch_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Be eao manta la pagid tamag isobosobo ga gid iaoa kelede togau, ta bada taine eta ga iman natug iadaoa.’ ");
INSERT INTO bch_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Ta nabeta ag maron bedane, ‘Be oangga taine toa oa itin ngan inam toman ngan gau mao, eine gau madongan?’ ");
INSERT INTO bch_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Ta ag maron ikeo, ‘Maron toa somisomi nanasnasi ilinge, eine ga isula ele anggelo ga ila toman ngan eao. Ta ei ga ikado ga lem lalalanga iuot kemi. Toa bedaoa ta eao rangrang ngan badanga taine eta pagid sobosobog ga gid iaoa kelede togau ta iman natug iadaoa. ");
INSERT INTO bch_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Be oangga eao la pagid, be tilongo ngan eao bada taine toa oa ga iman natug iadaoa mao, goibe, matam sapian posanga tautaunga toa kado pagau ne, be eao lem idil eta paeamao mao.’ ");
INSERT INTO bch_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Be labone ado, nanam naot eaumatai ta nararing bedane, ‘O Maron, Deo ton ag maron Abraam, kado leg lalalanga toa nanama ngan ne ga iuot kemi. ");
INSERT INTO bch_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ega, gau namadmadid eaumata isaleai ne, be oangga taine eta inam ngan eau aea ednga, eine ga nakeo pan bedane, “Irangrang ngan naun eau kauteta lem uloeai?” ");
INSERT INTO bch_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Be oangga ikeo, “Goibe, un, ta gau ga napaun lem kamel pade,” Maron, gau nakim eao sio taine tota nena ga iman ag maron inat iadaoa.’ ");
INSERT INTO bch_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Nararing lologeai toa bedaoa maitne, be Rebeka ibisi ulo eau aea ga inam iuot. Ei isulug ga ila eaumatai ta ied eau. Ga kus ta nakeo pan bedane, ‘Nakim naun teta.’ ");
INSERT INTO bch_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Tota manmanae isoa ulo ga isulug ta ikeo bedane, ‘Goibe un, ta gau ga napaun lem kamel pade.’ Io, naun ga kus ta ipaun leg kamel pade. ");
INSERT INTO bch_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Ta nabeta ei bedane, ‘Eao sai inat taine?’ “Ta ikeo, ‘Gau Betuel inat taine. Betuel ei Naor ga Milka natud.’ “Ikeo bedaoa pagau ga kus ta nasesean bangau gol toa oa ga idudunga inudiai ta nadol poipoi gol ibageai. ");
INSERT INTO bch_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Ga kus ta nakor aeg ga nadol laborag ga isulug tanoeai pan Maron ta nasoa Maron ieda, ei Deo ton ag maron Abraam. Ngansa ei ibada gau ga nanam tutui pagid iaoa kelede ton ag maron itar kakau, ngan badanga inat taine ede toaine ga iman ag maron inat iadaoa. ");
INSERT INTO bch_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Be oangga gimi akeo ga akado kadonga kemi ga tutui ngan ag maron, ta akeo pagau. Be oangga gimi tinimi ngan mao, tota akeo pagau pade. Toa bedaoa ga naoatai edap isaoa ga nanasi.” ");
INSERT INTO bch_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Io, Laban ga Betuel tikoli ele posanga bedane, “Danga oaine, Maron ikado ga iuot. Ta gai arangrang ngan akado posanga eta ngan mao. ");
INSERT INTO bch_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ega, Rebeka ta imamado. Bada ei ta gimirua ala. Kemi ngan iuai am maron inat, mambe Maron ikeo ngan.” ");
INSERT INTO bch_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Io, paeaeanga ton Abraam ilongo posanga toa ne ga kus ta idol ilabora ga isulug tanoeai ta isoa Maron ieda. ");
INSERT INTO bch_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Ga kus ta ibada gid sogonga kemikemi ga iuot. Ibada silva ga gol ga barikia papau ga ila pan Rebeka. Ta ibada gid gerebo kemikemi toa aea olnga kapei ga ila pan Rebeka itna ga iliu. ");
INSERT INTO bch_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Io, tian ga tiun ga kus ta Abraam ele paeaeanga ga ele panua naurata ad tila tieno. Gaisala ngan ado sae tidae ta Abraam ele paeaeanga ikeo bedane, “Nakeo ga naluagau mulian pan ag maron.” ");
INSERT INTO bch_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Be Rebeka itna ga iliu tikeo bedane, “Longean taine blala toa ne ga idio toman ngan gai irangrang ngan ado sangaul, ga kus ta ila.” ");
INSERT INTO bch_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Be Abraam ele paeaeanga ikoli led posanga bedane, “Gimi apaidi gau padam. Maron ikado leg lalalanga toa ne ga iuot kemi na. Gau nakim alongean gau ta naluagau mulian pan ag maron.” ");
INSERT INTO bch_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ta tikeo bedane, “Tababa taine toa oa ga inam ta tabeta ei ngan ilolo madongan.” ");
INSERT INTO bch_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Io, tibaba Rebeka ga inam ta tibeta ei, “Eao kim la toman ngan eaba toa ne?” Ta ikeo, “Be. Gau ga nala.” ");
INSERT INTO bch_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Idio ta tilongean Rebeka ga taine kapei ede imariala ngan ei, ta tila toman ngan Abraam ele paeaeanga ga ele panua naurata ad. ");
INSERT INTO bch_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ta tikado posanga kemi ngan pamatuanga Rebeka ta tikeo, “Liumai, eine eao ga ot panua bunoringring busa tnad. Eao tibutibum ga tibada tuanga togid ad miri itamatama ga iman led.” ");
INSERT INTO bch_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tota Rebeka toman ngan ele paeaeanga tidae ga timado kamel paodeai. Ta tinasi Abraam ele paeaeanga ga tila. Ngan kadonga toa bedaoa ta Abraam ele paeaeanga ibada Rebeka ga ila. ");
INSERT INTO bch_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Be ngan ado toaiua, Aisak imamado ngan tibur kapei Negev. (Ngansa mugaeai itnan tibur Ber-Laai-Roi ta ila imado toa eoa.) ");
INSERT INTO bch_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Be lailai ede Aisak ilalala ga ila ngan tibur aea purup kemikemi ta idio iraring. Be imata idae ta igera gid kamel tilalala ga tinam. ");
INSERT INTO bch_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Be Rebeka ei pade imata idae ta igera Aisak. Ta isulug ngan kamel ");
INSERT INTO bch_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ta ibeta paeaeanga toa oa bedane, “Eaba sai toa ilalala ga eoa ga inam pagita?” Ta paeaeanga ikeo, “Eine ag maron.” Tota Rebeka ibada ilabora aea malo ta ipamumul ngan imata. ");
INSERT INTO bch_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Idio ta Abraam ele paeaeanga ipalongo Aisak ngan danga toa ngada oa ikado. ");
INSERT INTO bch_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ta Aisak ibada Rebeka ga ila imado itna Sara ele palatai. Tota gisirua tiuai ngan gid, be Aisak ikim ei tau. Ta Aisak ilolo kemi mulian. Ngansa mugaeai ilolo isat ngan itna imate. ");
INSERT INTO bch_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Idio ta Abraam iuai taine ede pade ieda Ketura. ");
INSERT INTO bch_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ta ei ipopo Simran ga Ioksan ga Medan ga Midian ga Isbak ga Sua. ");
INSERT INTO bch_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Be Ioksan ei Seba ga Dedan tamad. Be Dedan ei gid Asur ga gid Letus ga gid Leum tibud. ");
INSERT INTO bch_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Be Midian ele gergeu arangaranga edad ga bedane: Epa ga Eper ga Anok ga Abida ga Elda. Gid iaoa toaine eine Ketura ele gergeu ga itubtub. ");
INSERT INTO bch_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Idio ta Abraam ipan ele danga sisid toa ngada oa ga ila pan inat Aisak. ");
INSERT INTO bch_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Be Abraam iuai gid ele taine paeaeanga edengada. Imamado maitne be ibada gid tenainga ga ila pagid iadadaoa toa oa led gergeu. Ga kus ta isula gid ga tila timado ado ele parangai, aluai ngan inat Aisak. ");
INSERT INTO bch_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abraam aea rai toa ngada oa iuot buno ede sangalima sangaul rua igegea lima (175). ");
INSERT INTO bch_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Ei iuot eaba kapei tau ta itin igelgel ngan ele madonga mole tanoeai. Ga kus ta imate ta ila ieno toman ngan itubtub. ");
INSERT INTO bch_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Be ele gergeu rua Aisak ga Ismael titaian ei ngan pat kapei aea baba ngan tibur ieda Makpela boloma ngan Mamre ele tuanga. Denga toa oa ienono ngan tano ton Epron, Soar inat, eaba It aea. ");
INSERT INTO bch_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Be tano toa oa, eine Abraam iuol pagid It. Ta Aisak ga Ismael titaian ei ngan denga toa mugaeai Abraam itaian iadaoa Sara ngan. ");
INSERT INTO bch_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Muriai ngan Abraam ele matenga, Deo ikado kemi tau ngan inat Aisak. Ngan ado toaiua, Aisak imamado boloma ngan tibur Ber-Laai-Roi. ");
INSERT INTO bch_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ismael aea titnga ga bedane: Ismael ei Abraam inat toa Agar ipopo. Agar ei taine Isip aea be ei Sara ele paeaeanga. ");
INSERT INTO bch_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Be Ismael ele gergeu edad ga bedane: inat lautabe Nebaiot, ga kus ta Kedar ga Atbel ga Mipsam ");
INSERT INTO bch_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ga Misma ga Duma ga Masa ");
INSERT INTO bch_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ga Adat ga Tema ga Ietur ga Napis ga Kedema. ");
INSERT INTO bch_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Eine gid Ismael ele gergeu arangaranga edad. Gid edaeda toa ne tiuatoato ngan gid iaoa toaine ad tano ga led tuanga. Gid panua toa sangaul ga igegea rua ne, timadid ga timugamuga ngan gid lum sangaul ga igegea rua. ");
INSERT INTO bch_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismael aea rai toa ngada oa iuot buno ede sangaul tol igegea lima ga rua (137). Ga kus ta imate ta ila ieno toman ngan itubtub. ");
INSERT INTO bch_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ismael ele gergeu ga itubtub tila timado ngan tibur kapei rabu ngan Avila ga Sur. Sur ienono boloma ngan Isip, ngan edap ila ngan tibur kapei Asiria. Be gid iaoa toaine timanman ariapolpol ngan gid. ");
INSERT INTO bch_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abraam inat Aisak aea titnga ga bedane: Abraam ei Aisak itama. ");
INSERT INTO bch_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Be Aisak aea rai sangaul pange ta iuai Rebeka. Rebeka ei gergeu taine ton Betuel, eaba Aram aea ngan tibur kapei Padan-Aram. Rebeka iliu eine Laban, eaba Aram aea. ");
INSERT INTO bch_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Be Aisak iadaoa Rebeka ipopo gergeu eta mao. Tota Aisak iraring ga ila pan Maron ngan luanga iadaoa. Ta Maron ilongo Aisak ele raring ta Rebeka iapa. ");
INSERT INTO bch_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Be gergeu ninnga boge rua tienono Rebeka iapai, be tipaparau. Ta Rebeka ikeo, “Ikamado ga danga toa ne iuot ngan gau?” Ei iuangga iuatai ngan danga toa ne ipu, ta ibeta Maron. ");
INSERT INTO bch_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ta Maron ikeo pan bedane, “Gergeu rua toa apameai na, eine ga tiuot alu rua. Be alu rua toa eao ga popo ne, eine ga timan ariapolpol. Ede ga iura kapei ngan ede pade. Be gergeu kapei ga iman itar kakau ele paeaeanga.” ");
INSERT INTO bch_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Io, ele ado poponga aea iuot ta ipopo gergeu ninnga boge rua. ");
INSERT INTO bch_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Gergeu toa imuga oa itin singsingia, be itin ilaun kapei. Tota tiuato ieda Iso. ");
INSERT INTO bch_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Ga kus ta ipopo itar kakau, be ibage igigiran Iso iae igub. Tota tiuato ieda Iakop. Aisak aea rai sangalima sangaul ede, be Rebeka ipopo gisirua. ");
INSERT INTO bch_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Gergeu toa rua oa tidae kapeipei, be Iso ele oatainga kapei ngan ilonga masilau tibur aea. Be Iakop ei eaba posanga aea mao. Ei mumun ga imamado saupuiai. ");
INSERT INTO bch_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Aisak ikim Iso ngansa itin igelgel ngan eannga gid masilau toa Iso ibabada. Be Rebeka ikim Iakop. ");
INSERT INTO bch_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Ado ede Iakop iliu annga ngan ulo. Be Iso iluai mulian tiburiai ga inam be pitoreanei ta itin imanggolenga tau. ");
INSERT INTO bch_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Ta Iso ikeo pan Iakop, “Manmanae! Bada annga singsingia toa uloeai na inam naean. Pitoreagau ga tinig imanggolenga kapei tau.” (Ngan ipu toaine tiuato ieda ede pade Idom.) ");
INSERT INTO bch_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Be Iakop ikeo, “Longean mulim gergeu lautabe aea ga inam pagau bua.” ");
INSERT INTO bch_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ta Iso ikeo, “Ega, naoangga namate ngan pitoro. Toa bedane mulig gergeu lautabe aea ga ilua gau madongan?” ");
INSERT INTO bch_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Be Iakop ikeo, “Posa tautaunga gadae bua, ngan mulim gergeu lautabe aea ga inam pagau.” Tota Iso iposa tautaunga gadae ta ilongean imul gergeu lautabe aea ga ila pan Iakop. ");
INSERT INTO bch_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ga kus ta Iakop ipan aea bret ga sul singsingia toa ikado ngan lentil ipuapua. Iso ian ga iun ga kus ta idae ga ila. Ngan kadonga toa bedaoa, Iso ipasolan mambe ei iuangga imul gergeu lautabe aea eine danga sapaean. ");
INSERT INTO bch_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Idio ta sapanga kapei iuot ngan tibur Kenan mambe mugaeai iuot ngan Abraam imamado. Ta Aisak ila pan Abimelek, maron kapei togid Pilistia, ngan tuanga Gerar. ");
INSERT INTO bch_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Be Maron iuot pan Aisak ta ikeo, “Eao la Isip mao. Eao manta la mado ngan tibur ede nene gau ga nakeo pago ngan. ");
INSERT INTO bch_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Eao mamado ngan tano toa ne, ta gau ga namado toman ngan eao ga nakado kemi tau ngan eao. Ngansa gau ga napan tano toa kapei ne ga idio pago ga pagid lem gergeu ga tibutibum. Ta gau ga naparangrang leg posanga tautaunga toa nakado pan tamam Abraam. ");
INSERT INTO bch_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Be gau ga nakado ga lem gergeu ga tibutibum tiuot busa mambe gid gigima mariambai, ta gau ga napan tano toa ne pagid. Be kadonga kemi toa nakado ngan tibutibum, eine ga iparangrang alu toa ngada ne tanoeai, ");
INSERT INTO bch_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ngansa Abraam ilongo lingeg ga inasi leg posanga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Tota Aisak idio ngan tuanga Gerar. ");
INSERT INTO bch_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Idio ta gid arangaranga Gerar tibeta Aisak ngan iadaoa. Ta ikeo, “Ei gau liug.” Ngansa imataud ta ikeo iloleai bedane, “Gid panua ngan tuanga toa ne ga tipamate gau ta tibada adaoag. Ngansa ei taine namelapau.” ");
INSERT INTO bch_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Mole tede ga kus ta Abimelek, maron kapei togid Pilistia, imamado ele lumaeai be imata ila ta igera Aisak ipatitiaudan iadaoa Rebeka. ");
INSERT INTO bch_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tota Abimelek ibaba Aisak ga inam pan ta ikeo, “Ega, eine adaoam tautaunga, na? Eao kamado keo ga ei lium?” Ta Aisak ikeo pan, “Ngansa oangga nakeo ga ei adaoag, eine ga tirau gau ga namate.” ");
INSERT INTO bch_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Ta Abimelek ikeo, “Eao kamado kado bedane ngan gai? Oangga eaba eta ngan gai ieno toman ngan ei, eine eao kado ga lemai kadonga sat kapei tau.” ");
INSERT INTO bch_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Tota Abimelek iposa matua pagid panua toa ngada oa bedane, “Oangga sai ikado kadonga eta paeamao ngan eaba toa ne ga iadaoa, ei ga imate.” ");
INSERT INTO bch_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Idio ta Aisak ikado dadanga ta iarum gid annga ipuapua ngan tano toa oa. Be ngan rai toaiua gid annga iuot busa ta iasal tau gid annga ipuapua toa iarum mugaeai, ngansa Maron ikado kemi tau ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Tota Aisak ele pat ga danga sisid iuot busa. Ta ele danga sisid iuotot busa tau ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ei ele sipsip ga bulmakao ga paeaeanga busa tau, tota gid Pilistia lolod paeamao ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Ta tidom gid baba eau aea toa Abraam ele paeaeanga tilei mugaeai. ");
INSERT INTO bch_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ga kus ta Abimelek ikeo pan Aisak bedane, “Eao la aluai ngan gai! Eao uram kapei ta aeasal gai tau.” ");
INSERT INTO bch_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tota Aisak itnan tibur toa oa, ta ila ikado saupu ngan dubu kapei ngan tibur Gerar ta imamado toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Mugaeai Abraam ilei gid baba eau aea ngan tibur toa oa. Be muriai ngan imate, gid Pilistia tidom gid. Be Aisak ilei mulian gid baba eau aea toa oa ta iuato gid edad mambe itama iuatoato mugaeai. ");
INSERT INTO bch_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Be ado ede, Aisak ele paeaeanga tila ngan dubu kapei ta tilei baba ede eau aea, ta eau ilele ngan ga iuot. ");
INSERT INTO bch_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Be gid panua toa timariala ngan gid bulmakao togid Gerar, aoad isokangai pagid Aisak ele paeaeanga ta tikeo, “Eau aea baba toa ne eine gai togai.” Tota Aisak iuato eau aea baba toa oa ieda Esek, ngansa gid panua aoad isokangai pan. ");
INSERT INTO bch_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Idio ta Aisak ele paeaeanga tilei eau aea baba ede pade, be gid panua aoad isokangai ngan pade. Tota Aisak iuato eau aea baba toa oa ieda Sitna. ");
INSERT INTO bch_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ga kus ta Aisak itnan tibur toa oa ta ila ilei eau aea baba ede pade. Be gid panua aoad isokangai ngan mao. Tota Aisak iuato eau aea baba toa oa ieda Reobot ngansa ikeo bedane, “Labone Maron ipan tibur oatalai pagita, ta leda naurata ga iuot kemi toa eko.” ");
INSERT INTO bch_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Idio ta Aisak itnan tibur toa oa ta ila ngan tibur Berseba. ");
INSERT INTO bch_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Be ngan bong toaiua Maron iuot pan ta ikeo, “Gau Deo ton tamam Abraam. Eao mataud mao, ngansa gau namado toman ngan eao. Gau ga nakado kemi tau ngan eao, ta nakado ga lem gergeu ga tibutibum tiuot busa, ngansa eao gergeu ton leg paeaeanga Abraam.” ");
INSERT INTO bch_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ta Aisak ipagun popou tenainga aea ngan tibur toa oa, ta ibaba ga ila pan Maron ta isoa ieda. Toa eoa irau ele palata, be gid paeaeanga tilei baba eau aea. ");
INSERT INTO bch_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Be Abimelek itnan ele tuanga Gerar ta ila igera Aisak. Be panua rua tinam toman ngan ei. Ede eine Ausat, eaba ilualua Abimelek ngan ele posanga. Be ede pade eine Pikol, madidnga ngan Abimelek ele panua paraunga ad. ");
INSERT INTO bch_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ta Aisak ibeta gid bedane, “Mugaeai gimi aman ag isat ta asere gau. Be labone akim saoa ga anam pagau pade?” ");
INSERT INTO bch_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Ta tikeo, “Labone gai aoatai tautaunga mambe Maron imamado toman ngan eao. Ta gai akim gitaingada tarau posanga tautaunga ta loloda kelede. Tarau posanga ga bedane: ");
INSERT INTO bch_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Eao ga kado kadonga eta paeamao ngan gai mao. Ngansa gai akado kadonga eta paeamao ngan eao mao, be somisomi lemai kadonga kemi pago. Ta mugaeai eao tnan gai ga la, be eao lolom itarui ta la. Ta labone gai agera mambe Maron ikado kemi tau ngan eao.” ");
INSERT INTO bch_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Io, Aisak ikado ele eaneannga kapei ede, ta gisingada tian ga tiun. ");
INSERT INTO bch_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Ta gaisala rumaruma ngan ado sae, tidae ta tirau posanga tautaunga ngan gid led kadonga kemi rabu ngan gid. Ta ital gid, be lolod itarui ta titnan ei ga tila. ");
INSERT INTO bch_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Be ngan ado toaiua, Aisak ele paeaeanga tila pan ta tipalongo ei ngan baba eau aea toa tilei ta tikeo, “Eau iuot ngan.” ");
INSERT INTO bch_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Tota Aisak iuato eau aea baba toa oa ieda Siba. Toa bedaoa ta labone pade panua tiuatoato tuanga toa oa ieda Berseba. ");
INSERT INTO bch_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Iso aea rai sangaul pange, be iuai taine ede ieda Iudit. Ei gergeu taine ton Beri, eaba It aea. Be Iso iuai taine ede pade ieda Basemat. Ei gergeu taine ton Elon, eaba It aea. ");
INSERT INTO bch_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Be taine toa rua ne tikado Aisak ga Rebeka ta lolod itolatola tau ngan gisirua. ");
INSERT INTO bch_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Idio ta Aisak iuot eaba kapei tau, be imata ikila ta irangrang ngan igeragera mao. Ta ado ede ibaba ele gergeu lautabe Iso ga inam pan. Ta ikeo, “Natug.” Ta Iso ikeo, “Gau ta eko.” ");
INSERT INTO bch_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Ta Aisak ikeo, “Ega, gau eaba kapei na, be naoatai mao ngan ado isaoa ga namate. ");
INSERT INTO bch_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tota bada lem pandenga ga tutupi ta la tiburiai ngan ilonga ag masilau eta. ");
INSERT INTO bch_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Eao bada masilau ga kus ta nono annga toa imana kemi mambe nakimkim. Ta bada ga inam pagau ta naean. Toa bedaoa ta nakado leg posanga kemi ngan pamatuanga go motean, ga kus ta namate.” ");
INSERT INTO bch_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Be Rebeka ilongo Aisak iposaposa pan inat Iso toa bedaoa. Ta Iso ila tiburiai ngan ilonga masilau. ");
INSERT INTO bch_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ga kus ta Rebeka ikeo pan inat Iakop bedane, “Ega, patautene nalongo tamam ikeo pan Iso bedane, ");
INSERT INTO bch_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Bada ag masilau eta ta nono ga imana kemi ta naean. Ga kus ta nakado leg posanga kemi ngan pamatuanga go Maron imatai, mugaeai ngan leg matenga.’ ");
INSERT INTO bch_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Natug, longo kemi ta nasi leg posanga. ");
INSERT INTO bch_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","La gera leda meme ipu ta bada meme daenga pau rua toa titub kapeipei. Ta gau ga nanono tamam aea annga imana kemi mambe ikimkim. ");
INSERT INTO bch_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Ta eao ga bada ga ila pan tamam ta ian. Tota ei ga ikado ele posanga kemi ngan pamatuanga eao, mugaeai ngan imate.” ");
INSERT INTO bch_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Be Iakop ikeo pan itna Rebeka bedane, “Be tadig kapei itin ilaun kapei. Be gau tinig ilaun mao. ");
INSERT INTO bch_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Kado tamag idab tinig ta iuatai mambe napakaka ei. Toa bedaoa ga ikado posanga paeamao ta Deo ipaeabu ngan gau, ta nabada pamatuanga eta mao.” ");
INSERT INTO bch_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ta itna ikeo pan, “Natug, eao lolom ede ga ede mao. Posanga paeamao ga idae ngan gau. Be eao la kado mambe nakeo, ta bada gid meme toa oa ga inam pagau.” ");
INSERT INTO bch_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tota ila ibada gid meme ga ila pan itna. Ta itna inono itama aea annga toa imana kemi mambe ikimkim. ");
INSERT INTO bch_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ga kus ta Rebeka ibada Iso ele barikia kemikemi ienono lumaeai ta idol ngan inat Iakop. ");
INSERT INTO bch_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ta irobi Iakop ibage ga igagal ngan meme itin kukul. Ipasogo Iakop bedaoa ga kus ");
INSERT INTO bch_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ta ibada annga toa imana kemi toman ngan bret toa inono oa ga idae Iakop ibageai. ");
INSERT INTO bch_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ta Iakop ibada ga ila pan itama ta ikeo, “Apa.” Ta Aisak ikeo, “Natug, saoa toa? Eao sai?” ");
INSERT INTO bch_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ta Iakop ikeo pan itama, “Gau lem gergeu lautabe Iso. Gau nakado mambe eao keo pagau ngan. Dae mado ta ean am masilau idanga ede toa nanono ne. Ga kus ta kado posanga kemi ngan pamatuanga gau.” ");
INSERT INTO bch_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ta Aisak ibeta ei bedane, “Natug, eao bada masilau toa ne manmanae madongan?” Ta Iakop ikeo, “Am Maron Deo ilua gau ta nabada manmanae.” ");
INSERT INTO bch_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Ta Aisak ikeo pan Iakop bedane, “Nam boloma ta nadab tinim ta naoatai, eao natug Iso, mao mao?” ");
INSERT INTO bch_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Io, Iakop ila boloma pan, ta itama idab itin ta ikeo, “Ilinge mambe Iakop, be ibage mambe Iso.” ");
INSERT INTO bch_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Ei iuatai ngan ei mao, ngansa meme ilaun irobi ibage, mambe Iso itin ilaun. Ta Aisak ipamatua ei. ");
INSERT INTO bch_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Be ibeta ei pade, “Tautaunga eao natug Iso na?” Ta Iakop ikeo, “Be. Eine gau.” ");
INSERT INTO bch_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Ta Aisak ikeo, “Natug, bada annga toa eao nono ne ga inam naean. Ga kus ta nakado leg posanga kemi ngan pamatuanga eao.” Io, Iakop ibada pan ta ian, ta ibada oain pade ga ila pan ta iun. ");
INSERT INTO bch_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Ga kus ta itama Aisak ikeo, “Natug, nam boloma pagau ta busum papag.” ");
INSERT INTO bch_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tota Iakop ila boloma pan ta ibusum ipapa. Be itama inud barikia ton Iso ta ikado posanga kemi ngan pamatuanga ei ta ikeo, “A, natug itin iuad kemi toa ne, eine mambe dadanga ede iuad kemi, ngansa Maron ikado ga iuot kemi tau. ");
INSERT INTO bch_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Deo ga ikado namul buburiai aea ga isulug ga inam ngan am dadanga, ta am annga ga iuot busa. Eine ga ikado ga am tano imona kapei ta am wit ga oain iuot busa pade. ");
INSERT INTO bch_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Gid alu toa ngada ne ga timan lem paeaeanga, ta panua ngan tuanga toa ngada ne ga tikor aed ga tilolon ngan eao. Eao ga man maron ngan am kakakau, ta tnam ele gergeu ga tikor aed ga tilolon ngan eao pade. Be sapadua tikado posanga paeamao ngan eao, eine Deo ga ipaeabu ngan gid. Be sapadua tikado posanga kemi ngan eao, eine Deo ga ikado kemi ngan gid.” ");
INSERT INTO bch_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Io, Aisak ikado posanga kemi ngan pamatuanga Iakop ga kus ta Iakop itnan ei ga idio. Be mole mao, itar kapei Iso iluai mulian tiburiai ga inam. ");
INSERT INTO bch_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Ei pade inono itama aea annga imana kemi ta ibada ga ila pan. Ta ikeo, “Apa, dae mado ta ean am masilau toa nabada ga inam. Ga kus ta kado lem posanga kemi ngan pamatuanga gau.” ");
INSERT INTO bch_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Be Aisak ikeo, “Eao sai?” Ta ikeo, “Gau natum lautabe Iso.” ");
INSERT INTO bch_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Be Aisak ikakrik ta itin isamimi paeamao tau ta ikeo, “Be sai patautene ibada masilau ga inam pagau? Eao nam ot maitne, be naean o. Ta gau nakado posanga kemi ngan pamatuanga ei, ta posanga toa oa ga iuot ngan ei tautaunga.” ");
INSERT INTO bch_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Io, Iso ilongo itama ele posanga toa bedaoa, ta ilolo bake ga ingangar kapei tau. Ta ikeo, “Apa, kado posanga kemi ngan pamatuanga gau pade!” ");
INSERT INTO bch_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Be Aisak ikeo, “Tadim kakau inam ta ipakaka gau ta ilub am pamatuanga na.” ");
INSERT INTO bch_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Ta Iso ikeo bedane, “Ega, ei ipakaka gau parua na. Mugaeai ilub mulig gergeu lautabe aea, ta labone ilub ag pamatuanga pade. Tota ele kadonga pakakanga toa ne inasi ieda ipu.” Ta Iso ibeta itama pade bedane, “Be lem pamatuanga eta pade ngan gau mao?” ");
INSERT INTO bch_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Ta Aisak ikeo pan Iso, “Natug, ega, gau nakado ei ga iuot maron ngan eao na. Be isobosobo toa ngada ne ga timan ele paeaeanga. Be nakeo pade ngan aea wit ga oain iuot busa. Toa bedaoa ga nakado saoa pade ngan eao?” ");
INSERT INTO bch_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Ta Iso ikeo pade pan itama, “Be lem pamatuanga kelede mon? Apa, kado posanga kemi ngan pamatuanga gau pade!” Ta itang kapei. ");
INSERT INTO bch_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Be itama Aisak ikeo, “Ega, eao ga mado aluai ngan tano imona. Be namul buburiai aea ga isulug ga ipatub am dadanga mao. ");
INSERT INTO bch_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Eao ga parau ngan didi ngan badanga am annga ga lem madonga kemi. Be eao ga man tadim kakau ele paeaeanga. Be muriai eao ga tolatola ngan ei, ta boko paeaeanga pan pade mao.” ");
INSERT INTO bch_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso ilolo paeamao ngan Iakop ngansa tamad ikado posanga kemi ngan pamatuanga ei toa bedaoa. Ta ikeo iloleai bedane, “Teta pade tamag ga imate, ta gai atang ngan ei. Be oangga akado madonga lolo isat aea ga kus, eine ga narau Iakop ga imate.” ");
INSERT INTO bch_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Be Rebeka ilongo posanga ngan ele gergeu lautabe Iso iuangga ipamate Iakop, ta ibaba ele gergeu atange Iakop ga inam pan ta ikeo, “Ega, am kapei Iso iuangga ikado ga ilolo kemi mulian ngan pamatenga go. ");
INSERT INTO bch_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tota eao manta nasi leg posanga. Toa patautene dae ta eaoa manmanae ga la pan liug Laban ngan tuanga Aran. ");
INSERT INTO bch_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Eao dio mamado pan ga irangrang ngan tadim kapei ilolo itano ga idio ");
INSERT INTO bch_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ta imata sapian lem kadonga paeamao ngan ei. Ga kus ta napaoen posanga ga ila pago, ta luago mulian. Ngan kado ta gimirua amate ngan ado kelede ta naman aimara.” ");
INSERT INTO bch_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Idio ta Rebeka ikeo pan Aisak bedane, “Gau lolog itola tau ngan madonga boloma pagid taine It ad toa ne. Oangga Iakop pade iuai taine It aea, mambe taine toa rua ne, kemi ngan gau namate.” ");
INSERT INTO bch_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tota Aisak ibaba Iakop ga inam pan ta iposa kemi ngan pamatuanga ei. Ta irenren pan bedane, “Eao rangrang ngan oai taine eta Kenan aea mao. ");
INSERT INTO bch_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Toa patautene dae ta la ngan tibur kapei Padan-Aram pagid iaoa kelede ton Betuel, toa tnam itama. La pan tnam iliu Laban ta bada inat taine eta ga iman adaoam. ");
INSERT INTO bch_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kemi ngan Deo Matua Soke Tau ikado kemi ngan eao, ta ikado ga lem gergeu tiuot busa. Tota eao ga ot alu busa tibud. ");
INSERT INTO bch_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Be kemi ngan pamatuanga toa Deo ipamatua Abraam ngan mugaeai, idio pago ga pagid tibutibum muriai. Ta gimingada tibutibum ga abada tano toa ne ga iman ami. Eao labone mamado nene mambe kaluae ede. Eine tano toa Deo ipan ga iman Abraam aea.” ");
INSERT INTO bch_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Io, Aisak iposa bedaoa ga kus ta isula Iakop ga ila ngan tibur kapei Padan-Aram. Ila pan Laban, Betuel inat, eaba Aram aea. Ei Rebeka iliu. Be Rebeka ei Iakop ga Iso tnad. ");
INSERT INTO bch_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Iso igera mambe itama Aisak ikado posanga kemi ngan pamatuanga Iakop ga kus ta isula ei ga ila ngan tibur kapei Padan-Aram ngan badanga iadaoa eta toa eoa. Be ngan ado toaiua tamad ipamatua Iakop, Iso igera mambe tamad irenren pan Iakop ta ikeo ga irangrang ngan ibada iadaoa eta pagid taine Kenan ad mao. ");
INSERT INTO bch_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Be igera mambe Iakop ilongo tamad ga tnad linged ta ila ngan tibur Padan-Aram. ");
INSERT INTO bch_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Be igera pade mambe itama Aisak itin ngan gid taine Kenan ad mao. ");
INSERT INTO bch_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Tota Iso ila pagid iaoa kelede pan Ismael toa Abraam inat ede pade, ta iuai taine ede pade, ieda Maalat. Taine toa ne ei Ismael inat taine ga Nebaiot iliu. Taine pau toa ne itlan Iso iadadaoa toa rua oa. ");
INSERT INTO bch_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Be Iakop itnan Berseba ta inasi edap ga ila ngan tuanga Aran. ");
INSERT INTO bch_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Iuot ngan tibur ede ta idio ieno toa eoa, ngansa ado idil. Ibada pat ede iman aea nakulnga ta idol ilabora ga idae ngan ta idio ieno toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Ngan ianun igera tete mamarae ede idae ga ila buburiai ga isulug tung tanoeai. Be gid anggelo ton Deo tilalala ga tidae ga tilalala ga tisulug ngan. ");
INSERT INTO bch_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Ta Iakop igera Maron imadid gadae ngan ta ikeo, “Gau Maron, Deo ton tibum Abraam ga tamam Aisak. Gau ga napan tano toa eao eno ngan ne ga iman eao am ga lem gergeu ga tibutibum ad. ");
INSERT INTO bch_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Lem gergeu ga tibutibum ga tiuot busa mambe riringa tano aea. Gid ga tisarung ad tano aea but ngan tibur toa ngada ne, ngan ado ele parangai ga ado ele dilngai, ga not ga saut pade. Be kadonga kemi toa nakado ngan eao ga tibutibum, eine ga iparangrang gid lum ga lum toa ngada ne tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Be ega, gau ga namado toman ngan eao ga matag ikikisi go ngan lem lalalanga toa ngada ne. Ta gau ga nabada go ga luago mulian ngan tano toa ne. Be gau ga natnan eao mao ga irangrang ngan nakado danga toa ngada ne iuot pago mambe naposa tautaunga pago ngan.” ");
INSERT INTO bch_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Io, Iakop ieno ga idae ta ikeo bedane, “Made bong naoatai mao mambe Maron imamado ngan tibur toa ne. Be tautaunga ei ta imamado!” ");
INSERT INTO bch_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Iakop imataud ta ikeo, “Tibur ne ikado ga namataud kapei tau. Eine luma ton Deo. Be eine bubur aea atama.” ");
INSERT INTO bch_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Io, gaisala rumaruma ngan ado sae, Iakop idae ta ibada aea nakulnga pat toa oa ta ipagun ga iman kilala ta itok bude ga idae pat ipaoeai. ");
INSERT INTO bch_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Ta iuato tibur toa oa ieda Betel. Mugaeai gid panua tiuatoato tuanga ga boloma oa ieda Lus. ");
INSERT INTO bch_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ta Iakop iposa tautaunga pan Deo ta ikeo, “Oangga Deo imamado toman ngan gau ga imata kikisi gau ngan leg lalalanga toa ne, ga ipanpan ag annga ga ag barikia papau, ");
INSERT INTO bch_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ta oangga naluagau kemi tamag ele lumaeai, tota Maron ga iuot ag Deo. ");
INSERT INTO bch_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Be pat toa napagun ne ga iman Deo ele luma. Ta danga toa ngada ne ibabada pagau, eine ga napota ga iuot suknga sangaul, ta natenai suknga ede ga ila pan.” ");
INSERT INTO bch_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Iakop ilalala ga ila ta iuot ngan tano togid panua ado ele parangai ad. ");
INSERT INTO bch_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Toa eoa ila ngan dubu ede ta igera eau aea baba. Be sipsip ipu tol timamado boloma ngan, ngansa somisomi tamatamad tieded eau ngan baba toa oa ta tipaun gid. Be pat kapitnami ede ipakala eau aea baba. ");
INSERT INTO bch_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Somisomi oangga gid sipsip toa ngada oa tiluplup ga kus, eine gid panua timariala ngan sipsip tipul pat toa oa ngan eau aea baba ta tipaun gid sipsip. Ga kus ta tipatabul mulian pat ga ipakala baba iaoa. ");
INSERT INTO bch_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ta Iakop ibeta gid panua toa timariala ngan sipsip oa bedane, “Leg panua, gimi sida ami?” Ta tikeo, “Gai lemai tuanga Aran.” ");
INSERT INTO bch_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ta ibeta gid, “Gimi aoatai ngan Laban, Naor itub pade?” Ta tikeo, “Be. Gai aoatai ngan ei.” ");
INSERT INTO bch_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ta Iakop ibeta gid, “Laban imamado kemi na?” Ta tikeo, “Be. Ei imamado kemi. Ega, inat taine Resel ta inam toman ngan gid sipsip.” ");
INSERT INTO bch_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ta Iakop ikeo, “Ega, ado gadae maitne. Be ado imata toaine eine kemi ngan paluplupnga gid sipsip mao. Ikamado ga apaun gid sipsip manmanae mao? Toa bedaoa ta tiluagid ga tila ta tian ad purup.” ");
INSERT INTO bch_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Ta tikeo, “Gai arangrang ngan akado toa bedaoa mao. Manta gid sipsip toa ngada ne tiluplup ga kus ta apul pat ipakala eau aea baba ta apaun gid sipsip.” ");
INSERT INTO bch_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Iakop iposaposa toman ngan gid maitne, be Resel inama iuot toman ngan itama ele sipsip, ngansa ele naurata ngan imariala ngan gid. ");
INSERT INTO bch_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Iakop igera Resel toman ngan iua Laban ele sipsip ipu, ta ila ipul pat kapei baba iaoai ta ipaun iua Laban ele sipsip. ");
INSERT INTO bch_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ta Iakop ibusum Resel ipapa ta itang. ");
INSERT INTO bch_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ta Iakop ipalongo Resel mambe ei gergeu ton Rebeka, itama iliu. Ta Resel ilado ga ila ipalongo itama. ");
INSERT INTO bch_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laban ilongo mambe gergeu ton iliu inama iuot, tota ilado ga ila iluku ei ta ibusum ipapa. Ga kus ta ibada ei ga ila lumaeai. Ta Iakop ininipu pan Laban ngan danga toa ngada oa iuot ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Ta Laban ikeo pan bedane, “Tautaunga, gitarua taot ngan sing kelede.” Iakop imamado taiko dodol ede toman ngan Laban. ");
INSERT INTO bch_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Ga kus ta Laban ikeo pan Iakop bedane, “Tautaunga eao gau sobog, be gau tinig ngan eao boko pagau sapaean mao. Be keo pagau, eao kim am olnga pida?” ");
INSERT INTO bch_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Be Laban ele gergeu taine rua. Lautabe ieda Lea, be atange ieda Resel. ");
INSERT INTO bch_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lea imata kemi tau mao, be Resel ei taine namelapau ga imata kemi tau. ");
INSERT INTO bch_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Iakop ikim tau Resel ta ikeo pan Laban bedane, “Gau ga naboko rai lima ga rua pago, ta eao longean natum taine Resel ga iman adaoag.” ");
INSERT INTO bch_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Ta Laban ikeo, “Oangga eaba eta pade iuai ei, eine kemi tau mao. Be kemi ngan nabada ei ga ila pago. Eao dio pagau.” ");
INSERT INTO bch_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tota Iakop iboko rai lima ga rua ngan badanga Resel ga iman iadaoa. Be Iakop iuangga rai toa lima ga rua oa, eine danga eta mao, mambe ado pidaede, ngansa ilolo ikim Resel kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Rai lima ga rua kus ta Iakop ikeo pan Laban bedane, “Gau ag rai lima ga rua kus na. Bada natum taine ga inam ta irangrang ngan naeno toman ngan ei.” ");
INSERT INTO bch_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tota Laban ikado eaneannga kapei oainga aea ta ibaba gid panua toa ngada oa tuangai ad ga tinam. ");
INSERT INTO bch_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Be ngan bong toaiua, ibada inat taine Lea ga ila pan Iakop, ta ieno toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Ta Laban ipan Lea ele taine paeaeanga ede ieda Silpa. ");
INSERT INTO bch_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Io, gaisala ngan ado sae, Iakop itograi ngan geranga taine toa ieno toman ngan ei. Eine Resel mao, be Lea! Tota Iakop ila ikeo pan Laban bedane, “Eao kamado kado kadonga toaine ngan gau? Gau nakado lem naurata ngan oainga Resel. Eao kamado pakaka gau?” ");
INSERT INTO bch_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Be Laban ikeo, “Gai tuanga toa ne lemai nasinga ga bedane: Manta taine lautabe iuai mugaeai, ga kus ta atange iuai. ");
INSERT INTO bch_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Eao sanga bong lima ga rua irangrang ngan eaneannga oainga aea ne kus. Ta gai ga alongean natumai taine ede pade iuai go pade. Be eao ga kado leg naurata irangrang ngan rai lima ga rua pade.” ");
INSERT INTO bch_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Io, Iakop ikado toa bedaoa. Eaneannga oainga aea kus ta Laban ibada Resel pade ga ila pan Iakop ta iman iadaoa. ");
INSERT INTO bch_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Ta Laban ipan Resel ele taine paeaeanga pade ieda Bila. ");
INSERT INTO bch_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ta Iakop ieno toman ngan Resel pade ga ikim ei kapei tau. Be ikim Lea tau mao. Tota Iakop iboko pan Laban irangrang ngan rai lima ga rua pade. ");
INSERT INTO bch_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Idio ta Maron igera mambe Iakop ikim Lea tau mao, ta ilua ei ga irangrang ngan iapa. Be Resel irangrang ngan iapa mao. ");
INSERT INTO bch_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lea iapa ta ipopo gergeu aranga. Ta iuato ieda Ruben, ngansa ikeo bedane, “Maron igera ag kadonga kulupu na. Ta labone adaoag ga ikim gau.” ");
INSERT INTO bch_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ga kus ta Lea iapa pade ta ipopo gergeu aranga. Ta ikeo, “Maron ibada gergeu aranga ede pade pagau, ngansa ilongo mambe Iakop ikim gau mao.” Tota iuato ieda Simeon. ");
INSERT INTO bch_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Idio ta Lea iapa pade ta ipopo gergeu aranga. Ta ikeo, “Labone ga muriai ga ila, adaoag ga isolasola gau, ngansa napopo ele gergeu arangaranga tol.” Ta iuato ieda Livai. ");
INSERT INTO bch_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Idio ta Lea iapa pade ta ipopo gergeu aranga pade. Ta ikeo, “Labone gau ga nasoa Maron ieda ga idae.” Ta iuato ieda Iuda. Idio ta Lea iapa pade mao. ");
INSERT INTO bch_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Idio ta Resel igera mambe ei ipopo Iakop ele gergeu eta mao, ta ilolo paeamao ngan itar kapei Lea. Ta ikeo pan Iakop bedane, “Eao kado ta napopo gergeu eta! Oangga mao, gau ga namate.” ");
INSERT INTO bch_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Be Iakop ilolo bake ta ikeo pan Resel bedane, “Eao oangga gau Deo ta narangrang ngan nabada gergeu pago na? Eine mao, be Deo ipakala eao ta apam mao.” ");
INSERT INTO bch_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ta Resel ikeo bedane, “Ega, eao bada leg taine paeaeanga ne, Bila. Eao eno toman ngan ei ta ei ga ipopo leg gergeu etangada. Toa bedaoa ta gau pade ga naot gid gergeu tnad.” ");
INSERT INTO bch_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tota Resel ibada ele taine paeaeanga Bila ga ila pan Iakop mambe iadaoa. Ta Iakop ieno toman ngan ei, ");
INSERT INTO bch_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","ta iapa ta ipopo Iakop ele gergeu aranga. ");
INSERT INTO bch_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Ta Resel ikeo bedane, “Deo igera leg kadonga, ta ikeo ga gau tutui. Ta ilongo leg raring ta ibada gergeu aranga ede pagau.” Tota iuato ieda Dan. ");
INSERT INTO bch_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Idio ta Resel ele paeaeanga Bila iapa pade ta ipopo gergeu aranga ede pade ton Iakop. ");
INSERT INTO bch_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Ta Resel ikeo, “Salisalinga ne kapei tau, be naeasal tadig kapei.” Ta iuato ieda Naptali. ");
INSERT INTO bch_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Idio ta Lea igera mambe iapa pade mao, ta ibada ele taine paeaeanga Silpa ga ila pan Iakop ta iuot mambe iadaoa. ");
INSERT INTO bch_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Idio ta Lea ele taine paeaeanga Silpa ipopo Iakop ele gergeu aranga ede. ");
INSERT INTO bch_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Ta Lea ikeo, “Danga kemi tau iuot pagau.” Ta iuato ieda Gat. ");
INSERT INTO bch_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Idio ta Silpa ipopo gergeu aranga ede pade ton Iakop. ");
INSERT INTO bch_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ta Lea ikeo, “Gau tinig igelgel kapei tau. Gid taine ga tikeo bedane ngan gau, ‘Ei taine tingelgel aea.’” Ta iuato ieda Aser. ");
INSERT INTO bch_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Idio ta wit aea laoe iuot, ta Ruben ila tiburiai ta iuot ngan manderek itautau ta ibada ga ila pan itna Lea. Ta Resel ikeo pan Lea bedane, “Natum ele manderek itautau toa na, irangrang ngan eao pan etangada ga iman ag?” ");
INSERT INTO bch_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Be Lea ikeo pan bedane, “Eao paeaoa adaoag na. Be eao oangga kadonga toa ne danga sapaean? Ta eao keo ga bada natug ele manderek itautau pade?” Ta Resel ikeo, “Goibe, oangga eao bada ele manderek itautau ga inam pagau, bong labone Iakop ga ieno toman ngan eao.” ");
INSERT INTO bch_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Io, ngan lailai toaiua Iakop iluai mulian dadangai ga inam, be Lea iuot pan edapeai ta ikeo pan bedane, “Eao manta eno toman ngan gau bong labone, ngansa naol go ngan natug ele manderek itautau.” Ta ieno toman ngan ei ngan bong toaiua. ");
INSERT INTO bch_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Idio ta Deo ilongo Lea ele raring, ta iapa pade ta ipopo Iakop ele gergeu aranga lima aea. ");
INSERT INTO bch_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Ta Lea ikeo, “Deo ilasu gau ngansa nabada leg taine paeaeanga ga ila pan adaoag.” Ta iuato ieda Isakar. ");
INSERT INTO bch_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Idio ta Lea iapa pade ta ipopo Iakop ele gergeu aranga lima ga ede aea. ");
INSERT INTO bch_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ta Lea ikeo, “Deo ipan tenainga kemi ede pagau. Labone ga muriai ga ila, adaoag ga ilolon ngan gau ngansa napopo ele gergeu arangaranga lima ga ede.” Ta iuato gergeu toa ieda Sebulun. ");
INSERT INTO bch_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Idio ga muriai ta Lea ipopo gergeu taine ede ta iuato ieda Daina. ");
INSERT INTO bch_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Idio ta Deo imata nanan Resel ta ilongo ele raring ta ikado ga Resel irangrang ngan ipopo gergeu. ");
INSERT INTO bch_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Resel iapa ta ipopo gergeu aranga. Ta ikeo, “Deo ikado ga ag maeamaea ne kus. ");
INSERT INTO bch_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Ta gau nakim Maron ibada gergeu aranga ede pade pagau.” Ta iuato ieda Iosep. ");
INSERT INTO bch_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Resel ipopo Iosep ga kus ta Iakop ikeo pan Laban bedane, “Eao longean gau ta naluagau mulian ag tuanga ipuiai. ");
INSERT INTO bch_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Longean adadaoag ga leg gergeu tinam toman ngan gau, ngansa nakado naurata kapei pago ngan olnga gid. Eao oatai, gau nakado lem naurata toa ngada ne kemikemi mon.” ");
INSERT INTO bch_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Be Laban ikeo pan bedane, “Oangga lolom marum ngan gau, eao tnan gau padam. Ngan leg borou, naot ngan posanga ta naoatai mambe Maron ikado kemi ngan gau ngansa eao mamado toman ngan gau.” ");
INSERT INTO bch_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Ta Laban ikeo pade bedane, “Keo tutui pagau ngan am olnga pida. Eine ga naol go toa bedaoa.” ");
INSERT INTO bch_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ta Iakop ikeo, “Eao oatai ngan leg naurata toa ngada ne nakakado. Ta eao oatai pade mambe gau namariala kemi tau ngan lem sipsip ga meme ta tiuot busa. ");
INSERT INTO bch_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Mugaeai lem sipsip ga meme pidaede mon. Be gau namamado toman ngan eao, ta labone tiuot busa, ngansa Maron ilua gau ngan leg naurata toa ngada ne, ta ikado kemi ngan eao. Be irangrang ngan nalualua gau leg luma lolo ngeda?” ");
INSERT INTO bch_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ta Laban ibeta Iakop bedane, “Gau ga nabada saoa pago iman am olnga?” Ta Iakop ikeo, “Gau tinig ngan eao bada danga eta pagau mao. Be oangga eao longo lingeg ngan danga ga oaine, eine ga namariala ngan gid lem sipsip ga meme pade. Leg posanga ga bedane: ");
INSERT INTO bch_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Labone gau ga nala nagera kemi gid lem sipsip ga meme, ta nabada gid sipsip ga meme toa ngada oa tinid kiripes ga gid sipsip gereirei toa ngada oa tinid asaso. Gau ga nabada gid ga iman ag olnga. ");
INSERT INTO bch_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ta muriai, oangga eao kim, eao ga gera gid sipsip ga meme toa nabada ga iman ag olnga, ta eao oatai, gau nanasi tutui leg posanga toa ne, mao napakaka. Ta oangga eao gera gid masilau mud togau, be gera meme eta itin kiripes mao, ga oangga eao gera sipsip kakaueta toa itin asaso mao imamado rabu ngan gid, eine eao oatai, gau nalub.” ");
INSERT INTO bch_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Ta Laban ikeo, “Eine kemi. Takado mambe eao keo.” ");
INSERT INTO bch_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Tota ngan ado toaiua, Laban ilelean gid meme arangaranga ga taine toa ngada oa tinid kiripes, ga gid sipsip gereirei toa ngada oa tinid asaso, ta idol gid ga tidae ele gergeu arangaranga bagedeai, ta timariala ngan. ");
INSERT INTO bch_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Ta asingada Laban tilalala ga tila ga irangrang ngan ado tol, ta tidio toa eoa. Be Iakop idio imariala ngan gid sipsip ga meme padengada ton Laban. ");
INSERT INTO bch_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Be Iakop ibada abei salke ga poplar ga plen ibogaboga papau, ta isoi itin kukul idanga edengada ta aea bodbode iuot. ");
INSERT INTO bch_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Ta ipagun gid abei ibogaboga toa oa gadudunga ngan gid sipsip ga meme ad golomada ununnga aea. Toa bedaoa ta oangga gid meme tinam tiun, eine ga tigera gid abei ibogaboga toa oa. Ei iuatai, oangga gid meme led taiko saeaeanga aea iuot ta tinam ngan unnga eau, ");
INSERT INTO bch_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","eine gid meme arangaranga ga tisaeaea gid meme taine boloma ngan gid abei ibogaboga toa oa. Ta muriai gid meme taine tipopo gid meme kiripes mon. ");
INSERT INTO bch_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ta Iakop ilongean gid sipsip ton Laban tisaeaea gid sipsip taine boloma ngan gid meme gereirei tinid kiripes. Ta ngan kadonga toaine, Iakop ibada gid sipsip ga meme ei ton, be ipaluplup gid toman ngan Laban ele sipsip ga meme mao. ");
INSERT INTO bch_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ta somisomi oangga gid sipsip taine toa urad kapei tiuangga gid sipsip arangaranga tisaeaea gid, eine Iakop ga ipagun gid abei ibogaboga toa oa ga idudunga ngan sipsip ad golomada eau aea. Ta gid sipsip ga tigera gid abei ibogaboga, ta tisaeaea boloma ngan. ");
INSERT INTO bch_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Be oangga gid sipsip ga meme taine urad mao, eine Iakop ga idol gid abei ibogaboga mao. Toa bedaoa ta gid sipsip ga meme toa urad mao, timan Laban ele, be gid sipsip ga meme toa urad kapei timan Iakop ele. ");
INSERT INTO bch_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ngan kadonga toa bedaoa, Iakop ele danga sisid iuot busa tau. Ei ele sipsip ga meme busa, ga ele paeaeanga arangaranga ga taine busa, ga ele kamel ga donki busa pade. ");
INSERT INTO bch_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Idio ta Iakop ilongo sal mambe Laban ele gergeu arangaranga tiposa pol ngan gid bedane, “Iakop ibada danga toa ngada ne ton tamada, ta ngan kadonga toaine ele danga sisid iuot busa tau.” ");
INSERT INTO bch_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ta Iakop igera mambe mugaeai Laban itin igelgel ngan ei, be labone mao. ");
INSERT INTO bch_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Idio ta Maron ikeo pan Iakop bedane, “Eao luago mulian ta la ngan tuanga ton tamam ga sobosobom. Ta gau ga namado toman ngan eao.” ");
INSERT INTO bch_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Io, Iakop ipaoen posanga ga ila pan Resel ga Lea ngan tila tigera ei ngan tibur toa ele sipsip ga meme timamado ngan. ");
INSERT INTO bch_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ta ikeo pagisirua bedane, “Gau nagera mambe tamami itin igelgel ngan gau mambe mugaeai ne mao. Be Deo ton tamag imamado toman ngan gau. ");
INSERT INTO bch_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Gimirua aoatai, gau nabokoboko matua tau pan tamami. ");
INSERT INTO bch_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Be tamami ipakaka gau ta isogesoge ag olnga pabusa tau. Be Deo ipakala ei, ta ipaeabu ngan gau mao. ");
INSERT INTO bch_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Mugaeai ikeo ga gid meme kiripes timan ag olnga, be gid meme tipopo kiripes mon. Idio ga muriai ta ikeo ga gid tinid sirisiri timan ag olnga, be gid meme tipopo sirisiri mon. ");
INSERT INTO bch_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Toa bedaoa ta Deo ibada masilau mud toa ngada ne ton tamami ta ipan ga iman leg. ");
INSERT INTO bch_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Ngan gid meme led taiko saeaeanga aea, gau anunug ta nagera gid meme arangaranga tinid kiripes mon tisaeaea gid meme taine. ");
INSERT INTO bch_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ta anggelo ton Deo ikeo pagau ngan anunug bedane, ‘Iakop.’ Ta nakeo, ‘Gau ta eko.’ ");
INSERT INTO bch_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ta ikeo, ‘Matam idae ta gera mambe gid meme arangaranga kiripes mon tisaeaea gid meme taine. Gau nakado ga iuot bedane, ngansa nagera kadonga toa Laban ikakado ngan eao. ");
INSERT INTO bch_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Gau Deo toa mugaeai naot pago ngan tibur Betel. Ngan tibur toa oa eao pagun pat ede iman kilala ta tok bude ga idae ngan. Toa eoa eao kado posanga tautaunga ede pagau. Be toa patautene dae ta bada lem gergeu ga danga sisid ta tnan tibur toa ne, ta luago mulian am tuanga ipuiai.’” ");
INSERT INTO bch_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Io, Resel ga Lea tikoli ele posanga bedane, “Muriai ngan tamamai ele matenga, aea tano ga ele danga etangada ienono ngan tipota ga inam pagairua ne mao. ");
INSERT INTO bch_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Ei ikado mambe gairua aot iaoa ede pade. Ibada gairua amai olnga, ta ianean ngan ga kus. ");
INSERT INTO bch_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Tamamai ele danga toa ngada ne, tota Deo ibada pago ta iman gaingada gergeu lemai. Tota kemi ngan eao kado mambe Deo ikeo pago ngan.” ");
INSERT INTO bch_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Io, Iakop idae ta idol gid iadadaoa ga ele gergeu ga tidae ngan gid kamel, ");
INSERT INTO bch_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ta isula gid meme ga sipsip ipu tila timuga ngan ei toman ngan ele danga sisid toa ngada oa ibada ngan tibur Padan-Aram. Ta titnan tibur toa oa ta tilalala ga tinasi edap ila ngan itama Aisak ele tuanga ngan tibur Kenan. ");
INSERT INTO bch_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Matad boloma ngan led lalalanga, be Laban ila ngan ketnga gid sipsip launid. Ta Resel ilub itama aea deo ad namer. ");
INSERT INTO bch_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Be Iakop ipakaka Laban, ngansa ipalongo ei ngan ele eaoanga mao. ");
INSERT INTO bch_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tota Iakop iaoa toman ngan ele danga sisid toa ngada oa, ta tiuore ngan eau kapei Iupretis ta tingata gid bereo ngan tibur Gileat. ");
INSERT INTO bch_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Be ngan ado tol aea gid panua tipalongo Laban ngan Iakop iaoa ga ila. ");
INSERT INTO bch_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tota Laban ibada isobosobo ta tilado ga tinasi Iakop irangrang ngan ado lima ga rua. Ta tiuot pagid ngan tibur Gileat aea bereo. ");
INSERT INTO bch_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Be ngan bong toaiua Deo iuot pan Laban toa eaba Aram aea, ngan ianun ta ikeo, “Eao gabit kemi. Kado posanga eta ngan dadanga Iakop ilolo mao ga posanga eta paeamao pan mao pade.” ");
INSERT INTO bch_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Io, Iakop irau ele saupu ngan tibur Gileat aea bereo ede, be Laban iuot pan. Ta Laban ga isobosobo tirau saupu toa eoa pade. ");
INSERT INTO bch_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Ta Laban ikeo pan Iakop bedane, “Eao kamado pakaka gau ta paeaoa leg gergeu taine mambe panua paraunga ad tikakado? ");
INSERT INTO bch_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Eao kamado eaoa mumulnga, be palongo gau mao? Be oangga eao palongo gau, eine ga nakeo pagid sobosobog ta tikado baunga etangada ngan abam ga arp, ta gai akado tingelgel be atal go ga la. ");
INSERT INTO bch_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Be mao. Eao longean gau ta nabusum tibutibug ga leg gergeu taine papad mao, ta natal gid kemi ga tila mao. Eao lem kadonga ne buobuonga tau. ");
INSERT INTO bch_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Gau narangrang ngan nakado paeamao ngan gimi, be made bong Deo ton tamami ikeo pagau bedane, ‘Eao gabit kemi. Kado posanga eta ngan dadanga Iakop ilolo mao ga posanga eta paeamao pan mao pade.’ ");
INSERT INTO bch_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Gau naoatai, eao kim tau ngan luago mulian am tuanga ipuiai ta tnan gau. Be eao kamado lub ag deo ad namer?” ");
INSERT INTO bch_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ta Iakop ikoli Laban ele posanga bedane, “Naeaoa mumulnga ngansa namataud. Ngan kado ta eao parau pagau ta bada mulian lem gergeu taine. ");
INSERT INTO bch_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Be oangga eao ot ngan eaba eta ngan gai ilub am deo ad namer, goibe rau ei ga imate. Rabu ngan sobosoboda matad, eao nam ta sare kemi danga toa ngada ne. Ta oangga gera danga eta eao togo, tota bada mulian.” Be Iakop iuatai mao mambe Resel ilub itama aea deo ad namer. ");
INSERT INTO bch_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tota Laban idudunga Iakop ele palatai ta isare ele danga sisid. Ga kus ta idudunga Lea ele palatai ta isaresare pade. Ta isaresare ngan palata togid taine paeaeanga rua pade. Be igera aea deo ad namer mao. Ei itnan Lea ele palata ga idio ta ila ngan palata ton Resel. ");
INSERT INTO bch_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Be Resel ibada gid deo ad namer ta idol gid gadudunga ngan ele mul madonga aea toa tidoldol kamel ipaoeai. Ta Resel idio imado ngan. Io, Laban isaresare danga toa ngada oa palata iloleai, be iuot ngan gid namer toa oa mao. ");
INSERT INTO bch_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ta Resel ikeo pan itama, “Apa, daba gau padam, be gau narangrang ngan namadid matameai mao, ngansa dibala togai taine iuot ngan gau.” Tota Laban iloilo aea deo ad namer ga mao. ");
INSERT INTO bch_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Be Iakop ilolo bake ta idaba Laban bedane, “Gau nakado saoa kadonga paeamao ngan eao? Leg idil isaoa paeamao ta eao butatan gau? ");
INSERT INTO bch_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Eao sare leg danga toa ngada ne ga kus, be eao ot ngan saoa danga togo? Oangga eao ot ngan lem danga eta, eao dol rabu ngan sobosoboda matad. Ta gid ga tigera ta tikeo ga sai ngan gitarua itutui. ");
INSERT INTO bch_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Gau namamado pago ag rai sangaul rua na. Be lem sipsip ga meme tidio gau bagegeai ta tipopo kemikemi mon. Be gau naean lem sipsip aranga eta mao. ");
INSERT INTO bch_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Oangga gid masilau saksak tirau lem sipsip ede ga imate, gau nabada ipat ga inama pago mao, be napakoli ngan sipsip ede togau. Somisomi eao keo ga oangga gid masilau saksak tibada lem sipsip bong mao ado, manta napakoli sipsip toa isusu oa. ");
INSERT INTO bch_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Somisomi ado inono gau ga del bong aea ipaeabu ngan gau. Be naeno eta kemi mao. ");
INSERT INTO bch_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nabokoboko pago toa bedaoa irangrang ngan ag rai sangaul rua. Nakado naurata irangrang ngan rai sangaul igegea pange ngan badanga natum taine toa rua ne, ta naboko pade ngan ag rai lima ga ede ngan badanga sipsip ga meme edengada ga iman leg. Be somisomi eao sogesoge ngan ag olnga. ");
INSERT INTO bch_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Be Deo ton tibug Abraam imamado toman ngan gau. Ei Deo toa tamag Aisak pade ilolon ngan. Be oangga imamado toman ngan gau mao, eine eao ga sula gau ta naluagau mulian sapaean. Be Deo igera ag kadonga kulupulupu ga leg naurata oanaoana, ta made bong idaba go.” ");
INSERT INTO bch_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Ta Laban ikoli Iakop ele posanga bedane, “Gid taine toa rua ne eine gau leg gergeu. Be led gergeu toa ne eine gau leg gergeu pade. Be gid sipsip ga meme, gau togau pade. Danga toa ngada ne eao gera, eine gau togau. Be eine ga nakado mado ngan gid leg gergeu taine toman ngan led gergeu? ");
INSERT INTO bch_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Nam ta gitarua tarau posanga ta loloda kelede. Ta takado danga eta ngan luanga gitarua ta matada nanan posanga toa tarau ne.” ");
INSERT INTO bch_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tota Iakop ibada pat mamarae ede ta ipagun ga iman kilala. ");
INSERT INTO bch_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Ta Iakop ikeo pagid isobosobo ta tigou gid patpat edengada ga inam ta tisuk gid. Ga kus ta tian annga boloma ngan suknga toa oa. ");
INSERT INTO bch_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban iuato suknga toa oa ieda Iegar-Saaduta, be Iakop iuato ieda Galet. ");
INSERT INTO bch_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Ta Laban ikeo, “Suknga toaine iman kilala ngan posanga toa gitarua tarau labone.” Tota tiuato ieda Galet. ");
INSERT INTO bch_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Be tiuato ieda ede pade Mispa, ngansa Laban ikeo bedane, “Labone ga muriai ga ila, gitarua taluplup ga tamado mao, be Maron ga igeragera kemi leda kadonga. ");
INSERT INTO bch_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Be oangga eao kado paeamao ngan gid leg gergeu taine, mao oangga oai taine eta pade, io, manta matam nanan kemi danga ga oaine: Oangga eaba eta igera gitarua leda kadonga mao, Deo somisomi igeragera leda kadonga.” ");
INSERT INTO bch_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ta Laban ikeo pan Iakop pade bedane, “Ega, eao gera pat mamarae napagun ga pat aea suknga toa ienono rabu ngan gitarua ne. ");
INSERT INTO bch_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Pat aea suknga toman ngan pat mamarae toa ne timan kilala ngan posanga toa gitarua tarau labone. Ta muriai, gau ga narangrang ngan nalaputian kilala toa ne ngan kadonga paraunga pago mao. Be eao pade rangrang ngan laputian kilala toa ne ngan kadonga paraunga pagau mao. ");
INSERT INTO bch_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Be oangga kadonga eta sat iuot rabu ngan gitarua, eine Deo ga ikeo ga sai ngan gitarua itutui. Ei Deo ton Abraam ga Naor ga Deo togid tibutibud pade.” Tota Iakop iposa tautaunga ngan Deo ieda. Ei Deo toa itama Aisak ilolon ngan. ");
INSERT INTO bch_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Irau masilau ga iman ele tenainga ga ila pan Deo ngan bereo toa oa, ta ibaba isobosobo ta tian annga tenainga aea. Gid tian ga kus ta ado idil, ta tieno toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Be ado sae gaisala rumaruma Laban ibusum itubtub ga ele gergeu taine papad ta ikado posanga kemi ngan pamatuanga gid. Ga kus ta itnan gid ta iluai mulian ele tuangai. ");
INSERT INTO bch_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Idio ta Iakop pade itnan tibur toa oa ta ilalala ga ila. Be edapeai gid anggelo ton Deo tiuot pan. ");
INSERT INTO bch_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Iakop igera gid ta ikeo, “Tibur ne Deo ele saupu!” Ta iuato tibur toa oa ieda Maanaim. ");
INSERT INTO bch_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Idio ta Iakop isula gid panua ato ad idanga ede ta timuga ngan ei ga tila pan itar kapei Iso ngan tibur kapei Seir. (Tibur toa oa ieda ede pade Idom.) ");
INSERT INTO bch_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Be Iakop irenren pagid bedane, “Gimi ga akeo pan ag maron Iso ga bedane, ‘Lem paeaeanga Iakop ikeo ga bedane: Gau namamado mole pan Laban, ta labone naoangga naluagau mulian. ");
INSERT INTO bch_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Gau leg bulmakao ga donki ga sipsip ga meme ga paeaeanga arangaranga ga taine. Gau naeabalan posanga toaine ga ila pago, ngansa nakim lolom marum ngan gau.’” ");
INSERT INTO bch_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Idio ta gid panua ato ad toa oa tiluagid mulian ta tikeo pan Iakop bedane, “Gai ala pan tadim kapei Iso, ta patautene iuangga inama iuot pago edapeai. Be arangaranga buno pange tinam toman ngan ei.” ");
INSERT INTO bch_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Iakop ilongo posanga toa oa ta imataud kapei ga ilolo ede ga ede. Tota ipota ele panua ga sipsip ga meme ga bulmakao ga kamel ta tiuot iaoa rua. ");
INSERT INTO bch_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Ikeo bedane, “Oangga Iso inama ikado paraunga pagid iaoa ede, eine iaoa ede pade ga tiaoa.” ");
INSERT INTO bch_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Ta Iakop iraring bedane, “O Deo ton tibug Abraam ga tamag Aisak, eao Maron toa mugaeai keo pagau ngan naluagau mulian ag tuanga ipuiai pagid sobosobog, ta eao posa tautaunga ngan kado kemi pagau. ");
INSERT INTO bch_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Gau eao lem paeaeanga. Gau mambe eaba ieda mao, be ikamado ga lolom isat ngan gau somisomi ta kado kadonga mata tutui aea pagau? Mugaeai naore ngan eau Iordan ta nanam namado pan Laban. Be ngan ado toaiua, gau leg danga eta mao. Nakisi toto lalalanga aea kekelen. Be labone naluagau mulian toman ngan gid panua iaoa toa rua ne. ");
INSERT INTO bch_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Gau nabeta eao, lua gau ta bada gau mulian pan tadig kapei Iso ibageai. Ngansa namataud. Ngan kado ta ikado paraunga pagau ta ipamukuru gai toman ngan gid gergeu ga tnatnad. ");
INSERT INTO bch_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Be eao kado posanga tautaunga pagau bedane, ‘Gau ga nakado kemi tau ngan eao ta nakado ga lem gergeu ga tibutibum tiuot busa mambe riringa lab aea, ta irangrang ngan eaba eta iuade gid mao.’” ");
INSERT INTO bch_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Tota Iakop ieno ngan bong toaiua. Be ei isio gid masilau mud idanga ede ga timan ele tenainga ila pan itar kapei Iso. ");
INSERT INTO bch_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Ei isio gid masilau mud ga tiuot bedane: meme taine buno rua, ga meme arangaranga sangaul rua, ga sipsip taine buno rua, ga sipsip arangaranga sangaul rua, ");
INSERT INTO bch_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ga kamel taine sangaul tol toman ngan led gergeu, ga bulmakao taine sangaul pange, ga bulmakao arangaranga sangaul ede, ga donki taine sangaul rua, ga donki arangaranga sangaul. ");
INSERT INTO bch_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Ei idol gid paeaeanga kelede kelede ta timariala ngan gid masilau ipu kelede kelede. Ta ikeo pagid bedane, “Gimi ala amuga ngan gau, be gid masilau ipu kelede kelede irangrang ngan tilalala boloma boloma mao.” ");
INSERT INTO bch_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ta Iakop ikeo pan paeaeanga toa imuga oa bedane, “Oangga tadig kapei Iso iuot pagimi edapeai ta ibeta gimi, ‘Gimi paeaeanga ton sai? Be ala sida? Be gid masilau ipu toa ne ton sai?’ ");
INSERT INTO bch_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","tota gimi ga akoli posanga pan bedane, ‘Danga toa ngada ne ton lem paeaeanga Iakop. Be ilongean gid ga timan tenainga ga ila pan aea maron Iso. Be ega, Iakop ta ilalala muriai ngan gai.’” ");
INSERT INTO bch_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Ta Iakop ikado posanga lalaede pagid paeaeanga toa ngada oa tinasi paeaeanga toa imuga oa. Tilalala ga timuga ngan gid masilau ipu ga ipu, be ikeo pagid bedane, “Oangga gimi aot pan Iso, manta akado posanga lalaede pan. ");
INSERT INTO bch_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Ta gimi ga akeo pade bedane, ‘Ega, lem paeaeanga Iakop ta inasnasi gai ga inam.’” Iakop ikado bedaoa ngansa ikeo iloleai bedane, “Gau ga napatarui tadig kapei ilolo ngan gid tenainga toa imuga ngan gau ne. Ta muriai oangga igera gau, eine ga ilolo kemi pagau.” ");
INSERT INTO bch_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tota Iakop ele tenainga ila imuga ngan ei, be ei kekelen idio saupuiai ngan bong toaiua. ");
INSERT INTO bch_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Ngan bong toaiua Iakop idae ta ibada iadadaoa rua ga ele taine paeaeanga rua ga ele gergeu sangaul ga igegea ede, ta tiuore ngan eau kakauede ieda Iabok. ");
INSERT INTO bch_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Ital gid ga tiuore ga kus, ta iluai mulian ta ikeo pagid ele paeaeanga ta tibada ele danga sisid toa ngada oa ta tiuore pade. ");
INSERT INTO bch_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ei kekelen idio, be ngan bong toaiua eaba ede inam, ta gisirua tipaparau ga irangrang ngan gaisala. ");
INSERT INTO bch_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Gisirua tipaparau ga ila, be eaba toa oa igera mambe irangrang ngan iasal Iakop mao. Tota irau Iakop ise kasanga ta iae ituatua iseki. ");
INSERT INTO bch_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ga kus ta eaba toa oa ikeo, “Teta pade gaga itakai. Longean gau ta nala.” Be Iakop ikeo, “Eao kado posanga kemi ngan pamatuanga gau bua. Ga kus ta nalongean eao ta la.” ");
INSERT INTO bch_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ta eaba toa oa ibeta ei, “Eao edam sai?” Ta ikeo, “Gau edag Iakop.” ");
INSERT INTO bch_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Ta eaba toa oa ikeo, “Labone ga muriai ga ila, gid panua ga tiuatoato edam Iakop pade mao, be gid ga tiuato edam pau Israel. Ngansa eao parau pagid eababa ga pan Deo ta easal gid.” ");
INSERT INTO bch_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Ta Iakop ikeo, “Keo pagau ngan edam sai.” Be eaba toa oa ikeo, “Eao kamado beta gau ngan edag?” Ta ikado posanga kemi ngan pamatuanga ei toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ta Iakop ikeo, “Gau nagera Deo imata, be namate mao.” Tota iuato tibur toa oa ieda Peniel. ");
INSERT INTO bch_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Ado ipara ga idae ta Iakop iuore ngan eau ta itnan tibur Peniel, be isenggesengge ngansa iae ituatua iseki maitne. ");
INSERT INTO bch_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Tota irangrang ngan labone pade, gid Israel tianean masilau ilislisia ise kasangai mao, ngansa eaba toa oa irau Iakop, ta ise kasanga ituatua iseki. ");
INSERT INTO bch_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Idio ta Iakop imata idae ta igera Iso inama toman ngan ele panua buno pange. Tota ipota gid gergeu rabu ngan Lea ga Resel ga gid taine paeaeanga toa rua oa. ");
INSERT INTO bch_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Ta ikeo ga taine paeaeanga toa rua oa toman ngan led gergeu tila timuga. Ga kus ta Lea toman ngan ele gergeu tilalala ga tinasi gid. Be Resel ga Iosep tisomur ngan gid. ");
INSERT INTO bch_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Be Iakop ila imuga ngan ele panua toa ngada oa. Io, ipaboloma itar kapei Iso ta ikor iae ga idol ilabora ga isulug tanoeai. Ikado toa bedaoa palima ga rua ga ila irangrang ngan iuot pan. ");
INSERT INTO bch_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Be Iso ilado ga ila pan ta iluku ei ta idol ilabora ga idae ikepeai ta ibusum ipapa. Ta gisirua titang. ");
INSERT INTO bch_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ta Iso imata idae ta igera gid taine toman ngan led gergeu. Ta ibeta Iakop, “Sapadua toa gimingada?” Ta Iakop ikeo, “Deo ikado kemi tau ngan gau, lem paeaeanga, ta ibada gid gergeu toa ne ga tinam pagau.” ");
INSERT INTO bch_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Idio ta gid taine paeaeanga tinam toman ngan led gergeu ta tikor aed pan Iso ta tidol laborad ga isulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Ga kus ta Lea toman ngan ele gergeu tinam ta tikor aed pade ta tidol laborad ga isulug tanoeai. Ta muriai ngan gid toa ngada oa, Iosep ga Resel tinam tikor aed pade ta tidol laborad ga isulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Ta Iso ikeo, “Be gid masilau mud ipu toa tiuot pagau edapeai oa timan saoa aea?” Ta Iakop ikeo, “Ag maron, eine timan leg tenainga ila pago ta lolom marum ngan gau.” ");
INSERT INTO bch_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Ta Iso ikeo, “Ag kakau, leg danga sisid busa na. Kemi ngan lem danga sisid idio mulian pago.” ");
INSERT INTO bch_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Be Iakop ikeo, “Mao, mao. Oangga eao lolom marum ngan gau, bada tenainga toa ne togau ga iman lem. Patautene nagera matam, eine mambe nagera Deo imata, ngansa lolom marum ngan gau toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Eao manta bada leg tenainga toa nabada pago ne, ngansa Deo ikado kemi tau ngan gau, ta leg danga sisid imata karanga.” Io, Iakop iparpar tau ngan Iso ga irangrang ngan ilongo, ta ibada ele tenainga toa oa. ");
INSERT INTO bch_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Idio ta Iso ikeo, “Io, gita tala. Ta gau ga napasolan go ngan edap.” ");
INSERT INTO bch_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Be Iakop ikeo, “Ag maron, eao oatai, gid gergeu urad tau mao. Be lolog ede ga ede ngan gid sipsip ga bulmakao toman ngan led gergeu toa tidudud maitne. Manta namariala kemi ngan gid. Oangga nakado gid ga tilalala ado dodol kelede pade, eine gid sipsip toa ngada oa ga timate. ");
INSERT INTO bch_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tota ag maron, kemi ngan eao muga, be gau, lem paeaeanga, ga tem ga tem muriai ta nanasi lalalanga togid masilau ipu ga gid gergeu, ga irangrang ngan naot pago ngan tibur kapei Seir.” ");
INSERT INTO bch_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Ta Iso ikeo, “Kemi ngan nalongean leg paeaeanga etangada ga tidio pago ngan badanga gimi ga anam.” Be Iakop ikeo, “Eao oangga kado toa bedane ngan saoa? Eine kemi mao, be oangga lolom marum ngan gau, eine ikaranga.” ");
INSERT INTO bch_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tota ngan ado toaiua, Iso ilalala ga iluai mulian ngan tibur kapei Seir. ");
INSERT INTO bch_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Be Iakop ila ngan tibur Sukot, ta ikado ele luma ta irau palata gereirei togid masilau. Tota iuato tibur toa oa ieda Sukot. ");
INSERT INTO bch_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ngan kadonga toa bedaoa Iakop itnan tibur kapei Padan-Aram, ta iluai mulian ngan tibur kapei Kenan, be ele lalalanga iuot kemi. Ta irau saupu boloma ngan tuanga Sekem. ");
INSERT INTO bch_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ta tano idanga tede toa irau saupu ngan, ei iuol pagid iaoa kelede ton Sekem toa Amor inat. Tano toa oa aea olnga irangrang mambe pat silva buno. ");
INSERT INTO bch_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Toa eoa ipagun popou tenainga aea ta iuato popou toa oa ieda El-Eloe-Israel. ");
INSERT INTO bch_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Idio ta Daina toa gergeu taine ton Iakop ga Lea, ila ngan geranga gid taine toa timamado ngan tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Be eaba ede ieda Sekem imamado. Ei gergeu ton tibur toa oa aea madidnga kapei ieda Amor, eaba Ivi aea. Sekem igera Daina ta iluku ei ta ieno toman ngan ei ga ipamaeamaea ei. ");
INSERT INTO bch_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Be ilolo ikim tau Daina, Iakop inat taine, ta ikado posanga meles pan. ");
INSERT INTO bch_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tota Sekem ila ikeo pan itama Amor bedane, “Apa, bada taine toaine ga inam ta naoai ei.” ");
INSERT INTO bch_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Idio ta Iakop ilongo posanga ngan ei ikado kadonga paeamao toa oa ngan inat taine, be ele gergeu arangaranga timariala ngan gid sipsip ga meme tiburiai. Ta Iakop iposa mao ga irangrang ngan tiluagid mulian ga tinam lumaeai. ");
INSERT INTO bch_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Be Sekem itama Amor ila pan Iakop ta iposaposa toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Be Iakop ele gergeu arangaranga tiluagid mulian tiburiai ga tinam tutui ngan ado imata toa tilongo posanga toa oa. Gid lolod bake tau ngansa kadonga toa Sekem ikado ngan enonga toman ngan liud, eine kadonga paeamao tau ngan gid Israel matad, ta tikeo ga kadonga toa bedaoa manta panua tikado mao. ");
INSERT INTO bch_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Be Amor ikeo pagid, “Gau natug Sekem ilolo ikim tau natum taine, tota nakeo ga gimi alongean ei ta iuai ei. ");
INSERT INTO bch_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Kemi ngan gitaingada taluplup ga tamado. Alongean lemi gergeu taine ta tiuaioai gai, ta gai pade ga alongean lemai gergeu taine ta tiuaioai gimi. ");
INSERT INTO bch_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Ta kemi ngan gimi amamado toman ngan gai ngan tibur kapei toaine. Gimi ala amado ngan tibur isaoa akim. Ta akado lemi naurata pat aea ga aol tano idanga teta togimi.” ");
INSERT INTO bch_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Be Sekem pade ikeo pan Daina itama ga iliuliu bedane, “Gau nakim lolomi marum ngan gau, ta alongo ngan leg betanga. Oangga bedaoa, saoa danga gimi abeta gau ngan, eine ga nabada pagimi. ");
INSERT INTO bch_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Oangga gimi adol taine toaine aea olnga kapei ta akeo pagau ngan saoa gerebo ga nabada pagimi, goibe eine ga naol. Be gau lolog ikim kapei ngan taine toaine iman adaoag.” ");
INSERT INTO bch_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Be Iakop ele gergeu arangaranga tikado posanga pakakanga pan Sekem ga itama Amor, ngansa ei ikado kadonga paeamao ngan liud. ");
INSERT INTO bch_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ta tikeo pagisirua bedane, “Eaba sai toa ibada palunga mao, irangrang ngan gai alongean ei ga iuai liumai mao. Oangga bedaoa, eine ga maeamaea gai kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Edap kelede mon ienono ngan gai alongo ngan lemi betanga: Manta apalu lemi arangaranga toa ngada ne, ta tiuot mambe gai. ");
INSERT INTO bch_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Oangga akado toa bedaoa, eine gai ga alongean lemai gergeu taine ta tiuaioai gimi, ta gai pade ga aoaioai lemi gergeu taine. Toa bedaoa ta gai ga amado toman ngan gimi ta gitaingada taot alu kelede. ");
INSERT INTO bch_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Be oangga gimi alongo ngan badanga palunga mao, eine gai ga abada liumai ta atnan gimi ga ala.” ");
INSERT INTO bch_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Io, Amor ga inat Sekem tikim posanga toaine. ");
INSERT INTO bch_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Tota eaba iriau toa oa ikado aea gerei mao, ngansa ilolo ikim Iakop inat taine kapei tau. Be ei ieda kapei rabu ngan itama isobosobo toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Tota Amor ga inat Sekem tila ngan tibur rourounga aea boloma ngan tuanga toa oa aea atama iaoa, ta tikeo pagid arangaranga tuangai ad bedane, ");
INSERT INTO bch_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Gid panua iaoa toaine gid panua kemikemi, tikeo ga timado kemi toman ngan gita. Ega, gita ada tano kapei. Kemi ngan talongean gid ta timado ngan leda tibur kapei ne ngan tibur isaoa tikim, ta tikado led naurata pat aea. Kemi ngan taoaioai led gergeu taine, ta gid pade ga tiuaioai leda gergeu taine. ");
INSERT INTO bch_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Be tinid ngan timado toman ngan gita ga timan alu kelede toman ngan gita sapaean mao. Tiparpar ngan posanga kelede ga oaine: Tikeo ga gita arangaranga manta tabada palunga ta taot mambe gid. ");
INSERT INTO bch_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Oangga takado bedane, eine led bulmakao ga masilau mud ga danga sisid toa ngada oa ga iman leda! Tota kemi ngan talongo led posanga ta timado pagita.” ");
INSERT INTO bch_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Io, gid panua toa tirourou ngan tuanga toa oa aea atama iaoa, gid toa ngada oa lolod kelede ngan Amor ga Sekem led posanga, ta tipalu gid arangaranga toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ngan ado tol aea gid panua toa oa tinid ieiei maitne, be Iakop inat rua Simeon ga Livai toa Daina iliuliu, tibada led didi paraunga aea ta tidudunga ngan tuanga Sekem ta tiraurau gid arangaranga toa ngada oa ga timate. Be eaba eta irangrang ngan ipaidi gid mao. ");
INSERT INTO bch_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tirau Amor ga inat Sekem ngan didi ga kus ta tibada mulian Daina toa imamado Sekem ele lumaeai ta tila. ");
INSERT INTO bch_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ga kus ta Iakop ele gergeu arangaranga padengada tila Sekem pade ta tigera panua patid ienono, ta tilublub led danga sisid toa ngada oa. Kadonga toa oa iman kolinga ngan kadonga paeamao toa Sekem ikado ngan liud. ");
INSERT INTO bch_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Ta tibada led sipsip ga bulmakao ga donki, ga danga sisid toa ienono tuangai ga gaot ngan tuanga. ");
INSERT INTO bch_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Tipaeaoa adadaoad ga led gergeu pade ta tilublub led pat ga danga sisid ngan luma toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Ga kus ta Iakop ikeo pan Simeon ga Livai bedane, “Gimi akado ga kadonga paeamao idae ngan gau. Gid panua Kenan ga Peres ngan tibur kapei toa ne ga tigera gau mambe eaba paeamao ede. Gau leg panua ne busa mao, ta oangga tiluplup ga tikado paraunga pagau, eine ga tipamukuru gaingada leg panua toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Be gisirua tikoli ele posanga bedane, “Ikamado? Eine kemi ngan talongean ei ta ikado ga liumai iuot mambe taine edap aea pade?” ");
INSERT INTO bch_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Idio ta Deo ikeo pan Iakop bedane, “Eao dae ta la mado ngan tibur Betel ta kado popou tenainga aea ngan kadonga tenainga pagau. Gau Deo toa mugaeai naot pago ngan ado toaiua eao eaoa ngan tadim kapei Iso.” ");
INSERT INTO bch_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tota Iakop iposa pagid iadadaoa ga ele gergeu ga gid panua toa ngada oa timamado toman ngan ei, ta ikeo, “Atado gid deo ad namer tienono pagimi ga tiduaea. Manta anasi kadonga ngan sigiringa tinimi aea muk Deo imatai. Ta adol ami barikia papau. ");
INSERT INTO bch_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ga kus ta tatnan tuanga toa ne ta tala Betel. Toa eoa ga nakado popou tenainga aea ton Deo. Ei Deo toa ilongo gau ga ilua gau ngan ado toaiua danga kulupu iuot ngan gau. Be imamado toman ngan gau ngan leg lalalanga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tota tibada gid deo ad namer toa ngada oa ga ila pan Iakop ga tibada tangad aea pato pade ga ila pan. Ta Iakop idom gid abei ouk ede ibuloloeai, boloma ngan tuanga Sekem. ");
INSERT INTO bch_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Ga kus ta tilalala ga tila, be Deo ikado ga gid panua toa ngada oa ngan gid tuanga boloma timataud gid gergeu arangaranga ton Iakop ta tibutatan gid mao. ");
INSERT INTO bch_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Idio ta Iakop ga ele panua toa ngada oa tiuot ngan tuanga Lus ngan tibur kapei Kenan. Lus eine Betel ieda mugamuga. ");
INSERT INTO bch_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Toa eoa ipagun popou tenainga aea ta iuato tibur toa oa ieda El-Betel ngansa toa eoa Deo ipasolan ei mulian pan Iakop ngan ado toaiua iaoa ngan itar kapei. ");
INSERT INTO bch_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Gid timamado ngan tibur toa oa, be Rebeka ele paeaeanga, taine kapei Debora toa imariala ngan ei oa, imate ta titaian ei abei ouk ede ibuloloeai, boloma ngan tuanga Betel. Ta tiuato abei toa oa ieda Alon-Bakut. ");
INSERT INTO bch_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Muriai ngan Iakop itnan tibur kapei Padan-Aram ga iluai mulian ngan tibur Kenan, Deo iuot pan pade ta ikado posanga kemi ngan pamatuanga ei. ");
INSERT INTO bch_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Ta Deo ikeo pan bedane, “Labone edam Iakop, be muriai ga ila, gid panua ga tiuatoato edam Iakop pade mao. Eine ga tiuato edam pau Israel.” Toa bedaoa ta idol ieda pau Israel. ");
INSERT INTO bch_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Ta Deo ikeo pan pade bedane, “Gau Deo Matua Soke Tau. Eao manta papot gid gergeu busa. Ta muriai lem gergeu ga tibutibum tiuot alu busa. Edengada ngan gid ga tiuot mamaron kapeipei. ");
INSERT INTO bch_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tano toa napan ga iman Abraam ga Aisak ad mugaeai, eine ga napan ga iman eao am pade. Ta muriai ngan eao, eine ga napan ga iman lem gergeu ga tibutibum ad.” ");
INSERT INTO bch_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Deo iposa bedaoa pan ga kus ta itnan ei ga idio ta idae ga ila gadae. ");
INSERT INTO bch_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Idio ta Iakop ipagun pat mamarae ede ta iman kilala ngan tibur toa Deo iposaposa pan ngan. Ga kus ta itok oain ga bude oliv aea ga idae ngan pat toa oa ta iman tenainga ila pan Deo. ");
INSERT INTO bch_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Ta Iakop iuato tibur toa Deo iposaposa pan ngan oa ieda Betel. ");
INSERT INTO bch_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Idio ta titnan tibur Betel ta tilalala ga tila pade. Be tipaboloma tuanga Eprata, ta Resel inaman gergeu ituntun ei, be ieiei paeamao tau. ");
INSERT INTO bch_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Inaman ieieinga kapei maitne, be taine papoponga aea ikeo pan bedane, “Eao mataud mao. Eine lem gergeu aranga ede pade.” ");
INSERT INTO bch_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Io, Resel iuangga imate, be idada mosonga pakelede ta iuato gergeu toa oa ieda Benoni. Be itama iuato ieda Benjamin. ");
INSERT INTO bch_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Resel imate ga kus ta titaian ei edap isaleai, boloma ngan tuanga Eprata. (Eprata eine Betleem ieda mugamuga.) ");
INSERT INTO bch_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ta Iakop ipagun pat ede iman kilala ngan Resel aea denga. Ta labone pat toa oa ienono maitne. ");
INSERT INTO bch_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Idio ta Israel ilalala ga ila pade ta itnan tuanga Migdal-Eder. Ta irau ele saupu pade. ");
INSERT INTO bch_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Israel imamado ngan tibur toa oa maitne, be Ruben ieno toman ngan Bila, itama ele taine paeaeanga. Be Israel ilongo posanga ngan kadonga toa oa iuot. Iakop ele gergeu arangaranga sangaul ga igegea rua. ");
INSERT INTO bch_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Gid gergeu arangaranga toa Lea ipopo, eine Ruben toa Iakop ele gergeu lautabe, ga Simeon ga Livai ga Iuda ga Isakar ga Sebulun. ");
INSERT INTO bch_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Be gid gergeu arangaranga toa Resel ipopo, eine Iosep ga Benjamin. ");
INSERT INTO bch_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Be gid gergeu arangaranga ton Resel ele taine paeaeanga Bila eine Dan ga Naptali. ");
INSERT INTO bch_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Be gid gergeu arangaranga ton Lea ele taine paeaeanga Silpa eine Gat ga Aser. Gid gergeu toa ne, Iakop imamado ngan tibur Padan-Aram, be iadadaoa tipopo gid. ");
INSERT INTO bch_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Idio ta Iakop iluai mulian pan itama Aisak ngan tuanga ton Mamre, boloma ngan tuanga Kiriat-Arba. (Kiriat-Arba eine Ebron ieda mugamuga.) Tuanga toa oa, Abraam ga Aisak timamado ngan mugaeai. ");
INSERT INTO bch_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Aisak aea rai toa ngada oa iuot buno ede sangalima sangaul tol (180). ");
INSERT INTO bch_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Ei iuot eaba kapei tau ta imate ga ila ieno toman ngan itubtub. Ta inat rua Iso ga Iakop titaian ei. ");
INSERT INTO bch_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Iso ieda ede pade Idom. Aea titnga ga bedane: ");
INSERT INTO bch_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Iso iuai gid taine Kenan ad. Ede eine Ada, gergeu taine ton Elon, eaba It aea. Ga ede pade eine Oolibama, gergeu taine ton Ana. Be Ana ei gergeu taine ton Sibeon, eaba Ivi aea. ");
INSERT INTO bch_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ga pade, iuai Basemat, gergeu taine ton Ismael. Be Basemat ei Nebaiot iliu. ");
INSERT INTO bch_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Ada ipopo Iso inat Elipas, be Basemat ipopo Ruel. ");
INSERT INTO bch_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Be Oolibama ipopo Jeus ga Ialam ga Kora. Iso imamado ngan tibur Kenan, be iadadaoa tipopo gid gergeu toa ne. ");
INSERT INTO bch_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Idio ga muriai ta Iso itnan itar kakau Iakop ta ila imado ngan tibur ede pade. Ei ibada iadadaoa ga ele gergeu arangaranga ga taine ga gid panua toa ngada oa timamado toman ngan ei, ga ele bulmakao ga masilau mud padengada, ga ele danga sisid toa ngada oa ibada ngan tibur Kenan, ta tila. ");
INSERT INTO bch_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Iso itnan Iakop ngansa gisirua led danga sisid ga masilau mud tiuot busa tau, ta tano toa oa irangrang ngan gisirua tilup ga timado ngan mao. ");
INSERT INTO bch_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tota Iso ila imado ngan tibur aea bereo ngan tibur kapei Seir. (Iso ieda ede pade Idom.) ");
INSERT INTO bch_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Iso eine gid panua Idom tibud. Gid Idom timamado ngan tibur aea bereo ngan tibur kapei Seir. Iso aea titnga ga bedane. ");
INSERT INTO bch_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Iso ele gergeu arangaranga edad ga bedane: Elipas toa gergeu ton Iso iadaoa Ada, ga Ruel toa gergeu ton Iso iadaoa Basemat. ");
INSERT INTO bch_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Be Elipas ele gergeu arangaranga edad ga bedane: Teman ga Omar ga Sepo ga Gatam ga Kenas. ");
INSERT INTO bch_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Be Iso inat Elipas iuai taine paeaeanga ede ieda Timna. Ta Timna ipopo Amalek. Gid gergeu toa ne, gid Iso itubtub pan iadaoa Ada. ");
INSERT INTO bch_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Be Ruel ele gergeu arangaranga edad ga bedane: Naat ga Sera ga Sama ga Misa. Gid gergeu toa ne, gid Iso itubtub pan iadaoa Basemat. ");
INSERT INTO bch_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Be Iso iadaoa Oolibama ipopo Jeus ga Ialam ga Kora. Gid gergeu toa ne, tnad ei Oolibama, gergeu taine ton Ana. Be Ana ei gergeu taine ton Sibeon. ");
INSERT INTO bch_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Iso itubtub edengada tiuot madidnga. Iso inat lautabe Elipas ele gergeu toa muriai tiuot madidnga, edad ga bedane: Teman ga Omar ga Sepo ga Kenas ");
INSERT INTO bch_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ga Kora ga Gatam ga Amalek. Gid gergeu toa ne timado ngan tibur kapei Idom be tiuot madidnga. Gid eine Elipas ele gergeu ga Ada itubtub. ");
INSERT INTO bch_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Iso inat Ruel ele gergeu toa muriai tiuot madidnga, edad ga bedane: Naat ga Sera ga Sama ga Misa. Gid gergeu toa ne timado ngan tibur kapei Idom be tiuot madidnga. Gid eine Ruel ele gergeu ga Iso iadaoa Basemat itubtub. ");
INSERT INTO bch_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Iso iadaoa Oolibama ele gergeu toa muriai tiuot madidnga, edad ga bedane: Jeus ga Ialam ga Kora. Gid madidnga toa ne, gid Iso iadaoa Oolibama ele gergeu. Be Oolibama ei gergeu taine ton Ana. ");
INSERT INTO bch_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Gid gergeu toa ne, gid Iso ele gergeu toa muriai tiuot madidnga ngan gid iaoa kelede kelede togid. Be Iso ieda ede pade Idom. ");
INSERT INTO bch_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seir ei eaba ede Or aea, be gid Or timamado motean ngan tibur kapei Idom. Seir ele gergeu arangaranga edad ga bedane: Lotan ga Sobal ga Sibeon ga Ana ");
INSERT INTO bch_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ga Dison ga Eser ga Disan. Gid panua toa ne, gid Seir ele gergeu arangaranga, be tiuot madidnga ngan gid panua Or toa timamado ngan tibur kapei Idom. ");
INSERT INTO bch_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Be Lotan ele gergeu arangaranga edad ga bedane: Ori ga Emam. Be Timna ei Lotan iliu. ");
INSERT INTO bch_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Be Sobal ele gergeu arangaranga edad ga bedane: Alvan ga Manaat ga Ebal ga Sepo ga Onam. ");
INSERT INTO bch_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Be Sibeon ele gergeu arangaranga edad ga bedane: Aia ga Ana. Ana toa ne imariala ngan itama Sibeon ele donki ngan tibur modamodanga, be iuot ngan gid eaumata oanaoana. ");
INSERT INTO bch_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Be Ana ele gergeu edad ga bedane: Dison ga Oolibama. Oolibama ei gergeu taine ton Ana. ");
INSERT INTO bch_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Be Dison ele gergeu arangaranga edad ga bedane: Emdan ga Esban ga Itran ga Keran. ");
INSERT INTO bch_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Be Eser ele gergeu arangaranga edad ga bedane: Bilan ga Savan ga Akan. ");
INSERT INTO bch_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Be Disan ele gergeu arangaranga edad ga bedane: Us ga Aran. ");
INSERT INTO bch_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Gid panua toa tiuot madidnga ngan gid Or, edad ga bedane: Lotan ga Sobal ga Sibeon ga Ana ");
INSERT INTO bch_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ga Dison ga Eser ga Disan. Gid panua toa ne timadid ga timugamuga ngan gid lum ga lum togid Or ngan tibur kapei Seir. ");
INSERT INTO bch_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Gid Israel ad maron kapei eta iuot maitne, be panua ga gid ne tiuot mamaron kapeipei ngan tibur kapei Idom: ");
INSERT INTO bch_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bela, gergeu ton Beor, iuot maron kapei togid Idom. Ele tuanga ieda Dinaba. ");
INSERT INTO bch_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Be Bela imate ga kus ta Iobap, gergeu ton Sera ngan tuanga Bosra, ibada imul ta iuot maron kapei. ");
INSERT INTO bch_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Be Iobap imate ga kus ta Usam, eaba ede Teman aea, ibada imul ta iuot maron kapei. ");
INSERT INTO bch_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Be Usam imate ga kus ta Adat, gergeu ton Bedat, ibada imul ta iuot maron kapei. Adat toa oa ila ngan tibur kapei Moap ta iparau pagid Midian ta iasal gid. Ele tuanga ieda Avit. ");
INSERT INTO bch_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Be Adat imate ga kus ta eaba ede ieda Samla ngan tuanga Masreka ibada imul ta iuot maron kapei. ");
INSERT INTO bch_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Be Samla imate ga kus ta eaba ede ieda Saul ibada imul ta iuot maron kapei. Ele tuanga Reobot, boloma ngan eau kapei Iupretis. ");
INSERT INTO bch_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Be Saul imate ga kus ta Balanan, gergeu ton Akbor, ibada imul ta iuot maron kapei. ");
INSERT INTO bch_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Be Balanan, gergeu ton Akbor, imate ga kus ta Adar ibada imul ta iuot maron kapei. Ele tuanga ieda Pau. Iadaoa ieda Meetabel, gergeu taine ton Matret. Be Matret ei Mesaap ele gergeu taine. ");
INSERT INTO bch_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Gid madidnga ngan gid iaoa kelede pan Iso timadid ga timugamuga ngan gid lum kelede kelede, be tila timado ngan gid kelede kelede ad tano. Gid madidnga toa ne edad ga bedane: Timna ga Alva ga Ietet ");
INSERT INTO bch_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ga Oolibama ga Ela ga Pinon ");
INSERT INTO bch_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ga Kenas ga Teman ga Mipsar ");
INSERT INTO bch_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","ga Makdiel ga Iram. Gid madidnga toa ne timadid ga timugamuga ngan gid panua Idom ad, ngan gid kelede kelede led tuanga ga ad tano. Eiua Iso aea titnga. Ei gid panua Idom tibud. ");
INSERT INTO bch_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Iakop imamado Kenan ngan tibur toa itama Aisak imamado ngan mugaeai. ");
INSERT INTO bch_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Gid gergeu arangaranga ton Iakop ad titnga ga bedane: Iosep ei iriau, aea rai sangaul ede igegea lima ga rua. Ei gisingada gid gergeu arangaranga togid itama iadadaoa, Bila ga Silpa, tila timariala ngan gid sipsip ga meme. Be Iosep ipalongo itama ngan itar kapeipei led kadonga paeamao. ");
INSERT INTO bch_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israel ikimkim Iosep kapei ta ele kimnga toa ne iasal ele kimnga ngan ele gergeu padengada. Ikim Iosep kapei toa bedaoa ngansa itna ipopo ei ngan ei eaba kapei tau. Tota ikado ele pononga mamarae toa aea sogonga kemikemi oa ta ibada pan. ");
INSERT INTO bch_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ta Iosep itar kapeipei tigera mambe tamad ikim ei kapei, be gid tau mao. Tota lolod paeamao ngan ei, ta irangrang ngan tikado posanga eta kemi pan mao. ");
INSERT INTO bch_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Be ado ede Iosep ianun ta ininipu pagid itar kapeipei ngan. Gid tilongo ngan ianun toa oa, ta lolod paeamao pan kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Be Iosep ininipu pagid bedane, “Alongo anunug ga oaine: ");
INSERT INTO bch_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Ega, gita takaukau gid wit aea tulua dadangai. Be mole mao, gau leg tulua idae imadid tutui, be gimi lemi tulua tibalil ngan gau leg ta tidol laborad ga isulug tanoeai boloma ngan gau leg.” ");
INSERT INTO bch_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Itar kapeipei tilongo bedane ta tikeo, “Eao oangga ot maron kapei ngan gai, ta gai adio eao bagemeai na?” Tota itar kapeipei lolod paeamao ga paeamao tau ngan ei, ngansa ininipu pagid ngan ianun toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Idio ta ianun pade ta ininipu pagid itar kapeipei bedane, “Ega, gau anunug pade ta mole mao nagera ado ga taiko ga gigima sangaul igegea ede tikor aed ga tidol laborad ga isulug tanoeai pagau.” ");
INSERT INTO bch_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Iosep ininipu pan itama toman ngan itar kapeipei ngan ianun toa oa, be itama idaba ei ta ikeo, “Anunum ne madongan? Eao oangga gaingada tnam ga am kapeipei anam akor aemai ta adol laboramai ga isulug tanoeai pago na?” ");
INSERT INTO bch_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Tota Iosep itar kapeipei lolod paeamao ngan ei, be itama imata nanan posanga toa ne. ");
INSERT INTO bch_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Be ado ede Iosep itar kapeipei tila ngan tibur ede boloma ngan tuanga Sekem ngan ilonga tibur aea purup kemikemi ta led sipsip tianean. ");
INSERT INTO bch_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Ta Israel ikeo pan Iosep bedane, “Tadim kapeipei tila ngan tibur ede boloma ngan tuanga Sekem ngan ilonga tibur kemikemi ngan gid sipsip tian purup. Gau nakim eao la pagid.” Ta Iosep ikeo, “Goibe. Gau ga nala.” ");
INSERT INTO bch_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Tota Israel ikeo pan bedane, “La gera am kapeipei ga leda sipsip, timamado kemi, mao madongan? Eao gera ga kus ta eabalan posanga ga inam pagau.” Tota isula Iosep ga ila. Iosep itnan itama ngan dubu kapei ngan tibur Ebron ta ila iuot ngan tuanga Sekem. ");
INSERT INTO bch_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Ei ilalala ngan tibur toa oa, be eaba ede iuot pan ta igera mambe ibuobuo ngan edap ta ibeta ei, “Eao iloilo saoa?” ");
INSERT INTO bch_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Ta Iosep ikeo, “Gau nailoilo tadig kapeipei. Gid tibada led sipsip ga tila ngan tibur isaoa? Eao oatai pade?” ");
INSERT INTO bch_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Ta eaba toa oa ikeo, “Gid titnan tibur toa ne ta nalongo tikeo ga tila ngan tuanga Dotan.” Tota Iosep inasi itar kapeipei ta ila boloma ngan tuanga Dotan, ta igera gid timamado aluai tede. ");
INSERT INTO bch_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Gid tigera mambe ei ilalala aluai tede maitne, be mugaeai ngan ipaboloma gid, tirau posanga ngan pamatenga ei. ");
INSERT INTO bch_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Ta tiposa pol ngan gid bedane, “Ega, eaba toa ianun somisomi ta inama. ");
INSERT INTO bch_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Alongo! Kemi ngan tarau ei ga imate, ta tatado ipat ga idudunga ngan baba eta. Ga kus ta takeo ga, ‘Masilau saksak ede ian ei.’ Toa bedaoa ta tagera ianun toa ininipu ngan oa iuot madongan.” ");
INSERT INTO bch_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Be Ruben ilongo mambe itar kakakau tiposa toa bedaoa, ta iuangga ibada ei mulian pagid bagedeai. Ta ikeo, “Tarau ei ga imate mao. ");
INSERT INTO bch_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Tatado ei ga idudunga ngan eau aea baba ga eko, ngan tibur modamodanga toa ne. Be tapaeabu ngan ei mao.” Ruben ikado posanga toa ne ngansa iuangga ibada Iosep mulian pagid bagedeai ta ibada ei ga iluai mulian pan itama. ");
INSERT INTO bch_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Io, Iosep iuot pagid itar kapeipei ga kus ta tiluku ei ta titil ele pononga mamarae toa aea sogonga kemikemi oa. ");
INSERT INTO bch_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Ga kus ta titado ei ga idudunga ngan eau aea baba toa oa. Be baba toa oa mamasa. ");
INSERT INTO bch_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Ga kus ta tidio timado ga tianean, be mole mao matad idae ta tigera panua iaoa ede Ismael ad tilalala ga tinam toman ngan led kamel. Gid titnan tibur Gileat ga tinam ta tiuangga tila Isip ngan panua tiuolol led danga sisid. Led tulua toa kamel paodeai oa iuon ngan bude kemikemi dibala aea, ga danga padengada iuad kemikemi, ga abei mer itekea. ");
INSERT INTO bch_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Be Iuda ikeo pagid itar kapeipei ga aea kakakau bedane, “Oangga tarau ei ga imate, be tapamumul ising, eine kadonga toa ne ga ilua gita madongan? ");
INSERT INTO bch_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Alongo! Kemi ngan tadol ei ga idae pagid Ismael bagedeai ta tiuol ei ga iman led paeaeanga sapaean. Be tarau ei ga imate mao. Ngansa ei gita ada kakau ga gita sing kelede.” Ta Iuda itar kapeipei ga aea kakakau tinasi ele posanga. ");
INSERT INTO bch_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tota gid panua oalo ad toa led tuanga ipu Midian oa tinama tiuot. Be Iosep itar kapeipei tidada ei babaeai ga idae, ta tidol ei ga idae pagid Ismael toa oa bagedeai, ta tiuol ei ngan pat silva sangaul rua. Ta tibada ei ga ila Isip. ");
INSERT INTO bch_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Idio ta Ruben iluai mulian babaeai, be ikakrik ngansa igera Iosep mao. Ta ilolo isat ga itaka ele pononga mulian. ");
INSERT INTO bch_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Ta iluai ga ila pagid itar kakakau ta ikeo, “Ada kakau eoa mao! Eine ga nakado mado?” ");
INSERT INTO bch_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Tota tipamate meme ede ta tibada ising ta tigasi Iosep ele pononga mamarae ga idudunga ngan. ");
INSERT INTO bch_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Ta tibada pononga mamarae toa aea sogonga kemikemi oa ga ila pan tamad ta tikeo, “Gai alalala ngan tibur ede, be aot ngan danga ga oaine. Gera kemi. Kado natum ele pononga mamarae.” ");
INSERT INTO bch_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ta tamad igera ga iuatai ngan ta ikeo, “Tautaunga. Eine natug ele pononga mamarae! Kado masilau saksak eta ipaeabu ngan Iosep ga imate.” ");
INSERT INTO bch_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tota Iakop ilolo isat kapei ta itaka ele pononga mulian ta ikado mok lolo isat aea. Be ado ga ado itangtang ngan inat irangrang ngan taiko busa. ");
INSERT INTO bch_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ele gergeu arangaranga ga taine toa ngada oa tila pan ta titoba ngan pamusnga ei, be ei itin ngan mao. Ta ikeo, “Gau ga natangtang ngan ei ga irangrang ngan namate ta nala pan ngan tibur togid panua matemate.” Tota itama itang kapei tau ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Be gid panua Midian toa oa tibada Iosep ga ila Isip ta tidol ei ga idae pan madidnga kapei ede ibageai ieda Potipa, ta iuol ei ga iman ele paeaeanga sapaean. Potipa toa, ei madidnga ede ngan gid panua paraunga ad, be imariala ngan luma ton maron kapei Isip aea. ");
INSERT INTO bch_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ngan ado toaiua, Iuda itnan itar kapeipei ga aea kakakau ta ila igera iarea ede ieda Ira ngan tuanga Adulam, ta idio imado pan toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Toa eoa Iuda igera taine ede Kenan aea toa itama ieda Sua. Ta iuai ei ta ieno toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Idio ta iapa ta ipopo gergeu aranga ede. Ta Iuda iuato ieda Er. ");
INSERT INTO bch_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Idio ga muriai ta iapa pade ta ipopo gergeu aranga ede ieda Onan. ");
INSERT INTO bch_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ga kus ta ipopo gergeu aranga ede pade ta iuato ieda Sela. Iuda imamado ngan tuanga Kesip, be iadaoa ipopo Sela. ");
INSERT INTO bch_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Iuda ele gergeu tidae kapeipei, ta ibada taine ede ieda Tamar ga iman ele gergeu lautabe Er iadaoa. ");
INSERT INTO bch_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Be Iuda ele gergeu lautabe Er ele kadonga paeamao tau Maron imatai, ta Maron irau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Ga kus ta Iuda ikeo pan Onan bedane, “Eao nasi gita alu toa ne leda nasinga ta la eno toman ngan tadim kapei iadaoa, ta gimirua apapot tadim kapei ele gergeu eta. Toa bedaoa ta iaoa kelede pan tadim kapei irangrang ngan kus mao.” ");
INSERT INTO bch_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Be Onan iuatai, oangga ipapot gergeu ton itar kapei, gergeu toa oa ga ei ton mao. Ta somisomi oangga gisirua tieno, ilongean isul ga itoki ga isulug tanoeai. Ngan kado ta ipapot itar kapei ele gergeu. ");
INSERT INTO bch_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ele kadonga toa oa paeamao tau Maron imatai. Tota irau ei pade ga imate. ");
INSERT INTO bch_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ga kus ta Iuda ikeo pan ilaoa taine Tamar bedane, “Eao man asape na. Tota luago mulian tamam ele lumaeai ge. Oangga muriai, natug Sela idae kapei, ta gimirua aoai.” Iuda ikado posanga sapaean toa bedaoa ngansa imataud. Ngan kado ta Sela pade imate mambe itar kapeipei. Tota Tamar iluai mulian itama ele lumaeai ta idio imado toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Be mole tede ga kus ta Iuda iadaoa imate pade. (Iadaoa toa ei gergeu taine ton Sua.) Idio ta Iuda ipasala ele madonga lolo isat aea ga kus, ta ila ngan tuanga Timna ngan geranga gid panua toa tiketket ele sipsip launid. Be iarea Ira, eaba Adulam aea, ila toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Be Tamar ilongo gid panua tikeo pan bedane, “Ega, laoam patautene ila ngan tuanga Timna ngan ketnga ele sipsip launid.” ");
INSERT INTO bch_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Be Tamar igera mambe Sela ei kapei na, be Iuda ipaoai gisirua mao. Tota Tamar itil ele danga sisid mok aea ta ipamumul imata ngan malo kakauede, mambe gid taine edap ad tikakado. Ga kus ta idio imado edap iaoai boloma ngan tuanga Enaim. Tuanga toa oa ienono rabu ngan edap ila ngan tuanga Timna. ");
INSERT INTO bch_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Be Iuda ilalala ga inam ta iadi mambe ei taine ede edap aea ngansa ipamumul imata. ");
INSERT INTO bch_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tota Iuda ila pan toa edap isaleai oa, ta ikeo, “Nam gitarua taeno.” Be ei iuatai mao mambe taine toa oa, ei ilaoa taine. Ta taine ibeta ei, “Be eao ga bada saoa pagau ta gitarua taeno.” ");
INSERT INTO bch_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ta ikeo, “Gau ga naeabalan leg meme daenga pau eta ga ilat pago.” Ta taine toa oa ikeo, “Goibe, be eao manta bada danga eta pagau iman kilala ngan am gigi pagau, ta oangga lem meme inam iuot pagau ga kus, eine ga naeabalan lem danga iluai mulian.” ");
INSERT INTO bch_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Ta Iuda ikeo, “Eine ga nabada saoa pago iman kilala ngan ag gigi?” Ta ikeo, “Eao bada lem toto lalalanga aea toa ienono bagemeai ga am namer toman ngan aea oaro toa ienono gagalimeai, ta longean ga inam pagau bua.” Tota Iuda ibada gid danga toa oa ga ila pan ta ieno toman ngan ei. Ta Tamar iapa. ");
INSERT INTO bch_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Tamar itnan ei ga ila ga kus ta itil malo kakauede toa imatai oa, ta idol mulian ele danga sisid mok aea. ");
INSERT INTO bch_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Idio ta Iuda ibada meme daenga pau ede ga idae iarea toa eaba Adulam aea ibageai, ta isula ei ga ila ngan badanga mulian aea namer ga toto lalalanga aea toa ibada pan taine. Be ei iloilo taine toa oa ga mao. ");
INSERT INTO bch_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Ta ibeta gid arangaranga toa eoa bedane, “Taine edap aea sida, toa imamado edap iaoai boloma ngan tuanga Enaim?” Be tikeo pan bedane, “Taine eta edap aea imamado nene mao.” ");
INSERT INTO bch_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tota iluai mulian pan Iuda ta ikeo, “Gau nagera taine toa oa mao, be gid panua tuangai ad tikeo ga taine eta edap aea imamado toa eoa mao.” ");
INSERT INTO bch_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ta Iuda ikeo, “Goibe, gid danga oa idio pan. Tailoilo ei pade mao. Ngan kado ta panua tinging ngan gita. Ega, nanasi tutui leg posanga ta naeabalan meme ga ila pan, be eao ot ngan ei mao.” ");
INSERT INTO bch_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Io, taiko tol ila ga kus ta panua tipalongo Iuda bedane, “Ega, laoam taine Tamar ikado arala ta iapa.” Ta Iuda ikeo, “Abada ei ga inam ta tanono ei ngan dinga ga imate.” ");
INSERT INTO bch_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Idio ta tibada Tamar ga iuot, be ei ibada gid danga sisid toa iman kilala ngan Iuda aea gigi ta iabalan ga ila pan Iuda toman ngan posanga bedane, “Gau apag pan eaba toa ibada danga sisid ga nene pagau. Gera kemi. Namer toa ne toman ngan aea oaro ga toto lalalanga aea ne ton sai?” ");
INSERT INTO bch_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Iuda igera ta iuatai ngan ta ikeo, “Ei itutui. Be gau nakado kadonga paeamao, ngansa napaoai ei toman ngan natug Sela mao.” Tota Iuda ieno toman ngan ei pade mao. ");
INSERT INTO bch_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Idio ta Tamar imata boloma ngan poponga ta tigera mambe gergeu ninnga boge rua tienono iapai. ");
INSERT INTO bch_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ei iuangga ipopo gid, be gergeu ede ibage iuot, ta taine papoponga aea ikaukau ibage ngan oaro singsingia ede ta ikeo, “Gergeu toa ne imuga.” ");
INSERT INTO bch_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Be mole mao, idada ibage ga iluai mulian, ta itar kapei imuga ga iuot. Ta taine toa oa ikeo, “Madongan? Eao purususu ga ot na?” Ta iuato ieda Peres. ");
INSERT INTO bch_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Ga kus ta itar kakau iuot, be oaro singsingia ienono ibageai. Ta iuato ieda Sera. ");
INSERT INTO bch_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Be gid Ismael tibada Iosep ga ila Isip, ta Potipa toa eaba Isip aea oa, iuol ei ga iman ele paeaeanga sapaean. Potipa ei madidnga ede ngan gid panua paraunga ad, be imariala ngan luma ton maron kapei Isip aea. ");
INSERT INTO bch_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Be Maron Deo imamado toman ngan Iosep ta ikado ga ele naurata toa ngada oa iuot kemikemi. Iosep ibokoboko aea maron Isip aea ele lumaeai, ");
INSERT INTO bch_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ta aea maron igera mambe Maron Deo imamado toman ngan Iosep, ta saoa naurata toa ienono Iosep ibageai oa, Maron Deo ikado ga iuot kemikemi. ");
INSERT INTO bch_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Tota eaba toa oa ilolo marum ngan Iosep, ta idol ei ga iman ele aluagau. Ei idol Iosep ta imariala ngan ele luma, ta ele danga sisid toa ngada oa idae Iosep ibageai. ");
INSERT INTO bch_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Tota ngan ado toaiua ga ila, Maron Deo ikado kemi tau ngan eaba toa Isip aea oa ga ele panua, ngansa Iosep imamado toman ngan gid. Maron ikado kemi ngan ele danga toa ngada oa lumaeai ga dadangai pade. ");
INSERT INTO bch_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tota eaba toa oa idol Iosep ta imariala ngan ele danga toa ngada oa. Ele naurata toa ngada oa idae Iosep ibageai, tota ilolo ede ga ede ngan danga eta mao. Imamado ngan annga aea eannga kekelen. Be Iosep ibebe kapei ga imata kemi. ");
INSERT INTO bch_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Idio ga muriai, Iosep aea maron iadaoa ingale ei ta ikeo pan bedane, “Nam gitarua taeno.” ");
INSERT INTO bch_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Be Iosep ilongo mao, ta ikoli ele posanga bedane, “Ag maron idol gau ta namariala ngan danga toa ngada ne ele lumaeai. Tota ilolo ede ga ede ngan danga eta toa gau bagegeai ne mao. ");
INSERT INTO bch_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Idol eaba eta pade ga imadid ga imuga ngan ele luma toa ne mao, gau kekelegau. Be idangadangan danga eta pagau mao, eao kekelego, ngansa eao iadaoa. Tota irangrang ngan nakado kadonga sat toa ne mao. Oangga nakado bedane, eine kadonga paeamao tau Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Be ado ga ado taine toa oa iparumrum Iosep ngan posanga, be ei ilongo ei mao, ga ieno toman ngan ei mao, ga irangrang ngan imamado taine toa oa imatai mao pade. ");
INSERT INTO bch_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Be ado ede, Iosep idudunga lumaeai ngan kadonga ele naurata, be eaba eta pade imamado mao. ");
INSERT INTO bch_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Tota taine toa oa igigiran Iosep ele pononga mamarae ta ikeo, “Nam gitarua taeno!” Be Iosep ipiripiri ei ta itnan ele pononga mamarae ga idio ibageai, ta iaoa ga iuot ga ila. ");
INSERT INTO bch_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Be taine toa oa igera mambe ei itnan ele pononga mamarae ga idio ibageai ga iaoa, ");
INSERT INTO bch_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tota ibaba matua ga ila pagid paeaeanga arangaranga luma aea ta ikeo, “Agera! Adaoag ibada eaba Ibru aea toa ne ga inam pagita, be iuangga gai taine danga buligaliga! Ei idudunga ga inam pagau ta ikeo ga gairua aeno, be gau nangangar kapei. ");
INSERT INTO bch_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Be ilongo gau nangangar ta itnan ele pononga mamarae ga idio pagau ta iaoa ga iuot ga ila.” ");
INSERT INTO bch_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tota taine toa oa ikikisi Iosep ele pononga mamarae ga irangrang ngan Iosep aea maron iluai mulian ga inam ele lumaeai. ");
INSERT INTO bch_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Inama iuot ga kus ta iadaoa ipalongo ei ngan kadonga toa oa bedane, “Paeaeanga Ibru aea toa eao bada ga inam leda lumaeai, ei inam pagau ta iuangga ikado kadonga arala ngan gau. ");
INSERT INTO bch_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Be gau nangangar kapei, ta itnan ele pononga mamarae ga idio pagau, be ei iaoa ga iuot ga ila.” ");
INSERT INTO bch_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Io, Iosep aea maron ilongo iadaoa ele ninipunga ngan Iosep ele kadonga toa bedaoa, ta ilolo bake tau. ");
INSERT INTO bch_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Ta idol ei ga idudunga ngan luma panasnga aea. Ngan luma panasnga aea toa oa, tidoldol gid panua tikakado paeamao ngan maron kapei Isip aea. Be ngan luma panasnga aea toa oa, ");
INSERT INTO bch_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Maron Deo imamado toman ngan Iosep, ta ilolo isat ngan ei. Ta ikado ga madidnga ngan luma panasnga aea ilolo marum ngan Iosep ");
INSERT INTO bch_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","ta idol ei ga imariala ngan gid panua toa ngada oa luma panasnga aea iloleai. Ta ikeo ga naurata toa ngada oa ngan luma panasnga aea idae Iosep ibageai. ");
INSERT INTO bch_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Madidnga ngan luma panasnga aea imata ila ngan danga eta toa Iosep ibageai oa mao, ngansa Maron imamado toman ngan ei ta ikado ga ele naurata toa ngada oa iuot kemikemi. ");
INSERT INTO bch_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Idio ga muriai ta maron kapei togid Isip ele paeaeanga rua tikado kadonga paeamao ad maron imatai. Paeaeanga ede ele naurata ngan parerenga maron kapei aea oain. Be paeaeanga ede pade ele naurata ngan nononga maron kapei aea bret. ");
INSERT INTO bch_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Tota maron kapei ilolo bake pagisirua ");
INSERT INTO bch_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","ta idol gid ga tidio madidnga paraunga aea ibageai, ta ei idol gid ga tidudunga ngan luma panasnga aea. Be luma panasnga aea toa oa eine Iosep pade imamado ngan. ");
INSERT INTO bch_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Madidnga ibada naurata pan Iosep ngan luanga gisirua. Tidio ngan luma panasnga aea mole tede ga kus, ");
INSERT INTO bch_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","ta bong ede maron kapei ele paeaeanga toa rua oa anunud toa luma panasnga aea iloleai oa. Be paeaeanga toa iparere maron kapei aea oain ianun ipu ede, be paeaeanga ede pade toa inonono maron kapei aea bret, ei ianun ipu ede pade. ");
INSERT INTO bch_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Be gaisala ngan ado sae, Iosep igera gisirua matad kemi mao, mambe lolod ede ga ede. ");
INSERT INTO bch_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Ta ibeta maron kapei ele paeaeanga rua toa gisingada timamado ngan luma panasnga aea oa bedane, “Ikamado ga matami imalai tau?” ");
INSERT INTO bch_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Ta gisirua tikeo, “Gai anunumai, be eaba eta nene ngan paolanga anunumai ipu pagai mao.” Ta Iosep ikeo, “Deo kekelen irangrang ngan ipasolan gita ngan anunuda ipu. Be irangrang ngan aninipu pagau ngan pade?” ");
INSERT INTO bch_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Tota eaba toa iboko ngan maron kapei aea oain ininipu pan Iosep bedane, “Ngan anunug nagera oaroaro oain ");
INSERT INTO bch_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ibogaboga tol ienono. Mole mao ilaun papau iuot, ta ipur iuot, ga kus ta nagera itautau iuot ta iblabla. ");
INSERT INTO bch_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Maron kapei aea loba ienono bagegeai ta nabada oain itautau toa oa ta nabib ga isul idudunga ngan maron kapei aea loba. Ga kus ta nabada loba ga ila pan maron kapei.” ");
INSERT INTO bch_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Ta Iosep ikeo, “Anunum ipu ga bedane: Gid oain ibogaboga tol, eine ado tol. ");
INSERT INTO bch_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Be oangga ado tol kus, eine maron kapei ga ilongean go ta tnan luma panasnga aea, ta idol go mulian ngan lem naurata ngan badanga oain ga ila pan, mambe mugaeai eao kakado. ");
INSERT INTO bch_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Be oangga eao la ta mado kemi, irangrang ngan matam nanan gau pade? Nakim eao lolom isat ngan gau ta keo pan maron kapei ta ilongean gau ta natnan luma panasnga aea toa ne. ");
INSERT INTO bch_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ngansa mugaeai namamado ngan tano togai Ibru, be panua tipaeaoa gau ga nanama nene. Be nene pade, leg idil eta paeamao mao. Tidol gau sapaean ga nadudunga ngan luma panasnga aea.” ");
INSERT INTO bch_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Io, eaba ede pade toa iboko ngan maron kapei aea bret, igera mambe Iosep ipaola iuae ianun ipu kemi, ta ikeo pan Iosep bedane, “Gau pade anunug, be mole mao nagera karei tol iuon ngan bret ienono gadae ngan laborag. ");
INSERT INTO bch_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ngan karei toa gadae oa, nagera bret kemikemi imata ede ga ede mambe maron kapei ikimkim. Be gid man tinam tianean bret toa laborageai oa.” ");
INSERT INTO bch_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Ta Iosep ikeo, “Anunum ipu ga bedane: Karei tol eine ado tol. ");
INSERT INTO bch_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Be oangga ado tol kus, eine maron kapei ga ibada go ga ot ta ikeo pagid panua ta tiket gagalim ga put, ta tipakantutu patim ga idae ngan abei. Ta gid man ga tinam tianean patim.” ");
INSERT INTO bch_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Io, ado tol ila ga kus ta maron kapei ikado eaneannga kapei ngan aea poponga, ta ibaba ele madidnga busa ga tinam. Tota maron kapei ilongean panua toa rua oa ta titnan luma panasnga aea, ta ipamadid gisirua toa ele madidnga matadeai. ");
INSERT INTO bch_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Ta idol eaba toa ibabada aea oain pan ta iluai mulian ngan ele naurata. ");
INSERT INTO bch_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Be eaba toa iboko ngan aea bret, maron kapei ikeo pagid ele panua ta tipakantutu ipat ga idae ngan abei. Danga toa ne iuot lalaede mambe Iosep ipaola anunud ipu pagisirua ngan. ");
INSERT INTO bch_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Be eaba toa ibabada oain pan maron kapei, imata nanan Iosep pade mao. Imata sapian ei. ");
INSERT INTO bch_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Rai rua ila ga kus ta maron kapei togid Isip ieno ga ianun. Ta ngan ianun, igera mambe ei imadmadid eau Nail isaleai. ");
INSERT INTO bch_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Be mole mao igera bulmakao lima ga rua titubtub ga matad kemikemi, titnan eau ga tidae. Ta tianean purup boloma eau isaleai. ");
INSERT INTO bch_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ga kus ta igera bulmakao lima ga rua pade, be gid tipegepege ga matad papaeamao. Gid titnan eau Nail ga tidae, ta tila timadid boloma ngan gid bulmakao toa padengada eau isaleai. ");
INSERT INTO bch_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Be gid bulmakao toa pegepege ga matad papaeamao oa tian gid bulmakao toa matad kemikemi oa ta tison gid ga kus. Maron kapei ianun toa bedaoa ga kus ta idae. ");
INSERT INTO bch_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Idio ta ieno pade ga ianun, be mole mao igera wit itautau lima ga rua kemikemi ga titub kapeipei. Gid tiparapara ga tidae ngan wit iboga kelede. ");
INSERT INTO bch_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ga kus ta igera wit itautau lima ga rua pade, be gid titub kapei mao, ngansa namule oanaoana inono gid ga timalai. ");
INSERT INTO bch_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Be gid wit itautau toa titub mao oa tian gid wit itautau toa titubtub ga matad kemikemi oa ta tison gid ga kus. Maron kapei ianun toa bedaoa ga kus ta idae. Ta iuatai mambe ei ianun. ");
INSERT INTO bch_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Be gaisala ngan ado sae maron kapei ilolo ede ga ede ta ibaba gid panua oatainga ad ga gid panua borou ad toa ngada oa ga tinam pan, ta ipalongo gid ngan ianun. Be eaba eta irangrang ngan ipaola ianun ipu pan mao. ");
INSERT INTO bch_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Be eaba toa iparere maron kapei aea oain ikeo bedane, “Labone, matag nanan leg kadonga sat ede. ");
INSERT INTO bch_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Mugaeai eao lolom bake pagai lem paeaeanga ta eao dol gau ga nadudunga ngan luma panasnga aea toman ngan lem paeaeanga toa inonono am bret. Gairua amado ngan luma panasnga aea pan madidnga paraunga aea ibageai. ");
INSERT INTO bch_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Be bong ede gairua anunumai. Be anunumai toa oa lalaede mao. Ei ianun ipu ede pade, gau anunug ipu ede pade. ");
INSERT INTO bch_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Be eaba iriau ede Ibru aea imamado toman ngan gai ngan luma panasnga aea. Ei paeaeanga ton madidnga paraunga aea. Gairua aninipu pan ngan anunumai, ta ipaola anunumai ipu kelede kelede pagai. ");
INSERT INTO bch_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ta danga toa ngada oa iuot lalaede mambe ipaola pagai ngan. Gau nabada mulian leg naurata. Be eaba ede pade tipakantutu ipat ga idae ngan abei.” ");
INSERT INTO bch_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Io, Maron kapei ilongo posanga toa ne ta isula ele paeaeanga ga tila ngan badanga Iosep ga inam pan. Ta manmanae tila ngan luma panasnga aea ta tibada Iosep ga iuot. Inin ei ga idol barikia pau ga kus ta tibada ei ga ila maron kapei imatai. ");
INSERT INTO bch_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Ta maron kapei ikeo pan Iosep bedane, “Gau anunug, be eaba eta irangrang ngan ipaola anunug ipu pagau mao. Be nalongo panua tiposaposa ngan eao ta tikeo ga oangga eao longo panua anunud, eao rangrang ngan paola anunud ipu pagid.” ");
INSERT INTO bch_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Ta Iosep ikoli ele posanga bedane, “Gau narangrang mao. Be Deo irangrang ngan ipaola tutui anunum ipu pago ta ipatarui lolom.” ");
INSERT INTO bch_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Ta maron kapei ikeo pan Iosep bedane, “Ngan anunug gau namadmadid eau Nail isaleai, ");
INSERT INTO bch_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","be mole mao nagera bulmakao lima ga rua titnan eau ga tidae. Gid titub kapeipei ga matad kemikemi, be tianean purup eau isaleai. ");
INSERT INTO bch_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Ga kus ta nagera bulmakao lima ga rua pade titnan eau ga tidae. Be tinid imogougou ga tipegepege, be matad papaeamao tau. Ngan tibur toa ngada ne Isip, nagera bulmakao eta paeamao toa bedaoa mao. ");
INSERT INTO bch_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Be gid bulmakao toa pegepege oa tian gid bulmakao toa titubtub oa ta tison gid ga kus. ");
INSERT INTO bch_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Io, tian ga kus, be imata mambe tian mao, ngansa gid tipegepege maitne, mambe mugaeai. Anunug toa bedaoa ga kus ta nadae. ");
INSERT INTO bch_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Be anunug pade ta mole mao nagera wit itautau lima ga rua tipara ga tidae ngan wit iboga kelede. Wit itautau toa oa kemikemi ga titub kapeipei. ");
INSERT INTO bch_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ga kus ta nagera wit itautau lima ga rua pade, be titub kapei mao ngansa namule oanaoana inono gid ga timalai. ");
INSERT INTO bch_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Be gid wit itautau toa gereirei oa tian gid wit itautau kemikemi ta tison gid ga kus. Gau napalongo gid panua borou ad ngan anunug toa ne, be eta ngan gid irangrang ngan ipaola anunug ipu pagau mao.” ");
INSERT INTO bch_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Ta Iosep ikeo pan maron kapei bedane, “Anunum toa rua ne ipu kelede. Deo iuangga ipasolan eao ngan danga ei iuangga ikado. ");
INSERT INTO bch_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Gid bulmakao kemikemi lima ga rua, ga gid wit itautau kemikemi lima ga rua, gid mambe rai lima ga rua. Anunum toa rua ne tiposa ngan danga kelede. ");
INSERT INTO bch_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Be gid bulmakao pegepege ga matad papaeamao lima ga rua toa tiuot muriai ga gid wit itautau gereirei lima ga rua toa namule oanaoana inono gid, gid mambe rai lima ga rua sapanga aea. ");
INSERT INTO bch_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Eine mambe nakeo pago ngan. Deo ipasolan eao ngan danga kapei toa iuangga ikado. ");
INSERT INTO bch_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ega, irangrang ngan rai lima ga rua, annga dadangai ga iuot kapei tau ngan tibur Isip. ");
INSERT INTO bch_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Be muriai ngan rai toa kemikemi oa, sapanga kapei ga iuot ga irangrang ngan rai lima ga rua pade. Ta panua ga matad sapian gid rai kemikemi, ngansa sapanga ga ipaeabu ngan ada tano. ");
INSERT INTO bch_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Panua ga matad nanan gid rai kemikemi pade mao, ngansa sapanga toa oa ga iuot paeamao tau. ");
INSERT INTO bch_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Anunum toa oa iuot parua bedaoa ngansa Deo irau ele posanga ngan ga kus, ta irangrang ngan ipul pade mao. Deo ga ikado patautene. ");
INSERT INTO bch_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Tota kemi ngan eao dol eaba eta toa ele oatainga kapei ga ilolo iuatai ta imadid ga mugamuga ngan tibur kapei Isip. ");
INSERT INTO bch_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ga pade, kemi ngan eao dol gid madidnga ta timugamuga ngan tibur kelede kelede Isip. Gid madidnga toa oa ga tibada annga itautau ngan gid rai lima ga rua toa kemikemi ne, ta tipota ga iuot suknga lima. Ta tisio suknga kelede ga iman takis ga ila pago. ");
INSERT INTO bch_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kemi ngan lem madidnga tipaluplup gid annga ta tigor ngan gid rai toa kemikemi ne. Ta tibokoboko eao bagemeai ta tidoldol gid annga ngan luma annga aea ngan gid tuanga kelede kelede. ");
INSERT INTO bch_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Tota oangga rai lima ga rua sapanga aea iuot, gid panua Isip ga tibabada annga toa gid madidnga tigor ga ienono. Toa bedaoa ta sapanga irangrang ngan ipamukuru gid panua ngan leda tibur toa ne mao.” ");
INSERT INTO bch_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Maron kapei togid Isip ga gid ele madidnga tilongo Iosep ele posanga ta lolod kelede ngan. ");
INSERT INTO bch_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Ta maron kapei ikeo pagid ele madidnga bedane, “Gid deo timamado toman ngan eaba toa ne. Toa bedane ta irangrang ngan taot ngan eaba eta pade ngan kadonga naurata toa ne mao.” ");
INSERT INTO bch_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Ga kus ta maron kapei ikeo pan Iosep bedane, “Deo ipasolan eao ngan gid danga toa ngada ne. Tota eaba eta pade ele oatainga kapei ga ilolo iuatai kemi mambe eao ne mao. ");
INSERT INTO bch_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Eao ga ot madidnga kapei ngan gau leg luma. Be leg panua toa ngada ne manta tilongolongo lingem. Gau maron kapei, ta gau kekelegau namamado gadae ngan eao.” ");
INSERT INTO bch_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ta maron kapei ikeo pan Iosep pade bedane, “Longo. Gau nadol eao ga ot madidnga kapei ngan tibur toa ngada ne Isip.” ");
INSERT INTO bch_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ga kus ta maron kapei ipasu ibage igonga aea pato ta idol ga idae Iosep ibage igongai. Pato toa oa, maron kapei aea namer ienono ngan. Ga kus ta idol pononga kemi ngan Iosep, ta idol nagemgem gol ede ga idae igagaleai. ");
INSERT INTO bch_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Ngan ado toaiua ga ila, Iosep idaedae ngan maron kapei ele karis ede pade ta inasnasi maron kapei. Ta gid paeaeanga tiladlado ga timuga ngan ei ta tikeo pagid panua bedane, “Akor aemi!” Ngan kadonga toa bedaoa, maron kapei idol Iosep ga iman madidnga kapei tau ngan tibur Isip. ");
INSERT INTO bch_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ta maron kapei ikeo pan Iosep bedane, “Gau maron kapei, nakeo bedane: Eaba eta Isip irangrang ngan ikado danga eta ngan ele kimnga mao. Manta ibeta eao bua.” ");
INSERT INTO bch_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ta maron kapei iuato Iosep ieda pau Sapenat-Panea. Be ibada taine ede ga iman Iosep iadaoa. Taine toa oa ieda Asenat. Ei gergeu taine ton Potipera, eaba tenainga aea ede ngan tuanga On. Tota Iosep ilalala alele ngan tibur Isip. ");
INSERT INTO bch_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Iosep aea rai sangaul tol, be maron kapei togid Isip idol ei ngan kadonga ele naurata. Ta Iosep itnan maron kapei ga idio ta ilalala ngan tibur toa ngada oa Isip. ");
INSERT INTO bch_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Ngan rai kemikemi lima ga rua, annga iuot kapei tau ngan tibur Isip. ");
INSERT INTO bch_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tota ngan gid rai toa kemikemi oa Iosep igorgor gid annga busa. Ei igor gid annga dadanga aea ngan tuanga toa ngada oa Isip ta idoldol ngan gid luma annga aea boloma ngan gid tuanga kelede kelede. ");
INSERT INTO bch_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Annga toa Iosep igor oa, iuot busa tau, mambe riringa lab aea. Tota Iosep ikaput ngan annga aea oadenga, ngansa iuot busa tau. ");
INSERT INTO bch_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Gid rai sapanga aea iuot maitne, be Iosep iadaoa Asenat ipopo Iosep ele gergeu arangaranga rua. (Asenat toa ei gergeu taine ton Potipera, eaba tenainga aea ngan tuanga On.) ");
INSERT INTO bch_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Ta Iosep ikeo, “Deo ilua gau ta matag sapian ag kadonga kulupu ga gid iaoa kelede togau.” Tota iuato ele gergeu lautabe ieda Manase. ");
INSERT INTO bch_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Ga kus ta Iosep ikeo, “Deo ikado ga napapot gergeu, ga leg naurata iuot kemikemi ngan tibur toa nabada ieieinga ngan ne.” Ta iuato ele gergeu atange ieda Epraim. ");
INSERT INTO bch_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Idio ta tibur Isip aea rai kemikemi lima ga rua kus. ");
INSERT INTO bch_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Ta rai lima ga rua sapanga aea iuot, lalaede mambe Iosep ikeo ngan. Sapanga toa oa ipakaranga gid alu toa ngada oa ad tano. Be ngan tibur Isip, annga ienono. ");
INSERT INTO bch_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Idio ta sapanga iuot ngan tibur Isip pade. Ta gid panua titang ga ila pan maron kapei ngan annga. Ta maron kapei ikeo pagid panua Isip toa ngada oa bedane, “Ala pan Iosep ta anasi saoa posanga ikeo pagimi ngan.” ");
INSERT INTO bch_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Idio ta sapanga iuot paeamao tau ngan tibur Isip, ta Iosep ipokaka gid luma annga aea, ta gid panua Isip tiuolol ad annga. ");
INSERT INTO bch_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Ta gid alu padengada tinam Isip ngan olnga ad annga pan Iosep, ngansa sapanga paeamao ipakaranga tibur toa ngada oa tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Be Iakop ilongo posanga ngan annga ienono Isip ta ikeo pagid ele gergeu arangaranga bedane, “Ikamado ga matami inonono pol ngan gimi ga amamado sapaean? ");
INSERT INTO bch_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ega, nalongo mambe annga ienono Isip. Tota gimi ala ta aol ada annga etangada. Toa bedaoa ta tamado kemi be tamate ngan pitoro mao.” ");
INSERT INTO bch_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tota Iosep itar kapeipei sangaul tidae ga tila Isip ngan olnga ad annga. ");
INSERT INTO bch_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Be Iakop isula Iosep itar kakau Benjamin ga ila toman ngan gid mao, ngansa imataud. Ngan kado ta danga eta ipaeabu ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tota Israel ele gergeu pade tila Isip ngan olnga ad annga toman ngan gid panua busa, ngansa sapanga toa oa iuot ngan tibur Kenan pade. ");
INSERT INTO bch_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Be Iosep ei madidnga kapei ngan tibur Isip, ta gid panua toa ngada oa tilagalaga pan ngan olnga ad annga. Tota Iosep itar kapeipei tinam tiuot pan, ta tikor aed ga tidol laborad ga isulug tanoeai boloma pan. ");
INSERT INTO bch_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Be Iosep igera itar kapeipei, ta manmanae iuatai ngan gid. Be iposaposa pagid mambe iuatai ngan gid mao. Ta iposa malmal pagid ta ikeo, “Gimi sida ami?” Ta tikeo, “Gai Kenan amai. Be gai akeo ga aol amai annga.” ");
INSERT INTO bch_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Iosep iuatai ngan itar kapeipei, be gid tiuatai ngan ei mao. ");
INSERT INTO bch_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tota Iosep imata nanan ianun ngan gid mugaeai, ngan tidol laborad ga isulug pan. Ta ikeo pagid bedane, “Gimi panua papaeamao, aoangga anama atalelean lemai tibur kapei ne. Gimi ailoilo gid tibur toa panua timariala ngan kemi mao.” ");
INSERT INTO bch_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Ta tikeo, “Maron, eine mao. Gai lem paeaeanga, anama ngan olnga annga. ");
INSERT INTO bch_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Gai toa ngada ne eaba kelede ele gergeu. Gai lem paeaeanga, posanga tautaunga amai. Gai atalelean lemi tibur kapei ne mao.” ");
INSERT INTO bch_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Be Iosep ikeo pagid, “Eine mao. Gid tibur togai, toa panua timariala ngan kemi mao, tota anama atalelean.” ");
INSERT INTO bch_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ta tikeo, “Maron, gai panua sangaul igegea rua ngan iaoa kelede. Gai gergeu ton eaba kelede imamado Kenan. Amai ketnga tud ta imamado pan tamamai, be amai kakau ede pade isusu ga ila o.” ");
INSERT INTO bch_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Be Iosep ikeo, “Eine mambe nakeo pagimi, gimi anama atalelean lemai tibur kapei! ");
INSERT INTO bch_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Gau ga natoba gimi ga bedane: Naposa tautaunga ngan maron kapei togid Isip ieda, manta ami ketnga tud inama nene. Oangga mao, irangrang ngan atnan tibur toa ne mao. ");
INSERT INTO bch_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Gimi asula eaba eta ngan gimi ta ila ibada ami ketnga tud ga inama. Be gimi padengada ga adio amado ngan luma panasnga aea ga irangrang ngan gai aoatai tutui ngan gimi: aposa tutui, mao apakaka. Be oangga gai aoatai mambe gimi apakaka, naposa tautaunga ngan maron kapei togid Isip ieda bedane: Gimi anama atalelean lemai tibur kapei, ta gimi ga abada panasnga ngan.” ");
INSERT INTO bch_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Tota Iosep idol gid ga tidudunga ngan luma panasnga aea, irangrang ngan ado tol. ");
INSERT INTO bch_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ngan ado tol aea Iosep ikeo pagid bedane, “Oangga akeo ga amado kemi, manta alongo ngan leg posanga ga oaine. Ngansa gau nalolon ngan Deo. ");
INSERT INTO bch_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Oangga gimi panua posanga tautaunga ami, atnan eaba eta ngan gimi ta idio ngan luma panasnga aea, be gimi padengada abada annga ga ila lemi tuangai pagid sobosobomi toa pitoreagid. ");
INSERT INTO bch_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Be manta abada ami ketnga tud ga inam pagau. Toa bedaoa ta naoatai mambe lemi posanga tautaunga, ta irangrang ngan napamate gimi mao.” Io, tota tilongo ngan ele posanga toa oa. ");
INSERT INTO bch_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Be tiposa pol ngan gid bedane, “Tautaunga, gita leda idil paeamao toa mugaeai takado ngan ada kakau, ta ngan ipu toaine danga kulupu toa ne iuot ngan gita. Matada nanan ei itangtang ga iansaban gita ngan luanga ei, be gita talongo ei mao. Tota labone kadonga paeamao toa ne iuot ngan gita.” ");
INSERT INTO bch_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ta Ruben ikeo, “Ngan ado toaiua, nakeo pagimi ngan akado kadonga sat ngan ada kakau toa oa mao, be gimi alongo gau mao. Ega, labone tabada panasnga paeamao ngan ele matenga.” ");
INSERT INTO bch_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Iosep itar kapeipei tiposaposa Ibru, be tiuatai mao mambe Iosep ilongolongo led posanga. Ngansa somisomi Iosep ikado posanga Isip ga ila pagid, be eaba ede pade ipul ele posanga ga ila ngan posanga Ibru. ");
INSERT INTO bch_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tota Iosep ipul imur pagid, ta itang. Itang ga kus ta iluai mulian ta iposa pade pagid. Ta ikeo pagid paeaeanga ngan tiluku Simeon, ta ngan gid matad tiaud ei. ");
INSERT INTO bch_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Idio ta Iosep ikeo pagid ele paeaeanga ta tinonoi wit ga idudunga ngan itar kapeipei led samare toman ngan ad tamad lalalanga aea. Be ikeo ga tidol mulian gid kelede kelede led pat ga idudunga ngan led samare pade. Ele paeaeanga tikado toa bedaoa ga kus ");
INSERT INTO bch_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ta itar kapeipei tidol led tulua ga idae donki ipaoeai ta tila. ");
INSERT INTO bch_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tilalala ga edap irabuiai ta tidio tirau saupu ngan enonga bong toaiua. Be eaba ede ngan gid iuangga ipan ele donki aea annga ta ipokaka ele samare iaoa. Be mole mao igera ele pat ienono samare iloleai. ");
INSERT INTO bch_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Ta ikeo pagid aea kapeipei ga aea kakakau bedane, “Ega, tipalua leg pat! Ta ienono samare iloleai!” Io, tilongo bedaoa ta tikakrik be timataud kapei tau. Ta tikeo pol ngan gid bedane, “Deo ikado mado ngan gita?” ");
INSERT INTO bch_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Be tila tiuot pan tamad Iakop ngan tibur Kenan ga kus ta tipalongo ei ngan danga toa ngada oa iuot pagid. Ta tikeo, ");
INSERT INTO bch_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Madidnga kapei toa imugamuga ngan tibur toa oa, iposa malmal pagai ta isol gai ngan posanga mambe gai atalelean ele tibur kapei. ");
INSERT INTO bch_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Be gai akoli ele posanga bedane, ‘Gai panua posanga tautaunga amai. Gai atalelean lem tibur kapei toa ne mao. ");
INSERT INTO bch_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Gai panua sangaul igegea rua ngan iaoa kelede. Gai eaba kelede ele gergeu. Amai kakau ede isusu, be ketnga tud ta imamado pan tamamai ngan tibur Kenan.’ ");
INSERT INTO bch_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Ga kus ta madidnga kapei ikeo pagai pade bedane, ‘Gau ga natoba gimi ga bedane ta naoatai, lemi posanga tautaunga, mao pakakanga. Manta atnan eaba eta ngan gimi ta idio pagau. Be gimi padengada abada annga ga ila pagid sobosobomi toa pitoreagid. ");
INSERT INTO bch_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Be manta abada ami ketnga tud ga inam pagau. Toa bedaoa ta naoatai lemi posanga tautaunga, be atalelean lemai tibur kapei ne mao. Akado bedaoa ga kus ta nalongean ami ede pade ga iluai mulian pagimi. Ga kus ta alalala alele ngan tibur isaoa gimi akim.’” ");
INSERT INTO bch_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Idio ta titok ad annga ga isulug lumaeai, be gid kelede kelede tigera led pat ienono led samare iloleai! Be tamad pade igera toa bedaoa ta gid toa ngada oa timataud kapei. ");
INSERT INTO bch_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ta tamad Iakop ikeo pagid bedane, “Gimi akado ga naman aimara. Mugaeai Iosep isusu, ga kus ta Simeon pade isusu. Ta labone aoangga abada Benjamin ga itnan gau pade? Gid kadonga kulupulupu toa ngada ne iuotot ngan gau!” ");
INSERT INTO bch_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Be Ruben ikeo pan itama bedane, “Oangga nabada Benjamin ga iluai mulian pago mao, eine eao ga rangrang ngan rau leg gergeu arangaranga toa rua ne ga timate. Longean gau ta namariala ngan ei, ta gau ga nabada ei ga iluai mulian pago.” ");
INSERT INTO bch_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Be Iakop ikeo, “Gau natug irangrang ngan ila toa eoa toman ngan gimi mao. Itar kapei imate, ta ei kekelen imamado. Gau eaba kapei tau, ta oangga danga eta ipaeabu ngan ei edapeai, eine gimi ga akado ga lolog iketi tau ta namate ga nala dengaeai.” ");
INSERT INTO bch_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Be sapanga toa oa iuraura maitne ngan tibur Kenan. ");
INSERT INTO bch_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Idio ta wit toa mugaeai Israel ele gergeu tiuol ngan tibur Isip, tianean ga kus. Tota tamad Israel ikeo pagid bedane, “Aluagimi ga ala ta aol ada annga etangada pade.” ");
INSERT INTO bch_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Be Iuda ikeo pan itama bedane, “Apa, gai akeo pago ngan eaba toa oa ele posanga na. Ei ikado posanga matua tau pagai bedane ta ikeo, ‘Oangga ami ketnga tud inama toman ngan gimi mao, eine irangrang ngan agera matag pade mao.’ ");
INSERT INTO bch_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tota oangga eao longo ngan Benjamin inam toman ngan gai, eine gai ga ala aol am annga. ");
INSERT INTO bch_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Be oangga eao longean ei ga inam toman ngan gai mao, gai ga ala mao. Ngansa eaba toa oa ikeo pagai bedane, ‘Oangga ami ketnga tud inama toman ngan gimi mao, eine irangrang ngan gimi agera matag pade mao.’” ");
INSERT INTO bch_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Ta Israel ikeo, “Ikamado ga akado paeamao ngan gau ta apalongo eaba toa oa ngan ami kakau ede pade imamado?” ");
INSERT INTO bch_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ta tikeo, “Eaba toa oa ibeta nanan gai ngan iaoa kelede togita ta ikeo, ‘Tamami imamado maitne? Be ami kakau eta pade imamado?’ Ta gai akolikoli ele betanga. Gai aoatai mao mambe ei ga ikeo ga abada amai ketnga tud ga ila pade.” ");
INSERT INTO bch_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Ta Iuda ikeo pan itama Israel bedane, “Longean natum toa na ga inam toman ngan gau ta gaingada ala toa patautene. Toa bedaoa ta gitaingada leda gergeu tamate ngan pitoro mao, be tadio kemi. ");
INSERT INTO bch_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Naposa tautaunga, gau ga matag ikikisi ei, ta irangrang ngan danga eta ipaeabu ngan ei mao. Oangga nabada ei ga iluai mulian pago mao, idil paeamao toa ne ga ienono ngan gau somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Be oangga eao kado aea gerei ngan gai mao, eine gai arangrang ngan ala ga aluagai mulian parua na.” ");
INSERT INTO bch_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Idio ta tamad Israel ikeo pagid bedane, “Oangga edap eta pade mao, akado ga bedane: Gimi abada danga kemikemi nene aea ga idudunga lemi samareai, ta iman tenainga ga ila pan eaba toa oa. Abada bude dibala aea, ga bon isul, ga danga padengada iuad kemikemi, ga abei mer itekea, ga abei itautau mambe angal ga salke. ");
INSERT INTO bch_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Be abada lemi pat ta apaluplup toman ngan pat mugaeai aea, ngansa manta akoli mulian pat toa tidol lemi samareai. Kado tibuobuo ta tipalua pat toa oa. ");
INSERT INTO bch_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Abada ami ketnga tud ta ala pan eaba toa oa patautene. ");
INSERT INTO bch_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Be kemi ngan Deo Matua Soke Tau ikado ga eaba toa oa ilolo isat ngan gimi, ta irangrang ngan ilongean Benjamin ga ami ede pade ta tiluagid mulian toman ngan gimi. Be oangga Deo ikeo ga naman aimara, eine ga naman aimara.” ");
INSERT INTO bch_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tota tibada gid tenainga toman ngan led pat toa tipaluplup oa, ga tibada Benjamin pade ga tila. Tila manmanae ngan tibur Isip ta tila timadid Iosep imatai. ");
INSERT INTO bch_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Iosep igera mambe gisingada Benjamin tinama, ta ikeo pan ele paeaeanga luma aea bedane, “Bada gid panua toa ne ga tila leg lumaeai. Totoi bulmakao eta ta kado amai annga, ngansa labone arobad, gau ga naean toman ngan gid.” ");
INSERT INTO bch_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Tota paeaeanga toa oa ila ikado mambe Iosep ikeo ngan, ta ibada gid ga tila Iosep ele lumaeai. ");
INSERT INTO bch_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Tidudunga lumaeai maitne, be timataud ta tiposa pol ngan gid bedane, “Kado matad nanan pat toa mugaeai tidol leda samareai. Ta ngan ipu toaine tibada gita ga tala ele lumaeai. Eine ga tiluku gita ta tiaud gita ga taman led paeaeanga sapaean. Ta tibada leda donki pade ga iman led.” ");
INSERT INTO bch_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tota tila pan Iosep ele paeaeanga toa boloma atama iaoai ta tikeo pan bedane, ");
INSERT INTO bch_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","“Irangrang ngan longo lemai posanga ge? Mugaeai gai anama nene ngan olnga amai annga. ");
INSERT INTO bch_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Gai aol ga kus ta alalala pade, be ngan tibur toa arau saupu ngan, agera mambe gai kelede kelede lemai pat annga aea ienono samare iloleai. Tota gai akoli pat toa ne ga iluai mulian. ");
INSERT INTO bch_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Be abada pat pau ngan olnga amai annga pade. Gai aoatai mao, sai idol pat toa oa ga idudunga lemai samareai?” ");
INSERT INTO bch_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Be paeaeanga toa oa ikeo, “Lolomi itarui. Amataud mao. Ami Deo toa, Deo ton tamami, ipan lemi pat ga idudunga samareai. Be pat toa aol ngan annga mugaeai, gau nabada o.” Paeaeanga iposa bedaoa ga kus ta ibada Simeon ga iuot ga ila pagid. ");
INSERT INTO bch_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Ga kus ta paeaeanga toa oa ibada gid ga tila tidudunga Iosep ele lumaeai, ta ibada eau ga inam ta tisigiri aed. Ta ipan led donki ad annga pade. ");
INSERT INTO bch_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Be tilongo mambe Iosep ga ian toman ngan gid ngan arobad, ta tibada led tenainga ga iuot. ");
INSERT INTO bch_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Iosep iluai mulian ga inam lumaeai ta tibada led tenainga ga ila pan, ta tikor aed boloma pan ta tidol laborad ga isulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Ta ibeta gid ngan led madonga, ta ibeta gid pade bedane, “Tamami eaba kapei toa akeokeo pagau ngan, ta imamado maitne?” ");
INSERT INTO bch_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ta tikeo, “Lem paeaeanga, tamamai, ta imamado kemi.” Be tilolon ngan ei ta tikor aed pan ta tidol laborad ga isulug tanoeai pan pade. ");
INSERT INTO bch_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Iosep imata ila ta igera Benjamin toa gisirua tnad kelede, ta ibeta gid, “Ami ketnga tud toa akeo pagau ngan, tota nene?” Ta Iosep ikeo pan Benjamin bedane, “Leg gergeu, Deo ele kadonga lolo marum aea idio pago.” ");
INSERT INTO bch_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Be igera itar kakau ta ilolo ila pan kapei tau, ta iuangga itang. Tota manmanae ila idudunga ngan ele luma aea bobo ede pade ta itang. ");
INSERT INTO bch_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Be imen imata ngan eau ga ipamatua ilolo ga kus ta iluai mulian ta ikeo pagid ele paeaeanga bedane, “Apota annga.” ");
INSERT INTO bch_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Io, Iosep idio imado ngan popou ede, be itar kapeipei timado ngan popou ede pade, be gid Isip timado ngan popou ede pade, ngansa gid Isip ga gid Ibru tirangrang ngan tiluplup ga tianean mao. Ngansa ngan gid Isip matad, eine paeamao. ");
INSERT INTO bch_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Be Iosep ikeo pagid ele paeaeanga motean ngan tidol itar kapeipei mulid madonga aea ga inasi ad poponga. Lautabe imuga ga ila irangrang ngan ad ketnga tud. Be Iosep itar kapeipei tigera bedaoa ta tikakrik ga matad inono pol ngan gid. ");
INSERT INTO bch_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Gid paeaeanga tibada annga Iosep ele popouiai ta tipota ga ila pagid itar kapeipei. Be Benjamin aea annga tipota kapei tau, irangrang ngan panua lima tian ngan. Tota tinid igelgel toman ngan Iosep ta tianean ga tiunun oain ga itara gid. ");
INSERT INTO bch_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Tian ga kus ta Iosep ikeo pan ele paeaeanga luma aea bedane, “Eao nonoi led samare ga iuon tau ngan annga. Be eao dol gid kelede kelede led pat ga idudunga mulian led samare iloleai. ");
INSERT INTO bch_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Ga kus ta dol ag loba silva ga idudunga ngan samare ton ad ketnga tud toman ngan ele pat annga aea.” Io, paeaeanga toa oa ila ikado mambe Iosep ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Gaisala rumaruma gid paeaeanga tisula Iosep itar kapeipei ga tila toman ngan led donki. ");
INSERT INTO bch_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ta titnan tuanga ga tilalala ga tila. Gid tila aluai mao, be Iosep ikeo pan ele paeaeanga luma aea bedane, “Manmanae, la nasi gid panua toa oa. Be oangga eao ot pagid, keo pagid bedane, ‘Gai akado kadonga kemi ngan gimi, be ikamado ga akoli paeamao pagai? ");
INSERT INTO bch_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Loba toa gimi abada, eine ag maron aea loba ununnga aea. Be ikakado borou ngan loba toa oa, ta ilualua ei ngan badanga oatainga ngan gid danga ienono mumulnga pade. Lemi kadonga toa ne paeamao tau.’” ");
INSERT INTO bch_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Io, Iosep ele paeaeanga ila inasi gid ga iuot pagid, ta ikado posanga toa bedaoa pagid. ");
INSERT INTO bch_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Be tikeo pan bedane, “Maron, eao kamado kado posanga toa bedane ngan gai? Gai lem paeaeanga arangrang ngan akado danga eta bedaoa mao. ");
INSERT INTO bch_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ega, eao oatai, gai atnan Kenan ga anama ta aoangga akoli mulian pat toa ienono lemai samare iloleai. Toa bedaoa ta gai ga alub am maron ele danga mambe silva ga gol madongan? ");
INSERT INTO bch_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Oangga eao ot ngan eaba eta ngan gai ilub am maron aea loba, ei ga imate, ta gai padengada ga aman am maron ele paeaeanga sapaean.” ");
INSERT INTO bch_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Ta paeaeanga toa oa ikeo, “Eine takado mambe gimi akeo. Be eaba sai ikikisi loba toa oa, ei kekelen ga iuot paeaeanga sapaean. Be gimi padengada lemi idil eta paeamao mao, tota aluagimi mulian.” ");
INSERT INTO bch_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Io, manmanae gid toa ngada oa tisoa led samare ga isulug tanoeai ta gid kelede kelede tipokaka. ");
INSERT INTO bch_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Ga kus ta paeaeanga isaresare gid kelede kelede led samare, be imuga ngan ad lautabe ga ila irangrang ngan ad ketnga tud. Be igera loba toa oa ienono ngan Benjamin ele samare. ");
INSERT INTO bch_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Be itar kapeipei tigera bedaoa ta lolod isat kapei tau ta titaka led pononga mulian. Ta tidol led samare ga idae mulian donki ipaoeai ta tiluagid mulian Iosep ele tuangai. ");
INSERT INTO bch_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Iuda toman ngan aea kapeipei ga aea kakakau tinam tiuot, be Iosep imamado lumaeai maitne. Tota manmanae tikor aed ga tidol laborad ga isulug tanoeai pan. ");
INSERT INTO bch_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Ta Iosep ikeo pagid, “Gimi akado saoa kadonga ngan gau? Ngan leg borou, gau narangrang ngan naoatai ngan gid danga ienono mumulnga, be gimi aoatai mao?” ");
INSERT INTO bch_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Ta Iuda ikoli ele posanga bedane, “Maron, gai arangrang ngan akado posanga eta pago mao. Gai ga apasolan mambe gai panua tututui madongan? Deo ikado ga lemai idil paeamao iuot masaeai. Tota labone, eaba toa ilub am loba ne, ei kekelen ga iuot lem paeaeanga sapaean mao. Ega, gai toa ngada ne ga aot lem paeaeanga sapaean.” ");
INSERT INTO bch_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Be Iosep ikeo, “Eine mao. Irangrang ngan gimi akado bedane mao. Eaba toa ilub ag loba ne, ei kekelen ga iuot leg paeaeanga sapaean. Be gimi padengada lolomi itarui ta aluagimi mulian pan tamami.” ");
INSERT INTO bch_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Be Iuda ila boloma pan Iosep ta ikeo, “Aiao, maron! Irangrang ngan eao longo leg posanga? Tautaunga, eao maron kapei tau mambe Isip ad maron kapei, be gau, lem paeaeanga, nakim eao malmal pagau padam be longo leg posanga. ");
INSERT INTO bch_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mugaeai eao beta gai, lem paeaeanga bedane, ‘Gimi tamami ga ami kakau eta ta timamado?’ ");
INSERT INTO bch_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Ta gai akoli lem posanga bedane, ‘Be. Tamamai ei eaba kapei tau ta imamado. Be inat ketnga tud ta imamado pade. Itna ipopo ei ngan tamamai ei eaba kapei tau. Itna toa oa ipopo gergeu rua mon. Ede imate, be ei kekelen imamado. Be itama ikim ei kapei tau.’ ");
INSERT INTO bch_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Ga kus ta eao keo pagai, lem paeaeanga bedane, ‘Abada ami ketnga tud toa oa ga inama nene ta nagera ei.’ ");
INSERT INTO bch_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Be gai akoli lem posanga bedane, ‘Gergeu toa ne irangrang ngan itnan itama mao. Oangga itnan ei, itama ga imate.’ ");
INSERT INTO bch_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Be eao keo pagai bedane, ‘Oangga ami ketnga tud inama toman ngan gimi mao, irangrang ngan agera gau pade mao.’ ");
INSERT INTO bch_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tota gai aluagai mulian pan tamamai ta apalongo ei ngan lem posanga toa ne. ");
INSERT INTO bch_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Idio ta tamamai ikeo pagai bedane, ‘Aluagimi mulian ta aol ada annga etangada pade.’ ");
INSERT INTO bch_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Be gai akeo, ‘Gai arangrang ngan ala mao. Oangga eao longean amai ketnga tud ga inama toman ngan gai, ta gai ala. Be oangga amai ketnga tud inama toman ngan gai mao, irangrang ngan agera eaba toa oa pade mao.’ ");
INSERT INTO bch_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Tota lem paeaeanga tamamai ikeo pagai bedane, ‘Gimi aoatai, adaoag ipopo gergeu rua mon. ");
INSERT INTO bch_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ede isusu ta nagera ei pade mao. Masilau saksak ede ipaeabu ngan ei ga imate. ");
INSERT INTO bch_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tota oangga gimi abada itar kakau pade ga itnan gau ga ila, be danga eta ipaeabu ngan ei edapeai, eine gimi ga akado ga lolog isat kapei tau ta namate ga nala dengaeai.’ ");
INSERT INTO bch_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","“Tota labone, oangga naluagau mulian pan tamag, be igera inat ketnga tud inama toman ngan gau mao, eine ga imate. Ngansa gisirua lolod ikim ngan gid kapei tau. Gai tamamai ei eaba kapei. Ta oangga gai aluagai mulian toman ngan eaba toa ne mao, eine ga akado ga tamamai ilolo isat kapei tau ga imate. ");
INSERT INTO bch_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ga pade, gau nakado posanga tautaunga pan tamag ngan matag ikikisi eaba toa ne. Ta nakeo pan bedane, ‘Oangga nabada ei ga iluai mulian pago mao, eine leg idil paeamao toa matameai ne ga ienono ngan gau somisomi ga ilalala ga ila.’ ");
INSERT INTO bch_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Tota labone nakim eao longean gau ta nabada eaba toa ne imul, ta naman lem paeaeanga sapaean. Be eao longean eaba toa ne ga iluai mulian pan itama toman ngan itar kapeipei. ");
INSERT INTO bch_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Be oangga eaba toa ne iluai mulian toman ngan gau mao, irangrang ngan nagera tamag pade mao. Tinig ngan nagera kadonga kulupu toa ne iuot ngan tamag mao.” ");
INSERT INTO bch_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Iosep itoba pamatuanga ilolo toa ele paeaeanga matadeai ga mao, ta iuangga itang. Be iposa matua pagid bedane, “Gimi toa ngada ne aot ga ala.” Tota ei kekelen imamado toman ngan itar kapeipei be ikeo pagid ngan ei sai. ");
INSERT INTO bch_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Be Iosep itang kapei tau, ta gid Isip tilongo. Ta gid panua toa maron kapei ele lumaeai tilongo ngan pade. ");
INSERT INTO bch_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ta Iosep ikeo pagid itar kapeipei bedane, “Gau Iosep. Tamag imamado maitne na?” Be itar kapeipei tirangrang ngan tikoli ele posanga mao, ngansa timataud kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ta Iosep ikeo pade bedane, “Anam boloma pagau.” Io, tila boloma pan ta ikeo, “Gau tadimi kakau Iosep. Mugaeai gimi adol gau ga nadae pagid Ismael bagedeai, ta gid Isip tiuol gau ga naman led paeaeanga sapaean. ");
INSERT INTO bch_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Be kado lolomi ngur ga ngur ngan gimi mulian ngan lemi kadonga paeamao toa akado ngan gau ne. Lolomi ede ga ede mao pade, ngansa Deo isula gau ta namuga ngan gimi, ngansa iuangga ilua gimingada panua busa ta irangrang ngan amate mao. ");
INSERT INTO bch_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Ngansa sapanga iuot ngan tibur toa ne, aea rai rua ila na. Be irangrang ngan rai lima pade, gid panua ga tirangrang ngan tibada annga dadangai mao. ");
INSERT INTO bch_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Be Deo isula gau ta namuga ngan gimi ga nanama nene, ngansa iuangga ilua gita panua toa pidaede ne ta irangrang ngan tamukuru tanoeai mao. Be ngan iura kapei tau iuangga ibada gita mulian. ");
INSERT INTO bch_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Eine gimi asula gau ga nanama nene mao, be Deo isula gau. Ei ikado ga naot mambe aluagau ton maron kapei Isip aea. Gau naot madidnga kapei ngan ele luma ga tibur toa ngada ne Isip. Ta ilongolongo leg posanga mambe gergeu ilongolongo itama ele posanga. ");
INSERT INTO bch_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tota aluagimi manmanae ga ala pan tamag, ta akeo pan bedane, ‘Natum Iosep ikeo bedane: Deo ikado ga naot madidnga kapei ngan tibur Isip. Tota eao manta nam pagau manmanae. ");
INSERT INTO bch_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Eao ga mado boloma pagau ngan tibur ede ieda Gosen. Eao nama toman ngan lem gergeu ga tibutibum ga lem sipsip ga bulmakao ga lem danga sisid toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Gau ga namariala ngan eao toa nene, ngansa sapanga toa ne aea rai lima maitne. Ngan kado ta pitoro ipaeabu ngan eao ga lem panua toa ngada na.’ ");
INSERT INTO bch_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Ega, agera kemi matag ta aoatai, gau eaba eta pade mao, gau ami kakau Iosep. Be tadig kakau Benjamin pade iuatai ngan gau. ");
INSERT INTO bch_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Apalongo tamag ngan gau edag iuot kapei tau ngan tibur Isip, ta apalongo ei ngan danga toa ngada ne gimi agera. Ga kus ta abada ei manmanae ga inama nene.” ");
INSERT INTO bch_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Iosep iposa bedaoa ga kus ta iluku itar kakau Benjamin ta idol ilabora ga idae ikepeai ga itang. Be Benjamin pade ikisi Iosep ga itang. ");
INSERT INTO bch_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ga kus ta Iosep ikisi itar kapeipei kelede kelede ga itang ngan gid ga ibusum papad. Idio ta itar kapeipei tiposaposa pan. ");
INSERT INTO bch_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Be maron kapei togid Isip ilongo posanga ngan Iosep itar kapeipei tinam tiuot pan, ta ei ga ele madidnga toa ngada oa tinid igelgel. ");
INSERT INTO bch_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Ta maron kapei ikeo pan Iosep bedane, “Keo pagid am kapeipei ta tidol led tulua ga idae led donki ipaoeai, ta tiluagid mulian Kenan. ");
INSERT INTO bch_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Manta tibada tamami ga led panua toa ngada oa ta tiluagid ga tinam pagau. Ta gau ga nalongean gid ta tila timado ngan tano ede kemi tau, ta irangrang ngan ad annga dadangai iuot busa. ");
INSERT INTO bch_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Be manta keo pagid pade bedane, ‘Gimi abada gid karis Isip aea toa ne ga iman tamami ga lemi gergeu ga adadaoami led lalalanga aea. Ta gimingada adae ngan ta aluagimi ga anama nene. ");
INSERT INTO bch_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Be lolomi ede ga ede ngan lemi danga sisid ngan tibur Kenan mao, ngansa danga sisid kemikemi toa ngada ne ngan tibur Isip ga iman lemi.’” ");
INSERT INTO bch_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Io, Israel ele gergeu arangaranga tikado toa bedaoa mambe maron kapei togid Isip ikeo ngan. Iosep ibada karis pagid ga ipan ad tamad lalalanga aea. ");
INSERT INTO bch_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Be ipan gid kelede kelede ad barikia papau, be ipan Benjamin ele pat silva buno tol ga ele barikia papau lima. ");
INSERT INTO bch_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ga kus ta Iosep ibada danga kemikemi busa Isip aea ngan luanga itama edapeai, ta idol ga idae donki arangaranga sangaul paodeai, ta ibada gid wit ga bret ga annga imata ede ga ede iman itama aea tamad lalalanga aea ta idol ga idae donki taine sangaul paodeai. ");
INSERT INTO bch_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Ga kus ta isula itar kapeipei ga tila, be ikeo pagid bedane, “Gimi aoami isokangai edapeai mao.” ");
INSERT INTO bch_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tota Iosep itar kapeipei titnan Isip ga tila tiuot pan tamad Iakop ngan tibur Kenan. ");
INSERT INTO bch_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ta tikeo pan bedane, “Iosep imate mao! Ei imamado Isip be iuot madidnga kapei ngan tibur toa oa!” Iakop ilongo bedaoa ta itograi, be iuangga tipakaka. ");
INSERT INTO bch_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Be tipalongo ei ngan danga toa ngada oa Iosep ikeo pagid ngan, ga igera gid karis toa Iosep isula ga inam ngan badanga ei, ta ilolo ikapok. ");
INSERT INTO bch_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Ta Israel ikeo, “Tautaunga. Natug Iosep ta imamado! Manmanae ga nala ta nagera ei mugaeai ngan leg matenga.” ");
INSERT INTO bch_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Idio ta Israel ipagorou ele danga sisid toa ngada oa, ta ei toman ngan ele panua toa ngada oa tinasi edap ngan langa Isip. Be tila tiuot ngan tibur Berseba, ta Israel irau gid masilau ta iman ele tenainga ga ila pan Deo ton itama Aisak. ");
INSERT INTO bch_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Be ngan bong toaiua, Israel igera Deo iuot pan ta ibaba ga ila pan bedane, “Iakop, Iakop!” Ta ikeo, “Gau ta eko.” ");
INSERT INTO bch_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ta ikeo, “Gau Deo, Deo ton tamam Aisak. Eao mataud ngan langa Isip mao. Ngansa gau ga nakado ga lem gergeu ga tibutibum tiuot alu kapei tau toa eoa. ");
INSERT INTO bch_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Gau ga nala Isip toman ngan eao, be gau ga nabada go ga luago mulian pade. Be oangga eao mate, Iosep ga ipatutui lem enonga ta itaian go.” ");
INSERT INTO bch_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Idio ta Iakop ikakai ngan lalalanga, be ele gergeu arangaranga tidol ei ga led gergeu ga adadaoad ta tidae ngan gid karis toa maron kapei togid Isip iabalan ga ila ngan badanga gid, ta titnan tibur Berseba ga tila. ");
INSERT INTO bch_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ta Iakop toman ngan ele panua toa ngada oa tila Isip. Be tibada led masilau mud ga danga sisid toa ngada oa ngan tibur Kenan ta tila. ");
INSERT INTO bch_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Iakop ele gergeu ga itubtub arangaranga ga taine toa ngada oa tila Isip toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israel, toa ieda ede pade Iakop, ele gergeu ga itubtub toa tila Isip toman ngan ei, edad ga bedane: Inat lautabe ieda Ruben. ");
INSERT INTO bch_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Be Ruben ele gergeu arangaranga edad ga bedane: Anok ga Palu ga Esron ga Karmi. ");
INSERT INTO bch_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Be Simeon ele gergeu arangaranga edad ga bedane: Iemuel ga Iamin ga Oat ga Iakin ga Soar ga Saul. Be Saul itna ei taine Kenan aea. ");
INSERT INTO bch_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Be Livai ele gergeu arangaranga edad ga bedane: Gerson ga Koat ga Merari. ");
INSERT INTO bch_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Be Iuda ele gergeu arangaranga edad ga bedane: Er ga Onan ga Sela ga Peres ga Sera. Be Er ga Onan gisirua timate ngan tibur Kenan. Be Peres ele gergeu arangaranga edad ga bedane: Esron ga Amul. ");
INSERT INTO bch_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Be Isakar ele gergeu arangaranga edad ga bedane: Tola ga Pua ga Iop ga Simron. ");
INSERT INTO bch_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Be Sebulun ele gergeu arangaranga edad ga bedane: Seret ga Elon ga Ialel. ");
INSERT INTO bch_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Be Ruben ga Simeon ga Livai ga Iuda ga Isakar ga Sebulun, eine gid gergeu arangaranga toa Iakop iadaoa Lea ipopo ngan tibur Padan-Aram. Be Lea ipopo gergeu taine ede ieda Daina. Be Lea ele gergeu ga itubtub arangaranga ga taine toa ngada oa dabad iuot sangaul tol igegea tol. ");
INSERT INTO bch_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Be Gat ele gergeu arangaranga edad ga bedane: Sipion ga Agi ga Suni ga Esbon ga Eri ga Arodi ga Areli. ");
INSERT INTO bch_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Be Aser ele gergeu arangaranga edad ga bedane: Imna ga Isva ga Isvi ga Beria. Be liud ieda Sera. Be Beria ele gergeu arangaranga edad ga bedane: Eber ga Malkiel. ");
INSERT INTO bch_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Gid panua iaoa toaine, eine Iakop iadaoa Silpa ele gergeu ga itubtub. Be Silpa ei taine paeaeanga toa Laban ilongean ga ila pan inat taine Lea. Gid panua iaoa toaine dabad iuot sangaul ede igegea lima ga ede. ");
INSERT INTO bch_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Be Iakop iadaoa Resel ele gergeu arangaranga edad ga bedane: Iosep ga Benjamin. ");
INSERT INTO bch_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Be Iosep imamado Isip ta iuai taine ede ieda Asenat. (Asenat ei gergeu taine ton Potipera, eaba tenainga aea ngan tuanga On.) Asenat ipopo gergeu arangaranga rua, Manase ga Epraim. ");
INSERT INTO bch_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Be Benjamin ele gergeu arangaranga edad ga bedane: Bela ga Beker ga Asbel ga Gera ga Naman ga Ei ga Ros ga Mupim ga Upim ga Art. ");
INSERT INTO bch_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Gid panua iaoa toaine, eine Iakop iadaoa Resel ele gergeu ga itubtub. Dabad iuot sangaul ede igegea pange. ");
INSERT INTO bch_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Be Dan ele gergeu aranga ieda Usim. ");
INSERT INTO bch_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Be Naptali ele gergeu arangaranga edad ga bedane: Iasel ga Guni ga Ieser ga Silem. ");
INSERT INTO bch_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Gid panua iaoa toaine, eine Iakop iadaoa Bila ele gergeu ga itubtub. Be Bila ei taine paeaeanga toa Laban ilongean ga ila pan inat taine Resel. Gid panua iaoa toaine dabad iuot lima ga rua. ");
INSERT INTO bch_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Gid iaoa kelede pan Iakop toa tila Isip toman ngan ei, dabad iuot sangalima sangaul ede igegea lima ga ede. Be dabad toa ne ipaluplup Iakop ele gergeu adadaoad mao. ");
INSERT INTO bch_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Be Iosep iadaoa ipopo gergeu rua ngan tibur Isip. Tota gid iaoa kelede toa ngada oa pan Iakop tila Isip toman ngan ei, dabad iuot sangalima sangaul rua. ");
INSERT INTO bch_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Idio ta Iakop isula Iuda ta imuga ga ila pan Iosep ngan badanga ei ga ila ipasolan gid ngan tibur Gosen aea edap. Tota Iakop masin tiuot ngan tibur Gosen, ");
INSERT INTO bch_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","be Iosep ilongo bedaoa ta ikeo pagid ele paeaeanga ta tibada ele karis ga iuot edapeai. Ta Iosep idae ngan ta ila Gosen ngan geranga itama Israel. Io, Iosep igera itama ta ila iluku ei ga itang mole tede. ");
INSERT INTO bch_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Ga kus ta Israel ikeo pan Iosep bedane, “Labone, oangga namate, tinig igelgel ngan langa dengaeai, ngansa nagera go ngan matag ta naoatai, eao mamado maitne.” ");
INSERT INTO bch_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Ta Iosep ikeo pagid itar kapeipei ga gid iaoa kelede toa ngada oa ton itama bedane, “Gau ga nala napalongo maron kapei Isip aea ta nakeo pan bedane, ‘Ag kapeipei ga gid luma lolo ton tamag titnan tibur Kenan ga tinam tiuot pagau. ");
INSERT INTO bch_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Timariala ngan sipsip ga masilau mud iman led naurata pat aea. Gid tinama toman ngan led sipsip ga bulmakao ga danga sisid toa ngada oa.’ ");
INSERT INTO bch_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Gau ga nakado posanga toa bedaoa pan maron kapei, ta oangga maron kapei ibaba gimi ga anam pan ta ibeta gimi ngan saoa naurata gimi akakado, ");
INSERT INTO bch_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ta gimi ga akoli ele posanga bedane, ‘Maron, gai lem paeaeanga amariala ngan sipsip ga bulmakao. Mugaeai gai gereirei maitne ga irangrang ngan labone, gai akakado naurata toa ne, mambe tibutibumai tikakado mugaeai.’ Manta akado posanga toa bedaoa pan maron kapei, ta ei ga ilongean gimi ta ala amado ngan tibur Gosen. Ngansa gid Isip tikeo ga naurata ngan timariala ngan sipsip eine naurata paeamao.” ");
INSERT INTO bch_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Be Iosep ila pan maron kapei Isip aea ta ikeo, “Gau tamag ga tadig kapeipei titnan Kenan ga tinam tiuot nene toman ngan led sipsip ga bulmakao ga danga sisid toa ngada oa. Ega, patautene tirau led saupu ngan tibur Gosen.” ");
INSERT INTO bch_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Be Iosep isio aea kapeipei lima ta tila timadid maron kapei imatai. ");
INSERT INTO bch_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Ta maron kapei ibeta gid bedane, “Gimi akado saoa naurata?” Ta tikoli maron kapei ele posanga bedane, “Gai amariala ngan sipsip, mambe tibutibumai tikakado mugaeai. ");
INSERT INTO bch_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Be gai akeo ga amado kauteta nene, ngansa sapanga toa ne iuot paeamao tau ngan tibur Kenan. Be purup eta ngan lemai masilau tianean mao. Tota akeo ga eao longean gai lem paeaeanga ta ala amado ngan tibur Gosen.” ");
INSERT INTO bch_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Ta maron kapei Isip aea ikeo pan Iosep bedane, “Tamam ga am kapeipei tinam ta tikeo ga timado toman ngan eao. ");
INSERT INTO bch_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Eao manta sio tano eta kemi tau ngan tibur Isip ta keo pagid ta tila timado ngan. Kemi ngan tila timado Gosen. Be oangga eao oatai etangada ngan gid toa led oatainga kapei ngan timariala ngan bulmakao, ta dol gid ga timariala ngan gau leg bulmakao ipu.” ");
INSERT INTO bch_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Idio ta Iosep ibada itama Iakop ga ila igera maron kapei. Iakop ikado posanga kemi pan ga kus ta ");
INSERT INTO bch_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","maron kapei ibeta ei, “Eao am rai pida?” ");
INSERT INTO bch_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ta Iakop ikeo pan maron kapei bedane, “Gau namamado tanoeai irangrang ngan ag rai buno ede sangaul tol (130). Leg madonga ne mole tau mao. Be danga kulupulupu busa iuotot ngan gau. Gau tibutibug timamado mole tau tanoeai, be gid ad rai iasal gau ag rai.” ");
INSERT INTO bch_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Ga kus ta Iakop ikado posanga kemi pan maron kapei ta itnan ei ga ila. ");
INSERT INTO bch_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Toa bedaoa ta Iosep ilua itama ga itar kapeipei ta tila timado ngan tibur Isip. Ei ilongean tano pagid ngan tibur ieda Rameses, mambe maron kapei ikeo ngan. Tano toa ne kemi tau ga iasal tibur padengada Isip. ");
INSERT INTO bch_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Be somisomi Iosep ibabada annga ga ila pan itama ga itar kapeipei toman ngan led gergeu, be ele potanga annga inasnasi dabad. ");
INSERT INTO bch_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Sapanga toa oa iuot paeamao tau, ta tibur toa ngada oa aea annga eta mao. Sapanga ipaeabu ngan tibur Kenan ga Isip pade. ");
INSERT INTO bch_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tota gid panua toa ngada oa Kenan ga Isip tiuolol annga pan Iosep ga irangrang ngan led pat kus. Ta Iosep ibada pat toa oa ta idol ga ila ngan maron kapei ele luma. ");
INSERT INTO bch_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Idio ta gid panua toa ngada oa Kenan ga Isip led pat kus, ta gid Isip tila pan Iosep ta tikeo, “Eao pan amai annga. Oangga mao, sapanga ga ipaeabu ngan gai, ta amate eao matameai. Manta lua gai, ngansa lemai pat toa ngada ne kus.” ");
INSERT INTO bch_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ta Iosep ikeo pagid bedane, “Oangga lemi pat kus, ta abada lemi masilau mud ga inam pagau, ta iman ami annga aea olnga.” ");
INSERT INTO bch_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tota tibada led os ga sipsip ga meme ga bulmakao ga donki ta ila pan Iosep ta iman ad annga aea olnga. Ta Iosep ilualua gid ngan annga toa bedaoa ga irangrang ngan rai toaiua kus. ");
INSERT INTO bch_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Be ngan rai ede pade, tila pan Iosep ta tikeo bedane, “Gai arangrang ngan amudan amai kadonga kulupu pago mao. Eao bada lemai pat ga masilau mud toa ngada oa ga iman lem. Lemai danga eta pade ngan badanga pago mao. Eine gai kekelegai ga amai tano. ");
INSERT INTO bch_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Eao longean gai ga amate ngan pitoro padam. Ngan kado ta amai tano iman danga buligaliga. Kemi ngan eao lualua gai ngan annga, ta gai ga aman maron kapei ele paeaeanga sapaean. Ta amai tano pade ga iman ele. Be eao manta bada gid annga ipuapua earumnga aea ga inam pagai. Ngan kado ta amate ta amai tano aea eaba eta imariala ngan mao.” ");
INSERT INTO bch_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Tota gid panua toa ngada oa Isip tilongean ad tano ga ila pan Iosep ta iuol ga iman maron kapei aea, ngansa sapanga toa oa paeamao tau. Ta tano toa ngada oa Isip iman maron kapei aea. ");
INSERT INTO bch_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Ta Iosep ikado ga gid panua Isip toa ngada oa tila timado ngan gid tuanga kapeipei Isip. ");
INSERT INTO bch_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Be Iosep iuol tano togid panua tenainga ad mao, ngansa maron kapei ibabada pat pagid ta iman ad annga aea olnga. Tota gid panua tenainga ad kekelegid tilongean ad tano ga ila pan maron kapei mao. ");
INSERT INTO bch_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Idio ta Iosep ikeo pagid panua bedane, “Ega, gau naol gimi ga ami tano pade, ta gimi aman paeaeanga sapaean ton maron kapei. Be gid annga ipuapua earumnga aea ta eko. Abada ga ila ta aearum dadangai. ");
INSERT INTO bch_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Be oangga annga dadangai imatua, manta apota ga iuot suknga lima. Ta suknga ede ga iman maron kapei ele. Be gimi lemi suknga pange ta iman gimingada lemi gergeu ami. Be manta adol ipuapua etangada ga iman earumnga aea.” ");
INSERT INTO bch_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Io, gid panua tikeo pan Iosep bedane, “Maron, gai tinimai igelgel ngan aman paeaeanga sapaean ton maron kapei, ngansa eao bada gai mulian ta amado kemi na. Gai akim lolom marum ngan gai.” ");
INSERT INTO bch_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tota ngan ado toaiua ga ila, Iosep idol apu kapei ede ngan tibur Isip ga bedane: Oangga gid Isip ad annga dadangai imatua, manta tipota ga iuot suknga lima. Be suknga ede ga iman maron kapei ele. Be labone pade, apu toa ne ienono maitne. Gid panua tenainga ad kekelegid ad tano iman maron kapei aea mao. ");
INSERT INTO bch_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Gid Israel timamado Isip ngan tibur Gosen, ta tibada tano ngan tibur toa eoa. Be tipopo gergeu ga tiuot busa ta led danga sisid pade iuot busa. ");
INSERT INTO bch_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Be Iakop imamado Isip irangrang ngan aea rai sangaul ede igegea lima ga rua. Aea rai toa ngada oa iuot buno ede sangaul pange igegea lima ga rua (147). ");
INSERT INTO bch_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ele matenga inam boloma, ta ibaba Iosep ga inam pan ta ikeo, “Oangga lolom marum ngan gau, nakim eao dol bagem ga idio buleg ibuloloeai, ta posa tautaunga pagau ngan eao ga lolom isat ngan gau ta kado kadonga tautaunga pagau ngan danga ga oaine: Irangrang ngan eao taian gau Isip mao. ");
INSERT INTO bch_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Be oangga namate ga nala naeno toman ngan tibutibug, eao manta bada patig ga itnan Isip, ta la taian gau ngan denga toa titaian tibutibug ngan.” Ta Iosep ikeo, “Gau ga nakado mambe eao keo.” ");
INSERT INTO bch_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Be Iakop ikeo pan pade bedane, “Eao manta posa tautaunga gadae ngan kadonga toaine.” Tota Iosep ikado posanga tautaunga gadae. Ga kus ta Israel idol ilabora ga isulug imuliai ta ilolon ngan Deo. ");
INSERT INTO bch_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Idio ga muriai gid panua tikeo pan Iosep bedane, “Ega, tamam idibal.” Tota Iosep ibada ele gergeu arangaranga rua, Epraim ga Manase, ta tila tigera itama. ");
INSERT INTO bch_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ta gid panua tikeo pan Iakop bedane, “Ega, natum Iosep ta inam pago.” Tota Israel ipamatua ei ga idae imado imuliai. ");
INSERT INTO bch_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Ta Iakop ikeo pan Iosep bedane, “Deo Matua Soke Tau iuot pagau ngan tuanga Lus ngan tibur Kenan. Ta ikado posanga kemi ngan pamatuanga gau ");
INSERT INTO bch_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","ta ikeo pagau bedane, ‘Ega, gau ga nakado ga lem gergeu ga tibutibum tiuot busa ta tiuot alu kapei tau. Be gau ga napan tano toa ne ga iman lem gergeu ga tibutibum ad somisomi ga ilalala ga ila.’ ");
INSERT INTO bch_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Mugaeai ngan nanam naot pago ngan tibur Isip, adaoam ipopo lem gergeu arangaranga rua nene. Gergeu toa rua ne ga tiuot mambe gau leg gergeu. Ta Epraim ga Manase ga tiuot gergeu tautaunga togau, mambe Ruben ga Simeon. ");
INSERT INTO bch_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Oangga lem gergeu etangada muriai ngan Epraim ga Manase, gid eao lem. Ta muriai oangga tipota tano pagid iaoa kelede kelede pagau, lem gergeu muriai ad ga tidio gadio ngan Epraim ga Manase edad. ");
INSERT INTO bch_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nakado posanga toa ne ngansa lolog isat ngan tnam Resel. Ngan ado toaiua tatnan Padan-Aram ga tala ngan tibur Kenan, ei imate edap irabuiai. Gita tapaboloma tuanga Eprata, ta nataian ei edap isaleai.” (Eprata eine Betleem ieda mugamuga.) ");
INSERT INTO bch_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Be Israel igera Iosep ele gergeu ta ibeta ei bedane, “Eine sapadua?” ");
INSERT INTO bch_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Ta Iosep ikeo, “Eine leg gergeu rua toa Deo ibada pagau ngan tibur Isip.” Ta Israel ikeo, “Bada gisirua ga tinam pagau ta nakado posanga kemi ngan pamatuanga gid.” ");
INSERT INTO bch_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Be Israel ei eaba kapei tau ta imata igeragera kemi mao. Tota Iosep ibada gisirua ga tila boloma pan itama, ta Israel ikisi gid ga ibusum papad. ");
INSERT INTO bch_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Ta Israel ikeo pan Iosep bedane, “Mugaeai naeadi mambe narangrang ngan geranga go pade mao. Be ega, Deo ilongean gau ta nagera eao ga lem gergeu pade.” ");
INSERT INTO bch_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Ta Iosep isoa gisirua Iakop ibuleai ga tisulug, ta ikor iae ga idol ilabora ga isulug tanoeai ta ilolon ngan itama. ");
INSERT INTO bch_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Be Iosep ibada Epraim ngan ibage oatai ga Manase ngan ibage angas ta tila timadid boloma pan Iakop toa imatai oa, ngansa Iosep ikim Manase imadid ngan Israel ibage oatai ga Epraim ngan ibage angas. ");
INSERT INTO bch_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tautaunga Epraim eine gergeu atange, be Israel ipalaurerean ibage ta idol ibage oatai ga idae ngan Epraim ilabora, be ibage angas idae ngan gergeu lautabe Manase ilabora. ");
INSERT INTO bch_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ta Iakop ikado posanga kemi ngan pamatuanga Iosep ta iraring pan Deo bedane, “Mugaeai eao Deo ton tibug Abraam ga tamag Aisak, ta gisirua tinasnasi eao. Be eao mariala kemi ngan gau toa ag popongai ga irangrang ngan labone, mambe eaba imariala kemi ngan ele sipsip. ");
INSERT INTO bch_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Eao otot pagau mambe Anggelo, ta somisomi eao bada gau mulian ngan danga papaeamao iuangga ipaeabu ngan gau. Be labone nabeta eao, kado kemi ngan gergeu toa rua ne pade. Ta eao kado led gergeu ga tibutibud tiuot busa tau tanoeai. Toa bedaoa ta gid panua ga matad nanan gau edag ga tibug Abraam ga tamag Aisak edad pade.” ");
INSERT INTO bch_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Be Iosep igera mambe itama idol ibage oatai ga idae ngan Epraim ilabora, ta iuangga itutui mao, tota ikisi itama ibage ta iuangga idol ga idae ngan Manase ilabora. ");
INSERT INTO bch_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Ta ikeo, “Apa, eine mao. Gergeu lautabe ta eko. Dol bagem oatai ga idae ngan ei ilabora.” ");
INSERT INTO bch_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Be Israel itin ngan mao ta ikeo, “Natug, gau naoatai. Tautaunga Manase pade ieda ga iuot kapei, ta ele gergeu ga itubtub ga tiuot busa, be itar kakau Epraim ga iasal ei, ta ele gergeu ga itubtub ga tiuot mambe alu busa tau.” ");
INSERT INTO bch_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tota ngan ado toaiua, Israel ikado posanga kemi ngan pamatuanga gisirua ta ikeo, “Labone ga muriai ga ila, oangga gid Israel tikado posanga kemi ngan pamatuanga pol ngan gid, eine ga tiuato lem gergeu toa rua ne edad ta tikeo bedane, ‘Deo ikado kemi tau ngan gimi, mambe mugaeai ikado kemi ngan Epraim ga Manase.’” Ngan kadonga toa bedaoa Israel idol Epraim ga ila imuga ngan Manase. ");
INSERT INTO bch_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ga kus ta Israel ikeo pan Iosep bedane, “Ega, gau teta pade namate. Be Deo ga imamado toman ngan gimi, ta ei ga ibada gimi ta aluagimi mulian ngan tano togid tibutibumi. ");
INSERT INTO bch_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Be eao madid gadae ngan am kapeipei ta mugamuga ngan gid. Tota napan tano toa aea bereo kemi ede ga iman am. Eine tano toa mugaeai naparau pagid Amor ngan didi ga pandenga ta nabada. Be labone napan ga iman am.” ");
INSERT INTO bch_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Idio ta Iakop ibaba ele gergeu arangaranga ga tinam pan ta ikeo pagid bedane, “Gimi anam boloma pagau, ta gau ga naposa ngan saoa danga ga iuot ngan gimi maitne muriai. ");
INSERT INTO bch_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Gimi gergeu togau Iakop, anam aluplup boloma pagau. Gau tamami Israel, alongo kemi leg posanga. ");
INSERT INTO bch_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Ruben, eao leg gergeu lautabe. Gau tinig gargar maitne be napopo eao, ta eao man kilala ngan gau urag. Eao edam ga uram kapei tau, ta madid ga mugamuga. ");
INSERT INTO bch_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Be eao parpar ngan nasinga lem kimnga mambe eau imasesel. Tota eao rangrang ngan madid ga muga pade mao, ngansa eao eno toman ngan adaoag, ta pamaeamaea gau kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simeon ga itar kakau Livai led kadonga lalaede, tibabada led didi paraunga aea ta tipaeabu ngan panua padengada. ");
INSERT INTO bch_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Irangrang ngan lolog kelede ngan gisirua led posanga mao. Gau eaba ede toa panua tilolon ngan, ta irangrang ngan nalongo ngan saoa posanga gisirua tirau oa mao. Ngansa ngan led malmalnga tipamate panua. Be tinasi led tingelgel ta tiket bulmakao aed ilislisia. ");
INSERT INTO bch_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Led malmalnga eine danga paeamao tau. Tiuatai ngan kadonga lolo isat aea mao ga mao. Gau ga napatabilin gid ta timado alele ngan gid lum padengada Israel. ");
INSERT INTO bch_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Iuda, am kapeipei ga am kakakau ga tisoasoa edam. Eao ga gigiran am miri itamatama gagalid. Be tamam ele gergeu padengada ga tikor aed ga tilolon ngan eao. ");
INSERT INTO bch_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Iuda, eao mambe laion daenga pau ede, ta eao raurau am masilau ta eanean, ga kus ta dae ga la. Iuda ei mambe laion ede imata inono masilau, ta tem ga tem ngan aea raunga. Eaba eta irangrang ngan ikado ele pespes ta ipamasmasi ilolo mao. ");
INSERT INTO bch_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Iuda ga ikikisi toto togid mamaron kapeipei somisomi. Ele gergeu muriai ga timadid ga timugamuga. Ieda kapei ga ienono toa bedaoa ga irangrang ngan eaba tutui ede ibada imul muriai. Gid alu toa ngada ne tanoeai ga tilongolongo eaba toa oa ilinge. ");
INSERT INTO bch_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Iuda ele oain itautau kemikemi ga iuot busa tau, ta ei ga ikaukau ele donki aea oaro ngan ibogaboga, ta ilongean ele donki daenga pau ianean itautau toa oa pade. Be ei ga imum ele danga sisid ngan ele oain isul pade. ");
INSERT INTO bch_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iuda imata kadlo rua ila singsingia, ngansa iunun oain kapei. Be iluo bodbode tau, ngansa iunun bulmakao itud isul somisomi. ");
INSERT INTO bch_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Sebulun ga imamado lab matai. Ele lab aea igal kemikemi ngan gid oaga tidudunga. But ngan aea tano ga idio boloma ngan tuanga Saidon. ");
INSERT INTO bch_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Isakar ei mambe donki ede iura kapei. Be gid tulua ienono ipaoeai ipakulupu ei, ta idae imadid mao. ");
INSERT INTO bch_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ei ga igera ele tibur earainga aea kemi ga aea tano kemi ngan madonga, ta iura pakpakia ngan kadonga naurata. Be muriai ei ga iuot paeaeanga sapaean ta ikado naurata kulupulupu. ");
INSERT INTO bch_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Dan ga iuot eaba patutuinga posanga aea ngan ele panua. Ta ei ieda kapei mambe gid lum padengada Israel. ");
INSERT INTO bch_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dan imamado edap isaleai mambe mota aipel. Oangga gid panua paraunga ad tiladlado ngan os ga tinam, ei ga idug ta ingot aed igub, ta os toman ngan itama ga titap pan murid ga tisulug. ");
INSERT INTO bch_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Maron, nasangasanga eao ngan badanga gau mulian. ");
INSERT INTO bch_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gid panua lublubnga ad ga tinam tiparau pan Gat, be ei ga ikoli paraunga pagid, ta inasnasi aed mul ta ilado tatan gid. ");
INSERT INTO bch_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Tano ton Aser imona kapei. Ei ga inonono gid annga kemikemi toa gid mamaron kapeipei tikimkim. ");
INSERT INTO bch_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Naptali ei mambe meme saksak ede, inasnasi ele kimnga mulian ta ilalala alele. Ei ipopo gid gergeu kemikemi. ");
INSERT INTO bch_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Iosep ei mambe oaroaro oain ede tiarum boloma ngan eaumata, ta itautau iuot busa. Ibogaboga iuot mamarae ta ilugaluga dadanga aea ala. ");
INSERT INTO bch_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Gid panua toa tipaparau ngan pandenga tiuangga tirau ei ta tikado paraunga matua pan. ");
INSERT INTO bch_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Be ei ikikisi matua ele pandenga, ga ibage isamimi mao. Ngansa Iakop aea Deo toa iura kapei tau idol ibage ga idae ngan ei ngan pamatuanga ei. Deo toa ne somisomi imariala ngan gid Israel, be ei mambe led pat matua. ");
INSERT INTO bch_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Iosep, tamam aea Deo, ei eao am luanga. Deo Matua Soke Tau ga ikado kemi ngan eao ta ibabada danga kemikemi ga ila pago. Ele pamatuanga ngan eao ga itaptap mariambai ga isulug ga iuotot tanoeai ga idae pade. Lem taine ga masilau mud ga tipopo kemi ga tipadudud led gergeu. ");
INSERT INTO bch_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Gau tamam, naposa kemi ngan pamatuanga go, be gid danga kemikemi toa nakeo ga eao bada, eine ga iuot kapei tau ga iasal gid lusi kapeipei laborad. Gid danga toa kemikemi ne ga iasal gid danga kemikemi toa tibutibum tibabada mugaeai. Gid danga kemikemi toa ngada ne ga iuot ngan eao Iosep, ngansa eao edam kapei ga easal am kapeipei. ");
INSERT INTO bch_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Benjamin ei mambe kaua saksak ede. Gaisala ila ngan raunga gid masilau tibur aea, be lailai ipotapota gid danga toa ibabada.” ");
INSERT INTO bch_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Eiua gid lum sangaul igegea rua togid Israel. Ngan ado toaiua tamad iuangga imate, ei ikado posanga kemikemi toa bedaoa ngan pamatuanga gid. Ta gid kelede kelede ad pamatuanga itutui ngan gid. ");
INSERT INTO bch_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Iakop ikado posanga toa bedaoa ga kus, ta irenren pagid ele gergeu arangaranga bedane, “Teta pade gau ga namate ta nala ngan tibur togid leg panua matemate. Be gimi manta ataian gau toman ngan tibutibug ga tamatamag ngan pat kapei aea baba, ngan tano ton Epron, eaba It aea. ");
INSERT INTO bch_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Baba toa oa ienono ngan tibur Makpela boloma ngan tuanga ton Mamre ngan tibur kapei Kenan. Mugaeai Abraam iuol tano toa oa toman ngan pat kapei aea baba pan Epron, eaba It aea, ta iman Abraam aea ngan taiannga ele panua matemate. ");
INSERT INTO bch_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ngan denga toa oa, titaian Abraam ga iadaoa Sara, ga Aisak ga iadaoa Rebeka, be gau nataian Lea toa eoa pade. ");
INSERT INTO bch_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Tano toa oa toman ngan pat kapei aea baba, Abraam iuol pagid It.” ");
INSERT INTO bch_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Io, Iakop irenren pagid bedaoa ga kus ta isoa iae ga idae imuliai ta idada mosonga pakelede ga imate ta ila ieno toman ngan itubtub. ");
INSERT INTO bch_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Be Iosep igera itama imate, ta itap ga idae itama igogoeai ta itang ga ibusum ipapa. ");
INSERT INTO bch_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ga kus ta Iosep ikeo pagid panua keminga dibala ad, ta tisama danga iuad kemikemi ngan Israel ipat ta irangrang ngan ibuda mao. Tota gid panua keminga dibala ad tikado toa bedaoa ");
INSERT INTO bch_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ga irangrang ngan ado sangaul pange, lalaede mambe led nasinga ngan pasogonga gid matemate patid. Ta gid panua Isip titangtang ngan ei ga irangrang ngan ado sangalima sangaul rua. ");
INSERT INTO bch_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Be madonga lolo isat aea kus ta Iosep ila ikeo pagid madidnga ton maron kapei bedane, “Oangga lolomi marum ngan gau, nakim gimi akado leg posanga ila pan maron kapei ga bedane, ");
INSERT INTO bch_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Boloma ngan tamag imate, iposa matua pagau ta nakado posanga tautaunga pan ngan badanga ipat ga ila nataian ngan denga toa ei ikemi motean ngan tibur Kenan. Tota nakeo ga eao longo gau ta nala nataian ei, ga kus ta naluagau mulian.’” ");
INSERT INTO bch_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Ta maron kapei ikeo, “Eao manta nasi lem posanga tautaunga pan tamam ta bada ipat ga ila ta taian ei, mambe ikeo pago ngan.” ");
INSERT INTO bch_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tota Iosep ila ngan taiannga itama. Be gid madidnga ga paeaeanga ton maron kapei ga gid panua kapeipei Isip ad busa tila toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Be gid iaoa kelede ton Iosep gisingada adadaoad ga led gergeu tila toman ngan ei. Be gid gergeu gereirei kekelegid tidio ngan tibur Gosen toman ngan gid sipsip ga meme ga bulmakao. ");
INSERT INTO bch_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Be gid karis ga panua tidae ngan gid os pade tila toman ngan ei. Ta tiuot ipom kapei tau. ");
INSERT INTO bch_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tila tiuot ngan tibur Atat, toa ado ele parangai ngan eau Iordan. Tibur toa oa gid Atat tilelean wit aea sakirkir ngan. Be Iosep masin tila tiuot toa eoa ta titang kapei tau ngan Iakop. Be tidio toa eoa ta Iosep inasi kadonga lolo isat aea irangrang ngan ado lima ga rua. ");
INSERT INTO bch_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Ta gid Kenan ngan tibur toa oa tigera gid panua titang kapei tau toa eoa ta tikeo, “Gid Isip titang kapei tau ngan eaba imate.” Tota tibur toa boloma ngan eau Iordan oa, tiuato ieda Abel-Misraim. ");
INSERT INTO bch_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Tota Iakop ele gergeu arangaranga tikado mambe irenren pagid ngan. ");
INSERT INTO bch_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Tibada ipat ga ila Kenan, ta titaian ei ngan pat kapei aea baba ngan tibur Makpela boloma ngan tuanga ton Mamre. Mugaeai Abraam iuol tano toa oa toman ngan pat kapei aea baba pan Epron, eaba It aea, ta iman Abraam aea ngan taiannga ele panua matemate. ");
INSERT INTO bch_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Titaian Iakop ga kus ta Iosep toman ngan itar kapeipei ga panua toa ngada oa tila toman ngan gid, tiluagid mulian Isip. ");
INSERT INTO bch_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Be Iosep itar kapeipei tigera mambe tamad imate ta tikeo, “Labone gau madongan? Kado Iosep ilolo ngur ga ngur pagita maitne ta iuangga ikoli kadonga papaeamao toa takado ngan ei mugaeai.” ");
INSERT INTO bch_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Tota tiabalan posanga ga ila pan Iosep bedane, “Mugaeai ngan tamada imate, ei ikado posanga ede pagai. ");
INSERT INTO bch_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","Ikeo ga gai akado posanga pago ga bedane, ‘Iosep, nabeta matua eao, samum tadim kapeipei led kadonga sasat toa tikado ngan eao.’ Tamada ikeo toa bedaoa, tota gai, paeaeanga ton tamada aea Deo, abeta eao bedane: Irangrang ngan eao samum lemai kadonga sasat?” Io, Iosep ilongo toa bedaoa ta itangtang. ");
INSERT INTO bch_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Ga kus ta itar kapeipei tila tigera ei ta tidol laborad ga isulug tanoeai pan ta tikeo, “Ega, gai eao lem paeaeanga sapaean.” ");
INSERT INTO bch_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Be Iosep ikeo pagid, “Amataud mao. Gimi aoangga gau Deo? Eine mao. ");
INSERT INTO bch_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Gimi aoangga apaeabu ngan gau, be Deo ilongean kadonga toa ne ga iuot ta iman leda kemi aea, ngansa iuangga ilualua panua busa ta irangrang ngan tamate mao. Ta gimi agera danga kapei toa Deo ikado ga iuot ne. ");
INSERT INTO bch_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tota amataud mao. Gau ga napanpan gimingada lemi gergeu ami annga.” Ta Iosep ikado posanga meles pagid toa bedaoa ta ipamatua lolod. ");
INSERT INTO bch_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Idio ta Iosep imamado Isip toman ngan gid iaoa kelede pan itama. Imamado ga irangrang ngan aea rai buno ede sangaul ede (110). ");
INSERT INTO bch_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Ei igera ele sasa toa Epraim itubtub tipopo. Be gid gergeu ton Makir toa Manase inat, gid tidio timado Iosep ibuleai muriai ngan tnad ipopo gid. Ta tiuot mambe Iosep ele gergeu pade. ");
INSERT INTO bch_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Idio ga muriai ta Iosep ikeo pagid iaoa kelede ei ton bedane, “Gau teta pade namate. Be muriai Deo ga ilualua gimi ta ibada gimi ta atnan tibur toa ne ta ala ngan tano toa mugaeai iposa tautaunga pan Abraam ga Aisak ga Iakop ngan.” ");
INSERT INTO bch_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Ga kus ta Iosep ikeo, “Gimi manta akado posanga tautaunga gadae ngan kadonga ga oaine: Oangga Deo inama ngan luanga gimi, manta abada tuatuag ta atnan tibur toa ne ga ala.” ");
INSERT INTO bch_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Tota Iosep aea rai buno ede sangaul ede (110) ta imate. Ga kus ta tisama ipat ngan gid danga iuad kemikemi ta irangrang ngan ibuda mao. Ta tidol ipat ga idudunga ngan ribrib ede ngan tibur Isip. ");
INSERT INTO bch_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Gid gergeu arangaranga ton Iakop toa tila Isip toman ngan ei, gid kelede kelede tila toman ngan adadaoad ga led gergeu. Israel ele gergeu arangaranga edad ga bedane: ");
INSERT INTO bch_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben ga Simeon ga Livai ga Iuda ");
INSERT INTO bch_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ga Isakar ga Sebulun ga Benjamin ");
INSERT INTO bch_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ga Dan ga Naptali ga Gat ga Aser. ");
INSERT INTO bch_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ngan ado toaiua, gid iaoa kelede pan Iakop, dabad iuot sangalima sangaul rua. Be Iosep imamado motean toa Isip oa. ");
INSERT INTO bch_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Idio ta Iosep asingada itar kapeipei ga panua toa ngada oa ngan ado toaiua timamado led ga kus. Be muriai ngan led matenga, ");
INSERT INTO bch_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","gid Israel tipopo gergeu busa ta tiuot alu ede matua tau ta tipakaranga tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Idio ta maron kapei pau ede imadid ga imugamuga ngan tibur Isip. Be maron kapei toa oa iuatai ngan Iosep mao. ");
INSERT INTO bch_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ta ikeo pagid ele panua bedane, “Ega, gid Israel tiuot busa, be urad kapei iasal gita tau. ");
INSERT INTO bch_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Be oangga paraunga eta iuot, eine ga tilup toman ngan ada miri itamatama ta tikado paraunga pagita. Toa bedaoa ta titnan leda tibur ga tila. Be manta tanasi oatainga kemi ta tailo edap eta ngan pakalanga gid, ta irangrang ngan tiuot busa pade mao.” ");
INSERT INTO bch_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tota gid Isip tidol gid madidnga naurata ad ta tipaeaea gid Israel ta tikado kulupu tau ngan gid. Tiposa matua pagid Israel ta tikado tuanga kapeipei rua, Pitom ga Rameses, ngan gornga maron kapei ele annga ga danga padengada. ");
INSERT INTO bch_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Gid Isip urad ngan paeaeanga gid Israel, be gid Israel urad ta tiuotot busa pade. Tota gid Isip timataud gid Israel ");
INSERT INTO bch_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ta tikado gid ga tisonggaro ngan naurata, be lolod isat ngan gid mao. ");
INSERT INTO bch_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Gid Isip tikado ga gid Israel led madonga paeamao ngan naurata kulupulupu. Tidoldol naurata pagid ngan bulnga tano ga iuot matua ta tikado ngan gid luma, be tikakado naurata imata ede ga ede dadangai pade. Gid Isip lolod isat ngan gid Israel mao. Tipaeaea gid paeamao tau. ");
INSERT INTO bch_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Be maron kapei togid Isip ibaba taine rua Ibru ad, Sipra ga Pua, ta tinam pan. Gisirua led naurata ngan papoponga gid taine Ibru. ");
INSERT INTO bch_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Ta ikeo pagisirua bedane, “Somisomi oangga gimirua apapopo gid taine Ibru ad, ta agera mambe tipopo gergeu aranga, arau ei ga imate. Be oangga tipopo gergeu taine, atnan ei ga idio.” ");
INSERT INTO bch_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Be taine toa rua oa timataud Deo ta tinasi maron kapei togid Isip ele posanga mao. Titnan gid gergeu arangaranga ga tidio. ");
INSERT INTO bch_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Idio ta maron kapei ibaba taine toa rua oa ga tinam pan ta ibeta gid bedane, “Ikamado ga akado bedane? Atnan gid gergeu arangaranga ga tidio ngan saoa?” ");
INSERT INTO bch_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Ta taine toa rua oa tikoli maron kapei ele posanga bedane, “Gid taine Ibru ad eine mambe gid taine Isip ad mao. Gai aot maitne, be tipopo. Ngansa gid urad kapei.” ");
INSERT INTO bch_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Tota Deo ikado kemi ngan taine toa rua oa, ta ikado gisirua ga tipopo led gergeu pade, ngansa timataud Deo. Be gid Israel tipopo busa ga tiuot alu matua ede. ");
INSERT INTO bch_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Idio ta maron kapei iposa matua pagid panua Isip bedane, “Oangga gid taine Ibru ad tipopo gergeu arangaranga, atado gid ga tisulug ngan eau kapei Nail. Be oangga tipopo gergeu taine, atnan gid ga tidio.” ");
INSERT INTO bch_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Ngan ado toaiua, eaba ede ngan lum pan Livai iuai taine ede toa gisirua lum kelede. ");
INSERT INTO bch_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Idio ta iapa ta ipopo gergeu aranga ede. Be taine toa oa igera mambe ele gergeu imata kemi tau ta imudan ei irangrang ngan taiko tol. ");
INSERT INTO bch_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Be taiko tol kus ta irangrang ngan imudan gergeu pade mao. Tota ibada tia ede ta isama ngan naraelo ta idodon ngan tia ibaba. Ta idol gergeu ga idudunga tia iloleai ta imudan tia toa oa piso iloleai, ngan eau kapei Nail isal. ");
INSERT INTO bch_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Be gergeu toa oa iliu imadmadid aluai tede ngan geranga saoa danga ga iuot ngan ei. ");
INSERT INTO bch_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ngan ado toaiua, maron kapei inat taine ila ililiu eauiai, be ele taine paeaeanga tilalala eau isaleai. Be maron kapei inat taine igera tia toa oa imomono piso iloleai, ta isula ele taine paeaeanga ede ta ila ibada. ");
INSERT INTO bch_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Maron kapei inat taine ipokaka tia iaoa ta igera gergeu aranga toa oa itangtang. Be ilolo isat ngan ei ta ikeo, “Talo. Gergeu aranga ede ne togid Ibru.” ");
INSERT INTO bch_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Gergeu toa oa iliu ibeta maron kapei inat taine bedane, “Irangrang ngan nabada taine eta Ibru aea ga inam ta ipadud gergeu toa na?” ");
INSERT INTO bch_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Ta maron kapei inat taine ikoli ele posanga bedane, “Goibe, la.” Tota taine kakauede toa oa ila ibada gergeu itna. ");
INSERT INTO bch_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Idio ta itna inama iuot, ta maron kapei inat taine ikeo, “Nakim eao lua gau ta bada gergeu toa ne ta padudud ei ga geragera ei kemi. Ta gau ga naol go.” Tota gergeu itna toa oa ibada ei ta ipadudud ei. ");
INSERT INTO bch_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Be gergeu idae kapei tede, ta itna ibada ei ga ila pan maron kapei inat taine, ta iuot mambe ei ele gergeu. Ta iuato ieda Moses ngansa ikeo, “Gau nadada ei eauiai ga idae.” ");
INSERT INTO bch_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Idio ga muriai Moses idae kapei ta ila igera gid ele panua Ibru ad. Be igera mambe tikakado naurata kulupulupu ton maron kapei Isip aea. Igera eaba ede Isip aea itapa eaba ede Ibru aea paeamao. ");
INSERT INTO bch_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ta Moses imata kleng alele, be igera eaba eta pade mao, tota manmanae ila irau eaba Isip aea ga imate ta imudan ipat ngan tantano. ");
INSERT INTO bch_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Be ngan ado sae, iuot ga ila pade ta igera panua rua Ibru ad tipaparau. Idae ta ibeta eaba toa ikado paeamao ngan iuae ede pade ta ikeo, “Eao kamado tapa oaem Ibru aea toa ne?” ");
INSERT INTO bch_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Be eaba toa oa ikeo, “Sai idol go ga man amai madidnga patutuinga posanga aea? Eao oangga rau gau pade mambe rau eaba Isip aea made na?” Moses ilongo toa bedaoa ta imataud ta ikeo iloleai bedane, “Danga toa nakado ne, panua tiuatai ngan.” ");
INSERT INTO bch_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Be maron kapei togid Isip ilongo mambe Moses ikado danga toa ne, ta iloilo ei ngan pamatenga ei. Be Moses iaoa ngan maron kapei ta ila imado ngan tibur Midian, boloma ngan eau aea baba ede. ");
INSERT INTO bch_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Be eaba tenainga aea ede ngan tibur Midian toa ieda Ietro, ei ele gergeu taine lima ga rua timamado. Gid ele gergeu taine tila ngan eau aea baba toa oa ngan ednga eau ga idudunga ngan tamad ele sipsip ga meme ad golomada. ");
INSERT INTO bch_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Be gid arangaranga toa timariala ngan sipsip ipu ede pade, tisere gid taine toa oa. Be Moses idae ta isere gid arangaranga toa oa, ga kus ta ipaun sipsip ga meme togid taine. ");
INSERT INTO bch_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Idio ta gid taine tiluagid mulian pan tamad Ruel, ta ibeta gid bedane, “Ikamado ga labone aluagimi manmanae tau?” ");
INSERT INTO bch_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Ta tikeo, “Eaba ede Isip aea ilua gai ta gid arangaranga tirangrang ngan tisere gai mao. Be eaba toa oa ied eau pade ta ipaun leda sipsip ga meme.” ");
INSERT INTO bch_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ta tamad ibeta gid, “Eaba toa oa sida? Ikamado ga atnan ei ga idio toa eoa? Ala abada ei ga inam ta ian toman ngan gita.” ");
INSERT INTO bch_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Io, tamad ikeo ga Moses idio imado toman ngan ei, ta Moses ilongo. Ta tamad ipaoai Moses ngan inat taine ede ieda Sipora. ");
INSERT INTO bch_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Muriai Sipora ipopo Moses ele gergeu aranga ede, ta Moses iuato ieda Gersom, ngansa ikeo, “Gau eaba ngan tibur ede pade, be nanam namado ngan tano toa ne.” ");
INSERT INTO bch_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Idio ga rai edengada muriai ta maron kapei togid Isip imate. Be gid Israel tisolil ngan ad ieieinga ngan naurata kulupulupu, ta tingangar ngan tandanga. Be tiansaban Deo ngan luanga gid ngan led naurata kulupulupu. Ta led tandanga idae ga ila pan. ");
INSERT INTO bch_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Ta Deo ilongo led tandanga ta imata nanan ele posanga tautaunga toa mugaeai irau toman ngan Abraam ga Aisak ga Iakop. ");
INSERT INTO bch_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Tota Deo igera gid Israel led madonga paeamao toa bedaoa ta ilolo isat ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Ngan ado toaiua, Moses imariala ngan gid sipsip ga meme ton ilaoa Ietro, eaba tenainga aea ngan tibur Midian. Ta Moses ibada gid sipsip ga meme ta tiuore ga tila ngan tibur modamodanga isal iadag. Ta ila iuot ngan lusi Orep. Lusi toa oa ton Deo. ");
INSERT INTO bch_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Toa eoa anggelo ton Maron iuot pan mambe dinga irarabal ngan abei kakauede ibogaboga. Mole mao, Moses igera abei kakauede toa dinga irarabal ngan, be dinga inono abei toa oa ilaun ga ibogaboga eta mao. ");
INSERT INTO bch_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Ta ikeo, “Danga ne iuot madongan? Ikamado ga dinga inono abei toa oa mao? Gau ga nala boloma ta nagera.” ");
INSERT INTO bch_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Be Maron imamado rabu ngan abei toa oa, ta igera Moses inam boloma ngan geranga, ta ibaba ga ila pan bedane, “Moses, Moses!” Ta Moses ikeo, “Gau ta eko.” ");
INSERT INTO bch_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ta Deo ikeo, “Eao nam boloma mao. Til lem su ga idio. Ngansa tano toa eao madmadid ngan ne, eine leg ul ienono ngan. ");
INSERT INTO bch_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Gau Deo togid tibutibum Abraam ga Aisak ga Iakop.” Be Moses ilongo bedaoa ta ipamumul imata, ngansa imataud ngan geranga Deo. ");
INSERT INTO bch_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Ta Maron ikeo, “Gau nagera kadonga kulupulupu iuot ngan leg panua ngan tibur Isip na. Be nalongo led tandanga inam pagau ngan gid madidnga naurata ad tilasu paeaeanga gid tau. Ta gau lolog isat ngan ad ieieinga. ");
INSERT INTO bch_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Tota nasulug ga nanam ngan badanga gid mulian pagid Isip bagedeai. Be nakeo ga nabada gid ga titnan Isip ta tila timado ngan tano ede kemi, aea tibur oatalai, be imona kapei ta bon isul ga bulmakao itud isul iuotot ngan. Tibur toa oa labone gid alu ga gid ne timamado ngan: gid Kenan ga gid It ga gid Amor ga gid Peres ga gid Ivi ga gid Iebus. ");
INSERT INTO bch_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ega, nalongo gid Israel led tandanga na, be nagera gid Isip tikakado paeamao ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Tota gau ga nasula go ga la pan maron kapei togid Isip ngan badanga leg panua Israel ta titnan Isip ga tinam.” ");
INSERT INTO bch_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Be Moses ikeo pan Deo bedane, “Gau eaba madongan ta narangrang ngan nala pan maron kapei ngan badanga gid Israel ta titnan Isip ga tinam?” ");
INSERT INTO bch_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ta Deo ikeo, “Gau ga namado toman ngan eao. Be gau ga nakado kilala ede ngan pasolannga mambe nasula go tautaunga. Kilala ga bedane: Oangga eao bada gid Israel ta titnan Isip ga tinam, eine gimingada ga asoa gau edag ngan lusi tota nene.” ");
INSERT INTO bch_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Be Moses ikeo pan Deo bedane, “Ega, eine ga nala pagid Israel ta nakeo pagid bedane, ‘Deo togid tibutibumi isula gau ta nanam pagimi,’ be oangga tibeta gau ta tikeo, ‘Ei ieda sai?’ eine ga nakoli led posanga madongan?” ");
INSERT INTO bch_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ta Deo ikeo pan Moses, “Gau Eine Tota Bedane. Ta eao ga keo pagid Israel, ‘Deo iuato ieda mulian bedane: Gau Eine Tota Bedane. Ta ei isula gau Moses ta nanam pagimi.’” ");
INSERT INTO bch_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ta Deo ikeo pan Moses, “Eao ga keo pagid Israel bedane, ‘Maron, Deo togid tibutibumi Abraam ga Aisak ga Iakop, isula gau ta nanam pagimi. Ikeo ga ieda eine toa bedaoa, ta gid panua ga matad nanan ei toa bedaoa somisomi ga ilalala ga ila.’” ");
INSERT INTO bch_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Eao ga la paluplup gid kapeipei togid Israel ta keo pagid bedane, ‘Maron, Deo togid tibutibumi Abraam ga Aisak ga Iakop, iuot pagau ta ikeo: Gau Deo, matag ikikisi gimi. Be nagera danga papaeamao toa ngada ne gid Isip tikakado ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Be naposa tautaunga ngan badanga gimi mulian ngan kadonga papaeamao pagid Isip bagedeai. Ta gau ga nabada gimi ga ala ngan tano togid Kenan ga It ga Amor ga Peres ga Ivi ga Iebus. Tano toa ne kemi ga imona kapei ta bon isul ga bulmakao itud isul iuotot ngan.’ ");
INSERT INTO bch_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Gid kapeipei Israel ad ga tilongo eao ta tinasi lem posanga. Ga kus ta eao ga gid kapeipei toa oa ga ala pan maron kapei togid Isip ta akeo pan bedane, ‘Maron Deo togai Ibru ilup toman ngan gai ta ikeo ga gai anam abeta eao ngan longean gai ta ala ngan tibur modamodanga, irangrang ngan ado tol, ta gai ga arau gid masilau iman lemai tenainga ga ila pan amai Maron Deo.’ ");
INSERT INTO bch_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Gimi ga akado posanga pan toa bedaoa, be gau naoatai mambe maron kapei togid Isip ga irangrang ngan ilongean gimi ga ala sapaean mao. Be oangga napasolan ei ngan urag, eine ga ilongean gimi ta ala. ");
INSERT INTO bch_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Tota ngan gau urag, eine ga napaeabu ngan tibur Isip, ta napamatala gid ngan leg uisinga imata ede ga ede toa nakado ga iuot matadeai. Ga kus ta ei ga ilongean gimi ta ala. ");
INSERT INTO bch_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Be gau ga nakado ga gid Isip lolod marum ngan gimi ta irangrang ngan akilolo ga atnan Isip mao. ");
INSERT INTO bch_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Gid taine Israel ad ga tibetabeta gid taine Isip ad ga gid Isip led kaluae pade, ta tibada danga sisid silva ga gol ga gid barikia papau ga ila pagid. Ta gimi ga adol ga idae ngan lemi gergeu. Ngan kadonga toa bedane, gimi ga abada sapaean gid Isip led danga sisid busa.” ");
INSERT INTO bch_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Ta Moses ikoli ele posanga bedane, “Be oangga gid Israel tiadi gau mao ga tilongo leg posanga mao ta tikeo, ‘Eao pakaka. Maron iuot pago mao,’ eine ga nakado mado?” ");
INSERT INTO bch_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ta Maron ikeo, “Saoa danga toa ienono bagemeai?” Ta Moses ikeo, “Eine toto lalalanga aea.” ");
INSERT INTO bch_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Ta ikeo, “Tado ga isulug tanoeai.” Io, Moses itado ga isulug tanoeai, ta ipul ei ga iuot mota. Be Moses igera ta iuangga iaoa. ");
INSERT INTO bch_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Be Maron ikeo, “Bagem isulug ta kisi iuui.” Tota Moses ibage isulug ta ikisi mota iuui, ta ipul ei mulian ga iuot toto pade. ");
INSERT INTO bch_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Ta ikeo, “Oangga eao la pagid Israel ta kado toa bedaoa, eine ga tiuatai kemi mambe gau Maron naot pago tautaunga. Gau Deo togid tibutibud Abraam ga Aisak ga Iakop.” ");
INSERT INTO bch_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ta Maron ikeo pan Moses pade bedane, “Dol bagem ga idudunga ngan lem pononga mamarae.” Io, Moses ikado toa bedaoa, be mole mao inusi ibage ga iuot mulian, ta igera ibage aea dibala kankan, be imata bodbode tau. ");
INSERT INTO bch_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Ta ikeo pan Moses pade bedane, “Dol bagem ga idudunga pade.” Ta Moses idol ibage ga idudunga pade, be inusi ibage ga iuot mulian ta igera ibage iuot kemi mambe itin toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Ta ikeo, “Oangga panua tigera eao kado uisinga ngan toto be tiadi go mao, eine ga tiadi go ngan uisinga toa ede pade ne. ");
INSERT INTO bch_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Be oangga tigera uisinga toa rua ne be tiadi go mao ga tilongo lem posanga mao, tota ed eau kauteta Nail ta tok ga isulug tanoeai. Oangga eau toa oa isulug tanoeai, eine ga iuot sing.” ");
INSERT INTO bch_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Be Moses ikeo pan Maron bedane, “O Maron, mugaeai ga inam, gau eaba posanga kemi ag mao. Be labone eao posaposa pagau, be aoag ikulupu maitne. Tota narangrang ngan nakado posanga kemi panua matadeai mao.” ");
INSERT INTO bch_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Be Maron ikeo, “Sai ikado eaba iaoa ga iuot? Be sai irangrang ngan ikado ei ga itanga kua ga iaoa gum? Be sai irangrang ngan ikado ei ga imata ikila ga imata igeragera? Gau kekelegau Maron, nakado toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Tota la ne. Gau ga nalua go ngan posanga, ta napaoatai go ngan saoa posanga eao posa ngan.” ");
INSERT INTO bch_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Be Moses ikeo, “Aiao Maron. Gau narangrang mao. Kemi ngan eao sula eaba eta pade.” ");
INSERT INTO bch_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Maron ilolo bake pan Moses ta ikeo, “Be tadim kapei Aron imamado, na? Ei ede ngan gid Livai, ga naoatai mambe ei irangrang ngan ikado posanga kemi. Ega, patautene inama ngan geranga go. Be oangga inama iuot pago, eine ga itin igelgel. ");
INSERT INTO bch_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Eao ga kado posanga toa ngada ne pan, ta ei ga iposa ngan. Be gau ga nalua gimirua ngan posanga ga napaoatai gimirua ngan saoa danga gimi akado. ");
INSERT INTO bch_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Aron ga ibada eao aoam ngan posanga pagid panua. Be ngan ei imata, eao ga ot mambe Deo. ");
INSERT INTO bch_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Be manta bada toto lalalanga aea toa ne ta la. Muriai ta eao kado gid uisinga ngan.” ");
INSERT INTO bch_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Moses ilongo Deo ele posanga ga kus ta iluai mulian pan ilaoa Ietro ta ikeo pan, “Gau nakim eao longo ta naluagau mulian Isip, pagid leg panua, ta nagera gid ta naoatai, labone timamado madongan.” Ta Ietro ikeo, “Goibe. Lolom itarui ta la.” ");
INSERT INTO bch_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Be Moses imamado Midian maitne, ta Maron ikeo pan bedane, “Eao luago mulian Isip. Ngansa gid panua toa tikeo ngan am pamatenga, timate gid ga kus.” ");
INSERT INTO bch_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Tota Moses ibada iadaoa toman ngan ele gergeu arangaranga ta idol gid ga tidae donki ipaoeai, ta tikaka gid ngan langa Isip. Be Moses ikikisi toto lalalanga aea ton Deo. ");
INSERT INTO bch_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ta Maron ikeo pan Moses bedane, “Oangga eao ot Isip, eao manta kado gid uisinga toa na ga iuot maron kapei imatai. Gid uisinga toa na, napamatua go ngan aea kadonga. Be gau ga nakado ga maron kapei ilolo matua ga ipaki itanga, ta ei ga irangrang ngan ilongean leg panua ga tila mao. ");
INSERT INTO bch_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Be eao ga keo pan maron kapei Isip aea bedane, ‘Maron Deo ele posanga bedane: Israel eine gau leg gergeu lautabe. ");
INSERT INTO bch_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Be gau nakeo ga eao longean natug toa ne ga inam ta isoa gau edag. Be ega, oangga eao longean ei ga inama mao, eine ga narau eao lem gergeu lautabe ga imate.’” ");
INSERT INTO bch_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Be ngan saupu ede edap irabuiai, Maron iuot pan Moses ta iuangga irau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Be Sipora, Moses iadaoa, ibada adial ede imata ta ipalu inat ngan itin kukul. Ga kus ta idol inat itin kukul toa oa ga idae ngan Moses iae ta ikeo, “Natuda ising idae ngan eao, ta labone eao gau adaoag tautaunga.” ");
INSERT INTO bch_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Moses iadaoa ikeo toa bedaoa ngansa imata nanan kadonga ngan palunga inat. Ta Deo ipaeabu ngan Moses mao. ");
INSERT INTO bch_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Be Maron ikeo pan Aron bedane, “Eao la ngan tibur modamodanga ta ot pan Moses.” Tota ila iuot pan Moses ngan lusi ton Deo. Igera ei ta ibusum ipapa. ");
INSERT INTO bch_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Idio ta Moses iaoa inasi pan Aron ngan danga toa ngada oa Maron isula ei ngan keonga ga ngan gid uisinga toa irenren pan ngan. ");
INSERT INTO bch_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Idio ga muriai ta Moses ga Aron tila tipaluplup gid kapeipei Israel ad. ");
INSERT INTO bch_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Ta Aron ikeo pagid ngan danga toa ngada oa Maron ikeo pan Moses ngan. Ga pade Moses ikado gid uisinga panua matadeai. ");
INSERT INTO bch_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Ta gid panua Israel tiuangga gisirua led posanga eine tautaunga. Be tilongo mambe Maron igera kadonga papaeamao toa gid Isip tikakado ngan gid ga iuangga ilua gid, tota tikor aed ga tidol laborad ga isulug tanoeai ta tisoa Deo ieda. ");
INSERT INTO bch_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Idio ta Moses ga Aron tila pan maron kapei togid Isip ta tikeo, “Gai Israel amai Maron Deo ikeo ga eao longean ele panua ta tila ngan tibur modamodanga ta tikado eaneannga ngan soanga ieda.” ");
INSERT INTO bch_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Be maron kapei togid Isip ikeo, “Maron sai toa? Ikamado ga nalongo ele posanga ta nalongean gimi Israel ga ala? Gau naoatai ngan Maron toa na mao. Be irangrang ngan nalongean gimi Israel ga ala mao.” ");
INSERT INTO bch_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Ta gisirua tikeo, “Deo togai Ibru ilup toman ngan gai. Gai aoangga alalala ga ala ngan tibur modamodanga irangrang ngan ado tol, ta gai ga apamate gid masilau iman tenainga ga ila pan amai Maron Deo. Be irangrang ngan eao longean gai ta ala? Oangga gai akado toa bedane mao, kado ta ipaeabu ngan gai ngan paraunga, mao ngan dibala kapei eta.” ");
INSERT INTO bch_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Be maron kapei togid Isip ikeo pagisirua bedane, “O Moses ga Aron, ikamado ga akado ta gid panua titnan led naurata? Manmanae, aluagimi ga ala ngan lemi naurata!” ");
INSERT INTO bch_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Ta maron kapei ikeo, “Gid Israel tiuot busa ngan tibur toa ne, be gimirua aoangga akado ta titnan led naurata.” ");
INSERT INTO bch_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Tota ngan ado toaiua, maron kapei togid Isip ikado posanga matua pagid madidnga naurata ad togid Isip ga gid paeaeanga aoad togid Israel ta ikeo, ");
INSERT INTO bch_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Irangrang ngan gimi akado mambe oadla ga inama ne mao. Irangrang ngan abada purup mamasa ga ila pagid panua ngan bulnga toman ngan tano ngan kadonga pat matua oa mao. Manta gid kekelegid tila tigou led purup mamasa. ");
INSERT INTO bch_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Be gimi ga akeo matua pagid ngan tikado pat matua busa lalaede mambe tikakado oadla ga inam. Irangrang ngan tisarung pat matua dabad ga isulug mao. Gid panua malainga ad, tota titang pagau ta tikeo, ‘Longean gai ta ala arau masilau ta iman tenainga ga ila pan amai Deo.’ ");
INSERT INTO bch_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Adol naurata kulupu pagid ta tisonggaro ngan led naurata aea kadonga ta irangrang ngan tilongo posanga pakakanga bedane pade mao.” ");
INSERT INTO bch_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Idio ta gid madidnga naurata ad togid Isip ga gid paeaeanga aoad togid Israel tila pagid panua ta tikeo, “Maron kapei Isip aea ikeo ga irangrang ngan ibada purup mamasa pagimi pade mao. ");
INSERT INTO bch_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Gimi kekelegimi ga ala agou lemi purup mamasa ngan tibur isaoa aot ngan. Be manta akado pat matua busa lalaede mambe somisomi.” ");
INSERT INTO bch_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Gid Israel tilongo bedaoa ta tibilin ga tila alele ngan tibur toa ngada oa Isip ngan gounga purup isakirkir iman led pat matua aea. ");
INSERT INTO bch_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Be gid madidnga naurata ad togid Isip tipasensen gid ta tikeo, “Manta apasala lemi naurata ado ga ado, lalaede mambe oadla gai ababada purup pagimi.” ");
INSERT INTO bch_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ta gid madidnga naurata ad togid Isip timuimui gid paeaeanga aoad togid Israel ta tikeo, “Ikamado ga gimi apasala lemi naurata ngan pat matua aea kadonga made ga labone mao, mambe akakado mugaeai?” ");
INSERT INTO bch_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Tota gid paeaeanga aoad togid Israel titang ga ila pan maron kapei Isip aea bedane, “Ikamado ga eao kado bedane ngan gai lem paeaeanga? ");
INSERT INTO bch_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tibada purup mamasa pagai mao, be aoad isensen gai, lem paeaeanga, ngan pat matua aea kadonga. Ega, timuimui gai, be lemai idil eta paeamao mao. Idil paeamao togimi Isip.” ");
INSERT INTO bch_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Ta maron kapei Isip aea ikeo, “Gimi panua malainga ami! Tota aparpar ta akeo, ‘Longo ta gai ala akado tenainga ga ila pan amai Maron.’ ");
INSERT INTO bch_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Io, aluagimi ngan lemi naurata! Gai ga abada purup mamasa pagimi mao, be manta akado pat matua busa lalaede mambe somisomi.” ");
INSERT INTO bch_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Io, gid paeaeanga aoad togid Israel tilongo maron kapei ikeo ga tirangrang ngan tisarung led pat matua dabad ga isulug ado ga ado mao, ta tiuatai, kadonga kulupu tau tota iuot ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Tota titnan maron kapei Isip aea ga idio, ta tila tiuot pan Moses ga Aron. Gisirua timadmadid ga tisangasanga gid, ");
INSERT INTO bch_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","be gid paeaeanga aoad togid Israel tikeo pagisirua bedane, “Maron Deo igera gimirua lemi kadonga na. Ta ei ga ipanas gimirua. Ngansa gimirua akado ga maron kapei Isip aea toman ngan ele madidnga tiuangga gai ele paeaeanga eine danga buligaliga. Gimirua akado edap ngan gid Isip tipamate gita.” ");
INSERT INTO bch_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Be Moses iluai mulian ga ila pan Maron Deo ta ikeo, “O Maron, eao kamado kado paeamao ngan lem panua ngan kadonga toa ne? Eao sula gau ga nanam ngan ipu toaine na? ");
INSERT INTO bch_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ngan ado toaiua nabada lem posanga ga ila pan maron kapei Isip aea, ga irangrang ngan labone, ei ikado paeamao tau ngan lem panua. Be eao kado danga eta ngan luanga gid mao.” ");
INSERT INTO bch_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Ta Maron Deo ikeo pan Moses bedane, “Teta pade ta eao gera gid danga naoangga nakado ngan maron kapei togid Isip. Ngan gau urag ta nakado ei ga ilongean gimi ta ala. Ta ei ga ipasensen gimi ta isuk gimi ta atnan ele tibur.” ");
INSERT INTO bch_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ta Deo ikeo pan Moses pade bedane, “Gau eine Maron. ");
INSERT INTO bch_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Mugaeai naot pan Abraam ga Aisak ga Iakop, ta tiuatai mambe gau Deo Matua Soke Tau. Be tiuatai ngan edag toaine Maron mao, ngansa napalongo gid ngan mao. ");
INSERT INTO bch_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Be ngan ado toaiua, narau leg posanga tautaunga toman ngan gid ngan pannga tano Kenan ga iman ad. Be timamado ngan tano toa oa mambe kaluae. ");
INSERT INTO bch_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Be labone gid Isip tipaeaea leg panua Israel, ta tisolil ngan ad ieieinga. Be gau nalongo led tandanga na. Ta labone matag nanan leg posanga tautaunga toa narau toman ngan tibutibud. ");
INSERT INTO bch_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Tota eao manta bada leg posanga ga ila pagid Israel bedane: Gau eine Maron. Be gau ga nabada gimi mulian pagid Isip bagedeai, ngan gid danga kulupulupu tikakado ngan gimi. Ta gau ga napola gimi ta atnan lemi naurata paeaeanga ta amado lemi kemi. Be ngan gau urag kapei, eine ga nabada gimi mulian ta napanas gid Isip paeamao tau. ");
INSERT INTO bch_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ta gau ga nakado ga gimi aot leg panua, ta gau ga naot ami Deo. Be gimi ga aoatai mambe gau eine Maron Deo togimi toa nabada gimi ga atnan lemi naurata paeaeanga pagid Isip. ");
INSERT INTO bch_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Be gau ga nabada gimi ta ala ngan tano toa mugaeai naposa tautaunga pan Abraam ga Aisak ga Iakop ngan. Tano toa oa eine ga napan ga iman ami. Gau eine Maron.” ");
INSERT INTO bch_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Io, Moses ipalongo gid Israel ngan posanga toa ngada ne, be tilongo ele posanga mao. Ngansa naurata paeaeanga ikado gid ga lolod igagagai. ");
INSERT INTO bch_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Ga kus ta Maron ikeo pan Moses bedane, ");
INSERT INTO bch_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“La pan maron kapei togid Isip ta keo pan, ei manta ilongean gid Israel ta titnan ele tibur.” ");
INSERT INTO bch_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Be Moses ikeo pan Maron bedane, “Oangga gid Israel tilongo leg posanga mao, eine maron kapei Isip aea ga ilongo leg posanga madongan? Ngansa gau aoag ikulupu ngan posanga.” ");
INSERT INTO bch_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Be Maron iposa toman ngan Moses ga Aron ta ibada naurata pagisirua ngan tila pagid Israel ga pan maron kapei Isip aea, ta ikeo ga led naurata eine ngan badanga gid Israel ta titnan Isip. ");
INSERT INTO bch_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Panua ga gid ne timugamuga ngan gid iaoa edengada Israel. Ruben ei Israel ele gergeu lautabe. Ruben ele gergeu arangaranga edad ga bedane: Anok ga Palu ga Esron ga Karmi. Gid panua toa ne timugamuga ngan gid iaoa kelede pan Ruben. ");
INSERT INTO bch_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Simeon ele gergeu arangaranga edad ga bedane: Iemuel ga Iamin ga Oat ga Iakin ga Soar ga Saul. Saul itna ei taine Kenan aea. Gid panua toa ne timugamuga ngan gid iaoa kelede pan Simeon. ");
INSERT INTO bch_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Livai ele gergeu arangaranga ga itubtub arangaranga edad ga bedane: Gerson ga Koat ga Merari. Be Livai imamado irangrang ngan aea rai buno ede sangaul tol igegea lima ga rua (137), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Be Gerson ele gergeu arangaranga edad ga bedane: Lipni ga Simei. Gisirua timugamuga ngan gid iaoa edengada pan Livai. ");
INSERT INTO bch_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Be Koat ele gergeu arangaranga edad ga bedane: Amram ga Isar ga Ebron ga Usiel. Be Koat imamado irangrang ngan aea rai buno ede sangaul tol igegea tol (133), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Be Merari ele gergeu arangaranga edad ga bedane: Mali ga Musi. Gid panua toa ne timugamuga ngan gid iaoa kelede pan Livai. ");
INSERT INTO bch_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Be Amram iuai itama iliu Iokebet, be taine toa oa ipopo Aron ga Moses. Be Amram imamado irangrang ngan aea rai buno ede sangaul tol igegea lima ga rua (137), ga kus ta imate. ");
INSERT INTO bch_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Be Isar ele gergeu arangaranga edad ga bedane: Kora ga Nepek ga Sikri. ");
INSERT INTO bch_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Be Usiel ele gergeu arangaranga edad ga bedane: Misael ga Elsapan ga Sitri. ");
INSERT INTO bch_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Be Aron iuai taine ede ieda Eliseba. Ei gergeu taine ton Aminadap, be iliu ieda Nason. Aron iadaoa Eliseba ipopo ele gergeu arangaranga edad ga bedane: Nadap ga Abiu ga Eleasar ga Itamar. ");
INSERT INTO bch_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Be Kora ele gergeu arangaranga edad ga bedane: Asir ga Elkana ga Abiasap. Gid panua toa ne timugamuga ngan gid iaoa kelede pan Kora. ");
INSERT INTO bch_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Aron inat Eleasar iuai gergeu taine ede ton Putiel. Ei ipopo Pinias. Gid panua toa ne timugamuga ngan gid iaoa kelede kelede pan Livai. ");
INSERT INTO bch_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Panua rua toa Maron ikeo pagid ngan badanga gid iaoa kelede kelede togid Israel ta titnan Isip, panua toa rua oa, eine Moses ga Aron. Gisirua edad iuot ngan gid iaoa toaine. ");
INSERT INTO bch_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Gisirua tota tila pan maron kapei Isip aea ngan badanga gid Israel ta titnan Isip. Panua toa rua ne tota tikado kadonga toa oa. ");
INSERT INTO bch_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Moses imamado Isip ta Maron iposa pan. Be ngan ado toaiua, ");
INSERT INTO bch_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","Maron ikeo pan bedane, “Gau eine Maron. Eao manta keo pan maron kapei togid Isip ngan posanga toa ngada ne naposa pago ngan.” ");
INSERT INTO bch_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Be Moses ikeo pan Maron bedane, “Gau eaba posanga kemi ag mao. Tota maron kapei togid Isip ga ilongo gau madongan?” ");
INSERT INTO bch_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ta Maron ikeo pan Moses, “Longo. Ngan maron kapei Isip aea imata, gau ga nakado ta eao ot mambe Deo. Be tadim kapei Aron ga ibada aoam, ta ei ga ibada lem posanga ga ila pan maron kapei togid Isip. ");
INSERT INTO bch_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Danga toa ngada ne naposa pago ngan, eine eao ga keo pan tadim kapei Aron ngan. Ta Aron ga iposa pan maron kapei Isip aea ngan ilongean gid panua Israel ta titnan ele tibur. ");
INSERT INTO bch_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Be gau ga nakado ta maron kapei ilolo matua ga ipaki itanga. Toa bedaoa ta nakado gid uisinga busa iman kilala rabu ngan gid Isip. ");
INSERT INTO bch_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Be maron kapei togid Isip irangrang ngan ilongo lemi posanga mao. Tota gau ga napasolan urag ta napanas gid Isip ngan gid pamukurunga kapeipei. Be gau ga naot mambe madidnga paraunga aea ta namuga ngan leg panua, gid iaoa kelede kelede togid Israel, ta titnan Isip ga tila. ");
INSERT INTO bch_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Be oangga napaeabu ngan tibur Isip ta nabada gid panua Israel ta titnan tibur toa oa, eine gid Isip ga tiuatai kemi mambe gau eine Maron.” ");
INSERT INTO bch_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Tota Moses ga Aron tikado mambe Maron ikeo pagisirua ngan. ");
INSERT INTO bch_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Ngan ado toaiua gisirua tila tiposa pan maron kapei togid Isip, Moses aea rai sangalima sangaul tol, be Aron aea rai sangalima sangaul tol igegea tol. ");
INSERT INTO bch_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Idio ta Maron ikeo pan Moses ga Aron bedane, ");
INSERT INTO bch_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Oangga maron kapei togid Isip ikeo pagimirua ngan kadonga uisinga eta ngan pasolannga mambe gau nasula gimirua, eine eao ga keo pan Aron ta ibada ele toto lalalanga aea ta itado ga isulug maron kapei Isip aea imatai, ta ele toto ga ipul ei ga iuot mota.” ");
INSERT INTO bch_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Tota Moses ga Aron tila pan maron kapei togid Isip ta tikado mambe Maron Deo ikeo pagisirua ngan. Aron itado ele toto ga isulug maron kapei Isip aea ga ele madidnga matadeai, ta ipul ei ga iuot mota. ");
INSERT INTO bch_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Be maron kapei igera toa bedaoa ta ibaba ele panua oatainga ad ga ele panua borou ad, ta tikado toa bedaoa pade ngan led borou mambe Aron ikado. ");
INSERT INTO bch_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Gid kelede kelede titado led toto ga isulug tanoeai ta tipul gid ga tiuot mota. Be Aron ele mota ison gid led mota ga kus. ");
INSERT INTO bch_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Maron kapei togid Isip igera, be ilolo matua ga ipaki itanga. Ta ilongo gisirua led posanga mao, lalaede mambe Maron Deo ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Idio ta Maron ikeo pan Moses bedane, “Maron kapei togid Isip ilolo matua tau, ta itin ngan ilongean gid Israel ga tila mao. ");
INSERT INTO bch_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Be gaisala rumaruma ei ga ila eauiai, ta eao ga la ot pan. Bada toto toa mugaeai iuot mota ta la sanga ei eau Nail isaleai. ");
INSERT INTO bch_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ta eao ga keo pan bedane, ‘Gai Ibru amai Maron Deo isula gau ga nanam ta nakeo pago bedane: Eao manta longean ele panua ga tila ngan tibur modamodanga ta tisoa ieda. Be irangrang ngan labone, eao longo ele posanga mao. ");
INSERT INTO bch_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Tota labone Maron Deo ikeo bedane: Eao ga gera gid danga naoangga nakado, ta eao ga oatai kemi mambe gau eine Maron.’ Ega, gau ga nabal eau Nail ngan toto toa bagegeai ne, ta eau ga iuot sing. ");
INSERT INTO bch_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Gid ia ga timatemate, be eau ga iuad paeamao tau, ta irangrang ngan gid Isip tiun mao.” ");
INSERT INTO bch_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Ta Maron ikeo pan Moses pade ga bedane, “Keo pan Aron ta ibada ele toto ta igaga ga ingata gid eau kapeipei ga gereirei ga liuliu toa ngada ne ngan tibur Isip. Ta gid eau ga tiuot sing. Tota ngan tibur toa ngada ne Isip, sing ga iuon ngan gid eau. Be gid tabla ga ulo ga eaupat pade ga tiuon ngan sing.” ");
INSERT INTO bch_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Tota Moses ga Aron tikado lalaede mambe Maron ikeo pagisirua ngan. Ngan maron kapei togid Isip ga ele madidnga matad, Aron isoa ele toto ga idae ta ibal eau Nail, ta eau toa ngada oa iuot sing. ");
INSERT INTO bch_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Ia toa ngada oa ngan eau Nail timatemate, be eau toa oa iuad paeamao tau, ta irangrang ngan gid Isip tiunun mao. Sing iuon ngan tibur toa ngada oa Isip. ");
INSERT INTO bch_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Be gid panua borou ad togid Isip tikado led borou ta tikado toa bedaoa pade. Ta maron kapei Isip aea ilongo Moses ga Aron led posanga mao, ngansa ilolo matua ga ipaki itanga mambe Maron Deo ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Tota maron kapei togid Isip iluai mulian ele lumaeai. Kadonga toa ne ikado ga ilolo ede ga ede eta mao. ");
INSERT INTO bch_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Be gid panua Isip tirangrang ngan tiun eau Nail mao, tota tileilei gid baba eau Nail isaleai ngan badanga ad eau. ");
INSERT INTO bch_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Be Maron ikado ga eau Nail ienono paeamao toa bedaoa irangrang ngan ado lima ga rua. ");
INSERT INTO bch_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Idio ta Maron ikeo pan Moses bedane, “La pan maron kapei togid Isip ta keo pan, ‘Maron Deo ele posanga bedane: Eao manta longean leg panua ta tila tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Be ega, oangga eao longean gid ga tila mao, eine ga nakado ta gid kalo busa tiuot ngan tibur Isip, ta napaeabu ngan lemi tibur toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Eau Nail ga iuon tau ngan gid kalo. Be gid kalo ga titnan eau ga tidae ta tidugdug ga tila ngan lem luma ga lem bobo enonga aea ga mulim pade. Be gid kalo ga tidugdug ga tidae pade ngan luma togid lem madidnga ga lem panua toa ngada ne. Be gid ga tidugdug ga tidae pade ngan lemi danga nononga aea ga lemi tabla bret aea. ");
INSERT INTO bch_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Gid kalo ga tidugdug ga tidae ngan eao ga lem madidnga ga lem panua toa ngada ne.’” ");
INSERT INTO bch_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ta Maron ikeo pan Moses pade bedane, “Keo pan Aron ta ikisi ele toto lalalanga aea ga idae ta ipatutui ibage, ta igaga ga ingata gid eau kapeipei ga gereirei ga liuliu toa ngada oa ngan tibur Isip. Toa bedaoa ga gid kalo tiuon ngan tibur Isip.” ");
INSERT INTO bch_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Tota Aron ikisi ele toto lalalanga aea ga idae ta ipatutui ibage, ta igaga ga ingata gid eau Isip, ta gid kalo tidae ga tiluga tibur Isip. ");
INSERT INTO bch_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Be gid panua borou ad togid Isip tikado led borou, ta gid pade tikado ga gid kalo titnan eau ga tidae ngan tibur Isip. ");
INSERT INTO bch_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Idio ta maron kapei togid Isip ibaba Moses ga Aron ga tinam pan ta ikeo, “Manta gimirua araring ga ila pan ami Maron Deo ta isere gid kalo ta titnan gau ga leg panua. Ga kus ta nalongean gimingada lemi panua ta ala akado tenainga ga ila pan ami Maron.” ");
INSERT INTO bch_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Ta Moses ikeo pan maron kapei Isip aea bedane, “Goibe, gau ga nararing ngan luanga eao ga lem madidnga ga lem panua. Toa bedaoa ta gid kalo ga titnan gimi ga lemi luma, ta tila mulmulid eauiai. Be eao kim nararing ngeda? Tota nadol ga idae eao bagemeai.” ");
INSERT INTO bch_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ta maron kapei togid Isip ikeo, “Raring sabale.” Ta Moses ikeo, “Gau ga nakado mambe eao keo ngan, tota eao ga oatai kemi bedane: Deo eta pade mambe gai amai Maron Deo mao. ");
INSERT INTO bch_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Gid kalo ga titnan eao ga lem madidnga ga lem panua ga lemi luma. Tota tila mulmulid eauiai.” ");
INSERT INTO bch_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Io, Moses ga Aron titnan maron kapei Isip aea ga idio, ga kus ta Moses iraring matua ga ila pan Maron Deo ngan serenga gid kalo toa mugaeai isula ga tidae ngan maron kapei Isip aea. ");
INSERT INTO bch_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Tota Maron Deo ikado mambe Moses ibeta ei ngan. Ta gid kalo timatemate lumaeai ga tuanga iloleai ga dadangai pade. ");
INSERT INTO bch_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Ta tisuksuk gid kalo patid ngan suknga ga suknga ngan tibur toa ngada oa Isip, be tibur toa oa iuad paeamao tau. ");
INSERT INTO bch_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Be maron kapei togid Isip igera mambe gid kalo timatemate, ta ilolo ikapok. Tota ilolo matua pade ga ipaki itanga. Ta ilongo Moses ga Aron led posanga mao, mambe Maron Deo ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Idio ta Maron ikeo pan Moses bedane, “Keo pan Aron ta isoa ele toto ga idae ta ibal tano, ta tano aea kangkanga ngan tibur toa ngada ne Isip ga iuot kikiramo.” ");
INSERT INTO bch_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Tota gisirua tikado toa bedaoa. Aron isoa ele toto ga idae ta ibal tano, ta tano aea kangkanga toa ngada oa Isip iuot kikiramo. Be kikiramo tigonggong gid eababa ga masilau mud pade. ");
INSERT INTO bch_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Be gid panua borou ad togid Isip titoba ngan kadonga kikiramo ngan led borou pade, be tirangrang mao. Kikiramo tigonggong gid eababa ga masilau. ");
INSERT INTO bch_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ta gid panua borou ad tikeo pan maron kapei Isip aea bedane, “Deo kekelen ikado kadonga toa ne.” Be maron kapei ilolo matua ga ipaki itanga ngan Moses ga Aron led posanga, mambe Maron Deo ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Idio ta Maron ikeo pan Moses bedane, “Gaisala rumaruma, oangga maron kapei togid Isip ila eauiai, eao dae ta la ot pan. Ta keo pan ngan leg posanga bedane, ‘Gau Maron Deo nakeo ga bedane: Eao longean leg panua ta tila tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Be ega, oangga eao longean leg panua ga tila mao, gau ga nakado ta langlango busa tau tidae ngan eao ga lem madidnga ga lem panua toa ngada oa, be tidudunga lemi lumaeai pade. Langlango ga tiuon ngan gimi Isip lemi luma ga tibur isaoa amamado ngan. ");
INSERT INTO bch_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“‘Be oangga gid langlango tiuot, eine ga nakado kadonga ede pade ngan gau leg panua toa timamado ngan tibur Gosen. Langlango eta ga ila pagid leg panua ngan tibur toa oa mao. Toa bedaoa ta eao ga gera ta oatai kemi mambe gau Maron Deo nakado kadonga toa ne ngan lem tibur. ");
INSERT INTO bch_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Be gau ga nabada mulian leg panua, ta langlango ga tila pagid mao, be pagid eao lem panua kekelegid. Longo, uisinga kapei toa ne ga iuot sabale.’” ");
INSERT INTO bch_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Tota Maron Deo ikado toa bedaoa. Gid langlango ipu ga ipu tiroro ga tidudunga maron kapei ele lumaeai. Ga pade tidudunga ngan luma togid ele madidnga ga tibur toa ngada oa Isip. Gid langlango tikado ga tibur Isip iuot paeamao. ");
INSERT INTO bch_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Idio ta maron kapei togid Isip ibaba Moses ga Aron ga tinam pan ta ikeo, “Gimi adio ngan tibur Isip ta akado tenainga ga ila pan ami Deo.” ");
INSERT INTO bch_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Be Moses ikeo, “Oangga gai akado bedane, eine tutui mao. Ngansa gid tenainga toa gai akakado ga ila pan amai Maron Deo, eine gid Isip ga tigera mambe danga ede paeamao ga paeamao tau. Oangga gid Isip tigera gai arau gid masilau tenainga aea toa bedaoa, eine ga tirau gai ngan patpat ga amate. ");
INSERT INTO bch_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Gai manta alalala ga ala ngan tibur modamodanga irangrang ngan ado tol ta akado tenainga ga ila pan amai Maron Deo toa eoa, mambe ikeo pagai ngan.” ");
INSERT INTO bch_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Ta maron kapei togid Isip ikeo, “Goibe, gau ga nalongean gimi ta ala ngan tibur modamodanga ngan kadonga tenainga ga ila pan ami Maron Deo, be irangrang ngan ala aluai tau mao. Be manta araring ngan luanga gau pade.” ");
INSERT INTO bch_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Ta Moses ikeo, “Ega, gau ga natnan go ga dio, ga kus ta nararing ga ila pan Maron Deo, ta sabale ei ga isere gid langlango ngan eao ga lem madidnga ga lem panua. Be kado eao pakaka gai pade ta pakala gai ngan kadonga tenainga ga ila pan amai Maron Deo.” ");
INSERT INTO bch_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Tota Moses itnan maron kapei togid Isip ga idio, ga kus ta iraring ga ila pan Maron Deo. ");
INSERT INTO bch_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Ta Maron ikado mambe Moses ibeta ei ngan. Gid langlango titnan maron kapei Isip aea ga ele madidnga ga ele panua. Langlango eta idio mao. ");
INSERT INTO bch_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Gid langlango tila ga kus, be maron kapei togid Isip ilolo matua ga ipaki itanga pade, ta ilongean gid panua ga tila mao. ");
INSERT INTO bch_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Idio ta Maron ikeo pan Moses bedane, “La pan maron kapei togid Isip ta keo pan bedane, ‘Gau Maron Deo togid Ibru. Leg posanga ga bedane: Longean leg panua ta tila tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Be oangga eao longean gid ga tila mao, be dangadangan gid maitne, ");
INSERT INTO bch_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","eine gau ga nakado dibala ede paeamao tau iuot ngan lemi masilau mud. Lemi os ga donki ga kamel ga bulmakao ga sipsip ga meme gau tidibal kapei ta timate. ");
INSERT INTO bch_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Be gau leg kadonga ngan gid Israel led masilau ga iuot lalaede mambe nakado ngan gimi Isip lemi masilau mao. Masilau eta togid Israel ga imate mao.’” ");
INSERT INTO bch_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Io, tota Maron Deo idol ado imata ngan kadonga toa ne iuot ta ikeo, “Sabale eine ga nakado toa bedaoa ngan tibur toa ne.” ");
INSERT INTO bch_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Ta ngan ado sae Maron ikado ga iuot toa bedaoa. Gid masilau mud toa ngada oa togid Isip timatemate. Be masilau eta togid Israel imate mao. ");
INSERT INTO bch_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Be maron kapei togid Isip isula ele panua edengada ga tila pagid Israel, ngansa iuangga iuatai: masilau eta togid Israel imate, mao madongan. Be tiluagid mulian ga tila pan ta tikeo, “Mao. Masilau eta togid Israel imate mao.” Io, maron kapei togid Isip igera bedaoa, be ilolo matua ga ipaki itanga pade, ta ilongean gid Israel ga tila mao pade. ");
INSERT INTO bch_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Idio ta Maron ikeo pan Moses ga Aron bedane, “Gimirua ala ngan tibur toa tinono pat matua ngan, ta akori dinga itae idanga eta ta ala pan maron kapei togid Isip. Gimi aot pan ga kus ta Moses ga isiran dinga itae toa oa ga idae gadae toa maron kapei imatai. ");
INSERT INTO bch_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Ta dinga itae ga ibilin ta ipakaranga tibur toa ngada oa Isip. Be oangga dinga itae toa oa itap ga idae ngan gid eababa ga masilau tinid, eine ga ipapot gid sererie ga iuotot ta timapmapoga. Ga kus ta gid boto kapeipei ga iuotot.” ");
INSERT INTO bch_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Io, tota Moses ga Aron tikori dinga itae ta tila timadid maron kapei Isip aea imatai, ta Moses isiran dinga itae toa oa ga idae gadae. Ta dinga itae ipapot gid sererie ngan gid eababa ga masilau tinid. Ga kus ta timapmapoga ta gid boto kapeipei tiuotot. ");
INSERT INTO bch_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Be gid panua borou ad togid Isip tirangrang ngan timadid Moses imatai mao, ngansa gid sererie iuotot ngan gid tinid pade mambe iuotot ngan gid Isip toa ngada oa tinid. ");
INSERT INTO bch_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Be Maron Deo ikado ga maron kapei Isip aea ilolo matua ga ipaki itanga pade. Ta ilongo Moses ga Aron led posanga mao, mambe Maron Deo ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Idio ta Maron ikeo pan Moses bedane, “Gaisala rumaruma eao dae ta la ot pan maron kapei togid Isip, ta kado leg posanga pan bedane, ‘Gau Maron Deo togid Ibru. Nakeo ga bedane: Longean leg panua ta tila tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Oangga mao, gau ga nakado leg pamukurunga toa ngada ne ta napaeabu ngan eao ga lem madidnga ga lem panua. Ta gimi ga aoatai kemi bedane: Ngan tibur toa ngada ne tanoeai, deo eta pade mambe gau mao. ");
INSERT INTO bch_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Be oangga nakim, gau narangrang ngan napaeabu ngan eao ga lem panua ngan dibala kapei eta ta napamukuru gimi ga kus. ");
INSERT INTO bch_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Be nakado toa bedaoa mao ngansa naoangga napasolan gimi ngan urag kapei, ta nakim oalug ipakaranga tibur toa ngada ne tanoeai. Ta ngan ipu toaine nadol go. ");
INSERT INTO bch_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Be eao pakala leg panua maitne ta longean gid ga tila mao. ");
INSERT INTO bch_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tota longo. Sabale ngan ado imata toa bedane, gau ga nakado aoara kapei toa idildil matua mambe patpat ga itap ngan tibur Isip. Mugaeai, tibur Isip iuot pau ga irangrang ngan labone, aoara kapei eta bedane itap mao. ");
INSERT INTO bch_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Toa patautene eao manta kado posanga matua ga ila pagid lem panua ta tibada lem bulmakao ga danga padengada ienono gaot, ta tinam tidudunga lumaeai. Ngansa aoara idildil matua mambe patpat eine ga itaptap ga idae ngan gid eababa ga masilau toa ngada oa timamado gaot. Ta gid ga timate.’” ");
INSERT INTO bch_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Io, maron kapei togid Isip ele madidnga edengada timataud Maron Deo ele posanga ta tila manmanae ta tibada led paeaeanga ga masilau mud ga tidudunga lumaeai. ");
INSERT INTO bch_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Be maron kapei ele madidnga padengada matad ila ngan Maron Deo ele posanga mao, ta titnan led paeaeanga ga led masilau mud ga tidio gaot. ");
INSERT INTO bch_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Idio ta Maron ikeo pan Moses bedane, “Soa bagem ga idae ta gaga ga ingata mariamba, ta aoara idildil matua mambe patpat eine ga itaptap ngan tibur toa ngada ne Isip. Eine ga itap ga idae ngan gid eababa ga masilau mud ga gid annga toa ngada oa dadangai.” ");
INSERT INTO bch_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Idio ta Moses isoa ele toto ga idae ta igaga ga ingata mariamba, ta Maron Deo ikado ga gla isamil ga pelaka ger. Ta ikado ga aoara kapei toa idildil matua mambe patpat itaptap ngan tibur toa ngada oa Isip. ");
INSERT INTO bch_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Aoara idildil matua toa oa itaptap kapei tau, be gla isamil alele ngan tibur toa ngada oa. Mugaeai, tibur Isip iuot pau ga irangrang ngan ado toaiua, gid Isip tigera aoara eta kapei bedaoa mao. ");
INSERT INTO bch_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Aoara toa idildil matua ipaeabu ngan gid eababa ga masilau ga danga toa ngada oa ienono gaot. Be ipaeabu ngan gid annga dadangai ga ikorkor gid abei toa ngada oa pade. ");
INSERT INTO bch_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Be ngan tibur Gosen kekelen, toa gid Israel timamado ngan, aoara idildil matua itap eta mao. ");
INSERT INTO bch_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Idio ta maron kapei togid Isip ibaba Moses ga Aron ga tinam pan ta ikeo, “Labone leg kadonga paeamao. Maron Deo ele kadonga itutui, be gaingada leg panua lemai idil paeamao. ");
INSERT INTO bch_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Gimi araring ga ila pan ami Maron ta ipamate mariamba ele tandanga ga aoara idildil matua ga idio. Ngansa aoara toa idildil matua ne ipaeabu ngan gai tau. Tota gau ga nalongean gimi ga ala. Irangrang ngan amado mole nene pade mao.” ");
INSERT INTO bch_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Ta Moses ikeo, “Oangga natnan tuanga toa ne ga nala, eine ga nasoa bageg ta nararing pan Maron Deo. Ta mariamba ele tandanga ga aoara idildil matua ga kus ga tidio. Toa bedaoa ta eao ga oatai kemi mambe tibur toa ngada ne tanoeai, eine ton Maron Deo. ");
INSERT INTO bch_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Be gau naoatai, eao ga lem madidnga alolon ngan Maron Deo mao.” ");
INSERT INTO bch_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ngan ado toaiua, aoara idildil matua ipaeabu ngan pleks ga bali toa ngada oa dadangai, ngansa ado toaiua eine gid danga oa ad laoe. ");
INSERT INTO bch_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Be gid wit ga kusemet timate mao, ngansa gid ad laoe iuot maitne. ");
INSERT INTO bch_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Be Moses itnan maron kapei Isip aea ga idio ta itnan tuanga toa oa ga ila, ta isoa ibage ga idae ta iraring ga ila pan Maron Deo. Tota mariamba ele tandanga ga aoara idildil matua kus ta itaptap tanoeai pade mao. ");
INSERT INTO bch_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Be maron kapei togid Isip igera mambe aoara idildil matua ga mariamba ele tandanga kus, ta gisingada ele madidnga lolod matua ga tipaki tangad ta tikado kadonga sat pade. ");
INSERT INTO bch_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Tota maron kapei togid Isip ilolo matua ta ilongean gid Israel ga tila mao, lalaede mambe Moses ibada Maron Deo iaoa ngan. ");
INSERT INTO bch_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Idio ta Maron ikeo pan Moses bedane, “Eao la gera maron kapei togid Isip pade. Ngansa gau nakado ta ei toman ngan ele madidnga lolod matua tau ga tipaki tangad. Toa bedaoa ta gau ga nakado gid uisinga iman kilala rabu ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Nakado toa bedaoa ta muriai gimi ga aninipu pagid lemi gergeu ga tibutibumi ngan gau nakoli paeamao pagid Isip ngan gid uisinga toa nakado rabu ngan gid, be lolog isat ngan gid mao. Toa bedaoa ta gimi toa ngada ne ga aoatai kemi mambe gau eine Maron.” ");
INSERT INTO bch_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Io, Moses ga Aron tila pan maron kapei Isip aea ta tikeo, “Maron Deo togai Ibru ele posanga ga bedane: ‘Ngeda be eao lolon ngan gau ta longo lingeg? Longean leg panua ta tila tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Be oangga eao longean gid ga tila mao, sabale gau ga nakado ta gid gurisi busa tinam tiuon ngan lem tibur. ");
INSERT INTO bch_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Gid ga tirobi tibur toa ngada ne ta tiuon ngan, ta irangrang ngan gimi agera tano igogo mao. Annga idanga edengada toa aoara idildil matua ipaeabu ngan mao ne, tota gid gurisi ga tian ga kus toman ngan gid abei toa tiparapara tiburiai ga dadangai. ");
INSERT INTO bch_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Gid gurisi ga tiroro ga tila tiuon ngan lem luma ga luma togid lem madidnga ga lem panua toa ngada ne. Mugaeai, tamatamami ga tibutibumi timamado Isip ga irangrang ngan labone, gid tigera gurisi tiuot busa toa bedaoa mao.’” Io, Moses iposa bedaoa ga kus ta ipul ei mulian ta itnan maron kapei togid Isip ga ila. ");
INSERT INTO bch_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Be gid madidnga ton maron kapei Isip aea tikeo pan bedane, “Eaba toa ne ga ikado kulupu ngan gita papida pade? Longean ele panua ta tila tisoa ad Maron Deo ieda! Tibur Isip paeamao na. Be eao gera mao?” ");
INSERT INTO bch_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Idio ta tila tibada Moses ga Aron ta tiluagid mulian pan maron kapei togid Isip, ta ikeo pagisirua, “Goibe. Gimi ala asoa ami Maron Deo ieda. Be sapadua ngan gimi ga tila?” ");
INSERT INTO bch_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Ta Moses ikeo, “Gai toa ngada ne ga ala. Gaingada gid kakau ga kapeipei ga gergeu arangaranga ga taine ga lemai sipsip ga meme ga bulmakao. Ngansa gai ga akado eaneannga ngan soanga amai Maron Deo ieda.” ");
INSERT INTO bch_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Be maron kapei togid Isip ikeo, “Irangrang ngan gimi toa ngada ne ala mao. Oangga adadaoami ga lemi gergeu tila pade, manta ami Maron Deo ilua gimi! Ngansa gau nakeo ga tidio. Gau naoatai, gimi aoangga akado paeamao ngan gai. ");
INSERT INTO bch_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Mao tau! Gimi arangaranga kekelegimi ga ala asoa ami Maron ieda. Ngansa gimi abeta pagau ngan toa bedane.” Maron kapei togid Isip iposa bedaoa ga kus ta ele madidnga tisusuran Moses ga Aron ta tiuot ga tila. ");
INSERT INTO bch_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Ga kus ta Maron Deo ikeo pan Moses bedane, “Soa bagem ga idae ta gaga ga ingata tibur Isip. Ta irangrang ngan gid gurisi busa tiroro ga tinam tiuon ngan tibur Isip. Gid annga ga danga padengada toa aoara idildil matua ipaeabu ngan mao ne, eine gid gurisi ga tian ga kus.” ");
INSERT INTO bch_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Io, tota Moses isoa ele toto ga idae ta igaga ga ingata tibur Isip, ta Maron Deo ikado ga rai kapei iuot ado ele parangai ga inam, irangrang ngan ado dodol ede ga bong. Be gaisala rumaruma ngan ado sae tota rai itilak gid gurisi ga tinam. ");
INSERT INTO bch_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Ta tisulug ga tisaoe tibur toa ngada oa Isip ga iuon ngan gid. Mugaeai ga inama, gurisi tiuot busa toa bedaoa mao. Be irangrang ngan tiuot busa toa bedaoa muriai mao pade. ");
INSERT INTO bch_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tirobi tano igogo ga ikusuksuk. Tota tian annga ga danga toa ngada oa aoara idildil matua ipaeabu ngan mao. Titnan abei itautau ga abei ilaun eta ga ienono ngan tibur Isip mao. Tian toa ngada oa ga kus. ");
INSERT INTO bch_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Tota manmanae maron kapei togid Isip ibaba Moses ga Aron ga tinam pan ta ikeo, “Gau nakado kadonga sat pan ami Maron Deo ga pagimi pade. ");
INSERT INTO bch_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tota asamum leg kadonga sat toa ne pakelede pade, ta araring ga ila pan ami Maron Deo ta ikado ga danga paeamao toa ne kus. Ngan kado ta ipaeabu ngan gau.” ");
INSERT INTO bch_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Tota Moses itnan maron kapei Isip aea ga idio, ta iraring ga ila pan Maron Deo. ");
INSERT INTO bch_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Tota Maron Deo ipalele rai ele ladonga ta iuot ado ele dilngai ga inam. Ta rai toa oa iuot kapei tau ta itilak gid gurisi ta tisulug ngan tad Singsingia. Be gurisi eta idio ngan tibur Isip mao. ");
INSERT INTO bch_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Be Maron Deo ikado ga maron kapei Isip aea ilolo matua ga ipaki itanga pade. Ta ilongean gid Israel ga tila mao pade. ");
INSERT INTO bch_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Idio ta Maron ikeo pan Moses bedane, “Soa bagem ga idae ta gaga ga ingata mariamba, ta irangrang ngan tibur toa ngada oa Isip iuot dodom. Dodom toa ne ga iuot ede pade tau, mambe danga ede idae tor ngan panua tinid ga tinaman.” ");
INSERT INTO bch_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Io, Moses isoa ibage ga idae ta igaga ga ingata mariamba, tota tibur toa ngada oa Isip iuot dodom tau irangrang ngan ado tol. ");
INSERT INTO bch_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Eaba eta Isip irangrang ngan geranga iuae eta pade mao. Gid timamado lumaeai, be tirangrang ngan langa gaot mao, ngansa dodom kapei ipakala gid irangrang ngan ado tol. Be dodom toa oa iuot pagid Israel mao. Gid timamado merengai. ");
INSERT INTO bch_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Idio ta maron kapei togid Isip ibaba Moses ga inam pan ta ikeo, “Gimi ala asoa ami Maron Deo ieda. Goibe, gimingada adadaoami ga lemi gergeu ga ala. Be lemi bulmakao ga sipsip ga tidio Isip.” ");
INSERT INTO bch_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Be Moses ikeo, “Mao. Eao manta longean gai ta abada lemai masilau pade ta timan lemai tenainga aea. Edengada, gai ga adol dingaeai ta dinga inono ga timomout ga kus, ta iman tenainga ga ila pan amai Maron Deo. ");
INSERT INTO bch_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Tota lemai masilau mud toa ngada ne ga tila toman ngan gai. Gai ga atnan eta ga idio mao. Be toa nene irangrang ngan gai aoatai ngan masilau isaoa ga iman tenainga aea mao. Gai ala aot toa eoa ga kus ta asio gid masilau toa timan tenainga ga ila pan amai Maron Deo ngan soanga ieda.” ");
INSERT INTO bch_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Be Maron Deo ikado ga maron kapei togid Isip ilolo matua ga ipaki itanga pade. Ta itin ngan ilongean gid ga tila mao. ");
INSERT INTO bch_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ta maron kapei togid Isip ikeo pan Moses bedane, “La aluai ngan matag! Irangrang ngan eao luago mulian pagau pade mao. Oangga eao luago mulian pagau pade, eao ga mate.” ");
INSERT INTO bch_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Ta Moses ikeo, “Eine mambe eao keo. Gau ga nanam nagera matam pade mao.” ");
INSERT INTO bch_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Idio ta Maron ikeo pan Moses bedane, “Gau ga nakado pamukurunga kelede pade ga iuot ngan maron kapei togid Isip toman ngan ele panua. Ga kus ta ei ga ilongean gimi ta atnan tibur toa ne ga ala. Be ei ga ipasensen gimi ta isuk gimi toa ngada ne ga ala. ");
INSERT INTO bch_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Be keo pagid arangaranga ga taine Israel ad ta tibeta gid Isip toa timamado boloma pagid ta tibada sogonga silva ga gol ga ila pagid.” ");
INSERT INTO bch_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Be ngan ado toaiua, gid Isip tilongo gid Israel linged ta tibada danga sisid toa oa pagid, ngansa Maron Deo ikado ga gid Isip lolod marum ngan gid Israel. Be maron kapei Isip aea ele panua ga ele madidnga pade tilolon ngan Moses ta tigera ei mambe madidnga kapei ede.) ");
INSERT INTO bch_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ta Moses ikeo pan maron kapei togid Isip bedane, “Maron Deo ikeo ga bedane: Bong irabu, gau ga nala ngan luma kelede kelede togid Isip, ");
INSERT INTO bch_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ta gid gergeu lautabtabe arangaranga toa ngada oa Isip ad ga timate. Eao lem gergeu lautabe toa sio ei ngan badanga mulim, ei ga imate. Ga gergeu lautabtabe togid panua edad kapeipei ga panua edad mao toa ngada oa ga irangrang ngan gergeu lautabe ton taine paeaeanga ilumulumu wit itautau, gid toa ngada oa ga timate. Be gid bulmakao led gergeu lautabtabe ga timate pade. ");
INSERT INTO bch_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Toa bedaoa ta gid Isip ga tikado tandanga kapei tau. Tandanga eta kapei bedane iuot mugaeai ngan tibur Isip mao, be muriai irangrang ngan tandanga kapei bedane iuot mao pade. ");
INSERT INTO bch_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Be pagid Israel, kaua eta ga isok mao, ga kadonga eta ga iuot pagid led panua mao ga led masilau mud mao pade. Toa bedaoa ta gimi ga aoatai kemi mambe Maron Deo ikado kadonga lalaede pagid Israel mambe ikado pagimi Isip mao. ");
INSERT INTO bch_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Eao lem madidnga ga lem panua toa ngada ne ga tinam tikor aed pagau ta tiposa matua bedane, ‘Manmanae! La toman ngan panua toa ngada na tinasnasi lingem!’ Kadonga toa ngada ne iuot ga kus ta gau ga natnan Isip ga nala.” Moses iposa bedaoa ga kus ta itnan maron kapei togid Isip ta iuot ga ila, be ilolo bake tau. ");
INSERT INTO bch_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Be somisomi Maron Deo ikeo pan Moses bedane, “Maron kapei togid Isip ga ipaki itanga ngan lem posanga pade. Toa bedaoa ta leg uisinga iuot busa rabu ngan gid Isip.” ");
INSERT INTO bch_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Be Moses ga Aron tikado gid uisinga toa busa ne maron kapei Isip aea imatai ga kus. Be Maron Deo ikado ei ga ilolo matua ga ipaki itanga somisomi, ta ilongean gid Israel ga titnan ele tibur mao. ");
INSERT INTO bch_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Moses ga Aron timamado Isip maitne, be Maron ikeo pagisirua bedane, ");
INSERT INTO bch_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Taiko toaine eine gimi lemi taiko imugamuga ngan rai toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Be gimirua ga akeo pagid panua toa ngada ne Israel ad ga bedane: Ngan taiko toaine aea ado sangaul, gid luma itamatama kelede kelede ga tisio gid ad sipsip mao meme eta. ");
INSERT INTO bch_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Oangga luma eta aea panua busa mao ta tirangrang ngan eannga masilau dodol toa oa ga kus mao, eine ga tilup toman ngan iaoa ede pade boloma ngan gid. Manta matad inasi kemi led panua dabad ta tipota masilau imedameda ga irangrang ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Be manta asio sipsip mao meme aranga eta toa aea rai kelede. Be irangrang ngan asio sipsip eta toa aea tibun mao ga danga eta pade ipaeabu ngan itin mao pade. ");
INSERT INTO bch_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","“Gimi ga amariala kemi ngan gid irangrang ngan taiko toaine aea ado sangaul igegea pange. Ngan lailai sagogogo ngan ado toaiua, eine gimi toa ngada ne ga atotoi gid. ");
INSERT INTO bch_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Manta adoi singid kauteta ta asama ngan lemi atama aea kisinga toa rua oa ga aea tabalanga gadae pade. Akado bedaoa ngan gid luma kelede kelede toa aeanean ngan. ");
INSERT INTO bch_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ngan bong toaiua gimi ga alut ami sipsip ngan dinga ga kus ta aean toman ngan sabatnga ipaipai ga bret toa aea yis ienono ngan mao. ");
INSERT INTO bch_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Be irangrang ngan aean sipsip imedameda gargar mao, ga anadnad ngan eau mao pade. Be manta alut ngan dinga toman ngan ilabora ga iae ga ibage ga idanga sisid toa ngada oa iloleai. ");
INSERT INTO bch_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Be irangrang ngan gimi atnan ilia ga idio gaisala mao. Oangga ilia idio gaisala, anono ngan dinga ga imomout ga kus. ");
INSERT INTO bch_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Oangga aean, gimi manta anasi ga bedane: Apit ami malo ga akaukau ngan ami pus, ta adol lemi su ga akisi lemi toto lalalanga aea. Manta aean manmanae. Ngansa eine gau Maron leg eaneannga Pasova aea. ");
INSERT INTO bch_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Be ngan bong toaiua gau ga nala ngan gid luma kelede kelede togid Isip ta napamate gid gergeu lautabtabe arangaranga ga masilau led gergeu lautabtabe toa ngada oa. Toa bedaoa ta gau ga napanas gid deo togid Isip. Gau eine Maron. ");
INSERT INTO bch_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Be sing toa asama ngan lemi luma aea atama iaoa, eine ga iman kilala ngan gimi. Ta oangga napamukuru gid Isip led gergeu lautabtabe, eine ga nagera sing toa oa, ta nasapir ngan gimi, ta natnan gimi ga adio kemi. ");
INSERT INTO bch_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Rai ga rai ngan ado toaine, manta akado eaneannga toa ne ta matami nanan kadonga kapei toa gau Maron nakado. Be lemi gergeu ga tibutibumi tiuotot muriai ga ila, manta tinasnasi apu toa ne pade.” ");
INSERT INTO bch_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Idio ta Deo ikeo pade bedane, “Irangrang ngan ado lima ga rua, gimi ga aean bret toa aea yis ienono ngan mao. Be ngan ado toa imuga oa, manta atado saoa yis ienono lemi lumaeai ga iduaea. Be ngan ado toa imuga oa ga irangrang ngan ado lima ga rua, oangga sai ian annga eta toa yis ienono ngan, manta asuk ei ga ila aluai ngan gimi Israel. ");
INSERT INTO bch_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Be ngan ado toa imuga oa, ga pade ngan ado lima ga rua aea, gimi ga aluplup ngan soanga gau edag. Be irangrang ngan akado naurata eta ngan ado toa rua ne mao, ngansa gau leg ul ienono ngan. Naurata kelede mon arangrang ngan akado, eine ami annga aea kadonga. ");
INSERT INTO bch_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Gimi ga akado eaneannga ngan Bret aea Yis Ienono ngan Mao ne, ngansa gau nabada gimi iaoa kelede kelede Israel ami ta atnan Isip ngan ado toaine. Manta akado eaneannga kapei toa ne ngan rai ga rai ga ila, ta muriai lemi gergeu ga tibutibumi tikakado pade. ");
INSERT INTO bch_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Be lailai ngan taiko toaine aea ado sangaul igegea pange, ga ila irangrang ngan lailai ngan ado sangaul rua igegea ede, gimi manta aeanean bret toa aea yis ienono ngan mao. ");
INSERT INTO bch_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Ngan ado toa lima ga rua ne, irangrang ngan yis eta ienono lemi lumaeai mao. Be oangga eaba eta ngan gimi, mao eaba eta ngan tibur ede pade toa imamado rabu ngan gimi ian danga eta toa yis ienono ngan, manta asuk ei ga ila aluai ngan gimi Israel. ");
INSERT INTO bch_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ngan tibur isaoa gimi amamado ngan, aean annga eta toman ngan yis padam. Manta aean bret toa yis ienono ngan mao.” ");
INSERT INTO bch_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Idio ta Moses ibaba gid kapeipei Israel ad ga tinam pan ta ikeo pagid, “Gimi kelede kelede ala manamana ta asio ami sipsip mao meme eta, ta atotoi gid ga iman amingada lemi gergeu ami Pasova aea. ");
INSERT INTO bch_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Aparere singid kautede ga idae ngan tabla gereirei, ga kus ta abada abei isop iboga ta agasi ga idudunga ngan sing toa oa, ta asama ngan lemi atama aea kisinga toa rua oa ga aea tabalanga gadae pade. Be irangrang ngan gimi atnan lemi luma ga ala gaot mao ga irangrang ngan gaisala. ");
INSERT INTO bch_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Oangga Maron ila ngan luma kelede kelede ngan tibur Isip ngan raunga gid gergeu lautabtabe, ei ga igera sing toa ienono ngan lemi atama iaoa, ta ei ga isapir ngan gimi. Toa bedaoa ta ei ga ilongean anggelo pamatenga aea ga idudunga lemi lumaeai ngan pamatenga lemi gergeu lautabtabe mao. ");
INSERT INTO bch_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Gimi ga anasi apu toa ne ngan rai ga rai, be muriai lemi gergeu ga tibutibumi ga tinasnasi toa bedane pade. ");
INSERT INTO bch_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Be muriai oangga gimi ala amado ngan tano toa Maron iposa tautaunga pagimi ngan, manta anasnasi kadonga toa ne pade. ");
INSERT INTO bch_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Be oangga lemi gergeu tibeta gimi bedane, ‘Eaneannga toa ne ipu madongan?’ ");
INSERT INTO bch_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","tota akeo pagid bedane, ‘Gita takado eaneannga Pasova aea toa ne toman ngan aea masilau tenainga aea ga ila pan Maron, ngansa matada nanan ado toa ei irau gid Isip led gergeu lautabtabe ga timate, be isapir ngan gita Israel leda luma ta itnan gitaingada leda gergeu lautabtabe ga tadio kemi.’” Gid panua Israel tilongo posanga toa ne ta tikor aed ga tidol laborad ga isulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Ga kus ta tila tikado danga toa ngada oa mambe Maron irenren pan Moses ga Aron ngan. ");
INSERT INTO bch_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Be bong irabu Maron Deo irau gid gergeu lautabtabe toa ngada oa togid Isip ga timate. Ei ipamate maron kapei togid Isip ele gergeu lautabe ga gergeu lautabtabe togid panua edad kapeipei ga panua edad mao toa ngada oa ga irangrang ngan gergeu lautabtabe togid panua timamado ngan luma panasnga aea. Be ipamate gid masilau mud led gergeu lautabtabe pade. ");
INSERT INTO bch_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Maron kapei togid Isip toman ngan ele madidnga ga panua toa ngada oa Isip ad tidae bong ta tigera led gergeu lautabtabe timatemate, ta tikado tandanga kapei. Luma toa ngada oa Isip, eta aea sala ngan matenga mao. ");
INSERT INTO bch_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Ngan bong toaiua maron kapei togid Isip ibaba Moses ga Aron ga tinam pan ta ikeo, “Manmanae! Gimingada panua Israel adae ta atnan leg panua ga ala. Ala asoa ami Maron Deo ieda mambe abetabeta gau ngan. ");
INSERT INTO bch_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Abada lemi masilau mud mambe akeo ngan ta ala. Be manta araring ngan Deo ikado kemi ngan gau pade.” ");
INSERT INTO bch_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Idio ta gid Isip aoad isensen gid Israel ngan tnannga led tibur manmanae. Ta tikeo bedane, “Oangga atnan gai manmanae mao, eine gai toa ngada ne ga amate!” ");
INSERT INTO bch_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tota gid Israel tibada ad plaoa sapaean. Tibul yis ngan mao, be tidoldol ngan gid tabla ta tiluga ngan gid malo, ga kus ta tibisibisi ga tila. ");
INSERT INTO bch_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Be tibetabeta gid Isip ngan badanga sogonga silva ga gol ga barikia papau pagid mambe Moses ikeo pagid ngan. ");
INSERT INTO bch_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Ta gid Isip tilongo ta tibada danga sisid toa tibetabeta ngan pagid, ngansa Maron Deo ikado ga gid Isip lolod marum ngan gid Israel. Ngan kadonga toa bedaoa, gid Israel tibada danga sisid busa togid Isip sapaean. ");
INSERT INTO bch_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Idio ta gid Israel titnan tuanga Rameses, ta tilalala ga tila ngan tuanga Sukot. Gid ipom toa tilalala, arangaranga kekelegid dabad iuot bunoringring buno lima, bunoringring buno ede (600,000). Be tiuade gid taine ga gergeu mao. ");
INSERT INTO bch_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tibada led bulmakao ga sipsip ga meme ipu ga ipu ta tila toman ngan gid. Be panua busa padengada tila toman ngan gid pade. ");
INSERT INTO bch_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Be tinono bret ngan plaoa toa aea yis ienono ngan mao. Plaoa toa oa tibada Isip ga inam, be aea yis ienono ngan mao, ngansa gid Isip tipasensen gid, ta tirangrang ngan tikado kemi ad tamad mao. ");
INSERT INTO bch_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Gid Israel timamado Isip irangrang ngan rai buno pange sangaul tol (430). ");
INSERT INTO bch_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Be tutui ngan rai toa buno pange sangaul tol kus, tota Maron ele panua Israel iaoa kelede kelede titnan Isip ga tila. ");
INSERT INTO bch_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ngan bong toaiua Maron imata arar ta imariala kemi ngan gid Israel ta ibada gid ta titnan Isip ga tila. Tota rai ga rai ngan bong toaiua, gid Israel matad arar ngan soanga Maron ieda, ta matad nanan ele kadonga. ");
INSERT INTO bch_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Idio ta Maron ikeo pan Moses ga Aron bedane, “Alongo gid apu ngan eaneannga Pasova aea: “Eaba eta ngan tibur ede pade toa imamado rabu ngan gimi, irangrang ngan ian annga Pasova aea mao. ");
INSERT INTO bch_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Be oangga aol lemi paeaeanga aranga eta, ta ikeo ga ian annga Pasova aea, manta apalu ei, ga kus ta irangrang ngan ian toman ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Be panua timamado pagimi mole mao, ga panua tibokoboko pat pagimi, tirangrang ngan tian annga toa ne mao. ");
INSERT INTO bch_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Manta aean annga toa na gadudunga ngan lemi luma kelede kelede. Irangrang ngan abada imedameda eta ga ila gaot mao. Be irangrang ngan akor masilau toa oa ituatua eta mao. ");
INSERT INTO bch_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Ipom toa ngada ne Israel, manta tikado eaneannga toa ne. ");
INSERT INTO bch_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Be oangga eaba ngan tibur ede pade imamado rabu ngan gimi ta iuangga ian Maron ele eaneannga Pasova aea pade, manta ipalu ele arangaranga toa ngada oa. Oangga ikado bedaoa ga kus, ei ga irangrang ngan ian annga toa ne mambe gimi Israel pade. Be eaba eta toa ibada palunga mao, irangrang ngan ian annga toa ne mao. ");
INSERT INTO bch_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Apu toa lalaede ne ipakaranga gimi Israel ga gid panua ngan tibur ede pade timamado rabu ngan gimi.” ");
INSERT INTO bch_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Idio ta gid Israel toa ngada oa tikado mambe Maron irenren pan Moses ga Aron ngan. ");
INSERT INTO bch_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Be tutui ngan ado toaiua, Maron ibada gid iaoa kelede kelede togid Israel ta titnan Isip ga tila. ");
INSERT INTO bch_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Idio ta Maron ikeo pan Moses bedane, ");
INSERT INTO bch_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Gimi manta adol leg ul ngan lemi gergeu lautabtabe arangaranga toa ngada ne ta timan gau leg. Be manta adol leg ul pade toa bedaoa ngan gergeu lautabtabe togid lemi masilau mud.” ");
INSERT INTO bch_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Idio ta Moses ikeo pagid panua bedane, “Mugaeai gid Isip tipakala gimi ta akado naurata paeaeanga pagid. Be ngan Maron Deo iura, ei ibada gimi ta atnan tibur toa oa ga anam. Tota somisomi muriai, gimi manta matami nanan ado toaine. Be irangrang ngan aean annga eta toa aea yis ienono ngan mao. ");
INSERT INTO bch_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Gimi atnan Isip labone, ngan taiko Abip. ");
INSERT INTO bch_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mugaeai Maron iposa tautaunga pagid tibutibumi ngan ipan tano pagid. Eine tano togid Kenan ga It ga Amor ga Ivi ga Iebus. Be tano toa ne kemi tau ga imona kapei ta bon isul ga bulmakao itud isul iuotot ngan. Tota oangga ibada gimi ga ala ngan tano toa oa, manta akado eaneannga toa ne ngan Bret aea Yis Ienono ngan Mao. Rai ga rai ngan taiko toaine, manta akado eaneannga toa ne. ");
INSERT INTO bch_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Irangrang ngan ado lima ga rua, gimi ga aean bret toa aea yis ienono ngan mao. Be ngan ado lima ga rua aea, gimi ga akado eaneannga ngan soanga Maron ieda. ");
INSERT INTO bch_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Ngan ado toa lima ga rua ne, gimi ga aean bret aea yis ienono ngan mao. Annga eta toa yis ienono ngan, irangrang ngan ienono lemi lumaeai mao, ga ngan lemi tibur mao pade. ");
INSERT INTO bch_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ngan ado toaiua, akeo pagid lemi gergeu bedane, ‘Gita takado bedane ngansa matada nanan Maron ele kadonga ngan luanga gita ta tatnan Isip.’ ");
INSERT INTO bch_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Eaneannga toa ne ga iman kilala ngan matami nanan Maron ele kadonga, mambe kilala ede akaukau ga idae bagemiai mao laboramiai. Toa bedaoa ga matami nanan Deo ele apu ta aposaposa ngan. Ngansa Maron iura kapei ta ibada gimi ta atnan Isip ga anam. ");
INSERT INTO bch_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Manta anasnasi apu toa ne rai ga rai ngan ado toaine.” ");
INSERT INTO bch_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Moses ikeo pade bedane, “Maron ga ibada gimi ga ala ngan tano togid Kenan. Ei ga ipan tano toa oa ga iman ami, lalaede mambe iposa tautaunga pagimi ga pagid tibutibumi mugaeai ngan. ");
INSERT INTO bch_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Be oangga ibada gimi ga ala amado toa eoa ga kus, manta adol lemi gergeu lautabtabe arangaranga toa ngada ne ga tidae Maron ibageai, ngansa ei idol ul ngan gid. Be idol ul pade ngan gid gergeu lautabtabe togid lemi masilau mud, ngansa gid timan Maron ele. ");
INSERT INTO bch_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Be manta atenai sipsip ede ngan patutuinga ul toa idol ngan lemi donki ele gergeu lautabe. Be oangga tinimi ngan tenainga sipsip ngan patutuinga donki toa oa aea ul mao, manta akor donki toa oa igagal. Be manta akado tenainga ede pade ngan patutuinga lemi gergeu lautabtabe arangaranga ad ul. ");
INSERT INTO bch_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Be muriai, oangga lemi gergeu tibeta gimi ta tikeo, ‘Kadonga toa ne ipu madongan?’ ta akeo pagid, ‘Mugaeai gid Isip tipakala gita ta takado naurata paeaeanga pagid. Be Maron iura kapei ta ibada gita ta tatnan tibur toa oa ga tanam. ");
INSERT INTO bch_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Be maron kapei togid Isip ilolo matua ga ipaki itanga ta ilongean gita ga tala mao, tota Maron Deo ipamate gid gergeu lautabtabe toa ngada oa togid Isip. Be ipamate gid gergeu lautabtabe togid masilau mud pade. Ngan ipu toaine gita tarau gid gergeu lautabtabe togid masilau mud ta timan tenainga ga ila pan Maron. Be takado tenainga ede pade ngan patutuinga leda gergeu lautabtabe ad ul. ");
INSERT INTO bch_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Gita tanasi kadonga toa ne ta matada nanan Maron Deo iura ngan badanga gita ta tatnan tibur Isip ga tanam. Kadonga toa ne eine mambe kilala ede takaukau ga idae bagedai ga laboradai ngan papeinga matada ngan ele kadonga toa ne.’” ");
INSERT INTO bch_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Maron kapei togid Isip ilongean gid Israel ta tila ga kus, be Deo ibada gid ga tinasi edap aea bolobolo toa ila labiai ngan tibur Pilistia oa mao. Ngansa ikeo iloleai bedane, “Ngan kado ta tigera alu ede pade tikado paraunga pagid, ta tipul lolod ta tiluagid mulian ga tila Isip.” ");
INSERT INTO bch_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tota Deo ibada gid ta timalele ngan tibur modamodanga ta tinasi edap ila ngan tad Singsingia. Be gid Israel tibada danga sisid paraunga aea pade ta titnan tibur Isip ta tilalala ga tila. ");
INSERT INTO bch_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Be Moses ibada Iosep ituatua pade ta tila, ngansa mugaeai Iosep irenren pagid Israel ta tiposa tautaunga pan, ta ikeo, “Muriai Deo ga ilua gimi ta ibada gimi ga atnan Isip. Be ngan ado toaiua, manta abada tuatuag ga ila toman ngan gimi pade.” ");
INSERT INTO bch_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Idio ta gid Israel titnan tuanga Sukot ta tila tirau saupu ngan tibur Etam. Tibur toa oa digedige ngan tibur modamodanga. ");
INSERT INTO bch_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Be ado ga ado, Maron Deo imamado gadudunga ngan laulau mamarae ede ta imugamuga ngan gid ga ipasolan gid ngan edap. Be bong ga bong imamado gadudunga ngan dinga mamarae ede ta itaratara gid. Toa bedaoa ta tirangrang ngan tilalala bong ga ado. ");
INSERT INTO bch_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ado somisomi laulau toa oa ilalala ga imugamuga ngan gid, be somisomi bong, dinga toa oa imugamuga ngan gid pade. ");
INSERT INTO bch_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Idio ta Maron ikeo pan Moses bedane, ");
INSERT INTO bch_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Keo pagid Israel ta tiluagid mulian ta tirau saupu boloma tad matai ngan tuanga Piairot toa rabu ngan tuanga Mikdol ga tad Singsingia, iadag ngan tuanga Balsepon. ");
INSERT INTO bch_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Be maron kapei togid Isip ga ikeo iloleai bedane, ‘Gid Israel tilalala mangamanga alele ngan tibur toa oa, be led edap eta ngan tnannga tibur toa oa mao, ngansa tibur modamodanga ipakala gid.’ ");
INSERT INTO bch_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Be gau ga nakado ga maron kapei togid Isip ilolo matua ga iparpar maitne, ta ei ga ilado tatan gid. Be gau ga naeasal ei ngan paraunga, toman ngan ele panua paraunga ad. Be ngan kadonga toa ga nakado, eine ga panua tisoa gau edag. Ta gid Isip ga tiuatai kemi mambe gau eine Maron.” Io, tota gid Israel tinasi Moses ele posanga toa oa. ");
INSERT INTO bch_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Be maron kapei togid Isip ilongo posanga mambe gid Israel tiaoa ga tila, tota ei toman ngan ele madidnga tipul lolod mulian ta lolod paeamao ngan gid Israel ta tikeo, “Ikamado ga talongean gid Israel ga tila? Labone sapadua ga tikado leda naurata?” ");
INSERT INTO bch_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Tiposa bedaoa ga kus ta maron kapei togid Isip ibada ele karis ta ibaba ele panua paraunga ad. ");
INSERT INTO bch_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Be ibada ele karis kemikemi paraunga aea buno lima buno ede (600), toman ngan gid karis paraunga aea toa ngada oa Isip, be ele madidnga kelede kelede tiladlado ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Be Maron Deo ikado ga maron kapei togid Isip ilolo matua ga iparpar maitne, ta tilado tatan gid Israel. Gid Israel toa oa tilalala ga titnan Isip be timataud gid Isip mao. ");
INSERT INTO bch_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ta gid Isip led os ga karis paraunga aea ga karis itamatama ga panua paraunga ad padengada tilado tatan gid Israel ta tipaboloma led saupu toa boloma tad matai ngan tuanga Piairot, iadag ngan tuanga Balsepon. ");
INSERT INTO bch_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Maron kapei togid Isip toman ngan ele panua tiladlado ga tingata gid Israel, be gid Israel matad idae, ta tigera gid Isip ru ga ru ga per. Tota timataud kapei ta tiansaban ga ila pan Maron. ");
INSERT INTO bch_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Ta tikeo pan Moses bedane, “Eao kamado bada gai ga anam ngan tibur modamodanga toa ne? Eao oangga tibur Isip aea denga busa mao, ta bada gai ga anama amate ngan tibur modamodanga toa ne? Kemi ngan gai amado Isip ga amate. ");
INSERT INTO bch_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Be gita tamamado Isip maitne, ta gai akeo pago bedane, ‘Tnan gai ga adio. Kemi ngan gai aman paeaeanga sapaean togid Isip.’ Be paeamao ngan gai amate ngan tibur modamodanga toa ne.” ");
INSERT INTO bch_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Be Moses ikeo pagid panua, “Amataud mao. Amadid matua ta agera danga toa Maron ga ikado ngan badanga gimi mulian labone. Ngansa gid panua Isip toa labone agera, eine muriai ga agera gid pade mao. ");
INSERT INTO bch_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Alongo. Maron ga iparau ala ngan gimi. Be gimi ga amumun ga amadmadid.” ");
INSERT INTO bch_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ga kus ta Maron ikeo pan Moses bedane, “Eao kamado tang ga inam pagau? Keo pagid Israel ta tidae ga tila. ");
INSERT INTO bch_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Soa lem toto lalalanga aea ga idae ta gaga ga ingata tad. Tota tad ga imapoga ga iman rua, ta gid Israel ga tilalala ngan tano mamasa ta tiuore ga tila iadag. ");
INSERT INTO bch_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Be ega, gau ga nakado ta gid Isip lolod matua ta tiparpar ngan nasinga gid. Be gau ga naparau pan maron kapei togid Isip toman ngan ele panua paraunga ad ga led karis ga gid karis itamatama, ta naeasal gid. Ngan leg kadonga toa ne, gid panua ga tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Be oangga naeasal maron kapei togid Isip ga ele karis ga gid karis itamatama toa bedaoa, eine gid Isip ga tiuatai kemi mambe gau eine Maron.” ");
INSERT INTO bch_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Io, anggelo ton Deo toa imugamuga ngan gid Israel led panua paraunga ad, tota ipul ei mulian ta ila imadid muriai ngan gid. Be laulau mamarae toa ilalala ga imugamuga ngan gid, tota ipul ei mulian pade ta ila imadid muriai ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ta ila imadid rabu ngan gid panua paraunga ad togid Israel ga togid Isip. Ngan bong dodol toaiua laulau kapei toa oa ikado dodom kapei ila pagid Isip, be tibur meremere ila pagid Israel. Tota gid Isip tirangrang ngan tila boloma pagid Israel mao ga irangrang ngan gaisala. ");
INSERT INTO bch_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Idio ta Moses isoa ibage ga idae ta igaga ga ingata tad, ta Maron ikado ga rai kapei iuot ado ele parangai ga inam ta ipalua tad irangrang ngan gaisala. Be tad imapoga ga iman rua, ta tano gadio madaoan iloleai, tota imamasa ga iuot masaeai. ");
INSERT INTO bch_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Ta gid Israel tilalala ga tiuore iadag ngan tano mamasa. Be tad iuot mambe kali imadmadid led edap isaleai iadag ga iadag. ");
INSERT INTO bch_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Be gid Isip tilado tatan gid, ta maron kapei Isip aea ele os ga karis ga gid karis itamatama toa ngada oa tinasi gid ga tila rabu ngan tad toa oa. ");
INSERT INTO bch_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Gaga iuangga itakai, be Maron imamado rabu ngan laulau mamarae ga dinga, ta imata isulug pagid panua paraunga ad togid Isip ta ipabuobuo laborad ga timangamanga. ");
INSERT INTO bch_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Ta ikado ga led karis aed tos ga tos, ta tirangrang ngan tiladlado kemi mao. Tota gid Isip tikeo, “Manmanae! Tala aluai ngan gid Israel. Ad Maron iparau ala ngan gid ga inam pagita.” ");
INSERT INTO bch_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Ga kus ta Maron ikeo pan Moses bedane, “Soa bagem ga idae ta gaga ga ingata tad, ta tad ga krau ga isulug ta irobi gid Isip toman ngan led os ga karis ga gid karis itamatama.” ");
INSERT INTO bch_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Io, gaga itakai ta Moses isoa ibage ga idae ta igaga ga ingata tad. Tota tad krau ga isulug mulian imuliai. Gid Isip tigera ta tiuangga tiaoa ngan, be tirangrang mao, ngansa Maron itado gid ga tidudunga tad iloleai. ");
INSERT INTO bch_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Be tad ilele mulian ta irobi gid karis ga gid karis itamatama ga gid panua paraunga ad toa ngada oa ton maron kapei Isip aea. Gid Isip toa tinasi gid Israel ga tila tad irabuiai oa, eta ngan gid iluai mulian mao. Toa ngada oa timatemate ga kus. ");
INSERT INTO bch_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Be gid Israel tilalala ga tiuore ga tila iadag ngan tano mamasa. Be tad iuot mambe kali imadmadid led edap isaleai iadag ga iadag. ");
INSERT INTO bch_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Ngan ado toaiua, Maron ibada mulian gid Israel pagid Isip bagedeai. Be gid Israel tigera gid Isip timate ga patid ienono labiai. ");
INSERT INTO bch_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Gid Israel tigera Maron iasal gid Isip ngan iura kapei toa bedaoa, ta timataud ga tilolon ngan Maron, be lolod matua ngan ei ga ngan ele paeaeanga Moses pade. ");
INSERT INTO bch_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Ngan ado toaiua, Moses gisingada gid Israel tikado baunga ga oaine ila pan Maron. “Gau ga nakado baunga ila pan Maron, ngansa ei iasal aea miri itamatama, ta ieda idae gadae tau. Gid os toman ngan os itamatama, itado gid ga tisulug tadiai. ");
INSERT INTO bch_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Maron ipamatua gau ta urag kapei, ta nakado baunga toa ne ngan ei. Ei ibada gau mulian, ta gau ga nasoa ieda. Ei gau ag Deo ga Deo ton tamag pade, ta gau ga nakado baunga ngan soanga ieda. ");
INSERT INTO bch_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Maron ei eaba paraunga aea ede toa iura kapei. Ei ieda Maron. ");
INSERT INTO bch_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Ei itado maron kapei Isip aea ele karis ga panua paraunga ad ga tisulug tadiai. Maron kapei togid Isip ele madidnga kemikemi tidal ngan tad Singsingia ga timate. ");
INSERT INTO bch_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tad kapei irobi gid, ta timadi ga tisulug madaoan iloleai mambe pat. ");
INSERT INTO bch_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","“O Maron, bagem oatai iura kapei tau ta ipasolan lem taranga. Maron, bagem oatai ipurum am miri itamatama ga kus. ");
INSERT INTO bch_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Eao mamado gadae tau ta easal gid panua toa tikado paraunga pago ta tado gid ga tisulug gadio. Eao lolom bake mambe dinga irarabal, ta nono am miri itamatama ga kus mambe purup imisimisi. ");
INSERT INTO bch_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Aoam uru iuso tad ta isum ga idae. Be ngalu kapeipei timadid tutui iadag ga iadag mambe kali. Ta tad kapei imadid matua toa madaoan iloleai oa. ");
INSERT INTO bch_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","“Am miri itamatama tikeo, ‘Gai ga abutatan gid ta aluku gid. Be gai ga apota alele led danga sisid kemikemi. Gai ga akere gai ngan led danga sisid kemikemi aea badanga. Gai ga anusi lemai didi paraunga aea ta apaeabu ngan gid ngan gai uramai.’ ");
INSERT INTO bch_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Be eao uso aoam uru pakelede, tota tad irobi gid. Ta timadi ga tisulug madaoan iloleai mambe pat. ");
INSERT INTO bch_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","“O Maron, Deo eta pade mambe eao mao. Eao kekelego tutui tau ta mamado gadae. Panua toa ngada ne timataud ngan eao ta tipakuru ngan go, be eao pamatala gid panua ngan lem uisinga kapeipei. ");
INSERT INTO bch_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Eao patutui bagem oatai, tota tano ipokakai ta ison gid. ");
INSERT INTO bch_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","“Be ngan lem kadonga lolo isat aea ga mata tutui aea, eao bada lem panua mulian ngan led naurata paeaeanga, ta eao madid ga mugamuga ngan gid. Ngan eao uram, eao ga pasolan gid ngan led edap, ta tilalala ga tila ngan tibur kemi toa eao sio ga iman lem. ");
INSERT INTO bch_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Be gid alu padengada toa tilongo ngan lem kadonga, timataud kapei ga tisamimi. Mataudnga kapei ga ibada gid Pilistia. ");
INSERT INTO bch_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Gid madidnga togid Idom ga timataud ta laborad imangamanga. Gid madidnga togid Moap ga tisamimi paeamao tau. Be gid panua Kenan ga timataud ta tiaoa alele. ");
INSERT INTO bch_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Gid toa ngada oa ga timataud ga lolod ede ga ede. Ngan eao bagem iura kapei, gid ga tisapun mao mambe pat, ga irangrang ngan lem panua tilalala ga tisapir ga tila. Maron, gid panua toa oa eao ol gid ga timan lem. ");
INSERT INTO bch_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","O Maron, gid mambe eao lem abei kemi ede toa earum dadangai. Ta eao ga bada gid ga tila timado kemi ngan lusi toa eao sio ga iman lem. Tibur toa oa, eao mulmulim ngan. Ngan eao bagem eao kado lem tibur madonga aea toa eoa. ");
INSERT INTO bch_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Maron, danga toa ngada ne ga idio eao bagemeai somisomi ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Ngan ado toaiua, maron kapei togid Isip ele panua paraunga ad ga led karis ga karis itamatama tinasi gid Israel ga tila rabu ngan tad kapei, be Maron Deo ikado ta tad iluai mulian ga irobi gid. Be gid Israel tilalala ga tila tad irabuiai ngan tano mamasa. ");
INSERT INTO bch_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ta ngan ado toaiua, Aron iliu Miriam, taine toa ibabada Deo iaoa, ibada ele golo ta gid taine tinasi ei ta tibada led golo pade ta titoltol. ");
INSERT INTO bch_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Ta Miriam ikado baunga ila pagid ga bedane: “Gimi abau ga ila pan Maron, ngansa ei iasal aea miri itamatama, ta ieda idae gadae tau. Gid os toman ngan os itamatama, itado gid ga tisulug tadiai.” ");
INSERT INTO bch_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Idio ta Moses ibada gid Israel ta titnan tad Singsingia ta tilalala ga tila ngan tibur modamodanga ieda Sur. Tilalala alele ngan tibur modamodanga irangrang ngan ado tol, be tigera eau eta mao. ");
INSERT INTO bch_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Ga kus ta tiuot ngan eau ede ngan tibur Mara, be tirangrang ngan tiun mao, ngansa imana paipai. Ngan ipu toaine tiuato tibur toa oa ieda Mara. ");
INSERT INTO bch_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tota gid panua tiririak ngan Moses ta tikeo, “Gai ga aun saoa?” ");
INSERT INTO bch_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Idio ta Moses iansaban ga ila pan Maron, ta Maron ipasolan ei ngan abei itul ede ienono. Moses ibada ta itado ga isulug eauiai. Tota eau toa oa imana iuot marilonga kemi, ta tirangrang ngan tiun. Toa eoa Deo idol apu edengada ngan gid tinasnasi, be itoba gid toa eoa, ngansa iuangga iuatai, gid ga tinasi ilinge, mao madongan? ");
INSERT INTO bch_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ta ikeo pagid, “Gau Maron Deo togimi. Oangga alongolongo lingeg ga akado kadonga tututui ngan gau matag ta alongo kemi leg apu toa ngada ne ga anasnasi, eine gid dibala papaeamao toa nakado ga iuot ngan gid Isip, eta ngan gid ga iuot ngan gimi mao ga mao tau. Ngansa gau Maron toa nakemikemi ami dibala.” ");
INSERT INTO bch_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ga kus ta tilalala ga tiuot ngan tibur Elim. Toa eoa eaumata sangaul igegea rua ienono ga abei det sangalima sangaul rua timadmadid. Tota gid Israel tirau saupu boloma ngan eau toa oa. ");
INSERT INTO bch_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Taiko rua muriai ngan gid Israel titnan Isip, ngan taiko toa oa aea ado sangaul igegea lima, gid Israel toa ngada oa titnan tibur Elim ta tilalala ga tila ngan tibur modamodanga ieda Sen. Tibur toa oa ienono rabu ngan tibur Elim ga lusi Sainai. ");
INSERT INTO bch_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Ngan tibur modamodanga toa oa gid Israel toa ngada oa tiririak ga ila pan Moses ga Aron. ");
INSERT INTO bch_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Gid Israel tikeo pagisirua bedane, “Gai aoangga kemi ngan Maron ipamate gai motean ngan tibur Isip. Toa eoa lemai ulo iuon ngan masilau imedameda ta gai aeanean annga irangrang ngan lemai kimnga. Be gimirua abada gai ga anama ngan tibur modamodanga toa ne ta aoangga apamate gai toa ngada ne ngan pitoro.” ");
INSERT INTO bch_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Idio ta Maron ikeo pan Moses bedane, “Ega, gau ga nakado ta annga itaptap mariambai ga isulug mambe aoara. Ngan ado kelede kelede gid panua ga tiuot ta tila tigou annga toa oa irangrang ngan ado kelede aea. Ngan kadonga toa ne, eine ga natoba gid ta naoatai, gid ga tinasi lingeg, mao madongan? ");
INSERT INTO bch_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Be ngan ado lima ga ede aea, gid ga tibada annga irangrang ngan ado rua, ta tinono motean ga ienono.” ");
INSERT INTO bch_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Tota Moses ga Aron tikeo pagid Israel toa ngada oa bedane, “Labone lailai gimi ga aoatai kemi mambe Maron kekelen ibada gimi ta atnan Isip. ");
INSERT INTO bch_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Gimi aririak ga ila pan Maron, ta ei ilongo na. Tota sabale gaisala gimi ga agera Maron ele taranga kapei. Ikamado ga aririak ga inam pagai? Gairua panua sapaean.” ");
INSERT INTO bch_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Be Moses ikeo pade bedane, “Oangga Maron ipan ami masilau lailai ga ipan ami annga gaisala ga irangrang ngan lemi kimnga, eine gimi ga aoatai mambe ei kekelen ibada gimi ta atnan Isip. Ngansa ei ilongo gimi aririak ga ila pan. Gairua panua sapaean. Gimi aririak ga inam pagai, be tautaunga aririak ga ila pan Maron.” ");
INSERT INTO bch_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ga kus ta Moses ikeo pan Aron, “Keo pagid panua Israel toa ngada ne bedane, ‘Gimi anam amadid boloma pan Maron, ngansa ei ilongo lemi ririaknga na.’” ");
INSERT INTO bch_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Io, Aron iposaposa maitne pagid panua Israel, be matad ila ngan tibur modamodanga ta tigera Maron ele taranga kapei iuot laulauiai ga isulug. ");
INSERT INTO bch_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ta Maron ikeo pan Moses bedane, ");
INSERT INTO bch_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Gau nalongo gid Israel tiririak ga inam pagau. Tota keo pagid, ‘Lailai sagogogo gimi ga aean masilau imedameda, be gaisala gimi ga aean annga irangrang ngan lemi kimnga. Toa bedaoa ta gimi ga aoatai kemi mambe gau eine Maron Deo togimi.’” ");
INSERT INTO bch_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Io, ngan lailai toaiua gid man kaeau tiroro ga tisulug ta tiuon ngan led saupu. Be gaisala ngan ado sae, namul bong aea isulug ta ikado led saupu idigedige ga iburisinga. ");
INSERT INTO bch_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Be namul toa oa imamasa ga ila ga kus ta tigera gid danga gereirei busa ienono tano igogoeai mambe mama aea kota be malamalan. ");
INSERT INTO bch_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ta gid Israel tigera ta tiposa pol ngan gid bedane, “Danga ne saoa?” Ngansa tigera danga eta bedaoa mugaeai mao. Be Moses ikeo pagid bedane, “Eine ami annga toa Maron ibada ga ila pagimi. ");
INSERT INTO bch_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Maron iposa matua pagita bedane, ‘Gimi kelede kelede ga abada annga toa ne irangrang ngan gimi aean. Anonoi ngan ulo gereirei kelede kelede ta apota ga irangrang ngan lemi panua pida ngan palata ede.’” ");
INSERT INTO bch_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Idio ta gid Israel tikado toa bedaoa mambe Moses ikeo pagid ngan. Panua edengada tigou busa, be panua padengada tigou busa tau mao. ");
INSERT INTO bch_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ga kus ta tinonoi ngan gid ulo gereirei, ta tigera mambe gid panua toa tigou busa, eine gid ad ikaranga ngan gid, be gid panua toa tigou busa tau mao, gid ad pade ikaranga ngan gid. Gid toa ngada oa tibada ga irangrang ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ta Moses ikeo pagid, “Irangrang ngan gimi adol annga ilia eta ga idio gaisala mao.” ");
INSERT INTO bch_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Be mao. Panua edengada tilongo Moses ilinge mao ta tidol annga ilia ga idio gaisala. Be tigera iuon ngan motamota gereirei ga iuad paeamao. Tota Moses ilolo bake ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Gaisala ngan ado ga ado, panua toa ngada oa tigou annga toa oa ga irangrang ngan gid. Be oangga ado idae ta tibur oanaoana, annga isaoa ienono tanoeai maitne, tota ado inono ga isapa. ");
INSERT INTO bch_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Be ngan ado lima ga ede aea, tigou busa tede irangrang ngan ado rua. Tigou irangrang mambe ulo gereirei rua ngan panua kelede kelede. Be gid madidnga togid Israel tila tipalongo Moses ele toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Ta Moses ikeo pagid, “Maron iposa matua pagita ga bedane, ‘Sabale eine Ado Earainga aea ton Maron. Ei idol ele ul ngan ado toa oa. Tota gimi ga anono annga toa ngada ne labone. Gimi atuba ngan dinga, mao oangga akim, anono ngan ulo. Be adol ami annga ilia iadag iman sabale aea.’” ");
INSERT INTO bch_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Io, tota tidol ad annga ilia iadag ga idio iman sabale aea, mambe Moses ikeo pagid ngan. Be annga toa oa ibudabuda mao, ga aea motamota eta mao pade. ");
INSERT INTO bch_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Ta ngan ado sae Moses ikeo pagid, “Ami annga ilia iadag, tota aean labone. Ngansa labone eine Ado Earainga aea ton Maron. Irangrang ngan gimi aot ngan annga eta toa ne labone mao. ");
INSERT INTO bch_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Gimi ga agou annga toa ne irangrang ngan ado lima ga ede, be ngan ado lima ga rua aea, gimi ga aot ngan eta mao, ngansa eine Ado Earainga aea.” ");
INSERT INTO bch_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Be mao. Ngan ado lima ga rua aea, panua edengada tiuot ga tila ngan gounga annga toa oa, be tiuot ngan eta mao. ");
INSERT INTO bch_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Ta Maron ikeo pan Moses bedane, “Ngeda be gimi atnan lemi tanga balbal ta alongo ga anasi lingeg? ");
INSERT INTO bch_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Alongo kemi. Gau Maron Deo nadol Ado Earainga aea ngan luanga gimi. Ngan ipu toaine, ngan ado lima ga ede aea, napan ami annga irangrang ngan ado rua. Be ngan ado lima ga rua aea, gimi toa ngada ne manta adio lemi saupuiai. Irangrang ngan eaba eta iuot ga ila gaot ngan saupu mao.” ");
INSERT INTO bch_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Tota gid panua tiaragid ngan ado lima ga rua aea. ");
INSERT INTO bch_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Gid panua Israel tiuato annga toa oa ieda mana. Mana toa oa bodbode be gereirei mambe abei korianda ipuapua. Be imana mambe mama tisama ngan bon isul. ");
INSERT INTO bch_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Be Moses ikeo, “Maron iposa matua pagita ga bedane, ‘Abada ulo kakaueta iuon ngan mana ta adol kemi ga ienono ngan lemi gergeu ga tibutibumi tigera muriai ga ilalala ga ila. Toa bedaoa ta tiuatai ngan annga toa napan pagimi ngan tibur modamodanga muriai ngan nabada gimi ta atnan Isip.’” ");
INSERT INTO bch_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ta Moses ikeo pan Aron, “Bada ulo kakaueta ta nonoi ngan mana. Ga kus ta dol ga idio Maron imatai, ta ienono ngan pasolannga pagid tibutibuda muriai ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Io, Aron ikado mambe Maron ikeo pan Moses ngan, ta idol mana toa oa ga idio boloma ngan korol apu aea, ta imulmuli toa eoa. ");
INSERT INTO bch_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Gid Israel tianean mana ga irangrang ngan rai sangaul pange. Be ngan rai toa sangaul pange oa kus, tila tiuot ngan tibur kapei Kenan aea but ta timamado kemi ga tianean annga dadangai. ");
INSERT INTO bch_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","(Ngan ado toaiua, gid Israel tiuadoade annga ngan gid ulo gereirei ga kapeipei. Gid ulo kapeipei irangrang ngan titok ulo gereirei sangaul ga idudunga ngan.) ");
INSERT INTO bch_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Gid panua Israel toa ngada oa titnan tibur modamodanga ieda Sen, ta tilalala ga tila ngan tibur ga tibur mambe Maron ikeo pagid ngan. Ga kus ta tirau saupu ngan tibur ieda Repidim. Be toa eoa eau eta ienono ngan gid panua tiun mao. ");
INSERT INTO bch_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tota tiririak ga ila pan Moses ta tikeo, “Bada eau ga inam aun!” Be Moses ikeo, “Ikamado ga aririak ga inam pagau? Gimi aoangga atoba Maron iura ngan saoa?” ");
INSERT INTO bch_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Be gid panua marumian gid kapei tau, ta tiririak ga ila pan Moses ta tikeo, “Eao kamado bada gai ta atnan Isip? Eao kim gaingada lemai gergeu ga masilau mud marumian gai ga amate?” ");
INSERT INTO bch_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Idio ta Moses iansaban Maron ta ikeo, “Eine ga nakado mado ngan gid panua toa ne? Teta pade ga tiraurau gau ngan pat ga namate.” ");
INSERT INTO bch_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Ta Maron ikeo pan Moses bedane, “Bada gid kapeipei etangada togid Israel ta gimingada alalala ga amuga ngan gid panua. Be bada lem toto lalalanga aea toa mugaeai eao bal eau Nail ngan, ta gimingada ala. ");
INSERT INTO bch_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Be ega, gau ga namadid matameai, gadae ngan pat kapei ngan lusi Orep. Ta eao ga bal pat toa oa, ta eau ga ilele ga iuot, ta gid panua tiun.” Io, Moses ikado toa bedaoa ngan gid kapeipei Israel matad. ");
INSERT INTO bch_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Ta iuato tibur toa oa ieda rua bedane: Masa ga Meriba. Eine ngansa gid Israel tiposa malmal ga ila pan Moses ta tibeta, “Maron imamado rabu ngan gita, mao mao?” Be ngan kadonga toa bedaoa, titoba Maron iura. ");
INSERT INTO bch_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Idio ta gid Amalek tinam tikado paraunga pagid Israel ngan tibur Repidim. ");
INSERT INTO bch_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Ta Moses ikeo pan Iosua bedane, “Sio leda arangaranga etangada, ta gimingada ala aparau pagid Amalek sabale. Be gau ga nakikisi toto lalalanga aea ton Deo ta namadid gadae bereoeai.” ");
INSERT INTO bch_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Tota Iosua toman ngan gid panua paraunga ad togid Israel tiparau pagid Amalek, mambe Moses ikeo ngan. Be Moses ga Aron ga Ur tidae ga tila bereo ipaoeai. ");
INSERT INTO bch_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Somisomi oangga Moses isoa ibage ga idae, gid Israel tiasal gid Amalek ngan paraunga. Be oangga ibage isulug, gid Amalek tiasal gid Israel. ");
INSERT INTO bch_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Idio ta Moses ibage imamatenga, tota Aron ga Ur tibada pat ede ga inama, ta Moses idio imado ngan. Gisirua timadid iadag ga iadag boloma pan, ta tikisi ibage ga idae ta imulmuli ga irangrang ngan ado idil. ");
INSERT INTO bch_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Tota Iosua toman ngan gid Israel tiasal gid Amalek ngan paraunga, ta tipaeabu ngan gid ngan didi paraunga aea. ");
INSERT INTO bch_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ga kus ta Maron ikeo pan Moses bedane, “Bode posanga ga oaine ga idae ngan laulau ede, ngan gid panua matad nanan ga bedane, ‘Gau ga napamukuru gid Amalek, ta irangrang ngan gid panua matad nanan gid pade mao.’ Be eao ga palongo Iosua ngan posanga toaine pade.” ");
INSERT INTO bch_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Idio ta Moses ipagun popou tenainga aea ta iuato popou toa oa ieda bedane, “Maron ei mambe gau leg mirmir.” ");
INSERT INTO bch_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moses iuato ieda toa bedaoa ngansa ikeo, “Gid tigaga baged ngan paraunga ga ila pan Maron toa imamado ngan ele mul maron aea. Tota Maron ga ipaparau pagid Amalek ga led gergeu ga tibutibud ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Be Moses ilaoa Ietro, eaba tenainga aea ngan tibur Midian, ilongo ngan danga toa ngada oa Deo ikado ngan luanga Moses ga ele panua Israel. Be ilongo pade ngan saoa danga Maron ikado ngan badanga gid Israel ta titnan Isip. ");
INSERT INTO bch_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Be mugaeai Moses isula iadaoa Sipora toman ngan ele gergeu rua ga tila pan ilaoa Ietro ta tidio pan. ");
INSERT INTO bch_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","Moses ele gergeu toa rua oa, ede ieda Gersom, ngansa mugaeai Moses ikeo, “Gau eaba ngan tibur ede pade, be nanam namado ngan tano toa ne.” ");
INSERT INTO bch_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Be iuato ele gergeu ede pade ieda Elieser, ngansa ikeo, “Deo ton tamag, ei gau ag luanga. Ibada gau mulian, ta irangrang ngan maron kapei Isip aea ipamate gau mao.” ");
INSERT INTO bch_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Tota Moses ilaoa Ietro toman ngan Moses iadaoa ga ele gergeu rua tinam tiuot pan Moses ele saupuiai ngan tibur modamodanga boloma ngan lusi ton Deo. ");
INSERT INTO bch_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Be mugaeai Ietro iabalan posanga ga ila pan Moses bedane, “Gau laoam Ietro toman ngan adaoam ga lem gergeu rua aoangga anam pago.” ");
INSERT INTO bch_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Moses ilongo toa bedaoa ta idae ga ila iuot pan Ietro edapeai. Ta Moses ikor iae boloma pan. Ga kus ta ibusum ipapa. Tibeta pol gid ngan led madonga ga kus ta tidudunga Moses ele palatai. ");
INSERT INTO bch_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Ta Moses ininipu pan ilaoa ngan danga toa ngada oa Maron Deo ikado ngan maron kapei togid Isip ga ele panua. Be ininipu pade ngan gid danga kulupulupu iuotot ngan gid Israel toa edapeai, be somisomi Maron ilualua gid ga ibada gid mulian. ");
INSERT INTO bch_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Be Ietro itin igelgel kapei ngan longonga danga kemikemi toa ngada oa Maron ikado ngan badanga gid Israel mulian pagid Isip bagedeai. ");
INSERT INTO bch_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Ta Ietro ikeo, “Tasoa Maron ieda, ngansa ei ibada gimi mulian pan maron kapei Isip aea ga ele panua bagedeai, ta atnan lemi naurata paeaeanga pagid. ");
INSERT INTO bch_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Labone naoatai kemi mambe Maron Deo iasal gid deo toa ngada oa, ngansa ei ipanas gid panua tanga balbal ad toa tiuangga tikado paeamao ngan ele panua Israel.” ");
INSERT INTO bch_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Io, ga kus ta Moses ilaoa Ietro idol masilau ede ga idae dingaeai, ta dinga inono ga imomout ga kus ta iman ele tenainga ga ila pan Deo. Be ikado tenainga padengada ga ila pan Deo pade. Ta Aron toman ngan gid kapeipei Israel ad toa ngada oa tila tian annga toa Deo imatai oa toman ngan Moses ilaoa Ietro. ");
INSERT INTO bch_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Ngan ado sae Moses idio imado ngan patutuinga posanga togid panua Israel. Be panua busa tinam pan ga timadmadid ga tisanga ei gaisala ga irangrang ngan lailai. ");
INSERT INTO bch_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Be Moses ilaoa Ietro igera danga toa ngada oa Moses ikakado ngan luanga gid panua ta ikeo, “Kadonga toa eao kakado ngan gid panua toa ne madongan? Eao kamado kekelego patutui posanga ngan gid? Gera, gid panua toa ne timadmadid be tisangasanga go gaisala ga irangrang ngan lailai.” ");
INSERT INTO bch_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Ta Moses ikeo pan ilaoa bedane, “Gid panua tinam pagau ngansa tiuangga tiuatai ngan Deo ele kimnga ta tinasi. ");
INSERT INTO bch_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Somisomi oangga panua rua aoad parau, tibada gid ga tinam pagau, ta gau nakeo ga sai ngan gisirua itutui, ta napaoatai gid ngan gid apu ton Deo.” ");
INSERT INTO bch_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Be Moses ilaoa ikoli ele posanga bedane, “Edap toa eao nasi ngan kadonga naurata toa ne, eine kemi mao. ");
INSERT INTO bch_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Naurata toa ne ikulupu tau ngan eao kekelego kado. Oangga eao kekelego kado, eine gimingada panua toa ngada ne ga atolatola. ");
INSERT INTO bch_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Be longo ga inam pagau, ta napanasi go ngan edap kemi ede ngan kadonga naurata toa ne. Ta Deo ga imamado toman ngan eao. Eao ga man gid panua bebed ta raring ga ila pan Deo ngan patutuinga led aoa parau. ");
INSERT INTO bch_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Eao ga pananale gid ngan Deo ele apu, ga paoatai gid ngan edap isaoa kemi ngan tinasi ga saoa naurata kemikemi tikakado. ");
INSERT INTO bch_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Be manta sio panua kemikemi oatainga ad etangada rabu ngan gid Israel toa ngada oa, ta timan madidnga ga timugamuga ngan gid panua bunoringring, ga padengada timuga ngan panua buno, ga padengada timuga ngan panua sangalima, ga padengada timuga ngan panua sangaul. Gid madidnga toa ne, manta tilolon ngan Deo, ga tarangrang ngan taeadi gid, be manta tinid ngan panua tiparumrum gid ngan pat mao. ");
INSERT INTO bch_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Gid ga tipatutui posanga pagid panua somisomi, be oangga posanga eta kapei tau ngan gid, eine ga tilongean ga ila pago. Gid kekelegid ga tipatutui posanga gereirei. Toa bedaoa ta tilualua eao ngan naurata toa ne, ta eao lem naurata malamalan. ");
INSERT INTO bch_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Oangga eao nasi bedane, be Deo ilolo kelede ngan pade, eao ga madid matua ngan naurata toa ne, be gid panua ga lolod itarui ta tiluagid mulian.” ");
INSERT INTO bch_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Io, Moses ilongo ilaoa ele posanga ta ikado danga toa ngada oa mambe ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Ei isio gid panua kemikemi oatainga ad rabu ngan gid Israel toa ngada oa, ta idol gid ga timan madidnga ngan gid panua bunoringring, ga panua buno, ga panua sangalima, ga panua sangaul. ");
INSERT INTO bch_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Gid tipatutui posanga ngan gid panua somisomi. Ta gid kekelegid tipamate posanga gereirei. Be gid posanga kapeipei, tilongean ga ila pan Moses. ");
INSERT INTO bch_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ga kus ta Moses ital ilaoa Ietro ga ila edapeai, ta iluai mulian ga ila ele tuangai. ");
INSERT INTO bch_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Taiko tol muriai ngan gid Israel titnan Isip, ngan ado imuga ngan taiko toa oa, gid Israel tiuot ngan tibur modamodanga ieda Sainai. ");
INSERT INTO bch_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Titnan tibur Repidim ga kus ta tila tiuot toa eoa. Ta gid Israel tirau saupu ngan tibur modamodanga boloma lusi Sainai isaleai. ");
INSERT INTO bch_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Idio ta Moses idae ga ila pan Deo. Be Maron imamado lusiai ta ibaba ga ila pan Moses ta ikeo, “Eao ga palongo Iakop itubtub toa gid panua Israel ga bedane, ");
INSERT INTO bch_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Gimi agera saoa danga nakado ngan gid Isip. Ga pade gimi agera nabisi gimi mambe man abalem ibisi ele gergeu ngan ibagbage, ta nabada gimi ga anam ta adio pagau. ");
INSERT INTO bch_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Be labone, oangga gimi alongo lingeg ga anasi kemi posanga toa narau toman ngan gimi, eine gimi ga aot leg panua. Tautaunga, gid alu toa ngada ne tanoeai gau togau, be gau ga nasio gimi, ta aot leg panua toa lolog ikimkim. ");
INSERT INTO bch_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Gimi ga amado gau bagegeai ta akakado leg naurata ngan luanga gid panua ta lolod matua ngan gau. Gau leg ul ga ienono ngan gimi, ta gimi aot leg panua tututui rabu ngan gid alu padengada.’ Be Moses, eao ga bada leg posanga toa ne ga ila pagid Israel.” ");
INSERT INTO bch_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Tota Moses iluai mulian ga ila ta ipaluplup gid kapeipei Israel ad ta ipalongo gid ngan posanga toa ngada ne Maron ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Ta gid panua linged kelede ta tikeo, “Gai ga akado danga toa ngada ne mambe Maron ikeo ngan.” Tiposa bedaoa ga kus ta Moses ibada led posanga ga ila pan Maron. ");
INSERT INTO bch_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ta Maron ikeo pan Moses bedane, “Ega, gau ga nanam pago ngan laulau kapei aea molomolo, ta gid panua ga tilongo gau naposaposa toman ngan eao. Toa bedaoa ta somisomi gid ga tiadi go.” Ga kus ta Moses ikeo pan Maron ngan gid panua led posanga. ");
INSERT INTO bch_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Ta Maron ikeo pan Moses, “La pagid panua ta dol leg ul ngan gid labone ga sabale. Ta keo pagid ngan tinasi kadonga ngan pasolannga mambe leg ul ienono ngan gid ga timum led danga sisid, ");
INSERT INTO bch_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ta tikemi gid mulian ngan ado tol aea. Ngansa ngan ado tol aea, gid ga tigera gau Maron nasulug ga nanam ta nadio ngan lusi Sainai. ");
INSERT INTO bch_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Be eao ga dol but ga ibalil ngan lusi ta pabib led bedane, ‘Agabit kemi. Ngan kado ta alaputian but toa ne ta adae ga ala lusiai. Be anam boloma lusi ipuiai mao pade. Ngansa oangga sai ilaputian but toa ne, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Be irangrang ngan gimi arau ei ngan bagemi mao. Manta araurau ei ngan pat, mao agal ei ngan tutupi. Oangga eababa mao masilau eta ilaputian but toa ne, manta apamate ei toa bedaoa. Be oangga gimi alongo taule itang, tota adae ga anam lusiai.’” ");
INSERT INTO bch_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Io, Moses isorir lusiai ga isulug, ta ila pagid panua ta idol Deo ele ul ngan gid, ta ikeo ga tinasi kadonga ngan pasolannga mambe Deo ele ul ienono ngan gid ta timum led danga sisid pade. ");
INSERT INTO bch_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Ta ikeo pagid, “Manta akemi gimi mulian ngan ado tol aea. Be aenono toman ngan gid taine mao.” ");
INSERT INTO bch_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Io, gaisala ngan ado tol aea, gla isamil ga pelaka itang, be laulau kapei iluga lusi. Be taule itang kapei tau, ta gid panua toa saupuiai oa timataud kapei ga tisamimi. ");
INSERT INTO bch_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Idio ta Moses ila imuga ngan gid panua ta tila timadid lusi ipuiai, ngansa teta pade tilup toman ngan Deo. ");
INSERT INTO bch_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Be Maron imamado ngan dinga kapei ta isulug ga inam ngan lusi Sainai, be basu kapei puk ga idae ta iluga lusi. Basu toa oa kapei mambe suksuknga kapei ede aea basu. Be lusi isamimi paeamao tau. ");
INSERT INTO bch_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Taule itang ga ila kapei ga kapei tau. Ga kus ta Moses iposa, ta Deo ilinge ikoli ele posanga. ");
INSERT INTO bch_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Be Maron isulug ta imadid lusi Sainai ilaborai. Ta ibaba Moses ta idae ga ila pan toa lusi ilaborai oa. Tota Moses idae ga ila, ");
INSERT INTO bch_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ta Maron ikeo pan, “Sulug ga la ta kado posanga matua pagid panua ngan tilaputian but toaine mao. Ngan kado ta tigera gau Maron ta gid busa timate. ");
INSERT INTO bch_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Be gid panua tenainga ad pade, manta tilolon ngan ul toa nadol ngan gid ta tinasi kadonga ngan pasolannga mambe leg ul ienono ngan gid. Ngan kado ta napaeabu ngan gid.” ");
INSERT INTO bch_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Ta Moses ikeo pan Maron, “Be gid panua tirangrang ngan tidae ga tinam lusiai ne mao. Ngansa eao posa matua pagai ta adol but ga ibalil ngan lusi Sainai. Toa bedaoa ta tilolon ngan lem ul toa ne.” ");
INSERT INTO bch_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Be Maron ikeo pan, “Sulug ga la ta bada Aron ta gimirua adae ga anam pagau. Be irangrang ngan gid panua tenainga ad ga gid ipom tilaputian but ta tidae ga tinam pagau mao. Ngan kado ta napaeabu ngan gid.” ");
INSERT INTO bch_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Io, tota Moses isulug ga ila ta ipalongo gid ngan posanga toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ta Deo ikado posanga toa ngada ne ga bedane, ");
INSERT INTO bch_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Gau Maron Deo togo, toa nabada go ga tnan Isip. Ngan tibur toa oa mugaeai tipakala go ta eao kakado led naurata paeaeanga. ");
INSERT INTO bch_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Irangrang ngan deo eta pade iman am deo mao. Gau kekelegau naman am Deo. ");
INSERT INTO bch_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Irangrang ngan eao kado lem deo eta aea namer mao. Be kado danga eta pade aea namer mao pade. Danga eta ienono buburiai, mao tanoeai, mao ngan eau gadio tanoeai, irangrang ngan eao kado aea namer mao. ");
INSERT INTO bch_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Be irangrang ngan eao kor aem ngan gid deo padengada mao ga soa edad mao pade. Ngansa gau, Maron Deo togo, naparpar tau ta irangrang ngan nalongean deo eta pade ibada mulig mao. Be sapadua lolod paeamao ngan gau, gid led idil paeamao ienono matageai, ta gau ga napanas gid ngan led kadonga sat ga napanas led gergeu ga tibutibud ga led sasasa pade. ");
INSERT INTO bch_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Be sapadua lolod ikim gau ga tinasnasi leg apu, gau ga lolog ikim gid pade ga nanasi kadonga mata tutui aea pagid toman ngan led gergeu ga tibutibud ga ila irangrang ngan led panua iaoa bunoringring muriai ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Irangrang ngan eao oato am Maron Deo ieda sapaean mao. Ngansa gau Maron ga napanas sapadua toa tiuatoato edag sapaean. ");
INSERT INTO bch_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Eao manta matam nanan kemi Ado Earainga aea ta lolon ngan ado toa oa aea ul. ");
INSERT INTO bch_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Ngan ado toa lima ga ede ne, eao ga kado lem naurata toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Be ado lima ga rua aea, eine Ado Earainga aea ton am Maron Deo. Ngan ado toaiua, irangrang ngan eao kado naurata eta mao. Be lem gergeu arangaranga ga taine, ga lem paeaeanga arangaranga ga taine, ga lem masilau mud, ga panua ngan tibur padengada toa timamado pago, gimi toa ngada ne arangrang ngan akado naurata eta ngan ado toaiua mao. ");
INSERT INTO bch_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ngansa ngan ado toa lima ga ede oa mugaeai, gau Maron nakado bubur ga tano ga tad ga danga toa ngada ne ienono ngan ga iuot. Be naearagau ngan ado lima ga rua aea. Tota gau Maron nakado posanga kemi ngan pamatuanga Ado Earainga aea ta nadol leg ul ngan ado toa oa. ");
INSERT INTO bch_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Manta lolon ngan tamam ga tnam ta nasi linged. Oangga eao kado toa bedaoa, eine eao ga mamado mole ngan tano toa am Maron Deo iuangga ipan ga iman am. ");
INSERT INTO bch_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Irangrang ngan eao pamate eaba ede pade mao. ");
INSERT INTO bch_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Irangrang ngan eao paeabu ngan oainga ngan kadonga arala mao. ");
INSERT INTO bch_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Irangrang ngan eao lublub mao. ");
INSERT INTO bch_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Oangga eao madid ngan posanga, irangrang ngan eao pakaka ta sol lem eaba ede pade ngan posanga sapaean mao. ");
INSERT INTO bch_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Irangrang ngan eao ngale ga kim luma ton eaba ede pade mao, ga ngale ga kim iadaoa mao, ga ngale ele paeaeanga arangaranga ga taine mao, ga ngale ele bulmakao ga donki mao, ga ngale ele danga sisid padengada mao pade.” ");
INSERT INTO bch_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Be gid panua tilongo taule itang ga pelaka ele tandanga, ga tigera gla isamil alele ga basu puk ga idae lusiai, tota timataud kapei ga tisamimi. Ta kos ga tiluagid ta timadid aluai tede ngan lusi ");
INSERT INTO bch_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ta tikeo pan Moses, “Kemi ngan eao kekelego posa pagai ta alongo. Be kado Deo iposa ga inam pagai ta amate.” ");
INSERT INTO bch_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Be Moses ikeo pagid, “Amataud mao. Deo inam ngan tobanga gimi. Toa bedaoa ta alolon ngan ei, ta irangrang ngan akado kadonga sasat mao.” ");
INSERT INTO bch_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Io, gid panua timadmadid aluai tede maitne, be Moses ilalala ga ingata laulau kusuksuk toa Deo imamado ngan. ");
INSERT INTO bch_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Idio ta Maron ikeo pan Moses bedane, “Keo pagid panua Israel ga bedane, ‘Gimi agera ngan matami ta aoatai mambe gau namamado buburiai ta naposaposa pagimi. ");
INSERT INTO bch_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Tota irangrang ngan akado deo eta pade ga itlan gau mao. Be gimi akado lemi deo eta aea namer ngan gol ga silva mao. ");
INSERT INTO bch_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“‘Abada tano ta akado ngan leg popou tenainga aea, ta arau lemi sipsip ga meme ga bulmakao ngan, ta timan lemi tenainga ga inam pagau. Edengada adol ga idae dingaeai, ta dinga inono ga timomout ga kus, be padengada iman tenainga eaneannga aea ngan gitaingada loloda kelede. Ngan tibur isaoa nadol ngan gimi asoa edag ngan, gau ga nanam pagimi ta nakado kemi ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Be oangga akado leg popou tenainga aea ngan pat, irangrang ngan akado ngan gid pat toa panua tiket oa mao. Ngansa oangga aket pat ngan danga eta mambe kabasi, eine gimi apaeabu ngan, ta irangrang ngan adol ngan leg popou tenainga aea mao. ");
INSERT INTO bch_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Be irangrang ngan akado leg popou tenainga aea ga idae gadae mao. Ngan kado ta aeasi ngan tete ga adae ta panua tigera tinimi.’” ");
INSERT INTO bch_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Deo ikeo pade bedane, “Eao manta bada apu ga gid ne ga ila pagid: ");
INSERT INTO bch_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Oangga gimi aol eaba eta Ibru aea ta iman lemi paeaeanga sapaean, ei ga iboko pagimi irangrang ngan rai lima ga ede. Be ngan rai lima ga rua aea, gimi ga alongean ei ta itnan gimi ga ila. Ei ga iuol gimi mao. ");
INSERT INTO bch_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Oangga ei iriau maitne be gimi aol ei, ei kekelen ga itnan gimi ga ila ngan rai lima ga rua aea. Be oangga gimi aol eaba oainga ga inam toman ngan iadaoa, iadaoa ga ila toman ngan ei ngan rai lima ga rua aea. ");
INSERT INTO bch_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Be oangga aea maron ipaoai ei ngan taine ede ta ipopo ele gergeu etangada, taine toa oa toman ngan ele gergeu ga timan maron ele. Paeaeanga aranga kekelen ga itnan aea maron ga ila. ");
INSERT INTO bch_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Be oangga paeaeanga toa oa ikeo, ‘Gau lolog ikim tau ag maron ga adaoag ga leg gergeu, ta tinig ngan natnan gid ga nala mao,’ ");
INSERT INTO bch_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","tota aea maron ga ibada ei ta gisirua tila Deo ele luma aea atama iaoai. Ta ei ga imadid boloma ngan atama aea kisinga, ta aea maron ga idul itanga ngan salumu. Kadonga toa ne iman kilala ngan ei ga ibokoboko paeaeanga pan ga irangrang ngan ele matenga. ");
INSERT INTO bch_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Oangga eaba eta ilongean inat taine ga ila pan eaba ede pade ta iuol ei ga iman ele paeaeanga sapaean, taine toa oa irangrang ngan itnan aea maron ngan rai lima ga rua aea mao, mambe gid paeaeanga arangaranga tikakado oa mao. ");
INSERT INTO bch_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Oangga eaba iuol taine toa oa ta ikeo ga iuai ei, be muriai itin igelgel ngan ei mao, manta ilongean taine toa oa itama masin tiuol ei mulian. Eaba toa oa ele kadonga pan taine itutui mao, tota irangrang ngan ilongean ei ga ila pagid alu padengada ga tiuol ei mao. ");
INSERT INTO bch_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Be oangga isio taine toa oa ga iman inat iadaoa, manta ikakado kadonga kemi ga tutui pan, mambe ikakado ngan inat taine. ");
INSERT INTO bch_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Be oangga maron toa oa iuai taine ede pade, manta imariala kemi ngan taine toa mugamuga oa, ta ipan aea annga ga barikia papau ga gisirua tienono pade. ");
INSERT INTO bch_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Be oangga inasi kadonga toa tol ne ngan taine paeaeanga oa mao, ei manta ilongean ei ta itnan ei ga ila. Be taine toa oa ga ibada olnga eta ga ila pan mao.” ");
INSERT INTO bch_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Deo ikeo pade bedane, “Oangga sai irau eaba ede pade ga imate, manta arau eaba toa oa ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Be oangga eaba toa oa itoba ngan pamatenga iuae ede pade mao, be ikakrik ngan ele matenga, manta eaba toa oa iaoa ga ila ngan tibur ede gau ga nasio, ta ei ga imado kemi toa eoa. Ngansa Deo kekelen ilongean iuae toa ede pade oa ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Be oangga iloilo edap eta ngan raunga eaba ede pade ga imate ta ikado toa bedaoa, manta arau eaba toa oa ga imate. Irangrang ngan iaoa ngan aea panasnga ta ila ngan leg popou tenainga aea mao. Oangga bedaoa, aluku ei toa eoa ta abada ei ga ila ngan tibur ede pade ta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Oangga sai itapa itama mao itna, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Oangga gimi agera eaba eta ipaeaoa eaba ede pade, ta ila iuot mambe ele paeaeanga sapaean, manta arau ei ga imate. Oangga aluku eaba toa oa, be agera paeaeanga toa oa idio pan maitne, mao oangga agera ilongean ei pagid panua padengada ta tiuol ei, manta arau eaba toa oa ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Oangga sai iposa paeamao ngan itama mao itna, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","“Oangga panua rua tiparau, ta eaba ede itapa iuae ede pade, mao oangga irau ei ngan pat, be iuae toa oa imate mao, irangrang ngan gimi apanas eaba toa oa mao. Be oangga iuae toa oa imate mao, be ibada ieieinga ta ienono imuliai, be muriai idae ta ibada ele toto ta ilalala alele, eine eaba toa irau ei oa manta iuol ei ngan ado pida itnan ele naurata. Ga pade, ei manta imariala ngan ei ga irangrang ngan itin iuot kemi mulian. ");
INSERT INTO bch_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Oangga eaba eta imui ele paeaeanga aranga mao taine ngan toto, ta paeaeanga toa oa imate ngan ado toaiua, manta apanas paeaeanga toa oa aea maron. ");
INSERT INTO bch_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Be oangga paeaeanga toa oa ieno ngan ado ede mao rua, ga kus ta imate, irangrang ngan apanas aea maron toa oa mao. Ngansa paeaeanga toa oa imamado aea maron ibageai, ta ele matenga eine danga ton aea maron. ");
INSERT INTO bch_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Be oangga panua tiparau, be taine ede iapa imadid boloma, ta tirau ei, ta ipopo gergeu ga imate, be taine toa oa imate mao, eaba toa irau taine, manta iuol taine toa oa iadaoa ngan pat pida iadaoa ikim. Be gid panua patutuinga posanga ad, manta lolod kelede ngan pat pida iuol ga ila pan taine iadaoa. ");
INSERT INTO bch_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Be oangga taine toa oa ibada ieieinga paeamao ga ienono, manta akado kadonga lalaede toa bedaoa pan eaba toa irau ei. Be oangga taine toa oa imate, manta arau eaba toa oa ga imate pade. ");
INSERT INTO bch_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Be oangga eaba ipaeabu ngan taine toa oa imata, mao iluo, mao ibage, mao iae, manta akado kadonga lalaede toa bedaoa pan. ");
INSERT INTO bch_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Be oangga inono taine toa oa itin ngan dinga, mao oangga ipaeabu ngan taine toa oa itin ga aea nasimou, mao oangga irau ei ga itin idadalnga, manta akado kadonga lalaede pan eaba toa oa pade. ");
INSERT INTO bch_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Oangga eaba irau ele paeaeanga aranga mao taine ga idae imatai, ta ipaeabu ngan imata, manta ilongean paeaeanga toa oa ta itnan ei ga ila. Kadonga toa ne iman paeaeanga imata aea olnga. ");
INSERT INTO bch_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Be oangga eaba irau ele paeaeanga aranga mao taine ga ikor iluo, manta ilongean paeaeanga toa oa ta itnan ei ga ila. Kadonga toa ne iman paeaeanga iluo aea olnga.” ");
INSERT INTO bch_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Deo ikeo pade bedane, “Oangga bulmakao irau eaba eta mao taine eta ngan aea pelenga ga imate, manta araurau bulmakao toa oa ngan pat ga imate. Be irangrang ngan aean imedameda mao. Be bulmakao itama ele idil eta paeamao mao. ");
INSERT INTO bch_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Be oangga bulmakao ele kadonga toa bedaoa somisomi, ta gid panua tikado posanga matua ga ila pan bulmakao itama, be idol bulmakao ga idio koroleai mao, ta irau eaba mao taine ga imate, manta araurau bulmakao toa oa ngan pat ga imate. Be apamate bulmakao itama pade. ");
INSERT INTO bch_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Be oangga eaba toa imate oa isobosobo tikim, bulmakao itama manta iuol pat pida toa tikeo ngan oa ga ila pagid, ta bulmakao itama ga imate mao. ");
INSERT INTO bch_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Be oangga bulmakao irau gergeu aranga mao taine, eine ga anasi apu toa lalaede ne pade. ");
INSERT INTO bch_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Be oangga bulmakao irau eaba ede pade ele paeaeanga aranga mao taine, bulmakao itama manta iuol paeaeanga aea maron ngan pat silva sangaul tol. Be manta tiraurau bulmakao toa oa ngan pat ga imate. ");
INSERT INTO bch_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Oangga eaba ilalaoan nasulung iaoa aea pakalanga, mao oangga ilei nasulung be irobi mao, ta eaba ede pade ele bulmakao mao donki itap ga isulug ngan ga imate, ");
INSERT INTO bch_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","manta nasulung itama iuol ga ila pan masilau toa oa itama. Be masilau toa imate oa ga iman ei ele. ");
INSERT INTO bch_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Be oangga eaba ede ele bulmakao irau bulmakao ton eaba ede pade ga imate, gisirua ga tilongean bulmakao toa imata igeragera oa ta panua tiuol. Ga kus ta tipota pat toa oa toman ngan masilau toa imate oa rabu ngan gisirua. ");
INSERT INTO bch_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Be oangga tiuatai mambe bulmakao toa oa ipaparau somisomi, be itama idol ei ga idudunga koroleai mao, ei manta ikoli ele bulmakao ede pade ga ila pan bulmakao toa imate oa itama. Be bulmakao toa imate oa pade ga iman ele.” ");
INSERT INTO bch_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Deo ikeo pade bedane, “Oangga eaba ede ilub iuae ede pade ele bulmakao, mao sipsip, ga kus ta itotoi, mao ilongean ga ila pagid panua padengada ta tiuol, manta eaba toa lublubnga aea oa ikoli bulmakao lima ga ila pan iuae ede pade ngan ele bulmakao ede. Be oangga ilub sipsip, manta ikoli sipsip pange ga ila pan. ");
INSERT INTO bch_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Oangga eaba lublubnga aea igoro luma bong, be luma itama irau ei ga imate, luma itama ele idil eta paeamao ngan raunga ei ga imate mao. ");
INSERT INTO bch_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Be oangga irau ei ado ga imate, luma itama ele idil paeamao ngan raunga ei ga imate. “Eaba lublubnga aea manta ikoli mulian saoa danga ilub. Be oangga ele danga eta mao, manta tilongean ei pagid panua padengada ta tiuol ei ga iman led paeaeanga sapaean. Pat toa ne ga ila pan danga sisid itama ngan olnga ele danga toa ilub oa. ");
INSERT INTO bch_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","“Oangga eaba ede ilub iuae ede pade ele bulmakao, mao donki, mao sipsip, ta tiluku eaba lublubnga aea toa oa, be masilau imata igeragera maitne, manta eaba lublubnga aea ikoli ngan masilau rua ga ila pan masilau itama. ");
INSERT INTO bch_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Oangga eaba ibada ele masilau mud ga tila tian purup dadangai, mao boloma ngan dadanga oain, be masilau toa oa tilaputian but ta tila tian eaba ede pade aea dadanga, manta masilau toa oa itama ikoli annga kemikemi ga oain kemikemi ga ila pan dadanga itama. ");
INSERT INTO bch_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Oangga eaba itun aea dadanga, be dinga ian sasari purup mamasa ta iuore ga ila ian eaba ede pade aea dadanga, mao ian ele wit aea suknga, mao wit padengada tiket maitne, manta eaba toa ipaisi dinga oa ikoli saoa annga toa dinga ian. ");
INSERT INTO bch_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Oangga eaba ibada ele pat silva, mao ele danga sisid padengada ga ila idio pan iuae ede pade, ta imariala ngan, be eaba lublubnga aea inam ilub danga sisid toa oa pan iuae ele lumaeai, ta tiluku ei, manta eaba lublubnga aea ikoli danga sisid ruangada ga ila pan danga sisid itama. ");
INSERT INTO bch_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Be oangga tiluku eaba lublubnga aea mao, luma itama ga ila imadid pagid panua patutuinga posanga ad matadeai, ta ei manta ikado posanga ga ila pagid ga bedane, ‘Tautaunga, gau nalub oaeg ede pade ele danga sisid mao.’ ");
INSERT INTO bch_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Be oangga panua rua aoad parau ngan danga ede mambe bulmakao, mao donki, mao sipsip, mao barikia, mao danga eta pade, ta gisirua tiparpar ngan posanga ta tikeo, ‘Eine gau togau,’ eine gisirua ga tila timadid pagid panua patutuinga posanga ad matadeai. Oangga panua patutuinga posanga ad tikeo ga ede ngan gisirua ipakaka, eaba toa oa manta ikoli danga sisid ruangada ga ila pan iuae toa ede pade oa. ");
INSERT INTO bch_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Oangga eaba ibada ele donki, mao bulmakao, mao sipsip, mao masilau mud eta pade ga ila pan iuae ede pade, ta imariala ngan, be masilau toa oa ibada nasimou, mao imate, mao eaba lublubnga aea ipaeaoa, be eaba eta pade igera mao, ");
INSERT INTO bch_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","eine gisirua ga tikado posanga tautaunga ngan Maron ieda, ta eaba toa imariala ngan masilau manta ikado posanga bedane, ‘Tautaunga gadae, gau napaeabu ngan oaeg ede pade ele masilau mud mao, be nalub mao pade.’ Be masilau itama manta ilongo ngan posanga toa ne. Ta iuae ede pade ga ikoli danga eta pan mao. ");
INSERT INTO bch_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Be oangga masilau itama iuae toa oa imariala ngan masilau kemi mao, ta eaba lublubnga aea ipaeaoa, eine iuae toa oa ga iuol ga ila pan masilau itama. ");
INSERT INTO bch_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Be oangga masilau saksak ede irau masilau mud toa oa ga imate, eaba toa oa ga ibada masilau ikatinge ede ga ila ipasolan pan masilau itama, ta ei ga iuol ga ila pan masilau itama mao. ");
INSERT INTO bch_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Oangga eaba iuanana iuae ede pade ele masilau mud ta iuol ei motean ngan ado toa pidaede oa, be masilau toa oa aea kadonga ede, mao imate, be masilau toa oa itama igera mao, manta eaba toa iuanana masilau ibada masilau aea olnga dodol ga ila pan masilau itama. ");
INSERT INTO bch_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Be oangga masilau itama igera masilau aea kadonga paeamao toa oa, eaba toa iuanana masilau ga iuol ga ila pan masilau itama mao. Ngansa pat kautede toa ibada motean pan, eine ikaranga.” ");
INSERT INTO bch_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Deo ikeo pade bedane, “Oangga eaba ipalum taine blala ede toa ieno toman ngan eaba eta maitne, be tisio taine toa oa motean ngan oainga eaba eta pade mao, be eaba toa oa ieno toman ngan ei, ei manta ibada gid gerebo ga ila pan taine toa oa itama. Ga kus ta eaba toa oa ga iuai ei. ");
INSERT INTO bch_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Be oangga taine itama itin ngan eaba toa oa iuai inat taine mao, eine gisirua ga tiuai mao, be eaba toa oa manta ibada gid gerebo ga ila pan taine itama. ");
INSERT INTO bch_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Oangga taine sai ikado borou, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Oangga sai ieno toman ngan masilau, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Manta akado tenainga ga ila pan Maron kekelen. Oangga sai irau masilau ga iman tenainga ga ila pan deo eta pade, manta arau ei ga imate ga apaeabu ngan ele danga sisid. ");
INSERT INTO bch_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Oangga eaba ngan tibur ede pade imamado rabu ngan gimi, irangrang ngan akado kadonga eta paeamao ngan ei mao. Akado kulupu ngan ei mao pade, ngansa mugaeai gimi panua ngan tibur ede pade toa amamado Isip. ");
INSERT INTO bch_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Irangrang ngan akado paeamao ngan gid asapsape ga akonokono mao. ");
INSERT INTO bch_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Oangga akado bedaoa, be tiansaban gau ngan luanga gid, eine ga nalongo led tandanga. ");
INSERT INTO bch_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Toa bedaoa ta lolog bake ta nasula ami miri itamatama ta tinam tirau gimi ga amate. Toa bedaoa ta adadaoami ga tidio timan asapsape ga lemi gergeu timan akonokono. ");
INSERT INTO bch_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Oangga leg panua edengada rabu ngan gimi led danga sisid imata karanga mao ta tiuanana lemi pat, irangrang ngan akeo ga tikoli ad gigi pagimi toman ngan aea tlannga mambe gid panua oalo ad tikakado oa mao. ");
INSERT INTO bch_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Oangga oaem ede pade ibada ele pononga mamarae ga idio pago ta iman kilala ngan aea gigi pago, mugaeai ngan ado idil, eao manta bada ele pononga toa oa ga iluai mulian pan. ");
INSERT INTO bch_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Ngansa ele danga eta pade ngan robinga itin mao. Be oangga ieno, ei ga irobi ei ngan saoa? Tota oangga itang ga inam pagau, eine ga nalongo ele tandanga. Ngansa somisomi lolog isat ngan gid panua toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Irangrang ngan aposa paeamao ngan ami madidnga mao. Be aposa paeamao ngan Deo mao pade. ");
INSERT INTO bch_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Irangrang ngan adangadangan lemi wit ga oain ga bude oliv aea pagau mao. Manta atenai etangada ga iman lemi tenainga ga inam pagau. “Manta adol lemi gergeu lautabtabe arangaranga ga tidae bagegeai. ");
INSERT INTO bch_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Be manta atenai lemi bulmakao ga sipsip lautabtabe ga tinam pagau pade. Gid bulmakao ga sipsip lautabtabe ga tidio pagid tnatnad irangrang ngan ado lima ga rua. Be ngan ado lima ga tol aea, manta atenai gid ga tinam pagau. ");
INSERT INTO bch_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Gimi manta apasolan mambe leg ul ienono ngan gimi. Tota oangga masilau saksak irau lemi masilau mud eta ga imate, irangrang ngan aean imedameda mao. Atado ga ila pagid kaua.” ");
INSERT INTO bch_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Deo ikeo pade bedane, “Irangrang ngan gimi apaoasasa posanga pakakanga mao. Oangga eaba ede ele idil paeamao ta tipamadid ei ngan posanga, irangrang ngan gimi akado posanga pakakanga ngan aea isat ngan luanga ei mao. ");
INSERT INTO bch_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Oangga gid ipom tiuangga tikado kadonga paeamao ede, irangrang ngan gimi anasi gid ngan kadonga toa oa mao. Be oangga tipamadid eaba ede ngan posanga, be panua busa tiuangga tikado posanga pakakanga ngan luanga ei, irangrang ngan gimi anasi gid ngan led posanga pakakanga mao. ");
INSERT INTO bch_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Be oangga tipamadid eaba lululunga aea ngan posanga, irangrang ngan gimi akado kadonga bagbage kelede ngan luanga ei mao. ");
INSERT INTO bch_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Oangga agera ami isat ele bulmakao, mao donki itnan aea korol ta iaoa, manta abada ga iluai mulian pan. ");
INSERT INTO bch_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Be oangga agera ami isat ede ele donki itap toman ngan ele tulua, manta alua ei ngan soanga ele donki ga idae. Atnan ei ga idio ienono tanoeai mao. ");
INSERT INTO bch_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Oangga tipamadid eaba lululunga aea ngan posanga, irangrang ngan gimi aposa pakakanga ngan ei mao. Ngan kado ta tipatutui ele posanga kemi mao. ");
INSERT INTO bch_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Be irangrang ngan gimi apakaka ta apamadid eaba ede pade ngan posanga sapaean mao. Be oangga eaba tutui ede ele idil eta paeamao mao, irangrang ngan gimi apamadid ei ngan posanga sapaean ta arau ei ga imate mao. Ngansa oangga sai ele idil paeamao ngan kadonga toaine, gau ga napamadid ei ngan posanga, ta irangrang ngan isapir ngan aea panasnga mao. ");
INSERT INTO bch_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Oangga eaba ede iparumrum gimi ngan pat ta ikeo ga akado posanga pakakanga ngan luanga ei, irangrang ngan alongo ei mao. Ngansa kadonga toaine ipabuobuo panua kemikemi led posanga ta ikado ga panua patutuinga posanga ad tipaeabu ngan panua tututui. ");
INSERT INTO bch_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Oangga eaba ngan tibur ede pade imamado rabu ngan gimi, irangrang ngan akado kulupu ngan ei mao. Ngansa matami nanan ami kadonga kulupulupu gid Isip tikakado ngan gimi mugaeai.” ");
INSERT INTO bch_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Irangrang ngan rai lima ga ede, gimi ga aearum ami annga dadangai ga ababada ami annga imatua dadangai pade. ");
INSERT INTO bch_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Be ngan rai lima ga rua aea, manta atnan dadanga toa oa ga idio iman balim, ga abada saoa annga ienono ngan pade mao. Akado toa bedaoa pade ngan ami dadanga oain ga ami oalu oliv. Toa bedaoa ta gid panua lululunga ad ga tibabada ad annga ngan, be gid masilau saksak pade ga tian saoa annga gid panua lululunga ad titnan ga idio. ");
INSERT INTO bch_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Ngan ado toa lima ga ede ne, gimi ga akado lemi naurata. Be ngan ado lima ga rua aea, irangrang ngan gimi akado naurata eta mao. Toa bedaoa ta lemi bulmakao ga donki ga lemi paeaeanga ga eaba ngan tibur ede pade toa imamado rabu ngan gimi, eine ga tiaragid, ta urad iluai mulian. ");
INSERT INTO bch_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Alongo kemi ga anasnasi posanga toa ngada ne nakeo pagimi ngan. Irangrang ngan gimi araring ga ila pagid deo padengada mao. Be aoatoato gid deo padengada edad mao pade.” ");
INSERT INTO bch_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ngan rai ga rai, gimi manta akado eaneannga kapeipei tol ngan soanga gau edag. ");
INSERT INTO bch_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Akado eaneannga kapei ngan Bret toa aea Yis Ienono ngan Mao mambe nakeo pagimi ngan. Ngan ado toa lima ga rua ne, manta aean bret aea yis ienono ngan mao. Akado eaneannga toa ne tutui ngan aea ado ngan taiko Abip. Ngansa ngan taiko toa ne, gimi atnan Isip ga anam. “Irangrang ngan bagemi sapaean ga anama pagau ngan eaneannga toa tol ne mao. Manta anam toman ngan lemi tenainga. ");
INSERT INTO bch_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Be akado eaneannga kapei ede pade ngan Matami Nanan Annga Imatua aea Badanga. Manta atenai lemi annga isaoa imatua ga imuga ta iman tenainga ga inam pagau. “Be akado eaneannga kapei ede pade ngan Matami Nanan lemi Madonga Palatai, ngan taiko annga aea laoe. Ngan ado toaiua apaluplup ami oliv itautau ga annga padengada itautau, ta akado eaneannga toa ne. ");
INSERT INTO bch_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Ngan eaneannga kapeipei toa tol ne, gimi arangaranga toa ngada ne manta anam pagau ta asoa gau edag. Gau Maron toa namadid ga namugamuga ngan danga toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Irangrang ngan atenai lemi masilau eta ga inam pagau toman ngan annga aea yis mao. “Ngan gid eaneannga toa ne irangrang ngan adol masilau tenainga aea imona ga idio gaisala mao. ");
INSERT INTO bch_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Lemi annga kemikemi imatua ga imuga, manta abada ga ila leg palatai, ta iman tenainga ga inam pagau ami Maron Deo. “Irangrang ngan anono meme daenga pau eta ngan ulo toman ngan itna itud isul mao.” ");
INSERT INTO bch_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Deo ikeo pade bedane, “Ega, gau nasula anggelo ga imuga ngan gimi, ta ei ga imariala ngan gimi edapeai. Ei ga ibada gimi ga ala aot ngan tibur toa nakemi motean ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Alongo kemi ele posanga ga anasi. Be apamasmasi ilolo mao. Ngansa gau namamado toman ngan ei, ta ei ga isamum lemi kadonga tanga balbal aea mao. ");
INSERT INTO bch_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Oangga alongo kemi ele posanga ga akado danga toa ngada ne mambe nakeo ngan, eine ga naman ami miri itamatama ad isat. Be oangga sapadua tiparau pagimi, eine ga naparau ga ila pagid. ");
INSERT INTO bch_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Leg anggelo toa ne ga imuga ngan gimi ta ibada gimi ga ala ngan tano togid Amor ga It ga Peres ga Kenan ga Ivi ga Iebus. Ta gau ga napamukuru gid ga kus. ");
INSERT INTO bch_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Be irangrang ngan akor aemi ngan ad deo mao, ga asoa ad deo edad mao. Be irangrang ngan anasi led kadonga mao pade. Manta apaeabu ngan ad namer ga agorogoro led pat kilala aea ga irumrum. ");
INSERT INTO bch_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Gau Maron Deo togimi. Manta asoa gau kekelegau edag. Oangga akado bedaoa, eine ga nakado kemi ngan ami annga ga eau, ga naseresere dibala ga ila aluai ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Be gid taine apapad ga tipopo kemi led gergeu, ta irangrang ngan eta imate itna iapai mao. Be taine eta ga iman taine lasi mao pade. Ta gimi ga arangrang ngan amate manmanae mao. Gimi ga amamado mole tanoeai. ");
INSERT INTO bch_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Gid alu isaoa tigera gimi, eine ga nakado ga timataud kapei ta napabuobuo laborad ta timangamanga alele. Be ami miri itamatama toa ngada oa ga tipul murid pagimi ta tiaoa ga tila. ");
INSERT INTO bch_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Be gau ga nasula gid gulupa ta timugamuga ngan gimi, ta tipitpit gid Ivi ga Kenan ga It, ta tila aluai ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Be gau ga nasere gid ga kus ngan rai kelede mao. Ngan kado ta tano toa oa ienono sapaean ta gid masilau saksak tiuot busa ta tipapaeabu ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Eine ga napaeabu ngan gid kautedengada ga irangrang ngan gimi aot busa ta apakaranga tano toa oa ga amadid matua ngan. ");
INSERT INTO bch_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Eine ga nadol ami tano aea but imata ga idio ngan tad Singsingia aea lab, be aea but imata iadag ga idio ngan tad kapei togid Pilistia, be aea but imata iadag ga idio ngan tibur modamodanga, be aea but imata iadag ga idio ngan eau kapei Iupretis. Be gid panua timamado ngan tibur toa oa, eine ga nadol gid ga tidae bagemiai, ta gimi ga asere gid ta tiaoa ga tila. ");
INSERT INTO bch_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Be irangrang ngan arau posanga ta lolomi kelede toman ngan gid alu toa oa ga ad deo mao. ");
INSERT INTO bch_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Be alongean gid ga timamado ngan ami tano mao pade. Ngan kado ta tidada gimi ta akado kadonga sasat ngan gau. Ngansa oangga asoa ad deo edad, eine kadonga toa ne ga ipaeabu ngan gimi mambe adae kas ngan pitpit.” ");
INSERT INTO bch_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Idio ta Maron ikeo pan Moses bedane, “Gau nakim eao dae ga nam pagau lusiai toman ngan Aron ga Nadap ga Abiu ga gid kapeipei Israel ad sangalima sangaul rua. Gid ga timadid aluai tede ta tikor aed ga tisoa gau edag. ");
INSERT INTO bch_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Be Moses, eao kekelego nam boloma pagau Maron. Be gid panua padengada tirangrang ngan tinam boloma pagau mao. Be gid ipom pade tirangrang ngan tidae ga tinam toman ngan eao mao.” ");
INSERT INTO bch_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Io, Moses ila ikeo pagid ipom ngan Maron ele posanga ga ele apu toa ngada oa. Ga kus ta linged kelede ta tikeo, “Gai ga akado danga toa ngada ne mambe Maron ikeo ngan.” ");
INSERT INTO bch_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Tiposa bedaoa ga kus ta Moses ibode Maron ele posanga toa ngada oa ga idae ngan laulau ede. Be gaisala rumaruma ngan ado sae, ipagun popou tenainga aea boloma lusi ipuiai. Ga kus ta ipagun pat mamamarae sangaul ga igegea rua, iman kilala ngan gid lum sangaul igegea rua togid Israel. ");
INSERT INTO bch_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Be isula gid kakau iririau Israel ad ta tila tikado gid tenainga ga ila pan Maron. Masilau edengada tidol ga idae dingaeai, ta dinga inono ga imomout ga kus, be titenai gid bulmakao daenga papau padengada, ta timan tenainga eaneannga aea ngan lolod kelede toman ngan Deo. ");
INSERT INTO bch_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Be Moses idoi gid masilau singid ta itok ga idudunga ngan gid tabla gereirei, be itil sing ilia ga idae ngan popou tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ga kus ta ibada laulau apu aea toa iman kilala ngan posanga toa Deo irau toman ngan gid Israel, ta iuato laulau aea posanga ga ila pagid panua. Tilongo ga kus ta tikeo, “Gai ga akado ga anasi tutui danga toa ngada ne mambe Maron ikeo ngan.” ");
INSERT INTO bch_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Ga kus ta Moses ibada sing ngan gid tabla toa oa ta itil ga idae ngan gid ipom ta ikeo, “Ega, sing toa ne iparangrang posanga tautaunga toa Maron irau ngan gimi, mambe laulau toa ne ikeo ngan.” ");
INSERT INTO bch_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Idio ta Moses ga Aron ga Nadap ga Abiu ga gid kapeipei Israel ad sangalima sangaul rua tidae ga tila lusiai ");
INSERT INTO bch_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ta tigera Deo togid Israel. Iae ibuloloeai, tigera danga mambe edap ede tikado ngan pat sapaia bil. Be edap toa oa mil ga mil mambe mariamba. ");
INSERT INTO bch_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Tautaunga, gid kapeipei Israel ad tigera Deo ngan matad, be Deo ipaeabu ngan gid mao. Ga kus ta tian annga ga tiun. ");
INSERT INTO bch_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Idio ta Maron ikeo pan Moses bedane, “Dae ga nam pagau lusiai ta dio toa eko. Ta gau ga nabada pat apu aea toa rua ne ga ila pago. Ngan pat toa rua ne, nabode gid apu ga posanga toa gid panua manta tinasnasi, ta eao ga paoatai gid ngan.” ");
INSERT INTO bch_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Io, Moses toman ngan ele aluagau Iosua tidae ga tila, ta Moses ibida ga idae ngan lusi ton Deo. ");
INSERT INTO bch_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Be ikeo motean pagid kapeipei Israel ad bedane, “Gimi adio saupuiai ne ta asangasanga gairua ga irangrang ngan aluagai mulian pagimi. Ega, Aron ga Ur tidio toman ngan gimi. Ta oangga sapadua aoad parau, manta tila pagisirua, ta tipatutui posanga pagid.” ");
INSERT INTO bch_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Moses iposa bedaoa ga kus ta idae ga ila ngan lusi Sainai, be laulau kapei irobi lusi. ");
INSERT INTO bch_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Be Maron ele taranga isulug laulauiai ga idio ngan lusi. Irangrang ngan ado lima ga ede, laulau kapei toa oa irobi lusi. Be ngan ado lima ga rua aea, Deo toa imamado laulau iloleai oa ibaba ga ila pan Moses. ");
INSERT INTO bch_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ngan gid Israel matad, Maron ele taranga imata mambe dinga kapei irarabal toa lusi ilaborai oa. ");
INSERT INTO bch_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Idio ta Moses ibida ga idae lusi ilaborai, be idudunga laulau iloleai. Ta Moses idio imamado toa lusiai oa irangrang ngan aea ado ga bong sangaul pange. ");
INSERT INTO bch_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Idio ta Maron ikeo pan Moses bedane, ");
INSERT INTO bch_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Keo pagid panua Israel ta tibada led danga sisid etangada ga inam pagau. Panua kelede kelede tikim badanga led danga etangada ga inam pagau, kemi ngan tital ga ila pagimi. ");
INSERT INTO bch_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Ta gimi ga abada led danga toa titenai ga inam pagau ga bedane: gol, ga silva, ga bras, ");
INSERT INTO bch_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ga sipsip ilaun toa tisama ngan pulo singsingia ga singsingia tede ga bil, ga gid malo kemikemi, ga malo tikado ngan meme ilaun, ");
INSERT INTO bch_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ga sipsip arangaranga tinid kukul toa tisama ngan pulo singsingia, ga rui tinid kukul, ga abei akas ikatinge etangada. ");
INSERT INTO bch_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","Ga pade, kemi ngan tibada bude lam aea ga danga iuad kemikemi ngan bulnga toman ngan bude samanga aea toa iman kilala ngan gid danga sisid togau. Ga pade, kemi ngan tibada danga iuad kemikemi ngan bulnga toman ngan nabene ngan kadonga basu iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","Ga pade, kemi ngan tibada pat oniks ga pat imata ede ga ede toa aea olnga kapei tau, ta muriai apatoi gid ga tidae ngan madidnga kapei tenainga aea irabu aea malo, ga apatoi etangada pade ga idae ngan igogo aea malo kakauede. ");
INSERT INTO bch_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ta gid panua ga tibada gid danga sisid toa ne ta tikado leg palata ede ngan. Toa bedaoa ta namamado rabu ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Be gimi manta akado palata toa ne toman ngan aea danga sisid toa ngada oa ta iuot lalaede mambe ianun toa gau ga napasolan pago.” ");
INSERT INTO bch_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Deo ikeo pan Moses pade bedane, “Ta gid panua ga tikado korol ede ngan abei akas, aea mamarae iluai kepeda iadag, be aea babanga iluai baidai, be aea gadae iluai baidai pade. ");
INSERT INTO bch_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Be manta abada gol kemikemi ta anono ngan dinga ga ila maraka, ta asile aea sakirkir toa ngada oa. Ga kus ta abada gol toa oa ikatinge babanga, ta apatoi ga idae ngan korol ilolo ga aluga ngan itin gaot pade. Ga pade, manta apatoi gol idanga ede mamarae ga iman korol aea lapinga ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ga pade, akado korol aea koea gol pange ta apatoi gid ga tidae ngan korol iae gereirei pange. Apatoi koea rua ngan korol imata iadag, ga rua pade ngan korol imata iadag. ");
INSERT INTO bch_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Ga kus ta abada abei akas mamarae rua ta aoaliue gid kemi ta timan sig. Amol sig toa rua oa ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Ga kus ta asabun sig toa rua oa ga tidudunga ngan gid koea korol aea. Asabun sig ede iadag, ga sig ede pade iadag, ta iman korol aea bisinga. ");
INSERT INTO bch_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Sig toa rua oa manta ienono somisomi ngan gid koea. Irangrang ngan anusi gid sig toa oa pade mao. ");
INSERT INTO bch_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Be muriai gau ga nabada pat rua apu aea ga ila pago. Ta eao ga dol pat toa rua oa ga tidudunga koroleai. ");
INSERT INTO bch_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Be gimi manta akado korol ipao ngan gol kemikemi, aea mamarae iluai kepeda iadag, be aea babanga iluai baidai. Korol ipao toa ne eine tibur toa sing isamum panua led kadonga sasat ga ila, ta lolog itarui mulian ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Manta abada gol ikatinge kelede ta atut ngan pat patotonga aea ta akado korol ipao toman ngan aea kerubim rua, ede iadag, ede pade iadag. Akado ede ngan korol ipao imata ngan bageda oatai, be ede pade ngan bageda angas. Ta gid kerubim toa rua ne ga tidio ngan korol ipao imata iadag ga iadag. ");
INSERT INTO bch_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kerubim toa rua ne ga tidio ngan tibur toa nasamum panua led kadonga sasat ngan, be matad inono ngan gid. Be gisirua bagbaged ga iualai ga idae ta tirobi korol ipao. ");
INSERT INTO bch_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Ta gau ga nabada pat apu aea toa rua oa pago, ta eao ga dol gid ga tidudunga korol iloleai. Ga kus ta kapin korol ngan ipao. ");
INSERT INTO bch_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ta gau ga nalup toman ngan eao ngan tibur toa nasamum kadonga sasat ngan. Be gau ga namado rabu ngan kerubim toa rua oa ta napaola leg apu toa ngada ne pago. Be eao ga bada gid apu toa ne ga ila pagid Israel ta tinasi.” ");
INSERT INTO bch_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Deo ikeo pade bedane, “Gimi manta akado popou ede ngan abei akas, aea mamarae ga iluai gogodai, be aea babanga ga iluai bageda aea makoreai, be aea gadae ga iluai baidai. ");
INSERT INTO bch_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Be manta aluga popou toa ne ngan gol kemikemi ikatinge babanga. Be apatoi gol idanga ede mamarae ga iman popou aea lapinga ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Be manta apatoi gol ikatinge babanga ede pade ta imadid ngan popou ipao mambe ala ta ibalil ngan popou ipao imata. Gol ikatinge toa oa aea gadae ga iluai mambe bageda ilolo aea babanga. Ga pade, apatoi lapinga gol ede pade ga idae tatan ngan gol ikatinge toa babanga oa ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","27","Ga pade, manta akado popou aea koea gol pange ta apatoi gid ga tidae ngan popou ipao aea gol ikatinge toa babanga oa ta inasi popou iae toa pange oa. Ta gid koea toa oa ga tikikisi sig rua ta timan popou aea bisinga. ");
INSERT INTO bch_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Be manta akado sig toa rua ne ngan abei akas ta amol gid ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Ga pade, manta akado gid tabla gereirei ga lalate ga eaupat ga loba ngan gol kemikemi. Gid danga sisid toa ne iman tenainga oain aea toknga. ");
INSERT INTO bch_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ta gimi ga adol bret tenainga aea ga idae ngan popou toa ne, ta ienono matageai somisomi.” ");
INSERT INTO bch_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Deo ikeo pade bedane, “Gimi manta abada gol kemikemi ta akado ga iman lam iae, ngan dolnga gid lam ga idae ngan. Atut gol ngan pat patotonga aea ta akado lam iae ipu ga ilua ga ibogaboga iman lam imul aea dolnga. Be akado gid lam mulid ngan gol ta matad mambe koko ipur. Be lam iae aea danga toa ngada ne, manta akado ngan gol ikatinge kelede. ");
INSERT INTO bch_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Manta akado lam iae ilua toman ngan ibogaboga lima ga ede, tol iadag ga tol iadag. ");
INSERT INTO bch_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Ngan gid lam iae iboga kelede kelede, manta akado aea sogonga imata lalaede mambe abei salke ipur tol toman ngan ilaun gereirei. ");
INSERT INTO bch_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Be apasogo lam iae ilua pade toa bedaoa ga imata lalaede mambe abei salke ipur pange toman ngan ilaun gereirei. ");
INSERT INTO bch_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Be gadio ngan lam iae ilua ikasanga toa tol ne, manta apasogo ngan gol ga imata mambe abei salke ilaun gereirei. ");
INSERT INTO bch_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Manta abada gol ikatinge kelede ta atut ngan pat patotonga aea ta akado lam iae toman ngan aea danga sisid toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Akado bedaoa ga kus ta akado lam lima ga rua. Ta adol lam lima ga ede ga tidae ngan lam iae ibogaboga lima ga ede, be ede pade ga idae ngan lam iae ilua ilabora. Adol gid lam tutui ga lalaede ta titara kemi leg palata ilolo. ");
INSERT INTO bch_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Be manta akado gid danga mambe kaida gol iman lam aea wik imata aea ketketnga. Ga pade, akado lam aea lalate gol. ");
INSERT INTO bch_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Gol toa ngada ne ngan lam iae ga aea danga sisid, aea kulupu ga iuot mambe kilo sangaul tol igegea pange. ");
INSERT INTO bch_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Oangga akado danga sisid toa ngada ne, manta anasi tutui ga iuot lalaede mambe ianun toa napasolan pago lusiai.” ");
INSERT INTO bch_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Deo ikeo pade bedane, “Gimi manta akado leg palata ngan malo kemikemi sangaul. Be apasogo gid malo toa oa ngan oaro salumu aea singsingia ga singsingia tede ga bil. Akeo pan eaba mosi aea ta isaisai gid kerubim anunud ga idae ngan gid malo toa oa. ");
INSERT INTO bch_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Gid malo toa ngada ne manta tiuot lalaede. Ad mamarae ga iuot leoa lima leoa rua. Be ad babanga ga iuot leoa ede. ");
INSERT INTO bch_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Asaisai malo lima ga tila tiluplup ta ila mamarae. Be akado toa bedaoa pade ngan gid malo lima pade. ");
INSERT INTO bch_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Be abada malo ilialia bil ta asaisai gid koea, ta iman malo kapeipei toa rua ne ad saunnga ta tila tiluplup. Asaisai gid koea toa ne ga tidae ngan malo kapeipei toa rua ne ngan matad iadag kelede. ");
INSERT INTO bch_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Asaisai koea sangalima ngan malo kapei imata ede, be asaisai koea sangalima pade ngan malo kapei ede pade imata iadag. ");
INSERT INTO bch_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Ga pade, akado lingau gol sangalima ta iman malo kapeipei toa rua ne ad saunnga, ta ila iuot mambe malo kapitnami kelede. ");
INSERT INTO bch_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Ga pade, manta akado malo sangaul igegea ede ngan meme ilaun ta iman leg palata aea robinga. ");
INSERT INTO bch_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Gid malo toa sangaul igegea ede ne manta tiuot lalaede mon. Ad mamarae ga iuot leoa lima leoa rua aea mana. Be ad babanga ga iuot leoa ede. ");
INSERT INTO bch_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Asaisai malo lima ga tila tiluplup ta iuot mambe malo mamarae kelede. Be asaisai gid malo toa lima ga ede ienono maitne ta tila tiluplup pade toa bedaoa, ta tiuot mambe malo mamarae ede pade, be ikatinge lima ga ede. Ga kus ta akop malo ikatinge toa lima ga ede aea ne, ta malo aea kopnga toa ne iman leg palata imata aea robinga. ");
INSERT INTO bch_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Ga pade, asaisai malo aea koea sangalima ngan malo kapeipei toa rua ne matad. ");
INSERT INTO bch_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ga pade, manta akado lingau bras sangalima ta asaun ngan gid koea ta iman malo kapeipei toa rua ne ad paluplupnga. Toa bedaoa ta iuot mambe malo kapitnami kelede. ");
INSERT INTO bch_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Be malo aea mana toa ienono sapaean, manta atnan ga idio ta itututu leg palata imuriai. ");
INSERT INTO bch_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Oangga adol malo kapitnami toa ne ga idae irobi leg palata, eine malo toa ne aea mamarae ga iasal leg palata aea mamarae kautede, irangrang mambe bageda aea makoreai, iadag ga iadag. Toa bedaoa ta ila irobi kemi leg palata. ");
INSERT INTO bch_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Be gimi manta akado danga rua pade ngan robinga leg palata. Robinga ede, gimi ga akado ngan sipsip arangaranga tinid kukul toa tisama ngan pulo singsingia. Be gadae ngan robinga toa oa, akado robinga ede pade ngan rui tinid kukul. ");
INSERT INTO bch_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Ga pade, manta akado palata aea kadanga arangaranga ngan abei akas, be rabu ngan gid kadanga arangaranga ruangada, manta apatoto gid tabalanga, ta tikado ga gid kadanga arangaranga ruangada tiuot mambe pagirigiri. Toa bedaoa ta gid kadanga arangaranga ruangada toman ngan ad tabalanga timan didnga ituatua ikatinge kelede kelede. ");
INSERT INTO bch_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Kadanga arangaranga kelede kelede ad mamarae ga iuot leoa rua aea mana. Be gid tabalanga rabu ngan gid kadanga arangaranga kelede kelede ad mamarae ga iluai baidai. ");
INSERT INTO bch_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Be asap gid kadanga arangaranga toa ngada ne matad ila mamarae tede, ngan tila tidudunga ngan gid kadanga ipu silva ad baba ta timadid ngan. ");
INSERT INTO bch_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Ngan palata ikarkare pan saut, manta akado didnga ituatua ikatinge sangaul rua toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Ga pade, akado kadanga ipu silva sangaul pange ta timan gid didnga ituatua ad pagunnga. Be ngan gid didnga ituatua ikatinge kelede kelede, manta adol kadanga ipu silva ruangada. ");
INSERT INTO bch_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","21","Akado lalaede toa bedaoa pade ngan palata ikarkare iadag pan not. ");
INSERT INTO bch_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Be ngan palata imur aea talele, akado didnga ituatua ikatinge lima ga ede toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Ga pade, akado didnga ituatua ikatinge rua pade, ngan paluplupnga palata ikarkare ga aea talele toa palata imuriai oa, ta tila tung ngan palata igal. ");
INSERT INTO bch_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ngan palata imur igal toa rua ne, asaun gid didnga ituatua ikatinge toa oa ngan gid koea ga lingau, pan ipu ga ila gadae. Asaun palata imur igal toa rua oa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Toa bedaoa ta palata imur aea talele ituatua ikatinge ga tiuot lima ga tol toman ngan ad kadanga ipu silva sangaul ede igegea lima ga ede. Gadio ngan gid didnga ituatua ikatinge kelede kelede, manta adol kadanga ipu silva ruangada. ");
INSERT INTO bch_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","“Ga pade, manta abada abei akas ta akado palata aea lapinga tol, ede gadae, ede rabu, ga ede pade gadio. Akado gid lapinga toa ne ta tidae ngan palata ikarkare toa rua oa ga aea talele pan imur. Be aket gid lapinga gadae aea ga gadio aea, ga idio rabu ga iman rua. ");
INSERT INTO bch_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Be manta akado lapinga rabu aea ngan abei mamarae kelede, ta inasi palata aea mamarae ngan palata isal toa tol oa. ");
INSERT INTO bch_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Be amol gid didnga ituatua toa ngada oa ngan gol ikatinge babanga. Be ngan gid didnga ituatua ikatinge kelede kelede pan gaot, manta akado gid koea gol iman gid lapinga ad sabunnga. Be amol gid lapinga pade ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Akado palata aea danga sisid toa ngada ne ga iuot lalaede mambe ianun toa napasolan pago lusiai. ");
INSERT INTO bch_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Ga pade, manta akado malo kemi ede, ta apakantutu palata iloleai, ta ipoga palata ilolo ga iman rua. Apasogo malo toa ne ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be manta akeo pan eaba mosi aea ta isaisai gid kerubim anunud ga idae ngan malo kapei toa ne. ");
INSERT INTO bch_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Ga kus ta abada abei akas ta akado malo toa oa aea kadanga mamarae pange. Amol kadanga toa pange ne ngan gol ikatinge babanga, ga kus ta apagun gid kadanga toa pange ne, ta gid kelede kelede timadid ngan ad kadanga ipu silva. Ga kus ta apatoi gid lingau gol ga idae ngan gid kadanga toa ne, ta malo kapei toa ne ga idae itututu ngan. ");
INSERT INTO bch_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Adol malo kapei toa ne ga idio rabu ngan leg palata ilolo ta ipoga leg palata ilolo ga iman rua. Palata ilolo ede eine tibur toa aea ul kapei tede. Be palata ilolo ede pade, toa muriai ngan malo kapei, eine tibur toa aea ul kapei tau. Be abada korol apu aea toa iman kilala ngan posanga toa narau toman ngan gimi, ta adol ga idio muriai ngan malo kapei toa ne, ngan tibur toa aea ul kapei tau. ");
INSERT INTO bch_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Adol korol apu aea toa oa ga idudunga ngan tibur toa aea ul kapei tau, ta akapin korol toa oa ngan ipao. Korol ipao toa oa, eine tibur toa sing isamum panua led kadonga sasat, ta lolog itarui mulian ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Ga kus ta abada popou toa iman tenainga bret aea, ta adol leg palata iloleai, ngan tibur toa aea ul kapei tede pan not. Be adol lam iae ngan leg palata ilolo toa oa pan saut. ");
INSERT INTO bch_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Be manta akado malo kemi ede pade iman leg palata iaoa aea pakalanga. Be apasogo malo toa ne ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be manta akeo pan eaba mosi aea ta isaisai gid sogonga kemikemi ga idae ngan. ");
INSERT INTO bch_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Abada abei akas ta akado malo toa ne aea kadanga lima, ta amol gid ngan gol ikatinge babanga. Ga kus ta apatoi gid lingau gol ta iman malo kapei toa ne aea tutunga. Manta akado gid kadanga toa lima ne toman ngan ad ipu bras.” ");
INSERT INTO bch_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Deo ikeo pade bedane, “Gimi manta abada abei akas ta akado popou tenainga aea ngan. Aea gadae ga iluai bageda aea makor iadag, be aea mamarae ga aea babanga ga iuot lalaede ga iluai leoa ede ga ilia iluai bageda aea makoreai. ");
INSERT INTO bch_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Be gadae ngan popou igal toa pange ne, asap danga pange imata mambe bulmakao aea pelenga. Be manta asap popou igal toa pange oa toman ngan aea pelenga ngan abei akas ikatinge kelede. Be manta aluga popou tenainga aea isal toa ngada oa toman ngan aea pelenga ngan gid bras ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Ga pade, manta akado gid tabla iman dinga itae aea tadonga, ga dinga itae aea doidoinga, ga gid loba ngan dolnga masilau ising ngan, ga gid duduinga iman masilau imedameda aea galnga, ga gid lalate iman dinga aea badanga. Danga toa ngada ne akakado ngan bras kekelen. ");
INSERT INTO bch_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Ga pade, manta akado popou toa ne aea kakari bras iman dinga aea. Be akado toman ngan aea koea pange toa tidae ngan igal toa pange oa. ");
INSERT INTO bch_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Be ngan popou iae toa pange ne, apatoi bras idanga ede ga idae iae irabuiai, ta iman kakari bras aea kisinga. ");
INSERT INTO bch_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Ga kus ta abada abei akas ta akado sig rua ta amol gid ngan bras ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Sig toa rua ne iman popou aea bisinga. Asabun gid ngan popou aea koea toa pange oa, sig ede iadag, ga sig ede pade iadag. ");
INSERT INTO bch_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Gimi ga adid popou toa ne ngan abei ikatinge kemikemi, be atnan iaoa gadio ga gadae ga idio ibangabanga. Akado ga iuot lalaede mambe ianun toa napasolan pago lusiai.” ");
INSERT INTO bch_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Deo ikeo pade bedane, “Gimi manta abada malo kemikemi ta asilasila ga ibalil ngan leg palata. Be silasila toa ne ikarkare pan saut, aea mamarae ga iuot sangaul rua leoa lima. ");
INSERT INTO bch_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Be manta akado silasila ikarkare toa ne toman ngan aea kadanga sangaul rua. Be akado gid kadanga ipu bras sangaul rua pade iman gid kadanga ad pagunnga. Be ngan gid kadanga kelede kelede, akado gid lingau silva ga tabalanga silva pade. ");
INSERT INTO bch_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Be silasila toa ne ikarkare pan not, eine ga iuot lalaede mambe iadag aea pade. Aea mamarae ga iuot sangaul rua leoa lima. Be akado aea kadanga sangaul rua toman ngan ad kadanga ipu bras sangaul rua pade iman gid kadanga ad pagunnga. Be ngan silasila aea kadanga kelede kelede, akado gid lingau silva ga tabalanga silva pade. ");
INSERT INTO bch_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Be silasila toa palata imuriai oa, aea mamarae ga iuot sangaul ede leoa rua aea mana. Be akado silasila toa oa aea kadanga sangaul toman ngan ad kadanga ipu bras sangaul pade iman gid kadanga ad pagunnga. Be akado aea malo lalaede toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Be silasila iaoa toa ado ele parangai, aea mamarae ga iuot sangaul ede leoa rua aea mana. ");
INSERT INTO bch_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Be ngan silasila iaoa isal iadag ga iadag, apakantutu malo rua, ede iadag, ede pade iadag, ad mamarae iuot leoa tol ga ilia iluai bageda aea makor iadag. Akado silasila iaoa isal toa rua ne toman ngan kadanga lima ga ede, tol iadag, ga tol pade iadag, toman ngan ad kadanga ipu bras. ");
INSERT INTO bch_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Be akado silasila iaoa aea malo kemi ede, aea mamarae ga iuot leoa lima. Be akeo pan eaba mosi aea ta ipasogo malo toa ne ngan gid oaro salumu aea singsingia ga singsingia tede ga bil. Be akado silasila iaoa aea malo toa ne toman ngan aea kadanga pange ga kadanga ipu bras pange pade. ");
INSERT INTO bch_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Manta akado silasila aea kadanga toa ngada ne toman ngan ad tabalanga silva ga ad lingau silva ga ad kadanga ipu bras. ");
INSERT INTO bch_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Silasila toa ne aea mamarae ga iuot sangaul rua leoa lima. Be aea babanga ga iuot sangaul ede leoa rua aea mana. Akado silasila aea malo toa ngada ne ngan gid malo kemikemi. Be silasila aea gadae ga iuot leoa ede ga ilia iluai bageda aea makoreai. Be akado aea kadanga ipu ngan bras. ");
INSERT INTO bch_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Be manta abada bras kekelen ta akado ngan leg palata aea danga naurata aea toa ngada ne. Ga pade, akado kisinga bras gereirei ngan kisinga gid oaro palata aea, ta muriai agin gid ga tidudunga tanoeai.” ");
INSERT INTO bch_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Deo ikeo pan Moses pade bedane, “Keo pagid panua Israel ta tibada bude kemi oliv aea ga inam, ta iman gid lam aea ta titaratara somisomi. ");
INSERT INTO bch_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aron toman ngan ele gergeu arangaranga ga tibada gid lam toa ne ga tidudunga leg palata iloleai ngan tibur toa nalup toman ngan gid. Gid lam toa ne ga ienono leg palata iloleai ngan tibur toa aea ul kapei tede, boloma ngan malo kapei toa ipamumul korol apu aea. Be ado ga ado, Aron ga ele gergeu arangaranga ga tiparere bude ngan gid lam, ta titaratara gau matageai somisomi lailai ga irangrang ngan gaisala. Gimi Israel toman ngan lemi gergeu ga tibutibumi tiuotot muriai, manta anasnasi apu toa ne ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Deo ikeo pade bedane, “Oangga eao luago mulian, manta baba tadim kapei Aron toman ngan ele gergeu arangaranga Nadap ga Abiu ga Eleasar ga Itamar, ta tinam timadid rol ngan gid panua Israel. Ta eao ga dol gid ga timan leg panua tenainga ad. ");
INSERT INTO bch_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Eao ga kado sogonga kemikemi tenainga aea ton tadim kapei Aron ngan pasogonga ei. Sogonga toa oa aea ul pade. Toa bedaoa ta ieda kapei, ta gid Israel ga tilolon ngan ei. ");
INSERT INTO bch_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Gau nabada oatainga pagid panua edengada ngan kadonga mosi ngan malo kemikemi. Ta eao ga keo pagid ta tikado sogonga tenainga aea ton Aron. Ta Aron ga idol gid sogonga toa oa ngan ado toaiua nadol aea ul ngan kadonga leg naurata tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Gid sogonga tenainga aea, manta tikado ga bedane: igogo aea malo kakauede toa aea sogonga kemikemi, ga irabu aea malo, ga ele pononga mamarae, ga ele siot toa aea sogonga kemikemi, ga malo ede pade iman ilabora aea molnga, ga irabu aea pus. Sogonga toa ne aea ul pade. Gid panua mosi ad ga tikado gid sogonga toa ne ton Aron ga ele gergeu arangaranga, ngansa gid ga tikado leg naurata tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ngan kadonga sogonga toa ngada ne, gid panua mosi ad ga tibada malo kemikemi ta tipasogo gid ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be manta tiuaoai gid oaro gol gereirei ga idae ngan pade. ");
INSERT INTO bch_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Gid panua mosi ad ga tibada malo kemi ede ngan kadonga Aron irabu aea malo. Be manta tipasogo malo toa oa ngan gid oaro gol gereirei ga oaro salumu aea singsingia ga singsingia tede ga bil. ");
INSERT INTO bch_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Be gadae ngan irabu aea malo toa ne, manta tisaisai ikepe aea oaro rua, iman kaukaunga aea. ");
INSERT INTO bch_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Ga pade, manta tibada oaro salumu aea singsingia ga singsingia tede ga bil ta tikado irabu aea pus. Be manta tiuaoai gid oaro gol gereirei ga idae ngan pade. Ga kus ta tisaisai pus toa ne ga idae ngan irabu aea malo toa oa imata, ta ila iuot mambe malo kelede. ");
INSERT INTO bch_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Ga pade, manta tibada pat oniks rua ta titotoi Iakop ele gergeu sangaul igegea rua edad ngan. ");
INSERT INTO bch_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Manta titotoi edad ga inasi ad poponga, lima ga ede ngan pat ede, ga lima ga ede ngan pat ede pade. ");
INSERT INTO bch_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Manta dol naurata toa ne ngan eaba ede toa ele oatainga kapei ngan ketnga mosi ga idae ngan pat. Ta ei ga ibada gol ta ikado pat toa rua oa ipu ad kisinga toman ngan ad sogonga kemikemi. ");
INSERT INTO bch_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Ga kus ta panua mosi ad ga tikaukau pat toa rua ne ga tidae ngan ikepe aea oaro rua toa mugaeai tikaukau ngan irabu aea malo. Ta pat toa rua ne iman kilala ngan gid lum sangaul igegea rua togid Israel. Toa bedaoa ta Aron ga ibisibisi edad ngan pat toa rua oa, ta gau ga nagera ta matag nanan leg panua somisomi. ");
INSERT INTO bch_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Manta tibada gol kemikemi ngan kadonga pat toa rua oa ipu ad kisinga toman ngan ad sogonga kemikemi. ");
INSERT INTO bch_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","Ga pade, manta tipilai oaro gol rua ta iuot mambe kenga, ta tikaukau oaro toa rua ne ga tidae ngan pat toa rua oa ipu ad kisinga gol.” ");
INSERT INTO bch_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Deo ikeo pade bedane, “Eao manta keo pan eaba mosi aea ta ikado eaba tenainga aea igogo aea malo kakauede toa ilualua ei ngan badanga oatainga ngan Deo ele kimnga. Akado malo kakauede toa ne aea sogonga ga iuot lalaede mambe eaba tenainga aea irabu aea malo. Asaisai malo toa ne ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be manta aoaoai gid oaro gol gereirei ga tidae ngan pade. ");
INSERT INTO bch_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Akado malo kakauede toa ne aea mamarae ga iluai bageda aea makoreai, be aea babanga iluai bageda aea ubereai. Akop malo toa ne ga idio irabuiai, ta aea mamarae ga aea babanga imata lalaede, ta kopnga toa ne iman danga rua aea dolnga. ");
INSERT INTO bch_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Ga kus ta abada gid pat sangaul igegea rua toa aea olnga kapei tau. Be apatoi gid ga tidae ngan ipu ad kisinga ngan malo kakauede toa ne pan gaot. Alalo gid pat toa ne ngan iaoa pange. Ngan iaoa toa imuga oa, alalo pat rubi singsingia, ga pat topas eangonga, ga pat beril singsingia tau. ");
INSERT INTO bch_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Be ngan pat iaoa ede pade, alalo pat terkois birbirianga, ga pat sapaia bil, ga pat emeral birbirianga. ");
INSERT INTO bch_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Be ngan pat iaoa tol aea, alalo pat iasint singsingia tede, ga pat aget eangonga tede, ga pat ametis singsingia tau. ");
INSERT INTO bch_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Be ngan pat iaoa pange aea, alalo pat krisolait birbirianga, ga pat oniks mariluangge, ga pat iaspa birbirianga. Be manta apatoi gid pat kelede kelede ngan ipu ad kisinga gol. ");
INSERT INTO bch_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ngan gid pat toa sangaul igegea rua ne, manta atotoi Iakop ele gergeu arangaranga sangaul igegea rua edad. Gid panua toa ne timugamuga ngan gid lum sangaul igegea rua togimi Israel. ");
INSERT INTO bch_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Ga pade, manta abada gol kemikemi ta apilai oaro gol rua ta tiuot mambe kenga, ta iman eaba tenainga aea igogo aea malo kakauede aea kisinga. ");
INSERT INTO bch_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Manta akado malo toa ne aea koea gol rua, ta asaisai gid ga tidae ngan malo igal rua pan gadae. ");
INSERT INTO bch_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Ga kus ta asaun gid oaro gol rua ta tidudunga ngan gid koea toa rua oa. ");
INSERT INTO bch_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Be gid oaro gol matad iadag, manta akaukau ga tidae ngan gid pat ipu ad kisinga gol toa rua oa. Ta akaukau kisinga gol toa oa ngan ikepe aea oaro ta ikisi irabu aea malo. ");
INSERT INTO bch_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Ga pade, akado koea gol rua pade ta asaisai gid ga tidae muriai ngan igogo aea malo kakauede igal toa rua oa pan gadio, boloma ngan irabu aea malo. ");
INSERT INTO bch_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Be akado koea gol rua pade ta apatoi gid ga tidae ngan ikepe aea oaro toa mugaeai tikaukau ngan irabu aea malo, boloma ngan irabu aea pus. ");
INSERT INTO bch_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ga kus ta abada gid oaro salumu aea bil ta asaisai ga tidae ngan gid koea ngan igogo aea malo. Be oaro matad iadag, eine ga akaukau ga tidae ngan irabu aea malo, boloma ngan irabu aea pus. Toa bedaoa ta igogo aea malo irangrang ngan bir ga bir mao. ");
INSERT INTO bch_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Tota oangga Aron idudunga palata iloleai, ngan tibur toa aea ul kapei tede, eine Israel ele gergeu arangaranga edad ga ienono ngan igogo aea malo, ta gau ga nagera ta matag nanan leg panua somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ga pade, manta abada danga rua ilualua eaba tenainga aea ngan badanga oatainga ngan Deo ele kimnga, ta adol gid ga tidudunga ngan igogo aea malo aea kopnga. Tota oangga Aron idudunga leg palata iloleai ta inam boloma pagau, eine danga toa rua oa ga ienono boloma igogoeai, ta ilualua ei ngan badanga oatainga ngan saoa danga nakim gid Israel tikakado.” ");
INSERT INTO bch_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Deo ikeo pade bedane, “Gimi manta abada malo bil ta akado eaba tenainga aea ele pononga mamarae ngan. ");
INSERT INTO bch_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Be atal pononga mamarae toa ne aea baba ngan ilabora idudunga ngan. Be manta asaisai baba toa ne toman ngan igagal aea malo ga iuot matoltol teta ta irangrang ngan itakai mao. ");
INSERT INTO bch_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Ga pade, apasogo pononga mamarae toa ne iaoa aea les ngan oaro salumu aea singsingia ga singsingia tede ga bil. Akado sogonga toa ne ga imata mambe abei pomigranet itautau. Be akaukau gid golo gereirei toa tikado ngan gol, ta apalapala gid toman ngan abei pomigranet itautau anunud toa oa. ");
INSERT INTO bch_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Oangga Aron ikakado ele naurata tenainga aea, manta idol pononga mamarae toa ne. Tota oangga idudunga leg palata iloleai ga inam pagau, ngan tibur toa aea ul kapei tede, mao oangga itnan tibur toa oa ga iuot, eine gid panua ga tilongo gid golo greng ga greng. Toa bedaoa ta irangrang ngan imate toa eoa mao. ");
INSERT INTO bch_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Ga pade, manta akado gol ikatinge kakauede ta atotoi posanga ga idae ngan bedane: Maron ele ul ienono ngan. ");
INSERT INTO bch_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Be abada oaro salumu aea ede bil, ta akaukau gol ikatinge toa ne ga idae ngan ilabora aea malo, gadae ngan imata. ");
INSERT INTO bch_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Gol ikatinge toa aea posanga ienono ngan ne, manta ienono gadae ngan Aron imata somisomi. Toa bedaoa ta gau, Maron Deo togimi, ga nababada lemi tenainga isaoa adol ul ngan ga inam pagau, ta gau ga nakim. Ta oangga panua tenainga ad tinasi gid apu tenainga aea tutui mao, eine led idil paeamao ga idae ngan Aron, ta gau ga nasamum kadonga sasat toa oa. ");
INSERT INTO bch_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Be manta abada oaro salumu aea kemikemi ta aoaoai ele siot ga ilabora aea malo. Ga pade, manta akeo pan eaba mosi aea ta iuaoai irabu aea pus, ga isaisai aea sogonga kemikemi ga idae ngan. ");
INSERT INTO bch_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Ga pade, manta akado Aron ele gergeu arangaranga led siot, ga rabud aea pus, ga gid malo laborad aea. Toa bedaoa ta tisogo ngan, ta edad iuot kapei panua matadeai, ta tilolon ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Be oangga apasogo Aron ga ele gergeu arangaranga ngan gid sogonga toa ngada ne ga kus, atok bude ga idae laboradeai, ngan dolnga ad ul ngan kadonga leg naurata. ");
INSERT INTO bch_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Be manta akado led sainga ngan robinga tinid pan luad ga isulug buledeai. ");
INSERT INTO bch_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Somisomi oangga Aron ga ele gergeu arangaranga tila boloma ngan leg popou tenainga aea, mao oangga tidudunga ngan leg palata ngan tibur toa aea ul kapei tede, manta tidoldol sainga toa ne. Oangga mao, eine led idil paeamao ta timate. “Somisomi Aron ga ele gergeu ga itubtub toa tiuotot muriai, manta tinasnasi apu toa ne.” ");
INSERT INTO bch_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Deo ikeo pan Moses pade bedane, “Eao manta nasi kadonga ga bedane ngan dolnga Aron ga ele gergeu arangaranga ad ul ta tiuot leg panua tenainga ad. Bada bulmakao aranga ede daenga pau ga sipsip arangaranga rua toa ad tibun eta mao. ");
INSERT INTO bch_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Ga pade, bada wit aea plaoa kemikemi toa aea yis ienono ngan mao, ta kado bret imata tol ga bedane: Kado bret ede toa abul toman ngan bude, ga bret ede pade toa abul toman ngan bude mao, ga bisket toa asama ngan bude pade. ");
INSERT INTO bch_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Dol gid bret toa oa ga idio ngan samare ede, ta bada ga inam pagau toman ngan bulmakao ga sipsip toa rua oa. ");
INSERT INTO bch_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","“Ga kus ta bada Aron toman ngan ele gergeu arangaranga ta tila timadid leg palata iaoai, ta paliliu gid toa eoa. ");
INSERT INTO bch_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Ga kus ta pasogo Aron ngan gid sogonga tenainga aea. Dol siot ga idae ngan ei, ga pononga mamarae, ga irabu aea malo, ga igogo aea malo kakauede. Kaukau irabu aea malo toa oa toman ngan irabu aea pus toa gid panua mosi ad tiuaoai. ");
INSERT INTO bch_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ga kus ta dol ilabora aea malo, ta kaukau gol ikatinge kakauede toa aea posanga ienono ngan oa ga idae ngan ilabora aea malo. Gol ikatinge toa oa iman kilala ngan aea ul. ");
INSERT INTO bch_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ga kus ta bada bude toa iman kilala ngan gid danga sisid togau, ta tok ga idae ilaborai ngan dolnga ei ga iman leg eaba tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","“Ga kus ta bada ele gergeu arangaranga ga tinam ta pasogo gid ngan led siot ");
INSERT INTO bch_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ga laborad aea malo. Ga kus ta kaukau rabud ngan ad pus. Ngan kadonga toa bedane eao ga dol Aron ga ele gergeu ga timan leg panua tenainga ad. Ta gid iaoa toaine ga led gergeu ga tibutibud tiuotot muriai, eine ga tikakado leg naurata tenainga aea somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Ga kus ta bada bulmakao tenainga aea ga inam boloma leg palata iaoai. Ta Aron ga ele gergeu arangaranga ga tidol baged ga idae ngan ilabora. ");
INSERT INTO bch_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Ngan gau matag, boloma ngan leg palata iaoa, totoi bulmakao toa oa. ");
INSERT INTO bch_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Ga kus ta doi ising kauteta, ta dol bagem igonga ga idudunga ngan, ta sama sing toa oa ga idae ngan popou aea pelenga toa pange oa. Be sing ilia ienono maitne, tok ga isulug popou ibuloloeai. ");
INSERT INTO bch_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Ga kus ta bada bulmakao ilolo imona, ga aea toboloa idanga kemi, ga iaule toa rua oa toman ngan imona, ta dol ga idae dingaeai ngan leg popou tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Be bada imedameda ga itin kukul ga itae imogaleai, ta nono gid ngan dinga ede pade gaot ngan saupu. Bulmakao toa ne eine tenainga ngan samumnga kadonga sasat. ");
INSERT INTO bch_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Ga kus ta bada sipsip tenainga aea eta ngan gisirua, ta Aron toman ngan ele gergeu arangaranga ga tidol baged ga idae ngan ilabora. ");
INSERT INTO bch_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Be eao ga totoi sipsip toa oa, ta doi ising kauteta ta til ga idae ngan popou tenainga aea isal toa pange oa. ");
INSERT INTO bch_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Totoi sipsip toa oa ga kus, ta sigiri iae ga idanga sisid toa ngada oa iloleai, ta dol gid ga tidae dingaeai toman ngan ilabora ga ikatinge padengada. ");
INSERT INTO bch_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ta dinga ga inono sipsip ikatinge toa ngada oa ga imomout ga kus. Eine lemi tenainga ga inam pagau Maron. Ta gau ga tinig igelgel ngan iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Be sipsip tenainga aea toa ede pade oa, Aron ga ele gergeu arangaranga ga tidol baged ga idae ngan ilabora. ");
INSERT INTO bch_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Ta eao ga totoi, ta doi ising kauteta. Ta sama sing toa oa ga idae ngan Aron ga ele gergeu arangaranga kelede kelede tangad oatai iuaro, ga baged oatai igonga kapei, ga aed oatai igonga kapei. Ga kus ta til sing ga idae ngan popou tenainga aea isal toa pange oa. ");
INSERT INTO bch_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Ga kus ta bada sing kautede ienono popouiai toman ngan bude iman kilala ngan gid danga sisid togau, ta til ga idae ngan Aron, ga ele gergeu arangaranga, ga ad sogonga tenainga aea. Kado toa bedaoa ngan dolnga leg ul ngan gid toman ngan ad sogonga ta timan gau leg. ");
INSERT INTO bch_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Be sipsip toa idae dingaeai maitne, eine sipsip tenainga aea ngan dolnga leg panua tenainga ad ngan led naurata. Be bada sipsip toa na imona, ga iuui imona, ga ilolo imona, ga aea toboloa idanga kemi, ga iaule toa rua oa toman ngan imona, ga ibule oatai, ta dol gid ga tidae Aron ga ele gergeu arangaranga bagedai. ");
INSERT INTO bch_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Be ngan samare toa iuon ngan bret aea yis ienono ngan mao, toa ienono matageai, eao ga bada bret kelede kelede imata tol ga bedane: bret ede toa abul toman ngan bude, ga bret ede pade toa abul toman ngan bude mao, ga bisket toa asama ngan bude. ");
INSERT INTO bch_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Dol gid bret toa ne pade ga idae Aron ga ele gergeu arangaranga bagedeai. Ta gid ga tipatambolembole gau matageai. ");
INSERT INTO bch_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ga kus ta bada danga sisid toa bagedeai, ta dol ga idae dingaeai, ta dinga ga inono ga imomout ga kus toman ngan sipsip tenainga aea ede pade. Eine lemi tenainga ga inam pagau Maron. Ta gau ga tinig igelgel ngan iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Be sipsip toa idae dingaeai maitne, eao ga bada igogo ta patambolembole gau matageai. Ga kus ta iman eao am eaneannga aea. ");
INSERT INTO bch_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Be somisomi oangga adol eaba ga iman leg eaba tenainga aea, manta adol ul ngan sipsip igogo, ta akisi ngan bagemi, ta apatambolembole matageai. Be adol ul pade ngan sipsip tenainga aea ibule. Ga kus ta masilau ikatinge toa rua ne iman Aron ga ele gergeu ad eaneannga aea. ");
INSERT INTO bch_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Somisomi oangga gid Israel tikakado tenainga eaneannga aea ngan kadonga lolomai kelede, masilau ikatinge toa rua ne ga iman Aron ga ele gergeu arangaranga ad. Gid Israel ga tikakado tenainga toa bedane ga inam pagau Maron. ");
INSERT INTO bch_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Be gau nadol ul ngan Aron ele sogonga tenainga aea. Tota muriai, oangga Aron imate, eine sogonga toa oa ga iman ele gergeu arangaranga ga itubtub led. Toa bedaoa ta gid ga tidol sogonga toa ne ngan ado toaiua titok bude ga idae laboradeai ngan dolnga gid ga tiuot leg panua tenainga ad. ");
INSERT INTO bch_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Oangga Aron ele gergeu eta ibada imul ta iuot madidnga kapei tenainga aea, ei manta idol sogonga toa ne irangrang ngan ado lima ga rua. Be ngan ado toa lima ga rua oa, ei ga idudunga leg palata iloleai ngan tibur toa aea ul kapei tede, ta ikakado leg naurata. ");
INSERT INTO bch_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Be oangga eao dol Aron ga ele gergeu ga timan leg panua tenainga ad, manta bada sipsip tenainga aea imedameda, ta nono ngan tibur ede aea ul, gadudunga ngan leg palata aea silasila. ");
INSERT INTO bch_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Be Aron ga ele gergeu arangaranga ga tibada imedameda toa oa toman ngan bret ienono ngan samare, ta tian boloma leg palata iaoai. ");
INSERT INTO bch_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ngan ado toaiua tidol ad ul ga timan leg panua tenainga ad, gid ga tian annga tenainga aea toa oa. Tenainga toa oa iman led kadonga sasat aea samumnga. Gid kekelegid tirangrang ngan eannga annga toa oa. Eaba eta pade irangrang ngan ian mao, ngansa annga toa oa aea ul pade. ");
INSERT INTO bch_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Be oangga sipsip toa oa imedameda toman ngan bret toa oa ienono ga gaisala, eine irangrang ngan tian mao. Manta tinono ngan dinga ga imomout ga kus, ngansa annga toa oa aea ul pade. ");
INSERT INTO bch_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Eao manta kado danga toa ngada ne ngan dolnga Aron toman ngan ele gergeu arangaranga ta timan leg panua tenainga ad. Ta kado toa bedane ga irangrang ngan ado lima ga rua, mambe nakeo pago ngan. ");
INSERT INTO bch_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ngan ado toa lima ga rua ne, manta tenai bulmakao kelede kelede ngan samumnga led kadonga sasat. Be kado tenainga ede pade ngan sigiringa popou tenainga aea. Toa bedaoa ta popou tenainga aea ga iuot kemi matageai. Be manta tok bude ga idae ngan popou tenainga aea, ngan dolnga leg ul ngan ta iman danga togau. ");
INSERT INTO bch_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Irangrang ngan ado lima ga rua, eao manta kado bedane ngan popou tenainga aea. Toa bedaoa ta popou tenainga aea oa, aea ul kapei tau. Be oangga sai isibo leg popou tenainga aea, mao oangga danga eta idae tos ngan, eine aea ul pade ta iman leg.” ");
INSERT INTO bch_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Deo ikeo pade bedane, “Ado ga ado gimi manta abada sipsip ruangada, ad rai kelede, ta atenai gid ga tidae ngan leg popou tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Atenai ede gaisala, be ede pade lailai. ");
INSERT INTO bch_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Oangga gaisala, atenai sipsip toa oa toman ngan wit aea plaoa kemikemi, aea kulupu irangrang mambe kilo kelede, ta abul toman ngan bude oliv aea, aea lita kelede. Ga pade, atok oain aea lita kelede ga iman lemi tenainga ga inam pagau. ");
INSERT INTO bch_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Be oangga lailai, ta atenai sipsip ede pade toa bedaoa toman ngan wit aea plaoa ga bude ga oain lalaede mambe akado gaisala. Adol tenainga toa ne ga idae dingaeai ta iman lemi tenainga ga inam pagau Maron. Ta gau ga nakim iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Somisomi muriai, gimi manta anono tenainga toa ne ngan dinga ga imomout ga kus. Be gimi ga akakado tenainga ado ga ado toa bedaoa gau matageai, boloma ngan leg palata iaoa. Toa eoa ga nalup toman ngan gimi ta naposaposa pagimi. ");
INSERT INTO bch_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Be gau ga nalup toman ngan gid Israel toa eoa pade. Ta leg taranga kapei ga iuot ta irobi leg palata, ta ikado tibur toa oa aea ul kapei, ta gid panua tilolon ngan. ");
INSERT INTO bch_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Toa bedaoa ta gau ga nadol ul ngan leg palata ga popou tenainga aea ga nadol ul ngan Aron pade toman ngan ele gergeu arangaranga ta timan gau leg, ta gid ga tikakado leg naurata tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Ta gau ga namamado rabu ngan gimi Israel ta naman ami Deo. ");
INSERT INTO bch_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Toa bedaoa ta gimi ga aoatai kemi mambe gau eine Maron Deo togimi. Gau Deo toa nabada gimi ta atnan Isip ga anam. Nakado toa bedaoa ngansa naoangga namamado rabu ngan gimi. Gau Maron Deo togimi.” ");
INSERT INTO bch_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Deo ikeo pade bedane, “Gimi manta abada abei akas ta akado popou tenainga aea ede pade, iman nabene aea nononga. ");
INSERT INTO bch_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Popou toa ne aea mamarae ga aea babanga ga iuot lalaede ga iluai bageda aea makoreai. Be aea gadae ga iluai gogodai. Be ngan popou ipao igal toa pange oa, asap gid danga imata mambe bulmakao aea pelenga. Be akado popou ipao toman ngan aea pelenga ngan abei akas ikatinge kelede. ");
INSERT INTO bch_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Ga kus ta abada gol kemikemi ikatinge babanga, ta aluga ngan popou isal toa pange oa, ga ipao, ga aea pelenga. Be apatoi gol idanga ede mamarae ga iman popou aea lapinga ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Be gadio ngan lapinga toa oa, apatoi koea gol rua, ede ngan isal iadag, be ede pade ngan isal iadag, ta iman sig ad sabunnga ngan popou aea bisinga. ");
INSERT INTO bch_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Be abada abei akas ta akado sig rua, ga kus ta amol gid ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ga kus ta adol popou nabene aea toa ne ga idio leg palata iloleai, ngan tibur toa aea ul kapei tede, boloma ngan malo kapei, be iadag ngan korol apu aea ipao. Ngan korol ipao toa oa sing isamum panua led kadonga sasat, ta lolog itarui mulian ngan gid. Be nalup toman ngan gimi toa eoa pade. ");
INSERT INTO bch_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Gaisala ngan ado ga ado, Aron ga idudunga leg palatai ngan patutuinga gid lam. Be oangga ikado bedaoa, manta inono nabene iuad kemi ngan popou toa ne. ");
INSERT INTO bch_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Be lailai, oangga Aron itun gid lam pade, manta inono nabene toa bedaoa pade. Tota nabene ga ibung ga idae gau matageai ado ga ado ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Be irangrang ngan gimi atenai nabene eta pade ngan popou toa ne mao. Ga pade, irangrang ngan atenai masilau eta, mao wit eta, mao oain eta ga idae ngan popou toa ne mao. ");
INSERT INTO bch_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Be pakelede ngan rai ga rai, Aron ga ikado ga popou nabene aea toa ne iuot kemi gau matageai. Ei ga inasi bedane: Ei ga ibada sing kauteta ngan masilau tenainga aea ngan samumnga panua led kadonga sasat. Ga kus ta isama ga idae ngan popou toa ne aea pelenga toa pange oa. Manta panua tenainga ad tinasi kadonga toa ne ga ilalala ga ila. Toa bedaoa ta popou toa ne ga iman danga togau Maron, ta aea ul kapei tau.” ");
INSERT INTO bch_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Idio ta Maron ikeo pan Moses bedane, ");
INSERT INTO bch_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Oangga eao oade gid Israel dabad, eaba kelede kelede manta ibada pat ga inam pagau Maron ngan olnga ei mulian. Ngan kado ta imate. Ngan ado toaiua eao oade gid, oangga tiuol gid mulian ngan pat toa oa, eine pamukurunga paeamao eta ga iuot ngan gid mao. ");
INSERT INTO bch_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Panua toa ngada oa tiuade dabad ga kus, manta tibada pat silva kelede ga iman tenainga ga inam pagau Maron. Manta tibada pat silva imata lalaede mambe gid panua tenainga ad led pat. ");
INSERT INTO bch_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Gimi ga aoade arangaranga toa ngada oa ad rai sangaul rua ga idae, ta gid kekelegid manta tibada tenainga toa ne ga inam pagau Maron. ");
INSERT INTO bch_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Be gid panua toa led danga sisid busa tirangrang ngan tibada pat busa ga inama mao. Be gid panua lululunga ad pade, tirangrang ngan tibada pat kautede ga inama mao. Gid toa ngada oa manta tibada pat idaba lalaede toa bedane ga inam pagau Maron. Ngan tenainga toa ne tiuol gid mulian. Ngan kado ta timate. ");
INSERT INTO bch_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Eao ga bada pat toa ne ga inam ta dol ngan luanga leg palata aea naurata. Ta gau ga nagera pat toa ne ta matag nanan leg panua Israel. Oangga tikado toa bedaoa, eine ga lolog itarui mulian ngan gid, ta gid ga timate mao.” ");
INSERT INTO bch_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Maron ikeo pan Moses pade bedane, ");
INSERT INTO bch_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Gimi manta abada bras ta akado tabla kapei eta toman ngan aea popou. Tabla toa ne iman panua tenainga ad baged ga aed aea sigiringa. Adol tabla toa ne ga idio rabu ngan leg popou tenainga aea ga leg palata. Ga kus ta atok eau ga idudunga ngan. ");
INSERT INTO bch_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aron ga ele gergeu arangaranga manta tisigiri baged ga aed ngan eau toa oa. ");
INSERT INTO bch_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Somisomi oangga tidudunga leg palatai, manta tisigiri baged ga aed, ngan kado ta timate. Ga pade, oangga tila boloma ngan leg popou tenainga aea ngan kadonga gid tenainga ga inam pagau ga idae dingaeai, ");
INSERT INTO bch_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","manta tisigiri baged ga aed, ngan kado ta timate. Gid toman ngan led gergeu ga tibutibud tiuotot muriai, manta tinasnasi apu toa ne ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Maron ikeo pan Moses pade bedane, ");
INSERT INTO bch_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Eao manta bada gid danga iuad kemikemi ga bedane: abei mer itekea toa aea kulupu irangrang mambe kilo lima ga ede, ga abei sinamon itin kukul toa aea kulupu irangrang mambe kilo tol, ga piso iuad kemi toa aea kulupu irangrang mambe kilo tol pade, ");
INSERT INTO bch_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ga abei kasia itin kukul toa aea kulupu irangrang mambe kilo lima ga ede, ga bude oliv aea lita pange. ");
INSERT INTO bch_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Be keo pan eaba ede toa ele oatainga kapei ngan kadonga danga sisid iuad kemi, ta ei ga ibul gid danga toa ne ga iuot mambe bude ede iuad kemi. Bude toa ne aea ul, ta iman kilala ngan danga sisid togau. ");
INSERT INTO bch_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Ga kus ta bada bude toa ne kauteta ta tok ga idae ngan leg palata, ga korol apu aea, ");
INSERT INTO bch_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ga popou bret aea toman ngan aea danga sisid, ga lam iae toman ngan aea danga sisid, ga popou nabene aea, ");
INSERT INTO bch_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","ga popou tenainga aea toman ngan aea danga sisid, ga tabla eau aea toman ngan aea popou. ");
INSERT INTO bch_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Eao ga tok bude toa ne ga idae ngan gid danga sisid toa ngada ne ngan dolnga leg ul ga idae ngan ta timan gau leg. Be oangga danga eta idae tos ngan danga sisid toa oa, eine aea ul pade ta iman leg. ");
INSERT INTO bch_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Ga kus ta tok bude toa ne kauteta ga idae ngan Aron ga ele gergeu arangaranga, ngan dolnga ad ul ta timan leg panua tenainga ad ngan kadonga leg naurata. ");
INSERT INTO bch_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Be eao manta keo pagid Israel bedane, ‘Somisomi muriai, bude toa ne iman kilala ngan gid danga sisid ton Deo. Bude toa ne aea ul pade. ");
INSERT INTO bch_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Irangrang ngan gimi atok ga idae ngan gid panua sapaean tinid mao. Be irangrang ngan akado bude eta lalaede toa bedane mao, ngansa bude toa ne aea ul. Ta gimi manta alolon ngan. ");
INSERT INTO bch_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Oangga sai ikado bude eta lalaede toa bedane, mao oangga eaba eta itok ga idae ngan panua sapaean, manta asuk ei ga ila aluai ngan gid iaoa kelede togimi.’” ");
INSERT INTO bch_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Maron ikeo pan Moses pade bedane, “Eao manta bada gid danga sisid iuad kemikemi ga bedane: paura toa tikado ngan abei mer itekea, ga paura toa tikado ngan mase ipat, ga abei galbanum itekea, ga paura toa tikado ngan abei libanon itekea. Danga toa ngada ne eao bada, manta ad kulupu iuot lalaede mon. ");
INSERT INTO bch_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Be eao ga keo pan eaba ede toa ele oatainga kapei ngan kadonga danga sisid iuad kemi, ta ei ga ibul gid danga toa ne ta iuot mambe nabene ngan kadonga basu iuad kemi. Be manta adol sol kauteta ngan, ta ikado nabene toa ne ga iuot kemi matageai, be leg ul ienono ngan. ");
INSERT INTO bch_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ga kus ta alumu danga toa ngada ne ga ibilin ga ila gereirei. Io, akado bedaoa ga kus ta adol nabene toa ne idanga ede ga idio leg palata iloleai, iadag ngan korol apu aea. Ngan tibur toa oa, gau ga nalup toman ngan gimi. Be nabene toa ne aea ul kapei tau. Manta alolon ngan. ");
INSERT INTO bch_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ta irangrang ngan gimi akado lemi nabene eta lalaede toa bedane mao. Ngansa eine danga togau Maron, be leg ul ienono ngan, ta gimi manta alolon ngan. ");
INSERT INTO bch_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Oangga sai ikim nabene iuad toa ne ta ikado ele nabene ga iuot lalaede toa bedane, manta asuk ei ga ila aluai ngan gid iaoa kelede togimi.” ");
INSERT INTO bch_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Maron ikeo pan Moses pade bedane, ");
INSERT INTO bch_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ega, gau nasio eaba ede ieda Besalel. Ei Uri inat ga Ur itub ngan lum pan Iuda. ");
INSERT INTO bch_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Be gau nadol Tautaudig Tutui ga idio pan ta nakado ga ele oatainga kapei ga ilolo iuatai ngan kadonga naurata imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Ta ei ga irangrang ngan ikado mosi ngan gol ga silva ga bras. ");
INSERT INTO bch_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Be ele oatainga kapei ngan ketnga gid pat toa aea olnga kapei toman ngan ipu ad kisinga gol. Ga ele oatainga kapei ngan sapnga gid abei pade. Ta ei ga irangrang ngan ikado naurata imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Be ega, gau nasio eaba ede pade ngan luanga ei, ieda Ooliap. Ei Aisamak inat ngan lum pan Dan. Be gau nabada oatainga kapei pagid panua naurata ad padengada ngan kadonga danga toa ngada ne mambe nakeo pago ngan. ");
INSERT INTO bch_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Ta gid ga tikado leg palata, ga korol apu aea toman ngan ipao toa sing isamum kadonga sasat ngan ga lolog itarui mulian. Ta gid ga tikado palata aea danga sisid padengada ga bedane: ");
INSERT INTO bch_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","popou bret aea toman ngan aea danga sisid, ga lam iae gol toman ngan aea danga sisid, ga popou nabene aea, ");
INSERT INTO bch_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","ga popou tenainga aea toman ngan aea danga sisid toa ngada oa, ga tabla eau aea toman ngan aea popou, ");
INSERT INTO bch_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ga sogonga tutui tenainga aea ton Aron ga ele gergeu arangaranga, ");
INSERT INTO bch_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","ga bude iman kilala ngan danga sisid togau, ga nabene ngan kadonga basu iuad kemi leg palata iloleai ngan tibur toa aea ul kapei tede. Manta tikado danga toa ngada ne lalaede mambe nakeo pago ngan.” ");
INSERT INTO bch_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Maron ikeo pan Moses pade bedane, ");
INSERT INTO bch_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Eao manta keo pagid Israel ga bedane, ‘Somisomi gimi manta aearagimi ngan Ado Earainga aea. Gau nadol Ado Earainga aea toa ne ga iman kilala rabu ngan gau ga gimi ga lemi gergeu ga tibutibumi tiuotot muriai. Toa bedaoa ta gimi ga aoatai kemi mambe gau eine Maron toa nadol ul ngan gimi. ");
INSERT INTO bch_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“‘Be gau nadol ul pade ngan Ado Earainga aea. Tota gimi manta aearagimi ngan. Oangga sai ilolon ngan Ado Earainga aea toa ne mao, manta arau ei ga imate. Be oangga sai ikado naurata ngan ado toaiua, manta asuk ei ga ila aluai ngan gid ele panua. ");
INSERT INTO bch_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Gimi ga akado lemi naurata irangrang ngan ado lima ga ede. Be ado lima ga rua aea, eine Ado Earainga aea toa gau Maron nadol ul ngan. Oangga sai ikado naurata ngan Ado Earainga aea, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Gimi Israel toman ngan lemi gergeu ga tibutibumi tiuotot muriai, manta aearagimi ngan Ado Earainga aea. Ngansa eine posanga tautaunga ede narau toman ngan gimi, ta eine ga ienono ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ado Earainga aea toa ne iman kilala rabu ngan gau ga gimi Israel somisomi. Ngansa ngan ado toa lima ga ede oa mugaeai, gau Maron nakado mariamba ga tano ga iuot. Be ngan ado lima ga rua aea, nakaput ngan leg naurata ta naearagau.’” ");
INSERT INTO bch_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Io, Maron iposa pan Moses ngan lusi Sainai toa bedaoa ga kus, ta ibada pat rua apu aea ga ila pan. Deo kekelen ibage igonga ibode ele apu ga idae ngan pat toa rua oa. ");
INSERT INTO bch_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Idio ta gid panua tigera mambe Moses imamado mole tau lusiai, be iluai mulian manmanae mao. Tota tila tiluplup pan Aron ta tikeo pan bedane, “Eao manta kado amai deo etangada ta timuga ngan gai ngan lemai edap. Ngansa Moses, eaba toa ibada gita ta tatnan Isip ga tanam, gai aoatai ngan saoa danga iuot ngan ei mao.” ");
INSERT INTO bch_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Io, Aron ikoli led posanga bedane, “Atil tangami aea pato gol ienono adadaoami ga lemi gergeu tangadeai, ta abada ga inam pagau.” ");
INSERT INTO bch_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Tota gid panua tibada tangad aea pato gol ga ila pan. ");
INSERT INTO bch_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Ta Aron ibada ta inono ngan dinga ga ila maraka, ta itok ga idudunga ngan baba ede toa ital ianun ngan mambe bulmakao daenga pau. Ta ibada didi ta ipenpen ngan bulmakao aea namer toa oa. Ga kus ta gid panua tikeo, “Gimi Israel alongo. Danga toa ne, eine gita ada deo toa ibada gita ta tatnan Isip ga tanam.” ");
INSERT INTO bch_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Be Aron igera toa bedaoa ta ipagun popou tenainga aea boloma ngan bulmakao aea namer toa oa. Ta ikeo, “Sabale takado eaneannga kapei ngan soanga Maron ieda.” ");
INSERT INTO bch_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Io, gaisala rumaruma ngan ado sae, gid panua tibada gid masilau tenainga aea, ta edengada tidol ga idae dingaeai ngan dinga inono ga imomout ga kus. Be masilau padengada iman tenainga eaneannga aea ngan lolod kelede. Idio ta timamado ngan eaneannga ga ununnga, ga kus ta tidae ga tila tititiau. ");
INSERT INTO bch_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Idio ta Maron ikeo pan Moses bedane, “Sulug ga la! Ngansa gid lem panua toa bada gid ga titnan Isip oa tikado kadonga sasat kapei tau. ");
INSERT INTO bch_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Tipul murid manmanae tau ngan gau ta titnan edap toa nakeo ga tinasi. Be tikado deo ede pade aea namer gol ga imata mambe bulmakao, ta tikor aed ngan ga tirau gid masilau ga iman led tenainga ga ila pan. Ta tikeo, ‘Gimi Israel alongo. Danga toa ne, eine gita ada deo toa ibada gita ga tatnan Isip ga tanam.’” ");
INSERT INTO bch_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ta Maron ikeo pan Moses bedane, “Gau nagera led kadonga na. Gid panua toa ne tanga balbal ad tau. ");
INSERT INTO bch_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Gau lolog bake tau. Eao dio ge, ta napamukuru gid. Be gau ga nakado ga eao lem gergeu ga tibutibum tiuot alu kapei tau.” ");
INSERT INTO bch_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Be Moses iuangga ikado ga aea Maron Deo ilolo itano ga idio, ta iraring matua ga ila pan bedane, “O Maron, eao lolom bake ngan lem panua padam. Ngansa ngan uram kapei, eao bada gid ta titnan Isip. ");
INSERT INTO bch_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Oangga eao pamukuru gid, eine gid Isip ga tikeo, ‘Deo ilolo paeamao ngan ele panua ta ibada gid ga tila lusiai, ngansa iuangga ipamukuru gid.’ Be manta pul lolom mulian ta tnan lem kadonga lolo bake aea ta paeabu ngan lem panua padam. ");
INSERT INTO bch_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Matam nanan lem paeaeanga Abraam ga Aisak ga Iakop. Mugaeai eao posa tautaunga pagid ta keo bedane, ‘Ngan gau edag naposa tautaunga, gau ga nakado ga lemi gergeu ga tibutibumi tiuot busa mambe gigima mariambai.’ Be eao posa tautaunga pagid pade ngan pannga tano ga iman ad, ta eao keo ga mulmulid ga timamado toa eoa somisomi.” ");
INSERT INTO bch_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Moses iraring bedaoa ga kus ta Maron ipul ilolo mulian ta ipaeabu ngan gid mao. ");
INSERT INTO bch_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Idio ta Moses ibada pat apu aea toa rua oa ta isorir lusiai ga isulug. Pat apu aea toa rua oa, Deo ibode apu ga idae ngan imata ga idibe. ");
INSERT INTO bch_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Deo kekelen ikado pat toa rua oa ga iuot, ta ibode posanga ga idae ngan. ");
INSERT INTO bch_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Be Iosua ilongo panua arerengad ga tingangar, ta ikeo pan Moses bedane, “Panua arerengad mambe paraunga ede iuot saupuiai.” ");
INSERT INTO bch_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Be Moses ikeo, “Eine mao. Arerengad oa mambe panua tiasal paraunga mao. Be eine mambe panua ad miri itamatama tiasal gid mao pade. Be nalongo ad gagal mambe panua tibaubau.” ");
INSERT INTO bch_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Io, Moses ila boloma saupuiai ta igera bulmakao aea namer ga panua titoltol alele, ta ilolo bake ta itado pat apu aea toa rua oa ga isulug ta timapmapoga lusi ipuiai. ");
INSERT INTO bch_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Idio ta ibada bulmakao aea namer toa oa ta itado ga idae dingaeai ga inono. Ga kus ta itut ga ila gereirei mambe kangkanga, ta isiran ga isulug eauiai, ta ikado ga gid Israel tiun eau toa oa. ");
INSERT INTO bch_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Idio ta ikeo pan Aron, “Gid panua toa ne tikado mado ngan eao, ta eao muga ngan gid ngan kadonga sat kapei toa bedane?” ");
INSERT INTO bch_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Ta Aron ikeo, “Eaba kapei, eao malmal padam. Eao oatai, gid panua toa ne tiparpar tau ngan kadonga sasat. ");
INSERT INTO bch_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Tikeo pagau bedane, ‘Kado amai deo etangada ta timuga ngan gai ngan lemai edap. Ngansa Moses, eaba toa ibada gita ta tatnan Isip ga tanam, gai aoatai ngan saoa danga iuot ngan ei mao.’ ");
INSERT INTO bch_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Tota nakeo pagid, ‘Oangga sai ele sogonga gol, manta itil ta ibada ga inam pagau.’ Tota tibada led gol ga inam pagau, ta natado ga idae dingaeai. Be mole mao bulmakao aea namer toa ne iuot sapaean.” ");
INSERT INTO bch_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Io, Moses igera mambe panua tiladlado alele, be Aron irangrang ngan ipakoko gid mao. Tota Moses ikeo iloleai bedane, “Kado ta amai miri itamatama tigera ta tinging paeamao ngan gai.” ");
INSERT INTO bch_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Tota ila imadid saupu aea edap iaoai ta ibaba kapei bedane, “Oangga sai ikeo ga inasi Maron, manta inam pagau.” Io, tota gid panua ngan lum pan Livai tila timadid boloma pan. ");
INSERT INTO bch_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ta Moses ikeo pagid, “Maron Deo togita Israel ikeo ga bedane, ‘Gimi kelede kelede abada lemi didi paraunga aea ta ala ngan tibur toa ngada ne saupuiai, ta aketket ami kakakau ga kapeipei ga oaeoaemi ga panua padengada timamado boloma pagimi.’” ");
INSERT INTO bch_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Io, tota gid Livai tila tikado mambe Moses ikeo pagid ngan. Be ngan ado toaiua, panua bunoringring tol timate. ");
INSERT INTO bch_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Ga kus ta Moses ikeo pagid Livai bedane, “Labone gimi arau ami kapeipei ga kakakau ga lemi gergeu ga timate, ngansa tikado kadonga sat kapei. Tota labone Maron ikado kemi tau ngan gimi ta isio gimi ngan kadonga ele naurata.” ");
INSERT INTO bch_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Io, ngan ado sae Moses ikeo pagid panua bedane, “Gimi akado kadonga sat kapei tau. Be gau ga nadae ga nala lusiai pan Maron ta naton betanga ei ngan isamum lemi kadonga sat.” ");
INSERT INTO bch_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Tota Moses iluai mulian ga ila pan Maron ta ikeo, “Aiao! Gid panua toa ne tikado kadonga sat kapei tau. Tikado deo padengada ad namer ngan gol ta tisoa edad. ");
INSERT INTO bch_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Be gau nabeta eao, oangga eao kim, samum led kadonga sat. Be oangga eao tinim ngan mao, tota samum gau edag ngan laulau toa eao bode na.” ");
INSERT INTO bch_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Ta Maron ikeo pan Moses, “Eine mao. Oangga sapadua tikado kadonga sat ngan gau, eine ga nasamum gid kekelegid edad ngan leg laulau. ");
INSERT INTO bch_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Be eao la. La muga ngan gid panua ta bada gid ga tila ngan tibur toa nakeo pago ngan. Ega, gau leg anggelo ga ila imuga ngan gimi. Be muriai, gau ga nanam ta napanas gid ngan led kadonga sasat tutui ngan ado panasnga aea.” ");
INSERT INTO bch_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Idio ta Maron ikado dibala kapei ga iuot ngan gid, ngan panasnga gid ngan led kadonga sat. Ngansa gid tiposa matua pan Aron ta ikado bulmakao aea namer gol toa oa. ");
INSERT INTO bch_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Maron ikeo pan Moses pade bedane, “Eao ga gid panua toa bada gid ga titnan Isip ga tinam, gimingada atnan tibur toa ne ta ala ngan tano toa naposa tautaunga ngan. Mugaeai naposa tautaunga pan Abraam ga Aisak ga Iakop bedane, ‘Gau ga napan tano toa ne ga iman lemi gergeu ga tibutibumi ad.’ ");
INSERT INTO bch_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Be gau ga nasula leg anggelo, ta ei ga imuga ngan gimi ta isere gid Kenan ga Amor ga It ga Peres ga Ivi ga Iebus. ");
INSERT INTO bch_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Tota ala ngan tano kemi toa oa. Tano toa oa imona kapei ta bon isul ga bulmakao itud isul iuotot ngan. Be gau ga nala toman ngan gimi mao. Ngansa gimi panua tanga balbal ami tau. Ngan kado ta nala toman ngan gimi, ta napaeabu ngan gimi edapeai.” ");
INSERT INTO bch_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Gid panua tilongo ato paeamao toa ne ta lolod isat ta tidoldol led sogonga gol mao. ");
INSERT INTO bch_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Be Maron ikeo pan Moses bedane, “Keo pagid Israel, ‘Gimi panua tanga balbal ami tau. Oangga nala toman ngan gimi, mole mao ta napamukuru gimi. Tota patautene atil lemi sogonga gol, ta gau ga matag nanan kemi saoa danga ga nakado ngan gimi.’” ");
INSERT INTO bch_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Tota gid Israel titil led sogonga gol lusi Orep ipuiai ta tidol sogonga toa oa pade mao. ");
INSERT INTO bch_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Somisomi oangga gid Israel tirau saupu ngan tibur ede, Moses ipagun palata ede boloma tede ngan saupu, ta iuato palata toa oa ieda “Palata Luplupnga aea toman ngan Deo.” Be oangga sai ikeo ga iuatai ngan Maron ele kimnga, ei ga ila ngan palata toa oa boloma tede ngan saupu. ");
INSERT INTO bch_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Somisomi oangga Moses itnan saupu ta ila ngan palata toa oa, gid panua tidae timadid led palata iaoai ta tigeragera Moses ila idudunga ngan palata toa oa. ");
INSERT INTO bch_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Be oangga Moses idudunga palatai, tota laulau mamarae isulug ga ila imadid boloma palata iaoai, ta Deo iposaposa toman ngan Moses. ");
INSERT INTO bch_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Be oangga gid panua tigera laulau mamarae toa oa isulug ga imadid palata iaoai, gid toa ngada oa tidae ta tikor aed toa led palata iaoai. ");
INSERT INTO bch_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Be somisomi Maron iposaposa toman ngan Moses mambe ei ga iuae ede matad inono ngan gid ta tiposaposa. Be oangga gisirua tiposa ga kus, ta Moses iluai mulian saupuiai. Be ele aluagau Iosua, gergeu ton Nun, ei imamado palata iloleai somisomi. Ado ga ado ei itnan palata toa oa mao. ");
INSERT INTO bch_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Idio ta Moses ikeo pan Maron bedane, “Ega, somisomi eao keo pagau ngan badanga panua toa ne ga tila ngan tano toa keo pagau ngan, be eao palongo gau ngan sai toa eao sula ei ga inam toman ngan gau ne mao. Be eao keo pagau bedane, ‘Gau naoatai kemi ngan eao, ga lolog marum ngan eao.’ ");
INSERT INTO bch_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Be oangga lolom marum ngan gau, paoatai gau ngan lem edap, ta gau ga naoatai kemi ngan eao ta nanasi kadonga mambe eao kim. Ga pade, nakim eao matam nanan alu toa ne, gid eao lem panua.” ");
INSERT INTO bch_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ta Deo ikoli ele posanga bedane, “Gau ga nala toman ngan eao ta naearan go kemi.” ");
INSERT INTO bch_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Ta Moses ikeo pan pade bedane, “Oangga eao nam toman ngan gai mao, kemi ngan gai atnan tibur toa ne mao. ");
INSERT INTO bch_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Be oangga eao nam toman ngan gai mao, panua padengada ga tiuatai madongan mambe lolom marum ngan gau ga lem panua toa ne? Be oangga eao nam toman ngan gai, eine gid alu padengada tanoeai ga tikakrik ngan gai alu toa ne ede pade tau ngan gid.” ");
INSERT INTO bch_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Ta Maron ikeo pan Moses, “Gau ga nakado tutui mambe eao keo ngan, ngansa lolog marum ngan eao ga naoatai kemi ngan go.” ");
INSERT INTO bch_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Ta Moses ikeo, “Pasolan gau ngan lem taranga.” ");
INSERT INTO bch_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Ta Deo ikeo, “Toa patautene gau ga napasolan eao mambe gau eaba kemi tau, ta gau ga naoato edag Maron pago. Longo. Oangga nakeo ga lolog isat ngan eaba eta, eine ga lolog isat ngan ei. Be oangga nakeo ga nauduan eaba eta, eine ga nauduan ei. ");
INSERT INTO bch_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Be irangrang ngan eao gera matag mao. Ngansa oangga sai igera matag, ei ga imate.” ");
INSERT INTO bch_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ta Maron ikeo pade bedane, “Ega, pat kapei ede ienono boloma pagau. Ta eao ga dae madid ngan. ");
INSERT INTO bch_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Tota oangga leg taranga inam boloma, gau ga nadol go ga dudunga ngan pat toa ne aea baba, ta napamumul go ngan bageg ga irangrang ngan nasapir ngan go ga nala. ");
INSERT INTO bch_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ga kus ta nasoa bageg ga idae pade, ta eao ga gera murig. Be irangrang ngan eao gera matag mao.” ");
INSERT INTO bch_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Maron ikeo pan Moses pade bedane, “Manta ket pat rua pade, lalaede mambe pat apu aea toa mugaeai eao tado ga timapoga. Ta gau ga nabode posanga ga idae ngan gid lalaede mambe mugaeai. ");
INSERT INTO bch_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sabale gaisala, eao manta bada pat toa rua ne ta dae ga nam pagau lusi ilaborai ta madmadid nene. ");
INSERT INTO bch_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Be irangrang ngan eaba eta inam toman ngan eao mao. Be tinig ngan nagera eaba eta pade ilalala alele lusiai mao pade. Be gid bulmakao ga sipsip, tirangrang ngan tian purup lusi ipuiai mao pade.” ");
INSERT INTO bch_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Io, tota Moses iket pat rua pade lalaede mambe mugaeai aea, ta gaisala rumaruma ibada pat toa rua oa ta idae ga ila lusi Sainai, mambe Maron ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Be Maron imamado laulauiai ta isulug ga ila imadmadid toman ngan Moses, ta ei iuato ieda mulian Maron. ");
INSERT INTO bch_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Be Maron ila boloma pan Moses, ta ibaba bedane, “Gau Maron, gau Maron. Gau Deo, eaba lolo isat aea ga eaba uduannga aea. Be lolog bake manmanae mao. Gau ga nanasnasi kadonga kimnga aea ga kadonga mata tutui aea somisomi. ");
INSERT INTO bch_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Somisomi lolog ikimkim gid panua bunoringring busa ta nasamum led kadonga sasat ga kadonga tanga balbal aea imata ede ga ede. Be gid panua toa led idil paeamao, irangrang ngan natnan gid ga tidio kemi mao. Gid ga tibada ad panasnga. Oangga sapadua tinasnasi kadonga papaeamao, gau ga napanas gid ga led gergeu ga tibutibud ga led sasasa pade.” ");
INSERT INTO bch_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Deo iposaposa bedaoa, be manmanae Moses ikor iae ta idol ilabora ga isulug tanoeai. ");
INSERT INTO bch_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Ta ikeo, “O Maron, oangga lolom marum ngan gau tautaunga, tota nakim eao nam toman ngan gai. Tautaunga, gid panua toa ne tanga balbal ad tau, be nakim eao samum lemai kadonga sasat ga lemai idil papaeamao, ta bada gai ga aman lem panua tautaunga.” ");
INSERT INTO bch_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Idio ta Deo ikeo, “Ega, labone narau posanga toman ngan gimi ta loloda kelede. Ngan gimi matami, gau ga nakado uisinga kapeipei mambe gid alu padengada tigera mugaeai ga inama ne mao. Be gid panua timamado boloma pagimi, eine ga tigera danga imata ede ga ede nakado ngan luanga gimi, ta gid ga timataud. ");
INSERT INTO bch_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Be manta gimi anasnasi leg apu toa nabada pago labone. Be ega, gau ga namuga ngan gimi ta nasere gid Amor ga Kenan ga It ga Peres ga Ivi ga Iebus. ");
INSERT INTO bch_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Be manta agabit kemi. Ngan kado ta arau posanga toman ngan gid panua timamado ngan tibur toa gimi ala ngan oa, ta lolomi kelede. Oangga akado bedaoa, eine paeamao ngan gimi mambe adae kas ngan pitpit. ");
INSERT INTO bch_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Be gimi manta arepe led popou tenainga aea, ga agoro led pat kilala aea ga irumrum, ga aged ad deo taine Asera aea namer ga tisulug. ");
INSERT INTO bch_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Irangrang ngan gimi asoa deo eta pade ieda mao. Ngansa gau Maron, edag ede pade eine Eaba Lolo Bake aea. Ta gau ga lolog bake, ta irangrang ngan nalongean deo eta pade ibada mulig mao. ");
INSERT INTO bch_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Be agabit kemi. Irangrang ngan gimi arau posanga toman ngan gid panua ngan tano toa oa mao. Ngansa gid ga tisoa ad deo edad ngan led kadonga arala, ta tirau masilau iman led tenainga ga ila pagid. Be oangga tikado bedaoa, eine ga tidada gimi ga ala toman ngan gid, ta aeanean led annga tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Be oangga apaoai lemi gergeu arangaranga ngan gid led gergeu taine, eine ga tisoa ad deo edad ngan led kadonga arala, ta tikado ga lemi gergeu arangaranga tinasi gid pade. ");
INSERT INTO bch_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Irangrang ngan akado deo eta aea namer ngan danga mambe gol ga silva ga aen mao. ");
INSERT INTO bch_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Manta akado eaneannga ngan Bret toa aea Yis Ienono ngan Mao mambe nakeo pagimi ngan. Ngan ado toa lima ga rua ne, manta aean bret toa aea yis ienono ngan mao. Akado eaneannga toa ne tutui ngan aea ado ngan taiko Abip. Ngansa ngan taiko toa ne, gimi atnan Isip ga anam. ");
INSERT INTO bch_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Gau nadol ul ngan lemi gergeu lautabtabe ga gergeu lautabtabe togid lemi bulmakao ga sipsip ga masilau padengada, ta gid toa ngada ne timan gau leg. Manta atenai gergeu lautabtabe togid lemi masilau ga tinam pagau. ");
INSERT INTO bch_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Be manta atenai sipsip ede ngan patutuinga lemi donki ele gergeu lautabe aea ul. Be oangga tinimi ngan tenainga sipsip ngan patutuinga donki toa oa aea ul mao, manta akor igagal. Be manta akado tenainga ede pade ngan patutuinga lemi gergeu lautabtabe arangaranga ad ul. “Irangrang ngan bagemi sapaean ga anam pagau mao. Manta anam toman ngan lemi tenainga. ");
INSERT INTO bch_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Irangrang ngan ado lima ga ede, gimi ga akado lemi naurata. Be ngan ado lima ga rua aea, manta aearagimi. Goibe, ado lima ga rua aea ne iuotot ngan lemi taiko earumnga annga aea ga iuotot ngan lemi taiko badanga annga imatua aea, be irangrang ngan gimi akado naurata ngan ado toa oa mao. Manta aearagimi. ");
INSERT INTO bch_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Aoadoade gid Ado Earainga aea ta akado eaneannga kapei ede pade ngan tenainga lemi wit isaoa imatua ga imuga. Be ngan taiko annga aea laoe toa ababada gid annga imatua dadangai ga inam, manta akado eaneannga kapei ede pade ngan Matami Nanan lemi Madonga Palatai. ");
INSERT INTO bch_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Be patol ngan rai ga rai, manta gimi arangaranga toa ngada ne anam pagau ta asoa gau edag. Gau Maron Deo togimi Israel, danga toa ngada ne ienono gau bagegeai. ");
INSERT INTO bch_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Be gid alu toa labone timamado ngan tano togimi, gau ga nasere gid ga tila aluai ngan gimi. Be gau ga nasarung ami tano aea but ta ila kapei. Be patol ngan rai ga rai, oangga atnan lemi tuanga ta anam aluplup pagau Maron Deo togimi, irangrang ngan ami isat eta ikado ele pespes ngan badanga ami tano mao. ");
INSERT INTO bch_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Irangrang ngan atenai lemi masilau eta ga inam pagau toman ngan annga aea yis mao. Be irangrang ngan adol annga Pasova aea eta ga idio gaisala mao. ");
INSERT INTO bch_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Lemi annga kemikemi imatua ga imuga, manta abada ga inam pagau Maron Deo togimi ta atenai toa leg palatai. “Irangrang ngan anono meme daenga pau eta ngan ulo toman ngan itna itud isul mao.” ");
INSERT INTO bch_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Idio ta Maron ikeo pan Moses pade bedane, “Posanga toa aoag inasi ngan pago ne, manta bode ga idae ngan laulau ede, ngansa ngan gid apu toa ne, narau posanga toman ngan gimi Israel ta loloda kelede.” ");
INSERT INTO bch_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Io, Moses idio imamado toman ngan Maron irangrang ngan aea ado ga bong sangaul pange. Be ngan gid ado toa oa, ianean annga mao ga iunun eau mao pade. Be Deo ibode posanga toa irau toman ngan gid Israel ga idae ngan pat toa rua oa. Posanga toa oa eine gid apu kapeipei sangaul ton Deo. ");
INSERT INTO bch_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ngan ado toaiua Moses isorir ngan lusi Sainai ga isulug, ei ikikisi pat rua apu aea ga isulug. Be iuatai mao mambe imata mil ga mil tau. Imata ikado toa bedaoa ngansa iposaposa toman ngan Deo. ");
INSERT INTO bch_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Be Aron ga gid panua Israel tigera Moses imata mil ga mil tau, ta timataud ngan langa boloma pan. ");
INSERT INTO bch_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Be Moses ibaba ga ila pagid, tota Aron ga gid madidnga toa ngada oa tila boloma pan pade, ta Moses iposaposa pagid. ");
INSERT INTO bch_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Idio ta gid Israel toa ngada oa tila boloma pan, ta iposa pagid ngan apu toa ngada oa Maron ibada ga ila pan ngan lusi Sainai. ");
INSERT INTO bch_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Moses iposa pagid ga kus, ta ipamumul imata ngan malo kakauede. ");
INSERT INTO bch_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Be somisomi oangga Moses idudunga Maron ele palatai ngan posanga toman ngan ei, itil malo kakauede toa oa ga irangrang ngan iuot mulian pade. Ta oangga Moses iuot ga ila ta ikeo pagid Israel ngan saoa posanga ei ikeo pan ngan, ");
INSERT INTO bch_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","eine tigera imata mil ga mil tau. Tota somisomi Moses ibada malo kakauede toa oa ta ipamumul ngan imata ga irangrang ngan ila iposa toman ngan ei pade. ");
INSERT INTO bch_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Idio ta Moses ibaba gid panua Israel toa ngada oa ta tinam tiluplup pan, ta ikeo pagid, “Maron ikeo ga gimi manta anasi gid apu ga bedane: ");
INSERT INTO bch_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Irangrang ngan ado lima ga ede, gimi ga akado lemi naurata, be Maron idol ul ngan ado lima ga rua aea, ta ikeo ga eine Ado Earainga aea ei ton. Manta aearagimi ngan ado toaiua. Oangga sai ikado naurata ngan Ado Earainga aea, manta arau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Be ngan Ado Earainga aea, irangrang ngan gimi apaisi dinga lemi lumaeai mao pade.” ");
INSERT INTO bch_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Idio ta Moses ikeo pagid panua Israel toa ngada oa bedane, “Maron iposa matua pagita ga bedane: ");
INSERT INTO bch_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Ikeo ga kemi ngan gimi abada lemi danga sisid etangada ga ila pan. Panua kelede kelede toa tikim badanga led danga etangada ga ila pan Maron, kemi ngan titenai gid danga sisid ga bedane: gol, ga silva, ga bras, ");
INSERT INTO bch_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ga sipsip ilaun toa tisama ngan pulo singsingia ga singsingia tede ga bil, ga gid malo kemikemi, ga malo tikado ngan meme ilaun, ");
INSERT INTO bch_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ga sipsip arangaranga tinid kukul toa tisama ngan pulo singsingia, ga rui tinid kukul, ga abei akas ikatinge etangada. ");
INSERT INTO bch_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","Ga pade, kemi ngan tibada bude lam aea ga danga iuad kemikemi ngan bulnga toman ngan bude samanga aea toa iman kilala ngan gid danga sisid ton Deo. Ga pade, kemi ngan tibada danga iuad kemikemi ngan bulnga toman ngan nabene ngan kadonga basu iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","Ga pade, kemi ngan tibada pat oniks ga pat imata ede ga ede toa aea olnga kapei tau, ta muriai tipatoi gid ga tidae ngan madidnga kapei tenainga aea irabu aea malo, ga tipatoi etangada pade ga idae ngan igogo aea malo kakauede.” ");
INSERT INTO bch_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Moses ikeo pade bedane, “Oangga sapadua timamado rabu ngan gimi be led oatainga kapei ngan naurata imata ede ga ede, manta tinam ta tikado danga toa ngada ne Maron iposa ngan ga bedane: ");
INSERT INTO bch_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Deo ele palata toman ngan aea malo, ga aea lingau, ga didnga ituatua, ga palata aea lapinga, ga gid kadanga toman ngan ad kadanga ipu, ");
INSERT INTO bch_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ga korol apu aea toman ngan aea sig, ga korol ipao toa sing ipatarui Deo ilolo ngan, ga malo kapei toa ipoga palata ilolo ga iman rua. ");
INSERT INTO bch_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","Ga pade, manta tikado bret tenainga aea toman ngan aea popou, ga popou aea sig, ga danga padengada ngan dolnga bret tenainga aea ga ienono Deo imatai, ");
INSERT INTO bch_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ga lam iae toman ngan aea lam, ga aea danga sisid padengada iman palata ilolo aea taranga, ga lam aea bude, ");
INSERT INTO bch_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","ga popou nabene aea toman ngan aea sig, ga bude iman kilala ngan danga sisid ton Deo, ga nabene ikado basu iuad kemi, ga malo kapei iman palata iaoa aea pakalanga, ");
INSERT INTO bch_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","ga popou tenainga aea toman ngan aea kakari bras, ga popou aea sig, ga aea danga sisid padengada, ga tabla bras iman eau aea toman ngan aea popou, ");
INSERT INTO bch_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ga gid malo silasila aea toman ngan ad kadanga ga gid kadanga ipu, ga malo kapei ipakala silasila iaoa, ");
INSERT INTO bch_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ga gid oaro palata aea ga silasila aea, ga gid kisinga gereirei bras toa tigin ga idudunga tanoeai ngan kisinga gid oaro toa oa, ");
INSERT INTO bch_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ga gid sogonga tutui tenainga aea ton Aron ga ele gergeu arangaranga ngan kadonga led naurata tenainga aea Deo ele palata iloleai ngan tibur toa aea ul kapei tede.” ");
INSERT INTO bch_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Gid panua Israel toa ngada oa titnan Moses ga tila. ");
INSERT INTO bch_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Be Moses ele posanga ipul gid panua busa lolod, ta gid kelede kelede toa tikim badanga led danga edengada ga ila pan Maron, tota tibada led danga sisid ga iman led tenainga ga ila pan. Led danga sisid toa oa, ila ngan kadonga Deo ele palata, ga ngan luanga ele palata aea naurata, ga ngan kadonga sogonga togid panua tenainga ad. ");
INSERT INTO bch_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Be gid panua kelede kelede arangaranga ga taine toa tikim badanga led danga sisid edengada ga ila pan, tota tibada led sogonga gol imata ede ga ede ga bedane: danga gol gereirei tikapin ga idae ngan led pononga, ga tangad aea pato gol, ga baged igonga aea pato gol, ga gid sogonga gol padengada. Sogonga gol toa ngada oa, tisoa ngan baged ga idae ta tipatambolembole Maron imatai, ta iman led tenainga ga ila pan. ");
INSERT INTO bch_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Be panua padengada tibada led oaro salumu aea singsingia ga singsingia tede ga bil toa tikado ngan sipsip ilaun, ga meme ilaun, ga malo kemikemi, ga sipsip arangaranga tinid kukul toa tisama ngan pulo singsingia, ga rui tinid kukul. ");
INSERT INTO bch_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Be panua padengada tibada led silva ga bras iman led tenainga ga ila pan Maron. Be panua padengada tibada led abei akas ikatinge edengada ngan kadonga Deo ele palata aea danga sisid. ");
INSERT INTO bch_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Be gid taine edengada led oatainga kapei ngan loinga oaro salumu aea. Gid tibada led oaro salumu aea singsingia ga singsingia tede ga bil, ga led malo kemikemi. ");
INSERT INTO bch_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Be taine padengada tikim badanga led danga sisid ga inam. Gid led oatainga kapei ngan kadonga oaro salumu aea ngan meme ilaun ta tibada ga inam. ");
INSERT INTO bch_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Be gid madidnga tibada led pat oniks ga gid pat padengada toa aea olnga kapei ga inam ngan patoinga ga idae ngan madidnga kapei tenainga aea irabu aea malo ga igogo aea malo kakauede. ");
INSERT INTO bch_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Ga pade, tibada danga imata ede ga ede iuad kemikemi, ga bude oliv aea iman lam aea, ga bude iman kilala ngan danga sisid ton Deo, ga bude ngan bulnga toman ngan nabene ngan kadonga basu iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Tota gid Israel busa toa tikim badanga led danga sisid ga iman Maron ele, tibada led danga toa oa ga ila ngan kadonga naurata toa ngada oa mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Idio ta Moses ikeo pagid Israel bedane, “Ega, Maron isio eaba ede ieda Besalel. Ei Uri inat ga Ur itub ngan lum pan Iuda. ");
INSERT INTO bch_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Be Deo idol Itautau Tutui ga idio pan eaba toa oa ta ikado ga ele oatainga kapei ga ilolo iuatai ngan kadonga naurata imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Ta ei ga irangrang ngan ikado mosi ngan gol ga silva ga bras. ");
INSERT INTO bch_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Be ele oatainga kapei ngan ketnga gid pat toa aea olnga kapei toman ngan ipu ad kisinga gol. Ga ele oatainga kapei ngan sapnga gid abei pade. Ta ei ga irangrang ngan ikado naurata mosi aea imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Ga pade, Deo ibada oatainga kapei pan Ooliap toa Aisamak inat, ngan lum pan Dan. Ta ikado ga gisirua lolod ikim ngan paoatainga panua padengada naurata ad. ");
INSERT INTO bch_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Be ei ibada oatainga pagid ngan kadonga naurata imata ede ga ede ga bedane: Tirangrang ngan tiketket pat mil ga mil, ga tirangrang ngan tikado mosi imata ede ga ede, ga tirangrang ngan oaoainga malo kemikemi ga tisaisai sogonga kemikemi ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be tirangrang ngan tikado mosi imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Maron ibada oatainga kapei toa bedaoa pan Besalel ga Ooliap toman ngan panua naurata ad padengada, ta led oatainga kapei. Ta gid ga tirangrang ngan tikado Deo ele palata toa aea ul ienono ngan oa toman ngan aea danga sisid toa ngada oa, mambe Maron ikeo ngan.” ");
INSERT INTO bch_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Idio ta Moses ibaba Besalel, ga Ooliap, ga panua padengada toa Maron ibada oatainga kemi pagid, ga panua padengada toa tikim tau naurata, ta gid toa ngada oa tila pan Moses, ta ikeo pagid ngan kadonga naurata. ");
INSERT INTO bch_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Tota Moses ibada danga sisid toa ngada oa gid Israel tipaluplup ngan kadonga naurata tenainga aea toa oa, ta idol ga idae gid panua naurata ad bagedeai. Be gaisala ngan ado ga ado, gid panua tibabada led danga sisid ga iman led tenainga ga ila pan Deo. Be tikaput ngan danga sisid aea badanga mao. ");
INSERT INTO bch_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Tota gid panua naurata ad tigera danga sisid toa ngada oa, ta titnan led naurata ga idio, ");
INSERT INTO bch_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ta tila tikeo pan Moses bedane, “Gid panua tibada danga sisid busa tau, ta imata karanga ngan naurata toa Maron ikeo pagita ngan. Be danga sisid busa ga idio sapaean.” ");
INSERT INTO bch_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Idio ta Moses ikado posanga matua ga ila pagid panua saupuiai ga bedane, “Irangrang ngan eaba eta pade ibada ele danga eta ngan kadonga palata toa ne mao.” Tota tikaput ngan badanga danga sisid pade ga inam, ");
INSERT INTO bch_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ngansa danga sisid toa tipaluplup oa, iuot busa tau ga imata karanga ngan kadonga naurata toa ngada oa. Be tigera mambe danga sisid ilia ga idio sapaean. ");
INSERT INTO bch_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Idio ta gid panua naurata ad toa led oatainga kapei tikado Deo ele palata ngan malo kemikemi sangaul. Be tipasogo gid malo toa oa ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be eaba ede mosi aea isaisai gid kerubim anunud ga idae ngan gid malo toa oa. ");
INSERT INTO bch_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Gid malo toa ngada oa tiuot lalaede. Ad mamarae iuot leoa lima leoa rua. Be ad babanga iuot leoa ede. ");
INSERT INTO bch_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Eaba ede mosi aea isaisai malo lima ga tila tiluplup ta ila mamarae. Be ikado toa bedaoa pade ngan gid malo lima pade. ");
INSERT INTO bch_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Be ibada malo ilialia bil ta isaisai gid koea, ta iman malo kapeipei toa rua oa ad saunnga, ta tila tiluplup. Isaisai gid koea toa oa ga tidae ngan malo kapeipei toa rua oa ngan matad iadag kelede. ");
INSERT INTO bch_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Isaisai koea sangalima ngan malo kapei imata ede, be isaisai koea sangalima pade ngan malo kapei ede pade imata iadag. ");
INSERT INTO bch_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Ga pade, ikado lingau gol sangalima ta iman malo kapeipei toa rua oa ad saunnga, ta ila iuot mambe malo kapitnami kelede. ");
INSERT INTO bch_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Ga pade, ikado malo sangaul igegea ede ngan meme ilaun ta iman Deo ele palata aea robinga. ");
INSERT INTO bch_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Gid malo toa sangaul igegea ede oa tiuot lalaede mon. Ad mamarae iuot leoa lima leoa rua aea mana. Be ad babanga iuot leoa ede. ");
INSERT INTO bch_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Isaisai malo lima ga tila tiluplup ta iuot mambe malo mamarae kelede. Be isaisai gid malo toa lima ga ede ienono maitne, ta tila tiluplup pade toa bedaoa, ta tiuot mambe malo mamarae ede pade, be ikatinge lima ga ede. ");
INSERT INTO bch_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ga pade, isaisai malo aea koea sangalima ngan malo kapeipei toa rua oa matad. ");
INSERT INTO bch_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Ga pade, ikado lingau bras sangalima ta isaun ngan gid koea, ta iman malo kapeipei toa rua oa ad paluplupnga. Toa bedaoa ta iuot mambe malo kapitnami kelede. ");
INSERT INTO bch_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Be ikado danga rua pade ngan robinga Deo ele palata. Robinga ede, ikado ngan sipsip arangaranga tinid kukul toa tisama ngan pulo singsingia. Be gadae ngan robinga toa oa, ikado robinga ede pade ngan rui tinid kukul. ");
INSERT INTO bch_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Ga pade, ikado palata aea kadanga arangaranga ngan abei akas, be rabu ngan gid kadanga arangaranga ruangada, ipatoto gid tabalanga, ta ikado ga gid kadanga arangaranga ruangada tiuot mambe pagirigiri. Toa bedaoa ta gid kadanga arangaranga ruangada toman ngan ad tabalanga timan didnga ituatua ikatinge kelede kelede. ");
INSERT INTO bch_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Kadanga arangaranga kelede kelede ad mamarae iuot leoa rua aea mana. Be gid tabalanga rabu ngan gid kadanga arangaranga kelede kelede ad mamarae iluai baidai. ");
INSERT INTO bch_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Be isap kadanga arangaranga toa ngada oa matad ila mamarae tede, ngan tila tidudunga ngan gid kadanga ipu silva ad baba ta timadid ngan. ");
INSERT INTO bch_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Be ngan palata ikarkare pan saut, ikado didnga ituatua ikatinge sangaul rua toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Ga pade, ikado kadanga ipu silva sangaul pange ta timan gid didnga ituatua ad pagunnga. Be ngan gid didnga ituatua ikatinge kelede kelede, idol kadanga ipu silva ruangada. ");
INSERT INTO bch_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","26","Ikado lalaede toa bedaoa pade ngan palata ikarkare iadag pan not. ");
INSERT INTO bch_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Be ngan palata imur aea talele, ikado didnga ituatua ikatinge lima ga ede toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Ga pade, ikado didnga ituatua ikatinge rua pade, ngan paluplupnga palata ikarkare ga aea talele toa palata imuriai oa, ta tila tung ngan palata igal. ");
INSERT INTO bch_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Ngan palata imur igal toa rua oa, isaun gid didnga ituatua ikatinge toa oa ngan gid koea ga lingau, pan ipu ga ila gadae. Isaun palata imur igal toa rua oa bedaoa. ");
INSERT INTO bch_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Toa bedaoa ta palata imur aea talele ituatua ikatinge tiuot lima ga tol toman ngan ad kadanga ipu silva sangaul ede igegea lima ga ede. Gadio ngan gid didnga ituatua ikatinge kelede kelede, idol kadanga ipu silva ruangada. ");
INSERT INTO bch_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Ga pade, ibada abei akas ta ikado palata aea lapinga tol, ede gadae, ede rabu, ga ede pade gadio. Ikado gid lapinga toa oa ta tidae ngan palata ikarkare toa rua oa ga aea talele pan imur. Be iket gid lapinga gadae aea ga gadio aea, ga idio rabu ga iman rua. ");
INSERT INTO bch_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Be ikado lapinga rabu aea ngan abei mamarae kelede, ta inasi palata aea mamarae ngan palata isal toa tol oa. ");
INSERT INTO bch_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Be imol gid didnga ituatua toa ngada oa ngan gol ikatinge babanga. Be ngan gid didnga ituatua ikatinge kelede kelede pan gaot, ikado gid koea gol iman gid lapinga ad sabunnga. Be imol gid lapinga pade ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Ga pade, ikado malo kemi ede ta ipakantutu palata iloleai, ta ipoga palata ilolo ga iman rua. Ipasogo malo toa oa ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be eaba ede mosi aea isaisai gid kerubim anunud ga idae ngan. ");
INSERT INTO bch_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Ga kus ta ibada abei akas ta ikado malo toa oa aea kadanga mamarae pange. Imol kadanga toa pange oa ngan gol ikatinge babanga, ga kus ta ipagun gid ga timadid ngan ad kadanga ipu silva. Ga kus ta ipatoi gid lingau gol ga tidae ngan gid kadanga toa oa, ta malo kapei idae itututu ngan. ");
INSERT INTO bch_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Be ikado malo kemi ede pade ta iman Deo ele palata iaoa aea pakalanga. Be ipasogo malo toa oa ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be eaba ede mosi aea isaisai gid sogonga kemikemi ga idae ngan. ");
INSERT INTO bch_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Be ikado malo toa oa aea kadanga lima, ta ipatoi gid lingau ga tidae ngan, ta iman malo kapei toa oa aea tutunga. Ga kus ta ibada gol ikatinge babanga ta imol ngan gid kadanga laborad ga gid tabalanga. Be ikado gid kadanga toa lima oa toman ngan ad ipu bras. ");
INSERT INTO bch_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalel ikado korol ede ngan abei akas, aea mamarae iluai kepeda iadag, be aea babanga iluai baidai, be aea gadae iluai baidai pade. ");
INSERT INTO bch_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Ibada gol kemikemi ta inono ngan dinga ga ila maraka, ta isile aea sakirkir toa ngada oa. Ga kus ta ibada gol toa oa ikatinge babanga, ta ipatoi ga idae ngan korol ilolo ga iluga ngan itin gaot pade. Ga pade, ipatoi gol idanga ede mamarae ta iman korol aea lapinga ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Ga pade, ikado korol aea koea gol pange ta ipatoi gid ga tidae ngan korol iae gereirei pange. Ipatoi koea rua ngan korol imata iadag, ga rua pade ngan korol imata iadag. ");
INSERT INTO bch_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ga kus ta ibada abei akas mamarae rua ta iualiue gid kemi ta timan sig. Ta imol sig toa rua oa ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Ga kus ta isabun sig toa rua oa ga tidudunga ngan gid koea korol aea. Isabun sig ede iadag, ga sig ede pade iadag, ta iman korol aea bisinga. ");
INSERT INTO bch_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Be ikado korol ipao ngan gol kemikemi, aea mamarae iluai kepeda iadag, be aea babanga iluai baidai. Korol ipao toa oa, eine tibur toa sing isamum panua led kadonga sasat, ta Deo ilolo itarui mulian ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Ibada gol ikatinge kelede ta itut ngan pat patotonga aea ta ikado korol ipao toman ngan aea kerubim rua, ede iadag, ede pade iadag. ");
INSERT INTO bch_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Ede ngan gid kerubim toa oa, ikado ngan korol ipao imata ngan bageda oatai, be ikado ede pade ngan bageda angas. Ikado korol ipao toman ngan kerubim toa rua oa ngan gol ikatinge kelede. ");
INSERT INTO bch_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Ikado kerubim toa rua oa ga tidio ngan tibur toa Deo isamum kadonga sasat ngan, be matad inono ngan gid. Be gisirua bagbaged iualai ga idae ta tirobi korol ipao. ");
INSERT INTO bch_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Ga kus ta ikado popou ede ngan abei akas, aea mamarae iluai gogodai, be aea babanga iluai bageda aea makoreai, be aea gadae iluai baidai. ");
INSERT INTO bch_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Ga kus ta iluga popou toa oa ngan gol kemikemi ikatinge babanga. Be ipatoi gol idanga ede mamarae ga iman popou aea lapinga ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Be ipatoi gol ikatinge babanga ede ta imadid ngan popou ipao mambe ala ta ibalil ngan popou ipao imata. Gol ikatinge toa oa aea gadae iluai mambe bageda ilolo aea babanga. Ga pade, ipatoi lapinga gol ede pade ga idae tatan ngan gol ikatinge toa oa ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","14","Ga pade, ikado popou aea koea gol pange ta ipatoi gid ga tidae ngan popou ipao aea gol ikatinge babanga ta inasi popou iae toa pange oa. Ta gid koea toa oa tikikisi sig rua ta timan popou aea bisinga. ");
INSERT INTO bch_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Ikado sig toa rua oa ngan abei akas ta imol gid ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Ga pade, ikado gid tabla gereirei ga lalate ga eaupat ga loba ngan gol kemikemi. Gid danga sisid toa oa iman tenainga oain aea toknga. ");
INSERT INTO bch_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Ga kus ta ibada gol kemikemi ta ikado ga iman lam iae, ngan dolnga gid lam ga idae ngan. Itut gol ngan pat patotonga aea ta ikado lam iae ipu ga ilua ga ibogaboga iman lam imul aea dolnga. Be ikado gid lam mulid ngan gol ta matad mambe koko ipur. Be lam iae aea danga toa ngada oa, ikado ngan gol ikatinge kelede. ");
INSERT INTO bch_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Be ikado lam iae ilua toman ngan ibogaboga lima ga ede, tol iadag ga tol iadag. ");
INSERT INTO bch_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Ngan gid lam iae iboga kelede kelede, ikado aea sogonga imata lalaede mambe abei salke ipur tol toman ngan ilaun gereirei. ");
INSERT INTO bch_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Be ipasogo lam iae ilua pade toa bedaoa ga imata lalaede mambe abei salke ipur pange toman ngan ilaun gereirei. ");
INSERT INTO bch_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Be gadio ngan lam iae ilua ikasanga toa tol oa, ipasogo ngan gol ga imata mambe abei salke ilaun gereirei. ");
INSERT INTO bch_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Ibada gol ikatinge kelede ta itut ngan pat patotonga aea ngan kadonga lam iae toman ngan aea danga sisid toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ikado toa bedaoa ga kus ta ikado aea lam lima ga rua. Be ikado gid danga mambe kaida gol iman lam aea wik imata aea ketketnga. Ga pade, ikado lam aea lalate gol. ");
INSERT INTO bch_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Gol toa ngada oa ngan lam iae ga aea danga sisid, aea kulupu iuot mambe kilo sangaul tol igegea pange. ");
INSERT INTO bch_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Ga kus ta ibada abei akas ta ikado popou tenainga aea ede pade, iman nabene aea nononga. Popou toa oa aea mamarae ga aea babanga iuot lalaede ga iluai bageda aea makoreai. Be aea gadae iluai gogodai. Be ngan popou ipao igal toa pange oa, isap gid danga imata mambe bulmakao aea pelenga. Ikado popou ipao toman ngan aea pelenga ngan abei akas ikatinge kelede. ");
INSERT INTO bch_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Ga kus ta ibada gol kemikemi ikatinge babanga, ta iluga ngan popou isal toa pange oa, ga ipao, ga aea pelenga. Be ipatoi gol idanga ede mamarae ga iman popou aea lapinga ga ibalil ngan. ");
INSERT INTO bch_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Be gadio ngan lapinga toa oa, ipatoi koea gol rua, ede ngan isal iadag, be ede pade ngan isal iadag, ta iman sig ad sabunnga ngan popou aea bisinga. ");
INSERT INTO bch_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Be ibada abei akas, ta ikado sig rua, ga kus ta imol gid ngan gol ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Be ikeo pan eaba ede toa ele oatainga kapei ngan kadonga danga sisid iuad kemi, ta ikado bude kemi ede. Bude toa oa aea ul, ta iman kilala ngan gid danga sisid ton Deo. Ga pade, ikado nabene ngan kadonga basu iuad kemi. ");
INSERT INTO bch_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Ga kus ta ibada abei akas ta ikado popou tenainga aea ngan. Aea gadae iluai bageda aea makor iadag, be aea mamarae ga aea babanga iuot lalaede ga iluai leoa ede ga ilia iluai bageda aea makoreai. ");
INSERT INTO bch_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Be gadae ngan popou igal toa pange oa, isap danga pange imata mambe bulmakao aea pelenga. Be isap popou igal toa pange oa toman ngan aea pelenga ngan abei akas ikatinge kelede. Be iluga popou tenainga aea isal toa ngada oa toman ngan aea pelenga ngan gid bras ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Ga pade, ikado gid tabla iman dinga itae aea tadonga, ga dinga itae aea doidoinga, ga gid loba ngan dolnga masilau ising ngan, ga gid duduinga iman masilau imedameda aea galnga, ga gid lalate iman dinga aea badanga. Danga toa ngada oa ikado ngan bras kekelen. ");
INSERT INTO bch_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Ga pade, ikado popou toa oa aea kakari bras iman dinga aea. Be ngan popou iae toa pange oa, ipatoi bras idanga ede ga idae iae irabuiai, ta iman kakari bras aea kisinga. ");
INSERT INTO bch_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Be ikado gid koea bras pade ta ipatoi gid koea toa oa ga tidae ngan kakari bras igal toa pange oa. Gid koea toa oa iman sig ad sabunnga ngan bisinga kakari bras. ");
INSERT INTO bch_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Ga kus ta ibada abei akas, ta ikado sig rua ta imol gid ngan bras ikatinge babanga. ");
INSERT INTO bch_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Sig toa rua oa iman popou aea bisinga. Isabun gid ngan popou aea koea toa pange oa, sig ede iadag, ga sig ede pade iadag. Be idid popou toa oa ngan abei ikatinge kemikemi, be itnan iaoa gadio ga gadae ga idio ibangabanga. ");
INSERT INTO bch_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Be ngan palata luplupnga aea toman ngan Deo, gid taine edengada tikakado naurata boloma palata iaoai. Gid led bras idanga edengada iman matad aea tlonga. Be tibada bras toa oa ga ila pan eaba naurata aea, ta ikado tabla eau aea toman ngan aea popou ngan bras toa oa, ta iman panua tenainga ad baged ga aed aea sigiringa. ");
INSERT INTO bch_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Ga kus ta ibada malo kemikemi ta tisilasila ga ibalil ngan Deo ele palata. Be silasila toa oa ikarkare pan saut, aea mamarae iuot sangaul rua leoa lima. ");
INSERT INTO bch_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Be tikado silasila ikarkare toa oa toman ngan aea kadanga sangaul rua. Be tikado gid kadanga ipu bras sangaul rua pade iman gid kadanga ad pagunnga. Be ngan gid kadanga kelede kelede, tikado gid lingau silva ga tabalanga silva pade. ");
INSERT INTO bch_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Be silasila toa oa ikarkare pan not iuot lalaede mambe iadag aea pade. Aea mamarae iuot sangaul rua leoa lima. Be tikado aea kadanga sangaul rua toman ngan ad kadanga ipu bras sangaul rua pade iman gid kadanga ad pagunnga. Be ngan silasila aea kadanga kelede kelede, tikado gid lingau silva ga tabalanga silva pade. ");
INSERT INTO bch_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Be silasila toa palata imuriai oa, aea mamarae iuot sangaul ede leoa rua aea mana. Be tikado silasila toa oa aea kadanga sangaul toman ngan ad kadanga ipu bras sangaul pade iman gid kadanga ad pagunnga. Be tikado aea malo lalaede toa bedaoa pade. Be ngan silasila aea kadanga kelede kelede, tikado gid lingau silva ga tabalanga silva pade. ");
INSERT INTO bch_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Be silasila iaoa, toa ado ele parangai, aea mamarae iuot sangaul ede leoa rua aea mana. ");
INSERT INTO bch_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Be ngan silasila iaoa isal iadag ga iadag, tipakantutu malo rua, ede iadag, ede pade iadag, ad mamarae iuot leoa tol ga ilia iluai bageda aea makor iadag. Tikado silasila iaoa isal toa rua oa toman ngan kadanga lima ga ede, tol iadag, ga tol pade iadag, toman ngan ad kadanga ipu bras. ");
INSERT INTO bch_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Be tibada malo kemikemi kekelen ngan kadonga silasila toa oa. ");
INSERT INTO bch_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Be tibada bras ngan kadonga silasila aea kadanga ipu toa ngada oa. Be tibada silva ngan kadonga gid kadanga kelede kelede ad lingau ga tabalanga. Be timol gid kadanga laborad ngan silva ikatinge babanga pade. Toa bedaoa ta gid kadanga ad tabalanga toa ngada oa, eiua silva kekelen. ");
INSERT INTO bch_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Be tikado silasila iaoa aea malo kemi ede. Aea mamarae iuot leoa lima. Be aea gadae iuot leoa ede ga ilia iluai bageda aea makoreai, lalaede mambe silasila aea malo padengada. Be eaba mosi aea ipasogo malo toa oa ngan gid oaro salumu aea singsingia ga singsingia tede ga bil. ");
INSERT INTO bch_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Be tikado silasila iaoa aea malo toa oa toman ngan aea kadanga pange ga kadanga ipu bras pange pade. Be tibada silva ngan kadonga gid kadanga toa oa ad lingau ga tabalanga. Be timol gid kadanga laborad ngan silva ikatinge babanga pade. ");
INSERT INTO bch_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Be tibada bras ngan kadonga gid kisinga gereirei ngan kisinga gid oaro palata aea ga gid oaro silasila aea pade, ta muriai tigin gid ga tidudunga tanoeai. ");
INSERT INTO bch_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ngan Deo ele palata toa pat rua apu aea ienono ngan, gid panua naurata ad tibada gol ga silva ga bras ta tikado ngan. Be Moses ikeo pagid Livai ta tiuade gol ga silva ga bras toa oa, ta tibode aea kulupu ga idae ngan laulau. Be Itamar, gergeu ton eaba tenainga aea Aron, imuga ngan oadenga danga sisid toa oa. ");
INSERT INTO bch_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Be Besalel, Uri inat ga Ur itub ngan lum pan Iuda, ikado palata aea danga toa ngada oa mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Be Ooliap, Aisamak inat ngan lum pan Dan, ilualua Besalel. Be ei ele oatainga kapei ngan kadonga naurata imata ede ga ede mambe totoinga posanga ga idae ngan pat mil ga mil, ga ikakado mosi imata ede ga ede, ga isaisai sogonga kemikemi ngan oaro salumu aea singsingia ga singsingia tede ga bil ta tidae ngan gid malo kemikemi. ");
INSERT INTO bch_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Be gid gol toa ngada oa gid Israel titenai ngan kadonga Deo ele palata, tipatambolembole Deo imatai. Be tiuade gol toa oa aea kulupu iuot kilo buno lima buno pange, sangalima sangaul pange, igegea lima ga tol (998). ");
INSERT INTO bch_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","26","Gid arangaranga toa ad rai sangaul rua ga idae, tiuade dabad ga kus ta gid kelede kelede titado pat silva kelede ga ila ngan kadonga Deo ele palata. Be gid silva toa tipaluplup oa, tiuade aea kulupu iuot kilo bunoringring tol, buno pange sangaul tol (3,430). Gid arangaranga toa oa dabad iuot bunoringring buno lima, bunoringring buno ede, igegea bunoringring tol, buno lima sangalima (603,550). ");
INSERT INTO bch_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Be tibada silva toa oa idanga ede ngan kadonga palata aea kadanga ipu, ga palata ilolo aea malo aea kadanga ipu. Silva toa oa aea kulupu iuot kilo bunoringring tol, buno pange (3,400). Gid kadanga ipu kelede kelede aea kulupu iuot kilo sangaul tol igegea pange. ");
INSERT INTO bch_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Be silva toa idanga ede pade, eaba naurata aea ikado ngan gid kadanga ad lingau ga tabalanga, be imol ga idae ngan gid kadanga laborad pade. Be silva toa oa aea kulupu iuot kilo sangaul tol. ");
INSERT INTO bch_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Be gid bras toa ngada oa gid Israel titenai ngan kadonga Deo ele palata, tiuade aea kulupu iuot kilo bunoringring rua, buno pange, sangaul rua igegea lima (2,425). ");
INSERT INTO bch_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Bras toa oa, ei ikado ngan Deo ele palata iaoa aea kadanga ipu, ga iluga ngan popou tenainga aea, ga ikado ngan aea kakari bras, ga ikado ngan popou aea danga sisid toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Be silasila aea kadanga ipu tikado ngan bras toa oa pade, ga tikado ngan silasila iaoa aea kadanga ipu, ga tikado ngan gid kisinga gereirei ngan kisinga gid oaro palata aea ga oaro silasila aea. ");
INSERT INTO bch_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Be tibada oaro salumu aea singsingia ga singsingia tede ga bil ta tikado gid sogonga kemikemi togid panua tenainga ad. Deo ikeo ga somisomi oangga gid panua tenainga ad tidudunga ga tila ngan tibur toa aea ul kapei tede, ngan kadonga ele naurata, manta tidol sogonga tenainga aea toa oa. Be tikado Aron aea sogonga tenainga aea ga iuot lalaede mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Eaba mosi aea ibada malo kemi ede ngan kadonga Aron irabu aea malo. Be ipasogo malo toa oa ngan gid oaro gol gereirei ga oaro salumu aea singsingia ga singsingia tede ga bil. ");
INSERT INTO bch_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Ngan kadonga gid oaro gol toa oa, eaba mosi aea ibada pat patotonga aea ta itut gid gol ikatinge gereirei ta iket gid ga ila iuot mambe oaro gol gereirei. Ga kus ta iuaoai gid oaro gol toa oa toman ngan gid oaro salumu aea singsingia ga singsingia tede ga bil, ta iman malo toa oa aea sogonga. ");
INSERT INTO bch_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Be gadae ngan Aron irabu aea malo toa oa, tisaisai ikepe aea oaro rua, iman kaukaunga aea. ");
INSERT INTO bch_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Ga pade, tibada oaro salumu aea singsingia ga singsingia tede ga bil ta tikado irabu aea pus. Be tiuaoai gid oaro gol gereirei ga idae ngan pade. Ga kus ta tisaisai pus toa oa ga idae ngan irabu aea malo toa oa imata, ta ila iuot mambe malo kelede, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Ga pade, tibada pat oniks rua ta titotoi Iakop ele gergeu sangaul igegea rua edad ngan. Be tibada gol ta tikado pat toa rua oa ipu ad kisinga toman ngan ad sogonga kemikemi. ");
INSERT INTO bch_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ga kus ta tikaukau pat toa rua oa ga tidae ngan ikepe aea oaro rua toa mugaeai tikaukau ngan irabu aea malo. Ta pat toa rua oa iman kilala ngan gid lum sangaul igegea rua togid Israel, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Ga kus ta eaba mosi aea ikado eaba tenainga aea igogo aea malo kakauede. Ikado malo kakauede toa oa aea sogonga ga iuot lalaede mambe eaba tenainga aea irabu aea malo. Isaisai malo toa oa ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be iuaoai gid oaro gol gereirei ga tidae ngan pade. ");
INSERT INTO bch_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Ikado malo kakauede toa oa aea mamarae ga iluai bageda aea makoreai, be aea babanga iluai bageda aea ubereai. Ikop malo toa oa ga idio irabuiai, ta aea mamarae ga aea babanga imata lalaede, ta kopnga toa oa iman danga rua aea dolnga. ");
INSERT INTO bch_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Ga kus ta tibada gid pat sangaul igegea rua toa aea olnga kapei tau. Be tipatoi gid ga tidae ngan ipu ad kisinga ngan malo kakauede toa oa pan gaot. Tilalo gid pat toa oa ngan iaoa pange. Ngan iaoa toa imuga oa, tilalo pat rubi singsingia, ga pat topas eangonga, ga pat beril singsingia tau. ");
INSERT INTO bch_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Be ngan pat iaoa ede pade, tilalo pat terkois birbirianga, ga pat sapaia bil, ga pat emeral birbirianga. ");
INSERT INTO bch_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Be ngan pat iaoa tol aea, tilalo pat iasint singsingia tede, ga pat aget eangonga tede, ga pat ametis singsingia tau. ");
INSERT INTO bch_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Be ngan pat iaoa pange aea, tilalo pat krisolait birbirianga, ga pat oniks mariluangge, ga pat iaspa birbirianga. Be tipatoi gid pat kelede kelede ngan ipu ad kisinga gol. ");
INSERT INTO bch_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Ngan gid pat toa sangaul igegea rua oa, titotoi Iakop ele gergeu arangaranga sangaul igegea rua edad. Gid panua toa ne timugamuga ngan gid lum sangaul igegea rua togid Israel. ");
INSERT INTO bch_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Ga pade, tibada gol kemikemi ta tipilai oaro gol rua ta tiuot mambe kenga, ta iman eaba tenainga aea igogo aea malo kakauede aea kisinga. ");
INSERT INTO bch_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Be tikado gid pat toa oa ipu ad kisinga gol rua ga aea koea gol rua, ta tisaisai gid koea ngan malo igal rua pan gadae. ");
INSERT INTO bch_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Ga kus ta tisaun gid oaro gol rua ta tidudunga ngan gid koea toa rua oa. ");
INSERT INTO bch_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Be tikaukau gid oaro gol matad iadag ga tidae ngan gid pat toa oa ipu ad kisinga gol rua. Ta tikaukau kisinga gol toa oa ngan ikepe aea oaro ta ikisi irabu aea malo. ");
INSERT INTO bch_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Be tikado koea gol rua pade, ta tisaisai gid ga tidae muriai ngan igogo aea malo kakauede igal toa rua oa pan gadio, boloma ngan irabu aea malo. ");
INSERT INTO bch_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Be tikado koea gol rua pade, ta tipatoi gid ga tidae ngan ikepe aea oaro toa mugaeai tikaukau ngan irabu aea malo, boloma ngan irabu aea pus. ");
INSERT INTO bch_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Ga kus ta tibada gid oaro salumu aea bil, ta tisaisai ga tidae ngan gid koea ngan igogo aea malo. Be tikaukau oaro matad iadag ga tidae ngan irabu aea malo, boloma ngan irabu aea pus. Toa bedaoa ta igogo aea malo irangrang ngan bir ga bir mao. Tikado toa bedaoa mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Ga kus ta eaba ede toa ele oatainga kapei ngan oaoainga malo ibada malo bil ta ikado eaba tenainga aea ele pononga mamarae ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Be ital pononga mamarae toa oa aea baba ngan ilabora idudunga ngan. Be isaisai baba toa oa toman ngan igagal aea malo ga iuot matoltol tede ta irangrang ngan itakai mao. ");
INSERT INTO bch_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ga pade, tipasogo pononga mamarae toa oa iaoa aea les ngan oaro salumu aea singsingia ga singsingia tede ga bil. Be tikado sogonga toa oa ga imata mambe abei pomigranet itautau. ");
INSERT INTO bch_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","26","Be tikado golo gereirei ngan gol kemikemi, ta tikaukau ga tidae ngan iaoa aea les pade, ta tipalapala gid golo toa oa toman ngan gid abei pomigranet itautau anunud. Be Maron iposa matua pan Moses ngan eaba tenainga aea manta idol pononga mamarae toa oa somisomi oangga ikakado ele naurata. ");
INSERT INTO bch_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Be eaba ede toa ele oatainga kapei ngan oaoainga malo ibada malo kemikemi ta ikado Aron ga ele gergeu arangaranga led siot. ");
INSERT INTO bch_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Be tibada malo kemikemi ta tikado Aron ilabora aea malo ga ele gergeu arangaranga laborad aea malo pade. Be tibada malo kemikemi ta tikado led sainga pade. ");
INSERT INTO bch_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Be tibada malo kemikemi ta tikado Aron irabu aea pus. Be eaba ede mosi aea ibada oaro salumu aea singsingia ga singsingia tede ga bil, ta isaisai sogonga ga idae ngan, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Ga pade, tikado gol ikatinge kakauede iman kilala ngan aea ul, ta titotoi posanga ga idae ngan bedane: Maron ele ul ienono ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Be tibada oaro salumu aea ede bil ta tikaukau gol ikatinge toa oa ga idae ngan Aron ilabora aea malo, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Toa bedaoa ta tipasala Deo ele palata aea naurata toa ngada oa ga kus. Ngan palata toa oa Deo iluplup toman ngan ele panua. Be gid Israel tikado naurata toa ngada oa tutui mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Ga kus ta tibada danga sisid toa ngada oa ga ila pan Moses. Tibada Deo ele palata toman ngan aea malo ga aea danga sisid ga bedane: aea lingau, ga gid didnga ituatua, ga palata aea lapinga, ga gid kadanga toman ngan ad kadanga ipu, ");
INSERT INTO bch_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","ga aea robinga tikado ngan sipsip arangaranga tinid kukul toa tisama ngan pulo singsingia, ga aea robinga ede pade tikado ngan rui tinid kukul, ga malo kapei toa ipoga palata ilolo ga iman rua, ");
INSERT INTO bch_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ga korol apu aea toman ngan aea sig, ga korol ipao toa sing ipatarui Deo ilolo ngan, ");
INSERT INTO bch_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ga bret tenainga aea toman ngan aea popou ga aea danga sisid ngan dolnga bret tenainga aea ga ienono Deo imatai, ");
INSERT INTO bch_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ga lam iae gol toman ngan aea lam, ga aea danga sisid padengada, ga lam aea bude, ");
INSERT INTO bch_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","ga popou gol iman tenainga nabene aea, ga bude iman kilala ngan danga sisid ton Deo, ga nabene ikado basu iuad kemi, ga malo kapei iman palata iaoa aea pakalanga, ");
INSERT INTO bch_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","ga popou bras iman tenainga aea toman ngan aea kakari bras, ga popou bras aea sig, ga aea danga sisid padengada, ga tabla eau aea toman ngan aea popou, ");
INSERT INTO bch_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ga gid malo silasila aea toman ngan ad kadanga ga gid kadanga ipu, ga malo kapei ipakala silasila iaoa, ga silasila aea oaro toman ngan gid kisinga gereirei ngan kisinga gid oaro. Tota tibada Deo ele palata aea danga sisid toa ngada oa ga ila pan Moses. Ngan palata toa oa, Deo iluplup toman ngan ele panua. ");
INSERT INTO bch_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ga pade, tibada gid sogonga togid panua tenainga ad ga ila pan Moses ga bedane: Aron aea sogonga tutui tenainga aea, ga ele gergeu arangaranga ad sogonga kemikemi tenainga aea. Sogonga toa oa, eine ngan gid panua tenainga ad tidol ngan kadonga led naurata Deo ele palata iloleai, ngan tibur toa aea ul kapei tede. ");
INSERT INTO bch_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Toa bedaoa ta gid Israel tipasala naurata toa ngada oa tutui mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Be Moses imata inasi danga toa ngada oa gid panua tikado, ta igera mambe tikado tutui mambe Maron ikeo pan ngan. Tota Moses ikado posanga kemi ngan pamatuanga gid. ");
INSERT INTO bch_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Idio ta Maron ikeo pan Moses, ");
INSERT INTO bch_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Ngan rai toa ne aea taiko imuga, ngan taiko toa ne aea ado imuga, manta pagun leg palata, toa gitaingada taluplup ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Be dol korol apu aea ga idudunga ngan leg palata, ga kus ta apakantutu malo kapei toa ipoga leg palata ilolo ga iman rua, ta dol korol apu aea ga idio muriai ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Ga kus ta bada popou tenainga bret aea ga idudunga leg palatai, ta lalo aea danga sisid ga idae ngan. Ga kus ta bada lam iae ta dol aea lam ga tidae ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ga kus ta bada popou gol iman nabene aea, ta dol ga idudunga leg palata iloleai, ngan tibur toa aea ul kapei tede, iadag ngan korol apu aea. Ga kus ta apakantutu palata iaoa aea malo. ");
INSERT INTO bch_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Be gaot ngan leg palata iaoa, manta dol popou tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Be rabu ngan leg palata ga popou tenainga aea, manta dol tabla eau aea, ta tok eau ga idudunga ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Ga kus ta atado silasila ga ibalil ngan leg palata, ta apakantutu silasila iaoa aea malo. ");
INSERT INTO bch_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Ga kus ta bada bude toa iman kilala ngan leg danga sisid, ta tok ga idae ngan leg palata ga danga toa ngada oa palata iloleai. Toa bedaoa ta eao dol leg ul ngan palata ga aea danga sisid ta iman gau leg. ");
INSERT INTO bch_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ga kus ta tok bude toa oa ga idae ngan popou tenainga aea toman ngan aea danga sisid naurata aea. Toa bedaoa ta eao dol leg ul ngan popou toman ngan aea danga sisid, ta gimi manta alolon ngan kapei tau. ");
INSERT INTO bch_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ga kus ta tok bude toa oa ga idae ngan tabla eau aea toman ngan aea popou, ta dol leg ul ngan ta iman gau leg. ");
INSERT INTO bch_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Ga kus ta bada Aron ga ele gergeu arangaranga ta tila timadid leg palata iaoai, ta paliliu gid ngan eau. ");
INSERT INTO bch_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ga kus ta pasogo Aron ngan aea sogonga tutui tenainga aea, ta tok bude ga idae ngan ei ngan dolnga leg ul ngan ei ngan kadonga leg naurata tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ga kus ta bada ele gergeu arangaranga ta pasogo gid ngan led siot tenainga aea. ");
INSERT INTO bch_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Ga kus ta tok bude ga idae ngan gid pade mambe tok ga idae ngan tamad. Toa bedaoa ta tirangrang ngan tikado leg naurata tenainga aea. Naurata tenainga aea toa eao dol gid ngan, eine gid kekelegid ga tikikisi, toman ngan led gergeu ga tibutibud ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Io, Moses ikado danga toa ngada oa mambe Maron ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Rai ede muriai ngan gid Israel titnan Isip, ngan rai toa oa aea taiko imuga, ngan ado imuga ngan taiko toa oa, gid tipagun Deo ele palata. ");
INSERT INTO bch_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Be Moses toman ngan panua naurata ad tipagun Deo ele palata ga bedane: Tidol gid kadanga ipu, ga kus ta tipaluplup gid didnga ituatua ikatinge, ta tidol aea lapinga ga tidae ngan, ga kus ta tisoa gid kadanga ta tipagun. ");
INSERT INTO bch_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Ga kus ta tirobi palata ngan aea malo kapei, be tidol aea robinga rua pade ga idae gadae ngan, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Ga kus ta Moses ibada pat rua apu aea ta idol ga idudunga koroleai. Be isabun aea sig ga tidudunga ngan aea koea. Ga kus ta idol korol ipao. Ngan korol ipao toa oa sing isamum panua led kadonga sasat, ta Deo ilolo itarui mulian ngan gid. ");
INSERT INTO bch_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Ga kus ta idol korol apu aea toa oa ga idudunga palatai, ta ipakantutu palata ilolo aea malo kapei, ta ipoga palata ilolo ga iman rua, ta ipamumul korol apu aea, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Ga kus ta Moses idol popou tenainga bret aea ga idudunga palata iloleai, ngan tibur toa aea ul kapei tede pan not. ");
INSERT INTO bch_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Ga kus ta idol bret tenainga aea ga idae ngan popou toa oa ta ienono Maron imatai, mambe ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Ga kus ta idol lam iae ga idudunga palata iloleai pan saut, iadag ngan popou tenainga bret aea. ");
INSERT INTO bch_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Ga kus ta idol gid lam ga idae ngan iae ta ienono Maron imatai, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Ga kus ta Moses idol popou gol iman nabene aea ga idudunga palata iloleai, ngan tibur toa aea ul kapei tede, boloma ngan malo kapei. ");
INSERT INTO bch_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Be gadae ngan popou toa oa, inono nabene ikado basu iuad kemi, mambe Maron ikeo pan ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Ga kus ta tipakantutu palata iaoa aea malo. ");
INSERT INTO bch_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Ga kus ta Moses idol popou tenainga aea ga idio gaot ngan palata iaoa, ta inono gid tenainga gadae ngan, ta dinga inono ga timomout ga kus. Be inono gid tenainga wit pade, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Ga kus ta idol tabla eau aea rabu ngan palata ga popou tenainga aea ta itok eau ga idudunga ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Ta Moses ga Aron ga Aron ele gergeu arangaranga tisigiri baged ga aed ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Somisomi oangga tidudunga Deo ele palatai, mao oangga tila boloma ngan popou tenainga aea, eine tisigiri baged ga aed, mambe Maron ikeo pan Moses ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Ga kus ta Moses toman ngan panua naurata ad titado silasila ga ibalil ngan palata ga popou tenainga aea. Ga kus ta tipakantutu silasila iaoa aea malo. Toa bedaoa ta Moses ipasala naurata toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Naurata toa ngada oa kus, ta Maron ele laulau irobi ele palata, be ele taranga kapei idudunga palata iloleai ga iuon ngan. ");
INSERT INTO bch_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Ta Moses irangrang ngan idudunga palatai mao, ngansa Maron ele laulau isulug ngan ta irobi, be ele taranga kapei iuon iloleai. ");
INSERT INTO bch_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Somisomi oangga tigera laulau itnan palata ga idae, eine gid Israel tikaka gid ngan lalalanga. ");
INSERT INTO bch_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Be oangga tigera laulau toa oa itnan palata ga idae mao, eine tikisi madonga ga timamado ga irangrang ngan ado toa tigera laulau itnan palata ga idae. ");
INSERT INTO bch_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Toa bedaoa ta somisomi tigera Maron ele laulau toa oa imadid gadae ngan ele palata ado ga ado, be somisomi bong, tigera dinga ianean laulau iloleai. Ikakado toa bedaoa ngan gid Israel led lalalanga toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Laulau ga eine iposa ngan Iesus Kristus aea titnga ngan itubtub. Iesus ei iaoa kelede pan Devit, ga Devit ei iaoa kelede pan Abraam. ");
INSERT INTO bch_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraam ei Aisak itama. Aisak ei Iakop itama. Iakop ei Iuda itama toman ngan itar kapeipei ga aea kakakau. ");
INSERT INTO bch_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Iuda ei Peres ga Sera tamad. (Gisirua tnad ieda Tamar.) Peres ei Esron itama. Esron ei Ram itama. ");
INSERT INTO bch_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram ei Aminadap itama. Aminadap ei Nason itama. Nason ei Salmon itama. ");
INSERT INTO bch_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon ei Boas itama. (Boas itna ieda Raap.) Boas ei Obet itama. (Obet itna ieda Rut.) Obet ei Iesi itama. ");
INSERT INTO bch_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Iesi ei maron kapei Devit itama. Devit ei Solomon itama. (Be Solomon itna, mugaeai iadaoa Uria.) ");
INSERT INTO bch_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon ei Reoboam itama. Reoboam ei Abia itama. Abia ei Asa itama. ");
INSERT INTO bch_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa ei Jeosapat itama. Jeosapat ei Jeoram itama. Jeoram ei Usia itama. ");
INSERT INTO bch_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usia ei Iotam itama. Iotam ei Aas itama. Aas ei Esekia itama. ");
INSERT INTO bch_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekia ei Manase itama. Manase ei Emon itama. Emon ei Iosaia itama. ");
INSERT INTO bch_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Iosaia ei Jeoiakin ga itar kakakau tamad. Ngan taun toaiua, gid Babilon tinam tisere gid Israel ta titnan ad tano ga tila timado Babilon. ");
INSERT INTO bch_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Muriai ngan gid Babilon tisere gid Israel, Jeoiakin ei Sealtiel itama. Sealtiel ei Serubabel itama. ");
INSERT INTO bch_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabel ei Abiut itama. Abiut ei Eliakim itama. Eliakim ei Asor itama. ");
INSERT INTO bch_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asor ei Sadok itama. Sadok ei Akim itama. Akim ei Eliut itama. ");
INSERT INTO bch_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliut ei Eleasar itama. Eleasar ei Matan itama. Matan ei Iakop itama. ");
INSERT INTO bch_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Iakop ei Iosep itama. Iosep ei Maria iadaoa. Maria toaine ipopo Iesus toa taoato ei Kristus. ");
INSERT INTO bch_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tota gid iaoa kelede pan Abraam ga ila irangrang ngan Devit, eine tiuot sangaul ga igegea pange. Be gid iaoa kelede pan Devit ga ila irangrang ngan gid Babilon tisere Israel, eine tiuot sangaul ga igegea pange pade. Be gid iaoa kelede muriai ngan gid Babilon tisere Israel ga ila irangrang ngan Kristus, eine tiuot sangaul ga igegea pange pade. ");
INSERT INTO bch_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Iesus Kristus aea poponga iuot ga bedane: Itna Maria, tisio ei ngan oainga Iosep. Gisirua tilup maitne, be tigera Maria iapa. Eine ngansa ngan Itautau Tutui iura, Maria iapa. ");
INSERT INTO bch_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Be iadaoa Iosep ei eaba tutui, ta itin ngan ipamaeamaea Maria panua busa matadeai mao. Tota iuangga itnan ei mumulnga. ");
INSERT INTO bch_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Iosep imata nanan kadonga toa ne maitne, be mole mao, anggelo ton Maron iuot pan ngan ianun ta ikeo bedane, “Iosep, eao iaoa kelede pan Devit, irangrang ngan lolom ede ga ede ngan badanga Maria ga iman adaoam mao. Ngansa gergeu toa iapa ngan oa, eine Itautau Tutui ibada pan. ");
INSERT INTO bch_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ei ga ipopo gergeu aranga, ta eao ga oato ieda Iesus, ngansa ei ga ibada ele panua mulian ngan led kadonga sasat.” ");
INSERT INTO bch_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Danga toa ngada ne iuot ta iparangrang Maron ele posanga mambe eaba ibada Deo iaoa mugaeai ikeo ngan ga bedane, ");
INSERT INTO bch_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ega, taine ede ieno toman ngan eaba eta maitne, ei ga iapa. Ta ei ga ipopo gergeu aranga, ta gid ga tiuato ieda Emanuel.” (Edaeda toa ne ipu bedane, “Deo imamado pagita.”) ");
INSERT INTO bch_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Iosep ieno ga idae ta ila ikado mambe anggelo ton Maron irenren pan ngan. Iuai Maria toa, ");
INSERT INTO bch_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","be gisirua tilup mao ga irangrang ngan ipopo gergeu aranga. Ta iuato ieda Iesus. ");
INSERT INTO bch_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ngan ado toaiua, Erot iman maron kapei, be Iesus itna ipopo ei ngan tuanga Betleem ngan tibur Iudea. Itna ipopo ei ga kus ta gid kapeipei edengada ado ele parangai ad tinam tiuot Ierusalem. Gid led oatainga kapei ngan gigima iman kilala. Tiuot Ierusalem ga kus ta tibetabeta alele bedane, ");
INSERT INTO bch_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Gergeu pau toa muriai ga iuot maron kapei togimi Iuda, ei imamado sida? Ngansa gai amado ado ele parangai, be agera gigima iman kilala ngan aea poponga. Ta gai anam aoangga asoa ieda.” ");
INSERT INTO bch_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Maron kapei Erot ilongo bedaoa ta ilolo ede ga ede, ga panua busa Ierusalem, gid pade lolod ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tota ibaba gid madidnga tenainga ad ga apu ad togid Iuda ta tinam tiluplup pan. Ta ibeta gid bedane, “Eaba toa tiuato ei Kristus ga iuot ngan tuanga isaoa?” ");
INSERT INTO bch_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ta gid tikoli ele posanga bedane, “Ei ga iuot ngan tuanga Betleem ngan tibur Iudea, ngansa eaba ibada Deo iaoa mugaeai ibode posanga bedane, ");
INSERT INTO bch_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“‘Eao Betleem ngan tibur Iudea, eao edam iuot kapei mambe gid tuanga kapeipei Iudea. Ngansa eaba ede pagimi aea ga iuot Maron kapei, ta ei ga imariala ngan leg panua Israel mambe eaba imariala ngan sipsip.’” ");
INSERT INTO bch_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Erot ilongo bedaoa ga kus ta ipaoen posanga mumulnga ga ila pagid kapeipei oatainga ad, ngan tila pan. Ta ibeta gid bedane, “Gigima toa gimi agera na iuot ngeda?” Ilongo kemi led posanga ngan ga kus ");
INSERT INTO bch_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ta isula gid ga tila Betleem ta ikeo pagid, “Gimi ala Betleem ta amarum ngan ilonga gergeu toa oa. Be oangga gimi aot ngan ei, anam apalongo gau. Ta gau pade nala nasoa ieda.” ");
INSERT INTO bch_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Io, tilongo Erot ga kus ta tila. Be mole mao gigima toa mugaeai tigera ado ele parangai, iuot pade be imuga ngan gid ga ila imadid tutui ngan tibur toa gergeu ienono ngan. ");
INSERT INTO bch_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Tigera gigima toa oa iuot pade ta tinid igelgel kapei tau. ");
INSERT INTO bch_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ta gid tila lumaeai ta tigera gergeu toa oa toman ngan itna Maria. Ta tikor aed ga tidol laborad ga isulug tanoeai pan gergeu ta tisoa ieda. Ta tipokaka led apou ta tibada led tenainga ga iuot. Gid tipan ele gol, ga nabene, ga abei mer itekea kemikemi. ");
INSERT INTO bch_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Be ngan anunud Deo ipabib led ngan tiluagid mulian pan Erot mao. Tota tinasi edap ede pade ta tiluagid ga tila led tuangai. ");
INSERT INTO bch_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Gid kapeipei oatainga ad tiluagid mulian ga kus, be mole mao anggelo ton Maron iuot pan Iosep ngan ianun ta ikeo, “Eao dae ta bada gergeu toman ngan itna, ta gimi tol aeaoa ga ala Isip. Ta amamado toa eoa ga irangrang ngan naposa pago pade. Ngansa Erot iuangga ilo gergeu toa ne ta ipaeabu ngan ei.” ");
INSERT INTO bch_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tota bong maitne, Iosep idae ta ibada gergeu toman ngan itna ta tiaoa ga tila Isip. ");
INSERT INTO bch_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ta tidio toa eoa ga irangrang ngan Erot imate. Danga toa ne iuot ta iparangrang Maron ele posanga mambe eaba ibada Deo iaoa mugaeai ikeo ngan bedane, “Gau nababa natug ta itnan tibur Isip ga inam.” ");
INSERT INTO bch_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Erot isanga gid kapeipei oatainga ad ga mao, ta iuatai mambe tipakaka ei, ta ilolo bake paeamao tau. Tota isula ele panua paraunga ad ga tila Betleem ga gid tuanga boloma ngan, ta tipamate gid gergeu arangaranga toa ngada oa ad rai rua ga isulug. Ei imata nanan gid kapeipei oatainga ad led posanga ngan gigima ele otnga, ta iuade gid gergeu ad rai toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Be kadonga toa ne iuot ta iparangrang Deo ele posanga ede. Ieremaia ibada Deo iaoa mugaeai ta ibode posanga bedane, ");
INSERT INTO bch_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Tilongo tandanga kapei ga keoainga iuot ngan tuanga Rama. Eine Resel itangtang ngan gid ele gergeu. Ei ilolo isat kapei, be itin ngan panua tipamus ei mao, ngansa ele gergeu timate gid ga kus.” ");
INSERT INTO bch_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Idio ta Erot imate, be mole mao anggelo ton Maron ila Isip ta iuot pan Iosep ngan ianun ");
INSERT INTO bch_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ta ikeo, “Eao dae ta bada gergeu toman ngan itna ta aluagimi ga ala ngan tibur Israel. Ngansa gid panua toa tiuangga tipamate gergeu ne, timate na.” ");
INSERT INTO bch_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tota Iosep idae ta ibada gergeu toman ngan itna ta tiluagid mulian Israel. ");
INSERT INTO bch_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Be Iosep ilongo mambe Arkelaus ibada itama Erot imul ta iman maron kapei togid Iuda, tota imataud ngan langa toa eoa. Be ngan Iosep ianun, Deo ipabib ele, ta ila imado ngan tibur Galili ");
INSERT INTO bch_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ngan tuanga Nasaret. Kadonga toa ne iuot ta iparangrang posanga ede gid panua tibada Deo iaoa mugaeai tikeo ngan ga bedane, “Gid ga tiuato ei eaba Nasaret aea.” ");
INSERT INTO bch_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ngan taun toaiua, Ioanes Paliliunga aea ila ngan tibur modamodanga ede ngan tibur Iudea ta ipaola posanga ga ila pagid ipom ");
INSERT INTO bch_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","bedane, “Gimi apul lolomi ga apatutui lemi kadonga! Ngansa teta pade madonga Deo ibageai ga iuot.” ");
INSERT INTO bch_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Be Ioanes ei eaba toa mugaeai Aisaia ibada Deo iaoa ta ikeo ngan ei bedane, “Ngan tibur modamodanga, eaba ede ipotalae ta ikeo, ‘Gimi manta asaoa Maron ele edap ga apatutui kemi ngan ele namanga pagimi.’” ");
INSERT INTO bch_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Be Ioanes ipit aea malo tikado ngan kamel ilaun, ga ikaukau irabu ngan aea pus tikado ngan bulmakao itin kukul. Be ianean gurisi ga iunun bon isul tibur aea. ");
INSERT INTO bch_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Idio ta panua busa Ierusalem, ga gid tuanga padengada Iudea, ga gid tuanga boloma ngan eau Iordan tila pan Ioanes. ");
INSERT INTO bch_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ta tiuaoa ngan led kadonga sasat, ta Ioanes ipaliliu gid ngan eau Iordan. ");
INSERT INTO bch_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Be ei igera gid Parisi ga Sadiusi busa tinama ngan badanga paliliunga pade, ta ikeo pagid bedane, “Gimi mota ele gergeu! Sai ipabuobuo gimi ta aoangga abada paliliunga sapaean ta asapir ngan Deo ele kadonga lolo bake aea? Gimi arangrang mao. ");
INSERT INTO bch_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Be oangga apul lolomi, manta apatutui lemi kadonga pade, ta ipasolan mambe gimi apul lolomi tautaunga. ");
INSERT INTO bch_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Be kado gimi apakaka gimi mulian ta aoangga gimi iaoa kelede pan Abraam, ta ngan ipu toaine Deo ga ipanas gimi mao. Eine mao. Ngansa gau nakeo pagimi, Deo ipapauis ngan gid iaoa kelede pan Abraam mao. Oangga ikim, ei irangrang ngan ikado ga gid patpat toa ne tiuot iaoa kelede pan Abraam. ");
INSERT INTO bch_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Be kabasi ienono motean abei ipuiai. Ta abei isaoa itautau iuot kemikemi mao, eine ga iged ga isulug ta itado ga idae dingaeai. ");
INSERT INTO bch_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Gau napaliliu gimi ngan eau iman kilala ngan gimi apul lolomi. Be eaba ede ga inam muriai ngan gau, ei iura kapei ngan gau. Ei iasal gau tau, ta irangrang ngan nalua ei ngan ele su aea kisinga mao. Ei ga ipaliliu gimi ngan Itautau Tutui ga dinga. ");
INSERT INTO bch_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ei mambe eaba ikisi duduinga kapei ta ilelean sakirkir toa ngada oa ienono ngan wit. Ta ei ga isuk gid wit itautau kemikemi ta idol ngan luma wit aea. Be itado wit aea sakirkir ga idae dingaeai. Dinga toa oa irangrang ngan imate mao.” ");
INSERT INTO bch_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Idio ta Iesus itnan tibur Galili ta ila pan Ioanes ngan eau Iordan ngan Ioanes ipaliliu ei. ");
INSERT INTO bch_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Be Ioanes iuangga ipaidi ei ta ikeo, “Gau napapauis ngan eao paliliu gau, be keo ga gau napaliliu go ngan saoa?” ");
INSERT INTO bch_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ta Iesus ikoli ele posanga bedane, “Longo. Patautene eao nasi mambe nakeo ngan. Ngansa gita manta taparangrang kadonga tutui toa ngada ne.” Tota Ioanes ilongo ta ipaliliu ei. ");
INSERT INTO bch_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iesus ibada paliliunga ga kus ta itnan eau ga idae. Be mole mao bubur ipokakai, ta igera Deo Itautau Tutui isulug ga inam pan mambe man barur, ta itamaroro ga isulug pan. ");
INSERT INTO bch_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Be babanga ede isulug buburiai ga inam ta ikeo, “Eine gau Natug toa nakim ei tau. Tinig igelgel ngan ei.” ");
INSERT INTO bch_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Idio ta Itautau Tutui ibada Iesus ga ila ngan tibur modamodanga ta eaba paeamao itoba ei. ");
INSERT INTO bch_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iesus iplese annga ga irangrang ngan aea ado ga bong sangaul pange. Ila ga pitoreanei kapei tau. ");
INSERT INTO bch_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Be eaba paeamao tobanga aea ila pan ta ikeo, “Oangga eao Deo Inat, posa ngan gid patpat toa ne ta tiuot am bret.” ");
INSERT INTO bch_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Be Iesus ikoli ele posanga ta ikeo, “Deo ele laulau aea posanga bedane, ‘Gid panua tirangrang ngan badanga madonga kemi ngan eannga bret kekelen mao. Be tibada madonga kemi ngan longonga Deo ele posanga toa ngada ne.’” ");
INSERT INTO bch_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Idio ta eaba paeamao ibada ei ga tila Deo ele tuangai Ierusalem ta ipamadid ei gadae Deo ele luma kapei ipaoeai. ");
INSERT INTO bch_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Ta ikeo pan, “Oangga eao Deo Inat, dug ga sulug. Ngansa Deo ele laulau aea posanga bedane, “‘Ei ga ikeo pagid ele anggelo ta matad ikikisi go, ta tisoa go ngan baged, ngan kado ta pat eta igal aem.’” ");
INSERT INTO bch_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Be Iesus ikeo pan bedane, “Deo ele laulau aea posanga ede pade ikeo ga, ‘Eao toba am Maron Deo padam.’” ");
INSERT INTO bch_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ga kus ta eaba paeamao ibada ei ga ila ta tidae ngan lusi ede gadae tau. Ta ipasolan ei ngan tibur kapei togid mamaron kapeipei toa ngada ne tanoeai ga led danga sisid kemikemi. ");
INSERT INTO bch_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ta ikeo pan, “Oangga eao kor aem ta soa gau edag, gau ga napan danga sisid toa ngada ne ga iman lem.” ");
INSERT INTO bch_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ta Iesus ikeo pan bedane, “Satan, eao la aluai! Ngansa Deo ele laulau aea posanga bedane, ‘Eao manta soa am Maron Deo ieda, ta eao kikisi ei kekelen ele naurata.’” ");
INSERT INTO bch_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tota eaba paeamao itnan ei, be mole mao gid anggelo tinam tilua ei. ");
INSERT INTO bch_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Idio ta Iesus ilongo mambe tidol Ioanes Paliliunga aea ga idudunga ngan luma panasnga aea, ta ei iluai mulian ga ila Galili ");
INSERT INTO bch_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ngan tuanga Nasaret. Be itnan tuanga Nasaret ta ila imado ngan tuanga Kapernaum toa liu kapei Galili isaleai, ngan tano togid Sebulun ga Naptali. ");
INSERT INTO bch_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kadonga toa ne iuot ta iparangrang Deo ele posanga ede. Aisaia ibada Deo iaoa mugaeai ta ibode posanga bedane, ");
INSERT INTO bch_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ngan tano togid Sebulun ga Naptali, ngan edap ila ngan liu kapei, iadag ngan eau Iordan, ngan tibur kapei Galili, gid panua Israel ad mao timamado. ");
INSERT INTO bch_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Gid mambe panua timamado ngan tibur dodom, be tigera taranga kapei. Ngan tibur dodom toa mugaeai timamado ngan oa timataud matenga, be Deo ele taranga kapei itara gid.” ");
INSERT INTO bch_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tota ngan ado toaiua ga ila, Iesus ipaola posanga bedane, “Gimi apul lolomi ga apatutui lemi kadonga! Ngansa madonga Deo ibageai tota iuot ne.” ");
INSERT INTO bch_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Idio ta ipapaele labiai ngan liu kapei Galili ta igera panua rua, Saimon toa tiuato ei Petrus, ga itar kakau Andreas, titatado puo liuiai ngansa gisirua tibabada ia iman led pat aea. ");
INSERT INTO bch_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ta ikeo pagisirua, “Gimirua anama anasi gau, ta gau ga napaoatai gimi ngan badanga panua ga tinam pagau, mambe labone ababada ia.” ");
INSERT INTO bch_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mole mao gisirua titnan led puo ga idio, ta tila tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Idio ta ilalala pade, ta igera panua rua pade, Jems toa Sebedi inat, ga itar kakau Ioanes. Gisirua timamado oagaeai toman ngan tamad Sebedi, be tiaman led puo. Ta Iesus ibaba gisirua. ");
INSERT INTO bch_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Mole mao, titnan tamad ga idio oagaeai ta tila tinasi Iesus. ");
INSERT INTO bch_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tota Iesus ilalala ga ila ngan tuanga toa ngada oa Galili, ta ipapaoatai gid panua led luma raring aea iloleai. Ta ipaola ato kemi ngan madonga Deo ibageai, ga ikemikemi gid panua ad dibala imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tota iualu ilado ga ipakaranga tuanga toa ngada oa Siria. Ta gid titaltal panua ad dibala imata ede ga ede ta tila pan. Edengada ieieinga kapei ikado gid, ga padengada iriau papaeamao ienono ngan gid, ga padengada dibala kakapanga ikado gid, ga padengada aed ga baged imate. Ta Iesus ikado kemi gid. ");
INSERT INTO bch_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Be ipom busa Galili, ga Dekapolis, ga tuanga Ierusalem, ga gid tuanga padengada Iudea, ga gid tuanga iadag ngan eau Iordan, gid busa tinasi Iesus somisomi. ");
INSERT INTO bch_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iesus igera gid ipom busa ta idae ga ila lusiai. Ei idio imado, ta ele aluagau tinam pan, ");
INSERT INTO bch_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ta ipaoatai gid ta ikeo ga, ");
INSERT INTO bch_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kemi tau ngan gid panua toa tiuatai mambe tirangrang mao Deo imatai! Ngansa gid timamado Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Kemi tau ngan gid panua toa lolod itangtang! Ngansa Deo ga ipamus gid. ");
INSERT INTO bch_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kemi tau ngan gid panua toa tiparim ngan gid mulian mao! Ngansa Deo ga ipan tano toa ngada ne ga iman ad. ");
INSERT INTO bch_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Kemi tau ngan gid panua toa tikim kadonga tutui, mambe eaba pitoreanei ga marumian ei! Ngansa Deo ga iparangrang gid mambe eaba ian ga iapa isum. ");
INSERT INTO bch_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Kemi tau ngan gid panua toa lolod isat ngan panua padengada! Ngansa Deo ga ilolo isat ngan gid. ");
INSERT INTO bch_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Kemi tau ngan gid panua toa lolod aea danga eta mao! Ngansa gid ga tigera Deo ngan matad. ");
INSERT INTO bch_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Kemi tau ngan gid panua toa tipamate ariapolpol ga tipatarui panua lolod! Ngansa Deo ga iuato gid ele gergeu. ");
INSERT INTO bch_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Kemi tau ngan gid panua toa tinasi kadonga tutui, be ngan ipu toaine panua padengada tikado kulupu ngan gid! Kemi tau ngan gid, ngansa gid timamado Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Oangga panua tigera gimi anasi gau, be ngan ipu toaine tidaba gimi sat, ga tikado kulupu ngan gimi, ga tipakaka ta tisol gimi ngan posanga papaeamao imata ede ga ede, kemi tau ngan gimi! ");
INSERT INTO bch_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Manta lolomi kemi ga tinimi igelgel, ngansa gimi ga abada lasunga kemi tau buburiai. Danga kulupulupu toa iuot ngan gimi, eine iuot toa bedaoa pade ngan gid panua tibada Deo iaoa mugaeai.” ");
INSERT INTO bch_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Iesus ikeo pade bedane, “Ngan lemi kadonga rabu ngan gid panua tanoeai ad, gimi mambe sol ikado annga ga imana kemi ta irangrang ngan ibuda manmanae mao. Be oangga sol imana kus, irangrang ngan gimi akado ga imana iluai mulian mao. Sol toa bedaoa eine kemi ngan danga eta mao. Eine panua tisiran ga iduaea ta tiuadoad ngan aed. ");
INSERT INTO bch_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Gimi mambe taranga ngan gid panua tanoeai ad. Tuanga ienono gadae bereoeai irangrang ngan imumul mao. ");
INSERT INTO bch_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ga pade, oangga tatun lam, eine tarobi ngan ulo mao. Be gita tadol ga idae ngan lam imul ta itara gid panua toa ngada oa luma iloleai. ");
INSERT INTO bch_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Toa bedaoa ta lemi kadonga manta iuot panua matadeai, mambe lam itara gid. Ta irangrang ngan tigera lemi kadonga kemikemi ta tisoa Tamami toa buburiai oa ieda.” ");
INSERT INTO bch_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Iesus ikeo pade bedane, “Kado gimi aoangga gau nanama ngan samumnga Deo ele apu ga posanga togid panua tibada Deo iaoa. Eine mao. Gau nanama ngan samumnga mao, be nanama ngan naparangrang posanga toa oa ga iuot tautaunga. ");
INSERT INTO bch_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ngansa nakeo tautaunga pagimi, tano ga mariamba ga isapa, be irangrang ngan Deo ele apu aea posanga idil eta isapa mao. Ele apu imatua ga ienono toa bedaoa ga irangrang ngan aea posanga toa ngada oa iuot tautaunga. ");
INSERT INTO bch_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tota oangga sai ipul imur ngan Deo ele posanga idil kakau eta, ga ipaoatai gid panua ngan pulnga murid ngan ele posanga toa bedaoa pade, eine eaba toa oa ieda ga isulug gadio tau ngan gid panua timamado Deo ibageai. Be oangga sai inasi Deo ele apu ga ipapaoatai gid panua ngan nasinga kemi toa bedaoa, eine eaba toa oa ieda ga iuot kapei rabu ngan gid panua timamado Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ngansa gau nakeo pagimi, oangga lemi kadonga tututui iasal kadonga togid madidnga apu ad ga togid Parisi mao, eine irangrang ngan gimi abada madonga Deo ibageai mao.” ");
INSERT INTO bch_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Iesus ikeo pade bedane, “Gimi aoatai ngan posanga ga oaine tibutibuda tibada mugaeai, ‘Irangrang ngan eao pamate eaba ede pade mao. Be oangga sai ipamate eaba ede pade, ei ga imadid ngan posanga kapei ta ibada panasnga ngan ele kadonga sat.’ ");
INSERT INTO bch_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Be gau nakeo pagimi ga bedane: Oangga sai ilolo bake ngan iuae ede pade, ei ga imadid ngan posanga kapei ta ibada panasnga. Be oangga sai idaba iuae ede pade ta ikeo, ‘Eao mangamanga!’ ei ga imadid ngan posanga pagid madidnga patutuinga posanga ad matadeai. Be oangga sai idaba iuae ede pade ta ikeo, ‘Laboram pat!’ ei ele idil paeamao ta irangrang ngan ila ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Tota oangga eao tal lem tenainga ga ila Deo ele popouiai, be toa eoa matam nanan mambe oaem ede pade ele selelenga ngan go, ");
INSERT INTO bch_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tota tnan lem tenainga ga idio. La pan oaem ge ta nasi edap ngan gimirua lolomi itarui mulian. Ga kus ta tal lem tenainga ga ila pan Deo. ");
INSERT INTO bch_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Be oangga eaba eta ikeo ga ipamadid go ngan posanga, mugaeai ngan gimi ala, eao manta patutui posanga toa na manmanae, ta ilolo kelede mulian toman ngan go. Ngan kado ta idol go pan eaba patutuinga posanga aea ibageai, ta ei ibada go ga la pan madidnga togid nakala, ta tidol go ga dudunga ngan luma panasnga aea. ");
INSERT INTO bch_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nakeo tautaunga pago, irangrang ngan eao tnan luma panasnga aea toa oa mao, ga irangrang ngan eao ol mulian lem idil papaeamao toa ngada oa.” ");
INSERT INTO bch_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Iesus ikeo pade bedane, “Gimi aoatai ngan posanga mugaeai aea ga bedane, ‘Irangrang ngan eao kado kadonga arala ta paeabu ngan oainga mao.’ ");
INSERT INTO bch_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Be gau nakeo pagimi ga bedane: Oangga sai imata inono taine be ilolo paeamao ngan ei, eaba toa oa ele kadonga sat, ngansa ikado kadonga arala ngan ei toa iloleai oa. ");
INSERT INTO bch_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Be oangga matam eta idada go ngan kadonga sat, pasu matam toa ga iduaea. Kemi ngan matam eta ipasui ga ila. Be paeamao oangga matam rua ta tinim dodol ila ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Be oangga bagem oatai idada go ngan kadonga sat, ket bagem toa ga iduaea. Kemi ngan bagem eta blos ga ila. Be paeamao oangga tinim dodol ila ngan dinga imperno.” ");
INSERT INTO bch_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iesus ikeo pade bedane, “Be posanga mugaeai aea ede pade ga bedane, ‘Oangga sai isuk iadaoa, ei manta ibada laulau ga ila pan iadaoa ngan ketnga led oainga.’ ");
INSERT INTO bch_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Be gau nakeo pagimi ga bedane: Oangga eaba iadaoa ikado kadonga arala eta mao, be eaba toa oa isuk ei, eine ikado ga iadaoa iuot mambe taine arala aea (oangga iuai pau pade). Ngansa Deo imatai, led oainga ienono maitne. Ga oangga eaba pau iuai taine toa oa, ei pade ikado kadonga arala.” ");
INSERT INTO bch_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Iesus ikeo pade bedane, “Be gimi aoatai posanga ede pade ila pagid tibutibuda ga bedane, ‘Oangga eao kado posanga tautaunga gadae, irangrang ngan eao pakaka mao. Be eao manta parangrang posanga toa oa ga iuot tautaunga Deo imatai.’ ");
INSERT INTO bch_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Be gau nakeo pagimi ga bedane: Irangrang ngan eao kado posanga tautaunga gadae eta mao. Be eao oato bubur ngan pamatuanga lem posanga padam. Ngansa bubur eine mul madonga aea ton Deo. ");
INSERT INTO bch_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Be oato tano ngan pamatuanga lem posanga padam. Ngansa tano eine mul toa Deo idol iae gadae ngan. Be oato Ierusalem ngan pamatuanga lem posanga padam. Ngansa Ierusalem eine tuanga ton ada Maron kapei. ");
INSERT INTO bch_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Be irangrang ngan eao oato eao mulian ngan pamatuanga lem posanga mao pade. Ngansa eao rangrang ngan kado launim eta ga iuot mama mao ga kusuksuk mao pade. ");
INSERT INTO bch_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Be kemi ngan gimi oangga akeo ga bedane, ‘Be. Gau ga nakado.’ Ga mao, akeo bedane, ‘Gau ga nakado mao.’ Posanga toa bedaoa ikaranga. Be oangga akado posanga eta pade ngan pamatuanga lemi posanga, eine eaba paeamao ikado ga iuot.” ");
INSERT INTO bch_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Iesus ikeo pade bedane, “Gimi aoatai posanga mugaeai aea ga bedane, ‘Oangga eaba eta ipaeabu ngan eaba ede pade imata kadlo mao iluo, tota akoli bedaoa ga ila pan pade.’ ");
INSERT INTO bch_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Be gau nakeo pagimi ga bedane: Oangga eaba eta ikado paeamao ngan go, eao paidi ei mao. Be oangga eaba eta ipoda papam, pul papam iadag ga ila pan pade. ");
INSERT INTO bch_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Be oangga eaba eta ipamadid go ngan posanga ta iuangga tinim aea pononga iman ele, tota bada lem pononga gaot aea ga ila pan pade. ");
INSERT INTO bch_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Be oangga eaba eta ipaeaea go ta ikeo ga eao bisi ele danga sisid ga ila irangrang ngan kilomita ede, eao bisi ga ila irangrang ngan kilomita rua. ");
INSERT INTO bch_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Be oangga sai igau danga eta pago, ta eao bada pan. Be oangga sai ikeo ga lem pat mao danga eta pade ila pan ta iuanana, eao palua ei sapaean mao.” ");
INSERT INTO bch_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Iesus ikeo pade bedane, “Be gimi aoatai posanga mugaeai aea ga bedane, ‘Eao manta kim oaem ede pade, be lolom paeamao ngan am miri itamatama.’ ");
INSERT INTO bch_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Be gau nakeo pagimi, manta akim ami miri itamatama. Ta araring ngan luanga gid panua tikakado kulupu ngan gimi. ");
INSERT INTO bch_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Toa bedaoa ta gimi aot gergeu ton Tamami buburiai. Ngansa ei ikado ele ado ga ipara ga idae ta itara gid panua papaeamao ga panua kemikemi pade. Be ikado aoara ga itap ngan luanga gid panua tututui ga gid panua kadonga sasat ad pade. ");
INSERT INTO bch_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngansa oangga akimkim gid panua toa tikimkim gimi, gimi ga abada saoa lasunga? Ngansa gid panua takis ad tikakado toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Be oangga akeo ‘ado kemi’ pagid oaeoaemi kekelegid, lemi kadonga iasal kadonga ton eaba eta pade mao. Ngansa gid panua toa timangamanga ngan Deo tikakado toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tota gimi manta aot tutui tau, mambe Tamami buburiai ei tutui tau.” ");
INSERT INTO bch_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iesus ikeo pade bedane, “Gimi agabit kemi. Ngan kado ta akim gid panua tigera lemi kadonga tututui ta apasolan pagid panua busa matadeai. Toa bedaoa ta gimi ga abada lasunga eta inam pan Tamami buburiai mao. ");
INSERT INTO bch_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Ta oangga eao lua gid panua lululunga ad, irangrang ngan eao kado mambe gid panua pakakanga ad mao. Gid tisula eaba imuga ngan gid ta iuso taule panua busa matadeai ta iman kilala ngan led kadonga kemi. Tikakado bedaoa luma raring aea iloleai ga melemeleai ngansa tikim panua busa tigera gid ta tisoa edad. Nakeo tautaunga pagimi, gid tibada ad lasunga o. ");
INSERT INTO bch_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Be oangga eao lua gid panua lululunga ad, kado mumulnga, ta irangrang ngan oaem toa kemi na pade iuatai ngan mao. ");
INSERT INTO bch_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Toa bedaoa ta lem kadonga lolo isat aea ga ienono mumulnga. Ta Tamam toa igera danga mumulnga toa ngada oa ga ikoli kemi pago.” ");
INSERT INTO bch_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Iesus ikeo pade bedane, “Be oangga gimi araring, akado mambe gid panua pakakanga ad mao. Ngansa gid tikim tau ngan kadonga raring panua busa matadeai toa luma raring aea iloleai ga melemeleai, ta panua busa tigera gid. Nakeo tautaunga pagimi, gid tibada ad lasunga o. ");
INSERT INTO bch_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Be oangga eao raring, eao dudunga lem luma iloleai ta saisai atama ta raring ga ila pan Tamam toa imamado mumulnga. Ta Tamam toa igera danga mumulnga toa ngada oa ga ikoli kemi pago. ");
INSERT INTO bch_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Be oangga gimi araring, akado mambe gid panua toa timangamanga ngan Deo oa tikakado mao. Gid tikado posanga busa sapaean, ta tiuangga ad deo ga ilongo gid ngan led posanga mamarae. ");
INSERT INTO bch_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Irangrang ngan anasi led kadonga mao. Ngansa gimi abeta Tamami maitne, be ei iuatai ngan saoa danga apapauis ngan. ");
INSERT INTO bch_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Tota gimi araring ga bedane, “‘Tamamai buburiai, manta panua tilolon ngan eao edam. ");
INSERT INTO bch_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kemi ngan danga toa ngada ne idae eao bagemeai, ga eao lem kimnga iuotot tanoeai mambe iuotot buburiai pade. ");
INSERT INTO bch_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Amai annga ado ga ado, eao pan gai ngan labone pade. ");
INSERT INTO bch_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Be samum lemai kadonga sasat, mambe gai pade asamum togid panua tikado sat pagai. ");
INSERT INTO bch_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pakala gai ta irangrang ngan atap ngan tobanga mao, be bada gai mulian ngan danga paeamao.’ ");
INSERT INTO bch_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ngansa oangga asamum gid panua led kadonga sasat, eine Tamami buburiai ga isamum gimi lemi kadonga sasat pade. ");
INSERT INTO bch_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Be oangga asamum gid panua led kadonga sasat mao, eine Tamami ga isamum gimi lemi kadonga sasat mao pade.” ");
INSERT INTO bch_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Iesus ikeo pade bedane, “Be oangga gimi aplese annga, irangrang ngan matami imalai alele mambe gid panua pakakanga ad tikakado mao. Gid tikado ga matad iuot paeamao ngansa tikim panua busa tiuatai mambe lolod isat ga tiplese annga. Nakeo tautaunga pagimi, gid tibada ad lasunga o. ");
INSERT INTO bch_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Be oangga eao plese annga, kado ga bedane: liliu kemi, ga men matam, ga sama laboram ngan bude mambe somisomi. ");
INSERT INTO bch_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Toa bedaoa ta irangrang ngan eaba eta iuatai ngan eao plese annga mao. Be Tamami imamado mumulnga, ei kekelen iuatai. Ta Tamami toa igera danga mumulnga toa ngada oa ga ikoli kemi pago.” ");
INSERT INTO bch_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Iesus ikeo pade bedane, “Irangrang ngan agor lemi danga sisid kemikemi tanoeai mao. Ngansa nene tanoeai lemi danga sisid imotmot, ga ngorongoro tipaeabu ngan, ga panua lublubnga ad tigoro lemi luma ga tilub lemi danga sisid. ");
INSERT INTO bch_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Be kemi ngan gimi agor lemi danga sisid kemikemi buburiai. Toa eoa lemi danga sisid imotmot mao, ga ngorongoro tirangrang ngan tipaeabu ngan mao, ga panua lublubnga ad tirangrang ngan tilub mao pade. ");
INSERT INTO bch_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngansa oangga lem danga sisid kemikemi ienono tanoeai, lolom pade ga inasi gid danga tanoeai aea. Be oangga lem danga sisid kemikemi ienono buburiai, lolom pade ga inasi gid danga buburiai aea.” ");
INSERT INTO bch_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Iesus ikeo pade bedane, “Matada kadlo eine mambe lam ngan tinida. Tota oangga matam igeragera kemi, eine tinim toa ngada na ga iuon ngan taranga. ");
INSERT INTO bch_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Be oangga matam paeamao, tinim toa ngada na pade ga iuot dodom. Tota oangga taranga toa lolomeai na imate, eine dodom toa na kapei tau!” ");
INSERT INTO bch_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Iesus ikeo pade bedane, “Eaba eta irangrang ngan iboko gadio ngan madidnga rua mao. Ngansa ei ga ilolo paeamao ngan ede, be ilolo ikim ede pade. Be ei ga ilongo ede ilinge, be ipul imur ngan ede pade. Irangrang ngan pat iman ami maron toman ngan Deo mao.” ");
INSERT INTO bch_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Iesus ikeo pade bedane, “Tota nakeo pagimi, gimi lolomi ede ga ede ngan lemi madonga mao, ga ngan ami annga ga eau mao, ga ngan tinimi aea pononga mao pade. Ngansa tinimi eine danga kapei, be aea pononga eine danga kapei mao. Lemi madonga eine danga kapei, be annga eine danga kapei mao. ");
INSERT INTO bch_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Matami nanan gid man. Gid tiarum annga mao, ga tibada annga dadangai ga inam tigor led lumaeai mao pade. Be Tamami buburiai ipanpan gid. Ega, ngan Deo imata, gimi kapei tau ngan gid man. ");
INSERT INTO bch_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Be sai ngan gimi ngan ele kadonga lolo ede ga ede irangrang ngan igalbatan ado imata kelede ngan ele madonga tanoeai? ");
INSERT INTO bch_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Be ikamado ga lolomi ede ga ede ngan lemi pononga? Matami nanan gid koko tiburiai. Gid tipara madongan? Gid tiboko mao, ga tikado ad malo mao pade. ");
INSERT INTO bch_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Be gau nakeo pagimi, sogonga togid koko toa ne iasal tau maron kapei Solomon aea sogonga pade. ");
INSERT INTO bch_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gid koko tiparapara tiburiai labone, be sabale iman abei ibedbed. Be oangga Deo ipasogo gid koko kemi toa bedaoa, eine ga idol tinimi aea pononga pade. Ikamado ga lemi kadonga lolo matua aea kapei mao? ");
INSERT INTO bch_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tota lolomi ede ga ede ngan ilonga saoa danga aoangga aeanean ga aunun oa mao. ");
INSERT INTO bch_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ngansa gid panua toa timangamanga ngan Deo oa lolod ede ga ede ta tiloilo gid danga sisid toa bedaoa. Be Tamami buburiai iuatai ngan danga toa ngada ne gimi apapauis ngan. ");
INSERT INTO bch_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Be danga kapei gimi manta amarum ngan ilonga, eine lemi madonga Deo ibageai ga ele kadonga tutui iparangrang gimi. Oangga akado toa bedaoa, ei ga ibada danga toa ngada ne pagimi pade. ");
INSERT INTO bch_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tota lolomi ede ga ede ngan sabale padam. Ngansa sabale ga inam toman ngan aea kadonga kulupulupu pade. Be gid danga kulupulupu labone aea, ikaranga ngan labone.” ");
INSERT INTO bch_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iesus ikeo pade bedane, “Gimi aselele panua padengada padam. Ngan kado ta Deo iselele gimi pade. ");
INSERT INTO bch_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngansa Deo ga iselele gimi lalaede mambe gimi aselele panua padengada. Be saoa kadonga gimi akakado pagid panua padengada, ngan kadonga toa ne, Deo ga ikoli pagimi pade. ");
INSERT INTO bch_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Be eao kamado gera sakirkir kakauede ienono ngan oaem ede pade imata, be matam nanan abei kapitnami ienono eao matameai mao? ");
INSERT INTO bch_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Eao keo pan oaem ede pade bedane, ‘Nam boloma ta nasile sakirkir kakauede ienono matameai,’ be ega, abei kapitnami ta ienono ngan eao matam! ");
INSERT INTO bch_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eao eaba pakakanga am! Pul abei kapitnami ienono eao matameai bua, ga kus ta matam igera kemi, ta eao rangrang ngan sile sakirkir kakauede ienono ngan oaem ede pade imata. ");
INSERT INTO bch_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Gid danga kemikemi ton Deo, gimi abada ga ila pagid kaua mao. Ngan kado ta tipul gid ta tingot gimi. Be lemi nagemgem kemikemi, atado ga ila pagid gaea mao. Ngan kado ta tiuadoad ngan aed.” ");
INSERT INTO bch_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Iesus ikeo pade bedane, “Gimi abetabeta Deo, ta ei ga ibada pagimi. Gimi ailoilo saoa danga pan Deo, ta gimi ga aot ngan. Gimi atintin atama, ta Deo ga irepe ngan gimi. ");
INSERT INTO bch_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngansa eaba sai ibetabeta Deo, ei ga ibada saoa danga ibeta ei ngan. Ga eaba sai iloilo danga inam pan Deo, ei ga iuot ngan. Ga eaba sai itintin atama, Deo ga irepe ngan ei. ");
INSERT INTO bch_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Sai ngan gimi, oangga inat ibeta ei ngan badanga annga pan, eine ga ibada patpat pan? Na? Oo, eaba eta ikado bedaoa mao! ");
INSERT INTO bch_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Be oangga ibeta ei ngan ia, eine ga ibada mota pan? Na? Mao tau! ");
INSERT INTO bch_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Tautaunga gimi panua papaeamao, be somisomi aoatai ngan badanga danga kemikemi ga ila pagid lemi gergeu. Be Tamami buburiai iasal gimi ngan kadonga kemikemi, ta ei ga ibada danga kemikemi tau pagid panua tibeta ei ngan. ");
INSERT INTO bch_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Tota saoa kadonga gimi akim gid panua tikado ngan gimi, gimi akado toa bedaoa pade ngan gid. Ngansa kadonga toa ne, eine posanga ipu ngan Deo ele apu ga posanga togid panua tibada Deo iaoa mugaeai.” ");
INSERT INTO bch_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Iesus ikeo pade bedane, “Gimi manta adudunga ngan atama kakauede. Ngansa atama ila ngan dinga imperno eine kapei, ga aea edap maknga ga ienono. Ta panua busa tidudunga ngan atama toa oa. ");
INSERT INTO bch_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Be atama ila ngan madonga kemi, eine kakauede tau, ga aea edap iuanaoana tau ngan nasinga. Ta panua keledengada tigera ga tinasi.” ");
INSERT INTO bch_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iesus ikeo pade bedane, “Gimi agabit kemi ngan panua pakakanga ad tikeo ga tibada Deo iaoa. Gid mambe kaua saksak tipit sipsip itin kukul ta tila rabu ngan gid sipsip ta tipaeabu ngan gid. ");
INSERT INTO bch_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Oangga matami inasi annga saoa iuotot ngan led kadonga, gimi ga aoatai ngan gid. Ngansa oain itautau irangrang ngan iuot ngan oaroaro aea gigi mao. Be abei fik itautau irangrang ngan iuot ngan purup aea asile mao pade. ");
INSERT INTO bch_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Toa bedaoa ta gid abei kemikemi tautaudid iuot kemikemi, be gid abei papaeamao tautaudid iuot papaeamao. ");
INSERT INTO bch_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Abei kemi irangrang ngan itautau iuot papaeamao mao. Be abei paeamao irangrang ngan itautau iuot kemikemi mao pade. ");
INSERT INTO bch_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Be abei isaoa itautau iuot kemikemi mao, eina ga tiged ta titado ga idae dingaeai. ");
INSERT INTO bch_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tota matami inasi saoa annga iuotot ngan led kadonga, ta aoatai ngan gid. ");
INSERT INTO bch_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Kado gimi aoangga panua toa busa ne tiuatoato gau ‘Maron, Maron,’ ga tibada madonga Deo ibageai. Eine mao. Be gid panua tinasi Tamag buburiai ele kimnga, gid kekelegid ga tibada madonga Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Muriai oangga Deo ipamadid gid panua ngan posanga, panua busa ga tikeo pagau bedane, ‘Maron, Maron, ngan eao edam gai abada Deo iaoa. Ga gai asere iriau papaeamao ngan eao edam. Ga gai akado gid uisinga ngan eao edam. Be matam nanan mao?’ ");
INSERT INTO bch_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Be ngan ado toaiua, gau ga nakeo tutui pagid bedane, ‘Mugaeai ga inama, gau naoatai ngan gimi mao. Gimi panua toa apul murimi ngan Deo ele posanga, ala aluai ngan gau!’” ");
INSERT INTO bch_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Iesus ikeo pade bedane, “Oangga sai ilongo leg posanga ga inasi, ei mambe eaba oatainga aea toa ipagun ele luma gadae ngan pat matua. ");
INSERT INTO bch_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ga muriai, aoara itap ga oanga imasesel, ta sariaba kapei inam ta inuga luma toa oa paeamao tau. Be luma toa oa grum ga isulug mao. Ngansa aea kadanga imadid ga idudunga ngan pat matua. ");
INSERT INTO bch_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Be oangga sai ilongo leg posanga be inasi mao, ei mambe eaba ilolo buobuo ta ipagun ele luma gadae ngan tano marum. ");
INSERT INTO bch_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ga muriai, aoara itap ga oanga imasesel, ta sariaba kapei inam ta inuga luma toa oa. Ta luma toa oa grum ga isulug be grok ga grok paeamao tau.” ");
INSERT INTO bch_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Idio ta Iesus ipasala ele posanga ga kus, be gid ipom timatala kapei ngan ele paoatainga. ");
INSERT INTO bch_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngansa ei ipaoatai gid mambe gid madidnga apu ad mao. Be ikado posanga mambe eaba ieda kapei. ");
INSERT INTO bch_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Idio ta Iesus isorir lusiai ga isulug, ta ipom kapei tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Be mole mao eaba ede aea dibala kankan inam ta ikor iae boloma pan ta ikeo, “Maron, oangga eao kim, eao rangrang ngan kado tinig ga iuot kemi Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Io, Iesus igaga ibage ta idol ngan ei ta ikeo, “Gau nakim. Ot kemi toa patautene.” Mole mao, tota itin iuot kemi. ");
INSERT INTO bch_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ta Iesus ikeo pan, “Eao gabit kemi. Keo pan eaba eta pade ngan mao. Be la pasolan tinim pan eaba tenainga aea, ta kado lem tenainga ngan tinim aea keminga, mambe Moses ele apu ikeo ngan. Kadonga toa oa ga ipasolan gid mambe tinim iuot kemi tautaunga.” ");
INSERT INTO bch_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Idio ta Iesus ila ngan tuanga Kapernaum, be madidnga paraunga aea ede togid Rom inam ta iansaban ei ta ikeo, ");
INSERT INTO bch_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“O Maron, leg paeaeanga idibal ta ienono imuliai. Iae imate, be itin ieiei paeamao tau.” ");
INSERT INTO bch_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ta Iesus ikeo, “Gau ga nala nakemi ei.” ");
INSERT INTO bch_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Be madidnga paraunga aea ikoli ele posanga bedane, “Maron, gau leg idil kemikemi imata karanga ngan eao nam dudunga leg lumaeai mao. Be eao dio nene ta kado posanga kekelen, ta leg paeaeanga ga iuot kemi. ");
INSERT INTO bch_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngansa gau pade namamado gadio ngan gid panua toa edad kapeipei, be leg panua paraunga ad timamado gadio ngan gau. Ta oangga nakeo pan ede, ‘Eao la,’ ei ga ila. Be oangga nakeo pan ede pade, ‘Eao nam,’ ei ga inam. Be oangga nakeo pan leg paeaeanga, ‘Eao kado naurata toa ne,’ ei ga ikado. Tota dibala toa ne ga ilongo lingem pade.” ");
INSERT INTO bch_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iesus ilongo bedaoa ta imatala ta ikeo pagid panua tinasi ei bedane, “Nakeo tautaunga pagimi, ngan panua toa ngada ne Israel, nagera eaba eta ele kadonga lolo matua aea kapei mambe eaba toa ne mao. ");
INSERT INTO bch_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Be nakeo pade pagimi, muriai panua busa ga tinam ado ele parangai ga ado ele dilngai ga tinam ta tibada gid mul ngan eaneannga kapei ngan madonga Deo ibageai toman ngan Abraam ga Aisak ga Iakop. ");
INSERT INTO bch_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Be gid panua Israel toa mugaeai timamado Deo ibageai, ei ga isere gid ga tila ngan tibur dodom, gaot ngan Deo ele tuanga kemi. Toa eoa ga titangtang paeamao ga luod kek ga kek.” ");
INSERT INTO bch_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ta Iesus ikeo pan madidnga paraunga aea bedane, “Eao la. Danga toa ne ga iuot lalaede mambe lolom matua ngan.” Io, tutui ngan ado imata toaiua, ele paeaeanga toa oa itin iuot kemi. ");
INSERT INTO bch_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Idio ta Iesus ila idudunga Petrus ele lumaeai ta igera Petrus ilaoa taine idibal ta ienono imuliai, be itin iuanaoana. ");
INSERT INTO bch_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Be Iesus ikisi ibage ta oanaoananga toa oa itnan ei. Tota taine toa oa idae ta ila ipan Iesus aea annga. ");
INSERT INTO bch_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ado idil ngan lailai toaiua, ta gid panua tuangai tital gid panua busa toa iriau papaeamao ienono ngan gid, ta tila pan Iesus. Ei ikado posanga kekelen ta gid iriau papaeamao titnan gid. Ta ikemi gid dibala tamad toa ngada oa pade. ");
INSERT INTO bch_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Kadonga toa ne iparangrang Deo ele posanga ede. Aisaia ibada Deo iaoa mugaeai ta ibode posanga bedane, “Ei ikado kemi ada dibala imata ede ga ede, ta isere gid ga tila aluai ngan gita.” ");
INSERT INTO bch_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iesus igera ipom kapei tibalil ngan ei, ta ikeo pagid ele aluagau ngan gisingada tila liu isal iadag. ");
INSERT INTO bch_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Be madidnga ede apu aea inam pan ta ikeo, “Eaba paoatainga am, gau ga nanasi go ngan tibur isaoa eao la ngan.” ");
INSERT INTO bch_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Be Iesus ikeo pan bedane, “Gid kaua saksak ad baba enonga aea tanoeai, ga gid man ad luma abeiai, be Eaba Inat ele tibur eta enonga aea mao.” ");
INSERT INTO bch_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Idio ta aluagau ede pade ikeo pan bedane, “Maron, longo ngan gau nala nataian tamag bua.” ");
INSERT INTO bch_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Be Iesus ikeo pan bedane, “Gid panua tiuatai ngan madonga kemi toman ngan Deo mao, gid tirangrang ngan titaian led panua matemate, be eao nam nasi gau.” ");
INSERT INTO bch_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Idio ta Iesus idae oagaeai, ta ele aluagau tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tiuot ga tila liu irabuiai, be mole mao sariaba kapei inam, ta sobo iuangga irobi led oaga. Be Iesus ienono. ");
INSERT INTO bch_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Gid tila pan ta tiuaoan ei ta tikeo, “Maron, kado taduaea ta! Lua gita!” ");
INSERT INTO bch_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Be ikeo pagid, “Ikamado ga amataud? Lemi kadonga lolo matua aea kapei eta mao.” Idio ta idae imadid ta idaba rai ga ngalu. Tota tibur madlo ituntun. ");
INSERT INTO bch_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Be gid panua toa oa timatala kapei ta tikeo, “Ei eaba madongan ta rai ga ngalu tilongo ilinge?” ");
INSERT INTO bch_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iesus iuot ngan liu isal iadag ta ila ngan tibur togid Gadara. Be panua rua toa iriau papaeamao ienono ngan gid, tiuot dengaeai ga tila pan. Gisirua matad saksak tau, ta gid panua tirangrang ngan tilalala ngan edap toa oa mao. ");
INSERT INTO bch_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Be mole mao gisirua tingangar pan ta tikeo, “Eao Deo Inat, eao ga kado mado ngan gai? Ado kolikolinga aea maitne, be eao nam ngan paieiei gai na?” ");
INSERT INTO bch_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Be gaea ipu kapei timadmadid aluai tede ga tianean. ");
INSERT INTO bch_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ta gid iriau papaeamao tibeta matua ei bedane, “Oangga sere gai, longean gai ta ala adudunga ngan gaea ipu ga oaiua.” ");
INSERT INTO bch_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ta ikeo pagid, “Ala!” Tota titnan panua rua ta tila tidudunga ngan gaea ipu toa oa. Be mole mao, gid gaea toa ngada oa tilado manmanae ga titaptap perpereai ga tisulug ngan liu kapei ta timatemate. ");
INSERT INTO bch_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Be gid panua toa timariala ngan gaea, tiaoa ga tila tuangai ta tipalongo ngan danga toa ngada oa, ga ngan panua rua toa iriau papaeamao titnan gid. ");
INSERT INTO bch_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Be mole mao, gid ipom tiuot ga tila ngan geranga Iesus. Tiuot pan ga kus ta tibeta matua ei ngan itnan led tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iesus idae oagaeai ta iuore ga ila liu isal iadag, ta ila ele tuangai. ");
INSERT INTO bch_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Be mole mao, panua edengada tibisi dibala tamad ede ga ila pan. Ei iae ga ibage imate, ta ienono ngan aea nagarengreng. Iesus igera led kadonga lolo matua aea ta ikeo pan dibala tamad bedane, “Leg eaba, pamatua lolom. Gau nasamum lem kadonga sasat na.” ");
INSERT INTO bch_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Be mole mao, gid madidnga apu ad tiposa pol ngan gid bedane, “Eaba toa ne iuangga ibada Deo imul!” ");
INSERT INTO bch_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Be Iesus iuatai ngan lolod ta ikeo, “Ikamado ga lolomi paeamao toa bedaoa? ");
INSERT INTO bch_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Posanga isaoa aea naurata malan: oangga nakeo, ‘Gau nasamum lem kadonga sasat,’ mao oangga nakeo, ‘Dae madid ta lalala’? ");
INSERT INTO bch_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Be gau ga napasolan gimi ta irangrang ngan aoatai kemi mambe Eaba Inat ieda kapei tanoeai ngan samumnga kadonga sasat.” Ta ikeo pan dibala tamad bedane, “Dae madid. Bada am nagarengreng ta la lem lumaeai.” ");
INSERT INTO bch_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tota eaba toa oa idae imadid ta ilalala ga ila ele lumaeai. ");
INSERT INTO bch_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Be gid ipom tigera ta titogragid ga tisoa Deo ieda. Ngansa ei ipamatua gid eababa ngan kadonga toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Idio ta Iesus ilalala ga ila ta igera eaba ede ieda Mateus imamado ngan luma takis aea. Ta ikeo pan, “Eao nam nasi gau.” Tota idae ga ila inasi ei. ");
INSERT INTO bch_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Idio ta gisirua timamado lumaeai ga tianean. Be panua busa takis ad ga kadonga sasat ad tinam tianean toman ngan Iesus ga ele aluagau. ");
INSERT INTO bch_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Be gid Parisi tigera bedaoa ta tikeo pagid ele aluagau bedane, “Ikamado ga lemi eaba paoatainga aea ianean toman ngan gid panua takis ad ga kadonga sasat ad?” ");
INSERT INTO bch_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Be Iesus ilongo bedaoa ta ikoli led posanga bedane, “Gid panua tinid kemi, led ipu eta ngan tila pan eaba keminga aea mao, be gid dibala tilagalaga pan. ");
INSERT INTO bch_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Be gimi ala abada oatainga ngan Deo ele posanga ga oaine: ‘Gau tinig ngan lemi tenainga sapaean mao. Be nakim lolomi isat ngan eaba ede pade.’ Ngansa gau nanam ngan babanga gid panua tututui mao, be nanam ngan babanga gid panua kadonga sasat ad.” ");
INSERT INTO bch_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Idio ta gid aluagau ton Ioanes Paliliunga aea tinam tibeta Iesus bedane, “Ikamado ga gaingada gid Parisi anasnasi kadonga ngan plesenga annga, be lem aluagau tiplese annga mao?” ");
INSERT INTO bch_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ta Iesus ikeo pagid, “Oangga eaba ede iuai taine, ta tikado eaneannga ngan led oainga, gid toman ngan oaeoaed tirangrang ngan lolod isat mao, ngansa eaba oainga imamado toman ngan gid. Be ado ede muriai, panua padengada ga tipaeaoa eaba toa oa ga ila aluai ngan gid. Ta ngan ado toaiua, gid ga tiplese annga. ");
INSERT INTO bch_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Be eaba eta irangrang ngan ibada malo pau ilia ta isaisai ngan aea malo mugamuga aea krak mao. Oangga ikado bedaoa, be imum ga kus ta ipaeanado, eine malo pau ilia ga itaka malo mugamuga ga paeamao. ");
INSERT INTO bch_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Be eaba eta irangrang ngan iparere oain pau ngan meme itin kukul mugamuga mao. Oangga ikado bedaoa, eine oain pau ga ikado meme itin kukul mugamuga ga pak. Ta oain ga itoki, be meme itin kukul ga iduaea pade. Be gita taparere oain pau ngan meme itin kukul papau, ta oain toman ngan meme itin kukul ga tidio kemi.” ");
INSERT INTO bch_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iesus iposaposa maitne pagid aluagau ton Ioanes, be mole mao madidnga ede inam ikor iae boloma pan ta ikeo, “Gau natug taine imate toa patautene. Be eao nam dol bagem ga idae ngan ei, ta ei ga idae mulian.” ");
INSERT INTO bch_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ta Iesus idae ta inasi ei ga ila toman ngan ele aluagau. ");
INSERT INTO bch_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Be mole mao, taine ede aea dibala sing palapala ilalala Iesus imuriai ta isibo ele pononga imata. Aea dibala toa oa ikakado ei irangrang ngan aea rai sangaul ga igegea rua, ");
INSERT INTO bch_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","be ikeo iloleai bedane, “Oangga nasibo ele pononga kekelen, eine ga naot kemi pade.” ");
INSERT INTO bch_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Be Iesus ipul ei ta igera taine toa oa ta ikeo, “Taine, pamatua lolom. Lem kadonga lolo matua aea ikado ga tinim iuot kemi.” Tota ngan ado imata toaiua ga ila, itin kemi mulian. ");
INSERT INTO bch_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Idio ta Iesus ila idudunga madidnga ele lumaeai ta tigera panua titangtang ga tiusouso piloli ga arerengad kapei. ");
INSERT INTO bch_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Be ikeo pagid, “Gimi adae ga ala. Taine kakauede imate mao. Ei ienono.” Be gid tinging ngan ei. ");
INSERT INTO bch_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Be ei isere gid ga tila gaot, ta idudunga ga ila pan taine kakauede ta ikisi ibage. Ta idae mulian. ");
INSERT INTO bch_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tota ato ngan Iesus ele kadonga toa oa iuasasa ga ipakaranga tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Idio ta Iesus itnan tuanga toa oa ta ilalala ga ila. Be panua rua matad ikila tinasi ei ta tibaba bedane, “Devit itub, uduan gairua.” ");
INSERT INTO bch_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Io, Iesus idudunga lumaeai, be gisirua tinasi ei ga tila pan. Ta ibeta gisirua bedane, “Gimirua lolomi matua ta aeadi mambe gau narangrang ngan nakado kemi matami na?” Ta gisirua tikeo, “Be, Maron.” ");
INSERT INTO bch_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tota idol ibage ga idae ngan gisirua matad ta ikeo, “Eine ga iuot ngan gimirua lalaede mambe lolomi matua ngan.” ");
INSERT INTO bch_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tota gisirua matad pal ta tigeragera pade. Be Iesus iposa matua pagisirua bedane, “Gimirua agabit kemi. Ngan kado ta eaba eta pade iuatai ngan.” ");
INSERT INTO bch_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Be mao. Gisirua tiuot ga tila tipaoasasa posanga ngan ei ta iualu ipakaranga tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Gisirua tiuot ga tila, be mole mao panua padengada tital eaba ede iriau paeamao ienono ngan ei ta ila pan Iesus. Iriau ikado ei ga iaoa gum. ");
INSERT INTO bch_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iesus isere iriau paeamao ta eaba toa oa iposaposa pade. Be gid ipom tigera ga timatala ta tikeo, “Mugaeai ga inam, danga eta bedane iuot Israel mao.” ");
INSERT INTO bch_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Be gid Parisi tikeo, “Ei iseresere gid iriau papaeamao ngan madidnga togid iriau papaeamao iura.” ");
INSERT INTO bch_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Idio ta Iesus ilalala ga ila ngan gid tuanga kapeipei ga gereirei toa ngada oa. Ta ipapaoatai gid panua led luma raring aea iloleai, ga ipaola ato kemi ngan madonga Deo ibageai, ga ikemikemi ad dibala imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Be igera gid ipom ta ilolo isat ngan gid, ngansa danga papaeamao iuotot ngan gid ta lolod ede ga ede ngan led madonga paeamao, be ad luanga eta mao. Gid mambe sipsip, be tamad eta imariala ngan gid mao. ");
INSERT INTO bch_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tota ikeo pagid ele aluagau bedane, “Annga busa tau imatua ga ienono dadangai, be gid panua tibokoboko ngan aea badanga, gid busa mao. ");
INSERT INTO bch_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tota manta araring matua ga ila pan dadanga Itama, ta isula panua busa naurata ad ga tila tibada gid annga imatua.” ");
INSERT INTO bch_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Idio ta Iesus ibaba ele aluagau sangaul igegea rua ga tinam pan. Ta ipamatua gid ngan serenga iriau papaeamao ga keminga panua ad dibala imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iesus ele panua ato ad sangaul igegea rua, edad ga bedane: eaba imuga ngan gid eine Saimon toa tiuato ei Petrus, ga itar kakau Andreas, ga Jems toa Sebedi inat, ga itar kakau Ioanes, ");
INSERT INTO bch_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ga Pilip, ga Bartolomeus, ga Tomas, ga Mateus toa mugaeai ibabada takis, ga Jems toa Alpius inat, ga Tadius, ");
INSERT INTO bch_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","ga Saimon Selot, ga Iudas Iskariot toa muriai idol Iesus ga idae aea miri itamatama bagedeai. ");
INSERT INTO bch_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iesus isula gid panua toa sangaul igegea rua oa ta irenren pagid bedane, “Gimi ala pagid alu padengada mao, ga ala ngan tuanga eta togid Samaria mao pade. ");
INSERT INTO bch_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Be gimi ala pagid Israel kekelegid. Gid titnan Deo ele edap ga tisusu mambe sipsip. ");
INSERT INTO bch_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gimi alalala ga ala ta apaola posanga ga bedane, ‘Madonga Deo ibageai tota iuot ne.’ ");
INSERT INTO bch_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Gimi ala akado kemi gid panua ad dibala, ga apei mulian gid panua timate, ga akado kemi gid panua ad dibala kankan ga tiuot kemi Deo imatai, ga asere gid iriau papaeamao. Pamatuanga toa ne nabada pagimi sapaean, tota ala abada sapaean pagid panua. Eine aea olnga mao. ");
INSERT INTO bch_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Gimi alalala be akikisi lemi pat gol ga silva mao, ga pat singsingia mao pade. ");
INSERT INTO bch_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Abada ami bisinga mao, ga lemi pononga ga su ruangada mao, ga toto lalalanga aea mao pade. Ngansa eine tutui ngan gid panua tipan annga ga ila pagimi panua naurata ami ton Deo. ");
INSERT INTO bch_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Oangga gimi ala ngan tuanga kapei, mao kakauede isaoa, ailo eaba kemi eta ta aeno ele lumaeai ga irangrang ngan atnan tuanga toa oa. ");
INSERT INTO bch_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ta oangga adudunga ngan luma ede, abada lemi ado kemi ga posanga lolo tarui aea ga ila pagid panua toa oa. ");
INSERT INTO bch_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ta oangga gid panua kemikemi, lemi posanga lolo tarui aea ga idio pagid. Be oangga gid panua kemikemi mao, tota abada mulian lemi posanga lolo tarui aea. ");
INSERT INTO bch_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Be oangga sapadua tibada gimi ga ala led lumaeai mao, ga tinid ngan longonga lemi posanga mao, tota atnan luma toa oa, mao tuanga toa oa, ta asile aemi aea kangkanga ga idio pagid. ");
INSERT INTO bch_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nakeo tautaunga pagimi, muriai oangga Deo ipamadid gid panua ngan posanga, gid ad panasnga ga iasal gid Sodom ga Gomora ad panasnga.” ");
INSERT INTO bch_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Iesus ikeo pade bedane, “Ega, gau nasula gimi ga ala mambe sipsip tilalala rabu ngan kaua saksak. Tota manta anasi oatainga kemi lalaede mambe gid mota, be lolomi aea danga eta mao mambe man barur. ");
INSERT INTO bch_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Be agabit kemi ngan panua papaeamao. Ngansa gid ga tidol gimi ga adae pagid madidnga patutuinga posanga ad bagedeai ta timuimui gimi led luma raring aea iloleai. ");
INSERT INTO bch_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ta gid ga tipamadid gimi pagid mamaron kapeipei ga gavana matad, ngansa gimi gau leg panua. Toa bedaoa ta gimi ga apalongo gid ngan leg ato kemi, ta gid kapeipei toa oa ga gid panua Iuda ad mao ga tilongo. ");
INSERT INTO bch_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Be oangga tidol gimi ga adae bagedeai, lolomi ede ga ede ngan saoa posanga aoangga akoli ga ila pagid mao. Ngansa ngan ado imata toaiua, Deo ga ibada posanga pagimi. ");
INSERT INTO bch_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ngansa eine gimi lemi posanga mao, be Tamami Itautau Tutui ga ikado posanga ga iuot aoamiai. ");
INSERT INTO bch_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Be eaba itar kapeipei ga aea kakakau ga tidol ei ga idae pagid madidnga bagedeai ta tirau ei ga imate. Be gergeu tamatamad ga tikado toa bedaoa pade ngan led gergeu. Ga gid gergeu ga timan tnatnad ga tamatamad ad isat ta tikeo pagid panua ta tirau gid ga timate. ");
INSERT INTO bch_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Be panua busa ga lolod paeamao ngan gimi, ngansa gimi gau leg panua. Be oangga sai imadid matua ga irangrang ngan ele madonga tanoeai kus, eine Deo ga ibada ei mulian. ");
INSERT INTO bch_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Be oangga tuanga ede tipaieiei gimi, tota aeaoa ga ala ngan tuanga eta pade. Ngansa nakeo tautaunga pagimi, gimi ga apasala lemi naurata ngan gid tuanga Israel maitne, be Eaba Inat ga iluai mulian ga inam. ");
INSERT INTO bch_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Aluagau eta iasal ele eaba paoatainga aea mao, ga paeaeanga eta iasal aea maron mao pade. ");
INSERT INTO bch_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Be oangga aluagau iuot mambe ele eaba paoatainga aea, eine ikaranga ngan ei. Ga oangga paeaeanga iuot mambe aea maron, eine ikaranga ngan ei pade. Tota oangga panua aoad ibiu luma itama ta tiuato ei Belsebul, eine ga tiposa paeamao ga paeamao tau ngan gid ele luma lolo.” ");
INSERT INTO bch_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Iesus ikeo pade bedane, “Tota gimi amataud gid panua mao. Ngansa saoa danga ienono mumulnga labone, eine muriai ga iuot masaeai. Be saoa danga timudan labone, muriai panua toa ngada ne ga tiuatai ngan. ");
INSERT INTO bch_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Saoa posanga nakeo pagimi ngan tibur dodom, gimi manta apalongo ga iuot merengai. Ga saoa posanga nakamur ngan ga alongo tangamiai, manta amadid luma ipaoeai ta apaola ga iuot pagid ipom. ");
INSERT INTO bch_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ga pade, gid panua toa tiuangga tipamate gimi, irangrang ngan amataud gid mao. Ngansa gid tipamate tinimi, be irangrang ngan tipamate tautaudimi mao. Be gimi amataud Deo. Ngansa ei irangrang ngan ipamate tinimi, be ipaeabu ngan tautaudimi pade ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Gimi aoatai, man gereirei eine panua tiuol rua ngan pat singsingia kelede, be eta ngan gid irangrang ngan itap ga imate sapaean mao. Tamami imata nanan gid toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Be ei iuade launimi idil toa ngada ne laboramiai, ta irangrang ngan imata sapian gimi mao pade. ");
INSERT INTO bch_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tota amataud mao. Ngan Deo imata, gimi kapei tau ngan man gereirei busa.” ");
INSERT INTO bch_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Iesus ikeo pade bedane, “Tota oangga sai iuaoa pagid panua ngan ei gau leg eaba ede, eine gau pade ga naoaoa pan Tamag buburiai ngan ei gau leg eaba. ");
INSERT INTO bch_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Be oangga sai ikeo pagid panua ngan ei gau leg eaba mao, eine gau pade ga nakeo pan Tamag buburiai ngan eaba toa oa gau leg eaba mao.” ");
INSERT INTO bch_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Iesus ikeo pade bedane, “Kado gimi aoangga gau nanam ngan kadonga gid panua tanoeai ga lolod itarui. Eine mao. Be gau nanam ngan talnga didi paraunga aea ga inam! ");
INSERT INTO bch_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ngansa ngan gau leg namanga, gid panua ga timan ariapolpol ngan gid. “‘Eaba ga iman itama aea isat, ga taine ga iman itna aea isat, ga taine oainga ga iman ilaoa taine aea isat. ");
INSERT INTO bch_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tota eaba isobosobo ga timan aea miri itamatama.’ ");
INSERT INTO bch_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Eaba sai ikim itama ga itna kapei, be ikim gau kapei tau mao, eine irangrang ngan iman leg eaba mao. Toa bedaoa pade ngan inat ga inat taine, oangga ikim gid kapei, be ikim gau kapei tau mao, eine irangrang ngan iman leg eaba mao. ");
INSERT INTO bch_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Be oangga sai ibisi aea abei tabala ga inasi gau mao, eine irangrang ngan iman leg eaba mao. ");
INSERT INTO bch_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Oangga sai ikim tau ele madonga tanoeai, ei ga imate ta ele madonga ga iduaea. Be oangga sai imate ngan nasinga gau, ei ga ibada madonga kemi tautaunga.” ");
INSERT INTO bch_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Iesus ikeo pade bedane, “Oangga sai itin igelgel ngan badanga gimi, eine ibada gau pade. Be oangga sai ibada gau, eine ibada gau kekelegau mao, be ibada eaba toa isula gau pade. ");
INSERT INTO bch_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Oangga sai itin igelgel ngan badanga eaba ede ibada Deo iaoa, ngansa Deo isula ei, Deo ga ilasu eaba toa oa lalaede mambe ilasu gid panua tibabada iaoa. Be oangga sai itin igelgel ngan badanga gid panua tututui, ngansa Deo isula gid, eine Deo ga ilasu eaba toa oa lalaede mambe ilasu gid panua tututui. ");
INSERT INTO bch_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Be oangga sai ikeo ga ilua gid aluagau togau ta ibada eau memednga ga ila pan aluagau eta togau toa ieda mao, nakeo tautaunga pagimi, irangrang ngan eaba toa oa isapir ngan badanga aea lasunga mao.” ");
INSERT INTO bch_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iesus ipasala ele renrennga pagid ele aluagau sangaul igegea rua, ga kus ta itnan tibur toa oa, ta ila ngan gid Galili led tuanga ga tuanga ta ipapaoatai gid ga ipapaola Deo ele posanga ga ila pagid. ");
INSERT INTO bch_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Be Ioanes Paliliunga aea imado ngan luma panasnga aea ta ilongo ngan Kristus ele bokonga. Tota isula ele aluagau ta tila pan ");
INSERT INTO bch_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta tikeo, “Eao eaba toa Deo iposa tautaunga ngan isula go ga nam, mao gai asanga eaba eta pade?” ");
INSERT INTO bch_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ta Iesus ikoli led posanga bedane, “Aluagimi ta apalongo Ioanes ngan saoa danga alongolongo ga ageragera. ");
INSERT INTO bch_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Gid panua matad sususu tigeragera pade. Gid panua aed imate tilalala pade. Gid panua ad dibala kankan tiuot kemi Deo imatai. Gid panua tangad kua tilongolongo pade. Gid matemate tidae mulian. Ga gid panua lululunga ad tilongolongo ato kemi. ");
INSERT INTO bch_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Be kemi tau ngan eaba sai toa ilolo matua ngan gau, be ele kadonga lolo matua aea itap mao!” ");
INSERT INTO bch_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gid aluagau ton Ioanes tiluagid ga tila ga kus ta Iesus iposa pagid ipom ngan Ioanes. Ta ikeo, “Mugaeai gimi ala ngan tibur modamodanga ngan geranga saoa? Aoangga agera eaba ilolo iburlogologoi alele mambe piso ede rai ipabeu na? Eine mao. ");
INSERT INTO bch_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Be gimi ala ngan geranga saoa danga? Aoangga agera eaba idol danga sisid kemikemi? Eine mao. Ega, gid panua tidol danga sisid kemikemi timamado ngan luma togid mamaron kapeipei. ");
INSERT INTO bch_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Be ikamado ga gimi ala? Ala ngan geranga eaba ibada Deo iaoa? Be! Ei tota nena. Be nakeo pagimi, Ioanes iasal gid panua padengada tibabada Deo iaoa mugaeai. ");
INSERT INTO bch_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Deo ele laulau iposa ngan ei bedane, “‘Ega, gau ga nasula leg eaba ato aea ta ila imuga ngan eao. Ta ei ga ipatutui danga toa ngada ne ngan lem namanga.’ ");
INSERT INTO bch_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nakeo tautaunga pagimi, mugaeai ga irangrang ngan labone, eaba eta tanoeai iasal Ioanes Paliliunga aea mao. Be labone gid panua timamado Deo ibageai, gid edad kapeipei ga gid edad mao toa ngada ne tiasal Ioanes. ");
INSERT INTO bch_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Be ngan ado toaiua Ioanes Paliliunga aea ipaola posanga ga irangrang ngan labone, gid panua tiparpar tau ga tipaparau ngan badanga madonga Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ngansa gid panua tibada Deo iaoa ga gid panua tibode Deo ele apu, gid tikakado led posanga ga irangrang ngan Ioanes iuot. ");
INSERT INTO bch_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Be oangga gimi akim, kemi ngan aeadi Ioanes, ei Elaija toa Deo iposa tautaunga ngan mugaeai, ngan sulanga ei ga inam. ");
INSERT INTO bch_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Eaba sai itanga, manta ilongo kemi posanga toaine. ");
INSERT INTO bch_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Be gau ga natado oanenga itna isaoa idodo kemi gid panua labone ad? Gid mambe gergeu timamado ngan tibur oalo aea ta tibaba ga ila pagid areread ga bedane, ");
INSERT INTO bch_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“‘Gai auso piloli ngan gimi, be ikamado ga atoltol mao? Gai akado keoainga, be ikamado ga atangtang mao?’ ");
INSERT INTO bch_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ngansa Ioanes inam ta iunun oain mao ga iplese annga, be gid panua tikeo ga iriau paeamao ienono ngan ei. ");
INSERT INTO bch_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Be Eaba Inat inam ta ianean ga iunun, be gid tikeo, ‘Ega, eaba ne ele eaneannga ga ununnga sat tau. Ei iarerea gid panua takis ad ga panua kadonga sasat ad.’ Gid tiselele toa bedaoa, be kadonga togid panua tikado Deo ele naurata tautaunga, eine ipasolan mambe Deo ele oatainga itutui.” ");
INSERT INTO bch_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Idio ta Iesus iselele gid tuanga toa tigera ele uisinga pabusa, ngansa tipul lolod mao. ");
INSERT INTO bch_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ta ikeo bedane, “Paeamao tau ngan gimi panua ngan tuanga Korasin ga Betsaida! Ngansa oangga gid panua ngan tuanga Tair ga Saidon tigera gid uisinga mambe gimi agera nakakado, eine ga tidol danga sisid mok aea toa mugaeai oa ga tisama matad ngan asaso ta iman kilala ngan tipul lolod. ");
INSERT INTO bch_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Be nakeo pagimi, muriai oangga Deo ipamadid gid panua ngan posanga, gimi ami panasnga ga iasal gid Tair ga Saidon ad panasnga. ");
INSERT INTO bch_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Be gimi panua Kapernaum aoangga Deo ga isoa gimi ga adae buburiai na? Mao tau! Gimi ga asulug gadio, ta ala ngan tibur paeamao togid matemate. Ngansa oangga gid panua Sodom tigera gid uisinga mambe gimi Kapernaum agera nakakado, eine ga Sodom ienono ga irangrang ngan labone. ");
INSERT INTO bch_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Be nakeo pagimi, muriai oangga Deo ipamadid gid panua ngan posanga, gimi ami panasnga ga iasal gid Sodom ad panasnga.” ");
INSERT INTO bch_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ngan ado toaiua, Iesus iraring ga bedane, “Apa, eao Maron ngan bubur ga tano. Gau nasoa edam, ngansa eao mudan lem posanga ipu pagid panua oatainga ad. Be gid panua toa edad mao, eao pasolan lem posanga ipu pagid. ");
INSERT INTO bch_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Be tautaunga Apa, eao nasi lem kimnga ta kado toa bedane. ");
INSERT INTO bch_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Gau Tamag idol danga toa ngada ne ga idae bagegeai. Be eaba eta iuatai ngan Deo Inat mao. Tamag kekelen iuatai. Be eaba eta pade iuatai ngan Tamag mao. Inat kekelen iuatai, toman ngan gid panua toa Inat ikim ipasolan ei pagid. ");
INSERT INTO bch_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Gimi panua toa akakado naurata oanaoana ga danga kulupulupu ipaieiei gimi, gimi toa ngada ne anam pagau, ta gau ga naearan gimi kemi. ");
INSERT INTO bch_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Gimi abada oatainga pagau ga aboko gadio ngan gau, mambe bulmakao iboko gadio ngan itama ta idada ele danga sisid. Ngansa gau nakado kadonga marum ngan gid panua, ga nasoa edag mulian mao. Ta gimi ga aearagimi kemi ga lolomi ede ga ede mao. ");
INSERT INTO bch_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngansa gau leg posanga ikulupu ngan aea nasinga mao, be leg naurata malamalan.” ");
INSERT INTO bch_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ngan taun toaiua, ngan Ado Earainga aea, Iesus asingada ele aluagau tilalala rabu ngan dadanga wit. Ele aluagau pitoreagid ta tipasu gid wit itautau idanga ede ta tian. ");
INSERT INTO bch_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Be gid Parisi tigera ta tikeo pan bedane, “Ega, kadonga toa lem aluagau tikakado eine tutui ngan Ado Earainga aea mao.” ");
INSERT INTO bch_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ta ikoli led posanga bedane, “Kado gimi aoato laulau ngan Devit ele kadonga toa mugaeai oa mao. Ngan ado toaiua, Devit asingada iuaeoae pitoreagid, ");
INSERT INTO bch_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ta idudunga Deo ele palatai ta ibada bret tenainga aea toa ienono Deo imatai ta ian. Be bret toa oa itutui ngan gid panua tenainga ad kekelegid tianean. ");
INSERT INTO bch_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","“Be kado gimi aoato posanga ede pade ga oaine ngan laulau apu aea mao. Ikeo ngan Deo ele luma, oangga gid panua tenainga ad tikakado naurata tenainga aea toa eoa ngan Ado Earainga aea, gid led idil eta paeamao mao. Tautaunga tinasi apu ngan Ado Earainga aea toa eoa mao, be gid led idil eta paeamao mao. ");
INSERT INTO bch_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Be gau nakeo pagimi, eaba ede rabu ngan gimi, ei ieda kapei iasal luma ton Deo. ");
INSERT INTO bch_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Be posanga ede pade ngan Deo ele laulau ikeo bedane, ‘Gau tinig ngan lemi tenainga sapaean mao, be nakim lolomi isat ngan eaba ede pade.’ Oangga gimi aoatai kemi ngan posanga toa oa, irangrang ngan aselele gid panua tututui mao. ");
INSERT INTO bch_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngansa Eaba Inat ei Maron ngan Ado Earainga aea.” ");
INSERT INTO bch_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iesus itnan tibur toa oa ta ila idudunga ngan led luma ede raring aea. ");
INSERT INTO bch_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Be toa eoa eaba ede imamado, ibage ede imate. Ta gid panua tiuangga tigera idil eta paeamao pan Iesus ta tibeta ei bedane, “Eine tutui ngan takado kemi gid dibala ngan Ado Earainga aea pade, mao madongan?” ");
INSERT INTO bch_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Be ei ikeo pagid bedane, “Oangga eaba eta ngan gimi ele sipsip itap ga isulug babaeai ngan Ado Earainga aea, ei ga ikado mado? Ei ga idada ga idae mulian na? ");
INSERT INTO bch_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Be gita eababa taeasal sipsip tau. Tota eine tutui ngan tanasi kadonga kemi ngan Ado Earainga aea.” ");
INSERT INTO bch_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Io, Iesus ikeo pan eaba toa ibage imate oa bedane, “Patutui bagem.” Tota ipatutui ibage, ta ibage iuot kemi mulian mambe ibage ede pade. ");
INSERT INTO bch_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Be gid Parisi tiuot ga tila ta tiraurau aea posanga ngan pamatenga ei. ");
INSERT INTO bch_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Be Iesus iuatai ngan danga toa gid Parisi tiuangga tikado ngan ei, tota itnan tibur toa oa ga ila. Be ipom kapei tau tinasi ei ta ikado kemi ad dibala toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Be irenren matua pagid ngan tiuaoa ngan ei pagid panua padengada mao. ");
INSERT INTO bch_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ngan kadonga toa oa, ei iparangrang Deo ele posanga ede. Aisaia ibada Deo iaoa mugaeai ta ibode ga bedane, ");
INSERT INTO bch_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ega, eaba toa ne ei gau leg paeaeanga. Gau nasio ei. Gau nakim ei tau ga lolog kemi ngan ei. Gau ga nadol Tautaudig Tutui ga ienono pan, ta ei ga ipaola posanga pagid alu toa ngada ne tanoeai ngan leg edap ngan patutuinga gid. ");
INSERT INTO bch_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ei ga iaoa parau pagid panua mao ga ngar ga ngar mao. Be gid panua ga tirangrang ngan tilongo ele posanga iuot kapei melemeleai mao pade. ");
INSERT INTO bch_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Piso ikolakolanga ta iuangga imakor, ei ga ikor mao. Be lam aea dinga imata igigimonga, ei ga ipamate mao. Ei ga ibokoboko toa bedaoa ga irangrang ngan ikado ga leg kadonga tutui iparangrang tibur toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ta gid alu toa ngada ne tanoeai ga tigaga matad ngan ei ngan badanga gid mulian.” ");
INSERT INTO bch_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Idio ta tital eaba ede iriau paeamao ienono ngan ei, ta ila pan Iesus. Eaba toa oa imata ikila ga iaoa gum. Ta Iesus ikado kemi ei, ta iposaposa ga igeragera pade. ");
INSERT INTO bch_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Gid ipom tigera toa bedaoa ta timatala kapei ta tikeo, “Kado eaba toa ne Devit itub?” ");
INSERT INTO bch_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Be gid Parisi tilongo bedaoa ta tikeo, “Eaba toa ne iseresere gid iriau papaeamao sapaean mao. Be Belsebul, madidnga togid iriau papaeamao, ipamatua ei ta ikakado toa bedaoa.” ");
INSERT INTO bch_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Be Iesus iuatai ngan gid lolod ta ikeo pagid, “Oangga maron kapei ede ele panua timapoga ta tiparau pol ngan gid, eine ga timukuru. Ga toa bedaoa pade ngan tuanga ede, mao luma ede, oangga timapoga ta tiparau pol ngan gid, eine irangrang ngan timadid matua mao. ");
INSERT INTO bch_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tota oangga Satan isere Satan, eine ele panua timapoga ta tiparau pol ngan gid. Toa bedaoa ga Satan imadid ga imugamuga ngan ele tibur kapei madongan? ");
INSERT INTO bch_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Be oangga asol gau ngan serenga iriau papaeamao ngan Belsebul iura, gimi akeo mado ngan lemi panua toa tiseresere gid iriau papaeamao pade? Gimi aoangga Satan ilualua gid? Tota naurata togid lemi panua ga ipasolan mambe lemi selelenga itutui mao. ");
INSERT INTO bch_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Be oangga Deo Itautau Tutui ipamatua gau ngan serenga iriau papaeamao, kadonga toa ne ipasolan gimi mambe madonga Deo ibageai iuot rabu ngan gimi na. ");
INSERT INTO bch_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Eaba eta irangrang ngan idudunga sapaean ngan luma ton eaba iura kapei, ngan lubnga ele danga sisid mao. Be oangga ikaukau eaba toa iura kapei oa ngan kenga ga kus, tota ei ga irangrang ngan ilub ele danga toa ngada oa lumaeai. ");
INSERT INTO bch_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Oangga sai iboko toman ngan gau mao, ei gau ag isat. Ga oangga sai ilua gau ngan badanga gid panua ga tinam boloma pan Deo mao, eine eaba toa oa iseresere gid ga tila aluai ngan Deo. ");
INSERT INTO bch_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ngan ipu toaine nakeo pagimi, Deo ga isamum gid panua led kadonga sasat ga posanga papaeamao imata ede ga ede, be eaba sai ipaeabu ngan Itautau Tutui ieda, Deo ga isamum ele kadonga sat mao. ");
INSERT INTO bch_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ga oangga sai iposa paeamao ngan Eaba Inat, eine irangrang ngan Deo isamum ele kadonga sat. Be eaba sai iposa paeamao ngan Itautau Tutui, eine Deo ga isamum ele kadonga sat mao. Labone ga muriai pade, ele kadonga sat aea samumnga mao.” ");
INSERT INTO bch_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Iesus ikeo pade bedane, “Oangga akeo ga abei ede eine kemi, manta akado posanga lalaede toa bedaoa ngan itautau kemikemi. Oangga akeo ga abei ede eine paeamao, akado posanga lalaede toa bedaoa ngan itautau papaeamao. Ngansa gita taoatai ngan abei kemi ga abei paeamao ngan geranga itautau. ");
INSERT INTO bch_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Gimi mota ele gergeu! Gimi panua papaeamao, tota akakado posanga kemikemi madongan? Ngansa saoa posanga iuon eaba iloleai, eine iaoa ga iposa ngan ga iuot. ");
INSERT INTO bch_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Oangga eaba kemi, eine posanga kemikemi ienono iloleai, ta inasi posanga kemikemi toa oa. Be oangga eaba paeamao, eine posanga papaeamao ienono iloleai, ta inasi posanga papaeamao toa oa. ");
INSERT INTO bch_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Be gau nakeo pagimi, muriai oangga Deo ipamadid gid panua ngan posanga, eine ga imata nanan lemi posanga idil toa ngada oa akakado alele toa mugaeai ga inam, ta gimi ga akoli posanga ga ila pan ngan. ");
INSERT INTO bch_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Deo ga imata inasi eao lem posanga ta iuato eao eaba tutui. Oangga mao, ei ga imata inasi eao lem posanga ta ipanas go.” ");
INSERT INTO bch_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Idio ta gid madidnga apu ad ga gid Parisi edengada tikeo pan Iesus bedane, “Eaba paoatainga am, gai akim agera eao kado uisinga eta iman kilala.” ");
INSERT INTO bch_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Be ei ikoli led posanga bedane, “Gid panua papaeamao labone ad lolod itnan Deo somisomi tau. Gid tikim tigera uisinga iman kilala. Be irangrang ngan tigera mao. Kilala kelede mon ga tigera, eine ngan Iona toa ibada Deo iaoa mugaeai. ");
INSERT INTO bch_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ngan ado toaiua, ei ieno ado tol ga bong tol ia kapei iloleai. Ta lalaede toa bedaoa, Eaba Inat ga ieno tano iloleai aea ado tol ga bong tol. ");
INSERT INTO bch_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Be muriai oangga Deo ipamadid gid panua ngan posanga, eine gid panua Ninive ga timadid ta tisol gid panua labone ad ngan posanga. Ngansa gid Ninive tilongo Iona ele posanga pabibnga aea ta tipul lolod. Be ega, labone eaba ede rabu ngan gimi iasal Iona, be gimi apul lolomi mao. ");
INSERT INTO bch_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Be oangga Deo ipamadid gid panua ngan posanga ngan ado toaiua, taine nagerara ngan tibur saut ga idae mulian toman ngan gid panua labone ad ta isol gid ngan posanga. Ngansa ele tuanga ienono tano idigedigeai, be ei ilalala aluai ga inam ngan longonga Solomon ele paoatainga. Be ega, labone eaba ede rabu ngan gimi iasal Solomon.” ");
INSERT INTO bch_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Iesus ikeo pade bedane, “Oangga iriau paeamao itnan eaba ede, eine ga ilalala alele ngan tibur mamasa, ta iloilo tibur eta kemi earainga aea. Be iuot ngan mao ");
INSERT INTO bch_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ta ikeo, ‘Gau ga naluagau mulian ngan luma toa natnan oa.’ Ta oangga ila iuot toa eoa, ei ga igera luma toa oa ienono sapaean, be tisile ga tipatutui mulian. ");
INSERT INTO bch_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ga kus ta ila ibada gid iriau papaeamao lima ga rua toa tiasal ei ngan kadonga sasat. Ta gisingada tidudunga ta timulmuli toa eoa. Tota labone eaba toa oa ele madonga paeamao tau ga iasal ele madonga toa mugaeai aea. Gid panua papaeamao labone ad, eine ga tiuot toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iesus iposaposa pagid ipom maitne, be mole mao itna ga itar kakakau timadmadid gaot ngan luma toa oa ta tiuangga tiposa toman ngan ei. ");
INSERT INTO bch_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ta eaba ede ikeo pan, “Ega, tnam ga am kakakau timadmadid gaot, be tiuangga tiposa toman ngan eao.” ");
INSERT INTO bch_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Be Iesus ikoli eaba toa oa ele posanga bedane, “Sai gau tnag, ga sapadua ag kakakau?” ");
INSERT INTO bch_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ta igaga ibage ga idae ta idodo gid ele aluagau ta ikeo, “Ega, gau tnag ga ag kakakau tota eko. ");
INSERT INTO bch_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ngansa oangga sapadua tinasi Tamag toa buburiai oa ele kimnga, gid gau ag kakakau ga liuliug ga tnatnag.” ");
INSERT INTO bch_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ngan ado toaiua, Iesus itnan luma ta iuot ga ila gaot. Ta idio imado liu kapei isaleai. ");
INSERT INTO bch_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Be gid ipom kapei tinam tiluplup pan. Tota idug ga idae ngan oaga ede ta idio imado ngan, be gid ipom timadmadid labiai. ");
INSERT INTO bch_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ta itado oanenga itna busa pagid ta ikeo, “Ega, dadanga itama ila isiran wit ipuapua. ");
INSERT INTO bch_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ei isisiran ga ila, be wit ipuapua idanga ede itaptap ga idio edap isaleai. Be gid man tinam ta tian ga kus. ");
INSERT INTO bch_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Be wit ipuapua idanga ede itaptap ga idio ngan tano aea patpat kapeipei. Be tano kapei tau mao, tota wit ipara ga idae manmanae ngansa isulug tau mao. ");
INSERT INTO bch_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ado ipara ga idae ta ilaba wit. Be wit iuaroar tos ngan pat, tota imalai ga imisi. ");
INSERT INTO bch_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Be wit ipuapua idanga ede itaptap ga idio ngan oaroaro aea gigi. Be oaroaro idae kapei ta imol wit ga paeamao. ");
INSERT INTO bch_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Be wit ipuapua idanga ede itaptap ga idio ngan tano kemi, ta itautau iuot busa. Idanga ede itautau iuot buno, idanga ede itautau iuot sangalima sangaul ede, idanga ede itautau iuot sangaul tol. ");
INSERT INTO bch_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Eaba sai itanga, manta ilongo kemi posanga toaine.” ");
INSERT INTO bch_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Idio ta Iesus ele aluagau tinam pan ta tibeta ei bedane, “Ikamado ga eao tatado oanenga itna pagid ipom somisomi?” ");
INSERT INTO bch_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ta ikoli led posanga bedane, “Ngansa Deo ilongean gimi ta aoatai kemi ngan ele posanga ipu mumulnga ngan madonga ibageai. Be ibada oatainga toa ne ga ila pagid ipom mao. ");
INSERT INTO bch_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Oangga sai ele oatainga, Deo ga igaltatan ele oatainga ga ila kapei. Be oangga sai ele oatainga mao, saoa danga ei iuatai ngan kautede, eine Deo ga ikado ga imata sapian. ");
INSERT INTO bch_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Natado oanenga itna pagid ngan ipu ga oaine: “Matad igeragera, be tiuatai ngan saoa danga toa tigera oa mao. Ga tangad ibabada, be tiuatai ngan saoa danga toa tilongo oa mao, ga tibada oatainga ngan mao pade. ");
INSERT INTO bch_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ngan kadonga toaine tiparangrang Deo ele posanga ede. Aisaia ibada Deo iaoa mugaeai ta ibode bedane, “‘Gimi ga alongo posanga somisomi, be eine ga aoatai ngan ipu mao. Be gimi ageragera pabusa, be irangrang ngan laborami ibada mao. ");
INSERT INTO bch_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngansa gid panua toa ne lolod buobuo, be tangad itola ngan longonga posanga. Be matad isi pade. Ngan kado ta tigera ngan matad, ga tangad ilongo ta laborad ibada kemi posanga ipu. Toa bedaoa ta tipul lolod, ta nakado gid ga tiuot kemi. Be eine mao.’ ");
INSERT INTO bch_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Be kemi tau ngan gimi! Ngansa gimi matami pal ta ageragera Deo ele posanga ipu, ga tangami ilongolongo ga abada oatainga. ");
INSERT INTO bch_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nakeo tautaunga pagimi, mugaeai ga inam, panua busa tibada Deo iaoa ga gid panua tututui busa lolod iminmin ngan geranga gid danga toa labone gimi agera, be gid tigera mao. Be lolod iminmin ngan longonga posanga toa gimi labone alongo, be gid tilongo mao.” ");
INSERT INTO bch_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Iesus ikeo pade bedane, “Tota alongo oanenga itna ipu ngan wit ipuapua ta abada oatainga ngan. ");
INSERT INTO bch_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Oangga panua tilongo ato kemi ngan madonga Deo ibageai, be tiuatai ngan ipu mao, Deo ele posanga ila pagid mambe wit ipuapua itaptap edap isaleai. Be eaba paeamao inam ta ipaeaoa posanga toa lolodeai oa. ");
INSERT INTO bch_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Be Deo ele posanga ila pagid panua padengada mambe wit ipuapua itaptap ngan tano aea patpat. Gid tilongo Deo ele posanga ga tibada manmanae ta tinid igelgel ngan. ");
INSERT INTO bch_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Be posanga toa oa isulug lolodeai mao, mambe wit iuaroar isulug gadio tanoeai mao. Gid tidio mole tau mao, ta oangga kadonga kulupulupu iuot, ga panua tipaieiei sapadua tinasi Deo ele posanga, eine led kadonga lolo matua aea itap manmanae tau. ");
INSERT INTO bch_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Be Deo ele posanga ila pagid panua padengada mambe wit ipuapua itaptap ngan oaroaro aea gigi. Gid tilongo Deo ele posanga, be gid danga tanoeai aea ikakado ga lolod ede ga ede, be tikim tau pat ta ipabuobuo laborad. Tota gid danga toa oa iuot mambe oaroaro aea gigi toa imol Deo ele posanga lolodeai, ta irangrang ngan itautau iuot mao. ");
INSERT INTO bch_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Be Deo ele posanga ila pagid panua padengada mambe wit ipuapua itaptap ngan tano kemi. Gid tilongo Deo ele posanga ta tiuatai kemi ngan ipu. Tota gid mambe tano kemi toa wit itautau iuot busa ngan. Idanga ede itautau iuot buno, padengada itautau iuot sangalima sangaul ede, padengada itautau iuot sangaul tol.” ");
INSERT INTO bch_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iesus itado oanenga itna ede pade pagid ta ikeo, “Madonga Deo ibageai eine mambe eaba isiran wit ipuapua kemikemi aea dadangai. ");
INSERT INTO bch_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Bong ede ele panua tienono, be aea isat ede inam ta isiran purup papaeamao wit iloleai. Ga kus ta ila. ");
INSERT INTO bch_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Idio ga muriai, wit ipara ga idae ta iuangga itautau, be tigera purup papaeamao pade ipara toman ngan wit. ");
INSERT INTO bch_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ta gid paeaeanga ton dadanga itama tila pan ta tikeo, ‘Maron, mugaeai eao siran wit kemikemi am dadangai, be ikamado ga purup papaeamao iparapara toman ngan?’ ");
INSERT INTO bch_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ta ikeo pagid, ‘Gau ag isat ede ikado toa bedane.’ “Ta gid paeaeanga tikeo pan, ‘Oangga eao kim, ta gai ala akule gid purup papaeamao ta asuk gid.’ ");
INSERT INTO bch_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Be ikeo, ‘Mao. Ngan kado ta akule wit toman ngan purup papaeamao. ");
INSERT INTO bch_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Atnan gisirua ga tidio ga irangrang ngan wit itautau imatua. Ta oangga wit imatua, eine ga nakeo pagimi paeaeanga ta ala asuk gid purup papaeamao mugaeai, ta akaukau gid ngan tulua ga tulua ta iman dinga aea. Be asuk gid wit itautau ta adol ngan leg luma annga aea.’” ");
INSERT INTO bch_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Idio ta Iesus itado oanenga itna ede pade pagid ta ikeo, “Madonga Deo ibageai eine mambe mastet ipuapua eaba ede ibada ta iarum aea dadangai. ");
INSERT INTO bch_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tautaunga, mastet ipuapua eine kakauede tau ngan gid annga padengada ipuapua. Be oangga ipara ga idae, eine idae ga ila kapei ta iasal gid annga padengada dadangai. Ta iuot mambe abei, ta gid man tirangrang ngan tinam ta tirau ad luma ngan ibogaboga.” ");
INSERT INTO bch_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Idio ta Iesus itado oanenga itna ede pade pagid ipom bedane, “Madonga Deo ibageai eine mambe yis toa taine ede ibada, ta ibul toman plaoa iuon ngan tabla kapeipei tol. Ga kus ta plaoa toa ngada oa isum ga idae kapei.” ");
INSERT INTO bch_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Gid posanga toa ngada oa Iesus itado pagid ipom, eine itado ngan gid oanenga itna mon. Ei iposa masaeai ngan danga eta mao. ");
INSERT INTO bch_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ngan kadonga toa oa, ei iparangrang Deo ele posanga mambe eaba ibada Deo iaoa mugaeai ikeo ngan ga bedane, “Gau ga natado gid oanenga itna pagimi ta napalongo ngan gid danga toa ienono mumulnga. Ngan danga toa ngada ne led otnga mugaeai ga irangrang ngan labone, gid posanga toa oa ienono mumulnga.” ");
INSERT INTO bch_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iesus itnan gid ipom ga tidio ta ila idudunga lumaeai. Be ele aluagau tila pan ta tikeo, “Irangrang ngan eao paola oanenga itna ipu pagai ngan purup papaeamao dadangai?” ");
INSERT INTO bch_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ta ikoli led posanga bedane, “Eaba isiran wit ipuapua kemikemi eine Eaba Inat. ");
INSERT INTO bch_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Be dadanga eine tibur toa ngada ne tanoeai. Be wit ipuapua kemikemi eine gid panua timamado Deo ibageai. Be purup papaeamao eine gid panua timamado eaba paeamao ibageai. ");
INSERT INTO bch_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Be dadanga itama aea isat eine eaba paeamao. Be ado badanga annga aea, eine ado muriai toa madonga tanoeai kus. Be panua naurata ad eine gid anggelo. ");
INSERT INTO bch_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Be ngan ado muriai toa madonga tanoeai kus, kadonga ga iuot lalaede mambe gid panua tikulekule gid purup papaeamao ta titado ga tidae dingaeai. ");
INSERT INTO bch_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Eaba Inat ga isula ele anggelo ta tibada danga toa ngada oa idadada gid panua ngan kadonga sasat ga gid panua toa ngada oa tipul murid ngan Deo ele apu, ta tila aluai ngan gid panua timamado Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eine ga titado gid ga tidae dingaeai. Toa eoa ga titangtang paeamao ga luod kek ga kek. ");
INSERT INTO bch_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ngan ado toaiua, gid panua tututui ga tiuot masaeai mambe ga ado imata ele taranga. Ta gid ga timamado Tamad Deo ibageai. Eaba sai itanga, manta ilongo kemi posanga toaine.” ");
INSERT INTO bch_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iesus ikeo pade bedane, “Madonga Deo ibageai eine mambe apou ede ienono mumulnga tano iloleai. Eaba ede iuot ngan apou toa oa ta imudan pade. Itin igelgel kapei ta ila ilongean ele danga sisid toa ngada oa pagid panua ta tiuolol gid. Ga kus ta ibada ele pat ta ila iuol tano toa oa ga iman ei aea.” ");
INSERT INTO bch_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Iesus ikeo pade bedane, “Ga pade, madonga Deo ibageai eine mambe eaba ede toa ele naurata ngan badanga gid nagemgem kemikemi ta gid panua tiuolol pan. ");
INSERT INTO bch_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ado ede iuot ngan nagemgem ede kemi tau aea olnga kapei. Tota ila ilongean ele danga sisid toa ngada oa pagid panua ta tiuolol gid. Ga kus ta ibada ele pat ta ila iuol nagemgem toa oa ga iman ele.” ");
INSERT INTO bch_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Iesus ikeo pade bedane, “Ga pade, madonga Deo ibageai eine mambe puo ede titado ngan liu kapei. Titado puo toa oa ta tibabada ia busa imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Idio ta puo iuon, ta gid panua tidada ga idae labiai. Tota tidio timado ta tilelean gid ia. Ia kemikemi tidoldol ga tidae ngan karei, be ia papaeamao titado ga iduaea. ");
INSERT INTO bch_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Eine ga iuot toa bedaoa pade ngan ado muriai toa madonga tanoeai kus. Gid anggelo ga tila ta tilelean panua papaeamao timamado rabu ngan panua tututui. ");
INSERT INTO bch_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Eine ga titado gid ga tidae dingaeai. Toa eoa ga titangtang paeamao ga luod kek ga kek.” ");
INSERT INTO bch_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ta Iesus ibeta ele aluagau bedane, “Gimi aoatai ngan posanga toa ngada ne ipu pade?” Ta tikeo, “Be.” ");
INSERT INTO bch_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ta ikeo pagid, “Tota gid aluagau toa ngada ne togau, gid mambe panua oatainga ad ngan Deo ele apu. Be gid tibada paoatainga ngan madonga Deo ibageai pade. Tota gid mambe luma itama ede toa ibada danga sisid kemikemi ele apouiai ga iuot. Danga sisid edengada mugamuga ga padengada papau.” ");
INSERT INTO bch_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Idio ta Iesus ipasala ele posanga ngan gid oanenga itna toa ne ga kus ta itnan tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Ta iluai mulian aea tuanga ipuiai Nasaret ta ipaoatai gid panua luma raring aea iloleai. Be gid tikakrik ta tikeo, “Eaba toa ne ibada ele oatainga sida? Iura madongan ta ikakado gid uisinga? ");
INSERT INTO bch_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Be eaba toa ne itama ikakado gid luma na? Itna ieda Maria ga itar kakakau Jems ga Iosep ga Saimon ga Iudas na? ");
INSERT INTO bch_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Iliuliu pade timamado toman ngan gita na? Tota eaba ne ibada iura ga ele oatainga sida?” ");
INSERT INTO bch_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Gid panua lolod paeamao ngan ei ta tiposa toa bedaoa. Be Iesus ikeo pagid, “Oangga eaba ibada Deo iaoa ta ila ngan tuanga ga tuanga, panua busa ga tilolon ngan ei. Be oangga ila aea tuanga ipuiai, pagid isobosobo, gid ga tilolon ngan ei mao.” ");
INSERT INTO bch_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tota Iesus ikado uisinga busa toa eoa mao ngansa lolod matua ngan ei mao. ");
INSERT INTO bch_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ngan ado toaiua, madidnga kapei Erot ilongo Iesus iualu. ");
INSERT INTO bch_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ta ikeo pagid ele paeaeanga bedane, “Eaba toa ne ei Ioanes Paliliunga aea, be idae mulian ngan ele matenga. Tota iura kapei ngan kadonga gid uisinga.” ");
INSERT INTO bch_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Erot ikeo bedaoa ngansa ei iuai Erodias, itar kapei Pilip iadaoa. Be ngan ipu toaiua Ioanes iselele Erot bedane, “Lem kadonga ngan oainga lem kadenge ne itutui mao.” Tota Erot isula ele panua ta tiluku Ioanes ta tiaud ei ga tidol ei ga idudunga ngan luma panasnga aea. ");
INSERT INTO bch_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ta Erot iuangga ipamate Ioanes, be imataud gid ipom, ngansa gid tiuangga Ioanes ei eaba ibada Deo iaoa. ");
INSERT INTO bch_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Be ado ede, Erot ikado eaneannga kapei ngan aea poponga. Be rabu ngan eaneannga toa oa, Erodias inat taine inam itoltol gid nounga matadeai, ta ikado ga Erot itin igelgel kapei. ");
INSERT INTO bch_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tota ikado posanga tautaunga pan taine blala toa oa ngan badanga saoa danga ikim ga ila pan. ");
INSERT INTO bch_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Be ei inasi itna ilinge ta ikeo pan bedane, “Gau nakim toa patautene eao dol Ioanes Paliliunga aea ilabora ngan lalate ta bada ga inam pagau.” ");
INSERT INTO bch_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Maron kapei Erot ilongo posanga toa oa ta ilolo ikulupu ngan, be imata nanan ele posanga tautaunga toa ikado gid nounga matadeai. Tota ikeo pan ele paeaeanga ta ila ikado mambe taine blala ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ta ele paeaeanga ila ngan luma panasnga aea ta iket Ioanes igagal ga put. ");
INSERT INTO bch_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Tota idol ilabora ga idae ngan lalate ede ta ibada ga ila pan taine blala toa oa, ta ei ibada ga ila pan itna. ");
INSERT INTO bch_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Idio ta Ioanes ele aluagau tinam tibada ipat ta tila titaian. Ga kus ta tila tipalongo Iesus. ");
INSERT INTO bch_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iesus ilongo posanga ngan Ioanes ele matenga ga kus, ta itnan tibur toa oa. Ei idae oagaeai toman ngan ele aluagau, ta kekelegid tila ngan tibur modamodanga ede. Be gid ipom ngan gid tuanga boloma, tilongo ngan ele langa toa oa ta tipaele ga tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ei itnan oaga ga idio be igera ipom kapei tau, ta ilolo isat ngan gid, ta ikado kemi ad dibala. ");
INSERT INTO bch_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Idio ta ado iuangga idil, ta ele aluagau tila pan ta tikeo, “Tibur ne modamodanga, be ado iuangga idil. Tota sula gid ipom ga tila ngan gid tuanga ta tiuol ad annga.” ");
INSERT INTO bch_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Be Iesus ikeo pagid, “Kemi ngan gid tila mao. Gimi apan ad annga.” ");
INSERT INTO bch_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Be ele aluagau tikeo, “Annga eta pade nene mao. Amai bret lima ga ia rua mon ienono.” ");
INSERT INTO bch_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ta ikeo, “Abada ga inam pagau.” ");
INSERT INTO bch_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Io, Iesus ikeo pagid ipom ta tidio timado tanoeai. Ta ibada bret lima ga ia rua ta imata idae ga ila buburiai ta iposa kemi pan Deo ngan. Ga kus ta itei ta ibada ga ila pagid ele aluagau, ta gid tiuade ga ila pagid ipom. ");
INSERT INTO bch_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Be gid toa ngada oa tian ga apad isum. Ga kus ta tibada mulian annga ilialia ta tinonoi ngan karei sangaul ga igegea rua. ");
INSERT INTO bch_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Toa eoa arangaranga bunoringring lima tian toman ngan adadaoad ga led gergeu. ");
INSERT INTO bch_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Be mole mao, Iesus iaoa isensen ele aluagau ta tidae oagaeai ta timuga ngan ei ga tila liu isal iadag. Be ei ikeo ga idio ta isula gid ipom ga tila. ");
INSERT INTO bch_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Io, isula gid ipom ga tila ga kus ta ei kekelen idae ga ila lusiai ta idio iraring. Tibur bong be ei kekelen imamado lusiai. ");
INSERT INTO bch_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Be ele aluagau tiuodeode ga tila liu irabuiai, aluai tau ngan lab. Be rai kapei iuot ta isoka gid ga ngalu ipatabulbul gid. ");
INSERT INTO bch_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Io, gaga iuangga itakai, be Iesus ilalala eau igogoeai ga ingata gid. ");
INSERT INTO bch_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Be gid aluagau tigera ei ilalala eau igogoeai ta tikakrik kapei ta tikeo, “Danga oa lausio eta!” Tota timataud ga tingangar. ");
INSERT INTO bch_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Be mole mao Iesus ibaba ga ila pagid ta ikeo, “Lolomi pu! Eine gau. Amataud mao.” ");
INSERT INTO bch_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Be Petrus ikeo pan bedane, “Maron, oangga eao tautaunga, keo pagau ta nalalala eau igogoeai ga nalat pago.” ");
INSERT INTO bch_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ta Iesus ikeo, “Nama.” Tota Petrus isulug oagaeai ta ilalala gadae ngan eau igogo ga ingata Iesus. ");
INSERT INTO bch_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Be ei igera rai kapei ta imataud. Tota iuangga imadi ta ibaba, “Maron, lua gau!” ");
INSERT INTO bch_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Be mole mao, Iesus igaga ibage ta igigiran Petrus ta ikeo, “O Petrus, eao lem kadonga lolo matua aea ne kapei mao. Eao kamado ga lolom ruangada?” ");
INSERT INTO bch_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Io, gisirua tidae oagaeai, tota rai itano ga idio. ");
INSERT INTO bch_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Be gid toa oagaeai oa tilolon ngan ei kapei tau ta tikeo, “Tautaunga, eao Deo Inat.” ");
INSERT INTO bch_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Gid tiuore ngan liu isal iadag ta tidudunga ngan tuanga Genesaret. ");
INSERT INTO bch_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gid panua tigera Iesus ta tiuatai ngan ei. Tota tisula ato ga ila ngan gid tuanga boloma, ta tital gid panua ad dibala ga tila pan. ");
INSERT INTO bch_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Gid tibeta matua ei ngan ilongean gid ta tisibo ele pononga imatamata. Ta gid toa ngada oa tisibo ei bedaoa, tinid iuot kemi. ");
INSERT INTO bch_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Idio ta gid Parisi edengada toman ngan gid madidnga apu ad titnan Ierusalem ga tila pan Iesus ta tibeta ei bedane, ");
INSERT INTO bch_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ikamado ga lem aluagau tipul murid ngan nasinga togid tibutibuda? Gid tisigiri baged mao be tian.” ");
INSERT INTO bch_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ta ei ikoli led posanga bedane, “Be ikamado ga lemi nasinga ikado ga apul murimi ngan Deo ele posanga? ");
INSERT INTO bch_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ngansa Deo ikeo, ‘Eao manta lolon ngan tamam ga tnam ta nasi linged.’ Ga ‘Oangga sai kado posanga paeamao ngan itama mao itna, ei ga imate.’ ");
INSERT INTO bch_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Be gimi akeo ga oangga sai ikim, kemi ngan ikeo pan itama ga itna bedane, ‘Leg pat toa mugaeai ienono ngan luanga gimirua, gau nasio ngan iman Deo ele tenainga.’ ");
INSERT INTO bch_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tota ei ga ilolon ngan itna ga itama mao, be gimi akeo ga eine kemi. Tota ngan lemi nasinga, gimi akado ga Deo ele posanga iman danga buligaliga. ");
INSERT INTO bch_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Gimi panua pakakanga ami! Mugaeai Aisaia ibada Deo iaoa tutui ngan gimi ta ikeo, ");
INSERT INTO bch_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“‘Gid panua toa ne tilolon ngan gau ngan aoad kekelen, be lolod inam pagau tautaunga mao. ");
INSERT INTO bch_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Gid tisoa edag sapaean. Tikado paoatainga ngan gid eababa led posanga ta tikeo ga eine Deo ele apu.’” ");
INSERT INTO bch_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iesus ibaba gid ipom ga tinam pan ta ikeo pagid bedane, “Gimi alongo kemi leg posanga ga abada oatainga. ");
INSERT INTO bch_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Saoa danga idudunga eaba iaoai irangrang ngan ikado ei ga iuot paeamao Deo imatai mao. Be saoa danga ienono eaba iloleai ga iuot iaoai, eine ikado ei ga iuot paeamao Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Idio ta ele aluagau tila pan ta tibeta ei bedane, “Gid Parisi tilongo posanga toa ne ta lolod paeamao ngan, be eao oatai pade?” ");
INSERT INTO bch_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ta ikoli led posanga bedane, “Saoa danga toa Tamag buburiai iarum aea dadangai mao, eine ga ikule ta itado ga iduaea. ");
INSERT INTO bch_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gimi atnan gid ga tidio. Gid mambe panua matad sususu tipasolan edap pagid panua padengada matad sususu. Toa bedaoa ga gisingada titap babaeai ga tisulug.” ");
INSERT INTO bch_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Be Petrus ibeta ei bedane, “Irangrang ngan eao paola posanga ipu pagai ngan oanenga itna toa ne pade?” ");
INSERT INTO bch_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ta Iesus ikeo, “Ikamado? Gimi pade laborami ibada maitne? ");
INSERT INTO bch_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Manta aoatai bedane: Saoa danga idudunga eaba iaoai, eine ga ila iapai ta inasi edap sakir aea. ");
INSERT INTO bch_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Be gid danga iuot eaba iaoai, eine inam iloleai ga iuot. Ta gid danga toa bedaoa ikado ei ga iuot paeamao Deo imatai. ");
INSERT INTO bch_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ngansa gid danga inam eaba iloleai ga iuot, eine gid danga papaeamao ga bedane: matad nanan danga papaeamao, ga raunga eaba ga imate, ga kadonga arala, ga kadonga iriau aea, ga lublubnga, ga posanga pakakanga, ga dabanga sasat. ");
INSERT INTO bch_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gid kadonga toa ne ikado eaba ga iuot paeamao Deo imatai. Be oangga eaba ian annga be isigiri ibage mao, kadonga toa ne irangrang ngan ikado ei ga iuot paeamao Deo imatai mao.” ");
INSERT INTO bch_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Idio ta Iesus ila aluai ngan tibur toa oa ga ila ngan tibur togid panua Tair ga Saidon. ");
INSERT INTO bch_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Be mole mao taine Kenan aea ede ngan tibur toa oa ila pan ta ibaba bedane, “Maron, eao Devit itub, uduan gau! Iriau paeamao ipaeabu ngan natug taine paeamao tau.” ");
INSERT INTO bch_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Be Iesus ikoli ele posanga eta mao. Ta ele aluagau tila pan ta tikeo, “Palua taine toa ne ga ila, ngansa ei inasnasi gita be ibababa parpar tau.” ");
INSERT INTO bch_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Be ei ikoli led posanga bedane, “Deo isula gau ga nanam pagid alu padengada mao. Isula gau ngan luanga gid Israel kekelegid toa titnan ele edap ga tisususu mambe sipsip.” ");
INSERT INTO bch_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Be ei inam boloma pan ta ikor iae ga isulug ta ikeo, “Maron, lua gau!” ");
INSERT INTO bch_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Be Iesus ikoli ele posanga bedane, “Oangga natado gid gergeu ad bret ga ila pagid kaua, eine kemi mao.” ");
INSERT INTO bch_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ta ei ikeo, “Tautaunga, Maron. Be gid kaua pade tianean annga isakirkir togid tamatamad itaptap ga isulug popou ibuloloeai.” ");
INSERT INTO bch_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iesus ilongo posanga toa ne ta ikeo, “O taine, lem kadonga lolo matua aea kapei tau. Danga toa ne ga iuot lalaede mambe eao kim.” Io, tutui ngan ado imata toaiua, taine toa oa ele gergeu iuot kemi. ");
INSERT INTO bch_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Idio ta Iesus itnan tibur toa oa ta ilalala ga ila liu kapei Galili isaleai. Ei idae ga ila bereoeai ta idio imado. ");
INSERT INTO bch_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Be ipom kapei tila pan ta tital gid panua busa ad dibala. Edengada aed imatemate, padengada matad ikilakila, padengada tuatuad konggekongge, padengada aoad gum, ga dibala padengada busa. Tidol gid boloma ngan Iesus iae, ta ikado kemi gid. ");
INSERT INTO bch_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Be panua tigera gid aoad gum tiposaposa, ga panua tuatuad konggekongge iuot tutui, ga panua aed imatemate tilalala, ga panua matad ikilakila tigeragera pade. Tota gid ipom timatala kapei ta tisoa Deo togid Israel ieda. ");
INSERT INTO bch_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Idio ta Iesus ibaba ele aluagau ga tinam pan ta ikeo, “Gau lolog isat ngan gid ipom toa ne, ngansa timamado toman ngan gau irangrang ngan ado tol na, be ad annga eta mao. Be tinig ngan nasula gid ga tila toman ad pitoro mao. Ngan kado ta tinid iura mao ta titaptap edapeai.” ");
INSERT INTO bch_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Be ele aluagau tikeo, “Tibur ne modamodanga. Be gita tabada annga sida irangrang ngan ipom kapei toa bedane?” ");
INSERT INTO bch_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ta Iesus ibeta gid, “Gimi ami bret pida ienono?” Ta tikeo, “Lima ga rua toman ngan ia gereirei pidaede.” ");
INSERT INTO bch_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Io, Iesus ikeo pagid ipom ta tidio timado tanoeai. ");
INSERT INTO bch_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ta ibada bret lima ga rua toman ngan ia, ta iposa kemi pan Deo. Ga kus ta itei ta ibada ga ila pagid aluagau, ta gid tiuade ga ila pagid ipom. ");
INSERT INTO bch_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Gid toa ngada oa tian ga apad isum. Ga kus ta tibada gid annga ilialia mulian ta tinonoi ngan samare lima ga rua. ");
INSERT INTO bch_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Arangaranga bunoringring pange tian toa eoa toman ngan adadaoad ga led gergeu. ");
INSERT INTO bch_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Io, Iesus isula gid ipom ga tila, ga kus ta idae oagaeai ta ila ngan tibur togid Magadan. ");
INSERT INTO bch_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Idio ta gid Parisi ga Sadiusi tila pan Iesus ngan tobanga ei. Ta tibeta ei ngan pasolannga gid ngan uisinga eta iman kilala ngan ei ikakado Deo ele naurata. ");
INSERT INTO bch_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ta ikoli led posanga bedane, “Oangga ado idil ga mariamba isingsingia, gimi ga akeo, ‘Sabale ga tibur kemi, ngansa mariamba isingsingia.’ ");
INSERT INTO bch_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Be oangga gaisala, gimi ga akeo, ‘Labone rai ga iuot ga aoara itap, ngansa mariamba isingsingia be laulau kapei ipakala ado imata.’ Gimi aoatai kilala ngan tibur kemi ga tibur paeamao ngan geranga mariamba, be ikamado ga aoatai kilala ngan saoa danga iuotot labone rabu ngan gimi ne mao? ");
INSERT INTO bch_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Gid panua papaeamao labone ad, lolod itnan Deo somisomi, be tikim tigera uisinga iman kilala. Be gid ga tigera kilala eta pade mao. Kilala kelede mon ga tigera, eine kilala ngan Iona.” Iesus iposa bedaoa ga kus ta itnan gid ga ila. ");
INSERT INTO bch_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Idio ta Iesus toman ngan ele aluagau tiuot ngan liu isal iadag, be ele aluagau matad sapian ngan badanga bret. ");
INSERT INTO bch_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Be Iesus ikeo pagid, “Gimi agabit kemi. Ala aluai ngan yis togid Parisi ga Sadiusi.” ");
INSERT INTO bch_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ta tiposa pol ngan gid bedane, “Ei ikado posanga toa ne ngansa gita tabada bret mao.” ");
INSERT INTO bch_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Be Iesus iuatai ngan posanga toa tikeo ngan ta ikeo, “Lemi kadonga lolo matua aea kapei eta mao! Ikamado ga aposaposa ngan ami bret ienono mao? ");
INSERT INTO bch_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Gimi laborami ibada maitne? Be kadonga iuot oadla ne, matami nanan mao? Gitaingada ipom bunoringring lima, gita ada bret lima mon, be gimi anonoi annga ilialia ngan karei pida? ");
INSERT INTO bch_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Be gitaingada ipom bunoringring pange, gita ada bret lima ga rua mon, be anonoi annga ilialia ngan samare pida? ");
INSERT INTO bch_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ikamado ga aoatai ngan leg posanga ipu mao? Gau naposa pagimi ngan bret mao, be nakeo ga agabit kemi ngan yis togid Parisi ga Sadiusi.” ");
INSERT INTO bch_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Io, tota tiuatai ngan ele posanga ipu. Ei iposa pagid ngan yis bret aea mao, be ikeo ga tigabit kemi ngan paoatainga togid Parisi ga Sadiusi. ");
INSERT INTO bch_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Idio ta Iesus ilalala ga ila ngan tibur boloma ngan tuanga Sisaria Pilipai. Ta ibeta ele aluagau bedane, “Gid panua tikeo ga Eaba Inat ei sai?” ");
INSERT INTO bch_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ta gid tikeo, “Panua edengada tikeo ga eao Ioanes Paliliunga aea, be padengada tikeo ga eao Elaija, be padengada tikeo ga eao Ieremaia, mao eaba ede ibada Deo iaoa mugaeai.” ");
INSERT INTO bch_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ta ibeta gid, “Be gimi akeo ga gau sai?” ");
INSERT INTO bch_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ta Saimon Petrus ikoli ele posanga bedane, “Eao Kristus, gergeu ton Deo toa imamado somisomi ne.” ");
INSERT INTO bch_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ta Iesus ikeo, “Saimon, gergeu ton Iona, kemi tau ngan eao! Ngansa eaba eta tanoeai ipaola posanga toa ne pago mao, be Tamag buburiai ipaola ga ila pago. ");
INSERT INTO bch_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Be gau nakeo pago, lalaede mambe edam Petrus ipu eine ‘pat,’ gau ga nakado ga gid panua tiuot iaoa kelede togau ga timadid matua ngan pat toa ne, ta irangrang ngan matenga iura iasal gid iaoa kelede togau mao. ");
INSERT INTO bch_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Be atama ila ngan madonga Deo ibageai, gau nabada aea kuklang ga ila pago. Ta saoa danga eao pakala tanoeai, eine Deo ga ipakala buburiai pade, be saoa danga eao longo ngan tanoeai, eine ga Deo ilongo ngan buburiai pade.” ");
INSERT INTO bch_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Idio ta Iesus irenren matua pagid aluagau ngan tikeo pan eaba eta pade mao ngan ei Kristus. ");
INSERT INTO bch_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Ngan ado toaiua ga ila, Iesus iaoa inasi pagid ele aluagau ngan ei manta ila Ierusalem ta ibada ieieinga imata ede ga ede pagid kapeipei ga gid madidnga tenainga ad ga apu ad bagedeai, ta tirau ei ga imate. Be ngan ado tol aea ta idae mulian. ");
INSERT INTO bch_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Be Petrus ilongo bedaoa ta ibada Iesus ga ila digedige ta idaba ei bedane, “Maron, mao tau! Irangrang ngan kadonga toa ne iuot ngan eao mao ga mao!” ");
INSERT INTO bch_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Be ei ipul ei ta ikeo pan Petrus bedane, “Satan, eao la muriai ngan gau! Eao oangga pakala leg edap na? Eao nasi Deo ele kimnga mao, be eao nasi gid eababa led kimnga.” ");
INSERT INTO bch_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Tota Iesus ikeo pagid ele aluagau bedane, “Oangga sai ikim inasi gau, manta itnan ele kimnga tano aea ga idio, ta ibisi aea abei tabala ta inasi gau. ");
INSERT INTO bch_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngansa oangga sai igera ele madonga tanoeai mambe danga kapei tau, ei ga imate ta ele madonga iduaea. Be oangga sai imate ngan nasinga gau, ei ga ibada madonga kemi tautaunga. ");
INSERT INTO bch_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ngansa oangga eaba eta ibabada danga sisid toa ngada ne tanoeai, be isapir ngan madonga kemi muriai ngan ele matenga, ele danga toa ngada oa ga ilua ei madongan? Ngansa eaba eta irangrang ngan iuol ele madonga kemi muriai aea mao. ");
INSERT INTO bch_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Be teta pade Eaba Inat ga inam toman ngan Itama ele taranga kapei ga ele anggelo. Ngan ado toaiua, ei ga ikoli pagid panua kelede kelede ga inasi led kadonga. ");
INSERT INTO bch_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nakeo tautaunga pagimi, panua edengada timadmadid toa nene ga timate maitne, be tigera Eaba Inat inama ta danga toa ngada ne idae ibageai.” ");
INSERT INTO bch_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Muriai ngan ado lima ga ede, Iesus ibada Petrus ga Jems ga itar kakau Ioanes kekelegid ta tidae ga tila ngan lusi ede gadae tau. ");
INSERT INTO bch_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Be toa eoa Iesus itin iuot ede pade matadeai. Ei imata iuot mambe ado, be ele danga sisid iuot bodbode ga mil ga mil mambe taranga. ");
INSERT INTO bch_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Be mole mao tigera Moses ga Elaija per ga tiuot, ta gisingada Iesus tiposaposa. ");
INSERT INTO bch_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Be Petrus ikeo pan Iesus bedane, “Maron, eine kemi ngan tadio toa eko. Oangga eao kim, gau ga nakado palata tol, eao lem ede, ga Moses ele ede, ga ede pade ton Elaija.” ");
INSERT INTO bch_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ei iposaposa maitne, be mole mao laulau ede bodbode tau irobi gid. Be babanga ede iuot laulau iloleai ta ikeo, “Eine gau Natug toa nakim ei tau. Lolog kemi ngan ei. Gimi alongo ilinge.” ");
INSERT INTO bch_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Gid aluagau tilongo bedaoa ta tikor aed ga tidol laborad ga isulug tanoeai be timataud kapei tau. ");
INSERT INTO bch_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Be Iesus inam ta ibage idae ngan gid ta ikeo, “Adae amadid. Amataud mao.” ");
INSERT INTO bch_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Be matad idae ta tigera Iesus kekelen, be eaba eta pade mao. ");
INSERT INTO bch_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Idio ta tisorir lusiai ga tisulug, ta Iesus irenren matua pagid ta ikeo, “Danga toa gimi agera ne, akeo pan eaba eta pade ngan mao, ga ila irangrang ngan Eaba Inat idae mulian ngan ele matenga.” ");
INSERT INTO bch_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Be ele aluagau tibeta ei bedane, “Ikamado ga gid madidnga apu ad tikeo ga Elaija ga inam imuga ngan Kristus?” ");
INSERT INTO bch_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ta ikoli led posanga bedane, “Posanga toa ne tautaunga. Elaija inam ta ipatutui danga toa ngada ne ngan Kristus ele namanga. ");
INSERT INTO bch_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Be gau nakeo pagimi, Elaija imuga ga inama o. Be gid tiuatai ngan ei mao. Tota tinasi led kimnga ta tikado paeamao ngan ei. Eine ga tipaieiei Eaba Inat toa bedaoa pade.” ");
INSERT INTO bch_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iesus iposa bedaoa ta ele aluagau tiuatai, ei iposa pagid ngan Ioanes Paliliunga aea. ");
INSERT INTO bch_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Iesus toman ngan ele aluagau toa tol oa tiuot pagid ipom. Be eaba ede ila pan ta ikor iae boloma pan ");
INSERT INTO bch_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ta ikeo, “Maron, uduan gau natug. Ei aea kakapanga ta ibabada ieieinga paeamao tau. Pateatea itap ga idae dingaeai ga pateatea itap ga isulug eauiai. ");
INSERT INTO bch_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ta gau natal ei ga ila pagid lem aluagau, be tirangrang ngan tikemi ei mao.” ");
INSERT INTO bch_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ta Iesus ikeo bedane, “O gimi panua labone ami! Lolomi matua eta mao, be ananale ngan lemi kadonga sasat tau. Papida ga namamado toman ngan gimi ga nabisi ami kadonga kulupulupu? Atal gergeu toa na inam pagau.” ");
INSERT INTO bch_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Io, Iesus idaba iriau paeamao ta itnan gergeu toa oa. Tota aea kakapanga kus ngan ado imata toaiua. ");
INSERT INTO bch_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Idio ta ele aluagau kekelegid tila pan ta tibeta ei, “Ikamado ga gai arangrang ngan serenga iriau paeamao toa oa mao?” ");
INSERT INTO bch_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ta ikeo pagid, “Eine ngansa lemi kadonga lolo matua aea kapei mao. Nakeo tautaunga pagimi, oangga lolomi matua ngan Deo kautede pade, mambe mastet ipuapua kakauede, eine gimi ga arangrang ngan akeo pan lusi ga oaine bedane, ‘Eao dae ta la ga eoa,’ ta eine ga ilongo lingemi ga ila. Toa bedaoa ta gimi ga arangrang ngan akado danga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Idio ta Iesus toman ngan ele alugau tila tiluplup Galili, ta ikeo pagid bedane, “Teta pade ga tidol Eaba Inat ga idae pagid panua bagedeai. ");
INSERT INTO bch_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ta gid ga tirau ei ga imate, be ngan ado tol aea, ei ga idae mulian.” Be ele aluagau tilongo posanga toa oa ta lolod isat kapei. ");
INSERT INTO bch_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Iesus toman ngan ele aluagau tila tiuot Kapernaum, be gid panua takis ad ngan Deo ele luma tila pan Petrus ta tibeta ei, “Lemi eaba paoatainga aea iuolol takis ngan Deo ele luma pade?” ");
INSERT INTO bch_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ta Petrus ikeo, “Be. Ei iuolol.” Idio ta Petrus idudunga lumaeai, be ikado posanga eta maitne, ta Iesus ibeta ei, “Saimon, eao keo mado ngan gid mamaron kapeipei tanoeai aea? Sapadua tibabada takis ga ila pagid, gid iaoa kelede togid, mao panua padengada?” ");
INSERT INTO bch_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ta Petrus ikeo, “Panua padengada.” Ta Iesus ikeo, “Eine tautaunga. Tota gid iaoa kelede ton maron kapei tiuolol takis mao. ");
INSERT INTO bch_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Be kado ta tapamasmasi lolod. Tota eao la ngan liu kapei ta tado lem konaonanga ga ila. Ia isaoa imuga ga ibada, tota dada ga idae ta pokaka iaoa. Eao ga gera pat ede ienono iaoai. Bada pat toa na ga ila pagid ta iman gitarua leda takis aea.” ");
INSERT INTO bch_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ngan ado imata toaiua, Iesus ele aluagau tila pan ta tibeta ei, “Sai ieda iuot kapei tau ngan gid panua timamado Deo ibageai?” ");
INSERT INTO bch_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Be Iesus ibaba gergeu ede ga inam pan ta idol ei rabu ngan gid ");
INSERT INTO bch_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ta ikeo, “Nakeo tautaunga pagimi, manta apul lolomi ga aot mambe gergeu. Oangga mao, irangrang ngan gimi abada madonga Deo ibageai mao. ");
INSERT INTO bch_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tota oangga sai idol ei mulian ga idio gadio, mambe gergeu toaine, ei ieda ga iuot kapei rabu ngan gid panua timamado Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Be oangga sai ibada gergeu kelede toa bedane ngan gau edag ta ilua ei, eine ibada gau ta ilua gau.” ");
INSERT INTO bch_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Iesus ikeo pade bedane, “Gid leg panua toa edad mao bedane, gid lolod matua ngan gau kemi. Be oangga sai ipabuobuo eta ngan gid ta ele kadonga lolo matua aea itap, eine Deo ga ipanas eaba toa oa paeamao tau. Kemi ngan tikaukau eaba toa oa igagal ngan pat kapei ede ta titado ei ga isulug tadiai motean! Toa bedaoa ta irangrang ngan ipabuobuo eta ngan gid mao. ");
INSERT INTO bch_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Paeamao tau ngan tal mon gid panua tanoeai! Ngansa danga busa iuangga ipabuobuo gid ta led kadonga lolo matua aea itap. Gid danga toa bedaoa ga iuotot. Be paeamao tau ngan eaba sai ikado danga toa bedaoa ga iuot. ");
INSERT INTO bch_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tota oangga bagem mao aem ikado ga lem kadonga lolo matua aea itap, ket ta tado ga iduaea! Kemi ngan bagem kelede, mao aem kelede, ta eao la ngan madonga kemi. Be kado bagem rua, mao aem rua, ta Deo itado go ga la ngan dinga imperno. Dinga toa oa ianean somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Be oangga matam eta ikado ga lem kadonga lolo matua aea itap, pasu matam ga iuot ta tado ga iduaea! Kemi ngan matam kelede ta eao la ngan madonga kemi. Be kado matam rua ta Deo itado go ga la ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","“Gimi agabit kemi. Ngan kado ta matami ibiu eta ngan leg panua toa edad mao ne. Ngansa gau nakeo pagimi, gid ad anggelo buburiai somisomi tigeragera Tamag imata toa buburiai oa.” ");
INSERT INTO bch_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Iesus ikeo pade bedane, “Oangga eaba ede ele sipsip buno, be ede ngan gid isusu, gimi aoangga ei ga ikado mado? Eine ga itnan gid sangalima sangaul pange igegea lima ga pange ga tidio bereoeai ta ila iloilo toa kelede oa isusu. ");
INSERT INTO bch_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Nakeo tautaunga pagimi, oangga iuot ngan sipsip toa oa, eine ga itin igelgel kapei. Ele tingelgel toa ne ga iasal ele tingelgel ngan gid padengada toa tisusu mao. ");
INSERT INTO bch_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Lalaede toa bedaoa, Tamami buburiai itin ngan ele panua gereirei toa eta ngan gid isusu mao.” ");
INSERT INTO bch_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iesus ikeo pade bedane, “Oangga oaem ede pade ele kadonga sat ngan eao, la pan ta gimirua kekelegimi amado ta eao patutui ei. Oangga ilongo eao, tota kemi ngan gimirua lolomi itarui mulian. ");
INSERT INTO bch_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Be oangga ilongo lem posanga mao, tota bada eaba eta, mao panua rua pade ta tila toman ngan eao, ta timan bebem. Toa bedaoa ta ‘panua rua mao tol tipamatua posanga ga iuot tutui.’ ");
INSERT INTO bch_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Be oangga ilongo lemi posanga mao, tota apaola posanga toa oa pagid iaoa kelede ton Deo matadeai. Be oangga itin ngan longonga gid iaoa kelede ton Deo mao pade, tota atnan ei ga idio ta iuot mambe eaba takis aea, mao mambe eaba ede imangamanga ngan Deo. ");
INSERT INTO bch_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nakeo tautaunga pagimi, saoa danga apakala tanoeai, eine Deo ga ipakala buburiai pade, be saoa danga alongo ngan tanoeai, eine Deo ga ilongo ngan buburiai pade. ");
INSERT INTO bch_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Nakeo pade pagimi, oangga panua rua ngan gimi toa tanoeai ne lolod kelede ngan saoa danga tibeta Tamami buburiai ngan, eine ga ilongo gid ta ikado led posanga ga iuot. ");
INSERT INTO bch_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ngansa oangga panua rua mao tol tiluplup ngan gau edag, gau namamado rabu ngan gid.” ");
INSERT INTO bch_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Idio ta Petrus ila pan Iesus ta ibeta ei bedane, “Maron, oangga oaeg ede pade ele kadonga sat ngan gau, gau manta nasamum papida? Oangga ikado kadonga sat pagau palima ga rua, ta nasamum toa bedaoa palima ga rua, ikaranga na?” ");
INSERT INTO bch_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Be Iesus ikoli ele posanga bedane, “Nakeo pago, lem kadonga ngan samumnga ele kadonga sasat palima ga rua ne irangrang mao. Be eao samum ga ila irangrang ngan palima ga rua, ga palima ga rua pade ga ila irangrang ngan sangalima sangaul rua. ");
INSERT INTO bch_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Ngan ipu toaine, madonga Deo ibageai eine mambe maron kapei ede tanoeai aea toa ikeo ga ele paeaeanga tinam pan ta tipatutui ad gigi. ");
INSERT INTO bch_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ei ikakado toa bedaoa, be tital eaba ede ga ila pan toa aea gigi gadae ngan pat bunoringring sangaul, irangrang ngan tiuade mao. ");
INSERT INTO bch_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ei irangrang ngan ikoli aea gigi toa oa mao. Ta aea maron ikeo pagid ele paeaeanga padengada ta tilongean eaba toa oa toman ngan iadaoa ga ele gergeu ta panua padengada tibada gid ga timan led paeaeanga sapaean. Ta ele danga sisid toa ngada oa, panua ga tiuolol ga irangrang ngan aea gigi toa dodol oa kus. ");
INSERT INTO bch_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Be paeaeanga toa oa ikor iae pan ta ibeta matua bedane, ‘Eao sanga gau kauteta ta nakoli ag gigi toa dodol ne ga ila pago.’ ");
INSERT INTO bch_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Be maron ilolo isat ngan paeaeanga toa oa, ta isamum aea gigi toa dodol oa ta ilongean ei ga ila sapaean. ");
INSERT INTO bch_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Be paeaeanga toa oa iuot ga ila ta igera iuae ede pade toa gisirua led naurata kelede. Eaba toa oa aea gigi pan iuot mambe pat buno ede. Tota iluku ei ta igigiran matua igagal ta ikeo, ‘Eao manta koli am gigi pagau toa patautene!’ ");
INSERT INTO bch_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Be eaba toa oa ikor iae pan ta ibeta ei matua bedane, ‘Eao sanga gau kauteta, ta nakoli ag gigi toa ne ga ila pago.’ ");
INSERT INTO bch_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Be paeaeanga toa oa itin ngan mao. Be ila idol eaba toa oa ga idudunga ngan luma panasnga aea, ga irangrang ngan ikoli aea gigi. ");
INSERT INTO bch_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Be gid paeaeanga padengada tigera ele kadonga toa bedaoa, ta lolod ikulupu tau. Tota tila pan ad maron ta aoad inasi pan ngan paeaeanga toa oa ele kadonga toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Idio ta maron ibaba paeaeanga toa oa ga inam pan ta ikeo, ‘Eao paeaeanga paeamao! Mugaeai eao tang pagau ta nasamum am gigi toa kapitnami oa. ");
INSERT INTO bch_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Be eao kamado ga lolom isat ngan oaem ede pade mao, mambe gau lolog isat ngan eao mugaeai?’ ");
INSERT INTO bch_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Maron ilolo bake ta idol ei ga idae pagid madidnga bagedeai ngan luma panasnga aea, ta tipaieiei ei ga irangrang ngan iuol mulian aea gigi toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Be Tamag buburiai ga inasi kadonga lalaede toa bedaoa ngan gimi pade, oangga asamum tautaunga oaemi ede pade ele kadonga sasat ngan gimi mao.” ");
INSERT INTO bch_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Idio ta Iesus ipasala gid posanga toa ne. Ga kus ta itnan Galili ta ila ngan gid tuanga Iudea iadag ngan eau Iordan. ");
INSERT INTO bch_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ipom kapei tinasi ei, ta ikado kemi ad dibala ngan tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Be gid Parisi tila pan ta tiuangga titoba ei ta tibeta ei bedane, “Eao keo mado ngan ketnga oainga? Oangga eaba isuk iadaoa, be inasi ipu eta mao, eine tutui pade, mao madongan?” ");
INSERT INTO bch_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ta Iesus ikoli led posanga bedane, “Kado gimi aoato laulau ngan danga toa Deo ikado mugaeai oa mao? Ele laulau ikeo ga mugaeai tau ikado danga toa ngada ne ga iuot, be ‘ikado gid panua ga tiuot arangaranga ga taine.’ ");
INSERT INTO bch_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ta Deo ikeo bedane, ‘Ngan ipu toaine eaba ga itnan itama ga itna ta ila ilup toman ngan iadaoa, ta eine mambe gisirua tinid iuot kelede.’ ");
INSERT INTO bch_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Toa bedaoa ta tirangrang ngan timan rua pade mao. Gisirua tiuot kelede Deo imatai. Tota danga toa Deo ikaukau, irangrang ngan eaba eta iket mao.” ");
INSERT INTO bch_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ta gid Parisi tikeo, “Tota ikamado ga Moses ibode apu ngan eaba iuangga isuk iadaoa, manta ibada laulau ngan ketnga led oainga ga ila pan, ga kus ta isuk ei ga ila?” ");
INSERT INTO bch_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ta Iesus ikeo, “Gimi apaki tangami ngan Deo ele posanga somisomi tau, tota Moses ilongean gimi ta asuksuk adadaoami. Be mugaeai tau ga inam, Deo ilongo ngan kadonga eta bedane mao. ");
INSERT INTO bch_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Be gau nakeo pagimi, oangga sai iadaoa ikado arala mao, be isuk ei sapaean ta iuai taine pau pade, eaba toa oa ikado kadonga arala.” ");
INSERT INTO bch_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ta ele aluagau tikeo pan, “Oangga eaba imado paeamao toman ngan iadaoa bedaoa, kemi ngan gisirua tiuai mugaeai mao.” ");
INSERT INTO bch_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ta Iesus ikeo pagid, “Irangrang ngan panua toa ngada ne tinasi posanga ga oaine mao, be Deo ibada pagid panua keledengada. ");
INSERT INTO bch_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Alongo, arangaranga edengada tiuai taine mao ngan ipu imata ede ga ede. Edengada tinid paeamao ngan tnad ipopo gid, ta tirangrang ngan tiuai mao. Padengada, panua tipaeabu ngan tinid ta tirangrang ngan tiuai mao. Be padengada tiuai mao ngansa tiuangga tikado naurata ngan luanga gid panua ta tibada madonga Deo ibageai. Eaba sai irangrang ngan inasi posanga toa ne, kemi ngan inasi.” ");
INSERT INTO bch_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Idio ta gid panua tital led gergeu ga tila pan Iesus, ta tiuangga idol ibage ga idae ngan gid ta iraring ngan luanga gid. Be ele aluagau tidaba gid. ");
INSERT INTO bch_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Be Iesus ikeo, “Alongean gid gergeu ga tinam pagau. Apaidi gid mao. Ngansa madonga Deo ibageai eine togid panua toa bedane.” ");
INSERT INTO bch_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Idio ta idol ibage ga idae ngan gid gergeu kelede kelede, ga kus ta itnan tibur toa oa ga ila. ");
INSERT INTO bch_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Be mole mao eaba ede ila pan Iesus ta ibeta ei bedane, “Eaba paoatainga am, gau ga nakado saoa kadonga kemi ta nabada madonga kemi somisomi?” ");
INSERT INTO bch_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ta Iesus ikeo, “Ikamado ga eao beta gau ngan kadonga kemikemi? Deo kekelen ei kemi. Be oangga eao keo ga bada madonga kemi somisomi, eao manta nasi gid apu ton Deo.” ");
INSERT INTO bch_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ta ibeta ei, “Eao keo ngan gid apu isaoa?” Ta Iesus ikeo, “‘Eao pamate eaba ede pade mao, eao kado arala ta paeabu ngan oainga mao, eao lublub mao, oangga eao madid ngan posanga, irangrang ngan eao pakaka mao, ");
INSERT INTO bch_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","be eao manta lolon ngan tamam ga tnam ta nasi linged. Be eao kim lem eaba ede pade mambe kim go mulian.’” ");
INSERT INTO bch_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ta eaba iriau toa oa ikeo, “Gau nanasnasi gid posanga toa ngada ne. Be leg idil isaoa imata karanga maitne?” ");
INSERT INTO bch_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ta Iesus ikeo pan, “Oangga eao keo ga ot tutui tau, eao la longean lem danga sisid toa ngada oa pagid panua ta tiuolol. Ta bada lem pat, ta oade ga ila pagid panua lululunga ad. Toa bedaoa ta lem danga sisid kemikemi ienono buburiai. Ga kus ta nam nasi gau.” ");
INSERT INTO bch_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Be eaba iriau ilongo posanga toa ne ta ilolo itangtang be itnan ei ga ila. Ngansa ele danga sisid busa. ");
INSERT INTO bch_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ta Iesus ikeo pagid ele aluagau, “Nakeo tautaunga pagimi, eine kulupu tau ngan gid panua toa led danga sisid busa ngan tibada madonga Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nakeo pade pagimi, oangga kamel itoba ngan ipurususu ngan salumu aea baba, eine ga kulupu ngan ei, mao madongan? Be kulupu ga kulupu tau ngan eaba sai toa ele danga sisid busa, ngan ibada madonga Deo ibageai.” ");
INSERT INTO bch_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Be gid aluagau tilongo posanga toa ne ta tikakrik kapei ta tikeo, “Toa bedaoa ta sai irangrang ngan Deo ibada ei mulian?” ");
INSERT INTO bch_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Be Iesus imata ila pagid ta ikeo, “Gid eababa tirangrang mao. Be Deo kekelen irangrang ngan ikado danga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Tota Petrus ikeo, “Ega, gai atnan lemai danga sisid toa ngada oa ta anama anasi go. Eine gai ga abada saoa?” ");
INSERT INTO bch_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ta Iesus ikeo pagid, “Nakeo tautaunga pagimi, muriai oangga Deo ikado danga toa ngada ne ga iuot pau, Eaba Inat ga idio imado ngan ele mul Maron aea ngan taranga kapei. Ta gimi panua toa anasnasi gau, gimi pade ga amamado ngan lemi mul maron aea kelede kelede ta amugamuga ngan gid lum sangaul igegea rua togid Israel. ");
INSERT INTO bch_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Be oangga sai inasi gau ta itnan ele luma, ga itar kapeipei, ga aea kakakau, ga iliuliu, ga itama, ga itna, ga ele gergeu, ga aea dadanga, eine Deo ga ikoli buno pade pan eaba toa oa ngan danga sisid toa ne, ta ei ga ibada madonga kemi somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Be panua busa toa edad kapei labone, muriai edad ga isulug. Be panua busa toa edad mao labone, muriai edad ga iuot kapei.” ");
INSERT INTO bch_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Iesus ikeo pade bedane, “Nakeo bedaoa ngansa madonga Deo ibageai eine mambe ninipunga ga oaine ngan dadanga itama ede. Gaisala rumaruma ei isogou ga ila ngan ilonga gid panua ta tiboko ngan aea dadanga oain. ");
INSERT INTO bch_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Gid panua naurata ad tilongo ngan badanga pat kelede iman ad olnga ngan ado toaiua. Tota isula gid ga tila tiboko aea dadangai. ");
INSERT INTO bch_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Be gaisala ngan ado imata lima ga pange, eaba toa oa ila ngan tibur oalo aea ta igera gid panua timadmadid sapaean. ");
INSERT INTO bch_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ta ikeo pagid, ‘Gimi pade ala aboko ngan ag dadanga oain, ta gau ga naol gimi ngan saoa olnga itutui ngan lemi naurata.’ ");
INSERT INTO bch_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tota gid pade tila tiboko toa eoa. “Be ngan arobad ei ila ipalum gid panua toa bedaoa pade, ga lailai ngan ado imata tol, ikado toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Be lailai ngan ado imata lima, ila ngan tibur oalo aea pade ta igera panua padengada timadmadid sapaean ta ikeo pagid, ‘Ikamado ga gimi amadmadid sapaean ado dodol toa ne ga lailai?’ ");
INSERT INTO bch_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Ta tikeo pan bedane, ‘Eine ngansa eaba eta ibada naurata pagai mao.’ “Ta ikeo pagid, ‘Gimi pade ala aboko ngan ag dadanga oain.’ ");
INSERT INTO bch_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Io, ado idil ga kus ta dadanga itama ikeo pan ele madidnga ngan gid panua naurata ad bedane, ‘Baba gid panua naurata ad ga tinam, ta bada ad olnga ga ila pagid. Be eao pamuga olnga ila pagid panua toa tinam lailai tau, ta ol gid ga ila irangrang ngan gid panua tinama gaisala.’ ");
INSERT INTO bch_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Io, gid panua tinam lailai ngan ado imata lima, gid kelede kelede tibada pat kelede iman ad olnga. ");
INSERT INTO bch_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ila ga kus ta gid panua toa tinama gaisala ngan naurata, gid tiuangga ad olnga ga iasal olnga togid panua tiboko lailai kekelen. Be mao. Gid pade tibada pat kelede. ");
INSERT INTO bch_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tibada ad olnga toa bedaoa ta tiselele dadanga itama ");
INSERT INTO bch_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ta tikeo, ‘Gid panua tinam muriai tau, gid tikado naurata kautede mon, be eao kamado ol gid lalaede mambe gai pade? Be gai aboko matua ado dodol ga lailai, be ado ilang karkar gai tau!’ ");
INSERT INTO bch_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Be dadanga itama ikoli posanga pan eaba ede ngan gid ta ikeo, ‘Leg eaba, gau leg idil eta paeamao ngan go mao. Gaisala gitarua loloda kelede ngan eao bada pat kelede ngan lem naurata labone na? ");
INSERT INTO bch_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Eao bada am olnga ta la. Be gid panua tinam muriai, gau nakim naol gid ngan olnga lalaede mambe eao bada. ");
INSERT INTO bch_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Eine danga togau. Be oangga nanasi leg kimnga ngan saoa danga togau, eao gera mambe itutui mao na? Be kado lolom paeamao ngan leg mamaron?’” ");
INSERT INTO bch_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Be lalaede toa bedaoa, panua busa toa edad kapei labone, muriai edad ga isulug. Be panua busa toa edad mao labone, muriai edad ga iuot kapei.” ");
INSERT INTO bch_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Idio ta Iesus ilalala ga ila Ierusalem, be edap irabuiai, ibada ele aluagau sangaul igegea rua, ta gid kekelegid tila digedige ta ikeo pagid, ");
INSERT INTO bch_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ega, gita tala Ierusalem. Be toa eoa ga tidol Eaba Inat ga idae pagid madidnga tenainga ad ga apu ad bagedeai. Ta gid ga tipamadid ei ngan posanga ta tirau posanga ngan pamatenga ei. ");
INSERT INTO bch_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Eine ga tidol ei ga idae pagid alu padengada bagedeai, ta gid ga tigalinge paeamao ngan ei, ga timuimui ei, ga tipatoto ei ngan abei tabala. Be ngan ado tol aea ta idae mulian.” ");
INSERT INTO bch_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Idio ta Sebedi iadaoa ibada ele gergeu rua ta tila pan Iesus. Ta ikor iae ta iuangga ibeta ei ngan danga ede. ");
INSERT INTO bch_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ta Iesus ibeta ei, “Eao kim saoa?” Ta ikeo, “Muriai oangga eao ot Maron kapei ta danga toa ngada ne idae bagemeai, gau nakim leg gergeu toa rua ne tibada edaeda kapei toman ngan eao, ta ede imado ngan bagem oatai, be ede pade ngan bagem angas.” ");
INSERT INTO bch_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Be Iesus ikoli ele posanga bedane, “Gimi aoatai ngan saoa danga abeta ngan ne mao. Loba ieieinga aea toa teta pade ga naun, gimi arangrang ngan aun pade?” Ta gisirua tikeo pan, “Be. Gairua arangrang.” ");
INSERT INTO bch_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ta ikeo pagid, “Tautaunga, gimirua ga aun loba ieieinga aea mambe gau naun. Be sapadua ga timado ngan bageg oatai ga bageg angas, eine danga togau mao. Tamag kekelen ibada gid mul toa ne pagid panua toa ei isio.” ");
INSERT INTO bch_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Idio ta gid aluagau padengada tilongo posanga toa oa ta lolod bake pagisirua. ");
INSERT INTO bch_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Be Iesus ibaba gid ga tinam pan ta ikeo, “Gimi aoatai ngan kadonga togid alu padengada. Ad mamaron kapeipei timadid matua ta tipaeaea led panua, ga ad madidnga tikado kulupu tau ngan gid. ");
INSERT INTO bch_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Be irangrang ngan gimi anasi kadonga toa ne mao. Be sai ngan gimi iuangga ieda iuot kapei, manta ikado naurata ngan luanga gimi. ");
INSERT INTO bch_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ga sai iuangga imadid ga imuga ngan gimi, ei ga iman lemi paeaeanga. ");
INSERT INTO bch_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Eine mambe Eaba Inat pade. Ei inama ngan gid panua tilua ei mao, be ei inama ngan luanga gid panua. Ta ilongean ei mulian ga imate ngan patutuinga panua busa ad gigi kapei Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Idio ta Iesus asingada ele aluagau titnan tuanga Ieriko ga tila, be ipom kapei tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Be panua rua timamado edap isaleai, matad sususu. Gisirua tilongo ngan Iesus ilalala ga inam, ta mole mao tibaba matua bedane, “Maron, eao Devit itub, uduan gairua!” ");
INSERT INTO bch_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Be gid ipom tidaba gisirua ta tikeo, “Amumun!” Be mao. Gisirua tibaba matua pade, “Maron, eao Devit itub, uduan gairua!” ");
INSERT INTO bch_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ta Iesus iae tor ta ibaba gisirua ga tinam ta ikeo, “Gimirua akim nakado mado ngan gimi?” ");
INSERT INTO bch_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ta tikeo, “Maron, gai akim eao kado kemi matamai.” ");
INSERT INTO bch_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Io, Iesus ilolo isat ngan gisirua ta idol ibage ga idae ngan matad. Be mole mao, matad iuot kemi pade ta tilalala ga tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Idio ta Iesus asingada ele aluagau tipaboloma Ierusalem ta tiuot ngan tuanga Betpage ngan bereo Oliv. Ta isula ele aluagau rua ");
INSERT INTO bch_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ta irenren pagisirua bedane, “Gimirua ala ngan tuanga ga matadai ne, be mole mao, gimirua ga agera donki ede tikaukau ngan oaro toman ngan ele gergeu daenga pau. Apola ad oaro ta abada gisirua ga tinam pagau. ");
INSERT INTO bch_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Be oangga eaba eta ibeta gimirua ngan, gimi ga akeo, ‘Maron ele bokonga ngan gisirua. Be mole mao ei ga isula gisirua ta tiluagid mulian.’” ");
INSERT INTO bch_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kadonga toa ne iuot ta iparangrang Deo ele posanga mambe eaba ibada Deo iaoa mugaeai ikeo ngan bedane, ");
INSERT INTO bch_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Apalongo gid panua ngan bereo Saion bedane, ‘Ega, ami Maron kapei tota ila pagimi ne. Ei iparim ngan ei mulian mao, be imamado donki ipaoeai, be imamado donki daenga pau ede ipaoeai.’” ");
INSERT INTO bch_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Io, aluagau toa rua oa tila tikado mambe Iesus ikeo pagisirua ngan. ");
INSERT INTO bch_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tibada donki itna toman ngan ele gergeu, ta tidol led pononga mamarae ga idae paodeai ta Iesus idae imado ngan. ");
INSERT INTO bch_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Be panua busa tau tibada led pononga mamarae ta tilalo edapeai. Be padengada tiket abei ilaun kapeipei ta tilalo edapeai pade. ");
INSERT INTO bch_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Panua busa tilalala ga timuga ngan ei, be padengada tilalala muriai, ta tibaba bedane, “Eao Devit itub, gai asoa edam ga idae!” “Maron ipamatua eaba toa inama ngan ei ieda ne!” “Tasoa Maron gadae tau ieda!” ");
INSERT INTO bch_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Io, Iesus idudunga Ierusalem toa bedaoa, ta gid ipom tuangai ad titogragid ta tibeta pol gid alele bedane, “Eaba toa ne sai?” ");
INSERT INTO bch_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Be panua toa oa, tikoli led posanga bedane, “Eine Iesus, eaba toa ibada Deo iaoa. Aea tuanga ipu Nasaret ngan tibur Galili.” ");
INSERT INTO bch_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Idio ta Iesus idudunga ngan Deo ele luma aea ala ta isere gid panua tibokoboko ngan pat aea badanga ga gid panua tiuolol danga sisid Deo ele lumaeai. Ta ipatabul gid popou togid panua tilaumalile ngan pat ga ipatabul gid mul madonga aea togid panua toa tilongean man barur ga panua tiuolol. ");
INSERT INTO bch_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ta ikeo pagid, “Deo ele laulau aea posanga bedane, ‘Gau leg luma, gid panua ga tiuato luma raring aea.’ Be gimi apul ga iman ‘baba mumulnga aea togid panua lublubnga ad.’” ");
INSERT INTO bch_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Idio ta gid panua matad ikilakila ga panua aed imatemate tila pan toa gadudunga ngan Deo ele luma aea ala, ta ikado kemi gid. ");
INSERT INTO bch_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Be gid madidnga tenainga ad ga apu ad tigera kadonga kemikemi toa Iesus ikakado, ga tigera gid gergeu gereirei Deo ele lumaeai tibaba ga ila pan bedane, “Eao Devit itub, gai asoa edam ga idae!” Ta gid madidnga toa oa lolod bake. ");
INSERT INTO bch_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ta tibeta ei bedane, “Eao longo posanga toa tikakado ngan eao na?” Ta Iesus ikoli led posanga bedane, “Nalongo led posanga na. Be posanga ga oaine ienono ngan Deo ele laulau, be kado gimi aoato mao? Ikeo ga bedane, “‘Deo, eao kado ga gid gergeu gereirei ga gergeu puruanga pade tisoasoa eao edam.’” ");
INSERT INTO bch_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Idio ta Iesus itnan gid ga tidio ta iuot ga ila gaot ngan tuanga Ierusalem, ta ila ngan tuanga Betani ta ieno ngan bong toaiua. ");
INSERT INTO bch_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Be gaisala rumaruma Iesus ilalala ga ila Ierusalem pade, be pitoreanei. ");
INSERT INTO bch_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ta igera abei fik ede imadmadid edap isaleai, ta ila boloma ngan. Be igera itautau eta mao. Ilaun kekelen ienono. Tota ikeo ga abei fik toa oa irangrang ngan itautau pade mao ga ilalala ga ila. Be mole mao, abei toa oa imalai ga imate. ");
INSERT INTO bch_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Be ele aluagau tigera ta tikakrik ta tikeo, “Ikamado ga abei toa ne imalai ga imate manmanae tau?” ");
INSERT INTO bch_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ta Iesus ikoli led posanga bedane, “Nakeo tautaunga pagimi, oangga lolomi matua ngan Deo, be lolomi ruangada mao, eine gimi ga akado mambe gau nakado ngan abei fik toa ne. Ga pade, gimi ga akado posanga ngan lusi ga oaine bedane, ‘Eao dae ta dug ga la tadiai!’ Ta eine ga ila ikado toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ta oangga lolomi matua ngan Deo, gimi ga abada saoa danga araring ga ila pan ngan.” ");
INSERT INTO bch_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Idio ta Iesus idudunga ngan Deo ele luma aea ala ta ipaoatai gid ipom. Be gid madidnga tenainga ad ga gid kapeipei togid Iuda tila pan ta tibeta ei bedane, “Sai idol naurata toa ne ga idae bagemeai ta isula go ngan aea kadonga?” ");
INSERT INTO bch_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ta Iesus ikoli led posanga bedane, “Gau pade ga nabeta gimi ngan posanga ede. Ta oangga akoli leg posanga, eine ga nakeo pagimi ngan sai isula gau ngan kadonga naurata toa ne. ");
INSERT INTO bch_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Naurata toa Ioanes ikakado mugaeai, ngan paliliunga gid panua, eine inam buburiai ga inam, mao inam pagid eababa?” Be tiraurau posanga pol ngan gid ta tikeo, “Oangga takeo ga inam buburiai ga inam, eine ga ikeo, ‘Ikamado ga lolomi matua ngan ele posanga mao?’ ");
INSERT INTO bch_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Be oangga takeo ga inam pagid eababa, eine tamataud gid ipom. Ngansa gid busa tiadi mambe Ioanes ei eaba ede ibada Deo iaoa.” ");
INSERT INTO bch_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tota tikoli Iesus ele posanga bedane, “Gai aoatai mao.” Ta ikeo pagid, “Goibe, gau pade ga nakeo pagimi mao ngan sai isula gau ngan kadonga naurata toa ne.” ");
INSERT INTO bch_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iesus ikeo pade bedane, “Gimi akeo mado ngan posanga ga oaine? Eaba ede ele gergeu rua. Ei ila pan lautabe ta ikeo, ‘Natug, eao la boko ngan dadanga oain labone.’ ");
INSERT INTO bch_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Be ikoli ele posanga bedane, ‘Gau tinig ngan mao.’ Be muriai, ipul ilolo ta ila iboko toa eoa. ");
INSERT INTO bch_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Idio ta ila pan ele gergeu toa ede pade oa ta ikado posanga toa bedaoa pade ngan langa dadangai. Ta ikeo, ‘Apa, gau ga nala.’ Be ila eta mao. ");
INSERT INTO bch_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Tota sai ngan gisirua ilongo tamad ilinge?” Ta tikeo, “Gergeu lautabe.” Ta Iesus ikeo, “Nakeo tautaunga pagimi, gid panua takis ad ga gid taine edap ad timugamuga ngan gimi ta tibada madonga Deo ibageai. ");
INSERT INTO bch_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ngansa mugaeai Ioanes inam ta ipasolan gimi ngan edap tutui aea nasinga, be lolomi matua ngan ei mao. Be gid panua takis ad ga taine edap ad lolod matua ngan ei. Be gimi agera tikakado bedaoa, be apul lolomi mao, ga lolomi matua ngan ei mao pade.” ");
INSERT INTO bch_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iesus ikeo pade bedane, “Alongo oanenga itna ede pade. Dadanga itama ede iarum gid abei oain aea dadangai. Ei itado ala ngan ta ikado tibur ede kemi ngan bibnga oain itautau ta tibada isul ngan. Ga ikado luma mamarae ede ngan gid panua timadid ngan ta matad ikilele. Ga kus ta ilongean dadanga toa oa ga idae gid panua naurata ad bagedeai, be ei ila ngan tibur ede pade aluai. ");
INSERT INTO bch_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Idio ta oain aea laoe iuot, ta isula ele paeaeanga ga tila pagid panua naurata ad ngan badanga oain itautau idanga ede ga ila pan. ");
INSERT INTO bch_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Be gid panua naurata ad tiluku gid paeaeanga toa oa, ta tirau ede paeamao tau, be tipamate ede pade, be ede pade tiraurau ei ngan pat. ");
INSERT INTO bch_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ga kus ta dadanga itama isula ele paeaeanga padengada ga tila pagid, be isula gid busa tede iasal gid toa mugaeai isula gid oa. Be gid panua naurata ad tikado toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ele paeaeanga toa ngada oa, isula gid ga kus. Be muriai, isula inat ga ila pagid ta ikeo, ‘Eine ga tilolon ngan natug.’ ");
INSERT INTO bch_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Be gid panua naurata ad tigera inat ta tiposa pol ngan gid bedane, ‘Ega, muriai eaba toa ne ga ibada danga sisid toa ngada ne ton itama. Io, tarau ei ga imate, ta ele danga sisid toa ngada ne ga iman leda!’ ");
INSERT INTO bch_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tota tiluku ei ta titado ei ga ila gaot ngan dadanga aea ala, ta tirau ei ga imate.” ");
INSERT INTO bch_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Io, oangga dadanga itama iluai mulian, gimi aoangga ei ga ikado mado ngan gid panua naurata ad?” ");
INSERT INTO bch_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ta gid tikeo, “Ei ga ipaeabu ngan gid panua papaeamao toa oa. Ta ilongean aea dadanga ga ila pagid panua padengada. Ta oangga oain aea laoe iuot, gid ga tibada aea oain itautau tutui ga ila pan.” ");
INSERT INTO bch_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ta Iesus ikeo pagid, “Eine tautaunga. Be posanga ga oaine ienono ngan Deo ele laulau, be kado gimi aoato mao? Ikeo ga bedane, “‘Pat toa ne, gid panua tikakado luma tiuangga eine paeamao ta titado ga iduaea. Be labone iman luma aea kisinga. Maron ikado ga iuot bedane, ta gai agera eine kemi tau ta amatala ngan.’ ");
INSERT INTO bch_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Tota nakeo pagimi, Deo ga isuk gimi ga ala, ta abada madonga ei ibageai mao. Be gid panua iaoa ede pade toa tinasnasi tutui ele kimnga, gid ga tibada madonga ibageai. ");
INSERT INTO bch_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Oangga sai itap ga idae ngan pat toa ne, eine ga krau ga krau ga irumrum. Be oangga pat toa ne itap ga idae ngan eaba sai, eine ga ibib ei ga imaraka.” ");
INSERT INTO bch_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Io, gid madidnga tenainga ad ga gid Parisi tilongo Iesus ele oanenga itna, ta tiuatai mambe ei iposaposa ngan gid. ");
INSERT INTO bch_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ta gid tiuangga tilo edap eta ngan lukunga ei, be timataud gid ipom, ngansa gid busa tiadi mambe ei ibada Deo iaoa tautaunga. ");
INSERT INTO bch_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Idio ta Iesus itado oanenga itna ede pade pagid ta ikeo, ");
INSERT INTO bch_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Madonga Deo ibageai eine mambe maron kapei ede toa ikado eaneannga kapei ngan inat ele oainga. ");
INSERT INTO bch_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Mugaeai, isio gid panua ngan tinam ngan ele eaneannga ta ipalongo gid ngan. Idio ta ado eaneannga aea iuot ta isula ele paeaeanga ga tila pagid panua toa oa, ta tikeo pagid ngan tinam, be gid tinid ngan namanga mao. ");
INSERT INTO bch_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Be isula ele paeaeanga padengada ga tila pagid ta irenren matua bedane, ‘Gimi ala pagid panua toa nababa gid mugaeai, ta akeo pagid bedane, “Ega, gau natotoi gid bulmakao ga masilau titubtub kapeipei, ta danga sisid toa ngada ne imata karanga ga kus. Nanono annga toa ngada ne ga imisi o. Tota anama ngan leg eaneannga oainga aea.” ’ ");
INSERT INTO bch_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Io, gid paeaeanga tila tikado toa bedaoa, be gid panua tilongo maron kapei ele posanga mao. Eaba ede ila aea dadangai, be ede pade ila ikado ele naurata ngan badanga pat. ");
INSERT INTO bch_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Be padengada tiluku maron kapei ele paeaeanga ta tikado paeamao ngan gid ta tirau gid ga timate. ");
INSERT INTO bch_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Tota maron kapei ilolo bake ta isula ele panua paraunga ad ga tila tipaeabu ngan gid panua papaeamao toa oa ta titun led tuanga. ");
INSERT INTO bch_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Idio ta maron kapei ikeo pagid ele paeaeanga pade bedane, ‘Agera, annga oainga aea imisi ga ienono, be gid panua toa mugaeai nababa gid, led idil kemikemi imata karanga mao. ");
INSERT INTO bch_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tota gimi ala ngan gid edap kapeipei iaoa, ta sapadua gimi agera, ababa gid ga tinam ngan eaneannga toa ne.’ ");
INSERT INTO bch_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Idio ta ele paeaeanga tila ngan gid edap kapeipei iaoa, ta tipaluplup gid panua sapadua toa tigera. Eiua gid panua kemikemi ga panua papaeamao, ta tibada gid ga tila timado ngan luma eaneannga aea ga irangrang ngan iuon. ");
INSERT INTO bch_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Gid busa timamado ngan eaneannga, ta maron kapei idudunga ga ila igera gid. Be toa eoa igera eaba ede idol pononga eta kemi ngan eaneannga oainga aea mao. ");
INSERT INTO bch_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ta ikeo pan, ‘Leg eaba, ikamado ga eao dol pononga eta kemi mao, be nam dudunga ngan eaneannga toa ne?’ Be eaba toa oa ele posanga eta mao. ");
INSERT INTO bch_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ta maron kapei ikeo pagid ele paeaeanga bedane, ‘Gimi akaukau iae ga ibage ta atado ei ga ila gaot, ta idio ngan tibur dodom. Toa eoa ga titangtang paeamao ga luod kek ga kek.’ ");
INSERT INTO bch_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Alongo. Deo ibaba panua busa, be isio gid keledengada ga timan ele panua.” ");
INSERT INTO bch_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Idio ta gid Parisi tila tirau posanga ngan tobanga edap ede ngan pabuobuonga Iesus. Ngansa tikim tigera ei ikado posanga idil paeamao eta ta irangrang ngan tipamadid ei ngan posanga. ");
INSERT INTO bch_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tota tisula led aluagau gisingada Erot ele panua ga tila pan. Ta tikeo, “Eaba paoatainga am, gai aoatai mambe eao eaba posanga tautaunga am, ta eao papaoatai gid panua ngan Deo ele edap tautaunga. Eao kado kadonga bagbage kelede mao, ngansa eao mataud eaba eta mao. ");
INSERT INTO bch_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Be keo pagai, eine tutui ngan taol takis ga ila pan Kaisa, mao madongan?” ");
INSERT INTO bch_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Be Iesus iuatai ngan lolod paeamao ta ikeo, “Gimi panua pakakanga ami! Akamado ga atoba pabuobuonga gau? ");
INSERT INTO bch_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Apasolan pat eta takis aea pagau.” Io, tibada ga ila pan, ");
INSERT INTO bch_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ta ikeo pagid, “Sai ianun ga ieda ienono ngan pat toa ne?” ");
INSERT INTO bch_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ta tikeo, “Kaisa ianun ga ieda.” Ta ikeo pagid, “Tota danga ton Kaisa, abada ga ila pan Kaisa. Be danga ton Deo, abada ga ila pan Deo.” ");
INSERT INTO bch_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Gid tilongo toa bedaoa ta titogragid, be titnan ei ga tila. ");
INSERT INTO bch_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ngan ado toaiua, gid Sadiusi tila pan Iesus. Gid somisomi tikeo ga panua matemate tirangrang ngan tidae mulian mao. Tota tibeta ei bedane, ");
INSERT INTO bch_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Eaba paoatainga am, Moses ibode posanga bedane, ‘Oangga eaba eta ele gergeu mao be imate, eine itar kakau ga iuai asape toa oa ta tipopo gergeu iman eaba toa imate oa aea kolinga.’ ");
INSERT INTO bch_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Be ado ede, kadonga toa ne iuot pagai ga bedane: Arangaranga lima ga rua ngan iaoa ede timamado. Ad lautabe iuai taine, ga kus ta imate, be gisirua led gergeu eta mao. Tota itar kakau atange iuai asape toa oa, ");
INSERT INTO bch_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","be ei pade imate toa bedaoa. Ga kus ta itar kakau tol aea iuai ei ga imate ga ila irangrang ngan gid arangaranga toa lima ga rua oa. Tipopo gergeu eta mao, be timate. ");
INSERT INTO bch_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ga kus ta taine toa oa imate pade. ");
INSERT INTO bch_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tota ngan ado toaiua, oangga gid matemate tidae mulian, taine toa oa ga iman sai iadaoa? Ngansa gid toa lima ga rua oa tiuai ei.” ");
INSERT INTO bch_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ta Iesus ikoli led posanga bedane, “Gimi abuobuo ngansa aoatai ngan Deo ele laulau aea posanga mao, ga aoatai ngan iura mao pade. ");
INSERT INTO bch_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ngansa muriai, oangga panua matemate tidae mulian, gid ga tiuaioai mao, ga tipapaoai led gergeu mao pade. Be gid ga tiuot mambe gid anggelo buburiai. ");
INSERT INTO bch_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Be posanga ngan gid matemate tidae mulian, Deo iposa pagimi ngan ele laulau na. Be kado gimi aoato mao? Ikeo ga bedane, ");
INSERT INTO bch_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Gau Deo ton Abraam ga Aisak ga Iakop.’ Agera, ei Deo togid panua matemate mao, be ei Deo togid panua matad bibita.” ");
INSERT INTO bch_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Gid ipom tilongo bedaoa ta timatala kapei ngan ele paoatainga. ");
INSERT INTO bch_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Idio ta gid Parisi tilongo mambe Iesus ikado ga gid Sadiusi tirangrang ngan tikoli ele posanga mao, ta gid pade tiluplup. ");
INSERT INTO bch_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ta eaba apu aea ede ngan gid iuangga itoba Iesus ta ibeta ei bedane, ");
INSERT INTO bch_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Eaba paoatainga am, apu isaoa kapei ga iasal gid apu toa ngada ne?” ");
INSERT INTO bch_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ta Iesus ikeo, “‘Eao manta kim am Maron Deo kapei tau ngan lolom, ga tautaudim, ga lem oatainga.’ ");
INSERT INTO bch_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Apu toaine kapei ga iasal gid apu padengada. ");
INSERT INTO bch_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Be apu kapei ede pade eine lalaede mambe apu toa ne. Aea posanga bedane, ‘Eao manta kim lem eaba ede pade mambe kim go mulian.’ ");
INSERT INTO bch_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Apu toa rua ne iman posanga ipu ngan apu toa ngada ne ga ngan posanga togid panua tibada Deo iaoa mugaeai.” ");
INSERT INTO bch_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Gid Parisi tiluplup ga timamado, be Iesus ibeta gid bedane, ");
INSERT INTO bch_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Gimi akeo mado ngan eaba toa tiuato ei Kristus? Ei ga iuot ngan iaoa kelede pan sai?” Ta tikeo, “Ei iaoa kelede pan Devit.” ");
INSERT INTO bch_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ta Iesus ikeo, “Be ikamado ga Devit iuato eaba toa oa aea Maron? Ngansa Itautau Tutui ibada oatainga pan Devit ta ikeo bedane, ");
INSERT INTO bch_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“‘Maron Deo ikeo pan ag Maron bedane, “Eao dio mamado ngan bageg oatai, ga irangrang ngan nadol am miri itamatama ga tidio aem ibuloloeai.” ’ ");
INSERT INTO bch_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ega, oangga Devit iuato eaba toa oa aea Maron, ei ga iuot ngan iaoa kelede pan Devit madongan?” ");
INSERT INTO bch_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iesus iposa bedaoa, be eaba eta irangrang ngan ikoli ele posanga mao. Tota ngan ado toaiua ga ila, gid panua timataud ngan betanga ei ngan posanga eta pade. ");
INSERT INTO bch_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Idio ta Iesus iposa pagid ipom toman ngan ele aluagau bedane, ");
INSERT INTO bch_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Gid madidnga apu ad ga gid Parisi tibada Moses imul ta tipapaoatai gimi ngan apu ton Deo mambe Moses ikakado mugaeai. ");
INSERT INTO bch_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tota saoa danga tikeo pagimi ngan, manta alongo ga anasi. Be kadonga tikakado, irangrang ngan gimi anasi mao. Ngansa gid tikado posanga, be tinasi led posanga mulian mao. ");
INSERT INTO bch_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Led posanga kulupu tau ngan panua tinasi, mambe tulua kulupulupu tidol ga idae panua kepedeai ta tipaeaea gid ngan aea bisinga. Be tinid ngan luanga gid ngan aea bisinga kauteta mao. ");
INSERT INTO bch_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Led kadonga toa ngada oa, eine tikado ngansa tikim panua tigera gid ta tisoa edad. Gid tipapasogo led apou gereirei raring aea ta tipitpit ga idae laboradeai ga bagedeai, ga tikaukau oaro mamamarae ngan led pononga imatamata ngansa tiuangga iman kilala ngan tinasnasi Deo. ");
INSERT INTO bch_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Be oangga tila ngan luma raring aea ga tila ngan gid eaneannga kapeipei, tikim tau ngan badanga mul kemikemi togid panua edad kapeipei. ");
INSERT INTO bch_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Be oangga tila ngan tibur oalo aea, tikim panua busa tilolon ngan gid ta tikeo, ‘Ado kemi, mamaron.’ Ga tikim tau ngan gid panua tiuatoato gid ‘panua paoatainga ad.’ ");
INSERT INTO bch_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Be irangrang ngan gimi alongean eaba eta iuatoato gimi ‘panua paoatainga ami’ mao. Ngansa lemi eaba paoatainga aea kelede mon, be gimi toa ngada ne lalaede ngan iaoa kelede. ");
INSERT INTO bch_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Be irangrang ngan aoato eaba eta tanoeai aea ‘tamami’ mao. Ngansa Tamami kelede mon imamado buburiai. ");
INSERT INTO bch_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Be irangrang ngan alongean gid panua tiuatoato gimi ‘mamaron’ mao, ngansa ami Maron kelede mon, eine Kristus. ");
INSERT INTO bch_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Be eaba sai iman lemi paeaeanga, ei ga ieda iuot kapei ngan gimi. ");
INSERT INTO bch_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ngansa oangga sai isoa ieda mulian ga idae, Deo ga idol ieda ga isulug. Be oangga sai idol ieda mulian ga isulug, eine Deo ga isoa ieda ga idae.” ");
INSERT INTO bch_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Iesus ikeo pade bedane, “Paeamao tau ngan gimi madidnga apu ami ga gimi Parisi! Gimi panua pakakanga ami! Ngansa gimi apakala edap ngan gid panua tiuangga tibada madonga Deo ibageai. Gimi pade ala ngan badanga madonga Deo ibageai mao, be apakala gid panua padengada ta gid tibada madonga toa oa mao pade. ");
INSERT INTO bch_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Paeamao tau ngan gimi madidnga apu ami ga gimi Parisi! Gimi panua pakakanga ami! Ngansa gimi alalala ngan tibur toa ngada ne tanoeai ga tadiai ngan ilonga eaba kelede ta inasi lemi edap. Be oangga inasi gimi, gimi akado ei ta iasal gimi ngan kadonga papaeamao. Toa bedaoa ta gimingada ga ala ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Paeamao tau ngan gimi! Gimi mambe panua matad sususu, be aoangga apasolan panua padengada ngan edap. Ngansa gimi akeo, ‘Oangga sai iposa tautaunga gadae ta ikeo ngan Deo ele luma ngan pamatuanga ele posanga, be iparangrang ele posanga toa oa mao, eine danga eta mao. Be oangga iposa tautaunga gadae ngan danga sisid gol ienono Deo ele luma iloleai, ei manta iparangrang ele posanga ga iuot tautaunga.’ ");
INSERT INTO bch_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Gimi mambe panua matad sususu ga amangamanga! Gimi aoangga gol eine danga kapei ta iasal Deo ele luma? Eine mao. Deo ele luma iasal gol. Ngansa gol aea ul ienono sapaean mao. Deo ele luma ikado gol ga iman ei ele. ");
INSERT INTO bch_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ga pade, gimi akeo, ‘Oangga eaba iposa tautaunga gadae ta ikeo ngan popou tenainga aea ngan pamatuanga ele posanga, be iparangrang ele posanga toa oa mao, eine danga eta mao. Be oangga iposa tautaunga gadae ngan tenainga ienono popou ipaoeai, ei manta iparangrang ele posanga ga iuot tautaunga.’ ");
INSERT INTO bch_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Gimi mambe panua matad sususu! Gimi aoangga tenainga eine danga kapei ta iasal popou tenainga aea pade? Eine mao. Popou iasal tenainga. Ngansa tenainga aea ul ienono sapaean mao. Popou kekelen ikado tenainga ga iman Deo ele. ");
INSERT INTO bch_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Toa bedaoa ta oangga sai iposa tautaunga gadae ta ikeo ngan popou tenainga aea, eine ipamatua ele posanga ngan popou kekelen mao, be ipamatua ele posanga ngan popou toa oa toman ngan tenainga. ");
INSERT INTO bch_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Be oangga sai iposa tautaunga gadae ta ikeo ngan Deo ele luma, eine ipamatua ele posanga ngan luma kekelen mao, be ipamatua ele posanga ngan Deo ga ele luma toa imamado ngan. ");
INSERT INTO bch_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Be oangga sai iposa tautaunga gadae ta ikeo ngan Deo ele mul Maron aea buburiai, eine ipamatua ele posanga ngan Deo ele mul Maron aea kekelen mao, be ipamatua ele posanga ngan Deo pade imamado ngan mul toa oa. ");
INSERT INTO bch_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Paeamao tau ngan gimi madidnga apu ami ga gimi Parisi! Gimi panua pakakanga ami! Ngansa gid sabatnga imata ede ga ede, gimi apota ga iuot suknga sangaul, ta atenai suknga ede ga ila pan Deo. Gimi anasi gid apu gereirei toa bedaoa kemi, be atnan Deo ele apu kapeipei ga idio, mambe kadonga tutui, ga kadonga lolo isat aea, ga kadonga mata tutui aea. Gimi manta anasi gid apu kapeipei toa ne, be atnan gid apu gereirei toa oa mao. ");
INSERT INTO bch_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gimi mambe panua matad sususu, be aoangga apasolan panua padengada ngan edap. Gimi mambe eaba igera umoumo kakauede sapa ienono ngan aea sul ta ibada ga itado ga ila, be kamel kapitnami ienono ngan sul, eine gimi agera mao. Tota aun sul, be ason kamel pade ga ila. ");
INSERT INTO bch_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Paeamao tau ngan gimi madidnga apu ami ga gimi Parisi! Gimi panua pakakanga ami! Ngansa gimi asigiri loba ga lalate tinid pan gaot, be ilolo iuon ngan gid danga gimi ababada ngan lemi kadonga kate aea ga mogal buda. ");
INSERT INTO bch_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Gimi Parisi mambe panua matad sususu. Manta asigiri loba ga lalate ilolo bua. Toa bedaoa ta itin pan gaot ga iuot kemi pade. ");
INSERT INTO bch_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Paeamao tau ngan gimi madidnga apu ami ga gimi Parisi! Gimi panua pakakanga ami! Ngansa gimi mambe pat denga aea tisama ngan pulo bodbode. Denga pan gaot imata kemi, be ilolo iuon ngan panua tuatuad ga danga papaeamao imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gimi toa bedaoa pade. Ngan panua matad, gimi mambe panua tututui, be tautaunga lolomi iuon ngan kadonga pakakanga ga tnannga Deo ele apu. ");
INSERT INTO bch_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Paeamao tau ngan gimi madidnga apu ami ga gimi Parisi! Gimi panua pakakanga ami! Ngansa gimi akado kemi ga apasogo denga togid panua tututui ga panua tibada Deo iaoa mugaeai. ");
INSERT INTO bch_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ta gimi akeo, ‘Oangga gai amado ngan ado toaiua tibutibumai timamado, eine gai ga alua gid ngan pamatenga gid panua tibabada Deo iaoa oa mao.’ ");
INSERT INTO bch_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ngan lemi posanga toa ne, gimi aoaoa ngan gimi mulian ta akeo ga gimi iaoa kelede pagid panua tipapamate gid panua tibada Deo iaoa. ");
INSERT INTO bch_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Goibe, gimi apasala kadonga papaeamao togid tibutibumi, ta abada panasnga ngan pade! ");
INSERT INTO bch_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Gimi gergeu togid mota papaeamao! Gimi ga asapir ngan ami panasnga ngan dinga imperno madongan? ");
INSERT INTO bch_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ega, ngan ipu toaine gau ga nasula gid panua tibada Deo iaoa, ga panua oatainga ad, ga panua tipapaoatai gimi ngan Deo ele posanga ta tila pagimi. Be gimi ga arau edengada ga timate, ga apatoto padengada ngan abei tabala, ga amuimui padengada luma raring aea iloleai. Ta gimi ga abutatan gid ta tiaoa ga tila ngan tuanga ga tuanga. ");
INSERT INTO bch_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Toa bedaoa ta Deo ga ipanas gimi ngan pamatenga gid panua tututui toa ngada ne tanoeai. Ei ga ipanas gimi ngan Abel aea pamatenga mugaeai, ga ila irangrang ngan Sekaraia, gergeu ton Berekia, toa gimi apamate rabu ngan Deo ele luma ga popou tenainga aea. ");
INSERT INTO bch_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nakeo tautaunga pagimi, panasnga ngan kadonga sasat toa ngada ne ga iuot ngan gid panua toa labone timamado.” ");
INSERT INTO bch_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iesus ikeo pade bedane, “O Ierusalem, Ierusalem, gimi apapamate gid panua tibada Deo iaoa. Ga gid panua Deo isula gid ga tila pagimi, gimi araurau gid ngan pat ga timatemate. Somisomi naoangga napaluplup gimi ga namariala kemi ngan gimi mambe kokako taine ipaluplup inatnat ibagbage ibuloloeai, be gimi tinimi ngan mao. ");
INSERT INTO bch_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Tota alongo. Deo ga itnan ele luma ta lemi tuanga ga idio sapaean. ");
INSERT INTO bch_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ngansa nakeo pagimi, gimi ga agera gau pade mao ga ila irangrang ngan ado toaiua gimi akeo, ‘Maron ipamatua eaba toa ne ta isula ei ga inama ngan ei ieda.’” ");
INSERT INTO bch_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Idio ta Iesus iuangga itnan Deo ele luma aea ala ta ilalala ga ila. Be ele aluagau tila pan ta tiuangga tipasolan ei ngan gid luma gadudunga ngan Deo ele luma aea ala. ");
INSERT INTO bch_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ta ikeo pagid, “Gimi agera gid luma toa ngada ne kemikemi na? Nakeo tautaunga pagimi, muriai luma toa ne aea pat eta ga idae tatan pat eta pade mao. Eine ga tirepe toa ngada ne ga isulug.” ");
INSERT INTO bch_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Idio ta Iesus idio imado ngan bereo Oliv, be ele aluagau kekelegid tila pan ta tibeta ei bedane, “Keo pagai, gid kadonga toa ne ga iuot ngeda? Be saoa kilala ga iuot ta ipasolan mambe teta pade eao luago ga nam, ta ado muriai ga muriai tau ga iuot?” ");
INSERT INTO bch_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ta Iesus ikoli led posanga bedane, “Gimi agabit kemi. Ngan kado ta eaba eta ipakaka gimi. ");
INSERT INTO bch_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngansa panua busa ga tinam ngan gau edag ta tikeo ngan gid mulian bedane, ‘Gau Kristus.’ Ta gid ga tipabuobuo panua busa. ");
INSERT INTO bch_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Be gimi ga alongo paraunga kapeipei iualu boloma ga aluai, be irangrang ngan atogragimi mao. Ngansa gid paraunga toa bedane ga iuotot, be ado muriai ga muriai tau ga iuot maitne. ");
INSERT INTO bch_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ngansa panua ngan alu ede ga tiparau pagid alu ede pade, be maron kapei ede ele panua ga tiparau pagid panua ton maron kapei ede pade. Ngan tibur edengada sapanga kapeipei ga iuotot, be nauruge ga inuga tibur padengada ga inogonogoi. ");
INSERT INTO bch_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Be gid danga papaeamao toa ne irangrang ngan kus manmanae mao, mambe ieieinga iuot ngan taine mugaeai ngan ipopo gergeu. ");
INSERT INTO bch_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ngan ado toaiua, gid ga tiluku gimi ta tipaieiei gimi, ta tirau gimi ga amate. Ta gid alu toa ngada ne ga lolod itola ngan gimi, ngansa lolomi matua ngan gau. ");
INSERT INTO bch_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Be panua busa lolod ga itnan gau, ta gid ga timan ariapolpol ngan gid ta tidol led panua mulian ga tidae pagid madidnga bagedeai. ");
INSERT INTO bch_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Be panua busa ga tinam ta tipakaka ngan badanga Deo iaoa ta tipabuobuo panua busa. ");
INSERT INTO bch_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Be kadonga ngan tnannga Deo ele apu ga iuot kapei, ta eine ga ikado ga panua busa titnan kadonga ngan kimnga eaba ede pade. ");
INSERT INTO bch_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Be oangga sai imadid matua ga irangrang ngan ele madonga tanoeai kus, eine Deo ga ibada mulian ei. ");
INSERT INTO bch_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Be eine ga tipaola ato kemi toa ne ngan madonga Deo ibageai ta ila ngan tibur toa ngada ne tanoeai. Ta gid alu toa ngada ne ga tilongo. Ga kus ta ado muriai ga muriai tau ga iuot.” ");
INSERT INTO bch_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Iesus ikeo pade bedane, “Be muriai gimi ga agera danga ede paeamao ga paeamao tau imadmadid ngan tibur toa Deo ele ul ienono ngan, ta ikado ga panua tiaoa ta titnan tibur toa oa ga idio sapaean. Mugaeai Daniel ibada Deo iaoa ta iposa ngan danga toaine. (Eaba iuato laulau, manta iuatai kemi ngan posanga toa ne.) ");
INSERT INTO bch_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ngan ado toaiua, gid panua timamado Iudea, manta tiaoa ga tila bereoeai. ");
INSERT INTO bch_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Be oangga sai imamado luma ipaoeai, ei manta isulug ta iaoa manmanae. Irangrang ngan ila ibada ele danga etangada luma iloleai mao. ");
INSERT INTO bch_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Be oangga sai imamado dadangai, irangrang ngan ipul ei mulian ngan badanga ele pononga gaot aea mao. ");
INSERT INTO bch_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Be paeamao tau ngan gid taine apapanga ga gid pinapina ngan ado toaiua. Gid tal mon ga kulupu ngan eaoanga. ");
INSERT INTO bch_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Be manta araring ta lemi eaoanga iuot ngan aoara lolo mao, ga Ado Earainga aea mao pade. ");
INSERT INTO bch_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngansa danga kulupulupu tau ga iuot ngan ado toaiua. Ngan danga toa ngada ne led otnga ga irangrang ngan labone, danga eta kulupu bedaoa iuot mao, be muriai pade danga eta kulupu bedaoa ga iuot mao pade. ");
INSERT INTO bch_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Be oangga Deo ikeo ga gid danga kulupulupu toa ne ga idio mole, panua toa ngada ne tanoeai ga timukuru. Be ei imata nanan ele panua toa isio gid, ta ikeo ga danga kulupulupu toa ne ga idio mole tau mao. ");
INSERT INTO bch_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Ngan ado toaiua, oangga eaba eta ikeo pagimi, ‘Ega, Kristus tota eoa!’ mao ‘Ei tota eko!’ irangrang ngan aeadi posanga toa oa mao. ");
INSERT INTO bch_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ngansa panua busa ga tinam ta tipakaka ta tikeo, ‘Gau Kristus.’ Be padengada ga tipakaka ta tikeo ga tibada Deo iaoa. Ta gid ga tikado uisinga kapeipei iman kilala ga gid danga ipamatala panua busa. Ta oangga tirangrang, gid ga tipabuobuo Deo ele panua toa isio gid. ");
INSERT INTO bch_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ega, gau napalongo gimi motean ngan danga toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Tota oangga tikeo pagimi, ‘Ega, ei imamado ngan tibur modamodanga,’ gimi anasi gid ga ala mao. Be oangga tikeo, ‘Ega, ei imamado luma iloleai,’ gimi aeadi led posanga mao pade. ");
INSERT INTO bch_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngansa Eaba Inat ele namanga eine ga iuot mambe gla isamil ta itara mariamba dodol, toa ado ele parangai ga irangrang ngan ado ele dilngai. ");
INSERT INTO bch_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Be ngan tibur isaoa burua mate ienono ngan, eine gid man abalem ga tinam tiluplup.” ");
INSERT INTO bch_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Iesus ikeo pade bedane, “Ga muriai oangga gid danga kulupulupu toa oa kus, tota “‘ado ga iuot dodom, be taiko ga itara mao, be gid gigima ga titaptap mariambai ga tisulug, be gid danga kapeipei mariambai ga inogonogoi.’ ");
INSERT INTO bch_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Ga kus ta kilala ngan Eaba Inat ga iuot mariambai. Ta gid alu toa ngada ne tanoeai ga lolod isat ga titangtang. Gid ga tigera Eaba Inat isulug ga inam ngan gid laulau mariambai toman ngan iura ga ele taranga kapei. ");
INSERT INTO bch_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Be taule ga itang kapei tau, ta ei ga isula ele anggelo ga tila ngan tano igal toa pange oa ta tipaluplup ele panua toa isio gid. Gid ga tipaluplup gid ngan tibur toa ngada ne, irangrang ngan tano aea digedige iadag ga iadag, ta tibada gid ga tinam.” ");
INSERT INTO bch_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Iesus ikeo pade bedane, “Gimi alongo oanenga itna ngan abei fik ta abada oatainga. Oangga ibogaboga aea eau, ga ilaun papau iuotot, eine gimi aoatai, ado aea sau teta pade ga iuot. ");
INSERT INTO bch_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Toa bedaoa ta oangga gimi agera gid kadonga toa ngada ne iuotot, eine gimi aoatai, ado toaiua ta inam boloma, mambe eaba imadid atama iaoai. ");
INSERT INTO bch_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nakeo tautaunga pagimi, gid panua ado toa ne ad ga timate maitne be kadonga toa ngada ne ga iuot. ");
INSERT INTO bch_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Mariamba ga tano ga isapa, be irangrang ngan leg posanga isapa mao ga mao tau.” ");
INSERT INTO bch_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Iesus ikeo pade bedane, “Be eaba eta iuatai mao, gid danga toa oa ga iuot ngeda, mao ado imata pida be gid danga toa oa iuot. Gid anggelo buburiai tiuatai mao, be Deo Inat iuatai mao pade. Tamag kekelen iuatai. ");
INSERT INTO bch_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Kadonga toa gid panua tikakado ngan ado toaiua Noa imamado, eine ga tikado toa bedaoa pade ngan Eaba Inat ele namanga. ");
INSERT INTO bch_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ngan ado toaiua, mugaeai ngan oanga kapei iuot, gid panua tianean ga tiunun ga tiuaioai ga tipapaoai led gergeu taine, ga ila irangrang ngan ado toa Noa idudunga oagaeai. ");
INSERT INTO bch_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Gid tiuatai mao ngan danga toa oa ga iuot. Timamado toa bedaoa ga irangrang ngan oanga kapei iuot ta ipamukuru gid. Be Eaba Inat ele namanga eine ga iuot toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ngan ado toaiua, panua rua ga tiboko dadangai. Deo ga ibada ede ga ila, be itnan ede pade ga idio. ");
INSERT INTO bch_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Taine rua ga tilumulumu wit ipuapua ngan pat. Deo ga ibada taine ede ga ila, be itnan ede pade ga idio. ");
INSERT INTO bch_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Tota agabit kemi. Ngansa gimi aoatai mao, ami Maron ga inam ngeda. ");
INSERT INTO bch_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Be matami nanan: Oangga luma itama iuatai ngan eaba lublubnga aea ga inam bong ngan ado imata pida, eine ga imata arar ga igabit kemi ngan ele luma, ta irangrang ngan eaba lublubnga aea igoro mao. ");
INSERT INTO bch_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tota gimi pade matami idae, ngansa Eaba Inat ga inama ngan ado imata eta gimi aoatai ngan mao.” ");
INSERT INTO bch_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Iesus ikeo pade bedane, “Paeaeanga isaoa ele oatainga kemi ga imata tutui ngan ele naurata? Maron ga idol paeaeanga ede bedaoa ta iman madidnga ngan ele paeaeanga padengada. Ta ei ga ipotapota ad annga tutui ngan ado imata aea maron ikeo ngan. ");
INSERT INTO bch_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Oangga paeaeanga toa oa aea maron iluai mulian ta igera ei ikakado naurata kemi toa bedaoa, kemi tau ngan paeaeanga toa oa! ");
INSERT INTO bch_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nakeo tautaunga pagimi, ei ga idol ele danga sisid toa ngada oa ga idae paeaeanga toa oa ibageai ta imariala ngan. ");
INSERT INTO bch_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Be oangga paeaeanga toa oa paeamao, eine ga ikeo iloleai bedane, ‘Ag maron irangrang ngan inama manmanae mao.’ ");
INSERT INTO bch_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Tota ei ga iraurau gid paeaeanga padengada ta ianean ga iunun toman ngan panua led ununnga sat. ");
INSERT INTO bch_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Oangga bedaoa, eine aea maron ga iluai mulian ngan ado ede, mao bong ede toa ei iuatai ngan mao. ");
INSERT INTO bch_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Tota aea maron ga ipanas paeaeanga toa oa paeamao tau, ta idol ei ga idio toman ngan gid panua pakakanga ad. Toa eoa ga titangtang paeamao ga luod kek ga kek.” ");
INSERT INTO bch_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iesus ikeo pade bedane, “Ngan ado toaiua, madonga Deo ibageai ga iuot mambe ninipunga ga oaine ngan taine blalala sangaul. Bong ede eaba iuangga iuai pau ikeo ga inama ngan badanga iadaoa. Gid taine blalala sangaul tibada led lam ta tila tisanga ei edapeai, ngan badanga ei ga inam. ");
INSERT INTO bch_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Taine blalala lima lolod buobuo, be gid lima pade lolod iuatai. ");
INSERT INTO bch_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Gid toa lolod buobuo oa, tibada led lam ga tila sapaean, be aea bude mao. ");
INSERT INTO bch_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Be gid toa lolod iuatai, tiparere bude ngan eaupat, ta tibada ga inam toman ngan led lam. ");
INSERT INTO bch_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Be eaba toa iuangga iuai, inama manmanae mao, tota gid taine toa ngada oa matad iboboeo ta tidio tieno. ");
INSERT INTO bch_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Be bong irabu tilongo eaba ede ibaba bedane, ‘Ega, eaba iuangga iuai tota inama! Adae ta tala tagera ei ta tabada ei ga inam.’ ");
INSERT INTO bch_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Tota taine toa sangaul oa tidae ta tikado kemi led lam. ");
INSERT INTO bch_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Be gid lolod buobuo oa tikeo pagid lolod iuatai bedane, ‘Apan lemai bude kauteta. Lemai lam iuangga imate.’ ");
INSERT INTO bch_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Be gid lolod iuatai tikoli led posanga bedane, ‘Mao. Bude toa ne irangrang ngan gita busa mao. Gimi ala pagid panua oalo ad ta aol lemi.’ ");
INSERT INTO bch_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Io, gid toa lima oa tila ngan olnga led bude, be eaba toa iuangga iuai, ta inama. Tota gid toa led danga imata karanga motean, gid tila tidudunga lumaeai toman ngan ei ngan eaneannga oainga aea. Ta tisaisai atama. ");
INSERT INTO bch_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Be muriai, taine blalala padengada tinam ta tibaba bedane, ‘Maron, maron, repe atama ngan gai.’ ");
INSERT INTO bch_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Be ikoli led posanga bedane, ‘Nakeo tautaunga pagimi, gau naoatai ngan gimi mao.’” ");
INSERT INTO bch_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ta Iesus ikeo, “Tota agabit kemi. Ngansa gimi aoatai mao, ami Maron ga inama ngan ado isaoa ga ado imata pida.” ");
INSERT INTO bch_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iesus ikeo pade bedane, “Be muriai, kadonga ga iuot mambe ninipunga ga oaine ngan maron ede toa iuangga ila ngan tibur ede aluai. Mugaeai ngan ila, ibaba ele paeaeanga ga tinam, ta idol ele danga sisid ga idae bagedeai ta timariala ngan. ");
INSERT INTO bch_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ei imata nanan kadonga togid paeaeanga kelede kelede ga urad, ta ipota pat ga ila pagid. Paeaeanga ede ibada bunoringring lima, be ede pade ibada bunoringring rua, be ede pade ibada bunoringring kelede. Maron ipota bedaoa ga kus ta ila. ");
INSERT INTO bch_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ila ga kus ta paeaeanga toa ibada bunoringring lima, ei iboko ngan ta ibada pat bunoringring lima pade. ");
INSERT INTO bch_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Be paeaeanga toa ibada pat bunoringring rua, ei ikado toa bedaoa pade ta ibada pat bunoringring rua pade. ");
INSERT INTO bch_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Be paeaeanga toa ibada bunoringring kelede, ei ila ta ilei baba tanoeai ta imudan aea maron ele pat. ");
INSERT INTO bch_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Be mole tede ga kus ta ad maron iluai mulian ta ikeo ga ele paeaeanga tipalongo ei ngan pat toa mugaeai tibada. ");
INSERT INTO bch_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tota paeaeanga toa ibada bunoringring lima, ei ibada bunoringring lima pade ga inam ta ikeo, ‘Maron, mugaeai eao bada pat bunoringring lima pagau. Be ega, nakado naurata ngan, ta nabada pat bunoringring lima pade.’ ");
INSERT INTO bch_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ta aea maron ikeo pan bedane, ‘Kemi tau! Eao paeaeanga kemi ga matam tutui somisomi. Ngan ado toaiua eao mariala ngan danga sisid pidaede, eao pasolan mambe matam tutui. Tota labone nadol eao ta mariala ngan danga sisid busa. Nam dudunga ta tinim igelgel toman ngan gau.’ ");
INSERT INTO bch_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Idio ta paeaeanga toa ibada bunoringring rua, ei pade inam ta ikeo, ‘Maron, mugaeai eao bada pat bunoringring rua pagau. Be ega, nakado naurata ngan, ta nabada pat bunoringring rua pade.’ ");
INSERT INTO bch_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ta aea maron ikeo pan bedane, ‘Kemi tau! Eao paeaeanga kemi ga matam tutui somisomi. Ngan ado toaiua eao mariala ngan danga sisid pidaede, eao pasolan mambe matam tutui. Tota labone nadol eao ta mariala ngan danga sisid busa. Nam dudunga ta tinim igelgel toman ngan gau.’ ");
INSERT INTO bch_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Be paeaeanga toa ibada bunoringring kelede, ei pade inam ta ikeo, ‘Maron, gau naoatai mambe lem kadonga kulupulupu. Ngan tibur toa eao earum annga ngan mao, eao kulekule gid annga. Be ngan tano toa eao siran annga ipuapua ngan mao, eao suksuk gid annga. ");
INSERT INTO bch_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Tota namataud ta nala namudan lem pat tanoeai. Ega, lem pat tota eko.’ ");
INSERT INTO bch_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ta aea maron ikoli ele posanga bedane, ‘Eao paeaeanga paeamao ga malainga am! Eao keo ga oatai mambe nakulekule annga ngan tibur toa naearum mao, ga nababada annga ngan tano toa nasiran ipuapua ngan mao. Eine tautaunga? ");
INSERT INTO bch_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tota eao kamado dol leg pat ga idio ngan luma pat aea mao? Toa bedaoa ta oangga naluagau, eine ga nabada aea tlannga pade, be eine mao.’ ");
INSERT INTO bch_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","“‘Tota gimi abada pat bunoringring kelede ne ga ila pan eaba toa ele pat bunoringring sangaul. ");
INSERT INTO bch_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ngansa oangga sai ele danga sisid ienono, gau ga napan etangada pade ga ila pan ta ele danga sisid busa. Be oangga sai ele danga eta mao, saoa danga ei ikikisi, eine ga nabada mulian pan. ");
INSERT INTO bch_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Be paeaeanga paeamao toa ne, atado ei ga ila gaot, ngan tibur dodom. Toa eoa ga titangtang paeamao ga luod kek ga kek.’” ");
INSERT INTO bch_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iesus ikeo pade bedane, “Muriai oangga Eaba Inat iluai mulian, ei ga inam toman ngan ele taranga kapei ga ele anggelo busa. Ta ei ga idio imado ngan ele mul Maron aea kemi tau. ");
INSERT INTO bch_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Eine ga ipaluplup gid alu toa ngada ne ga tinam pan. Ta ei ga ipota gid ga tiuot iaoa rua, mambe eaba imariala ngan sipsip ipota ele sipsip ga tila iadag, ga meme tila iadag. ");
INSERT INTO bch_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ta ei ga idol gid sipsip ngan ibage oatai, be gid meme ngan ibage angas. ");
INSERT INTO bch_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ga kus ta Maron kapei ga ikeo pagid panua ngan ibage oatai bedane, ‘Gimi anam. Tamag ikado kemi tau ngan gimi! Mugaeai ngan danga toa ngada ne led otnga, ei isio gimi ngan badanga madonga kemi ei ibageai. Tota anam abada madonga kemi toa ne! ");
INSERT INTO bch_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngansa mugaeai pitoreagau, be gimi apan ag annga. Marumian gau, be gimi abada eau pagau. Gau eaba ngan tuanga ede pade, be gimi abada gau ga nala lemi lumaeai. ");
INSERT INTO bch_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Gau leg pononga eta mao, be gimi apan leg pononga. Gau ag dibala, be gimi anam akiakia gau. Gau namado ngan luma panasnga aea, be gimi anam agera gau.’ ");
INSERT INTO bch_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ta gid panua tututui ga tibeta ei bedane, ‘Maron, gai agera eao pitoreago ngeda, ta apan am annga? Be marumian go ngeda, ta abada eau pago? ");
INSERT INTO bch_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Be agera eao mambe eaba ngan tuanga ede pade ngeda, ta abada go ga la lemai lumaeai? Be gai agera mambe lem pononga mao, ta apan lem pononga ngeda? ");
INSERT INTO bch_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Be agera eao dibal ngeda, ga mado ngan luma panasnga aea ngeda, ta anama akia go?’ ");
INSERT INTO bch_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ta Maron kapei ga ikoli led posanga bedane, ‘Nakeo tautaunga pagimi, saoa danga akakado ngan gid panua toa edad mao ngan iaoa kelede togau, eine akado ngan gau.’ ");
INSERT INTO bch_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ga kus ta ei ga ikeo pagid panua ngan ibage angas bedane, ‘Gimi panua toa Deo ga ipanas gimi ne, ala aluai ngan gau! Ala ngan dinga imperno toa ianean somisomi ga ilalala ga ila. Dinga toa ne, Deo ikado ga iman tibur panasnga aea ngan eaba paeamao toman ngan ele anggelo. ");
INSERT INTO bch_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngansa mugaeai pitoreagau, be gimi apan ag annga mao. Marumian gau, be gimi abada eau pagau mao. ");
INSERT INTO bch_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Gau eaba ngan tuanga ede pade, be gimi abada gau ga nala lemi lumaeai mao. Gau leg pononga eta mao, be apan leg pononga mao. Gau ag dibala, ga namado ngan luma panasnga aea, be gimi anam akia gau mao.’ ");
INSERT INTO bch_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ta gid pade ga tikoli ele posanga bedane, ‘Maron, ngeda gai agera eao pitoreago, ga marumian go, ga eao eaba ngan tuanga ede pade, ga lem pononga mao, ga am dibala, ga mado ngan luma panasnga aea, be alua go mao?’ ");
INSERT INTO bch_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ta ei ga ikoli led posanga bedane, ‘Nakeo tautaunga pagimi, saoa danga akakado ngan gid panua toa edad mao ngan iaoa kelede togau mao, eina akado ngan gau mao pade.’ ");
INSERT INTO bch_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Tota gid ga tila ngan ad panasnga somisomi ga ilalala ga ila. Be gid panua tututui ga tila ngan madonga kemi somisomi ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iesus ipasala ele posanga toa ngada oa ga kus ta ikeo pagid ele aluagau bedane, ");
INSERT INTO bch_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Gimi aoatai, ado rua ga kus ta eaneannga Pasova aea ga iuot. Be gid panua ga tidol Eaba Inat ga idae pagid aea isat bagedeai, ta tipatoto ei ngan abei tabala.” ");
INSERT INTO bch_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Idio ta gid madidnga tenainga ad ga gid kapeipei togid Iuda tila tirou ngan luma kemi ton madidnga kapei tenainga aea ieda Kaiapas. ");
INSERT INTO bch_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Gid tiraurau posanga ngan edap eta ngan pakakanga Iesus ta irangrang ngan tiluku ei ta tirau ei ga imate. ");
INSERT INTO bch_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Be gid tikeo, “Irangrang ngan takado bedane rabu ngan eaneannga toa ne mao. Ngan kado gid ipom tigera ta tiparau.” ");
INSERT INTO bch_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Idio ta Iesus imamado ngan tuanga Betani ngan luma ton eaba ede ieda Saimon. Mugaeai eaba toa oa aea dibala kankan. ");
INSERT INTO bch_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Iesus imamado ga ianean, be taine ede inam ibada ele botol pat, aea bude iuad kemi ienono ngan. Bude toa oa aea olnga kapei tau, be itok ga idae Iesus ilaborai. ");
INSERT INTO bch_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Be ele aluagau tigera ta lolod bake ta tikeo, “Ikamado ga itok bude toa ne ga kus sapaean? ");
INSERT INTO bch_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kemi ngan ilongean pagid panua ta tiuol, ta ibada pat kapei. Toa bedaoa ta ilualua gid panua lululunga ad. Be tota mao ne.” ");
INSERT INTO bch_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Be Iesus iuatai ngan led posanga ta ikeo, “Ikamado ga akado kulupu ngan taine toa ne? Ei ikado kadonga kemi tau ngan gau. ");
INSERT INTO bch_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ngansa gid panua lululunga ad timamado pagimi somisomi, be gau namamado pagimi somisomi mao. ");
INSERT INTO bch_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ei itok bude toa ne ga idae ngan gau, be ngan kadonga toa ne ipasogo gau motean, ngan muriai nala dengaeai. ");
INSERT INTO bch_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nakeo tautaunga pagimi, muriai gid panua ga tila tipaola leg ato kemi ngan tibur toa ngada ne tanoeai, be eine ga tininipu pade ngan taine toa ne ele kadonga, ta panua ga matad nanan ei.” ");
INSERT INTO bch_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Idio ta eaba tiuato ei Iudas Iskariot, toa ede ngan gid aluagau sangaul igegea rua, ei ila pagid madidnga tenainga ad ");
INSERT INTO bch_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ta ibeta gid bedane, “Oangga nadol ei ga idae bagemiai, eine ga abada saoa pagau?” Ta tibada pat silva sangaul tol ga ila pan. ");
INSERT INTO bch_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tota ngan ado toaiua ga ila, ei isangasanga ado eta kemi ngan dolnga Iesus ga idae bagedeai. ");
INSERT INTO bch_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ngan ado toa imuga ngan eaneannga ngan Bret aea Yis Ienono ngan Mao, Iesus ele aluagau tila pan ta tibeta ei bedane, “Eao kim gai ala sida ta akado annga Pasova aea ta taean?” ");
INSERT INTO bch_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ta ikeo, “Gimi ala tuangai pan eaba ede, ta akeo pan bedane, ‘Eaba Paoatainga aea ikeo ga ele ado imata ta boloma ne. Tota iuangga inam lem lumaeai ta ikado eaneannga Pasova aea toman ngan ele aluagau.’” ");
INSERT INTO bch_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Io, ele aluagau tila tikado mambe Iesus irenren pagid ngan, ta tikado annga Pasova aea. ");
INSERT INTO bch_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ado idil ngan lailai toaiua, ta Iesus imamado popouiai toman ngan ele aluagau sangaul igegea rua. ");
INSERT INTO bch_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Gid tianean, be ikeo pagid bedane, “Nakeo tautaunga pagimi, eaba ede ngan gimi ga idol gau pagid ag isat bagedeai.” ");
INSERT INTO bch_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Tilongo bedaoa ta lolod isat kapei, ta gid kelede kelede tibeta ei bedane, “Maron, eine gau mao, na?” ");
INSERT INTO bch_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Be ikoli led posanga bedane, “Eine eaba toa ga idol ibage ga idudunga ngan lalate toman ngan gau. Eaba tota nena ga idol gau pagid ag isat bagedeai. ");
INSERT INTO bch_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tautaunga, Eaba Inat ga inasi edap mambe Deo ele laulau ikeo ngan ei, be paeamao tau ngan eaba toa idol Eaba Inat ga idae pagid aea isat bagedeai! Kemi ngan eaba toa oa oangga itna ipopo ei mao.” ");
INSERT INTO bch_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Be Iudas, eaba toa ga idol ei pagid aea isat bagedeai, ikeo bedane, “Eaba paoatainga am, eine gau mao, na?” Be Iesus ikeo, “Eine eao keo toa bedaoa.” ");
INSERT INTO bch_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Idio ta Iesus asingada ele aluagau tianean, be ei ibada bret ta iposa kemi pan Deo. Ga kus ta itei ta ibada ga ila pagid aluagau ta ikeo, “Gimi abada ta aean. Eine gau medamedag.” ");
INSERT INTO bch_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ga kus ta ibada loba ta iposa kemi pan Deo ta ibada pagid. Ta ikeo, “Gimi toa ngada ne aun. ");
INSERT INTO bch_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Eine gau singig. Singig toa ne iparangrang posanga toa Deo irau ngan ele panua. Eine itoki ngan samumnga kadonga sasat. ");
INSERT INTO bch_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nakeo pagimi, gau ga naun oain isul pade mao ga ila irangrang ngan ado toaiua tamado kemi Tamag ibageai. Toa eoa ga naun oain pau toman ngan gimi.” ");
INSERT INTO bch_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Idio ta tibau baunga ede ngan Deo, ga kus ta tiuot ga tila ngan bereo Oliv. ");
INSERT INTO bch_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Idio ta Iesus ikeo pagid, “Labone bong, gimi ga agera kadonga iuot ngan gau, ta gimi toa ngada ne lemi kadonga lolo matua aea ga itap. Ngansa Deo ele laulau aea posanga bedane, “‘Gau ga narau eaba imariala ngan sipsip, ta gid sipsip ga tibilin alele.’ ");
INSERT INTO bch_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Be muriai gau ga nadae mulian ngan matenga ta namuga ngan gimi ga nala Galili.” ");
INSERT INTO bch_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Be Petrus ikeo pan bedane, “Goibe, gid toa ngada ne ga tigera kadonga iuot ngan eao ta led kadonga lolo matua aea ga itap, be irangrang ngan gau leg kadonga lolo matua aea itap mao.” ");
INSERT INTO bch_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Iesus ikeo pan bedane, “Nakeo tautaunga pago, labone bong kokako ga itang maitne, be eao ga paisiamo patol ngan oatai gau mao.” ");
INSERT INTO bch_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Be Petrus ikeo, “Goibe, gau ga namate toman ngan eao, be irangrang ngan napaisiamo bedaoa ngan eao mao ga mao tau.” Ta gid aluagau padengada tiposa lalaede toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Idio ta Iesus toman ngan ele aluagau tila ngan tibur ede tiuato Getsemani. Ta ikeo pagid aluagau, “Gimi adio amado nene, be gau nala eoa ta nararing.” ");
INSERT INTO bch_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Io, ibada Petrus ga Sebedi inat rua ga tila toman ngan ei, be ilolo isat kapei ta inaman kemi mao. ");
INSERT INTO bch_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ta ikeo pagid, “Gau lolog isat kapei tau, ta naoangga namate. Gimi adio nene, be matami arar toman ngan gau.” ");
INSERT INTO bch_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Idio ta ila kautede pade ta idol ilabora ga isulug tanoeai ta iraring bedane, “Apa, oangga eao longo, bada loba ieieinga aea toa ne ga ila aluai ngan gau. Be nasi gau lingeg mao, nasi eao lingem.” ");
INSERT INTO bch_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ga kus ta iluai mulian pagid ele aluagau, ta igera tienono. Ta ikeo pan Petrus bedane, “Madongan? Gimi arangrang ngan matami arar toman ngan gau irangrang ngan ado imata keleta mao? ");
INSERT INTO bch_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Matami arar ga araring ta irangrang ngan atap ngan tobanga mao. Ngansa lolomi ikim inasi Deo, be tinimi iura mao.” ");
INSERT INTO bch_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Idio ta ila iraring toa bedaoa pade ta ikeo, “Apa, nakim loba ieieinga aea toa ne ila aluai ngan gau. Be oangga edap eta pade mao, ta eao keo ga manta naun, goibe kado mambe eao kim.” ");
INSERT INTO bch_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ga kus ta iluai mulian pade, ta igera tienono maitne, ngansa matad iboboeo. ");
INSERT INTO bch_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ta itnan gid pade ta ila iraring lalaede toa bedaoa patol aea. ");
INSERT INTO bch_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ga kus ta iluai mulian pagid aluagau ta ikeo, “Gimi aearagimi ga aenono maitne? Ega, ado imata tota iuot ne. Eine ga tidol Eaba Inat ga idae pagid panua papaeamao bagedeai. ");
INSERT INTO bch_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Adae ta tala. Ega, eaba toa iuangga idol gau pagid panua papaeamao bagedeai, tota inam boloma ne.” ");
INSERT INTO bch_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iesus iposaposa maitne, be mole mao Iudas, aluagau ede ngan gid sangaul igegea rua, inama iuot toman ngan ipom kapei. Gid madidnga tenainga ad ga gid kapeipei togid Iuda tisula gid ga tila be tikikisi didi ga kaip. ");
INSERT INTO bch_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Be eaba toa iuangga idol Iesus ga idae bagedeai, ikeo pagid motean ngan kilala ede iuangga ikado. Ta ikeo, “Oangga nabusum eaba ede ipapa, eaba toa oa eine Iesus. Gimi aluku ei.” ");
INSERT INTO bch_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Be mole mao ila pan Iesus ta ikeo, “Bong kemi, eaba paoatainga am.” Ta ibusum ipapa. ");
INSERT INTO bch_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ta Iesus ikeo, “Leg eaba, danga eao nama ngan, kado manmanae.” Tota tila pan Iesus ta tidol baged ga idae ngan ei ta tiluku ei. ");
INSERT INTO bch_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Be mole mao, Iesus ele aluagau ede inusi ele didi ga iuot ta irau ngan paeaeanga ton madidnga kapei tenainga aea ta iket itanga ga put. ");
INSERT INTO bch_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Be Iesus ikeo, “Dol lem didi ga iluai mulian aea lumaeai! Ngansa oangga sai iparau ngan didi, eine ga tipaeabu ngan ei pade ngan didi. ");
INSERT INTO bch_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Be gau narangrang ngan nababa ga ila pan Tamag ta isula ele anggelo bunoringring sangaul bunoringring rua (12,000) ta tinam tilua gau. Be eao oatai mao? ");
INSERT INTO bch_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Be oangga nakado bedaoa, irangrang ngan Deo ele laulau aea posanga iuot tautaunga mao. Ngansa ele laulau ikeo ga gid danga manta iuot toa bedane.” ");
INSERT INTO bch_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ngan ado imata toaiua, Iesus ikeo pagid ipom bedane, “Gimi abada didi ga kaip ta anama ngan lukunga gau mambe aluku eaba ede lublubnga aea? Ado ga ado namamado gadudunga ngan Deo ele luma aea ala ga napapaoatai gid ipom, be gimi aluku gau mao. ");
INSERT INTO bch_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Be danga toa ngada ne iuot ta iparangrang Deo ele posanga mambe gid panua tibada iaoa tibode mugaeai.” Tota ele aluagau toa ngada oa titnan ei ta tiaoa alele. ");
INSERT INTO bch_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Gid panua toa tiluku Iesus tibada ei ga ila pan madidnga kapei tenainga aea ieda Kaiapas. Gid madidnga apu ad ga gid kapeipei togid Iuda tiluplup toa eoa. ");
INSERT INTO bch_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrus inasi ei ga ila, be idio aluai tede ga ila irangrang ngan madidnga kapei tenainga aea ele luma aea ala. Ei idudunga ngan ala toa oa ta ila imado toman ngan gid nakala ton madidnga kapei, be iuangga igera saoa kadonga ga iuot ngan Iesus. ");
INSERT INTO bch_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Be gid madidnga tenainga ad ga gid madidnga patutuinga posanga ad padengada tiloilo panua edengada ngan tiuaoa ngan posanga pakakanga ngan Iesus, ta irangrang ngan tiuot ngan ipu eta ngan raunga ei ga imate. ");
INSERT INTO bch_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Ta panua busa tinam ta tisol ei ngan posanga pakakanga, be tiuot ngan ele idil eta ngan pamatenga ei mao. Be panua rua tinam muriai ");
INSERT INTO bch_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ta tikeo bedane, “Eaba toa ne ikeo ga irangrang ngan irepe Deo ele luma, ta ipagun mulian ngan ado tol.” ");
INSERT INTO bch_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Tota madidnga kapei tenainga aea imadid ta ibeta Iesus bedane, “Eao kado posanga eta mao? Posanga toa tisol go ngan ne madongan?” ");
INSERT INTO bch_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Be Iesus mumun ga imadmadid. Ta madidnga kapei tenainga aea ikeo pan bedane, “Ngan Deo toa imamado somisomi ne ieda, eao posa tautaunga pagai, eao Kristus, Deo Inat?” ");
INSERT INTO bch_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ta Iesus ikeo, “Eine mambe eao keo. Be gau nakeo pagimi, muriai gimi ga agera Eaba Inat imado ngan Deo toa iura kapei tau ibage oatai, ta ei ga isulug ga inam ngan gid laulau mariambai.” ");
INSERT INTO bch_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Io, madidnga kapei tenainga aea ilongo bedaoa ta itaka ele pononga mulian ta ikeo, “Eaba ne iuangga ibada Deo imul! Gita leda ipu eta ngan ilonga panua padengada ngan solnga eaba toa ne mao. Patautene talongo ipaeabu ngan Deo ieda. ");
INSERT INTO bch_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Gimi aoangga takado mado ngan ei?” Ta tikeo, “Ei ele idil paeamao. Manta imate.” ");
INSERT INTO bch_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Tota tiplapla imata ga tiraurau ei. Be padengada tipodapoda ei ");
INSERT INTO bch_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ta tikeo, “Eao Kristus na? Oangga eao bada Deo iaoa tautaunga, keo pagai toa patautene, sai ga sai tirau go?” ");
INSERT INTO bch_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Be Petrus imamado gadudunga ngan ala ton madidnga kapei tenainga aea, be taine paeaeanga ede ila boloma pan ta ikeo, “Eao pade mamado toman ngan Iesus Galili aea.” ");
INSERT INTO bch_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Be ei ipaisiamo panua busa matadeai ta ikeo, “Mao. Gau naoatai ngan danga toa eao posaposa ngan ne mao.” ");
INSERT INTO bch_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ta ila boloma ngan ala iaoa, ta taine ede pade igera ei ta ikeo pagid panua toa timadid boloma bedane, “Eaba toa ne imamado toman ngan Iesus Nasaret aea.” ");
INSERT INTO bch_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Be ei ipaisiamo pade ta ikeo, “Tautaunga gadae, gau naoatai ngan eaba toa ne mao.” ");
INSERT INTO bch_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Idio ta gid panua toa timadid boloma oa tila pan Petrus ta tikeo, “Tautaunga, eao eaba ede ngan gid. Lingem ipasolan go mulian. Ngansa am gagal mambe gid Galili.” ");
INSERT INTO bch_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Be iposa tautaunga gadae ta ikeo, “Gau naoatai ngan eaba toa oa mao. Oangga napakaka, goibe Deo ga ipaeabu ngan gau.” Be mole mao kokako itang. ");
INSERT INTO bch_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Tota Petrus imata nanan Iesus ele posanga pan bedane, “Kokako ga itang maitne, be eao ga paisiamo patol ngan oatai gau mao.” Tota iuot ga ila gaot ta itang paeamao tau. ");
INSERT INTO bch_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Gaisala rumaruma ngan ado sae, gid madidnga tenainga ad ga gid kapeipei togid Iuda tirau posanga ngan pamatenga Iesus. ");
INSERT INTO bch_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Tota tikaukau ei ta tibada ei ga ila pan Pailat, gavana ngan tibur toa oa. ");
INSERT INTO bch_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Be Iudas, eaba toa idol Iesus ga idae pagid aea isat bagedeai, igera mambe tirau posanga ngan pamatenga ei, ta ipul ilolo. Ei ibada pat silva sangaul tol toa oa ga iluai mulian pagid madidnga tenainga ad ga gid kapeipei togid Iuda. ");
INSERT INTO bch_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ta ikeo, “Gau nakado kadonga sat ngan dolnga ei ga idae bagemiai. Ngansa ele idil eta paeamao mao, be gimi ga arau ei ga imate.” Be gid tikeo, “Eine gai lemai danga eta mao. Eine eao lem danga.” ");
INSERT INTO bch_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Tota itado pat toa oa ga idio Deo ele lumaeai, ta itnan gid ta ila ikon igagal ga imate. ");
INSERT INTO bch_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Be gid madidnga tenainga ad tibada pat toa oa ta tikeo, “Oangga tadol pat toa ne toman ngan gid tenainga toa Deo ele lumaeai, eine tutui mao. Ngansa eine olnga ngan raunga eaba ga imate.” ");
INSERT INTO bch_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tota tirau posanga ngan pat toa oa ta tiuol ngan tano ede ton eaba ikakado ulo. Ta tano toa oa iman denga togid panua ngan gid tuanga aluai. ");
INSERT INTO bch_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tota tiuato tano toa oa, “Tano Sing aea.” Be panua tiuatoato ieda toa bedaoa ga irangrang ngan labone pade. ");
INSERT INTO bch_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Kadonga toa oa iparangrang Deo ele posanga ede. Ieremaia ibada Deo iaoa mugaeai ta ikeo ga bedane, “Eaba toa oa, gid panua tiuol ei ngan pat silva sangaul tol ga iman led. Eine gid Israel tirau posanga ngan aea olnga iuot toa bedaoa. Be gid panua tibada pat toa oa ");
INSERT INTO bch_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ga ila pan eaba ikakado ulo ngan olnga aea tano idanga tede. Kadonga toa oa iuot mambe Maron irenren pagau ngan.” ");
INSERT INTO bch_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Idio ta Iesus imadid gavana imatai, ta gavana ibeta ei bedane, “Eao maron kapei togid Iuda na?” Ta Iesus ikeo, “Eine mambe eao keo.” ");
INSERT INTO bch_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ta gid madidnga tenainga ad ga gid kapeipei togid Iuda tisol ei ngan posanga busa. Be ei iposa eta mao. ");
INSERT INTO bch_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ga kus ta Pailat ibeta ei bedane, “Gid tisol go ngan posanga busa, be eao longo mao?” ");
INSERT INTO bch_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Be Iesus ikoli posanga eta mao. Ta gavana imatala kapei. ");
INSERT INTO bch_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Be rai ga rai ngan ado Pasova aea, gavana inasnasi ipom linged ta ilongean eaba kelede ta itnan luma panasnga aea. ");
INSERT INTO bch_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Be ngan ado toaiua, eaba ede ieda Barabas imamado ngan luma panasnga aea. Ei eaba paeamao ede ta iualu kapei. ");
INSERT INTO bch_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Io, gid ipom tiluplup, ta Pailat ibeta gid bedane, “Gimi akim nalongean sai ga ila pagimi? Akim Barabas, mao akim Iesus toa tiuato ei Kristus?” ");
INSERT INTO bch_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ibeta gid ipom bedaoa ngansa iuatai mambe gid lolod paeamao sapaean ngan Iesus ta tiluku ei ga ila pan. ");
INSERT INTO bch_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ta Pailat imamado ngan mul patutuinga posanga aea, be iadaoa ipaoen posanga ga ila pan bedane, “Eao kado kadonga eta ngan eaba tutui toa na mao. Ngansa made bong nagera ei ngan anunug, be nanaman paeamao lologeai.” ");
INSERT INTO bch_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Be gid madidnga tenainga ad ga gid kapeipei togid Iuda tidada gid ipom ngan posanga ta tibeta ei ngan ilongean Barabas ga ila pagid be irau Iesus ga imate. ");
INSERT INTO bch_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ta gavana ibeta gid pade bedane, “Gimi akim nalongean sai ngan gisirua ta ila pagimi?” Ta tikeo, “Barabas!” ");
INSERT INTO bch_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ta Pailat ibeta gid, “Tota akim nakado mado ngan Iesus toa tiuato ei Kristus?” Ta gid toa busa oa tingangar bedane, “Patoto ei ngan abei tabala!” ");
INSERT INTO bch_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ta Pailat ibeta gid, “Ngan saoa? Ele kadonga isaoa paeamao?” Be tingangar kapei pade bedane, “Patoto ei ngan abei tabala!” ");
INSERT INTO bch_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Io, Pailat igera mambe tilongo ele posanga eta mao, be tiuangga tikado paraunga. Tota ibada eau ta isigiri ibage ipom matadeai ta ikeo, “Eine gau leg idil eta paeamao ngan eaba toa ne aea pamatenga mao. Eine gimi lemi idil paeamao.” ");
INSERT INTO bch_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ta gid panua toa ngada oa tikoli ele posanga bedane, “Goibe, aea pamatenga eine idil paeamao togai ga lemai gergeu.” ");
INSERT INTO bch_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Tota ilongean Barabas ga ila pagid, be idol Iesus ga idae pagid panua paraunga ad bagedeai. Ta ikeo ga timuimui ei ga kus ta tipatoto ei ngan abei tabala. ");
INSERT INTO bch_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Idio ta gavana ele panua paraunga ad tibada Iesus ga ila ngan luma gavman aea. Ta gid panua paraunga ad toa busa oa tiluplup Iesus imatai. ");
INSERT INTO bch_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Gid titil pononga ngan ei ta tidol pononga singsingia ngan itin mambe pononga togid mamaron kapeipei. ");
INSERT INTO bch_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ga kus ta tibada oaroaro aea gigi ta tikado mambe nakala togid mamaron kapeipei ta tidol ga idae ilaborai. Be tidol piso matua ede ngan ibage oatai, ta tigalinge ngan ei. Be tikor aed boloma pan ta tikeo, “Ado kemi, maron kapei togid Iuda!” ");
INSERT INTO bch_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Gid tiplapla ei ga tibada piso toa oa ta tiraurau ngan ilabora. ");
INSERT INTO bch_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Tigalinge ngan ei toa bedaoa ga kus ta titil pononga singsingia ngan ei, ta tidol ele pononga mulian. Ta tibada ei ga ila ngan patotonga ei ngan abei tabala. ");
INSERT INTO bch_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Idio ta tilalala ga tila, be gid panua paraunga ad tigera eaba ede Sairini aea ieda Saimon. Gid tiparpar ngan ei ta ibisi Iesus aea abei tabala. ");
INSERT INTO bch_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tota tiuot ngan tibur toa tiuato Golgota. Edaeda toa ne ipu eine Tibur Laborada Ituatua aea. ");
INSERT INTO bch_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Toa eoa tibada oain pan Iesus, be tibul toman ngan sul ede ipaipai. Ei itoba, be itin ngan aea unnga mao. ");
INSERT INTO bch_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Tipatoto ei ngan abei tabala ga kus ta tipota ele danga sisid pol ngan gid, be titado danga ede iman salisalinga ngan sionga sai ga sai ga tibada. ");
INSERT INTO bch_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ta tidio timamado be timariala ngan ei. ");
INSERT INTO bch_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Be gadae ngan ilabora, tibode posanga toa tisol ei ngan bedane, “Eine Iesus, maron kapei togid Iuda.” ");
INSERT INTO bch_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Be boloma ngan Iesus, tipatoto panua rua lublubnga ad ngan abei tabala pade, ede ngan ibage oatai, be ede pade ngan ibage angas. ");
INSERT INTO bch_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Be gid panua toa tila ga tinam, tiposa paeamao ngan ei ga laborad itambolembole ");
INSERT INTO bch_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ta tikeo, “Eao oangga repe Deo ele luma ta pagun mulian ngan ado tol? Oangga eao Deo Inat, lua eao mulian ta tnan abei tabala ga sulug!” ");
INSERT INTO bch_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Be gid madidnga tenainga ad ga apu ad ga gid kapeipei togid Iuda, aoad ibiu ei toa bedaoa pade ta tikeo, ");
INSERT INTO bch_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ei ilualua panua padengada, be irangrang ngan ilua ei mulian mao. Be ei maron kapei Israel aea! Kemi ngan itnan abei tabala ga isulug. Toa bedaoa ga loloda matua ngan ei. ");
INSERT INTO bch_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ei ikeo ga ilolo matua ngan Deo. Ta oangga Deo ikim ei, kemi ngan ibada ei mulian. Ngansa ikeo ngan ei mulian bedane, ‘Gau Deo Inat.’” ");
INSERT INTO bch_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Be panua rua lublubnga ad toa tipatoto gid ngan abei tabala boloma ngan Iesus, gid pade tiposa paeamao ngan ei toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Be tutui ngan arobad, tibur toa ngada oa iuot dodom ga irangrang ngan lailai toaiua ngan ado imata tol. ");
INSERT INTO bch_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Be boloma ngan ado imata tol, Iesus ingangar kapei bedane, “Eli, Eli, lama sabaktani.” Posanga toa ne ipu bedane, “Ag Deo, ag Deo, eao pul murim ngan gau ngan saoa?” ");
INSERT INTO bch_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Be panua edengada toa timadid boloma oa tilongo posanga toa oa ta tikeo, “Ei ta ibaba Elaija!” ");
INSERT INTO bch_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ta manmanae eaba ede ngan gid ilado ga ila ibada asile tad aea ta ilolo ngan oain isul meleoleonga. Ga kus ta iaud ngan piso imata ta iuangga ipaun ei ngan. ");
INSERT INTO bch_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Be gid padengada tikeo, “Kado ei mao. Tadio ge ta tagera. Elaija ga inama tautaunga ngan badanga ei mulian, mao mao?” ");
INSERT INTO bch_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Idio ta Iesus ingangar kapei pade ta itautau itnan ei ga ila be imate. ");
INSERT INTO bch_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Be tutui ngan ado imata toaiua, malo kapitnami toa itututu Deo ele luma iloleai oa, itakai pan gadae ga isulug ta iuot rua. Be nauruge kapei inuga tano ta gid pat kapeipei timapoga. ");
INSERT INTO bch_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Be gid denga aoad ipokakai, ta panua tututui busa toa timate mugaeai tota tidae mulian. ");
INSERT INTO bch_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Gid titnan denga, be muriai ngan Iesus ele daenga mulian, tidudunga tuanga iloleai ta panua busa tigera gid. ");
INSERT INTO bch_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Be madidnga paraunga aea ga ele panua paraunga ad toa timariala ngan Iesus, tigera tano inogoi ga gid danga padengada iuot toa bedaoa, ta timataud kapei ta tikeo, “Tautaunga, eaba toa ne, ei Deo Inat!” ");
INSERT INTO bch_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Be taine busa timadmadid aluai tede ga timamaran ele matenga. Gid tinasnasi Iesus Galili ga tinam, be tilualua ei. ");
INSERT INTO bch_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ede ngan gid, eine Maria Makdala aea, be ede pade eine Maria toa Jems ga Iosep tnad, be ede pade eine Sebedi iadaoa. ");
INSERT INTO bch_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ado iuangga idil ngan lailai toaiua, be eaba ede tuanga Arimatea aea inam, ieda Iosep. Ele danga sisid busa, be ei pade iman aluagau ede ton Iesus. ");
INSERT INTO bch_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ei ila pan Pailat ta ibeta ei ngan ilongean Iesus ipat ta ibada. Io, Pailat ilongo ta ikeo pagid panua paraunga ad ta tibada Iesus ipat ga ila pan. ");
INSERT INTO bch_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Iosep ibada Iesus ipat ta imol ei ngan malo bodbode toa aea muk eta mao. ");
INSERT INTO bch_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ga kus ta idol ngan denga pau ede ei ton. Denga toa oa eine Iosep ipir pat kapei ede ta ikado aea baba. Tota ipul pat kapei ede ta ipakala denga iaoa ngan, ga kus ta ila. ");
INSERT INTO bch_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Be Maria Makdala aea ga Maria toa ede pade oa timamado boloma, iadag ngan denga iaoa. ");
INSERT INTO bch_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ado toaiua eine Ado Koromotnga aea toa imuga ngan Ado Earainga aea. Be ngan ado sae gid madidnga tenainga ad ga gid Parisi tiluplup ga tila pan Pailat ");
INSERT INTO bch_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ta tikeo bedane, “Eaba kapei, gai matamai nanan posanga ede toa eaba pakakanga aea oa ikado ngan ei imata eababa maitne. Ikeo, ‘Muriai ngan ado tol, eine ga nadae mulian.’ ");
INSERT INTO bch_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Tota eao manta keo pagid panua paraunga ad ta timariala kemi ngan denga ga irangrang ngan ado tol aea. Ngan kado ta ele aluagau tila tipaeaoa ipat ta tikeo pagid ipom bedane, ‘Ei idae mulian ngan matenga.’ Toa bedaoa ga posanga pakakanga pau toa ne iasal posanga pakakanga toa ei ikakado mugaeai.” ");
INSERT INTO bch_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ta Pailat ikeo pagid, “Gid panua paraunga ad tidio bagemiai. Ala adol gid ta timariala kemi ngan denga, mambe gimi akeo ngan.” ");
INSERT INTO bch_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Tota tila tipakala denga iaoa ta tidol kararanga ede ngan pat kapei toa oa. Ta tidol gid panua paraunga ad ta tidio timariala ngan. ");
INSERT INTO bch_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gaisala rumaruma ngan ado toa inasi Ado Earainga aea, Maria Makdala aea ga Maria ede pade tisogou ga tila ngan geranga Iesus aea denga. ");
INSERT INTO bch_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Be mole mao, nauruge kapei inuga tano. Ngansa anggelo ton Maron isulug buburiai ga inam ta ila ipul pat kapei denga iaoai ta idae imado ngan. ");
INSERT INTO bch_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Anggelo toa oa imata mil ga mil mambe gla isamil, be ele pononga bodbode tau mambe laulau bodbode mariambai. ");
INSERT INTO bch_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Gid panua paraunga ad toa timariala ngan denga oa timataud kapei ga tisamimi, be titap ga tisulug mambe panua timate. ");
INSERT INTO bch_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Be anggelo ikeo pagid taine bedane, “Amataud mao. Gau naoatai, gimi anam ngan ilonga Iesus, eaba toa tipatoto ei ngan abei tabala. ");
INSERT INTO bch_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Be ei nene mao. Idae mulian o! Eine mambe ikeo pagimi ngan mugaeai. Anama agera imul. ");
INSERT INTO bch_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Be ala manmanae ta apalongo ele aluagau bedane, ‘Ei idae mulian ngan matenga! Be ega, ei ga imuga ngan gimi ta ila Galili. Ta gimi ga agera ei toa eoa.’ Ega, napalongo gimi na.” ");
INSERT INTO bch_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Io, gid taine titnan denga manmanae be timataud kapei ga tinid igelgel. Gid tilado ga tila ngan palongonga ele aluagau. ");
INSERT INTO bch_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Be mole mao Iesus iuot pagid edapeai ta ikeo, “Gaisala kemi.” Be gid tila boloma pan ta tikisi iaepu ga tisoa ieda. ");
INSERT INTO bch_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ta Iesus ikeo pagid, “Amataud mao. Be ala apalongo oaeoaeg ta tila Galili. Ta gid ga tigera gau toa eoa.” ");
INSERT INTO bch_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Gid taine tilado ga tila, be mole mao gid panua paraunga ad idanga ede tila tuangai ta tipalongo gid madidnga tenainga ad ngan danga toa ngada oa iuot. ");
INSERT INTO bch_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Gid tiluplup toman ngan gid kapeipei togid Iuda ta tirau posanga ede. Ta tibada pat silva kapei tede ga ila pagid panua paraunga ad ");
INSERT INTO bch_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ta tikeo, “Oangga sapadua tibeta gimi, manta akeo bedane, ‘Ele aluagau tinam bong ta tipaeaoa ipat, be gai aenono.’ ");
INSERT INTO bch_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Be oangga gavana ilongo posanga toa ne, eine gai ga apatarui posanga ga ila pan, ta kadonga kulupu eta ga iuot ngan gimi mao.” ");
INSERT INTO bch_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Idio ta gid panua paraunga ad tibada pat toa oa ta tila tikado mambe gid madidnga tikeo pagid ngan. Tota posanga toa ne iuasasa alele pagid Iuda ga irangrang ngan labone. ");
INSERT INTO bch_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Idio ta gid aluagau sangaul ga igegea ede tila Galili ngan lusi toa Iesus ikeo pagid ngan. ");
INSERT INTO bch_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gid tigera ei ta tisoa ieda, be edengada lolod ruangada. ");
INSERT INTO bch_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Be Iesus ila boloma ta ikeo pagid bedane, “Deo idol danga toa ngada ne buburiai ga tanoeai ga idae gau bagegeai. ");
INSERT INTO bch_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tota gimi ala ta akado ga gid alu toa ngada ne lolod matua ga tinasnasi gau. Be apaliliu gid ngan Tamada ieda ga Inat ga Itautau Tutui. ");
INSERT INTO bch_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Be leg posanga toa ngada ne nababada pagimi, apaoatai gid ngan ta tinasnasi pade. Be ega, gau namamado toman ngan gimi toa somisomi ne ga irangrang ngan madonga tanoeai kus.” ");
INSERT INTO bch_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ato kemi ton Iesus Kristus, Deo Inat, iuot mugaeai ga bedane: ");
INSERT INTO bch_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aisaia ibada Deo iaoa ta ibode ga bedane, “Ega, gau ga nasula leg eaba ato aea ta ila imuga ngan eao. Ta ei ga isaoa edap ngan lem namanga.” ");
INSERT INTO bch_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Eaba ede ipotalae ngan tibur modamodanga bedane, ‘Asaoa Maron ele edap ga apatutui kemi!’” ");
INSERT INTO bch_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Tota Ioanes Paliliunga aea ila ngan tibur modamodanga, ta ipaola posanga pagid ipom ngan gid manta tipul lolod ga tibada paliliunga, ta Deo isamum led kadonga sasat. ");
INSERT INTO bch_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gid panua busa ngan tibur Iudea ga tuanga Ierusalem tila pan Ioanes ta tiuaoa ngan led kadonga sasat, ta Ioanes ipaliliu gid ngan eau Iordan. ");
INSERT INTO bch_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Be Ioanes ipit malo tikado ngan kamel ilaun ta ikaukau irabu ngan aea pus tikado ngan bulmakao itin kukul. Ianean gurisi ga iunun bon isul tibur aea. ");
INSERT INTO bch_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ei ipaola posanga bedane, “Eaba ede ga inam muriai ngan gau, ei iura kapei ngan gau. Ei iasal gau tau, ta irangrang ngan namouru ngan luanga ei ngan ele su aea polanga mao. ");
INSERT INTO bch_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Gau napaliliu gimi ngan eau, be ei ga ipaliliu gimi ngan Itautau Tutui.” ");
INSERT INTO bch_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Idio ta ngan ado toaiua, Iesus itnan tuanga Nasaret ngan tibur Galili ta ila ngan eau Iordan, ta Ioanes ipaliliu ei. ");
INSERT INTO bch_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ei itnan eau ga idae, be mole mao igera bubur ipokakai ta Itautau Tutui isulug ga inam pan mambe man barur. ");
INSERT INTO bch_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Be babanga ede isulug buburiai ga inam ta ikeo, “Eao gau Natug. Gau nakim go tau. Tinig igelgel ngan eao.” ");
INSERT INTO bch_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Be mole mao, Itautau Tutui isula Iesus ta ila ngan tibur modamodanga. ");
INSERT INTO bch_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ei idio ngan tibur toa oa aea ado sangaul pange, be Satan itobatoba ei. Ei imamado toman ngan gid masilau saksak, be gid anggelo tinam tilua ei. ");
INSERT INTO bch_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Be muriai ngan tidol Ioanes ngan luma panasnga aea, Iesus ila ngan gid tuanga Galili ta ipaola Deo ele ato kemi. ");
INSERT INTO bch_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ta ikeo, “Ado toa Deo isio ne tota inama. Madonga Deo ibageai ta iuot. Tota gimi manta apul lolomi ta lolomi matua ngan ele ato kemi!” ");
INSERT INTO bch_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Idio ta Iesus ipapaele labiai ngan liu kapei Galili, ta igera Saimon ga itar kakau Andreas titatado puo liuiai, ngansa gisirua tibabada ia iman led pat aea. ");
INSERT INTO bch_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ta Iesus ikeo pagisirua, “Gimirua anam anasi gau, ta gau ga napaoatai gimi ngan badanga panua ga tinam pagau, mambe labone ababada ia.” ");
INSERT INTO bch_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Mole mao, gisirua titnan led puo ga idio, ta tila tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Idio ta ilalala pade ta igera Jems toa Sebedi ele gergeu ga itar kakau Ioanes. Gisirua pade timamado oagaeai ta tiaman led puo. ");
INSERT INTO bch_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mole mao, ibaba gisirua. Tota titnan tamad Sebedi ga idio oagaeai gisingada ele panua naurata ad, ta gisirua tila tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Idio ta Iesus asingada ele aluagau tila Kapernaum. Be mole mao idudunga ngan luma raring aea ngan Ado Earainga aea ta ipapaoatai gid. ");
INSERT INTO bch_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Tilongo ele paoatainga ta timatala kapei, ngansa ei ipapaoatai gid mambe gid madidnga apu ad mao, be ikakado paoatainga mambe eaba ieda kapei. ");
INSERT INTO bch_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Be mole mao, eaba ede ingangar luma raring aea iloleai. Iriau paeamao ienono pan ");
INSERT INTO bch_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ta ikeo, “Iesus, Nasaret am, eao ga kado mado ngan gai? Eao nam ngan paeabunga gai na? Gau naoatai ngan eao. Eao Eaba Tutui ton Deo.” ");
INSERT INTO bch_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Be Iesus idaba iriau paeamao ta ikeo, “Kapin aoam ta tnan ei.” ");
INSERT INTO bch_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Tota iriau paeamao toa oa inuga ei paeamao tau ta ingangar, ga kus ta itnan ei ga ila. ");
INSERT INTO bch_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Be panua toa ngada oa tikakrik ta tibeta pol ngan gid bedane, “Danga ne saoa toa? Eine paoatainga pau ede inam pan eaba ieda kapei! Ei iposa pagid iriau papaeamao ta tilongo ilinge.” ");
INSERT INTO bch_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Tota iualu ilado manmanae ga ila ngan tuanga toa ngada oa Galili. ");
INSERT INTO bch_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iesus asingada ele aluagau titnan luma raring aea ga tiuot ta tila tutui pan Saimon ga Andreas led lumaeai. Jems ga Ioanes tila pade. ");
INSERT INTO bch_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Be Saimon ilaoa taine itin iuanaoana ta ienono imuliai. Be tutui ngan Iesus inama iuot, tipalongo ei. ");
INSERT INTO bch_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ei ila boloma pan ta ikisi ibage ta ilua ei ga idae. Be oanaoananga itnan ei, ta ila ipan ad annga. ");
INSERT INTO bch_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ado idil ngan lailai toaiua, be gid panua tital panua busa ad dibala ta tila pan Iesus. Ga tital padengada toa iriau papaeamao ienono ngan gid ta tila pan. ");
INSERT INTO bch_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Gid ipom toa ngada oa tuangai tinam timadmadid atama iaoai. ");
INSERT INTO bch_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ta ei ikemi panua busa ad dibala imata ede ga ede, ga iseresere iriau papaeamao pagid panua padengada. Be ei ilongean gid iriau papaeamao ta tiposaposa mao, ngansa gid tiuatai ngan ei sai. ");
INSERT INTO bch_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Gaga iuangga itakai, be Iesus idae ta iuot ga ila ngan tibur modamodanga. Ei idio iraring toa eoa. ");
INSERT INTO bch_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Be Saimon masin tiloilo ei. ");
INSERT INTO bch_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tiuot ngan ei ga kus ta tikeo, “Panua busa tiloilo eao.” ");
INSERT INTO bch_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Be ikeo pagid, “Kemi ngan tala ngan gid tuanga padengada boloma, ta irangrang ngan napaola posanga ga ila pagid. Ngansa gau nanama ngan ipu tota nene.” ");
INSERT INTO bch_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Idio ta ila ngan gid tuanga busa Galili ga idudunga ngan gid luma raring aea, ta ipaola Deo ele posanga ga ila pagid ga iseresere iriau papaeamao. ");
INSERT INTO bch_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Idio ta eaba ede aea dibala kankan ila pan Iesus. Ei ikor iae pan ta ibeta matua ei bedane, “Oangga eao kim, eao rangrang ngan kado tinig ga iuot kemi Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iesus iuduan ei ta idol ibage ga idae ngan ei ta ikeo, “Gau nakim. Eao tinim iuot kemi.” ");
INSERT INTO bch_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Be mole mao, dibala kankan itnan ei ta iuot kemi pade. ");
INSERT INTO bch_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Iesus isula ei manmanae ga ila be iposa matua pan bedane, ");
INSERT INTO bch_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gabit kemi. Keo pan eaba eta pade mao. Be la tutui pan eaba tenainga aea ta pasolan tinim pan. Ga kus ta tal lem tenainga ngan tinim iuot kemi, mambe Moses ele apu ikeo ngan. Kadonga toa ne ga ipasolan gid mambe tinim iuot kemi tautaunga.” ");
INSERT INTO bch_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Be mao. Eaba toa oa ila ta iuaoa pagid panua busa ngan danga toa oa ta ipaoasasa aea posanga. Toa bedaoa ta Iesus irangrang ngan ilalala tuangai panua matadeai mao. Be ei idio ngan tibur modamodanga, ta panua busa ngan tuanga toa ngada oa tilagalaga pan. ");
INSERT INTO bch_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ado edengada ila ga kus ta Iesus iluai mulian ele tuangai Kapernaum. Ta gid panua tilongo mambe ei imamado lumaeai. ");
INSERT INTO bch_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Be panua busa tiluplup ta tipakaranga luma ilolo, be atama iaoa pade iuon ngan gid panua. Ei ipaola Deo ele posanga ila pagid. ");
INSERT INTO bch_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Be panua pange tibisi eaba ede ngan aea nagarengreng ta tinam. Eaba toa oa iae ga ibage imate. ");
INSERT INTO bch_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Be tirangrang ngan tibada ei ga ila boloma pan mao, ngansa panua busa ga edap mao. Tota tidae ga tila ta tirepe usi gadae ngan tibur toa Iesus imamado ngan. Tikaukau aea nagarengreng ngan oaro ta tipasil ei ngan baba toa oa ta idudunga lumaeai. ");
INSERT INTO bch_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Iesus igera led kadonga lolo matua aea ta ikeo pan dibala tamad bedane, “Leg eaba, gau nasamum lem kadonga sasat na.” ");
INSERT INTO bch_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Be gid madidnga apu ad timamado pade ta tikeo lolodeai bedane, ");
INSERT INTO bch_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ikamado ga eaba toa ne iposa bedane? Ei iuangga ibada Deo imul! Eaba eta irangrang ngan isamum kadonga sasat mao. Deo kekelen irangrang.” ");
INSERT INTO bch_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Be mole mao toa iloleai oa, Iesus iuatai ngan led posanga lolodeai ta ikeo pagid bedane, “Ikamado ga aposa bedaoa lolomiai? ");
INSERT INTO bch_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Posanga isaoa aea naurata malan: oangga nakeo pan dibala tamad bedane, ‘Gau nasamum lem kadonga sasat,’ mao oangga nakeo, ‘Dae madid, bada am nagarengreng ta lalala’? ");
INSERT INTO bch_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Be gau ga napasolan gimi ta irangrang ngan aoatai kemi mambe Eaba Inat ieda kapei tanoeai ngan samumnga kadonga sasat.” Ta ikeo pan dibala tamad bedane, ");
INSERT INTO bch_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nakeo pago, dae madid, bada am nagarengreng ta la lem lumaeai.” ");
INSERT INTO bch_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Tota eaba toa oa idae imadid ta manmanae ibada aea nagarengreng ta iuot ga ila panua busa matadeai. Ta gid toa ngada oa timatala kapei ga tisoa Deo ieda ta tikeo, “Mugaeai ga inam, gai agera danga eta bedane mao!” ");
INSERT INTO bch_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Idio ta Iesus ila labiai ngan liu kapei Galili pade. Be ipom kapei tila pan, ta ipaoatai gid. ");
INSERT INTO bch_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ga kus ta ilalala ga ila ta igera Livai toa Alpius inat imamado ngan luma takis aea. Ta Iesus ikeo pan, “Eao nam nasi gau.” Tota idae ta ila inasi ei. ");
INSERT INTO bch_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Idio ta gisirua timamado Livai ele lumaeai ga tianean. Be panua busa takis ad ga kadonga sasat ad timamado ga tianean toman ngan Iesus ga ele aluagau. Ngansa panua matad ede ga ede tinasnasi ei. ");
INSERT INTO bch_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Be gid madidnga apu ad ga gid Parisi tigera ei ianean toman ngan gid panua kadonga sasat ad ga panua takis ad, ta tikeo pagid ele aluagau bedane, “Ikamado ga ami Maron ianean toman ngan gid panua kadonga sasat ad ga panua takis ad?” ");
INSERT INTO bch_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Be Iesus ilongo toa bedaoa ta ikeo pagid, “Gid panua tinid kemi led ipu eta ngan tila pan eaba keminga aea mao, be gid dibala tilagalaga pan. Gau nanam ngan babanga gid panua tututui mao, be nanam ngan babanga gid panua kadonga sasat ad.” ");
INSERT INTO bch_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Be gid aluagau ton Ioanes Paliliunga aea ga togid Parisi tinasnasi kadonga ngan plesenga annga. Ta ado ede tila pan Iesus ta tibeta ei, “Ikamado ga gid aluagau ton Ioanes Paliliunga aea ga togid Parisi tiplese annga, be eao lem aluagau tiplese annga mao?” ");
INSERT INTO bch_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ta Iesus ikoli led posanga bedane, “Oangga eaba ede iuai taine ta tikado eaneannga ngan led oainga, gid toman ngan oaeoaed tirangrang ngan tiplese annga pade? Eine mao. Oangga eaba oainga imamado toman ngan gid, tinid igelgel ta tirangrang ngan tiplese annga mao. ");
INSERT INTO bch_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Be ado ede muriai, panua padengada ga tipaeaoa eaba toa oa ga ila aluai ngan gid. Ta ngan ado toaiua, gid ga tiplese annga. ");
INSERT INTO bch_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Eaba eta irangrang ngan ibada malo ilia pau ta isaisai ngan aea malo mugamuga aea krak mao. Oangga ikado bedaoa, be imum ga kus ta ipaeanado, eine malo pau ilia ga itaka malo mugamuga ga paeamao. ");
INSERT INTO bch_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Be eaba eta irangrang ngan iparere oain pau ngan meme itin kukul mugamuga mao. Oangga ikado bedane, eine oain pau ga ikado meme itin kukul mugamuga ga pak. Ta oain ga itoki, ga meme itin kukul pade ga iduaea. Be gita taparere oain pau ngan meme itin kukul papau.” ");
INSERT INTO bch_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Idio ta ngan Ado Earainga aea ede, Iesus ilalala rabu ngan dadanga wit, be ele aluagau tipasu wit itautau edengada ta tianean ga tilalala. ");
INSERT INTO bch_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Be gid Parisi tikeo pan bedane, “Ega, ikamado ga lem aluagau tikado kadonga itutui mao ngan Ado Earainga aea?” ");
INSERT INTO bch_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Be ikeo pagid, “Kado gimi aoato laulau ngan Devit ele kadonga toa mugaeai oa mao? Ngan ado toaiua, Devit asingada iuaeoae ad annga mao, ta pitoreagid. ");
INSERT INTO bch_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ta idudunga Deo ele palatai ngan ado toaiua Abiatar iman madidnga kapei tenainga aea, ta ibada bret tenainga aea toa ienono Deo imatai ta ian. Be bret toa oa, itutui ngan gid panua tenainga ad kekelegid tianean. Be Devit ian ta ipan iuaeuae ad pade.” ");
INSERT INTO bch_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ta Iesus ikeo pagid, “Deo ele ipu ngan dolnga gid eababa, eine ngan nasinga gid apu ngan Ado Earainga aea mao. Be ele ipu ngan dolnga Ado Earainga aea, eine ngan luanga gid eababa. ");
INSERT INTO bch_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tota Eaba Inat, ei Maron ngan Ado Earainga aea pade.” ");
INSERT INTO bch_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Idio ta Iesus idudunga pade ngan luma raring aea. Be eaba ede ibage imate imamado toa eoa. ");
INSERT INTO bch_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Be gid panua matad ingitngit Iesus, ngansa oangga tigera ei ikado kemi dibala ngan Ado Earainga aea, eine ga tisol ei ngan posanga. ");
INSERT INTO bch_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Be ikeo pan eaba toa ibage imate oa bedane, “Nam madid rabu.” ");
INSERT INTO bch_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ta ibeta gid bedane, “Ngan Ado Earainga aea, eine tutui ngan takado kadonga kemi, mao takado kadonga paeamao? Eine tutui oangga tabada mulian gid panua, mao tapaeabu ngan gid?” Be gid tiposa eta mao. ");
INSERT INTO bch_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ta imata inono gid kelede kelede be ilolo bake, ngansa tipaki tangad ngan posanga tautaunga, ta ei ilolo itang. Ta ikeo pan eaba toa oa, “Patutui bagem.” Io, ipatutui ibage, be ibage iuot kemi pade. ");
INSERT INTO bch_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Idio ta gid Parisi tiuot ga tila tiluplup toman ngan Erot ele panua, ta tiloilo edap eta ngan pamatenga ei. ");
INSERT INTO bch_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Idio ta Iesus asingada ele aluagau titnan tuanga toa oa ta tila ngan liu kapei Galili. Be gid ipom tinasi gid. Gid panua Galili, ga Iudea, ");
INSERT INTO bch_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ga tuanga Ierusalem, ga tibur Idumea, ga gid tuanga iadag ngan eau Iordan, ga tuanga Tair ga Saidon, ga gid tuanga boloma ngan, gid busa tilongo ngan ele kadonga ta tilagalaga pan. ");
INSERT INTO bch_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ta ikeo pagid ele aluagau ngan tibada oaga eta ga inam ta imomono boloma, ta oangga gid ipom tigong ei, eine ga idug ga idae ngan. ");
INSERT INTO bch_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ngansa ei ikakado kemi panua busa. Ta sapadua tidibal, eine tiparpar ngan sibonga ei ta tipairile ngan gid. ");
INSERT INTO bch_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Be oangga gid iriau papaeamao tigera ei, gid tikor aed ngan ei ta tingangar ta tikeo, “Eao Deo Inat.” ");
INSERT INTO bch_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Be ei ipakoko gid matua tau ngan tiuaoa ngan ei sai. ");
INSERT INTO bch_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Idio ta Iesus idae ga ila lusiai ta ibaba gid panua toa ikim gid, ta tila pan. ");
INSERT INTO bch_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ei idol panua sangaul ga igegea rua ta iuato gid ele panua ato ad. Ei ikim timamado toman ngan ei somisomi, ta iuangga isula gid ga tila tipaola posanga, ");
INSERT INTO bch_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ga iuangga ipamatua gid ngan serenga iriau papaeamao. ");
INSERT INTO bch_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gid sangaul ga igegea rua toa Iesus idol oa, edad ga bedane: Saimon toa Iesus iuato ieda ede pade Petrus, ");
INSERT INTO bch_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ga Jems toa Sebedi inat, ga itar kakau Ioanes. (Iesus iuato gisirua edad ede pade Boanerges. Be edaeda toa ne ipu bedane: Gisirua mambe mariamba ele tandanga.) ");
INSERT INTO bch_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ga idol Andreas, ga Pilip, ga Bartolomeus, ga Mateus, ga Tomas, ga Jems toa Alpius inat, ga Tadius, ga Saimon Selot, ");
INSERT INTO bch_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ga Iudas Iskariot toa muriai idol Iesus ga idae aea isat bagedeai. ");
INSERT INTO bch_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Idio ta Iesus idudunga lumaeai. Be panua busa tiluplup pade ta tikado ga Iesus asingada ele aluagau tirangrang ngan tian ad annga mao. ");
INSERT INTO bch_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Be isobosobo tilongo toa bedaoa ta tikeo ga ei imangamanga. Tota tila ngan badanga ei mulian. ");
INSERT INTO bch_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Be gid madidnga apu ad titnan Ierusalem ga tinam ta tikeo, “Belsebul toa gid iriau papaeamao ad madidnga ienono pan, ta iseresere gid iriau papaeamao ngan Belsebul iura.” ");
INSERT INTO bch_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Be Iesus ibaba gid ga tinam pan ta itado oanenga itna pagid bedane, “Satan irangrang ngan isere Satan mao. ");
INSERT INTO bch_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Oangga maron kapei ede ele panua timapoga ta tiparau pol ngan gid, irangrang ngan timadid matua mao. ");
INSERT INTO bch_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ga oangga gid panua ngan luma ede timapoga ta tiparau pol ngan gid, gid iaoa kelede toa oa tirangrang ngan timadid matua mao pade. ");
INSERT INTO bch_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tota oangga Satan ele panua timapoga ta tiparau pol ngan gid, eine ga timadid matua mao, be gid ga timukuru ga tila. ");
INSERT INTO bch_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Be eaba eta irangrang ngan idudunga sapaean ngan luma ton eaba iura kapei ngan lubnga ele danga sisid mao. Be oangga ikaukau eaba toa iura kapei oa ngan kenga ga kus, tota ei ga irangrang ngan ilub ele danga toa ngada oa lumaeai. ");
INSERT INTO bch_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nakeo tautaunga pagimi, Deo ga isamum panua led kadonga sasat ga led posanga papaeamao imata ede ga ede, ");
INSERT INTO bch_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","be eaba sai ipaeabu ngan Itautau Tutui ieda, Deo ga isamum ele kadonga sat mao. Labone ga muriai pade ele kadonga sat aea samumnga mao ga ilalala ga ila.” ");
INSERT INTO bch_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iesus ikeo bedaoa ngansa gid tikeo ga iriau paeamao ienono pan. ");
INSERT INTO bch_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Idio ta Iesus itna toman ngan itar kakakau tinam ta timadmadid gaot ngan luma toa oa, be tisula ato ga ila pan ta tiuangga ei ila pagid. ");
INSERT INTO bch_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Panua busa timamado ga tibalil ngan ei ta tikeo pan bedane, “Ega, tnam ga am kakakau ga liulium timadmadid gaot, be tiuangga tigera go.” ");
INSERT INTO bch_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ta ikoli led posanga bedane, “Sai gau tnag, ga sapadua ag kakakau?” ");
INSERT INTO bch_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ta imata ila pagid panua toa timamado ga tibalil ngan ei ta ikeo, “Ega, gau tnag ga ag kakakau tota eko. ");
INSERT INTO bch_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngansa eaba sai inasi Deo ele kimnga, ei ag kakakau ga liuliug ga tnatnag.” ");
INSERT INTO bch_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Idio ta Iesus ila ngan liu kapei Galili ta ipaoatai gid panua pade. Ipom kapei tau tinam tiluplup pan, ta idae oagaeai ta idio imado. Gid ipom timadmadid labiai, ");
INSERT INTO bch_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","be ei itado oanenga itna busa pagid ngan paoatainga gid. Ei ipapaoatai gid ta ikeo, ");
INSERT INTO bch_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Alongo, dadanga itama ila isiran wit ipuapua dadangai. ");
INSERT INTO bch_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ei isisiran ga ila, be wit ipuapua idanga ede itaptap ga idio edap isaleai. Ta gid man tinam tian ga kus. ");
INSERT INTO bch_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Be wit ipuapua idanga ede itaptap ga idio ngan tano aea patpat kapeipei. Be tano kapei tau mao, tota wit ipara ga idae manmanae ngansa isulug tau mao. ");
INSERT INTO bch_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ado ipara ga idae ta ilaba wit. Be wit iuaroar tos ngan pat, tota imalai ga imisi. ");
INSERT INTO bch_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Be wit ipuapua idanga ede itaptap ga idio rabu ngan oaroaro aea gigi. Be oaroaro idae kapei ta imol wit ta irangrang ngan itautau mao. ");
INSERT INTO bch_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Be wit ipuapua idanga ede itaptap ga idio ngan tano kemi, ta idae kapei ga itautau iuot busa. Idanga ede itautau iuot sangaul tol, idanga ede itautau iuot sangalima sangaul ede, idanga ede itautau iuot buno.” ");
INSERT INTO bch_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ta Iesus ikeo, “Eaba sai itanga, manta ilongo kemi posanga toaine.” ");
INSERT INTO bch_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Idio ta Iesus imamado toman ngan ele aluagau sangaul igegea rua ga gid panua toa tinasnasi ei, ta gid kekelegid timamado. Ta tibeta ei ngan gid oanenga itna toa oa ipu madongan. ");
INSERT INTO bch_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ta ikeo pagid, “Deo ipaola pagimi ngan posanga ipu mumulnga ngan madonga ibageai. Be gid panua toa timan iaoa ede toman ngan gita mao, gid ga tibada posanga toa ngada ne ngan oanenga itna kekelen. ");
INSERT INTO bch_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Toa bedaoa ta, “‘Matad igeragera, be laborad ibada mao. Ga tangad ilongolongo, be tibada oatainga mao. Ngan kado ta tipul lolod ta nasamum led kadonga sasat.’” ");
INSERT INTO bch_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Idio ta Iesus ibeta gid, “Oanenga itna toa ne, gimi aoatai ngan ipu mao na? Oangga bedaoa, gimi ga aoatai ngan oanenga itna padengada madongan? ");
INSERT INTO bch_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Dadanga itama eine mambe eaba itado Deo ele posanga ga ila pagid panua. ");
INSERT INTO bch_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Be Deo ele posanga ila pagid panua edengada mambe wit ipuapua itaptap edap isaleai. Gid tilongo Deo ele posanga, be manmanae Satan inam ta ipaeaoa posanga toa lolodeai oa. ");
INSERT INTO bch_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Be Deo ele posanga ila pagid panua padengada mambe wit ipuapua itaptap ngan tano aea patpat. Gid tilongo Deo ele posanga ga tibada manmanae ta tinid igelgel ngan. ");
INSERT INTO bch_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Be posanga toa oa isulug lolodeai mao, mambe wit iuaroar isulug gadio tanoeai mao. Gid timamado mole mao, ta oangga kadonga kulupulupu iuot, ga gid panua tipaieiei sapadua tinasi Deo ele posanga, eine led kadonga lolo matua aea itap manmanae tau. ");
INSERT INTO bch_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Be Deo ele posanga ila pagid panua padengada mambe wit ipuapua itaptap ga idio ngan oaroaro aea gigi. Gid tilongo Deo ele posanga, ");
INSERT INTO bch_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","be gid danga tanoeai aea ikakado ga lolod ede ga ede, ga tikim tau pat ta ipabuobuo laborad, ga tingale danga imata ede ga ede. Tota gid danga toa oa iuot mambe oaroaro aea gigi toa imol Deo ele posanga lolodeai ta irangrang ngan itautau iuot mao. ");
INSERT INTO bch_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Be Deo ele posanga ila pagid panua padengada mambe wit ipuapua itaptap ga idio ngan tano kemi. Gid tilongo Deo ele posanga ta tikikisi kemi lolodeai. Tota gid mambe tano kemi toa wit itautau iuot busa ngan. Idanga ede itautau iuot sangaul tol, padengada itautau iuot sangalima sangaul ede, padengada itautau iuot buno.” ");
INSERT INTO bch_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Idio ta Iesus ikeo pagid, “Oangga eaba eta ibada lam ga inam, ei ga irobi ngan ulo mao, ga idol mul ibuloloeai mao pade. Be ei ga idol ga idae ngan lam imul, ngan tibur ede masaeai. ");
INSERT INTO bch_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ngansa saoa danga labone ienono mumulnga, eine muriai ga iuot masaeai. Be saoa posanga toa ipu ienono masaeai mao, muriai eine ga iuot merengai. ");
INSERT INTO bch_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Eaba sai itanga, manta ilongo kemi posanga toaine.” ");
INSERT INTO bch_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Iesus ikeo pagid pade bedane, “Be posanga toa gimi alongo, manta matami nanan kemi. Saoa kadonga gimi anasi ngan longonga Deo ele posanga, ei ga ibada oatainga pagimi ngan kadonga lalaede toa bedaoa, be ei ga ikado ga lemi oatainga ilalala ga idae pade. ");
INSERT INTO bch_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Oangga sai ele oatainga, Deo ga igal tatan ele oatainga ga ila kapei. Be oangga sai ele oatainga mao, saoa danga ei iuatai ngan kautede, eine Deo ga ikado ga imata sapian.” ");
INSERT INTO bch_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iesus ikeo pade bedane, “Madonga Deo ibageai eine mambe eaba ede iarum kon ipuapua dadangai. ");
INSERT INTO bch_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Bong ga bong eaba toa oa ienono. Ado ga ado idae ta ilalala, be ei iuatai mao, kon toa oa ipara madongan. ");
INSERT INTO bch_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tano kekelen ikado ga kon ipara ga idae ta itautau iuot. Ilaun iuot mugaeai, ga kus ta aea boloae pros ga iuot irabuiai, ga kus ta itautau iuot aea boloae iloleai. ");
INSERT INTO bch_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Be oangga itautau itub ga ila kapei, manmanae eaba toa oa iket ta ibada, ngansa aea laoe iuot na.” ");
INSERT INTO bch_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iesus ikeo pade bedane, “Madonga Deo ibageai eine mambe saoa danga? Oanenga itna isaoa kemi ta napaola pagimi ngan? ");
INSERT INTO bch_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Eine mambe mastet ipuapua taearum dadangai. Mastet ipuapua kakauede tau ngan gid annga ipuapua toa ngada ne tanoeai. ");
INSERT INTO bch_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Be oangga taearum ga kus ta ipara ga idae, eine idae ga ila kapei ta iasal gid annga padengada dadangai. Ibogaboga ila kapeipei ta irangrang ngan gid man tirau ad luma ngan ta timado kemi aea molomoloeai.” ");
INSERT INTO bch_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Idio ta Iesus itado oanenga itna busa pagid toa bedaoa, irangrang ngan tilongolongo ga laborad ibabada. ");
INSERT INTO bch_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Be ei iposa masaeai pagid ngan danga eta mao. Ei itado gid oanenga itna mon. Be oangga imamado toman ngan ele aluagau kekelegid, eine ipaola posanga toa ngada oa ipu pagid. ");
INSERT INTO bch_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Idio ta ado idil ngan lailai toaiua, ta Iesus ikeo pagid ele aluagau bedane, “Gita taore ga tala ngan liu isal iadag.” ");
INSERT INTO bch_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tota titnan gid ipom ga tidio, be gid tidae ngan oaga toa Iesus imamado ngan. Be oaga padengada tinasi gid. ");
INSERT INTO bch_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Idio ta rai kapei iuot ta sobo iraurau led oaga. Ta oaga ilolo iuangga iuon ngan lilimo. ");
INSERT INTO bch_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Be ei idio oaga imuriai, ta ilabora idae ngan aea nakulnga ta ieno. Tota tiuaoan ei ta tikeo, “Eaba paoatainga am, teta pade taduaea, be matam ila ngan mao?” ");
INSERT INTO bch_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Tota Iesus idae imadid ta idaba rai ga ngalu ta ikeo, “Ikaranga na! Aoam itano ga idio!” Tota rai ga ngalu kos ga idio, be tibur madlo ituntun. ");
INSERT INTO bch_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ta ikeo pagid, “Ikamado ga amataud? Lolomi matua eta maitne?” ");
INSERT INTO bch_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Be gid tilolon ngan ei kapei tau, ta tibetabeta pol ngan gid, “Eaba toa ne sai, ta rai ga ngalu tilongo ilinge?” ");
INSERT INTO bch_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Idio ta Iesus asingada ele aluagau tiuot liu isal iadag ngan tibur togid Gerasa. ");
INSERT INTO bch_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ei itnan oaga ga idio, be manmanae eaba ede inam dengaeai ga ila pan. Iriau paeamao ienono pan ");
INSERT INTO bch_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ta ikado ei ta imamado alele ngan gid denga. Panua tiuangga tiaud ei ngan sen, be tirangrang mao. ");
INSERT INTO bch_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Somisomi tiaud iae ga ibage ngan sen ga ankap, be ei idada sen ga iketi ga igoro ankap pade. Tota eaba eta irangrang ngan ipakoko ei mao. ");
INSERT INTO bch_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Somisomi bong ga ado ei idio imamado alele dengaeai ga bereoeai, be ingangar ga iketket itin ngan patpat. ");
INSERT INTO bch_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ei igera Iesus aluai maitne, ta ilado ga ila pan ta ikor iae. ");
INSERT INTO bch_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Be ingangar matua tau ta ikeo, “Iesus, gergeu ton Deo Gadae Tau, eao ga kado mado ngan gau? Nabeta eao ngan Deo ieda, paieiei gau padam.” ");
INSERT INTO bch_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ei ikeo toa bedaoa ngansa Iesus ikeo pan bedane, “Iriau paeamao, eao tnan eaba toa ne ga idio!” ");
INSERT INTO bch_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ta Iesus ibeta ei, “Eao edam sai?” Ta ikeo, “Gau edag Ipom, ngansa gai busa tau.” ");
INSERT INTO bch_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ta gid tibeta ei matua ngan isere gid ta titnan tibur toa oa mao. ");
INSERT INTO bch_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Be boloma ngan bereo toa oa, gaea ipu kapei ede tianean. ");
INSERT INTO bch_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ta gid iriau papaeamao tibeta ei matua bedane, “Longean gai ta ala adudunga ngan gaea ipu ga eoa.” ");
INSERT INTO bch_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ta Iesus ilongo. Tota gid iriau papaeamao titnan eaba toa oa ta tila tidudunga ngan gaea ipu. Be manmanae gid gaea tiladlado ga titaptap perpereai ga tisulug liuiai. Tota gid gaea toa bunoringring rua oa tidal liuiai ga timatemate. ");
INSERT INTO bch_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Be gid panua toa timariala ngan gaea oa tiaoa ga tila tipalongo gid panua tuangai ga gid panua gaot ngan tuanga. Tota gid busa tila ngan geranga saoa danga iuot. ");
INSERT INTO bch_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ta tila pan Iesus ta tigera eaba toa mugaeai gid iriau papaeamao timamado pan. Be patautene eaba toa oa ilolo iluai mulian ga ipit malo kemi ta imamado. Tigera bedaoa ta timataud. ");
INSERT INTO bch_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ta gid panua toa tigera saoa danga iuot oa aoad inasi pagid ngan iriau papaeamao titnan eaba toa oa madongan, ga ngan gid gaea titap perpereai. ");
INSERT INTO bch_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Be gid panua tiparpar pan Iesus ngan itnan gid ta ila ngan tibur eta pade. ");
INSERT INTO bch_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Idio ta Iesus iuangga idae oagaeai, be eaba toa iriau papaeamao titnan ei oa ibeta matua Iesus ngan ilalala toman ngan ei somisomi. ");
INSERT INTO bch_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Be Iesus ipalua ei ta ikeo, “Eao luago ga la lem lumaeai pagid sobosobom, ta palongo gid ngan saoa danga Maron ikado ngan eao ga ilolo isat ngan go.” ");
INSERT INTO bch_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Idio ta eaba toa oa ilalala ga ila ngan gid tuanga Dekapolis ta ipaoasasa posanga ngan saoa danga Iesus ikado ngan ei, ta timatala kapei. ");
INSERT INTO bch_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Idio ta Iesus asingada ele aluagau tidae oagaeai pade ta tiuore ga tila ngan liu isal iadag. Ei isulug ta imadmadid labiai, be panua busa tiama ga tinam pan. ");
INSERT INTO bch_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Be madidnga ede ngan luma raring aea, ieda Iairus, inam igera ei ta ikor iae boloma pan. ");
INSERT INTO bch_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ei iansaban Iesus ta ibeta matua bedane, “Natug taine teta pade imate. Nam dol bagem ga idae ngan ei, ta itin iuot kemi mulian ta imamado.” ");
INSERT INTO bch_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Tota gisirua tila, be ipom kapei tinasi gid ta tigong ei. ");
INSERT INTO bch_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Be taine ede ilalala toman ngan gid. Ei aea dibala sing palapala ikakado ei irangrang ngan aea rai sangaul ga igegea rua. ");
INSERT INTO bch_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Aea ieieinga kapei ta ila pagid panua keminga ad ta iuolol gid ga irangrang ngan ele pat kus, be itin iuot kemi eta mao. Aea dibala ila paeamao ta iasal toa mugaeai aea pade. ");
INSERT INTO bch_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Be taine toa oa ilongo Iesus iualu, ta ikeo iloleai bedane, “Oangga nasibo ele pononga, tota tinig ga iuot kemi.” Tota idudunga ipom lolodeai ta ila Iesus imuriai ta isibo ele pononga. ");
INSERT INTO bch_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Be mole mao, sing palapala ilaea ngan ei ta inaman aea dibala kus. ");
INSERT INTO bch_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Be Iesus iuatai manmanae mambe iura idanga ede ila ngan keminga, ta ipul ei ipom lolodeai ta ibeta, “Sai isibo leg pononga?” ");
INSERT INTO bch_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ta ele aluagau tikeo, “Gera, panua busa tigong go. Eao kamado beta ngan sai isibo go?” ");
INSERT INTO bch_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Be imata kleng alele ngan gid ipom ngan geranga sai ikado toa bedaoa. ");
INSERT INTO bch_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Be taine toa oa iuatai ngan kadonga toa iuot ngan ei, ta imataud ga isamimi. Ta inam ikor iae pan ta iuaoa ngan gid danga toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ta Iesus ikeo pan bedane, “Taine, lem kadonga lolo matua aea ikado ga tinim iuot kemi. Lolom itarui ta la. Eao am dibala kus.” ");
INSERT INTO bch_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ei iposaposa maitne, be gid panua tinam madidnga toa oa ele lumaeai ga tinam ta tikeo, “Natum taine imate o. Paeaea eaba paoatainga aea ne pade mao.” ");
INSERT INTO bch_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Be Iesus imata ila ngan posanga toa oa mao ta ikeo pan madidnga toa oa, “Mataud mao. Lolom matua kekelen.” ");
INSERT INTO bch_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Iesus ipaidi gid panua padengada, be ibada Petrus ga Jems ga itar kakau Ioanes kekelegid ");
INSERT INTO bch_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ta tila madidnga ele lumaeai. Toa eoa igera panua titangtang ga tiansaban ga arerengad kapei. ");
INSERT INTO bch_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ei idudunga lumaeai ta ikeo pagid, “Ikamado ga arerengami ga atangtang toa bedaoa? Gergeu imate mao. Ei ienono.” ");
INSERT INTO bch_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Be gid tinging ngan ei. Be ei isere gid toa ngada oa ga tila gaot. Ta ibada gergeu itama ga itna toman ngan ele aluagau toa oa kekelegid, ta ila boloma ngan taine kakauede imul. ");
INSERT INTO bch_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ei ikisi gergeu toa oa ibage ta ikeo, “Talita kum.” (Posanga toa ne ipu bedane, “Taine kakauede, nakeo pago, dae!”) ");
INSERT INTO bch_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Be mole mao, taine kakauede toa oa idae imadid ta ilalala. Ngansa ei aea rai sangaul ga igegea rua. Gid tigera ta timatala kapei tau. ");
INSERT INTO bch_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Be ei iposa matua pagid ta ikeo ga tiposa alele ngan danga toa oa mao. Ga kus ta ikeo ga tipan taine kakauede aea annga. ");
INSERT INTO bch_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Idio ta Iesus itnan tibur toa oa ta ila aea tuanga ipuiai Nasaret. Ele aluagau pade tinasi ei. ");
INSERT INTO bch_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Be ngan Ado Earainga aea, ei ila ngan luma raring aea ta ipaoatai gid panua. Panua busa tilongo ele posanga ta titogragid ta tikeo, “Eaba toa ne ibada ele oatainga madongan? Ele posanga inam sida ga inam? Be sai ipamatua ei ta ikakado gid uisinga? ");
INSERT INTO bch_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Be tautaunga ei Maria ele gergeu toa mugaeai ikakado luma. Ei itar kakakau Jems ga Iosep ga Iudas ga Saimon ga iliuliu pade timamado toman ngan gita.” Gid lolod paeamao ngan ei ta tiposa bedaoa. ");
INSERT INTO bch_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ta Iesus ikeo pagid, “Oangga eaba ibada Deo iaoa ta ila ngan tuanga ga tuanga, gid busa ga tilolon ngan ei. Be oangga ila aea tuanga ipuiai, pagid isobosobo ga iaoa kelede ei ton, gid ga tilolon ngan ei mao.” ");
INSERT INTO bch_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Tota ei irangrang ngan ikado uisinga kapei eta toa eoa mao. Be idol ibage ga idae ngan dibala pidaede ta ikado kemi gid. ");
INSERT INTO bch_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ta igera mambe lolod matua eta mao ta itograi. Be ei ila ngan gid tuanga boloma ta ipapaoatai gid. ");
INSERT INTO bch_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Idio ta Iesus ibaba ele aluagau sangaul ga igegea rua ta tinam pan. Ei ipamatua gid ngan serenga iriau papaeamao, ta isula gid ruangada ga tila ngan tuanga ga tuanga. ");
INSERT INTO bch_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ei irenren pagid ta ikeo ngan led lalalanga toa oa, irangrang ngan tikisi led toto lalalanga aea kekelen, be danga eta pade mao. Ikeo ga tibada annga mao ga pat mao ga bisinga mao pade. ");
INSERT INTO bch_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Irangrang ngan tidol su, be led pononga ruangada mao. ");
INSERT INTO bch_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ta irenren pagid bedane, “Oangga gimi ala ngan luma eta, adio aeno ngan luma toa oa irangrang ngan atnan led tuanga. ");
INSERT INTO bch_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Be oangga tuanga ede tibada gimi ga ala led lumaeai mao, ga tinid ngan longonga lemi posanga mao, tota atnan tuanga toa oa, be asile aemi aea kangkanga ga idio pagid ta iman kilala ngan paoatainga gid.” ");
INSERT INTO bch_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Idio ta tila tipaola posanga ta tikeo ga gid panua manta tipul lolod. ");
INSERT INTO bch_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ta tiseresere iriau papaeamao busa, ga tisama gid dibala ngan bude ta tikado kemi gid. ");
INSERT INTO bch_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Idio ta maron kapei Erot ilongo ngan Iesus, ngansa iualu iuot ngan tuanga toa ngada oa. Ta panua edengada tikeo ga, “Ioanes Paliliunga aea idae mulian ngan ele matenga ta ngan ipu toaine ikakado gid uisinga.” ");
INSERT INTO bch_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Be panua padengada tikeo ga, “Mao, ei Elaija.” Be padengada tikeo ga, “Ei eaba ede ibada Deo iaoa, mambe gid panua mugaeai tibabada Deo iaoa.” ");
INSERT INTO bch_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Be Erot ilongo posanga toa oa ta ikeo, “Mugaeai naket Ioanes igagal, be ei idae mulian pade!” ");
INSERT INTO bch_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Erot ikeo bedaoa ngansa mugaeai isula ele panua ta tiluku Ioanes ta tiaud ei ta tidol ei idudunga ngan luma panasnga aea. Ngansa Ioanes iselele Erot ngan oainga ele kadenge Erodias toa itar kapei Pilip iadaoa. ");
INSERT INTO bch_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Ngansa Ioanes ikeo pan Erot bedane, “Lem kadonga ngan oainga lem kadenge ne itutui mao.” ");
INSERT INTO bch_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tota Erodias ilolo paeamao ngan Ioanes ta iuangga ipamate ei, be irangrang mao. ");
INSERT INTO bch_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ngansa Erot iuatai mambe Ioanes ei eaba tutui, ta ilolon ngan ei ga imariala kemi ngan ei. Ioanes ele posanga ikakado ei ga ilolo ede ga ede, be ikim tau ngan longonga ele posanga. ");
INSERT INTO bch_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Be ado ede danga toa Erodias ikim, iuot ga bedane: Erot ikado eaneannga kapei ngan aea poponga. Ta ibaba ele panua toa edad kapeipei, ga gid madidnga paraunga ad, ga gid mamaron Galili ad. ");
INSERT INTO bch_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Gid tianean, be Erodias inat taine blala idudunga ga inam ta itoltol. Ta ikado ga Erot toman ngan ele nounga tinid igelgel kapei. Ta maron kapei Erot ikeo pan taine blala toa oa bedane, “Eao kim saoa pagau, eine ga nabada pago.” ");
INSERT INTO bch_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ta ikado posanga tautaunga gadae pan bedane, “Naposa tautaunga, saoa danga eao beta gau ngan, eine ga nabada pago. Oangga eao keo ga napoga leg tibur kapei toman leg danga sisid ga iman rua ta lem iadag, eine ga nakado.” ");
INSERT INTO bch_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ta taine toa oa iuot ga ila ta ibeta itna, “Gau ga nakeo pan ngan saoa ga ibada pagau?” Ta itna ikeo, “Eao keo pan ta ibada Ioanes Paliliunga aea ilabora ga inam.” ");
INSERT INTO bch_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tota taine blala toa oa iluai manmanae ga ila pan maron kapei ta ikeo, “Gau nakim toa patautene eao dol Ioanes Paliliunga aea ilabora ga idae ngan lalate ta bada ga inam pagau.” ");
INSERT INTO bch_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Be maron kapei Erot ilongo posanga toa oa ta ilolo itang. Be imata nanan ele posanga tautaunga gadae toa ikado ele nounga matadeai, ta igera mambe irangrang ngan itolatola ngan taine toa oa ele posanga mao. ");
INSERT INTO bch_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ta manmanae isula ele eaba ede ga ila ngan luma panasnga aea ta irenren pan ngan badanga Ioanes ilabora ga inam. Tota eaba toa oa ila iket Ioanes igagal ga put. ");
INSERT INTO bch_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ga kus ta idol ilabora ga idae ngan lalate ta ibada ga ila pan taine blala toa oa, ta ei ibada ga ila pan itna. ");
INSERT INTO bch_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Idio ta Ioanes ele aluagau tilongo ngan kadonga toa oa iuot, ta tila tibisi ipat ga ila ta tidol dengaeai. ");
INSERT INTO bch_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Idio ta Iesus ele panua ato ad tiluagid mulian ta tiluplup pan. Ta tininipu pan ngan kadonga toa ngada oa tikakado ga ngan saoa posanga tipapaoatai ngan. ");
INSERT INTO bch_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Be panua busa tau tila ga tinam ta tikado ga Iesus asingada ele aluagau tirangrang ngan tian ad annga mao. Ta ikeo pagid, “Anam ta gita kekelegita tala ngan tibur modamodanga, ta aearagimi teta.” ");
INSERT INTO bch_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Tota tidae oagaeai ta gid kekelegid tila ngan tibur modamodanga. ");
INSERT INTO bch_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Be panua busa tigera gid tila ta tiuatai ngan led lalalanga toa oa. Ta panua busa ngan tuanga ga tuanga tiladlado labiai ga tila ta tipaket gid matad. ");
INSERT INTO bch_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Idio ta Iesus itnan oaga ga idio ta igera ipom kapei toa oa ta ilolo isat ngan gid, ngansa gid mambe sipsip, be tamad eta imariala ngan gid mao. Ta ipaoatai gid ngan danga imata ede ga ede. ");
INSERT INTO bch_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Idio ta ado iuangga isulug ta ele aluagau tila pan ta tikeo, “Tibur ne modamodanga, be teta pade ado idil. ");
INSERT INTO bch_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Tota sula gid ipom ga tila ngan gid tibur ga tuanga gereirei boloma, ta tiuol ad annga ta tian.” ");
INSERT INTO bch_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Be Iesus ikoli led posanga ta ikeo, “Gimi apan ad annga.” Ta tikeo pan bedane, “Eao oangga gai ala ta aol ad bret ngan pat buno rua ta apan gid?” ");
INSERT INTO bch_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Be ibeta gid, “Gimi ami bret pida ienono? Ala agera.” Io, tigera ga kus ta tikeo, “Gai amai bret lima ga ia rua.” ");
INSERT INTO bch_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Idio ta ikeo pagid ipom ta tidio timado ngan rounga ga rounga toa tanoeai oa. ");
INSERT INTO bch_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ngan rounga edengada panua dabad iuot buno, be ngan rounga padengada dabad iuot sangalima. ");
INSERT INTO bch_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Idio ta ibada bret lima ga ia rua ta imata idae ga ila buburiai ta iposa kemi pan Deo. Ta itei bret ta ibada ga ila pagid ele aluagau, ta gid tiuade pagid ipom. Ta ipota gid ia toa rua oa ga ila pagid toa ngada oa. ");
INSERT INTO bch_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ta gid toa ngada oa tian ga apad isum. ");
INSERT INTO bch_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ga kus ta tibada mulian annga ilialia ta tinonoi ngan karei sangaul ga igegea rua. ");
INSERT INTO bch_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ngan gid ipom toa tian annga oa, gid arangaranga tiuot bunoringring lima. ");
INSERT INTO bch_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Idio ta Iesus iaoa isensen ele aluagau ta tidae oagaeai ta timuga ngan ei ga tila ngan liu isal iadag, ngan tuanga Betsaida. Be ei idio ta isula gid ipom ta tiluagid mulian led tuangai. ");
INSERT INTO bch_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ga kus ta itnan gid ta idae ga ila lusiai ta iraring. ");
INSERT INTO bch_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Io, bong ta gid aluagau tiuodeode ga tila liu irabuiai, be ei kekelen imamado tanopuiai. ");
INSERT INTO bch_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Be ei igera rai isoka gid be pakpakid ngan odenga. Io, gaga iuangga itakai be Iesus ilalala gadae ngan eau igogo ta ingata gid, be iuangga ilalala ga ila matadeai. ");
INSERT INTO bch_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Be gid tigera ei ilalala gadae ngan eau igogo, ta tiuangga ei lausio eta, ta tingangar. ");
INSERT INTO bch_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Gid toa ngada oa tigera ei ta timataud kapei. Be ei iposa toman ngan gid ta ikeo, “Lolomi pu! Eine gau. Amataud mao.” ");
INSERT INTO bch_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Tota idae pagid oagaeai, be rai kos ga idio. Ta gid timatala kapei tau. ");
INSERT INTO bch_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ngansa gid tiuatai kemi mao ngan ele kadonga ipu ngan ikado bret ga iuot busa. Laborad irangrang ngan ibada mao. ");
INSERT INTO bch_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Iesus asingada ele aluagau tiuore ngan liu isal iadag ta tidudunga ngan tuanga Genesaret ta titado nagun. ");
INSERT INTO bch_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Gid titnan oaga ga idio, be mole mao panua tiuatai mambe eine Iesus. ");
INSERT INTO bch_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ta ipom kapei ngan tuanga busa ngan tibur toa oa tiladlado ga tila pan. Somisomi oangga panua tilongo ngan ei imamado ngan tibur isaoa, gid tibisibisi gid dibala ngan nagarengreng ga tila pan. ");
INSERT INTO bch_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ta somisomi oangga ila ngan gid tibur ga tuanga kapeipei ga gereirei, gid tidol gid dibala ngan tibur oalo aea, ta tibeta matua ei ngan ilongean gid dibala ta tisibo ele pononga imatamata. Ta gid toa ngada oa tisibo ei bedaoa, tinid iuot kemi. ");
INSERT INTO bch_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Idio ta gid Parisi ga gid madidnga edengada apu ad titnan Ierusalem ta tila tiluplup pan Iesus. ");
INSERT INTO bch_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Gid tigera ele aluagau edengada tianean be tisigiri baged mao, ta tiselele Iesus. ");
INSERT INTO bch_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Ngansa gid Parisi ga gid Iuda toa ngada oa tinasnasi tibutibud led nasinga, ta oangga tisigiri baged mao, irangrang ngan tian mao. ");
INSERT INTO bch_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ga oangga tila ngan tibur oalo aea ta tiluagid led lumaeai, be tisigiri tinid aea muk mao, eine irangrang ngan tian mao pade. Tinasi led nasinga busa bedaoa ta tisigiri ad loba ga eaupat ga ulo ga mulid.) ");
INSERT INTO bch_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Tota gid Parisi ga madidnga apu ad tibeta ei bedane, “Ikamado ga lem aluagau tinasi tibutibuda led nasinga ngan bageda aea sigiringa mao, be tianean sapaean?” ");
INSERT INTO bch_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ta ei ikeo pagid bedane, “Mugaeai Aisaia ibada Deo iaoa tutui ngan gimi panua pakakanga ami ta ibode bedane, “‘Gid panua toa ne tilolon ngan gau ngan aoad kekelen, be lolod inam pagau tautaunga mao. ");
INSERT INTO bch_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Gid tisoa edag sapaean. Tikado paoatainga ngan gid eababa led posanga ta tikeo ga eine Deo ele apu.’ ");
INSERT INTO bch_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gimi atnan Deo ele apu, be akisi matua gid eababa led nasinga.” ");
INSERT INTO bch_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ta ikeo pade bedane, “Gimi anasi kemi nasinga togid tibutibumi, be apaki tangami ngan Deo ele apu. ");
INSERT INTO bch_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Nakeo pagimi bedane ngansa mugaeai Moses ikeo, ‘Eao manta lolon ngan tamam ga tnam ta nasi linged,’ ga ‘Oangga sai iposa paeamao ngan itama, mao ngan itna, ei ga imate.’ ");
INSERT INTO bch_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Be gimi akeo ga oangga sai ikim, kemi ngan ikeo pan itama ga itna bedane, ‘Leg pat toa mugaeai ienono ngan luanga gimirua, gau nasio ga iuot korban.’ (Posanga idil toaine ipu bedane: Deo ele tenainga.) ");
INSERT INTO bch_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ta panua tinasi lemi kadonga toa ne ta tirangrang ngan tilua tamad ga tnad mao. ");
INSERT INTO bch_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tota ngan lemi nasinga, gimi akado ga Deo ele posanga iman danga buligaliga. Gimi abada nasinga toa ne pagid tibutibumi ta apaoatai lemi gergeu ngan pade. Be lemi kadonga toa bedaoa imata ede ga ede.” ");
INSERT INTO bch_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Idio ta Iesus ibaba gid ipom ta tinam pan pade ta ikeo pagid, “Gimi toa ngada ne alongo kemi leg posanga ga abada oatainga ngan. ");
INSERT INTO bch_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Gid danga ienono gaot ngan eaba ga idudunga iaoai, irangrang ngan ikado ei ga iuot paeamao Deo imatai mao. Be gid danga toa ienono eaba iloleai ga iuot, tota ikado ei ga iuot paeamao Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Idio ta itnan gid ipom toa oa ga tidio ta idudunga lumaeai. Be ele aluagau tibeta ei ngan oanenga itna toa ne ipu. ");
INSERT INTO bch_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ta ikeo pagid, “Ikamado? Gimi pade laborami ibada maitne? Manta gimi aoatai bedane: Saoa danga ienono gaot ngan eaba ga idudunga iaoai, eine irangrang ngan ikado ei ga iuot paeamao Deo imatai mao. ");
INSERT INTO bch_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Eine ngansa idudunga tautaunga eaba iloleai mao, be idudunga iapai ta inasi edap sakir aea.” (Ngan posanga toa ne, Iesus ikeo ga annga toa ngada ne kemi ngan eaneannga.) ");
INSERT INTO bch_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ta ikeo pade bedane, “Be gid danga ienono eaba iloleai ga iuot, tota ikado ei ga iuot paeamao Deo imatai. ");
INSERT INTO bch_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ngansa gid danga inam eaba iloleai ga iuot, eine gid danga ga bedane: matad nanan danga papaeamao, ga kadonga iriau aea, ga lublubnga, ga raunga panua ga timate, ");
INSERT INTO bch_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ga kadonga arala, ga mogal buda, ga lolod papaeamao, ga pakakanga, ga nasinga kadonga mambe kaua, ga mata galgal, ga dabanga sat, ga kadonga parimnga, ga kadonga mangamanga. ");
INSERT INTO bch_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gid danga papaeamao toa ngada ne ienono panua lolodeai ga iuot, ta ikado gid ga tiuot paeamao Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Idio ta Iesus idae ta itnan tuanga toa oa ta ila ngan tibur togid panua Tair ad. Ei idudunga ngan luma ede, be itin ngan panua tiuatai ngan ei mao. Be ei irangrang ngan imumul mao. ");
INSERT INTO bch_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mole mao taine ede ilongo posanga ngan ei ta ila ikor iae boloma pan. Ele gergeu taine, iriau paeamao ienono ngan ei. ");
INSERT INTO bch_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Be taine toa oa Iuda aea mao. Ei tibur Ponisia aea ngan tibur kapei Siria. Be ila ta ibeta matua ei ngan serenga iriau paeamao ngan inat taine. ");
INSERT INTO bch_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Be Iesus ikeo pan bedane, “Kemi ngan gid gergeu tian ga apad isum bua. Ngansa oangga nabada ad annga ta natado ga ila pagid kaua, eine kemi mao.” ");
INSERT INTO bch_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Be taine toa oa ikoli ele posanga bedane, “Be Maron, gid kaua pade toa popou ibuloloeai tian annga isakirkir togid gergeu.” ");
INSERT INTO bch_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ta Iesus ikeo pan, “Eao keo bedane kemi. Tota luago ga la. Iriau paeamao itnan lem gergeu na.” ");
INSERT INTO bch_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Idio ta taine toa oa iluai mulian ele lumaeai ta igera ele gergeu ienono imuliai, be iriau paeamao itnan ei ga ila o. ");
INSERT INTO bch_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Idio ta Iesus idae pade ta itnan tibur togid Tair ga Saidon ta ila boloma ngan liu kapei Galili ngan tibur togid Dekapolis. ");
INSERT INTO bch_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ila ta panua edengada tital eaba ede toa itanga kua ga imae kulupu, ta ila pan Iesus. Gid tibeta ei matua ngan idol ibage ga idae ngan eaba toa oa. ");
INSERT INTO bch_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Idio ta Iesus ibada ei ga ila ta titnan gid ipom, be gisirua kekelegid tidio. Ta idol ibage igonga ga idae ngan eaba itanga toa rua oa. Ta ipla imau ta ibage idae ngan eaba toa oa imae. ");
INSERT INTO bch_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ga kus ta Iesus imata idae ga ila buburiai ta isolil. Ta ikeo pan eaba toa oa bedane, “Epata!” (Posanga toa ne ipu bedane, “Manta pak!”) ");
INSERT INTO bch_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Be mole mao, eaba toa itanga pak ga imae imapolai ta iposaposa kemi. ");
INSERT INTO bch_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Idio ta Iesus iaoa ikarara gid ngan tiposa alele ngan danga toa oa. Ei iposa matua pagid, be mao. Gid tipaoasasa alele pagid panua busa. ");
INSERT INTO bch_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Be gid panua tilongo ngan posanga toa oa ta timatala kapei ta tikeo, “Ele kadonga toa ngada ne kemi. Ei ikado gid panua tangad kua ta tilongolongo, ga ikado panua aoad gum ta tiposaposa pade.” ");
INSERT INTO bch_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ngan ado ede toaiua, ipom kapei tiluplup pade be ad annga eta mao. Ta Iesus ibaba ele aluagau ga tinam pan ta ikeo pagid, ");
INSERT INTO bch_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Gau lolog isat ngan gid ipom toa ne, ngansa timamado toman ngan gau irangrang ngan ado tol na, be ad annga eta mao. ");
INSERT INTO bch_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Be oangga nasula gid ga tila led tuangai toman ad pitoro, eine ga tinid iura mao ta titaptap edapeai. Be edengada tilalala aluai ga tinam.” ");
INSERT INTO bch_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ta ele aluagau tikeo, “Tibur ne modamodanga. Be gita tabada annga sida irangrang ngan gid ipom toa ne?” ");
INSERT INTO bch_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Be ei ibeta gid, “Gimi ami bret pida ienono?” Ta tikeo, “Lima ga rua.” ");
INSERT INTO bch_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Tota Iesus iposa pagid ipom ta tidio timado tanoeai. Ta ibada bret toa lima ga rua oa, ta iposa kemi pan Deo ta itei. Ga kus ta ibada ga ila pagid ele aluagau ngan oadenga ga ila pagid ipom. Tota tiuade ga ila pagid. ");
INSERT INTO bch_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Be gid ad ia pidaede ienono pade, ta ei iposa kemi pan Deo ngan gid pade ta ikeo pagid, “Aoade ia toa ne ga ila pagid pade.” ");
INSERT INTO bch_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ta gid toa ngada oa tian ga apad isum. Ga kus ta tibada gid annga ilialia mulian ta tinonoi ngan samare lima ga rua. ");
INSERT INTO bch_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Gid ipom toa oa dabad iuot mambe bunoringring pange. Idio ta isula gid ga tila. ");
INSERT INTO bch_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Be mole mao, ei idae oagaeai toman ngan ele aluagau ta tila ngan tibur Dalmanuta. ");
INSERT INTO bch_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Idio ta gid Parisi tila pan Iesus ta aoad isokangai toman ngan ei. Gid tiuangga titoba ei ta tibeta ei ngan pasolannga gid ngan uisinga eta iman kilala ngan ei ikakado Deo ele naurata. ");
INSERT INTO bch_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Be ei ilolo kulupu ngan led betanga, ta iuru ei ta ikeo, “Ikamado ga gid panua labone ad tikim tigera uisinga iman kilala? Nakeo tautaunga pagimi, gimi ga agera uisinga eta mao ga mao tau.” ");
INSERT INTO bch_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Tota Iesus itnan gid ga idae oagaeai pade ta ila ngan liu isal iadag. ");
INSERT INTO bch_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Be Iesus ele aluagau matad sapian ngan badanga bret. Ad bret kelede mon ienono oagaeai. ");
INSERT INTO bch_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Idio ta Iesus ipabib led bedane, “Gimi agabit kemi. Ala aluai ngan yis togid Parisi ga ton Erot.” ");
INSERT INTO bch_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ta tiposa pol ngan gid ta tikeo ga ei ikado posanga toa oa ngansa ad bret ienono mao. ");
INSERT INTO bch_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Be ei iuatai ngan led posanga ta ikeo pagid, “Ikamado ga aposaposa ngan ami bret ienono mao? Gimi lolomi iuatai maitne? Laborami ibada maitne? Be gimi arangrang ngan abada oatainga mao? ");
INSERT INTO bch_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Gimi matami, be agera danga eta mao? Gimi tangami, be alongo posanga eta mao? Be matami nanan mao na? ");
INSERT INTO bch_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mugaeai gitaingada ipom bunoringring lima, ta natei bret toa lima oa, be gimi anonoi annga ilialia ngan karei pida?” Ta tikeo, “Sangaul ga igegea rua.” ");
INSERT INTO bch_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ta ikeo, “Be gitaingada ipom bunoringring pange, ta natei bret toa lima ga rua oa, be gimi anonoi annga ilialia ngan samare pida?” Ta tikeo, “Lima ga rua.” ");
INSERT INTO bch_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ta ikeo pagid, “Ikamado ga laborami ibada maitne?” ");
INSERT INTO bch_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Idio ta Iesus asingada ele aluagau tila ngan tuanga Betsaida. Be panua edengada tital eaba ede imata ikila ga ila pan. Ta tibeta ei matua ngan idol ibage ga idae ngan ei. ");
INSERT INTO bch_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ta ei ikisi eaba toa imata ikila oa ibage ta ibada ei ga tila gaot ngan tuanga. Ga kus ta ipla eaba toa oa imata ta idol ibage ga idae ngan ei. Ta ibeta ei, “Matam igera danga eta, mao maitne?” ");
INSERT INTO bch_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ta eaba toa oa imata idae ta ikeo, “Gau nagera panua edengada mambe abei, be tilalala alele.” ");
INSERT INTO bch_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ta Iesus idol ibage ga idae ngan eaba toa oa imata pade, ta imata pal be iuot kemi ta igera danga toa ngada oa masaeai. ");
INSERT INTO bch_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ga kus ta Iesus isula ei ga ila ele lumaeai ta ikeo pan bedane, “Lalala alele tuanga iloleai mao.” ");
INSERT INTO bch_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Idio ta Iesus asingada ele aluagau tilalala ga tila ngan gid tuanga boloma ngan Sisaria Pilipai. Be edapeai ibeta ele aluagau bedane, “Gid panua tikeo ga gau sai?” ");
INSERT INTO bch_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ta tikeo, “Panua edengada tikeo ga eao Ioanes Paliliunga aea, be padengada tikeo ga eao Elaija, be padengada tikeo ga eao eaba ede mugaeai aea ibada Deo iaoa.” ");
INSERT INTO bch_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ta ibeta gid, “Be gimi akeo ga gau sai?” Ta Petrus ikeo, “Eao Kristus.” ");
INSERT INTO bch_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Be Iesus iaoa ikarara gid ngan tiuaoa ngan ei pagid panua padengada mao. ");
INSERT INTO bch_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Idio ta Iesus ipaoatai ele aluagau ta ikeo ga Eaba Inat manta ibada ieieinga imata ede ga ede. Ta gid kapeipei togid Iuda ga gid madidnga tenainga ad ga apu ad gau tipul murid ngan ei. Ta gid ga tirau ei ga imate. Be muriai ngan ado tol, ei ga idae mulian. ");
INSERT INTO bch_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iesus iposa masaeai bedaoa, be Petrus ibada Iesus ga tila digedige ta idaba ei. ");
INSERT INTO bch_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Be Iesus ipul ei mulian ta imata ila pagid ele aluagau, ta idaba Petrus ta ikeo, “Satan, eao la aluai ngan gau! Ngansa eao nasi Deo ele kimnga mao, be eao nasi gid eababa led kimnga.” ");
INSERT INTO bch_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ta ibaba gid ipom toman ngan ele aluagau ga tinam boloma pan ta ikeo pagid, “Oangga eaba eta ikim inasi gau, manta itnan ele kimnga tano aea ga idio, ta ibisi aea abei tabala ta inasi gau. ");
INSERT INTO bch_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ngansa oangga sai igera ele madonga tanoeai mambe danga kapei tau, ei ga imate ta ele madonga iduaea. Be oangga sai imate ngan ele kadonga lolo matua aea ngan gau ga leg ato kemi, ei ga ibada madonga kemi tautaunga. ");
INSERT INTO bch_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ngansa oangga eaba eta ibabada danga sisid toa ngada ne tanoeai, be isapir ngan madonga kemi muriai ngan ele matenga, ele danga toa ngada oa ga ilua ei madongan? ");
INSERT INTO bch_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ngansa eaba eta irangrang ngan iuol ele madonga kemi muriai aea mao. ");
INSERT INTO bch_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Be oangga sai maeamaea ei ngan gau ga leg posanga labone, pagid panua kadonga sasat ad ga panua toa lolod itnan Deo somisomi, muriai Eaba Inat ga maeamaea ei pan eaba toa oa ngan ado toaiua inama ngan Itama ele taranga kapei toman ngan gid anggelo tututui.” ");
INSERT INTO bch_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ta ikeo pagid, “Nakeo tautaunga pagimi, panua edengada timadmadid toa nene ga timate maitne, be tigera Deo iura kapei ga danga toa ngada ne idae ibageai.” ");
INSERT INTO bch_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Muriai ngan ado lima ga ede, Iesus ibada Petrus ga Jems ga Ioanes kekelegid ta tidae ga tila ngan lusi ede gadae tau. Be toa eoa Iesus itin iuot ede pade matadeai. ");
INSERT INTO bch_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ele pononga iuot bodbode, be mil ga mil kapei tau. Eaba eta tanoeai irangrang ngan imum malo ga iuot bodbode toa bedaoa mao. ");
INSERT INTO bch_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Be tigera Elaija toman ngan Moses per ga tiuot, ta gisingada Iesus tiposaposa. ");
INSERT INTO bch_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Be Petrus ikeo pan Iesus bedane, “Eaba paoatainga am, eine kemi ngan tadio toa eko. Longo ta gai akado palata tol eta, eao lem ede, ga Moses ele ede, ga ede pade ton Elaija.” ");
INSERT INTO bch_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Petrus iuatai ngan saoa posanga ikakado oa mao, ngansa timataud kapei.) ");
INSERT INTO bch_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Be laulau ede irobi gid. Ta babanga ede inam laulau iloleai ga iuot ta ikeo, “Eine gau Natug. Nakim ei tau. Gimi alongo ilinge.” ");
INSERT INTO bch_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mole mao, matad kleng alele, be tigera eaba eta pade mao. Iesus kekelen idio toman ngan gid. ");
INSERT INTO bch_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Idio ta tisorir lusiai ga tisulug, ta ei iposa matua pagid ngan tikeo pan eaba eta ngan danga toa tigera oa mao ga ila irangrang ngan Eaba Inat idae mulian ngan ele matenga. ");
INSERT INTO bch_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tota timudan posanga toa oa be tibeta pol ngan gid bedane, “Posanga ngan daenga mulian ngan matenga ne ipu madongan?” ");
INSERT INTO bch_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Idio ta tibeta ei, “Ikamado ga gid madidnga apu ad tikeo ga Elaija ga inam imuga ngan Kristus?” ");
INSERT INTO bch_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ta ikeo pagid, “Tautaunga, Elaija imuga ta ipatutui danga toa ngada ne. Be ikamado ga Deo ele laulau ikeo ga Eaba Inat ga ibada ieieinga imata ede ga ede, ta panua ga tikado paeamao ngan ei? ");
INSERT INTO bch_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Be gau nakeo pagimi, Elaija imuga ga inama o. Be gid panua tinasi led kimnga ta tikado paeamao ngan ei, lalaede mambe Deo ele laulau ikeo ngan.” ");
INSERT INTO bch_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Idio ta Iesus toman ngan ele aluagau toa tol oa tila tiuot pagid aluagau padengada. Ta tigera panua busa tigong gid aluagau toa padengada oa. Be gid madidnga apu ad aoad isokangai toman ngan gid. ");
INSERT INTO bch_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Mole mao gid ipom tigera ei ta timatala ta tilado manmanae ga tila pan ta tikeo “ado kemi” pan. ");
INSERT INTO bch_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Be ei ibeta ele aluagau, “Gimingada madidnga apu ad aoami isokangai ngan saoa?” ");
INSERT INTO bch_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Be eaba ede ngan ipom toa oa ikoli ele posanga ta ikeo, “Eaba paoatainga am, gau labone natal natug ga inam pago. Iriau paeamao ienono ngan ei ta ikado ei ga iaoa gum. ");
INSERT INTO bch_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Somisomi iriau paeamao toa ne ibada ei ta itado ei ga isulug tanoeai. Ikado ga ingarongaro iuotot iaoai, ga iluo kek ga kek, be itin toa ngada oa igagagai. Ta nabeta lem aluagau ngan serenga iriau paeamao toa ne, be tirangrang mao.” ");
INSERT INTO bch_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ta Iesus ikeo pagid, “O gimi panua labone ami! Lolomi matua eta mao. Papida ga namamado toman ngan gimi ga nabisi ami kadonga kulupulupu? Atal gergeu toa na inam pagau.” ");
INSERT INTO bch_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Tota tital ei ga ila pan. Be mole mao iriau paeamao igera ei ta inuga gergeu ta itap ga isulug tanoeai. Ipulpul ei alele ga ingarongaro iuotot iaoai. ");
INSERT INTO bch_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ta Iesus ibeta itama, “Aea kadonga toa ne iuot ngeda?” Ta itama ikeo, “Ikado ei toa ngan ei kakauede ngan oa. ");
INSERT INTO bch_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Somisomi iriau paeamao iuangga ipaeabu ngan ei ta itado ei ga idae dingaeai ga eauiai. Be oangga eao rangrang, eao uduan gai ta lua gai.” ");
INSERT INTO bch_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Be Iesus ikeo pan, “Eao kamado keo, ‘Oangga narangrang’? Eaba sai ilolo matua ngan Deo, saoa danga ibeta ei ngan, eine irangrang ngan iuot.” ");
INSERT INTO bch_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Be gergeu itama ibaba ta ikeo, “Gau lolog matua ngan ei, be lua gau ta irangrang ngan lolog ruangada mao!” ");
INSERT INTO bch_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Io, Iesus igera ipom kapei tilado ga tinam tiluplup, ta idaba iriau paeamao ta ikeo, “Iriau paeamao, toa kakado panua aoad gum ga tangad kua ne, naposa matua pago, tnan gergeu toa ne, be dudunga pan pade mao.” ");
INSERT INTO bch_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ta iriau paeamao ingangar kapei ga inuga gergeu toa oa paeamao tau ta itnan ei ga ila. Be gergeu idio ienono tanoeai mambe imate, ta gid panua tikeo ga, “Ei imate!” ");
INSERT INTO bch_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Be Iesus ikisi ibage ta ipei ei ga idae imadid. ");
INSERT INTO bch_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Idio ta Iesus ila lumaeai ta imado toman ngan ele aluagau kekelegid. Ta tibeta ei, “Ikamado ga gai arangrang ngan serenga iriau paeamao toa oa mao?” ");
INSERT INTO bch_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ta ikeo, “Ngan raring kekelen tarangrang ngan serenga iriau papaeamao toa bedaoa. Edap eta pade mao.” ");
INSERT INTO bch_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Idio ta Iesus asingada ele aluagau titnan tuanga toa oa ta tilalala ngan tibur Galili. Be ei itin ngan eaba eta iuatai ngan ei mao, ");
INSERT INTO bch_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ngansa ei ipapaoatai ele aluagau. Ta ikeo pagid, “Gid panua ga tidol Eaba Inat ga idae pagid panua bagedeai. Ta gid ga tirau ei ga imate. Be ado tol muriai ngan ele matenga, eine ga idae mulian.” ");
INSERT INTO bch_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Be gid aluagau tiuatai ngan posanga toa oa ipu mao. Be timataud ngan betanga ei pade. ");
INSERT INTO bch_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Idio ta Iesus asingada ele aluagau tila Kapernaum ta tidudunga lumaeai. Be ei ibeta gid bedane, “Toa edapeai oa aoami isokangai ngan saoa?” ");
INSERT INTO bch_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Be gid tikoli ele posanga eta mao, ngansa toa edapeai oa aoad isokangai ngan sai ngan gid ieda ga iuot kapei tau. ");
INSERT INTO bch_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ei idio imado ga kus ta ibaba gid toa sangaul igegea rua oa ga tinam pan ta ikeo pagid, “Sai ikim ieda iuot kapei, ei manta idol ieda ga isulug gadio tau ngan gimi toa ngada ne ga iman lemi paeaeanga.” ");
INSERT INTO bch_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ta ei ibada gergeu ede ta idol ei rabu ngan gid. Ikisi ei ta ikeo pagid bedane, ");
INSERT INTO bch_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Oangga sai ibada gergeu kelede toa bedane ngan gau edag ta ilua ei, eine ibada gau ta ilua gau. Be eaba sai ibada gau, eine ibada gau kekelegau mao, be ibada Eaba toa isula gau ga nanam ne.” ");
INSERT INTO bch_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Be Ioanes ikeo pan Iesus bedane, “Eaba paoatainga am, gai agera eaba ede isere iriau papaeamao ngan eao edam. Be gai apaidi ei, ngansa ei inasnasi gita mao.” ");
INSERT INTO bch_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Be Iesus ikeo, “Apaidi ei mao. Ngansa oangga eaba eta ikado uisinga ngan gau edag, eine ga irangrang ngan ipul ei manmanae ta iposa paeamao ngan gau mao. ");
INSERT INTO bch_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngansa eaba sai iman gita ada isat mao, ei ilualua gita. ");
INSERT INTO bch_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nakeo tautaunga pagimi, oangga sai igera gimi anasi gau Kristus, ta ipaun gimi ngan eau, eine Deo ga ilasu ei. Irangrang ngan eaba toa oa isapir ngan badanga aea lasunga mao.” ");
INSERT INTO bch_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iesus ikeo pade bedane, “Gid leg panua toa edad mao bedane, gid lolod matua ngan gau kemi. Be oangga sai ipabuobuo eta ngan gid ta ele kadonga lolo matua aea itap, eine Deo ga ipanas eaba toa oa paeamao tau. Kemi ngan tikaukau eaba toa oa igagal ngan pat kapei ede ta titado ei ga isulug tadiai motean. Toa bedaoa ta irangrang ngan ipabuobuo eta ngan gid mao. ");
INSERT INTO bch_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tota oangga bagem eta ikado ga lem kadonga lolo matua aea itap, ket bagem toa ga iduaea. Kemi ngan bagem kelede ta eao la ngan madonga kemi. Kado bagem rua be eao la ngan dinga imperno. Dinga toa oa irangrang ngan imate mao. ");
INSERT INTO bch_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ga oangga aem eta ikado ga lem kadonga lolo matua aea itap, ket aem toa ga iduaea. Kemi ngan aem kelede ta eao la ngan madonga kemi. Kado aem rua be eao la ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ga oangga matam eta ikado ga lem kadonga lolo matua aea itap, pasu matam toa ga iduaea. Kemi ngan matam kelede ta la mado Deo ibageai. Kado matam rua, be Deo itado go ga la ngan dinga imperno. ");
INSERT INTO bch_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“‘Toa eoa motamota tianean panua papaeamao somisomi, ga dinga toa eoa irangrang ngan imate mao.’ ");
INSERT INTO bch_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ngansa sol mambe dinga ga itaptap ga idae ngan panua toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Sol eine danga kemi. Be oangga imana kus, irangrang ngan gimi akado ga imana iluai mulian pade mao. Gimi manta aot mambe sol ta apapot kadonga lolo tarui aea pol ngan gimi.” ");
INSERT INTO bch_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Idio ta Iesus itnan tuanga toa oa ta inasi edap iadag ngan eau Iordan ta iuore ga ila ngan tibur Iudea. Be ipom kapei tinam tiluplup pan pade. Ta ei inasi ele kadonga mambe somisomi ta ipaoatai gid. ");
INSERT INTO bch_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Be gid Parisi tinam boloma pan ngan tobanga ei, ta tibeta ei bedane, “Oangga eaba iket ele oainga ta isuk iadaoa, eine tutui, mao madongan?” ");
INSERT INTO bch_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ei ikoli led posanga ta ibeta gid, “Moses ikado posanga madongan pagimi?” ");
INSERT INTO bch_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ta tikeo, “Moses ilongo ngan eaba ibode laulau ngan ketnga oainga ta ibada pan iadaoa ta isuk ei ga ila.” ");
INSERT INTO bch_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ta Iesus ikeo pagid, “Gimi apaki tangami ngan Deo ele posanga somisomi tau, tota Moses ibode apu toaine pagimi. ");
INSERT INTO bch_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Be mugaeai tau, Deo ikado danga toa ngada ne ga iuot, be ‘ikado gid panua ga tiuot arangaranga ga taine.’ ");
INSERT INTO bch_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ta ele laulau ikeo pade ga bedane, ‘Ngan ipu toaine, eaba ga itnan itama ga itna ta ila ilup toman ngan iadaoa, ");
INSERT INTO bch_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ta eine mambe gisirua tinid iuot kelede.’ Toa bedaoa ta tirangrang ngan timan rua pade mao. Gisirua tiuot kelede Deo imatai. ");
INSERT INTO bch_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Tota danga toa Deo ikaukau, irangrang ngan eaba eta iket mao.” ");
INSERT INTO bch_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Idio ta idudunga lumaeai ta ele aluagau tibeta ei ngan posanga idil toa ne pade. ");
INSERT INTO bch_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ta ikeo pagid, “Oangga sai isuk iadaoa ta iuai taine pau, eine ikado kadonga arala iadaoa mugamuga imatai. ");
INSERT INTO bch_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ga oangga taine itnan iadaoa ta iuai eaba pau, ei pade ikado kadonga arala iadaoa mugamuga imatai.” ");
INSERT INTO bch_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Idio ta gid panua tital gid gergeu ga tila pan Iesus. Ta tiuangga ei idol ibage ga idae ngan gid. Be ele aluagau tidaba gid. ");
INSERT INTO bch_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Be ei igera ta ilolo bake ta ikeo, “Alongean gid gergeu ga tinam pagau. Apaidi gid mao, ngansa madonga Deo ibageai eine togid panua toa bedane. ");
INSERT INTO bch_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nakeo tautaunga pagimi: Oangga sai ilongean Deo ga iman aea maron lalaede mambe gid gergeu toa ne mao, eine ga irangrang ngan ibada madonga Deo ibageai mao.” ");
INSERT INTO bch_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Idio ta ikisi gid gergeu kelede kelede, ta idol ibage ga idae ngan gid ta ikado posanga kemi ngan pamatuanga gid. ");
INSERT INTO bch_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Idio ta Iesus ilalala edapeai, be eaba ede ilado ga ila pan ta ikor iae ta ibeta ei bedane, “Eaba kemi paoatainga am, gau ga nakado mado ta nabada madonga kemi somisomi?” ");
INSERT INTO bch_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Be Iesus ikeo pan, “Eao oato gau ‘eaba kemi’ ngan saoa? Eaba eta pade kemi mao. Deo kekelen ei kemi. ");
INSERT INTO bch_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Be eao oatai ngan Deo ele apu. Ikeo ga bedane, ‘Eao pamate eaba ede pade mao. Eao kado arala ta paeabu ngan oainga mao. Eao lublub mao. Oangga eao madid ngan posanga, irangrang ngan eao pakaka mao. Irangrang ngan eao pakaka eaba ede pade ta bada ele danga sisid mao. Manta lolon ngan tamam ga tnam ta nasi linged.’” ");
INSERT INTO bch_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ta eaba toa oa ikeo, “Eaba paoatainga am, mugaeai gau kakauede ga irangrang ngan labone, gau nanasnasi gid apu toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Iesus imata inono ei be ikim ei tau ta ikeo, “Lem idil kelede mon imata karanga maitne. La longean lem danga sisid toa ngada oa pagid panua ta tiuol. Ta bada lem pat ta oade ga ila pagid panua lululunga ad. Toa bedaoa ta lem danga sisid kemikemi ienono buburiai. Ga kus ta nam nasi gau.” ");
INSERT INTO bch_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ei ilongo posanga toa ne ta imata imalai, be ilolo itangtang ta itnan ei ga ila. Ngansa ele danga sisid busa. ");
INSERT INTO bch_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iesus imata igera pol gid ele aluagau ta ikeo, “Eine kulupu tau ngan gid panua toa led danga sisid busa ngan tibada madonga Deo ibageai!” ");
INSERT INTO bch_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Be gid aluagau tikakrik ngan ele posanga toa ne. Be ikeo pagid pade, “Leg gergeu, eine kulupu tau ngan gid panua ngan tibada madonga Deo ibageai! ");
INSERT INTO bch_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Oangga kamel itoba ngan ipurususu ngan salumu aea baba, eine ga kulupu ngan ei, mao madongan? Be kulupu ga kulupu tau ngan eaba sai toa ele danga sisid busa, ngan ibada madonga Deo ibageai.” ");
INSERT INTO bch_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ta gid aluagau tikakrik kapei tau ta tibetabeta pol ngan gid, “Toa bedaoa ta sai irangrang ngan Deo ibada ei mulian?” ");
INSERT INTO bch_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Be Iesus imata ila pagid ta ikeo, “Gid eababa tirangrang mao. Be danga eta ikulupu ngan Deo mao. Ei irangrang ngan ikado danga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Be Petrus ikeo pan bedane, “Ega, gai atnan lemai danga sisid toa ngada oa ta anama anasi go!” ");
INSERT INTO bch_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ta Iesus ikeo, “Nakeo tautaunga pagimi, oangga sai itnan ele luma, ga itar kapeipei, ga aea kakakau, ga iliuliu, ga itna, ga itama, ga ele gergeu, ga aea dadanga, ngan luanga gau ga leg ato kemi, ");
INSERT INTO bch_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","eine Deo ga ikoli buno pade pan eaba toa oa. Ei ga ibada gid luma, ga itar kapeipei, ga aea kakakau, ga iliuliu, ga itnatna, ga gid gergeu, ga gid dadanga. Eaba toa oa ga imamado tanoeai maitne, be Deo ga ikoli kemi pan bedaoa. Be ei ga ibada ieieinga pagid panua papaeamao bagedeai pade. Be muriai ei ga ibada madonga kemi somisomi ga ilalala ga ila. ");
INSERT INTO bch_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Be panua busa toa edad kapei labone, muriai edad ga isulug. Be panua busa toa edad mao labone, muriai edad ga iuot kapei.” ");
INSERT INTO bch_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Idio ta Iesus asingada ele aluagau tinasi edap ila ngan tuanga Ierusalem, be Iesus imugamuga ngan gid. Ele aluagau timatala, be gid panua toa tinasnasi gid oa timataud. Be ei ibada ele aluagau sangaul igegea rua ta iaoa inasi pagid pade ngan saoa danga ga iuot toa eoa. ");
INSERT INTO bch_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ta ikeo, “Ega, gita talalala ga tala Ierusalem, be gid panua ga tidol Eaba Inat ga idae pagid madidnga tenainga ad ga apu ad bagedeai. Ta gid ga tipamadid ei ngan posanga ta tirau posanga ngan pamatenga ei. Eine ga tidol ei ga idae pagid alu padengada bagedeai. ");
INSERT INTO bch_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ta gid ga tigalinge paeamao ngan ei, ga tiplapla ei, ga timuimui ei, ga tirau ei ga imate. Be muriai ngan ado tol, eine ga idae mulian.” ");
INSERT INTO bch_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Idio ta Sebedi ele gergeu rua, Jems ga Ioanes, tila boloma pan Iesus ta tikeo, “Eaba paoatainga am, gairua akeo ga eao kado saoa danga gai abeta go ngan.” ");
INSERT INTO bch_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ta ikeo, “Akim nakado mado ngan gimirua?” ");
INSERT INTO bch_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ta tikeo pan, “Muriai oangga edam iuot kapei tau, gai akim eao longo ngan gairua abada edaeda kapei toman ngan eao, ta ede ngan gai imado ngan bagem oatai, be ede pade imado ngan bagem angas.” ");
INSERT INTO bch_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Be Iesus ikeo pagisirua, “Gimirua aoatai ngan saoa danga abeta ngan ne mao. Loba ieieinga aea toa teta pade ga naun, gimi arangrang ngan aun pade? Be paliliunga toa teta pade nabada, gimi arangrang ngan abada pade?” ");
INSERT INTO bch_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ta gisirua tikeo pan, “Be. Gairua arangrang.” Ta Iesus ikeo pagisirua, “Tautaunga, gimirua ga aun loba ieieinga aea mambe gau naun, ga abada paliliunga ieieinga aea mambe gau pade. ");
INSERT INTO bch_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Be sapadua ga timado ngan bageg oatai ga bageg angas, eine danga togau mao. Deo kekelen ibada gid mul toa ne pagid panua toa ei isio.” ");
INSERT INTO bch_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Io, gid aluagau padengada tilongo posanga toa oa ta lolod bake ngan Jems ga Ioanes. ");
INSERT INTO bch_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Be Iesus ibaba gid ga tinam pan ta ikeo pagid, “Gid panua toa tibada edaeda mambe madidnga togid alu padengada, gimi aoatai ngan led kadonga na. Timadid matua ta tipaeaea led panua. Ga led panua toa edad kapeipei tikado kulupu tau ngan gid. ");
INSERT INTO bch_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Be irangrang ngan gimi anasi kadonga toa ne mao. Be sai ngan gimi iuangga ieda iuot kapei, manta ikado naurata ngan luanga gimi. ");
INSERT INTO bch_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ga sai iuangga imadid ga imuga ngan gimi, ei ga iman paeaeanga ngan gimi toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ngansa Eaba Inat, ei pade inama ngan gid panua tilua ei mao, be ei inama ngan luanga gid panua. Ta ilongean ei mulian ga imate ngan patutuinga panua busa ad gigi kapei Deo imatai.” ");
INSERT INTO bch_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Idio ta Iesus toman ngan ele aluagau tila Ieriko. Ta gisingada ipom kapei titnan Ieriko ga tila. Be Bartimeus, gergeu ton Timeus, imamado edap isaleai. Ei imata sususu, be somisomi igaugau pat ga danga sisid pagid panua. ");
INSERT INTO bch_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ei ilongo ngan Iesus Nasaret aea ilalala ga inam ta ibaba matua bedane, “Iesus, Devit itub, uduan gau.” ");
INSERT INTO bch_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Be panua busa tidaba ei ta tikeo, “Eao mumun!” Be mao. Ei ibaba matua pade, “Devit itub, uduan gau!” ");
INSERT INTO bch_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ta Iesus iae tor ga imadid ta ikeo, “Ababa ei ga inam.” Tota tibaba eaba toa imata sususu oa, ta tikeo pan, “Lolom pu ta dae madid. Ei ta ibaba go!” ");
INSERT INTO bch_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Tota itado ele pononga mamarae ga idio ta manmanae idug ga idae imadid ta ila pan Iesus. ");
INSERT INTO bch_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ta Iesus ibeta ei bedane, “Eao kim nakado mado ngan go?” Ta eaba toa imata sususu oa ikeo, “Eaba paoatainga am, gau nakim matag pal ta nageragera pade.” ");
INSERT INTO bch_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ta Iesus ikeo pan, “Eao la. Lem kadonga lolo matua aea ikado ga matam iuot kemi.” Mole mao, eaba toa oa igeragera pade ta inasi Iesus toa edapeai oa. ");
INSERT INTO bch_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Idio ta Iesus asingada ele aluagau tipaboloma Ierusalem ta tiuot ngan tuanga Betpage ga Betani boloma ngan bereo Oliv. Ta ei isula ele aluagau rua ");
INSERT INTO bch_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ta ikeo pagisirua, “Gimirua ala ngan tuanga ga matadai ne. Be tutui ngan gimirua ala aot toa eoa, gimi ga agera donki daenga pau ede tikaukau ngan oaro. Donki toa oa, eaba eta imado ngan maitne. Apola aea oaro ta abada ei ga inam. ");
INSERT INTO bch_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Be oangga eaba eta ibeta gimirua, ‘Ikamado ga akado bedane?’ gimi ga akoli ele posanga bedane, ‘Maron ele bokonga ngan. Be mole mao ei ga isula ei ta iluai mulian toa nene.’” ");
INSERT INTO bch_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Idio ta gisirua tila ta tigera donki toa oa. Panua tikaukau ei atama iaoai boloma edap isaleai. Tota gisirua tipola aea oaro. ");
INSERT INTO bch_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Be panua edengada timadmadid toa eoa tikeo pagisirua, “Gimirua akado mado ga apola donki aea oaro?” ");
INSERT INTO bch_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ta tikeo pagid mambe Iesus ikeo ngan. Tota panua toa oa tilongo, ");
INSERT INTO bch_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ta gisirua tibada donki ga ila pan Iesus. Ta tidol led pononga mamarae ga idae donki ipaoeai ta Iesus idae imado ngan. ");
INSERT INTO bch_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Be panua busa tilalo led pononga mamarae ga idio edapeai, be padengada tila dadangai ta tiket abei ilaun ga inam ta tilalo edapeai pade. ");
INSERT INTO bch_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Panua busa tilalala ga timuga ngan ei, be padengada tilalala muriai ta tibaba bedane, “Maron, gai asoa edam ga idae! Maron ipamatua eaba toa inama ngan ei ieda ne!” ");
INSERT INTO bch_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Maron ipamatua eaba toa ne, ta ei ga imadid ga imugamuga ngan gita mambe tibuda Devit mugaeai. Tasoa Maron ieda gadae tau!” ");
INSERT INTO bch_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tota Iesus iuot Ierusalem ta idudunga ngan Deo ele luma aea ala, ta imata igera alele danga toa ngada oa. Be ado iuangga idil, tota iuot ga ila Betani toman ngan ele aluagau sangaul ga igegea rua. ");
INSERT INTO bch_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ngan ado sae Iesus asingada ele aluagau titnan Betani ta tilalala pade, be Iesus pitoreanei. ");
INSERT INTO bch_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ei igera abei fik ede toa ilaun iuotot ga imadmadid boloma tede. Ta ei ila boloma, ngansa iuangga igera, itautau eta ienono, mao mao. Be itautau eta mao. Ilaun kekelen ienono, ngansa aea laoe maitne. ");
INSERT INTO bch_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tota ikeo pan abei toa oa bedane, “Irangrang ngan eaba eta ian tautaudim pade mao ga ilalala ga ila.” Be ele aluagau tilongolongo posanga toa oa. ");
INSERT INTO bch_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Idio ta Iesus asingada ele aluagau tila tiuot Ierusalem. Ei idudunga ngan Deo ele luma aea ala ta isere gid panua tibokoboko ngan pat aea badanga ga gid panua tiuolol danga sisid Deo ele lumaeai. Ta ipatabul gid popou togid panua tilaumalile ngan pat, ga ipatabul gid mul madonga aea togid panua toa tilongean gid man barur ga panua tiuolol. ");
INSERT INTO bch_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ta ipakala gid panua ngan badanga danga sisid ga idudunga ngan Deo ele luma aea ala. ");
INSERT INTO bch_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ta ipaoatai gid ta ikeo, “Deo ele laulau aea posanga ga bedane, “‘Gau leg luma, gid panua ga tiuato luma raring aea togid alu toa ngada ne.’ Be gimi apul ga iman baba mumulnga aea togid panua lublubnga ad.” ");
INSERT INTO bch_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Idio ta gid madidnga tenainga ad ga apu ad tilongo bedaoa ta tiloilo edap ngan pamatenga ei. Be timataud ei, ngansa gid ipom timatala ngan ele paoatainga. ");
INSERT INTO bch_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Idio ga lailai, Iesus asingada ele aluagau titnan tuanga ga tila. ");
INSERT INTO bch_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gaisala ngan ado sae Iesus asingada ele aluagau tilalala ga tila ta tigera abei fik toa Iesus iposa ngan. Be iuaroar ga ilaun toa ngada oa imalai ga imisi. ");
INSERT INTO bch_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ta Petrus imata nanan Iesus ele posanga ta ikeo, “Eaba paoatainga am, gera. Abei fik toa made eao posa ngan, tota imisi!” ");
INSERT INTO bch_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ta Iesus ikoli ele posanga ta ikeo, “Manta lolomi matua ngan Deo. ");
INSERT INTO bch_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nakeo tautaunga pagimi, oangga sai ikeo pan lusi ga oaine bedane, ‘Eao dae ta dug ga sulug tadiai,’ ta eaba toa oa ilolo ruangada mao, be ilolo matua ta iadi mambe ele posanga toa oa ga iuot, eine ga iuot tautaunga ngan ei. ");
INSERT INTO bch_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ngan ipu toaine nakeo pagimi, saoa danga gimi araring ta abeta Deo ngan, manta lolomi matua ta aeadi mambe lemi posanga toa oa ga iuot. Ta eine ga iuot tautaunga ngan gimi. ");
INSERT INTO bch_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Be oangga amadid ga araring ta matami nanan ami gagal pan oaemi ede pade ngan ele idil paeamao eta, manta asamum ele kadonga sat toa oa. Toa bedaoa ta Tamami toa buburiai oa ga isamum gimi lemi kadonga sasat pade.” ");
INSERT INTO bch_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Idio ta Iesus asingada ele aluagau tila Ierusalem pade. Ei ilalala gadudunga ngan Deo ele luma aea ala, be gid madidnga tenainga ad ga apu ad ga gid kapeipei togid Iuda tila pan. ");
INSERT INTO bch_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ta tibeta ei bedane, “Sai idol naurata toa ne ga idae bagemeai ta isula go ngan aea kadonga?” ");
INSERT INTO bch_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ta Iesus ikeo pagid, “Gau pade ga nabeta gimi ngan posanga ede. Ta oangga akoli leg posanga, eine ga nakeo pagimi ngan sai isula gau ngan kadonga naurata toa ne. ");
INSERT INTO bch_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Paliliunga toa Ioanes ikakado mugaeai, eine inam buburiai ga inam, mao inam pagid eababa? Akoli leg posanga!” ");
INSERT INTO bch_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Be tiraurau posanga pol ngan gid ta tikeo, “Oangga takeo ga inam buburiai ga inam, eine ga ikeo, ‘Ikamado ga lolomi matua ngan ele posanga mao?’ ");
INSERT INTO bch_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Be irangrang ngan takeo ga inam pagid eababa mao pade.” Tikeo bedaoa ngansa timataud gid ipom, ngansa gid busa tiadi mambe Ioanes ibada Deo iaoa tautaunga. ");
INSERT INTO bch_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Tota tikoli Iesus ele posanga bedane, “Gai aoatai mao.” Ta ikeo pagid, “Goibe, gau pade ga nakeo pagimi mao ngan sai isula gau ngan kadonga naurata toa ne.” ");
INSERT INTO bch_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Idio ta Iesus itatado gid oanenga itna pagid ta ikeo, “Eaba ede iarum gid abei oain aea dadangai. Ei itado ala ngan ga ikado tibur ede kemi ngan bibnga oain itautau ta tibada isul ngan. Ga ikado luma mamarae ede ngan gid panua timadid ngan ta matad ikilele. Ga kus ta ilongean dadanga toa oa pagid panua naurata ad bagedeai, be ei ila ngan tibur ede pade aluai. ");
INSERT INTO bch_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Idio ta oain aea laoe iuot, ta isula ele paeaeanga ede ga ila pagid panua naurata ad ngan badanga oain itautau idanga etangada ga inam pan. ");
INSERT INTO bch_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Be gid tiluku ei ta tirau ei ta tisere ei ga iluai sapaean. ");
INSERT INTO bch_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Be dadanga itama isula ele paeaeanga ede pade ga ila pagid, be tirau ei ga idae ilaborai ga tipamaeamaea ei. ");
INSERT INTO bch_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Idio ta isula ele paeaeanga ede pade ga ila, be tirau ei ga imate. Tota isulasula ele paeaeanga busa pagid, be tiraurau edengada ga tipapamate padengada. ");
INSERT INTO bch_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Ila ga ele eaba kelede idio. Eaba toa oa, ei inat toa ikim ei tau. Dadanga itama isula ei ga ila muriai ngan ele paeaeanga toa ngada oa ta ikeo, ‘Eine ga tilolon ngan natug.’ ");
INSERT INTO bch_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Be gid panua naurata ad tiposa pol ngan gid bedane, ‘Eaba toa ne muriai ga ibada danga sisid toa ngada ne ton itama. Io, tarau ei ga imate. Ta ele danga sisid toa ngada ne ga iman leda!’ ");
INSERT INTO bch_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Tota tiluku ei ta tirau ei ga imate. Be titado ipat ga ila gaot ngan dadanga aea ala. ");
INSERT INTO bch_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Toa bedaoa ta dadanga itama ga ikado mado? Eine ga inam ta ipaeabu ngan gid panua naurata ad ta idol dadanga oain ga idae pagid panua padengada bagedeai. ");
INSERT INTO bch_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Posanga ga oaine ienono ngan Deo ele laulau, be kado gimi aoato mao? Ikeo bedane, “‘Pat toa ne, gid panua tikakado luma tiuangga eine paeamao ta titado ga iduaea. Be labone iman luma aea kisinga. ");
INSERT INTO bch_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Maron ikado ga iuot bedane, ta gai agera eine kemi tau ta amatala ngan.’” ");
INSERT INTO bch_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Be gid tiuangga tiluku ei, ngansa tiuatai mambe ei itado oanenga itna toa ne ga idodo gid. Be timataud gid ipom, tota titnan ei ga tila. ");
INSERT INTO bch_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Idio ta gid madidnga tisula Parisi edengada toman ngan Erot ele panua edengada ga tila pan Iesus. Tiuangga tipabuobuo ei ngansa tikim tigera ei ikado posanga idil eta paeamao ta irangrang ngan tipamadid ei ngan posanga. ");
INSERT INTO bch_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Tota tila tikeo pan bedane, “Eaba paoatainga am, gai aoatai mambe eao eaba posanga tautaunga am. Eao kado kadonga bagbage kelede mao ga mao tau, ngansa eao mataud eaba eta mao. Be eao papaoatai gid panua ngan Deo ele edap tautaunga. Be keo pagai, eine tutui ngan taol takis ga ila pan Kaisa, mao madongan? Eao keo ga gita manta taol, mao mao?” ");
INSERT INTO bch_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Be Iesus iuatai ngan led pakakanga ta ikeo pagid, “Ikamado ga atoba gau? Abada pat eta ga inam ta nagera!” ");
INSERT INTO bch_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Io, tibada ga ila pan, ta ibeta gid, “Sai ianun ga ieda ienono ngan pat toa ne?” Ta tikeo, “Kaisa ianun ga ieda.” ");
INSERT INTO bch_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ta Iesus ikeo pagid, “Io, danga ton Kaisa, abada ga ila pan Kaisa, be danga ton Deo, abada ga ila pan Deo.” Gid tilongo ele posanga ta tikakrik ngan ei. ");
INSERT INTO bch_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Idio ta gid Sadiusi tila pan Iesus. Gid tikeo ga panua matemate tirangrang ngan tidae mulian mao. Ta tikeo pan bedane, ");
INSERT INTO bch_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Eaba paoatainga am, Moses ibode apu ede pagita ta ikeo ga, ‘Oangga eaba eta itar kapei imate ta itnan iadaoa ga idio, be ele gergeu eta mao, manta itar kakau iuai asape toa oa ta tipopo itar kapei aea kolinga eta.’” ");
INSERT INTO bch_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“Be ado ede, arangaranga lima ga rua ngan iaoa ede timamado. Ad lautabe iuai taine, ga kus ta imate, be gisirua led gergeu eta mao. ");
INSERT INTO bch_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Tota itar kakau atange iuai asape toa oa, be ei pade ipopo gergeu mao ga imate. Ga kus ta itar kakau tol aea iuai ei ga imate toa bedaoa pade. ");
INSERT INTO bch_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Kadonga lalaede iuot ngan gid arangaranga toa lima ga rua oa. Tipopo gergeu mao be timate. Ta muriai taine toa oa imate pade. ");
INSERT INTO bch_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Tota ngan ado toaiua, oangga gid matemate tidae mulian, taine toa oa ga iman sai iadaoa? Ngansa gid toa lima ga rua oa tiuai ei.” ");
INSERT INTO bch_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ta Iesus ikeo pagid, “Gimi abuobuo ngansa aoatai ngan Deo ele laulau aea posanga mao, ga aoatai ngan iura mao pade. ");
INSERT INTO bch_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ngansa muriai, oangga panua matemate tidae mulian, eine ga tiuaioai mao ga tipapaoai led gergeu mao pade. Be gid ga tiuot mambe gid anggelo buburiai. ");
INSERT INTO bch_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Be posanga ngan gid matemate tidae mulian ienono ngan Moses ele laulau, be gimi aoato mao? Ikeo ga Deo ele babanga iuot abei kakauede iloleai ta ikeo pan Moses bedane, ‘Gau Deo ton Abraam ga Aisak ga Iakop.’ ");
INSERT INTO bch_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Agera, ei Deo togid panua matemate mao. Ei Deo togid panua matad bibita. Gimi abuobuo kapei tau.” ");
INSERT INTO bch_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Be madidnga ede apu aea ilongolongo gid Sadiusi aoad kaukau pan Iesus, ta igera mambe ei ikoli led posanga kemi tau, ta ibeta ei bedane, “Deo ele apu isaoa kapei ngan apu toa ngada oa?” ");
INSERT INTO bch_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ta Iesus ikoli ele posanga bedane, “Apu ga oaine kapei ga kapei tau. Eine ga bedane, ‘Gimi Israel alongo! Maron Deo togita ei Deo kelede. Ei kekelen Maron. ");
INSERT INTO bch_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Be eao manta kim tau am Maron Deo kapei tau ngan lolom, ga tautaudim, ga lem oatainga, ga uram.’ ");
INSERT INTO bch_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Be apu kapei ede pade eine ga bedane, ‘Eao manta kim lem eaba ede pade mambe kim go mulian.’ Apu eta pade kapei mambe toa rua ne mao.” ");
INSERT INTO bch_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ta madidnga apu aea toa oa ikeo pan bedane, “Eaba paoatainga am, lem posanga kemi. Tautaunga Deo kekelen ei Maron, be Deo eta pade mao, mambe eao keo. ");
INSERT INTO bch_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ga manta takim ei tau ngan loloda, ga leda oatainga, ga urada. Ga manta takim eaba ede pade mambe takim gita mulian. Oangga tanasi apu toa rua ne, eine kadonga toa ne iasal gid tenainga imata ede ga ede ga gid tenainga tinono ngan dinga ga imomout ga kus.” ");
INSERT INTO bch_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ta Iesus igera mambe eaba toa oa ikoli posanga mambe ei eaba oatainga aea kemi ta ikeo, “Eao boloma ngan badanga madonga Deo ibageai.” Idio ta gid panua timataud ngan betanga Iesus ngan posanga eta pade. ");
INSERT INTO bch_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Idio ta Iesus ipapaoatai gid panua gadudunga ngan Deo ele luma aea ala ta ikeo, “Ikamado ga gid madidnga apu ad tikeo ga Kristus eine iaoa kelede pan Devit? ");
INSERT INTO bch_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ngansa ngan pamatuanga inam pan Itautau Tutui, Devit ikeo, “‘Maron Deo ikeo pan ag Maron bedane: “Eao dio mamado ngan bageg oatai, ga irangrang ngan nadol am miri itamatama ga tidio aem ibuloloeai.” ’ ");
INSERT INTO bch_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Agera, Devit pade iuato eaba toa oa aea Maron. Tota ei ga iuot ngan iaoa kelede pan Devit madongan?” Be gid ipom tinid igelgel ngan longonga Iesus ele posanga. ");
INSERT INTO bch_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Idio ta Iesus ipapaoatai gid ipom ta ikeo, “Gimi agabit kemi ngan gid madidnga apu ad. Gid tikim tau ngan dolnga pononga mamarae ta tilalala alele. Ga oangga tila ngan tibur oalo aea, tikim panua busa tikeo ‘ado kemi’ ta tilolon ngan gid. ");
INSERT INTO bch_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ga oangga tila ngan luma raring aea, ga tila ngan gid eaneannga kapeipei, gid tikim tau ngan badanga mul kemikemi togid panua edad kapeipei. ");
INSERT INTO bch_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Be tipakaka gid asapsape ta tibabada sapaean led luma ga danga sisid. Ga kus ta tiraring mamarae, be led raring eine pakakanga aea. Muriai gid ad panasnga ga paeamao ga paeamao tau.” ");
INSERT INTO bch_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Idio ta Iesus imamado boloma ngan apou tenainga aea toa Deo ele lumaeai. Ei igeragera gid ipom tinam tidoldol led pat ga idudunga ngan apou toa oa. Panua busa toa led pat ga danga sisid busa tidoldol led pat kapeipei. ");
INSERT INTO bch_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Be asape ede lululunga aea inam ta idol pat gereirei rua. Pat toa oa irangrang mambe pat singsingia kelede. ");
INSERT INTO bch_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ta Iesus ikamo ele aluagau ga tinam pan ta ikeo pagid, “Nakeo tautaunga pagimi, asape lululunga aea toa ne ele tenainga iasal tenainga togid panua toa ngada ne. ");
INSERT INTO bch_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ngansa gid toa ngada oa led danga sisid busa ta tipota ilia iman led tenainga. Be asape toa ne, ele danga sisid imata karanga mao, be ei idol ele pat madonga aea toa ngada oa ga kus.” ");
INSERT INTO bch_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Idio ta Iesus iuangga itnan Deo ele luma ta ilalala ga ila, be ele aluagau ede ikeo pan bedane, “Eaba paoatainga am, gera Deo ele luma aea mosi kemi tau ga aea pat kapeipei!” ");
INSERT INTO bch_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ta Iesus ikoli ele posanga bedane, “Eao gera gid luma kapeipei toa ne aea mosi kemi na? Muriai luma toa ne aea pat eta ga idae tatan pat eta pade mao. Eine ga tirepe toa ngada ne ga isulug.” ");
INSERT INTO bch_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Idio ta Iesus idio imado ngan bereo Oliv ta igera Deo ele luma imadmadid iadag. Be Petrus ga Jems ga Ioanes ga Andreas kekelegid tila pan ta tibeta ei bedane, ");
INSERT INTO bch_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Eao keo pagai, gid danga kulupulupu toa ne ga iuot ngeda? Be saoa kilala ga iuot ta ipasolan mambe gid danga toa ne teta pade ga iuot?” ");
INSERT INTO bch_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ta Iesus ikoli led posanga bedane, “Gimi agabit kemi. Ngan kado ta eaba eta ipakaka gimi. ");
INSERT INTO bch_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ngansa panua busa ga tinam ngan gau edag ta tikeo ngan gid mulian bedane, ‘Gau eaba toa Deo isula gau ne.’ Ta gid ga tipabuobuo panua busa. ");
INSERT INTO bch_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Be oangga gimi alongo paraunga kapeipei iualu boloma ga aluai, atogragimi ngan mao. Gid paraunga toa bedane ga iuotot, be ado muriai ga muriai tau ga iuot maitne. ");
INSERT INTO bch_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ngansa panua ngan alu ede ga tiparau pagid alu ede pade, be maron kapei ede ele panua ga tiparau pagid panua ton maron kapei ede pade. Ngan tibur edengada nauruge ga inuga tano ga isamimi. Be sapanga kapeipei ga iuotot pade. Be gid danga kulupulupu toa ne irangrang ngan kus manmanae mao, mambe ieieinga iuot ngan taine mugaeai ngan ipopo gergeu. ");
INSERT INTO bch_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Be gimi agabit kemi. Ngansa gid panua ga tidol gimi ga adae pagid madidnga patutuinga posanga ad bagedeai. Ta gid ga timuimui gimi luma raring aea iloleai. Ta gid ga tipamadid gimi ngan posanga pagid gavana ga mamaron kapeipei matadeai, ngansa gimi anasi gau. Ta gimi ga apamatua leg posanga ila pagid. ");
INSERT INTO bch_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Be mugaeai ngan ado toaiua, leg panua ga tipaola ato kemi ga ila pagid alu toa ngada ne tanoeai. ");
INSERT INTO bch_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Be oangga tidol gimi ga adae bagedeai ta tipamadid gimi ngan posanga, irangrang ngan lolomi ede ga ede ngan saoa edap aoangga anasi ngan kolinga led posanga solsolnga oa mao. Be saoa posanga Deo idol aoamiai ngan ado toaiua, manta akoli ga ila pagid. Ngansa eine gimi lemi posanga mao, be Itautau Tutui ele posanga. ");
INSERT INTO bch_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Be eaba itar kapeipei ga aea kakakau ga tidol ei ga idae pagid madidnga bagedeai, ta gid ga tirau ei ga imate. Be gergeu tamatamad ga tikado toa bedaoa pade ngan led gergeu. Ga gid gergeu ga timan tnad ga tamad ad isat ta tikeo pagid madidnga ta tirau gid ga timate. ");
INSERT INTO bch_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Be panua toa ngada ne ga lolod itola ngan gimi, ngansa lolomi matua ngan gau edag. Be oangga sai imadid matua ga irangrang ngan ele madonga tanoeai kus, eine Deo ga ibada ei mulian.” ");
INSERT INTO bch_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Iesus ikeo pade bedane, “Be muriai gimi ga agera danga ede paeamao ga paeamao tau imadmadid ngan mul ton Deo ta ikado ga panua tiaoa ta titnan ele luma ga idio sapaean. (Eaba iuato laulau manta iuatai kemi ngan posanga toa ne.) Ngan ado toaiua, gid panua timamado Iudea manta tiaoa ga tila bereoeai. ");
INSERT INTO bch_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Be oangga sai imamado luma ipaoeai, ei manta isulug ta iaoa manmanae. Irangrang ngan idudunga ele lumaeai ngan badanga ele danga etangada mao. ");
INSERT INTO bch_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Be oangga sai imamado dadangai, irangrang ngan ipul ei mulian ngan badanga ele pononga gaot aea mao. ");
INSERT INTO bch_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Be paeamao tau ngan gid taine apapanga ga gid pinapina ngan ado toaiua. Gid tal mon ga kulupu ngan eaoanga. ");
INSERT INTO bch_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Be manta araring ta danga paeamao toa ne iuot ngan aoara lolo mao. ");
INSERT INTO bch_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngansa ngan ado toaiua, danga kulupulupu tau ga iuot. Ngan danga toa ngada ne led otnga ga irangrang ngan labone, danga eta kulupu bedaoa iuot mao, be muriai pade danga eta kulupu bedaoa ga iuot mao pade. ");
INSERT INTO bch_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Be oangga Maron ikeo ga gid danga kulupulupu toa ne ga idio mole, panua toa ngada ne tanoeai ga timukuru. Be ei imata nanan ele panua toa isio gid, ta ikeo ga danga kulupulupu toa ne ga idio mole tau mao. ");
INSERT INTO bch_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ngan ado toaiua, oangga eaba eta ikeo pagimi, ‘Ega, eaba tiuato ei Kristus tota eko!’ mao ‘Ei tota eoa!’ irangrang ngan aeadi posanga toa oa mao. ");
INSERT INTO bch_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ngansa panua busa ga tinam ta tipakaka ta tikeo, ‘Gau Kristus.’ Be padengada ga tipakaka ta tikeo ga tibada Deo iaoa. Ta gid ga tikado uisinga iman kilala ga gid danga ipamatala panua busa. Ta oangga tirangrang, gid ga tipabuobuo Deo ele panua toa isio gid. ");
INSERT INTO bch_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Toa bedaoa ta gimi agabit kemi. Gau napalongo gimi motean ngan danga toa ngada ne.” ");
INSERT INTO bch_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Iesus ikeo pade bedane, “Be ngan ado toaiua, oangga gid danga kulupulupu toa oa kus, tota “‘ado ga iuot dodom, be taiko ga itara mao, ");
INSERT INTO bch_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","be gid gigima ga titaptap mariambai ga tisulug, be gid danga kapeipei mariambai ga inogonogoi.’ ");
INSERT INTO bch_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Ga kus ta panua ga tigera Eaba Inat isulug ga inam ngan gid laulau toman ngan iura kapei ga ele taranga. ");
INSERT INTO bch_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ga kus ta ei ga isula ele anggelo ga tila ngan tano igal toa pange oa ta tipaluplup ele panua toa isio gid. Gid ga tipaluplup gid ngan tibur toa ngada ne, ngan tano aea digedige ga ila bubur aea digedige pade, ta tibada gid ga tinam.” ");
INSERT INTO bch_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iesus ikeo pade bedane, “Gimi alongo oanenga itna ngan abei fik ta abada oatainga. Oangga ibogaboga aea eau ga ilaun papau iuotot, eine gimi aoatai, ado aea sau teta pade ga iuot. ");
INSERT INTO bch_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Toa bedaoa ta oangga gimi agera gid danga toa ne iuotot, eine gimi aoatai, ado toaiua ta inam boloma, mambe eaba imadid atama iaoai. ");
INSERT INTO bch_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nakeo tautaunga pagimi, gid panua ado toa ne ad ga timate maitne be kadonga toa ngada ne ga iuot. ");
INSERT INTO bch_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mariamba ga tano ga isapa, be irangrang ngan leg posanga isapa mao ga mao tau.” ");
INSERT INTO bch_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Iesus ikeo pade bedane, “Be eaba eta iuatai mao, gid danga toa oa ga iuot ngeda, mao ado imata pida be gid danga toa oa iuot. Gid anggelo buburiai tiuatai mao, be Deo Inat iuatai mao pade. Tamag kekelen iuatai. ");
INSERT INTO bch_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Tota matami arar ga agabit kemi. Ngansa gimi aoatai mao, gid danga toa oa ga iuot ngeda. ");
INSERT INTO bch_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Eine mambe eaba ede itnan ele luma ta ila ngan langa ede. Ei ikeo pagid ele paeaeanga ta timariala ngan ele luma, ta ipota naurata pagid ele paeaeanga kelede kelede. Ta ikeo pan eaba toa imariala ngan atama bedane, ‘Eao gabit kemi.’ ");
INSERT INTO bch_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Tota agabit kemi, ngansa gimi aoatai mao, luma itama ga iluai mulian ngeda. Ei ga inam lailai, mao bong irabu, mao kokako itang, mao gaisala rumaruma, eine gimi aoatai mao. ");
INSERT INTO bch_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Kado ei inama manmanae ta igera gimi aenono. ");
INSERT INTO bch_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Posanga toa nakeo pagimi ne, eine nakeo pagid panua toa ngada ne: ‘Agabit kemi!’” ");
INSERT INTO bch_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ngan ado toaiua, eaneannga Pasova aea ga eaneannga ngan Bret aea Yis Ienono ngan Mao inam boloma. Be ado rua imuga ngan eaneannga Pasova aea, gid madidnga tenainga ad ga apu ad tiloilo edap eta ngan pakakanga Iesus ta irangrang ngan tiluku ei ta t