﻿USE sofia;
DROP TABLE IF EXISTS sofia.bccl_vpl;
CREATE TABLE bccl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bccl_vpl WRITE;
INSERT INTO bccl_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Bahtáwar hamá ent ke badkáráni shawr o saláhay sará narawt, gonahkáráni rahsará naóshtit o rishkand kanókáni diwáná nanendit, ");
INSERT INTO bccl_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","hamá ke wáhagi gón Hodáwanday tálimá ent o róch o shap áiay tálimay sará pekra kant. ");
INSERT INTO bccl_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Á hamá drachkay paymá ent ke rombókén jósaréay kerrá keshag butag o mósomay sará nibaga dant o táki nagimmorant, harché ham ke kant kámyába bit. ");
INSERT INTO bccl_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Bale badkár chosh naant, á hamá pog o paláráni paymá ant ke gwátesha rópit o bárt. ");
INSERT INTO bccl_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Gorhá bezán ke badkárán, pa dádrasiá óshtagay wák o twán nést o gonahkár pahrézkáráni diwáná hór buta nakanant. ");
INSERT INTO bccl_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ke Hodáwand pahrézkáráni ráhay negahpán ent, bale badkáráni ráh tabáhi o bégwáhi ent. ");
INSERT INTO bccl_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Á dega kawm pa ché shóresha kanant o ráj chiá mopt o náhudagén pandala sázant? ");
INSERT INTO bccl_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Jahánay bádsháh tayára bant o hákem yakjáh mocch, Hodáwand o áiay Masihay helápá óshtant: ");
INSERT INTO bccl_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Byáét tán áyáni sád o bandán beborrén o zamzilánesh besendén.” ");
INSERT INTO bccl_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Hodáwand ke ásmáná bádsháhia kant kandit o áyán maskará kant. ");
INSERT INTO bccl_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Á wahdá wati hezhmay tahá gón áyán habara kant, wati gazabay tahá áyána torsénit: ");
INSERT INTO bccl_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Man wati bádsháh, wati pák o gechénién kóh, Sahyunay sará nendáréntag.” ");
INSERT INTO bccl_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Nun Hodáwanday hokmá darshána kanán ke maná gwashti: “Taw mani Bacch ay, maróchi man tará pédá kortag. ");
INSERT INTO bccl_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Cha man belóth tán kawmán tai mirás bekanán o zeminay chárén kondháni ráján tai sawgát. ");
INSERT INTO bccl_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Gón ásenén asáé áyán prósha dayay o kunzagáni paymá hurt hurtesha kanay.” ");
INSERT INTO bccl_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Paméshká, oo bádsháhán! Aglmand bebét. Anchosh oo jahánay hákemán! Adab bezurét. ");
INSERT INTO bccl_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Pa tors, Hodáwanday hezmatá bekanét o pa drahag pádáni kapét. ");
INSERT INTO bccl_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Chokká bechokkét chó mabit ke zahr begipt o shomá ráhay némá gár o bégwáh bebét, chiá ke á anágat bránza gipt. Bahtáwar hamá ant ke áiay mayár o báhótha bant. ");
INSERT INTO bccl_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Dáuday Zabur, hamá wahdá ke cha wati chokk Abshálumá jehagá at. Oo Hodáwand! Mani dozhmen chenkadar báz ant. Bázéné mani helápá pád áyagá ent. ");
INSERT INTO bccl_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Bázéné mani bárawá gwashagá ent: “Hodá eshiá narakkénit.” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Bale taw oo Hodáwand! Wat mani chágerdá espar ay, Mani shán o shawkat ay, maná sarperáza kanay. ");
INSERT INTO bccl_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Hodáwandon gón borzén tawáré peryáta kort o áiá cha wati pák o gechénién kóhá maná passaw dát. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Man ásudag waptán o pád átkán, chiá ke Hodáwand mani posht o panáh at. ");
INSERT INTO bccl_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Cha lakkáni lakká natorsán ke cha har némagá maná angerresh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Oo Hodáwand! Pád á. Oo mani Hodá! Maná berakkén. Taw ay ke mani dozhmenáni démá shahmáta janay o badkáráni dap o dantánána próshay. ");
INSERT INTO bccl_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Rakkénók Hodáwand ent, tai barkat tai kawmá berasát! Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Pa sázger o washáwázáni sálárá. Gón zehi o simmi sázán. Dáuday Zabur. Oo mani dádrasén Hodá! Passaw beday wahdé peryáta kanán. Sakki o sóriáni wahdá mani dast o bánzolet pach kortant. Maná mehr o rahmat baksh o dwáyánon gósh dár. ");
INSERT INTO bccl_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Oo mardomán! Tán kadéná mani ezzat kamsharap kanaga bit? Tán chontá náhudagiá dósta dárét o drógay padá gardét? Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Bezánét ke Hodáwandá Hodádóst pa wat zortag o jetá kortagant. Wahdé Hodáwandá tawára kanán, á eshkont. ");
INSERT INTO bccl_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Hezhmay tahá gonáh makanét. Éshiay badalá, wapsagay wahdá, wati delá é bárawá pegr kanét o árám gerét. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Barhakkén korbánig peshkash kanét o Hodáwanday sará tawkal. ");
INSERT INTO bccl_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Bázéné gwashit: “Kay ent pa má néki bekant?” Oo Hodáwand! Wati démá pa má rozhnág kan. ");
INSERT INTO bccl_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Taw mani del cha shádániá sarréch kortag, cha áyáni hamá wahday shádániá géshter ke dán o gallah o tázagén sharábesh báz bebant. ");
INSERT INTO bccl_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Árámiá drája kasshán o wáb ham kapán, chiá ke tahná taw, oo Hodáwand, maná émeniay tahá nendénay. ");
INSERT INTO bccl_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Pa sázger o washáwázáni sálárá. Gón nali sázán. Dáuday Zabur. Oo Hodáwand! Mani gappán gósh bedár, mani nálagán delgósh kan. ");
INSERT INTO bccl_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Oo mani bádsháhén Hodá! Mani peryátá beshkon, chiá ke tai gwará dwá kanán. ");
INSERT INTO bccl_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Oo Hodáwand! Bámgwáhán taw mani tawárá eshkonay, bámgwáhán, gón dazbandi wati wáhagán pésha kanán o wadáriga bán. ");
INSERT INTO bccl_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Taw choshén Hodáé naay ke cha badiá delwassh bebay, badi gón taw jalleta nakant. ");
INSERT INTO bccl_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Porkebr o gorunák tai démá óshtáta nakant o cha sajjahén badkárán naprata kanay. ");
INSERT INTO bccl_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Drógbandán bégwáha kanay, Hodáwand cha hónig o préb‌kárán naprata kant. ");
INSERT INTO bccl_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Bale man cha tai mehrá tai lógá káyán o cha tai torsá tai parasteshgáhá kóndhána kapán. ");
INSERT INTO bccl_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Oo Hodáwand! Pa mani dozhmenáni sawabá, gón wati adl o ensápá maná rahshóni beday o wati ráhá pa man sáp o tachk bekan. ");
INSERT INTO bccl_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Chiá ke rásti áyáni zobáná nést o del o darunesh tabáhi ent o bass. Gotth o galuesh práhén kabré o wati zobáná pa cháplusi kára bandant. ");
INSERT INTO bccl_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Oo Hodá! Eshán mayárbár hesáb kan, bell ke wati shawráni tahá beboddhant. Áyáni bázén náparmániáni sawabá, cha wat duresh kan, chiá ke tai helápá shóreshesh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Bale á sajjahén ke tai báhóth o mayára bant, shádmáni bekanant, dáemá sáz o zémel bejanant. Áyán wati sáhegay chérá negahpáni bekan, tán harkas ke tai námay dóstdár ent gón tai námá shádán bebit. ");
INSERT INTO bccl_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Allamá, taw, oo Hodáwand, pahrézkárán barkata dayay o áyán gón wati mehr o rahmatá esparay paymá negahpána bay! ");
INSERT INTO bccl_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Pa sázger o washáwázáni sálárá. Gón zehi o simmi sázán. “Sheminitay” tarzay sará. Dáuday Zabur. Oo Hodáwand! Maná gón wati hezhmá hakkal maday o gón wati gazabá neherr. ");
INSERT INTO bccl_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Hodáwandá! Mani sará rahm kan chiá ke gimmortagán. Oo Hodáwand! Maná dráh bekan chiá ke jesm o jánon paréshán ent. ");
INSERT INTO bccl_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Arwáhon sakk békarár o jalájósh ent. Oo Hodáwand! Tán kadén? Tán kadén? ");
INSERT INTO bccl_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Hodáwandá! Wati démá gón man tarrén o mani sáhá berakkén, wati mehray sawabá maná neját beday. ");
INSERT INTO bccl_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Chiá ke mordag tará yát korta nakanant, kay ent ke cha mordagáni jaháná tai shográ begipt? ");
INSERT INTO bccl_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Cha nálagán dam bortagán, har shap gandalán cha gréwagá ménán o tahtá gón arsán tarra kanán. ");
INSERT INTO bccl_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Chammon cha bázén andóhán nezór butagant o cha bázén dozhmenán tahár. ");
INSERT INTO bccl_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Oo sajjahén badkárán! Cha man dur bét, chiá ke Hodáwandá mani gréwagáni tawár eshkotagant. ");
INSERT INTO bccl_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Hodáwandá mani peryát gósh dáshtagant, Hodáwand mani dwáyá mannit. ");
INSERT INTO bccl_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Mani sajjahén dozhmen sharmendag o sakk paréshána bant, á démá chahra dayant o pashal o sharmendaga bant. ");
INSERT INTO bccl_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Dáuday Shigáyun. Dáudá é Zabur Benyáminay kabilahay Kush námén mardoméay habaráni sawabá pa Hodáwandá darshán kortag. Oo Hodáwand, mani Hodá! Tai báhóth o mayára bán. Maná cha á sajjahénán ke mani randá kaptagant berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Agan na, á maná shéráni paymá derrant, chondh chondha kanant o maná rakkénóké nabit. ");
INSERT INTO bccl_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Oo Hodáwand, mani Hodá! Agan man choshén káré kortag o daston gonáhéá mén ent, ");
INSERT INTO bccl_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","agan pa dóstéá badion kortag, yá ke dozhmené bémayárá poletag, ");
INSERT INTO bccl_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","bell ke dozhmen mani padá byayt o áiay dast pa man berasit, mani zendá pádmál bekant o maná hákáni tahá bwápénit. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Oo Hodáwand! Gón wati hezhmá jáh bejan o mani dozhmenáni gazabay démá pád á! Ágáh bay, oo mani Hodá! Taw ay ke dádrasiay járet jatag! ");
INSERT INTO bccl_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Bell ke kawmáni romb tai gwará yakjáh bant, cha borzá esháni sará hákemi bekan! ");
INSERT INTO bccl_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Bell ke Hodáwand pa kawmán shawr o hokm beborrit. Oo Hodáwand! Gón mani rásti o tachkiá, wati dadrasiá mani pahrézkáriáni sará bekan. ");
INSERT INTO bccl_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Oo ádelén Hodá ke del o darunána zánay! Badkáráni sherrián halás kan o pahrézkárán pa del mohr bedár. ");
INSERT INTO bccl_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Mani espar Hodá ent ke nékdelána rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Hodá ádelén dadrasé, Hodáé ke har róch hezhma gipt. ");
INSERT INTO bccl_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Agan ensán pashómán mabit, wati zahmá téza kant o wati kamáná kasshit o tayára kant. ");
INSERT INTO bccl_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Áiá koshókén seláh tayár kortag o wati tirán ácheshéna kant. ");
INSERT INTO bccl_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Á mardomá bechár ke cha sherr o shórá ápos ent o cha petnahá lápporr, á dróga zayt. ");
INSERT INTO bccl_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Kallé kóchit o johla kant o hamá chátá kapit ke wat kótkagi. ");
INSERT INTO bccl_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Áiay petnah wati sará kapit o pasáti ham sará laggit. ");
INSERT INTO bccl_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Hodáwandá pa áiay adl o ensápá shogra gerán, borzén arshay Hodáwanday námá názénán. ");
INSERT INTO bccl_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Pa sázger o washáwázáni sálárá. “Gittitay” tarzay sará. Dáuday Zabur. Oo Hodáwand, may Hodáwand! Chenkadar porshawkat ent tai nám jahánay chárén kondhán. Taw wati shán o mazani ásmánáni sarborá sheng o tálán kortag. ");
INSERT INTO bccl_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Pa wat satá o saná, chokk o shirmechén nonnokáni dapá ham dátag ke tai dozhmenáni sawabá tará satá bekanant, tánke dozhmen o bérgirán chopp o bétawár bekanay. ");
INSERT INTO bccl_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Wahdé tai ásmánáni némagá chárán ke tai lankokáni ezm o honar ant máh o estáráni némagá, ke taw barjáh dáshtagant, ");
INSERT INTO bccl_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","ensán chié ke taw áiay gamwár bebay o bani ádam kay ent ke áiay delgóshá bedáray? ");
INSERT INTO bccl_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Bale angat taw cha préshtagán bass kammoké kamter kort o mazani o ezzatay táj sará dát. ");
INSERT INTO bccl_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Wati dastay sajjahén káráni sará hákem kort o har chizz áiay pádáni chérá esht. ");
INSERT INTO bccl_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Sajjahén ramag o górrom gyábán o sahrái jánwar ");
INSERT INTO bccl_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ásmánay báli morg o daryáay máhig o har ché ke cha zeray ráhá gwazit. ");
INSERT INTO bccl_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Oo Hodáwand, may Hodáwand! Chenkadar porshawkat ent tai nám jahánay chárén kondhán. ");
INSERT INTO bccl_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Pa sázger o washáwázáni sálárá. “Mawt-labbénay” tarzay sará. Dáuday zabur. Tará, oo Hodáwand, cha delay johlánkián shogra gerán, tai sajjahén ajabén kárán darshána kanán. ");
INSERT INTO bccl_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Tai gwará gal o shádmánia kanán. Oo borzén arshay Hodá! Tai námá názénán. ");
INSERT INTO bccl_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Wahdé mani dozhmen pada kenzant, cha tai démá lakoshant o tabáh o haláka bant. ");
INSERT INTO bccl_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Chiá ke taw mani hakk o ensáp pa sharri dáshtag, wati tahtá neshtagay o pa ensáp dádrasi kortag. ");
INSERT INTO bccl_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Kawmet hakkal dátagant, badkár tabáh o barbád kortagant o áyáni nám abad tán abad gár o bégwáh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Dozhmen, dáemi wayránagáni tahá gár o gomsár butagant, áyáni shahráni risshag o wandhálet cha boná kasshetagant, tantaná áyáni yát ham gár o zawál butag. ");
INSERT INTO bccl_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Bale Hodáwand tán abad bádsháhia kant, áiá wati shawr o dádrasiay taht páydár kortag. ");
INSERT INTO bccl_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Á wat jaháná gón adlá dádrasia kant, kawmáni sará gón ensápá shawra borrit. ");
INSERT INTO bccl_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Hodáwand pa zolm distagénán, borzén kaláté kaláté borzén, mán sakkén sáhatán. ");
INSERT INTO bccl_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Á ke tai námá zánant tai sará tawkala kanant chiá ke taw, oo Hodáwand, wati hodónákén lóthók yalah nakortagant. ");
INSERT INTO bccl_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Hodáwandá, ke tahti Sahyuná ent, benázénét, kawmáni nyámá áiay kortagén kárán jár janét. ");
INSERT INTO bccl_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Chiá ke á ke hónáni bérgir ent, eshán yáta kant zolm distagénáni peryátána nashamóshit. ");
INSERT INTO bccl_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Oo Hodáwand! Mani sará rahm kan, hamá ázárán ke cha dozhmenáni dastá maná rasant bechár, taw ke cha markay darwázagán maná sarperáza kanay, ");
INSERT INTO bccl_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","tánke tai sajjahén satá o tawsipán Sahyunay Jenekay darwázagáni démá barjáh dárán o shádmáni bekanán ke taw maná rakkéntag. ");
INSERT INTO bccl_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Kawm, wati hamá kótkagén kallá kaptagant, áyáni pád hamá dámá band geptag o passetagant ke watesh chér kortagat. ");
INSERT INTO bccl_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Hodáwandá watá gón wati adl o ensápá pajjáréntag, badkár cha wati kortagén kárán wat dámá kapant. Zegr... Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Badkár mordagáni jaháná pera tarrant, á sajjahén kawm ke Hodáyá shamóshant. ");
INSERT INTO bccl_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Bale hájatmand harwahd shamóshaga nabant o zolm distagénáni omét tán abad barbáda nabit. ");
INSERT INTO bccl_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Oo Hodáwand! Pád á o mayl ke ensán báládast bebit, bell ke tai dargáhá kawmáni shawr o hokm borrag bebit. ");
INSERT INTO bccl_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Oo Hodáwand! Torsesh jesm o jáná perrén tán kawm bezánant ke ensán ant o bass. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Oo Hodáwand! Pa ché dur óshtátagay? Chiá watá sakkén sáhatán chéra dayay? ");
INSERT INTO bccl_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Badkár gón kebr nezórénán shekára kant, bell ke wati pandaláni dámá gereptár bebit. ");
INSERT INTO bccl_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Chiá ke badkárá wati delay wáhagáni sará pahr ent, lálech kanókán barkata dant o Hodáwandá bad o rada gwashit. ");
INSERT INTO bccl_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Badkár mán wati kebr o gorunákiá gwashit: “Hodá dar gétka nakant”, áiay sajjahén pegr o hayál esh ent ke “Hodáé nést”. ");
INSERT INTO bccl_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Wati ráhá modám kámyáb o sóbén ent, tai shawr o dádrasi cha áiay chammá dur ant, wati sajjahén dozhmenán rishkanda kant. ");
INSERT INTO bccl_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Wati delá gwashit: “Hechbar cha wati jáhá sorénag o jombénaga nabán nasláni nasl cha kazá o baláhán dura bán.” ");
INSERT INTO bccl_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Dap o zobáni cha nálat o préb o setamá porr ent, áiay zobánay chérá petnah o sherkáriá kodám bastag. ");
INSERT INTO bccl_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Métag o ábádiáni kaminá nendit, chér o panáhén jáhán bégonáhána koshit, chérokái béwasáni shekár kanagay shóházá ent. ");
INSERT INTO bccl_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Shéray paymá wati kaminá wadára kant, wadára kant o nezór o nátwánán wati panjagá kárit, panjagá kárit o dámá dawra dant. ");
INSERT INTO bccl_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Áiay shekár, lagatmál o zár o wára bant, áiay dastá gár o gomsára bant. ");
INSERT INTO bccl_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Wati delá gwashit: “Hodáyá shamoshtag démi póshéntag o hechbara nagendit.” ");
INSERT INTO bccl_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Oo Hodáwand! Pád á. Oo Hodá! Wati dastá shahár. Bazzagénán mashamósh. ");
INSERT INTO bccl_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Badkár pa ché Hodáyá bad o rada gwashit? Chiá wati delá gwashit: “Hodá dar gétka nakant”? ");
INSERT INTO bccl_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Bale albat taw genday. Sakki o sóriána genday, tán kár o ehtiárá wati dastá bedáray. Bazzag o béchárag watá tai sepordaga kanant, chórawáni madat kanók taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Sherr o badkáráni báská beprósh, áyáni sharáratay hesábá beger, hamá káráni hesábá ham ke áiá gwashtag: “Hodá dar gétka nakant”. ");
INSERT INTO bccl_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Hodáwand abad tán abad bádsháh ent, kawm cha áiay sardhagárá gár o gomsára bant. ");
INSERT INTO bccl_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Oo Hodáwand! Taw bazzagáni wáhagán gósha dáray, áyán delbaddhia dayay o habaránesh eshkonay. ");
INSERT INTO bccl_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Chóraw o setam distagénáni dadrasiá kanay tánke é hákién ensán dega baré tors o dehshat maperrénit. ");
INSERT INTO bccl_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Man Hodáwanday mayár o báhóth án, gorhá shomá maná che paymá gwashét: “Morgé bebay o wati kóhá bál kan. ");
INSERT INTO bccl_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Chiá ke haw, badkár kamáná kasshant o tiresh zehá dátag, ke mán tahárókiá nékdelán bejanant. ");
INSERT INTO bccl_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Agan bonred tabáh kanag bebant, gorhá pahrézkár ché korta kant?” ");
INSERT INTO bccl_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Hodáwand wati pákén parasteshgáhá ent, Hodáwanday taht ásmáná ent. Chammi gendagá ant, didagi ensánay chokkána ázmáit. ");
INSERT INTO bccl_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Hodáwand pahrézkár o badkárána chakkásit, áiay ruh cha hamáyán naprata kant ke sherr o sheddatesh dósta bit. ");
INSERT INTO bccl_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Badkáráni sará angar o gókorta gwárénit, áyáni jám o pyálahay bahr, sóchák o lewárén gwát ent. ");
INSERT INTO bccl_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Hodáwand ádel ent, áiá adl o ensáp dósta bit, nékdel áiay démá gendant. ");
INSERT INTO bccl_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Pa sázger o washáwázáni sálárá. “Sheminitay” tarzay sará. Dáuday Zabur. Oo Hodáwand! Berakkén, chiá ke hech Hodádósté pasht nakaptag o wapádár cha mardománi nyámá gár o bégwáh butagant. ");
INSERT INTO bccl_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Harkas gón hamsáhegá dróga bandit, cháplusén dapesh pa préb habara kanant. ");
INSERT INTO bccl_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Hodáwand har cháplusén dapá próshát o har bathák janókén zobáná borrát. ");
INSERT INTO bccl_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Gwashant: “Má gón wati zobáná kámyáb o sóbéna bén, may dap o lonth ham gón má ant, may wájah o master kay ent?” ");
INSERT INTO bccl_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Hodáwanda gwashit: “Cha nezórén mardománi lagatmáli o hájatmandáni nálagáni sawabá nun jáha janán. Man eshán hamá paymá émenia bakshán ke esháni armán ent.” ");
INSERT INTO bccl_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Hodáwanday habar asil o béayb ant, nograhay paymá ke cha kurahá dar átkag o hapt randá pák o sallah kanag butag. ");
INSERT INTO bccl_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Oo Hodáwand! Taw eshán negahpánia kanay, taw é dábén mardománi nyámá esháni posht o panáha bay. ");
INSERT INTO bccl_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Badkár har némagá tarr o tába kanant, á wahdi ke mardom palitiá ezzata dayant. ");
INSERT INTO bccl_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodáwand! Tán kadén? Bárén maná tán abada shamóshay? Tán kadén wati démá cha man panáha kanay o póshénay? ");
INSERT INTO bccl_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Tán kadén mani pegr o andéshag maná ázár bedayant, har róch delon gamig? Tán kadén dozhmen mani sará báládast bebit? ");
INSERT INTO bccl_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Oo Hodáwand! Mani Hodá! Mani cháragá bekan o passaw day! Chammánon rozhná kan, agan na, markay wábá wapsán. ");
INSERT INTO bccl_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Chó mabit dozhmen begwashit: “Man áiay sará sóbén butagán”, badwáh shádán bebit ke mana larzán. ");
INSERT INTO bccl_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bale tai mehray sará tawkala kanán, delon gal o bála bit ke taw maná rakkéntag. ");
INSERT INTO bccl_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Hodáwandá názénán, ke modám mani sará mehrabán butag. ");
INSERT INTO bccl_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Nádán wati delá gwashit: “Hodáé nést.” É palit ant o káresh sell o gandah, nékkáré nést. ");
INSERT INTO bccl_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Hodáwand cha ásmáná bani ádamá chárit tán begendit bárén dánáé hast ke Hodáay shóházá ent. ");
INSERT INTO bccl_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Sajjahénán wati ráh gár dátag, hórigá palit butagant, nékkáré nést, yakké ham nést. ");
INSERT INTO bccl_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Badkár hechbar sarpada nabant? É mani kawmá anchosha warant ke mardom nagana warant o Hodáwandá hech tawára nakanant. ");
INSERT INTO bccl_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Bale ódá wati torsay tahá boddhant, chiá ke Hodá gón pahrézkáráni nasl o padréchá ent. ");
INSERT INTO bccl_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Shomá setam distagénáni shawrbandián rishkanda kanét, bale Hodá esháni panáhgáh ent. ");
INSERT INTO bccl_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Kasé cha Sahyuná byáyát o Esráilá berakkénát. Wahdé Hodáwand washbahtiá pa wati kawmá pera tarrénit, Ákub gal o bála bit o Esráil shádehia kant. ");
INSERT INTO bccl_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Dáuday Zabur. Oo Hodáwand! Kay tai tambuá mehmán bebit? Kay tai pákén kóhá jahmenend bebit? ");
INSERT INTO bccl_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Hamá ke béayb gám bejant, adl o ensápá barjáh dárit o pa delsetki rásténá begwashit, ");
INSERT INTO bccl_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","hamá ke gón wati zobáná kaséay báposhtá habaré magwashit, pa hamsáhegá badi makant o hamráhán ér majant, ");
INSERT INTO bccl_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","hamá ke badkár áiay chammán hakir o béarzesh bebant, Hodátorsán ezzat o hormat bedant o wati labzay sará wapá bekant, toré zalar o zyán begendit, ");
INSERT INTO bccl_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","hamá ke wati zarrá pa sutt madant o bégonáhéay helápá reshwat magipt, á ke eshán barjáha dárit hechbara nalarzit. ");
INSERT INTO bccl_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Dáuday shayr. Oo Hodá! Maná pa sharri bedár, ke tai mayár o báhóth butagán. ");
INSERT INTO bccl_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Gón Hodáwandá gwashton: “Taw ay mani Hodáwand, abéd cha taw pa man hech sharrié nést.” ");
INSERT INTO bccl_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Á pák o palgártagén ke zeminá ant, hamá sharapmand ant ke mani sajjahén shádmáni hamáyáni sawabá ent. ");
INSERT INTO bccl_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Á ke dega hodáéay randá tachant, áyáni gam o andóh sakk báza bit, áyáni hónén korbánigáni rasmán góna nabán o námánesh wati zobáná nayárán. ");
INSERT INTO bccl_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Oo Hodáwand! Taw mani gisshetagén bahrwandh o jám ay, taw mani bahrá sharriay sará dáray. ");
INSERT INTO bccl_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Mani hadd o simsar, deltabén jágahán gisshénag butagant, maná delkasshén mirásé dastá kaptag. ");
INSERT INTO bccl_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Man Hodáwandá názénán ke maná shawr o saláha dant, delon shappásán ham maná ráh sója dant. ");
INSERT INTO bccl_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Man modám Hodáwand wati dém pa démá distag, á mani rástén pahnátá ent, cha hamé sawabá mana nalarzán. ");
INSERT INTO bccl_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Paméshká, delon wassh o zobán shádán ent. Jesm o jánon mán ométay kalátá áráma gipt. ");
INSERT INTO bccl_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Chiá ke taw maná mordagáni jaháná yalaha nakanay o wati dóstdárá sarhag o pussagá naylay. ");
INSERT INTO bccl_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Taw maná zenday ráhá sója dayay o wati bárgáhá maná cha shádmániá sarrécha kanay. Tai rástén kashá, wasshi abadmán ent. ");
INSERT INTO bccl_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Dáuday dwá. Oo Hodáwand! Mani barhakkén peryátán beshkon o nálagánon gósh dár, dwáyánon beshkon, ke cha béryáén dap o lonthán dara káyant. ");
INSERT INTO bccl_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Cha tai bárgáhá maná dádrasi o ázáti sar bát, chammet rásténá begendátant. ");
INSERT INTO bccl_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Taw mani del ázmáesh kortag o shappásán mani cháragá átkagay, maná chakkásetaget o hech dar nagétkag, ahdon kortag ke dap gonáh makant. ");
INSERT INTO bccl_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Mardománi kár har ché ke bit, bale man cha tai lontháni gálá watá cha zálemáni ráhá dur dáshtag. ");
INSERT INTO bccl_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Mani pádáni pad tai ráhá naksh ant, pádon nalarzetagant. ");
INSERT INTO bccl_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Oo Hodá! Tará lóthán, chiá ke taw maná passawa dayay, gósh dár o habaránon beshkon. ");
INSERT INTO bccl_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Wati mehray ajabbatiá pésh bedár! Taw hamáyána rakkénay ke cha wati dozhmenán tai gwará mayár o báhótha bant. ");
INSERT INTO bccl_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Maná chó wati chammá besambál o wati bánzoláni sáhegá chér beday, ");
INSERT INTO bccl_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","cha á badkárán ke maná gár o gomsára kanant o cha hamá jawrén dozhmenán ke maná angerresh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Á wati sengén delán mohra kanant o áyáni zobán porkebr o gorunákén habara kant. ");
INSERT INTO bccl_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Mani padesh geptagant o hamé annun maná angerresh kortag, chammesh pa man dótkag tán zeminá dawron bedayant. ");
INSERT INTO bccl_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Á shéréay paymá ant ke pa shekárá shodig ent, warnáén shéréay paymá ke kaminá neshtag, ");
INSERT INTO bccl_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Oo Hodáwand! Jáh jan, esháni démá dar á o zeminá bejanesh, gón wati zahmá maná cha badkárán berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Hodáwandá! Maná cha é paymén mardománi dastá ázát kan, cha é donyáay mardomán ke nasibesh tahná hamé donyá ent o bass, ke lápánesh cha wati hazánagá séra kanay, chokkesh báza bant o áyáni pasht kaptagén chizz pa chokkánesha rasit. ");
INSERT INTO bccl_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Bale man pa pahrézkári tai démá gendán, ágáh ke bán, cha tai gendagá séra bán. ");
INSERT INTO bccl_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Pa sázger o washáwázáni sálárá. Hodáwanday hezmatkár Dáuday Zabur. Dáudá é Zabur hamá wahdá pa Hodáwandá per bast ke Hodáwandá cha sajjahén dozhmenán o cha Sháulay dastá rakként. Dáudá chosh gwasht: Oo Hodáwand, oo mani zór o wák! Tará báz dósta dárán. ");
INSERT INTO bccl_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Hodáwand mani talár ent, mani kalát o mani rakkénók ent, mani Hodá mani talár ent o hamáiay poshtá báhóth o mayára bán. Á mani espar ent, mani zórákén rakkénók o mani sangar. ");
INSERT INTO bccl_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Hodáwandá ke satá o sanáay láhek ent tawára kanán o cha wati dozhmenána rakkán. ");
INSERT INTO bccl_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Markay sád o bandán maná patátagat o tabáhi o zawáliay hár o hirrópán maná torséntagat. ");
INSERT INTO bccl_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Mordagáni jahánay sád o bandán patátagatán o gón markay dámá, dém pa dém atán. ");
INSERT INTO bccl_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Wati paréshániáni tahá Hodáwandon tawár jat o komak lóthagay peryáton wati Hodáay gwará borz kort. Áiá cha wati parasteshgáhá mani tawár eshkot o mani komak lóthagay peryát áiay góshán raset. ");
INSERT INTO bccl_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Nun zemin chandhet o jomb o jóshá lagget, kóháni béh o bonyát ham larzetant, chiá ke á hezhm geptagat. ");
INSERT INTO bccl_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Cha áiay pónzá dutt dar átk o sóznákén ásé cha dapá, taptagén angar zobánok janagá atant. ");
INSERT INTO bccl_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ásmáni ér áwort o jahl átk, syáhén jambar áiay pádáni chérá at. ");
INSERT INTO bccl_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Karrubiéay bánzoláni sará neshtagat o gwátay bánzoláni sará bál at. ");
INSERT INTO bccl_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Taháróki wati pósháki kort o jambaráni gobár o syáhén hawri wati chágerday kápár kortant. ");
INSERT INTO bccl_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Rozhn o drapshnáki cha áiá démá at o jambar chest bayagá atant, taptagén seng o ácheshén angar dara kaptant. ");
INSERT INTO bccl_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Hodáwandá cha ásmáná grandet o borzén arshay Hodáyá cha taptagén seng o ácheshén angarán wati tawár sar dát. ");
INSERT INTO bccl_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Áiá wati tir shántant o dozhmen sheng o sháng kortant, gróki dawr dát o sargardáni kortant. ");
INSERT INTO bccl_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Daryáay ápráh gendag butant o donyáay bonyát paddar, cha tai neherr o hakkalán cha tai pónzay trondén gwátá, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Áiá cha borzádá dast shahárt o maná gepti, cha zyádahén ápá maná dar áworti o ");
INSERT INTO bccl_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","cha zóráwarén dozhmená rakként, cha áyán ke napratesh mani sará próshtagat, chiá ke cha man zórákter atant. ");
INSERT INTO bccl_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Sakki o sóriáni róchá, mani démá dar átkant, bale Hodáwand mani posht o panáh at. ");
INSERT INTO bccl_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Áiá maná práh o émenén jágahé áwort o maná rakkénti, chiá ke cha man báz wassh o razá at. ");
INSERT INTO bccl_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Hodáwandá pa mani pahrézkáriá gón man néki kortag, mani dastáni pákiay mozz bakshátag, ");
INSERT INTO bccl_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","chiá ke man Hodáwanday ráh yalah nadátag o cha Hodáyá dém pa badiá nashotagán. ");
INSERT INTO bccl_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Áiay parmán modám mani chammáni démá butagant o áiay hokm cha wat dur nadáshtagant. ");
INSERT INTO bccl_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Áiay démá tamán o béayb butagán o watá cha gonáhá dur dáshtag. ");
INSERT INTO bccl_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Hodáwandá mani pahrézkáriáni mozz dátag, áiá mani dastáni páki distag. ");
INSERT INTO bccl_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Taw gón wapádárán wapádár ay o gón tachkénán tachk. ");
INSERT INTO bccl_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Gón pákénán pák ay o gón repkkárán chálák. ");
INSERT INTO bccl_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Chiá ke taw békebrána rakkénay, bale porkebr o gorunákán chamjahla kanay. ");
INSERT INTO bccl_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Oo Hodáwandén Hodá! Taw ay ke mani cherágá rozhnága kanay. Hamá ent ke mani tahárókián róshena kant. ");
INSERT INTO bccl_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Gón tai madatá lashkaréay sará orosh o hamlaha barán o gón Hodáay komaká ent ke cha borzén diwálán koppa kanán. ");
INSERT INTO bccl_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Haw! Hodá, áiay ráh tamán o kámelén ráhé, Hodáay habar béayb ant, pa harkasá ke áiay gwará panáha zurit, esparé. ");
INSERT INTO bccl_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Hodáwandá abéd, kay Hodá ent o Hodáyá abéd, kay talár? ");
INSERT INTO bccl_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","É Hodá ent ke maná zór o wáka dant o mani ráhá tamán o béayba kant. ");
INSERT INTO bccl_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Mani pádán áskáni paymá téza kant o maná borziáni óshtagá láhekia dant. ");
INSERT INTO bccl_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Mani dastán pa jangá ázmudaga kant, tán báskon brenjén kamáná beloppénit o chóth bekant. ");
INSERT INTO bccl_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Taw wati sóbén bayagay espará maná bakshay o rástén dastet mani posht o panáh ent, tai narmdeli o békebri maná mazania dant. ");
INSERT INTO bccl_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Taw mani pádáni chéray ráhá práha kanay tánke pádon malarzant. ");
INSERT INTO bccl_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Dozhmenáni randá kapán o mani dast pa áyána rasit, tán halák mabant, pera natarrán. ");
INSERT INTO bccl_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Anchosh zeminá janán ke pád áyagay móh o wákesh mabit, mani pádáni chérá kapant. ");
INSERT INTO bccl_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Taw pa jangá maná zór o wáka bakshay o dozhmenán mani pádáni chérá dawra dayay. ");
INSERT INTO bccl_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Mani pádán dozhmenáni gardenay sará éra kanay o man wati dozhmenán gár o gomsára kanán. ");
INSERT INTO bccl_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Pa komaká peryáta kanant bale rakkénóké nést, cha Hodáwandá komaka lóthant, bale passawa nadant. ");
INSERT INTO bccl_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Man áyán háka kanán o gwátá dayán, damk o kuchaháni gelay paymá chandhán. ");
INSERT INTO bccl_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Taw maná cha mardománi jang o chópána rakkénay o kawmáni sardára kanay, hamá mardom mani hezmatá kanant ke manesh pajjáha nayárán. ");
INSERT INTO bccl_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Tán mani tawárá eshkonant, parmána barant, darámad mani démá wati sará jahla kanant. ");
INSERT INTO bccl_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Á deltrakka bant, larzán o drahán cha wati kalátána tachant. ");
INSERT INTO bccl_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Hodáwand zendag ent. Pa mani talárén Hodáyá názénk. Mani rakkénókén Hodáyá shán o shawkat bát. ");
INSERT INTO bccl_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Hodá ent ke mani bérá gipt, kawm o ráján mani chérdastiá nádénit o ");
INSERT INTO bccl_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","maná cha dozhmenána rakkénit. Haw! Taw mani dozhmenáni démá maná sarperáza kanay o cha zálemén mardomána chotthénay. ");
INSERT INTO bccl_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Oo Hodáwand! Paméshká tará kawmáni nyámá satá kanán o tai námá názénán. ");
INSERT INTO bccl_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Á wati bádsháhá mazanén sób o pérózia bakshit o wati rógen per moshtagéná mehra kant, bezán Dáud o áiay nasl o padréchá tán abad. ");
INSERT INTO bccl_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Ásmán Hodáwanday shán o mazaniá paddara kant, borzén arsh áiay dastay kárán. ");
INSERT INTO bccl_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","É róch pa á róchá habar rawána kant o é shap pa á shapá zánt o hekmat darshána kant, ");
INSERT INTO bccl_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","na habaré o na gálé, áyáni tawár eshkonaga nabit. ");
INSERT INTO bccl_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Padá ham áwázesh sarjamén zeminá sheng o tálána bit o habaresh tán jahánay goddhi marz o simsarána rasant. Pa róchá, Hodáyá ásmáná tambué bastag, ");
INSERT INTO bccl_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","róch sálónkéay paymá cha wati kellahbandá dara kayt o chó ke pahlawáné shádán maydána kant. ");
INSERT INTO bccl_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Cha ásmánay yak gwaréá dara kayt o tán á dega gwará chahra wárt, hech chizzé cha áiay horm o garmiá chér naent. ");
INSERT INTO bccl_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Hodáwanday Sharyat tamán o béayb ent o jesm o jáná bóda kárit. Hodáwanday hokm porehtebár ant o kamzántán dáná o aglmand kant. ");
INSERT INTO bccl_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Hodáwanday rahband rást ant o delá shádána kanant. Hodáwanday parmán pák ant o chammán rozhnága kanant. ");
INSERT INTO bccl_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Hodáwanday tors pák ent o tán abad páydár. Hodáwanday parmán barhakk ant o sarjamiá adl, ");
INSERT INTO bccl_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","cha teláhá delkashter, tantaná cha asilén zarr ham, cha shahdá shirkenter, tantaná cha bénagay kodámay har trampá washter. ");
INSERT INTO bccl_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Tai hezmatkárá cha áyán dháh o hoshdár rasit o gón áyáni dáragá mazanén mozzé. ");
INSERT INTO bccl_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Kay ent á ke wati radián bezánt o sarpad bebit? Maná cha wati nazántagén gonáhán pák o sallah kan. ");
INSERT INTO bccl_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Wati hezmatkárá cha gorunák o porkebrén kár o kerdán bedár, mayl ke mani sará báládast bebant. Hamá wahdá tamán o béayba bán o cha har mazanén gonáhá pák. ");
INSERT INTO bccl_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Oo Hodáwand! Mani dapay habar o delay pegr o hayál tai delá benendátant, taw ke mani talár o posht o panáh ay. ");
INSERT INTO bccl_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Hodáwand tará sakki o sóriáni róchá passaw bedayát, Ákubay Hodáay nám tará negahpán bát. ");
INSERT INTO bccl_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Cha wati pákén jágahá pa taw komak berasénát o cha Sahyuná tará madat kanát. ");
INSERT INTO bccl_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Tai sajjahén korbánigán wati yátá bedárát, tai sóchagi korbánigáni mannók bát. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Tai delay wáhagán barjáh dárát o tai sajjahén shawrbandián kámyáb kanát. ");
INSERT INTO bccl_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Tai sób o péróziá gón shádmáni kukkár bekanén o wati bayraká tai námay sará borzád bechandhénén. Hodáwand tai sajjahén dazbandián purah o sarjam bekanát. ");
INSERT INTO bccl_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Nun zánton ke Hodáwand wati rógen per moshtagéná rakkénit o cha wati pákén ásmáná áiá passawa dant, gón wati rástén dastay rakkénókén wák o tágatá. ");
INSERT INTO bccl_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Lahtén wati asp o arrábaháni sará pahra kanant, bale má wati Hodáwandén Hodáay námay sará pahra kanén. ");
INSERT INTO bccl_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Á srénprósha bant o kapant, bale má páda káén o mohra óshtén. ");
INSERT INTO bccl_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Oo Hodáwand! Bádsháhá sób o pérózi beday. Tawár ke kanén, may passawá beday. ");
INSERT INTO bccl_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodáwand! Bádsháh cha tai zórá shádmánia kant o cha tai rakkénagá ent ke inchok gal o bál ent. ");
INSERT INTO bccl_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Taw áiay delay morád bakshátagant o áiay lontháni wáhaget cha áiá dur nadáshtagant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Chiá ke gón bázén barkatáni dayagá pa áiay wasshátká dar átkagay o tájé cha asilén teláhá sará dátet. ");
INSERT INTO bccl_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Áiá cha taw zend lóthet o taw bakshát, rócháni dráji, abad tán abad. ");
INSERT INTO bccl_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Cha tai bakshátagén kámránián, áiay shán o marháh mazan ent, áiárá shawkat o mazani dátag. ");
INSERT INTO bccl_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Pa rásti abadmánén barkat bakshátag o wati bagalá gal o shadánet kortag. ");
INSERT INTO bccl_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Chiá ke bádsháh Hodáwanday sará tawkala kant o borzén arshay Hodáwanday mehrá nalarzit. ");
INSERT INTO bccl_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Tai dast, sajjahén dozhmenán dara géjit, tai rástén dast pa áyán ke cha taw naprata kanant rasit. ");
INSERT INTO bccl_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Á wahdi ke záhera bay áyán porácheshén tarunéay paymá kanay. Hodáwand wati hezhmay tahá áyán éra bárt o áiay áchesh áyána wárt. ");
INSERT INTO bccl_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Áyáni padréchá cha zeminá gár o bégwáha kanay, chokk o nabiragánesh cha mardománi nyámá. ");
INSERT INTO bccl_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Harchont ke tai helápá palitén shawrbandi bekanant o badén repk o pandal besázant bale sóbéna nabant, ");
INSERT INTO bccl_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","chiá ke taw áyána táchénay, wahdé ke wati kamáná dém pa áyána tarrénay. ");
INSERT INTO bccl_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Oo Hodáwand! Gón wati zór o twáná anchosh maz‌anshán bátay. Tai wák o kodratá satá kanén o názénén. ");
INSERT INTO bccl_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. “Sahargáhi áskay” tarzay sará. Oo mani Hodá, oo mani Hodá! Taw chiá maná tahná esht? Pa ché cha mani rakkénagá dur ay, cha mani áh o peryátán sakk jetá ay. ");
INSERT INTO bccl_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Oo mani Hodá! Sajjahén róchá peryáta kanán o taw passawé nadayay, sajjahén shapá ham, bale áráma nagerán. ");
INSERT INTO bccl_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Angat ham taw pák o palgár ay, Bani Esráil tará názénit ke taw pa bádsháhi neshtagay. ");
INSERT INTO bccl_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","May petán tai sará tawkal kort, tai sará tawkalesh kort o taw rakkéntant. ");
INSERT INTO bccl_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Tai dargáhá peryátesh kort o rakketant, tai sará tawkalesh kort o pashal o sharmendag nabutant. ");
INSERT INTO bccl_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Záná, man ensáné naán, kermé án? Mardománi démá sobakk án o kawmay chammá béezzat. ");
INSERT INTO bccl_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Harkas ke maná gendit kalág o rishkand kant. Dapá chótha kanant, sará sorénant o gwashant: ");
INSERT INTO bccl_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Angat wati óst o ométá pa Hodáyá band, bell á tará berakkénit, berakkénit agan tará dósta dárit.” ");
INSERT INTO bccl_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Bale taw maná cha mátay lápá dar áwort o mátay sénagá ásudagi dát. ");
INSERT INTO bccl_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Cha pédáeshá tai baddhá dawr dayag bután, cha mátay lápá mani Hodá butagay. ");
INSERT INTO bccl_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Cha man dur mabay, chiá ke sakki o sóri nazzik ent o kassé pa komaká nést. ");
INSERT INTO bccl_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Bázén narén gókéá mani chapp o chágerd geptag, Báshánay sardhagáray zóráwarén gókán maná angerr kortag, ");
INSERT INTO bccl_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","wati práhén dapesh pa man parroptag, gorrók o derrókén shéráni paymá. ");
INSERT INTO bccl_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Chó ke ápá réchag o tálán butagán sajjahén haddhon cha bandán dar átkagant. Delon chó ke mómá áp ent o sénagá sóchit. ");
INSERT INTO bccl_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Zór o tágaton kunzagi chondhé ke hoshk butag o zobánon nokká lacchetag, maná markay háká wápéntaget. ");
INSERT INTO bccl_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kochekán mani chapp o chágerd geptag, sherr o badkáráni rombá angerr án, mani dast o pádesh thong thong kortagant, ");
INSERT INTO bccl_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","wati sajjahén haddhán shomár korta kanán. Áyán wati thélag pa man sakk kortagant, ");
INSERT INTO bccl_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","mani pocchán wati nyámá bahra kanant o jámagay sará pála janant. ");
INSERT INTO bccl_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Bale taw, oo Hodáwand! Dur mabay. Oo mani zór o tawkal! Pa mani komaká eshtáp kan. ");
INSERT INTO bccl_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Mani arwáhá cha zahm o shamshirá berakkén o mani zendagiá cha kochekáni zolm o zórákiá. ");
INSERT INTO bccl_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Maná cha shér o mazáráni dapá neját beday, ke taw maná cha wahshién káigaráni kánthán rakkéntag. ");
INSERT INTO bccl_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Tai námá pa wati brátán jára janán o mocchiay nyámá tará názénán. ");
INSERT INTO bccl_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Shomá, oo Hodátorsán! Áiá benázénét. Oo Ákubay sajjahén chokk o óbádagán! Áiá ezzat o shán bedayét. Oo Esráilay padréchán! Áiay haybatá bechárét. ");
INSERT INTO bccl_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Chiá ke áiá cha setam distagénay bazzagiá posht nakortag o démi cha áiá natarréntag. Peryáti ke kortag áiá eshkotagant. ");
INSERT INTO bccl_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Mazanén diwáná mani satá o saná pa taw ent, wati kawlán hamáyáni démá sarjama kanán ke Hodátors ant. ");
INSERT INTO bccl_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Békebr o darbésh waráka warant o séra bant o á ke Hodáyá shóháza kanant áiá názénant. shomay del tán abad zendag bát. ");
INSERT INTO bccl_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Zeminay chárén kondh áiá yáta kanant o dém pa Hodáwandá pera tarrant, sajjahén kawmáni hándán o kothom áiay bárgáhá sará jahla kanant. ");
INSERT INTO bccl_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Chiá ke bádsháhi Hodáwandayg ent o hamá ent ke kawmáni sará hákemia kant. ");
INSERT INTO bccl_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Zeminay sajjahén zóráwar waráka warant o áiay démá kapant, hákién ensán kóndhána kapit, hamá ke watá, wat zendag dáshta nakant. ");
INSERT INTO bccl_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Áyókén nasl áiay hezmatá bant, démi padréch Hodáwanday bárawá sahig kanaga bant o ");
INSERT INTO bccl_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","pa áyán ke angat wadi nabutagant áiay adl o ensápá jára janant. Gwashant: “Á hamá at ke é kári kort.” ");
INSERT INTO bccl_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dáuday Zabur. Hodáwand mani shopánk ent, hech chizzay mohtája nabán. ");
INSERT INTO bccl_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Maná sarsabzén charágáhána wápénit o pa árámén ápán sara kant. ");
INSERT INTO bccl_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Mani arwáhá tázaga kant o pa wati námaygi pahrézkáriay ráhán maná démá bárt. ");
INSERT INTO bccl_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Agan cha markay tahárterén shép o daragán ham begwazán cha hech bimm o baláhá natorsán, chiá ke taw gón man gón ay, tai latth o asá maná tasallá bakshit. ");
INSERT INTO bccl_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Dozhmenáni chammáni démá parzónagé pa man pacha kanay, pa sharapa dayagá mani saragá théla janay o mani jámá modám porr kanán ay. ");
INSERT INTO bccl_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Allamá, mehr o néki zenday sajjahén róchán mani pad o randá ant o Hodáwanday kalátá jahmenenda bán, tán abad. ");
INSERT INTO bccl_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Dáuday Zabur. Zemin o áiay sajjahén hasti Hodáwandayg ant, jahán o sajjahén mahluk. ");
INSERT INTO bccl_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Chiá ke Hodáwandá áiay bonyát mán daryáyá nádént o ápáni sará óshtárént. ");
INSERT INTO bccl_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Kay cha Hodáwanday kóhá borzád shota kant? Kay áiay pákén jágahá óshtáta kant? ");
INSERT INTO bccl_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Hamá ke deli sáp o dasti pák ent, hamá ke wati arwáhá dém pa náhudagiá natarrénit o drógén sawgenda nawárt. ");
INSERT INTO bccl_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Á cha Hodáwandá barkata gipt o cha wati rakkénókén Hodáyá, adl o ensáp. ");
INSERT INTO bccl_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Hamé paymá ant, á mardom ke Ákubay Hodáay shóházá ant, hamá ke pa áiay démá hodónák ant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Oo darwázagán! Wati sará borz bedárét. Oo kwahnén dar o dapigán! Watá pa sháhegáni pach kanét, tánke mazani o shánay bádsháh begwazit. ");
INSERT INTO bccl_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Mazani o shánay é bádsháh kay ent? Porwák o zóráwarén Hodáwand, Hodáwand ke jangá delér ent. ");
INSERT INTO bccl_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Oo darwázagán! Wati sará borz bedárét! Oo kwahnén dar o dapigán! Watá pa sháhegáni pach kanét, tánke mazani o shánay bádsháh begwazit. ");
INSERT INTO bccl_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Mazani o shánay é bádsháh kay ent? Lashkaráni Hodáwand hamá ent mazani o shánay bádsháh. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Dáuday Zabur. Oo Hodáwand! Man pa del o ján dém pa taw káyán. ");
INSERT INTO bccl_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Oo mani Hodá! Tai sará tawkala kanán, mayl ke pashal o sharmendag bebán o dozhmen mani sará báládast bebant. ");
INSERT INTO bccl_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Ji haw! Á ke tai sará óst o ométa kant hechbar sarjahla nabit. Á ke bé sawabá béwapáia kanant sarjahl o sharmendaga bant. ");
INSERT INTO bccl_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Oo Hodáwand! Ráhá maná pésh dár o wati keshká maná tálim day. ");
INSERT INTO bccl_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Dém pa wati rástiá maná rahshón bay o sabak beday, chiá ke taw mani rakkénókén Hodá ay o sajjahén róchá tai entezár o wadárá án. ");
INSERT INTO bccl_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Oo Hodáwand! Wati rahmat o mehrá yát kan, chiá ke á cha azalá hastant. ");
INSERT INTO bccl_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Mani warnáiay náparmáni o gonáhán yát makan, wati mehray kesásá maná yát kan ke taw nék ay, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Hodáwand nék o rást ent, paméshká gonahkárán ráhá sója dant. ");
INSERT INTO bccl_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Békebr o darbéshén mardomán rástiay ráhá rahshónia dant, wati keshká áyán pésha dárit. ");
INSERT INTO bccl_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Hamá ke Hodáwanday ahd o paymánay sará óshtant, áiay sajjahén ráh pa áyán cha mehr o wapáyá sarréch ant. ");
INSERT INTO bccl_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Oo Hodáwand! Pa wati námaygi mani gonáh o mayárán bebaksh, chiá ke mazan ant. ");
INSERT INTO bccl_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Kay ent hamá ke pa del Hodátors bebit? Hodáwand áiá hamá rástén ráhá sója dant ke báyad ent gechéni bekant. ");
INSERT INTO bccl_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Á wati róchán pa séri o azgária gwázénit, áiay chokk o óbádag zeminay mirás baróka bant. ");
INSERT INTO bccl_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Hodáwand wati delay ráz o ramzán gón Hodátorsán darshána kant, wati ahd o paymáná pa áyán pajjárénit. ");
INSERT INTO bccl_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Mani chamm modám dém pa Hodáwandá ant, chiá ke hamá ent ke mani pádán cha dámá ázáta kant. ");
INSERT INTO bccl_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Wati démá gón man bekan o maná rahmat bebaksh, chiá ke man békas o setam distagéné án. ");
INSERT INTO bccl_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Mani delay sakki o sóri báz ant, maná cha paréshániá berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Mani ranj o sakkián bechár o sajjahén gonáhánon bebaksh. ");
INSERT INTO bccl_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Mani dozhmenán bechár ke chinchok báz ant o cha man chón pa kahr naprata kanant. ");
INSERT INTO bccl_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Mani zendá bepahréz o berakkén, mayl ke sharmendag bebán, chiá ke tai báhóth o mayár án. ");
INSERT INTO bccl_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Tachki o rásti mani negahpán bát, chiá ke mani omét taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Oo Hodá! Esráilá cha sajjahén sakki o sórián berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Dáuday Zabur. Oo Hodáwand! Gonáhay bohtámá cha mani sará bethagalén, chiá ke wati bémayáriay tahá gámon jatag o bé larzagé Hodáwanday sará tawkalon kortag. ");
INSERT INTO bccl_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Hodáwandá! Maná bechakkás o ázmáesh kan, mani del o hayálá cha chakkásá begwázén. ");
INSERT INTO bccl_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Chiá ke tai mehr modám mani chammáni démá ent o tai wapádáriay sáhegá gáma janán. ");
INSERT INTO bccl_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Na gón prébkárán hamdiwána bán o na dotal o dopóstén mardománi hamráh. ");
INSERT INTO bccl_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Cha badkáráni hamráhiá naprata kanán o gón radkárán hamdiwána nabán. ");
INSERT INTO bccl_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Oo Hodáwand! Wati dastán bégonáhiay tahá shódán o tai korbánjáhay sará chahra warán, ");
INSERT INTO bccl_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","tán wati shogrgozáriay tawárá borz kanán o tai sajjahén ajabén káráni kessahá byárán. ");
INSERT INTO bccl_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Oo Hodáwand! Maná tai lóg sakk dóst ent, tai shán o shawkatay jágah. ");
INSERT INTO bccl_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Mani sáhá gonahkáráni hórigá mager o zendá gón hónigán, ");
INSERT INTO bccl_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","ke gandahén pandalesh dastá ent o rástén dastesh cha reshwatá sarréch. ");
INSERT INTO bccl_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Bale man wati bémayáriay tahá gáma janán, maná berakkén o mani sará rahm kan. ");
INSERT INTO bccl_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Pádon tachk o sápén jágahé ér ent, mazanén diwánán Hodáwandá názénán. ");
INSERT INTO bccl_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dáuday Zabur. Hodáwand mani rozhn o rakkénók ent, cha kayá betorsán? Hodáwand mani zenday kalát ent, cha kayá bimmé bebit? ");
INSERT INTO bccl_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Wahdé badkár hamlaha kanant ke mani jesm o jáná bederrant o ér bebarant, wahdé dozhmen o badwáh mani sará orosha kanant, á wat thagala warant o kapant. ");
INSERT INTO bccl_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Bell ke lashkaré mani chágerdá wati gedánán mekk bekant, angat mani dela nalarzit, agan jangé ham mani sará bekapit, angat deljam án. ");
INSERT INTO bccl_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Cha Hodáwandá yak chizzé lóthetagon o hameshiay pad o randá bán, ke wati zenday sajjahén róchán Hodáwanday lógá jahmenend bebán, tánke Hodáwanday zébáiá begendán o parasteshgáhá cha hamáiá rahshóni belóthán. ");
INSERT INTO bccl_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Chiá ke sakki o sóriáni róchá maná wati sáhegá dárit, wati tambuay tahá chéra dant o taláréay sará borzá óshtárénit. ");
INSERT INTO bccl_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Nun dozhmenáni angerrá sarperáza bán o gón shádmániáni kukkárá áiay tambuay tahá korbániga kanán, Hodáwandá pa sawt o sáza názénán. ");
INSERT INTO bccl_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Oo Hodáwand! Wahdé peryáta kanán mani tawárá beshkon, mani sará rahm kan o passaw beday. ");
INSERT INTO bccl_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Taw gwashtag: “Mani chehragay shóházá bebay.” Dela gwashit: “Hodáwandá! Tai chehragay shóházá án.” ");
INSERT INTO bccl_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Démá cha man chér maday, wati hezmatkárá gón hezhm per matarrén, taw ke mani madatkár butagay. Oo mani rakkénókén Hodá! Maná dawr maday o yalah makan. ");
INSERT INTO bccl_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Agan mát o pet ham maná yalah bekanant, Hodáwand wat maná zurit o dasta gipt. ");
INSERT INTO bccl_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Oo Hodáwand! Wati ráhá maná sój day, dozhmenáni sawabá maná rást o tachkén ráhá rahshón bay. ");
INSERT INTO bccl_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Pa dozhmenáni wáhagá maná yalah makan, chiá ke drógén sháhed mani helápá pád átkagant ke jang o chópay ásá damant. ");
INSERT INTO bccl_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Deljam án ke Hodáwanday nékiá zendagénáni zeminá gendán. ");
INSERT INTO bccl_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Hodáwanday wadárá bay, zórmand bay o delá dhaddh kan. Haw! Hodáwanday wadárá bay. ");
INSERT INTO bccl_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Dáuday Zabur. Oo Hodáwand, oo mani talár! Tará tawára kanán, cha man nádelgósh mabay. Agan taw bétawár bebay, hamáyáni paymá bán ke kall o kabrá kapant. ");
INSERT INTO bccl_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Mani peryát o záriay tawárá gósh dár, wahdé cha taw madata lóthán o wati dastán dém pa tai pákén bárgáhá borza kanán. ");
INSERT INTO bccl_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Maná badkáráni hamráhiá gerrán makan o makassh, hamá ke radén kára kanant o gón hamsáhegán cha sohl o saláhá habará ant, bale delesh cha sherr o shórá porr ent. ");
INSERT INTO bccl_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Kortagén káráni mozzáesh beday, hamsang gón áyáni badén kárán, dastay kortagénáni mozzáesh beday, áyáni káráni kaddá. ");
INSERT INTO bccl_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Paméshká ke Hodáwanday káráni parwáhá nakanant, áiay dazhonaray káráni háterá nadárant, á eshán tabáha kant o hechbar pa rost o rodómá naylit. ");
INSERT INTO bccl_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Hodáwandá satá bát, chiá ke mani peryát o záriay tawári eshkotag. ");
INSERT INTO bccl_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Hodáwand mani zór o espar ent, delon áiay sará tawkala kant o madaton rasetag. Del cha shádmániá sarréch ent o gón wati sawt o názénkán áiay shográ gerán. ");
INSERT INTO bccl_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Hodáwand wati mardománi zór o twán ent, pa rógen per moshtagéná rakkagay kaláté. ");
INSERT INTO bccl_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Wati mardomán berakkén o wati kawmá barkat beday, áyáni shopánk bay o tán abad wati kópagá bejallesh. ");
INSERT INTO bccl_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Dáuday Zabur. Oo ásmánián! Hodáwandá satá kanét, Hodáwanday shán o kodratá satá kanét. ");
INSERT INTO bccl_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Hodáwanday námay shán o shawkatá satá kanét, Hodáwandá mán áiay pák o palgárén drapshnákiá satá kanét. ");
INSERT INTO bccl_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Hodáwanday tawár ápáni sarborá ent, shán o shawkatay Hodá grandit, Hodáwand porzórén ápáni sarborá grandit. ");
INSERT INTO bccl_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Hodáwanday tawár zórmand ent, Hodáwanday tawár drapshnák ent. ");
INSERT INTO bccl_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Hodáwanday tawár gazzána próshit, Hodáwand Lobnánay gazzána próshit. ");
INSERT INTO bccl_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Á Lobnáná gwaskéay paymá jáha serrénit, Siryuná jalabén gókéay paymá. ");
INSERT INTO bccl_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Hodáwanday tawár grand o grókén áchesh rawána kant. ");
INSERT INTO bccl_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Hodáwanday tawár gyábáná larzénit, Hodáwand Kádeshay gyábáná larzénit. ");
INSERT INTO bccl_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Hodáwanday tawár áposén áskána géjénit o jangalá bé lamb o táka kant. Áiay parasteshgáhá sajjahén gwánka janant: “Shawkat o shán!” ");
INSERT INTO bccl_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Hodáwand hár o tuppánay sarborá, wati tahtay sará neshtag, Hodáwand tán abad wati bádsháhi tahtay sará neshtag. ");
INSERT INTO bccl_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Hodáwand wati kawmá wák o kodrat bebakshát, Hodáwand wati kawmá gón sohl o émeni barkat bedayát. ");
INSERT INTO bccl_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Dáuday Zabur. Pa mazanén parasteshgáhay wapká sawté. Oo Hodáwand! Tará shán o shawkata dayán, chiá ke taw maná cha johlánkián chest kort o naeshtet dozhmen mani sará shádehi bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Oo Hodáwand, mani Hodá! Tai gwará pa komaká peryáton kort o taw maná cha nájórhiá dráh kort, ");
INSERT INTO bccl_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","mani arwáh cha mordagáni jaháná dar áwort o cha áyáni nyámá ke kall o kabr butant zendag kort. ");
INSERT INTO bccl_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Oo Hodáwanday dóstdárán! Pa Hodáwandá názénk bejanét, áiay pák o palgárén námay shográ begerét. ");
INSERT INTO bccl_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Chiá ke hezhmi damáné o mehr o rahmati omray drájiá. Bit ke sajjahén shapé pa gréwag begwazit, bale bámgwáhá shádehi wati chehragá záhera kant. ");
INSERT INTO bccl_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Man wati ásudagiay wahdá gwasht: “Hechbar larzénaga nabán.” ");
INSERT INTO bccl_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Oo Hodáwand! Taw maná cha wati mehr o rahmatá mohrén kóhéay paymá óshtáréntagat, bale wahdé wati démet cha man tarrént, torseton. ");
INSERT INTO bccl_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Oo Hodáwand! Tará tawáron jat, tai gwará zári o peryáton borz kort: ");
INSERT INTO bccl_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Mani marká che sutté mán o kabray tahá mani ér rawagá chónén páedagé? Záná, hák tará satá dant? Jára jant ke taw wapádár ay? ");
INSERT INTO bccl_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Oo Hodáwand! Beshkon o mani sará mehrabán bay. Hodáwandá! Mani madat kanók bay.” ");
INSERT INTO bccl_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Taw mani mótk nách o sohbaté kort, sugi god o póshák dar kort o maná gón shádmániá póshént, ");
INSERT INTO bccl_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","tánke mani arwáh tará satá bedant o bétawár mabit. Oo Hodáwand, mani Hodá! Tán abad tai shográ gerán. ");
INSERT INTO bccl_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodáwand! Tai mayár o báhóth butagán, hechbar mayl ke sharmendag bebán, wati adl o ensápay tahá maná neját beday. ");
INSERT INTO bccl_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Wati delgóshá gón man bedár o maná zutt berakkén. Pa man panáhay taláré bay o pa mani rakkénagá mohrén kaláté. ");
INSERT INTO bccl_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Pa rásti mani talár o kalát ay, pa wati námaygi maná ráh sója dayay o rahshónia kanay. ");
INSERT INTO bccl_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Maná cha á dámá dar byár ke pa man chér o andém ent, chiá ke mani panáh taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Wati ruh o sáhá tai dastá dayán. Oo Hodáwand, oo wapádárén Hodá! Taw maná rakkénay. ");
INSERT INTO bccl_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Tará cha áyán naprat ent ke delgóshesh gón béarzeshén botán ent, bale man tai sará tawkala kanán, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Tai mehrá gala bán o shádehia kanán, chiá ke taw mani syahróchi distagant o mani arwáhay sakkiáni némagá hayál gwar kortag. ");
INSERT INTO bccl_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Maná dozhmenáni dastá nadayay o mani pádán práh o sháygánén jágahé éra kanay. ");
INSERT INTO bccl_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Oo Hodáwand! Mani sará rahm kan chiá ke paréshán án, chammon cha gam o andóhán nezór butagant, jesm o arwáh ham. ");
INSERT INTO bccl_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Chiá ke zendon gamán wártag o omr nálagán, cha mani gonáhá, tágaté pa man pasht nakaptag o haddh o bandon pussán ant. ");
INSERT INTO bccl_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Dozhmenáni sawabá sobakk o kalági butagán, hás pa hamsáhegán, pajjárók cha man torsán ant o harkas maná kuchah o damkána gendit, tachit. ");
INSERT INTO bccl_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Mordagáni warhá cha yátá shotagán o proshtagén kunzagéay paymá butagán. ");
INSERT INTO bccl_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Chiá ke bázénéay bohtámán eshkonagá án, tors o dehshat cha har gwará, gón yakdegará pandala jórhénant o pa mani koshagá mandr o repka sázant. ");
INSERT INTO bccl_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Bale oo Hodáwand! Man tai sará tawkala kanán o gwashán ke “taw mani Hodá ay.” ");
INSERT INTO bccl_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Mani wahd o damán tai dastá ant, maná cha dozhmenán berakkén, cha hamáyán ke mani randá kaptagant. ");
INSERT INTO bccl_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Démá pa wati hezmatkárá drapshán kan, gón wati mehrá maná berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Hodáwandá! Mayl ke sharmendag bebán, chiá ke tará tawáron per jatag, bell ke sharur sarjahl o sharmendag bebant o mordagáni jaháná bétawár. ");
INSERT INTO bccl_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Drógbandén lonthesh chopp bátant, ke gón kebr o ér janag pahrézkáráni helápá pa gorunáki habara kanant. ");
INSERT INTO bccl_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Tai néki chenkadar báz ent, ke pa Hodátorsán ambáret kortag o bani ádamáni chammáni démá pa hamáyán purah o sarjam kortag ke tai báhótha bant. ");
INSERT INTO bccl_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Eshán wati bárgáhay panáhá cha mardománi pandalán chér o andéma dáray o wati sáhegá cha bohtám janókén zobánán dur. ");
INSERT INTO bccl_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Hodáwandá satá bát, chiá ke wati ajabén mehrá hamé wahdá pa man paddara kant ke man dawrah butagén shahréay paymá angerr án. ");
INSERT INTO bccl_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Man cha wati torsá gwasht: “Cha tai chammá sestag o dur kaptagán.” Angat taw mani peryát o záriá eshkonay, wahdé man pa madatá tará tawára kanán. ");
INSERT INTO bccl_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Oo Hodáwanday sajjahén dóstdárán! Áiá dóst bedárét, Hodáwand wati wapádáráni negahpániá kant, bale gorunákénán báz sezá dant. ");
INSERT INTO bccl_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Oo sajjahénán ke Hodáwanday wadárá ét! Porzór bebét o delá dhaddh kanét. ");
INSERT INTO bccl_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Dáuday shayri gwashtánk. Bahtáwar hamá ent ke Hodáwand cha áiay násharián sar gwastag o gonáhi bakshag butagant. ");
INSERT INTO bccl_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Bahtáwar hamá ent ke Hodáwand áiay gonáhá hechbar hesába nayárit o áiay arwáhá prébé mán nést. ");
INSERT INTO bccl_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Wahdé chopp o bétawár atán haddh o bandon pussán atant, cha sajjahén róchay zári o peryátán. ");
INSERT INTO bccl_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Chiá ke róch o shap tai dast mani sará sangin at, sajjahén tágaton hoshagá at, chó ke garmágay taptay chérá bebán. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Gorhá wati gonáhon tai dargáhá mannet o wati náparmániánon chér nadát. Gwashton: “Wati gonáh o sarkashián Hodáwanday gwará mannán” o taw mani gonáhay mayárbári bakshet. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Paméshká, tán wahd o móh ent, har Hodádóst tai gwará dwá bekant, wahdé hárén áp chesta bant, hech paymá pa áiá sar buta nakanant. ");
INSERT INTO bccl_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Taw mani chér bayagay jágah ay, cha sakki o tangián maná émena dáray o gón ázátiay sawt o zémelán gwarambáza kanay. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Hodáwanda gwashit: “Tará hamá ráhá sója dayán ke báyad ent beraway, tará shawr o saláha dayán o tará chárána bán. ");
INSERT INTO bccl_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Násarpadén asp yá kacharay paymá mabay, ke tahná gón lagám o mahárá rám kanaga bit, agan na, tai nazziká nayayt.” ");
INSERT INTO bccl_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Badkáray ranj o azáb báz ant, bale Hodáwanday mehr hamáiay chapp o chágerdá gipt ke Hodáwanday sará tawkala kant. ");
INSERT INTO bccl_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Oo pahrézkárán! Hodáwanday bárgáhá shádehi kanét o shádán bebét. Oo sajjahén nékdelán! Shádehiay gwánká borz kanét. ");
INSERT INTO bccl_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Oo pahrézkárán! Hodáwanday bárgáhá pa shádehi kukkár kanét, nékdelán, Hodáwanday satá kanag zéba dant. ");
INSERT INTO bccl_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Hodáwandá gón chang benázénét, gón dahtárén changá pa áiá sáz bejanét. ");
INSERT INTO bccl_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Pa áiá, nókén sawté byárét, gón washpanjagi simmán belarzénét o pa shádehi gwánk janét. ");
INSERT INTO bccl_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Chiá ke Hodáay habar tachk o rást ent o áiay sajjahén kár gón wapádáriá. ");
INSERT INTO bccl_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Áiá adl o rásti dósta bit, zemin cha áiay mehrá porr ent. ");
INSERT INTO bccl_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Gón Hodáwanday gál o habará ásmán addh butagant o áyáni sajjahén lashkar, gón áiay dapay damá. ");
INSERT INTO bccl_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Daryáay ápán mocch o hákótha kant o johlián mán ambárá. ");
INSERT INTO bccl_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Sajjahén zemin cha Hodáwandá betorsit, jahánay sajjahén mardom áiá ezzat bedayant. ");
INSERT INTO bccl_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Chiá ke áiá gwasht o hamá chizz paym but, parmáni dát o barjáh dárag but. ");
INSERT INTO bccl_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Hodáwand, kawmáni shawrbandián pacha réchit o rájáni kársáziána karójit. ");
INSERT INTO bccl_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Bale Hodáwanday shawr o saláh abadmán ant, áiay delay shawrbandi pa sajjahén nasl o padréchán. ");
INSERT INTO bccl_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Bahtáwar hamá kawm ent ke Hodáwand áiay Hodá ent, hamá mardom ke áiá pa wati mirásá gechén kortagant. ");
INSERT INTO bccl_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Hodáwand cha ásmáná jahláda chárit o sajjahén bani ádamána gendit, ");
INSERT INTO bccl_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","cha wati bádsháhi tahtá zeminay sajjahén jahmenendána chárit, ");
INSERT INTO bccl_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","á ke é sajjahénáni deli jórh kortag o áyáni har kár o kerdá zánt. ");
INSERT INTO bccl_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Bádsháhá, wati lashkaray mazani nejáta nadant o sarmachárá, wati básk o panjagáni zór. ");
INSERT INTO bccl_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Pa sóbén bayagá, aspay sará omét bandag náhudag ent, toré zóráwar bebit bale rakkénta nakant. ");
INSERT INTO bccl_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Haw! Hodáwanday chamm gón hamáyán ent ke cha áiá torsant, gón hamáyán ke óst o ométesh áiay mehr ent, ");
INSERT INTO bccl_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","tánke áyáni arwáhá cha marká berakkénit o mán dhokkálá zendagesh bedárit. ");
INSERT INTO bccl_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","May arwáh Hodáwanday wadárá ent, hamá may komak o espar ent. ");
INSERT INTO bccl_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","May del áiay bárgáhá shádmánia kant, chiá ke may tawkal hamáiay pákén námay sará ent. ");
INSERT INTO bccl_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Oo Hodáwand! Tai mehr may sará sáhél bát, hamá dábá ke ométen pa taw bastag. ");
INSERT INTO bccl_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Dáuday Zabur. Hamá wahdá ke áiá Abimelekay kerrá watá ganókáni paymá kort, cha ódá dar kanag but o wati ráhá shot. Dáemá Hodáwandá názénán áiay satá o saná modám mani dapá ent. ");
INSERT INTO bccl_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Mani arwáh Hodáwanday sará pahra kant, békebrén mardom beshkonant o shádehi bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Gón man hórigá Hodáwandá mazani bedayét, byáét ke hawáriá áiay námá názénén. ");
INSERT INTO bccl_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Hodáwandon shóház kort o maná passawi dát, cha mani sajjahén torsán maná ázáti kort. ");
INSERT INTO bccl_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Á ke chammesh gón áiá ent drapshán ant, áyáni dém hechbar sharmsára nabit. ");
INSERT INTO bccl_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","É meskiná tawár per jat, Hodáwandá áiay tawár eshkot o cha sajjahén sakkián rakkénti. ");
INSERT INTO bccl_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Hodáwanday préshtag Hodátorsáni chapp o chágerdá pallé bandit o áyán nejáta dant. ");
INSERT INTO bccl_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Bechashét o bechárét ke Hodáwand nék ent, bahtáwar hamá ent ke áiay mayár o báhótha bit. ");
INSERT INTO bccl_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Oo Hodáwanday palgártagénán! Cha Hodáwandá betorsét, chiá ke Hodátorsán hech kammié nést. ");
INSERT INTO bccl_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Warnáén shér mohtáj o shodiga bant, bale Hodáwanday shóház kanókán cha nékiá hech kammié nést. ");
INSERT INTO bccl_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Oo chokkán! Byáét o cha man beshkonét, man shomárá sabaka dayán ke Hodáwandá chón bemannét. ");
INSERT INTO bccl_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Cha shomá kay pa zendá hodónák ent o wasshén rócháni gendagay lóthók? ");
INSERT INTO bccl_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Wati zobáná cha badiá dur bedár o lonthán cha drógá. ");
INSERT INTO bccl_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Cha badiá per tarr o néki kan, sohl o émeniay shóházá bebay o hameshiay randá bekap. ");
INSERT INTO bccl_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Hodáwanday chamm gón pahrézkárán ent o góshi ham pa áyáni peryátán pach. ");
INSERT INTO bccl_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Hodáwanday dém badkáráni helápá ent, tán áyáni yátá cha jaháná beborrit o gomsár bekant. ");
INSERT INTO bccl_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Wahdé pahrézkár peryáta kanant, Hodáwanda eshkont o áyán cha sajjahén sakkiána rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Hodáwand gón proshtadelán nazzik ent o droshtaruhán rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Pahrézkárá bázén sakki o sória rasit, bale Hodáwand áiá cha sajjahén sakkiána rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Áiay sajjahén haddhán mohra dárit, cha áyán yakké ham próshaga nabit. ");
INSERT INTO bccl_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Badi badkárá koshit o hamá ke cha pahrézkárá naprata kant, mayárbára bit. ");
INSERT INTO bccl_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Hodáwand wati hezmatkáráni zendá rakkénit, harkas ke áiay báhótha bit, mayárbára nabit. ");
INSERT INTO bccl_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Dáuday Zabur. Oo Hodáwand! Gón hamáyán bemerh ke gón mana merhant o gón hamáyán jang kan ke gón man janga kanant. ");
INSERT INTO bccl_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Wati kasán o mazanén esparán bezur o mani madatá jáh bejan. ");
INSERT INTO bccl_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Pa áyán ke mani randá kaptagant wati nayzahá chest kan o áyáni ráhá band. Mani arwáhá begwash: “Tai rakkénók man án!” ");
INSERT INTO bccl_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Á ke mani zenday tabáhiay randá ant, roswá o sharmendag bátant. á ke pa mani táwáná pandala jórhénant, poshtá bekenzát o pashal bátant. ");
INSERT INTO bccl_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Chosh ke pog o palár gwátay démá, Hodáwanday préshtag áyán betáchénát. ");
INSERT INTO bccl_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Ráhesh tahárók o lakoshánk bát o Hodáwanday préshtag áyáni padá bekapát, ");
INSERT INTO bccl_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","chiá ke mopt o náhakká pa man dámesh chér gétkag o pa mani arwáhá kallesh kótkag. ");
INSERT INTO bccl_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Anágat tabáhi‌esh chakká kapát o wati chér gétkagén dámá kapátant, kapát o gár o gomsár bátant. ");
INSERT INTO bccl_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Gorhá mani arwáh Hodáwanday bárgáhá shádehia kant o pa wati rakkagá lezzata bárt. ");
INSERT INTO bccl_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Á wahdá har band o bógon gwánka jant: “Oo Hodáwand! Tai matth kay ent? Taw nézgárá cha zóráwarteréná rakkénay o nezór o hájatmandá cha pol o pánch kanóká.” ");
INSERT INTO bccl_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Badwáh o bérahmén sháhed jáha janant o hamá mayárán maná laddhant ke cha áyán sahig naán. ");
INSERT INTO bccl_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Nékiay badalá gón man badia kanant o mani arwáh gamig o porsig ent. ");
INSERT INTO bccl_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Bale wahdé á nádráh atant, man sugi god o póshák gwará kort o jesm o ján gón róchag dáragá ranjént. Wahdé mani dwá bépassaw mantant ");
INSERT INTO bccl_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","gréwán bután, hamá dábá ke pa dóst yá brátéá gamiga bant, sar jahl o mótk árán bután, hamá dábá ke pa mátá zára janant. ");
INSERT INTO bccl_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Bale wahdé thagalon wárt past o lagór gón mazanén shádehié mocch butant, mani helápá wahdé man sahig naatán, á maná derrán atant o bassesha nakort. ");
INSERT INTO bccl_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Chó Hodánábáwarán, áyán wati maskará gésh kanána kort o pa man dantánesha drosht. ");
INSERT INTO bccl_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Oo Hodáwand! Tán kadéna nenday o cháray? Mani arwáhá cha áyáni setamá berakkén, mani yakkén zendá cha shéráni dapá. ");
INSERT INTO bccl_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Gorhá mazanén diwáná tai shográ gerán, mardománi mazanén mocchiá tará satá kanán. ");
INSERT INTO bccl_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Mayl ke prébkárén dozhmen mani sará shádehi kanant, mayl hamá ke mopt o náhakká cha man bézár ant chammok o pónzok bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Chiá ke pa sohl o émeni habara nakanant, pa á mardomán ke molká árám o béják neshtagant pormakrén habar payma kanant. ");
INSERT INTO bccl_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Dapá pa man pacha réchant o gwashant: “Hah, hah, hah! Gón wati chammánen distag!” ");
INSERT INTO bccl_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Oo Hodáwand! Taw é distag, chopp o bétawár mabay. Hodáwandá! Cha man dur mabay. ");
INSERT INTO bccl_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ágáh bay o pa mani dádrasiá jáh bejan. Oo mani Hodá, oo mani Hodáwand! Pa mani hakká. ");
INSERT INTO bccl_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Oo mani Hodáwandén Hodá! Pa wati adlaygi gonáhay bohtámá cha man thagalén, mayl á mani sará shádehi bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Mayl wati delá begwashant: “Hah, hah, hah! Pa wati armáná rasetén.” Mayl begwashant: “Lonkahé kort o éren bort.” ");
INSERT INTO bccl_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Harkas ke mani mosibatáni sará shádehia kant sharmendag o sarjahl bát, á ke watá cha man borztera kanant gón sharm o bésharapi póshénag bátant. ");
INSERT INTO bccl_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Á ke wáhagesh mani bémayári ent shádmán bátant o shádehiay gwánká borz kanátant, modám begwashátant: “Hodáwand mazan ent ke cha wati hezmatkáray salámatiá gala bit.” ");
INSERT INTO bccl_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Gorhá zobánon sajjahén róchá tai adlá gwánka jant, tai satá o sanáyá. ");
INSERT INTO bccl_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Pa sázger o washáwázáni sálárá. Hodáwanday hezmatkár Dáuday Zabur. Gonáh, badkárá mán áiay delay johlánkiá gwánka jant, áiay chammán Hodátorsi nést. ");
INSERT INTO bccl_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Chiá ke á wati jenday delá haminchok wati tawsipá kant, ke wati gonáhá nazánt o cha áiá naprat korta nakant. ");
INSERT INTO bccl_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Dapay habari badi o préb ent, cha aglmandi o nékkáriá dasti shoshtag. ");
INSERT INTO bccl_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Tantaná wati gandal o bestará pandala sázit, gonahkáriay ráhi geptag o badiá yalaha nakant. ");
INSERT INTO bccl_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Oo Hodáwand! Tai mehr arshá rasit o wapádári tán jambarán. ");
INSERT INTO bccl_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Tai adl o rásti borzterén kóháni dhawlá ent o ensáp, mazanén johlánkiáni. Oo Hodáwand! Taw ay ke ensán o haywánay rakkénók ay. ");
INSERT INTO bccl_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Oo Hodá! Tai mehr chenkadar porarzesh ent, bani ádam tai bánzoláni sáhegá panáha gipt. ");
INSERT INTO bccl_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Á cha tai bárgáhay sarréchén nyámatán séra bant o cha wati lezzatáni kawrá áyán sérápa kanay. ");
INSERT INTO bccl_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Chiá ke zendmánay sarchammag taw ay o cha tai nurá ent ke nura gendén. ");
INSERT INTO bccl_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Pa wati dóstdárán wati mehrá modám barjáh dár o adl o rástiá pa nékdelán. ");
INSERT INTO bccl_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Porkebráni pád mani sará ér mabát, badkáráni dast maná sargardán makanát. ");
INSERT INTO bccl_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Bechár badkár che paymá kaptagant, háká sarshakun o pád átka nakanant. ");
INSERT INTO bccl_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dáuday Zabur. Badkáráni sawabá jósh majan o radkáráni sará hasadd makan. ");
INSERT INTO bccl_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Chiá ke é káhay paymá zutta gimmorant o sabzagáni paymá hoshka tarrant. ");
INSERT INTO bccl_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Hodáay sará tawkal kan o nékiay ráhá ger, wati molká jahmenend bay o wapádáriay randgir. ");
INSERT INTO bccl_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Cha Hodáwandá shádmán bay ke á tai delay morádá puraha kant. ");
INSERT INTO bccl_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Wati zendmánay ráhá Hodáwanday sepordag kan o áiay sará tawkal, ke kársáz hamá ent. ");
INSERT INTO bccl_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Á tai bémayáriá nuray paymá róshena kant o dádrasiá chó bámgwáhay rozhnáiá drapshán. ");
INSERT INTO bccl_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Hodáwanday bárgáhá árám bay o gón ópáré áiay wadárá. Áyáni sawabá jósh majan ke wati ráhá kámrán ant o áyáni sawabá ham ke palitén pandalán kára bandant. ");
INSERT INTO bccl_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Cha hezhmá dur bay o gazabá yalah kan. Jósh majan ke tará dém pa badkáriá bárt. ");
INSERT INTO bccl_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Chiá ke badkár goddhaga bant, bale á ke Hodáwanday wadárá ant molká mirása barant. ");
INSERT INTO bccl_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Kammoké wahdá rand badkára namánit, shomá áiá sakk báz shóháza kanét bale nagendéti. ");
INSERT INTO bccl_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Narmdel molká mirása barant o cha wasshén sohl o émeniá shádkámia kanant. ");
INSERT INTO bccl_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Badkár pahrézkáray helápá pandala sázit o pa áiá dantána droshit, ");
INSERT INTO bccl_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","bale Hodáwand badkáray sará kandit, chiá ke zánt áiay rócha kayt. ");
INSERT INTO bccl_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Badkár wati zahmá cha nyámá dara kanant o kamáná kasshant, tán nezór o hájatmandán chér betarrénant o nékdelán tégáni dapá bedayant. ");
INSERT INTO bccl_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Bale áyáni zahm, wati jenday delá nendit o kamánesha proshant. ");
INSERT INTO bccl_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Pahrézkáray kammén hasti cha bázén badkáráni hastiá gehter ent. ");
INSERT INTO bccl_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Chiá ke badkáráni báskay zóra proshit, bale Hodáwand pahrézkáráni madat kanók ent. ");
INSERT INTO bccl_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Hodáwand bégonáháni rócháni negahpán ent o mirásesh namirána bit. ");
INSERT INTO bccl_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Baláh o mosibatáni wahdá bazzag o sharmendaga nabant o kahti o dhokkálay róchán sér o ábáda bant. ");
INSERT INTO bccl_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Bale badkár gára bant, Hodáwanday dozhmen charágáhay sabzagáni paymá gár. Haw! Zyána bant, duttay paymá zyán. ");
INSERT INTO bccl_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Badkár wáma kant o padá nadant, bale pahrézkár pa daspachia bakshit. ");
INSERT INTO bccl_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Allamá, áyán ke Hodáwand barkata dant molká mirása barant, bale áyán ke nálata kant, gár o bégwáha bant. ");
INSERT INTO bccl_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Hodáwand hamáiay gámán mohra kant ke Hodáwanday ráhá shádehia kant. ");
INSERT INTO bccl_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Toré bethagalit, zeminá nakapit, chiá ke Hodáwand áiay negahpán ent. ");
INSERT INTO bccl_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Warná atán o nun pir án, bale choshén pahrézkáré nadiston ke Hodáwandá yalah kortag yá ke chokki pa nánéá gadá butagant. ");
INSERT INTO bccl_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Modám daspach ent o pa ásáni wáma dant, chokki barkata kárant. ");
INSERT INTO bccl_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Cha badiá démá chahr day o néki kan, gorhá tán abad molká jahmenenda bay. ");
INSERT INTO bccl_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Chiá ke Hodáwandá adl dóst ent o wati dóstdárán yalaha nakant. Hodáwand tán abad pahrézkáráni posht o panáh ent, bale badkáráni nasl goddhaga bit. ");
INSERT INTO bccl_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Pahrézkár molká mirása barant o tán abad hamódá jahmenenda bant. ");
INSERT INTO bccl_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Pahrézkáray dap hekmat tálána kant o zobáni adl. ");
INSERT INTO bccl_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Hodáwanday Sharyat áiay delá ent o pádia nalakoshant. ");
INSERT INTO bccl_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Badkár, pa pahrézkárá kamina kant o áiay kóshay randá ent. ");
INSERT INTO bccl_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Bale Hodáwand áiá badkáray zóray tahá naperrénit o wahdé hakdiwáná baraga bit, pa mayárbáriá nayliti. ");
INSERT INTO bccl_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Hodáwanday wadárá bay o hamáiay ráhá bósht, ke tará pa molkay mirás baragá sarperáza kant, wata genday ke badkár chón goddhaga bant. ");
INSERT INTO bccl_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Badkár o bérahmén mardé diston ke sarsabzén drachkéay paymá wati jáhá shádáb at, ");
INSERT INTO bccl_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","bale namant o zutt mort, harché shóházon kort, gendag nabut. ");
INSERT INTO bccl_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Béaybén mardá begend o nékdelá bechár, chiá ke sohl o émeniay shóház kanóká ákebaté hast, ");
INSERT INTO bccl_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","bale sajjahén sarkash gár o gomsára bant, badkár goddhaga bant o áyán ákebaté nést. ");
INSERT INTO bccl_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Pahrézkáráni rakkénók Hodáwand ent o sakkiay wahdá áyáni kalát. ");
INSERT INTO bccl_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Hodáwand áyán madata dant o rakkénit, cha badkáráni dastá rakkénit o nejáta dant, chiá ke áiay mayár o báhóth ant. ");
INSERT INTO bccl_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Dáuday Zabur. Dazbandié. Oo Hodáwand! Maná gón wati hezhmá hakkal maday o gón wati gazabá neherr. ");
INSERT INTO bccl_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Chiá ke tai tirán mani ján soptag o tai dastay zór mani sará kaptag. ");
INSERT INTO bccl_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Cha tai gazabá mani jesm o jáná hech dráhié pasht nakaptag o cha gonáhá, mán haddhán ham salámatié. ");
INSERT INTO bccl_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Mani mayárbári cha sará sar gwastag, gránén báréay paymá cha tágatá gésh ent. ");
INSERT INTO bccl_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Cha mani ahmakiá thappon bó geptag o bazhnák ant. ");
INSERT INTO bccl_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Purah komp o dotal án, sajjahén róchá mátam kanáná gardán. ");
INSERT INTO bccl_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Sréná sóchnákén dardé tawrénagá ent o jesmá dráhié nést. ");
INSERT INTO bccl_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Man ájez án o droshag butagán, cha delay áshópá nálán. ");
INSERT INTO bccl_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Oo Hodáwand! Mani sajjahén armán tai démá ant, áhsard o ginsárton cha taw chér naant. ");
INSERT INTO bccl_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Delon mán sénagá kop koppá ent, wák o twánon dar shotag, chammáni rozhnái ham gár ent. ");
INSERT INTO bccl_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Dóst o hambalon thappáni sawabá cha man watá kerré dárant o nazzikén ham dur óshtátagant. ");
INSERT INTO bccl_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Á ke mani kóshay randá ant, dám chéra kanant, badwáh mani gomsár kanagay habará kanant o sajjahén róchá pandala sázant. ");
INSERT INTO bccl_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Bale man karréay paymá án ke naeshkont o gongéay paymá ke bétawár ent. ");
INSERT INTO bccl_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Pa rásti man anchén mardoméay dhawlá án ke naeshkont o dapá passawé nésti. ");
INSERT INTO bccl_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Oo Hodáwand! Pa taigi ent ke wadárá án. Oo Hodáwand, mani Hodá! É taw ay ke passawa dayay. ");
INSERT INTO bccl_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Chiá ke gwashton: “Wahdé pádona larzit, hamá mardomán mani sará shádehi kanagá mayl ke watá cha man mastera zánant.” ");
INSERT INTO bccl_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Chiá ke kapagi án o mani dard modám gón man gón ent. ");
INSERT INTO bccl_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Wati mayárbáriá mannán o cha wati gonáhá sakk padard án. ");
INSERT INTO bccl_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Sarzór o salámat ant, á ke mani dozhmen ant, bázéné bé sawabá cha man naprata kant. ");
INSERT INTO bccl_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Á ke nékiay badalá gón man badia kanant, mani dozhmen o bohtám janók ant, chiá ke man nékiay randá án. ");
INSERT INTO bccl_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Oo Hodáwand! Maná yalah makan. Oo mani Hodá! Cha man dur mabay. ");
INSERT INTO bccl_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Oo Hodáwand, mani rakkénók! Pa mani madatá eshtáp kan. ");
INSERT INTO bccl_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Pa sázger o washáwázáni sálárá. Pa Yedutuná. Dáuday Zabur. Gwashton ke “pahréza kanán tán gón wati zobáná gonáh makanán. Tán wahdé badkáré mani kerrá ent wati dapá lagáma kanán.” ");
INSERT INTO bccl_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Chopp o bétawár bután, tantaná sharrén habaré ham nakorton, bale dard o andóhon géshter butant. ");
INSERT INTO bccl_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Delon mán daruná jósh janagá ent. Wahdé géshter pegrona kort, ásá shamálaha kasshet, gorhá zobánon pach but. ");
INSERT INTO bccl_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Oo Hodáwand! Mani ákebatá paddar kan, mani rócháni hesáb chi ent, bell tán bezánán ke chón zutta gwazant. ");
INSERT INTO bccl_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Taw mani zend bechilléay kaddá kortag, mani zendmánay sál, tai chammá hecch naant. Saddak án ke ensánay zend yak sáhé gésh naent.” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Béshakk ensán chó sáhegéá chakkarit, béshakk ke á mopt o náhudagá tach o tága kant, mocch o ambára kant, bale nazánt ke kayá rasant. ");
INSERT INTO bccl_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“Bale nun oo Hodáwand! Man che chizzay wadárá án? Ométon tai sará ent. ");
INSERT INTO bccl_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Maná cha sajjahén náparmánián chotthén o ahmakáni kalági makan. ");
INSERT INTO bccl_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Bétawár án o dapá pacha nakanán, chiá ke é taw kortag. ");
INSERT INTO bccl_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Wati zarbatá cha mani sará dur kan, ke cha tai shahmátá tostag o kaptagán. ");
INSERT INTO bccl_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Taw pa hakkal ensáná cha gonáhá adaba dayay o áiay dósténán hamá paymá kanay ke raméz o waróka kant. Saddak án ke ensánay zend sáh o damé gésh naent. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","“Oo Hodáwand! Mani dwáyá beshkon o pa komaká mani peryátay némagá delgósh kan, arsánon mashamósh o bétawár mabay. Chiá ke tai gwará mehmánéay paymá án, darámadé, wati pet o pirénáni dhawlá. ");
INSERT INTO bccl_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Wati gazabá cha man dur kan, tán cha jahánay yalah kanagá pésar padá gal bebán.” ");
INSERT INTO bccl_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Gón sabré pa Hodáwandá wadáron kort, démi gón man tarrént o mani peryáti eshkot. ");
INSERT INTO bccl_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Maná cha johlánkén kalléá dar áworti, cha gel o gandápá, mani pádi taláréay sará óshtárént o gámi mohr kortant. ");
INSERT INTO bccl_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Nókén sawté mani dapá dáti, may Hodáay satá o sanáay shayr. Bázéné gendit o mannit o Hodáwanday sará tawkala kant. ");
INSERT INTO bccl_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Bahtáwar hamá ent ke Hodáwanday sará tawkala kant o démá gón porkebrénána nakant, gón hamáyán ke drógén hodáyáni randgiriá gomráh ant. ");
INSERT INTO bccl_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Oo Hodáwand, oo mani Hodá! Taw pa má bázén ajabén kár o shawré kortag, hechkas tai matth buta nakant. Agan belóthán tai káráni bárawá jár bejanán o habar bekanán, haminchok báz ant ke cha hesábá dar ant. ");
INSERT INTO bccl_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Tará pa hayrát o korbánigá hájaté nést, bale mani góshet pach kortag, sóchagi korbánig o gonáháni korbániget nalóthetag. ");
INSERT INTO bccl_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Gorhá gwashton: “Man átkag o tayár án, mani bárawá ketábay tumárá nebisag butag. ");
INSERT INTO bccl_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Oo mani Hodá! Armánon tai lóth o wáhagay sarjam kanag ent, tai Sharyat mani delá ent.” ");
INSERT INTO bccl_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Rakkénag o nejátay wasshén hálon mazanén diwáná jár jatag. Oo Hodáwand! Hamá dhawlá ke taw zánay man wati dap lagám najatag. ");
INSERT INTO bccl_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Tai rakkénókén madaton wati delá chér nadátag, tai wapádári o nejátbakshiay bárawá habaron kortag o cha mazanén diwáná tai mehr o wapáon napóshéntag. ");
INSERT INTO bccl_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Oo Hodáwand! Maná cha wati rahmatá zebahr makan, tai mehr o wapá tán abad maná émen bedárát. ");
INSERT INTO bccl_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Chiá ke béhesábén sakkián maná angerr kortag, mayárbárián maná geptag o dista nakanán, cha mani saray mudán gésh ant, mani del kaptag. ");
INSERT INTO bccl_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Oo Hodáwand! Mehrabáni kan o maná berakkén. Hodáwandá! Zutt pa mani madatá byá. ");
INSERT INTO bccl_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Á sajjahén ke mani kóshay randá ant o mani marká lóthant sarjahl o sharmsár bátant, á ke mani syahróchiay padá ant poshtá berawát o roswá bátant. ");
INSERT INTO bccl_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Á ke mani sará “hah, haha” kanant wati sarjahliá hayrán o habakkah bátant. ");
INSERT INTO bccl_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Bale á ke tai shóházá ant sajjahén tai bárgáhá shádehi kanát o gal o bál bátant, á ke tai rakkénókén madatesh dóst ent, modám begwashátant: “Hodáwand maz‌an ent.” ");
INSERT INTO bccl_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Man garib o hájatmand án, Hodáwandá mani hayál gwar bát. Taw mani komak o rakkénók ay. Oo mani Hodá! Dér makan. ");
INSERT INTO bccl_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Bahtáwar hamá ent ke garib o bazzagáni hayálá ent, Hodáwand áiá baláh o mosibatáni róchá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Hodáwand áiay negahpániá kant o zendaga dárit, á, molkay tahá bahtáwara bit. Taw áiá dozhmenáni wáhagáni sará yalaha nakanay. ");
INSERT INTO bccl_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Hodáwand áiá nádráhiay wahdá zór o wáka dant, cha nájórhi o kamzórián áiá dráha kant. ");
INSERT INTO bccl_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Man gwasht: “Oo Hodáwand! Mani sará rahm kan, maná dráh kan ke tai gonahkár án.” ");
INSERT INTO bccl_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Dozhmen pa badwáhi mani bárawá gwashant: “Kadéna merit o námi gára bit?” ");
INSERT INTO bccl_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Wahdé cha áyán yakké mani didárá kayt dozobáni habara kant o delá badia ródénit, dhanná ke dara kapit, wati delay habará kant. ");
INSERT INTO bccl_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Sajjahén dozhmen mani helápá halwat o soksoka kanant o pa mani táwán dayagá pandala sázant. ");
INSERT INTO bccl_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Gwashant: “Sellén nádráhiéá geptag, cha waptagén jáhá hechbar pád átka nakant.” ");
INSERT INTO bccl_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Tantaná mani nazzikén dóst ke cha áiá deljam atán, hamá ke gón man hamkásag at, áiá ham maná dróhetag. ");
INSERT INTO bccl_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Bale taw, oo Hodáwand! Mani sará rahm kan, maná pád kan tán wati jostánesh bekanán. ");
INSERT INTO bccl_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Cha eshiá zánán ke cha man washnód ay, ke dozhmen mani sará báládast nabutagant. ");
INSERT INTO bccl_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Cha mani tachki o rástiá, taw mani posht o panáh butagay o modám wati bárgáhá jágaha dayay. ");
INSERT INTO bccl_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Hodáwandá satá bát, Esráilay Hodáyá, cha azal tán abad. Anchosh bát. Ámin. ");
INSERT INTO bccl_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni shayri gwashtánk. Áskay paymá ke pa kawray ápán zahirwár ent, hamé paymá, oo mani Hodá, mani arwáh tai zahirán ent. ");
INSERT INTO bccl_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Mani arwáh pa Hodáyá tonnig ent, pa zend bakshókén Hodáyá, ke bárén kadi Hodáay bárgáhá rawán o áiay démá záhera bán? ");
INSERT INTO bccl_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Shap o róch warákon ars ent, Wahdé mardom modám maná gwashant: “Tai Hodá kojá ent?” ");
INSERT INTO bccl_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Wahdé wati delay dardán darshána kanán, hayálá kapán ke che paymá mazanén mocchiay hamráh atán, jashnay mazanén mocchiay o gón shádehiay kukkár o shogrgozáriay sawtán dém pa Hodáay lógá áyáni rahshón atán. ");
INSERT INTO bccl_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Oo mani arwáh! Chiá gimmortagay? Chiá mani del o daruná paréshán ay? Óst o omét Hodáay sará bekan, chiá ke nóksará hamáiá názénán, wati rakkénók o ");
INSERT INTO bccl_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","wati Hodáyá. Mani daruná arwáh gimmortag paméshká tará cha Ordonay sardhagár o Hermónay kóhá yáta kanán, cha Misáray kóhá. ");
INSERT INTO bccl_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Tai mazanén ápsháráni grandá, johlánki, johlánkiá gwánka jant, tai sajjahén chawl o mawj, mani sará proshtagant. ");
INSERT INTO bccl_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Róchá, Hodáwand wati mehrá déma dant o shapá sawt o zémeli gón man ent, dwáé dém pa wati zend bakshókén Hodáyá. ");
INSERT INTO bccl_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Gón Hodáyá ke mani talár ent gwashán: “Chiá maná shamoshtaget? Chiá cha dozhmenay ázárá mótk byárán?” ");
INSERT INTO bccl_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Dozhmenáni shegánán, mani haddh hurt kortagant, chiá ke sajjahén róchá maná gwashant: “Tai Hodá kojá ent?” ");
INSERT INTO bccl_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Oo mani arwáh! Chiá gimmortagay? Chiá mani del o daruná paréshán ay? Óst o omét Hodáay sará bekan, chiá ke nóksará hamáiá názénán, wati rakkénók o wati Hodáyá. ");
INSERT INTO bccl_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Oo Hodá! Gonáhay bohtámá cha mani sará bethagalén, Hodánábáwarén kawméay démá, pa mani hakká jáh bejan o maná cha badkár o prébkáráni dastá berakkén, ");
INSERT INTO bccl_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","chiá ke taw mani kalát ay. Taw parchá maná cha wat dur kortag? Chiá cha dozhmenay ázárá mótk byárán? ");
INSERT INTO bccl_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Wati rozhn o rástiá ráh day, tánke mani rahshón bebant o maná pákén kóhá o tai bárgáhá byárant. ");
INSERT INTO bccl_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Á wahdi Hodáay korbánjáhá rawán, dém pa Hodáyá ke mani wasshi o shádehi ent. Oo Hodá, mani Hodá! Tará gón changá názénán. ");
INSERT INTO bccl_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Oo mani arwáh! Chiá gimmortagay? Chiá mani del o daruná paréshán ay? Óst o omét Hodáay sará bekan, chiá ke nóksará hamáiá názénán, wati rakkénók o wati Hodá. ");
INSERT INTO bccl_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni shayri gwashtánk. Oo Hodá! Má wati góshán eshkotag, may pet o pirénán gwashtag ke áyáni zamánagá chónén káret kortag, gwastagén dawr o bárigán. ");
INSERT INTO bccl_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Taw gón wati dastá kawm dar kortant, bale may pet o pirén sabz kortant. Kawmet droshtant o may pet o pirén sháhegáni bakshátant. ");
INSERT INTO bccl_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Na áyáni zahmáni zór at ke molkesh gept na ke básk o bázuán sóbén kortant. É tai rástén dast at, tai básk o chehragay rozhn, chiá ke áyáni sará mehrabán atay. ");
INSERT INTO bccl_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Oo Hodá! Taw mani bádsháh ay. Pa Ákubá péróziay hokmá borr. ");
INSERT INTO bccl_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Cha tai némagá ent ke dozhmenán pada kenzénén, cha tai námá ent ke orosh barókán lagatmála kanén. ");
INSERT INTO bccl_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Man wati kamánay sará tawkala nakanán o zahm maná sóbéna nakant. ");
INSERT INTO bccl_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","É taw ay ke márá cha dozhmenán rakkéntag o badwáh sarjahl kortagant. ");
INSERT INTO bccl_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Oo Hodá! Má modám tai sará pahr kortag o tán abad tai námay shográ gerén. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Bale nun taw márá dawr dátag o béezzat kortag, may lashkaray hamráha nabay. ");
INSERT INTO bccl_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Márá dozhmenáni démá pada kenzénay o badwáh márá áwára janant. ");
INSERT INTO bccl_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Márá korbánigén pasáni paymá pa koshagá eshtaget o kawmáni nyámá sheng o sháng kortag. ");
INSERT INTO bccl_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Taw wati kawm arzáná bahá kortag o cha áyáni baháyá sutté nabortag. ");
INSERT INTO bccl_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Márá hamsáhegáni rishkandi kortag o kerr o gwaray mardománi kalági. ");
INSERT INTO bccl_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Taw márá kawmáni nyámá thekk o neshán kortag, darkawm sará chandhénant o maskará kanant. ");
INSERT INTO bccl_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Sajjahén róchá gón sarjahliá dém pa dém án o sharmá mani dém póshetag, ");
INSERT INTO bccl_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","cha bad o rad gwashókáni shegáná, cha dozhmen o bérgiray dastá. ");
INSERT INTO bccl_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","É sajjahén may sará átkagant, bale angat má tará nashamoshtag o gón tai ahdá nárást nabutagén. ");
INSERT INTO bccl_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","May del cha taw per natarretag o pád o gám cha tai ráhá dar nabutag. ");
INSERT INTO bccl_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Bale taw márá prósh dátag o gón wahshién haywánán yakjáh kortag, gón tahárterén tahárókiá póshéntag. ");
INSERT INTO bccl_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Agan má wati Hodáay nám beshamoshtén, yá dast pa bigánagén hodáéá borz kortén, ");
INSERT INTO bccl_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Hodáyá nazántagat? Chiá ke á cha delay ráz o asrárán sarpad ent. ");
INSERT INTO bccl_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Bale má tai sawabá sajjahén róchá gón marká dém pa dém én o korbánigén pasáni paymá hesáb áraga bén. ");
INSERT INTO bccl_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Oo Hodáwand! Ágáh bay. Pa ché wáb ay? Jáh jan o márá tán abad yalah makan. ");
INSERT INTO bccl_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Chiá wati démá chéra dayay o pa ché may bazzagi o lagatmáliá shamóshay? ");
INSERT INTO bccl_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Chiá ke má háká dém pa chér én o láp zeminá lacchetag. ");
INSERT INTO bccl_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Pád á o may madatá byá, wati mehray sawabá márá bemók o berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Pa sázger o washáwázáni sálárá. “Susanáni” tarzay sará. Kórahay chokkáni shayri gwashtánk. Eshki sawt. Delon cha zébáén gálán sarréch ent, shayré pa bádsháhá gwashán, zobán, zabardastén nebisókéay kalamay paymá ent. ");
INSERT INTO bccl_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Taw ádamiáni nyámá zébáterén ay o cha tai lonthán lál o gawhara gwárit, paméshká Hodáyá tará abadmánén barkaté dátag. ");
INSERT INTO bccl_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Oo tamardén bádsháh! Gón wati shán o shawkatá zahmá lánká band. ");
INSERT INTO bccl_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Gón hamá shawkatá péróziay aspá betáchén, pa rásti, békebri o ensápay dáragá, bell ke rástén dast tará bákamálén kár sój bedant. ");
INSERT INTO bccl_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Tai tir téz ant o bádsháhay dozhmenáni delá nendant, kawm tai pádáni chérá kapant. ");
INSERT INTO bccl_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Oo Hodá! Tai bádsháhi taht modámi o abadmán ent, tai bádsháhi asá, adl o ensápay asá ent. ");
INSERT INTO bccl_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Taw páki o rásti dóst dáshtag o cha badiá naprat kortag, paméshká Hodáyá, tai Hodáyá, tará géshter cha tai hamráhán shádehiay rógen per moshtag. ");
INSERT INTO bccl_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Sajjahén jámaget gón morr o aud o tójá moshtag o washbó butagant. Ájén kasráni tahá simmi sázáni zémel tará shádána kanant. ");
INSERT INTO bccl_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bádsháháni jenek tai gránázén mehmán ant, tai rástén némagá, malakah gón Opiray teláháni singárá óshtátag. ");
INSERT INTO bccl_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Oo jenek! Beshkon o sharriá delgósh kan, wati kawm o peti lógá shamósh, ");
INSERT INTO bccl_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","bell bádsháh tai zébáiay shaydá bebit, áiay démá pa adab bósht ke á tai wájah ent. ");
INSERT INTO bccl_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Suray shahray mardom gón wati thékiá kayt, shahray hastómandén mardom tai razá o washnódiay randá bant. ");
INSERT INTO bccl_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Sháhay jenek wati kasrá sakk zébdár ent, áiay póshák zargwáp ant. ");
INSERT INTO bccl_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Gón pordóchén jámagán bádsháhay kerrá baranti, neshtagén jenek, áiay dazgohár, áiay padá gón ant. ");
INSERT INTO bccl_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Pa shádehi dém dayaga bant o bádsháhi kalátá sara bant. ");
INSERT INTO bccl_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Tai pet o pirokáni jágahá, óbádageta nendant, áyán sajjahén molkay kamásh o mastera kanay. ");
INSERT INTO bccl_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Tai námay yátá nasláni nasl zendaga dárán, paméshká sajjahén kawm tará abad tán abada názénant. ");
INSERT INTO bccl_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. “Alámutay” tarzay sará. Sawté. Hodá may panáhgáh o zór o wák ent, madat kanóké ke sakkiáni wahdá tayár ent. ");
INSERT INTO bccl_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Paméshká natorsén, toré zemin bejombit o kóh daryáay delá bekapant. ");
INSERT INTO bccl_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Toré áiay áp grumbán o kap o gajj bebant o kóh cha áyáni grumbagá belarzant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Kawré hast ke jói Hodáay shahrá shádmána kanant, borzén arshay Hodáay pákén jágahá. ");
INSERT INTO bccl_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Hodá shahray nyámá ent o shahra nasorit, bámgwáhá Hodá madatia kant. ");
INSERT INTO bccl_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Kawm shóresha kanant o hokumat sarshakuna bant, á wati tawárá borza kant o zemin ápa bit. ");
INSERT INTO bccl_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Lashkaráni Hodáwand gón má gón ent, Ákubay Hodá may kalát ent. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Byáét Hodáay kárán bechárét, begendét ke áiá zeminá chónén béráni áwortag. ");
INSERT INTO bccl_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Zeminay chárén kondhán jangán halása kant, kamáná próshit, nayzahá hurt hurta kant o arrábahán ás mána dárit. ");
INSERT INTO bccl_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","“Watá bedárét o bezánét ke man, Hodá án, kawmáni sará hokmrán o jaháná hákem.” ");
INSERT INTO bccl_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Lashkaráni Hodáwand gón má gón ent, Ákubay Hodá may kalát ent. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. Oo sajjahén kawmán! Cháp bejanét. Gón shádmániay borzén sawtán dém pa Hodáyá kukkár kanét. ");
INSERT INTO bccl_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Chiá ke borzén arshay Hodáwand bákamál ent, sajjahén jahánay mazanén bádsháh. ");
INSERT INTO bccl_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Kawmán may chérdasta kant, ráján may pádáni chérá. ");
INSERT INTO bccl_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","May mirásá pa má gechéna kant, wati dóstén Ákubay pahrá. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Hodá shádmániay kukkáráni nyámá borzád shotag, Hodáwand sornáay tawáray nyámá. ");
INSERT INTO bccl_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Gón wati názénkán Hodáyá satá kanét, názénk janét, benázénét, may bádsháhá benázénét. ");
INSERT INTO bccl_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Chiá ke Hodá sajjahén jahánay bádsháh ent, áiá gón shayré benázénét. ");
INSERT INTO bccl_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Hodá kawmáni sará bádsháhia kant, á wati pákén tahtá neshtag. ");
INSERT INTO bccl_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Kawmáni sarók o master mocch butagant, gón Ebráhémay Hodáay kawmá yakjáh, chiá ke jahánay sajjahén sardár, Hodáayg ant, á béhesáb maz‌anshán ent. ");
INSERT INTO bccl_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kórahay chokkáni Zabur. Hodáwand mazan o satáay báz láhek ent, may Hodáay shahray tahá. Áiay pákén kóh, ");
INSERT INTO bccl_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Sahyunay kóh, zébá gón wati borziá, sajjahén jahánay shádehi, shomálay borzterén bolandi, mazanshánén bádsháhay shahr ent. ");
INSERT INTO bccl_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Hodá áiay borján ent, watá mohrén kaláté pajjáréntagi. ");
INSERT INTO bccl_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Bádsháh yakjáh butant o hóriá démá shotant, ");
INSERT INTO bccl_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","bale anchosh ke shahresh dist, hayrán o habakkah mantant o torsáná jestant. ");
INSERT INTO bccl_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Larzagesh delá kapt, dardé trondén chó ke janénéay chellag o zanká. ");
INSERT INTO bccl_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Taw gón ródarátki gwátá Tarshishay bandenay bójig próshtant. ");
INSERT INTO bccl_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Hamá dábá ke eshkotag nun gón wati chammána gendén, lashkaráni Hodáwanday shahray tahá, may Hodáay shahrá ke Hodá tán abad pádária kant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Oo Hodáwand! Tai parasteshgáhay tahá may johlánkén pegr o hayál gón tai mehrá ent. ");
INSERT INTO bccl_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Oo Hodá! Tai námay paymá, tai satá zeminay chárén kondhán sara bit. tai rástén dast adl o rástiá porr ent. ");
INSERT INTO bccl_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Cha tai dadrasiá Yahudáay métag shádmán bátant o Sahyunay kóh shádán. ");
INSERT INTO bccl_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Sahyuná zyárat kanét, áiay chágerdá begardét o borján hesáb kanét, ");
INSERT INTO bccl_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","áiay mohrén diwáláni némagá sharriá hayál gwar dayét o sajjahén kalátáni bechárét, tánke gón nókén naslá begwashét ");
INSERT INTO bccl_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","ke Hodá hamesh ent, may Hodá, abad tán abad, hamá ent ke tán marká may rahshóna bit. ");
INSERT INTO bccl_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Pa sázger o washáwázáni sálárá, Kórahay chokkáni Zabur. Oo sajjahén kawmán! Beshkonét. Oo jahánay drostigén jahmenendán! Delgósh kanét. ");
INSERT INTO bccl_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Borz o jahlén mardom doén, azgár o nézgár, shomá sajjahén. ");
INSERT INTO bccl_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Mani dap, hekmat bayána kant, delay johlánkén pegr, pahm o zánta bakshit. ");
INSERT INTO bccl_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Góshá dém pa nemunah o batalé tarrénán, wati delay cháchay granchá gón changay sázá pacha kanán. ");
INSERT INTO bccl_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Baláh o sakkiáni róchán chiá betorsán, á wahdá ke rad dayókáni badi maná angerra kant? ");
INSERT INTO bccl_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Áyáni tawkal pa wati zarr o málá ent o wati mazanén hastiay sará pahra kanant. ");
INSERT INTO bccl_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Saddak án ke hechkas wati brátay zendá móketa nakant o áiay hónbaháyá Hodáyá dáta nakant. ");
INSERT INTO bccl_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Chiá ke zenday mókag sakk grán ent o hech kimmaté áiá porr korta nakant ");
INSERT INTO bccl_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","tánke ensán namirán bemánit o hechbar kabrá magendit. ");
INSERT INTO bccl_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Chiá ke gendagá én, dáná ham merant o nádán o bésodd ham haláka bant o wati mál o hastiá pa degarána kellant. ");
INSERT INTO bccl_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Kabr áyáni abadmánén lóga bit, nasláni nasl, áyáni menendjáh, harchont ke kallagáná wati námesh per kort. ");
INSERT INTO bccl_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Ádami wati arzesh o hastómandiá namánit, chárpádáni paymá ent ke bérána bant. ");
INSERT INTO bccl_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Esh ent jáheláni ásar, hamáyáni ákebat ke wati habaráni mannók ant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Pasáni paymá dém pa mordagáni jaháná ráh dayaga bant, hamódá ke mark áyáni shopánka bit. Bámgwáhán, nékdel áyáni sará hokmránia kanant o áyáni jesm o ján kabrá pussit, dur cha borzén márhián. ");
INSERT INTO bccl_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Bale Hodáwand mani arwáhá cha mordagáni jaháná mókit o maná wati dastá zurit. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Wahdé shomá gendét kasé hastómanda bit o lógay shawkati gésha bit, matorsét. ");
INSERT INTO bccl_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Chiá ke markay wahdá chizzé gón wata nabárt o shawkati gón áiá kabrá narawt. ");
INSERT INTO bccl_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Tán hastómand ent mardom áiá satá dayant. Harchont ke zendá watá bahtáwar zántagi, ");
INSERT INTO bccl_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","bale wati pet o pirénáni hamráha bit, ke zenday rozhná hechbara nagendant. ");
INSERT INTO bccl_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Ádami wati arzesh o hastómandiay tahá nádán ent, chárpádáni paymá ent ke bérána bant. ");
INSERT INTO bccl_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asápay Zabur. Hamá porwák, Hodáwandén Hodá habara kant o zeminá gwánka jant, cha ródarátká tán rónendá. ");
INSERT INTO bccl_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Hodá cha Sahyuná ke zébáiay kamál ent, wati nurá drapshána kant. ");
INSERT INTO bccl_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","May Hodá kayt o bétawára nabit, ér barókén ásé démá enti o trondén gwát o lurhé chágerdá. ");
INSERT INTO bccl_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Borzén ásmánán ham gwánka jant o zeminá ham, tánke wati mardománi dadrasiá bekant. ");
INSERT INTO bccl_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Hodádóstán mani gwará yakjáh kanét, hamá ke gón korbánig kanagá, gón man ahdesh bastag.” ");
INSERT INTO bccl_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Ásmán áiay adl o rástiá jára janant, chiá ke Hodá wat dádras ent. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Oo mani mardomán! Beshkonét ke habara kanán. Oo Esráil! Tai helápá gwáhia dayán. Man Hodá án, shomay Hodá. ");
INSERT INTO bccl_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Pa korbánigi naent ke tará hakkala dayán, tai sóchagi korbánig modám mani chammáni démá ant. ");
INSERT INTO bccl_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Na cha tai lógá gwaské zurán o na pasé cha tai gwáshá. ");
INSERT INTO bccl_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Chiá ke jangalay sajjahén haywán manig ant, hazárán kóháni dalwat. ");
INSERT INTO bccl_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Kóhestagáni sajjahén báli morgán jáha kárán o har ché ke zeminá gardit manig ent. ");
INSERT INTO bccl_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Agan shodig atán tará sahigon nakortagat, chiá ke jahán o harché áiá hast, manig ant. ");
INSERT INTO bccl_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Gókáni góshtá warán? Pasáni hóná nóshán? ");
INSERT INTO bccl_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Wati shogrgozáriay korbánigá Hodáyá pésh kan o wati kawlá gón borzén arshay Hodáyá purah kan. ");
INSERT INTO bccl_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Sakki o sóriáni róchá maná belóth, man tará nejáta dayán o taw maná shán o shawkata dayay.” ");
INSERT INTO bccl_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Bale Hodá gón badkárá chosha gwashit: “Tará che hakk ent ke mani Sharyatay rahbandáni habará bekanay yá mani ahd o paymánay bárawá chizzé begwashay? ");
INSERT INTO bccl_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Chiá ke cha adab o tálimá bézár ay o mani habará poshtá dawra dayay. ");
INSERT INTO bccl_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Dozzé ke genday, démet róshena bit o gón zenákárán hamráha bay. ");
INSERT INTO bccl_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Dapay lagámá pa badiá yalaha kanay o zobáná pa prébá. ");
INSERT INTO bccl_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Modám wati brátay helápá habara kanay, wati mátay chokkay sará bohtáma janay. ");
INSERT INTO bccl_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Taw é kár kortagant o man hecch nagwasht, hayálet kort ke man tai payméné án. Bale nun tará malámata kanán o tai mayár o gonáhán tai chammáni démá éra kanán. ");
INSERT INTO bccl_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","“Oo Hodá shamoshtagénán! É habará neshán kanét, agan na, shomárá chondh chondha kanán o kas shomárá rakkénta nakant. ");
INSERT INTO bccl_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Á kas ke shogrgozáriay korbánigá pésha kant hamá maná shán o shawkata dant, pa wat ráhé tayára kant o man áiá hamá nejátá pésha dárán ke cha mani némagá ent.” ");
INSERT INTO bccl_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Pa sázger o washáwázáni sálárá, Dáuday Zabur, wahdé Nátán Nabi, cha Dáud o Batshebahay wapt o wábá rand, áiay kerrá átk. Oo Hodá! Pa wati mehrá bechár o mani sará rahm kan! Cha wati békesásén rahmatán náparmániánon gár kan. ");
INSERT INTO bccl_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Pa sarjami maná cha mayárbárián beshód o cha gonáhánon pák kan! ");
INSERT INTO bccl_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Chiá ke wati náparmániána zánán o mani gonáh modám chammáni démá ent. ");
INSERT INTO bccl_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Man tai helápá, tahná tai helápá gonáh kortag o hamá káron kortag ke tai chammá bad ent. Paméshká, taw ke habara kanay barhakk ay o dádrasiay wahdá béayb ay. ");
INSERT INTO bccl_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Pa rásti man mayárbár pédá butagán o cha hamá wahdá ke mátay lápá kaptán, gonahkár. ");
INSERT INTO bccl_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Nun deljam án ke taw cha mani del o jabiná rástiay lóthók ay o chér o panáhén daruná maná hekmata bakshay. ");
INSERT INTO bccl_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Gón zupáay lambán pákon kan ke pákizaga bán, maná beshód ke cha barpá espéttera bán. ");
INSERT INTO bccl_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Bell ke shádehi o shádmániá beshkonán, bell á haddh ke taw droshtagant gal o bál bebant. ");
INSERT INTO bccl_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Cha mani gonáhán sar gwaz o sajjahén mayárbáriánon gár kan. ");
INSERT INTO bccl_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Oo Hodá! Mani daruná pákén delé bejórhén o mani del o jabiná padá mohrén ruhé byár. ");
INSERT INTO bccl_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Maná cha wati bárgáhá dur maperrén o wati Pákén Ruhá cha man pach mager. ");
INSERT INTO bccl_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Wati dátagén rakkénagay shádehiá padá beday o maná morádigén ruhé bebaksh. ");
INSERT INTO bccl_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Gorhá sarkashén mardomán tai ráhán tálima dayán o gonahkár tai kerrá wátarra kanant. ");
INSERT INTO bccl_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Oo Hodá! Oo mani rakkénókén Hodá! Maná cha hón o kóshay gonáhá berakkén o zobánon tai adl o rástiá názénit. ");
INSERT INTO bccl_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Hodáwandá! Mani lonthán pach kan, tánke mani dap tará satá bekant. ");
INSERT INTO bccl_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tará pa korbánigá wáhagé nést, agan na, mana áwort, sóchagi korbánig tará washnóda nakant. ");
INSERT INTO bccl_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Hodáay delpasondén korbánig, proshtagén arwáh ent. Oo Hodá! Proshtag o tawbahkárén deléa taw jahla najanay. ");
INSERT INTO bccl_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Pa wati washnódiá bechár o gón Sahyuná mehrabán bay, Urshalimay diwálán padá addh kan. ");
INSERT INTO bccl_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Gorhá cha rást o ádelén korbánigán shádána bay, cha sóchagi korbánigá ke sarjamá sóchaga bit, tai korbánjáhá gwask pésh kanaga bant. ");
INSERT INTO bccl_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Pa sázger o washáwázáni sálárá, Dáuday shayri gwashtánk, á wahdá ke Edumi Duig, Sháulay kerrá shot o á sahig korti ke “Dáud, Ahimelekay lógá shotag.” Oo porzórén mard! Chiá badiay sará pahra kanay? Hodáay mehr dáemi ent. ");
INSERT INTO bccl_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Oo prébkár! Tai zobán, tabáhi o barbádiay pandalána sázit, almásén tégéay paymá. ");
INSERT INTO bccl_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Tará badi cha nékiá dóster ent o dróg cha rástiá. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Oo prébkárén zobán! Har bérán kanókén habará dósta dáray. ");
INSERT INTO bccl_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Bale Hodá tará abadia próshit. Tará chakápit o cha tai gedáná gwajit o cha zendagénáni zeminá tai risshagá kasshit. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Pahrézkára gendit o torsit, badkáray sará kandit o gwashit: ");
INSERT INTO bccl_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Haw! Esh ent á kas ke Hodái wati kalát nakort. Tawkali wati bázén mál o dawlatay sará bast o wati barbád kanagá twáná but.” ");
INSERT INTO bccl_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Bale man zaytunay sabzén drachkéay paymá án, ke Hodáay lógá sabza bit. Mani tawkal Hodáay mehray sará ent abad tán abad. ");
INSERT INTO bccl_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Pa tai kortagén kárán modám tai shográ gerán o Hodádóstáni démá pa tai námá ométwár án, chiá ke tai nám nék ent. ");
INSERT INTO bccl_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Pa sázger o washáwázáni sálárá. “Mahallátay” tarzay sará. Dáuday shayri gwashtánk. Nádán wati delá gwashit: “Hodáé nést.” É palit ant o káresh bazhnák, nékkáré nést. ");
INSERT INTO bccl_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Hodá cha ásmáná bani ádamá chárit tán begendit bárén dánáé hast ke Hodáay shóházá ent. ");
INSERT INTO bccl_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Sajjahénán Hodáay ráh gár dátag, hórigá palit butagant, nékkáré nést, yakké ham nést. ");
INSERT INTO bccl_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Badkár hech sarpada nabant? É mani kawmá anchosha warant ke mardom nagana warant o Hodáyá hech tawára nakanant. ");
INSERT INTO bccl_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Ódá ke hech torsé nést é sakka torsant, chiá ke Hodá shomay angerr kanókáni haddhán sheng o shánga kant, taw eshán sharmendaga kanay, chiá ke Hodáyá á cha wat dawr dátagant. ");
INSERT INTO bccl_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Kasé cha Sahyuná byáyát o Esráilá berakkénát. Wahdé Hodá washbahtiá pa wati kawmá pera tarrénit, Ákub gal o bála bit o Esráil shádehia kant. ");
INSERT INTO bccl_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Pa sázger o washáwázáni sálárá. Gón simmi sázán. Dáuday shayri gwashtánk, hamá wahdá ke Zépay mardom Sháulay kerrá shot o gwashtesh: “Bárén, Dáud watá may nyámá chér dayagá naent?” Oo Hodá! Gón wati námá maná berakkén. gón wati zórá gonáhay bohtámá cha mani sará bethagalén. ");
INSERT INTO bccl_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Hodáyá! Mani dwáyá gósh kan o dapay habarán beshkon. ");
INSERT INTO bccl_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Chiá ke bigánag, mani démá pa dozhmeni pád átkagant o setamger mani kóshay padá ant, hamá ke Hodáyá wati chammáni démá nayárant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Bale haw! Hodá mani komak kanók ent, Hodáwand mani zenday dárók ent. ");
INSERT INTO bccl_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Mani dozhmenáni badi áyáni jenday chakká kapát, wati wapádáriay sawabá, áyán gár kan. ");
INSERT INTO bccl_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Oo Hodáwand! Wati delkasshén korbánigán tará pésha kanán o tai námay shográ gerán, chiá ke nék ent. ");
INSERT INTO bccl_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Parchá ke taw maná cha har sakki o sóriá rakkéntag, mani chamm dozhmenay prósh waragay sháhed butagant. ");
INSERT INTO bccl_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Pa sázger o washáwázáni sálárá. Gón simmi sázán. Dáuday shayri gwashtánk. Oo Hodá! Mani dwáyá beshkon o watá cha mani zári o peryátán chér maday. ");
INSERT INTO bccl_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Mani némagá delgósh kan o passaw day, wati nálag o zangán paréshán án. ");
INSERT INTO bccl_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Cha dozhmenáni tawár o cha badkáráni kukkárán bétágat o hayrán án. Chiá ke náhakká maná ranjénant o gón hezhmé mani dozhmeniá kanant. ");
INSERT INTO bccl_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Del mán sénagá azáb ent o markay torson sará kaptag o ");
INSERT INTO bccl_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","bimm o dehshatá maná chér tarréntag. ");
INSERT INTO bccl_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Gwashán: “Dréchá kapóti bálon per butén, tánke bálon bekortén o árám begepténán, ");
INSERT INTO bccl_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Haw! Dém pa durén jágahána shotán o dasht o gyábánon wati hankéna kort. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Pa eshtápia shotán o jáhé chéra bután, cha lurh o tuppánán dur.” ");
INSERT INTO bccl_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Hodáwandá! Áyáni zobáná anchosh betarrén ke yakdomiá sarpad mabant, chiá ke shahrá jang o chópa gendán. ");
INSERT INTO bccl_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Róch o shap shahray chágerdá diwáláni sará tarragá ant o shahr cha náensápi o petnahá porr ent, ");
INSERT INTO bccl_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","cha harábi o bérániá sarréch ent o setam o repk, cha áiay bázárá dura nabit. ");
INSERT INTO bccl_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","É dozhmené naent ke maná shegána jant, agan na, mana sagget, badwáh naent ke gón pahré mani démá óshtátag, agan na, cha áiá chéra bután. ");
INSERT INTO bccl_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ji, taw ay mani matth, mani bráhondag o nazzikén dóst, ");
INSERT INTO bccl_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","ke márá wasshén hamráhié hastat hamá wahdá ke gón mazanén mocchié Hodáay lógá gámena jat. ");
INSERT INTO bccl_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Mark áyáni chakká bekapát o zendahgórr bátant, chiá ke badi áyáni lóg o deláni tahá ent. ");
INSERT INTO bccl_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Bale man Hodáyá gwánka janán o Hodáwand maná rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Bégáh o sabáh o némróchá zanga janán o peryáta kanán o á mani tawárá eshkont. ");
INSERT INTO bccl_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Mani jesm o jáná cha hamá jangá ke démá dar átkag pa dráhi o salámatia rakkénit, bell toré bázéné mani démá óshtátag. ");
INSERT INTO bccl_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Hodá ke cha azal wati bádsháhi tahtay sará neshtag, eshkont o sharmendagesha kant. Ósht... Chiá ke badala nabant o Hodátorsiesh nést. ");
INSERT INTO bccl_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Mani bráhondagá wati dast dóstáni helápá shahárt o wati kawli prósht. ");
INSERT INTO bccl_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Zobáni chó thélá charp at bale deli jangig, dapay habari cha rógená narmter, bale kasshetagén zahm atant. ");
INSERT INTO bccl_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Wati paréshánián pa Hodáyá bell, ke á tai dárók ent, á hechbar pahrézkárán kapagá naylit. ");
INSERT INTO bccl_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Bale taw, oo Hodá, badkárán johlterén kallá dawra dayay, hónwár o prébkárén mardom wati rócháni némá ham zendaga namánant, bale man tai sará tawkala kanán. ");
INSERT INTO bccl_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Pa sázger o washáwázáni sálárá. “Bétawár o durdastén kapótay” tarzay sará. Dáuday shayr, hamá wahdá ke Pilistián Dáud Gatay shahrá dazgir kort. Oo Hodá! Mani sará rahm kan, ke dozhmen sakk mani randá ant, sajjahén róchá, mani sará orosha kanant. ");
INSERT INTO bccl_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Sajjahén róchá, dozhmen maná lagatmála kanant, chiá ke bázéné pa kebr mani sará orosha kant. ");
INSERT INTO bccl_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Wahdé maná torsit tai sará tawkala kanán. ");
INSERT INTO bccl_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Hodáay sará, ke áiay habará satá kanán, Hodáay sará tawkala kanán o natorsán, hákién ensán maná ché korta kant? ");
INSERT INTO bccl_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Sajjahén róchá, mani habarán tába dayant o sajjahén honaresh pa mani ázár dayagá ent. ");
INSERT INTO bccl_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Pandala sázant o kamina kanant, mani gámána chárant o mani koshagay randá ant. ");
INSERT INTO bccl_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Gón é sajjahén badián rakketa kanant? Oo Hodá! Wati hezhmay tahá kawmán sarshakun kan. ");
INSERT INTO bccl_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Taw mani darpadariay hesábána dáray, mani arsán wati arsdáná bekan, é tai ketáb o daptarán nebeshtah naant? ");
INSERT INTO bccl_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Gorhá á wahdá ke tará gwánka janán dozhmen pada kenzant. Eshiá zánán ke Hodá gón man ent. ");
INSERT INTO bccl_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Hamá Hodá ke áiay habará satá kanán, haw, hamá Hodáwand ke áiay habará satá kanán, ");
INSERT INTO bccl_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Hamá Hodáay sará tawkala kanán o natorsán. Ensán maná ché korta kant? ");
INSERT INTO bccl_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Oo Hodá! Báyad ent gón taw wati kortagén kawlán purah bekanán, pa taw shogrgozáriay korbánigán pésha kanán. ");
INSERT INTO bccl_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Chiá ke taw, oo Hodá, maná cha marká rakkénay o mani pádán cha lakoshagá dáray, ke zenday rozhná tai bárgáhá gám bejanán. ");
INSERT INTO bccl_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Dáuday shayr, hamá wahdá ke Dáud cha Sháulá tatk o gáréá chér but. Mani sará rahm kan. Oo Hodá! Mani sará rahm kan, chiá ke mani arwáh tai mayár o báhóth ent. Tai bánzoláni sáhegá panáha zurán, tán hamá wahdá ke é baláh berawt o begwazit. ");
INSERT INTO bccl_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Borzén arshay Hodáay gwará peryáta kanán, hamá Hodá ke gonáhay bohtámá cha mana thagalénit. ");
INSERT INTO bccl_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Cha ásmáná wati komaká ráha dant, maná rakkénit o áyán ke maná lapáshant, pa hakkal adaba kant. Ósht... Hodá wati mehr o wapádáriá rawána kant. ");
INSERT INTO bccl_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Mani arwáh shéráni nyámá ent, ás bon dayókáni nyámá wapsán, hamá mardománi nyámá ke dantánesh tir o nayzah ant o zobánesh tézén zahm. ");
INSERT INTO bccl_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Oo Hodá! Ásmánáni sará bátay, tai shawkat sajjahén zeminá sheng bát. ");
INSERT INTO bccl_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Mani pádáni démá dámesh chér kort o arwáhon sarshakun but. Ráhay sará chátesh kótk, bale wat ódá shakun butant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Oo Hodá! Mani del mohr ent. Mani del mohr ent o sawt o sáza janán. ");
INSERT INTO bccl_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Oo mani arwáh! Ágáh bay. Oo chang o soródán! Ágáh bét. Man bámgwáhá cha wábá páda kanán. ");
INSERT INTO bccl_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Oo Hodáwand! Tará kawmáni nyámá satá kanán o pa taigi kabilaháni nyámá sawta janán. ");
INSERT INTO bccl_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Chiá ke tai mehr báz ent, tán arshá rasit o tai wapádári tán jambarán. ");
INSERT INTO bccl_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Oo Hodá! Ásmánáni sará bátay, tai shawkat sajjahén zeminá sheng bát. ");
INSERT INTO bccl_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Dáuday shayr. Oo hákemán! Shomay bétawári náensápi naent? Mardománi nyámá pa ensáp dádrasia kanét? ");
INSERT INTO bccl_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Enna, wati delá béadlia sázét o shomay dast zeminá petnah páda kanant. ");
INSERT INTO bccl_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Badkárán cha mátay lápá wati ráh gár dátag o cha pédáeshá gomráh o drógband ant. ");
INSERT INTO bccl_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Áyán zahré mán ent chosh ke máray zahrá, syahmáréay dhawlá ant ke góshi bastagant o ");
INSERT INTO bccl_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","hech paymá wati démá pa márgeráni áwázá natarrénit, harchont ke ezm o honara kanant. ");
INSERT INTO bccl_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Oo Hodá! Esháni dantánán mán dapá prósh. Hodáwandá! É warnáén shéráni néshén dantánán cha boná dar kan. ");
INSERT INTO bccl_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Tachókén ápáni paymá gár bátant, wahdé kamána kasshant tiresh konth bátant o pad o nesháné maylátant, ");
INSERT INTO bccl_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","halazunay paymá ke gón rawagá ápa bit o eshkand butagén chokkay paymá ke hechbar róchay rozhná nagendit. ");
INSERT INTO bccl_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Cha eshiá pésar ke shomay déz konthagáni ásá bemárant, tarr bebant yá hoshk, Hodáesh gár o gomsár kanát. ");
INSERT INTO bccl_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Pahrézkár, bérá ke gendit, shádehia kant, wati pádán mán badkáráni hóná shódit. ");
INSERT INTO bccl_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Mardoma gwashant: “Albat ke pa pahrézkárá mozzé hast, Hodáé hast ke zeminay sará dádrasia kant.” ");
INSERT INTO bccl_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Dáuday shayr, hamá wahdá ke Sháulá pa Dáuday kóshá, lahtén chárug áiay lógá rawán dát. Oo mani Hodá! Maná cha dozhmenán berakkén o cha áyán ke mani helápá jáha janant, mani negahpániá bekan. ");
INSERT INTO bccl_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Maná cha badkárán berakkén o cha hónigán neját beday. ");
INSERT INTO bccl_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Bechár ke che paymá pa mani kóshá kaminesh kortag. Oo Hodáwand! Zórákén mard mani helápá yakjáh butagant, maná hech gonáh o mayáré ham nést. ");
INSERT INTO bccl_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Man hech gonáh o mayáré nakortag, bale é angat mani sará orosh kanagá tayár ant. Pa mani komaká pád á o mani hálá bechár. ");
INSERT INTO bccl_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Oo Hodáwand, oo lashkaráni Hodá! Taw Esráilay Hodá ay, ágáh bay, sajjahén kawmán sezá beday o badkárén dróhókáni sará rahm makan. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Shapá pera tarrant, kochekáni paymá gorrant o shahray chágerdá gardant. ");
INSERT INTO bccl_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Bechár ke cha dapá ché dara kanant, zahmesh dapá ent, gwashant: “Kass eshkonagá naent.” ");
INSERT INTO bccl_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Bale taw, oo Hodáwand, áyáni sará kanday, sajjahén kawmáni sará rishkanda kanay. ");
INSERT INTO bccl_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Oo mani wák o zór! Tai rahchár án, chiá ke taw mani kalát ay, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Hodá pa man mehrabán ent o mani komaká kayt, dozhmenáni sará wati péróziá gendán. ");
INSERT INTO bccl_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Oo Hodáwand ke may espar ay! Áyán makosh, chosh mabit ke mani kawm beshamóshit. Gón wati zórákiá eshán sargardán kan o ér byár. ");
INSERT INTO bccl_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Pa wati dapay gonáh o lontháni habarán wati kebray tahá bandig bebant. Esháni nálat o drógbandiay sawabá, ");
INSERT INTO bccl_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","eshán wati hezhmay tahá gár o gomsár kan, gár o gomsár kan ke hech pasht makapant, tán zánag bebit ke cha Ákubá beger tán zeminay har kondhá Hodá bádsháhia kant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Shapá pera tarrant, kochekáni paymá gorrant o shahray chágerdá gardant. ");
INSERT INTO bccl_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Warákay shóházá sar sar janána bant o agan sér mabant wába nakapant. ");
INSERT INTO bccl_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Bale man tai kodratay tawsipá sawt o sáza janán, sohbá tai mehray satáyá sawta janán o shádehia kanán, chiá ke taw mani borzén kalát ay o sakkiáni wahdá mani panáhgáh. ");
INSERT INTO bccl_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Oo mani wák o twán! Tará názénán. Hodá mani borzén kalát ent, mani Hodá ke gón man mehra kant. ");
INSERT INTO bccl_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Pa sázger o washáwázáni sálárá. “Susanay” tarzay sará. Gwáhié. Pa tálimá Dáuday shayr, hamá wahdá ke Dáudá gón Naharaymay Árámián o Sóbahay Árámián jang kort o hamá wahdá ke Yuáb per tarret o Wáday dashtá cha Edumián dwázdah hazár mardomi kosht. Oo Hodá! Taw márá yalah kortag o may sangar próshtagant, hezhmnák butagay, bale nun gón má wasshán bay. ");
INSERT INTO bccl_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Zeminet jombéntag o tal dátag, taláni beger ke larzagá ent. ");
INSERT INTO bccl_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Wati kawmet gránén jáwarán perréntag, márá madhósh kanókén sharábet wáréntag. ");
INSERT INTO bccl_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Bale angat bayraket pa Hodátorsán borzád kortag tánke yakjáh bebant o cha dozhmenay kamáná berakkant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Gón wati rástén dastá berakkén o passaw beday tán hamá ke tará dóst ant berakkant. ");
INSERT INTO bccl_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Hodáyá cha wati pákiá habar kort: “Shekémá gón shádehi bahra kanán o Sukkótay daragá kesása kanán. ");
INSERT INTO bccl_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Galyád manig ent o Manassi mani, Epráim mani jangi koláh ent, Yahudá bádsháhiay asá o ");
INSERT INTO bccl_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Muáb mani dasshódi trasht, Edumay sará wati swásá chagala dayán o Pilistiahay sará wati péróziay gwánká janán.” ");
INSERT INTO bccl_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Kay maná choshén shahréá kárit ke sangarband ent? Kay maná dém pa Edumá rahshóna bit? ");
INSERT INTO bccl_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Oo Hodá! Taw márá yalah dátag. Oo Hodá! Padá may lashkaráni hamráha nabay. ");
INSERT INTO bccl_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Dozhmenáni démá márá madat kan, chiá ke ensánay madat békár o náhudag ent. ");
INSERT INTO bccl_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Gón Hodáyá sóbéna bén, hamá ent ke may dozhmenán pádmála kant. ");
INSERT INTO bccl_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Pa sázger o washáwázáni sálárá. Gón simi sázán. Dáuday Zabur. Oo Hodá! Mani peryátá beshkon o mani dwáyá gósh dár. ");
INSERT INTO bccl_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Tará cha zeminay godhsará gwánka janán, wahdé delona drahit. Maná dém pa taláréá bar ke cha man borzter ent. ");
INSERT INTO bccl_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Chiá ke taw mani panáhgáh butagay o dozhmenáni démá mohrén borjé. ");
INSERT INTO bccl_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Bell ke tai tambuá tán abad bemánán o tai bánzoláni sáhegá panáh bezurán. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Chiá ke taw, oo Hodá, mani dátagén kawl eshkotagant o wati námay torsetagénáni miráset maná bakshátag. ");
INSERT INTO bccl_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Bádsháhay omray róchán báz kan o áiay sálán, tán sajjahén naslán. ");
INSERT INTO bccl_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Hodáay bárgáhá tán abad sháhi tahtá benendát, wati mehr o wapádáriá áiay negahpán kan. ");
INSERT INTO bccl_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Nun tai námá modám názénán o wati kawlán har róch puraha kanán. ");
INSERT INTO bccl_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Pa sázger o washáwázáni sálárá. “Yedutunay” tarzay sará. Dáuday Zabur. Mani arwáh pa émeni tahná Hodáay rahchár ent, chiá ke mani rakkénag cha hamáiay némagá ent. ");
INSERT INTO bccl_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Mani talár o mani rakkénók tahná hamá ent, mani kalát ent, hechbara nalarzán. ");
INSERT INTO bccl_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Tán kadén mardéay sará orosha kanét tánke sarjamiá bekoshéti, chosh ke proshtagén diwál o kaptagén shank o pallé? ");
INSERT INTO bccl_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Albat pandala sázant ke áiá cha borzád sarshakun bekanant. Cha dróg bandagá lezzata barant, gón wati dapá barkata dayant, bale delay tahá nálata kanant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Oo mani arwáh! Pa émeni tahná Hodáay rahchár bay, chiá ke mani omét gón hamáiá ent. ");
INSERT INTO bccl_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Mani talár o mani rakkénók tahná hamá ent, mani kalát ent, mana nalarzán. ");
INSERT INTO bccl_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Mani neját o ezzat gón Hodáyá ent, hamá mani mohrén talár ent, mani panáhgáh ent. ");
INSERT INTO bccl_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Oo mardomán! Hodáay sará tawkal kanét o delay hálán hamáiay démá darshán kanét, Hodá may panáhgáh ent. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Pa rásti ke ensán cha daméá géshter naent, bani ádam prébé, agan sháhémá tóresh bekanant hech naant. É sajjahén, yakjáh cha damé géshter naant. ");
INSERT INTO bccl_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Pa zolm o zórá tawkal makanét o pa dozziá omét mabandét, harchont ke shomay mál géshtera bit, pa áiá del mabandét. ");
INSERT INTO bccl_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Hodáyá yak habaré gwashtag o man do eshkotag, ke zór o kodrat Hodáayg ent o ");
INSERT INTO bccl_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","mehr o rahm ham taig ent, oo Hodáwand! Taw harkasá áiay kortagén káráni hesábá, mozza dayay. ");
INSERT INTO bccl_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dáuday Zabur, hamá wahdá ke Yahudáay gyábáná at. Oo Hodá! Mani Hodá taw ay, gón wati sajjahén del o jáná tai shóházá án, arwáhon tai tonnig ent o jesm o jánon tai hodónák, béáp o hoshkén zeminéá. ");
INSERT INTO bccl_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Tai pákén jágahá, maná tai shobén butag, tai shán o kodraton distag, ");
INSERT INTO bccl_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","chiá ke tai mehr cha zendá sharter ent, mani lonth tará názénant. ");
INSERT INTO bccl_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Tán zendag án tará názénán o pa tai námá dastán borza kanán. ");
INSERT INTO bccl_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Arwáhon anchosh séra bit chó ke yakké wasshén waráké bwárt o dapon gón shádmánén lonthán tará názénit. ");
INSERT INTO bccl_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Wati bestaray tahá ham tará yáta kanán o shapáni pásán tai hayálá bán. ");
INSERT INTO bccl_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Tai bánzoláni sáhegá tará názénán, chiá ke taw mani madatkár ay. ");
INSERT INTO bccl_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Arwáhon gón taw bandók ent o rástén dastet mani posht o panáh. ");
INSERT INTO bccl_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Á ke mani koshagay pad o randá ant gár o gomsára bant o zeminay johlánkián éra rawant. ");
INSERT INTO bccl_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Zahmáni dapá tarrant o tólagáni waráka bant. ");
INSERT INTO bccl_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Bale bádsháh Hodáay dargáhá shádehia kant o harkas ke gón Hodáyá sawgenda wárt pahra kant, chiá ke drógbandáni dap chopp o bandaga bit. ");
INSERT INTO bccl_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodá! Wahdé nálán o peryáta kanán, mani tawárá beshkon o zendá cha torsnákén dozhmenán berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Maná cha badkáráni pandalán chér day, cha radkáráni áshópá. ");
INSERT INTO bccl_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Chiá ke wati zobáná zahmáni paymá téza kanant o wati tahlén habarán tiray paymá kára bandant ");
INSERT INTO bccl_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","tánke cha wati sangarán bémayárá neshánag bekanant. Anágat o bé torsá áiá tira janant. ");
INSERT INTO bccl_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Radén kárá yakdomiá delbaddhia dayant, habar ke kanant, maksadesh wati dámáni chér kanag ent. Gwashant: “Kayesha gendit?” ");
INSERT INTO bccl_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Náensápiá dalil o honara kanant o gwashant: “Má tamán o kamálén shawré kortag.” Pa rásti ke ensánay del o hayál zánaga nabant. ");
INSERT INTO bccl_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Bale Hodá áyán tira jant o anágat thappiga bant. ");
INSERT INTO bccl_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Á wati jenday zobánay sawabá thagala warant. Harkas ke begenditesh pa áyán sará chandhénit. ");
INSERT INTO bccl_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Sajjahén bani ádama torsant, Hodáay kárá jára janant o áiay kárá pa hósh o sára chárant. ");
INSERT INTO bccl_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Pahrézkár Hodáwanday dargáhá shádehi kanát o áiay dargáhá panáh bezurát. Sajjahén nékdel pahr bekanátant. ");
INSERT INTO bccl_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Sawté. Oo Hodá! Sahyuná satá o saná tai wadárá ent, gón taw may kawl puraha bant. ");
INSERT INTO bccl_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Oo taw ke dwáyána eshkonay! Sajjahén mardom dém pa taw káyant. ");
INSERT INTO bccl_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Á wahdá ke gonáh mani sará lombetant, taw márá bakshet. ");
INSERT INTO bccl_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Bahtáwar hamá ent ke tawi gechéna kanay o wati bárgáhá káray tánke hamódá jahmenend bebit. Cha tai dargáhay nékiá séráp bátén, cha tai parasteshgáhay pákiá. ");
INSERT INTO bccl_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Gón wati bákamálén kárán, márá pa adl o ensáp passawa dayay. Oo may rakkénókén Hodá! Zeminay chár kondh o durdastterén daryáyáni omét gón taw ent. ");
INSERT INTO bccl_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Taw ay ke gón wati zór o wáká kóhet jórhéntagant o watá gón kodratá selahbandet kortag, ");
INSERT INTO bccl_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","daryáyáni gorraget árám kortant, mawjáni tawár o kawmáni áshóp. ");
INSERT INTO bccl_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Zeminay chár kondhá nendók cha tai neshánián hayrán ant, taw shagreb o magrebá parmáay ke shádmániay kukkárá bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Taw zeminay hayáldáriá kanay, áiá ápa dayay o ábáda kanay. Hodáay kawr sarréch ent taw mardomán gandoma bakshay chiá ke tai shawr hamé butag. ");
INSERT INTO bccl_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Taw zeminay palán ápa dayay o dhagárá hamdasta kanay, gón gwáragá narmia kanay o rost o rodómá barkata dayay. ");
INSERT INTO bccl_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Gón wati nékiá sálá tájé sará dayay, tai pádráh ham cha barkatá sarréch ant. ");
INSERT INTO bccl_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Gyábánáni charágáh ábáda bant o kóhán wati srén pa shádmáni bastagant. ");
INSERT INTO bccl_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Dhagárán watá gón ramagán póshéntag o daragán gón gandomá, shádmániay kukkárá borza kanant o sawta janant. ");
INSERT INTO bccl_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Pa sázger o washáwázáni sálárá. Sawté. Zaburé. Oo zeminay sajjahén mardomán! Pa Hodáyá shádehiay gwánká bejanét. ");
INSERT INTO bccl_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Áiay námay mazaniá názénét o áiay shán o shawkatá satá kanét. ");
INSERT INTO bccl_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Hodáyá begwashét: “Tai kár chenkadar bákamál ant. Tai wák o kodratay mazaniay sawabá dozhmen tai démá háká kapant. ");
INSERT INTO bccl_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Zeminay sajjahén mardom tará sojdaha kanant o tará názénant. Haw! Tai námá sárháyant.” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Byáét o bechárét ke Hodáyá ché kortag, ajabén kár pa bani ádamá. ");
INSERT INTO bccl_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Daryái hoshk kort o Hodáay kawm ódá pád payádaká cha kawrá gwast, áiay bárgáhá shádmáni bekanén. ");
INSERT INTO bccl_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Á gón wati kodratá tán abad bádsháhia kant, chammi gón kawmán ent. Sarkesh áiay helápá pád mayáyant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Oo kawmán! May Hodáyá satá kanét, pa borztawári benázénéti. ");
INSERT INTO bccl_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","May zendi rakkéntag o pádi cha thagalagá dáshtagant. ");
INSERT INTO bccl_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Oo Hodá! Chiá ke taw márá chakkásetag, taw márá nograhay paymá palgártag. ");
INSERT INTO bccl_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Taw márá dámá dawr dátag o may gardená mazanén báré eshtag. ");
INSERT INTO bccl_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Cha tai razáyá mardomán márá sarjamiá lagatmál kortag, cha áp o ásá gwastagén, bale márá sarsabzén jáhéá áwortaget. ");
INSERT INTO bccl_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Gón sóchagi korbánigán tai dargáhá káyán o gón taw wati kawlán puraha kanán, ");
INSERT INTO bccl_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","hamá kawl ke lonthán wádah dátag o dapá gwashtagant sakki o sóriáni wahdá. ");
INSERT INTO bccl_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Pazzórén dalwatán sóchagi korbániga kanán, gón gwarándháni korbánigay duttán, pa taw pas o gók nadra kanán. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Oo sajjahén Hodátorsán! Byáét o beshkonét, hamá chizzána gwashán ke pa man kortaganti. ");
INSERT INTO bccl_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Gón wati dapá áiay kerrá peryáton kortag, áiay satá o saná mani zobáná at. ");
INSERT INTO bccl_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Agan badié mani delá butén Hodáwandá mani habar gósh nadáshtagat. ");
INSERT INTO bccl_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Bale Hodáyá pa rásti eshkotag o mani dwáay tawári gósh dáshtag. ");
INSERT INTO bccl_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Hodáyá satá bát ke cha mani dwáyá nádelgósh nabutag o wati mehri cha man dur nadáshtag. ");
INSERT INTO bccl_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Pa sázger o washáwázáni sálárá. Pa simmi sázán. Zaburé. Sawté. Hodá may sará mehrabán bát, márá barkat bedayát o wati démá pa má drapshán kanát, ósht..., ");
INSERT INTO bccl_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","tánke tai ráh jaháná zánag bebit o tai dátagén rakkénag sajjahén kawmáni nyámá. ");
INSERT INTO bccl_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Oo Hodá! Kawm tará satá kanátant, sajjahén kawm tará satá kanátant. ");
INSERT INTO bccl_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Kawm shádehi kanátant o shádmániay gwánká bejanátant, chiá ke taw kawmáni sará pa ensáp dádrasia kanay o jahánay kawmáni rahshóna bay. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Oo Hodá! Kawm tará satá kanátant, sajjahén kawm tará satá kanátant. ");
INSERT INTO bccl_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Zeminá wati bar o samar dátag, Hodá, may Hodá, márá barkat bedayát. ");
INSERT INTO bccl_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Hodá márá barkat bedayát tánke zeminay chár kondh áiay mazaniá sharap bedayant. ");
INSERT INTO bccl_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Sawté. Hodá jáh bejanát o áiay dozhmen sheng o sháng bátant, á ke cha áiá naprata kanant cha áiay dargáhá betachátant. ");
INSERT INTO bccl_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Anchosh ke dutt bála kant eshán betáchén, anchosh ke móm ásay démá ápa bit, badkár Hodáay dargáhá gár o gomsár bátant. ");
INSERT INTO bccl_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Bale pahrézkár shádmán o Hodáay dargáhá gal o bál bátant o cha wasshiá shádehi kanátant. ");
INSERT INTO bccl_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Pa Hodáyá sawt bejanét o áiay námá názénét, pa áiá ke jambarán swár ent satá o sanáay tawárá borz kanét. Áiay nám Hodáwand ent, áiay bárgáhá shádehi kanét. ");
INSERT INTO bccl_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Hodá wati pákén bárgáhá chórhawáni pet ent o janózámáni dádras. ");
INSERT INTO bccl_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Hodá békasán pa lóg o jáha kant o bandigán, ázát o ábád, bale sarkesh, hoshkén zeminéá nendóka bant. ");
INSERT INTO bccl_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Oo Hodá! Á wahdá ke wati kawmay rahshón atay, á wahdá ke gyábáná mallán atay, ósht..., ");
INSERT INTO bccl_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","zemin larzet o ásmánán hawr gwart, Hodáay bárgáhá, Sináay kóhay yakdánagén Hodáay, Hodáay bárgáhá, Esráilay Hodáay. ");
INSERT INTO bccl_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Oo Hodá! Taw bázén hawré gwárént o tai mirás ke hoshk o wayrán butagat, taw séráp kort. ");
INSERT INTO bccl_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Tai ramag ódá jahmenend but. Cha wati nékiá, oo Hodá, taw béwas rózi dátant. ");
INSERT INTO bccl_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Hodáwand wati habará jára jant, bashárat árókén janén, mazanén lashkaré ant. ");
INSERT INTO bccl_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Bádsháh gón wati lashkarána jehant o tachant, janén wati lógá áwárán bahra kanant. ");
INSERT INTO bccl_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Toré gwásh o áhorráni tahá wáb bebay kapódaráni bál nograhpósha bant o potthesh teláh‌rang. ");
INSERT INTO bccl_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Wahdé Porwákén Zórá bádsháh sheng o sháng kortant, barpá Salmunay kóhay sará gwart. ");
INSERT INTO bccl_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Oo mazankóh! Oo Báshánay kóh! Oo bázthollén kóh! Oo Báshánay kóh! ");
INSERT INTO bccl_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Oo bázthollén kóh! Pa ché hamá kóhá gón hasaddé cháragá ay ke Hodáyá pa wati lógjáhá gechén kortag, hamódá ke Hodáwand tán abad jahmenenda bit? ");
INSERT INTO bccl_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Hodáay arrábah hazáráni hazár o lakkáni lakk ant, Hodáwand cha Sináay kóhá wati pákén jágahá átkag. ");
INSERT INTO bccl_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Á wahdá ke arshá borz butay bázén bandigé zortet, cha mardomán thékiet zort, tantaná cha sarkashán ham, tánke taw, oo Hodáwandén Hodá, ódá jahmenend bebay. ");
INSERT INTO bccl_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Hodáwandá satá bát, may rakkénókén Hodáyá ke har róch may bárána saggit. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","May Hodá rakkénókén Hodá ent, cha marká rakkénag Hodáwanday dastá ent, tahná Hodáwanday. ");
INSERT INTO bccl_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Bale Hodá dozhmenáni sará próshit, hamáyáni pormudén saray gobbahá próshit ke wati gonáháni tahá gáma janant. ");
INSERT INTO bccl_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Hodáwandá gwashtag: “Áyán cha Básháná pera tarrénán, áyán cha daryáay johlánkián pera tarrénán, ");
INSERT INTO bccl_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","tánke tai pád áyáni hóná lagatmál bekanant o tai kochekáni zobán ham wati bahrá cha dozhmenán begerant.” ");
INSERT INTO bccl_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Oo Hodá! Tai jashnay kárwán gendaga bit mani Hodá o mani bádsháhay kárwán mán pákén jágahá. ");
INSERT INTO bccl_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Démá sháer o poshtá sázger o nyámá jenek tamburag janagá ant. ");
INSERT INTO bccl_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Hodáyá mán mazanén diwánán benázénét. Oo Esráilay óbádagán! Hodáwandá benázénét. ");
INSERT INTO bccl_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benyáminay kasánén kabilah hamódá ent, Yahudáay kamásh áyáni hákem ant, Zebulunay kamásh o Naptáliay kamásh, mazanén rombé ant. ");
INSERT INTO bccl_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Tai Hodáay parmán ent ke taw zóráwar bebay. Oo Hodá! Anchosh ke pésará kortaget, wati zór o wáká márá pésh bedár. ");
INSERT INTO bccl_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Pa tai parasteshgáhay háterá ke Urshalimá ent bádsháh pa taw thékia kárant. ");
INSERT INTO bccl_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Kalam o kásháni nyámay rastará hakkal day o kawmáni gwaskáni nyámá gókáni góromá. Rastar érdasta bit o nograha kárit. Jangdóstén kawmán sheng o sháng kan. ");
INSERT INTO bccl_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Kásed cha Mesrá káyant Habashah eshtápiá wati dastán dém pa Hodáyá borzáda kant. ");
INSERT INTO bccl_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Oo jahánay molkán! Pa Hodáyá sawt bejanét, Hodáwandá gón sawtá benázénét, ósht..., ");
INSERT INTO bccl_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","hamáiá ke ásmánán shahswária kant, kwahnén ásmánán, hamáiá ke wati áwázá borza kant, trond o porwákén áwázá. ");
INSERT INTO bccl_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Hodáay kodratá jár bejanét, ke shán o shawkati Esráilay sará ent o kodrati, ásmánáni sará. ");
INSERT INTO bccl_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Oo Hodá! Taw wati pákén jágahá bákamál ay, Esráilay Hodá wati kawmá zór o wáka bakshit. Hodáyá satá o saná bát. ");
INSERT INTO bccl_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Pa sázger o washáwázáni sálárá. “Susanáni” tarzay sará. Dáuday Zabur. Oo Hodá! Maná berakkén ke áp tán mani gardená ent. ");
INSERT INTO bccl_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Johlánkén pujgelán mén butagán, jágahé ke páda naóshtit. Johlánkén ápáni tahá kaptagán o hár o lahrhán maná angerr kortag. ");
INSERT INTO bccl_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Cha bázén peryátán damon bortag, mani nokk hoshk ent o chamm wati Hodáay wadárá tahár butagant. ");
INSERT INTO bccl_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Á ke bésawab cha man naprata kanant cha mani saray mudán géshter ant. Bázéné mani gár kanagay randá ent dozhmen mani sará drógén bohtáma janant. Cha man lóthant hamá chizzán per betarrénán ke man nadozzetagant. ");
INSERT INTO bccl_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Oo Hodá! Taw zánay ke man ahmaki kortag, mani gonáh cha taw chér naant. ");
INSERT INTO bccl_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Oo Hodáwand, oo lashkaráni Hodáwand! Hamá ke tai wadárig ant mani sawabá sharmendag mabátant. Oo Esráilay Hodá! Hamá ke tai shóházá ant mani sawabá roswá mabátant. ");
INSERT INTO bccl_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Chiá ke pa taigi maná sobakka kanant o mani dém cha sharmá póshénag butag. ");
INSERT INTO bccl_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Brátáni chammá bigánag butagán o wati mátay chokkáni démá darámadé. ");
INSERT INTO bccl_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Á gayrat ke maná pa Hodáay lógá hastent, maná jánsócha kant o báhénit o tai rad o bad kanókáni rad o bad, mani sará kaptagant. ");
INSERT INTO bccl_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Á wahdá ke arson rétkag o róchagon dáshtag sobakk kanag butagán. ");
INSERT INTO bccl_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Á wahdá ke sugi god o póshákon gwará kortagant, esháni kerrá batalé butagán. ");
INSERT INTO bccl_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Shahray masteráni gwará nám o dap án o sharábiáni sawt. ");
INSERT INTO bccl_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Bale man, oo Hodáwand, tai rahmay wahdá, tai dargáhá dwá kanán. Oo Hodá! Cha wati bázén mehr o wapádáriá, gón deljamén rakkénagé passaw beday. ");
INSERT INTO bccl_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Maná cha pujgelán dar kan, tánke ér maboddhán. Cha naprat kanókáni panjagá maná berakkén o cha johlánkén ápán dar kan. ");
INSERT INTO bccl_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Mayl ke hár maná angerr kanant, yánke johlánki maná ér barant, yá mani sará kall wati dapá bebandit. ");
INSERT INTO bccl_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Oo Hodáwand! Mani passawá beday ke tai rahmat báz ant, wati rahmatáni kesás o hesábá, wati démá gón man betarrén. ");
INSERT INTO bccl_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Démá cha wati hezmatkárá mapóshén, pa mani madatá eshtáp kan ke sakk tang átkagán. ");
INSERT INTO bccl_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Nazzik byá o maná berakkén, dozhmenáni sawabá maná bemók. ");
INSERT INTO bccl_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Taw á sobakkián wata zánay ke mani sará ant o mani sharmsári o roswáián, mani sajjahén dozhmen tai démá ant. ");
INSERT INTO bccl_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Sobakki o béezzatián mani del próshtag o dar mantagán, rahmay wadárá atán o dastá nakapt, gamwáréay shóházá atán o naraset. ");
INSERT INTO bccl_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Warákay badalá, maná jawresh dát o wahdé tonnig bután tropshén sharábesh nóshént. ");
INSERT INTO bccl_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Parzónagesh dámé bát o sohl o émeniesh talké. ");
INSERT INTO bccl_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Chammesh tahár bát o magendátant o srénesh drahag o larzagá bát. ");
INSERT INTO bccl_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Wati hezhmá áyáni sará begwárén, gazabay ácheshá pa áyán berasén. ");
INSERT INTO bccl_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Lóg o jágahesh haráb o wayrán bát, áyáni gedánán hechkas jahmenend mabát. ");
INSERT INTO bccl_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Chiá ke hamáiá ázára rasénant ke taw jatag o hamáiay ranjáni habará kanant ke taw thappig kortag. ");
INSERT INTO bccl_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Mayár pa mayáresh beladdh, cha tai adlá bébahr bátant. ");
INSERT INTO bccl_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Cha zendagénáni daptará gár bátant, gón pahrézkárán yakjáh nebisag mabátant. ");
INSERT INTO bccl_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Bale nun man, setam distag o padard án. Oo Hodá! Tai neját maná émen bedárát. ");
INSERT INTO bccl_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Hodáay námá gón sawta názénán o gón bázén shogrgozáriá shán o shawkatia dayán. ");
INSERT INTO bccl_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","É chizz Hodáyá cha gwaskéá géshter pasonda bit, cha mazankánth o mazansrombén gókéá. ");
INSERT INTO bccl_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Békebr o darbésh é chizzá ke begendant gal o shádána bant. Oo Hodáay shóház kanókán! Zendahdel bátét. ");
INSERT INTO bccl_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Hodáwand nyázmandáni dwáyán gósha dárit o wati bandigén mardomán bazzag o wára nakant. ");
INSERT INTO bccl_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Ásmán o zemin áiá benázénant, daryá o áiay tahay sajjahén sahdár. ");
INSERT INTO bccl_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Chiá ke Hodá Sahyuná nejáta dant o Yahudáay shahrán nóksará addha kant. Kawm ódá jahmenenda bit o molkay hakkén wáresa bit. ");
INSERT INTO bccl_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Molk áiay hezmatkáráni poshtpaday mirása bit o áiay námay dóst dárók ódá jahmenenda bant. ");
INSERT INTO bccl_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Dazbandié. Oo Hodá! Zutt kan o maná berakkén. Oo Hodáwand! Pa mani madatá eshtáp kan. ");
INSERT INTO bccl_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Á ke mani kóshay randá ant, sarjahl o sharmsár bátant, á ke mani barbádiá gala bant, pad bekenzát o roswá bátant. ");
INSERT INTO bccl_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Á ke mani sará “hah, haha” kanant, cha pashaliá poshtoká kenzátant. ");
INSERT INTO bccl_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Bale á ke tai shóházá ant, sajjahén tai dargáhá shádehi kanát o gal o bál bátant, á ke tai dátagén nejátesh dósta bit, modám begwashátant: “Hodáwand mazanshán ent.” ");
INSERT INTO bccl_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Bale man setam distagén mohtájé án. Oo Hodá! Dém pa man eshtáp kan, taw mani rakkénók o madatkár ay. Oo Hodáwand! Dér makan. ");
INSERT INTO bccl_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Oo Hodáwand! Man tai mayár o báhóth án, maná sharmsár makan. ");
INSERT INTO bccl_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Pa wati adlá maná berakkén o bechotthén, delgóshá gón man kan o maná berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Mani panáh dayagay talár bay, ke modám dém pa áiá byáyán. Taw pa mani rakkénagá hokm kortag, chiá ke mani talár o kalát taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Oo mani Hodá maná cha badkáráni dastá berakkén, cha setamger o bérahmáni panjagá. ");
INSERT INTO bccl_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Chiá ke taw, oo Hodáwand, mani omét ay o cha kasániá, oo Hodáwand, óst o ométon tai sará butag. ");
INSERT INTO bccl_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Cha pédáeshá mani komak kanók butagay, é taw butagay ke maná cha mátá pédá kortag, mani satá o sárháyagáni dém modám gón taw ent. ");
INSERT INTO bccl_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Pa bázénéá neshánié butagán, chiá ke taw mani mohrén panáhgáh ay. ");
INSERT INTO bccl_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Dapon cha tai tawsipá porr ent, cha tai shán o shawkatá sajjahén róchá. ");
INSERT INTO bccl_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Piriá maná cha watá dur makan, á wahdá ke twánona kotthit, yalahon makan. ");
INSERT INTO bccl_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Chiá ke dozhmen mani helápá habará ant, á ke mani koshagay randá ant hórigá pandala sázant. ");
INSERT INTO bccl_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Gwashant: “Hodáyá yalah kortag, berawén begeréni, kassia narakkénit.” ");
INSERT INTO bccl_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Oo Hodá! Cha man dur mabay. Oo mani Hodá! Mani madatá eshtáp kan. ");
INSERT INTO bccl_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Mani bohtám janók sharmsár o tabáh bátant o á ke mani ázáray padá ant pashal o sharmendag bátant. ");
INSERT INTO bccl_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Bale man modám tai komakay ométwár án o tará gésh o géshter satá kanán. ");
INSERT INTO bccl_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Tai ádelén káráni habará kanán, sajjahén róchá tai dátagén nejátay járá janán, harchont ke áyáni hesáb cha mani zánagá dhann ent. ");
INSERT INTO bccl_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Mana káyán o Hodáwanday porwákén káráni járá janán, tahná Hodáwanday, tai adlay járá janán, tahná tai. ");
INSERT INTO bccl_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Oo Hodá! Taw maná cha kasániá sój dátag, modám tai ajabén káráni járá janán. ");
INSERT INTO bccl_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Oo Hodá! Nun ke pir án o mud espét ant, maná yalah makan, tán nókén padréchay nyámá tai zóray járá bejanán o sajjahén áyókén naslán cha tai wák o twáná sahig bekanán. ");
INSERT INTO bccl_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Oo Hodá! Tai adl tán borzén arshá ent, taw ay ke mazanén káret kortag. Oo Hodá! Tai matth kay ent? ");
INSERT INTO bccl_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Harchont taw maná bázén sakki o sóri pésh dáshtag, bale padá mani zendá bódénay, Haw, nóksará maná cha zeminay johlánkiá borzáda káray. ");
INSERT INTO bccl_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Mani ezzatá borztera baray maná padá ásudaga kanay. ");
INSERT INTO bccl_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Man tará gón chang o soróda názénán, chiá ke taw wapádár ay, oo mani Hodá! Gón rabábay sázá tará názénán, oo Esráilay Pákén! ");
INSERT INTO bccl_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Mani lonth shádmániay kukkárá kanant, man tará názénán, ke taw maná móketag. ");
INSERT INTO bccl_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Sajjahén róchá tai ádelén káráni zegrá kanán chiá ke á ke mani ázár rasénagay lóthók atant, sarjahl o sharmsár butagant. ");
INSERT INTO bccl_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Solaymánay Zabur. Oo Hodá! Wati adlá bádsháhá bebaksh, wati ensápá bádsháhay chokká, ");
INSERT INTO bccl_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","tánke á pa ensáp tai kawmay sará dádrasi bekant, setam distagénáni sará pa adl. ");
INSERT INTO bccl_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Kóh pa kawmá ábádi byárátant, jomp o tomp, pahrézkáriay samará. ");
INSERT INTO bccl_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Bádsháh kawmay setam distagénáni hakká bedayát, mohtájáni chokkán berakkénát o setamgerán tabáh kanát. ");
INSERT INTO bccl_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Nasláni nasl tai sharap o ezzatá bedárátant, tánke rócha drapshit, tánke máh nura dant. ");
INSERT INTO bccl_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Bádsháhay hákemi hamá hawráni paymá bát ke rotagén sabzagáni sará gwárant, hamá hawráni paymá ke zeminá sérápa kanant. ");
INSERT INTO bccl_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Áiay ahdá pahrézkár shádáb bátant, tán hamá wahdá ke máh nura dant ábádi bát. ");
INSERT INTO bccl_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Daryá tán daryá áiay bádsháhi barjáh bát o cha kawrá tán zeminay goddhi simsarán. ");
INSERT INTO bccl_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Áiay dargáhá gyábánay nendók sará jahl bekanátant, áiay dozhmen hák bechatthátant. ");
INSERT INTO bccl_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Tarshish o tayábgwaráni sardhagáray bádsháh hamáiá song o máliát bedayátant, Shébá o Sabáay bádsháh pa áiá théki byárátant. ");
INSERT INTO bccl_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Sajjahén bádsháh, áiay démá sará jahl bekanátant, sajjahén kawm áiay hezmatá bekanátant. ");
INSERT INTO bccl_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Chiá ke á hájatmandán hamá wahdá rakkénit ke peryáta kanant, setam distagénán o hamáyán ke madatkáré néstesh. ");
INSERT INTO bccl_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Nezór o hájatmandáni sará rahma kant o hájatmandáni zendá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Áyáni zendá cha zolm o sheddatá nejáta dant, áyáni hóná gránkimmata zánt. ");
INSERT INTO bccl_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Omri báz bát, Sabáay teláh áiay peshkash bátant. Mardom modám áiay dwágó bátant o sajjahén róchá pa áiá barkat belóthátant. ");
INSERT INTO bccl_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Gandom sajjahén molká anchosh báz bát ke jompáni sará chawl bejant o bar o samari anchosh báz bát ke Lobnáná ent. Shahrán mardom anchosh ábád bátant ke sabzag mán dhagárán. ");
INSERT INTO bccl_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Bádsháhay nám namirán bát, tán rócha drapshit nám o tawári bemánát. Sajjahén kawm cha áiá barkat begerátant o áiá mobárak begwashátant. ");
INSERT INTO bccl_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Hodáwandén Hodáyá satá bát, Esráilay Hodáyá, ajabén káráni kanók tahná hamá ent. ");
INSERT INTO bccl_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Áiay porshawkatén námá tán abad satá bát, áiay shán o shawkat sajjahén zeminá begerát. Anchosh bát. Ámin. ");
INSERT INTO bccl_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Dáude Yassiay dwá hamedá kotthant. ");
INSERT INTO bccl_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asápay Zabur. Pa rásti Hodá pa Esráilá mehrabán ent, pa hamáyán ke delesh sáp ent. ");
INSERT INTO bccl_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Bale kammé mantagat bethagalán, nazzik at pád belakoshant. ");
INSERT INTO bccl_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Chiá ke pa porkebrán hasaddi bután, hamá wahdá ke man badkár ábádi o ásudagiá distant. ");
INSERT INTO bccl_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Chiá ke áyán tán marká dardé per nést o wassh o sérláp ant. ");
INSERT INTO bccl_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Á degaráni paymá ranj o zahmatá naant o mardomi baláháni tahá nakapant. ");
INSERT INTO bccl_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Paméshká kebr áyáni gwaray hár ent o hezhm o gazab áyáni póshák. ");
INSERT INTO bccl_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Chammesh cha pazzóriá dar átkagant o delay hayálánesh haddé nést. ");
INSERT INTO bccl_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Pa maskará o badwáhi habara kanant, pa kebr zolm o setamá wati zobáná kárant. ");
INSERT INTO bccl_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Dapá ásmánay helápá pacha kanant o zobánesh sajjahén zeminá gipt. ");
INSERT INTO bccl_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Paméshká kawm dém pa áyána rawt o pa galé hamáyáni dastay ápána wárt. ");
INSERT INTO bccl_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Gwashant: “Hodá che paymá zánt? Borzén arshay Hodáyá é dhawlén zántkári hast?” ");
INSERT INTO bccl_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Haw, badkár chosh ant, modám ásudag ant o mál o melkatesh démá rawán ent. ");
INSERT INTO bccl_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Pa rásti man wati del mopt o náhudagá pák dáshtag o dast mán bégonáhiá shoshtagant. ");
INSERT INTO bccl_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Har róch ázárán kaptagán o har sohbá hakkala warán. ");
INSERT INTO bccl_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Agan begwashténon: “É habarána kanán,” man tai chokkáni nasl dróhetagat. ");
INSERT INTO bccl_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Wahdé é sajjahén chizzáni zánagay johdon kort, pa man grán at, ");
INSERT INTO bccl_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","tán hamá wahdá ke Hodáay pákén jágahá shotán. Nun é mardománi ákebaton dist. ");
INSERT INTO bccl_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Pa rásti áyán lakoshánkén jáhána perrénay, gár o gomsáriay chátá dawra dayay. ");
INSERT INTO bccl_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Anágat gár o zawála bant, cha torsá sarjamá bérána bant. ");
INSERT INTO bccl_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Wábéay dhawlá ant ke wahdé chamm pacha bant gára bit, á wahdá ke taw páda káay, oo Hodáwand, eshán wahméay paymá mána nayáray. ");
INSERT INTO bccl_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Á wahdá ke mani arwáh zahr o tahl at o del résh, ");
INSERT INTO bccl_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","bépahm o nazántkár atán, tai dargáhá haywánéay paymá, cha pahm o póhá dhann. ");
INSERT INTO bccl_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Angat ham modám gón taw án, taw mani rástén dastá geray. ");
INSERT INTO bccl_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Gón wati sar o sóján maná rahshónia kanay o randá gón shán o shawkaté zuray. ");
INSERT INTO bccl_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ásmáná, abéd cha taw maná kay hast?! Zeminá ham, abéd cha taw hech chizzé nalóthán. ");
INSERT INTO bccl_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Mani jesm o ján o del balkén zawál bebant, bale Hodá mani delay kalát ent, tán abad mani gisshetagén bahrwandh. ");
INSERT INTO bccl_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Pa rásti á ke cha taw dur ant gár o gomsára bant o hamáyán bérána kanay ke gón taw béwapá ant. ");
INSERT INTO bccl_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Bale pa man wasshi hamesh ent ke Hodáay nazziká bebán, Hodáwandon wati panáhgáh kortag, tán tai sajjahén kárán jár bejanán, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Asápay shayri gwashtánk. Oo Hodá! Chiá márá tán abad yalah dátaget? Pa ché tai hezhmay ás pa tai charágáhay pasán rók ent? ");
INSERT INTO bccl_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Wati kawmay yátá bekap, ke taw cha dérén zamánagán pa bahá zortagatant, ke taw móketagant tán tai kawm o mirás bebant. Sahyunay kóhay hayálá bekap ke ódá jahmenend butagay. ");
INSERT INTO bccl_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Wati gámán dém pa wati hamé modámigén wayránagán betarrén, chiá ke dozhmená har chizz bérán kortag ke tai pákén jágahá butag. ");
INSERT INTO bccl_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Dozhmenán tai didárjáhay tahá gorret o wati bayrak pa neshániá mekk kortant. ");
INSERT INTO bccl_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Hamáyáni paymá atant ke wati taparán jangalay drachkáni sará borza barant. ");
INSERT INTO bccl_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Áyán, tai pákén jágahay sajjahén ájetagén dár gón wati tapar o téshagán prósht o hurt kortant. ");
INSERT INTO bccl_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Tai pákén jágahesh ás kasshet o hák o por kort, tai námay menendjáhesh palit kort. ");
INSERT INTO bccl_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Wati delá gwashtesh: “Áyán sarjamiá wati panjagay chérá kárén,” gorhá Hodáay sajjahén didárjáhesh é sardhagárá sótkant. ");
INSERT INTO bccl_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Nun hech neshánié nagendagá én, hech nabié pasht nakaptag o cha má kass ham nazánt ke tán kadén é paymá bit. ");
INSERT INTO bccl_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Oo Hodá! Tán kadén dozhmen tai sará bekandit? Dozhmen tán abad tai námá bad o rad bekant? ");
INSERT INTO bccl_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Chiá wati dastá poshtá dáray, wati rástén dastá? Dastá pach kan o pa áyán gári o tabáhié byár. ");
INSERT INTO bccl_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Bale Hodá cha dérén zamánagán mani bádsháh ent, ke zeminay sará nejátbakshén kára kant. ");
INSERT INTO bccl_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","É taw atay ke daryáet gón wati zór o wáká do ném kort o daryáay baláháni saret ápáni nyámá próshtant, ");
INSERT INTO bccl_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Liwyátánay saret próshtant o gyábánay sahdáráni waráket kort. ");
INSERT INTO bccl_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Jó o sarchammag, taw rombént o rawán kortant, modámigén kawr, taw hoshk kortant. ");
INSERT INTO bccl_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Róch taig ent o shap ham tai máh o róch taw barjáh dáshtagant. ");
INSERT INTO bccl_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","É taw atay ke zeminay hand o simsaret gisshéntant, garmág o zemestánay addh kanók taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Oo Hodáwand! Yátá bekap ke dozhmen che paymá maskará kanant o názántén mardom tai námá che paymá bad o rada gwashant. ");
INSERT INTO bccl_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Wati kapótá rastaráni warák makan o setam distagén kawmay zendá tán abad mashamósh. ");
INSERT INTO bccl_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Wati bastagén ahdá bedár, chiá ke é sardhagáray tahárén jágah cha zolm o zóray kodóh o kodámá porr ant. ");
INSERT INTO bccl_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Mayl ke pádmálén mardom gón roswái pad bekenzant, setam distag o hájatmand tai námá satá bekanátant. ");
INSERT INTO bccl_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Oo Hodá! Jáh jan o wati hakkay démpániá bekan, yátá bekap ke názánt sajjahén róchá che paymá tai sará kandant. ");
INSERT INTO bccl_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Wati dozhmenáni kukkárán mashamósh, dozhmenáni shóreshá ke modám borzád ent. ");
INSERT INTO bccl_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Asápay Zabur. Sawté. Oo Hodá! Tai shográ gerén, tai shográ gerén ke tai nám nazzik ent o mardom tai ajabén káráni habará kanant. ");
INSERT INTO bccl_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Taw gwashay: “Wati gisshéntagén wahdá pa ensáp dádrasia kanán. ");
INSERT INTO bccl_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Hamá wahdá ke zemin o áiay sajjahén nendóka larzant, é man án ke áiay pádagán mohra dárán. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Gón porkebrán gwashán: ‘Pahr mabandét,’ o gón badkárán: ‘Wati kánthán borz makanét. ");
INSERT INTO bccl_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Wati kánthán enkadar borz makanét o pa kebr o gorunáki habar makanét.’” ");
INSERT INTO bccl_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Chiá ke sarperázi na cha ródarátká kayt, na cha rónendá o na cha gyábáná. ");
INSERT INTO bccl_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","É Hodá ent ke dádrasia kant, yakkéá éra jant o yakkéá sarborza kant. ");
INSERT INTO bccl_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Chiá ke Hodáay dastá jámé, cha porjóshén sharáb o tahlagá porr ent. Sharábá réchit o zeminay sajjahén badkár áiá tán goddhi trampá warant. ");
INSERT INTO bccl_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Bale man modám Hodáay káráni habará kanán, Ákubay Hodáyá názénán. ");
INSERT INTO bccl_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","“Sajjahén badkáráni kánthána próshán, bale pahrézkáráni kánth borz dáraga bant.” ");
INSERT INTO bccl_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Pa sázger o washáwázáni sálárá. Gón simmi sázán. Asápay zabur. Sawté. Yahudiahá Hodá zánag o pajjáh áraga bit, Esráilá áiay nám mazan ent. ");
INSERT INTO bccl_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Áiay tambu Shalimá ent o menendjáh, Sahyuná. ");
INSERT INTO bccl_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ásgwárén tiri hamódá próshtant, zahm o espar ham, ke jangi seláh ant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Taw drapshán ay o shawkat o shánet, cha á kóhestagán zébáter ent ke shekárá porr ant. ");
INSERT INTO bccl_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Delér áwár janag butant, wati goddhi wábá ant, cha jangáwarán yakké ham namant ke dasté besorénit. ");
INSERT INTO bccl_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Oo Ákubay Hodá! Cha tai neherrán, áyáni arrábah o aspán sar pa markay wábá dát. ");
INSERT INTO bccl_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Taw bákamál ay, wahdé hezhma geray, kay tai démá óshtáta kant? ");
INSERT INTO bccl_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Taw cha ásmáná dádrasia kanay o wahdé taw, oo Hodá, pa dadrasiá jáha janay ke zeminay sajjahén setam distagénán neját bedayay, zemin cha torsá chopp o bétawára bit. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Pa ensáná tai hezhm ham tai satáay sawaba bit o pasht kaptagén hezhmá taw wati lánká banday. ");
INSERT INTO bccl_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Gón wati Hodáwandén Hodáyá kawl bekanét o wati zobánay sará bóshtét, á sajjahén ke kerr o gwarán ant pa hamáiá théki byárant ke bákamál ent. ");
INSERT INTO bccl_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Á hákemáni gorurána próshit, zeminay bádsháh cha áiá torsant. ");
INSERT INTO bccl_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Pa sázger o washáwázáni sálárá. Pa Jedutuná. Asápay Zabur. Man Hodáyá tawára kanán o pa komaká hamáiá gwánka janán, mani peryát gón Hodáyá ent o á mani áwázá gósha dárit. ");
INSERT INTO bccl_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Sakki o sóriáni róchá Hodáwanday shóházá án, sajjahén shapá mani dast dráj ant o dama nabarán, mani arwáh árám geraga nalóthit. ");
INSERT INTO bccl_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Hodáyá yáta kanán o nálán, pegra kanán o delprósha bán. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Taw mani chammán nazz bayagá naylay, paréshán án o habar korta nakanán. ");
INSERT INTO bccl_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Gwastagén wahdáni hayálá kapán, kwahnén ahd o bárigáni. ");
INSERT INTO bccl_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Shapán, wati sawtay hayálá kapán, delá báz pegriga bán o arwáhon josta kant: ");
INSERT INTO bccl_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Hodáwand tán abad yalaha kant o padá hechbar mehrabána nabit? ");
INSERT INTO bccl_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Áiay mehr pa modámi halás butag o kawli pa sajjahén naslán zawál? ");
INSERT INTO bccl_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Hodáyá mehrabán bayag shamoshtag o wati rahmati hezhmay tahá band kortag?” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Mana gwashán: “É shakk o sawál maná ranjénant. Nun hamá ahd o bárigáni hayálá kapán ke borzén arshay Hodáyá wati rástén dast shahártag.” ");
INSERT INTO bccl_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Oo Hodáwand! Tai kárán yáta kanán, tai ajabén kárán ke taw péshi zamánagán kortagant. ");
INSERT INTO bccl_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Tai kortagén sajjahén káráni bárawá pegra kanán o tai kerdáni hayálá bán. ");
INSERT INTO bccl_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Oo Hodá! Tai ráh pák ent. Kojám hodá may Hodáay paymá mazan buta kant? ");
INSERT INTO bccl_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Taw hamá Hodá ay ke ajabén kára kant. Taw wati zór o wák sajjahén kawmáni nyámá pésh dáshtag, ");
INSERT INTO bccl_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","gón wati básk o kodratá wati kawm rakkéntag, Ákub o Issopay chokk. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Ápán tará dist, oo Hodá! Ápán tará dist o larzetant, johlánki drahagá laggetant. ");
INSERT INTO bccl_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Jambarán ápa gwart o ásmánán grandet, tai grókay tir har némagá retkant. ");
INSERT INTO bccl_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Tai granday tawár danz o gwátáni tahá at, tai nurá jahán róshná kort, zemin larzet o jombet. ");
INSERT INTO bccl_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Tai ráh cha mazanén daryáyá gwast o tai keshk cha mazanén ápán, bale tai pádáni pad gendag nabutant. ");
INSERT INTO bccl_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Taw wati kawm Mussá o Hárunay dastá rahshóni kort, ramagéay paymá. ");
INSERT INTO bccl_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Asápay shayri gwashtánk. Oo mani kawm! Mani sóján gósh dár o delgóshá gón mani habarán kan. ");
INSERT INTO bccl_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Wati dapá pa batal pacha kanán o kwahnén chách o chistánán máná kanán, ");
INSERT INTO bccl_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","hamá ke má eshkotag o zántagant, hamá ke may pirénán márá gwashtagant. ");
INSERT INTO bccl_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Eshán cha áyáni chokk o nomásagán chéra nadayén, gón áyókén naslá Hodáwanday porshawkatén káráni kessahá kárén, Hodáwanday zór o twánay kessahá kárén o áiay kortagén ajabén mójezaháni kessahá. ");
INSERT INTO bccl_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Áiá gwáhié pa Ákubá esht, Sharyati pa Esráilá áwort o may pet o piréni parmán dátant ke eshán wati chokk o nomásagán sarpad bekanét, ");
INSERT INTO bccl_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","tán démi naslesh bezánant o hamá chokk ham ke angat pédá nabutagant, wati wahdá, gón wati chokk o nomásagán esháni kessahá bekanant, ");
INSERT INTO bccl_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","tánke á ham Hodáay sará tawkal bekanant o Hodáay kárán mashamóshant o áiay hokmán bemannant. ");
INSERT INTO bccl_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Wati pet o pirénáni paymá mabant, sarkash o mánmayátk ke delesh gón Hodáyá nabast o arwáhesh gón Hodáyá wapádár naat. ");
INSERT INTO bccl_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Epráimi, harchont ke gón kamánán selahband atant, bale janagay róchá tatkant. ");
INSERT INTO bccl_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Áyán Hodáay ahd nadásht o wati delá shawresh kort ke “áiay Sharyatay sará zenda nagwázénén.” ");
INSERT INTO bccl_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Áiay kortagén káresh shamoshtant, hamá ajabén kár ke áyáná péshi dáshtagatant, ");
INSERT INTO bccl_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Hamá kár ke áyáni pet o pirénáni démá kortagatanti, Mesray molká, Zohánay gyábáná. ");
INSERT INTO bccl_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Áyáni démay daryái ném kort o ái gwázéntant, ápi, doén démán chó diwálá mekk kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Róchá, gón jambará rashónii dátant o shapá gón ásay rozhná. ");
INSERT INTO bccl_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Gyábáná, talári tal kortant o áyáná, johlén zeréay kesásá ápi dát. ");
INSERT INTO bccl_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Cha talárán chammagi bótkant o ápi chó kawrá rombént. ");
INSERT INTO bccl_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Bale áyán angat géshter gonáh kort o gyábáná borzén arshay Hodáay helápá shóreshesh kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Hodáesh pa zánt hamá warákáni sará chakkáset ke áyáni delá lóthet. ");
INSERT INTO bccl_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Hodáay helápá habaresh kort o gwashtesh: “Hodá é gyábáná parzónagé pach korta kant? ");
INSERT INTO bccl_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Talári wa jat o cha áiá áp rawán but o kawr sar rechán butant, bale wati mardomán nán ham dáta kant? Yá pa wati kawmá gósht ham tayár korta kant?” ");
INSERT INTO bccl_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Hodáyá ke eshkot, zahr gept, ásé pa Ákubá róki kort, hezhmi pa Esráilá chest but. ");
INSERT INTO bccl_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Chiá ke Hodáay sará imánesh néstat o báwaresh nabut ke Hodáesha rakkénit. ");
INSERT INTO bccl_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Ásmáni pa pach bayagá parmán dát o arshay darwázagi pach kortant. ");
INSERT INTO bccl_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Manni pa áyán chó hawrá gwart ke bwarant, ásmáni gandomi bakshátant. ");
INSERT INTO bccl_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Mardomán préshtagi warák wárt, pa áyán békesás waráki rawán dát. ");
INSERT INTO bccl_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Cha ásmáná ródarátki gwáti sar dát o gón wati zórá jonubi gwáti chest kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Danzáni paymá pa áyán góshti gwárént, daryáay rékáni kesásá, báli morg, ");
INSERT INTO bccl_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","áyáni ordgáhá éri áwortant, áyáni gedánáni kerr o gwarán. ");
INSERT INTO bccl_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Wárt o séresh kort, pa har chizzá ke áyán hers at, dátanti. ");
INSERT INTO bccl_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Bale cha áyáni hersay purah bayagá pésar, ke warákesh angat dapá at, ");
INSERT INTO bccl_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Hodáay hezhm áyáni sará pád átk, áyáni zórmandterén mardomi koshtant o Esráilay warnái jokkéntant. ");
INSERT INTO bccl_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","É sajjahén káresh distant o angat ham gonáhesha kort o áiay ajabén káráni sará báwaresha nakort. ");
INSERT INTO bccl_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Gorhá áyáni róchi pa náhudagi halás kortant o sál pa tors. ");
INSERT INTO bccl_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Hodáyá ke áyáni koshag bendát kort, nun áiay shóházá dar kaptant. Dém pa Hodáyá per tarretant o pa setk o del Hodáay shóházá butant. ");
INSERT INTO bccl_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Hayálá kaptant ke Hodá áyáni talár ent, hamá borzén arshay Hodá, áyáni posht o panáh. ");
INSERT INTO bccl_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Bale gón wati dapá, gón áiá charpzobániesha kort o gón zobáná drógesha bast. ");
INSERT INTO bccl_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Delesh gón áiá wapádár naat o áiay bastagén ahdesh nadásht. ");
INSERT INTO bccl_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Bale á angat mehrabán at o áyáni gonáhi bakshetant o sajjahéni nakoshtant. Rand pa randá wati hezhmia dásht o wati sajjahén gazabi darshána nakort. ");
INSERT INTO bccl_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Zánti ke é hákién ensán ant, rawókén gwáté ke padá pera natarrit. ");
INSERT INTO bccl_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Gyábáná chinchok randá cha Hodáyá sarkashiesh kort, ódá áesh gamig kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Rand pa randá Hodáesh chakkáset, Esráilay pákénesh ázár dát. ");
INSERT INTO bccl_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Áiay dastay zóresh yát nakort ke á róchá chón cha dozhmenáni dastá rakkéntanti, ");
INSERT INTO bccl_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","hamá wahdá ke Mesrá wati neshánii paddar kortant o Zohánay gyábáná ajabén kári kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Áyáni kawri hóná badal kortant ke kassá cha wati jóán áp wárta nakort. ");
INSERT INTO bccl_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Makeskáni rombi áyáni nyámá ráh dátant ke makeskesh bwarant o pogoláni romb, ke barbádesh bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Áyáni keshári madagáná dátant o bar o samar kathagán wártant. ");
INSERT INTO bccl_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Áyáni anguri gón tróngalá zawál kortant o enjiráni drachk, gón hár o tuppánán. ");
INSERT INTO bccl_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Áyáni ramagi pa tróngal koshtant o dalwat, pa grand o grók. ");
INSERT INTO bccl_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Wati sóchókén kahr o gazabi áyáni sará rawán dát, kahr o gazab o azáb, gár o gomsár kanókén préshtagáni thólié áyáni sará. ");
INSERT INTO bccl_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Ráhi pa wati hezhmá rást o tachk kort, cha marká narakkéntanti, wabáyáni dapái dátant. ");
INSERT INTO bccl_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Mesray sajjahén awali chokki jatant, Mesray gedánnendáni mardánagiay awali bar o samar. ");
INSERT INTO bccl_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Bale wati mardomi ramagay paymá sar dát o bortant, pasáni dhawlá gyábánán rashónii kortant. ");
INSERT INTO bccl_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ái pa émeni rahshóni kortant ke matorsant bale áyáni dozhmen daryáyá mán patátant. ");
INSERT INTO bccl_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Gorhá ái wati pákén zeminá sar kortant, hamá kóhestagén molká ke gón wati rástén dastá geptagati. ");
INSERT INTO bccl_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Áyáni démá kawmi cha ódá dar kortant, kawmáni zemini áyáni mirás kortant o Esráilay kabilahi gedánáni tahá jahmenend kortant. ");
INSERT INTO bccl_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Bale angat áyán borzén arshay Hodá chakkáset o áiay helápá sarkashiesha kort, áiay hokmesha namannet. ");
INSERT INTO bccl_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Wati pirénáni paymá rástén ráhesh yalaha dát o béwapá butant, chó sost o nábáwarén kamáná mantant. ");
INSERT INTO bccl_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Borzén jáhán bothánahesha bast o Hodáesh zahra baráént, botesha jórhént o Hodáesh hasaddiga kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Hodáyá ke dist, sakk hezhm gept o Esráili sarjamiá yalah kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Wati Shiluhay menendjáhi yalah kort, hamá tambu ke Hodá ódá mardománi nyámá jahmenend at. ");
INSERT INTO bccl_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Wati zór o wákay pétii bandig kanáént, wati shán o shawkatay neshánii dozhmenáni dastá dát. ");
INSERT INTO bccl_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Wati kawmi zahmáni dapá dát, wati mirásay sará sakk hezhmnák but. ");
INSERT INTO bccl_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Warnáén bachak, ásá wártant o jenek, pa suri názénkán sar nabutant. ");
INSERT INTO bccl_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Dini péshwá zahmáni dapá kaptant o janózámán gréta nakort. ");
INSERT INTO bccl_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Nun Hodáyá anchosh jáh jat ke yakké cha wábá bosta kant, chó ke jangólé cha sharábay béhóshiá jáh bejant. ");
INSERT INTO bccl_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Wati dozhmeni jat o poshtá kenzént o abadi roswáiéá dawr dátant. ");
INSERT INTO bccl_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Bale Issopay tambui nádóst kort o Epráimay kabilahi nazort, ");
INSERT INTO bccl_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Yahudáay kabilahi gechén kort, Sahyunay kóh, ke dóst ati. ");
INSERT INTO bccl_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Wati pákén jágahi, borzagáni paymá addh kort, zeminay paymá namirán, jórhi kort. ");
INSERT INTO bccl_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Wati hezmatkárén Dáudi gechén kort o cha pasáni gwáshá dari kort, ");
INSERT INTO bccl_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","cha edá o rand, ái cha mésháni shopánkiá dar kort o wati kawm, Ákubay shopánki kort, wati mirás, Esráilay. ");
INSERT INTO bccl_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dáudá gón sápén delé áyáni shopánki kort o gón honarmandén dasté áyáni rahshón but. ");
INSERT INTO bccl_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Asápay Zabur. Oo Hodá! Kawmán tai mirás geptag, tai pákén parasteshgáhesh palit kortag o Urshalim, wayrán. ");
INSERT INTO bccl_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Tai hezmatkáráni jónesh báli morgáni warák kortag o tai wapádáráni jánay gósht, rastaráni. ");
INSERT INTO bccl_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Esháni hónesh ápay paymá sajjahén Urshalimá rétkag, kass namant ke mordagán kabr bekant. ");
INSERT INTO bccl_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Hamsáhegáni démá roswá butagén o kash o kerray mardománi kalági. ");
INSERT INTO bccl_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Oo Hodáwand! Tán kadén zahra bay? Tán abad? Tán kadén tai hasadd ásay paymá róka bit? ");
INSERT INTO bccl_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Wati gazabá hamá kawmáni sará begwár ke tará pajjáha nayárant o hamá molkáni sará ke tai námá nagerant, ");
INSERT INTO bccl_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","ke Ákubesh wártag o ér bortag o áiay molkesh wayrán kortag. ");
INSERT INTO bccl_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Gwastagén nasláni gonáhán may sará maladdh, tai rahmat zutt may sará byáyátant ke sakk wár o bazzag én. ");
INSERT INTO bccl_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Oo may rakkénókén Hodá! Márá madat kan, wati námay shán o shawkatay sawabá, pa wati námaygi márá berakkén o may gonáhán bebaksh. ");
INSERT INTO bccl_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Chiá darkawm begwashant: “Esháni Hodá kojá ent?” May chammáni démá kawm begendátant ke taw wati hezmatkáráni retkagén hónáni bérá geray. ");
INSERT INTO bccl_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Bandigáni áh o peryát pa taw sar bátant, gón wati báskay zórá hamáyán berakkén ke koshag bayagá ant. ");
INSERT INTO bccl_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Oo Hodáwand! Cha may hamsáhegán hamá sobakkiáni bérá hapt sari géshter beger ke tai sháná kortagantesh. ");
INSERT INTO bccl_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Gorhá má, tai kawm ke tai charágáhay pas én, tán abad tai shográ gerén, nasláni nasl tará satá kanén. ");
INSERT INTO bccl_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Pa sázger o washáwázáni sálárá, “Susanáni” tarzay sará. Gwáhié. Asápay Zabur. Oo Esráilay shopánk! Gósh dár, taw ke shopánkéay paymá Issopay ramagay rahshón ay. Oo Hodá! Taw ke karrubiáni nyámá bádsháhi tahtá neshtagay, wati nurá tálán kan. ");
INSERT INTO bccl_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Epráim, Benyámin o Manassiay démá, wati wák o tágatá borz kan o pa may rakkénagá byá. ");
INSERT INTO bccl_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Oo Hodá! Gón má wasshán bay wati démá gón má rozhná kan ke má berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Oo Hodáwand! Lashkaráni Hodá! Tán kadén hezhmay ásá wati kawmay dwáyáni sará gwárána bay? ");
INSERT INTO bccl_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Taw áyáná arsay nagan o arsáni sarréchén jám wárént. ");
INSERT INTO bccl_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Taw márá hamsáhegáni démá bannám kortag o dozhmen márá kalága bandant. ");
INSERT INTO bccl_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Oo lashkaráni Hodá! Gón má wasshán bay wati démá gón má rozhná kan ke má berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Taw anguray drachké cha Mesrá gwatk, taw kawm dhanná dar kortant o é drachk kesht. ");
INSERT INTO bccl_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Taw zemin pa áiá práh kort, gorhá risshagi jat o zemini porr kort. ");
INSERT INTO bccl_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Áiay sáhegá kóh póshetant o áiay sháharhán, rostagén gazz. ");
INSERT INTO bccl_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Sháharhi tán Myánzerá o tháli tán Parátay kawrá sar butant. ");
INSERT INTO bccl_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Gorhá taw chiá áiay pall prósht o dawr dát ke hamok rahgwaz áiay barán bechent? ");
INSERT INTO bccl_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Jangali hukk áiá éra barant o dashtay jánwaria warant o séra kanant. ");
INSERT INTO bccl_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Oo lashkaráni Hodá! May gwará per tarr, cha ásmáná delgósh kan o bechár, é anguray delgóshá bedár, ");
INSERT INTO bccl_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","hamé anguray ke tai rástén dastá kesht, hamé chokkay ke taw pa wat ródént o zórmand kort. ");
INSERT INTO bccl_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Dozhmenán angur goddhet o ásá dawr dát, é gón tai hakkaléá gár o gomsár bátant. ");
INSERT INTO bccl_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Tai dast hamá marday sará bát ke tai rástén némagá ent, hamá ensánay chokkay sará ke taw pa wat ródént o zórmand kort. ");
INSERT INTO bccl_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Gorhá má wati démá cha taw natarrénén, márá zend bebaksh ke tai námá begerén. ");
INSERT INTO bccl_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Oo Hodáwand, lashkaráni Hodá! Gón má wasshán bay, wati démá gón má rozhná kan ke má berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Pa sázger o washáwázáni sálárá. “Gittitay” tarzay sará. Asápay Zabur. Hodáyá pa shádehi benázénét ke may zór o wák ent, pa Ákubay Hodáyá shádmániay kukkárá borz kanét. ");
INSERT INTO bccl_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Sáz o tamburagá bongéj kanét, washtawárén chang o soródán. ");
INSERT INTO bccl_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Máhay nóká, gwarándhay kánthay tawárá borz kanét, máhay chárdahá, may pákén aidá. ");
INSERT INTO bccl_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","É pa Esráilá hokmé, rahbandé cha Ákubay Hodáay némagá. ");
INSERT INTO bccl_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Wahdé Mesray helápá dar átk kánuné pa Issopá eshti. Man eshkot, nááshnáén zobánéá gwasht: ");
INSERT INTO bccl_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Báron cha áiay kópagá dur kort o dast cha gránén saptá ázát kortant.” ");
INSERT INTO bccl_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Taw sakkiáni sáhatán peryát kort o man tará rakként, man grandán andém atán o tará passaw dát, Meribáay ápáni kerrá tará chakkáseton. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Oo mani kawm! Beshkon ke tará dháha dayán, Oo Esráil! Drégatá taw mani habar gósh bedáshtén. ");
INSERT INTO bccl_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Shomay nyámá darámadén hodáé mabát o bigánagén hodáéay démá sará jahl makanét. ");
INSERT INTO bccl_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Man Hodáwand án, tai Hodá ke tará cha Mesrá dar kort o áwort. Wati dapá sarjamá pach kan, ke man porria kanán. ");
INSERT INTO bccl_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Bale kawmá mani habar gósh nadásht o Esráil mani parmánbardár nabut. ");
INSERT INTO bccl_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Gorhá man á yalah dátant ke wati sengén deláni randgiriá bekanant, wati jenday ráh o hayáláni. ");
INSERT INTO bccl_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Drégatá mani kawmá mani habar gósh bedáshtén o Esráil, mani ráhá beshotén. ");
INSERT INTO bccl_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Á wahdá man damáná áyáni dozhmen prósh dátagatant o mani dast áyáni dozhmenáni helápá chest butagat. ");
INSERT INTO bccl_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Hamá ke cha Hodáwandá naprata kanant, dotal o sarjahl butagatant, tán abad anchosh butagat. ");
INSERT INTO bccl_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Bale tará gehterén gandomay warákon dátagat o tará cha talárá dar kortagén bénagá séron kortagat.” ");
INSERT INTO bccl_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Asápay Zabur. Hodá, wati Hodái bárgáhá barjam ent, “hodáyáni” diwáná dádrasia kant. ");
INSERT INTO bccl_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Tán kadén pa náensápi shawra borrét? Tán kadén badkáráni badalá bét? Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Nezór o chórhawáni dadrasiá bekanét o garib o setam distagénáni hakká begerét. ");
INSERT INTO bccl_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Nézgár o hájatmandán berakkénét o cha badkáráni dastá ázát kanét. ");
INSERT INTO bccl_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","É “hodá” heccha nazánant o sarpada nabant, taháriá sargardán ant o zeminay sajjahén bonyád larzagá ant. ");
INSERT INTO bccl_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Gwashton: “Shomá ‘hodá’ ét o shomá sajjahén, borzén arshay Hodáay chokk ét, ");
INSERT INTO bccl_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Bale mardománi paymá merét o shahzádagáni paymá sarshakuna bét.” ");
INSERT INTO bccl_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Oo Hodá! Jáh jan o zeminay dadrasiá bekan, ke sajjahén kawm tai mirás ant. ");
INSERT INTO bccl_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Asápay Zabur. Sawté. Oo Hodá! Bétawár mabay, hámósh mabay o hoshká manend, oo Hodá! ");
INSERT INTO bccl_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Bechár ke tai dozhmen che paymá gorrant o cha taw naprat kanókáni sar chón borz ent. ");
INSERT INTO bccl_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Tai kawmay helápá pa cháláki pandala sázant o tai gránkadrénáni helápá shawr o saláha kanant. ");
INSERT INTO bccl_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Gwashant: “Byáét gár o gomsáresha kanén ke kawmé mamánant o Esráilay nám pa yátéá ham pasht makapit.” ");
INSERT INTO bccl_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Pa hamdeli shawresh kortag o tai helápá ahdé bastagesh. ");
INSERT INTO bccl_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Edumi o Esmáili, Muábi o Hágári, ");
INSERT INTO bccl_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gébáli, Ammuni o Amáliki, Pilisti o Suray nendók, ");
INSERT INTO bccl_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Áshuri ham gón áyán hamráh ant o pa Lutay chokkán báské butagant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Gón áyán hamá paymá bekan ke taw gón Midyáná kort, gón Siserá o Yábiná, Kishunay kawray kerrá, ");
INSERT INTO bccl_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","ke Endórá tabáh butant o zeminay kad o samát butant. ");
INSERT INTO bccl_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Esháni sardárán Óréb o Zehébay paymá kan, shahzádagánesh Zebah o Zalmunnáay dhawlá, ");
INSERT INTO bccl_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","ke gwashtagatesh: “Byáét Hodáay charágáhán pa zóra gerén.” ");
INSERT INTO bccl_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Oo mani Hodá! Eshán danzéay paymá bál day, chó ke paláré, gwátay démá. ");
INSERT INTO bccl_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Anchosh ke ás jangalá sóchit o kóhán mána dárit, ");
INSERT INTO bccl_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","gón wati tuppánán randáesh kap o gón syahgwátán betorsénesh, ");
INSERT INTO bccl_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","démáesh cha sharmá syáh kan tánke tai námay shóházá bebant, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Sharmsár bát o abadi torséá kapátant, roswá bát o bemerátant. ");
INSERT INTO bccl_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Bell bezánant ke tai nám Hodáwand ent o tahná taw, oo borzén arshay Hodá, sajjahén zeminay sará hákemia kanay. ");
INSERT INTO bccl_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. “Gittitay” tarzay sará. Oo lashkaráni Hodá! Tai bárgáh chón dóstnák ent. ");
INSERT INTO bccl_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Mani arwáh pa Hodáwanday parasteshgáhay péshjáhán shaydá o hodók ent, mani del o ján pa zendagén Hodáyá pa shádehi kukkára kant. ");
INSERT INTO bccl_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Jengolá ham pa wat lógé dar gétk o pistáná pa wat kodóhé ke wati chureg o chippokán ódá beródénit, tai korbánjáhay nazziká, oo lashkaráni Hodáwand, mani bádsháh o mani Hodá! ");
INSERT INTO bccl_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Bahtáwar ant hamá ke tai bárgáhá jahmenend ant, á modám tará názénant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Chón bahtáwar ant hamá ke wák o zóresh cha tai némagá ent o delesh tai ráhán ent. ");
INSERT INTO bccl_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Á, wahdé cha arsáni daragá gwazant, daragá cha chammagá porra kanant o tákchandhay mósomay hawr ham áiá rahmata póshénit. ");
INSERT INTO bccl_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Cha mohrá mohrter bayána bant tán hamá wahdá ke Sahyuná Hodáay bárgáhá rasant. ");
INSERT INTO bccl_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Oo Hodáwand, lashkaráni Hodá! Mani dwáyá gósh dár, beshkon, oo Ákubay Hodá! Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","May bádsháhá delgósh kan, oo Hodá! Wati rógen per moshtagéná delgósh kan. ");
INSERT INTO bccl_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Tai bárgáhay yak róché gehter ent cha dega jágahéay hazárán róchá, cha badkáráni tambuáni tahá árámén zendéay gwázenagá maná wati Hodáay dargáhay dapá óshtag dóstera bit, ");
INSERT INTO bccl_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","ke Hodáwandén Hodá róch o esparé, Hodáwand rahmata bakshit o ezzata dant. Hamá ke zendá pa bémayária gwázénit, Hodáwand sharrén chizzán cha áiá dura nadárit. ");
INSERT INTO bccl_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Oo lashkaráni Hodáwand! Bahtáwar ent hamá ke tai sará tawkala kant. ");
INSERT INTO bccl_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. Oo Hodáwand! Taw wati sardhagárá rahmat gwart o Ákubay gwastagén washbahti padá per tarrént. ");
INSERT INTO bccl_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Taw wati kawmay mayárbári bakshetant o áyáni sajjahén gonáh póshetant. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Taw wati sajjahén gazab poshtá dawr dát o wati hezhmay ás tóst. ");
INSERT INTO bccl_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Oo may rakkénókén Hodá! Gón má wasshán bay o wati gazabá cha má dur kan. ");
INSERT INTO bccl_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Tán abad gón má zahra bay? Wati hezhmá nasláni nasl drájkassha kanay? ");
INSERT INTO bccl_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Márá padá zenda nabakshay ke tai kawm tai bárgáhá shádehi bekant? ");
INSERT INTO bccl_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Oo Hodáwand! Wati mehrá márá pésh bedár o márá hamá rakkénagá bebaksh ke cha tai némagá ent. ");
INSERT INTO bccl_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Har chizz ke Hodáwandén Hodá gwashit, man gósha dárán, chiá ke pa wati kawmá émeniay kawlá dant, pa wati wapádárán, chó mabit ke á ahmakiay ráhá per betarrant. ");
INSERT INTO bccl_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Béshakk, á mardománi rakkénag nazzik ent ke cha Hodáyá torsant, tán may sardhagár cha áiay shán o shawkatá sarréch bebit. ");
INSERT INTO bccl_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Mehr o wapádári yakdegará dochára kapant, adl o émeni yakdomiá chokkant. ");
INSERT INTO bccl_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Wapádári cha zeminá rodit o adl cha ásmáná jahláda chárit. ");
INSERT INTO bccl_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Béshakk, Hodáwand nékén chizza bakshit o may zemin áiay bar o samará kárit. ");
INSERT INTO bccl_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Adl, áiay démá rawána bit o pa áiay gámán ráhé tayára kant. ");
INSERT INTO bccl_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Dáuday dwá. Oo Hodáwand! Wati delgóshá gón man kan o maná passaw day, ke garib o mohtájé án. ");
INSERT INTO bccl_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Mani zenday negahpániá bekan ke tai dóstdár án, wati hezmatkárá berakkén ke tai sará tawkala kant. ");
INSERT INTO bccl_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Oo Hodáwand! Mani sará rahm kan, ke sajjahén róchá tará tawára kanán. ");
INSERT INTO bccl_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Wati hezmatkáray delá shádmán kan, oo Hodáwand, ke man cha taw dwá lóthán. ");
INSERT INTO bccl_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Taw, oo Hodáwand, nék o bakshendah ay o pa áyán cha mehrá sarréch ay ke gón taw peryáta kanant. ");
INSERT INTO bccl_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Oo Hodáwand! Mani dwáyán gósh dár, mani peryát o zárián delgósh kan. ");
INSERT INTO bccl_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Sakkiáni róchá tará tawára kanán, ke taw passawa dayay. ");
INSERT INTO bccl_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Oo Hodáwand! Hodáyáni nyámá kass tai mattha nabit o tai kár bématth ant. ");
INSERT INTO bccl_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Oo Hodáwand! Tai jórh kortagén sajjahén kawma káyant o tará sojdaha kanant, tai námá shán o shawkata dayant, ");
INSERT INTO bccl_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","ke taw mazan ay o ajabén kára kanay, Hodá tahná taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Wati ráhá maná sój day, oo Hodáwand, ke tai rástén ráhá berawán, mani delá sarjamá gón wat kan ke cha tai námá betorsán. ");
INSERT INTO bccl_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Gón tamánén delé tai shográ gerán, oo Hodáwand, mani Hodá! Tai námá tán abad shán o shawkata dayán ");
INSERT INTO bccl_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","ke pa man tai mehr sakk mazan ent, taw maná cha johlánkián rakkéntag, cha mordagáni jaháná. ");
INSERT INTO bccl_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Oo Hodá! Gorunákén mardom mani helápá pád átkagant, zórákáni rombé mani koshagay johdá ent o tará hech mána nayárit. ");
INSERT INTO bccl_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Bale taw, oo Hodáwand, rahm kanók o mehrabánén Hodáé ay, hezhm geragá déra kanay o mehr o wapáyá sarréch ay. ");
INSERT INTO bccl_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Démá gón man tarrén o mani sará rahm kan, wati hezmatkárá zór o wák bebaksh o wati móleday chokká berakkén. ");
INSERT INTO bccl_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Maná wati rahmatáni neshánié beday, tán hamá ke gón man naprat kanant begendant o sharmendag bebant, chiá ke taw, oo Hodáwand, maná madat kortag o tasallá dátag. ");
INSERT INTO bccl_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Kórahay chokkáni Zabur. Sawté. Áiá, pákén kóhay sará shahré addh kort. ");
INSERT INTO bccl_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Hodáwandá Sahyunay darwázag dóster ant cha á dega hamá sajjahén jágahán ke Ákub jahmenend butag. ");
INSERT INTO bccl_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Oo Hodáay shahr! Tai bárawá porshánén habar kanaga bit. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Mesr o Bábelá gón hamáyán hór hesába kárán ke maná zánant, Pilistiah o Surá ham, gón Kushá hawár. Esháni bárawá gwashaga bit: “É hamódá pédá butag”. ");
INSERT INTO bccl_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Sahyunay bárawá gwashaga bit: “É mardom o á mardom hamódá pédá butagant, borzén arshay Hodá wat Urshalimá pádára kant.” ");
INSERT INTO bccl_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Wahdé Hodáwand kawmáni námán nebeshtaha kant, nebisit: “É hamódá pédá butag.” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Á ke sawta janant o á ke nácha kanant gwashant: “Mani sajjahén chammag cha taw bojant.” ");
INSERT INTO bccl_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. “Mahallat Léhanutay” tarzay sará. Hémán Ezráhiay shayri gwashtánk. Sawté. Oo Hodáwand! Oo mani rakkénókén Hodá! Shap o róch tai bárgáhá dwá o peryáta kanán. ");
INSERT INTO bccl_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Mani dwá tai dargáhá berasát, wati delgóshá gón mani peryátá kan. ");
INSERT INTO bccl_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Man janjálán kaptagán o mani zend pa marká sar butag. ");
INSERT INTO bccl_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Hamá mardománi paymá hesáb áraga bán ke johlén kandhá kaptagant, anchén mardoméay paymá ke nezór o nátwán ent. ");
INSERT INTO bccl_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Mordagáni nyámá yalah dayag butagán, chó mordagéá ke kabrá waptag, ke taw áyáni yátá naay o cha tai dastá jetá butagant. ");
INSERT INTO bccl_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Taw maná johlterén kandhá dawr dátag, tahárén johlánkiá. ");
INSERT INTO bccl_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Tai hezhm mani chakká kaptag, chawlán maná mán patátag. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Taw mani hamdelén sangat cha man dur bortag o cha man bézár kortagant. Bandig án o dar átka nakanán. ");
INSERT INTO bccl_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Mani chamm cha andóhá tahár butagant. Oo Hodáwand! Har róch tará tawára kanán o dastán pa taw shahárán. ");
INSERT INTO bccl_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Wati ajabén kárán mordagán pésha dáray? Mordagáni arwáh páda káyant o tará satá kanant? Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Mordag, kabrá tai mehray járá janant? Mordagáni jaháná tai wapádáriay kessahána kárant? ");
INSERT INTO bccl_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Taháriá, tai ajabén kár zánaga bant o tai adl, shamóshkáriay molká? ");
INSERT INTO bccl_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Bale man gón taw madatay peryátá kanán, oo Hodáwand! Hamok sabáhá mani dwá tai bárgáhá rasant. ");
INSERT INTO bccl_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Oo Hodáwand! Chiá maná yalaha kanay o wati démá cha man chéra dayay? ");
INSERT INTO bccl_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Cha warnáiá sakkiáni ámách o markig butagán, tai torsá maná bazzag kortag o béwas án. ");
INSERT INTO bccl_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Tai hezhmá maná patátag o tai bimmá maná próshtag. ");
INSERT INTO bccl_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Sajjahén róchá ápay paymá maná chapp o chágerdá geptag o cha har némagá angerresh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Taw mani dóst o sangat cha man dur kortagant, tahná tahári ent ke mani hamráh ent. ");
INSERT INTO bccl_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Itán Ezráhiay shayri gwashtánk. Hodáwanday mehrá tán abada názénán cha wati zobáná, tai wapádáriay kessahá sajjahén naslán sara kanán. ");
INSERT INTO bccl_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Man gwasht ke “tai mehr abadmán ent o taw wati wapádári, ásmáná káhem kortag.” ");
INSERT INTO bccl_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Taw gwasht: “Man gón wati gechén kortagéná ahd o karáre bastag o gón wati hezmatkár Dáudá pa sawgend kawl kortag: ");
INSERT INTO bccl_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Tai padréchá tán abad barjáha dárán o tai bádsháhi tahtá nasláni nasl.’” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Oo Hodáwand! Ásmán tai ajabén kárán satá kant o tai wapádáriá ham, pákénáni diwáná. ");
INSERT INTO bccl_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Ásmánán, kay Hodáwanay matth buta kant? Choshén ásmáni hastié hast ke Hodáwanday paymá bebit? ");
INSERT INTO bccl_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Hodáay tors ásmáni hastiáni nyámá sakk mazan ent, á cha wati chapp o chágerday sajjahénán bákamálter ent. ");
INSERT INTO bccl_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Oo Hodáwand, lashkaráni Hodá! Kay tai matth o darwar ent? Taw zórák ay, oo Hodáwand, o tai wapádáriá tará chapp o chágerd kortag. ");
INSERT INTO bccl_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Taw mastén daryáyáni sará hokmránia kanay o wahdé chawlesh chesta bant, taw éresha káray. ");
INSERT INTO bccl_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Taw Raháb, láshéay paymá drosht o gón wati zórmandén báská wati dozhmen sheng o sháng kortant. ");
INSERT INTO bccl_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Ásmán taig ent o zemin ham, jahán o eshiay tahá harché ke hast, taw addh kortagant. ");
INSERT INTO bccl_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Shomál o jonub taw addh kortagant, Tábór o Hermónay kóh tai námá názénant. ");
INSERT INTO bccl_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Tai básk zórmand ent, tai dast zóráwar ent, tai rástén dast porwák o sóbén ent. ");
INSERT INTO bccl_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Adl o ensáp tai bádsháhiay bonyád ant, mehr o wapádári tai hamráhiá, démá gám janán ant. ");
INSERT INTO bccl_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Oo Hodáwand! Bahtáwar hamá ant ke shádmániay áwázá pajjáha kárant o tai bárgáhay nurá gáma janant. ");
INSERT INTO bccl_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Sajjahén róchá tai námay sará shádehia kanant o cha tai adlá sarboland ant. ");
INSERT INTO bccl_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Chiá ke taw áyáni shán o shawkat o áyáni wák o twán ay o cha wati mehrabániá may kánthá sarperáza kanay. ");
INSERT INTO bccl_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Béshakk, may bádsháh Hodáwandayg ent, may espar Esráilay pákénay. ");
INSERT INTO bccl_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Yak wahdé taw, shobéná gón wati wapádárán habar kort o gwasht: “Man jangólé madat kortag o cha kawmá gechéni warnáé ródéntag. ");
INSERT INTO bccl_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Man wati hezmatkár, Dáud shóház kortag o wati pákén, rógen per moshtag. ");
INSERT INTO bccl_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Mani dast gón áiá góna bit o mani báski zórmanda kant. ");
INSERT INTO bccl_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Dozhmen cha áiá bája nabárt o badkár áiay sará sarzóra nabit. ");
INSERT INTO bccl_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Dozhmenán áiay démá prósha dayán o harkas ke cha áiá naprata kant, prósháni. ");
INSERT INTO bccl_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Mani mehr o wapádári áiay hamráha bant o mani námá áiay kánth borzáda bit. ");
INSERT INTO bccl_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Áiay dastá tán daryáyá sara kanán, áiay rástén dastá tán kawrán. ");
INSERT INTO bccl_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Á maná gwánka jant o gwashit: ‘Taw mani Pet ay, mani Hodá o mani nejátay talár.’ ");
INSERT INTO bccl_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Man ham áiá wati masterén chokka kanán, jahánay masterén bádsháh. ");
INSERT INTO bccl_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Wati mehrá tán abad áiay hamráha kanán o gón áiá wati ahd o karárá mohra dárán. ");
INSERT INTO bccl_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Tán abad áiay naslá barjáha dárán, áiay bádsháhiay tahtá ásmánay rócháni hesábá. ");
INSERT INTO bccl_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","“Agan áiay chokk mani Sharyatá yalah bekanant o mani parmánáni randgiriá makanant, ");
INSERT INTO bccl_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","agan mani rahbandán bepróshant o mani hokmán mamannant, ");
INSERT INTO bccl_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","áyáni gonáhán pa latth sezá dayán, náparmánián pa hayzarán, ");
INSERT INTO bccl_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","bale áiay dóst dáragá bassa nakanán o gón áiá wati kortagén kawlá napróshán. ");
INSERT INTO bccl_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Wati ahd o paymáná napróshán o á habar ke cha mani dapá dar átkag, badalia nakanán. ");
INSERT INTO bccl_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Man yak baré mán wati pákiá sawgendé wártag o gón Dáudá dróga nabandán, ");
INSERT INTO bccl_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","ke áiay nasl tán abad barjáha mánit o áiay taht mani dargáhá chó róchá abadi ent, ");
INSERT INTO bccl_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","chó máhá tán abad barjáha mánit, ke jambaráni tahá tachk o rástén sháhedé.” Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Bale annun taw wati dém tarréntag o á yalah kortag, wati rógen per moshtagénay sará hezhm geptagay. ");
INSERT INTO bccl_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Taw gón wati hezmatkárá bastagén ahd o paymán pad tarréntag o áiay táj, zeminá dawr dátag. ");
INSERT INTO bccl_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Taw áiay sajjahén diwál karótkagant o áiay mohrén kalát próshtag. ");
INSERT INTO bccl_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Harkas ke cha ráhá gwazit, áiá pol o páncha kant o á wati hamsáhegáni kalági jórh butag. ");
INSERT INTO bccl_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Taw áiay dozhmenáni rástén dast borzád bortag o sajjahén badwáh shádmán kortagant. ");
INSERT INTO bccl_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Taw áiay zahm konth kortag o jangá madat nadátag. ");
INSERT INTO bccl_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Taw áiay shán bortag o taht hákán dawr dátag. ");
INSERT INTO bccl_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Taw áiay warnáiay róch kamm kortagant o sharmendagiay kabáhéá póshéntag. Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Tán kadén, oo Hodáwand! Watá tán abad chéra dayay? Tán kadén tai hezhm chó ásá róka mánit? ");
INSERT INTO bccl_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Hayálá bekap ke mani omray róch chón kamm ant, taw bani ádam nákárén chizzé jórh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Kojám ensán ent ke marka nagendit, kay cha kabray zórá rakketa kant? Ósht... ");
INSERT INTO bccl_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Oo Hodáwand! Tai á pésarigén mehr kojá ent ke taw gón Dáudá sawgend wárt o kawl kort. ");
INSERT INTO bccl_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Oo Hodáwand! Hayálá bekap ke tai hezmatkárá chón shegána janant, sajjahén kawmáni rishkandán wati delá dárán. ");
INSERT INTO bccl_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Oo Hodáwand! Tai dozhmenán mani sará rishkand kortag o hamok gámá tai rógen per moshtagénesh kalág bastag. ");
INSERT INTO bccl_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Hodáwandá tán abad satá bát. Anchosh bát. Ámin. ");
INSERT INTO bccl_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Hodáay hezmatkár Mussáay dwá. Oo Hodáwand! Nasláni nasl taw may menendjáh butagay. ");
INSERT INTO bccl_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Cha kóháni pédá bayag o zemin o jahánay addh kanagá pésar, cha azal tán abad, Hodá taw ay. ");
INSERT INTO bccl_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ensáná padá hákay chérá baray o gwashay: “Oo ensánay chokk! Háká per tarr.” ");
INSERT INTO bccl_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Hazár sál pa taw chó gwastagén yak róchéá ent, chó shapi yak páséá. ");
INSERT INTO bccl_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Ensán wábé o chó háréá áiá rópána kanay. Sohbá chó káhá tázag ent, ");
INSERT INTO bccl_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","sabáhá rodit o sabzit, bégáhá gimmorit o hoshka tarrit. ");
INSERT INTO bccl_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Cha tai hezhmá halása bén, cha tai gazabá paréshán. ");
INSERT INTO bccl_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Taw may mayár wati démá kortagant o chérén gonáh wati bárgáhay rozhnáiá. ");
INSERT INTO bccl_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","May sajjahén zend tai hezhmay chérá gwazit o wati sálán pa nálagá halása kanén. ");
INSERT INTO bccl_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","May omray róch haptád sál ant yá hashtád sál, agan sakk zreng bebén, bale sharterén róch ham zahmat o janjálá porr ant, sakk zutta gwazant o má bála kanén. ");
INSERT INTO bccl_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Kay tai hezhmay trondiá zánt? tai gazab delá torsa nádénit. ");
INSERT INTO bccl_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Gorhá márá é zántá beday ke may rócháni hesáb kamm ent, tán may del aglmand bebit. ");
INSERT INTO bccl_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Dém pa má per tarr, oo Hodáwand! Tán kadén chosha bit? Wati hezmatkáráni sará rahm kan. ");
INSERT INTO bccl_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Bámgwáhán, márá gón wati mehrá sér kan, tánke sajjahén omrá sawt bejanén o shádehi bekanén. ");
INSERT INTO bccl_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Haminchok róchá ke taw márá azáb dátag, haminchok róchá márá shádmán kan, haminchok sálá ke sakkián dochár butagén. ");
INSERT INTO bccl_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Tai kár tai hezmatkáráni démá paddar bátant o tai mazani pa áyáni óbádagán. ");
INSERT INTO bccl_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","May Hodáwandén Hodáay mehrabáni pa má sar bát, may dastáni kárán barkat beday, haw, may dastáni kárán barkat beday. ");
INSERT INTO bccl_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Hamá ke borzén arshay Hodáay panáhgáhá neshtag, zórákay sáhegá áráma gipt. ");
INSERT INTO bccl_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Hodáwanday bárawá gwashán: “Hamá mani panáh o kalát ent, mani Hodá, ke hamáiay sará tawkala kanán.” ");
INSERT INTO bccl_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Deljam án ke hamá tará cha shekáriáni dámá rakkénit, cha koshókén wabáyán. ");
INSERT INTO bccl_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Á tará gón wati poth o bálán póshénit o áiay bánzoláni chérá panáha bay, áiay wapádári espar o diwálé. ");
INSERT INTO bccl_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Cha shapay bimmá natorsay, na cha á tirá ke róchá srapit, ");
INSERT INTO bccl_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","na cha wabáyá ke taháriá gardit, na cha á hawpá ke némróchá béránia kárit. ");
INSERT INTO bccl_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Hazárán kas tai kerrá kapit, dahán hazár tai rástén némagá, bale é tabáhi tai nazziká átka nakanant. ");
INSERT INTO bccl_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Tahná gón wati chammáni shánk dayagá badkáráni sezáyána genday. ");
INSERT INTO bccl_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Agan Hodáyá wati panáh bekanay, borzén arshay Hodáyá wati menendjáh, ");
INSERT INTO bccl_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","hech kazá tai sará sarzóra nabit o hech baláh tai gedánay nazziká nayayt. ");
INSERT INTO bccl_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Tai bárawá préshtagán hokma kant ke tai sajjahén ráhán, tai negahpániá bekanant. ");
INSERT INTO bccl_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Á tará wati dastáni delá dárant tán tai pád dhókéá malaggit. ");
INSERT INTO bccl_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Shér o máráni sará garday, rostagén shér o syahmáráni saragán pádmála kanay. ");
INSERT INTO bccl_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Hodáwanda gwashit: “Á ke maná dósta dárit áiá nejáta dayán o hamáiay posht o panáha bán ke mani námá zánt. ");
INSERT INTO bccl_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Á maná tawára kant o man passawia dayán, sakkián áiay hamráha bán, áiá nejáta dayán o ezzata bakshán. ");
INSERT INTO bccl_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Áiá cha drájén omré sérápa kanán o Hodái nejátá áiá pésha dárán.” ");
INSERT INTO bccl_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Pa Shabbatay róchá sawté. Zaburé. Hodáay satá kanag wassh ent o tai námay názénag, oo borzén arshay Hodá! ");
INSERT INTO bccl_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Bámgwáhán tai mehr o shapán tai wapádáriay járay janag, ");
INSERT INTO bccl_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","gón dahtárén tamburag o changay zémelá wassh ent. ");
INSERT INTO bccl_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Chiá ke taw, oo Hodáwand, maná gón wati dastay kárán shádmán kortag, tai tawsipá shádmániay sawta janán. ");
INSERT INTO bccl_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Oo Hodáwand! Tai kár chón mazan ant o pegr chenkadar johlánk. ");
INSERT INTO bccl_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Ahmaka nazánt o nádán sarpada nabit. ");
INSERT INTO bccl_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Harchont ke badkár chó káhá berodant o radkár besabzant, bale tán abad tabáha bant. ");
INSERT INTO bccl_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Bale taw, oo Hodáwand, tán abad borzén arshay Hodá ay. ");
INSERT INTO bccl_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Tai dozhmen, oo Hodáwand, allam gár o gomsára bant o sajjahén badkár, sheng o sháng. ");
INSERT INTO bccl_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Bale taw mani kánth, wahshién gókay kánthay paymá borz dáshtag o maná sapáén rógen per moshtag. ");
INSERT INTO bccl_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Mani chammán dozhmenáni shekast distag o góshán badkáráni sarshakuniay habar eshkotag. ");
INSERT INTO bccl_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Pahrézkár macchay paymá sabzant o Lobnánay gazzáni paymá rodant. ");
INSERT INTO bccl_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Á Hodáwanday lógá keshag butagant o may Hodáay bárgáhá sabzant. ");
INSERT INTO bccl_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","15","Piriá ham bar o samara dayant o pa é járay janagá tarr o tázag o sabza mánant ke Hodáwand rást o ádel ent, hamá mani talár ent o áiá hech náensápi o badi mán nést. ");
INSERT INTO bccl_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Hodáwand bádsháhia kant áiá watá pa shán o shawkat árástag, Hodáwand porshawkat ent o zór o wáká selahband. Donyá mohr óshtátag o nalarzit. ");
INSERT INTO bccl_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Tai bádsháhi taht cha azal barjam ent o taw cha azal hastay. ");
INSERT INTO bccl_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Oo Hodáwand! Kawr chest butagant, kawrán wati tawár chest kortag, kawrán wati gorragáni tawár chest kortag. ");
INSERT INTO bccl_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Hodáwand cha mazanén ápáni tawárán, cha daryáay chawláni proshagá mazanshánter ent, borzén arshá. ");
INSERT INTO bccl_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Oo Hodáwand! Tai hokm modám barjáha mánant, tai bádsháhi pák o palgár ent, modám, tán abad. ");
INSERT INTO bccl_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Oo bérgirén Hodá! Oo Hodáwand! Oo bérgirén Hodá! Wati shán o shawkatá záher kan. ");
INSERT INTO bccl_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Pád á, oo zeminay dádras! Porkebr o gorunákán sezá day. ");
INSERT INTO bccl_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Tán kadén, oo Hodáwand! Badkár tán kadén sarzór bebant? ");
INSERT INTO bccl_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","É mardom gón kebré habara kanant, sajjahén badkár batháka janant. ");
INSERT INTO bccl_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Oo Hodáwand! Tai kawmá pádmála kanant o tai mirásá ázára dayant. ");
INSERT INTO bccl_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Janózám o darámadán koshant o chórhawán haláka kanant. ");
INSERT INTO bccl_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Gwashant: “Hodáwanda nagendit, Ákubay Hodá sarpada nabit”. ");
INSERT INTO bccl_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Sarpad bét, oo kawmay názántán! Oo jáhelán! Kadén ákela bét? ");
INSERT INTO bccl_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Á ke góshi addh kortag, naeshkont? O á ke chammi addh kortag, nagendit? ");
INSERT INTO bccl_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Á kas ke kawmán sezá dant, áyán adaba nakant? O á kas ke bani ádamá zánta bakshit, watá zánt o zánagi nést? ");
INSERT INTO bccl_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Hodáwand ensánay sajjahén pegrána zánt, á zánt ke náhudag o nákár ant. ");
INSERT INTO bccl_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Oo Hodáwand! Bahtáwar ent hamá ke taw áiá adaba kanay, hamá ke taw gón wati Sharyatá áiá tálima dayay. ");
INSERT INTO bccl_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Taw áiá cha sakkén róchána rakkénay, tán hamá wahdá ke pa badkárán kallé kóchag bebit. ");
INSERT INTO bccl_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Chiá ke Hodáwand wati kawmá yalaha nakant o wati mirásá dawra nadant. ");
INSERT INTO bccl_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Dádrasi padá pa ensápa bit, sajjahén nékdel ensápay randgiriá kanant. ");
INSERT INTO bccl_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Kay ent ke pa manigi badkáráni démá pád byayt? Kay ent ke pa manigi radkáráni démá bóshtit? ");
INSERT INTO bccl_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Agan Hodáwand mani komak mabutén, man zutt markay bétawariá bokketagatán. ");
INSERT INTO bccl_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Wahdé gwashton: “Mani pád thagalagá ent”, tai mehrá, oo Hodáwand, maná cha kapagá dásht. ");
INSERT INTO bccl_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Wahdé sargardána bán, tai dátagén delbaddhi maná shádmána kant. ");
INSERT INTO bccl_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Choshén béensápén hákemé gón taw yak o tepák buta kant ke gón wati hokm o kánunán náensápia kárit? ");
INSERT INTO bccl_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Áyáni thóli pahrézkáráni helápá hamdast o hamkára bant o bégonáhán markay sezá dayant. ");
INSERT INTO bccl_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Bale Hodáwand mani kalát ent, mani Hodá, mani talár, mani panáhgáh. ");
INSERT INTO bccl_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Hodá, áyáni gonáhán hamáyáni jenday sará pera tarrénit o áyán, áyáni jenday badén káráni tahá gár o gomsára kant. Haw, may Hodáwand áyán gár o tabáha kant. ");
INSERT INTO bccl_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Byáét Hodáwandá pa galé názénén, pa wati nejátay talárá pa shádehi kukkára kanén. ");
INSERT INTO bccl_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Byáét pa shogrgozári áiay bárgáhá rawén, pa shádehi kukkára kanén, sawta janén o áiá satá kanén, ");
INSERT INTO bccl_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","ke Hodáwand mazanshánén Hodá ent, sajjahén “hodáyáni” masterén bádsháh. ");
INSERT INTO bccl_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Zeminay johli hamáiay dastá ant o kóháni borzi ham hamáiayg ant. ");
INSERT INTO bccl_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Daryá Hodáwandayg ent ke wat addhi kortag, hoshkén zemin ham hamáiay dastán jórh kortag. ");
INSERT INTO bccl_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Byáét, sará jahla kanén o sojdaha kanén, wati addh kanókén Hodáwanday bárgáhá kóndhána kapén, ");
INSERT INTO bccl_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","ke hamá may Hodá ent o má, áiay charágáhay mardom, hamáiay dastay ramag én. Drégatá shomá maróchi áiay tawár beshkotén: ");
INSERT INTO bccl_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Wati delán á paymá sarkash makanét ke kawmá Meribáyá kort, ke kawmá á róchi Massahay gyábáná kort. ");
INSERT INTO bccl_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Ódá shomay pirénán maná chakkáset o ázmáesh kort, bell ke mani kortagén káresh distagatant. ");
INSERT INTO bccl_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Tán chel sálá cha á naslá bézár atán, gwashton: ‘É anchén mardom ant ke delesh gomráh ant o mani ráhána nazánant,’ ");
INSERT INTO bccl_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Gorhá man wati hezhmá sawgend wárt ke ‘é hechbar mani ásudagiá sara nabant.’” ");
INSERT INTO bccl_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Pa Hodáwandá nókén sawté bejanét. Oo sajjahén zemin! Hodáwandá benázén. ");
INSERT INTO bccl_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Hodáwandá benázénét, áiay námá satá kanét. Har róch hamá nejátay járá bejanét ke cha áiay némagá ent. ");
INSERT INTO bccl_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Kawmáni nyámá áiay shán o shawkatay járá bejanét, sajjahén kawmáni nyámá áiay ajabén káráni. ");
INSERT INTO bccl_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Ke Hodáwand mazan ent o satáyáni láhek, cha sajjahén “hodáyán” bákamálter ent. ");
INSERT INTO bccl_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Kawmáni sajjahén “hodá” náudagén bot ant, bale Hodáwandá ásmán jórh kortant. ");
INSERT INTO bccl_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Ezzat o shán hamáiay chapp o chágerdá ent o kodrat o zébái áiay pákén bárgáhá. ");
INSERT INTO bccl_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Oo kawmáni kabilahán! Hodáwandá benázénét, Hodáwanday shán o kodratá benázénét. ");
INSERT INTO bccl_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Hodáwanday námay mazaniá benázénét, korbánig byárét o áiay bárgáhá byáét. ");
INSERT INTO bccl_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Cha Hodáwanday pákiay zébáiá, áiay démá kóndhán bekapét. Oo sajjahén zemin! Áiay dargáhá belarz. ");
INSERT INTO bccl_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Sajjahén kawmáni nyámá begwashét: “Hodáwand bádsháh ent.” Jahán pa mohkami jórh kanag butag o nasorit, á, kawmáni dadrasiá pa ensápa kant. ");
INSERT INTO bccl_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Ásmán shádehi bekanát o zemin gal bát, daryá o harché ke daryáyá mán, pa borztawári áiá benázénátant. ");
INSERT INTO bccl_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Dhagár o harché ke dhagárá hast gal bátant, jangalay sajjahén drachk pa shádmáni áiá benázénátant. ");
INSERT INTO bccl_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Hodáwandá benázénátant, chiá ke á kayt, haw, pa zeminay dadrasiá kayt. Jahánay dadrasiá pa adl o ensápa kant o kawmáni dadrasiá wati rásti o tachkiay hesábá. ");
INSERT INTO bccl_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Hodáwand bádsháhia kant, zemin shádehi bekanát o sajjahén tayábi sardhagár gal bátant. ");
INSERT INTO bccl_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Jambar o tahári áiay chapp o chágerdá ant, adl o ensáp, áiay tahtay bonhesht o bonyád ant. ");
INSERT INTO bccl_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Ás áiay démá rawán ent o cha har némagá áiay dozhmenán éra bárt. ");
INSERT INTO bccl_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Áiay grók jaháná róshná kant, zemina gendit o larzit. ");
INSERT INTO bccl_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Hodáwanday démá kóh chó mómá ápa bant, sajjahén jahánay Hodáwanday démá. ");
INSERT INTO bccl_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Ásmán áiay adlay járá janant o sajjahén kawm áiay shán o shawkatá gendant. ");
INSERT INTO bccl_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Á sajjahén mardom sharmsára bant ke bot sojdaha kanant, hamá ke náhudagén botáni poshtá pahra bandant. Oo sajjahén “hodáyán”! Áiá sojdah kanét. ");
INSERT INTO bccl_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Sahyun eshkont o shádehia kant o Yahudiahay jenek gal ant cha tai dadrasiá, oo Hodáwand! ");
INSERT INTO bccl_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Chiá ke taw, oo borzén arshay Hodáwand, sajjahén zeminay sará mazanshán ay, taw sajjahén “hodáyáni” sará báládast ay. ");
INSERT INTO bccl_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Shomá ke Hodáwandá dósta dárét, cha badiá naprat kanét, chiá ke á Hodádóstáni zenday negahpán ent o áyán cha badkáráni dastá nejáta dant. ");
INSERT INTO bccl_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Nur pa pahrézkárán keshaga bit o shádehi pa nékdelán. ");
INSERT INTO bccl_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Oo pahrézkárán! Hodáwanday bárgáhá shádehi kanét o áiay pákén námá benázénét. ");
INSERT INTO bccl_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Zaburé. Pa Hodáwandá nókén sawté bejanét, ke ajabén kári kortag, áiay rástén dast o pákén báská sób o pérózi katthetag. ");
INSERT INTO bccl_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Hodáwandá hamá neját pésh dáshtag ke cha áiay némagá ent, wati adli kawmáni chammán paddar kortag. ");
INSERT INTO bccl_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Áiá pa Esráilay óbádagán wati mehr o wapa yátá áwortag, zeminay sajjahén goddhi hadd o simsarán, may Hodáay dátagén neját distag. ");
INSERT INTO bccl_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Oo sajjahén zemin! Pa Hodáwandá shádmániay kukkárá borz kan. Kukkár kanét, pa shádehi sawt bejanét, benázénét. ");
INSERT INTO bccl_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Pa Hodáwandá chang o sáz bejanét, gón sázá sawt bejanét. ");
INSERT INTO bccl_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Gón sorná o gwarándhay kánthá bádsháhén Hodáwanday bárgáhá, shádehiay kukkárá chest kanét. ");
INSERT INTO bccl_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Daryá o daryáay tahay sajjahén chizz grandátant, jahán o áiay sajjahén jahmenend. ");
INSERT INTO bccl_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Kawr cháp bejanátant o kóh pa shádmáni sawt, ");
INSERT INTO bccl_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Hodáwanday bárgáhá sawt bejanátant, ke á pa zeminay dadrasiá kayt. Á jaháná pa adl dádrasia kant o kawmán pa ensáp. ");
INSERT INTO bccl_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Hodáwand bádsháhia kant, kawm belarzátant, á, karrubiáni nyámá, wati bádsháhi tahtá neshtag, zemin belarzát. ");
INSERT INTO bccl_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Sahyuná, Hodáwand mazan ent, borzén arshay Hodá, sajjahén kawmáni sará hákem. ");
INSERT INTO bccl_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Tai mazan o bákamálén námá satá kanátant, Hodáwand pák ent. ");
INSERT INTO bccl_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Bádsháh zóráwar ent, adli dósta bit. Taw, oo Hodá, ensáp barjáh dáshtag, sajjahén Esráilá taw hamá kár kortag ke pa adl o ensáp ant. ");
INSERT INTO bccl_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","May Hodáwandén Hodáyá shán o shawkat dayét o áiay pádáni padagay démá parastesh kanét, ke á pák ent. ");
INSERT INTO bccl_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Mussá o Hárun cha hamáiay dini péshwáyán atant o Samuil ham cha hamáyán at ke Hodáwanday námesh gept. Hodáwandesh tawár kort o áiá passaw dátant. ");
INSERT INTO bccl_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Cha jambaray sotuná gón áyán habari kort o áyán ham hamá hokm o Sharyat barjáh dásht ke dátagati. ");
INSERT INTO bccl_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Oo Hodáwand, may Hodá! Taw á passaw dátant, taw pa Esráilá pahell kanókén Hodáé atay, harchont ke áyáni gonáháni sezáet ham dát. ");
INSERT INTO bccl_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","May Hodáwandén Hodáyá shán o shawkat bedayét, áiay pákén kóhay sará áiá parastesh kanét, ke Hodáwand, may Hodá pák ent. ");
INSERT INTO bccl_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Shogrgozáriay Zaburé. Oo sajjahén zemin! Pa Hodáwandá shádmániay gwánká bejan. ");
INSERT INTO bccl_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Hodáwandá pa shádehi parastesh kanét, gón shádmániay sawtán áiay bárgáhá byáét. ");
INSERT INTO bccl_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Bezánét ke Hodáwand, Hodá ent, hamáiá márá addh kortag o má hamáiayg én, má áiay kawm, áiay charágáhay ramag én. ");
INSERT INTO bccl_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Áiay darwázagán gón shogrgozári bepotrét o áiay bárgáhá gón satá o saná. Áiay shográ begerét o áiay námá besárháét, ");
INSERT INTO bccl_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","ke Hodáwand nék ent o mehri abadmán, áiay wapádári nasláni nasl barjáha mánit.");
INSERT INTO bccl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Issá Masih, Dáud o Ebráhémay chokk ent. Áiay béh o bonyáday daptar é dhawlá ent: ");
INSERT INTO bccl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Esháke Ebráhém, Ákube Eshák, Yahudá o áiay brát ke Ákubay chokk atant. ");
INSERT INTO bccl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Páres o Zárahe Yahudá ke áyáni mátay nám Támár at. Hesrune Páres, Arame Hesrun, ");
INSERT INTO bccl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminádábe Aram, Nahshune Aminádáb, Salmune Nahshun, ");
INSERT INTO bccl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Buáze Salmun ke áiay mátay nám Raháb at, Óbayde Buáz ke mátay námi Rut at, Yassie Óbayd, ");
INSERT INTO bccl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","bádsháh Dáude Yassi. Solaymáne Dáud, ke máti pésará Uriáay lógi butagat, ");
INSERT INTO bccl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Rehobáme Solaymán, Abiáe Rehobám, Ásáe Abiá, ");
INSERT INTO bccl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Yehushápáte Ásá, Yuráme Yehushápát, Ozziáe Yurám, ");
INSERT INTO bccl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Yutáme Ozziá, Áháze Yutám, Hezekiáe Áház, ");
INSERT INTO bccl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manassie Hezekiá, Ámune Manassi, Yusiáe Ámun, ");
INSERT INTO bccl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yekuniáe Yusiá o áiay sajjahén brát, ke é wahdá Yahudi Bábelá darándhéh butant. ");
INSERT INTO bccl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Cha Bábelay darándhéhiá rand, Shiáltiále Yekuniá, Zerubábele Shiáltiál, ");
INSERT INTO bccl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abihude Zerubábel, Elyákime Abihud, Ázure Elyákim, ");
INSERT INTO bccl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Saduke Ázur, Ákime Saduk, Elihude Ákim, ");
INSERT INTO bccl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliázare Elihud, Mattáne Eliázar, Ákube Mattán, ");
INSERT INTO bccl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Issope Ákub ke Maryamay mard at. Cha Maryamá Issá pédá but ke Masih zánaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","É dhawlá, cha Ebráhémá beger tán Dáudá chárdah posht o cha Dáudá beger tán Yahudiáni Bábelay darándhéhiá dega chárdah posht o cha á darándhéhiá beger tán Issá Masihá ham chárdah posht ant. ");
INSERT INTO bccl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Issá Masihay pédáesh é dhawlá at: Issáay mát Maryam, Issopá sáng kortagat bale cha áyáni sur o árósá pésar, zántesh ke cha Hodáay Pákén Ruhá, áiay láp porr butag. ");
INSERT INTO bccl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Maryamay lógwájah Issop, rást o pahrézkárén mardomé at, nalótheti Maryamá bannám bekant, paméshká wati delá shawri kort: “Pa bétawári é sángá bepróshán.” ");
INSERT INTO bccl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","É bárawá angat pegr kanagá at ke áiay wábá anágat Hodáwanday préshtagé átk o gwashti: “Issop, oo Dáud bádsháhay chokk! Cha wati deshtár Maryamay zurag o lógá baragá mators, chiá ke áiá é lápporri, cha Pákén Ruhá rasetag. ");
INSERT INTO bccl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Á, mardénchokkéay sará chellaga bit o áiay námá Issá bekan, chiá ke á wati kawmá cha áyáni gonáhána rakkénit.” ");
INSERT INTO bccl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","É sajjahén kár paméshká chosh butant tán Hodáwanday hamá habar rást o paddar bebant ke áiá cha nabiay zobáná gwashtagant: ");
INSERT INTO bccl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Neshtagén janénchokkéay láp porra bit o mardénchokkéay sará chellaga bit o áiay námá Emánuil pera bandant, ke eshiay máná “Hodá gón má” ent. ");
INSERT INTO bccl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wahdé Issop cha wábá ágáh but, hamá dhawlá ke Hodáwanday préshtagá hokm dátagat, wati jani zort, ");
INSERT INTO bccl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","bale tán á wahdá ke chokk pédá nabutagat, gón áiá wapt o wábi nakort o chokkay námi Issá per bast. ");
INSERT INTO bccl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Bádsháh Hirudisay ahd o bárigá, wahdé Issá Yahudiahay damagay shahr Bayt-Lahemá pédá butagat, gorhá cha ródarátká lahtén nojumi Urshalimay shahrá átk. ");
INSERT INTO bccl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jostesh gept: “Hamá nonnok ke pa Yahudiáni bádsháhiá pédá butag, kojá ent? Má áiay estár dar áyagá distag o pa áiay parastesh kanagá átkagén.” ");
INSERT INTO bccl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Cha é habaray eshkonagá, Hirudis bádsháh o Urshalimay sajjahén mardom báz paréshán o deltaparkah butant. ");
INSERT INTO bccl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hirudisá kawmay sajjahén dini péshwá o Sharyatay zánóger lóthet o jost geptant ke “Masihay pédáesh kojá bayagi ent?” ");
INSERT INTO bccl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Áyán passaw dát: “Yahudiahay shahr Bayt-Lahemá pédá bit, chiá ke nabiay ketábá nebeshtah ent: ");
INSERT INTO bccl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Oo Yahudáay shahr Bayt-Lahem! Taw Yahudáay hákemáni nyámá kasterén naay, chiá ke cha taw yak hákemén sardáré pédá bit ke á mani kawm Bani Esráilay shopánkiá kant.’” ");
INSERT INTO bccl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Gorhá Hirudisá nojumi chérandari lóthetant o á estáray dar áyag o záher bayagay allamén wahdi jost kort ke kadén at. ");
INSERT INTO bccl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Randá áiá nojumi pa hamá nonnokay shóház o dar géjagá Bayt-Lahemá ráh dátant o gwashti: “Berawét o é chokkay bárawá sharr patth o pól bekanét, wahdé shomá dar gétk, maná sahig bekanét tán man ham pa áiay parastesh kanagá berawán.” ");
INSERT INTO bccl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Bádsháhay habaráni eshkonagá rand, nojumi sar geptant. Ráhá rawán, hamá estár ke áyán dar áyagá distagat, áyáni démá pésh kapán, hamá jágahay sarborá óshtát, ke nonnok ódá at. ");
INSERT INTO bccl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Cha é estáray gendagá, sakk báz washdel butant. ");
INSERT INTO bccl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lógá shotant o nonnokesh áiay mát Maryamay gwarán dist. Gorhá kóndhán kaptant o chokkesh parastesh kort, wati tohpah o thékiáni hokkah o zabáddánesh pach kortant o sohr o sóchoki o morresh pa nonnoká sawgát kortant. ");
INSERT INTO bccl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Randá, Hodáyá wábá á hozzhár kortant ke Hirudisay kerrá per matarrant. Gorhá cha dega ráhé, wati molká shotant. ");
INSERT INTO bccl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nojumiáni per tarragá rand, Hodáwanday préshtagé Issopay wábá átk o gwashti: “Chokk o chokkay mátá bezur o Mesrá betach, tán man tará nagwashán hamódá bedár, chiá ke Hirudis chokkay dar géjag o koshagá delmánag ent.” ");
INSERT INTO bccl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Gorhá, Issop anchosh ke cha wábá ágáh but, chokk o chokkay máti zort o shapi shap dém pa Mesrá shot. ");
INSERT INTO bccl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tán Hirudisay marká hamódá mantant tán Hodáwanday hamá habar rást o paddar bebit ke cha nabiay kawlá gwashag butagat: Man wati bacch cha Mesrá lóthet o áwort. ");
INSERT INTO bccl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wahdé Hirudis sahig but ke nojumián á rad dátag, báz zahr gept. Parmáni dát: “Bayt-Lahem o kerr o gwaray do sálig yá kasterén sajjahén mardénchokk koshag bebant.” Anchosh ke áiá pésará nojumi jost o pors kortagatant, hamá hesábá é wahdi gisshént. ");
INSERT INTO bccl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","É dhawlá Eremiá Nabiay Ketábá Hodáay hamá habar sarjam butant ke gwashtagati: ");
INSERT INTO bccl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Cha Rámahay shahrá kukkáré góshán kapt, mótk o zárié mazanén, Ráhilá pa wati chokkán grét, kaséay tasallái nazort, chiá ke á namantagatant. ");
INSERT INTO bccl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Hirudisay marká rand, Mesrá Hodáwanday préshtagé Issopay wábá átk. ");
INSERT INTO bccl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Préshtagá gwasht: “Pád á, chokk o chokkay mátá bezur o padá wati molk, Esráilá per betarr. Chiá ke chokkay koshagay shawr borrók mortagant.” ");
INSERT INTO bccl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Nun Issop pád átk o chokk o chokkay máti zortant o padá Esráilay molká átk. ");
INSERT INTO bccl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Bale wahdé sahig but ke Hirudisay jáhá áiay chokk ArkeláusYahudiahay damagay bádsháh ent, gorhá óday rawagi torset. Wahdé cha wábéá dháhé raseti, watá pa Jalilay damagá rasénti. ");
INSERT INTO bccl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ódá, Náserahay shahrá jahmenend but tán é paymá nabiáni habar rást o paddar bebit ke á Náseri gwashaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Á róchán, pákshódókén Yahyá átk o Yahudiahay gyábáná jári perrént: ");
INSERT INTO bccl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Cha wati gonáhán pashómán bebét, chiá ke ásmáni bádsháhi nazzik ent.” ");
INSERT INTO bccl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yahyá hamá ent ke Eshayá nabi áiay bárawá gwashit: Gyábáná, kasé gwánkajant: Hodáwanday ráhá tayár o, áiay keshká rást o tachk bekanét. ");
INSERT INTO bccl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yahyáyá cha oshteray pothán gwaptagén póshák gwará at o póstén kamarbandé lánká bastagat. Áiay ward o warák, madag o gyábáni bénag at. ");
INSERT INTO bccl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Urshalimay nendók, Yahudiahay sajjahén damagay mardom o Ordonay kawray kerr o gwaray jahmenend áiay kerrá shotant. ");
INSERT INTO bccl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Wati gonáháni pashómániesh záher kort o Yahyáyá Ordonay kawrá pákshódi dátant. ");
INSERT INTO bccl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Wahdé Yahyáyá dist ke Parisi o Saduki rombay bázén mardom pákshódi geragá áiay kerrá áyagá ant, gón áyán gwashti: “Oo syahmárzádagán! Kayá shomárá dháh dátag ke cha Hodáay áyókén kahr o gazabá rakketa kanét?! ");
INSERT INTO bccl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Anchén kár bekanét cha áyán paddar bebit ke shomá pa del cha wati gonáhán pashómán butagét. ");
INSERT INTO bccl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Cha wati delá é habará dar bekanét ke ‘má Ebráhémay nasl o óbádag én.’ Man shomárá gwashán ke Hodá cha é seng o dhókán ham, pa Ebráhémá chokk o óbádag pédá korta kant. ");
INSERT INTO bccl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nun tapar tayár ent ke drachkán cha boná begoddhit o har drachké ke sharrén bara nayárit, goddhag o ásá dawr dayaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Man pa shomay gonáháni pashómániá, shomárá gón ápá pákshódia dayán, bale hamá ke cha man o rand áyagi ent, cha man zórákter ent o man áiay kawsháni dast geragay láhek ham naán. Á shomárá gón Pákén Ruh o ásá pákshódia dant. ");
INSERT INTO bccl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Áiá cha bucch o pogán dánay jetá kanag o gisshénagá, hanshóné dastá ent. Jóháná pák o sallaha kant o dánán ambárá éra kant, bale pog o palárán anchosha sóchit ke ásesh hechbara namerit.” ");
INSERT INTO bccl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Gorhá Issá cha Jalilay damagá dar átk o Yahyáay dastá pákshódi geragá Ordonay kawrá shot. ");
INSERT INTO bccl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Bale Yahyáyá johd kort áiá pa é kárá maylit o gwashti: “Báyad man cha tai dastá pákshódi begerán, taw chón mani gwará káay?” ");
INSERT INTO bccl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Issáyá gwasht: “Annun bell ke anchosh bebit, é paymá Hodáay razáyá sarjama kanén.” Gorhá áiá mannet o Issái pákshódi dát. ");
INSERT INTO bccl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wahdé Issáyá pákshódi gept o cha ápá dar átk, anágat ásmánay dap pach but o Hodáay Pákén Ruhi dist ke kapótéay dróshomá átk o áiay sará ér nesht. ");
INSERT INTO bccl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Cha ásmáná tawáré átk: “É mani dóstén Bacch ent o man cha eshiá báz wassh o razá án.” ");
INSERT INTO bccl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Randá, cha Pákén Ruhay rahshóniá Issá gyábáná shot tán Shaytán áiá bechakkásit. ");
INSERT INTO bccl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chel shap o chel róch róchag dáragá rand Issá shodig but. ");
INSERT INTO bccl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Gorhá Shaytán pa áiay chakkásagá átk o gwashti: “Agan taw Hodáay Chokk ay, é sengán begwash nagan bebant.” ");
INSERT INTO bccl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Issáyá passaw dát: “Pákén Ketábá nebisag butag: ‘Mardom tahná pa nán zendaga nabit, cha Hodáay zobánay sajjahén habaráni mannagá zendaga bit.’” ");
INSERT INTO bccl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Padá Shaytáná Issá pákén shahrá bort o mazanén parasteshgáhay diwálay borzterén jágahá óshtárént o ");
INSERT INTO bccl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","gwashti: “Agan taw Hodáay Chokk ay gorhá watá cha edá jahlád dawr beday chiá ke nebisag butag: Hodá pa tai negahpániá wati préshtagán hokma kant o á, tará wati dastáni delá dárant tán tai pád dhókéá malaggit.” ");
INSERT INTO bccl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Issáyá gwasht: “Haw, bale chosh ham nebisag butag: Wati Hodáwandén Hodáyá machakkás o ázmáesh makan.” ");
INSERT INTO bccl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nun Shaytáná yak sakkén borzén kóhéay sará bort o cha ódá donyáay sajjahén bádsháhi o áyáni shán o shawkati pésh dáshtant o ");
INSERT INTO bccl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","gwashti: “Agan taw mani démá kóndhán bekapay o maná parastesh bekanay, man é sajjahénán tará dayán.” ");
INSERT INTO bccl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Gorhá Issáyá gwasht: “Oo Shaytán! Cha mani démá gom bay! Pákén Ketábá nebisag butag: Wati Hodáwandén Hodáyá parastesh bekan o tahná hamáiay hezmatá bekan.” ");
INSERT INTO bccl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nun Shaytáná á yalah dát o shot. Préshtag átkant o Issáay hezmatesh kort. ");
INSERT INTO bccl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wahdé Issá sahig but ke Yahyá dazgir kanag butag, gorhá Jalilá shot. ");
INSERT INTO bccl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Náserahay shahri yalah dát o Kaparnáhumay shahrá jahmenend but. Kaparnáhum, Jalilay mazangwarmay kerrá, Zebulun o Naptáliay kabilaháni sardhagárá ent. ");
INSERT INTO bccl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Paméshká é dhawl but ke Eshayá nabiay gwashten sarjam bebit: ");
INSERT INTO bccl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zebulun o Naptáliay sardhagár, gwarmay mazanráhay sará, Ordonay kawray á dastá, Jalilay hamá hand o hankén ke darkawm jahmenend ant, ");
INSERT INTO bccl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","hamá kawmá ke zendi taháriá gwastagat, mazanén rozhnáié dist o hamá molk o dhagár ke ódá mark sáhél at, óday jahmenendáni sará rozhnáiá sar jat. ");
INSERT INTO bccl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Cha hamá wahdá, Issáyá é kolaw o paygámay rasénag bongéj kort. Gwashti: “Cha wati gonáhán pashómán bebét chiá ke ásmáni bádsháhi nazzik ent.” ");
INSERT INTO bccl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wahdé Issá Jalilay mazangwarmay lambá gám janagá at, do bráti dist, yakké Shamun at ke pannámi Petros at o domi áiay brát Andriás at. Áyáni kár máhigiri at o á wahdá pa máhigiriá wati dám o máhórán gwarmá chér géjagá atant. ");
INSERT INTO bccl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Issáyá gón áyán gwasht: “Byáét, mani randgiriá bekanét o man shomárá anchosha kanán ke máhig geragay badalá, mardománi delá shekár bekanét.” ");
INSERT INTO bccl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Áyán hamá damáná wati dám yalah dát o áiay hamráh butant. ");
INSERT INTO bccl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Wahdé kammé démá shot, dega do brát, Ákub o Yuhannái distant ke Zebdiay chokk atant. Bójigay tahá gón wati pet Zebdiá neshtagatant o wati máhórán sráchag o sharr kanagá atant. Issáyá á lóthetant. ");
INSERT INTO bccl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Áyán ham wati pet gón bójigá yalah dát o áiay hamráh butant. ");
INSERT INTO bccl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Issáyá sajjahén Jalilá tarr o garda kort. Áiá kanisaháni tahá mardom dars o sabaka dát, Hodáay bádsháhiaymestága rasént o mardom cha nájórhi o nádráhián jórh o dráha kortant. ");
INSERT INTO bccl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Sajjahén Suriahá áiay nám o tawár prosht o mardomán har dhawlén nájórh o nádráh, jenni, mergiay nádráh, lang o mondh Issáay kerrá áwortant o áiá dráha kortant. ");
INSERT INTO bccl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jalil, Dekápulis, Urshalim, Yahudiah o Ordonay kawray á dastay hand o damagáni bázén mardomé átk o Issáay hamráh but. ");
INSERT INTO bccl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Mardománi mazanén mocchiay gendagá rand, Issá kóhéay sará sar kapt. Wahdé borzagá nesht, morid ham áiay kerrá átkant. ");
INSERT INTO bccl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Gorhá é dhawlá áyáni tálim dayagá lagget: ");
INSERT INTO bccl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Bahtáwar ant hamá ke áyáni ruh wár o bazzag ent, chiá ke ásmáni bádsháhi hamáyánig ent. ");
INSERT INTO bccl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Bahtáwar ant hamá ke gamig o porsig ant, chiá ke áyán tasallá o delbaddhia rasit. ");
INSERT INTO bccl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Bahtáwar ant hamá ke narmdel o mehrabán ant, chiá ke zeminay mirás barók hamá bant. ");
INSERT INTO bccl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Bahtáwar ant hamá ke hakk o ensápay shodig o tonnig ant, chiá ke á séra bant. ");
INSERT INTO bccl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Bahtáwar ant hamá ke pa degarán rahma kanant, chiá ke áyáni sará ham rahm kanaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Bahtáwar ant hamá ke delesh pák o sáp ent, chiá ke á Hodáyá gendant. ");
INSERT INTO bccl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Bahtáwar ant hamá ke sohl o émenia kárant, chiá ke á Hodáay chokk náménaga bant. ");
INSERT INTO bccl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Bahtáwar ant hamá ke pa Hodáay ráhay geragá bohtám janag o ázár dayaga bant, chiá ke ásmáni bádsháhi hamáyánig ent. ");
INSERT INTO bccl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Bahtáwar ét shomá ke pa manigi mardom shomárá dozhmána dayant o ázára rasénant, shomay poshtá dróga bandant o bada gwashant. ");
INSERT INTO bccl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Gal o washdel bebét o shádehi bekanét, chiá ke ásmáná shomay mozz sakk báz ent. Pésarigén nabiáni sará ham é dhawlén ázáresh raséntag. ");
INSERT INTO bccl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Shomá jahánay wád ét, bale agan wáday tám berawt, gorhá chón padá wádók buta kant? Abéd cha dur réchag o mardománi pádmáliá nun dega hech kárá nayayt. ");
INSERT INTO bccl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Shomá jahánay nur o rozhn ét, shahré ke kóhéay sará ent, chér o andém buta nakant. ");
INSERT INTO bccl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Hechkas rókén cherágá tagáréay chérá éra nakant, cherágdánay sará éria kant tán áiay rozhnái pa lógay sajjahén mardomán berasit. ");
INSERT INTO bccl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Hamé dhawlá shomay rozhn, mardománi démá shahm bedant tán shomay nékén kárán begendant o shomay ásmáni Petá satá bedayant o besárháyant. ");
INSERT INTO bccl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Gomán makanét ke man pa Tawrát o nabiáni habaráni kár nabandag o nákár kanagá átkagán. Man pa áyáni kár nabandag o nákár kanagá nayátkagán, pa áyáni sarjam kanagá átkagán. ");
INSERT INTO bccl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Shomárá rásténa gwashán, zemin o ásmánay gár o bérán bayagá pésar, Sharyatay yak áb o thekké ham gára nabit tán sajjahén sarjam mabant. ");
INSERT INTO bccl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Paméshká agan kasé cha Sharyatay parmánán gwandhteréné sost begipt o kár mabandit o degarán ham anchosh dars o sabak bedant, á, ásmáni bádsháhiá kasterén zánaga bit. Bale kasé ke é parmánáni sará kára kant o degarán ham sója dant, ásmáni bádsháhiá mazan zánaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Paméshká shomárá gwashán, agan shomay pahrézkári o sharkerdi cha Parisi o Sharyatay zánógeráni kerdá géshter mabit, hechbar ásmáni bádsháhiay darwázagá poterta nakanét. ");
INSERT INTO bccl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Shomá eshkotag ke gón péshigén mardomán gwashag butag: ‘hón o kósh makan, harkas hóna kant, áiay dádrasi o dáwaria bit o mayárig kanaga bit.’ ");
INSERT INTO bccl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Bale man shomárá gwashán, harkas wati brátay sará zahra gipt, á ham hakdiwánay démá mayárig kanaga bit. Kasé ke wati brátá zá o zakat bekant, hakdiwáná mayárig kanaga bit, kasé ke wati brátá ‘hódh’ o ‘ahmaka’ gwashit, tahtarunay ásay sezáwára bit. ");
INSERT INTO bccl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Paméshká agan korbánjáhá, korbánig kanagay wahdá yát o tránagá kaptay ke tai brátá gón taw gelagé hastent, ");
INSERT INTO bccl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","wati korbánigá hamódá korbánjáhá bell o beraw pésará gón wati brátá sohl kan, gorhá byá korbánig bekan. ");
INSERT INTO bccl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Agan kaséá gón taw arh o dáwáé hast o tará hakdiwáná bárt, gorhá rasagá pésar, ráhá gón áiá wati arhá begisshén o sohl bekan. Chosh mabit káziay démá barag bebay, á tará apsaray dastá bedant o apsar tará bandijáhá bebárt o jél bekant. ");
INSERT INTO bccl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tará rásténa gwashán, tán zarráni goddhi pai o paysahá porra nakanay, cha ódá ázáta nabay. ");
INSERT INTO bccl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Shomá eshkotag ke gwashag butag: ‘zená makan’. ");
INSERT INTO bccl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Bale man shomárá gwashán, agan kasé pa badchammi o deldozzi janénéá bechárit, bezán wati delá, gón hamá janéná zenái kort. ");
INSERT INTO bccl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Paméshká agan tai rástén chamm tará dém pa gonáhá bebárt, áiá kassh o dawr beday, chiá ke cha sarjamén jánay tahtaruná kapagá pa taw sharter hamesh ent ke tai jesmay yak band o bógé cha taw jetá bebit. ");
INSERT INTO bccl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Hamé dhawlá, agan tai rástén dast tará dém pa gonáhá bebárt, gorhá áiá borr o dawr beday, chiá ke cha sarjamén jánay tahtaruná rawagá pa taw sharter esh ent ke tai jesmay yak band o bógé cha taw jetá bebit. ");
INSERT INTO bccl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“É ham gwashag butag: ‘agan kasé wati janá yalah bekant, gorhá báyad áiá taláknámahé bedant’. ");
INSERT INTO bccl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Bale man shomárá gwashán, agan janénéá zená nakortag o mard áiay sawn o talákán bedant, bezán áiay zenahkáriay sawaba bit o agan kasé hamá janózámén janéná sur o sáng bekant, gorhá bezán gón áiá zená kant. ");
INSERT INTO bccl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Shomá é ham eshkotag ke gón péshigén mardomán gwashag butag: ‘wati sawgendá maprósh, Hodáwanday démá wati sawgendá purah bekan’. ");
INSERT INTO bccl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Bale man shomárá gwashán, hechbar sawgend mawarét, na pa ásmáná, chiá ke Hodáay taht ent, ");
INSERT INTO bccl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","na pa zeminá, chiá ke Hodáay pádáni chéray padag o chárchóbah ent, na pa Urshalimá chiá ke ‘Mazanén Bádsháhay’ shahr ent. ");
INSERT INTO bccl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pa wati sará ham sawgend mawar, chiá ke saray mudáni yak tháléá syáh o espét korta nakanay. ");
INSERT INTO bccl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Paméshká ódá ke ‘haw’ gwashagi ent, begwashét ‘haw’ o ódá ke ‘enna’ gwashagi ent, begwashét ‘enna’. Cha eshiá géshter Shaytánay kár ent. ");
INSERT INTO bccl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Shomá eshkotag ke gwashag butag: ‘pa chammá chamm o pa dantáná dantán’. ");
INSERT INTO bccl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Bale man shomárá gwashán, radkárén mardománi káráni démá maóshtét, agan kaséá tai rástén gobbá shahmáté jat, domiá ham áiay némagá betarrén. ");
INSERT INTO bccl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Agan kasé pa tai jámagay kasshagá tará hakdiwáná bebárt, wati kabáhá ham áiá beday. ");
INSERT INTO bccl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Agan kasé tará pa zór o bigári hazár gámay pand janaga parmáit, do hazár gám áiay hamráhiá beraw. ");
INSERT INTO bccl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kasé ke cha taw lóthit, áiá beday o agan yakké wáma lóthit, chak o pad mabay. ");
INSERT INTO bccl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Shomá eshkotag ke gwashag butag: ‘Gón wati hamsáhegá mehr bekan o gón wati dozhmená naprat’. ");
INSERT INTO bccl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Bale man shomárá gwashán, gón wati dozhmená mehr bekanét o pa hamáyán ke shomárá ázára dayant nékén dwá belóthét, ");
INSERT INTO bccl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","tán wati ásmáni Petay chokk bebét, chiá ke á wati róchá pa nék o badána drapshénit o wati hawrá pa pahrézkár o radkárána gwárénit. ");
INSERT INTO bccl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Agan tahná gón hamá mardomán mehr kanét ke gón shomá mehra kanant, gorhá shomárá chónén mozzé rasit? Songi o máliátgir hamé dhawlá nakanant? ");
INSERT INTO bccl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Agan éwaká wati brátán drud o drahbát begwashét, gorhá cha degarán shomay sharteri chi ent? Záná, á Hodánábáwarén darkawm ham anchosha nakanant? ");
INSERT INTO bccl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Paméshká shomá báyad tamán o béayb bebét, anchosh ke shomay ásmáni Pet wati jáhá tamán o béayb ent. ");
INSERT INTO bccl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Hozzhár bét! Wati nékén kárán pa mardománi pésh dáragá makanét, chiá ke é dhawlá shomárá cha ásmáni Petay némagá hech mozzé narasit. ");
INSERT INTO bccl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wahdé chizzé hayráta kanay, gorhá jár majan o dhandhór makan. Doru o dopóstén mardom, kanisah o kuchah o damkáni tahá é dhawlá kanant tánke mardom áyán satá bekanant o besárháyant. Shomárá rásténa gwashán, mozzé ke áyán rasagi at, rasetesh. ");
INSERT INTO bccl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wahdé hayráté cha rástén dastá dayay, chappén dast sahig mabit, ");
INSERT INTO bccl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","tánke tai dátagén hayrát sarpósh o chérandari bebit. Gorhá tai ásmáni Pet, ke chérénána gendit, tai mozzá dant. ");
INSERT INTO bccl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wahdé dwá kanét, gorhá doru o dopóstén mardománi dhawlá makanét, chiá ke áyán kanisaháni tahá o chárráháni sará óshtag o dwá kanag dósta bit, tánke mardom áyán begendant. Shomárá rásténa gwashán, mozzé ke áyán rasagi at, rasetesh. ");
INSERT INTO bccl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Bale harwahd dwá kanay, wati lógá beraw, lógay dapá beband o cha wati ásmáni Petá, ke cha chammán chér o andém ent, dwá belóth, gorhá tai Pet, ke chérénána gendit, tai mozzá dant. ");
INSERT INTO bccl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Wahdé dwá kanét, gorhá darkawmén mardománi dhawlá mopt o náhudagén habarán lés o pellés makanét, á hayála kanant ke cha lés o pellésá áyáni dwá gósh dáraga bit. ");
INSERT INTO bccl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Áyáni paymá mabét, chiá ke shomay ásmáni Pet cha lóthagá pésar wata zánt ke shomárá ché garaz ent. ");
INSERT INTO bccl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Shomá é dhawlá dwá belóthét: ‘Oo may Pet, ke borzén ásmáná ay! Tai nám sharapdár bát. ");
INSERT INTO bccl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tai bádsháhi byáyát. Tai wáhag o erádah zeminay sará ham hamá dhawlá sarjam bát ke ásmáná sarjama bit. ");
INSERT INTO bccl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","May maróchigén rezk o rózigá maróchi márá beday. ");
INSERT INTO bccl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","May gonáh o radián bebaksh, anchosh ke má wati sajjahén daynkár bakshetagant. ");
INSERT INTO bccl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Márá ázmáesh o chakkásá dawr maday o cha Shaytáná berakkén.’ ");
INSERT INTO bccl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Chiá ke agan shomá mardománi gonáh o mayárán bebakshét, gorhá shomay ásmáni Pet shomay gonáh o mayárán ham bakshit, ");
INSERT INTO bccl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","bale agan shomá mardománi gonáh o mayárán mabakshét, gorhá shomay ásmáni Pet ham shomay gonáh o mayárána nabakshit. ");
INSERT INTO bccl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wahdé róchaga bét, doru o dopóstén mardománi dhawlá wati démá tábán o gamnák makanét. Á wati ruá gimmorénant o munjá kanant tán mardom bezánant róchag ant. Shomárá rásténa gwashán, mozzé ke áyán rasagi at, rasetesh. ");
INSERT INTO bccl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Bale wahdé róchaga bay, gorhá wati dém o ruá beshód o sará charp kan, ");
INSERT INTO bccl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","tánke mardom mazánant taw róchag ay, tahná tai ásmáni Pet ke chérandém ent, hamá bezánt. Á wahdi tai ásmáni Pet ke chérandaria gendit tai mozzá dant. ");
INSERT INTO bccl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“É jaháná pa wat mál o maddhi mocch makanét, ke edá áyán warók o raméza wárt o zanga gipt o dozzesha polant o barant. ");
INSERT INTO bccl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Pa wat ásmáná ganj o hazánag ambár bekanét ke ódá na áyán warók o raméza wárt, na zanga gipt o na dozza polant o barant. ");
INSERT INTO bccl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tai del hamá jáhá rawt ke mál hamódá ent. ");
INSERT INTO bccl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Chamm, jesm o jánay cherág ent. Agan tai chamm wassh o dráh ent, gorhá tai sajjahén jesm o ján rozhnága bit. ");
INSERT INTO bccl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Bale agan tai chamm nájórh ent, gorhá tai sajjahén jesm o ján tahára bit. Nun agan tai jesm o jánay rozhn wat tahárié bebit, gorhá á tahári chónén mazanén tahárié bit. ");
INSERT INTO bccl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Hechkas pa do wájahá golámi korta nakant, yá gón yakkéá dozhmenia kant o domigi dósta bit, yá gón awaligá wapádára bit o cha á degará badia kayt. Shomá yakwahd o yakjáh Hodá o zarray golámiá korta nakanét. ");
INSERT INTO bccl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Paméshká shomárá gwashán ke pa wati zendá paréshán o deltaparkah mabét ke ‘ché bwarén o ché benóshén?’, na pa wati jesm o jáná ke ‘ché bepóshén?’. Zend cha waráká o jesm o ján cha pósháká géshtera nakarzit? ");
INSERT INTO bccl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ásmánay báli morgán bechárét, na keshant o na ronant o na ambára kanant, bale angat shomay ásmáni Pet áyán warák o róziga dant. Shomay arzesh o kimmat cha áyán géshter naent? ");
INSERT INTO bccl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kay gón pegr o hayáláni zórá wati zenday róchán yak sáhaté ham gésh korta kant? ");
INSERT INTO bccl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Pa pocch o pósháká chiá paréshán ét? Gyábánay gol o polláni némagá delgósh kanét, chón rost o rodóma kanant. Na zahmaté kasshant o na résant o gwapant, ");
INSERT INTO bccl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","bale shomárá gwashán ke Solaymán bádsháhá gón wati mazanén shán o shawkatá é polláni hamdróshomén póshák gwará nabutag. ");
INSERT INTO bccl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Oo kambáwarán! Wahdé Hodá gyábánay káhán é dhawlá zébá o brahdára kant ke maróchi hastant o bándá taruná sóchaga bant, gorhá shomárá che paymá sharterén pósháka nadant? ");
INSERT INTO bccl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Paméshká paréshán o deltaparkah mabét o magwashét ke ‘bárén ché bwarén o ché benóshén?’ yá ‘ché bepóshén?’. ");
INSERT INTO bccl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Donyáay sajjahén Hodánábáwarén mardom é chizzáni randá tachant, bale shomay ásmáni Peta zánt ke shomárá é chizz pakár ant. ");
INSERT INTO bccl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Cha har chizzá pésar, Hodáay bádsháhi o áiay rástén ráhay shóházá bebét, é sajjahén wat shomárá dayaga bant. ");
INSERT INTO bccl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pa bándátigén róchá paréshán o pegrig mabét, chiá ke bándát, wati pegrá wata kant. Maróchigén janjál, pa maróchigá bass ant. ");
INSERT INTO bccl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Degarán ér majanét o iráz magerét, tánke shomá ér janag mabét. ");
INSERT INTO bccl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Anchosh ke shomá degarán éra janét, hamé paymá shomá ér janaga bét o gón har kayl o paymánahéá ke bedayét, gón hamá kaylá shomárá dayaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Chiá wati brátay chammay pilláshká genday, bale wati chammay bondhá nagenday? ");
INSERT INTO bccl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tará ke bondhé chammá ent, chón wati brátá gwashta kanay: ‘Bell ke tai chammay pilláshká dara kanán’? ");
INSERT INTO bccl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Oo dopóstén shatalkár! Pésará wati chammay bondhá dar kan, randá tai chamm pacha bit o wati brátay chammay pilláshká kassheta kanay. ");
INSERT INTO bccl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Pák o palgárén chizzán kochekán madayét o wati morwáredán hukkáni démá maperrénét. Chó mabit ke áyán lagatmál bekanant o per betarrant o shomay jendá derr o drásh bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Belóthét, shomárá dayaga bit. Shóház bekanét, dara géjét. Darwázagá bethokkét, pacha bit. ");
INSERT INTO bccl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Chiá ke harkas belóthit, áiá rasit. Harkas shóház bekant, dara géjit. Harkas darwázagá bethokkit, pa áiá pacha bit. ");
INSERT INTO bccl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Shomay nyámá choshén peté hast ke agan áiay chokk nán belóthit dhóké bedanti? ");
INSERT INTO bccl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Yá agan máhig belóthit máré bedanti? ");
INSERT INTO bccl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Shomá ke radkár ét, angat wati chokkán sharrén chizzáni dayagá zánét. Gorhá shomay ásmáni Pet chenkadar shartera zánt ke wati lóthókén chokkán wasshén chizz bedant. ");
INSERT INTO bccl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Paméshká, har kárá gón degarán hamá dhawlá néki bekanét ke lóthét á dega ham gón shomá bekanant. Sharyat o nabiáni gapp o habar hamesh ent. ");
INSERT INTO bccl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Cha tankén darwázagá bepoterét. Chiá ke práhén darwázag o práhén ráh, gári o bégwáhiay némagá bárt o bázéné hamá ráhá zurit. ");
INSERT INTO bccl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Bale tank ent á darwázag o grán ent á ráh ke zenday némagá bárt o é ráhay rawók ham kamm ant. ");
INSERT INTO bccl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cha drógén paygambarán hozzhár bebét. Á, méshay póstá gwará kanant o shomay kerrá káyant bale cha bon o béhá derrókén gork ant. ");
INSERT INTO bccl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Shomá cha áyáni kerdá áyán pajjáha kárét. Cha dhangarán angur o cha dhóloká enjir chenaga bit? ");
INSERT INTO bccl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Sharrén drachk, sharrén bar o nibaga kárit o sellén drachk sellén bar o nibaga kárit. ");
INSERT INTO bccl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Sharrén drachk, sellén bar áworta nakant o sellén drachk sharrén bar dáta nakant. ");
INSERT INTO bccl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Drachké ke sharrén bara nayárit, goddhag o sóchaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Paméshká áyán cha barán pajjáha kárét. ");
INSERT INTO bccl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Hamá ke maná ‘Hodáwand, Hodáwanda’ gwashant, pa á sajjahénán ásmáni bádsháhiay darwázag pacha nabit, tahná hamá shota kant ke mani ásmáni Petay wáhag o razáay sará kára kant. ");
INSERT INTO bccl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Wahdé á rócha kayt bázéné maná gwashit: ‘Hodáwand, oo Hodáwand! Má gón tai námá paygambari nakortag? Gón tai námá cha mardomán jenn nakasshetagant o gón tai námá bázén ajabén kár pésh nadáshtag?’ ");
INSERT INTO bccl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Gorhá man áyán rásténa gwashán: ‘Oo badkárán! Man hechbar shomárá pajjáh nayáwortag, cha mani démá dur bebét.’ ");
INSERT INTO bccl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Paméshká, harkas ke mani é habarána eshkont o áyáni sará kára kant, hamá zántkár o hóshmandén mardomay paymá ent ke wati lógi taláray sará bast. ");
INSERT INTO bccl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Hawr but, hár o hirróp átk, purr o syahgwátán gón á lógá dhikk wárt, bale lóg nakapt, chiá ke áiay bonred taláray sará ér kanag butagat. ");
INSERT INTO bccl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Bale kasé ke mani habarán gósha dárit o áyáni sará kára nakant, hamá hódh o kamzántén mardomay dhawlá ent ke wati lógi rékáni sará bast. ");
INSERT INTO bccl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Hawr but, hár o hirróp átk, purr o syahgwátán gón á lógá dhikk wárt, lóg kapt o pahk wayrán but.” ");
INSERT INTO bccl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wahdé Issáyá é habar halás kortant, mardománi mocchi cha áiay dars o sabakán hayrán but o bah mantant, ");
INSERT INTO bccl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","chiá ke áiá Sharyatay zánógeráni paymá darsa nadát, gón wák o ehtiáré dars o tálimia dát. ");
INSERT INTO bccl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wahdé Issá cha kóhá ér kapt, mardománi mazanén mocchié áiay randá gón kapt. ");
INSERT INTO bccl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Yak mardé ke áiá syahgarray nádráhiá geptagat Issáay kerrá átk, áiay pádán kapt o gwashti: “Oo wájah! Agan taw belóthay, maná wassh o palgár korta kanay.” ");
INSERT INTO bccl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Issáyá dast shahárt, dasti per mosht o gwashti: “Mana lóthán, wassh o palgár bay.” Hamá damáná mard cha syahgarrá palgár but. ");
INSERT INTO bccl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Gorhá Issáyá gón áiá gwasht: “Hozzhár bay! Hechkasá cha é habar o hálá sahig makan, bale beraw, watá dini péshwáyá pésh bedár o hamá korbánigá bekan ke Mussáay Sharyatá nebisag butag, tánke pa áyán gwáh o sháhedié bebit.” ");
INSERT INTO bccl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wahdé Issá Kaparnáhumay shahrá raset, yak Rumi pawji apsaré áiay kerrá átk, mennatgiri kort o gwashti: ");
INSERT INTO bccl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Oo wájah! Mani hezmatkárén bachak lógá lang o mondh ent o kaptag, sakkén dard o dórán dochár ent.” ");
INSERT INTO bccl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Issáyá gwasht: “Gorhá mana káyán, áiá dráha kanán.” ");
INSERT INTO bccl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Pawji apsará passaw dát: “Oo wájah! Mana nakarzán ke taw mani lógá byáay, taw tahná hokm bekan, mani hezmatkár dráha bit. ");
INSERT INTO bccl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Chiá ke man ham wati masteráni hokmay chérá án o mani dastay chérá ham sepáhig hast. Agan kaséá hokm bekanán: ‘Beraw,’ á rawt o agan kaséá begwashán: ‘Byá,’ á kayt. Agan wati hezmatkárá begwashán: ‘É kárá bekan,’ á kant.” ");
INSERT INTO bccl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Wahdé Issáyá é habar eshkot, hayrán but o gón wati hamráhán gwashti: “Shomárá rásténa gwashán ke Esráiliáni nyámá ham man choshén mohrén setk o báwar nadistag. ");
INSERT INTO bccl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Bezánét ke cha ródarátk o rónendá bázén mardoma káyant o gón Ebráhém, Eshák o Ákubá ásmáni bádsháhiay mehmániá yakkén parzónagay chapp o chágerdá nendant, ");
INSERT INTO bccl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","bale é bádsháhiay chokk o óbádag dhanná taháriá dawr dayaga bant. Ódá gréwant o dantán pa dantána droshant.” ");
INSERT INTO bccl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Gorhá Issáyá gón pawji apsará gwasht: “Beraw, anchosh ke tai báwar ent, gón taw hamá dhawlá bit.” Áiay hezmatkárén bachak hamá damáná dráh but. ");
INSERT INTO bccl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wahdé Issá Petrosay lógá shot, disti Petrosay wassig tapig ent o nepáday sará waptag. ");
INSERT INTO bccl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Issáyá wati dast áiay dastay sará per mosht, tapi sest, á pád átk o Issáay hezmat kanagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Bégáhá mardomán bázén jenni ganók Issáay kerrá áwort, áiá gón wati yakkén habará jenn cha áyán kasshetant o sajjahén nádráh wassh o dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","É dhawlá Eshayá nabiay péshgói purah o sarjam but: áiá may nezóri dur kortant o nádráhi bortant. ");
INSERT INTO bccl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wahdé Issáyá wati chapp o chágerdá mardománi mocchi dist, parmán dát o gwashti: “Byáét, gwarmay domi némagá rawén.” ");
INSERT INTO bccl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Sharyatay zánógeré áiay kerrá átk o gwashti: “Oo ostád! Har jáh ke taw raway man tai hamráha bán.” ");
INSERT INTO bccl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Issáyá gwasht: “Róbáhán hóndh o jágah hast o báli morgán kodóh o kodám, bale maná ke Ensánay Chokk án pa saray ér kanagá hech jágah nést.” ");
INSERT INTO bccl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Dega yak moridéá gón áiá gwasht: “Oo wájah! Maná mókal beday pésará rawán wati petá kabra kanán.” ");
INSERT INTO bccl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Issáyá gwasht: “Byá, mani randgiriá bekan, bell ke mordag wati mordagán wat kabr o kapona kanant.” ");
INSERT INTO bccl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Issá bójigá swár but, morid ham swár butant. ");
INSERT INTO bccl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Yak anágat trondén tuppáné but o chawl o mawján bójig mán ropt, bale Issá wáb at. ");
INSERT INTO bccl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Morid áiay kerrá átkant, ágáhesh kort o gwashtesh: “Oo Hodáwand! Márá berakkén, ke ér bokkagi o meragi én.” ");
INSERT INTO bccl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Gón áyán gwashti: “Oo kambáwarán! Shomárá chiá torsit?” Randá pád átk, gwát o gwarmi hakkal dátant o tuppán pahk érmósh but. ");
INSERT INTO bccl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Á sajjahén bah mantant o gwashagá laggetant: “É chónén mardomé ke gwát o chawl ham eshiay hokmá mannant.” ");
INSERT INTO bccl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wahdé Issá mazangwarmay domi pahnátá, Gadáriáni sardhagárá raset, gorhá do mardom ke cha kabrestáná dar átkagat, gón áiá dochár kaptant. Áyán jenn per at o haminchok wahshi o torsnák atant ke kasséá cha á ráhá gwasta nakort. ");
INSERT INTO bccl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Áyán kukkár kort o gwasht: “Oo Hodáay Chokk! Tará gón má che kár ent? Cha gisshéntagén wahdá pésar, pa may azáb dayagá átkagay?” ");
INSERT INTO bccl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Cha áyán kammé gestá o á kashter, hukkáni ramagé charagá at. ");
INSERT INTO bccl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Gorhá palitén ruhán cha Issáyá dazbandi kort o gwasht: “Agan taw márá cha é mardomán dara kanay, gorhá ráh day ke hukkáni jesmá poterén.” ");
INSERT INTO bccl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Issáyá gón áyán gwasht: “Bepoterét!” Nun á dar átk o hukkáni jesmá potertant o hukkáni sajjahén ramag cha jompá jahlagá ér kapáná gwarmá bokket o mortant. ");
INSERT INTO bccl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Gorhá hukkáni shwánag shahrá tatkant o é sajjahén hál o jenni ganókáni sargwastesh pa mardomán rasént. ");
INSERT INTO bccl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Gorhá shahray sajjahén mardom Issáay cháragá átkant o gón áiá dazbandiesh kort ke áyáni sardhagárá yalah bedant o berawt. ");
INSERT INTO bccl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Issá yak bójigéá swár but, mazangwarmi gwázént o wati jenday shahrá átk. ");
INSERT INTO bccl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hamé wahdá lahtén mardomá, tahtéay sará waptagén lang o mondhén mardé áiay kerrá áwort. Wahdé Issáyá áyáni setk o báwar dist, gón langá gwashti: “Oo mani chokk! Delá mazan kan, tai gonáh bakshag butant.” ");
INSERT INTO bccl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Bale Sharyatay lahtén zánógerá wati delá gwasht: “É mard kopr kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Issáyá áyáni delay hál o habar zántant o gwashti: “Shomá chiá wati delá palitén hayála kárét? ");
INSERT INTO bccl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kojám habaray gwashag ásánter ent: ‘Tai gonáh bakshag butagant,’ yá: ‘Pád á, beraw’? ");
INSERT INTO bccl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bale man paméshká é habar kort tán shomá bezánét, man ke Ensánay Chokk án, maná é donyáyá gonáháni pahell kanagay wák o ehtiár hast.” Padá gón á langá gwashti: “Pád á, wati taht o nepádán bezur o lógá beraw.” ");
INSERT INTO bccl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gorhá mard pád átk o lógá shot. ");
INSERT INTO bccl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Wahdé mardomán é kár dist, torsetesh o Hodáesh satá kort o sárhát ke mardomi inchok wák o ehtiár dátagant. ");
INSERT INTO bccl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Anchosh ke Issá ráhá rawagá at, Mattá námén mardé disti ke song o máliát geragay jágahá neshtagat. Gón áiá gwashti: “Byá, mani randgiriá bekan!” Mattá pád átk o áiay hamráh but. ");
INSERT INTO bccl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wahdé Issá Mattáay lógá parzónagay sará neshtagat o warák waragá at, bázén songi o máliátgir o radkár ham átk o waragá gón Issá o áiay moridán hamwán butant. ");
INSERT INTO bccl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wahdé Parisián é dist gón Issáay moridán gwashtesh: “Chiá shomay wájah gón songi o gonahkárán waráka wárt?” ");
INSERT INTO bccl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Issáyá eshkot o gwashti: “Dráh o salámatén mardomán dáktar pakár naent, nádráhán dáktar pakár ent.” ");
INSERT INTO bccl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Bale berawét o é habaray mánáyá dar begéjét ke man hayrát o korbánig kanagay lóthók naán, mehr o rahmatay lóthók án. Man pa pahrézkárán nayátkagán, gonahkáráni lóthag o gwánk janagá átkagán. ");
INSERT INTO bccl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Randá, Yahyáay morid Issáay kerrá átkant o jostesh kort: “Má o Parisi róchaga dárén, bale tai morid chiá róchaga nadárant?” ");
INSERT INTO bccl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Issáyá passaw dát: “Sálónk ke neshtag, sur o árósay mehmán sugia bant o porsa dárant? Bale anchén wahdé kayt ke sálónk cha áyán jetá kanaga bit, hamá wahdá róchaga dárant. ");
INSERT INTO bccl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Hechkas cha nókén godéá chondhé naderrit o kwahnén pashká pacch o pinaga najant, chiá ke nókén goday pacch nazza kayt o kwahnén pashká géshtera derrit. ");
INSERT INTO bccl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Hamé dhawlá, kwahnén zekkáni tahá nókén sharáb mána nakanant, agan chosh bekanant zekka derant o sharába rechant o zekk ham zawála bant. Nókén sharábá nókén zekkán mána kanant, tán sharáb o zekk, har doén bemánant.” ");
INSERT INTO bccl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Issá angat gón áyán habar kanagá at ke parasteshgáhay yak masteré átk o áiay pádán kapt o gwashti: “Mani jenek hamé annun mortag, bale byá wati dastá áiay sará per mosh, á padá zendaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Issá pád átk o gón wati moridán áiay hamráh but. ");
INSERT INTO bccl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Hamódá yak janéné hastat ke dwázdah sál at áiay hón band nabutagat. Á cha poshti némagá átk o Issáay kabáhay lambi dast jat. ");
INSERT INTO bccl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Wati delá gwashagá at: “Agan Issáay kabáhá ham dast per bekanán, dráha bán.” ");
INSERT INTO bccl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Issáyá chakk tarrént o gwashti: “Oo mani jenek! Delá mazan kan, tai setk o báwará tará rakkéntag.” Hamá damáná janén dráh but. ");
INSERT INTO bccl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wahdé Issá parasteshgáhay masteray lógá raset, lahtén mótk áróki dist o bázéné porsay sará zár o puhár ham kanagá at. ");
INSERT INTO bccl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Issáyá gwasht: “Dhanná berawét, jenek namortag, bass wáb ent.” Bale mardom áiay habaráni sará kalág geragá atant. ");
INSERT INTO bccl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wahdé Issáyá mardom cha lógá dhanná dar kortant, jenekay dasti gept o jenek pád átk. ");
INSERT INTO bccl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","É hál, sajjahén damagá tálán but. ");
INSERT INTO bccl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Issá cha ódá ráh gept, ráhá do kór gwánk janán áiay randá kapt o gwashtesh: “Oo Dáud bádsháhay chokk! Tará may sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anchosh ke Issá lógá raset, doén kór áiay kerrá átkant. Issáyá gón áyán gwasht: “Shomárá báwar ent ke man é kárá korta kanán?” Áyán jwáb dát: “Haw, oo Hodáwand!” ");
INSERT INTO bccl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Gorhá Issáyá wati dast áyáni chammáni sará per mosht o gwashti: “Hamá dhawlá ke shomá báwar kortag, gón shomá hamá dhawlá bebit.” ");
INSERT INTO bccl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nun áyáni chamm rozhná butant. Issáyá kaddhan kort o gwashtant ke gón hechkasá é bárawá habar makanant. ");
INSERT INTO bccl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Bale á shotant o Issáay námesh sajjahén damagá tálán kort. ");
INSERT INTO bccl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Áyáni rawagá rand, yak mardé Issáay kerrá áwortesh ke jennéá geptagat o gong at. ");
INSERT INTO bccl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Anchosh ke Issáyá jenn kasshet, gong habar kanagá lagget. Sajjahén mardom hayrán butant o gwashtesh: “Choshén kár hechbar Esráilá gendag nabutag.” ");
INSERT INTO bccl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bale Parisián gwasht: “É, gón jennáni sardáray sarókiá jennána kasshit.” ");
INSERT INTO bccl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Issá sajjahén shahr o métagána shot o kanisaháni tahá mardomi dars o sabaka dátant, Hodáay bádsháhiaymestági sheng o tálána kort o har paymén nádráhi o nezórián dur kanán at. ");
INSERT INTO bccl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Áiá ke mardománi mocchi distant áyáni sará bazzagi but, chiá ke á béshopánkén pasáni dhawlá, paréshán o béwas atant. ");
INSERT INTO bccl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gón wati moridán gwashti: “Keshár báz ent bale ronók kamm. ");
INSERT INTO bccl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Paméshká gón kesháray wáhondá dazbandi bekanét o belóthét ke pa wati keshárán ronók dém bedant.” ");
INSERT INTO bccl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Randá Issáyá wati dwázdahén hásén kásed lóthetant o jennáni dar kanag o har dhawlén nádráh o nezórén mardománi dráh kanagay wák o ehtiári dátant. ");
INSERT INTO bccl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Á dwázdahén kásedáni nám esh ant: pésará, Shamun ke Petros ham gwashaga bit o áiay brát Andriás, randá Zebdiay chokk, Ákub o áiay brát Yuhanná, ");
INSERT INTO bccl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Pilipos, Bartulumá, Tumá o máliátgirén Mattá, Halpiay chokk Ákub, Taddá, ");
INSERT INTO bccl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","sarmachárén Shamun o Yahudá Eskaryuti, hamá ke randá Issái dróhagi o dozhmenáni dastá dayagi at. ");
INSERT INTO bccl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Issáyá wati é dwázdahén kásed rawán dát, kaddhan kort o gwashtant: “Darkawmáni gwará marawét, á shahrán ham marawét ke ódá Sámeri jahmenend ant, ");
INSERT INTO bccl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","bale Bani Esráiliáni kerrá berawét ke á gárén mésháni dhawlá ant.” ");
INSERT INTO bccl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Gwashti: “Har jáh ke rawét, é mestágá sar bekanét ke ásmáni bádsháhi nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Nádráhán dráh, mordagán zendag, garrián pák o sallah bekanét o cha mardomán jennán dar bekanét. Shomárá moptá rasetag, moptá ham bedayét. ");
INSERT INTO bccl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wati lánkbandáni tahá sohr o nograh o ród mán makanét. ");
INSERT INTO bccl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pa wati sát o sapará turag o pélek mazurét o na do jámag, na chawath o swás o na asá o dazlatth, chiá ke kár kanók wati mozzay hakdár ent. ");
INSERT INTO bccl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wahdé shahr yá métagéá rawét, gorhá anchén mardomé shóház bekanét ke shomay mehmán kanagay láhek bebit o tán roksata nabét hamáiay kerrá bedárét. ");
INSERT INTO bccl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wahdé lógéá rawét, drud o drahbát begwashét o pa á lógá sohl o émeni belóthét. ");
INSERT INTO bccl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Agan á lóga karzit, gorhá shomay émeniay wáhag pa áiá rasit o agan nakarzit, shomay é wáhag padá pa shomá pera tarrit. ");
INSERT INTO bccl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Agan kasé shomárá wasshátka nakant yá shomay habarán gósha nadárit, á lóg yá shahrá bellét o yalah kanagay wahdá, wati pádáni danz o hákán hamódá bechandhét o betakénét. ");
INSERT INTO bccl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Shomárá rásténa gwashán, jost o porsay róchá, Sodum o Gomurahay mardománi sezá cha á shahray mardománi sezá o azábá ásánter o kamtera bit.” ");
INSERT INTO bccl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Gósh dárét! Man shomárá rawána kanán, bale shomá anchosha bét ke gorkáni nyámá pas. Paméshká máráni dhawlá hozzhár o kapódaráni dhawlá sádah bebét. ");
INSERT INTO bccl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cha mardomán hozzhár bét, á shomárá geráénant o hakdiwánána barant, wati kanisaháni tahá shomárá shallák o hayzarána janant. ");
INSERT INTO bccl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pa manigi hákem o bádsháháni démá pésh kanaga bét, gorhá shomárá sharrén móhé rasit ke áyáni o darkawmáni démá pa man gwáhi bedayét. ");
INSERT INTO bccl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Á wahdán ke shomá ódá baraga bét, delá paréshán mabét ke ‘ché begwashén’ yá ‘chón passaw bedayén,’ chiá ke harché ódá shomárá gwashagia bit, hamá wahdá shomárá rasit. ");
INSERT INTO bccl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Á wahdá habar kanók shomá nabét, shomay ásmáni Petay Ruh shomay zobáná habara kant. ");
INSERT INTO bccl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Brát wati brátá dróhit o kóshárénit o pet wati chokká, chokk cha wati pet o mátá yágia bant o áyána kóshárénant. ");
INSERT INTO bccl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Sajjahén mardom, pa mani námay sawabá cha shomá naprata kanant. Bale hamá ke tán áherá sakkiána saggit, á rakkit. ");
INSERT INTO bccl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wahdé shomárá yak shahréá ázára rasénant gorhá betachét o dega shahréá berawét. Shomárá rásténa gwashán, tánke shomá Esráilay sajjahén shahrán sar bebét, man ke Ensánay Chokk án, pésará káyán. ");
INSERT INTO bccl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Na shágerd cha wati ostádá mastera bit o na golám cha wati hodábondá. ");
INSERT INTO bccl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Shágerdá haminchok bass ent ke wati ostáday paymá bebit o golám wati hodábonday paymá. Wahdé lógay hodábondesh Belzabul gwashtag, gorhá lógay é dega mardomán allam badterén nám pera bandant. ");
INSERT INTO bccl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Shomá cha á mardomán matorsét, chiá ke hech choshén chérén chizzé nést ke záher o paddar mabit o hech choshén rázé nést ke áshkár o démdará mabit. ");
INSERT INTO bccl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Hamá habarán ke man gón shomá shapay taháriá gwashán, shomá á habarán róchay rozhnáiá begwashét, hamá habar ke halwatá shomay góshán gwashaga bant, á habarán lóg o bánáni sará begwashét o jár janét. ");
INSERT INTO bccl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Cha áyán matorsét ke jesm o jáná koshta kanant, bale sáh o arwáhá koshta nakanant, cha hamáiá betorsét ke jesm o ján o sáh o arwáh, doénán tahtaruná dawr dát o bérán korta kant. ");
INSERT INTO bccl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Do jenjeshk pa yak paysahá bahá nabit? Bale angat cha áyán yakké ham bé shomay ásmáni Petay zánagá zeminá nakapit. ");
INSERT INTO bccl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Hodáyá shomay saray mudáni hesáb ham gón ent. ");
INSERT INTO bccl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Paméshká matorsét, shomay kadr o arzesh cha sajjahén jenjeshkán géshter ent. ");
INSERT INTO bccl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Harkas mardománi démá maná bemannit, man ham wati ásmáni Petay démá áiá mannán, ");
INSERT INTO bccl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","bale harkas mardománi démá maná mamannit, man ham wati ásmáni Petay démá áiá namannán. ");
INSERT INTO bccl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Gomán makanét ke man donyáyá tepáki o sohlay áragá átkagán, pa sohl o tepákiá nayátkagán, gón zahméá átkagán. ");
INSERT INTO bccl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Chiá ke man átkagán tán pet o chokkay nyámá, mát o jenekay nyámá, neshár o wassigay nyámá nátepáki byárán, ");
INSERT INTO bccl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","bezán harkasay dozhmen áiay wati mardoma bant. ");
INSERT INTO bccl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Kaséá ke wati pet o mát cha man dóstera bant, á maná nakarzit o kaséá ke wati bachak o jenek cha man dóstera bant, á ham maná nakarzit. ");
INSERT INTO bccl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Kasé ke wati salibá baddhá makant o mani hamráh mabit, á ham maná nakarzit. ");
INSERT INTO bccl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Chiá ke, agan kasé wati sáhay dáragay johdá bekant, áiá báhénit, bale kasé ke pa manigi wati sáhá báhénit, áiá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Harkas shomárá wasshátk begwashit o sharap bedant, maná sharapa dant o hamá ke maná sharapa dant, á hamáiá sharapa dant ke maná ráhi dátag. ");
INSERT INTO bccl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Agan kasé paygambaréá paméshká wasshátka kant o sharapa dant ke á Hodáay ráh dátagén ent, áiá paygambaréay mozza rasit. Hamé dhawlá, kasé ke pahrézkár o rástén mardoméá pa áiay pahrézkáriá sharap bedant, áiá ham pahrézkárén mardoméay mozza rasit. ");
INSERT INTO bccl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Agan kasé cha é kasánokén moridán yakkéá paméshká tásé ápa dant ke mani morid ent, allam bezánét ke áiá wati mozza rasit.” ");
INSERT INTO bccl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wati dwázdahén moridáni tálim dayagá rand, Issá cha ódá dar átk o pa dars o sabak dayag o wáz kanagá áyáni shahrán shot. ");
INSERT INTO bccl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Wahdé pákshódókén Yahyá, bandijáhá cha Issá Masihay kárán sahig but, wati moridi ráh dátant ");
INSERT INTO bccl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ke cha áiá jost bekanant: “Bárén, taw hamá ay ke áyagi at, yá pa degaréá rahchár bebén?” ");
INSERT INTO bccl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Issáyá passaw dátant: “Harché ke shomá eshkonag o gendagá ét, berawét Yahyáyá sahig kanét: ");
INSERT INTO bccl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","kór gendag o maym kanagá ant, lang tarrag o ráh rawagá ant, garri pák o palgár bayagá ant, karr eshkonagá ant, mordag zendag bayagá ant o bazzag o nézgárán wasshén mestág sar bayagá ent. ");
INSERT INTO bccl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Bahtáwar hamá ent ke mani káráni gendagá thagal mawárt o malakoshit.” ");
INSERT INTO bccl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wahdé Yahyáay kásed dar kapt o shotant, Issá gón mardomán Yahyáay bárawá gapp o trán kanagá lagget: “Chónén chizzéay cháragá gyábáná shotagét? Kalam o káshay dhilléay cháragá ke gón gwátay kasshagá é dém o á dém shikka wárt? ");
INSERT INTO bccl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Agan na, gorhá chónén chizzéay cháragá shotagét? Anchén mardéay cháragá shotagét ke narm o názorkén pósháki gwará at? Á mardom ke názorkén póshák gwará kanant, bádsháhi kalát o márhián nendók ant. ");
INSERT INTO bccl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Gorhá ódá shomá chónén chizzéay cháragá shotagét? Paygambaréay cháragá? Haw, shomárá gwashán ke Yahyá cha paygambaréá ham master ent. ");
INSERT INTO bccl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Á hamá ent ke áiay bárawá nebisag butag: Bechár, man wati kásedá cha taw pésar ráha dayán ke á, tai ráhá tachk o tayára kant. ");
INSERT INTO bccl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Shomárá rásténa gwashán ke hech mátá pákshódókén Yahyáay warhén bématthén chokké nayáwortag. Bale ásmáni bádsháhiá, hamá ke cha sajjahénán kaster ent, á cha Yahyáyá ham master ent. ");
INSERT INTO bccl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Cha pákshódókén Yahyáay wahdá beger tán annun, Hodáay ásmáni bádsháhi gón zóráki démá rawán ent o zórmand áiá pa zóré watigia kanant. ");
INSERT INTO bccl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Sajjahén nabián o Tawrátá, tán Yahyáay zamánagá wati péshgói kortagant. ");
INSERT INTO bccl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Agan shomá pa mannagá tayár ét, bezánét Yahyá hamá Elyás nabi ent ke áyagi at. ");
INSERT INTO bccl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Harkasá gósh per, beshkont. ");
INSERT INTO bccl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“É zamánagay mardomán kai hamdarwar bekanán ke á, kai dhawlá ant? Á, hamá chokkáni paymá ant ke bázárá neshtagant o á dega chokkán gwánka janant o gwashant: ");
INSERT INTO bccl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Má pa shomá nal o kalam sáz kort, bale shomá nách o sohbat nagept, má pa shomá mótk áwort, bale shomá arsé narétk.’ ");
INSERT INTO bccl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yahyá átkag, na nána wárt o na sharába nóshit, gwashant: ‘Jenni per ent,’ ");
INSERT INTO bccl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","bale Ensánay Chokk átkag, wárt o nóshit, gwashant: ‘Lápi o sharábié, máliátgir o gonahkáráni sangat ent.’ Bale hekmat o zánt cha kár o kerdá záhera bit.” ");
INSERT INTO bccl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Gorhá Issá hamá shahr o mardománi mayárig kanagá lagget ke wati géshterén ajabén kári hamá shahrán kortagatant, chiá ke áyán cha wati badén kárán pashómáni darshán nakortagat. ");
INSERT INTO bccl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Bazhn o apsóz pa shomá, oo Korázinay mardomán! Bazhn o apsóz pa shomá, oo Bayt-Saydáay mardomán! Hamá mójezah o ajekkái ke man shomay nyámá pésh dáshtagant, agan Sur o Saydunay shahrán pésh bedáshténant, gorhá óday mardomán hamá wahdá wati gonáháni pashómániay póshák gwará kortagat o poráni sará neshtagatant. ");
INSERT INTO bccl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Báwar kanét, jost o porsay róchá Sur o Saydunay mardománi sezá cha shomay sezá o azábá ásánter o kamtera bit. ");
INSERT INTO bccl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Oo Kaparnáhumay mardomán! Shomá chest kanag o ásmáná baraga bét? Hechbar! Tahtarunay johlánkián sarshakuna bét. Chiá ke hamá mójezah o ajekkái ke pa taw pésh dárag butant, agan Sodumay shahrá bebuténant, á shahr tán róch maróchigá mantagat. ");
INSERT INTO bccl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Báwar kanét, jost o porsay róchá Sodumay mardománi sezá cha shomay sezá o azábá ásánter o kamtera bit.” ");
INSERT INTO bccl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Á wahdá Issáyá gwasht: “Oo mani Pet, zemin o ásmánay Hodábond! Tará satá kanán o sárháyán ke taw é ráz o habar cha zántkár o hóshmandán chér dátant o kódakáni sará paddar kortant. ");
INSERT INTO bccl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Oo mani Pet! Taw cha wati razá o wáhagá é dhawlá kort. ");
INSERT INTO bccl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Sajjahén chizz, Petá mani dastá dátagant. Abéd cha Petá, hechkas Chokká nazánt. Hamé dhawlá, dega hechkas Petá nazánt, abéd cha Chokká o hamá mardomán ke Chokk belóthit Petá pa áyán paddar bekant. ");
INSERT INTO bccl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Oo srénproshtagén zahmatkasshán! Dém pa man byáét, man wat shomárá árám o ásudagia bakshán. ");
INSERT INTO bccl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Mani jogá baddhá kanét, cha man hél begerét, ke man narmdel o békebr án. Gorhá shomárá árám o ásudagia rasit. ");
INSERT INTO bccl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Chiá ke mani jog ásán o mani bár sobakk ent.” ");
INSERT INTO bccl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Yak randé, Shabbatay róchá Issá cha gandomi keshárán gwazagá at. Áiay morid shodig atant o kesháray hóshagán sendag o waragá laggetant. ");
INSERT INTO bccl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Parisián ke dist gón Issáyá gwashtesh: “Bechár! Tai morid anchén kára kanant ke Shabbatay róchá rawá naent.” ");
INSERT INTO bccl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Passawi dát: “Záná, shomá nawántag, wahdé Dáud o áiay hamráh shodig butant, Dáudá ché kort?” ");
INSERT INTO bccl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Hodáay Pákén lógá shot, Hodáay námá hayráti o pákwandhén náni wártant ke áyáni warag na pa áiá rawá at o na pa áiay hamráhán, tahná pa dini péshwáyán rawá at. ");
INSERT INTO bccl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sharyatá é ham nawántagó ke mazanén parasteshgáhay tahá, dini péshwá Shabbatay béhormatiá kanant bale angat bémayár zánag o lékaga bant? ");
INSERT INTO bccl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Man gón shomá gwashán ke edá cha mazanén parasteshgáhá ham masteréné hastent. ");
INSERT INTO bccl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Agan shomá é habaray máná bezántén ke gwashit: Man hayrát o korbánig kanagay lóthók naán, mehr o rahmatay lóthók án, gorhá shomá á mardom mayárig nakortagatant ke bémayár ant. ");
INSERT INTO bccl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Bezánét man ke Ensánay Chokk án, Shabbatay róchay wáhond án. ");
INSERT INTO bccl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Cha ódá démá rawán, Issá áyáni kanisahá shot. ");
INSERT INTO bccl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ódá mardé hastat ke dasti hoshk o mondh at. Lahténá pa beddh o bohtám janagay nimmóná cha Issáyá jost kort: “Shabbatay róchá kaséay dráh kanag rawá ent yá na?” ");
INSERT INTO bccl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Gón áyán gwashti: “Agan cha shomá kaséá méshé hast o Shabbatay róchá chátéá bekapit, hamá damáná méshá cha chátá dara nakant? ");
INSERT INTO bccl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ensánay arzesh cha méshá báz géshter ent. Paméshká Shabbatay róchá néki kanag rawá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nun gón á mardá gwashti: “Dastá shahár day.” Áiá dast shahár dát o domi dastay dhawlá wassh o dráh but. ");
INSERT INTO bccl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Bale Parisi dhanná shotant o pa Issáay kóshárénagá shawr o saláhesh kort. ");
INSERT INTO bccl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Wahdé Issáyá áyáni delay é habar zánt, cha ódá dar kapt. Bázéné áiay padá rawán but o áyáni nyámá harkas ke nádráh at, sajjahéni dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Kaddhani kortant o gwashti: “Gón kassá magwashét man kay án.” ");
INSERT INTO bccl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","É dhawl paméshká but ke Eshayá nabiay gwashtagén habar sarjam bebit: ");
INSERT INTO bccl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","É mani hezmatkár ent ke man gechén kortag, maná sakk dóst ent o man cha eshiá báz wassh o razá án, man wati Ruhá eshiay sará éra géján, darkawmáni nyámá é hezmatkár mani ensáp o dádrasiay járá perrénit. ");
INSERT INTO bccl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na jang o merha kant o na ják o kukkár o na kasé damk o bázárán áiay tawárá eshkont, ");
INSERT INTO bccl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","na ke nezór o nawahkén kalam o káshá próshit o na mermeránkén cherágá koshit, tán hamá wahdá ke ensáp o dádrasiá sóbéno kámyáb bekant. ");
INSERT INTO bccl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Pa donyáay kawmán áiay nám mazanén omété bit. ");
INSERT INTO bccl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Hamá wahdá mardomán Issáay gwará yak jenni ganóké áwort. Á, kór o gong at. Issáyá dráh kort o á gendag o habar kanagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Sajjahén mardom pa hayráni o bah mánagi gwashagá laggetant: “Chosh buta kant ke é Dáud bádsháhay chokk o óbádag ent?!” ");
INSERT INTO bccl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bale wahdé Parisián é habar eshkot, gwashtesh: “É, gón jennáni sardár Belzabulay sarókiá jennána kasshit.” ");
INSERT INTO bccl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Issáyá áyáni é hayál zánt o gón áyán gwashti: “Har molkéá ke nátepáki bekapit, á molk gár o zawála bit o har shahré yá lógé bahr o báng bebit, barjáha namánit. ");
INSERT INTO bccl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Agan Shaytán wat Shaytáná dar bekant, bezán gón wati jendá jang ent. Gorhá áiay bádsháhi chón barjáha mánit? ");
INSERT INTO bccl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Agan man gón Belzabulay sarókiá jennán dara kanán, gorhá shomay jenday chokk o morid gón kai zór o wáká jennán dara kanant? É paymá, shomay morid wat shomárá mayáriga kanant. ");
INSERT INTO bccl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Bale agan man gón Hodáay Ruhá jennán dara kanán, bezánét ke Hodáay bádsháhi shomay nyámá rasetag. ");
INSERT INTO bccl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Yá chón buta kant, kasé zóráwarén mardoméay lógá bepoterit o áiay mál o melkatá pol o pánch bekant, tán pésará á zóráwarén mardá magipt o mabandit? Gorhá áiay lógá pol o pánch korta kant. ");
INSERT INTO bccl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Kasé ke mani hamráh o dózwáh naent, á mani badwáh ent, kasé ke mocch o yakjáh kanagá gón man hór naent, á, sheng o sháng o tak o parka kant. ");
INSERT INTO bccl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Paméshká shomárá gwashán ke har gonáh o kopr, bakshag o pahell kanaga bit, bale Hodáay Pákén Ruhay bárawá sellén habar o kopr, pahell kanaga nabit. ");
INSERT INTO bccl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Harkas Ensánay Chokkay bárawá sellén habaré bekant bakshaga bit, bale á ke Pákén Ruhay bárawá sellén habaré begwashit, na é donyáyá pahell kanaga bit o na áyókén donyáyá. ");
INSERT INTO bccl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Agan sharrén bar o nibaga lóthét, báyad ent drachk sharréné bebit, badén drachk badén bar o nibaga dant, har drachk cha áiay bará zánaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Oo syahmárzádagán! Shomá ke wat sell o radkár ét, chón sharrén habar korta kanét? Chiá ke harché mardomay delá bebit, hamá cha áiay dapá dara kayt. ");
INSERT INTO bccl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Sharrén mardom cha sharrén ganj o hazánagá sharrén chizz dara kant o sellén mardom cha sellén hazánagá, sellén chizz. ");
INSERT INTO bccl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Shomárá gwashán ke jost o porsay róchá mardomán wati har mopt o náhudagén habaray hesáb dayagi ent. ");
INSERT INTO bccl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Chiá ke tai habar ant ke tará bémayára kanant o tai habar ant ke tará mayárbára kanant.” ");
INSERT INTO bccl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Gorhá lahtén Parisi o Sharyatay zánógerá gón áiá gwasht: “Oo ostád! Má cha taw neshánié gendaga lóthén.” ");
INSERT INTO bccl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Issáyá áyáni passawá gwasht: “Sherr o zenahkárén nasl o padréch, neshánia lóthit, bale Yunes nabiay neshániá abéd, dega hech neshánié áyán dayaga nabit. ");
INSERT INTO bccl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Anchosh ke Yunes tán say róch o say shapá thuhén máhigay lápá at, hamé paymá Ensánay Chokk tán say róch o say shapá zeminay lápá bit. ");
INSERT INTO bccl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jost o porsay róchá, Naynawáay mardom gón é zamánagay mardomán hórigá páda káyant o áyán mayáriga kanant, chiá ke á Yunesay dháh o hozzhárbáshay sará cha wati gonáhán pashómán butant. Bale nun cha Yunesá masteréné edá ent. ");
INSERT INTO bccl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jost o porsay róchá, Sabáay malakah gón é zamánagay mardomán hórigá páda kayt o áyán mayáriga kant, chiá ke Sabáay malakah cha donyáay á dastá átk tán Solaymánay hekmatá beshkont. Bale nun cha Solaymáná masteréné edá ent. ");
INSERT INTO bccl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Wahdé jenné cha kaséá dara kayt, gorhá gyábánána rawt tán pa wati árámi o ásudagiá, jáhé shóház bekant, bale choshén jágahé narasiti. ");
INSERT INTO bccl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Gorhá gwashit: ‘Cha ódá ke dar átkagán, padá hamódá rawán.’ Wahdé pera tarrit o gendit ke á lóg hórk o hálig, roptag o sáp o sallah ent, ");
INSERT INTO bccl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","gorhá rawt o cha watá dega hapt selterén jenn gón wata kárit. Á sajjahén, hórigá ódá rawant o ord o bonaga kanant. É dhawlá, á mardomay ásar o ákebat cha pésarigéná angat badtera bit. É badkárén naslay hál ham hamé paymá bit.” ");
INSERT INTO bccl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Issá angat gón mardomán habará at ke áiay mát o brát átk o dhanná óshtátant. Áyán gón Issáyá habar kanagi at. ");
INSERT INTO bccl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Gorhá yakkéá Issá sahig kort ke “tai mát o brát dhanná óshtátagant, gón taw habar kanaga lóthant.” ");
INSERT INTO bccl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Issáyá passaw dát: “Mani mát kay ent o mani brát kay?” ");
INSERT INTO bccl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Padá áiá wati moridáni némagá dast shahár dát o gwasht: “Esh ant mani mát o brát. ");
INSERT INTO bccl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Harkas ke mani ásmáni Petay wáhag o razáay sará kára kant, mani brát, mani mát o gohár hamá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Hamá róchá, Issá cha lógá dar átk o mazangwarmay kerrá shot o nesht. ");
INSERT INTO bccl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Bale mardománi anchén mazanén mocchié áiay gwará átk ke á bójigéá swár but. Sajjahén mardom gwarmay tayábá óshtátagatant. ");
INSERT INTO bccl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Gorhá áiá mardom gón darwar o mesálán bázén dars o sabaké dátant. Gwashti: “Yak dehkáné pa tohmay chandhagá shot, ");
INSERT INTO bccl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","tohmáni chandhagay wahdá kammoké tohm ráhay sará retk o báli morgán chet o wártant. ");
INSERT INTO bccl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kammé tohm dhal o dhókáni sará retk ke ódá hák kamm at, paméshká zutt rost o sabz butant, chiá ke dhagár talag at. ");
INSERT INTO bccl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Bale cha róchay trondén garmiá gimmort o hoshk butant, chiá ke áyáni risshag o wandhál zeminá johl nashotagatant. ");
INSERT INTO bccl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kammé tohm shezz o cherekkáni tahá ham retk o shezzán áyáni rost o rodóm dásht. ");
INSERT INTO bccl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Dega kammé tohm, sharrén zeminá retk, rost o baresh kort, jáhé sad sari, jáhé shast sari o jáhé si sari. ");
INSERT INTO bccl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Harkasá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nun morid áiay kerrá átkant o jostesh kort: “Chiá taw gón mardomán pa darwar o mesál habara kanay?” ");
INSERT INTO bccl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Áyáni passawá gwashti: “Hodáyá é zánt shomárá dátag ke ásmáni bádsháhiay rázán sarpad bebét, bale á dega mardománá nadátagi. ");
INSERT INTO bccl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Hamáiá ke chizzé hast, géshter dayaga bit, tánke áiá báz bebit, bale kaséá ke nést, hamá ke hastenti ham pach geraga bit. ");
INSERT INTO bccl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Paméshká man pa darwar o mesál gón áyán habara kanán ke áyáni chammán maym hast bale nagendant, góshesh pach ant bale naeshkonant o sarkech ham nawarant. ");
INSERT INTO bccl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Eshayá nabiay péshgói é mardománi bárawá rást o sarjama bit ke gwashit: gón góshána eshkonét, bale sarkecha nawarét, gón chammána chárét, bale nagendét, ");
INSERT INTO bccl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","chiá ke é kawm sengdel butag, góshesh grán ant, áyán wati chamm bastagant chó mabit áyáni chamm begendant, áyáni gósh beshkonant, áyáni del bezánant o sarpad bebant o mani némagá per betarrant ke man áyán dráh bekanán. ");
INSERT INTO bccl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Bale shomay chamm bahtáwar ant ke gendant o shomay gósha eshkonant. ");
INSERT INTO bccl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Shomárá rásténa gwashán, bázén paygambar o pahrézkárén mardománi wáhag butag ke harché shomá gendagá ét áyán ham bedistén, bale nadistesh o harché ke shomá eshkonagá ét áyán ham beshkotén bale naeshkotesh. ");
INSERT INTO bccl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Nun tohm chandhagay mesálay maksad o mánáyá gósh bedárét. ");
INSERT INTO bccl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Wahdé kasé Hodáay bádsháhiay habará eshkont, bale sarkecha nawárt, gorhá Shaytána kayt o harché ke áiay delá keshag butag dara kant o bárt. Esh at ráhay sará retkagén tohmáni mesálay máná. ");
INSERT INTO bccl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Á tohm ke dhal o dhókáni sará retkant, hamá mardomay mesál ent ke Hodáay habará eshkont o hamá damáná pa gal o shádehia mannit, ");
INSERT INTO bccl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","bale pa é sawabá ke risshag o wandháli najatag, Hodáay habar áiay delá, tán dérá namánit o jágaha nakant. Wahdé Hodáay gál o habaráni sawabá sakki o ázáré berasiti, hamá damáná cha ráhá thagalit o kapit. ");
INSERT INTO bccl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Á tohm ke shezz o dhangaráni tahá retkant, hamá mardomay mesál ent ke Hodáay habará gósha dárit, bale donyái parésháni o mál o zarray hers o jópah, áiá rada dayant o naylant Hodáay habar sabz betarrit o bar o barward bedant. ");
INSERT INTO bccl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Á tohm ke sharrén zeminá retkant hamá mardomay mesál ent ke Hodáay habará gósha dárit o sarpada bit o bar o barwarda dant, bázéné sad sari, bázéné shast sari o bázéné si sari.” ");
INSERT INTO bccl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Issáyá pa áyán dega mesálé áwort o gwasht: “Ásmáni bádsháhi, hamá mardomay paymá ent ke wati dhagárá sharrén tohmi keshtagat, ");
INSERT INTO bccl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","bale wahdé mardom waptag o wáb atant, áiay dozhmené átk o gandomay keshtagén dhagárá zahrichk o barri káhay tohmi rétk o shot. ");
INSERT INTO bccl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wahdé gandom rostant o hóshagesh áwort, káh o zahrichk ham rost o mazan butant. ");
INSERT INTO bccl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nun nawkar átkant o gón wati hodábondá gwashtesh: ‘Oo wájah! Taw wati dhagárá sharrén tohm nakeshtagat? Gorhá é zahrichk o barri káh cha kojá átkant?’ ");
INSERT INTO bccl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Gwashti: ‘Dozhmenéá é kár kortag.’ Nawkarán jost kort: ‘Taw lóthay má berawén áyán begwajén?’ ");
INSERT INTO bccl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Passawi dát: ‘Na, chó mabit ke káh o zahrichkáni gwajagay wahdá gandom ham dar kanag bebant. ");
INSERT INTO bccl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tán ronagay wahdá belli hórigá rodant, ronagay wahdá gón rónkárána gwashán: “Pésará zahrichkán yakráh o pa sóchagá grámband bekanét, randá gandomán mani ambárá bellét.”’” ");
INSERT INTO bccl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Issáyá gón áyán dega mesálé jat o gwasht: “Ásmáni bádsháhi, thélkáhay tohmay dhawlá ent, ke kaséá zort o wati dhagárá kesht. ");
INSERT INTO bccl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Toré belli áiay dánag cha é dega tohmán kaster ent, bale wahdé rodit cha é dega sabzagán borzter, drachkéay dhawlá bit o báli morg áiay ták o tháláni chérá kodóh o kodáma bandant.” ");
INSERT INTO bccl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Randá dega mesálé áworti: “Ásmáni bádsháhi, hamá homiray paymá ent ke janénéá zort o gón bázén ártéá hawár kort o kam kammá sajjahén árt gwát gept o homir but.” ");
INSERT INTO bccl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Issáyá pa mardomán sajjahén habar, mesál o darwaráni tahá gwashtant, bé darwar o mesálán hech habaria nakort, ");
INSERT INTO bccl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","tán paygambaray é habar sarjam bebit ke gwashit: “man gón mesál o darwarán wati zobáná pacha kanán o gón áyán anchén habara kanán ke cha donyáay pédáeshá beger tán angat, chér o andém butagant.” ");
INSERT INTO bccl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Randá Issáyá mardom eshtant o lógá shot, ódá morid áiay gwará átkant o gwashtesh: “Márá dhagáray barri káh o zahrichkay mesálay mánáyá sarpad kan.” ");
INSERT INTO bccl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Gwashti: “Hamá ke sharrén tohma keshit, Ensánay Chokk ent. ");
INSERT INTO bccl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Dhagár donyá ent, sharrén tohm ásmáni bádsháhiay chokk ant, zahrichkay tohm Shaytánay chokk ant, ");
INSERT INTO bccl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","hamá dozhmen ke tohmi dhagárá rétkant, Shaytán ent, kesháray rónay wahd, áheratay róch ent o kesháray ronók,préshtag ant. ");
INSERT INTO bccl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Anchosh ke zahrichk mocch kanag o ásá sóchaga bant, áheratay róchá ham hamé dhawlá bit. ");
INSERT INTO bccl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ensánay Chokk, wati préshtagán ráha dant tán sajjahén badkárán o áyán ke degarán rada dayant yakjáh bekanant o cha áiay bádsháhiá dar bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Áyán ásay kurahá dawra dayant ke ódá gréwag o dantán pa dantán droshaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Á wahdá nék o pahrézkárén mardom, wati Petay bádsháhiá róchay paymá drapshant. Harkasá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ásmáni bádsháhi, hamá ganj o hazánagay paymá ent ke dhagáréá chér dayag butag. Wahdé anágat kaséá dar gétk, áiá chéra dant o padá pa gal o shádehia rawt o wati sajjahén mál o maddhiá bahá kant o hamá dhagárá pa bahá zurit. ");
INSERT INTO bccl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Hamé dhawlá, ásmáni bádsháhi, sawdágeréay paymá ent ke dhawldárén morwáred shóháza kant. ");
INSERT INTO bccl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wahdé áiá sakkén gránkimmatén morwáredé dastá kapit, gorhá rawt o wati sajjahén hast o néstá bahá kant o hamá morwáredá gipt. ");
INSERT INTO bccl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Hamé dhawlá ásmáni bádsháhi, yak dám o máhóréay dhawlá ent ke gwarmá dawria dayant o har paymén máhiga gerant. ");
INSERT INTO bccl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Wahdé dám cha máhigá porra bit, cha gwarmá dhann daria kanant o máhigán dara chenant, sharrén máhigána zurant o saptáni tahá kanant o é dega harábénán dawra dayant. ");
INSERT INTO bccl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Áheratay róchá ham anchosha bit. Préshtaga káyant o badkárán cha nék o pahrézkárén mardomána gisshénant o jetá kanant. ");
INSERT INTO bccl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Badkárán ásay kurahá dawra dayant ke ódá gréwag o dantán pa dantán droshaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Bárén, shomá é sajjahén habarán sarpad butét?” Áyán passaw dát: “Ji haw.” ");
INSERT INTO bccl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Gón áyán gwashti: “Paméshká Sharyatay har zánóger ke ásmáni bádsháhiay moridé bit, hamá marday dhawlá ent ke cha wati hazánagá har paymén nók o kwahnén chizz dara kant.” ");
INSERT INTO bccl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wahdé Issáyá é mesál o darwar sarjam kortant, cha ódá dar kapt. ");
INSERT INTO bccl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Wati jenday shahrá átk, óday kanisahá mardománi tálim dayagi bongéj kort. Mardom pa hayráni gwashagá laggetant: “Eshiá é zánt o zánag o é dhawlén ajabén kár kanagay wák o twán cha kojá rasetag?” ");
INSERT INTO bccl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","É hamá dártráshay chokk naent? Maryam eshiay mát o Ákub, Issop, Shamun o Yahudá eshiay brát naant? ");
INSERT INTO bccl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Eshiay sajjahén gohár hamedá may kerrá jahmenend naant? Gorhá é sajjahén chizzi cha kojá áwortagant? ");
INSERT INTO bccl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Áyán bad átk o Issáesh namannet, bale Issáyá gón áyán gwasht: “Hech nabiéá wati shahr o hankéná o wati lógá sharap nést.” ");
INSERT INTO bccl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Paméshká áiá ódá bázén mójezah pésh nadásht, chiá ke mardomán áiay sará báwar néstat. ");
INSERT INTO bccl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Á wahdá Jalilay hákem Hirudis, Issáay nám o tawárá sahig but. ");
INSERT INTO bccl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Áiá gón wati hezmatkárán gwasht: “É hamá pákshódókén Yahyá ent ke cha mordagán zendag butag, paméshká choshén ajekkái o mójezahána kant.” ");
INSERT INTO bccl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Chosh at ke Hirudisá Hirudiáay sawabá ke pésará áiay brát Piliposay jan at, Yahyá geráéntag o bandijáhá band kortagat. ");
INSERT INTO bccl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Chiá ke Yahyáyá gón Hirudisá gwashtagat: “Hirudiáay wati lógi kanag Sharyatá pa taw rawá naent.” ");
INSERT INTO bccl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hirudisá pa Yahyáay kóshárénagá shawr kortagat bale torseti, chiá ke mardománi báwar at Yahyá paygambaré. ");
INSERT INTO bccl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Hirudisay sálgerah but o Hirudiáay jeneká mehmánáni démá nách o sohbat gept. Hirudis báz washdel but, ");
INSERT INTO bccl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","sawgendi wárt o labzi kort ke “harché lóthay belóth, pa taw bakshaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Jeneká wati mátay shawr o saláhay sará gwasht: “Pákshódókén Yahyáay sará hamedá tabakéay tahá bekan o maná beday.” ");
INSERT INTO bccl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Hirudis báz paréshán o deltaparkah but bale mehmánáni démá sawgendi wártagat o jeneki labz dátagat, paméshká parmáni kort áiay é wáhagá barjáh bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","É dhawlá, Yahyáay sari bandijáhá borráént. ");
INSERT INTO bccl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Gorhá áiay sar tabakéay tahá árag o jeneká dayag but, áiá wati mátay kerrá bort. ");
INSERT INTO bccl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Yahyáay morid átkant o áiay jónesh bort, kabr o kaponá rand, shot o Issáesh sahig kort. ");
INSERT INTO bccl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","É habaray eshkonagá rand, Issá bójigéá swár but o dur o gestáén jáhéá tahnaká shot. Wahdé mardom sahig butant, cha shahrán payádaká áiay randá gón kaptant. ");
INSERT INTO bccl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Issá ke cha bójigá ér kapt o mardománi mazanén mocchii dist, áyáni sará bazzagi but o sajjahén nádráhi dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bégáhá, morid áiay kerrá átkant o gwashtesh: “É, dur o gestáén jágahé o béwahd ham butag, paméshká mardomán bell ke métag o bázárán berawant o pa wat ward o waráké bahá begerant.” ");
INSERT INTO bccl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bale Issáyá gwasht: “Áyán rawagay zalurat nést, shomá wat áyán warák bedayét.” ");
INSERT INTO bccl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Gwashtesh: “Edá may kerrá tahná panch nán o do máhig hast.” ");
INSERT INTO bccl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Gwashti: “Harché shomárá gón, mani kerrá byárét.” ");
INSERT INTO bccl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Gorhá áiá mardom sabzagén káháni sará nendagay parmán dátant, randá panchén nán o doén máhigi zortant, ásmánay némagá cháreti o Hodáay shogri gept, gorhá náni chondh chondh kort o moridáni dastá dátant. Moridán nán mardománi sará bahr kortant. ");
INSERT INTO bccl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sajjahén mardomán tán sérá wárt o moridán angat cha sar átkagén chondhán, dwázdah sapt porr kort. ");
INSERT INTO bccl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Janén o chokkán o abéd, kesás panch hazár mardén atant. Sajjahénán sérá wárt. ");
INSERT INTO bccl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Issáyá hamá damáná morid parmán dát o gwashtant: “Tánke man é mardomán roksata kanán, shomá bójigá swár bét o cha man pésar gwarmay domi némagá berawét.” ");
INSERT INTO bccl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Mardománi rahádag kanagá rand, pa dwá kanagá tahná kóhay sará sar kapt. Rónend at o á wat tahná at. ");
INSERT INTO bccl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Á wahdá, bójig cha tayábá dur rasetagat, trond o tézén gwát o mastén mawj o chawláni ámách at. ");
INSERT INTO bccl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Shapay cháromi pásá, Issá ápay sará gám janán dém pa áyán pédák at. ");
INSERT INTO bccl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wahdé moridán Issá ápay sará gám janán dist, sakk torset o gwashtesh balkén ruhé, paméshká cha torsá kukkáresh kort. ");
INSERT INTO bccl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Bale Issáyá hamá damáná gón áyán gwasht: “Matorsét, é man án.” ");
INSERT INTO bccl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Petrosá gwasht: “Oo Hodáwand! Agan é taw ay, gorhá bell ke man ham ápay sará tai kerrá káyán.” ");
INSERT INTO bccl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Issáyá gwasht: “Byá!” Gorhá Petros cha bójigá gwarmá ér átk o ápay sará Issáay némagá rawagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Bale cha gwátay trondiá torseti o ér boddhagá lagget, gorhá kukkári kort: “Oo Hodáwand! Maná berakkén.” ");
INSERT INTO bccl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Hamá damáná Issáyá dast shahár dát, á gept o gwashti: “Oo kambáwar! Chiá shakket kort?” ");
INSERT INTO bccl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bójigá sar kaptant o gwát kapt o árám but. ");
INSERT INTO bccl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Hamá ke bójigá neshtagatant, Issáesh satá o saná kanáná gwasht: “Béshakk taw Hodáay Chokk ay.” ");
INSERT INTO bccl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wahdé áyán gwarm gwázént Genisáretay shahrá ér átkant. ");
INSERT INTO bccl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Óday mardomán Issá pajjáh áwort, sajjahén hand o damagay á dega mardomesh sahig kortant o sajjahén nádráhesh áiay kerrá áwortant. ");
INSERT INTO bccl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Dazbandiesha kort: “Bell má tai kabáhay lambá dast bejanén o bass.” Áyán ke dasta jat, sajjahén wassh o dráha butant. ");
INSERT INTO bccl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Randá, cha Urshalimá átkagén lahtén Parisi o Sharyatay zánóger Issáay kerrá átk o gwashtesh: ");
INSERT INTO bccl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tai morid chiá may pet o piroki rahbandá próshant o cha waragá pésar dasta nashódant?” ");
INSERT INTO bccl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Áyáni passawá gwashti: “Shomá chiá pa wati dód o rahbandáni dáragá Hodáay hokmána próshét?! ");
INSERT INTO bccl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Hodáyá gwashtag: Wati pet o mátá sharap o ezzat beday o harkas ke wati pet o mátá zá o dwá bedant, báyad ent koshag bebit. ");
INSERT INTO bccl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Bale shomá gwashét: ‘Agan kasé wati pet yá mátá begwashit: “Hamá komak ke man báyad ent shomárá bedátén, á man Hodáay ráhá korbánig kortag,” ");
INSERT INTO bccl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","nun zalurat naent á wati pet o mátá sharap bedant.’ Shomá pa wati dód o rahbandáni dáragá Hodáay habará próshét. ");
INSERT INTO bccl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Oo doru o dopóstén mardomán! Eshayá nabiá cha Hodáay némagá shomay bárawá sharr gwashtag: ");
INSERT INTO bccl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","É mardom dapá maná satá dayant, bale delesh cha man báz dur ent. ");
INSERT INTO bccl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Á moptá maná parastesha kanant o mardománi jórhéntagén ráh o rahbandán sója dayant.” ");
INSERT INTO bccl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Issáyá mardom wati kerrá lóthet o gwashtant: “Gósh bedárét o sarpad bebét. ");
INSERT INTO bccl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Á chizzé ke dapá rawt mardomá nápáka nakant, bale hamá chizz ke cha dapá dara kayt mardomá nápáka kant.” ");
INSERT INTO bccl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nun morid áiay kerrá átkant o gwashtesh: “Zánay ke tai é habarán Parisi tawréntagant?” ");
INSERT INTO bccl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Issáyá passaw dát: “Har nehálé ke mani ásmáni Petá nakeshtag, allamá gwajaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Shomá áyán bay makanét, á kóráni kórén rahshón ant, wahdé yak kóré domi kórá ráhá shóna dant gorhá doén chátá kapant.” ");
INSERT INTO bccl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Petrosá gwasht: “É mesálay mánáyá márá sarpad kan.” ");
INSERT INTO bccl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Issáyá gwasht: “Shomá angat haminkadar násarpad ét? ");
INSERT INTO bccl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nazánét harché ke dapá rawt, lápá mána bit o padá cha rótán dara kayt. ");
INSERT INTO bccl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Bale harché ke cha dapá dara kayt, béhá cha delá páda kayt o hamé chizz ensáná nápáka kant. ");
INSERT INTO bccl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Chiá ke badén pegr o hayál, hón o kósh, zená, bénangi, dozzi, drógén sháhedi o kopr, cha delá chesta bant. ");
INSERT INTO bccl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","É sajjahén, mardomá nápák o palita kanant, bale agan kasé gón nashoshtagén dastán warag bwárt, sell o nápáka nabit.” ");
INSERT INTO bccl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Issáyá á jágah yalah dát o Sur o Saydunay sardhagárá shot. ");
INSERT INTO bccl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kanáni janéné ke hamóday mardomé at átk o kukkári kort: “Oo Hodáwand, oo Dáud bádsháhay chokk! Tará mani sará bazzag bát. Palitén ruhé mani jeneká sakk ázára dant.” ");
INSERT INTO bccl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Bale Issáyá jwábé nadát. Nun moridán dazbandi kort: “Eshiá yal kan, galléni, may randá kaptag o báz kukkár kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Issáyá darráént: “Man bass pa Bani Esráilay gárén méshán ráh dayag butagán.” ");
INSERT INTO bccl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Gorhá janén áiay pádán kapt o gwashti: “Oo Hodáwand! Maná komak kan.” ");
INSERT INTO bccl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Gwashti: “Cha chokkáni dastá nánay pach gerag o kochekáni démá dawr dayag sharr naent.” ");
INSERT INTO bccl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Janéná gwasht: “Oo Hodáwand! Bale kochek wati wáhondáni parzónagay sarárókén naganay thokkorána warant.” ");
INSERT INTO bccl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Gorhá Issáyá áiay passawá gwasht: “Oo bánok! Tai báwar mohr o rédag ent, paméshká hamá dhawl ke taw lóthay anchosha bit.” Hamá damáná áiay jenek dráh but. ");
INSERT INTO bccl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Issáyá á jágah esht o shot, cha Jalilay mazangwarmay tayábá gwast o yak kóhéay sará sar kapt o nesht. ");
INSERT INTO bccl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Bázén mardomé áiay kerrá átk, lang, kór, mondh, lell o dega har paymén nádráhesh, Issáay démá áwortant o Issáyá dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wahdé mardomán dist ke gong habar kanagá ant, mondh dráh bayagá ant, lang tarragá ant o kór gendagá ant, gorhá Esráili hayrán butant o wati Hodáesh satá o saná kort. ");
INSERT INTO bccl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Issáyá wati morid lóthet o gwashtant: “Maná é mardománi sará bazzaga bit, say róch ent mani kerrá ant o nun pa waragá hecchesh nést. Gón shodigén lápá eshán roksat kanaga nalóthán, chó mabit ke ráhá betosant o bekapant.” ");
INSERT INTO bccl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Moridán darráént: “É barr o gyábáná pa inchok mardomay waráká, nán cha kojá byárén?” ");
INSERT INTO bccl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Gorhá Issáyá cha moridán jost kort: “Shomárá chont nán gón?” Gwashtesh: “Hapt nán o lahtén hordén máhig.” ");
INSERT INTO bccl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Áiá mardom zeminay sará nendagay hokm dátant. ");
INSERT INTO bccl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Gorhá haptén nán o máhigi zortant, Hodáay shogri gept, náni chondh chondh kort o moridáni dastá dátant o moridán mardománi sará bahr kortant. ");
INSERT INTO bccl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Sajjahénán sérá wárt o randá cha sar átkagén nánáni chondhán, moridán hapt sapt porr kort. ");
INSERT INTO bccl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Chár hazár mardéná warák wárt, áyán janén o chokk ham gón at. ");
INSERT INTO bccl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mardománi roksat kanagá rand, Issá bójigá nesht o Magadanay sardhagárá shot. ");
INSERT INTO bccl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Parisi o Sadukiáni lahtén mardom Issáay kerrá pa áiay chakkásagá átk o ásmáni neshánié lóthetesh. ");
INSERT INTO bccl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bale Issáyá passaw dát: “Wahdé bégáha bit shomá gwashét: ‘Bóm o hawá wassha bit chiá ke ásmánay rang sohr ent.’ ");
INSERT INTO bccl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sabáhá gwashét: ‘Maróchi tuppána bit chiá ke ásmánay rang moj o hónchak ent.’ É paymá ásmánay rang o neshániáni kesás kanagá zánét, bale zamánag o wahday neshániáni kesás kanagá nazánét. ");
INSERT INTO bccl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Sherr o zenahkárén nasl o padréch neshánia lóthit, bale áyán Yunes nabiay neshániá abéd, dega hech neshánié dayaga nabit.” Randá Issáyá á yalah dátant o shot. ");
INSERT INTO bccl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wahdé morid mazangwarmay domi pahnátá rasetant zántesh ke nánesh shamoshtag. ");
INSERT INTO bccl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Issáyá gón áyán gwasht: “Hozzhár bét! Cha Parisi o Sadukiáni homirá pahréz kanét.” ");
INSERT INTO bccl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Gorhá á watmánwat habar kanagá laggetant: “Wájah paméshká chosha gwashit ke má nán gón wat nayáwortag.” ");
INSERT INTO bccl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Issáyá zánt ke ché gwashagá ant, paméshká gwashti: “Oo kambáwarán! Chiá jérhagá ét ke ‘gón má nán nést,’ ");
INSERT INTO bccl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","angat hecch sarpad nabutagét?! Shomá á panchén nán shamoshtag, ke panch hazár mardomá sérá wárt o cha sar átkagén naganán chont sapt porr kort? ");
INSERT INTO bccl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yá hamá haptén nán ke chár hazár mardomá wárt o sér kort o shomá cha sar átkagénán chont sapt porr kort? ");
INSERT INTO bccl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Gorhá chón sarkecha nawarét ke man gón shomá nánáni bárawá habar nakortag? Cha Parisi o Sadukiáni homirá pahréz kanét.” ");
INSERT INTO bccl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Gorhá morid sarpad butant ke áiá nagwashtag cha ártén homirá pahréz bekanant, cha Parisi o Sadukiáni dars o tálimá watá dur bedárant. ");
INSERT INTO bccl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wahdé Issá Kaysariah Pilipiay sardhagárá átk, cha wati moridán josti kort: “Mardom Ensánay Chokkay bárawá ché gwashant, man kay án?” ");
INSERT INTO bccl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Áyán passaw dát: “Lahténa gwashit pákshódókén Yahyá ay, lahténa gwashit Elyás nabi ay, dega lahténa gwashit Eremiá nabi ay yá cha á dega nabián yakké.” ");
INSERT INTO bccl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Gorhá cha áyán josti kort: “Shomá wat mani bárawá ché gwashét, man kay án?” ");
INSERT INTO bccl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Shamun Petrosá passaw dát: “Taw Masih ay, namiránén Hodáay Chokk.” ");
INSERT INTO bccl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Issáyá darráént: “Oo Shamun, oo Yunáay chokk! Taw bahtáwaré ay, chiá ke é habar ensánéá pa taw záher o paddar nakortag, mani Pet ke ásmáná ent, áiá paddar kortag. ");
INSERT INTO bccl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tará gwashán: Taw Petros ay o é taláray sará man wati kelisáay bonyádá éra kanán ke markay zór áiá hechbar prósha nadant o áiay sará sóbéna nabit. ");
INSERT INTO bccl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Man ásmáni bádsháhiay kelitán tará dayán, zeminay sará harché ke taw makana kanay, ásmáná ham makan kanaga bit, harché ke zeminay sará taw rawá kanay ásmáná ham rawá kanaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Randá áiá wati morid parmán kortant: “Hechkasá magwashét ke man Masih án.” ");
INSERT INTO bccl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Cha hamá wahdá rand Issá gón wati moridán pa tachk o paddari habar kanagá lagget ke “allamá, báyad ent Urshalimá berawán, cha kawmay kamásh, mazanén dini péshwá o Sharyatay zánógeráni dastá sakki o sóri besaggán o koshag bebán o saymi róchá zendag bebán o jáh bejanán.” ");
INSERT INTO bccl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Petrosá á yak kerré kasshet o pa iráz gwashti: “Oo Hodáwand! Hodá chosh makanát. Gón taw hechbar é paymá nabit.” ");
INSERT INTO bccl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Issáyá chak tarrént o gón Petrosá gwashti: “Oo Shaytán! Cha mani démá dur bay. Taw mani ráhá bandagá ay, tai hayál Hodái hayálé naent, ensáni hayálé.” ");
INSERT INTO bccl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Randá Issáyá morid lóthetant o gwashti: “Agan kasé lóthit mani randgiriá bekant, báyad ent wati delay sajjahén lóth o wáhagán yalah bedant o pa sáhay nadr kanagá, wati jenday salibá baddhá bekant o mani ráhá gám bejant. ");
INSERT INTO bccl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Chiá ke, agan kasé wati sáhay rakkénagay johdá bekant, áiá báhénit, bale á ke wati sáhá pa manigia báhénit, áiá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Agan kaséá sajjahén donyá berasit, bale wati sáhá bebáhénit, gorhá á chónén sóbé bárt o ché kattheta kant? Mardom wati sáhá pa che kimmaté bahá zorta kant? ");
INSERT INTO bccl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","“Ensánay Chokk gón wati Petay mazanén shán o marháhá préshtagáni hamráhiá kayt, gorhá harkasá áiay kortagén káráni mozzá dant. ");
INSERT INTO bccl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Shomárá rásténa gwashán, edá lahtén mardom óshtátag ke tán áyáni démá Ensánay Chokkay bádsháhi záher mabit, markay támá nachashant.” ");
INSERT INTO bccl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Shash róchá rand, Issáyá Petros, Ákub o áiay brát Yuhanná, hamráh kortant o yak borzén kóhéay sará bortant ke ódá dega kass mabit. ");
INSERT INTO bccl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ódá áyáni démá Issáay chehrag o dróshom badal but. Áiay dém róchay dhawlá drapshnák but o god o pósháki, espét espét butant. ");
INSERT INTO bccl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Hamá wahdá áyáni démá Mussá o Elyás záher butant o gón Issáyá habar kanagá laggetant. ");
INSERT INTO bccl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Petrosá gón Issáyá gwasht: “Oo Hodáwand! May edá bayag sakk sharr ent, agan tai razá bebit hamedá say sáheg o kápára bandén, yakké pa taw, yakké pa Mussá o degaré pa Elyásá.” ");
INSERT INTO bccl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Hamé wahdá ke angat á habará at, drapshókén jambaréá áyáni sará sáheg kort o cha jambará tawáré átk o gwashti: “É mani dóstén Bacch ent, cha eshiá man báz wassh o razá án, eshiay habarán gósh bedárét.” ");
INSERT INTO bccl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wahdé moridán é tawár eshkot, sakk torsetesh o dém pa chér kaptant. ");
INSERT INTO bccl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bale Issá démá átk, dasti per kortant o gwashti: “Pád áét, matorsét!” ");
INSERT INTO bccl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wahdé áyán chamm pach kortant o cháret, abéd cha Issáyá dega hechkasesh nadist. ");
INSERT INTO bccl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Cha kóhá ér kapagay wahdá Issáyá hokm kortant: “Tán hamá wahdá ke Ensánay Chokká cha mordagán jáh najatag, wati é distagénáni bárawá hechkasá hál madayét.” ");
INSERT INTO bccl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Moridán jost kort: “Sharyatay zánóger chiá gwashant ke cha Masihay áyagá pésar, báyad ent Elyás nabi byayt?” ");
INSERT INTO bccl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Passawi dát: “Elyása kayt o sajjahén kárán gwam o géga kant. ");
INSERT INTO bccl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Bale mana gwashán, Elyás wa átkag, áyán pajjáh nayáwort o harché ke áyáni delá lóthet, gón áiá hamá dhawlesh kort. Hamé dábá Ensánay Chokká ham cha áyáni dastá sakki o sóri saggagi ent.” ");
INSERT INTO bccl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Nun moridán zánt ke á pákshódókén Yahyáay bárawá habar kanagá ent. ");
INSERT INTO bccl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wahdé Issá o sayén morid mardománi mocchiay nazziká átkant, yak mardé Issáay démá átk, kóndhán kapt o gwashti: ");
INSERT INTO bccl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Oo wájah! Tará mani bachakay sará bazzag bát, áiá mergiay nádráhi gón ent o sakk azáb o bazzagia kant, bázén baré ásá kapit o báz bará ápá. ");
INSERT INTO bccl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Man tai moridáni kerrá áwort, bale áyán dráh kort nakort.” ");
INSERT INTO bccl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Issáyá gwasht: “Oo bébáwar o gomráhén nasl o padréch! Man tán kadéná gón shomá bemánán? Tán chinchok wahdá shomárá besaggán? Chokká edá mani kerrá byárét.” ");
INSERT INTO bccl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Issáyá jenn hakkal dát, jenn dar átk o bachak hamá damáná dráh but. ");
INSERT INTO bccl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Randá morid halwatá Issáay gwará átkant o cha áiá jostesh kort: “Má chiá á jenn kasshet nakort?” ");
INSERT INTO bccl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Issáyá passaw dát: “Shomay kambáwariay sawabá. Shomárá rásténa gwashán, agan shomay báwar arzonéay kesásá ham bebit, shomá é kóhá gwashta kanét ke ‘cha edá bekenz o ódá beraw,’ kóha kenzit. Hech chizz pa shomá nabuteni naent. ");
INSERT INTO bccl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bale é dhawlén jenn, abéd cha dwá kanag o róchag dáragá dara nayáyant.” ");
INSERT INTO bccl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wahdé Jalilá yakjáh butant, Issáyá gón áyán gwasht: “Ensánay Chokk dróhaga bit o anchén mardománi dastá dayaga bit ");
INSERT INTO bccl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ke áiá koshant, bale saymi róchá á zendaga bit o jáha jant.” Cha é habarán, áiay morid báz paréshán o deltaparkah butant. ");
INSERT INTO bccl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wahdé Issá o áiay morid Kaparnáhumá rasetant, gorhá mazanén parasteshgáhay songi o máliátgir Petrosay kerrá átkant o jostesh kort: “Tai ostád mazanén parasteshgáhay songá nadant?” ");
INSERT INTO bccl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Passawi dát: “Haw, dant.” Wahdé Petros lógá átk, Issáyá cha áiá pésar hamé jost kort ke “oo Shamun!Donyáay bádsháh cha kayá song o máliáta gerant? Cha wati chokkán yá cha degarán?” ");
INSERT INTO bccl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Passawi tarrént: “Cha degarán.” Issáyá gwasht: “Gorhá chokk bakshaga bant. ");
INSERT INTO bccl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bale pa áyáni naranjénagá, mazangwarmay tayábá beraw o nahigé ápá dawr beday, hamá máhig ke pésará nahigá jant, áiay dapá pach kan, taw yak chárkaldári zarré genday, hamáiá bezur, manig o wati songá porr kan.” ");
INSERT INTO bccl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Hamá wahdá morid Issáay kerrá átkant o jostesh kort: “Bárén, ásmáni bádsháhiá sajjahénáni master o kamásh kay ent?” ");
INSERT INTO bccl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Issáyá kasánén chokké tawár kort, áyáni nyámá óshtárént o ");
INSERT INTO bccl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","gwashti: “Shomárá rásténa gwashán, agan shomá watá badal makanét o kasánén chokkáni paymá mabét, hechbar ásmáni bádsháhiá pád ér korta nakanét. ");
INSERT INTO bccl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Paméshká harkas watá é chokkay dhawlá békebr bekant, ásmáni bádsháhiá hamá cha sajjahénán mastera bit. ");
INSERT INTO bccl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Harkas pa mani námá, gón washwáhagi é dhawlén chokké wati gwará bedárit, bezán áiá maná dáshtag. ");
INSERT INTO bccl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Harkas, cha é kasánokénán ke mani sará báwarmand ant yakkéá dém pa gonáhá bebárt, pa áiá gehter ent ke jenteri táé áiay gardená bebandant o daryáay johlánkián chagal bedayant. ");
INSERT INTO bccl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Zár o wáwaylá pa é donyáyá ke gomráhiáni sawab ent. Nabit ke mardom rad majant o thagal mawárt, bale apsóz pa hamá kasá ke radiáni sáchók o sawabsáza bit. ");
INSERT INTO bccl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Agan tai dast yá pád tará dém pa gonáhá bebárt, áiá borr o dawr day, chiá ke gón doén dast o pádán tahtarunay dáemi ásá kapagay badalá, pa taw sharter hamesh ent ke lang o mondh, namiránén zenday wáhond bebay. ");
INSERT INTO bccl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Agan tai chamm tará dém pa gonáhá bebárt, áiá ham dar kan o dawr day, chiá ke gón doén chammán dózahay ásá kapagay badalá, pa taw sharter hamesh ent ke gón yak chamméá namiránén zenday wáhond bebay. ");
INSERT INTO bccl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Hozzhár bét. Cha é kasánénán yakkéá ham kamarzesh mazánét o ér majanét. Man shomárá gwashán ke ásmáná esháni préshtag, modám mani ásmáni Petay chehragá gendant. ");
INSERT INTO bccl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ensánay chokk pa gonahkár o gárénáni rakkénagá átkag. ");
INSERT INTO bccl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Shomá ché gwashét? Agan kaséá sad mésh bebit o cha áyán yakké gár bebit, gorhá nawad o nohén méshán kóhá yalaha nadant o gárén méshay shóházá narawt? ");
INSERT INTO bccl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Shomárá rásténa gwashán, agan gárén méshá dar begéjit, cha á nawad o nohén gár nabutagénán, pa eshiá géshter gal o shádehia kant. ");
INSERT INTO bccl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Hamé paymá, shomay ásmáni pet cha é kasánénán yakkéay gár bayagá ham razá nabit. ");
INSERT INTO bccl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Agan tai brát radié bekant, beraw o mán halwatá cha á gonáhá sahigi bekan, agan tai habari gósh dásht, gorhá bezán tará wati brát raset. ");
INSERT INTO bccl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Bale agan tai habari namannet, gorhá yak o do kas hamráh bekan, chiá ke har chizzay rásti, gón do yá say mardomay sháhediá paddar kanag bebit. ");
INSERT INTO bccl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Agan áyáni habari namannet, gorhá kelisáyá hál beday, bale agan kelisáay habari ham gósh nadásht, gorhá áiá nábáwaráni dhawlá bezán. ");
INSERT INTO bccl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Shomárá rásténa gwashán, harché ke shomá zeminay sará makana kanét, ásmáná ham makan kanaga bit, harché ke shomá zeminay sará rawá kanét, ásmáná ham rawá kanaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Man shomárá é ham gwashán, agan zeminay sará cha shomá do kas, pa hamdeli o tepák chizzé belóthit, har wáhagé ke bebit, cha mani ásmáni Petay némagá áyána rasit. ");
INSERT INTO bccl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Chiá ke har jáh do yá say kas mani námay sará hór bebit, man gón áyán góna bán.” ");
INSERT INTO bccl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Hamá wahdá Petrosá cha Issáyá jost kort: “Oo Hodáwand! Agan mani brát gón man badi bekant, gorhá tán chont randá man áiá pahell bekanán? Tán hapt randá?” ");
INSERT INTO bccl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Issáyá passaw dát: “Man tará gwashán, hapt randá na. Haptá, haptád randá hesáb kan o bebakshi. ");
INSERT INTO bccl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Chiá ke ásmáni bádsháhi, hamá bádsháhay dhawlá ent ke cha wati golámán hesáb geragi lóthet. ");
INSERT INTO bccl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wahdé hesáb geragá lagget, yak mardé áiay démá áwortesh ke lakkáni lakk wámdár at, ");
INSERT INTO bccl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","bale áiá wám dát nakortant. Paméshká hodábondá parmán kort ke á wat gón jan o chokkán o dega harché ke áiá hastat, bahá kanag o wám gerag bebant. ");
INSERT INTO bccl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Golám áiay pádán kapt o mennat o zári kort o gwashti: ‘Maná móh beday, tai sajjahén wámána dayán.’ ");
INSERT INTO bccl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Hodábondá golámay sará bazzag but, cha á wámán sar gwast o ázáti kort. ");
INSERT INTO bccl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Bale wahdé á golám dhanná dar átk, wati hamkárén golámi dist ke áiay sad dináray wámdár at, dasti gotthá sakk dátant o gwashti: ‘Mani wámán beday.’ ");
INSERT INTO bccl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Áiay pádán kapt o mennat o zári kort o gwashti: ‘Maná móh beday, tai sajjahén wámána dayán.’ ");
INSERT INTO bccl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Bale áiá namannet o tán wámáni dayagá jélá bandi kort. ");
INSERT INTO bccl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","É dega golám cha é sargwastay gendagá báz delranj butant o sajjahén hál o habaresh pa wati hodábondá sar kort. ");
INSERT INTO bccl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Gorhá hodábondá á golám lóthet o gwashti: ‘Oo radkárén golám! Man wám tará paméshká bakshetant ke taw gón man báz mennat o zári kort. ");
INSERT INTO bccl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Anchosh ke maná tai sará bazzag butagat, tará ham báyad wati wámdáray sará bazzag butén.’ ");
INSERT INTO bccl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Hodábond zahr gept o á golámi tán sarjamén wámáni dayagá band kanáént. ");
INSERT INTO bccl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nun agan shomá wati brátá pa del mabakshét, mani ásmáni pet ham gón shomá hamé dhawlá kant.” ");
INSERT INTO bccl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wahdé Issáyá é habar halás kortant, Jalilay damagi yalah dát o dém pa Yahudiahay hamá hand o damagá shot ke Ordonay kawray domi pahnátá ent. ");
INSERT INTO bccl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Mardománi mazanén rombé áiay randá gón at o Issáyá ódá áyáni nádráhén mardom dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Lahtén Parisi, Issáay chakkásagá áiay kerrá átk o jostesh kort: “Bárén, pa mardá rawá ent ke wati janay talák o sawnán bedant, sawab toré harché bebit?” ");
INSERT INTO bccl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Passawi tarrént: “Shomá nawántag ke Hodáyá jahánay jórhénagay wahdá ensán mardén o janén addh kortag o ");
INSERT INTO bccl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","gwashtagi: Paméshká, mard cha wati pet o mátá jetá o gón wati janá hór o yakjáha bit. Mard o jan, yak jesm o jána bant. ");
INSERT INTO bccl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","É paymá, nun á do naant, yak jesm o ján ant. Paméshká, á ke Hodáyá yakk kortagant, ensán áyán jetá makant.” ");
INSERT INTO bccl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jostesh kort: “Gorhá parchá Mussáyá parmán dátag ke mard pa wati janay sawn dayagá, áiá taláknámahé bedant o begisshéniti?” ");
INSERT INTO bccl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Issáyá passaw dát: “Mussáyá shomay sengdeliay sawabá janénáni sawn dayag rawá kortag, cha bongéjá é dhawl nabutag. ");
INSERT INTO bccl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Shomárá gwashán: Harkas cha zenahkáriá abéd, pa dega sawabéá wati janénay sawn o talákán bedant o gón dega janénéá sur o sáng bekant, bezán zená kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Moridán gwasht: “Agan mard o janay nyámá jáwar é dhawlá ent gorhá sur nakanag sharter ent.” ");
INSERT INTO bccl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Gwashti: “É tálimá harkas zorta nakant, hamá kas zorta kant ke áiá é wák o twán bakshag butag. ");
INSERT INTO bccl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Lahtén sur korta nakant chiá ke cha mátay lápá é dhawlá pédá butag, lahtén cha mardománi dastá anchosh butag o lahtén pa ásmáni bádsháhiá cha sur o árósá sara gwazit. Agan kasé é habará saggit, hamé dhawlá bekant.” ");
INSERT INTO bccl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Á wahdá kasánén chokkesh Issáay kerrá áwortant ke wati dastá áyáni sará per bemoshit o dwá bekant, bale moridán neherr o hakkal dátant. ");
INSERT INTO bccl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Issáyá gwasht: “Chokkán bellét mani kerrá byáyant, áyáni démá madárét, chiá ke ásmáni bádsháhi anchén mardománig ent.” ");
INSERT INTO bccl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Nun Issáyá áyáni sará dast per mosht. Gorhá wati ráhi gept o shot. ");
INSERT INTO bccl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Padá yak mardé Issáay kerrá átk o josti kort: “Oo ostád! Man kojám nékén kárán bekanán ke namiránén zenday wáhond bebán?” ");
INSERT INTO bccl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Issáyá gwasht: “Taw chiá nékiay bárawá cha man josta kanay? ‘Nékén’ tahná yakké, á Hodáay jend ent, agan taw zendmána lóthay, gorhá Hodáay hokmáni sará kár kan.” ");
INSERT INTO bccl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Josti kort: “Kojám hokmáni sará?” Issáyá gwasht: “Hón makan, zená makan, dozzi makan, drógén sháhedi maday, ");
INSERT INTO bccl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wati pet o mátá ezzat beday, gón wati hamsáhegá wati jenday paymá mehr bekan.” ");
INSERT INTO bccl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Warnáén mardá gón Issáyá gwasht: “É sajjahén man kortagant. Dega kojám kár pasht kaptag?” ");
INSERT INTO bccl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Issáyá passaw dát: “Agan lóthay tamánén ensáné bebay, beraw wati sajjahén mál o hastiá bahá kan o zarrán garib o nézgárén mardománi sará bahr kan, é paymá tará ásmáni ganjé rasit. Gorhá byá o mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Anchosh ke warnáyá é habar eshkot, báz gamig o paréshán but o shot, chiá ke á sér o azgárén mardé at. ");
INSERT INTO bccl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Issáyá gón moridán gwasht: “Shomárá rásténa gwashán, pa azgár o máldárén mardomán ásmáni bádsháhiá pád ér kanag sakk grán ent. ");
INSERT INTO bccl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Haw, shomárá gwashán: Suchenay domká oshteray gwazag wa báz grán ent, bale Hodáay bádsháhiá, zardárén mardomay rawag angat gránter ent.” ");
INSERT INTO bccl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","É habaray eshkonagá, morid sakk hayrán butant o watmánwatá gwashtesh: “Gorhá kay rakketa kant?” ");
INSERT INTO bccl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Issáyá áyáni némagá cháret o gwashti: “Pa ensáná nabuteni ent, bale Hodáay dastá har chizz buta kant.” ");
INSERT INTO bccl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Gorhá Petrosá gwasht: “Má wati har chizz yalah dátag o tai randgiriá kanagá én, bárén márá ché rasit?” ");
INSERT INTO bccl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Issáyá gón áyán gwasht: “Shomárá rásténa gwashán, hamá nókén donyáyá wahdé Ensánay Chokk wati shán o shawkatay tahtay sará nendit, shomá ke mani hamráh ét, dwázdah tahtay sará nendét o Bani Esráilay dwázdahén kabilaháni dádrasiá kanét. ");
INSERT INTO bccl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Harkasá pa mani námaygi lóg, brát o gohár, pet o mát, chokk yá mál o dhagár yalah dátagant, áiá sad sari géshtera rasit o abadmánén zenday wáhonda bit. ");
INSERT INTO bccl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Bale bázéné ke awali ent, áheria bit o hamá ke áheri ent awalia bit. ");
INSERT INTO bccl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ásmáni bádsháhi, bágéay hamá hodábonday paymá ent ke pa wati anguri bágá, kárendahay shóházá máhallah dar kapt. ");
INSERT INTO bccl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Áiá, róchmozz yak dináré gisshént o kárendah pa kárá bágá rawán dátant. ");
INSERT INTO bccl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kesás say sáhatá rand dar átk o disti lahtén kárendah bázárá békár óshtátag. ");
INSERT INTO bccl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Gwashti: ‘Shomá ham berawét mani bágá kár kanét. Harché ke shomay hakka bit, shomárá dayán.’ ");
INSERT INTO bccl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gorhá á shotant. Padá némróchá o dém pa bégáhá dhanná dar átk o anchoshi kort. ");
INSERT INTO bccl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Rónenday nazziká padá dar átk o disti dega lahtén mardom óshtátag, cha áyán josti kort: ‘Chiá shomá sajjahén róchá békárá óshtátagét?’ ");
INSERT INTO bccl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Gwashtesh: ‘Márá hechkasá kár nadátag.’ Bágay hodábondá gwasht: ‘Shomá ham berawét o bágá kár kanét.’ ");
INSERT INTO bccl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Rónend but o hodábondá gón wati kármasterá gwasht: ‘Godhsari kárendahán beger tán awaligénán, sajjahénáni mozzá beday.’ ");
INSERT INTO bccl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Hamáyán ke rónenday nazziká kár bongéj kortagat, harkasá yak dináré mozz raset. ");
INSERT INTO bccl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Randá hamáyáni bárig átk ke pésará káresh bongéj kortagat, áyáni hayál at ke géshteresha rasit, bale áyán ham yak yak dináré raset. ");
INSERT INTO bccl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wati mozzesh zort o bágay hodábonday sará norondhagá laggetant o gwashtesh: ");
INSERT INTO bccl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Cha sajjahénán o rand átkagén kárendahán yak sáhaté kár kortag o má sajjahén róchá garmi saggetag o kár kortag, bale taw mayg o áyáni mozz barábar kortant.’ ");
INSERT INTO bccl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bágay hodábondá gón yakkéá gwasht: ‘Oo mani sangat! Man gón taw náhakki nakortag. Taw wat gón man róché yak dináréá namannetag? ");
INSERT INTO bccl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Paméshká haminchok ke tai hakk ent bezur o beraw. É mani tab ent ke harché tará dayán, haminchok cha taw rand átkagén kárendahán ham bedayán. ");
INSERT INTO bccl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Záná, man wati zarráni master wat naán, har dhawlá ke lóthán gón wati zarrán hamá dhawl bekanán? Yá ke tai chamm mani daspachiá dista nakant?’ ");
INSERT INTO bccl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","É dhawlá, á ke awali ant, áheria bant o hamá ke áheri ant, awalia bant.” ");
INSERT INTO bccl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Urshalimay rawagay wahdá, ráhá, Issáyá dwázdahén morid yak kerré bortant o gwashti: ");
INSERT INTO bccl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nun má Urshalimá rawagá én, ódá Ensánay Chokká gerant o mazanén dini péshwá o Sharyatay zánógeráni dastá dayant. Áiay markay hokmá borrant o ");
INSERT INTO bccl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","darkawmén mardománi dastá dayanti. Darkawmén mardom áiay sará rishkand o maskará kanant, gón hayzarán mána bandant o salibay sará dranjanti. Bale saymi róchá, á padá zendaga bit o jáha jant.” ");
INSERT INTO bccl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Hamé wahdá Zebdiay chokkáni mát, wati chokkáni hamráhiá Issáay kerrá átk, áiay pádán kapt o lótheti ke pa mennatgiri chizzé begwashit. ");
INSERT INTO bccl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Issáyá cha áiá jost kort: “Begwash, ché lóthay?” Gwashti: “Wahdé tai bádsháhia kayt, labz kan ke mani doén chokkán gón wata nendárénay, yakkéá wati rástén o domiá chappén némagá.” ");
INSERT INTO bccl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Issáyá passaw dát: “Shomá nazánét ché lóthagá ét. Bárén, á jámá ke mana nóshán shomá nósheta kanét?” Gwashtesh: “Ji haw, má wártia kanén.” ");
INSERT INTO bccl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Issáyá gwasht: “Shomárá mani jám nóshagi ent, bale é mani dastá naent ke kay mani rástén o kay chappén némagá benendit. É jágah hamáyánig ant ke mani Petá pa áyán gisshéntagant.” ");
INSERT INTO bccl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wahdé á dega dahén moridán é habar eshkot, doén brátáni sará zahr geptant. ");
INSERT INTO bccl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gorhá Issáyá sajjahén morid lóthetant o gwashti: “Shomá zánét ke darkawmáni hákem mardománi sará hákemia kanant o kawmáni master wati chérdastén mardománi sará wati ehtiárá kára bandant. ");
INSERT INTO bccl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Bale shomá chosh makanét. Cha shomá harkas ke mazania lóthit báyad ent sajjahénáni hezmatkár bebit o ");
INSERT INTO bccl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","cha shomá harkas ke masteria lóthit, shomay kaster o dazbój bebit. ");
INSERT INTO bccl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Hamé dhawlá, Ensánay Chokk nayátkag ke mardom áiay hezmatá bekanant, átkag ke mardománi hezmatá bekant o gón wati sáhay dayagá, bázénéá berakkénit.” ");
INSERT INTO bccl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wahdé cha Ariháay shahrá dar áyagá atant, bázén mardomé Issáay randá gón at. ");
INSERT INTO bccl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Áyáni ráhay sará neshtagén do kórá eshkot ke Issá cha ódá gwazagá ent, kukkáresh kort o gwashtesh: “Oo Hodáwand, oo Dáud bádsháhay chokk! Tará may sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mardomán á hakkal dátant o gwashtesh: “Bétawár bét,” bale áyán géshter kukkár kort: “Oo Hodáwand, oo Dáud bádsháhay chokk! Tará may sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Issá óshtát o josti kort: “Shomá cha man ché lóthét? Pa shomá ché bekanán?” ");
INSERT INTO bccl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Áyán passaw dát: “Oo Hodáwand! Márá biná kan.” ");
INSERT INTO bccl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Issáyá áyáni sará bazzag but, dasti chammán per moshtant o hamá damáná biná butant o Issáay randá gón kapt o shotant. ");
INSERT INTO bccl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wahdé Urshalimay nazziká átkant o Zaytunay kóhay dámoná Bayt-Pájiay métagá rasetant, Issáyá do morid rawán dát o ");
INSERT INTO bccl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","gwashtanti: “Démi métagá berawét, anchosh ke ódá rasét haré gendét ke bastag o korragi ham gón ent, áyán bójét o pa man byárét. ");
INSERT INTO bccl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Agan kaséá gón shomá chizzé gwasht, begwashét: ‘Wájahá pakár ant o randá ráhesha dant.’” ");
INSERT INTO bccl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Paméshká é dhawlá but tán hamá chizz ke nabiay zobáná péshgói kanag butag, rást o paddar bebit: ");
INSERT INTO bccl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Gón Sahyunay Jeneká begwashét: ‘Nun tai bádsháh tai gwará békebr pédák ent o haréá, bezán korragéá swár ent.’” ");
INSERT INTO bccl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Gorhá morid shotant o hamá paymá ke Issáyá gwashtagat, hamá dhawlá kortesh. ");
INSERT INTO bccl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Áyán har o korrag áwortant, wati shál o cháderesh haráni poshtá ér kortant o Issá swár but. ");
INSERT INTO bccl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bázénéá wati shál o cháder ráhay sará chérgéján kortant, dega bázén mardoméá drachkáni thál o ták borret o ráhay sará ér kort. ");
INSERT INTO bccl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Issáay péshromb o padrombén mardom, kukkár kanáná gwashagá atant: “Hushiáná, oo Dáud bádsháhay chokk! Mobárak bát hamá ke pa Hodáwanday námá kayt, Hushiáná, borzén arshá.” ");
INSERT INTO bccl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wahdé Issá Urshalimá raset gorhá shór o walwalahé macchet. Shahray mardom jostá atant ke “é kay ent?” ");
INSERT INTO bccl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Mocchiay mardomán passaw dát: “É hamá nabi ent, Issá ke Jalilay shahr Náserahay nendóké.” ");
INSERT INTO bccl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Issá mazanén parasteshgáhay péshjáhá shot o ódá sawdáger o grákáni gallénag o dar kanagá goláésh but. Zarr badal kanókén sarrápáni mizz o barónki chappig kortant o kapót bahá kanókáni korsi o tahtagi dawr dátant. ");
INSERT INTO bccl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Gwashti: “Hodáay Ketábá nebisag butag: mani lóg, dwá o parasteshay jágah bebit, bale shomá dozzbázáré kanéti.” ");
INSERT INTO bccl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mazanén parasteshgáhay péshjáhá, bázén kór o lang Issáay kerrá átkant o áiá dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wahdé mazanén dini péshwá o Sharyatay zánógerán Issáay mójezah o ajekkái distant o é ham distesh ke parasteshgáhá kasánén chokk pa kukkár “Hushiáná, oo Dáud bádsháhay chokk” gwashagá ant, báz nawassh butant o ");
INSERT INTO bccl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","cha Issáyá jostesh kort: “Eshkonagá ay é chokk ché gwashagá ant?” Gwashti: “Haw! Eshkonagá án. Shomá hechbar nawántag ke: ‘Taw pa wat satá o saná, chokk o shirmechén nonnokáni dapá ham dátag ke tará satá bekanant’?” ");
INSERT INTO bccl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Gorhá Issáyá á yalah kortant o cha shahrá dhann dar átk o Bayt-Anyáay métagá wati shapi róch kort. ");
INSERT INTO bccl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wahdé Issá sabáhá máhallah per tarrag o shahray némagá rawagá at, shodig but. ");
INSERT INTO bccl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ráhay sará enjiray drachké disti, áiay némagá shot bale abéd cha táká dega hecchi nadist. Gorhá gwashti: “Dega baré, hechbar burr o bar makanátay” o hamá damáná drachk gimmort o hoshk but. ");
INSERT INTO bccl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Eshiay gendagá morid hayrán butant. Jostesh kort: “Chón but ke yak anágat drachk gimmort?” ");
INSERT INTO bccl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Issáyá passaw dát: “Shomárá rásténa gwashán, agan shomárá báwar ent o delá shakka nayárét, gorhá hamá dhawlá ke man gón enjiray drachká kortag, shomá ham anchosh o angat géshter korta kanét. Agan shomá é kóhá begwashét ke ‘watá cha edá chest kan o daryáay tahá dawr beday,’ gorhá hamé dhawlá bit. ");
INSERT INTO bccl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Agan shomá báwar kanét, harché ke wati dwáyáni tahá lóthét, shomárá dayaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Hamá wahdá ke Issá mazanén parasteshgáhay péshjáhá shot o tálim dayagá lagget, mazanén dini péshwá o kawmay kamásh áiay kerrá átkant o jostesh kort: “Taw gón kojám hakk o ehtiárá é kárána kanay? Kayá tará é káráni kanagay ehtiár dátag?” ");
INSERT INTO bccl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Issáyá passaw dát o gwashti: “Maná ham cha shomá josté hast, agan mani jostay passawá bedayét, gorhá shomárá gwashán ke gón kojám hakk o ehtiárá é kárána kanán. ");
INSERT INTO bccl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Shomay hayálá, Yahyáyá cha kojá pákshódi dayagay ehtiár rasetagat, cha ásmáná yá cha ensánay némagá?” Áyán watmánwatá shawr o saláh kort o gwashtesh: “Agan begwashén cha ásmáná at, gorhá márá gwashit: ‘pa ché áiay sará imánó nayáwort?’ ");
INSERT INTO bccl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Agan begwashén ke cha ensánay némagá butag, gorhá márá cha mardomána torsit chiá ke sajjahén mardomán mannetag ke Yahyá nabié.” ");
INSERT INTO bccl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Paméshká passawesh dát: “Má nazánén.” Issáyá gwasht: “Gorhá man ham shomárá nagwashán ke gón kojám hakk o ehtiárá é kárána kanán.” ");
INSERT INTO bccl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Nun shomá ché gwashét? Yak mardé hastat, áiay do bacch atant. Wati masterén bacchay kerrá shot o gwashti: ‘Oo mani chokk! Maróchi beraw anguri bágá kár kan.’ ");
INSERT INTO bccl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Áiá passaw dát: ‘Mana narawán,’ bale randá pashómán but o shot. ");
INSERT INTO bccl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Gorhá domi bacchay kerrá shot o hamé dhawlá gwashti. Bacchá passaw dát: ‘Ji haw, mani wájah! Mana rawán,’ bale nashot. ");
INSERT INTO bccl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Cha é doénán kojám bacchá wati petay habar zort?” Áyán passaw dát: “Awaligá.” Issáyá gón áyán gwasht: “Báwar kanét, songi o máliátgir o chalandhén janén cha shomá pésar Hodáay bádsháhiá rawant. ");
INSERT INTO bccl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Chiá ke Yahyá pahrézkáriay ráh o rastahá shomay kerrá átk, bale shomá áiay sará báwar nakort, songi o chalandhén janénán áiay sará báwar kort o shomá é chizz gón wati chammán dist, angat pashómán nabutét o báwaró nakort. ");
INSERT INTO bccl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Dega yak mesálé gósh dárét: Zemindáréá anguri bágé addh kort o áiay chapp o chágerdá pall o pasili bast, pa anguráni shiragay geragá, kall o kombé jórhi kort o pa negahpániá yak borjé ham basti. Randá bági pa konandahkári o zamán lahtén bágpánay dastá dát o wat saparéá shot. ");
INSERT INTO bccl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wahdé anguray mósom but, pa wati bahray geragá, hezmatkári zamánzurén bágpánáni kerrá ráh dátant. ");
INSERT INTO bccl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Bágpánán áiay hezmatkár geptant, yakké latth o kotthesh kort, domi ham jat o kosht o saymiesh sengsár kort. ");
INSERT INTO bccl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Randá, cha pésarigénán géshter hezmatkári ráh dát, bale bágpánán gón áyán ham hamé dhawlá kort. ");
INSERT INTO bccl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Godhsará, wati chokki ráh dát, hayáli kort balkén áiay ruá bedárant. ");
INSERT INTO bccl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Bale wahdé bágpánán áiay chokk dist, watmánwatá gwashtesh: ‘Bágay mirás barók hamesh ent, byáét bekoshéni tán eshiay melk o mirásay hodábond wat bebén.’ ");
INSERT INTO bccl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Gorhá gept o cha bágá dhann bort o koshtesh. ");
INSERT INTO bccl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Nun wahdé anguray bágay hodábonda kayt, gón é bágpánán ché kant?” ");
INSERT INTO bccl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Áyán passaw dát: “Á, é badkerdén bágpánán gár o bégwáha kant o bágá dega bágpánáni dastá dant ke áiay bahrá pa wahda dayant.” ");
INSERT INTO bccl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Issáyá cha áyán jost kort: “Shomá Hodáay Pákén Ketábán nawántag: Á seng ke bánbandén ostáyánpasond nakort o nazort hamá seng, bonheshtbut. É Hodáwanday kár ent o may chammán ajab ent.” ");
INSERT INTO bccl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Paméshká gón shomá gwashán ke Hodáay bádsháhi, cha shomá pach gerag o yak kawméá dayaga bit ke áiay bar o samará kárit. ");
INSERT INTO bccl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Kasé ke hamé sengay sará kapit, thokkor thokkora bit o kasé ke seng áiay sará kapit, hurta bit.” ");
INSERT INTO bccl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wahdé mazanén dini péshwá o Parisián Issáay mesál eshkotant, sarpad butant ke á hamáyáni bárawá habar kanagá at. ");
INSERT INTO bccl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Lóthetesh Issáyá dazgir bekanant, bale cha mardomána torsetesh, chiá ke mardománi chammá Issá paygambaré at. ");
INSERT INTO bccl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Issáyá padá gón mardomán pa mesál o darwar habar kort o gwasht: ");
INSERT INTO bccl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ásmáni bádsháhi, hamá bádsháhay paymá ent ke pa wati chokkay árósá mehmánié korti. ");
INSERT INTO bccl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Golámi lóthetagén mehmánáni randá ráh dátant, bale áyáni delá nalóthet byáyant. ");
INSERT INTO bccl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Gorhá áiá dega lahtén golám ráh dát o hokmi kort ke gón hamá lóthetagén mardomán begwashant: ‘Shámon tayár kortag, káigar o pábondi gwask helár kanag butagant o har chizz tayár ent, byáét árósay mehmániá gón bebét.’ ");
INSERT INTO bccl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bale parwáhesh nakort o harkas wati káray némagá shot, yakké dhagáráni némagá o yakké dém pa wati sawdágeriá. ");
INSERT INTO bccl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Á degarán áiay golám gept o sobakk o béezzat kort o koshtant. ");
INSERT INTO bccl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bádsháh sakk zahr gept o pa hónigáni janag o áyáni shahray sóchagá sepáhigi ráh dátant. ");
INSERT INTO bccl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Gorhá gón wati golámán gwashti: ‘Árósay mehmáni tayár ent, bale hamá ke lóthag butagatant, áyagay láhek naatant. ");
INSERT INTO bccl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Paméshká berawét chárráháni sará harkasá ke gendét, áyán mani mehmániá byárét.’ ");
INSERT INTO bccl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Bádsháhay golám shotant o sharr o gandah, harkasesh ke dist, sajjahénesh yakjáh kort o áwortant o árósay tálár cha mehmáná porr but. ");
INSERT INTO bccl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Nun wahdé bádsháh mehmánáni cháragá átk, yak anchén mardé disti ke suri godi gwará naat. ");
INSERT INTO bccl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Bádsháhá cha áiá jost kort: ‘Hambal! Bé suri pósháká, taw chón tóká potertagay?’ Bale áiá hech passaw dát nakort. ");
INSERT INTO bccl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Gorhá bádsháhá gón wati golámán gwasht: ‘Eshiay dast o pádán bandét o dhanná taháriá dawr bedayét.’ Ódá gréwant o dantán pa dantána droshant. ");
INSERT INTO bccl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Chiá ke lóthetagén báz ant, bale gechén kortagén kamm.” ");
INSERT INTO bccl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Hamé wahdá Parisi shotant o anchén pandal o repké kortesh ke Issáyá chón cha áiay jenday habarán mán begisshénant o dámá dawr bedayant. ");
INSERT INTO bccl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Nun lahtén shágerdesh gón Hirudiáni hamráhiá áiay kerrá rawán dát tán begwashant: “Oo ostád! Má zánén ke taw tachk o rástén mardomé ay o Hodáay ráhá pa rástiá sója dayay o hechkaséay némagá nageray, chiá ke sajjahénán pa yak chamméá cháray. ");
INSERT INTO bccl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Márá begwash, tai hayálá Rumay bádsháh Kaysará song o máliát dayag rawá ent yá na?” ");
INSERT INTO bccl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Issáyá áyáni gandahén pegr zánt o gwashti: “Oo dopóstén shatalkárán! Chiá maná chakkásagá ét? ");
INSERT INTO bccl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Cha hamá zarrán ke pa máliátá dayant, yakké maná pésh bedárét.” Áyán yak dináré pésh kort. ");
INSERT INTO bccl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Issáyá cha áyán jost kort: “Eshiay sará kai nám o naksh per ent?” ");
INSERT INTO bccl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Gwashtesh: “Kaysaray.” Nun Issáyá darráént: “Gorhá Kaysaraygá Kaysará bedayét o Hodáaygá Hodáyá bedayét.” ");
INSERT INTO bccl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","É habaráni eshkonagá á hayrán butant o Issáesh esht o shotant. ");
INSERT INTO bccl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Randá, lahtén Saduki ke áheratay namannók ant, Issáay kerrá átk o jostesh kort: ");
INSERT INTO bccl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Oo ostád! Mussáyá gwashtag: ‘Agan kasé bé poshtpadá bemerit, báyad ent áiay brát gón áiay janózámá sur bekant, tán pa wati brátá rand o ráhé bellit.’ ");
INSERT INTO bccl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","May némagá hapt brát hastat. Awali brátá sur kort, bé chokká mort o wati jani pa á dega brátá esht. ");
INSERT INTO bccl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Padá gón domi o saymi tán haptomiá anchosh but. ");
INSERT INTO bccl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Godhsará, á janén ham mort. ");
INSERT INTO bccl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nun taw begwash, áheratay róchá é janén cha haptén brátán kojám brátayga bit? Chiá ke sajjahén brátán bárig bárigá gón áiá sur kortagat.” ");
INSERT INTO bccl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Issáyá passaw dát: “Shomá rad wártag, chiá ke na cha Pákén Ketábán chizzé sarkecha warét o na Hodáay wák o zórá sarpada bét. ");
INSERT INTO bccl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Áheratá, na kasé sura kant o na sur dayaga bit, ásmáni préshtagáni dhawlá bant. ");
INSERT INTO bccl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Mordagáni padá zendag bayag o jáh janagay bárawá, záná shomá hamá habar nawántag ke Hodáyá shomárá gwashtagat: ");
INSERT INTO bccl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Man án, Ebráhémay Hodá, Eshákay Hodá o Ákubay Hodá? Bezán á, mordagáni Hodá naent, zendagénáni Hodá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Mardom cha Issáay é habaráni eshkonagá hayrán o habakkah butant. ");
INSERT INTO bccl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wahdé Parisi sahig butant ke Issáyá chón gón wati passawá Sadukiáni dap bastag, gorhá hór but o átkant. ");
INSERT INTO bccl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Cha áyán yakkéá, ke Sharyatay kázié at, pa Issáay chakkásagá cha áiá jost kort: ");
INSERT INTO bccl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Oo ostád! Sharyatay masterén hokm kojám ent?” ");
INSERT INTO bccl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Issáyá passaw dát: “Wati Hodáwandén Hodáyá pa del, gón sajjahén ján o sáh o gón sajjahén pahm o pegrá dóst bedár. ");
INSERT INTO bccl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Cha sajjahénán masterén o awali hokm hamesh ent. ");
INSERT INTO bccl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Domi hokm ham, hameshiay dhawlá ent: Gón wati hamsáhegá wati jenday paymá mehr bekan. ");
INSERT INTO bccl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Hamé doén hokm, Mussáay Sharyat o sajjahén nabiáni parmánáni bonyád ant.” ");
INSERT INTO bccl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Hamé wahdá ke Parisi yakjáh mocch atant, Issáyá cha áyán jost kort: ");
INSERT INTO bccl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Masihay bárawá shomá ché gwashét? Á kai chokk ent?” Áyán passaw dát: “Dáud bádsháhay chokk ent.” ");
INSERT INTO bccl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nun gwashti: “Gorhá chiá Dáud cha Pákén Ruhay shobén o elhámá, áiá wati Hodáwanda zánt, wahdé gwashit: ");
INSERT INTO bccl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Hodáwandá gón mani Hodáwandágwasht: ‘Mani rástén némagá benend tán hamá wahdá ke tai dozhmenán tai pádáni chérá dawr bedayán.’ ");
INSERT INTO bccl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Nun agan Dáud, Masihá wati Hodáwanda gwashit, gorhá Masih chón áiay chokk buta kant?” ");
INSERT INTO bccl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Hechkasá áiay habaráni passaw dát nakort o cha á róchá o rand, kaséá ham cha áiá jost kanagay del o joryat néstat. ");
INSERT INTO bccl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Á wahdá Issáyá gón mocchiay mardomán o wati moridán habar kort o gwasht: ");
INSERT INTO bccl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Sharyatay zánóger o Parisi, Mussáay jáhá neshtagant. ");
INSERT INTO bccl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Paméshká harché ke shomárá tálima dayant, áyáni habarán bemannét o á habaráni randgiriá bekanét, bale áyáni dhawlá mabét, parchá ke harché á tálima dayant, wat á dhawlá nakanant. ");
INSERT INTO bccl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Anchén gránén bára bandant o mardománi kópagá laddhant ke chest kanaga nabant, bale wat pa áyáni chest kanagá lankok o mórdánagé ham nasorénant. ");
INSERT INTO bccl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Á harché ke kanant, pa mardománi pésh dáragá kanant o bass. Wati táitán mazana kanant o kabáhay lambán drájkassh. ");
INSERT INTO bccl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Mehmánián, awali reday nendagesh dóst ent o kanisaháni sharterén jáhán gechéna kanant. ");
INSERT INTO bccl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Bázáráni tarr o garday wahdá lóthant ke mardom áyán wasshátk o drahbát begwashant o ‘rabbi’ tawár bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bale maylét mardom shomárá ‘ostád’ begwashant, chiá ke shomárá tahná yak ostádé hast o sajjahén yakdomiay brát ét. ");
INSERT INTO bccl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Shomá é donyáyá hechkasá ‘pet’ tawár makanét chiá ke shomárá yak Peté hast, hamá ke ásmáná ent. ");
INSERT INTO bccl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Shomárá hechkas ‘tálim dayók’ magwashit, chiá ke shomárá yak tálim dayóké hast o á Masih ent. ");
INSERT INTO bccl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Á ke shomay nyámá cha sajjahénán master ent, hamá á degaráni hezmatkár bebit. ");
INSERT INTO bccl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Chiá ke harkas watá mazana zánt o lékit, kamsharapa bit o harkas watá jahl o érdasta mannit, washnám o sharapdára bit. ");
INSERT INTO bccl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Bale bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá mardománi démá ásmáni bádsháhiay darwázagá banda kanét, na wata poterét o na degarána kellét. ");
INSERT INTO bccl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Bale bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá janózámáni lógán gón málwáriá barét o pa pésh dáragá, wati dwá o sanáyán drájkassha kanét, shomárá sakterén sezá o padmozza rasit. ");
INSERT INTO bccl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá pa yak mardoméay Yahudi kanagá, hoshki o daryáyán sát o sapara kanét, bale wahdé kasé shomay hambáwara bit, gorhá áiá cha wati jendá do sari badter o dózahay chokka kanét. ");
INSERT INTO bccl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Oo kórén rahshónán! Bazhn o apsóz pa shomá ke mardomán sója dayét: ‘Agan kasé mazanén parasteshgáhay sawgendá bwárt parwáh nést, bale agan yakké parasteshgáhay teláh o tangawáni sawgendá bwárt, gorhá báyad ent wati sawgendá purah bekant.’ ");
INSERT INTO bccl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Oo kamzántén kórán! Kojám chizzay darajat borzter ent, tangaw o teláháni yá parasteshgáhay? Teláh o tangaw, paméshká pák o palgár ant ke parasteshgáhá ér ant. ");
INSERT INTO bccl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Shomá chosh ham gwashét ke ‘agan kasé korbánjáhay sawgendá bwárt hech parwáh nést, bale agan kasé korbánjáhay korbánigay sawgendá bwárt, gorhá báyad ent wati sawgendá purah bekant.’ ");
INSERT INTO bccl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Oo kórén mardomán! Kojám chizzay darajat borzter ent, korbánigay yá korbánjáhay? Korbánig paméshká pák o palgár zánaga bit ke korbánjáhá korbánig kanaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Paméshká kasé ke korbánjáhay sawgendá wárt, bezán korbánjáh o korbánig kortagén sajjahén chizzáni sawgendá wárt. ");
INSERT INTO bccl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Harkas ke mazanén parasteshgáhay sawgendá wárt, bezán parasteshgáh o áiay jahmenenday sawgendá wárt. ");
INSERT INTO bccl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Harkas ke ásmánay sawgendá wárt, Hodáay taht o á taht nendókay sawgendá wárt. ");
INSERT INTO bccl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá purchénk, gwátag o zirragay dahyakká kasshét o Hodáay námá dayét bale cha Sharyatay dega masterén hokmán bezán dádrasi o ensáp, rahmdeli o wapádáriá béhayál o bétránag butagét. Drégatá, shomá é kár bekorténant o á ham yalah madáténant. ");
INSERT INTO bccl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Oo kórén rahshónán! Shomá passhagá kamaká géchét o dara kanét, bale oshterá éra barét. ");
INSERT INTO bccl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá wati pyálah o darpáni dhanni némagá sáp o sallaha kanét bale áyáni tal o tók sell ent. Shomay del o darun ham cha lálech o tamah o bépahréziá porr o sell ent. ");
INSERT INTO bccl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Oo kórén Parisi! Pésará wati pyálahay tóká sapá kan, dhanni némagá á wat pák o sallaha bit. ");
INSERT INTO bccl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá espétén gach jatagén kabráni paymá ét ke sarzáherá dhawldár ant, bale tóká, cha mordagáni haddh o har paymén gand o gasarhá porr ant. ");
INSERT INTO bccl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Hamé dhawlá shomá ham sarzáherá mardománi chammá tachk o pahrézkárén mardom ét bale shomay del cha shatalkári o náshariá sarréch ent. ");
INSERT INTO bccl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Bazhn o apsóz pa shomá, oo Sharyatay zánógerán o Parisián! Oo dopóstén shatalkárán! Shomá nabiáni kabráni sará gombod o addiraha bandét o pahrézkáráni kabrána sambahénét o dhawldára kanét. ");
INSERT INTO bccl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Chosh ham gwashét ke ‘agan má wati pet o pirokáni wahd o bárigá buténén, gorhá paygambaráni kosht o kóshá gón áyán hamráh nabutagatén.’ ");
INSERT INTO bccl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","É dhawlá wati bárawá sháhedia dayét o mannét hamáyáni nasl o óbádag ét ke paygambaresh koshtagant. ");
INSERT INTO bccl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Bale hamá kár ke shomay pet o pirokán bongéj kortag, shomá áyán sarjam bekanét. ");
INSERT INTO bccl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Oo márán, oo syahmárzádagán! Shomá chón cha tahtarunay sezáyá rakketa kanét? ");
INSERT INTO bccl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Man, paygambar o zántkár o Sharyatay zánóger shomay kerrá ráha dayán, shomá cha áyán lahténá koshét o saliba kasshét, dega lahténá wati kanisahán hayzarána janét o shahr pa shahra táchénét. ");
INSERT INTO bccl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gorhá cha Hábilá beger tán Barakiáay chokk Zakaryáyá, ke shomá mazanén parasteshgáh o korbánjáhay nyámá kosht, é sajjahén pahrézkáráni hón ke jaháná réchag butag, shomay gardená bit. ");
INSERT INTO bccl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Shomárá rásténa gwashán, é sajjahénáni kóshay sezá hamé zamánagay mardomána rasit. ");
INSERT INTO bccl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Urshalim, oo Urshalim! Taw paygambarána koshay o Hodáay ráh dátagénán sengsára kanay. Báz randá man lóthetag tai chokkán wati kerrá mocch o yakjáh bekanán, anchosh ke nekénkén morgé chureg o chippokán wati bál o bánzoláni chérá moccha kant, bale shomá nalóthet. ");
INSERT INTO bccl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Nun shomay lóg wayrán, shomay wati dastá yalah dayaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Shomárá gwashán, dega baré maná nagendét tán á wahdá ke wati zobáná begwashét: ‘Mobárak bát hamá ke pa Hodáwanday námá kayt.’” ");
INSERT INTO bccl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Issá cha mazanén parasteshgáhá dar áyagá at ke morid átkant tán áiay delgósh o chamshánká pa parasteshgáhay jágah o márhiáni nedáragá betarrénant. ");
INSERT INTO bccl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Issáyá gón áyán gwasht: “É sajjahénán gendagá ét? Shomárá rásténa gwashán, yak sengé ham domi sengay sará namánit, sajjahénána próshant o karójant.” ");
INSERT INTO bccl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Hamá wahdá ke Issá Zaytunay kóhay sará neshtagat, áiay morid pa halwat o ehwaté átkant o jostesh kort: “Begwash bárén, é prosht o prósh kadéna bit o tai bádsháhiay áyag o donyáay halásiay nesháni, chi ent?” ");
INSERT INTO bccl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Issáyá passaw dátant: “Hozzhár bét kasé shomárá gomráh makant. ");
INSERT INTO bccl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Chiá ke bázéné mani námá kayt o gwashit: ‘Man hamá Masih án’ o bázénéá gomráha kant. ");
INSERT INTO bccl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Jangáni kukkárá eshkonét o áyáni hál o habar shomay góshána kapit bale matorsét o paréshán mabét. Allam é dhawlá bit, bale angat halásiay wahd nayátkag o pa sar narasetag. ");
INSERT INTO bccl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Yak kawmé dega kawméay sará o yak hokumaté dega hokumatéay sará páda kayt. Bázén molk o jágahán kahta kapit o zeminchandha bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Bale é sajjahén, tahná zank o záyagay dardáni bendát ent. ");
INSERT INTO bccl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Á wahdá shomárá gerant o sakki o sóriáni ámácha kanant o koshant ham o donyáay sajjahén kawm, mani námay sawabá cha shomá naprata kanant. ");
INSERT INTO bccl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Gorhá bázéné poshtá kenzit o cha ráhá thagalit, yakké domiá dróhit o kast o kénaga kant. ");
INSERT INTO bccl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Bázén drógén paygambar jáha janant o bázénéá gomráha kanant. ");
INSERT INTO bccl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Cha gomráhi o náshariá, bázén mardománi nyámá mehr o dósti kamma bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Bale hamá ke tán áherá sakkiána saggit, á rakkit. ");
INSERT INTO bccl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Hodáay bádsháhiaymestágay jár, sajjahén donyáyá janaga bit, tán pa sajjahén kawmán sháhedié bebit, gorhá donyáay halási sara rasit. ");
INSERT INTO bccl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Wahdé shomá á ‘palit o bérán kanókén bazhnáká’ gendét, hamá ke Dányál nabiá áiay bárawá habar kortag ke á pákén jágahá óshtátag,” wánók bezánt o sharr sarpad bebit, ");
INSERT INTO bccl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“hamá ke Yahudiahá ant dém pa kóhán betachant. ");
INSERT INTO bccl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Hamá ke bán o bádgiray sará ent, wati ord o poténkáni zuragá jahlá ér makapit o lógá marawt o ");
INSERT INTO bccl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","hamá mardom ke dhagáráni sará kesht o keshárá ent, wati kabáhay zuragá per matarrit. ");
INSERT INTO bccl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Á róchán, apsóz pa lápporr o chokmátén janénán. ");
INSERT INTO bccl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Dwá bekanét ke shomay tachag o dar rawag, zemestán yá Shabbatay róchá mabit. ");
INSERT INTO bccl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Chiá ke hamá róchán, anchén gránén sakki o sórié kapit ke áiay mesál cha jahánay jórh bayagá tán é wahdá nayátkag o hechbar ham nayayt. ");
INSERT INTO bccl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Agan á sakkiáni róch kamter kanag mabuténant, hech mardomé narakketagat, bale pa gechén kortagénáni háterá, á róch kamter kanaga bant. ");
INSERT INTO bccl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Á wahdá, agan kasé shomárá begwashit: ‘Bechár, Masih edá ent’ yá ‘Bechár, ódá ent,’ báwar makanét. ");
INSERT INTO bccl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Chiá ke drógén Masih o drógén nabi jáha janant o mazanén nesháni o ajekkái pésha dárant. Wati sajjahén zórá janant ke gechén kortagénán ham gomráh bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Man cha é jáwaráni bayagá pésar shomárá hál dátag. ");
INSERT INTO bccl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Gorhá, agan wahdé mardom shomárá begwashant: ‘Bechárét, gyábáná ent,’ ódá marawét, yá ke begwashant: ‘lógay tahá ent,’ báwar makanét. ");
INSERT INTO bccl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Chiá ke Ensánay Chokk anchén grókéay paymá kayt ke cha ródarátká beger tán rónendá shahma dant o gendaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Har jáh ke mortagén sahdáréay jóna bit, ódá gittó o dhundhwárén morg moccha bant. ");
INSERT INTO bccl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Á rócháni sakki o sórián o rand, yak anágat róch tahára bit, máha nadrapshit o máhekánia nabit, estár ham cha ásmáná kapant o ásmáni zór o wák, larzénaga bant. ");
INSERT INTO bccl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Á wahdá, Ensánay Chokkay nesháni ásmáná paddara bit o donyáay sajjahén kawma gendant ke Ensánay Chokk, gón mazanén wák o twán o shán o shawkaté jambaráni sará kayt o paddara bit, nun gréwant o mótka kárant. ");
INSERT INTO bccl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gón karnáay borzén tawárá wati préshtagán ráha dant ke áiay gechén kortagén mardomán, cha donyáay chárén kondhán, bezán cha zeminay hand o damagán tán ásmánay goddhi marz o simsarán, mocch o yakjáh bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Nun cha enjiray drachká dars o sabak begerét, anchosh ke áiay thál narma bant o táka trokkant, gorhá zánét ke garmágay mósom nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Hamé dhawlá, wahdé é sajjahén chizzána gendét, wata zánét ke mani áyagay wahd nazzik ent o darwázagay dapá rasetagán. ");
INSERT INTO bccl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Shomárá rásténa gwashán, tán é sajjahén jáwar mayáyant é nasl o padréch halása nabit. ");
INSERT INTO bccl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Zemin o ásmán gára bant, bale mani habar hechbar gár o zyána nabant. ");
INSERT INTO bccl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Hechkasa nazánt ke á róch o á sáhat kadéna rasit, na ásmánay préshtaga zánant o na chokk, tahná Peta zánt o bass. ");
INSERT INTO bccl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hamá dhawlá ke Nuhay bárigá butag, Ensánay Chokkay áyagay róch ham anchosha bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Chiá ke cha hár o tuppáná pésar, tán hamá róchá ke Nuh bójigá swár but, mardomán wártag o nóshetag o sáng o sur kortag. ");
INSERT INTO bccl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Á hecch sahig naatant tán hár o tuppán átk o sajjahén mardomi gár o hármal kortant. Ensánay Chokkay áyagay wahdá ham hamé dhawlá bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Á wahdá, do mardom kesháráni sará kárá bit, yakké baraga bit o domi hamódá pasht géjaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Do janén jenteray sará dánay droshagá bit, yakké baraga bit o domi hamódá pasht géjaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Shomá nazánét ke shomay Hodáwand kojám róchá kayt. Paméshká sár o hozzhár bét. ");
INSERT INTO bccl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Shomá sharra zánét, agan lógay hodábondá bezántén ke dozz shapay kojám wahd o pásá kayt, gorhá ágáh butagat o dozzi wati lógá pa dozziá naeshtagat. ");
INSERT INTO bccl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Hamé paymá tayár bét, chiá ke Ensánay Chokk anchén wahdéá kayt ke shomá áiay entezár o wadárá nabét. ");
INSERT INTO bccl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Kay ent hamá wapádár o shiwwárén hezmatkár ke hodábond áiá wati é dega sajjahén hezmatkáráni master bekant tán áyán pa wahd ward o warák bedant. ");
INSERT INTO bccl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bahtáwar ent hamá hezmatkár ke wahdé hodábonda kayt, áiá hamá káráni sará gendit. ");
INSERT INTO bccl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Shomárá rásténa gwashán, hodábond hamá hezmatkárá wati sajjahén mál o hastiay kármastera kant. ");
INSERT INTO bccl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Bale agan hezmatkár gandah o radkáré bebit o wati delá begwashit ke ‘hodábond áyagá déra kant’ o ");
INSERT INTO bccl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","paméshká wati hamkáráni latth o kotth kanagá bongéj bekant o gón sharábián ward o nóshá bebit, ");
INSERT INTO bccl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","áiay hodábond anchén róch o sáhatéá kayt o rasit ke á nazánt o wadárá naent. ");
INSERT INTO bccl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Gorhá hodábond áiá thokkor thokkora kant o shatalkáráni nyámá dawra dant. Ódá gréwant o dantán pa dantána droshant. ");
INSERT INTO bccl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Á wahdá ásmáni bádsháhi, hamá dahén neshtagén janénchokkáni paymá bit ke wati cherágesh zortant o sálónkay péshwáziá dar kaptant. ");
INSERT INTO bccl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cha áyán panch nádán atant o panch dáná. ");
INSERT INTO bccl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nádánén jenekán wati cherág zortant bale gón wat thélesh nabort gón. ");
INSERT INTO bccl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Dánáén jenekán cherágán o abéd, théldánáni tahá ham gón wat thél bort gón. ");
INSERT INTO bccl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Sálónká áyagá dér kort, paméshká á sajjahén kóchandhán wáb kaptant. ");
INSERT INTO bccl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Shapnémá kukkár macchet ke ‘hayyá byáét, sálónk pédák ent o wasshátki kanét.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Gorhá á sajjahén ágáh butant o wati cherágáni sharr kanagá laggetant. ");
INSERT INTO bccl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Nádánén jenekán gón dánáén jenekán gwasht: ‘Cha wati thélán kammoké márá ham bedayét, chiá ke may cherág mermeránk ant.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Dánáén jenekán passaw dát: ‘Na, balkén pa máshomá sajjahénán bass mabant, shomá berawét cha dokkánán thél bezurét.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Bale wahdé á thélay geragá shotagatant, sálónk átk o raset. Hamá jenek ke tayár o járhig atant, sálónkay hamráhiá suray mehmániá shotant o mehmánjáhay darwázag band but. ");
INSERT INTO bccl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Randá é dega jenek ham átkant o gwashtesh: ‘Wájah, oo wájah! Darwázagá pa má pach kan.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Bale sálónká passaw tarrént: ‘Shomárá rásténa gwashán ke man shomárá nazánán.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Paméshká hósh o sár bebét chiá ke shomá á róch o sáhatá heccha nazánét. ");
INSERT INTO bccl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Hamé dhawlá Hodáay bádsháhi, mardéay paymá ent ke sát o saparéá shot. Hezmatkári lóthetant o wati mál o maddhii hamáyáni dastá dát. ");
INSERT INTO bccl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Har hezmatkári, áiay bud o twánay kesásá zarr dát, yakké panch tálánt, domi do tálánt o saymi yak tálánté dáti o wati sapará shot. ");
INSERT INTO bccl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Á hezmatkár ke áiá panch tálánt rasetagat, hamá damáná sawdágeriá shot o panch tálánti nap raset. ");
INSERT INTO bccl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Hamé paymá, á domi ke do tálánti rasetagat, dega do tálánti nap raset. ");
INSERT INTO bccl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Bale hamáiá, ke yak tálánté rasetagati, wájahay zarri zort o yak jágahé zeminá kall kort o chéri dát. ");
INSERT INTO bccl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Bázén wahdéá rand, é hezmatkáráni hodábond per tarret o átk o cha áyán hesábi lóthet. ");
INSERT INTO bccl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Hamáiá ke panch tálánt rasetagat, dega panch géshén tálánti áwort o gwashti: ‘Oo wájah! Taw maná panch tálánt dátagat, é panchén géshén ant ke man katthetagant.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Hodábondá gwasht: ‘Shábásh, oo wapádár o sharrén golám! Taw gón kammén bonmálá tachk o rást butagay, nun man tará géshterén káráni zemmah o dhobbahá dayán, byá mani shádkámiáni sharikdár bay.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Hamá ke do tálánti rasetagat ham átk o gwashti: ‘Oo wájah! Taw maná do tálánt dátagat, esh ant do dega ke cha á doénán man katthetagant.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Áiay hodábondá gwasht: ‘Shábásh, oo wapádár o sharrén golám! Taw ham gón kammoká tachk o rást butagay, tará ham géshterén káráni dhobbahá dayán, byá mani shádkámiáni sharikdár bay.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Nun hamá hezmatkár átk ke áiá yak tálánté rasetagat, gwashti: ‘Oo wájah! Man zántag ke taw trondén mardé ay, nakeshtagéna ronay o cha hamódá moccha kanay o baray ke tohmi dánagé nachandhetaget. ");
INSERT INTO bccl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Paméshká cha torsá man tai dátagén tálánt zeminá kall kort, esh ent tai zarr.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Áiay hodábondá passaw dát: ‘Oo nábud o békárén golám! Wahdé taw zánt man nakeshtagéna ronán o ódá ke tohmi dánagé nachandhetagon, moccha kanán o barán, ");
INSERT INTO bccl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","gorhá báyad ent taw mani dátagén zarr byáji o bápáriéay kerrá ér bekorténant tánke cha wati saparay per tarragá rand, man wati zarr gón sutt begepténant. ");
INSERT INTO bccl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Paméshká tálántá cha eshiá pach gerét o hamáiá bedayét ke áiay kerrá dah tálánt ant. ");
INSERT INTO bccl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Chiá ke harkasá chizzé hast, áiá géshter dayaga bit tán sarréch bebit, bale harkasá ke nést, harché ke hasti ham pach geraga bit. ");
INSERT INTO bccl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","É nábudén golámá dhanná taháriá dawr bedayét. Ódá gréwant o dantán pa dantána droshant.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Wahdé Ensánay Chokk gón wati mazanén shán o marháhá préshtagáni hamráhiá kayt, gorhá wati porshawkatén tahtay sará nendit. ");
INSERT INTO bccl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Á wahdá sajjahén kawmáni mardom árag o áiay démá mocch kanaga bant o á, áyán anchosha gisshénit o do bahra kant ke shwánag wati bozán cha méshán jetá kant. ");
INSERT INTO bccl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Méshán wati rástén némagá kant o bozán chappén némagá. ");
INSERT INTO bccl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Gorhá bádsháh gón áyán ke rástén némagá ant, gwashit: ‘Oo bahtáwarán ke shomárá cha mani Petá barkat rasetag! Byáét, é bádsháhiá wati mirás kanét, ke cha donyáay bongéjá pa shomá tayár kanag butag. ");
INSERT INTO bccl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Chiá ke wahdé man shodig atán, shomá maná warag dát. Tonnig atán, maná ápó dát. Dar pa dar atán, maná wati lógá jágahó dát. ");
INSERT INTO bccl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Jándar atán, maná póshákó dát. Nádráh atán, mani hálporsió kort. Bandig atán, mani gendagá átkét.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Gorhá hamá pahrézkárén mardom cha bádsháhá josta kanant: ‘Oo wájah! Má kadi tará shodig distag o warag dátag, tonnig distag o áp dátag. ");
INSERT INTO bccl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Má kadi tará darpadar distag o wati lógán jágah dátag, kadi tará jándar distag o póshák gwará dátag, ");
INSERT INTO bccl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","kadi tará nádráh yá bandig distag o tai gendagá átkagén?’ ");
INSERT INTO bccl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Bádsháh passawa dant: ‘Báwar kanét, wahdé shomá gón mani yak kaster kasterén brátéá é paymén kár kortag, gorhá allam bezán gón manó ham kortag.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Randá gón hamáyán ke chappén némagá ant, gwashit: ‘Oo shummán! Cha mani démá dur bét o hamá jamburén ásay némagá berawét ke hechbara namerit o pa Shaytán o áiay hamráhán addh kanag butag. ");
INSERT INTO bccl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Chiá ke wahdé man shodig atán shomá maná warag nadát, tonnig atán ápó nadát. ");
INSERT INTO bccl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Dar pa dar atán lógá nabort, jándar atán póshák gwará nadát, nádráh yá bandig atán o manó hálporsi nakort.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Gorhá á ham josta kanant: ‘Oo wájah! Má kadi tará shodig, tonnig, darpadar, jándar, nádráh yá bandig distag o tai hezmat nakortag?’ ");
INSERT INTO bccl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Gorhá bádsháh áyán é dhawlá passawa dant: ‘Báwar kanét, wahdé shomá gón mani hech kasterénéá é dhawlén kár nakortag, gorhá allam bezán gón manó ham nakortag.’ ");
INSERT INTO bccl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Paméshká é mardom dém pa abadmánén sezáyá rawant, bale pahrézkárén mardomán namiránén zenda rasit.” ");
INSERT INTO bccl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wahdé Issáyá é habar halás kortant, gón wati moridán gwashti: ");
INSERT INTO bccl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Shomá wassha zánét ke do róchá rand Sargwazay aida bit o Ensánay Chokk pa salib kasshagá geráénaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Hamé wahdá, mazanén dini péshwá o kawmay kamáshán, masterén dini péshwá Kiápáay márhiá diwán kort o ");
INSERT INTO bccl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","é pandal jórhént ke Issáyá pa yak repk o honaré begeráénant o bekóshárénant. ");
INSERT INTO bccl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Bale gwashtesh: “Aiday róchán na, chosh mabit ke mardom áshóp bekanant.” ");
INSERT INTO bccl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wahdé Issá Bayt-Anyáyá hamá Shamunay lógá at ke cha jozámay nádráhiá dráh butagat, ");
INSERT INTO bccl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","yak janéné gón sengmarmarén atrdánéá ke gránbaháén atri mán at, Issáay gwará átk. Issá parzónagay sará neshtagat o hamódá Issáay sari atr per mosht. ");
INSERT INTO bccl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Gón é káray gendagá, Issáay morid delá nawassh butant ke “chiá é atr zawál kanag but? ");
INSERT INTO bccl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Agan é bahá kanag butén, mazanén zarré rasetagat o garib o nézgárán dayag butagat.” ");
INSERT INTO bccl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Issáyá moridáni é nawasshi sarkech wárt, paméshká gwashti: “Chiá shomá é janéná ranjénagá ét? Eshiá gón man nékié kortag. ");
INSERT INTO bccl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Garib o nézgár modám shomay kerrá hast, bale man harwahd gón shomá gón naán. ");
INSERT INTO bccl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","É janén pésh kaptag o pa mani kabr kanagay tayáriá, maná atri per moshtag. ");
INSERT INTO bccl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Shomárá rásténa gwashán, sajjahén donyáyá, har kondhé ke mani wasshén mestág jár janaga bit, é janén o eshiay kár ham yát kanaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Randá cha dwázdahén moridán yakké, ke námi Yahudá Eskaryuti at, mazanén dini péshwáyáni kerrá shot o ");
INSERT INTO bccl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","gwashti: “Agan man Issáyá shomay dastá bedayán, shomá maná ché dayét?” Áyán si nograhén korsh hesáb kort o áiay dastá dát. ");
INSERT INTO bccl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Cha hamá wahdá o rand, Yahudá pa Issáay áyáni dastá dayagá gwam o gégén wahd o móhéay shóházá at. ");
INSERT INTO bccl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Béhomirén nánay aiday awali róchá, moridán cha Issáyá jost kort: “Ché lóthay, Sargwazay aiday shámay tayáriá kojá bekanén ke taw bwarayi?” ");
INSERT INTO bccl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Áiá passaw dát: “Shahrá berawét o pelán mardomá begwashét ke ‘ostáda gwashit, mani wahd nazzik ent, mani dela lóthit gón wati moridán Sargwazay shámá tai lógá bwarán.’” ");
INSERT INTO bccl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Gorhá moridán Issáay gwashagay sará Sargwazay shám tayár kort. ");
INSERT INTO bccl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Bégáh ke but, Issá gón wati dwázdahén moridán parzónagay sará neshtagat. ");
INSERT INTO bccl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Waragay wahdá áiá gón moridán gwasht: “Báwar kanét, cha shomá yakké maná dróhit o dozhmenáni dastá dant.” ");
INSERT INTO bccl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Morid báz paréshán o deltaparkah butant o bárig bárigá cha áiá jost kanagá laggetant: “Oo Hodáwand! Man wa naán, na?” ");
INSERT INTO bccl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Áiá passaw tarrént: “Á ke annun gón man hamkásag but, hamá maná dróhit.” ");
INSERT INTO bccl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Hamá dhawlá ke nebisag butag, Ensánay Chokk cha é donyáyá rawagi ent, bale bazhn o apsóz pa hamáiá ke Ensánay Chokká dróhit. Pa áiá sharter at ke hechbar cha mátá pédá mabutén. ");
INSERT INTO bccl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Gorhá Yahudáyá, hamá ke Issái dróhagi at, gwasht: “Oo ostád! Man wa naán, na?” Issáyá passaw dát: “Taw wat gwasht.” ");
INSERT INTO bccl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wahdé shám waragá atant Issáyá nagané zort, Hodáay shogri gept, chondh chondh kort o moridáná dáti. Gwashti: “Bezurét o bwarét, é mani jesm ent.” ");
INSERT INTO bccl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Padá jámé zorti, Hodáay shogri gept, moridáná dát o gwashti: “Shomá sajjahén cha eshiá benóshét. ");
INSERT INTO bccl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","É mani ahd o karáray hón ent, ke pa bázénéay gonáháni bakshagá réchaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Man shomárá gwashán, nun dega baré anguray dahl o samará nanóshán, hamá róchá padá nósháni ke wati Petay bádsháhiá, gón shomá hóra bán.” ");
INSERT INTO bccl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Hodáay sepat o sanáyá rand, dém pa Zaytunay kóhá ráh geptant. ");
INSERT INTO bccl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Gorhá Issáyá gón moridán gwasht: “Shomá sajjahén, hamé enshapi thagala warét o maná yalaha kanét, chiá ke nebisag butag: Man shopánká janán o ramagay pas sheng o shánga bant. ");
INSERT INTO bccl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Bale zendag bayag o jáh janagá rand, cha shomá pésar Jalilá rawán.” ");
INSERT INTO bccl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Gorhá Petrosá darráént: “Agan sajjahén thagal bwarant o tará yalah bedayant, man hechbar thagala nawarán.” ");
INSERT INTO bccl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Issáyá gwasht: “Tará rásténa gwashán, hamé enshapi cha korósbángá pésar, mani pajjáh áragá say randá enkára kanay o namannay.” ");
INSERT INTO bccl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bale Petrosá gwasht: “Agan gón taw mani sar ham berawt, cha tai pajjáh áragá hechbara nabajján.” É dega sajjahén moridán ham anchosh gwasht. ");
INSERT INTO bccl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Randá Issá gón wati moridán Jetsimáni námén jágahéá shot o gón áyán gwashti: “Hamedá bedárét, man kammé démterá rawán o dwá kanán.” ");
INSERT INTO bccl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Zebdiay doén chokk o Petrosi wati hamráh kortant. Anágat yak mazanén andóh o bétáhirié áiay jesm o jáná nesht. ");
INSERT INTO bccl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Gón áyán gwashti: “Sakk paréshán án, gam o andóhán maná markig kortag, shomá edá bedárét, mawapsét o mani hamráhiá ágáh o hozzhár bét.” ");
INSERT INTO bccl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Randá kammé démterá shot, dém pa chér kapt o dwá kanáná gwashti: “Oo mani Pet! Agan buta kant, cha man é sakkiáni jám o pyálahá bethagalén, bale á dhawlá na ke mana lóthán, hamá dhawlá ke taw lóthay.” ");
INSERT INTO bccl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wahdé per tarret o wati moridáni kerrá átk, disti ke á wáb ant. Gón Petrosá gwashti: “Nabut yak sáhaté ham gón man ágáh bemánét? ");
INSERT INTO bccl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Hozzhár bét o dwá kanét tánke ázmáesh o chakkásá makapét. Ruh, tayár o morádig ent, bale jesm nezór o nátwán.” ");
INSERT INTO bccl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Domi bará pa dwá kanagá shot o dwái kort: “Oo mani Pet! Agan é pyálah bé nóshagá cha man thagalénaga nabit, gorhá harché ke tai razá ent hamá dhawlá bebit.” ");
INSERT INTO bccl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Wahdé per tarret, disti padá wáb ant. Áyáni chamm rohézag o wábénag atant. ");
INSERT INTO bccl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yalahi dátant o saymi randá padá pa dwá kanagá shot o hamá dwái kort. ");
INSERT INTO bccl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Gorhá moridáni kerrá per tarret o gwashti: “Angat ham waptag o árám kanagá ét? Nun á wahd o sáhat nazzik ent ke Ensánay Chokk dróhag o gonahkáráni dastá dayaga bit. ");
INSERT INTO bccl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Pád áét berawén. Á ke maná dróhit, pédák ent.” ");
INSERT INTO bccl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Issá angat habará at ke cha dwázdahén moridán yakké, bezán Yahudá, átk o raset. Áiá mazanén rombé hamráh at ke zahm o latthesh gón at. É romb, cha mazanén dini péshwá o kawmay kamásháni némagá ráh dayag butagat. ");
INSERT INTO bccl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Issáay dróhóká áyáná é nesháni dátagat: “Hamáiá ke mana chokkán, Issá hamá ent. Áiá dazgir kanét.” ");
INSERT INTO bccl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Gorhá Yahudá tachkátachk Issáay kerrá átk o gwashti: “Oo ostád! Drud o drahbát!” Randá Issái chokket. ");
INSERT INTO bccl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Issáyá gwasht, “Oo hambal! Pa hamá kárá ke átkagay, bekani.” Gorhá démá átkant, Issáesh gept o dazgir kort. ");
INSERT INTO bccl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Hamá damáná, Issáay hamráhán yakkéá wati zahm kasshet o masterén dini péshwáay nawkaray góshi sest. ");
INSERT INTO bccl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Issáyá gón áiá gwasht: “Wati zahmá jotká kan. Á kas ke zahma kasshit, cha zahmá merit. ");
INSERT INTO bccl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Záná, taw nazánay agan cha wati Petá belóthán, á pa mani komaká hamé annun dwázdah lashkará géshter préshtag ráha dant. ");
INSERT INTO bccl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Bale gorhá Pákén Ketábáni nebeshtagén hamá habar ke báyad ent sarjam bebant, chón pa sara rasant?” ");
INSERT INTO bccl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nun démi mardománi mocchiay némagá tarrént o gwashti: “Záná man yági o rahzané án ke shomá gón zahm o latthán pa mani geragá átkagét? Man har róch mazanén parasteshgáhá neshtag o mardom dars o sabak dátagant o shomá maná nageptag. ");
INSERT INTO bccl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Bale é paymá paméshká but ke Nabiáni Ketábáni péshgói, rást o paddar bebant.” Gorhá sajjahén moridán á yalah dát o jestant. ");
INSERT INTO bccl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Issáay dazgir kanókán, Issá zort o masterén dini péshwá Kiápáay kerrá bort ke ódá Sharyatay zánóger o kawmay kamásh mocch atant. ");
INSERT INTO bccl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petros ham dur durá, Issáay randá rawán at tán masterén dini péshwáay lógay péshjáhá raset, tahá potert o gón hezmatkárán nesht tán bezánt ke chónén shawré borraga bit. ");
INSERT INTO bccl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mazanén dini péshwá o sarókáni diwánay sajjahén básk, pa Issáay markay sezá dayagá drógén sháhediay shóházá atant, ");
INSERT INTO bccl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","chónáhá bázén drógén sháhed pa gwáhi dayagá pád átk, bale hecchesh dastá nakapt. Godhsará do mardom démá dar átk o ");
INSERT INTO bccl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","gwashtesh: “É mardá gwashtag ke ‘man Hodáay parasteshgáhá próshta kanán o say róchá padá bandáni.’” ");
INSERT INTO bccl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Gorhá masterén dini péshwá pád átk o cha Issáyá josti kort: “Tai bárawá chónén sháhedi dayagá ant? Esháni hech passawa nadayay?” ");
INSERT INTO bccl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Bale Issáyá passaw nadát. Masterén dini péshwáyá padá gón áiá gwasht: “Man tará namiránén Hodáay sará sawgenda dayán, márá begwash, bárén, taw hamá Masih, Hodáay Chokk ay?” ");
INSERT INTO bccl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Issáyá darráént: “Taw wat gwasht. Bale shomá sajjahénán hála dayán, démterá gendét ke Ensánay Chokk zóráwarén Hodáay rástén némagá neshtag. Cha ásmánay jambaráni sará ham kayt.” ");
INSERT INTO bccl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Gorhá masterén dini péshwáyá wati gwaray jámag dert o gwashti: “Eshiá kopr kort, angat ham márá sháhed pakár ent? Shomá eshiay kopr wat eshkot. ");
INSERT INTO bccl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Nun shomay shawr o saláh chi ent?” Áyán passaw dát: “Eshiay sezá mark ent.” ");
INSERT INTO bccl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Randá áyán Issáay dap o démá toh kort o lahténá mosht o shahmát ham jat. ");
INSERT INTO bccl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Nun gwashtesh: “Oo Masih! Pa má paygambari kan o begwash tará kayá jat.” ");
INSERT INTO bccl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Á wahdá Petros dhanná péshjáhá neshtagat, móledé áiay kerrá átk o gwashti: “Taw ham Jalili Issáay hamráh butagay.” ");
INSERT INTO bccl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Bale áiá sajjahénáni démá namannet o gwashti: “Mana nazánán taw ché gwashagá ay.” ");
INSERT INTO bccl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wahdé dém pa mazanén darwázagá rawagá at, dega móledéá dist o gón mardomán gwashti: “É mard Issá Náseriay hamráh butag.” ");
INSERT INTO bccl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Petrosá sawgend wárt o domi randá namannet o gwashti: “Man é mardá nazánán.” ");
INSERT INTO bccl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Damánéá rand, ódá óshtátagén mardom Petrosay kerrá átkant o gwashtesh: “Allamá taw cha hamáyán ay, cha tai gálwárá anchosh jáha kayt.” ");
INSERT INTO bccl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrosá pa nálaté sawgend wárt o gwasht: “Man é mardá nazánán.” Hamá damáná korósá báng dát. ");
INSERT INTO bccl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Gorhá Petros yát o tránagá kapt ke Issáyá gwashtagat: “Korósay bángá pésar, taw say randá mani pajjáh áragá enkára kanay.” Nun dhanná dar átk o sakk gréti. ");
INSERT INTO bccl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Sabáhá máhallah, sajjahén mazanén dini péshwá o kawmay kamásh Issáay kóshá hamshawr butant. ");
INSERT INTO bccl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Issáesh bast, gerrán kort o Rumi wáli Pilátusay dastá dát. ");
INSERT INTO bccl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Wahdé Issáay geráénók Yahudáyá dist ke Issáesh mayárig kort, cha wati kortagén kárá pashómán but o sién nograhén korshi bort o mazanén dini péshwá o kawmay kamásháná wápas dátant. ");
INSERT INTO bccl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Gwashti: “Man sakk mayárig án ke yak bégonáhén mardomé pa kóshárénagá geráéntag.” Bale áyán passaw dát: “Má chón kanén, taw bezánay o tai kár.” ");
INSERT INTO bccl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Gorhá Yahudáyá hamá zarr mazanén parasteshgáhá dawr dátant o shot, watá gothlóp kort o koshti. ");
INSERT INTO bccl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mazanén dini péshwáyán zarr zortant o gwashtesh: “É palitén zarr ant, parasteshgáhay hazánagá esháni ér kanag nárawá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Paméshká shawr o saláhá rand, cha á zarrán kombáréay dhagáresh bahá gept ke pa darámadán kabrestáné bekananti. ");
INSERT INTO bccl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tán róch maróchigá á dhagáray nám “hónay dhagár” ent. ");
INSERT INTO bccl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Paméshká chosh but tán hamá chizz ke Eremiá nabiay zobáná péshgói kanag butag, rást o paddar bebit: Man sién nograhén korsh zortant ke é zarr Bani Esráilay chokkán áiay kimmat bastagat o ");
INSERT INTO bccl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","cha é zarrán kombáray dhagáron bahá gept, anchosh ke Hodáwandá maná parmán kortagat. ");
INSERT INTO bccl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nun Issá wáliay démá óshtárénag but o wáliá cha áiá jost kort: “Taw Yahudiáni bádsháh ay?” Issáyá passaw dát: “Taw wat gwashagá ay.” ");
INSERT INTO bccl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Mazanén dini péshwá o kawmay kamásh Issáyá beddh o bohtám janagá atant, bale áiá hech passaw nadát. ");
INSERT INTO bccl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilátusá gwasht: “Taw naeshkonagá ay ke é tará chinchok bohtám janagá ant?” ");
INSERT INTO bccl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bale Issáyá áyáni hech bohtámay passaw ham nadát o wáli sakk hayrán mant. ");
INSERT INTO bccl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Wáliá har sál aiday wahdá, cha Yahudi bandigán yakké, hamá ke mardomán belóthetén, ázáta kort. ");
INSERT INTO bccl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Á wahdá yak námdárén bandigé jélá at ke námi Bárábás at. ");
INSERT INTO bccl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nun ke mardom mocch atant, Pilátusá cha áyán jost kort: “Shomá ché lóthét? Man kayá ázát bekanán? Bárábásá, yá Issáyá ke Masih ham gwashanti?” ");
INSERT INTO bccl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Áiá zántagat ke Issáesh pa hasadd o konnat áiay dastá dátag. Paméshká chosh gwashti. ");
INSERT INTO bccl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wahdé Pilátus hakdiwáná neshtagat, áiay janá é kolaw ráh dát ke “gón é bégonáh o nékén mardá hecch makan, chiá ke dóshi man eshiay bárawá sakkén paréshánén wábé distag.” ");
INSERT INTO bccl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Bale mazanén dini péshwá o kawmay kamáshán mardománi mocchi sakk shórént o áshopént ke Issáay mark o Bárábásay ázátiá belóthant. ");
INSERT INTO bccl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wáliá jost kort: “Ché lóthét, cha é doénán kojámiá pa shomá ázát bekanán?” Áyán gwasht: “Bárábásá.” ");
INSERT INTO bccl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilátusá cha áyán jost kort: “Gorhá gón Issáyá ke Masih ham gwashanti, ché bekanán?” Áyán pa hamtawári passaw dát o gwasht: “Salibi kassh!” ");
INSERT INTO bccl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilátusá jost kort: “Chiá bárén? Mayári chi ent?” Bale áyán géshter kukkár kort o gwashtesh: “Salibi kassh!” ");
INSERT INTO bccl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wahdé Pilátusá dist ke hech káré korta nakant o mardom shóresh kanagá ant, gorhá áiá áp zort, mocchiay démá wati dast shoshtant o gwashti: “Man cha é marday hóná bémayár án, shomá bezánét o shomay kár.” ");
INSERT INTO bccl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sajjahén mardomán gwasht: “Eshiay hón mayg o may chokkáni gardená bebit.” ");
INSERT INTO bccl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Gorhá Pilátusá pa áyánigi, Bárábás ázát kort o Issá shallák janáént o dáti ke áiá salibay sará bedranjant. ");
INSERT INTO bccl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wáliay sepáhigán Issá wáliay kóth o márhiay péshjáhá bort o sepáhigáni sajjahén lashkar áiay chapp o chágerdá mocch kort. ");
INSERT INTO bccl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Áyán, Issáay gwaray god kasshetant o bádsháháni paymén sohrchakén kabáhé gwará dát, ");
INSERT INTO bccl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","cha dhangar o konthagán tájé jórhént o áiay sará ér kort, latthé rástén dastá dát o pa kalág o rishkand, áiay démá kóndhán kaptant o gwashtesh: “Drud o drahbát, oo Yahudiáni bádsháh!” ");
INSERT INTO bccl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Áiay démá tohesh kort o hamá latthesh sará jat. ");
INSERT INTO bccl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wahdé kalág o malandhesh hallént, gwaray kabáhesh kasshet o áiay jenday godesh padá gwará dátant. Randá dém pa salib kasshagá bortesh. ");
INSERT INTO bccl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wahdé rawagá laggetant, Shamun námén mardé distesh ke Keriniay shahray mardomé at. Sepáhigán á pa bigár gept ke Issáay salibá baddhá bekant. ");
INSERT INTO bccl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wahdé “Joljotá” bezán hamá “Kámpól” námén jágahá rasetant ");
INSERT INTO bccl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ódá Issáesh morr mán retkagén sharáb dát, bale áiá chashagá rand nawárt. ");
INSERT INTO bccl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nun salibay sará dratkesh, pocch o póshákesh watmánwatá bahr kortant o áyáni sará pál jatesh ke bárén kayá berasant. ");
INSERT INTO bccl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Randá hamódá neshtant o áiay negahpániesh kort. ");
INSERT INTO bccl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Issáay sarborá, salibay dáray sará, mayárnámagé dratkesh ke áiay sará nebeshtagat: “É Yahudiáni bádsháh, Issá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Issáay hamráhiá do yági o dozzesh ham salibay sará dratk, yakké rástén o domi chappén némagá. ");
INSERT INTO bccl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Rahgwazán dozhmán dayán, wati sar chandhént o ");
INSERT INTO bccl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","gwashtesh: “Oo mazanén parasteshgáhay karójók ke gwashtaget: ‘say róchá padá áiá addha kanán’. Agan taw Hodáay Chokk ay, gorhá cha salibá ér á o watá berakkén.” ");
INSERT INTO bccl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Hamé dhawlá mazanén dini péshwá, Sharyatay zánóger o kawmay kamásh ham áiay sará rishkand o maskará kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Gwashtesh: “Á dega mardomi rakkéntant, bale watá rakkénta nakant, é wa Esráilay bádsháh ent, agan nun cha salibá ér bekapit, má áiay sará báwara kanén. ");
INSERT INTO bccl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Óst o ométi pa Hodá bastag, agan Hodáyá dóst ent, berakkéniti, chiá ke gwashtagati: ‘Man Hodáay Chokk án.’” ");
INSERT INTO bccl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Hamé paymá Issáay hamráhiá salib kasshetagén yági ham áiá bad o rad gwashagá atant. ");
INSERT INTO bccl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Némróchá beger tán bégáhay sayá, sajjahén molk anágat tahár but. ");
INSERT INTO bccl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Bégáhay sáhat sayá, Issáyá chihál jat: “Eli, Eli, lemá sabaktani?” Bezán: Oo mani Hodá, oo mani Hodá! Taw chiá maná tahná esht? ");
INSERT INTO bccl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ódá, lahtén óshtátagén mardomá wahdé eshkot, gwashtesh: “Elyásá tawár kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Cha áyán yakké tacháná shot, espanjé zorti o tropshén sharábá missénti, dáréay sará bast o pa chussagá Issáay némagá shahárti. ");
INSERT INTO bccl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Bale é dega mardomán gwasht: “Sabr kan, bechárén bárén Elyás eshiay rakkénagá kayt yá na?” ");
INSERT INTO bccl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Issáyá domi bará borzén tawáréá chihál kasshet o sáh dát. ");
INSERT INTO bccl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Hamá wahdá mazanén parasteshgáhay pardah, borzádá beger tán jahlád, dert o do bahr but, zemin larzet o talár trakket o kap butant, ");
INSERT INTO bccl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","kabráni dap pach but o bázén pák o pahrézkárén mardom ke mortagatant, padá zendag butant. ");
INSERT INTO bccl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Issáay jáh janag o zendag bayagá rand, cha wati kabrán dar átkant, Urshalimay Pákén shahrá shotant o watá pa bázénéá záher o paddaresh kort. ");
INSERT INTO bccl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Hamá pawji apsar o áiay hamráhén sepáhig ke Issáay páneg atant, wahdé zeminchandh o é dega sargwastesh distant, sakk torset o gwashtesh: “Béshakk é mard Hodáay Chokk at.” ");
INSERT INTO bccl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Bázén janéné ham, ke cha Jalilá pa Issáay hezmat o cholópagá áiay hamráhiá átkagat, dur óshtátag o cháragá atant. ");
INSERT INTO bccl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gón áyán Maryam Majdaliah, Ákub o Issopay mát Maryam o Zebdiay chokkáni mát gón atant. ");
INSERT INTO bccl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Rónendá, Arimátiáay shahray Issop námén zardárén mardé átk ke Issáay moridé at. ");
INSERT INTO bccl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilátusay kerrá shot o Issáay jónay baragay ejázati lóthet. Pilátusá parmán dát ke jóná áiá bedayant. ");
INSERT INTO bccl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Issopá jón zort o sápén lilomén godéá patát o ");
INSERT INTO bccl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","hamá nókén kabray tahá ér dát ke pa wat cha talárá tráshtagati. Mazanén dhóké léth dayáná kabray dapá éri kort o shot. ");
INSERT INTO bccl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Bale Maryam Majdaliah o á dega Maryam, hamódá kabray dém pa démá neshtant. ");
INSERT INTO bccl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Domi róchá, bezán Shambehá, mazanén dini péshwá o Parisi yakjáh but o Pilátusay kerrá shotant. ");
INSERT INTO bccl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Gwashtesh: “Oo wájah! Márá yát ent ke é drógbandá wati zendá gwashtagat ke ‘say róchá rand man padá zendaga bán o jáha janán.’ ");
INSERT INTO bccl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Paméshká parmán beday ke tán say róchá kabray sará negahpáni kanag bebit, chó mabit ke áiay morid jóná bedozzant o bebarant o gón mardomán begwashant ke á cha mordagán padá zendag butag o é goddhi repk o dróg, cha pésarigéná angat gandahter bebit.” ");
INSERT INTO bccl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilátusá darráént: “Negahpán wa esh ant, wati hamráhiá bebarét o haminchok ke gón shomá buta kant, kabray negahpániá bekanét.” ");
INSERT INTO bccl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Gorhá shotant o kabray dapay mazanén dhók mohr o mómband kort o sepáhigesh páneg kortant. ");
INSERT INTO bccl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Shabbatay róchá rand, bezán Yakshambehay gwarbámá Maryam Majdaliah o á dega Maryam kabray cháragá shotant. ");
INSERT INTO bccl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Yak anágat mazanén zeminchandhé but, chiá ke Hodáwanday préshtagé cha ásmáná ér átk, dhóki léthént o áiay sará nesht. ");
INSERT INTO bccl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Rang o dróshomi grókay paymá drapshagá at o god o pósháki, barpay dhawlá espét atant. ");
INSERT INTO bccl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Negahpánén sepáhig cha bimmá larzagá laggetant o mordagay dhawlá butant. ");
INSERT INTO bccl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Préshtagá gón janénán gwasht: “Matorsét! Mana zánán shomá Issáay shóházá ét ke salib kasshag butag. ");
INSERT INTO bccl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Á edá naent, anchosh ke wat gwashtagati zendag butag o jáhi jatag, byáét hamá jágahá bechárét ke ér kanag butagat. ");
INSERT INTO bccl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Eshtápiá berawét o áiay moridán sahig kanét ke á cha mordagán zendag butag o cha shomá pésar Jalilá rawt, hamódá áiá gendét. Nun man shomárá hál dát.” ");
INSERT INTO bccl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Gorhá janén pa tors o ham gón wasshi cha kabray sará tachán but o shotant tán é hálá moridán sar bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Issá bé gat o gománá anágat wat gón á janénán dochár kapt o gwashti: “Drud o drahbát!” Á nazziká átkant, Issáay pádesh geptant o parasteshesh kort. ");
INSERT INTO bccl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Issáyá gón áyán gwasht: “Matorsét! Berawét mani brátán begwashét ke Jalilá berawant, hamódá maná gendant.” ");
INSERT INTO bccl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Hamá wahdá ke janén per tarrag o rawagá atant, lahtén negahpánén sepáhig, dém pa shahrá shot tán dini péshwáyán cha é sargwastán sahig bekanant. ");
INSERT INTO bccl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dini péshwáyán, kawmay kamásháni gend o nend o shawr o saláhá rand, sepáhig mazanén zarré lálech dát o ");
INSERT INTO bccl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","gwashtant: “Gón mardomán begwashét: ‘Shapá má wáb butagén, áiay morid átkagant o jónesh dozzetag o bortag.’ ");
INSERT INTO bccl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Agan wáli cha é hálán sahig but, shomá paréshán o deltaparkah mabét, má áiá sarpada kanén ke pa shomá janjálé mabit.” ");
INSERT INTO bccl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Sepáhigán zarr zortant o anchosh ke sój dayag butagatant, hamá dábesh kort. É kessah tán róch maróchigá Yahudiáni nyámá sheng o tálán ent. ");
INSERT INTO bccl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Gorhá yázdahén morid Jalilay hamá kóhay sará shotant ke Issáyá gón áyán gwashtagat. ");
INSERT INTO bccl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wahdé áyán Issá dist parasteshesh kort, bale lahtén angat shakk at. ");
INSERT INTO bccl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Issáyá gón áyán gwasht: “Ásmán o zeminay sajjahén zór o wák mani dastá dayag butag. ");
INSERT INTO bccl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Paméshká, berawét sajjahén kawmán mani morid bekanét, Pet o Chokk o Pákén Ruhay námá pákshódi bedayét o ");
INSERT INTO bccl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","áyán dars o sabak bedayét ke mani sajjahén hokm o parmánáni sará kár bekanant. Deljam bebét, man tán donyáay halásiá, modám gón shomá gón án.”");
INSERT INTO bccl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Issá Masih, Hodáay Chokkay wasshén mestágay bongéj o shoruhát. ");
INSERT INTO bccl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anchosh ke Eshayá Nabiay Ketábá nebeshtah ent: Bechár, man wati kásedá cha taw pésar ráha dayán ke á, tai ráhá tachk o tayára kant. ");
INSERT INTO bccl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Gyábáná, kasé gwánkajant: Hodáwanday ráhá tayár o áiay keshká rást o tachk bekanét. ");
INSERT INTO bccl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Pákshódókén Yahyá gyábáná záher but o gwánki jat: “Cha wati gonáhán pashómán bebét o pákshódi bekanét ke bakshaga bét.” ");
INSERT INTO bccl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mardom, cha Yahudiahay sajjahén métag o kallagán o cha Urshalimay shahrá áiay kerrá shotant. Wati gonáháni pashómániesh záhera kort o Yahyáyá Ordonay kawrá pákshódia dátant. ");
INSERT INTO bccl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yahyáyá cha oshteray pothán gwaptagén póshák gwará at o póstén kamarbandé lánká bastagati. Áiá, madag o gyábáni bénaga wárt. ");
INSERT INTO bccl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Yahyáyá jára jat o gwashti: “Cha man o rand, mardé kayt ke cha man báz zórákter ent o maná é láheki ham nést ke kóndhán bekapán o áiay kawshbandán bebóján. ");
INSERT INTO bccl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Man shomárá gón ápá pákshódia dayán, bale á shomárá gón Hodáay Pákén Ruhá pákshódia dant.” ");
INSERT INTO bccl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Á róchán, Issá cha Jalilay damagay shahr Náserahá átk o Ordonay kawrá Yahyáay dastá pákshódi dayag but. ");
INSERT INTO bccl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Anchosh ke á cha ápá dar áyagá at, disti ke ásmánay dap pach but o Hodáay Pákén Ruh kapótéay dróshomá átk o áiay sará ér nesht. ");
INSERT INTO bccl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Cha ásmáná é tawár átk: “Taw mani dóstén Bacch ay o man cha taw báz wassh o razá án.” ");
INSERT INTO bccl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Hamá wahdá Pákén Ruhá Issá gyábáná rawán dát. ");
INSERT INTO bccl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Á, tán chel róchá gyábáná mant o Shaytán áiá báz chakkásagá at. Ódá jangali jánwar ham gón áiá hór atant o préshtagán áiay hezmat kort. ");
INSERT INTO bccl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Cha Yahyáay dazgir bayagá rand, Issá Jalilá shot o Hodáay bádsháhiay wasshén mestágay jári jat o ");
INSERT INTO bccl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","gwashti: “Wahd átkag o rasetag. Hodáay bádsháhi nazzik ent. Nun pa del cha wati gonáhán pashómán bebét o Hodáay wasshén mestágay sará báwar bekanét.” ");
INSERT INTO bccl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Issá, Jalilay mazangwarmay lambá rawagá at ke do máhigiri dist, Shamun o áiay brát Andriás, ke pa máhigiriá wati dám o máhórán gwarmá chér géjagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Issáyá gón áyán gwasht: “Byáét, mani randgiriá bekanét o man shomárá anchosha kanán ke máhig geragay badalá, mardománi delá shekár bekanét.” ");
INSERT INTO bccl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Áyán hamá damáná wati dám yalah dát o áiay hamráh butant. ");
INSERT INTO bccl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Issá ke kammé démá shot Zebdiay chokk, Ákub o áiay brát Yuhannái distant, ke bójigá neshtagatant o wati máhórán sráchag o sharr kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Anchosh ke Issáyá á distant, gwánki jatant. Á doénán, wati pet Zebdi gón kárendahán bójigá yalah dát o Issáay hamráh butant. ");
INSERT INTO bccl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Issá o áiay morid Kaparnáhumay shahrá shotant. Shabbatay róchá Issá kanisahá shot o mardomi tálim dátant. ");
INSERT INTO bccl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Mardom cha áiay dars o sabakán hayrán atant, chiá ke áiá Sharyatay zánógeráni paymá darsa nadát, gón wák o ehtiáré dars o tálima dát. ");
INSERT INTO bccl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Hamé wahdá, kanisahay tahá yak mardéá ke áiá jenné per at, kukkár kanáná gwasht: ");
INSERT INTO bccl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Oo Issá Náseri! Tará gón má che kár ent? Átkagay ke márá gár o tabáh bekanay? Mana zánán taw kay ay, taw Hodáay gechén kortagén hamá Pákén ay.” ");
INSERT INTO bccl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Issáyá jenn hakkal dát o gwashti: “Wati dapá bedár o é mardá yalah day.” ");
INSERT INTO bccl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jenná á mard sakk pretk o zhámbalént o kukkár kanán cha áiá dar átk. ");
INSERT INTO bccl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mardomán pa hayráni watmánwatá gwasht: “É chónén habaré? Gwashay nókén tálimé, gón choshén wák o ehtiáré ke jennán ham hokma dant o jenn ham áiay habará mannant.” ");
INSERT INTO bccl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Dér nagwast ke Jalilay sajjahén kerr o gwarán, Issáyá nám dar áwort. ");
INSERT INTO bccl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Issá, anchosh ke cha kanisahá dar kapt, Ákub o Yuhannáay hamráhiá Shamun o Andriásay lógá shot. ");
INSERT INTO bccl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ódá, Shamunay wassig tapig at o nepáday sará waptagat. Anchosh ke Issá lógá átk, nádráhay hálesh dát, ");
INSERT INTO bccl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Issá nazziká shot, áiay dasti gept o pádi kort. Áiay tap kapt, á wassh but o áyáni hezmat kanagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Bégáhá rónendá rand, mardomán wati nádráh ke áyáni nyámá ganók o jenni ham hastat, Issáay kerrá áwortant. ");
INSERT INTO bccl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Shahray sajjahén mardom, lógay dapá mocch butant. ");
INSERT INTO bccl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Issáyá bázéné dráh kort ke dhawl dhawlén nádráhián geptagatant o bázén ganókáni jenni kasshetant, áiá jenn pa habará naeshtant, chiá ke jennán á pajjáha áwort. ");
INSERT INTO bccl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sabáhá máhallah ke angat tahár at, Issá pád átk, cha lógá dar kapt, yak gestá o panáhén jágahéá shot o dwái kort. ");
INSERT INTO bccl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Shamun o áiay hamráh pa Issáay shóházá dar kaptant. ");
INSERT INTO bccl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wahdé Issáesh dist, gón áiá gwashtesh: “Sajjahén mardom tará shóház kanagá ant.” ");
INSERT INTO bccl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Issáyá gwasht: “Byáét dega némagéá berawén, dém pa kerr o gwaray halk o hankénán, tánke man wasshén mestágá berasénán, chiá ke man pa hamé kárá átkagán.” ");
INSERT INTO bccl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gorhá, sajjahén Jalilá tarr o tábi kort, kanisaháni tahá wasshén mestágay jári jat o jenniáni jenni ham kasshet o dar kortant. ");
INSERT INTO bccl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yak mardé, ke áiá syahgarr at Issáay kerrá átk, kóndhán kapt, dazbandi kort o gwashti: “Agan taw belóthay, maná wassh o palgár korta kanay.” ");
INSERT INTO bccl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Issáyá áiay sará sakk bazzag but, dasti shahárt o á mardi dast per mosht o gwashti: “Mana lóthán, wassh o palgár bay.” ");
INSERT INTO bccl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Hamá damáná á mard cha syahgarrá dráh but. ");
INSERT INTO bccl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Roksat kanagay wahdá, Issáyá kaddhan kort o gwasht: ");
INSERT INTO bccl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Hozzhár bay. Hechkasá cha é habar o hálá sahig makan. Bale beraw, watá dini péshwáyá pésh bedár o pa wati pák o palgáriá, hamá korbánig ke Mussáay Sharyatá nebisag butag, hayráti bekan tánke pa áyán gwáh o sháhedié bebit.” ");
INSERT INTO bccl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Bale á mard ke cha ódá dar kapt, wati drahbakshiay habari har jáh sheng o tálán kort. É sawabá, nun Issáyá sarzáherá, hech shahréá shota nakort, dasht o gyábán o gestáén jágahána tarret. Bale angat mardom cha har némagá áiay kerrá átkant. ");
INSERT INTO bccl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Lahtén róchá o rand, Issá padá Kaparnáhumá átk o é habar sheng o tálán but ke á lógá ent. ");
INSERT INTO bccl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Gorhá, haminkadar mardom átk o mocch but ke lógay dapá óshtagay jágah ham néstat. Issá Hodáay habarán mahluká dars o sabak dayagá at. ");
INSERT INTO bccl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Hamá damáná, chár mardom yak lang o mondhén mardé áiay kerrá áragá at, ");
INSERT INTO bccl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","bale cha mardománi bázén mocchiá, mondhesh Issáay nazziká áwort nakort. Paméshká, lógay sará sar kaptant, lógay saresh thong kort o mondhesh gón nepádá, jahl ér dát. ");
INSERT INTO bccl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Issáyá ke áyáni setk o báwar dist, gón langá gwashti: “Oo mani chokk! Tai gonáh bakshag butant.” ");
INSERT INTO bccl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bale Sharyatay lahtén zánóger ke ódá neshtagat, wati delá gwashtesh: ");
INSERT INTO bccl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Á pa ché chosha gwashit? É kopré. Abéd cha Hodáay jendá, dega kass gonáhán baksheta nakant.” ");
INSERT INTO bccl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Harché ke áyáni delá at, Issáyá hamá damáná máret o gwashti: “Shomá pa ché wati delá choshén hayála kanét. ");
INSERT INTO bccl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Wat begwashét, gón é langá kojám habar ásánter ent: ‘Tai gonáh bakshag butagant’ yá: ‘Pád á, wati nepádán bezur o beraw’? ");
INSERT INTO bccl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bale man paméshká é habar kort tán shomá bezánét, man ke Ensánay Chokk án, maná é donyáyá gonáháni pahell kanagay wák o ehtiár hast.” Padá gón á langá gwashti: ");
INSERT INTO bccl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Tará gwashán, pád á, wati nepádán bezur o lógá beraw.” ");
INSERT INTO bccl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gorhá mard sajjahénáni démá pád átk, wati nepádi zortant o dhanná shot. Sajjahén mardom hayrán butant, Hodáesh satá kort o sárhát o gwashtesh: “Má choshén kár hechbar nadistagat.” ");
INSERT INTO bccl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Issá, padá gwarmay lambá shot. Mardománi mazanén rombé áiay kerrá átk, Issáyá á mardom tálim dátant. ");
INSERT INTO bccl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Anchosh ke Issá ráhá rawagá at, Halpiay chokk Láwii dist ke song o máliát geragay jágahá neshtagat. Gón áiá gwashti: “Byá, mani randgiriá bekan.” Á pád átk o Issáay hamráh but. ");
INSERT INTO bccl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wahdé Issá Láwiay lógá pa waragá neshtagat, dega bázén songi o máliátgir o gonahkárén mardomé gón Issá o áiay moridán nán waragá at. Chiá ke bázéné áiay mannók at. ");
INSERT INTO bccl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","SharyatayParisi zánógerán, wahdé Issá gón é dhawlén mardomán yakjáh waragá dist, gón Issáay moridán gwashtesh: “Á chiá gón songi o gonahkárán hór neshtag o waragá ent?” ");
INSERT INTO bccl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","É habaráni eshkonagá rand, Issáyá gwasht: “Dráh o salámatén mardomán, dáktar pakár naent, nádráhán dáktar pakár ent. Man pa pahrézkárán nayátkagán, gonahkáráni lóthag o gwánk janagá átkagán.” ");
INSERT INTO bccl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Yahyáay morid o Parisi róchag atant. Nun mardom Issáay kerrá átkant o jostesh kort: “Chiá Yahyá o Parisiáni morid róchaga dárant, bale tai morid róchaga nabant?” ");
INSERT INTO bccl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Issáyá gón mesáléá passaw dát: “Sur o árósay mehmán, tán sálónk neshtag, róchag buta kanant? Na, tánke sálónk gón áyán gón ent, róchaga nabant. ");
INSERT INTO bccl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Bale á rócha kayt ke sálónk cha áyán jetá kanaga bit, gorhá á róchaga dárant. ");
INSERT INTO bccl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Hechkas cha nókén godéá chondhé naderrit o kwahnén pashká pacch o pinaga najant, chiá ke nókén goday pacch nazza kayt o kwahnén pashká géshtera derrit. ");
INSERT INTO bccl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Hechkas ham nókén sharábá, kwahnén zekkán mána nakant, chiá ke nókén sharáb, zekkána trákénit o derrit. Zekk o sharáb, har do zawála bant. Nókén sharábá, nókén zekkán mána kanant.” ");
INSERT INTO bccl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Shabbatay róchéá, Issá cha gandomi kesháráni tóká gwazagá at. Áiay moridán ráh rawájaká cha á keshárán lahtén hóshag sest. ");
INSERT INTO bccl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisián gón Issáyá gwasht: “Bechár, chiá tai morid Shabbatay róchá anchén kára kanant ke rawá naent?” ");
INSERT INTO bccl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Issáyá gwasht: “Záná, shomá nawántag, wahdé Dáud o áiay hamráh shodig butant o áyán chizzé pa waragá néstat, gorhá Dáudá ché kort? ");
INSERT INTO bccl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Masterén dini péshwá Ábyátáray zamánagá, Dáud Hodáay Pákén Lógá shot o wat gón hamráhán Hodáay námá hamá hayráti o pákwandhén nánesh wártant ke, abéd cha dini péshwáyán dega hechkasá áyáni waragay hakk néstat.” ");
INSERT INTO bccl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Padá, gón áyán gwashti: “Hodáyá Shabbatay róch pa mardomán pédá kortag, mardom pa Shabbatay róchá pédá nakortagant. ");
INSERT INTO bccl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Paméshká, man ke Ensánay Chokk án, maná Shabbatay róchay ehtiár ham hast.” ");
INSERT INTO bccl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Dega randé, Issá kanisahá shot. Ódá mardé hastat ke dasti hoshk o mondh at. ");
INSERT INTO bccl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Neshtagén mardom Issáay entezár o wadárá atant ke “agan é marday dastá Shambehay róchá dráh bekant, gorhá má áiay sará Shabbatay róchá kár kanagay bohtámá jata kanén.” ");
INSERT INTO bccl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Issáyá gón mondhén mardá gwasht: “Byá démá bósht.” ");
INSERT INTO bccl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Randá gón á neshtagén mardomán gwashti: “Shabbatay róchá, néki kanag rawá ent yá badi? Ensánay zenday rakkénag yá koshag o gár kanag?” Á bétawár butant. ");
INSERT INTO bccl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Issáyá pa zahr cháretant, chiá ke cha áyáni sengdeliá sakk padard but. Gón á mardá gwashti: “Dastá shahár day!” Áiá dast shahár dát o dasti wassh o dráh but. ");
INSERT INTO bccl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Gorhá Parisi dhanná shotant o pa Issáay kóshárénagá gón Hirudián shawr o saláhesh bongéj kort. ");
INSERT INTO bccl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Issá cha mardomán dur, gón wati moridán gwarmay lambá shot. Bázén Jalili mardomé áiay padá rawán but. ");
INSERT INTO bccl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Cha Yahudiah, Urshalim, Edumiah o Ordonay kawray á dastá ham bázén mardomé mocch but, Sur o Saydunay chapp o chágerday nendók ham átkant. Chiá ke áyán Issáay mójezaháni bárawá eshkotagat. ");
INSERT INTO bccl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Issáyá gón moridán gwasht, bójigé pa áiá tayár bekanant tánke cha bázén mardománi mocchiay angerr o áshópá dur bebit. ");
INSERT INTO bccl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Áiá bázén mardomé wassh o dráh kortagat, paméshká nádráhén mardom pa áiay dast per kanagá, télánk dayán, démá kenzán atant. ");
INSERT INTO bccl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Hamáyán ke jenn per at, wahdé Issáesh dist áiay pádán kaptant, kukkáresh kort o gwashtesh: “Taw Hodáay Chokk ay.” ");
INSERT INTO bccl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Issáyá hokm dátant: “Gón kassá magwashét man kay án.” ");
INSERT INTO bccl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Randá, Issá kóhay sará sar kapt o cha wati moridán lahténi hamódá lóthet o á Issáay kerrá átkant. ");
INSERT INTO bccl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Issáyá cha áyán dwázdah kas gechén kort o wati hásén kásed náméntant, tánke gón áiá hamráh bebant o áyán pa wasshén mestágay sheng kanagá rawán bekant. ");
INSERT INTO bccl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jenn kasshagay ehtiári ham dátant. ");
INSERT INTO bccl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Á dwázdahénáni nám esh ant: Shamun ke Issáyá áiay domi nám, “Petros” per bast, ");
INSERT INTO bccl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebdiay chokk, Ákub o áiay brát Yuhanná ke Issáyá “grand o grókay chokk” nám per bastant, ");
INSERT INTO bccl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andriás, Pilipos, Bartulumá, Mattá, Tumá, Halpiay chokk Ákub, Taddá, sarmachárén Shamun o ");
INSERT INTO bccl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yahudá Eskaryuti ke randá Issái dróhagi o dozhmenáni dastá dayagi at. ");
INSERT INTO bccl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Randá, Issá lógá átk o ódá mardom haminchok báz at ke Issá o áiay moridán waragay móh ham naraset. ");
INSERT INTO bccl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wahdé áiay syád o wáres sahig butant, áiay baragá átkant, chiá ke lahténá gwashtagat ke á sár naent. ");
INSERT INTO bccl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Cha Urshalimá átkagén Sharyatay zánógerán ham anchosh gwashtagat ke Issáyá jenn per o gón jennáni sardár Belzabulay sarókiá, jennána kasshit. ");
INSERT INTO bccl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Gorhá Issáyá á lóthetant, mesáli dát o gwashti: “Shaytán, chón Shaytáná kasshet o dar korta kant? ");
INSERT INTO bccl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Agan yak molkéá nátepáki bebit, á molk barjáha namánit o ");
INSERT INTO bccl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","agan yak lógéay mardom watmánwat nátepák bebant, á lóg ham pashta nakapit. ");
INSERT INTO bccl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Hamé dhawlá, agan Shaytán wati jenday helápá bóshtit, gár o bégwáha bit. É áiay halási ent. ");
INSERT INTO bccl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Yak zóráwarén mardoméay lógá hechkasa napoterit o áiay lógá pol o pánch korta nakant, tán wahdé ke hamá zóráwarén mardomá magipt o mabandit. Randá áiay lógá pol o pánch korta kant. ");
INSERT INTO bccl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Báwar kanét ke mardománi gonáh o kopr bakshag bant, ");
INSERT INTO bccl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","bale hamá ke Hodáay Pákén Ruhay helápá kopra kant, hechbar pahell kanaga nabit o abadi gonahkára mánit.” ");
INSERT INTO bccl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Issáyá paméshká chosh gwasht ke á gwashagá atant, Issáyá jenné sará ent. ");
INSERT INTO bccl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Issáay mát o brát átk o dhanná óshtátant, kolaw o paygámesh rawán dát ke Issá áyáni kerrá byayt. ");
INSERT INTO bccl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Bázén mardomé áiay chapp o chágerdá neshtagat o hálesh dát: “Tai mát o brát dhanná óshtátag o tará lóthant.” ");
INSERT INTO bccl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Issáyá áyáni passawá jost kort: “Mani mát o brát kay ant?” ");
INSERT INTO bccl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nun Issáyá neshtagén mardománi némagá cháret o gwashti: “Mani mát o brát esh ant! ");
INSERT INTO bccl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Á ke Hodáay wáhag o razáay sará kára kanant, hamá mani mát o brát o gohár ant.” ");
INSERT INTO bccl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Issá padá mazangwarmay kerrá, mardomán dars o sabak dayagá at. Áiay chapp o chágerdá haminchok mardom mocch but ke á bójigéá swár but o kammoké á kashter kenzet. Sajjahén mardom gwarmay tayábá óshtátagatant. ");
INSERT INTO bccl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Gorhá áiá mardom gón darwar o mesálán bázén dars o sabaké dátant. Gwashti: ");
INSERT INTO bccl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Gósh dárét. Yak dehkáné pa tohmay chandhagá shot, ");
INSERT INTO bccl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","tohmáni chandhagay wahdá kammoké tohm ráhay sará retk o báli morgán chet o wártant. ");
INSERT INTO bccl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Kammé tohm dhal o dhókáni sará retk ke ódá hák kamm at, paméshká zutt rost o sabz butant, chiá ke dhagár talag at. ");
INSERT INTO bccl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Bale cha róchay trondén garmiá gimmort o hoshk butant, chiá ke áyáni risshag o wandhál, zeminá johl nashotagatant. ");
INSERT INTO bccl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Kammé tohm shezz o cherekkáni tahá ham retk, shezzán áyáni rost o rodóm dásht o á bébar o bésamar mantant. ");
INSERT INTO bccl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Dega kammé tohm, sharrén zeminá retk, á sharr rost o mazan butant, jáhé si sari, jáhé shast sari o jáhé sad sari hóshag o baresh kort.” ");
INSERT INTO bccl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Padá gwashti: “Harkasá pa eshkonagá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wahdé mardom shotant o Issá tahná mant, gorhá dwázdahén morid o é dega hamráhán, cha áiá é mesáláni máná jost kort. ");
INSERT INTO bccl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Issáyá passaw dát: “Hodáay bádsháhiay ráz shomárá bakshag butag, bale á ke mani ráhay randgiriá nakanant, é chizz pa áyán hoshkén mesál o darwar ant o bass, ");
INSERT INTO bccl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","tánke: gón chammán bechárant, bale magendant gón góshán beshkonant, bale sarkech mawarant, Hodáay némagá per matarrant o bakshag mabant.” ");
INSERT INTO bccl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Padá gwashti: “Agan shomá é mesálá sarkecha nawarét, gorhá á dega mesálán chón zánta kanét? ");
INSERT INTO bccl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Tohm chandhók hamá ent ke Hodáay habará keshit. ");
INSERT INTO bccl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lahtén mardom ráhay sará retkagén tohmay dhawlá ent. Hodáay gál o habar ke ódá keshaga bit, hamá damáná Shaytána kayt o cha áyáni delá keshtagén habará dara kant o bárt. ");
INSERT INTO bccl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Hamé dhawlá, á tohm ke dhal o dhókáni sará retkant, hamá mardománi mesál ent ke Hodáay habará gósha dárant o hamá damáná pa gal o shádehia mannanti, ");
INSERT INTO bccl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","bale pa é sawabá ke risshag o wandhálesh najatag, Hodáay kolaw áyáni delá, tán dérá namánit o jágaha nakant. Wahdé pa Hodáay gál o habaránigi sakki o ázáré berasitesh, hamá damáná cha ráhá thagalant o kapant. ");
INSERT INTO bccl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Á tohm ke shezz o dhangaráni nyámá réchag butant, hamá mardom ant ke Hodáay gál o habará gósha dárant ");
INSERT INTO bccl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","bale donyái parésháni o mál o zarray hers o jópah o á dega chizzáni lóth o wáhag áyán rada dayant o naylant Hodáay habar sabz betarrit o bar o barward bedant. ");
INSERT INTO bccl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Á tohm ke sharrén zeminá retkant, hamá mardom ant ke Hodáay habará eshkonant o mannant, bar o barwarda dayant, lahtén si sari, lahtén shast sari o lahtén sad sari.” ");
INSERT INTO bccl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Issáyá mesál dayáná gwasht: “Kay rókén cherágá tagár, yá tahtay chérá chéra dant? Cherágá cherágdánay sará éra nakanant? ");
INSERT INTO bccl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Á chizz ke chér ent, záher o paddar bayagi ent o á habar ke panáh o andém ent, áshkár o démdará bayagi ent. ");
INSERT INTO bccl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Harkasá pa eshkonagá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Padá gwashti: “Delgósh kanét ke shomá ché eshkonét. Gón har kayl o paymánahéá ke bedayét, gón hamá kaylá shomárá dayaga bit. Angat géshter ham shomárá rasit. ");
INSERT INTO bccl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kaséá ke chizzé hast, áiá géshter dayaga bit o kaséá ke nést, cha áiá hamá ke hastenti ham pach geraga bit.” ");
INSERT INTO bccl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Issáyá gwasht: “Hodáay bádsháhi, anchosh ent ke kasé dhagárá tohm bekeshit. ");
INSERT INTO bccl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Shapá bwapsit o róchá ágáh bebit. Bale tohm anchosha rodant o mazana bant ke dehkán wata nazánt che paymá o chónaká chosh but. ");
INSERT INTO bccl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bé kaséay komaká, dhagár wat keshtagén tohmá pa bar o barwarda rasénit. É dhawlá: pésará ták, padá hóshag o randá hóshagay tahá dánag. ");
INSERT INTO bccl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wahdé kesháray bara rasit, dehkán dásá sóhána kant, chiá ke rón o móshay wahd átkag.” ");
INSERT INTO bccl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Padá Issáyá gwasht: “Pa Hodáay bádsháhiá, chónén darwaré byárén o chónén mesálé pa áiay bayáná pésh bekanén? ");
INSERT INTO bccl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Hodáay bádsháhi, thélkáhay tohmay dhawlá ent. Zeminá keshagi tohmáni tahá cha sajjahénán kasterén ent. ");
INSERT INTO bccl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Bale keshag ke but, rodit o cha á dega sabzagán borztera bit, sháh o lambi anchosh mazana bant ke báli morg, áiay ták o tháláni sáhegá kodóh o kodáma bandant.” ");
INSERT INTO bccl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Issáyá Hodáay habar anchén mesál o darwaráni tahá gón áyán darshána kortant ke á sarpad but bekanant. ");
INSERT INTO bccl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Bé darwar o mesálán hech habaria nakort, bale wahdé gón wati moridán tahná but, gorhá sajjahén mesáli pa áyán máná kortant. ");
INSERT INTO bccl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Hamá róchá, bégáhá, Issáyá gón wati moridán gwasht: “Byáét gwarmay domi némagá rawén.” ");
INSERT INTO bccl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Áyán cha mardomán roksat gept, hamá bójigá ke Issá neshtagat swár butant o Issáesh gón wat bort. Dega lahtén bójig ham áyáni hamráh at. ");
INSERT INTO bccl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Dér nagwast ke mazanén syahgwátéá sar kort o mastén chawl o mawján bójig cha ápá porr kort. ");
INSERT INTO bccl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Issáyá, sarjáhé saray chérá at o bójigay poshti némagá, wáb at. Gorhá moridán, cha wábá ágáh kort o gwashtesh: “Oo ostád! Tará may hayál hecch gwar naent ke má ér bokkagi o meragi én?” ");
INSERT INTO bccl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Á cha wábá ágáh but, gwáti hakkal dát o gón gwarmá gwashti: “Érmósh! Bass kan!” Gorhá gwát kapt o chawl o mawj árám geptant. ");
INSERT INTO bccl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Padá gón wati moridán gwashti: “Shomárá pa ché torsit? Angat báwara nakanét?” ");
INSERT INTO bccl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Áyán sakk torset o watmánwatá gwashtesh: “É chónén mardomé ke gwát o chawl ham eshiay hokmá mannant?” ");
INSERT INTO bccl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Issá o áiay morid, Jalilay mazangwarmay domi pahnátá Gerásiáni sardhagárá rasetant. ");
INSERT INTO bccl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wahdé Issá cha bójigá ér átk, hamá damáná yak mardé ke jenné per ati, cha kabrestáná dar átk o gón áiá dochár kapt. ");
INSERT INTO bccl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Á, kabrestáná jahmenend at o haminchok zóri mán at ke hechkasá áiay dast o pád gón zamzilá ham kayd korta nakortant. ");
INSERT INTO bccl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Pésará báz randá mardomán kayd kortagat, bale áiá zamzil próshtagatant o hechkasá áiay ger o dáray wák o twán néstat. ");
INSERT INTO bccl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Á, shap o róch kabrestán o kóhán neshtagat, kukkár o chihália jat o watá gón dhók o sengá thappigia kort. ");
INSERT INTO bccl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Anchosh ke Issái cha durá dist, tacháná áiay némagá átk o Issáay pádán kapt. ");
INSERT INTO bccl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Gón kukkár o chiháléá gwashti: “Issá, oo mazanshánén Hodáay Chokk! Tará gón man che kár ent? Tará Hodáay sawgend ent, maná azáb maday.” ");
INSERT INTO bccl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Chiá ke Issáyá gwashtagat: “Oo palitén ruh! É mardá yalah day.” ");
INSERT INTO bccl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Issáyá cha áiá jost kort: “Tai nám kay ent?” Áiá passaw dát: “Mani nám ‘Lashkar’ ent, chiá ke má báz én.” ");
INSERT INTO bccl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Padá áiá gón Issáyá báz randá mennat o zári kort ke “márá cha é sardhagárá dar makan.” ");
INSERT INTO bccl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Hamódá jompéay sará, hukkáni mazanén ramagé charagá at. ");
INSERT INTO bccl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Jennán dazbandi kort o gwasht: “Márá ráh beday tánke hamé hukkáni jesmá poterén.” ");
INSERT INTO bccl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Issáyá ejázat dátant. Gorhá, jenn dar átkant o hukkáni jesmá potertant. Hukkáni ramag ke do hazáray kesásá at, cha jompá jahlagá ér kapáná gwarmá bokket. ");
INSERT INTO bccl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Gorhá, hukkáni shwánag shahr o métagán tatkant o mardomesh é bárawá hál dátant. Wahdé mardomán é habar eshkot, átkant tán gón wati jenday chammán é sargwastá begendant. ");
INSERT INTO bccl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Issáay gwará ke átkant distesh, hamá mard ke pésará jennán ganók kortagat, hamedá neshtag, pocch o pósháki gwará o pa hósh o sár ent. Nun torsesh delá nesht. ");
INSERT INTO bccl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Á ke wat chamdistén sháhed atant, kessahesh kort ke jenni ganók chónaká hósh o sár butag o hukk che paymá gwarmá bokketagant. ");
INSERT INTO bccl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gorhá mardomán gón Issáyá dazbandi kort ke áyáni sardhagárá yalah bedant o berawt. ");
INSERT INTO bccl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wahdé Issá bójigá swár bayagá at, á mardá ke jenná yalah dátagat, dazbandi kort: “Maná wati hamráh kan.” ");
INSERT INTO bccl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Bale Issáyá ejázat nadát o gwashti: “Lógá beraw o wati mardomán hál beday ke Hodáwandá pa taw chónén káré kortag o tai sará chón bazzagi butag.” ");
INSERT INTO bccl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Gorhá, á mard shot o har káré ke Issáyá pa áiá kortagat, Dekápulisay sardhagáray mardomi hál dátant. Sajjahén mahluk, habakkah o hayrán but. ");
INSERT INTO bccl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wahdé Issá padá bójigá swár but o gwarmay á dastá shot, tayábay kerrá, mardománi mazanén rombé áiay chapp o chágerdá mocch but. ");
INSERT INTO bccl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Yáyrus námén mardé ke kanisahay master at, hamódá átk o gón Issáay gendagá, áiay pádán kapt. ");
INSERT INTO bccl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Gón áiá dazbandii kort ke “mani jenek markig ent. Byá o wati dastá áiay sará ér mosh, tánke dráh bebit o zendag bemánit.” ");
INSERT INTO bccl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Issá áiay hamráh but o shot. Dega bázén rombé mardom ham, angerr kanán gón áiá rawán but. ");
INSERT INTO bccl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mardománi rombá janéné gón at ke dwázdah sál at áiay hón band nabutagat o ");
INSERT INTO bccl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","cha bázén dáktarán pa wati elájá mazanén ranjé kasshetagati o sajjahén zarr o máli ham báhéntagatant, bale dráh bayagay badalá nájórhter butagat. ");
INSERT INTO bccl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Áiá pésará Issáay bárawá eshkotagat o nun cha mardománi nyámá Issáay poshtá átk o áiay kabáhi dast jat. ");
INSERT INTO bccl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Chiá ke áiay setk o báwar esh at ke “agan Issáay pocchán ham dast per bekanán, dráha bán.” ");
INSERT INTO bccl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Anchoshi kort, hamá damáná hón band but o cha wati jesmay hálatá sarpad but ke dráh ent. ");
INSERT INTO bccl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Issáyá zutt zánt ke yak wák o kodraté cha áiá dar átkag. Gorhá áiá mardománi némagá chakk tarrént o josti kort: “Kayá mani pocch dast jatant?” ");
INSERT INTO bccl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Moridán gwasht: “Oo wájah! Wat gendagá ay ke mardomán tará chón angerr kortag, angat ham josta kanay: ‘Kayá mani pocch dast jatant?’” ");
INSERT INTO bccl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Issá angat chárén némagán cháragá at ke kayá é kár kortag. ");
INSERT INTO bccl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Bale hamá janéná ke é kár kortagat, zánti ke áiá chón butag o pa tors o larz átk, Issáay pádán kapt o é káray rástén habar o háli dátant. ");
INSERT INTO bccl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Issáyá gón áiá gwasht: “Oo mani jenek! Tai setk o báwará tará rakkéntag, pa wasshi o salámati beraw o cha wati nájórhiá dráh bebay.” ");
INSERT INTO bccl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Issá angat habará at ke cha kanisahay masteray lógá, mardomé átk o Yáyrusi hál dát ke “tai jenek mortag, nun pa ché ostádá géshter delsyáha kanay?” ");
INSERT INTO bccl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Issáyá áyáni habaráni némagá delgósh nakort o gón kanisahay masterá gwashti: “Mators, báwar kan.” ");
INSERT INTO bccl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Cha Petros, Ákub o áiay brát Yuhannáyá abéd, dega hechkasá hamráhiay ejázati nadát. ");
INSERT INTO bccl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wahdé kanisahay masteray lógá átkant, distesh ke baláhén shór o walwalahé, mardom gréwag o mótk áragá ant. ");
INSERT INTO bccl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lógá potert o gwashti: “Chiá shóra kanét o gréwét? Chokk namortag, bass wáb ent.” ");
INSERT INTO bccl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Mardomán gón é habaráni eshkonagá rishkandé jat, bale Issáyá cha hamá báná ke jenek ódá at, sajjahén mardom dar kortant o gón jenekay pet o mát o wati sayén moridán hamódá shot. ");
INSERT INTO bccl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Issáyá jenekay dast gept o gwashti: “Talitá kom!” Bezán: Oo jenekok! Pád á. ");
INSERT INTO bccl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jenek hamá damáná pád átk o tarragá lagget. Omri dwázdah sál at. Á mardom ke gón atant sakk hayrán butant. ");
INSERT INTO bccl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Issáyá pa trondi hokm kortant: “É habará gón hechkasá magwashét” o gwashti: “Jeneká warák bedayét.” ");
INSERT INTO bccl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Randá, Issá cha ódá dar átk o moridáni hamráhiá wati jenday shahrá átk. ");
INSERT INTO bccl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Shabbatay róch ke but, kanisahá shot o mardománi tálim dayagi bongéj kort. Cha áiay dars o sabakán bázén mardomé hayrán but o gón yakdegará gwashtesh: “É habar eshiá cha kojá áwortagant o é zánt o zánag kayá dátag? É dhawlén ajabén káráni kanagay wák o twáni cha kojá rasetag? ");
INSERT INTO bccl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","É hamá dártrásh naent ke Maryamay bacch o Ákub, Yushá, Yahudá o Shamunay brát ent? Áiay gohár ham hamedá may shahrá jahmenend naant?” Gorhá áyán bad átk o Issáesh namannet. ");
INSERT INTO bccl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Issáyá gón áyán gwasht: “Hech nabiéá wati shahr o hankéná, wati lógá o wati syád o wáresáni nyámá sharap nést.” ");
INSERT INTO bccl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Áiá ódá bázén mójezah pésh dásht nakort, bass lahtén nádráhay sará dasti per mosht o dráhi kortant. ");
INSERT INTO bccl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Issá, cha áyáni nábáwariá hayrán at. Randá, Issáyá é dega métag o ábádián tarr o garda kort o mardomi sabaka dátant. ");
INSERT INTO bccl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Dwázdahén kásedi lóthetant o do doá rawán kortant, jenn o palitén ruháni dar kanagay wák o ehtiári ham dátant o ");
INSERT INTO bccl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","gwashti: “Tarr o garday wahdá, gón wat abéd cha asá o dazlatthéá dega hecch mabarét, na nán o na turag o tóshag, na wati lánkbandáni tahá zarr. ");
INSERT INTO bccl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kawsh pádá kanét, bale cha gwaray jámagá abéd, dega géshén póshák mazurét. ");
INSERT INTO bccl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Harkaséay lógá ke rawét, tán shomay kár halása nabit, hamá lógá bedárét. ");
INSERT INTO bccl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Har jáh ke mardom shomárá wasshátka nakanant o shomay habarán gósha nadárant, cha ódá dar kapét o dar kapagay wahdá, wati pádáni danz o hákán bechandhét, tán áyáni helápá sháhedié bebit ke shomá Hodáay kolaw pa áyán raséntag.” ");
INSERT INTO bccl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gorhá, morid shotant o járesh jat ke mardom cha wati badén kárán pashómán bebant. ");
INSERT INTO bccl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Áyán bázén jenni ganóké sár kort o bázén nádráhé thél per mosht o dráh kort. ");
INSERT INTO bccl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Issáay é káráni hál o habar Hirudis bádsháhay góshá raset, chiá ke Issáay nám nun portawár butagat. Lahténay gomán at, é hamá pákshódókén Yahyá ent ke padá cha mordagán zendag butag, paméshká choshén ajekkái o mójezahána kant. ");
INSERT INTO bccl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lahténá gwasht: “Elyás nabi ent ke padá átkag,” á degarána gwasht: “É, gwastagén paygambaráni dhawlá yak paygambaré.” ");
INSERT INTO bccl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Gón é habaráni eshkonagá Hirudisá gwasht: “É hamá Yahyá ent ke man sar borretag, bale nun padá zendag butag.” ");
INSERT INTO bccl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Yahyáay koshagay kessah chosh at ke Hirudisá, Yahyáay gerag o bandi kanagay hokm wat dátagat, chiá ke Hirudisá gón wati brát, Piliposay janá, ke námi Hirudiá at, sur kortagat. ");
INSERT INTO bccl_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Yahyáyá é habaray sará Hirudis mayárig kortagat o gwashtagati ke Sharyatá rawá naent kasé gón wati zendagén brátay janá sáng o sur bekant. ");
INSERT INTO bccl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Paméshká, Hirudiáyá gón Yahyáyá báz hasadd o kénag hastat o lótheti áiá bekóshárénit, bale é kár cha áiay dazrasá dur at, ");
INSERT INTO bccl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","chiá ke Hirudisá zántagat Yahyá pahrézkár o pákén mardomé o cha áiá torseti. Paméshká gwashtagati kasé áiá ázáré marasénit. Báz bará, á cha Yahyáay habaráni gósh dáragá negrán o paréshán butagat bale angat áiá dósta but ke Yahyáay habarán beshkont. ");
INSERT INTO bccl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Áherá, Hirudiáyá gwam o gégén wahd o móhé raset. Hirudisá pa wati sálgerahá, mazanén jashné gept o sajjahén darbári, pawji sarmaster o Jalilay mir o master lóthetagatant. ");
INSERT INTO bccl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Hamá wahdá, Hirudiáay jenek majlesá átk, nách o sohbati gept o Hirudis o áiay mehmáni washdel kortant. Bádsháhá cha galá gón jeneká gwasht: “Harché tai dela lóthit begwash, man tará dayán.” ");
INSERT INTO bccl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Sawgendi wárt o gwashti: “Harché lóthay, belóth, toré mani bádsháhiay némá.” ");
INSERT INTO bccl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jenek dar átk, wati mátay kerrá shot o josti kort: “Ché belóthán?” Mátá gwasht: “Pákshódókén Yahyáay sará belóth.” ");
INSERT INTO bccl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Gorhá á zut zuttá per tarret, bádsháhay kerrá átk o gwashti: “Man pákshódókén Yahyáay sará tabakéay tahá lóthán, hamé annun.” ");
INSERT INTO bccl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Hirudis bádsháh sakk paréshán but, bale áiá mehmánáni démá sawgend wártagat o jeneki labz dátagat. ");
INSERT INTO bccl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Paméshká jalládi hokm kort: “Zendáná beraw, Yahyáay sará borr, tabakéay tahá kan o byár.” Jallád, bandijáhá shot, Yahyáay sari borret o ");
INSERT INTO bccl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","tabakéay tahá pa jeneká áwort o rasént. Jeneká sar bort o wati mátárá dát. ");
INSERT INTO bccl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wahdé Yahyáay morid sahig butant, átkant, jónesh bort o kabr kort. ");
INSERT INTO bccl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Issáay kásed, áiay gwará per tarretant o wati sajjahén kortagén kár o dátagén tálimay bárawá Issáesh hál dát. ");
INSERT INTO bccl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Áiá gwasht: “Byáét yak gestáén jágahé rawén tánke tahná bebén o shomá kammé árám bekanét.” Chiá ke á wahdá mardománi raw o á, haminchok báz at ke áyán pa waragá ham móh naraset. ");
INSERT INTO bccl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Á, bójigéá neshtant o yak gestáén jágahé shotant tánke tahná bebant. ");
INSERT INTO bccl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Rawagay wahdá, bázén mardoméá á distant o pajjáhesh áwortant o mardom cha sajjahén shahrán payádaká hamá jágahá shotant o cha Issá o moridán pésar ódá sar butant. ");
INSERT INTO bccl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wahdé Issá cha bójigá ér kapt o mardománi mazanén mocchii dist, áyáni sará bazzagi but, chiá ke á béshopánkén pasáni dhawlá atant. Gorhá áyán bázén chizzéay tálim dayagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Rónendá, morid átkant o gwashtesh: “Nun béwahd ent o é gestáén jágahé. ");
INSERT INTO bccl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mardomán begwash tán é kerr o gwaráni métag o bázárán berawant o pa wat ward o warák begerant.” ");
INSERT INTO bccl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Bale Issáyá gwasht: “Shomá wat áyán warák bedayét.” Moridán darráént: “Gorhá má berawén o dosad dináray nagan begerén o eshán bedayén ke bwarant?” ");
INSERT INTO bccl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Áiá jost gept: “Gón shomá chont nán gón? Berawét bechárét.” Áyán patthet o padá átk o gwashtesh: “May kerrá panch nagan o do máhig hast.” ");
INSERT INTO bccl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Áiá hokm kort: “Mardomán sabzagén káháni patthay sará benendárénét.” ");
INSERT INTO bccl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Mardom panjáh panjáh o sad saday romb o thóliá neshtant. ");
INSERT INTO bccl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Issáyá panchén nagan o doén máhig dastá kortant, ásmáni cháret o Hodáay shogri gept. Randá nagani chondh chondh kort o moridáni dastá dátant tánke mardománi sará bahresh bekanant. Doén máhigi ham sajjahénáni sará bahr kortant. ");
INSERT INTO bccl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Sajjahén mardomán tán sérá wárt. ");
INSERT INTO bccl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Moridán cha sar átkagén nán o máhigán dwázdah sapt porr kort. ");
INSERT INTO bccl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nán warókén mardománi tahá panch hazár mardén atant. ");
INSERT INTO bccl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Issáyá hamá damáná morid parmán dát o gwashtant: “Tánke man é mardomán roksata kanán, shomá bójigá swár bét o cha man pésar gwarmay domi pahnátá, Bayt-Saydáay shahrá berawét.” ");
INSERT INTO bccl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mardománi yalah kanagá rand, Issá pa dwá kanagá kóhay sará sar kapt. ");
INSERT INTO bccl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Rónendá, morid bójigay tahá gwarmay nyámá atant o Issá hoshkiá tahná at. ");
INSERT INTO bccl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Disti ke trondén gwáté áyáni dém pa démá kasshagá ent o morid pa zahmat o hillaté hulig janagá ant. Gorhá shapay cháromi pásá, Issá ápay sará gám janán, dém pa áyán átk o lótheti cha áyáni kash o kerrá begwazit. ");
INSERT INTO bccl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wahdé áyán Issá ápay sará gám janán dist, gománesh kort balkén ruhé o ják o salwátesh kort. ");
INSERT INTO bccl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Chiá ke sajjahénán gón áiay gendagá báz torset. Bale Issáyá hamá damáná gón áyán gwasht: “Matorsét, é man án.” ");
INSERT INTO bccl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Gorhá gón áyán yakjáh but o bójigá nesht, gwát ham kapt o árám but. Morid hayrán o habakkah mantant, ");
INSERT INTO bccl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","chiá ke áyán angat naganay mójezah sarkech nawártagat, delesh sakk o seng at. ");
INSERT INTO bccl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Issá o moridán gwarm gwázént o domi pahnátá Genisáretay shahrá rasetant o bójigesh nangar kort. ");
INSERT INTO bccl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Anchosh ke cha bójigá ér kaptant, mardomán Issá pajjáh áwort. ");
INSERT INTO bccl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mardom pa drekk o maydán har némagá shotant, wati nádráh o nájórhesh tahtáni sará kortant o har jáh ke áyán eshkot Issá ódá ent, hamódá bortant. ");
INSERT INTO bccl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Issá har shahr o kallagéá ke shot, mardomán wati nádráh chárráháni sará áwortant o dazbandiesha kort ejázat bedant ke bimmár áiay kabáhay lambá dast bejanant. Harkasá ke dast pera kort, wassh o dráha but. ");
INSERT INTO bccl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Cha Urshalimá átkagén lahtén Parisi o Sharyatay zánóger Issáay kerrá mocch but. ");
INSERT INTO bccl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Distesh ke Issáay lahtén morid gón nashoshtagén, bezán gón sell o nápákén dastán waráka wárt. ");
INSERT INTO bccl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Chiá ke Parisi o sajjahén Yahudi, tánke wati pet o piroki dini rahbanday sará dast mashódant, waráka nawarant. ");
INSERT INTO bccl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Wahdé cha bázárá káyant, tán shosht o shód makanant heccha nawarant o dega bázén hamé dhawlén dód o dáb hastant chosh ke, tán waráki darp o hiránán pésará mashódant kármarza nakanant. ");
INSERT INTO bccl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Paméshká, Parisi o Sharyatay zánógerán cha áiá jost kort: “Chiá tai morid pet o piroki rahbandáni randgiriá nakanant o gón sell o nápákén dastán waráka warant?” ");
INSERT INTO bccl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Áiá gwasht: “Oo doru o dopóstén mardomán! Eshayá nabiá cha Hodáay némagá shomay bárawá sharr nebeshtag: É mardom dapá maná satá dayant, bale delesh cha man báz dur ent. ");
INSERT INTO bccl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Á moptá maná parastesha kanant o mardománi jórhéntagén ráh o rahbandán sója dayant. ");
INSERT INTO bccl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Shomá Hodáay hokm yalah dátagant o mardománi ráh o rahband geptagant.” ");
INSERT INTO bccl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Randá gwashti: “Shomá pa wati dód o rahbandáni kár bandagá Hodáay hokmáni yalah dayagay sharrén ráhé dar gétkag. ");
INSERT INTO bccl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chiá ke Tawrátay tahá Mussáyá gwashtag: Wati pet o mátá sharap o ezzat beday. Harkas ke wati pet o mátá zá o dwá bedant, báyad ent koshag bebit. ");
INSERT INTO bccl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Bale shomá mardomán chosh sója dayét ke yakké wati pet o mátá komak makant o begwashit: ‘Pahell kanét, á komak ke man báyad ent shomárá bedátén, Hodáay ráhá korbánig kortag.’ ");
INSERT INTO bccl_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Shomá á mardomá gón é sar o sójá, cha wati pet o mátay komak kanagá makan o manaha kanét. ");
INSERT INTO bccl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Shomá gón wati dód o rahbandáni barjáh dáragá, Hodáay habarán nákára kanét o dega bázén hamé dhawlén kára kanét.” ");
INSERT INTO bccl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Padá áiá rombé mardom wati kerrá lóthet o gwashti: “Shomá mani habarán gósh bedárét o sarpad bebét. ");
INSERT INTO bccl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Chizzé ke mardomay lápá rawt áiá sell o nápáka nakant, bale chizzé ke cha delá dara kayt, mardomá nápáka kant. ");
INSERT INTO bccl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Harkasá pa eshkonagá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wahdé mardomi yalah dátant o lógá átk, moridán gwasht: “Márá é mesálay maksadá sarpad kan.” ");
INSERT INTO bccl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Issáyá gwasht: “Shomá haminkadar násarpad ét? Hech warákay warag mardomá sell o nápáka nakant, ");
INSERT INTO bccl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","chiá ke delá narawt, lápá rawt o cha rótán dara kayt.” Gón é mesálá, áiá gisshént ke sajjahén waragi chizz, helár o pák ant. ");
INSERT INTO bccl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Padá gésh kanáná gwashti: “Á chizz ke mardomá sell o nápáka kant, cha áiay del o daruná chesta bit o áiá nápáka kant, ");
INSERT INTO bccl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","chosh ke badén pegr o hayál, bénangi, dozzi, hón o kósh, zená, ");
INSERT INTO bccl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lálech o tamah, badwáhi, mandr, waylánki, hasadd, kopr, takabbor o ahmaki. ");
INSERT INTO bccl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","É sajjahén badi, cha mardomay daruná sarchammaga gerant o mardomá sell o nápáka kanant.” ");
INSERT INTO bccl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Issá cha ódá dar átk o Suray sardhagárá shot. Ódá lógéá shot o nalótheti ke kasé áiay áyagá sahig bebit, bale watá chér dát nakort. ");
INSERT INTO bccl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Janéné ke áiay kasánén jeneká jenné per at, wahdé Issáay áyagay háli eshkot, hamá damáná átk o áiay pádán kapt. ");
INSERT INTO bccl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","É janén Yunánié at o Suriahay damag Pinikiahá pédá butagat. Áiá Issá mennat o dazbandi kort ke jenná cha jeneká dar bekant. ");
INSERT INTO bccl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Issáyá gwasht: “Awalá báyad ent chokk warag bwarant o sér bekanant, chiá ke cha chokkáni dastá nánay pach gerag o kochekáni démá dawr dayag sharr naent.” ");
INSERT INTO bccl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Janéná gwasht: “Oo Hodáwand! Bale kochek ham chokkáni parzónagay sarárókén naganay thokkorána warant.” ");
INSERT INTO bccl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Issáyá gwasht: “Taw sharrén passawé dát, beraw, tai jenekay jenn dar átkag.” ");
INSERT INTO bccl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wahdé janén lógá per tarret, disti ke jenek tahtay sará waptag o jenná yalah dátag. ");
INSERT INTO bccl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Issá, cha Suray sardhagárá per tarret, Sayduni gwázént, dém pa Jalilay mazangwarm o Dekápulisay sardhagárá átk o raset. ");
INSERT INTO bccl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mardomán yak karrén mardé ke zobáni ham lell o checch at, Issáay kerrá áwort o dazbandiesh kort ke wati dastá áiay sará per bemoshit. ");
INSERT INTO bccl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Issáyá á mard cha mardománi mocchiá yak kerré bort o lankoki áiay góshán mán kortant. Randá áiay zobánay sará lebzi per mosht. ");
INSERT INTO bccl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ásmánay némagá cháreti, áh o ginsárté kasshet o gwashti: “Effatah!” (Bezán “pach bay!”) ");
INSERT INTO bccl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hamá damáná, marday gósh pach butant, zobáni ham pach but o pa sharri habar kanagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Issáyá, mardom báz kaddhan kortant ke gón hechkasá é bárawá hecch magwashant, bale haminchok ke áiá pa habar nakanagá kaddhan kort, mardomán habar haminkadar géshter tálán kort. ");
INSERT INTO bccl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Mardom báz hayrán atant o gón yakdomiá gwashtesh: “É chónén ajabén nékén kára kant, karráni góshán pacha kant o lelláni zobáná ham bójit.” ");
INSERT INTO bccl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Hamá róchán, yak baré padá Issáay gwará mardománi mazanén rombé yakjáh but. Áyán ward o warák gón naat. Paméshká, áiá wati morid lóthetant o gwashti: ");
INSERT INTO bccl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maná é mardománi sará bazzaga bit. Say róch ent mani kerrá ant o nun pa waragá hecchesh nést. ");
INSERT INTO bccl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Agan eshán gón shodigén lápá roksat bekanán, ráhá tosant o kapant, chiá ke lahtén cha durén jágahán átkag.” ");
INSERT INTO bccl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Moridán passaw dát: “É barr o gyábáná pa inchok mardomay waráká, nán cha kojá byárén?” ");
INSERT INTO bccl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Áiá cha moridán jost kort: “Shomárá chont nán gón?” Gwashtesh: “Hapt.” ");
INSERT INTO bccl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Áiá mardom zeminay sará nendagay hokm dátant, haptén náni zortant, Hodáay shogri gept, chondh chondhi kort o moridáni dastá dátanti, tánke mardománi démá éresh bekanant. Moridán anchosh kort. ");
INSERT INTO bccl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Áyáni kerrá lahtén hordén máhig ham hastat. Issáyá máhigáni sará ham Hodáay shogr gept o gón moridán gwashti ke “mardománi démá éresh kanét.” ");
INSERT INTO bccl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sajjahénán sérá wárt o randá cha sar átkagén chondhán, moridán hapt sapt porr kort. ");
INSERT INTO bccl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Á mardom chár hazáray kesásá atant. Randá áiá mardom roksat kortant o ");
INSERT INTO bccl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","randá gón wati moridán bójigá nesht o Dalmánutahay sardhagárá shot. ");
INSERT INTO bccl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Lahtén Parisi Issáay kerrá átk o gón áiá gapp o tráná nesht, tán áiá bechakkásant o dámá dawr bedayant. Gwashtesh: “Márá ásmáni neshánié pésh kan tán báwar bekanén ke tará Hodáyá rawán dátag.” ");
INSERT INTO bccl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Issáyá cha delá áh o ginsárté kasshet o gwashti: “É zamánagay mardom, chiá ásmáni neshánia lóthant? Báwar kanét ke áyán hech neshánié dayaga nabit.” ");
INSERT INTO bccl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Gorhá Issáyá á eshtant, bójigá swár but o dém pa gwarmay domi némagá shot. ");
INSERT INTO bccl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Moridán shamoshtagat gón wat nán bezurant. Bójigá gón áyán yak náné hastat o bass. ");
INSERT INTO bccl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Issáyá hokm kort o gwashtant: “Hozzhár bét! Cha Parisi o Hirudis bádsháhay homirá pahréz kanét.” ");
INSERT INTO bccl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Á watmánwatá habar kanagá laggetant ke “wájah é habará paméshká gwashit ke má gón wat nán nayáwortag.” ");
INSERT INTO bccl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Issáyá zánt o gwashti: “Chiá jérhagá ét ke ‘gón má nán nést’? Angata nazánét o sarpad nabutagét, shomay del inkadar sakk o seng ant? ");
INSERT INTO bccl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Shomárá chamm per, gorhá pa ché nagendét, gósh per, bale góshán pacha nakanét ke beshkonét? Shomá shamoshtag ");
INSERT INTO bccl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","man che paymá gón panch naganá panch hazár mardom sér kort o shomá cha sar átkagén naganán, chont sapt porr kort?” Moridán passaw dát: “Dwázdah.” ");
INSERT INTO bccl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Shomá nadist ke man hapt nán chondh chondh kort o chár hazár mardomá wárt o shomá cha sar átkagén naganáni chondhán, chont sapt porr kort? Áyán passaw dát: “Hapt.” ");
INSERT INTO bccl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Issáyá gwasht: “Gorhá pa ché angat mani habarán sarkecha nawarét?” ");
INSERT INTO bccl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wahdé Issá gón wati moridán Bayt-Saydáyá sar but, yak kórén mardé áiay kerrá áwortesh o dazbandiesh kort ke “wati dastá eshiay sará per mosh.” ");
INSERT INTO bccl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Issáyá kóray dast gept, cha métagá dur bort o áiay chammáni sará lebzi per mosht. Randá wati dasti áiay chammáni sará ér kort o josti gept: “Taw chizzé genday?” ");
INSERT INTO bccl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Á mardá sar borz kort o gwashti: “Mardomán gendagá án, gwashay drachk ant ke soragá ant.” ");
INSERT INTO bccl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Issáyá padá wati dast áiay chammáni sará per moshtant, é randá, áiay chamm pakká sharr butant o sajjahén chizzi sharriá distant. ");
INSERT INTO bccl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nun Issáyá gwasht: “Tachkátachk wati lógá beraw o métagá mán matarr.” ");
INSERT INTO bccl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Issá gón wati moridán dém pa Kaysariah Pilipiay kallagán shot. Ráhá, cha wati moridán josti kort: “Mani bárawá mardom ché gwashant, man kay án?” ");
INSERT INTO bccl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Áyán passaw dát: “Lahténa gwashit taw pákshódókén Yahyá ay, lahténa gwashit taw Elyás nabi ay. Dega lahténa gwashit cha á dega nabián yakké ay.” ");
INSERT INTO bccl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Gorhá áiá jost kort: “Shomá wat mani bárawá ché gwashét, man kay án?” Petrosá passaw dát: “Taw Masih ay.” ");
INSERT INTO bccl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Bale áiá hokm dátant: “É habará páshk makanét ke man Masih án.” ");
INSERT INTO bccl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Randá, Issá moridán tálim dayagá lagget o gwashti: “Ensánay Chokk báyad ent bázén sakki o sóri besaggit. Kawmay kamásh, mazanén dini péshwá o Sharyatay zánóger allamá áiá mamannant o bekóshárénant o say róchá rand á padá zendag bebit.” ");
INSERT INTO bccl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Wahdé Issáyá tachkátachk é habar kortant, Petrosá á yak kerré bort o gwashti: “Oo wájah! Dega baré choshén habar makan.” ");
INSERT INTO bccl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Bale Issáyá chakk tarrént, moridáni némagá cháret o Petrosi hakkal dát o gwashti: “Oo Shaytán! Cha mani démá dur bay. Tai hayál Hodái hayálé naent, ensáni hayálé.” ");
INSERT INTO bccl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Issáyá, sajjahén mahluk o morid lóthetant o gwashti: “Agan kasé lóthit mani randgiriá bekant, báyad ent wati delay sajjahén lóth o wáhagán yalah bedant o pa sáhay nadr kanagá, wati jenday salibá baddhá bekant o mani ráhá gám bejant. ");
INSERT INTO bccl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Chiá ke, agan kasé wati sáhay rakkénagá johd bekant, áiá báhénit, bale harkas pa man o mani wasshén mestágá wati sáhá báhénit, áiá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Agan yakkéá sajjahén donyá berasit bale wati sáhá bebáhénit, gorhá á chónén sóbé bárt o ché kattheta kant? ");
INSERT INTO bccl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Mardom wati sáhá pa che kimmaté bahá zorta kant? ");
INSERT INTO bccl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Agan kasé é béwapá o radkárén ahd o zamánagá cha man o mani habarán lajj bekant, gorhá Ensánay Chokk ham, wahdé Hodáay pákén préshtagáni hamráhiá gón Petay mazanén shán o marháhá padá kayt, cha áiá lajja kant.” ");
INSERT INTO bccl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Issáyá gón áyán gwasht: “Báwar kanét, cha shomá lahtén ke annun edá óshtátag, tán Hodáay bádsháhiá gón sajjahén wák o kodratá nagendit, markay támá nachashit.” ");
INSERT INTO bccl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Cha é habarán shash róchá rand, Issáyá Petros o Ákub o Yuhanná wati hamráh kort o yak borzén kóhéay sará pa halwat o ehwaté bortant ke ódá dega kass mabit. Áyáni démá, Issáay rang o dróshom badal but o ");
INSERT INTO bccl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","áiay póshák, anchosh espét butant ke jahánay hech godshódé godán é dhawlá espét o drapshnák korta nakant. ");
INSERT INTO bccl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Á wahdi, Elyás o Mussá záher butant o gón Issáyá gapp o habaresh kort. ");
INSERT INTO bccl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Petrosá gón Issáyá gwasht: “Wájah! May edá bayag sakk sharr ent, bell ke má say sáheg o kápára bandén, yakké pa taw, yakké pa Mussáyá o degaré pa Elyásá.” ");
INSERT INTO bccl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrosá nazánt ché begwashit, chiá ke sakk torsagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Bale hamá damáná jambaréá áyáni sará sáheg kort o tawáré rost: “É mani dóstén Bacch ent, eshiay habarán gósh bedárét!” ");
INSERT INTO bccl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Anágat, moridán chapp o chágerdá cháret, bale abéd cha Issáyá dega hechkasesh nadist. ");
INSERT INTO bccl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Cha kóhá ér kapagay wahdá, Issáyá hokm kortant: “Tán á wahdá ke Ensánay Chokká cha mordagán jáh najatag, wati é distagénáni bárawá hechkasá hál madayét.” ");
INSERT INTO bccl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Á, é habaray sará bah mant o watmánwat jérhagá atant ke cha mordagán jáh janag o zendag bayagay máná chi ent? ");
INSERT INTO bccl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Gorhá jostesh kort: “Sharyatay zánóger chiá gwashant ke cha Masihay áyagá pésar, báyad ent Elyás nabi byayt?” ");
INSERT INTO bccl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Issáyá passaw dát: “Sharyatay zánógeráni habar rást ent ke Masihay áyagá pésar, Elyás nabi padá kayt o sajjahén kárán gwam o géga kant. Bale ásmáni ketábán pa ché chosh átkag ke Ensánay Chokk báyad ent báz sakki o sóri besaggit o mardom áiá mamannant? ");
INSERT INTO bccl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Elyás nabiay bárawá shomárá begwashán ke á padá átk o anchosh ke Hodáay ketábán péshgói kanag butag, har dhawl áyáni delá lóthet, gón áiá hamá dhawlesh kort.” ");
INSERT INTO bccl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wahdé Issá o sayén morid per tarret o é dega moridáni kerrá átkant, mardománi mazanén rombé distesh. Lahtén Sharyatay zánóger ham hamódá at o gón moridán dapjáká at. ");
INSERT INTO bccl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Anchosh ke mahluká Issá dist, báz hayrán butant o tachán tacháná áiay némagá átkant o wasshátkesh kort. ");
INSERT INTO bccl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Áiá jost kort: “Shomá gón eshán ché bárawá dapják kanagá ét?” ");
INSERT INTO bccl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cha rombay nyámá, mardéá passaw dát: “Ostád! Man wati bachak tai gwará áwortag. Á habar korta nakant, chiá ke yak gongén ruhéay asir o bandig ent. ");
INSERT INTO bccl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Wahdé jenn áiá gipt, zeminá dawria dant, dapi kap o gajja bit, dantána droshit o konth o hoshka bit. Man gón tai moridán gwasht ke eshiay jenná bekasshét, bale áyán dar kort nakort.” ");
INSERT INTO bccl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Issáyá gwasht: “Oo bébáwarén nasl o padréch! Man tán kadéná gón shomá bemánán o besaggán? Chokká mani kerrá byárét!” ");
INSERT INTO bccl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Gorhá bachakesh áwort, bale anchosh ke jennay chamm pa Issáyá kaptant, bachaki pretk o zhámbalént o zeminrá dawr dát. Á, léth waráná kap o gajj but. ");
INSERT INTO bccl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Issáyá cha áiay petá jost kort: “Chont wahd ent ke é dhawlá ent?” Petá passaw dát: “Cha kasániá. ");
INSERT INTO bccl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Báz randá, jenn áiá pa koshagá ás o ápá dawra dant. Agan tai dastá buta kant, má bazzag én, madat kan.” ");
INSERT INTO bccl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Issáyá gwasht: “Agan mani dastá buta kant? Á ke báwara kant, pa áiá har chizz buta kant.” ");
INSERT INTO bccl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Bachakay petá hamá damáná kukkár kort o gwashti: “Maná báwar ent, agan mani báwar nezór ent, komak bekan tán porzórter bebit.” ");
INSERT INTO bccl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wahdé Issáyá dist mahluk cha har némagá tachán áiay kerrá pédák ent, jenni hakkal dát o gwashti: “Oo karr o lellén jenn! É bachaká yalah day o padá hechbar eshiay jesm o jáná mapoter.” ");
INSERT INTO bccl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Gorhá jenná krinzhagé jat o bachaki zhámbalént o yalah dát. Bachak mordagay dhawlá kapt. Bázéné gwashagá at ke bachak mortag. ");
INSERT INTO bccl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Bale Issáyá áiay dast gept o pádi kort. Á pád átk o óshtát. ");
INSERT INTO bccl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wahdé Issá lógá raset, moridán halwatá cha áiá jost kort: “Má chiá é bachakay jenn kasshet nakort?” ");
INSERT INTO bccl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Áiá passaw dát: “É dhawlén jenn, bé dwá kanagá dara nayáyant.” ");
INSERT INTO bccl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Issá o áiay moridán á jágah yalah dát o cha Jalilá gwastant, bale Issáyá nalóthet kasé bezánt ke á kojá ent, ");
INSERT INTO bccl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","chiá ke wati moridáni tálim dayagá goláésh at. Gwashti: “Ensánay Chokk dróhaga bit o anchén mardománi dastá dayaga bit ke koshanti, bale say róchá rand, padá zendaga bit o jáha jant.” ");
INSERT INTO bccl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Bale morid áiay é habará sarpad nabutant o cha áiá jost kanagesh ham torset. ");
INSERT INTO bccl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Padá Kaparnáhumá átkant. Wahdé Issá lógá at, cha moridán josti kort: “Shomá ráhá ché gwashagá atét?” ");
INSERT INTO bccl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Bale áyán passaw nadát o bétawár butant chiá ke ráhá, watmánwat é habará atant ke “bárén, may nyámá sajjahénáni master o kamásh kay ent.” ");
INSERT INTO bccl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Gorhá Issá nesht, dwázdahén moridi lóthetant o gwashti: “Á kas ke masteria lóthit, báyad ent watá cha sajjahénán kaster bezánt o sajjahénáni hezmatkár bebit.” ");
INSERT INTO bccl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Gorhá, yak kasánén chokké áyáni nyámá óshtárénti, baddhá kort o gwashti: ");
INSERT INTO bccl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Harkas pa mani námá, gón washwáhagi é dhawlén chokké wati gwará bedárit, bezán áiá maná dáshtag. Harkas maná bedárit, bezán hamá ásmáni Peti dáshtag ke maná ráhi dátag.” ");
INSERT INTO bccl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yuhannáyá gón Issáyá gwasht: “Ostád! Má yak mardé dist ke gón tai námay geragá, cha mardomán palitén ruh dara kant, bale má á makan o manah kort, chiá ke á cha má naat.” ");
INSERT INTO bccl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Issáyá gwasht: “Na, é kárá makanét, chiá ke harkas gón mani námá mójezah o ajekkáié kant, á wat padá maná bad gwashta nakant o ");
INSERT INTO bccl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","á ke may badwáh naent gón má ent. ");
INSERT INTO bccl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Agan kasé é námay sawabá shomárá tásé áp bedant ke shomá Masihayg ét, allam bezánét ke áiá wati mozza rasit. ");
INSERT INTO bccl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Harkas, cha é kasánokénán ke mani sará báwarmand ant yakkéá dém pa gonáhá bebárt, pa áiá gehter ent ke jenteri táé áiay gardená bebandant o daryáyá chagali bedayant. ");
INSERT INTO bccl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Agan tai dasté tará dém pa gonáhá bebárt, áiá borr. Chiá ke gón doén dastán tahtarunay dáemi ásá kapagay badalá, sharter hamesh ent ke gón yak dasté, namiránén zenday wáhond bebay. ");
INSERT INTO bccl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Agan tai pádé tará dém pa gonáhá bebárt, áiá borr. Chiá ke gón doén pádán tahtaruná kapagay badalá, sharter hamesh ent ke gón yak pádé namiránén zenday wáhond bebay. ");
INSERT INTO bccl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Agan tai chammé tará dém pa gonáhá bebárt, áiá dar kan. Chiá ke gón doén chammán tahtaruná kapagay badalá, sharter hamesh ent ke gón yak chammé Hodáay bádsháhiá bepoteray, ");
INSERT INTO bccl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","hamá tahtarun, ke ódá warókén kerm hechbara namerant o ás hechbar sárt o érmósha nabit. ");
INSERT INTO bccl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Chiá ke harkas cha ásá wádók kanaga bit. ");
INSERT INTO bccl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Wád sharr ent, bale agan áiay tám gár bebit, shomá chón áiá padá wádóka kanét. Shomá ham watá wádók o támdár bekanét o gón yakdegará pa sohl o émeni zend begwázénét.” ");
INSERT INTO bccl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Issá, cha ódá dar átk o dém pa Yahudiahay damag o Ordonay kawray domi pahnátá shot. Ódá, padá mardománi bázén rombé átk o áiay kerrá mocch but. Á, wati hél o ádatay sará, mardománi tálim dayagá goláésh but. ");
INSERT INTO bccl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Lahtén Parisi átk o pa áiay chakkásagá jostesh kort: “Bárén, rawá ent ke mard wati janay talák o sawnán bedant?” ");
INSERT INTO bccl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Issáyá passaw dát: “Mussáyá shomárá ché hokm kortag?” ");
INSERT INTO bccl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Áyán passaw dát: “Mussáyá razá dátag ke mard pa wati janay sawn dayagá, taláknámahé benebisit o áiá begisshénit.” ");
INSERT INTO bccl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Nun Issáyá gwasht: “Mussáyá pa shomay sengdeliay sawabá é dhawlá hokm dátag. ");
INSERT INTO bccl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Bale jahánay jórhénagay wahdá, Hodáyá ensán mardén o janén addh kortag. ");
INSERT INTO bccl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Paméshká, mard cha wati pet o mátá jetá o gón wati janá hór o yakjáha bit. ");
INSERT INTO bccl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Mard o jan, yak jesm o jána bant, é paymá, nun á do naant, yak jesm o jáné ant. ");
INSERT INTO bccl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Paméshká, á ke Hodáyá yakk kortagant, ensán áyán jetá makant.” ");
INSERT INTO bccl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lógá ke shotant, moridán cha áiá é bárawá jost kort. ");
INSERT INTO bccl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Gwashti: “Kasé ke wati janénay sawn o talákána dant o gón dega janénéá sur o sánga kant bezán ke á, gón wati nókén janá zená kanagá ent. ");
INSERT INTO bccl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Hamé dhawlá, agan janéné cha wati mardá sawn begipt o gón dega mardéá sáng o sur bekant, á ham zená kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Yak róché, mardomán wati kasánén chokk, Issáay kerrá áwortant ke wati dastá áyáni sará bemoshit, bale moridán neherr o hakkal dátant. ");
INSERT INTO bccl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Issáyá ke chosh dist nárazá but o gón moridán gwashti: “Chokkán bellét mani kerrá byáyant, áyáni démá madárét, chiá ke Hodáay bádsháhi anchén mardománig ent. ");
INSERT INTO bccl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Shomárá rásténa gwashán, á ke Hodáay bádsháhiá chokkáni paymá mamannit, hechbar ódá pád ér korta nakant.” ");
INSERT INTO bccl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Randá Issáyá chokk wati kotthá nendáréntant, dasti per mosht o barkati dátant. ");
INSERT INTO bccl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wahdé Issáyá wati ráh gept o shot, yak mardé tacháná átk, kóndhán kapt o josti kort: “Oo nékén ostád! Man chón bekanán ke namiránén zenday wáhond bebán?” ");
INSERT INTO bccl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Issáyá gwasht: “Taw maná ‘nékén’ pa ché gwashay? Abéd cha Hodáyá, kass nék naent. ");
INSERT INTO bccl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Hodáay hokmán ham taw zánay: Hón makan, zená makan, dozzi makan, drógén sháhedi maday, degaray málá mawar, wati pet o mátá ezzat beday.” ");
INSERT INTO bccl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mardá passaw dát: “Oo ostád! Hodáay é hokm o parmánán, man cha kasániá kárband kanagá án.” ");
INSERT INTO bccl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Gorhá, Issáyá pa mehré áiay némagá cháret o gwashti: “Tará angat yak káré kanagi ent, beraw wati sajjahén mál o hastiá bahá kan o zarrán garib o nézgárén mardománi sará bahr kan, é paymá tará ásmáni ganjé rasit. Gorhá byá o mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Cha é habará, démi pazhmordah, gamig o paréshán but o shot. Chiá ke á sér o azgárén mardé at. ");
INSERT INTO bccl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Issáyá chárén némagán cháret o gón wati moridán gwashti: “Pa máldárén mardomán, Hodáay bádsháhiá pád ér kanag sakk grán ent.” ");
INSERT INTO bccl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Áiay morid cha é habarán hayrán butant. Issáyá padá gwasht: “Oo mani chokkán! Hodáay bádsháhiá pád ér kanag, sakk grán ent. ");
INSERT INTO bccl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cha suchenay domká oshteray gwazag wa báz grán ent, bale Hodáay bádsháhiá, zardárén mardomay rawag angat gránter ent.” ");
INSERT INTO bccl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Morid, géshter hayrán butant o gón yakdomiá gwashtesh: “Gorhá kay rakketa kant?” ");
INSERT INTO bccl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Issáyá padá á cháretant o gwashti: “Pa ensáná nabuteni ent, bale pa Hodáyá chosh naent, chiá ke Hodáay dastá har chizz buta kant.” ");
INSERT INTO bccl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Gorhá Petros gwashagá lagget: “Má wati har chizz yalah dátag o tai randgiriá kanagá én.” ");
INSERT INTO bccl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Issáyá passaw dát: “Báwar kanét, agan kaséá pa man o pa mani wasshén mestágá wati lóg, brát o gohár, mát o pet, chokk yá mál o dhagár yalah dátagant o mani randgirii kortag, ");
INSERT INTO bccl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Hodá áyáni badalá sad barábar géshtera dant. Hamé jaháná, gón sakki o sóriáni hamráhiá, lóg, brát o gohár, mát, chokk, mál o dhagár áiá rasit o á dega jaháná ham abadmánén zenday wáhonda bit. ");
INSERT INTO bccl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bale bázéné ke awali ent, áheria bit o hamá ke áheri ent, awalia bit.” ");
INSERT INTO bccl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Issá pésar o morid áiay randá, Urshalimay némagá rawagá atant. Morid, hayrán o bah mánag atant o á dega hamráháni delá, tors o bimmé wadi butagat. Issáyá á dwázdahén morid kerréá bortant o gwashti ke gón áiá ché bayagi ent. ");
INSERT INTO bccl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nun má Urshalimá rawagá én, ódá Ensánay Chokká gerant o mazanén dini péshwá o Sharyatay zánógeráni dastá dayant. Áiay markay hokmá borrant o darkawmén mardománi dastá dayanti. ");
INSERT INTO bccl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Darkawmén mardom áiay sará rishkand o maskará kanant, áiay sar o démá toha janant, shallák o hayzaránia janant o koshanti, bale say róchá rand, á padá zendaga bit o jáha jant.” ");
INSERT INTO bccl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebdiay doén chokk Ákub o Yuhanná, Issáay kerrá átkant o gwashtesh: “Oo ostád! May wáhag esh ent ke á chizzá ke cha taw annuna lóthén pa má bekani.” ");
INSERT INTO bccl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Áiá passaw dát: “Ché lóthét?” ");
INSERT INTO bccl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Gwashtesh: “Wahdé tai bádsháhia kayt, wati porshawkatén diwáná, cha má yakkéá wati rástén o á degará chappén némagá benendárén.” ");
INSERT INTO bccl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Issáyá passaw dát: “Shomá nazánét ché lóthagá ét. Bárén, shomárá é twán hast, á jámá ke man nósha kanán benóshét o á pákshódiá ke mana kanán bekanét?” ");
INSERT INTO bccl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Gwashtesh: “Ji haw, é kárá korta kanén.” Issáyá gwasht: “Démterá, shomárá é jám nóshagi o é pákshódi ham kanagi ent, ");
INSERT INTO bccl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","bale bezánét ke é cha mani ejázatá dar ent o gwashta nakanán kay mani rástén o kay chappén némagá nendit. É jágah, hamáyánig ant ke pa áyán gisshénag butagant.” ");
INSERT INTO bccl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wahdé á dega dahén moridán é habar eshkot, Ákub o Yuhannáay sará zahr geptant. ");
INSERT INTO bccl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Gorhá, Issáyá sajjahén morid lóthetant o gwashti: “Shomá zánét, á ke darkawmáni hákem zánaga bant mardománi sará hákemia kanant o kawmáni master chérdastáni sará wati ehtiárá kára bandant. ");
INSERT INTO bccl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Bale shomá chosh makanét, cha shomá harkas ke mazania lóthit, báyad ent sajjahénáni hezmatkár bebit o ");
INSERT INTO bccl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","cha shomá harkas ke masteria lóthit, sajjahénáni kaster o dazbój bebit. ");
INSERT INTO bccl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Hamé dhawlá, Ensánay Chokk nayátkag ke mardom áiay hezmatá bekanant, átkag ke mardománi hezmatá bekant o gón wati sáhay dayagá, bázénéá berakkénit.” ");
INSERT INTO bccl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Gorhá, Ariháay shahrá átkant. Wahdé Issá gón wati morid o dega bázén mardománi hamráhiá, cha Ariháyá dar kapagá at, ráhay sará, yak kórén pendhógeré neshtagat ke námi Bártimáus at o Timáusay chokk at. ");
INSERT INTO bccl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Wahdé Bártimáus sahig but, Issá Náseri ent ke cha hamé ráhá gwazagá ent, gwánki jat o gwashti: “Issá, oo Dáud bádsháhay chokk! Tará mani sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Lahténá hakkal kanáná gwasht: “Bétawár bay!” Bale áiá géshter kukkár kort: “Oo Dáud bádsháhay chokk! Tará mani sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Issá óshtát o gwashti: “Tawári kanét.” Mardomán á kór tawár kort o gwashtesh: “Delá mazan kan! Pád á, byá ke tará tawár kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Bártimáusá wati kabáh kerré dawr dát, koppi kort o Issáay gwará átk. ");
INSERT INTO bccl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Issáyá jost kort: “Ché lóthay? Man pa taw ché bekanán?” Gwashti: “Oo ostád! Mana lóthán biná bebán.” ");
INSERT INTO bccl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Issáyá gwasht: “Beraw ke tai imáná tará dráh kort.” Kór hamá damáná biná but o Issáay hamráhiá rawán but. ");
INSERT INTO bccl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wahdé Urshalimay nazziká, Zaytunay kóhay dámoná Bayt-Páji o Bayt-Anyáay métagán rasetant, gorhá Issáyá do morid rawán dát o ");
INSERT INTO bccl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","gwashti: “Démi métagá berawét. Anchosh ke ódá rasét, korragén haré gendét ke bastag. Á korragá angat hechkas swár nabutag. Áiá bójét o edá byárét. ");
INSERT INTO bccl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Agan kaséá jost kort ke ‘shomá ché kanagá ét,’ begwashét ke ‘wájahá é korrag pakár ent o padá zutt peria tarrénit.’” ");
INSERT INTO bccl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Gorhá doén morid shotant o korragé distesh ke darwázagay dapá bastagat. Bótkesh. ");
INSERT INTO bccl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Cha ódá óshtátagén mardomán lahténá jost kort: “Shomá ché kanagá ét? Pa ché é korragá bójét?” ");
INSERT INTO bccl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Anchosh ke Issáyá sój dátagatant, áyán hamá dáb gwasht. Gorhá, dátesh. ");
INSERT INTO bccl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Korragesh Issáay kerrá áwort o wati shál o cháderesh áiay poshtá ér kortant o Issá swár but. ");
INSERT INTO bccl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Bázénéá Issáay wasshátk kanagá, áiay ráhay sará wati shál o cháder chérgéján kortant. Dega bázénéá, cha machkadag o dhagárán drachkáni thál o ták borret o ráhay sará ér kort. ");
INSERT INTO bccl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Issáay péshromb o padrombén mardom, kukkár kanáná gwashagá atant: “Hushiáná, mobárak bát hamá ke pa Hodáwanday námá kayt! ");
INSERT INTO bccl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Shogr ent ke may bonpirok Dáuday bádsháhi padá barjáh dáraga bit. Hushiáná, borzén arshá!” ");
INSERT INTO bccl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Gorhá Issá Urshalimá átk o mazanén parasteshgáhá shot. Ódá, áiá parasteshgáhay chárén kondháni har chizz cháret. Bale béwahd at, paméshká gón wati dwázdahén moridán Bayt-Anyáyá shot. ");
INSERT INTO bccl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Domi róchá, wahdé Issá o áiay morid cha Bayt-Anyáyá dar kaptant, ráhá Issá shodig but. ");
INSERT INTO bccl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Áiá cha durá enjiray drachké dist ke táki sabz o baz atant. Drachkay nazziká shot tán begendit bárén bar ent yá na. Bale wahdé raset, abéd cha táká dega hecchi nadist, chiá ke enjiray baray mósom naat. ");
INSERT INTO bccl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Gorhá gón drachká gwashti: “Cha ed o rand, hechkas cha taw baré mawarát.” É habar moridán eshkot. ");
INSERT INTO bccl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Anchosh ke Urshalimá sar butant, Issá mazanén parasteshgáhay péshjáhá shot o ódá sawdáger o grákáni gallénag o dar kanagá goláésh but. Zarr badal kanókén sarrápáni mizz o barónki chappig kortant o kapót bahá kanókáni korsi o tahtagi dawr dátant. ");
INSERT INTO bccl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Mazanén parasteshgáhay péshjáhá, tájeráná málay barag o áragi ham naesht. ");
INSERT INTO bccl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mardomi tálim dátant o gwashti: “Záná, Hodáay Ketábá nebisag nabutag: Mani lóg sajjahén kawmáni dwá o parasteshay jágah bebit, bale shomá dozzbázáré kortag.” ");
INSERT INTO bccl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Wahdé mazanén dini péshwá o Sharyatay zánógerán é habar eshkot, áiay koshagay johdesh kort. Bale torsetesh, chiá ke sajjahén mardom cha Issáay tálimán hayrán o habakkah atant. ");
INSERT INTO bccl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Bégáh ke but, Issá o áiay morid cha shahrá dar kaptant. ");
INSERT INTO bccl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Domi sohbá, ráhá hamá enjiray drachkesh dist ke nun cha boná hoshk butagat. ");
INSERT INTO bccl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petros, Issáay pésarigén habaray yát o tránagá kapt o gwashti: “Wájah! Bechár, é drachk ke taw baddwái kort gimmortag.” ");
INSERT INTO bccl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Issáyá passaw dát: “Hodáay sará báwar kanét, ");
INSERT INTO bccl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","shomárá rásténa gwashán, agan kaséá setk o báwar bebit o é kóhá begwashit: ‘Watá cha edá chest kan o daryáay tahá dawr beday’ o wati gwashtagén habaray sará delá shakk mayárit o báwar bekant, á wahdi pa áiá anchosha bit. ");
INSERT INTO bccl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Paméshká shomárá gwashán, harché ke wati dwáyáni tahá lóthét, báwar kanét ke shomárá rasetag o shomárá dayaga bit. ");
INSERT INTO bccl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Harwahdá ke pa dwáyá óshtét, agan shomárá gón yakkéá gelage hast, wati dwáay tahá áiá bebakshét, tánke shomay ásmáni Pet ham, shomay gonáh o mayárán bebakshit. ");
INSERT INTO bccl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Bale agan shomá mabakshét, shomay ásmáni Pet ham shomay gonáh o mayárána nabakshit.” ");
INSERT INTO bccl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Issá o áiay morid, padá Urshalimá átkant. Anchosh ke Issá mazanén parasteshgáhay péshjáhá gám janagá at, mazanén dini péshwá, Sharyatay zánóger o kawmay kamásh áiay kerrá átkant. ");
INSERT INTO bccl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Jostesh kort: “Taw gón kojám hakk o ehtiárá é kárána kanay? Kayá tará é káráni kanagay ehtiár dátag?” ");
INSERT INTO bccl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Issáyá passaw dát o gwasht: “Maná ham cha shomá josté hast, mani passawá bedayét, tán man ham shomárá begwashán ke gón kojám hakk o ehtiárá é kárána kanán. ");
INSERT INTO bccl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yahyáyá pákshódi dayagay ehtiár, cha ásmáná rasetagat yá cha ensánay némagá? Passaw bedayét!” ");
INSERT INTO bccl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Áyán watmánwatá shawr o saláh kort o gwashtesh: “Agan begwashén cha ásmáná at, gorhá gwashit: ‘Pa ché áiay sará imánó nayáwort?’ ");
INSERT INTO bccl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Agan begwashén cha ensánay némagá at...?” É habaresh démá nabort chiá ke áyán cha mardomán torset, pa é háterá ke mardom Yahyáyá barhakkén nabié hesáb kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Paméshká passawesh dát: “Má nazánén.” Issáyá gwasht: “Gorhá man ham shomárá nagwashán ke gón kojám hakk o ehtiárá é kárána kanán.” ");
INSERT INTO bccl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Issáyá, randá gón mesál o darwar wati habar gón áyán bongéj kort o gwashti: “Mardéá anguri bágé addh kort. Áiay chapp o chágerdá pall o pasili bast, pa anguráni shiragay geragá kall o kombé jórhi kort o pa negahpániá yak borjé ham basti. Randá bági pa konandahkári o zamán lahtén bágpánay dastá dát o wat saparéá shot. ");
INSERT INTO bccl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wahdé anguray mósom but, áiá hezmatkáré zamánzurén bágpánáni kerrá ráh dát tán cha bágá kammé nibag byárit, ");
INSERT INTO bccl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","bale bágpánán é hezmatkár latth o kotth kort o gón hórk o háligén dastán per tarrént. ");
INSERT INTO bccl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Gorhá, hodábondá dega hezmatkáré dém dát. Áyán, áiay sar ham prósht o béezzat kort. ");
INSERT INTO bccl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Padá dega hezmatkáré rawáni dát o bágpánán á ham jat o kosht. Hamé dhawlá, áiá dega bázén hezmatkáré ráh dát, bale bágpánán lahtén jat o lahtén kosht. ");
INSERT INTO bccl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Nun pa ráh dayagá áiay kerrá yak kasé pasht kaptagat, áiay dóstén mardénchokk. Godhsará, wati hamá chokki rawán dát, hayáli kort balkén áiay ruá bedárant. ");
INSERT INTO bccl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Bale bágpánán watmánwatá gwasht: ‘Bágay mirás barók hamesh ent, byáét eshiá ham koshén, tánke melk o mirás may bebant.’ ");
INSERT INTO bccl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gorhá gept o koshtesh o jónesh cha bágá dhann, dawr dát.” ");
INSERT INTO bccl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Issáyá jost kort: “Nun shomay gománá bágay hodábond ché kant? Á kayt, bágpánána koshit o bágá dega bágpánáni dastá dant. ");
INSERT INTO bccl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Záná, shomá Pákén Ketábá nawántag: Á seng ke bánbandén ostáyánpasond nakort o nazort hamá seng, bonheshtbut. ");
INSERT INTO bccl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","É Hodáwanday kár ent o may chammán ajab ent.” ");
INSERT INTO bccl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nun áyán lóthet Issáyá dazgir bekanant, chiá ke zántesh Issáyá é mesál hamáyáni bárawá áwortag, bale cha mardomána torsetesh. Gorhá Issáesh esht o shotant. ");
INSERT INTO bccl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Randá, áyán lahtén Parisi o Hirudi Issáay kerrá rawán dát tán áiá cha áiay jenday habarán mán begisshénant. ");
INSERT INTO bccl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nun átk o jostesh kort: Oo ostád! Má zánén ke taw tachk o rástén mardomé ay o harché gwashay pa rástiá gwashay o hechkaséay némagá nageray, chiá ke sajjahénán pa yak chamméá cháray o gón rásti o delsetki Hodáay ráhá sója dayay. Bárén, Rumay bádsháh Kaysará, song o máliát dayag rawá ent yá na? Má áiá máliát bedayén yá madayén? ");
INSERT INTO bccl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Issáyá áyáni é dotal o dopósti zánt o gwashti: “Chiá maná chakkásagá ét? Yak dináré byárét tán bechárán.” ");
INSERT INTO bccl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Áyán dináré áwort. Josti kort: “Eshiay sará kai nám o naksh per ent?” Áyán passaw dát: “Kaysaray.” ");
INSERT INTO bccl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nun Issáyá gwasht: “Gorhá Kaysaraygá Kaysará bedayét o Hodáaygá Hodáyá bedayét.” Cha é passawá, á hayrán o habakkah mantant. ");
INSERT INTO bccl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Randá, lahtén Saduki, ke áheratay namannók ant, Issáay kerrá átk o jostesh kort: “Oo ostád! Mussáyá pa má nebeshtag: Agan kaséay sur kortagén bráté bé chokká bemerit o janózámi zendag bebit, gorhá áiay brát báyad ent gón á janózámá sur bekant tánke chokk o rand o ráhé pa wati brátá bellit. ");
INSERT INTO bccl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","É dhawlá, hapt brát atant. Awali brátá jané gept o bé chokká mort, ");
INSERT INTO bccl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","gorhá domi brátá gón á janózámá sur kort, bale á ham bé chokká mort. Saymi brát ham, hamé dhawlá. ");
INSERT INTO bccl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Cha haptén brátán hechkasá pa wat rand o ráhé naesht. Godhsará, á janén ham mort. ");
INSERT INTO bccl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nun taw begwash, áheratay róchá é janén kojám brátayga bit? Chiá ke har haptén brátán bárig bárigá gón áiá sur kortagat.” ");
INSERT INTO bccl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Issáyá gwasht: “Shomá gomráh naét? Parchá ke na cha Pákén Ketábán chizzé sarkecha warét o na Hodáay wák o zórá sarpada bét. ");
INSERT INTO bccl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Mordag ke jáha janant, na sura kanant o na sur dayaga bant, ásmáni préshtagáni dhawlá bant. ");
INSERT INTO bccl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Mordagáni padá zendag bayag o jáh janagay bárawá, záná shomá Mussáay ketábá bon geptagén dhólokay kessah nawántag, ke Hodáyá gón Mussáyá chón habar kort? ‘Man án, Ebráhémay Hodá, Eshákay Hodá o Ákubay Hodá.’ ");
INSERT INTO bccl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bezán á, mordagáni Hodá naent, zendagénáni Hodá ent. Shomá báz rad wártag.” ");
INSERT INTO bccl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cha Sharyatay zánógerán yakké, áyáni é habarán gósh dáragá at o áiá máret ke Issá sharr passaw dayagá ent, nazziká átk o josti kort: “Sharyatay masterén hokm kojám ent?” ");
INSERT INTO bccl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Issáyá passaw dát: “Sharyatay masterén hokm esh ent: ‘Oo Esráil! Gósh dár: Hodáwand, may Hodá, yektáén Hodá ent, ");
INSERT INTO bccl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","wati Hodáwandén Hodáyá, pa del, gón sajjahén ján o sáh, gón sajjahén pahm o pegr o gón sajjahén was o wáká dóst bedár.’ ");
INSERT INTO bccl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Domi hokm esh ent: ‘Gón wati hamsáhegá wati jenday paymá mehr bekan.’ Cha é doénán, dega masterén hokm nést.” ");
INSERT INTO bccl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Gorhá, Sharyatay zánógerá gwasht: “Oo ostád! Taw sakk rást o sharr gwasht, pa rásti ke Hodá yakké o abéd cha áiá, Hodáé nést. ");
INSERT INTO bccl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Áiá pa del, gón sajjahén pahm o pegr o sarjamén was o wáká dóst dárag o hamsáhegá wati jenday paymá mehr kanag cha sajjahén hayrátién sóchagi tohpah o sajjahén korbánigán sharter ent.” ");
INSERT INTO bccl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wahdé Issáyá dist áiá dánáén passawé dát, gwashti: “Taw cha Hodáay bádsháhiá dur naay.” Cha ed o rand, hechkasá del nakort cha Issáyá chizzé jost bekant. ");
INSERT INTO bccl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wahdé Issáyá, mazanén parasteshgáhá tálima dát, josti kort ke “Sharyatay zánóger che paymá gwashant MasihDáud bádsháhay chokk ent? ");
INSERT INTO bccl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dáudá wat cha Hodáay Pákén Ruhay shobén o elhámá gwashtag: Hodáwandá gón mani Hodáwandágwasht mani rástén némagá benend tán hamá wahdá ke tai dozhmenán tai pádáni chérá dawr bedayán. ");
INSERT INTO bccl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Agan Dáuday jend, Masihá wati Hodáwanda gwashit, gorhá á chón Dáuday chokk buta kant?” Mardománi mocchiá gón wasshi o shádehi, Issáay habar gósha dásht. ");
INSERT INTO bccl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Padá, Issáyá wati tálimáni tahá gwasht: “Cha Sharyatay zánógerán hozzhár bét ke áyán, drájén jámag o kabáh gwará kanag dósta bit o bázáráni tarr o gardá, cha mardomán wasshátk o drahbáta lóthant. ");
INSERT INTO bccl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kanisaháni sharterén jáhán gechéna kanant o mehmánián, awali reday nendagesh pasond ent. ");
INSERT INTO bccl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Janózámáni lógán gón málwáriá barant o pa pésh dáragá wati dwá o sanáyán drájkassha kanant. Eshán sakterén sezá o padmozza rasit.” ");
INSERT INTO bccl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Issá, mazanén parasteshgáhay hayrátáni pétiay dém pa démá neshtagat o hamá mardomán cháragá at ke é pétiá zarresh dawra dát. Cha zardárán bázénéá, zyádahén zarré ér kort. ");
INSERT INTO bccl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Gorhá, garib o béwasén janózámé átk o do paysahi pétiá mán kort. ");
INSERT INTO bccl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nun Issáyá morid wati kerrá lóthetant o gwashti: “Shomárá rásténa gwashán, é béwasén janózámá cha á sajjahénán géshter zarr pétiá mán kort. ");
INSERT INTO bccl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Chiá ke á degarán cha wati géshén málá chizzoké dát, bale é janózámá, gón wati nézgári o garibiá, harché ke áiá hastat dáti, bezán wati sajjahén bonmál.” ");
INSERT INTO bccl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wahdé Issá cha mazanén parasteshgáhá dar áyagá at, cha moridán yakkéá gón áiá gwasht: “Oo ostád! Bechár chónén dhawldárén seng o dhok ant o chónén shawkén lóg o márhi.” ");
INSERT INTO bccl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Issáyá passaw dát: “É dhawldárén lóg o márhiána genday? Cha eshán yak sengé ham domi sengay sará namánit, sajjahénána próshant o karójant.” ");
INSERT INTO bccl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wahdé Issá mazanén parasteshgáhay dém pa démá Zaytunay kóhay sará neshtagat, Petros, Ákub, Yuhanná o Andriás áiay kerrá átkant o pa halwat o ehwaté jostesh kort: ");
INSERT INTO bccl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Márá begwash, bárén, é prosht o prósh kadéna bit o eshiay nazzik bayagay nesháni chi ent?” ");
INSERT INTO bccl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Issáyá habar bongéj kort o gwashtant: “Hozzhár bét, kasé shomárá gomráh makant. ");
INSERT INTO bccl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Bázéné mani námá kayt o gwashit: ‘Man hamá án’ o bázénéá gomráha kant. ");
INSERT INTO bccl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wahdé jangáni kukkárá eshkonét o áyáni hál o habar shomay góshána kapit, matorsét o paréshán mabét. Allam é dhawlá bit, bale angat halásiay wahd nayátkag. ");
INSERT INTO bccl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Yak kawmé dega kawméay sará o yak hokumaté dega hokumatéay sará páda kayt. Bázén molk o jágahán zeminchandha bit o kahta kapit. É, tahná zank o záyagay dardáni bendát ent. ");
INSERT INTO bccl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Hozzhár bét! Shomárá hakdiwánáni démá pésha kanant, kanisaháni tahá janant o pa manigi, hákem o bádsháháni démá óshtárénant. Gorhá shomárá sharrén móhé rasit ke pa man gwáhi bedayét. ");
INSERT INTO bccl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bale pésará báyad ent ke mani wasshén mestág pa sajjahén kawmán jár janag bebit. ");
INSERT INTO bccl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Harwahd ke shomárá gerant o hakdiwánána barant, cha péshá paréshán mabét ke ‘má ché begwashén.’ Á wahdá, har chizzé ke shomárá sój dayaga bit, hamáiá begwashét. Chiá ke gwashók shomá naét, Hodáay Pákén Ruh ent. ");
INSERT INTO bccl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Brát wati brátá dróhit o kóshárénit o pet wati chokká, chokk cha wati pet o mátá yágia bant o áyána kóshárénant. ");
INSERT INTO bccl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Sajjahén mardom, pa mani námaygi cha shomá naprata kanant. Bale hamá ke tán áherá sakkiána saggit, á rakkit. ");
INSERT INTO bccl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Wahdé shomá á ‘palit o bérán kanókén bazhnáká’ hamá jágahá gendét ke áiay jágah naent,” wánók bezánt o sharr sarpad bebit, “hamá ke Yahudiahá ant dém pa kóhán betachant. ");
INSERT INTO bccl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Á ke bán o bádgiray sará ent pa chizzéay zuragá jahlá ér makapit o lógá marawt o ");
INSERT INTO bccl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","á ke dhagáráni sará kesht o keshárá ent, wati kabáhay zuragá per matarrit. ");
INSERT INTO bccl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Á róchán, apsóz pa lápporr o chokmátén janénán. ");
INSERT INTO bccl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Dwá bekanét ke é chizz zemestáná mabit. ");
INSERT INTO bccl_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Chiá ke hamá róchán, anchén sakki o sórié kapit ke áiay mesál, cha hamá róchá ke Hodáyá jahán jórhéntag tán é wahdá nayátkag o hechbar ham nayayt. ");
INSERT INTO bccl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Agan Hodáwandá á sakkiáni róch kamter makorténant, hech mardomé narakketagat. Bale pa wati gechén kortagénáni háterá, á róchi kamter kortagant. ");
INSERT INTO bccl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Á wahdá, agan kasé shomárá begwashit: ‘Bechár, Masih edá ent’ yá ‘bechár, ódá ent,’ báwar makanét. ");
INSERT INTO bccl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Chiá ke drógén masih o drógén nabi jáha janant o nesháni o ajekkái pésha dárant. Wati sajjahén zórá janant ke gechén kortagénán ham gomráh bekanant. ");
INSERT INTO bccl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Nun sharr hósh o sár kanét, chiá ke é sajjahén jáwaráni bayagá pésar man shomárá hál dátag. ");
INSERT INTO bccl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Á róchán, cha é sakki o sórián o rand, róch tahára bit, máha nadrapshit o máhekánia nabit, ");
INSERT INTO bccl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","estár ham cha ásmáná kapant o ásmáni zór o wák larzénaga bant. ");
INSERT INTO bccl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Á wahdá, mardom Ensánay Chokká gendant, ke gón mazanén wák o twán o shán o shawkaté cha jambaráni nyámá kayt. ");
INSERT INTO bccl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Gorhá préshtagán ráha dant o cha chárén gwátán, bezán cha zeminay hand o damagán tán ásmánay goddhi marz o simsarán, wati gechén kortagén mardomán yakjáha kant. ");
INSERT INTO bccl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Nun cha enjiray drachká dars o sabak begerét. Anchosh ke áiay thál narma bant o táka trokkant, gorhá zánét ke garmágay mósom nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Hamé dhawlá, wahdé é chizzána gendét, wata zánét ke mani áyagay wahd nazzik ent o darwázagay dapá rasetagán. ");
INSERT INTO bccl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Shomárá rásténa gwashán, tán é sajjahén jáwar mayáyant é nasl o padréch halása nabit. ");
INSERT INTO bccl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Zemin o ásmán gára bant, bale mani habar hechbar gár o zyána nabant. ");
INSERT INTO bccl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Hechkasa nazánt ke á róch o á sáhat kadéna rasit, na ásmánay préshtaga zánant o na chokk, Peta zánt o bass. ");
INSERT INTO bccl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Tayár o hozzhár bét! Chiá ke nazánét á wahd o damán kadéna kayt. ");
INSERT INTO bccl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mani per tarragay mesál, hamé dhawlá ent ke mardé dur o drájén saparéá berawt, roksat kanagay wahdá, sajjahén hezmatkáráni kár o bárán sar o sój bekant o negahpáná hokm bedant: ‘Sár o hozzhár bay!’ ");
INSERT INTO bccl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Shomá nazánét ke lógay hodábond kojám róch o che wahdá kayt; bégáhá, shapnémá, bámgwáhá yá sabáhay wahdá? Paméshká sár o hozzhár bét. ");
INSERT INTO bccl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Chosh mabit ke hodábond anágat byayt o begendit ke shomá wáb ét. ");
INSERT INTO bccl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Anchosh ke man shomárá gwashagá án, sajjahénána gwashán: Hozzhár bét!” ");
INSERT INTO bccl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sargwaz o béhomirén nánay aidá do róch pasht kaptagat, mazanén dini péshwá o Sharyatay zánóger, ráh o nimmóné shóház kanagá atant tán gón repk o pandal, Issáyá begerant o bekóshárénant. ");
INSERT INTO bccl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Bale gwashtesh: “Aiday róchán na, chosh mabit ke mardom áshóp bekanant.” ");
INSERT INTO bccl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Issá, Bayt-Anyáyá hamá Shamunay lógá mehmán at ke cha jozámay nádráhiá dráh butagat. Hamódá, yak janéné gón sengmarmarén atrdánéá Issáay gwará átk, atrdáná sombolay gehter o gránbaháén atr mán at. Áiá atrdán pach kort o atr, Issáay sará chandhetant. ");
INSERT INTO bccl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ódá, lahtén neshtagén mardom cha é kárá wati delá nawassh but o gwashtesh: “Chiá é atr zawál kanag but? ");
INSERT INTO bccl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","É atr, cha sésad dinárá géshterá bahá butagat o zarr, garib o nézgárán dayag butagatant.” Paméshká, nun á janéná mayárig kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Bale Issáyá gwasht: “Belléti, shomá pa ché eshiá ranjénagá ét? É janéná gón man nékié kortag. ");
INSERT INTO bccl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Garib o nézgár, modám shomay kerrá ant o shomá harwahd ke belóthét gón áyán néki korta kanét, bale man har wahd gón shomá gón naán. ");
INSERT INTO bccl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Éshiá pa mani kabr kanagay tayáriá, wati hezmat sarjam kort o mani sará atr chandhet. ");
INSERT INTO bccl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Shomárá rásténa gwashán, sajjahén donyáyá, har kondhé ke mani wasshén mestág jár janaga bit, é janén o eshiay kár ham yát kanaga bit.” ");
INSERT INTO bccl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahudá Eskaryuti, ke cha Issáay dwázdahén moridán yakké at, mazanén dini péshwáyáni kerrá shot tánke Issáyá bedróhit o áyáni dastá bedant. ");
INSERT INTO bccl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Á cha Yahudáay habaray eshkonagá báz wassh butant o labzesh kort áiá chizzé zarr bedayant. Nun, Yahudá gwam o gégén wahd o móhéay shóházá at ke Issáyá áyáni dastá bedant. ");
INSERT INTO bccl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Béhomirén nánay aiday awali róchá, ke gwarándhay korbánig kanagay róch at, moridán cha Issáyá jost kort: “Ché lóthay, Sargwazay aiday shámay tayáriá kojá bekanén ke taw bwarayi?” ");
INSERT INTO bccl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Gorhá, Issáyá cha moridán do kas dém dát o gwashti: “Shahrá berawét, ódá mardé gendét ke ápi kunzagé gón enti, áiay poshtá rawán bét. ");
INSERT INTO bccl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Hamá lógá ke á rawt, shomá ham berawét o lógay wáhondá begwashét: ‘Ostád josta kant: Mehmánhánah kojá ent ke man gón wati moridán Sargwazay shámá hamódá bwarán?’ ");
INSERT INTO bccl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Á mard, shomárá wati lógay sarborá, práhén bán o diwánjáhé pésha dárit ke ódá har chizz hast o tayár ent, shámay tayáriá hamódá bekanét.” ");
INSERT INTO bccl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Doén morid shot o shahrá rasetant. Ódá, áyán har chizz hamá paymá dist ke Issáyá gwashtagat. Sargwazay shámesh hamódá tayár kort. ");
INSERT INTO bccl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bégáh ke but, Issá gón dwázdahén moridán hamódá átk. ");
INSERT INTO bccl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wahdé parzónagay sará neshtagatant o shám waragá atant, gwashti: “Báwar kanét, cha shomá yakké ke annun gón man neshtag o shám waragá ent, maná dróhit o dozhmenáni dastá dant.” ");
INSERT INTO bccl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Morid paréshán o deltaparkah butant o bárig bárigá jostesh kort: “Wájah! Man wa naán, na?” ");
INSERT INTO bccl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Issáyá passaw dát: “Cha shomá dwázdahénán yakké, hamá ke annun gón man hamkásag ent.” ");
INSERT INTO bccl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Chiá ke hamá dhawlá ke nebisag butag, Ensánay Chokk cha é donyáyá rawagi ent, bale bazhn o apsóz pa hamáiá ke Ensánay Chokká dróhit. Pa áiá sharter at ke hechbar cha mátá pédá mabutén. ");
INSERT INTO bccl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wahdé shám waragá atant, Issáyá nagané zort, shogri gept, chondh chondh kort o moridáná dáti. Gwashti: “Bezurét! É mani jesm ent.” ");
INSERT INTO bccl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Padá jámé zorti, Hodáay shogri gept, moridáná dáti o sajjahénán cha á jámá nóshet. ");
INSERT INTO bccl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Nun gwashti: “É mani nókén ahd o karáray hón ent ke pa bázénéá réchaga bit. ");
INSERT INTO bccl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Shomárá rásténa gwashán, nun dega baré anguray dahl o samará nanóshán tán hamá róchá ke Hodáay bádsháhiá padá benósháni.” ");
INSERT INTO bccl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Hodáay sepat o sanáyá rand, dém pa Zaytunay kóhá ráh geptant. ");
INSERT INTO bccl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Issáyá gón moridán gwasht: “Shomá sajjahén thagala warét o maná yalaha kanét. Chiá ke nebisag butag: Man shopánká janán o pas sheng o shánga bant. ");
INSERT INTO bccl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Bale zendag bayag o jáh janagá rand, cha shomá pésar Jalilá rawán.” ");
INSERT INTO bccl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Petrosá darráént: “Agan sajjahén thagal bwarant o tará yalah bedayant, man hechbar thagala nawarán.” ");
INSERT INTO bccl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Issáyá gwasht: “Tará rásténa gwashán, hamé maróchi, haw enshapi, taw, tai jend, cha korósay domi bángá pésar, mani pajjáh áragá say randá enkára kanay o namannay.” ");
INSERT INTO bccl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Petrosá pa deljami gwasht: “Agan gón taw mani sar ham berawt, cha tai pajjáh áragá hechbara nabajján.” É dega sajjahén moridán ham anchosh gwasht. ");
INSERT INTO bccl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Issá o áiay morid, Jetsimáni námén jágahéá shotant. Gón áyán gwashti: “Hamedá bedárét, mana rawán o dwá kanán.” ");
INSERT INTO bccl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Petros, Ákub o Yuhannái wati hamráh kortant. Anágat, yak mazanén andóh o bétáhirié áiay jesm o jáná nesht. ");
INSERT INTO bccl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Gón áyán gwashti: “Sakk paréshán án, gam o andóhán maná markig kortag, shomá edá bedárét, mawapsét o ágáh o hozzhár bét.” ");
INSERT INTO bccl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Cha ódá kammé démterá shot, dém pa chér kapt o dwá kanán gwashti: “Oo mani Pet! Agan buta kant, é sakkén sáhatá cha mani sará bethagalén.” ");
INSERT INTO bccl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Padá gwashti: “Abbá, oo mani Pet! Tai dastá har chizz buta kant, é sakkiáni jám o pyálahá cha man dur kan o bethagalén. Bale á dhawlá na ke mana lóthán, hamá dhawlá ke taw lóthay.” ");
INSERT INTO bccl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wahdé Issá per tarret, disti ke á wáb ant. Gorhá gón Shamun Petrosá gwashti: “Shamun! Wáb ay? Nabut yak sáhaté ham ágáh bemánay? ");
INSERT INTO bccl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Hozzhár bét o dwá kanét tánke ázmáesh o chakkásá makapét. Ruh, tayár o morádig ent, bale jesm nezór o nátwán.” ");
INSERT INTO bccl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yak baré padá pa dwá kanagá shot o hamá dwái kort. ");
INSERT INTO bccl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Wahdé per tarret, disti padá wáb ant. Áyáni chamm rohézag o wábénag atant o nazántesh áiá ché passaw bedayant. ");
INSERT INTO bccl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Saymi randá, padá moridáni kerrá átk o gwashti: “Angat ham waptag o árám kanagá ét? Bass ent! Á wahd o sáhat rasetag. Nun Ensánay Chokk dróhag o gonahkáráni dastá dayaga bit. ");
INSERT INTO bccl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Pád áét berawén! Á ke maná dróhit, pédák ent.” ");
INSERT INTO bccl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Issá angat habará at ke cha dwázdahén moridán yakké, bezán Yahudá, átk o raset. Áiá rombé mardom hamráh at ke zahm o latthesh gón at. É romb, cha mazanén dini péshwá, Sharyatay zánóger o kawmay kamásháni némagá ráh dayag butagat. ");
INSERT INTO bccl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yahudáyá áyáná é nesháni dátagat: “Hamáiá ke mana chokkán, Issá hamá ent. Áiá dazgir kanét o gón mohr o mohkamén negahpánié bebarét.” ");
INSERT INTO bccl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Gorhá, Yahudá tachkátachk Issáay kerrá átk o gwashti: “Oo ostád!” Randá, Issái chokket. ");
INSERT INTO bccl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yahudáay hamráhán Issá gept o dazgir kort. ");
INSERT INTO bccl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cha Issáay hamráhán yakkéá wati zahm kasshet o masterén dini péshwáay nawkaray sará orosh bort o áiay góshi sest. ");
INSERT INTO bccl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Issáyá gón hamá mardomán ke áiay dazgir kanagá átkagatant, gwasht: “Záná, man yági o rahzané án ke gón zahm o latthán pa mani geragá átkagét? ");
INSERT INTO bccl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Man har róch, shomay démá mazanén parasteshgáhá tálim dátag o shomá maná nageptag. Bale Pákén Ketábáni habar báyad ent sarjam bebant.” ");
INSERT INTO bccl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Á wahdi, moridán á yalah dát o jestant. ");
INSERT INTO bccl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Warnáé ke lilomén jámagé gwará ati o bass, Issáay randá gón kapt, áesh ham gept. ");
INSERT INTO bccl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Bale dazgir kanagay wahdá, áiay jámag lakosht o á jándará tatk. ");
INSERT INTO bccl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Issáay dazgir kanókán, Issá zort o masterén dini péshwáay kerrá bort, hamódá é dega mazanén dini péshwá, kawmay kamásh o Sharyatay zánóger mocch atant. ");
INSERT INTO bccl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petros ham dur durá Issáay randá rawán at, masterén dini péshwáay lógay péshjáhá potert o gón hezmatkárán ásay kerrá nesht o dastáni tápagá lagget. ");
INSERT INTO bccl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mazanén dini péshwá o sarókáni diwánay sajjahén básk, pa Issáay markay sezá dayagá sháhediay shóházá atant, bale sháhed néstat. ");
INSERT INTO bccl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Bázénéá, drógén sháhedi dát, bale áyáni habar gón yakdomiá yakk o hamdap naatant. ");
INSERT INTO bccl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Dega lahtén, pa drógén sháhedi dayagá pád átk o gwashtesh: ");
INSERT INTO bccl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Má eshkotag ke é mardá gwashtag: ‘Man ensánay addh kortagén é mazanén parasteshgáhá karóján o próshán o say róchay tahá yakké bandán ke ensánay jórhéntagéna nabit.’” ");
INSERT INTO bccl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Bale á sháhedáni habar ham yak dhawlá naatant. ");
INSERT INTO bccl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Masterén dini péshwá pád átk o sajjahénáni démá cha Issáyá josti kort: “Tai bárawá chónén sháhedi dayagá ant? Esháni hech passawa nadayay?” ");
INSERT INTO bccl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Bale Issá bétawár at o hech passawé nadáti. Masterén dini péshwáyá padá cha áiá jost kort o gwashti: “Taw hamá Masih, mazanshánén Hodáay Chokk ay?!” ");
INSERT INTO bccl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Issáyá passaw dát: “Man Hamá Án, shomá yak róché gendét ke Ensánay Chokk, zóráwarén Hodáay rástén némagá neshtag. Cha ásmánay jambaráni tahá ham kayt.” ");
INSERT INTO bccl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Masterén dini péshwáyá wati gwaray jámag dert o gwashti: “Angat ham márá sháhed pakár ent? ");
INSERT INTO bccl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Shomá wat eshiay kopr eshkot. Nun shomay shawr o saláh chi ent?” Sajjahénán darráént: “Eshiay sezá mark ent.” ");
INSERT INTO bccl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cha áyán lahténá, Issáay dap o démá toh kort, áiay chammesh bastant, mosht o shahmátesh jat o gwashtesh: “Nun paygambari kan!” Sepáhigán, á gept o gón latth o shahmátán mán bast. ");
INSERT INTO bccl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Á wahdá ke Petros, jahlá, péshjáhá neshtagat, cha masterén dini péshwáay móledán yakké átk. ");
INSERT INTO bccl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petrosi dist ke ásay démá neshtag o watá garm kanagá ent. Áiay némagá rogurogu cháret o gwashti: “Taw ham Issá Náseriay hamráh butagay!” ");
INSERT INTO bccl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Bale áiá namannet o gwashti: “Na, mana nazánán o sarpada nabán ke taw ché gwashagá ay.” Gón é habará, dém pa darwázagá rahádag but. Hamé damáná korósá báng dát. ");
INSERT INTO bccl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Á móledá yak baré padá Petros dist o gón áyán ke ódá óshtátagatant, gwashti: “É mard ham cha hamáyán ent!” ");
INSERT INTO bccl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Bale Petrosá padá namannet. Kammé randterá, á ke ódá óshtátagatant, padá gón Petrosá gwashtesh: “Allamá taw cha hamáyán ay, chiá ke taw ham Jalilié ay.” ");
INSERT INTO bccl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Bale Petrosá sawgend wárt o gwasht: “Mani sará Hodáay nálat bát agan dróg bebandán. É mardá ke shomá gwashét, mania nazánán.” ");
INSERT INTO bccl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Hamé damáná korósá domi báng dát. Nun Petros, Issáay hamá habaray yát o tránagá kapt ke gwashtagati: “Cha korósay domi bángá pésar, say randá mani pajjáh áragá enkára kanay.” Nun delranj but o sakk gréti. ");
INSERT INTO bccl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Sabáhá máhallah mazanén dini péshwá, kawmay kamásh, Sharyatay zánóger o sarókáni diwánay sajjahén básk hamshawr butant o Issáesh bast, gerrán kort o Pilátusay dastá dát. ");
INSERT INTO bccl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilátusá cha áiá jost kort: “Taw Yahudiáni bádsháh ay?” Issáyá passaw dát: “Taw wat gwashagá ay.” ");
INSERT INTO bccl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mazanén dini péshwá áiay sará bázén bohtám janagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilátusá padá jost kort: “Pa ché passawa nadayay? Bechár tai sará chinchok bohtám janagá ant.” ");
INSERT INTO bccl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Issáyá hech passaw nadát. Pilátus hayrán mant. ");
INSERT INTO bccl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pilátusá, har sál aiday wahdá, cha Yahudi bandigán yakké, hamá ke mardomán belóthetén, ázáta kort. ");
INSERT INTO bccl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Bandigáni tahá Bárábás námén mardé hastat. Gón hamá áshópián gerag butagat ke shóreshay wahdá hón o kóshesh kortagat. ");
INSERT INTO bccl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mardom, Pilátusay kerrá átkant, dazbandiesh kort o gwashtesh: “Har dábá ke taw gwastagén sálán kortag, embari ham hamá dábá bekan.” ");
INSERT INTO bccl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilátusá jost kort: “Shomá lóthét ke Yahudiáni bádsháhá pa shomá ázát bekanán?” ");
INSERT INTO bccl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Áiá zántagat ke dini péshwáyán, Issá pa hasadd o konnat áiay dastá dátag. Paméshká chosh gwashti. ");
INSERT INTO bccl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Bale dini péshwáyán mardom shórént o áshopéntant tán cha Pilátusá Issáay badalá, Bárábásay ázátiá belóthant. ");
INSERT INTO bccl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilátusá padá jost kort: “Gorhá é mardá ke shomá áiá Yahudiáni bádsháha gwashét, chón kanán?” ");
INSERT INTO bccl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Mardomán kukkár kort: “Salibi kassh!” ");
INSERT INTO bccl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilátusá jost kort: “Chiá bárén? Mayári chi ent?” Bale áyán géshter kukkár kort: “Salibi kassh!” ");
INSERT INTO bccl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gorhá Pilátusá, ke lótheti mardomán cha wat razá bekant, Bárábás ázát kort o Issá, shallák janáént o dáti ke salibay sará bedranjanti. ");
INSERT INTO bccl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sepáhigán, Issá wáliay kóth o márhiay péshjáhá bort o sepáhigáni sajjahén lashkar lóthet o mocch kort. ");
INSERT INTO bccl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Áyán, bádsháhi jamurangén kabáhé Issáay gwará dát, cha dhangar o konthagán tájé jórhént o áiay sará ér kort. ");
INSERT INTO bccl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Gón kalág o rishkandé, sharap o ezzat dát o gwashtesh: “Drud o drahbát, o Yahudiáni bádsháh!” ");
INSERT INTO bccl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Latthesh sará jat, dap o démá toh kort o sojdahesh kort. ");
INSERT INTO bccl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wahdé kalág o malandhesh hallént, gwaray jamurangén kabáhesh kasshet o áiay jenday godesh padá gwará dátant. Randá, dém pa salib kasshagá bortesh. ");
INSERT INTO bccl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Hamá wahdá, Keriniay shahray Shamun námén mardé, ke Eskandar o Ruposay pet at, cha keshárán dém pa shahrá áyagá distesh. Sepáhigán pa bigár gept ke Issáay salibá baddhá bekant. ");
INSERT INTO bccl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Áyán, Issá hamá jágahá áwort ke námi “Joljotá” bezán “Kámpól” ent. ");
INSERT INTO bccl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Gorhá, sharábesh morr mán kort o pa waragá dát, bale Issáyá nawárt. ");
INSERT INTO bccl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nun salibay sará dratkesh, pocch o póshákesh watmánwatá bahr kortant o pál jatesh ke bárén kayá ché rasit. ");
INSERT INTO bccl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sohbay wahd at ke Issáesh salib kasshet. ");
INSERT INTO bccl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mayárnámagay sará pa áiay jorm o mayárá chosh nebeshtagat: “Yahudiáni bádsháh.” ");
INSERT INTO bccl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Issáay hamráhiá do yági o dozzesh ham salibay sará dratk, yakké rástén o domi chappén némagá. ");
INSERT INTO bccl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","É dhawlá, Pákén Ketábay hamá péshgói sarjam but ke gwashit: Á cha radkárán zánag but. ");
INSERT INTO bccl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Rahgwazán dozhmán dayán, wati sar chandhént o gwashtesh: “Oo mazanén parasteshgáhay karójók ke gwashtaget: ‘Say róchá padá áiá addha kanán’! ");
INSERT INTO bccl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nun watá berakkén o cha salibá ér á!” ");
INSERT INTO bccl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Hamé paymá mazanén dini péshwá o Sharyatay zánóger rishkand o maskará kanagá atant o gwashtesh: “Á dega mardomi rakkéntant bale watá rakkénta nakant. ");
INSERT INTO bccl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Bell ke Masih, Esráilay bádsháh, nun cha salibá ér bekapit tánke má begendén o báwar bekanén.” Á doén ham ke gón áiá dár kasshag butagatant, Issáyá bad o rad gwashagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Némróchá beger tán bégáhay sayá, sajjahén molk anágat tahár but. ");
INSERT INTO bccl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Bégáhay sáhat sayá, Issáyá chihál jat: “Elui, Elui, lemá sabaktani?” (Bezán: Oo mani Hodá, oo mani Hodá! Taw chiá maná tahná esht?) ");
INSERT INTO bccl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ódá nazziká, lahtén óshtátagén mardomá wahdé eshkot, gwashtesh: “Bechárét, Elyásá tawár kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cha áyán yakké tacháná shot, espanjé zort o tropshén sharábá missénti. Espanji dáréay sará bast o pa chussagá Issáay némagá shahárt o gwashti: “Sabr kanét, bechárén bárén Elyás eshiay rakkénagá kayt yá na?” ");
INSERT INTO bccl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Gorhá, Issáyá borzén tawáréá chihál kasshet o sáh dát. ");
INSERT INTO bccl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Hamé wahdá, mazanén parasteshgáhay pardah, borzádá beger tán jahlád dert o do bahr but. ");
INSERT INTO bccl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Hamá pawji apsar ke Issáay dém pa démá óshtátagat, wahdé disti ke áiá chón sáh dát, gorhá gwashti: “Béshakk é mard Hodáay Chokk at.” ");
INSERT INTO bccl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lahtén janén dur óshtátag o cháragá at, gón áyán, Maryam Majdaliah, kasánén Ákub o Yusháay mát Maryam o Sálumah gón atant. ");
INSERT INTO bccl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wahdé Issá Jalilá at, é janén áiay hamráh atant o áiay hezmat o cholópagesh kortagat. Abéd cha eshán, dega bázén janéné ham ódá at ke áiay hamráhiá Urshalimá átkagatant. ");
INSERT INTO bccl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Á róch, Jomahay róch at o mardom, pa Shabbatay róchay árám kanagá, watá tayár kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Issop námén mardé ke Arimátiáay shahray nendók at, sarókáni diwánay ezzatmandén báské at o wat ham Hodáay bádsháhiay rahchár o wadárig at. Jomahay bégáhá Pilátusay kerrá shot o gón bahádorri o deléri, Issáay jónay baragay ejázati lóthet. ");
INSERT INTO bccl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Wahdé Pilátus sahig but Issá chó zutt mortag, hayrán o habakkah mant o pawjiáni masteri lóthet tán bezánt ke Issá mortag yá na? ");
INSERT INTO bccl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pawjiáni masteray sajjahén hál o habaráni eshkonagá rand, Issáay jónay baragay ejázati dát. ");
INSERT INTO bccl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Issopá, lilomén godé bahá gept o áwort, áiay jón cha salibá ér gétk o hamá goday tahá kapon kort. Kabréay tahá ke cha pésará cha talárá tráshag o tayár kanag butagat, Issái kabr kort o mazanén dhóké léth dayáná kabray dapá ér kort. ");
INSERT INTO bccl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maryam Majdaliah o Yusháay mát Maryam, har doénán dist ke áesh kojá kall kort. ");
INSERT INTO bccl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wahdé Shabbatay róch halás but, Maryam Majdaliah, Ákubay mát Maryam o Sálumahá, washbóén dáru gept ke Issáay jóná charp kanant. ");
INSERT INTO bccl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Yakshambehay bámgwáhá, dém pa Issáay kabrá shotant. ");
INSERT INTO bccl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ráhá, watmánwat habar kanagá atant ke “bárén, kabray dapay dhóká kay pa má léthénit o dura kant?” ");
INSERT INTO bccl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Bale wahdé nazzik rasetant distesh dhók, ke sakk mazan at, léthénag butag. ");
INSERT INTO bccl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kabrá ke potertant, distesh ke rástén némagá yak espétpóshén warnáé neshtag. Cha áiay gendagá, sakk hayrán o habakkah mantant. ");
INSERT INTO bccl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Warnáyá gwasht: “Matorsét, shomá Issá Náseriay shóházá ét ke salib kasshag butag. Á zendag butag, jáhi jatag o edá naent. Bechárét, é hamá jágah ent ke edá áiay jón ér at. ");
INSERT INTO bccl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nun shomá berawét, Petros o á dega moridán sahig kanét ke Issá cha shomá pésar, Jalilá rawt. Anchosh ke wat shomárá gwashtagati, hamódá áiá gendét.” ");
INSERT INTO bccl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Janén dar átk o cha kabray sará jestant. Á cha torsá larzag o drahagá atant. Paméshká, gón hechkasá habaresh nakort. ");
INSERT INTO bccl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Yakshambehay sabáhá máhallah, cha wati jáh janagá rand, Issá cha sajjahénán pésar, Maryam Majdaliahay démá paddar but. É hamá Maryam ent ke Issáyá cha áiá hapt jenn kasshetagat. ");
INSERT INTO bccl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Á shot o hamáyáná háli dát ke Issáay hamráh butagatant o nun gréwán o mótk árán atant. ");
INSERT INTO bccl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Bale wahdé áyán é habar eshkot ke Issá zendag butag o Maryamá distag, báwaresh nakort. ");
INSERT INTO bccl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Randá, Issá dega shekl o dróshoméá, do moriday démá záher but ke dém pa yak kallagéá rawagá atant. ");
INSERT INTO bccl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Á, padá átkant o é dega moridesh hál dátant, bale áyán ham báwar nakort. ");
INSERT INTO bccl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Randá, Issá wati yázdahén moridáni démá, hamá wahdá átk o záher but ke warák waragá atant. Issáyá, pa áyáni kambáwari o sengdeliá, á mayárig kortant chiá ke á mardománi habaresh báwar nakortagat ke Issáesh cha jáh janagá rand distagat. ");
INSERT INTO bccl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Gón áyán gwashti: “Shomá donyáay sajjahén kawmáni kerrá berawét o wasshén mestágá sar kanét. ");
INSERT INTO bccl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Harkas ke mani sará báwara kant o pákshódia kant, á rakkit. Bale kasé ke mani sará báwara nakant, mayáriga bit. ");
INSERT INTO bccl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Báwarmandán, é nesháni góna bant: mani námay sará, jennán cha mardomána kasshant, nók nókén zobánán habara kanant, ");
INSERT INTO bccl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","márán pa dasta gerant o agan zahrnákén chizz ham bwarant, áyán hech parwáha nabit. Gón báwarmandáni dast per moshagá, nádráh wassh o dráha bant.” ");
INSERT INTO bccl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Anchosh ke Hodáwandén Issáyá gón áyán wati habar halás kortant, ásmáná barag but o Hodáay rástén némagá nesht. ");
INSERT INTO bccl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Morid, pa áiay mestágay sheng o tálán kanagá, har molk o shahrá shotant o Hodáwand ham áyáni hamráh at o gón bázén mójezah o ajabbatén neshánián, wati habaráni barhakkii rást o paddar kort.");
INSERT INTO bccl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","3","Sharapdárén wájah Tiupilos! Anchén sargwast may nyámá sarjam butagant ke Enjilay awali hezmatkárán cha bongéjá, hamé sargwast gón wati chammán distagant o randá pa má raséntagant. Bázénéá áyáni bárawá nebeshtag o annun man johlánkén patth o pólé kortag o pa wat gehter distag ke áyán pa taw gón sharrén red o bandé benebisán, ");
INSERT INTO bccl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","tán hamá tálim ke taw geptagant, áyáni rástiay bárawá tai báwar mohr o mohkamter bebit. ");
INSERT INTO bccl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yahudiahay damagay bádsháh, Hirudisay zamánagá, Zakaryá námén dini péshwáé hastat ke cha Abiáay dini péshwáyáni thóliá at. Áiay jan, cha Hárunay nasl o padréchá at o námi Elizábet at. ");
INSERT INTO bccl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Á, har doén, Hodáay chamm o nezará nék o pahrézkár atant o Hodáwanday sajjahén hokm o rahbandáni sará pa bémayári zendesha gwázént. ");
INSERT INTO bccl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Bale chokkesh néstat, chiá ke Elizábet santh o béchokk at o doénáni omr ham mazan at. ");
INSERT INTO bccl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Yak randé ke hezmatkáriay bárig pa Zakaryáay thóliá kapt o á, Hodáay bárgáhá dini péshwái kanagá at, ");
INSERT INTO bccl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","gón dini péshwáiay rahbandáni randgiriá, Zakaryá pálay sará gechén kanag but ke á, Hodáwanday mazanén parasteshgáhá berawt o sóchoki dutt bedant. ");
INSERT INTO bccl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wahdé Zakaryá sóchoki dutt dayagá at, é dega sajjahén mardom dhanná dwá kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Anágat, Hodáwanday préshtagé, bósóchay rástén némagá, Zakaryáay démá záher but. ");
INSERT INTO bccl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Gón préshtagay gendagá, Zakaryá bah mant o áiay jesm o jáná torsé kapt. ");
INSERT INTO bccl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Bale préshtagá gón áiá gwasht: “Oo Zakaryá! Mators. Tai dwá mannag but, tai jan Elizábet mardénchokkéay sará chellaga bit o báyad ent taw áiay námá Yahyá bekanay. ");
INSERT INTO bccl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Á, pa taw shádehi o wasshia kárit o cha áiay butená bázéné ham shádána bit, ");
INSERT INTO bccl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","chiá ke á, Hodáwanday chammá mazanén mardomé bit. Nabáyad ent sharáb o dega hanósh o bésár kanókén chizzán dap per bekant o bwárt. Á, mátay lápá cha Hodáay Pákén Ruhá porra bit. ");
INSERT INTO bccl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Bázén Bani Esráiliáni delán dém pa Hodáwandá tarrénit, ke áyáni Hodá ent. ");
INSERT INTO bccl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Á, gón Elyás nabiay ruh o kodratá, cha Hodáwandá pésara kayt, tánke petáni delán chokkáni némagá betarrénit o namannókán ham pahrézkáráni hekmatay némagá chahr bedant, tánke pa Hodáwandá kawmé tayár bekant.” ");
INSERT INTO bccl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakaryáyá cha préshtagá jost kort: “Eshiá chón bezánán o báwar bekanán? Man pir án o mani jan ham mazanomr ent.” ");
INSERT INTO bccl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Préshtagá passaw dát: “Man Jebráil án o Hodáay bárgáhá óshtók án. Annun rawán dayag butagán, gón taw habar bekanán o tará é mestágá bedayán. ");
INSERT INTO bccl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","É wahdá, nun taw lell o gonga bay o tán á róchá ke é habaráni rásti allama bit, habar korta nakanay. Chiá ke taw, mani é habar ke kawl dátagén wahdá rást o paddara bant báwar nakortant.” ");
INSERT INTO bccl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Hamé wahdá, mardom dhanná Zakaryáay entezár o wadárá atant. Hayrán atant ke á chiá mazanén parasteshgáhá inkadar mahtal butagat. ");
INSERT INTO bccl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wahdé Zakaryá dhanná dar átk, áiá gón mardomán habar kort nakort. Gorhá zántesh áiá parasteshgáhá elhámé rasetag o shobéné distagi. Chiá ke áiá gón mardomán esháraha kort o habar kanagay wáki néstat. ");
INSERT INTO bccl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Zakaryá cha hezmatkáriay halásiá rand, wati lógá per tarret. ");
INSERT INTO bccl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Chizzé wahdá rand, áiay jan, Elizábetá chokkéay ométwári but o tán panch máhá, démgir but o cha lógá dara nakapt. ");
INSERT INTO bccl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Áiá gón wat gwasht: “Hodáwandá pa man choshén káré kortag, é róchán wati mehri mani sará gwáréntag o mardománi chammá é kamezzatii cha man dur kortag.” ");
INSERT INTO bccl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Shashomi máhá, Hodáyá wati préshtag Jebráil, Jalilay damagay shahr Náserahá, Maryam námén neshtagén jenekéay kerrá ráh dát ke áiay sáng gón Issop námén mardéá butagat. Issop, cha Dáuday nasl o padréchá at. ");
INSERT INTO bccl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Préshtag, Maryamay kerrá átk o gwashti: “Gal o shádán bay ke Hodáay nékén wáhagay sáhegá ay o Hodáwand gón taw gón ent.” ");
INSERT INTO bccl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Cha é habaray eshkonagá, Maryam báz paréshán but o delá gwashti: “Bárén, é dhawlén hál o hawál kanagay máná chi ent?!” ");
INSERT INTO bccl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Préshtagá gwasht: “Oo Maryam! Mators, chiá ke Hodáay mehr o rahmat tai hamráh ent. ");
INSERT INTO bccl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nun taw pa chokká ométwára bay o tará mardénchokké bit, ke báyad ent áiay námá Issá bekanay. ");
INSERT INTO bccl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Á, mazanén mardomé bit o borzén arshay Hodáay Chokk zánaga bit o Hodáwandén Hodá, áiay pet o piroki, bezán Dáuday bádsháhiay tahtá áiá bakshit. ");
INSERT INTO bccl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Á, Ákubay padréchay sará modám bádsháhia kant o áiay bádsháhi hechbara nakotthit.” ");
INSERT INTO bccl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamá cha préshtagá jost kort: “É chón buta kant ke man taningah sur nakortag o janénchokké án?!” ");
INSERT INTO bccl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Préshtagá passaw dát: “Hodáay Pákén Ruh tai sará éra kayt o borzén arshay Hodáay zór o kodrat tai sará sáhéla bit. Paméshká á, pák o Hodáay Chokk zánaga bit. ");
INSERT INTO bccl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Elizábet ham ke tai syád ent, piránsariá pa mardénchokkéá ométwár ent. Hamá ke gwashtagatesh santh o bérand ent, nun shash máh ent ke lápi porr ent. ");
INSERT INTO bccl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Chiá ke pa Hodáyá, hech káré nabuteni naent.” ");
INSERT INTO bccl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamá gwasht: “Man Hodáwanday móled án, hamé dhawlá ke taw gwashtag, anchosh bát.” Randá préshtag cha áiay kerrá shot. ");
INSERT INTO bccl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Hamá róchán, Maryam eshtápiá sar gept o Yahudiahay kóhestáni hand o damagay shahréá shot. ");
INSERT INTO bccl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ódá Zakaryáay lógá shot o Elizábeti hál o hawál kort. ");
INSERT INTO bccl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Anchosh ke Maryamay tawár Elizábetay góshán kapt, áiay lápá, chokká serr bast o Elizábet cha Pákén Ruhá porr but. ");
INSERT INTO bccl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Gón borzén tawáré gwashti: “Taw, janénáni nyámá bahtáwar ay! Bahtáwar ent hamá chokk ke tai lápá ent. ");
INSERT INTO bccl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Man kay án ke mani Hodáwanday mát mani gendagá byayt? ");
INSERT INTO bccl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wahdé tai tayárjórhiay tawár mani góshán kapt, chokk cha galá lápay tahá soret. ");
INSERT INTO bccl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Bahtáwar ay taw ke báwaret kortag, chiá ke Hodáwanday hamá habar ke gón taw gwashag butagant, sarjama bant.” ");
INSERT INTO bccl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamá, áiay passawá gwasht: “Mani sáh o ján, Hodáwandá satá o saná kant. ");
INSERT INTO bccl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mani ruh gal o bál ent, ke Hodá mani rakkénók ent. ");
INSERT INTO bccl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Chiá ke wati móleday nezórii cháretag. Cha ed o rand, sajjahén nasl o padréch maná bahtáwara zánant. ");
INSERT INTO bccl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Chiá ke á Páknámén Zóráká pa man mazanén kár kortag. ");
INSERT INTO bccl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Áiay mehr o rahmat, hamá sajjahénáni posht dar poshtá mánit ke áiay torsesh delá hastent. ");
INSERT INTO bccl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Áiá gón wati zórákén báská, mazanén kár o kerd pésh dáshtag o hamá ke wati delá bázén pahresh bastag, áiá sheng o sháng kortagant. ");
INSERT INTO bccl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Áiá, hokmrán cha wati tahtán sarshakun o garib, borz o sarperáz kortagant. ");
INSERT INTO bccl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Shodig, gón wasshén chizzán sérláp o séréni dast hórk o hálig rahádag kortagant. ");
INSERT INTO bccl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Á wati mehr o rahmatáni yát o tránagá kaptag o pa wati hezmatkárén Bani Esráili kawmá mehrabán butag, ");
INSERT INTO bccl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","bezán pa Ebráhém o áiay chokk o óbádagán abadi mehri bakshetag, hamá paymá ke gón may pet o pirokán labzi kortagat.” ");
INSERT INTO bccl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maryam, say máhay kesásá Elizábetay lógá mant o randá per tarret o wati lógá shot. ");
INSERT INTO bccl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wahdé Elizábetay máh o róch sarjam butant, áiá mardénchokké but. ");
INSERT INTO bccl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Áiay chellagiay hál ke syád o hamsáhegán sar but o eshkotesh Hodáwandá áiay sará mazanén mehr o rahmaté kortag, gorhá gón áiay wasshiá hór o sharikdár butant. ");
INSERT INTO bccl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wahdé nonnoká hasht róch but, pa áiay sonnat kanagá átkant. Áyán nonnokay nám petay námay sará, Zakaryá per bandagi at. ");
INSERT INTO bccl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Bale nonnokay mátá gwasht: “Na, áiay nám báyad ent Yahyá bebit.” ");
INSERT INTO bccl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Mardomán gwasht: “Tai kothom o hándáná, é námén mardom kass nabutag.” ");
INSERT INTO bccl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Gorhá áyán chokkay pet, Zakaryá pa eshárah jost kort ke á wati chokká chónén námé pera bandit? ");
INSERT INTO bccl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakaryáyá nebisagi dártahtagé lóthet o áiay sará nebeshti: “Chokkay nám Yahyá ent.” Gorhá sajjahén mardom hayrán butant. ");
INSERT INTO bccl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Hamá damáná Zakaryáay gongén zobán pach but o habará lagget o Hodáay satá o sanái bongéj kort. ");
INSERT INTO bccl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Cha é habará, hamsáhegán tors delá kapt o Yahudiahay damagay kóhestagáni sajjahén mardomán é bárawá habara kort. ");
INSERT INTO bccl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Harkasá ke é hál eshkot wati del o hayálá chosh gwashti: “Bárén, é chokk chónén mardomé bit?” Chiá ke Hodáwanday dast gón áiá gón at. ");
INSERT INTO bccl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Gorhá, Yahyáay pet Zakaryá, cha Pákén Ruhá porr but o péshgói kort o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Hodáwand, Esráilay Hodáyá satá o saná bát, chiá ke pa wati kawmay madat kanagá átkag o kawmi rakkéntag. ");
INSERT INTO bccl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Áiá cha wati hezmatkárén Dáuday lóg o bonjáhá, kánthé pa may rakkénagá jórhéntag, ");
INSERT INTO bccl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","anchosh ke áiá bázén wahdéá pésar, cha wati pákén nabiáni zobáná kawl dátag. ");
INSERT INTO bccl_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Áiá, cha may sajjahén dozhmen o badwáhán ke cha má naprata kanant, márá rakkéntag, ");
INSERT INTO bccl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","may pet o pirokáni sará mehr o rahmati kortag o wati pákén hamá ahd o karáray yát o tránagi dáshtag. ");
INSERT INTO bccl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Gón may pet Ebráhémá sawgendi ham kortagat, ");
INSERT INTO bccl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ke márá cha dozhmenáni dastá berakkénit, tánke bé tors o bimmá pa áiá hezmat bekanén o ");
INSERT INTO bccl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","áiay chamm o nezará wati sarjamén zendá nék o pák bebén. ");
INSERT INTO bccl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Taw, oo mani chokk! Borzén arshay Hodáay nabi zánaga bay, chiá ke taw cha Hodáwanday áyagá pésar, áiay ráh o keshká tachk o tayára kanay. ");
INSERT INTO bccl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Taw áiay kawmá é zántá dayay ke gón áyáni gonáháni pahelliá, Hodá áyána rakkénit. ");
INSERT INTO bccl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Chiá ke may Hodá mehrabán ent o cha áiay békesásén rahmatán róch cha borzén arshá, may zendmáná sara kasshit, ");
INSERT INTO bccl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","tán pa áyán ke taháróki o markay sáhegá neshtagant, rozhnái bebakshit o márá dém pa sohl o ásudagiay ráhá rahshóni bekant.” ");
INSERT INTO bccl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Á chokk, rodán o mán Pákén Ruhá zórmand bayán at. Cha Bani Esráiliáni nyámá záher bayagá pésar, gyábánána mant. ");
INSERT INTO bccl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Hamá róchán, Rumay bádsháh Kaysar Águstusá jár jat o hokm kort ke Rumay sarjamén molk mardomshomári kanag bebit. ");
INSERT INTO bccl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","É awali mardomshomári at o á wahdá, Kwirinius Suriahay wáli at. ");
INSERT INTO bccl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Harkas pa wati námay nebeshtah kanáénagá, wati pet o piroki shahrá shot. ");
INSERT INTO bccl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Issop ham cha Jalilay shahr Náserahá dar kapt o Yahudiahay shahr Bayt-Lahemá shot. Bayt-Lahem, hamá shahr ent ke bázén wahdé pésará ódá Dáud bádsháh pédá butagat. Issop, béhá cha Dáuday padréchá at, paméshká pa wati námay nebeshtah kanáénagá ódá shot. ");
INSERT INTO bccl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Issopá, wati deshtár, Maryam ham gón at ke á, pa chokkéá ométwár at. ");
INSERT INTO bccl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Hamé wahdá ke á Bayt-Lahemá atant, Maryamay chellag bayagay máh o róch sarjam butant o ");
INSERT INTO bccl_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","mardénchokkéay sará chellag but ke áiay awali chokk at. Maryamá wati nonnok godéá pétk o káhdánéay tahá wápént, chiá ke pa áyán mehmánjáhá jágah néstat. ");
INSERT INTO bccl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Hamá hand o damagá, lahtén shopánk hastat ke shapá gyábáná wati ramagesh negahpánia kort. ");
INSERT INTO bccl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Á shapá, anágat Hodáwanday préshtagé áyáni démá átk o chárén némagán Hodáwanday mazaniay shahm o rozhnái drapshán but. Cha eshiá, áyán sakk torset. ");
INSERT INTO bccl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Bale préshtagá gwasht: “Matorsét, maná mestágé gón ent ke pa shomá bázén wasshié kárit o pa sajjahén kawmá wasshén mestágé. ");
INSERT INTO bccl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Á esh ent ke Dáuday shahr Bayt-Lahemá maróchi pa shomá rakkénóké pédá butag ke á, Hodáwandén Masih ent. ");
INSERT INTO bccl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Eshiay pajjáh áragay nesháni esh ent ke shomá kahdánéay tahá, mán godéá pétkagén nonnoké gendét.” ");
INSERT INTO bccl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Anágat, cha ásmáni préshtagáni lashkará rombé á préshtagay kerrá átk o Hodáesh sepat o saná kort: ");
INSERT INTO bccl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Shán o shawkat borzén arshay Hodáyá bát o zeminay sará sohl o ásudagi pa hamá mardomán bát ke Hodá cha áyán wassh o washnód ent.” ");
INSERT INTO bccl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wahdé préshtag per tarret o ásmáná shotant, shopánkán watmánwatá shawr kort o gwashtesh: “Byáét Bayt-Lahemá berawén o hamé sargwast ke ódá butag o Hodáwandá márá hál dátag, wat begendén.” ");
INSERT INTO bccl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Gorhá á, pa eshtápi sar gept o hamódá shotant, Issop o Maryamesh dar gétkant o nonnokesh kahdánay tahá dist. ");
INSERT INTO bccl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nonnokay gendagá rand, shopánkán é chokkay bárawá harché ke cha préshtagán eshkotagat, mardom sahig kortant. ");
INSERT INTO bccl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Á mardomán ke shopánkáni habar eshkot, hayrán o habakkah mantant. ");
INSERT INTO bccl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Bale Maryamá é sajjahén habar, wati delá dáshtant o esháni sará báz pegr o hayáli kort. ");
INSERT INTO bccl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Shopánkán, harché ke eshkotag o distagat, pa áyán Hodáyá sepat o saná kanán per tarretant, chiá ke é sajjahén hamá dhawlá atant ke gón áyán gwashag butagat. ");
INSERT INTO bccl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Hashtomi róchá, wahdé nonnokay sonnat kanagay wahd átk, áiay námesh Issá per bast, hamá nám ke mátay lápá kapagá pésar, préshtagá per kortagat. ");
INSERT INTO bccl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Wahdé mát o chokkay chellagshódiay wahd halás but, Mussáay Sharyatay randgiriá, Issop o Maryamá Issá Urshalimaymazanén parasteshgáhá áwort tánke áiá Hodáwanday sepordah bekanant, ");
INSERT INTO bccl_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","anchosh ke Hodáwanday Sharyata gwashit: Awali har mardénchokk báyad ent pa Hodáwandá nadrigé hesáb kanag bebit. ");
INSERT INTO bccl_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Pa korbánig kanagá ham átkant, tán hamá dhawlá ke Hodáwanday Sharyata gwashit, “jopté shántol yá do kasánén kapót” hayrát bekanant. ");
INSERT INTO bccl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Hamá wahdá Urshalimay shahrá, Shamun námén mardé hastat ke pahrézkár o Hodádósté at o Bani Esráiliáni rakkénókay rahchár at o Hodáay Pákén Ruh, gón áiá gón at. ");
INSERT INTO bccl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Pákén Ruhá mestág dátagat, tán wahdé ke Hodáwanday Masihá magendit, á namerit. ");
INSERT INTO bccl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Cha Pákén Ruhay elhám o shobénagá, mazanén parasteshgáhay péshjáhá átkagat. Nun wahdé Issáay pet o mátá Sharyatay ráh o rahbandáni sarjam kanagá Issá Pákén Lógá áwortagat, ");
INSERT INTO bccl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Shamuná Issá zort, dastáni delá dásht, Hodá saná o satá kort o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Oo zórákén Hodáwand! Nun maná, wati é hezmatkárá, anchosh ke taw wat labz dátag, cha é jaháná pa wasshi o salámati chest kan o wati gwará bebar, ");
INSERT INTO bccl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","chiá ke man gón wati chammán cha tai némagá é neját o rakkénag distag ");
INSERT INTO bccl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ke taw sajjahén kawmáni démá paddar kort. ");
INSERT INTO bccl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Á pa dega kawmán Hodáay bárawá sarpad kanókén rozhné bit o pa tai Bani Esráili kawmá pahr o sháné.” ");
INSERT INTO bccl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Wahdé Issáay pet o mátá áiay bárawá Shamunay é habar eshkotant, hayrán butant. ");
INSERT INTO bccl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Shamuná pa áyán nékén dwá kort o gón chokkay mát, Maryamá gwashti: “Hodáyá é chokk, pa bázén Bani Esráiliáni rakkénag o bázénéay gár o bégwáh kanagá ráh dátag. É chokk neshánié bit, bale bázéné áiá namannit. ");
INSERT INTO bccl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Hamé paymá á, bázénéay deláni rázán páshka kant. Oo Maryam! Taw wati zendá mazanén gam o andóhé genday ke á gam, zahmay dhawlá tai delá kappa kant.” ");
INSERT INTO bccl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Hamódá, Ásheray kabilahay yak janéné hastat ke nabié at. Áiay nám Hanná at o áiay Petay nám Panuil at. Omri mazan at. Sur kanagá rand, hapt sáli gón wati lógwájahá gwázéntagat, ");
INSERT INTO bccl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","bale randá janózám but. Nun áiay omr hashtád o chár sál at o áiá cha mazanén parasteshgáhá dhann, pád éra nakort. Shap o róch, Hodáyá saná o satá kanán, wati wahd pa dwá o róchaga gwázént. ");
INSERT INTO bccl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Á ham, hamá sáhatá áyáni kerrá átk, Hodáay shogri gept o gón hamá sajjahén mardomán ke Urshalimay rakkénagay rahchár atant, gwashti: “É chokk hamá rakkénók ent.” ");
INSERT INTO bccl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wahdé Issáay pet o mátá Hodáwanday Sharyatay sajjahén ráh o rahband purah kortant, gorhá per tarret o Jalilá, wati shahr Náserahá átkant. ");
INSERT INTO bccl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Á chokk, rodán o zórmand bayán at. Cha zánt o zánagá sarréch at o Hodáay rahmati gón at. ");
INSERT INTO bccl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Issáay pet o mát, Issop o Maryam, har sál Sargwazay aidá,Urshalimá shotant. ");
INSERT INTO bccl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Wahdé Issáyá dwázdah sál but, wati hél o ádatay padá, aidá Urshalimá shotant. ");
INSERT INTO bccl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Aiday róch ke halás butant, per tarragay wahdá, kasánén Issáay mát o pet sahig naatant o á Urshalimá mant. ");
INSERT INTO bccl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Awali róchá, áyán wati delá pegr kort balkén gón kárwáná gón ent, paméshká yak róchéay menzelá démá shotant. Randá, áiay shóházá dar kaptant o cha wati syád o pajjárókán áiay jostesh gept. ");
INSERT INTO bccl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Bale Issáay nagendagá per tarret o pa áiay shóházá, Urshalimá shotant. ");
INSERT INTO bccl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Saymi róchá, áyán Issá mazanén parasteshgáhay péshjáhá dar gétk ke ódá á, Sharyatay zánógeráni nyámá neshtagat, áyáni habarán gósh dáragá at o cha áyán jost o pors kanagá at. ");
INSERT INTO bccl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Sajjahén eshkonók cha áiay hóshmandi o passawán hayrán atant. ");
INSERT INTO bccl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Wahdé Issop o Maryamá á dist, hayrán butant. Mátá gón áiá gwasht: “Oo mani chokk! Taw chiá gón má chosh kort? Man o tai pet gón parésháni tai shóházá butagén.” ");
INSERT INTO bccl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Issáyá passaw dát: “Shomá chiá mani shóházá butagét? Záná, nazántagó ke man báyad ent wati Petay lógá bebán?” ");
INSERT INTO bccl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bale á Issáay é habarán sarpad nabutant. ");
INSERT INTO bccl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Issá gón áyán padá Náserahá shot o áyáni sajjahén habari gept o mannetant. Áiay mátá é sajjahén habar, wati delá dáshtant. ");
INSERT INTO bccl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Issá rodán o cha zánt o zánagá sarréch bayán at o Hodá o mardomán róch pa róch dóstera but. ");
INSERT INTO bccl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Rumay bádsháh, Tiberius Kaysaray bádsháhiay pánzdahomi sál at. Hamá róchán, Pontius Pilátus, Yahudiahay wáli at. Hirudis, Jalilay hákem at. Hirudisay brát Pilipos, Eturiah o Tráhunitisay hákem at o Lisániás, Ábiliniay hákem at. ");
INSERT INTO bccl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Hanná o Kiápá, á wahday masterén dini péshwá atant. Hamá róchán, Hodáay kolaw gyábáná Zakaryáay bacch, Yahyáay sará átk. ");
INSERT INTO bccl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Yahyá, Ordonay kawray doén pahnátán har jágaha shot o Hodáay kolawi pa mardomána rasént o gwashti: “Cha wati gonáhán pashómán bebét o pákshódi bekanét ke bakshaga bét.” ");
INSERT INTO bccl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Anchosh ke é bárawá Eshayá Nabiay Ketábá nebeshtah ent: Gyábáná, kasé gwánkajant: “Hodáwanday ráhá tayár o áiay keshká rást o tachk bekanét. ");
INSERT INTO bccl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Sajjahén kandh o daragporr kanaga bant o sajjahén kóh o jomp jahl áraga bant. Chapp o chóthén ráh tachk kanaga bant o sajjahén sarkap o érkap hamdap o hamlasun kanaga bant. ");
INSERT INTO bccl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Jahánay sajjahén mardom cha Hodáay némagá rakkénag o rastgária gendant.” ");
INSERT INTO bccl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Wahdé mardom pa pákshódi kanagá átk o mocch butant, Yahyáyá gón áyán gwasht: “Oo syahmárzádagán! Kayá shomárá dháh dátag o gwashtag ke cha Hodáay áyókén kahr o gazabá rakketa kanét?! ");
INSERT INTO bccl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Anchén kár bekanét cha áyán paddar bebit ke shomá pa del cha wati gonáhán pashómán butagét. Wati delá pahr mabandét ke ‘má Ebráhémay nasl o óbádag én.’ Man shomárá gwashán ke Hodá cha é seng o dhókán ham, pa Ebráhémá chokk o óbádag pédá korta kant. ");
INSERT INTO bccl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nun tapar tayár ent drachkán cha boná begoddhit o har drachké ke sharrén bara nayárit, goddhag o ásá dawr dayaga bit.” ");
INSERT INTO bccl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Mardomán jost kort: “Gorhá má ché bekanén?” ");
INSERT INTO bccl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Áiá passaw dát: “Agan kaséá do jámag hast, yakkéá hamá kasá bedant ke áiá hecch nést o agan kaséay kerrá ward o warák hast, áyán ham bahr bekant.” ");
INSERT INTO bccl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Songi o máliátgir ham pa pákshódiá Yahyáay kerrá átkant. Jostesh kort: “Oo ostád! Má ché bekanén?” ");
INSERT INTO bccl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Gorhá áiá gwasht: “Cha gisshéntagén kesásá géshter magerét.” ");
INSERT INTO bccl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Sepáhigán ham cha áiá jost gept: “Má ché bekanén?” Passawi dát: “Pa zór cha kaséá zarr magerét o kaséay sará drógén tohmat majanét. Wati mozzay sará gozarán bekanét.” ");
INSERT INTO bccl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Mardom, Hodáay wádah dátagén rakkénókay entezár o wadárá atant, paméshká hayálesha kort ke balkén Yahyá hamá Masih ent? ");
INSERT INTO bccl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Bale Yahyáyá á sajjahén passaw dátant o gwashti: “Man shomárá tahná gón ápá pákshódia dayán, bale yak anchén kasé áyagi ent ke á cha man zórákter ent o man áiay kawshbandáni bójagay láhek ham naán. Á shomárá gón Hodáay Pákén Ruh o ásá pákshódia dant. ");
INSERT INTO bccl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Áiá cha bucch o pogán dánay jetá kanag o gisshénagá, hanshóné dastá ent. Jóháná pák o sallaha kant o dánán ambárá éra kant, bale pog o palárán anchosha sóchit ke ásesh hechbara namerit.” ");
INSERT INTO bccl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yahyáyá, mardom dega bázén sar o sój o delbaddhi ham dátant o wasshén mestág, dayán kort. ");
INSERT INTO bccl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Bale wahdé Yahyáyá, Jalilay hákem Hirudis pa é háterá sakk mayárig kort ke áiá gón wati brátay jan Hirudiáyá, náráhén nazziki hastat o dega bázén radén kári ham kortagat, ");
INSERT INTO bccl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Hirudisá wati gandahén kár gésh kort o Yahyái gept o bandig kanáént. ");
INSERT INTO bccl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wahdé Yahyá bázén mardomán pákshódi dayagá at, áiá Issá ham pákshódi dát. Wahdé Issá dwá kanagá at, hamá wahdá ásmánay dap pach but o ");
INSERT INTO bccl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Pákén Ruh, kapótéay dróshomá áiay sará ér nesht o cha ásmáná tawáré átk ke “taw mani dóstén Bacch ay, man cha taw báz wassh o razá án.” ");
INSERT INTO bccl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Issáyá kamm o gésh si sál at ke wati kári bongéj kort. Mardománi hayál at ke Issá Issopay chokk ent. Issop Háliay chokk ent o cha Háliá rand: ");
INSERT INTO bccl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Mattát, Mattáte Láwi, Láwie Malki, Malkie Yanná, Yannáe Issop, ");
INSERT INTO bccl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Issope Mattátiá, Mattátiáe Ámus, Ámuse Náhum, Náhume Hasli, Haslie Najjáy, ");
INSERT INTO bccl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Najjáye Mahat, Mahate Mattátiá, Mattátiáe Shemi, Shemie Issop, Issope Yahudá, ");
INSERT INTO bccl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yahudáe Yuhanán, Yuhanáne Risá, Risáe Zerubábel, Zerubábele Shiáltiál, Shiáltiále Niri, ");
INSERT INTO bccl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nirie Malki, Malkie Addi, Addie Kusám, Kusáme Elmudám, Elmudáme Ér, ");
INSERT INTO bccl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ére Yushah, Yushahe Elyázar, Elyázare Yurim, Yurime Mattát, Mattáte Láwi, ");
INSERT INTO bccl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Láwie Shamun, Shamune Yahudá, Yahudáe Issop, Issope Yunán, Yunáne Elyákim, ");
INSERT INTO bccl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elyákime Maliá, Maliáe Minán, Mináne Mattátá, Mattátáe Nátán, Nátáne Dáud, ");
INSERT INTO bccl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dáude Yassi, Yassie Óbayd, Óbayde Buáz, Buáze Salmun, Salmune Nahshun, ");
INSERT INTO bccl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshune Aminádáb, Aminádábe Aram, Arame Hesrun, Hesrune Páres, Párese Yahudá, ");
INSERT INTO bccl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yahudáe Ákub, Ákube Eshák, Esháke Ebráhém, Ebráhéme Tárah, Tárahe Náhur, ");
INSERT INTO bccl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Náhure Soruj, Soruje Rau, Raue Pálaj, Pálaje Ábér, Ábére Shálah, ");
INSERT INTO bccl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shálahe Kaynán, Kaynáne Arpakshád, Arpaksháde Sám, Sáme Nuh, Nuhe Lámak, ");
INSERT INTO bccl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lámake Matushálah, Matushálahe Hannuh, Hannuhe Yáred, Yárede Mahalálil, Mahalálile Kaynán, ");
INSERT INTO bccl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynáne Anush, Anushe Shays, Shayse Ádam, o Ádam cha Hodáay némagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Issá, Hodáay Pákén Ruhá sarréch, cha Ordonay kawrá per tarret o Pákén Ruh, gyábáná áiay rahshón at. ");
INSERT INTO bccl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ódá Shaytáná Issá tán chel róchá chakkáset. Á róchán áiá hech waráké nawárt. Wahdé á róch halás butant shodig but. ");
INSERT INTO bccl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shaytáná gwasht: “Agan taw Hodáay Chokk ay, gorhá é sengá begwash nagané bebit.” ");
INSERT INTO bccl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Issáyá passaw dát: “Pákén Ketábá nebisag butag ke mardom tahná pa nán zendaga nabit.” ");
INSERT INTO bccl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Gorhá Shaytáná á, yak borzén jágahéá bort o pa yak damáné donyáay sajjahén bádsháhi pésh dáshtant o ");
INSERT INTO bccl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","gwashti: “Man esháni sajjahén was o wák o shawkatá tará dayán, chiá ke é mani dastá kaptagant o man harkasá belóthán, dayánesh. ");
INSERT INTO bccl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Paméshká, agan taw maná parastesh bekanay, é sajjahén taiga bant.” ");
INSERT INTO bccl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Issáyá passaw dát: “Pákén Ketábá nebisag butag: wati Hodáwandén Hodáyá parastesh bekan o tahná hamáiay hezmatá bekan.” ");
INSERT INTO bccl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Randá, Shaytáná Issá Urshalimá bort, mazanén parasteshgáhay diwálay borzterén jágahá óshtárént o gwashti: “Agan taw Hodáay Chokk ay gorhá watá cha edá jahlád dawr beday. ");
INSERT INTO bccl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Chiá ke Pákén Ketábá nebisag butag: Hodá pa tai negahpániá wati préshtagán hokma kant o ");
INSERT INTO bccl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","á, tará wati dastáni delá dárant tán tai pád dhókéá malaggit.” ");
INSERT INTO bccl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Issáyá passaw dát: “Pákén Ketáb chosh ham gwashit: Wati Hodáwandén Hodáyá machakkás o ázmáesh makan.” ");
INSERT INTO bccl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Shaytáná, wahdé wati sajjahén chakkás halás kortant, Issái pa dega sharterén wahd o móhéá esht o shot. ");
INSERT INTO bccl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Gorhá Issá gón Pákén Ruhay zór o wáká Jalilá per tarret o áiay nám o tawár á sajjahén damagá sar but. ");
INSERT INTO bccl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Issáyá áyáni kanisaháni tahá tálima dát o sajjahén mardomán á satá kort o sárhát. ");
INSERT INTO bccl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Gorhá, Náserahá shot, hamódá ke rostag o mazan butagat. Shabbatay róchá, wati hél o ádatay sará kanisahá átk. Ódá pa wánagá óshtát. ");
INSERT INTO bccl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Eshayá Nabiay Ketábesh áiay dastá dát. Anchosh ke áiá pach kort, chammi pa hamá bahrá kapt ke gwashit: ");
INSERT INTO bccl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Hodáwanday Ruh mani sará ent, áiá maná dast per moshtag tánke wár o nézgárán wasshén mestágé berasénán, maná démi dátag ke bandig o asirán ázátiay basháratá bedayán o pa kórán bináiay mestágá berasénán, zolm distagénán berakkénán o ");
INSERT INTO bccl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Hodáwanday mehr o rahmatay sálay basháratá bedayán.” ");
INSERT INTO bccl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Gorhá, Issáyá ketáb pétk, kanisahay hezmatkáray dastá dát o nesht. Parasteshgáhay sajjahén mardom áiay némagá cháragá atant. ");
INSERT INTO bccl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Issáyá gón áyán gwasht: “Maróchi gón shomay gósh dáragá, Pákén Ketábay é nebeshtahay rásti pakká o sarjam but.” ");
INSERT INTO bccl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Harkasá pa áiá sharrén gwáhié dát o cha áiay pormehrén habarán, sajjahén mardom hayrán o habakkah mantant. Gwashtesh: “Bárén, é hamá Issopay chokk naent?” ");
INSERT INTO bccl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Issáyá gón áyán gwasht: “Man deljam án shomá é batalá pa mana kárét ke ‘agan taw dáktaré ay gorhá pésará watá dráh bekan. Hamá mójezah ke má eshkotag taw Kaparnáhumá kortagant, áyán edá wati shahr o hankéná ham pésh bedár.’” ");
INSERT INTO bccl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Géshi kort: “Shomárá rásténa gwashán, hech nabiéá wati shahr o hankéná sharap nést. ");
INSERT INTO bccl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Deljam bebét ke Elyás nabiay zamánagá, wahdé tán say o ném sálá ásmánay dap band but o sajjahén molká mazanén dhokkálé kapt, Esráilá bázén janózámé hastat. ");
INSERT INTO bccl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bale Elyás pa komaká cha áyán yakkéay kerrá ham ráh dayag nabut, tahná Saydunay shahr Sarapahá, pa yak janózáméay komaká rawán dayag but. ");
INSERT INTO bccl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Hamé paymá, Elishá nabiay zamánagá, Esráilá bázéné syahgarray nádráhiá geptagat, bale yakké ham dráh nabut. Tahná Nómán námén mardé rakket ke á Suriahay molká nendók at.” ");
INSERT INTO bccl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Cha é habaráni eshkonagá, kanisahay neshtagén mardom zahr geptant. ");
INSERT INTO bccl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Pád átkant o Issáesh télánk dayán cha shahrá dar kort o hamá kóhay kashagá bort ke shahr á kóhay sará addh butagat, tánke jahlád dawri bedayant. ");
INSERT INTO bccl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Bale Issá cha mardománi nyámá dar átk, wati ráhi gept o shot. ");
INSERT INTO bccl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Randá, Issá Kaparnáhumá shot, ke Jalilay damagay shahré. Shabbatay róchá, parasteshgáhay tahá mardomi tálim dátant. ");
INSERT INTO bccl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Issáay tálimáni gósh dárók cha áiay habaráni eshkonagá hayrán atant, chiá ke áiá gón wák o ehtiár, gapp o trána kort. ");
INSERT INTO bccl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kanisahay tahá yak mardéá ke áiá jenné per at, kukkár kanáná gwasht: ");
INSERT INTO bccl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oo Issá Náseri! Tará gón má che kár ent? Átkagay ke márá gár o tabáh bekanay? Mana zánán taw kay ay, taw Hodáay gechén kortagén hamá Pákén ay.” ");
INSERT INTO bccl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Issáyá jenn hakkal dát o gwashti: “Wati dapá bedár o é mardá yalah day!” Jenná mardománi démá á mard zeminá dawr dát o anchosh dar átk ke á mardá hech noksáné naraset. ");
INSERT INTO bccl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Cha é kárá sajjahén mardom hayrán butant o watmánwatá gwashtesh: “É chónén habaré?! Gón wák o ehtiáré jennán hokma dant o á ham mardomán yalaha kanant.” ");
INSERT INTO bccl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nun, kerr o gwaray sajjahén halk o hankénán, Issáay nám o tawár prosht o sheng but. ");
INSERT INTO bccl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Issá cha kanisahá dar kapt o Shamunay lógá shot. Shamunay wassig, trondén tapéá geptagat. Shamunay lógay mardomán, pa áiay dráh kanagá gón Issáyá dazbandi kort. ");
INSERT INTO bccl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Issá shot, áiay kashá óshtát o tapi hakkal dát. Hamá damáná tapi sest o pa áyáni hezmat kanagá pád átk. ");
INSERT INTO bccl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Rónendá, mardomán har dhawlén nádráh Issáay kerrá áwortant o áiá nádráháni sará dast per mosht o dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jenn, cha bázén mardomán dar átkant o kukkár kanán gwashtesh: “Taw Hodáay Chokk ay,” chiá ke áyán zántagat, á Hodáay hamá gechén kortagén Masih ent. Bale Issáyá hakkal dayán bétawár kortant. ");
INSERT INTO bccl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wahdé róch but, Issá yak gestá o panáhén jágahéá shot. Mardom áiay shóházá atant. Wahdé áyán Issá dist, gwashtesh: “Gón má bejall o márá yalah maday.” ");
INSERT INTO bccl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Issáyá gwasht: “Maná Hodáay bádsháhiaymestág, á dega shahrán ham rasénagi ent, chiá ke Hodáyá maná pa hamé kárá ráh dátag.” ");
INSERT INTO bccl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Gorhá Yahudiahay sajjahén kanisahán, wasshén mestági jár jat. ");
INSERT INTO bccl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yak randé Issá Genisáretay mazangwarmay lambá óshtátagat o mardom Hodáay habaráni gósh dáragá, yakdomiá télánk dayán, áiay chapp o chágerdá mocch atant. ");
INSERT INTO bccl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Áiá, gwarmay kerrá do bójig dist. Máhigir cha bójigán ér kaptagatant o wati dám o máhórán shódagá atant. ");
INSERT INTO bccl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Issá cha hamá bójigán yakkéá ke Shamunayg at, swár but. Cha Shamuná lótheti bójigá cha tayábá kammé dur bebárt. Randá nesht o cha hamódá mardománi tálim dayagá lagget. ");
INSERT INTO bccl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wahdé habari halás butant, gón Shamuná gwashti: “Bójigá gwarmay johlánkián bebar o wati dámán pa máhigay shekárá ápá dawr bedayét.” ");
INSERT INTO bccl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Shamuná gwasht: “Wájah! Dóshi má sajjahén shap delsyáhi kasshetag o márá hech máhig dastá nakaptag, bale nun ke taw gwashay, man dámán ápá dawra dayán.” ");
INSERT INTO bccl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Áyán dám ápá dawr dátant o haminchok máhigesh gept ke dám deragi butant. ");
INSERT INTO bccl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Paméshká, domi bójigay neshtagén hamkáresh, gón eshárah pa komaká tawár kortant. Á átkant o doén bójig cha máhigá haminkadar porr butant ke ápá boddhagi atant. ");
INSERT INTO bccl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wahdé Shamun Petrosá é kár dist, cha torsá Issáay pádán kapt o gwashti: “Oo Hodáwand! Maná yalah day o beraw, chiá ke man gonahkáré án.” ");
INSERT INTO bccl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Cha bázén máhigáni shekárá, Shamun Petros o áiay sajjahén hamkár hayrán atant. ");
INSERT INTO bccl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Hamé dhawlá, Zebdiay doén chokk, Ákub o Yuhanná ke Shamunay sharikdár atant, ham hayrán butant. Issáyá gón Shamuná gwasht: “Mators! Tán é wahdá taw máhig shekár kortag, cha ed o rand mardománi delán shekára kanay.” ");
INSERT INTO bccl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Padá áyán wati bójig o dám tayábá áwortant o wati sajjahén kár o bár yalah dátant o Issáay hamráh butant. ");
INSERT INTO bccl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Dega róché, Issá yak shahréá at. Ódá mardé sará tán pádá syahgarray nádráhiá geptagat. Wahdé Issái dist, átk o dém pa chér kapt, dazbandii kort: “Oo wájah! Agan taw belóthay maná wassh o palgár korta kanay.” ");
INSERT INTO bccl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Issáyá wati dast shahárt, dasti per mosht o gwashti: “Mana lóthán. Dráh o pák bebay!” Hamá damáná, syahgarrá mard yalah dát. ");
INSERT INTO bccl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Issáyá á hokm dát o kaddhan kort: “É habará gón hechkasá magwash, bale beraw, watá dini péshwáyá pésh bedár o pa wati pák o palgáriá, hamá korbánig ke Mussáay Sharyatá nebisag butag, hayráti bekan tánke pa áyán gwáh o sháhedié bebit.” ");
INSERT INTO bccl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Bale Issáay nám o tawár angat ham har jáh sheng o tálána but o bázén mardom pa áiay habaráni gósh dárag o wati nájórhiáni dráh kanáénagá átk o áiay kerrá moccha butant. ");
INSERT INTO bccl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Issá géshter, cha mardomán dur, gestá o tahná, barr o gyábánán dwá kanagá at. ");
INSERT INTO bccl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yak róché, Issá dars o sabak dayagá at. Lahtén Parisi o Sharyatay ostád, ke cha Jalil o Yahudiahay sajjahén métagán o cha Urshalimá átkagat, hamódá neshtagatant. Pa nádráháni dráh kanagá, Hodáwanday zór o twán gón Issáyá gón at. ");
INSERT INTO bccl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Hamá wahdá lahtén mardomá, tahtéay sará yak lang o mondhén mardé gón at o átkant. Áyán báz johd kort ke áiá Issáay démá byárant, ");
INSERT INTO bccl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","bale cha mardománi bázén mocchiá, áyán lógay tóká átk nakort. Paméshká, nádráhesh zort, lógay sará sar kaptant o nádráhesh gón tahtá cha bánay sará jahlád, Issáay démá ér dát. ");
INSERT INTO bccl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wahdé Issáyá áyáni é báwar dist, gwashti: “Oo mani dóst! Tai gonáh bakshag butant.” ");
INSERT INTO bccl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Cha Issáay é habará, Parisi o Sharyatay é dega zánóger, ke ódá neshtagatant, pegr kanagá atant: “É kay ent ke kopra kant?! Abéd cha Hodáay jendá, dega kass gonáhán pahell kort o baksheta nakant.” ");
INSERT INTO bccl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Bale Issáyá áyáni delay hál o habar zántant o gwashti: “Shomá chiá wati delá choshén hayála kárét? ");
INSERT INTO bccl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kojám habaray gwashag ásánter ent: ‘Tai gonáh bakshag butagant,’ yá: ‘Pád á, beraw?’ ");
INSERT INTO bccl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bale tán shomá bezánét, maná ke Ensánay Chokk án, é donyáyá gonáháni pahell kanagay wák o ehtiár hast...” padá gón á langá gwashti: “...tará gwashán, pád á, wati taht o gandalán bezur o lógá beraw.” ");
INSERT INTO bccl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Hamá damáná, mard sajjahénáni démá pád átk, wati taht o gandali baddhá kortant o Hodáyá sepat o satá kanán lógá shot. ");
INSERT INTO bccl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Cha é káray gendagá, óday neshtagén mardom hayrán o habakkah butant, Hodáesh satá kort o sárhát o pa torsé gwashtesh: “Maróchi má chónén bah mánagén kár distag!” ");
INSERT INTO bccl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Randá, Issá dhanná dar átk o Láwi námén yak songi o máliátgirén mardé disti, ke wati káray jágahá neshtagat. Issáyá gwasht: “Byá, mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Láwi pád átk o sajjahén chizzi yalah dátant o áiay hamráh but. ");
INSERT INTO bccl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Gorhá Láwiá wati lógá pa Issáay sharapá, pormarháhén mehmánié kort. É mehmániá, bázén máliátgir o lahtén dega mardom gón áyán gón at. ");
INSERT INTO bccl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi o áyáni Sharyatay zánógerán, gón Issáay moridán gelag kanáná gwasht: “Shomá chiá gón songi o gonahkárán yakkén wánay sará warét o nóshét?” ");
INSERT INTO bccl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Issáyá gwasht: “Dráh o salámatén mardomán, dáktar pakár naent, nádráhán dáktar pakár ent. ");
INSERT INTO bccl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Man pa pahrézkárán nayátkagán, gonahkáráni lóthag o gwánk janagá átkagán, ke á cha wati sellén kárán pashómán bebant.” ");
INSERT INTO bccl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Lahténá, cha Issáyá jost kort: “Yahyáay morid géshter róchaga dárant o zegr o dwá kanant. Parisiáni morid ham anchosha kanant, bale tai morid modáma warant o nóshant.” ");
INSERT INTO bccl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Issáyá gwasht: “Suray mehmán, tán wahdé ke sálónk gón áyán gón ent, pa róchagay dáragá hojj kanaga bant? ");
INSERT INTO bccl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bale wahdé kayt ke sálónk cha áyán jetá kanaga bit, gorhá á róchaga bant.” ");
INSERT INTO bccl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Issáyá é mesál ham dát: “Hechkas cha nókén pashkéá chondhé naborrit o kwahnén pashká pacch o pinaga najant o agan chosh bekant nókén pashká derrit. Kwahnén pashk ham gón nókén pacchá dhawldára nabit. ");
INSERT INTO bccl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Hamé dhawlá, hechkas nókén sharábá kwahnén zekkán mána nakant, chiá ke nókén sharáb, zekká trákénit. Sharába rechant o zekk ham zawála bit. ");
INSERT INTO bccl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Nókén sharáb, báyad ent nókén zekká mán réchag bebit. ");
INSERT INTO bccl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kasé ke kwahnén sharábay waragá héldár ent, nókén sharába nawárt. Pa áiay delá kwahnén sharáb támdárter ent.” ");
INSERT INTO bccl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Yak baré Shabbatay róchá, Issá cha gandomi keshárán gwazagá at. Áiay morid gandomi hóshagán sendag o gón wati dastán moshag o waragá atant. ");
INSERT INTO bccl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Gorhá cha Parisián lahténá gwasht: “Chiá anchén kára kanét ke Shabbatay róchá rawá naent?” ");
INSERT INTO bccl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Issáyá passaw dát: “Záná, shomá nawántag, wahdé Dáud o áiay hamráh shodig butant, gorhá Dáudá ché kort? ");
INSERT INTO bccl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Á, Hodáay Pákén Lógá shot, Hodáay námá hamá hayráti o pákwandhén náni zort, wártant o wati hamráháná ham pa waragá dáti, ke áyáni warag tahná pa dini péshwáyán rawá at.” ");
INSERT INTO bccl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Padá Issáyá gón áyán gwasht: “Maná, ke Ensánay Chokk án, Shabbatay róchay ehtiár hast.” ");
INSERT INTO bccl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Dega Shabbatay róché, Issá kanisahá shot o mardománi tálim dayagá goláésh but. Hamódá, yak mardé at ke rástén dasti hoshk o mondh at. ");
INSERT INTO bccl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sharyatay zánóger o Parisi, Issáyá cháragá atant o yak nimmónéay shóházá atant ke “agan é marday dastá Shambehay róchá dráh bekant, gorhá má áiay sará Shabbatay róchá kár kanagay bohtámá jata kanén.” ");
INSERT INTO bccl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Issáyá áyáni delay hál o habar zánt. Gón mondhén mardá gwashti: “Pád á, byá démá bósht, mardom tará begendant!” Á mard pád átk o óshtát. ");
INSERT INTO bccl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Gorhá Issáyá cha mardomán jost kort: “Nun maná begwashét ke Shabbatay róchá néki kanag rawá ent yá badi? Ensánay zenday rakkénag rawá ent, yá koshag o gár kanag?” ");
INSERT INTO bccl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Gorhá sajjahénáni némagá cháret o gón á mardá gwashti: “Dastá shahár day!” Áiá anchosh kort o dasti wassh o dráh but. ");
INSERT INTO bccl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Sharyatay zánóger o Parisi sakk zahr geptant o watmánwatá shawr o saláhesh kort ke gón Issáyá ché bekanant. ");
INSERT INTO bccl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Hamá wahdá yakk róché, Issá pa dwá kanagá kóhá shot o sajjahén shapi gón Hodáyá pa dwá gwázént. ");
INSERT INTO bccl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wahdé róch but, áiá morid wati kerrá lóthetant o cha áyán dwázdah kas gechén kort o wati hásén kásed náméntant. ");
INSERT INTO bccl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Áyáni nám esh ant: Shamun ke Issáyá áiay nám “Petros” per bast, áiay brát Andriás, Ákub, Yuhanná, Pilipos, Bartulumá, ");
INSERT INTO bccl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mattá, Tumá, Halpiay chokk Ákub, Shamun ke áiay pannám “sarmachár” ent, ");
INSERT INTO bccl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Ákubay chokk Yahudá o Yahudá Eskaryuti ke randá Issái dróhagi o dozhmenáni dastá dayagi at. ");
INSERT INTO bccl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Issá gón moridán cha kóhá ér kapt o yak patth o pachén jágahéá óshtát. Cha áiay moridán bázéné ódá at. Cha Yahudiah, Urshalim o Sur o Saydunay tayábgwaray mardomán, mazanén rombé ham átk o mocch but. ");
INSERT INTO bccl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mardománi é mazanén mocchi, pa áiay habaráni gósh dárag o wati nádráhiáni dráh kanáénagá átkagat. Á ke palitén ruhán dochár atant ham dráh kanag butant. ");
INSERT INTO bccl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Mardomán Issáay dast per kanagay kóshesha kort, chiá ke cha áiá yak anchén wák o twáné dar áyagá at ke sajjahéni dráha kortant. ");
INSERT INTO bccl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Issáyá wati moridáni némagá cháret o gwashti: “Bahtáwar ét shomá ke wár o bazzag ét, chiá ke Hodáay bádsháhi shomayg ent. ");
INSERT INTO bccl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Bahtáwar ét shomá ke annun shodig ét, chiá ke séra bét. Bahtáwar ét shomá ke annun gréwán ét, chiá ke kandána bét. ");
INSERT INTO bccl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Bahtáwar ét shomá, wahdé mardom pa Ensánay Chokkaygi shomárá ázára dayant o cha wat dur o gestá kanant, dozhmána dayant o bannáma kanant. ");
INSERT INTO bccl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Á róchá, shádkámi bekanét o gal o bál bebét, chiá ke ásmáná shomay mozz sakk báz ent. Áyáni pet o pirénán ham gón nabián hamé dhawlá kortag. ");
INSERT INTO bccl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Bale bazhn o apsóz pa shomá ke hastómand ét, chiá ke shomárá árám o ásudagi rasetag. ");
INSERT INTO bccl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Bazhn o apsóz pa shomá ke annun sér ét, chiá ke shodiga bét. Bazhn o apsóz pa shomá ke annun kandán ét, chiá ke gamnák o gréwána bét. ");
INSERT INTO bccl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Bazhn o apsóz pa shomá, wahdé ke sajjahén mardom shomárá satá dayant o sárháyant, chiá ke áyáni pet o pirénán ham gón drógén nabián, anchosh kort. ");
INSERT INTO bccl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Oo mani gósh dárókán! Shomárá gwashán ke gón wati dozhmenán mehr bekanét o gón áyán ham ke cha shomá naprata kanant, néki bekanét. ");
INSERT INTO bccl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Pa áyán ke shomárá badén dwá kanant barkat belóthét, pa áyán ke shomárá ázára dayant nékén dwá belóthét. ");
INSERT INTO bccl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Agan kaséá tará shahmáté jat, wati domi gobbá ham áiay némagá betarrén o agan kaséá tai kabáh pach gept, belli ke tai pashká ham bebárt. ");
INSERT INTO bccl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Agan kasé cha taw chizzé lóthit, bedayi, agan kasé tai chizzé pa zór bebárt, padá malóthi. ");
INSERT INTO bccl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gón degarán hamá dhawlá néki bekanét ke cha áyána lóthét. ");
INSERT INTO bccl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Agan shomá tahná gón hamáyán mehr bekanét ke gón shomá mehra kanant, gorhá shomá chónén sób o páedagé katthetag? É kár, gonahkáráni dastá ham buta kant. ");
INSERT INTO bccl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Agan shomá gón hamáyán néki bekanét ke gón shomá nékia kanant, gorhá shomárá che páedagé rasit? Gonahkár ham anchosha kanant. ");
INSERT INTO bccl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Agan shomá tahná hamáyán wám bedayét ke ométa kasshét zortagén wámán dát korta kanant, gorhá shomárá che mozzé rasit? Gonahkár ham gonahkárán wáma dayant o padá pacha gerant. ");
INSERT INTO bccl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Bale shomá gón wati dozhmenán ham mehrabán bebét, gón áyán néki bekanét, wámesh bedayét o padá malóthét. É dhawlá, shomárá cha Hodáay némagá, mazanén mozzé rasit o shomá mazanshánén Hodáay Chokka bét, chiá ke á, gón náshogr o badkárén mardomán ham mehrabán ent. ");
INSERT INTO bccl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Hamá dhawlá ke shomay ásmáni Pet rahmdel ent, shomá ham rahmdel bebét. ");
INSERT INTO bccl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Degarán ér majanét o iráz magerét, tánke shomá ér janag mabét. Kaséá mayárig makanét, tánke mayárig kanag mabét, degarán pahell kanét o bebakshét tánke pahell kanag o bakshag bebét. ");
INSERT INTO bccl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bedayét tán shomárá ham dayag bebit. Shomay dátagénáni badalá, sarréch o dapádapén kayl o paymánah, shomay kotthá réchaga bit, chiá ke, gón har kayléá bedayét, gón hamá kaylá shomárá dayaga bit.” ");
INSERT INTO bccl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","É mesáli ham pa áyán áwort: “Kóré che paymá dega kóréá ráhá pésh dáshta kant? Har doén chátá nakapant? ");
INSERT INTO bccl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Shágerd cha wati ostádá zántkártera nabit, bale hamá ke rost o rodóma gipt o cha tálimá sarrécha bit, wati ostáday dhawlá buta kant. ");
INSERT INTO bccl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Chiá wati brátay chammay pilláshká genday, bale wati chammay bondhá nagenday? ");
INSERT INTO bccl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Wahdé taw wati chammay bondhá nagenday, chón wati brátá gwashta kanay: ‘Bell ke tai chammay pilláshká dara kanán?’ Oo dopóstén shatalkár! Pésará wati chammay bondhá dar kan, randá tai chamm pacha bant o wati brátay chammay pilláshká kassheta kanay. ");
INSERT INTO bccl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Hech sharrén drachké sellén bar o nibaga nayárit o na sellén drachk sharrén bar o nibaga kárit. ");
INSERT INTO bccl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Har drachk, cha wati bará zánaga bit. Na cha dhangarán enjir chenaga bit o na cha dhóloká angur. ");
INSERT INTO bccl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Sharrén mardom, wati delay hazánagay ér kortagén nékián, cha wati dap o zobáná dara kant o sellén mardom, wati delay ambáray ér kortagén gandagián, cha wati dap o zobáná réchit. Chiá ke harché mardomay delá bebit, hamá cha áiay dapá dara kayt. ");
INSERT INTO bccl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Wahdé shomá mani habaráni sará kára nakanét, gorhá chiá maná ‘Hodáwand, Hodáwanda’ gwashét? ");
INSERT INTO bccl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Á kas ke mani habaráni eshkonagá kayt o áyáni sará kára kant, man shomárá pésha dárán ke á, kai paymá ent. ");
INSERT INTO bccl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Á hamá bánbandén ostáay dhawlá ent ke pa lógay bandagá cholli johl borret o bonredi taláray sará ér kort. Wahdé hár o hirróp átk, hárá á lóg sorént nakort, chiá ke mohr o mohkam bandag butagat. ");
INSERT INTO bccl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bale kasé ke mani habarán gósha dárit o áyáni sará kára nakant, hamá mardomay paymá ent ke lógi bé bonredá bast. Wahdé hár o hirróp átk, lóg hárá mallet, kapt o pahk wayrán but.” ");
INSERT INTO bccl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wahdé Issáyá gón mardomán wati habar halás kortant, Kaparnáhumá shot. ");
INSERT INTO bccl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ódá, yak Rumi pawji apsaréá, hezmatkáré hastat ke áiá báz dóst at. Á hezmatkár, sakk nádráh o markig at. ");
INSERT INTO bccl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wahdé á pawji apsar Issáay bárawá sahig but, áiá Yahudiáni lahtén kamáshén mardom Issáay kerrá ráh dát tán áiay mennatgiriá bekanant o begwashanti ke byayt o áiay hezmatkárá dráh bekant. ");
INSERT INTO bccl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Á Yahudi kamásh Issáay kerrá átkant, áiay mennatesh gept o gwashtesh: “É pawji apsara karzit ke taw pa áiá é kárá bekanay. ");
INSERT INTO bccl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Chiá ke may kawmay dózwáh ent. May kanisah ham hamáiá addh kanáéntag.” ");
INSERT INTO bccl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Issá áyáni hamráh but o shot. Wahdé lógay nazziká rasetant, pawji apsará wati lahtén dóst kásed kort o pa Issáyá, kolawi rawán dát: “Oo Hodáwand! Watá zahmatwár makan. Mana nakarzán ke taw mani lógá byáay o ");
INSERT INTO bccl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","man pa wat é láhekiá ham nagendán ke tai kerrá byáyán. Taw tahná hokm bekan, mani hezmatkár dráha bit. ");
INSERT INTO bccl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Chiá ke man ham wati masteráni hokmay chérá án o mani dastay chérá ham sepáhig hast. Agan kaséá hokm bekanán ‘beraw,’ á rawt o agan kaséá begwashán ‘byá,’ á kayt. Agan wati hezmatkárá begwashán ‘é kárá bekan,’ á kant.” ");
INSERT INTO bccl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Wahdé Issáyá é habar eshkot, hayrán but o démi gón wati hamráhén mardomán kort o gwashti: “Shomárá gwashán, man choshén mohrén setk o báwar Esráiliáni nyámá ham nadistag.” ");
INSERT INTO bccl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wahdé pawji apsaray kásed per tarret o lógá átkant, distesh ke hezmatkár wassh o dráh ent. ");
INSERT INTO bccl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Dér nagwast, Issá gón wati morid o dega bázén mardománi hamráhiá, Náin námén shahréá shot. ");
INSERT INTO bccl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wahdé shahray darwázagay nazziká raset, disti mardom yak mordagé cha shahrá dhann baragá ant ke á wati janózámén mátay yakkén chokk at. Shahray bázén mardom ham, gón á janózámá gón atant. ");
INSERT INTO bccl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wahdé Hodáwandén Issáyá á janózám dist, áiay sará sakk bazzagi but o gwashti: “Magréw.” ");
INSERT INTO bccl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nazzik átk o mordagay tahti dast per kort, mordagay kópag dayók óshtátant. Issáyá mordag gwánk jat: “Oo warná! Man tará gwashán, pád á.” ");
INSERT INTO bccl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mordag pád átk o nesht o habará lagget. Issáyá á warná mátay dastá dát. ");
INSERT INTO bccl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Sajjahénáni delá torsé nesht o Hodáyá sepat o saná kanán, gwashtesh: “May kerrá mazanén nabié wadi butag” o “Hodá wati kawmay komak kanagá átkag.” ");
INSERT INTO bccl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Issáay hál o habar, sajjahén Yahudiah o kerr o gwaray sardhagárán tálán but. ");
INSERT INTO bccl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Pákshódókén Yahyáay moridán, Yahyá cha Issáay é ajabén kárán sahig kort, paméshká Yahyáyá cha wati moridán do kas lóthet o ");
INSERT INTO bccl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","pa jost kanagá Hodáwandén Issáay kerrá dém dát ke “bárén, taw hamá ay ke áyagi at, yá pa degaréá rahchár bebén?” ");
INSERT INTO bccl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Á doén Issáay kerrá átkant o gwashtesh: “Márá pákshódókén Yahyáyá pa é habaray jostá ráh dátag: ‘Bárén, taw hamá ay ke áyagi at, yá pa degaréá rahchár bebén?’” ");
INSERT INTO bccl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Hamá wahdá, Issá bázén nájórh o nádráhán dráh kanagá at, cha jennián, palitén ruhán kasshagá at o bázén kóráni chammán, rozhnái bakshagá at. ");
INSERT INTO bccl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Issáyá passaw dátant: “Harché ke shomá distag o eshkotag, berawét Yahyáyá sahig kanét ke kór gendag o maym kanagá ant, lang tarrag o ráh rawagá ant, garri pák o palgár bayagá ant, karr eshkonagá ant, mordag zendag bayagá ant o bazzag o nézgárán wasshén mestág sar bayagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bahtáwar hamá ent, ke mani káráni gendagá thagal mawárt o malakoshit.” ");
INSERT INTO bccl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wahdé Yahyáay kásed dar kapt o shotant, Issá gón mardomán Yahyáay bárawá gapp o trán kanagá lagget: “Chónén chizzéay cháragá gyábáná shotagét? Kalam o káshay dhilléay cháragá ke gón gwátay kasshagá é dém o á dém shikka wárt? ");
INSERT INTO bccl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Agan na, gorhá chónén chizzéay cháragá shotagét? Anchén mardéay cháragá shotagét ke narm o názorkén pósháki gwará at? Á mardom ke brahdárén póshák gwará kanant o hastómandáni dhawlá zenda gwázénant, kalát o márhián nendók ant. ");
INSERT INTO bccl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Gorhá ódá shomá chónén chizzéay cháragá shotagét? Paygambaréay cháragá? Haw, shomárá gwashán ke Yahyá cha paygambaréá ham master ent. ");
INSERT INTO bccl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Á hamá ent ke áiay bárawá nebisag butag: Bechár, man wati kásedá cha taw pésar ráha dayán ke á, tai ráhá tachk o tayára kant. ");
INSERT INTO bccl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Man shomárá gwashán ke hech mátá pákshódókén Yahyáay warhén bématthén chokké nayáwortag. Bale Hodáay bádsháhiá, hamá ke cha sajjahénán kaster ent, á cha Yahyáyá ham master ent. ");
INSERT INTO bccl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Wahdé Yahyáyá Hodáay paygám áwort, bázén mardomán, songi o máliátgirán ham mannet ke Hodáay kolaw o paygám rást ent, chiá ke á Yahyáay dastá pákshódi dayag butagatant. ");
INSERT INTO bccl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bale Parisi o Sharyatay kázián cha Yahyáay dastá pákshódi nagept o Hodáay lóth o wáhagesh pa wat namannet. ");
INSERT INTO bccl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“É zamánagay mardomán kai hamdarwar bekanán ke á, kai dhawlá ant? ");
INSERT INTO bccl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Á, hamá chokkáni paymá ant ke bázárá neshtagant o yakdomiá gwashagá ant: ‘Má pa shomá nal o kalam sáz kort, bale shomá nách o sohbat nagept, má pa shomá mótk áwort, bale shomá arsé narétk.’ ");
INSERT INTO bccl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Pákshódókén Yahyá átkág, na náni wárt o na sharábi nóshet o shomá gwashét: ‘Jenni per ent,’ ");
INSERT INTO bccl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","bale Ensánay Chokk átkag, wárt o nóshit o shomá gwashét: ‘Lápi o sharábié, máliátgir o gonahkáráni sangat ent.’ ");
INSERT INTO bccl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bale hekmat o zántá hamá záhera kanant ke áiay randgir o mannóger ant.” ");
INSERT INTO bccl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Cha Parisián yakkéá Issá wati lógá mehmán kort. Á shot o pa waragá parzónagay sará nesht. ");
INSERT INTO bccl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Á shahrá, yak badkárén janéné hastat. Wahdé sahig but ke Issá é Parisiay mehmán ent, sengmarmarén atrdánéay tahá, atri zort o hamódá shot. ");
INSERT INTO bccl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Issáay poshtá, áiay pádáni nazziká gréwán óshtát, gón wati arsán Issáay pádi tarr kort o gón wati mud o malgórán hoshk kortant o pádi chokket o atr per moshtant. ");
INSERT INTO bccl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wahdé á Parisiá ke Issá mehmán kortagat é dist, wati delá gwashti: “Agan é mard paygambaré butén, allamá zántagati é janén ke áiá dast per kanag o moshagá ent, kay ent o chónén gonahkáré.” ");
INSERT INTO bccl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Issáyá gwasht: “Oo Shamun! Maná gón taw yak habaré gwashagi ent.” Áiá gwasht: “Ji ostád, begwash!” ");
INSERT INTO bccl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Issáyá gwasht: “Mardéá do wámdár hastat, yakké panchsad dinár o domi panjáh dináray wámdár at, ");
INSERT INTO bccl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","bale á doénán pa wámáni dayagá hecch néstat, paméshká wám dayóká áyáni wám bakshetant. Nun cha á doénán kojámiá wám dayók géshter dósta bit?” ");
INSERT INTO bccl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Shamuná passaw dát o gwashti: “Mani hayálá, hamá ke áiay wám géshter atant.” Issáyá passaw dát: “Taw sharr gwasht.” ");
INSERT INTO bccl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Gorhá Issáyá janénay némagá chakk tarrént o gón Shamuná gwashti: “É janéná genday? Man tai lógá átkán, taw maná pádáni shódagá trampé áp nadát, bale é janéná mani pád gón wati arsán tarr kort o gón malgórán hoshk kortant. ");
INSERT INTO bccl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Taw maná nachokket, bale é janén cha mani rasagá tán é wahdi, yakpaymá mani pádán chokkagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Taw mani sará rógen per namosht, bale áiá mani pádáni sará atr per mosht. ");
INSERT INTO bccl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Paméshká tará gwashán: É janénay bázén dóstiay sawab esh ent, ke eshiay bázén gonáh bakshag butant, bale á ke áiay dósti kamter ent, hamá ent ke áiay bakshetagén gonáh kamter ant.” ");
INSERT INTO bccl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Gorhá démi gón á janéná tarrént o gwashti: “Tai gonáh bakshag butant.” ");
INSERT INTO bccl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Bale é dega mehmán gón yakdegará gwashagá laggetant: “É kay ent ke mardománi gonáhán ham pahella kant?” ");
INSERT INTO bccl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nun Issáyá gón á janéná gwasht: “Tai setk o báwará tará rakként, pa wasshi o salámati beraw.” ");
INSERT INTO bccl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Randá, Issá shahr pa shahr o métag pa métaga tarret o pa mardomán, Hodáay bádsháhiaymestágay jária jat. Áiay dwázdahén kásed hamráh atant. ");
INSERT INTO bccl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Lahtén janén ham ke Issáyá áyáni jenn kasshetagatant o cha nádráhián dráh o jórh kortagatant, gón áyán gón atant. Cha áyán yakké Maryam at, ke áiay pannám Majdaliah at o Issáyá cha áiá hapt jenn kasshetagat. ");
INSERT INTO bccl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Dega yakké Yuánná at ke áiay lógwájah, Huzá, Hirudis bádsháhay kalátay kelitdár at. Yakké Susan at o dega báz janén atant, ke cha wati zarr o málán, pa Issá o áiay moridán komak kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cha har shahr o har halk o hankéná mardom Issáay kerrá pédák atant. Wahdé bázén mardom átk o mocch but, Issáyá pa mesál o darwar gón áyán gwasht: ");
INSERT INTO bccl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Yak dehkáné pa tohmay chandhagá shot, tohmáni chandhagay wahdá kammoké tohm ráhay sará retk ke pálapásh butant o báli morgán chet o wártant. ");
INSERT INTO bccl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Kammoké dhal o dhókáni sará retk, á rostant bale zutt gimmort o hoshk butant, chiá ke zeminá namb néstat. ");
INSERT INTO bccl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Dega kammoké, shezz o cherekkáni nyámá retk, gón áyán hórigá rostant bale shezzán áyáni rost o rodóm dásht. ");
INSERT INTO bccl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Á dega tohm, sharrén zeminá retk o sharr rost o mazan but o sad sari hóshag o baresh kort.” É mesálay gwashagá rand, Issáyá pa borztawári gwasht: “Harkasá pa eshkonagá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Issáay moridán, cha áiá é mesálay máná jost kort. ");
INSERT INTO bccl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Áiá passaw dát: “Hodáyá shomay delay chamm pach kortagant, ke shomá áiay bádsháhiay rázán sarpad bebét, bale pa á dega mardomán, mesál o darwar ant o bass, tánke: ‘gón chammán bechárant, bale magendant gón góshán beshkonant, bale sarkech mawarant.’ ");
INSERT INTO bccl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“É mesálay máná esh ent: Tohm, Hodáay habar ant. ");
INSERT INTO bccl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ráhay sará retkagén tohmáni máná, hamá mardom ant ke Hodáay habarán gósha dárant, bale Shaytána kayt o cha áyáni delá, Hodáay habarán dara kant ke chosh mabit á báwar bekanant o berakkant. ");
INSERT INTO bccl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Dhal o dhókén zeminay retkagén tohmáni máná, hamá mardom ant ke Hodáay habarána eshkonant o pa gal o wasshia mannant, bale Hodáay habar, áyáni delá risshag o wandhála najanant, tán kammoké wahdá rand, áyáni báwar kamma bit o ázmáesh o chakkásay wahdá poshtá kenzant o cha ráhá thagalant. ");
INSERT INTO bccl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Shezz o dhangaráni tahá retkagén tohmáni máná, hamá mardom ant ke Hodáay habarán gósha dárant, bale donyái parésháni o mál o zarray hers o jópah o aysh o nóshán mána gisshant o hóshag o bara nayárant. ");
INSERT INTO bccl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Sharrén zeminá retkagén tohmáni máná, hamá mardom ant ke Hodáay habarán gósha dárant o pa setk o del o pákén niyaté áyána mannant. É chó hamá keshárá ant ke hóshag o bara kanant o páydára bant. ");
INSERT INTO bccl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kasé ke cherágá róka kant, tagáréay chérá chéria nadant, yá tahtay chérá éria nakant. Rókén cherágá, cherágdáná éra kanant, tán harkas ke lógá kayt rozhnáiá begendit. ");
INSERT INTO bccl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chiá ke hech choshén chérén chizzé nést ke záher o paddar mabit o hech choshén panáh o andémén habaré nést ke áshkár o démdará mabit. ");
INSERT INTO bccl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Shomá hozzhár bét o bezánét ke che paymá eshkonét. Kaséá ke chizzé hast, áiá géshter dayaga bit o kaséá ke nést, bale gomána kant ke hasti, cha áiá hamá ham pach geraga bit.” ");
INSERT INTO bccl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Hamé wahdá Issáay mát o brát áiay gendagá átkant, bale cha mardománi bázén mocchiá áiay nazziká átkesh nakort. ");
INSERT INTO bccl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Issáesh hál dát ke “tai mát o brát pa tai gendagá dhanná óshtátagant.” ");
INSERT INTO bccl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Issáyá darráént: “Mani mát o brát hamá ant ke Hodáay habarán gósha dárant o áyáni sará kára kanant.” ");
INSERT INTO bccl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yak róché, Issáyá gón moridán gwasht: “Byáét gwarmay domi némagá rawén.” Bójigá swár butant o ráh geptant. ");
INSERT INTO bccl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wahdé bójig rawagá at, Issá wáb kapt. Anágat syahgwátéá sar kort o tuppán but o bójig cha ápá porr bayagi at. Áyáni zend, hataray tahá at. ");
INSERT INTO bccl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Morid Issáay gwará shotant, cha wábá ágáhesh kort o gwashtesh: “Wájah, oo wájah! Má ér bokkagi o meragi én.” Á, cha wábá ágáh but o tuppán o mawj o chawli hakkal dátant, cha neherr o hakkalán gwát kapt o tuppán prosht o érmósh but. ");
INSERT INTO bccl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Áiá gón wati moridán gwasht: “Shomay setk o báwar kojá shot?!” Moridán cha é ajabén kárá torset o bah mantant o cha yakdomiá jostesh gept: “É chónén mardomé ke gwát o chawlán neherr o hokma dant o á ham, áiay hokmá mannant.” ");
INSERT INTO bccl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Gorhá, Gerásiáni sardhagárá rasetant ke Jalilay damagay dém pa démá, mazangwarmay domi pahnátá ent. ");
INSERT INTO bccl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wahdé Issá cha bójigá ér kapt o hoshkiá átk, cha shahray mardomán yakké, ke jenni ganóké at, gón áiá dochár kapt. Cha bázén wahdéá, áiá pocch gwará nakortagat o lógéá naneshtagat, shap o róch kabrestáná kaptagat. ");
INSERT INTO bccl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Wahdé áiá Issá dist, kukkáré korti, áiay pádán kapt o gón borztawári gwashti: “Issá, Oo mazanshánén Hodáay Chokk! Tará gón man che kár ent? Tará pa Hodá sawgend, maná azáb maday.” ");
INSERT INTO bccl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Áiá paméshká chosh gwasht ke Issáyá jenn hokm dátagat, é mardá yalah bedant. Jenná, é mard pésará ham báz randá geptagat, mardomán pa zamzil mohr bastagat o ger o dár kortagat, bale mardá zamzil próshtagatant o jenná, á kasshakán kortagat o gyábáná bortagat. ");
INSERT INTO bccl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Issáyá cha áiá jost kort: “Tai nám kay ent?” Áiá passaw dát: “Mani nám lashkar ent,” chiá ke bázén jenné áiay jesm o jáná potertagat. ");
INSERT INTO bccl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Jennán gón Issáyá dazbandi kort ke áyán, johlén tahtarunay chátá dawr dayagay hokmá madant. ");
INSERT INTO bccl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Hamódá, jompéay sará, hukkáni mazanén ramagé charagá at, jennán gón Issáyá dazbandi kort: “Márá bell ke é hukkáni jesmá poterén.” Issáyá ejázat dátant. ");
INSERT INTO bccl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Jennán á mard yalah dát o hukkáni jesmá potertant o anágat, hukkáni ramag cha jompá jahlagá ér kapáná gwarmá bokket. ");
INSERT INTO bccl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wahdé hukkáni shwánagán chosh dist, pa drekké métag o shahrá shotant o mardomesh hál dátant. ");
INSERT INTO bccl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mardom shotant tán gón wati chammán é sargwastá begendant. Issáay kerrá átkant o hamá mardesh dist ke jennán yalah kortagat, Issáay pádáni démá neshtag, pocch o pósháki gwará o pa hósh o sár ent. Nun torsesh delá nesht. ");
INSERT INTO bccl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Á ke wat chamdistén sháhed atant, á dega mardomesh hál dátant ke é jenni ganók chónaká dráh butag. ");
INSERT INTO bccl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Gerásináay sardhagáray mardomán, gón Issáyá dazbandi kort ke áyáni sardhagárá yalah bedant o berawt, chiá ke áyán báza torset. Paméshká Issá bójigá swár but o shot. ");
INSERT INTO bccl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Hamá mardá ke Issáyá áiay jenn dar kortagatant, gón Issáyá dazbandi kort ke áiá gón wat bebárt. Bale Issáyá á mard per tarrént o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Lógá beraw o wati mardomán hál beday ke Hodáyá gón taw chónén káré kortag.” Á mard shot o wati shahrá jári jat ke Issáyá gón áiá ché kortag. ");
INSERT INTO bccl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wahdé Issá per tarret, rombé mardomá wasshátk kort, chiá ke sajjahén áiay rahchár atant. ");
INSERT INTO bccl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Hamá wahdá, Yáyrus námén yak mardé ke kanisahay master at, Issáay kerrá átk. Áiay pádán kapt o dazbandi o mennati kort ke “mani lógá byá.” ");
INSERT INTO bccl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Chiá ke áiay yakkén jenek, ke omri dwázdah sálay kesásá at, markig at. Wahdé Issá áiay lógay némagá rawagá at, mardom chakká kapán o télánk dayán áiay gwará mocch butant. ");
INSERT INTO bccl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Hamódá yak janéné ham hastat ke dwázdah sál at áiay hón band nabutagat. Hechkasá ham á dráh kort nakortagat. ");
INSERT INTO bccl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Hamá janén, Issáay poshti némagá átk o áiay kabáhay lambi dast jat o hamá damáná hón band but. ");
INSERT INTO bccl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Gorhá Issáyá gwasht: “Kayá mani kabáh dast jat?” Wahdé hechkasá namannet, gorhá Petrosá gwasht: “Wájah! Wat gendagá ay ke mardomán tará chón angerr kortag o chakká kapán ant.” ");
INSERT INTO bccl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Bale Issáyá padá gwasht: “Allamá kaséá maná dast per kort, man máret ke wák o twáné cha man dar bayagá ent.” ");
INSERT INTO bccl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wahdé janéná zánt ke é habar chér dayaga nabit, gorhá larzáná átk o Issáay pádán kapt. Áiá sajjahénáni démá gwasht ke chiá Issáay kabáhi dast per kortag o che paymá, hamá damáná cha wati nádráhiá rakketag. ");
INSERT INTO bccl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Issáyá gwasht: “Oo mani jenek! Tai setk o báwará tará rakkéntag, pa wasshi o salámati beraw.” ");
INSERT INTO bccl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Issá angat habará at, ke cha kanisahay masteray lógá, mardomé átk o Yáyrusi hál dát ke “tai jenek mortag o nun ostádá géshter delsyáh makan.” ");
INSERT INTO bccl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Issáyá é habar eshkot o gón Yáyrusá gwashti: “Mators, báwar kan, tai jeneka rakkit.” ");
INSERT INTO bccl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wahdé Issá Yáyrusay lógá raset, áiá Petros, Yuhanná, Ákub o hamá jenekay pet o mátá abéd, dega hechkas hamráhiay ejázat nadát. ");
INSERT INTO bccl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Sajjahén mardom pa jenekay marká mótk o zári kanagá atant. Bale áiá gwasht: “Magréwét, á namortag, bass wáb ent.” ");
INSERT INTO bccl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Áyán Issáay sará kandet o kalág gept, chiá ke zántagatesh jenek mortag. ");
INSERT INTO bccl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Issáyá jenekay dast gept o gón borzén tawáré gwashti: “Oo mani chokk! Pád á.” ");
INSERT INTO bccl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jenekay sáh per tarret o hamá damáná pád átk. Issáyá gwasht: “Chokká warag bedayét.” ");
INSERT INTO bccl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Chokkay mát o pet hayrán o habakkah mantant, bale Issáyá kaddhan kortant ke é habará gón hechkasá magwashant. ");
INSERT INTO bccl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Issáyá wati dwázdahén kásed lóthetant, áyáná sajjahén jenn o palitén ruháni dar kanag o nájórhiáni dráh kanagay zór o ehtiári ham dát. ");
INSERT INTO bccl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Pa Hodáay bádsháhiay jár janag o nádráháni drahbakshiá ráhi dátant. ");
INSERT INTO bccl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Gwashti: “Ráhá, gón wat chizzé mabarét, na asá o dazlatthé, na lót o turagé, na nán o tóshag, na zarr o na géshén jámag. ");
INSERT INTO bccl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wahdé lógéá rawét, tán shahray yalah dayagá hamá lógá bemánét. ");
INSERT INTO bccl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Agan yak shahréay mardom shomárá wasshátka nakanant, gorhá dar áyagay wahdá, wati pádáni danzán hamódá bechandhét o betakénét tán áyáni helápá sháhedi bebit ke shomá Hodáay kolaw pa áyán raséntag.” ");
INSERT INTO bccl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Gorhá Issáay morid dar kapt o métag pa métag har jáh, wasshén mestágesh pa mardomána rasént o nádráhén mardomesh dráha kortant. ");
INSERT INTO bccl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wahdé Jalilay hákem Hirudis, cha é sajjahén habar o hálán sahig but, paréshán o takánsar but chiá ke lahtén mardom Issáay bárawá chosh gwashagá at: “Á, Yahyá ent ke padá cha mordagán zendag butag,” ");
INSERT INTO bccl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","dega lahtén gwashagá at ke “Elyás nabi záher butag,” o dega lahtén chosh ham gwashagá at ke “cha péshi zamánagay paygambarán yakké ke padá zendag butag.” ");
INSERT INTO bccl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Gorhá Hirudisá gwasht: “Yahyáay sar wa man borretag, nun é kay ent ke áiay bárawá man é dhawlén hál eshkonagá án?” Á pa Issáay gendagá hodónák at. ");
INSERT INTO bccl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wahdé Issáay kásed cha wati sapará per tarret o átkant, wati kortagén káráni hálesh Issáyá sar kort. Gorhá Issáyá á gón wat hamráh kortant o Bayt-Saydá námén shahréá shot tánke cha mardomán dur o gestá bebant. ");
INSERT INTO bccl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bale wahdé mardom sahig butant, áiay randá ráh geptant. Issáyá á wasshátk kortant, Hodáay bádsháhiay bárawá sar o sój dátant o nádráhén mardom ham wassh o dráh kortant. ");
INSERT INTO bccl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Rónenday wahdá, dwázdahén kásed átkant o gwashtesh: “Nun é mardomán ráh day ke é gwar o kerráni métag o bázárán berawant o pa wat warag o wábjáhé shóház bekanant, chiá ke edá barr o gyábánén jágahé.” ");
INSERT INTO bccl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Bale Issáyá gwasht: “Shomá wat eshán warák bedayét.” Áyán passaw dát: “May kerrá panch nagan o do máhigá géshter chizzé nést, bale haw, agan berawén pa é sajjahén mardomán warák pa bahá begerén.” ");
INSERT INTO bccl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Cha á mardomán, kesás panch hazár mardén atant. Issáyá gón moridán gwasht: “Mardomán panjáh panjáhay thóliá benendárénét.” ");
INSERT INTO bccl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Moridán anchosh kort o mardom nendáréntant. ");
INSERT INTO bccl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Issáyá panchén nán o doén máhig zortant o ásmánay némagá cháret, Hodáay shogri gept o padá nán o máhigi chondh chondh kort o moridáni dastá dátanti tánke mardománi sará bahr bekanant. ");
INSERT INTO bccl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Sajjahén mardomán lápsérá warag wárt o angat cha sar átkagén chondhán, dwázdah sapt porr but. ");
INSERT INTO bccl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yak róché, Issá éwaká dwá kanagá at o morid gón áiá gón atant. Cha moridán josti kort: “Mardom mani bárawá ché gwashant, man kay án?” ");
INSERT INTO bccl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Áyán passaw dát: “Lahténa gwashit taw pákshódókén Yahyá ay o lahténa gwashit taw Elyás nabi ay. Dega lahtén chosh ham gwashit, taw cha pésarigén zamánagay á dega nabián yakké ay ke padá zendag butagay.” ");
INSERT INTO bccl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Áiá jost kort: “Shomá wat mani bárawá ché gwashét, man kay án?” Petrosá passaw dát: “Taw Hodáay ráh dátagén hamá Masih ay.” ");
INSERT INTO bccl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Bale Issáyá á hokm kortant ke “é habará gón hechkasá magwashét.” ");
INSERT INTO bccl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Gwashti: “Ensánay Chokk báyad ent bázén sakki o sóri besaggit. Kawmay kamásh, mazanén dini péshwá o Sharyatay zánóger allamá áiá mamannant o bekóshárénant o saymi róchá padá zendag bebit.” ");
INSERT INTO bccl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Issáyá sajjahén mardom gwashtant: “Agan kasé lóthit mani randgiriá bekant, wati delay wáhag o lóthán yalah bedant o har róch wati jenday salibá baddhá bekant o mani ráhá gám bejant. ");
INSERT INTO bccl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Harkas ke wati sáhay rakkénagay johdá bebit, áiá báhénit. Bale á ke pa manigi wati sáhá báhénit, áiá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Agan yakkéá sajjahén donyá berasit bale wati sáhá bebáhénit, chónén sóbé bárt o ché kattheta kant? ");
INSERT INTO bccl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Agan kasé cha man o mani habarán lajj bekant, gorhá Ensánay Chokk ham, á wahdi ke gón watig o ásmáni Petayg o pákén préshtagáni shán o shawkatá é jaháná padá kayt, cha áiá lajja kant. ");
INSERT INTO bccl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Bale man shomárá rásténa gwashán, edá lahtén mardom óshtátag ke tán áyáni démá Hodáay bádsháhi paddar mabit, markay támá nachashant.” ");
INSERT INTO bccl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Cha é habarán, kesás hasht róchá rand, Issáyá Petros, Yuhanná o Ákub hamráh kortant o pa dwáyá yak kóhéay sará shot. ");
INSERT INTO bccl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wahdé Issá dwá kanagá at, áiay démay rang badal but o gwaray god sakk espét but o drapshagá laggetant. ");
INSERT INTO bccl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Yak anágat do mardom paddar but o gón Issáyá habar kanagá atant, yakké Mussá o á dega Elyás at. ");
INSERT INTO bccl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Á doén gón mazanén shán o shawkatéá záher butant o Issáay markay bárawá habar kanagá atant ke allamá Urshalimá bayagi at. ");
INSERT INTO bccl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Petros o áiay hamráh Ákub o Yuhanná sakk wábénag atant, bale wahdé sharr ágáh butant, gorhá distesh ke Issá pa shán o shawkaté gón Mussá o Elyásá yakjáh óshtátag. ");
INSERT INTO bccl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wahdé á doén Issáyá roksat kanag o rawagi atant, Petrosá gwasht: “Wájah! May edá bayag sakk sharr ent, bell ke má say sáheg o kápára bandén, yakké pa taw, yakké pa Mussá o degaré pa Elyásá.” Bale Petrosá wat nazánt ché gwashagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Angat Petros habará at ke jambaréá áyáni sará sáheg kort. Wahdé jambar áyáni sará sáhél but moridán torset. ");
INSERT INTO bccl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Cha jambará tawáré rost: “É mani gechéni Bacch ent. Shomá eshiay habarán gósh bedárét.” ");
INSERT INTO bccl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tawáray eshkonagá rand, moridán Issá éwaká dist. Áyán é sargwast wati delá dásht o á wahdá wati distagénesh gón hechkasá nagwasht. ");
INSERT INTO bccl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Domi róchá wahdé Issá o sayén morid cha kóhá ér átkant, mardománi mazanén mocchié átk o gón Issáyá dochár kapt. ");
INSERT INTO bccl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Cha mardománi nyámá yak mardoméá kukkár kanáná gwasht: “Oo ostád! Gón taw dazbandia kanán ke tará mani bachakay sará bazzag bebit, á mani yakkén chokk ent. ");
INSERT INTO bccl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Jenné anágah mani chokká gipt o zhámbalénit o hamá damáná chokk ják o kukkára kant, kap o gajja bit. Áiá báz kamm yalaha dant o lóthit áiá bekoshit. ");
INSERT INTO bccl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Man gón tai moridán dazbandi kort ke é jenná bekasshant, bale áyán kasshet nakort.” ");
INSERT INTO bccl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Issáyá gwasht: “Oo bébáwar o gomráhén nasl o padréch! Man tán kadéná gón shomá bemánán o besaggán? Chokká edá byár.” ");
INSERT INTO bccl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wahdé chokk pédák at, jenná zhámbalént o dhagárá jat. Issáyá jenn gón neherr o hakkalán mán bast, chokk dráh kort o petay dastá dát. ");
INSERT INTO bccl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Sajjahén mardom cha Hodáay mazaniá hayrán but o bah mantant. Wahdé sajjahén mardom cha Issáay mójezah o ajabén kárán hayrán atant, gón wati moridán gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mani é habarán pa sharri delgósh kanét, Ensánay Chokk gón dagá o dróhag mardománi dastá dayaga bit.” ");
INSERT INTO bccl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Bale morid áiay é habará sarpad nabutant, chiá ke pa áyán ramz o rázé at. Cha Issáyá jost kanagesh ham torset. ");
INSERT INTO bccl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Issáay morid watmánwatá é gappay sará dapják kanagá atant: “Bárén, may nyámá sajjahénáni master o kamásh kay ent?” ");
INSERT INTO bccl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Issáyá áyáni delay habar zánt o yak kasánén chokké wati kashá óshtárént o ");
INSERT INTO bccl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","gón moridán gwashti: “Harkas ke pa mani námaygi é kasánén chokká gón washwáhagi bezurit o wati gwará bedárit, bezán áiá maná zortag o mannetag. Harkas ke maná bemannit hamá Hodáyá mannit ke maná ráhi dátag, chiá ke cha shomá, hamá master ent ke watá cha sajjahénán kastera zánt.” ");
INSERT INTO bccl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yuhannáyá gón Issáyá gwasht: “Wájah! Má yak mardé dist ke gón tai námay geragá cha mardomán palitén ruhán dara kant, bale má á makan o manah kort, chiá ke á mard cha má naat.” ");
INSERT INTO bccl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Issáyá gwasht: “Na, é kárá makanét, chiá ke agan kasé shomay badwáh mabit, gón shomá ent.” ");
INSERT INTO bccl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wahdé Issáay chest bayag o ásmáná rawagay wahd nazzik but, gorhá gón deljamén shawré dém pa Urshalimá sar gept. ");
INSERT INTO bccl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Bale cha watá pésar, lahtén kásedi ráh dát. Á shotant o Sámeriáni yak métagéá rasetant tánke cha áiay áyagá pésar, pa áiá tayári bekanant. ");
INSERT INTO bccl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Bale óday mardomán Issá wasshátk nakort chiá ke á Urshalimá rawagá at. ");
INSERT INTO bccl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wahdé Issáay morid, Ákub o Yuhanná cha é hálá sahig butant, gwashtesh: “Oo Hodáwand! Taw razá dayay má cha Hodáyá belóthén ke cha ásmáná ásé ráh bedant o eshán besóchit o hák o por bekant?” ");
INSERT INTO bccl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Bale Issáyá chakk tarrént, á neherr o hakkal dátant. ");
INSERT INTO bccl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Randá gón wati moridán, dega métagéá shot. ");
INSERT INTO bccl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Issá o áiay morid, ráhá rawagá atant. Yak mardéá gwasht: “Har jáh ke taw raway man tai hamráha bán.” ");
INSERT INTO bccl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Issáyá gwasht: “Róbáhán hóndh o jágah hast o báli morgán kodóh o kodám, bale man ke Ensánay Chokk án, maná pa saray ér kanagá hech jágah nést.” ");
INSERT INTO bccl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Issáyá gón dega mardéá gwasht: “Byá, mani randgiriá bekan.” Bale áiá passaw dát: “Oo wájah! Maná mókal beday pésará rawán wati petá kabra kanán.” ");
INSERT INTO bccl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Issáyá gwasht: “Bell ke mordag wati mordagán wat kabr o kapona kanant, taw beraw o Hodáay bádsháhiay wasshén mestágá pa mardomán sar kan.” ");
INSERT INTO bccl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Degaréá gwasht: “Oo wájah! Man tai randgiriá kanán, bale maná bell tán pésará wati lógay mardomán roksat bekanán.” ");
INSERT INTO bccl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Issáyá áiay passawá gwasht: “Á kas ke nangár kanagay wahdá poshtá chárit, Hodáay bádsháhiay hezmatkáriay láhek naent.” ");
INSERT INTO bccl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Cha eshiá rand, Hodáwandén Issáyá dega haptád morid gechén kort o hamá shahr o métagán ke rawagi at, cha watá pésar, do doá ráhi dátant o ");
INSERT INTO bccl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","gón áyán gwashti: “Keshár báz ent, bale ronók kamm. Paméshká gón kesháray wáhondá dazbandi bekanét o belóthét ke pa wati keshárán ronók dém bedant. ");
INSERT INTO bccl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Berawét, ke man shomárá gwaragáni dhawlá, gorkáni nyámá rawána kanán. ");
INSERT INTO bccl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wati sát o sapará gón wat, na zarturag o lót o pélek bezurét o na chawath o swás. Ráhá, gón kaséá géshén tayárjórhi makanét. ");
INSERT INTO bccl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Har lógéá ke rawét awalá begwashét: ‘É lógay mardom dráh o émen bátant’. ");
INSERT INTO bccl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Cha á lógay mardomán, agan kasé sohl o émeniay lóthók ent, shomay é émeniay wáhag pa áiá rasit o agan á nakarzit, shomay é wáhag padá pa shomá pera tarrit. ");
INSERT INTO bccl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Hamá yakkén lógá bedárét o lóg pa lóg marawét. Harché ke shomárá pa waragá dátesh, bwarét o benóshét, chiá ke kár kanók wati rózigay hakdár ent. ");
INSERT INTO bccl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Har shahréá ke rawét o á shahray mardom shomárá wasshátka kanant, gorhá harché ke pa waragá kárant, bwarét. ");
INSERT INTO bccl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Hamá shahray nádráhán dráh kanét o mardomán begwashét ke Hodáay bádsháhi nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bale agan shahréá shotét ke á shahray mardomán shomárá wasshátk nakort, gorhá cha ódá dar byáét o hamá shahray rahsarán harkasá ke gendét, áyán begwashét: ");
INSERT INTO bccl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Shomay shahray hamá danz ke may pádán laggetag, má á danzán hamedá chandhén o takénén, tánke é danz sháhedi bedayant ke má Hodáay wasshén kolaw pa shomá áwort. Bale bezánét ke Hodáay bádsháhi nazzik ent.’ ");
INSERT INTO bccl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Báwar kanét, jost o porsay róchá Sodumay mardománi sezá cha á shahray mardománi sezá o azábá ásánter o kamtera bit. ");
INSERT INTO bccl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Bazhn o apsóz pa shomá, oo Korázinay mardomán! Bazhn o apsóz pa shomá, oo Bayt-Saydáay mardomán! Hamá mójezah o ajekkái ke man shomay nyámá pésh dáshtagant, agan Sur o Saydunay shahrán pésh bedáshténant, gorhá óday mardomán hamá wahdá wati gonáháni pashómániay póshák gwará kortagat o poráni sará neshtagatant. ");
INSERT INTO bccl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Jost o porsay róchá, Sur o Saydunay mardománi sezá cha shomay sezá o azábá ásánter o kamtera bit. ");
INSERT INTO bccl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Oo Kaparnáhumay mardomán! Shomá chest kanag o ásmáná baraga bét? Hechbar! Tahtarunay johlánkián sarshakuna bét. ");
INSERT INTO bccl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Agan kasé shomay habarán gósh bedárit, á mani habarán ham gósha dárit. Harkas shomárá mamannit, á maná ham namannit o mani namannók áiá ham namannit ke maná ráhi dátag.” ");
INSERT INTO bccl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Issáay haptádén morid gón shádehi per tarretant o gwashtesh: “Oo Hodáwand! Cha tai námay zórákiá, jenn ham may hokmá mannant.” ");
INSERT INTO bccl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Issáyá darráént: “Man Shaytán dist ke grókéay dhawlá cha ásmáná kapt. ");
INSERT INTO bccl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Man shomárá hamá wák o ehtiár dátag ke már o zumm o dozhmenay sajjahén wák o kodratá lagatmál bekanét. Hech chizz shomárá táwán dáta nakant o noksána narasénit. ");
INSERT INTO bccl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Bale pa eshiá delwassh mabét ke jenn shomay hokmá mannant, shomay delwasshi é bebit ke námó ásmáná nebisag butag.” ");
INSERT INTO bccl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Hamá damáná, gón Pákén Ruhá gal o shádán, Issáyá gwasht: “Oo Pet, zemin o ásmánay Hodábond! Tará satá kanán o sárháyán ke taw é ráz o habar cha zántkár o hóshmandán chér dátant o kódakáni sará paddar kortant. Oo Pet! Taw cha wati razá o wáhagá é dhawlá kort. ");
INSERT INTO bccl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sajjahén chizz, Petá mani dastá dátagant. Abéd cha Petá, hechkas Chokká nazánt, hamé dhawlá, abéd cha Chokká o hamá mardomán ke Chokk belóthit Petá pa áyán paddar bekant, dega hechkas Petá nazánt.” ");
INSERT INTO bccl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Padá Issáyá pa ehwat o halwatá dém gón moridán kort o gwashti: “Bahtáwar ant hamá chamm ke harché shomá distag á ham begendant. ");
INSERT INTO bccl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Man shomárá gwashán, bázén paygambar o bádsháháni wáhag o morád hamé butag ke harché shomá gendagá ét áyán ham bedistén, bale nadistesh o harché shomá eshkonagá ét áyán ham beshkotén bale naeshkotesh.” ");
INSERT INTO bccl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cha Sharyatay kázián yakké, Issáay kerrá átk o pa áiay chakkásá josti kort: “Oo ostád! Man chón bekanán ke namiránén zenday wáhond bebán?” ");
INSERT INTO bccl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Issáyá passaw dát: “Sharyatá ché nebeshtah ent, cha áiay wánagá taw ché sarpada bay?” ");
INSERT INTO bccl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Áiá passaw dát: “Wati Hodáwandén Hodáyá, pa del, gón sajjahén ján o sáh, gón sajjahén was o wák o gón sajjahén pahm o pegrá dóst bedáro hamsáhegá ham wati jenday paymá mehr bekan.” ");
INSERT INTO bccl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Issáyá gwasht: “Taw sharr gwashtag, hamé dhawlá bekan, tará abadmánén zenda rasit.” ");
INSERT INTO bccl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nun Sharyatay zánógerá pa é sawabá ke pésh bedárit áiá sharrén josté kortag, cha Issáyá padá jost kort: “Gorhá, mani hamsáheg kay ent?” ");
INSERT INTO bccl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Áiay passawá, Issáyá chosh gwasht: “Yahudi mardé cha Urshalimá dém pa Ariháay shahrá rawagá at. Ráhá, dozzán gept o áiay mál o maddhi polet o áiay pocch o póshák pach geptant, jat, latth o kotth o némzadag kort o ráhay sará dawr dát o shotant. ");
INSERT INTO bccl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Bé gat o gománá, cha hamé ráhá yak dini péshwáé gwazagá at, wahdé é mardi dist, wati ráhi táb dát o gwast. ");
INSERT INTO bccl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Hamé dhawlá, mazanén parasteshgáhay hezmatkáré ham cha hamé ráhá gwazagá at, wahdé á mardi dist gwast o shot. ");
INSERT INTO bccl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Bale randterá, Sámeri kawmay yak mardé cha ódá gwazán, hamé jágahá raset. Wahdé á mardi dist, áiay sará bazzagi but, ");
INSERT INTO bccl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","áiay kerrá átk o thappi gón sharáb o thél darmán kort o bastant, wati óláká swár kort, yak kárwánsaráéá áwort o áiay hayáldárii kort. ");
INSERT INTO bccl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Domi róchá, kárwánsaráay hodábondi do dinár dát o gwashti: ‘É marday hayáldáriá bekan, agan cha é zarrán géshter pakár but per tarragay wahdá tará dayán.’” ");
INSERT INTO bccl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Gorhá Issáyá cha hamá Sharyatay zánógerá jost kort: “Taw ché gwashay, cha á sayénán kojámiá gón é zadag o thappigén mardá wati hamsáhegi zemmahwári sarjam kort?” ");
INSERT INTO bccl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Áiá passaw dát: “Hamá ke áiay sará bazzagi but.” Issáyá gwasht: “Beraw taw ham anchosh bekan.” ");
INSERT INTO bccl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Issá o áiay morid, gwazán o pand janán, átk o métagéá rasetant. Ódá, Martá námén janénéá Issá wati lógá mehmán kort. ");
INSERT INTO bccl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martáyá Maryam námén goháré hastat ke pa Hodáwandén Issáay habaráni gósh dáragá áiay pádáni démá nesht. ");
INSERT INTO bccl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Bale Martá ke mehmániay káráni chen o lánchá dazgatth at, Issáay kerrá átk o gwashti: “Oo Hodáwand! Tará é habaray parwáh nést ke mani gohárá maná kár kanagá tahná yalah dátag? Begwashi maná komak bekant.” ");
INSERT INTO bccl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Bale Hodáwandén Issáyá passaw dát: “Martá, oo Martá! Taw bázén kár o báráni sará watá negrán o deltaparkaha kanay, ");
INSERT INTO bccl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","bale tahná yak chizz zalurat ent. Maryamá hamá gehterén pa wat gechén kortag ke cha áiá pach geraga nabit.” ");
INSERT INTO bccl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yak baré Issá jágahé dwá kanagá at, wahdé dwái hallént, cha áiay moridán yakkéá gwasht: “Oo Hodáwand! Anchosh ke Yahyáyá wati morid dwá kanag sój dátagant hamé paymá taw ham márá dwá kanag sój beday.” ");
INSERT INTO bccl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Issáyá gwasht: “Harwahd dwá kanét, é dhawlá begwashét: ‘Oo Pet! Tai nám sharapdár bát. Tai bádsháhi byáyát. ");
INSERT INTO bccl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","May har róchigén rezk o rózigá har róch márá beday. ");
INSERT INTO bccl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","May gonáh o radián bebaksh, anchosh ke má wati sajjahén daynkárána bakshén. Márá ázmáesh o chakkásá dawr maday.’” ");
INSERT INTO bccl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Gorhá Issáyá gwasht: “Cha shomá yakké, agan shapnémá wati sangatay lógá berawt o begwashit: ‘Oo brát! Maná say nán pa badal beday, ");
INSERT INTO bccl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ke dósté cha sapará átkag o mani lógá pa waragá hecch nést,’ ");
INSERT INTO bccl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","buta kant á cha wati lógá jwáb bedant o begwashit: ‘Oo dóst! Maná delsyáh makan, lógay dap band ent o man gón chokkán waptagán. Annun pád átka nakanán tará chizzé bedayán.’ ");
INSERT INTO bccl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Shomárá gwashán, é mard agan pa dóstiá pád mayayt o áiá chizzé madant, bale cha áiay bázén lézgi o lés o pellésá páda kayt o harché á lóthit danti. ");
INSERT INTO bccl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Nun shomárá gwashán: Belóthét, shomárá dayaga bit. Shóház bekanét, dara géjét. Darwázagá bethokkét, pacha bit. ");
INSERT INTO bccl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Chiá ke harkas belóthit, áiá rasit. Harkas shóház bekant, dara géjit. Harkas darwázagá bethokkit, pa áiá pacha bit. ");
INSERT INTO bccl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Shomay nyámá choshén peté hast ke agan áiay chokk máhig belóthit máré bedanti? ");
INSERT INTO bccl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Yá agan hayké belóthit, zummé bedanti? ");
INSERT INTO bccl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Nun agan shomá ke radkár ét, angat ham wati chokkán sharrén chizzáni dayagá zánét, gorhá may ásmáni Pet chenkadar shartera zánt ke wati lóthókén chokkán Pákén Ruhá bedant.” ");
INSERT INTO bccl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Yak baré, Issá cha yakkéá jenné dar kanagá at ke áiá é mard gong kortagat. Wahdé jenn dar átk, gongén mard habar kanagá lagget o sajjahén mardom hayrán butant. ");
INSERT INTO bccl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Bale lahténá gwasht: “Issá cha jennáni sardár Belzabulay sarókiá, jennána kasshit.” ");
INSERT INTO bccl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Dega lahténá pa Issáay chakkásagá cha áiá ásmáni neshánié lóthet. ");
INSERT INTO bccl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Bale Issáyá áyáni delay hál o habar zántant o gwashti: “Agan yak molkéá nátepáki bekapit, á molk gár o zawála bit, agan yak lógéay mardom gón wat jang o jérhah bekanant, á lóg haráb o barbáda bit. ");
INSERT INTO bccl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Agan Shaytán gón wat jang bekant, gorhá áiay bádsháhi chón barjáha mánit? Shomá gwashét ke man cha jennáni sardár, Belzabulay komaká jennán dara kanán. ");
INSERT INTO bccl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nun agan man gón Belzabulay sarókiá jennán dara kanán, gorhá shomay jenday chokk o morid gón kai zór o wáká jennán dara kanant? É paymá, shomay morid wat shomárá mayáriga kanant. ");
INSERT INTO bccl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Bale agan man gón Hodáay zór o wáká jennán dara kanán, bezánét ke Hodáay bádsháhi shomay nyámá rasetag. ");
INSERT INTO bccl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Agan yak zóráwarén mardomé seláhband bebit o wati lógay negahpániá bekant, gorhá áiay mál o melkat barjáha mánant. ");
INSERT INTO bccl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Bale agan zórmandterén mardomé áiay lógay sará hamlah o orosh bebárt o cha áiá sardast bebit, hamá seláhán ke á mard cha áyán deljam at, cha áiá pacha gipt o áiay mál o melkatá bahr o bánga kant. ");
INSERT INTO bccl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kasé ke mani hamráh o dózwáh naent á mani badwáh ent, kasé ke mocch o yakjáh kanagá gón man hór naent, á tak o park o sheng o shánga kant. ");
INSERT INTO bccl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wahdé jenné cha kaséá dara kayt, gorhá gyábánána rawt tán pa wati árámi o ásudagiá jáhé shóház bekant, bale choshén jágahé narasiti. Gorhá gwashit: ‘Cha ódá ke dar átkagán, padá hamódá rawán.’ ");
INSERT INTO bccl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wahdé pera tarrit o gendit ke á jágah roptag o sáp o sallah ent, ");
INSERT INTO bccl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","gorhá rawt o cha watá dega hapt selterén jenna kárit. Á sajjahén, hórigá ódá rawant o ord o bonaga kanant. É dhawlá, á mardomay ásar o ákebat cha pésarigéná angat badtera bit.” ");
INSERT INTO bccl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Hamé wahdá ke Issá é habarán kanagá at cha mardománi nyámá yak janénéá gwánk jat: “Bahtáwar hamá mát ent ke cha áiay lápá taw pédá butagay o tará shiri méchéntag.” ");
INSERT INTO bccl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Issáyá áiay passawá darráént: “Bahtáwar hamá ant ke Hodáay habarán gósha dárant o áyáni sará kára kanant.” ");
INSERT INTO bccl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wahdé mardománi mocchi géshter bayán at, Issáyá gwasht: “É zamánagay mardom sherr o zenahkárén mardom ant. Ajabbatén neshánia lóthant, bale áyán Yunes nabiay neshániá abéd, dega hech neshánié dayaga nabit. ");
INSERT INTO bccl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Anchosh ke pa Naynawáay mardomán Yunes yak neshánié at, hamé paymá Ensánay Chokk ham wat pa é zamánagay mardomán yak neshánié bit. ");
INSERT INTO bccl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jost o porsay róchá, Sabáay malakah gón é zamánagay mardomán hórigá páda kayt o áyán mayáriga kant, chiá ke Sabáay malakah cha donyáay á dastá átk tán Solaymánay hekmatá beshkont. Bale nun cha Solaymáná masteréné edá ent. ");
INSERT INTO bccl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jost o porsay róchá, Naynawáay mardom gón é zamánagay mardomán hórigá páda káyant o áyán mayáriga kanant, chiá ke á, Yunesay dháh o hozzhárbáshay sará cha wati gonáhán pashómán butant. Bale nun cha Yunesá masteréné edá ent. ");
INSERT INTO bccl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Hechkas cherágá pa chér dayagá róka nakant o na áiá tagáray chérá éra kant. Áiá cherágdánay sará éra kant, tán harkas ke lógá kayt áiay rozhnáiá begendit. ");
INSERT INTO bccl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Tai chamm, jesm o jánay cherág ent. Wahdé tai chamm wassh o dráh ent, tai sajjahén jesm o ján rozhnága bit, bale agan tai chamm nádráh bebit, gorhá tai jesm o ján ham tahára bit. ");
INSERT INTO bccl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Hozzhár bay, é nur o rozhn ke tará hastent, tahár mabit. ");
INSERT INTO bccl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Agan tai sajjahén jesm o ján rozhnág bebit o áiay hech bahré tahár mabit, gorhá sarjamiá drapshnáka bit, anchosh ke cherágay shahm tará rozhnága kant.” ");
INSERT INTO bccl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wahdé Issáyá habar halás kort, yak Parisiéá á wati lógá mehmán kort, Issá áiay lógá shot o pa warákay waragá parzónagay sará nesht. ");
INSERT INTO bccl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Bale wahdé Parisiá dist ke Issáyá cha waragá pésar dast nashoshtant hayrán mant. ");
INSERT INTO bccl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gorhá Hodáwandén Issáyá dém gón áiá kort o gwashti: “Shomá Parisi, pyálah o darpáni dhanni némagá sáp o sallaha kanét, bale shomay darun cha lálech o tamah o radén kárán porr ent. ");
INSERT INTO bccl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Oo násarpadán! Áiá ke shomay dhanni némag, bezán jesm o ján addh kortag, shomay del o darun ham hamáiá najórhéntag? ");
INSERT INTO bccl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gorhá cha darunay chizzán hayrát bedayét tán sajjahén chizz pa shomá pák o sallah bebant. ");
INSERT INTO bccl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Oo Parisián! Bazhn o apsóz pa shomá ke purchénk o sadáp o é dega káhokáni sará dahyakka dayét bale cha dádrasi o ensáp o Hodáay mehrá béhayál o bétránag ét. Drégatá, shomá é kár bekorténant o á ham yalah madáténant. ");
INSERT INTO bccl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Oo Parisián! Bazhn o apsóz pa shomá ke kanisaháni awali red o srapay nendag o bázárán mardománi wasshátk o drahbátán dósta dárét. ");
INSERT INTO bccl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Bazhn ent, shomá hamá kabráni paymá ét ke áyáni sará seng o shakk nést o gendaga nabant o mardom pa názánti áyána lapáshant o gwazant.” ");
INSERT INTO bccl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","É habaráni sará Sharyatay káziéá gwasht: “Oo ostád! Taw gón wati é habarán, márá ham béezzat kanagá ay.” ");
INSERT INTO bccl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Issáyá gwasht: “Oo Sharyatay kázián! Pa shomá ham bazhn o apsóz ent. Shomá mardománi chakká gránén bára laddhét ke cha áyáni zórá gésh ent, bale wat pa komak kanagá, lankok o mórdánagé ham nasorénét. ");
INSERT INTO bccl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Bazhn o apsóz pa shomá! Hamá nabiáni kabráni sará gombod o addiraha bandét ke shomay pet o pirokán koshtagant. ");
INSERT INTO bccl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","É paymá, shomá wat áyáni é káray sháhed o mannóger ét. Shomay pet o pirokán paygambar koshtagant o shomá áyáni kabráni sará addiraha bandét. ");
INSERT INTO bccl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Paméshká, Hodáyá cha wati hekmatá gwashtag: Man paygambar o kásed pa áyán ráha dayán, bale á lahténá koshant o lahténá ázára dayant. ");
INSERT INTO bccl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Paméshká cha donyáay bongéjá hamá sajjahén paygambar ke mardomán koshtagant, áyáni hón é zamánagay mardománi gardená ent, ");
INSERT INTO bccl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","bezán Hábilay hóná beger tán Zakaryáay hóná, ke korbánjáh o mazanén parasteshgáhay nyámá réchag but. Haw! Shomárá gwashán ke é zamánagay mardom, á sajjahén hónáni daynkár ant. ");
INSERT INTO bccl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Oo Sharyatay kázián! Bazhn ent ke shomá zántkáriay hazánagay kelit zort o bort, na wat tahá átkagét o na á ke ráhá ant, tahá rawagá eshtagant.” ");
INSERT INTO bccl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Wahdé Issá cha ódá dar átk, Parisi o Sharyatay zánóger gón zahrnáki áiay démá óshtátant o bázén jost kanagá laggetant, tán Issáyá cha áiay jenday habarán mán begisshénant o dámá dawr bedayant. ");
INSERT INTO bccl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Hamá wahdá, hazárán mardom mocch but o yakdomiá gwarmósh dayán o lapáshán at. Issáyá pésará dém gón moridán tarrént, wati gapp o tráni bongéj kort o gwashti: “Cha Parisiáni homirá ke ryákári o dotal o dopóstiay homir ent, watá dur bedárét, ");
INSERT INTO bccl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","chiá ke hech chérén káré nést ke záher o paddar mabit o choshén andém o panáhén chizzé nést ke áshkár o démdará mabit. ");
INSERT INTO bccl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Paméshká, har habaré ke shomá shapay taháriá kortag, róchay rozhnáiá eshkonaga bit o har habaré ke shomá dapbandén lógáni tahá pa halwat kortag, cha lóg o bánáni sará jár janaga bit. ");
INSERT INTO bccl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Oo mani dóstán! Shomárá gwashán ke cha mardomán matorsét. Á shomay jesm o jáná koshta kanant, bale cha eshiá géshter hecch korta nakanant. ");
INSERT INTO bccl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Man shomárá kaddhana kanán o gwashán ke cha kayá betorsét. Cha hamáiá betorsét ke koshta kant o koshagá rand tahtaruná dawr dayagay wáki ham hast. Haw! Man shomárá gwashán ke cha hamáiá betorsét. ");
INSERT INTO bccl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Panch jenjeshk pa do paysahá bahá nabit? Bale Hodá cha áyán yakkéá ham béhayála nabit. ");
INSERT INTO bccl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Hodáyá shomay saray mudáni hesáb ham gón ent, gorhá matorsét chiá ke shomay kadr o arzesh cha sajjahén jenjeshkán géshter ent. ");
INSERT INTO bccl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Man shomárá gwashán ke harkas mardománi démá maná bemannit, Ensánay Chokk Hodáay préshtagáni démá áiá mannit. ");
INSERT INTO bccl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bale harkas mardománi démá maná mamannit, man ham Hodáay préshtagáni démá áiá namannán. ");
INSERT INTO bccl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Hamé dhawlá, agan kasé Ensánay Chokkay helápá habar bekant pahell kanaga bit, bale harkas Hodáay Pákén Ruhay sará kopr bekant, á bakshaga nabit. ");
INSERT INTO bccl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mardom shomárá gerant o kanisahána barant o hákem o hokumatáni démá pésha kanant. Á wahdá, pa wati démpániá paréshán mabét ke ché begwashét, ");
INSERT INTO bccl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","chiá ke Pákén Ruh shomárá hamá wahdá wat sója dant ke ché begwashét.” ");
INSERT INTO bccl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Cha mardománi mocchiá, yakkéá gón áiá gwasht: “Oo ostád! Mani brátá begwash ke cha petay mirásá mani bahrá begisshénit o bedant.” ");
INSERT INTO bccl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Issáyá passaw dát: “Oo mard! Kaséá maná shomay mirásay bahr kanók nakortag.” ");
INSERT INTO bccl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Gorhá gón mardomán gwashti: “Hozzhár bét! Watá cha har dhawlén tamah o lálechá dur bedárét, chiá ke mál o dawlatay zyádahi ensánay zenday maksad o morád naent.” ");
INSERT INTO bccl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Áiá yak mesálé dát o gwashti: “Yak hastómandén zemindáré hastat ke áiá cha wati dhagár o keshárán bázén dahl o rasadé raset. ");
INSERT INTO bccl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nun wati delá pegri kort ke ‘ché bekanán? Maná pa esháni ambár kanagá jágah nést.’ ");
INSERT INTO bccl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Gorhá gón wat gwashti: ‘Nun zánton ché bekanán. Wati ambárána karóján o harába kanán o esháni jágahá masterén ambára bandán o sajjahén dán o málán hamódá ambára kanán. ");
INSERT INTO bccl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Padá gón wata gwashán: “Taw pa bázén sálán mazanén málé mocch kortag. Nun ásudag bebay, wassh bwar o benósh o shádehi kan!”’ ");
INSERT INTO bccl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Bale Hodáyá gwasht: ‘Oo nádán! Enshapi tai sáh cha taw geraga bit, gorhá tai é mocch kortagén mál o melkat kaiga bant?’ ");
INSERT INTO bccl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","“Esh ent á mardomay ásar o ákebat ke pa wat mál ambára kant bale Hodáay gwará hastómand naent.” ");
INSERT INTO bccl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Issáyá gón wati moridán gwasht: “Paméshká shomárá gwashán ke pa wati zendá paréshán o deltaparkah mabét ke ‘Ché bwarén?’ na pa wati jesm o jáná ke ‘Ché bepóshén?’ ");
INSERT INTO bccl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","chiá ke zend, cha waráká o jesm o ján, cha pósháká géshtera karzit. ");
INSERT INTO bccl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gwarágán bechárét, na keshant o na ronant o na kahdán o ambáresh hast. Bale angat Hodá áyán róziga dant. Shomay arzesh o kimmat cha morgán báz géshter ent. ");
INSERT INTO bccl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kasé gón pegr o hayáláni zórá wati zenday róchán sáhaté ham gésh korta kant? ");
INSERT INTO bccl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Agan shomá inchokén kasánén káré korta nakanét, gorhá chiá zenday dega chizzáni bárawá pegra kanét? ");
INSERT INTO bccl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","28","“Oo kambáwarán! Gol o polláni némagá delgósh kanét ke chón rost o rodóma kanant. Na zahmaté kasshant o na résant o gwapant, bale man shomárá gwashán ke Solaymán bádsháhá gón wati mazanén shán o shawkatá, hechbar choshén dhawldárén póshák gwará nabutag, chosh ke é poll zébá o brahdár ant. Wahdé Hodá gyábánay káhán ke maróchi hastant o bándá taruná sóchaga bant, é dhawlá zébá o brahdára kant, gorhá shomárá che paymá sharterén pósháka nadant? ");
INSERT INTO bccl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Paméshká pa ward o warákay shóházá watá delsyáh makanét. ");
INSERT INTO bccl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Donyáay sajjahén Hodánábáwarén mardom é chizzáni randá tachant, bale shomay ásmáni Peta zánt ke shomárá é chizz pakár ant. ");
INSERT INTO bccl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Shomá Hodáay bádsháhiay shóházá bebét, é sajjahén wat shomárá dayaga bant. ");
INSERT INTO bccl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Oo mani kasánokén romb o thóli! Matorsét chiá ke shomay ásmáni Petay razá o wáhag hamesh ent ke bádsháhiá shomárá bedant. ");
INSERT INTO bccl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wati mál o melkatá bahá kanét o nézgáráni sará bahr kanét. Pa wat anchén zarturag addh bekanét ke hechbar kwahn mabant, nahallagi o abadmánén ásmáni ganjé ambár kanét ke na dozz áiá bárt o na warók o raméz áiá wárt. ");
INSERT INTO bccl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Shomay del hamá jáhá rawt ke mál hamódá ent. ");
INSERT INTO bccl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Lánká bebandét o wati cherágá rók o rozhnág bedárét. ");
INSERT INTO bccl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hamá hezmatkár o dazbójáni paymá bebét ke rahchár ant áyáni hodábond kadén cha sur o árósay shádehián pera tarrit o anchosh ke kayt o darwázagá thokkit, á darwázagá pacha kanant. ");
INSERT INTO bccl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bahtáwar ant hamá hezmatkár ke áyáni hodábonda kayt o gendit ágáh o hozzhár ant. Báwar kanét hodábond wat pa áyáni hezmatá lánka bandit, áyána nendárénit o warag démá dant. ");
INSERT INTO bccl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Bahtáwar ant hamá hezmatkár agan áyáni wájah shapay domi yá saymi pásá byayt, begendit ke ágáh ant. ");
INSERT INTO bccl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Shomá sharra zánét, agan lógay hodábondá bezántén dozz kojám wahdá kayt, gorhá áiá hechbar dozz wati lógá pa dozziá naeshtagat. ");
INSERT INTO bccl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Hamé paymá tayár bebét, chiá ke Ensánay Chokk anchén wahdéá kayt ke shomá áiay entezár o wadárá nabét.” ");
INSERT INTO bccl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrosá gwasht: “Oo Hodáwand! É mesál taw pa má áwort yá pa sajjahénán?” ");
INSERT INTO bccl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Hodáwandén Issáyá gwasht: “Wapádár o shiwwárén kármaster hamá ent ke hodábond áiá wati é dega sajjahén hezmatkáráni master bekant tán áyán pa wahd ward o warák bedant. ");
INSERT INTO bccl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bahtáwar ent hamá hezmatkár ke wahdé hodábonda kayt, áiá hamá káráni sará gendit. ");
INSERT INTO bccl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Shomárá rásténa gwashán, hodábond hamá hezmatkárá wati sajjahén mál o hastiay kármastera kant. ");
INSERT INTO bccl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Bale agan hamá kármaster wati delá begwashit: ‘Angat mani hodábonday áyagá báz wahd hast’ o paméshká warag o charagá malár o hanósh bebit o wati hamkárén golám o móledán latth o kotth bekant. ");
INSERT INTO bccl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Áiay hodábond anchén róch o sáhatéá kayt o rasit ke á nazánt o wadárá naent. Gorhá hodábond áiá thokkor thokkora kant o béwapá o nábáwaráni nyámá dawra dant. ");
INSERT INTO bccl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Á hezmatkár ke wati hodábonday wáhag o delkasshiána zánt, bale angat áiay razá o morádáni sará kár kanagá watá tayára nakant, bázén latthé wárt. ");
INSERT INTO bccl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Bale hamá ke pa názánti anchén radé jant ke latth o kotthay sezáwár ent, kamter lattha wárt. Chiá ke cha masterén mansabdárá géshter jost o porsa bit o kaséá ke géshter zemmahwári dayag butag, cha áiá géshter hesáb geraga bit. ");
INSERT INTO bccl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Man donyáyá átkagán ke ásé rók bekanán. Drégatá é wahdi á ás rók butén. ");
INSERT INTO bccl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Bale cha áiá pésar, maná pákshódié zalurat ent, ke pa áiay sarjam kanagá báz paréshán o bétáhir án. ");
INSERT INTO bccl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Gomána kanét man átkagán tán zeminay sará tepáki o sohl byárán? Na, man pa jetáiay áragá átkagán. ");
INSERT INTO bccl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Cha é damáná o rand, har lógay panchén mardománi nyámá jetáia kapit, say doay helápá o do sayay helápá bit. ");
INSERT INTO bccl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pet gón chokká nátepáka bit o chokk gón petá, jenek cha mátá jetá bit o mát cha jeneká, wassig gón neshárá nátepáka bit o neshár gón wassigá.” ");
INSERT INTO bccl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Gorhá Issáyá gón mardomán gwasht: “Wahdé shomá dém pa rónendá gendét ke jambaréá bastag, hamá damáná gwashét ke hawra bit o hawr ham gwárit. ");
INSERT INTO bccl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Wahdé cha jonubá gwáta kasshit, gwashét ke maróchi garm o lewára bit o hamé dhawlá ham bit. ");
INSERT INTO bccl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Oo dopóstén shatalkárán! Wahdé shomá zemin o ásmánay rang o neshániána zánét ke ché bayagi ent, gorhá chón é annugén zamánagay neshánián kesás korta nakanét? ");
INSERT INTO bccl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Shomá pa ché rástiá wat kesás korta nakanét? ");
INSERT INTO bccl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Wahdé gón wati daynkárá hakdiwáná raway, johd kan ráhá gón áiá pa sohl o saláh berasay. Chosh mabit ke tará káziay kerrá bebárt o á tará sepáhigay dastá bedant o sepáhig tará bandijáhá bebárt o jél bekant. ");
INSERT INTO bccl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tará gwashán, tán wahdé ke taw zarráni goddhi pai o paysahá porr makanay, cha ódá ázáta nabay.” ");
INSERT INTO bccl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Hamá wahdá, lahténá gón Issáyá á Jalili mardománi bárawá hál o habara kort ke Pilátusá koshtagatant o áyáni hón, gón hamáyáni korbánigén dalwatáni hóná hór o hawár kortagat. ");
INSERT INTO bccl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Issáyá áyáni passawá gwasht: “Shomá gomána kanét, á Jalili ke pa choshén bazzagi o syahróchié dochár kaptant, cha á degarán gonahkárter atant? ");
INSERT INTO bccl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Man shomárá gwashán na, chosh naent, bale agan cha wati gonáhán pashómán mabét, shomá ham hamáyáni dhawlá gár o gomsára bét. ");
INSERT INTO bccl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Gomána kanét hamá hazhdahén mardom ke Siluháay borj áyáni sará kapt o mortant, cha Urshalimay á dega sajjahén mardomán radkárter atant? ");
INSERT INTO bccl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Man shomárá gwashán na, shomá ham, agan cha wati gonáhán pashómán mabét, hamáyáni dhawlá gár o gomsára bét.” ");
INSERT INTO bccl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Padá Issáyá pa áyán mesálé jat: “Mardéá wati anguri bágá enjiray drachké hastat. Yak róché, á enjiray baráni cháragá bágá shot, bale baré nadisti. ");
INSERT INTO bccl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Gorhá gón wati bágpáná gwashti: ‘Say sál ent ke man é enjiray baráni cháragá káyán bale heccha nagendán. Begoddhi tán zeminá bébar o bésamar makant.’ ");
INSERT INTO bccl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Bale bágpáná passaw dát: ‘Wájah! Dega yak sálé belli, man eshiay boná kóchán o kolóndhán o samáta dayán, ");
INSERT INTO bccl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","démi sálá, agan bari dát sharr, agan nadáti gorhá begoddhi.’” ");
INSERT INTO bccl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Shabbatay róché, Issá yak kanisahéá mardomán sabak o tálim dayagá at. ");
INSERT INTO bccl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yak janéné hamódá at ke hazhdah sálá, yak arwáhéá nádráh kortagat. Kompi jatagat o hech dhawlá wati sréni tachk korta nakort. ");
INSERT INTO bccl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wahdé Issáay chamm pa áiá kaptant, tawári kort o gwashti: “Oo janén! Taw cha wati nájórhiá rakketay.” ");
INSERT INTO bccl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Issáyá wati dast áiay sará ér kort o hamá damáná á kompén janénay srén tachk but o Hodáay sepat o sanáyá lagget. ");
INSERT INTO bccl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Bale kanisahay master pa é sawabá ke Issáyá Shabbatay róchá drahbakshi kortagat nárazá but o gwashti: “Shomárá pa wati kárán shash róch hast o hamá róchán pa wati drahbakshiá byáét, na ke Shabbatay róchá.” ");
INSERT INTO bccl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Hodáwandén Issáyá áiay passawá darráént: “Oo shatalkárén ryákárán! Cha shomá hechkas Shabbatay róchá wati har o gókán cha wati banjáhána nabójit o dhanná pa áp dayagá nabárt? ");
INSERT INTO bccl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Gorhá, é janén, ke Ebráhémay nasl o padréch ent o hazhdah sál ent ke Shaytáná wati bandig kortag, chiá Shabbatay róchá cha wati azábán ázát o ásudag kanag mabit?” ");
INSERT INTO bccl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wahdé Issáyá chosh gwasht, áiay sajjahén badwáh pashal o sharmendag butant. Bale é dega sajjahén mardom cha Issáay é mójezah o ajabén kárán báz washdel o shádán butant. ");
INSERT INTO bccl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Randá, Issáyá gwasht: “Hodáay bádsháhi che paymá ent? Áiá gón chónén chizzé hamdarwar bekanán? ");
INSERT INTO bccl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Hodáay bádsháhi, thélkáhay tohmay paymá ent ke mardéá zort o wati bágá kesht. Á dánag rost o drachkéay dhawlá but o báli morgán áiay ták o tháláni chérá kodóh o kodám bast.” ");
INSERT INTO bccl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Padá gwashti: “Man pa Hodáay bádsháhiá chónén mesálé pésh bekanán? ");
INSERT INTO bccl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Hodáay bádsháhi hamá homiray paymá ent ke janénéá zort o gón bázén ártéá hawár kort o kam kammá sajjahén árt gwát gept o homir but.” ");
INSERT INTO bccl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Issá shahr pa shahr o métag pa métag mardomán tálim dayán dém pa Urshalimá rawagá at, ");
INSERT INTO bccl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","yakkéá jost kort: “Oo wájah! Bárén, cha mardomán, tahná kammokéné rakkit?” ");
INSERT INTO bccl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Áiá passaw dát: “Johd kanét cha tankén darwázagá begwazét, chiá ke man shomárá gwashán, bázéné cha hamé darwázagá gwazagay johdá kant, bale gwasta nakant. ");
INSERT INTO bccl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Wahdé kayt ke lógay hodábond páda kayt o lógay darwázagá banda kant, gorhá shomá lógay dapá óshtét o harchont darwázagá thokkét o tawára kanét: ‘Oo wájah! Darwázagá pa má pach kan!’, bale á passawa dant ke ‘man shomárá pajjáha nayárán o nazánán cha kojá ét.’ ");
INSERT INTO bccl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Shomá gwashét: ‘Má gón taw hamwán o hamdiwán butagén o taw may damk o kuchahán márá tálim dátag.’ ");
INSERT INTO bccl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Bale á passawa dant: ‘Man shomárá pajjáha nayárán o nazánán cha kojá ét? Oo radkárán! Cha mani démá dur bét.’ ");
INSERT INTO bccl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Á wahdá, gréwét o dantán pa dantána droshét, chiá ke Ebráhém, Eshák, Ákub o sajjahén paygambarán, mán Hodáay bádsháhiá gendét, bale wat cha Hodáay bádsháhiá dhanná dawr dayaga bét. ");
INSERT INTO bccl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","“É dega mardom cha ródarátk o rónend o cha shomál o jonubay chárén némagána káyant o Hodáay bádsháhiay parzónagay sará nendant. ");
INSERT INTO bccl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Haw, anchosh ent ke áheri, awalia bant o awali, áheria bant.” ");
INSERT INTO bccl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Hamá wahdá, lahtén Parisi, Issáay gwará átk o gwashtesh: “Nun taw é jágahá yalah kan o dega jáhéá beraw, chiá ke Hirudis tai koshagay randá ent.” ");
INSERT INTO bccl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Áyáni passawá gwashti: “Berawét á róbáhá begwashét ‘Maróchig o bándá, jennána kasshán o mardomán dráha kanán o saymi róchá, wati kárá sarjam pa sara rasénán.’ ");
INSERT INTO bccl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Bale maróchi, bándát o póshi, allamá wati é sát o sapará démá barán, chiá ke hech paygambaray kósh cha Urshalimá dhanná nabit. ");
INSERT INTO bccl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Urshalim, oo Urshalim! Taw paygambarána koshay o Hodáay ráh dátagénán sengsára kanay. Báz randá man lóthetag tai chokkán wati kerrá mocch o yakjáh bekanán, anchosh ke nekénkén morgé chureg o chippokán wati bál o bánzoláni chérá moccha kant, bale shomá nalóthet. ");
INSERT INTO bccl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Nun shomay lógay ákebat, shomay wati dastá yalah dayaga bit. Shomárá gwashán dega baré maná nagendét tán á wahdá ke cha wati zobáná begwashét: ‘Mobárak bát hamá ke pa Hodáwanday námá kayt!’” ");
INSERT INTO bccl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Shabbatay róché, Issá pa warákay waragá cha Parisi sarókán yakkéay lógá shotagat. Óday mardom pa delgósh áiá cháragá atant ke bárén ché kant? ");
INSERT INTO bccl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Áiay dém pa démá, mardé at ke gón jalandaray nádráhiá gwát geptagat. ");
INSERT INTO bccl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Issáyá cha Sharyatay kázi o Parisián jost gept: “Shabbatay róchá nádráháni dráh kanag rawá ent yá na?” ");
INSERT INTO bccl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Bale á bétawár butant. Gorhá Issáyá á marday dast gept, dráhi kort o roksat dát ke berawt. ");
INSERT INTO bccl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Gorhá Issáyá dém gón áyán tarrént o gwashti: “Cha shomá kay ent ke áiay chokk yá gók Shabbatay róchá chátá bekapit o áiá hamá damáná cha chátá dar makant?” ");
INSERT INTO bccl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Bale áyán hech passaw dát nakort. ");
INSERT INTO bccl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wahdé Issáyá dist ke mehmán, che paymá diwánjáhay sharterén jágahán gechén kanagá ant, gorhá é mesáli dát o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Wahdé taw pa sur o áróséá lóthaga bay, diwánay sharterén jágahán manend, balkén cha taw masterén mardomé ham lóthag butag. ");
INSERT INTO bccl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Gorhá, á mehmándár ke shomá har doéni lóthetagant, tará gwashit: ‘Wati jáhá áiá beday.’ Gorhá taw pashal o sharmendaga bay o nácháriá, cha sajjahénán jahltera nenday. ");
INSERT INTO bccl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Wahdé kasé tará mehmán bekant, sajjahénáni poshtá benend, tánke mehmándár wat byayt o begwashit: ‘Oo mani dóst! Byá o démáter benend.’ Á wahdá, taw á dega mehmánáni chammá sharapdártera bay. ");
INSERT INTO bccl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Chiá ke harkas watá mazana zánt o lékit, kamsharapa bit o harkas watá jahl o érdasta mannit, washnám o sharapdára bit.” ");
INSERT INTO bccl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Gorhá, Issáyá gón mehmándárá gwasht: “Wahdé taw pa sobáreg yá shámá mehmánia kanay, wati sangat, brát o syád yá hastómandén hamsáhegán malóth, chosh mabit ke á ham tai mehmániay badalá, tará mehmán bekanant o taw wati mehmániay badalá begeray. ");
INSERT INTO bccl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Wahdé mehmánia kanay, gorhá nézgár o mondh o lang o kórán belóth. ");
INSERT INTO bccl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Gorhá bahtáwara bay, chiá ke áyáni kerrá chizzé nést tará badalá bedayant o taw wati mozzá pahrézkáráni padá zendag bayagay wahdá geray.” ");
INSERT INTO bccl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cha óday mehmánán yakkéá, gón é habaray eshkonagá gwasht: “Bahtáwar ent hamá ke Hodáay bádsháhiay mehmániá waraga wárt.” ");
INSERT INTO bccl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Issáyá passaw dát o gwashti: “Mardéá mazanén mehmánié kort o bázén mardomé lótháént. ");
INSERT INTO bccl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mehmániay róchá, gón wati golámá gwashti: ‘Beraw mani mehmánán begwash: “Byáét ke har chizz nun tayár ent.”’ ");
INSERT INTO bccl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bale cha á sajjahénán har yakkéá nimmóné kort o nayátk. Yakkéá gwasht: ‘Man yak dhagáré pa bahá geptag o báyad ent pa áiay cháragá berawán, paméshká pahellia lóthán.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Degaréá gwasht: ‘Man panch jopt káigar geptag o pa áyáni chárag o chakkásagá sar geptagán, paméshká pahellia lóthán.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Saymiá gwasht: ‘Man nóki sur kortag, paméshká átka nakanán.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Golám átk o wati hodábondi cha sajjahénáni hálá sahig kort. Hodábond é habaráni eshkonagá sakk zahr gept o hokmi kort: ‘Pa eshtápi beraw, cha shahray tank o rahsarán, sajjahén nézgár, mondh, kór o langán pa é mehmániay waragá byár.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Randá, golám átk o gón hodábondá gwashti: ‘Wájah! Harché ke taw maná hokm dát man hamá dhawlá kort, bale angat jágah hastent.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Gorhá hodábondá wati golám hokm kort: ‘Shahrá dhann, ráh o rahsarán beraw, mardomán shóház kan o áyán mennat kan o mani lógá byár tánke mehmánjáh cha mardomá porr bebit.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Shomárá rásta gwashán ke cha awali lóthetagén mardomán yakké ham, mani mehmániay warákána nachashit.” ");
INSERT INTO bccl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Mazanén romb o mocchié, Issáyá hamráhi kanagá at. Áiá dém gón áyán tarrént o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Á ke lóthit mani morid bebit, agan cha wati pet o mát, jan o chokk, brát o gohárán o cha wati jenday sáhá ham sar magwazit, mani morid buta nakant. ");
INSERT INTO bccl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Agan kasé wati salibá baddhá makant o mani randá mayayt, á ham mani morid buta nakant. ");
INSERT INTO bccl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Kay ent á ke lóthit borjé bebandit, bale cha borjay bandagá pésar, manendit o áiay zarr o málay hesábá makasshit o machárit ke bárén é káray sarjam o purah kanagay wák o twáni hast yá na? ");
INSERT INTO bccl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Chiá ke agan é borjay bonredá ér bekant o némtamán bellit, sajjahén mardom ke gendant, áiá kalág o rishkanda kanant o ");
INSERT INTO bccl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","gwashant: ‘É mardá káré bongéj kort bale sarjam kanagá dar mant.’ ");
INSERT INTO bccl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Yá kojám bádsháh ent ke gón dega bádsháhéá pa jangá sar begipt bale cha jangá pésar, manendit o é pegrá makant ke bárén gón dah hazáray pawjá, á bádsháhay bist hazári lashkaray démá dáshta kant yá na? ");
INSERT INTO bccl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","O agan begendit ke áiay démá dáshta nakant, gorhá angat ke dozhmenay lashkar dur ent, cha péshá pa sohl o tráná wati kásedán rawána kant. ");
INSERT INTO bccl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Hamé paymá, cha shomá harkasé, tán wahdé ke cha wati sajjahén mál o hastiá dast makasshit, mani morid buta nakant. ");
INSERT INTO bccl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Wád sharr ent bale agan wáday tám berawt, gorhá chón áiá padá wádók korta kanant? ");
INSERT INTO bccl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Na pa zemin o dhagárá darda wárt o na samát buta kant, áiá dura réchant. Harkasá pa eshkonagá gósh per, beshkont.” ");
INSERT INTO bccl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nun sajjahén songi o máliátgir o gonahkárén mardom, Issáay gwará átkant tán áiay habarán beshkonant. ");
INSERT INTO bccl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Bale Parisi o Sharyatay zánóger, norondhán o iráz geráná gwashagá atant: “É mard gón gonahkárán nend o nyáda kant o gón áyán hór waraga wárt.” ");
INSERT INTO bccl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Gorhá Issáyá pa áyán é mesál áwort o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Cha shomá agan kaséá sad mésh bebit o cha áyán yakké gár bebit, gorhá nawad o nohén méshán charágáhá yalaha nadant o hamá gárén méshay shóházá narawt tán áiá dar begéjit? ");
INSERT INTO bccl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Wahdé gárén méshá dara géjit pa galé wati kópagá kanti, ");
INSERT INTO bccl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","lógá rawt, dóst o hamsáhegána lóthit o gwashit: ‘Gón man gal o shádehi kanét ke man wati á gárén mésh dar gétkag.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Man shomárá gwashán, hamé dhawlá pa yak pashómánén gonahkáréá ásmáná mazanén jashné geraga bit, bale pa nawad o noh pahrézkárá ke áyán pashómáni darkár naent choshén jashné geraga nabit. ");
INSERT INTO bccl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yá ke agan janénéá dah kaldár bebit o cha á dahén kaldárán yakké gár bebit, gorhá pa wati gárén kaldáray shóházá, cherág róka nakant o lógá narópit? Tán áiá dar magéjit cha wati shóházá dasta kasshit? ");
INSERT INTO bccl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Anchosh ke á kaldárá dara géjit, dóst o hamsáhegána lóthit o gwashit: ‘Gón man gal o shádehi kanét chiá ke wati gárén kaldáron wadi kortag.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Hamé paymá man shomárá gwashán, agan yak gonahkáré cha wati gonáhán pashómán bebit o Hodáay ráhá byayt, Hodáay préshtagáni bárgáhá jashn o shádehi geraga bit.” ");
INSERT INTO bccl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Issáyá gésh kanán kort o gwashti: “Yak mardéá do mardénchokk hastat. ");
INSERT INTO bccl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Kasteréná yak róché gón petá gwasht: ‘Oo mani pet! Cha tai mál o melkatá, harché ke mani bahr o wandhá kapit maná annun beday.’ Gorhá petá wati sajjahén mál o maddhi doén chokkáni sará bahr kort. ");
INSERT INTO bccl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","14","“Lahtén róchá o rand, kasterén chokká wati sajjahén bahr yakjáh kort, zort o durén molkéá shot o sajjahén zarri pa hawasnáki gár kortant. Randá, á molká sakk dhokkál kapt o á dastang o mohtáj but. ");
INSERT INTO bccl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Hamá molká, yak mardoméay kerrá shot o pa káréay geragá watá lacchénti. Gorhá, áiá wati dhagáráni sará hukkáni chárénók kort. ");
INSERT INTO bccl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ódá haminchok shodig but ke delia lóthet hamá kónsagán bwárt o wati lápá sér bekant ke hukkáni warák atant, bale kassá pa waragá hecch nadát. ");
INSERT INTO bccl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wahdé hóshi kort o zánti, gón wat gwashti: ‘Mani petay bázén nawkar o kárdárá lápay sérá waráka rasit o man edá shodá mark án. ");
INSERT INTO bccl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nun wati petay kerrá pera tarrán o áiá gwashán: Oo mani pet! Man tai o ásmánay Hodáay gonahkár án o ");
INSERT INTO bccl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","nuna nakarzán ke tai chokk gwashag bebán. Maná wati hezmatkáráni dhawlá yak hezmatkáré bekan.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Gorhá pád átk o dém pa petay lógá rahádag but. Petá ke cha durá dist deli pa áiá sotk o pa eshtápi áiay démá tachán but o gwarambázi kort o chokketi. ");
INSERT INTO bccl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Chokká gwasht: ‘Oo mani pet! Man tai o ásmánay Hodáay gonahkár án o nuna nakarzán ke tai chokk gwashag bebán.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Bale petá wati hezmatkár gwashtant: ‘Eshtáp kanét, pa áiá gehterén kabáhá byárét o gwarái bedayét. Challah o mondriki dastá o kawshi pádá bedayét. ");
INSERT INTO bccl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Á pábondi gwaská byárét o bekoshét tánke jashné bekanén o wasshén waráké bwarén. ");
INSERT INTO bccl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Chiá ke mani é chokk mortagat bale nun padá zendag butag, gár at o nun wadi butag. É dhawlá áyán gal o shádehi kort.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Bale masterén chokk dhagáráni sará at. Wahdé lógay nazziká raset o sáz o zémelay tawári eshkot, ");
INSERT INTO bccl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","cha hezmatkárán yakké lóthet o josti kort: ‘Edá ché bayagá ent?’ ");
INSERT INTO bccl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Hezmatkárá passaw dát: ‘Tai brát padá lógá átkag o nun ke á pa wasshi o salámati rasetag tai petá jashné geptag o á pábondi gwaski koshtag.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Gorhá, masterén brát sakk zahr gept o nalótheti lógá berawt. Bale pet dhanná átk o áiay wasshán kanagá mennatwár but. ");
INSERT INTO bccl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Chokká petay mennatgiriay passawá gwasht: ‘Wati delá bechár, man inchok sálá tai kerrá goláméay dhawlá kár kortag, hechbar cha tai hokmá dar nabutagán o taw maná yak sheneké ham nadátag ke gón wati dóst o hambalán shádehi bekanán. ");
INSERT INTO bccl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Bale tai é chokká tai mál gón waylánkén janénán gár o gárat kortag o taw pa áiay per tarragá pábondi gwask koshtag.’ ");
INSERT INTO bccl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Petá gwasht: ‘Oo mani chokk! Taw harwahd mani kerrá ay o harché ke maná hast á sajjahén taig ant, ");
INSERT INTO bccl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","bale annun márá paméshká jashn o shádehi kanagi ent ke tai é brát mortagat o nun zendag butag, gár o bégwáh at o nun wadi butag o átkag.’” ");
INSERT INTO bccl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Issáyá gón wati moridán gwasht: “Azgár o hastómandén mardéá hesábdáré hastat. Wahdé pa áiá é hál sar but ke hesábdár áiay málá wárt o gára kant, ");
INSERT INTO bccl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","gorhá á lóthet o gwashti: ‘É chónén habar ant ke tai bárawá man eshkonagá án? Beraw wati sarjamén hesáb o ketábán begisshén o byár o maná beday. Maróchi o rand, taw cha mani hesábdáriá dar ay.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Hesábdárá wati delá jérhet: ‘Nun chón bekanán ke mani wáhond maná cha kárá dar kanagá ent, bard o kódhál man jata nakanán, pendhagá ham maná lajja kant. ");
INSERT INTO bccl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Bale haw! Annun zánton ché bekanán. Báyad ent anchén káré bekanán ke wahdé cha kárá kasshaga bán, randá mardom maná wati lógán bellant.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Áiá wáhonday wámdár yak yakká wati kerrá lóthetant. Cha awali wámdárá josti gept: ‘Tará mani wáhonday chinchok wám per ent?’ ");
INSERT INTO bccl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Passawi dát: ‘Maná yaksad kayl zaytuni rógen wám per ent.’ Hesábdárá gwasht: ‘Beger, esh ent tai wámáni kabz, zutt benend o panjáh kayl benebis.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Padá cha domi wámdárá josti kort: ‘Tará chinchok wám per ent?’ Gwashti: ‘Yaksad kayl gandom.’ Hesábdárá gwasht: ‘É tai wámáni kabz ent. Beger o hashtád kayl benebis.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Wáhondá wati locch o dozzén hesábdár shábásh gwasht, ke áiá é kár, gón aglmandi kortagat. Chiá ke é wahday chokk gón wati zamánagay mardomán donyái gir o dáráni dar baragá, cha Nuray chokkán bezán Hodái mardomán ákelter ant. ");
INSERT INTO bccl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Shomárá gwashán ke donyáay é béwapáén málá pa sharrén dóstáni shóház kanagá kár bandét, tánke wahdé é mála hallit, shomárá abadmánén jaháná wasshátk bekanant. ");
INSERT INTO bccl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Á ke gwandh o kasánén káráni sará tachk o rásta bit, mazanénáni sará ham rásta bit o á ke gwandhén káráni sará rásta nabit, mazanénáni sará ham rásta nabit. ");
INSERT INTO bccl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nun agan shomá é béwapá o kurhahén donyáay máláni sará rást o tachk mabét, gorhá kay barhakkén mál o ganjay bárawá shomay sará báwara kant? ");
INSERT INTO bccl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Agan pa degaráni málá rást o tachk mabét, kay ent ke shomay wati málá, shomárá bedant? ");
INSERT INTO bccl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Hech golámé pa do wájahá hezmat korta nakant, yá gón yakkéá dozhmenia kant o domigi dósta bit, yá gón awaligá wapádára bit o cha á degará badia kayt. Shomá yakwahd o yakjáh, Hodá o zarray golámiá korta nakanét.” ");
INSERT INTO bccl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi ke wat zarparast atant, gón é habaráni eshkonagá, Issáesh kalág gept o rishkand kort. ");
INSERT INTO bccl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Issáyá gwasht: “Shomá hamá ét ke mardománi démá watá tachk o pahrézkár pésha dárét, bale Hodá cha shomay delay hálán sahig ent. Shomárá begwashán, hamá chizz ke mardománi gwará báz kimmati ent, Hodá cha á chizzá sakk bézár ent. ");
INSERT INTO bccl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Tawrát o sajjahén nabiáni bárig, tán Yahyáay wahdá at. Nun randá, Hodáay bádsháhiaymestág dayaga bit o harkas johda kant wati ráhá dém pa áiá dar begéjit. ");
INSERT INTO bccl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bezánét ke ásmán o zeminay gár o bérán bayag cha Sharyatay yak thekk o noktahéay kapag o dur bayagá báz ásánter ent. ");
INSERT INTO bccl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Agan kasé wati janá sawn o taláka dant o gón dega janénéá sura kant, zená kant o harkas ke gón talák dátagén janénéá sur o sánga kant, á ham zená kant. ");
INSERT INTO bccl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Yak máldár o azgárén mardéá modám gránkimmatén pocch o pósháka póshet o wati róchi pa aysh o nósha gwázéntant. ");
INSERT INTO bccl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ilázar námén yak garibén mardé hamáiay lógay dapá nádénag butagat ke jesm o jáni, sará tán pádá résh at. ");
INSERT INTO bccl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Áiay armán at ke cha azgárén marday parzónagay sar átkagén chondh o chánigán, wati lápá sér bekant. Kochek ham átkant o áiay résh o násuresha chatthetant. ");
INSERT INTO bccl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wahdé á garib mort, préshtagán á zort o Ebráhémay kerrá bort. Azgárén mard ham mort o mardomán kabr o kapon kort. ");
INSERT INTO bccl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Hamá sér o azgárén mard, dózahá sakk bazzagi kasshagá at. Áiá ke sar chest kort cha durá chammi pa Ebráhémá kapt ke hamá Ilázar áiay kashá nendók at. ");
INSERT INTO bccl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Gwánki jat: ‘Ebráhém, oo mani pet! Tará mani sará bazzag bát, Ilázará mani kerrá dém beday ke wati lankoká ápá bejant o mani nokká tarr bekant ke man ásá sochagá án.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bale Ebráhémá passaw dát: ‘Oo mani bacch! Hayálá bekap ke taw wati zendá sharrén chizzáni wájah butagay o Ilázará wati róch pa bazzagi gwázéntagant. Bale á nun edá ásudag ent o taw azábán talwasagá ay. ");
INSERT INTO bccl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Eshiá abéd, shomayg o may nyámá, yak anchén johlén daragé borrag butag ke na may némagay mardom shomay gwará shota kanant o na shomay némagay mardom may kerrá átka kanant.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Padá azgárén mardá gón Ebráhémá gwasht: ‘Oo mani pet! Gorhá cha taw dazbandia kanán, Ilázará mani petay lógá rawán bekan, ");
INSERT INTO bccl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","chiá ke mani panch brát ant o mani wáhag ent ke Ilázar áyáni kerrá berawt o áyán dháh bedant o hozzhár bekant, chosh mabit ke á ham é porazábén jágahá byáyant.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bale Ebráhémá gwasht: ‘Áyáni kerrá Mussá o Nabiáni Ketáb hastant. Áyán bwánant o habaránesh gósh bedárant.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Á mardá gwasht: ‘Na, oo mani pet Ebráhém! Cha mordagán agan kasé áyáni kerrá berawt, allamá á cha wati badén kárán pashómána bant.’ ");
INSERT INTO bccl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ebráhémá gwasht: ‘Agan á Mussá o paygambaráni habarán gósha nadárant, gorhá cha mordagán ham agan kasé zendag bebit o áyáni kerrá berawt, áiay habarán ham báwara nakanant o namannant.’” ");
INSERT INTO bccl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Issáyá gón wati moridán gwasht: “Nabit ke mardom rad majant o thagal mawárt, bale apsóz pa hamá kasá ke degarán dém pa gonáhá bebárt. ");
INSERT INTO bccl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Cha é kasánokénán yakkéay dém pa gonáhá baragay badalá, gehter hamesh ent ke áiay gardená jenteri táé bebandant o daryáyá chagali bedayant. ");
INSERT INTO bccl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Cha wati kár o kerdán hozzhár bét. Agan tai brát gonáhé bekant, áiá sarkech day o mayárig kan, agan pashómán but, bebakshi. ");
INSERT INTO bccl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Toré róché hapt randá gonáh bekant o hapt randá tai gwará byayt o begwashit: ‘man pashómán án,’ bebakshi.” ");
INSERT INTO bccl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Issáay kásedán gón Hodáwandén Issáyá gwasht: “Wájah! May setk o báwará gésh kan.” ");
INSERT INTO bccl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Gwashti: “Agan shomay báwar arzonéay kesásá ham bebit, shomá tuday é drachká hokm korta kanét ke ‘watá cha boná begwaj o beraw zeray tahá berod o besabz’. Á wahdá, drachk shomay hokmá mannit. ");
INSERT INTO bccl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Cha shomá á kas kay ent ke áiay hezmatkár cha dhagáráni nangár kanag, ramagay chárénag o káray halás kanagá byayt, wáhond áiá begwashit: ‘Zutt byá o benend o warag bwar?’ ");
INSERT INTO bccl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Gón áiá nagwashit: ‘Pésará pa man warag addh kan, tán man nawártag taw mani hezmatá bósht, wahdé man halás kort gorhá taw bwar?’ ");
INSERT INTO bccl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Hodábond, wati hezmatkáray shogr o mennatá gipt ke ‘taw mani hokm mannetag?’ Na, hechbar. ");
INSERT INTO bccl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Hamé paymá shomá ham, sajjahén á hokmán ke shomárá dayag butagant sarjam bekanét o begwashét ke ‘má tai hezmatkár bayagay láhek ham naén, tahná wati zemmah o dhobbah sarjam kortagant.’” ");
INSERT INTO bccl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Issá dém pa Urshalimay rawagá, cha Sámerah o Jalilay simsarán gwazagá at. ");
INSERT INTO bccl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wahdé dém pa yak métagéá pédák at, dah syahgarrién mardom gón áiá dochár kapt. Dur óshtátant o ");
INSERT INTO bccl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","gón borzén tawáré gwashtesh: “Oo wájah Issá! Tará may sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Issáyá ke distant gwashti: “Berawét watá pa dini péshwáyán pésh bedárét.” Á, ráh geptant o ráhay nyámá, pák o palgár butant. ");
INSERT INTO bccl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cha áyán yakkéá, wahdé dist ke nun dráh ent, gón borztawári Hodáyá satá kanán, per tarret o átk, ");
INSERT INTO bccl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Issáay pádán kapt o shogri gept. Á, cha Sámerián at. ");
INSERT INTO bccl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Issáyá jost kort: “Záná, har dahén cha garrá pák o palgár nabutét? Á dega nohén kojá ant? ");
INSERT INTO bccl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","É yakkén darkawmá abéd, cha áyán dega yakké pa Hodáay sepat o sanáyá nayátk?” ");
INSERT INTO bccl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Gorhá Issáyá gón á mardá gwasht: “Pád á, beraw, ke tai setk o báwará tará dráh kortag.” ");
INSERT INTO bccl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yak róché, lahtén Parisiá cha Issáyá jost kort: “Hodáay bádsháhi kadéna kayt?” Issáyá gwasht: “Hodáay bádsháhi chamzáherá gendaga nabit. ");
INSERT INTO bccl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Gwashaga nabit ke Hodáay bádsháhi edá ent yá ódá. Chiá ke Hodáay bádsháhi, shomay delá ent.” ");
INSERT INTO bccl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Padá gón wati moridán gwashti: “Yak wahdé kayt ke shomá pa Ensánay Chokkay rócháni yak róchéay gendagá armán o árzua kanét, bale á róchá nagendét. ");
INSERT INTO bccl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mardom shomárá gwashant ke ‘á edá ent’ yá ‘á ódá ent,’ bale shomá áyáni habará gón makapét. ");
INSERT INTO bccl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Anchosh ke grók cha yak kondhéá jant o sajjahén ásmáná jarhashkénit o rozhnága kant, Ensánay Chokk ham wati á róchá, anchosh záher o paddara bit. ");
INSERT INTO bccl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bale awalá báyad ent bázén sakki o sóri besaggit o é zamánagay nasl o padréch áiá mamannant. ");
INSERT INTO bccl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Hamá dhawlá ke Nuhay bárigá butag, Ensánay Chokkay róch ham anchosha bit. ");
INSERT INTO bccl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Á róchán, mardom ward o nósh o sáng o surá dazgatth atant tán hamá róchá ke Nuh bójigá swár but. Randá, mazanén hár o tuppáná sajjahén mardom gár o bégwáh kortant. ");
INSERT INTO bccl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Lutay zamánagá ham hamé dhawlá at, mardom pa warag o charag o badal o bándát o kesht o keshár o lóg o jágahay bandagá goláésh atant, ");
INSERT INTO bccl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","bale á róchá ke Lut cha Sodumay shahrá dar átk, Hodáyá cha ásmáná ás o rókén gókort gwárént o Sodumay sajjahén mardom gár o bégwáh kortant. ");
INSERT INTO bccl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Ensánay Chokkay paddar bayagay róchá, hamé dhawlá bit. ");
INSERT INTO bccl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Á róchá, agan kasé wati lógay sará bebit o áiay ord o poténk lógá ér bant, pa áyáni zuragá jahlá ér makapit. Hamé dhawlá, agan kasé wati dhagáráni sará kesht o keshárá ent, á ham padá lógá per matarrit. ");
INSERT INTO bccl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lutay lógbánokay sargwastá yát bekanét. ");
INSERT INTO bccl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Harkas wati sáhay rakkénagay randá bebit, áiá báhénit. Harkas wati sáhá bebáhénit, áiá rakkénit. ");
INSERT INTO bccl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Shomárá gwashán ke á wahdá, agan do mardom yakkén taht o nepáday sará waptag, yakké baraga bit o domi hamódá pasht géjaga bit. ");
INSERT INTO bccl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Cha do janéná, ke hórigá jenteray sará dánay droshagá bant, yakké baraga bit o domi hamódá pasht géjaga bit. ");
INSERT INTO bccl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Do mard ke dhagáráni sará bit, yakké baraga bit o domi hamódá pasht géjaga bit.” ");
INSERT INTO bccl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jostesh kort: “Oo Hodáwand! Kojá chosha bit?” Passawi dát: “Har jáh ke jóné kapit, ódá gittó o dhundhwárén morg moccha bant.” ");
INSERT INTO bccl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Issáyá pa moridán mesálé áwort tán áyán sarkech bedant o pésh bedárit ke harwahd dwá bekanant o hechbar delprósh o náomét mabant. ");
INSERT INTO bccl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Gwashti: “Shahréá, yak kázié hastat ke áiá na cha Hodáyá torset o na mardománi parwáhia kort. ");
INSERT INTO bccl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Hamá shahrá, janózámé ham hastat ke harwahd káziay kerrá átk o mennatwár at ke áiay hakká cha daynkárá begipt. ");
INSERT INTO bccl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Tán lahtén wahdá, káziá janózámay peryátay némagá hech delgósha nakort, bale randá delá hayáli kort ke ‘rást ent, maná na Hodáay tors ent o na mardománi parwáh. ");
INSERT INTO bccl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Bale é janózám maná delsyáh kanagá ent. Paméshká gehter ent eshiay hakká begerán o bedayán. Chosh mabit gón wati har róchigén rawag o áyagá maná géshter delsyáh bekant.’” ");
INSERT INTO bccl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Gorhá Hodáwandén Issáyá gwasht: “Beshkonét é náhakkén kázi ché gwashit? ");
INSERT INTO bccl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nun bárén Hodá gón wati gechén kortagénán, ke shap o róch gón áiá pa wati hakká peryáta kanant, hakka nakant? Pa áyáni hakrasiá déra kant? ");
INSERT INTO bccl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Shomárá gwashán ke zutt áyáni hakká dant. Bale á wahdi ke Ensánay Chokka kayt, bárén setk o báwar é zeminay sará pashta kapit ke á begendit?” ");
INSERT INTO bccl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Issáyá hamá mardománi bárawá mesálé áwort ke watá nék o pahrézkára zánant o é dega mardomán éra janant. ");
INSERT INTO bccl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Do mardom pa dwá kanagá mazanén parasteshgáhá shot ke cha áyán yakké Parisié at o domi máliátgiré at. ");
INSERT INTO bccl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi óshtát o pa wati jendá dwái kort o gwashti: ‘Oo Hodá! Tai mennatwár án ke man é dega mardománi dhawlá dozz o radkár o zenahkáré naán o na é máliátgiray dhawlá án.’ ");
INSERT INTO bccl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Man haptagé do róch, róchaga dárán o wati sajjahén málay dahyakká dayán. ");
INSERT INTO bccl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bale hamá máliátgir dur óshtátagat o ásmáni cháret ham nakort. Dasti wati sénagá jat o peryát kanáná gwashti: ‘Oo Hodá! Tará mani sará bazzag bát ke gonahkáré án.’ ");
INSERT INTO bccl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Nun man shomárá gwashán: Parisi na, bale hamá máliátgir nék o pahrézkár but o lógá shot, chiá ke harkas watá mazana zánt o lékit, kamsharapa bit o harkas watá jahl o érdasta mannit, washnám o sharapdára bit.” ");
INSERT INTO bccl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Mardomán wati nonnokén chokk ham Issáay gwará áwortant ke dastesh sará per bemoshit. Wahdé moridán chosh dist, mardomesh neherr o hakkal dátant. ");
INSERT INTO bccl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Bale Issáyá chokk wati kerrá lóthetant o gwashti: “Chokkán bellét ke mani kerrá byáyant, áyáni démá madárét, chiá ke Hodáay bádsháhi anchén mardománig ent. ");
INSERT INTO bccl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Shomárá rásténa gwashán, á ke Hodáay bádsháhiá chokkáni paymá mamannit, hechbar ódá pád ér korta nakant.” ");
INSERT INTO bccl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cha sardárán yakkéá jost kort: “Oo nékén ostád! Man chón bekanán ke namiránén zenday wáhond bebán?” ");
INSERT INTO bccl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Issáyá gwasht: “Taw maná ‘nékén’ pa ché gwashay? Abéd cha Hodáyá kass nék naent. ");
INSERT INTO bccl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Taw Hodáay hokmána zánay: ‘Zená makan, hón makan, dozzi makan, drógén sháhedi maday, wati pet o mátá ezzat beday.’” ");
INSERT INTO bccl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Áiá gwasht: “Man cha kasániá é sajjahén hokm barjáh dáshtagant.” ");
INSERT INTO bccl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wahdé Issáyá áiay passaw eshkot, gwashti: “Tará angat yak káré kanagi ent, wati sajjahén mál o hastiá bahá kan o zarrán garib o nézgárén mardománi sará bahr kan, é paymá tará ásmáni ganjé rasit. Gorhá byá o mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Wahdé á mardá é passaw eshkot, báz delgir o gamig but chiá ke á mazanén máldáré at. ");
INSERT INTO bccl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Issáyá á mard cháret o gwashti: “Pa azgár o máldárén mardomán Hodáay bádsháhiá pád ér kanag sakk grán ent. ");
INSERT INTO bccl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Haw! Cha suchenay domká oshteray gwazag wa báz grán ent, bale Hodáay bádsháhiá, zardárén mardomay pád ér kanag, angat gránter ent.” ");
INSERT INTO bccl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Hamá ke é habará eshkonagá atant, jostesh kort: “Gorhá kay rakketa kant?” ");
INSERT INTO bccl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Issáyá passaw dát: “Pa ensáná nabuteni ent, bale Hodáay dastá har chizz buta kant.” ");
INSERT INTO bccl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Petrosá gwasht: “Má wati har chizz yalah dátag o tai randgiriá kanagá én.” ");
INSERT INTO bccl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Issáyá gwasht: “Haw! Báwar kanét, harkasá ke pa Hodáay bádsháhiá wati jan o chokk, brát, mát o pet yá lóg o jágah yalah dátagant, ");
INSERT INTO bccl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","hamé jaháná é chizzáni badalá áiá báz géshtera rasit o á dega jaháná, abadmánén zenday wáhonda bit.” ");
INSERT INTO bccl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Padá Issáyá wati dwázdahén kásed yak kerré bortant o gwashti: “Nun má Urshalimá rawagá én, har chizzé ke nabián Ensánay Chokkay bárawá nebeshtag, á sajjahén ódá sarjama bant. ");
INSERT INTO bccl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Áiá darkawmén mardománi dastá dayant o hamá darkawm, kalágia gerant, béezzatia kanant o sar o démá tohia janant, ");
INSERT INTO bccl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","shallák o hayzaránia janant o koshanti. Bale saymi róchá, á padá zendaga bit o jáha jant.” ");
INSERT INTO bccl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Áiay morid cha é habarán yakkéá ham sarpad nabutant. Issáay é habaráni máná cha áyáni zántá chér at o áyán sarkech nawárt ke Issá ché gwashagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wahdé Issá Ariháay shahray nazziká raset, kóré disti ke ráhay sará neshtag o pendhagá at. ");
INSERT INTO bccl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wahdé kórá mahluk o mocchiay tawár eshkot, josti kort: “Ché bayagá ent?” ");
INSERT INTO bccl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Hálesh dát: “Issá Náseri gwazagá ent.” ");
INSERT INTO bccl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Gorhá áiá kukkár kort: “Issá, oo Dáud bádsháhay chokk! Tará mani sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Á ke cha sajjahénán pésar o péshgám atant, kóresh hakkal kort o gwashtesh: “Bass kan, bétawár bay!” Bale áiá géshter kukkár kort: “Oo Dáud bádsháhay chokk! Tará mani sará bazzag bát.” ");
INSERT INTO bccl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Issá óshtát o hokmi kort: “Á mardá byárét.” Wahdé nazzik átk, Issáyá jost kort: ");
INSERT INTO bccl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Taw cha man ché lóthay? Pa taw ché bekanán?” Áiá passaw dát: “Oo Hodáwand! Mana lóthán biná bebán.” ");
INSERT INTO bccl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Issáyá gwasht: “Biná bebay! Tai imáná tará dráh kort.” ");
INSERT INTO bccl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Hamá damáná kór biná but, Hodáyá sepat o saná kanán, Issáay hamráhiá rahádag but. Mardomán ke chosh dist, áyán ham Hodáay shogr gept. ");
INSERT INTO bccl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Issá Ariháyá átk o cha shahray nyámá gwazagá at. ");
INSERT INTO bccl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ódá Zakká námén sér o azgárén mardé hastat ke máliátgiráni kamásh at. ");
INSERT INTO bccl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Áiá lóthet bechárit Issá chónéné, bale mardománi mocchi mérhi báz at o áiay jend pathakk o lokkaddé at. Paméshká disti nakort. ");
INSERT INTO bccl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gorhá pa drekké démá shot o mazanén drachkéay sará sar kapt tán áiá begendit, chiá ke Issá cha hamé ráhá gwazagá at. ");
INSERT INTO bccl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wahdé Issá hamá jágahá raset, borzád cháret o gwashti: “Oo Zakká! Zutt jahlá ér kap, ke maróchi man tai mehmán án.” ");
INSERT INTO bccl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Á, eshtápi cha drachká ér kapt o Issái pa gal o shádehi wati lógá wasshátk kort. ");
INSERT INTO bccl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Wahdé mardomán é dist, watmánwatá norondhán gwashtesh: “Issá gonahkárén mardéay lógá mehmán butag.” ");
INSERT INTO bccl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Bale Zakká pád átk, óshtát o gón Hodáwandén Issáyá gwashti: “Oo Hodáwand! Wati sajjahén mál o maddhiay némá pa nézgár o garibén mardomán bahr o bánga kanán o agan man kaséay mál pa náhakk poshtá kasshetag o bortag, áyáni badalá chár sari géshtera dayán.” ");
INSERT INTO bccl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Issáyá gón áiá gwasht: “Maróchi é lógá, pahelli o rakkag sar butag, chiá ke é mard ham cha Ebráhémay nasl o padréchá ent. ");
INSERT INTO bccl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Haw! Ensánay Chokk pa gonahkár o gárénáni shóház o rakkénagá átkag.” ");
INSERT INTO bccl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Hamá wahdá ke mardom Issáay habarán gósh dáragá atant, Issáyá gésh kanán mesálé áwort. Chiá ke á Urshalimay nazziká rasetagat o mardománi gomán esh at ke Hodáay bádsháhi hamá wahdá paddara bit. ");
INSERT INTO bccl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Gwashti: “Yak baré, sardárzádagé durén molkéá shot tánke pa bádsháhiá berasit o padá wati dhéh o dhagárá per betarrit. ");
INSERT INTO bccl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gorhá, dah hezmatkári wati kerrá lóthet o har yakkéá yak ashrapié dát o gwashtanti: ‘Tánke man wati sapará janán o padá káyán, shomá gón é zarrán sawdágeri bekanét.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bale hamá molkay mardomán cha áiá naprata kort. Áiay rawagá rand, kásed o kolawesh ráh dát ke ‘má nalóthén é mard, may sará bádsháhi bekant.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Bale áiá bádsháhi raset o wati molká per tarret o átk. Gorhá hokmi kort hamá dahén hezmatkárán ke zarri dátagatant byárant, tán bezánt áyán chinchok nap o sutt katthetag. ");
INSERT INTO bccl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Awali hezmatkár átk o gwashti: ‘Oo wájah! Cha tai yakkén ashrapiá, man dah ashrapi katthetag.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Bádsháhá gwasht: ‘Shábásh, oo sharrén golám! Nun paméshká ke taw gón kammén bonmálá tachk o rást butagay, man tará wati molkay dah shahray hákema kanán.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Domi átk o gwashti: ‘Oo wájah! Man cha tai yakkén ashrapiá, panch katthetag.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Bádsháhá gwasht: ‘Man tará wati molkay panch shahray hákemiá dayán.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Dega hezmatkáré átk o gwashti: ‘Oo wájah! Esh ent tai dátagén ashrapi ke man dazmáléá bastag o ér kortagat. ");
INSERT INTO bccl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Chiá ke maná cha taw torsetag, taw trondén mardé ay o hamá ke taw ér nakortagant, hamá chizzáni payradá janay o watiga kanay o nakeshtagéna ronay.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Bádsháhá gwasht: ‘Oo békárén golám! Man tará cha tai jenday habarán mayáriga kanán, taw zánt man trondén mardomé án, ér nakortagén chizzán watiga kanán o nakeshtagéna ronán. ");
INSERT INTO bccl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Gorhá taw chiá mani dátagén zarr, byáji o bápáriéay kerrá ér nakort ke man per tarragá rand, wati zarr gón sutt begepténant.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Gorhá bádsháhá gón wati diwánay mardomán gwasht: ‘Ashrapiá cha eshiá pach gerét o hamáiá bedayét ke áiay kerrá dah ashrapi ant.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Áyán gwasht: ‘Wájah! Gón áiá pésará dah ashrapi hast.’ ");
INSERT INTO bccl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Bádsháhá gwasht: ‘Shomárá gwashán, harkasá ke chizzé hast, áiá géshter dayaga bit, bale harkasá ke nést, harché ke hasti ham pach geraga bit. ");
INSERT INTO bccl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bale hamá ke mani dozhmen ant o mani bádsháhiá nalóthant, áyán mani kerrá byárét o mani démá bekoshét.’” ");
INSERT INTO bccl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Cha é habarán o rand, Issá pésar o péshgám dém pa Urshalimá rawagá at. ");
INSERT INTO bccl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wahdé Zaytun námkaptén kóhay sará, Bayt-Páji o Bayt-Anyáay métagáni nazziká raset, wati do moridi pésará dém dát o ");
INSERT INTO bccl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","gwashtanti: “Démi métagá berawét o anchosh ke shomá ódá rasét, korragén haré gendét ke bastag o taningah kasé áiá swár nabutag. Áiá bójét o edá byárét. ");
INSERT INTO bccl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Agan kaséá cha shomá jost kort ‘Chiá eshiá bójagá ét,’ begwashét: ‘Wájahá pakár ent.’” ");
INSERT INTO bccl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Morid shotant o hamá dhawlá ke Issáyá gwashtagat, hamá paymá distesh. ");
INSERT INTO bccl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Anchosh ke korragay bójagá atant, korragay hodábondán cha áyán jost kort: “Shomá chiá é korragá bójagá ét?” ");
INSERT INTO bccl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Moridán passaw dát: “Wájahá pakár ent.” ");
INSERT INTO bccl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Áyán korrag Issáay kerrá áwort, wati shál o cháderesh korragay poshtá ér kortant o Issáesh swár kort. ");
INSERT INTO bccl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Anchosh ke Issá démá rawán at, mardomán wati shál o cháder ráhay sará chérgéján kortant. ");
INSERT INTO bccl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wahdé Issá Zaytunay kóhay érkapay nazziká raset, áiay moridáni mocchiá pa é sajjahén ajekkái o mójezahán ke áyán distagatant, pa gal o shádehi o gón borzén tawáré, Hodá satá kort o gwasht: ");
INSERT INTO bccl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Mobárak bát, hamá bádsháhá ke pa Hodáwanday námá kayt! Sohl o ásudagi mán ásmáná o shán o shawkat borzén arshá.” ");
INSERT INTO bccl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Cha mardománi nyámá, lahtén Parisiá gón Issáyá gwasht: “Oo ostád! Wati moridán neherr o hakkal kan ke chosh magwashant!” ");
INSERT INTO bccl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Issáyá darráént: “Man shomárá gwashán, agan é bétawár bebant, seng o dhók kukkára kanant.” ");
INSERT INTO bccl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wahdé Issá Urshalimá nazzik but o shahri dist, gréti o ");
INSERT INTO bccl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","gwashti: “Drégatá taw, haw, hamé taw, maróchi bezántén ke kojám chizz, pa taw sohl o ásudagi áworta kant. Bale bazhn o apsóz ke nun á cha tai chammá chér o andém ent. ");
INSERT INTO bccl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pa taw anchén rócha káyant ke dozhmen tai chapp o chágerdá sangara bandant o tai chárén némagán angerra kanant o tai perh o chágerdá tanka tarrénant. ");
INSERT INTO bccl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Tará o tai chokkán, dhagárá chagala dayant o gón hák o hóná hór o hawára kanant o sengé pa sengéay sará ham pashta nagéjant, chiá ke taw wati Hodáay áyagay wahd o sáhat, pajjáh nayáwort.” ");
INSERT INTO bccl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Cha eshiá rand, Issá mazanén parasteshgáhay péshjáhá shot o sawdágeráni dhanná dar kanagá goláésh but. ");
INSERT INTO bccl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Gwashti: “Hodáay Ketábá nebisag butag: Mani lóg, dwá o parasteshay jágah bebit, bale shomá dozzbázáré kortag.” ");
INSERT INTO bccl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Áiá har róch mazanén parasteshgáhá tálima dát. Mazanén dini péshwá, Sharyatay zánóger o kawmay kamásh, áiay koshagay johdá atant, ");
INSERT INTO bccl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bale pa wati é maksadá, hech ráhé dar gétk nakortesh, chiá ke áiay har habar mardománi delá neshtagat. ");
INSERT INTO bccl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yak róché ke Issá mazanén parasteshgáhay péshjáhá mardomán tálim o wasshén mestág dayagá at, mazanén dini péshwá o Sharyatay zánóger gón kawmay kamáshán áiay kerrá átkant o ");
INSERT INTO bccl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","gwashtesh: “Márá begwash ke taw gón kojám hakk o ehtiárá é kárána kanay? Kayá tará é káráni ehtiár dátag?” ");
INSERT INTO bccl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Issáyá passaw dát: “Maná ham cha shomá yak josté hast. Begwashét, ");
INSERT INTO bccl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Yahyáyá, pákshódi dayagay ehtiár cha ásmáná rasetagat yá cha ensánay némagá?” ");
INSERT INTO bccl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Áyán watmánwatá shawr o saláh kort o gwashtesh: “Agan begwashén ‘cha ásmáná at,’ gwashit: ‘Pa ché imánó nayáwort?’ ");
INSERT INTO bccl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Oo agan begwashén ke ‘mardomi káré butag,’ gorhá mardom márá sengsára kanant, chiá ke áyáni setk o báwar hamesh ent ke Yahyá nabié butag.” ");
INSERT INTO bccl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Paméshká passawesh dát: “Má nazánén cha kojá at.” ");
INSERT INTO bccl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Issáyá gwasht: “Gorhá man ham shomárá nagwashán ke gón kojám hakk o ehtiárá é kárána kanán.” ");
INSERT INTO bccl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Randá, Issáyá pa mardomán é mesál áwort: “Mardéá anguri bágé addh kort o pa konandahkári o zamán, lahtén bágpánay dastá dát o wat drájén saparéá shot. ");
INSERT INTO bccl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wahdé anguray mósom but, bágay hodábondá pa wati bahray geragá, hezmatkáré ráh dát, bale zamánzurén bágpánán á hezmatkár latth o kotth kort o gón hórk o háligén dastán per tarrént. ");
INSERT INTO bccl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Bágay hodábondá, padá dega hezmatkáré dém dát, bale bágpánán á ham jat o béezzat kort o gón hórk o háligén dastán per tarrént. ");
INSERT INTO bccl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Gorhá saymi randá, dega hezmatkáré ráhi dát, bale áyán á ham jat o thappig kort o dhanná gallént. ");
INSERT INTO bccl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Nun bágay hodábondá wati delá pegr kort ke ‘chón bekanán?’ É randá, wati dóstén chokká ráha dayán, balkén áiay ruá bedárant. ");
INSERT INTO bccl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bale wahdé bágpánán áiay chokk dist, watmánwatá shawr kort o gwashtesh: ‘Bágay mirás barók o poshtpad hamesh ent, eshiá ham bekoshén tán bág may mirás bebit.’ ");
INSERT INTO bccl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gorhá cha bágá dhann bort o koshtesh. Nun shomay gománá, bágay hodábond gón é bágpánán ché kant? ");
INSERT INTO bccl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Á kayt, é bágpánána koshit o bágá dega bágpánáni dastá dant.” Wahdé mardomán Issáay é habar eshkot, gwashtesh: “Chosh mabát!” ");
INSERT INTO bccl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Issáyá áyáni némagá cháret o gwashti: “Gorhá, á nebeshtahay máná chi ent ke gwashit: ‘Hamá seng ke bánbandén ostáyán pasond nakort o nazort, hamá seng bonheshtbut.’ ");
INSERT INTO bccl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Harkas ke á sengay sará bekapit, thokkor thokkora bit o kasé ke seng áiay sará kapit, hurta bit.” ");
INSERT INTO bccl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sharyatay zánóger o mazanén dini péshwáyán zánt ke Issáyá é mesál hamáyáni bárawá áwortag. Paméshká, shawresh kort hamá damáná Issáyá begerant, bale cha mardomána torsetesh. ");
INSERT INTO bccl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Gorhá Issáesh chammáni chérá kort, wati chárig o jásusesh rawán dátant tán watá Issáay démá tachk o pahrézkárén mardom pésh bedárant. Áyáni maksad esh at ke Issáyá cha áiay jenday habarán mán begisshénant o Rumay wáliay dastá bedayant. ");
INSERT INTO bccl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Áyán jost kort: “Oo ostád! Má zánén taw harché ke gwashay, har tálimé ke dayay, á sajjahén rást ant o hechkaséay némagá nageray o pa rásti Hodáay ráhá sója dayay. ");
INSERT INTO bccl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nun márá begwash, bárén Rumay bádsháh Kaysará song o máliát dayag rawá ent yá na?” ");
INSERT INTO bccl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bale Issáyá áyáni é repk o mandr zánt o gwashti: ");
INSERT INTO bccl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Maná yak dináré pésh bedárét, eshiay sará kai nám o naksh per ent?” Áyán passaw dát: “Kaysaray.” ");
INSERT INTO bccl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Issáyá gwasht: “Gorhá Kaysaraygá Kaysará bedayét o Hodáaygá Hodáyá bedayét.” ");
INSERT INTO bccl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","É dhawlá, áyán mardománi démá Issá cha áiay jenday habarán dámá dawr dát nakort o cha áiay passawán bah mant o bétawár butant. ");
INSERT INTO bccl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Randá, lahtén Saduki, ke áheratay namannók ant, Issáay kerrá átk o ");
INSERT INTO bccl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","jostesh kort: “Oo ostád! Mussáyá pa má nebeshtag: Agan kaséay sur kortagén bráté bé chokká bemerit o janózámi zendag bebit, gorhá áiay brát báyad ent gón á janózámá sur bekant tánke chokk o rand o ráhé pa wati brátá bellit. ");
INSERT INTO bccl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nun hapt brát atant, awali brátá jané gept, chokki nabut o mort, ");
INSERT INTO bccl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","domi brátá o ");
INSERT INTO bccl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","padá saymi brátá gón á janéná sur kort o á ham bé chokká mortant. Hamé paymá haptén brátán gón hamá janéná sur kort o bé pad o rand cha donyáyá shotant. ");
INSERT INTO bccl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Godhsará, á janén ham mort. ");
INSERT INTO bccl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nun taw begwash, áheratay róchá, é janén, kojám brátayga bit, chiá ke har haptén brátán bárig bárigá gón áiá sur kortagat.” ");
INSERT INTO bccl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Issáyá passaw dát: “Mardom, é jaháná sáng o sura kanant, ");
INSERT INTO bccl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","bale hamá mardom ke namiránén zendá karzant o áheratay láhek ant, á na sura kanant o na sur dayaga bant. ");
INSERT INTO bccl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Á hechbar padá namerant o préshtagáni dhawlá ant, Hodáay chokk ant, chiá ke namiránén zenday chokk ant. ");
INSERT INTO bccl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bale mordagáni zendag bayagay habaray rásti, Mussáyá mán bon geptagén dhólokay kessahá pésh dáshtag. Ódá Mussá Hodáwandén Hodáyá, Ebráhémay Hodá, Eshákay Hodá o Ákubay Hodá gwashit. ");
INSERT INTO bccl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Á mordagáni Hodá naent, zendagénáni Hodá ent, chiá ke áiay gwará, sajjahén zendag ant.” ");
INSERT INTO bccl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cha Sharyatay zánógerán lahténá gwasht: “Oo ostád, taw sharr gwasht.” ");
INSERT INTO bccl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Cha ed o rand, hechkasá del nakort cha áiá dega josté begipt. ");
INSERT INTO bccl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Issáyá gón áyán gwasht: “É chónén habaré ke gwashant: ‘Masih, Dáud bádsháhay chokk ent?’ ");
INSERT INTO bccl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Chiá ke Dáud wat Zaburay ketábá gwashit: Hodáwandá gón mani Hodáwandágwasht mani rástén némagá benend ");
INSERT INTO bccl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","tán hamá wahdá ke tai dozhmenán tai pádáni chéray padag o chárchóbahé bekanán. ");
INSERT INTO bccl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nun agan Dáud, Masihá wati Hodáwanda gwashit, gorhá Masih chón áiay chokk buta kant?” ");
INSERT INTO bccl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Hamé wahdá ke sajjahén mardom gósh dáragá atant, Issáyá gón moridán gwasht: ");
INSERT INTO bccl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Cha Sharyatay zánógerán hozzhár bét, ke áyán drájén jámag o kabáh gwará kanag dósta bit o bázáráni tarr o gardá cha mardomán wasshátk o drahbáta lóthant. Kanisaháni sharterén jáhán gechéna kanant o mehmánián, awali reday nendagesh pasond ent. ");
INSERT INTO bccl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Janózámáni lógán gón málwáriá barant o pa pésh dáragá wati dwá o sanáyán drájkassha kanant. Eshán sakterén sezá o padmozza rasit.” ");
INSERT INTO bccl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Issáyá sar borz kort o disti ke lahtén azgár o hastómand, wati hayráti zarrán mazanén parasteshgáhay pétiá mán kanagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Áiá, yak nézgárén janózámé ham dist ke pétiay tahá do paysahi dawr dát. ");
INSERT INTO bccl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nun gwashti: “Shomárá rásténa gwashán, é béwasén janózámá cha sajjahénán géshter mán kort. ");
INSERT INTO bccl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Chiá ke á degarán cha wati géshén málá chizzoké dát, bale é janózámá, gón wati nézgári o garibiá, harché ke áiá hastat dáti, bezán wati sajjahén bonmál.” ");
INSERT INTO bccl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Lahtén mardom mazanén parasteshgáhay bárawá habar kanag o gwashagá at ke “é gón chónén dhawldárén seng o gránkimmatén hayrát o thékián nakshband kanag butag.” ");
INSERT INTO bccl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Á wahdi Issáyá gwasht: “Cha eshán ke shomá maróchi gendagá ét, róché kayt ke yak sengé ham domi sengay sará namánit. Sajjahénána próshant o karójant.” ");
INSERT INTO bccl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jostesh gept: “Oo ostád! Bárén, é prosht o prósh kadéna bit o eshiay nazzik bayagay nesháni chi ent?” ");
INSERT INTO bccl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Issáyá gwasht: “Hozzhár bét, kasé shomárá gomráh makant. Chiá ke bázéné pa mani námá kayt o gwashit: ‘Man hamá án’ o ‘Wahd átkag o nazzik ent,’ bale shomá áyáni habará gón makapét. ");
INSERT INTO bccl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wahdé shomá jang o áshópay kukkárá eshkonét, matorsét o paréshán mabét. Chiá ke awalá báyad ent é dhawlá bebit, bale halásiay wahd hamá damáná pa sara narasit.” ");
INSERT INTO bccl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Gorhá gón áyán gwashti: “Yak kawmé dega kawméay sará o yak hokumaté dega hokumatéay sará páda kayt. ");
INSERT INTO bccl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Mazanén zeminchandha bit o bázén jágahán dhokkál o wabá kapit. Cha ásmáná torsnákén sargwast o ajabbatén nesháni paddara bit. ");
INSERT INTO bccl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Bale cha é sajjahénán o pésar, shomárá gerant o pa shomá jawr o ázára kanant, kanisah o jélána barant o bandiga kanant. Pa mani námay sawabá bádsháh o hákemáni démá barant o pésha kanant. ");
INSERT INTO bccl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Gorhá shomárá pa gwáhi dayagá sharrén móhé rasit. ");
INSERT INTO bccl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Gón wat shawr kanét ke pa wati démpániá, cha wahdá pésar paréshán mabét. ");
INSERT INTO bccl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Chiá ke man shomárá anchén habaráni zántkáriá dayán ke hech dozhmené shomay démá maóshtit o shomay habarán prósht makant. ");
INSERT INTO bccl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tantaná shomay mát o pet, brát o syád o dóst, shomárá geráénant o lahténá kóshárénant. ");
INSERT INTO bccl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Sajjahén mardom pa mani námay sawabá cha shomá naprata kanant, ");
INSERT INTO bccl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","bale cha shomay sará yak mudé ham kamma nabit. ");
INSERT INTO bccl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Agan pa deléri sakkián besaggét, wati sáhá rakkénét. ");
INSERT INTO bccl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Wahdé shomá gendét ke Urshalim, pawj o lashkará chapp o chágerdá angerr kortag, gorhá bezánét ke eshiay wayrániay wahd nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Á wahdá hamá ke Yahudiahá ant, kóhán betachant, á ke Urshalimá ant dhanná dar bekapant o á ke cha shahrá dhann ant shahrá marawant. ");
INSERT INTO bccl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Chiá ke á wahd sezáay wahda bit o sajjahén nebeshtánkáni habar purah o sarjama bant. ");
INSERT INTO bccl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Á róchán, apsóz pa lápporr o chokmátén janénán, chiá ke molkay sará báz sakki o janjála kayt o é kawmay sará Hodáay kahra kapit. ");
INSERT INTO bccl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Dozhmen áyán zahmáni dapá dayant o bázénéá bandig o sajjahén donyáay tahá darándhéha kanant. Urshalim, darkawmáni pádáni lagatmála bit, tán á wahdá ke darkawmáni wahd o báriga kotthit o halása bit. ");
INSERT INTO bccl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Cha róch o máh o estárán ajabbatén nesháni paddara bant o donyáay sajjahén kawm cha daryáay chawl o mawjáni trondén tawárá paréshán o sargardána bant. ");
INSERT INTO bccl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Mardom, donyáay sará áyókén janjál o sakki o sóriáni tors o bimmá béhósha bant, chiá ke ásmánay zór o wák larzénaga bant. ");
INSERT INTO bccl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Á wahdá, mardom Ensánay Chokká gendant, ke gón mazanén wák o twán o shán o shawkaté cha jambaréay nyámá kayt o paddara bit. ");
INSERT INTO bccl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wahdé é jáwara káyant o rasant, gorhá wati sará borz kanét o tachkátachk bóshtét ke shomay rakkénagay wahd nazzik ent.” ");
INSERT INTO bccl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Issáyá pa áyán é mesál ham dát ke “enjir o é dega drachkán bechárét, ");
INSERT INTO bccl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","anchosh ke tákesh jat, wata zánét ke nun garmágay mósom nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Hamé paymá, wahdé é chizzána gendét, wata zánét ke Hodáay bádsháhi nazzik ent. ");
INSERT INTO bccl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Shomárá rásténa gwashán, tán é sajjahén jáwar mayáyant, é nasl o padréch halása nabit. ");
INSERT INTO bccl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Zemin o ásmán gára bant, bale mani habar hechbar gár o zyána nabant. ");
INSERT INTO bccl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Hozzhár bét, chosh mabit ke shomay del pa neshah o malárán berawt o zenday pegr o andóh shomay delá gránbár bekant o á róch anágat shomay gotthá lóp bebit. ");
INSERT INTO bccl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Chiá ke á róch pa donyáay sajjahén mardomána kayt. ");
INSERT INTO bccl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Paméshká harwahd hozzhár bét o dwá bekanét, tán shomárá á róchá ke chosha bit o é jáwar pa sara rasant dar rawagay wák bebit o Ensánay Chokkay bárgáhá óshtát bekanét.” ");
INSERT INTO bccl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Issáyá har róch, mazanén parasteshgáhá sabak o tálima dát. Har shap cha shahrá dhann, Zaytun námkaptén kóhay sará shot o wati shapi sabáha kort. ");
INSERT INTO bccl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Mardom ham har sabáhá máhallah, pa áiay habaráni gósh dáragá, mazanén parasteshgáhá átkant. ");
INSERT INTO bccl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Béhomirén nánay aid, hamá ke Sargwaz gwashaga bit nazzik at. ");
INSERT INTO bccl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mazanén dini péshwá o Sharyatay zánóger pa Issáay kóshárénagá, ráh o nimmóné shóház kanagá atant, bale cha mardomána torsetesh. ");
INSERT INTO bccl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Hamá wahdá, Yahudá ke Eskaryuti nám kaptagat o wat cha Issáay dwázdahén moridán yakké at, Shaytán áiay póstá potert. ");
INSERT INTO bccl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahudá, mazanén dini péshwá o mazanén parasteshgáhay negahpánén sepáhigáni masteráni kerrá shot o gón áyán gend o nendi kort ke che paymá Issáyá bedróhit o áyáni dastá bedant. ");
INSERT INTO bccl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Á báz wassh butant o shawresh kort ke áiá chizzé zarr bedayant. ");
INSERT INTO bccl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yahudáyá mannet o nun gwam o gégén wahd o móhéay shóházá at ke cha mardománi mocchiá dur, Issáyá áyáni dastá bedant. ");
INSERT INTO bccl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gorhá, béhomirén nánay aiday hamá róch átk ke gwarándhá korbániga kanant. ");
INSERT INTO bccl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Issáyá Petros o Yuhanná dém dátant o gwashti: “Berawét Sargwazay aiday shámay tayáriá bekanét ke bwarén.” ");
INSERT INTO bccl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Áyán jost kort: “Taw ché lóthay, má é tayáriá kojá bekanén?” ");
INSERT INTO bccl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Passawi dát: “Shahrá ke rasét, mardéá gendét ke ápi kunzagé gón enti, áiay randá hamá lógá berawét ke á rawt. ");
INSERT INTO bccl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Lógay wáhondá begwashét: ‘Ostád josta kant: “Mehmánhánah kojá ent ke man gón wati moridán Sargwazay shámá hamódá bwarán?”’ ");
INSERT INTO bccl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Á mard, shomárá wati lógay sarborá, práhén bán o diwánjáhé pésha dárit ke ódá har chizz hast, shámay tayáriá hamódá bekanét.” ");
INSERT INTO bccl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Á shotant. Ódá, áyán har chizz hamá paymá dist ke Issáyá gwashtagat. Sargwazay shámesh hamódá tayár kort. ");
INSERT INTO bccl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Hamá sáhat ke raset, Issá gón moridán parzónagay sará nesht. ");
INSERT INTO bccl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Gón áyán gwashti: “Mani masterén armán hamé butag ke gránén sakki o sóriáni saggagá pésar, é Sargwazay shámá gón shomá hórigá bwarán. ");
INSERT INTO bccl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Shomárá gwashán, tán Hodáay bádsháhi barjáh dárag mabit, dega baré é shámá nawarán.” ");
INSERT INTO bccl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Gorhá, jámé chesti kort, Hodáay shogri gept o gwashti: “É jámá bezurét, wati nyámá bahr kanét. ");
INSERT INTO bccl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Shomárá gwashán ke cha ed o rand, tán Hodáay bádsháhi mayayt o marasit, man anguray dahl o samará nanóshán.” ");
INSERT INTO bccl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nagani ham zort, Hodáay shogri gept, chondh chondhi kort, moridáná dát o gwashti: “É mani jesm ent ke pa shomá korbániga bit, é rasmá pa mani yát o yátmáná barjáh bedárét.” ");
INSERT INTO bccl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Hamé dhawlá, cha waragá rand, jámé zort o gwashti: “É jám, mani nókén ahd o karáray hón ent ke pa shomaygi réchaga bit. ");
INSERT INTO bccl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bale, hamá ke maná dróhit, áiay dast gón mani dastá yakkén parzónagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Chiá ke hamá dhawlá ke péshá shawr borrag butag, Ensánay Chokka rawt, bale bazhn o apsóz pa hamá mardomá ke áiá dróhit.” ");
INSERT INTO bccl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Á wahdi, morid yakdomiá jost kanagá laggetant: “Bárén, cha má kay choshén káré kant?” ");
INSERT INTO bccl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Moridáni nyámá arh o dáwáé pád átk ke “bárén, may nyámá sajjahénáni master o kamásh kay ent?” ");
INSERT INTO bccl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Issáyá gón áyán gwasht: “Darkawmáni bádsháh, wati mardománi sará gón zóráki wájahia kanant o áyáni hákemáni maksad o morád esh ent ke mardom áyán hayr o barkat dayók bezánant. ");
INSERT INTO bccl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bale shomá chosh makanét, bellét ke shomay masterén, kasterénay dhawlá bebit o shomay hákem, hezmatkáray dhawlá. ");
INSERT INTO bccl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Bárén, kay master ent? Hamá ke neshtag o waragá ent, yá hamá ke hezmat kanagá ent? Albat, hamá ke neshtag o waragá ent. Bale man shomay nyámá, hezmatkáréay dhawlá án. ");
INSERT INTO bccl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Shomá hamá ét ke mani ázmáesh o chakkásán, gón man hamráh o hamkópag butagét. ");
INSERT INTO bccl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Hamá dhawlá ke Petá maná bádsháhi bakshetag, man ham áiá shomárá bakshán ");
INSERT INTO bccl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","tán mani bádsháhiay tahá cha mani parzónagá bwarét, benóshét, tahtáni sará benendét o Bani Esráilay dwázdahén kabilaháni dádrasiá bekanét. ");
INSERT INTO bccl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Shamun, oo Shamun! Shaytáná mókal o ejázat lóthet ke shomárá gandomay dhawlá kamak bekant o begéchit. ");
INSERT INTO bccl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bale man pa taw dwá kort tán tai báwar o imán zawál mabit. Gorhá, wahdé per tarret o padá mani ráhá átkay, wati brátáni dastá beger o delbaddhi beday.” ");
INSERT INTO bccl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bale Petrosá passaw tarrént: “Oo Hodáwand! Man gón taw hórigá pa kayd o band o marká ham tayár án.” ");
INSERT INTO bccl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Issáyá gwasht: “Oo Petros! Man tará gwashán ke maróchi taw cha korósbángá pésar, mani pajjáh áragá say randá enkára kanay o namannay.” ");
INSERT INTO bccl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Randá cha áyán josti kort: “Bárén, hamá wahdá ke man shomárá bé zarturag o pélek, bé chawath o swásá dém dát, shomá pa chizzé wázmand o mohtáj butét?” Áyán passaw dát: “Na, pa hech chizzá.” ");
INSERT INTO bccl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Gorhá gwashti: “Bale nun cha shomá agan kaséay kerrá zarturag o pélek hast, gón wat bezurit o áiay kerrá ke zahm nést, wati kabáhá bahá bekant o zahmé bahá begipt, ");
INSERT INTO bccl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","chiá ke é nebeshtah mani bárawá, báyad ent purah o sarjam bebit ke gwashit: Á gón gonahkárán hesáb kanag but. Haw! Á chizz ke mani bárawá nebisag butag nun sarjam bayagi ent.” ");
INSERT INTO bccl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Moridán gwasht: “Oo Hodáwand! Bechár, márá do zahm gón ent.” Gwashti: “Bass ant.” ");
INSERT INTO bccl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Randá, Issá dar átk o anchosh ke áiay hél o ádat at, dém pa Zaytunay kóhá shot. Morid ham áiay randá shotant. ");
INSERT INTO bccl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ódá ke sar but, gwashti: “Dwá kanét ke ázmáesh o chakkásá makapét.” ");
INSERT INTO bccl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Randá, yak dhókéay chagaljáhay kesásá, cha moridán dur but, kóndháni sará nesht o chosh dwái kort: ");
INSERT INTO bccl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Oo mani Pet! Agan tai razá ent gorhá é sakkiáni jám o pyálahá cha man dur kan o bethagalén, bale na pa mani lóth o wáhagá, pa tai jenday washnódiá.” ");
INSERT INTO bccl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Hamá wahdá, cha ásmáná préshtagé záher but o Issái deldári o delbaddhi dát. ");
INSERT INTO bccl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Á, yak grán o jánsóchén ranjéá dochár at, paméshká géshter dwái kort o áiay héd, hónay trampáni dhawlá zeminay sará petthetant. ");
INSERT INTO bccl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Cha dwáyá ke pád átk, moridáni némagá per tarret, disti ke cha bázén gam o andóhán, wáb kaptagant. ");
INSERT INTO bccl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Gwashti: “Pa ché waptagét? Pád áét, dwá kanét ke chakkásá makapét.” ");
INSERT INTO bccl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Angat Issá gón moridán habar kanagá at ke rombé mardom átk o raset. Cha Issáay dwázdahén moridán yakké, bezán Yahudá, áyáni rahshón at. Á, Issáay nazziká átk tán bechokkiti. ");
INSERT INTO bccl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Issáyá gwasht: “Oo Yahudá! Taw gón chokkag o drót,Ensánay Chokká geráénay?” ");
INSERT INTO bccl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wahdé Issáay hamráhán dist ché bayagá ent, jostesh kort: “Oo Hodáwand! Wati zahmán bekasshén?” ");
INSERT INTO bccl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Cha moridán yakkéá wati zahm kasshet o masterén dini péshwáay nawkaray rástén góshi sest. ");
INSERT INTO bccl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Bale Issáyá gwasht: “Bass ent! Dast bedárét!” Áiay góshá dasti per mosht o dráhi kort. ");
INSERT INTO bccl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Á wahdá, Issáyá gón mazanén dini péshwá, mazanén parasteshgáhay negahpánén sepáhigáni master o kawmay kamáshán ke pa áiay dazgir kanagá átkagatant, gwasht: “Záná, man yági o rahzané án ke shomá gón zahm o latthán pa mani dazgir kanagá átkagét? ");
INSERT INTO bccl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Man har róch mazanén parasteshgáhá gón shomá hór o yakjáh butagán, ódá shomá maná dast najatag. Bale haw! Nun wahd shomayg ent o taháróki hákem ent.” ");
INSERT INTO bccl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Gorhá, Issáesh dazgir kort o masterén dini péshwáay lógá bort. Petros dur durá, áyáni poshtá rawán at. ");
INSERT INTO bccl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Lógay péshjáhá, ásé rókesh kortagat o ásay chágerdá neshtagatant. Petros ham gón áyán nesht. ");
INSERT INTO bccl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Móledéá, ásay rozhnáiá, Petros dist, rogurogu cháret o gwashti: “É mard ham gón Issáyá hamráh butag.” ");
INSERT INTO bccl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bale Petrosá namannet o gwashti: “Oo janén! Man áiá nazánán.” ");
INSERT INTO bccl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kammé wahdá rand, degaréá Petros dist o gwashti: “Taw ham cha hamáyán ay.” Petrosá passaw dát: “Oo mard! Man cha áyán naán.” ");
INSERT INTO bccl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kamm o gésh sáhatéá rand, dega yakkéá Petrosay némagá cháret o pa deljami gwashti: “É mard allamá Issáay hamráh butag chiá ke á ham Jalilié.” ");
INSERT INTO bccl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Petrosá darráént: “Oo mard! Man sarpada nabán taw ché gwashagá ay.” Petros hamé habará gwashagá at ke korósá báng dát. ");
INSERT INTO bccl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Hodáwandén Issáyá chakk tarrént o Petrosay némagá cháret. Gorhá, Petros Hodáwanday habaray yát o tránagá kapt ke gwashtagati: “Taw maróchi korósbángá pésar, say randá mani pajjáh áragá enkára kanay.” ");
INSERT INTO bccl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nun dhanná dar átk o sakk gréti. ");
INSERT INTO bccl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Á sepáhigán ke Issá wati nyámá geptagat, áiay janag o malandh o maskará kanagesh bongéj kort. ");
INSERT INTO bccl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Issáay chammesh bastant o gwashtesh: “Nun paygambari kan, begwash kayá tará jat?!” ");
INSERT INTO bccl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Dega bázén bad o radé ham gwashtesh. ");
INSERT INTO bccl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wahdé róch but, kawmay kamásháni diwán, bezán mazanén dini péshwá o Sharyatay zánóger yakjáh butant, Issáesh lóthet o áwort. ");
INSERT INTO bccl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Jostesh kort: “Agan taw Masih ay gorhá márá begwash.” Issáyá passaw dát: “Agan man begwashán, báwara nakanét. ");
INSERT INTO bccl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Oo agan jost begerán, passawa nadayét. ");
INSERT INTO bccl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Bale cha annun o rand, Ensánay Chokk zóráwarén Hodáay rástén némagá nendit.” ");
INSERT INTO bccl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Á wahdá sajjahénán gwasht: “Acha, taw Hodáay Chokk ay?!” Passawi dát: “Shomá wat gwashagá ét ke Man Hamá Án.” ");
INSERT INTO bccl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Áyán gwasht: “Nun dega chónén gwáh o sháhedié lóthén? Má wat cha áiay jenday zobáná é habar eshkot.” ");
INSERT INTO bccl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Randá, diwánay sajjahén mardom pád átkant o Issáesh Pilátusay démá bort. ");
INSERT INTO bccl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Áiay sará tohmat o bohtám janáná gwashtesh: “Má distag ke é mard, kawmá gomráha kant, Rumay Kaysaray song o máliát dayagá manah o makana kant o gwashit: ‘Man Masih o bádsháh án.’” ");
INSERT INTO bccl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilátusá jost kort: “Taw Yahudiáni bádsháh ay?” Issáyá passaw dát: “Taw wat gwashagá ay.” ");
INSERT INTO bccl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilátusá gón mazanén dini péshwá o á dega mardomán gwasht: “Man pa é mardá hech mayáré nagendán.” ");
INSERT INTO bccl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Bale mardom wati habaray sará óshtátant o gwashtesh: “É mard, gón wati tálimán, Yahudiahay sajjahén damagay mardomána shórénit. Cha Jalilá bongéji kortag o annun edá rasetag.” ");
INSERT INTO bccl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilátusá mardománi é habar ke eshkotant, lótheti bezánt, bárén, á cha Jalilay mardomán ent? ");
INSERT INTO bccl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wahdé sahig but Issá Jalilié, gorhá Hirudisay némagá ráhi dát, chiá ke Jalilay hákem, Hirudis á wahdá Urshalimá at. ");
INSERT INTO bccl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hirudisá Issá ke dist, báz wassh but, chiá ke dérén wahdé at ke áiay gendagá wáhagdár at. Cha Issáay kortagén káráni eshkonagá rand, nun ométwár at ke yak mójezah o ajabbatén neshánié begendit. ");
INSERT INTO bccl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Gorhá, cha Issáyá bázén jost o porsé korti, bale Issáyá hech passawé nadát. ");
INSERT INTO bccl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mazanén dini péshwá o Sharyatay zánóger ke hamódá óshtátagatant, Issáay sará bázén tohmat o bohtám janagá atant. ");
INSERT INTO bccl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudisá ham gón wati sepáhigán hórigá, Issá béezzat kort o kalág gept. Randá, dhawldárén kabáhé gwará dát o padá Pilátusay kerrá rawán kort. ");
INSERT INTO bccl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Cha hamá róchá, Hirudis o Pilátus, bél o sangat butant. Pésará, á watmánwat dozhmen atant. ");
INSERT INTO bccl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilátusá, mazanén dini péshwá, Yahudiáni kamásh o mahluk lóthetant o ");
INSERT INTO bccl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","gwashti: “Shomá, é mard mani gwará áwortag o tohmat o bohtám jatag ke mardomán gomráh o yágia kant. Bale cha á jostán ke man shomay démá kortagant, áiay sará shomay jatagén bohtámán hech rástié nadiston. ");
INSERT INTO bccl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hirudisá ham mayáré nadistag, paméshká padá may gwará ráhi dátag. É mardá choshén hech gonáh o mayáré nakortag ke sezái mark bebit. ");
INSERT INTO bccl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gorhá, man áiá adaba dayán o yalaha kanán.” ");
INSERT INTO bccl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Bale sajjahén mardomán kukkár kort o gwasht: “Issáyá bekosh! Bárábásá yalah beday!” ");
INSERT INTO bccl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Bárábás, Urshalimay shahrá, áshóp o hón kanagay mayáray sará, bandig kanag butagat. ");
INSERT INTO bccl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilátus, Issáay yalah dayagá delmánag at, Paméshká dega yak randé áiay bárawá gón mardomán habari kort. ");
INSERT INTO bccl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Bale mardom sakk kukkár kanagá atant o gwashtesh: “Salibi kassh! Salibi kassh!” ");
INSERT INTO bccl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilátusá, saymi randá cha áyán jost kort: “Chiá bárén? É mardá che badén káré kortag? Man pa eshiá hech choshén mayáré nagendán ke kóshay hokmá bedayán, paméshká adabia dayán o yalahia kanán.” ");
INSERT INTO bccl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Bale mardom gón kukkár wati habaray sará óshtátant o gwashtesh: “Salibi kassh!” Néth, áyáni wáhag o kukkár pa sar raset. ");
INSERT INTO bccl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilátusá áyáni wáhagay sará hokm dát. ");
INSERT INTO bccl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","É dhawlá, áiá hamá mard ke pa áshóp pád kanag o hónay bohtámá bandig at o mardomán áiay yalah dayaga lóthet, ázát kort o áyáni wáhagay sará, pa Issáay kóshá hokm dát. ");
INSERT INTO bccl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wahdé Issáyá baragá atant, Shamun námén mardé distesh ke Keriniay shahray mardomé at o dém pa shahrá pédák at. Sepáhigán á mard gept, salib áiay baddhá dát o hojjesh kort ke Issáay randá berawt. ");
INSERT INTO bccl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Issáay randá, bázén mardomé rawagá at o gón áyán rombé janén ham gón at ke pa Issáaygi gréwán o mótk kanán atant. ");
INSERT INTO bccl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Issáyá chakk tarrént, áyáni némagá cháret o gwashti: “Oo Urshalimay jenekán! Pa man magréwét, pa wat o wati chokkán begréwét. ");
INSERT INTO bccl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Yak anchén wahdé kayt ke gwashant: ‘Bahtáwar ant á janén ke santh o bérand ant, hamá janén ke chokkesh nabutag o cha wati sénagán chokkesh naméchéntag.’ ");
INSERT INTO bccl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Hamá wahdá, mardom kóhán tawára kanant: ‘Byáét may sará bekapét’ o jompána gwashant: ‘Márá panáh dayét.’ ");
INSERT INTO bccl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Wahdé á gón sabzagén drachká chosha kanant, gorhá gón hoshkéná ché nakanant?” ");
INSERT INTO bccl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Áyán, do radkárén mardom áwort ke gón Issáyá hór, koshagi atant. ");
INSERT INTO bccl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wahdé hamá “Kámpól” námén jágahá rasetant, áyán Issá salibay sará dratk. Áiay rástén némagá yak radkáré salib kasshet o chappén némagá domi radkár. ");
INSERT INTO bccl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Issáyá gwasht: “Oo Pet! Áyán pahell kan, chiá ke nazánant ché kanagá ant.” Gorhá sepáhigán Issáay pocch o póshák kasshetant o pa áyáni bahr kanagá pál jatesh ke bárén kayá rasant. ");
INSERT INTO bccl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Mardom pa sayl o nedáragá óshtátagatant o sarókáni diwánay básk rishkand kanáná, gwashagá atant ke “eshiá, á dega rakkéntant, bale agan Masih ent o Hodáay hamá gechén kortagén, nun gorhá watá berakkénit.” ");
INSERT INTO bccl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sepáhig ham áiay nazziká shotant o kalágesh gept, tropshén sharábesh cháshént o gwashtesh: ");
INSERT INTO bccl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","“Agan taw Yahudiáni bádsháh ay, gorhá watá berakkén.” ");
INSERT INTO bccl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Issáay saray borzádiá é dhawlén mayárnámagé ham lónj kortagat ke: “É Yahudiáni bádsháh ent.” ");
INSERT INTO bccl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cha doén radkárán ke salibá dratkagatant, yakkéá dozhmán dayáná gwasht: “Taw Masih naay? Gorhá, byá watá o márá berakkén!” ");
INSERT INTO bccl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Bale domi radkárá á hakkal kort o gwashti: “Záná, tará cha Hodáyá natorsit? Tará ham hamé sezá rasagá ent. ");
INSERT INTO bccl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","May sezá barhakk ent, chiá ke may kortagén káráni ásar ent. Bale é mardá hech mayáré nakortag.” ");
INSERT INTO bccl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Gorhá gwashti: “Oo Issá! Wahdé taw wati bádsháhiá sar butay, mani hayálá ham bekap.” ");
INSERT INTO bccl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Issáyá passaw dát: “Tará rásténa gwashán ke taw maróchi mani hamráhiá, beheshtá raway.” ");
INSERT INTO bccl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Némróchay wahd at. Anágat sajjahén molk tahár but o é taháróki tán bégáhá mant. ");
INSERT INTO bccl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Chiá ke róchay drapshag band butagat o mazanén parasteshgáhay pardah cha nyámá dert o do ném but. ");
INSERT INTO bccl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Issáyá borzén tawáréá chihál kasshet o gwasht: “Oo Pet! Man wati ruh o sáhá tai dastá dayán.” Gón hamé habará, sáhi dát. ");
INSERT INTO bccl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Pawjiáni yak apsaréá é nedárag dist, Hodái satá kort o gwashti: “Béshakk ke é nékén mardé at.” ");
INSERT INTO bccl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Á dega sajjahén mardom ke pa saylá átkagatant, gón é nedáragay gendagá sar o sénag janán o mótk kanáná wati lógán per tarretant. ");
INSERT INTO bccl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Hamá mardom ke Issáay pajjárók atant o hamá janén ke cha Jalilá áiay hamráhiá átkagatant, dur o gestá óshtátagatant o é sajjahén sargwastesh distant. ");
INSERT INTO bccl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Hamódá, Issop námén mardé ham gón at ke tachk o pahrézkárén mardé at. Belli ke sarókáni diwánay báské at, ");
INSERT INTO bccl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","bale pa Issáay mayárig kanagá gón áyáni shawr o habarán hamdel naat. Á, Yahudiáni shahr Arimátiáay mardomé at o Hodáay bádsháhiay rahchár o wadárig at. ");
INSERT INTO bccl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilátusay kerrá shot o cha áiá Issáay jónay baragay ejázati lóthet. ");
INSERT INTO bccl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Issáay jóni cha salibay sará ér gétk, lilomén godéay tahá kapon kort o taláray tráshtagén kabréá ér kort ke pésará ódá hechkas kall kanag nabutagat. ");
INSERT INTO bccl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Á róch, tayáriay róch at o Shabbat bongéj bayagi at. ");
INSERT INTO bccl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Hamá janén ke cha Jalilá, Issáay hamráhiá átkagatant, Issopay randá rawán butant o hamá kabresh dist. Áyán é ham dist ke Issáay jón che paymá kabrá ér dayag but. ");
INSERT INTO bccl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Randá, wati lógán átkant o washbóén atr o rógenesh tayár kort. Shabbatay róchá, Sharyatay rahbanday sará, áyán árám kort. ");
INSERT INTO bccl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Haptagay awali róchá, bezán Yakshambehay gwarbámá, janénán hamá washbóén rógen o atr ke tayár kortagatant, zortant o kabray sará shotant, ");
INSERT INTO bccl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","bale distesh hamá dhók ke kabray dapá at léth geptag o cha wati jágahá thagaletag. ");
INSERT INTO bccl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Wahdé kabray tahá shotant, Hodáwandén Issáay jónesh nadist. ");
INSERT INTO bccl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Hayrán atant o nazántesh ché bekanant ke anágat do mard, gón drapshókén god o pocchán áyáni kashá óshtát. ");
INSERT INTO bccl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Janénán, cha torsá wati sar jahl kort, bale á doénán gwasht: “Shomá chiá á zendagéná, mordagáni nyámá shóháza kanét? ");
INSERT INTO bccl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Á, edá naent, áiá jáh jatag. Yát kanét, á wahdi ke angat gón shomá Jalilá at, ché gwashti? ");
INSERT INTO bccl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Shomárá nagwashti ke ‘Ensánay Chokk báyad ent gonahkáráni dastá dayag bebit, báyad ent salib kasshag bebit o saymi róchá padá zendag bebit o jáh bejant’?” ");
INSERT INTO bccl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Gorhá, á janén Issáay é habaray yát o tránagá kaptant. ");
INSERT INTO bccl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Cha kabray sará ke per tarretant, é sajjahén hál o habaresh gón yázdahén kásed o á degarán gwashtant. ");
INSERT INTO bccl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Á ke é habaresh pa kásedán rasént, Maryam Majdaliah, Yuánná, Ákubay mát Maryam o áyáni á dega hamráhén janén atant. ");
INSERT INTO bccl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kásedán, janénáni habar bé sar o bonén habar zánt o báwaresh nakortant. ");
INSERT INTO bccl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Bale Petros pád átk o pa drekké kabray némagá shot, sari jahl kort o kabray tahá cháreti, bale cha lilomén godán o abéd, dega hecchi nadist. Gorhá cha wati distagénán, hayrán o habakkah but o lógá per tarret. ");
INSERT INTO bccl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Hamá róchá, cha áyán do morid, dém pa Emáus námén métagéá rawagá at ke cha Urshalimá kesás yázdah kilumitar dur at. ");
INSERT INTO bccl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Á, ráhá gón yakdegará hamé butagén habar o háláni bárawá gapp o trán kanagá atant. ");
INSERT INTO bccl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Hamé wahdá ke gapp o habará atant, anágat Issá wat áyáni kerrá átk o gón áyán hór o hamráh but. ");
INSERT INTO bccl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Bale pajjáhesh nayáwort, chiá ke áyáni chamm pardahéá póshetagatant. ");
INSERT INTO bccl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Issáyá jost kort: “Shomá wati ráhá, chónén sarháláni bárawá gapp o trán kanagá ét.” Á gón gamnákén chehragé óshtátant. ");
INSERT INTO bccl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Gorhá cha áyán yakkéá ke námi Kliupás at, passaw dát: “Urshalimá darámadén mardom yakkén taw ay, cha é sarhálán ke hamé róchán ódá butagant sahig naay?” ");
INSERT INTO bccl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Josti kort: “Cha kojám sarhálán?” Gwashtesh: “Hamá ke Issá Náseriay sará átkant. Á, paygambaré at ke áiay kár o habarán, Hodáay bárgáh o mardománi gwará, bázén zór o kodraté mán at. ");
INSERT INTO bccl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Bale may mazanén dini péshwá o kawmay sarókán darkawmáni dastá dát ke pa áiá kóshay hokmá bedayant o randá áyán salib kasshet. ");
INSERT INTO bccl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Márá omét at, á hamá bit ke Esráilá rakkénit. Nun gapp esh ent ke é habarán say róch gwastag. ");
INSERT INTO bccl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Cha may hamráhén janénán, lahténáni habarán ham márá hayratéá perréntag. Á maróchi bámgwáhá kabray sará shotagant, ");
INSERT INTO bccl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","bale áiay jónesh nadistag. Gorhá átkant o márá hálesh dát ke áyán pa elhám o shobén préshtag distagant ke gwashtagesh: ‘Issá zendag ent.’ ");
INSERT INTO bccl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Cha may mardomán ham lahtén kabray sará shotag o áyán ham anchosh ke janénán gwashtag hamá dhawlá distag, bale áyáni chamm pa wájahay jendá nakaptag.” ");
INSERT INTO bccl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Issáyá gón áyán gwasht: “Oo násarpadán! Pa nabiáni sajjahén habaráni báwar kanagá shomay del kór ent. ");
INSERT INTO bccl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Masihá pa wati shán o shawkatay rasagá, é sakki o sóri saggagi naatant?” ");
INSERT INTO bccl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Randá Issáyá wati bárawá, Mussá o sajjahén nabiáni Pákén Ketábáni tahá, harché ke nebisag butagat, á sarpad kortant. ");
INSERT INTO bccl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Anchosh ke hamá métagay nazziká átk o rasetant ke ódá rawagi atant, Issáyá é dábá pésh dásht ke áiá durter rawagi ent. ");
INSERT INTO bccl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Áyán dazbandi kort: “Shapá gón má bejall chiá ke róch shotag o shap áyagi ent.” Gorhá, Issá ham shot tán gón áyán bemánit. ");
INSERT INTO bccl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Hamá wahdá ke Issá gón áyán pa waragá nesht, náni zort, Hodáay shogri gept, náni chondh chondh kort o áyáni dastá dát. ");
INSERT INTO bccl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nun áyáni chamm pach butant o Issáesh pajjáh áwort bale hamá damáná cha áyáni chammá chér o andém but. ");
INSERT INTO bccl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Gorhá cha yakdomiá jostesh kort: “Ráhá wahdé á gón má trán kanagá at o márá Pákén Ketábáni habarán sarpad kanagá at, may del janag o drik drik kanagá naat?” ");
INSERT INTO bccl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Gorhá, hamá damáná pád átk o Urshalimá per tarretant. Ódá, áyán yázdahén kásed o á dega morid yakjáh distant, ");
INSERT INTO bccl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ke gwashagá atant: “É rást ent ke Hodáwandá jáh jatag o pa Shamuná záher butag!” ");
INSERT INTO bccl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Gorhá é doénán wati ráhay sargwast gón áyán gwasht ke Issáesh che paymá nánay chondh kanagay wahdá pajjáh áwortag. ");
INSERT INTO bccl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Taningah á hamé habarán atant ke Issá wat átk o áyáni nyámá óshtát o gwashti: “Drud o drahbát pa shomá!” ");
INSERT INTO bccl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Áyán torset o hayrán o habakkah butant o gománesh kort balkén ruhé gendagá ant. ");
INSERT INTO bccl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Bale Issáyá gwasht: “Pa ché shomárá inchoka torsit o hayrán o habakkah mantagét o chiá shomay delá shakk pád átkag? ");
INSERT INTO bccl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Dast o pádánon begendét, é mani jend ent. Maná dast janét o bechárét, arwáhá haddh o gósht pera nabit, bale shomá gendagá ét ke maná haddh o gósht per ent.” ");
INSERT INTO bccl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","É habaray gwashagá rand, wati dast o pádi pésh dáshtant. ");
INSERT INTO bccl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Á, cha shádmániá hayrán o habakkah butant o báwaresh nakort. Gorhá, josti kort: “Gón shomá pa waragá edá chizzé hast?” ");
INSERT INTO bccl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Chondhé patkagén máhigesh dát, ");
INSERT INTO bccl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Issáyá zort o áyáni dém pa démá wárt. ");
INSERT INTO bccl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Gorhá gwashti: “É mani hamá habar ant ke man gón shomá á wahdá kortagant ke angat gón shomá butagán. Mani bárawá, har habaré ke Mussáay Sharyat, Zabur o Nabiáni Ketábán nebeshtah ent, á zalur báyad ent hamá dhawlá sarjam bebant.” ");
INSERT INTO bccl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Randá, áyáni zánt o zánagi rozhnág kort tánke Pákén Ketábáni máná o maksadá sarpad bebant. ");
INSERT INTO bccl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Gwashti: “Nebisag butag ke Masih báyad ent sakki besaggit, sáh bedant o saymi róchá, cha mordagáni nyámá jáh bejant o ");
INSERT INTO bccl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","áiay námay sará, pashómán bayag o gonáháni pahelli báyad pa sajjahén kawmán jár janag bebit. É káray bongéj cha Urshalimá bit. ");
INSERT INTO bccl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Shomá é kár o habaráni gwáh o sháhed ét. ");
INSERT INTO bccl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Man wati Petay wádah dátagén Pákén Ruhá pa shomá rawána dayán, nun shomá shahrá bemánét, tán hamá wahdá ke cha borzá shomárá wák o kodrat berasit.” ");
INSERT INTO bccl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Randá, Issáyá morid tán Bayt-Anyáay nazziká bortant o dast borz kort o pa áyán nékén dwái lóthet o barkat dátant. ");
INSERT INTO bccl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Hamá wahdá ke dwá kanag o barkat dayagá at, cha áyán gisshet o ásmáná barag but. ");
INSERT INTO bccl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Moridán Issá parastesh kort o gón bázén gal o wasshié Urshalimá per tarretant. ");
INSERT INTO bccl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Modám mazanén parasteshgáhá mantant o Hodáyá satá kanán atant.");
INSERT INTO bccl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Bongéjá, cha azal, Gál hastat. Gál gón Hodáyá gón at o Gál Hodáay jend at. ");
INSERT INTO bccl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cha azalá, Gál gón Hodáyá at. ");
INSERT INTO bccl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sajjahén chizz cha Gálá jórh butant o cha é jórh butagénán, bé Gálá hech chizzé jórh nabut. ");
INSERT INTO bccl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Hasti o zend cha hamáiá pédá but o zend, mardománi nur o rozhn at. ");
INSERT INTO bccl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Rozhn, tahárókiá drapshit o tahárókiá, rozhn hechbar zánt nakortag o prósh nadátag. ");
INSERT INTO bccl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Yahyá námén mardé pédá but ke Hodáay ráh dátagén at. ");
INSERT INTO bccl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Á átk ke sháhed bebit o pa hamá rozhná gwáhi bedant, tánke sajjahén mardom cha áiay gwáhiá imán byárant. ");
INSERT INTO bccl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Á wat hamá rozhn naat, bale átk tán pa rozhná gwáhi bedant. ");
INSERT INTO bccl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Hamá rástén rozhn, ke pa sajjahén mardomán rozhnáia kárit, nun mán jaháná áyagi at. ");
INSERT INTO bccl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Á mán jaháná at o Hodáyá jahán cha hamáiá jórhéntagat, bale jaháná á pajjáh nayáwort. ");
INSERT INTO bccl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Á wati mahlukay nyámá átk o mahluká namannet. ");
INSERT INTO bccl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Bale hamá mardomán ke báwara kort o mannet, áiá é hakk o ehtiár dátant ke Hodáay chokk bebant, bezán hamá ke áiay námay sará imánesha áwort. ");
INSERT INTO bccl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Á, na cha hóná pédá butant o na cha jesmáni wáhagán o na cha ensáni lóthán, cha Hodáyá pédá butant. ");
INSERT INTO bccl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gál ensán but o may nyámá jágahi kort. Má áiay shán o shawkat dist, shán o shawkaté ke Petay yakkén Chokkayg ent, hamá Chokk ke cha rahmat o rástiá porr ent. ");
INSERT INTO bccl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yahyá pa áiá gwáhia dant, gwánka jant o gwashit: “Esh ent hamá kas ke áiay bárawá man gwashtag: Cha man o randa kayt, bale cha man master o démáter ent. Chiá ke cha man pésará butag.” ");
INSERT INTO bccl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Má sajjahénán cha áiay pormehrén rahmatay sawgátá modám barkat geptag. ");
INSERT INTO bccl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","É rást ent ke Tawrát cha Mussáyá márá bakshag butag, bale rahmat o rásti, cha Issá Masihá pa má átk o sar but. ");
INSERT INTO bccl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kassá hechbar Hodá nadistag, bale hamá yakdánagén Chokk ke wat Hodá ent o Petay ambázá ent, hamáiá Hodá pajjáréntag. ");
INSERT INTO bccl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","20","Wahdé Urshalimay shahray Yahudián wati lahtén dini péshwá o Láwiay kabilahay mardom Yahyáay kerrá rawán dát ke jost begerant: “Taw kay ay?” Áiá enkár nakort, tachk o pa rásti gwáhi dát o gwashti: “Man Masih naán.” ");
INSERT INTO bccl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Áyán jost kort: “Taw Elyás ay?” Gwashti: “Na.” Gwashtesh: “Gorhá taw hamá wádah dátagén nabi ay?” Gwashti: “Na.” ");
INSERT INTO bccl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Jostesh kort: “Acha, taw kay ay? Má báyad ent pa áyán passawé bebarén gón ke márá rawánesh dátag. Wati bárawá ché gwashay?” ");
INSERT INTO bccl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Áiá cha Eshayá nabiay kawlá gwasht: “Man hamá tawár án ke mán gyábáná gwánka jant o gwashit, Hodáwanday ráhá rást o tachk kanét.” ");
INSERT INTO bccl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Cha é rawán dátagén kásedán lahtén Parisi atant. ");
INSERT INTO bccl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jostesh kort: “Agan taw na Masih ay o na Elyás ay o na hamá nabi, gorhá pa ché pákshódia dayay?” ");
INSERT INTO bccl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yahyáyá áyáni passawá gwasht: “Man gón ápá pákshódia dayán, bale kaséá shomay nyámá jáh jatag ke shomá áiá nazánét. ");
INSERT INTO bccl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Á cha man o randa kayt o man áiay kawshbandáni bójagay láhek ham naán.” ");
INSERT INTO bccl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","É kár Ordonay kawray á dastá, Bayt-Anyáyá but, hamá jágahá ke Yahyáyá mardom pákshódia dátant. ");
INSERT INTO bccl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","É dega róchá, wahdé Yahyáyá Issá dist ke dém pa áiá pédák ent, gwashti: “Bechárét! Esh ent Hodáay hamá Gwarándh ke jahánay gonáhán dura kant. ");
INSERT INTO bccl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Esh ent hamá kas ke áiay bárawá man gwashtag: ‘Cha man o randa kayt bale cha man master o démáter ent, chiá ke cha man pésará butag.’ ");
INSERT INTO bccl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Man wat pajjáh nayáwort, bale gón ápá mardománi pákshódi dayagá átkán tánke é dhawlá á pa Bani Esráilián zánag o paddar kanag bebit.” ");
INSERT INTO bccl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yahyáyá wati gwáhi é paymá démá bort: “Man Hodáay Ruh dist ke kapótéay dróshomá cha ásmáná ér átk o áiay sará nesht. ");
INSERT INTO bccl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Man á nazánt, bale hamá kasá ke maná rawán dát tán gón ápá pákshódi bedayán, gwashtagati: ‘Wahdé taw dist Ruh kaséay sará ér byayt o benendit, bezán á hamá kas ent ke gón Hodáay Pákén Ruhá pákshódia dant.’ ");
INSERT INTO bccl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Man é chizz distag o gwáhia dayán ke á Hodáay Chokk ent.” ");
INSERT INTO bccl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","É dega róchá, Yahyá gón wati do moridá óshtátagat. ");
INSERT INTO bccl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Wahdé Yahyáyá Issá dist ke cha ódá gwazagá ent gwashti: “Esh ent Hodáay Gwarándh.” ");
INSERT INTO bccl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Á doén moridán é habar eshkot o Issáay randá rawán butant. ");
INSERT INTO bccl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Issáyá chakk tarrént o har doéni distant ke áiay randá áyagá ant. Josti kort: “Shomá ché lóthét?” Gwashtesh: “Rabbi!” Bezán: Oo ostád! “Tai jágah kojá ent?” ");
INSERT INTO bccl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Gwashti: “Byáét o bechárét!” Gorhá á doén shotant o distesh ke kojá neshtag o róchay pasht kaptagén bahrá hamáiay kerrá mantant. Bégáhay wahd at. ");
INSERT INTO bccl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yahyáay habaráni eshkonagá rand, cha é doénán ke Issáay randesh gept o shotant, yakké Shamun Petrosay brát, Andriás at. ");
INSERT INTO bccl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Áiá pésará wati brát Shamun wadi kort o gwashti: “Má Masih dar gétk.” ");
INSERT INTO bccl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Randá, áiá Shamun Issáay kerrá bort. Issáyá Shamun cháret o gwashti: “Taw Shamun, Yuhannáay chokk ay. Bale nun tai nám Kaypá bit.” Kaypáay máná Petros, bezán talár ent. ");
INSERT INTO bccl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","É dega róchá, wahdé Issáyá wati delá gwasht ke Jalilay damagá berawt, Piliposi dar gétk o gwashti: “Mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipos ham, Petros o Andriásay dhawlá, cha Bayt-Saydáay shahray mardomán at. ");
INSERT INTO bccl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipos ham shot o Natnáili shóház kort o gwashti: “Má hamá kas distag o dar gétkag ke Mussáyá Tawrátay tahá áiay mestág dátag o á dega nabián ham áiay bárawá gwashtag. Á Issá Náseri, Issopay chokk ent.” ");
INSERT INTO bccl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natnáilá gón áiá gwasht: “Cha Náserahá ham sharrén chizzé dar kapta kant?” Piliposá gwasht: “Byá o bechár!” ");
INSERT INTO bccl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wahdé Issáyá Natnáil dist ke dém pa áiá pédák ent, gwashti: “É tachkén Bani Esráilié ke delá hech paymén mandr o repké mán nést.” ");
INSERT INTO bccl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natnáilá jost kort: “Taw maná cha kojá zánay?” Issáyá áiay passawá gwasht: “Cha á wahdá pésar ke Piliposá tará tawár kort, man tará hamá wahdá dist ke enjiray drachkay chérá atay.” ");
INSERT INTO bccl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natnáilá gwasht: “Oo ostád! Taw Hodáay Chokk ay, taw Esráilay bádsháh ay.” ");
INSERT INTO bccl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Issáyá passaw dát: “Paméshká imánet áwort ke man gwasht: ‘Tará enjiray drachkay chérá distagon’. Cha é chizzán masteréna genday.” ");
INSERT INTO bccl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gorhá gón áiá gwashti: “Shomárá rásténa gwashán, démterá ásmáná pacha gendét o Hodáay préshtag dém pa Ensánay Chokká, ke man án, jahl o borza káyant o rawant.” ");
INSERT INTO bccl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Saymi róchá, Jalilá, Káná námén métagéá, sur o árósé hastat o Issáay mát ham hamódá at. ");
INSERT INTO bccl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Issá o áiay moridesh ham lóthetagatant. ");
INSERT INTO bccl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wahdé sharáb halletant, Issáay mátá gón áiá gwasht: “Áyán dega sharáb nést.” ");
INSERT INTO bccl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Gwashti: “Oo bánok! Maná o tará gón eshiá che kár? Mani wahd angat narasetag.” ");
INSERT INTO bccl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mátá gón kárendah o hezmatkárán gwasht: “Harché shomárá gwashit, hamá kárá bekanét.” ");
INSERT INTO bccl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ódá ápay shash sengén kunzag ér at, ke har yakkéá sad tásay jágah hastat o Yahudiáni pákizagiay rasmán kármarza butant. ");
INSERT INTO bccl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Issáyá gón hezmatkárán gwasht: “Kunzagán cha ápá porr kanét.” Gorhá kunzagesh cha ápá sarréch kortant. ");
INSERT INTO bccl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nun Issáyá gwasht: “Pa diwánay kamáshá kammoké bebarét.” Áyán anchosh kort. ");
INSERT INTO bccl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Diwánay kamáshá nazánt é áp ke sharáb butagatant cha kojá árag butagant, áiá chashet o nósh kortant, bale hezmatkárán ke áp kasshetagatant zántesh. Nun diwánay kamáshá, sálónk tawár jat o ");
INSERT INTO bccl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","gwashti: “Harkas mehmánán sharterén sharábá pésará dant, wahdé á malár o sargrána bant, randá adná o arzánteréná kárant. Bale taw sharterén nóki áwortag!” ");
INSERT INTO bccl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","É mójezah o ajabbatén nesháni ke Jalilay métag Kánáyá but, Issáay awali mójezah at. Áiá gón hamé mójezahá wati mazani o shawkat paddar kort o moridán áiay sará imán áwort. ");
INSERT INTO bccl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Randá Issá gón wati mát, brát o moridán Kaparnáhumay shahrá shot o lahtén róchá hamódá mant. ");
INSERT INTO bccl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Yahudiáni Pesah, bezán Sargwazay aid, nazzik at. Paméshká, Issá Urshalimá shot. ");
INSERT INTO bccl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Mazanén parasteshgáhay tahá disti ke mardom gók, pas o kapótay bahá kanagá goláésh ant o zarr badal kanókén sarráp ham neshtagant. ");
INSERT INTO bccl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Gorhá gón sád o chilleká, hayzaráné jórhénti o sajjahén bápári o pas o góki cha parasteshgáhá dar kortant o sarrápáni zarr o sekkahi ham rétkant o mizz o barónki chappig kortant. ");
INSERT INTO bccl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Gorhá gón kapót bahá kanókán gwashti: “Eshán cha edá dar kanét. Mani ásmáni Petay lógá bázáré makanét.” ");
INSERT INTO bccl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Nun morid yát o tránagá kaptant ke Hodáay Pákén Ketába gwashit: Á gayrat ke maná pa Hodáay lógá hastent, maná jánsócha kant o báhénit. ");
INSERT INTO bccl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gorhá Yahudián gwasht: “Taw gón chónén neshánié paddara kanay ke tará é káráni ejázat hastent?” ");
INSERT INTO bccl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Issáyá gwasht: “É mazanén parasteshgáhá bepróshét o karójét, man say róchá padá chestia kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yahudián gwasht: “É mazanén parasteshgáh, chel o shash sálá jórh kanag butag, taw chón áiá say róchá chesta kanay?” ");
INSERT INTO bccl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Bale á parasteshgáh ke Issá áiay bárawá gapp kanagá at, áiay jenday jesm o ján at. ");
INSERT INTO bccl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Cha Issáay merag o jáh janagá rand, morid yát o tránagá kaptant ke áiá wat é habar gwashtagat, paméshká Hodáay Pákén Ketáb o Issáay habaráni sará imánesh áwort. ");
INSERT INTO bccl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Á róchán, Issá pa Sargwazay aidá Urshalimá at. Bázén mardoméá ke Issáay ajabbatén nesháni distant, áiay námay sará báwaresh kort. ");
INSERT INTO bccl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Bale Issáyá watá áyáni démá záher o paddar nakort, chiá ke áiá sajjahén mardom sharriay sará zántant. ");
INSERT INTO bccl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pa ensánay zánag o pajjáh áragá, áiá hechkaséay gwáhiay zalurat naat, chiá ke á, mardománi delay har hálá sahig at. ");
INSERT INTO bccl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nikudimus námén Parisié, ke cha Yahudiáni sarók o diwánay báskán yakké at, ");
INSERT INTO bccl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","shapéá Issáay kerrá átk o gón áiá gwashti: “Oo ostád! Má zánén taw ostádé ay ke cha Hodáay némagá átkagay, chiá ke tán Hodá gón kaséá gón mabit, á é dhawlén ajabbatén nesháni pésh dáshta nakant ke taw pésh dáragá ay.” ");
INSERT INTO bccl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Issáyá áiay passawá gwasht: “Tará rásténa gwashán, tán kasé padá nóksará pédá mabit, Hodáay bádsháhiá dista nakant.” ");
INSERT INTO bccl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikudimusá gwasht: “Chón buta kant ke piréné padá cha mátá pédá bebit? Buta kant ke á padá mátay lápá berawt o pédá bebit?” ");
INSERT INTO bccl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Issáyá passaw dát: “Tará rásténa gwashán, tán kasé cha áp o Ruhá pédá mabit, Hodáay bádsháhiá pád ér korta nakant. ");
INSERT INTO bccl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Á chizz ke cha jesmá pédá bit, jesm ent o á chizz ke cha Ruhá bit, ruh ent. ");
INSERT INTO bccl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Hayrán mabay ke tará gwashán shomá sajjahén báyad ent nóksará pédá bebét. ");
INSERT INTO bccl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Gwát har jáh ke belóthit, kasshit. Taw áiay tawárá eshkonay, bale nazánay cha kojá kayt o kojá rawt. Á kas ke cha Ruhá pédá bit, á ham anchosh ent.” ");
INSERT INTO bccl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikudimusá gwasht: “É chón buta kant?” ");
INSERT INTO bccl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Issáyá gwasht: “Taw wat Esráiliáni ostádé ay, é chizzá nazánay? ");
INSERT INTO bccl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Báwar kan, má hamá chizzáni habará kanén ke áyáni bárawá zánén o hamá chizz ke distagant, áyáni sháhediá dayén. Bale shomá may sháhediá namannét. ");
INSERT INTO bccl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Wahdé zemini chizzáni bárawá habara kanán báwara nakanét, agan ásmáni chizzáni bárawá habar bekanán gorhá che paymá báwara kanét? ");
INSERT INTO bccl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Hechkas ásmáná borzád nashotag, abéd cha hamá kasá ke cha ásmáná ér átk, bezán man ke Ensánay Chokk án. ");
INSERT INTO bccl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Hamá dhawlá ke Mussáyá, gyábáná á már dáray sará dratk, Ensánay Chokk ham báyad ent chest kanag bebit, ");
INSERT INTO bccl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","tán harkas ke pa áiá imána kárit, namiránén zenday wáhond bebit.” ");
INSERT INTO bccl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Chiá ke Hodáyá jahánay mardom haminchok dóst atant ke wati yakk o yakdánagén Chokki ham nadr kort tán harkas ke áiay sará báwar bekant gár o zyán mabit o tán abad zendag bemánit. ");
INSERT INTO bccl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Hodáyá wati Chokk pa mardománi ér janag o mayárig kanagá jaháná rawán nadát. Rawáni dát ke áyán neját bedant o berakkénit. ");
INSERT INTO bccl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Harkas ke áiay sará báwar bekant mayáriga nabit, bale harkas ke báwar makant, hamé annun mayárig ent, chiá ke Hodáay yakdánagén Chokkay námay sará báwari nakortag. ");
INSERT INTO bccl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Hodáay dádrasi hamesh ent: Rozhn o nur jaháná átk, bale rozhnay badalá, mardomán taháróki dóst at, parchá ke áyáni kár sell atant. ");
INSERT INTO bccl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Chiá ke á mardom ke sellén káráni ráh o keshká zurit cha rozhnáiá bézára bit o watá cha rozhná dura dárit, tánke áiay badén kerd páshk o paddar mabant. ");
INSERT INTO bccl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Bale á ke rástiá gechéna kant o zurit dém pa rozhnáiá kayt, tán pakká bebit ke áiay kár Hodái butagant. ");
INSERT INTO bccl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Randá, Issá gón wati moridán Yahudiahay métag o kallagán shot o gón áyán hamódá mant o pákshódia dáti. ");
INSERT INTO bccl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yahyá ham Sálemay nazziká, Aynuná, mardománi pákshódiá goláésh at. Á chágerdá áp báz at o mardom pa pákshódiá átkant. ");
INSERT INTO bccl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Chiá ke Yahyá angat jélá bandi nabutagat. ");
INSERT INTO bccl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Pákizagiay sará, Yahyáay morid o yak Yahudiéay nyámá kassh o chillé but. ");
INSERT INTO bccl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Gorhá á, Yahyáay kerrá átkant o gwashtesh: “Oo ostád! Hamá mard ke Ordonay kawray á dastá gón taw gón at o taw áiay bárawá gwáhi dát, á edá pákshódi dayagá ent o sajjahén mardom hamáiay kerrá rawagá ant.” ");
INSERT INTO bccl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yahyáyá áyáni passawá gwasht: “Cha Hodáay dátagéná abéd, mardom dega chizzé kattheta nakant. ");
INSERT INTO bccl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Shomá wat sháhed ét gwashton ke ‘Man Masih naán, bale cha áiá pésar rawán dayag butagán.’ ");
INSERT INTO bccl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Bánóray hodábond, sálónk ent. Sálónkay dóst ke óshtátag o áiay tawárá eshkont, gal o shádána bit. Hamé dhawlá, mani shádehi annun pa kamál rasetag o sarréch butag. ");
INSERT INTO bccl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Á báyad ent démá berawt o man pad bekenzán.” ");
INSERT INTO bccl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Á kas ke cha borzáda kayt, cha sajjahénán master ent o á ke cha é hákién donyáyá ent zemini mardomé o donyái chizzáni bárawá habara kant. Bale á ke cha ásmáná kayt cha sajjahénán master ent. ");
INSERT INTO bccl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Har chizzé ke distag o eshkotagi, pa áyán gwáhia dant, bale hechkas áiay gwáhiá namannit. ");
INSERT INTO bccl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Harkasá ke áiay gwáhi mannetag, Hodáay rástiay gwáhii dátag. ");
INSERT INTO bccl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Á kas ke cha Hodáay némagá rawán dayag butag, Hodáay habarána kant, chiá ke Hodá wati Ruhá pa áiá békesása bakshit. ");
INSERT INTO bccl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Petá Chokk dóst ent o sajjahén chizzi hamáiay dastá dátagant. ");
INSERT INTO bccl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Á kas ke Chokkay sará imán byárit namiránén zenday wáhonda bit, bale á kas ke Chokkay habarán mamannit, zenday wáhonda nabit o Hodáay nárazáiay tahá gereptára bit. ");
INSERT INTO bccl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Issáyá zánt Parisián eshkotag ke áiá cha Yahyáyá géshterén moridé wadi kortag o áyán pákshódia dant. ");
INSERT INTO bccl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","3","Gorhá cha Yahudiahá dém pa Jalilá per tarret. Chónáhá, Issáyá wat mardom pákshódia nadátant, é kár moridána kort. ");
INSERT INTO bccl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Bale zalurat at ke cha Sámerahay damagá begwazit. ");
INSERT INTO bccl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ódá, yak shahréá raset ke námi Suhár at o hamá dhagáray nazziká at ke Ákubá wati chokk Issopárá dátagat. ");
INSERT INTO bccl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Ákubay chát hamódá at. Issáyá cha sapará dam bortagat o hamé chátay kerrá nesht. Némróchay wahd at. ");
INSERT INTO bccl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Sámeri janéné ápay kasshagá átk, Issáyá gón áiá gwasht: “Kammé áp maná beday.” ");
INSERT INTO bccl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Áiay morid, pa warákay gerag o áragá shahrá shotagatant. ");
INSERT INTO bccl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Sámeri janéná gwasht: “Taw ke yak Yahudié ay, chón cha man ápa lóthay?” Janéná paméshká chosh gwasht, ke Yahudi gón Sámerián raw o á nakanant. ");
INSERT INTO bccl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Issáyá áiay passawá gwasht: “Agan taw bezántén Hodáay bakshesh chi ent o é kay ent ke cha taw ápa lóthit, gorhá allamá taw gón áiá dazbandi kortagat ke tará zendáp bedant.” ");
INSERT INTO bccl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Janéná gwasht: “Oo wájah! Tará pa ápay kasshagá dhól nést o é chát sakk johl ent, cha kojá zendápa káray? ");
INSERT INTO bccl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Taw cha may pirok Ákubá master ay, ke é cháti márá dátag o áiay jend, chokk, ramag o górromá cha é chátá áp wártag?” ");
INSERT INTO bccl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Issáyá passaw tarrént: “Harkas ke é ápá bwárt padá tonniga bit, ");
INSERT INTO bccl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","bale harkas ke mani bakshetagén ápá bwárt, hechbar tonniga nabit. Chiá ke hamá ápá ke mana dayán agan kasé bwárt, cha áiay daruná zendápay chammagé bojit o jáha jant ke abadi ent.” ");
INSERT INTO bccl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Janéná gwasht: “Oo wájah! Hamá ápá maná beday tán dega baré tonnig mabán o pa ápay kasshagá edá mayáyán.” ");
INSERT INTO bccl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Issáyá gwasht: “Beraw wati lógwájahá tawár kan o padá hamedá byá.” ");
INSERT INTO bccl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Janéná áiay passawá gwasht: “Maná mard nést.” Issáyá gwasht: “Rásta gwashay ke tará mard nést, ");
INSERT INTO bccl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","chiá ke tará panch mard butag o é mard ke annun gón taw zendagia kant, tai mard naent. Taw rást gwasht.” ");
INSERT INTO bccl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Janéná darráént: “Oo wájah! Mani zánagá, taw yak nabié ay. ");
INSERT INTO bccl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","May pet o pirokán hamé kóhay sará parastesh kortag, bale shomá Yahudia gwashét, báyad ent Hodá Urshalimáparastesh kanag bebit.” ");
INSERT INTO bccl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Issáyá gwasht: “Oo janén! Báwar kan, yak wahdé kayt ke Hodáén Petá na é kóhay sará parastesha kanant o na ham Urshalimá. ");
INSERT INTO bccl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Shomá Sámeri hamáiá parastesha kanét ke áiá nazánét. Bale má hamáiá parastesha kanén ke áiá zánén. Chiá ke neját o rastgári cha Yahudiáni némagá kayt. ");
INSERT INTO bccl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Yak wahdé kayt o á wahd annun bongéj butag ke rást o barhakkén parastesh kanók Petá gón Ruh o pa rásti parastesha kanant. Chiá ke Pet hamé dhawlén parastesh kanókáni lóthók ent. ");
INSERT INTO bccl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Hodá Ruh ent o harkas ke áiá parastesha kant gón Ruh o pa rásti parastesh bekant.” ");
INSERT INTO bccl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Janéná gwasht: “Mana zánán ke Masiha kayt o har wahdé ke á kayt, sajjahén chizzán márá gwashit.” ");
INSERT INTO bccl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Issáyá gwasht: “Man ke gón taw habar kanagá án, hamá án.” ");
INSERT INTO bccl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Hamé wahdá Issáay morid padá átkant. Wahdé distesh ke Issá gón janénéá habar kanagá ent, hayrán butant. Bale hechkasá jost nakort ke “chiá gón eshiá habar kanagá ay?” yá “cha eshiá ché lóthay?” ");
INSERT INTO bccl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nun janéná wati kunzag zeminá ér kort, shahrá shot o gón mardomán gwashti: ");
INSERT INTO bccl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Byáét mardéá begendét, man tán é wahdi harché kortag, áiá maná gwashtant. Bárén, Masih naent?” ");
INSERT INTO bccl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Gorhá mardom cha shahrá dar kapt o Issáay némagá ráh geptant. ");
INSERT INTO bccl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","É nyámá moridán gón Issáyá dazbandi kort o gwashtesh: “Oo ostád! Chizzé bwar.” ");
INSERT INTO bccl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Bale áiá gwasht: “Maná waráké hast ke shomá áiay bárawá nazánét.” ");
INSERT INTO bccl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nun morid watmánwat habará atant ke “bárén, kaséá pa áiá waráké áwortag?” ");
INSERT INTO bccl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Issáyá gón áyán gwasht: “Mani warák hamesh ent ke wati rah dayókay wáhagá barjáh bekanán o áiay kárán sarjam bekanán. ");
INSERT INTO bccl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Shomá nagwashét ke pa rón o móshay mósomá angat chár máh pasht kaptag? Sharr delgósh kanét, shomárá gwashán, keshárán bechárét o begendét ke annun pa róná rasetag o tayár ant. ");
INSERT INTO bccl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ronók wati mozzá gipt o bar o samará pa namiránén zendá moccha kant, tán keshók o ronók hór gal o shádán bebant. ");
INSERT INTO bccl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Edá é habar rást ent ke ‘yakké keshit o degaré ronit.’ ");
INSERT INTO bccl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Man shomárá rawán dát tán hamá bar o samaráni wáhond bebét ke shomá pa áyán hech zahmaté ham nakasshetag. Degarán zahmat kasshetag o shomá cha áyáni kárá nap o sutta gerét.” ");
INSERT INTO bccl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Á shahray bázén Sámeri mardomán paméshká Issáay sará imán áwort ke á janéná gwáhi dátag o gwashtagat: “Har chizzé ke tán é wahdi man kortag áiá maná gwashtant.” ");
INSERT INTO bccl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Gorhá Sámeri Issáay kerrá átkant o dazbandiesh kort ke áyáni kerrá bemánit. Issá tán do róchá gón hamáyán nesht o ");
INSERT INTO bccl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","bázénéá áiay habaráni sará imán áwort. ");
INSERT INTO bccl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Gón á janéná gwashtesh: “Nun éwak o tahná tai habaráni sará báwarmand naén, má áiay jenday habar ham eshkotagant o deljam én ke á pa rásti jahánay rakkénók ent.” ");
INSERT INTO bccl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Do róchá rand, Issá cha ódá dar kapt o Jalilá shot. ");
INSERT INTO bccl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Issáyá wat gwashtagat ke “hech nabiéá wati shahr o hankéná ezzat nést.” ");
INSERT INTO bccl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Bale wahdé Jalilá raset, mardomán pa delsetki wasshátk kort, chiá ke aiday róchán á Urshalimá atant o ódá áiay kortagén káresh distagatant. ");
INSERT INTO bccl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Issá padá Jalilay métag Kánáyá shot, hamódá ke ápi sharáb kortagatant. Bádsháhay kárdáré hastat ke chokki, Kaparnáhumay shahrá nádráh at. ");
INSERT INTO bccl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wahdé á sahig but ke Issá cha Yahudiahá Jalilá átkag, áiay kerrá átk o dazbandi korti ke Kaparnáhumá byayt o áiay nádráhén bachaká berakkénit ke markig ent. ");
INSERT INTO bccl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Issáyá gón áiá gwasht: “Shomá tán mójezah o ajabbatén nesháni magendét hech paymá imána nayárét.” ");
INSERT INTO bccl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Á mardá gwasht: “Oo wájah! Bachakay meragá pésar byá.” ");
INSERT INTO bccl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Issáyá gwasht: “Beraw tai chokk dráha bit.” Á mardá Issáay habar báwar kort o wati lógá shot. ");
INSERT INTO bccl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Angat lógá narasetagat ke nawkarán ráhay nyámá dist o hálesh dát: “Tai chokk dráh butag.” ");
INSERT INTO bccl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Áiá jost gept: “Che wahd o damáná gehter butag?” Áyán gwasht: “Zi némróchá kammé rand, tapá yalah dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Petá zánt ke é wahd, hamá wahd at ke Issáyá gwashtagat: “Tai chokk dráha bit.” Gorhá áiá wat gón lógay sajjahén mardomán Issáay sará imán áwort. ");
INSERT INTO bccl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Cha Yahudiahá, Jalilá ke átk, é Issáay domi ajabbatén nesháni at. ");
INSERT INTO bccl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kammé randterá, Issá pa Yahudiáni yak aidéá, Urshalimá shot. ");
INSERT INTO bccl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Urshalimá, yak darwázagéay nazziká, ke áiá pasay darwázaga gwashant, taláwagé hastent ke cha panch gombodá jórh butag o Árámi zobáná áiá Bayt-Hasdá gwashant. ");
INSERT INTO bccl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ódá bázén lang, mondh, kór o nádráhé waptagat. ");
INSERT INTO bccl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","É mardománi nyámá yak mardé hastat, si o shash sál at ke nájórh at. ");
INSERT INTO bccl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wahdé Issáyá á mard waptagén hálatá dist o zánti ke cha dérigén wahdéá nádráh ent, gwashti: “Taw lóthay wassh o dráh bebay?” ");
INSERT INTO bccl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Á nádráhá gwasht: “Oo wájah! Wahdé ápa rombit o rawána bit, kasé nést ke maná taláwagá dawr bedant. Tán man watá berasénán, degaré zutter koppa kant.” ");
INSERT INTO bccl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Issáyá gwasht: “Pád á, wati nepádán bezur o beraw.” ");
INSERT INTO bccl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Á mard dráh but, wati nepád o gandali zortant o ráh kapt. Á róch Shabbatay róch at. ");
INSERT INTO bccl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Paméshká Yahudi gón á dráh butagén mardá gwashagá laggetant: “Maróchi Shabbatay róch ent, tará wati gandaláni zurag o rawagay hakk nést.” ");
INSERT INTO bccl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Passawi dát: “Á mardá ke maná dráh kort gwashti: ‘Pád á, wati gandalán bezur o beraw.’ ” ");
INSERT INTO bccl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Cha áiá jostesh kort: “Kayá tará gwashtag: ‘Wati gandalán bezur o beraw?’” ");
INSERT INTO bccl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Bale dráh butagén mardá nazánt á kay at. Chiá ke Issá mardománi mocchiay tahá chér o andém butagat. ");
INSERT INTO bccl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Randá, Issáyá á mard mazanén parasteshgáhá dist o gwashti: “Nun ke dráh butagay, gonáh makan. Chosh mabit ke ganterén baláhé tai sará bekapit.” ");
INSERT INTO bccl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Á mard shot o gón Yahudián gwashti: “Á ke maná rakkénti, Issá at.” ");
INSERT INTO bccl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Yahudián Issá ázára rasént, chiá ke áiá é dhawlén kár, Shabbatay róchá kortant. ");
INSERT INTO bccl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Bale Issáyá gón áyán gwasht: “Mani Pet angat kár kanagá ent, man ham kára kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Cha é gappán, Yahudi pa áiay koshagá tézáster butant. Chiá ke Shabbatay hokmay próshagá abéd, áiá Hodá ham wati jenday Pet zánt. É dhawlá, watá gón Hodáyá barábari kort. ");
INSERT INTO bccl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Gorhá Issáyá gwasht: “Báwar kanét ke Chokk watsar hech káré korta nakant, Petay kárána gendit o áyáni randgiriá kant. Har káré ke Peta kant, Chokk ham hamá kárá kant. ");
INSERT INTO bccl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Chiá ke Petá Chokk dóst ent o harché ke wata kant, Chokká ham sója dant. Áiá dega masterén kár ham pésha dárit tán shomá hayrán bemánét. ");
INSERT INTO bccl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Anchosh ke Pet mordagán zendaga kant o áyán zenda bakshit, Chokk ham harkasá ke wat zendag kanag belóthit, áiá zendaga kant. ");
INSERT INTO bccl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pet hechkaséay sará shawr o hokmé naborrit, áiá wati dádrasiay sajjahén ehtiár Chokkay dastá dátagant, ");
INSERT INTO bccl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","tán sajjahén mardom hamá dhawlá ke Petá ezzata dayant Chokká ham ezzat bedayant. Kasé ke Chokká béezzata kant, Petá ham ke áiay rah dayók ent béezzata kant. ");
INSERT INTO bccl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Shomárá rásténa gwashán, harkas mani gappán beshkont o mani rah dayókay sará imán byárit, namiránén zenday wáhonda bit o hechbar mayáriga nabit, bezán á cha marká rakketag o namirán butag. ");
INSERT INTO bccl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Báwar kanét, wahdé kayt o anchosh ent ke á wahd annun bongéj butag, mordag Hodáay Chokkay tawárá eshkonant o harkas ke beshkont padá zendaga bit. ");
INSERT INTO bccl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Chiá ke hamá dhawlá ke Pet zendmánay sarchammag ent, wati Chokká ham é wák o twáni dátag ke zendmánay sarchammag bebit. ");
INSERT INTO bccl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Dádrasiay ehtiári áiay dastá dátag, chiá ke Ensánay Chokk ent. ");
INSERT INTO bccl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Cha eshiá hayrán o habakkah mabét, wahdé kayt ke sajjahén mordag áiay tawárá eshkonant o cha wati kabrán dara káyant, nékkár pa namiránén zendá rawant o badkár, mayárig bayag o sarzaneshay jágahá. ");
INSERT INTO bccl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Man watsar káré korta nakanán, wati eshkotagénáni sará shawr o hokma borrán o mani dádrasi barhakk ent. Parchá ke wati delay wáhagáni sarjam kanagay padá naán, wati rah dayókay wáhagáni sarjam kanagay randá án. ");
INSERT INTO bccl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Agan man wati bárawá wat gwáhi bedayán, mani gwáhiá ehtebár o arzeshé nabit. ");
INSERT INTO bccl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Bale degaré hastent ke mani bárawá gwáhia dant o mana zánán ke áiay gwáhi mani bárawá báz porehtebár ent. ");
INSERT INTO bccl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Shomá wati kásed Yahyáay kerrá rawán dátant o áiá ham pa mani rástiá gwáhi dát. ");
INSERT INTO bccl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Mardománi gwáhiá mana nalóthán, pa shomay rakkénagá é habarána gwashán. ");
INSERT INTO bccl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yahyá, cherágéay dhawlá rók o drapshán at, shomárá ham tán gwandhén wahdéá áiay nuray chérá shádmáni dósta but. ");
INSERT INTO bccl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Bale maná cha Yahyáyá masterén sháhed hast. Hamé kár ke Petá mani dastá dátagant ke sarjamesh bekanán o manesha kanán wat mani sháhed ant ke maná Petá rawán dátag. ");
INSERT INTO bccl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Hamá Petá ke maná rawán dátag, hamá wat mani gwáh o sháhed ent. Shomá hechbar á nadistag o áiay tawár naeshkotag. ");
INSERT INTO bccl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Áiay habarán shomay delá jáh nést, chiá ke shomá áiay rawán dátagénay sará báwara nakanét. ");
INSERT INTO bccl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Pákén Ketábán patth o póla kanét o wánét, hayála kanét ke áyáni tahá namiránén zend hastent, bale hamé Pákén Ketáb pa man gwáhia dayant. ");
INSERT INTO bccl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Shomá nalóthét mani kerrá byáét ke shomárá abadmánén zend bedayán. ");
INSERT INTO bccl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Man mardománi dátagén shán o sharapá nazurán. ");
INSERT INTO bccl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Man shomárá jáha kárán o zánán ke Hodáay mehr shomay delá néstent. ");
INSERT INTO bccl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Man pa wati Petay námá átkagán o shomá maná namannét, bale agan kasé watsar byayt, áiá mannét o wasshátka kanét. ");
INSERT INTO bccl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Shomá cha yakdegará mazani o ezzata zurét o á ezzat ke cha Hodáay némagá kayt, áiay shóházá naét. Gorhá chón imán áworta kanét? ");
INSERT INTO bccl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Gomán makanét ke man Petay démá shomárá mayáriga kanán. Degaré, bezán hamá Mussá ke cha áiá ométwár ét, á shomárá mayáriga kant. ");
INSERT INTO bccl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Agan shomárá pa Mussáyá báwar butén, pa manó ham imána áwort, chiá ke áiá mani bárawá nebeshtag. ");
INSERT INTO bccl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Bale wahdé shomárá áiay nebeshtagénáni sará imán nést, mani habarán chón báwara kanét?” ");
INSERT INTO bccl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Randá, Issá Jalilay mazangwarmay á dastá shot, ke Teberiahay gwarm ham gwashaga bit. ");
INSERT INTO bccl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Mardománi mazanén rombé áiay randá gón kapt, chiá ke áyán cha Issáyá nádráháni drahbakshiay ajabbatén nesháni distagatant. ");
INSERT INTO bccl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Gorhá Issá kóhéay sará shot o gón wati moridán hamódá nesht. ");
INSERT INTO bccl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Yahudiáni Sargwazay aid nazzik at. ");
INSERT INTO bccl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Wahdé Issáyá wati chapp o chágerd cháret, disti ke mardománi mocchié dém pa áiá pédák ent. Gón Piliposá gwashti: “Nán cha kojá bezurén ke é mardom warák bwarant?” ");
INSERT INTO bccl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Issáyá é habar pa áiay emtehán o chakkásagá gwasht, wat zánti ché bekant. ");
INSERT INTO bccl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Piliposá gwasht: “Dosad dináray nán ham bassa nabit, toré harkas kammok ham bwárt.” ");
INSERT INTO bccl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Cha áiay moridán yakkéá ke námi Andriás at o Shamun Petrosay brát at, gwasht: ");
INSERT INTO bccl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Yak bachaké hamedá ent ke panch jawén nagan o do máhigi gón, bale pa rombé mardomá ché bant?” ");
INSERT INTO bccl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Issáyá gwasht: “Mardomán benendárénét.” Ódá bázén káh o sabzagé rostagat, mardom neshtant. Cha áyán kamm o gésh panch hazár mardén atant. ");
INSERT INTO bccl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Issáyá nagan zortant, Hodáay shogri gept o neshtagén mardománi sará bahri kortant. Máhig ham anchosh, harkasá haminchok ke lóthet dáti. ");
INSERT INTO bccl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wahdé sajjahén sér butant, gón moridán gwashti: “Náni thokkorán o mantagén máhigán mocch o yakjáh kanét ke zawál mabant.” ");
INSERT INTO bccl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Gorhá nánesh mocch o yakjáh kortant, ke cha á panchén jawén naganáni thokkorán, dwázdah sapt porr but. ");
INSERT INTO bccl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Mardomán ke Issáay é mójezah o ajabbatén nesháni dist, gwashtesh: “Pa del é hamá wádah dátagén nabi ent ke báyad ent yak róché jaháná byayt.” ");
INSERT INTO bccl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Bale wahdé Issáyá zánt mardoma lóthant pa zór áiá bebarant o bádsháh bekanant, gorhá cha mardomán dur but o tahná kóhá shot. ");
INSERT INTO bccl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Róchay érnendá, morid dém pa gwarmá shotant. ");
INSERT INTO bccl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Bójigá neshtant o gwarmay á dastá, dém pa Kaparnáhumá ráh geptant. Tahár butagat o Issá angat áyáni kerrá nayátkagat. ");
INSERT INTO bccl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Trondén gwáté ham kasshagá at o chawl o mawj chest butant. ");
INSERT INTO bccl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wahdé kesás panch tán shash kilumitar démá shotant, distesh ke Issá ápay sará gám janán, dém pa bójigá pédák ent. Áyán torset. ");
INSERT INTO bccl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Bale Issáyá gwasht: “Matorsét, é man án.” ");
INSERT INTO bccl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Lóthetesh áiá bójigá byárant o anchosh ke á swár but bójig menzelá raset. ");
INSERT INTO bccl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","É dega róchá, hamá mardom ke gwarmay á démá mantagatant, zántesh cha hamá bójigá abéd ke morid swár butagatant, dega bójigé ódá néstat. Issá áiay tahá naat o morid bé áiá shotagatant. ");
INSERT INTO bccl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Randá, dega lahtén bójig cha Teberiahá, hamá jágahá átk o raset ke ódá Hodáwandén Issáyá Hodáay shogr geptagat o mardomán nán wártagat. ");
INSERT INTO bccl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wahdé mardomán dist ke na Issá ódá ent o na áiay morid, Issáay shóházá, bójigán swár butant o dém pa Kaparnáhumá shotant. ");
INSERT INTO bccl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wahdé Issáesh gwarmay á dastá dist, gwashtesh: “Ostád! Taw kadi edá átkagay?” ");
INSERT INTO bccl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Issáyá áyáni passawá gwasht: “Báwar kanét, shomá pa eshiá mani randá nakaptagét ke mójezah o ajabbatén nesháni distagant, paméshká átkagét ke nánó wárt o sérláp butét. ");
INSERT INTO bccl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bale pa é zawál bayókén waráká johd makanét, pa hamá dáemi waráká johd bekanét ke namiránén zenda bakshit, hamá waráká ke Ensánay Chokk shomárá dant. Chiá ke Hodáén Petá áiay sará wati mannagay mohr jatag.” ");
INSERT INTO bccl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Gorhá jostesh kort: “May kár o zemmahwári chi ent? Hamá kárán ke Hodá cha má lóthit, áyán chón purah o sarjam bekanén?” ");
INSERT INTO bccl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Issáyá passaw dát: “Á kárá ke Hodá cha shomá lóthit, esh ent: Hamá kasay sará imán byárét ke Hodáyá ráh dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Áyán gwasht: “Chónén ajabbatén nesháni pésha dáray ke begendén o tai sará imán byárén? Ché kanay? ");
INSERT INTO bccl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","May pet o pirokán gyábáná mann wárt, anchosh ke Pákén Ketába gwashit: ‘Áiá cha ásmáná, nán rawán dát ke bwarant’.” ");
INSERT INTO bccl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Gorhá Issáyá gón áyán gwasht: “Báwar kanét, á nán ke cha ásmáná ér átkagat Mussáyá shomárá nadátagat, é mani Pet ent, ke cha ásmáná asligén náná shomárá bakshit. ");
INSERT INTO bccl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Chiá ke Hodáay nán hamá ent ke cha ásmáná ér átkag o jaháná zendmána dant.” ");
INSERT INTO bccl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nun gón áiá gwashtesh: “Oo wájah! É náná harwahd márá beday.” ");
INSERT INTO bccl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Issáyá gwasht: “Hasti o zenday nán, man án. Harkas mani kerrá kayt hechbar shodiga nabit. Harkas mani sará báwar bekant hechbar tonniga nabit. ");
INSERT INTO bccl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Bale hamá dhawlá ke gwashton, shomá maná distag o angat imána nayárét. ");
INSERT INTO bccl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Á sajjahénán ke Pet maná bakshit dém pa mana káyant, harkas ke mani kerrá kayt, man áiá cha wat dura nakanán. ");
INSERT INTO bccl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Man cha ásmáná wati wáhagáni sarjam kanagá ér nayátkagán, átkagán tán wati rah dayókay wáhagán sarjam bekanán. ");
INSERT INTO bccl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mani rah dayókay wáhag esh ent, hamá ke maná dátaganti, yakké ham cha mani dastá marawt o áherzamáná áyán padá zendag bekanán. ");
INSERT INTO bccl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Chiá ke mani Petay wáhag hamesh ent, harkas ke Chokká gendit o áiay sará imána kárit, namiránén zenday wáhond bebit o man áherzamáná áiá zendaga kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Gorhá Yahudi pa gelag o norondhag dar átkant, chiá ke áiá gwashtagat: “Man hamá nán án ke cha ásmáná ér átkag.” ");
INSERT INTO bccl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Áyán gwasht: “É mard, hamé Issopay chokk Issá naent ke má áiay pet o mátá zánén? Gorhá chóna gwashit ke ‘man cha ásmáná ér átkagán’?” ");
INSERT INTO bccl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Issáyá áyáni passawá gwasht: “Inchok manorondhét o shekáyat makanét. ");
INSERT INTO bccl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kass mani kerrá átka nakant tán hamá Pet ke maná ráhi dátag, áiá mani némagá machekkit o mayárit. Gorhá, man áiá áherzamáná zendaga kanán. ");
INSERT INTO bccl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Nabiáni Ketábán nebisag butag: ‘Sajjahén cha Hodáyá dars o sabaka gerant.’ Harkas ke Petay habarán beshkont o cha áiá sabak begipt, mani kerrá kayt. ");
INSERT INTO bccl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Chosh ent ke kassá Pet nadistag. Tahná hamáiá Pet distag ke cha Hodáay némagá átkag. ");
INSERT INTO bccl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Báwar kanét, á ke imána kárit, namiránén zenday wáhonda bit. ");
INSERT INTO bccl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Hasti o zenday nán, man án. ");
INSERT INTO bccl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Shomay pet o pirénán gyábáná mann wárt o mortant. ");
INSERT INTO bccl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Bale man hamá nánay bárawá habar kanagá án ke cha ásmáná ér átkag. Agan yakké áiá bwárt, hechbara namerit. ");
INSERT INTO bccl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Man hamá zend bakshókén nagan án ke cha ásmáná ér átkag, harkas ke é náná bwárt, tán abad zendaga mánit. É náná ke mana dayán, mani jenday jesm o ján ent ke áiá pa jahánay mardománi zendá nadra kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nun, Yahudián pa jérhah o dapják watmánwatá gwasht: “É mard chón wati jesm o jáná dant, ke mái bwarén?” ");
INSERT INTO bccl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Issáyá gwasht: “Shomárá rásténa gwashán, agan Ensánay Chokkay jesm o jáná, bezán mani jesm o jáná mawarét o mani hóná manóshét, shomá pa namiránén zendá narasét. ");
INSERT INTO bccl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Harkas mani jesm o jáná bwárt o mani hóná benóshit, namiránén zenday wáhonda bit o áherzamáná man áiá zendaga kanán. ");
INSERT INTO bccl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Chiá ke mani jesm o ján, asligén warák o mani hón, asligén zendáp ent. ");
INSERT INTO bccl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Harkas mani jesm o jáná bwárt o mani hóná benóshit, á mani arwáh o jabiná mánit o man áiaygá. ");
INSERT INTO bccl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Hamé paymá ke namiránén Petá maná rawán dát o man cha áiay némagá zendag án, harkas mani jesm o jáná bwárt, cha mani némagá zendaga mánit. ");
INSERT INTO bccl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","É nán ke cha ásmáná ér átkag, á nán naent ke shomay pet o pirénán wárt o mortant, chiá ke harkas é náná bwárt, tán abad zendaga mánit.” ");
INSERT INTO bccl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Issáyá é chizz hamá wahdá dars o sabak dátant, ke Kaparnáhumay kanisahá at. ");
INSERT INTO bccl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bázén moridéá é habaráni eshkonagá rand, gwasht: “É sabak sakk grán ant, kay eshán manneta kant?” ");
INSERT INTO bccl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Wahdé Issáyá máret ke áiay morid, cha é habará nálant o shekáyata kanant, gwashti: “Shomárá é habara tawrénit? ");
INSERT INTO bccl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Agan Ensánay Chokká begendét ke pa wati awali jágahá borzáda rawt, gorhá ché kanét? ");
INSERT INTO bccl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","É Ruh ent ke zendmána dant, jesmá sutt o páedagé nést. É habar ke man gón shomá gwashtant, Ruh o zend ant. ");
INSERT INTO bccl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Bale cha shomá lahténá báwar nést.” Chiá ke Issáyá á mardom ke báwaresh néstat cha béhá pajjáha áwortant o zánti kay ent hamá ke randá áiá dróhit o dozhmenáni dastá dant. ");
INSERT INTO bccl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Gorhá gwashti: “Paméshká man gwasht ke kass mani kerrá átka nakant, tán wahdé ke mani Pet imánay sawgátá áiá mabakshit.” ");
INSERT INTO bccl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Randá, bázén moridéá Issá yalah dát o áiay hamráhi nakort. ");
INSERT INTO bccl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Gorhá Issáyá cha wati dwázdahén moridán jost kort: “Bárén, shomá ham maná yalaha kanét?” ");
INSERT INTO bccl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Shamun Petrosá passaw dát: “Oo Hodáwand! Kai kerrá berawén? Namiránén zenday gál o habar tai kerrá ant o ");
INSERT INTO bccl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","márá báwar ent o zánén ke taw Hodáay hamá Pákén ay.” ");
INSERT INTO bccl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Issáyá gwasht: “Man, shomá dwázdahén gechén nakortant? Anchosh ham zánán ke cha shomá yakké, eblisé.” ");
INSERT INTO bccl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Áiay maksad Shamunay chokk, Yahudá Eskaryuti at. Chiá ke á cha dwázdahén moridán yakké at o Issái dróhagi o dozhmenáni dastá dayagi at. ");
INSERT INTO bccl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Randá, Issáyá Jalilá tarr o tába kort. Yahudi áiay kóshay randá atant, paméshká nalótheti Yahudiahá bemánit. ");
INSERT INTO bccl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Anchosh ke Yahudiáni kápáráni aid nazzik but, ");
INSERT INTO bccl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Issáay brátán gón áiá gwasht: “É jáhá bell o Yahudiahá beraw, tán hamá kárán ke taw kanay, tai morid begendant. ");
INSERT INTO bccl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kasé ke námdária lóthit, pa chérokái kára nakant. Taw ke é kárána kanay, bell ke sajjahén donyá tará begendit.” ");
INSERT INTO bccl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Chiá ke brátán ham pa áiá báwar néstat. ");
INSERT INTO bccl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Issáyá gón áyán gwasht: “Angat á wahd pa man narasetag, bale pa shomá har wahd sharr ent. ");
INSERT INTO bccl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Donyá cha shomá naprata nakant, bale cha man naprata kant, chiá ke man áiay bárawá gwáhia dayán ke áiay kár sell o gandah ant. ");
INSERT INTO bccl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Shomá pa é aidá berawét, man annun é aidá nayáyán, chiá ke mani wahd angat narasetag.” ");
INSERT INTO bccl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Issáyá é habar gón áyán gwasht o Jalilá mant. ");
INSERT INTO bccl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Issáay brát ke pa aidá Urshalimá shotant, randá áiay jend ham hamódá shot, bale mardománi chamdidá nashot, chérokái shot. ");
INSERT INTO bccl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Aiday róchán, Yahudi áiay shóházá atant o jost o porsesha kort ke “á kojá ent?” ");
INSERT INTO bccl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Áiay bárawá mardománi nyámá pa chérokái bázén gwash o góé hastat, lahtén gwashagá at: “Á sharrén mardé.” Dega lahtén gwashagá at: “Mardomána répénit o gomráha kant.” ");
INSERT INTO bccl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Bale cha Yahudiáni torsá, kasséá sarzáherá hecch nagwasht. ");
INSERT INTO bccl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Aiday nyámi róchán, Issá mazanén parasteshgáhá shot o dars o sabak dayagá goláésh but. ");
INSERT INTO bccl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yahudián gón hayraté gwasht: “É mardá nawántag, inchok zántkári cha kojá áwortagi?” ");
INSERT INTO bccl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Issáyá áyáni passawá darráént: “É chizzán ke man sabaka dayán mani naant, cha mani rah dayókay némagá ant. ");
INSERT INTO bccl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Harkas ke belóthit Hodáay wáhagán sarjam bekant, zánt ke mani sabak Hodáayg ant yá man cha wat habara kanán. ");
INSERT INTO bccl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Harkas ke watsar habara kant, pa wati mazaniay pésh dáragá habara kant. Bale á kas ke wati rah dayókay shán o shawkatay lóthóka bit, tachkén mardomé o áiá nárásti nést. ");
INSERT INTO bccl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Záná, Mussáyá Sharyat shomárá nadát, hamá Sharyat ke cha shomá kass áiay sará kár nakanagá ent? Pa ché lóthét maná bekoshét?” ");
INSERT INTO bccl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Mardomán gwasht: “Tará jenn per ent, kay tará koshit?” ");
INSERT INTO bccl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Issáyá áyáni passawá gwasht: “Man tahná yak káré kortag o shomá sajjahén chó habakkah o hayrán mantagét. ");
INSERT INTO bccl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mussáyá chokkáni sonnat kanag shomárá dát, harchont ke é kár cha Mussáyá bongéj nabutagat o cha kawmay pet o pirénán at o shomá Shabbatay róchá, wati mardénchokkán sonnata kanét. ");
INSERT INTO bccl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nun agan pa Mussáay Sharyatay napróshagá shomá Shabbatay róchá mardénchokkán sonnata kanét, chiá mani sará zahr geptagét, ke Shabbatay róchá yak mardomé pa sarjami drahbakshion kortag? ");
INSERT INTO bccl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Záherá machárét o shawr maborrét, wati hokm o shawrán pa ensáp bekanét.” ");
INSERT INTO bccl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Gorhá Urshalimay lahtén mardom gwashagá at: “É hamá naent ke áiay koshagay randá ant? ");
INSERT INTO bccl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Bechárét, tachkátachk o sarzáherá habar kanagá ent o áiá heccha nagwashant, bárén rájay sarók deljam butagant ke é hamá wádah dátagén Masih ent? ");
INSERT INTO bccl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Má zánén ke é mard cha kojám hand o damagá ent, bale wahdé Masih jáha jant, hechkasa nazánt á cha kojá kayt.” ");
INSERT INTO bccl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Paméshká, wahdé Issáyá mazanén parasteshgáhay tahá sabaka dát, gón borzén tawáré gwashti: “Shomá maná pajjáha kárét o zánét ke cha kojá án, bale man watsar nayátkagán, mani rah dayók hamá rástén Hodá ent o shomá áiá nazánét. ");
INSERT INTO bccl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Man áiá zánán, chiá ke cha áiay némagá átkagán o hamáiá maná ráh dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Hamé wahdá, áyán lóthet Issáyá dazgir bekanant, bale hechkasá áiay némagá dast nashahárt, parchá ke angat áiay wahd narasetagat. ");
INSERT INTO bccl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bale bázénéá áiay sará imán áwort o gwasht: “Wahdé Masih jáha jant, cha é mardá géshterén mójezah o ajabbatén neshánia kárit?” ");
INSERT INTO bccl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Á gapp o habar ke mardomán chérokái Issáay bárawá gwashtant, Parisián eshkotant. Gorhá mazanén dini péshwá o Parisián pa Issáay dazgir kanagá, parasteshgáhay sepáhig rawán dátant. ");
INSERT INTO bccl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Á wahdi Issáyá gwasht: “Man pa yak kammokén wahdéá shomay nyámá án o randá wati rah dayókay kerrá rawán. ");
INSERT INTO bccl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Shomá mani shóházá gardét, bale maná wadi korta nakanét o á jáhá ke mana rawán, shomá átka nakanét.” ");
INSERT INTO bccl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Gorhá Yahudián gón yakdegará gwasht: “Kojá rawaga lóthit ke má áiá dar gétka nakanén. Bárén, hamá Yahudiáni kerrá rawt, ke Yunániáni nyámá sheng o sháng ant o Yunánián ham sabaka dant? ");
INSERT INTO bccl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","É habar ke á gwashit: ‘Shomá mani shóházá gardét, bale maná wadi korta nakanét’ o ‘á jáhá ke mana rawán shomá átka nakanét,’ áiay é habaray maksad chi ent?” ");
INSERT INTO bccl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Aiday áheri o masterén róchá, Issá óshtát o pa borztawári gwashti: “Agan kasé tonnig ent, mani kerrá byayt o áp benóshit. ");
INSERT INTO bccl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Hamá dhawlá ke Hodáay Pákén Ketába gwashit, harkas ke mani sará báwar bekant, shahjóáni rawánén zendáp cha áiay daruná rombit o tachána bit.” ");
INSERT INTO bccl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","É habar áiá Hodáay Pákén Ruhay bárawá gwashtant ke báyad ent áiay báwarmandán dayag bebit. Bale Issá angat pa shán o shawkat narasetagat, paméshká taningah Pákén Ruh bakshag nabutagat. ");
INSERT INTO bccl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Gón é habaráni eshkonagá, lahtén mardom gwashagá at: “Pa del, é mard hamá wádah dátagén nabi ent.” ");
INSERT INTO bccl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Dega lahtén gwashagá at: “É Masih ent.” Bázénéá chosh ham gwasht: “Masih cha Jalilá jáha jant? ");
INSERT INTO bccl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Záná, Pákén Ketába nagwashit ke Masih báyad ent cha Dáuday nasl o padréchá bebit o cha áiay shahr, Bayt-Lahemá, byayt?” ");
INSERT INTO bccl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Hamé dábá mardománi nyámá nátepákié kapt. ");
INSERT INTO bccl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Lahténá á dazgir kanag lóthet, bale hechkasá áiay némagá dast nashahárt. ");
INSERT INTO bccl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Randá, parasteshgáhay sepáhig per tarretant o mazanén dini péshwá o Parisiáni kerrá átkant. Áyán cha sepáhigán jost kort: “Shomá chiá Issá gón wat nayáwortag?” ");
INSERT INTO bccl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sepáhigán gwasht: “Tán é wahdi hechkasá é marday dhawlá habar nakortag.” ");
INSERT INTO bccl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Parisián gwasht: “Shomá ham gomráh butagét? ");
INSERT INTO bccl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Cha kawmay sarók o Parisián yakkéá áiay sará báwar kortag? ");
INSERT INTO bccl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Bale anchosh ent, mardománi á romb ke cha Sharyatá násarpad ent, nálat butagéné.” ");
INSERT INTO bccl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikudimusá, ke wat cha Parisián yakké at o péshá Issáay kerrá átkagat, gwasht: ");
INSERT INTO bccl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bárén, Sharyat márá ejázata dant ke kaséay habaráni eshkonag o káráni zánagá pésar, áiá mayárig bekanén?” ");
INSERT INTO bccl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Áiay passawá gwashtesh: “Taw ham cha Jalilay mardomán ay? Wat patth o pól kan o bechár, hechbar nabié cha Jalilá jáha najant.” ");
INSERT INTO bccl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Randá, á sajjahén wati lógán shotant. ");
INSERT INTO bccl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Bale Issá Zaytunay kóhá shot. ");
INSERT INTO bccl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","É dega sabáhá, padá mazanén parasteshgáhá átk. Mardom áiay chapp o chágerdá mocch butant. Issá nesht o áyáni sabak dayagá goláésh but. ");
INSERT INTO bccl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Hamé wahdá Sharyatay zánóger o Parisián, janéné mardománi nyámá áwort ke zenáay wahdá gerag butagat. ");
INSERT INTO bccl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Gón Issáyá gwashtesh: “Oo ostád! É janén zenáay sará gerag butag. ");
INSERT INTO bccl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Sharyatay tahá, Mussáyá márá hokm dátag ke é paymén janén báyad ent sengsár kanag bebant. Bale taw ché gwashay?” ");
INSERT INTO bccl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Áyán lóthet Issá chizzé begwashit tán áiá dámá dawr bedayant o mayárig bekanant, bale Issá nesht o gón lankoká zeminay sará chizzé nebisagá lagget. ");
INSERT INTO bccl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Gón kast o kénagé lóthetesh ke á passaw bedant. Gorhá Issáyá wati sar borz kort o gwashti: “Agan áiá sengsár kanaga lóthét, awali sengá báyad ent hamá bejant ke áiá wat hech gonáh nakortag.” ");
INSERT INTO bccl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Padá nesht o zeminay sará chizzé nebisagá goláésh but. ");
INSERT INTO bccl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Gón é habaráni eshkonagá, kawmay péshwá, awalá pirén o randá sajjahén, dar kapt o shotant. Tahná Issá o hamá janén pasht kaptant. ");
INSERT INTO bccl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nun Issá óshtát o gón janéná gwashti: “Oo bánok! Mardom kojá shotant? Pa tai mayárig kanagá yakké ham namant?” ");
INSERT INTO bccl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Janéná gwasht: “Na wájah! Kass namant.” Issáyá gwasht: “Man ham tará mayáriga nakanán, beraw, bale dega baré gonáh makan.” ");
INSERT INTO bccl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Issáyá padá gón mardomán gwasht: “Man jahánay rozhn o nur án. Kasé ke mani randgiriá kant, tahárókiá gesar o sargardána nabit, zenday rozhnáiay wáhonda bit.” ");
INSERT INTO bccl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisián gón áiá gwasht: “Taw wati bárawá wat sháhedia dayay, gorhá tai sháhediá arzesh o ehtebáré nést.” ");
INSERT INTO bccl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Issáyá áyáni passawá gwasht: “Man pa wati jendá toré wat sháhedi bedayán, mani sháhediá ehtebár hast, chiá ke mana zánán cha kojá átkagán o kojá rawán, bale shomá nazánét man cha kojá átkagán o kojá rawán. ");
INSERT INTO bccl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Shomá gón ensáni chammé chárét o shawr o hokma borrét. Bale man hechkaséay bárawá shawra naborrán. ");
INSERT INTO bccl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Agan shawré ham beborrán, mani hokm o shawr barhakkén shawré bit, chiá ke é káray tahá tahná naán, hamá Pet ke maná ráhi dátag gón man hamráh ent. ");
INSERT INTO bccl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Shomay Sharyatá é ham nebisag butag ke do mardomay gwáhiá ehtebár hast. ");
INSERT INTO bccl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yakké mani jend ent ke pa wat sháhedia dayán, domi hamá Pet ent ke maná ráhi dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Áyán gwasht: “Tai pet kojá ent?” Issáyá passaw dát: “Shomá na maná zánét o na mani Petá, agan shomá maná bezántén, mani Petó ham zántagat.” ");
INSERT INTO bccl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Issáyá é habar hamá wahdá kortant ke mazanén parasteshgáhá, hayráti zarráni pétiay nazziká, dars o sabak dayagá at. Kasséá pa áiay dazgir kanagá dast nashahárt, chiá ke angat áiay wahd narasetagat. ");
INSERT INTO bccl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Padá Issáyá gón áyán gwasht: “Mana rawán o shomá mani shóházá gardét, bale wati gonáháni tahá merét o á jáhá ke mana rawán, shomá átka nakanét.” ");
INSERT INTO bccl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Yahudi gón yakdomiá gwashagá laggetant: “Wahdé gwashit: ‘Á jáhá ke mana rawán shomá átka nakanét,’ cha eshiá áiay maksad chi ent? Balkén lóthit watá bekoshit?” ");
INSERT INTO bccl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Issáyá gón áyán gwasht: “Shomá cha é jahli jaháná ét o man cha borzádi jaháná, shomá cha é donyáyá ét o man cha é donyáyá naán. ");
INSERT INTO bccl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Paméshká shomárá gwashán ke wati gonáháni tahá merét. Agan imán mayárét Man Hamá Án ke gwashán, wati gonáháni tahá merét.” ");
INSERT INTO bccl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Áyán jost kort: “Taw kay ay?” Issáyá passaw dát: “Man hamá án ke cha péshá ham shomárá gwashton. ");
INSERT INTO bccl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Maná shomay bárawá bázén chizzé pa gwashag o shawr borragá hastent, bale mani rah dayók hamá rástén ent o man har chizzé ke cha áiá eshkotag pa jaháná darshána kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Áyán nazánt Petay bárawá habar kanagá ent. ");
INSERT INTO bccl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Paméshká Issáyá gwasht: “Wahdé shomá Ensánay Chokk cha zeminá chest kort, gorhá zánét ke Man Hamá Án o watsar káré nakanán, hamá dhawlá ke Petá sój dátag, hamá dhawlá habara kanán. ");
INSERT INTO bccl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Mani rah dayók gón man ent, áiá maná tahná o éwak naeshtag, chiá ke man modám hamá kárána kanán ke áiá gal o shádána kanant.” ");
INSERT INTO bccl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Cha é habaráni eshkonagá, bázénéá Issáay sará báwar kort. ");
INSERT INTO bccl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Randá, Issáyá gón hamá Yahudián ke áiay sará báwarmand butagatant, gwasht: “Agan mani habaráni sará bóshtét, pa del mani morid ét. ");
INSERT INTO bccl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Á wahdi rástiá zánét o rásti shomárá ázáta kant.” ");
INSERT INTO bccl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Áyán gwasht: “Má Ebráhémay awlád én o hechbar kaséay golám nabutagén. Gorhá taw chóna gwashay ke ‘shomá ázáta bét’?” ");
INSERT INTO bccl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Issáyá gwasht: “Báwar kanét, á kas ke gonáha kant, gonáhay bandig o golám ent o ");
INSERT INTO bccl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","golám dáemá wájahay lógá namánit, bale chokk dáemá mánit. ");
INSERT INTO bccl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Gorhá, agan Chokk shomárá ázát bekant pa rásti o pakká ázáta bét. ");
INSERT INTO bccl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Zánán ke shomá Ebráhémay awlád ét, bale paméshká ke mani sabakán shomay delá jágah nést, mani koshagay randá ét. ");
INSERT INTO bccl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Man hamá chizzáni bárawá gappa kanán ke wati Petay bárgáhá distagant o shomá hamá chizzáni sará kára kanét ke cha wati petá sabak geptagant.” ");
INSERT INTO bccl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Áyán darráént: “May pet Ebráhém ent.” Issáyá gón áyán gwasht: “Agan shomá Ebráhémay chokk buténét, hamáiay ráhó zortagat. ");
INSERT INTO bccl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Shomá zánét, man hamá rásti ke cha Hodáyá eshkotag gón shomá gwasht. Bale angat mani koshagay randá ét. Ebráhémá choshén kár nakortagat. ");
INSERT INTO bccl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Shomá wati petay kárán barjáha dárét.” Áyán gwasht: “Má bépet o kihorr naén, márá yak peté hast, á ham Hodáay jend ent.” ");
INSERT INTO bccl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Issáyá gwasht: “Agan Hodá shomay pet butén, shomá maná ham dóst dáshtagat, chiá ke man cha hamáiay némagá átkagán o shomay nyámá án. Man watsar nayátkagán, hamáiá maná dém dátag. ");
INSERT INTO bccl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pa ché mani habarán sarkecha nawarét? Paméshká ke shomárá é habaráni eshkonagay twán nést. ");
INSERT INTO bccl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Shomá wati pet, bezán eblisay chokk ét o hamáiay morád o wáhagáni sará kár kanaga lóthét. Á cha bon o béhá hónigé o cha rástiá dur o zebahr ent, chiá ke áiá hech rásti mán nést. Wahdé dróga bandit, wati bon o béhá rawt, chiá ke drógbandé o sajjahén drógáni pet ent. ");
INSERT INTO bccl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Bale paméshká mani sará báwara nakanét ke rástiá gón shomá gwashán. ");
INSERT INTO bccl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Cha shomá kay maná gonáhé per basta kant? Gorhá, agan man rásténa gwashán, pa ché báwara nakanét? ");
INSERT INTO bccl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Á kas ke Hodái ent, Hodáay habará gósha dárit. Shomá Hodáay habará gósha nadárét, chiá ke Hodái naét.” ");
INSERT INTO bccl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yahudián áiay passawá darráént: “Má nagwasht ke taw cha Sámerián ay o tará jenn per ent?” ");
INSERT INTO bccl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Issáyá gwasht: “Maná jenn per nést, wati Petá báz ezzata dayán, bale shomá maná béezzata kanét. ");
INSERT INTO bccl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Man pa wat mazania nalóthán, á degaré ke maná sharap o mazania dant o wat dádrasia kant. ");
INSERT INTO bccl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Allam bezánét agan kasé mani habará begipt, hechbara namerit.” ");
INSERT INTO bccl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Yahudián gón áiá gwasht: “Nun márá báwar ent ke tará jenn per. Ebráhém o sajjahén nabi mortant, bale taw gwashay: ‘Harkas mani habará bezurit hechbara namerit.’ ");
INSERT INTO bccl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Záná, taw cha may pet Ebráhémá master ay? Á mort o sajjahén nabi ham mortant. Taw kay ay?” ");
INSERT INTO bccl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Issáyá passaw dát: “Agan man watá wat satá bedayán, é satáyá arzeshé nést, é mani Pet ent ke maná mazani o shawkata bakshit, hamá ke shomá áiá wati Hodá zánét. ");
INSERT INTO bccl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Angat áiá nazánét o pajjáha nayárét, bale man áiá zánán. Agan begwashán ke áiá nazánán, shomay dhawlá drógbanda bán, bale man áiá zánán o har chizzé ke á gwashit mana kanán. ");
INSERT INTO bccl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Shomay pet Ebráhém, pa hamé ométá gal o shádán at ke mani róchá begendit. Áiá dist o delshát but.” ");
INSERT INTO bccl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Yahudián gwasht: “Tará angat panjáh sál ham nabit, gorhá chón taw Ebráhém distag?” ");
INSERT INTO bccl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Issáyá gwasht: “Báwar kanét, Man Hamá Án ke cha Ebráhémá pésar butagán o hastán.” ");
INSERT INTO bccl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Áyán pa Issáay janagá seng o dhók chet, bale á cha mardománi chammá dur o andém but, mazanén parasteshgáhi esht o shot. ");
INSERT INTO bccl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Cha ráhéá gwazán, Issáyá yak pédáeshi kóré dist. ");
INSERT INTO bccl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Moridán cha áiá jost kort: “Oo ostád! É mard chiá kór pédá butag? Wat gonahkár ent yá áiay pet o mát?” ");
INSERT INTO bccl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Issáyá passaw dát: “Na áiay jend gonahkár ent, na pet o mát. Paméshká é dhawlá but ke Hodáay kár o zóráki gón áiá paddar o záher bebit. ");
INSERT INTO bccl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tánke róch ent, báyad wati rah dayókay kárán sarjam bekanén, shap ke bit gorhá kass káré korta nakant. ");
INSERT INTO bccl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Man, tán wahdé ke jaháná án, jahánay rozhnái án.” ");
INSERT INTO bccl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wahdé chosh gwashti, lebzi zeminá dawr dát o cha lebzá geli addh kort, kóray chammán per mosht o ");
INSERT INTO bccl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","gwashti: “Beraw, wati chammán Siluháay taláwagá beshód.” (Siluháay máná “dém dátagén” ent.) Gorhá á shot, chammi shoshtant, biná but o átk. ");
INSERT INTO bccl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Randá, hamsáheg o é dega mardom ke á mardesh cha pendhógeriay róchán pajjáh áwortagat, gwashagá laggetant: “É hamá naent ke neshtagat o pendhagá at?” ");
INSERT INTO bccl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Lahténá gwasht: “Hamá ent.” Dega lahténá gwasht: “Áiay hamrang o hamdróshom ent.” Á wat gwashagá at: “Man hamá mardom án.” ");
INSERT INTO bccl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Jostá atant: “Gorhá tai chamm chón biná butant?” ");
INSERT INTO bccl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Gwashti: “Hamá mard ke námi Issá ent, áiá gel tarr kort, mani chammán per mosht o gwashti ke Siluháay taláwagá berawán o chammán beshódán. Man chamm shoshtant o biná bután.” ");
INSERT INTO bccl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Gwashtesh: “Á mard kojá ent?” Gwashti: “Mana nazánán.” ");
INSERT INTO bccl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Hamá mard ke pésará kór at Parisiáni kerrá bortesh. ");
INSERT INTO bccl_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Shabbatay róch at ke Issáyá gel jórhéntagat o áiay chamm biná kortagatant. ");
INSERT INTO bccl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Nun Parisi ham cha áiá jostá atant: “Taw chón biná butay?” Mardá gwasht: “Áiá mani chamm gel per moshtant, man shoshtant o nun gendagá án.” ");
INSERT INTO bccl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Lahtén Parisiá gwasht: “É mard cha Hodáay némagá nayátkag, parchá ke Shabbatay rahbanday sará kára nakant.” Dega lahténá gwasht: “Gonahkárén mardomé chón é dhawlén ajabbatén nesháni pésh dáshta kant?” Á watmánwat kassh o chilléá kaptant. ");
INSERT INTO bccl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Padá cha hamá mardá jostesh kort ke pésará kór at: “É tai chamm atant ke áiá biná kortant, nun taw áiay bárawá ché gwashay?” Gwashti: “Nabié.” ");
INSERT INTO bccl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Yahudián báwar nakort ke á mard kór butag o annun biná ent, paméshká áiay pet o mátesh áwortant. ");
INSERT INTO bccl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Cha áyán jostesh kort: “É mard shomay chokk ent, hamá ke shomá gwashét pédáeshi kóré at? Gorhá nun chóna gendit?” ");
INSERT INTO bccl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Pet o mátá áyáni passawá gwasht: “Má zánén ke may chokk ent o kór pédá butag. ");
INSERT INTO bccl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Bale nazánén nun chóna gendit o kayá biná kortag. Cha áiay jendá jost begerét, rostag o tamánén mardé, wati habará wata kant.” ");
INSERT INTO bccl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Áiay pet o mátá cha Yahudián torset, paméshká é dhawlá passawesh dát. Parchá ke Yahudián cha péshá shawr kortagat, harkas bemannit ke Issá Masih ent, áiá cha kanisah o parasteshgáhán dara kanant. ");
INSERT INTO bccl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Paméshká á marday pet o mátá gwasht ke “cha áiá jost begerét, á wat rostag o tamánén mardé.” ");
INSERT INTO bccl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Domi randá, á mard ke pésará kór butagat padá áwort o gwashtesh: “Pa Hodáay námá sawgend bwar ke rásta gwashay, má zánén ke é mard, Issá, gonahkáré.” ");
INSERT INTO bccl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Áiá gwasht: “É mard gonahkáré yá na, mana nazánán, tahná yak chizzé zánán, ke man kór butagán o nun biná án.” ");
INSERT INTO bccl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Áyán jost kort: “Gón taw ché korti? Chón tai chammi biná kortant?” ");
INSERT INTO bccl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Passawi dát: “Man annun gón shomá gwasht, shomá gósh nadásht, pa ché lóthét padá beshkonét? Záná, shomá ham lóthét áiay morid bebét?” ");
INSERT INTO bccl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Gorhá á biná butagén mardesh zá o zakat kort o gwashtesh: “Taw wat áiay morid ay, má Mussáay morid én. ");
INSERT INTO bccl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Má zánén ke Hodáyá gón Mussáyá habar kortag, bale é marday bárawá nazánén ke cha kojá átkag.” ");
INSERT INTO bccl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nun á mardá áyáni passawá gwasht: “É ajabén habaré, áiá mani chamm biná kortagant o shomá nazánét á cha kojá átkag! ");
INSERT INTO bccl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Máshomá sajjahéna zánén ke Hodá gonahkáráni dwáyá gósha nadárit, hamáiay dwáyá gósha dárit ke Hodádósté o áiay wáhagáni sará kára kant. ");
INSERT INTO bccl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cha jahánay jórhénagá beger tán maróchi, eshkonag nabutag ke yakké pédáeshi kóré biná bekant. ");
INSERT INTO bccl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Agan é mard cha Hodáay némagá mayátkén, hech choshén kári korta nakort.” ");
INSERT INTO bccl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Áiay passawá gwashtesh: “Taw ke wat gonáhay chokk ay, márá sabaka dayay?” Gorhá á mardesh dar kort. ");
INSERT INTO bccl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Wahdé Issáyá eshkot biná butagén mardesh galléntag, á mardi dar gétk o gwashti: “Tará Ensánay Chokkay sará báwar ent?” ");
INSERT INTO bccl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Mardá darráént: “Oo wájah! Maná begwash, á kay ent ke áiay sará báwar bekanán?” ");
INSERT INTO bccl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Issáyá gwasht: “Taw á distag. Hamá ent ke gón taw habar kanagá ent.” ");
INSERT INTO bccl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Gwashti: “Oo Hodáwand! Imánon áwort” o Issáay pádán kapt. ");
INSERT INTO bccl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Gorhá Issáyá gwasht: “Man pa hokm borrag o dádrasiá é donyáyá átkagán, tánke kór biná bebant o biná kór.” ");
INSERT INTO bccl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Cha Parisián lahtén ke áiay chapp o chágerdá atant é gappesh eshkot o gwashtesh: “Tai maksad esh ent ke má kór én?” ");
INSERT INTO bccl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Issáyá gwasht: “Agan kór buténét shomárá mayáré per néstat, bale paméshká angat mayárig ét ke gwashét: ‘Má biná én.’ ");
INSERT INTO bccl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Báwar kanét, agan kasé cha pasáni gwásh o wárhay dapá mapoterit o cha dega némagé kopp bekant, bezán dozz o rahzané. ");
INSERT INTO bccl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Bale á kas ke cha gwáshay dapá rawt, pasáni shopánk ent. ");
INSERT INTO bccl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Negahpán, gwáshay dapá pa áiá pacha kant o pas áiay tawárá eshkonant. Á wati pasán pa nám gwánk o tawára jant o áyán dhanná bárt. ");
INSERT INTO bccl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Wahdé wati pasán dhanná bárt, wat pésara bit o pas áiay randá kapant, chiá ke áiay tawárá pajjáha kárant. ");
INSERT INTO bccl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Bégánagáni randá nakapant, cha áyána tachant, chiá ke bégánagáni tawárá pajjáha nayárant o nazánant.” ");
INSERT INTO bccl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Issáyá, é mesál pa áyán pésh kort, bale mardomán áiay maksad sarkech nawárt. ");
INSERT INTO bccl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Gorhá padá gwashti: “Báwar kanét, man pasáni gwáshay dap o darwázag án. ");
INSERT INTO bccl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Á sajjahén ke cha man o pésar átkagant dozz o rahzan atant o pasán áyáni tawár gósh nadásht. ");
INSERT INTO bccl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Man darwázag án, harkas ke cha mani ráhá begwazit, rakkit. Tóká rawt yá dhanná, pa charágáhé sara bit. ");
INSERT INTO bccl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Dozza kayt tán dozzi bekant, bekoshit o tabáh bekant, man átkagán ke mardomán zendmán berasit o sarjamiá áiay wáhond bebant. ");
INSERT INTO bccl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Man nékén shopánk án, nékén shopánk wati sáhá pa pasán nadra kant. ");
INSERT INTO bccl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Bale kasé ke pa mozz kára kant, pasáni wáhond naent. Wahdé gendit ke gork dém pa pasán pédák ent, áyán yalaha kant o tachit. Á wahdi, gork pasáni sará hamlah o orosha bárt o áyán sheng o shánga kant. ");
INSERT INTO bccl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Á tachit, chiá ke pa mozz kára kant, pasáni hayáldáriá nakant. ");
INSERT INTO bccl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Man nékén shopánk án, man wati pasán jáha kárán o á ham maná zánant, ");
INSERT INTO bccl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","hamá dhawlá ke Pet maná zánt o man Petá zánán. Man wati sáhá pa pasán nadra kanán. ");
INSERT INTO bccl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Maná dega pas ham hast, ke cha é ramagá naant, báyad ent áyán ham byárán. Á mani tawárá eshkonant o yak ramag o yak shopánka bant. ");
INSERT INTO bccl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Pet maná dósta dárit, chiá ke man wati sáhá nadra kanán ke padá wati ján o zenday wáhond bebán. ");
INSERT INTO bccl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Hechkas mani sáhá cha man gepta nakant, man gón wati hobb o wáhagá áiá nadra kanán. Maná wati sáhay dayagay ehtiár watá gón ent o padá áiay per tarrénagay master ham wat án. É hokm, maná Petá dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","É habaráni bárawá, padá Yahudiáni nyámá nátepáki kapt. ");
INSERT INTO bccl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bázéné gwashagá at: “Áiá jenné per, ganóké, pa ché áiay habarán gósha dárét.” ");
INSERT INTO bccl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Á dega gwashagá atant: “Kaséá ke jenn per ent, é dhawlén gapp jata nakant. Jenn kórán biná korta kant?” ");
INSERT INTO bccl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wahdé Urshalimá, mazanén parasteshgáhay shosht o shód o wapkay aid átk, zemestán at. ");
INSERT INTO bccl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Issáyá mazanén parasteshgáhá, Solaymánay péshjáhá kadama jat. ");
INSERT INTO bccl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yahudi áiay chapp o chágerdá mocch but o gwashagá atant: “Tán kadén márá é dhawlá shakkay tahá dáray? Agan taw Masih ay, rást o pakká begwash.” ");
INSERT INTO bccl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Issáyá gwasht: “Man shomárá gwashtag, bale báwara nakanét. Á kárán ke man cha Petay némagá kanán wat pa man gwáhia dayant. ");
INSERT INTO bccl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Bale shomá ke mani pas naét, báwara nakanét. ");
INSERT INTO bccl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mani pas mani tawárá eshkonant, man áyán jáha kárán o mani randgiriá kanant. ");
INSERT INTO bccl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Man áyán namiránén zenda bakshán o á hechbara namerant. Kass áyán cha man pach gepta nakant. ");
INSERT INTO bccl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Hamá Pet, ke é maná bakshetaganti, cha sajjahénán master ent o hechkas áyán cha mani Petay dastá pach gepta nakant. ");
INSERT INTO bccl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Man o mani Pet yakk én.” ");
INSERT INTO bccl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Padá Yahudián dhók chet ke áiá sengsár bekanant. ");
INSERT INTO bccl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Issáyá gón áyán gwasht: “Man cha Petay némagá bázén nékén káré kortag, pa kojám kárá maná sengsára kanét?” ");
INSERT INTO bccl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yahudián darráént: “Pa nékén káréá tará sengsára nakanén, pa tai koprán é kárá kanén. Taw bani ádamé ay bale gwashay: ‘Man Hodá án.’” ");
INSERT INTO bccl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Issáyá gwasht: “Shomay Sharyatá nayátkag ke Hodáyá gwashtag: ‘Shomá cha hamá shawr borrókénhodáyán ét’? ");
INSERT INTO bccl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Agan á mardom ke Hodáay habar pa áyán rasetag, ‘hodá’ gwashag butagant o zánén ke Hodáay Pákén Ketáb hechbara nakapit o nákára nabit, ");
INSERT INTO bccl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","gorhá maná ke Petá gechén kortag o é jaháná rawán dátag, chón kopray bohtámá janét? Á ham tahná pa é habará ke man gwashtag: ‘Hodáay Chokk án.’ ");
INSERT INTO bccl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Agan man wati Petay kárán makanán, pa man imán mayárét. ");
INSERT INTO bccl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Bale agan áyáni sará kára kanán, toré agan pa man imán mayárét, pa mani kárán imán byárét. Á wahdi, sarkecha warét ke Pet mani jesm o jáná ent o man áiay arwáh o jabiná.” ");
INSERT INTO bccl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Gorhá lóthetesh padá áiá dazgir bekanant, bale Issá cha áyáni dazrasá dur but. ");
INSERT INTO bccl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Randá cha Ordonay kawrá gwast o hamá jágahá shot o mant ke pésará Yahyáyá ódá pákshódi dátagat. ");
INSERT INTO bccl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Bázén mardomé áiay kerrá átk o gwashtesh: “Yahyáyá hech mójezah o ajabbatén nesháni pésh nadásht, bale é marday bárawá har chizzé ke gwashti rást ent.” ");
INSERT INTO bccl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ódá bázén mardoméá Issáay sará imán áwort. ");
INSERT INTO bccl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Bayt-Anyáay métagá, Ilázar námén mardé nájórh at. Bayt-Anyá, Maryam o áiay gohár Martáay métag at. ");
INSERT INTO bccl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryam hamá at ke Hodáwandén Issáay pádi atr per moshtant o gón wati mudán hoshki kortant, annun áiay brát Ilázar nájórh at. ");
INSERT INTO bccl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Áiay gohárán pa Issáyá kolaw kort: “Oo Hodáwand! Tai dóst nádráh ent.” ");
INSERT INTO bccl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wahdé Issáyá é habar eshkot gwashti: “É nádráhi áiá dém pa marká nabárt, pa Hodáay shán o shawkatá yak neshánié bit, tánke Hodáay Chokk ham cha é ráhá pa mazani o shawkat berasit.” ");
INSERT INTO bccl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Issáyá, Martá o áiay gohár o Ilázar dósta butant. ");
INSERT INTO bccl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wahdé cha Ilázaray nájórhiá sahig but, dega do róch hamá jáhá ke dáshtagati mahtal but. ");
INSERT INTO bccl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Gorhá gón moridán gwashti: “Byáét padá dém pa Yahudiahá berawén.” ");
INSERT INTO bccl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Moridán gwasht: “Oo ostád! É habará dér nagwastag ke Yahudián lóthet tará sengsár bekanant. Padá hamódá rawaga lóthay?” ");
INSERT INTO bccl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Issáyá passaw dát: “Róchay rozhnái dwázdah sáhat naent? Kasé ke róchá ráha rawt nalakoshit o thagala nawárt, chiá ke jahánay rozhnáiá gendit. ");
INSERT INTO bccl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Bale agan kasé shapá ráh berawt lakoshit, chiá ke áiá hech rozhnáié démá nést.” ");
INSERT INTO bccl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","É habarán o rand, Issáyá gwasht: “May dóstén Ilázar waptag, bale mana rawán o áiá páda kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Moridán gwasht: “Oo Hodáwand! Agan wáb ent, allamá dráha bit.” ");
INSERT INTO bccl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Issáyá áiay markay bárawá habar kort, bale áyán hayál kort ke Ilázar anchosh waptag o wáb ent. ");
INSERT INTO bccl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Á wahdi Issáyá sarkech dátant ke “Ilázar mortag. ");
INSERT INTO bccl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nun pa shomaygi shádmán án ke ódá nabutagán. Pa ché ke nun báwar korta kanét. Byáét, áiay gwará rawén.” ");
INSERT INTO bccl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tumá ke áesh “Járhó” náméntagat, gón á dega moridán gwashti: “Byáét, má ham berawén o gón áiá hór bemerén.” ");
INSERT INTO bccl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wahdé Issá ódá átk o raset, sahig but chár róch ent ke Ilázar kabr kanag butag. ");
INSERT INTO bccl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bayt-Anyá tán Urshalimá, kesás say kilumitar ent. ");
INSERT INTO bccl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Bázén Yahudié, Martá o Maryamay kerrá pa áyáni brátay porsá átkagat. ");
INSERT INTO bccl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wahdé Martá sahig but ke Issá pédák ent, áiay péshwáziá shot, bale Maryam mant. ");
INSERT INTO bccl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martáyá gón Issáyá gwasht: “Oo Hodáwand! Agan taw edá buténay, mani brát namortagat. ");
INSERT INTO bccl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Bale angata zánán, har chizz ke taw cha Hodáyá belóthay tará dant.” ");
INSERT INTO bccl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Issáyá gwasht: “Tai brát padá zendaga bit.” ");
INSERT INTO bccl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martáyá gwasht: “Mana zánán ke áherzamáná zendaga bit.” ");
INSERT INTO bccl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Issáyá gwasht: “Man zendmán o áherat án. Agan kasé mani sará imán byárit toré bemerit, padá ham zendaga bit. ");
INSERT INTO bccl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Harkas ke zendag ent o mani sará báwara kant, hechbara namerit. É habará báwara kanay?” ");
INSERT INTO bccl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martáyá gwasht: “Haw mani Hodáwand! Maná báwar ent ke taw Masih ay, Hodáay hamá Chokk ay ke báyad ent é jaháná byayt.” ");
INSERT INTO bccl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Cha é gappáni gwashagá o rand, Martá shot wati gohár Maryami tawár kort o pa halwaté gwashti: “Ostád átkag o tará lóthit.” ");
INSERT INTO bccl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wahdé Maryamá é eshkot, hamá damáná chest but o Issáay kerrá shot. ");
INSERT INTO bccl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Issá angat á métagá narasetagat o hamódá at ke Martá áiay gendagá shotagat. ");
INSERT INTO bccl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Hamá Yahudi ke Maryamay lógá atant o áiá tasallá dayagá atant, wahdé distesh ke á pa eshtápi pád átkag o cha lógá dar áyagá ent, áiay randá kaptant. Gón wat gwashtesh: “Balkén pa gréwagá kabray sará rawt.” ");
INSERT INTO bccl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Bale Maryam hamódá shot o sar but ke Issá ódá at o á disti. Nun Issáay pádán kapt o gwashti: “Oo Hodáwand! Agan taw edá buténay, mani brát namortagat.” ");
INSERT INTO bccl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wahdé Issáyá Maryam gón á Yahudián ke áiay hamráh atant gréwán dist, cha delá áhé kasshet o sakk padard but. ");
INSERT INTO bccl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Gwashti: “Shomá Ilázar kojá kabr kortag?” Gwashtesh: “Oo Hodáwand! Byá o bechár.” ");
INSERT INTO bccl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Cha Issáay chammán ars retkant. ");
INSERT INTO bccl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yahudi gwashagá atant: “Bechárét chenkadar dósti butag.” ");
INSERT INTO bccl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Cha áyán lahténá gwasht: “É mard ke kóray chammi biná kortant, Ilázari cha marká rakként nakort?” ");
INSERT INTO bccl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Randá, Issá anchosh ke cha delá áh kasshagá at, kabray sará átk. Kabr, yak gáré at ke dhóké áiay dapá ér at. ");
INSERT INTO bccl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Issáyá gwasht: “Dhóká dur kanét.” Ilázaray gohár Martáyá gwasht: “Oo wájah! Áiay marká chár róch gwastag o bóa kant.” ");
INSERT INTO bccl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Issáyá passaw dát: “Man nagwasht agan tará imán bebit, Hodáay shán o shawkatá genday?” ");
INSERT INTO bccl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Gorhá dhókesh cha kabray dapá dur kort, Issáyá ásmánay némagá cháret o gwashti: “Oo Pet! Tai shográ gerán ke mani habaret eshkot. ");
INSERT INTO bccl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Man zánt ke taw modám mani habará gósha dáray, bale é habaron pa á mardomán gwasht ke edá óshtátagant, tán báwar bekanant ke taw maná rawán dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Cha é habarán o rand, Issáyá gón borzén tawáré gwánk jat: “Ilázar! Dar kap.” ");
INSERT INTO bccl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Hamá mordag, ke dast o pádi kaponá atant o démi dazmáléá póshetagat, dhanná dar átk. Issáyá gwasht: “Áiá pach kanét, belléti ke rawt.” ");
INSERT INTO bccl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Maryamay gwará átkagén bázén Yahudián, wahdé Issáay é kár dist, áiay sará imánesh áwort. ");
INSERT INTO bccl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Bale lahtén, Parisiáni kerrá shot o Issáay kortagén káray hálesh bort o sar kort. ");
INSERT INTO bccl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Mazanén dini péshwá o Parisián wati sarókáni diwánay básk lóthetant o gwashtesh: “Má ché kanagá én? É mard bázén mójezah o ajabbatén nesháni pésh dáragá ent. ");
INSERT INTO bccl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Agan áiá hamé dhawlá yalah bedayén, sajjahén áiay sará báwara kanant, á wahdi Rumia káyant o may kawm o mazanén parasteshgáhá gerant.” ");
INSERT INTO bccl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Cha áyán, Kiápá námén mardéá, ke á sálá masterén dini péshwá at, gwasht: “Shomá cha bon o béhá chizzé nazánét. ");
INSERT INTO bccl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nazánét ke pa shomá, sarjamén kawmay tabáhiay badalá, sharter hamesh ent ke kawmay jáhá yak mardomé bemerit.” ");
INSERT INTO bccl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","É gapp, áiá watsar nagwasht, chiá ke á sálá, Kiápá masterén dini péshwá at, áiá péshgói kort ke Issá báyad ent pa kawmá bemerit, ");
INSERT INTO bccl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","tahná pa á kawmá na, pa Hodáay sajjahén sheng o shángén chokkán tán áyán yakjáh o yakráh bekant. ");
INSERT INTO bccl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Cha á róchá o rand, áiay koshagay band o bastesh bongéj kort. ");
INSERT INTO bccl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Cha ed o rand, dega baré Issáyá watá Yahudiáni nyámá záher nakort. Gyábánay nazziká, Epráim námén shahréá, gón wati moridán shot o nesht. ");
INSERT INTO bccl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Yahudiáni Sargwazay aid nazzik at o bázén mardomé cha molkay sajjahén hand o damagán, Urshalimá átkagat ke cha aidá pésar pákizagiay rasmán purah bekanant. ");
INSERT INTO bccl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Á Issáay jost o porsá atant o mazanén parasteshgáhá gón yakdegará gwashagá atant: “Bárén, é aidá nayayt? Shomá ché gwashét?” ");
INSERT INTO bccl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Bale mazanén dini péshwáyán o Parisián hokm kortagat, harkasé ke bezánt Issá kojá ent, hál bedant tán áiá dazgir bekanant. ");
INSERT INTO bccl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Cha Sargwazay aidá shash róch pésar, Issá Bayt-Anyáyá shot ke Ilázaray lóg hamódá at, hamá Ilázar ke cha mordagán zendag kortagati. ");
INSERT INTO bccl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Áyán, pa Issáyá shámé jórh kortagat, Martáyá hezmata kort o Ilázar gón mehmánán Issáay kashá parzónagay sará neshtagat. ");
INSERT INTO bccl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Á wahdi, Maryamá ném táséay kesásá, sombolay gehter o gránbaháén atr áwort, Issáay pádán per mosht o pád gón wati mud o malgórán hoshk kortant. Atray wasshén bó, á lógay har kondhá tálán but. ");
INSERT INTO bccl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Hamé wahdá Yahudá Eskaryutiá, ke cha Issáay moridán at o pa hamé zuttán, Issái dróhagi o dozhmenáni dastá dayagi at, gwasht: ");
INSERT INTO bccl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Parchá é atr pa sésad dinárá bahá nabut o zarr, garib o nézgárán dayag nabutant?” ");
INSERT INTO bccl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Áiá é habar pa bazzagén mardománi gamwáriá nagwasht, paméshká gwashti ke á wat Issáay rombay kelitdár at o dozzé at. Áiá harwahd cha zarturagá chizzé pa wata zort. ");
INSERT INTO bccl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Issáyá gwasht: “Maryamay kárá kár madárét, áiá é rógen pa mani kabr kanagay tayáriá ér kortagant. ");
INSERT INTO bccl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Garib o nézgár modám shomay kerrá hast, bale man harwahd gón shomá gón naán.” ");
INSERT INTO bccl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Cha Yahudián bázénéá, wahdé eshkot ke Issá ódá ent, tahná Issáay didárá nayátkant, Ilázaray gendagá ham átkant ke zendag butagat. ");
INSERT INTO bccl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Paméshká mazanén dini péshwáyán Ilázaray kóshay shawr ham borret. ");
INSERT INTO bccl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Chiá ke áiay sawabá, bázén Yahudié cha áyán per tarretagat o Issáay sará báwarmand butagat. ");
INSERT INTO bccl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","É dega róchá, mazanén rombé ke pa aidá átkagat, wahdé zántesh Issá Urshalimay ráhá ent, ");
INSERT INTO bccl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","gón maccháni sarsabzén pissh o takán, pa Issáay péshwáziá dar átk. Kukkáresha kort: “Hushiáná, Esráilay bádsháhá mobárak bát ke pa Hodáwanday námá kayt.” ");
INSERT INTO bccl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Issáyá korragén haré dar gétk o áiá swár but, anchosh ke Hodáay Pákén Ketába gwashit: ");
INSERT INTO bccl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Oo Sahyunay Jenek! Nun mators. Tai bádsháh korragén haréay poshtá neshtag o pédák ent.” ");
INSERT INTO bccl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Awalá é chizzáni maksad pa moridán pakká naat, bale randá ke Issá pa wati mazani o shawkatá raset, morid yát o tránagá kaptant ke é chizz áiay bárawá nebisag butagat o mardomán ham gón áiá anchosh kort. ");
INSERT INTO bccl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Wahdé Issáyá Ilázar tawár jat o cha kabrá zendag dar áwort, bázéné hamódá at. Áyán pa wati distagén o eshkotagénán sháhedia dát. ");
INSERT INTO bccl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Á mazanén romb, pa é háterá Issáay péshwáziá átkagat, ke eshkotagatesh Issáyá é mójezah o ajabbatén nesháni záher kortag. ");
INSERT INTO bccl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Parisián gón yakdegará gwasht: “Bechárét, máshomá hecch nakanagá én, sajjahén donyá áiay ráhá ent.” ");
INSERT INTO bccl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Gón é mardomán ke aiday róchán pa parastesháUrshalimá átkagatant, lahtén Yunáni ham gón at. ");
INSERT INTO bccl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Á Piliposay kerrá átkant. Pilipos Jalilay shahr Bayt-Saydáay mardomé at. Gón áiá gwashtesh: “Wájah! Má lóthén Issáyá begendén.” ");
INSERT INTO bccl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Pilipos shot o é habari gón Andriásá gwasht. Á doén shotant o Issáesh hál dát. ");
INSERT INTO bccl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Issáyá áyáni passawá gwasht: “Á wahd átkag ke Ensánay Chokk pa wati shán o shawkatá berasit. ");
INSERT INTO bccl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Allam bezánét, agan gandomay dánag hákay chérá marawt o mamerit, hechbar cha yak dánagéá géshtera nabit, bale agan kall bebit bázén dánagé kárit. ");
INSERT INTO bccl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Harkasá ke wati zend dóst ent, áiá báhénit o harkas ke é jaháná cha wati zendá sara gwazit, á wati sáh o jáná rakkénit o pa namiránén zendá sara bit. ");
INSERT INTO bccl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Agan kasé lóthit mani hezmatá bekant, báyad ent mani randgiriá bekant. Har jáh ke man án, mani hezmatkár hamódá gón man ent o agan kasé mani hezmatá kant, mani Pet áiá washnáma kant. ");
INSERT INTO bccl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Annun mani del bétáhir o jalájósh ent, ché begwashán? Bárén begwashán: ‘Oo mani Pet! Maná cha é sáhatá berakkén’? Na, habar esh ent ke mani áyagay morád o maksad hamé wahd o damán butag. ");
INSERT INTO bccl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Oo Pet! Wati námá mazani o shawkat beday.” Hamé wahdá, borzén tawáré cha ásmáná rost ke gwashti: “Shán o mazanion dátag o angat ham dayán.” ");
INSERT INTO bccl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Rombé mardom ke ódá óshtátagat, gón é tawáray eshkonagá gwashagá laggetant: “Granday tawár at,” á degarána gwasht: “Préshtagéá gón áiá gapp kort.” ");
INSERT INTO bccl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Issáyá gwasht: “É tawár, pa man na, pa shomaygi átk. ");
INSERT INTO bccl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Annun é jahánay dádrasiay wahd ent o jahánay náláhekén sardár Shaytán, dhanná dar kanaga bit. ");
INSERT INTO bccl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Wahdé cha zeminá chest kanaga bán, sajjahén mardomán wati némagá kasshán.” ");
INSERT INTO bccl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Issáyá é habar pa hamá dhawlén markéá gwasht ke áiay entezár o wadárá at. ");
INSERT INTO bccl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Mardomán darráént: “Sharyata gwashit ke Masih tán abad gón má mánit. Gorhá taw chóna gwashay ke ‘Ensánay Chokk chest kanaga bit’? Ensánay é Chokk kay ent?” ");
INSERT INTO bccl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Issáyá gwasht: “Tahná yak gwandhén wahdéá rozhnái gón shomá gón ent. Tán wahdé ke é rozhnái gón shomá gón ent, gám janán démá berawét. Chosh mabit ke taháróki shomay sará báládast bebit o shomárá prósh bedant. Kasé ke tahárókiá ráha rawt, nazánt kojá rawt. ");
INSERT INTO bccl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Tánke shomárá rozhnái gón ent, rozhnay sará imán byárét ke rozhnáiay chokk bebét.” Issáyá é gwasht o cha áyáni nyámá shot o chérandém but. ");
INSERT INTO bccl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Gón Issáay é bázén mójezah o ajabbatén neshánián, angat ham áyán imán nayáwort, ");
INSERT INTO bccl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","tánke Eshayá nabiay habar purah o sarjam bebit, ke áiá gwashtagat: “Oo Hodáwand! May kolaw kayá báwar kortag o Hodáwanday wák o kodratpa kayá záher butag?” ");
INSERT INTO bccl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gorhá áyán báwar kort nakort, chiá ke Eshayáyá angat ham gwashtagat: ");
INSERT INTO bccl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Áyáni chammi kór o deli sakk mohr kortagant tán gón chammán magendant, gón delán sarkech mawarant o dém pa man per matarrant, tánke áyán dráh bekanán.” ");
INSERT INTO bccl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Eshayáyá Issáay mazani o shawkat dist, paméshká áiay bárawá é habari kort. ");
INSERT INTO bccl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Angat ham Yahudiáni bázén sarókán imán áwort. Bale cha hamé torsá ke Parisi áyán cha kanisah o parasteshgáhán dar makanant, námesha nagept. ");
INSERT INTO bccl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Chiá ke áyán, ensánay dátagén ezzat o satá cha Hodáay dátagén ezzat o satáyá géshter dósta but. ");
INSERT INTO bccl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Gorhá Issáyá gón borzén tawáré gwasht: “Harkas mani sará báwar bekant, na tahná mani sará, mani rah dayókay sará ham báwara kant. ");
INSERT INTO bccl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Harkas maná gendit, mani rah dayóká ham gendit. ");
INSERT INTO bccl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Man é jahánay átkagén rozhnái án, tán harkas ke mani sará báwar bekant, tahárókiá mamánit. ");
INSERT INTO bccl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Bale agan kasé mani habarán beshkont o áyáni sará kár makant, angat ham man áiay bárawá shawr o hokmé naborrán. Chiá ke man pa jahánay mayárig kanagá nayátkagán, pa jahánay rakkénagá átkagán. ");
INSERT INTO bccl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Shawr borróké hast, tán harkas ke maná cha wat besendit o mani habarán mamannit, áiá mayárig bekant. Mani gwashtagén gapp o habar, jost o porsay róchá áiá mayáriga kanant. ");
INSERT INTO bccl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Chiá ke man watsar gapp o habar nakortag, hamá Petá ke maná rawán dátag, hokmi kortag ke ché begwashán o chón habar bekanán. ");
INSERT INTO bccl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Zánán ke áiay hokm o parmán, namiránén zend ent. É chizzán ke mana gwashán, hamá chizz ant ke Petá maná gwashtagant.” ");
INSERT INTO bccl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sargwazay aidá yak o do róch pasht kaptagat, Issáyá zánt áiay hamá sáhat o damán átkag ke báyad ent é jaháná yalah bedant o Petay kerrá berawt. Áiá wati morid, é jaháná mehr dátagatant o tán wati omray áheri damáná, pa del dósta dáshtant. ");
INSERT INTO bccl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Shámay wahd at o Shaytáná cha péshá Shamunay chokk, Yahudá Eskaryutiay del áshopéntagat ke Issáyá bedróhit o dozhmenáni dastá bedant. ");
INSERT INTO bccl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Issáyá zánt ke Petá sajjahén chizz Chokkay dastá dátagant, Chokk cha Hodáay némagá átkag o hamáiay kerrá rawt. ");
INSERT INTO bccl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Cha parzónagay sará pád átk, kabáhi kerré esht o lánkigé sréná basti. ");
INSERT INTO bccl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nun dasshódé zorti, moridáni pádi shoshtant o gón hamá lánkigá hoshk kortant. ");
INSERT INTO bccl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wahdé Shamun Petrosay bárig raset, áiá gwasht: “Oo Hodáwand! Taw mani pádán shódaga lóthay?” ");
INSERT INTO bccl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Issáyá passaw tarrént: “Annun taw nazánay man ché kanán, randá sarkecha waray.” ");
INSERT INTO bccl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrosá gwasht: “Man hechbara naylán taw mani pádán beshóday.” Issáyá gwasht: “Agan tará mashódán, cha man tará hech wandh o bahré narasit.” ");
INSERT INTO bccl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Shamun Petrosá gwasht: “Oo wájah! Agan chosh ent, tahná mani pádán na, mani sar o dastán ham beshód.” ");
INSERT INTO bccl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Issáyá gwasht: “Hamá kasá ke pákshódi kortag, áiá abéd cha pádán dega hech shosht o shóday hájat nést. Á sará tán pádá, sapá o sallah ent. Shomá pák ét, bale sajjahén na.” ");
INSERT INTO bccl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Chiá ke Issáyá zánt kay áiá dróhit, paméshká gwashti: “Shomay rombay tahá, sajjahén pák naant.” ");
INSERT INTO bccl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Sajjahénáni pádáni shódagá rand, wati kabáhi gwará kort o parzónagay sará nesht o gwashti: “Shomá zánét man pa shomá ché kort? ");
INSERT INTO bccl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Shomá maná ostád o Hodáwanda zánét o tawára kanét o rást ham gwashét, man hamá án. ");
INSERT INTO bccl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Agan man shomay Hodáwand o ostád án o shomay pádon shoshtagant, shomá ham báyad ent yakdegaray pádán beshódét. ");
INSERT INTO bccl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Man shomárá mesálé pésh kort, tán hamá dhawlá ke man gón shomá kort, shomá ham bekanét. ");
INSERT INTO bccl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Shomárá rásténa gwashán, hech golám cha wati wájahá o hech kásed cha wati rah dayóká master naent. ");
INSERT INTO bccl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Nun ke shomá eshiá zánét, bahtáwar ét agan kári bebandét. ");
INSERT INTO bccl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","É chizzán ke gwashán pa shomá sajjahénán naant. Á ke man gechén kortagant, áyána zánán o pajjáha kárán. Bale Pákén Ketábay é péshgói báyad ent sarjam bebit, á kas ke gón man hamkásag at, mani badwáh ent o mani démá óshtátag. ");
INSERT INTO bccl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Annun cha é kárá pésar shomárá gwashán ke wahdé chosha bit, gorhá bezánét ke Man Hamá Án. ");
INSERT INTO bccl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Báwar kanét, harkas hamáiá ke man rawán dátag wasshátk bekant o sharap bedant, bezán maná sharapi dátag o harkas maná sharap bedant, bezán mani rah dayóki sharap dátag.” ");
INSERT INTO bccl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wahdé Issáyá é gwasht, cha ruh o daruná sakk padard but o gón pakkái gwashti: “Báwar kanét, cha shomá yakké maná dróhit o dozhmenáni dastá dant.” ");
INSERT INTO bccl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Moridán nazánt kai bárawá é habará gwashagá ent o gón shakk o shohbah yakdegaresh cháret. ");
INSERT INTO bccl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cha moridán yakké ke Issáyá báz dóst at, áiay kerrá neshtagat. ");
INSERT INTO bccl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Paméshká Shamun Petrosá hamá morid eshárah kort ke wájahá jost bekant, bárén kai bárawá gapp kanagá ent? ");
INSERT INTO bccl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gorhá á morid nazzikter kenzet o cha Issáyá josti kort: “Oo Hodáwand! Á kay ent?” ");
INSERT INTO bccl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Issáyá passaw dát: “Á hamá ent ke man chondhé nán kásagá pera janán o áiá dayán.” Gorhá náni per jat o Shamun Eskaryutiay chokk, Yahudáyárá dáti. ");
INSERT INTO bccl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Anchosh ke Yahudáyá lonkah dastá kort, Shaytán áiay póstá potert. Nun Issáyá gón áiá gwasht: “Zutt kan! Har káré ke tará kanagi ent bekan.” ");
INSERT INTO bccl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Bale cha parzónagay saray neshtagén mardomán, hechkasá nazánt ke gón é habará áiay maksad chi ent. ");
INSERT INTO bccl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Lahténá gomán kort pa é háterá ke Yahudá zarturagay zemmahwár ent, Issá áiá gwashit ke berawt o harché pa aidá pakár ent begipt, yá nézgárán chizzé bedant. ");
INSERT INTO bccl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Anchosh ke Yahudáyá lonkah zort, dhanná dar kapt. Shap at. ");
INSERT INTO bccl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yahudá ke dar kapt, Issáyá gwasht: “Ensánay Chokk pa mazani o shawkat sar but. Hodáyá ham cha áiay némagá shawkat raset. ");
INSERT INTO bccl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Agan Hodáyá cha áiay némagá shawkat rasetag, Hodá ham áiá mazania dant o é mazani o shawkat ham hamé zutti bongéja bit. ");
INSERT INTO bccl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Oo mani chokkán! Angat tán gwandhén wahdéá gón shomá gón án. Randá mani shóházá gardét. Hamá dhawlá ke gón Yahudián gwashton, gón shomá ham gwashán: Á jáhá ke mana rawán, shomá átka nakanét. ");
INSERT INTO bccl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Shomárá nókén hokmé dayán: yakdegará dóst bedárét. Anchosh ke man shomárá dóst dáshtag, shomá ham yakdomiá dóst bedárét. ");
INSERT INTO bccl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Agan gón yakdegará mehr bekanét, gorhá sajjahéna zánant ke mani morid ét.” ");
INSERT INTO bccl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Shamun Petrosá gwasht: “Oo Hodáwand! Kojá raway?” Issáyá passaw dát: “Anchén jágahé rawán ke taw annun gón man átka nakanay. Bale randterá káay.” ");
INSERT INTO bccl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Petrosá gwasht: “Oo Hodáwand! Annun pa ché gón taw átka nakanán? Man wati sáhá pa taw nadra kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Issáyá gwasht: “Bárén, taw pa man wati sáhay nadr kanagá tayár ay? Báwar kan, cha korósbángá pésar, say randá mani pajjáh áragá enkára kanay o namannay. ");
INSERT INTO bccl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Shomay del negrán o bétáhir mabit, Hodáay sará báwar kanét, pa man ham imán byárét. ");
INSERT INTO bccl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Mani Petay lógá bázén báné hast. Agan é dhawl mabutén shomárá gwashton, mana rawán tán pa shomá jágahé tayár kanán. ");
INSERT INTO bccl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Bale nun agan man pa shomay jágahay tayár kanagá rawán, padá káyán o shomárá gón wata barán, tán shomá ham hamódá gón man yakjáh bebét. ");
INSERT INTO bccl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Shomá zánét ke man kojá rawán o ráhá ham balad ét.” ");
INSERT INTO bccl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tumáyá gwasht: “Oo Hodáwand! Má nazánén taw kojá raway, gorhá ráhá chón bezánén?” ");
INSERT INTO bccl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Issáyá gwasht: “Ráh man án. Rásti o zend bakshók ham man án. Hechkas bé man Petay kerrá átka nakant. ");
INSERT INTO bccl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Agan shomá maná bezántén, mani Petó ham zánt. Bale cha ed o rand, shomá áiá zánét o á distagó.” ");
INSERT INTO bccl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Piliposá gón áiá gwasht: “Oo Hodáwand! Petá márá pésh bedár, pa má hamé bass ent.” ");
INSERT INTO bccl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Issáyá gwasht: “Oo Pilipos! É bázén wahdá man gón shomá hamráh án o taw angat maná nazánay? Harkasá ke maná distag, mani Peti ham distag. Gorhá chóna gwashay: ‘Petá márá pésh bedár’? ");
INSERT INTO bccl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Báwara nakanay ke man Petay arwáh o jabiná án o Pet manigá? É habarán ke gón shomá gwashán mani naant, hamá Petayg ant ke mani jesm o jáná ent. Hamá ent ke é kárána kant. ");
INSERT INTO bccl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Mani é habará bemannét ke man Petay jabiná án o Pet manigá. Agan báwara nakanét, hamá káráni sará imán byárét ke shomá cha man distagant. ");
INSERT INTO bccl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Báwar kanét, harkas ke mani sará imán byárit, harché ke mana kanán, á ham korta kant. Masterén kár ham kant, chiá ke man Petay kerrá rawán o ");
INSERT INTO bccl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","harché ke pa mani námá belóthét, á wáhagá sarjama kanán, tánke Chokk wati Petá shán o shawkat bedant. ");
INSERT INTO bccl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Agan chizzé pa mani námá belóthét, pa shomá sarjam o tayára kanán. ");
INSERT INTO bccl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Agan shomá maná dósta dárét, mani hokmá ham pa del o jána mannét. ");
INSERT INTO bccl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Gorhá man wat cha Petá lóthán o á shomárá dega posht o panáhé dant ke modám shomay nyámá bemánit. ");
INSERT INTO bccl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Bezán é rástiay hamá Ruh ent ke jahán eshiá manneta nakant, chiá ke nagendit o pajjáhia nayárit. Bale shomá eshiá pajjáha kárét, chiá ke shomay kerrá mánit o shomay del o daruná bit. ");
INSERT INTO bccl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Shomárá yatim o chórawa nakanán, shomay kerrá pera tarrán. ");
INSERT INTO bccl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Kammén wahdéá rand, jahán dega baré maná nagendit, bale shomá maná gendét. Man zendag án, paméshká shomá ham zendaga mánét. ");
INSERT INTO bccl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Á róchá zánét ke man Petay arwáh o jabiná án o shomá manigá o man shomaygá. ");
INSERT INTO bccl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Á kasá ke mani hokm gón ent o á hokmáni sará kára kant, hamá maná dósta dárit. Á ke maná dósta dárit, á mani Petá ham dósta bit. Maná ham á dósta bit o watá pa áiá paddara kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahudá Eskaryutiá na, á domi Yahudáyá jost kort: “Oo Hodáwand! Pa ché watá pa má paddara kanay bale pa jaháná nakanay?” ");
INSERT INTO bccl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Issáyá passaw tarrént: “Á kas ke maná dósta dárit, hamá habaráni sará kára kant ke man gwashtagant o á ham mani Petá dósta bit. Man o Pet áiay kerrá rawén o gón áiá mánén. ");
INSERT INTO bccl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Á kas ke maná dósta nadárit, mani habaráni sará kára nakant. É habarán ke shomá cha mana eshkonét mani naant, hamá Petayg ant ke maná ráhi dátag. ");
INSERT INTO bccl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","É habaron hamá wahdá gwashtant ke angat shomay nyámá án. ");
INSERT INTO bccl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Bale shomay posht o panáh, hamá Pákén Ruh ent ke Peti pa mani námá rawána kant. Á, sajjahén chizzán shomárá sója dant. Hamá habar ke man gón shomá gwashtagant, shomárá áyáni yát o tránagá perrénit. ");
INSERT INTO bccl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Man shomárá deljami o ásudagia dayán, wati árámi o ásudagiá shomárá bakshán. Jaháná é wák o twán nést hamá ásudagiá shomárá bedant ke mana dayán. Negrán o deltaparkah mabét. ");
INSERT INTO bccl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Shomá eshkot man gwasht ke rawán, bale padá shomay kerrá pera tarrán. Agan man shomárá dósta buténán, cha é habará shádána butét ke man Petay kerrá rawán, chiá ke Pet cha man master ent. ");
INSERT INTO bccl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Paméshká, cha é káray sarjam bayagá pésar gwashton ke wahdé chosha bit, imán byárét. ");
INSERT INTO bccl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Cha ed o rand, gón shomá báz habara nakanán, chiá ke é jahánay náláhekén sardár, Shaytána kayt. Áiá mani sará hech wák o zóré nést. ");
INSERT INTO bccl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Man bass hamá kárána kanán ke Petá maná hokm kortag, tán jahán bezánt ke maná Pet dóst ent. Pád áét, cha edá berawén. ");
INSERT INTO bccl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Man anguray asligén drachk án o mani Pet bágpán ent. ");
INSERT INTO bccl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mani har thálé ke bar mayárit, áiá goddhit o har thálé ke gránbara bit, áiá pák o sallaha kant ke géshter nibag byárit. ");
INSERT INTO bccl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Shomá gón mani habarán pák butagét. ");
INSERT INTO bccl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Shomá mani jesm o jáná bemánét o man shomaygá. Hamá dhawlá ke agan thálé gón drachká hór mabit, bara nadant, shomá ham agan gón man hór mabét bar dáta nakanét. ");
INSERT INTO bccl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Man drachk án o shomá thál ét. Harkas ke gón man bemánit o man gón áiá, bázén nibagé kárit, chiá ke shomá cha man jetá hech káré korta nakanét. ");
INSERT INTO bccl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Agan kasé gón man mamánit, yak tháléay dhawlá dawr dayaga bit o hoshka tarrit. Mardom hoshkén thálán moccha kanant o sóchant. ");
INSERT INTO bccl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Agan mani jesm o jáná bemánét o mani habar shomay delá benendant, harché ke belóthét, shomay wáhag sarjama bant. ");
INSERT INTO bccl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mani Petá gón hamé kárá shán o shawkata rasit ke shomá bázén bar o nibagé byárét o mani morid bebét. ");
INSERT INTO bccl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Hamá dhawlá ke Petá maná dóst dáshtag, man ham shomárá hamá paymá dóst dáshtag. Mani mehráni sáhegá bemánét. ");
INSERT INTO bccl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Agan mani hokmáni sará kár bekanét, mani mehráni tahá mánét, anchosh ke man wati Petay hokmáni sará kár kortag o áiay mehráni tahá émen neshtagán. ");
INSERT INTO bccl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","É habaron gón shomá paméshká gwashtant, tánke mani shádmániay wáhond bebét o shomay shádmáni sarjam bebit. ");
INSERT INTO bccl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mani hokm esh ent ke shomá gón yakdegará mehr bekanét, hamá dhawlá ke man gón shomá mehr kortag. ");
INSERT INTO bccl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Cha eshiá masterén mehr nést ke mardom wati sáhá pa dóstá nadr bekant. ");
INSERT INTO bccl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Agan shomá mani hokmáni sará kár bekanét, mani dóst ét. ");
INSERT INTO bccl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Cha ed o rand shomárá golám o bandaha nagwashán, chiá ke goláma nazánt wájah ché kant. Paméshká man shomárá wati dóst zánt, ke harché cha Petá eshkot, gón shomá gwashton. ");
INSERT INTO bccl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Shomá maná gechén nakortag, man shomárá gechén kortag o rawán dátag ke berawét o nibag byárét, abadmánén nibag. Á wahdi, harché pa mani námá cha Petá belóthét, shomárá dant. ");
INSERT INTO bccl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mani hokm pa shomá hamesh ent: Yakdegará dóst bedárét. ");
INSERT INTO bccl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Agan donyá cha shomá naprata kant, bezánét ke pésará cha man ham naprati kortag. ");
INSERT INTO bccl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Agan shomá é donyái mardom buténét, donyáyá ham shomárá watigáni dhawlá dósta dásht. Bale paméshká ke shomá donyái naét o man shomárá cha é donyáyá gechén kortag o dar chetag, nun donyá cha shomá bézár ent. ");
INSERT INTO bccl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cha é habará béhayál mabét ke man gón shomá gwashtagat: ‘Golám cha wájahá mastera nabit.’ Agan áyán maná ázár dátag, shomárá ham ázára dayant. Agan mani habaresh zortag, shomay habará ham zurant. ");
INSERT INTO bccl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pa mani námaygi gón shomá é dhawlá kanant, chiá ke mani rah dayóká nazánant. ");
INSERT INTO bccl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Agan man mayátkénán o gón áyán é habar makorténant, á bémayár atant. Bale annun áyán, pa wati gonáhán hech ozré nést. ");
INSERT INTO bccl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Harkas ke cha man naprata kant, cha mani Petá ham naprata kant. ");
INSERT INTO bccl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Agan áyáni nyámá á kár man makorténant ke cha degaráni was o wáká dar ant, bémayár atant. Bale nun, áyán é kár distagant o angat cha man o mani Petá naprata kanant. ");
INSERT INTO bccl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Áyáni Sharyatay é habar ke gwashit, ‘bé sawab cha man napratesh kortag,’ é dhawlá rást o paddar but. ");
INSERT INTO bccl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Bale wahdé shomay hamá posht o panáha kayt, bezán rástiay Pákén Ruh ke áiay sarchammag Pet ent o mani cha Petay némagá rawána kanán, hamá mani bárawá gwáhia dant. ");
INSERT INTO bccl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Shomá ham mani gwáh o sháheda bét, chiá ke cha hamá bongéjá gón man gón butagét. ");
INSERT INTO bccl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“É chizzon gón shomá gwashtant ke shomá mathagalét o rad mawarét. ");
INSERT INTO bccl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Bezánét ke shomárá cha parasteshgáh o kanisahán dara kanant. Yak wahdé kayt, á kas ke shomárá koshit, gomána kant gón wati é kárá pa Hodáyá hezmata kant. ");
INSERT INTO bccl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","É kárán gón shomá kanant, chiá ke na Petá zánant o na maná. ");
INSERT INTO bccl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","É habaron shomárá paméshká gwashtant ke wahdé chosh but, mani gwashtagén habaráni hayál o tránagá bekapét. É chizzon cha awalá gón shomá nagwashtant, chiá ke man wat gón shomá gón atán. ");
INSERT INTO bccl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Annun wati rah dayókay kerrá rawán bale cha shomá hechkas josta nakant ke ‘kojá raway?’ ");
INSERT INTO bccl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Shomay del cha gamá porr but, chiá ke man é habar gón shomá gwashtant. ");
INSERT INTO bccl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Bale rásténa gwashán ke mani rawag pa shomá sharter ent. Chiá ke agan marawán, shomay posht o panáh shomay nyámá nayayt, bale mana rawán o áiá pa shomá rawána kanán. ");
INSERT INTO bccl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Wahdé á kayt, jaháná gonáh o pahrézkári o adl o hokmay bárawá sahig o mayáriga kant. ");
INSERT INTO bccl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Gonáhá pésha dárit, chiá ke mani sará imánesh nayáwort; ");
INSERT INTO bccl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","pahrézkáriá paddara kant, chiá ke man Petay kerrá rawán o shomá dega baré maná nagendét; ");
INSERT INTO bccl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","adl o hokmá pajjárénit, chiá ke é jahánay náláhekén sardár, Shaytán mayárig kanag butag. ");
INSERT INTO bccl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Bázén chizzé hast ke báyad ent gón shomá begwashán, bale shomárá é wahdi áyáni eshkonagay wák o twán nést. ");
INSERT INTO bccl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Á ke rástiay Ruh ent, kayt. Á shomárá pa sarjamén rástiá rahdarbaria kant. Parchá ke watsar chizzé nagwashit, tahná cha hamá chizzán habara kant ke eshkont o shomárá cha démá áyókén chizzán sarpada kant. ");
INSERT INTO bccl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Á mani shán o shawkatá paddara kant, chiá ke har hál o habaré ke cha mana gipt, shomárá sahiga kant. ");
INSERT INTO bccl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Harché ke mani Petá hast, manig ent. Paméshká gwashton ke Pákén Ruh cha mana gipt o shomárá sahiga kant. ");
INSERT INTO bccl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Kammén wahdéá rand, maná nagendét bale padá, kammoké randterá maná gendét.” ");
INSERT INTO bccl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Gorhá cha moridán lahténá gón yakdegará gwasht: “Chiá gwashit: ‘Kammén wahdéá rand, maná nagendét bale padá, kammoké randterá maná gendét,’ yá é habar ke á gwashit: ‘Petay kerrá rawán,’ áiay maksad chi ent?” ");
INSERT INTO bccl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Á watmánwat gwashagá atant: “É ‘gwandhén wahd’ ke áiay bárawá habara kant, chi ent? Má nazánén ché gwashit?” ");
INSERT INTO bccl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Issáyá zánt ke é bárawá cha man jost kanaga lóthant. Gorhá gwashti: “Shomá mani hamé habaray bárawá gón yakdomiá jost o porsá ét ke man shomárá gwasht: ‘kammén wahdéá rand dega baré maná nagendét, bale padá, kammoké randterá maná gendét. Shomay gapp o trán hamé bárawá at?’ ");
INSERT INTO bccl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Báwar kanét o bezánét ke shomá arsa réchét o yak gam o andóhéá kapét, bale jahán shádehia kant. Shomá gamnák o porsiga bét, bale shomay é gam pa shádmániá badala bit. ");
INSERT INTO bccl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yak janéné wati chellagiay wahdá darda kasshit, bale anchosh ke nonnok pédá bit, wati dardána shamóshit, paméshká ke nókén ensáné pédá butag. ");
INSERT INTO bccl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Shomá ham annun, hamé dhawlá gamnák ét, bale shomárá padá gendán. Á wahdi, shádmána bét o shomay wasshián hechkas pach gepta nakant. ");
INSERT INTO bccl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Á róchá dega chizzé cha man josta nakanét. Báwar kanét, harché pa mani námá cha Petá belóthét, shomárá dant. ");
INSERT INTO bccl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tán é wahdi shomá chizzé pa mani námá nalóthetag, belóthét tán shomárá berasit o shomay shádmáni sarjam o sarréch bebit. ");
INSERT INTO bccl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Tán é wahdi, man gón shomá pa ráz o ramz habar kortag, bale wahdé kayt ke dega pa ráz o ramz habara nakanán, tachk o paddar Petay bárawá gón shomá habara kanán. ");
INSERT INTO bccl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Wahdé á rócha kayt, shomá mani námá gerét o cha Hodáyá lóthét o mana nagwashán ke pa shomá cha Petá lóthán. ");
INSERT INTO bccl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Pet wat shomárá dósta dárit, chiá ke manó dóst dáshtag o mannetagó ke man cha Hodáay némagá átkagán. ");
INSERT INTO bccl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Man cha Petay kerrá átkag o é jaháná sar butagán, annun é jaháná yalaha kanán o Petay gwará rawán.” ");
INSERT INTO bccl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Moridán gón áiá gwasht: “Nun róshen o pakká, bé ráz o ramz habar kanagá ay. ");
INSERT INTO bccl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nun deljam én ke taw sajjahén chizzána zánay o tará hech zalurat naent kasé cha taw josté bekant. Paméshká márá báwar ent, taw cha Hodáay némagá átkagay.” ");
INSERT INTO bccl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Issáyá passaw dát: “Nun shomárá báwar ent. ");
INSERT INTO bccl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Bechárét, yak wahd o sáhaté kayt o á wahd cha hamé annun bongéj butag, shomá sajjahén sheng o shánga bét o harkas wati ráhá rawt. Maná tahná o éwak yalaha dayét, bale angat tahná naán, chiá ke mani Pet gón man gón ent. ");
INSERT INTO bccl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","É chizzon shomárá gwashtant ke gón man hór bayagá shomárá sohl o ásudagi berasit. Jaháná shomárá dard o ranja rasit, bale matorsét o delér bebét chiá ke man é jahánay sará sóbén bután.” ");
INSERT INTO bccl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Cha é habarán o rand, Issáyá dém pa ásmáná cháret o gwashti: “Oo Pet! Á wahd o sáhat rasetag, wati Chokká shán o shawkat beday tánke Chokk tará ezzat o shán bedant. ");
INSERT INTO bccl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Taw sajjahén mardománi ehtiár áiay dastá dátag, tán hamá mardom ke taw áiárá bakshetagant, áyán namiránén zend bedant. ");
INSERT INTO bccl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Oo yakk o barhakkén Hodá! Namiránén zend hamesh ent ke á tará bezánant o tai rawán dátagén Issá Masihá pajjáh byárant. ");
INSERT INTO bccl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Á kár ke taw mani zemmah o ogdahá eshtagat, man sarjam kort o jaháná tai mazani o shawkat záher o paddar kort. ");
INSERT INTO bccl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Oo Pet! Annun maná wati bárgáhá shán o shawkat beday, hamá shawkat ke maná cha é jahánay jórhénagá pésar tai kerrá butag. ");
INSERT INTO bccl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Man tai nám, gón áyán pajjárént ke taw cha é jaháná gechén kortag o mani dastá dátagatant. Á taig atant o taw maná dátant. Áyán tai habaráni sará kár kortag. ");
INSERT INTO bccl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Annun áyán zánt, á chizz ke taw maná dátagant, pa rásti cha tai némagá ant. ");
INSERT INTO bccl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Chiá ke á habar ke taw maná gwashtag man pa áyán sar kortant o áyán ham mannet. Nun áyán pa del zánt ke man cha tai némagá átkagán o báwara kanant ke taw maná rawán dátag. ");
INSERT INTO bccl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Man pa áyán dwá kanán, pa sajjahén jaháná na. Man pa á mardomán dwá kanán ke taw mani dastá dátagant, chiá ke taig ant. ");
INSERT INTO bccl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Á ke manig ant, á sajjahén taig ant, á ke taig ant, manig ant o mani shán o shawkat cha áyán záher o paddar but. ");
INSERT INTO bccl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Man cha ed o rand é jaháná namánán, bale á angat jaháná ant o man tai kerrá káyán. Oo pákén Pet! Gón hamá námay zór o twáná ke taw maná dátag, áyáni negahpániá bekan tánke yakk bebant, hamá warhá ke má yakk én. ");
INSERT INTO bccl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tán wahdé ke man gón áyán butagán, gón hamá námay zór o twáná ke taw maná dátag, áyáni negahpánion kortag. Cha áyán yakké ham tabáh o halák nabut, abéd cha hamá yakkéná, ke wat halákatay láhek at, tán hamá chizz purah o sarjam bebit ke Pákén Ketába gwashit. ");
INSERT INTO bccl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Annun tai gwará káyán. Cha jahánay yalah dayagá pésar, é habarána gwashán tánke á cha mani shádmániá sarréch bebant. ");
INSERT INTO bccl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Man tai habar pa áyán rasént. Paméshká ke á, é donyái naant donyá cha áyán naprata kant, anchosh ke man é donyáié naán. ");
INSERT INTO bccl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Tai bárgáhá é dwáyá nakanán ke áyán cha donyáyá bebar, dwá kanán ke áyán cha sherr o Shaytáná berakkén. ");
INSERT INTO bccl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Hamá dhawlá ke man é donyáié naán, á ham naant. ");
INSERT INTO bccl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Áyán gón wati rástiá pák bedár, tai habar rásti ent. ");
INSERT INTO bccl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Hamá dhawlá ke taw maná jaháná rawán dát, man ham á, jaháná rawán kortant. ");
INSERT INTO bccl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Annun pa hamáyánigi watá gón páki o palgári tai sepordaha kanán, tánke á ham gón rástiá palgár o Hodáay sepordah bebant. ");
INSERT INTO bccl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Tahná pa eshán dwá nakanán, pa á mardomán ham dwá kanán ke cha esháni kolaw o gwáhiá mani sará imána kárant, ");
INSERT INTO bccl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","tánke á sajjahén yakk bebant. Oo Pet! Hamá dhawlá ke taw mani arwáh o jabiná ay o man taigá, á ham gón má bebant o jahán imán byárit ke taw maná rawán dátag. ");
INSERT INTO bccl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Á mazani o shawkat ke taw maná dátagat man áyáná dát o rasént tánke á yakk bebant, hamá dhawlá ke má yakk én, ");
INSERT INTO bccl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","man áyáni jesm o jáná bemánán o taw manigá, tánke á cha hamsetki o yakdeliá sarréch bebant. Á wahdi, jahána zánt ke taw maná rawán dátag o anchosh ke taw maná dóst dáshtag, áet ham dóst dáshtagant. ");
INSERT INTO bccl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Oo Pet! Mani wáhag esh ent, á ke taw maná bakshetagant hamódá ke man án, gón man hamódá yakjáh bebant, tán hamá shawkatá begendant ke taw maná bakshetag, chiá ke cha jahánay jórh bayagá pésar ham, taw maná dóst dáshtag. ");
INSERT INTO bccl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Oo ádelén Pet! Harchont ke jaháná tará nazánt o pajjáh nayáwort, man tará zánt o pajjáh áwort. Nun é ham zánant ke taw maná rawán dátag. ");
INSERT INTO bccl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Man tai nám gón áyán pajjárént o angat ham pajjárénáni, tán hamá mehr ke tará pa man hastent, áyáni del o jáná ham bebit o man áyáni del o jáná bebán.” ");
INSERT INTO bccl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Cha é habarán o rand, Issá gón wati moridán Kedrunay daragay á dastá shot. Ódá yak bágé hastat, Issá o áiay morid hamódá shotant. ");
INSERT INTO bccl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yahudáyá, ke áiay dróhók at, á jágah zánt, chiá ke Issá o áiay morid géshter hamódá shotant. ");
INSERT INTO bccl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Gorhá, Yahudáyá hokumati pawji gón parasteshgáhay sepáhigán, ke cha mazanén dini péshwá o Parisiáni némagá rawán dayag butagatant, zort o hamá bágá bortant. Áyán mashal o kandhil o seláh gón at. ");
INSERT INTO bccl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Issáyá zánt ke áiay sará chónén káré kapagi ent, démá shot o josti kort: “Kayá shóháza kanét?” ");
INSERT INTO bccl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Gwashtesh: “Issá Náseriay padá gardén.” Passawi dát: “Man Án!” Yahudá, Issáay dróhók ham hamódá at. ");
INSERT INTO bccl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Wahdé Issáyá gwasht: “Man án,” á poshtá kenzán kenzán zeminá kaptant. ");
INSERT INTO bccl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Padá gwashti: “Kai randá gardét?” Áyán gwasht: “Issá Náseriay.” ");
INSERT INTO bccl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Issáyá darráént: “Man shomárá gwasht: Man án. Agan mani randá gardét, eshán bellét ke rawant.” ");
INSERT INTO bccl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Issáyá é gwasht tán áiay pésarigén habar sarjam bebit: “Á ke taw maná dátagatant, cha áyán kass tabáh o halák nabut.” ");
INSERT INTO bccl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Á wahdi, Shamun Petrosá ke zahmé gón at kasshet o masterén dini péshwáay nawkaray rástén góshi gón zarbaté sest. Nawkaray nám Malkus at. ");
INSERT INTO bccl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Issáyá gón Petrosá gwasht: “Wati zahmá jotká kan! Á jámá nósh makanán ke Petá maná dátag?” ");
INSERT INTO bccl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Gorhá hokumati pawji o áyáni sarmaster o Yahudi sepáhigán, Issá dazgir kort o mohr o mohkam bast. ");
INSERT INTO bccl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Issáesh pésará Hannáay kerrá bort, ke á Kiápáay janay pet at. Kiápá á sálá, masterén dini péshwá at. ");
INSERT INTO bccl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","É hamá Kiápá at ke gón Yahudián gwashtagati: “Kawmay jáhá, yak mardoméay merag gehter ent.” ");
INSERT INTO bccl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Shamun Petros o dega moridé Issáay padá rawán but o shotant. Á dega moridá gón masterén dini péshwáyá pajjáróki hastat, paméshká gón Issáyá masterén dini péshwáay péshjáhá potert. ");
INSERT INTO bccl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bale Petros dhanná darwázagay nazziká óshtátagat. Gorhá á morid ke gón masterén dini péshwáyá pajjárók at, dhanná dar átk, darwázagpánén móleday góshá chizzé gwashti o Petrosi tóká bort. ");
INSERT INTO bccl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Á móledá Petrosay némagá dém tarrént o gwashti: “Záná, taw cha é marday moridán naay?” Áiá gwasht: “Na, naán!” ");
INSERT INTO bccl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Hezmatkár o sepáhigán ásé rók kortagat, chiá ke hawá sárt at. Ásay kerrá óshtátagatant o dast tápagá atant. Petros ham áyáni kerrá óshtátagat o watá tápagá at. ");
INSERT INTO bccl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Masterén dini péshwáyá cha Issáyá, áiay morid o tálim o sabakáni bárawá lahtén jost o pors kort. ");
INSERT INTO bccl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Issáyá passaw dát: “Man sajjahénáni démá róshen o pakká gapp o habar kortag. Modám kanisahán o mazanén parasteshgáhá, hamódá ke sajjahén Yahudi moccha bant, dars o sabakon dátag o hechbar panáh o chérokái chizzé nagwashtagon. ");
INSERT INTO bccl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Gorhá chiá cha man josta geray? Cha hamáyán jost beger ke mani gapp o habaresh eshkotagant. Á zánant man ché gwashtag.” ");
INSERT INTO bccl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Issáyá ke é habar kortant, yak sepáhigé ódá óshtátagat, Issái shahmáté jat o gwashti: “Masterén dini péshwáyá é dhawlá passawa dayay?” ");
INSERT INTO bccl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Issáyá darráént: “Agan man radén habaré kortag, maná mayárig bekan, agan ráston gwashtag, pa ché janay?” ");
INSERT INTO bccl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Gorhá Hannáyá Issá dast bastaká, masterén dini péshwá, Kiápáay kerrá dém dát. ");
INSERT INTO bccl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Shamun Petros hamódá óshtátagat o dast tápagá at. Lahténá gwasht: “Záná, taw cha áiay moridán naay?” Áiá namannet o gwashti: “Na, naán.” ");
INSERT INTO bccl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Cha masterén dini péshwáay hezmatkárán yakké, hamá marday syád at ke Petrosá áiay gósh borretagat. Áiá gón Petrosá gwasht: “Man wat tará gón áiá hamá bágá nadist?” ");
INSERT INTO bccl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Petrosá padá ham namannet. Hamá damáná, korósá báng dát. ");
INSERT INTO bccl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Sabáhá máhallah, Issáesh cha Kiápáay kerrá Rumay wáliay kalátá bort. Yahud, á kalátá nashotant ke nápák mabant o Sargwazay aiday waráká wárt bekanant. ");
INSERT INTO bccl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gorhá Pilátus átk o cha áyán josti kort: “É marday sará shomay bohtám chi ent?” ");
INSERT INTO bccl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Áyán passaw tarrént: “Agan mayárig mabutén má tai kerrá nayáwort.” ");
INSERT INTO bccl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilátusá gwasht: “Eshiá bebarét o gón wati Sharyatá pa eshiá hokm o shawré beborrét.” Yahudián gwasht: “Márá kasséay koshagay hakk o ehtiár nést.” ");
INSERT INTO bccl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Áherá, hamá dhawlá ke Issáyá wati markay bárawá gwashtagat, hamá dáb but. ");
INSERT INTO bccl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Randá Pilátus, wati kóth o kalátá shot o Issái hamódá lótháént o gwashti: “Haw! Taw Yahudiáni bádsháh ay?” ");
INSERT INTO bccl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Issáyá gwasht: “É tai jenday gapp o habar ent yá tará é dhawlá gwashtagesh?” ");
INSERT INTO bccl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilátusá gwasht: “Záná, man Yahudié án? Tai wati kawm o mazanén dini péshwáyán tará mani kerrá áwortag. Chiet kortag?” ");
INSERT INTO bccl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Issáyá passaw dát: “Mani bádsháhi, donyái bádsháhié naent. Agan mani bádsháhi donyái bádsháhié butén, mani hezmatkárán janga kort tánke Yahudiáni dastá makapán. Bale mani bádsháhi donyái naent.” ");
INSERT INTO bccl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilátusá gwasht: “Acha, taw bádsháhé ay?!” Issáyá gwasht: “Taw wat gwashagá ay ke man bádsháhé án. Man pédá butag o donyáyá átkagán ke pa rástiá gwáhi bedayán. Harkasá ke rásti dósta bit, mani habarán gósha dárit.” ");
INSERT INTO bccl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilátusá darráént: “Rásti chi ent?” Eshiay gwashagá o rand, Pilátus padá Yahudiáni kerrá shot o gwashti: “Man pa é mardá hech mayáré nagendán. ");
INSERT INTO bccl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Bale gón shomay rasmá, man Sargwazay aiday róchá, yak bandigé pa shomá ázáta kanán. Lóthét Yahudiáni bádsháhá pa shomá ázát bekanán?” ");
INSERT INTO bccl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Á sajjahénán kukkár kort: “Na, áiá nalóthén! Bárábásá ázát kan!” Bárábás, yak yágié at. ");
INSERT INTO bccl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Á wahdi, Pilátusá hokm dát Issáyá shallák o hayzarán bejanant. ");
INSERT INTO bccl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Pawjián cha dhangar o konthagán tájé jórhént o Issáay sará ér kort, bádsháhi jamurangén kabáhé ham gwará dátesh. ");
INSERT INTO bccl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Áiay kerrá áyán o gwashán atant: “Drud o drahbát, oo Yahudiáni bádsháh!” Shahmátesh ham jat. ");
INSERT INTO bccl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilátus padá Yahudiáni kerrá átk o gwashti: “Bechárét, shomay kerrá káráni tán bezánét ke man pa áiá hech mayáré nagendán.” ");
INSERT INTO bccl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Issá ke áiá konthagén tájé sará o jamurangén kabáhé gwará at, dhanná dar átk. Pilátusá gwasht: “Bechárét, é mard hamedá ent!” ");
INSERT INTO bccl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wahdé mazanén dini péshwáyán o áyáni sepáhigán á dist, kukkáresh kort: “Salibi kassh! Salibi kassh!” Pilátusá gwasht: “Shomá wat áiá salib bekasshét. Man hech warhén mayáré pa áiá nagendán.” ");
INSERT INTO bccl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Yahudián gwasht: “Márá Sharyaté hastent ke áiay rahbandáni redá, báyad ent koshag bebit, chiá ke gwashtagi: ‘Man Hodáay Chokk án.’” ");
INSERT INTO bccl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wahdé Pilátusá é eshkot, cha péshá géshter torsi delá nesht. ");
INSERT INTO bccl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wati kóth o kalátá shot o cha Issáyá josti kort: “Taw cha kojá ay?” Issáyá passaw nadát. ");
INSERT INTO bccl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilátusá gwasht: “Maná passawa nadayay? Taw nazánay ke tai ázáti o salib kasshagay ehtiár mani dastá ent?” ");
INSERT INTO bccl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Issáyá passaw dát: “Agan Hodáyá tará é ehtiár madátén, mani sará tará hech wák o ehtiáré néstat. Bale, hamá ke maná tai dastá dáti, géshter mayárbár ent.” ");
INSERT INTO bccl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Cha ed o rand, Pilátusá áiay ázát kanagay johda kort, bale Yahudián kukkára kort: “Agan é mardá ázát bekanay, Kaysaray dózwáh naay. Harkas watá bádsháh bezánt o belékit, Kaysaray dozhmen ent.” ");
INSERT INTO bccl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wahdé Pilátusá é eshkot, Issái dhanná áwort o wat yak jáhé pa hokm kanagá nesht ke áiá “Sengparsha” gwashant, pa Árámi zobáná “Jabbátá” bit. ");
INSERT INTO bccl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sargwazaytayáriay róchay némróchá, Pilátusá gón Yahudián gwasht: “Bechárét, shomay bádsháh hamedá ent!” ");
INSERT INTO bccl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Bale áyán kukkár kort: “Gári kan! Gári kan! Salibi kassh!” Pilátusá gwasht: “Pakká shomá lóthét ke shomay bádsháhá bekoshán?” Mazanén dini péshwáyán gwasht: “Cha Kaysará abéd, márá dega bádsháhé nést.” ");
INSERT INTO bccl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Áherá, Pilátusá Issá pawjiáni dastá dát ke áiá salibay sará bedranjant. Gorhá áyán Issá bort. ");
INSERT INTO bccl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Issáyá salibay konth baddhá at o “Kámpól” námén jágahéá bortesh, ke Árámi zobáná “Joljotá” gwashaga bit. ");
INSERT INTO bccl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Hamódá áesh zort o salibay sará dratk. Gón áiá dega do mardomesh ham salib kasshet, yakké rástén o domi chappén némagá. Issá, á doénáni nyámá at. ");
INSERT INTO bccl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilátusay hokmá, mayárnámagé nebeshtesh ke salibay sará dranjag bebit o á nebeshtag é dhawlá at “Issá Náseri - Yahudiáni bádsháh.” ");
INSERT INTO bccl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Cha Yahudián bázénéá é mayárnámag wánt, chiá ke Issáay salib kasshagay jágah cha shahrá dur naat o pa Ebráni, Látini o Yunáni zobánán nebisag butagat. ");
INSERT INTO bccl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Paméshká, Yahudiáni mazanén dini péshwáyán gón Pilátusá gwasht: “‘Yahudiáni bádsháh’ manebis, benebis ke é mardá gwashtag ‘man Yahudiáni bádsháh án’.” ");
INSERT INTO bccl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilátusá gwasht: “Harché ke man nebeshtag, nebeshtagon.” ");
INSERT INTO bccl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Cha salib kasshagá rand, pawjián Issáay pocch zortant, chár bahrá bahr kortant o har yakkéá yak bahré zort. Bale Issáay yak dazgwápén jámagé mant, ke áiá hech cháké néstat, sarjam o yakgwáp at. ");
INSERT INTO bccl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Gorhá áyán gón wat gwasht: “Byáét eshiá naderrén, eshiay sará pála janén, bechárén bárén kay katthit?” Hamá dáb ke Hodáay Pákén Ketába gwashit, hamá dhawlá but: “Mani pocchesh wati nyámá bahr kortant o jámagay sará pál jatesh.” Pawjián ham hamé kár kort. ");
INSERT INTO bccl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Salibay nazziká Issáay mát, gón wati gohár, Kliupásay jan Maryam o Maryam Majdaliahá óshtátagat. ");
INSERT INTO bccl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Wahdé Issáyá wati mát dist ke hamá dóstén moriday kerrá óshtátag, gón m átá gwashti: “Oo bánok! É tai chokk ent.” ");
INSERT INTO bccl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Randá gón wati moridá gwashti: “É tai mát ent.” Á moridá, cha hamá sáhatá rand Maryam wati lógá bort. ");
INSERT INTO bccl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nun Issáyá dist ke sajjahén chizz sarjam butagant o paméshká ke Pákén Ketábay habar sarjam bebant, gwashti: “Tonnig án.” ");
INSERT INTO bccl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Cha tropshén sharábá porrén kunzagé ódá ér at. Áyán yak espanjé zort o sharábén kort, dáréay sará bast o Issáay lonthán per mosht. ");
INSERT INTO bccl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wahdé Issáyá sharáb dap jat, gwashti: “Halás but!” Randá sari jahl ér áwort o sáhi dát. ");
INSERT INTO bccl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Á róch, Jomah o Sargwazay aiday tayári geragay róch at. Paméshká Yahudián nalóthet dár kasshetagénáni jón o jasad, á mazanén Shabbatay róchá salibay sará lónján bebant. Paméshká cha Pilátusá lóthetesh á sayénáni thángán bepróshant o cha salibáni sará ér begéjant. ");
INSERT INTO bccl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Gorhá pawji démá átkant o á doénáni pádesh próshtant ke gón Issáyá salib kasshag butagatant. ");
INSERT INTO bccl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Issáay kerrá ke átkant, distesh sáhi dátag. Paméshká áiay pádesh napróshtant. ");
INSERT INTO bccl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Bale cha pawjián yakkéá, nayzahé Issáay pahlugá jat o hamá damáná cha áiay jóná hónáp dar átk. ");
INSERT INTO bccl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Á kas ke wat é chizzáni sháhed butag, é habarána gwashit o áiay sháhedi rást ent. Á zánt ke rásténa gwashit tán shomá imán byárét. ");
INSERT INTO bccl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","É kár, hamá dhawlá but tán Pákén Ketábay habar sarjam bebit ke gwashit: “Áiay hech haddhé próshaga nabit.” ");
INSERT INTO bccl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Pákén Ketáb, dega yak jágahé ham gwashit: “Á hamá kasá chárant ke nayzahesh jatag.” ");
INSERT INTO bccl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Randá, Issop námén mardé ke Arimátiáay shahray nendók at o cha Yahudiáni torsá chérokái Issáay morid at, Pilátusay kerrá shot o Issáay jónay baragay ejázati lóthet. Pilátusá ejázat dát o áiá jón bort. ");
INSERT INTO bccl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikudimus, hamá ke awali randá yak shapé Issáay gendagá shotagat, átk o gón wat lahtén hór o hawárén morr o aud o karzarwáhi áwort, ke si kiluay kesásá atant. ");
INSERT INTO bccl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nun áyán Issáay jón zort o Yahudiáni kabr o kaponay dód o rabédagáni redá, gón washbóén dáruán lilomén godéá patát. ");
INSERT INTO bccl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Hamá salibay nazziká yak bágé at ke ódá nókén kabré hastat o angat kasé áiay tahá kabr nabutagat. ");
INSERT INTO bccl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yahudiáni tayáriay róch at o kabr ham hamá nazziká at, paméshká Issáay jónesh hamódá kabr kort. ");
INSERT INTO bccl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Haptagay awali róchá, bezán Yakshambehay sabáhá máhallah ke angat tahár at, Maryam Majdaliah kabray sará shot o disti hamá dhók ke kabray dapá at, cha kabrá dur kanag butag. ");
INSERT INTO bccl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Á pa maydán, Shamun Petros o Issáay hamá moriday kerrá átk ke Issáyá báz dóst at. Gwashti: “Wájahesh cha kabrá bortag, bale nazánén kojá éresh kortag.” ");
INSERT INTO bccl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Gorhá Petros o á dega morid ráh geptant o dém pa kabrá shotant. ");
INSERT INTO bccl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Har doénán maydán kort, bale á dega morid cha Petrosá gwast o cha áiá pésar kabray sará raset. ");
INSERT INTO bccl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Sari jahl kort o kabray tahá cháreti. Lilomén godi distant, bale wat kabray tahá nashot. ");
INSERT INTO bccl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Randá Shamun Petros raset o kabray tahá shot. Áiá ham dist ke kapon hamódá ent. ");
INSERT INTO bccl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Á dazmál ke Issáay sará bastagat kaponay kerrá naat, pétkagat o kammé durter yak kerréá ér at. ");
INSERT INTO bccl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Randá, á morid ke pésará kabray sará rasetagat kabray tahá shot, disti o imáni áwort. ");
INSERT INTO bccl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Chiá ke áyán, tán á wahdi Pákén Ketábay habar sarkech nawártagat ke Issá báyad ent cha mordagáni nyámá jáh bejant. ");
INSERT INTO bccl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Gorhá á doén morid, wati lógán per tarretant. ");
INSERT INTO bccl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryam cha kabrá dhann óshtátagat o gréti. Hamá dhawlá ke gréwagá at, sari jahl kort o kabray tóká cháreti. ");
INSERT INTO bccl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Hamódá ke Issáay jón ér butagat, do espétpóshén préshtagi dist, yakké sarunán neshtagat o á dega pádunán. ");
INSERT INTO bccl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Áyán gwasht: “Oo janén! Taw pa ché gréwagá ay?” Passawi dát: “Mani wájahesh bortag o nazánán kojá éresh kortag.” ");
INSERT INTO bccl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wahdé é gwashti, chakki tarrént o Issái dist hamódá óshtátagat, bale pajjáhi nayáwort. ");
INSERT INTO bccl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Issáyá gón áiá gwasht: “Oo bánok! Chiá gréwagá ay? Kai padá garday?” Maryamá hayál kort balkén bágpán ent. Gwashti: “Oo wájah! Agan taw bortag, maná begwash kojáet eshtag ke man áiá bebarán.” ");
INSERT INTO bccl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Issáyá passaw dát: “Oo Maryam!” Maryamá chakk tarrént o Árámi zobáná gwashti: “Rabbuni!” (Bezán: Oo mani ostád.) ");
INSERT INTO bccl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Issáyá gwasht: “Maná dast majan, chiá ke angat Petay kerrá borzád nashotagán, bale mani brátáni kerrá beraw o áyán begwash ke annun dém pa wati Petá o shomay Petá, wati Hodáyá o shomay Hodáyá borzáda rawán.” ");
INSERT INTO bccl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryam Majdaliah moridáni kerrá shot o mestági dát: “Man Hodáwand dist.” Gorhá Issáay kolawi pa áyán bort o sar kort. ");
INSERT INTO bccl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Hamá Yakshambehay shapá, wahdé morid cha Yahudiáni torsá lógéay tahá mocch atant ke darwázagi kobl atant, Issá átk, áyáni nyámá óshtát o gwashti: “Shomárá sohl o émeni sar bát.” ");
INSERT INTO bccl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","É habaray gwashagá rand, wati dast o pahlugi áyáná pésh dáshtant. Wahdé moridán Hodáwand dist, báz gal o shádán butant. ");
INSERT INTO bccl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Issáyá padá gwasht: “Shomárá sohl o émeni sar bát. Hamá dhawlá ke Petá maná ráh dátag, man shomárá rawána kanán.” ");
INSERT INTO bccl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Cha é habará rand, Issáyá morid dam jatant o gwashti: “Hodáay Pákén Ruhá begerét o wati delá jágah bedayét! ");
INSERT INTO bccl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Agan kaséay gonáhán bebakshét, bakshaga bant, áyán ke nabakshét, bakshaga nabant.” ");
INSERT INTO bccl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Cha dwázdahén moridán yakké, Tumá ke áesh “Járhó” náméntagat, Issáay áyagay wahdá gón áyán gón naat. ");
INSERT INTO bccl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Paméshká wahdé á dega morid gwashagá atant: “Má Hodáwand distag,” áiá gwasht: “Man tán áiay dastán, méháni thappá magendán, tánke wati lankoká, méháni thappá o dastá áiay pahlugá ér makanán, báwara nakanán.” ");
INSERT INTO bccl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Hasht róchá rand, wahdé morid padá yakjáh butant, Tumá ham gón at. Lógay dap band at, bale angat ham Issá gwast o áyáni nyámá óshtát o gwashti: “Shomárá sohl o émeni sar bát.” ");
INSERT INTO bccl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nun gón Tumáyá gwashti: “Wati lankoká edá byár, mani dastán bechár, wati dastá mani pahlugay sará ér kan o cha ed o rand béimán mabay, imándár bay.” ");
INSERT INTO bccl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tumáyá gwasht: “Oo mani Hodáwand, oo mani Hodá!” ");
INSERT INTO bccl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Issáyá gwasht: “Taw paméshká imán áwort ke maná distet. Bale bahtáwar hamá ant ke maná nagendant o imána kárant.” ");
INSERT INTO bccl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Issáyá wati moridáni démá, dega bázén mójezah o ajabbatén nesháni pésh dáshtag ke é Ketábá nebisag nabutagant. ");
INSERT INTO bccl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Bale haminchok nebisag butag tán shomá báwar kanét ke Issá, Masih ent o Hodáay Chokk, tánke imán byárét o áiay námay sará namiránén zenday wáhond bebét. ");
INSERT INTO bccl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Chizzé wahdá rand, Teberiahay mazangwarmay kerr o gwarán, padá Issáyá watá pa moridán paddar kort. Áiay záher bayag é dhawlá at ke ");
INSERT INTO bccl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Shamun Petros o hamá Tumá ke “Járhó” náméntagatesh o Natnáil ke cha Jalilay métag Kánáyá at, gón Zebdiay do chokk o dega do moridá hamódá atant. ");
INSERT INTO bccl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Shamun Petrosá gón áyán gwasht: “Man máhigiriá rawán.” Áyán gwasht: “Má ham káén gón.” Gorhá ráh geptant o bójigá neshtant, bale á shapá chizzé nageptesh. ");
INSERT INTO bccl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Sabáh ke but, Issá tayábá óshtátagat, bale moridán pajjáh nayáwort. ");
INSERT INTO bccl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Issáyá gón áyán gwasht: “Oo chokkán! Shomárá máhigé chizzé gón ent?” Áyán passaw dát: “Na.” ");
INSERT INTO bccl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Gwashti: “Dámá bójigay rástén némagá dawr dayét, ódá máhig gepta kanét.” Áyán anchosh kort o haminkadar máhigesh gept ke dámesh dém pa bójigá kasshet nakort. ");
INSERT INTO bccl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Gorhá hamá moridá ke Issáyá báz dóst at, gón Petrosá gwasht: “É Hodáwand ent!” Shamun Petros jándar at, wahdé é habari eshkot, wati pocchi gwará kortant o ápá koppi kort. ");
INSERT INTO bccl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Á dega morid mán bójigá, hoshkiay némagá átkant o porrén dámesh kasshakán kort, chiá ke cha tayábá sad gámá durter naatant. ");
INSERT INTO bccl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wahdé hoshkiá sar butant, rókén jal o eshkaráni sará, máhig o kammoké nánesh dist. ");
INSERT INTO bccl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Issáyá gón áyán gwasht: “Cha hamé máhigán kammoké byárét ke annun shomá geptagant.” ");
INSERT INTO bccl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Shamun Petros bójigá shot, dámé ke cha yaksad o panjáh o say mazanén máhigá porr at dém pa hoshkiá kassheti, máhigán dám ham nadertagat. ");
INSERT INTO bccl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Issáyá gwasht: “Byáét warag bwarét!” Cha moridán yakkéá ham tahm o joryat nakort cha Issáyá jost begipt: “Taw kay ay?” Áyán zánt ke é Hodáwand ent. ");
INSERT INTO bccl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Gorhá Issá démá átk, náni zort o áyáná dáti, hamé dhawlá máhigi ham bahr kortant. ");
INSERT INTO bccl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Cha wati zendag bayag o jáh janagá rand, é saymi bárig at ke Issá pa moridán záher but. ");
INSERT INTO bccl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ragbandá rand, Issáyá gón Shamun Petrosá gwasht: “Oo Shamun, Yuhannáay chokk! Tai mehr pa man cha eshán géshter ent?” Petrosá gwasht: “Oo Hodáwand! Taw zánay ke tará dósta dárán.” Issáyá gwasht: “Acha, mani gwaragán bechárén.” ");
INSERT INTO bccl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Domi randá gwashti: “Oo Shamun, Yuhannáay chokk! Bárén, maná dósta dáray?” Petrosá gwasht: “Oo Hodáwand! Taw zánay ke maná dóst ay.” Issáyá gwasht: “Gorhá mani pasáni delgóshá bedár.” ");
INSERT INTO bccl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Saymi bará gwashti: “Oo Shamun, Yuhannáay chokk! Bárén, maná dósta dáray?” Paméshká ke saymi bará josti kort: “Maná dósta dáray?” Petros molur o delranj but o gwashti: “Oo mani Hodáwand! Taw wat har chizzá zántkárter ay, taw zánay ke maná dóst ay.” Issáyá gwasht: “Mani pasán bechárén. ");
INSERT INTO bccl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tará rásténa gwashán, wahdé warná atay, srén bastagat o har jáh ke lóthetet, shotay. Bale wahdé pira bay, dastán drája kanay o degaré tai sréná bandit o tará anchén jáhé bárt ke nalóthay.” ");
INSERT INTO bccl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Gón é habarán, Issáyá pa hamá marká eshárah kort ke randá Petros gón áiá Hodáay námá shán o shawkat dayagi at. Gorhá gwashti: “Mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrosá chapp o chágerd cháret o disti hamá morid ke Issáyá báz dóst ent cha poshtá pédák ent, hamá ke shám waragay wahdá, Issáay nazziká kenzetagat o cha áiá josti kortagat: “Oo Hodáwand! Á kay ent ke tará dróhit o dozhmenáni dastá dant?” ");
INSERT INTO bccl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wahdé Petrosay chamm pa á moridá kapt, cha Issáyá josti kort: “Oo Hodáwand! Áiay ásar o ákebat ché bit?” ");
INSERT INTO bccl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Issáyá gwasht: “Agan mani razá é bebit ke tán mani áyagay wahdá á bemánit, tai che káré harába bit? Taw mani randgiriá bekan.” ");
INSERT INTO bccl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gorhá moridáni nyámá é habar tálán but ke balkén á morid hechbara namerit. Bale gapp esh ent, Issáyá nagwashtagat ke á namerit, tahná gwashtagati: “Agan mani razá é bebit ke tán mani áyagay wahdá á bemánit, tai che káré harába bit?” ");
INSERT INTO bccl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","É hamá morid ent ke é chizzi nebeshtagant o pa áyáni rásti o pakká bayagá gwáhia dant. Má zánén ke áiay sháhedi rást ent. ");
INSERT INTO bccl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Albat, Issáyá dega bázén kár kortagat. Agan á sajjahén nebisag buténant, mani hayálá sajjahén donyáyá pa á ketábán jágah néstat.");
INSERT INTO bccl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Oo wájah Tiupilos! Wati awali ketábay tahá, Issáay káráni bongéjá beger ");
INSERT INTO bccl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","tán hamá róchá ke dém pa ásmáná barag but, har káré ke áiá kortagat o har tálimé ke áiá dátagat, man tará sahig kort. Issáyá pa wati kásediá, lahtén mardom pésará gechén kortagat o cha Hodáay Pákén Ruhay némagá hokmi dátagatant o gwashtagatanti ke áyáni kár chi ant. ");
INSERT INTO bccl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Markay sakkiay saggagá rand, wati kásedáni démá záhera but o gón bázén gwáhián paddaria kort ke cha mordagáni nyámá zendag butag o jáhi jatag. Áiá, tán chel róchá watá kásedáni démá záhera kort o gón áyán Hodáay bádsháhiay bárawá habaria kort. ");
INSERT INTO bccl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yak randé ke gón áyán hórigá neshtag o warák waragá at, hokmi dátant: “Cha Urshalimay shahrá dhann marawét, Petay wádah dátagén Pákén Ruhay wadár o entezárá bebét ke shomá áiay bárawá pésará ham cha man eshkotag. ");
INSERT INTO bccl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yahyáyá mardom gón ápá pákshódi dátagant, bale Petay wádah esh ent ke laht