﻿USE sofia;
DROP TABLE IF EXISTS sofia.bcc_vpl;
CREATE TABLE bcc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bcc_vpl WRITE;
INSERT INTO bcc_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Bongéjá, Hodáyá ásmán o zemin addh kortant. ");
INSERT INTO bcc_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Zemin bédróshom at o hecchi mán néstat. Taháriá johlánki sarpósh kortagat o Hodáay Ruh ápay sarborá némbál at. ");
INSERT INTO bcc_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Hodáyá gwasht: “Rozhnái bebit” o rozhnái but. ");
INSERT INTO bcc_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Hodáyá dist ke rozhnái sharr ent, gorhá rozhni cha taháriá jetá kort. ");
INSERT INTO bcc_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Hodáyá rozhnay nám “róch” kort o taháriay nám “shap”. Shap gwast o sohb but. É awali róch at. ");
INSERT INTO bcc_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Hodáyá gwasht: “Ápáni nyámá kobbahé bebit ke ápá cha ápá jetá bekant.” ");
INSERT INTO bcc_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Hodáyá kobbah addh kort o kobbahay chéray áp cha sarboray ápán jetá kortant. É kár but. ");
INSERT INTO bcc_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Hodáyá kobbahay nám “ásmán” kort. Shap gwast o sohb but. É domi róch at. ");
INSERT INTO bcc_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Hodáyá gwasht: “Ásmánay chéray áp yakk némagé bebant o hoshki paddar bebit” o anchosh but. ");
INSERT INTO bcc_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Hodáyá hoshkiay nám “zemin” kort o yakjáh butagén ápáni nám “daryá”. Hodáyá dist ke é kár sharr but. ");
INSERT INTO bcc_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Hodáyá gwasht: “Zemin sabzag beródénit; tohmdárén keshár o nibag dayókén drachk, ke har drachkay bará, áiay jenday tohm mán bebit, áyáni jenday tahray hesábá” o anchosh but. ");
INSERT INTO bcc_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Zeminá sabzag ródént; tohmdárén keshár o nibag dayókén drachk ke hamok drachkay bará wati tohm mán at, áyáni jenday tahray hesábá. Hodáyá dist ke é kár sharr but. ");
INSERT INTO bcc_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Shap gwast o sohb but. É sayomi róch at. ");
INSERT INTO bcc_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Hodáyá gwasht: “Ásmánay kobbahá rozhnáén chizz mán bebit ke róchá cha shapá jetá bekanant. É rozhnáén chizz mósom, róch o sáláni nesháni bebant. ");
INSERT INTO bcc_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","É, kobbahá nur jórh bebant o zeminá rozhná bekanant” o anchosh but. ");
INSERT INTO bcc_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Hodáyá do mazanén nur addh kort, masterén nuri addh kort ke róchay sará hákemi bekant o kasterén nur shapay sará. Estári ham addh kortant. ");
INSERT INTO bcc_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Hodáyá é nur, ásmánay kobbahá ér kortant ke zeminá rozhn bedayant o ");
INSERT INTO bcc_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","róch o shapay sará hákemi bekanant o rozhná cha taháriá jetá bekanant. Hodáyá dist ke é kár sharr but. ");
INSERT INTO bcc_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Shap gwast o sohb but. É cháromi róch at. ");
INSERT INTO bcc_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Hodáyá gwasht: “Áp cha sahdáráni ramán porr bebant o báli morg, zeminay sarborá, ásmánay kobbahá bál bekanant.” ");
INSERT INTO bcc_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Gorhá Hodáyá mazanén daryái sahdár o warh warhén dega sahdár addh kort ke é, wati tahray hesábá ram jórh butant o daryáesh porr kort. Hamé paymá warh warhén báli morgi addh kort, áyáni jenday tahray hesábá. Hodáyá dist ke é kár sharr but. ");
INSERT INTO bcc_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Hodáyá é sajjahén barkat dát o gwashtant: “Chokk o bar kanét. Gésh bayán bebét o daryáyán porr kanét. Báli morg ham zeminá sakk báz bebant.” ");
INSERT INTO bcc_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Shap gwast o sohb but. É panchomi róch at. ");
INSERT INTO bcc_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Hodáyá gwasht: “Zemin har paymén sahdár pédá bekant, áyáni jenday tahray hesábá; dalwatá beger tán lápkasshén jánwar o wakshién haywáná, har yakké wati tahray hesábá.” É kár but. ");
INSERT INTO bcc_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Hodáyá zeminay wakshién haywán áyáni jenday tahray hesábá, dalwat áyáni jenday tahray hesábá o zeminay sará lápkasshén jánwar áyáni jenday tahray hesábá jórh kortant. Hodáyá dist ke é kár sharr but. ");
INSERT INTO bcc_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Hodáyá gwasht: “Byá ensáná wati jenday dróshomá addha kanén, wati sheklá ke daryáay máhig, ásmánay morg, dalwat, sajjahén wakshién haywán o lápkasshén jánwaráni sará hákemi bekant.” ");
INSERT INTO bcc_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Hodáyá ensán wati sheklá addh kort, wati jenday Hodái sheklá addhi kort, mardén o janéni addh kortant. ");
INSERT INTO bcc_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Hodáyá á, barkat dát o gwashtant: “Chokk o bar kanét, báz bebét o zeminá porr kanét o zeminay sará hákemi bekanét. Daryáay máhig, ásmánay morg o zeminay sajjahén sorendaháni sará hákemi bekanét.” ");
INSERT INTO bcc_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Hodáyá gwasht: “Bechárét, man shomárá zeminay saray hamá sajjahén sabzagána dayán ke tohma kárant o hamá sajjahén drachkána dayán ke baránesh jenday tohm mán ent. É shomay warák ant. ");
INSERT INTO bcc_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Man zeminay sajjahén haywán, ásmánay sajjahén morg, sajjahén lápkasshén jánwar, bezán hamok sahdár ham pa waráká sabzag dátag.” É kár but. ");
INSERT INTO bcc_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Hodáyá wati sajjahén jórh kortagén chizz cháretant. Disti ke é kár sakk sharr but. Shap gwast o sohb but. É shashomi róch at. ");
INSERT INTO bcc_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","É paymá ásmán o zemin o é sajjahén chizzáni jórh bayag sarjam but. ");
INSERT INTO bcc_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Haptomi róchá, Hodáyá hamá kár sarjam kortagatant ke dastá atanti. Wati sajjahén káráni halásiá rand, haptomi róchá árámi kort. ");
INSERT INTO bcc_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Gorhá Hodáyá haptomi róch barkat dát, gisshént o pákén róch námént, chéá ke Hodáyá hamé róchá cha é sajjahén hastiay jórh kanagay kárá árám kort. ");
INSERT INTO bcc_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","É zemin o ásmánay kessah at ke jórh kanag butant. Á wahdá ke Hodáwandén Hodáyá zemin o ásmán jórh kortant, ");
INSERT INTO bcc_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","zeminay sará hecch drachk o dár narostagat o dhagárán sabzag néstat. Chéá ke tán á wahdá Hodáwandén Hodáyá zeminay sará hawr nagwáréntagat o angat ensáné néstat ke zeminá kesht o kesháré bekant. ");
INSERT INTO bcc_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Bale cha zeminá ápay chammag botkant o sajjahén zeminay sarboresh séráp kort. ");
INSERT INTO bcc_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Hodáwandén Hodáyá cha zeminay háká mardomé jórh kort, áiay pónzá zenday sáhi damet o é mardom sahdáré but. ");
INSERT INTO bcc_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Hodáwandén Hodáyá ródarátká, Adaná bágé jórh kort o wati addh kortagén mardomi hamódá nádént. ");
INSERT INTO bcc_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Hodáwandén Hodáyá cha háká har warhén drachk ródént ke gendagá zébá o baresh waragá wassh atant. Zenday drachk o néki o badiay zánagay drachk bágay nyámá atant. ");
INSERT INTO bcc_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Pa bágay áp dayagá kawré hastat ke bonzehi Adaná at o cha ódá é kawr chár jáhá bahra but. ");
INSERT INTO bcc_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Awali kawray nám Pishón ent ke Hawilahay sajjahén sardhagárá ke sohr o teláhi mán, chahra wárt. ");
INSERT INTO bcc_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Á sardhagáray sohr, sharrén sohré o ódá kóhi bód o senge solaymán ham hast. ");
INSERT INTO bcc_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Domi kawray nám Géhun ent ke Kushay sajjahén sardhagárá chahra wárt. ");
INSERT INTO bcc_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Sayomi kawray nám Dejlah ent ke Áshuray ródarátki gwar o pahnátána tachit o cháromi kawr Parát ent. ");
INSERT INTO bcc_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Hodáwandén Hodáyá á mardom zort o Adanay bágá jahmenend kort ke bágá ábád bekant o bágay hayálá bedárit. ");
INSERT INTO bcc_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Hodáwandén Hodáyá mard parmán dát ke bágay har drachkay bará waray bwar, ");
INSERT INTO bcc_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","bale néki o badiay zánagay drachkay bará mawar. Hamá róchá ke taw wárt, allamá meray. ");
INSERT INTO bcc_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Hodáwandén Hodáyá gwasht: “Pa mardá tahnái sharr naent. Man pa áiá, hamdarwarén hamráh o madat kanóké jórha kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Hodáwandén Hodáyá cha háká zeminay saray sajjahén wakshién haywán o ásmánay sajjahén morg jórh kortagatant. Nun á sajjahéni marday kerrá áwortant tán bechárit ke bárén mard áyán kojám námán tawára kant. Har náméá ke mardá á sahdár tawár kortant, hamá áyáni nám but. ");
INSERT INTO bcc_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Mardá sajjahén dalwat, ásmánay morg o zeminay wakshién haywán nám per bastant, bale mardá hamdarwarén hamráh o madat kanóké néstat. ");
INSERT INTO bcc_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Gorhá Hodáwandén Hodáyá mard gránén wábé sará dát. Mard ke wáb at gorhá Hodáyá áiay yakk pahlugé kasshet o háligén jáhi gón góshtá porr kort. ");
INSERT INTO bcc_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Hodáwandén Hodáyá cha mardá kasshetagén pahlug janéné kort o janéni marday kerrá áwort. ");
INSERT INTO bcc_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Gorhá mardá gwasht: “Nun é cha mani haddhán haddhé o cha mani góshtán góshté. É báyad ent janén gwashag bebit, chéá ke cha mardéná zurag butag.” ");
INSERT INTO bcc_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Paméshká mard wati pet o mátá yalaha kant o gón janá hawára bit, gorhá á doén, yakk jesm o jána bant. ");
INSERT INTO bcc_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ádam o áiay jan, doén luch o jándar atant o áyán sharma nakort. ");
INSERT INTO bcc_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Már cha Hodáwandén Hodáay jórh kortagén á dega wakshién haywánán thagter o chálákter at. Áiá gón janéná gwasht: “É rást ent ke Hodáyá gwashtag bágay hecch drachkay bará mawarét?” ");
INSERT INTO bcc_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Janéná gwasht: “Má bágay drachkáni bar o samarán wárta kanén, ");
INSERT INTO bcc_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","bale Hodáyá gwashtag ke hamá drachkay bará mawarét ke bágay nyámá ent. Áiá dast ham per makanét. Agan na, merét.” ");
INSERT INTO bcc_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Márá gwasht: “Shomá pakká namerét. ");
INSERT INTO bcc_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Bale Hodá zánt, hamá róchá ke shomá á drachkay bará warét, shomay chamm pacha bant, shomá Hodáay paymá bét o nék o badá zánét.” ");
INSERT INTO bcc_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Nun janéná cháret ke á drachkay bar gwashay pa waragá wassh o gendagá zébá ent o pa zántkár bayagá delwáh. Gorhá áiá cha drachkay barán zort o wárt o wati mardárá ham dáti, ke hamráh ati. Mardá ham wárt. ");
INSERT INTO bcc_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Nun doénáni chamm pach butant o zántesh ke má jándar én. Cha enjiray tákán pa wat póshákesh dótk. ");
INSERT INTO bcc_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Gwátá ke sar kort, áyán Hodáwandén Hodáay pádbramsh eshkot ke bágá gám janagá at. Mard o áiay janá, watá bágay drachkáni poshtá cha Hodáwandén Hodáyá chér dát. ");
INSERT INTO bcc_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Hodáwandén Hodáyá mard gwánk jat o gwasht: “Kojá ay?” ");
INSERT INTO bcc_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Áiá passaw dát: “Man bágá tai pádbramsh eshkot o maná torset chéá ke jándar atán, paméshká man watá chér dát.” ");
INSERT INTO bcc_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Hodáyá gwasht: “Kayá tará gwasht ke taw jándar ay? Taw hamá drachkay bar wártag ke man tará gwashtag mawari?” ");
INSERT INTO bcc_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Mardá gwasht: “Hamá janén ke taw maná dátag, hamáiá á drachkay bar maná dát o man wárt.” ");
INSERT INTO bcc_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Gorhá Hodáwandén Hodáyá gón janéná gwasht: “É che káré ke taw kort?” Janéná gwasht: “Márá maná rad dát o man wárt.” ");
INSERT INTO bcc_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Hodáwandén Hodáyá gón márá gwasht: “Taw ke é kár kortag, nun taw sajjahén dalwat o sajjahén wakshién haywánáni nyámá masterén nálati ay. Taw wati zenday sajjahén róchán pa lápkasshokái raway o tai warák hák o danza bit. ");
INSERT INTO bcc_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Man taig o janénay nyámá, tai nasl o janénay naslay nyámá dozhmeni pédá kanán. Eshiay nasl tai saragá jant o taw áiay páday punzá janay.” ");
INSERT INTO bcc_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Hodáyá gón janéná gwasht: “Man tai chellagiay dardán sakk báza kanán, taw gón dard chokk pédá kanay. Tai wáhag pa wati mardá bit o á, tai sará wájahia kant.” ");
INSERT INTO bcc_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Hodáyá gón Ádamá gwasht: “Taw wati janay habar gósh dásht o hamá drachkay bar wárt ke man tará hokm dátagat ke cha eshiá mawar, paméshká tai sawabá zemin nálati ent. Taw wati zenday sajjahén róchán pa sakki o sóri cha zeminá wati waráká kasshay. ");
INSERT INTO bcc_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Zemin pa taw konthag o dhangara kárit o taw zeminay sabzagána waray. ");
INSERT INTO bcc_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Gón hédén péshánigé wati naganá waray tán hamá wahdá ke háká pera tarray, chéá ke cha hameshiá zurag butagay. Taw háké ay o padá háká pera tarray.” ");
INSERT INTO bcc_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Ádamá wati janay nám Hawá kort, chéá ke á, sajjahén mardománi mát ent. ");
INSERT INTO bcc_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Hodáwandén Hodáyá, pa Ádam o áiay janá, cha póstá póshák jórh kort o gwará dátant. ");
INSERT INTO bcc_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Hodáwandén Hodáyá gwasht: “Nun ensán may payméné jórh butag o nék o badá zánt, chó mabit ke wati dastá shahár bedant o zenday drachkay bará bezurit o bwárt o tán abad zendag bebit.” ");
INSERT INTO bcc_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Gorhá Hodáwandén Hodáyá á cha Adanay bágá dar kort ke zeminay sará kesht o keshár bekant, hamá zemin ke cha áiay háká á jórh kanag butagat. ");
INSERT INTO bcc_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Ensánay gallénagá rand, pa zenday drachkay ráhay bandagá, Hodáyá Adanay bágay ródarátki némagá karrubi óshtáréntant o anchén ásgwárén zahmé ham éri kort ke har némagá chahria wárt. ");
INSERT INTO bcc_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Ádamá, gón wati jan Hawáyá wapt o wáb kort o Hawáay láp porr but o Káen pédá but. Hawáyá gwasht: “Cha Hodáwanday barkatá, maná mardénchokké butag.” ");
INSERT INTO bcc_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Randá Hawáyá Káenay brát, Hábil pédá kort. Hábilá shepánkia kort o Káená dehkáni. ");
INSERT INTO bcc_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kammé wahdá o rand, Káená cha wati dhagáray bar o samarán pa Hodáwandá thékié áwort. ");
INSERT INTO bcc_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Hábilá ham cha wati ramagay pasáni awali chokkán lahtén kosht o áyáni pigi gósht zort o pa Hodáyá théki áwort. Hodáwandá Hábil o áiay théki pasond butant, ");
INSERT INTO bcc_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","bale Káen o áiay théki áiá pasond nabutant. Káen sakk zahr gept o démi tahár but. ");
INSERT INTO bcc_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Hodáwandá gón Káená gwasht: “Chéá zahr ay? Chéá tai dém tahár ent? ");
INSERT INTO bcc_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Agan taw sharrén kár bekanay, tai hayálá kabul kanaga nabay? Bale agan taw sharrén kára nakanay, gonáh tai darwázagay poshtá óshtátag o tai randá kaptag. Taw báyad ent gonáhay sará báládast bebay.” ");
INSERT INTO bcc_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Káená gón wati brát Hábilá gwasht: “Byá dhagáray sará rawén.” Dhagárá ke shotant, Káená wati brát Hábilay sará orosh kort o koshti. ");
INSERT INTO bcc_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Gorhá Hodáwandá gón Káená gwasht: “Tai brát Hábil kojá ent?” Áiá gwasht: “Nazánán. Záná man wati brátay negahpán án?” ");
INSERT INTO bcc_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Hodáwandá gwasht: “Taw che káré kort? Tai brátay hón cha zeminá gón man peryát kanagá ent. ");
INSERT INTO bcc_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Nun taw nálatié ay. Cha é zeminá darpadar kanaga bay ke dapi pa tai brátay hónay ér baragá pach ent, hamá hón ke cha tai dastá réchag butag. ");
INSERT INTO bcc_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Wahdé zeminá kára kanay, zemin pa taw bara nayárit o taw, jaháná darpadar o béáráma bay.” ");
INSERT INTO bcc_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Káená gón Hodáwandá gwasht: “Mani sezá cha mani sagg o bardáshtá dhann ent, ");
INSERT INTO bcc_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","maróchi taw maná cha é sarzeminá gallénay. Man cha tai bárgáhá gára bán. Jaháná darpadar o béáráma bán o harkas ke gón man dhikk bwárt, maná koshit.” ");
INSERT INTO bcc_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Hodáwandá gón áiá gwasht: “Chosha nabit. Harkas ke tará bekoshit, áiay sezá hapt saria bit.” Gorhá Hodáwandá Káenárá nesháné per kort tánke agan kasé gón áiá dhikk bwárt, makoshiti. ");
INSERT INTO bcc_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Káen cha Hodáwanday bárgáhá dar but o Adanay ródarátká, Nóday sardhagárá nesht. ");
INSERT INTO bcc_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Káená gón wati janá wapt o wáb kort o áiay janay láp porr but o cha áiá Hanuk námén chokké pédá but. Káen shahré addh kanagá at o shahray námi wati mardénchokkay námay sará Hanuk kort. ");
INSERT INTO bcc_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Cha Hanuká Irád pédá but, cha Irádá Mehuyáil, cha Mehuyáilá Metusháil o cha Metusailá Lamék. ");
INSERT INTO bcc_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laméká do jan gept, awaliay nám Ádah at o domiay Zellah. ");
INSERT INTO bcc_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Cha Ádahá Yábál pédá but. Yábál, hamá mardománi pet at ke gedánnend atant o dalwatesha dásht. ");
INSERT INTO bcc_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Yábálay brátay nám Yubál at. Yubál, chang o nal janókáni pet at. ");
INSERT INTO bcc_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Cha Zellahá, Tubál-Káen pédá but ke brenj o ásenay warh warhén awzár o sámánáni addh kanók at. Tubal-Káenay goháray nám Nahmah at. ");
INSERT INTO bcc_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laméká gón wati janán gwasht: “Oo Ádah o Zellah! Mani tawárá gósh dárét. Oo Lamékay janán! Mani gappán gósh dárét. Yakk mardéá maná thappig kort o man á kosht, warnáén mardé ke maná thappigi kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Agan Káenay bér hapt sari geraga bit, Lamékay bér haptád o hapt sari geraga bit.” ");
INSERT INTO bcc_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Ádamá padá gón wati janá wapt o wáb kort o áiay janá mardénchokké áwort. Janá chokkay nám Sayt kort. Gwashti: “Hodáyá maná Hábilay badalá dega chokké dátag, parchá ke Káená Hábil kosht.” ");
INSERT INTO bcc_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Saytá ham mardénchokké but o áiay námi Énósh kort. Hamé wahdá mardomán Hodáwanday námay tawár kanag bendát kort. ");
INSERT INTO bcc_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ádamay nasl o padréchay ketábi kessah chosh ent: Hodáyá á róchá ke ensán jórh kort, wati sheklá jórhi kort. ");
INSERT INTO bcc_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Mardén o janéni jórh kortant. Hamá wahdá ke addhi kortant, barkati dátant o áyáni námi ensán kort. ");
INSERT INTO bcc_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ádamá ke 130 sál but, wati paymén, wati sheklay mardénchokkéay pet but o áiay námi Sayt kort. ");
INSERT INTO bcc_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Saytay pédáeshá rand, Ádamá 800 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","É hesábá Ádamá sarjamiá 930 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Saytá ke 105 sál but, cha áiá Énósh pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Énóshay pédáeshá rand, Saytá 807 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","É hesábá Saytá sarjamiá 912 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Wahdé Énóshá 90 sál but, cha áiá Kenán pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Cha Kenánay pédáeshá rand, Énóshá 815 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Énóshá sarjamiá 905 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenáná ke 70 sál but, cha áiá Mahalalél pédá but ");
INSERT INTO bcc_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalélay pédáeshá rand, Kenáná 840 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenáná sarjamiá 910 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Wahdé Mahalalélá 65 sál but, cha áiá Yáred pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yáreday pédáeshá rand, Mahalalélá 830 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalélá sarjamiá 895 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Wahdé Yáred 162 sál but, cha áiá Hanuk pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Hanukay pédáeshá rand, Yáred 800 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yáred sarjamiá 962 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Wahdé Hanuká 65 sál but, cha áiá Metushálah pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Metushálahay pédáeshá rand, Hanuká 300 sál Hodáay ráhá gáma jat o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Hanukay sarjamén omr 365 sál but. ");
INSERT INTO bcc_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Hanuká Hodáay ráhá gáma jat o randá kassá nadist, chéá ke Hodáyá Hanuk zendagá zort o bort. ");
INSERT INTO bcc_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Wahdé Metushálahá 187 sál but, cha áiá Lamék pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lamékay pédáeshá rand, Metushálahá 782 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Metushálahá sarjamiá 969 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Wahdé Laméká 182 sál but, cha áiá mardénchokké pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Áiá wati chokk Nuh námént o gwasht: “É chokk márá cha may dastáni hamá gránén kár o zahmatán ásudaga kant ke cha Hodáay nálat kortagén zeminá chest butagant.” ");
INSERT INTO bcc_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nuhay pédáeshá rand, Laméká 595 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laméká sarjamiá 777 sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nuhay omr 500 sál but o randá cha áiá Sám o Hám o Yápet pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Zeminay sará, mardom ke gésh bayán butant o janénchokkesha áwort, ");
INSERT INTO bcc_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Hodáay mardénchokkána dist ke jenekk sharrang o zébá ant. Gorhá pa wat jenekesh gechéna kort o zort. ");
INSERT INTO bcc_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Nun Hodáwandá gwasht: “Mani arwáh tán abad ensánay jesm o jáná namánit, chéá ke ensán merókén chizzé o cha yakk sad o bist sálá géshter omra nakant.” ");
INSERT INTO bcc_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Á róchán o rand ham zeminay sará Nepilim hastatant. Hodáay mardénchokk ke ensánáni jenekkáni kerrá shotant, é jenekkán chokka áwort. É chokk kwahnén zamánagay mazanmard o námdárén mardom atant. ");
INSERT INTO bcc_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Hodáwandá dist ke ensánay radkári zeminay sará sakk báz ant o sajjahén del o hayálesh modám gón badiá ent o bass. ");
INSERT INTO bcc_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Hodáwand pashómán but ke man donyáyá ensán chéá jórh kort. Hodáwanday del sakk padard but. ");
INSERT INTO bcc_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Gwashti: “Wati jórh kortagén ensáná cha zeminay sará gár o gomsára kanán. Mardomán, chárpádén haywánán, lápkasshén jánwarán o ásmánay báli morgán yakjáh gomsára kanán, chéá ke man cha esháni jórh kanagá padard án.” ");
INSERT INTO bcc_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Bale Hodáwand cha Nuhá razá at. ");
INSERT INTO bcc_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nuhay kessah chosh ent: Nuh, wati dawr o bárigay mardománi nyámá pahrézkár o béaybén mardé at. Á Hodáay ráhá at. ");
INSERT INTO bcc_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nuh, say mardénchokkay pet at: Sám o Hám o Yápet. ");
INSERT INTO bcc_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Nun Hodáay chammán zemin sell o cha sheddatá porr at. ");
INSERT INTO bcc_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Hodáyá dist ke zemin sell butag, chéá ke donyáay sajjahén mardomán badén ráhé geptagat. ");
INSERT INTO bcc_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Gorhá Hodáyá gón Nuhá gwasht: “Man sajjahén mardomán tabáha kanán, chéá ke hamesháni sawabá zemin cha sheddatá porr ent. Man, esháni jendá gón zeminá hór, gár o gomsára kanán. ");
INSERT INTO bcc_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Cha góparay dárá pa wat mazanén bójigé jórh kan. Bójig, tóká kóthi kóthi bebit. Bójigay dhanná o tóká gón dhámbará dón. ");
INSERT INTO bcc_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Bójigá anchó addh kan ke drájiá say sad dast bebit, práhiá panjáh dast o borziá si dast. ");
INSERT INTO bcc_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Bójigay sará band, bale borzádi némagay chapp o chágerdá yakk dasté pach bell. Bójigay kashá darwázagé per kan. Bójigá say tabak kan: chéri, nyámi o borzi tabak. ");
INSERT INTO bcc_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Man donyáyá anchén hár o tuppáné kárán ke ásmánay chéray sajjahén sahdára merant, har sahdár ke dama kasshit, bérána bit. Harché ke zeminay sará hast, sajjahéna merant. ");
INSERT INTO bcc_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Bale man gón taw wati ahd o paymáná bandán. Taw bójigá swára bay; taw o tai bachakk o tai lógi o tai neshár. ");
INSERT INTO bcc_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Cha sajjahén sahdárán yakk yakk jotké gón wat bójigá bar gón, naréné o mádagéné, ke wati hamráhiá zendagesh bedáray. ");
INSERT INTO bcc_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Cha har tahray báli morg, har tahray chárpádén haywán, zeminay saray har tahray lápkasshén jánwarán, yakk yakk jotké tai kerrá kayt tánke é sajjahénán zendag bedáray. ");
INSERT INTO bcc_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Har paymén warák o warden bezur gón. Ambáresh kan ke shomayg o haywánáni waragay kárá káyant.” ");
INSERT INTO bcc_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Gorhá Nuhá hamé paymá kort. Harché ke Hodáyá gwashtagat, Nuhá kort. ");
INSERT INTO bcc_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Hodáyá gón Nuhá gwasht: “Taw gón wati lógay sajjahén mardomán bójigay tahá beraw, chéá ke mana gendán ke é naslá pahrézkár taw ay. ");
INSERT INTO bcc_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Cha sajjahén helárén haywánán hapt jotk gón wat bar gón, narén o áiay mádagéná, cha sajjahén harámén jánwarán yakk yakk jotké, narén o áiay mádagéná, ");
INSERT INTO bcc_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","o cha ásmáni morgán hapt jotk, narén o mádagén, ke sarjamén zeminay sará áyáni naslá zendag bedáray. ");
INSERT INTO bcc_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Hapt róchá rand, anchén hawré gwárénán ke tán chell róch o chell shapá gwárit o man wati jórh kortagén sajjahén sahdárán cha zeminá gár o gomsára kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Harché ke Hodáwandá gwashtagat, Nuhá hamá paymá kort. ");
INSERT INTO bcc_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","É wahdá ke zeminay sará hár átk, Nuhay omr shash sad sál at. ");
INSERT INTO bcc_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nuh o áiay jan o chokk o neshár bójigá potertant ke cha hár o tuppáná berakkant. ");
INSERT INTO bcc_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Cha helári o harámén haywán o morg o sajjahén lápkasshén jánwarán, ");
INSERT INTO bcc_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","jotk jotká, naréné o mádagéné, Nuhay kerrá átk o bójigá potert, hamá paymá ke Hodáyá Nuh hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Hapt róchá rand zeminay sará hár o tuppáné átk. ");
INSERT INTO bcc_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nuhay omray shash sadomi sálay domi máhay habdahomi róchá, johlánkiáni sajjahén chammag botkant o ásmánay darig pach butant. ");
INSERT INTO bcc_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Chell róch o chell shapá zeminay sará hawrán gwart. ");
INSERT INTO bcc_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Hamé róchay jendá Nuh o áiay chokk Sám o Hám o Yápet o Nuhay jan o sayén neshár bójigá potertant. ");
INSERT INTO bcc_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Áyáni hamráhiá har paymén sahdár wati tahray hesábá gón at; har paymén dalwat wati tahray hesábá, har paymén lápkasshén jánwar wati tahray hesábá o har paymén morg wati tahray hesábá, har paymén bánzolién sahdár. ");
INSERT INTO bcc_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Har sahdár ke zenday sáhi mán at, jotké jotké Nuhay kerrá átk o bójigá potert. ");
INSERT INTO bcc_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Hamá paymá ke Hodáyá Nuh hokm dátagat, har sahdáray nar o mádag bójigá potertant. Nun Hodáwandá darwázag bast. ");
INSERT INTO bcc_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Tán chell róchá zemin hárá mallet o áp gésh bayán but o bójigi cha zeminá borz chest kort. ");
INSERT INTO bcc_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Zeminay sará áp anchó ke borzter bayán but, bójig ham ápay sarborá trappal but. ");
INSERT INTO bcc_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Áp zeminay sarborá sakk chest but o sajjahén ásmánay chéray drostigén borzén kóh zéráp butant. ");
INSERT INTO bcc_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Áp borzter rawán but o kóhi chér o andém kortant. Áp cha kóháni thollán kesás chár gwáz borzter shot. ");
INSERT INTO bcc_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Zeminay saray sajjahén sahdár bérán butant; morg o dalwat o wakshién haywán o hamá sajjahén sahdár ke zeminay sará romb o ramaga kanant o sajjahén ensán ham. ");
INSERT INTO bcc_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Hamá sajjahén sorendah ke hoshkén zeminá atant, hamá ke zenday sáhesh mán at, bérán butant. ");
INSERT INTO bcc_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Hodáyá zeminay saray sajjahén sahdár gár o gomsár kortant. Ensán o jánwar o lápkassh o ásmánay morg, sajjahén cha zeminá gár butant. Éwaká Nuh o hamá ke gón áiá bójigá gón atant, pasht kaptant. ");
INSERT INTO bcc_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tán yakk sad o panjáh róchá zemin ápá mán póshetagat. ");
INSERT INTO bcc_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Hodáyá Nuh o hamá sajjahén wakshién haywán o dalwat yát kortant ke Nuhay hamráhiá bójigá atant. Hodáyá zeminay sará gwáté ráh dát o áp ér áyán but. ");
INSERT INTO bcc_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Johlánkiáni chammag o ásmánay darig band butagatant o cha ásmáná hawráni gwárag ham band butagat. ");
INSERT INTO bcc_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Áp kamm kammá cha zeminay sará kamm b ayán but. Yakk sad o panjáh róchá rand áp jahl shotagat. ");
INSERT INTO bcc_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Haptomi máhay habdahomi róchá bójig Árárátay kóháni sará óshtát. ");
INSERT INTO bcc_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tán dahomi máhá áp angat kamm bayán at. Dahomi máhay awali róchá kóháni tholl záher butant. ");
INSERT INTO bcc_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Chell róchá rand, Nuhá hamá darig pach kort ke áiá bójigá per kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Gwarágé dhanná ráhi dát. Gwarágá tán hamá wahdá bál kort o gasht ke zeminay saray áp hoshk butant. ");
INSERT INTO bcc_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Padá kapóté ráhi dát tán bechárit ke áp cha zeminay sará kamm butag yá na. ");
INSERT INTO bcc_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Bale kapótá choshén jáhé nadist ke wati pádán ér bekant, chéá ke sajjahén zemin angat ápay chérá at. Gorhá kapót bójigá, Nuhay kerrá per tarret. Nuhá wati dast shahárt, kapóti gept o bójigá áwort. ");
INSERT INTO bcc_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nuhá dega hapt róch wadár kort o padá kapóti cha bójigá ráh dát. ");
INSERT INTO bcc_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Wahdé kapót bégáhá áiay kerrá per tarret, zaytunay tázagén táké dapá ati. Nun Nuhá zánt ke cha zeminay sará áp kamm butag. ");
INSERT INTO bcc_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Nuhá dega hapt róch wadár kort o padá kapóti ráh dát. É bari kapót áiay kerrá per natarret. ");
INSERT INTO bcc_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nuhay omray shash sad o yakomi sálay awali máhay awali róchá zeminay saray áp hoshk butagat. Nuhá bójigay sarpósh kasshet o disti ke zemin hoshk ent. ");
INSERT INTO bcc_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Domi máhay bist o haptomi róchá zemin sarjamá hoshk at. ");
INSERT INTO bcc_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Gorhá Hodáyá gón Nuhá gwasht: ");
INSERT INTO bcc_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Cha bójigá dar á, gón wati jan o chokk o neshárán. ");
INSERT INTO bcc_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Hamá sajjahén sahdár ke tai hamráh ant, dhanná baresh gón, báli morg o jánwar o sajjahén lápkasshán, tánke zeminay sará romb o ramag bekanant, chokk o bar bekanant o géshá gésh bebant.” ");
INSERT INTO bcc_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Gorhá Nuh gón wati jan o chokk o neshárán dar átk. ");
INSERT INTO bcc_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Sajjahén jánwar o sajjahén lápkassh o sajjahén báli morg o zeminay saray sajjahén sorendah cha bójigá dar átkant, har yakké wati tahray hesábá. ");
INSERT INTO bcc_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nun Nuhá pa Hodáwandá korbánjáhé addh kort o cha helárén haywán o helárén báli morgán lahténi zort o korbánjáhá sóchagi korbánigi kortant. ");
INSERT INTO bcc_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Esháni wasshén bó ke Hodáwanday kerrá sar but, wati delá gwashti: “Man cha ed o rand hechbar zeminá ensánay sawabá nálata nakanán, bell toré cha kasániá áiay delay wáhag bad ant. Cha ed o dém hechbar sajjahén sahdárán é paymá hórigá gár o gomsára nakanán ke annun kortagon. ");
INSERT INTO bcc_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Tán hamá wahdá ke zemin hastent kesht o keshár o rón o móshay wahd, sárti o garmi, garmág o zemestán o róch o shapa naóshtant.” ");
INSERT INTO bcc_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Hodáyá Nuh o áiay chokk barkat dát o gwashtant: “Chokk o bar kanét o gésh bebét o donyáyá porr kanét. ");
INSERT INTO bcc_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Zeminay sajjahén haywán, ásmánay sajjahén báli morg, sajjahén lápkassh o daryáay sajjahén máhig shomay tors o bimmay chérá bant. É sajjahén shomay dastá dayag butagant. ");
INSERT INTO bcc_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Har sorendah ke sáhi mán ent, shomay waráka bit o anchó ke man shomárá sabzag dátagant, nun har chizza dayán. ");
INSERT INTO bcc_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Bale á góshtá hechbar mawarét ke áiá zend, bezán hón mán ent. ");
INSERT INTO bcc_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Harkas ke shomay hóná beréchit o sáhá begipt, man cha áiá hesába gerán. Cha har haywáná hesába gerán o cha har ensáná. Cha hamá mardomá hesába gerán ke dega mardoméá koshit, chéá ke mardom brát ant. ");
INSERT INTO bcc_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Harkas ensánéay hóná beréchit, áiay hón ham ensánéay dastá réchaga bit, chéá ke Hodáyá ensán wati sheklá addh kortag. ");
INSERT INTO bcc_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Nun shomá, chokk o bar kanét o zeminay sará gésh bebét, zeminay sará sheng o tálán o géshá cha gésh bebét.” ");
INSERT INTO bcc_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Gorhá Hodáyá gón Nuh o áiay chokkán ke Nuhay hamráh atant, gwasht: ");
INSERT INTO bcc_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Nun man gón shomá o gón shomay randi naslán ahd o paymáné kanán. ");
INSERT INTO bcc_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Gón har sahdárá ke shomay kerrá ent, báli morg, dalwat o wakshién haywán o har yakk chizzéá ke gón shomá cha bójigá dar átkag, gón zeminay hamok sahdárá ham é ahd o paymáná kanán. ");
INSERT INTO bcc_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Man gón shomá wati é ahd o paymáná kanán ke dega baré sajjahén sahdár cha hár o tuppánay ápá bérána nabant; dega hechbar choshén háré nayayt ke sajjahén zeminá wayrán bekant.” ");
INSERT INTO bcc_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Hodáyá gwasht: “É hamá ahd o paymánay nesháni ent ke man, wati o shomay o hamá sajjahén sahdáráni nyámá bandagá án ke gón shomá gón ant. É pa sajjahén áyókén naslán ahd o paymáné. ");
INSERT INTO bcc_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Man wati sanj, jambaráni tahá ér kortag o é, mani o zeminay nyámá butagén ahd o paymánay neshánia bit. ");
INSERT INTO bcc_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Harwahd ke man zeminay sarborá jambara kárán o sanj ham jambaráni tahá záhera bit, ");
INSERT INTO bcc_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","gorhá wati é ahd o paymánay yátá kapán ke mani o shomay o har tahray sajjahén sahdáráni nyámá ent. Nun áp hechbar chó hára nakant ke sajjahén sahdárán tabáh bekant. ");
INSERT INTO bcc_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Harwahd ke sanj jambaráni tahá záhera bit, mania gendán o hamá abadmánén ahd o paymánay yátá kapán ke mane Hodá o zeminay har tahray sajjahén sahdáráni nyámá butag.” ");
INSERT INTO bcc_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Hodáyá gón Nuhá gwasht: “Esh ent hamá ahd o paymánay nesháni ke man, wati o zeminay sajjahén sahdáráni nyámá bastag.” ");
INSERT INTO bcc_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nuhay chokk cha bójigá dar átkant, Sám o Hám o Yápet. Hám Kanhánay pet at. ");
INSERT INTO bcc_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","É sayén Nuhay chokk atant o cha hameshán mardom sajjahén zeminay sará sheng o tálán butant. ");
INSERT INTO bcc_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nuhá kesht o keshár bendát kort o anguri bágé addhi kort. ");
INSERT INTO bcc_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Hamé anguray sharábi wárt, malár but o gedánay tahá jándar but. ");
INSERT INTO bcc_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kanhánay pet Hámá, wati pet jándará dist o wati doén brát ke dhanná atant, hál dátant. ");
INSERT INTO bcc_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Sám o Yápetá kabáhé zort, wati kópagáni sará ér kort o poshtokái shotant o wati petay jándariesh póshént. Áyáni dém ángor at o wati petay jándariesh nadist. ");
INSERT INTO bcc_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Wahdé Nuh cha sharábay malárá dar átk, zánti mani kasterén bachakká gón man ché kortag, ");
INSERT INTO bcc_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","gwashti: “Kanháná nálat bát. Wati brátáni golámáni golám bát.” ");
INSERT INTO bcc_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nuhá gwasht: “Hodáwandá satá bát, Sámay Hodáyá. Kanhán, Sámay golám bát. ");
INSERT INTO bcc_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Hodá zeminá pa Yápetá práhter kanát. Yápet, Sámay gedánáni tahá jahmenend bát o Kanhán, áiay golám bát.” ");
INSERT INTO bcc_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Cha hárá rand Nuhá dega say sad o panjáh sál omr kort. ");
INSERT INTO bcc_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Nuhá sarjamiá noh sad o panjáh sál omr kort o mort. ");
INSERT INTO bcc_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nuhay chokk, Sám o Hám o Yápetay nasl o padréchay kessah chosh ent: Eshán cha tuppáná rand chokk o bar kort. ");
INSERT INTO bcc_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Gumer o Májuj o Madái o Yáwán o Tubál o Máshek o Tirás, Yápetay mardénchokk atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ashkenáz o Ripat o Tugarmah, Gumeray mardénchokk atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Elishah o Tarshish o Kettimi mardom o Dódánimi mardom, Yáwánay mardénchokk atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Cha eshán tayábdapi mardom wati sardhagárán tálán butant, har yakké gón wati jenday zobáná, wati kabilaháni hesábá, wati kawmáni tahá. ");
INSERT INTO bcc_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kush o Mesráim o Put o Kanhán, Hámay mardénchokk atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Sebá o Hawilah o Sebtáh o Rámah o Sabteká, Kushay mardénchokk atant. Sabá o Dédán, Rámahay mardénchokk atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cha Kushá Namrud pédá but ke zeminay sará awali zórmandén jangól at. ");
INSERT INTO bcc_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Hodáwanday chammán Namrud, zrengén shekárié at, paméshká gwashaga bit: “É mard, Hodáwanday chammán Namruday paymén mazanén shekárié.” ");
INSERT INTO bcc_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Namruday bádsháhiay bendát cha Bábel, Erek, Akkád o Kalnehá but ke Shináray sardhagárá atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Á cha é sardhagárá Áshurá shot o ódá Naynawá, Rahubut-Ir, Kálah o ");
INSERT INTO bcc_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Risenay shahri addh kortant. Risen, Naynawá o Kálahay nyámá ent, Kálah mazanén shahré. ");
INSERT INTO bcc_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Cha Mesráimá, Ludi o Anami o Lehábi o Naptuhi mardom pédá butant o ");
INSERT INTO bcc_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Patrusi o Kapturi o Kasluhi mardom, ke cha Kasluhián, Pilesti pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanhánay awali chokk Saydun at o padá Hitti o ");
INSERT INTO bcc_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yabusi o Amuri o Gergáshi o ");
INSERT INTO bcc_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Héwi o Arki o Sini o ");
INSERT INTO bcc_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwádi o Semári o Hamáti mardom pédá butant. Randá Kanháni kabilah sheng o tálán butant. ");
INSERT INTO bcc_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Kanhánay hadd o simsar, cha Sayduná ke dém pa Gerárá raway tán Gazzahá at o agan dém pa Sodum, Gomurah, Admah o Sebwimá raway, tán Lasháhá at. ");
INSERT INTO bcc_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Hámay naslay kessah, áyáni kabilah o zobán o sardhagár o kawmay hesábá hamesh at. ");
INSERT INTO bcc_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Sám ke Yápetay masterén brát at, áiá ham mardénchokk but. Sám, Eberay sajjahén chokkáni bonpirok ent. ");
INSERT INTO bcc_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sámay mardénchokk, Ilám o Áshur o Arpakshád o Lud o Arám atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Arámay mardénchokk, Uz o Hul o Giter o Másh atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arpakshád, Shelahay pet at o Shelah, Eberay pet. ");
INSERT INTO bcc_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eberá do mardénchokk but, yakkéay nám Péleg at, chéá ke hamé wahdá zemin bahr o báng but. Brátay námi Yoktán at. ");
INSERT INTO bcc_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yoktán, Almudád o Shélep o Hazarmáwet o Yérah o ");
INSERT INTO bcc_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadurám o Uzál o Deklah o ");
INSERT INTO bcc_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Óbál o Abimáél o Sabá o ");
INSERT INTO bcc_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ópir o Hawilah o Yubábay pet at. É sajjahén Yoktánay mardénchokk atant. ");
INSERT INTO bcc_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Á damagá ke é nendók atant, cha Mesháyá dém pa Sepárá at, ródarátkay kóhestagén molká. ");
INSERT INTO bcc_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sámay chokkáni kessah, áyáni kabilah o zobán o sardhagár o kawmay hesábá hamesh at. ");
INSERT INTO bcc_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nuhay mardénchokkáni kabilah, áyáni sar o bonay red o banday sará, áyáni kawmáni hesábá hamesh atant. Tuppáná rand cha hameshán sajjahén kawm zeminay sará sheng o tálán butant. ");
INSERT INTO bcc_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Sajjahén donyáay zobán yakkén at o labz yakkén atant. ");
INSERT INTO bcc_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mardom ke cha ródarátká laddhetant, Shináray sardhagárá dashté distesh o hamódá jahmenend butant. ");
INSERT INTO bcc_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Gón yakdomiá gwashtesh: “Byá, heshta janén o sharriay sará pachénesh.” Áyán sengay jáhá hesht kára bast o gelay jáhá dhámbar. ");
INSERT INTO bcc_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Gwashtesh: “Byá pa wat shahré addha kanén, anchén borjé máni bebit ke sartholli ásmáná sar bebit, tánke pa wat námé ér bekanén ke sajjahén zeminay sará sheng o sháng mabén.” ");
INSERT INTO bcc_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Hodáwand ér átk tánke hamá shahr o borjá bechárit ke mardomi addh kanagá atant. ");
INSERT INTO bcc_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Hodáwandá gwasht: “Edá bechár, nun é yakkén ráj o kawm ant o sajjahénáni zobán yakk ent. Agan é káresh bendát kortag, cha ed o dém é harché kanag belóthant, pa eshán nabutenia nabit. ");
INSERT INTO bcc_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Byá, jahláda rawén o esháni zobáná garh o manja kanén ke é, yakdomiay habarán sarpad mabant.” ");
INSERT INTO bcc_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Hodáwandá, é mardom cha ódá sajjahén zeminay sará sheng o sháng kortant o eshán shahray addh kanagay kár band kort. ");
INSERT INTO bcc_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Paméshká á shahray nám Bábel but ke Hodáwandá ódá sajjahén donyáay yakkén zobán garh o manj kort. Áiá mardom cha ódá zortant o sajjahén zeminay sará sheng o sháng kortant. ");
INSERT INTO bcc_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sámay nasl o padréchay kessah chosh ent: Tuppáná do sálá rand wahdé Sámay omr 100 sál at, cha áiá Arpakshád pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arpaksháday pédáeshá rand, Sámá 500 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arpaksháday omr 35 sál at ke cha áiá Shelah pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shelahay pédáeshá rand, Arpakshádá 403 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shelahay omr 30 sál at ke cha áiá Eber pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Eberay pédáeshá rand, Shelahá 403 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eberay omr 34 sál at ke cha áiá Péleg pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pélegay pédáeshá rand, Eberá 430 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pélegay omr 30 sál at ke cha áiá Rahu pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rahuay pédáeshá rand, Pélegá 209 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rahuay omr 32 sál at ke cha áiá Serug pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Serugay pédáeshá rand, Rahuá 207 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Serugay omr 30 sál at ke cha áiá Náhór pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Náhóray pédáeshá rand, Serugá 200 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Náhóray omr 29 sál at ke cha áiá Térá pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Téráay pédáeshá rand, Náhórá 119 sál omr kort o áiá dega mardénchokk o janénchokk ham but. ");
INSERT INTO bcc_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Téráay omr 70 sál but o randá cha áiá Ebrám o Náhór o Hárán pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Téráay nasl o padréchay kessah chosh ent: Cha Téráyá Ebrám o Náhór o Hárán pédá butant. Cha Háráná Lut pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Háránay pet, Térá angat zendag at o Hárán mán Kaldániáni shahr Urá mort, hamódá ke pédá butagat. ");
INSERT INTO bcc_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Ebrám o Náhór, doénán sur o sáng kort. Ebrámay lógiay nám Sárái at o Náhóray lógiay nám Melkah. Melkah, Háránay jenekk at o Hárán, Melkah o Yaskáhay pet. ");
INSERT INTO bcc_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sárái santh at o chokki néstat. ");
INSERT INTO bcc_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Téráyá wati chokk Ebrám o nomásag Lut, ke Háránay chokk at o wati neshár, bezán Ebrámay jan Sárái zortant o cha Kaldániáni shahr Urá dar átk. É sajjahén dém pa Kanhánay sardhagárá ráh geptant, bale wahdé Háránay shahrá rasetant, hamódá neshtant. ");
INSERT INTO bcc_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Téráyá do sad o panch sál omr kort o Háráná mort. ");
INSERT INTO bcc_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Hodáwandá gón Ebrámá gwasht: “Wati molk, wati syád o wáres o wati petay lógá yalah day o cha edá hamá molká beraw ke man tará péshia dárán. ");
INSERT INTO bcc_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Man tará mazanén kawmé jórha kanán, tará barkata dayán o tai námá borza kanán o taw barkaté bay. ");
INSERT INTO bcc_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Hamá mardom ke tará barkata dayant, man áyán barkata dayán o hamá mardom ke tará nálata kanant, man áyán nálata kanán o zeminay sajjahén kawm tai sawabá barkata gerant.” ");
INSERT INTO bcc_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Gorhá hamá paymá ke Hodáwandá gón Ebrámá gwashtagat, Ebrám shot o Lut ham áiay hamráh but. Ebrám ke cha Háráná dar átk, omri haptád o panch sál at. ");
INSERT INTO bcc_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Ebrámá wati lógi Sárái o brázátk Lut hamráh kortant o dém pa Kanháná ráh gept. Hamá sajjahén mál ke áyán mocch kortagatant o hamá mardom ke Háráná áyáni dastá kaptagatant, áiá gón wat bortant gón. Kanhánay sardhagárá átk o rasetant. ");
INSERT INTO bcc_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ebrám á molká tarr o táb kanán tán Murehay mazanén drachkay jágahá, Shekémá shot. Á wahdá, é molká Kanháni nendók atant, ");
INSERT INTO bcc_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Bale Hodáwand, Ebrámay démá záher but o gwashti: “Cha mani némagá é sardhagár tai nasl o padréchayg ent.” Gorhá Ebrámá ódá pa Hodáwandá, ke áiay démá záher butagat, korbánjáhé addh kort. ");
INSERT INTO bcc_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Cha ódá á, dém pa kóhestagá, Bayt-Élay ródarátki némagá shot o wati gedáni anchén jágahé mekk kort ke Bayt-Élay shahr áiay rónendi némagá o Ayáay shahr, ródarátki némagá at. Ódá pa Hodáwandá korbánjáhé addhi kort o Hodáwanday námi tawár kort. ");
INSERT INTO bcc_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Gorhá Ebrám cha ódá dar átk o dém pa Negébá rawán but. ");
INSERT INTO bcc_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bale Kanháná dhokkál at o Ebrám, dém pa Mesrá jahlád ráh gept tánke pa wahdéá hamódá, darámadéay paymá bedárit, chéá ke sakkén dhokkálé at. ");
INSERT INTO bcc_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Wahdé Mesray nazzikká átk o raset, gón wati lógi Sáráiá gwashti: “Mana zánán ke taw zébáén janéné ay. ");
INSERT INTO bcc_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Mesri tará begendant, gwashant: ‘É, eshiay lógi ent,’ gorhá maná koshant bale tará zendagá kellant. ");
INSERT INTO bcc_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Begwash ke man eshiay gohár án, tánke pa taigi gón man sharr bebant o tai sawabá mani sáh berakkit.” ");
INSERT INTO bcc_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ebrám ke Mesrá átk, Mesrián dist ke Sárái sakkén zébáén janéné. ");
INSERT INTO bcc_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Perawnay apsarán ke Sárái dist, Perawnay kerrá áiay sárháyagá laggetant o Sárái Perawnay kalátá barag but. ");
INSERT INTO bcc_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Perawn, Sáráiay háterá gón Ebrámá mehrabán but o Ebrám pas o gók o lág o mádyán o golám o móled o oshteráni wáhond but. ");
INSERT INTO bcc_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Bale Hodáwandá Ebrámay lógi, Sáráiay sawabá Perawn o áiay lógay sará mazanén wabá o warh warhén nádráhi dawr dát. ");
INSERT INTO bcc_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Perawná Ebrám lótháént o gwasht: “É che káré at ke taw gón man kort? Taw chéá maná hál nadát ke é tai lógi ent? ");
INSERT INTO bcc_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Chéá gwashtet: ‘É mani gohár ent,’ ke man pa jani zort? Bechár, é tai jan ent. Zuri o beraw.” ");
INSERT INTO bcc_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Perawná Ebrámay bárawá wati apsár hokm dátant o áyán Ebrám gón lógi o sajjahén mál o hastiá rahádag kort. ");
INSERT INTO bcc_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ebrámá harché ke hastat, zortanti o gón wati lógiá cha Mesrá borzád ráh gept o Negébá shot. Lut ham gón áiá gón at. ");
INSERT INTO bcc_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Ebrám, mál o dalwat o teláh o nograhá báz hastómand at. ");
INSERT INTO bcc_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Á, cha Negébá laddhán o rawán tán Bayt-Élá raset, tán Bayt-Él o Ayáay shahráni nyámá, hamá jágahá ke pésará wati gedáni mekk kortagat, ");
INSERT INTO bcc_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","hamá jágahá ke pésará korbánjáhé addhi kortagat. Ódá Ebrámá Hodáwanday nám tawár kort. ");
INSERT INTO bcc_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Lut ham ke Ebrámay hamsapar at, áiá pas o dalwat o gedán hastat. ");
INSERT INTO bcc_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Bale jágah pa Lut o Ebrámay yakjáh nendagá kamm at, chéá ke mál o dalwatesh báz at. Paméshká hór neshtesh nakort. ");
INSERT INTO bcc_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ebrám o Lutay shepánk arhetant. Á zamánagá Kanháni o Perizzi ham é sardhagárá jahmenend atant. ");
INSERT INTO bcc_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Gorhá Ebrámá gón Lutá gwasht: “Má brát én. Mani o tai nyámá, yá mani o tai shepánkáni nyámá arh o korhé mabit. ");
INSERT INTO bcc_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Sajjahén molk tai démá ent. Cha man jetá bay. Agan taw chappén némagá raway, man rásténá rawán o agan taw rástén némagá raway, man chappéná rawán.” ");
INSERT INTO bcc_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Lutá chamm chest kortant, disti ke Ordonay sajjahén dasht, tán Sóhará séráp ent, Hodáwanday bágay dhawlá, Mesray sardhagáray dhawlá. É cha á wahdá pésar at ke Hodáwandá Sodum o Gomurahay shahr gár o bégwáh kortant. ");
INSERT INTO bcc_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Gorhá Lutá Ordonay sajjahén dasht pa wat gechén kort o dém pa ródarátká ráh gept o doén mard cha yakdomiá jetá butant. ");
INSERT INTO bcc_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ebrám Kanhánay sardhagárá nesht o Lut hamá shahrán jahmenend but ke dashtá atant. Lutá wati gedán zort o Sodumay nazzikká mekk kortant. ");
INSERT INTO bcc_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodumay mardom badkár o Hodáwanday démá báz gonahkár atant. ");
INSERT INTO bcc_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lut ke cha Ebrámá jetá but, Hodáwandá gón Ebrámá gwasht: “Cha wati hamé jágahá, chammán chest kan o shomál, jonub, ródarátk o rónenday némagá bechár, ");
INSERT INTO bcc_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","é sajjahén molká ke taw gendagá ay, cha mani némagá é tán abad tai o tai nasl o padréchayg ent. ");
INSERT INTO bcc_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Tai nasl o padréchá zeminay danzáni paymá báza kanán, agan kasé danz o gobárán hesáb korta kant, gorhá tai nasl o padréchá ham hesáb korta kant. ");
INSERT INTO bcc_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Pád á, é molkay dráji o práhiá tarr o gard bekan, ke eshiá man tará dayán.” ");
INSERT INTO bcc_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Gorhá Ebrámá wati gedán chest kortant o Hebruná shot o Mamrehay mazanén drachkáni nazzikká jahmenend but. Ódá pa Hodáwandá korbánjáhé addhi kort. ");
INSERT INTO bcc_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Shináray bádsháh Amrápel o Elásaray bádsháh Aryuk o Ilámay bádsháh Kedorlámer o Góimay bádsháh Tidálay zamánagá, ");
INSERT INTO bcc_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","é bádsháhán gón Sodumay bádsháh Bárah o Gomurahay bádsháh Bershá o Admahay bádsháh Shenáb o Sebwimay bádsháh Shémeber o Bélahay bádsháhá jang kort. Bélahay domi nám Sóhar ent. ");
INSERT INTO bcc_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nun é goddhi panchén bádsháh, Seddimay daragá, bezán Wádzeray daragá yakjáh butant. ");
INSERT INTO bcc_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Eshán tán dwázdah sálá Kedorlámeray hezmat kort o sézdahomi sálá sarkeshiesh kort. ");
INSERT INTO bcc_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Chárdahomi sálá Kedorlámer gón hamráhén bádsháhán átk o mán Asterut-Karnaymá Repáhi mahluki prósh dát, Zuzi mahluki mán Hámá o Émi mahluki mán Sháweh-Keryátaymá prósh dátant. ");
INSERT INTO bcc_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Hórái mahluki, mán kóhestagén molká, Sahirá beger tán El-Páráná prósh dát. El-Párán gyábánay nazzikká ent. ");
INSERT INTO bcc_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Nun per tarretant o En-Meshpátá bezán Kádeshá átkant o Amálikiáni sajjahén molkesh gept. Hasásun-Tamárá neshtagén Amuriáni molkesh ham gept. ");
INSERT INTO bcc_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Gorhá Sodumay bádsháh, Gomurahay bádsháh, Admahay bádsháh, Sabuimay bádsháh o Bélahay, bezán Sóharay bádsháh, dhanná dar átkant o Seddimay daragá janagay tayáriesh kort o ");
INSERT INTO bcc_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","gón Ilámay bádsháh Kedorlámer o Góimay bádsháh Tidál o Shináray bádsháh Amrápel o Elásaray bádsháh Aryuká jangesh kort, bezán chár bádsháh, panch bádsháhay helápá. ");
INSERT INTO bcc_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Seddimay darag cha dhámbaray kandhá porr at o wahdé Sodum o Gomurahay bádsháh tatkant, báz mardom é kandháni tahá kapt o é dega mardom dém pa kóhestagá tatkant. ");
INSERT INTO bcc_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Gorhá chárén bádsháhán Sodum o Gomurahay sajjahén mál o maddhi o tóshag zort o shotant. ");
INSERT INTO bcc_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ebrámay brázátk Lut, Sodumá jahmenend at. Áesh ham gept o gón sajjahén mál o maddhiá gón wat bort. ");
INSERT INTO bcc_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Yakk mardomé tatk o Ebránién Ebrámay kerrá átk o é háli dát. É wahdá Ebrám, Amurién Mamrehay mazanén drachkáni nazzikká neshtagat. Amurién Mamreh, Eshkul o Áneray brát at. Esháni o Ebrámay nyámá ahd o paymáné hastat. ");
INSERT INTO bcc_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Wahdé Ebrámá eshkot ke mani brázátk gerag o barag butag, wati hamá say sad o hazhdahén dar áwortagén jangól, ke áiay lógá pédá butagatant, zortanti o tán Dánay shahrá dozhmenáni randá kapt. ");
INSERT INTO bcc_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Shapay wahdá áiá wati hamráh thóli thóliá bahr kortant o dozhmenay sará oroshi kort o próshi dátant o tán Hóbahá, ke Dameshkay shomálá ent, áyáni randá kapt. ");
INSERT INTO bcc_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Ebrámá sajjahén mál o maddhi pach geptant o wati brázátk Lut o áiay mál o hasti, janénádam o é dega mardom padá áwortant. ");
INSERT INTO bcc_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Wahdé Ebrám cha Kedorlámer o áiay hampattén bádsháháni prósh dayagá rand per tarragá at, Sodumay bádsháh tán Sháwehay daragá, ke bádsháhay darag ent, áiay péshwáziá átk. ");
INSERT INTO bcc_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Gorhá Salimay bádsháh Malkisediká, ke borzén arshay Hodáay dini péshwá at, nán o sharáb áwort. ");
INSERT INTO bcc_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Áiá Ebrám barkat dát o gwasht: “Ebrám! Tará cha borzén arshay Hodá, ásmán o zeminay addh kanókay némagá barkat berasát. ");
INSERT INTO bcc_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Borzén arshay Hodáyá satá o saná bát ke dozhmeni tai dastá dátant.” Gorhá Ebrámá, áiárá cha har chizzá dahyakk dát. ");
INSERT INTO bcc_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Sodumay bádsháhá gón Ebrámá gwasht: “Mani mardomán maná beday o mál o maddhián bezur, taig ant.” ");
INSERT INTO bcc_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Ebrámá gón Sodumay bádsháhá gwasht: “Man Hodáwanday démá, borzén arshay Hodá, ásmán o zeminay jórh kanókay démá dast chest kortag o sawgend wártag ");
INSERT INTO bcc_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","harché ke taig ent, man cha áyán heccha nazurán, yakk bandikké yá swásbandé ham nazurán. Chosh mabit taw begwashay ke Ebrám man hastómand kortag. ");
INSERT INTO bcc_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Man hecch chizza nazurán abéd cha hamá warákán ke warnáyán wártagant o hamá mardománi bahrá ke mani hamráhiá átkagant, bezán Áner, Eshkul o Mamreh. Á wati bahrá bezurant.” ");
INSERT INTO bcc_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Cha é chizzán o rand, Hodáwanday habar elhám o shobénéay tahá pa Ebrámá átk: “Oo Ebrám! Mators, man tai espar án. Tai enám sakk mazan ent.” ");
INSERT INTO bcc_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Bale Ebrámá gwasht: “Oo Hodáwandén Hodá! Taw maná ché dayay? Maná wa chokk nést o mani lógay wáres Dameshki Elizar ent.” ");
INSERT INTO bcc_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Padá gwashti: “Taw maná chokk o poshpadé nadátag o bándá róch mani lógay hezmatkáré mani wáresa bit.” ");
INSERT INTO bcc_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Bale Hodáwanday habar Ebrámá sar but ke é hezmatkár tai wáresa nabit, tai jendá mardénchokké bit o hamá tai wáresa bit. ");
INSERT INTO bcc_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Hodáwandá Ebrám dhanná bort o gwasht: “Ásmáná bechár o estárán hesáb kan, agan hesábesh korta kanay. Tai nasl o padréch esháni paymá báza bit.” ");
INSERT INTO bcc_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Ebrámá Hodáwanday sará báwar kort o Hodáwandá Ebrámay é báwar, pa áiá páki o palgárié hesáb kort. ");
INSERT INTO bcc_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nun Hodáwandá gón áiá gwasht: “Man hamá Hodáwand án ke tará cha Kaldániáni shahr, Urá daron kort o áwort ke é sardhagárá tará bedayán o taw eshiay wáhond bebay.” ");
INSERT INTO bcc_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Bale Ebrámá gwasht: “Oo Hodáwandén Hodá! Man chón bezánán ke eshiay wáhonda bán?” ");
INSERT INTO bcc_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Gorhá Hodáwandá gwasht: “Pa man say sáligén mádagén góké, say sáligén bozé, say sáligén gwarándhé, shántolé o kasánén kapóté byár.” ");
INSERT INTO bcc_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Ebrámá é sajjahén pa Hodáwandá áwort o do kappá kortant o har tal, domi talay démá ér kort, bale morgi kapp nakortant. ");
INSERT INTO bcc_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Dhundhwárén morg ke é jónáni sará neshtant, Ebrámá galléntant. ");
INSERT INTO bcc_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Wahdé róch ér nendagá at, Ebrám gránén wábéá gept o bazén o torsnákén taháriéá áiay sará mán shánt. ");
INSERT INTO bcc_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Gorhá Hodáwandá gwasht: “Deljam bay o bezán ke tai nasl o padréch anchén sardhagáréá darámadéáy paymá jahmenenda bit ke á molk áyáni naent. Tai óbádag ódá goláma bant o tán chár sad sálá zolm o zórákiay ámácha bant. ");
INSERT INTO bcc_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Bale man, á kawmá sezá dayán ke tai naslá goláma kant. Padá tai padréch gón mazanén mál o maddhiéá cha ódá dara kayt. ");
INSERT INTO bcc_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Bale taw wat pa émeni wati bonpirokáni kerrá raway o sharrén mazanén omréá rand kabr kanaga bay. ");
INSERT INTO bcc_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Tai padréch, cháromi naslá edá pera tarrit chéá ke Amuriáni badkári angat purah o sarjam nabutag.” ");
INSERT INTO bcc_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Róch ke ér nesht o taháriá mán shánt, ásdáné ke dutt dayán at gón rókén mashaléá záher but o cha taláni nyámá gwast. ");
INSERT INTO bcc_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Á róchá Hodáwandá gón Ebrámá ahd o paymáné kort o gwashti: “Cha mani némagá é sardhagár cha Mesray shépá beger tán Parátay mazanén kawrá tai nasl o padréchayg ent, ");
INSERT INTO bcc_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","bezán Kani o Kanizzi o Kadmuni o ");
INSERT INTO bcc_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Hitti o Perizzi o Repáhi o ");
INSERT INTO bcc_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amuri o Kanháni o Gergáshi o Yabusi mahlukay sarzemin.” ");
INSERT INTO bcc_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ebrámay lógi Sáráiá chokka nabut. Sáráiá Mesri móledé hastat ke námi Hájer at. ");
INSERT INTO bcc_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Sáráiá gón Ebrámá gwasht: “Hodáwandá mani dém dáshtag o chokk áworta nakanán. Taw beraw o gón mani móledá bwaps ke balkén maná cha áiay némagá chokké bebit.” Ebrámá Sáráiay gapp zort. ");
INSERT INTO bcc_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Wahdé Ebrámá dah sál Kanháná gwázéntagat, áiay jan Sáráiá wati Mesri móled Hájer zort o Ebrámárá pa jani dát. ");
INSERT INTO bcc_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Ebrámá gón Hájerá wapt o wáb kort o Hájeray láp porr but. Wahdé Hájerá zánt ke mani láp porr ent, wati bánokay mán nayáragi bendát kort. ");
INSERT INTO bcc_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Gorhá Sáráiá gón Ebrámá gwasht: “É azáb o sheddat ke mani sará kaptag, eshiay zemmawár taw ay. Man wati móled tai bagalá dát o nun wahdé á zánt ke lápi porr ent, maná mána nayárit. Hodáwand mani o tai nyámá dádras bát.” ");
INSERT INTO bcc_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Bale Ebrámá gón Sáráiá gwasht: “Tai móled tai dastá ent, gón áiá hamá paymá bekan ke tai delá sharter ent.” Gorhá Sárái, Hájeray sará trond but o Hájer cha áiá tatk. ");
INSERT INTO bcc_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Hodáwanday préshtagá Hájer gyábáná, chammagéay kerrá dist. É hamá chammag ent ke Shuray ráhay sará ent. ");
INSERT INTO bcc_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Préshtagá gwasht: “Oo Hájer, Sáráiay móled! Taw cha kojá átkagay o kojá rawagá ay?” Hájerá gwasht: “Man cha wati bánok Sáráiá tachagá án.” ");
INSERT INTO bcc_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Gorhá Hodáwanday préshtagá gwasht: “Wati bánokay kerrá wátarr kan o watá hamáiay dastá day.” ");
INSERT INTO bcc_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Préshtagá chosh ham gwasht: “Hodáwanda gwashit ke man tai nasl o padréchá anchó báza kanán ke cha hesábá dhanna bant.” ");
INSERT INTO bcc_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Hodáwanday préshtagá padá gwasht: “Nun taw lápporr ay o mardénchokké káray. Chokkay námá Esmáél bekan chéá ke Hodáwandá tai peryát eshkotag. ");
INSERT INTO bcc_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","É bachakk wakshién haré bit. É sajjahénáni dozhmena bit o sajjahén eshiay dozhmeniá kanant. É wati zendá gón wati sajjahén brátán pa jang o jérhaha gwázénit.” ");
INSERT INTO bcc_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Hodáwandá ke gón Hájerá habar kort, Hájerá Hodáwandárá é nám bast: “Taw hamá Hodá ay ke maná genday.” Chéá ke Hájerá gwasht: “Nun man hamá dist ke maná modáma gendit.” ");
INSERT INTO bcc_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Paméshká é chát, Behér-Lahái-Rui nám kapt. É chát, Kádesh o Béreday nyámá ent. ");
INSERT INTO bcc_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Gorhá Hájerá pa Ebrámá mardénchokké pédá kort o Ebrámá Hájeray áwortagén chokkay nám Esmáél kort. ");
INSERT INTO bcc_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Wahdé Hájer pa Esmáélá chellag but, Ebrámay omr hashtád o shash sál at. ");
INSERT INTO bcc_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ebrámá ke nawad o noh sál but, Hodáwand áiay démá záher but o gwashti: “Man porwákén Hodá án, mani ráhá beraw o pa bémayári zend begwázén. ");
INSERT INTO bcc_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Man wati o tai nyámay ahd o paymáná pakká kanán ke tai chokk o nomásagán sakk báza kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Gorhá Ebrám dém pa chér kapt o Hodáyá gón áiá gwasht: ");
INSERT INTO bcc_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Bechár, é gón taw mane Hodáay ahd o paymán ent ke taw bázén kawméay peta bay. ");
INSERT INTO bcc_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Cha ed o rand tai nám Ebráma nabit, tai nám Ebráhéma bit, chéá ke man tará bázén kawméay pet kortag. ");
INSERT INTO bcc_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Man tará sakk báz porsamara kanán o cha taw kawm o ráj jórha kanán o cha taw bádsháh wadia bant. ");
INSERT INTO bcc_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Man wati o tai nyámay ahd o paymáná abadmánén ahd o paymáné jórha kanán, gón taw o gón tai áyókén nasl o padréchá. Man tai Hodá án o cha taw rand tai poshpaday Hodá bán. ");
INSERT INTO bcc_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Man Kanhánay sajjahén sardhagárá, ke annun taw edá darámadé ay, tai o cha taw rand tai nasl o padréchay abadi melkata kanán o áyáni Hodá bán.” ");
INSERT INTO bcc_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Gorhá Hodáyá gón Ebráhémá gwasht: “Bale tawe Ebráhém báyad ent mani ahd o paymáná barjáh bedáray, tai jend o tai nasl o padréch, posht dar posht. ");
INSERT INTO bcc_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Mani ahd o paymán gón tai jendá o cha taw rand gón tai poshpadá esh ent o báyad ent shomá barjáhi bedárét: Shomay har mardén báyad ent borrok o sonnat kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Shomá watá sonnat bekanáénét. É hamá ahd o paymánay neshánia bit ke mani o shomay nyámá ent. ");
INSERT INTO bcc_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Áyókén nasl o padrécháni tahá, shomay nyámá hamok hasht róchigén mardénchokk báyad ent sonnat kanag bebit, tahná shomay jenday lógay chokk na, hamá zarharidén golámchokk ham ke shomay nasl o padréch naant o shomá cha dhanni mardomán pa bahá zortagant, á ham sonnat kanag bebant. ");
INSERT INTO bcc_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Toré shomay lógá pédá bebant yá ke shomá áyán pa bahá begerét, báyad ent sonnat kanag bebant. É paymá shomay jesm o jáná, mani ahd o paymán abadmána bit. ");
INSERT INTO bcc_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Har sonnat nakortagén mardén ke jesmi sonnat kanag nabutag, cha wati kawmá sendaga bit, chéá ke mani ahd o paymáni próshtag.” ");
INSERT INTO bcc_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Hodáyá gón Ebráhémá gwasht: “Bale wati lógi Sáráiá cha ed o rand Sárái tawár makan, áiay nám Sáraha bit. ");
INSERT INTO bcc_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Man barkatia dayán o tará cha áiá mardénchokké bit. Man Sárahá barkata dayán o á kawmáni máta bit, kawmáni bádsháh cha áiá pédá bant.” ");
INSERT INTO bcc_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Gorhá Ebráhém dém pa chér kapt o kandeti o wati delá gwashti: “Cha sad sáligén mardéá chokké pédá bit? Sárah nawad sálagiá chokké kárit?” ");
INSERT INTO bcc_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Ebráhémá gón Hodáyá gwasht: “Esmáél wati zendá tai bárgáhá begwázénát.” ");
INSERT INTO bcc_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Hodáyá gwasht: “Enna, tai jan Sárah chokké kárit o taw báyad ent chokkay námá Esák bekanay. Man wati ahd o paymáná gón Esáká barjáha dárán o cha áiá rand, é pa áiay nasl o padréchá abadmánén ahd o paymáné bit. ");
INSERT INTO bcc_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Esmáélay bárawá ham man tai habar gósh dásht: Man áiá allam barkata dayán, áiá porsamara kanán o áiay nasl o padréchá sakk báza kanán. Á dwázdah shahzádagay peta bit o cha áiá mazanén kawmé pédá kanán. ");
INSERT INTO bcc_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Bale wati ahd o paymáná gón Esáká barjáha dárán ke démi sálá hamé wahdá cha Sárahá pédá bit.” ");
INSERT INTO bcc_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Wahdé Hodáyá wati habar gón Ebráhémá halás kortant, cha áiay kerrá borzád shot. ");
INSERT INTO bcc_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Hamá róchá Ebráhémá wati chokk Esmáél, wati lógá pédá butagén sajjahén mardén o zarharidén golám, lógay sajjahén mardén zort o sonnat kanáéntant, hamá paymá ke Hodáyá gwashtagat. ");
INSERT INTO bcc_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Ebráhém wahdé sonnat kanag but, omri nawad o noh sál at. ");
INSERT INTO bcc_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Áiay chokk Esmáélá sézdah sál at. ");
INSERT INTO bcc_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Pet o chokk hamá yakkén róchá sonnat kanag butant. ");
INSERT INTO bcc_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ebráhémay lógay sajjahén mardén, hamá ke áiay lógá pédá butagatant o hamá zarharidén golám ke áiá cha dhanni mardomán pa bahá zortagatant, gón áiá hórigá sonnat kanag butant. ");
INSERT INTO bcc_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Hodáwand Mamrehay mazanén drachkáni nazzikká Ebráhémay démá záher but. Némróchay thák at o Ebráhém wati gedánay dapá neshtagat. ");
INSERT INTO bcc_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Ebráhémá chamm chest kortant, disti ke say mard mani nazzikká óshtátag. Áiá ke distant, cha gedánay dapá pa eshtápi áyáni wasshátká shot, pa adab sari jahl kort o ");
INSERT INTO bcc_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","gwashti: “Oo mani wájah! Maná ezzat beday, cha wati hezmatkárá sar magwaz o gón man bejall. ");
INSERT INTO bcc_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bell bachakk pa shomay pádáni shódagá kammé ápa kárant, shomá drachkay chérá árám kanét. ");
INSERT INTO bcc_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Shomá ke wati hezmatkáray kerrá átkagét, bell pa shomá waraga kárán, áp o támé bekanét o randá démá berawét.” Gwashtesh: “Sharr, harché ke taw gwashay.” ");
INSERT INTO bcc_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Ebráhém eshtáp eshtápá Sárahay kerrá gedáná shot o gwashti: “Zutt kan, say kyás sharrén árt bezur, tarresh kan o nagan bepach.” ");
INSERT INTO bcc_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Ebráhémá wat dém pa góromá maydán kort, sharrén pazzórén gwaské dari chet o hezmatkáréá dáti. Hezmatkárá zutt addh kort. ");
INSERT INTO bcc_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Gorhá shir o shillánch o patkagén góshti zort o áyáni démá dátant. Á ke waragá atant, Ebráhém áyáni kerrá, drachkay chérá óshtát. ");
INSERT INTO bcc_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Áyán jost gept: “Tai lógi Sárah kojá ent?” Ebráhémá passaw dát: “Ódá gedánay tahá ent.” ");
INSERT INTO bcc_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Gorhá cha áyán yakkéá gwasht: “Áyókén sálá hamé wahdá allamá tai kerrá pera tarrán o tai lógi Sárahá mardénchokké gwarána bit.” Sárah áiay poshti némagá, gedánay dapá, gósh dáragá at. ");
INSERT INTO bcc_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Nun Ebráhém o Sárah pir o ájez atant o Sárahá janéni máhánaga nabut. ");
INSERT INTO bcc_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Gorhá Sárahá delá kandet o gwasht: “Man pir án o mani wájah ájez ent, nun maná che wasshi o lezzaté rasit?” ");
INSERT INTO bcc_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Gorhá Hodáwandá gón Ebráhémá gwasht: “Sárahá chéá kandet o gwasht: ‘É piránsariá, pa rásti maná chokké bit?’ ");
INSERT INTO bcc_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Choshén káré hast ke pa Hodáwandá grán bebit? Gisshetagén wahdá, démi sálá tai kerrá pera tarrán o Sárahá mardénchokké bit.” ");
INSERT INTO bcc_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Sárahá torset, drógi bast o gwashti: “Man nakandet.” Bale Hodáwandá gwasht: “Pa rásti taw kandet.” ");
INSERT INTO bcc_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","É sayén mard cha ódá pád átk o ráh geptant. Dém pa Sodumá cháretesh. Ebráhém ham shot gón ke áyán rahádag bekant. ");
INSERT INTO bcc_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Gorhá Hodáwandá gwasht: “Á kár ke maná kanagi ent, cha Ebráhémá chéri bedayán? ");
INSERT INTO bcc_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ebráhém allamá mazan o zórmandén kawmé jórha bit o áiay sawabá zeminay sajjahén kawm barkata gerant. ");
INSERT INTO bcc_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Chéá ke man, Ebráhém dar chetag ke wati chokk o lógay mardomán hokm bedant ke cha áiá rand, pa pahrézkári o ensáp mane Hodáwanday ráhá rawán bebant tánke pa Ebráhémá hamá kárá bekanán ke gón áiá kawlon kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Gorhá Hodáwandá gwasht: “Sodum o Gomurahay helápá peryáté chest ent. Áyáni gonáh haminchok báz ant ");
INSERT INTO bcc_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ke man jahláda rawán o charán bárén áyáni kortagén kár hamá peryátay kaddá báz ant ke pa man sar butag? Agan chosh naent, wa man sahiga bán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Gorhá á mardán wati ráh táb dát o dém pa Sodumá shotant, bale Ebráhém angat Hodáwanday bárgáhá óshtók at. ");
INSERT INTO bcc_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Gorhá Ebráhém nazzikk átk o gwashti: “Taw pa rásti pahrézkárá ham gón badkárá rópay o baray? ");
INSERT INTO bcc_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Agan shahrá panjáh pahrézkárén mardom bebit, gorhá? Angat á shahrá rópay o baray? Hamá panjáhén pahrézkáráni háterá á shahrá nabakshay? ");
INSERT INTO bcc_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Cha tai dastá choshén káré mabát ke pahrézkárá gón badkárá hór bekoshay o pahrézkár o badkárá yakkén chammá becháray. Sajjahén jahánay dádras pa hakk o ensáp kára nakant?” ");
INSERT INTO bcc_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Hodáwandá gwasht: “Agan Sodumay shahrá panjáh pahrézkár begendán, áyáni háterá á sajjahén jágahá bakshán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Ebráhémá passaw dát o gwasht: “Man ke hák o poré án, man nun haminkas delér butagán ke gón Hodáwandá habara kanán, ");
INSERT INTO bcc_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","bale agan cha panjáhén pahrézkárán panch kamm bebit, pa é panchén mardománi kamm bayagá sajjahén shahrá tabáha kanay?” Hodáwandá passaw dát: “Agan man chell o panch ham begendán, shahrá tabáha nakanán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Ebráhémá padá gón áiá gwasht: “Agan chell bebant?” Hodáwandá gwasht: “Hamé chellénáni háterá ham tabáhia nakanán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Gorhá gwashti: “Oo Hodáwand! Zahr magerátay, bale bell ke man habara kanán, agan tahná si bebant?” Hodáwandá passaw dát: “Agan si begendán ham shahrá tabáha nakanán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ebráhémá gwasht: “Nun ke man del kortag o gón tawe Hodáwandá habar kanagá án, agan ódá tahná bist bebit?” Gwashti: “É bisténáni háterá ham shahrá tabáha nakanán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ebráhémá gwasht: “Oo Hodáwand! Zahr magerátay, man angat gappé kanaga lóthán. Agan ódá tahná dah bebit, gorhá?” Passawi tarrént: “Á dahén mardománi háterá ham á shahrá tabáha nakanán.” ");
INSERT INTO bcc_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Wahdé Hodáwandá gón Ebráhémá habar halás kort, cha ódá shot o Ebráhém ham wati lógá per tarret. ");
INSERT INTO bcc_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Bégáhá, doén préshtag Sodumá sar butant. Lut shahray darwázagay dapá neshtagat. Wahdé préshtagi distant, pád átk o áyáni péshwáziá shot, pa adab sari jahl kort o ");
INSERT INTO bcc_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","gwashti: “Oo mani wájahán! Wati kasteray lógá byáét o wati pádán beshódét. Shapá hamedá bejallét o bámgwáhá sar begerét.” Áyán gwasht: “Enna, má wati shapá shahray chárráhá gwázénén.” ");
INSERT INTO bcc_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bale Lutá haminchok mennat kortant ke áyán ráh táb dát o Lutay lógá shotant gón. Lutá pa áyán shámé tayár kort, béhomirén nagani addh kort o áyán wárt. ");
INSERT INTO bcc_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Á angat nawaptagatant ke cha Sodumay har kondhá sajjahén mardén, pir o warná átkant o lógesh angerr kort. ");
INSERT INTO bcc_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Áyán Lut gwánk jat o gwasht: “Hamé bachakk ke enshapi tai lógá átkagant, kojá ant? May kerrá byáresh ke má gón áyán wapt o wába kanén.” ");
INSERT INTO bcc_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lut dhanná dar átk o poshtá darwázagi band kort. ");
INSERT INTO bcc_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Gwashti: “Na, mani brátán! Man dasta bandán, é badén kárá makanét. ");
INSERT INTO bcc_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Bechárét, maná do janénchokk hast ke angat gón hecch mardéná wapt o wábesh nakortag. Man áyán shomay kerrá kárán, gón áyán harché shomay dela lóthit, bekanét. Bale é mardomán kár madárét ke mani lógá átkagant o mani mayár ant.” ");
INSERT INTO bcc_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Áyán gwasht: “Yakk kerr bay” o watmánwatá gwashtesh: “É mard darámadé at o may shahrá átkag. Nun may masteriá kanaga lóthit.” Padá gón Lutá gwashtesh: “Nun má tai jendá cha é bachakkán gantera kanén.” Lutesh télánk dayán kort o démá shotant ke darwázagá bepróshant. ");
INSERT INTO bcc_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Bale préshtagán dast dhanná shahárt, Lutesh lógay tahá kasshet o darwázagesh bast. ");
INSERT INTO bcc_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Préshtagán, darwázagay dapay mardománi, warná o pirénáni chamm tahár kortant ke darwázagá dar gétk makanant. ");
INSERT INTO bcc_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nun á doénán gón Lutá gwasht: “Tará edá dega kasé hast, zámát, bacch, jenekk, yá dega syád o wáresé ke é shahrá ent? Agan hast, gorhá cha edá daresh kan ");
INSERT INTO bcc_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ke má é jágahá tabáha kanén. É shahray helápá anchén mazanén peryáté Hodáwandá sar butag ke márá pa é shahray tabáh kanagá rawáni dátag.” ");
INSERT INTO bcc_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Gorhá Lut shot o wati zámáti gwashtant, hamá ke gón áiay jenekkán sáng kanagi atant: “Eshtáp kanét o cha edá dar kapét ke Hodáwand é shahrá tabáha kant.” Bale áiay zámátán delá gwasht ke Lut maskará kanagá ent. ");
INSERT INTO bcc_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Bámgwáh ke but, préshtagán Lut hojj kort o gwasht: “Zutt kan wati jan o doén jenekkán cha edá bezur o beraw, agan na é shahr ke sezá dayaga bit, shomá ham rópag o baraga bét.” ");
INSERT INTO bcc_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bale Lutá ke dér kort, á mardán, Lut o Lutay jan o doén jenekk dastá geptant o cha shahrá dhann bortant, chéá ke Hodáwandá áyáni sará rahm kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Wahdé áesh cha shahrá dhann bortant, cha préshtagán yakkéá gwasht: “Betach o poshtá chakk majan. Dashtá hecch jágah maósht. Dém pa kóhán betach, agan na rópag o baraga bay.” ");
INSERT INTO bcc_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Bale Lutá gwasht: “Enna wájahán! Rahm kanét. ");
INSERT INTO bcc_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Shomá mani sará, wati kasteray sará rahm kortag o gón mani zenday rakkénagá pésh dáshtag ke chinkadar mehrabán ét. Bale man dém pa kóhán tatka nakanán. Chó mabit ke é tabáhi maná mán berópit o man bemerán. ");
INSERT INTO bcc_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Bechár, mani nazzikká shahré hast ke dém pa áiá tatka kanán. Kasánén shahré, bell ke dém pa áiá betachán. É wa kasánén shahré, na? Gorhá mani jána rakkit.” ");
INSERT INTO bcc_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Préshtagá gwasht: “Sharr ent, tai é wáhagá puraha kanán o é shahray námá ke taw geragá ay, eshiá tabáha nakanán. ");
INSERT INTO bcc_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Bale zutt betach o beraw. Tánke taw ódá sara nabay, man hecch korta nakanán.” Paméshká é shahray námesh Sóhar kort. ");
INSERT INTO bcc_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Lut ke Sóhará raset, róchá nóki thekk kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Gorhá Hodáwandá Sodum o Gomurahay sará ás o gókort gwárént. É ás o gókort cha Hodáwanday némagá, cha ásmáná retkant. ");
INSERT INTO bcc_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","É paymá, Hodáwandá á shahr o sajjahén dasht o shahráni sajjahén jahmenend o sabzag tabáh kortant. ");
INSERT INTO bcc_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Bale Lutay janá poshtá chakk jat o wáday boté but. ");
INSERT INTO bcc_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ebráhém sohbá máhallah pád átk o hamá jágahá shot ke pésarigén randá Hodáwanday bárgáhá óshtátagat. ");
INSERT INTO bcc_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Sodum o Gomurahay némagá, jahlá, sajjahén dashtay némagá cháreti o disti ke cha zeminá bazén dutté chest ent, chó kurahay duttá. ");
INSERT INTO bcc_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Hodáyá ke dashtay shahr sar o chér kortant, Ebráhémay tránagá kapt. Hamá shahrán ke Lut jahmenend butagat, áyáni tabáh kanagay wahdá Hodáyá Lut cha ódá dar kort. ");
INSERT INTO bcc_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Lut gón wati doén jenekkán cha Sóhará laddhet o kóhestagá jahmenend but, chéá ke Sóhará nendagi torset. Lut gón doén jenekkán gáréay tahá nesht. ");
INSERT INTO bcc_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yakk róché masterén jenekká gón kasteréná gwasht: “May pet pir ent o edá dega hecch mardéné nést ke gón má wapt o wábé bekant, anchó ke sajjahén donyáay dód ent. ");
INSERT INTO bcc_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Byá petá sharába wárénén o gón áiá wapt o wába kanén ke cha hamáiá wati nasl o padréchá démá bebarén.” ");
INSERT INTO bcc_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Á shapá wati petesh sharáb wárént o masterén jenekk shot o gón petá wapt o wábi kort. Lut na áiay wapsagá sahig but, na pád áyagá. ");
INSERT INTO bcc_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Domi róchá masterén jenekká gón kasteréná gwasht: “Dóshi man shot o gón petá waptán, byá enshapi padá sharábia dayén o taw beraw o gón áiá bwaps. Cha hamáiá wati nasl o padréchá démá barén.” ");
INSERT INTO bcc_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Gorhá pésarigén shapay paymá wati petesh sharáb wárént, kasterén jenekk pád átk o gón petá wapt o wábi kort. Lut na áiay wapsagá sahig but, na pád áyagá. ");
INSERT INTO bcc_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Lutay doén jenekk cha wati petá lápporr butant. ");
INSERT INTO bcc_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Masterén jenekká mardénchokké but o námi Muáb kort. Muáb, maróchigén Muábiáni pet ent. ");
INSERT INTO bcc_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Kasterén jenekká ham mardénchokké but o námi Ben-Ammi kort. Ben-Ammi maróchigén Ammuniáni pet ent. ");
INSERT INTO bcc_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Ebráhém cha ódá laddhet o Negébay damagá shot o Kádesh o Shuray nyámá jahmenend but. Tán chizzé wahdá Gerárá darámadéay paymá zendi gwázént. ");
INSERT INTO bcc_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Ebráhémá wati jan Sárahay bárawá gwasht: “Mani gohár ent.” Gorhá Geráray bádsháh, Abimaleká wati mardom rawán dátant o Sárahi wati kerrá bort. ");
INSERT INTO bcc_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Bale shapá Hodá Abimalekay wábá átk o gwashti: “Bechár, é janén ke taw bortag, taw eshiay sawabá meray. É sur kortagéné.” ");
INSERT INTO bcc_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abimalek angat Sárahay nazzikká nashotagat, gwashti: “Oo mani Hodáwand! Bégonáhén kawmé tabáha kanay? ");
INSERT INTO bcc_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ebráhémá wat gón man nagwasht: ‘É mani gohár ent’? O Sárahá wat nagwasht: ‘É mani brát ent’? Man é kár gón sápén del o pákén dasté kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Hodáyá gwasht: “Haw! Mana zánán ke taw é kár gón sápén delé kortag o man ham tará naesht ke mani gonahkár bebay, paméshká man tará é janénay dast janagá naesht. ");
INSERT INTO bcc_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Nun é marday janá beday. É mard nabié. Pa taw dwá kant o taw zendaga mánay. Bale agan é marday janá madayay, deljam bay ke tai jend o tai sajjahén mardom allamá merant.” ");
INSERT INTO bcc_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abimalek sohbá máhallah pád átk, wati sajjahén hezmatkári lótháéntant o harché ke butagat, sajjahén háli dátant. Áyán sakk torset. ");
INSERT INTO bcc_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Gorhá Abimaleká Ebráhém lótháént o gwasht: “Taw chéá gón má chosh kort? Man tai kojám kár haráb kortagat ke taw mani jend o mani molk choshén mazanén gonáhé sará dátant? Taw gón man anchén káré kort ke kass gón kassá nakant.” ");
INSERT INTO bcc_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abimaleká cha Ebráhémá jost kort: “Tai delá ché hastat ke choshet kort?” ");
INSERT INTO bcc_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Ebráhémá passaw dát: “Man wati delá gwasht edá hecch Hodátorsi nést o mani lógiay sawabá mardom maná koshant. ");
INSERT INTO bcc_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Sárah chónáhá wa mani gohár ent ke mani petay chokk ent, bell toré mani mátay chokk naent, bale randá má sur kort o á mani lógi but. ");
INSERT INTO bcc_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Wahdé Hodáyá maná cha mani petay lógá darpadar kort, man gón Sárahá gwasht: ‘Agan maná dósta dáray, har jágah ke rawén, begwash: “É mani brát ent.”’” ");
INSERT INTO bcc_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Gorhá Abimaleká pas o gók o golám o móled áwort o Ebráhémárá dát o áiay lógi Sárahi per tarrént. ");
INSERT INTO bcc_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimaleká gwasht: “Mani molk tai démá ent, har jáh ke tará dósta bit hamódá benend.” ");
INSERT INTO bcc_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Gón Sárahá gwashti: “Man tai brátá hazár nograha dayán. Tai sajjahén mardománi démá é malámá porra kanán ke taw hecch radié nakortag.” ");
INSERT INTO bcc_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Gorhá Ebráhémá Hodáay kerrá dwá kort o Hodáyá Abimalek, áiay lógi o áiay móled dráh kortant ke padá chokk áwort bekanant, ");
INSERT INTO bcc_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","chéá ke Hodáwandá Ebráhémay jan Sárahay sawabá Abimalekay lógay sajjahén janén chokband kortagatant. ");
INSERT INTO bcc_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Hamá paymá ke Hodáwandá wat gwashtagat, Sárahay sará mehrabán but o pa Sárahá hamá kári kort ke wádahi kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sárahay láp porr but o Ebráhémay piránsariá pa áiá mardénchokké áworti. Chokk hamá gisshetagén wahdá pédá but ke Hodáyá cha pésará Ebráhém hál dátagat. ");
INSERT INTO bcc_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Ebráhémá wati é chokkay nám, ke cha Sárahá pédá butagat, Esák kort. ");
INSERT INTO bcc_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Esákay omr ke hasht róch but, Ebráhémá sonnat kanáént, hamá paymá ke Hodáyá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","É wahdá ke Esák pédá but, Ebráhémay omr sad sál at. ");
INSERT INTO bcc_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sárahá gwasht: “Hodáyá maná ‘kandag’ dátag o harkas ke sahiga bit, gón mana kandit.” ");
INSERT INTO bcc_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Padá gwashti: “Kayá gón Ebráhémá gwashta kort ke Sárah chokk shira méchénit? Bale man pa áiá mardénchokké áwort, áiay piriay róchán.” ");
INSERT INTO bcc_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Chokk rodán but o cha shirá sestesh. É róchá ke Esákesh cha shirá sest, Ebráhémá mazanén dáwaté kort. ");
INSERT INTO bcc_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Bale Sárahá dist ke Ebráhémay hamá chokk ke cha Mesri Hájerá pédá butagat, maná kalág geragá ent. ");
INSERT INTO bcc_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Gorhá Sárahá gón Ebráhémá gwasht: “É móledá gón chokká gallén. É móleday chokk gón mani chokk Esáká hechbar hammirás buta nakant.” ");
INSERT INTO bcc_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","É gappá Ebráhém sakk paréshán kort, chéá ke Esmáél ham áiay chokk at. ");
INSERT INTO bcc_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Bale Hodáyá gón Ebráhémá gwasht: “Pa bachakká o wati móledén zálá paréshán mabay. Harché Sárah tará gwashit, hamá warh bekan, chéá ke tai nasl o padréch cha Esáká zánaga bit. ");
INSERT INTO bcc_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Man móledén zálay chokká ham kawmé kanán chéá ke á ham tai nasl o padréch ent.” ");
INSERT INTO bcc_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Domi sohbá máhallah Ebráhémá tóshag o mashké áp zort o Hájerárá dát. Mashk o tóshagi Hájeray kópagá dátant o gón chokká dari kort. Hájer shot o Bérshébahay gyábáná sargardán but. ");
INSERT INTO bcc_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Mashkay áp ke halás butant, chokki dhólokéay boná ér kort, ");
INSERT INTO bcc_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","wat dur shot o kesás tirkasshéay ráhá dém pa démá nesht. Delá gwashti: “Chokkay marká magendátán.” Chokkay dém pa démá ke neshtagat, kukkár kort o gréti. ");
INSERT INTO bcc_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Hodáyá chokkay tawár eshkot o Hodáay préshtagá cha ásmáná Hájer gwánk jat o gwasht: “Hájer! Tará ché butag? Mators. Chokk hamá jágahá ke ér ent, Hodáyá áiay tawár cha hamódá eshkotag. ");
INSERT INTO bcc_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Pád á, chokká chest kan, dastái ger ke man áiá mazanén kawmé kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Hodáyá Hájeray chamm pach kortant o Hájerá ápay cháté dist. Shot o mashki porr kort o chokki áp dát. ");
INSERT INTO bcc_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Chokk rodán but o Hodá gón áiá gón at. Chokká gyábáná zenda gwázént o tirkamánay janagá sakk balad but. ");
INSERT INTO bcc_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Esmáél, Páránay dashtá jahmenend but o mátá gón Mesri jenekkéá sur dát. ");
INSERT INTO bcc_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Hamé wahdá Abimalek o áiay lashkaray master Pikulá gón Ebráhémá gwasht: “Taw harché ke kanay, Hodá gón taw gón ent. ");
INSERT INTO bcc_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Nun edá gón man Hodáay sawgendá bwar ke maná yá mani chokkán yá mani óbádagán rada nadayay. Hamá paymá ke man gón taw mehrabán butagán, taw gón man o gón mani molká hamé paymá mehrabán bay, gón hamé molká ke taw darámadéay hesábá neshtagay.” ");
INSERT INTO bcc_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Ebráhémá gwasht: “Maná sawgend ent.” ");
INSERT INTO bcc_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ebráhémá Abimalekay kerrá áiay hezmatkáráni shekáyat kort ke mani cháté poshtá kasshetagesh. ");
INSERT INTO bcc_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimaleká gwasht: “Mana nazánán é kár kayá kortag. Taw maná hál nadátag o tán maróchi man eshiay bárawá hecch naeshkotag.” ");
INSERT INTO bcc_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Gorhá Ebráhémá pas o gók zort o Abimalekárá dátant o doén mardán ahd o paymáné bast. ");
INSERT INTO bcc_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Ebráhémá hapt kasánén mésh cha ramagá jetá kort. ");
INSERT INTO bcc_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abimaleká cha Ebráhémá jost kort: “Taw hapt kasánén mésh jetá kort, eshiay máná ché ent?” ");
INSERT INTO bcc_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ebráhémá passaw dát: “É haptén méshán cha mani némagá bezur. É sháhedié bit ke é chát manig ent o man jatag.” ");
INSERT INTO bcc_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Gorhá á jágahay nám Bérshébah kanag but, chéá ke doén mardán ódá sawgendé wárt. ");
INSERT INTO bcc_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","É paymá mán Bérshébahá ahd o paymáné bastesh. Randá Abimalek o áiay lashkaray master Pikulá Pilestiáni sardhagárá wátarr kort. ");
INSERT INTO bcc_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Ebráhémá Bérshébahá gazzay drachké kesht o ódá Hodáwand, abadmánén Hodáay námi tawár kort. ");
INSERT INTO bcc_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Tán mazanén wahdéá Ebráhémá Pilestiáni sardhagárá darámadéay hesábá zenda gwázént. ");
INSERT INTO bcc_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","É chizzán o rand, Hodáyá Ebráhém chakkáset. Gón Ebráhémá gwashti: “Ebráhém!” Ebráhémá passaw dát: “Ji!” ");
INSERT INTO bcc_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Hodáyá gwasht: “Wati bacch, wati yakkén chokk, Esák ke tará dóst ent, bezuri o Muriáay damagá beraw. Hamá kóhá ke man tará pésha dárán, hamódá bar o sóchagi korbánigay hesábá nadri kan.” ");
INSERT INTO bcc_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Domi sohbá máhallah, Ebráhém pád átk o wati hari pálám kort. Wati do hezmatkár o Esáki zortant, pa sóchagi korbánigá dári prósht o dém pa hamá jágahá ráh gept ke Hodáyá gwashtagat. ");
INSERT INTO bcc_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Nun saparay sayomi róch at. Ebráhémá chamm chest kortant o cha durá á jágahi dist. ");
INSERT INTO bcc_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Gón wati hezmatkárán gwashti: “Shomá gón hará hamedá bejallét, man o chokk ódá rawén o Hodáyá parastesha kanén o káén.” ");
INSERT INTO bcc_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Ebráhémá sóchagi korbánigay dár zortant o wati chokk Esákay baddhá dátant, ás o kárchi wat zortant o doén ráh geptant. ");
INSERT INTO bcc_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Esáká gón wati pet Ebráhémá gwasht: “Mani pet!” Ebráhémá passaw dát: “Ji mani chokk!” Esáká gwasht: “Ás o dár wa esh ant, bale sóchagi korbánigay gwarándh kojá ent?” ");
INSERT INTO bcc_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Ebráhémá passaw dát: “Mani chokk! Sóchagi korbánigay gwarándhay kárá Hodá wat chár o gozára kant” o á doén rawán butant. ");
INSERT INTO bcc_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Wahdé hamá jágahá sar butant ke Hodáyá gwashtagat, Ebráhémá korbánjáhé addh kort, dári sar pa sar kortant o wati chokk Esáki bast o korbánjáhá, dáráni sará ér kort. ");
INSERT INTO bcc_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ebráhémá dast shahárt o kárchi zort ke wati chokká helára kanán, ");
INSERT INTO bcc_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","bale Hodáwanday préshtagá cha ásmáná Ebráhém tawár kort: “Ebráhém! Oo Ebráhém!” Ebráhémá passaw dát: “Ji!” ");
INSERT INTO bcc_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Préshtagá gwasht: “Wati dastá bedár o chokká hecch makan. Nun mana zánán ke taw Hodátorsé ay, chéá ke taw chakk o pad nabutay o wati bacch, wati yakkén chokk ham maná dát.” ");
INSERT INTO bcc_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Ebráhémá chamm chest kortant o poshtá cháret, disti ta gwarándhé ke kánthi dhangarán mán gisshetagant. Ebráhém shot, gwarándhi zort o wati chokkay jágahá sóchagi korbánig kort. ");
INSERT INTO bcc_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ebráhémá á jágahay nám kort “Hodáwand chár o gozára kant” o tán maróchigá gwashaga bit ke: “Hodáwanday kóhay sará, chár o gozár kanaga bit.” ");
INSERT INTO bcc_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Hodáwanday préshtagá padá Ebráhém cha ásmáná gwánk jat. ");
INSERT INTO bcc_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","Gwashti: “Hodáwanda gwashit: ‘Maná wati saray sawgend ent, taw ke wati bacchay, wati yakkén chokkay dayagá chakk o pad nabutay, ");
INSERT INTO bcc_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","man ham pa rásti tará barkata dayán o tai nasl o padréchá anchó báza kanán ke ásmánay estár o tayábay rék ant. Tai poshpad wati dozhmenáni shahrána gerant o wati melkata kanant o ");
INSERT INTO bcc_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","zeminay sajjahén kawm tai poshpaday sawabá barkata gerant, chéá ke taw mani habar zortag.’” ");
INSERT INTO bcc_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Gorhá Ebráhém wati hezmatkáráni kerrá per tarret o á, hórigá dém pa Bérshébahá ráh geptant. Ebráhém Bérshébahá jahmenend but. ");
INSERT INTO bcc_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Chizzé wahdá rand Ebráhémesh sahig kort ke Melkahá ham chokk áwortag, pa tai brát Náhórá chokki pédá kortag. ");
INSERT INTO bcc_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Áiay awali chokk Uz ent, Uzay brát Buz o Kemuil ant, Kemuil, Arámay pet ent. ");
INSERT INTO bcc_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","É dega chokki Kesed o Hazó o Pildásh o Yadláp o Betwél ant. ");
INSERT INTO bcc_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Cha Betwélá Rebekká pédá but. Ebráhémay brát Náhóray é hashtén chokk cha Melkahá pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Náhóray soriat ke námi Rahumah at, cha áiá Tebah o Gaham o Tahásh o Mákah pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sárahá yakk sad o bist o hapt sál omr kort. Áiay zenday sál o róch haminkas atant. ");
INSERT INTO bcc_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Sárah, Kanhánay sardhagárá, Keryah-Arbahá bérán but. Keryah-Arbahay domi nám Hebrun ent. Ebráhém shot ke porsá benendit o pa Sárahá begrét. ");
INSERT INTO bcc_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Padá cha láshay kerrá pád átk o gón Hittián gwashti: ");
INSERT INTO bcc_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Man shomay nyámá darkawm o darámadé án. Maná pa kabrestánéá, zemini thokkoré bahá bedayét ke wati mordagá kabr kort bekanán.” ");
INSERT INTO bcc_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hittián passaw dát: ");
INSERT INTO bcc_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Oo mani wájah! May habarán gósh dár. Taw may nyámá porwákén shahzádagé ay. Wati mordagá may kabrestáná, gechéni jágahéá kabr kan. Cha má kass, tará cha tai mordagay kabr kanagá nadárit.” ");
INSERT INTO bcc_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Ebráhém pád átk o á sardhagáray mardom, bezán Hittiáni démá pa adab sari jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Gón áyán gwashti: “Agan shomá rázig ét ke man wati mordagá kabr bekanán, gorhá mani habará gósh dárét o Sóharay chokk Eprunay kerrá mani sepáreshá bekanét, ");
INSERT INTO bcc_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","ke wati gárá mani kerrá bahá bekant, hamá gár ke Makpélahá áiay dhagáray goddhi bahrá ent. Jágahay purahén kimmatá cha man begipt ke maná shomay molká kabrestáné bebit.” ");
INSERT INTO bcc_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Eprun Hitti hamódá mardománi nyámá neshtagat. Ebráhémay passawi anchosh dát ke áiay shahray darwázagay dapá átkagén sajjahén Hitti beshkonant: ");
INSERT INTO bcc_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Enna, wájah! Kimmatay habará makan. Mani gappá gósh dár. Man á gár o dhagár doén tará dátagant. Mani é sajjahén mardománi démá, á dhagár taig ent. Wati mordagá ódá kabr kan.” ");
INSERT INTO bcc_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Ebráhémá padá á molkay mardománi démá sar jahl kort o ");
INSERT INTO bcc_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","gón Epruná anchó gwashti ke mardom beshkonant: “Agan mani habarán gósha dáray, man dhagáray kimmatá dayán. Eshiay zarrán cha man bezur ke man wati mordagá ódá kabr kort bekanán.” ");
INSERT INTO bcc_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Epruná passaw dát: ");
INSERT INTO bcc_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Mani wájah! Mani habará gósh dár. Dhagáray kimmat nograhay chár sad shekel ent. É manig o tai nyámá hecché naent. Wati mordagá kabr kan.” ");
INSERT INTO bcc_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ebráhémá Eprunay habar zort o hamá kimmati tór kort ke Epruná gwashtagat o Hittián eshkotagat, bezán nograhay chár sad shekel, sawdagaráni gisshetagén sang o tóray hesábá. ");
INSERT INTO bcc_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Gorhá Eprunay dhagár ke Makpélahá, Mamrehay nazzikká at, sajjahén Hittiáni démá ke shahray darwázagá átkagatant, á dhagár o dhagáray tahay gár o sajjahén drachk, Ebráhémay melkat butant. ");
INSERT INTO bcc_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nun Ebráhémá wati lógi Sárah, Makpélahay dhagáray gárá, Kanhánay sarzeminá kabr kort. É gár Mamrehay nazzikká ent o Mamreh Hebruná ent. ");
INSERT INTO bcc_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Hittián é dhagár gón gárá Ebráhémárá dát ke kabrestáné bekanti. ");
INSERT INTO bcc_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Nun Ebráhém pir o kamásh at. Hodáwandá Ebráhém har chizzá barkat dátagat. ");
INSERT INTO bcc_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ebráhémay lógá kwahnén hezmatkáré hastat ke áiay sajjahén kár o báráni sarók at. Ebráhémá gón áiá gwasht: “Wati dastá mani zánay chérá ér kan. ");
INSERT INTO bcc_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Man tará Hodáwanday sawgendá dayán, ásmán o zeminay Hodáay sawgendá dayán, ke cha é Kanhánián, ke man esháni nyámá zend gwázenagá án, cha esháni jenekkán mani chokká jana nadayay. ");
INSERT INTO bcc_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Mani molká raway o mani chokk Esáká hamódá cha mani jenday syádán jané dayay.” ");
INSERT INTO bcc_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Hezmatkárá cha áiá jost kort: “Bale agan jenekk pa é molkay áyagá rázig mabit, gorhá tai chokká hamá molká per betarrénán ke taw cha ódá átkagay?” ");
INSERT INTO bcc_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Ebráhémá gwasht: “Hechbar mani chokká ódá per matarrén. ");
INSERT INTO bcc_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Hodáwand, ásmánay Hodá, hamá ke maná cha mani petay lóg o mani pédáeshay molká edá áworti, hamá Hodá ke gón man habari kort, kasam o sawgendi wárt o kawli kort ke ‘cha mani némagá é sardhagár tai nasl o padréchayg ent’, hamá Hodá wati préshtagá cha taw pésar ráha dant ke taw cha ódá pa mani chokká jané dar gétk bekanay. ");
INSERT INTO bcc_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Agan á jenekk gón taw áyagá rázig nabut, gorhá taw cha mani é sawgendá ázát ay. Bale mani chokká ódá per matarrén.” ");
INSERT INTO bcc_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Gorhá hezmatkárá dast wati wájah Ebráhémay zánay chérá ér kort o hamé sawgend wárt. ");
INSERT INTO bcc_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Hezmatkárá cha wati wájahay oshterán dah oshter zort o rahádag but. Cha wájahay némagá tahr tahrén gechéni théki áiá gón at. Pád átk o dém pa Arám-Nahraymá rawán but. Náhóray shahr hamódá at. ");
INSERT INTO bcc_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Cha shahrá dhann, chátéay kerrá oshteri jókéntant. Bégáhay wahd at o é wahdá janén pa ápay kasshagá átkant. ");
INSERT INTO bcc_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Áiá dwá kort o gwasht: “Oo Hodáwand! Mani wájahén Ebráhémay Hodá! Maróchi maná sóbén kan o mani wájahén Ebráhémay sará mehrabán bay. ");
INSERT INTO bcc_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Bechár, man é chammagay kerrá óshtátagán o shahray mardománi jenekk pa ápay kasshagá pédák ant. ");
INSERT INTO bcc_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Hamá jenekk ke agan man gwasht: ‘Wati kunzagá jahl kan, man ápa warán’ o áiá gwasht: ‘Byá bwar, man tai oshterán ham ápa dayán’ mana zánán ke hamé jenekk taw pa wati hezmatkárén Esáká gechén kortag. Man cha hamé gappá zánán ke taw pa mani wájahá mehrabán butagay.” ");
INSERT INTO bcc_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Áiá angat dwá halás nakortagat ke Rebekkáyá wati kunzag kópagá at o átk. Rebekká Betwélay jenekk at. Betwél Melkahay mardénchokk at o Melkah, Ebráhémay brát Náhóray jan at. ");
INSERT INTO bcc_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Jenekk sakkén sharrangé at. Janénchokké at o angat gón hecch mardéná nawaptagat. Rebekká dém pa chammagá jahlád ráh gept, kunzagi porr kort o padá borzád but. ");
INSERT INTO bcc_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Hezmatkár tacháná áiay kerrá shot o gwashti: “Maná cha wati kunzagá kammé áp beday.” ");
INSERT INTO bcc_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebekkáyá gwasht: “Bwar, mani wájah!” Zutt zuttá kunzagi gón doén dastán jahl kort o ápi dát. ");
INSERT INTO bcc_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Rebekkáyá hezmatkár áp dát, randá gwashti: “Man tai oshterán ham ápa dayán, tán hamá wahdá ke wat bass bekanant.” ");
INSERT INTO bcc_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Eshtáp eshtápiá kunzagi tagáray tahá hálig kort o dém pa chátá tachán but ke dega áp byárit. Pa áiay sajjahén oshterán ápi kasshet. ");
INSERT INTO bcc_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Mard bétawár at o Rebekkáyá cháragá at tán bezánt bárén Hodáwandá mani sapar sóbén kortag yá na. ");
INSERT INTO bcc_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Oshterán ke ápay warag bass kort, mardá sohray polóhé dar kort ke kesás shash gerám at o pa áiay dastán sohray do hattali ke har yakkéay wazan kesás sad o bist gerám at. ");
INSERT INTO bcc_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Josti kort: “Taw kai jenekk ay? Maná begwash, tai petay lógá jágah hast ke má wati shapá ódá begwázénén?” ");
INSERT INTO bcc_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebekkáyá gwasht: “Man Betwélay jenekk án. Betwél, Melkah o Náhóray chokk ent.” ");
INSERT INTO bcc_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Padá gwashti: “Márá káh o kadim ham báz hast o choshén jágah ham hast ke shomá shapá bedárét.” ");
INSERT INTO bcc_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mardá wati sar jahl kort, Hodáwanday shogri gept o ");
INSERT INTO bcc_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","gwashti: “Hodáwandá satá bát, mani wájah Ebráhémay Hodáyá ke gón mani wájahá wati mehr o wapádárii barjáh dáshtag o dém pa mani wájahay syádáni lógay é sapará mani rahshón butag.” ");
INSERT INTO bcc_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Jenekk tachán but o mátay lógay mardomi hál dátant. ");
INSERT INTO bcc_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Rebekkáyá bráté hastat ke námi Lábán at. Lábán tachán but o chammagay kerrá, hezmatkáray némagá shot. ");
INSERT INTO bcc_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lábáná ke wati goháray pónzay polóh o dastay hattali distant o anchó ke goháray gappi eshkot ke á mardá gón áiá ché gwashtagat, dar átk o marday némagá shot. Disti ke mard chammagay sará oshteráni kerrá óshtátag. ");
INSERT INTO bcc_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Gwashti: “Oo Hodáwanday barkat dátagén! Byá, dhanná chéá óshtátagay? Man lóg tayár kortag o pa oshterán ham jágahon gisshéntag.” ");
INSERT INTO bcc_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Gorhá mard lógá shot. Oshteráni báresh ér gétkant o oshteresh káh o kadim kortant. Pa marday jend o hamráhán ápesh áwort ke wati pádán beshódant. ");
INSERT INTO bcc_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Nun waragesh áwort o démá dátant. Bale hezmatkárá gwasht: “Man tánke wati gappána najanán, heccha nawarán.” Lábáná gwasht: “Wati gappán bejan.” ");
INSERT INTO bcc_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Gwashti: “Man Ebráhémay hezmatkáré án. ");
INSERT INTO bcc_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Hodáwandá mani wájah sakk báz barkat dátag o wájah hastómand o amiré. Hodáwandá pas o gók, har o oshter, nograh o teláh, golám o móled dátag. ");
INSERT INTO bcc_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Mani wájahay lógi Sárahá piránsariá pa wájahá mardénchokké áwortag o mani wájahá wati sajjahén hasti hamáiárá dátag. ");
INSERT INTO bcc_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Mani wájahá maná sawgend dátag o gwashtag: ‘Mani chokká Kanháni jané maday, cha é molká ke annun man neshtagán. ");
INSERT INTO bcc_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Mani petay lógá o mani syádáni kerrá beraw o mani chokká cha hamáyán jané beday.’ ");
INSERT INTO bcc_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Man cha wati wájahá jost kort ke agan jenekk gón man mayayt gón, gorhá? ");
INSERT INTO bcc_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Gwashti: ‘Hodáwand, ke man áiay ráh zortag, wati préshtagá gón taw ráha dant o tará tai sapará sóbéna kant tánke taw pa mani mardénchokká cha mani jenday mardomán o mani petkawmá jané dar gétk bekanay. ");
INSERT INTO bcc_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Agan taw mani syádáni kerrá beraway, cha sawgendá ázáta bay. Agan á wati jenekká madayant ham, taw cha mani sawgendá ázáta bay.’ ");
INSERT INTO bcc_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Maróchi ke man é chammagay sará átkán, gwashton: ‘Oo Hodáwand! Mani wájah Ebráhémay Hodá! Agan tai razá ent, é sapará ke man átkagán eshiá sóbén kan. ");
INSERT INTO bcc_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Bechár, man é chammagay kerrá óshtátagán, agan jenekké ápá byayt o mani begwashán: “Maná cha wati kunzagá kammé áp beday” o ");
INSERT INTO bcc_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","á maná begwashit: “Bwar, man pa tai oshterán ham ápa kasshán,” gorhá á jenekk hamá bebát ke taw pa mani wájahay chokká gechén kortag.’ ");
INSERT INTO bcc_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Man angat delay tahá dwá nahalléntagat o Rebekkáyá wati kunzag kópagá at o átk. Rebekká dém pa chammagá jahlád ráh gept, shot o ápi kasshet. Man gón áiá gwasht: ‘Maná áp beday.’ ");
INSERT INTO bcc_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Áiá pa eshtápi cha kópagá wati kunzag jahl kort o gwasht: ‘Bwar. Man tai oshterán ham ápa dayán.’ Gorhá man áp wárt o áiá mani oshter ham áp dátant. ");
INSERT INTO bcc_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Man cha áiá jost kort: ‘Taw kai jenekk ay?’ Áiá gwasht: ‘Betwélay jenekk án. Betwélay pet Náhór ent o mát Melkah.’ Gorhá man polóh pónzá dát o hattali dastá dátant o ");
INSERT INTO bcc_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","wati saron jahl kort o Hodáwanday shogr gept. Man, Hodáwand wati wájah Ebráhémay Hodá satá kort ke maná rástén ráhi pésh dásht ke wati wájahay bacchay sángá gón wájahay brátay jenekká bekanáénán. ");
INSERT INTO bcc_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Nun, agan shomá gón mani wájahá mehrabán o wapádára bét, maná jwábé bedayét. Agan mehrabán o wapádára nabét ham begwashét tánke man bezánán ke rástá berawán yá chappá.” ");
INSERT INTO bcc_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lábán o Betwélá passaw dát: “É kár cha Hodáwanday némagá butag. Márá eshiay bárawá na ‘haw’ kanagay ehtiáré hast o na ‘enna’ kanagay. ");
INSERT INTO bcc_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Esh ent Rebekká, zuri o beraw ke tai wájahay chokkay lógi bebit, hamá paymá ke Hodáwandá gwashtag.” ");
INSERT INTO bcc_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ebráhémay hezmatkárá ke áyáni é habar eshkot, Hodáwanday bárgáhá pa adab sari jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Gorhá hezmatkárá nograh o teláhay saht o zéwar o lahtén god áwort o Rebekkáyárá dát. Rebekkáay brát o máti ham gránkimmatén théki dátant. ");
INSERT INTO bcc_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nun hezmatkár o hamráhán warag o charag wárt o shapá hamódá jalletant. Sohbá ke pád átkant, mardá gwasht: “Maná dém pa mani wájahá rahádag kanét.” ");
INSERT INTO bcc_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Bale Rebekkáay brát o mátá passaw dát: “Jenekká bell angat pa kammé wahdá, dahé róchá may kerrá ent, randá berawét.” ");
INSERT INTO bcc_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Hezmatkárá gwasht: “Nun ke Hodáwandá maná mani sapará sóbén kortag, maná madárét o rahádag kanét ke wati wájahay kerrá berawán.” ");
INSERT INTO bcc_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Áyán gwasht: “Sharr, byá jenekká tawára kanén o áiay jendá josta gerén.” ");
INSERT INTO bcc_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Gorhá Rebekkáesh tawár kort o jostesh gept: “Taw gón é mardá raway gón?” Áiá passaw dát: “Haw, rawán gón.” ");
INSERT INTO bcc_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Gorhá áyán wati gohár Rebekká, Rebekkáay shirmátén móled, Ebráhémay hezmatkár o áiay hamráh ráh dátant. ");
INSERT INTO bcc_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Áyán Rebekká barkat dát o gwashtesh: “May gohár! Taw hazáráni hazár bátay. Tai nasl o padréch wati badwáháni shahráni master bátant.” ");
INSERT INTO bcc_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Gorhá Rebekkáyá wati móled zortant o pád átk. Oshterán jammáz butant o á marday hamráhiá shotant. É paymá hezmatkárá Rebekká zort o wati ráhá shot. ");
INSERT INTO bcc_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Nun Esák cha Behér-Lahái-Ruiá per tarretag o átkagat o Negébá jahmenend butagat. ");
INSERT INTO bcc_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Bégáhéá, Esák dhagáray sará gardagá at o hayáláni tahá at. Chammi chest kortant o disti ke lahtén oshter pédák ent. ");
INSERT INTO bcc_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekkáyá ham chamm ke chest kortant, Esáki dist. Cha wati oshterá ér kapt o ");
INSERT INTO bcc_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","gón hezmatkárá gwashti: “É mard kay ent ke dhagáray sará tarráná dém pa má pédák ent?” Hezmatkárá gwasht: “É mani wájah ent.” Gorhá Rebekkáyá cháder zort o watárá mán póshet. ");
INSERT INTO bcc_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Nun hezmatkárá, harché ke butagat, Esák hál dát. ");
INSERT INTO bcc_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Esáká Rebekká zort o wati mátay, bezán Sárahay gedáná áwort o gón Rebekkáyá suri kort. Á, Esákay lógi but o Esáká sakk dóst at. Esák ke wati mátay marká gamig at, nun árám gept. ");
INSERT INTO bcc_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ebráhémá dega jané geptagat ke námi Keturah at. ");
INSERT INTO bcc_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Ebráhémay chokk Zemrán o Yokshán o Médán o Midyán o Yashbák o Shawáh cha Keturahá pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Cha Yoksháná Shébá o Didán pédá butant. Didánay óbádag Áshuri o Letushi o Layumi atant. ");
INSERT INTO bcc_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Midyánay mardénchokk, Epád o Éper o Hanuk o Abidah o Eldáh atant. É sajjahén Keturahay óbádag atant. ");
INSERT INTO bcc_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Ebráhémá wati sajjahén hasti Esákárá dát. ");
INSERT INTO bcc_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Hamá mardénchokk ke Ebráhémá cha soriatán butagatant, wati zendá áyáná thékii dát o cha wati chokk Esáká dur, ródarátki molká ráh dátant. ");
INSERT INTO bcc_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Ebráhémá sad o haptád o panch sál omr kort o ");
INSERT INTO bcc_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","wati goddhi dami kasshet, sharrén mazanén omré korti o mort. Ebráhém piriá pa delémeni gón wati mortagén mahluká hawár but. ");
INSERT INTO bcc_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Áiay chokk Esák o Esmáélá wati pet Mamrehay nazzikká, Makpélahay gáray tahá kabr kort, hamá dhagárá ke Hitti Sóharay chokk Eprunay butagat o ");
INSERT INTO bcc_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Ebráhémá cha Hittián bahá zortagat. Ebráhém hamódá wati lógi Sárahay kerrá kabr kanag but. ");
INSERT INTO bcc_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Cha Ebráhémay marká rand Hodáyá áiay chokk Esák barkat dát. Esák Behér-Lahái-Ruiay nazzikká jahmenend but. ");
INSERT INTO bcc_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ebráhémay chokk Esmáél, ke cha Sárahay Mesri móled Hájerá pédá butagat, áiay nasl o padréchay kessah chosh ent: ");
INSERT INTO bcc_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Esmáélay mardénchokkáni nám, omray hesábá pa red esh ant: Masterén chokk Nebáyut o é dega chokk, Kédar o Adbil o Mebsám o ");
INSERT INTO bcc_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Meshmá o Dumá o Massá o ");
INSERT INTO bcc_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadád o Témá o Yatur o Nápish o Kedmah atant. ");
INSERT INTO bcc_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Hankén o gedánáni hesábá, Esmáélay chokkáni nám hamesh atant, dwázdah sardár, wati kabilaháni red o banday sará. ");
INSERT INTO bcc_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Esmáélá yakk sad o si o hapt sál omr kort. Wati goddhi dami kasshet o mort o gón wati mortagén mahluká hawár but. ");
INSERT INTO bcc_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Áiay óbádag, Mesray simsará ke dém pa Áshurá raway, cha Hawilahá beger tán Shuray zeminá jahmenend butant. Á gón wati sajjahén brátán arhetagatant. ");
INSERT INTO bcc_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ebráhémay chokk Esákay kessah chosh ent: Esákay pet Ebráhém at. ");
INSERT INTO bcc_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Esákay omr chell sál at wahdé gón Rebekkáyá suri kort. Rebekká, Betwél Aramáiay jenekk o Lábán Aramáiay gohár at. Betwél Paddán-Arámay mardomé at. ");
INSERT INTO bcc_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Esákay lógi santh o béawlád at o paméshká Esáká pa wati lógiá cha Hodáwandá dwá lóthet. Hodáwandá áiay dwá gósh dásht o Esákay lógi Rebekkáay láp porr but. ");
INSERT INTO bcc_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Doén chokk, mátay lápá gón yakdomiá kassh o chill kanagá atant. Rebekkáyá gwasht: “Gón man chéá chosh bayagá ent?” Shot o cha Hodáwandá josti kort. ");
INSERT INTO bcc_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Hodáwandá gwasht: “Do ráj tai lápá ent. Do kawm cha tai lápay tahá sedit. Yakk rájé cha domiá zórmandtera bit o masterén, kasterénay hezmatá kant.” ");
INSERT INTO bcc_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Chokmátiay máh o róch ke purah butant, Rebekkáyá járh áwort. ");
INSERT INTO bcc_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Awali chokk ke pédá but, sohragé at o áiay sajjahén badan chó mudi kabáhá at. Áiay námesh Issu kort. ");
INSERT INTO bcc_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Randá áiay brát pédá but o pédá bayagay wahdá Issuay páday punzi dáshtagat. É chokkay námesh Ákub kort. Wahdé Rebekkáyá é járh áwortant, Esáká shast sál at. ");
INSERT INTO bcc_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Chokk rost o mazan butant. Issu zabardastén shekárié but o dasht o gyábánán gardókén mardé at. Ákub árámtabén mardé at o géshter gedáná neshtagat. ");
INSERT INTO bcc_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esáká Issu dóstter at ke shekáray góshtáni támi wassha but. Rebekkáyá Ákub dóstter at. ");
INSERT INTO bcc_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Yakk róché Ákub nároshtay grádagá at, Issu cha gyábáná átk, shodá chang at. ");
INSERT INTO bcc_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Gón Ákubá gwashti: “Cha é sohrén nároshtán toshé day golombán, cha é sohrénán, ke maná shodá kosht.” Paméshká Issuesh Edum ham gwasht. ");
INSERT INTO bcc_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Ákubá passaw dát: “Awalá wati pédáeshi hakká mani kerrá bahá kan.” ");
INSERT INTO bcc_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Issuá gwasht: “Maná shodá kosht, pédáeshi hakk mani che kárá kayt?” ");
INSERT INTO bcc_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Ákubá gwasht: “Pésará gón man sawgend bwar.” Gorhá áiá sawgend wárt o wati pédáeshi hakki Ákubay kerrá bahá kort. ");
INSERT INTO bcc_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Nun Ákubá lahtén nagan o dhálay nárosht Issuárá dát. Áiá wárt o randá pád átk o shot. É paymá Issuá wati pédáeshi hakk béezzat kort. ");
INSERT INTO bcc_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Chó but ke á sardhagárá dhokkálé kapt, abéd cha á pésari dhokkálá ke Ebráhémay wahdá butagat. Esák, Gerárá shot, Pilestiáni bádsháh Abimalekay kerrá. ");
INSERT INTO bcc_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Hodáwand, Esákay démá záher but o gwashti: “Mesrá maraw. Hamá sardhagárá benend ke man tará gwashán. ");
INSERT INTO bcc_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Annun hamé molká darámadéáy paymá benend. Man gón taw gón án o tará barkata dayán. É sajjahén zeminán tará o tai nasl o padréchárá dayán o gón tai pet Ebráhémá wártagén sawgendá barjama dárán. ");
INSERT INTO bcc_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Man tai nasl o padréchá ásmánay estáráni kesásá báza kanán o é sajjahén zeminán áyáná dayán o tai nasl o padréchay sawabá zeminay sajjahén kawm barkata gerant, ");
INSERT INTO bcc_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","chéá ke Ebráhémá mani parmánbardári kort. Áiá mani habar zort, mani rahband o parmán o mani hokm o kánuni barjáh dáshtant.” ");
INSERT INTO bcc_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Gorhá Esák Gerárá nesht. ");
INSERT INTO bcc_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Wahdé óday mardénán cha Esáká áiay lógiay bárawá jost kort, cha torsá nagwashti ke mani lógi ent, gwashti: “Mani gohár ent.” Áiá delá hayál kortagat chó mabit ke eday mardén maná bekoshant o Rebekkáyá bebarant ke á sharrangé. ");
INSERT INTO bcc_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Esák tán mazanén moddatéá hamódá nesht. Yakk róché Pilestiáni bádsháh Abimaleká cha darigá dhann jahlá cháret, disti ke Esák gón wati jan Rebekkáyá dazjaniá ent. ");
INSERT INTO bcc_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimaleká Esák lótháént o gwasht: “Acha é tai jan ent! Taw chéá gwashtag ke ‘mani gohár ent’?” Esáká passaw dát: “Man wati delá gwasht ke áiay sawabá yakké mani jendá koshit.” ");
INSERT INTO bcc_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimaleká gwasht: “Taw chéá gón má chosh kort? Agan mani mardomé gón tai janá bwaptén, taw gonáhé may chakká dawr dátagat.” ");
INSERT INTO bcc_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Gorhá Abimaleká sajjahén mardom hokm dátant: “Harkas ke é mard o eshiay janá dastá ham per bekant, áiá allam markay sezá dayaga bit.” ");
INSERT INTO bcc_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Esáká á dhagáray sará kesht o keshár kort o á sálá dhagárá sad sari bar o samar dát, chéá ke Hodáwandá Esák barkat dát. ");
INSERT INTO bcc_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Esák sér o hazgár but o mál o hastii tán hamá haddá gésh bayán but ke á sakkén mazanén hastómandé jórh but. ");
INSERT INTO bcc_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Esáká ramag o górom o hezmatkár anchó báz at ke Pilesti hasaddig butant o ");
INSERT INTO bcc_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","á sajjahén chátesh bár dát o háká porr kortant ke Esákay pet Ebráhémay hezmatkárán, Ebráhémay zamánagá jatagatant. ");
INSERT INTO bcc_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Nun Abimaleká gón Esáká gwasht: “Cha may kerrá beraw. Taw sakk zórmand ay o cha may haddá dar ay.” ");
INSERT INTO bcc_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Gorhá Esák cha ódá dar átk o Geráray daragá wati gedáni mekk kortant o nesht. ");
INSERT INTO bcc_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Esáká hamá chát dar roptant ke áiay pet Ebráhémay zamánagá kóchag butagatant o Pilestián, Ebráhémay marká rand bár dátagatant. Esáká é chát hamá nám per kortant ke áiay petá bastagatant. ");
INSERT INTO bcc_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Wahdé Esákay hezmatkárán á daragay tahá zemin kótk, tachókén ápay cháté daresh gétk, ");
INSERT INTO bcc_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","bale Geráray shepánk gón Esákay shepánkán arhetant o gwashtesh: “É áp mayg ent.” Gorhá Esáká é chátay nám Esek kort, chéá ke Geráray mardom gón áiá arhetagatant. ");
INSERT INTO bcc_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Esákay hezmatkárán dega cháté jat, bale eshiay sará ham arhetant, gorhá áiá é chátay nám Setnah kort. ");
INSERT INTO bcc_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Esák cha ódá laddhet o shot. Dega cháté jati. Nun eshiay sará kassá arh o korh nakort. Esáká chátay nám Rahubut kort o gwashti: “Nun Hodáwandá márá práh o sháhegánén jágahé dátag o má hamé sardhagárá sér o ábáda bén.” ");
INSERT INTO bcc_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Esák cha ódá dém pa Bérshébahá shot. ");
INSERT INTO bcc_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Hamá shapá Hodáwand áiay démá záher but o gwashti: “Man tai pet Ebráhémay Hodá án. Mators, chéá ke man gón taw gón án. Man wati hezmatkár Ebráhémay sawabá tará barkata dayán o tai nasl o padréchá géshá gésha kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Esáká ódá korbánjáhé addh kort o Hodáwanday námi tawár kort. Wati gedáni hamódá mekk kort o áiay hezmatkárán hamódá cháté jat. ");
INSERT INTO bcc_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Abimalek cha Gerárá wati saláhkár Ahuzzah o wati pawjay sarlashkar Pikulay hamráhiá Esákay kerrá átk. ");
INSERT INTO bcc_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Esáká cha áyán jost kort: “Shomá gón man dozhmeni kort o maná cha wati kerrá gallént. Nun chéá mani kerrá átkagét?” ");
INSERT INTO bcc_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Áyán passaw tarrént: “Má sharriay sará distag ke Hodáwand gón taw gón ent, paméshká má gwasht ke báyad ent mayshomay nyámá kasam o sawgendé bebit. Byá ahd o paymáné bandén ");
INSERT INTO bcc_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ke taw márá ázára nadayay, anchó ke má tará ázár nadátag o gón taw sharr butagén o tará pa salámati o émeni cha wati kerrá rahádag kortag. Nun má gendén ke tará cha Hodáwanday némagá barkat rasetag.” ");
INSERT INTO bcc_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Gorhá Esáká pa áyán mehmánié kort o áyán wárt o noshet. ");
INSERT INTO bcc_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Domi sohbá máhallah pád átkant o Esák o Abimaleká gón yakdegará sawgend wárt. Esáká mardom rahádag kortant o á, cha Esákay kerrá pa salámati o émeni shotant. ");
INSERT INTO bcc_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Hamá róchá Esákay hezmatkár átkant o wati jatagén chátay bárawá hálesh dát. Gwashtesh: “Má áp dar gétkag.” ");
INSERT INTO bcc_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Esáká é chátay nám Shébah kort o tán róche maróchigá á shahrá Bérshébaha gwashant. ");
INSERT INTO bcc_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Wahdé Issuay omr chell sál but, gón Hitti kabilahay Behiri námén mardéay jenekk Yudit o Hitti Élónay jenekk Basématá suri kort. ");
INSERT INTO bcc_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Issuay é janán, Esák o Rebekkáay zendagi azáb kort. ");
INSERT INTO bcc_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Wahdé Esák pir but, chammi nezór butant o maymia nakort. Yakk róché wati masterén chokk, Issui lóthet o gwashti: “Oo mani chokk!” Áiá gwasht: “Ji.” ");
INSERT INTO bcc_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Esáká gwasht: “Bechár, man pir án o nazánán kojám róchá merán. ");
INSERT INTO bcc_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Paméshká wati seláhán, wati tirdán o kamáná bezur o gyábáná beraw o pa man shekáré bekan. ");
INSERT INTO bcc_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Washtámén waragé pa man tayár kan o byár ke bwarán o cha marká pésar tará barkat bedayán, anchén waragé ke maná dósta bit.” ");
INSERT INTO bcc_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Wahdé Esák gón wati chokk Issuá habará at, Rebekká áyáni habarán gósh dáragá at. Issu ke pa shekáray janag o áragá gyábáná shot, ");
INSERT INTO bcc_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekkáyá gón wati chokk Ákubá gwasht: “Bechár, man eshkot ke tai petá gón tai brát Issuá gwasht: ");
INSERT INTO bcc_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","‘Pa man shekáré bekan o byár o washtámén waragé addh kan ke bwarán o cha marká pésar Hodáwanday bárgáhá tará barkat bedayán.’ ");
INSERT INTO bcc_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Mani chokk! Nun mani habará sharr delgósh kan o hamé paym ke man tará gwashán, anchó bekan: ");
INSERT INTO bcc_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Beraw o cha ramagá pa man do sharrén shenekk byár ke man pa tai petá washtámén waragé addh kort bekanán, hamá paymá ke áiá dósta bit. ");
INSERT INTO bcc_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Padá bar o wati petá beday ke bwártesh o cha marká pésar tará barkat bedant.” ");
INSERT INTO bcc_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Ákubá gón wati mát Rebekkáyá gwasht: “Bale mani brát Issuay badaná báz poth per ent o mani ján sáp ent. ");
INSERT INTO bcc_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Agan mani pet maná dast per bekant, gorhá? Man áiay chammán prébkáré bán o barkatay badalá nálaté wati sará kárán.” ");
INSERT INTO bcc_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Mátá gwasht: “Mani chokk! Tai badalá nálat mani chakká kapát. Bass mani habará gósh dár, beraw o shenekkán byár.” ");
INSERT INTO bcc_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Gorhá Ákub shot, shenekki gept o wati mátay kerrá áwortant o mátá washtámén waragé hamá paymá addh kort ke Ákubay petá wassha but. ");
INSERT INTO bcc_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Rebekkáyá wati masterén chokk Issuay hamá sharrén god ke lógá áiay kerrá ér atant, zort o wati kasterén chokk Ákubay gwará dátant. ");
INSERT INTO bcc_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Ákubay gardenay bépohtén jágah o dasti gón shenekkáni póstá póshetant. ");
INSERT INTO bcc_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Nun addh kortagén washtámén warag o nagani wati chokk Ákubay dastá dátant. ");
INSERT INTO bcc_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Ákub wati petay kerrá shot o gwashti: “Mani pet!” Esáká gwasht: “Ji mani chokk! Taw kay ay?” ");
INSERT INTO bcc_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Ákubá gwasht: “Man Issu án, tai awali chokk. Man hamá paymá kort ke taw gwashtagat. Pád á, benend o cha mani shekárá chizzé bwar ke maná barkat dát bekanay.” ");
INSERT INTO bcc_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Esáká wati chokk jost kort: “Mani chokk! Chó zutt taw chón shekár dar gétk?” Passawi dát: “Hodáwandá, tai Hodáyá maná sóbén kort.” ");
INSERT INTO bcc_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Gorhá Esáká gón Ákubá gwasht: “Mani chokk! Nazzikter byá ke man tará dast per kort bekanán o bezánán ke pa rásti taw mani chokk Issu ay yá na.” ");
INSERT INTO bcc_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Ákub wati pet Esákay nazzikká shot, petá dast per kort o gwasht: “Tawár Ákubayg ent, bale dast Issuayg ant.” ");
INSERT INTO bcc_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Esáká Ákub pajjáh nayáwort, chéá ke nun Ákubay dastán Issuay dastáni paymá báz poth per at. Gorhá Esák Ákubay barkat dayagá lagget. ");
INSERT INTO bcc_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Esáká jost kort: “Pa rásti taw mani chokk Issu ay?” Áiá passaw dát: “Haw.” ");
INSERT INTO bcc_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Gorhá gwashti: “Mani chokk! Cha wati shekárá kammok byár ke bwarán o randá tará barkat bedayán.” Ákubá warag áwortant o áiá wárt. Sharábi ham áwort o Esáká wárt. ");
INSERT INTO bcc_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Nun petá gwasht: “Mani chokk! Edá byá o maná bechokk.” ");
INSERT INTO bcc_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ákub áiay nazzikká shot o chokketi. Esáká ke áiay godáni bó lagget, Ákubi barkat dát o gwashti: “Bechár, mani chokkay bó chó hamá gyábánay washbóá ent ke Hodáwandá barkat dátag. ");
INSERT INTO bcc_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Hodá tará cha ásmánay nód o zeminay séri o hazgáriá béhesáb dán o tázagén sharáb bedayát. ");
INSERT INTO bcc_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Kawm tai hezmatá bekanátant o ráj tai démá kóndhán kapátant. Wati brátáni wájah bátay o tai mátay chokk tai démá kóndhán kapátant. Harkas tará nálata kant, wat nálati bát o harkas ke tará barkata dant, áiá barkat berasát.” ");
INSERT INTO bcc_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Esáká Ákubay barkat dayag halás kortagat o Ákub nóki cha wati pet Esákay kerrá shotagat ke áiay brát Issu cha shekárá átk. ");
INSERT INTO bcc_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Áiá ham washtámén waragé addh kort o pa wati petá áwort. Gwashti: “Mani pet! Pád á, benend o cha mani shekárá chizzé bwar ke maná barkat dát bekanay.” ");
INSERT INTO bcc_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Áiay pet Esáká gwasht: “Taw kay ay?” Áiá passaw dát: “Man tai chokk án, Issu án, tai awali chokk.” ");
INSERT INTO bcc_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nun Esáká baláhén larzagé jáná kapt o gwashti: “Gorhá á kay at ke shekáré jat o pa man áworti o man tai áyagá damáné pésar wárt o áiárá barkat dát? O allam áiá barkata rasit.” ");
INSERT INTO bcc_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Wahdé Issuá wati petay habar eshkotant, baláhén peryáté jati. Gón wati petá gwashti: “Maná barkat day, mani pet! Maná ham barkat beday.” ");
INSERT INTO bcc_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Bale Esáká gwasht: “Tai brát pa makr o préb átk o tai barkati bort.” ");
INSERT INTO bcc_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Issuá gwasht: “Paméshká námi Ákub ent. É domi rand ent ke maná répénit. Pésará mani pédáeshi hakki wárt o nun mani barkati bort.” Padá josti kort: “Taw pa man hecch barkat pasht nagétkag?” ");
INSERT INTO bcc_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Esáká gwasht: “Man áiárá tai wájah kortag o áiay sajjahén syád áiay hezmatkár kortagant. Man áiárá gón dán o tázagén sharábá rezk o rózig bakshátag. Nun pa taw ché korta kanán, mani chokk?” ");
INSERT INTO bcc_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Issuá gón wati petá gwasht: “Mani pet! Tai kerrá barkat hamé yakkén at? Maná ham barkat beday, mani pet!” O Issuá zár zárá grét. ");
INSERT INTO bcc_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Áiay pet Esáká gwasht: “Tai hankén cha zeminay séri o hazgáriá bébahra bit o cha borzén ásmánay nódán ham. ");
INSERT INTO bcc_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Taw pa zahm wati rózigá dara géjay o wati brátay hezmatá kanay, bale wahdé bézára bay, wati brátay jogá cha wati gardená kasshay o chagala dayay.” ");
INSERT INTO bcc_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Cha hamá wahdá Issuá pa Ákubá kénag delá dásht, hamá barkatay sawabá ke petá áiárá dátagat. Delá gwashti: “Mani petay porsay róch nazzikk ant. Randá wati brát Ákubá koshán.” ");
INSERT INTO bcc_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Wahdé Rebekkáyá hál raset ke áiay masterén chokk Issuá ché gwashtag, wati kasterén chokk Ákubi lóthet o gwashti: “Tai brát Issuá del wassh kortag ke Ákubá koshán o wati bérá gerán. ");
INSERT INTO bcc_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Mani chokk! Nun mani habará beger. Zutt cha edá betach o Háráná, mani brát Lábánay kerrá beraw. ");
INSERT INTO bcc_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Chizzé wahdá hamáiay kerrá bedár tánke tai brát wati zahrán ér bebárt. ");
INSERT INTO bcc_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tai brátay zahr ke éra káyant o á kárá béhayála kant ke taw gón áiá kortag, man pa taw kolawé ráha dayán. Gorhá cha ódá wátarr kan o byá. Chéá yakkén róchá man shomá doénán bebáhénán?” ");
INSERT INTO bcc_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nun Rebekkáyá gón Esáká gwasht: “Man é Hitti janénáni sawabá cha zendagiá bézár án. Agan Ákubá cha é molkay jenekkán, cha é warhén Hitti jenekkán yakké sáng kort, gorhá man bemerátán.” ");
INSERT INTO bcc_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Esáká Ákub lótháént o barkat dát. Hokmi dát o gwashti: “Kanháni jenekké sáng makan. ");
INSERT INTO bcc_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Zutt Paddán-Arámá beraw, wati mátay pet Betwélay lógá. Hamódá, gón wati mátay brát Lábánay jenekkéá sur kan. ");
INSERT INTO bcc_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Porwákén Hodá tará barkat bedayát o porsamar kanát. Tará géshá gésh kanát o taw kawmáni rombé bátay. ");
INSERT INTO bcc_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Hodá tará o tai nasl o padréchá hamá barkatá bedayát ke Ebráhémárá dátagi, ke hamá sardhagáray wáhond bebay ke annun ódá darámadéay paymá zend gwázenagá ay, hamá sardhagár ke Hodáyá Ebráhémárá bakshátag.” ");
INSERT INTO bcc_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Gorhá Esáká Ákub ráh dát o Ákub Paddán-Arámá Betwél Aramáiay chokk Lábánay kerrá shot. Lábán, Issu o Ákubay mát Rebekkáay brát at. ");
INSERT INTO bcc_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Issu sahig but ke Esáká Ákub barkat dátag o Paddán-Arámá rahádag kortag ke hamódá jané begipt. Á é gappá ham sahig but ke barkat dayagay wahdá Esáká Ákub hokm dátag ke: “Kanháni jenekké sáng makan” o ");
INSERT INTO bcc_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Ákubá pet o mátay habar geptag o Paddán-Arámá shotag. ");
INSERT INTO bcc_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Nun Issu sarpad but ke Kanháni janén mani pet Esáká chinchok nádóst ant. ");
INSERT INTO bcc_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Paméshká Esmáélay kerrá shot o wati pésari janáni sará, Ebráhémay Esmáélén chokkay jenekki gept. Jenekkay nám Mahálat at o Nebáyutay gohár at. ");
INSERT INTO bcc_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ákub cha Bérshébahá dar átk o dém pa Háráná shot. ");
INSERT INTO bcc_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Yakk jágahéá ke raset, shapá hamódá dáshti, chéá ke róch ér shotagat. Hamá jágahá sengé zort o saray chérái kort o tachk but. ");
INSERT INTO bcc_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Wábé disti ta padánké ke yakk saré zeminá enti o domi sar ásmáná o Hodáay préshtag sara kapant o éra kapant. ");
INSERT INTO bcc_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Hodáwand cha padánká borzter óshtátagat. Gwashti: “Man Hodáwand án, tai pet Ebráhémay Hodá o Esákay Hodá. É zeminay sará ke taw annun waptagay, man eshiá tará o tai nasl o padréchárá dayán. ");
INSERT INTO bcc_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tai chokk o nomásag zeminay hákáni kesásá báza bant o shomá ródarátk o rónend o shomál o jonub, chárén némagán tálána bét. Zeminay sajjahén kawm tai o tai nasl o padréchay sawabá barkata gerant. ");
INSERT INTO bcc_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Bechár, man gón taw gón án o har kojá ke raway tai chár o gozárá kanán o tará padá hamé sardhagárá kárán. Tánke man gón taw wati kawl purah nakortag, tará yalaha nadayán.” ");
INSERT INTO bcc_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Ákub ke cha wábá pád átk, gón wat gwashti: “Béshakk Hodáwand hamé jágahá ent o man nazántag.” ");
INSERT INTO bcc_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Torset o gwashti: “É jágah delá ápa kant. É allamá Hodáay jenday lóg ent, arshay darwázag ent.” ");
INSERT INTO bcc_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Domi sohbá máhallah Ákub pád átk, wati saray chéray sengi zort o chédagé addhi kort o rógeni per rétk. ");
INSERT INTO bcc_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Á jágahay námi Bayt-Él kort. Chónáhá á shahray nám pésará Luz at. ");
INSERT INTO bcc_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nun Ákubá kawlé kort, gwashti: “É sapará ke man rawagá án, agan Hodá gón man gón bebit o mani páspániá bekant, agan maná pa waragá nagan o póshagá pocch bedant, ");
INSERT INTO bcc_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ke pa salámati per betarrán o wati petay lógá berasán, gorhá Hodáwand mani Hodá bit. ");
INSERT INTO bcc_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","É seng ke man pa chédag mekk kortag, Hodáay lóga bit. Harché ke tawe Hodá maná dayay, áiay dahyakká allamá tará dayán.” ");
INSERT INTO bcc_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Ákub ráh gept, shot o shot tánke ródarátki mardománi molká sar but. ");
INSERT INTO bcc_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ódá disti ta dashtá cháté o say ramag chátay nazzikká waptag, chéá ke mardomán é ramag cha hamé chátá ápa dátant. Baláhén sengé chátay dapá at. ");
INSERT INTO bcc_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Wahdé sajjahén ramag ódá moccha butant, shepánkán á seng cha chátay dapá kenzént, pas ápa dátant o seng padá hamá jágahá, chátay dapá éra kort. ");
INSERT INTO bcc_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Ákubá gón áyán gwasht: “Brátán! Shomá kojig ét?” Passawesh dát: “Háránay mardom én.” ");
INSERT INTO bcc_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Ákubá jost kortant: “Shomá Náhóray chokk Lábáná pajjáha kárét?” Áyán gwasht: “Haw, zánéni.” ");
INSERT INTO bcc_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Ákubá jost kort: “Lábán dráh o salámat ent?” Áyán passaw dát: “Haw, dráh o salámat ent o esh ent áiay jenekk Ráhil gón pasán pédák ent.” ");
INSERT INTO bcc_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Ákubá gwasht: “Bechár, róch angat borz ent o ramagáni mocch bayagay wahd naent. Pasán áp bedayét o kahcharán barét.” ");
INSERT INTO bcc_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Passawesh dát: “Tánke sajjahén ramag mocch mabant o seng cha chátay dapá kenzénag mabit, má pasán áp dáta nakanén. Randá ápesha dayén.” ");
INSERT INTO bcc_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Ákub angat gón áyán habará at ke Ráhil gón wati petay pasán átk o raset. Ráhil wati petay pasáni shepánk at. ");
INSERT INTO bcc_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Wahdé Ákubá wati mátay brát Lábánay jenekk Ráhil o Lábánay pas distant, dém pa chátá shot, sengi cha chátay dapá kenzént o wati nákóay pasi áp dátant. ");
INSERT INTO bcc_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Ákubá Ráhil chokket o gón borzén tawáréá grewagi bendát kort. ");
INSERT INTO bcc_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Ráhili hál dát ke man tai petay syád án o Rebekkáay chokk án. Ráhil tacháná shot o wati peti hál dát. ");
INSERT INTO bcc_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Lábáná anchó ke wati gohárzátk Ákubay hál eshkot, tacháná átk, Ákubi gwarambáz kort, chokket o wati lógá borti. Ákubá sajjahén gapp gón Lábáná jatant o ");
INSERT INTO bcc_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Lábáná gón áiá gwasht: “Taw mani haddh o hón ay.” Ákub tán máhéá áiay kerrá jallet. ");
INSERT INTO bcc_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Gorhá Lábáná gón Ákubá gwasht: “Belli taw mani syád ay, bale pa man moptá kár makan. Maná wati mozzá begwash.” ");
INSERT INTO bcc_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Lábáná do janénchokk hastat. Masterénay nám Lyáh at o kasterénay nám Ráhil. ");
INSERT INTO bcc_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Lyáhay chamm béjalwah atant bale Ráhil sharrangé at o dhill o báládá jalwanák at. ");
INSERT INTO bcc_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ákubá Ráhil dóst but, gwashti: “Agan maná wati kasterén jenekk Ráhilá bedayay, man pa taw hapt sálá kára kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Lábáná gwasht: “Sharter ent ke man Ráhilá dega mardéay badalá tará bedayán. Hamedá mani kerrá bedár.” ");
INSERT INTO bcc_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Gorhá Ákubá pa Ráhilaygi tán hapt sálá kár kort, bale Ráhili anchó dóst at ke Ákubay delá é haptén sál purah lahtén róch atant. ");
INSERT INTO bcc_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Nun Ákubá gón Lábáná gwasht: “Mani zálá maná beday. Mani haptén sál sarjam butagant o nun man gón áiá hór bayaga lóthán.” ");
INSERT INTO bcc_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Lábáná óday sajjahén mardom lóthetant o dáwaté kort. ");
INSERT INTO bcc_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Shap ke but, wati jenekk Lyáhi zort o Ákubay kerrá bort o Ákub gón áiá hór but. ");
INSERT INTO bcc_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Lábáná wati móled Zelpah wati jenekkárá dát ke áiay hezmatá bekant. ");
INSERT INTO bcc_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sohb ke but, Ákubá dist ke way, é wa Lyáh ent. Gorhá gón Lábáná gwashti: “É chónén káré ke taw gón man kort? Man pa Ráhilá tai hezmat nakort? Taw chéá maná rad dát?” ");
INSERT INTO bcc_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lábáná passaw dát: “May rasm é naent ke kasterén jenekká cha masteréná pésar sur bedayén. ");
INSERT INTO bcc_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","É suray haptagá purah kan, kasteréná ham tará dayén, bale pa man dega hapt sálá kár kan.” ");
INSERT INTO bcc_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Ákubá anchosh kort o Lyáhay haptagi purah kort o Lábáná wati á dega jenekk, Ráhil gón Ákubá sur dát. ");
INSERT INTO bcc_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Lábáná wati móled Bellah wati jenekk Ráhilárá dát ke áiay hezmatá bekant. ");
INSERT INTO bcc_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ákub gón Ráhilá ham hór but. Ráhili cha Lyáhá dóstter at. Ákubá dega hapt sál pa Lábáná hezmat kort. ");
INSERT INTO bcc_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Wahdé Hodáwandá dist ke Lyáh Ákubá nádóst ent, áiárá chokki dát, bale Ráhil santh o béawlád at. ");
INSERT INTO bcc_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Lyáh lápporr but o mardénchokké áworti o chokkay námi Ruben kort. Gwashti: “Hodáwandá mani bazzagi dist. Mani mard nun allamá maná dósta dárit.” ");
INSERT INTO bcc_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Lyáh padá lápporr but o wahdé mardénchokké áworti, gwashti: “Hodáwandá dist ke man nádósté án, paméshká maná é chokki ham dát.” Gorhá chokkay námi Shamun kort. ");
INSERT INTO bcc_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Á padá lápporr but o wahdé mardénchokké áworti, gwashti: “Nun, cha ed o dém mani mard maná dósta dárit ke man pa áiá say mardénchokk áwortag.” Paméshká é chokkay námesh Láwi kort. ");
INSERT INTO bcc_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lyáh padá lápporr but o wahdé mardénchokké áworti, gwashti: “Nun man Hodáwandá názénán.” Gorhá chokkay námi Yahudá kort. Cha ed o rand chokkay áragi band but. ");
INSERT INTO bcc_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Wahdé Ráhilá dist ke man pa Ákubá hecch chokk nayáwortag, wati goháray sará hasaddig but. Gorhá gón Ákubá gwashti: “Maná chokk o awlád beday, agan na mana merán.” ");
INSERT INTO bcc_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Ákub áiay sará zahr gept o gwashti: “Záná man Hodá án ke tai démon dáshtag ke chokk mayáray?” ");
INSERT INTO bcc_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Ráhilá gwasht: “Esh ent mani móled Bellah. Gón eshiá wapt o wáb bekan ke pa man chokk byárit o áiay barkatá maná ham awlád bebit.” ");
INSERT INTO bcc_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Gorhá Ráhilá wati móled Bellah pa jani Ákubárá dát o Ákubá gón áiá wapt o wáb kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bellah lápporr but o pa Ákubá mardénchokké áworti. ");
INSERT INTO bcc_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Gorhá Ráhilá gwasht: “Hodáyá mani dádrasi kortag. Mani peryáti gósh dáshtag o maná chokké dátagi.” Paméshká áiay námi Dán kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Ráhilay móled Bellah padá lápporr but o pa Ákubá dega mardénchokké áworti. ");
INSERT INTO bcc_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Gorhá Ráhilá gwasht: “Maná gón wati gohárá mazanén jang o jérhahé butag o man katthetag.” Paméshká é chokkay námi Naptáli kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Bale wahdé Lyáhá dist ke man chokk áworta nakanán, wati móled Zelpahi chest kort o pa jani Ákubárá dát. ");
INSERT INTO bcc_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Gorhá Lyáhay móled Zelpahá pa Ákubá mardénchokké áwort o ");
INSERT INTO bcc_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lyáhá gwasht: “Chónén wasshén bahté!” Paméshká é chokkay námi Jád kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Lyáhay móled Zelpahá pa Ákubá dega mardénchokké áwort. ");
INSERT INTO bcc_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Gorhá Lyáhá gwasht: “Man sakk gal án. Janénán mani nám kortag ‘Galátun’.” Paméshká chokkay námi Ásher kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Gallahay rón o móshay wahdá Ruben shot o dhagáréá lahtén mehrkáhi dar gétk o pa wati mát Lyáhá áwort. Gorhá Ráhilá gón Lyáhá gwasht: “Cha wati chokkay mehrkáhán maná kammé beday.” ");
INSERT INTO bcc_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Bale Lyáhá gwasht: “Taw mani mard bortag, bass naent? Nun mani chokkay mehrkáhán ham pacha geray?” Ráhilá gwasht: “Sharr ent, tai chokkay mehrkáháni mozzá, enshapi Ákub gón taw bwapsit.” ");
INSERT INTO bcc_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Gorhá wahdé Ákub bégáhay wahdá cha dhagárá per tarret, Lyáh dhanná áiay démá dar átk o gón áiá gwashti: “Gón man bwaps ke man wati chokkay mehrkáháni badalá tará keréh kortag.” Gorhá á shapá Ákubá gón Lyáhá wapt o wáb kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Hodáyá Lyáhay peryát gósh dásht o Lyáh lápporr but o panchomi randá pa Ákubá mardénchokké áworti. ");
INSERT INTO bcc_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Gorhá Lyáhá gwasht: “Man wati móled wati mardárá dát o Hodáyá mani mozz dát.” Gorhá é chokkay námi Issákár kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Lyáh padá lápporr but o shashomi randá pa Ákubá mardénchokké áworti. ");
INSERT INTO bcc_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Gorhá Lyáhá gwasht: “Hodáyá maná kimmatién sawgáté bakshátag. Nun mani mard mani ezzatá kant ke man pa áiá shash mardénchokk áwortag.” Gorhá chokkay námi Zebulun kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Moddatéá rand Lyáhá janénchokké áwort o áiay námi Dinah kort. ");
INSERT INTO bcc_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nun Hodá Ráhilay tránagá kapt, áiay némagá delgóshi gwar kort o chokké baksháti. ");
INSERT INTO bcc_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ráhil lápporr but o mardénchokké áworti. Gwashti: “Hodáyá mani kamsharapi dur kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Paméshká chokkay námi Issop kort. Gwashti: “Hodáwand maná dega mardénchokké ham bedayát.” ");
INSERT INTO bcc_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Wahdé Ráhilá Issop áwort, Ákubá gón Lábáná gwasht: “Nun maná razá beday ke wati jenday dhéhá wátarra kanán. ");
INSERT INTO bcc_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Pa é jan o chokkánigi ke tai hezmaton kortag, eshán maná beday ke zuránesh o rawán. Taw wata zánay ke man pa taw chinchok kár kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Lábáná gwasht: “Maná ezzat beday. Dazbandia kanán hamedá bedár. Man pál jatag o maná é sarpadi rasetag ke Hodáwandá pa taigi maná barkat dátag.” ");
INSERT INTO bcc_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Padá gwashti: “Wati mozzá begwash, tará dayáni.” ");
INSERT INTO bcc_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Ákubá gwasht: “Taw zánay ke man che paymá pa taw kár kortag o tai mál o dalwat man chón sharr dáshtagant. ");
INSERT INTO bcc_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Cha mani áyagá pésar tará kammok hastat o nun sakk báz butagant. Har jáh ke man wati pád ér kortag, Hodáwandá tará hamódá barkat dátag. Bale man kadi pa wati jenday lógá káré bekanán?” ");
INSERT INTO bcc_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Lábáná jost kort: “Tará ché bedayán?” Ákubá passaw tarrént: “Maná hecch maday, bale agan é yakkén kárá pa man bekanay, gorhá man angat tai ramagay shepánki o páspániá kanán. ");
INSERT INTO bcc_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Bell maróchi tai sarjamén ramagáni nyámá gardán. Sajjahén thekk thekkén espétpas o syáhén gwarándh o sajjahén thekk thekkén syahpasán jetá kanán. É mani mozza bant. ");
INSERT INTO bcc_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Bándá róch agan hamé mozzá becháray ke taw maná dátag, mani rásti o tachki wat pa man gwáhia dant. Agan taw mani kerrá anchén syahpasé dar gétk ke thekk thekk mabit yá anchén gwarándhé ke rangi syáh mabit, bezán á dozzetagén málé.” ");
INSERT INTO bcc_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lábáná gwasht: “Sharr ent. Anchosha kanén.” ");
INSERT INTO bcc_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Á róchi Lábáná sajjahén thekk o thagárén páchen, sarjamén thekk thekkén boz ke espétén neshánesh per at o sajjahén syáhén gwarándh jetá kort o wati mardénchokkáni dastá dát o ");
INSERT INTO bcc_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","cha Ákubá say róchay ráhá dur bortant. É wahdá Ákub, Lábánay á dega pasán chárénagá at. ");
INSERT INTO bcc_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Bale Ákubá espédár, bádám o chenáláni nók borretagén sháharh zort o póst pátk o sháharháni tahay espéti dará kortant ke espétén tal záher bebant. ");
INSERT INTO bcc_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Padá pátkagén sháharhi zort o ápdánay tahá ér kortant ke dalwat ke ápá káyant, sháharhesh démá bebant. Wahray wahdá, dalwat ke ápá átkant, ");
INSERT INTO bcc_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","sháharháni démá jopta butant. Paméshká thekk o thagárén chokkesha áwort. ");
INSERT INTO bcc_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ákubá kasánén gwarag jetá kortant o é degaráni démi gón thagárén pas o syáhén pasán kort ke Lábánayg atant. É paymá wati dalwati jetá kortant o gón Lábánay dalwatán hóri nakortant. ");
INSERT INTO bcc_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Har wahdá ke zrengén mádagén dalwat wahra butant, Ákubá sháharh áyáni démay ápdánáni tahá éra kortant ke dalwat é sháharháni kerrá jopt bebant. ");
INSERT INTO bcc_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Bale hamá pas ke nezór atant, sháharhi áyáni démá éra nakortant. É paymá nezórén pas Lábánay némagá shotant o zrengén Ákubay némagá. ");
INSERT INTO bcc_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","É dhawlá Ákub sakk sér o ábád but o baláhén ramagáni wáhond but. Golám o móled o oshter o hari ham báz but. ");
INSERT INTO bcc_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ákubá eshkot ke Lábánay chokk gwashagá ant: “Ákubá may petay sajjahén mál o hasti poshtá kasshetag. Cha may petay málán watá chó sér o hazgári kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ákub sarpad but ke Lábán maná pésari paymá nachárit. ");
INSERT INTO bcc_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Gorhá Hodáwandá gón Ákubá gwasht: “Wati pet o pirok o syádáni molká wátarr kan. Man gón taw gón án.” ");
INSERT INTO bcc_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ákubá pa Ráhil o Lyáhá kolawé dém dát ke gyábáná, mani ramagay kahchará byáét. ");
INSERT INTO bcc_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Gón áyán gwashti: “Mana gendán ke shomay pet maná pésari paymá nachárit, bale mani petay Hodá gón man gón butag. ");
INSERT INTO bcc_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Shomá zánét ke man gón wati sajjahén wák o twáná pa shomay petá kár kortag, ");
INSERT INTO bcc_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","bale angat shomay petá maná rad dátag o mani mozzi dah randá badal kortag, bale Hodáyá shomay pet naesht ke maná táwán bedant. ");
INSERT INTO bcc_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Wahdé Lábáná gwasht: ‘Thekk thekkén pas tai mozza bant,’ sajjahén ramagáni zank o bar thekk thekkéna butant. Wahdé áiá gwasht: ‘Thagár thagárén pas tai mozza bant,’ sajjahén ramagáni zank o bar thagár thagáréna butant. ");
INSERT INTO bcc_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","É paymá Hodáyá shomay petay ramag pach gept o maná dátant. ");
INSERT INTO bcc_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Yakk randé, ramagay wahray mósomá man wábé dist ke man wati sar chest kort o dist ke hamá páchen ke ramagay bozána ráénant, thekk o thagárén ant. ");
INSERT INTO bcc_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Gorhá Hodáay préshtagá wábay tahá maná gwasht: ‘Ákub!’ Man gwasht: ‘Ji.’ ");
INSERT INTO bcc_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Gwashti: ‘Sará chest kan o bechár, ramagay bozáni ráénókén sajjahén páchen thekk o thagárén ant. Man distag ke Lábáná gón taw ché kortag. ");
INSERT INTO bcc_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Man Bayt-Élay Hodá án, hamá jágahay Hodá án ke taw ódá chédagéárá rógen per mosht o gón man kawlé kort. Nun pád á, cha é sardhagárá dar á o wati pédáeshi molká wátarr kan.’ ");
INSERT INTO bcc_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Ráhil o Lyáhá gwasht: ‘Márá wa nun petay lógá mirásé nést. ");
INSERT INTO bcc_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Á márá ham darámadéay hesábá chárit. Áiá márá bahá wa kortag, may baháay zarri ham wártagant. ");
INSERT INTO bcc_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Á sajjahén mál ke Hodáyá cha may petá pach gept, allamá mayg o may chokkánig ent. Gorhá hamá paymá bekan ke Hodáyá tará gwashtag.’” ");
INSERT INTO bcc_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Gorhá Ákub pád átk, wati jan o chokki oshterán jammáz kortant o ");
INSERT INTO bcc_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Paddán-Arámá wati katthetagén sajjahén mál o hastii zort o wati sajjahén ramagi sar dayán kort o dém pa Kanhánay molká wati pet Esákay némagá ráh gept. ");
INSERT INTO bcc_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Lábán pasáni chéná shotagat. Ráhilá wati petay lógay botén Hodá dozzetant. ");
INSERT INTO bcc_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ákubá Lábán Aramái rad dát, háli nadát o cha Lábánay kerrá tatk. ");
INSERT INTO bcc_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Ákub gón wati sajjahén mál o hastiá tatk, cha Parátay kawrá gwast o wati démi gón Gelyáday kóhestagén damagá kort. ");
INSERT INTO bcc_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Sayomi róchá Lábáná hál raset ke Ákub tatkag. ");
INSERT INTO bcc_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Lábáná wati syád zortant o tán hapt róchá Ákubay randá kapt o Gelyáday kóhestagén damagá rasénti. ");
INSERT INTO bcc_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Hodá shapá Lábán Aramáiay wábá átk o gwashti: “Habardár! Ákubá hecch magwash, na sharr, na haráb.” ");
INSERT INTO bcc_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","É wahdá ke Lábán gón Ákubá dochár kapt, Ákubá wati gedán Gelyáday kóhestagén damagá mekk kortagat o Lábán o syádán ham hamódá wati gedán mekk kortant. ");
INSERT INTO bcc_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Lábáná gón Ákubá gwasht: “Taw chéá chó kort? Taw maná rad dát o mani jenekk chó jangi bandigán bortant. ");
INSERT INTO bcc_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Taw chéá maná rad dát o chérokái tatkay? Chéá maná hálet nadát? Man shomárá pa shádehi gón sawt o kanjari o changay sázán rahádag kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Taw inchoká ham sabr nakort ke man wati nomásag o jenekkán bechokkán o roksat bekanán. Taw hórh o ahmakén káré kort. ");
INSERT INTO bcc_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Man tará ázár dáta kanán, bale dóshi tai petay Hodáyá gón man gwasht: ‘Habardár! Gón Ákubá hecch magwash, na sharr, na haráb.’ ");
INSERT INTO bcc_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Taw paméshká shotay ke tará pa wati petay lógá sakk zahir kanagá at, bale taw mani Hodá chéá dozzetant?” ");
INSERT INTO bcc_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Ákubá passaw dát: “Maná torset ke taw wati jenekkán pacha geray, ");
INSERT INTO bcc_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","bale agan taw wati Hodá kaséay kerrá dar gétkant, á koshaga bit. Mani sajjahén mál o hastiá bechár, agan eshán tai chizzé mán, mardománi démá maná péshi dár o bari.” Ákubá nazánt ke é botén Hodá Ráhilá dozzetagant. ");
INSERT INTO bcc_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Gorhá Lábáná Ákubay gedán o Lyáhay gedán o doén móledáni gedán patthetant, bale hechi nadist. Wahdé cha Lyáhay gedáná dar átk, Ráhilay gedáná potert, ");
INSERT INTO bcc_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","bale Ráhilá botén Hodá zortag o wati oshteray lachá kortagatant o wat lachay sará neshtagat. Lábáná sajjahén gedán patthet, bale hecchi nadist. ");
INSERT INTO bcc_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Ráhilá gón wati petá gwasht: “Wájah! Zahr mager, man tai démá pád átka nakanán ke mani janéni máhánagáni wahd ent.” Lábáná patthet, bale botén hodái dast nakaptant. ");
INSERT INTO bcc_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Ákub zahr gept o Lábáni malámat kort. Gón Lábáná gwashti: “Mani mayár ché ent? Man che gonáh kortag ke taw zahrá zahr mani randá kaptagay? ");
INSERT INTO bcc_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Nun ke taw mani sajjahén chizz patthetagant, tará choshén chizzé dast kapt ke taig ent? Agan dast kaptag, mani o wati syád o mardománi démá éri kan. Belli hamá mani o tai paysalahá kanant. ");
INSERT INTO bcc_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Man bist sálá tai kerrá butagán. Tai yakk mésh o bozéá nagétkag. Man tai ramagay yakk gwarándhé nawártag. ");
INSERT INTO bcc_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Man hechbar dalwaté tai kerrá nayáwortag ke rastarán jatag o koshtag. Har táwáné ke butag, badal man cha wat porr kortag. Agan yakk chizzé róchá dozzag butag yá shapá, áiay kimmat taw cha man lóthetag. ");
INSERT INTO bcc_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","É mani hál butag. Róchá maná garmá koshtag o shapá gwahrá. Mani chammáni wáb shotag. ");
INSERT INTO bcc_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tai lógá bist sálá mani hál hamé butag. Man chárdah sál tai doén jenekkáni háterá pa taw kár kortag o shash sál tai ramagáni háterá. Angat taw dah randá mani mozz badal kortag. ");
INSERT INTO bcc_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Agan mani petay Hodá, Ebráhémay Hodá o Esákay Hodá gón man gón mabutén, allamá taw maná hórk o háligén dastán ráh dátagat, bale Hodáyá mani bazzagi o zahmat distag o dóshi tará neherr o hakkali dátag.” ");
INSERT INTO bcc_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Lábáná gwasht: “É jenekk mani jenekk ant, chokk mani chokk o ramag ham mani ramag ant. Harché ke gendagá ay, manig ent. Bale maróchi mani dast gón wati é jenekk o esháni pédá kortagén chokkána narasit. ");
INSERT INTO bcc_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Byá, man o taw gón yakdegará ahd o paymáné bandén. Belli é ahd mani o tai nyámá gwáh o sháheda bit.” ");
INSERT INTO bcc_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Gorhá Ákubá sengé zort o chédagé addh kort o ");
INSERT INTO bcc_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","gón wati syádán gwashti: “Seng mocch kanét.” Áyán seng zort o kót kortant o hameshiay kerrá wargesh wárt. ");
INSERT INTO bcc_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Lábáná eshiay nám Jégar-Sahadutah kort o Ákubá Galid. ");
INSERT INTO bcc_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Lábáná gwasht: “Maróchi é sengkót manig o tai nyámá sháhedé.” Paméshká é Galid náménag but o ");
INSERT INTO bcc_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Lábáná eshiay nám Mespah ham kort ke gwashti: “Wahdé man wati ráhá rawán o taw watigá, Hodáwand maná o tará gendit. ");
INSERT INTO bcc_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Agan gón mani jenekkán sharr mabay o mani jenekkáni sará dega jan begeray, bell toré kass magendit, bale béhayál mabay ke Hodá maná o tará gendit.” ");
INSERT INTO bcc_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Lábáná gón Ákubá chó ham gwasht: “Esh ent sengkót o esh ent hamá chédag ke man watig o tai nyámá mekk kortag. ");
INSERT INTO bcc_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","É sengkót sháhedé o é chédag ham sháhedé ke man pa tai ázár dayagá cha é sengkótá nagwazán o dém pa taw nayáyán o taw ham pa mani ázár dayagá cha é sengkót o chédagá nagwazay o dém pa mana nayáay. ");
INSERT INTO bcc_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ebráhémay Hodá, Náhóray Hodá, áyáni petay Hodá mani o tai nyámá dádras bát.” Gorhá Ákubá wati pet Esákay Hodáay námá sawgend wárt. ");
INSERT INTO bcc_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Hamódá, kóhestagén damagá korbánigé korti o syád o wáresi waragéá dáwat dátant. Waragá rand shapá hamódá dáshtesh. ");
INSERT INTO bcc_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Domi sabáhá, máhallah Lábáná wati jenekk o nomásag chokket o barkat dátant. Padá dar átk o wati lógá per tarret. ");
INSERT INTO bcc_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Nun Ákub rahádag but o ráhá Hodáay préshtag gón áiá dochár kaptant. ");
INSERT INTO bcc_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Wahdé Ákubá préshtag distant, gwashti: “É Hodáay lashkaray ordgáh ent.” Paméshká á jágahay námi Mahanáem kort. ");
INSERT INTO bcc_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Cha wat o pésar kásedi Sahiray sardhagárá, Edumay damagá wati brát Issuay kerrá ráh dátant o ");
INSERT INTO bcc_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","kásedi hokm dátant ke: “Mani wájahén Issuá begwashét ke tai kaster Ákuba gwashit ke tán é wahdi man Lábánay kerrá darámadéay paymá nendók butagán. ");
INSERT INTO bcc_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Maná gók o har o pas o golám o móled hast. Nun man é paygám paméshká pa wati wájah Issuá ráh dátag ke taw maná béezzat makanay.” ");
INSERT INTO bcc_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kásedán ke wati sapar jat o padá Ákubay kerrá sar butant, gwashtesh: “Má tai brát Issuay kerrá shotén o nun á wat gón chár sad mardá tai gendoká pédák ent.” ");
INSERT INTO bcc_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Ákubá gón mazanén tors o larz o paréshánié wati hamráhén mardom do thóliá bahr kortant, ramag o górom o baggi ham do bahrá kortant. ");
INSERT INTO bcc_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Delá gwashti: “Agan Issu byayt o yakk rombéay sará orosh bekant, gorhá domi romb tatka kant.” ");
INSERT INTO bcc_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Gorhá Ákubá dwá kort: “Oo mani pet Ebráhémay Hodá! Mani pet Esákay Hodá! Oo hamá Hodáwand ke gón man gwashtet: ‘Molká wati syádáni kerrá wátarr kan ke man tará sabz o ábáda kanán!’ ");
INSERT INTO bcc_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mane Ákub inchok mehr o wapá nakarzán ke taw gón wati hezmatkárá kortag. Wahdé man cha Ordonay kawrá gwazagá atán, maná bas wati asá gón at, bale nun do ordgáhay wáhond án. ");
INSERT INTO bcc_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Maná cha mani brátay dastá berakkén. Maná cha Issuá rakkén ke maná cha áiá torsit. Á mayayt o mani o mani chokk o chokkáni mátáni sará orosh makant. ");
INSERT INTO bcc_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Bale taw gwashtag: ‘Man allamá tará sabz o ábáda kanán o tai padréchá daryáay rékáni paymá anchó báza kanán ke hesáb nabant.’” ");
INSERT INTO bcc_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Ákubá shapá hamódá dásht. Cha wati málán pa wati brát Issuá sawgáté gechéni kort: ");
INSERT INTO bcc_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","do sad boz o bist páchen, do sad mésh o bist gwarándh, ");
INSERT INTO bcc_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","si dháchi gón herrán, chell mádag o dah káiger, bist mádyán o dah lág. ");
INSERT INTO bcc_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Áiá é, galag galag kort o wati hezmatkáráni dastá dátant o gwashti: “Cha man pésar bét o galagán cha yakdomiá dur dur bedárét.” ");
INSERT INTO bcc_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Ákubá awali hezmatkár hokm dát o gwasht: “Mani brát Issu ke gón taw dochára kapit o josta kant: ‘Taw kai mardom ay? Kojá rawagá ay? É mál o dalwat ke tará gón ant, kaig ant?’ ");
INSERT INTO bcc_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","begwashi: ‘É tai kaster Ákubayg ant. É sawgát ant ke pa mani wájah Issuá ráhi dátagant o Ákubay jend poshtá pédák ent.’” ");
INSERT INTO bcc_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Áiá domi o sayomi o á dega sajjahén hezmatkár ke gón galagán rawagá atant, ham anchosh hokm dátant: “Wahdé shomá Issu dist, hamé habarán gón áiá bekanét. ");
INSERT INTO bcc_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Allamá begwashét: ‘Tai kaster Ákub may poshtá pédák ent.’” Delá gwashti: “Man é thékián cha wat o pésar ráha dayán o áiay delá narma kanán. Randá ke áiá gendán, balkén mani ezzatá bekant.” ");
INSERT INTO bcc_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Gorhá Ákubay sawgát cha áiay jendá pésar shotant o jendi shapá ordgáhá jallet. ");
INSERT INTO bcc_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Hamá shapá Ákub pád átk, wati doén jan, doén móled o yázdahén mardénchokki zortant o cha Yabukay kawray shóná gwast. ");
INSERT INTO bcc_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","É sajjahéni cha kawrá gwázéntant. Wati sajjahén mál o maddhii ham gwázéntant. ");
INSERT INTO bcc_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ákub éwak but. Yakk mardé átk o tán bámgwáhá gón áiá band merhet. ");
INSERT INTO bcc_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Wahdé band merhagá atant, mardá dist ke Ákubá zérdast korta nakanán, gorhá maguná moshté jati o Ákubay magun cha boná dar shot. ");
INSERT INTO bcc_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Gorhá mardá gón Ákubá gwasht: “Bell nun mana rawán ke bámgwáh ent.” Bale Ákubá gwasht: “Tánke maná barkata nadayay, tará rawagá naylán.” ");
INSERT INTO bcc_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Gorhá mardá gwasht: “Tai nám kay ent?” Ákubá passaw dát: “Ákub.” ");
INSERT INTO bcc_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Mardá gwasht: “Cha ed o rand taw Ákub gwashaga nabay, tai nám Esráila bit, chéá ke taw gón Hodáyá o gón mardomán merhetagay o sardast butagay.” ");
INSERT INTO bcc_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Gorhá Ákubá gwasht: “Mani dazbandi ent ke wati námá begwash.” Bale áiá gwasht: “Mani námay jostá chéá kanay?” Gorhá hamódá Ákubi barkat dát. ");
INSERT INTO bcc_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Paméshká Ákubá á jágahay nám Pani-Él kort. Gwashti: “Gón Hodáyá dém pa dém bután, bale angat mani ján rakket.” ");
INSERT INTO bcc_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Wahdé Ákub cha Pani-Élá gwazagá at, róchá thekk kort. Magunay sawabá Ákub lang janáná shot. ");
INSERT INTO bcc_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Páday bonay é zardillek ke dalwatay maguná per ent, paméshká Esráili tán róche maróchigá eshiá nawarant ke á mardá Ákub magunay hamé jágahá moshté jat ke é zardillek ent. ");
INSERT INTO bcc_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Nun Ákubá chamm chest kortant o disti ke Issu pédák ent o chár sad mardi hamráh ent. Gorhá Ákubá Lyáh o chokk yakk thólié kortant, Ráhil o chokk yakk thólié o doén móled gón chokkán yakk thólié. ");
INSERT INTO bcc_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Móled o móledáni chokki démá kortant, cha áyán o rand Lyáh o Lyáhay chokk o cha Lyáh o chokkán o rand, Ráhil o Issop posht poshtá. ");
INSERT INTO bcc_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ákubay jend cha sajjahénán démá shot o hapt randá pa adab sari jahl kort tánke wati brátay nazzikká sar but. ");
INSERT INTO bcc_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Bale Issu pa wati brátay gendoká tachán but. Ákubi gwarambáz kort, dasti áiay gardená dawr dátant o chokketi. Doénán grét. ");
INSERT INTO bcc_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Wahdé Issuá wati chamm chest kortant o janén o chokki distant, gwashti: “É kay ant ke tará gón ant?” Ákubá gwasht: “É hamá chokk ant ke Hodáyá cha wati bakshendahiá tai kasterárá dátagant.” ");
INSERT INTO bcc_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Gorhá móled o chokk nazzikká átkant o saresh jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Lyáh o chokk ham nazzikká átkant o saresh jahl kort. Godhsará Issop o Ráhil nazzikká átkant o saresh jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Issuá jost kort: “É ramag o górom ke man dhikk dátant, esháni maksad ché ent?” Ákubá gwasht: “Maksad esh ent ke taw mani sará mehrabán bebay, mani wájah!” ");
INSERT INTO bcc_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Bale Issuá gwasht: “Mani brát! Maná chónáhá báz hast. Harché tará hast, gón wat bedáresh.” ");
INSERT INTO bcc_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ákubá gwasht: “Enna, cha taw dazbandia kanán, agan mani ezzatá kanay, mani sawgátán bezur ke tai didár chó Hodáay didárá ent o taw maná pa mehrabáni kabul kortag. ");
INSERT INTO bcc_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Mani é thékiá bezur ke pa taw árag butag. Chéá ke Hodá pa man mehrabán butag o maná har chizzi dátag.” Ákubá mennat kort o Issuá mannet. ");
INSERT INTO bcc_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Gorhá Issuá gwasht: “Sar begerén o berawén. Man pésara bán.” ");
INSERT INTO bcc_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Bale Ákubá gwasht: “Mani wájah! Taw zánay chokk kasán o názork ant o pas o gók ham zátagant o shiri ant. Agan yakk róchéá ham eshán pa trondi barán bekanén, sajjahén dalwata merant. ");
INSERT INTO bcc_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Mani dazbandi ent ke mani wájah cha wati kasterá pésar berawt o man narm narmá ramag o góromán sar dayána kanán o chokkáni gámán áyána bán, tánke Sahiray sardhagárá wati wájahay kerrá sar bebán.” ");
INSERT INTO bcc_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Issuá gwasht: “Gorhá man wati lahtén mardom tai hamráha kanán.” Ákubá gwasht: “Chéá? Pa man hamé bass ent ke mani wájah pa man mehrabán ent.” ");
INSERT INTO bcc_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Gorhá Issu hamá róchá dém pa Sahirá per tarret, ");
INSERT INTO bcc_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","bale Ákub Sokkutá shot, hamódá pa wat lóg o pa wati dalwatán gwáshi bast. Paméshká á jágahá Sokkuta gwashant. ");
INSERT INTO bcc_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ákub ke cha Paddán-Arámá per tarragá at, Shekémay shahrá Kanhánay sardhagárá pa salámati sar but o shahray nazzikká ordi kort. ");
INSERT INTO bcc_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","É dhagár ke ódá áiá wati gedán mekk kort, cha Hamóray chokkán pa sad thokkor nograhá bahái zort. Hamór, Shekémay pet at. ");
INSERT INTO bcc_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Ódá korbánjáhé addhi kort o áiay námi Él-Éluhi-Esráil kort. ");
INSERT INTO bcc_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dinah, Ákubay hamá jenekk ke cha Lyáhá pédá butagat, óday jenekkáni gendoká dhanná dar átk. ");
INSERT INTO bcc_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Á molkay hákem Hamóray chokk Shekémá ke Dinah dist, Dinahi bort o pa zór gón áiá wapt o wábi kort. Hamór, Héwi thakkay mardomé at. ");
INSERT INTO bcc_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Shekémay del gón Ákubay jenekk Dinahá lagget o á, Dinahay mehrá gereptár but o gón Dinahá narm narmá habari kort. ");
INSERT INTO bcc_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Shekémá gón wati pet Hamórá gwasht: “Maná gón hamé jenekká sur day.” ");
INSERT INTO bcc_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ákub sahig but ke Shekémá mani jenekk Dinah zená kortag, bale tán wati chokkáni áyagá hecchi nagwasht, chéá ke chokk gyábáná, ramagán chárénagá atant. ");
INSERT INTO bcc_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Shekémay pet, Hamór átk ke gón Ákubá habar bekant. ");
INSERT INTO bcc_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Anchó ke Ákubay chokk sahig butant, cha gyábáná per tarretant. Padard atant o zahrá porr atant ke Shekémá Ákubay jenekk zená kortag o Esráil bannám kortag. É kár mabutén. ");
INSERT INTO bcc_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamórá gón áyán habar kort o gwasht: “Mani chokk Shekémay del pa shomay jenekká band ent. Áiá pa Dinahá zámát kanét. ");
INSERT INTO bcc_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Gón má sángbandi bekanét. Wati jenekkán márá bedayét o maygán shomá bezurét. ");
INSERT INTO bcc_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","May kerrá jahmenend bebét. É molk shomay watig ent, benendét, sawdágeri o bápár bekanét o melkatay wáhond bebét.” ");
INSERT INTO bcc_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Shekémá gón Dinahay pet o brátán gwasht: “Mani sará mehrabán bebét. Harché lóthét, shomárá dayán. ");
INSERT INTO bcc_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Bánóray hakmehrá begwashét o har málé ke lóthét, haminchok ke gwashét, man shomárá dayán. Bass é jenekká gón man sur bedayét.” ");
INSERT INTO bcc_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ákubay chokkán gón Shekém o áiay pet Hamórá pa makkári habar kort, chéá ke Shekémá áyáni gohár Dinah zená kortagat. ");
INSERT INTO bcc_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Ákubay chokkán gón áyán gwasht: “Má é kárá korta nakanén. Gón sonnat nabutagén mardéá wati goháray sur dayag pa má roswáié. ");
INSERT INTO bcc_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","May shart bass yakké. Shomay sajjahén mardén may paymá sonnat kanag bebant. ");
INSERT INTO bcc_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Gorhá má wati jenekkán shomárá dayén o shomay jenekkána zurén o shomay kerrá jahmenenda bén o gón shomá yakjáh, yakkén kawma bén. ");
INSERT INTO bcc_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Bale agan shomá sonnat kanagá razá mabét, má wati gohárá zurén o rawén.” ");
INSERT INTO bcc_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Áyáni habar Hamór o Hamóray chokk Shekémá dóst but. ");
INSERT INTO bcc_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shekém wati petay lógay sharapmandterén mardom at. Hecch mahtal nabut ke Ákubay jenekki sakk dóst at. ");
INSERT INTO bcc_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Gorhá Hamór o áiay chokk Shekém wati shahray darwázagay dapá átkant o gón wati shahray mardénán habaresh kort. Gwashtesh: ");
INSERT INTO bcc_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“É sharrén mardom ant o gón má jang o jadala nalóthant. Shomá bellétesh ke molká nendant o bápára kanant. É molká pa eshán jágah báz ent. Má esháni jenekkána gerén o é maygán. ");
INSERT INTO bcc_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Bale pa may kerrá jahmenend bayag o gón má yakkén kawm bayagá, esháni yakkén shart esh ent ke may har mardén esháni paymá sonnat kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","É dhawlá esháni dalwat o mál o jánwar mayg ham bant gón. Gorhá byáét esháni shartá mannén ke may kerrá jahmenend bebant.” ");
INSERT INTO bcc_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Shahray darwázagá átkagén sajjahén mardénán Hamór o áiay chokk Shekémay habar zort o shahray har mardén sonnat kanag but. ");
INSERT INTO bcc_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Say róch gwast. Angat áyán sonnatay dard per atant ke Ákubay do chokk, Dinahay brát Shamun o Láwiá wati zahm zortant o nádelgóshén shahray sará orosh kort o shahray sajjahén mardénesh koshtant. ");
INSERT INTO bcc_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Áyán Hamór o áiay chokk Shekém zahmay dapá dát o koshtant o Dinahesh cha Shekémay lógá zort o shotant. ");
INSERT INTO bcc_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ákubay chokk mordagáni sará per retkant o hamá shahresh pol o pánch kort ke ódá áyáni gohár zená kanag butagat. ");
INSERT INTO bcc_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Áyán shahray mardománi ramag o górom o har o shahray tahá o shahrá dhann dhagáráni sará harché ke hastat, hull kort o bort. ");
INSERT INTO bcc_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Á mardománi sajjahén mál o hasti‌esh bortant, janén o chokkesh bandig kortant o lógáni sajjahén chizzesh áwár jatant. ");
INSERT INTO bcc_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Gorhá Ákubá gón Shamun o Láwiá gwasht: “Shomá maná azábé sará dát ke shomá maná é molkay mardom, bezán Kanháni o Perizziáni delá syahru kort. Má kammok én o agan é mardom wati zórá yakk bekanant o mani sará orosh bekanant, man o mani lógay mardom tabáha bén.” ");
INSERT INTO bcc_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Bale áyán gwasht: “Gorhá á may gohárá kahbagéay paymá kármarz bekant?” ");
INSERT INTO bcc_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Hodáyá gón Ákubá gwasht: “Pád á, Bayt-Élá beraw o hamódá benend. Ódá pa man korbánjáhé addh kan, pa hamá Hodáyá ke wahdé taw cha wati brát Issuá tachagá atay, tai démá záher but.” ");
INSERT INTO bcc_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ákubá gón wati lógay mardom o á dega sajjahén hamráhán gwasht: “Hamá dhanni hodá ke shomay nyámá ant, cha wat daresh kanét, watá pák o palgár kanét o wati pocchán badal kanét o ");
INSERT INTO bcc_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","byáét Bayt-Élá rawén. Ódá man pa hamá Hodáyá korbánjáhé addha kanán ke sakki o sóriáni róchán mani dwái gósh dáshtag o har jáh ke shotagán, gón man gón butag.” ");
INSERT INTO bcc_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Gorhá áyán har dhanni hodáé ke gón at o har cholombé ke góshán at, sajjahénesh Ákubárá dátant o Ákubá é zort o Shekémá, mazanén drachkay chérá kall kortant. ");
INSERT INTO bcc_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Nun á ráh geptant. Hodáay torsá áyáni chapp o chágerday sajjahén shahráni sará mán shánt o kass áyáni randá nakapt. ");
INSERT INTO bcc_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Ákub o áiay sajjahén hamráh Kanhánay sardhagárá Luzay shahrá, bezán Bayt-Élá sar butant. ");
INSERT INTO bcc_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ákubá hamódá korbánjáhé addh kort o á jágahay námi Él-Bayt-Él kort, chéá ke wahdé á cha wati brátá tachagá at, Hodáyá hamedá áiay démá watá záher kort. ");
INSERT INTO bcc_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Rebekkáay shirmát Daburah bérán but o áesh cha Bayt-Élá dhann, mazanén drachkéay chérá kabr kort. Á jágahay nám Alun-Bákut kanag but. ");
INSERT INTO bcc_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Ákub ke cha Paddán-Arámá átk, Hodá padá áiay démá záher but o Ákubi barkat dát. ");
INSERT INTO bcc_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Gón áiá gwashti: “Tai nám Ákub ent, bale cha ed o rand taw Ákub gwashaga nabay. Tai nám Esráila bit.” Gorhá Ákubay námi Esráil kort. ");
INSERT INTO bcc_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Hodáyá gón Ákubá gwasht: “Man porwákén Hodá án. Chokk o bar kan o gésh bayán bay. Cha taw kawmé o kawmáni rombé pédá bit o bádsháh cha tai sréná pédá bant. ");
INSERT INTO bcc_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Hamá molk ke man Ebráhém o Esákárá dát, tará ham dayáni o cha taw o rand, tai nasl o padréchárá ham é molká dayán.” ");
INSERT INTO bcc_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Gorhá Hodáyá Ákub esht o cha hamá jágahá ke gón áiá habari kortagat, borzád shot. ");
INSERT INTO bcc_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Hamé jágahá ke Hodáyá gón áiá habar kortagat, Ákubá ódá sengay chédagé addh kort o sengay sará réchagi korbánigi rétk o rógeni ham per rétk. ");
INSERT INTO bcc_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","É jágahá ke Hodáyá gón Ákubá habar kortagat, é jágahay nám Ákubá Bayt-Él kort. ");
INSERT INTO bcc_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Gorhá á cha Bayt-Élá dar átkant. Angat Eprátá sar nabutagatant ke Ráhilay chellagi dard bongéj butant. É sáhat pa áiá sakk grán at. ");
INSERT INTO bcc_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Wahdé á chellagiay gránén dardán at, janbógá gón áiá gwasht: “Mators. Tará dega mardénchokké bit.” ");
INSERT INTO bcc_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Wahdé Ráhilay markay sáhat átk o áiay arwáh bál kanagá at, wati chokkay námi Ben-Uni kort, bale petá chokkay nám Benyámin kort. ");
INSERT INTO bcc_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ráhil mort o áesh Eprátay ráhá, bezán Bayt-Lahemay ráhá kabr kort. ");
INSERT INTO bcc_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Ákubá áiay kabray sará shakké mekk kort o hamé shakk tán róche maróchigá Ráhilay kabray nesháni ent. ");
INSERT INTO bcc_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Esráil padá ráh gept o wati gedáni Migdál-Édaray domi némagá mekk kort. ");
INSERT INTO bcc_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Esráil hamé damagá nendók at. Ruben shot o gón wati petay soriat, Bellahá wapt o wábi kort. Esráil sahig but. Ákubá dwázdah mardénchokk hastat: ");
INSERT INTO bcc_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","cha Lyáhá Ruben, ke Ákubay awali chokk at o Shamun o Láwi o Yahudá o Issákár o Zebulun atant, ");
INSERT INTO bcc_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","cha Ráhilá Issop o Benyámin, ");
INSERT INTO bcc_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Bellah ke Ráhilay móled at, cha áiá Dán o Naptáli, ");
INSERT INTO bcc_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Zelpah ke Lyáhay móled at, cha áiá Jád o Ásher. Ákubay hamá mardénchokk ke Paddán-Arámá pédá butant, hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ákub wati pet Esákay kerrá Mamrehá, Keryah-Arbahay shahrá bezán Hebruná átk, hamódá ke Ebráhém o Esáká darámadáni paymá zend gwázéntagat. ");
INSERT INTO bcc_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Esáká yakk sad o hashtád sál omr kort, ");
INSERT INTO bcc_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Wati goddhi dami kasshet o gón wati mortagén mahluká hawár but. Esáká sharrén mazanén omré kort o pir but o mort. Áiay mardénchokkán, bezán Issu o Ákubá á zort o kabr kort. ");
INSERT INTO bcc_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Issu ke áiay domi nám Edum at, áiay nasl o padréchay kessah chosh ent: ");
INSERT INTO bcc_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Issuá do Kanháni jan gept, yakkéay nám Ádah at o yakkéay nám Ohulibámah. Ádah Ilun Hittiay jenekk at o Ohulibámah Anáay jenekk o Sebun Héwiay nomásag at. ");
INSERT INTO bcc_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Issuay sayomi janay nám Basémat at. Basémat Esmáélay jenekk o Nebáyutay gohár at. ");
INSERT INTO bcc_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Issuay chokk Elipáz cha Ádahá pédá but o Rawél cha Basématá. ");
INSERT INTO bcc_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Yahush o Yalám o Kórá cha Ohulibámahá pédá butant. Esh atant Issuay mardénchokk ke Kanhánay sardhagárá pédá butant. ");
INSERT INTO bcc_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Issuá wati jan o bacch o jenekk o lógay sajjahén mardom, wati mál o dalwat o jánwar o harché ke áiá Kanháná chetag o nazz áwortagat, gón wat zortant o cha wati brát Ákubá dur dega molkéá shot. ");
INSERT INTO bcc_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Áyáni mál o hasti sakk báz atant, paméshká hór neshtesh nakort, chéá ke zemin o kahchar pa áyáni ramag o góromán bassa nabut. ");
INSERT INTO bcc_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Gorhá Issu bezán Edum, Sahiray kóhestagá jahmenend but. ");
INSERT INTO bcc_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Sahiray kóhestagay Edumiáni bonpirok Issuay nasl o padréchay kessah chosh ent: ");
INSERT INTO bcc_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Issuay mardénchokkáni nám esh ant: Elipáz ke Issu o Ádahay chokk at, Rawél ke Issu o Basématay chokk at. ");
INSERT INTO bcc_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elipázay mardénchokk Timán o Umár o Sepu o Gatám o Kenáz atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Issuay chokk Elipázá soriaté hastat ke námi Temnah at o Elipázay chokk Amálik cha hamáiá pédá but. Issuay jan Ádahay óbádag hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Rawélay mardénchokk Nahát o Zárah o Shammá o Mezzá atant. Issuay jan Basématay óbádag hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Issuay jan Ohulibámah, Anáay jenekk o Sebunay nomásag at. Yahush o Yahlám o Kórá Issuay hamá mardénchokk atant ke cha Ohulibámahá pédá butagatant. ");
INSERT INTO bcc_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Bani Issuay thakkáni sardár: É sardár, Issuay awali chokk Elipázay mardénchokk atant: Timán o Umár o Sepu o Kenáz o ");
INSERT INTO bcc_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Kórá o Gatám o Amálik. Edumay sardhagárá Elipázay thakkáni sardár hamesh atant. É Ádahay óbádag atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Issuay chokk Rawélay mardénchokk ke thakkáni sardár butant, esh ant: Nahát o Zárah o Shammá o Mezzá. É Edumay sardhagárá Rawélay thakkáni sardár atant o Issuay jan Basématay óbádag atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Issu o áiay jan Ohulibámahay mardénchokk ke sardár butant, esh ant: Yahush o Yahlám o Kórá. É hamá thakkáni sardár atant ke cha Issuay jan Ohulibámahá pédá butant. Ohulibámah, Anáay jenekk at. ");
INSERT INTO bcc_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","É, Issuay, bezán Edumay mardénchokk atant ke har yakké wati thakkay sardár but. ");
INSERT INTO bcc_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Sahir Hóráiay mardénchokk ke á molká nendók atant, esh ant: Lután o Shubál o Sebun o Aná o ");
INSERT INTO bcc_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Dishun o Eser o Dishán. Sahiray é chokk Edumay sardhagárá Hórái thakkáni sardár atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Hóri o Hémám, Lutánay mardénchokk atant. Temnah, Lutánay gohár at. ");
INSERT INTO bcc_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Shubálay mardénchokk Alwán o Manahát o Ébál o Shepu o Ónám atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Sebunay mardénchokk Ayá o Aná atant. É hamá Aná ent ke wati pet Zebyánay haráni chárénagay wahdá gyábáná garmén chammagi dar gétkant. ");
INSERT INTO bcc_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anáay mardénchokk Dishun at o janénchokk Ohulibámah. ");
INSERT INTO bcc_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Dishunay mardénchokk Hemdán o Eshbán o Etrán o Kerán atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Eseray mardénchokk Belhán o Záwán o Akán atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishánay mardénchokk Uz o Arán atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Hórái thakkáni sardár esh atant: Lután o Shubál o Sebun o Aná o ");
INSERT INTO bcc_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishun o Eser o Dishán. Sahiray sardhagárá Hórái thakkáni sardár yakk yakká hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","É hamá bádsháh atant ke Edumay molká bádsháhi‌esh kort. Cha ed o pésar Esráiliáni sará bádsháhéá hákemi nakortagat. ");
INSERT INTO bcc_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Behuray mardénchokk Bélahá mán Edumá bádsháhi kort. Bélahay shahray nám Dinábah at. ");
INSERT INTO bcc_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Cha Bélahay marká rand, Zárahay mardénchokk Yubáb áiay jáhá bádsháhiá nesht. Yubáb Bosrahay mardomé at. ");
INSERT INTO bcc_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yubábay marká rand Hóshám áiay jáhá bádsháh but. Hóshám Timániáni molkay mardomé at. ");
INSERT INTO bcc_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hóshámay marká rand Bedáday mardénchokk Hadád, Hóshámay jáhá bádsháh but. É hamá Hadád at ke Muábay dashtá Midyánii jatant. Hadáday shahray nám Awit at. ");
INSERT INTO bcc_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadáday marká rand Samlah, Hadáday jáhá bádsháh but. Samlah Masrikahay mardomé at. ");
INSERT INTO bcc_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlahay marká rand Shául, Samlahay jáhá bádsháh but. Shául Rahubutay mardomé at. Rahubut Parátay kawray kerrá ent. ");
INSERT INTO bcc_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Sháulay marká rand Akburay mardénchokk Bahal-Hánán Sháulay jáhá bádsháh but. ");
INSERT INTO bcc_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Akburay chokk Bahal-Hánánay marká rand Hadád áiay jáhá bádsháh but. Hadáday shahray nám Páhu at o janay námi Mehtabel at. Mehtabel, Matreday jenekk at o Matred Mizáhabay jenekk. ");
INSERT INTO bcc_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","É, Issuay thakkáni sardár atant. Áyáni nám, thakk o damagáni red o banday hesábá Temnah o Alwah o Atit o ");
INSERT INTO bcc_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Ohulibámah o Élah o Pinun o ");
INSERT INTO bcc_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Kenáz o Timán o Mebzár o ");
INSERT INTO bcc_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdél o Irám atant. É wati halk o métagáni hesábá Edumay thakkáni sardár atant, hamá molká ke áyáni wati melkat at. É, Edumiáni bonpirok Issuay padréch at. ");
INSERT INTO bcc_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ákub hamá sardhagárá jahmenend but ke áiay petá ódá darámadéay paymá zend gwázéntagat, bezán Kanhánay molká. ");
INSERT INTO bcc_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ákubay nasl o padréchay kessah chosh ent: Issop habdah sáli warnáé at o wati brátáni hamráhiá ramagia chárént, wati mátó Bellah o Zelpahay mardénchokkáni hamráhiá. Issopá wati brátáni radén káráni bárawá pet hála dát. ");
INSERT INTO bcc_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Esráilá Issop cha wati á dega sajjahén chokkán dóstter at, chéá ke Issop áiay piránsariay chokk at. Pa Issopá sakkén dhawldárén kabáhé addhi kanáént. ");
INSERT INTO bcc_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Wahdé brátán dist ke petá Issop cha má dóstter ent, cha Issopá napratesh kort o gón áiá modám zahrá zahr habaresha kort. ");
INSERT INTO bcc_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Issopá wábé dist o wahdé wati bráti hál dátant, áiay brátán cha Issopá géshter naprat kort. ");
INSERT INTO bcc_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Issopá gón áyán gwasht: “Gósh dárét! Man wati distagén wábá shomárá gwashán. ");
INSERT INTO bcc_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Má dhagáray sará gandom lóthok kanagá atén ke yakbará mani lóthok pád átk o óshtát. Hamé damáná shomay lóthok, mani lóthokay chapp o chágerdá mocch butant o áesh sojdah kort.” ");
INSERT INTO bcc_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Issopay brátán gwasht: “Taw may sará bádsháhi kanaga lóthay? Hakk o del may sará hákemia kanay?” Issopay brátán, áiay wáb o habaráni sawabá cha áiá géshter naprat kort. ");
INSERT INTO bcc_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Issopá dega wábé dist o wati bráti hál dátant. Gwashti: “Gósh dárét. Man dega wábé distag. É randi, róch o máh o yázdah estár maná sojdah kanagá at.” ");
INSERT INTO bcc_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Wahdé wati pet o bráti hál dátant, petá Issop hakkal kort o gwasht: “É chónén wábé taw distag? Man o tai mát o tai brát byáén o tará sojdah bekanén?” ");
INSERT INTO bcc_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Brát gón Issopá hasaddig atant, bale petay hayál modám gón Issopay wáb o habarán at. ");
INSERT INTO bcc_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Issopay brátán petay ramag pa chárénagá Shekémay nazzikká bortagat. ");
INSERT INTO bcc_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Esráilá gón Issopá gwasht: “Taw zánay ke tai brát ramagay chárénagá Shekémá shotagant. Watá gisshén o áyáni kerrá beraw.” Issopá gwasht: “Sharr ent.” ");
INSERT INTO bcc_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Esráilá gwasht: “Beraw o bechár tai brát o ramag dráh o salámat ant? Áyáni hálá ger o byá.” Gorhá Issopi cha Hebrunay daragá ráh dát. Lógesh hamódá at. Wahdé Issop Shekémá sar but, ");
INSERT INTO bcc_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","gón yakk mardéá dochár kapt. Mardá dist ke Issop gyábáná sargardán ent, josti kort: “Taw ché shóház kanagá ay?” ");
INSERT INTO bcc_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Issopá gwasht: “Wati brátán. Taw zánay ramagá kojá chárénagá ant?” ");
INSERT INTO bcc_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Mardá passaw dát: “Cha edá shotagant. Man eshkot, á gwashagá atant: ‘Dótáná berawén.’” Gorhá Issop hamá némagá dém pa brátán shot. Dótáná dari gétkant. ");
INSERT INTO bcc_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Brátán Issop cha durá dist o áiay sar bayagá pésar pa áiay koshagá pandalé sázetesh. ");
INSERT INTO bcc_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Watmánwatá gwashtesh: “Bechárét, wábáni wájah pédák ent. ");
INSERT INTO bcc_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Byáét nun koshén o cha é chátán yakkéá dawria dayén, gwashén rastaréá wártag. Gorhá chárén ke cha áiay wábán ché dara kayt.” ");
INSERT INTO bcc_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bale wahdé Rubená é habar eshkot, johdi kort ke Issopá cha áyáni dastá berakkénit. Gwashti: “Enna, Issopay sáhá nagerén. ");
INSERT INTO bcc_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Hón maréchét. Hamé gyábáná, é chátá dawria dayén, bale nakoshéni.” Rubená é habar paméshká gwasht ke Issopá berakkénit o gón wat bezurit o petay kerrá bebárt. ");
INSERT INTO bcc_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Wahdé Issop brátáni kerrá sar but, áiay gwaray kabáh, hamá dhawldárén kabáhesh dar kort o ");
INSERT INTO bcc_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Issopesh gept o chátá dawr dát. Chátá áp mán néstat, kórcháté at. ");
INSERT INTO bcc_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Brát nánay waragá neshtant. Chammesh ke chest kortant, distesh Esmáéliáni kárwáné cha Gelyádá pédák ent. Áyán wati oshterán sosorr o bám o washbó laddhetagat o Mesrá baragá atant. ");
INSERT INTO bcc_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yahudáyá gón wati brátán gwasht: “Márá cha wati brátay koshag o áiay hónay chér dayagá che páedagé rasit? ");
INSERT INTO bcc_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Byáét, Issopá Esmáéliáni kerrá bahá kanén. Áiay jendá nakoshén. May brát ent. May wati haddh o hón ent.” Brátán mannet. ");
INSERT INTO bcc_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Wahdé Midyáni sawdáger nazzikká rasetant, brátán Issop cha chátá kasshet o bist nograhá Esmáéliáni kerrá bahá kort. Esmáélián Issop Mesrá bort. ");
INSERT INTO bcc_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Wahdé Ruben per tarret o chátay kerrá átk o Issopi ódá nadist, wati godi dertant. ");
INSERT INTO bcc_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Wati brátáni kerrá shot o gwashti: “Bachakk ódá naent. Nazánán ché bekanán.” ");
INSERT INTO bcc_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Gorhá pasé heláresh kort, Issopay kabáhesh zort o pasay hónán jat. ");
INSERT INTO bcc_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Nun Issopay dhawldárén kabáhesh petay kerrá bort o gwashtesh: “Má é chetag. Bechári, bárén tai chokkay kabáh naent?” ");
INSERT INTO bcc_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ákubá kabáh pajjáh áwort, gwashti: “É mani chokkay kabáh ent. Chokk rastaréá wártag. Allamá Issop thokkor thokkor butag.” ");
INSERT INTO bcc_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Gorhá Ákubá wati god dertant o gónién god gwará kort o tán bázén róchéá wati chokkay porsá nesht. ");
INSERT INTO bcc_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ákubay sajjahén bacch o jenekk pa áiay tasallá dayagá átkant, bale á tasallá nabut. Gwashti: “Man porsigá porsig mordagáni jaháná, wati chokkay kerrá jahláda rawán.” O pet modám pa Issopá gréwagá at. ");
INSERT INTO bcc_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","O á némagá Midyánián Mesrá Issop Putipáray kerrá bahá kort. Putipár, Perawnay apsaré at. Negahpánáni master at. ");
INSERT INTO bcc_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Hamé wahdá Yahudáyá wati brát yalah dátant o shot o Hirá námén mardéay kerrá jahmenend but. Hirá Adollámié at. ");
INSERT INTO bcc_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Ódá áiá Shóhá námén mardéay jenekk dist. Shóhá Kanhánié at. Yahudáyáy Shóháay jenekk sáng kort. Gón áiá yakjáh but o ");
INSERT INTO bcc_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","janénay láp porr but o mardénchokké áworti. Yahudáyá chokkay nám Hér kort. ");
INSERT INTO bcc_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Yahudáay jan padá lápporr but. Dega mardénchokké áworti o eshiay námi Ónán kort. ");
INSERT INTO bcc_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Padá dega mardénchokké áworti o eshiay námi Shélá kort. Shélá Kezébay shahrá pédá but. ");
INSERT INTO bcc_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yahudáyá wati awali chokk Hér gón Támár námén jenekkéá sur dát, ");
INSERT INTO bcc_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","bale Hodáwanday chammán Yahudáay awali chokk Hér badkáré at, paméshká Hodáwandá markay dapá dát. ");
INSERT INTO bcc_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Gorhá Yahudáyá gón Ónáná gwasht: “Wati brátay janózámá beger o gón áiá yakjáh bay. Wati bráti parzá purah kan o pa wati brátá padréché pédá kan,” ");
INSERT INTO bcc_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","bale Ónáná zánt ke é mani jenday padrécha nabit, paméshká wahdé gón wati brátay janá yakjáha but, wati marzii dhanná rétkant ke pa brátá padréché pédá makant. ");
INSERT INTO bcc_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Áiay é kár Hodáwanday chammán radén káré at, paméshká Ónáni ham markay dapá dát. ");
INSERT INTO bcc_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Gorhá Yahudáyá gón wati neshár Támárá gwasht: “Tánke mani chokk Shélá kasán ent, wati petay lógá janózámi benend.” Áiá wati delá hayál kort: “Chosh mabit ke Shélá ham wati brátáni paymá bemerit.” Gorhá Támár shot o wati petay lógá nesht. ");
INSERT INTO bcc_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Mazanén moddatéá rand Yahudáay jan ke Shóháay jenekk at, mort. Wahdé Yahudá cha porsá pád átk, Temnahay shahrá wati paschénáni kerrá shot. Áiay sangat Hirá Adollámi áiay hamráh at. ");
INSERT INTO bcc_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Wahdé Támár sahig but ke mani nákó pa wati pasáni chéná dém pa Temnahá ráhá ent, ");
INSERT INTO bcc_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wati janózámi godi kasshetant, nekábé pósheti o Temnahay ráhay sará, Enáimay shahray darwázagay kerrá nesht, chéá ke áiá dist ke Shélá nun mazan butag, bale angat maná gón áiá suresh nadátag. ");
INSERT INTO bcc_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yahudáyá ke Támár dist, delá gwashti é kahbagé chéá ke Támárá wati dém póshetagat. ");
INSERT INTO bcc_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Nazánti ke mani neshár ent. Hamódá, ráhay kashá Yahudá áiay kerrá shot o gwashti: “Gón man nayáay gón?” Támárá jost kort: “Gón man ke wapt o wába kanay, maná ché dayay?” ");
INSERT INTO bcc_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Yahudáyá passaw dát: “Cha wati ramagá pa taw shenekké ráha dayán.” Támárá gwasht: “Zamánat ché dayay ke taw shenekká ráha dayay?” ");
INSERT INTO bcc_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yahudáyá gwasht: “Ché zamánat bedayán?” Támárá gwasht: “Wati mohr o mohray bandá o wati dastay asáyá.” Yahudáyá é chizz Támáray dastá dátant, gón áiá wapt o wábi kort o Támár lápporr but. ");
INSERT INTO bcc_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Támár ke lógá shot, wati nekábi kasshet o padá janózámi godi gwará kortant. ");
INSERT INTO bcc_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yahudáyá gón wati Adollámi sangatá gwasht ke shenekká bar o zamánatay chizzán cha janénay kerrá pach ger o byár. Bale sangatá janén nadist. ");
INSERT INTO bcc_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Cha shahray mardomán josti kort: “Bothánahay hamá móled ke Enáimay ráhay sará neshtagat, kojá ent?” Áyán gwasht: “Edá bothánahay hecch móled nabutag.” ");
INSERT INTO bcc_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Gorhá Yahudáay sangat átk o gwashti: “Man á janén dar gétk nakort. Shahray mardomán ham gwasht ke edá bothánahay hecch móled nabutag.” ");
INSERT INTO bcc_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yahudáyá gwasht: “Belli á chizzi gón ant. Chó mabit ke may jend bannám bebit. Bechár, man shenekk ráh dát, bale á janénay jend gár ent.” ");
INSERT INTO bcc_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Kesás say máhá rand Yahudáesh hál dát ke: “Tai neshár Támárá wati dém syáh kortag o nun lápi porr ent.” Yahudáyá gwasht: “Áiá dhanná dar kanét o bon dayét.” ");
INSERT INTO bcc_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Wahdé Támárá baragá atant, pa wati nákóá paygámé ráhi dát o gwashti: “É chizzáni wáhondá maná lápporr kortag. Bechár, bárén é mohr o mohray band o asáay wáhondá pajjáha káray?” ");
INSERT INTO bcc_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yahudáyá é chizz pajjáh áwortant o gwashti: “Támár cha man bégonáhter ent ke man Támár gón wati chokk Shéláyá sur nadát.” Yahudáyá padá hechbar gón áiá wapt o wáb nakort. ");
INSERT INTO bcc_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Wahdé Támáray chellag bayagay wahd but, áiay lápay chokk járh atant. ");
INSERT INTO bcc_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Támár ke chellag bayagá at, cha jáhrán yakkéá wati dast cha áiay jáná dhann dar kort o janbógá sohrén bandikké áiay dastá bast o gwashti: “É chokk pésará átk.” ");
INSERT INTO bcc_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Bale wahdé é chokká wati dast padá tahá bort, bráti dar átk o janbógá gwasht: “Eh! Taw chón wati ráh pach kort.” Paméshká áiay námesh Páres kort. ");
INSERT INTO bcc_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Randá áiay brát ke dastá sohrén bandikké bastagat, pédá but o áiay námesh Zárah kort. ");
INSERT INTO bcc_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Nun, Esmáélián Issop Mesrá áwort. Ódá, Putipár námén Mesri mardéá Issop bahá gept. Putipár cha Perawnay apsarán yakké at. Negahpánáni master at. ");
INSERT INTO bcc_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Hodáwand gón Issopá gón at, paméshká Issop har kárá kámyáb at o wati Mesri wájahay lógá jahmenend at. ");
INSERT INTO bcc_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Wahdé Issopay wájahá dist ke Hodáwand gón Issopá gón ent o Issop har káré ke kant, Hodáwand áiá kámyába kant, ");
INSERT INTO bcc_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Issopay sará mehrabán but o Issopi wati hásén hezmatkár kort. Putipárá Issop wati lógay master kort o wati sajjahén mál o hastii hamáiay dastá dát. ");
INSERT INTO bcc_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Cha hamá wahdá ke áiá Issop wati lóg o sajjahén hastiay master kort, Hodáwandá pa Issopaygi Mesri Putipáray lóg barkat dát. Hodáwandá Putipáray sajjahén mál o hasti barkat dát, lógá ham o dhagáráni sará ham. ");
INSERT INTO bcc_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Gorhá Putipárá wati har chizz hamáiay dastá dát o wati waráká abéd gón dega hecchá kári néstat. Issop washkadd o brahdárén warnáé at. ");
INSERT INTO bcc_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kammé wahdá rand wájahay lógiá chamm Issopá sakk dátant o gwashti: “Gón man bwaps.” ");
INSERT INTO bcc_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Bale Issopá namannet o gwashti: “Mani wájah cha man anchó deljam ent ke áiá gón é lógay hecchá kár nést o wati sajjahén mál o hastii mani dastá dátag. ");
INSERT INTO bcc_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","É lógá kass cha man master naent. Tai jendá abéd hecch chizzi cha man dur nadáshtag, chéá ke taw áiay lógbánok ay. Gorhá man chón choshén radén káré bekanán o watá Hodáay chammán gonahkár bekanán?” ");
INSERT INTO bcc_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Wájahay janá har róch Issop mennata kort, bale Issopá namannet o nalótheti ke gón áiá wapt o wáb bekant. Áiay nazzikk o gwará bayagi ham wassha nabut. ");
INSERT INTO bcc_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Yakk róché ke Issop wati káráni kanagá lógá potert, lógá dega kass néstat. ");
INSERT INTO bcc_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Putipáray janá dast Issopay kabáhá sakk kortant. Gón Issopá gwashti: “Byá, gón man bwaps.” Bale Issop tacháná dar átk o kabáh janénay dastá mant. ");
INSERT INTO bcc_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Wahdé janéná dist ke Issopá wati kabáh mani dastá esht o cha lógá tatk, ");
INSERT INTO bcc_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","wati lógay hezmatkári gwánk jatant o gwashti: “Bechárét, mani lógwájahá é Ebráni may lógá áwortag ke márá kalági bekant. É mani chakká kaptag ke gón man bwaps, bale man kukkár kort o ");
INSERT INTO bcc_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","wahdé eshiá dist ke man kukkár kort, wati kabáhi mani kerrá esht o dar shot.” ");
INSERT INTO bcc_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Putipáray janá Issopay kabáh tán hamá wahdá wati kerrá ér kort ke Issopay wájah lógá átk, ");
INSERT INTO bcc_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","gón áiá kessahi kort o gwashti: “É Ebráni golám ke taw may lógá áwortag, mani kerrá átk ke maná kalági bekant, ");
INSERT INTO bcc_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","bale wahdé man kukkár kort, áiá wati kabáh mani kerrá yalah dát o dar shot.” ");
INSERT INTO bcc_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Wahdé Issopay wájahá wati lógiay habar eshkotant ke tai hezmatkárá gón man chosh kortag, sakk hezhm gept o ");
INSERT INTO bcc_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Issopi zort o hamá bandijáhá band kanáént ke ódá bádsháhay bandig band atant. Issop hamódá band kanag but, ");
INSERT INTO bcc_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","bale Hodáwand gón áiá gón at o wati mehri pa Issopá gwárént o bandijáhay masteray deli pa Issopá narm kort. ");
INSERT INTO bcc_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Bandijáhay masterá Issop sajjahén bandigáni master kort o óday har kári Issopay dastá dát. ");
INSERT INTO bcc_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Bandijáhay masterá har kár o zemmahé ke Issopay dastá dát, deli jam at, chéá ke Hodáwand gón Issopá gón at o Issopá har káré ke kort, Hodáwandá á kámyába kort. ");
INSERT INTO bcc_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kammé wahdá rand Mesray bádsháhay ápiá o nániá wati wájah, Mesray bádsháhay nezará radi kort. ");
INSERT INTO bcc_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Perawn doén kárdáráni sará, masterén ápi o masterén nániay sará zahr gept o ");
INSERT INTO bcc_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","negahpánáni masteray lógá bandi kanáéntant, hamá bandijáhá ke Issop bandig at. ");
INSERT INTO bcc_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Negahpánáni masterá Issop hokm dát ke esháni hayálá bedár. Issopá anchosh kort. É mardom tán moddatéá bandijáhá mantant. ");
INSERT INTO bcc_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Mesray bádsháhay ápi o náni ke bandijáhá atant, yakk shapé doénán wáb dist o har yakkéay wábá jetáén mánáé hastat. ");
INSERT INTO bcc_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Wahdé Issop é dega sohbá áyáni kerrá átk, disti ke doén paréshán ant. ");
INSERT INTO bcc_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Perawnay hamé doén kárdár ke Issopay wájahay bandijáhá gón áiá yakjáh band atant, Issopá cha áyán jost kort: “Maróchi shomá paréshán ét, che gappé?” ");
INSERT INTO bcc_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Áyán passaw dát: “Má doénán wáb distag o kass nést ke mánáesh bekant.” Issopá gwasht: “Wábáni mánáay zánag wa Hodái káré. Wati wábán maná begwashét.” ");
INSERT INTO bcc_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Gorhá ápiáni masterá wati wáb gón Issopá gwasht: “Bechár, man wábé dist ke anguray drachké mani démá ent. ");
INSERT INTO bcc_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Drachká say thál per. Anchó ke drachká tej jat, burr o bar but o cha hóshán rasetagén angur dar átk. ");
INSERT INTO bcc_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Perawnay pyalah mani dastá at. Man angur sar chet o Perawnay pyálahay tahá pretkant o pyalah áiay dastá dát.” ");
INSERT INTO bcc_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Issopá gwasht: “Tai wábay máná esh ent: Say thálay máná say róch ent. ");
INSERT INTO bcc_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Say róchay tahá Perawn tai sará borza kant o tará pésarigén mansabá dant. Taw Perawnay pyálahá dastá dayay, anchó ke taw pésará kortag hamá wahdá ke áiay ápi butagay. ");
INSERT INTO bcc_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Wahdé tai kár sharra bant, mani yátá bekap. Mehrabáni bekan o mani hálá Perawná sar kan o maná cha é bandijáhá dar kanáén. ");
INSERT INTO bcc_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Man cha Ebrániáni molká dozzag o edá árag butagán o edá ham man choshén káré nakortag ke é syahchátá dawr dayag bebán.” ");
INSERT INTO bcc_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Wahdé nániáni masterá dist ke Issopá sharrén mánáé kort, gwashti: “Man wati wábá distag ke naganay say sapt mani sará ent o ");
INSERT INTO bcc_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","sarbori saptá pa Perawná warh warhén patkagén warák mán, bale báli morg cha saptá eshán waragá ant.” ");
INSERT INTO bcc_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Issopá gwasht: “Tai wábay máná esh ent: Say saptay máná say róch ent. ");
INSERT INTO bcc_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Say róchay tahá Perawn tai sará ‘borza’ kant o tará drachkéá dranjit o báli morg tai góshtá warant.” ");
INSERT INTO bcc_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Sayomi róchá Perawnay sálgerah at. Áiá sajjahén hezmatkár dáwaté dátant. Wati hezmatkáráni démá masterén ápi o masterén nániay sari “borz” kortant. ");
INSERT INTO bcc_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Áiá masterén ápi padá hamá mansabá nádént ke Perawnay pyálah dastá dayók bebit. ");
INSERT INTO bcc_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Bale hamá paymá ke Issopá gwashtagat o masterén nániay wábi máná kortagat, Perawná masterén náni dratk. ");
INSERT INTO bcc_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Bale ápiáni masterá Issop shamosht o áiay tránagá nakapt. ");
INSERT INTO bcc_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Do sálá rand Perawná wábé dist ke Nillay kawray kerrá óshtátagán. ");
INSERT INTO bcc_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Hamé wahdá hapt dhawldár o pazzórén gók cha ápá dar átk o kásháni tahá charagá laggetant. ");
INSERT INTO bcc_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Cha eshán o rand dega hapt baddhawl o lágarén gók cha Nillá dar átk o kawray kashá, á dega gókáni kerrá óshtátant. ");
INSERT INTO bcc_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Baddhawl o lágarén gókán haptén dhawldár o pazzórén gók wártant. Perawn cha wábá ágah but. ");
INSERT INTO bcc_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Perawn padá wapt o dega wábé disti ke dánay hapt zandh o sharrén hóshag yakk tháléay sará rodagá ent. ");
INSERT INTO bcc_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Cha eshán o rand dega hapt hóshag záher but. É hóshag lágar atant o cha ródarátká kasshókén lewárá gimmoréntagatant. ");
INSERT INTO bcc_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Lágarén hóshagán haptén zandh o sharrén hóshag wártant. Perawn pád átk o zánti ke é wábé at. ");
INSERT INTO bcc_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Sohb ke but, Perawn paréshán at. Wati mardomi ráh dátant o Mesray sajjahén dáná o jádugeri lótháéntant. Perawná gón áyán wati wábáni kessah kort, bale kassá áiay wáb máná kort nakortant. ");
INSERT INTO bcc_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Gorhá masterén ápiá gón Perawná gwasht: “Man maróchi wati radiáni tránagá kaptagán. ");
INSERT INTO bcc_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yakk randé tawe Perawn wati hezmatkáráni sará zahr geptay o maná o masterén náni zort o negahpánáni masteray bandijáhá band kanáént. ");
INSERT INTO bcc_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Yakk shapé má doénán wáb dist o har yakk wábéá wati mánáé hastat. ");
INSERT INTO bcc_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ódá gón má Ebráni warnáé band at. Negahpánáni masteray hezmatkáré at. Má gón áiá wati wábay kessah kortant o áiá máná kort o dátant. Doénán wati wábáni máná raset. ");
INSERT INTO bcc_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Hamá paymá ke áiá may wáb máná kortagatant, hamá dhawlá but. Maná wati pésarigén mansab raset o náni dranjag but.” ");
INSERT INTO bcc_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Gorhá Perawná Issop lótháént o Issop hamá damáná cha syahchátá dar kanag o árag but. Issopá rissh sát o god matth kortant o Perawnay darbárá átk. ");
INSERT INTO bcc_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Perawná gón Issopá gwasht: “Man wábé distag o kass eshiá máná korta nakant, bale man tai bárawá eshkotag ke agan kasé gón taw wati wábay kessahá bekant, taw mánái korta kanay.” ");
INSERT INTO bcc_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Issopá gwasht: “É cha mani was o wáká dar ent, bale Hodá tawe Perawná hayrén passawé dáta kant.” ");
INSERT INTO bcc_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Gorhá Perawná gón Issopá gwasht: “Man wáb dist ke Nillay kawray kashá óshtátagán. ");
INSERT INTO bcc_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Hamé wahdá hapt pazzór o dhawldárén gók cha kawrá dar átk o kásháni tahá charagá laggetant. ");
INSERT INTO bcc_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Cha áyán o rand dega hapt gók dar átk ke nezór o baddhawl o lágar atant. Sajjahén Mesray molká man choshén baddhawlén gók hechbar nadistagat. ");
INSERT INTO bcc_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Lágar o baddhawlén gókán pésari haptén pazzórén gók wártant. ");
INSERT INTO bcc_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Bale áyáni waragá rand ham é gók angat pésari dhawlá anchó baddhawl atant ke nagwashay á gókesh wártagant. Man cha wábá ágah bután. ");
INSERT INTO bcc_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Padá ke wáb kaptán, gendán ke dánay hapt zandhén o sharrén hóshag yakk tháléay sará rodagá ent. ");
INSERT INTO bcc_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Cha áyán o rand, dega hapt hóshag rost. É hóshag nezór o lágar atant o cha ródarátká kasshókén lewárá gimmoréntagatant. ");
INSERT INTO bcc_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Lágarén hóshagán haptén sharrén hóshag wártant. Man gón jádugerán kessah kort, bale cha áyán kassá é wáb máná kort nakort.” ");
INSERT INTO bcc_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Gorhá Issopá gón Perawná gwasht: “Tawe Perawnay doén wáb yakk ant. Hamá kár ke Hodá démterá kanti, pa tawe Perawná paddari kortag. ");
INSERT INTO bcc_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Haptén sharrén gók hapt sál ant o dánay haptén sharrén hóshag ham hapt sál ant. Doén wáb yakk ant. ");
INSERT INTO bcc_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Hamá haptén lágar o baddhawlén gók ke cha áyán o rand dar átkant, hapt sál ant o hamé dhawlá haptén hórk o háligén hóshag ke cha ródarátká kasshókén lewárá gimmoréntagatant, hapt sálay dhokkál ant. ");
INSERT INTO bcc_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Man gón tawe Perawná gwasht, hamá kár ke Hodá démterá kanti, pa tawe Perawná paddari kortag. ");
INSERT INTO bcc_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Nun sajjahén Mesrá hapt sálá mazanén sarsabzi o peráwánié bit, ");
INSERT INTO bcc_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","bale cha eshiá rand, hapt sálá dhokkála bit o é dhokkál Mesrá anchó tabáh o wayrána kant ke mardom molkay sajjahén sarsabzi o peráwániá shamóshant. ");
INSERT INTO bcc_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Molkay sarsabzi shamóshaga bit, chéá ke é dhokkál ke randá kayt, sakk grána bit. ");
INSERT INTO bcc_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","É wáb paméshká tawe Perawnay sará do randá átkag ke Hodáyá pakkáiá paysalah kortag o Hodá é kárá hamé zuttána kant. ");
INSERT INTO bcc_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Nun tawe Perawn aglmand o dánáén mardé dar géj o Mesray molkay sajjahén kárán hamáiay dastá beday. ");
INSERT INTO bcc_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Tawe Perawn báyad ent molká anchén kármaster bedáray ke sarsabziay haptén sáláni wahdá kesháráni pancheká begerant. ");
INSERT INTO bcc_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","É kármaster sarsarbziay áyókén sálán ward o warák mocch bekanant o Perawnay chérdastiá, shahrán pa waragá dán ambár bekanant. ");
INSERT INTO bcc_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","É ward o warák pa molká ambár kanag bebant o hamá haptén sálán ke Mesrá dhokkála kapit, kármarz kanag bebant ke molk cha dhokkálá tabáh mabit.” ");
INSERT INTO bcc_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","É habar, Perawn o Perawnay sajjahén apsaráni chammán sharrén habaré at. ");
INSERT INTO bcc_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Perawná gón wati hezmatkárán gwasht: “Dega choshén mardomé dara kapit ke é marday paymá Hodáay Ruh áiá mán bebit?” ");
INSERT INTO bcc_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Démi gón Issopá kort o gwashti: “Hodáyá é sajjahén chizz ke pa taw paddar kortagant, gorhá bezán tai paymén aglmand o dáná dega nést. ");
INSERT INTO bcc_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Man tará wati lógay mastera kanán o mani sajjahén mardom tai parmánay pábanda bant o tahná mane bádsháh cha taw mastera bán.” ");
INSERT INTO bcc_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Nun Perawná gón Issopá gwasht: “Bechár, taw cha mani némagá sajjahén Mesray molkay master ay.” ");
INSERT INTO bcc_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Perawná wati mohray mondrikk cha dastá kasshet o Issopay dastá dát, sharrén lilomay póshák o sohray háré gwarái dát. ");
INSERT INTO bcc_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Molkay náebay arrábahá swári kort. Mardomán jár jat ke Issopay démá kóndhán bekapét. Perawná Issop sajjahén Mesray master kort. ");
INSERT INTO bcc_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Perawná gón Issopá gwasht: “Man Perawn án. Bé tai razáyá sajjahén Mesray molká kass wati dast o pádé sorénta nakant.” ");
INSERT INTO bcc_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Perawná Issop Sopnát-Panéhá námént o gón Unay shahray dini péshwá Putipéráay jenekk Asenátá sur dát. Nun Issop sajjahén Mesrá gasht. ");
INSERT INTO bcc_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Wahdé Issopá Mesray bádsháh Perawnay hezmat bendát kort, omri si sál at. Issop cha Perawnay darbárá pad átk o sajjahén Mesrá gasht. ");
INSERT INTO bcc_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Sarsabziay haptén sálán zeminá mazanén bar o samaré dát. ");
INSERT INTO bcc_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Sarsabziay haptén sálán ke Mesray molká ward o warák báz at, Issopá shahráni ambár porr kortant. Har shahray kash o kerray dhagáráni bar o samari hamá shahrá ambár kort. ");
INSERT INTO bcc_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Issopá sakk báz dán ambár kort, daryáay rékáni kaddá. Dán anchó báz atant ke esháni hesáb kanagi band kort, chéá ke cha hesábá dhann atant. ");
INSERT INTO bcc_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Cha dhokkálay sálán o pésar Issopá do mardénchokk but. Esháni mát Asenát, Unay shahray dini péshwá Putipéráay jenekk at. ");
INSERT INTO bcc_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Issopá wati awali chokkay nám Manasi kort, gwashti: “Hodáyá maná cha sajjahén sakki o sórián o cha petay lógay sajjahén tránagán ázát kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Domi chokkay námi Epráém kort, gwashti: “Mani sakki o sóriáni molká, Hodáyá maná porsamar kortag.” ");
INSERT INTO bcc_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Gorhá hamá paymá ke Issopá gwashtagat, Mesray molkay sarsabziay haptén sál halás butant o dhokkálay haptén sál bongéj butant. Á dega sajjahén molkán dhokkál but, bale sarjamén Mesrá warák hastat. ");
INSERT INTO bcc_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Gorhá sajjahén Mesr ke shodig but, mardomán Perawnay kerrá pa waráká peryát kort. Perawná gón sajjahén Mesrián gwasht: “Issopay kerrá berawét o á harché ke gwashit, hamá dhawl bekanét.” ");
INSERT INTO bcc_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Sarjamén molk ke dhokkálá gept, Issopá ambáráni dap pach kort o Mesriáni kerrá dáni bahá kort ke sajjahén Mesrá mazanén dhokkálé kaptagat. ");
INSERT INTO bcc_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Sarjamén donyá pa dánay geragá Mesrá Issopay kerrá átk, chéá ke sajjahén donyáyá gránén dhokkálé kaptagat. ");
INSERT INTO bcc_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Wahdé Ákubá dist ke Mesrá dán hast, gón wati chokkán gwashti: “Chéá neshtag o yakdomiá cháragá ét? ");
INSERT INTO bcc_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Man eshkotag ke Mesrá dána rasit. Berawét o dán begerét ke zendag bemánén, shodá mamerén.” ");
INSERT INTO bcc_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Gorhá Issopay dah brát Mesrá dánay geragá shot. ");
INSERT INTO bcc_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ákubá Issopay brát Benyámin gón á dega brátán dém nadát, gwashti chó mabit ke táwáné berasiti. ");
INSERT INTO bcc_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","É paymá Esráilay chokk hamá mardománi rombá gón atant ke dánay geragá átkagatant, chéá ke Kanhánay molká dhokkál at. ");
INSERT INTO bcc_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Nun Issop molkay wáli at. É Issop at ke molkay sajjahén mardománi kerrá gandomi bahá kort. Gorhá Issopay brát átkant o áiay démá pa adab saresh jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Wahdé Issopá wati brát distant, pajjáhi áwortant, bale áyáni démá záheri nakort. Gón áyán pa trondi habari kort o josti kort: “Shomá cha kojá átkagét?” Áyán passaw dát: “Cha Kanhánay molká, dánay zuragá átkagén.” ");
INSERT INTO bcc_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Issopá brát pajjáh áwortant, bale áyán Issop pajjáh nayáwort. ");
INSERT INTO bcc_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Issop wati wábáni tránagá kapt ke brátáni bárawá distagatanti. Issopá gón áyán gwasht: “Shomá jásus o chárig ét. Shomá edá átkagét ke bezánét may molkay kojám jágahá páspáni o hepázat nezórter ent.” ");
INSERT INTO bcc_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Áyán gwasht: “Enna, mani wájah! Tai kaster ward o warákay geragá átkagant. ");
INSERT INTO bcc_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Má sajjahén yakkén petay chokk én, rást o tachkén mardom én, tai pádáni chéray hák én, jásus o chárig naén.” ");
INSERT INTO bcc_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Issopá gwasht: “Enna! Shomá edá átkagét ke bezánét may molkay kojám jágahá páspáni o hepázat nezórter ent.” ");
INSERT INTO bcc_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bale áyán gwasht: “Tai kaster yakkén petay chokk ant o may pet Kanháná jahmenend ent. Má dwázdah brát butagén. Kasterén brát annun petay kerrá ent. Á dega brát nun néstent.” ");
INSERT INTO bcc_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Issopá gwasht: “Anchó ke man shomárá gwasht, shomá jásus o chárig ét. ");
INSERT INTO bcc_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Shomárá é paymá chakkásén: Tánke shomay kasterén brát edá nayayt, maná Perawnay saray sawgend ent ke shomá cha é jágahá shota nakanét. ");
INSERT INTO bcc_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Cha wati brátán yakké ráh dayét, belli shomay brátá kárit. Shomá á dega brát hamedá bandijáhá mánét. Shomay habar chárag o chakkásaga bant ke bárén rásta gwashét yá na. Agan shomá rást nagwasht, maná Perawnay saray sawgend ent ke shomá jásus o chárig ét.” ");
INSERT INTO bcc_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Issopá tán say róchá sajjahén brát bandijáhá band kanáéntant. ");
INSERT INTO bcc_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sayomi róchá gón áyán gwashti: “Hamá paymá ke man shomárá gwashán, hamá paym bekanét, gorhá zendaga mánét, parchá ke maná cha Hodáyá torsit. ");
INSERT INTO bcc_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Agan shomá rást o tachkén mardom ét, cha shomá brátán yakké bandijáhá benendit o á dega berawant o pa wati lógay gozhnagén mardomán dán bebarant, ");
INSERT INTO bcc_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","bale wati kasterén brátá mani kerrá byárét ke shomay habar rást bebant o cha marká berakkét.” Áyán anchosh kort o ");
INSERT INTO bcc_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","gón yakdegará gwashtesh: “Aslá márá brátay hakkán geptag. Má dist ke á chinchok paréshán at, pa wati jánay rakkénagá may kerrá dazbandi o peryáti kort, bale má áiay habar gósh nadáshtant, paméshká é mosibat may sará kaptag.” ");
INSERT INTO bcc_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubená gwasht: “Man wa shomárá gwasht ke hecchi makanét, bale shomá gósh nadásht. Nun márá áiay hónay hesáb dayagi ent.” ");
INSERT INTO bcc_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Brátán nazánt ke Issop may habarán sarpad bayagá ent, chéá ke Issop tarjomah kanókéay komakká gón áyán habará at. ");
INSERT INTO bcc_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Issopá wati dém ángor kort o gréti. Padá démi tarrént o gón áyán habari kort. Gorhá cha brátáni nyámá Shamuni gept o áyáni chammáni démá dast o pádi bandáéntant. ");
INSERT INTO bcc_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nun Issopá hokm dát ke brátáni gónián cha dáná porr kanét, har yakkéay nograhán hamáiay jenday góniá mán kanét o saparay tóshagesh ham bedayét. É kár ke pa áyán kanag butant, ");
INSERT INTO bcc_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","nun áyán wati dán harán laddhetant o cha ódá ráh geptant. ");
INSERT INTO bcc_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Ráhá shapá geptant o yakk jágahéá menzelesh kort. Wahdé cha áyán yakkéá wati góniay dap pach kort ke pa wati hará káh o kadimé bekasshit, disti ke mani nograh góniay dap dapá ér ant. ");
INSERT INTO bcc_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Gón wati brátán gwashti: “Mani nograhesh nazortagant, esh ant mani góniay tahá ant.” Torsé áyáni delá kapt. Démesh gón yakdegará kort o drahán o larzáná gwashtesh: “É che káré ke Hodáyá gón má kortag?” ");
INSERT INTO bcc_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Wahdé á wati pet Ákubay kerrá Kanhánay molká átkant, wati sajjahén kessah o sargwastesh áwortant. Gwashtesh: ");
INSERT INTO bcc_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Hamá mard ke molkay master ent, áiá gón má pa trondi habar kort o gwashti: ‘Shomá é molká jásusi kanagá átkagét.’ ");
INSERT INTO bcc_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Bale má gón áiá gwasht: ‘Má rást o tachkén mardom én, chárig o jásus naén. ");
INSERT INTO bcc_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Má yakkén petay chokk én. Dwázdah brát butagén. Yakk bráté nun néstent o kasterén brát annun Kanháná petay kerrá ent.’ ");
INSERT INTO bcc_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Gorhá molkay masterá gwasht: ‘Man hamá wahdá zánán shomá rást o tachkén mardom ét ke shomá yakk bráté hamedá gón man bellét o á dega berawét o pa wati lógay gozhnagén mardomán dán bebarét o ");
INSERT INTO bcc_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","wati kasterén brátá mani kerrá byárét. Gorhá mana zánán ke shomá chárig o jásus naét o tachk o rástén mardom ét. Randá man shomay brátá shomárá dayán o shomá é molká sawdágeri o bápár korta kanét.’” ");
INSERT INTO bcc_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Wahdé á wati gónián hálig kanagá atant, har yakkéay góniá áiay nograháni turag mán at. Wahdé áyán o áyáni petá nograhay turag distant, torsetesh. ");
INSERT INTO bcc_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Áyáni pet Ákubá gwasht: “Shomá maná béawlád kanagá ét. Issop ham néstent o Shamun ham. Nun shomá Benyáminá pach geraga lóthét. É sajjahén kahr mani sará kapagá ant.” ");
INSERT INTO bcc_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubená gón petá gwasht: “Agan man tai chokk padá pa taw nayáwort, mani doén chokkán bekosh. Benyáminá maná beday, man padá pa taw káráni.” ");
INSERT INTO bcc_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Bale Ákubá gwasht: “Mani chokk gón shomá nayayt gón. Áiay brát mortag o bass jendi pasht kaptag. Agan shomay é sapará táwáné berasiti, man cha gamána merán o mani pirén saray hón shomay gardená bit.” ");
INSERT INTO bcc_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Molk sakk dhokkál at o ");
INSERT INTO bcc_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","wahdé áyán cha Mesrá áwortagén dán wárt o halás kortant, petá gwasht: “Padá berawét o pa má kammé ward o warák begerét.” ");
INSERT INTO bcc_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Bale Yahudáyá gón áiá gwasht: “Á mardá márá pa trondi habardár kort o gwasht: ‘Agan shomay brát gón shomá gón nabut, mani démá makapét.’ ");
INSERT INTO bcc_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Agan taw may brátá gón má ráh bedayay, má rawén o pa taw ward o waráka gerén, ");
INSERT INTO bcc_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","bale agan taw áiá gón makanay, má narawén. Chéá ke á mardá gwasht: ‘Agan shomay brát gón shomá gón nabut, mani démá makapét.’” ");
INSERT INTO bcc_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Esráilá jost kort: “Shomá chéá á mard hál dát ke márá dega bráté hast o é parésháni mani sará áwort?” ");
INSERT INTO bcc_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Passawesh dát: “Á mardá mayg o may hándánay bárawá har chizzay jost kort: ‘Shomay pet angat zendag ent? Shomárá dega brát ham hast?’ Má áiay jostáni passaw dátant. Má chón bezántén ke á gwashit: ‘Wati brátá edá byárét’?” ");
INSERT INTO bcc_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Gorhá Yahudáyá gón wati pet Esráilá gwasht: “Bachakká gón man hamráh kan. Má hamé damáná páda káén o rahádaga bén ke má o taw o may chokk zendag bemánén o mamerén. ");
INSERT INTO bcc_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Man wat áiay salámatiay zemmahá zurán. Áiá cha mani dastá belóth. Agan man tai chokk padá nayáwort o pa taw sar nakort, tán zendag án tai gonahkár án. ");
INSERT INTO bcc_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Agan má inchok mahtal mabuténén, tán é wahdi do randá shotag o átkagatén.” ");
INSERT INTO bcc_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Gorhá áyáni pet Esráilá gwasht: “Agan allami ent, gorhá chosh kanét ke cha molkay sharterén chizzán lahtén wati pélekán kanét o pa á mardá théki barét gón. Kammé bám, kammé bénag, sosorr o pestah o bádám o washbó barét gón. ");
INSERT INTO bcc_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Do sari nograh barét gón ke shomárá hamá nograh padá dayagi ant ke shomay góniáni dap dapá ér kanag butagatant. Balkén pa radi chó butag. ");
INSERT INTO bcc_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Wati brátá ham barét gón. Tachká á marday kerrá berawét. ");
INSERT INTO bcc_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Porwákén Hodá á mardá pa shomá rahmdel kanát ke shomay á dega brátá o Benyáminá gón shomá áyagá bellit. Bale agan man chokk báhéntant wa mani baht o nasib.” ");
INSERT INTO bcc_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Gorhá mardán théki o do sari nograh o Benyámin zort o ráh geptant. Mesrá ke rasetant, Issopay darbárá átk o óshtátant. ");
INSERT INTO bcc_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Wahdé Issopá dist ke Benyámin gón ent, wati lógay péshkári gwasht: “É mardomán mani lógá byár. Pas o kósh kan o waragé tayár kan ke é mardom sobáregá mani kerrá ant.” ");
INSERT INTO bcc_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Péshkárá hamá paym kort ke Issopá gwasht. Mardomi Issopay lógá áwortant. ");
INSERT INTO bcc_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Wahdé mardom Issopay lógá árag butant, tors o larz atant. Gwashtesh: “Márá hamá nograháni sawabá edá áwortagesh ke pésari randá may gónián mán kanag butagatant. Nun é mard may sará orosh kanag o márá zérdast kanaga lóthit ke may jendá golám bekant o harán ham bebárt.” ");
INSERT INTO bcc_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Gorhá á Issopay péshkáray kerrá shotant o lógay darwázagay dapá gón áiá habaresh kort. ");
INSERT INTO bcc_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Gwashtesh: “Wájah! Awali randá ke má edá pa warákay geragá átkén, ");
INSERT INTO bcc_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","per tarragá má shapá yakk jágahéá dásht. Má wati bár ke bótkant, disten ke cha má harkasay nograh sarjamiá áiay jenday góniay dap dapá ér ant. Nun má é nograh padá áwortagant gón. ");
INSERT INTO bcc_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Má pa warákay geragá dega nograh ham áwortag gón. Nazánén bárén kayá é nograh padá may gónián mán kortagant.” ");
INSERT INTO bcc_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Péshkárá gwasht: “Parwáh nést. Matorsét. Shomayg o shomay petay Hodáyá é ganj gónián mán kortag. Shomay nograh maná rasetagant.” Nun Shamuni áyáni kerrá áwort. ");
INSERT INTO bcc_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Péshkárá á Issopay lógá bortant, ápi dátant ke wati pádán beshódant o pa áyáni harán káh o kadimay tayárii ham kort. ");
INSERT INTO bcc_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tán Issopay áyagá, némróchay wahdá, áyán wati théki tayár kortant, chéá ke eshkotagatesh ke má sobáregá hamedá én. ");
INSERT INTO bcc_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Issop ke lógá átk, áyán wati áwortagén théki dátant o Issopay démá saresh pa adab jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Issopá áyáni hál jost kort o gwashti: “Shomay pirén pet ke shomá áiay bárawá gón man habar kortagat, chón ent? Angat hast o salámat ent?” ");
INSERT INTO bcc_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Áyán passaw dát: “Tai hezmatkár, may pet angat hast o salámat ent.” Áyán Issopay démá pa adab sar jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Issopá sar chest kort, chammi wati hakkigén brát Benyáminá kaptant. Josti kort: “É shomay hamá kasterén brát ent ke shomá nám geptagat?” Issopá gón Benyáminá gwasht: “Hodá pa taw mehrabán bát, mani chokk!” ");
INSERT INTO bcc_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Gón brátay gendagá Issopá wati del dásht nakort. Zutt zuttá pád átk o pa gréwagá jágahéay shóházá but. Gorhá wati jenday kóthiá shot o hamódá gréti. ");
INSERT INTO bcc_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Randá chammi shoshtant o dar átk. Deli dásht o gwashti: “Waragán byárét.” ");
INSERT INTO bcc_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Pa Issopá jetá parzónagé pachesh kort o pa áiay brátán jetá. Hamá Mesri ke ódá waragá atant, áyáni parzónag ham jetá at, chéá ke Mesrián gón Ebránián hór waraga nawárt. Áyáni nezzá é sakkén bazzhnákén káré at. ");
INSERT INTO bcc_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Brát, Issopay démá omray hesábá nádénag butagatant, master masteréná beger tán kaster kasteréná. Awali chokk wati pédáeshi hakkay hesábá o kasterén, wati kasteriay hesábá. Paméshká brát pa hayráni yakdomiá cháragá atant. ");
INSERT INTO bcc_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Wahdé cha Issopay parzónagá áyáni bahrá dayagá atant, Benyáminá cha á degarán panch sari géshter raset. Gón Issopá sharábesh wárt o wasshén wahdé gwázéntesh. ");
INSERT INTO bcc_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Nun Issopá wati lógay péshkár chó hokm dát: “Esháni gónián cha waráká porr kanét. Haminchok ke borta kanant, bedayétesh o har yakkéay nograhán áiay góniay dap dapá ér kanét. ");
INSERT INTO bcc_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Mani pyálahá, mani nograhén pyálahá kasterénay góniay dap dapá ér kanét o áiay dánáni nograhán ham.” Hamá dhawlá ke Issopá gwasht, péshkárá hamá dhawl kort. ");
INSERT INTO bcc_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Sohb ke but, áesh roksat kortant. Mardán har zortant o ráh geptant. ");
INSERT INTO bcc_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Angat cha shahrá dur nashotagatant ke Issopá gón péshkárá gwasht: “Zutt kan o randáesh kap. Wahdé raséntant, begwashesh: ‘Shomá nékiay badalá chéá badi kort? ");
INSERT INTO bcc_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","É hamá pyalah naent ke mani wájah eshiay tahá sharába wárt? O pa pál janagá ham káramarzia kant? É badén káré ke shomá kortag.’” ");
INSERT INTO bcc_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Wahdé péshkár áyáni kerrá sar but, hamé habari kortant. ");
INSERT INTO bcc_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bale áyán gwasht: “Wájah! Chéá choshén habara kanay? Tai kaster hechbar choshén káré korta nakanant. ");
INSERT INTO bcc_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Má wa hamá nograh ke wati góniáni dapá distant, áen ham cha Kanhánay molká padá áwortant. Má chón cha tai wájahay lógá nograh o teláha dozzén? ");
INSERT INTO bcc_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Wájah! Cha má harkasay kerrá dozziay mál dar átk, áiay sezá mark ent o má é degaráni sezá hamesh ent ke tai goláma bén.” ");
INSERT INTO bcc_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Péshkárá gwasht: “Sharr ent. Harché ke shomá gwashét, bale harkasay kerrá ke é dar kapt, á mani goláma bit o é dega bémayára bét.” ");
INSERT INTO bcc_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Har yakkéá eshtáp eshtápá wati góni zeminá ér kort o bótk o ");
INSERT INTO bcc_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","péshkár patthagá lagget. Cha masteréná bongéji kort o kasteréná halás. Pyálah cha Benyáminay góniá dar kapt. ");
INSERT INTO bcc_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Brátán ke dist, wati godesh dertant. Padá wati báresh harán laddhetant o shahrá per tarretant. ");
INSERT INTO bcc_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Wahdé Yahudá o áiay brát átkant, Issop angat lógá at. Á Issopay pádán kaptant. ");
INSERT INTO bcc_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Issopá gón áyán gwasht: “É che káré shomá kortag? Shomá nazánét ke mani paymén mardomé pál jata kant o chizzán dar gétka kant?” ");
INSERT INTO bcc_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yahudáyá gwasht: “Mani wájah! Má gón taw ché gwashta kanén? Ché begwashén? Che paymá wati bémayáriá pésh bedárén? Hodáyá tai kasteráni radén kár páshk kortag. Mani wájah! Nun má tai golám én. May jend ham o hamá mardom ham ke pyálah áiay kerrá dar kaptag.” ");
INSERT INTO bcc_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Bale Issopá gwasht: “Man hechbar choshén káré nakanán. Éwaká hamá mardom mani goláma bit ke pyalah áiay kerrá dar kaptag. Shomá á dega mardom pa salámati wati petay kerrá berawét.” ");
INSERT INTO bcc_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Gorhá Yahudá nazzikká átk o gwashti: “Oo mani wájah! Bell tai kaster gón tawe wájahá habaré kant. Wati kasteray sará zahr mager ke taw Perawnay barábar ay. ");
INSERT INTO bcc_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Mani wájah! Taw cha wati kasterán jost kort: ‘Shomárá pet yá brát hast?’ ");
INSERT INTO bcc_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Má passaw dát: ‘Márá pirén peté hast o kasterén bráté ke petay piriay róchán pédá butag. Á brátay hakkigén brát mortag o cha wati mátá yakkén chokk ent ke mantag o pet áiá sakk dósta dárit.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Gorhá taw gón wati kasterán gwasht: ‘Áiá mani kerrá byárét ke gón wati jenday chammán begendáni.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Má gón tawe wájahá gwasht: ‘Bachakk wati petá yalah dáta nakant. Agan petá yalah bedant, petia merit.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Bale taw gón wati kasterán gwasht: ‘Agan shomá wati brátá mayárét gón, mani démá makapét.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Wahdé má mani petay kerrá, bezán tai hezmatkáray kerrá per tarretén, tai habaren gón áiá kortant, mani wájah! ");
INSERT INTO bcc_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Gorhá may petá gwasht: ‘Padá berawét o pa má kammé ward o warák begerét o byárét.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Bale má gwasht: ‘Má padá shota nakanén. Hamá shartá rawén ke may kasterén brát gón má gón bebit. Má tán hamá wahdá á marday démá kapta nakanén ke may kasterén brát gón mabit.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mani petá, bezán tai hezmatkárá gón má gwasht: ‘Shomá zánét ke mani lógbánoká pa man do mardénchokk áwort. ");
INSERT INTO bcc_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Cha áyán yakkéá maná yalah dát o man gwasht: “Allamá rastaréá wártag.” Cha á wahdá tán annun wati chokkon nadistag. ");
INSERT INTO bcc_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Agan é chokká ham cha mana barét o eshiá táwáné berasit, man cha gamána merán o mani pirén saray hón shomay gardená bit.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Agan chokk gón má gón mabit o man wati petay kerrá, bezán tai hezmatkáray kerrá per betarrán o mani pet begendit ke é gón naent, gorhá may pet, tai hezmatkára merit ke sáhi gón hameshiá bastag. O áiay pirén saray hón tai kasteráni gardená bit. ");
INSERT INTO bcc_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Petay kerrá tai kasterá é bachakkay salámatiay zemmah zortag. Man gón petá gwasht: ‘Mani pet! Agan man tai chokk padá pa taw nayáwort, tán zendag án tai gonahkár án.’ ");
INSERT INTO bcc_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Gorhá, oo mani wájah! Bell ke é bachakkay badalá tai kaster edá bemánit o tai golámiá bekant o é bachakk gón wati brátán per betarrit. ");
INSERT INTO bcc_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Man chón wati petay kerrá bé eshiá shota kanán? Man á róchá magendátán ke petay sará choshén mosibaté byayt.” ");
INSERT INTO bcc_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Issopá óshtátagén mardománi démá del dásht nakort o kukkári kort: “Sajjahén mardomán cha mani démá barét.” Wahdé Issopá brát hál dátant ke man Issop án, áiay kerrá dega kass néstat. ");
INSERT INTO bcc_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Áiá anchén borzén tawáréá grét ke Mesrián eshkot o Perawnay lógay mardom ham sahig butant. ");
INSERT INTO bcc_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Issopá gón brátán gwasht: “Man Issop án. Mani pet angat hast o salámat ent?” Brát Issopay démá torsagá atant o hecch passawesh dát nakort. ");
INSERT INTO bcc_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Gorhá gón brátán gwashti: “Mani nazzikterá byáét.” Wahdé á nazzikká átkant, Issopá gwasht: “Man shomay brát Issop án. Man hamá mardom án ke shomá bahá kort o sari Mesrá kapt. ");
INSERT INTO bcc_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Bale nun paréshán mabét o watá mayárig makanét ke shomá chéá maná edá bahá kort. Hodáyá pa sáháni rakkénagá maná cha shomá pésar edá ráh dát. ");
INSERT INTO bcc_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Do sál ent ke molká dhokkál ent. Áyókén panch sálá ham hecch dhagáré na nangár kanag o keshaga bit o na ronag o moshag, ");
INSERT INTO bcc_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","bale Hodáyá cha shomá pésar maná edá ráh dát ke shomárá zendag bedárit o sarjamiá berakkénit ke shomay nasl cha zeminá gár mabit. ");
INSERT INTO bcc_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Paméshká mani edá ráh dayók shomá naatét, Hodá at. Hodáyá maná pa Perawná peté, pa áiay sajjahén lógá masteré o pa sarjamén Mesray molká hákemé kort. ");
INSERT INTO bcc_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Nun zutt kanét o mani petay kerrá berawét. Gón áiá begwashét: ‘Tai chokk Issopa gwashit: “Hodáyá maná sajjahén Mesray wájah kortag. Mahtal mabay o mani kerrá byá. ");
INSERT INTO bcc_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Gón wati chokk o nomásag o ramag o górom o wati sajjahén mál o hastiá, Góshenay damagá jahmenend bay ke gón man nazzikk bebay. ");
INSERT INTO bcc_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Man tai har chizzay zemmah zortag ke é dhokkál tán panch sálá angata mánit. Chó mabit ke taw wár o bazzag bebay, tai jend o tai hándán o tai sajjahén mardom janjál bebant.” ");
INSERT INTO bcc_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Shomá wat gendagá ét o mani brát Benyámin ham gendagá ent ke é mani jend ent ke gón shomá habará ent. ");
INSERT INTO bcc_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","É mazani o sharap ke maná edá Mesrá rasetag o hamá sajjahén chizz ke shomá distagant, berawét o mani petá hál bedayét o áiay jendá zutt byárét.’” ");
INSERT INTO bcc_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Gorhá Issopá wati brát Benyámin goláésh kort o gréti. Benyáminá ham Issop goláésh kort o gréti. ");
INSERT INTO bcc_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Issopá wati sajjahén brát ambáz kort o chokketant o gréti. Nun áiay brát gón áiá habará laggetant. ");
INSERT INTO bcc_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Wahdé Perawnay lógá é hál raset ke Issopay brát átkagant, Perawn o áiay hezmatkár gal butant. ");
INSERT INTO bcc_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Perawná gón Issopá gwasht: “Wati brátán begwash: ‘Chó kanét ke bárán wati ólákán beladdhét o Kanhánay molká berawét o ");
INSERT INTO bcc_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","wati petá bezurét o laddh o lóg mani kerrá byáét. Man Mesray sharterén zeminá shomárá dayán o shomá zeminay sharterén bar o samarána warét.’ ");
INSERT INTO bcc_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Pa taw hokm esh ent ke wati brátán begwash: ‘Chó kanét ke pa wat cha Mesrá aspgárhi bezurét gón, pa wati jan o chokkán. Wati petá bezurét o byáét. ");
INSERT INTO bcc_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Agan shomay chizzé pasht kapt, paréshán mabét, chéá ke sajjahén Mesray sharterén zemin shomayga bit.’” ");
INSERT INTO bcc_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Gorhá Esráilay chokkán anchosh kort. Hamá paymá ke Perawná hokm dátagat, Issopá wati brátáná aspgárhi o tóshag dát. ");
INSERT INTO bcc_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Áiá har yakkéárá jórhié god dát, bale Benyáminá say sad nograh o panch jórhi godi dát. ");
INSERT INTO bcc_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Pa wati petá é chizzi ráh dátant: dah lág ke cha Mesray sharterén chizzán laddhag butagat o dah mádyán ke pa petay sapará dán o warák o tóshag laddhag butagat. ");
INSERT INTO bcc_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Padá wati bráti rahádag kortant. Brát ke dar kapagá atant, gón áyán gwashti: “Ráhá arh o korh makanét.” ");
INSERT INTO bcc_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Gorhá á cha Mesrá dar átk o wati pet Ákubay kerrá Kanhánay molká átkant. ");
INSERT INTO bcc_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Gón wati petá gwashtesh: “Issop angat zendag ent. Eshiá bell, sajjahén Mesray hákem ent.” Ákub hoshk o hayrán but. Áyáni sará báwari nabut. ");
INSERT INTO bcc_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Bale wahdé áyán Issopay gwashtagén habar gón petá kortant o Ákubá hamá aspgárhi distant ke Issopá pa áiay áragá ráh dátagatant, arwáhi tázag but. ");
INSERT INTO bcc_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Esráilá gwasht: “Bass, nun maná báwar ent. Mani chokk Issop angat zendag ent. Cha ed o pésar ke bemerán, rawán ke Issopá begendán.” ");
INSERT INTO bcc_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Esráil gón wati sajjahén mál o hastiá ráh gept. Wahdé Bérshébahá átk o raset, pa wati pet Esákay Hodáyá korbánigi nadr kortant. ");
INSERT INTO bcc_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Hodáyá shapay elháméay tahá gón Esráilá habar kort. Gwashti: “Ákub! Oo Ákub!” Áiá passaw dát: “Ji!” ");
INSERT INTO bcc_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Hodáyá gwasht: “Man Hodá án, tai petay Hodá. Mesray rawagá mators ke man ódá cha taw mazanén kawmé addha kanán. ");
INSERT INTO bcc_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Man wat gón taw Mesrá káyán o allam tará padá kárán. O Issopay jend tará dast o chamma kant.” ");
INSERT INTO bcc_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Gorhá Ákub cha Bérshébahá dar kapt. Esráilay chokkán wati pet Ákub o kasánén chokk o wati janén hamá aspgárhián nádéntant ke Perawná pa Ákubay áragá ráh dátagatant. ");
INSERT INTO bcc_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Ákubá wati ramag o górom o hamá mál o maddhi ke Kanháná mocch kortagatant, zortant o gón wati sajjahén óbádagán Mesrá shot. ");
INSERT INTO bcc_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Ákubá wati bacch o jenekk o nomásag, bezán wati sajjahén óbádag Mesrá bortant gón. ");
INSERT INTO bcc_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Esráil, bezán Ákub ke gón wati óbádagán Mesrá shot, áiay mardénchokkáni nám esh ant: Ruben, Ákubay awali chokk at. ");
INSERT INTO bcc_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Rubenay mardénchokk Hanuk o Pallu o Hesrun o Karmi atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Shamunay mardénchokk Yamuél o Yámin o Uhad o Yákin o Sóhar o Shául atant. Sháulay mát Kanhánié at. ");
INSERT INTO bcc_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Láwiay mardénchokk Gershón o Kohát o Merári atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yahudáay mardénchokk Ér o Ónán o Shélá o Páres o Zárah atant. Bale Ér o Ónán Kanháná mortagatant. Páresay mardénchokk Hesrun o Hámul atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Issákáray mardénchokk Tulá o Puá o Yáshub o Shemrun atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zebulunay mardénchokk Sered o Ilun o Yahlél atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ákub o Lyáhay mardénchokk hamesh atant ke Paddán-Arámay molká pédá butagatant. Ákub o Lyáhay jenekk Dinah ham hamódá pédá butagat. Ákubay é bacch o jenekk sarjamiá si o say atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Jáday mardénchokk Sepyun o Haggi o Shuni o Esbun o Eri o Aródi o Aréli atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ásheray mardénchokk Yamná o Yashwá o Yashwi o Beryá atant o esháni gohár Serah at. Beryáay mardénchokk Heber o Malkiél atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Ákub o Zelpahay mardénchokk hamesh atant ke sarjamiá shánzdah atant. Zelpah hamá móled at ke Lábáná wati jenekk Lyáhárá dátagat. ");
INSERT INTO bcc_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ákub o áiay jan Ráhilay mardénchokk Issop o Benyámin atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Issopay chokk Manasi o Epráém Mesray molká cha Asenátá pédá butant. Asenát Putipéráay jenekk at o Putipérá Unay shahray dini péshwá at. ");
INSERT INTO bcc_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benyáminay mardénchokk Bélá o Báker o Ashbil o Girá o Nahmán o Éhi o Rosh o Moppim o Hoppim o Ard atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ákub o Ráhilay mardénchokk sarjamiá chárdah atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Dánay mardénchokk Hushim at. ");
INSERT INTO bcc_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Naptáliay mardénchokk Yahsayl o Gani o Yáser o Shillem atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Ákub o Bellahay chokk hamesh atant. É sarjamiá hapt atant. Bellah hamá móled at ke Lábáná wati jenekk Ráhilárá dátagat. ");
INSERT INTO bcc_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","É sajjahén mardom ke gón Ákubá Mesrá shotant o áiay jenday óbádag atant, abéd cha áiay neshárán shast o shash atant. ");
INSERT INTO bcc_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Issopay mardénchokk ke Mesrá pédá butagatant, do atant. Ákub ke Mesrá átkagat, áiay hándán sarjamiá haptád mardom at. ");
INSERT INTO bcc_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ákubá cha wat o pésar Yahudá Issopay kerrá ráh dát ke Góshenay ráhá jost bekant. Gorhá Ákub gón wati mardomán Góshenay damagá sar but. ");
INSERT INTO bcc_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Issopá wati arrábah tayár kanáént o Góshená, wati pet Esráilay cháragá shot. Anchó ke Issop petay kerrá sar but, peti goláésh kort o tán dérá gréti. ");
INSERT INTO bcc_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Esráilá gón Issopá gwasht: “Nun man pa meragá tayár án, chéá ke gón wati jenday chammán diston ke taw zendag ay.” ");
INSERT INTO bcc_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Issopá gón wati brátán o gón wati petay lógay mardomán gwasht: “Mana rawán o Perawná hála dayán. Gwasháni ke mani brát o mani petay lógay mardom ke Kanhánay molká nendók butagant, nun mani kerrá átkagant. ");
INSERT INTO bcc_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Shepánk o máldár ant. Wati ramag o górom o sajjahén mál o hasti‌esh áwortag gón. ");
INSERT INTO bcc_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","O padá Perawn ke shomárá lótháénit o cha shomá josta kant ke ‘shomay kár o rózgár ché ent?’ ");
INSERT INTO bcc_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","shomá begwashét ke ‘tai kaster cha kasániá shepánk o máldár butagant, wati pet o pirokáni paymá.’ Gorhá shomárá é ejázata rasit ke Góshenay damagá jahmenend bebét ke Mesriáni nezzá sajjahén shepánk bazznákén mardom ant.” ");
INSERT INTO bcc_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Issop shot o gón Perawná gwashti: “Mani pet o brát gón wati ramag o górom o sajjahén mál o hastiá cha Kanhánay molká átkagant o nun Góshenay damagá ant.” ");
INSERT INTO bcc_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Issopá panch brát zort o Perawnay démá pésh kort. ");
INSERT INTO bcc_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Perawná cha áiay brátán jost kort: “Shomay kár o rózgár ché ent?” Áyán passaw dát: “Tai kaster shepánk ant, wati pet o pirokáni paymá.” ");
INSERT INTO bcc_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Áyán gón Perawná chosh ham gwasht: “Má átkagén ke chizzé wahdá hamedá benendén, chéá ke Kanháná sakkén mazanén dhokkálé kaptag o pa tai kasteráni ramagán kahchar o charágáh nést. May dazbandi ent, wati kasterán razá beday ke Góshená jahmenend bebant.” ");
INSERT INTO bcc_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Perawná gón Issopá gwasht: “Nun ke tai pet o brát tai kerrá átkagant, ");
INSERT INTO bcc_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Mesray sardhagár tai démá ent. Wati pet o brátán molkay sharterén jágahá nádén. Belli Góshenay damagá nendant. Agan áyáni tahá budi o zrengén mardoma genday, mani mál o dalwatán hamáyáni dastá beday.” ");
INSERT INTO bcc_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Gorhá Issopá wati pet Ákub Perawnay kerrá áwort o pajjárént o Ákubá Perawn barkat dát. ");
INSERT INTO bcc_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Perawná cha Ákubá jost kort: “Tará chont sál ent?” ");
INSERT INTO bcc_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Ákubá passaw dát: “Mani zenday mosáperiá sad o si sál ent. Mani omr mazan naent o mani sál pa sakki o sóri gwastagant. Cha mani pet o pirokáni mosáperiay sálán kamter ant.” ");
INSERT INTO bcc_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Gorhá Ákubá Perawn barkat dát o cha Perawnay kerrá dar átk o shot. ");
INSERT INTO bcc_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Hamá paymá ke Perawná hokm dátagat, Issopá wati pet o brát Mesrá nádéntant o Mesray sharterén jágahá bezán Ramesésay damagá melkati dátant. ");
INSERT INTO bcc_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Issopá wati pet o brát o petay lógay sajjahén mardom láp dátant o haminchok chokkesh ke hastat haminchoki dátant. ");
INSERT INTO bcc_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Nun á sajjahén damagá pa waragá hecch néstat, chéá ke sakkén gránén dhokkálé kaptagat. Mesr o Kanhán doén, dhokkálá tabáh kortagatant. ");
INSERT INTO bcc_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Mardomán nograha dát o dán bahá gept. Issopá Mesr o Kanhánay sajjahén nograh moccha kort o Perawnay kalátá áwortant. ");
INSERT INTO bcc_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Wahdé Mesr o Kanhánay dráhén nograh halás butant, Mesray sajjahén mardom Issopay kerrá átkant o gwashtesh: “May nograh halás ant. Márá warák beday. Má tai chammáni démá bemerén?” ");
INSERT INTO bcc_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Issopá gón áyán gwasht: “Gorhá wati mál o dalwatán byárét. Shomay nograh ke halás butagant, shomay dalwatána zurán o badalá shomárá waráka dayán.” ");
INSERT INTO bcc_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Gorhá áyán wati mál o dalwat Issopay kerrá áwortant o Issopá áyáni asp o pas o gók o haráni badalá áyáná waráka dát. Á sálá, Issopá áyáni sajjahén mál o dalwat zortant o badalá áyáná warák dát. ");
INSERT INTO bcc_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Sál ke gwast, mardom domi sálá padá Issopay kerrá átkant o gwashtesh: “Má é gappá cha wati wájahá chér dáta nakanén ke may nograh ham halás ant o may mál o dalwat ham may wájahay butant. Nun may kerrá may jesm o ján o dhagárán abéd dega hecch pasht nakaptag ke tawe wájahay hezmatá pésh bekanén. ");
INSERT INTO bcc_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Má gón wati dhagárán tai chammáni démá gár o gomsár bebén? May jend o may dhagárán warákay badalá bezur. Má gón dhagárán Perawnay goláma bén. Márá dán beday ke zendag bemánén o mamerén o may dhagár ham wayrán mabant.” ");
INSERT INTO bcc_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Gorhá Issopá sajjahén Mesray dhagár pa Perawná bahá zortant. Mesray sajjahén mardomán wati dhagár bahá kortant, chéá ke sakkén gránén dhokkáléá geptagatant. Perawn áyáni dhagáráni wáhond but. ");
INSERT INTO bcc_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mesray é kondhá beger tán á kondhá Issopá mardom laddhént o shahráni tahá jahmenend kortant. ");
INSERT INTO bcc_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Albat, dini péshwáyáni dhagári bahá nazortant. Cha Perawnay némagá áyán komakka raset o é komakk pa áyáni ward o waráká bass at. Paméshká wati dhagáresh bahá nakortant. ");
INSERT INTO bcc_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Issopá gón mardomán gwasht: “Nun ke man maróchi shomay jend o shomay dhagár pa Perawná bahá zortagant, tohm esh ant, zeminá bekeshét. ");
INSERT INTO bcc_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Wahdé rón o móshay mósoma kayt, dhagáray bar o samaray pancheká Perawná bedayét. Chár bahr wati kerrá bedárét ke shomárá pa keshagá tohm o pa wati jend o wati lógay mardom o chokkán warák bebit.” ");
INSERT INTO bcc_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Mardomán gón áiá gwasht: “Taw may zend rakként. Wájahay nezar pa má nék bát. Má Perawnay goláma bén.” ");
INSERT INTO bcc_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Gorhá Issopá pa Mesray molká é kánun jórh kort ke tán róche maróchigá hastent ke dhagáráni bar o samaray panchek Perawnayg ent. Perawn éwaká dini péshwáyáni zemináni wáhond nabut o bass. ");
INSERT INTO bcc_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Nun Esráili Mesray molká, Góshenay damagá jahmenend butant. Ódá áyán dhagár raset, bázén chokk o baré kortesh o sakk báz butant. ");
INSERT INTO bcc_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ákubá Mesrá habdah sál gwázént o tán yakk sad o chell o hapt sálay omrá zendag at. ");
INSERT INTO bcc_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Wahdé Esráilay markay wahd nazzikk but, wati chokk Issopi lótháént o gwashti: “Mani sará mehrabánié bekan. Wati dastá mani zánay chérá ér kan o kawl beday ke gón man mehr o wapá kanay o maná Mesrá kabra nakanay. ");
INSERT INTO bcc_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Wahdé man sar ér kort o wati pet o pirokáni kerrá shotán, maná cha Mesrá bar o hamáyáni kerrá kabr kan.” Issopá gwasht: “Sharr ent. Anchosha kanán.” ");
INSERT INTO bcc_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Ákubá gwasht: “Sawgend bwar.” Issopá gón áiá sawgend wárt. Esráilá nepáday saruná pa adab sar jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Kammé wahdá rand Issopá hál raset ke tai pet nádráh ent. Gorhá áiá wati doén mardénchokk Manasi o Epráém zortant o shot. ");
INSERT INTO bcc_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Wahdé Ákubesh hál dát ke tai chokk Issop tai cháragá átkag, Esráilá wati wák o twán yakjáh kort o nepáday sará nesht. ");
INSERT INTO bcc_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Gón Issopá gwashti: “Porwákén Hodá Kanhánay molká, Luzay shahrá mani démá záher but. Maná barkati dát o ");
INSERT INTO bcc_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","gón man gwashti: ‘Man tará porsamara kanán o tai nasl o padréchá sakk báza kanán. Man tará kawmáni rombé jórha kanán o é sardhagárá cha taw o rand tai nasl o padréchárá dayán ke tán abad hamáyáni melkat bebit.’ ");
INSERT INTO bcc_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Nun tai é doén mardénchokk maniga bant, hamé chokk ke cha mani edá, tai kerrá áyagá pésar Mesray molká pédá butagant. Epráém o Manasi maniga bant, anchó ke Ruben o Shamun manig ant. ");
INSERT INTO bcc_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tai cha eshán o randteri chokk taiga bant, bale wati brát Epráém o Manasiay námay sará pajjáh áraga bant o hamé brátáni námay sará mirásesha rasit. ");
INSERT INTO bcc_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Wahdé man cha Paddáná per tarragá atán o Eprátay rasagá angat kammé ráh pasht kaptagat, ráhá, Kanhánay molká Ráhilay markay sók mani sará kapt. Man Ráhil hamódá Eprátay ráhá kabr kort.” Eprát Bayt-Lahem ent. ");
INSERT INTO bcc_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Wahdé Esráilá Issopay chokk distant, josti kort: “É kay ant?” ");
INSERT INTO bcc_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Issopá gwasht: “É mani chokk ant, Hodáyá hamedá maná dátagant.” Esráilá gwasht: “Mani kerrá byáresh ke barkatesh bedayán.” ");
INSERT INTO bcc_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Esráilay chamm cha piriá nezór atant o sharr maymia nakort. Paméshká Issopá wati chokk áiay nazzikká bortant o Ákubá, Epráém o Manasi chokket o goláésh kortant. ");
INSERT INTO bcc_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Esráilá gón Issopá gwasht: “Maná é omét nabutag ke padá tará gendán, bale Hodáyá tai chokk ham maná pésh dáshtant.” ");
INSERT INTO bcc_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Nun Issopá chokk cha Esráilay kotthá kenzéntant o sari pa adab jahl kort. ");
INSERT INTO bcc_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Issopá doén chokk zortant, Epráémi wati rástén némagá o Esráilay chappén némagá kort. Manasii wati chappén némagá o Esráilay rástén némagá kort. Wati petay nazzikká bortanti. ");
INSERT INTO bcc_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Bale Esráilá wati rástén dast chappén némagá shahár dát o chappén dast rástén némagá. Rástén dasti Epráémay sará ér kort, bell toré kaster at. Chappén dasti Manasiay sará ér kort, bell toré awali chokk at. ");
INSERT INTO bcc_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Ákubá Issop barkat dát o gwashti: “Hamá Hodá ke mani pet o pirok Ebráhém o Esáká áiay ráh zortag, hamá Hodá ke cha mani pédáeshá beger tán maróchi mani negahpán butag, ");
INSERT INTO bcc_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","hamá préshtag ke maná cha har táwáná rakkéntagi, é chokkán barkat bedayát. É mani námay sará o mani pet o pirokay námay sará bezán Ebráhém o Esákay námá zánag bátant o zeminay sará sakk báz bátant.” ");
INSERT INTO bcc_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Wahdé Issopá dist ke mani petay rástén dast Epráémay sará ent, wasshi nabut. Petay dasti gept ke cha Epráémay sará duri bekant o Manasiay sará éri bekant. ");
INSERT INTO bcc_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Gón petá gwashti: “Mani pet! Chó makan. Mani awali chokk esh ent. Wati rástén dastá eshiay sará ér kan.” ");
INSERT INTO bcc_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Bale petá namannet, gwashti: “Mana zánán, mani chokk! Zánán. Cha masteréná ham kawmé addha bit o á ham mazanén mardomé bit, bale kasterén brát cha áiá masterén mardomé bit o kasterénay chokk o nomásag báz kawma bant.” ");
INSERT INTO bcc_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Gorhá á róchi Ákubá Issopay mardénchokk barkat dátant, gwashti: “Bani Esráil barkat dayagay wahdá tai námá gipt: ‘Hodá tará chó Epráém o Manasiá kanát.’” É dhawlá Ákubá Epráém cha Manasiá démáter kort. ");
INSERT INTO bcc_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Esráilá gón Issopá gwasht: “Man hamé zuttána merán, bale Hodá gón shomá góna bit o shomárá shomay pet o pirokáni molká pera tarrénit. ");
INSERT INTO bcc_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Nun man tará cha tai brátán géshtera dayán. Hamá kóhestagá tará dayán ke man wati zahm o tirkamánay sará cha Amurián geptag.” ");
INSERT INTO bcc_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Ákubá wati chokk gwánk jat o gwashtant: “Yakjáh bét, man shomárá gwashán ke áyókén róchán ché bit. ");
INSERT INTO bcc_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Yakjáh bét o gósh dárét, oo Ákubay chokkán! Wati pet Esráilay habarán gósh dárét. ");
INSERT INTO bcc_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Oo Ruben! Taw mani awali chokk ay, mani wák o twán ay, mani mardánagiay awali neshán ay, marháh o zóray shán ay. ");
INSERT INTO bcc_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Chó ápá bélagám ay, master nun taw namánay, ke wati petay nepádán, mani gandalán sar kaptay o palitet kortant. ");
INSERT INTO bcc_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Shamun o Láwi brát ant, zahmesh sheddati seláh ant. ");
INSERT INTO bcc_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Hechbar esháni majlesá manendátán, gón eshán hamdiwán mabátán, ke cha wati hezhmá mardomesh koshtagant o pa wati delwasshiá sándhesh lang kortagant. ");
INSERT INTO bcc_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Nálat bát esháni trondén hezhmá, esháni berahmén kahrá. Ákubay molká yakk yakkesha kanán, Esráilay molká sheng o sháng. ");
INSERT INTO bcc_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Oo Yahudá! Tai brát tará názénant, tai dast dozhmenáni gotthá sakka bit, tai petay chokk tai démá kóndhana kapant. ");
INSERT INTO bcc_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yahudá shéri gollorhé. Oo mani chokk! Taw cha shekárán átkagay. Yahudá chó sherá srápa kant, chó mádagén shérá kamina kant. Kai majál ent ke pádi bekant? ");
INSERT INTO bcc_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Bádsháhi asá cha Yahudáay dastá narawt o hákemiay dazlatth cha áiay pádáni démá dura nabit tán hamá wahdá ke asligén wáhonda kayt o kawm áiay parmánbardára bant. ");
INSERT INTO bcc_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Á wati hará anguri drachkéá bandit o korragá gechéni sháharhéá, wati póshákán gón sharábá shódit, wati pocchán gón anguray hóná. ");
INSERT INTO bcc_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Áiay chamm cha sharábá sohrtera bant o dantán cha shirá espétter. ");
INSERT INTO bcc_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Zebulun tayábdapá jahmenenda bit, pa bójigán bandené bit o simsari tán Sayduná sara bit. ");
INSERT INTO bcc_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Issákár zórmandén haré ke doén tangáni nyámá tachk ent. ");
INSERT INTO bcc_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Gendit ke árámjáh sharr ent o zemin wassh, wati baddhá pa bárá éra dant o pa bigáriá tayára bit. ");
INSERT INTO bcc_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Dán Esráilay kabilahé bit o pa wati mardomán ensápa kárit. ");
INSERT INTO bcc_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Dán rahsará maré bit, keshkay kashá syahmáré, aspáni srombán dhanga jant ke swár poshtoká bekapit. ");
INSERT INTO bcc_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Oo Hodáwand! Wadárig án ke taw berakkénay. ");
INSERT INTO bcc_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Orosh kanók Jádá angerra kanant, bale Jád áyáni pádáni punzáni sará birha bárt. ");
INSERT INTO bcc_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ásheray nagan charpa bit, mahluká sháhi waráka dant. ");
INSERT INTO bcc_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Naptáli ázát butagén áské o dhawldárén áskaloka kárit. ");
INSERT INTO bcc_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Issop porsamarén anguré, chammagay lambá baráwarén anguré. Sháharhi, diwálán sara kapant. ");
INSERT INTO bcc_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Tirkamán janókán pa zahrnáki áiay sará orosh kort o pa badwáhi tiresh jat. ");
INSERT INTO bcc_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Bale Issopay kamán barjáh mant o báski mohr o mohkam atant, Ákubay zórmandén Hodáay dastay barkatá, Esráilay shepánkay barkatá, Esráilay taláray barkatá, ");
INSERT INTO bcc_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","tai petay Hodáay barkatá, ke tará madata kant, porwákén Hodáay barkatá, ke tará barkata dant. Gón ásmánay barkatán, cha borzá, gón johlánkiay barkatán, cha jahlá o gón chokdán o gwaráni barkatán tará barkata dant. ");
INSERT INTO bcc_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Tai petay barkat cha abadi kóháni barkatán báláter ant, cha kwahnén jompáni nyámatán géshter ant. É sarjamá Issopay sará begwárátant, Issopay péshánigay sará ke wati brátáni shahzádag ent. ");
INSERT INTO bcc_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Benyámin derrók o warókén gorké, sohbán shekár éra bárt o bégáhán áwár bahra kant.” ");
INSERT INTO bcc_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","É Esráilay dwázdahén kabilah atant o é hamá habar atant ke áyáni petá barkat dayagay wahdá gón áyán kortant. Har yakkéárá hamáiay hesábá barkati dát. ");
INSERT INTO bcc_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Nun Ákubá wati chokk chó sój dátant: “Man gón wati mortagén mardomán hawár bayagi án. Maná mani pet o pirokáni kerrá, hamá gárá kabr kanét ke Eprun Hittiay dhagárá ent, ");
INSERT INTO bcc_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","hamá gárá ke Makpélahay dhagárá, Mamrehay nazzikká, Kanhánay molká ent o Ebráhémá cha Eprun Hittiá gón dhagárá hór bahá zort ke kabrestáné bekanti. ");
INSERT INTO bcc_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Ódá Ebráhém o áiay jan Sárah kabr kanag butagant, Esák o áiay jan Rebekká kabr kanag butagant o man Lyáh ham hamódá kabr kortag. ");
INSERT INTO bcc_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Dhagár o áiay tahay gár cha Hittián bahá zurag butagant.” ");
INSERT INTO bcc_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Wahdé Ákubá wati chokkáni sój dayag halás kort, nepáday sará wati pádi tachk kortant, goddhi dami kasshet o gón wati mortagén mardomán hawár but. ");
INSERT INTO bcc_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Issopá watárá petay sará dawr dát, gréti o peti chokket. ");
INSERT INTO bcc_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Gorhá hamá dáktar ke Issopay hezmatá atant, Issopá gón áyán gwasht ke mani pet Esráilá mómyái kanét o áyán Esráil mómyái kort. ");
INSERT INTO bcc_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","É kárá chell róch jat ke inchok wahd pa mómyái kanagá allami at. Mesrián haptád róch pa áiá pors dásht. ");
INSERT INTO bcc_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Wahdé porsay róch halás butant, Issopá gón Perawnay lógay mardomán gwasht: “Agan mani ezzatá kanét, pa manigi gón Perawná habar kanét o begwashéti ");
INSERT INTO bcc_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","ke mani petá maná sawgend dátag o gwashtag: ‘Man meragi án. Maná hamá kabrá kall kan ke man pa wat Kanhánay molká kótkag.’ Nun maná razá day ke rawán o wati petá kabra kanán o káyán.” ");
INSERT INTO bcc_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Perawná gwasht: “Beraw, wati petá hamá paymá kabr kan ke tará sawgendi dátag.” ");
INSERT INTO bcc_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Gorhá Issop wati petay kabr kanagá shot. Perawnay sajjahén hezmatkár ham áiay hamráh atant. Perawnay lógay masterén mardom o Mesray sajjahén kamásh shotant gón. ");
INSERT INTO bcc_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Issopay lógay sajjahén mardom, áiay petay lógay mardom o áiay brát ham gón atant. Éwaká chokk o ramag o górom Góshená mantant. ");
INSERT INTO bcc_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Arrábaswár o aspswár ham shotant gón. Sakkén mazanén rombé at. ");
INSERT INTO bcc_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Wahdé á Ordonay kawray nazzikká Atáday jóháná sar butant, kukkáresh kort o záresh jat. Issopá ódá hapt róchá pa wati petá pors dásht. ");
INSERT INTO bcc_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Wahdé óday nendókén Kanhánián Atáday jóháná dáshtagén é pors dist, gwashtesh: “Mesrián baláhén porsé dáshtag.” Paméshká á jágah ke Ordonay kawray nazzikká ent, á jágahay námesh Ábel-Mesráém kort. ");
INSERT INTO bcc_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Gorhá Ákubay chokkán hamá paym kort ke petá hokm dátagatant. ");
INSERT INTO bcc_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Ákubesh Kanhánay molká bort o hamá gárá kabr kort ke Makpélahay dhagárá, Mamrehay nazzikká at. Ebráhémá á gár gón dhagárá cha Eprun Hittiá bahá zortagat ke kabrestáné bekanti. ");
INSERT INTO bcc_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Cha petay kabr kanagá rand Issop gón wati brátán o gón sajjahén hamráhán ke áiay petay kabr kanagá átkagatant, Mesrá per tarret. ");
INSERT INTO bcc_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Wahdé Issopay brátán dist ke may pet mortag, gwashtesh: “Agan Issopá kénag delá ent, hamá sajjahén badiáni bérá gipt ke má gón áiá kortagant.” ");
INSERT INTO bcc_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Gorhá áyán pa Issopá kolawé ráh dát o gwashtesh: “Tai petá marká pésh é wasiat kortag: ");
INSERT INTO bcc_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Issopá begwashét ke mani dazbandi ent ke wati brátáni mayár o gonáhán bebaksh ke gón taw badi‌esh kortag. Wati petay Hodáay bandaháni badián pahell kan.’” Wahdé áyáni paygám Issopá sar but, gréti. ");
INSERT INTO bcc_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Gorhá brát Issopay kerrá átkant o pádáni kaptant o gwashtesh: “Má tai golám én.” ");
INSERT INTO bcc_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Bale Issopá gwasht: “Matorsét. Man Hodá wa naán. ");
INSERT INTO bcc_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Shomay niyat mani táwán dayag at, bale Hodáay niyat nék at. Áiay niyat hamesh at ke bázén mardoméay sáh berakkit. É kár, hamesh ent annun bayagá ent. ");
INSERT INTO bcc_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Gorhá matorsét. Man shomay o shomay chokkáni zaluratán puraha kanán.” Bráti deljami dátant o gón áyán pa sharri habari kort. ");
INSERT INTO bcc_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Issop gón wati petay lógay sajjahén mardomán Mesrá nesht. Yakk sad o dah sál omri kort o ");
INSERT INTO bcc_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Epráémay chokkáni sayomi poshti dist. Manasiay nomásag, Mákiray chokk ham ke pédá butant, Issopay kotthá dayag butant. ");
INSERT INTO bcc_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Issopá gón wati brátán gwasht: “Man meragi án, bale deljam án ke Hodá pa shomay madatá kayt o shomárá cha é molká dém pa hamá molká bárt ke áiay bárawá gón Ebráhém o Esák o Ákubá sawgendi wártag.” ");
INSERT INTO bcc_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Issopá gón Esráilay chokkán gwasht: “Sawgend bwarét ke wahdé Hodá shomay madatá kayt, mani haddhán cha é jágahá barét gón.” ");
INSERT INTO bcc_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Issop yakk sad o dah sálay omrá mort, gorhá áesh mómyái kort o tábutéá wápént o Mesrá éresh kort.");
INSERT INTO bcc_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ákubay hamá mardénchokk ke har yakkéá wati lógay mardom zortant o gón Ákubá Mesrá shot gón, áyáni nám esh ant: ");
INSERT INTO bcc_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruben o Shamun o Láwi o Yahudá o ");
INSERT INTO bcc_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Issákár o Zebulun o Benyámin o ");
INSERT INTO bcc_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Dán o Naptáli o Jád o Ásher. ");
INSERT INTO bcc_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Ákubay chokk o nomásag sarjamiá haptád atant. Issop cha pésará Mesrá at. ");
INSERT INTO bcc_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Issop mort o sajjahén bráti ham mortant o áiay hamomrén sarjamén nasl ham mort. ");
INSERT INTO bcc_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Bale Bani Esráil porsamar at. Áyán chokk o bar kort, waddán but o sakk báz butant. Mesray molk cha Esráilián porr but. ");
INSERT INTO bcc_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Nun Mesray sará nókén Perawné bádsháhi tahtá nesht. É bádsháh Issopay bárawá sarpad naat. ");
INSERT INTO bcc_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Áiá gón wati mahluká gwasht: “Bechárét, Bani Esráilay mardom cha má báz géshter o zórmandter jórh butagant. ");
INSERT INTO bcc_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Báyad ent pa hóshmandi esháni démá bedárén, agan é géshter bebant o márá jangé begipt, é may dozhmenáni hamráha bant o gón má janga kanant o padá cha may molká tachant o rawant.” ");
INSERT INTO bcc_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Bádsháh o áiay mansabdárán, bigárgir esháni kármaster kortant ke esháni sará zóráki bekanant o gránén káresh bebandant. Bani Esráilián pa Perawná do shahr addh kort. Yakkéay nám Pitum at o yakkéay Ramesés. Doén ambári shahr atant. ");
INSERT INTO bcc_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Mesrián áyáni sará haminkas ke géshter zórákia kort, Esráili géshter bayán o sheng bayána butant. Gorhá Mesrián cha Esráilián torset. ");
INSERT INTO bcc_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mesrián Esráili pa bérahmi kára bastant. ");
INSERT INTO bcc_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Hesht o batánahay addh kanagesha parmátant o dhagáráni sará har dábén gránén káresha geptant o áyáni zendagiesh azáb kort. Sajjahén káresh pa bérahmi parmátant. ");
INSERT INTO bcc_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mesray bádsháhá gón Ebráni janbógán habar kort. Yakk janbógéay nám Shiprah at o domiay Puah. ");
INSERT INTO bcc_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Gón eshán gwashti: “Wahdé shomá Ebráni janénán chokmát kanét, chellagiay bashánahá bechárét, agan chokk bachakké, bekoshéti o agan jenekké, belléti.” ");
INSERT INTO bcc_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Bale janbógán cha Hodáyá torset o á dhawlá nakortesh ke Mesray bádsháhá gwashtagatant o mardénchokkesh nakoshtant. ");
INSERT INTO bcc_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Gorhá Mesray bádsháhá janbóg lótháéntant o gón áyán gwashti: “Shomá chéá chó kort o mardénchokk zendagá eshtant?” ");
INSERT INTO bcc_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Janbógán gón Perawná gwasht: “Ebráni janén Mesri janénáni paymá naant. Dhaddhén zál ant o cha janbogáni rasagá pésar chokká pédá kanant.” ");
INSERT INTO bcc_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Gorhá Hodá janbogáni sará mehrabán but. Esráilián chokk o bar kort o sakk báz butant. ");
INSERT INTO bcc_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Janbógán cha Hodáyá torset, paméshká Hodáyá áyáni lóg ábád kortant. ");
INSERT INTO bcc_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Gorhá Perawná wati sajjahén mardom hokm dát o gwashtant: “Har Ebráni mardénchokké ke pédá bit, áiá Nillay kawrá dawr bedayét, bale Ebráni jenekkán bellét.” ");
INSERT INTO bcc_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Láwi kabilahay mardé shot o Láwi jenekké sángi kort. ");
INSERT INTO bcc_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Janén lápporr but o mardénchokké áworti. Janéná dist ke chokk sharrangé, tán say máhá chéri dát. ");
INSERT INTO bcc_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Wahdé áiá chokk cha ed o géshter chér dát nakort, pa áiá cha kalam o káshá gwaptagén sapté zorti, sapti gir o dhámbar jat, chokki saptá kort o Nillay kawray lambá kásháni tahá éri kort. ");
INSERT INTO bcc_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Chokkay gohár kammé dur óshtát o cháragá lagget ke bárén chokk chóna bit. ");
INSERT INTO bcc_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Perawnay jenekk jánay shódagá Nillay kawrá átk. Móled Nillay kawray kerrá gardagá laggetant. Perawnay jenekká kásháni nyámá sapt dist o wati móledé ráhi dát ke saptá byár. Áiá áwort. ");
INSERT INTO bcc_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Perawnay jenekká sapt pach kort o nonnok dist. Nonnok gréwagá at. Perawnay jenekká áiay sará bazzag but. Gwashti: “É cha Ebrániáni chokkán ent.” ");
INSERT INTO bcc_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Gorhá nonnokay gohárá cha Perawnay jenekká jost kort: “Berawán o Ebráni janéné tawár bekanán ke nonnoká pa taw shir beméchénit?” ");
INSERT INTO bcc_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Perawnay jenekká gwasht: “Beraw.” Jenekk shot o nonnokay máti tawár kort. ");
INSERT INTO bcc_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Perawnay jenekká gón áiá gwasht: “É nonnoká gón wat bar o pa man méchén. Man tai mozzá dayán.” Janéná nonnok zort o méchént. ");
INSERT INTO bcc_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Chokk ke rost o kammé master but, mátá Perawnay jenekkay kerrá áwort. Perawnay jenekká chokk zort o wati chokk kort. Áiay námi Mussá kort, gwashti: “É man cha ápá kasshetag.” ");
INSERT INTO bcc_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Wahdé Mussá rost o mazan but, yakk róché wati mardománi kerrá shot o áyáni bigári o gránén kári distant. Mussáyá Mesrié dist ke Ebrániéá, bezán cha Mussáay jenday mardomán yakkéá janagá at. ");
INSERT INTO bcc_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Mussáyá wati chapp o chágerd cháret o disti ke kass nést. Gorhá Mesrii kosht o rékáni tahá kall kort. ");
INSERT INTO bcc_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Domi róchá padá dhanná shot o disti ke do Ebráni merhagá ent. Gón mayárigén mardomá gwashti: “Chéá wati hamkawmá janagá ay?” ");
INSERT INTO bcc_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Áiá passaw dát: “Kayá tará may sará hákem o dádras kortag? Záná taw lóthay maná ham bekoshay anchó ke Mesriet kosht?” Mussáyá torset o delá gwashti: “Pakkáyá habar páshk butag.” ");
INSERT INTO bcc_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Perawn é habará sahig but o Mussáay koshagay erádahi kort. Bale Mussá cha Perawnay kerrá tatk o Midyánay molká shot o chátéay kerrá nesht. ");
INSERT INTO bcc_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Midyánay dini péshwáyá hapt janénchokk hastat. É jenekk átk o ápay kasshag o tagáray porr kanagá laggetant ke petay ramagá áp bedayant. ");
INSERT INTO bcc_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Bale lahtén shepánk átk o jenekkesh galléntant. Mussá jenekkáni komakká pád átk o áyáni ramagi áp dát. ");
INSERT INTO bcc_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Jenekk ke wati pet Rawélay kerrá átkant, petá jost kortant: “Maróchi chéá chó zutt átkagét?” ");
INSERT INTO bcc_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Áyán gwasht: “Maróchi Mesriéá márá cha shepánkáni dastá rakként. Ápi ham kasshet o ramagi áp dát.” ");
INSERT INTO bcc_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Petá gón wati jenekkán gwasht: “Gorhá kojá ent? Shomá á mard chéá nayáwortag gón? Tawári kanét, belli kayt o nána wárt.” ");
INSERT INTO bcc_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Mussá marday kerrá jahmenend bayagá rázig but o mardá wati jenekk Sapurah gón Mussáyá sur dát. ");
INSERT INTO bcc_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Sapurahá mardénchokké áwort o Mussáyá áiay nám Gayrshám kort, gwashti: “Man darmolká darámadé án.” ");
INSERT INTO bcc_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Máh o sál gwastant o hamé nyámá Mesray bádsháh mort. Esráili cha wati golámiá nálag o peryátá atant. Áyáni é nálag o peryát borzád shot o Hodáyá sar butant. ");
INSERT INTO bcc_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Hodáyá áyáni nálag eshkotant o wati hamá ahd o paymánay tránagá kapt ke gón Ebráhém o Esák o Ákubá bastagati. ");
INSERT INTO bcc_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Hodáyá Esráili distant o áyáni sará bazzagi but. ");
INSERT INTO bcc_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Mussá wati nákó, Midyánay dini péshwá Yatrunay ramagá chárénagá at. Ramagi zort o gyábánay á dastá, Hórébá, bezán Hodáay kóhá shot. ");
INSERT INTO bcc_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Hodáwanday préshtag cha dhólokéay nyámá, ásay shamálahéay tahá áiay démá záher but. Mussáyá dist ke dhólok bon ent, bale sochag o por bayagá naent. ");
INSERT INTO bcc_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mussáyá gwasht: “Rawán o é ajabén nedáragá charán ke bárén dhólok chéá sochag o por bayagá naent.” ");
INSERT INTO bcc_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Hodáwandá dist ke Mussá é nedáragay cháragá pédák ent. Hodáyá cha dhólokay tahá gwánk jat: “Mussá, oo Mussá!” Mussáyá passaw dát: “Ji!” ");
INSERT INTO bcc_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Hodáyá gwasht: “Nazzikter mayá. Wati swásán kassh ke é jágahá ke taw óshtátagay, é pákén jágahé.” ");
INSERT INTO bcc_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Hodáyá padá gwasht: “Man tai petay Hodá án, Ebráhémay Hodá, Esákay Hodá o Ákubay Hodá án.” Mussáyá Hodáay chárag torset o wati démi gept. ");
INSERT INTO bcc_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Hodáwandá gwasht: “Mani mahluk ke Mesrá ent, man áyáni bazzagi sharriá distag. Man distag ke wati bigárgiráni sawabá chón peryáta kanant. Áyáni dardán sharriá zánán. ");
INSERT INTO bcc_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Man ér átkagán ke áyán cha Mesriáni dastá berakkénán o cha é molká, sharrén o práh o sháhegánén molkéá bebarán, anchén molkéá ke ódá shir o bénagay jó tachagá ant, Kanháni o Hitti o Amuri o Perizzi o Héwi o Yabusiáni molká. ");
INSERT INTO bcc_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Bechár, Bani Esráiliáni peryát mani kerrá sar butag, man hamá zolm ham distagant ke Mesri áyáni sará kanantesh. ");
INSERT INTO bcc_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Beraw, man tará Perawnay kerrá ráha dayán, mani kawm Bani Esráilá bezur o cha Mesrá dar á.” ");
INSERT INTO bcc_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Bale Mussáyá gón Hodáyá gwasht: “Man kay án ke Perawnay kerrá berawán o Bani Esráilá bezurán o cha Mesrá dar byáyán?” ");
INSERT INTO bcc_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Hodáyá gwasht: “Man gón taw góna bán. Taw ke kawmá zuray o cha Mesrá dara káay, shomá hamé kóhá Hodáay parasteshá kanét. O é yakk neshánié bit ke tai ráh dayók man án.” ");
INSERT INTO bcc_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mussáyá gón Hodáyá gwasht: “Agan man Bani Esráilay kerrá berawán o begwashán ke shomay bonpirokáni Hodáyá maná shomay kerrá ráh dátag o á cha man jost bekanant ke áiay nám kay ent, áyáni passawá ché begwashán?” ");
INSERT INTO bcc_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Hodáyá gwasht: “Man hamá án ke hastán. Gón Bani Esráilá begwash ke hamá ke nám enti ‘Man Hamá Án’, hamáiá maná shomay kerrá ráh dátag.” ");
INSERT INTO bcc_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Hodáyá gón Mussáyá é ham gwasht: “Gón Bani Esráilá begwash ke ‘Yahweh’, bezán shomay bonpirokáni Hodá, Ebráhémay Hodá, Esákay Hodá o Ákubay Hodáyá maná shomay kerrá ráh dátag. Tán abad mani nám hamesh ent o man nasláni nasl hamé námá yát kanaga bán. ");
INSERT INTO bcc_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Beraw Esráilay kamáshán yakjáh kan o gón áyán begwash ke Hodáwand, bezán shomay bonpirokáni Hodá, Ebráhém o Esák o Ákubay Hodá mani démá záher butag o gón man gwashtagi ke man cha nazzikká distag ke Mesrá gón shomá ché butag o ");
INSERT INTO bcc_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","man kawla kanán ke shomárá cha é bazzagiá dara kanán ke Mesrá shomay sará átkag o shomárá Kanháni o Amuri o Perizzi o Héwi o Yabusiáni molká barán, hamá molká ke shir o bénagay jó tachagá ant. ");
INSERT INTO bcc_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Esráilay kamásh tai habarán gósha dárant. Shomá hórigá Mesray bádsháhay kerrá berawét o gón áiá begwashét ke Hodáwand, bezán Ebrániáni Hodá may démá záher butag. Nun márá razá beday ke má gyábáná say róchay ráhá rawén o pa wati Hodáwandén Hodáyá korbániga kanén. ");
INSERT INTO bcc_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Bale mana zánán ke tán zórmandén dasté Mesray bádsháhá majbur makant, á shomárá rawagá naylit. ");
INSERT INTO bcc_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Man wati dastá shahára dayán o Mesrá gón wati hamá sajjahén ajabbatén kárána janán ke manesh áyáni nyámá kanán. Gorhá Perawn shomárá ráwagá kellit. ");
INSERT INTO bcc_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Man Mesriáni delá pa é kawmá narma tarrénán o wahdé shomá rawét, cha Mesrá gón hórk o háligén dastána narawét. ");
INSERT INTO bcc_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Har janén cha wati hamsáhegén janén o cha áiay lógá nendókén janéná god o pocch o nograh o teláhay saht o zéwar belóthit o wati bacch o jenekkáni gwaráesh bedant. É paymá shomá Mesriáni mál o hastiá polét.” ");
INSERT INTO bcc_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mussáyá passaw dát: “Agan mardom mani sará báwar makanant o mani habarán gósh madárant o begwashant: ‘Hodáwand tai démá záher nabutag,’ gorhá?” ");
INSERT INTO bcc_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Hodáwandá gwasht: “É chéé tai dastá ent?” Passawi dát: “Asáé.” ");
INSERT INTO bcc_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Gwashti: “Zeminá dawri day.” Mussáyá ke asá zeminá dawr dát, asá maré but o Mussá cha áiay kerrá tatk. ");
INSERT INTO bcc_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Hodáwandá gón Mussáyá gwasht: “Wati dastá shahár day o máray dombá beger.” Mussáyá wati dast shahár dát o gepti o már áiay dastá asáé but. ");
INSERT INTO bcc_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Hodáwandá gwasht: “É neshániá ke záhera kanay, gorhá Esráili báwara kanant ke mane Hodáwand bezán áyáni bonpirokáni Hodá, Ebráhémay Hodá, Esákay Hodá o Ákubay Hodá tai démá záher butag.” ");
INSERT INTO bcc_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Padá Hodáwandá gwasht: “Dastá wati kabáhay tahá kan.” Áiá dast kabáhay tahá kort. Dasti ke cha kabáhá dar kort, dast purah garrá geptagat o chó barpá espét at. ");
INSERT INTO bcc_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Hodáwandá gwasht: “Dastá padá kabáhay tahá kan.” Áiá dast padá kabáhay tahá kort. Dasti ke cha kabáhá dar kort, ta dast wassh butagat o dastay póst jánay é dega jágaháni póstay paymá at. ");
INSERT INTO bcc_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","“Agan mardomán tai gapp báwar nabut o awali neshániesh delgósh nakort, domi neshániá báwara kanant. ");
INSERT INTO bcc_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Bale agan é doén neshániesh báwar nakortant o tai gappesh gósh nadásht, gorhá cha Nillá kammé áp bezur o hoshkén zeminay sará beréch. É ápán ke taw cha Nillá zuray, é áp hoshkén zeminay sará hóna bant.” ");
INSERT INTO bcc_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Mussáyá gón Hodáwandá gwasht: “Oo mani Hodáwand! Man habarzánté naán, na pésará butagán o na annun habarzánté án. É sáhatá ham ke taw gón wati kasterá habará ay, mani zobán o bayán konth ent.” ");
INSERT INTO bcc_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Hodáwandá gwasht: “Baniádamay dap kayá jórh kortag? Kay ensáná gong o karra kant? Kay ensáná champach o kóra kant? Mane Hodáwand naent? ");
INSERT INTO bcc_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Nun beraw, man tará sója dayán ke tará ché gwashagi ent. Dap taiga bit o gapp maniga bant.” ");
INSERT INTO bcc_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Mussáyá gwasht: “Oo mani Hodáwand! Degaré ráh day.” ");
INSERT INTO bcc_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Hodáwand Mussáay sará zahr gept o gwashti: “Hárun tai brát naent, Láwi kabilahay Hárun? Mana zánán ke habarzánté. Bechár, á annun tai gendoká pédák ent o cha tai gendagá deli wassha bit. ");
INSERT INTO bcc_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Taw gón áiá habara kanay o habarán áiay dapá dayay. Man shomárá sója dayán ke ché bekanét. Dap taig o áiayga bant o gapp maniga bant. ");
INSERT INTO bcc_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Tai badalá á gón mardomán habara kant. Á pa taw dapé bit o taw pa áiá hodáé bay. ");
INSERT INTO bcc_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Taw é asáyá dastá kan ke wati neshánián gón hameshiá pésh bedáray.” ");
INSERT INTO bcc_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Mussá padá wati nákó Yatrunay kerrá shot o gón áiá gwashti: “Maná razá day, Mesrá wati brátáni kerrá rawán o charán ke bárén zendag ant yá mortagant.” Yatruná gwasht: “Beraw pa salámati.” ");
INSERT INTO bcc_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Midyánay molká Hodáwandá gón Mussáyá gwasht: “Padá Mesrá beraw, chéá ke á sajjahén mardom ke tai koshagay randá atant, mortagant.” ");
INSERT INTO bcc_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Mussáyá wati jan o doén chokk zort o hará swár kortant o Mesrá wátarr but. Mussáyá “Hodáay asá” dastá kort. ");
INSERT INTO bcc_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Hodáwandá gón Mussáyá gwasht: “Wahdé padá Mesrá raway, bechár, hamá sajjahén mójezah ke man tai dastá dátagant, Perawnay démá á mójezahán bekan o pésh dár, bale man áiay delá senga kanán ke kawmá rawagá maylit. ");
INSERT INTO bcc_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Gón Perawná begwash: ‘Hodáwand chosha gwashit: Esráil mani mardénchokk ent, mani awali chokk ent. ");
INSERT INTO bcc_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Man tará gwasht ke mani chokká bell ke rawt o mani parasteshá kant. Bale taw namannet o rawagá naesht. Bechár, nun man tai chokká koshán, tai awali mardénchokká.’” ");
INSERT INTO bcc_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Chó but ke ráhá menzeléá Hodáwand gón Mussáyá dochár kapt o lótheti ke Mussáyá bekoshit. ");
INSERT INTO bcc_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Bale Mussáay jan Sapurahá tézén sengé zort o wati chokkay loppok borret o hamé pósti Mussáay pádán jat. Gwashti: “Taw pa man ‘hónay sálónké’ ay.” ");
INSERT INTO bcc_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Hodáwandá hamé wahdá Mussá yalah dát ke Sapurahá sonnatay sawabá Mussá “hónay sálónk” gwashtagat. ");
INSERT INTO bcc_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Hodáwandá gón Háruná gwasht: “Mussáay cháragá gyábáná beraw.” Hárun shot o Hodáay kóhá gón Mussáyá dochár kapt o Mussái chokket. ");
INSERT INTO bcc_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Mussáyá hamá sajjahén habar gón Háruná kortant ke Hodáwandá pa áyáni gwashagá Mussá ráh dátagat. Hamá sajjahén neshániáni háli ham dát ke Hodáwandá pa áyáni pésh dáragá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Gorhá Mussá o Hárun shotant o Esráiliáni sajjahén kamáshesh yakjáh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Háruná hamá sajjahén habar kortant ke Hodáwandá gón Mussáyá kortagatant o hamá neshánii mahlukay chammáni démá pésh dáshtant. ");
INSERT INTO bcc_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Mahluká báwar kort. Wahdé áyán eshkot ke Hodáwandá may némagá delgósh kortag o may bazzagii distag, pa adab saresh jahl kort o parastesh kanagá laggetant. ");
INSERT INTO bcc_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Randá Mussá o Hárun shotant o gón Perawná gwashtesh: “Yahweh, Esráilay Hodá chosha gwashit: ‘Mani mahluká bell ke gyábáná rawt o pa man jashné kant.’” ");
INSERT INTO bcc_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Bale Perawná gwasht: “Yahweh kay ent ke man áiay gappá gósh bedárán o Bani Esráilá rawagá bellán? Man Yahwehá nazánán o Bani Esráilá rawagá naylán.” ");
INSERT INTO bcc_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Áyán gwasht: “Ebrániáni Hodá may démá záher butag. Nun márá bell ke gyábáná say róchay ráhá rawén o pa wati Hodáwandén Hodáyá korbániga kanén. Chó mabit ke gón wabá yá zahmá may sará bekapit.” ");
INSERT INTO bcc_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Bale Mesray bádsháhá gwasht: “Mussá! Hárun! Shomá chéá mardomán kárá naylét? Berawét o wati bigáriá bekanét.” ");
INSERT INTO bcc_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Padá gwashti: “Bechár, annun é molká Esráili sakk báz ant bale shomá kárá naylétesh.” ");
INSERT INTO bcc_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Hamá róchá Perawná mardománi bigárgir o kármaster hokm dát o gwashtant: ");
INSERT INTO bcc_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Pésará pa heshtay janagá shomá mardománá palár dátag, nun madayétesh. Belli wata rawant o palára chenant. ");
INSERT INTO bcc_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Bale cha áyán hesht hamá kesásá belóthét ke pésará jatagesh, hecch kamm makanét. É mardom jándozz o tambal ant, paméshká peryáta kanant: ‘Márá bell ke rawén o pa wati Hodáyá korbániga kanén.’ ");
INSERT INTO bcc_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Áyán angat gránterén kár beparmáét ke wati kárá dazgatth bebant o drógén habaráni némagá delgósh makanant.” ");
INSERT INTO bcc_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mardománi bigárgir o kármaster dhanná shotant o gón mardomán gwashtesh: “Perawn chosha gwashit: ‘Man shomárá palára nadayán.’ ");
INSERT INTO bcc_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Shomá wat berawét o palár bechenét, har jágah ke dar gétka kanét. Bale cha shomay kárá toshé kamma nabit.” ");
INSERT INTO bcc_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mardom sajjahén Mesray molká sheng butant ke pa heshtay janagá palár bechenant. ");
INSERT INTO bcc_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Bigárgirán kaddhan kort o gwashtant: “Wati hamok róchi gisshéntagén kárá hamá wahday paymá sarjam bekanét ke shomárá palár butag.” ");
INSERT INTO bcc_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Perawnay bigárgirán wati dáshtagén Esráili kármaster jat o jost kortant: “Shomay zikkén o maróchigén hesht chéá pésarigén kesásá naant?” ");
INSERT INTO bcc_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Esráili kármaster shotant o Perawnay kerrá peryátesh kort: “Taw chéá gón wati kasterán chó kanagá ay? ");
INSERT INTO bcc_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Tai kasterán palára nadayant o angat márá gwashant: ‘Hesht bejanét.’ Bechár, radi tai mardománig ent, latthán má waragá én.” ");
INSERT INTO bcc_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Perawná gwasht: “Shomá jándozz o tambal ét, behyá ét, paméshká gwashét: ‘Márá bell ke rawén o pa Hodáwandá korbániga kanén.’ ");
INSERT INTO bcc_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Nun berawét o kár kanét. Shomárá palár dayaga nabit, bale hesht hamá kesásá bejanét.” ");
INSERT INTO bcc_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Esráili kármasterán zánt ke má janjáléá kaptagén ke márá gwashant shomay jatagén hesht cha har róchigén gisshéntagén kesásá kamter mabant. ");
INSERT INTO bcc_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Wahdé kármaster cha Perawnay kerrá dar átkant, gón Mussá o Háruná dhikkesh wárt. Mussá o Hárun áyáni wadárá atant. ");
INSERT INTO bcc_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Gón áyán gwashtesh: “Hodáwand shomárá may hakkáni jostá bekanát o wat ensáp bekanát. Shomá Perawn o áiay hezmatkáráni chammán márá syahru kanáéntag o pa may koshagá zahmé áyáni dastá dátag.” ");
INSERT INTO bcc_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mussá padá Hodáwanday kerrá shot o gwashti: “Oo Hodáwand! Taw chéá é mahluk janjáléá dawr dát? Taw paméshká maná ráh dát? ");
INSERT INTO bcc_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Man Perawnay kerrá shotán ke tai námay sará gón áiá habar bekanán, bale cha á róchá o rand Perawná tai mahluk ganter janjál kortag o taw pa mahlukay rakkénagá hecch nakortag.” ");
INSERT INTO bcc_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Hodáwandá gón Mussáyá gwasht: “Nun taw genday ke man gón Perawná ché kanán. Perawn mani zórmandén dastá ke gendit, mahluká rawagá kellit. Haw, mani zórmandén dastá ke gendit, áyán cha wati molká gallénit.” ");
INSERT INTO bcc_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Hodáyá gón Mussáyá habar kort, gwashti: “Man Hodáwand án. ");
INSERT INTO bcc_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Man ke Ebráhém o Esák o Ákubay démá záher bután, man wati nám ‘Porwákén Hodá’ kort. Man á hál nadátant ke mani nám ‘Yahweh’ ent. ");
INSERT INTO bcc_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Man gón áyán ahd o paymán ham kort ke Kanhánay molká shomárá dayán, bezán hamá molká ke ódá á, darámaday paymá neshtagatant. ");
INSERT INTO bcc_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Man distag ke Mesrián Esráili golám kortagant o Esráili cha é golámiá nálagá ant. Man é nálag eshkotagant o wati ahd o paymánay yátá kaptagán. ");
INSERT INTO bcc_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Paméshká mani é paygámá Esráilián sar kan: ‘Man Hodáwand án. Man shomárá cha Mesriáni bigáriá kasshán o cha golámiá ázáta kanán. Dastá shahára dayán, Mesrián gránén sezá dayán o shomárá mókán. ");
INSERT INTO bcc_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Man shomárá zurán o wati kawma kanán o shomay Hodá bán. Gorhá shomá zánét ke man shomay Hodáwandén Hodá án, hamá ke shomárá cha Mesriáni bigáriá dari kortag. ");
INSERT INTO bcc_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Man shomárá hamá molká barán ke wati daston chest kort o sawgendon wárt ke Ebráhém o Esák o Ákubá dayáni. Man á molká shomárá dayán ke shomay jenday melkat bebit. Man Hodáwand án.’” ");
INSERT INTO bcc_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Mussáyá gón Esráilián é habar kortant, bale wati proshtagén arwáh o gránén zahmatáni sawabá Mussáay habaresh gósh nadásht. ");
INSERT INTO bcc_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Beraw o Mesray bádsháh Perawná begwash ke Esráilián cha wati molká rawagá bell.” ");
INSERT INTO bcc_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Bale Mussáyá gón Hodáwandá gwasht: “Mani habar Esráilián gósh nadáshtagant, gorhá Perawnesh chón gósha dárit? Man wa konthbayánén mardomé án.” ");
INSERT INTO bcc_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Hodáwandá gón Mussá o Háruná habar kort o hokm dátant ke gón Esráilián o gón Mesray bádsháh Perawná habar bekanét o Esráilián cha Mesray molká bekasshét. ");
INSERT INTO bcc_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Esráiliáni kabilaháni sar o master esh ant: Esráilay awali chokk Rubenay mardénchokk Hanuk o Pallu o Hesrun o Karmi atant. Rubenay thakk hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Shamunay mardénchokk Yamuél o Yámin o Uhad o Yákin o Sóhar o Shául atant. Sháulay mát Kanhánié at. Shamunay thakk hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Láwiay mardénchokkáni nám, áyáni pédáeshay red o banday hesábá esh ant: Gershón o Kohát o Merári. Láwiá 137 sál omr kort. ");
INSERT INTO bcc_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershónay mardénchokk Lebni o Shemmi atant, wati thakkáni hesábá. ");
INSERT INTO bcc_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohátay mardénchokk Amrám o Esár o Hebrun o Ozzél atant. Kohátá 133 sál omr kort. ");
INSERT INTO bcc_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meráriay mardénchokk Mahli o Mushi atant. Láwiay thakk, áyáni pédáeshay red o banday hesábá hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amrámá gón wati petay gohár Yukebédá sur kort o Hárun o Mussá cha Yukebédá pédá butant. Amrámá 137 sál omr kort. ");
INSERT INTO bcc_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Esáray mardénchokk Kórá o Nepeg o Zekri atant. ");
INSERT INTO bcc_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ozzélay mardénchokk Misháél o Elsápán o Setri atant. ");
INSERT INTO bcc_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Háruná gón Elishebahá sur kort. Elishebah Aminádábay jenekk at o Nahshunay gohár. Hárunay mardénchokk Nádáb o Abihu o Elyázar o Itámár cha Elishebahá pédá butant. ");
INSERT INTO bcc_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Kóráay mardénchokk Assir o Elkáná o Abyásáp atant. Kóráiáni thakk hamesh atant. ");
INSERT INTO bcc_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Hárunay mardénchokk Elyázará gón Putihélay janénchokkéá sur kort o cha é jenekká Pinehás pédá but. Láwiáni sar o master hamesh atant, wati thakkáni hesábá. ");
INSERT INTO bcc_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Hamé Hárun o Mussá atant ke Hodáwandá gón áyán gwasht: “Esráilián cha Mesrá romb rombá bekasshét.” ");
INSERT INTO bcc_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","É doénán, hamé Mussá o Háruná gón Mesray bádsháh Perawná habar kort ke Esráili cha Mesrá ázát kanag bebant. ");
INSERT INTO bcc_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Á róchá ke Hodáwandá Mesray molká gón Mussáyá habar kort, ");
INSERT INTO bcc_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","choshi gwasht: “Man Hodáwand án, harché ke tará gwashán, Mesray bádsháh Perawná begwashesh.” ");
INSERT INTO bcc_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Bale Mussáyá gón Hodáwandá gwasht: “Man konthbayánén mardomé án, Perawn chón mani habarán gósha dárit?” ");
INSERT INTO bcc_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Gorhá Hodáwandá gón Mussáyá gwasht: “Bechár, man tará pa Perawná chó Hodáyá kortag o tai brát Hárun tai nabia bit. ");
INSERT INTO bcc_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Harché ke tará hokma kanán, hamá paym gwashán kan. Tai brát Hárun báyad ent gón Perawná begwashit ke Esráilián cha wati molká rawagá bell. ");
INSERT INTO bcc_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Bale man Perawnay delá senga kanán. Man Mesray molká bázén ajabbatén nesháni o mójezahé pésha dárán, ");
INSERT INTO bcc_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","bale Perawn shomay habarán gósha nadárit. Man wati dastá Mesray helápá chesta kanán, Mesrián gránén sezá dayán o wati Esráili kawmá romb rombá cha Mesrá kasshán. ");
INSERT INTO bcc_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Wahdé wati dastá Mesray helápá chesta kanán o Bani Esráilá cha Mesriáni nyámá kasshán, nun Mesria zánant ke man Hodáwand án.” ");
INSERT INTO bcc_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mussá o Háruná anchosh kort. Hamá paymá ke Hodáwandá hokm dátagatant, áyán hamá paymá kort. ");
INSERT INTO bcc_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","É wahdá ke áyán gón Perawná habar kort, Mussáay omr hashtád sál at o Hárunay hashtád o say. ");
INSERT INTO bcc_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Hodáwandá gón Mussá o Háruná gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Perawn ke shomárá gwashit: ‘Mójezahé pésh bedárét’ gorhá taw Háruná begwash: ‘Wati asáyá bezur o Perawnay démá zeminá dawri day.’ Asá maré bit.” ");
INSERT INTO bcc_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mussá o Hárun Perawnay kerrá shotant o hamá paymá ke Hodáwandá hokm dátagatant, hamá paymá kortesh. Háruná wati asá Perawn o áiay hezmatkáráni démá zeminá dawr dát o asá maré but. ");
INSERT INTO bcc_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Gorhá Perawná dáná o sáher lótháéntant o é Mesri jádugerán gón wati jáduá hamé kár kort. ");
INSERT INTO bcc_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Cha áyán har yakkéá wati asá zeminá dawr dát o áyáni asá már butant. Hárunay asáyá áyáni asá wárt o ér bortant. ");
INSERT INTO bcc_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Bale anchó ke Hodáwandá gwashtagat, Perawnay del angat seng at o áyáni habari gósh nadáshtant. ");
INSERT INTO bcc_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Hodáwandá gón Mussáyá gwasht: “Perawnay del seng ent o mardomán rawagá naylit. ");
INSERT INTO bcc_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Sohbá ke Perawn ápay kerrá rawt, taw beraw o Nillay kawray lambá áiay ráhay sará bósht o már butagén asáyá dastá kan. ");
INSERT INTO bcc_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Gón Perawná begwash: ‘Hodáwandá, bezán Ebrániáni Hodáyá maná tai kerrá ráh dátag ke tará begwashán: “Mani mahluká bell ke gyábáná rawt o maná parastesha kant,” bale taw angat gósh dáragá naay. ");
INSERT INTO bcc_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Hodáwand chosha gwashit ke tawe Perawn cha é neshániá zánay ke man Hodáwand án: Bechár, é asá ke mane Mussáay dastá ent, man eshiá kawray ápá janán o áp hón jórha bant. ");
INSERT INTO bcc_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Kawray máhiga merant, kawr bóa kant o Mesri kawray ápá wárta nakanant.’” ");
INSERT INTO bcc_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Hodáwandá gón Mussáyá gwasht: “Háruná begwash: ‘Wati asáyá dastá kan o dastá Mesray ápáni sará shahár day, áyáni kawráni sará, áyáni jóáni sará, áyáni taláwagáni sará o áyáni sajjahén ápjalláni sará. Esháni tahay sajjahén áp hón jórha bant. Sajjahén Mesray molk hóná porra bit, ápdán ham cha hóná porra bant.’” ");
INSERT INTO bcc_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mussá o Háruná hamá paymá kort ke Hodáwandá hokm dátagatant. Háruná Perawn o hezmatkáráni chammáni démá wati asá chest kort o kawray ápáni sará jat. Kawray sajjahén áp hón jórh butant. ");
INSERT INTO bcc_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kawray máhig mortant, kawrá bó kort o Mesrián kawray áp wárt nakort. Sajjahén Mesray molká hón tachagá at. ");
INSERT INTO bcc_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Bale Mesri jádugerán ham gón wati jáduá hamé kár kort o hamá paymá ke Hodáwandá gwashtagat, Perawnay del seng at o Mussá o Hárunay habari gósh nadáshtant. ");
INSERT INTO bcc_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Perawná posht mán dát o wati kalátá shot o é gappi hecch mán nayáwort. ");
INSERT INTO bcc_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Sajjahén Mesrián pa waragi ápá kawray kash o kerrán kánig janag bendát kort, chéá ke kawray ápesh wárta nakort. ");
INSERT INTO bcc_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Cha á wahdá ke Hodáwandá Nillay kawray sará é kahr dawr dát, hapt róch gwast. ");
INSERT INTO bcc_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Nun Hodáwandá gón Mussáyá gwasht: “Perawnay kerrá beraw o gón áiá begwash: ‘Hodáwand chosha gwashit: “Mani mahluká bell ke rawt o maná parastesha kant. ");
INSERT INTO bcc_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Agan mani mahluká rawagá maylay, bechár, man tai sajjahén molkay sará pogolay kahré dawra dayán. ");
INSERT INTO bcc_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Nillay kawr cha pogolá porra bit. Pogol chesta bant o tai lógá káyant, tai wábjáhá poterant o tahtá sara kapant, tai hezmatkár o mardománi lógán ham káyant, tai tarun o árt tarr kanagay darpáni tahá dawra kanant. ");
INSERT INTO bcc_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Pogol tai jend o tai mardom o tai sajjahén hezmatkárán pera rechant.”’” ");
INSERT INTO bcc_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Hodáwandá padá gón Mussáyá gwasht: “Háruná begwash: ‘Wati asáyá dastá kan o dastá kawr o jó o taláwagáni sará shahár day o Mesray molká cha pogolá porr kan.’” ");
INSERT INTO bcc_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Háruná wati dast Mesray ápáni sará shahár dát, pogol dar átk o Mesray molká mán retkant. ");
INSERT INTO bcc_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Bale jádugerán ham gón wati jáduá anchosh kort o pogol cha ápán dar átk o Mesray molká sheng butant. ");
INSERT INTO bcc_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Perawná Mussá o Hárun lótháéntant o gwashti: “Hodáwanday kerrá dwá kanét ke pogolán cha man o mani mardomán dur bebárt. Man shomay mahluká rawagá kellán ke pa Hodáwandá korbánig bekant.” ");
INSERT INTO bcc_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mussáyá gón Perawná gwasht: “Ji, hokm kan. Kadi pa taw o pa tai hezmatkár o mardomán dwá bekanán ke pogol cha taw o cha tai lógán gár o bégwáh bebant o tahná kawrá bejallant?” ");
INSERT INTO bcc_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Perawná gwasht: “Bándá.” Mussáyá gwasht: “Anchosha bit ke taw gwashay. Pogol cha taw o tai lógán, cha tai hezmatkár o mardomán dura bant o tahná kawrá jallant, tánke taw bezánay ke may Hodáwandén Hodáay matth nést.” ");
INSERT INTO bcc_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Mussá o Hárun cha Perawnay kerrá shotant. Mussáyá Hodáwanday kerrá peryát kort, hamá pogoláni bárawá ke Hodáwandá Perawnay chakká dawr dátagatant. ");
INSERT INTO bcc_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Hodáwandá Mussáay dwá gósh dásht o pogol, lóg o péshgáh o dhagárán mortant. ");
INSERT INTO bcc_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Pogolesh kót kótá mocch kanán kortant. Zemin bó gept. ");
INSERT INTO bcc_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Wahdé Perawná dist ke cha é kahrá ján chotthet, hamá paymá ke Hodáwandá gón Mussáyá gwashtagat, Perawná wati del seng kort o Mussá o Hárunay habari gósh nadáshtant. ");
INSERT INTO bcc_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Hodáwandá gón Mussáyá gwasht: “Háruná begwash: ‘Wati asáyá shahár day o zeminay hákán bejan ke sajjahén Mesrá passhag mán berechit.’” ");
INSERT INTO bcc_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Áyán anchosh kort. Háruná wati dast gón asáyá shahár dát o zeminay háki jatant. Sajjahén Mesrá, zeminay hák badal but o passhag butant o mardom o jánwarán per retkant. ");
INSERT INTO bcc_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Jádugerán gón wati jáduá was kort ke passhag byárant, bale áwortesh nakort. Passhag mardom o jánwarán per lecchetagatant. ");
INSERT INTO bcc_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Jádugerán gón Perawná gwasht: “É Hodái káré.” Bale hamá paymá ke Hodáwandá gwashtagat, Perawnay del seng at o Mussá o Hárunay habari gósh nadáshtant. ");
INSERT INTO bcc_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Hodáwandá gón Mussáyá gwasht: “Sohbá máhallah pád á o wahdé Perawn dém pa ápá rawt, áiay démá dar á o begwashi: ‘Hodáwand chosha gwashit: “Mani mahluká bell ke rawt o maná parastesha kant. ");
INSERT INTO bcc_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Chéá ke agan mani mahluká rawagá maylay, bechár, man tará o tai hezmatkár o tai mardomán o tai lógán makeskgranda kanán. Mesriáni lóg cha makeská porra bant o hamá zemin ham ke ódá áyáni lóg bastagant. ");
INSERT INTO bcc_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Bale á róchá man Góshenay damagá ke ódá mani mahluk neshtag, é kahrá nayárán. Ódá makeskgranda nabit. É paymá taw zánay ke é molká Hodáwand man án. ");
INSERT INTO bcc_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Man wati mahluk o tai mahlukay nyámá park o péra kanán o é nesháni bándá záhera bit.”’” ");
INSERT INTO bcc_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Hodáwandá anchosh kort. Makeskáni sehr Perawn o áiay hezmatkáráni lógán per retkant. Makeskán sajjahén Mesr tabáh kort. ");
INSERT INTO bcc_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Perawná Mussá o Hárun lótháént o gwashtant: “Berawét o pa wati Hodáyá korbánig bekanét, bale hamé molkay tahá.” ");
INSERT INTO bcc_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Bale Mussáyá gwasht: “Má chó korta nakanén. Chéá ke má pa wati Hodáwandén Hodáyá anchén korbániga kanén ke pa Mesrián bazhnák ant. Agan má Mesriáni chammáni démá anchén korbánig bekanén ke pa áyán bazhnák ant, márá sengsára nakanant? ");
INSERT INTO bcc_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Má báyad ent gyábáná say róchay ráhá berawén o pa wati Hodáwandén Hodáyá korbánig bekanén, hamá paymá ke Hodáyá márá gwashtag.” ");
INSERT INTO bcc_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Perawná gwasht: “Man shomárá rawagá kellán ke gyábáná pa wati Hodáwandén Hodáyá korbánig bekanét. Bale sakk dur marawét o pa man ham dwá kanét.” ");
INSERT INTO bcc_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Mussáyá gwasht: “Bechár, man cha tai kerrá dara káyán o Hodáwanday bárgáhá dwá kanán. Bándá makesk cha tawe Perawn o tai hezmatkár o mardomán dura káyant. Bale chó mabit ke tawe Perawn padá makr o préb bekanay o mardomán maylay ke berawant o pa Hodáwandá korbánig bekanant.” ");
INSERT INTO bcc_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Mussá cha Perawnay kerrá dar átk o Hodáwanday bárgáhá dwái kort o ");
INSERT INTO bcc_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Hodáwandá Mussáay dwá gósh dásht. Makeskán cha Perawn o áiay hezmatkár o mardománi kerrá bál kort. Yakk dánagé makesk ham pasht nakapt. ");
INSERT INTO bcc_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Bale é randi padá Perawná wati del seng kort o mardomi rawagá naeshtant. ");
INSERT INTO bcc_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Hodáwandá gón Mussáyá gwasht: “Perawnay kerrá beraw o gón áiá begwash: ‘Hodáwand, Ebrániáni Hodá chosha gwashit: “Mani mahluká bell ke rawt o maná parastesha kant. ");
INSERT INTO bcc_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Chéá ke agan áyán rawagá maylay o angat áyán bedáray, ");
INSERT INTO bcc_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","Hodáwand dastá shahára dant o kahcharán, tai mál o dalwatáni sará sakkén gránén wabáé dawra dant, tai har o asp o oshter o pas o gókáni sará. ");
INSERT INTO bcc_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Bale Hodáwand Esráili o Mesriáni mál o dalwatáni nyámá park o péra kant o cha Esráiliáni mál o dalwatán yakké ham namerit.”’” ");
INSERT INTO bcc_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Hodáwandá yakk wahdé gisshént o gwashti: “Bándá é molká mane Hodáwand é kárá kanán.” ");
INSERT INTO bcc_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Domi róchá Hodáwandá é kár kort. Mesriáni sajjahén mál o dalwat mortant, bale cha Esráiliáni mál o dalwatán yakké ham namort. ");
INSERT INTO bcc_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Perawná pa pakká kanagá mardom ráh dát o sahig but ke cha Esráiliáni mál o dalwatán yakké ham namortag. Bale Perawnay del angat seng at o mahluki rawagá naesht. ");
INSERT INTO bcc_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Hodáwandá gón Mussá o Háruná gwasht: “Cha kurahéá chanké chanké por bezurét, o Mussá eshán Perawnay démá ásmánay némagá shánk bedant. ");
INSERT INTO bcc_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","É por danza bant o sajjahén Mesray molkay sará mána shánant o sajjahén Mesrá ensán o jánwaráni jáná ábelahén résh o sóm pédá kanant.” ");
INSERT INTO bcc_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Mussá o Háruná cha kurahéá por zort o Perawnay démá óshtátant. Mussáyá por ásmánay némagá shánk dátant o é porán ensán o jánwaráni jáná ábelahén résh o sóm pédá kort. ");
INSERT INTO bcc_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Résháni sawabá jádugerán Mussáay démá óshtát nakort, chéá ke jáduger o sajjahén Mesriáni jáná sóm dar átkagat. ");
INSERT INTO bcc_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Bale Hodáwandá Perawnay del seng kort o hamá paymá ke Hodáwandá gón Mussáyá gwashtagat, Perawná áyáni habar gósh nadáshtant. ");
INSERT INTO bcc_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Hodáwandá gón Mussáyá gwasht: “Sohbá máhallah pád á, Perawnay démá dar á o begwashi: ‘Hodáwand, Ebrániáni Hodá chosha gwashit: “Mani mahluká bell ke rawt o maná parastesha kant. ");
INSERT INTO bcc_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Chéá ke é randi man wati sajjahén kahrán tai jend o tai hezmatkár o tai mardománi sará dawra dayán ke taw bezánay ke sajjahén donyáyá mani paymén nést. ");
INSERT INTO bcc_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Chéá ke agan man belóthetén, déri wati daston shahár dátagat o tai o tai mardománi sará kahré dawr dátagat o taw cha jaháná gár o gomsár butagatay. ");
INSERT INTO bcc_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Bale tará paméshká zendagá eshton ke wati zór o wáká tará pésh bedárán o sajjahén jaháná mani námay jár janag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Bale taw angat mani mahlukay dém dáshtag o rawagáesha naylay. ");
INSERT INTO bcc_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Bechár, bándá hamé wahdá man anchén trondén tróngalé gwárénán ke cha ed o pésh Mesrá hechbar nabutag, cha hamá wahdá beger ke Mesray bonpad ér kanag butag tán róche maróchigá. ");
INSERT INTO bcc_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Nun hokm day ke tai hamá mál o dalwat o é dega sajjahén chizz ke dhanná ant, áyán panáhén jágahé bebarant. Har mardom o dalwat ke dhanná but o panáh kanag nabut, é tróngal áiá laggant o á merit.”’” ");
INSERT INTO bcc_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Perawnay á hezmatkárán ke cha Hodáwanday habarán torset, hamá damáná wati golám o dalwatesh panáh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Bale hamáyán ke Hodáwanday habar mán nayáwortant, wati golám o dalwatesh dhanná eshtant. ");
INSERT INTO bcc_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Hodáwandá gón Mussáyá gwasht: “Wati dastá ásmánay némagá shahár day ke sajjahén Mesray molká tróngal begwárit, ensán o jánwar o Mesray dhagáráni har drachk o dáray sará.” ");
INSERT INTO bcc_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Mussáyá wati asá ásmánay némagá shahár dát o Hodáwandá grand o tróngal ráh dát o zeminá bir kapt. Hodáwandá Mesray molká tróngal gwárént. ");
INSERT INTO bcc_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Tróngalá gwart o tróngalay wahdá geróká pa damáné ham bass nakort. Anchó tróngal but ke Mesrá pésará hechbar nabutagat, cha hamá wahdá ke Mesr molké jórh butag. ");
INSERT INTO bcc_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Sajjahén Mesrá harché ke dhanná at, tróngalá jat o prósht, ensáná beger tán jánwará. Dhagáráni sajjahén keshár o drachki ham jat o próshtant. ");
INSERT INTO bcc_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Tahná Góshenay damagá tróngalá nagwart, hamódá ke Bani Esráil neshtagat. ");
INSERT INTO bcc_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Perawná Mussá o Hárun lótháént o gwashtant: “É bari man gonáh kortag. Hodáwand barhakk ent o man o mani mardom mayárbár én. ");
INSERT INTO bcc_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Hodáwanday kerrá dwá bekanét ke é baláhén grand o tróngalá márá kosht. Man shomárá rawagá kellán. Shomárá cha ed o géshter edá nadárán.” ");
INSERT INTO bcc_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mussáyá gwasht: “Man anchó ke cha shahrá dara káyán, wati dastán Hodáwanday némagá chesta kanán. Granda óshtit o tróngalay gwárag banda bit ke taw bezánay ke donyá Hodáwandayg ent. ");
INSERT INTO bcc_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Bale mana zánán ke tará o tai hezmatkárán angat cha Hodáwandén Hodáyá natorsit.” ");
INSERT INTO bcc_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Kattán o jaway keshár tabáh butant, chéá ke jawá hóshag o kattáná poll jatagat. ");
INSERT INTO bcc_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Bale gandom o gallahay keshár tabáh nabutant ke esháni mósom randá kayt. ");
INSERT INTO bcc_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Mussá cha Perawnay kerrá shot o cha shahrá ke dar átk, dasti Hodáwanday némagá chest kortant. Grand o tróngal óshtátant o hawrá gwárag bass kort. ");
INSERT INTO bcc_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Wahdé Perawná dist ke hawr o tróngal o grand óshtátant, padá gonáhi bená kort. Perawn o áiay hezmatkárán wati del seng kort. ");
INSERT INTO bcc_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Perawnay del seng but. Esráilii rawagá naeshtant, hamá paymá ke Hodáwandá cha Mussáay zobáná gwashtagat. ");
INSERT INTO bcc_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Hodáwandá gón Mussáyá gwasht: “Perawnay kerrá beraw. Man Perawnay del o áiay hezmatkáráni del paméshká seng kortagant ke wati é neshánián áyáni démá záher bekanán o ");
INSERT INTO bcc_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","shomá gón wati chokk o nomásagán kessah bekanét ke man chón Mesri layb dáshtant o áyáni nyámá wati nesháni záher kortant, tánke shomá bezánét ke man Hodáwand án.” ");
INSERT INTO bcc_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mussá o Hárun Perawnay kerrá shotant o gwashtesh: “Hodáwand, Ebrániáni Hodá chosha gwashit: ‘Tán kadén gorunáka bay o mani démá óshtay o watá békebra nakanay? Mani mahluká bell ke rawt o maná parastesha kant. ");
INSERT INTO bcc_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Agan mani mahluká rawagá maylay, bechár, man bándá tai molká madagé mána réchán. ");
INSERT INTO bcc_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Madag sajjahén molká anchosha póshit ke kass zeminá dista nakant. Harché ke cha tróngalá pasht kaptag, madagesha wárt. Tai hamok drachk o dár ke zeminá rodit, áiá ham warant. ");
INSERT INTO bcc_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Madag tai o tai hezmatkár o sajjahén Mesriáni lógán anchó mána rechant ke shomay pet o pirokán nadistag, cha hamá wahdá beger ke á é zeminá butagant, tán é wahdá.’” Mussáyá posht mán dát o cha Perawnay kerrá shot. ");
INSERT INTO bcc_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Hezmatkárán gón Perawná gwasht: “Tán kadi é mard may gotthá lóp ent? Belli mardoma rawant o wati Hodáwandén Hodáay parasteshá kanant. Mesr tabáh ent, taw angat sarpada nabay?” ");
INSERT INTO bcc_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mussá o Hárunesh padá Perawnay kerrá áwortant o Perawná gón áyán gwasht: “Berawét o wati Hodáwandén Hodáyá parastesh bekanét. Cha shomá kay kay rawt?” ");
INSERT INTO bcc_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mussáyá gwasht: “Má gón wati warná o pirénána rawén. Gón wati mardénchokk o janénchokkán, gón wati pas o gókána rawén. Chéá ke márá pa Hodáwandá jashné geragi ent.” ");
INSERT INTO bcc_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Perawná gwasht: “Hodáwand allamá shomay posht o panáh butagat, agan man shomárá gón chokkán rawagá beshtén. Bechár, shomárá pakkáyá radén káré delá ent. ");
INSERT INTO bcc_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Enna, tahná shomá mardén berawét o Hodáwandá parastesh bekanét. Shomay lóth hamé butag.” Mussá o Hárunesh cha Perawnay kerrá galléntant. ");
INSERT INTO bcc_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Hodáwandá gón Mussáyá gwasht: “Wati dastá Mesray molkay sará shahár day ke madag Mesray sará orosh bekanant o molkay sajjahén drachk o dárán bwarant, harché ke cha tróngalá rakketag.” ");
INSERT INTO bcc_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Mussáyá wati asá Mesray molkay sará shahár dát. Cha Hodáwanday hokmá á sajjahén róchá o sajjahén shapá molká ródarátki gwátéá sar kort. Tán sohbá gwátá molk cha madagá porr kortagat. ");
INSERT INTO bcc_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Sajjahén Mesray molká madag kapt o sarjamén Mesrá mán retk. Madagay choshén sehr na pésará butag o na démterá bit. ");
INSERT INTO bcc_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Sarjamén zeminesh póshet o syáh syáh kort. Zeminay hamá sajjahén drachk o dár o drachkáni hamá sajjahén nibag ke cha tróngalá rakketagatant, madagán wártant. Sarjamén Mesrá hecch sabzén chizzé pasht nakapt, na drachké, na káhé. ");
INSERT INTO bcc_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Perawná damáná Mussá o Hárun gwánk jat o gwashtant: “Man shomay Hodáwandén Hodáay o shomay gonahkár án. ");
INSERT INTO bcc_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","É yakkén randá mani gonáhá bebakshét o cha wati Hodáwandén Hodáyá dwá belóthét ke é malkamutá cha mani sará bethagalénit.” ");
INSERT INTO bcc_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mussá cha Perawnay kerrá shot o cha Hodáwandá dwái lóthet. ");
INSERT INTO bcc_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Hodáwandá gwátay dém tarrént o sakkén trondén rónendi gwáté kort. Gwátá madag bort o Sohrzerá dawr dátant. Sajjahén Mesrá yakk dánagé madag ham pasht nakapt. ");
INSERT INTO bcc_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Bale Hodáwandá Perawnay del seng kort o áiá Esráili rawagá naeshtant. ");
INSERT INTO bcc_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Hodáwandá gón Mussáyá gwasht: “Wati dastá ásmánay némagá shahár day ke Mesray molká tahárié mán beshánit, anchén bazén tahárié ke chamm pa chammá gendag mabit.” ");
INSERT INTO bcc_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Mussáyá wati dast ásmánay némagá shahár dát o bazén taháriéá sajjahén Mesr tán say róchá mán póshet. ");
INSERT INTO bcc_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tán say róchá kassá kass nadist o kass cha wati jágahá pád nayátk. Bale Esráiliáni sajjahén hankén rozhná atant. ");
INSERT INTO bcc_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Perawná Mussá lótháént o gwashti: “Berawét o Hodáwanday parasteshá bekanét. Bass shomay ramag o górom hamedá dáraga bant. Wati chokkán ham barét gón.” ");
INSERT INTO bcc_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mussáyá gwasht: “Taw báyad ent márá helárig o sóchagi korbánigáni baragá ham bellay ke má pa wati Hodáwandén Hodáyá korbánigesh bekanén. ");
INSERT INTO bcc_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Báyad ent má wati mál o dalwatán ham bebarén gón. Yakk srombé ham pasht makapit, chéá ke má cha eshán lahtén pa wati Hodáwandén Hodáyá gechéna kanén o tánke má ódá sar mabén, nazánén kojámiá pa Hodáwandá korbánig bekanén.” ");
INSERT INTO bcc_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Hodáwandá Perawnay del seng kort o Perawn áyáni rawagá rázig nabut. ");
INSERT INTO bcc_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Perawná gón Mussáyá gwasht: “Thagal cha mani démá! Habardár. Dega baré mani démá nakapay. Mani démá kaptay, tai mark ent.” ");
INSERT INTO bcc_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mussáyá gwasht: “Harché taw gwashay. Man dega baré tai démá nakapán.” ");
INSERT INTO bcc_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Hodáwandá gón Mussáyá gwasht: “Man Perawn o Mesray sará dega yakk kahré dawra dayán. Eshiá rand á shomárá cha edá rawagá kellit. Rawagay habará bell, shomárá sarjamiá cha edá gallénit. ");
INSERT INTO bcc_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Mahluká begwash ke harkas, har mardén o har janén wati hamsáhegay kerrá cha nograh o teláhá addh butagén sámán belóthit.” ");
INSERT INTO bcc_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Hodáwandá Mesriáni nezar pa wati mahluká nék kort. Mussáay jend ham Mesray molká Perawnay hezmatkár o mardománi chammán sakkén mazanén mardomé but. ");
INSERT INTO bcc_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mussáyá gwasht: “Hodáwanda gwashit: ‘Man shapay némá dara káyán o sajjahén Mesrá gardán. ");
INSERT INTO bcc_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Bádsháhi tahtá neshtagén Perawnay awali chokká beger tán jenteray sará neshtagén móledéay awali chokká, Mesrá sajjahén awali mardenchokka merant. Sajjahén mál o dalwatáni awali narén chokk ham merant. ");
INSERT INTO bcc_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Sarjamén Mesrá anchén mazanén gréwag o zárié chesta bit ke na pésará butag o na démterá bit, ");
INSERT INTO bcc_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","bale Bani Esráilay sará kochekké ham nawakkit, na mardoméay sará o na dalwatéay sará.’ Gorhá shomá zánét ke Hodáwand Esráil o Mesray nyámá park o péra kant. ");
INSERT INTO bcc_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Tai é sajjahén hezmatkár mane Mussáay kerrá káyant o kóndhána kapant o gwashant: ‘Dar á, tai jend gón hamá sajjahén mardomán ke tai randgir ant.’ Gorhá man cha é molká dara káyán o rawán.” Nun Mussá zahrá zahr cha Perawnay kerrá dar átk o shot. ");
INSERT INTO bcc_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Hodáwandá gón Mussáyá gwasht: “Perawn shomay habarán gósha nadárit. Paméshká Mesrá mane Hodáwanday mójezah géshtera bant.” ");
INSERT INTO bcc_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mussá o Háruná Perawnay démá é sajjahén mójezah pésh dáshtant, bale Hodáwandá Perawnay del seng kort o Perawná Esráili cha wati molká rawagá naeshtant. ");
INSERT INTO bcc_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Hodáwandá Mesray molká gón Mussá o Háruná gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“É máh pa shomá bendáti máha bit, pa shomá sálay awali máha bit. ");
INSERT INTO bcc_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Esráilay sajjahén mahluká begwashét ke é máhay dahomi róchá har lóg o hándán pa wat pasé bezurit, har lóg yakk pasé. ");
INSERT INTO bcc_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Agan lógéay mardom anchó kamm bebant ke purahén pasé pa áyán báz bebit, gorhá á o áyáni nazzikterén hamsáheg hór bebant o yakk pasé bezurant. Mardomán hesáb kanét o bechárét ke yakk mardomé chinchoka wárt, o hamá andázahén pasé bezurét. ");
INSERT INTO bcc_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Shomay pas allamá béayb bebit, omrá yakk sálié bebit o naréné bebit. Gwarándhé zurét sharr o páchené zurét sharr. ");
INSERT INTO bcc_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Tán é máhay chárdahomi róchá bedáréti. Sajjahén Esráili mahluk magrebtahárá wati wati pasá helár bekant. ");
INSERT INTO bcc_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Mardom kammé hón bezurant o hamá lógá ke é góshtá warant, á lógay darwázagay chánthá, bezán darwázagay sarborá o kashán é hóná per bemoshant. ");
INSERT INTO bcc_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Á báyad ent hamá shapá góshtá ásá bepachant o gón béhomirén nagan o tahlén káhoká bwaranti. ");
INSERT INTO bcc_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","É góshtá hámagá mawarét o ápgrádi ham makanét o mawaréti. Gón sarag o pádag o delig o lápigán ásá pachét o bwaréti. ");
INSERT INTO bcc_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Tán sohbá cha áiá hecch pasht makapit. Agan tán sohbá chizzé sar átk, ásá besóchéti. ");
INSERT INTO bcc_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Chó bwaréti: watá pa sapará tayár bekanét, swásán pádá kanét o asáyá dastá kanét o eshtáp eshtápá bwarét. É Hodáwanday Sargwaz ent. ");
INSERT INTO bcc_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Man hamé shapá Mesrá gardána bán o molkay sajjahén awali mardénchokkána janán. Ensánán beger tánke dalwatáni awali chokkána janán o Mesray sajjahén hodáyán sezá dayán. Man Hodáwand án. ");
INSERT INTO bcc_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Lógán per moshtagén é hón shomay neshánia bit ke edá shomá ét. Man é hónán ke gendán, cha shomá sara gwazán o wahdé Mesrá tabáhiay kahré dawra dayán, é kahr shomay sará nakapit. ");
INSERT INTO bcc_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","É pa shomá yátgárén róché bebit. Shomá báyad ent é róchá Hodáwanday námá jashné bekanét. Nasláni nasl é jashná abadi parmánéay hesábá barjáh bedárét. ");
INSERT INTO bcc_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Hapt róchá béhomirén nagan bwarét. Harché homir ke shomay lógán hast, awali róchá dawresh bedayét. Chéá ke harkasá ke awali róchá beger tán haptomi róchá homiri chizzé wárt, á mardom cha Esráilay kawmá sendaga bit. ");
INSERT INTO bcc_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Awali róchá pákén diwáné bekanét o haptomi róchá ham. É doén róchán hecch kár makanét, bass pa waragá warák tayár kanét. Hamé yakkén kárá korta kanét. ");
INSERT INTO bcc_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Béhomirén Naganay Aidá barjáh bedárét, chéá ke hamé róchá man shomárá romb rombá cha Mesrá dar kort. Nasláni nasl é róchá abadi parmánéay hesábá barjáh bedárét. ");
INSERT INTO bcc_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Awali máhá, chárdahomi róchay bégáhá beger tán bist o yakkomi róchay bégáhá béhomirén nagan bwarét. ");
INSERT INTO bcc_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Tán hapt róchá shomay lógán homir mabit. Chéá ke harkasá ke homiri chizzé wárt, á mardom cha Esráilay mahluká sendaga bit, harkas bebit, darámadé yá molki mardomé. ");
INSERT INTO bcc_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Hecch homiri chizz mawarét. Wati sajjahén métagán béhomirén nagan bwarét.” ");
INSERT INTO bcc_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Mussáyá Esráilay sajjahén kamásh lótháéntant o gón áyán gwashti: “Berawét o pa wat, pa wati lógán pas bezurét. É pas Sargwazay korbánig ent, helári kanét. ");
INSERT INTO bcc_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Bandoké zupá bezurét, trashtay tahay hónáni bejanét o wati lógáni darwázagay chánthá, sarbor o doén kasháni dárán peri moshét, cha hamé hónán ke trashtay tahá ant. Tán sohbá cha shomá kass cha lógay darwázagá dhann dar mayayt. ");
INSERT INTO bcc_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Hodáwand pa Mesriáni janagá gardána bit, bale wahdé shomay chántháni saray hónána gendit, gorhá cha á darwázagá sara gwazit o tabáh kanóká shomay lógán poterag o shomay janagá naylit. ");
INSERT INTO bcc_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Shomá é rasmá tán abad barjáh bedárét, é pa shomá o shomay chokkán abadi parmáné. ");
INSERT INTO bcc_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Wahdé shomá hamá molká sara bét ke Hodáwand wati wádahay hesábá shomárá danti, ódá é rasmá barjáh bedárét. ");
INSERT INTO bcc_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Shomay chokk ke cha shomá josta kanant ke é chónén rasmé, ");
INSERT INTO bcc_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","begwashét ke é pa Hodáwandá Sargwazay korbánigé, chéá ke Hodáwandá, Mesrá Esráiliáni lóg sargwaz kortant. Wahdé Hodáwandá Mesri jatant, may lógáni sará hayri kort.” Gorhá mardomán sar jahl kort o parasteshá laggetant. ");
INSERT INTO bcc_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Esráili shotant o hamá paymá ke Hodáwandá Mussá o Hárun hokm dátagatant, hamá paymá kortesh. ");
INSERT INTO bcc_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Hamá shapay némá Hodáwandá, Mesray molká sajjahén awali mardénchokk jatant. Sháhi tahtá neshtagén Perawnay awali chokká beger tán zendáná neshtagén bandigéay awali chokk, o mál o dalwatáni sajjahén awali narén chokk, sajjahén mortant. ");
INSERT INTO bcc_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Shapá Perawn o áiay sajjahén hezmatkár o sajjahén Mesri pád átkant. Mesrá mazanén gréwag o zárié chest at. Choshén lógé néstat ke ódá yakké namortagat. ");
INSERT INTO bcc_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Shapay shap Perawná Mussá o Hárun lótháéntant o gwashti: “Chest bét o cha mani molk o mardomán dur bét, shomay jend o sajjahén Esráili. Berawét o Hodáwandá parastesh kanét, hamá paymá ke shomá lóthetag. ");
INSERT INTO bcc_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Wati ramag o góromán ham barét gón, hamá paymá ke shomá wat gwashtag. Pa man ham barkat belóthét.” ");
INSERT INTO bcc_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mesrián Esráili hojj kort o gwashtant ke shomá cha may molká zutt dar áét ke má sajjahéna merén. ");
INSERT INTO bcc_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Mardomán tarr kortagén béhomirén árt, cha gwát geragá pésar gón darpán zort o wati chaderán kort o baddhá jatant. ");
INSERT INTO bcc_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Esráilián hamá paymá kortagat ke Mussáyá gwashtagatant. Áyán Mesriáni kerrá god o cha nograh o teláhá addh butagén sámán lóthetagat. ");
INSERT INTO bcc_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Hodáwandá ham Mesriáni nezar pa Esráilián nék kortagat. Paméshká áyán harché lóthetagat, Mesrián dátagat. É paymá Mesriáni dawlatesh bort. ");
INSERT INTO bcc_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Esráili cha Ramesésá dém pa Sokkutá sar geptant. Janén o chokkán abéd, á kesás shash sad hazár payádagén mardén atant. ");
INSERT INTO bcc_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Hór o hawárén mardománi baláhén rombé ham gón áyán shot gón. Esráilián báz ramag o górom, sakk báz mál o dalwat gón at. ");
INSERT INTO bcc_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Hamá tarr kortagén árt ke cha Mesrá gón atantesh, cha áyán béhomirén kólokesh patk. Mardom cha Mesrá gallénag butagatant, paméshká chánag béhomir atant. Áyán natwánt mahtal bebant o pa wati tóshagá warák addh bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Esráilián chár sad o si sál Mesrá gwázéntagat. ");
INSERT INTO bcc_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","É chár sad o sién sáláni godhsará, goddhi róchay jendá, Hodáwanday sajjahén mahluk romb rombá cha Mesrá dar átk. ");
INSERT INTO bcc_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","É sajjahén shapá Hodáwandá áyáni negahpáni kort ke áyán cha Mesrá dar bekant, paméshká é shap pa Esráilián Hodáwanday námá shappásié o báyad ent sajjahén Esráili é shappásiá nasláni nasl barjáh bedárant. ");
INSERT INTO bcc_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Hodáwandá gón Mussá o Háruná gwasht: “Esh ent Sargwazay waragay parmán: hecch dhanni mardom eshiá mawárt, ");
INSERT INTO bcc_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","zarharidén golám wártia kant bale cha sonnat bayagá rand. ");
INSERT INTO bcc_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Hamá mardom ke pa gwandhén moddatéá átkag o neshtag, á ham mawárt o hamá nawkar ham mawárt ke pa zarr shomay kerrá kárá ent. ");
INSERT INTO bcc_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Yakkén lógay tahá bebét o bwaréti. Cha Sargwazay góshtá toshé dhanná mabarét o pasay yakk haddhé ham mapróshét. ");
INSERT INTO bcc_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Sargwazay róchá Esráilay sajjahén mahluk aid bekant. ");
INSERT INTO bcc_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Agan shomay nyámá dhanni mardomé neshtag o Sargwazay róchá Hodáwanday námá aid kanaga lóthit, áiay lógay sajjahén mardén pésará sonnat kanag bebant. Gorhá á mardom bahr zorta kant o molki mardománi paymá bit. Bale hecch sonnat nakortagén mardén eshiá mawárt. ");
INSERT INTO bcc_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Eshiay kánun yakk ent, pa molki mardomán o pa hamá dhanni mardomán ke shomay nyámá neshtagant.” ");
INSERT INTO bcc_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Hamá paymá ke Hodáwandá Mussá o Hárun hokm dátagatant, sajjahén Esráilián hamá paymá kort. ");
INSERT INTO bcc_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Hamá róchay jendá Hodáwandá Esráili, romb rombá cha Mesrá dar kortant. ");
INSERT INTO bcc_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Sajjahén awali mardénchokkán gisshén o pa man wapk bekan. Esráilay sajjahén awali chokk manig ant, ensánáni chokk bebant yá dalwatáni.” ");
INSERT INTO bcc_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mussáyá gón mardomán gwasht: “É róchá mashamóshét ke shomá hamé róchá cha Mesrá dar átkagét, cha hamá molká ke ódá golám butagét o Hodáwandá gón wati dastay zórá shomárá cha ódá dar kortag o áwortag. Homiri nagan mawarét. ");
INSERT INTO bcc_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Shomá maróchigén róchá, Abibay máhá cha edá dara kapét. ");
INSERT INTO bcc_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Wahdé Hodáwand shomárá Kanháni o Hitti o Amuri o Héwi o Yabusiáni molká bárt, hamá molká ke gón shomay pet o pirokán sawgendi wártag ke shomárá danti, hamá molká ke ódá shir o bénagay jó tachagá ant, ódá é rasmá hamé máhá barjáh bedárét. ");
INSERT INTO bcc_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Tán hapt róchá béhomirén nagan bwarét o haptomi róchá Hodáwanday námá aidé bekanét. ");
INSERT INTO bcc_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Tán hapt róchá béhomirén nagan bwarét. Shomay kerrá o shomay hadd o simsaráni tahá hecch homir dast makapit. ");
INSERT INTO bcc_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","É aidá ke kanét, harkas gón wati chokká begwashit: ‘Cha Mesrá dar kapagay wahdá Hodáwandá pa man hamá kár ke kort, man hamá káray háterá é aidá kanán.’ ");
INSERT INTO bcc_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Wati dastá nesháné o péshánigá yátgéjé per kan ke Hodáwanday Sharyat tai dapá bebit. Chéá ke Hodáwandá gón wati porzórén dastá tará cha Mesrá dar kort. ");
INSERT INTO bcc_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","É parmáná sál pa sál barjáh bedár, eshiay gisshéntagén wahdá. ");
INSERT INTO bcc_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Wahdé Hodáwand shomárá Kanhániáni molká bárt o hamá paymá ke gón shomá o shomay bonpirokán sawgendi wártag, á molká shomárá dant, ");
INSERT INTO bcc_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ódá wati awali mardénchokkán gisshénét o pa Hodáwandá wapk kanét. Shomay mál o dalwatáni sajjahén awali narén chokk ham Hodáwanday bebant. ");
INSERT INTO bcc_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Haray awali korragay badalá gwarándhé bekosh o korragá bemók, bale agan namókayi, gorhá korragay gardená beprósh. Ensánáni sajjahén awali mardénchokkán allam bemók. ");
INSERT INTO bcc_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Agan bándá tai chokká cha taw jost kort: ‘É kárá chéá kanagá ay?’ taw begwash: ‘Hodáwandá gón wati dastay zórá márá cha Mesrá dar kort o áwort, cha hamá molká ke ódá má golám atén. ");
INSERT INTO bcc_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Wahdé Perawná zedd kort o márá rawagá naesht, Hodáwandá Mesray molká sajjahén awali chokk koshtant, cha ensánay awali mardénchokkán beger tán dalwatáni awali narén chokkán, sajjahéni koshtant. Paméshká man har dalwatay awali narén chokká pa Hodáwandá korbániga kanán o wati lógay sajjahén awali mardénchokkána mókán.’ ");
INSERT INTO bcc_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","É parmáná wati dastá nesháné o péshánigá thekké kan o per kan chéá ke Hodáwandá gón wati porzórén dastá tará cha Mesrá dar kort o áwort.” ");
INSERT INTO bcc_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Wahdé Perawná mahluk rawagá esht, Hodáyá á cha Pilestiáni molkay ráhá nabortant, bell toré á ráh gwandhter at, chéá ke Hodáyá gwasht: “Balkén jangé begiptesh o bebajjant o Mesrá per betarrant.” ");
INSERT INTO bcc_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Hodáyá mahluk cha gyábánay ráhá gardénán kort o dém pa Sohrzerá bort. Esráili ke cha Mesrá dar átkant, selahband atant. ");
INSERT INTO bcc_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mussáyá Issopay haddh gón wat zortant gón, chéá ke Issopá Bani Esráil sawgend dátag o gwashtagat: “Béshakk Hodáwand shomay madatá kayt. Á wahdá mani haddhán allam cha edá gón wat bebarét gón.” ");
INSERT INTO bcc_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Á cha Sokkutá ráh geptant o Étámá, gyábánay goddhi sará ordesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Hodáwand róchay wahdá jambaray menokéay tahá áyáni démá rawán at ke ráhá pésh bedárit. Shapay wahdá ásay menokéay tahá áyáni démá rawán at ke áyán rozhn bedant o á shapá ham sapar kort bekanant o róchá ham. ");
INSERT INTO bcc_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Róchay wahdá jambaray menok o shapay wahdá ásay menok, doén cha mahlukay démá dura nabutant. ");
INSERT INTO bcc_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Esráilián begwash per tarrét o Megdol o daryáay darnyámá, Pi-Háherótay nazzikká ord kanét. Bahal-Sepunay démá, tayábdapá ord kanét. ");
INSERT INTO bcc_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Perawn wati delá gwashit: ‘Esráili gyábáná sargardán ant. Har némagá ke berawant ráhé dar gétka nakanant.’ ");
INSERT INTO bcc_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Man, Perawnay delá senga kanán o á Esráiliáni randá kapit. Perawn o áiay sajjahén pawj mani shán o shawkatay sawabsáza bant. Gorhá Mesria zánant ke man Hodáwand án.” Esráilián hamódá ord kort ke Hodáwandá gwashtagat. ");
INSERT INTO bcc_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Perawn sahig but ke é mahluk tatkag. Esháni bárawá Perawn o áiay hezmatkáráni erádah badal but, gwashtesh: “Má chéá choshén káré kort? Esráili may hezmatá kanagá atant, má chéá rawagá eshtant?” ");
INSERT INTO bcc_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Perawná wati arrábah tayár kanáént o gón wati pawjá ráh gept. ");
INSERT INTO bcc_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Áiá shash sad gechéni arrábah o Mesray á dega arrábah ham zortant gón. Har yakkéá apsaré mán at. ");
INSERT INTO bcc_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Hodáwandá Mesray bádsháh Perawnay del seng kort o Perawn Esráiliáni randá kapt ke pa sarbolandi dar áyag o rawagá atant. ");
INSERT INTO bcc_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Mesri Esráiliáni randá kaptant. Perawnay sajjahén asp o arrábah o arrábaswár o payádagén lashkará Pi-Háherótay nazzikká, tayábdapá, Bahal-Sepunay démá Esráili raséntant, hamá jágahá ke Esráilián ord kortagat. ");
INSERT INTO bcc_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Wahdé Perawn áyáni nazzikká raset, Esráilián chamm chest kortant o Mesriesh distant ke áyáni randá kaptagatant. Esráilián sakk torset o Hodáwanday kerrá peryátesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Gón Mussáyá gwashtesh: “Záná Mesrá kabr néstat ke taw márá pa meragá é gyábáná áwortag? É che káré ke taw gón má kort? Taw chéá márá cha Mesrá dar kort? ");
INSERT INTO bcc_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Má Mesrá tará nagwasht: ‘Márá yalah kan o bell ke Mesriáni golámiá kanén?’ Cha é gyábáná meragá pa má Mesriáni golámi sharter at.” ");
INSERT INTO bcc_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Mussáyá gón mardomán gwasht: “Matorsét. Delá dhaddh kanét o bechárét ke maróchi Hodáwand shomárá chón nejáta dant, chéá ke é Mesrián ke shomá maróchi gendagá ét, padá eshán hechbara nagendét. ");
INSERT INTO bcc_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Hodáwand wat pa shomá janga kant, shomá bass árámá benendét.” ");
INSERT INTO bcc_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Hodáwandá gón Mussáyá gwasht: “Taw chéá mani kerrá peryát kanagá ay? Esráilián begwash démá rawán bebét. ");
INSERT INTO bcc_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Taw wati asáyá chest kan o dastá daryáay sará shahár day o daryáyá do bahr kan ke Esráili cha daryáay tahá, hoshkiay sará begwazant. ");
INSERT INTO bcc_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Man Mesriáni delán senga kanán ke Esráiliáni randá bekapant o Perawn o áiay sajjahén pawj o arrábah o arrábaswár mani shán o shawkatay sawabsáz bebant. ");
INSERT INTO bcc_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Wahdé Perawn o áiay arrábah o arrábaswáráni sawabá maná shán o shawkata rasit, gorhá Mesria zánant ke man Hodáwand án.” ");
INSERT INTO bcc_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Hodáay préshtag ke Esráili lashkaray démá rawán at, kenzet o áyáni poshtá shot. Jambaray menok ham cha áyáni démá kenzet o áyáni poshtá óshtát. ");
INSERT INTO bcc_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Jambaray menok Mesray lashkar o Esráilay lashkaray nyámá óshtát. Jambará yakk némagé tahár o domi némag rozhná kort. Sajjahén shapá lashkar yakdomiay nazzikká nayátkant. ");
INSERT INTO bcc_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Mussáyá wati dast daryáay sará shahár dát o cha Hodáwanday zórá sajjahén shapá cha ródarátká trondén gwátéá kasshet o daryá poshtá kenzént. Áp do bahr but o hoshki záher but. ");
INSERT INTO bcc_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Esráili daryáay tahá cha hamé hoshkiá rawán butant. Áp áyáni rást o chappén némagá chó diwálá óshtátagat. ");
INSERT INTO bcc_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Mesri gón Perawnay sajjahén asp o arrábah o arrábaswárán tán daryáay nyámá áyáni randá kaptant. ");
INSERT INTO bcc_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Shapay cháromi pásá Hodáwandá cha ás o jambaray menokay tahá Mesray pawj cháret o sarbatag o sargardán kort. ");
INSERT INTO bcc_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Hodáwandá áyáni arrabaháni parrag gatthéntant ke arrabaháni barag pa áyán grán bebit. Mesrián gwasht: “Byáét cha Esráiliána tachén ke Hodáwand pa áyánigi gón Mesrá jangá ent.” ");
INSERT INTO bcc_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Hodáwandá gón Mussáyá gwasht: “Wati dastá daryáay sará shahár day ke áp Mesri o áyáni arrábah o arrábaswáráni sará per beléthit.” ");
INSERT INTO bcc_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mussáyá wati dast daryáay sará shahár dát o cha bámgwáhá pésar, hamá wahdá ke Mesri cha ápá tachagá atant, daryá wati jágahá átk. É paymá Hodáwandá Mesri daryáyá chagal dátant. ");
INSERT INTO bcc_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Wahdé Perawnay sajjahén pawjay arrábah o arrábaswár Esráiliáni randá kaptant o daryáyá mánesh dát, áp per tarret o ái bokkéntant. Cha áyán yakké ham sar nayátk. ");
INSERT INTO bcc_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Esráili daryáay tahá, cha hoshk butagén ráhá gwastant o áp áyáni rást o chappén némagá chó diwálá óshtátagat. ");
INSERT INTO bcc_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","É paymá Hodáwandá á róchi Esráil cha Mesriáni dastá rakként o Esráilián dist ke Mesriáni jón o jasad tayábdapá kaptagant. ");
INSERT INTO bcc_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Wahdé Esráilián Hodáwanday zórmandén dast dist ke Mesriáni helápá chesti kortagat, cha Hodáwandá torsetesh o Hodáwanday jend o Hodáwanday hezmatkár Mussáay sará báwaresh kort. ");
INSERT INTO bcc_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Gorhá Mussá o Esráilián pa Hodáwandá é názénk jat: “Man Hodáwandá názénán, chéá ke Hodáwand pa shán o shawkat sóbén but. Áiá asp o aspswár daryáyá chagal dátant. ");
INSERT INTO bcc_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Hodáwand mani zór o wák o mani názénk ent. Hodáwand pa man nejáté but. Mani Hodá ent, mana názénáni. Mani petay Hodá ent o man áiá satá o saná kanán. ");
INSERT INTO bcc_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Hodáwand jang kanóké, námi Yahweh ent. ");
INSERT INTO bcc_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Perawnay arrábah o lashkari daryáyá chagal dátant, Perawnay sharterén apsar Sohrzerá bokketant. ");
INSERT INTO bcc_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Johlén ápán andém kortant, á chó sengá johlánkiá ér bokketant. ");
INSERT INTO bcc_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Oo Hodáwand! Tai rástén dast ajab zórmand at. Oo Hodáwand! Tai rástén dastá dozhmen shengént. ");
INSERT INTO bcc_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Taw cha wati mazanshániá dozhmen sarshakun kortant. Taw wati hezhm ráh dát o tai hezhmay ásá dozhmen chó palárá wártant. ");
INSERT INTO bcc_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Cha tai pónzay damá áp sar pa sar but, tachókén áp chó diwálá mohr óshtátant. Johlén áp daryáay gobbá badetant. ");
INSERT INTO bcc_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Dozhmená gwasht: ‘Man esháni randá kapán o rasénánesh, máláni áwárá bahra kanán o wati arwáhá sérápa kanán. Zahmá kasshán o mani dastesh tabáha kant.’ ");
INSERT INTO bcc_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Bale taw hopp kort o daryáyá á póshetant. Á chó sropá johlén ápán ér bokketant. ");
INSERT INTO bcc_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Oo Hodáwand! Hodáyáni nyámá kay tai paymá ent? Kay tai paymá pákiá mazanshán ent? Tai porshánén kár satá karzant o taw hayrán kanókén kára kanay. ");
INSERT INTO bcc_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Taw wati rástén dast shahár dát o zeminá dozhmen ér bortant. ");
INSERT INTO bcc_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Taw pa mehr wati móketagén mahlukay rahbari kort o gón wati zór o wáká dém pa wati pákén bárgáhá áyáni rahshóni kort. ");
INSERT INTO bcc_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Kawma eshkonant o larzant. Bimmé Pilestiáay jahmenendáni delá kapit. ");
INSERT INTO bcc_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edumay sardára torsant. Muábay zóráwaráni jáná drahagé kapit o Kanhánay sajjahén jahmenend deltrakka bant. ");
INSERT INTO bcc_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bimm o dahshaté delá kapitesh. Cha tai báskay zórmandiá á seng o syáha bant, tán hamá wahdá ke tai mahluk begwazit, oo Hodáwand, tán hamá wahdá ke tai móketagén mahluk begwazit. ");
INSERT INTO bcc_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Oo Hodáwand, Taw wati mahluká molká káray o wati mirásay kóhay sará nádénay, hamá jágahá ke taw pa wati nendagá addh kortag, hamá pákén jágah ke tai dastán tayár kortag, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Hodáwand abad tán abad hákemia kant.” ");
INSERT INTO bcc_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Wahdé Perawnay asp o arrábah o aspswárán daryáyá mán dát, Hodáwandá daryáay áp áyáni sará per gardént, bale Esráili daryáay tahá, cha hoshk butagén ráhá gwastant. ");
INSERT INTO bcc_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Paygambarén Maryam ke Hárunay gohár at, áiá kanjarié zort o pád átk. Sajjahén janén kanjari janán o nách kanáná pád átkant gón. ");
INSERT INTO bcc_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Maryamá pa áyán názénk jat: “Hodáwandá benázénét, chéá ke Hodáwand pa shán o shawkat sóbén but. Áiá asp o aspswár daryáyá chagal dátant.” ");
INSERT INTO bcc_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Gorhá Mussáyá Esráiliáni rahshóni kort. Á cha Sohrzeray tayábá pád átk o Shuray gyábáná shotant. Tán say róchá gyábáná saparesh kort bale hecch ápesh nadist. ");
INSERT INTO bcc_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Wahdé Márahá sar butant, Márahay ápesh wárt nakort ke sór at. Paméshká á jágahay nám Márah but. ");
INSERT INTO bcc_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mahluká Mussáay sará norondhet o gwasht: “Ché bwarén?” ");
INSERT INTO bcc_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mussáyá Hodáwanday kerrá peryát kort o Hodáwandá Mussá dári thokkoré pésh dásht. Mussáyá dár ápá dawr dát o áp shirken but. Ódá Hodáwandá pa mahluká hokm o parmáné gisshént o mahluki chakkáset. ");
INSERT INTO bcc_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Hodáwandá gwasht: “Agan taw pa delgósh wati Hodáwandén Hodáay tawárá gósh bedáray o hamá kárán bekanay ke áiay chammán sharr ant, agan áiay hokmán delgósh bekanay o áiay sajjahén parmánán bemannay, hecch choshén nádráhié tai sará nayárán ke man Mesriáni sará áwort, chéá ke mane Hodáwand tai dráh kanók án.” ");
INSERT INTO bcc_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Á Élimá átkant. Élimá ápay dwázdah chammag o haptád bon macch hastat. Ódá ápay kerrá ordesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Sajjahén Esráili mahluk cha Élimá rahádag but. Cha Mesrá dar kapagá rand, domi máhay pánzdahomi róchá Sinay gyábáná sar butant. Sin, Élim o Sináay nyámá ent. ");
INSERT INTO bcc_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Gyábáná, Esráilay sajjahén mahluk Mussá o Hárunay sará norondhagá lagget. ");
INSERT INTO bcc_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Esráilián gwasht: “Drégatá má Mesrá Hodáwanday dastá bemorténén. Ódá wa má góshtay dégáni kerrá neshtagatén o delay sérá nána wárt. Bale shomá márá é gyábáná áwort ke é sajjahén mahluká cha shodá bekoshét.” ");
INSERT INTO bcc_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Hodáwandá gón Mussáyá gwasht: “Bechár, man cha ásmáná pa shomá nagana gwárénán. Mahluk har róch dhanná dar byayt o wati hamá róchay kesásá nagan mocch bekant o bezurit. É paymá áyána chakkásán ke bárén mani Sharyatay ráhá rawant yá na. ");
INSERT INTO bcc_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Wati shashomi róchay naganán ke kárant o tayára kanant, báyad ent cha pésari har yakk róchéay naganán do sari bebant.” ");
INSERT INTO bcc_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mussá o Háruná gón sajjahén Esráilián gwasht: “Maróchi bégáhá shomá zánét ke cha Mesrá shomay dar kanók Hodáwand at o ");
INSERT INTO bcc_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","bándá sohbá shomá Hodáwanday shán o shawkatá gendét. Chéá ke shomá Hodáwanday sará norondhetag o áiá eshkotagant. Má ché én ke shomá may sará benorondhét?” ");
INSERT INTO bcc_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mussáyá gwasht: “Hodáwand shomárá pa waragá bégáhá gósht o sohbá nagana dant, lápay sérá, chéá ke Hodáwandá shomay hamá norondhag eshkotagant ke shomá áiay sará kortagant. Má ché én? Shomá may sará norondhagá naét, Hodáwanday sará norondhagá ét.” ");
INSERT INTO bcc_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mussáyá gón Háruná gwasht: “Sajjahén Esráili mahluká begwash: ‘Hodáwanday bárgáhá byáét. Chéá ke shomay norondhagi eshkotagant.’” ");
INSERT INTO bcc_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Chó but ke wahdé Hárun gón sajjahén Esráili mahluká habará at, áyán gyábánay némagá cháret o Hodáwanday shán o shawkatesh dist ke jambaray tahá záher at. ");
INSERT INTO bcc_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Man Esráiliáni norondhag eshkotagant. Áyán begwash: ‘Bégáhá gósht o sohbá nagana warét, lápay sérá. Gorhá shomá zánét ke man Hodáwand án, shomay Hodá.’” ");
INSERT INTO bcc_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Chó but ke bégáhá nekólén morg átkant o ordgáhesh sarpósh kort o sohbá nóday láé sajjahén ordgáhay chapp o chágerdá ér nesht. ");
INSERT INTO bcc_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Wahdé nóday lá gár but, zeminá názorkén kochalay paymén chizzé dará but, barpay pozzhokay paymén. ");
INSERT INTO bcc_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Wahdé Esráilián dist, gón yakdegará gwashtesh: “É chéé?” Chéá ke áyán nazánt é chéé. Mussáyá gwasht: “É hamá nagan ent ke Hodáwandá shomárá pa waragá dátag. ");
INSERT INTO bcc_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Hodáwanday dátagén hokm esh ent: ‘Haminchok ke warét, haminchok bezurét. Pa wati gedánay har mardoméá yakk oméréay kesásá bezurét.’” ");
INSERT INTO bcc_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Esráilián nagan zort, bale lahténá géshter zort o lahténá kamter. ");
INSERT INTO bcc_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Wahdé oméray hesábá kaylesh kortant, distesh ke á kasá ke gésh zortag, warák pa áiá géshén naant o á kasá ke kamm zortag, pa áiá kamm naant. Harkasá wati lápay kesásá zortagat. ");
INSERT INTO bcc_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mussáyá gón áyán gwasht: “Kass tán sohbá cha é warákán hecch ér makant.” ");
INSERT INTO bcc_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Bale lahténá Mussáay habar gósh nadásht. Áyán cha é warákán chizzé tán sohbá wati kerrá ér kort, bale é warák kerm kapt o bó kanagá laggetant. Gorhá Mussá áyáni sará zahr gept. ");
INSERT INTO bcc_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Har sohb mardomán wati lápay kesásá zort, róch ke tronda but, pasht kaptagén kochal ápa butant. ");
INSERT INTO bcc_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Har shashomi róchá áyán do sari waráka zort, bezán pa har mardoméá do omér. Mahlukay sajjahén sarók Mussáay kerrá átkant o Mussáesh hál dát. ");
INSERT INTO bcc_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mussáyá gón áyán gwasht: “Hodáwandá chó gwashtag: ‘Bándá Shabbatay róch ent, Hodáwanday gisshéntagén pákén róch ent, pa árám kanagá. Shomárá harché ke pachagi ent, maróchi bepachét o harché ke lahrh dayagi ent, maróchi lahrh dayét. Harché ke sara kayt, pa bándátigén róchá éresh kanét.’” ");
INSERT INTO bcc_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Hamá paymá ke Mussáyá gwashtagat, mardomán sar átkagén warák pa bándátigén róchá éra kortant. É warákán na bóa kort o na kerma kaptant. ");
INSERT INTO bcc_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mussáyá gwasht: “Maróchi eshán bwarét chéá ke maróchigén róch pa Hodáwandá Shabbaté. Maróchi é warák zeminá ér áraga nabit. ");
INSERT INTO bcc_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Shash róchá mocch kanét o bezurét, bale haptomi róchá, bezán Shabbatay róchá hecch nést.” ");
INSERT INTO bcc_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Haptomi róchá lahtén mardom dar átk ke rawén o nagan moccha kanén, bale hecchesh nadist. ");
INSERT INTO bcc_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Hodáwandá gón Mussáyá gwasht: “Tán kadéná sará tába dayét o mani hokm o sar o sójána nazurét? ");
INSERT INTO bcc_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Bechárét, mane Hodáwandá shomárá Shabbatay róch bakshátag. Paméshká shashomi róchá shomárá do róchay naganá dayán. Haptomi róchá shomá har jágahá ét, hamódá bebét. Haptomi róchá kass cha wati jágahá dar mayayt.” ");
INSERT INTO bcc_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Gorhá mahluká haptomi róchá árám kort. ");
INSERT INTO bcc_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Esráilián é naganay nám “mann” kort. É gehnichay tohmay paymén atant, espétchak atant o támesh chó bénagi naganá at. ");
INSERT INTO bcc_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Mussáyá gwasht: “Hodáwanday hokm esh ent: ‘Yakk purahén oméré mann pa wati áyókén nasl o padréchán ér kanét, ke á hamá naganá begendant ke man gyábáná shomárá wárént, hamá wahdá ke man shomárá cha Mesrá dar kort o áwort.’” ");
INSERT INTO bcc_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mussáyá gón Háruná gwasht: “Darpé bezur o yakk oméré manni mán kan o Hodáwanday bárgáhá éri kan ke pa shomay áyókén nasl o padréchán ér bebit.” ");
INSERT INTO bcc_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Hamá paymá ke Hodáwandá Mussá hokm dátagat, Háruná é darp sháhediay wánekáni démá ér kort ke paházag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Esráilián tán chell sálá manna wárt, bezán tán hamá wahdá ke ábádén molkéá sar butant. Tán hamá wahdá ke Kanhánay simsará rasetant, mannesha wárt. ");
INSERT INTO bcc_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Yakk oméré épahay dahyakk ent. ");
INSERT INTO bcc_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Hamá paymá ke Hodáwandá hokm dátagat, sajjahén Esráili mahluk cha Sinay gyábáná rahádag but o dárán o rawáná shot o Repidimá ordi kort, bale ódá áp néstat ke mardom bwarant. ");
INSERT INTO bcc_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Mardom gón Mussáyá arhetant, gwashtesh: “Márá áp beday ke bwarén.” Mussáyá gwasht: “Chéá gón man arhagá ét? Chéá Hodáwandá chakkásét?” ");
INSERT INTO bcc_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Bale mardom ódá tonnig atant, áyán Mussáay sará norondhet o gwasht: “Taw chéá márá cha Mesrá dar kort o áwort? Ke márá o may chokkán o mál o dalwatán cha tonná bekoshay?” ");
INSERT INTO bcc_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mussáyá Hodáwanday kerrá peryát kort o gwasht: “É mahluká chón bekanán? É wa pa mani sengsár kanagá óshtátagant.” ");
INSERT INTO bcc_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Hodáwandá gón Mussáyá gwasht: “Esráilay lahtén kamásh hamráh kan o cha mahlukay démá gwazán kan. Hamá asá ke taw gón áiá Nillay kawr jat, áiá dastá kan o beraw. ");
INSERT INTO bcc_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Bechár, ódá Horébá tai démá man taláréay sará óshtán. Gón asáyá talárá bejan, pa mahluká waragi áp dara kayt.” Gorhá Mussáyá Esráilay kamásháni chammáni démá anchosh kort. ");
INSERT INTO bcc_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Áiá á jágahay nám Massah o Meribah kort, chéá ke ódá Esráili arhetant o Hodáwandesh ham chakkáset o gwashtesh: “Bárén Hodáwand gón má gón ent yá na?” ");
INSERT INTO bcc_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amáliki átkant o Repidimá gón Esráilián jangesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Mussáyá gón Yusháyá gwasht: “Lahtén mard gechén kan o beraw, gón Amálikián jang kan. Bándá man Hodáay asáyá dastá kanán o jompay sará óshtán.” ");
INSERT INTO bcc_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yusháyá hamá paymá kort ke Mussáyá gwashtagat o gón Amálikián jangi kort. Mussá o Hárun o Ahur jompá sar kaptant. ");
INSERT INTO bcc_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Har wahdá ke Mussáyá dast chesta kortant, Esráili báládasta butant o har wahdá ke wati dasti jahla kortant, Amáliki báládasta butant. ");
INSERT INTO bcc_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mussáay dastán dam bort. Hárun o Ahurá sengé áwort o áiay chérá dát. Mussá sengay sará nesht. Áyán Mussáay dast gept o borz dáshtant, yakkéá rástén dast o domiá chappén dast. É paymá Mussáay dast tán rónenday wahdá jahl nakaptant o ");
INSERT INTO bcc_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Yusháyá Amáliki pawj pa zahm prósh dát. ");
INSERT INTO bcc_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Hodáwandá gón Mussáyá gwasht: “É kessahá ketábéá nebeshtah kan ke shamóshag mabit. É kessahá Yusháay kerrá byár. Chéá ke man Amálikay nám o nesháná cha jaháná sarjamiá gára kanán.” ");
INSERT INTO bcc_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Mussáyá korbánjáhé addh kort o áiay námi kort “Hodáwand mani bayrak ent”. ");
INSERT INTO bcc_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Gwashti: “Maná Hodáwanday bádsháhi tahtay sawgend ent ke Hodáwand nasláni nasl gón Amálikián janga kant.” ");
INSERT INTO bcc_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Midyánay dini péshwá Yatrun ke Mussáay janay pet at, hamá sajjahén káráni bárawá sahig but ke Hodáyá pa Mussá o áiay mahluk Esráilá kortagatant, bezán Hodáwandá chón Esráili cha Mesrá dar kort o áwortant. ");
INSERT INTO bcc_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Mussáyá wati jan Sapurah petay lógá ráh dátagat. Nun Yatruná Mussáay jan o áiay doén mardénchokk zortant o ráh gept. Yakk chokkéay nám Gayrshám at, chéá ke Mussáyá gwashtagat ke man darmolká darámadé án. ");
INSERT INTO bcc_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Domi chokkay nám Élizer at, chéá ke Mussáyá gwashtagat ke mani petay Hodá mani madatkár butag o maná cha Perawnay zahmá rakkéntagi. ");
INSERT INTO bcc_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mussáay nákó Yatrun gón Mussáay jan o chokkán gyábáná, Hodáay kóhá shot, hamódá ke Mussáyá ord kortagat. ");
INSERT INTO bcc_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yatruná pa Mussáyá paygám ráh dát: “Mane Yatrun tai nákó, tai jan o doén chokkáni hamráhiá tai kerrá pédák án.” ");
INSERT INTO bcc_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Mussá pa wati nákóay péshwáziá dar átk, pa adab sari jahl kort o nákói chokket. Yakdomiay hálporsiesh kort o gedáná potertant. ");
INSERT INTO bcc_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Hodáwandá Esráiliáni háterá gón Perawn o Mesrián harché ke kortagat, Mussáyá á sajjahén habar gón wati nákóá kortant. Ráhay sajjahén sakki o sóriáni bárawá ham habari kort o gwashti ke Hodáwandá chón márá rakkéntag. ");
INSERT INTO bcc_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yatrun á sajjahén sharrén káráni sará gal but ke Hodáwandá pa Esráilián hamá wahdá kortagatant ke Esráilii cha Mesrián rakkéntant. ");
INSERT INTO bcc_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yatruná gwasht: “Hodáwandá satá bát ke shomárá cha Perawn o Mesriáni dastá rakkéntagi o kawmi cha Mesriáni zolmá neját dátag. ");
INSERT INTO bcc_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Nun mana zánán ke Hodáwand cha á dega sajjahén Hodáyán master ent. Chéá ke wati mahluki cha gorunákén Mesriáni zolm o zórákián rakként.” ");
INSERT INTO bcc_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mussáay nákó Yatruná pa Hodáyá sóchagi o dega korbánig pésh kort. Hárun o Esráilay sajjahén kamásh átkant ke Hodáay bárgáhá gón Mussáay nákóá nán bwarant. ");
INSERT INTO bcc_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Chó but ke domi róchá Mussá pa mahlukay dádrasiá nesht. Mardom sohbá tán bégáhá áiay chapp o chágerdá óshtátagatant. ");
INSERT INTO bcc_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Mussá pa mahluká harché ke kanagá at, nákóá dist. Gwashti: “É che káré ke taw pa mahluká kanagá ay? Tahná taw chéá neshtagay o dádrasi kanagá ay o é dega sajjahén mardom sohbá tán bégáhá tai chapp o chágerdá óshtátagant?” ");
INSERT INTO bcc_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mussáyá gón wati nákóá gwasht: “É wástá ke mardom Hodáay razáay shóházá mani kerrá káyant. ");
INSERT INTO bcc_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Wahdé jérhahé bitesh, é mani kerrá káyant o man doén némagay mardománi paysalahá kanán o Hodáay parmán o sar o sójánesh sara kanán.” ");
INSERT INTO bcc_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Mussáay nákóá gwasht: “Taw sharrén káré kanagá naay. ");
INSERT INTO bcc_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Shomá dama barét, tai jend o é mahluk ke tai hamráh ent, shomá sajjahén dama barét. É kár pa taw sakk grán ent. Taw é kárá tahná korta nakanay. ");
INSERT INTO bcc_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Nun mani habará gósh dár, tará sójé dayán. Hodá gón taw gón bát. Taw Hodáay démá mahlukay nomáendah bay o esháni jerhahán Hodáay kerrá bebar. ");
INSERT INTO bcc_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Hodáay hokm o parmánán eshán sar kan o hamá ráhánesh pésh dár ke é berawant o hamá káránesh sój day ke é bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Cha sajjahén mahlukay nyámá budnákén mardom gechén kan, hamá ke Hodátors o porehtebár ant o cha nárawáén páedagá naprata kanant. Mahluká hazár hazár, sad sad, panjáh panjáh o dah dahá bahr kan o cha é mardomán har yakké, yakk thóliéay master kan. ");
INSERT INTO bcc_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","É mardom modám mahlukay dádrasiá bekanant. Mazanén jerhahán tai kerrá byárant, bale kasánén jérhaháni dádrasiá wat bekanant. É paymá tai bár sobaktera bit o á tai hamkópaga bant. ");
INSERT INTO bcc_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Agan Hodá tará beparmáit o taw anchó bekanay, gorhá é bárá zorta kanay o sajjahén mardom pa salámati o émeni wati lógána rawant.” ");
INSERT INTO bcc_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mussáyá wati nákóay habar gósh dáshtant o har káré ke nákóá gwashtagat, korti. ");
INSERT INTO bcc_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Cha sajjahén Esráilá budnákén mardomi gechén kort o mahlukay sar o master kortant ke hazár hazár, sad sad, panjáh panjáh o dah dah mardomay master bebant. ");
INSERT INTO bcc_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","É mardomán modám mahlukay dádrasia kort. Gránén jérhahesh Mussáay kerrá áwortant, bale sajjahén kasánén jérhaháni sará wat dádrasiesha kort. ");
INSERT INTO bcc_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Nun Mussáyá wati nákó Yatrun ejázat kort o Yatrun wati molká per tarret. ");
INSERT INTO bcc_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Cha Mesrá dar kapagá rand, sayomi máhay awali róchá Esráili Sináay gyábáná sar butant. ");
INSERT INTO bcc_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Cha Repidimá ráh geptant o Sináay gyábáná, kóhay dámoná ordesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Mussá borzá Hodáay kerrá shot. Hodáwandá cha kóhá Mussá gwánk jat o gwasht: “Gón Ákubay chokk o nomásagán habar kan. Esráilián chó begwash: ");
INSERT INTO bcc_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Shomá dist ke man gón Mesrián ché kort o che paymá shomárá wakábáni bánzolán nádént o wati kerrá áwort. ");
INSERT INTO bcc_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Nun agan shomá pa delgósh mani tawárá gósh bedárét o mani ahd o paymánay parmánbardáriá bekanét, sajjahén kawmáni tahá shomá mani hásén mál o matá bét. Bell toré sajjahén zemin manig ent, ");
INSERT INTO bcc_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","bale shomá pa man dini péshwáyáni bádsháhié jórha bét o pák o dar chetagén kawmé bét. Hamé habarán gón Esráilián bekan.’” ");
INSERT INTO bcc_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Mussá átk o mahlukay kamáshi lótháéntant o hamá sajjahén habari áyáni démá pésh kortant ke Hodáwandá áiárá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Sajjahén mahluká hamtawáriá chó passaw dát: “Harché Hodáwandá gwashtag, má anchosha kanén.” Mussáyá mahlukay passaw Hodáwanday kerrá bort. ");
INSERT INTO bcc_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Hodáwandá gón Mussáyá gwasht: “Bechár, man bazén jambaréay tahá tai kerrá káyán ke wahdé man gón taw habara kanán, mahluk beshkont o modám tai sará báwar bekant.” Mussáyá mahlukay habar gón Hodáwandá gwashtant. ");
INSERT INTO bcc_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Hodáwandá gwasht: “Mahlukay kerrá beraw o maróchi o bándá pa man wapkesh kan ke mani gechéni o pákén mardom bebant. Áyán begwash ke wati god o pocchán beshódét o ");
INSERT INTO bcc_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","pa sayomi róchá tayár bebét, chéá ke sayomi róchá mane Hodáwand sajjahén mahlukay chammáni démá Sináay kóhay sará éra káyán. ");
INSERT INTO bcc_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kóhay chapp o chágerdá pa sajjahén mardomán hadd o simsar begisshén o begwash: ‘Habardár! Kóhá sar makapét. Kóhay lambán ham dast per makanét. Harkasá ke kóh dast jat, markay sezá dayaga bit. ");
INSERT INTO bcc_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Kóhay dast janóká dast majanét, seng yá tiri bejanét o bekoshéti. Mardomé bebit yá dalwaté, báyad ent zendag mamánit.’ Karnáay drájkasshén tawáré ke chesta bit, gorhá mardomán ejázat ent ke kóhá sar bekapant.” ");
INSERT INTO bcc_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mussá cha kóhá ér kapt o mahlukay kerrá átk. Áiá mardom wapk kortant o mardomán wati god shoshtant. ");
INSERT INTO bcc_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Mussáyá gón mahluká gwasht: “Watá pa sayomi róchá tayár kanét. Janáni kerrá marawét.” ");
INSERT INTO bcc_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Chó but ke sayomi róchay sohbá grand o gerók but o kóhay sará bazén jambaré záher but o karnáay anchén trondén tawáré chest but ke ordgáhay sajjahén mardom cha torsá larzetant. ");
INSERT INTO bcc_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Mussáyá mardom pa Hodáay gendoká cha ordgáhá dhann bortant o mardom kóhay boná óshtátant. ");
INSERT INTO bcc_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Sináay kóh duttéá mán póshetagat, chéá ke Hodáwand áséay tahá kóhay sará ér átkagat o é ásay dutt chó kurahay duttá chest atant o sarjamén kóh sakk larzagá at. ");
INSERT INTO bcc_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Karnáay tawár ke borzter bayán but, Mussáyá habar kort o Hodáyá pa borztawári passaw dát. ");
INSERT INTO bcc_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Hodáwand cha ásmáná Sináay kóhay sará ér átk o Mussái kóhay thollá tawár kort. Mussá sar kapt. ");
INSERT INTO bcc_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Hodáwandá gón Mussáyá gwasht: “Ér kap o mardomán habardár kan ke pa Hodáwanday cháragá gisshéntagén hadd o simsará mapróshét. Agan na, cha shomá bázéné merit. ");
INSERT INTO bcc_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Dini péshwá ham, hamá ke Hodáwanday nazzikká áyagay ejázatesh hast, báyad ent watá pák o palgár bekanant ke Hodáwand áyán majant.” ");
INSERT INTO bcc_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mussáyá gón Hodáwandá gwasht: “Mahluká Sináay kóhá sar kapagay ejázat nést, chéá ke taw wat márá habardár kortag o maná gwashtag ke kóhay chapp o chágerdá hadd o simsaré begisshén o kóhá pa Hodáwandá wapk kan.” ");
INSERT INTO bcc_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Hodáwandá gwasht: “Ér kap o Háruná bezur o sar kap, bale dini péshwá o mahluk pa Hodáwanday kerrá borzá áyagá, gisshéntagén hadd o simsarán mapróshant ke Hodáwand áyán majant.” ");
INSERT INTO bcc_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mussá ér átk, mahlukay kerrá shot o é habari kortant. ");
INSERT INTO bcc_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Hodáyá é sajjahén habar gwashtant: ");
INSERT INTO bcc_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Man tai Hodáwandén Hodá án, hamá ke tará cha Mesrá dar kort o áwort, cha hamá molká ke ódá golám atay. ");
INSERT INTO bcc_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Cha man abéd tará dega hecch hodá mabit. ");
INSERT INTO bcc_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Na borzén ásmánay chizzéay sheklá pa wat bot addh bekan, na zeminay saray chizzéay sheklá, na zeminay chéray ápáni tahay chizzéay sheklá. Pa wat hecch botén hodá addh makan. ");
INSERT INTO bcc_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Esháni démá sará jahl makan o sojdahesh makan. Chéá ke man tai Hodáwandén Hodá hasaddigén Hodáé án. Petáni radkáriáni sezáyá áyáni chokkána dayán. Á ke cha man naprata kanant, áyáni radkáriáni sezáyá áyáni sayomi o cháromi nasl o padréchá dayán. ");
INSERT INTO bcc_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Bale á mardom ke maná dósta dárant o mani parmánáni sará kára kanant, man tán hazárán naslá áyáni sará mehrabána bán. ");
INSERT INTO bcc_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Mopt o watsará wati Hodáwandén Hodáay námá mager. Harkas ke mopt o watsará Hodáwanday námá gipt, gonahkára bit. ");
INSERT INTO bcc_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Shabbatay róchá yát bedár o é róchá gechéni o pákén róché bezán. ");
INSERT INTO bcc_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Shash róchá kár kan o wati sajjahén kárán gisshén. ");
INSERT INTO bcc_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Bale haptomi róch tai Hodáwandén Hodáay Shabbatay róch ent. É róchá hecch kár makan, na taw, na tai bacch o jenekk, na tai golám o móled, na tai dalwat o na hamá dhanni mardom ke tai shahrá nendók ent. ");
INSERT INTO bcc_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Chéá ke Hodáwandá shash róchá ásmán, zemin, daryá o harché ke esháni tahá hast, addh kortant o haptomi róchá árámi kort, paméshká Hodáwandá Shabbatay róch barkat dátag o gechéni o pákén róché jórh kortag. ");
INSERT INTO bcc_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Wati pet o mátá ezzat beday ke hamá molká tai omr dráj bebit ke tai Hodáwandén Hodá tará danti. ");
INSERT INTO bcc_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Mardom makosh. ");
INSERT INTO bcc_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Zená makan. ");
INSERT INTO bcc_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Dozzi makan. ");
INSERT INTO bcc_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Wati hamsáhegay helápá drógén sháhedi maday. ");
INSERT INTO bcc_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Pa wati hamsáhegay lógá delmánag mabay. Pa áiay jan, golám, móled, gók, har yá dega chizzéá lálech makan.” ");
INSERT INTO bcc_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Wahdé sajjahén mardomán dist ke grand o gerók ent o karnáay tawár ent o duttéá kóh póshetag, cha torsá larzet o dur óshtátant. ");
INSERT INTO bcc_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Áyán gón Mussáyá gwasht: “Taw wat gón má habar kan o má tai habará gósha dárén, bale mayl ke Hodá gón má habar bekant. Agan Hodá gón má habar bekant, má merén.” ");
INSERT INTO bcc_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mussáyá gón mahluká gwasht: “Matorsét, Hodá paméshká átkag ke shomárá bechakkásit o áiay tors shomay delán benendit o shomá gonáh makanét.” ");
INSERT INTO bcc_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mahluk dur óshtát o Mussá dém pa hamá bazén taháriá shot ke Hodá ódá at. ");
INSERT INTO bcc_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Hodáwandá gón Mussáyá gwasht: “Esráilián begwash ke shomá wat dist ke man cha ásmáná gón shomá habar kort. ");
INSERT INTO bcc_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Cha man abéd shomárá dega hecch hodá mabit. Pa wat hecch botén hodá addh makanét. Na nograhén hodá addh kanét, na teláhén. ");
INSERT INTO bcc_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Pa man hákay korbánjáhé addh kan. Ódá cha wati pas o gókán sóchagi korbánig o hamdeliay korbánig pésh kan. Har jágah ke man tará wati námay yát kanagá parmáyán, hamódá tai kerrá káyán o tará barkata dayán. ");
INSERT INTO bcc_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Bale agan pa man sengay korbánjáhé addha kanay, cha tráshtagén sengán addhi makan. Chéá ke pa sengay tráshagá awzár o sámán kármarza kanay o sengán palita kanay. ");
INSERT INTO bcc_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Mani korbánjáhá padánk per makan ke sar kapagay wahdá bésetra bay.” ");
INSERT INTO bcc_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“É hamá kánun ant ke tará gón kawmá gwashagi ant: ");
INSERT INTO bcc_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Agan taw Ebráni golámé bahá zort, é golám tán shash sálá tai hezmatá bekant. Haptomi sálá pa wati ázátiá hecch zarr madant o berawt. ");
INSERT INTO bcc_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Agan tahná átkag tahná berawt, bale agan cha pésará sur kortagéné gorhá jan ham áiay hamráhiá berawt gón. ");
INSERT INTO bcc_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Agan wájahá jané dát o janéná bacch o jenekk pédá kort, jan o chokk wájahayga bant o golám tahná berawt. ");
INSERT INTO bcc_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Bale agan golám dape wat begwashit: ‘Maná wati wájah o wati jan o chokk dóst ant o ázát bayag o rawaga nalóthán,’ ");
INSERT INTO bcc_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","gorhá wájah áiá Hodáay bárgáhá bebárt. Golámá darwázag yá darwázagay chánthay dapá bebárt, drapshé bezurit o áiay góshá besombit o á golám tán zendag ent, wájahay hezmatá bekant. ");
INSERT INTO bcc_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Agan mardé wati jenekká móledéay hesábá bahá bekant, á jenekk mardénén golámáni paymá ázát kanag mabit. ");
INSERT INTO bcc_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Agan é jenekk wájahéá gechén kort o zort o randá wájahá pasond nabut, gorhá báyad ent bellit ke jenekká degaré bemókit. Wájahá é hakk nést ke áiá dhanni mardoméay kerrá bahá bekant, chéá ke áiá wat gón jenekká béwapái kortag. ");
INSERT INTO bcc_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Agan wájahá jenekk pa wati bacchá gechén kortag o zortag, gorhá jenekká hamá hakká bedant ke wati jenday jenekká danti. ");
INSERT INTO bcc_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Agan wájah dega jané begipt, wati awali janá cha warák, póshák o jani hakká zebahr makant. ");
INSERT INTO bcc_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Agan áiá é sayén chizzán madant, janén pa wati ázátiá hecch zarr madant o berawt.” ");
INSERT INTO bcc_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Harkasá ke mardomé jat o kosht, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Bale agan áiá pa názánti é kár kort o mane Hodáyá ham é káray dém nadásht, gorhá man jágahé gisshénán ke hónig betachit o hamódá berawt. ");
INSERT INTO bcc_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Bale agan kaséá pa zánt yakkéay sará orosh kort o koshti, áiá mani korbánjáhá ham panáh nést. Cha ódá ham dari kan o markay sezái beday. ");
INSERT INTO bcc_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Harkasá ke wati pet yá mát jat, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Harkasá ke mardoméay dozzagá gerag but, á mardomi bahá kort yá wati kerrá dáshti, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Harkasá ke wati pet yá mát nálat kort, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Agan mardomán watmánwatá jang kort o hamé wahdá yakkéá domiárá sengé yá moshté jat o á mardom namort bale tahtay báhóth but o ");
INSERT INTO bcc_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","randá pád átk o dazlatthay madatá dhanná gasht, gorhá janók dega sezá dayag mabit, bale zawál butagén wahday táwán o elájay harch o darchán porr bekant. ");
INSERT INTO bcc_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Agan kaséá wati golám yá móled latth jat o golám yá móled áiay dastá mort, gorhá janók sezá dayag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Bale agan golám yá móledá tán yakk o do róchá hecch nabut, gorhá janóká sezá pera nabit, chéá ke golám wati wájahay mál ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Agan mardénán jang o dáwá kort o hamé wahdá lápporrén janéné jatesh o janénay chokk eshkand but, bale dega masterén jáni táwáné naraseti, gorhá janók hamá dhandh o malámá porr bekant ke janénay marda lóthit o kázi begisshénant. ");
INSERT INTO bcc_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Bale agan janéná mazanén jáni táwáné raset, gorhá sáhay badal sáh ent, ");
INSERT INTO bcc_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","chammay badal chamm, dantánay badal dantán, dastay badal dast, páday badal pád, ");
INSERT INTO bcc_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","sóchkay badal sóchk, thappay badal thapp o zaymay badal zaym ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Agan kaséá wati golám yá móleday chammá shahmáté jat o áiay chamm kór but, gorhá chammay badalá golámá ázát bekant. ");
INSERT INTO bcc_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Agan wati móled yá golámay dantáni prósht, gorhá dantánay badalá golámá ázát bekant. ");
INSERT INTO bcc_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Agan gókéá mardén yá janéné kánth jat o kosht, gók sengsár kanag bebit o mardom áiay góshtá mawarant. Gókay wáhond sezá dayag mabit. ");
INSERT INTO bcc_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Bale agan á góká pésará ham kánth jatag o áiay wáhondesh hál dátag o hozzhár kortag, o wáhondá angat gók nabastag o á góká mardén yá janéné kosht, gók sengsár kanag bebit o wáhond markay sezá dayag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Bale agan cha gókay wáhondá malám lóthag but, gorhá pa wati zenday mókagá har malámé ke cha áiá lóthaga bit, bedant. ");
INSERT INTO bcc_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Agan góká kaséay bacch yá jenekké kánth jat, ódá ham kánun hamesh ent. ");
INSERT INTO bcc_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Agan góká golám yá móledé kánth jat, gorhá gókay wáhond golámay wájahá si shekel nograh bedant o gók sengsár kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Agan kaséá chátéay dapig dur kort yá agan kaséá cháté jat o áiay dapi nagept o gók yá haré chátá kapt, ");
INSERT INTO bcc_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","chátay wáhond malámán porr bekant, mortagén dalwatá bezurit o dalwatay wáhondá zarrán bedant. ");
INSERT INTO bcc_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Agan kaséay góká hamsáhegéay gók jat o á gók mort, gókáni wáhond janókén góká bahá bekanant o zarrán ném bekanant, mortagén dalwatá ham ném bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Bale agan mardoma zánant ke á góká pésará ham kánth jatag o angat wáhondá gók nabastag, gorhá á wáhond gókay badalá góké bedant o mortagéná bezurit.” ");
INSERT INTO bcc_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Agan kaséá góké yá pasé dozzet o helár kort yá bahái kort, gorhá gókay badalá panch gók o pasay badalá chár pas bedant. ");
INSERT INTO bcc_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Agan dozzéá lógé jat o hamé wahdá gerag but o haminkas latth o kotth kanag but ke mort, áiá hónbahá nést. ");
INSERT INTO bcc_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Bale agan é kár róchay dar áyagá rand but, gorhá hón, koshókay sará ent. Harkas ke dozzia kant, báyad ent malám porr bekant, bale agan pa malámay porr kanagá hecchi nést, gorhá jendi bahá kanag bebit o malám porr kanag bebant. ");
INSERT INTO bcc_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Bale agan dozzetagén mál, góké bebit yá haré yá pasé, áiay kerrá zendagá dar átk, gorhá do sari malám bedant. ");
INSERT INTO bcc_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Agan kaséá wati dalwat dhagár yá anguri bágéá cháréntant yá dega mardoméay dhagárá yalahi kortant, gorhá cha wati sharterén keshár yá anguri bágay sharterén bahrá malámá porr bekant. ");
INSERT INTO bcc_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Agan kaséá ásé rók kort o é ásá shamálah kasshet o dhangaráni tahá anchó sheng but ke kesháray grám yá dánay narotagén keshár yá dhagári sótkant, gorhá é ásay rók kanók purahén malámán porr bekant. ");
INSERT INTO bcc_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Agan kaséá zarr yá sámáné hamsáhegéay kerrá amánat kort o é amánat cha hamsáhegay lógá dozzag but, gorhá dozz do sari malám porr bekant, agan gerag but. ");
INSERT INTO bcc_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Bale agan gerag nabut, gorhá lógay wáhondá Hodáay bárgáhá bebarant ke zánag bebit ke áiá wati hamsáhegay mál dast jatag yá na. ");
INSERT INTO bcc_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Agan do mardom chizzéay sará arhet, góké bebit yá haré yá pasé yá cháderé yá dega gár butagén chizzé, gorhá é doénáni jérhah Hodáay bárgáhá barag bebit o harkas ke Hodáyá mayárbár kort, á, domiá do sari malám bedant. ");
INSERT INTO bcc_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","Agan kaséá haré, góké, pasé yá dega dalwaté wati hamsáhegay amánat kort o á dalwat mort yá thappig but yá barag but o kassá nadist, ");
INSERT INTO bcc_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","gorhá áyáni jérhah Hodáwanday sawgenday sará gisshénag bebit ke áiá amánat kortagén mál dast najatag. Dalwatay wáhond é sawgenday sará rázig bebit o sawgenday warók malám porr makant. ");
INSERT INTO bcc_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Bale agan dalwat cha áiay kerrá dozzag butag, gorhá á, dalwatay wáhondá malám bedant. ");
INSERT INTO bcc_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Agan dalwat rastaréá jatag o koshtag, gorhá á, pa sabut dalwatay jóná byárit o mortagén dalwatay malámá porr makant. ");
INSERT INTO bcc_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Agan kaséá cha hamsáhegéá dalwaté badal zort ke padá tará dayáni, o wáhond ódá nabut o á dalwat thappig but yá mort, gorhá badal zurók purahén malámá porr bekant. ");
INSERT INTO bcc_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Bale agan é kár wáhonday démá but, gorhá malám porr kanag mabit. Agan dalwat pa keréh zurag butag, gorhá keréhay jend bass ent.” ");
INSERT INTO bcc_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Agan mardéá janénchokké rad dát o gón áiá wapt o wáb kort o agan é jenekk kassi deshtár naent, gorhá áiay hakmehrá bedant o begipti. ");
INSERT INTO bcc_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Bale agan jenekkay pet wati jenekkay dayagá hecch warhá rázig nabut, gorhá é mardén, jenekkéay hakmehray kesásá zarr bedant. ");
INSERT INTO bcc_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Jádugerén janéná zendagá mayl. ");
INSERT INTO bcc_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Harkasá ke gón haywánéá wapt o wáb kort, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Harkasá ke cha Hodáwandá abéd pa dega hodáéá korbánig kort, gár o gomsár kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Gón darámadéá badi makan o ázári maday, chéá ke shomá wat Mesrá darámad butagét. ");
INSERT INTO bcc_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Cha janózám yá chórawéay majburiá nájáezén páedag chest makan. ");
INSERT INTO bcc_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Agan é kárá bekanay o á mani kerrá peryát bekanant, man allam áyani peryátán gósha dárán. ");
INSERT INTO bcc_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Mani hezhm chesta bit o shomárá pa zahma koshán, o shomay jan janózáma bant o chokk chóraw. ");
INSERT INTO bcc_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Agan mani mahlukay nézgáréá wámé dayay, gorhá wám dayókáni paymá makan o cha áiá byáj mager. ");
INSERT INTO bcc_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Agan taw wati hamsáhegay cháder pa zamánat wati kerrá ér kort, gorhá cha rónendá pésar peri tarrén. ");
INSERT INTO bcc_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Chéá ke balkén áiay póshák éwaká hamesh ent, gorhá ché per bedant o bwapsit? Agan mani kerrá peryát bekant, man gósha dárán, chéá ke man mehrabán án. ");
INSERT INTO bcc_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Kopr makan. Wati mahlukay saróká nálat makan. ");
INSERT INTO bcc_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Cha wati keshár o shiragán mani bahray dayagá dér makan. Wati awali mardénchokká maná beday. ");
INSERT INTO bcc_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Wati gók o pasáni awali narén chokká ham beday. Áyáni awali chokkán tán hapt róchá mátay kerrá bell o hashtomi róchá manáesh beday. ");
INSERT INTO bcc_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Shomá mani pák o dar chetagén kawm bebét. Á dalwat ke rastaréá jatag o koshtag, áiay góshtá mawarét, kochekkáni démá dawri dayét.” ");
INSERT INTO bcc_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Drógén hál sheng makan. Gón badkárán hamkári makan o drógén sháhedi maday. ");
INSERT INTO bcc_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Gón géshterén mardomán gón makap o badén kár makan. Jérhahéay sará ke sháhedia dayay, ensápá lagatmál makan, bell toré géshterén mardom hamá némagá ant. ");
INSERT INTO bcc_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Jérhahéay tahá nézgárén mardoméay wástá ham ru o ryá makan. ");
INSERT INTO bcc_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Agan taw wati dozhmenay ham gárén gók yá har dist, allam wáhonday kerrá sari kan. ");
INSERT INTO bcc_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Agan taw dist ke tai badwáhéay har báray chérá chér tarretag, poshtá mán maday o maraw. Báray bójagá komakki kan. ");
INSERT INTO bcc_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Agan tai kawmay garib o nézgáréá wati arz o peryát áwort, áiá béensáp makan. ");
INSERT INTO bcc_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Cha drógén bohtámjaniá pahréz kan. Bégonáh o rást o barhakkén mardomá markay sezá maday. Chéá ke man náhakkén mardomá bégonáh hesába nakanán. ");
INSERT INTO bcc_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","Roshwat mazur, chéá ke roshwat rozhnáén chammán kóra kant o rástgóay habará tába dant. ");
INSERT INTO bcc_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Darámadéáy sará zolm makan. Chéá ke taw zánay darámad bayag chón grán ent. Shomá wat ham Mesrá darámad atét.” ");
INSERT INTO bcc_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Tán shash sálá wati dhagárá bekesh o beron, ");
INSERT INTO bcc_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","bale haptomi sálá bell ke dhagár áráma kant. Kári madár, bell ke tai mahlukay garib o nézgára chenant o warant o sar átkagénán gyábánay jánwara warant. Wati anguray bág o zaytunay bágá ham anchosh kan. ");
INSERT INTO bcc_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Shash róchá kár kan o haptomi róchá árám kan ke tai gók o har dam bekanant o tai móleday chokk o tai lógá neshtagén darámaday arwáh tázadam bebit. ");
INSERT INTO bcc_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Mani é sajjahén habar ke man gón shomá kortant, eshán delgósh kanét. Á dega hodáyáni námá magerét. Cha shomay dapá áyáni nám ham dar mayayt.” ");
INSERT INTO bcc_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Sálé say randá pa man aid bekan. ");
INSERT INTO bcc_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Béhomirén Naganay Aidá barjáh bedár. Hamá paymá ke man tará hokm dátag, hapt róchá béhomirén nagan bwar. É kárá Abibay máhá, hamá wahdá bekan ke man gisshéntag, chéá ke hamé máhá shomá cha Mesrá dar átkét. Kass gón háligén dastán mani bárgáhá mayayt. ");
INSERT INTO bcc_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Rón o Móshay Aidá gón wati hamá kesháráni awali bar o samarán jashn beger ke taw wati dhagárá keshtagant. Érahtay Aidá sálay goddhi róchán jashn beger, hamá wahdá ke wati dhagáray bar o samará moccha kanay. ");
INSERT INTO bcc_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Sajjahén mardén sálé say randá Hodáwandén Hodáay bárgáhá byáyant. ");
INSERT INTO bcc_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Korbánigay hóná ke mani démá pésha kanay, tará hecch homirdárén chizz gón mabit. Mani aiday korbánigay pig tán sabáhá pasht makapit. ");
INSERT INTO bcc_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Wati zeminay awali bar o samará wati Hodáwandén Hodáay lógá byár. Shenekkay góshtá mátay shiray tahá lahrh maday. ");
INSERT INTO bcc_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Bechár, nun man préshtagé ráh dayagá án. É cha taw pésara bit ke ráhá tai páspániá bekant o tará mani tayár kortagén jágahá bebárt o sar bekant. ");
INSERT INTO bcc_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Áiay ehterámá bekan o habaráni gósh dár. Áiay helápá pád mayá ke tai náparmániá nabakshit. Chéá ke mani nám áiay bátená ent. ");
INSERT INTO bcc_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Bale agan áiay tawárá sharriay sará gósh bedáray o harché ke mana gwashán, hamá paymá bekanay gorhá man tai dozhmenáni dozhmena bán o tai badwáháni badwáh. ");
INSERT INTO bcc_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Mani préshtag cha taw pésar rawána bit o tará Amuri o Hitti o Perizzi o Kanháni o Héwi o Yabusiáni molká bárt. Man eshán gár o gomsára kanán. ");
INSERT INTO bcc_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Esháni hodáyáni parastesh o hezmatá makan o esháni káráni randgiriá makan. Esháni botén hodáyán sarjamiá karój o hamá sengán thokkor thokkor kan ke eshán pa wati parasteshgáhay neshán kanagá mekk kortagant. ");
INSERT INTO bcc_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Man tai Hodáwandén Hodá án. Mani hezmatá bekan, man tai rezk o rózigá barkata dayán o nádráhiá cha tai jáná dura dárán. ");
INSERT INTO bcc_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Tai molká kass chokk eshkanda nakant o kass santh o béawláda nabit. Man shomay omrá barkata dayán. ");
INSERT INTO bcc_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Man wati bimmá cha taw pésar ráha dayán o taw har kawméá ke dapa kapay, á kawmá sarbatag o sargardána kanán o sajjahén dozhmenán cha tai démá táchénán. ");
INSERT INTO bcc_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Man wati kahrá cha taw pésar ráha dayán o Héwi o Kanháni o Hittián cha tai démá dura kanán. ");
INSERT INTO bcc_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Bale yakk sáléay tahá cha tai démá duresha nakanán. Chó mabit ke zemin wayrandán bebit o gyábánay jánwar cha taw géshter bebant. ");
INSERT INTO bcc_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","É kawmán kamm kammá cha tai démá dura kanán tánke taw báz bayán bebay o é sardhagárá wati bekanay. ");
INSERT INTO bcc_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Cha Sohrzerá tán Pilestiáni zerá o cha gyábáná tán Parátay kawrá, tai simsarána gisshénán o é sardhagáray nendókán tai dastá dayán o taw áyán cha wati kerrá gallénay. ");
INSERT INTO bcc_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Gón eshán o esháni hodáyán ahd o paymán makan. ");
INSERT INTO bcc_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","É mardom tai molká manendant. Chó mabit ke tará dém pa gonáhá bebarant o taw mani náparmán bebay. Agan taw esháni hodáyáni parastesh bendát kort, allamá dáméá kapay.” ");
INSERT INTO bcc_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Hodáyá gón Mussáyá gwasht: “Borzád, mane Hodáwanday bárgáhá byá. Taw o Hárun o Nádáb o Abihu o Esráilay haptád kamásh byáét o cha durá parastesh kanét. ");
INSERT INTO bcc_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Éwaká tawe Mussá mane Hodáwanday kerrá byá. Á dega mardom nazzikká mayáyant. Mahluk ham tai hamráhiá borzád mayayt gón.” ");
INSERT INTO bcc_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mussá átk o Hodáwanday sajjahén habar o parmáni mardománá sar kortant. Sajjahén mahluká pa hamtawári gwasht: “Hodáwandá harché ke gwashtag, má anchosha kanén.” ");
INSERT INTO bcc_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mussáyá Hodáwanday sajjahén habar nebeshtah kortant. Mussá sohbá máhallah pád átk, kóhay boná korbánjáhé addhi kort o pa Esráilay dwázdahén kabilahán dwázdah sengi mekk kort. ");
INSERT INTO bcc_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Bani Esráilay warnái ráh dátant, áyán káiger zort o pa Hodáwandá sóchagi korbánig o hamdeliay korbánigesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mussáyá hónáni ném tagárán kort o á dega némi korbánjáhay sará dranzetant. ");
INSERT INTO bcc_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Ahd o paymánay ketábi zort o mardománi démá wánti. Áyán gwasht: “Harché ke Hodáyá gwashtag, má hamá paymá kanén o parmánbardára bén.” ");
INSERT INTO bcc_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mussáyá hón zort, mahlukay sará dranzet o gwashti: “É sajjahén wántagén habar hamá ahd o paymánayg ant ke Hodáwandá gón shomá bastag o é hamé ahd o paymánay hón ant.” ");
INSERT INTO bcc_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mussá o Hárun o Nádáb o Abihu o Esráilay haptádén kamásh borzá sar kaptant ");
INSERT INTO bcc_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","o Esráilay Hodáesh dist. Hodáay pádáni chérá sabzén nilomay paymén parshé at ke chó ásmánay jendá sáp at. ");
INSERT INTO bcc_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Hodáyá Esráiliáni sarók táwán nadátant. Áyán Hodá dist o hamódá warag o charagesh wárt. ");
INSERT INTO bcc_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Hodáwandá gón Mussáyá gwasht: “Kóhá sar kap, mani kerrá byá o kammé hamedá bejall ke man tará wánekána dayán ke esháni sará man pa kawmay sar o sójá Sharyat o parmán nebeshtah kortagant.” ");
INSERT INTO bcc_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mussá o áiay komakkár Yushá ráh geptant. Mussá Hodáay kóhá sar kapt. ");
INSERT INTO bcc_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Bale pésará gón Esráilay kamáshán gwashti: “Tánke má shomay kerrá wátarra nakanén, hamedá bejallét. Bechár, Hárun o Ahur shomay kerrá ant. Harkasá jérhahe but, hamesháni kerrá berawt.” ");
INSERT INTO bcc_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Mussá kóhá sar kapt o jambará kóh sarpósh kort. ");
INSERT INTO bcc_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Hodáwanday shán o shawkatá Sináay kóhay sará hankén kort o jambará kóh tán shash róchá sarpósh kort. Haptomi róchá Hodáwandá cha jambaray nyámá Mussá gwánk jat. ");
INSERT INTO bcc_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Esráiliáni chammán Hodáwanday shán o shawkatay dróshom pelekkókén ásay paymá at ke kóhay thollá jambur at. ");
INSERT INTO bcc_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Mussá kóhá sar kapt o jambaray tahá shot o tán chell shap o chell róchá hamódá jallet. ");
INSERT INTO bcc_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Gón Esráilián begwash ke pa man shogránah byárét. Cha hamá sajjahén mardomán shogránah bezurét ke delesha parmáit. ");
INSERT INTO bcc_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Cha mardomán é shogránahán begerét: teláh, nograh, brenj, ");
INSERT INTO bcc_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ásmáni o jamu o sohrén pazhm, sharrén lilom, bozay mud, ");
INSERT INTO bcc_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","gwarándhay ratkagén sohrén póst, dega paymén mohrén póst, chegerday dár, ");
INSERT INTO bcc_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","pa cherágán thél, pa per moshagi rógen o washbóén sóchokiá masálah o ");
INSERT INTO bcc_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","pa épód o sénagpóshá senge solaymán o dega gránkimmatén seng. ");
INSERT INTO bcc_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Pa man pákén jágahé addh bekanant ke man áyáni nyámá jahmenend bebán. ");
INSERT INTO bcc_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Tambu o tambuay tahay sajjahén sámánán hamá paymá addh bekanant ke man tará pésha dárán. ");
INSERT INTO bcc_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Cha chegerday dárá pétié addh bekanant ke drájiá do o ném dast bebit, práhiá yakk o ném dast o borziá ham yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Pétiá cha dhanná o tahá gón zagrén teláhá sarpósh kan. Gerdágerd teláhén patthié peri kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Pa pétiá teláhay chár karhi addh kan o pétiay chárén pádagán lecchénesh, do karhi yakk némagéá o do á dega némagá. ");
INSERT INTO bcc_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Cha chegerday dárá do gwarbásk addh kan o gón teláhá sarpóshesh kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Pa pétiay chest kanagá gwarbáskán cha pétiay kashay karhián begwázén. ");
INSERT INTO bcc_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Gwarbásk pétiay karhián bebant o cha karhián dar kanag mabant. ");
INSERT INTO bcc_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Sháhediay wánekán ke man tará dayán, hamé pétiá mánesh kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Cha zagrén teláhá kapáraté addh kan o pétiá sarpósh kan. Drájiá do o ném dast bebit o práhiá yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Teláhay do karrubi addh kan, teláhá bezur o thapp o addhesh kan. É karrubián sarpóshay doén sarán addh kan, ");
INSERT INTO bcc_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","yakk karrubié sarpóshay yakk saréá addh kan o á dega karrubiá domi sará. Sarpósh o doén saráni karrubián jetá jetá addh makan, é yakthokkor bebant. ");
INSERT INTO bcc_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Karrubiáni dém gón yakdomiá bebit o chammesh gón sarpóshá. Bánzolesh borzádiá pach bebant o sarpóshá sáhél bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Sarpóshá pétiay sará ér kan o hamá sháhediay wánekán ke man tará dayán, áyán pétiay tahá kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Man hamódá tai démá záhera bán o gón taw habara kanán, cha sarpóshay borzá, cha sháhediay pétiay saray doén karrubiáni nyámá Esráiliáni bárawá har parmáné ke hast, tará gwashánesh gón. ");
INSERT INTO bcc_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Cha chegerday dárá thébalé addh kan. Drájiá do dast bebit, práhiá yakk dast o borziá yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Gón zagrén teláhá sarpóshi kan o teláhay patthié addh kan o chárén némagán peri kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Thébalay sarbori tahtagá, chárén némagán teláhay patthié per kan o tahtagay chérá chárén némagán yakk panjagéay práhiay kaddén kábé per kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Pa thébalá teláhay chár karhi addh kan o karhián chárén kondhán, pádagán per kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","É karhi báyad ent kábay nazzikká bebant chéá ke thébalay chest kanagay wahdá gwarbáskána dárant. ");
INSERT INTO bcc_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Thébalay chest kanagay gwarbáskán cha chegerday dárá addh kan o gón teláhá sarpóshesh kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","É thébalay tál o tásán cha zagrén teláhá addh kan. Thébalay jag o hamá kásagán ham ke pa réchagi korbánigay ér réchagá kár bandaga bant, cha zagrén teláhá addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","‘Pákwandhén naganán’ modám hamé thébalay sará, mani démá ér kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Cha zagrén teláhá cherágdáné addh kan. Cherágdáná, bezán bon o bonsháh o pyálah o golbon o pollán thapp o addh kan, jetá jetá addhesh makan, é yakthokkor bebant. ");
INSERT INTO bcc_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Cha bonsháhay kashán shash sháharh dar byayt, say sháharh cha yakk kashéá o say sháharh cha á dega kashá. ");
INSERT INTO bcc_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Har sháharhá say pyálah per bebit, pyálaháni sarborá bádámay pollay warhén golbon o pollé per bebit. Cherágdánay har shashén sháharh hamé paymá bebant. ");
INSERT INTO bcc_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Cherágdánay bonsháhá chár pyálah per bebit, gón bádámay pollay warhén golbon o pollán. ");
INSERT INTO bcc_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Cha bonsháhá dar áyókén shashén sháharháni boná golbon bebit, yakk golboné awali doén sháharháni boná bebit, cha hamá jágahá kammé jahlter ke sháharh cha bonsháhá dara káyant, domi golbon domi doén sháharháni boná o sayomi golbon sayomi doén sháharháni boná bebit. ");
INSERT INTO bcc_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Golbon o sháharh o cherágdán yakthokkor bebant. É sajjahénán cha yakkén thappetagén zagrén teláhá addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Hapt cherág addh kan o cherágdáná peresh kan ke cherágdánay démay jágahá rozhná bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Cherágdánay sambálagay awzár o sámánán cha zagrén teláhá addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Pa cherágdán o eshiay sajjahén sámánáni addh kanagá yakk tálánté zagrén teláh kármarz kan. ");
INSERT INTO bcc_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Bechár, é sajjahén chizzán hamá paymá addh kan ke man tará kóhay sará pésh dásht. ");
INSERT INTO bcc_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Pa sháhediay tambuá dah pardah addh kan. É pardah cha hurtgwápen lilomá o cha ásmáni o jamu o sohrén pazhmá gwapag bebant. Honarmandén ezmkáré é pardahán karrubiay naksh per bekant. ");
INSERT INTO bcc_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Sajjahén pardah yakkén kadd o mápay bebant. Hamok pardah drájiá bist o hasht dast bebit o práhiá chár dast bebit. ");
INSERT INTO bcc_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Panch pardah bezur o gón yakdegará lecchén o á dega panchénán ham hamé paymá lecchén. ");
INSERT INTO bcc_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Awali reday goddhi pardahay lambá ásmánrangén lóp per kan o domi reday goddhi pardahay lambá ham anchosh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Yakk pardahéá panjáh lóp per kan o domi reday pardahay lambá ham panjáh lóp per kan. Doénáni lóp dém pa dém bebant. ");
INSERT INTO bcc_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Teláhay panjáh karhi addh kan o pardahán gón yakdegará jórhén ke tambu yakk bebit. ");
INSERT INTO bcc_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Pa tambuay póshagá cha syahpasay mudá pardah addh kan. Yázdah pardah addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Yázdahén pardah yakkén kadd o mápay bebant. Hamok pardahay dráji si dast bebit o práhi chár dast. ");
INSERT INTO bcc_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Panch pardah yakk redéá gón yakdegará lecchén o á dega shashénán dega redéá. Domi reday shashomi pardahá tambuay démi némagá dotalá patá. ");
INSERT INTO bcc_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Awali reday goddhi pardahay lambá panjáh lóp per kan o domi reday goddhi pardahay lambá ham panjáh lóp per kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Brenjay panjáh karhi addh kan o lópán mánesh kan ke tambu bejorhit o yakk bebit. ");
INSERT INTO bcc_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Tambuay pardaháni pasht kaptagén bahr tambuay sará, poshti némagá lónján bebit. ");
INSERT INTO bcc_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Tambuay drájiá é pardah ke doén némagán cha tambuá yakk dast master ant, é bell doén némagán lónján ant o tambuá póshant. ");
INSERT INTO bcc_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Tambuay sarbori póshá cha gwarándhay anchén póstéá addh kan ke rajag o sohr kanag butag o eshiay sarborá dega paymén mohrén póstay póshé per kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Pa tambuá cha chegerday dárá mekk kanagi tahtag addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Har tahtag drájiá dah dast bebit o práhiá yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Hamok tahtagá do zobánok per kan o é zobánok dap mán dap bebant. Tambuay sajjahén tahtagán hamé paym kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Pa tambuay jonubi némagá bist tahtag addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Nograhay chell bonhesht addh kan ke tahtagáni chérá dayag bebant. Pa hamok tahtagá do bonhesht addh kan. Hamok zobánokay chérá yakk bonheshté dayag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Pa tambuay á dega némagá, bezán pa tambuay shomáli némagá ham bist tahtag addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Pa tahtagáni chérá nograhay chell bonhesht addh kan, bezán do bonhesht pa har tahtagá. ");
INSERT INTO bcc_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Pa tambuay poshti bahrá, bezán rónendi némagá shash tahtag addh kan o ");
INSERT INTO bcc_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","pa poshti bahray kondhán do tahtag addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","É doén kondhán, é tahtag cha jahlá gón yakdegará belecchant o borzá dap mán dap kanag o yakkén karhiay tahá mán kanag bebant. Doén kondhán anchó kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Hasht tahtag bebant o nograhay shánzdah bonhesht, hamok tahtagay chérá do bonhesht. ");
INSERT INTO bcc_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","Cha chegerday dárá gwarbast addh kan. Panch gwarbast pa tambuay yakk némagéay tahtagán o ");
INSERT INTO bcc_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","panch gwarbast pa á dega némagay tahtagán o panch gwarbast pa rónendi némagay tahtagán, bezán pa tambuay poshti bahray tahtagán. ");
INSERT INTO bcc_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Nyámi gwarbast cha é sar tán á dega sará, tahtagán sakk bebit, tahtagáni ném borziá. ");
INSERT INTO bcc_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tahtagán gón teláhá sarpósh kan o pa gwarbastáni dáragá teláhay karhi addh kan. Gwarbastán ham gón teláhá sarpósh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Tambuá hamá paymá mekk kan ke man kóhay sará tará pésh dásht. ");
INSERT INTO bcc_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Cha ásmáni o jamu o sohrén pazhmá o cha hurtgwápén lilomá pardahé addh kan o honarmandén ezmkáré eshiay sará karrubiay naksh addh bekant. ");
INSERT INTO bcc_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Pardahá gón teláhay karhián chár chegerdi menokay sará dranj. É menok gón teláhá sarpósh kanag bebant o nograhay chár bonheshtay sará mekk bebant. ");
INSERT INTO bcc_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Pardahá karhián mán kan o dranj o sháhediay pétiá pardahay poshtá ér kan. Pardah pákén jágahá cha pákterén jágahá jetá kant. ");
INSERT INTO bcc_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Kapáratay sarpóshá pákterén jágahá érén sháhediay pétiay sará day. ");
INSERT INTO bcc_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Thébalá cha pardahá dhann, shomáli némagá ér kan o cherágdáná thébalay dém pa démá, jonubi némagá ér kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ásmáni o jamu o sohrén pazhm o hurtgwápén lilom bezur o pa tambuay dapá ranggwápén pardahé addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Pa é pardahá cha chegerdá panch menok addh kan o gón teláhá sarpóshesh kan. Esháni karhi teláhay bebant o pa eshán panch brenjén bonhesht ham addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Cha chegerday dárá korbánjáhé addh kan. Drájiá o práhiá panch panch dast bebit. Korbánjáh chárkondh bebit. Borziá say dast bebit. ");
INSERT INTO bcc_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Korbánjáhay chárén kondháni sará yakk o yakk kánthé addh kan. Kánthán o korbánjáhá jetá jetá addh makan, é yakthokkor bebant. Korbánjáhá gón brenjá sarpósh kan. ");
INSERT INTO bcc_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Korbánjáhay poráni dar kanagay tagári o bard o tás o chársháh o ásdán, sajjahén sámánáni cha brenjá addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Pa korbánjáhá jálié, bezán brenjay thathé addh kan o pa eshiay chárén kondhán cha brenjá chár karhi addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Jáliá korbánjáhay tóki lambáni chérá per kan o anchó éri kan ke korbánjáhay borziay némá sar bebit. ");
INSERT INTO bcc_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Cha chegerday dárá pa korbánjáhá gwarbásk addh kan o gón brenjá sarpóshesh kan. ");
INSERT INTO bcc_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Gwarbáskán cha karhián gwázén ke korbánjáhay chest kanagay wahdá korbánjáhay doén kashán bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Korbánjáhá cha dáray tahtagá addh kan. Tóki bell ke hórk o hálig ent. Hamá paymá addhi kan ke man tará kóhay sará pésh dásht. ");
INSERT INTO bcc_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Pa sháhediay tambuá péshgáhé addh kan. Pa péshgáhay jonubi némagá cha hurtgwápén lilomá pardah addh kan ke sarjamiá yakk sad dast bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Gón bist menok o bist brenjén bonheshtá addhesh kan. Menokáni band o karhi nograhay bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Shomáli némag ham hamé paymá bebit. Pardah sarjamiá yakk sad dast bebant, gón bist menok o bist brenjén bonheshtá. Menokáni band o karhi nograhay bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Péshgáhay rónendi némagay pardah sarjamiá panjáh dast bebant, gón dah menok o dah bonheshtá. ");
INSERT INTO bcc_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Péshgáhay ródarátki némagay pardah, hamá némag ke róch dara kayt, panjáh dast bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Péshgáhay dapay yakk némagéay pardah sarjamiá pánzdah dast bebant, gón say menok o say bonheshtá, ");
INSERT INTO bcc_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","o dapay á dega némagay pardah ham pánzdah dast bebant, gón say menok o say bonheshtá. ");
INSERT INTO bcc_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Pa péshgáhay dapá pardahé addh kan ke bist dast bebit, gón chár menok o chár bonheshtá. É pardah cha ásmáni o jamu o sohrén pazhm o cha hurtgwápén lilomá addh bebit o ranggwáp bebit. ");
INSERT INTO bcc_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Péshgáhay chapp o chágerday sajjahén menokáni band o karhi nograhay bebant o bonhesht brenjay. ");
INSERT INTO bcc_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Péshgáhay dráji yakk sad dast bebit, práhi panjáh dast o borzi panch dast bebit. Gón hurtgwápén lilomay pardah o brenjén bonheshtán addh kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Tambuay á dega sámán, pa tambuay har káréá ke kármarza bant, cha brenjá addh kanag bebant. Tambuay o péshgáhay sajjahén méh ham cha brenjá addh kanag bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Taw Esráilián hokm day ke zaytun beprenchét o zagrén thél dar kanét o pa cherágán byárét ke cherág har wahdá rók bebant. ");
INSERT INTO bcc_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Sháhediay tambuay tahá, cha hamá pardahá dhann ke sháhediay pétiay démá ent, Hárun o áiay mardénchokk, bezán dini péshwá Hodáwanday bárgáhá shapá tán sohbá cherágán rók bedárant. É pa Esráiliáni áyókén nasl o padréchán abadmánén parmáné. ");
INSERT INTO bcc_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Wati brát Hárun o áiay mardénchokkán, bezán Nádáb o Abihu o Elyázar o Itámárá cha Esráiliáni nyámá wati kerrá byár ke dini péshwá bebant o mani hezmatá bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Pa wati brát Háruná pákén god tayár kan ke Háruná brahdár o shándár bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Hamá sajjahén honarmand ke man pa choshén kárán dánái bakshátagant, áyán begwash ke Hárunay póshákán tayár bekanét ke Hárunesh gwará bekant o pa dini péshwái o mani hezmatá wapk bebit. ");
INSERT INTO bcc_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Esh ant hamá póshák ke tayár kanagi ant: sénagpóshé, épódé, kabáhé, naksh nakshén jámagé, págé o lánkigé. Pa tai brát Hárun o áiay mardénchokkán é póshákán tayár bekanant ke Hárun o chokk dini péshwá bebant o mani hezmatá bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","É póshákán cha teláhá o cha ásmáni o jamu o sohrén pazhmá o cha sharrén lilomá tayár bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Épódá gón teláhá o gón ásmáni o jamu o sohrén pazhmá o gón restagén sharrén lilomá tayár bekanant. É kárá honarmandén ezmkáré bekant. ");
INSERT INTO bcc_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Eshiay do srugá do sarkópag per kan ke épód bandag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Épóday band épóday paymá bebit, bezán gón teláhá o gón ásmáni o jamu o sohrén pazhmá o gón hurtgwápén lilomá tayár kanag bebit. É band o épód hór gwapag bebant, é yakthokkor bebant. ");
INSERT INTO bcc_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Do senge solaymán bezur o áyáni sará Esráilay mardénchokkáni námán ájen o naksh kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Áyáni pédá bayagay red o banday hesábá shash nám yakk sengéay sará o á dega shashén nám domi sengay sará bebant. ");
INSERT INTO bcc_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Hamá paymá ke ájenók mohré naksha chent, taw ham Esráilay chokkáni námán hamé doén sengáni sará ájen. Doén sengán do teláhay mohragjáhay tahá kan o ");
INSERT INTO bcc_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","épóday doén sarkópagán peresh kan ke Esráilay chokkáni yátgéjiay seng ant. Hárun Hodáwanday bárgáhá pa yátgéjiá esháni námán wati doén kópagáni sará bekant. ");
INSERT INTO bcc_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Teláhay mohragjáh addh kan o ");
INSERT INTO bcc_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","cha zagrén teláhá restagén sáday dhawlén do zamzilok addh kan o gón mohragjáhán lecchén. ");
INSERT INTO bcc_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Paysalahsáziay sénagpóshé addh kan. Eshiá épóday paymá addh kan, bezán cha teláhá o cha ásmáni o jamu o sohrén pazhmá o cha hurtgwápén lilomá addhi kan. É kárá honarmandén ezmkáré bekant. ");
INSERT INTO bcc_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","É sénagpósh chárkondh bebit o dotal bebit. Dráji o práhiá yakk yakk bechillé bebit. ");
INSERT INTO bcc_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Eshiay sará chár redá gránkimmatén seng lecchén. Awali redá rubi, pokráj o bayrel, ");
INSERT INTO bcc_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","domi redá pérózah, nilom o zomorrod, ");
INSERT INTO bcc_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","sayomi redá shunzén ákut, akik o jamuén ákut, ");
INSERT INTO bcc_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","cháromi redá teláhrangén ákut, senge solaymán o yashm. Eshán teláhén mohragjáhán benádén. ");
INSERT INTO bcc_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Seng, Esráilay chokkáni námáni hesábá bebant, dwázdah nám o dwázdah seng. Har yakkéay sará cha dwázdahén kabilahán yakkéay nám chó mohrá naksh bebit. ");
INSERT INTO bcc_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Pa sénagpóshá cha zagrén teláhá restagén sáday dhawlén zamzilok addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Pa sénagpóshá do teláhén karhi addh kan o sénagpóshay do srugá peresh kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Doén teláhén zamzilokáni yakk yakk saré bezur o sénagpóshay doén srugáni karhián mánesh kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Zamzilokáni domi sarán bezur o gón doén mohragjáhán lecchén, sarkópagáni démi némagá. ");
INSERT INTO bcc_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Cha teláhá do karhi addh kan o sénagpóshay á dega doén srugánesh per kan, hamá lambán ke démesh gón épódá ent. ");
INSERT INTO bcc_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Cha teláhá dega do karhi addh kan o épóday démá, sarkópagáni jahli némagá, épóday banday sarborá peresh kan, hamódá ke sarkópag gón épódá lecchetagant. ");
INSERT INTO bcc_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Sénagpóshay karhián gón ásmánrangén bandán épóday karhián anchó band ke sénagpósh épóday banday sarborá bebit o cha épódá masorit. ");
INSERT INTO bcc_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Hárun ke pákén jágahá rawt, Esráilay mardénchokkáni nám paysalahsáziay sénagpóshay sará pa yátgéji modám Hodáwanday bárgáhá áiá gón bebant. ");
INSERT INTO bcc_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Urim o Tumimá paysalahsáziay sénagpóshá mán kan ke wahdé Hárun Hodáwanday bárgáhá rawt, é áiay delay sará bebant. É dhawlá Hárun har wahdá Hodáwanday bárgáhá Esráilay paysalahsáziay awzárán wati delbandá bedárit. ");
INSERT INTO bcc_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Épóday kabáhá sarjamiá cha ásmánrangén godá addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kabáhá gotthé per bebit. Gotthay chapp o chágerdá káláray paymén dazgwápén kenárié per bebit ke gotth maderit. ");
INSERT INTO bcc_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Ásmáni o jamu o sohrén pazhmay anár addh kan o kabáhay lambá, chapp o chágerdá peresh kan o esháni nyámá teláhén zháng per kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kabáhay dámonay chapp o chágerdá zhángé o anáré, zhángé o anáré per kanán kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Hamá wahdá ke Hárun hezmat kanagá bit, é kabáhá gwará bekant. Wahdé Hodáwanday bárgáhá pákén jágahá rawt yá cha ódá dara kapit, zhángáni tawár eshkonag bebit o é habar zánag bebit ke Hárun zendag ent. ");
INSERT INTO bcc_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Cha zagrén teláhá patthié addh kan o é labzán chó mohray nakshá patthiay sará naksh kan: ‘Wapke Hodáwandi.’ ");
INSERT INTO bcc_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Eshiá gón ásmánrangén bandéá, págay démi némagá band. ");
INSERT INTO bcc_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","É Hárunay péshánigá bit o Esráili ke wapkén shogránaha dayant, shogránah harché ke bebant, agan é káray tahá radié but, zemmah Hárunay sará bit. É patthi har wahdá Hárunay péshánigá bit ke Hodáwand shogránahán kabul bekant. ");
INSERT INTO bcc_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Jámagá cha sharrén lilomá addh kan o nakshi per kan. Sharrén lilomay págé addh kan o ranggwápén lánkigé ham addh kan. ");
INSERT INTO bcc_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Pa Hárunay mardénchokkán anchén jámag o lánkig o koláh addh kan ke áyán brahdár o shándár bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","É godán wati brát Hárun o áiay chokkáni gwará day. Hárun o chokkán rógen per mosh o gisshén o wapkesh kan o dini péshwáiay kárá hamáyáni dastá day. ");
INSERT INTO bcc_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Pa áyán cha lilomá chérpósh addh kan ke áyáni jándariá bepóshant. É cha sréná tán ránán bebant. ");
INSERT INTO bcc_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Wahdé Hárun o áiay chokk sháhediay tambuay tahá yá korbánjáhay nazzikká rawant, bezán pa hezmatá pákén jágahá káyant, é chérpóshán bepóshant. Chó mabit ke gonáhé wati sará beladdhant o bemerant. É pa Hárun o áiay nasl o padréchá abadmánén parmáné. ");
INSERT INTO bcc_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Pa Hárun o áiay mardénchokkáni wapk kanagá é kárán bekan ke á dini péshwá bebant o mani hezmatá bekanant: yakk káigeré o do gwarándh bezur, hecch aybesh mán mabit. ");
INSERT INTO bcc_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Cha sharrén gandomay ártá béhomirén nagan o béhomirén rógeni kólok o béhomirén tanakkén poráthah bepach. ");
INSERT INTO bcc_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Eshán saptéá kan o é saptá káiger o doén gwarándháni hamráhiá byár. ");
INSERT INTO bcc_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Hárun o áiay chokkán sháhediay tambuay dapá byár o áyáni jáná shód. ");
INSERT INTO bcc_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","God o póshákán bezur o jámag o épóday kabáh o épód o sénagpóshá Hárunay gwará day. Épódá gón épóday bandá band. ");
INSERT INTO bcc_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Págá Hárunay sará day o teláhay patthiá, bezán pákén tájá págay sará band. ");
INSERT INTO bcc_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Per moshagi rógen bezur o Hárunay sará ér réch o peri mosh. ");
INSERT INTO bcc_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Hárunay chokkán byár o jámagesh gwará day o ");
INSERT INTO bcc_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","koláhesh sará day. Hárun o áiay chokkáni sréná lánkig band. É abadmánén parmáné ke dini péshwái hamáyánig ent. É kárá Hárun o áiay chokkáni dastá day. ");
INSERT INTO bcc_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Káigerá tambuay démá byár o Hárun o áiay chokk káigerá dastá baddhá bejanant. ");
INSERT INTO bcc_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Káigerá Hodáwanday bárgáhá, tambuay dapá helár kan. ");
INSERT INTO bcc_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Cha káigeray hónán kammé bezur o gón wati lankoká korbánjáhay kánthán per mosh o sar átkagén hónán korbánjáhay boná réch. ");
INSERT INTO bcc_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Cháderpig o sarjagar o doén gotthag o gotthagáni pigán bezur o korbánjáhay sará sóch. ");
INSERT INTO bcc_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Bale káigeray gósht o póst o rótán cha ordgáhá dhann sóch. É gonáháni pahelliay korbánig ent. ");
INSERT INTO bcc_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Awali gwarándhá byár, Hárun o áiay chokk gwarándhá dastá baddhá bejanant o ");
INSERT INTO bcc_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","taw gwarándhá helár kan o hónáni bezur o korbánjáhay sajjahén némagán dranz day. ");
INSERT INTO bcc_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Gwarándhá thokkor thokkor kan, delig o lápig o pádáni shód o gón sarag o á dega thokkorán yakjáh ér kan. ");
INSERT INTO bcc_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Sarjamén gwarándhá korbánjáhay sará sóch. É pa Hodáwandá sóchagi korbánigé bit, táhirbakshén washbóé o pa Hodáwandá ásjatén korbánigé. ");
INSERT INTO bcc_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Nun domi gwarándhá byár, Hárun o áiay chokk gwarándhá dastá baddhá bejanant o ");
INSERT INTO bcc_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","taw gwarándhá helár kan o cha áiay hónán kammé bezur o Hárun o áiay chokkáni rástén góshay dorjáhá o áyáni rástén dast o rástén páday máti lankokán per mosh o sar átkagén hónán korbánjáhay sajjahén némagán dranz day. ");
INSERT INTO bcc_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kammé per moshagi rógen o cha korbánjáhay sará kammé hón bezur o Hárun o áiay godáni sará o Hárunay chokk o áyáni godáni sará dranz day. Gorhá Hárun o áiay god o áiay chokk o chokkáni god wapke Hodáwandia bant. ");
INSERT INTO bcc_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","É gwarándh ke péshwáay págbandiay rasmay gwarándh ent, eshiay pigán, bezán dombag o cháderpig o sarjagar o doén gotthagán gón pigán o rástén páday boná bezur o ");
INSERT INTO bcc_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","cha Hodáwanday bárgáhay saptay béhomirén naganán yakk gerdén kóloké o yakk bazén o yakk tanakkén poráthahé bezur o ");
INSERT INTO bcc_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","é sajjahénán Hárun o áiay chokkáni dastáni delá day o áyáni dastán Hodáwanday bárgáhá chest kan ke é chest kanagi korbánigé. ");
INSERT INTO bcc_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Nun é chizzán cha áyáni dastán bezur o korbánjáhay sará sóchagi korbánigay sará éresh kan o sóchesh. É Hodáwanday bárgáhá táhirbakshén washbóé o pa Hodáwandá ásjatén korbánigé. ");
INSERT INTO bcc_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Gorhá hamá gwarándh ke pa Hárunay péshwáiay págbandiay rasmá korbánig kanaga bit, áiay sénagá bezur o chest kanagi korbánigéay hesábá Hodáwanday bárgáhá chesti kan. É tai wandh ent. ");
INSERT INTO bcc_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Péshwáay págbandiay gwarándhay hamá sénagá o páday boná wapk kan ke chest kanagi korbánigay tahá atant. É Hárun o áiay chokkáni wandh ent. ");
INSERT INTO bcc_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","É cha Esráiliáni némagá pa Hárun o áiay chokkán abadmánén shogránahé, cha hamá hamdeliay korbánigán ke Esráili pa Hodáwandá kanantesh. ");
INSERT INTO bcc_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Cha Háruná rand Hárunay pákén god áiay chokkániga bant ke á hamé godáni tahá rógen per moshag bebant o áyáni págbandiay rasm sarjam kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Hamá chokk ke Hárunay jágahá dini péshwá bit o tambuay tahá pákén jágahá rawt o hezmata kant, eshán tán hapt róchá gwará bekant. ");
INSERT INTO bcc_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Péshwáay págbandiay gwarándhá bezur o áiay góshtá pákén jágahéá lahrh day. ");
INSERT INTO bcc_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Hárun o áiay chokk tambuay dapá gwarándhay gósht o saptay tahay naganán bwarant. ");
INSERT INTO bcc_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Á é chizzán wat bwarant, chéá ke é chizz pa áyáni págbandi o wapkiay rasmá kapáraté ant. Dega kass eshán mawárt, chéá ke é pákén warák ant. ");
INSERT INTO bcc_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Agan cha péshwáay págbandiay korbánigay gósht yá naganán tán sabáhá chizzé pasht kapt, besóchesh. Eshán mawar chéá ke pákén warák ant. ");
INSERT INTO bcc_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Hamé paymá ke man tará hokm dátag, gón Hárun o áiay chokkán anchó bekan. Hapt róchá péshwáiay págbandiay rasmá sarjam kan. ");
INSERT INTO bcc_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Pa gonáhay korbánigá har róch káigeré bekosh, pa kapáratá. Kapárat beday o korbánjáhá pák o palgár kan. Korbánjáhá rógen per mosh ke pák o palgár bebit. ");
INSERT INTO bcc_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Hapt róchá kapárat beday o korbánjáhá pák o palgár kan. Nun korbánjáh cha páká pákera bit o har chizzé ke gón eshiá dhokk belaggit, páka bit. ");
INSERT INTO bcc_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","É hamá chizz ant ke báyad ent taw eshán modám korbánjáhay sará pésh bekanay, har róch: do yakk sálagén gwarándh. ");
INSERT INTO bcc_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Yakké sohbá pésh kan o yakké magrebtahárá. ");
INSERT INTO bcc_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Yakk o ném sér sharrén árt gón yakk séré zaytunay zagrén thélá hawár kan o awali gwarándhay hamráhiá pésh kan. Yakk séré sharáb ham pésh kan ke réchagi korbánig ent. ");
INSERT INTO bcc_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Domi gwarándhá magrebtahárá pésh kan, sohbay dánay korbánigay paymá, o réchagi korbánigá ham pésh kan. É táhirbakshén washbóé o pa Hodáwandá ásjatén korbánigé. ");
INSERT INTO bcc_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","É sóchagi korbánig nasl pa nasl modám sháhediay tambuay dapá Hodáwanday bárgáhá pésh kanag bebant. Man hamódá gón taw gendoka kanán o gón taw habara kanán. ");
INSERT INTO bcc_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Gón Esráili mahluká ham hamedá gendoka kanán o é jágah mani shán o shawkatay barkatá páka bit. ");
INSERT INTO bcc_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Man tambu o korbánjáhá pák o palgára kanán o pa wata gisshénán, Hárun o áiay chokkán ham pák o palgára kanán o pa wata gisshénán ke dini péshwá bebant o mani hezmatá bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Man Esráiliáni nyámá jahmenenda bán o áyáni Hodá bán. ");
INSERT INTO bcc_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Gorhá á zánant ke man áyáni Hodáwandén Hodá án, hamá Hodá ke áyáná cha Mesrá daron kort ke áyáni nyámá nendók bebán. Man áyáni Hodáwandén Hodá án. ");
INSERT INTO bcc_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Pa sóchokiay chér sóchagá korbánjáhé addh kan, cha chegerday dárá addhi kan. ");
INSERT INTO bcc_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Chárkondhi kan, drájiá yakk dast bebit, práhiá ham yakk dast o borziá do dast. Kánth o korbánjáh hór addh bebant, é yakthokkor bebant. ");
INSERT INTO bcc_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Korbánjáhay sará o sajjahén némagán o kánthán gón zagrén teláhá sarpósh kan o chapp o chágerdá teláhén patthié peri kan. ");
INSERT INTO bcc_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Pa korbánjáhá teláhay karhi addh kan o hamé patthiay chérá peresh kan. Korbánjáhay doén kashán do do karhi per kan ke korbánjáhay chest kanagay wahdá gwarbáskán bedárant. ");
INSERT INTO bcc_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Gwarbáskán cha chegerday dárá addh kan o gón teláhá sarpósh kan. ");
INSERT INTO bcc_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Korbánjáhá hamá pardahay démá ér kan ke sháhediay pétiay démá ent, bezán kapáratay sarpóshay démá ke sháhediay wánekáni sarborá ent, hamá jágahá ke man gón taw gendoka kanán. ");
INSERT INTO bcc_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Hárun har sohb ke cherágán chárit o delgósha kant, bósóchi korbánjáhay sará washbóén sóchoki chér besóchit. ");
INSERT INTO bcc_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Magrebtahárá ke Hárun cherágán róka kant, padá sóchoki chér besóchit. É Hodáwanday bárgáhá dáemi chér sóchagi korbánigé, nasláni nasl. ");
INSERT INTO bcc_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Eshiay sará dega paymén sóchoki o sóchagi korbánig yá dánay korbánig chér masóchét o eshiay sará réchagi korbánig maréchét. ");
INSERT INTO bcc_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Hárun sálé yakk randé eshiay kántháni sará mahlukay gonáháni kapáratá bekant. É kapárat cha gonáháni kapáratay hóná kanag bebit, sálé yakk randé, nasláni nasl. É pa Hodáwandá cha páká pákter ent.” ");
INSERT INTO bcc_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Wahdé pa mardomshomáriá Esráilián hesába kanay, harkasay nám ke nebisaga bit, pa wati zenday mókagá Hodáwandá kapárat bedant. Gorhá námnebisiay wahdá wabáé áyáni chakká nakapit. ");
INSERT INTO bcc_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Hamá mardom ke námesh nebisaga bant, ném shekel bedayant, pákén jágahay shekelay hesábá ke shekelé bist géráh ent. É ném shekel pa Hodáwandá shogránahé. ");
INSERT INTO bcc_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Harkas ke omri bist sál yá géshter ent, námi nebisag bebit o Hodáwanday shogránahá bedant. ");
INSERT INTO bcc_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Wahdé pa wati zenday mókagá Hodáwanday shogránahá dayét, hastómand cha ném shekelá géshter o nézgár kamter madayant. ");
INSERT INTO bcc_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Cha Esráilián kapáratay zarrán beger o sháhediay tambuay hezmati káráni sará harchesh kan. Hodáwanday bárgáhá é, pa Esráilián wati zenday mókagay kapáratay yátgéjé.” ");
INSERT INTO bcc_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Pa shosht o shódá brenjay trashté addh kan o pádagi ham brenjay bebit. Sháhediay tambu o korbánjáhay nyámá éri kan o ápi mán kan. ");
INSERT INTO bcc_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Hárun o áiay mardénchokk wati dast o pádán gón hamé ápán beshódant. ");
INSERT INTO bcc_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Har wahdá ke tambuay tahá káyant, watá beshódant ke mamerant, hamá wahdá ham watá beshódant ke korbánjáhay nazzikká káyant ke hezmat bekanant o pa Hodáwandá ásjatén korbánig chér besóchant. ");
INSERT INTO bcc_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Wati dast o pádán beshódant ke mamerant. É pa Hárun o áiay nasl o padréchá abadmánén parmáné, nasláni nasl.” ");
INSERT INTO bcc_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“É sharterén washbóán bezur: panch sad shekel ápén morr, morráni némay kesásá bezán do sad o panjáh shekelay kesásá washbóén dárchini, do sad o panjáh shekel washbóén kándhél, ");
INSERT INTO bcc_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","panch sad shekel káshyá, sajjahén pákén jágahay shekelay hesábá bebant, o chár sér zaytunay thél. ");
INSERT INTO bcc_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Eshán bezur o per moshagi pákén rógené addh kan, washbóén rógené. Eshán hamá paymá hawár kan ke atrsáz washbó addha kanant. É per moshagi pákén rógéna bit. ");
INSERT INTO bcc_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Tambu o sháhediay péti o ");
INSERT INTO bcc_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","thébal o thébalay sajjahén sámán o cherágdán o cherágdánay sámán o bósóchi korbánjáh o ");
INSERT INTO bcc_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","sóchagi korbánigáni korbánjáh o áiay sajjahénán sámán o trasht o trashtay pádagá rógen per mosh. ");
INSERT INTO bcc_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Eshán wapk kan ke cha páká pákter bebant. Har chizz ke gón eshán dhokk belaggit, páka bit. ");
INSERT INTO bcc_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Hárun o áiay chokkán rógen per mosh o wapkesh kan ke dini péshwá bebant o mani hezmatá bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Gón Esráilián begwash: ‘É mani per moshagi pákén rógen ent, pa shomá, nasláni nasl. ");
INSERT INTO bcc_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Eshiá harkasá per mamoshét o é sámánán é dhawlá hawár makanét o dega choshén rógen addh makanét. É pákén rógené, eshiay kadrá bekanét. ");
INSERT INTO bcc_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Harkasá eshiay paymén washbóé addh kort yá anchén mardoméá peri mosht ke dini péshwáé naent, cha wati mahluká sendaga bit.’” ");
INSERT INTO bcc_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Hodáwandá gón Mussáyá gwasht: “É chizzán bezur o hawár kan: drachki shirag, sadap, galbanum o zagrén konderk, sajjahénáni kacch o kesás yakk bebit. ");
INSERT INTO bcc_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Hamá paymá hawáresh kan o washbóén sóchokié addh kan ke atrsáz washbó addha kant. É sóchoki wádók o zagr o pák bebit. ");
INSERT INTO bcc_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Cha eshán lahtén bedrosh o árt kan o tambuá sháhediay pétiay démá, ér kan, hamódá ke man gón taw gendoka kanán. Eshiay kadrá bezánét ke cha páká pákter ent. ");
INSERT INTO bcc_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Pa wati jendá sóchoki é paymá addh makanét. Hodáwanday bárgáhá é pákén chizzé, eshiay kadrá bekanét. ");
INSERT INTO bcc_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Harkasá pa wati delwasshiá é paymén sóchokié addh kort, cha wati mahluká sendaga bit.” ");
INSERT INTO bcc_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Bechár, man cha Yahudáay kabilahá Uriay chokk, Ahuray nomásag Besalél gechén kortag o ");
INSERT INTO bcc_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","cha Hodáay Ruhá porr kortag o agl o pahm o zánt o har kesmén dastay honar bakshátag ");
INSERT INTO bcc_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ke teláh o nograh o brenjay chizzáni sará naksh jórh bekant o ");
INSERT INTO bcc_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","sengáni tráshag o nádénagay kárá bekant o dár beájent o har paymén ezmkári bekant. ");
INSERT INTO bcc_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Man cha Dánay kabilahá Ahimásakay chokk Ohulyáb ham gechén kortag ke Besalélá komakk bekant. Man sajjahén honarmand dánái bakshátagant ke hamá sajjahén chizzán addh bekanant ke man tará hokm dátag: ");
INSERT INTO bcc_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","sháhediay tambu o sháhediay péti o pétiay saray sarpósh o tambuay é dega sajjahén sámánán, ");
INSERT INTO bcc_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","bezán thébal o thébalay sámánán, cha zagrén teláhá addh butagén cherágdán o cherágdánay sajjahén sámánán, bósóchi korbánjáhá, ");
INSERT INTO bcc_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","sóchagi korbánigay korbánjáh o áiay sajjahén sámánán, trasht o trashtay pádagá addh bekanant o ");
INSERT INTO bcc_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","dazgwápén godán, bezán dini péshwá Hárunay pákén god o pa dini péshwáiá áiay chokkáni godán addh bekanant o ");
INSERT INTO bcc_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","per moshagi rógen o pa pákén jágahá washbóén sóchoki ham addh bekanant. É sajjahén chizzán hamá paymá addh bekanant ke man tará hokm dátag.” ");
INSERT INTO bcc_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Esráilián begwash: ‘Mani Shabbatán allam barjáh bedárét. É pa shomay áyókén nasl o padréchán mani o shomay nyámay ahd o karáray neshánia bit tánke shomá bezánét ke man Hodáwand án, hamá ke shomárá gechéni kortag o shomárá pák o palgára kant. ");
INSERT INTO bcc_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Shabbatá barjáh bedárét chéá ke pa shomá gisshénag butag o pák o palgár ent. Harkasá eshiay béezzati kort, áiay sezá mark ent. Harkasá ke é róchá kár kort, cha wati mahluká sendaga bit. ");
INSERT INTO bcc_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Shash róchá kár kanét, bale haptomi róch Shabbat ent, árám kanagay róch ent. É róchá pa mane Hodáwandá wapk kanét. Harkasá Shabbatay róchá kár kort, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Esráili Shabbatá barjáh bedárant, nasláni nasl chó abadmánén ahd o paymánéá barjáhi bedárant. ");
INSERT INTO bcc_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","É tán abad mani o Esráilay nyámay ahd o karáray neshánia bit, chéá ke mane Hodáwandá shash róchá zemin o ásmán addh kortant o haptomi róchá árám kort o tázadam bután.’” ");
INSERT INTO bcc_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Wahdé Hodáwandá Sináay kóhay sará gón Mussáyá habar halás kort, sháhediay doén wáneki Mussáay dastá dátant, sengay do wánek atant ke esháni sará Hodáwandá dahén parmán daste wat nebeshtah kortagatant. ");
INSERT INTO bcc_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Wahdé mahluká dist ke Mussáyá cha kóhá ér kapagá sakk dér kort, Hárunay chapp o chágerdá mocch butant o gwashtesh: “Byá, pa má hodá addh kan ke ráhá cha má pésar bebant, chéá ke á mard, Mussá ke márá cha Mesrá dari kort o áworti, nazánén á chón but.” ");
INSERT INTO bcc_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Háruná gón áyán gwasht: “Wati jan o bacch o jenekkáni gósháni teláhén nálokán kasshét o mani kerrá byárét.” ");
INSERT INTO bcc_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Sajjahén mahluká teláhay nálok cha góshán kasshet o Hárunay kerrá áwortant. ");
INSERT INTO bcc_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Háruná áyáni dátagén teláh zort o áp kortant. Teláhi kálebéá kortant o botén gwaské addhi kort. Mardomán gwasht: “Oo Esráil! É tai hodá ent ke tará cha Mesrá dar kort o áworti.” ");
INSERT INTO bcc_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Háruná ke mardománi é hálat dist, gwaskay démá korbánjáhé addhi kort o jári jat: “Bándá Hodáwanday námá jashn ent.” ");
INSERT INTO bcc_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Domi róchá mahluk máhallah pád átk o sóchagi korbánigi chér sótk o hamdeliay korbánigi kort. Gorhá nesht o ward o nóshesh kort o pa layb o labáiá pád átkant. ");
INSERT INTO bcc_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Hodáwandá gón Mussáyá gwasht: “Ér kap, chéá ke é tai mahluk ke taw cha Mesrá dar kort o áwort, nun selkáriá laggetag. ");
INSERT INTO bcc_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Eshán mani sój dátagén ráh zutt yalah dátag. Pa wat botén gwaské addhesh kortag o sojdahesh kortag. Pa áiá korbánigesh kortag o gwashtagesh: ‘Oo Esráil! É tai Hodá ent ke tará cha Mesrá dar kort o áworti.’ ");
INSERT INTO bcc_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Bechár, man é mahluk distag. É náparmán o watsarén kawmé. ");
INSERT INTO bcc_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Taw mani démá mán matarr. Bell mani hezhm eshána sóchit o pora kant. Man cha taw dega mazanén kawmé addha kanán.” ");
INSERT INTO bcc_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Bale Mussáyá wati Hodáwandén Hodáay kerrá peryát o zári kort o gwasht: “Oo Hodáwand! É mahluk ke taw gón mazanén wáké o zórmandén dasté cha Mesrá dar kort o áwort, nun eshán chéá tai hezhm besóchit? ");
INSERT INTO bcc_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Chéá Mesri begwashant: ‘É mardomi cha Mesrá pa badniyati dar kortant ke kóh o gyábánán bebárt o bekoshitesh o cha jaháná gáresh bekant’? Wati hezhmay ásá kosh. Wati erádahá badal kan o é baláhá wati mahlukay sará dawr maday. ");
INSERT INTO bcc_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Wati hezmatkár Ebráhém o Esák o Esráilá yát kan ke taw gón áyán wati jenday sawgend wárt o gwasht ke man shomay nasl o padréchá ásmánay estáráni paymá báza kanán o anchó ke man gón shomá wádah kortag, é sajjahén sardhagárá shomay nasl o padréchárá dayán o tán abad hamáyáni mirása bit.” ");
INSERT INTO bcc_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Hodáwandá erádah kortagat ke wati mahlukay sará baláhé dawra dayán, bale erádahi badal kort. ");
INSERT INTO bcc_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Mussá per tarret o cha kóhá ér kapt. Ér kapagay wahdá Mussáyá sháhediay doén wánek dastá atant. Wánekáni doén némagán nebeshtah per at, é dém o á dém nebeshtah atant. ");
INSERT INTO bcc_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Wánek Hodáay tráshtagén atant o nebeshtah Hodáay daznebesht atant ke áiá wánekáni sará ájetagatant. ");
INSERT INTO bcc_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Yusháyá mahlukay kukkáráni tawár eshkot o gón Mussáyá gwashti: “Ordgáhá jangéay tawár ent.” ");
INSERT INTO bcc_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mussáyá gwasht: “É na sóbén bayagi kukkáré o na prósh waragi záré. Mani góshán é sawti tawáré.” ");
INSERT INTO bcc_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Wahdé Mussá ordgáhay nazzikká sar but, gwaski dist. É ham disti ke mardom náchá ant. Mussá sakk zahr gept o kóhay boná wati dastay wáneki zeminá dawr dát o thokkor thokkor kortant. ");
INSERT INTO bcc_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Hamá gwask ke mardomán addh kortagat, Mussáyá zort o bon dát. Nun chopt o hurt o árti kort o hurdagi ápá rétkant o ápi Esráiliáná wáréntant. ");
INSERT INTO bcc_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mussáyá gón Háruná gwasht: “É mardomán chón tará parmát o taw choshén baláhén gonáhé esháni chakká áwort?” ");
INSERT INTO bcc_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Háruná gwasht: “Zahr mager, wájah! Taw wata zánay ke é mardom pa gonáhá delé dayant. ");
INSERT INTO bcc_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Eshán maná gwasht: ‘Pa má hodá addh kan ke ráhá cha má pésar bebant, chéá ke á mard, Mussá ke márá cha Mesrá dari kort o áworti, nazánén á chón but.’ ");
INSERT INTO bcc_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Man gón áyán gwasht: ‘Harkasá ke teláhay saht o zéwar per, kasshét o byárétesh.’ Eshán wati teláh maná dátant. Man zort o ásá chagal dátant o é gwask cha ásá dar átk.” ");
INSERT INTO bcc_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mussáyá dist ke mardom bémahár ant o Háruná esháni mahár yalah dátag. Nun é mardom dozhmenáni kalági jórh butagant. ");
INSERT INTO bcc_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Mussá ordgáhay dapá óshtát o gwashti: “Harkas ke Hodáwanday némagá ent, mani kerrá byayt.” Láwiay sajjahén chokk Mussáay kerrá mocch butant. ");
INSERT INTO bcc_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mussáyá gwasht: “Hodáwand, Esráilay Hodá chosha gwashit: ‘Shomá sajjahén wati zahmán lánká bebandét o ordgáhá é sará tán á sará berawét o byáét o wati brát o dóst o nazzikén mardomán bekoshét.’” ");
INSERT INTO bcc_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Láwiay chokkán Mussáay habar zort. Á róchá kesás say hazár mardom koshag but. ");
INSERT INTO bcc_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Mussáyá gwasht: “Maróchi shomá pa Hodáwandá gechén kanag butagét, chéá ke shomá sajjahén wati chokk o brátáni helápá pád átkagét. Paméshká maróchi shomárá Hodáwanday barkat rasetag.” ");
INSERT INTO bcc_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Domi róchá Mussáyá gón mahluká gwasht: “Shomá mazanén gonáhé kortag. Bale man borzáda bán o Hodáwanday bárgáhá rawán. Balkén shomay gonáháni kapáratá dát bekanán.” ");
INSERT INTO bcc_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mussá Hodáwanday bárgáhá per tarret o gón Hodáwandá gwashti: “Off ke é mardomán chónén mazanén gonáhé kortag. Pa wat teláhén hodáé addhesh kortag. ");
INSERT INTO bcc_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nun agan buta kant esháni gonáhá bebaksh, bale agan nabakshay, gorhá mani námá cha hamá ketábá dar kan ke taw nebeshtah kortag.” ");
INSERT INTO bcc_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Hodáwandá gón Mussáyá gwasht: “Harkas ke mani gonahkár ent, man áiay námá cha wati ketábá dara kanán. ");
INSERT INTO bcc_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Nun beraw o mardomán dém pa hamá jágahá bar ke áiay bárawá man gón taw habar kortag. Mani préshtag cha taw pésara bit. Bale sezáay róchá man esháni gonáhay sezáyá dayán.” ");
INSERT INTO bcc_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Nun Hodáwandá paméshká wabáé mahlukay chakká dawr dát ke Háruná gwaské addh kortagat o mardomán parastesh kortagat. ");
INSERT INTO bcc_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Hodáwandá gón Mussáyá gwasht: “É jágahá yalah kan, taw o é mahluk ke taw cha Mesrá dar kortag o áwortag. Dém pa hamá molká beraw ke man gón Ebráhém o Esák o Ákubá sawgend wártag ke tai nasl o padréchárá dayáni. ");
INSERT INTO bcc_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Man préshtagé cha taw pésar ráha dayán o Kanháni o Amuri o Hitti o Perizzi o Héwi o Yabusiána gallénán. ");
INSERT INTO bcc_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Hamá molká beraw ke ódá shir o bénagay jó tachagá ant. Bale man gón taw hamráha nabán, chó mabit ke ráhá tará tabáh o barbád bekanán, chéá ke taw náparmán o watsarén kawmé ay.” ");
INSERT INTO bcc_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Mahluká ke é dardnákén habar eshkot, mótk o záriá lagget o kassá saht o zéwar per nakort, ");
INSERT INTO bcc_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","chéá ke Hodáwandá gón Mussáyá gwashtagat: “Esráilián begwash: ‘Taw náparmán o watsarén kawmé ay. Man agan pa damánéá ham gón taw hamráh bebán, balkén tará tabáh o barbád bekanán. Nun wati saht o zéwarán kassh. Mana charán ke gón taw ché bekanán.’” ");
INSERT INTO bcc_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Esráilián Hórébay kóhá wati saht o zéwar kasshetant. ");
INSERT INTO bcc_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mussáyá modám tambué zort o cha ordgáhá dur mekka kort. É tambuay námi gendokay tambu kort. Harkas ke Hodáwanday sar o sójáni lóthók at, cha ordgáhá dhann gendokay tambuá shot. ");
INSERT INTO bcc_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Har wahdá ke Mussá dara átk o dém pa tambuá ráha gept, sajjahén mahluk páda átk o harkas wati jenday gedánay dapá óshtát o tán hamá wahdá Mussáia cháret ke Mussá tambuá shot. ");
INSERT INTO bcc_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Wahdé Mussá tambuá shot, jambaray menok éra átk o tambuay dapá óshtát o Hodáwandá gón Mussáyá habara kort. ");
INSERT INTO bcc_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Wahdé mahluká dist ke jambaray menok tambuay dapá óshtátag, sajjahén mardom páda átk o wati gedánáni dapá óshtátant o Hodáwandesh parastesha kort. ");
INSERT INTO bcc_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Hodáwandá gón Mussáyá dém pa démá habara kort, sangatéay paymá. Randá Mussá ordgáhá shot, bale Yushá cha tambuá dara nakapt. Yushá Nunay chokk o Mussáay warnáén hezmatkár at. ");
INSERT INTO bcc_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mussáyá gón Hodáwandá gwasht: “Bechár, taw maná gwashagá ay: ‘É mahlukay rahshóniá bekan’ bale taw maná hál dayagá naay ke mani hamráh kay ent. Taw maná gwashtag ke ‘man tawe Mussáyá pajjáha kárán, tará tai jenday námay sará pajjáha kárán o mane Hodáwanday chammán tai kadr o ezzat sakk báz ent.’ ");
INSERT INTO bcc_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Nun agan tai chammán mani kadr o ezzat báz ent, gorhá wati ráhán pa man áshkár kan tánke man tará pajjáh byárán o hamá ezzat ke maná tai chammán hastent, áiá barjáh dásht bekanán. Bechár, é mahluk tai jenday kawm ent.” ");
INSERT INTO bcc_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Hodáwandá gwasht: “Man wat tai hamráha bán o tará árámi o ásudagia bakshán.” ");
INSERT INTO bcc_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mussáyá gón Hodáwandá gwasht: “Agan taw wata nayáay gón, márá cha edá ráh maday. ");
INSERT INTO bcc_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Agan taw may hamráh mabay, chón zánaga bit ke tai chammán maná kadr o ezzat hast, maná o tai mahluká? Chéá ke hamé chizz ent ke maná o tai mahluká cha donyáay á dega sajjahén kawmán jetá kant.” ");
INSERT INTO bcc_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Hodáwandá gón Mussáyá gwasht: “É kár ke taw gwasht, mania kanán, chéá ke mani chammán tai kadr o ezzat sakk báz ent o tará tai jenday námay sará pajjáha kárán.” ");
INSERT INTO bcc_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mussáyá gwasht: “Wati shán o shawkatá maná pésh dár.” ");
INSERT INTO bcc_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Hodáwandá gwasht: “Man wati sajjahén nékiá tará pésha dárán o tai démá wati nám Yahwehay járá janán. Harkasay sará ke maná rahmat gwárénagi ent, wati rahmatána gwárénán o harkasay sará ke maná rahm kanagi ent, rahma kanán. ");
INSERT INTO bcc_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Taw mani démá dista nakanay, chéá ke harkasá ke mani dém dist, zendaga namánit. ");
INSERT INTO bcc_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Bechár, mani nazzikká jágahé hast. Taw ódá taláréay sará bósht. ");
INSERT INTO bcc_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Hamá wahdá ke mani shán o shawkat cha tai démá gwazit, á wahdá tará taláray trakkéay tahá chéra dayán o wati dastá tán hamá wahdá tai sará éra kanán ke man begwazán. ");
INSERT INTO bcc_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Randá wati dastá dura kanán o taw mani poshtá genday, bale báyad ent mani dém gendag mabit.” ");
INSERT INTO bcc_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Hodáwandá gón Mussáyá gwasht: “Pésarigén wánekáni paymén do wánek betrásh o man áyáni sará hamá labzána nebisán ke pésarigénáni sará nebeshtah atant, hamá wánek ke taw próshtant. ");
INSERT INTO bcc_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Sabáhá watá gisshén. Sohbá Sináay kóhá sar kap o watá ódá kóhay thollá mani bárgáhá byár o sar kan. ");
INSERT INTO bcc_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Kass gón taw kóhá sar makapit o kóhay sará hecch jágah yakk mardomé ham gendag mabit. Ramag o górom ham kóhay démá macharant.” ");
INSERT INTO bcc_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mussáyá pésari wánekáni paymén do wánek trásht o hamá paymá ke Hodáwandá hokm dátagat, sabáhá máhallah Sináay kóhá sar kapt. Doén wánek áiay dastá atant. ");
INSERT INTO bcc_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Hodáwand jambaray tahá but o ér átk o Mussáay kerrá óshtát o wati námay jári jat ke man Yahweh án. ");
INSERT INTO bcc_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Hodáwand jár janáná Mussáay démá gwast: “Hodáwand án, Hodáwand, rahmán o mehrabánén Hodá man án. Gazabay áragá déra kanán o cha mehr o wapáyá porr án. ");
INSERT INTO bcc_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Gón hazárán naslá wati mehrá barjáha dárán o radkári o sarkasshi o gonáhána bakshán bale radkáriá bé sezáyá gwazaga naylán. Pet o mátáni radkáriáni sezáyá chokk o nomásagána dayán, tán sayomi o cháromi naslá.” ");
INSERT INTO bcc_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Mussáyá hamá damáná sar jahl kort o parastesh kanagá lagget. ");
INSERT INTO bcc_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Gwashti: “Oo Hodáwand! Agan tai chammán maná kadr o ezzaté hast, gorhá tawe Hodáwand may hamráh bay. Bell toré é náparmán o watsarén kawmé, bale taw may radkári o gonáhán bebaksh o márá wati mirás kan.” ");
INSERT INTO bcc_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Hodáwandá gwasht: “Bechár, nun man ahd o paymáné kanán. Man tai sajjahén mardománi démá anchén ajabbatén kára kanán ke angat sajjahén donyáyá hecch kawmá nadistag o tai sajjahén mardoma gendant ke mane Hodáwanday kár chón bákamál ent, hamé kár ke man pa taw kanáni. ");
INSERT INTO bcc_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Tará maróchi har hokmé ke dayán, hamá paymá bekan. Man Amuri o Kanháni o Hitti o Perizzi o Héwi o Yabusián cha tai démá dura kanán. ");
INSERT INTO bcc_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Habardár! É molká ke rawagá ay, gón é molkay mardomán hecch paymén ahd o paymán maband, chó mabit ke dáméá bekapay. ");
INSERT INTO bcc_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Áyáni korbánjáhán karój, pa botparastiá mekk kortagén sengánesh prósh o áyáni bánokén hodá Ashirahay botán goddh o gár kan. ");
INSERT INTO bcc_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Dega hecch hodáay parasteshá makan, chéá ke mane Hodáwand ke mani nám Hasud ent, hasaddigén Hodáé án. ");
INSERT INTO bcc_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Habardár! Gón á molkay mardomán hecch paymén ahd o paymán maband. Wahdé á wati botén hodáyán sojdaha kanant o pa áyán korbániga kanant, shomárá ham dáwata dayant o shomá áyáni korbánigána warét o ");
INSERT INTO bcc_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","wahdé shomá pa wati mardénchokkán áyáni janénchokkán gechéna kanét, á janénchokk wati botén hodáyán sojdaha kanant o shomay mardénchokkán ham wati hodáyáni sojdahá parmáyant. ");
INSERT INTO bcc_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Hecch botén hodá addh makan. ");
INSERT INTO bcc_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Béhomirén Naganay Aidá barjáh bedár. Hamá paymá ke man tará hokm dátag, tán hapt róchá béhomirén nagan bwar. É kárá Abibay máhá, hamá gisshéntagén wahdá bekan, chéá ke hamé máhá taw cha Mesrá dar átkay. ");
INSERT INTO bcc_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Har lápay awali chokk manig ent, tai sajjahén mál o dalwatáni awali narén chokk ham, gók bebant yá pas. ");
INSERT INTO bcc_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Haray awali korragay badalá gwarándhé bekosh o korragá bemók, bale agan namókayi, gorhá korragay gardená beprósh. Wati sajjahén awali mardénchokkán allam bemók. Kass mani démá gón hórkén dastán mayayt. ");
INSERT INTO bcc_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Shash róchá kár bekan, bale haptomi róchá árám kan. Nangár kanagay o rón o móshay mósomá ham hamé paymá bekan. ");
INSERT INTO bcc_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Haptagáni Aidá, bezán gandomay awali bar o samaray ronagay aidá barjáh bedár. Sálay godhsará Rón o Móshay Aidá ham barjáh bedár. ");
INSERT INTO bcc_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Tai sajjahén mardén, sálé say randá mane Hodáwandén Hodá, Esráilay Hodáay démá pésh bebant. ");
INSERT INTO bcc_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Man kawmán cha tai démá dura kanán o tai hadd o simsarán práh o sháhegána kanán. Taw ke sálé say randá wati Hodáwandén Hodáay cháragá káay, á wahdá kassa nayayt o tai molká nagipt. ");
INSERT INTO bcc_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Korbánigay hóná homiri chizzéay hamráhiá pésh makan. Sargwazay Aiday korbánigá tán sabáhá ér makan. ");
INSERT INTO bcc_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Wati zeminay awali bar o samará wati Hodáwandén Hodáay lógá byár. Shenekkay góshtá mátay shiray tahá lahrh maday.” ");
INSERT INTO bcc_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Nun Hodáwandá gón Mussáyá gwasht: “É habarán nebeshtah kan, chéá ke man hamé labz kár bastagant o gón taw o gón Esráilá ahd o paymáné kortag.” ");
INSERT INTO bcc_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mussá tán chell shap o chell róchá hamódá Hodáwanday kerrá at, na nánia wárt o na áp. Wánekáni sará ahd o paymánay labzi nebeshtah kortant, dahén parmáni nebeshtah kortant. ");
INSERT INTO bcc_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Wahdé Mussáyá sháhediay doén wánek dastá atant o cha Sináay kóhá ér kapt, sahig naat ke gón Hodáwandá habar kanagay sawabá mani dém drapshagá ent. ");
INSERT INTO bcc_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Wahdé Hárun o sajjahén Esráilián Mussá dist, cha áiay démay drapshnákiá áiay nazzikká rawagesh torset. ");
INSERT INTO bcc_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Bale Mussáyá á gwánk jatant. Hárun o kawmay sajjahén sarók Mussáay kerrá per tarretant o Mussáyá gón áyán habar kort. ");
INSERT INTO bcc_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Nun sajjahén Esráili Mussáay nazzikká átkant o áiá hamá sajjahén parmán Esráiliáná sar kortant ke Hodáwandá Sináay kóhá áiárá dátagatant. ");
INSERT INTO bcc_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Har wahdá ke Mussáyá gón áyán habar kanag halása kort, démi gón nekábéá póshet. ");
INSERT INTO bcc_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Har wahdá ke Mussá Hodáwanday bárgáhá shot ke gón áiá habar bekant, nekábi dura kort o tán dar áyagay wahdá wati démi gón nekábá napóshet. Wahdé dara átk o Hodáwanday parmáni gón mardomána gwashtant, ");
INSERT INTO bcc_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Esráiliána dist ke Mussáay dém drapshagá ent. Gorhá Mussáyá padá gón nekábá wati déma póshet, tán hamá wahdá ke padá tahá shot ke gón Hodáwandá habar bekant. ");
INSERT INTO bcc_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mussáyá Esráilay sajjahén mahluk mocch kort o gón áyán gwashti: “Esh ant hamá kár ke Hodáwandá shomárá esháni kanagay hokm dátag: ");
INSERT INTO bcc_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Shash róchá kár kanét, bale haptomi róch Shabbat ent, pa shomá pákén róché o árám kanagay róch ent. É róchá pa mane Hodáwandá wapk kanét. Harkasá Shabbatay róchá kár kort, áiay sezá mark ent. ");
INSERT INTO bcc_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Shabbatay róchá wati lóg o métagán ás rók makanét.” ");
INSERT INTO bcc_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mussáyá gón sajjahén Esráili mahluká gwasht: “É hamá hokm ent ke Hodáwandá dátag: ");
INSERT INTO bcc_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Cha wati mál o hastiá pa Hodáwandá shogránah pésh bekanét. Shogránah hamá kas bedant ke delia parmáit. Pa Hodáwandá é chizzán byárit: teláh o nograh o brenj, ");
INSERT INTO bcc_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ásmáni o jamu o sohrén pazhm, sharrén lilom, bozay mud, ");
INSERT INTO bcc_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","gwarándhay ratkagén sohrén póst, dega paymén mohrén póst, chegerday dár, ");
INSERT INTO bcc_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","pa cherágán thél, pa per moshagi rógen o washbóén sóchokiá masálah o ");
INSERT INTO bcc_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","pa épód o sénagpóshá senge solaymán o dega gránkimmatén seng. ");
INSERT INTO bcc_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Shomay sajjahén honarmand byáyant o é sajjahén chizzán addh bekanant ke Hodáwandá hokm dátag: ");
INSERT INTO bcc_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","sháhediay tambuá gón tóki tambu o pósh o karhi o mekk kanagi tahtag o gwarbast o menok o bonheshtán, ");
INSERT INTO bcc_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","pétiá gón gwarbásk o kapáratay sarpósh o pétiay démá lónjánén pardahá, ");
INSERT INTO bcc_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","thébalá gón gwarbásk o sajjahén sámán o pákwandhén naganán, ");
INSERT INTO bcc_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","pa rozhnáiá, cherágdáná gón cherág o thél o sajjahén sámánán, ");
INSERT INTO bcc_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","bósóchi korbánjáhá gón gwarbásk o per moshagi rógen o washbóén sóchokián, sháhediay tambuay dapay pardahá, ");
INSERT INTO bcc_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","sóchagi korbánigay korbánjáhá gón brenjén jáli o gwarbásk o sajjahén sámánán, brenjén trashtá gón pádagá, ");
INSERT INTO bcc_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","péshgáhay pardahán gón tahtag o bonheshtán, péshgáhay dapay pardahá, ");
INSERT INTO bcc_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","tambuay méh o péshgáhay méh o sádán, ");
INSERT INTO bcc_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","dini péshwá ke pákén jágahá rawant o hezmata kanant, pa áyán dazgwápén god, pa dini péshwá Háruná pákén god o pa áiay mardénchokkán god ke dini péshwái kanagay wahdá gwaráesh bekanant.” ");
INSERT INTO bcc_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Gorhá Esráiliáni sajjahén mahluk cha Mussáay kerrá dar átk o ");
INSERT INTO bcc_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","harkas ke delá parmát o arwáhá sekén dát, áiá pa sháhediay tambuay kárán, pa sajjahén hezmati kárán o pa pákén godán shogránaha áwort. ");
INSERT INTO bcc_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Janén o mardéna átkant. Harkas ke delá parmát, áiá thásin o nálok o mondrikk o hár, har tahrén saht o zéwara áwort. Har mardomá teláhay thékia áwort o pa Hodáwandá chest kanagi korbániga kortant. ");
INSERT INTO bcc_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Harkasay kerrá ke ásmáni o jamu o sohrén pazhm yá sharrén lilom, bozay mud, gwarándhay ratkagén sohrén póst yá dega mohkamén póst hastat, áworti. ");
INSERT INTO bcc_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Harkasá ke nograh o brenjay shogránahé dáta kort, pa Hodáwandá áworti o harkasay kerrá ke chegerday dár hastat, áworti ke pa tambuay yakk na yakk bahréá kár bedant. ");
INSERT INTO bcc_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Sajjahén honarmandén janénán jallakay kár dastá kort o é chizzesha gwapt o áwortant: ásmáni o jamu o sohrén pazhm o sharrén lilom. ");
INSERT INTO bcc_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Á sajjahén kárzántén janén ke delá parmátant, pasay mudesha zort o jallakay káresha kort. ");
INSERT INTO bcc_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Mahlukay sarókán pa épód o sénagpóshá senge solaymán o dega gránkimmatén senga áwort. ");
INSERT INTO bcc_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Pa cherágáni rók kanagá o pa per moshagi rógená o pa washbóén sóchokiáni addh kanagá masálah o thélesh ham áwort. ");
INSERT INTO bcc_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Esráilay har janén o mardéné ke delá parmát, áiá pa Hodáwandá hamá thékia áwort ke delá gwasht, pa é sarjamén kárá ke Hodáwandá Mussáay wasilahá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mussáyá gón Esráilián gwasht: “Bechárét, Hodáwandá cha Yahudáay kabilahá Uriay mardénchokk, Ahuray nomásag Besalél gechén kortag o ");
INSERT INTO bcc_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","cha Hodáay Ruhá porr kortag o agl o pahm o zánt o har kesmén dastay honar bakshátag. ");
INSERT INTO bcc_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Pa teláh o nograh o brenjay sámánáni sará nakshay sázagá, ");
INSERT INTO bcc_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","pa sengay tráshag o nádénagá o pa dáray ájenag o dega har paymén ezmkáriá honari bakshátag. ");
INSERT INTO bcc_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Hodáwandá Besalél o Dánay kabilahay Ohulyábe Ahisámak sekkárénagay láheki ham dátagant. ");
INSERT INTO bcc_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Hodáwandá esháná pa har paymén kárá honar bakshátag, pa hamá sajjahén kárán ke ájenókesha kanant o ezmkáresh ásmáni o jamu o sohrén pazhm o sharrén lilomay sará gwapant o dóchant, bezán har káré ke baladén ezmkára kanant.” ");
INSERT INTO bcc_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","“Besalél o Ohulyáb o sajjahén honarmand ke Hodáwandá pákén jágahay addh kanagay sajjahén káráni dánái o pahm bakshátagant, é kárá hamá paymá sarjam bekanant ke Hodáwandá hokm dátag.” ");
INSERT INTO bcc_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Besalél o Ohulyáb o sajjahén honarmand ke Hodáwandá dánái bakshátagatant, bezán harkas ke delá parmát ke byayt o kár bekant, Mussáyá á gwánk jat. ");
INSERT INTO bcc_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mussáyá hamá sajjahén shogránah esháni dastá dátant ke Esráilián pa pákén jágahay addh kanagay kárá áwortagatant. Mahluk angat pa wasshi o razá har sohb pa é kárá shogránah áragá at. ");
INSERT INTO bcc_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Gorhá é sajjahén honarmand ke pákén jágahay addh kanagá goláésh atant, eshán wati kár yalah dát o Mussáay kerrá átkant o ");
INSERT INTO bcc_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","gwashtesh: “Mahluk pa Hodáwanday hokm dátagén káray sarjam kanagá cha zaluratá gésh sámán áragá ent.” ");
INSERT INTO bcc_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Gorhá Mussáyá hokm dát o sajjahén ordgáhá jár janag but: “Pa pákén jágahay addh kanagá hech mardén yá janén cha ed o géshter shogránah mayárit.” É paymá mahluk cha géshterén sámánay áragá dárag but, ");
INSERT INTO bcc_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","chéá ke pa é sajjahén kárá áyáni áwortagén sámán cha zaluratá gésh atant. ");
INSERT INTO bcc_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","É honarmandán sháhediay tambuay dahén pardah addh kortant. É pardah cha hurtgwápén lilom o cha ásmáni o jamu o sohrén pazhmá gwapag butant. Honarmandén ezmkáréá é pardaháni sará karrubiay naksh jórh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Sajjahén pardah yakkén kadd o mápá atant. Hamok pardah drájiá bist o hasht dast o práhiá chár dast at. ");
INSERT INTO bcc_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Panch pardahesh zort o gón yakdegará lecchént o á dega panchénesh ham hamé paymá lecchéntant. ");
INSERT INTO bcc_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Awali reday goddhi pardahay lambá ásmánrangén lópesh per kort o domi reday goddhi pardahay lambá ham lópesh per kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Yakk pardahéá panjáh lópesh per kort o domi reday pardahay lambá ham panjáh lópesh per kort. Doénáni lóp dém pa dém atant. ");
INSERT INTO bcc_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Teláhay panjáh karhi‌esh addh kort o pardahesh gón yakdegará jórhéntant o tambuesh yakk kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Pa tambuay póshagá cha syahpasay mudá pardahesh addh kort. Yázdah pardahesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Yázdahén pardah yakkén kadd o mápayg atant. Hamok pardahay dráji si dast at o práhi chár dast. ");
INSERT INTO bcc_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Panch pardahesh yakk redéá gón yakdegará lecchént o á dega shashén dega redéá. ");
INSERT INTO bcc_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Awali reday goddhi pardahay lambá panjáh lópesh per kort o domi reday goddhi pardahay lambá ham panjáh lópesh per kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Brenjay panjáh karhi‌esh addh kort ke tambuá belecchénant o yakk bekanant. ");
INSERT INTO bcc_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Tambuay sarbori póshesh cha gwarándhay anchén póstéá addh kort ke rajag o sohr kanag butagat o eshiay sarborá dega paymén mohrén póstay póshé peresh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Pa tambuá cha chegerday dárá mekk kanagi tahtagesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Har tahtag drájiá dah dast at o práhiá yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Hamok tahtagá do zobánokesh per kort o é zobánokesh dap mán dap kortant. Tambuay sajjahén tahtagesh hamé paymá kortant. ");
INSERT INTO bcc_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Pa tambuay jonubi némagá bist tahtagesh addh kort o ");
INSERT INTO bcc_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","nograhay chell bonheshtesh addh kort ke tahtagáni chérá dayag bebant. Pa hamok tahtagá do bonheshtesh addh kort, pa hamok zobánokay chérá yakk bonheshté addhesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Pa tambuay á dega némagá, bezán tambuay shomáli némagá ham bist tahtagesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Pa tahtagáni chérá nograhay chell bonheshtesh addh kort, bezán do bonhesht pa har tahtagá. ");
INSERT INTO bcc_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Pa tambuay poshti bahrá, bezán rónendi némagá shash tahtagesh addh kort o ");
INSERT INTO bcc_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","pa poshti bahray kondhán do tahtagesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Doén kondhán, é tahtag cha jahlá gón yakdegará lecchetant o borzá dap mán dap kanag o yakkén karhiay tahá mán kanag butant. Doén kondhesh hamé paymá kortant. ");
INSERT INTO bcc_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Hasht tahtag butant o nograhay shánzdah bonhesht, pa hamok tahtagay chérá do bonhesht. ");
INSERT INTO bcc_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Cha chegerday dárá gwarbastesh addh kort. Panch gwarbast pa tambuay yakk némagéay tahtagán, ");
INSERT INTO bcc_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","panch gwarbast pa á dega némagay tahtagán o panch gwarbast pa rónendi némagay, bezán pa tambuay poshti bahray tahtagán. ");
INSERT INTO bcc_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Nyámi gwarbastesh addh kort ke é sar tán á dega sará, tahtagán sakk bebit, tahtagáni ném borziá. ");
INSERT INTO bcc_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tahtagesh gón teláhá sarpósh kortant o pa gwarbastáni dáragá teláhay karhi‌esh addh kort. Gwarbastesh ham gón teláhá sarpósh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Cha ásmáni o jamu o sohrén pazhmá o hurtgwápén lilomá pardahé addhesh kort o honarmandén ezmkáréá eshiay sará karrubiay naksh addh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Pa é pardahay dranjagá chár chegerdi menokesh addh kort o gón teláhá sarpóshesh kortant, teláhay karhi‌esh ham addh kort o pa menokán nograhay chár bonheshtesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Ásmáni o jamu o sohrén pazhm o hurtgwápén lilomesh zort o pa tambuay dapá ranggwápén pardahé addhesh kort. ");
INSERT INTO bcc_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Pa é pardahá panch menokesh gón karhián addh kort o menokáni sarok o bandesh gón teláhá sarpósh kortant o pa menokán brenjay panch bonheshtesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Besalélá cha chegerday dárá pétié addh kort ke drájiá do o ném dast at, práhiá yakk o ném dast o borziá ham yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Pétii cha dhanná o tahá gón zagrén teláhá sarpósh kort. Gerdágerd teláhay patthié peri kort. ");
INSERT INTO bcc_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Pa pétiá teláhay chár karhi‌i addh kort o pétiay chárén pádagáni lecchéntant, do karhi yakk némagéá o do á dega némagá. ");
INSERT INTO bcc_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Cha chegerday dárá do gwarbáski addh kort o gón teláhá sarpóshi kortant. ");
INSERT INTO bcc_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Pa pétiay chest kanagá gwarbáski cha pétiay kashay karhián gwázéntant. ");
INSERT INTO bcc_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Cha zagrén teláhá kapáraté addhi kort o pétii sarpósh kort. Drájiá do o ném dast at o práhiá yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Teláhay do karrubi‌i addh kort, teláhi zort o thappet o addhi kortant. É karrubi‌i sarpóshay doén sarán addh kortant, ");
INSERT INTO bcc_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","yakk karrubié sarpóshay yakk saréá addhi kort o á dega karrubi domi sará. Sarpósh o doén saráni karrubi‌i jetá jetá addh nakortant, é yakthokkor atant. ");
INSERT INTO bcc_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Karrubi sarpóshay sarborá atant. Démesh gón yakdomiá at o chammesh gón sarpóshá. Bánzolesh borzádiá pach atant o sarpóshesh sáhél kortagat. ");
INSERT INTO bcc_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Cha chegerday dárá thébalé addhi kort. Drájiá do dast at, práhiá yakk dast o borziá yakk o ném dast. ");
INSERT INTO bcc_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Gón zagrén teláhá sarpóshi kort o teláhay patthié addhi kort o chárén némagán peri kort. ");
INSERT INTO bcc_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Thébalay sarbori tahtagá, chárén némagán teláhay patthié peri kort o tahtagay chérá, chárén némagán yakk panjagéay práhiay kaddén kábé peri kort. ");
INSERT INTO bcc_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Pa thébalá teláhay chár karhi‌i addh kort o karhi‌i thébalay chárén kondhán, pádagán per kortant. ");
INSERT INTO bcc_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","É karhi paméshká kábay nazzikká atant ke thébalay chest kanagay wahdá gwarbáskán bedárant. ");
INSERT INTO bcc_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Thébalay chest kanagay gwarbáski cha chegerday dárá addh kort o gón teláhá sarpósh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Thébalay saray sámáni cha zagrén teláhá addh kortant, tál o tás o jag o hamá kásag ke pa réchagi korbánigay ér réchagá kár bandaga bant. ");
INSERT INTO bcc_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Cherágdáni cha zagrén teláhá addh kort. Cherágdán, cha boná beger tán sháharhán, eshiay jend o pyálah o golbon o polli thappet o addh kortant. Jetá jetá addhi nakortant, é yakthokkor atant. ");
INSERT INTO bcc_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Cha cherágdánay kashán shash sháharh dar átk, say sháharh cha cherágdánay yakk kashéá o say sháharh cha domi kashá. ");
INSERT INTO bcc_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Har sháharhá say pyálah per at, har pyálahá bádámay pollay warhén golbon o poll per at. Cherágdánay har shashén sháharh hamé paym atant. ");
INSERT INTO bcc_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Cherágdánay bonsháhá chár pyálah per at, gón bádámay pollay warhén golbon o pollán. ");
INSERT INTO bcc_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Yakk pyálahé awali doén sháharháni boná at, cha hamá jágahá kammé jahlter ke sháharh cha bonsháhá dar átkant, domi pyálah domi doén sháharháni boná o sayomi pyálah sayomi doén sháharháni boná at. Har shashén sháharháni chérá pyálah per at. ");
INSERT INTO bcc_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Golbon o sháharh o cherágdán yakthokkor atant. É sajjahéni cha yakkén thappetagén zagrén teláhá addh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Pa cherágdáná hapt cherági addh kort o cherágdánay sambálagay awzár o sámáni cha zagrén teláhá addh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Pa cherágdán o eshiay sajjahén sámánáni addh kanagá yakk tálánté zagrén teláhi kármarz kort. ");
INSERT INTO bcc_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Bósóchi korbánjáhi cha chegerday dárá addh kort. Chárkondh at. Drájiá yakk dast at, práhiá ham yakk dast o borziá do dast. Kánth o korbánjáhi hór addh kortant, yakthokkor atant. ");
INSERT INTO bcc_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Korbánjáhay sar o sajjahén némag o kánthi gón zagrén teláhá sarpósh kortant o chapp o chágerdá teláhay patthié peri kort. ");
INSERT INTO bcc_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Pa korbánjáhá teláhay do karhi‌i addh kort o hamé patthiay chérá peri kortant. Korbánjáhay doén kashán do do karhi‌i per kort ke chest kanagay wahdá gwarbáskán bedárant. ");
INSERT INTO bcc_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Gwarbáski cha chegerday dárá addh kortant o gón teláhá sarpósh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Per moshagi pákén rógen o asil o washbóén sóchokii addh kort, hamá paymá ke atrsáz washbó addha kanant. ");
INSERT INTO bcc_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Sóchagi korbánigáni korbánjáhi cha chegerday dárá addh kort. Drájiá panch dast at o práhiá ham panch dast. Korbánjáh chárkondh at. Borziá say dast at. ");
INSERT INTO bcc_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Korbánjáhay chárén kondháni sará yakk o yakk kánthé addhi kort. Kánth o korbánjáhi jetá jetá addh nakortant, é yakthokkor atant. Korbánjáhi gón brenjá sarpósh kort. ");
INSERT INTO bcc_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Korbánjáhay tagári o bard o tás o chársháh o ásdán, sajjahén sámáni cha brenjá addh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Pa korbánjáhá jálié, bezán brenjay thathé addhi kort o korbánjáhay lambáni patthiay chérá anchó éri kort ke korbánjáhay borziay némá sar but. ");
INSERT INTO bcc_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Pa brenjén jáliay chárén kondhán chár karhi‌i addh kort ke gwarbáskán bedárant. ");
INSERT INTO bcc_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Cha chegerday dárá gwarbáski addh kortant o gón brenjá sarpóshi kortant. ");
INSERT INTO bcc_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Gwarbáski cha karhián gwázéntant ke korbánjáhay chest kanagay wahdá korbánjáhay doén kashán bebant. Korbánjáhi cha dáray tahtagán addh kort o tóki hórk o hálig esht. ");
INSERT INTO bcc_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Brenjay trashti gón trashtay pádagá cha hamá janénáni ádénkán addh kort ke tambuay dapá hezmati kár kanagá atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Tambuay péshgáhi addh kort. Péshgáhay jonubi némagay hurtgwápén lilomay pardah drájiá yakk sad dast atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Gón bist menok o bist brenjén bonheshtá addhi kortant. Menokáni band o karhi nograhayg atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Shomáli némagay pardah ham drájiá yakk sad dast atant. Gón bist menok o bist brenjén bonheshtá addhi kortant. Menokáni band o karhi nograhayg atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Rónendi némagay pardah panjáh dast atant. Gón dah menok o dah bonheshtá addhi kortant. Menokáni band o karhi nograhayg atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Péshgáhay ródarátki némagay pardah, hamá némag ke róch dara kayt, panjáh dast atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Péshgáhay dapay yakk némagéay pardah pánzdah dast atant. Gón say menok o say bonheshtá addhi kortant. ");
INSERT INTO bcc_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Dapay á dega némagay pardah ham pánzdah dast atant. Gón say menok o say bonheshtá addhi kortant. ");
INSERT INTO bcc_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Péshgáhay chapp o chágerday sajjahén pardah hurtgwápén lilomayg atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Menokáni bonhesht brenjayg atant o band o karhi‌esh nograhayg atant. Menokáni sarok gón nograhá sarpósh atant. Péshgáhay sajjahén menokáni band nograhayg atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Péshgáhay dapay pardah ásmáni o jamu o sohrén pazhm o hurtgwápén lilomayg at o ranggwáp at. Pardahay dráji bist dast at o péshgáhay é dega pardaháni paymá, borzii panch dast at. ");
INSERT INTO bcc_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Pardahay chár menok o chár brenjén bonhesht atant. Menokáni band o karhi nograhayg atant o menokáni sarok gón nograhá sarpósh atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Tambuay o péshgáhay chapp o chágerday sajjahén méh brenjayg atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Tambuay, bezán sháhediay tambuay sámán hamesh atant ke Láwián Mussáay hokmay sará o dini péshwá Hárunay mardénchokk Itámáray sarókiá hesáb kort o nebeshtah kortant. ");
INSERT INTO bcc_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Harché ke Hodáwandá Mussá hokm dátagat, Besalélá addh kort. Besalél Yahudáay kabilahay mardomé at, Uriay chokk o Ahuray nomásag at. ");
INSERT INTO bcc_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Cha Dánay kabilahá Ahimásakay mardénchokk Ohulyáb é káray sarjam kanagá gón Besalélá gón at. Ohulyáb ájenók o baladén ezmkáré at o gón ásmáni o jamu o sohrén bandikk o hurtgwápén lilomá ranggwápiia kort. ");
INSERT INTO bcc_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Hamá chest kanagi korbánig, bezán hamá thékién teláh ke pa pákén jágahay addh kanagá kármarz butant, pákén jágahay shekelay hesábá, sarjamiá bist o noh tálánt o hapt sad o si shekel atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Mahlukay dátagén nograh ke hesáb kanag butant, pákén jágahay shekelay hesábá, yakk sad tálánt o hazár o hapt sad o haptád o panch shekel atant. É nograh cha hamá mardomán gerag butagatant ke mardomshomáriá hesáb kanag butagatant, ");
INSERT INTO bcc_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","bezán cha har mardomá yakk bekáé. Yakk bekáé ném shekel ent, pákén jágahay shekelay hesábá. É nograh cha hamá mardomán gerag butagatant ke mardomshomáriá hesáb kanag butagatant, bezán cha bist sálag o cha bist sálá masterén mardénán. É mardén sarjamiá shash lakk o say hazár o panch sad o panjáh atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","É yakk sad tálántén nograh pa pákén jágahay bonhesht o pardahay bonheshtáni addh kanagá kármarz butant, bezán sad tálánt pa sad bonheshtá, pa har bonheshtá yakk tálánté. ");
INSERT INTO bcc_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Hazár o hapt sad o haptád o panch shekeli pa menokáni karhi o menokáni sarokáni sarpósh o menokáni bandáni addh kanagá kármarz kort. ");
INSERT INTO bcc_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Hamá thékién brenj ke chest kanagi korbánig kanag butant, haptád tálánt o do hazár o chár sad shekel atant. ");
INSERT INTO bcc_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Sháhediay tambuay dapay bonhesht, brenjén korbánjáh o áiay brenjén jáli o korbánjáhay sajjahén sámán, ");
INSERT INTO bcc_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","péshgáhay chapp o chágerday bonhesht, péshgáhay dapay bonhesht, tambuay sajjahén méh o péshgáhay chapp o chágerday sajjahén méh cha hamé brenján addh kanag butant. ");
INSERT INTO bcc_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Cha ásmáni o jamu o sohrén pazhmá dazgwápén godesh addh kort ke wahdé péshwá pa hezmat kanagá pákén jágahá rawt, gwaráesh bekant. Hamá paymá ke Hodáwandá Mussá hokm dátagat, pa péshwáén Háruná pákén godesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Épódesh cha teláhá o cha ásmáni o jamu o sohrén pazhm o hurtgwápén lilomá addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Áyán teláhay názorkén ták thappet o tayár kort. Tákesh dráj drájá borretant o bandikkesh addh kort ke gón ásmáni o jamu o sohrén pazhm o hurtgwápén lilomá hawáresh bekanant. É kár honarmandén ezmkáréá kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Do sarkópagesh addh kort o épóday doén srugán peresh kort ke épód mohr bandag bebit. ");
INSERT INTO bcc_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Épóday band épóday paymá at, bezán cha teláhá o cha ásmáni o jamu o sohrén pazhm o hurtgwápén lilomá tayár kanag butagat. É band o épód hór gwapag butant, é yakthokkor atant, anchó ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Senge solaymánesh teláhay mohragjáhán nádéntant o anchó ke mohrá ájenanat o naksha kanant, Esráilay mardénchokkáni námesh áyáni sará naksh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Gorhá é seng ke Esráilay chokkáni yátgéjiay seng atant, épóday sarkópagán peresh kortant, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Sénagpóshé addhesh kort. Épóday paymá addhesh kort, bezán cha teláhá o cha ásmáni o jamu o sohrén pazhm o hurtgwápén lilomá addhesh kort. É kár honarmandén ezmkáréá kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","É chárkondh o dotal at. Dráji o práhiá yakk yakk bechillé at. ");
INSERT INTO bcc_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Eshiay sará chár redá gránkimmatén sengesh lecchént, awali redá rubi, pokráj o bayrel, ");
INSERT INTO bcc_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","domi redá pérózah, nilom o zomorrod, ");
INSERT INTO bcc_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","sayomi redá shunzén ákut, akik o jamuén ákut, ");
INSERT INTO bcc_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","cháromi redá teláhrangén ákut, senge solaymán o yashm. É sengesh teláhay mohragjáhán nádéntant. ");
INSERT INTO bcc_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Seng, Esráilay chokkáni námáni hesábá atant, dwázdah nám o dwázdah seng. Har yakkéay sará cha dwázdahén kabilahán yakkéay nám chó mohrá naksh at. ");
INSERT INTO bcc_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Pa sénagpóshá cha zagrén teláhá restagén sáday dhawlén zamzilokesh addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Teláhay do mohragjáh o teláhay do karhi‌esh addh kort o karhi‌esh sénagpóshay do srugá per kortant. ");
INSERT INTO bcc_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Teláhay doén zamzilokáni yakk yakk saré zortesh o sénagpóshay doén srugáni karhián mánesh kortant o ");
INSERT INTO bcc_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","zamzilokáni domi saresh zort o gón doén mohragjáhán lecchéntant, épóday sarkópagáni démi némagá. ");
INSERT INTO bcc_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Cha teláhá do karhi‌esh addh kort o sénagpóshay á dega doén srugán peresh kortant, hamá lambán ke démesh gón épódá at. ");
INSERT INTO bcc_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Cha teláhá dega do karhi‌esh addh kort o épóday démá, sarkópagáni jahli némagá, épóday banday sarborá peresh kortant, hamódá ke sarkópag gón épódá lecchetagant. ");
INSERT INTO bcc_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Sénagpóshay karhi‌esh gón ásmánrangén bandán épóday karhián anchó bastant ke épóday banday sará bebant o sénagpósh cha épódá masorit, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Épóday kabáhesh sarjamiá cha ásmánrangén godá gwapt o addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Kabáhá gotthé per at. Gotthay chapp o chágerdá mohrén káláray paymén dazgwápén lamb per at ke gotth maderit. ");
INSERT INTO bcc_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Ásmáni o jamu o sohrén pazhmay o hurtgwápén lilomay anáresh addh kort o kabáhay dámonay lambay chapp o chágerdá per kortant. ");
INSERT INTO bcc_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Zagrén teláhay zhángesh addh kort o kabáhay lambay chapp o chágerdá, anáráni nyámá peresh kortant. ");
INSERT INTO bcc_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Kabáhay dámonay chapp o chágerdá zhángé o anáré, zhángé o anáré per kanánesh kort, hamá paymá ke Hodáwandá Mussá hokm dátagat. Hezmatay wahdá Háruná é kabáh gwará kanagi at. ");
INSERT INTO bcc_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Pa Hárun o Hárunay mardénchokkán cha hurtgwápén lilomá jámagesh gwapt o addh kort. ");
INSERT INTO bcc_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Pág o koláh cha sharrén lilomá o chérpósh cha hurtgwápén lilomá addh kanag butant. ");
INSERT INTO bcc_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Cha hurtgwápén lilom o ásmáni o jamu o sohrén pazhmá ranggwápén lánkigé gwapt o addhesh kort, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Cha zagrén teláhá patthié, bezán pákén tájé addhesh kort o é labzesh chó mohray nakshá patthiay sará naksh kortant: “Wapke Hodáwandi.” ");
INSERT INTO bcc_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ásmánrangén bandé peresh kort ke patthi págay sará bóshtit, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Tambuay, bezán sháhediay tambuay sajjahén kár sarjam butant. Esráilián sajjahén kár kortant. Hamá paymá ke Hodáwandá Mussá hokm dátagat, hamá paymá kortesh. ");
INSERT INTO bcc_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Sháhediay tambuesh Mussáay kerrá áwort, tambu o sajjahén sámán, bezán karhi, tahtag, gwarbast, menok, bonhesht, ");
INSERT INTO bcc_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","cha gwarándhay ratkag o sohr butagén póstá jórh kortagén pósh, cha dega paymén mohrén póstá jórh kortagén pósh, sháhediay pétiay démá lónjánén pardah, ");
INSERT INTO bcc_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","sháhediay péti o gwarbásk o kapáratay pósh, ");
INSERT INTO bcc_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","thébal o sajjahén sámán o pákwandhén nagan, ");
INSERT INTO bcc_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","cha zagrén teláhá addh butagén cherágdán o cherágdánay cherág o sajjahén sámán o pa cherágán thél, ");
INSERT INTO bcc_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","teláhay korbánjáh, per moshagi rógen, washbóén sóchoki, tambuay dapay pardah, ");
INSERT INTO bcc_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","brenjén korbánjáh o áiay brenjén jáli o gwarbásk o sajjahén sámán, trasht o pádag, ");
INSERT INTO bcc_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","péshgáhay pardah o menok o bonhesht, péshgáhay dapay pardah o sád o méh, tambuay, bezán sháhediay tambuay káráni sajjahén sámán o ");
INSERT INTO bcc_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","dazgwápén god ke pákén jágahá hezmat kanagay wahdá gwará kanaga bant, bezán dini péshwá Hárunay pákén god o Hárunay chokkáni péshwái god, sajjahénesh áwortant. ");
INSERT INTO bcc_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Esráilián é sajjahén kár sarjam kortant, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Mussáyá sajjahén kár cháretant o disti ke áyán kár sarjam kortag. Hamá paymá ke Hodáwandá hokm dátagat, áyán hamá paymá kortagat. Nun Mussáyá á barkat dátant. ");
INSERT INTO bcc_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Hodáwandá gón Mussáyá gwasht: ");
INSERT INTO bcc_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Awali máhay awali róchá tambuá, bezán sháhediay tambuá mekk kan. ");
INSERT INTO bcc_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Sháhediay pétiá tambuay tahá ér kan o pardahá pétiay démá lónján kan ke péti chér o andém bebit. ");
INSERT INTO bcc_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Thébalá tóká bar o sámánán thébalay sará pa red o band ér kan. Cherágdáná tóká bar o cherágáni per kan. ");
INSERT INTO bcc_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Bósóchiay teláhén korbánjáhá sháhediay pétiay dém pa démá ér kan o tambuay dapay pardahá per kan. ");
INSERT INTO bcc_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Sóchagi korbánigáni korbánjáhá tambuay démá, bezán sháhediay tambuay démá ér kan o ");
INSERT INTO bcc_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","trashtá sháhediay tambu o korbánjáhay nyámá ér kan o ápi mán kan. ");
INSERT INTO bcc_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Tambuay chapp o chágerdá péshgáhay pardahán mekk kan o péshgáhay dapay pardahá per kan. ");
INSERT INTO bcc_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Per moshagi rógen bezur o tambu o tambuay tahay sajjahén sámánán per mosh o wapkesh kan ke pák bebant. ");
INSERT INTO bcc_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Sóchagi korbánigáni korbánjáhá o korbánjáhay sajjahén sámánán ham rógen per mosh o korbánjáhá wapk kan ke sakk pák bebit. ");
INSERT INTO bcc_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Trasht o trashtay pádagá ham rógen per mosh o wapkesh kan. ");
INSERT INTO bcc_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Hárun o Hárunay mardénchokkán sháhediay tambuay dapá byár o áyáni jáná beshód. ");
INSERT INTO bcc_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Pákén godán Hárunay gwará day, rógeni per mosh o wapki kan ke dini péshwá bebit o mani hezmatá bekant. ");
INSERT INTO bcc_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Hárunay chokkán byár o jámagánesh gwará day o ");
INSERT INTO bcc_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","anchó ke taw áyáni pet rógen per moshtag, áyáni jendá ham rógen per mosh ke dini péshwá bebant o mani hezmatá bekanant. Gón rógen per moshagá áyán dini péshwáia rasit o é péshwái abadmána bit, nasláni nasl.” ");
INSERT INTO bcc_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mussáyá sajjahén kár hamá paymá kortant ke Hodáwandá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Cha Mesrá dar áyagay domi sálay awali máhay awali róchá tambu mekk kanag but. ");
INSERT INTO bcc_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mussáyá tambu mekk kort, bonheshti ér kortant, tahtagi jatant, gwarbasti mán tarréntant o menoki mekk kortant. ");
INSERT INTO bcc_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Mussáyá pardah sháhediay tambuay sará dátant o sarpóshi pardaháni sará pach kortant, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Sháhediay doén wáneki zort o pétiá kortant, gwarbáski pétiá per kortant o kapáratay sarpóshi pétiay sará dát. ");
INSERT INTO bcc_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Pétii tambuay tóká bort o pardahi pétiay démá dratk o pétii chér o andém kort, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Thébali sháhediay tambuay tahá, tambuay shomáli némagá, cha pardahá dhann ér kort ");
INSERT INTO bcc_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","o nagani Hodáwanday bárgáhá thébalay sará ér kortant, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Cherágdáni sháhediay tambuay tahá, thébalay dém pa démá, tambuay jonubi némagá ér kort o ");
INSERT INTO bcc_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","hamódá Hodáwanday bárgáhá cherági cherágdáná per kortant, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Teláhay bósóchi korbánjáhi sháhediay tambuay tahá, pardahay démá ér kort o ");
INSERT INTO bcc_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","korbánjáhay sará washbóén sóchokii chér sótk, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Tambuay dapay pardahi per kort. ");
INSERT INTO bcc_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Sóchagi korbánigay korbánjáhi zort o sháhediay tambuay démá ér kort o áiay sará sóchagi korbánig o dánay korbánigi pésh kort, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Brenjén trashti sháhediay tambu o korbánjáhay nyámá ér kort o shódagi ápi mán kort. ");
INSERT INTO bcc_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mussá, Hárun o Hárunay chokkán hamé áp zortant o wati dast o pád shoshtant. ");
INSERT INTO bcc_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Har wahdá ke sháhediay tambuá yá korbánjáhay nazzikká shotant, watá shoshtesh, hamá paymá ke Hodáwandá Mussá hokm dátagat. ");
INSERT INTO bcc_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mussáyá tambu o korbánjáhay chapp o chágerdá péshgáhay pardah mekk kortant o péshgáhay dapay pardahi per kort. É paymá Mussáyá kár sarjam kort. ");
INSERT INTO bcc_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Jambará sháhediay tambu sarpósh kort o tambu cha Hodáwanday shán o shawkatá sarréch but. ");
INSERT INTO bcc_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mussáyá sháhediay tambuay tahá shot nakort ke tambu jambará geptagat o cha Hodáwanday shán o shawkatá sarréch at. ");
INSERT INTO bcc_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Wati sajjahén saparán, Esráili hamá wahdá rahádaga butant ke jambar cha tambuay sará chesta but, ");
INSERT INTO bcc_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","bale tánke jambar chesta nabut, á rahádaga nabutant. Tán jambaray chest bayagay róchá hamódá neshtant. ");
INSERT INTO bcc_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Sajjahén saparán, Esráiliána dist ke róchá Hodáwanday jambar tambuay sará ent o shapá jambaray tahá ásé rók ent.");
INSERT INTO bcc_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Bahtáwar hamá ent ke badkáráni shawr o saláhay sará narawt, gonahkáráni rahsará naóshtit o rishkand kanókáni diwáná nanendit, ");
INSERT INTO bcc_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","hamá ke wáhagi gón Hodáwanday tálimá ent o róch o shap áiay tálimay sará pekra kant. ");
INSERT INTO bcc_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Á hamá drachkay paymá ent ke rombókén jósaréay kerrá keshag butag o mósomay sará nibaga dant o táki nagimmorant, harché ham ke kant kámyába bit. ");
INSERT INTO bcc_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Bale badkár chosh naant, á hamá pog o paláráni paymá ant ke gwátesha rópit o bárt. ");
INSERT INTO bcc_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Gorhá bezán ke badkárán, pa dádrasiá óshtagay wák o twán nést o gonahkár pahrézkáráni diwáná hór buta nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Ke Hodáwand pahrézkáráni ráhay negahpán ent, bale badkáráni ráh tabáhi o bégwáhi ent. ");
INSERT INTO bcc_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","Á dega kawm pa ché shóresha kanant o ráj chiá mopt o náhudagén pandala sázant? ");
INSERT INTO bcc_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Jahánay bádsháh tayára bant o hákem yakjáh mocch, Hodáwand o áiay Masihay helápá óshtant: ");
INSERT INTO bcc_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","“Byáét tán áyáni sád o bandán beborrén o zamzilánesh besendén.” ");
INSERT INTO bcc_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Hodáwand ke ásmáná bádsháhia kant kandit o áyán maskará kant. ");
INSERT INTO bcc_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Á wahdá wati hezhmay tahá gón áyán habara kant, wati gazabay tahá áyána torsénit: ");
INSERT INTO bcc_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Man wati bádsháh, wati pák o gechénién kóh, Sahyunay sará nendáréntag.” ");
INSERT INTO bcc_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Nun Hodáwanday hokmá darshána kanán ke maná gwashti: “Taw mani Bacch ay, maróchi man tará pédá kortag. ");
INSERT INTO bcc_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","Cha man belóth tán kawmán tai mirás bekanán o zeminay chárén kondháni ráján tai sawgát. ");
INSERT INTO bcc_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Gón ásenén asáé áyán prósha dayay o kunzagáni paymá hurt hurtesha kanay.” ");
INSERT INTO bcc_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Paméshká, oo bádsháhán! Aglmand bebét. Anchosh oo jahánay hákemán! Adab bezurét. ");
INSERT INTO bcc_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","11","Pa tors, Hodáwanday hezmatá bekanét o pa drahag pádáni kapét. ");
INSERT INTO bcc_vpl VALUES ("PS2_12","020_2_12","PSA","2","12","12","Chokká bechokkét chó mabit ke zahr begipt o shomá ráhay némá gár o bégwáh bebét, chiá ke á anágat bránza gipt. Bahtáwar hamá ant ke áiay mayár o báhótha bant. ");
INSERT INTO bcc_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Dáuday Zabur, hamá wahdá ke cha wati chokk Abshálumá jehagá at. Oo Hodáwand! Mani dozhmen chenkadar báz ant. Bázéné mani helápá pád áyagá ent. ");
INSERT INTO bcc_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Bázéné mani bárawá gwashagá ent: “Hodá eshiá narakkénit.” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Bale taw oo Hodáwand! Wat mani chágerdá espar ay, Mani shán o shawkat ay, maná sarperáza kanay. ");
INSERT INTO bcc_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Hodáwandon gón borzén tawáré peryáta kort o áiá cha wati pák o gechénién kóhá maná passaw dát. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Man ásudag waptán o pád átkán, chiá ke Hodáwand mani posht o panáh at. ");
INSERT INTO bcc_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Cha lakkáni lakká natorsán ke cha har némagá maná angerresh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Oo Hodáwand! Pád á. Oo mani Hodá! Maná berakkén. Taw ay ke mani dozhmenáni démá shahmáta janay o badkáráni dap o dantánána próshay. ");
INSERT INTO bcc_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Rakkénók Hodáwand ent, tai barkat tai kawmá berasát! Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Pa sázger o washáwázáni sálárá. Gón zehi o simmi sázán. Dáuday Zabur. Oo mani dádrasén Hodá! Passaw beday wahdé peryáta kanán. Sakki o sóriáni wahdá mani dast o bánzolet pach kortant. Maná mehr o rahmat baksh o dwáyánon gósh dár. ");
INSERT INTO bcc_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Oo mardomán! Tán kadéná mani ezzat kamsharap kanaga bit? Tán chontá náhudagiá dósta dárét o drógay padá gardét? Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Bezánét ke Hodáwandá Hodádóst pa wat zortag o jetá kortagant. Wahdé Hodáwandá tawára kanán, á eshkont. ");
INSERT INTO bcc_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Hezhmay tahá gonáh makanét. Éshiay badalá, wapsagay wahdá, wati delá é bárawá pegr kanét o árám gerét. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Barhakkén korbánig peshkash kanét o Hodáwanday sará tawkal. ");
INSERT INTO bcc_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Bázéné gwashit: “Kay ent pa má néki bekant?” Oo Hodáwand! Wati démá pa má rozhnág kan. ");
INSERT INTO bcc_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Taw mani del cha shádániá sarréch kortag, cha áyáni hamá wahday shádániá géshter ke dán o gallah o tázagén sharábesh báz bebant. ");
INSERT INTO bcc_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Árámiá drája kasshán o wáb ham kapán, chiá ke tahná taw, oo Hodáwand, maná émeniay tahá nendénay. ");
INSERT INTO bcc_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","1","Pa sázger o washáwázáni sálárá. Gón nali sázán. Dáuday Zabur. Oo Hodáwand! Mani gappán gósh bedár, mani nálagán delgósh kan. ");
INSERT INTO bcc_vpl VALUES ("PS5_2","020_5_2","PSA","5","2","2","Oo mani bádsháhén Hodá! Mani peryátá beshkon, chiá ke tai gwará dwá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Oo Hodáwand! Bámgwáhán taw mani tawárá eshkonay, bámgwáhán, gón dazbandi wati wáhagán pésha kanán o wadáriga bán. ");
INSERT INTO bcc_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Taw choshén Hodáé naay ke cha badiá delwassh bebay, badi gón taw jalleta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Porkebr o gorunák tai démá óshtáta nakant o cha sajjahén badkárán naprata kanay. ");
INSERT INTO bcc_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Drógbandán bégwáha kanay, Hodáwand cha hónig o préb‌kárán naprata kant. ");
INSERT INTO bcc_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Bale man cha tai mehrá tai lógá káyán o cha tai torsá tai parasteshgáhá kóndhána kapán. ");
INSERT INTO bcc_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Oo Hodáwand! Pa mani dozhmenáni sawabá, gón wati adl o ensápá maná rahshóni beday o wati ráhá pa man sáp o tachk bekan. ");
INSERT INTO bcc_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Chiá ke rásti áyáni zobáná nést o del o darunesh tabáhi ent o bass. Gotth o galuesh práhén kabré o wati zobáná pa cháplusi kára bandant. ");
INSERT INTO bcc_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Oo Hodá! Eshán mayárbár hesáb kan, bell ke wati shawráni tahá beboddhant. Áyáni bázén náparmániáni sawabá, cha wat duresh kan, chiá ke tai helápá shóreshesh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","11","Bale á sajjahén ke tai báhóth o mayára bant, shádmáni bekanant, dáemá sáz o zémel bejanant. Áyán wati sáhegay chérá negahpáni bekan, tán harkas ke tai námay dóstdár ent gón tai námá shádán bebit. ");
INSERT INTO bcc_vpl VALUES ("PS5_12","020_5_12","PSA","5","12","12","Allamá, taw, oo Hodáwand, pahrézkárán barkata dayay o áyán gón wati mehr o rahmatá esparay paymá negahpána bay! ");
INSERT INTO bcc_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Pa sázger o washáwázáni sálárá. Gón zehi o simmi sázán. “Sheminitay” tarzay sará. Dáuday Zabur. Oo Hodáwand! Maná gón wati hezhmá hakkal maday o gón wati gazabá neherr. ");
INSERT INTO bcc_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Hodáwandá! Mani sará rahm kan chiá ke gimmortagán. Oo Hodáwand! Maná dráh bekan chiá ke jesm o jánon paréshán ent. ");
INSERT INTO bcc_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Arwáhon sakk békarár o jalájósh ent. Oo Hodáwand! Tán kadén? Tán kadén? ");
INSERT INTO bcc_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Hodáwandá! Wati démá gón man tarrén o mani sáhá berakkén, wati mehray sawabá maná neját beday. ");
INSERT INTO bcc_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Chiá ke mordag tará yát korta nakanant, kay ent ke cha mordagáni jaháná tai shográ begipt? ");
INSERT INTO bcc_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Cha nálagán dam bortagán, har shap gandalán cha gréwagá ménán o tahtá gón arsán tarra kanán. ");
INSERT INTO bcc_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Chammon cha bázén andóhán nezór butagant o cha bázén dozhmenán tahár. ");
INSERT INTO bcc_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Oo sajjahén badkárán! Cha man dur bét, chiá ke Hodáwandá mani gréwagáni tawár eshkotagant. ");
INSERT INTO bcc_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Hodáwandá mani peryát gósh dáshtagant, Hodáwand mani dwáyá mannit. ");
INSERT INTO bcc_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Mani sajjahén dozhmen sharmendag o sakk paréshána bant, á démá chahra dayant o pashal o sharmendaga bant. ");
INSERT INTO bcc_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Dáuday Shigáyun. Dáudá é Zabur Benyáminay kabilahay Kush námén mardoméay habaráni sawabá pa Hodáwandá darshán kortag. Oo Hodáwand, mani Hodá! Tai báhóth o mayára bán. Maná cha á sajjahénán ke mani randá kaptagant berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Agan na, á maná shéráni paymá derrant, chondh chondha kanant o maná rakkénóké nabit. ");
INSERT INTO bcc_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Oo Hodáwand, mani Hodá! Agan man choshén káré kortag o daston gonáhéá mén ent, ");
INSERT INTO bcc_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","agan pa dóstéá badion kortag, yá ke dozhmené bémayárá poletag, ");
INSERT INTO bcc_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","bell ke dozhmen mani padá byayt o áiay dast pa man berasit, mani zendá pádmál bekant o maná hákáni tahá bwápénit. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Oo Hodáwand! Gón wati hezhmá jáh bejan o mani dozhmenáni gazabay démá pád á! Ágáh bay, oo mani Hodá! Taw ay ke dádrasiay járet jatag! ");
INSERT INTO bcc_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Bell ke kawmáni romb tai gwará yakjáh bant, cha borzá esháni sará hákemi bekan! ");
INSERT INTO bcc_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Bell ke Hodáwand pa kawmán shawr o hokm beborrit. Oo Hodáwand! Gón mani rásti o tachkiá, wati dadrasiá mani pahrézkáriáni sará bekan. ");
INSERT INTO bcc_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Oo ádelén Hodá ke del o darunána zánay! Badkáráni sherrián halás kan o pahrézkárán pa del mohr bedár. ");
INSERT INTO bcc_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Mani espar Hodá ent ke nékdelána rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Hodá ádelén dadrasé, Hodáé ke har róch hezhma gipt. ");
INSERT INTO bcc_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","12","Agan ensán pashómán mabit, wati zahmá téza kant o wati kamáná kasshit o tayára kant. ");
INSERT INTO bcc_vpl VALUES ("PS7_13","020_7_13","PSA","7","13","13","Áiá koshókén seláh tayár kortag o wati tirán ácheshéna kant. ");
INSERT INTO bcc_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Á mardomá bechár ke cha sherr o shórá ápos ent o cha petnahá lápporr, á dróga zayt. ");
INSERT INTO bcc_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Kallé kóchit o johla kant o hamá chátá kapit ke wat kótkagi. ");
INSERT INTO bcc_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Áiay petnah wati sará kapit o pasáti ham sará laggit. ");
INSERT INTO bcc_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Hodáwandá pa áiay adl o ensápá shogra gerán, borzén arshay Hodáwanday námá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Pa sázger o washáwázáni sálárá. “Gittitay” tarzay sará. Dáuday Zabur. Oo Hodáwand, may Hodáwand! Chenkadar porshawkat ent tai nám jahánay chárén kondhán. Taw wati shán o mazani ásmánáni sarborá sheng o tálán kortag. ");
INSERT INTO bcc_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Pa wat satá o saná, chokk o shirmechén nonnokáni dapá ham dátag ke tai dozhmenáni sawabá tará satá bekanant, tánke dozhmen o bérgirán chopp o bétawár bekanay. ");
INSERT INTO bcc_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Wahdé tai ásmánáni némagá chárán ke tai lankokáni ezm o honar ant máh o estáráni némagá, ke taw barjáh dáshtagant, ");
INSERT INTO bcc_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","ensán chié ke taw áiay gamwár bebay o bani ádam kay ent ke áiay delgóshá bedáray? ");
INSERT INTO bcc_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Bale angat taw cha préshtagán bass kammoké kamter kort o mazani o ezzatay táj sará dát. ");
INSERT INTO bcc_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Wati dastay sajjahén káráni sará hákem kort o har chizz áiay pádáni chérá esht. ");
INSERT INTO bcc_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Sajjahén ramag o górrom gyábán o sahrái jánwar ");
INSERT INTO bcc_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","ásmánay báli morg o daryáay máhig o har ché ke cha zeray ráhá gwazit. ");
INSERT INTO bcc_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Oo Hodáwand, may Hodáwand! Chenkadar porshawkat ent tai nám jahánay chárén kondhán. ");
INSERT INTO bcc_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Pa sázger o washáwázáni sálárá. “Mawt-labbénay” tarzay sará. Dáuday zabur. Tará, oo Hodáwand, cha delay johlánkián shogra gerán, tai sajjahén ajabén kárán darshána kanán. ");
INSERT INTO bcc_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Tai gwará gal o shádmánia kanán. Oo borzén arshay Hodá! Tai námá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Wahdé mani dozhmen pada kenzant, cha tai démá lakoshant o tabáh o haláka bant. ");
INSERT INTO bcc_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Chiá ke taw mani hakk o ensáp pa sharri dáshtag, wati tahtá neshtagay o pa ensáp dádrasi kortag. ");
INSERT INTO bcc_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Kawmet hakkal dátagant, badkár tabáh o barbád kortagant o áyáni nám abad tán abad gár o bégwáh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Dozhmen, dáemi wayránagáni tahá gár o gomsár butagant, áyáni shahráni risshag o wandhálet cha boná kasshetagant, tantaná áyáni yát ham gár o zawál butag. ");
INSERT INTO bcc_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Bale Hodáwand tán abad bádsháhia kant, áiá wati shawr o dádrasiay taht páydár kortag. ");
INSERT INTO bcc_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Á wat jaháná gón adlá dádrasia kant, kawmáni sará gón ensápá shawra borrit. ");
INSERT INTO bcc_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Hodáwand pa zolm distagénán, borzén kaláté kaláté borzén, mán sakkén sáhatán. ");
INSERT INTO bcc_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Á ke tai námá zánant tai sará tawkala kanant chiá ke taw, oo Hodáwand, wati hodónákén lóthók yalah nakortagant. ");
INSERT INTO bcc_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Hodáwandá, ke tahti Sahyuná ent, benázénét, kawmáni nyámá áiay kortagén kárán jár janét. ");
INSERT INTO bcc_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Chiá ke á ke hónáni bérgir ent, eshán yáta kant zolm distagénáni peryátána nashamóshit. ");
INSERT INTO bcc_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Oo Hodáwand! Mani sará rahm kan, hamá ázárán ke cha dozhmenáni dastá maná rasant bechár, taw ke cha markay darwázagán maná sarperáza kanay, ");
INSERT INTO bcc_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","tánke tai sajjahén satá o tawsipán Sahyunay Jenekay darwázagáni démá barjáh dárán o shádmáni bekanán ke taw maná rakkéntag. ");
INSERT INTO bcc_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Kawm, wati hamá kótkagén kallá kaptagant, áyáni pád hamá dámá band geptag o passetagant ke watesh chér kortagat. ");
INSERT INTO bcc_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Hodáwandá watá gón wati adl o ensápá pajjáréntag, badkár cha wati kortagén kárán wat dámá kapant. Zegr... Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Badkár mordagáni jaháná pera tarrant, á sajjahén kawm ke Hodáyá shamóshant. ");
INSERT INTO bcc_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Bale hájatmand harwahd shamóshaga nabant o zolm distagénáni omét tán abad barbáda nabit. ");
INSERT INTO bcc_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Oo Hodáwand! Pád á o mayl ke ensán báládast bebit, bell ke tai dargáhá kawmáni shawr o hokm borrag bebit. ");
INSERT INTO bcc_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Oo Hodáwand! Torsesh jesm o jáná perrén tán kawm bezánant ke ensán ant o bass. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Oo Hodáwand! Pa ché dur óshtátagay? Chiá watá sakkén sáhatán chéra dayay? ");
INSERT INTO bcc_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Badkár gón kebr nezórénán shekára kant, bell ke wati pandaláni dámá gereptár bebit. ");
INSERT INTO bcc_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Chiá ke badkárá wati delay wáhagáni sará pahr ent, lálech kanókán barkata dant o Hodáwandá bad o rada gwashit. ");
INSERT INTO bcc_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Badkár mán wati kebr o gorunákiá gwashit: “Hodá dar gétka nakant”, áiay sajjahén pegr o hayál esh ent ke “Hodáé nést”. ");
INSERT INTO bcc_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Wati ráhá modám kámyáb o sóbén ent, tai shawr o dádrasi cha áiay chammá dur ant, wati sajjahén dozhmenán rishkanda kant. ");
INSERT INTO bcc_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Wati delá gwashit: “Hechbar cha wati jáhá sorénag o jombénaga nabán nasláni nasl cha kazá o baláhán dura bán.” ");
INSERT INTO bcc_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Dap o zobáni cha nálat o préb o setamá porr ent, áiay zobánay chérá petnah o sherkáriá kodám bastag. ");
INSERT INTO bcc_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Métag o ábádiáni kaminá nendit, chér o panáhén jáhán bégonáhána koshit, chérokái béwasáni shekár kanagay shóházá ent. ");
INSERT INTO bcc_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Shéray paymá wati kaminá wadára kant, wadára kant o nezór o nátwánán wati panjagá kárit, panjagá kárit o dámá dawra dant. ");
INSERT INTO bcc_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Áiay shekár, lagatmál o zár o wára bant, áiay dastá gár o gomsára bant. ");
INSERT INTO bcc_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Wati delá gwashit: “Hodáyá shamoshtag démi póshéntag o hechbara nagendit.” ");
INSERT INTO bcc_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Oo Hodáwand! Pád á. Oo Hodá! Wati dastá shahár. Bazzagénán mashamósh. ");
INSERT INTO bcc_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Badkár pa ché Hodáyá bad o rada gwashit? Chiá wati delá gwashit: “Hodá dar gétka nakant”? ");
INSERT INTO bcc_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Bale albat taw genday. Sakki o sóriána genday, tán kár o ehtiárá wati dastá bedáray. Bazzag o béchárag watá tai sepordaga kanant, chórawáni madat kanók taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Sherr o badkáráni báská beprósh, áyáni sharáratay hesábá beger, hamá káráni hesábá ham ke áiá gwashtag: “Hodá dar gétka nakant”. ");
INSERT INTO bcc_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Hodáwand abad tán abad bádsháh ent, kawm cha áiay sardhagárá gár o gomsára bant. ");
INSERT INTO bcc_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Oo Hodáwand! Taw bazzagáni wáhagán gósha dáray, áyán delbaddhia dayay o habaránesh eshkonay. ");
INSERT INTO bcc_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Chóraw o setam distagénáni dadrasiá kanay tánke é hákién ensán dega baré tors o dehshat maperrénit. ");
INSERT INTO bcc_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Man Hodáwanday mayár o báhóth án, gorhá shomá maná che paymá gwashét: “Morgé bebay o wati kóhá bál kan. ");
INSERT INTO bcc_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Chiá ke haw, badkár kamáná kasshant o tiresh zehá dátag, ke mán tahárókiá nékdelán bejanant. ");
INSERT INTO bcc_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Agan bonred tabáh kanag bebant, gorhá pahrézkár ché korta kant?” ");
INSERT INTO bcc_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Hodáwand wati pákén parasteshgáhá ent, Hodáwanday taht ásmáná ent. Chammi gendagá ant, didagi ensánay chokkána ázmáit. ");
INSERT INTO bcc_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Hodáwand pahrézkár o badkárána chakkásit, áiay ruh cha hamáyán naprata kant ke sherr o sheddatesh dósta bit. ");
INSERT INTO bcc_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Badkáráni sará angar o gókorta gwárénit, áyáni jám o pyálahay bahr, sóchák o lewárén gwát ent. ");
INSERT INTO bcc_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Hodáwand ádel ent, áiá adl o ensáp dósta bit, nékdel áiay démá gendant. ");
INSERT INTO bcc_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Pa sázger o washáwázáni sálárá. “Sheminitay” tarzay sará. Dáuday Zabur. Oo Hodáwand! Berakkén, chiá ke hech Hodádósté pasht nakaptag o wapádár cha mardománi nyámá gár o bégwáh butagant. ");
INSERT INTO bcc_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Harkas gón hamsáhegá dróga bandit, cháplusén dapesh pa préb habara kanant. ");
INSERT INTO bcc_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Hodáwand har cháplusén dapá próshát o har bathák janókén zobáná borrát. ");
INSERT INTO bcc_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Gwashant: “Má gón wati zobáná kámyáb o sóbéna bén, may dap o lonth ham gón má ant, may wájah o master kay ent?” ");
INSERT INTO bcc_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Hodáwanda gwashit: “Cha nezórén mardománi lagatmáli o hájatmandáni nálagáni sawabá nun jáha janán. Man eshán hamá paymá émenia bakshán ke esháni armán ent.” ");
INSERT INTO bcc_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Hodáwanday habar asil o béayb ant, nograhay paymá ke cha kurahá dar átkag o hapt randá pák o sallah kanag butag. ");
INSERT INTO bcc_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Oo Hodáwand! Taw eshán negahpánia kanay, taw é dábén mardománi nyámá esháni posht o panáha bay. ");
INSERT INTO bcc_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Badkár har némagá tarr o tába kanant, á wahdi ke mardom palitiá ezzata dayant. ");
INSERT INTO bcc_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodáwand! Tán kadén? Bárén maná tán abada shamóshay? Tán kadén wati démá cha man panáha kanay o póshénay? ");
INSERT INTO bcc_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Tán kadén mani pegr o andéshag maná ázár bedayant, har róch delon gamig? Tán kadén dozhmen mani sará báládast bebit? ");
INSERT INTO bcc_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Oo Hodáwand! Mani Hodá! Mani cháragá bekan o passaw day! Chammánon rozhná kan, agan na, markay wábá wapsán. ");
INSERT INTO bcc_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Chó mabit dozhmen begwashit: “Man áiay sará sóbén butagán”, badwáh shádán bebit ke mana larzán. ");
INSERT INTO bcc_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Bale tai mehray sará tawkala kanán, delon gal o bála bit ke taw maná rakkéntag. ");
INSERT INTO bcc_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Hodáwandá názénán, ke modám mani sará mehrabán butag. ");
INSERT INTO bcc_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Nádán wati delá gwashit: “Hodáé nést.” É palit ant o káresh sell o gandah, nékkáré nést. ");
INSERT INTO bcc_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Hodáwand cha ásmáná bani ádamá chárit tán begendit bárén dánáé hast ke Hodáay shóházá ent. ");
INSERT INTO bcc_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Sajjahénán wati ráh gár dátag, hórigá palit butagant, nékkáré nést, yakké ham nést. ");
INSERT INTO bcc_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Badkár hechbar sarpada nabant? É mani kawmá anchosha warant ke mardom nagana warant o Hodáwandá hech tawára nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Bale ódá wati torsay tahá boddhant, chiá ke Hodá gón pahrézkáráni nasl o padréchá ent. ");
INSERT INTO bcc_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Shomá setam distagénáni shawrbandián rishkanda kanét, bale Hodá esháni panáhgáh ent. ");
INSERT INTO bcc_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Kasé cha Sahyuná byáyát o Esráilá berakkénát. Wahdé Hodáwand washbahtiá pa wati kawmá pera tarrénit, Ákub gal o bála bit o Esráil shádehia kant. ");
INSERT INTO bcc_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Dáuday Zabur. Oo Hodáwand! Kay tai tambuá mehmán bebit? Kay tai pákén kóhá jahmenend bebit? ");
INSERT INTO bcc_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Hamá ke béayb gám bejant, adl o ensápá barjáh dárit o pa delsetki rásténá begwashit, ");
INSERT INTO bcc_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","hamá ke gón wati zobáná kaséay báposhtá habaré magwashit, pa hamsáhegá badi makant o hamráhán ér majant, ");
INSERT INTO bcc_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","hamá ke badkár áiay chammán hakir o béarzesh bebant, Hodátorsán ezzat o hormat bedant o wati labzay sará wapá bekant, toré zalar o zyán begendit, ");
INSERT INTO bcc_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","hamá ke wati zarrá pa sutt madant o bégonáhéay helápá reshwat magipt, á ke eshán barjáha dárit hechbara nalarzit. ");
INSERT INTO bcc_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Dáuday shayr. Oo Hodá! Maná pa sharri bedár, ke tai mayár o báhóth butagán. ");
INSERT INTO bcc_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Gón Hodáwandá gwashton: “Taw ay mani Hodáwand, abéd cha taw pa man hech sharrié nést.” ");
INSERT INTO bcc_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Á pák o palgártagén ke zeminá ant, hamá sharapmand ant ke mani sajjahén shádmáni hamáyáni sawabá ent. ");
INSERT INTO bcc_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Á ke dega hodáéay randá tachant, áyáni gam o andóh sakk báza bit, áyáni hónén korbánigáni rasmán góna nabán o námánesh wati zobáná nayárán. ");
INSERT INTO bcc_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Oo Hodáwand! Taw mani gisshetagén bahrwandh o jám ay, taw mani bahrá sharriay sará dáray. ");
INSERT INTO bcc_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Mani hadd o simsar, deltabén jágahán gisshénag butagant, maná delkasshén mirásé dastá kaptag. ");
INSERT INTO bcc_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Man Hodáwandá názénán ke maná shawr o saláha dant, delon shappásán ham maná ráh sója dant. ");
INSERT INTO bcc_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Man modám Hodáwand wati dém pa démá distag, á mani rástén pahnátá ent, cha hamé sawabá mana nalarzán. ");
INSERT INTO bcc_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Paméshká, delon wassh o zobán shádán ent. Jesm o jánon mán ométay kalátá áráma gipt. ");
INSERT INTO bcc_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Chiá ke taw maná mordagáni jaháná yalaha nakanay o wati dóstdárá sarhag o pussagá naylay. ");
INSERT INTO bcc_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Taw maná zenday ráhá sója dayay o wati bárgáhá maná cha shádmániá sarrécha kanay. Tai rástén kashá, wasshi abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Dáuday dwá. Oo Hodáwand! Mani barhakkén peryátán beshkon o nálagánon gósh dár, dwáyánon beshkon, ke cha béryáén dap o lonthán dara káyant. ");
INSERT INTO bcc_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Cha tai bárgáhá maná dádrasi o ázáti sar bát, chammet rásténá begendátant. ");
INSERT INTO bcc_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","3","Taw mani del ázmáesh kortag o shappásán mani cháragá átkagay, maná chakkásetaget o hech dar nagétkag, ahdon kortag ke dap gonáh makant. ");
INSERT INTO bcc_vpl VALUES ("PS17_4","020_17_4","PSA","17","4","4","Mardománi kár har ché ke bit, bale man cha tai lontháni gálá watá cha zálemáni ráhá dur dáshtag. ");
INSERT INTO bcc_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Mani pádáni pad tai ráhá naksh ant, pádon nalarzetagant. ");
INSERT INTO bcc_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Oo Hodá! Tará lóthán, chiá ke taw maná passawa dayay, gósh dár o habaránon beshkon. ");
INSERT INTO bcc_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Wati mehray ajabbatiá pésh bedár! Taw hamáyána rakkénay ke cha wati dozhmenán tai gwará mayár o báhótha bant. ");
INSERT INTO bcc_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","8","Maná chó wati chammá besambál o wati bánzoláni sáhegá chér beday, ");
INSERT INTO bcc_vpl VALUES ("PS17_9","020_17_9","PSA","17","9","9","cha á badkárán ke maná gár o gomsára kanant o cha hamá jawrén dozhmenán ke maná angerresh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Á wati sengén delán mohra kanant o áyáni zobán porkebr o gorunákén habara kant. ");
INSERT INTO bcc_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Mani padesh geptagant o hamé annun maná angerresh kortag, chammesh pa man dótkag tán zeminá dawron bedayant. ");
INSERT INTO bcc_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Á shéréay paymá ant ke pa shekárá shodig ent, warnáén shéréay paymá ke kaminá neshtag, ");
INSERT INTO bcc_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Oo Hodáwand! Jáh jan, esháni démá dar á o zeminá bejanesh, gón wati zahmá maná cha badkárán berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Hodáwandá! Maná cha é paymén mardománi dastá ázát kan, cha é donyáay mardomán ke nasibesh tahná hamé donyá ent o bass, ke lápánesh cha wati hazánagá séra kanay, chokkesh báza bant o áyáni pasht kaptagén chizz pa chokkánesha rasit. ");
INSERT INTO bcc_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Bale man pa pahrézkári tai démá gendán, ágáh ke bán, cha tai gendagá séra bán. ");
INSERT INTO bcc_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Pa sázger o washáwázáni sálárá. Hodáwanday hezmatkár Dáuday Zabur. Dáudá é Zabur hamá wahdá pa Hodáwandá per bast ke Hodáwandá cha sajjahén dozhmenán o cha Sháulay dastá rakként. Dáudá chosh gwasht: Oo Hodáwand, oo mani zór o wák! Tará báz dósta dárán. ");
INSERT INTO bcc_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Hodáwand mani talár ent, mani kalát o mani rakkénók ent, mani Hodá mani talár ent o hamáiay poshtá báhóth o mayára bán. Á mani espar ent, mani zórákén rakkénók o mani sangar. ");
INSERT INTO bcc_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Hodáwandá ke satá o sanáay láhek ent tawára kanán o cha wati dozhmenána rakkán. ");
INSERT INTO bcc_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Markay sád o bandán maná patátagat o tabáhi o zawáliay hár o hirrópán maná torséntagat. ");
INSERT INTO bcc_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Mordagáni jahánay sád o bandán patátagatán o gón markay dámá, dém pa dém atán. ");
INSERT INTO bcc_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Wati paréshániáni tahá Hodáwandon tawár jat o komak lóthagay peryáton wati Hodáay gwará borz kort. Áiá cha wati parasteshgáhá mani tawár eshkot o mani komak lóthagay peryát áiay góshán raset. ");
INSERT INTO bcc_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Nun zemin chandhet o jomb o jóshá lagget, kóháni béh o bonyát ham larzetant, chiá ke á hezhm geptagat. ");
INSERT INTO bcc_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Cha áiay pónzá dutt dar átk o sóznákén ásé cha dapá, taptagén angar zobánok janagá atant. ");
INSERT INTO bcc_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Ásmáni ér áwort o jahl átk, syáhén jambar áiay pádáni chérá at. ");
INSERT INTO bcc_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Karrubiéay bánzoláni sará neshtagat o gwátay bánzoláni sará bál at. ");
INSERT INTO bcc_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Taháróki wati pósháki kort o jambaráni gobár o syáhén hawri wati chágerday kápár kortant. ");
INSERT INTO bcc_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Rozhn o drapshnáki cha áiá démá at o jambar chest bayagá atant, taptagén seng o ácheshén angar dara kaptant. ");
INSERT INTO bcc_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Hodáwandá cha ásmáná grandet o borzén arshay Hodáyá cha taptagén seng o ácheshén angarán wati tawár sar dát. ");
INSERT INTO bcc_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Áiá wati tir shántant o dozhmen sheng o sháng kortant, gróki dawr dát o sargardáni kortant. ");
INSERT INTO bcc_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Daryáay ápráh gendag butant o donyáay bonyát paddar, cha tai neherr o hakkalán cha tai pónzay trondén gwátá, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Áiá cha borzádá dast shahárt o maná gepti, cha zyádahén ápá maná dar áworti o ");
INSERT INTO bcc_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","cha zóráwarén dozhmená rakként, cha áyán ke napratesh mani sará próshtagat, chiá ke cha man zórákter atant. ");
INSERT INTO bcc_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Sakki o sóriáni róchá, mani démá dar átkant, bale Hodáwand mani posht o panáh at. ");
INSERT INTO bcc_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Áiá maná práh o émenén jágahé áwort o maná rakkénti, chiá ke cha man báz wassh o razá at. ");
INSERT INTO bcc_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","20","Hodáwandá pa mani pahrézkáriá gón man néki kortag, mani dastáni pákiay mozz bakshátag, ");
INSERT INTO bcc_vpl VALUES ("PS18_21","020_18_21","PSA","18","21","21","chiá ke man Hodáwanday ráh yalah nadátag o cha Hodáyá dém pa badiá nashotagán. ");
INSERT INTO bcc_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Áiay parmán modám mani chammáni démá butagant o áiay hokm cha wat dur nadáshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Áiay démá tamán o béayb butagán o watá cha gonáhá dur dáshtag. ");
INSERT INTO bcc_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Hodáwandá mani pahrézkáriáni mozz dátag, áiá mani dastáni páki distag. ");
INSERT INTO bcc_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Taw gón wapádárán wapádár ay o gón tachkénán tachk. ");
INSERT INTO bcc_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Gón pákénán pák ay o gón repkkárán chálák. ");
INSERT INTO bcc_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Chiá ke taw békebrána rakkénay, bale porkebr o gorunákán chamjahla kanay. ");
INSERT INTO bcc_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Oo Hodáwandén Hodá! Taw ay ke mani cherágá rozhnága kanay. Hamá ent ke mani tahárókián róshena kant. ");
INSERT INTO bcc_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Gón tai madatá lashkaréay sará orosh o hamlaha barán o gón Hodáay komaká ent ke cha borzén diwálán koppa kanán. ");
INSERT INTO bcc_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Haw! Hodá, áiay ráh tamán o kámelén ráhé, Hodáay habar béayb ant, pa harkasá ke áiay gwará panáha zurit, esparé. ");
INSERT INTO bcc_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","Hodáwandá abéd, kay Hodá ent o Hodáyá abéd, kay talár? ");
INSERT INTO bcc_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","É Hodá ent ke maná zór o wáka dant o mani ráhá tamán o béayba kant. ");
INSERT INTO bcc_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Mani pádán áskáni paymá téza kant o maná borziáni óshtagá láhekia dant. ");
INSERT INTO bcc_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Mani dastán pa jangá ázmudaga kant, tán báskon brenjén kamáná beloppénit o chóth bekant. ");
INSERT INTO bcc_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Taw wati sóbén bayagay espará maná bakshay o rástén dastet mani posht o panáh ent, tai narmdeli o békebri maná mazania dant. ");
INSERT INTO bcc_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Taw mani pádáni chéray ráhá práha kanay tánke pádon malarzant. ");
INSERT INTO bcc_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Dozhmenáni randá kapán o mani dast pa áyána rasit, tán halák mabant, pera natarrán. ");
INSERT INTO bcc_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Anchosh zeminá janán ke pád áyagay móh o wákesh mabit, mani pádáni chérá kapant. ");
INSERT INTO bcc_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Taw pa jangá maná zór o wáka bakshay o dozhmenán mani pádáni chérá dawra dayay. ");
INSERT INTO bcc_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Mani pádán dozhmenáni gardenay sará éra kanay o man wati dozhmenán gár o gomsára kanán. ");
INSERT INTO bcc_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Pa komaká peryáta kanant bale rakkénóké nést, cha Hodáwandá komaka lóthant, bale passawa nadant. ");
INSERT INTO bcc_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Man áyán háka kanán o gwátá dayán, damk o kuchaháni gelay paymá chandhán. ");
INSERT INTO bcc_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Taw maná cha mardománi jang o chópána rakkénay o kawmáni sardára kanay, hamá mardom mani hezmatá kanant ke manesh pajjáha nayárán. ");
INSERT INTO bcc_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Tán mani tawárá eshkonant, parmána barant, darámad mani démá wati sará jahla kanant. ");
INSERT INTO bcc_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Á deltrakka bant, larzán o drahán cha wati kalátána tachant. ");
INSERT INTO bcc_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Hodáwand zendag ent. Pa mani talárén Hodáyá názénk. Mani rakkénókén Hodáyá shán o shawkat bát. ");
INSERT INTO bcc_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Hodá ent ke mani bérá gipt, kawm o ráján mani chérdastiá nádénit o ");
INSERT INTO bcc_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","maná cha dozhmenána rakkénit. Haw! Taw mani dozhmenáni démá maná sarperáza kanay o cha zálemén mardomána chotthénay. ");
INSERT INTO bcc_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Oo Hodáwand! Paméshká tará kawmáni nyámá satá kanán o tai námá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Á wati bádsháhá mazanén sób o pérózia bakshit o wati rógen per moshtagéná mehra kant, bezán Dáud o áiay nasl o padréchá tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Ásmán Hodáwanday shán o mazaniá paddara kant, borzén arsh áiay dastay kárán. ");
INSERT INTO bcc_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","É róch pa á róchá habar rawána kant o é shap pa á shapá zánt o hekmat darshána kant, ");
INSERT INTO bcc_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","3","na habaré o na gálé, áyáni tawár eshkonaga nabit. ");
INSERT INTO bcc_vpl VALUES ("PS19_4","020_19_4","PSA","19","4","4","Padá ham áwázesh sarjamén zeminá sheng o tálána bit o habaresh tán jahánay goddhi marz o simsarána rasant. Pa róchá, Hodáyá ásmáná tambué bastag, ");
INSERT INTO bcc_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","róch sálónkéay paymá cha wati kellahbandá dara kayt o chó ke pahlawáné shádán maydána kant. ");
INSERT INTO bcc_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Cha ásmánay yak gwaréá dara kayt o tán á dega gwará chahra wárt, hech chizzé cha áiay horm o garmiá chér naent. ");
INSERT INTO bcc_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Hodáwanday Sharyat tamán o béayb ent o jesm o jáná bóda kárit. Hodáwanday hokm porehtebár ant o kamzántán dáná o aglmand kant. ");
INSERT INTO bcc_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Hodáwanday rahband rást ant o delá shádána kanant. Hodáwanday parmán pák ant o chammán rozhnága kanant. ");
INSERT INTO bcc_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Hodáwanday tors pák ent o tán abad páydár. Hodáwanday parmán barhakk ant o sarjamiá adl, ");
INSERT INTO bcc_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","cha teláhá delkashter, tantaná cha asilén zarr ham, cha shahdá shirkenter, tantaná cha bénagay kodámay har trampá washter. ");
INSERT INTO bcc_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Tai hezmatkárá cha áyán dháh o hoshdár rasit o gón áyáni dáragá mazanén mozzé. ");
INSERT INTO bcc_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Kay ent á ke wati radián bezánt o sarpad bebit? Maná cha wati nazántagén gonáhán pák o sallah kan. ");
INSERT INTO bcc_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Wati hezmatkárá cha gorunák o porkebrén kár o kerdán bedár, mayl ke mani sará báládast bebant. Hamá wahdá tamán o béayba bán o cha har mazanén gonáhá pák. ");
INSERT INTO bcc_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Oo Hodáwand! Mani dapay habar o delay pegr o hayál tai delá benendátant, taw ke mani talár o posht o panáh ay. ");
INSERT INTO bcc_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Hodáwand tará sakki o sóriáni róchá passaw bedayát, Ákubay Hodáay nám tará negahpán bát. ");
INSERT INTO bcc_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Cha wati pákén jágahá pa taw komak berasénát o cha Sahyuná tará madat kanát. ");
INSERT INTO bcc_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Tai sajjahén korbánigán wati yátá bedárát, tai sóchagi korbánigáni mannók bát. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Tai delay wáhagán barjáh dárát o tai sajjahén shawrbandián kámyáb kanát. ");
INSERT INTO bcc_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Tai sób o péróziá gón shádmáni kukkár bekanén o wati bayraká tai námay sará borzád bechandhénén. Hodáwand tai sajjahén dazbandián purah o sarjam bekanát. ");
INSERT INTO bcc_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Nun zánton ke Hodáwand wati rógen per moshtagéná rakkénit o cha wati pákén ásmáná áiá passawa dant, gón wati rástén dastay rakkénókén wák o tágatá. ");
INSERT INTO bcc_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Lahtén wati asp o arrábaháni sará pahra kanant, bale má wati Hodáwandén Hodáay námay sará pahra kanén. ");
INSERT INTO bcc_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Á srénprósha bant o kapant, bale má páda káén o mohra óshtén. ");
INSERT INTO bcc_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Oo Hodáwand! Bádsháhá sób o pérózi beday. Tawár ke kanén, may passawá beday. ");
INSERT INTO bcc_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodáwand! Bádsháh cha tai zórá shádmánia kant o cha tai rakkénagá ent ke inchok gal o bál ent. ");
INSERT INTO bcc_vpl VALUES ("PS21_2","020_21_2","PSA","21","2","2","Taw áiay delay morád bakshátagant o áiay lontháni wáhaget cha áiá dur nadáshtagant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Chiá ke gón bázén barkatáni dayagá pa áiay wasshátká dar átkagay o tájé cha asilén teláhá sará dátet. ");
INSERT INTO bcc_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Áiá cha taw zend lóthet o taw bakshát, rócháni dráji, abad tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Cha tai bakshátagén kámránián, áiay shán o marháh mazan ent, áiárá shawkat o mazani dátag. ");
INSERT INTO bcc_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Pa rásti abadmánén barkat bakshátag o wati bagalá gal o shadánet kortag. ");
INSERT INTO bcc_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Chiá ke bádsháh Hodáwanday sará tawkala kant o borzén arshay Hodáwanday mehrá nalarzit. ");
INSERT INTO bcc_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Tai dast, sajjahén dozhmenán dara géjit, tai rástén dast pa áyán ke cha taw naprata kanant rasit. ");
INSERT INTO bcc_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Á wahdi ke záhera bay áyán porácheshén tarunéay paymá kanay. Hodáwand wati hezhmay tahá áyán éra bárt o áiay áchesh áyána wárt. ");
INSERT INTO bcc_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Áyáni padréchá cha zeminá gár o bégwáha kanay, chokk o nabiragánesh cha mardománi nyámá. ");
INSERT INTO bcc_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","11","Harchont ke tai helápá palitén shawrbandi bekanant o badén repk o pandal besázant bale sóbéna nabant, ");
INSERT INTO bcc_vpl VALUES ("PS21_12","020_21_12","PSA","21","12","12","chiá ke taw áyána táchénay, wahdé ke wati kamáná dém pa áyána tarrénay. ");
INSERT INTO bcc_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Oo Hodáwand! Gón wati zór o twáná anchosh maz‌anshán bátay. Tai wák o kodratá satá kanén o názénén. ");
INSERT INTO bcc_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. “Sahargáhi áskay” tarzay sará. Oo mani Hodá, oo mani Hodá! Taw chiá maná tahná esht? Pa ché cha mani rakkénagá dur ay, cha mani áh o peryátán sakk jetá ay. ");
INSERT INTO bcc_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Oo mani Hodá! Sajjahén róchá peryáta kanán o taw passawé nadayay, sajjahén shapá ham, bale áráma nagerán. ");
INSERT INTO bcc_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Angat ham taw pák o palgár ay, Bani Esráil tará názénit ke taw pa bádsháhi neshtagay. ");
INSERT INTO bcc_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","May petán tai sará tawkal kort, tai sará tawkalesh kort o taw rakkéntant. ");
INSERT INTO bcc_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Tai dargáhá peryátesh kort o rakketant, tai sará tawkalesh kort o pashal o sharmendag nabutant. ");
INSERT INTO bcc_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Záná, man ensáné naán, kermé án? Mardománi démá sobakk án o kawmay chammá béezzat. ");
INSERT INTO bcc_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Harkas ke maná gendit kalág o rishkand kant. Dapá chótha kanant, sará sorénant o gwashant: ");
INSERT INTO bcc_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","“Angat wati óst o ométá pa Hodáyá band, bell á tará berakkénit, berakkénit agan tará dósta dárit.” ");
INSERT INTO bcc_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Bale taw maná cha mátay lápá dar áwort o mátay sénagá ásudagi dát. ");
INSERT INTO bcc_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Cha pédáeshá tai baddhá dawr dayag bután, cha mátay lápá mani Hodá butagay. ");
INSERT INTO bcc_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Cha man dur mabay, chiá ke sakki o sóri nazzik ent o kassé pa komaká nést. ");
INSERT INTO bcc_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Bázén narén gókéá mani chapp o chágerd geptag, Báshánay sardhagáray zóráwarén gókán maná angerr kortag, ");
INSERT INTO bcc_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","wati práhén dapesh pa man parroptag, gorrók o derrókén shéráni paymá. ");
INSERT INTO bcc_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Chó ke ápá réchag o tálán butagán sajjahén haddhon cha bandán dar átkagant. Delon chó ke mómá áp ent o sénagá sóchit. ");
INSERT INTO bcc_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Zór o tágaton kunzagi chondhé ke hoshk butag o zobánon nokká lacchetag, maná markay háká wápéntaget. ");
INSERT INTO bcc_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Kochekán mani chapp o chágerd geptag, sherr o badkáráni rombá angerr án, mani dast o pádesh thong thong kortagant, ");
INSERT INTO bcc_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","wati sajjahén haddhán shomár korta kanán. Áyán wati thélag pa man sakk kortagant, ");
INSERT INTO bcc_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","mani pocchán wati nyámá bahra kanant o jámagay sará pála janant. ");
INSERT INTO bcc_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Bale taw, oo Hodáwand! Dur mabay. Oo mani zór o tawkal! Pa mani komaká eshtáp kan. ");
INSERT INTO bcc_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Mani arwáhá cha zahm o shamshirá berakkén o mani zendagiá cha kochekáni zolm o zórákiá. ");
INSERT INTO bcc_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Maná cha shér o mazáráni dapá neját beday, ke taw maná cha wahshién káigaráni kánthán rakkéntag. ");
INSERT INTO bcc_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Tai námá pa wati brátán jára janán o mocchiay nyámá tará názénán. ");
INSERT INTO bcc_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","23","Shomá, oo Hodátorsán! Áiá benázénét. Oo Ákubay sajjahén chokk o óbádagán! Áiá ezzat o shán bedayét. Oo Esráilay padréchán! Áiay haybatá bechárét. ");
INSERT INTO bcc_vpl VALUES ("PS22_24","020_22_24","PSA","22","24","24","Chiá ke áiá cha setam distagénay bazzagiá posht nakortag o démi cha áiá natarréntag. Peryáti ke kortag áiá eshkotagant. ");
INSERT INTO bcc_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Mazanén diwáná mani satá o saná pa taw ent, wati kawlán hamáyáni démá sarjama kanán ke Hodátors ant. ");
INSERT INTO bcc_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Békebr o darbésh waráka warant o séra bant o á ke Hodáyá shóháza kanant áiá názénant. shomay del tán abad zendag bát. ");
INSERT INTO bcc_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Zeminay chárén kondh áiá yáta kanant o dém pa Hodáwandá pera tarrant, sajjahén kawmáni hándán o kothom áiay bárgáhá sará jahla kanant. ");
INSERT INTO bcc_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Chiá ke bádsháhi Hodáwandayg ent o hamá ent ke kawmáni sará hákemia kant. ");
INSERT INTO bcc_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Zeminay sajjahén zóráwar waráka warant o áiay démá kapant, hákién ensán kóndhána kapit, hamá ke watá, wat zendag dáshta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Áyókén nasl áiay hezmatá bant, démi padréch Hodáwanday bárawá sahig kanaga bant o ");
INSERT INTO bcc_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","pa áyán ke angat wadi nabutagant áiay adl o ensápá jára janant. Gwashant: “Á hamá at ke é kári kort.” ");
INSERT INTO bcc_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Dáuday Zabur. Hodáwand mani shopánk ent, hech chizzay mohtája nabán. ");
INSERT INTO bcc_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Maná sarsabzén charágáhána wápénit o pa árámén ápán sara kant. ");
INSERT INTO bcc_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Mani arwáhá tázaga kant o pa wati námaygi pahrézkáriay ráhán maná démá bárt. ");
INSERT INTO bcc_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Agan cha markay tahárterén shép o daragán ham begwazán cha hech bimm o baláhá natorsán, chiá ke taw gón man gón ay, tai latth o asá maná tasallá bakshit. ");
INSERT INTO bcc_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Dozhmenáni chammáni démá parzónagé pa man pacha kanay, pa sharapa dayagá mani saragá théla janay o mani jámá modám porr kanán ay. ");
INSERT INTO bcc_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Allamá, mehr o néki zenday sajjahén róchán mani pad o randá ant o Hodáwanday kalátá jahmenenda bán, tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","1","Dáuday Zabur. Zemin o áiay sajjahén hasti Hodáwandayg ant, jahán o sajjahén mahluk. ");
INSERT INTO bcc_vpl VALUES ("PS24_2","020_24_2","PSA","24","2","2","Chiá ke Hodáwandá áiay bonyát mán daryáyá nádént o ápáni sará óshtárént. ");
INSERT INTO bcc_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","Kay cha Hodáwanday kóhá borzád shota kant? Kay áiay pákén jágahá óshtáta kant? ");
INSERT INTO bcc_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Hamá ke deli sáp o dasti pák ent, hamá ke wati arwáhá dém pa náhudagiá natarrénit o drógén sawgenda nawárt. ");
INSERT INTO bcc_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Á cha Hodáwandá barkata gipt o cha wati rakkénókén Hodáyá, adl o ensáp. ");
INSERT INTO bcc_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Hamé paymá ant, á mardom ke Ákubay Hodáay shóházá ant, hamá ke pa áiay démá hodónák ant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Oo darwázagán! Wati sará borz bedárét. Oo kwahnén dar o dapigán! Watá pa sháhegáni pach kanét, tánke mazani o shánay bádsháh begwazit. ");
INSERT INTO bcc_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","Mazani o shánay é bádsháh kay ent? Porwák o zóráwarén Hodáwand, Hodáwand ke jangá delér ent. ");
INSERT INTO bcc_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Oo darwázagán! Wati sará borz bedárét! Oo kwahnén dar o dapigán! Watá pa sháhegáni pach kanét, tánke mazani o shánay bádsháh begwazit. ");
INSERT INTO bcc_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","Mazani o shánay é bádsháh kay ent? Lashkaráni Hodáwand hamá ent mazani o shánay bádsháh. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Dáuday Zabur. Oo Hodáwand! Man pa del o ján dém pa taw káyán. ");
INSERT INTO bcc_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Oo mani Hodá! Tai sará tawkala kanán, mayl ke pashal o sharmendag bebán o dozhmen mani sará báládast bebant. ");
INSERT INTO bcc_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Ji haw! Á ke tai sará óst o ométa kant hechbar sarjahla nabit. Á ke bé sawabá béwapáia kanant sarjahl o sharmendaga bant. ");
INSERT INTO bcc_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Oo Hodáwand! Ráhá maná pésh dár o wati keshká maná tálim day. ");
INSERT INTO bcc_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Dém pa wati rástiá maná rahshón bay o sabak beday, chiá ke taw mani rakkénókén Hodá ay o sajjahén róchá tai entezár o wadárá án. ");
INSERT INTO bcc_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Oo Hodáwand! Wati rahmat o mehrá yát kan, chiá ke á cha azalá hastant. ");
INSERT INTO bcc_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Mani warnáiay náparmáni o gonáhán yát makan, wati mehray kesásá maná yát kan ke taw nék ay, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Hodáwand nék o rást ent, paméshká gonahkárán ráhá sója dant. ");
INSERT INTO bcc_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Békebr o darbéshén mardomán rástiay ráhá rahshónia dant, wati keshká áyán pésha dárit. ");
INSERT INTO bcc_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Hamá ke Hodáwanday ahd o paymánay sará óshtant, áiay sajjahén ráh pa áyán cha mehr o wapáyá sarréch ant. ");
INSERT INTO bcc_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Oo Hodáwand! Pa wati námaygi mani gonáh o mayárán bebaksh, chiá ke mazan ant. ");
INSERT INTO bcc_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Kay ent hamá ke pa del Hodátors bebit? Hodáwand áiá hamá rástén ráhá sója dant ke báyad ent gechéni bekant. ");
INSERT INTO bcc_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","Á wati róchán pa séri o azgária gwázénit, áiay chokk o óbádag zeminay mirás baróka bant. ");
INSERT INTO bcc_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Hodáwand wati delay ráz o ramzán gón Hodátorsán darshána kant, wati ahd o paymáná pa áyán pajjárénit. ");
INSERT INTO bcc_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Mani chamm modám dém pa Hodáwandá ant, chiá ke hamá ent ke mani pádán cha dámá ázáta kant. ");
INSERT INTO bcc_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Wati démá gón man bekan o maná rahmat bebaksh, chiá ke man békas o setam distagéné án. ");
INSERT INTO bcc_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Mani delay sakki o sóri báz ant, maná cha paréshániá berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Mani ranj o sakkián bechár o sajjahén gonáhánon bebaksh. ");
INSERT INTO bcc_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Mani dozhmenán bechár ke chinchok báz ant o cha man chón pa kahr naprata kanant. ");
INSERT INTO bcc_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Mani zendá bepahréz o berakkén, mayl ke sharmendag bebán, chiá ke tai báhóth o mayár án. ");
INSERT INTO bcc_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Tachki o rásti mani negahpán bát, chiá ke mani omét taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Oo Hodá! Esráilá cha sajjahén sakki o sórián berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Dáuday Zabur. Oo Hodáwand! Gonáhay bohtámá cha mani sará bethagalén, chiá ke wati bémayáriay tahá gámon jatag o bé larzagé Hodáwanday sará tawkalon kortag. ");
INSERT INTO bcc_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Hodáwandá! Maná bechakkás o ázmáesh kan, mani del o hayálá cha chakkásá begwázén. ");
INSERT INTO bcc_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Chiá ke tai mehr modám mani chammáni démá ent o tai wapádáriay sáhegá gáma janán. ");
INSERT INTO bcc_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Na gón prébkárán hamdiwána bán o na dotal o dopóstén mardománi hamráh. ");
INSERT INTO bcc_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Cha badkáráni hamráhiá naprata kanán o gón radkárán hamdiwána nabán. ");
INSERT INTO bcc_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Oo Hodáwand! Wati dastán bégonáhiay tahá shódán o tai korbánjáhay sará chahra warán, ");
INSERT INTO bcc_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","tán wati shogrgozáriay tawárá borz kanán o tai sajjahén ajabén káráni kessahá byárán. ");
INSERT INTO bcc_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Oo Hodáwand! Maná tai lóg sakk dóst ent, tai shán o shawkatay jágah. ");
INSERT INTO bcc_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Mani sáhá gonahkáráni hórigá mager o zendá gón hónigán, ");
INSERT INTO bcc_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","ke gandahén pandalesh dastá ent o rástén dastesh cha reshwatá sarréch. ");
INSERT INTO bcc_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Bale man wati bémayáriay tahá gáma janán, maná berakkén o mani sará rahm kan. ");
INSERT INTO bcc_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Pádon tachk o sápén jágahé ér ent, mazanén diwánán Hodáwandá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Dáuday Zabur. Hodáwand mani rozhn o rakkénók ent, cha kayá betorsán? Hodáwand mani zenday kalát ent, cha kayá bimmé bebit? ");
INSERT INTO bcc_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Wahdé badkár hamlaha kanant ke mani jesm o jáná bederrant o ér bebarant, wahdé dozhmen o badwáh mani sará orosha kanant, á wat thagala warant o kapant. ");
INSERT INTO bcc_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Bell ke lashkaré mani chágerdá wati gedánán mekk bekant, angat mani dela nalarzit, agan jangé ham mani sará bekapit, angat deljam án. ");
INSERT INTO bcc_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Cha Hodáwandá yak chizzé lóthetagon o hameshiay pad o randá bán, ke wati zenday sajjahén róchán Hodáwanday lógá jahmenend bebán, tánke Hodáwanday zébáiá begendán o parasteshgáhá cha hamáiá rahshóni belóthán. ");
INSERT INTO bcc_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Chiá ke sakki o sóriáni róchá maná wati sáhegá dárit, wati tambuay tahá chéra dant o taláréay sará borzá óshtárénit. ");
INSERT INTO bcc_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Nun dozhmenáni angerrá sarperáza bán o gón shádmániáni kukkárá áiay tambuay tahá korbániga kanán, Hodáwandá pa sawt o sáza názénán. ");
INSERT INTO bcc_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Oo Hodáwand! Wahdé peryáta kanán mani tawárá beshkon, mani sará rahm kan o passaw beday. ");
INSERT INTO bcc_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Taw gwashtag: “Mani chehragay shóházá bebay.” Dela gwashit: “Hodáwandá! Tai chehragay shóházá án.” ");
INSERT INTO bcc_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Démá cha man chér maday, wati hezmatkárá gón hezhm per matarrén, taw ke mani madatkár butagay. Oo mani rakkénókén Hodá! Maná dawr maday o yalah makan. ");
INSERT INTO bcc_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Agan mát o pet ham maná yalah bekanant, Hodáwand wat maná zurit o dasta gipt. ");
INSERT INTO bcc_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Oo Hodáwand! Wati ráhá maná sój day, dozhmenáni sawabá maná rást o tachkén ráhá rahshón bay. ");
INSERT INTO bcc_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Pa dozhmenáni wáhagá maná yalah makan, chiá ke drógén sháhed mani helápá pád átkagant ke jang o chópay ásá damant. ");
INSERT INTO bcc_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Deljam án ke Hodáwanday nékiá zendagénáni zeminá gendán. ");
INSERT INTO bcc_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Hodáwanday wadárá bay, zórmand bay o delá dhaddh kan. Haw! Hodáwanday wadárá bay. ");
INSERT INTO bcc_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Dáuday Zabur. Oo Hodáwand, oo mani talár! Tará tawára kanán, cha man nádelgósh mabay. Agan taw bétawár bebay, hamáyáni paymá bán ke kall o kabrá kapant. ");
INSERT INTO bcc_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Mani peryát o záriay tawárá gósh dár, wahdé cha taw madata lóthán o wati dastán dém pa tai pákén bárgáhá borza kanán. ");
INSERT INTO bcc_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Maná badkáráni hamráhiá gerrán makan o makassh, hamá ke radén kára kanant o gón hamsáhegán cha sohl o saláhá habará ant, bale delesh cha sherr o shórá porr ent. ");
INSERT INTO bcc_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Kortagén káráni mozzáesh beday, hamsang gón áyáni badén kárán, dastay kortagénáni mozzáesh beday, áyáni káráni kaddá. ");
INSERT INTO bcc_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Paméshká ke Hodáwanday káráni parwáhá nakanant, áiay dazhonaray káráni háterá nadárant, á eshán tabáha kant o hechbar pa rost o rodómá naylit. ");
INSERT INTO bcc_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Hodáwandá satá bát, chiá ke mani peryát o záriay tawári eshkotag. ");
INSERT INTO bcc_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Hodáwand mani zór o espar ent, delon áiay sará tawkala kant o madaton rasetag. Del cha shádmániá sarréch ent o gón wati sawt o názénkán áiay shográ gerán. ");
INSERT INTO bcc_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Hodáwand wati mardománi zór o twán ent, pa rógen per moshtagéná rakkagay kaláté. ");
INSERT INTO bcc_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Wati mardomán berakkén o wati kawmá barkat beday, áyáni shopánk bay o tán abad wati kópagá bejallesh. ");
INSERT INTO bcc_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Dáuday Zabur. Oo ásmánián! Hodáwandá satá kanét, Hodáwanday shán o kodratá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Hodáwanday námay shán o shawkatá satá kanét, Hodáwandá mán áiay pák o palgárén drapshnákiá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Hodáwanday tawár ápáni sarborá ent, shán o shawkatay Hodá grandit, Hodáwand porzórén ápáni sarborá grandit. ");
INSERT INTO bcc_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Hodáwanday tawár zórmand ent, Hodáwanday tawár drapshnák ent. ");
INSERT INTO bcc_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Hodáwanday tawár gazzána próshit, Hodáwand Lobnánay gazzána próshit. ");
INSERT INTO bcc_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Á Lobnáná gwaskéay paymá jáha serrénit, Siryuná jalabén gókéay paymá. ");
INSERT INTO bcc_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Hodáwanday tawár grand o grókén áchesh rawána kant. ");
INSERT INTO bcc_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Hodáwanday tawár gyábáná larzénit, Hodáwand Kádeshay gyábáná larzénit. ");
INSERT INTO bcc_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Hodáwanday tawár áposén áskána géjénit o jangalá bé lamb o táka kant. Áiay parasteshgáhá sajjahén gwánka janant: “Shawkat o shán!” ");
INSERT INTO bcc_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Hodáwand hár o tuppánay sarborá, wati tahtay sará neshtag, Hodáwand tán abad wati bádsháhi tahtay sará neshtag. ");
INSERT INTO bcc_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Hodáwand wati kawmá wák o kodrat bebakshát, Hodáwand wati kawmá gón sohl o émeni barkat bedayát. ");
INSERT INTO bcc_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Dáuday Zabur. Pa mazanén parasteshgáhay wapká sawté. Oo Hodáwand! Tará shán o shawkata dayán, chiá ke taw maná cha johlánkián chest kort o naeshtet dozhmen mani sará shádehi bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Oo Hodáwand, mani Hodá! Tai gwará pa komaká peryáton kort o taw maná cha nájórhiá dráh kort, ");
INSERT INTO bcc_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","mani arwáh cha mordagáni jaháná dar áwort o cha áyáni nyámá ke kall o kabr butant zendag kort. ");
INSERT INTO bcc_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Oo Hodáwanday dóstdárán! Pa Hodáwandá názénk bejanét, áiay pák o palgárén námay shográ begerét. ");
INSERT INTO bcc_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Chiá ke hezhmi damáné o mehr o rahmati omray drájiá. Bit ke sajjahén shapé pa gréwag begwazit, bale bámgwáhá shádehi wati chehragá záhera kant. ");
INSERT INTO bcc_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","6","Man wati ásudagiay wahdá gwasht: “Hechbar larzénaga nabán.” ");
INSERT INTO bcc_vpl VALUES ("PS30_7","020_30_7","PSA","30","7","7","Oo Hodáwand! Taw maná cha wati mehr o rahmatá mohrén kóhéay paymá óshtáréntagat, bale wahdé wati démet cha man tarrént, torseton. ");
INSERT INTO bcc_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Oo Hodáwand! Tará tawáron jat, tai gwará zári o peryáton borz kort: ");
INSERT INTO bcc_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","“Mani marká che sutté mán o kabray tahá mani ér rawagá chónén páedagé? Záná, hák tará satá dant? Jára jant ke taw wapádár ay? ");
INSERT INTO bcc_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Oo Hodáwand! Beshkon o mani sará mehrabán bay. Hodáwandá! Mani madat kanók bay.” ");
INSERT INTO bcc_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Taw mani mótk nách o sohbaté kort, sugi god o póshák dar kort o maná gón shádmániá póshént, ");
INSERT INTO bcc_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","tánke mani arwáh tará satá bedant o bétawár mabit. Oo Hodáwand, mani Hodá! Tán abad tai shográ gerán. ");
INSERT INTO bcc_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodáwand! Tai mayár o báhóth butagán, hechbar mayl ke sharmendag bebán, wati adl o ensápay tahá maná neját beday. ");
INSERT INTO bcc_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Wati delgóshá gón man bedár o maná zutt berakkén. Pa man panáhay taláré bay o pa mani rakkénagá mohrén kaláté. ");
INSERT INTO bcc_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Pa rásti mani talár o kalát ay, pa wati námaygi maná ráh sója dayay o rahshónia kanay. ");
INSERT INTO bcc_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Maná cha á dámá dar byár ke pa man chér o andém ent, chiá ke mani panáh taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Wati ruh o sáhá tai dastá dayán. Oo Hodáwand, oo wapádárén Hodá! Taw maná rakkénay. ");
INSERT INTO bcc_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Tará cha áyán naprat ent ke delgóshesh gón béarzeshén botán ent, bale man tai sará tawkala kanán, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Tai mehrá gala bán o shádehia kanán, chiá ke taw mani syahróchi distagant o mani arwáhay sakkiáni némagá hayál gwar kortag. ");
INSERT INTO bcc_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Maná dozhmenáni dastá nadayay o mani pádán práh o sháygánén jágahé éra kanay. ");
INSERT INTO bcc_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Oo Hodáwand! Mani sará rahm kan chiá ke paréshán án, chammon cha gam o andóhán nezór butagant, jesm o arwáh ham. ");
INSERT INTO bcc_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Chiá ke zendon gamán wártag o omr nálagán, cha mani gonáhá, tágaté pa man pasht nakaptag o haddh o bandon pussán ant. ");
INSERT INTO bcc_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Dozhmenáni sawabá sobakk o kalági butagán, hás pa hamsáhegán, pajjárók cha man torsán ant o harkas maná kuchah o damkána gendit, tachit. ");
INSERT INTO bcc_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Mordagáni warhá cha yátá shotagán o proshtagén kunzagéay paymá butagán. ");
INSERT INTO bcc_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Chiá ke bázénéay bohtámán eshkonagá án, tors o dehshat cha har gwará, gón yakdegará pandala jórhénant o pa mani koshagá mandr o repka sázant. ");
INSERT INTO bcc_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Bale oo Hodáwand! Man tai sará tawkala kanán o gwashán ke “taw mani Hodá ay.” ");
INSERT INTO bcc_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Mani wahd o damán tai dastá ant, maná cha dozhmenán berakkén, cha hamáyán ke mani randá kaptagant. ");
INSERT INTO bcc_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Démá pa wati hezmatkárá drapshán kan, gón wati mehrá maná berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Hodáwandá! Mayl ke sharmendag bebán, chiá ke tará tawáron per jatag, bell ke sharur sarjahl o sharmendag bebant o mordagáni jaháná bétawár. ");
INSERT INTO bcc_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Drógbandén lonthesh chopp bátant, ke gón kebr o ér janag pahrézkáráni helápá pa gorunáki habara kanant. ");
INSERT INTO bcc_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Tai néki chenkadar báz ent, ke pa Hodátorsán ambáret kortag o bani ádamáni chammáni démá pa hamáyán purah o sarjam kortag ke tai báhótha bant. ");
INSERT INTO bcc_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Eshán wati bárgáhay panáhá cha mardománi pandalán chér o andéma dáray o wati sáhegá cha bohtám janókén zobánán dur. ");
INSERT INTO bcc_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Hodáwandá satá bát, chiá ke wati ajabén mehrá hamé wahdá pa man paddara kant ke man dawrah butagén shahréay paymá angerr án. ");
INSERT INTO bcc_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Man cha wati torsá gwasht: “Cha tai chammá sestag o dur kaptagán.” Angat taw mani peryát o záriá eshkonay, wahdé man pa madatá tará tawára kanán. ");
INSERT INTO bcc_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Oo Hodáwanday sajjahén dóstdárán! Áiá dóst bedárét, Hodáwand wati wapádáráni negahpániá kant, bale gorunákénán báz sezá dant. ");
INSERT INTO bcc_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Oo sajjahénán ke Hodáwanday wadárá ét! Porzór bebét o delá dhaddh kanét. ");
INSERT INTO bcc_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Dáuday shayri gwashtánk. Bahtáwar hamá ent ke Hodáwand cha áiay násharián sar gwastag o gonáhi bakshag butagant. ");
INSERT INTO bcc_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Bahtáwar hamá ent ke Hodáwand áiay gonáhá hechbar hesába nayárit o áiay arwáhá prébé mán nést. ");
INSERT INTO bcc_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Wahdé chopp o bétawár atán haddh o bandon pussán atant, cha sajjahén róchay zári o peryátán. ");
INSERT INTO bcc_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Chiá ke róch o shap tai dast mani sará sangin at, sajjahén tágaton hoshagá at, chó ke garmágay taptay chérá bebán. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Gorhá wati gonáhon tai dargáhá mannet o wati náparmániánon chér nadát. Gwashton: “Wati gonáh o sarkashián Hodáwanday gwará mannán” o taw mani gonáhay mayárbári bakshet. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Paméshká, tán wahd o móh ent, har Hodádóst tai gwará dwá bekant, wahdé hárén áp chesta bant, hech paymá pa áiá sar buta nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Taw mani chér bayagay jágah ay, cha sakki o tangián maná émena dáray o gón ázátiay sawt o zémelán gwarambáza kanay. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Hodáwanda gwashit: “Tará hamá ráhá sója dayán ke báyad ent beraway, tará shawr o saláha dayán o tará chárána bán. ");
INSERT INTO bcc_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Násarpadén asp yá kacharay paymá mabay, ke tahná gón lagám o mahárá rám kanaga bit, agan na, tai nazziká nayayt.” ");
INSERT INTO bcc_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Badkáray ranj o azáb báz ant, bale Hodáwanday mehr hamáiay chapp o chágerdá gipt ke Hodáwanday sará tawkala kant. ");
INSERT INTO bcc_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Oo pahrézkárán! Hodáwanday bárgáhá shádehi kanét o shádán bebét. Oo sajjahén nékdelán! Shádehiay gwánká borz kanét. ");
INSERT INTO bcc_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Oo pahrézkárán! Hodáwanday bárgáhá pa shádehi kukkár kanét, nékdelán, Hodáwanday satá kanag zéba dant. ");
INSERT INTO bcc_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Hodáwandá gón chang benázénét, gón dahtárén changá pa áiá sáz bejanét. ");
INSERT INTO bcc_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Pa áiá, nókén sawté byárét, gón washpanjagi simmán belarzénét o pa shádehi gwánk janét. ");
INSERT INTO bcc_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Chiá ke Hodáay habar tachk o rást ent o áiay sajjahén kár gón wapádáriá. ");
INSERT INTO bcc_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Áiá adl o rásti dósta bit, zemin cha áiay mehrá porr ent. ");
INSERT INTO bcc_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Gón Hodáwanday gál o habará ásmán addh butagant o áyáni sajjahén lashkar, gón áiay dapay damá. ");
INSERT INTO bcc_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Daryáay ápán mocch o hákótha kant o johlián mán ambárá. ");
INSERT INTO bcc_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Sajjahén zemin cha Hodáwandá betorsit, jahánay sajjahén mardom áiá ezzat bedayant. ");
INSERT INTO bcc_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Chiá ke áiá gwasht o hamá chizz paym but, parmáni dát o barjáh dárag but. ");
INSERT INTO bcc_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Hodáwand, kawmáni shawrbandián pacha réchit o rájáni kársáziána karójit. ");
INSERT INTO bcc_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Bale Hodáwanday shawr o saláh abadmán ant, áiay delay shawrbandi pa sajjahén nasl o padréchán. ");
INSERT INTO bcc_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Bahtáwar hamá kawm ent ke Hodáwand áiay Hodá ent, hamá mardom ke áiá pa wati mirásá gechén kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Hodáwand cha ásmáná jahláda chárit o sajjahén bani ádamána gendit, ");
INSERT INTO bcc_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","cha wati bádsháhi tahtá zeminay sajjahén jahmenendána chárit, ");
INSERT INTO bcc_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","á ke é sajjahénáni deli jórh kortag o áyáni har kár o kerdá zánt. ");
INSERT INTO bcc_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Bádsháhá, wati lashkaray mazani nejáta nadant o sarmachárá, wati básk o panjagáni zór. ");
INSERT INTO bcc_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Pa sóbén bayagá, aspay sará omét bandag náhudag ent, toré zóráwar bebit bale rakkénta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Haw! Hodáwanday chamm gón hamáyán ent ke cha áiá torsant, gón hamáyán ke óst o ométesh áiay mehr ent, ");
INSERT INTO bcc_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","tánke áyáni arwáhá cha marká berakkénit o mán dhokkálá zendagesh bedárit. ");
INSERT INTO bcc_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","May arwáh Hodáwanday wadárá ent, hamá may komak o espar ent. ");
INSERT INTO bcc_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","May del áiay bárgáhá shádmánia kant, chiá ke may tawkal hamáiay pákén námay sará ent. ");
INSERT INTO bcc_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Oo Hodáwand! Tai mehr may sará sáhél bát, hamá dábá ke ométen pa taw bastag. ");
INSERT INTO bcc_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Dáuday Zabur. Hamá wahdá ke áiá Abimelekay kerrá watá ganókáni paymá kort, cha ódá dar kanag but o wati ráhá shot. Dáemá Hodáwandá názénán áiay satá o saná modám mani dapá ent. ");
INSERT INTO bcc_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Mani arwáh Hodáwanday sará pahra kant, békebrén mardom beshkonant o shádehi bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Gón man hórigá Hodáwandá mazani bedayét, byáét ke hawáriá áiay námá názénén. ");
INSERT INTO bcc_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Hodáwandon shóház kort o maná passawi dát, cha mani sajjahén torsán maná ázáti kort. ");
INSERT INTO bcc_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Á ke chammesh gón áiá ent drapshán ant, áyáni dém hechbar sharmsára nabit. ");
INSERT INTO bcc_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","É meskiná tawár per jat, Hodáwandá áiay tawár eshkot o cha sajjahén sakkián rakkénti. ");
INSERT INTO bcc_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Hodáwanday préshtag Hodátorsáni chapp o chágerdá pallé bandit o áyán nejáta dant. ");
INSERT INTO bcc_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Bechashét o bechárét ke Hodáwand nék ent, bahtáwar hamá ent ke áiay mayár o báhótha bit. ");
INSERT INTO bcc_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Oo Hodáwanday palgártagénán! Cha Hodáwandá betorsét, chiá ke Hodátorsán hech kammié nést. ");
INSERT INTO bcc_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Warnáén shér mohtáj o shodiga bant, bale Hodáwanday shóház kanókán cha nékiá hech kammié nést. ");
INSERT INTO bcc_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Oo chokkán! Byáét o cha man beshkonét, man shomárá sabaka dayán ke Hodáwandá chón bemannét. ");
INSERT INTO bcc_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Cha shomá kay pa zendá hodónák ent o wasshén rócháni gendagay lóthók? ");
INSERT INTO bcc_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","Wati zobáná cha badiá dur bedár o lonthán cha drógá. ");
INSERT INTO bcc_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Cha badiá per tarr o néki kan, sohl o émeniay shóházá bebay o hameshiay randá bekap. ");
INSERT INTO bcc_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Hodáwanday chamm gón pahrézkárán ent o góshi ham pa áyáni peryátán pach. ");
INSERT INTO bcc_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Hodáwanday dém badkáráni helápá ent, tán áyáni yátá cha jaháná beborrit o gomsár bekant. ");
INSERT INTO bcc_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Wahdé pahrézkár peryáta kanant, Hodáwanda eshkont o áyán cha sajjahén sakkiána rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Hodáwand gón proshtadelán nazzik ent o droshtaruhán rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Pahrézkárá bázén sakki o sória rasit, bale Hodáwand áiá cha sajjahén sakkiána rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Áiay sajjahén haddhán mohra dárit, cha áyán yakké ham próshaga nabit. ");
INSERT INTO bcc_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Badi badkárá koshit o hamá ke cha pahrézkárá naprata kant, mayárbára bit. ");
INSERT INTO bcc_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Hodáwand wati hezmatkáráni zendá rakkénit, harkas ke áiay báhótha bit, mayárbára nabit. ");
INSERT INTO bcc_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Dáuday Zabur. Oo Hodáwand! Gón hamáyán bemerh ke gón mana merhant o gón hamáyán jang kan ke gón man janga kanant. ");
INSERT INTO bcc_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Wati kasán o mazanén esparán bezur o mani madatá jáh bejan. ");
INSERT INTO bcc_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Pa áyán ke mani randá kaptagant wati nayzahá chest kan o áyáni ráhá band. Mani arwáhá begwash: “Tai rakkénók man án!” ");
INSERT INTO bcc_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Á ke mani zenday tabáhiay randá ant, roswá o sharmendag bátant. á ke pa mani táwáná pandala jórhénant, poshtá bekenzát o pashal bátant. ");
INSERT INTO bcc_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Chosh ke pog o palár gwátay démá, Hodáwanday préshtag áyán betáchénát. ");
INSERT INTO bcc_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Ráhesh tahárók o lakoshánk bát o Hodáwanday préshtag áyáni padá bekapát, ");
INSERT INTO bcc_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","chiá ke mopt o náhakká pa man dámesh chér gétkag o pa mani arwáhá kallesh kótkag. ");
INSERT INTO bcc_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Anágat tabáhi‌esh chakká kapát o wati chér gétkagén dámá kapátant, kapát o gár o gomsár bátant. ");
INSERT INTO bcc_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Gorhá mani arwáh Hodáwanday bárgáhá shádehia kant o pa wati rakkagá lezzata bárt. ");
INSERT INTO bcc_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Á wahdá har band o bógon gwánka jant: “Oo Hodáwand! Tai matth kay ent? Taw nézgárá cha zóráwarteréná rakkénay o nezór o hájatmandá cha pol o pánch kanóká.” ");
INSERT INTO bcc_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Badwáh o bérahmén sháhed jáha janant o hamá mayárán maná laddhant ke cha áyán sahig naán. ");
INSERT INTO bcc_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Nékiay badalá gón man badia kanant o mani arwáh gamig o porsig ent. ");
INSERT INTO bcc_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Bale wahdé á nádráh atant, man sugi god o póshák gwará kort o jesm o ján gón róchag dáragá ranjént. Wahdé mani dwá bépassaw mantant ");
INSERT INTO bcc_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","gréwán bután, hamá dábá ke pa dóst yá brátéá gamiga bant, sar jahl o mótk árán bután, hamá dábá ke pa mátá zára janant. ");
INSERT INTO bcc_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Bale wahdé thagalon wárt past o lagór gón mazanén shádehié mocch butant, mani helápá wahdé man sahig naatán, á maná derrán atant o bassesha nakort. ");
INSERT INTO bcc_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Chó Hodánábáwarán, áyán wati maskará gésh kanána kort o pa man dantánesha drosht. ");
INSERT INTO bcc_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Oo Hodáwand! Tán kadéna nenday o cháray? Mani arwáhá cha áyáni setamá berakkén, mani yakkén zendá cha shéráni dapá. ");
INSERT INTO bcc_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Gorhá mazanén diwáná tai shográ gerán, mardománi mazanén mocchiá tará satá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Mayl ke prébkárén dozhmen mani sará shádehi kanant, mayl hamá ke mopt o náhakká cha man bézár ant chammok o pónzok bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Chiá ke pa sohl o émeni habara nakanant, pa á mardomán ke molká árám o béják neshtagant pormakrén habar payma kanant. ");
INSERT INTO bcc_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Dapá pa man pacha réchant o gwashant: “Hah, hah, hah! Gón wati chammánen distag!” ");
INSERT INTO bcc_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Oo Hodáwand! Taw é distag, chopp o bétawár mabay. Hodáwandá! Cha man dur mabay. ");
INSERT INTO bcc_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Ágáh bay o pa mani dádrasiá jáh bejan. Oo mani Hodá, oo mani Hodáwand! Pa mani hakká. ");
INSERT INTO bcc_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Oo mani Hodáwandén Hodá! Pa wati adlaygi gonáhay bohtámá cha man thagalén, mayl á mani sará shádehi bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Mayl wati delá begwashant: “Hah, hah, hah! Pa wati armáná rasetén.” Mayl begwashant: “Lonkahé kort o éren bort.” ");
INSERT INTO bcc_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Harkas ke mani mosibatáni sará shádehia kant sharmendag o sarjahl bát, á ke watá cha man borztera kanant gón sharm o bésharapi póshénag bátant. ");
INSERT INTO bcc_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Á ke wáhagesh mani bémayári ent shádmán bátant o shádehiay gwánká borz kanátant, modám begwashátant: “Hodáwand mazan ent ke cha wati hezmatkáray salámatiá gala bit.” ");
INSERT INTO bcc_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Gorhá zobánon sajjahén róchá tai adlá gwánka jant, tai satá o sanáyá. ");
INSERT INTO bcc_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Pa sázger o washáwázáni sálárá. Hodáwanday hezmatkár Dáuday Zabur. Gonáh, badkárá mán áiay delay johlánkiá gwánka jant, áiay chammán Hodátorsi nést. ");
INSERT INTO bcc_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Chiá ke á wati jenday delá haminchok wati tawsipá kant, ke wati gonáhá nazánt o cha áiá naprat korta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Dapay habari badi o préb ent, cha aglmandi o nékkáriá dasti shoshtag. ");
INSERT INTO bcc_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Tantaná wati gandal o bestará pandala sázit, gonahkáriay ráhi geptag o badiá yalaha nakant. ");
INSERT INTO bcc_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Oo Hodáwand! Tai mehr arshá rasit o wapádári tán jambarán. ");
INSERT INTO bcc_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Tai adl o rásti borzterén kóháni dhawlá ent o ensáp, mazanén johlánkiáni. Oo Hodáwand! Taw ay ke ensán o haywánay rakkénók ay. ");
INSERT INTO bcc_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Oo Hodá! Tai mehr chenkadar porarzesh ent, bani ádam tai bánzoláni sáhegá panáha gipt. ");
INSERT INTO bcc_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Á cha tai bárgáhay sarréchén nyámatán séra bant o cha wati lezzatáni kawrá áyán sérápa kanay. ");
INSERT INTO bcc_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Chiá ke zendmánay sarchammag taw ay o cha tai nurá ent ke nura gendén. ");
INSERT INTO bcc_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Pa wati dóstdárán wati mehrá modám barjáh dár o adl o rástiá pa nékdelán. ");
INSERT INTO bcc_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Porkebráni pád mani sará ér mabát, badkáráni dast maná sargardán makanát. ");
INSERT INTO bcc_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Bechár badkár che paymá kaptagant, háká sarshakun o pád átka nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","1","Dáuday Zabur. Badkáráni sawabá jósh majan o radkáráni sará hasadd makan. ");
INSERT INTO bcc_vpl VALUES ("PS37_2","020_37_2","PSA","37","2","2","Chiá ke é káhay paymá zutta gimmorant o sabzagáni paymá hoshka tarrant. ");
INSERT INTO bcc_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Hodáay sará tawkal kan o nékiay ráhá ger, wati molká jahmenend bay o wapádáriay randgir. ");
INSERT INTO bcc_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Cha Hodáwandá shádmán bay ke á tai delay morádá puraha kant. ");
INSERT INTO bcc_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Wati zendmánay ráhá Hodáwanday sepordag kan o áiay sará tawkal, ke kársáz hamá ent. ");
INSERT INTO bcc_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Á tai bémayáriá nuray paymá róshena kant o dádrasiá chó bámgwáhay rozhnáiá drapshán. ");
INSERT INTO bcc_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Hodáwanday bárgáhá árám bay o gón ópáré áiay wadárá. Áyáni sawabá jósh majan ke wati ráhá kámrán ant o áyáni sawabá ham ke palitén pandalán kára bandant. ");
INSERT INTO bcc_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Cha hezhmá dur bay o gazabá yalah kan. Jósh majan ke tará dém pa badkáriá bárt. ");
INSERT INTO bcc_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Chiá ke badkár goddhaga bant, bale á ke Hodáwanday wadárá ant molká mirása barant. ");
INSERT INTO bcc_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Kammoké wahdá rand badkára namánit, shomá áiá sakk báz shóháza kanét bale nagendéti. ");
INSERT INTO bcc_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Narmdel molká mirása barant o cha wasshén sohl o émeniá shádkámia kanant. ");
INSERT INTO bcc_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Badkár pahrézkáray helápá pandala sázit o pa áiá dantána droshit, ");
INSERT INTO bcc_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","bale Hodáwand badkáray sará kandit, chiá ke zánt áiay rócha kayt. ");
INSERT INTO bcc_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Badkár wati zahmá cha nyámá dara kanant o kamáná kasshant, tán nezór o hájatmandán chér betarrénant o nékdelán tégáni dapá bedayant. ");
INSERT INTO bcc_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Bale áyáni zahm, wati jenday delá nendit o kamánesha proshant. ");
INSERT INTO bcc_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","16","Pahrézkáray kammén hasti cha bázén badkáráni hastiá gehter ent. ");
INSERT INTO bcc_vpl VALUES ("PS37_17","020_37_17","PSA","37","17","17","Chiá ke badkáráni báskay zóra proshit, bale Hodáwand pahrézkáráni madat kanók ent. ");
INSERT INTO bcc_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Hodáwand bégonáháni rócháni negahpán ent o mirásesh namirána bit. ");
INSERT INTO bcc_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Baláh o mosibatáni wahdá bazzag o sharmendaga nabant o kahti o dhokkálay róchán sér o ábáda bant. ");
INSERT INTO bcc_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Bale badkár gára bant, Hodáwanday dozhmen charágáhay sabzagáni paymá gár. Haw! Zyána bant, duttay paymá zyán. ");
INSERT INTO bcc_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Badkár wáma kant o padá nadant, bale pahrézkár pa daspachia bakshit. ");
INSERT INTO bcc_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Allamá, áyán ke Hodáwand barkata dant molká mirása barant, bale áyán ke nálata kant, gár o bégwáha bant. ");
INSERT INTO bcc_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Hodáwand hamáiay gámán mohra kant ke Hodáwanday ráhá shádehia kant. ");
INSERT INTO bcc_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Toré bethagalit, zeminá nakapit, chiá ke Hodáwand áiay negahpán ent. ");
INSERT INTO bcc_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Warná atán o nun pir án, bale choshén pahrézkáré nadiston ke Hodáwandá yalah kortag yá ke chokki pa nánéá gadá butagant. ");
INSERT INTO bcc_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Modám daspach ent o pa ásáni wáma dant, chokki barkata kárant. ");
INSERT INTO bcc_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Cha badiá démá chahr day o néki kan, gorhá tán abad molká jahmenenda bay. ");
INSERT INTO bcc_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Chiá ke Hodáwandá adl dóst ent o wati dóstdárán yalaha nakant. Hodáwand tán abad pahrézkáráni posht o panáh ent, bale badkáráni nasl goddhaga bit. ");
INSERT INTO bcc_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Pahrézkár molká mirása barant o tán abad hamódá jahmenenda bant. ");
INSERT INTO bcc_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Pahrézkáray dap hekmat tálána kant o zobáni adl. ");
INSERT INTO bcc_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Hodáwanday Sharyat áiay delá ent o pádia nalakoshant. ");
INSERT INTO bcc_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Badkár, pa pahrézkárá kamina kant o áiay kóshay randá ent. ");
INSERT INTO bcc_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Bale Hodáwand áiá badkáray zóray tahá naperrénit o wahdé hakdiwáná baraga bit, pa mayárbáriá nayliti. ");
INSERT INTO bcc_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Hodáwanday wadárá bay o hamáiay ráhá bósht, ke tará pa molkay mirás baragá sarperáza kant, wata genday ke badkár chón goddhaga bant. ");
INSERT INTO bcc_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Badkár o bérahmén mardé diston ke sarsabzén drachkéay paymá wati jáhá shádáb at, ");
INSERT INTO bcc_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","bale namant o zutt mort, harché shóházon kort, gendag nabut. ");
INSERT INTO bcc_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Béaybén mardá begend o nékdelá bechár, chiá ke sohl o émeniay shóház kanóká ákebaté hast, ");
INSERT INTO bcc_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","bale sajjahén sarkash gár o gomsára bant, badkár goddhaga bant o áyán ákebaté nést. ");
INSERT INTO bcc_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Pahrézkáráni rakkénók Hodáwand ent o sakkiay wahdá áyáni kalát. ");
INSERT INTO bcc_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Hodáwand áyán madata dant o rakkénit, cha badkáráni dastá rakkénit o nejáta dant, chiá ke áiay mayár o báhóth ant. ");
INSERT INTO bcc_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Dáuday Zabur. Dazbandié. Oo Hodáwand! Maná gón wati hezhmá hakkal maday o gón wati gazabá neherr. ");
INSERT INTO bcc_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Chiá ke tai tirán mani ján soptag o tai dastay zór mani sará kaptag. ");
INSERT INTO bcc_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Cha tai gazabá mani jesm o jáná hech dráhié pasht nakaptag o cha gonáhá, mán haddhán ham salámatié. ");
INSERT INTO bcc_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Mani mayárbári cha sará sar gwastag, gránén báréay paymá cha tágatá gésh ent. ");
INSERT INTO bcc_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Cha mani ahmakiá thappon bó geptag o bazhnák ant. ");
INSERT INTO bcc_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Purah komp o dotal án, sajjahén róchá mátam kanáná gardán. ");
INSERT INTO bcc_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Sréná sóchnákén dardé tawrénagá ent o jesmá dráhié nést. ");
INSERT INTO bcc_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Man ájez án o droshag butagán, cha delay áshópá nálán. ");
INSERT INTO bcc_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Oo Hodáwand! Mani sajjahén armán tai démá ant, áhsard o ginsárton cha taw chér naant. ");
INSERT INTO bcc_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Delon mán sénagá kop koppá ent, wák o twánon dar shotag, chammáni rozhnái ham gár ent. ");
INSERT INTO bcc_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Dóst o hambalon thappáni sawabá cha man watá kerré dárant o nazzikén ham dur óshtátagant. ");
INSERT INTO bcc_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Á ke mani kóshay randá ant, dám chéra kanant, badwáh mani gomsár kanagay habará kanant o sajjahén róchá pandala sázant. ");
INSERT INTO bcc_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Bale man karréay paymá án ke naeshkont o gongéay paymá ke bétawár ent. ");
INSERT INTO bcc_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Pa rásti man anchén mardoméay dhawlá án ke naeshkont o dapá passawé nésti. ");
INSERT INTO bcc_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Oo Hodáwand! Pa taigi ent ke wadárá án. Oo Hodáwand, mani Hodá! É taw ay ke passawa dayay. ");
INSERT INTO bcc_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Chiá ke gwashton: “Wahdé pádona larzit, hamá mardomán mani sará shádehi kanagá mayl ke watá cha man mastera zánant.” ");
INSERT INTO bcc_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Chiá ke kapagi án o mani dard modám gón man gón ent. ");
INSERT INTO bcc_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Wati mayárbáriá mannán o cha wati gonáhá sakk padard án. ");
INSERT INTO bcc_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Sarzór o salámat ant, á ke mani dozhmen ant, bázéné bé sawabá cha man naprata kant. ");
INSERT INTO bcc_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Á ke nékiay badalá gón man badia kanant, mani dozhmen o bohtám janók ant, chiá ke man nékiay randá án. ");
INSERT INTO bcc_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Oo Hodáwand! Maná yalah makan. Oo mani Hodá! Cha man dur mabay. ");
INSERT INTO bcc_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Oo Hodáwand, mani rakkénók! Pa mani madatá eshtáp kan. ");
INSERT INTO bcc_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Pa sázger o washáwázáni sálárá. Pa Yedutuná. Dáuday Zabur. Gwashton ke “pahréza kanán tán gón wati zobáná gonáh makanán. Tán wahdé badkáré mani kerrá ent wati dapá lagáma kanán.” ");
INSERT INTO bcc_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Chopp o bétawár bután, tantaná sharrén habaré ham nakorton, bale dard o andóhon géshter butant. ");
INSERT INTO bcc_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","Delon mán daruná jósh janagá ent. Wahdé géshter pegrona kort, ásá shamálaha kasshet, gorhá zobánon pach but. ");
INSERT INTO bcc_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Oo Hodáwand! Mani ákebatá paddar kan, mani rócháni hesáb chi ent, bell tán bezánán ke chón zutta gwazant. ");
INSERT INTO bcc_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Taw mani zend bechilléay kaddá kortag, mani zendmánay sál, tai chammá hecch naant. Saddak án ke ensánay zend yak sáhé gésh naent.” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Béshakk ensán chó sáhegéá chakkarit, béshakk ke á mopt o náhudagá tach o tága kant, mocch o ambára kant, bale nazánt ke kayá rasant. ");
INSERT INTO bcc_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","“Bale nun oo Hodáwand! Man che chizzay wadárá án? Ométon tai sará ent. ");
INSERT INTO bcc_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Maná cha sajjahén náparmánián chotthén o ahmakáni kalági makan. ");
INSERT INTO bcc_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Bétawár án o dapá pacha nakanán, chiá ke é taw kortag. ");
INSERT INTO bcc_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Wati zarbatá cha mani sará dur kan, ke cha tai shahmátá tostag o kaptagán. ");
INSERT INTO bcc_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Taw pa hakkal ensáná cha gonáhá adaba dayay o áiay dósténán hamá paymá kanay ke raméz o waróka kant. Saddak án ke ensánay zend sáh o damé gésh naent. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Oo Hodáwand! Mani dwáyá beshkon o pa komaká mani peryátay némagá delgósh kan, arsánon mashamósh o bétawár mabay. Chiá ke tai gwará mehmánéay paymá án, darámadé, wati pet o pirénáni dhawlá. ");
INSERT INTO bcc_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Wati gazabá cha man dur kan, tán cha jahánay yalah kanagá pésar padá gal bebán.” ");
INSERT INTO bcc_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Gón sabré pa Hodáwandá wadáron kort, démi gón man tarrént o mani peryáti eshkot. ");
INSERT INTO bcc_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Maná cha johlánkén kalléá dar áworti, cha gel o gandápá, mani pádi taláréay sará óshtárént o gámi mohr kortant. ");
INSERT INTO bcc_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Nókén sawté mani dapá dáti, may Hodáay satá o sanáay shayr. Bázéné gendit o mannit o Hodáwanday sará tawkala kant. ");
INSERT INTO bcc_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Bahtáwar hamá ent ke Hodáwanday sará tawkala kant o démá gón porkebrénána nakant, gón hamáyán ke drógén hodáyáni randgiriá gomráh ant. ");
INSERT INTO bcc_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Oo Hodáwand, oo mani Hodá! Taw pa má bázén ajabén kár o shawré kortag, hechkas tai matth buta nakant. Agan belóthán tai káráni bárawá jár bejanán o habar bekanán, haminchok báz ant ke cha hesábá dar ant. ");
INSERT INTO bcc_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Tará pa hayrát o korbánigá hájaté nést, bale mani góshet pach kortag, sóchagi korbánig o gonáháni korbániget nalóthetag. ");
INSERT INTO bcc_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","7","Gorhá gwashton: “Man átkag o tayár án, mani bárawá ketábay tumárá nebisag butag. ");
INSERT INTO bcc_vpl VALUES ("PS40_8","020_40_8","PSA","40","8","8","Oo mani Hodá! Armánon tai lóth o wáhagay sarjam kanag ent, tai Sharyat mani delá ent.” ");
INSERT INTO bcc_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","9","Rakkénag o nejátay wasshén hálon mazanén diwáná jár jatag. Oo Hodáwand! Hamá dhawlá ke taw zánay man wati dap lagám najatag. ");
INSERT INTO bcc_vpl VALUES ("PS40_10","020_40_10","PSA","40","10","10","Tai rakkénókén madaton wati delá chér nadátag, tai wapádári o nejátbakshiay bárawá habaron kortag o cha mazanén diwáná tai mehr o wapáon napóshéntag. ");
INSERT INTO bcc_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","11","Oo Hodáwand! Maná cha wati rahmatá zebahr makan, tai mehr o wapá tán abad maná émen bedárát. ");
INSERT INTO bcc_vpl VALUES ("PS40_12","020_40_12","PSA","40","12","12","Chiá ke béhesábén sakkián maná angerr kortag, mayárbárián maná geptag o dista nakanán, cha mani saray mudán gésh ant, mani del kaptag. ");
INSERT INTO bcc_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Oo Hodáwand! Mehrabáni kan o maná berakkén. Hodáwandá! Zutt pa mani madatá byá. ");
INSERT INTO bcc_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Á sajjahén ke mani kóshay randá ant o mani marká lóthant sarjahl o sharmsár bátant, á ke mani syahróchiay padá ant poshtá berawát o roswá bátant. ");
INSERT INTO bcc_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Á ke mani sará “hah, haha” kanant wati sarjahliá hayrán o habakkah bátant. ");
INSERT INTO bcc_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Bale á ke tai shóházá ant sajjahén tai bárgáhá shádehi kanát o gal o bál bátant, á ke tai rakkénókén madatesh dóst ent, modám begwashátant: “Hodáwand maz‌an ent.” ");
INSERT INTO bcc_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Man garib o hájatmand án, Hodáwandá mani hayál gwar bát. Taw mani komak o rakkénók ay. Oo mani Hodá! Dér makan. ");
INSERT INTO bcc_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Bahtáwar hamá ent ke garib o bazzagáni hayálá ent, Hodáwand áiá baláh o mosibatáni róchá rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Hodáwand áiay negahpániá kant o zendaga dárit, á, molkay tahá bahtáwara bit. Taw áiá dozhmenáni wáhagáni sará yalaha nakanay. ");
INSERT INTO bcc_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Hodáwand áiá nádráhiay wahdá zór o wáka dant, cha nájórhi o kamzórián áiá dráha kant. ");
INSERT INTO bcc_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Man gwasht: “Oo Hodáwand! Mani sará rahm kan, maná dráh kan ke tai gonahkár án.” ");
INSERT INTO bcc_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Dozhmen pa badwáhi mani bárawá gwashant: “Kadéna merit o námi gára bit?” ");
INSERT INTO bcc_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Wahdé cha áyán yakké mani didárá kayt dozobáni habara kant o delá badia ródénit, dhanná ke dara kapit, wati delay habará kant. ");
INSERT INTO bcc_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Sajjahén dozhmen mani helápá halwat o soksoka kanant o pa mani táwán dayagá pandala sázant. ");
INSERT INTO bcc_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Gwashant: “Sellén nádráhiéá geptag, cha waptagén jáhá hechbar pád átka nakant.” ");
INSERT INTO bcc_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Tantaná mani nazzikén dóst ke cha áiá deljam atán, hamá ke gón man hamkásag at, áiá ham maná dróhetag. ");
INSERT INTO bcc_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Bale taw, oo Hodáwand! Mani sará rahm kan, maná pád kan tán wati jostánesh bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Cha eshiá zánán ke cha man washnód ay, ke dozhmen mani sará báládast nabutagant. ");
INSERT INTO bcc_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Cha mani tachki o rástiá, taw mani posht o panáh butagay o modám wati bárgáhá jágaha dayay. ");
INSERT INTO bcc_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Hodáwandá satá bát, Esráilay Hodáyá, cha azal tán abad. Anchosh bát. Ámin. ");
INSERT INTO bcc_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni shayri gwashtánk. Áskay paymá ke pa kawray ápán zahirwár ent, hamé paymá, oo mani Hodá, mani arwáh tai zahirán ent. ");
INSERT INTO bcc_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Mani arwáh pa Hodáyá tonnig ent, pa zend bakshókén Hodáyá, ke bárén kadi Hodáay bárgáhá rawán o áiay démá záhera bán? ");
INSERT INTO bcc_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Shap o róch warákon ars ent, Wahdé mardom modám maná gwashant: “Tai Hodá kojá ent?” ");
INSERT INTO bcc_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Wahdé wati delay dardán darshána kanán, hayálá kapán ke che paymá mazanén mocchiay hamráh atán, jashnay mazanén mocchiay o gón shádehiay kukkár o shogrgozáriay sawtán dém pa Hodáay lógá áyáni rahshón atán. ");
INSERT INTO bcc_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","Oo mani arwáh! Chiá gimmortagay? Chiá mani del o daruná paréshán ay? Óst o omét Hodáay sará bekan, chiá ke nóksará hamáiá názénán, wati rakkénók o ");
INSERT INTO bcc_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","wati Hodáyá. Mani daruná arwáh gimmortag paméshká tará cha Ordonay sardhagár o Hermónay kóhá yáta kanán, cha Misáray kóhá. ");
INSERT INTO bcc_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","Tai mazanén ápsháráni grandá, johlánki, johlánkiá gwánka jant, tai sajjahén chawl o mawj, mani sará proshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Róchá, Hodáwand wati mehrá déma dant o shapá sawt o zémeli gón man ent, dwáé dém pa wati zend bakshókén Hodáyá. ");
INSERT INTO bcc_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Gón Hodáyá ke mani talár ent gwashán: “Chiá maná shamoshtaget? Chiá cha dozhmenay ázárá mótk byárán?” ");
INSERT INTO bcc_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Dozhmenáni shegánán, mani haddh hurt kortagant, chiá ke sajjahén róchá maná gwashant: “Tai Hodá kojá ent?” ");
INSERT INTO bcc_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","Oo mani arwáh! Chiá gimmortagay? Chiá mani del o daruná paréshán ay? Óst o omét Hodáay sará bekan, chiá ke nóksará hamáiá názénán, wati rakkénók o wati Hodáyá. ");
INSERT INTO bcc_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","1","Oo Hodá! Gonáhay bohtámá cha mani sará bethagalén, Hodánábáwarén kawméay démá, pa mani hakká jáh bejan o maná cha badkár o prébkáráni dastá berakkén, ");
INSERT INTO bcc_vpl VALUES ("PS43_2","020_43_2","PSA","43","2","2","chiá ke taw mani kalát ay. Taw parchá maná cha wat dur kortag? Chiá cha dozhmenay ázárá mótk byárán? ");
INSERT INTO bcc_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Wati rozhn o rástiá ráh day, tánke mani rahshón bebant o maná pákén kóhá o tai bárgáhá byárant. ");
INSERT INTO bcc_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Á wahdi Hodáay korbánjáhá rawán, dém pa Hodáyá ke mani wasshi o shádehi ent. Oo Hodá, mani Hodá! Tará gón changá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","Oo mani arwáh! Chiá gimmortagay? Chiá mani del o daruná paréshán ay? Óst o omét Hodáay sará bekan, chiá ke nóksará hamáiá názénán, wati rakkénók o wati Hodá. ");
INSERT INTO bcc_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni shayri gwashtánk. Oo Hodá! Má wati góshán eshkotag, may pet o pirénán gwashtag ke áyáni zamánagá chónén káret kortag, gwastagén dawr o bárigán. ");
INSERT INTO bcc_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Taw gón wati dastá kawm dar kortant, bale may pet o pirén sabz kortant. Kawmet droshtant o may pet o pirén sháhegáni bakshátant. ");
INSERT INTO bcc_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Na áyáni zahmáni zór at ke molkesh gept na ke básk o bázuán sóbén kortant. É tai rástén dast at, tai básk o chehragay rozhn, chiá ke áyáni sará mehrabán atay. ");
INSERT INTO bcc_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Oo Hodá! Taw mani bádsháh ay. Pa Ákubá péróziay hokmá borr. ");
INSERT INTO bcc_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","5","Cha tai némagá ent ke dozhmenán pada kenzénén, cha tai námá ent ke orosh barókán lagatmála kanén. ");
INSERT INTO bcc_vpl VALUES ("PS44_6","020_44_6","PSA","44","6","6","Man wati kamánay sará tawkala nakanán o zahm maná sóbéna nakant. ");
INSERT INTO bcc_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","É taw ay ke márá cha dozhmenán rakkéntag o badwáh sarjahl kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Oo Hodá! Má modám tai sará pahr kortag o tán abad tai námay shográ gerén. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Bale nun taw márá dawr dátag o béezzat kortag, may lashkaray hamráha nabay. ");
INSERT INTO bcc_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Márá dozhmenáni démá pada kenzénay o badwáh márá áwára janant. ");
INSERT INTO bcc_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Márá korbánigén pasáni paymá pa koshagá eshtaget o kawmáni nyámá sheng o sháng kortag. ");
INSERT INTO bcc_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Taw wati kawm arzáná bahá kortag o cha áyáni baháyá sutté nabortag. ");
INSERT INTO bcc_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Márá hamsáhegáni rishkandi kortag o kerr o gwaray mardománi kalági. ");
INSERT INTO bcc_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Taw márá kawmáni nyámá thekk o neshán kortag, darkawm sará chandhénant o maskará kanant. ");
INSERT INTO bcc_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","15","Sajjahén róchá gón sarjahliá dém pa dém án o sharmá mani dém póshetag, ");
INSERT INTO bcc_vpl VALUES ("PS44_16","020_44_16","PSA","44","16","16","cha bad o rad gwashókáni shegáná, cha dozhmen o bérgiray dastá. ");
INSERT INTO bcc_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","É sajjahén may sará átkagant, bale angat má tará nashamoshtag o gón tai ahdá nárást nabutagén. ");
INSERT INTO bcc_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","May del cha taw per natarretag o pád o gám cha tai ráhá dar nabutag. ");
INSERT INTO bcc_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Bale taw márá prósh dátag o gón wahshién haywánán yakjáh kortag, gón tahárterén tahárókiá póshéntag. ");
INSERT INTO bcc_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Agan má wati Hodáay nám beshamoshtén, yá dast pa bigánagén hodáéá borz kortén, ");
INSERT INTO bcc_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","Hodáyá nazántagat? Chiá ke á cha delay ráz o asrárán sarpad ent. ");
INSERT INTO bcc_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Bale má tai sawabá sajjahén róchá gón marká dém pa dém én o korbánigén pasáni paymá hesáb áraga bén. ");
INSERT INTO bcc_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Oo Hodáwand! Ágáh bay. Pa ché wáb ay? Jáh jan o márá tán abad yalah makan. ");
INSERT INTO bcc_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","Chiá wati démá chéra dayay o pa ché may bazzagi o lagatmáliá shamóshay? ");
INSERT INTO bcc_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Chiá ke má háká dém pa chér én o láp zeminá lacchetag. ");
INSERT INTO bcc_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Pád á o may madatá byá, wati mehray sawabá márá bemók o berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS45_1","020_45_1","PSA","45","1","1","Pa sázger o washáwázáni sálárá. “Susanáni” tarzay sará. Kórahay chokkáni shayri gwashtánk. Eshki sawt. Delon cha zébáén gálán sarréch ent, shayré pa bádsháhá gwashán, zobán, zabardastén nebisókéay kalamay paymá ent. ");
INSERT INTO bcc_vpl VALUES ("PS45_2","020_45_2","PSA","45","2","2","Taw ádamiáni nyámá zébáterén ay o cha tai lonthán lál o gawhara gwárit, paméshká Hodáyá tará abadmánén barkaté dátag. ");
INSERT INTO bcc_vpl VALUES ("PS45_3","020_45_3","PSA","45","3","3","Oo tamardén bádsháh! Gón wati shán o shawkatá zahmá lánká band. ");
INSERT INTO bcc_vpl VALUES ("PS45_4","020_45_4","PSA","45","4","4","Gón hamá shawkatá péróziay aspá betáchén, pa rásti, békebri o ensápay dáragá, bell ke rástén dast tará bákamálén kár sój bedant. ");
INSERT INTO bcc_vpl VALUES ("PS45_5","020_45_5","PSA","45","5","5","Tai tir téz ant o bádsháhay dozhmenáni delá nendant, kawm tai pádáni chérá kapant. ");
INSERT INTO bcc_vpl VALUES ("PS45_6","020_45_6","PSA","45","6","6","Oo Hodá! Tai bádsháhi taht modámi o abadmán ent, tai bádsháhi asá, adl o ensápay asá ent. ");
INSERT INTO bcc_vpl VALUES ("PS45_7","020_45_7","PSA","45","7","7","Taw páki o rásti dóst dáshtag o cha badiá naprat kortag, paméshká Hodáyá, tai Hodáyá, tará géshter cha tai hamráhán shádehiay rógen per moshtag. ");
INSERT INTO bcc_vpl VALUES ("PS45_8","020_45_8","PSA","45","8","8","Sajjahén jámaget gón morr o aud o tójá moshtag o washbó butagant. Ájén kasráni tahá simmi sázáni zémel tará shádána kanant. ");
INSERT INTO bcc_vpl VALUES ("PS45_9","020_45_9","PSA","45","9","9","Bádsháháni jenek tai gránázén mehmán ant, tai rástén némagá, malakah gón Opiray teláháni singárá óshtátag. ");
INSERT INTO bcc_vpl VALUES ("PS45_10","020_45_10","PSA","45","10","10","Oo jenek! Beshkon o sharriá delgósh kan, wati kawm o peti lógá shamósh, ");
INSERT INTO bcc_vpl VALUES ("PS45_11","020_45_11","PSA","45","11","11","bell bádsháh tai zébáiay shaydá bebit, áiay démá pa adab bósht ke á tai wájah ent. ");
INSERT INTO bcc_vpl VALUES ("PS45_12","020_45_12","PSA","45","12","12","Suray shahray mardom gón wati thékiá kayt, shahray hastómandén mardom tai razá o washnódiay randá bant. ");
INSERT INTO bcc_vpl VALUES ("PS45_13","020_45_13","PSA","45","13","13","Sháhay jenek wati kasrá sakk zébdár ent, áiay póshák zargwáp ant. ");
INSERT INTO bcc_vpl VALUES ("PS45_14","020_45_14","PSA","45","14","14","Gón pordóchén jámagán bádsháhay kerrá baranti, neshtagén jenek, áiay dazgohár, áiay padá gón ant. ");
INSERT INTO bcc_vpl VALUES ("PS45_15","020_45_15","PSA","45","15","15","Pa shádehi dém dayaga bant o bádsháhi kalátá sara bant. ");
INSERT INTO bcc_vpl VALUES ("PS45_16","020_45_16","PSA","45","16","16","Tai pet o pirokáni jágahá, óbádageta nendant, áyán sajjahén molkay kamásh o mastera kanay. ");
INSERT INTO bcc_vpl VALUES ("PS45_17","020_45_17","PSA","45","17","17","Tai námay yátá nasláni nasl zendaga dárán, paméshká sajjahén kawm tará abad tán abada názénant. ");
INSERT INTO bcc_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. “Alámutay” tarzay sará. Sawté. Hodá may panáhgáh o zór o wák ent, madat kanóké ke sakkiáni wahdá tayár ent. ");
INSERT INTO bcc_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Paméshká natorsén, toré zemin bejombit o kóh daryáay delá bekapant. ");
INSERT INTO bcc_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Toré áiay áp grumbán o kap o gajj bebant o kóh cha áyáni grumbagá belarzant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Kawré hast ke jói Hodáay shahrá shádmána kanant, borzén arshay Hodáay pákén jágahá. ");
INSERT INTO bcc_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Hodá shahray nyámá ent o shahra nasorit, bámgwáhá Hodá madatia kant. ");
INSERT INTO bcc_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Kawm shóresha kanant o hokumat sarshakuna bant, á wati tawárá borza kant o zemin ápa bit. ");
INSERT INTO bcc_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Lashkaráni Hodáwand gón má gón ent, Ákubay Hodá may kalát ent. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Byáét Hodáay kárán bechárét, begendét ke áiá zeminá chónén béráni áwortag. ");
INSERT INTO bcc_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Zeminay chárén kondhán jangán halása kant, kamáná próshit, nayzahá hurt hurta kant o arrábahán ás mána dárit. ");
INSERT INTO bcc_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","“Watá bedárét o bezánét ke man, Hodá án, kawmáni sará hokmrán o jaháná hákem.” ");
INSERT INTO bcc_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Lashkaráni Hodáwand gón má gón ent, Ákubay Hodá may kalát ent. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. Oo sajjahén kawmán! Cháp bejanét. Gón shádmániay borzén sawtán dém pa Hodáyá kukkár kanét. ");
INSERT INTO bcc_vpl VALUES ("PS47_2","020_47_2","PSA","47","2","2","Chiá ke borzén arshay Hodáwand bákamál ent, sajjahén jahánay mazanén bádsháh. ");
INSERT INTO bcc_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Kawmán may chérdasta kant, ráján may pádáni chérá. ");
INSERT INTO bcc_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","May mirásá pa má gechéna kant, wati dóstén Ákubay pahrá. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Hodá shádmániay kukkáráni nyámá borzád shotag, Hodáwand sornáay tawáray nyámá. ");
INSERT INTO bcc_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Gón wati názénkán Hodáyá satá kanét, názénk janét, benázénét, may bádsháhá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Chiá ke Hodá sajjahén jahánay bádsháh ent, áiá gón shayré benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Hodá kawmáni sará bádsháhia kant, á wati pákén tahtá neshtag. ");
INSERT INTO bcc_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Kawmáni sarók o master mocch butagant, gón Ebráhémay Hodáay kawmá yakjáh, chiá ke jahánay sajjahén sardár, Hodáayg ant, á béhesáb maz‌anshán ent. ");
INSERT INTO bcc_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Kórahay chokkáni Zabur. Hodáwand mazan o satáay báz láhek ent, may Hodáay shahray tahá. Áiay pákén kóh, ");
INSERT INTO bcc_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Sahyunay kóh, zébá gón wati borziá, sajjahén jahánay shádehi, shomálay borzterén bolandi, mazanshánén bádsháhay shahr ent. ");
INSERT INTO bcc_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Hodá áiay borján ent, watá mohrén kaláté pajjáréntagi. ");
INSERT INTO bcc_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Bádsháh yakjáh butant o hóriá démá shotant, ");
INSERT INTO bcc_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","bale anchosh ke shahresh dist, hayrán o habakkah mantant o torsáná jestant. ");
INSERT INTO bcc_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Larzagesh delá kapt, dardé trondén chó ke janénéay chellag o zanká. ");
INSERT INTO bcc_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Taw gón ródarátki gwátá Tarshishay bandenay bójig próshtant. ");
INSERT INTO bcc_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Hamá dábá ke eshkotag nun gón wati chammána gendén, lashkaráni Hodáwanday shahray tahá, may Hodáay shahrá ke Hodá tán abad pádária kant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Oo Hodáwand! Tai parasteshgáhay tahá may johlánkén pegr o hayál gón tai mehrá ent. ");
INSERT INTO bcc_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Oo Hodá! Tai námay paymá, tai satá zeminay chárén kondhán sara bit. tai rástén dast adl o rástiá porr ent. ");
INSERT INTO bcc_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Cha tai dadrasiá Yahudáay métag shádmán bátant o Sahyunay kóh shádán. ");
INSERT INTO bcc_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","12","Sahyuná zyárat kanét, áiay chágerdá begardét o borján hesáb kanét, ");
INSERT INTO bcc_vpl VALUES ("PS48_13","020_48_13","PSA","48","13","13","áiay mohrén diwáláni némagá sharriá hayál gwar dayét o sajjahén kalátáni bechárét, tánke gón nókén naslá begwashét ");
INSERT INTO bcc_vpl VALUES ("PS48_14","020_48_14","PSA","48","14","14","ke Hodá hamesh ent, may Hodá, abad tán abad, hamá ent ke tán marká may rahshóna bit. ");
INSERT INTO bcc_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","1","Pa sázger o washáwázáni sálárá, Kórahay chokkáni Zabur. Oo sajjahén kawmán! Beshkonét. Oo jahánay drostigén jahmenendán! Delgósh kanét. ");
INSERT INTO bcc_vpl VALUES ("PS49_2","020_49_2","PSA","49","2","2","Borz o jahlén mardom doén, azgár o nézgár, shomá sajjahén. ");
INSERT INTO bcc_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Mani dap, hekmat bayána kant, delay johlánkén pegr, pahm o zánta bakshit. ");
INSERT INTO bcc_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Góshá dém pa nemunah o batalé tarrénán, wati delay cháchay granchá gón changay sázá pacha kanán. ");
INSERT INTO bcc_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Baláh o sakkiáni róchán chiá betorsán, á wahdá ke rad dayókáni badi maná angerra kant? ");
INSERT INTO bcc_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Áyáni tawkal pa wati zarr o málá ent o wati mazanén hastiay sará pahra kanant. ");
INSERT INTO bcc_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Saddak án ke hechkas wati brátay zendá móketa nakant o áiay hónbaháyá Hodáyá dáta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","8","Chiá ke zenday mókag sakk grán ent o hech kimmaté áiá porr korta nakant ");
INSERT INTO bcc_vpl VALUES ("PS49_9","020_49_9","PSA","49","9","9","tánke ensán namirán bemánit o hechbar kabrá magendit. ");
INSERT INTO bcc_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Chiá ke gendagá én, dáná ham merant o nádán o bésodd ham haláka bant o wati mál o hastiá pa degarána kellant. ");
INSERT INTO bcc_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Kabr áyáni abadmánén lóga bit, nasláni nasl, áyáni menendjáh, harchont ke kallagáná wati námesh per kort. ");
INSERT INTO bcc_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Ádami wati arzesh o hastómandiá namánit, chárpádáni paymá ent ke bérána bant. ");
INSERT INTO bcc_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Esh ent jáheláni ásar, hamáyáni ákebat ke wati habaráni mannók ant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Pasáni paymá dém pa mordagáni jaháná ráh dayaga bant, hamódá ke mark áyáni shopánka bit. Bámgwáhán, nékdel áyáni sará hokmránia kanant o áyáni jesm o ján kabrá pussit, dur cha borzén márhián. ");
INSERT INTO bcc_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Bale Hodáwand mani arwáhá cha mordagáni jaháná mókit o maná wati dastá zurit. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Wahdé shomá gendét kasé hastómanda bit o lógay shawkati gésha bit, matorsét. ");
INSERT INTO bcc_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Chiá ke markay wahdá chizzé gón wata nabárt o shawkati gón áiá kabrá narawt. ");
INSERT INTO bcc_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Tán hastómand ent mardom áiá satá dayant. Harchont ke zendá watá bahtáwar zántagi, ");
INSERT INTO bcc_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","bale wati pet o pirénáni hamráha bit, ke zenday rozhná hechbara nagendant. ");
INSERT INTO bcc_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Ádami wati arzesh o hastómandiay tahá nádán ent, chárpádáni paymá ent ke bérána bant. ");
INSERT INTO bcc_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Asápay Zabur. Hamá porwák, Hodáwandén Hodá habara kant o zeminá gwánka jant, cha ródarátká tán rónendá. ");
INSERT INTO bcc_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Hodá cha Sahyuná ke zébáiay kamál ent, wati nurá drapshána kant. ");
INSERT INTO bcc_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","May Hodá kayt o bétawára nabit, ér barókén ásé démá enti o trondén gwát o lurhé chágerdá. ");
INSERT INTO bcc_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Borzén ásmánán ham gwánka jant o zeminá ham, tánke wati mardománi dadrasiá bekant. ");
INSERT INTO bcc_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","“Hodádóstán mani gwará yakjáh kanét, hamá ke gón korbánig kanagá, gón man ahdesh bastag.” ");
INSERT INTO bcc_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Ásmán áiay adl o rástiá jára janant, chiá ke Hodá wat dádras ent. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","“Oo mani mardomán! Beshkonét ke habara kanán. Oo Esráil! Tai helápá gwáhia dayán. Man Hodá án, shomay Hodá. ");
INSERT INTO bcc_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Pa korbánigi naent ke tará hakkala dayán, tai sóchagi korbánig modám mani chammáni démá ant. ");
INSERT INTO bcc_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Na cha tai lógá gwaské zurán o na pasé cha tai gwáshá. ");
INSERT INTO bcc_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Chiá ke jangalay sajjahén haywán manig ant, hazárán kóháni dalwat. ");
INSERT INTO bcc_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Kóhestagáni sajjahén báli morgán jáha kárán o har ché ke zeminá gardit manig ent. ");
INSERT INTO bcc_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Agan shodig atán tará sahigon nakortagat, chiá ke jahán o harché áiá hast, manig ant. ");
INSERT INTO bcc_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","Gókáni góshtá warán? Pasáni hóná nóshán? ");
INSERT INTO bcc_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Wati shogrgozáriay korbánigá Hodáyá pésh kan o wati kawlá gón borzén arshay Hodáyá purah kan. ");
INSERT INTO bcc_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Sakki o sóriáni róchá maná belóth, man tará nejáta dayán o taw maná shán o shawkata dayay.” ");
INSERT INTO bcc_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","16","Bale Hodá gón badkárá chosha gwashit: “Tará che hakk ent ke mani Sharyatay rahbandáni habará bekanay yá mani ahd o paymánay bárawá chizzé begwashay? ");
INSERT INTO bcc_vpl VALUES ("PS50_17","020_50_17","PSA","50","17","17","Chiá ke cha adab o tálimá bézár ay o mani habará poshtá dawra dayay. ");
INSERT INTO bcc_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Dozzé ke genday, démet róshena bit o gón zenákárán hamráha bay. ");
INSERT INTO bcc_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Dapay lagámá pa badiá yalaha kanay o zobáná pa prébá. ");
INSERT INTO bcc_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Modám wati brátay helápá habara kanay, wati mátay chokkay sará bohtáma janay. ");
INSERT INTO bcc_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Taw é kár kortagant o man hecch nagwasht, hayálet kort ke man tai payméné án. Bale nun tará malámata kanán o tai mayár o gonáhán tai chammáni démá éra kanán. ");
INSERT INTO bcc_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Oo Hodá shamoshtagénán! É habará neshán kanét, agan na, shomárá chondh chondha kanán o kas shomárá rakkénta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Á kas ke shogrgozáriay korbánigá pésha kant hamá maná shán o shawkata dant, pa wat ráhé tayára kant o man áiá hamá nejátá pésha dárán ke cha mani némagá ent.” ");
INSERT INTO bcc_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Pa sázger o washáwázáni sálárá, Dáuday Zabur, wahdé Nátán Nabi, cha Dáud o Batshebahay wapt o wábá rand, áiay kerrá átk. Oo Hodá! Pa wati mehrá bechár o mani sará rahm kan! Cha wati békesásén rahmatán náparmániánon gár kan. ");
INSERT INTO bcc_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Pa sarjami maná cha mayárbárián beshód o cha gonáhánon pák kan! ");
INSERT INTO bcc_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Chiá ke wati náparmániána zánán o mani gonáh modám chammáni démá ent. ");
INSERT INTO bcc_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Man tai helápá, tahná tai helápá gonáh kortag o hamá káron kortag ke tai chammá bad ent. Paméshká, taw ke habara kanay barhakk ay o dádrasiay wahdá béayb ay. ");
INSERT INTO bcc_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Pa rásti man mayárbár pédá butagán o cha hamá wahdá ke mátay lápá kaptán, gonahkár. ");
INSERT INTO bcc_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Nun deljam án ke taw cha mani del o jabiná rástiay lóthók ay o chér o panáhén daruná maná hekmata bakshay. ");
INSERT INTO bcc_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Gón zupáay lambán pákon kan ke pákizaga bán, maná beshód ke cha barpá espéttera bán. ");
INSERT INTO bcc_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Bell ke shádehi o shádmániá beshkonán, bell á haddh ke taw droshtagant gal o bál bebant. ");
INSERT INTO bcc_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Cha mani gonáhán sar gwaz o sajjahén mayárbáriánon gár kan. ");
INSERT INTO bcc_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Oo Hodá! Mani daruná pákén delé bejórhén o mani del o jabiná padá mohrén ruhé byár. ");
INSERT INTO bcc_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Maná cha wati bárgáhá dur maperrén o wati Pákén Ruhá cha man pach mager. ");
INSERT INTO bcc_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Wati dátagén rakkénagay shádehiá padá beday o maná morádigén ruhé bebaksh. ");
INSERT INTO bcc_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Gorhá sarkashén mardomán tai ráhán tálima dayán o gonahkár tai kerrá wátarra kanant. ");
INSERT INTO bcc_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Oo Hodá! Oo mani rakkénókén Hodá! Maná cha hón o kóshay gonáhá berakkén o zobánon tai adl o rástiá názénit. ");
INSERT INTO bcc_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Hodáwandá! Mani lonthán pach kan, tánke mani dap tará satá bekant. ");
INSERT INTO bcc_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Tará pa korbánigá wáhagé nést, agan na, mana áwort, sóchagi korbánig tará washnóda nakant. ");
INSERT INTO bcc_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Hodáay delpasondén korbánig, proshtagén arwáh ent. Oo Hodá! Proshtag o tawbahkárén deléa taw jahla najanay. ");
INSERT INTO bcc_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Pa wati washnódiá bechár o gón Sahyuná mehrabán bay, Urshalimay diwálán padá addh kan. ");
INSERT INTO bcc_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Gorhá cha rást o ádelén korbánigán shádána bay, cha sóchagi korbánigá ke sarjamá sóchaga bit, tai korbánjáhá gwask pésh kanaga bant. ");
INSERT INTO bcc_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","Pa sázger o washáwázáni sálárá, Dáuday shayri gwashtánk, á wahdá ke Edumi Duig, Sháulay kerrá shot o á sahig korti ke “Dáud, Ahimelekay lógá shotag.” Oo porzórén mard! Chiá badiay sará pahra kanay? Hodáay mehr dáemi ent. ");
INSERT INTO bcc_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Oo prébkár! Tai zobán, tabáhi o barbádiay pandalána sázit, almásén tégéay paymá. ");
INSERT INTO bcc_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Tará badi cha nékiá dóster ent o dróg cha rástiá. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Oo prébkárén zobán! Har bérán kanókén habará dósta dáray. ");
INSERT INTO bcc_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Bale Hodá tará abadia próshit. Tará chakápit o cha tai gedáná gwajit o cha zendagénáni zeminá tai risshagá kasshit. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Pahrézkára gendit o torsit, badkáray sará kandit o gwashit: ");
INSERT INTO bcc_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","“Haw! Esh ent á kas ke Hodái wati kalát nakort. Tawkali wati bázén mál o dawlatay sará bast o wati barbád kanagá twáná but.” ");
INSERT INTO bcc_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Bale man zaytunay sabzén drachkéay paymá án, ke Hodáay lógá sabza bit. Mani tawkal Hodáay mehray sará ent abad tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Pa tai kortagén kárán modám tai shográ gerán o Hodádóstáni démá pa tai námá ométwár án, chiá ke tai nám nék ent. ");
INSERT INTO bcc_vpl VALUES ("PS53_1","020_53_1","PSA","53","1","1","Pa sázger o washáwázáni sálárá. “Mahallátay” tarzay sará. Dáuday shayri gwashtánk. Nádán wati delá gwashit: “Hodáé nést.” É palit ant o káresh bazhnák, nékkáré nést. ");
INSERT INTO bcc_vpl VALUES ("PS53_2","020_53_2","PSA","53","2","2","Hodá cha ásmáná bani ádamá chárit tán begendit bárén dánáé hast ke Hodáay shóházá ent. ");
INSERT INTO bcc_vpl VALUES ("PS53_3","020_53_3","PSA","53","3","3","Sajjahénán Hodáay ráh gár dátag, hórigá palit butagant, nékkáré nést, yakké ham nést. ");
INSERT INTO bcc_vpl VALUES ("PS53_4","020_53_4","PSA","53","4","4","Badkár hech sarpada nabant? É mani kawmá anchosha warant ke mardom nagana warant o Hodáyá hech tawára nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS53_5","020_53_5","PSA","53","5","5","Ódá ke hech torsé nést é sakka torsant, chiá ke Hodá shomay angerr kanókáni haddhán sheng o shánga kant, taw eshán sharmendaga kanay, chiá ke Hodáyá á cha wat dawr dátagant. ");
INSERT INTO bcc_vpl VALUES ("PS53_6","020_53_6","PSA","53","6","6","Kasé cha Sahyuná byáyát o Esráilá berakkénát. Wahdé Hodá washbahtiá pa wati kawmá pera tarrénit, Ákub gal o bála bit o Esráil shádehia kant. ");
INSERT INTO bcc_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Pa sázger o washáwázáni sálárá. Gón simmi sázán. Dáuday shayri gwashtánk, hamá wahdá ke Zépay mardom Sháulay kerrá shot o gwashtesh: “Bárén, Dáud watá may nyámá chér dayagá naent?” Oo Hodá! Gón wati námá maná berakkén. gón wati zórá gonáhay bohtámá cha mani sará bethagalén. ");
INSERT INTO bcc_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Hodáyá! Mani dwáyá gósh kan o dapay habarán beshkon. ");
INSERT INTO bcc_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Chiá ke bigánag, mani démá pa dozhmeni pád átkagant o setamger mani kóshay padá ant, hamá ke Hodáyá wati chammáni démá nayárant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Bale haw! Hodá mani komak kanók ent, Hodáwand mani zenday dárók ent. ");
INSERT INTO bcc_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Mani dozhmenáni badi áyáni jenday chakká kapát, wati wapádáriay sawabá, áyán gár kan. ");
INSERT INTO bcc_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","6","Oo Hodáwand! Wati delkasshén korbánigán tará pésha kanán o tai námay shográ gerán, chiá ke nék ent. ");
INSERT INTO bcc_vpl VALUES ("PS54_7","020_54_7","PSA","54","7","7","Parchá ke taw maná cha har sakki o sóriá rakkéntag, mani chamm dozhmenay prósh waragay sháhed butagant. ");
INSERT INTO bcc_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Pa sázger o washáwázáni sálárá. Gón simmi sázán. Dáuday shayri gwashtánk. Oo Hodá! Mani dwáyá beshkon o watá cha mani zári o peryátán chér maday. ");
INSERT INTO bcc_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","2","Mani némagá delgósh kan o passaw day, wati nálag o zangán paréshán án. ");
INSERT INTO bcc_vpl VALUES ("PS55_3","020_55_3","PSA","55","3","3","Cha dozhmenáni tawár o cha badkáráni kukkárán bétágat o hayrán án. Chiá ke náhakká maná ranjénant o gón hezhmé mani dozhmeniá kanant. ");
INSERT INTO bcc_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Del mán sénagá azáb ent o markay torson sará kaptag o ");
INSERT INTO bcc_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","bimm o dehshatá maná chér tarréntag. ");
INSERT INTO bcc_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Gwashán: “Dréchá kapóti bálon per butén, tánke bálon bekortén o árám begepténán, ");
INSERT INTO bcc_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Haw! Dém pa durén jágahána shotán o dasht o gyábánon wati hankéna kort. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Pa eshtápia shotán o jáhé chéra bután, cha lurh o tuppánán dur.” ");
INSERT INTO bcc_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Hodáwandá! Áyáni zobáná anchosh betarrén ke yakdomiá sarpad mabant, chiá ke shahrá jang o chópa gendán. ");
INSERT INTO bcc_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Róch o shap shahray chágerdá diwáláni sará tarragá ant o shahr cha náensápi o petnahá porr ent, ");
INSERT INTO bcc_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","cha harábi o bérániá sarréch ent o setam o repk, cha áiay bázárá dura nabit. ");
INSERT INTO bcc_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","É dozhmené naent ke maná shegána jant, agan na, mana sagget, badwáh naent ke gón pahré mani démá óshtátag, agan na, cha áiá chéra bután. ");
INSERT INTO bcc_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Ji, taw ay mani matth, mani bráhondag o nazzikén dóst, ");
INSERT INTO bcc_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","ke márá wasshén hamráhié hastat hamá wahdá ke gón mazanén mocchié Hodáay lógá gámena jat. ");
INSERT INTO bcc_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Mark áyáni chakká bekapát o zendahgórr bátant, chiá ke badi áyáni lóg o deláni tahá ent. ");
INSERT INTO bcc_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Bale man Hodáyá gwánka janán o Hodáwand maná rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Bégáh o sabáh o némróchá zanga janán o peryáta kanán o á mani tawárá eshkont. ");
INSERT INTO bcc_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Mani jesm o jáná cha hamá jangá ke démá dar átkag pa dráhi o salámatia rakkénit, bell toré bázéné mani démá óshtátag. ");
INSERT INTO bcc_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Hodá ke cha azal wati bádsháhi tahtay sará neshtag, eshkont o sharmendagesha kant. Ósht... Chiá ke badala nabant o Hodátorsiesh nést. ");
INSERT INTO bcc_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Mani bráhondagá wati dast dóstáni helápá shahárt o wati kawli prósht. ");
INSERT INTO bcc_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Zobáni chó thélá charp at bale deli jangig, dapay habari cha rógená narmter, bale kasshetagén zahm atant. ");
INSERT INTO bcc_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Wati paréshánián pa Hodáyá bell, ke á tai dárók ent, á hechbar pahrézkárán kapagá naylit. ");
INSERT INTO bcc_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Bale taw, oo Hodá, badkárán johlterén kallá dawra dayay, hónwár o prébkárén mardom wati rócháni némá ham zendaga namánant, bale man tai sará tawkala kanán. ");
INSERT INTO bcc_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Pa sázger o washáwázáni sálárá. “Bétawár o durdastén kapótay” tarzay sará. Dáuday shayr, hamá wahdá ke Pilistián Dáud Gatay shahrá dazgir kort. Oo Hodá! Mani sará rahm kan, ke dozhmen sakk mani randá ant, sajjahén róchá, mani sará orosha kanant. ");
INSERT INTO bcc_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Sajjahén róchá, dozhmen maná lagatmála kanant, chiá ke bázéné pa kebr mani sará orosha kant. ");
INSERT INTO bcc_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Wahdé maná torsit tai sará tawkala kanán. ");
INSERT INTO bcc_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Hodáay sará, ke áiay habará satá kanán, Hodáay sará tawkala kanán o natorsán, hákién ensán maná ché korta kant? ");
INSERT INTO bcc_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Sajjahén róchá, mani habarán tába dayant o sajjahén honaresh pa mani ázár dayagá ent. ");
INSERT INTO bcc_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Pandala sázant o kamina kanant, mani gámána chárant o mani koshagay randá ant. ");
INSERT INTO bcc_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","Gón é sajjahén badián rakketa kanant? Oo Hodá! Wati hezhmay tahá kawmán sarshakun kan. ");
INSERT INTO bcc_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Taw mani darpadariay hesábána dáray, mani arsán wati arsdáná bekan, é tai ketáb o daptarán nebeshtah naant? ");
INSERT INTO bcc_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Gorhá á wahdá ke tará gwánka janán dozhmen pada kenzant. Eshiá zánán ke Hodá gón man ent. ");
INSERT INTO bcc_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Hamá Hodá ke áiay habará satá kanán, haw, hamá Hodáwand ke áiay habará satá kanán, ");
INSERT INTO bcc_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Hamá Hodáay sará tawkala kanán o natorsán. Ensán maná ché korta kant? ");
INSERT INTO bcc_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","12","Oo Hodá! Báyad ent gón taw wati kortagén kawlán purah bekanán, pa taw shogrgozáriay korbánigán pésha kanán. ");
INSERT INTO bcc_vpl VALUES ("PS56_13","020_56_13","PSA","56","13","13","Chiá ke taw, oo Hodá, maná cha marká rakkénay o mani pádán cha lakoshagá dáray, ke zenday rozhná tai bárgáhá gám bejanán. ");
INSERT INTO bcc_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Dáuday shayr, hamá wahdá ke Dáud cha Sháulá tatk o gáréá chér but. Mani sará rahm kan. Oo Hodá! Mani sará rahm kan, chiá ke mani arwáh tai mayár o báhóth ent. Tai bánzoláni sáhegá panáha zurán, tán hamá wahdá ke é baláh berawt o begwazit. ");
INSERT INTO bcc_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Borzén arshay Hodáay gwará peryáta kanán, hamá Hodá ke gonáhay bohtámá cha mana thagalénit. ");
INSERT INTO bcc_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Cha ásmáná wati komaká ráha dant, maná rakkénit o áyán ke maná lapáshant, pa hakkal adaba kant. Ósht... Hodá wati mehr o wapádáriá rawána kant. ");
INSERT INTO bcc_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Mani arwáh shéráni nyámá ent, ás bon dayókáni nyámá wapsán, hamá mardománi nyámá ke dantánesh tir o nayzah ant o zobánesh tézén zahm. ");
INSERT INTO bcc_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Oo Hodá! Ásmánáni sará bátay, tai shawkat sajjahén zeminá sheng bát. ");
INSERT INTO bcc_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Mani pádáni démá dámesh chér kort o arwáhon sarshakun but. Ráhay sará chátesh kótk, bale wat ódá shakun butant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Oo Hodá! Mani del mohr ent. Mani del mohr ent o sawt o sáza janán. ");
INSERT INTO bcc_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Oo mani arwáh! Ágáh bay. Oo chang o soródán! Ágáh bét. Man bámgwáhá cha wábá páda kanán. ");
INSERT INTO bcc_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Oo Hodáwand! Tará kawmáni nyámá satá kanán o pa taigi kabilaháni nyámá sawta janán. ");
INSERT INTO bcc_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Chiá ke tai mehr báz ent, tán arshá rasit o tai wapádári tán jambarán. ");
INSERT INTO bcc_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Oo Hodá! Ásmánáni sará bátay, tai shawkat sajjahén zeminá sheng bát. ");
INSERT INTO bcc_vpl VALUES ("PS58_1","020_58_1","PSA","58","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Dáuday shayr. Oo hákemán! Shomay bétawári náensápi naent? Mardománi nyámá pa ensáp dádrasia kanét? ");
INSERT INTO bcc_vpl VALUES ("PS58_2","020_58_2","PSA","58","2","2","Enna, wati delá béadlia sázét o shomay dast zeminá petnah páda kanant. ");
INSERT INTO bcc_vpl VALUES ("PS58_3","020_58_3","PSA","58","3","3","Badkárán cha mátay lápá wati ráh gár dátag o cha pédáeshá gomráh o drógband ant. ");
INSERT INTO bcc_vpl VALUES ("PS58_4","020_58_4","PSA","58","4","4","Áyán zahré mán ent chosh ke máray zahrá, syahmáréay dhawlá ant ke góshi bastagant o ");
INSERT INTO bcc_vpl VALUES ("PS58_5","020_58_5","PSA","58","5","5","hech paymá wati démá pa márgeráni áwázá natarrénit, harchont ke ezm o honara kanant. ");
INSERT INTO bcc_vpl VALUES ("PS58_6","020_58_6","PSA","58","6","6","Oo Hodá! Esháni dantánán mán dapá prósh. Hodáwandá! É warnáén shéráni néshén dantánán cha boná dar kan. ");
INSERT INTO bcc_vpl VALUES ("PS58_7","020_58_7","PSA","58","7","7","Tachókén ápáni paymá gár bátant, wahdé kamána kasshant tiresh konth bátant o pad o nesháné maylátant, ");
INSERT INTO bcc_vpl VALUES ("PS58_8","020_58_8","PSA","58","8","8","halazunay paymá ke gón rawagá ápa bit o eshkand butagén chokkay paymá ke hechbar róchay rozhná nagendit. ");
INSERT INTO bcc_vpl VALUES ("PS58_9","020_58_9","PSA","58","9","9","Cha eshiá pésar ke shomay déz konthagáni ásá bemárant, tarr bebant yá hoshk, Hodáesh gár o gomsár kanát. ");
INSERT INTO bcc_vpl VALUES ("PS58_10","020_58_10","PSA","58","10","10","Pahrézkár, bérá ke gendit, shádehia kant, wati pádán mán badkáráni hóná shódit. ");
INSERT INTO bcc_vpl VALUES ("PS58_11","020_58_11","PSA","58","11","11","Mardoma gwashant: “Albat ke pa pahrézkárá mozzé hast, Hodáé hast ke zeminay sará dádrasia kant.” ");
INSERT INTO bcc_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Dáuday shayr, hamá wahdá ke Sháulá pa Dáuday kóshá, lahtén chárug áiay lógá rawán dát. Oo mani Hodá! Maná cha dozhmenán berakkén o cha áyán ke mani helápá jáha janant, mani negahpániá bekan. ");
INSERT INTO bcc_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","2","Maná cha badkárán berakkén o cha hónigán neját beday. ");
INSERT INTO bcc_vpl VALUES ("PS59_3","020_59_3","PSA","59","3","3","Bechár ke che paymá pa mani kóshá kaminesh kortag. Oo Hodáwand! Zórákén mard mani helápá yakjáh butagant, maná hech gonáh o mayáré ham nést. ");
INSERT INTO bcc_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Man hech gonáh o mayáré nakortag, bale é angat mani sará orosh kanagá tayár ant. Pa mani komaká pád á o mani hálá bechár. ");
INSERT INTO bcc_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Oo Hodáwand, oo lashkaráni Hodá! Taw Esráilay Hodá ay, ágáh bay, sajjahén kawmán sezá beday o badkárén dróhókáni sará rahm makan. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Shapá pera tarrant, kochekáni paymá gorrant o shahray chágerdá gardant. ");
INSERT INTO bcc_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Bechár ke cha dapá ché dara kanant, zahmesh dapá ent, gwashant: “Kass eshkonagá naent.” ");
INSERT INTO bcc_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Bale taw, oo Hodáwand, áyáni sará kanday, sajjahén kawmáni sará rishkanda kanay. ");
INSERT INTO bcc_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Oo mani wák o zór! Tai rahchár án, chiá ke taw mani kalát ay, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Hodá pa man mehrabán ent o mani komaká kayt, dozhmenáni sará wati péróziá gendán. ");
INSERT INTO bcc_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Oo Hodáwand ke may espar ay! Áyán makosh, chosh mabit ke mani kawm beshamóshit. Gón wati zórákiá eshán sargardán kan o ér byár. ");
INSERT INTO bcc_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Pa wati dapay gonáh o lontháni habarán wati kebray tahá bandig bebant. Esháni nálat o drógbandiay sawabá, ");
INSERT INTO bcc_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","eshán wati hezhmay tahá gár o gomsár kan, gár o gomsár kan ke hech pasht makapant, tán zánag bebit ke cha Ákubá beger tán zeminay har kondhá Hodá bádsháhia kant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","14","Shapá pera tarrant, kochekáni paymá gorrant o shahray chágerdá gardant. ");
INSERT INTO bcc_vpl VALUES ("PS59_15","020_59_15","PSA","59","15","15","Warákay shóházá sar sar janána bant o agan sér mabant wába nakapant. ");
INSERT INTO bcc_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Bale man tai kodratay tawsipá sawt o sáza janán, sohbá tai mehray satáyá sawta janán o shádehia kanán, chiá ke taw mani borzén kalát ay o sakkiáni wahdá mani panáhgáh. ");
INSERT INTO bcc_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Oo mani wák o twán! Tará názénán. Hodá mani borzén kalát ent, mani Hodá ke gón man mehra kant. ");
INSERT INTO bcc_vpl VALUES ("PS60_1","020_60_1","PSA","60","1","1","Pa sázger o washáwázáni sálárá. “Susanay” tarzay sará. Gwáhié. Pa tálimá Dáuday shayr, hamá wahdá ke Dáudá gón Naharaymay Árámián o Sóbahay Árámián jang kort o hamá wahdá ke Yuáb per tarret o Wáday dashtá cha Edumián dwázdah hazár mardomi kosht. Oo Hodá! Taw márá yalah kortag o may sangar próshtagant, hezhmnák butagay, bale nun gón má wasshán bay. ");
INSERT INTO bcc_vpl VALUES ("PS60_2","020_60_2","PSA","60","2","2","Zeminet jombéntag o tal dátag, taláni beger ke larzagá ent. ");
INSERT INTO bcc_vpl VALUES ("PS60_3","020_60_3","PSA","60","3","3","Wati kawmet gránén jáwarán perréntag, márá madhósh kanókén sharábet wáréntag. ");
INSERT INTO bcc_vpl VALUES ("PS60_4","020_60_4","PSA","60","4","4","Bale angat bayraket pa Hodátorsán borzád kortag tánke yakjáh bebant o cha dozhmenay kamáná berakkant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS60_5","020_60_5","PSA","60","5","5","Gón wati rástén dastá berakkén o passaw beday tán hamá ke tará dóst ant berakkant. ");
INSERT INTO bcc_vpl VALUES ("PS60_6","020_60_6","PSA","60","6","6","Hodáyá cha wati pákiá habar kort: “Shekémá gón shádehi bahra kanán o Sukkótay daragá kesása kanán. ");
INSERT INTO bcc_vpl VALUES ("PS60_7","020_60_7","PSA","60","7","7","Galyád manig ent o Manassi mani, Epráim mani jangi koláh ent, Yahudá bádsháhiay asá o ");
INSERT INTO bcc_vpl VALUES ("PS60_8","020_60_8","PSA","60","8","8","Muáb mani dasshódi trasht, Edumay sará wati swásá chagala dayán o Pilistiahay sará wati péróziay gwánká janán.” ");
INSERT INTO bcc_vpl VALUES ("PS60_9","020_60_9","PSA","60","9","9","Kay maná choshén shahréá kárit ke sangarband ent? Kay maná dém pa Edumá rahshóna bit? ");
INSERT INTO bcc_vpl VALUES ("PS60_10","020_60_10","PSA","60","10","10","Oo Hodá! Taw márá yalah dátag. Oo Hodá! Padá may lashkaráni hamráha nabay. ");
INSERT INTO bcc_vpl VALUES ("PS60_11","020_60_11","PSA","60","11","11","Dozhmenáni démá márá madat kan, chiá ke ensánay madat békár o náhudag ent. ");
INSERT INTO bcc_vpl VALUES ("PS60_12","020_60_12","PSA","60","12","12","Gón Hodáyá sóbéna bén, hamá ent ke may dozhmenán pádmála kant. ");
INSERT INTO bcc_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Pa sázger o washáwázáni sálárá. Gón simi sázán. Dáuday Zabur. Oo Hodá! Mani peryátá beshkon o mani dwáyá gósh dár. ");
INSERT INTO bcc_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","2","Tará cha zeminay godhsará gwánka janán, wahdé delona drahit. Maná dém pa taláréá bar ke cha man borzter ent. ");
INSERT INTO bcc_vpl VALUES ("PS61_3","020_61_3","PSA","61","3","3","Chiá ke taw mani panáhgáh butagay o dozhmenáni démá mohrén borjé. ");
INSERT INTO bcc_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Bell ke tai tambuá tán abad bemánán o tai bánzoláni sáhegá panáh bezurán. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Chiá ke taw, oo Hodá, mani dátagén kawl eshkotagant o wati námay torsetagénáni miráset maná bakshátag. ");
INSERT INTO bcc_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Bádsháhay omray róchán báz kan o áiay sálán, tán sajjahén naslán. ");
INSERT INTO bcc_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Hodáay bárgáhá tán abad sháhi tahtá benendát, wati mehr o wapádáriá áiay negahpán kan. ");
INSERT INTO bcc_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Nun tai námá modám názénán o wati kawlán har róch puraha kanán. ");
INSERT INTO bcc_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Pa sázger o washáwázáni sálárá. “Yedutunay” tarzay sará. Dáuday Zabur. Mani arwáh pa émeni tahná Hodáay rahchár ent, chiá ke mani rakkénag cha hamáiay némagá ent. ");
INSERT INTO bcc_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Mani talár o mani rakkénók tahná hamá ent, mani kalát ent, hechbara nalarzán. ");
INSERT INTO bcc_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","Tán kadén mardéay sará orosha kanét tánke sarjamiá bekoshéti, chosh ke proshtagén diwál o kaptagén shank o pallé? ");
INSERT INTO bcc_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Albat pandala sázant ke áiá cha borzád sarshakun bekanant. Cha dróg bandagá lezzata barant, gón wati dapá barkata dayant, bale delay tahá nálata kanant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Oo mani arwáh! Pa émeni tahná Hodáay rahchár bay, chiá ke mani omét gón hamáiá ent. ");
INSERT INTO bcc_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Mani talár o mani rakkénók tahná hamá ent, mani kalát ent, mana nalarzán. ");
INSERT INTO bcc_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Mani neját o ezzat gón Hodáyá ent, hamá mani mohrén talár ent, mani panáhgáh ent. ");
INSERT INTO bcc_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Oo mardomán! Hodáay sará tawkal kanét o delay hálán hamáiay démá darshán kanét, Hodá may panáhgáh ent. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Pa rásti ke ensán cha daméá géshter naent, bani ádam prébé, agan sháhémá tóresh bekanant hech naant. É sajjahén, yakjáh cha damé géshter naant. ");
INSERT INTO bcc_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Pa zolm o zórá tawkal makanét o pa dozziá omét mabandét, harchont ke shomay mál géshtera bit, pa áiá del mabandét. ");
INSERT INTO bcc_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","11","Hodáyá yak habaré gwashtag o man do eshkotag, ke zór o kodrat Hodáayg ent o ");
INSERT INTO bcc_vpl VALUES ("PS62_12","020_62_12","PSA","62","12","12","mehr o rahm ham taig ent, oo Hodáwand! Taw harkasá áiay kortagén káráni hesábá, mozza dayay. ");
INSERT INTO bcc_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Dáuday Zabur, hamá wahdá ke Yahudáay gyábáná at. Oo Hodá! Mani Hodá taw ay, gón wati sajjahén del o jáná tai shóházá án, arwáhon tai tonnig ent o jesm o jánon tai hodónák, béáp o hoshkén zeminéá. ");
INSERT INTO bcc_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Tai pákén jágahá, maná tai shobén butag, tai shán o kodraton distag, ");
INSERT INTO bcc_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","chiá ke tai mehr cha zendá sharter ent, mani lonth tará názénant. ");
INSERT INTO bcc_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Tán zendag án tará názénán o pa tai námá dastán borza kanán. ");
INSERT INTO bcc_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Arwáhon anchosh séra bit chó ke yakké wasshén waráké bwárt o dapon gón shádmánén lonthán tará názénit. ");
INSERT INTO bcc_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","6","Wati bestaray tahá ham tará yáta kanán o shapáni pásán tai hayálá bán. ");
INSERT INTO bcc_vpl VALUES ("PS63_7","020_63_7","PSA","63","7","7","Tai bánzoláni sáhegá tará názénán, chiá ke taw mani madatkár ay. ");
INSERT INTO bcc_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Arwáhon gón taw bandók ent o rástén dastet mani posht o panáh. ");
INSERT INTO bcc_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Á ke mani koshagay pad o randá ant gár o gomsára bant o zeminay johlánkián éra rawant. ");
INSERT INTO bcc_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Zahmáni dapá tarrant o tólagáni waráka bant. ");
INSERT INTO bcc_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Bale bádsháh Hodáay dargáhá shádehia kant o harkas ke gón Hodáyá sawgenda wárt pahra kant, chiá ke drógbandáni dap chopp o bandaga bit. ");
INSERT INTO bcc_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Oo Hodá! Wahdé nálán o peryáta kanán, mani tawárá beshkon o zendá cha torsnákén dozhmenán berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Maná cha badkáráni pandalán chér day, cha radkáráni áshópá. ");
INSERT INTO bcc_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Chiá ke wati zobáná zahmáni paymá téza kanant o wati tahlén habarán tiray paymá kára bandant ");
INSERT INTO bcc_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","tánke cha wati sangarán bémayárá neshánag bekanant. Anágat o bé torsá áiá tira janant. ");
INSERT INTO bcc_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Radén kárá yakdomiá delbaddhia dayant, habar ke kanant, maksadesh wati dámáni chér kanag ent. Gwashant: “Kayesha gendit?” ");
INSERT INTO bcc_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Náensápiá dalil o honara kanant o gwashant: “Má tamán o kamálén shawré kortag.” Pa rásti ke ensánay del o hayál zánaga nabant. ");
INSERT INTO bcc_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Bale Hodá áyán tira jant o anágat thappiga bant. ");
INSERT INTO bcc_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Á wati jenday zobánay sawabá thagala warant. Harkas ke begenditesh pa áyán sará chandhénit. ");
INSERT INTO bcc_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Sajjahén bani ádama torsant, Hodáay kárá jára janant o áiay kárá pa hósh o sára chárant. ");
INSERT INTO bcc_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Pahrézkár Hodáwanday dargáhá shádehi kanát o áiay dargáhá panáh bezurát. Sajjahén nékdel pahr bekanátant. ");
INSERT INTO bcc_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Sawté. Oo Hodá! Sahyuná satá o saná tai wadárá ent, gón taw may kawl puraha bant. ");
INSERT INTO bcc_vpl VALUES ("PS65_2","020_65_2","PSA","65","2","2","Oo taw ke dwáyána eshkonay! Sajjahén mardom dém pa taw káyant. ");
INSERT INTO bcc_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Á wahdá ke gonáh mani sará lombetant, taw márá bakshet. ");
INSERT INTO bcc_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Bahtáwar hamá ent ke tawi gechéna kanay o wati bárgáhá káray tánke hamódá jahmenend bebit. Cha tai dargáhay nékiá séráp bátén, cha tai parasteshgáhay pákiá. ");
INSERT INTO bcc_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Gón wati bákamálén kárán, márá pa adl o ensáp passawa dayay. Oo may rakkénókén Hodá! Zeminay chár kondh o durdastterén daryáyáni omét gón taw ent. ");
INSERT INTO bcc_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Taw ay ke gón wati zór o wáká kóhet jórhéntagant o watá gón kodratá selahbandet kortag, ");
INSERT INTO bcc_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","daryáyáni gorraget árám kortant, mawjáni tawár o kawmáni áshóp. ");
INSERT INTO bcc_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Zeminay chár kondhá nendók cha tai neshánián hayrán ant, taw shagreb o magrebá parmáay ke shádmániay kukkárá bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Taw zeminay hayáldáriá kanay, áiá ápa dayay o ábáda kanay. Hodáay kawr sarréch ent taw mardomán gandoma bakshay chiá ke tai shawr hamé butag. ");
INSERT INTO bcc_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Taw zeminay palán ápa dayay o dhagárá hamdasta kanay, gón gwáragá narmia kanay o rost o rodómá barkata dayay. ");
INSERT INTO bcc_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Gón wati nékiá sálá tájé sará dayay, tai pádráh ham cha barkatá sarréch ant. ");
INSERT INTO bcc_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Gyábánáni charágáh ábáda bant o kóhán wati srén pa shádmáni bastagant. ");
INSERT INTO bcc_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Dhagárán watá gón ramagán póshéntag o daragán gón gandomá, shádmániay kukkárá borza kanant o sawta janant. ");
INSERT INTO bcc_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Pa sázger o washáwázáni sálárá. Sawté. Zaburé. Oo zeminay sajjahén mardomán! Pa Hodáyá shádehiay gwánká bejanét. ");
INSERT INTO bcc_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Áiay námay mazaniá názénét o áiay shán o shawkatá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Hodáyá begwashét: “Tai kár chenkadar bákamál ant. Tai wák o kodratay mazaniay sawabá dozhmen tai démá háká kapant. ");
INSERT INTO bcc_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Zeminay sajjahén mardom tará sojdaha kanant o tará názénant. Haw! Tai námá sárháyant.” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Byáét o bechárét ke Hodáyá ché kortag, ajabén kár pa bani ádamá. ");
INSERT INTO bcc_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Daryái hoshk kort o Hodáay kawm ódá pád payádaká cha kawrá gwast, áiay bárgáhá shádmáni bekanén. ");
INSERT INTO bcc_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Á gón wati kodratá tán abad bádsháhia kant, chammi gón kawmán ent. Sarkesh áiay helápá pád mayáyant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","8","Oo kawmán! May Hodáyá satá kanét, pa borztawári benázénéti. ");
INSERT INTO bcc_vpl VALUES ("PS66_9","020_66_9","PSA","66","9","9","May zendi rakkéntag o pádi cha thagalagá dáshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Oo Hodá! Chiá ke taw márá chakkásetag, taw márá nograhay paymá palgártag. ");
INSERT INTO bcc_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Taw márá dámá dawr dátag o may gardená mazanén báré eshtag. ");
INSERT INTO bcc_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Cha tai razáyá mardomán márá sarjamiá lagatmál kortag, cha áp o ásá gwastagén, bale márá sarsabzén jáhéá áwortaget. ");
INSERT INTO bcc_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","13","Gón sóchagi korbánigán tai dargáhá káyán o gón taw wati kawlán puraha kanán, ");
INSERT INTO bcc_vpl VALUES ("PS66_14","020_66_14","PSA","66","14","14","hamá kawl ke lonthán wádah dátag o dapá gwashtagant sakki o sóriáni wahdá. ");
INSERT INTO bcc_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Pazzórén dalwatán sóchagi korbániga kanán, gón gwarándháni korbánigay duttán, pa taw pas o gók nadra kanán. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Oo sajjahén Hodátorsán! Byáét o beshkonét, hamá chizzána gwashán ke pa man kortaganti. ");
INSERT INTO bcc_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Gón wati dapá áiay kerrá peryáton kortag, áiay satá o saná mani zobáná at. ");
INSERT INTO bcc_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Agan badié mani delá butén Hodáwandá mani habar gósh nadáshtagat. ");
INSERT INTO bcc_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Bale Hodáyá pa rásti eshkotag o mani dwáay tawári gósh dáshtag. ");
INSERT INTO bcc_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Hodáyá satá bát ke cha mani dwáyá nádelgósh nabutag o wati mehri cha man dur nadáshtag. ");
INSERT INTO bcc_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","1","Pa sázger o washáwázáni sálárá. Pa simmi sázán. Zaburé. Sawté. Hodá may sará mehrabán bát, márá barkat bedayát o wati démá pa má drapshán kanát, ósht..., ");
INSERT INTO bcc_vpl VALUES ("PS67_2","020_67_2","PSA","67","2","2","tánke tai ráh jaháná zánag bebit o tai dátagén rakkénag sajjahén kawmáni nyámá. ");
INSERT INTO bcc_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Oo Hodá! Kawm tará satá kanátant, sajjahén kawm tará satá kanátant. ");
INSERT INTO bcc_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Kawm shádehi kanátant o shádmániay gwánká bejanátant, chiá ke taw kawmáni sará pa ensáp dádrasia kanay o jahánay kawmáni rahshóna bay. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Oo Hodá! Kawm tará satá kanátant, sajjahén kawm tará satá kanátant. ");
INSERT INTO bcc_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Zeminá wati bar o samar dátag, Hodá, may Hodá, márá barkat bedayát. ");
INSERT INTO bcc_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","Hodá márá barkat bedayát tánke zeminay chár kondh áiay mazaniá sharap bedayant. ");
INSERT INTO bcc_vpl VALUES ("PS68_1","020_68_1","PSA","68","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Sawté. Hodá jáh bejanát o áiay dozhmen sheng o sháng bátant, á ke cha áiá naprata kanant cha áiay dargáhá betachátant. ");
INSERT INTO bcc_vpl VALUES ("PS68_2","020_68_2","PSA","68","2","2","Anchosh ke dutt bála kant eshán betáchén, anchosh ke móm ásay démá ápa bit, badkár Hodáay dargáhá gár o gomsár bátant. ");
INSERT INTO bcc_vpl VALUES ("PS68_3","020_68_3","PSA","68","3","3","Bale pahrézkár shádmán o Hodáay dargáhá gal o bál bátant o cha wasshiá shádehi kanátant. ");
INSERT INTO bcc_vpl VALUES ("PS68_4","020_68_4","PSA","68","4","4","Pa Hodáyá sawt bejanét o áiay námá názénét, pa áiá ke jambarán swár ent satá o sanáay tawárá borz kanét. Áiay nám Hodáwand ent, áiay bárgáhá shádehi kanét. ");
INSERT INTO bcc_vpl VALUES ("PS68_5","020_68_5","PSA","68","5","5","Hodá wati pákén bárgáhá chórhawáni pet ent o janózámáni dádras. ");
INSERT INTO bcc_vpl VALUES ("PS68_6","020_68_6","PSA","68","6","6","Hodá békasán pa lóg o jáha kant o bandigán, ázát o ábád, bale sarkesh, hoshkén zeminéá nendóka bant. ");
INSERT INTO bcc_vpl VALUES ("PS68_7","020_68_7","PSA","68","7","7","Oo Hodá! Á wahdá ke wati kawmay rahshón atay, á wahdá ke gyábáná mallán atay, ósht..., ");
INSERT INTO bcc_vpl VALUES ("PS68_8","020_68_8","PSA","68","8","8","zemin larzet o ásmánán hawr gwart, Hodáay bárgáhá, Sináay kóhay yakdánagén Hodáay, Hodáay bárgáhá, Esráilay Hodáay. ");
INSERT INTO bcc_vpl VALUES ("PS68_9","020_68_9","PSA","68","9","9","Oo Hodá! Taw bázén hawré gwárént o tai mirás ke hoshk o wayrán butagat, taw séráp kort. ");
INSERT INTO bcc_vpl VALUES ("PS68_10","020_68_10","PSA","68","10","10","Tai ramag ódá jahmenend but. Cha wati nékiá, oo Hodá, taw béwas rózi dátant. ");
INSERT INTO bcc_vpl VALUES ("PS68_11","020_68_11","PSA","68","11","11","Hodáwand wati habará jára jant, bashárat árókén janén, mazanén lashkaré ant. ");
INSERT INTO bcc_vpl VALUES ("PS68_12","020_68_12","PSA","68","12","12","Bádsháh gón wati lashkarána jehant o tachant, janén wati lógá áwárán bahra kanant. ");
INSERT INTO bcc_vpl VALUES ("PS68_13","020_68_13","PSA","68","13","13","Toré gwásh o áhorráni tahá wáb bebay kapódaráni bál nograhpósha bant o potthesh teláh‌rang. ");
INSERT INTO bcc_vpl VALUES ("PS68_14","020_68_14","PSA","68","14","14","Wahdé Porwákén Zórá bádsháh sheng o sháng kortant, barpá Salmunay kóhay sará gwart. ");
INSERT INTO bcc_vpl VALUES ("PS68_15","020_68_15","PSA","68","15","15","Oo mazankóh! Oo Báshánay kóh! Oo bázthollén kóh! Oo Báshánay kóh! ");
INSERT INTO bcc_vpl VALUES ("PS68_16","020_68_16","PSA","68","16","16","Oo bázthollén kóh! Pa ché hamá kóhá gón hasaddé cháragá ay ke Hodáyá pa wati lógjáhá gechén kortag, hamódá ke Hodáwand tán abad jahmenenda bit? ");
INSERT INTO bcc_vpl VALUES ("PS68_17","020_68_17","PSA","68","17","17","Hodáay arrábah hazáráni hazár o lakkáni lakk ant, Hodáwand cha Sináay kóhá wati pákén jágahá átkag. ");
INSERT INTO bcc_vpl VALUES ("PS68_18","020_68_18","PSA","68","18","18","Á wahdá ke arshá borz butay bázén bandigé zortet, cha mardomán thékiet zort, tantaná cha sarkashán ham, tánke taw, oo Hodáwandén Hodá, ódá jahmenend bebay. ");
INSERT INTO bcc_vpl VALUES ("PS68_19","020_68_19","PSA","68","19","19","Hodáwandá satá bát, may rakkénókén Hodáyá ke har róch may bárána saggit. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS68_20","020_68_20","PSA","68","20","20","May Hodá rakkénókén Hodá ent, cha marká rakkénag Hodáwanday dastá ent, tahná Hodáwanday. ");
INSERT INTO bcc_vpl VALUES ("PS68_21","020_68_21","PSA","68","21","21","Bale Hodá dozhmenáni sará próshit, hamáyáni pormudén saray gobbahá próshit ke wati gonáháni tahá gáma janant. ");
INSERT INTO bcc_vpl VALUES ("PS68_22","020_68_22","PSA","68","22","22","Hodáwandá gwashtag: “Áyán cha Básháná pera tarrénán, áyán cha daryáay johlánkián pera tarrénán, ");
INSERT INTO bcc_vpl VALUES ("PS68_23","020_68_23","PSA","68","23","23","tánke tai pád áyáni hóná lagatmál bekanant o tai kochekáni zobán ham wati bahrá cha dozhmenán begerant.” ");
INSERT INTO bcc_vpl VALUES ("PS68_24","020_68_24","PSA","68","24","24","Oo Hodá! Tai jashnay kárwán gendaga bit mani Hodá o mani bádsháhay kárwán mán pákén jágahá. ");
INSERT INTO bcc_vpl VALUES ("PS68_25","020_68_25","PSA","68","25","25","Démá sháer o poshtá sázger o nyámá jenek tamburag janagá ant. ");
INSERT INTO bcc_vpl VALUES ("PS68_26","020_68_26","PSA","68","26","26","Hodáyá mán mazanén diwánán benázénét. Oo Esráilay óbádagán! Hodáwandá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS68_27","020_68_27","PSA","68","27","27","Benyáminay kasánén kabilah hamódá ent, Yahudáay kamásh áyáni hákem ant, Zebulunay kamásh o Naptáliay kamásh, mazanén rombé ant. ");
INSERT INTO bcc_vpl VALUES ("PS68_28","020_68_28","PSA","68","28","28","Tai Hodáay parmán ent ke taw zóráwar bebay. Oo Hodá! Anchosh ke pésará kortaget, wati zór o wáká márá pésh bedár. ");
INSERT INTO bcc_vpl VALUES ("PS68_29","020_68_29","PSA","68","29","29","Pa tai parasteshgáhay háterá ke Urshalimá ent bádsháh pa taw thékia kárant. ");
INSERT INTO bcc_vpl VALUES ("PS68_30","020_68_30","PSA","68","30","30","Kalam o kásháni nyámay rastará hakkal day o kawmáni gwaskáni nyámá gókáni góromá. Rastar érdasta bit o nograha kárit. Jangdóstén kawmán sheng o sháng kan. ");
INSERT INTO bcc_vpl VALUES ("PS68_31","020_68_31","PSA","68","31","31","Kásed cha Mesrá káyant Habashah eshtápiá wati dastán dém pa Hodáyá borzáda kant. ");
INSERT INTO bcc_vpl VALUES ("PS68_32","020_68_32","PSA","68","32","32","Oo jahánay molkán! Pa Hodáyá sawt bejanét, Hodáwandá gón sawtá benázénét, ósht..., ");
INSERT INTO bcc_vpl VALUES ("PS68_33","020_68_33","PSA","68","33","33","hamáiá ke ásmánán shahswária kant, kwahnén ásmánán, hamáiá ke wati áwázá borza kant, trond o porwákén áwázá. ");
INSERT INTO bcc_vpl VALUES ("PS68_34","020_68_34","PSA","68","34","34","Hodáay kodratá jár bejanét, ke shán o shawkati Esráilay sará ent o kodrati, ásmánáni sará. ");
INSERT INTO bcc_vpl VALUES ("PS68_35","020_68_35","PSA","68","35","35","Oo Hodá! Taw wati pákén jágahá bákamál ay, Esráilay Hodá wati kawmá zór o wáka bakshit. Hodáyá satá o saná bát. ");
INSERT INTO bcc_vpl VALUES ("PS69_1","020_69_1","PSA","69","1","1","Pa sázger o washáwázáni sálárá. “Susanáni” tarzay sará. Dáuday Zabur. Oo Hodá! Maná berakkén ke áp tán mani gardená ent. ");
INSERT INTO bcc_vpl VALUES ("PS69_2","020_69_2","PSA","69","2","2","Johlánkén pujgelán mén butagán, jágahé ke páda naóshtit. Johlánkén ápáni tahá kaptagán o hár o lahrhán maná angerr kortag. ");
INSERT INTO bcc_vpl VALUES ("PS69_3","020_69_3","PSA","69","3","3","Cha bázén peryátán damon bortag, mani nokk hoshk ent o chamm wati Hodáay wadárá tahár butagant. ");
INSERT INTO bcc_vpl VALUES ("PS69_4","020_69_4","PSA","69","4","4","Á ke bésawab cha man naprata kanant cha mani saray mudán géshter ant. Bázéné mani gár kanagay randá ent dozhmen mani sará drógén bohtáma janant. Cha man lóthant hamá chizzán per betarrénán ke man nadozzetagant. ");
INSERT INTO bcc_vpl VALUES ("PS69_5","020_69_5","PSA","69","5","5","Oo Hodá! Taw zánay ke man ahmaki kortag, mani gonáh cha taw chér naant. ");
INSERT INTO bcc_vpl VALUES ("PS69_6","020_69_6","PSA","69","6","6","Oo Hodáwand, oo lashkaráni Hodáwand! Hamá ke tai wadárig ant mani sawabá sharmendag mabátant. Oo Esráilay Hodá! Hamá ke tai shóházá ant mani sawabá roswá mabátant. ");
INSERT INTO bcc_vpl VALUES ("PS69_7","020_69_7","PSA","69","7","7","Chiá ke pa taigi maná sobakka kanant o mani dém cha sharmá póshénag butag. ");
INSERT INTO bcc_vpl VALUES ("PS69_8","020_69_8","PSA","69","8","8","Brátáni chammá bigánag butagán o wati mátay chokkáni démá darámadé. ");
INSERT INTO bcc_vpl VALUES ("PS69_9","020_69_9","PSA","69","9","9","Á gayrat ke maná pa Hodáay lógá hastent, maná jánsócha kant o báhénit o tai rad o bad kanókáni rad o bad, mani sará kaptagant. ");
INSERT INTO bcc_vpl VALUES ("PS69_10","020_69_10","PSA","69","10","10","Á wahdá ke arson rétkag o róchagon dáshtag sobakk kanag butagán. ");
INSERT INTO bcc_vpl VALUES ("PS69_11","020_69_11","PSA","69","11","11","Á wahdá ke sugi god o póshákon gwará kortagant, esháni kerrá batalé butagán. ");
INSERT INTO bcc_vpl VALUES ("PS69_12","020_69_12","PSA","69","12","12","Shahray masteráni gwará nám o dap án o sharábiáni sawt. ");
INSERT INTO bcc_vpl VALUES ("PS69_13","020_69_13","PSA","69","13","13","Bale man, oo Hodáwand, tai rahmay wahdá, tai dargáhá dwá kanán. Oo Hodá! Cha wati bázén mehr o wapádáriá, gón deljamén rakkénagé passaw beday. ");
INSERT INTO bcc_vpl VALUES ("PS69_14","020_69_14","PSA","69","14","14","Maná cha pujgelán dar kan, tánke ér maboddhán. Cha naprat kanókáni panjagá maná berakkén o cha johlánkén ápán dar kan. ");
INSERT INTO bcc_vpl VALUES ("PS69_15","020_69_15","PSA","69","15","15","Mayl ke hár maná angerr kanant, yánke johlánki maná ér barant, yá mani sará kall wati dapá bebandit. ");
INSERT INTO bcc_vpl VALUES ("PS69_16","020_69_16","PSA","69","16","16","Oo Hodáwand! Mani passawá beday ke tai rahmat báz ant, wati rahmatáni kesás o hesábá, wati démá gón man betarrén. ");
INSERT INTO bcc_vpl VALUES ("PS69_17","020_69_17","PSA","69","17","17","Démá cha wati hezmatkárá mapóshén, pa mani madatá eshtáp kan ke sakk tang átkagán. ");
INSERT INTO bcc_vpl VALUES ("PS69_18","020_69_18","PSA","69","18","18","Nazzik byá o maná berakkén, dozhmenáni sawabá maná bemók. ");
INSERT INTO bcc_vpl VALUES ("PS69_19","020_69_19","PSA","69","19","19","Taw á sobakkián wata zánay ke mani sará ant o mani sharmsári o roswáián, mani sajjahén dozhmen tai démá ant. ");
INSERT INTO bcc_vpl VALUES ("PS69_20","020_69_20","PSA","69","20","20","Sobakki o béezzatián mani del próshtag o dar mantagán, rahmay wadárá atán o dastá nakapt, gamwáréay shóházá atán o naraset. ");
INSERT INTO bcc_vpl VALUES ("PS69_21","020_69_21","PSA","69","21","21","Warákay badalá, maná jawresh dát o wahdé tonnig bután tropshén sharábesh nóshént. ");
INSERT INTO bcc_vpl VALUES ("PS69_22","020_69_22","PSA","69","22","22","Parzónagesh dámé bát o sohl o émeniesh talké. ");
INSERT INTO bcc_vpl VALUES ("PS69_23","020_69_23","PSA","69","23","23","Chammesh tahár bát o magendátant o srénesh drahag o larzagá bát. ");
INSERT INTO bcc_vpl VALUES ("PS69_24","020_69_24","PSA","69","24","24","Wati hezhmá áyáni sará begwárén, gazabay ácheshá pa áyán berasén. ");
INSERT INTO bcc_vpl VALUES ("PS69_25","020_69_25","PSA","69","25","25","Lóg o jágahesh haráb o wayrán bát, áyáni gedánán hechkas jahmenend mabát. ");
INSERT INTO bcc_vpl VALUES ("PS69_26","020_69_26","PSA","69","26","26","Chiá ke hamáiá ázára rasénant ke taw jatag o hamáiay ranjáni habará kanant ke taw thappig kortag. ");
INSERT INTO bcc_vpl VALUES ("PS69_27","020_69_27","PSA","69","27","27","Mayár pa mayáresh beladdh, cha tai adlá bébahr bátant. ");
INSERT INTO bcc_vpl VALUES ("PS69_28","020_69_28","PSA","69","28","28","Cha zendagénáni daptará gár bátant, gón pahrézkárán yakjáh nebisag mabátant. ");
INSERT INTO bcc_vpl VALUES ("PS69_29","020_69_29","PSA","69","29","29","Bale nun man, setam distag o padard án. Oo Hodá! Tai neját maná émen bedárát. ");
INSERT INTO bcc_vpl VALUES ("PS69_30","020_69_30","PSA","69","30","30","Hodáay námá gón sawta názénán o gón bázén shogrgozáriá shán o shawkatia dayán. ");
INSERT INTO bcc_vpl VALUES ("PS69_31","020_69_31","PSA","69","31","31","É chizz Hodáyá cha gwaskéá géshter pasonda bit, cha mazankánth o mazansrombén gókéá. ");
INSERT INTO bcc_vpl VALUES ("PS69_32","020_69_32","PSA","69","32","32","Békebr o darbésh é chizzá ke begendant gal o shádána bant. Oo Hodáay shóház kanókán! Zendahdel bátét. ");
INSERT INTO bcc_vpl VALUES ("PS69_33","020_69_33","PSA","69","33","33","Hodáwand nyázmandáni dwáyán gósha dárit o wati bandigén mardomán bazzag o wára nakant. ");
INSERT INTO bcc_vpl VALUES ("PS69_34","020_69_34","PSA","69","34","34","Ásmán o zemin áiá benázénant, daryá o áiay tahay sajjahén sahdár. ");
INSERT INTO bcc_vpl VALUES ("PS69_35","020_69_35","PSA","69","35","35","Chiá ke Hodá Sahyuná nejáta dant o Yahudáay shahrán nóksará addha kant. Kawm ódá jahmenenda bit o molkay hakkén wáresa bit. ");
INSERT INTO bcc_vpl VALUES ("PS69_36","020_69_36","PSA","69","36","36","Molk áiay hezmatkáráni poshtpaday mirása bit o áiay námay dóst dárók ódá jahmenenda bant. ");
INSERT INTO bcc_vpl VALUES ("PS70_1","020_70_1","PSA","70","1","1","Pa sázger o washáwázáni sálárá. Dáuday Zabur. Dazbandié. Oo Hodá! Zutt kan o maná berakkén. Oo Hodáwand! Pa mani madatá eshtáp kan. ");
INSERT INTO bcc_vpl VALUES ("PS70_2","020_70_2","PSA","70","2","2","Á ke mani kóshay randá ant, sarjahl o sharmsár bátant, á ke mani barbádiá gala bant, pad bekenzát o roswá bátant. ");
INSERT INTO bcc_vpl VALUES ("PS70_3","020_70_3","PSA","70","3","3","Á ke mani sará “hah, haha” kanant, cha pashaliá poshtoká kenzátant. ");
INSERT INTO bcc_vpl VALUES ("PS70_4","020_70_4","PSA","70","4","4","Bale á ke tai shóházá ant, sajjahén tai dargáhá shádehi kanát o gal o bál bátant, á ke tai dátagén nejátesh dósta bit, modám begwashátant: “Hodáwand mazanshán ent.” ");
INSERT INTO bcc_vpl VALUES ("PS70_5","020_70_5","PSA","70","5","5","Bale man setam distagén mohtájé án. Oo Hodá! Dém pa man eshtáp kan, taw mani rakkénók o madatkár ay. Oo Hodáwand! Dér makan. ");
INSERT INTO bcc_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Oo Hodáwand! Man tai mayár o báhóth án, maná sharmsár makan. ");
INSERT INTO bcc_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Pa wati adlá maná berakkén o bechotthén, delgóshá gón man kan o maná berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Mani panáh dayagay talár bay, ke modám dém pa áiá byáyán. Taw pa mani rakkénagá hokm kortag, chiá ke mani talár o kalát taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","4","Oo mani Hodá maná cha badkáráni dastá berakkén, cha setamger o bérahmáni panjagá. ");
INSERT INTO bcc_vpl VALUES ("PS71_5","020_71_5","PSA","71","5","5","Chiá ke taw, oo Hodáwand, mani omét ay o cha kasániá, oo Hodáwand, óst o ométon tai sará butag. ");
INSERT INTO bcc_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Cha pédáeshá mani komak kanók butagay, é taw butagay ke maná cha mátá pédá kortag, mani satá o sárháyagáni dém modám gón taw ent. ");
INSERT INTO bcc_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Pa bázénéá neshánié butagán, chiá ke taw mani mohrén panáhgáh ay. ");
INSERT INTO bcc_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Dapon cha tai tawsipá porr ent, cha tai shán o shawkatá sajjahén róchá. ");
INSERT INTO bcc_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Piriá maná cha watá dur makan, á wahdá ke twánona kotthit, yalahon makan. ");
INSERT INTO bcc_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Chiá ke dozhmen mani helápá habará ant, á ke mani koshagay randá ant hórigá pandala sázant. ");
INSERT INTO bcc_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Gwashant: “Hodáyá yalah kortag, berawén begeréni, kassia narakkénit.” ");
INSERT INTO bcc_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Oo Hodá! Cha man dur mabay. Oo mani Hodá! Mani madatá eshtáp kan. ");
INSERT INTO bcc_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Mani bohtám janók sharmsár o tabáh bátant o á ke mani ázáray padá ant pashal o sharmendag bátant. ");
INSERT INTO bcc_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Bale man modám tai komakay ométwár án o tará gésh o géshter satá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Tai ádelén káráni habará kanán, sajjahén róchá tai dátagén nejátay járá janán, harchont ke áyáni hesáb cha mani zánagá dhann ent. ");
INSERT INTO bcc_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Mana káyán o Hodáwanday porwákén káráni járá janán, tahná Hodáwanday, tai adlay járá janán, tahná tai. ");
INSERT INTO bcc_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Oo Hodá! Taw maná cha kasániá sój dátag, modám tai ajabén káráni járá janán. ");
INSERT INTO bcc_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Oo Hodá! Nun ke pir án o mud espét ant, maná yalah makan, tán nókén padréchay nyámá tai zóray járá bejanán o sajjahén áyókén naslán cha tai wák o twáná sahig bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Oo Hodá! Tai adl tán borzén arshá ent, taw ay ke mazanén káret kortag. Oo Hodá! Tai matth kay ent? ");
INSERT INTO bcc_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Harchont taw maná bázén sakki o sóri pésh dáshtag, bale padá mani zendá bódénay, Haw, nóksará maná cha zeminay johlánkiá borzáda káray. ");
INSERT INTO bcc_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Mani ezzatá borztera baray maná padá ásudaga kanay. ");
INSERT INTO bcc_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Man tará gón chang o soróda názénán, chiá ke taw wapádár ay, oo mani Hodá! Gón rabábay sázá tará názénán, oo Esráilay Pákén! ");
INSERT INTO bcc_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Mani lonth shádmániay kukkárá kanant, man tará názénán, ke taw maná móketag. ");
INSERT INTO bcc_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Sajjahén róchá tai ádelén káráni zegrá kanán chiá ke á ke mani ázár rasénagay lóthók atant, sarjahl o sharmsár butagant. ");
INSERT INTO bcc_vpl VALUES ("PS72_1","020_72_1","PSA","72","1","1","Solaymánay Zabur. Oo Hodá! Wati adlá bádsháhá bebaksh, wati ensápá bádsháhay chokká, ");
INSERT INTO bcc_vpl VALUES ("PS72_2","020_72_2","PSA","72","2","2","tánke á pa ensáp tai kawmay sará dádrasi bekant, setam distagénáni sará pa adl. ");
INSERT INTO bcc_vpl VALUES ("PS72_3","020_72_3","PSA","72","3","3","Kóh pa kawmá ábádi byárátant, jomp o tomp, pahrézkáriay samará. ");
INSERT INTO bcc_vpl VALUES ("PS72_4","020_72_4","PSA","72","4","4","Bádsháh kawmay setam distagénáni hakká bedayát, mohtájáni chokkán berakkénát o setamgerán tabáh kanát. ");
INSERT INTO bcc_vpl VALUES ("PS72_5","020_72_5","PSA","72","5","5","Nasláni nasl tai sharap o ezzatá bedárátant, tánke rócha drapshit, tánke máh nura dant. ");
INSERT INTO bcc_vpl VALUES ("PS72_6","020_72_6","PSA","72","6","6","Bádsháhay hákemi hamá hawráni paymá bát ke rotagén sabzagáni sará gwárant, hamá hawráni paymá ke zeminá sérápa kanant. ");
INSERT INTO bcc_vpl VALUES ("PS72_7","020_72_7","PSA","72","7","7","Áiay ahdá pahrézkár shádáb bátant, tán hamá wahdá ke máh nura dant ábádi bát. ");
INSERT INTO bcc_vpl VALUES ("PS72_8","020_72_8","PSA","72","8","8","Daryá tán daryá áiay bádsháhi barjáh bát o cha kawrá tán zeminay goddhi simsarán. ");
INSERT INTO bcc_vpl VALUES ("PS72_9","020_72_9","PSA","72","9","9","Áiay dargáhá gyábánay nendók sará jahl bekanátant, áiay dozhmen hák bechatthátant. ");
INSERT INTO bcc_vpl VALUES ("PS72_10","020_72_10","PSA","72","10","10","Tarshish o tayábgwaráni sardhagáray bádsháh hamáiá song o máliát bedayátant, Shébá o Sabáay bádsháh pa áiá théki byárátant. ");
INSERT INTO bcc_vpl VALUES ("PS72_11","020_72_11","PSA","72","11","11","Sajjahén bádsháh, áiay démá sará jahl bekanátant, sajjahén kawm áiay hezmatá bekanátant. ");
INSERT INTO bcc_vpl VALUES ("PS72_12","020_72_12","PSA","72","12","12","Chiá ke á hájatmandán hamá wahdá rakkénit ke peryáta kanant, setam distagénán o hamáyán ke madatkáré néstesh. ");
INSERT INTO bcc_vpl VALUES ("PS72_13","020_72_13","PSA","72","13","13","Nezór o hájatmandáni sará rahma kant o hájatmandáni zendá rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS72_14","020_72_14","PSA","72","14","14","Áyáni zendá cha zolm o sheddatá nejáta dant, áyáni hóná gránkimmata zánt. ");
INSERT INTO bcc_vpl VALUES ("PS72_15","020_72_15","PSA","72","15","15","Omri báz bát, Sabáay teláh áiay peshkash bátant. Mardom modám áiay dwágó bátant o sajjahén róchá pa áiá barkat belóthátant. ");
INSERT INTO bcc_vpl VALUES ("PS72_16","020_72_16","PSA","72","16","16","Gandom sajjahén molká anchosh báz bát ke jompáni sará chawl bejant o bar o samari anchosh báz bát ke Lobnáná ent. Shahrán mardom anchosh ábád bátant ke sabzag mán dhagárán. ");
INSERT INTO bcc_vpl VALUES ("PS72_17","020_72_17","PSA","72","17","17","Bádsháhay nám namirán bát, tán rócha drapshit nám o tawári bemánát. Sajjahén kawm cha áiá barkat begerátant o áiá mobárak begwashátant. ");
INSERT INTO bcc_vpl VALUES ("PS72_18","020_72_18","PSA","72","18","18","Hodáwandén Hodáyá satá bát, Esráilay Hodáyá, ajabén káráni kanók tahná hamá ent. ");
INSERT INTO bcc_vpl VALUES ("PS72_19","020_72_19","PSA","72","19","19","Áiay porshawkatén námá tán abad satá bát, áiay shán o shawkat sajjahén zeminá begerát. Anchosh bát. Ámin. ");
INSERT INTO bcc_vpl VALUES ("PS72_20","020_72_20","PSA","72","20","20","Dáude Yassiay dwá hamedá kotthant. ");
INSERT INTO bcc_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Asápay Zabur. Pa rásti Hodá pa Esráilá mehrabán ent, pa hamáyán ke delesh sáp ent. ");
INSERT INTO bcc_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","2","Bale kammé mantagat bethagalán, nazzik at pád belakoshant. ");
INSERT INTO bcc_vpl VALUES ("PS73_3","020_73_3","PSA","73","3","3","Chiá ke pa porkebrán hasaddi bután, hamá wahdá ke man badkár ábádi o ásudagiá distant. ");
INSERT INTO bcc_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Chiá ke áyán tán marká dardé per nést o wassh o sérláp ant. ");
INSERT INTO bcc_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Á degaráni paymá ranj o zahmatá naant o mardomi baláháni tahá nakapant. ");
INSERT INTO bcc_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Paméshká kebr áyáni gwaray hár ent o hezhm o gazab áyáni póshák. ");
INSERT INTO bcc_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Chammesh cha pazzóriá dar átkagant o delay hayálánesh haddé nést. ");
INSERT INTO bcc_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Pa maskará o badwáhi habara kanant, pa kebr zolm o setamá wati zobáná kárant. ");
INSERT INTO bcc_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Dapá ásmánay helápá pacha kanant o zobánesh sajjahén zeminá gipt. ");
INSERT INTO bcc_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Paméshká kawm dém pa áyána rawt o pa galé hamáyáni dastay ápána wárt. ");
INSERT INTO bcc_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Gwashant: “Hodá che paymá zánt? Borzén arshay Hodáyá é dhawlén zántkári hast?” ");
INSERT INTO bcc_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Haw, badkár chosh ant, modám ásudag ant o mál o melkatesh démá rawán ent. ");
INSERT INTO bcc_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Pa rásti man wati del mopt o náhudagá pák dáshtag o dast mán bégonáhiá shoshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Har róch ázárán kaptagán o har sohbá hakkala warán. ");
INSERT INTO bcc_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Agan begwashténon: “É habarána kanán,” man tai chokkáni nasl dróhetagat. ");
INSERT INTO bcc_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","Wahdé é sajjahén chizzáni zánagay johdon kort, pa man grán at, ");
INSERT INTO bcc_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","tán hamá wahdá ke Hodáay pákén jágahá shotán. Nun é mardománi ákebaton dist. ");
INSERT INTO bcc_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Pa rásti áyán lakoshánkén jáhána perrénay, gár o gomsáriay chátá dawra dayay. ");
INSERT INTO bcc_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Anágat gár o zawála bant, cha torsá sarjamá bérána bant. ");
INSERT INTO bcc_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Wábéay dhawlá ant ke wahdé chamm pacha bant gára bit, á wahdá ke taw páda káay, oo Hodáwand, eshán wahméay paymá mána nayáray. ");
INSERT INTO bcc_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","21","Á wahdá ke mani arwáh zahr o tahl at o del résh, ");
INSERT INTO bcc_vpl VALUES ("PS73_22","020_73_22","PSA","73","22","22","bépahm o nazántkár atán, tai dargáhá haywánéay paymá, cha pahm o póhá dhann. ");
INSERT INTO bcc_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Angat ham modám gón taw án, taw mani rástén dastá geray. ");
INSERT INTO bcc_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Gón wati sar o sóján maná rahshónia kanay o randá gón shán o shawkaté zuray. ");
INSERT INTO bcc_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","Ásmáná, abéd cha taw maná kay hast?! Zeminá ham, abéd cha taw hech chizzé nalóthán. ");
INSERT INTO bcc_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Mani jesm o ján o del balkén zawál bebant, bale Hodá mani delay kalát ent, tán abad mani gisshetagén bahrwandh. ");
INSERT INTO bcc_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Pa rásti á ke cha taw dur ant gár o gomsára bant o hamáyán bérána kanay ke gón taw béwapá ant. ");
INSERT INTO bcc_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Bale pa man wasshi hamesh ent ke Hodáay nazziká bebán, Hodáwandon wati panáhgáh kortag, tán tai sajjahén kárán jár bejanán, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS74_1","020_74_1","PSA","74","1","1","Asápay shayri gwashtánk. Oo Hodá! Chiá márá tán abad yalah dátaget? Pa ché tai hezhmay ás pa tai charágáhay pasán rók ent? ");
INSERT INTO bcc_vpl VALUES ("PS74_2","020_74_2","PSA","74","2","2","Wati kawmay yátá bekap, ke taw cha dérén zamánagán pa bahá zortagatant, ke taw móketagant tán tai kawm o mirás bebant. Sahyunay kóhay hayálá bekap ke ódá jahmenend butagay. ");
INSERT INTO bcc_vpl VALUES ("PS74_3","020_74_3","PSA","74","3","3","Wati gámán dém pa wati hamé modámigén wayránagán betarrén, chiá ke dozhmená har chizz bérán kortag ke tai pákén jágahá butag. ");
INSERT INTO bcc_vpl VALUES ("PS74_4","020_74_4","PSA","74","4","4","Dozhmenán tai didárjáhay tahá gorret o wati bayrak pa neshániá mekk kortant. ");
INSERT INTO bcc_vpl VALUES ("PS74_5","020_74_5","PSA","74","5","5","Hamáyáni paymá atant ke wati taparán jangalay drachkáni sará borza barant. ");
INSERT INTO bcc_vpl VALUES ("PS74_6","020_74_6","PSA","74","6","6","Áyán, tai pákén jágahay sajjahén ájetagén dár gón wati tapar o téshagán prósht o hurt kortant. ");
INSERT INTO bcc_vpl VALUES ("PS74_7","020_74_7","PSA","74","7","7","Tai pákén jágahesh ás kasshet o hák o por kort, tai námay menendjáhesh palit kort. ");
INSERT INTO bcc_vpl VALUES ("PS74_8","020_74_8","PSA","74","8","8","Wati delá gwashtesh: “Áyán sarjamiá wati panjagay chérá kárén,” gorhá Hodáay sajjahén didárjáhesh é sardhagárá sótkant. ");
INSERT INTO bcc_vpl VALUES ("PS74_9","020_74_9","PSA","74","9","9","Nun hech neshánié nagendagá én, hech nabié pasht nakaptag o cha má kass ham nazánt ke tán kadén é paymá bit. ");
INSERT INTO bcc_vpl VALUES ("PS74_10","020_74_10","PSA","74","10","10","Oo Hodá! Tán kadén dozhmen tai sará bekandit? Dozhmen tán abad tai námá bad o rad bekant? ");
INSERT INTO bcc_vpl VALUES ("PS74_11","020_74_11","PSA","74","11","11","Chiá wati dastá poshtá dáray, wati rástén dastá? Dastá pach kan o pa áyán gári o tabáhié byár. ");
INSERT INTO bcc_vpl VALUES ("PS74_12","020_74_12","PSA","74","12","12","Bale Hodá cha dérén zamánagán mani bádsháh ent, ke zeminay sará nejátbakshén kára kant. ");
INSERT INTO bcc_vpl VALUES ("PS74_13","020_74_13","PSA","74","13","13","É taw atay ke daryáet gón wati zór o wáká do ném kort o daryáay baláháni saret ápáni nyámá próshtant, ");
INSERT INTO bcc_vpl VALUES ("PS74_14","020_74_14","PSA","74","14","14","Liwyátánay saret próshtant o gyábánay sahdáráni waráket kort. ");
INSERT INTO bcc_vpl VALUES ("PS74_15","020_74_15","PSA","74","15","15","Jó o sarchammag, taw rombént o rawán kortant, modámigén kawr, taw hoshk kortant. ");
INSERT INTO bcc_vpl VALUES ("PS74_16","020_74_16","PSA","74","16","16","Róch taig ent o shap ham tai máh o róch taw barjáh dáshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS74_17","020_74_17","PSA","74","17","17","É taw atay ke zeminay hand o simsaret gisshéntant, garmág o zemestánay addh kanók taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS74_18","020_74_18","PSA","74","18","18","Oo Hodáwand! Yátá bekap ke dozhmen che paymá maskará kanant o názántén mardom tai námá che paymá bad o rada gwashant. ");
INSERT INTO bcc_vpl VALUES ("PS74_19","020_74_19","PSA","74","19","19","Wati kapótá rastaráni warák makan o setam distagén kawmay zendá tán abad mashamósh. ");
INSERT INTO bcc_vpl VALUES ("PS74_20","020_74_20","PSA","74","20","20","Wati bastagén ahdá bedár, chiá ke é sardhagáray tahárén jágah cha zolm o zóray kodóh o kodámá porr ant. ");
INSERT INTO bcc_vpl VALUES ("PS74_21","020_74_21","PSA","74","21","21","Mayl ke pádmálén mardom gón roswái pad bekenzant, setam distag o hájatmand tai námá satá bekanátant. ");
INSERT INTO bcc_vpl VALUES ("PS74_22","020_74_22","PSA","74","22","22","Oo Hodá! Jáh jan o wati hakkay démpániá bekan, yátá bekap ke názánt sajjahén róchá che paymá tai sará kandant. ");
INSERT INTO bcc_vpl VALUES ("PS74_23","020_74_23","PSA","74","23","23","Wati dozhmenáni kukkárán mashamósh, dozhmenáni shóreshá ke modám borzád ent. ");
INSERT INTO bcc_vpl VALUES ("PS75_1","020_75_1","PSA","75","1","1","Pa sázger o washáwázáni sálárá. “Barbád makanay” tarzay sará. Asápay Zabur. Sawté. Oo Hodá! Tai shográ gerén, tai shográ gerén ke tai nám nazzik ent o mardom tai ajabén káráni habará kanant. ");
INSERT INTO bcc_vpl VALUES ("PS75_2","020_75_2","PSA","75","2","2","Taw gwashay: “Wati gisshéntagén wahdá pa ensáp dádrasia kanán. ");
INSERT INTO bcc_vpl VALUES ("PS75_3","020_75_3","PSA","75","3","3","Hamá wahdá ke zemin o áiay sajjahén nendóka larzant, é man án ke áiay pádagán mohra dárán. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS75_4","020_75_4","PSA","75","4","4","Gón porkebrán gwashán: ‘Pahr mabandét,’ o gón badkárán: ‘Wati kánthán borz makanét. ");
INSERT INTO bcc_vpl VALUES ("PS75_5","020_75_5","PSA","75","5","5","Wati kánthán enkadar borz makanét o pa kebr o gorunáki habar makanét.’” ");
INSERT INTO bcc_vpl VALUES ("PS75_6","020_75_6","PSA","75","6","6","Chiá ke sarperázi na cha ródarátká kayt, na cha rónendá o na cha gyábáná. ");
INSERT INTO bcc_vpl VALUES ("PS75_7","020_75_7","PSA","75","7","7","É Hodá ent ke dádrasia kant, yakkéá éra jant o yakkéá sarborza kant. ");
INSERT INTO bcc_vpl VALUES ("PS75_8","020_75_8","PSA","75","8","8","Chiá ke Hodáay dastá jámé, cha porjóshén sharáb o tahlagá porr ent. Sharábá réchit o zeminay sajjahén badkár áiá tán goddhi trampá warant. ");
INSERT INTO bcc_vpl VALUES ("PS75_9","020_75_9","PSA","75","9","9","Bale man modám Hodáay káráni habará kanán, Ákubay Hodáyá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS75_10","020_75_10","PSA","75","10","10","“Sajjahén badkáráni kánthána próshán, bale pahrézkáráni kánth borz dáraga bant.” ");
INSERT INTO bcc_vpl VALUES ("PS76_1","020_76_1","PSA","76","1","1","Pa sázger o washáwázáni sálárá. Gón simmi sázán. Asápay zabur. Sawté. Yahudiahá Hodá zánag o pajjáh áraga bit, Esráilá áiay nám mazan ent. ");
INSERT INTO bcc_vpl VALUES ("PS76_2","020_76_2","PSA","76","2","2","Áiay tambu Shalimá ent o menendjáh, Sahyuná. ");
INSERT INTO bcc_vpl VALUES ("PS76_3","020_76_3","PSA","76","3","3","Ásgwárén tiri hamódá próshtant, zahm o espar ham, ke jangi seláh ant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS76_4","020_76_4","PSA","76","4","4","Taw drapshán ay o shawkat o shánet, cha á kóhestagán zébáter ent ke shekárá porr ant. ");
INSERT INTO bcc_vpl VALUES ("PS76_5","020_76_5","PSA","76","5","5","Delér áwár janag butant, wati goddhi wábá ant, cha jangáwarán yakké ham namant ke dasté besorénit. ");
INSERT INTO bcc_vpl VALUES ("PS76_6","020_76_6","PSA","76","6","6","Oo Ákubay Hodá! Cha tai neherrán, áyáni arrábah o aspán sar pa markay wábá dát. ");
INSERT INTO bcc_vpl VALUES ("PS76_7","020_76_7","PSA","76","7","7","Taw bákamál ay, wahdé hezhma geray, kay tai démá óshtáta kant? ");
INSERT INTO bcc_vpl VALUES ("PS76_8","020_76_8","PSA","76","8","9","Taw cha ásmáná dádrasia kanay o wahdé taw, oo Hodá, pa dadrasiá jáha janay ke zeminay sajjahén setam distagénán neját bedayay, zemin cha torsá chopp o bétawára bit. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS76_10","020_76_10","PSA","76","10","10","Pa ensáná tai hezhm ham tai satáay sawaba bit o pasht kaptagén hezhmá taw wati lánká banday. ");
INSERT INTO bcc_vpl VALUES ("PS76_11","020_76_11","PSA","76","11","11","Gón wati Hodáwandén Hodáyá kawl bekanét o wati zobánay sará bóshtét, á sajjahén ke kerr o gwarán ant pa hamáiá théki byárant ke bákamál ent. ");
INSERT INTO bcc_vpl VALUES ("PS76_12","020_76_12","PSA","76","12","12","Á hákemáni gorurána próshit, zeminay bádsháh cha áiá torsant. ");
INSERT INTO bcc_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Pa sázger o washáwázáni sálárá. Pa Jedutuná. Asápay Zabur. Man Hodáyá tawára kanán o pa komaká hamáiá gwánka janán, mani peryát gón Hodáyá ent o á mani áwázá gósha dárit. ");
INSERT INTO bcc_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Sakki o sóriáni róchá Hodáwanday shóházá án, sajjahén shapá mani dast dráj ant o dama nabarán, mani arwáh árám geraga nalóthit. ");
INSERT INTO bcc_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Hodáyá yáta kanán o nálán, pegra kanán o delprósha bán. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Taw mani chammán nazz bayagá naylay, paréshán án o habar korta nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Gwastagén wahdáni hayálá kapán, kwahnén ahd o bárigáni. ");
INSERT INTO bcc_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Shapán, wati sawtay hayálá kapán, delá báz pegriga bán o arwáhon josta kant: ");
INSERT INTO bcc_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","“Hodáwand tán abad yalaha kant o padá hechbar mehrabána nabit? ");
INSERT INTO bcc_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","Áiay mehr pa modámi halás butag o kawli pa sajjahén naslán zawál? ");
INSERT INTO bcc_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","Hodáyá mehrabán bayag shamoshtag o wati rahmati hezhmay tahá band kortag?” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Mana gwashán: “É shakk o sawál maná ranjénant. Nun hamá ahd o bárigáni hayálá kapán ke borzén arshay Hodáyá wati rástén dast shahártag.” ");
INSERT INTO bcc_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Oo Hodáwand! Tai kárán yáta kanán, tai ajabén kárán ke taw péshi zamánagán kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Tai kortagén sajjahén káráni bárawá pegra kanán o tai kerdáni hayálá bán. ");
INSERT INTO bcc_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Oo Hodá! Tai ráh pák ent. Kojám hodá may Hodáay paymá mazan buta kant? ");
INSERT INTO bcc_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Taw hamá Hodá ay ke ajabén kára kant. Taw wati zór o wák sajjahén kawmáni nyámá pésh dáshtag, ");
INSERT INTO bcc_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","gón wati básk o kodratá wati kawm rakkéntag, Ákub o Issopay chokk. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Ápán tará dist, oo Hodá! Ápán tará dist o larzetant, johlánki drahagá laggetant. ");
INSERT INTO bcc_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Jambarán ápa gwart o ásmánán grandet, tai grókay tir har némagá retkant. ");
INSERT INTO bcc_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Tai granday tawár danz o gwátáni tahá at, tai nurá jahán róshná kort, zemin larzet o jombet. ");
INSERT INTO bcc_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Tai ráh cha mazanén daryáyá gwast o tai keshk cha mazanén ápán, bale tai pádáni pad gendag nabutant. ");
INSERT INTO bcc_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Taw wati kawm Mussá o Hárunay dastá rahshóni kort, ramagéay paymá. ");
INSERT INTO bcc_vpl VALUES ("PS78_1","020_78_1","PSA","78","1","1","Asápay shayri gwashtánk. Oo mani kawm! Mani sóján gósh dár o delgóshá gón mani habarán kan. ");
INSERT INTO bcc_vpl VALUES ("PS78_2","020_78_2","PSA","78","2","2","Wati dapá pa batal pacha kanán o kwahnén chách o chistánán máná kanán, ");
INSERT INTO bcc_vpl VALUES ("PS78_3","020_78_3","PSA","78","3","3","hamá ke má eshkotag o zántagant, hamá ke may pirénán márá gwashtagant. ");
INSERT INTO bcc_vpl VALUES ("PS78_4","020_78_4","PSA","78","4","4","Eshán cha áyáni chokk o nomásagán chéra nadayén, gón áyókén naslá Hodáwanday porshawkatén káráni kessahá kárén, Hodáwanday zór o twánay kessahá kárén o áiay kortagén ajabén mójezaháni kessahá. ");
INSERT INTO bcc_vpl VALUES ("PS78_5","020_78_5","PSA","78","5","5","Áiá gwáhié pa Ákubá esht, Sharyati pa Esráilá áwort o may pet o piréni parmán dátant ke eshán wati chokk o nomásagán sarpad bekanét, ");
INSERT INTO bcc_vpl VALUES ("PS78_6","020_78_6","PSA","78","6","6","tán démi naslesh bezánant o hamá chokk ham ke angat pédá nabutagant, wati wahdá, gón wati chokk o nomásagán esháni kessahá bekanant, ");
INSERT INTO bcc_vpl VALUES ("PS78_7","020_78_7","PSA","78","7","7","tánke á ham Hodáay sará tawkal bekanant o Hodáay kárán mashamóshant o áiay hokmán bemannant. ");
INSERT INTO bcc_vpl VALUES ("PS78_8","020_78_8","PSA","78","8","8","Wati pet o pirénáni paymá mabant, sarkash o mánmayátk ke delesh gón Hodáyá nabast o arwáhesh gón Hodáyá wapádár naat. ");
INSERT INTO bcc_vpl VALUES ("PS78_9","020_78_9","PSA","78","9","9","Epráimi, harchont ke gón kamánán selahband atant, bale janagay róchá tatkant. ");
INSERT INTO bcc_vpl VALUES ("PS78_10","020_78_10","PSA","78","10","10","Áyán Hodáay ahd nadásht o wati delá shawresh kort ke “áiay Sharyatay sará zenda nagwázénén.” ");
INSERT INTO bcc_vpl VALUES ("PS78_11","020_78_11","PSA","78","11","11","Áiay kortagén káresh shamoshtant, hamá ajabén kár ke áyáná péshi dáshtagatant, ");
INSERT INTO bcc_vpl VALUES ("PS78_12","020_78_12","PSA","78","12","12","Hamá kár ke áyáni pet o pirénáni démá kortagatanti, Mesray molká, Zohánay gyábáná. ");
INSERT INTO bcc_vpl VALUES ("PS78_13","020_78_13","PSA","78","13","13","Áyáni démay daryái ném kort o ái gwázéntant, ápi, doén démán chó diwálá mekk kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_14","020_78_14","PSA","78","14","14","Róchá, gón jambará rashónii dátant o shapá gón ásay rozhná. ");
INSERT INTO bcc_vpl VALUES ("PS78_15","020_78_15","PSA","78","15","15","Gyábáná, talári tal kortant o áyáná, johlén zeréay kesásá ápi dát. ");
INSERT INTO bcc_vpl VALUES ("PS78_16","020_78_16","PSA","78","16","16","Cha talárán chammagi bótkant o ápi chó kawrá rombént. ");
INSERT INTO bcc_vpl VALUES ("PS78_17","020_78_17","PSA","78","17","17","Bale áyán angat géshter gonáh kort o gyábáná borzén arshay Hodáay helápá shóreshesh kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_18","020_78_18","PSA","78","18","18","Hodáesh pa zánt hamá warákáni sará chakkáset ke áyáni delá lóthet. ");
INSERT INTO bcc_vpl VALUES ("PS78_19","020_78_19","PSA","78","19","19","Hodáay helápá habaresh kort o gwashtesh: “Hodá é gyábáná parzónagé pach korta kant? ");
INSERT INTO bcc_vpl VALUES ("PS78_20","020_78_20","PSA","78","20","20","Talári wa jat o cha áiá áp rawán but o kawr sar rechán butant, bale wati mardomán nán ham dáta kant? Yá pa wati kawmá gósht ham tayár korta kant?” ");
INSERT INTO bcc_vpl VALUES ("PS78_21","020_78_21","PSA","78","21","21","Hodáyá ke eshkot, zahr gept, ásé pa Ákubá róki kort, hezhmi pa Esráilá chest but. ");
INSERT INTO bcc_vpl VALUES ("PS78_22","020_78_22","PSA","78","22","22","Chiá ke Hodáay sará imánesh néstat o báwaresh nabut ke Hodáesha rakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS78_23","020_78_23","PSA","78","23","23","Ásmáni pa pach bayagá parmán dát o arshay darwázagi pach kortant. ");
INSERT INTO bcc_vpl VALUES ("PS78_24","020_78_24","PSA","78","24","24","Manni pa áyán chó hawrá gwart ke bwarant, ásmáni gandomi bakshátant. ");
INSERT INTO bcc_vpl VALUES ("PS78_25","020_78_25","PSA","78","25","25","Mardomán préshtagi warák wárt, pa áyán békesás waráki rawán dát. ");
INSERT INTO bcc_vpl VALUES ("PS78_26","020_78_26","PSA","78","26","26","Cha ásmáná ródarátki gwáti sar dát o gón wati zórá jonubi gwáti chest kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_27","020_78_27","PSA","78","27","27","Danzáni paymá pa áyán góshti gwárént, daryáay rékáni kesásá, báli morg, ");
INSERT INTO bcc_vpl VALUES ("PS78_28","020_78_28","PSA","78","28","28","áyáni ordgáhá éri áwortant, áyáni gedánáni kerr o gwarán. ");
INSERT INTO bcc_vpl VALUES ("PS78_29","020_78_29","PSA","78","29","29","Wárt o séresh kort, pa har chizzá ke áyán hers at, dátanti. ");
INSERT INTO bcc_vpl VALUES ("PS78_30","020_78_30","PSA","78","30","30","Bale cha áyáni hersay purah bayagá pésar, ke warákesh angat dapá at, ");
INSERT INTO bcc_vpl VALUES ("PS78_31","020_78_31","PSA","78","31","31","Hodáay hezhm áyáni sará pád átk, áyáni zórmandterén mardomi koshtant o Esráilay warnái jokkéntant. ");
INSERT INTO bcc_vpl VALUES ("PS78_32","020_78_32","PSA","78","32","32","É sajjahén káresh distant o angat ham gonáhesha kort o áiay ajabén káráni sará báwaresha nakort. ");
INSERT INTO bcc_vpl VALUES ("PS78_33","020_78_33","PSA","78","33","33","Gorhá áyáni róchi pa náhudagi halás kortant o sál pa tors. ");
INSERT INTO bcc_vpl VALUES ("PS78_34","020_78_34","PSA","78","34","34","Hodáyá ke áyáni koshag bendát kort, nun áiay shóházá dar kaptant. Dém pa Hodáyá per tarretant o pa setk o del Hodáay shóházá butant. ");
INSERT INTO bcc_vpl VALUES ("PS78_35","020_78_35","PSA","78","35","35","Hayálá kaptant ke Hodá áyáni talár ent, hamá borzén arshay Hodá, áyáni posht o panáh. ");
INSERT INTO bcc_vpl VALUES ("PS78_36","020_78_36","PSA","78","36","36","Bale gón wati dapá, gón áiá charpzobániesha kort o gón zobáná drógesha bast. ");
INSERT INTO bcc_vpl VALUES ("PS78_37","020_78_37","PSA","78","37","37","Delesh gón áiá wapádár naat o áiay bastagén ahdesh nadásht. ");
INSERT INTO bcc_vpl VALUES ("PS78_38","020_78_38","PSA","78","38","38","Bale á angat mehrabán at o áyáni gonáhi bakshetant o sajjahéni nakoshtant. Rand pa randá wati hezhmia dásht o wati sajjahén gazabi darshána nakort. ");
INSERT INTO bcc_vpl VALUES ("PS78_39","020_78_39","PSA","78","39","39","Zánti ke é hákién ensán ant, rawókén gwáté ke padá pera natarrit. ");
INSERT INTO bcc_vpl VALUES ("PS78_40","020_78_40","PSA","78","40","40","Gyábáná chinchok randá cha Hodáyá sarkashiesh kort, ódá áesh gamig kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_41","020_78_41","PSA","78","41","41","Rand pa randá Hodáesh chakkáset, Esráilay pákénesh ázár dát. ");
INSERT INTO bcc_vpl VALUES ("PS78_42","020_78_42","PSA","78","42","42","Áiay dastay zóresh yát nakort ke á róchá chón cha dozhmenáni dastá rakkéntanti, ");
INSERT INTO bcc_vpl VALUES ("PS78_43","020_78_43","PSA","78","43","43","hamá wahdá ke Mesrá wati neshánii paddar kortant o Zohánay gyábáná ajabén kári kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_44","020_78_44","PSA","78","44","44","Áyáni kawri hóná badal kortant ke kassá cha wati jóán áp wárta nakort. ");
INSERT INTO bcc_vpl VALUES ("PS78_45","020_78_45","PSA","78","45","45","Makeskáni rombi áyáni nyámá ráh dátant ke makeskesh bwarant o pogoláni romb, ke barbádesh bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS78_46","020_78_46","PSA","78","46","46","Áyáni keshári madagáná dátant o bar o samar kathagán wártant. ");
INSERT INTO bcc_vpl VALUES ("PS78_47","020_78_47","PSA","78","47","47","Áyáni anguri gón tróngalá zawál kortant o enjiráni drachk, gón hár o tuppánán. ");
INSERT INTO bcc_vpl VALUES ("PS78_48","020_78_48","PSA","78","48","48","Áyáni ramagi pa tróngal koshtant o dalwat, pa grand o grók. ");
INSERT INTO bcc_vpl VALUES ("PS78_49","020_78_49","PSA","78","49","49","Wati sóchókén kahr o gazabi áyáni sará rawán dát, kahr o gazab o azáb, gár o gomsár kanókén préshtagáni thólié áyáni sará. ");
INSERT INTO bcc_vpl VALUES ("PS78_50","020_78_50","PSA","78","50","50","Ráhi pa wati hezhmá rást o tachk kort, cha marká narakkéntanti, wabáyáni dapái dátant. ");
INSERT INTO bcc_vpl VALUES ("PS78_51","020_78_51","PSA","78","51","51","Mesray sajjahén awali chokki jatant, Mesray gedánnendáni mardánagiay awali bar o samar. ");
INSERT INTO bcc_vpl VALUES ("PS78_52","020_78_52","PSA","78","52","52","Bale wati mardomi ramagay paymá sar dát o bortant, pasáni dhawlá gyábánán rashónii kortant. ");
INSERT INTO bcc_vpl VALUES ("PS78_53","020_78_53","PSA","78","53","53","Ái pa émeni rahshóni kortant ke matorsant bale áyáni dozhmen daryáyá mán patátant. ");
INSERT INTO bcc_vpl VALUES ("PS78_54","020_78_54","PSA","78","54","54","Gorhá ái wati pákén zeminá sar kortant, hamá kóhestagén molká ke gón wati rástén dastá geptagati. ");
INSERT INTO bcc_vpl VALUES ("PS78_55","020_78_55","PSA","78","55","55","Áyáni démá kawmi cha ódá dar kortant, kawmáni zemini áyáni mirás kortant o Esráilay kabilahi gedánáni tahá jahmenend kortant. ");
INSERT INTO bcc_vpl VALUES ("PS78_56","020_78_56","PSA","78","56","56","Bale angat áyán borzén arshay Hodá chakkáset o áiay helápá sarkashiesha kort, áiay hokmesha namannet. ");
INSERT INTO bcc_vpl VALUES ("PS78_57","020_78_57","PSA","78","57","57","Wati pirénáni paymá rástén ráhesh yalaha dát o béwapá butant, chó sost o nábáwarén kamáná mantant. ");
INSERT INTO bcc_vpl VALUES ("PS78_58","020_78_58","PSA","78","58","58","Borzén jáhán bothánahesha bast o Hodáesh zahra baráént, botesha jórhént o Hodáesh hasaddiga kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_59","020_78_59","PSA","78","59","59","Hodáyá ke dist, sakk hezhm gept o Esráili sarjamiá yalah kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_60","020_78_60","PSA","78","60","60","Wati Shiluhay menendjáhi yalah kort, hamá tambu ke Hodá ódá mardománi nyámá jahmenend at. ");
INSERT INTO bcc_vpl VALUES ("PS78_61","020_78_61","PSA","78","61","61","Wati zór o wákay pétii bandig kanáént, wati shán o shawkatay neshánii dozhmenáni dastá dát. ");
INSERT INTO bcc_vpl VALUES ("PS78_62","020_78_62","PSA","78","62","62","Wati kawmi zahmáni dapá dát, wati mirásay sará sakk hezhmnák but. ");
INSERT INTO bcc_vpl VALUES ("PS78_63","020_78_63","PSA","78","63","63","Warnáén bachak, ásá wártant o jenek, pa suri názénkán sar nabutant. ");
INSERT INTO bcc_vpl VALUES ("PS78_64","020_78_64","PSA","78","64","64","Dini péshwá zahmáni dapá kaptant o janózámán gréta nakort. ");
INSERT INTO bcc_vpl VALUES ("PS78_65","020_78_65","PSA","78","65","65","Nun Hodáyá anchosh jáh jat ke yakké cha wábá bosta kant, chó ke jangólé cha sharábay béhóshiá jáh bejant. ");
INSERT INTO bcc_vpl VALUES ("PS78_66","020_78_66","PSA","78","66","66","Wati dozhmeni jat o poshtá kenzént o abadi roswáiéá dawr dátant. ");
INSERT INTO bcc_vpl VALUES ("PS78_67","020_78_67","PSA","78","67","67","Bale Issopay tambui nádóst kort o Epráimay kabilahi nazort, ");
INSERT INTO bcc_vpl VALUES ("PS78_68","020_78_68","PSA","78","68","68","Yahudáay kabilahi gechén kort, Sahyunay kóh, ke dóst ati. ");
INSERT INTO bcc_vpl VALUES ("PS78_69","020_78_69","PSA","78","69","69","Wati pákén jágahi, borzagáni paymá addh kort, zeminay paymá namirán, jórhi kort. ");
INSERT INTO bcc_vpl VALUES ("PS78_70","020_78_70","PSA","78","70","70","Wati hezmatkárén Dáudi gechén kort o cha pasáni gwáshá dari kort, ");
INSERT INTO bcc_vpl VALUES ("PS78_71","020_78_71","PSA","78","71","71","cha edá o rand, ái cha mésháni shopánkiá dar kort o wati kawm, Ákubay shopánki kort, wati mirás, Esráilay. ");
INSERT INTO bcc_vpl VALUES ("PS78_72","020_78_72","PSA","78","72","72","Dáudá gón sápén delé áyáni shopánki kort o gón honarmandén dasté áyáni rahshón but. ");
INSERT INTO bcc_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Asápay Zabur. Oo Hodá! Kawmán tai mirás geptag, tai pákén parasteshgáhesh palit kortag o Urshalim, wayrán. ");
INSERT INTO bcc_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Tai hezmatkáráni jónesh báli morgáni warák kortag o tai wapádáráni jánay gósht, rastaráni. ");
INSERT INTO bcc_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Esháni hónesh ápay paymá sajjahén Urshalimá rétkag, kass namant ke mordagán kabr bekant. ");
INSERT INTO bcc_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Hamsáhegáni démá roswá butagén o kash o kerray mardománi kalági. ");
INSERT INTO bcc_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Oo Hodáwand! Tán kadén zahra bay? Tán abad? Tán kadén tai hasadd ásay paymá róka bit? ");
INSERT INTO bcc_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","6","Wati gazabá hamá kawmáni sará begwár ke tará pajjáha nayárant o hamá molkáni sará ke tai námá nagerant, ");
INSERT INTO bcc_vpl VALUES ("PS79_7","020_79_7","PSA","79","7","7","ke Ákubesh wártag o ér bortag o áiay molkesh wayrán kortag. ");
INSERT INTO bcc_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Gwastagén nasláni gonáhán may sará maladdh, tai rahmat zutt may sará byáyátant ke sakk wár o bazzag én. ");
INSERT INTO bcc_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Oo may rakkénókén Hodá! Márá madat kan, wati námay shán o shawkatay sawabá, pa wati námaygi márá berakkén o may gonáhán bebaksh. ");
INSERT INTO bcc_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Chiá darkawm begwashant: “Esháni Hodá kojá ent?” May chammáni démá kawm begendátant ke taw wati hezmatkáráni retkagén hónáni bérá geray. ");
INSERT INTO bcc_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Bandigáni áh o peryát pa taw sar bátant, gón wati báskay zórá hamáyán berakkén ke koshag bayagá ant. ");
INSERT INTO bcc_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Oo Hodáwand! Cha may hamsáhegán hamá sobakkiáni bérá hapt sari géshter beger ke tai sháná kortagantesh. ");
INSERT INTO bcc_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Gorhá má, tai kawm ke tai charágáhay pas én, tán abad tai shográ gerén, nasláni nasl tará satá kanén. ");
INSERT INTO bcc_vpl VALUES ("PS80_1","020_80_1","PSA","80","1","1","Pa sázger o washáwázáni sálárá, “Susanáni” tarzay sará. Gwáhié. Asápay Zabur. Oo Esráilay shopánk! Gósh dár, taw ke shopánkéay paymá Issopay ramagay rahshón ay. Oo Hodá! Taw ke karrubiáni nyámá bádsháhi tahtá neshtagay, wati nurá tálán kan. ");
INSERT INTO bcc_vpl VALUES ("PS80_2","020_80_2","PSA","80","2","2","Epráim, Benyámin o Manassiay démá, wati wák o tágatá borz kan o pa may rakkénagá byá. ");
INSERT INTO bcc_vpl VALUES ("PS80_3","020_80_3","PSA","80","3","3","Oo Hodá! Gón má wasshán bay wati démá gón má rozhná kan ke má berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS80_4","020_80_4","PSA","80","4","4","Oo Hodáwand! Lashkaráni Hodá! Tán kadén hezhmay ásá wati kawmay dwáyáni sará gwárána bay? ");
INSERT INTO bcc_vpl VALUES ("PS80_5","020_80_5","PSA","80","5","5","Taw áyáná arsay nagan o arsáni sarréchén jám wárént. ");
INSERT INTO bcc_vpl VALUES ("PS80_6","020_80_6","PSA","80","6","6","Taw márá hamsáhegáni démá bannám kortag o dozhmen márá kalága bandant. ");
INSERT INTO bcc_vpl VALUES ("PS80_7","020_80_7","PSA","80","7","7","Oo lashkaráni Hodá! Gón má wasshán bay wati démá gón má rozhná kan ke má berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS80_8","020_80_8","PSA","80","8","8","Taw anguray drachké cha Mesrá gwatk, taw kawm dhanná dar kortant o é drachk kesht. ");
INSERT INTO bcc_vpl VALUES ("PS80_9","020_80_9","PSA","80","9","9","Taw zemin pa áiá práh kort, gorhá risshagi jat o zemini porr kort. ");
INSERT INTO bcc_vpl VALUES ("PS80_10","020_80_10","PSA","80","10","10","Áiay sáhegá kóh póshetant o áiay sháharhán, rostagén gazz. ");
INSERT INTO bcc_vpl VALUES ("PS80_11","020_80_11","PSA","80","11","11","Sháharhi tán Myánzerá o tháli tán Parátay kawrá sar butant. ");
INSERT INTO bcc_vpl VALUES ("PS80_12","020_80_12","PSA","80","12","12","Gorhá taw chiá áiay pall prósht o dawr dát ke hamok rahgwaz áiay barán bechent? ");
INSERT INTO bcc_vpl VALUES ("PS80_13","020_80_13","PSA","80","13","13","Jangali hukk áiá éra barant o dashtay jánwaria warant o séra kanant. ");
INSERT INTO bcc_vpl VALUES ("PS80_14","020_80_14","PSA","80","14","14","Oo lashkaráni Hodá! May gwará per tarr, cha ásmáná delgósh kan o bechár, é anguray delgóshá bedár, ");
INSERT INTO bcc_vpl VALUES ("PS80_15","020_80_15","PSA","80","15","15","hamé anguray ke tai rástén dastá kesht, hamé chokkay ke taw pa wat ródént o zórmand kort. ");
INSERT INTO bcc_vpl VALUES ("PS80_16","020_80_16","PSA","80","16","16","Dozhmenán angur goddhet o ásá dawr dát, é gón tai hakkaléá gár o gomsár bátant. ");
INSERT INTO bcc_vpl VALUES ("PS80_17","020_80_17","PSA","80","17","17","Tai dast hamá marday sará bát ke tai rástén némagá ent, hamá ensánay chokkay sará ke taw pa wat ródént o zórmand kort. ");
INSERT INTO bcc_vpl VALUES ("PS80_18","020_80_18","PSA","80","18","18","Gorhá má wati démá cha taw natarrénén, márá zend bebaksh ke tai námá begerén. ");
INSERT INTO bcc_vpl VALUES ("PS80_19","020_80_19","PSA","80","19","19","Oo Hodáwand, lashkaráni Hodá! Gón má wasshán bay, wati démá gón má rozhná kan ke má berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Pa sázger o washáwázáni sálárá. “Gittitay” tarzay sará. Asápay Zabur. Hodáyá pa shádehi benázénét ke may zór o wák ent, pa Ákubay Hodáyá shádmániay kukkárá borz kanét. ");
INSERT INTO bcc_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Sáz o tamburagá bongéj kanét, washtawárén chang o soródán. ");
INSERT INTO bcc_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Máhay nóká, gwarándhay kánthay tawárá borz kanét, máhay chárdahá, may pákén aidá. ");
INSERT INTO bcc_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","É pa Esráilá hokmé, rahbandé cha Ákubay Hodáay némagá. ");
INSERT INTO bcc_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Wahdé Mesray helápá dar átk kánuné pa Issopá eshti. Man eshkot, nááshnáén zobánéá gwasht: ");
INSERT INTO bcc_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Báron cha áiay kópagá dur kort o dast cha gránén saptá ázát kortant.” ");
INSERT INTO bcc_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Taw sakkiáni sáhatán peryát kort o man tará rakként, man grandán andém atán o tará passaw dát, Meribáay ápáni kerrá tará chakkáseton. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Oo mani kawm! Beshkon ke tará dháha dayán, Oo Esráil! Drégatá taw mani habar gósh bedáshtén. ");
INSERT INTO bcc_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Shomay nyámá darámadén hodáé mabát o bigánagén hodáéay démá sará jahl makanét. ");
INSERT INTO bcc_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Man Hodáwand án, tai Hodá ke tará cha Mesrá dar kort o áwort. Wati dapá sarjamá pach kan, ke man porria kanán. ");
INSERT INTO bcc_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","“Bale kawmá mani habar gósh nadásht o Esráil mani parmánbardár nabut. ");
INSERT INTO bcc_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Gorhá man á yalah dátant ke wati sengén deláni randgiriá bekanant, wati jenday ráh o hayáláni. ");
INSERT INTO bcc_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","13","Drégatá mani kawmá mani habar gósh bedáshtén o Esráil, mani ráhá beshotén. ");
INSERT INTO bcc_vpl VALUES ("PS81_14","020_81_14","PSA","81","14","14","Á wahdá man damáná áyáni dozhmen prósh dátagatant o mani dast áyáni dozhmenáni helápá chest butagat. ");
INSERT INTO bcc_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Hamá ke cha Hodáwandá naprata kanant, dotal o sarjahl butagatant, tán abad anchosh butagat. ");
INSERT INTO bcc_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Bale tará gehterén gandomay warákon dátagat o tará cha talárá dar kortagén bénagá séron kortagat.” ");
INSERT INTO bcc_vpl VALUES ("PS82_1","020_82_1","PSA","82","1","1","Asápay Zabur. Hodá, wati Hodái bárgáhá barjam ent, “hodáyáni” diwáná dádrasia kant. ");
INSERT INTO bcc_vpl VALUES ("PS82_2","020_82_2","PSA","82","2","2","Tán kadén pa náensápi shawra borrét? Tán kadén badkáráni badalá bét? Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS82_3","020_82_3","PSA","82","3","3","Nezór o chórhawáni dadrasiá bekanét o garib o setam distagénáni hakká begerét. ");
INSERT INTO bcc_vpl VALUES ("PS82_4","020_82_4","PSA","82","4","4","Nézgár o hájatmandán berakkénét o cha badkáráni dastá ázát kanét. ");
INSERT INTO bcc_vpl VALUES ("PS82_5","020_82_5","PSA","82","5","5","É “hodá” heccha nazánant o sarpada nabant, taháriá sargardán ant o zeminay sajjahén bonyád larzagá ant. ");
INSERT INTO bcc_vpl VALUES ("PS82_6","020_82_6","PSA","82","6","6","Gwashton: “Shomá ‘hodá’ ét o shomá sajjahén, borzén arshay Hodáay chokk ét, ");
INSERT INTO bcc_vpl VALUES ("PS82_7","020_82_7","PSA","82","7","7","Bale mardománi paymá merét o shahzádagáni paymá sarshakuna bét.” ");
INSERT INTO bcc_vpl VALUES ("PS82_8","020_82_8","PSA","82","8","8","Oo Hodá! Jáh jan o zeminay dadrasiá bekan, ke sajjahén kawm tai mirás ant. ");
INSERT INTO bcc_vpl VALUES ("PS83_1","020_83_1","PSA","83","1","1","Asápay Zabur. Sawté. Oo Hodá! Bétawár mabay, hámósh mabay o hoshká manend, oo Hodá! ");
INSERT INTO bcc_vpl VALUES ("PS83_2","020_83_2","PSA","83","2","2","Bechár ke tai dozhmen che paymá gorrant o cha taw naprat kanókáni sar chón borz ent. ");
INSERT INTO bcc_vpl VALUES ("PS83_3","020_83_3","PSA","83","3","3","Tai kawmay helápá pa cháláki pandala sázant o tai gránkadrénáni helápá shawr o saláha kanant. ");
INSERT INTO bcc_vpl VALUES ("PS83_4","020_83_4","PSA","83","4","4","Gwashant: “Byáét gár o gomsáresha kanén ke kawmé mamánant o Esráilay nám pa yátéá ham pasht makapit.” ");
INSERT INTO bcc_vpl VALUES ("PS83_5","020_83_5","PSA","83","5","5","Pa hamdeli shawresh kortag o tai helápá ahdé bastagesh. ");
INSERT INTO bcc_vpl VALUES ("PS83_6","020_83_6","PSA","83","6","6","Edumi o Esmáili, Muábi o Hágári, ");
INSERT INTO bcc_vpl VALUES ("PS83_7","020_83_7","PSA","83","7","7","Gébáli, Ammuni o Amáliki, Pilisti o Suray nendók, ");
INSERT INTO bcc_vpl VALUES ("PS83_8","020_83_8","PSA","83","8","8","Áshuri ham gón áyán hamráh ant o pa Lutay chokkán báské butagant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS83_9","020_83_9","PSA","83","9","9","Gón áyán hamá paymá bekan ke taw gón Midyáná kort, gón Siserá o Yábiná, Kishunay kawray kerrá, ");
INSERT INTO bcc_vpl VALUES ("PS83_10","020_83_10","PSA","83","10","10","ke Endórá tabáh butant o zeminay kad o samát butant. ");
INSERT INTO bcc_vpl VALUES ("PS83_11","020_83_11","PSA","83","11","11","Esháni sardárán Óréb o Zehébay paymá kan, shahzádagánesh Zebah o Zalmunnáay dhawlá, ");
INSERT INTO bcc_vpl VALUES ("PS83_12","020_83_12","PSA","83","12","12","ke gwashtagatesh: “Byáét Hodáay charágáhán pa zóra gerén.” ");
INSERT INTO bcc_vpl VALUES ("PS83_13","020_83_13","PSA","83","13","13","Oo mani Hodá! Eshán danzéay paymá bál day, chó ke paláré, gwátay démá. ");
INSERT INTO bcc_vpl VALUES ("PS83_14","020_83_14","PSA","83","14","14","Anchosh ke ás jangalá sóchit o kóhán mána dárit, ");
INSERT INTO bcc_vpl VALUES ("PS83_15","020_83_15","PSA","83","15","15","gón wati tuppánán randáesh kap o gón syahgwátán betorsénesh, ");
INSERT INTO bcc_vpl VALUES ("PS83_16","020_83_16","PSA","83","16","16","démáesh cha sharmá syáh kan tánke tai námay shóházá bebant, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS83_17","020_83_17","PSA","83","17","17","Sharmsár bát o abadi torséá kapátant, roswá bát o bemerátant. ");
INSERT INTO bcc_vpl VALUES ("PS83_18","020_83_18","PSA","83","18","18","Bell bezánant ke tai nám Hodáwand ent o tahná taw, oo borzén arshay Hodá, sajjahén zeminay sará hákemia kanay. ");
INSERT INTO bcc_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. “Gittitay” tarzay sará. Oo lashkaráni Hodá! Tai bárgáh chón dóstnák ent. ");
INSERT INTO bcc_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Mani arwáh pa Hodáwanday parasteshgáhay péshjáhán shaydá o hodók ent, mani del o ján pa zendagén Hodáyá pa shádehi kukkára kant. ");
INSERT INTO bcc_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Jengolá ham pa wat lógé dar gétk o pistáná pa wat kodóhé ke wati chureg o chippokán ódá beródénit, tai korbánjáhay nazziká, oo lashkaráni Hodáwand, mani bádsháh o mani Hodá! ");
INSERT INTO bcc_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Bahtáwar ant hamá ke tai bárgáhá jahmenend ant, á modám tará názénant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Chón bahtáwar ant hamá ke wák o zóresh cha tai némagá ent o delesh tai ráhán ent. ");
INSERT INTO bcc_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Á, wahdé cha arsáni daragá gwazant, daragá cha chammagá porra kanant o tákchandhay mósomay hawr ham áiá rahmata póshénit. ");
INSERT INTO bcc_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Cha mohrá mohrter bayána bant tán hamá wahdá ke Sahyuná Hodáay bárgáhá rasant. ");
INSERT INTO bcc_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Oo Hodáwand, lashkaráni Hodá! Mani dwáyá gósh dár, beshkon, oo Ákubay Hodá! Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","May bádsháhá delgósh kan, oo Hodá! Wati rógen per moshtagéná delgósh kan. ");
INSERT INTO bcc_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","10","Tai bárgáhay yak róché gehter ent cha dega jágahéay hazárán róchá, cha badkáráni tambuáni tahá árámén zendéay gwázenagá maná wati Hodáay dargáhay dapá óshtag dóstera bit, ");
INSERT INTO bcc_vpl VALUES ("PS84_11","020_84_11","PSA","84","11","11","ke Hodáwandén Hodá róch o esparé, Hodáwand rahmata bakshit o ezzata dant. Hamá ke zendá pa bémayária gwázénit, Hodáwand sharrén chizzán cha áiá dura nadárit. ");
INSERT INTO bcc_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Oo lashkaráni Hodáwand! Bahtáwar ent hamá ke tai sará tawkala kant. ");
INSERT INTO bcc_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. Oo Hodáwand! Taw wati sardhagárá rahmat gwart o Ákubay gwastagén washbahti padá per tarrént. ");
INSERT INTO bcc_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Taw wati kawmay mayárbári bakshetant o áyáni sajjahén gonáh póshetant. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Taw wati sajjahén gazab poshtá dawr dát o wati hezhmay ás tóst. ");
INSERT INTO bcc_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Oo may rakkénókén Hodá! Gón má wasshán bay o wati gazabá cha má dur kan. ");
INSERT INTO bcc_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","5","Tán abad gón má zahra bay? Wati hezhmá nasláni nasl drájkassha kanay? ");
INSERT INTO bcc_vpl VALUES ("PS85_6","020_85_6","PSA","85","6","6","Márá padá zenda nabakshay ke tai kawm tai bárgáhá shádehi bekant? ");
INSERT INTO bcc_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Oo Hodáwand! Wati mehrá márá pésh bedár o márá hamá rakkénagá bebaksh ke cha tai némagá ent. ");
INSERT INTO bcc_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Har chizz ke Hodáwandén Hodá gwashit, man gósha dárán, chiá ke pa wati kawmá émeniay kawlá dant, pa wati wapádárán, chó mabit ke á ahmakiay ráhá per betarrant. ");
INSERT INTO bcc_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Béshakk, á mardománi rakkénag nazzik ent ke cha Hodáyá torsant, tán may sardhagár cha áiay shán o shawkatá sarréch bebit. ");
INSERT INTO bcc_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Mehr o wapádári yakdegará dochára kapant, adl o émeni yakdomiá chokkant. ");
INSERT INTO bcc_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Wapádári cha zeminá rodit o adl cha ásmáná jahláda chárit. ");
INSERT INTO bcc_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Béshakk, Hodáwand nékén chizza bakshit o may zemin áiay bar o samará kárit. ");
INSERT INTO bcc_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Adl, áiay démá rawána bit o pa áiay gámán ráhé tayára kant. ");
INSERT INTO bcc_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Dáuday dwá. Oo Hodáwand! Wati delgóshá gón man kan o maná passaw day, ke garib o mohtájé án. ");
INSERT INTO bcc_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Mani zenday negahpániá bekan ke tai dóstdár án, wati hezmatkárá berakkén ke tai sará tawkala kant. ");
INSERT INTO bcc_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Oo Hodáwand! Mani sará rahm kan, ke sajjahén róchá tará tawára kanán. ");
INSERT INTO bcc_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Wati hezmatkáray delá shádmán kan, oo Hodáwand, ke man cha taw dwá lóthán. ");
INSERT INTO bcc_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Taw, oo Hodáwand, nék o bakshendah ay o pa áyán cha mehrá sarréch ay ke gón taw peryáta kanant. ");
INSERT INTO bcc_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Oo Hodáwand! Mani dwáyán gósh dár, mani peryát o zárián delgósh kan. ");
INSERT INTO bcc_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Sakkiáni róchá tará tawára kanán, ke taw passawa dayay. ");
INSERT INTO bcc_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Oo Hodáwand! Hodáyáni nyámá kass tai mattha nabit o tai kár bématth ant. ");
INSERT INTO bcc_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Oo Hodáwand! Tai jórh kortagén sajjahén kawma káyant o tará sojdaha kanant, tai námá shán o shawkata dayant, ");
INSERT INTO bcc_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","ke taw mazan ay o ajabén kára kanay, Hodá tahná taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Wati ráhá maná sój day, oo Hodáwand, ke tai rástén ráhá berawán, mani delá sarjamá gón wat kan ke cha tai námá betorsán. ");
INSERT INTO bcc_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Gón tamánén delé tai shográ gerán, oo Hodáwand, mani Hodá! Tai námá tán abad shán o shawkata dayán ");
INSERT INTO bcc_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","ke pa man tai mehr sakk mazan ent, taw maná cha johlánkián rakkéntag, cha mordagáni jaháná. ");
INSERT INTO bcc_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Oo Hodá! Gorunákén mardom mani helápá pád átkagant, zórákáni rombé mani koshagay johdá ent o tará hech mána nayárit. ");
INSERT INTO bcc_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Bale taw, oo Hodáwand, rahm kanók o mehrabánén Hodáé ay, hezhm geragá déra kanay o mehr o wapáyá sarréch ay. ");
INSERT INTO bcc_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Démá gón man tarrén o mani sará rahm kan, wati hezmatkárá zór o wák bebaksh o wati móleday chokká berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Maná wati rahmatáni neshánié beday, tán hamá ke gón man naprat kanant begendant o sharmendag bebant, chiá ke taw, oo Hodáwand, maná madat kortag o tasallá dátag. ");
INSERT INTO bcc_vpl VALUES ("PS87_1","020_87_1","PSA","87","1","1","Kórahay chokkáni Zabur. Sawté. Áiá, pákén kóhay sará shahré addh kort. ");
INSERT INTO bcc_vpl VALUES ("PS87_2","020_87_2","PSA","87","2","2","Hodáwandá Sahyunay darwázag dóster ant cha á dega hamá sajjahén jágahán ke Ákub jahmenend butag. ");
INSERT INTO bcc_vpl VALUES ("PS87_3","020_87_3","PSA","87","3","3","Oo Hodáay shahr! Tai bárawá porshánén habar kanaga bit. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS87_4","020_87_4","PSA","87","4","4","Mesr o Bábelá gón hamáyán hór hesába kárán ke maná zánant, Pilistiah o Surá ham, gón Kushá hawár. Esháni bárawá gwashaga bit: “É hamódá pédá butag”. ");
INSERT INTO bcc_vpl VALUES ("PS87_5","020_87_5","PSA","87","5","5","Sahyunay bárawá gwashaga bit: “É mardom o á mardom hamódá pédá butagant, borzén arshay Hodá wat Urshalimá pádára kant.” ");
INSERT INTO bcc_vpl VALUES ("PS87_6","020_87_6","PSA","87","6","6","Wahdé Hodáwand kawmáni námán nebeshtaha kant, nebisit: “É hamódá pédá butag.” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS87_7","020_87_7","PSA","87","7","7","Á ke sawta janant o á ke nácha kanant gwashant: “Mani sajjahén chammag cha taw bojant.” ");
INSERT INTO bcc_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Pa sázger o washáwázáni sálárá. Kórahay chokkáni Zabur. “Mahallat Léhanutay” tarzay sará. Hémán Ezráhiay shayri gwashtánk. Sawté. Oo Hodáwand! Oo mani rakkénókén Hodá! Shap o róch tai bárgáhá dwá o peryáta kanán. ");
INSERT INTO bcc_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Mani dwá tai dargáhá berasát, wati delgóshá gón mani peryátá kan. ");
INSERT INTO bcc_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Man janjálán kaptagán o mani zend pa marká sar butag. ");
INSERT INTO bcc_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Hamá mardománi paymá hesáb áraga bán ke johlén kandhá kaptagant, anchén mardoméay paymá ke nezór o nátwán ent. ");
INSERT INTO bcc_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Mordagáni nyámá yalah dayag butagán, chó mordagéá ke kabrá waptag, ke taw áyáni yátá naay o cha tai dastá jetá butagant. ");
INSERT INTO bcc_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Taw maná johlterén kandhá dawr dátag, tahárén johlánkiá. ");
INSERT INTO bcc_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Tai hezhm mani chakká kaptag, chawlán maná mán patátag. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Taw mani hamdelén sangat cha man dur bortag o cha man bézár kortagant. Bandig án o dar átka nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Mani chamm cha andóhá tahár butagant. Oo Hodáwand! Har róch tará tawára kanán o dastán pa taw shahárán. ");
INSERT INTO bcc_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","Wati ajabén kárán mordagán pésha dáray? Mordagáni arwáh páda káyant o tará satá kanant? Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","Mordag, kabrá tai mehray járá janant? Mordagáni jaháná tai wapádáriay kessahána kárant? ");
INSERT INTO bcc_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","Taháriá, tai ajabén kár zánaga bant o tai adl, shamóshkáriay molká? ");
INSERT INTO bcc_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Bale man gón taw madatay peryátá kanán, oo Hodáwand! Hamok sabáhá mani dwá tai bárgáhá rasant. ");
INSERT INTO bcc_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Oo Hodáwand! Chiá maná yalaha kanay o wati démá cha man chéra dayay? ");
INSERT INTO bcc_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Cha warnáiá sakkiáni ámách o markig butagán, tai torsá maná bazzag kortag o béwas án. ");
INSERT INTO bcc_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Tai hezhmá maná patátag o tai bimmá maná próshtag. ");
INSERT INTO bcc_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Sajjahén róchá ápay paymá maná chapp o chágerdá geptag o cha har némagá angerresh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Taw mani dóst o sangat cha man dur kortagant, tahná tahári ent ke mani hamráh ent. ");
INSERT INTO bcc_vpl VALUES ("PS89_1","020_89_1","PSA","89","1","1","Itán Ezráhiay shayri gwashtánk. Hodáwanday mehrá tán abada názénán cha wati zobáná, tai wapádáriay kessahá sajjahén naslán sara kanán. ");
INSERT INTO bcc_vpl VALUES ("PS89_2","020_89_2","PSA","89","2","2","Man gwasht ke “tai mehr abadmán ent o taw wati wapádári, ásmáná káhem kortag.” ");
INSERT INTO bcc_vpl VALUES ("PS89_3","020_89_3","PSA","89","3","3","Taw gwasht: “Man gón wati gechén kortagéná ahd o karáre bastag o gón wati hezmatkár Dáudá pa sawgend kawl kortag: ");
INSERT INTO bcc_vpl VALUES ("PS89_4","020_89_4","PSA","89","4","4","‘Tai padréchá tán abad barjáha dárán o tai bádsháhi tahtá nasláni nasl.’” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS89_5","020_89_5","PSA","89","5","5","Oo Hodáwand! Ásmán tai ajabén kárán satá kant o tai wapádáriá ham, pákénáni diwáná. ");
INSERT INTO bcc_vpl VALUES ("PS89_6","020_89_6","PSA","89","6","6","Ásmánán, kay Hodáwanay matth buta kant? Choshén ásmáni hastié hast ke Hodáwanday paymá bebit? ");
INSERT INTO bcc_vpl VALUES ("PS89_7","020_89_7","PSA","89","7","7","Hodáay tors ásmáni hastiáni nyámá sakk mazan ent, á cha wati chapp o chágerday sajjahénán bákamálter ent. ");
INSERT INTO bcc_vpl VALUES ("PS89_8","020_89_8","PSA","89","8","8","Oo Hodáwand, lashkaráni Hodá! Kay tai matth o darwar ent? Taw zórák ay, oo Hodáwand, o tai wapádáriá tará chapp o chágerd kortag. ");
INSERT INTO bcc_vpl VALUES ("PS89_9","020_89_9","PSA","89","9","9","Taw mastén daryáyáni sará hokmránia kanay o wahdé chawlesh chesta bant, taw éresha káray. ");
INSERT INTO bcc_vpl VALUES ("PS89_10","020_89_10","PSA","89","10","10","Taw Raháb, láshéay paymá drosht o gón wati zórmandén báská wati dozhmen sheng o sháng kortant. ");
INSERT INTO bcc_vpl VALUES ("PS89_11","020_89_11","PSA","89","11","11","Ásmán taig ent o zemin ham, jahán o eshiay tahá harché ke hast, taw addh kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS89_12","020_89_12","PSA","89","12","12","Shomál o jonub taw addh kortagant, Tábór o Hermónay kóh tai námá názénant. ");
INSERT INTO bcc_vpl VALUES ("PS89_13","020_89_13","PSA","89","13","13","Tai básk zórmand ent, tai dast zóráwar ent, tai rástén dast porwák o sóbén ent. ");
INSERT INTO bcc_vpl VALUES ("PS89_14","020_89_14","PSA","89","14","14","Adl o ensáp tai bádsháhiay bonyád ant, mehr o wapádári tai hamráhiá, démá gám janán ant. ");
INSERT INTO bcc_vpl VALUES ("PS89_15","020_89_15","PSA","89","15","15","Oo Hodáwand! Bahtáwar hamá ant ke shádmániay áwázá pajjáha kárant o tai bárgáhay nurá gáma janant. ");
INSERT INTO bcc_vpl VALUES ("PS89_16","020_89_16","PSA","89","16","16","Sajjahén róchá tai námay sará shádehia kanant o cha tai adlá sarboland ant. ");
INSERT INTO bcc_vpl VALUES ("PS89_17","020_89_17","PSA","89","17","17","Chiá ke taw áyáni shán o shawkat o áyáni wák o twán ay o cha wati mehrabániá may kánthá sarperáza kanay. ");
INSERT INTO bcc_vpl VALUES ("PS89_18","020_89_18","PSA","89","18","18","Béshakk, may bádsháh Hodáwandayg ent, may espar Esráilay pákénay. ");
INSERT INTO bcc_vpl VALUES ("PS89_19","020_89_19","PSA","89","19","19","Yak wahdé taw, shobéná gón wati wapádárán habar kort o gwasht: “Man jangólé madat kortag o cha kawmá gechéni warnáé ródéntag. ");
INSERT INTO bcc_vpl VALUES ("PS89_20","020_89_20","PSA","89","20","20","Man wati hezmatkár, Dáud shóház kortag o wati pákén, rógen per moshtag. ");
INSERT INTO bcc_vpl VALUES ("PS89_21","020_89_21","PSA","89","21","21","Mani dast gón áiá góna bit o mani báski zórmanda kant. ");
INSERT INTO bcc_vpl VALUES ("PS89_22","020_89_22","PSA","89","22","22","Dozhmen cha áiá bája nabárt o badkár áiay sará sarzóra nabit. ");
INSERT INTO bcc_vpl VALUES ("PS89_23","020_89_23","PSA","89","23","23","Dozhmenán áiay démá prósha dayán o harkas ke cha áiá naprata kant, prósháni. ");
INSERT INTO bcc_vpl VALUES ("PS89_24","020_89_24","PSA","89","24","24","Mani mehr o wapádári áiay hamráha bant o mani námá áiay kánth borzáda bit. ");
INSERT INTO bcc_vpl VALUES ("PS89_25","020_89_25","PSA","89","25","25","Áiay dastá tán daryáyá sara kanán, áiay rástén dastá tán kawrán. ");
INSERT INTO bcc_vpl VALUES ("PS89_26","020_89_26","PSA","89","26","26","Á maná gwánka jant o gwashit: ‘Taw mani Pet ay, mani Hodá o mani nejátay talár.’ ");
INSERT INTO bcc_vpl VALUES ("PS89_27","020_89_27","PSA","89","27","27","Man ham áiá wati masterén chokka kanán, jahánay masterén bádsháh. ");
INSERT INTO bcc_vpl VALUES ("PS89_28","020_89_28","PSA","89","28","28","Wati mehrá tán abad áiay hamráha kanán o gón áiá wati ahd o karárá mohra dárán. ");
INSERT INTO bcc_vpl VALUES ("PS89_29","020_89_29","PSA","89","29","29","Tán abad áiay naslá barjáha dárán, áiay bádsháhiay tahtá ásmánay rócháni hesábá. ");
INSERT INTO bcc_vpl VALUES ("PS89_30","020_89_30","PSA","89","30","30","Agan áiay chokk mani Sharyatá yalah bekanant o mani parmánáni randgiriá makanant, ");
INSERT INTO bcc_vpl VALUES ("PS89_31","020_89_31","PSA","89","31","31","agan mani rahbandán bepróshant o mani hokmán mamannant, ");
INSERT INTO bcc_vpl VALUES ("PS89_32","020_89_32","PSA","89","32","32","áyáni gonáhán pa latth sezá dayán, náparmánián pa hayzarán, ");
INSERT INTO bcc_vpl VALUES ("PS89_33","020_89_33","PSA","89","33","33","bale áiay dóst dáragá bassa nakanán o gón áiá wati kortagén kawlá napróshán. ");
INSERT INTO bcc_vpl VALUES ("PS89_34","020_89_34","PSA","89","34","34","Wati ahd o paymáná napróshán o á habar ke cha mani dapá dar átkag, badalia nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS89_35","020_89_35","PSA","89","35","35","Man yak baré mán wati pákiá sawgendé wártag o gón Dáudá dróga nabandán, ");
INSERT INTO bcc_vpl VALUES ("PS89_36","020_89_36","PSA","89","36","36","ke áiay nasl tán abad barjáha mánit o áiay taht mani dargáhá chó róchá abadi ent, ");
INSERT INTO bcc_vpl VALUES ("PS89_37","020_89_37","PSA","89","37","37","chó máhá tán abad barjáha mánit, ke jambaráni tahá tachk o rástén sháhedé.” Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS89_38","020_89_38","PSA","89","38","38","Bale annun taw wati dém tarréntag o á yalah kortag, wati rógen per moshtagénay sará hezhm geptagay. ");
INSERT INTO bcc_vpl VALUES ("PS89_39","020_89_39","PSA","89","39","39","Taw gón wati hezmatkárá bastagén ahd o paymán pad tarréntag o áiay táj, zeminá dawr dátag. ");
INSERT INTO bcc_vpl VALUES ("PS89_40","020_89_40","PSA","89","40","40","Taw áiay sajjahén diwál karótkagant o áiay mohrén kalát próshtag. ");
INSERT INTO bcc_vpl VALUES ("PS89_41","020_89_41","PSA","89","41","41","Harkas ke cha ráhá gwazit, áiá pol o páncha kant o á wati hamsáhegáni kalági jórh butag. ");
INSERT INTO bcc_vpl VALUES ("PS89_42","020_89_42","PSA","89","42","42","Taw áiay dozhmenáni rástén dast borzád bortag o sajjahén badwáh shádmán kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS89_43","020_89_43","PSA","89","43","43","Taw áiay zahm konth kortag o jangá madat nadátag. ");
INSERT INTO bcc_vpl VALUES ("PS89_44","020_89_44","PSA","89","44","44","Taw áiay shán bortag o taht hákán dawr dátag. ");
INSERT INTO bcc_vpl VALUES ("PS89_45","020_89_45","PSA","89","45","45","Taw áiay warnáiay róch kamm kortagant o sharmendagiay kabáhéá póshéntag. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS89_46","020_89_46","PSA","89","46","46","Tán kadén, oo Hodáwand! Watá tán abad chéra dayay? Tán kadén tai hezhm chó ásá róka mánit? ");
INSERT INTO bcc_vpl VALUES ("PS89_47","020_89_47","PSA","89","47","47","Hayálá bekap ke mani omray róch chón kamm ant, taw bani ádam nákárén chizzé jórh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS89_48","020_89_48","PSA","89","48","48","Kojám ensán ent ke marka nagendit, kay cha kabray zórá rakketa kant? Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS89_49","020_89_49","PSA","89","49","49","Oo Hodáwand! Tai á pésarigén mehr kojá ent ke taw gón Dáudá sawgend wárt o kawl kort. ");
INSERT INTO bcc_vpl VALUES ("PS89_50","020_89_50","PSA","89","50","50","Oo Hodáwand! Hayálá bekap ke tai hezmatkárá chón shegána janant, sajjahén kawmáni rishkandán wati delá dárán. ");
INSERT INTO bcc_vpl VALUES ("PS89_51","020_89_51","PSA","89","51","51","Oo Hodáwand! Tai dozhmenán mani sará rishkand kortag o hamok gámá tai rógen per moshtagénesh kalág bastag. ");
INSERT INTO bcc_vpl VALUES ("PS89_52","020_89_52","PSA","89","52","52","Hodáwandá tán abad satá bát. Anchosh bát. Ámin. ");
INSERT INTO bcc_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Hodáay hezmatkár Mussáay dwá. Oo Hodáwand! Nasláni nasl taw may menendjáh butagay. ");
INSERT INTO bcc_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Cha kóháni pédá bayag o zemin o jahánay addh kanagá pésar, cha azal tán abad, Hodá taw ay. ");
INSERT INTO bcc_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","3","Ensáná padá hákay chérá baray o gwashay: “Oo ensánay chokk! Háká per tarr.” ");
INSERT INTO bcc_vpl VALUES ("PS90_4","020_90_4","PSA","90","4","4","Hazár sál pa taw chó gwastagén yak róchéá ent, chó shapi yak páséá. ");
INSERT INTO bcc_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Ensán wábé o chó háréá áiá rópána kanay. Sohbá chó káhá tázag ent, ");
INSERT INTO bcc_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","sabáhá rodit o sabzit, bégáhá gimmorit o hoshka tarrit. ");
INSERT INTO bcc_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Cha tai hezhmá halása bén, cha tai gazabá paréshán. ");
INSERT INTO bcc_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Taw may mayár wati démá kortagant o chérén gonáh wati bárgáhay rozhnáiá. ");
INSERT INTO bcc_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","May sajjahén zend tai hezhmay chérá gwazit o wati sálán pa nálagá halása kanén. ");
INSERT INTO bcc_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","May omray róch haptád sál ant yá hashtád sál, agan sakk zreng bebén, bale sharterén róch ham zahmat o janjálá porr ant, sakk zutta gwazant o má bála kanén. ");
INSERT INTO bcc_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Kay tai hezhmay trondiá zánt? tai gazab delá torsa nádénit. ");
INSERT INTO bcc_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Gorhá márá é zántá beday ke may rócháni hesáb kamm ent, tán may del aglmand bebit. ");
INSERT INTO bcc_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Dém pa má per tarr, oo Hodáwand! Tán kadén chosha bit? Wati hezmatkáráni sará rahm kan. ");
INSERT INTO bcc_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Bámgwáhán, márá gón wati mehrá sér kan, tánke sajjahén omrá sawt bejanén o shádehi bekanén. ");
INSERT INTO bcc_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Haminchok róchá ke taw márá azáb dátag, haminchok róchá márá shádmán kan, haminchok sálá ke sakkián dochár butagén. ");
INSERT INTO bcc_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Tai kár tai hezmatkáráni démá paddar bátant o tai mazani pa áyáni óbádagán. ");
INSERT INTO bcc_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","May Hodáwandén Hodáay mehrabáni pa má sar bát, may dastáni kárán barkat beday, haw, may dastáni kárán barkat beday. ");
INSERT INTO bcc_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","1","Hamá ke borzén arshay Hodáay panáhgáhá neshtag, zórákay sáhegá áráma gipt. ");
INSERT INTO bcc_vpl VALUES ("PS91_2","020_91_2","PSA","91","2","2","Hodáwanday bárawá gwashán: “Hamá mani panáh o kalát ent, mani Hodá, ke hamáiay sará tawkala kanán.” ");
INSERT INTO bcc_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Deljam án ke hamá tará cha shekáriáni dámá rakkénit, cha koshókén wabáyán. ");
INSERT INTO bcc_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Á tará gón wati poth o bálán póshénit o áiay bánzoláni chérá panáha bay, áiay wapádári espar o diwálé. ");
INSERT INTO bcc_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Cha shapay bimmá natorsay, na cha á tirá ke róchá srapit, ");
INSERT INTO bcc_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","na cha wabáyá ke taháriá gardit, na cha á hawpá ke némróchá béránia kárit. ");
INSERT INTO bcc_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Hazárán kas tai kerrá kapit, dahán hazár tai rástén némagá, bale é tabáhi tai nazziká átka nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Tahná gón wati chammáni shánk dayagá badkáráni sezáyána genday. ");
INSERT INTO bcc_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","9","Agan Hodáyá wati panáh bekanay, borzén arshay Hodáyá wati menendjáh, ");
INSERT INTO bcc_vpl VALUES ("PS91_10","020_91_10","PSA","91","10","10","hech kazá tai sará sarzóra nabit o hech baláh tai gedánay nazziká nayayt. ");
INSERT INTO bcc_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Tai bárawá préshtagán hokma kant ke tai sajjahén ráhán, tai negahpániá bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Á tará wati dastáni delá dárant tán tai pád dhókéá malaggit. ");
INSERT INTO bcc_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Shér o máráni sará garday, rostagén shér o syahmáráni saragán pádmála kanay. ");
INSERT INTO bcc_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Hodáwanda gwashit: “Á ke maná dósta dárit áiá nejáta dayán o hamáiay posht o panáha bán ke mani námá zánt. ");
INSERT INTO bcc_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Á maná tawára kant o man passawia dayán, sakkián áiay hamráha bán, áiá nejáta dayán o ezzata bakshán. ");
INSERT INTO bcc_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Áiá cha drájén omré sérápa kanán o Hodái nejátá áiá pésha dárán.” ");
INSERT INTO bcc_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Pa Shabbatay róchá sawté. Zaburé. Hodáay satá kanag wassh ent o tai námay názénag, oo borzén arshay Hodá! ");
INSERT INTO bcc_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","2","Bámgwáhán tai mehr o shapán tai wapádáriay járay janag, ");
INSERT INTO bcc_vpl VALUES ("PS92_3","020_92_3","PSA","92","3","3","gón dahtárén tamburag o changay zémelá wassh ent. ");
INSERT INTO bcc_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Chiá ke taw, oo Hodáwand, maná gón wati dastay kárán shádmán kortag, tai tawsipá shádmániay sawta janán. ");
INSERT INTO bcc_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Oo Hodáwand! Tai kár chón mazan ant o pegr chenkadar johlánk. ");
INSERT INTO bcc_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Ahmaka nazánt o nádán sarpada nabit. ");
INSERT INTO bcc_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Harchont ke badkár chó káhá berodant o radkár besabzant, bale tán abad tabáha bant. ");
INSERT INTO bcc_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Bale taw, oo Hodáwand, tán abad borzén arshay Hodá ay. ");
INSERT INTO bcc_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Tai dozhmen, oo Hodáwand, allam gár o gomsára bant o sajjahén badkár, sheng o sháng. ");
INSERT INTO bcc_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Bale taw mani kánth, wahshién gókay kánthay paymá borz dáshtag o maná sapáén rógen per moshtag. ");
INSERT INTO bcc_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Mani chammán dozhmenáni shekast distag o góshán badkáráni sarshakuniay habar eshkotag. ");
INSERT INTO bcc_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Pahrézkár macchay paymá sabzant o Lobnánay gazzáni paymá rodant. ");
INSERT INTO bcc_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Á Hodáwanday lógá keshag butagant o may Hodáay bárgáhá sabzant. ");
INSERT INTO bcc_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","15","Piriá ham bar o samara dayant o pa é járay janagá tarr o tázag o sabza mánant ke Hodáwand rást o ádel ent, hamá mani talár ent o áiá hech náensápi o badi mán nést. ");
INSERT INTO bcc_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Hodáwand bádsháhia kant áiá watá pa shán o shawkat árástag, Hodáwand porshawkat ent o zór o wáká selahband. Donyá mohr óshtátag o nalarzit. ");
INSERT INTO bcc_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Tai bádsháhi taht cha azal barjam ent o taw cha azal hastay. ");
INSERT INTO bcc_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Oo Hodáwand! Kawr chest butagant, kawrán wati tawár chest kortag, kawrán wati gorragáni tawár chest kortag. ");
INSERT INTO bcc_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Hodáwand cha mazanén ápáni tawárán, cha daryáay chawláni proshagá mazanshánter ent, borzén arshá. ");
INSERT INTO bcc_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Oo Hodáwand! Tai hokm modám barjáha mánant, tai bádsháhi pák o palgár ent, modám, tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS94_1","020_94_1","PSA","94","1","1","Oo bérgirén Hodá! Oo Hodáwand! Oo bérgirén Hodá! Wati shán o shawkatá záher kan. ");
INSERT INTO bcc_vpl VALUES ("PS94_2","020_94_2","PSA","94","2","2","Pád á, oo zeminay dádras! Porkebr o gorunákán sezá day. ");
INSERT INTO bcc_vpl VALUES ("PS94_3","020_94_3","PSA","94","3","3","Tán kadén, oo Hodáwand! Badkár tán kadén sarzór bebant? ");
INSERT INTO bcc_vpl VALUES ("PS94_4","020_94_4","PSA","94","4","4","É mardom gón kebré habara kanant, sajjahén badkár batháka janant. ");
INSERT INTO bcc_vpl VALUES ("PS94_5","020_94_5","PSA","94","5","5","Oo Hodáwand! Tai kawmá pádmála kanant o tai mirásá ázára dayant. ");
INSERT INTO bcc_vpl VALUES ("PS94_6","020_94_6","PSA","94","6","6","Janózám o darámadán koshant o chórhawán haláka kanant. ");
INSERT INTO bcc_vpl VALUES ("PS94_7","020_94_7","PSA","94","7","7","Gwashant: “Hodáwanda nagendit, Ákubay Hodá sarpada nabit”. ");
INSERT INTO bcc_vpl VALUES ("PS94_8","020_94_8","PSA","94","8","8","Sarpad bét, oo kawmay názántán! Oo jáhelán! Kadén ákela bét? ");
INSERT INTO bcc_vpl VALUES ("PS94_9","020_94_9","PSA","94","9","9","Á ke góshi addh kortag, naeshkont? O á ke chammi addh kortag, nagendit? ");
INSERT INTO bcc_vpl VALUES ("PS94_10","020_94_10","PSA","94","10","10","Á kas ke kawmán sezá dant, áyán adaba nakant? O á kas ke bani ádamá zánta bakshit, watá zánt o zánagi nést? ");
INSERT INTO bcc_vpl VALUES ("PS94_11","020_94_11","PSA","94","11","11","Hodáwand ensánay sajjahén pegrána zánt, á zánt ke náhudag o nákár ant. ");
INSERT INTO bcc_vpl VALUES ("PS94_12","020_94_12","PSA","94","12","12","Oo Hodáwand! Bahtáwar ent hamá ke taw áiá adaba kanay, hamá ke taw gón wati Sharyatá áiá tálima dayay. ");
INSERT INTO bcc_vpl VALUES ("PS94_13","020_94_13","PSA","94","13","13","Taw áiá cha sakkén róchána rakkénay, tán hamá wahdá ke pa badkárán kallé kóchag bebit. ");
INSERT INTO bcc_vpl VALUES ("PS94_14","020_94_14","PSA","94","14","14","Chiá ke Hodáwand wati kawmá yalaha nakant o wati mirásá dawra nadant. ");
INSERT INTO bcc_vpl VALUES ("PS94_15","020_94_15","PSA","94","15","15","Dádrasi padá pa ensápa bit, sajjahén nékdel ensápay randgiriá kanant. ");
INSERT INTO bcc_vpl VALUES ("PS94_16","020_94_16","PSA","94","16","16","Kay ent ke pa manigi badkáráni démá pád byayt? Kay ent ke pa manigi radkáráni démá bóshtit? ");
INSERT INTO bcc_vpl VALUES ("PS94_17","020_94_17","PSA","94","17","17","Agan Hodáwand mani komak mabutén, man zutt markay bétawariá bokketagatán. ");
INSERT INTO bcc_vpl VALUES ("PS94_18","020_94_18","PSA","94","18","18","Wahdé gwashton: “Mani pád thagalagá ent”, tai mehrá, oo Hodáwand, maná cha kapagá dásht. ");
INSERT INTO bcc_vpl VALUES ("PS94_19","020_94_19","PSA","94","19","19","Wahdé sargardána bán, tai dátagén delbaddhi maná shádmána kant. ");
INSERT INTO bcc_vpl VALUES ("PS94_20","020_94_20","PSA","94","20","20","Choshén béensápén hákemé gón taw yak o tepák buta kant ke gón wati hokm o kánunán náensápia kárit? ");
INSERT INTO bcc_vpl VALUES ("PS94_21","020_94_21","PSA","94","21","21","Áyáni thóli pahrézkáráni helápá hamdast o hamkára bant o bégonáhán markay sezá dayant. ");
INSERT INTO bcc_vpl VALUES ("PS94_22","020_94_22","PSA","94","22","22","Bale Hodáwand mani kalát ent, mani Hodá, mani talár, mani panáhgáh. ");
INSERT INTO bcc_vpl VALUES ("PS94_23","020_94_23","PSA","94","23","23","Hodá, áyáni gonáhán hamáyáni jenday sará pera tarrénit o áyán, áyáni jenday badén káráni tahá gár o gomsára kant. Haw, may Hodáwand áyán gár o tabáha kant. ");
INSERT INTO bcc_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Byáét Hodáwandá pa galé názénén, pa wati nejátay talárá pa shádehi kukkára kanén. ");
INSERT INTO bcc_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","2","Byáét pa shogrgozári áiay bárgáhá rawén, pa shádehi kukkára kanén, sawta janén o áiá satá kanén, ");
INSERT INTO bcc_vpl VALUES ("PS95_3","020_95_3","PSA","95","3","3","ke Hodáwand mazanshánén Hodá ent, sajjahén “hodáyáni” masterén bádsháh. ");
INSERT INTO bcc_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Zeminay johli hamáiay dastá ant o kóháni borzi ham hamáiayg ant. ");
INSERT INTO bcc_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Daryá Hodáwandayg ent ke wat addhi kortag, hoshkén zemin ham hamáiay dastán jórh kortag. ");
INSERT INTO bcc_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Byáét, sará jahla kanén o sojdaha kanén, wati addh kanókén Hodáwanday bárgáhá kóndhána kapén, ");
INSERT INTO bcc_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","ke hamá may Hodá ent o má, áiay charágáhay mardom, hamáiay dastay ramag én. Drégatá shomá maróchi áiay tawár beshkotén: ");
INSERT INTO bcc_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Wati delán á paymá sarkash makanét ke kawmá Meribáyá kort, ke kawmá á róchi Massahay gyábáná kort. ");
INSERT INTO bcc_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Ódá shomay pirénán maná chakkáset o ázmáesh kort, bell ke mani kortagén káresh distagatant. ");
INSERT INTO bcc_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Tán chel sálá cha á naslá bézár atán, gwashton: ‘É anchén mardom ant ke delesh gomráh ant o mani ráhána nazánant,’ ");
INSERT INTO bcc_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Gorhá man wati hezhmá sawgend wárt ke ‘é hechbar mani ásudagiá sara nabant.’” ");
INSERT INTO bcc_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Pa Hodáwandá nókén sawté bejanét. Oo sajjahén zemin! Hodáwandá benázén. ");
INSERT INTO bcc_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Hodáwandá benázénét, áiay námá satá kanét. Har róch hamá nejátay járá bejanét ke cha áiay némagá ent. ");
INSERT INTO bcc_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","3","Kawmáni nyámá áiay shán o shawkatay járá bejanét, sajjahén kawmáni nyámá áiay ajabén káráni. ");
INSERT INTO bcc_vpl VALUES ("PS96_4","020_96_4","PSA","96","4","4","Ke Hodáwand mazan ent o satáyáni láhek, cha sajjahén “hodáyán” bákamálter ent. ");
INSERT INTO bcc_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Kawmáni sajjahén “hodá” náudagén bot ant, bale Hodáwandá ásmán jórh kortant. ");
INSERT INTO bcc_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Ezzat o shán hamáiay chapp o chágerdá ent o kodrat o zébái áiay pákén bárgáhá. ");
INSERT INTO bcc_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Oo kawmáni kabilahán! Hodáwandá benázénét, Hodáwanday shán o kodratá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Hodáwanday námay mazaniá benázénét, korbánig byárét o áiay bárgáhá byáét. ");
INSERT INTO bcc_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Cha Hodáwanday pákiay zébáiá, áiay démá kóndhán bekapét. Oo sajjahén zemin! Áiay dargáhá belarz. ");
INSERT INTO bcc_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Sajjahén kawmáni nyámá begwashét: “Hodáwand bádsháh ent.” Jahán pa mohkami jórh kanag butag o nasorit, á, kawmáni dadrasiá pa ensápa kant. ");
INSERT INTO bcc_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","Ásmán shádehi bekanát o zemin gal bát, daryá o harché ke daryáyá mán, pa borztawári áiá benázénátant. ");
INSERT INTO bcc_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","12","Dhagár o harché ke dhagárá hast gal bátant, jangalay sajjahén drachk pa shádmáni áiá benázénátant. ");
INSERT INTO bcc_vpl VALUES ("PS96_13","020_96_13","PSA","96","13","13","Hodáwandá benázénátant, chiá ke á kayt, haw, pa zeminay dadrasiá kayt. Jahánay dadrasiá pa adl o ensápa kant o kawmáni dadrasiá wati rásti o tachkiay hesábá. ");
INSERT INTO bcc_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Hodáwand bádsháhia kant, zemin shádehi bekanát o sajjahén tayábi sardhagár gal bátant. ");
INSERT INTO bcc_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Jambar o tahári áiay chapp o chágerdá ant, adl o ensáp, áiay tahtay bonhesht o bonyád ant. ");
INSERT INTO bcc_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Ás áiay démá rawán ent o cha har némagá áiay dozhmenán éra bárt. ");
INSERT INTO bcc_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Áiay grók jaháná róshná kant, zemina gendit o larzit. ");
INSERT INTO bcc_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Hodáwanday démá kóh chó mómá ápa bant, sajjahén jahánay Hodáwanday démá. ");
INSERT INTO bcc_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Ásmán áiay adlay járá janant o sajjahén kawm áiay shán o shawkatá gendant. ");
INSERT INTO bcc_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Á sajjahén mardom sharmsára bant ke bot sojdaha kanant, hamá ke náhudagén botáni poshtá pahra bandant. Oo sajjahén “hodáyán”! Áiá sojdah kanét. ");
INSERT INTO bcc_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","8","Sahyun eshkont o shádehia kant o Yahudiahay jenek gal ant cha tai dadrasiá, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS97_9","020_97_9","PSA","97","9","9","Chiá ke taw, oo borzén arshay Hodáwand, sajjahén zeminay sará mazanshán ay, taw sajjahén “hodáyáni” sará báládast ay. ");
INSERT INTO bcc_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Shomá ke Hodáwandá dósta dárét, cha badiá naprat kanét, chiá ke á Hodádóstáni zenday negahpán ent o áyán cha badkáráni dastá nejáta dant. ");
INSERT INTO bcc_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Nur pa pahrézkárán keshaga bit o shádehi pa nékdelán. ");
INSERT INTO bcc_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","Oo pahrézkárán! Hodáwanday bárgáhá shádehi kanét o áiay pákén námá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","Zaburé. Pa Hodáwandá nókén sawté bejanét, ke ajabén kári kortag, áiay rástén dast o pákén báská sób o pérózi katthetag. ");
INSERT INTO bcc_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Hodáwandá hamá neját pésh dáshtag ke cha áiay némagá ent, wati adli kawmáni chammán paddar kortag. ");
INSERT INTO bcc_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Áiá pa Esráilay óbádagán wati mehr o wapa yátá áwortag, zeminay sajjahén goddhi hadd o simsarán, may Hodáay dátagén neját distag. ");
INSERT INTO bcc_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Oo sajjahén zemin! Pa Hodáwandá shádmániay kukkárá borz kan. Kukkár kanét, pa shádehi sawt bejanét, benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Pa Hodáwandá chang o sáz bejanét, gón sázá sawt bejanét. ");
INSERT INTO bcc_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Gón sorná o gwarándhay kánthá bádsháhén Hodáwanday bárgáhá, shádehiay kukkárá chest kanét. ");
INSERT INTO bcc_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Daryá o daryáay tahay sajjahén chizz grandátant, jahán o áiay sajjahén jahmenend. ");
INSERT INTO bcc_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Kawr cháp bejanátant o kóh pa shádmáni sawt, ");
INSERT INTO bcc_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Hodáwanday bárgáhá sawt bejanátant, ke á pa zeminay dadrasiá kayt. Á jaháná pa adl dádrasia kant o kawmán pa ensáp. ");
INSERT INTO bcc_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Hodáwand bádsháhia kant, kawm belarzátant, á, karrubiáni nyámá, wati bádsháhi tahtá neshtag, zemin belarzát. ");
INSERT INTO bcc_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Sahyuná, Hodáwand mazan ent, borzén arshay Hodá, sajjahén kawmáni sará hákem. ");
INSERT INTO bcc_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Tai mazan o bákamálén námá satá kanátant, Hodáwand pák ent. ");
INSERT INTO bcc_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Bádsháh zóráwar ent, adli dósta bit. Taw, oo Hodá, ensáp barjáh dáshtag, sajjahén Esráilá taw hamá kár kortag ke pa adl o ensáp ant. ");
INSERT INTO bcc_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","May Hodáwandén Hodáyá shán o shawkat dayét o áiay pádáni padagay démá parastesh kanét, ke á pák ent. ");
INSERT INTO bcc_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Mussá o Hárun cha hamáiay dini péshwáyán atant o Samuil ham cha hamáyán at ke Hodáwanday námesh gept. Hodáwandesh tawár kort o áiá passaw dátant. ");
INSERT INTO bcc_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Cha jambaray sotuná gón áyán habari kort o áyán ham hamá hokm o Sharyat barjáh dásht ke dátagati. ");
INSERT INTO bcc_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Oo Hodáwand, may Hodá! Taw á passaw dátant, taw pa Esráilá pahell kanókén Hodáé atay, harchont ke áyáni gonáháni sezáet ham dát. ");
INSERT INTO bcc_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","May Hodáwandén Hodáyá shán o shawkat bedayét, áiay pákén kóhay sará áiá parastesh kanét, ke Hodáwand, may Hodá pák ent. ");
INSERT INTO bcc_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Shogrgozáriay Zaburé. Oo sajjahén zemin! Pa Hodáwandá shádmániay gwánká bejan. ");
INSERT INTO bcc_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Hodáwandá pa shádehi parastesh kanét, gón shádmániay sawtán áiay bárgáhá byáét. ");
INSERT INTO bcc_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Bezánét ke Hodáwand, Hodá ent, hamáiá márá addh kortag o má hamáiayg én, má áiay kawm, áiay charágáhay ramag én. ");
INSERT INTO bcc_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","4","Áiay darwázagán gón shogrgozári bepotrét o áiay bárgáhá gón satá o saná. Áiay shográ begerét o áiay námá besárháét, ");
INSERT INTO bcc_vpl VALUES ("PS100_5","020_100_5","PSA","100","5","5","ke Hodáwand nék ent o mehri abadmán, áiay wapádári nasláni nasl barjáha mánit. ");
INSERT INTO bcc_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Dáuday Zabur. Mehr o adlay sawtá janán, tará názénán, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Bémayáriay ráhá rawán. Mani kerrá kadi káay? Gón delpahki wati lógá zenda gwázénán. ");
INSERT INTO bcc_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Wati chammán sell o bazzhnákén chizzáni cháragá naylán, cha náráhén kárán bézár án, maná gón choshén chizzán kár nést. ");
INSERT INTO bcc_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Gomráhdelén mardomán cha wat dura dárán, maná gón hecch badiéá kára nabit. ");
INSERT INTO bcc_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Gár o gomsára kanán hamáiá ke wati hamsáhegay báposhtá habara kant. Hech porkebrén chamm o gorunákén deléay ópárá nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Mani chamm zeminay sará wapádárén mardom shóháza kanant tánke gón man jahmenend bebant, hamá kas mani hezmatkár buta kant ke pa bémayária gardit. ");
INSERT INTO bcc_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Prébkárá mani lógá jágaha nabit o drógband mani hezmatá korta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Har sohbá molkay sajjahén badkárán tabáha kanán, radkárán cha Hodáwanday shahrá gár o gomsára kanán. ");
INSERT INTO bcc_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Setam distagén mardoméay dwá, hamá wahdá ke wat ájez ent o wati peryátá Hodáwanday bárgáhá sara kant. Oo Hodáwand! Mani dwáyá gósh dár, mani peryát tará sar bát. ");
INSERT INTO bcc_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Mani sakki o sóriay róchá wati démá cha man chér maday. Wati delgóshá gón man kan, wahdé tará tawára kanán, zutt passaw beday. ");
INSERT INTO bcc_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Chéá ke mani róch chó duttá gára bant o haddh chó rókén eshkará sochant. ");
INSERT INTO bcc_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Mani del chó mortagén káhá gimmortag o hoshk tarretag o cha ward o waráká kaptagán. ");
INSERT INTO bcc_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Cha bázén nálag o peryátá hoshkén haddh o pósté án. ");
INSERT INTO bcc_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Gyábáni bumméay paymá án, anchó ke bummé mán wayránagán. ");
INSERT INTO bcc_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Béwáb gandaláni tahá tachk án, anchó ke tahnáén morgé lógéay sará. ");
INSERT INTO bcc_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Dozhmen sajjahén róchá maná shegána janant, kalága bandant o nálata kanant. ");
INSERT INTO bcc_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","9","Chéá ke nánay badalá pora warán o harché ke nóshán, arsá porr ant, ");
INSERT INTO bcc_vpl VALUES ("PS102_10","020_102_10","PSA","102","10","10","cha tai hezhm o gazabá, chéá ke taw maná chest kort o zeminá jat. ");
INSERT INTO bcc_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Mani róch, bégáhi sáhegéay paymá gára bant o man káhay dhawlá hoshk bayagá án. ");
INSERT INTO bcc_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Bale taw, oo Hodáwand, tán abad wati bádsháhi tahtá neshtagay o tai nám nasláni nasl barjáh ent. ");
INSERT INTO bcc_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Taw jáha janay o tará Sahyunay sará bazzaga bit, chéá ke Sahyunay sará rahm kanagay wahd átkag, á gisshetagén wahd rasetag. ");
INSERT INTO bcc_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Chéá ke tai hezmatkárán é shahray seng dóst ant o Sahyunay hákay sará ham bazzagesha bit. ");
INSERT INTO bcc_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","15","Kawm cha Hodáwanday námá torsant o zeminay sajjahén bádsháh cha tai mazani o sháná. ");
INSERT INTO bcc_vpl VALUES ("PS102_16","020_102_16","PSA","102","16","16","Chéá ke Hodáwand Sahyuná nóksará addha kant o mán wati shán o shawkatá záhera bit. ");
INSERT INTO bcc_vpl VALUES ("PS102_17","020_102_17","PSA","102","17","17","Á bazzagáni dwáyán gósha dárit o cha áyáni peryátán nádelgósha nabit. ");
INSERT INTO bcc_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Bell ke é pa áyókén nasléá nebisag bebit o anchén kawmé ke angat addh nabutag, Hodáwandá satá o saná bekant. ");
INSERT INTO bcc_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","19","Áiá cha wati pákén arshá jahlád cháretag, Hodáwandá cha ásmáná dém pa zeminá cháretag, ");
INSERT INTO bcc_vpl VALUES ("PS102_20","020_102_20","PSA","102","20","20","tánke bandigáni nálagán beshkont o hamáyán ázát bekant ke markay sezá dayag butagant, ");
INSERT INTO bcc_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","21","ke Sahyuná Hodáwanday námá jár bejanant o Urshalimá áiay satáyá bekanant, ");
INSERT INTO bcc_vpl VALUES ("PS102_22","020_102_22","PSA","102","22","22","hamá wahdá ke kawm o bádsháhi pa Hodáwanday parasteshá yakjáh moccha bant. ");
INSERT INTO bcc_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Ráhay némá mani twáni prósht o mani róchi gwandh kortant. ");
INSERT INTO bcc_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Gorhá man gwasht: “Oo Hodáwand! Omray nyámá mani zendá pach mager, tai sál tán sajjahén naslán barjáh ant. ");
INSERT INTO bcc_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Zemin, taw cha azalá jórh kortag o ásmán tai dastáni kár ent. ");
INSERT INTO bcc_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","É sajjahén gár o bégwáha bant bale taw mánay, é sajjahén chó pósháká kwahna bant, taw eshán chó pósháká badala kanay o é bérána bant, ");
INSERT INTO bcc_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","bale taw mánay o tai sál halása nabant. ");
INSERT INTO bcc_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Tai hezmatkáráni chokk tai bárgáhá jahmenenda bant o áyáni poshpad tai dargáhá barjáha mánant.” ");
INSERT INTO bcc_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Dáuday Zabur. Oo mani arwáh! Hodáwandá benázén. Oo mani bátenay har chizz! Áiay pákén námá benázén. ");
INSERT INTO bcc_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Hodáwandá benázén, oo mani arwáh! Áiay hecch nékiá mashamósh, ");
INSERT INTO bcc_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","hamá ke tai sajjahén gonáhána bakshit o tai drostigén nádráhián dráha kant. ");
INSERT INTO bcc_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Tará cha mordagáni jaháná rakkénit o mehr o rahmatay tájé tai sará dant. ");
INSERT INTO bcc_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Tará cha sharrén chizzán sérápa kant ke tai warnái wakábéay paymá nók o tázag bebit. ");
INSERT INTO bcc_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Hodáwand adl o ensápa kant o pa sajjahén setam distagénán dádrasi. ");
INSERT INTO bcc_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Áiá wati ráh pa Mussáyá záher kortant o wati kár pa Esráilay kawmá. ");
INSERT INTO bcc_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Hodáwand rahm kanók o mehrbán ent, hezhm geragá déra kant o mehrá sarréch ent. ");
INSERT INTO bcc_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Márá tán abad mayáriga nakant o na modám pa má gazaba gwárénit. ");
INSERT INTO bcc_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Márá may gonáháni hesábá nachárit, na ke márá may badiáni padmozzá dant. ");
INSERT INTO bcc_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Chéá ke haminkas ke ásmán cha zeminá borz ent, áiay mehr pa hamá mardomán ke Hodáay torsesh delá ent haminkas báz ent. ");
INSERT INTO bcc_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Haminkas ke mashrek cha magrebá dur ent, may gonáhi cha má haminkas dur kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","13","Hamá dábá ke peté pa wati chokkán mehrabán ent, hamé paymá Hodáwand pa hamá mardomán mehrabán ent ke áiay torsesh delá ent. ");
INSERT INTO bcc_vpl VALUES ("PS103_14","020_103_14","PSA","103","14","14","Chéá ke may sareshtá sarpad ent, á zánt ke má hák én. ");
INSERT INTO bcc_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Haw, ensán chó káhá ent, chó dhagáray goléá srapit. ");
INSERT INTO bcc_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Wahdé gwáté áiay sará kasshit, gára bit o áiay jágah padá áiá pajjáha nayárit. ");
INSERT INTO bcc_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","17","Bale Hodáwanday mehr, azal tán abad hamá mardománi hamráh ent ke áiay torsesh delá ent o áiay adl, esháni chokk o nomásagáni hamráh, ");
INSERT INTO bcc_vpl VALUES ("PS103_18","020_103_18","PSA","103","18","18","hamáyáni hamráh ke áiay rahbandáni randgiriá kanant o áiay hokmáni mannagá nashamóshant. ");
INSERT INTO bcc_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Hodáwandá wati bádsháhiay taht ásmánán barjáh dáshtag o áiay bádsháhi sajjahén hastiay sará hákemia kant. ");
INSERT INTO bcc_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Oo Hodáwanday préshtagán! Shomá, oo zóráwarán ke áiay habarán barjáha dárét o áiay parmánbardáriá kanét! Hodáwandá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Oo Hodáwanday sajjahén lashkarán! Shomá, oo áiay hezmatkárán ke áiay wáhagay parmánbardáriá kanét! Hodáwandá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Oo Hodáwanday sajjahén jórh kortagénán, har jágah ke áiay bádsháhi barjáh ent! Hodáwandá benázénét. Oo mani arwáh! Hodáwandá benázén. ");
INSERT INTO bcc_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Oo mani arwáh! Hodáwandá benázén. Oo Hodáwand, mani Hodá! Taw békesás mazan ay, taw gón ezzat o sháná póshetagay. ");
INSERT INTO bcc_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Nurá chó kabáhéá gwará kanay, ásmáná tambuéay paymá pacha kanay o ");
INSERT INTO bcc_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","3","wati borzi lógáni menokán ápáni sará oshtárénay. Jambarán wati arrábah jórha kanay o gwátay bánzolán swár ay. ");
INSERT INTO bcc_vpl VALUES ("PS104_4","020_104_4","PSA","104","4","4","Gwátán wati káseda kanay o ásay bránzá wati hezmatkár. ");
INSERT INTO bcc_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Taw zemin áiay bonredáni sará ér kortag ke hechbar soreta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Taw zemin gón ápáni johlánkián póshéntag, kabáhéay dhawlá, áp kóháni sarborá óshtát. ");
INSERT INTO bcc_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Áp cha tai neherrán jestant, cha tai grandáni tawárá bálesh kort, ");
INSERT INTO bcc_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","8","kóháni sará tatkant o dém pa daragán shotant, dém pa hamá jágahá ke taw pa áyán gisshéntagat. ");
INSERT INTO bcc_vpl VALUES ("PS104_9","020_104_9","PSA","104","9","9","Taw anchén hadd o simsaré gisshént ke áp cha ódá gwasta nakant o nun dega baré zeminá nagipt o napóshit. ");
INSERT INTO bcc_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Taw chammag parmátant ke daragán áp berombénant o kóháni nyámá tachán bebant. ");
INSERT INTO bcc_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Gyábánay hamok jánwará ápa dayant, wahshién har wati tonná próshant. ");
INSERT INTO bcc_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","12","Báli morg chammagáni kashá kodóha bandant o drachkáni sháharháni nyámá sawta janant. ");
INSERT INTO bcc_vpl VALUES ("PS104_13","020_104_13","PSA","104","13","13","Taw cha wati borzi bán o bárgáhá kóhán ápa dayay o zemin cha tai káráni bar o samará séra bit. ");
INSERT INTO bcc_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","14","Taw pa dalwatán káha ródénay o sabzag ke ensán kesht o keshár bekant o cha zeminá warák dar bekant, ");
INSERT INTO bcc_vpl VALUES ("PS104_15","020_104_15","PSA","104","15","15","sharáb ke mardomay delá shát bekant o rógen ke áyáni démá rozhná bekant o nán ke ensánay delá zórmand bekant. ");
INSERT INTO bcc_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Hodáwanday drachk séráp ant, Lobnánay gazz ke áiá keshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Morg hamódá kodóha bandant o kunj sanóbarén drachkáni sará jágaha kanant. ");
INSERT INTO bcc_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Borzén kóh wahshién bozánig ant o talár, rijgushkáni panáhgáh ant. ");
INSERT INTO bcc_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Taw máh pa wahdáni neshán kanagá addh kort o róch wati ér nendagay wahdá zánt. ");
INSERT INTO bcc_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Taháriá ke káray, shapa bit o jangalay sajjahén jánwar soragá laggant. ");
INSERT INTO bcc_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Shér pa wati shekárá gorrant o wati waráká cha Hodáyá lóthant. ");
INSERT INTO bcc_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Róch ke dara kayt, pera tarrant o wati hóndháni tahá áráma kanant. ");
INSERT INTO bcc_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Á wahdá mardom wati kárána rawant o tán bégáhá zahmata kasshant. ");
INSERT INTO bcc_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Oo Hodáwand! Tai kár chinkadar báz ant, taw, é sajjahén pa hekmat addh kortagant, zemin cha tai jórh kortagénán porr ent. ");
INSERT INTO bcc_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Daryá ent ke práh o sháegán ent o cha sahdárá sarréch, kasán o mazanéná. ");
INSERT INTO bcc_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Bójiga rawant o káyant o mazanén ápi jánwar ham, ke taw jórh kortagant ke ápay tahá gwázi bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Sajjahénáni chamm tará sakk ant, ke áyáni waráká pa wahd bedayay. ");
INSERT INTO bcc_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Taw ke dayayesh, áesh yakjáha kanant, taw ke wati dastá pacha kanay, é cha sharrén chizzán séra bant. ");
INSERT INTO bcc_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Taw ke wati démá chéra dayay, é paréshána bant o sarsara janant, esháni sáhá ke pacha geray merant o háká pera tarrant. ");
INSERT INTO bcc_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Wati ruhá ke déma dayay é addha bant. Zeminay sarborá nók o tázaga kanay. ");
INSERT INTO bcc_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Hodáwanday shán tán abad bemánát, Hodáwand cha wati kárán shádmán bát. ");
INSERT INTO bcc_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Hamá ke zeminá chárit, zemina larzit, kóhán ke dasta jant, dutta bant. ");
INSERT INTO bcc_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Man wati sajjahén zendá pa Hodáwandá sawta janán, tánke zendag án, wati Hodáyá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Mani pegr o hayál áiá pasond bátant ke man áiay bárgáhá shádmánia kanán. ");
INSERT INTO bcc_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Bale gonahkár cha zeminá gár o gomsár bátant o badkár pasht makapátant. Hodáwandá benázén, oo mani arwáh! Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Hodáwanday shográ begerét o hamáiay námá begerét, kawmán cha áiay kárán sahig kanét. ");
INSERT INTO bcc_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Áiá benázénét, áiá pa sawt benázénét, áiay sajjahén bákamálén káráni habará bekanét. ");
INSERT INTO bcc_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Áiay pákén námay sará pahr bekanét, Hodáwanday shóház kanókáni del shádmán bát. ");
INSERT INTO bcc_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Hodáwand o áiay zór o wákay lóthók bebét, modám áiay chehragay didáray shóházá bebét. ");
INSERT INTO bcc_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","5","Áiay kortagén bákamálén kárán yát kanét, áiay mójezah o dátagén hokmán, ");
INSERT INTO bcc_vpl VALUES ("PS105_6","020_105_6","PSA","105","6","6","oo áiay hezmatkárén Ebráhémay nasl, oo Ákubay chokkán ke áiay gechén kortagén ét! ");
INSERT INTO bcc_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Á, Hodáwand may Hodá ent. Áiay dádrasi sajjahén jaháná rasant. ");
INSERT INTO bcc_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","8","Á wati ahd o paymáná tán abad yáta kant, hamá labz ke áiá gón hazár naslá kort, ");
INSERT INTO bcc_vpl VALUES ("PS105_9","020_105_9","PSA","105","9","9","hamá ahd ke gón Ebráhémá korti o hamá sawgend ke gón Esáká wárti, ");
INSERT INTO bcc_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","10","gón Ákubá karáré bast o pakkái kort, gón Esráilá, abadmánén ahdé. ");
INSERT INTO bcc_vpl VALUES ("PS105_11","020_105_11","PSA","105","11","11","“Kanhánay sardhagárá tará bakshán, ke shomay bahr o mirása bit.” ");
INSERT INTO bcc_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Á wahdá ke é kammok mardom atant, kammok atant o darámad, ");
INSERT INTO bcc_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","é kawm o á kawmay nyámá darpadar atant, é molk o á molká gashtant. ");
INSERT INTO bcc_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Kassá áyáni sará zolm kanagi naesht, pa áyánigi, áiá bádsháh neherr dátant: ");
INSERT INTO bcc_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Mani ‘rógen per moshtagénán’ dast per makanét o mani nabián noksán madayét.” ");
INSERT INTO bcc_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Zeminá dhokkáli ér áwort o áyáni nánay ambári próshtant. ");
INSERT INTO bcc_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Áyáni démá mardomé rawáni dát, Issop, ke goláméay hesábá bahá kanag but. ");
INSERT INTO bcc_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Áiay pádesh pa band o zamzil thappig kortant o ásenén tawké gotthá dátesh, ");
INSERT INTO bcc_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","tán hamá wahdá ke áiay habar rást butant, Hodáay habará áiay rásti pakká kort. ");
INSERT INTO bcc_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Bádsháhá Issop lóthet o ázát kort, mardománi hákemá ázát kort. ");
INSERT INTO bcc_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Bádsháhá wati lógay master kort, wati sajjahén mál o melkatay hákem, ");
INSERT INTO bcc_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","ke bádsháhay kárendahán wati tabá adab bekant o kamáshán dánáiay tálimá bedant. ");
INSERT INTO bcc_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Nun Esráil Mesrá átk, Ákub, Hámay sardhagárá pa darámadi jahmenend but. ");
INSERT INTO bcc_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Wati mahluki ábád o cha áyáni dozhmenán zóráwarter kortant. ");
INSERT INTO bcc_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Dozhmenáni deli gardént tán cha áiay kawmá naprat bekanant o áiay hezmatkáráni helápá pandal besázant. ");
INSERT INTO bcc_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Áiá wati hezmatkárén Mussá rawán dát o Hárun, ke wat gechéni kortagat. ");
INSERT INTO bcc_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Eshán mardománi nyámá Hodáay ajabbatén nesháni o áiay mójezah pésh dáshtant, Hámay sardhagárá. ");
INSERT INTO bcc_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Áiá tahári rawán dát o zemin tahár kort, áiay habaray náparmániesh nakortagat. ");
INSERT INTO bcc_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Áyáni ápi hón kort o máhigi koshtant. ");
INSERT INTO bcc_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Sardhagáresh cha pogolá porr but ke tán áyáni bádsháhi wábjáhán sar butant. ");
INSERT INTO bcc_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Áiá habar kort o makeskáni lashkar átkant o passhag áyáni sajjahén molká mán retk. ");
INSERT INTO bcc_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Hawray badalá tróngali gwárént, ás o bir, áyáni sajjahén sarzaminá. ");
INSERT INTO bcc_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Áyáni angur o enjiray drachki tabáh kortant o molkay drachki próshtant. ");
INSERT INTO bcc_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Hokmi kort o madag átkant, kathag, béhesábá. ");
INSERT INTO bcc_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Áyáni molkay sajjahén sabzagesh wártant o hákay sajjahén bar o samaresh ér bort. ");
INSERT INTO bcc_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Nun áyáni sajjahén awali chokki jatant áyáni mardánagiay awali bar o samar. ");
INSERT INTO bcc_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Wati mardomi zarr o sohrá bár kort o dhanná áwortant o cha áyáni kabilahán kassá thagal nawárt. ");
INSERT INTO bcc_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Mesr cha Bani Esráilay rawagá gal but, chéá ke áyáni torsá gár at. ");
INSERT INTO bcc_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Áiá jambaré sáhél kort o póshéntant, ásé róki kort ke shapá rozhnáiesh bedant. ");
INSERT INTO bcc_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Áyán lóthet o Hodáwandá baynkuén morg rawán dát o ái gón ásmáni naganá sér kortant. ");
INSERT INTO bcc_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","41","Taláré tali dát o áp rawán but, gyábáná kawré tatk. ");
INSERT INTO bcc_vpl VALUES ("PS105_42","020_105_42","PSA","105","42","42","Chéá ke wati pákén kawli yát at ke gón wati hezmatkárén Ebráhémá kortagati. ");
INSERT INTO bcc_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","Áiá wati kawm pa shádmáni dhanná áwort, wati gechén kortagén, gón shádehiay kukkárán. ");
INSERT INTO bcc_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","44","Áyáná rájáni sardhagári dát o á, kawmáni kortagén mehnatáni málek butant, ");
INSERT INTO bcc_vpl VALUES ("PS105_45","020_105_45","PSA","105","45","45","ke áiay rahbandáni randgiriá bekanant o áiay Sharyatay hokmáni sará kár bekanant. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS106_1","020_106_1","PSA","106","1","1","Hodáwandá benázénét, Halléluyá. Hodáwanday shográ begerét ke nék ent o mehri abadmán. ");
INSERT INTO bcc_vpl VALUES ("PS106_2","020_106_2","PSA","106","2","2","Kay Hodáwanday porwákén káráni tawsip o áiay tamánén satá o sanáyá korta kant? ");
INSERT INTO bcc_vpl VALUES ("PS106_3","020_106_3","PSA","106","3","3","Bahtáwar ant hamá ke adlá barjáh dárant, hamá ke modám ensápay sará kára kanant. ");
INSERT INTO bcc_vpl VALUES ("PS106_4","020_106_4","PSA","106","4","4","Oo Hodáwand! Hamá wahdá ke wati mardománi sará rahma kanay, maná mashamósh. Mani kerrá byá o maná berakkén ");
INSERT INTO bcc_vpl VALUES ("PS106_5","020_106_5","PSA","106","5","5","ke tai gechén kortagénáni washbahtiá begendán, ke tai kawmay shádmániá hawár bebán o tai mahlukay hamráhiá pahr bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS106_6","020_106_6","PSA","106","6","6","Má gonáh kortag, may petán ham, má radén ráhé zortag o badkári kortag. ");
INSERT INTO bcc_vpl VALUES ("PS106_7","020_106_7","PSA","106","7","7","Á wahdá ke may pet o pirok Mesrá atant, tai hayrán kanókén káráni némagá delgóshesh nakort o tai sajjahén mehrabániesh shamoshtant, daryáay kerrá sarkasshiesh kort, Sohrzeray kerrá. ");
INSERT INTO bcc_vpl VALUES ("PS106_8","020_106_8","PSA","106","8","8","Bale Hodáwandá pa wati námaygi rakkéntant, tánke wati zór o wáká záher bekant. ");
INSERT INTO bcc_vpl VALUES ("PS106_9","020_106_9","PSA","106","9","9","Áiá Sohrzer neherr dát o zer hoshk but, cha johlánkián anchosh gwázéntanti ke purah gyábáné. ");
INSERT INTO bcc_vpl VALUES ("PS106_10","020_106_10","PSA","106","10","10","Cha badwáháni dastá rakként o cha dozhmenáni dastá móketanti. ");
INSERT INTO bcc_vpl VALUES ("PS106_11","020_106_11","PSA","106","11","11","Ápá, áyáni dozhmen póshént, cha áyán yakké ham pasht nakapt. ");
INSERT INTO bcc_vpl VALUES ("PS106_12","020_106_12","PSA","106","12","12","Nun Hodáwanday labzay sará báwaresh kort o áiay satá o sanáesh kort. ");
INSERT INTO bcc_vpl VALUES ("PS106_13","020_106_13","PSA","106","13","13","Bale zutt béhayál butant ke áiá ché kortagat o pa áiay shawr o saláhá wadáresh nakort. ");
INSERT INTO bcc_vpl VALUES ("PS106_14","020_106_14","PSA","106","14","14","Gyábáná wati hawá o hawasáni randgir butant o hoshkáwagán Hodáesh chakkáset. ");
INSERT INTO bcc_vpl VALUES ("PS106_15","020_106_15","PSA","106","15","15","Gorhá harché ke lóthetesh, Hodáyá dátant, bale áyáni jáná warókén nádráhié ham dáti. ");
INSERT INTO bcc_vpl VALUES ("PS106_16","020_106_16","PSA","106","16","16","Ordgáhá, Mussáay sará hasaddesh kort o Hárunay sará ham, ke Hodáwanday palgártagén dini péshwá at. ");
INSERT INTO bcc_vpl VALUES ("PS106_17","020_106_17","PSA","106","17","17","Gorhá zeminá dap pach kort o Dátán éri bort o Abirámay thóli bári dát. ");
INSERT INTO bcc_vpl VALUES ("PS106_18","020_106_18","PSA","106","18","18","Áyáni thóliá ásé mán kapt o bránzán badkár sótkant. ");
INSERT INTO bcc_vpl VALUES ("PS106_19","020_106_19","PSA","106","19","19","Sináay kóhá gwaské jórhesh kort o ásá táptagén teláhén botesh parastesh kort. ");
INSERT INTO bcc_vpl VALUES ("PS106_20","020_106_20","PSA","106","20","20","Wati mazanshánén Hodáay badalá káhwárén jalabén gókéay botesh zort. ");
INSERT INTO bcc_vpl VALUES ("PS106_21","020_106_21","PSA","106","21","21","Wati rakkénókén Hodáesh shamosht, hamá ke Mesrá mazanén kári kortagat. ");
INSERT INTO bcc_vpl VALUES ("PS106_22","020_106_22","PSA","106","22","22","Hámay sardhagárá hayrán kanókén o Sohrzeray kerrá bákamálén kári kortagat. ");
INSERT INTO bcc_vpl VALUES ("PS106_23","020_106_23","PSA","106","23","23","Gorhá Hodáyá gwasht: “Gár o gomsáresha kanán.” Bale áiay gechén kortagén Mussá nyámá kapt o pa áyáni tabáh kanagá Hodáay gazabi dásht. ");
INSERT INTO bcc_vpl VALUES ("PS106_24","020_106_24","PSA","106","24","24","Á delkasshén molkay arzesh o kadresh nazánt, áiay kawlay sará báwaresh néstat. ");
INSERT INTO bcc_vpl VALUES ("PS106_25","020_106_25","PSA","106","25","25","Wati gedánáni tahá norondhetesh o Hodáwanday habaresh nazort. ");
INSERT INTO bcc_vpl VALUES ("PS106_26","020_106_26","PSA","106","26","26","Gorhá dasti chest kort o sawgendi wárt ke gyábáná tabáhesha kanán o ");
INSERT INTO bcc_vpl VALUES ("PS106_27","020_106_27","PSA","106","27","27","chokk o nomásagánesh darkawmáni nyámá gár o gomsára kanán o sajjahén molkán sheng o shángesha kanán. ");
INSERT INTO bcc_vpl VALUES ("PS106_28","020_106_28","PSA","106","28","28","Áyán watárá gón Bahal Péórá jog kort o pa mordagán kortagén korbánigesh wártant. ");
INSERT INTO bcc_vpl VALUES ("PS106_29","020_106_29","PSA","106","29","29","Gón wati badkárián Hodáwandesh zahr baráént, hawp o wabáé saráesh kapt. ");
INSERT INTO bcc_vpl VALUES ("PS106_30","020_106_30","PSA","106","30","30","Bale Pinihás nyámá óshtát o dwái kort o wabá dárag but. ");
INSERT INTO bcc_vpl VALUES ("PS106_31","020_106_31","PSA","106","31","31","É pa áiá páki o palgárié hesáb árag but nasláni nasl, tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS106_32","020_106_32","PSA","106","32","32","Maribáay ápáni kerrá Hodáwandesh hezhm geráént o áyáni sawabá Mussá janjálá kapt, ");
INSERT INTO bcc_vpl VALUES ("PS106_33","020_106_33","PSA","106","33","33","chéá ke Mussáesh delsyáh kort o cha áiay dapá sobakkén habaré dar átk. ");
INSERT INTO bcc_vpl VALUES ("PS106_34","020_106_34","PSA","106","34","34","Kawmesh á paymá tabáh nakortant ke Hodáwandá parmán dátagatant. ");
INSERT INTO bcc_vpl VALUES ("PS106_35","020_106_35","PSA","106","35","35","Nun gón kawmán hór o tór but o hamáyáni rasm o dódesh zortant. ");
INSERT INTO bcc_vpl VALUES ("PS106_36","020_106_36","PSA","106","36","36","Hamáyáni botesh sojdaha kortant o é bot pa áyán dámé butant. ");
INSERT INTO bcc_vpl VALUES ("PS106_37","020_106_37","PSA","106","37","37","Wati bachakk o jenekkesh pa déhán korbániga kortant. ");
INSERT INTO bcc_vpl VALUES ("PS106_38","020_106_38","PSA","106","38","38","Bégonáhén hónesha rétk wati bachakk o jenekkáni hón, ke pa Kanhánay botán korbánigesha kortant o zemin cha esháni hóná áludag but. ");
INSERT INTO bcc_vpl VALUES ("PS106_39","020_106_39","PSA","106","39","39","Gón wati kárán watá nápák o gón wati kerdán watá syahkáresha kort. ");
INSERT INTO bcc_vpl VALUES ("PS106_40","020_106_40","PSA","106","40","40","Paméshká, Hodáwand wati kawmay sará zahr gept, deli cha wati mirásá bad but. ");
INSERT INTO bcc_vpl VALUES ("PS106_41","020_106_41","PSA","106","41","41","Darkawmáni dastá dátanti o badwáhán áyáni sará hákemi kort. ");
INSERT INTO bcc_vpl VALUES ("PS106_42","020_106_42","PSA","106","42","42","Dozhmenán áyáni sará zolm kort o wati chérdast kortant. ");
INSERT INTO bcc_vpl VALUES ("PS106_43","020_106_43","PSA","106","43","43","Hodáwandá báz bará ázát kortant bale wati shawr o hayáláni tahá sarkasshiesh kort o gonáháni tahá bokketant. ");
INSERT INTO bcc_vpl VALUES ("PS106_44","020_106_44","PSA","106","44","44","Bale wahdé ke áyáni peryáti eshkot, disti ke chón paréshán ant, ");
INSERT INTO bcc_vpl VALUES ("PS106_45","020_106_45","PSA","106","45","45","gón áyán wati ahd o karári yát kort o cha wati bázén mehrá, cha áyáni badián sar gwast. ");
INSERT INTO bcc_vpl VALUES ("PS106_46","020_106_46","PSA","106","46","46","Áyáni sajjahén bandig kanókáni delá pa áyán rahmi pédá kort. ");
INSERT INTO bcc_vpl VALUES ("PS106_47","020_106_47","PSA","106","47","47","Oo Hodáwand, may Hodá! Márá berakkén, márá cha darkawmáni nyámá chen o yakjáh kan ke tai pákén námay shográ begerén o pa tai satáyá pahr bekanén. ");
INSERT INTO bcc_vpl VALUES ("PS106_48","020_106_48","PSA","106","48","48","Hodáwandá satá o saná bát, Esráilay Hodáyá, abad tán abad. Sajjahén mardom begwashátant: “Anchosh bát. Ámin.” Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS107_1","020_107_1","PSA","107","1","1","Hodáwanday shográ begerét ke nék ent o mehri abadmán. ");
INSERT INTO bcc_vpl VALUES ("PS107_2","020_107_2","PSA","107","2","2","Hodáwanday rakkéntagén habar bekanátant, hamá ke cha dozhmenáni dastá rakkéntaganti, ");
INSERT INTO bcc_vpl VALUES ("PS107_3","020_107_3","PSA","107","3","3","hamá ke cha bázén sardhagárán zortag o yakjáhi kortagant, cha shagreb o magreb, cha shomál o jonubá. ");
INSERT INTO bcc_vpl VALUES ("PS107_4","020_107_4","PSA","107","4","4","Lahtén, jangal o gyábánán sargardán but o pa choshén shahréá ráhé nadistesh ke jahmenend bebant. ");
INSERT INTO bcc_vpl VALUES ("PS107_5","020_107_5","PSA","107","5","5","Gozhnag o tonnig mantant, markig butant. ");
INSERT INTO bcc_vpl VALUES ("PS107_6","020_107_6","PSA","107","6","6","Nun sakkiáni tahá Hodáwanday gwará peryátesh kort o áiá cha sakkián rakkéntant. ");
INSERT INTO bcc_vpl VALUES ("PS107_7","020_107_7","PSA","107","7","7","Áiá cha tachkén ráhéá rahshóni kortant, dém pa shahréá ke ódá jahmenend bebant. ");
INSERT INTO bcc_vpl VALUES ("PS107_8","020_107_8","PSA","107","8","8","Hodáwanday shográ begerátant, áiay mehr o pa baniádamá áiay bákamálén káráni sawabá. ");
INSERT INTO bcc_vpl VALUES ("PS107_9","020_107_9","PSA","107","9","9","Hamá ent ke tonnigán sérápa kant o gozhnagán cha sharrén waráká sérláp. ");
INSERT INTO bcc_vpl VALUES ("PS107_10","020_107_10","PSA","107","10","10","Tahárterén tahárián neshtagatant, ásenén zamziláni bandig o azáb atant ");
INSERT INTO bcc_vpl VALUES ("PS107_11","020_107_11","PSA","107","11","11","ke Hodáay habaráni helápá sarkasshiesh kortagat o borzén arshay Hodáay sar o sójesh kalág bastagatant. ");
INSERT INTO bcc_vpl VALUES ("PS107_12","020_107_12","PSA","107","12","12","Gorhá zahmatkasshiay sará dát o áyáni goruri prósht, thagalesh wárt o madat kanókesh néstat. ");
INSERT INTO bcc_vpl VALUES ("PS107_13","020_107_13","PSA","107","13","13","Nun sakki o sóriáni tahá gón Hodáwandá peryátesh kort o áiá cha janjálán rakkéntant. ");
INSERT INTO bcc_vpl VALUES ("PS107_14","020_107_14","PSA","107","14","14","Cha tahárterén tahárián dari kortant o áyáni zamzili próshtant. ");
INSERT INTO bcc_vpl VALUES ("PS107_15","020_107_15","PSA","107","15","15","Hodáwanday shográ begerátant, áiay mehr o pa baniádamá áiay bákamálén káráni sawabá ");
INSERT INTO bcc_vpl VALUES ("PS107_16","020_107_16","PSA","107","16","16","ke brenjén darwázagi próshtant o ásenén bandi goddhetant. ");
INSERT INTO bcc_vpl VALUES ("PS107_17","020_107_17","PSA","107","17","17","Cha wati sarkasshiá ahmak butant o wati gonáháni sawabá sakki o sórián kaptant. ");
INSERT INTO bcc_vpl VALUES ("PS107_18","020_107_18","PSA","107","18","18","Warákesh gotthá éra nashot o markay darwázagá rasetant. ");
INSERT INTO bcc_vpl VALUES ("PS107_19","020_107_19","PSA","107","19","19","Nun sakki o sóriáni tahá gón Hodáwandá peryátesh kort o áiá cha janjálán rakkéntant. ");
INSERT INTO bcc_vpl VALUES ("PS107_20","020_107_20","PSA","107","20","20","Wati hokmi ráh dát o dráhi kortant o cha kall o kaddhá rakkéntanti. ");
INSERT INTO bcc_vpl VALUES ("PS107_21","020_107_21","PSA","107","21","21","Hodáwanday shográ begerátant, áiay mehr o pa baniádamá áiay bákamálén káráni sawabá. ");
INSERT INTO bcc_vpl VALUES ("PS107_22","020_107_22","PSA","107","22","22","Shogrgozáriay korbánig bekanátant o gón shádmániay sawtán áiay káráni kessahá byárátant. ");
INSERT INTO bcc_vpl VALUES ("PS107_23","020_107_23","PSA","107","23","23","Hamá ke gón bójigán daryáyá shotant, hamá ke ápáni sará sawdágeriesh kort, ");
INSERT INTO bcc_vpl VALUES ("PS107_24","020_107_24","PSA","107","24","24","Hodáwanday káresh distant, mán johlánkián áiay hayrán kanókén kár. ");
INSERT INTO bcc_vpl VALUES ("PS107_25","020_107_25","PSA","107","25","25","Áiá habar kort o tuppánén gwáté átk o daryáay chawli chest kortant. ");
INSERT INTO bcc_vpl VALUES ("PS107_26","020_107_26","PSA","107","26","26","Bójig borzád tán arshá shotant o jahlád tán johlánkián kaptant o cha janjálá áyáni arwáh áp but. ");
INSERT INTO bcc_vpl VALUES ("PS107_27","020_107_27","PSA","107","27","27","Sharábiáni paymá tattarag o thagal waragá laggetant o áyáni sajjahén ezm o honar gár but. ");
INSERT INTO bcc_vpl VALUES ("PS107_28","020_107_28","PSA","107","28","28","Nun sakki o sóriáni tahá gón Hodáwandá peryátesh kort o áiá cha janjálán rakkéntant. ");
INSERT INTO bcc_vpl VALUES ("PS107_29","020_107_29","PSA","107","29","29","Tuppáni érmósh kort o daryáay chawl neshtant. ");
INSERT INTO bcc_vpl VALUES ("PS107_30","020_107_30","PSA","107","30","30","Tuppán ke ér nesht, gal butant, dém pa hamá tayábá rashónii kortant ke wat rawagesh lóthet. ");
INSERT INTO bcc_vpl VALUES ("PS107_31","020_107_31","PSA","107","31","31","Hodáwanday shográ begerátant, áiay mehr o pa baniádamá áiay bákamálén káráni sawabá. ");
INSERT INTO bcc_vpl VALUES ("PS107_32","020_107_32","PSA","107","32","32","Mardománi mocchiá áiá satá bekanátant o kamásháni majlesá tawsip. ");
INSERT INTO bcc_vpl VALUES ("PS107_33","020_107_33","PSA","107","33","33","Á kawrán gyábána kant, tachókén chammagán, hoshkáwagén zemin o ");
INSERT INTO bcc_vpl VALUES ("PS107_34","020_107_34","PSA","107","34","34","kesht o keshári zeminán sorága kant, óday jahmenendáni badkáriay sawabá. ");
INSERT INTO bcc_vpl VALUES ("PS107_35","020_107_35","PSA","107","35","35","Gyábánán gwarma kant o hoshkén zeminán, tachókén chammag. ");
INSERT INTO bcc_vpl VALUES ("PS107_36","020_107_36","PSA","107","36","36","Shodigi áwort o hamódá jahmenend kortant o áyán shahré ábád kort o neshtant. ");
INSERT INTO bcc_vpl VALUES ("PS107_37","020_107_37","PSA","107","37","37","Áyán dhagár kesht o anguri bág ábád kort ke báz bar o samaresh dát. ");
INSERT INTO bcc_vpl VALUES ("PS107_38","020_107_38","PSA","107","38","38","Áiá barkat dátant o á sakk báz géshter butant, naeshti ke dalwatesh kamm bebant. ");
INSERT INTO bcc_vpl VALUES ("PS107_39","020_107_39","PSA","107","39","39","Nun á kamm tarrán o wár o zár butant, cha ázár o janjál o gamá. ");
INSERT INTO bcc_vpl VALUES ("PS107_40","020_107_40","PSA","107","40","40","Hamá ke sharapdárán bésharapa kant, ái zort o béráhén gyábánán darpadar kortant. ");
INSERT INTO bcc_vpl VALUES ("PS107_41","020_107_41","PSA","107","41","41","Bale hájatmandi cha sakkián dar kortant, áyáni kahóli ramagáni paymá báz kortant. ");
INSERT INTO bcc_vpl VALUES ("PS107_42","020_107_42","PSA","107","42","42","Nékdelesha gendant o shádmánia kanant o har badkár wati dapá banda kant. ");
INSERT INTO bcc_vpl VALUES ("PS107_43","020_107_43","PSA","107","43","43","Harkas ke dáná ent, é kárán bechárit o Hodáwanday pormehrén káráni sará sharriá pegr bekant. ");
INSERT INTO bcc_vpl VALUES ("PS108_1","020_108_1","PSA","108","1","1","Sawté. Dáuday Zabur. Mani del jam ent, oo Hodá! Cha delay johlánkiá sawta janán o tará názénán. ");
INSERT INTO bcc_vpl VALUES ("PS108_2","020_108_2","PSA","108","2","2","Oo soróz o changán! Ágah bét. Man bámgwáhárá ham cha wábá páda kanán. ");
INSERT INTO bcc_vpl VALUES ("PS108_3","020_108_3","PSA","108","3","3","Kawmáni nyámá tai shográ gerán, oo Hodáwand! Darkawmáni nyámá tará názénán, ");
INSERT INTO bcc_vpl VALUES ("PS108_4","020_108_4","PSA","108","4","4","ke tai mehr báz ent, cha ásmánán borzter, tai wapádári tán jambarán ent. ");
INSERT INTO bcc_vpl VALUES ("PS108_5","020_108_5","PSA","108","5","5","Oo Hodá! Ásmánáni sarborá tai mazansháni názénag bát o sajjahén zeminá tai shán o shawkat sar bát. ");
INSERT INTO bcc_vpl VALUES ("PS108_6","020_108_6","PSA","108","6","6","Gón wati rástén dastá berakkén o maná passaw beday tánke hamá mardom berakkant ke tará dóst ant. ");
INSERT INTO bcc_vpl VALUES ("PS108_7","020_108_7","PSA","108","7","7","Hodáyá cha wati pákiá habar kortag: “Sóbéna bán o Shekémá bahra kanán o Sukkótay daragá pa wat kadd o kesása kanán. ");
INSERT INTO bcc_vpl VALUES ("PS108_8","020_108_8","PSA","108","8","8","Galyád manig ent o Manassi manig, Epráim mani jangi koláh ent, Yahudá, bádsháhiay asá o ");
INSERT INTO bcc_vpl VALUES ("PS108_9","020_108_9","PSA","108","9","9","Muáb dasshódi trasht, Edumay sará wati swásá chagala dayán o Pilistiahay sará wati péróziay gwánká janán.” ");
INSERT INTO bcc_vpl VALUES ("PS108_10","020_108_10","PSA","108","10","10","Kay maná pasilbandén shahrá kárit? Kay tán Edumá mani rahshóna bit? ");
INSERT INTO bcc_vpl VALUES ("PS108_11","020_108_11","PSA","108","11","11","Oo Hodá! Taw hamá naay ke márá yalahet kortag? Nun gón may lashkarán hamráha nabay? ");
INSERT INTO bcc_vpl VALUES ("PS108_12","020_108_12","PSA","108","12","12","May dozhmenáni démá márá madat kan, ke ensánay komakk náhudag ent. ");
INSERT INTO bcc_vpl VALUES ("PS108_13","020_108_13","PSA","108","13","13","Hodá ke gón ent, sóbéna bén, hamá ent ke may dozhmenán pádmála kant. ");
INSERT INTO bcc_vpl VALUES ("PS109_1","020_109_1","PSA","109","1","1","Pa sázger o washalhánáni sálárá. Dáuday Zabur. Oo mani satáyáni Hodá! Hámósh mabay. ");
INSERT INTO bcc_vpl VALUES ("PS109_2","020_109_2","PSA","109","2","2","Chéá ke badkár o prébkárán mani helápá wati dap pach kortag, gón drógbandén zobánéá mani helápá gappesh jatag. ");
INSERT INTO bcc_vpl VALUES ("PS109_3","020_109_3","PSA","109","3","3","Maná gón napratién habarán chapp o chágerdesh kortag, bésawabá gón man pa jangá pád átkagant. ");
INSERT INTO bcc_vpl VALUES ("PS109_4","020_109_4","PSA","109","4","4","Mani mehray badalá maná bohtámesh jatag, bale man pa áyán nékén dwá kortag. ");
INSERT INTO bcc_vpl VALUES ("PS109_5","020_109_5","PSA","109","5","5","Mani nékiáni badalá gón man badia kanant o mehray badalá naprat. ");
INSERT INTO bcc_vpl VALUES ("PS109_6","020_109_6","PSA","109","6","6","Gwashant: “Badkárén mardoméá eshiay chakká dawr day, bell ke bohtám janóké eshiay rástén némagá óshtit. ");
INSERT INTO bcc_vpl VALUES ("PS109_7","020_109_7","PSA","109","7","7","Wahdé áiay dadrasiá kanant, mayárbár zánag bát o dwái gonáh hesáb bátant. ");
INSERT INTO bcc_vpl VALUES ("PS109_8","020_109_8","PSA","109","8","8","Róchi kammok bátant o áiay ogdah o zemmawári degaréá berasát. ");
INSERT INTO bcc_vpl VALUES ("PS109_9","020_109_9","PSA","109","9","9","Chokki chóraw bátant o jani janózám. ");
INSERT INTO bcc_vpl VALUES ("PS109_10","020_109_10","PSA","109","10","10","Chokki pendhók o darpadar bátant o cha wati proshtagén lógán dar kanag bátant. ");
INSERT INTO bcc_vpl VALUES ("PS109_11","020_109_11","PSA","109","11","11","Wámdári sajjahén mál o hastiá pach gerátant o darámad áiay johdáni bar o samará barátant. ");
INSERT INTO bcc_vpl VALUES ("PS109_12","020_109_12","PSA","109","12","12","Kass pa áiá mehrabán mabát o áiay chórawáni sará bazzag makanát. ");
INSERT INTO bcc_vpl VALUES ("PS109_13","020_109_13","PSA","109","13","13","Padréchi gár bátant o námesh pa démi naslán sar mabát. ");
INSERT INTO bcc_vpl VALUES ("PS109_14","020_109_14","PSA","109","14","14","Áiay pet o pirokáni gonáh Hodáwanday bárgáhá yát kanag bátant, mátay gonáhi hechbar shódag mabátant. ");
INSERT INTO bcc_vpl VALUES ("PS109_15","020_109_15","PSA","109","15","15","Gonáhesh modám Hodáwanday chammáni démá bátant, Hodáwand áyáni yátá cha zeminá gár kanát. ");
INSERT INTO bcc_vpl VALUES ("PS109_16","020_109_16","PSA","109","16","16","Chéá ke á hechbar pa kassá mehrabán nabut, nézgár o hájatmandi ázár dátant o delproshtagéni pa mark raséntant. ");
INSERT INTO bcc_vpl VALUES ("PS109_17","020_109_17","PSA","109","17","17","Nálat kanagi wassha but, áiay wati sará kapátant. Barkat dayagi wassha nabut, hechbar barkati marasát. ");
INSERT INTO bcc_vpl VALUES ("PS109_18","020_109_18","PSA","109","18","18","Nálat kanagi chó pósháká gwará at, ápay paymá áiay jáná ér nesht, rógenay paymá haddháni shot. ");
INSERT INTO bcc_vpl VALUES ("PS109_19","020_109_19","PSA","109","19","19","Nálat kabáhé bát o áiay jendá bepóshát o kamarbandéay paymá modám áiay sréná bandók bát.” ");
INSERT INTO bcc_vpl VALUES ("PS109_20","020_109_20","PSA","109","20","20","Cha Hodáwanday némagá mani bohtám janókáni mozz hamé bát, hamá ke mani helápá badén habara kanant. ");
INSERT INTO bcc_vpl VALUES ("PS109_21","020_109_21","PSA","109","21","21","Bale taw, oo Hodáwand, tahná taw pa wati námaygi mani sará mehrabán bay, cha wati mehray nékiá maná berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS109_22","020_109_22","PSA","109","22","22","Chéá ke man nézgár o hájatmandé án o delon bátená thappig ent. ");
INSERT INTO bcc_vpl VALUES ("PS109_23","020_109_23","PSA","109","23","23","Man chó bégáhi sáhegéá gára bán, chó madagéá chandhaga bán. ");
INSERT INTO bcc_vpl VALUES ("PS109_24","020_109_24","PSA","109","24","24","Cha róchagá kóndhon drahagá ant, jesm o jánon ranjetag o lágar ent. ");
INSERT INTO bcc_vpl VALUES ("PS109_25","020_109_25","PSA","109","25","25","Bohtám janókáni kalági án, maná ke gendant, sará chandhénant. ");
INSERT INTO bcc_vpl VALUES ("PS109_26","020_109_26","PSA","109","26","26","Maná komakk kan, oo Hodáwand, mani Hodá! Pa wati mehraygi maná berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS109_27","020_109_27","PSA","109","27","27","Bell bezánant ke é tai dast ent, ke é kár taw kortag, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS109_28","020_109_28","PSA","109","28","28","Á nálata kanant, bale taw barkat bedayátay. Hamlah ke kanant, sharmendag bátant, bale tai hezmatkár shádmáni bekanát. ");
INSERT INTO bcc_vpl VALUES ("PS109_29","020_109_29","PSA","109","29","29","Mani dozhmenán roswáiay jámag gwará dayag bát o sharmendagiay kabáhá póshénag bátant. ");
INSERT INTO bcc_vpl VALUES ("PS109_30","020_109_30","PSA","109","30","30","Man cha wati zobáná Hodáwanday sakk báz shográ gerán, bázén mardoméay démá áiá satá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS109_31","020_109_31","PSA","109","31","31","Chéá ke hájatmanday rástén némagá óshtit tánke áiá cha dádrasáni hokmá berakkénit. ");
INSERT INTO bcc_vpl VALUES ("PS110_1","020_110_1","PSA","110","1","1","Dáuday Zabur. É Hodáwanday paygám ent pa mani Hodáwandá: “Mani rástén némagá benend tán hamá wahdá ke tai dozhmenán tai pádáni chéray padag o chárchóbahé bekanán.” ");
INSERT INTO bcc_vpl VALUES ("PS110_2","020_110_2","PSA","110","2","2","Hodáwand cha Sahyuná tai zóráwarén asáyá shahára dant o gwashit: “Wati dozhmenáni nyámá hákemi kan.” ");
INSERT INTO bcc_vpl VALUES ("PS110_3","020_110_3","PSA","110","3","3","Á róchá ke taw wati lashkará moccha kanay, tai mardom pa shawké góna bant. Gón pákiay shán o zébáiá tai warná tai gwará káyant, chó ke nód cha bámgwáhay bátená. ");
INSERT INTO bcc_vpl VALUES ("PS110_4","020_110_4","PSA","110","4","4","Hodáwandá sawgend wártag o pashómana nabit, ke: “Taw tán abad dini péshwáé ay, Malkisedikay hesábá.” ");
INSERT INTO bcc_vpl VALUES ("PS110_5","020_110_5","PSA","110","5","5","Hodáwand tai rástén dastá ent, wati gazabay róchá bádsháhána droshit. ");
INSERT INTO bcc_vpl VALUES ("PS110_6","020_110_6","PSA","110","6","6","Kawmán sezá dant, zeminá cha láshá porra kant o sajjahén zeminay hákemána droshit. ");
INSERT INTO bcc_vpl VALUES ("PS110_7","020_110_7","PSA","110","7","7","Ráhá, cha kawréá ápa wárt o sóbéna o sarbolanda bit. ");
INSERT INTO bcc_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","Hodáwandá benázénét, Halléluyá. Cha delay johlánkiá Hodáwanday shográ gerán, nékdeláni diwáná, mocchiay nyámá. ");
INSERT INTO bcc_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Hodáwanday kár mazan ant, harkasay delá ke neshtagant, áyáni sará pa sharri pegra kanant. ");
INSERT INTO bcc_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Áiay kár shándár o porshawkat ant o áiay adl tán abad barjama mánit. ");
INSERT INTO bcc_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Áiá wati bákamálén kár yádgár kortagant, Hodáwand mehrabán o rahm kanók ent. ");
INSERT INTO bcc_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Á hamáyán waráka dant ke áiay torsesh delá ent, wati ahd o karárá tán abad yáta kant. ");
INSERT INTO bcc_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Wati káráni zóri wati kawmárá pésh dáshtag, darkawmáni mirási wati kawmárá dátagant. ");
INSERT INTO bcc_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","7","Áiay dastáni kár rást o pa adl ant o sajjahén rahbandi porehtebár. ");
INSERT INTO bcc_vpl VALUES ("PS111_8","020_111_8","PSA","111","8","8","Abad tán abad mohr o mohkam ant, pa rásti o tachki kanag butagant. ");
INSERT INTO bcc_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Áiá wati kawm móketag, tán abad wati ahd o karári barjam dáshtag. Áiay nám pák o bákamál ent. ");
INSERT INTO bcc_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Hodáwanday tors dánáiay bendát ent. Hamá ke áiay rahbandáni randgiriá kanant, áyán sharrén zántkária rasit. Tán abad satá hamáiayg ent. ");
INSERT INTO bcc_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","Hodáwandá benázénét, Halléluyá. Bahtáwar ent hamá ke Hodáwanday tors áiay delá ent, hamá ke áiay hokmi sakk báz dósta bant. ");
INSERT INTO bcc_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Áiay nasl o óbádag zeminay sará porzóra bant, barkat nékdeláni padréchá rasit. ");
INSERT INTO bcc_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Áiay lóg cha mál o melkatá porra bit o áiay pahrézkári tán abad barjama mánit. ");
INSERT INTO bcc_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Pa nékdelán mán tahárókiá ham rozhna drapshénit, á mehrabán, rahm kanók o ádel ent. ");
INSERT INTO bcc_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Bakshendah o wámdehén mardomay ásar sharra bit, hamá ke wati kárán pa ensápa kant. ");
INSERT INTO bcc_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Chéá ke á hechbar larzénaga nabit, pahrézkárén mardomé tán abad yát kanaga bit. ");
INSERT INTO bcc_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Á cha badén hálána natorsit, deli jam ent, tawkali Hodáwanday sará ent. ");
INSERT INTO bcc_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Áiay del mohr ent, natorsit, néth wati dozhmenáni shekastá gendit. ");
INSERT INTO bcc_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Gón garib o nézgárán béhesáb bakshendah ent, áiay pahrézkári tán abad barjam ent. Áiay kánth pa sháné borz kanaga bit. ");
INSERT INTO bcc_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Badkára gendit o hezhmnáka bit, cha zahrá dantána droshit o ápa bit, badkáray wáhag námoráda bant. ");
INSERT INTO bcc_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","Hodáwandá benázénét, Halléluyá. Benázénét, oo Hodáwanday hezmatkárán! Hodáwanday námá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Hodáwanday námá satá o saná bát, cha annuná tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Mashreká beger tán magrebá, Hodáwanday nám názénag bát. ");
INSERT INTO bcc_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Hodáwand sajjahén kawmáni sará porjalál ent o áiay shán o shawkat cha ásmánán borzter. ");
INSERT INTO bcc_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Kay may Hodáwandén Hodáay dhawlá ent? May Hodá borzád, wati bádsháhi tahtá neshtag. ");
INSERT INTO bcc_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Á jahla bit ke ásmán o zeminá bechárit. ");
INSERT INTO bcc_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","7","Á nézgárá cha háká o hájatmandá cha poráni hákóthá chesta kant. ");
INSERT INTO bcc_vpl VALUES ("PS113_8","020_113_8","PSA","113","8","8","Shahzádagáni nyámá nádénitesh, wati kawmay shahzádagáni nyámá. ");
INSERT INTO bcc_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Santh o béawládén janéná washdel o chokkáni máta kant o áiay lógá ábád. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS114_1","020_114_1","PSA","114","1","1","Wahdé Esráil cha Mesrá dar átk, Ákubay hándán, cha darámadén zobánéay mardománi nyámá, ");
INSERT INTO bcc_vpl VALUES ("PS114_2","020_114_2","PSA","114","2","2","Yahudá Hodáay gechén kortagén o Esráil áiay bádsháhi but. ");
INSERT INTO bcc_vpl VALUES ("PS114_3","020_114_3","PSA","114","3","3","Daryáyá dist o tatk, Ordonay kawr, poshtá kenzet. ");
INSERT INTO bcc_vpl VALUES ("PS114_4","020_114_4","PSA","114","4","4","Kóh chó gwarándhá setth janán butant o jomp chó gwaragá. ");
INSERT INTO bcc_vpl VALUES ("PS114_5","020_114_5","PSA","114","5","5","Oo daryá! Ché but ke taw tatkay? Oo Ordon! Ché but ke taw poshtá kenzetay? ");
INSERT INTO bcc_vpl VALUES ("PS114_6","020_114_6","PSA","114","6","6","Oo kóhán! Ché but ke shomá chó gwarándhá setth jat, shomá chó gwaragá, oo jompán? ");
INSERT INTO bcc_vpl VALUES ("PS114_7","020_114_7","PSA","114","7","7","Belarz, oo zemin! Hodáwanday bárgáhá, Ákubay Hodáay bárgáhá. ");
INSERT INTO bcc_vpl VALUES ("PS114_8","020_114_8","PSA","114","8","8","Áiá talár gwarm kortant, cha ápá porr, mohrén seng ápay chammag. ");
INSERT INTO bcc_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Márá enna, oo Hodáwand! Márá enna, tai námá shán o shawkat berasát, tai mehr o wapádáriay sawabá. ");
INSERT INTO bcc_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","Á dega kawm chéá begwashant: “Esháni Hodá kojá ent?” ");
INSERT INTO bcc_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","May Hodá arshá ent, harché ke áiá wassha bit, hamá kárá kant. ");
INSERT INTO bcc_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Áyáni “hodá” nograh o teláh ant, ensánay dastay jórh kortagén bot. ");
INSERT INTO bcc_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Eshán dap per bale habar korta nakanant, chammesh per bale dista nakanant, ");
INSERT INTO bcc_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","góshesh per bale eshkota nakanant, pónzesh per bale bó cheta nakanant, ");
INSERT INTO bcc_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","dastesh per bale máreta nakanant, pádesh per bale ráh shota nakanant, na cha wati gotthá áwázé kassheta kanant. ");
INSERT INTO bcc_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Harkas ke eshán jórha kant, hamesháni paymá bit o hamá mardom ham ke esháni sará tawkala kant. ");
INSERT INTO bcc_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Oo Esráil! Hodáwanday sará tawkal kan, hamá shomay komakk o espar ent. ");
INSERT INTO bcc_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Oo Hárunay lóg! Hodáwanday sará tawkal kan, hamá shomay komakk o espar ent. ");
INSERT INTO bcc_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Oo Hodátorsán! Hodáwanday sará tawkal kanét, hamá shomay komakk o espar ent. ");
INSERT INTO bcc_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Hodáwandá márá yát kortag o márá barkata dant, Esráilay lógá barkata dant, Hárunay lógá barkata dant. ");
INSERT INTO bcc_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Hamáyán barkata dant ke Hodáwanday tors áyáni delá ent, mazanén o kasánénán, yakk paymá. ");
INSERT INTO bcc_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Hodáwand shomárá géshá cha géshter kanát, shomay jend o chokk, doénán. ");
INSERT INTO bcc_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Hodáwand shomárá barkat dayát, zemin o ásmánay addh kanók. ");
INSERT INTO bcc_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Borzén arsh Hodáwandayg ent o zemini baniádamárá dátag. ");
INSERT INTO bcc_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Mordag Hodáwandá nanázénant, na á mardom ke rawant o bétawára bant. ");
INSERT INTO bcc_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","É má én ke Hodáwandá satá dayén, annun tán abad. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Maná Hodáwand dóst ent ke mani tawári gósh dáshtag, mani peryát o záriay tawár o ");
INSERT INTO bcc_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","wati delgóshi mani némagá tarrént. Tán zendag án, gwánkia janán. ");
INSERT INTO bcc_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Markay sádán patátagatán, kabray tors mani sará kaptagat gam o andóháni bandig atán. ");
INSERT INTO bcc_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Hodáwanday námon gept o gwashton: “Oo Hodáwand! Mani zendá berakkén.” ");
INSERT INTO bcc_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Hodáwand mehrabán o ádel ent, may Hodá, cha mehr o rahmá sarréch. ");
INSERT INTO bcc_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Hodáwand sádahdelén mardomána sambálit, man ke wár o zár atán, maná rakkénti. ");
INSERT INTO bcc_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Padá árám bay, oo mani arwáh, ke Hodáwand pa taw mehrabán butag. ");
INSERT INTO bcc_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Oo Hodáwand! Taw mani arwáh cha marká rakként, mani chamm cha arsán o pád cha lakoshagá ");
INSERT INTO bcc_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","ke Hodáwanday bárgáhá gám bejanán zendagénáni zeminá. ");
INSERT INTO bcc_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Maná báwar at, hamá wahdá ham ke gwashton: “Sakk bazzag án.” ");
INSERT INTO bcc_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Paréshániáni tahá gwashton: “Harkas drógband ent.” ");
INSERT INTO bcc_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","É sajjahén sharri ke Hodáwandá gón man kortagant, esháni badalá chón bedayán? ");
INSERT INTO bcc_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Nejátay pyálahá chesta kanán o Hodáwanday námá tawára kanán. ");
INSERT INTO bcc_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Gón Hodáwandá wati kawlán puraha kanán, áiay sajjahén kawmay démá. ");
INSERT INTO bcc_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Hodáay wapádáráni mark, Hodáwanday démá gránkadr ent. ");
INSERT INTO bcc_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Oo Hodáwand! Man tai hezmatkár án, haw, man tai hezmatkár án, tai móleday chokk, taw maná cha zamzilán ázát kortag. ");
INSERT INTO bcc_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Shogrgozáriay korbánigé tará pésha kanán o Hodáwanday námá gerán. ");
INSERT INTO bcc_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","18","Gón Hodáwandá wati kawlán puraha kanán, áiay sajjahén kawmay démá, ");
INSERT INTO bcc_vpl VALUES ("PS116_19","020_116_19","PSA","116","19","19","Hodáwanday lógay péshgáhá, tai nyámá, oo Urshalim! Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","1","Oo sajjahén kawmán! Hodáwandá benázénét. Oo sajjahén ráján! Áiá satá kanét, ");
INSERT INTO bcc_vpl VALUES ("PS117_2","020_117_2","PSA","117","2","2","ke Hodáwanday mehr pa má sakk báz ent o áiay wapádári abadmán. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS118_1","020_118_1","PSA","118","1","1","Hodáwanday shográ begerét ke nék ent o mehri abadmán. ");
INSERT INTO bcc_vpl VALUES ("PS118_2","020_118_2","PSA","118","2","2","Esráil begwashát: “Áiay mehr abadmán ent.” ");
INSERT INTO bcc_vpl VALUES ("PS118_3","020_118_3","PSA","118","3","3","Hárunay lóg begwashát: “Áiay mehr abadmán ent.” ");
INSERT INTO bcc_vpl VALUES ("PS118_4","020_118_4","PSA","118","4","4","Hodátors begwashátant: “Áiay mehr abadmán ent.” ");
INSERT INTO bcc_vpl VALUES ("PS118_5","020_118_5","PSA","118","5","5","Wati tangián gón Hodáwandá peryáton kort, áiá maná passaw dát o ázát kort. ");
INSERT INTO bcc_vpl VALUES ("PS118_6","020_118_6","PSA","118","6","6","Hodáwand gón man ent, mana natorsán. Ensán maná ché korta kant? ");
INSERT INTO bcc_vpl VALUES ("PS118_7","020_118_7","PSA","118","7","7","Hodáwand gón man ent, mani madat kanók, pa sarperázi dozhmenáni némagá charán. ");
INSERT INTO bcc_vpl VALUES ("PS118_8","020_118_8","PSA","118","8","8","Hodáay kerrá panáh zurag cha ensánay sará tawkal kanagá sharter ent. ");
INSERT INTO bcc_vpl VALUES ("PS118_9","020_118_9","PSA","118","9","9","Hodáay kerrá panáh zurag cha shahzádagáni sará tawkal kanagá sharter ent. ");
INSERT INTO bcc_vpl VALUES ("PS118_10","020_118_10","PSA","118","10","10","Sajjahén kawmán maná angerr kort, bale man Hodáwanday námá prósh dátant. ");
INSERT INTO bcc_vpl VALUES ("PS118_11","020_118_11","PSA","118","11","11","Maná cha har némagá chapp o chágerdesh kort, bale man Hodáwanday námá prósh dátant. ");
INSERT INTO bcc_vpl VALUES ("PS118_12","020_118_12","PSA","118","12","12","Chó bénagmakeská mani sará per retkant, bale chó konthagá, damáná sotkant o man Hodáwanday námá prósh dátant. ");
INSERT INTO bcc_vpl VALUES ("PS118_13","020_118_13","PSA","118","13","13","Maná sakká télánkesh dát ke bekapán, bale Hodáwandá maná komakk kort. ");
INSERT INTO bcc_vpl VALUES ("PS118_14","020_118_14","PSA","118","14","14","Hodáwand mani zór o mani sawt ent, hamá mani rakkénók ent. ");
INSERT INTO bcc_vpl VALUES ("PS118_15","020_118_15","PSA","118","15","15","Pahrézkáráni tambuáni tahá sóbén bayag o shádmániay kukkár ent: “Hodáwanday rástén dastá mazanén káré kortag. ");
INSERT INTO bcc_vpl VALUES ("PS118_16","020_118_16","PSA","118","16","16","Hodáwanday rástén dast chest butag, Hodáwanday rástén dastá mazanén káré kortag.” ");
INSERT INTO bcc_vpl VALUES ("PS118_17","020_118_17","PSA","118","17","17","Mana namerán, zendaga mánán o Hodáwanday kortagén káráni járá janán. ");
INSERT INTO bcc_vpl VALUES ("PS118_18","020_118_18","PSA","118","18","18","Hodáwandá maná sharr adab dát, bale markay dastá nadáti. ");
INSERT INTO bcc_vpl VALUES ("PS118_19","020_118_19","PSA","118","19","19","Adl o rástiay darwázagán pa man pach kan, ke bepoterán o Hodáwanday shográ begerán. ");
INSERT INTO bcc_vpl VALUES ("PS118_20","020_118_20","PSA","118","20","20","Esh ent Hodáwanday darwázag ke pák o pahrézkár cha edá tahá shota kanant. ");
INSERT INTO bcc_vpl VALUES ("PS118_21","020_118_21","PSA","118","21","21","Tai shográ gerán ke taw maná passaw dát, taw mani rakkénók ay. ");
INSERT INTO bcc_vpl VALUES ("PS118_22","020_118_22","PSA","118","22","22","Á seng ke bánbandén ostáyán pasond nakort o nazort, hamá seng bonhesht but. ");
INSERT INTO bcc_vpl VALUES ("PS118_23","020_118_23","PSA","118","23","23","É Hodáwanday kár ent o may chammán bákamál ent. ");
INSERT INTO bcc_vpl VALUES ("PS118_24","020_118_24","PSA","118","24","24","Esh ent hamá róch ke Hodáwandá áwortag, byá pa é róchá gal o shádehia kanén. ");
INSERT INTO bcc_vpl VALUES ("PS118_25","020_118_25","PSA","118","25","25","Oo Hodáwand! Márá berakkén. Oo Hodáwand! Márá sóbén kan. ");
INSERT INTO bcc_vpl VALUES ("PS118_26","020_118_26","PSA","118","26","26","Mobárak bát hamá ke Hodáwanday námá kayt. Cha Hodáwanday lógá shomárá barkata dayén. ");
INSERT INTO bcc_vpl VALUES ("PS118_27","020_118_27","PSA","118","27","27","Hodáwand, Hodá ent, wati nuri may sará drapshéntag. Aiday korbánigá gón korbánjáhay kánthán pa sád bebandét. ");
INSERT INTO bcc_vpl VALUES ("PS118_28","020_118_28","PSA","118","28","28","Taw mani Hodá ay, tai shográ gerán. Taw mani Hodá ay, tará názénán. ");
INSERT INTO bcc_vpl VALUES ("PS118_29","020_118_29","PSA","118","29","29","Hodáwanday shográ begerét ke nék ent o mehri abadmán. ");
INSERT INTO bcc_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Bahtáwar ant hamá ke ráhesh rást ant o HodáwandaySharyatay hesábá gardant. ");
INSERT INTO bcc_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Bahtáwar ant hamá ke Hodáwanday parmánána mannant o pa setk o del áiay shóházá ant, ");
INSERT INTO bcc_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","hamá ke hecch náensápia nakanant o áiay ráhá rawant. ");
INSERT INTO bcc_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Taw wati rahband dátag‌ant ke pa sarjamiá áyáni randgiri kanag bebit. ");
INSERT INTO bcc_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Pa tai hokmáni barjáh dáragá mani ráh mohr o mohkam bátant. ");
INSERT INTO bcc_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Gorhá á wahdá ke tai sajjahén hokmáni némagá chárán, sharmsára nabán. ");
INSERT INTO bcc_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Gón tachkén deléa tai shográ gerán, wahdé tai ádelén parmánán dar barána bán. ");
INSERT INTO bcc_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Tai hokmáni randgiriá kanán maná pahk yalah makan. ");
INSERT INTO bcc_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","Warnáén mardomé chón wati ráhá pák dáshta kant? Gón tai habaray randgiriá. ");
INSERT INTO bcc_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Tará pa setk o del shóháza kanán, maná mayl ke tai hokmáni ráhá yalah bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Man tai habar wati delá ambár kortagant ke tai helápá gonáh makanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","Tará satá bát, oo Hodáwand! Wati hokmán maná sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Man cha tai dapá dar átkagén sajjahén hokmán dape wata gwashán. ");
INSERT INTO bcc_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Cha tai parmánáni mannagá anchó shádána bán ke cha mazanén ganjéá. ");
INSERT INTO bcc_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Tai rahbandáni sará pegra kanán o tai ráhána charán. ");
INSERT INTO bcc_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Cha tai hokmán shádmána bán o tai habará nashamóshán. ");
INSERT INTO bcc_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Wati hezmatkáray sará mehrabán bay tánke zendag bemánán o tai habaray parmánbardáriá bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Mani chammán pach kan ke tai Sharyatay bákamálén chizzán begendán. ");
INSERT INTO bcc_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Man zeminá darámadé án, wati hokmán cha man chér maday. ");
INSERT INTO bcc_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Pa tai hokmán mani arwáh modám zahirán droshtag. ");
INSERT INTO bcc_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Taw gorunákén mardomán hakkala dayay, hamá nálat butagénán ke tai hokmáni ráhá yalaha kanant. ");
INSERT INTO bcc_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Sobakki o kamsharapiá cha man dur kan, chéá ke man tai parmánána mannán. ");
INSERT INTO bcc_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Harchont ke hákem hóra nendant o mani helápá pandala sázant, bale tai hezmatkár, tai hokmáni sará pegra kant. ");
INSERT INTO bcc_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Tai parmán mani shádmáni ant, pa man sój o saláh ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Man hákán waptagán, maná wati labzay hesábá zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Man tará wati ráháni hál dát o taw maná passaw dát. Nun maná wati hokmán sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Maná, wati rahbandáni ráhá sarpad kan o man tai bákamálén káráni sará pegra kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Mani arwáh cha andóhána nálit, maná wati habaray hesábá mohkam kan. ");
INSERT INTO bcc_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Maná cha prébay ráhán dur bedár, mani sará rahm kan o Sharyatá maná beday. ");
INSERT INTO bcc_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Man wapádáriay ráh dar chetag, wati del tai hokmáni mannók kortag. ");
INSERT INTO bcc_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Man gón tai parmánán bandóka bán, oo Hodáwand! Mayl ke sharmsár kanag bebán. ");
INSERT INTO bcc_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Tai hokmáni ráhá maydána kanán, ke taw mani delá dáná kanay. ");
INSERT INTO bcc_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Oo Hodáwand! Wati hokmáni ráhá maná sój day, ke tán áherá bedáránesh. ");
INSERT INTO bcc_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Maná agl o hósh beday ke man tai Sharyatay páband bebán o pa del o setk eshiay randgiriá bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Wati hokmáni ráhá mani rahshón bay, ke mani wasshi hamesháni tahá ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Mani delá dém pa wati parmánán betarrén, mani nap o suttáni katthagay badalá. ");
INSERT INTO bcc_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Mani chammán cha béarzeshén chizzán dur bedár, maná wati ráhán zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Gón wati hezmatkárá kortagén kawlá bedár hamá kawlá ke gón Hodátorsána kanay. ");
INSERT INTO bcc_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Hamá bénangiá dur kan ke maná cha áiá torsit, ke tai hokm nék ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Pa tai rahbandán hodónák án, cha wati adlá maná zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Tai mehr maná sar bát, oo Hodáwand, o hamá neját ham ke taw kawl kortag. ");
INSERT INTO bcc_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Gorhá man hamá mardomán passawa dayán ke maná kalága bandant, chéá ke man tai habaray sará tawkala kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Rástén habará cha mani dapá pach mager, ke mani omét tai hokmáni sará ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Modám tai Sharyatay randgira bán, abad tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Pa ásudagia gardán, ke tai rahbandáni shóházá butagán. ");
INSERT INTO bcc_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","46","Bádsháháni démá tai parmánáni habará kanán o pashal o sharmendaga nabán. ");
INSERT INTO bcc_vpl VALUES ("PS119_47","020_119_47","PSA","119","47","47","Cha tai hokmán shádmán án, ke maná dóst ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Man pa tai hokmáni zuragá wati dast shahár dátagant ke maná dóst ant o tai parmánáni sará pegra kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Gón wati hezmatkárá kortagén kawlá yát kan, ke tai kawl mani omét ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Sakki o sórián mani tasallá hamesh ent, tai kawl maná zendaga dárit. ");
INSERT INTO bcc_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Gorunákén mardom maná dáemá kalága bandant, bale man tai Sharyatá yalaha nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Oo Hodáwand! Maná tai ahdi hokm yát ant o maná cha hameshán tasallá rasit. ");
INSERT INTO bcc_vpl VALUES ("PS119_53","020_119_53","PSA","119","53","53","Badkáráni sawabá hezhmnáka bán, hamáyáni sawabá ke tai Sharyatesh yalah dátag. ");
INSERT INTO bcc_vpl VALUES ("PS119_54","020_119_54","PSA","119","54","54","Tai hokm mani sawt butagant har jágah ke nendók butagán. ");
INSERT INTO bcc_vpl VALUES ("PS119_55","020_119_55","PSA","119","55","55","Oo Hodáwand! Shapán tai námá yáta kanán o tai Sharyatay ráhá bán. ");
INSERT INTO bcc_vpl VALUES ("PS119_56","020_119_56","PSA","119","56","56","Mani ráh hamé butag, tai rahbandáni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_57","020_119_57","PSA","119","57","57","Taw manig ay, oo Hodáwand! Man kawl kortag ke tai habaráni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_58","020_119_58","PSA","119","58","58","Pa del o setk tai chehragay shóházá butagán, mani sará hamá paymá mehrabán bay ke kawlet kortag. ");
INSERT INTO bcc_vpl VALUES ("PS119_59","020_119_59","PSA","119","59","59","Man wati ráh cháretagant o nun dém pa tai parmánán átkagán. ");
INSERT INTO bcc_vpl VALUES ("PS119_60","020_119_60","PSA","119","60","60","Tai hokmáni mannagá eshtápa kanán, déra nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_61","020_119_61","PSA","119","61","61","Harchont ke badkáráni sádán maná patátag, bale tai Sharyatá nashamóshán. ");
INSERT INTO bcc_vpl VALUES ("PS119_62","020_119_62","PSA","119","62","62","Shapnémá páda káyán o tai shográ gerán pa tai ádelén hokmán. ");
INSERT INTO bcc_vpl VALUES ("PS119_63","020_119_63","PSA","119","63","63","Man hamá sajjahénáni sangat án ke tai tors áyáni delá ent, hamá mardománi ke tai rahbandáni randgiriá kanant. ");
INSERT INTO bcc_vpl VALUES ("PS119_64","020_119_64","PSA","119","64","64","Zemin cha tai mehrá porr ent, oo Hodáwand! Wati hokmán maná sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_65","020_119_65","PSA","119","65","65","Pa wati hezmatkárá mehrabán butagay, hamá paymá ke taw kawl kortagat, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS119_66","020_119_66","PSA","119","66","66","Maná zánt o sarpadi sój day ke man tai hokmáni sará tawkala kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_67","020_119_67","PSA","119","67","67","Bazzag bayagá pésar, cha rástén ráhá thagal warán atán, bale nun tai habaray randgir án. ");
INSERT INTO bcc_vpl VALUES ("PS119_68","020_119_68","PSA","119","68","68","Taw nék ay o nékia kanay, wati hokmán maná sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_69","020_119_69","PSA","119","69","69","Harchont ke gorunákén mardomán mani sará drógén bohtám jatag, bale man pa del o setk tai rahbandán barjáha dárán. ");
INSERT INTO bcc_vpl VALUES ("PS119_70","020_119_70","PSA","119","70","70","Esháni del seng o béehsás ant bale man cha tai Sharyatá shádmán án. ");
INSERT INTO bcc_vpl VALUES ("PS119_71","020_119_71","PSA","119","71","71","Sharr but ke sakki o sóriáni tahá kaptán ke tai hokmán dar bort bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_72","020_119_72","PSA","119","72","72","Cha tai dapá dar átkagén Sharyat pa man cha hazárán teláh o nograhá sharter ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_73","020_119_73","PSA","119","73","73","Maná tai dastán addh kort o shekl o dróshom dát, maná agl o hósh beday ke tai hokmán sarpad bebán. ");
INSERT INTO bcc_vpl VALUES ("PS119_74","020_119_74","PSA","119","74","74","Hodátors gón mani gendagá shádmán bátant, ke man wati omét gón tai habará bastag. ");
INSERT INTO bcc_vpl VALUES ("PS119_75","020_119_75","PSA","119","75","75","Oo Hodáwand! Mana zánán ke tai hokm pa adl ant o taw cha wati wapádáriá maná mosibatáni tahá dawr dátag. ");
INSERT INTO bcc_vpl VALUES ("PS119_76","020_119_76","PSA","119","76","76","Tai mehr mani tasallá bát, hamá paymá ke taw gón wati hezmatkárá kawl kortag. ");
INSERT INTO bcc_vpl VALUES ("PS119_77","020_119_77","PSA","119","77","77","Tai rahmat maná sar bátant tán zendag bemánán, ke tai Sharyat mani shádmáni ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_78","020_119_78","PSA","119","78","78","Gorunákén mardom sarjahl o pashal bátant ke watsará mani báposhtá drógesh bastag, bale man tai rahbandáni sará pegra kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_79","020_119_79","PSA","119","79","79","Harkas ke cha taw torsit dém pa man byáyát, hamá mardom ke tai parmánán sarpada bant. ");
INSERT INTO bcc_vpl VALUES ("PS119_80","020_119_80","PSA","119","80","80","Tai hokmáni bárawá mani del bémayár bát tánke sharmendag mabán. ");
INSERT INTO bcc_vpl VALUES ("PS119_81","020_119_81","PSA","119","81","81","Mani arwáh pa hamá nejátá talwasit ke cha tai némagá ent, man wati óst o omét gón tai habará bastag. ");
INSERT INTO bcc_vpl VALUES ("PS119_82","020_119_82","PSA","119","82","82","Mani chamm tai kawlay shóházá kór butagant, gwashán: “Kadi maná tasallá dayay?” ");
INSERT INTO bcc_vpl VALUES ("PS119_83","020_119_83","PSA","119","83","83","Chó mashkéá án ke duttáni tahá hoshk butag, bale tai hokmon nashamoshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS119_84","020_119_84","PSA","119","84","84","Tán kadén tai hezmatkár wadárá bebit? Kadi mani ázár dayókán sezá dayay? ");
INSERT INTO bcc_vpl VALUES ("PS119_85","020_119_85","PSA","119","85","85","Gorunákén mardom pa man kalla kóchant, tai Sharyatay helápá. ");
INSERT INTO bcc_vpl VALUES ("PS119_86","020_119_86","PSA","119","86","86","Tai sajjahén parmán porehtebár ant, maná komakk kan ke mardom maná mopt o náhakká ázára dayant. ");
INSERT INTO bcc_vpl VALUES ("PS119_87","020_119_87","PSA","119","87","87","Maná cha zeminay sará gár o gomsár kanagi atant, bale man tai rahband yalah nadátant. ");
INSERT INTO bcc_vpl VALUES ("PS119_88","020_119_88","PSA","119","88","88","Wati mehray hesábá maná zendag bedár o cha tai dapá dar átkagén hokmáni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_89","020_119_89","PSA","119","89","89","Oo Hodáwand! Tai habar abadmán ent, ásmáná mohr óshtátag. ");
INSERT INTO bcc_vpl VALUES ("PS119_90","020_119_90","PSA","119","90","90","Tai wapádári nasláni nasl barjam ent, taw zemin addh kort o é barjáha mánit. ");
INSERT INTO bcc_vpl VALUES ("PS119_91","020_119_91","PSA","119","91","91","Tai hokm tán róche maróchigá barjáh ant chéá ke sajjahén chizz tai hezmatá kanant. ");
INSERT INTO bcc_vpl VALUES ("PS119_92","020_119_92","PSA","119","92","92","Agan tai Sharyat mani shádmáni mabutén, man mosibatáni tahá gár o gomsár butagatán. ");
INSERT INTO bcc_vpl VALUES ("PS119_93","020_119_93","PSA","119","93","93","Hechbar tai rahbandána nashamóshán, ke taw cha hamesháni wasilahá maná zendag dáshtag. ");
INSERT INTO bcc_vpl VALUES ("PS119_94","020_119_94","PSA","119","94","94","Maná berakkén ke taig án tai rahbandáni shóházá butagán. ");
INSERT INTO bcc_vpl VALUES ("PS119_95","020_119_95","PSA","119","95","95","Badkár mani tabáhiay wadárá ant, bale man tai parmánáni némagá charán. ");
INSERT INTO bcc_vpl VALUES ("PS119_96","020_119_96","PSA","119","96","96","Har kamálá haddé hast, bale tai hokmán haddé nést. ");
INSERT INTO bcc_vpl VALUES ("PS119_97","020_119_97","PSA","119","97","97","Tai Sharyat maná chón dóst ent, sajjahén róchá hameshiay pegrá án. ");
INSERT INTO bcc_vpl VALUES ("PS119_98","020_119_98","PSA","119","98","98","Tai hokm maná cha mani dozhmenán dánátera kanant, ke modám gón man gón ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_99","020_119_99","PSA","119","99","99","Maná cha wati tálim dayókán géshter zánt hast chéá ke tai parmánáni pegrá án. ");
INSERT INTO bcc_vpl VALUES ("PS119_100","020_119_100","PSA","119","100","100","Cha kamáshán zántkárter butagán ke tai rahbandáni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_101","020_119_101","PSA","119","101","101","Man wati pád cha har radén ráhá dur dáshtagant ke tai habará dásht bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_102","020_119_102","PSA","119","102","102","Cha tai hokmán wati démon natarréntag ke taw wat maná tálim dátag. ");
INSERT INTO bcc_vpl VALUES ("PS119_103","020_119_103","PSA","119","103","103","Tai habar chónén shirkenén támé kanant, mani dapá cha bénagá shirkenter ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_104","020_119_104","PSA","119","104","104","Cha tai rahbandán maná zánt o sarpadia rasit, paméshká maná cha har radén ráhá naprat ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_105","020_119_105","PSA","119","105","105","Tai habar pa mani pádán cherágé o pa mani ráhá rozhné. ");
INSERT INTO bcc_vpl VALUES ("PS119_106","020_119_106","PSA","119","106","106","Man sawgendé wártag o é sawgenday sará óshtátagán ke tai ádelén hokmáni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_107","020_119_107","PSA","119","107","107","Oo Hodáwand! Man sakk azáb saggetag, anchosh ke kawlet kortag, maná zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_108","020_119_108","PSA","119","108","108","Oo Hodáwand! Man pa wáhagé tará satá kanán, mani é korbánigá kabul kan o maná wati hokmán sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_109","020_119_109","PSA","119","109","109","Harchont ke modám markay panjagá án, bale tai Sharyatá béhayála nakanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_110","020_119_110","PSA","119","110","110","Badkárán pa man dámé chér gétkag, bale man cha tai rahbandán nathagaletagán. ");
INSERT INTO bcc_vpl VALUES ("PS119_111","020_119_111","PSA","119","111","111","Tai parmán modám mani mirás ant, mani delay shádmáni ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_112","020_119_112","PSA","119","112","112","Man wati del pa tai hokmáni mannagá tarréntag, modám, tán godhsará. ");
INSERT INTO bcc_vpl VALUES ("PS119_113","020_119_113","PSA","119","113","113","Cha doruén mardomán naprata kanán o tai Sharyatá dósta dárán. ");
INSERT INTO bcc_vpl VALUES ("PS119_114","020_119_114","PSA","119","114","114","Taw mani panáh o espar ay, man wati óst o omét gón tai habará bastag. ");
INSERT INTO bcc_vpl VALUES ("PS119_115","020_119_115","PSA","119","115","115","Cha man dur bebét, oo badkárán, ke man wati Hodáay hokmáni randgiriá bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_116","020_119_116","PSA","119","116","116","Wati labzay hesábá maná mohkam bedár o man zendaga mánán, mayl ke mani omét beproshit. ");
INSERT INTO bcc_vpl VALUES ("PS119_117","020_119_117","PSA","119","117","117","Maná mohr bedár ke berakkán, modám tai hokmáni zegrá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_118","020_119_118","PSA","119","118","118","Hamá mardomán yalaha kanay ke cha tai hokmáni ráhá dura bant, ke áyáni prébkáriá ásaré nést. ");
INSERT INTO bcc_vpl VALUES ("PS119_119","020_119_119","PSA","119","119","119","Taw zeminay saray sajjahén radkár chó gand o gasarhá dawr dátagant, paméshká maná tai parmán dósta bant. ");
INSERT INTO bcc_vpl VALUES ("PS119_120","020_119_120","PSA","119","120","120","Mani jánay gósht cha tai torsá larzit o maná cha tai rahbandána torsit. ");
INSERT INTO bcc_vpl VALUES ("PS119_121","020_119_121","PSA","119","121","121","Man adl o ensáp kortag, maná setamgeráni dastá yalah makan. ");
INSERT INTO bcc_vpl VALUES ("PS119_122","020_119_122","PSA","119","122","122","Wati hezmatkáray salámati o washháliay zemánatá beday, mayl ke gorunák mani sará zolm bekanant. ");
INSERT INTO bcc_vpl VALUES ("PS119_123","020_119_123","PSA","119","123","123","Mani chamm pa hamá rakkénagá wadárig ant ke cha tai némagá ent, tai ádelén kawlay purah bayagay entezárá án. ");
INSERT INTO bcc_vpl VALUES ("PS119_124","020_119_124","PSA","119","124","124","Wati hezmatkárá wati mehray hesábá bechár o wati hokmán maná sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_125","020_119_125","PSA","119","125","125","Man tai hezmatkár án, maná sarpadi beday ke tai parmánán bezánán. ");
INSERT INTO bcc_vpl VALUES ("PS119_126","020_119_126","PSA","119","126","126","Oo Hodáwand! Wahd átkag ke taw káré bekanay, chéá ke tai Sharyatá próshant. ");
INSERT INTO bcc_vpl VALUES ("PS119_127","020_119_127","PSA","119","127","127","Maná tai hokm cha teláhá dóstter ant, cha asligén teláhá géshter. ");
INSERT INTO bcc_vpl VALUES ("PS119_128","020_119_128","PSA","119","128","128","Tai sajjahén rahbandáni rástiá mannán, paméshká maná cha har radén ráhá naprat ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_129","020_119_129","PSA","119","129","129","Tai parmán bákamál ant, paméshká áyána mannán. ");
INSERT INTO bcc_vpl VALUES ("PS119_130","020_119_130","PSA","119","130","130","Tai habaray bayán kanag rozhna bakshit o násarpadán sarpadia dant. ");
INSERT INTO bcc_vpl VALUES ("PS119_131","020_119_131","PSA","119","131","131","Man wati dapá pacha kanán, tonnig án o pa tai hokmán zahirig. ");
INSERT INTO bcc_vpl VALUES ("PS119_132","020_119_132","PSA","119","132","132","Démá gón man tarrén o mani sará rahm kan, anchosh ke taw modám gón wati námay dóst dárókána kanay. ");
INSERT INTO bcc_vpl VALUES ("PS119_133","020_119_133","PSA","119","133","133","Wati habaray hesábá mani gámáni rahshón bay, gonáhá mayl ke mani sará hákemi bekant. ");
INSERT INTO bcc_vpl VALUES ("PS119_134","020_119_134","PSA","119","134","134","Maná cha ensánay zolmá bemók ke tai rahbandáni randgiriá kort bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_135","020_119_135","PSA","119","135","135","Wati démá wati hezmatkáray sará drapshén o wati hokmán maná sój day. ");
INSERT INTO bcc_vpl VALUES ("PS119_136","020_119_136","PSA","119","136","136","Cha mani chammán arsay kawra tachant ke tai Sharyatay randgiri kanaga nabit. ");
INSERT INTO bcc_vpl VALUES ("PS119_137","020_119_137","PSA","119","137","137","Oo Hodáwand! Taw ádel ay o tai hokm barhakk ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_138","020_119_138","PSA","119","138","138","Á parmán ke taw dátagant pa adl ant, sarjamiá porehtebár. ");
INSERT INTO bcc_vpl VALUES ("PS119_139","020_119_139","PSA","119","139","139","Mani gayratá maná jánsóch kortag chéá ke mani dozhmenán tai habar shamoshtag. ");
INSERT INTO bcc_vpl VALUES ("PS119_140","020_119_140","PSA","119","140","140","Tai habar pák o palgár ant o tai hezmatkárá dóst ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_141","020_119_141","PSA","119","141","141","Harchont ke man kamarzesh o hakiré án, bale angat tai rahbandána nashamóshán. ");
INSERT INTO bcc_vpl VALUES ("PS119_142","020_119_142","PSA","119","142","142","Tai adl dáemi o tai Sharyat rást ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_143","020_119_143","PSA","119","143","143","Sakki o sóri mani sará átkagant bale tai hokm mani shádmáni ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_144","020_119_144","PSA","119","144","144","Tai parmán tán abad pa adl ant, maná sarpadi beday ke zendag bemánán. ");
INSERT INTO bcc_vpl VALUES ("PS119_145","020_119_145","PSA","119","145","145","Oo Hodáwand! Pa del o setk tawára kanán, passaw beday o man tai hokmáni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_146","020_119_146","PSA","119","146","146","Gón taw peryáta kanán: “Maná berakkén” o man tai parmánána mannán. ");
INSERT INTO bcc_vpl VALUES ("PS119_147","020_119_147","PSA","119","147","147","Cha bámgwáhá pésar páda káyán o peryáta kanán, man wati óst o omét gón tai habará bastag. ");
INSERT INTO bcc_vpl VALUES ("PS119_148","020_119_148","PSA","119","148","148","Mani chamm shapay sajjahén pásán pach ant ke tai habaray sará pegr kort bekanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_149","020_119_149","PSA","119","149","149","Oo Hodáwand! Mani tawárá wati mehray hesábá gósh dár, wati hokmáni hesábá maná zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_150","020_119_150","PSA","119","150","150","Hamá ke badkáriáni randgir ant, nazzikká rasetagant, á cha tai Sharyatá dur ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_151","020_119_151","PSA","119","151","151","Oo Hodáwand! Taw nazzikk ay o tai sajjahén hokm rást ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_152","020_119_152","PSA","119","152","152","Man sakk dér ent zántag, taw wati parmán barjam dáshtagant ke abadi bebant. ");
INSERT INTO bcc_vpl VALUES ("PS119_153","020_119_153","PSA","119","153","153","Mani sakki o sórián bechár o mani sará rahm kan ke tai Sharyaton nashamoshtag. ");
INSERT INTO bcc_vpl VALUES ("PS119_154","020_119_154","PSA","119","154","154","Mani hakkay démpániá bekan o mani posht bay, wati kawlay hesábá maná zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_155","020_119_155","PSA","119","155","155","Rakkag cha badkárán dur ent ke á tai hokmáni shóházá naant. ");
INSERT INTO bcc_vpl VALUES ("PS119_156","020_119_156","PSA","119","156","156","Tai rahmat sakk báz ant, oo Hodáwand! Wati Sharyatay hesábá maná zendag bedár. ");
INSERT INTO bcc_vpl VALUES ("PS119_157","020_119_157","PSA","119","157","157","Mani ázár dayók o dozhmen báz ant, bale man cha tai parmánán wati dém natarréntag. ");
INSERT INTO bcc_vpl VALUES ("PS119_158","020_119_158","PSA","119","158","158","Béwapáyáni némagá charán o maná cha eshán naprata bit, ke tai rahbandáni randgiriá nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS119_159","020_119_159","PSA","119","159","159","Bechár tai rahband maná chón dóst ant, wati mehray hesábá maná zendag bedár, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS119_160","020_119_160","PSA","119","160","160","Tai sajjahén habar rást ant o tai sajjahén ádelén hokm abadmán. ");
INSERT INTO bcc_vpl VALUES ("PS119_161","020_119_161","PSA","119","161","161","Hákem maná mopt o náhakk ázára dayant, bale mani del tai habaráni sará larzit. ");
INSERT INTO bcc_vpl VALUES ("PS119_162","020_119_162","PSA","119","162","162","Man tai habaray sará shádehia kanán hamá mardomay paymá ke poletagén málé berasiti. ");
INSERT INTO bcc_vpl VALUES ("PS119_163","020_119_163","PSA","119","163","163","Cha repk o prébá naprata kanán, tai Sharyatá dósta dárán. ");
INSERT INTO bcc_vpl VALUES ("PS119_164","020_119_164","PSA","119","164","164","Róché hapt bar tará názénán, pa tai ádelén hokmán. ");
INSERT INTO bcc_vpl VALUES ("PS119_165","020_119_165","PSA","119","165","165","Hamá ke tai Sharyatá dósta dárant, sakk émen ant o áyán hecch chizz thagalénta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS119_166","020_119_166","PSA","119","166","166","Oo Hodáwand! Pa hamá nejátá wadárig án ke cha tai némagá ent o tai hokmáni randgiriá kanán. ");
INSERT INTO bcc_vpl VALUES ("PS119_167","020_119_167","PSA","119","167","167","Tai parmánáni randgiriá kanán ke maná sakk dóst ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_168","020_119_168","PSA","119","168","168","Tai rahband o parmánána dárán ke taw mani sajjahén ráhána zánay. ");
INSERT INTO bcc_vpl VALUES ("PS119_169","020_119_169","PSA","119","169","169","Oo Hodáwand! Mani peryát tará sar bát, wati labzay hesábá maná agl o hósh beday. ");
INSERT INTO bcc_vpl VALUES ("PS119_170","020_119_170","PSA","119","170","170","Mani nálag tará sar bát, wati kawlay hesábá maná berakkén. ");
INSERT INTO bcc_vpl VALUES ("PS119_171","020_119_171","PSA","119","171","171","Mani lonth tai satáyá sarréch bátant ke taw maná wati hokmán sója dayay. ");
INSERT INTO bcc_vpl VALUES ("PS119_172","020_119_172","PSA","119","172","172","Mani dap tai habará benázénát, ke tai sajjahén rahband pa adl ant. ");
INSERT INTO bcc_vpl VALUES ("PS119_173","020_119_173","PSA","119","173","173","Tai dast pa mani komakk kanagá tayár bát ke man tai rahband gechén kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS119_174","020_119_174","PSA","119","174","174","Oo Hodáwand! Pa hamá nejátá talwasagá án ke cha tai némagá ent o tai Sharyat mani shádmáni ent. ");
INSERT INTO bcc_vpl VALUES ("PS119_175","020_119_175","PSA","119","175","175","Maná zendag bedár ke tará benázénán o tai hokm maná madat kanátant. ");
INSERT INTO bcc_vpl VALUES ("PS119_176","020_119_176","PSA","119","176","176","Chó gárén paséá darpadar butagán. Wati hezmatkárá shóház kan ke man tai hokm nashamoshtagant. ");
INSERT INTO bcc_vpl VALUES ("PS120_1","020_120_1","PSA","120","1","1","Dém pa Urshalimá borzád rawagay sawté. Wati sakki o sóriáni wahdá man gón Hodáwandá peryát kort o áiá maná passaw dát. ");
INSERT INTO bcc_vpl VALUES ("PS120_2","020_120_2","PSA","120","2","2","“Oo Hodáwand! Maná cha drógbandén lonth o prébkárén dapán berakkén.” ");
INSERT INTO bcc_vpl VALUES ("PS120_3","020_120_3","PSA","120","3","3","Oo prébkárén dap! Hodáwand tará ché bedant o ched o gésh gón taw ché bekant? ");
INSERT INTO bcc_vpl VALUES ("PS120_4","020_120_4","PSA","120","4","4","Tará gón jangóláni tézén tir o gón rókén eshkarán sezá dant. ");
INSERT INTO bcc_vpl VALUES ("PS120_5","020_120_5","PSA","120","5","5","Apsóz pa man ke Méshékay molká neshtagán, ke man Kédaray gedánán jahmenend án. ");
INSERT INTO bcc_vpl VALUES ("PS120_6","020_120_6","PSA","120","6","6","Man gón choshén mardomán zend gwázenagá dam bortag ke cha sohl o émeniá naprata kanant. ");
INSERT INTO bcc_vpl VALUES ("PS120_7","020_120_7","PSA","120","7","7","Sohl o émeni pasondén mardomé án bale har wahdá ke habaré kanán, é jangá páda káyant. ");
INSERT INTO bcc_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Dém pa Urshalimá borzád rawagay sawté. Chammán dém pa kóhá chesta kanán maná komakk cha kojá rasit? ");
INSERT INTO bcc_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Maná komakk cha Hodáwandá rasit, hamá ke ásmán o zemini addh kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Á naylit ke tai pád belakoshit, á ke tai negahpániá kant wába nakapit. ");
INSERT INTO bcc_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Haw, á ke Esráilay negahpán ent nawapsit o wába nakapit. ");
INSERT INTO bcc_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Hodáwand wat tai negahpán ent, Hodáwand tai rástén némagá sáheg ent. ");
INSERT INTO bcc_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Róch, tará róchá ázára nadant o na máh, shapá. ");
INSERT INTO bcc_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Hodáwand tará cha har badiá dura dárit, tai zenday negahpán ent, ");
INSERT INTO bcc_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Hodáwand tai har rawag o áyagay negahpán ent annun o tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS122_1","020_122_1","PSA","122","1","1","Dém pa Urshalimá borzád rawagay sawté. Dáuday Zabur. Áyán ke gwasht: “Hodáwanday lógá berawén” man shádán bután. ");
INSERT INTO bcc_vpl VALUES ("PS122_2","020_122_2","PSA","122","2","2","Chón wassh! May pád cha tai darwázagán potertag o óshtátagant, oo Urshalim! ");
INSERT INTO bcc_vpl VALUES ("PS122_3","020_122_3","PSA","122","3","3","Urshalim anchosh bandag butag ke shahr cha har némagá gón wat chó tagerdéá gwaptag. ");
INSERT INTO bcc_vpl VALUES ("PS122_4","020_122_4","PSA","122","4","4","Hamódá ke kabilaha rawant, Hodáwanday kabilah ke Hodáwanday námá benázénant hamá ahd o karáray hesábá ke Esráilá dayag butag. ");
INSERT INTO bcc_vpl VALUES ("PS122_5","020_122_5","PSA","122","5","5","Ódá dádrasiay taht barjáh dárag butagant Dáuday kahól o hándánay taht. ");
INSERT INTO bcc_vpl VALUES ("PS122_6","020_122_6","PSA","122","6","6","Pa Urshalimay émeniá dwá kanét, harkas ke tará, ó Urshalim, dósta dárit, ásudag bát. ");
INSERT INTO bcc_vpl VALUES ("PS122_7","020_122_7","PSA","122","7","7","Tai shahray diwáláni tahá sohl o émeni bát o tai kalátán ásudagi. ");
INSERT INTO bcc_vpl VALUES ("PS122_8","020_122_8","PSA","122","8","8","Wati brát o sangatáni háterá gwashán: “Tará sohl o émeni sar bát.” ");
INSERT INTO bcc_vpl VALUES ("PS122_9","020_122_9","PSA","122","9","9","Wati Hodáwandén Hodáay lógay háterá tai ábád bayagay lóthók án. ");
INSERT INTO bcc_vpl VALUES ("PS123_1","020_123_1","PSA","123","1","1","dém pa Urshalimá borzád rawagay sawté. Wati chammán dém pa taw chesta kanán, taw ke arshá, wati bádsháhi tahtay sará neshtagay. ");
INSERT INTO bcc_vpl VALUES ("PS123_2","020_123_2","PSA","123","2","2","Anchó ke goláméay chamm wati wájahay dastá sakk ant o móledéay chamm wati bánoká may chamm Hodáwandén Hodáyá sakk ant ke may sará rahm bekant. ");
INSERT INTO bcc_vpl VALUES ("PS123_3","020_123_3","PSA","123","3","3","May sará rahm kan, oo Hodáwand! Rahm kan may sará, ke má sakk báz béezzati saggetag, ");
INSERT INTO bcc_vpl VALUES ("PS123_4","020_123_4","PSA","123","4","4","Ásudagén mardománi rishkand o porkebráni kalág márá pa sarjamiá rasetag. ");
INSERT INTO bcc_vpl VALUES ("PS124_1","020_124_1","PSA","124","1","1","Dém pa Urshalimá borzád rawagay sawté. Dáuday Zabur. “Agan Hodáwand gón má gón mabutén,” Esráil begwashát: ");
INSERT INTO bcc_vpl VALUES ("PS124_2","020_124_2","PSA","124","2","2","“Agan Hodáwand gón má gón mabutén á wahdá ke mardomán may sará orosh o hamlah kort, ");
INSERT INTO bcc_vpl VALUES ("PS124_3","020_124_3","PSA","124","3","3","áyán márá zendagá ér bortagat wahdé hezhmesh may sará chest at. ");
INSERT INTO bcc_vpl VALUES ("PS124_4","020_124_4","PSA","124","4","4","Á wahdá ápán márá ér bortagat, hár o tuppáná márá mán roptagat, ");
INSERT INTO bcc_vpl VALUES ("PS124_5","020_124_5","PSA","124","5","5","mastén ápán márá rópán kortagat.” ");
INSERT INTO bcc_vpl VALUES ("PS124_6","020_124_6","PSA","124","6","6","Hodáwandá satá bát ke naeshti má esháni dantánáni shekár bebén. ");
INSERT INTO bcc_vpl VALUES ("PS124_7","020_124_7","PSA","124","7","7","May zendi anchó rakként ke báli morgé cha shekáriay dámá, dám dert o má rakketén. ");
INSERT INTO bcc_vpl VALUES ("PS124_8","020_124_8","PSA","124","8","8","Hodáwanday nám may madat ent, ásmán o zeminay jórh kanókay nám. ");
INSERT INTO bcc_vpl VALUES ("PS125_1","020_125_1","PSA","125","1","1","Dém pa Urshalimá borzád rawagay sawté. Á ke Hodáwanday sará tawkala kanant Sahyunay kóhay paymá ant ke sorénaga nabit o tán abad barjáh mánit. ");
INSERT INTO bcc_vpl VALUES ("PS125_2","020_125_2","PSA","125","2","2","Anchosh ke kóhán, Urshalim chapp o chágerd kortag, Hodáwandá wati kawmay chapp o chágerd geptag, annun o tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS125_3","020_125_3","PSA","125","3","3","Badkárén bádsháhéay asá pahrézkáráni mirásay sará hokmrána nabit ke pahrézkár wati dastá pa badkári sell makanant. ");
INSERT INTO bcc_vpl VALUES ("PS125_4","020_125_4","PSA","125","4","4","Oo Hodáwand! Pa nékdelán néki kan pa hamáyán ke delesh rást o tachk ant. ");
INSERT INTO bcc_vpl VALUES ("PS125_5","020_125_5","PSA","125","5","5","Bale hamá mardom ke chapp o chóthén ráhána rawant, Hodáwand áyán gón badkárán yakjáha gallénit. Esráil émen o salámat bát. ");
INSERT INTO bcc_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Dém pa Urshalimá borzád rawagay sawté. Wahdé Hodáwandá Sahyunay washbahti per tarrént o áwort má purah wáb gendagá atén. ");
INSERT INTO bcc_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","May dap cha kandagá porr at, zobán cha shádehiay sawtá. Á wahdá kawmáni nyámá gwashag but: “Hodáwandá pa eshán mazanén kár kortag.” ");
INSERT INTO bcc_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Haw, Hodáwandá pa má mazanén kár kort, má gal atén. ");
INSERT INTO bcc_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Oo Hodáwand! May washbahtiá padá byár, anchó ke kawr Négéway gyábáná ábádia kárit. ");
INSERT INTO bcc_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Hamá ke ars récháná kesht o keshára kanant, pa shádehi kukkár kanáná ronant. ");
INSERT INTO bcc_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Hamá ke gréwáná dara kapit o tohmán pa keshagá bárt, pa shádehi kukkár kanáná wátarra kant o wati lóthokána kárit. ");
INSERT INTO bcc_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Dém pa Urshalimá borzád rawagay sawté. Solaymánay Zabur. Agan Hodáwand lógá mabandit, bánbandáni zahmat békár ent. Agan Hodáwand, shahray negahpániá makant, nehgahpánáni negahpáni békár ent. ");
INSERT INTO bcc_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Tai, sohbá máhallah pád áyag o shapá tán dérá ágah bayag békár ent. Zahmata kasshay ke tará pa waragá nán berasit, á ke Hodáyá dóst ant, agan wáb bebant ham Hodá é chizzán áyáná dant. ");
INSERT INTO bcc_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","3","Chokk cha Hodáwanday némagá mirás ant o padréch cha hamáiay némagá mozz. ");
INSERT INTO bcc_vpl VALUES ("PS127_4","020_127_4","PSA","127","4","4","Warnáiá áwortagén mardénchokk anchosh ant ke jangóléay dastá tir. ");
INSERT INTO bcc_vpl VALUES ("PS127_5","020_127_5","PSA","127","5","5","Bahtáwar hamá mard ent ke tirdáni cha chokká porr ent. Wahdé choshén mardomé shahray darwázagá gón dozhmená dém pa déma bit hechbar pashal o sharmendaga nabit. ");
INSERT INTO bcc_vpl VALUES ("PS128_1","020_128_1","PSA","128","1","1","Dém pa Urshalimá borzád rawagay sawté. Bahtáwar hamá ent ke Hodáwanday torsi delá ent o áiay parmánbardáriá gáma jant. ");
INSERT INTO bcc_vpl VALUES ("PS128_2","020_128_2","PSA","128","2","2","Taw wati zahmatay bar o samará waray o bahtáwar o washhála bay. ");
INSERT INTO bcc_vpl VALUES ("PS128_3","020_128_3","PSA","128","3","3","Tai jan tai lógay tahá chó bar áwarén angurá bit, tai chokk tai parzónagay chapp o chágerdá chó zaytunay nahálá bant. ");
INSERT INTO bcc_vpl VALUES ("PS128_4","020_128_4","PSA","128","4","4","Haw, hamá mardom ke Hodáwanday tors áiay delá ent hamé dhawlá bahtáwara bit. ");
INSERT INTO bcc_vpl VALUES ("PS128_5","020_128_5","PSA","128","5","5","Hodáwand cha Sahyuná tará barkat bedayát, Urshalimay ábádiá begendátay, wati zenday sajjahén róchán. ");
INSERT INTO bcc_vpl VALUES ("PS128_6","020_128_6","PSA","128","6","6","Wati chokkáni chokkán begendátay, Esráil émen o salámat bát. ");
INSERT INTO bcc_vpl VALUES ("PS129_1","020_129_1","PSA","129","1","1","Dém pa Urshalimá borzád rawagay sawté. “Áyán maná cha warnáiá sakk báz ázár dátag,” Esráil begwashát: ");
INSERT INTO bcc_vpl VALUES ("PS129_2","020_129_2","PSA","129","2","2","“Maná cha warnáiá sakk báz ázáresh dátag bale maná chérdastesh kort nakortag. ");
INSERT INTO bcc_vpl VALUES ("PS129_3","020_129_3","PSA","129","3","3","Nangár kanókán mani srén nangár kortag o pal dráj kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS129_4","020_129_4","PSA","129","4","4","Bale Hodáwand ádel ent, badkáráni zamzili sestant o maná ázáti kort.” ");
INSERT INTO bcc_vpl VALUES ("PS129_5","020_129_5","PSA","129","5","5","Hamá ke cha Sahyuná naprata kanant, sharmsár bát o poshtá bekenzátant. ");
INSERT INTO bcc_vpl VALUES ("PS129_6","020_129_6","PSA","129","6","6","Chó bánáni saray káhá bátant ke cha rodagá pésar hoshka bit, ");
INSERT INTO bcc_vpl VALUES ("PS129_7","020_129_7","PSA","129","7","7","ke ronókay panjagay porré nabit, chenókay bagalá porra nakant. ");
INSERT INTO bcc_vpl VALUES ("PS129_8","020_129_8","PSA","129","8","8","Rahgwazé ham pa áyán nékdwai makanát o magwashát: “Hodáwand shomárá barkat bedayát, má Hodáwanday námá shomárá barkata dayén.” ");
INSERT INTO bcc_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Dém pa Urshalimá borzád rawagay sawté. Man cha johlánkián tará tawára kanán, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Hodáwand! Mani tawárá gósh dár, mani peryát o zárián delgósh kanátay. ");
INSERT INTO bcc_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Oo Hodáwand! Agan taw gonáhán hesáb bekanay, gorhá kay pashta kapit, oo Hodáwand? ");
INSERT INTO bcc_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Bale taw bakshendah ay tánke tai tors may delá bebit. ");
INSERT INTO bcc_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Man pa Hodáwandá wadára kanán, mani sajjahén del o ján wadára kant o mani omét gón Hodáay habará ent. ");
INSERT INTO bcc_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Pa Hodáwandá wadára kanán cha hamá negahpánán géshter ke sohbay wadárá ant, haw, cha hamá negahpánán géshter ke sohbay wadárá ant. ");
INSERT INTO bcc_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Oo Esráil! Ométá pa Hodáwandá bedár, ke mehr gón Hodáyá ent o kámelén rakkénag hamáiay dastá ent. ");
INSERT INTO bcc_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Á wat Esráilá mókit cha áyáni sajjahén gonáhán. ");
INSERT INTO bcc_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Dém pa Urshalimá borzád rawagay sawté. Dáuday zabur. Oo Hodáwand! Mani del gorunák naent o na ke mani chamm porkebr ant. Gón mazanén kárán delgósha nabán o na gón á kárán ke mani delá bákamál ant. ");
INSERT INTO bcc_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Man watá chopp o árám kortag cha shirá sestagén nonnokéay paymá ke mátay kotthá ent. Haw, mani arwáh cha shirá sestagén nonnokéay paymá árám geptag. ");
INSERT INTO bcc_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Oo Esráil! Ométá pa Hodáwandá bedár, annun o tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS132_1","020_132_1","PSA","132","1","1","Dém pa Urshalimá borzád rawagay sawté. Oo Hodáwand! Dáudá yát kan o áiay sakki o sórián. ");
INSERT INTO bcc_vpl VALUES ("PS132_2","020_132_2","PSA","132","2","2","Gón Hodáwandá sawgendé wárti o gón Ákubay zórmandén Hodáyá kawli kort o gwashti: ");
INSERT INTO bcc_vpl VALUES ("PS132_3","020_132_3","PSA","132","3","5","“Tánke pa wati Hodáwand, pa Ákubay zorákén Hodáyá lógé addh makanán, wati jenday lógá narawán, watá árám kanagá naylán, chammán nazza nayárán, mecháchán dhokkagá naylán.” ");
INSERT INTO bcc_vpl VALUES ("PS132_6","020_132_6","PSA","132","6","6","Bechár, má Eprátahay shahrá ahd o karáray pétiay zegr eshkot o Jáháray sardhagárá dar gétk. ");
INSERT INTO bcc_vpl VALUES ("PS132_7","020_132_7","PSA","132","7","7","“Byáét áiay lógá rawén o áiay pádáni padagay démá sojdaha kanén o gwashén: ");
INSERT INTO bcc_vpl VALUES ("PS132_8","020_132_8","PSA","132","8","8","‘Hodáwand! Jáh jan o wati ásudagiay jágahá byá gón wati zóray ahd o karáray pétiá. ");
INSERT INTO bcc_vpl VALUES ("PS132_9","020_132_9","PSA","132","9","9","Tai dini péshwáyán pahrézkáriay póshák gwará bát o tai wapádárén hezmatkár shádehiay kukkár bekanátant.”’ ");
INSERT INTO bcc_vpl VALUES ("PS132_10","020_132_10","PSA","132","10","10","Pa wati hezmatkár Dáudá bechár o wati “rógen per moshtagéná” dawr maday. ");
INSERT INTO bcc_vpl VALUES ("PS132_11","020_132_11","PSA","132","11","11","Hodáwandá gón Dáudá sawgendé wárt, kawlé korti o cha wati zobáná nabajjit, ke: “Man cha tai óbádagán yakké tai bádsháhi tahtá nádénán. ");
INSERT INTO bcc_vpl VALUES ("PS132_12","020_132_12","PSA","132","12","12","Agan tai chokk, mani ahd o karáray sará bóshtant o mani hamá rahbandáni randgiriá bekanant ke manesh sója dayán, gorhá tai óbádag, tai bádsháhi tahtá nendant, tán abad.” ");
INSERT INTO bcc_vpl VALUES ("PS132_13","020_132_13","PSA","132","13","13","Chéá ke Hodáwandá Sahyun dar chetag o pa wati menendjáhá dósti butag, gwashtagi: ");
INSERT INTO bcc_vpl VALUES ("PS132_14","020_132_14","PSA","132","14","14","“É mani árámjáh ent, tán abad. Man hamedá wati bádsháhi tahtá nendán chéá ke dóstona bit. ");
INSERT INTO bcc_vpl VALUES ("PS132_15","020_132_15","PSA","132","15","15","Man eshiá barkata dayán o ábáda kanán, eshiay garibán lápséra kanán. ");
INSERT INTO bcc_vpl VALUES ("PS132_16","020_132_16","PSA","132","16","16","Man eshiay dini péshwáyán rakkagay pósháká gwará dayán o eshiay wapádárén mardom pa shádehi kukkára kanant. ");
INSERT INTO bcc_vpl VALUES ("PS132_17","020_132_17","PSA","132","17","17","Man edá pa Dáudá kánthé ródénán o pa wati “rógen per moshtagéná” cherágé róka kanán. ");
INSERT INTO bcc_vpl VALUES ("PS132_18","020_132_18","PSA","132","18","18","Eshiay dozhmenán, sharmsáriay pósháká gwará dayán o eshiay sar gón drapshókén tájéá borza bit.” ");
INSERT INTO bcc_vpl VALUES ("PS133_1","020_133_1","PSA","133","1","1","Dém pa Urshalimá borzád rawagay sawté. Dáuday Zabur. Chón wassh o delkassh ent ke Hodáay mardom pa tepáki hór benendant. ");
INSERT INTO bcc_vpl VALUES ("PS133_2","020_133_2","PSA","133","2","2","Purah gránbaháén thélé ke sará charp kortag o risshán ér rechán ent, Hárunay risshán o jahlád tán kabáhay jigá. ");
INSERT INTO bcc_vpl VALUES ("PS133_3","020_133_3","PSA","133","3","3","Chó ke Hermónay nódán ke Sahyunay kóháni sará shanzant. Chéá ke ódá Hodáwandá wati barkatay parmán dátag, zend, tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Dém pa Urshalimá borzád rawagay sawté. Ji haw, Hodáwandá benázénét, oo Hodáwanday sajjahén hezmatkárán ke shapán Hodáwanday lógá áiay hezmatá kanagá ét! ");
INSERT INTO bcc_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Dastán pákén jágahay némagá chest kanét o Hodáwandá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Hodáwand cha Sahyuná shomárá barkat bedayát, hamá ke zemin o ásmánay addh kanók ent. ");
INSERT INTO bcc_vpl VALUES ("PS135_1","020_135_1","PSA","135","1","1","Hodáwandá benázénét, Halléluyá. Hodáwanday námá benázénét, oo Hodáwanday hezmatkárán, Hodáwandá benázénét, ");
INSERT INTO bcc_vpl VALUES ("PS135_2","020_135_2","PSA","135","2","2","shomá sajjahén ke Hodáwanday lógá hezmata kanét, may Hodáay lógay péshgáhá. ");
INSERT INTO bcc_vpl VALUES ("PS135_3","020_135_3","PSA","135","3","3","Hodáwandá benázénét chéá ke Hodáwand nék ent, pa sawt áiay námá benázénét ke delkassh ent. ");
INSERT INTO bcc_vpl VALUES ("PS135_4","020_135_4","PSA","135","4","4","Chéá ke Hodáwandá Ákub pa wat gechén kortag, Esráil, ke pa áiá ganjé bebit. ");
INSERT INTO bcc_vpl VALUES ("PS135_5","020_135_5","PSA","135","5","5","Mana zánán ke Hodáwand mazan ent, ke may Hodáwand cha sajjahén hodáyán master ent. ");
INSERT INTO bcc_vpl VALUES ("PS135_6","020_135_6","PSA","135","6","6","Harché ke Hodáwand ásmánán o zeminá, daryáyán o daryáyáni sajjahén johlánkián kanag belóthit, kant. ");
INSERT INTO bcc_vpl VALUES ("PS135_7","020_135_7","PSA","135","7","7","Cha zeminay goddhi hadd o simsarán jambarán chesta kant, gerókán gón hawrán rawána dant o cha wati ambárán gwátá dhanná kárit. ");
INSERT INTO bcc_vpl VALUES ("PS135_8","020_135_8","PSA","135","8","8","Hamáiá Mesray awali chokk jatant, mardománi ham o dalwatáni ham. ");
INSERT INTO bcc_vpl VALUES ("PS135_9","020_135_9","PSA","135","9","9","Oo Mesr! Tai nyámá wati nesháni o mójezahi rawán dátant, Perawn o áiay sajjahén hezmatkáráni helápá. ");
INSERT INTO bcc_vpl VALUES ("PS135_10","020_135_10","PSA","135","10","10","Bázén kawmé jati o áyáni porwákén bádsháhi koshtant, ");
INSERT INTO bcc_vpl VALUES ("PS135_11","020_135_11","PSA","135","11","11","Amuriáni bádsháh Sihón, Báshánay bádsháh Óg o Kanhánay sajjahén bádsháh o ");
INSERT INTO bcc_vpl VALUES ("PS135_12","020_135_12","PSA","135","12","12","áyáni sardhagári mirásé kortant mirasé pa wati mahluká, pa Esráilá. ");
INSERT INTO bcc_vpl VALUES ("PS135_13","020_135_13","PSA","135","13","13","Oo Hodáwand! Tai nám tán abada mánit o taw nasláni nasl yát kanaga bay, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS135_14","020_135_14","PSA","135","14","14","Chéá ke Hodáwand wati mahlukay dadrasiá kant o pa wati hezmatkárán rahma kant. ");
INSERT INTO bcc_vpl VALUES ("PS135_15","020_135_15","PSA","135","15","15","Kawmáni “hodá” teláh o nograh ant, ensánay dastay jórh kortagén bot. ");
INSERT INTO bcc_vpl VALUES ("PS135_16","020_135_16","PSA","135","16","16","Dapesh per bale habar korta nakanant, chammesh per bale dista nakanant, ");
INSERT INTO bcc_vpl VALUES ("PS135_17","020_135_17","PSA","135","17","17","góshesh per bale eshkota nakanant o dapá sáhesh mán nést. ");
INSERT INTO bcc_vpl VALUES ("PS135_18","020_135_18","PSA","135","18","18","Harkas ke eshán jórha kant, hamesháni paymá bit o harkas ke esháni sará tawkala kant ham anchosha bit. ");
INSERT INTO bcc_vpl VALUES ("PS135_19","020_135_19","PSA","135","19","19","Oo Esráilián! Hodáwandá benázénét. Oo Hárunay lóg! Hodáwandá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS135_20","020_135_20","PSA","135","20","20","Oo Léwiay lóg! Hodáwandá benázénét. Oo Hodátorsán! Hodáwandá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS135_21","020_135_21","PSA","135","21","21","Cha Sahyuná Hodáwandá benázénét, hamá ke Urshalimá jahmenend ent. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS136_1","020_136_1","PSA","136","1","1","Hodáwanday shográ begerét ke á nék ent o mehri abadmán. ");
INSERT INTO bcc_vpl VALUES ("PS136_2","020_136_2","PSA","136","2","2","Hodáyáni Hodáay shográ begerét ke mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_3","020_136_3","PSA","136","3","3","Hodáwandáni Hodáwanday shográ begerét ke mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_4","020_136_4","PSA","136","4","4","Hamá yakkénay shográ begerét ke mazanén mójezaha kant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_5","020_136_5","PSA","136","5","5","Hamá ke cha wati dánáiá ásmáni addh kortagant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_6","020_136_6","PSA","136","6","6","Hamá ke zemini ápáni sará chér gétkag, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_7","020_136_7","PSA","136","7","7","Hamá ke mazanén nuri addh kortagant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_8","020_136_8","PSA","136","8","8","Róchi addh kort ke róchá hákemi bekant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_9","020_136_9","PSA","136","9","9","Máh o estári sázetant ke shapá hákemi bekanant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_10","020_136_10","PSA","136","10","10","Hamá ke Mesray awali chokki jatant, mehri abadmán ent o ");
INSERT INTO bcc_vpl VALUES ("PS136_11","020_136_11","PSA","136","11","11","Esráili cha áyáni nyámá dar kort, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_12","020_136_12","PSA","136","12","12","Gón porzórén básk o shahártagén dasté, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_13","020_136_13","PSA","136","13","13","Hamá ke Sohrzeri do kapp kort, mehri abadmán ent, ");
INSERT INTO bcc_vpl VALUES ("PS136_14","020_136_14","PSA","136","14","14","o Esráili cha eshiay tahá gwázént, mehri abadmán ent, ");
INSERT INTO bcc_vpl VALUES ("PS136_15","020_136_15","PSA","136","15","15","bale Perawni gón lashkará Sohrzerá bokként, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_16","020_136_16","PSA","136","16","16","Hamá ke gyábáná wati mahluki rahshóni dát, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_17","020_136_17","PSA","136","17","17","Hamá ke mazanén bádsháhi jatant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_18","020_136_18","PSA","136","18","18","Zóráwarén bádsháhi koshtant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_19","020_136_19","PSA","136","19","19","Amuriáni bádsháh Sihóni jat, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_20","020_136_20","PSA","136","20","20","Báshánay bádsháh Ógi kosht, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_21","020_136_21","PSA","136","21","21","Esháni zemini mirásé kortant, mehri abadmán ent, ");
INSERT INTO bcc_vpl VALUES ("PS136_22","020_136_22","PSA","136","22","22","mirásé pa wati hezmatkárén Esráilá, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_23","020_136_23","PSA","136","23","23","Hamá ke márá may kamsharapián yáti kort, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_24","020_136_24","PSA","136","24","24","Márá cha dozhmenán ázáti kort, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_25","020_136_25","PSA","136","25","25","Hamá ke sajjahén sahdárán róziga dant, mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS136_26","020_136_26","PSA","136","26","26","Borzén arshay Hodáay shográ begerét ke mehri abadmán ent. ");
INSERT INTO bcc_vpl VALUES ("PS137_1","020_137_1","PSA","137","1","1","Bábelay kawráni kashá, má nesht o grét, wahdé má Sahyun yát kort. ");
INSERT INTO bcc_vpl VALUES ("PS137_2","020_137_2","PSA","137","2","2","Má drachkáni sará wati soróz o chang dratkant, ");
INSERT INTO bcc_vpl VALUES ("PS137_3","020_137_3","PSA","137","3","3","ke may bandig kanókán márá gwasht: “Sawt bejanét,” ke may ázár dayókán cha má shádehiay sawt lóthet. Gwashtesh: “Pa má cha Sahyunay sawtán yakké bejanét.” ");
INSERT INTO bcc_vpl VALUES ("PS137_4","020_137_4","PSA","137","4","4","Má ke darándhéh én, Hodáwanday sawtán chón jata kanén? ");
INSERT INTO bcc_vpl VALUES ("PS137_5","020_137_5","PSA","137","5","5","Oo Urshalim! Agan man tará shamosht, mani rástén dast wati honará beshamóshát. ");
INSERT INTO bcc_vpl VALUES ("PS137_6","020_137_6","PSA","137","6","6","Mani zobán nokká belecchát agan tará yát makanán o agan Urshalimá wati masterén shádehi sarpad mabán. ");
INSERT INTO bcc_vpl VALUES ("PS137_7","020_137_7","PSA","137","7","7","Oo Hodáwand! Yátá bedár ke Urshalimay kapagay róchá Edumián ché kort. “Próshéti” áyán gwasht, “cha boná próshéti.” ");
INSERT INTO bcc_vpl VALUES ("PS137_8","020_137_8","PSA","137","8","8","Oo Bábelay jenekk! Taw zutt dém pa tabáhiá raway, bahtáwar hamá ent ke tará sezá dant, hamá chizzáni sezáyá ke taw gón má kortagant. ");
INSERT INTO bcc_vpl VALUES ("PS137_9","020_137_9","PSA","137","9","9","Bahtáwar hamá ent ke tai chokkána zurit o taláráni sará jant. ");
INSERT INTO bcc_vpl VALUES ("PS138_1","020_138_1","PSA","138","1","1","Dáuday zabur. Oo Hodáwand! Cha delay johlánkiá tai shográ gerán, hodáyáni bárgáhá tará pa sawta názénán. ");
INSERT INTO bcc_vpl VALUES ("PS138_2","020_138_2","PSA","138","2","2","Dém pa tai pákén parasteshgáhá kóndhána kapán o tai námá názénán pa tai mehr o wapádáriá ke taw wati nám o wati mohrén ahd o karár cha sajjahén chizán géshter mazani bakshátag. ");
INSERT INTO bcc_vpl VALUES ("PS138_3","020_138_3","PSA","138","3","3","Har wahdá ke tará gwánkon jatag taw maná passaw dátag, mani del mazan kortag o maná zór o wák bakshátag. ");
INSERT INTO bcc_vpl VALUES ("PS138_4","020_138_4","PSA","138","4","4","Hodáwand! Jahánay sajjahén bádsháh tai shográ begerátant, hamá wahdá ke tai habará eshkonant. ");
INSERT INTO bcc_vpl VALUES ("PS138_5","020_138_5","PSA","138","5","5","Tai káráni satáyá sawt bejanátant, ke Hodáwanday shán mazan ent. ");
INSERT INTO bcc_vpl VALUES ("PS138_6","020_138_6","PSA","138","6","6","Harchont ke Hodáwand mazanshán ent, bale békebrán pa rahma chárit o gorunákán cha durá pajjáha kárit. ");
INSERT INTO bcc_vpl VALUES ("PS138_7","020_138_7","PSA","138","7","7","Harchont ke sakki o sóriáni tahá gardán, bale taw maná zendaga dáray. Taw mani dozhmenáni hezhmay helápá wati dastá shaháray o gón wati rástén dastá maná rakkénay. ");
INSERT INTO bcc_vpl VALUES ("PS138_8","020_138_8","PSA","138","8","8","Hodáwand maná rakkénit. Hodáwand! Tai mehr abadmán ent, wati dastáni kárán band makan. ");
INSERT INTO bcc_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Pa sázger o washalhánáni sálárá. Dáuday Zabur. Oo Hodáwand! Taw maná chakkásetag o zánay. ");
INSERT INTO bcc_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Taw zánay ke man kadi nendán o kadi páda káyán, cha durá mani pegr o hayálána zánay. ");
INSERT INTO bcc_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Taw maná tarr o gard kanagá ham genday o tachk bayag o árám kanagá ham, mani har kárá zánay. ");
INSERT INTO bcc_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Habaré ke cha mani zobáná dara kayt, taw cha pésará zánayi, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Taw cha poshtá o démá maná chapp o chágerd kortag o wati dast mani sará ér moshtag. ");
INSERT INTO bcc_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Choshén zánt pa man sakk báz ajab ent cha mani sarpadiá békesás báláter. ");
INSERT INTO bcc_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Cha tai arwáhá démá tarrént o kojá shota kanán? Cha tai bárgáhá tatk o kojá shota kanán? ");
INSERT INTO bcc_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Agan ásmánán berawán, taw hamódá ay o agan mordagáni jaháná wati nepádá pach bekanán, taw hamódá ay. ");
INSERT INTO bcc_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","9","Agan bámgwáháni bánzolán bál bekanán, agan daryáay durterén kerréá benendán, ");
INSERT INTO bcc_vpl VALUES ("PS139_10","020_139_10","PSA","139","10","10","ódá ham tai dast mani rahshóniá kant o tai rástén dast maná mohra dárit. ");
INSERT INTO bcc_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","11","Agan begwashán: “Béshakk tahári maná chéra dant o rozhnái mani chapp o chágerdá shapé jórha bit,” ");
INSERT INTO bcc_vpl VALUES ("PS139_12","020_139_12","PSA","139","12","12","tahári ham pa taw tahára nabit, shap, chó róchá drapshit, ke tahári ham pa taw chó rozhnáiá ent. ");
INSERT INTO bcc_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","13","Béshakk mani del o darun taw addh kortag taw maná mátay lápá gwaptag. ");
INSERT INTO bcc_vpl VALUES ("PS139_14","020_139_14","PSA","139","14","14","Tai shográ gerán ke man chó wassh o zébá jórh butagán, tai kár hayrán kanók ant, man eshiá sharra zánán. ");
INSERT INTO bcc_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","15","Mani haddh cha taw chér naatant wahdé chér o andémén jágahá addh bayagá atán, wahdé zeminay johlánkián man gwapag o yakjáh kanag bayagá atán. ");
INSERT INTO bcc_vpl VALUES ("PS139_16","020_139_16","PSA","139","16","16","Tai chammán mani násarjamén ján dist, mani zenday sajjahén róch tai ketábá nebeshtah kanag butant, cha hamá wahdá pésar ke cha é róchán yakké ham nayátkagat. ");
INSERT INTO bcc_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","17","Oo Hodá! Tai hayál pa man chón bébahá ant, eshán hesáb nést. ");
INSERT INTO bcc_vpl VALUES ("PS139_18","020_139_18","PSA","139","18","18","Agan hesáb kanagesh belóthán, cha rékáni dánagán géshter ant. Wahdé ágaha bán, angat gón taw án. ");
INSERT INTO bcc_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","19","Taw badkár bekoshténant, oo Hodá! Cha man dur bét, oo hónwárán! ");
INSERT INTO bcc_vpl VALUES ("PS139_20","020_139_20","PSA","139","20","20","É pa badén maksadé tai námá gerant, tai helápá kopra kanant. ");
INSERT INTO bcc_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Oo Hodáwand! Man cha áyán sakk bézár án ke cha taw naprata kanant o cha áyán watá dura dárán ke tai helápá jáha janant. ");
INSERT INTO bcc_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Ji haw! Man gón áyán sakk naprata kanán, á mani dozhmen jórh butagant. ");
INSERT INTO bcc_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Oo Hodá! Maná bechakkás o mani delá bezán, maná bechakkás o mani paréshánián delgósh kan. ");
INSERT INTO bcc_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Agan cha mani káréá delranj ay maná péshi dár o karnigén ráhá maná rahshón bay. ");
INSERT INTO bcc_vpl VALUES ("PS140_1","020_140_1","PSA","140","1","1","Pa sázger o washalhánáni sálárá. Dáuday Zabur. Hodáwand! Maná cha badkárán pahréz o cha hezhmnákán berakkén, ");
INSERT INTO bcc_vpl VALUES ("PS140_2","020_140_2","PSA","140","2","2","cha hamáyán ke wati delá badén pandala sázant o har róch jangé páda kanant. ");
INSERT INTO bcc_vpl VALUES ("PS140_3","020_140_3","PSA","140","3","3","Wati zobáná chó márá téza kanant o garrmáray zahresh lontháni chérá ent. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS140_4","020_140_4","PSA","140","4","4","Hodáwand! Maná cha badkáráni dastá dur bedár o cha hezhmnákán berakkén ke pa mani pádán dám sázagá ant. ");
INSERT INTO bcc_vpl VALUES ("PS140_5","020_140_5","PSA","140","5","5","Gorunákán pa man dám chér gétkag, dámi chammag. Mani ráhá talkesh chér kortag. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS140_6","020_140_6","PSA","140","6","6","Gón Hodáwandá gwashán: “Taw mani Hodá ay.” Mani peryát o záriá gósh dár, oo Hodáwand! ");
INSERT INTO bcc_vpl VALUES ("PS140_7","020_140_7","PSA","140","7","7","Oo Hodáwand, mani mohkamén Hodáwand o rakkénók! Jangay róchá taw mani saray negahpáni kort. ");
INSERT INTO bcc_vpl VALUES ("PS140_8","020_140_8","PSA","140","8","8","Hodáwand! Badkáráni armánán purah makan, wahdé orosha kanant áyáni pandalán sóbén bayagá mayl. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS140_9","020_140_9","PSA","140","9","9","Áyán ke maná angerr kortag, áyáni lontháni badi, áyáni jenday sará bekápát. ");
INSERT INTO bcc_vpl VALUES ("PS140_10","020_140_10","PSA","140","10","10","Rókén eshkaresh sará berechát, ásá dawr dayag bátant o pujgelén kaddhán boddhátant o hechbar dar átk makanátant. ");
INSERT INTO bcc_vpl VALUES ("PS140_11","020_140_11","PSA","140","11","11","Pléndh may sardhagárá ábád mabátant, hezhmnákáni sará baláhé kapát. ");
INSERT INTO bcc_vpl VALUES ("PS140_12","020_140_12","PSA","140","12","12","Mana zánán ke Hodáwand pa bazzagán dadrasi o pa hájatmandán adl o ensápa kant. ");
INSERT INTO bcc_vpl VALUES ("PS140_13","020_140_13","PSA","140","13","13","Pahrézkár zalur tai námay shográ gerant o nékdel tai bárgáhá jahmenenda bant. ");
INSERT INTO bcc_vpl VALUES ("PS141_1","020_141_1","PSA","141","1","1","Dáuday Zabur Oo Hodáwand! Tará tawára kanán, zutt pa man byá. Wahdé tará tawára kanán, mani tawárá gósh dár. ");
INSERT INTO bcc_vpl VALUES ("PS141_2","020_141_2","PSA","141","2","2","Mani dwá tai bárgáhá chó sóchokiá kabul bát o mani chest butagén dast, bégáhay korbánigay paymá. ");
INSERT INTO bcc_vpl VALUES ("PS141_3","020_141_3","PSA","141","3","3","Hodáwand! Pa mani dapá negahpáné bedár o mani lontháni darwázagay dapá páspáni bekan. ");
INSERT INTO bcc_vpl VALUES ("PS141_4","020_141_4","PSA","141","4","4","Mani delá mayl ke dém pa badkáriá berawt o man badkáráni hamráhiá sellén kárán gón bebán, maná áyáni washtámén chizzáni waragá mayl. ");
INSERT INTO bcc_vpl VALUES ("PS141_5","020_141_5","PSA","141","5","5","Bell maná pahrézkáré shahmát bejant, é rahmé, bell maná hakkal bedant, é pa mani sará rógené, man cha eshiá enkára nakanán, angat mani dwá, badkáráni káráni helápá bit. ");
INSERT INTO bcc_vpl VALUES ("PS141_6","020_141_6","PSA","141","6","6","Esháni hákem, cha talárán jahlád dawr dayaga bant, gorhá zánant ke mani habar sharr o rást ant. ");
INSERT INTO bcc_vpl VALUES ("PS141_7","020_141_7","PSA","141","7","7","Gwashant: “Anchosh ke yakké zeminá nangára kant o derrit, may haddh, mordagáni jahánay dapá sheng o sháng butagant.” ");
INSERT INTO bcc_vpl VALUES ("PS141_8","020_141_8","PSA","141","8","8","Bale mani chamm tará sakk ant, Hodáwand, oo Hodáwand! Tai mayára bán, maná markay dastá maday. ");
INSERT INTO bcc_vpl VALUES ("PS141_9","020_141_9","PSA","141","9","9","Maná cha hamá dámá berakkén ke badkárán chér gétkag, cha áyáni talká. ");
INSERT INTO bcc_vpl VALUES ("PS141_10","020_141_10","PSA","141","10","10","Badkár wat, wati dámán kapátant o man pa salámati begwazátán. ");
INSERT INTO bcc_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Dáuday shayri gwashtánk, hamá wahdá ke gáray tahá at. Dwáé. Hodáay bárgáhá zár o peryáta kanán o cha Hodáwandá rahma lóthán. ");
INSERT INTO bcc_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","2","Wati gelagán hamáiay bárgáhá kanán o wati sakki o sórián hamáiá gwashán. ");
INSERT INTO bcc_vpl VALUES ("PS142_3","020_142_3","PSA","142","3","3","Arwáh ke mani bátená béwára bit, taw ay ke mani ráhay rahshón ay. Hamá ráhá ke mana rawán pa man dámé chéresh gétkag. ");
INSERT INTO bcc_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Mani rástén némagá bechár, kass nést ke mani hayálá bebit. Maná panáh nést o kass mani zenday pegrá naent. ");
INSERT INTO bcc_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Oo Hodáwand! Tai bárgáhá peryáta kanán o gwashán: “taw mani panáhjáh ay o zendagénáni zeminá mani bahr.” ");
INSERT INTO bcc_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Mani peryátá gósh dár ke man mazanén sakki o sórián kaptagán. Maná cha á mardomán berakkén ke mani randá kaptagant, chéá ke cha man zórákter ant. ");
INSERT INTO bcc_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Maná cha kaydá dar kan ke tai námá benázénán. Gorhá pahrézkár mani chapp o chágerdá moccha bant ke taw pa man nékia kanay. ");
INSERT INTO bcc_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Dáuday Zabur. Oo Hodáwand! Mani dwáyá gósh dár mani peryát o záriá beshkon, pa wati wapádári o adlaygi maná passaw beday. ");
INSERT INTO bcc_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Wati hezmatkárá mayárig makan ke tai bárgáhá kass bémayár naent. ");
INSERT INTO bcc_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Dozhmen mani randá kaptag, áiá maná zeminá dawr dátag, maná taháriá jahmenendi kortag kwahnén mordagáni paymá. ");
INSERT INTO bcc_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Arwáh mani daruná nezór ent o delon mán bátená hayrán. ");
INSERT INTO bcc_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Kwahnén zamánagán yáta kanán tai sajjahén káráni sará pegra kanán, tai dastáni kortagén káráni hayálá kapán. ");
INSERT INTO bcc_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Wati dastán tai némagá shahárán, man pa taw tonnig án, chó hoshkén dhagáréá. Ósht... ");
INSERT INTO bcc_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Hodáwand! Maná zutt passaw day, mani ruhá dam bortag, wati démá cha man chér maday, ke hamáyáni paymá bán ke kall o kabrá kapant. ");
INSERT INTO bcc_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Bámgwáhán tai mehray habará beshkonátán, ke man tai sará tawkal kortag, sój day ke kojám ráhá berawán, ke man wati zend tai dastá dátag. ");
INSERT INTO bcc_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Oo Hodáwand! Maná cha dozhmenán berakkén, man tai kerrá chéra bán. ");
INSERT INTO bcc_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Maná tálim beday ke tai razáay sará kár bekanán, chéá ke taw mani Hodá ay, tai nékén Ruh tachkén ráhá mani rahshón bát. ");
INSERT INTO bcc_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Oo Hodáwand! Pa wati námaygi maná zendag bedár, pa wati adlaygi, maná cha sakki o sórián dar kan. ");
INSERT INTO bcc_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Wati mehray tahá mani dozhmenán tabáh kan, mani badwáhán gár o bégwáh kan, ke man tai hezmatkár án. ");
INSERT INTO bcc_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Dáuday Zabur. Hodáwandá satá bát, mani talárá, ke mani dastán pa jangá dara kárit o mani lankokán pa merhagá. ");
INSERT INTO bcc_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Hamá mani mehr kanókén Hodá o kalát ent, mani sangar ent o mani rakkénók, mani espar, ke áiay mayára bán, ke mani kawmá mani chérdasta kant. ");
INSERT INTO bcc_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Hodáwand! Ensán chié ke taw áiá mán byáray, bani ádám chié ke taw áiay hayálá bedáray? ");
INSERT INTO bcc_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Ensánay zend chó damkasshéá ent o róchi chó gwazókén sáhegéá. ");
INSERT INTO bcc_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Hodáwand! Ásmáná derr o jahlád byá, kóhán dast jan ke cha eshán dutt dar byayt. ");
INSERT INTO bcc_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Wati gerókán sheng kan ke dozhmen sheng o sháng bebant, wati tirán shán o sargardánesh kan. ");
INSERT INTO bcc_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Dastá cha borzád shahár, maná ázát kan o berakkén cha bázén ápán, cha darámadáni dastán, ");
INSERT INTO bcc_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","ke dapesh cha drógá porr ant o rástén dastesh cha prébá. ");
INSERT INTO bcc_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Man pa taw nókén sawté janán, oo Hodá! Dahtárén soróz o changay sará pa taw sáza janán, ");
INSERT INTO bcc_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","pa hamáiá ke bádsháhán sóbéna kant o wati hezmatkárén Dáudá rakkénit, cha koshókén zahmá. ");
INSERT INTO bcc_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Maná berakkén o cha darámadáni dastá ázát kan, ke dapesh cha drógá porr ant o rástén dastesh cha prébá. ");
INSERT INTO bcc_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Gorhá may bachakk, warnáiá chó rostagén drachká bant o may jenekk chó washtráshtagén menoká ke pa kalátán tráshag butagant. ");
INSERT INTO bcc_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","May ambár, cha har paymén bar o samará porra bant o may ramag hazáráni hesábá gésha bant, dahán hazáráni hesábá, may dhagárán. ");
INSERT INTO bcc_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","May áposén gók báz báz chokka kárant o dozhmen may diwálán próshta nakanant, kass bandiga nabit o may bázárán nálag o peryáta namacchit. ");
INSERT INTO bcc_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Bahtáwar hamá mardom ant ke hamé dhawlá bant, bahtáwar hamá ant ke Hodáwand áyáni Hodá ent. ");
INSERT INTO bcc_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Satá o saná. Dáuday Zabur. Tai shán o shawkatá názénán, oo mani Hodá! Oo bádsháh! Tai námá satá kanán, abad tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Tará har rócha názénán o tai námá satá kanán, abad tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Hodáwand mazan ent o satáay báz láhek, kass áiay mazaniá kadd o kesás korta nakant. ");
INSERT INTO bcc_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Naslé pa domi naslá tai káráni satáyá kant o tai mazanén káráni kessahána kárit. ");
INSERT INTO bcc_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Man tai mazanén shán o shawkatay sará pegra kanán, tai bákamálén káráni sará. ");
INSERT INTO bcc_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Tai bákamálén káráni zóráwari hamok zobánay sará ent o man tai mazanén káráni járá janán. ");
INSERT INTO bcc_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Tai mazanén sharriáni kessahána kárant o tai adlay sawtá janant. ");
INSERT INTO bcc_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Hodáwand mehrabán o rahm kanók ent, hezhm geragá déra kant o mehri báz ent. ");
INSERT INTO bcc_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Hodáwand gón sajjahénán nék ent o wati sajjahén addh kortagénáni sará rahma kant. ");
INSERT INTO bcc_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Oo Hodáwand! Tai dastay hamok kár tai shográ gipt, tai wapádár tará názénant. ");
INSERT INTO bcc_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","11","Tai bádsháhiay shán o shawkatay habará kanant o tai zóray mesálána dayant, ");
INSERT INTO bcc_vpl VALUES ("PS145_12","020_145_12","PSA","145","12","12","tánke sajjahén baniádam tai zóráwarén kárán jár bejanant, tai bádsháhiay shán o shawkatá. ");
INSERT INTO bcc_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Tai bádsháhi abadi bádsháhié o tai hákemi nasláni nasl barjáha mánit. ");
INSERT INTO bcc_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Harkas ke kapit, Hodáwand áiá dárit o harkas ke lagatmál ent, Hodáwand áiá chesta kant. ");
INSERT INTO bcc_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Sajjahénáni chamm pa taw sakk ant o taw áyáni rózigá pa wahda bakshay. ");
INSERT INTO bcc_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Taw wati dastá pacha kanay o har zendagénay wáhagán puraha kanay. ");
INSERT INTO bcc_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Hodáwand wati hamok ráhá ádel ent, wati sajjahén kárán wapádár. ");
INSERT INTO bcc_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Harkas ke Hodáwandá tawára kant, Hodáwand áiay nazzikká ent, harkas ke pa del o setk áiá tawára kant. ");
INSERT INTO bcc_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Harkasá ke Hodáay tors delá ent, Hodá áiay wáhagán puraha kant o áiay peryátán gósha dárit o rakkéniti. ");
INSERT INTO bcc_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Hodáwand wati sajjahén dóst dárókáni negahpán ent o sajjahén badkárán tabáha kant. ");
INSERT INTO bcc_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Mani dap Hodáwandá názénit, sajjahén sahdár áiay pákén námá satá bedayátant, abad tán abad. ");
INSERT INTO bcc_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","Hodáwandá benázénét, Halléluyá. Oo mani arwáh! Hodáwandá benázén. ");
INSERT INTO bcc_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Tán zendag án Hodáwandá satá kanán tánke hastán wati Hodáyá názénán. ");
INSERT INTO bcc_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","3","Shahzádagáni sará tawkal makanét, mardománi sará, ke rakkénta nakanant. ");
INSERT INTO bcc_vpl VALUES ("PS146_4","020_146_4","PSA","146","4","4","Arwáhesh ke dara kayt, zeminá pera tarrant o hamá róchá áyáni sajjahén shawr o hayál gár o zawála bant. ");
INSERT INTO bcc_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Bahtáwar hamá ent Ákubay Hodá áiay komakk ent, hamá ke ométi wati Hodáwandén Hodáay sará ent, ");
INSERT INTO bcc_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","hamáiay sará ke zemin o ásmánay jórh kanók ent o daryá o har ché ke daryáyá hast, hamáiay sará ke tán abad wapádár ent, ");
INSERT INTO bcc_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","zolm distagénáni dadrasiá kant o shodigán waráka dant. Hodáwand bandigán ázáta kant, ");
INSERT INTO bcc_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Hodáwand kóráni chammán pacha kant, Hodáwand hamáyán chesta kant ke lagatmál ant, Hodáwand pahrézkárán dósta dárit, ");
INSERT INTO bcc_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Hodáwand darámadáni negahpániá kant o chóraw o janózámáni hayálá dárit, bale badkáráni ráhá chapp o chótha kant. ");
INSERT INTO bcc_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Hodáwand tán abad bádsháhia kant, tai Hodá, oo Sahyun, nasláni nasl. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","Hodáwandá benázénét, Halléluyá, may Hodáay názénag chón wassh ent o áiay satá kanag delkassh. ");
INSERT INTO bcc_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Hodáwand Urshalimá cha nóksará addha kant o Esráilay darándhéhán yakjáha kant. ");
INSERT INTO bcc_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Proshtadelán dráha kant o thappánesha bandit. ");
INSERT INTO bcc_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Estárán hesába kant o har yakkéá pa nám tawára kant. ");
INSERT INTO bcc_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","May Hodáwand mazan ent, zóri békesás, áiay zánt o zánagá kadd o kesás nést. ");
INSERT INTO bcc_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Hodáwand békebrán komaka kant, bale badkárán zeminá dawra dant. ");
INSERT INTO bcc_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Hodáwandá gón shogrgozári benázénét, pa may Hodáyá soróz o chang bejanét. ");
INSERT INTO bcc_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Á, ásmáná gón jambara póshénit o zeminá hawra bakshit o kóháni sará sabzaga ródénit. ");
INSERT INTO bcc_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Á, haywánán waráka dant o gwarágán ham, wahdé peryáta kanant. ");
INSERT INTO bcc_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Á, aspáni zórá gala nabit o na ke jangóláni pádán. ");
INSERT INTO bcc_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Hodáwand hamáyáni sará wassha bit ke cha áiá torsant o sajjahén óst o ométesh gón áiay mehrá ent. ");
INSERT INTO bcc_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Oo Urshalim! Hodáwandá satá kan, Oo Sahyun! Hodáwandá benázén. ");
INSERT INTO bcc_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Hamá tai darwázagáni karhián mohra dárit o tai diwáláni tahá, tai chokkán barkata dant. ");
INSERT INTO bcc_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Tai marz o simsarán émena kant o tará cha gehterén gandomá sérlápa kant. ");
INSERT INTO bcc_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Wati hokmá zeminá ráha dant o áiay habar téziá shenga bit. ");
INSERT INTO bcc_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Barpá chó pazhmá shenga kant o nódá poray paymá shánka dant. ");
INSERT INTO bcc_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Tróngalá nánay hurdagáni paymá éra dant, kay áiay barpén sártiay démá óshtáta kant? ");
INSERT INTO bcc_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Wati habará ráha dant o har chizz ápa bit, wati gwátá déma dant o ápa rombant o tachant. ");
INSERT INTO bcc_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Wati habará pa Ákubá áshkára kant o wati hokm o parmáná pa Esráilá. ");
INSERT INTO bcc_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","É kári pa dega hecch kawméá nakort o é dega kawm áiay rahbandána nazánant. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS148_1","020_148_1","PSA","148","1","1","Hodáwandá benázénét, Halléluyá. Cha ásmánán Hodáwandá benázénét, borzén jágahán áiá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS148_2","020_148_2","PSA","148","2","2","Oo áiay sajjahén préshtagán! Áiá satá kanét. Oo áiay sajjahén ásmáni lashkarán! Áiá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS148_3","020_148_3","PSA","148","3","3","Oo máh! Oo róch! Áiá satá kanét. Oo sajjahén drapshnákén estárán! Áiá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS148_4","020_148_4","PSA","148","4","4","Oo borzén arsh! Áiá satá kan. Oo ásmánay sarboray ápán! Áiá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS148_5","020_148_5","PSA","148","5","5","É sajjahén, Hodáwanday námá satá bekanátant, chéá ke cha hamáiay hokmá jórh butagant. ");
INSERT INTO bcc_vpl VALUES ("PS148_6","020_148_6","PSA","148","6","6","Hamáiá é sajjahén, abad tán abad barjáh dáshtagant o anchén hokmé dáti ke hechbar dawr dayag o nákár kanaga nabit. ");
INSERT INTO bcc_vpl VALUES ("PS148_7","020_148_7","PSA","148","7","7","Hodáwandá cha zeminá satá kanét, shomá oo sajjahén daryái sahdárán o zeray sajjahén johlánkián, ");
INSERT INTO bcc_vpl VALUES ("PS148_8","020_148_8","PSA","148","8","8","oo gerók o tróngal, barp o jambarán, oo tupánén gwátán ke hamáiay hokmá barjáha dárét, ");
INSERT INTO bcc_vpl VALUES ("PS148_9","020_148_9","PSA","148","9","9","oo kóh o sajjahén jompán, oo nibagi drachk o sajjahén gazzán, ");
INSERT INTO bcc_vpl VALUES ("PS148_10","020_148_10","PSA","148","10","10","oo rastar o sajjahén dalwatán, oo kasánén jánwar o báli morgán, ");
INSERT INTO bcc_vpl VALUES ("PS148_11","020_148_11","PSA","148","11","11","oo zeminay bádsháh o sajjahén kawmán, oo zeminay shahzádag o sajjahén hákemán, ");
INSERT INTO bcc_vpl VALUES ("PS148_12","020_148_12","PSA","148","12","12","oo warnáén mardén o janénán, oo pirénán, gón chokkán yakjáh! ");
INSERT INTO bcc_vpl VALUES ("PS148_13","020_148_13","PSA","148","13","13","É sajjahén, Hodáwanday námá satá bekanátant, chéá ke tahná hamáiay nám mazanshán ent, hamáiay shán o shawkat cha zemin o ásmáná borzádter ent. ");
INSERT INTO bcc_vpl VALUES ("PS148_14","020_148_14","PSA","148","14","14","Áiá kánthé pa wati kawmá borz kortag, áiay sajjahén wapádárén hezmatkáráni satá, Esráilay satá, kawmé ke gón áiay delá nazzikk ent. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS149_1","020_149_1","PSA","149","1","1","Hodáwandá benázénét, Halléluyá. Pa Hodáwandá nókén sawté bejanét o áiá, áiay wapádáráni mocchiá benázénét. ");
INSERT INTO bcc_vpl VALUES ("PS149_2","020_149_2","PSA","149","2","2","Esráil pa wati addh kanóká shádehi bekanát, Sahyunay chokk pa wati bádsháhá gal bátant. ");
INSERT INTO bcc_vpl VALUES ("PS149_3","020_149_3","PSA","149","3","3","Gón nách áiay námá satá bedayát o áiá gón zháng o chang benázénátant. ");
INSERT INTO bcc_vpl VALUES ("PS149_4","020_149_4","PSA","149","4","4","Chéá ke Hodáwand cha wati kawmá washnód ent, á békebrán sóbmandiay tájá bakshit. ");
INSERT INTO bcc_vpl VALUES ("PS149_5","020_149_5","PSA","149","5","5","Áiay wapádár gón é pahrá shádehi bekanát o wati gandaláni tahá shádehiay sawt bejanátant. ");
INSERT INTO bcc_vpl VALUES ("PS149_6","020_149_6","PSA","149","6","6","Hodáwanday satá o sanáesh dapá bát o dodapén zahmesh dastá ");
INSERT INTO bcc_vpl VALUES ("PS149_7","020_149_7","PSA","149","7","7","ke cha ráján bér begerant o kawmán sezá bedayant, ");
INSERT INTO bcc_vpl VALUES ("PS149_8","020_149_8","PSA","149","8","8","bádsháhánesh pa zamzil bebandant o sardáránesh pa ásenén pádband, ");
INSERT INTO bcc_vpl VALUES ("PS149_9","020_149_9","PSA","149","9","9","tánke hamá dadrasiá barjáh bekanant ke esháni helápá nebeshtah kanag butag, é, áiay sajjahén wapádáráni shán ent. Hodáwandá benázénét, Halléluyá. ");
INSERT INTO bcc_vpl VALUES ("PS150_1","020_150_1","PSA","150","1","1","Hodáwandá benázénét, Halléluyá. Hodáyá áiay pákén arshá satá kanét, áiay zór o wákay ásmánán. ");
INSERT INTO bcc_vpl VALUES ("PS150_2","020_150_2","PSA","150","2","2","Pa áiay porwákén kárán áiá satá kanét, pa áiay kámelén mazaniá áiá satá kanét. ");
INSERT INTO bcc_vpl VALUES ("PS150_3","020_150_3","PSA","150","3","3","Áiá gón sornáay tawárá satá kanét, gón soróz o changán satái kanét. ");
INSERT INTO bcc_vpl VALUES ("PS150_4","020_150_4","PSA","150","4","4","Áiá gón zháng o nách satá kanét, gón simmi sázán o nalá satái kanét. ");
INSERT INTO bcc_vpl VALUES ("PS150_5","020_150_5","PSA","150","5","5","Áiá gón dhohlán satá kanét, gón borztawárén dhohlán. ");
INSERT INTO bcc_vpl VALUES ("PS150_6","020_150_6","PSA","150","6","6","Har chizzá ke sáh mán, Hodáwandá satá bekanát. Hodáwandá benázénét, Halléluyá.");
INSERT INTO bcc_vpl VALUES ("DN1_1","028_1_1","DAN","1","1","1","Yahudáay bádsháh Yehóyákimay dawray sayomi sálá, Bábelay bádsháh Nebukadnezar átk o Urshalimi angerr kort. ");
INSERT INTO bcc_vpl VALUES ("DN1_2","028_1_2","DAN","1","2","2","Cha Hodáwanday razáyá Yahudáay bádsháh, Yehóyákimi prósh dát. Bádsháhay jend o Hodáay lógay lahtén darpi gón wat Bábelay sardhagárá, wati hodáay lógá áwort o darpi wati hodáay lógay hazánagá ér kortant. ");
INSERT INTO bcc_vpl VALUES ("DN1_3","028_1_3","DAN","1","3","3","Padá bádsháhá wati darbáray kármaster, Ashpenaz hokm dát ke cha Esráili chokkán lahtén anchén byár ke cha bádsháhi nasl o sharapmandén hándánán bebant, ");
INSERT INTO bcc_vpl VALUES ("DN1_4","028_1_4","DAN","1","4","4","anchén warná ke hecch paymén badani aybesh mán mabit o rangá dhawldár bebant, har dhawlén hekmatá balad bayagay láhek, zántkár o zut‌pahm bebant o bádsháhay bárgáhá óshtagá bekarzant. Padá é warnáyán Bábelay Aramái zobán o labzánká bwánén. ");
INSERT INTO bcc_vpl VALUES ("DN1_5","028_1_5","DAN","1","5","5","Bádsháhá esháni har róchigén warák o sharáb cha wati jenday warák o sharábá gechén kort o hokmi dát ke tán say sálá eshán sharr bwánénét o zántkár kanét o padá mani hezmatá bóshtárénét. ");
INSERT INTO bcc_vpl VALUES ("DN1_6","028_1_6","DAN","1","6","6","Esháni nyámá cha Yahudáyá áwortagén Dányál, Hanániá, Misháél o Azaryá hawár atant. ");
INSERT INTO bcc_vpl VALUES ("DN1_7","028_1_7","DAN","1","7","7","Darbáray kármasterá áyáná nókén nám per kort. Dányálay námi Beltesházar, Hanániáay Shadrak, Misháélay Mishak o Azaryáay Abednegó kort. ");
INSERT INTO bcc_vpl VALUES ("DN1_8","028_1_8","DAN","1","8","8","Dányálá erádáh kort ke man watá gón sháhi warák o sharábán palita nakanán. Gorhá áiá gón darbáray kármasterá dazbandi kort ke agan taw razá dayay, man é warákána nawarán o watá palita nakanán. ");
INSERT INTO bcc_vpl VALUES ("DN1_9","028_1_9","DAN","1","9","9","Nun Hodáyá kármasteray delá pa Dányálá mehr o hamdardi pédá kort, ");
INSERT INTO bcc_vpl VALUES ("DN1_10","028_1_10","DAN","1","10","10","bale kármasterá angat gón Dányálá gwasht: “Maná cha wati wájahén bádsháhá torsit. Áiá wat pa shomá warák o sharáb gechén kortag. Agan á begendit ke shomá cha wati é dega hamsarókén warnáyán nezórter ét, gorhá? É paymá, shomá bádsháhay dastá mani sará borráénét.” ");
INSERT INTO bcc_vpl VALUES ("DN1_11","028_1_11","DAN","1","11","11","Kármaster Ashpenázá pa Dányál, Hanániá, Misháél o Azaryáyá yakk apsaré dáshtagat. Dányálá gón hamé apsará gwasht: ");
INSERT INTO bcc_vpl VALUES ("DN1_12","028_1_12","DAN","1","12","12","“Mehrabáni bekan o márá tán dah róchá bechakkás o bechár, bell ke márá pa waragá tahná sabzi o pa nóshagá tahná áp dayag bebit. ");
INSERT INTO bcc_vpl VALUES ("DN1_13","028_1_13","DAN","1","13","13","Padá márá gón hamá warnáyán dém pa dém bekan o bechár ke sháhi warákán waragá ant. Agan má nezórter butén, randá gón má hamá paymá bekan ke tai dela gwashit.” ");
INSERT INTO bcc_vpl VALUES ("DN1_14","028_1_14","DAN","1","14","14","Gorhá apsará áyáni habar mannet o tán dah róchá á chakkásetant. ");
INSERT INTO bcc_vpl VALUES ("DN1_15","028_1_15","DAN","1","15","15","Dahén rócháni halásiá distesh ke á, cha é dega warnáyán jándráhter o pazzórter ant ke sháhi warákesh wártagat. ");
INSERT INTO bcc_vpl VALUES ("DN1_16","028_1_16","DAN","1","16","16","Gorhá apsará sháhi warák o sharáb, cha áyáni waráká dar kortant o áyáná sabzia dát. ");
INSERT INTO bcc_vpl VALUES ("DN1_17","028_1_17","DAN","1","17","17","É chárén warná, Hodáyá labzánk o hekmatay har paymén zánt o honar dayán kortant. Dányál har warhén elhám o shobén o wábáni mánáyá ham balad at. ");
INSERT INTO bcc_vpl VALUES ("DN1_18","028_1_18","DAN","1","18","18","Gorhá bádsháh Nebukadnezaray gisshéntagén sayén sál ke sarjam butant, darbáray kármasterá é sajjahén warná áwort o bádsháhay bárgáhá pésh kortant. ");
INSERT INTO bcc_vpl VALUES ("DN1_19","028_1_19","DAN","1","19","19","Wahdé bádsháhá gón áyán gapp o trán kort, disti ke dega kas Dányál, Hanániá, Misháél o Azaryáay paymá naent. Gorhá é chárén bádsháhay jenday hezmatá dárag butant. ");
INSERT INTO bcc_vpl VALUES ("DN1_20","028_1_20","DAN","1","20","20","Bádsháhá harché ke jost kortant, disti ke é mardom har paymén hekmat o sarpadiá cha molkay sajjahén jáduger o sáherán dah sari sharter ant. ");
INSERT INTO bcc_vpl VALUES ("DN1_21","028_1_21","DAN","1","21","21","Dányál, tán Kurosh bádsháhay dawray awali sálá hamódá mant. ");
INSERT INTO bcc_vpl VALUES ("DN2_1","028_2_1","DAN","2","1","1","Nebukadnezará wati bádsháhi dawray domi sálá wáb dist. Áiay arwáh bétáhir but o á wába nakapt. ");
INSERT INTO bcc_vpl VALUES ("DN2_2","028_2_2","DAN","2","2","2","Gorhá bádsháhá jáduger, sáher, jennband o nojumiáni lótháénagay hokm dát ke áiay wábán máná bekanant. Á, átk o bádsháhay démá óshtátant. ");
INSERT INTO bcc_vpl VALUES ("DN2_3","028_2_3","DAN","2","3","3","Bádsháhá gón áyán gwasht: “Man wábé distag o mani arwáh pa é wábay mánáay zánagá bétáhir ent.” ");
INSERT INTO bcc_vpl VALUES ("DN2_4","028_2_4","DAN","2","4","4","Gorhá nojumián gón bádsháhá Aramái zobáná gwasht: “Oo bádsháh! Modám zendag bátay. Márá wábá begwash. Má pa taw mánáia kanén.” ");
INSERT INTO bcc_vpl VALUES ("DN2_5","028_2_5","DAN","2","5","5","Bádsháhá gón nojumián gwasht: “Mani gapp yakké. Agan shomá mani wábá magwashét o máná makanét, shomá thokkor thokkor kanaga bét o shomay lóg tabáh kanag o hákóth jórh kanaga bant. ");
INSERT INTO bcc_vpl VALUES ("DN2_6","028_2_6","DAN","2","6","6","Bale agan shomá wábá begwashét o máná bekanét, shomárá cha mani némagá théki o tohpah, mozz o mazanén sharap o ezzaté rasit. Paméshká maná mani wáb o wábay mánáyá begwashét.” ");
INSERT INTO bcc_vpl VALUES ("DN2_7","028_2_7","DAN","2","7","7","Áyán yakk randé padá gwasht: “Ji bádsháh! Márá wábá begwash, má mánáia kanén.” ");
INSERT INTO bcc_vpl VALUES ("DN2_8","028_2_8","DAN","2","8","8","Bádsháhá gwasht: “Man saddak án ke shomá pa wahdzawáliá é habarán kanagá ét. Shomá gendagá ét ke mani hokm yakk o thekk ent ");
INSERT INTO bcc_vpl VALUES ("DN2_9","028_2_9","DAN","2","9","9","ke agan shomá maná wábá magwashét, pa shomá sezá yakkén ent. Shomá watmánwatá shawr kortag ke mani démá chapp o chóthén habar bekanét o dróg bebandét tán hamá wahdá ke wahd o jáwar badal bebant. Paméshká shomá wat maná wábá begwashét, gorhá nun mana zánán ke shomá mánái ham korta kanét.” ");
INSERT INTO bcc_vpl VALUES ("DN2_10","028_2_10","DAN","2","10","10","Nojumián, bádsháhay passawá gwasht: “Oo bádsháh! Donyáyá hecch choshén mardomé nést ke é kárá kort bekant. Hecch bádsháhá, harchont ke mazan o zóráwar bebit, hechbar cha hecch jáduger, sáher o nojumiá choshén parmáeshé nakortag. ");
INSERT INTO bcc_vpl VALUES ("DN2_11","028_2_11","DAN","2","11","11","É kárá ke tawe bádsháh lóthagá ay, sakk grán ent. Cha hodáyán abéd, é habará kass bádsháhá gwashta nakant, o hodá wa ensánáni nyámá naneshtagant.” ");
INSERT INTO bcc_vpl VALUES ("DN2_12","028_2_12","DAN","2","12","12","Gón é habaráni eshkonagá bádsháh cha zahrá sakk hezhm gept o hokmi dát ke Bábelay sajjahén dánáén mardom gár o gomsár kanag bebant. ");
INSERT INTO bcc_vpl VALUES ("DN2_13","028_2_13","DAN","2","13","13","Gorhá parmáné dayag but ke dáná koshag bebant. Dányál o áiay sangatáni shóházá ham dar kaptant ke bekoshantesh. ");
INSERT INTO bcc_vpl VALUES ("DN2_14","028_2_14","DAN","2","14","14","Nun Dányálá gón jalládáni sarmaster, Áryuká ke Bábelay dánáyáni koshagá dar kaptagat, pa hekmat o dánái habar kort. ");
INSERT INTO bcc_vpl VALUES ("DN2_15","028_2_15","DAN","2","15","15","Dányálá cha bádsháhay dáshtagén sarmaster, Áryuká jost kort: “Bádsháhá chéá choshén trondén parmáné dátag?” Áryuká, Dányál hál dát ke ché butag. ");
INSERT INTO bcc_vpl VALUES ("DN2_16","028_2_16","DAN","2","16","16","Nun Dányál shot o gón bádsháhá dazbandi‌i kort ke maná kammé wahd beday, man tawe bádsháhay wábá gwashán o máná kanán. ");
INSERT INTO bcc_vpl VALUES ("DN2_17","028_2_17","DAN","2","17","17","Dányál, lógá shot o wati sangat, Hanániá, Misháél o Azaryái hál dátant. ");
INSERT INTO bcc_vpl VALUES ("DN2_18","028_2_18","DAN","2","18","18","Gwashti: “Cha ásmáni Hodáyá rahm belóthét o dwá kanét ke é ráz pa má paddar bebit tánke máshomá o Bábelay é dega dáná koshag mabén.” ");
INSERT INTO bcc_vpl VALUES ("DN2_19","028_2_19","DAN","2","19","19","Gorhá hamá shapá é ráz pa Dányálá, shobénéá paddar kanag but. Nun Dányálá ásmáni Hodáay satá kort. ");
INSERT INTO bcc_vpl VALUES ("DN2_20","028_2_20","DAN","2","20","20","Gwashti: “Hodáay námá abad tán abad satá o saná bát, chéá ke hekmat o zór hamáiayg ant. ");
INSERT INTO bcc_vpl VALUES ("DN2_21","028_2_21","DAN","2","21","21","Hamá ent ke wahd o mósomán badala kant, hamá ent ke bádsháhán dura kant yá tahtá nádénit, hamá ent ke dánáyán hekmata dant o sarpadénán zánta bakshit, ");
INSERT INTO bcc_vpl VALUES ("DN2_22","028_2_22","DAN","2","22","22","hamá ent ke chér o andémén rázán paddara kant, hamá ent ke zánt taháriá ché hast o rozhnái hamáiay hamráh ent. ");
INSERT INTO bcc_vpl VALUES ("DN2_23","028_2_23","DAN","2","23","23","Oo mani pet o pirokáni Hodá! Man tai shográ gerán o tai tawsipá kanán, chéá ke taw maná zór o hekmat dátag. Annun ham é taw ay ke pa man hamá chizzet záher kortag ke má cha taw lóthetag, chéá ke taw nun bádsháhay jérhah pa má paddar kortag.” ");
INSERT INTO bcc_vpl VALUES ("DN2_24","028_2_24","DAN","2","24","24","Randá Dányál, Áryukay kerrá shot, hamáiay kerrá ke bádsháhá Bábelay dánáyáni koshagay hokm dátagat. Gón áiá gwashti: “Bábelay dánáyán makosh. Maná bádsháhay kerrá bar. Man áiay wábá máná kanán.” ");
INSERT INTO bcc_vpl VALUES ("DN2_25","028_2_25","DAN","2","25","25","Gorhá Áryuká zutt zuttá Dányál, bádsháhay kerrá bort o gwashti: “Man cha Yahudáay darándhéhán mardé dar gétkag ke tawe bádsháhay wábá máná korta kant.” ");
INSERT INTO bcc_vpl VALUES ("DN2_26","028_2_26","DAN","2","26","26","Bádsháhá gón Dányálá ke domi námi Beltesházar at, gwasht: “Taw mani distagén wábá o áiay mánáyá maná gwashta kanay?” ");
INSERT INTO bcc_vpl VALUES ("DN2_27","028_2_27","DAN","2","27","27","Dányálá gón bádsháhá gwasht: “Hamá rázá ke tawe bádsháh áiay jostá ay, hecch dáná, sáher, jáduger o estárzánté pa taw paddar korta nakant, ");
INSERT INTO bcc_vpl VALUES ("DN2_28","028_2_28","DAN","2","28","28","bale ásmáná Hodáé hast ke rázán paddara kant o hamáiá pa tawe bádsháh Nebukadnezará záher kortag ke áyókén róchán ché bit. É tai wáb ent o hamá shobén ant ke wahdé taw wati nepáday sará tachk atay, tai saray tahá chakarragá atant. ");
INSERT INTO bcc_vpl VALUES ("DN2_29","028_2_29","DAN","2","29","29","Oo bádsháh! Nepáday sará tai hayál áyókén wahday némagá shotant ke bárén ché bayagi ent. Hamá ke rázán paddara kant, tará péshi dásht ke áyókén wahdá ché bit. ");
INSERT INTO bcc_vpl VALUES ("DN2_30","028_2_30","DAN","2","30","30","Bale é ráz pa man é sawabá paddar kanag nabutag ke man cha é dega mardomán dánáter án. Paméshká paddar kanag butag, ke man tai wábá pa tawe bádsháhá máná bekanán tánke taw wati delay hayálán sarpad bebay. ");
INSERT INTO bcc_vpl VALUES ("DN2_31","028_2_31","DAN","2","31","31","Oo bádsháh! Taw cháragá atay o baláhén boté distet. É mazanén o sakkén drapshnákén boté at ke tai démá mekk at o gendagá torsnák at. ");
INSERT INTO bcc_vpl VALUES ("DN2_32","028_2_32","DAN","2","32","32","É botay sar, cha pahkén teláhá addh butagat. Delband o báski cha nograhá, láp o ráni brenjayg atant, ");
INSERT INTO bcc_vpl VALUES ("DN2_33","028_2_33","DAN","2","33","33","dhilleng ásen, pádáni ném ásen o ném patkagén gelayg atant. ");
INSERT INTO bcc_vpl VALUES ("DN2_34","028_2_34","DAN","2","34","34","Taw angat cháragá atay o sengé sendag but, mardomi dastéá nasest. Seng átk o botay ásen o gelén pádán lagget o próshtanti. ");
INSERT INTO bcc_vpl VALUES ("DN2_35","028_2_35","DAN","2","35","35","Padá ásen, patkagén gel, brenj, nograh o teláh, sarjamá yakjáh hurt butant, anchosh ke garmágán jóhánay pog o palár hurta bant, o gwátá ropt o bortant tán áyáni hecch nesháné pasht nakapt. Bale hamá seng ke botá lagget, baláhén kóhé jórh but o sajjahén zemini gept. ");
INSERT INTO bcc_vpl VALUES ("DN2_36","028_2_36","DAN","2","36","36","Wáb esh at. Nun má eshiá tawe bádsháhay démá máná kanén. ");
INSERT INTO bcc_vpl VALUES ("DN2_37","028_2_37","DAN","2","37","37","Oo bádsháh! Taw bádsháháni bádsháh ay. Hamá ay ke ásmáni Hodáyá tará bádsháhi, kodrat, zór o wák o shán o shawkat dátag o ");
INSERT INTO bcc_vpl VALUES ("DN2_38","028_2_38","DAN","2","38","38","har jágah ke ensán, jangali jánwar o báli morg zendag ant, Hodáyá tará é sajjahénáni sará hokmrán kortag. Teláhén sar, taw ay. ");
INSERT INTO bcc_vpl VALUES ("DN2_39","028_2_39","DAN","2","39","39","Cha tará pad, dega bádsháhié kayt ke cha taigá kamzórtera bit. Padá sayomi, brenjén bádsháhié kayt ke sajjahén zeminay sará hokmránia kant. ");
INSERT INTO bcc_vpl VALUES ("DN2_40","028_2_40","DAN","2","40","40","Padá cháromi bádsháhié kayt ke chó ásená mohr o mohkama bit, chéá ke ásen sajjahén chizzána próshit o sheng o shánga kant. Anchosh ke ásen sajjahén chizzána próshit, é bádsháhi ham, é sajjahén molkána próshit o thokkor thokkora kant. ");
INSERT INTO bcc_vpl VALUES ("DN2_41","028_2_41","DAN","2","41","41","É pád o pádáni lankok ke némá patkagén gel o némá ásenayg atant o taw distant, é bahr o bángén bádsháhié bit, bale eshiay tahá ásenay mohri mána bit, chéá ke taw ásen gón patkagén gelá hawár dist. ");
INSERT INTO bcc_vpl VALUES ("DN2_42","028_2_42","DAN","2","42","42","Chosh ke pádáni lankok, némá ásen o némá patkagén gelayg atant, é bádsháhiay bahré mohkam o bahré nezóra bit. ");
INSERT INTO bcc_vpl VALUES ("DN2_43","028_2_43","DAN","2","43","43","Hamá dhawlá ke taw ásen gón patkagén gelá hawár dist, kawm o nasl hawár wa bant bale gón yakdomiá nalecchant, anchosh ke ásen gón gelá nalecchit. ");
INSERT INTO bcc_vpl VALUES ("DN2_44","028_2_44","DAN","2","44","44","Á bádsháháni wahdá, ásmáni Hodá dega bádsháhié addha kant ke hechbar tabáha nabit o dega kawméay dastá ham dayaga nabit. É bádsháhi, á dega sajjahén bádsháhiána próshit o halása kant, bale wat tán abad barjama mánit. ");
INSERT INTO bcc_vpl VALUES ("DN2_45","028_2_45","DAN","2","45","45","Anchosh ke taw dist, seng cha kóhéá sendag but, mardomi dastéá nasest, o ásen, brenj, gel, nograh o teláhi hurt kortant. Oo bádsháh! Mazanén Hodáyá pa taw paddar kortag ke démterá ché bit. Paméshká wáb rást ent o eshiay máná ham pakká ent.” ");
INSERT INTO bcc_vpl VALUES ("DN2_46","028_2_46","DAN","2","46","46","Bádsháh Nebukadnezar dém pa chér kapt o Dányáli sojdah kort o hokmi dát ke Dányálay démá hayráté bekanét o sóchoki chérsóch bekanét. ");
INSERT INTO bcc_vpl VALUES ("DN2_47","028_2_47","DAN","2","47","47","Bádsháhá gón Dányálá gwasht: “Béshak tai Hodá, hodáyáni Hodá ent o bádsháháni Hodáwand ent o rázáni paddar kanók, chéá ke taw é ráz paddar kort kortag.” ");
INSERT INTO bcc_vpl VALUES ("DN2_48","028_2_48","DAN","2","48","48","Padá bádsháhá Dányál masterén ogdahé o bázén tohpah o thékié dát, Bábelay damagay hokmránii sarjamá hamáiay dastá dát o Bábelay sajjahén dánáyáni sarmasteri kort. ");
INSERT INTO bcc_vpl VALUES ("DN2_49","028_2_49","DAN","2","49","49","Nun Dányálá gón bádsháhá dazbandi kort o bádsháhá Shadrak, Mishak o Abednegó Bábelay damagay káráni master kortant. Dányál wat bádsháhay darbárá nesht. ");
INSERT INTO bcc_vpl VALUES ("DN3_1","028_3_1","DAN","3","1","1","Bádsháh Nebukadnezará si gazz borz o say gazz práhén teláhén boté addh kanáént o Bábelay damagá, Durahay dashtá mekk kanáént. ");
INSERT INTO bcc_vpl VALUES ("DN3_2","028_3_2","DAN","3","2","2","Áiá wáli, hákem, sardár, saláhkár, hazánagay kelitdár, kázi, monsep o damagay é dega sajjahén mansabdár lóthetant ke byáét o é botay démdaráiay rasmán bahr bezurét ke bádsháh Nebukadnezará mekk kanáéntag. ");
INSERT INTO bcc_vpl VALUES ("DN3_3","028_3_3","DAN","3","3","3","Nun wáli, hákem, sardár, saláhkár, hazánagay kelitdár, kázi, monsep o damagay é dega sajjahén mansabdár ke bádsháh Nebukadnezará wati mekk kanáéntagén botay démdaráiay rasmáni tahá bahr zuragá lótháéntagatant, átk o mocch butant o Nebukadnezaray mekk kanáéntagén botay démá óshtátant. ");
INSERT INTO bcc_vpl VALUES ("DN3_4","028_3_4","DAN","3","4","4","Gorhá jár janóká gón borzén áwázéá jár jat: “Oo kawm o ráján o har zobánay mardomán! É pa shomá hokmé: ");
INSERT INTO bcc_vpl VALUES ("DN3_5","028_3_5","DAN","3","5","5","Hamá damáná ke shomá karná, nal, chang, soróz, tamburag, dhohl o é dega sajjahén sáz o zémeláni tawárá eshkonét, allam bádsháh Nebukadnezaray mekk kanáéntagén teláhén botay démá bekapét o sojdahi bekanét. ");
INSERT INTO bcc_vpl VALUES ("DN3_6","028_3_6","DAN","3","6","6","Harkas ke dém pa chéra nakapit o sojdaha nakant, hamá damáná rókén kurahá dawr dayaga bit.” ");
INSERT INTO bcc_vpl VALUES ("DN3_7","028_3_7","DAN","3","7","7","Paméshká hamá damáná ke áyán karná, nal, chang, soróz, tamburag o é dega sajjahén sáz o zémeláni tawár eshkot, har kawm o ráj o har zobánay mardom, bádsháh Nebukadnezaray mekk kanáéntagén teláhén botay démá kaptant o sojdahesh kort. ");
INSERT INTO bcc_vpl VALUES ("DN3_8","028_3_8","DAN","3","8","8","Hamá wahdá, lahtén Bábeli mardom démá átk o Yahudiáni shekáyatesh kort. ");
INSERT INTO bcc_vpl VALUES ("DN3_9","028_3_9","DAN","3","9","9","Áyán gón bádsháh Nebukadnezará gwasht: “O bádsháh! Modám zendag bátay. ");
INSERT INTO bcc_vpl VALUES ("DN3_10","028_3_10","DAN","3","10","10","Tawe bádsháhá hokm dátag: ‘Hamá damáná ke sajjahén mardom karná, nal, chang, soróz, tamburag, dhohl o é dega sajjahén sáz o zémeláni tawárá eshkonant, teláhén botay démá bekapant o sojdah bekanant o ");
INSERT INTO bcc_vpl VALUES ("DN3_11","028_3_11","DAN","3","11","11","harkas ke dém pa chéra nakapit o sojdaha nakant, rókén kurahay tahá dawr dayaga bit.’ ");
INSERT INTO bcc_vpl VALUES ("DN3_12","028_3_12","DAN","3","12","12","Bale oo bádsháh! Lahtén Yahudi hast: Shadrak, Mishak o Abednegó, hamá ke taw Bábelay damagay sarkári káráni ogdah dátagant, áyán tai hokm namannetag. É mardom na tai hodáyáni hezmatá kanant o na tai mekk kanáéntagén teláhén botá sojdaha kanant.” ");
INSERT INTO bcc_vpl VALUES ("DN3_13","028_3_13","DAN","3","13","13","Nun Nebukadnezar sakk hezhm gept o hokmi dát ke Shadrak, Mishak o Abednegóá byárét. Gorhá é mardom bádsháhay démá árag butant. ");
INSERT INTO bcc_vpl VALUES ("DN3_14","028_3_14","DAN","3","14","14","Nebukadnezará gón áyán gwasht: “Oo Shadrak, Mishak o Abednegó! É rást ent ke shomá mani hodáyáni hezmatá nakanét o mani mekk kanáéntagén teláhén bot sojdah nakortag? ");
INSERT INTO bcc_vpl VALUES ("DN3_15","028_3_15","DAN","3","15","15","É randá, agan shomá karná, nal, chang, soróz, tamburag, dhohl o é dega sajjahén sáz o zémeláni tawár eshkot o mani addh kortagén botay démá kapag o sojdah kanagá tayár ét wa sharr, bale agan shomá sojdah nakort gorhá hamá damáná rókén kurahay tahá dawr dayaga bét. Á wahdá bárén kojám hodá shomárá cha mani dastá rakkénit?” ");
INSERT INTO bcc_vpl VALUES ("DN3_16","028_3_16","DAN","3","16","16","Shadrak, Mishak o Abednegóá bádsháhay passawá gwasht: “Oo bádsháh Nebukadnezar! Márá é bárawá hecch passaw dayagay zalurat naent. ");
INSERT INTO bcc_vpl VALUES ("DN3_17","028_3_17","DAN","3","17","17","Agan má ásá dawr dayag bebén, hamá Hodá ke má áiay hezmatá kanén, márá cha rókén kurahay ásá rakkénta kant o hamá márá cha tawe bádsháhay dastá ham rakkénit. ");
INSERT INTO bcc_vpl VALUES ("DN3_18","028_3_18","DAN","3","18","18","Bale oo bádsháh! Agan chosh mabit ham, taw báyad ent bezánay ke tai hodáyáni hezmatá nakanén o tai mekk kanáéntagén teláhén botá sojdaha nakanén.” ");
INSERT INTO bcc_vpl VALUES ("DN3_19","028_3_19","DAN","3","19","19","Gorhá Nebukadnezar, Shadrak, Mishak o Abednegóay sará sakk hezhm gept. Áiay démay rang cha zahrá bar gasht o hokmi dát ke kurahay ásá hapt sari gésh kanét. ");
INSERT INTO bcc_vpl VALUES ("DN3_20","028_3_20","DAN","3","20","20","Wati pawjay lahtén zórmandén sepáhigi hokm dát ke Shadrak, Mishak o Abednegóá bebandét o rókén kurahá dawr dayét. ");
INSERT INTO bcc_vpl VALUES ("DN3_21","028_3_21","DAN","3","21","21","Nun é mardom gón gwaray kabáh, shalwár, pág o é dega sajjahén póshákán bandag but o rókén kurahá dawr dayag butant. ");
INSERT INTO bcc_vpl VALUES ("DN3_22","028_3_22","DAN","3","22","22","Bádsháhay hokm haminchok trond at o kurah haminkas jambur ke ásay bránzán hamá mardom koshtant ke áyán Shadrak, Mishak o Abednegó borzád bortagatant ke kurahá dawresh bedayant. ");
INSERT INTO bcc_vpl VALUES ("DN3_23","028_3_23","DAN","3","23","23","É sayén mohr bastagén mard Shadrak, Mishak o Abednegó rókén kurahá kaptant. ");
INSERT INTO bcc_vpl VALUES ("DN3_24","028_3_24","DAN","3","24","24","Anágat, bádsháh Nebukadnezará pa hayráni setth kort o cha wati saláhkárán josti kort: “Má say mardom nabast o ásá dawr nadát?” Áyán passaw dát: “Bale, oo bádsháh!” ");
INSERT INTO bcc_vpl VALUES ("DN3_25","028_3_25","DAN","3","25","25","Áiá darráént: “Bechárét, man ásay tahá chár mardom gardagá gendagá án. Dast o pádesh pach ant o salámat ant. Cháromi purah Hodái chokké.” ");
INSERT INTO bcc_vpl VALUES ("DN3_26","028_3_26","DAN","3","26","26","Nebukadnezar rókén kurahay darwázagay nazzikká shot o kukkári kort: “Oo Shadrak! Oo Mishak! Oo Abednegó! Oo borzén arshay Hodáay hezmatkárán! Byáét dhanná, edá byáét.” Gorhá Shadrak, Mishak o Abednegó cha ásá dar átkant. ");
INSERT INTO bcc_vpl VALUES ("DN3_27","028_3_27","DAN","3","27","27","Wáli, hákem, sardár o bádsháhay saláhkár mocch butant o distesh ke ásá é mardománi badan inchoká ham nageptagat, na áyáni saray mudé pilloshtagat o na áyáni godáni rang badal butagat. Ásay bóá ham kanagá naatant. ");
INSERT INTO bcc_vpl VALUES ("DN3_28","028_3_28","DAN","3","28","28","Nebukadnezará gwasht: “Shadrak, Mishak o Abednegóay Hodáyá satá o saná bát ke áiá wati préshtagé dém dátag o wati hezmatkár rakkéntagant. Eshán wati Hodáay sará báwar o bésah at o mani hokmesh namannet. Cha wati zendá sar gwastant, bale wati jenday Hodáyá abéd, dega hodáay hezmat o sojdahá razá nabutant. ");
INSERT INTO bcc_vpl VALUES ("DN3_29","028_3_29","DAN","3","29","29","Paméshká man hokma dayán ke harkas bebit, cha har kawm, ráj o zobáná ke Shadrak, Mishak o Abednegóay Hodáay bárawá harábén habaré bekant, á thokkor thokkor kanaga bit o áiay lóg barbád kanag o hákóthé jórh kanaga bit. Chéá ke dega hecch hodáé nést ke chosh rakként bekant.” ");
INSERT INTO bcc_vpl VALUES ("DN3_30","028_3_30","DAN","3","30","30","Padá bádsháhá Shadrak, Mishak o Abednegó, Bábelay damagá masterén ogdah dátant. ");
INSERT INTO bcc_vpl VALUES ("DN4_1","028_4_1","DAN","4","1","1","Cha bádsháh Nebukadnezaray némagá, pa é jaháná neshtagén sajjahén kawm o ráj o har zobánay mardomán. Shomá géshá gésh émen bátét. ");
INSERT INTO bcc_vpl VALUES ("DN4_2","028_4_2","DAN","4","2","2","Hamá nesháni ke borzén arshay Hodáyá maná pésh dáshtagant o hamá mójezah ke pa man kortaganti, wassha bán ke shomárá begwashánesh. ");
INSERT INTO bcc_vpl VALUES ("DN4_3","028_4_3","DAN","4","3","3","Áiay nesháni zabardast ant o mójezah, porzór. Áiay bádsháhi tán abad hastent o hokmránii nasláni nasl barjáh. ");
INSERT INTO bcc_vpl VALUES ("DN4_4","028_4_4","DAN","4","4","4","Mane Nebukadnezar wati lógá ásudag, wati kalátá wassh o ábád atán. ");
INSERT INTO bcc_vpl VALUES ("DN4_5","028_4_5","DAN","4","5","5","Man wábé dist o torséá maná mán patát. Gandaláni sará, mani hayál o shobénán maná torsént. ");
INSERT INTO bcc_vpl VALUES ("DN4_6","028_4_6","DAN","4","6","6","Gorhá man hokm dát ke Bábelay sajjahén dáná árag bebant tánke mani wábá máná bekanant. ");
INSERT INTO bcc_vpl VALUES ("DN4_7","028_4_7","DAN","4","7","7","Wahdé jáduger, sáher, nojumi o estárzánt átkant, man gón áyán wati wáb gwasht bale áyán mani wáb máná kort nakort. ");
INSERT INTO bcc_vpl VALUES ("DN4_8","028_4_8","DAN","4","8","8","Bale godhsará Dányál ke áiay nám, mani hodáay námay hesábá Beltesházar ent, mani kerrá átk. Áiá pákén hodáyáni ruh mán ent. Man gón áiá wati wáb gwasht: ");
INSERT INTO bcc_vpl VALUES ("DN4_9","028_4_9","DAN","4","9","9","“Oo Beltesházar, nojumiáni master! Mana zánán ke tará pákén hodáyáni ruh mán ent o hecch rázay zánag pa taw grán naent. É mani wáb ent ke man distag, nun pa man mánái kan. ");
INSERT INTO bcc_vpl VALUES ("DN4_10","028_4_10","DAN","4","10","10","Man gandaláni sará, é shobén distant: Man cháragá atán ta gendán, zeminay nyámá drachké o drachk sakk borz ent. ");
INSERT INTO bcc_vpl VALUES ("DN4_11","028_4_11","DAN","4","11","11","Drachk rodán o master bayán ent. Eshiay borzi tán ásmáná sar ent o cha zeminay goddhi hadd o simsarán záher ent. ");
INSERT INTO bcc_vpl VALUES ("DN4_12","028_4_12","DAN","4","12","12","Táki dhawldár ant, bar o samará bár ent o pa sajjahénán waráki per ent. Pa zeminay jánwarán sáhegé o ásmánay morg eshiay sháharháni sará kodóha bandant o nendant. Har sahdár cha eshiá waráka wárt. ");
INSERT INTO bcc_vpl VALUES ("DN4_13","028_4_13","DAN","4","13","13","Wahdé gandalán waptagatán, shobénáni tahá diston, ta mani démá pákén mardomé, bezán kásedé, cha ásmáná jahlád pédák ent. ");
INSERT INTO bcc_vpl VALUES ("DN4_14","028_4_14","DAN","4","14","14","Áiá gón borzén tawáréá gwasht: ‘Drachká goddh o sháharháni borr o tákáni send o baráni sheng o sháng kan. Bell ke jánwar cha eshiay sáhegá dara káyant o tachant o morg cha eshiay sháharhán bála kanant. ");
INSERT INTO bcc_vpl VALUES ("DN4_15","028_4_15","DAN","4","15","15","Bale drachkay bondhá bell ke gón wandhál o risshagán bemánit tánke gón ásen o brenjén patthiéá patáyag bebit o dashtay sabzagáni tahá pasht bekapit. Belli cha ásmánay nódá tarra bit o bell ke jangali jánwaráni nyámá dashtay sabzagáni sará zendaga bit. ");
INSERT INTO bcc_vpl VALUES ("DN4_16","028_4_16","DAN","4","16","16","Bell ke eshiay del cha mardomi deléá badal kanag bebit o eshiá jánwari delé dayag bebit o bell ke tán hapt zamánagá anchosh bemánit. ");
INSERT INTO bcc_vpl VALUES ("DN4_17","028_4_17","DAN","4","17","17","É hokmay jár kásedán jatag, pákénán eshiay hokm dátag, tánke zendagén mardom bezánant ke borzén arshay Hodá ensáni bádsháhiáni sará hokmrán ent o é bádsháhián hamá mardomá dant ke Hodáay jenda lóthit. Tantaná kamzátén mardomán ham é bádsháhiáni sará hákema kant.’ ");
INSERT INTO bcc_vpl VALUES ("DN4_18","028_4_18","DAN","4","18","18","É hamá wáb ent ke mane bádsháh Nebukadnezará distag. Oo Beltesházar! Nun taw eshiá máná kan, parchá ke mani bádsháhiay hecch dáná eshiá máná korta nakant, bale taw kortia kanay chéá ke tará pákén hodáyáni ruh mán ent.” ");
INSERT INTO bcc_vpl VALUES ("DN4_19","028_4_19","DAN","4","19","19","Gorhá Dányál, ke domi námi Beltesházar at, pa damánéá hayrán but, hayálán paréshán kort. Bádsháhá gwasht: “Beltesházar! Wáb o wábay mánáyá mayl ke tará paréshán bekant.” Beltesházará gwasht: “Mani wájah! Drégatá é wáb tai dozhmenáni bárawá butén o eshiay máná ham pa tai badwáhán. ");
INSERT INTO bcc_vpl VALUES ("DN4_20","028_4_20","DAN","4","20","20","É drachk ke taw distag, hamé ke rost o zórmand but, borziá ásmáná sar but o cha zeminay sajjahén hadd o simsarán záher at, ");
INSERT INTO bcc_vpl VALUES ("DN4_21","028_4_21","DAN","4","21","21","táki dhawldár atant o bari békesás o pa sajjahénán waráki per at o áiay sáhegá jangali jánwara neshtant o sháharháni sará báli morgáni kodóh atant, ");
INSERT INTO bcc_vpl VALUES ("DN4_22","028_4_22","DAN","4","22","22","é drachk taw ay, oo bádsháh! Chéá ke taw mazan o porwák ay o tai mazani rostag o ásmáná sar ent o tai bádsháhi tán zeminay goddhi hadd o simsarán rasetag. ");
INSERT INTO bcc_vpl VALUES ("DN4_23","028_4_23","DAN","4","23","23","Tawe bádsháhá kásedé dist, pákéné, cha ásmáná ér áyag o gwashagá at: ‘Drachká goddh o barbád kan, bale drachkay bondhá bell ke gón wandhál o risshagán bemánit tánke gón ásen o brenjén patthiéá patáyag bebit o dashtay sabzagáni tahá pasht bekapit. Belli cha ásmánay nódá tarra bit, o bell ke jangali jánwaráni nyámá zendaga bit. Bell tán hapt zamánagá anchosha mánit.’ ");
INSERT INTO bcc_vpl VALUES ("DN4_24","028_4_24","DAN","4","24","24","Oo bádsháh! É tai wábay máná ent o é borzén arshay Hodáay hokm ent ke pa mani wájahén bádsháhá átkag. ");
INSERT INTO bcc_vpl VALUES ("DN4_25","028_4_25","DAN","4","25","25","Taw cha ensánán gallénaga bay o jangali jánwaráni darnyámá jahmenenda bay. Tai ward o warák pas o gókáni dhawlá káh o buccha bant o taw cha ásmánay nódán tarra bay. Tán hapt zamánagá taw anchosha bay, tán hamá wahdá ke taw pajjáh byáray ke borzén arshay Hodá ensáni bádsháhiáni sará hokmrán ent o hamá mardomá dantesh ke wata lóthit. ");
INSERT INTO bcc_vpl VALUES ("DN4_26","028_4_26","DAN","4","26","26","Hamé hokmay máná, ke drachkay bondh gón wandhál o risshagán pasht géjag bebit, esh ent ke wahdé taw pajjáha káray ke asli bádsháh arshá neshtag, tai bádsháhi padá tará dayaga bit. ");
INSERT INTO bcc_vpl VALUES ("DN4_27","028_4_27","DAN","4","27","27","Oo bádsháh! Paméshká mani é sój balkén pa taw sharrén sójé bebit: nékén kár bekan ke cha wati gonáhán dur bebay o bazzagáni sará rahm kan ke cha wati radkárián berakkay. Balkén tai ábádi barjáh bemánit.” ");
INSERT INTO bcc_vpl VALUES ("DN4_28","028_4_28","DAN","4","28","28","É sajjahén chizz gón bádsháh Nebukadnezará butant. ");
INSERT INTO bcc_vpl VALUES ("DN4_29","028_4_29","DAN","4","29","29","Dwázdah máhá rand, á Bábelay sháhi kalátay sará gám janagá at. ");
INSERT INTO bcc_vpl VALUES ("DN4_30","028_4_30","DAN","4","30","30","Bádsháhá gwasht: “É hamá mazanén Bábel naent ke man gón wati zabardastén zórá addh kort ke mani pormarháhén shán o shawkatá záher bekant o mani sháhi kalát bebit?” ");
INSERT INTO bcc_vpl VALUES ("DN4_31","028_4_31","DAN","4","31","31","Angat habar bádsháhay dapá at ke cha ásmáná tawáré átk, gwashagá at: “Oo bádsháh Nebukadnezar! Tará gwashag bayagá ent ke tai bádsháhi cha taw pach gerag butag. ");
INSERT INTO bcc_vpl VALUES ("DN4_32","028_4_32","DAN","4","32","32","Taw cha ensánán gallénaga bay o jangali jánwaráni darnyámá jahmenenda bay. Tai ward o warák pas o gókáni dhawlá káh o buccha bant. Tán hapt zamánagá taw anchosha bay tán hamá wahdá ke taw pajjáh byáray o bezánay ke borzén arshay Hodá ensáni bádsháhiáni sará hokmrán ent o hamá mardomá dantesh ke wata lóthit.” ");
INSERT INTO bcc_vpl VALUES ("DN4_33","028_4_33","DAN","4","33","33","Hamá damáná gón Nebukadnezará anchosh but ke gwashag butagat. Á cha ensánán gallénag but, pas o gókáni dhawlá káh o bucchia wárt, áiay jesm cha ásmánay nódá tarra but, tánke áiay mud wakábay potháni warhá rostant o nákoni morgay panjagáni dhawlá butant. ");
INSERT INTO bcc_vpl VALUES ("DN4_34","028_4_34","DAN","4","34","34","“Bale á rócháni halásiá, mane Nebukadnezará wati chamm ásmánay némagá chest kortant o mani hósh átk. Nun man borzén arshay Hodáay satá o saná kort, hamá Hodá ke tán abada mánit, man shán o ezzat dát. Chéá ke áiay hokmráni abadmánén hokmránié o áiay bádsháhi tán nasláni nasl barjáha mánit. ");
INSERT INTO bcc_vpl VALUES ("DN4_35","028_4_35","DAN","4","35","35","Jahánay sajjahén mahluk áiay démá hecch naant. Á, gón ásmáni lashkará wati delay tabá kára kant o gón zeminay saray nendókán ham. Choshén kasé nést ke áiay dastá bedárit o begwashit ke ‘taw ché kanagá ay?’ ");
INSERT INTO bcc_vpl VALUES ("DN4_36","028_4_36","DAN","4","36","36","Hamá damáná mani hósh átk o mani bádsháhiay shawkatay háterá mani shán o mazani padá pa man átk. Mani saláhkár o mir o mehterán maná dar gétk o mani bádsháhi taht padá maná dayag but o mani ezzat cha pésarigén ezzatá báz géshter but. ");
INSERT INTO bcc_vpl VALUES ("DN4_37","028_4_37","DAN","4","37","37","Nun mane Nebukadnezar ásmánáni bádsháhá satá kanán, sárháyán o sharapa dayán chéá ke áiay sajjahén kár rást ant o áiay ráh pa ensáp. Á, gorunákáni gardená jahl korta kant.” ");
INSERT INTO bcc_vpl VALUES ("DN5_1","028_5_1","DAN","5","1","1","Bádsháh Belsházará baláhén dáwaté dát. Wati hazár mir o mehteri mehmán kort o esháni démá sharábi wárt. ");
INSERT INTO bcc_vpl VALUES ("DN5_2","028_5_2","DAN","5","2","2","Wahdé Belsházará sharábay tám chasht, hokmi dát ke hamá teláh o nograhén darp árag bebant ke áiay pirok Nebukadnezará cha Urshalimaymazanén parasteshgáhá, cha Hodáay lógá áwortagatant tánke bádsháh, áiay mir o mehter, áiay jan o soriat esháni tahá benóshant. ");
INSERT INTO bcc_vpl VALUES ("DN5_3","028_5_3","DAN","5","3","3","Gorhá hamá teláhén darpesh áwortant ke cha Urshalimá, cha Hodáay parasteshgáhá áwár janag butagatant. Bádsháh, áiay mir o mehterán, áiay janán o soriatán esháni tahá sharáb wárt. ");
INSERT INTO bcc_vpl VALUES ("DN5_4","028_5_4","DAN","5","4","4","Áyán sharáb wárt o teláh, nograh, brenj, ásen, dár o sengén hodáyáni satá kort. ");
INSERT INTO bcc_vpl VALUES ("DN5_5","028_5_5","DAN","5","5","5","Anágahá mardomi dastéay lankok záher butant o cherágdánay domi némagá, sháhi kalátay diwálay dónay sará nebeshtah kanagá laggetant. Bádsháhá nebeshtah kanókén dastay posht dist. ");
INSERT INTO bcc_vpl VALUES ("DN5_6","028_5_6","DAN","5","6","6","Nun bádsháhay dém zard tarret o áiá anchén torsé delá kapt ke srénay band o bógi shol butant o kóndhi anchó larzetant ke gón yakdomiá laggetant. ");
INSERT INTO bcc_vpl VALUES ("DN5_7","028_5_7","DAN","5","7","7","Bádsháhá kukkár kort o hokm dát ke sáher, nojumi o estárzántán byárét. Gón Bábelay dánáyán gwashti: “Hamá kas ke é nebeshtahá bwánit o máná bekant, á jamurangén god o teláhén háré gwará dayaga bit o bádsháhiay sayomi hokmrán kanaga bit.” ");
INSERT INTO bcc_vpl VALUES ("DN5_8","028_5_8","DAN","5","8","8","Gorhá bádsháhay sajjahén dánáén mardom átkant, bale kassá nebeshtah wánt o pa bádsháhá máná kort nakort. ");
INSERT INTO bcc_vpl VALUES ("DN5_9","028_5_9","DAN","5","9","9","Nun bádsháh Belsházar géshter paréshán but. Áiay dém géshter zard tarret. Áiay mir o mehter hayrán butant. ");
INSERT INTO bcc_vpl VALUES ("DN5_10","028_5_10","DAN","5","10","10","Shahbánoká wahdé bádsháh o áiay hásén mardománi tawár eshkot, diwánjáhá átk o gón bádsháhá gwashti: “Oo bádsháh! Modám zendag bátay. Watá paréshán makan o wati démá zard matarrén. ");
INSERT INTO bcc_vpl VALUES ("DN5_11","028_5_11","DAN","5","11","11","Tai bádsháhiá mardé hast ke áiá pákén hodáyáni ruh mán ent o tai pirokay dawrá gendag butag ke áiá báteni rozhnái, sarpadi o hekmat o hodáyáni dhawlén dánáié gón. Tai bádsháhén pirok, Nebukadnezará é mard jáduger, sáher, nojumi o estárzántáni master kortagat, ");
INSERT INTO bcc_vpl VALUES ("DN5_12","028_5_12","DAN","5","12","12","chéá ke é Dányál, ke bádsháhá áiay nám Beltesházar kortag, eshiá ajabén ruhé, zánt o sarpadié hastat. Á wáb o chácháni máná kanag o gránén jérhaháni gisshénagá sakk balad at. Dányálá lótháén, hamá tará eshiay mánáyá gwashta kant.” ");
INSERT INTO bcc_vpl VALUES ("DN5_13","028_5_13","DAN","5","13","13","Gorhá Dányál, bádsháhay démá árag but. Bádsháhá gón Dányálá gwasht: “Taw hamá Dányál ay ke cha Yahudáay darándhéhán ent, hamá ke mani bádsháhén piroká cha Yahudáyá áwortagant? ");
INSERT INTO bcc_vpl VALUES ("DN5_14","028_5_14","DAN","5","14","14","Man annun sahig butagán ke tará hodáyáni ruhé mán ent o tará báteni rozhnái, sarpadi o ajabén hekmaté hast. ");
INSERT INTO bcc_vpl VALUES ("DN5_15","028_5_15","DAN","5","15","15","Mani démá annun dáná o sáher árag butagant ke é nebeshtahá bwánant o pa man máná bekanant, bale áyán máná kort nakort. ");
INSERT INTO bcc_vpl VALUES ("DN5_16","028_5_16","DAN","5","16","16","Bale man tai bárawá eshkotag ke taw máná korta kanay o jérhaháni gissh o giwárá balad ay. Agan taw é nebeshtahá wánt o máná kort bekanay, tará jamurangén god o teláhén háré gwará dayaga bit o taw bádsháhiay sayomi hokmrán kanaga bay.” ");
INSERT INTO bcc_vpl VALUES ("DN5_17","028_5_17","DAN","5","17","17","Gorhá Dányálá gón bádsháhá gwasht: “Wati théki o tohpahán wati kerrá kan o dádán pa dega kaséá ér kan. Man é nebeshtahá chónahá wánán o pa tawe bádsháhá máná kanán. ");
INSERT INTO bcc_vpl VALUES ("DN5_18","028_5_18","DAN","5","18","18","Oo bádsháh! Borzén arshay Hodáyá, Nebukadnezar bezán tai pirok, bádsháhi, mazani, shán o sharap dátagat. ");
INSERT INTO bcc_vpl VALUES ("DN5_19","028_5_19","DAN","5","19","19","Hamá mazaniay sawabá ke Hodáyá dátagat, sajjahén kawm o ráj o har zobánay mardom cha torsá tai pirokay démá larzetant. Kasé ke áiá koshaga lóthet, koshti o kasé ke áiá koshaga nalóthet, nakoshti. Kasé ke áiá mazani dayaga lóthet, mazaniia dát o kasé ke áiá kamsharap kanaga lóthet, kamsharapia kort. ");
INSERT INTO bcc_vpl VALUES ("DN5_20","028_5_20","DAN","5","20","20","Bale wahdé áiay del porkebr o arwáh cha gorunákiá porr but, cha bádsháhi tahtá ér géjag o shán o shawkati pach gerag but. ");
INSERT INTO bcc_vpl VALUES ("DN5_21","028_5_21","DAN","5","21","21","Á, cha ensánáni darnyámá gallénag but o áiay del jánwari delé jór kanag but. Jangali haráni nyámá jahmenend but, pas o gókáni dhawlá káh o bucch wárénaga but o cha ásmánay nódán áiay badan tarr kanaga but, tán hamá wahdá ke zánti ke borzén arshay Hodá ensáni bádsháhiáni sará hokmrán ent o hamá mardomá esháni sará hokmrána kant ke wata lóthit. ");
INSERT INTO bcc_vpl VALUES ("DN5_22","028_5_22","DAN","5","22","22","Bale oo Belsházar, Nebukadnezaray nomásag! É sajjahén chizzet zántant o angat ham gorunákiet cha wati delá dar nakort. ");
INSERT INTO bcc_vpl VALUES ("DN5_23","028_5_23","DAN","5","23","23","Taw watárá ásmáni Hodáwanday démá borz zánt o léket o hokmet kort ke Hodáay lógay darp tai démá árag bebant. Taw o tai mir o mehterán, tai janán o soriatán é darpáni tahá sharáb wárt o taw nograh, teláh, brenj, ásen, dár o sengén hodá satá kortant ke na gendant, na eshkonant o na sarpada bant. Bale taw hamá Hodá shán o shawkat nadát ke tai sáh o tai sajjahén ráh áiay dastá ant. ");
INSERT INTO bcc_vpl VALUES ("DN5_24","028_5_24","DAN","5","24","24","Paméshká é dast, cha hamá Hodáay némagá dém dayag butag o é labz nebeshtah kanag butagant. ");
INSERT INTO bcc_vpl VALUES ("DN5_25","028_5_25","DAN","5","25","25","Nebeshtah esh ent: ‘Mené, mené, tekel, pársin.’ ");
INSERT INTO bcc_vpl VALUES ("DN5_26","028_5_26","DAN","5","26","26","É labzáni máná esh ant: ‘Mené’ bezán Hodáyá tai bádsháhiay róch hesáb kortag o halás kortagant. ");
INSERT INTO bcc_vpl VALUES ("DN5_27","028_5_27","DAN","5","27","27","‘Tekel’ bezán taw sháhémá wazn kanag butagay o é habar zánag butag ke taw sobakk ay. ");
INSERT INTO bcc_vpl VALUES ("DN5_28","028_5_28","DAN","5","28","28","‘Peres’ bezán tai bádsháhi bahr kanag o Mád o Pársán dayag butag.” ");
INSERT INTO bcc_vpl VALUES ("DN5_29","028_5_29","DAN","5","29","29","Gorhá Belsházará hokm dát o Dányálesh jamurangén god o teláhén háré gwará dát o Dányál, bádsháhiay sayomi hokmrán jórh kanag but. ");
INSERT INTO bcc_vpl VALUES ("DN5_30","028_5_30","DAN","5","30","30","Hamá shapay shap Bábeliáni bádsháh, Belsházar koshag but. ");
INSERT INTO bcc_vpl VALUES ("DN5_31","028_5_31","DAN","5","31","31","Gorhá bádsháhi Mádén Dáryushá raset. É wahdá Dáryushay omr kesás shast o do sál at. ");
INSERT INTO bcc_vpl VALUES ("DN6_1","028_6_1","DAN","6","1","1","Dáryushá delá shawr kort ke wati bádsháhiá yakk sad o bist wáli bedárit ke áiay bádsháhiay sajjahén káráni zemmawár bebant o ");
INSERT INTO bcc_vpl VALUES ("DN6_2","028_6_2","DAN","6","2","2","é wáliáni sará say sarwazir dárag bebit. Dányál cha é sayénán yakké at. Wáliáná, hamé sarwaziráni démá hesáb dayagi at tánke bádsháhá táwáné marasit. ");
INSERT INTO bcc_vpl VALUES ("DN6_3","028_6_3","DAN","6","3","3","Dányál, wati ajabén ruhay sawabá, zutt cha é sarwazir o wálián démá dar átk. Cha Dányálay láhekiá, bádsháhá hayál kort ke sajjahén molkay zemmawárián hamáiá bedant. ");
INSERT INTO bcc_vpl VALUES ("DN6_4","028_6_4","DAN","6","4","4","Gorhá é dega sarwazir o wáli Dányálay hokumati káráni tahá radi shóház kanagá laggetant, bale áyán pa Dányálay ér janag o mayárig kanagá hecch nimmóné dast nakapt. Á, wapádáré at, cha wati kárán nádelgósh naat o na ke selkárié korti. ");
INSERT INTO bcc_vpl VALUES ("DN6_5","028_6_5","DAN","6","5","5","Nun é mardomán gwasht: “Márá é mard, Dányálay helápá dega hecch nimmóné dasta nakapit, abéd cha anchén gappéá ke áiay Hodáay Sharyatay bárawá bebit.” ");
INSERT INTO bcc_vpl VALUES ("DN6_6","028_6_6","DAN","6","6","6","Gorhá é sarwazir o wáli yakjáh but o bádsháhay kerrá átkant o gwashtesh: “Bádsháh Dáryush! Modám zendag bátay. ");
INSERT INTO bcc_vpl VALUES ("DN6_7","028_6_7","DAN","6","7","7","Oo bádsháh! Tai sajjahén sarwazir, hákem, wáli, saláhkár o sardárán watmánwatá shawr kortag ke taw yakk sháhi hokmé bedayay ke harkas tán áyókén si róchá tará abéd, dega hodá yá dega mardoméay kerrá dwá belóthit, shéráni gárá dawr dayaga bit. ");
INSERT INTO bcc_vpl VALUES ("DN6_8","028_6_8","DAN","6","8","8","Oo bádsháh! Nun hokm beday o é parmáná dashatt kan tánke badal but makant. É dhawlá é hokm, Mád o Pársay kánuné jórha bit ke badal kanaga nabit.” ");
INSERT INTO bcc_vpl VALUES ("DN6_9","028_6_9","DAN","6","9","9","Gorhá bádsháh Dáryushá parmán dashatt kort. ");
INSERT INTO bcc_vpl VALUES ("DN6_10","028_6_10","DAN","6","10","10","Nun wahdé Dányál sahig but ke choshén parmáné dashatt kanag butag, wati lógay hamá borzi kóthiá shot ke darigi dém pa Urshalimá pacha butant o anchó ke modám kortagati, róché say randá kóndhána kapt, dwáia kort o wati Hodáay shogria gept. ");
INSERT INTO bcc_vpl VALUES ("DN6_11","028_6_11","DAN","6","11","11","Gorhá é mard mocch but o átkant o distesh ke Dányál wati Hodáay kerrá dwá o peryát kanagá ent. ");
INSERT INTO bcc_vpl VALUES ("DN6_12","028_6_12","DAN","6","12","12","Bádsháhay kerrá shotant o sháhi parmánay bárawá habaresh kort o gwashtesh: “Oo bádsháh! Taw parmáné dashatt nakortag ke harkas tán si róchá tará abéd dega hodáéay yá ke dega mardoméay kerrá dwá belóthit, shéráni gárá dawr dayaga bit?” Bádsháhá passaw dát: “Haw, é rást ent. Mád o Pársay kánunay hesábá é badal buta nakant.” ");
INSERT INTO bcc_vpl VALUES ("DN6_13","028_6_13","DAN","6","13","13","Nun áyán gón bádsháhá gwasht: “Dányál ke cha Yahudáay darándhéhán yakké, tai jend o tai dashatt kortagén parmáni hecch delgósh nakortag, oo bádsháh! Róché say randá angat wati Hodáay kerrá dwá lóthagá ent.” ");
INSERT INTO bcc_vpl VALUES ("DN6_14","028_6_14","DAN","6","14","14","Bádsháhá ke é habar eshkot, sakk paréshán but. Erádahi kort ke Dányálá rakkénán o tán bégáhá hamé johdá at ke chón áiá berakkénit. ");
INSERT INTO bcc_vpl VALUES ("DN6_15","028_6_15","DAN","6","15","15","Gorhá é mard padá yakjáh but o bádsháhay kerrá átkant o gwashtesh: “Bechár, oo bádsháh! Mád o Pársay kánun ent ke bádsháhay dashatt kortagén hecch hokm o parmán badal buta nakant.” ");
INSERT INTO bcc_vpl VALUES ("DN6_16","028_6_16","DAN","6","16","16","Gorhá bádsháhá hokm dát o Dányál árag o shéráni gárá dawr dayag but. Bádsháhá gón Dányálá gwasht: “Tai hamá Hodá wat tará berakkénát ke taw modám áiay hezmatá kanay.” ");
INSERT INTO bcc_vpl VALUES ("DN6_17","028_6_17","DAN","6","17","17","Padá sengé árag o gáray dapá ér kanag but. Bádsháhá gón wati jenday o wati mir o mehteráni mondrikkán gáray dap mohr jat tánke Dányálay jáwar badal but makant. ");
INSERT INTO bcc_vpl VALUES ("DN6_18","028_6_18","DAN","6","18","18","Padá bádsháh wati kalátá shot. Sajjahén shapá waráki nawárt o wáb nakapt. Áiay bárgáhá hecch paymén shátkámi kanag nabut. ");
INSERT INTO bcc_vpl VALUES ("DN6_19","028_6_19","DAN","6","19","19","Sohbá máhallah, anchó ke róchá thekk kort, bádsháh pád átk o zutt zuttá shéráni gáray némagá shot. ");
INSERT INTO bcc_vpl VALUES ("DN6_20","028_6_20","DAN","6","20","20","Wahdé gáray nazzikká raset, gón dardnákén tawáréá kukkári kort o gón Dányálá gwashti: “Oo Dányál! Oo zendagén Hodáay hezmatkár! Bárén tará tai hamá Hodáyá cha shérán rakként kort ke taw modám áiay hezmatá kanay?” ");
INSERT INTO bcc_vpl VALUES ("DN6_21","028_6_21","DAN","6","21","21","Gorhá Dányálá passaw dát: “Oo bádsháh! Modám zendag bátay. ");
INSERT INTO bcc_vpl VALUES ("DN6_22","028_6_22","DAN","6","22","22","Mani Hodáyá wati préshtagé ráh dát ke shéráni dapi bast. Shérán maná hecch táwán nadát. Oo bádsháh! Haminchok ke man Hodáay démá bégonáh án haminchok tai démá ham man hecch radén káré nakortag.” ");
INSERT INTO bcc_vpl VALUES ("DN6_23","028_6_23","DAN","6","23","23","Nun bádsháh sakk gal but o hokmi dát ke Dányál cha gárá dar kanag bebit. Gorhá Dányál cha gárá dar kanag but. Thappé ham peri néstat chéá ke áiá wati Hodáay sará tawkal kortagat. ");
INSERT INTO bcc_vpl VALUES ("DN6_24","028_6_24","DAN","6","24","24","Nun bádsháhá hokm dát o hamá mardom árag butant ke Dányálay helápá pandalesh sázetagat. Á gón jan o chokkán shéráni gárá dawr dayag butant. Angat gáray johlánkiá sar nabutagatant ke shérán geptant o áyáni sajjahén haddh próshtant. ");
INSERT INTO bcc_vpl VALUES ("DN6_25","028_6_25","DAN","6","25","25","Padá bádsháh Dáryushá pa sajjahén kawm, ráj o har zobánay mardomán ke téwagén sarzeminá jahmenend atant, nebeshtah kort: “Shomá géshá géshter émen bátét. ");
INSERT INTO bcc_vpl VALUES ("DN6_26","028_6_26","DAN","6","26","26","Man jára janán ke mani bádsháhiay har kondhay mardom, cha Dányálay Hodáay torsá belarzant o hamáiá sharap bedayant. Chéá ke hamá zendagén Hodá ent o modáma mánit. Áiay bádsháhi hechbar tabáh o barbáda nabit o áiay hokmráni hechbar halása nabit. ");
INSERT INTO bcc_vpl VALUES ("DN6_27","028_6_27","DAN","6","27","27","Hamá nejáta dant o rakkénit, ásmán o zeminay sará ajabbatén nesháni o mójezah pésha dárit. Hamáiá Dányál cha shéráni dapá rakkéntag.” ");
INSERT INTO bcc_vpl VALUES ("DN6_28","028_6_28","DAN","6","28","28","Nun é mard Dányálá, Dáryush o Pársén Kuroshay bádsháhi dawrá démrawi kort. ");
INSERT INTO bcc_vpl VALUES ("DN7_1","028_7_1","DAN","7","1","1","Bábelay bádsháh Belsházaray dawray awali sálá Dányálá wábé dist, wahdé wati nepáday sará tachk at, shobén o elhám áiay saray tahá chakarragá atant. Áiá wati wábay hásén habar nebeshtah kortant. ");
INSERT INTO bcc_vpl VALUES ("DN7_2","028_7_2","DAN","7","2","2","Dányálá gwasht: “Man shapá elhám o shobén gendagá atán o man dist ke ásmánay chárén gwátán mazanén daryá mast kort. ");
INSERT INTO bcc_vpl VALUES ("DN7_3","028_7_3","DAN","7","3","3","Padá chár baláhén jánwar cha daryáyá dar átk. Har yakkéay dróshom cha é degarán jetá at. ");
INSERT INTO bcc_vpl VALUES ("DN7_4","028_7_4","DAN","7","4","4","Awali, shéray dhawléné at o wakábi bánzoli per at. Man chamm sakk kortag o tán hamá wahdá cháragá atán ke eshiay bánzol gwajag butant o jendi cha zeminá chest kanag o mardoméay warhá do páday sará óshtárénag but o eshiá ensáni delé dayag but. ");
INSERT INTO bcc_vpl VALUES ("DN7_5","028_7_5","DAN","7","5","5","Padá dega jánwaré záher but, é domi, mammay dhawléné at o kash waptagat o say pahlugi dantánáni nyámá dapá at. Eshiárá gwashag but: ‘Pád á, watá cha góshtá sérláp kan.’ ");
INSERT INTO bcc_vpl VALUES ("DN7_6","028_7_6","DAN","7","6","6","Eshiá rand, man angat cháragá atán o diston dega yakké, polangay dhawléné at o eshiay poshtá chár morgi bánzol per at. É jánwará chár sarag per at o hákemi ehtiáré eshiá dayag but. ");
INSERT INTO bcc_vpl VALUES ("DN7_7","028_7_7","DAN","7","7","7","Eshiá pad, man angat shapay elhám o shobénán gendagá atán o cháromi jánwaron dist. É torsnák, haybatnák o sakk zórmand at. Eshiá drájén ásenén dantán per at. Wati shekári prósht o ér bort o saráróki pádáni chérá lapáshtant. Cha á pésarigén sajjahén jánwarán jetá at o dah kánthi per at. ");
INSERT INTO bcc_vpl VALUES ("DN7_8","028_7_8","DAN","7","8","8","Man eshiay kántháni bárawá jérhagá atán, diston esháni nyámá dega kasánén kánthé dar átk o cha jánwaray awali kánthán say kánth eshiay démá cha boná gwajag but. Man dist ke é kánthá mardomi chammay paymén chamm per at o dapé per ati ke bathák janagá at. ");
INSERT INTO bcc_vpl VALUES ("DN7_9","028_7_9","DAN","7","9","9","Man angat cháragá atán ke bádsháhi taht árag o ér kanag butant o hamá ke cha zamánagán hastent, átk o nesht. Áiay póshák chó barpá o saray mud, pazhmay dhawlá espét atant. Áiay taht, ásay bránzé at o tahtay chahr warókén pádag, rókén ás atant. ");
INSERT INTO bcc_vpl VALUES ("DN7_10","028_7_10","DAN","7","10","10","Ásay kawré tachagá at o cha áiay bárgáhá dar áyagá at. Hazáráni hazár áiay hezmatá at o lakkáni lakk áiay démá óshtátagat. Diwán pa dádrasiá nesht o ketáb pach butant. ");
INSERT INTO bcc_vpl VALUES ("DN7_11","028_7_11","DAN","7","11","11","Hamá bathákán ke kánthesh janagá at, man áyáni sawabá angat é nedáragá cháragá atán. Tán hamá wahdá cháragá atán ke jánwar koshag but o áiay jón zawál kanag o rókén ásá dawr dayag but. ");
INSERT INTO bcc_vpl VALUES ("DN7_12","028_7_12","DAN","7","12","12","É dega jánwaráni hákemi pach gerag butagatant bale áyáni zendá lahtén róch gésh kanag but. ");
INSERT INTO bcc_vpl VALUES ("DN7_13","028_7_13","DAN","7","13","13","Man shapay elhámán cháragá atán ta diston, gón ásmáni jambarán ensáni chokkéay dhawléné áyagá at o hamáiay némagá pédák at ke cha zamánagán hastent o áiay démá árag o pésh kanag but. ");
INSERT INTO bcc_vpl VALUES ("DN7_14","028_7_14","DAN","7","14","14","Hákemi, shán o bádsháhi hameshiá dayag but ke sajjahén kawm o ráj o har zobánay mardom eshiay hezmatá bekanant. Eshiay hokmráni abadmánén hokmránié ke hechbar halása nabit o eshiay bádsháhi hechbar zawála nabit. ");
INSERT INTO bcc_vpl VALUES ("DN7_15","028_7_15","DAN","7","15","15","Mane Dányálay arwáh paréshán at. Mani del o damágay shobén o elhámán maná torsént. ");
INSERT INTO bcc_vpl VALUES ("DN7_16","028_7_16","DAN","7","16","16","Man cha hamáyán yakkéay kerrá shotán ke ódá óshtátagatant o joston kort ke é sajjahén chizzáni asli máná ché ent? Gorhá áiá gón man habar kort o maná esháni mánái sarpad kort. ");
INSERT INTO bcc_vpl VALUES ("DN7_17","028_7_17","DAN","7","17","17","‘É chárén baláhén jánwar, donyáay chár bádsháh ant ke chesta bant. ");
INSERT INTO bcc_vpl VALUES ("DN7_18","028_7_18","DAN","7","18","18","Bale bádsháhi, borzén arshay Hodáay pákén mardomán dayaga bit o abad tán abad hamáyáni melkata bit. ");
INSERT INTO bcc_vpl VALUES ("DN7_19","028_7_19","DAN","7","19","19","Padá man cháromi jánwaray pakkáén máná zánag lóthet, hamá ke gón wati ásenén dantán o brenjén panjagán cha é dega sajjahénán jetá o sakk báz torsnákter at, hamá ke wati shekári prósht o ér bort o pasht kaptagéni pádáni chérá lapáshtant. ");
INSERT INTO bcc_vpl VALUES ("DN7_20","028_7_20","DAN","7","20","20","Man áiay saray dahén kántháni máná ham zánag lóthet o é dega kánthay máná ham ke randá rost o áiay démá cha áyán say kánth kapt, bezán hamá ke chamm o dapi per at o bathák janagá at o gendagá cha é degarán master at. ");
INSERT INTO bcc_vpl VALUES ("DN7_21","028_7_21","DAN","7","21","21","Man angat cháragá atán o á kánth gón pákén mardomán jangá at o áyán chérdast kanagá at, ");
INSERT INTO bcc_vpl VALUES ("DN7_22","028_7_22","DAN","7","22","22","tánke hamá átk ke cha zamánagán hastent o borzén arshay Hodáay pákénáni hakká dádrasii kort o hamá wahd raset ke é pákénán bádsháhi wati melkat kort.’ ");
INSERT INTO bcc_vpl VALUES ("DN7_23","028_7_23","DAN","7","23","23","Gorhá áiá gwasht: ‘Cháromi jánwar, zeminay sará cháromi bádsháhié bit ke chó é dega sajjahén bádsháhiána nabit. É, sajjahén jaháná lagatmála kant, próshit o éria bárt. ");
INSERT INTO bcc_vpl VALUES ("DN7_24","028_7_24","DAN","7","24","24","Dahén kántháni máná esh ent ke cha é bádsháhiá dah bádsháh chesta bit o dega yakké cha eshán o rand chesta bit o é, pésarigénáni dhawléné nabit o say bádsháh prósha dant. ");
INSERT INTO bcc_vpl VALUES ("DN7_25","028_7_25","DAN","7","25","25","É, borzén arshay Hodáay helápá habara kant o áiay pákén mardomán ázára dant. Eshiay erádaha bit ke kánun o wahdán badal bekant o Hodáay pákén mardom pa wahdéá eshiay dastá dayaga bant, bezán tán wahdéá, wahdán o ném wahdá. ");
INSERT INTO bcc_vpl VALUES ("DN7_26","028_7_26","DAN","7","26","26","Bale diwán pa dádrasiá nendit. Áiay hákemi pach geraga bit o tán abad sarjamiá tabáh o barbád kanaga bit. ");
INSERT INTO bcc_vpl VALUES ("DN7_27","028_7_27","DAN","7","27","27","Padá bádsháhi, hákemi o ásmánay chéray sajjahén bádsháhiáni shawkat o mazani, borzén arshay Hodáay pákén mardomán dayaga bit. Hodáay bádsháhi abadi bádsháhié bit o sajjahén bádsháhi o molk, Hodáay hezmat o parmánbardáriá kanant.’ ");
INSERT INTO bcc_vpl VALUES ("DN7_28","028_7_28","DAN","7","28","28","Habar hamedá halás but. Mane Dányál cha wati hayálán sakk paréshán bután o mani dém zard tarret. Bale man é gapp gón wat dásht.” ");
INSERT INTO bcc_vpl VALUES ("DN8_1","028_8_1","DAN","8","1","1","Bádsháh Belsházaray dawray sayomi sálá mane Dányálá dega elhámé but, cha áiá o rand ke maná pésará butagat. ");
INSERT INTO bcc_vpl VALUES ("DN8_2","028_8_2","DAN","8","2","2","Man wati elhámá dist ke Shushay kalátá án ke Ilámay damagá ent. Elhámá diston ke Uláyay kawray kashá án. ");
INSERT INTO bcc_vpl VALUES ("DN8_3","028_8_3","DAN","8","3","3","Padá man sar chest kort o cháret ta dokánthén gwarándhé kawray démá óshtátag. Kánthi dráj ant, bale yakké cha domiá drájter ent o drájterén kánth randterá rost. ");
INSERT INTO bcc_vpl VALUES ("DN8_4","028_8_4","DAN","8","4","4","Man dist ke é gwarándh rónendi, góricháni o zerbári némagá kánth janán ent o hecch jánwar áiay démá óshtáta nakant o kassá é twán nést ke cha áiay zórá yakkéá rakként bekant. Áiá har chizz wati delay tabá kort o maz‌anshán but. ");
INSERT INTO bcc_vpl VALUES ("DN8_5","028_8_5","DAN","8","5","5","Man ke sharriá pegr kort gorhá diston ta yakk páchené cha rónendi némagá pédák ent ke purah sajjahén zemini geptag bale pádi zeminá nalaggagá ant o chammáni nyámá ajabén kánthé per enti. ");
INSERT INTO bcc_vpl VALUES ("DN8_6","028_8_6","DAN","8","6","6","Á hamá gwarándhay kerrá átk ke do kánthi per at, hamá ke man kawray démá óshtagá distagat. Páchen áiay sará hezhm geptagat o gón sarjamén zórá áiay sará kapt. ");
INSERT INTO bcc_vpl VALUES ("DN8_7","028_8_7","DAN","8","7","7","Man dist ke á, dém pa gwarándhá pédák ent. Sakk hezhm geptag. Páchená gwarándh jat o doén kánthi próshtant. Gwarándhá áiay démá hecch zór mán néstat. Zeminay sará dawri dát o pádmáli kort. Kass néstat ke gwarándhá cha áiay zórá berakkénit. ");
INSERT INTO bcc_vpl VALUES ("DN8_8","028_8_8","DAN","8","8","8","Padá páchen sakk zóráwar but bale anchó ke wati zóráwariay borzádián sar but, mazanén kánthi prosht o áiay jágahá chár dega ajabén kánth rost ke démesh ásmánay chárén gwátáni némagá at. ");
INSERT INTO bcc_vpl VALUES ("DN8_9","028_8_9","DAN","8","9","9","Cha é kánthán yakkéay sará kasánén kánthé rost ke jonubi, ródarátki o zébáén molkay némagá rodán o sakk mazan bayán but. ");
INSERT INTO bcc_vpl VALUES ("DN8_10","028_8_10","DAN","8","10","10","É ásmáni lashkaray némagá rost o lashkaray bahré o lahtén estári zeminá dawr dát o pádmál kort. ");
INSERT INTO bcc_vpl VALUES ("DN8_11","028_8_11","DAN","8","11","11","Eshiá watárá lashkaray sáláray dhawlá mazan kort. Har róchigén korbánigi band kanáéntant o mazanén parasteshgáhi kamsharap kort. ");
INSERT INTO bcc_vpl VALUES ("DN8_12","028_8_12","DAN","8","12","12","Eshiay sarkasshiay sawabá ásmáni lashkar o har róchigén korbánig eshiay dastá dayag butant. Rástii zeminá dawr dát o har chizzi ke kort, kámyáb but. ");
INSERT INTO bcc_vpl VALUES ("DN8_13","028_8_13","DAN","8","13","13","Nun man eshkot pákéné habará ent. Dega pákénéá cha áiá jost kort: “É elhám, bezán har róchigén korbánig, tabahkárén sarkasshi, Hodáay pákén lógay chérdasti o lashkaray pádmál bayagay elhám o shobén tán kadéná barjáha mánit?” ");
INSERT INTO bcc_vpl VALUES ("DN8_14","028_8_14","DAN","8","14","14","Áiá passaw dát: “Tán do hazár o say sad sohb o bégáhá, randá parasteshgáh padá pák o barjáh kanaga bit.” ");
INSERT INTO bcc_vpl VALUES ("DN8_15","028_8_15","DAN","8","15","15","Wahdé mane Dányál shobéná cháragá atán, man sarpad bayagay johd kort ta diston ke mani démá chizzé óshtátag ke purah ensánéay dhawlá ent. ");
INSERT INTO bcc_vpl VALUES ("DN8_16","028_8_16","DAN","8","16","16","Man cha Uláyay kawray nyámá ensáni tawáré eshkot, gwánki jat o gwashti: “Oo Jebráil! É mardá shobénay mánáyá sarpad kan.” ");
INSERT INTO bcc_vpl VALUES ("DN8_17","028_8_17","DAN","8","17","17","Gorhá á mani nazzikká hamódá átk ke man óshtátagatán. Maná torsé jáná kapt o dém pa chér kaptán. Áiá maná gwasht: “Sarpad bay, oo ensánay chokk! Shobén halásiay wahday bárawá ent.” ");
INSERT INTO bcc_vpl VALUES ("DN8_18","028_8_18","DAN","8","18","18","Hamá wahdá ke á gón man habará at man dém pa chér wapt o sakk wáb kaptán. Áiá maná dast per kort o óshtárént. ");
INSERT INTO bcc_vpl VALUES ("DN8_19","028_8_19","DAN","8","19","19","Gwashti: “Bechár, man tará sarpada kanán ke gazabay goddhi wahdá ché bit. Harché ke taw distag halásiay gisshéntagén wahday bárawá ent. ");
INSERT INTO bcc_vpl VALUES ("DN8_20","028_8_20","DAN","8","20","20","Dokánthén gwarándh ke taw dist, Mád o Pársay bádsháháni nesháni ent. ");
INSERT INTO bcc_vpl VALUES ("DN8_21","028_8_21","DAN","8","21","21","Páchen, Yunánay bádsháhay nesháni ent o hamá baláhén kánth ke áiay chammáni nyámá at, awali bádsháh ent. ");
INSERT INTO bcc_vpl VALUES ("DN8_22","028_8_22","DAN","8","22","22","Hamá chárén kánthán ke proshtagén kánthay jágah gept, á chár bádsháhiay nesháni ant ke cha eshiay kawmá chesta bant bale eshiay dhawlén zór o wákesh góna nabit. ");
INSERT INTO bcc_vpl VALUES ("DN8_23","028_8_23","DAN","8","23","23","Áyáni dawray goddhi zamánagá, wahdé sarkasshi cha géshá géshtera bit, haybatnák o petnahsázén bádsháhé kayt. ");
INSERT INTO bcc_vpl VALUES ("DN8_24","028_8_24","DAN","8","24","24","É, sakk zórmanda bit bale cha wati jenday wáká na. Sakkén baláhén tabáhia kárit o harché ke kant, kámyába bit. É, zóráwar o pákén mardomán tabáha kant. ");
INSERT INTO bcc_vpl VALUES ("DN8_25","028_8_25","DAN","8","25","25","Pa hóshmandi pandala sázit o kámyába bit. Wati delá watá mazan sarpada bit. Bázéné sahig ham nabit o émeniá neshtagén jágahá tabáhesha kant. É, s