﻿USE sofia;
DROP TABLE IF EXISTS sofia.bbr2013_vpl;
CREATE TABLE bbr2013_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bbr2013_vpl WRITE;
INSERT INTO bbr2013_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Okoro Jisas Krais* nukan askanai akan enmaka, Jisas ko Devit nukan kinjauk ko Apraham nukan askanai. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","6","Apraham ko akan momonaka pakas pote Devit kamwareäwon ro, akan enmak okoro jer we moin, rau: kiro Apraham, Apraham nukan mokoi Aisak, Aisak nukan mokoi Jekob, Jekob nukan mokoi Juda, kon amakut pak, Juda nukan mokoi Peres, ko Sera ori awan aninawa Tamar, Peres nukan mokoi Hesron, Hesron nukan mokoi Ram, Ram nukan mokoi Aminarap, Aminarap nukan mokoi Nason, Nason nukan mokoi Salmon, Salmon nukan mokoi Boas, kon anak Rehab, Boas nukan mokoi Obet, kon anak Rut, Obet nukan mokoi Jesi, Jesi nukan mokoi, kamwareäwon ro king Devit. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","11","Devit rawon ses opok Israel roasiret Babilon mena karapus imware manoin, okoro askanai akan enmaka: kiro Devit, Devit nukan mokoi Solomon, ko Uria nukan waun mokoi, Solomon nukan mokoi Rehoboam, Rehoboam nukan mokoi Abija, Abija nukan mokoi Esa, Esa nukan mokoi Jehosapat, Jehosapat nukan mokoi Jehoram, Jehoram nukan mokoi Usia, Usia nukan mokoi Jotam, Jotam nukan mokoi Ehas, Ehas nukan mokoi Esekaia, Esekaia nukan mokoi Manasa, Manasa nukan mokoi Emon, Emon nukan mokoi Josaia, Josaia nukan mokoi Jekonaia, kon amakut pak. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","16","Babilon* mena Israel roasiret pote rain ses opok, pote Jisas an jowon ses opok, okoro askanai akan enmaka: kiro Jekonaia, Jekonaia nukan mokoi Sealtiel, Sealtiel nukan mokoi Serubabel, Serubabel nukan mokoi Abiut, Abiut nukan mokoi Eliakim, Eliakim nukan mokoi Eso, Eso nukan mokoi Sadok, Sadok nukan mokoi Ekim, Ekim nukan mokoi Eraiat, Eraiat nukan mokoi Eleasa, Eleasa nukan mokoi Matan, Matan nukan mokoi Jekob, Jekob nukan mokoi Josep, ko kon wau Maria, ko Jisas nukan anak. Jisas ko Krais. Kiro enip onoktapau ‘Anut nukas äsimorwon, ätäi imäikaun ro’. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Keseria, kiro askanai 14 orip akan tupsiu pakas ak Apraham raiäwon ses pakas pote Devit rawon opok. Karauk askanai ak 14 orip akan tupsiu pakas, Devit rawon ses pakas pote Babilon mena karapus rain opok. Keseriar, askanai 14 orip akan tupsiu pakas karapus rain pakas pote Jisas Krais an jowon ses opok rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisas Krais owose pewon? Kon pewon onok kesek. Kon anak Maria ko Josep owaun sare moin. Utianik, meter kiro ro asir ori au ouratäu wa opok, Maria ko äpu mowon Anut nukan Osou Näus ko amaiwo sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Josep ko erekapu onok eposek miäu. Keseria, ko roasiret amiak opok Maria utonuk, Maria wou aru mai. Keserianik, ko ämäi ämäi Maria utaun ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Utianik, Josep ko asik utaun ronkat ounuk ounuk, Anut nukan sarau eitekus* nini epir pakas keser auruwon, “Josep. Devit nukan askanai, Anut nukan Osou Näu nukasar Maria amaiwo sarewon. Keseria, na kiro asik owaun itok, ko nan asik. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ko mokoi an jounuk, na kon enip Jisas mam. Kiro enip onoktapau ‘kos kon roasiret akan onok aru jäkäi mareanik, ak ätäi imwarai’.” ");
INSERT INTO bbr2013_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Rurisapai, kiro onok erekapu Näwäu nukas Anut nukan ämän roianik, areawon ro*, Aisaia, auruwon siar kiro epar peu. Aisaia nukas äiewon, ");
INSERT INTO bbr2013_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kar asir makun ko ro pak niniäu wa, ko amaiwo sareanik, ko mokoi an jowai, kiro mokoi kon enip Emaniuer äiäiei. Kiro onoktapau kesek, ‘Anut ik pak rau’.” ");
INSERT INTO bbr2013_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Keserianik, Josep ko siräumara, Anut nukan sarau eitek nukas auruwon siar kon asir Maria ätäi owon. ");
INSERT INTO bbr2013_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Utianik, Josep ko kiro asir pak ninau wa erar rai rai, pote Maria ko mokoi an jowon. Mokoi an jounuk, Josep nukas kiro mokoi enip Jisas mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jisas ko anakus Betlehem mena Judia provins opok an jowon. Kiro ses opok, Herot ko kiro omsau kamwareäwon ro näwäu king rawon. Maria an joi raunuk raunuk, karauk san peäwon pakan äpu miäin roat ak pai awau penuk, aparianik, ak kiro pai tainori Jerusalem näu mena koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Ak koianik, akas kiro pakan keser totwaroin, “Juda* akan kamwaraun mokoi awau pewon, kiro erapok pe rau? Ik kon pai san peäwon pakas penuk, aparianik, ik ko jou muraun koum.” ");
INSERT INTO bbr2013_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kiro omsau kamwareäwon ro king Herot kiro ämän roianik, ko wou aru mowon, roasiret erekapu Jerusalem menan ak erek woiaka aru moin. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Keseria, Herot nukas Anut kamuk raiäi roat näunäu* pak sintore ämän tamareäi roat* pak ak erekapu ämän surmaronuk, kouna, totwarowon, “Krais, Anut nukas ko äsimornuk, kowai, kiro ro ko erapok pe rau?” ");
INSERT INTO bbr2013_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Akas ätäi ko aurin, “Betlehem mena Judia provins opok. Meter Anut nukan ämän roianik, areawon ro nukas keser jer we mowon: ");
INSERT INTO bbr2013_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betlehem, na mena eteinak Judia provins opok, na ruris wa rawaun. Wa senes. Nan kar ro näwäu päi. Kiro ro päi ko isan Israel* roasiret kamwarai.’ Keseria, ko Betlehem mena kowai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Keser aurna, Herot nukas ämäi ämäi kiro roat san peäwon pakan totwarowon, “Kiro pai owo ses opok pewon?” Kiro onok totwarowon rowaun. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ko Betlehem mena äsimwareanik, keser ämän awarowon: “Ak potoinai, kiro mokoi jekur itane aparia, is ätäi koi airaiei. Keserna, isas pak erek pote jou muram.” Ko kiro mokoi pote wäun rai keser kiro sät ämän awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Keseria, kiro pai ninareäi roat ak Herot nukan ämän roumoi, ute manoin. Ak apu opok pote rai, kiro pai meter san peäwon pakaimas aparin. Kiro pai amke pote kiro mokoi rawon ou opok kämioik rawon aparianik, ak woiaka näu sareanik, nepipirin. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ak pote kiro owa toneanik, kiro mokoinak kon anak pak rawon aparianik, akan uoraka sur weanik, kiro mokoinak jou murin. Keseria, ak karauk osap enip aiauk gol* pak pauda kapasmer pak am an anakas sou eposek orip pak oianik, kiro mokoinak nurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ak kiro mokoinak osap nurianik, rauna rauna, Anut nukas nini epir pakas ämän jekur awarowon siar, “Ak ätäi Herot siakup wa potaiei.” Keseria, kiro roat kar apu pakaima akan mena ätäi manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Pai ninareäi roat ute manona, Anut nukan sarau eitek kararas pemara, nini epir pakaima Josep keser auruwon, “Herot nukas mokoi wäun itanera. Keseria, na kurte siräinam, mokoi anak ori imwatoinam, Ijip omsau imine pote rawam. Au kiro opok rawaieir. Imkanik, isakasar ätäi aisoita, ak ätäi kowaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kiro pututur, Josep ko siräumara, mokoi anak ori Ijip omsau imwate manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ko kiro opok pote raunuk raunuk, Herot meiewon. Keseria, kiro ämän meter Näwäu nukas Anut nukan ämän roianik, areawon ro nukas äiewon epar pewon, ‘Isan mokoi Ijip omsau pakan urweita, kowon.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Josep ko Ijip omsau manonuk, Herot ko pai ninareäi roat akas sät aurianik, manoin ämän roianik, ko kasak pewon. Keseria, kon marai roat awaronuk, ak kiro Betlehem mena pak karauk mena Betlehem mena siakup rain pak ak kiro menan mokoinakut apur jeäin woisan oiroror orip pak rusapaian mokoinakut pak erekapu akwarona, meiein. Owon, ko pai ninareäi roat akas kiro ses kiro pai pewon aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kiro onok Anut nukan ämän roianik, areawon ro Jeremaia nukas areawon ämän rusapai epar peu: ");
INSERT INTO bbr2013_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ko keser äiewon, ‘Rama* mena waiein jejep roin. Resel ko kon mokoit akanun waira. Karauk asiret akas kon wou näu saräun ämän aurna, ko akan ämän rowau wa. Ko ätäi wai rawon. Kon mokoit rawau wa, erekapu meiein.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Rai rai, Herot meienuk, Anut nukan sarau eitekus Josep Ijip omsau rawon nini epir pakaima pe auruwon, ");
INSERT INTO bbr2013_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Na siräinam, mokoi kon anak ori ätäi Israel akan omnokou opok imwate potam. Owon, kiro roat ak mokoi wäun keserin roat ak meiein.” ");
INSERT INTO bbr2013_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Keseria, Josep ko siräumara, kiro mokoi anak ori ätäi Israel akan omnokou opok imwate potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herot ko meienuk, Arkelaus ko kon momokun omoi pe oumara, Judia provins kamewon. Josep ko kiro ämän roumara, kiro opok potaun iminewon. Ko iminenuk, Anut nukas nini epir pakas ämän sosop jekur nurunuk, ko Judia provins tonau wa, Galili provins potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ko pote Nasaret mena om owon. Keseria, Anut nukan ämän roianik, areain roat akas arein kiro ämän epar peu: ‘Ko Nasaret menan ro.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jisas ko näwäu sarenuk, kiro ses opok, Jon, an jomareäwon ro, ko ro wäpik mena Judia provins om puru opok sarau onoktorowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jon nukas roasiret ko siakup kouna, awarowon, “Ak akan onok aru pakan ätäi pirirwe. Owon, Anut ak kamwaraun ses kou!” ");
INSERT INTO bbr2013_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jon nuka mesin Anut nukan ämän roianik, areawon ro Aisaia nukas meter ronkatemara, arewon: “Kar ro, ko ro wäpik mena om puru opok urwera. ‘Näwäu nukan apu jekur sare muruwe. Kon apu tuku muruwe!’” ");
INSERT INTO bbr2013_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jon nukan omjo opur kamel urik oumara, omjo ate mowon, ko kar opur kerau oumara, let senek takeäwon. Ko sonkäpit pak upes an pak jeäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalem menan roasiret pak karauk roasiret erekapu Judia provins opok rai pak, Jordan An kasakup raiäin roasiret pak erekapu ak ko siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ak akan onok aru Anut aurna, Jon nukas Jordan An opok an jomarowon*. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Jon ko Parisi* Sadusi* roat sosop an jowaun koin apwaromara, kos awarowon, “Ak män nukan tupsiu senek, akan onok aru senes Anut ak akwaraun kowai ses opok ak owose imine manaiei? ");
INSERT INTO bbr2013_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ak akan onok aru sumkäineinai, woiaka pirirwe. Kiro karauk roat äpu maiei akan onok aru pakan ätäi piririn. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ak akan ronkat keser wa oumoi, äiäu, ‘Apraham ko iken askanai. Keseria, Anut nukas ik sareikonuk, ik eposek rawam.’ Is ak epar senes awarom okoro aiauk omnokou opok rai Anut nukas oianik, Apraham nukan kinjaukut senek ate maun itok. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anut nukan ipous man ateanik, am rurukup me rau. Karauk am nemauk jekur wa muriäu, manas kiro am patirianik, oi ep unik uru kurenuk, jerai. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Is rusapai anas ak an jomariäim, kiro akan onok aru pakan piriraun kesermin. Utianik, kar ro ruris koura, kon sakaus isan sakau itimorai, kos Anut nukan Osou Näu ep orip pakas an jomarai. Is ko itimorau senek wa, is ro eposek wa. Keseria, is kon su ämäi murau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ko sauwor ipous ate rau, kiro sauworis wit oreanik, oik monuk, uriris kiro wit sinok utarianik, wit näu oianik, kon owa seper mai, sinok apoi oianik, ep wa koseriäu opok makai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kiro ses opok, Jisas ko Galili provins utomara, pote, Jordan An opok ko Jon nukas an jomuraun rai kowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Utianik, Jon nukas Jisas kon ronkat ätäi piriraun rai auruwon. “Na kiro onok wa keserau. Nasar is an joi muraun itok. Na owon isas an jomusaun rai koum?” ");
INSERT INTO bbr2013_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jisas nukas ätäi auruwon, “Mus, rurisapai nas keser! Kiro Anut nukan onok ik erekapu keseram. Iu kesersa, Anut apaitianik, äiäi, kiro onok tuku.” Keseria, Jisas nukas Jon auruwon siar Jon keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jon nukas Jisas an jomurnuk, ko kurte an utomara, kasakup pewon. Ko kasakup pemara, Anut nukas omar im tuewon aparwon, ko Anut nukan Osou Näu ai manap senek ko opok koianik, tapakup rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Näwäu nukas kar ron pätu senekus omar oikas urwenuk, rowon, “Okoro isan mokoi senes konun isan woias meieäim. Isan woias konun näu sareu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Keserianik, Anut nukan Osou Näus Jisas ro wäpik mena om puru opok Satan nukas ate aparaun imäi potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Omre 40 orip Jisas ko o wäpik sou rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Kiro ses opok, Satan nukas ko siakup pemara, auruwon, “Na Anut nukan Mokoi raroi, na okoro aiauk aurta, bret etäunuk, je.” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Utianik, Jisas nukas ätäi sakau ämän auruwon, “Ei, Anut nukan ämänis keser äieu, ‘Ro bret karar jeanik, awau wa rawai, Anut nukan ämän karar tainorianik, epar awau rawai.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Keseria, Satan nukas Jisas Jerusalem näu mena imäi manowon, Anut osap nuriäi ou näwäu kämioik mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Keserianik, auruwon, “Na Anut nukan Mokoi raroi, nakasar kiro pakas omnokou opok pitikänir nopot? Kiro Anut nukan ämänis äieu, ‘Anut nukas kon sarau eitek nanun awarai: Akas nan ipon karaim karaim ateanik, oi ne musaiei. Keserna, kar aiaukus nan ison wa wäi.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisas nukas ätäi sakau ämän auruwon, “Ei, utianik, Anut nukan ämänis keser äieu, ‘Na nan Näwäu Anut wa ate apar.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan nukas Jisas omtapau rumukäu senes kämioik imäi tonomara, osap erekapu sakau orip okoro omnokou opok rau ätär muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Satan nukas auruwon, “Na nan uon sur wenam, na is jou murota, okoro osap na apari raum kiro erekapu na isam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kesernuk, Jisas nukas auruwon, “Satan, na ute man! Anut nukan ämänis äieu, ‘Na nan Näwäu karar jou mur. Na Anut nukan sarau karar muram.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Keser aurunuk, Satan ko Jisas ute manowon. Anut nukan sarau eitek akas koianik, Jisas sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kiro ses opok, Jisas ko Jon karapus owa kurein ämän roianik, kiro mena ute Galili provins opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ko Nasaret mena karar rawau wa, ko pote Kapaneam mena rawon, kiro mena Galili An Unik siakup, Sebiulan Naptali ori awan tupsiu akan om taku opok pote rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Keseria, kiro onok Anut nukan ämän roianik, areawon ro Aisaia nukas meter arewon siar epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Sebiulan nukan omnokou pak Naptali nukan omnokou pak, näu apu mas an kasakup omnokou rau pak Jordan An kasakup karaima, Galili provins pakan roasiret pak karauk menan roasiret pak akan woiaka Anut mesin epar wa miäi ak raiäin. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kiro pakan roasiret ak pututu rai, ak arou näwäu aparaiei! Karauk roasiret ak erekapu om pututu senes uru meiauri rai ak nais arou merek aparaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kiro ses opok, Jisas kon sarau onoktoroianik, keser äiewon: “Anut ak kamwaraun ses kou. Kesernuk, akan onok aru pakan ätäi pirirwe!” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisas ko Galili An Unik kasakupaias ari ari pote, was oiäirin roat ori apwatowon. Kar ro Saimon, kon kar enip Pita; kon amak enip Andru, au was owaun jo an unik opok kure rairin. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisas nukas keser awatowon, “Au koi, is tainoirsa, isas au roasiret imwaraun onok ätär matam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Jisas nukas keser äienukar, au awan was oiäin jo pak karauk osap ous opok utomoi, kurte Jisas tainor manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ko pote, kar ro oirori apwatowon. Kiro ro Jems kon amak Jon pak, au Sebedi nukan mokoit ori. Au awan momonawa Sebedi pak akan ous opok rain, ak akan was oiäi jo kiräiwon, okon, jekur rain. Jisas nukas kiro roat ori urwatowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Au kurte awan ous pak awan momonawa pak utomoi, Jisas pak manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisas ko Galili provins ari ari potomara, Anut nukan Ämän Eposek Juda roasiret akan tururiäi owa tonemara, awarowon, “Anut ko koi ätäi roasiret imwarai.” Jisas ko ämän keser äianik, karauk roasiret ui pak sip pak osou aru orip pak jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Roasiret kon onok aparianik, kiro ämän Siria provins erekapu manowon. Keseria, kiro pakan roat akas karauk sip roat sosop pak, roat tätäi näwäu orip pak, roat osou aru akan woiaka uru rau pak ate karwareäu roat pak isiaka ipiaka meiewon roat pak, Jisas siakup imware kouna, kos erekapu jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Roasiret sosop sosop Galili provins pakan pak näu mena 10 orip enip Dekopolis pakan pak Jerusalem menan pak Judia provins pakan, omnokou Jordan An karaima pak ak erekapu Jisas tainori manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisas ko roasiret sosop apwareanik, pote kar omtapau opok tane rawon. Kesernuk, kon tamareäu roat* akas ko siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ak keserna, Jisas ko owosein akan woiaka näu saräiei räi awarowon. Ko keser awarowon: ");
INSERT INTO bbr2013_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Inok roasiret ak äpu akasar akan totomaka sarwarau senek wa, akararnak onok eposek mau senek wa, ak woiaka eposek saräiei. Anut nukas ak kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Inok roasiret ak wai raiäi, ak woiaka eposek saräiei. Anut nukas kiro roasiret akan woiaka aru ätäi jekur maronuk, rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Inok roasiret akan enmak akasar wa jou miäi, ak woiaka eposek saräiei. Anut nukas ak osap araun awaronuk, kiro erekapu akan owaiei! ");
INSERT INTO bbr2013_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Inok roasiret ak Anut nukan onok eposek owaun sarau sakau maiei ak woiaka eposek saräiei. Owon, Anut nukas akan sarau moin apwareanik, sarwarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Inok roasiret ak karauk roasiret akanun woiakas meiewon, ak woiaka eposek saräiei. Anut nukas keseriar akanun wous meiäi! ");
INSERT INTO bbr2013_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Inok roasiret ak woiaka uru ukun wäpik ak woiaka eposek saräiei. Ak Anut aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Inok roasiret akan sarau kiro karauk roat weräuna, erar rawaun patir ariai, ak woiaka eposek saräiei. Anut nukas ak isan mokoit awarai! ");
INSERT INTO bbr2013_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Inok roasiret ak onok eposek orip Anut nukan sarau muruna, karauk roat akas apwareanik, kasiaka penuk, karauk usu ak opok mona, ak woiaka eposek saräiei. Kiro roat Anut nukas kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ak is tainori arina, karauk roat ak apwareanik, sät ämän enmak opok mianik, jeim wareanik, akwarona, ak woiaka wa aru mau, ak woiaka näu saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ak woiaka näu saräiei, owon, Anut nukas karauk osap eposek sare marowon omar oik rau tawa owaiei. Kiro onok meter iken karauk asanokot akas Anut nukan ämän roianik, areain roat akwaroin siar roat akas ran rusapai ak kesewaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisas nukas ätäi awarowon, “Roasiret akan woiaka epar moin erekapu ak siu senek. Utianik, siu ko mitu wäpik sarenuk, ätäi kiro siu mitu sare maun senek wa. Kiro erekapu aru mowon, ak känkurena, roasiret akas isiakas tai kureäi! ");
INSERT INTO bbr2013_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Roasiret akan woiaka epar moin kiro ak omsau akan arou senek. Näu mena omtapau opok ou miäi kiro ämäiäu senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kar ros kon arou aioi mianik, baket uru wa miäu. Ko arou aioianik, kämioik amparar äsäi monuk, roasiret erekapu kon merek opok raiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kiro onok senek akan arou merek kiro roasiret akan amiak opok maraiei. Keseria, akas ak owo onok eposek keserin ak aparianik, akan momonaka omar oik rau ak kon enip jou maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jisas nukas ätäiar roasiret awarowon, “Ak is Moses nukan sintore ämän pak Anut nukan ämän roianik, areain roat akan ämän maroin kiro oi kuräun koim ra ak keser wa ronkatäu. Utianik, is kiro ämän oi kuräun kowau wa, is akan ämän kiro iporaun koim. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Is epar senes awarom, omar pak omnokou pak rain ses opok kar sintore ämän eteinak wa ämäiäu. Akan ämän karar karar erekapu epar, päi kiro ses opok epar, akan sintore ämän patarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Keserianik, inok ros kiro sintore ämän eteinak senes wa tainorianik, kos karauk roat kon onok ätär maronuk, kon enip Anut nukan amuk opok eteinak senes rawai. Kar onok kiro kesek, na inok ros kiro sintore ämän eteinak erekapu tainorianik, nas pak karauk roat kiro onok ätär maram nan enmat kiro Anut nukan amuk opok näwäu rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Is ak epar awarom, akan woiakas epar Anut mesin meieanik, akan onok eposek äpu meiäi roat pak Parisi roat akan ämän tamareäi roat pak itimwarau wa, ak epar Anut nukan kamwaraun mena tone rawau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisas nukas ätäiar awarowon, “Ak okoro ämän meter asanokot akas arena, roiäin, ‘Na kar ro wa weta, meiäu. Inok ros ko kar ro wenuk, meiäi ko ämän roiäi roat amiakap imäi potaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Utianik, rurisapai is ak awarom, inok ro ko kon jauk pak ketäirin ko ämän roiäi roat rawa imäi potaiei. Inok ro ko kon jauk jeimarnuk, ko kaunser opok imäi potaiei. Inok ro ko kon jauk aurai ‘Na raun otop’ auruwon, kiro ro ko Satan nukan ep uru nai. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Keserianik, na nan opur ra o ra oianik, Anut nukan osap nuraun patan opok maun oi kowam, ätäi ronkatäm nan jaun na pak ämän orip aurumon, na ätäi ute manam, ");
INSERT INTO bbr2013_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Nan opur ra o ra kiro patan siakup moinam, pote nan jaun pak aremoi, awan woiawa karar mianik, na ätäi koia, nan osap oianik, kiro patan opok mianik, Anut nuram. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Utianik, na kar ro ori ämän roiäi roat rawa manaun au apu opok pote rai, kiro omre potorair opokar awan ämän ätäi woiawa nau saräun jekur aräieir. Keseria, ko na ämän roiäi roat opok wa imäisi potai. Na kiro wa keseram, kos na ämän wasarewareäu ro nukan ipoukup musonuk, kos na polis nukan ipokup musonuk, polis nukas karapus owa kureisai. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Keseria, na kiro owas ätäi kasik naun erar wa äsimoisaiei. Utianik, na aiauk näwäu maun aisowon keseriar erekapu marota, epar na kasik utoisona, manam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisas nukas ätäiar awarowon, “Ak ämän meter keser arein roin. ‘Na asik oumon ro karauk asiret kuruk wa imware ariäu.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Utianik, is keser awarom, kar ro ko kar asir aparianik, kon wou siräianik, aru muram keser ronkatewon, kiro ro kon wou uruas kiro asir pak onok aru mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Keseria, na nan amunauk näu kaima onok aru maun reusonuk rai, kiro amunauk siräi oinam, känkuräm! Kiro amunauk eteinak känkureta, nan enmatsau erekapu orip Satan nukan ep näwäu orip orip jereäu mena wa kureisaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nan ipon näu kaima onok aru maun reusonuk, kiro ipon nau kaimas patir oinam, känkur. Na ipon utup rawam, kiro itok, nan enmatsau erekapu Satan nukan ep näwäu orip orip jereäu mena wa kureisaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisas nukas ätäi awarowon, “Meter kiro keser äiein, ‘Inok ro ko kon asir utonuk, manaun ko kar pepa eteinak opok jer weanik, asir nuria, kiro asir utonuk, manai.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Utianik, is ak awarom, kar ro kon wau sapum onok aru mau wa, erar utai, kiro ros onok aru senes kon wau opok keseru. Ko kon wau usu nuriäu, owon, wau ko ätäi kar ro ounuk, ko roasir ouratäiäi akan sintore ämän espäiäu. Kar ro kiro asir owai, kiro ro ko nais kiro sintore ämän espäiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ko ätäi äiewon, “Ak meter roasiret keser awaroin roin, ‘Na owo paip Anut pak moirin kiro wa utam, utianik, na owo paip Näwäu pak momon siar, kiro keseriar tainoram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Utianik, ruris is ak awarom, na kar ämän mia, kiro ämän paip pak wa sakau mau. Na ämän äianik, na omar nukan enip wa atau, owon, omar kiro Anut nukan taneäwon patan. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Na omnokou erar wa enip atau, owon, kiro opok Anut kon isou mianik, sume raiäu. Na Jerusalem enip wa atau, owon, kiro Anut iken kamoikeäwon ro näwäu kon näu mena. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na kar ämän mianik, na tapan wous kiro ämän ronkatemoi, wa sakau mau, owon, nan kar tapan urik aurta, ärneu ra, mokup ra, wa päi. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na erar keser ‘io’ ra, ‘wa’ ra, äiäum. Na owo kar ämän areäum, kiro ämän Satan nuka pakas koiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisas nukas ätäi äiewon, “Meter ak keser arena, roin, ‘Kar ros nan amunauk aru musonuk, nas nais ätäi kon amukauk karar aru muram, kar ros nan aunpanak porurnuk, nas nais kon aukpanak karar poruram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Utianik, rusapai is ak awarom, kar ros iwosonuk, nas ätäi ko wa wäu. Kar ros nan sipon näu kaimas purnuk, ätäi pirirnam, sipon sau kaimas nuruta, purai. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Kar onok kesek, kar ros na ämän roiäi ro opok imäisi potauri nan omjo rumukäu ounuk, nas wa tämurau. Utota, nan kar omjo nais owaura. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Kar onok kesek, kar marai ros kon jo oianik, apu rumukur imäiri manau aisonuk rai, nas pak kiro ro imäianik, apu rumukäu senes imäi pote mam. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Kar ses opok, kar ros nan osap owaun aisonuk, na wa tämarau, na ko nuram. Kar ros pak nan o ra, karauk osap ra oia, ‘ätäi amuk isam aisonuk rai, na ko wa sumkäinäu, na ko nuram.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Kos ätäi äiewon, “Meter ak ämän keser arein roin, ‘Nan wonas nan jaunan karar meieäum, utianik, na nan iwäi jaunat mesin wonas wa meieäum.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Utianik, rusapai is ak awarom, akan iwäi jaunakat akanun woiakas meienai, kiro roat akas ak akwaroin akanun ak Anut nukas sarwaraun auraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Keseria, ak akan momonaka omar oik rau nukan mokoit saräiei. Anut nukas san ate mianik, arou merek kiro roasiret aru pak roasiret eposek pak arou mareäu. Om nais kesekur roasiret eposek pak Satan nukan onok aru miäi roat pak erek om ne mareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Karauk roat akas akanun woiakas meieäi, akas nais ätäi kiro roat akanun karar woiakas meieäi. Keserna, Anut nukas ak kar osap eposek arai ra? Kiro roat onok aru orip akas nais kir keseriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ak akan jaunakat karar ämän eposek maraiei, ak karauk roat ämän eposek wa maraiei. Akan onokus karauk roasiret akan onok wa itimwaraiei. Owon, Anut nukan ämän wa roiäi roat akas nais kir keseriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Akan momonaka omar oik rau kon onok eposek senes. Keseria, ak nais ko senek onok eposek senes orip rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisas nukas ätäiar awarowon, “Ak jekur ronkatewe. Ak akan onok eposek eposek karauk roasiret akan amiakap wa keserwe. Utianik, ak kiro onok roasiret amiakap keserna roi, akan momonaka omar oik rau, kos ak kar osap wa arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ak kar saruku ro osap nuraurmana, ak karauk roasiret urwarna, wa koi aparaiei. Kiro sätäiäi roat akas Juda roasiret akan tururiäi owa, apu opok akan onok keser ariena, roasiret akas apwareanik, iken enmok roror mukaurai räi keseriäi senek. Ak wa keserau. Is ak epar senes awarom, kiro sätäiäi roat akan osap erekapu oin. Tawa Anut nukas kiro roat osap wa arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kar ses opok, na saruku ro osap nuraun, ämäi ämäi nuram. Keserta, nan jaunat ak na siatap rai akas wa apaisianik, äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na keseram, kiro nan onok ämäi rawai. Na kiro onok ämäi kesermon nan Momonas karar apaisianik, kos na ro eposek aisianik, tawa na osap isai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ak Anut auriäi ses opok, sätäiäi roat akas keseriäi senek wa keserau! Ak roasiret akas apaikia, akan enmak roror maurai rai, nepipirianik tup owa pak näu apu kasakup tai raianik, Anut auriäi senek ak wa keserau. Is ak epar senes awarom, kiro roat akan osap erekapu oin. Tawa Anut ak kar osap wa arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Utianik, na Anut auraun nan niniäum ou waru uru tonoinam, im penemata, nan Momon ämäi rau aparaun, auram. Na keserta, nan Momonas nan aurumon ronkat aparianik, tawa kar osap isai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ak Anut auraun ses opok, ämän sepuk sepuk wa arau. Roasiret Anut mesin woiaka epar mau wa, akas akan sät eitek aurianik, ämän sosop rowaura rai keseriäi senek ak kiro wa keserau. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ak kiro roat senek wa saräu. Ak Anut aurau wa opok, ko akan ronkat meter äpu mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ak Anut keser aurwe, ‘Iken momonek, na omar oik raum. Nan enmat eposek ik jou musiäum. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nan kamoikaun ses okoro omnokou erekapu koi itok mai. Nan onsau omar oik tainoriäi senek, ik nais omnokou pakan erek tainoram. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Omre orip orip ik nas o ikam. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ikes karauk roat akan onok aru ik opok mukiäi jäkäi mareäum senek, nas pak iken onok aru jäkäi muk. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na ik osap ate apaikaun opok wa kureikam. Na ik utoikota, onok arus wa imäikai.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Keseria, ak akan jaunakat akas onok aru ak opok mareäi, akas kiro akan onok aru jäkäi marona, akan momonaka omar oik rau kos nais akan onok aru miäi jäkäi marai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Utianik, ak akan jaunakat akan onok aru wa jäkäi marona roi, akan momonakas nais akan onok aru wa jäkäi marai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisas nukas ätäi awarowon, “Ak Anut auraun o utiäi, kiro sätäiäi roat akas o utomoi, wopure raiäi senek wa keserau. Ak sou ariena, karauk roat akas apwareanik, kiro roat akas äiäiei kiro roat ak o utoinus, keserai. Is ak epar senes awarom, kiro roat ak akan osap erekapu oin. Tawa Anut nukas kar osap wa arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Na o utoinam, an joumoi, sarat putaria, nan omjo eposek takäm. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Na kiro onok keserta, karauk roat akas na o utomon wa äpu musaiei. Nan momon ämäi rau, ko karar äpu mai. Na kiro onok ämäi kesermon, nan momonas apaisia, kos na ro eposek aisianik, tawa kos na osap isai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisas nukas ätäiar awarowon, “Ak okoro omnokou opok akan osap eposek sosop sosop wa turur maiei. Ak kiro keseraiei, nunuris karauk osap aru miäi, karauk akan osap erekapu aru mau wa, karauk päu roat akas akan ou kiräianik, kiro osap päu owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Utianik, ak akan osap eposek omar oik turur mowe. Kiro opok, nunuris wa aru maiei. Päu roat akas kiro opok akan ou wa kiräianik, akan osap erekapu wa owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Keseria, owo mena nan osap turur miäum opok nan wonauk nais kiro mena rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Kos ätäi äiewon, “Akan amiaka kiro enmaksau pakan arou. Akan amiaka eposek rawai kiro akan enmaksau arou senek jere rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Utianik, nan amunauk aru saräi, nan won uru nais erekapu pututu saräi. Keseria, nan won uru merek wäpik kiro pututu rau, kiro epar pututu näwäu senes!” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Kos ätäi äiewon, “Sarau ro kararas ko ro oirori opok sarau mau senek wa. Owon, ko karan wous meieanik, kar ron wous wa meiäi. Ko kar ron ämän jekur tainorianik, sarau eposek momoi, kar ro sumkäineanik, kon ämän jekur wa tainoriäu. Ak Anut nukan sarau pak aiaukun sarau pak erek turur mau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jisas nukas ätäi awarowon, “Keserianik, is ak epar senes awarom. Ak awau rawaun ronkat sosop oianik, wa keser äiäu, ‘Ik owo o pak an pak jemoi, rawau?’ ‘Ik owo omjo takäu?’ keser wa äiäu. Totomaka kiro näwäu senes, o näwäu wäpik. Akan enmaksau näwäu senes, omjo kiro näwäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ak ai raut apwarwe! Ak o uku wa weäi, ak o arianik, pote owa wa turur miäi. Akan momonaka Anut nukas ai raut o ariäu. Akas Anut nukan amuk opok ai raut erekapu itimware rai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Inok ro ak kamuk opok kon ronkat sosopus okoro omnokou opok omre rumuk rawaun itok? Ko keserau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ak owon omjon ronkat sosop ourai? Ak kurukan am musip aparwe. Ak sarau wa miäi, omjo nais akasar wa ate miäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Utianik, is ak epar senes awarom, meter kamwareäwon ro Solomon ko kon omjo eposek miäwon, kiro omjo am musip eposek senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kurukan amurik erar kiro Anut nukas omjo areäu. Kiro amurik rurisa rawai, kiro ariwa epis erekapu jerai. Kiro amurik erar raiäi kiro Anut nukas omjo areäu. Akan woiaka epar moin kiro eteinak! Ak äpu mowe, Anut nukas ak nais kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Keseria, ak ronkat sosop mianik, keser wa äiäu, ‘Isan o eras kowai? An eras kowai? Isan omjo eras kowai?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Kiro Anut nukan ämän wa roiäi roat akas, ak okoro omnokou pakan osap owaun ronkateäi. Utianik, akan momonaka omar oik rau ko äpu mowon, kiro osap sarau orip, okon, kos ak arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ak Anut nukan mena tonaun amke ronkateanik, kon onok eposek tainoraiei, kos ätäi kiro osap erekapu ak arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Keseria, ak ariwan ronkat rusapai wa owau. Rusapaian usu kiro kon atap. Ariwa nais usu orip. Ak rusapaian usu karar ronkatewe.” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisas nukas ätäiar awarowon, “Ak karauk roat akan onok wa wasare marau. Ak keserna, Anut nukas nais akan onok wa wasare marai. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ak karauk roasiret akan owo ämän wasare maraiei, Anut nukas nais kesekur akan ämän wasare marai. Ak karauk roat opok owo onok miäi senek, Anut nukas ak opok nais keseriar keserai. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Na owon nan jaunan amuk opok us eteinak oi kuräun aparum? Nakan amun opok am sawau rau na aparau senek wa ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nakan amunauk opok am sawau näwäu raunuk, na owose nan jaunan amuk opok us oi kuräun aurum, ‘Jai, is nan amun opok us oi kuräm.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Na sätwareäum ro, amke am sawau näwäu nakan amun opok rau oi kureinam, ätäi eposek apu aparianik, epar jaunan us amuk opok rau oi kuräm. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ak owo osap Anut nuraun sare moin kiro en oraut wa arau. Ak karoroi eposek eposek po nepukup wa känkuräu. En po ories kiro osap jau senek wa. Keseria, akas ätäi piririanik, akan isorakas kiro osap tai kunorianik, ätäi aka tukwaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisas nukas ätäi äiewon, “Ak owo osap owaun Anut aurna, kos osap arai. Ak owo osap itanäiei, ak aparaiei. Ak im ut koukouraiei, Anut nukas imtue marai. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Inok roasir ko osap owaun Anut aurai, ko osap owai. Inok roasir osap itanäi, ko aparai. Inok roasir ko Anut nukan im ut koukourai, Anut nukas ko im tue murunuk, owa tonai. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Utianik, kar ron mokois momok aurai, ‘Moni, is ma jam,’ aurnuk, momokus aiauk omnokou pakan oi nuriäu ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Utianik, kon mokois, ‘Moni, is was jam,’ aurnuk, momokus kar män aru oi nuriäu ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Is ak epar senes awarom, roat onok aru miäi akas akan mokoit owo osap eposek araun äpu miäi, keseriar akan Momonaka omar oik rau aurna, kos ak osap eposek senes arai. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kiro ämän Moses nukan sintore ämän pak Anut nukan ämän roianik, areain roat akan ämän pak akan onoktapau, owon kiro owo onok eposek roasiret akas ak opok keseraun keserna, ak nais kiro onok karar ak opok keserwe.” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Kos ätäi äiewon, “Ak ororok eteinak tonowe. Ep unik naun apu näwäu apsasawo roasiret sosop ak kiro apu opok säpkäri tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Utianik, kiro awau rawaun ororok eteinak. Kiro roasiret sosop tonaun senek itok wa. Roasir karar karar ak kiro ororok apariäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisas nukas roasiret keser awarowon, “Ak sät ämän roianik, ariäi roat jekur apwarwe. Kiro roat apwareanik, akas ak sipsip senek ronkateäi, utianik, ak epar kurukan en sei senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kiro sät roat akan onok owoseäi pakaima ak epar äpu maiei. Roat wain nemauk mur katuau pakan oiäi ra? Roat ak uran nemauk isiäu amurik pakan oiäi ra? Wa senes, wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Keseriar, owo am eposek ko nemauk eposek muriäu. Owo am aru ko nemauk aru muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Am eposek ko nemauk aru wa muriäu. Am aru ko nemauk näu wa muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Kiro am erekapu nemauk näu wa muriäi, kiro erekapu toreanik, ep uru amke kuräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kesek, okon, kiro sät ämän areäin roat akan onok owoseäi pakaima ak äpu maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jisas nukas ätäi awarowon, “Roasiret erekapu isan enim atomoi, äiäi, ‘Näwäu, Näwäu,’ kiro roasiret Anut nukan kameäu mena wa tonaiei. Utianik, inok ro isan moni omar oik rau kon ämän tainoriäu ro karar ko epar tonai. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Tawa wasarewaraun omre päi opok, roasiret sosop akas pemana, keser airaiei, ‘Näwäu, Näwäu, ik nan enmat pakaimas ik Anut nukan ämän oumoi, karauk roasiret pote ätär mareäumun, ik nan enmat pakaimas karauk roat ak osou aru orip raiäi jekwareäumun, nan enmat pakaimas ik kurur atap atap miäumun.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kiro ses opok is ak keser awaram, ‘Ak onok aru miäi roasiret, ak eurwe! Is ak äpu wa.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Kos ätäi äiewon, “Keseria, inok ro ko isan ämän roianik, tainoriäu ro, ko ro ronkat eposek orip. Kon ou aiauk sosop sakau opok miäu senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Om nonuk, joi näwäu nea, urir näwäu peanik, kiro ou suworwon, sinuk, sorokäiäu wa, owon, ou tutu aiauk sakau opok mowon, okon, ou sakau senes rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Utianik, inok ro ko isan ämän roumara, tainorau wa, ko karauk otop roat ronkat wäpik senek, kon ou usnokou opok mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Om nonuk, joi näwäu nea, urir näwäu peanik, kiro ou usnokou opok mowon erekapu suornuk, sorokäieanik, erekapu aru mowon.” ");
INSERT INTO bbr2013_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisas nukas kon ämän erekapu roasiret mare kurenuk, ak kon ämän atap tamarowon roianik, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Kon ämän sintore ämän tamareäi roat akan ämän senek wa. Ko kar ro enip orip senekus ämän awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisas ko omtapau oikas ute nonuk, roasiret sosop ko tainor potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kar ro sip aru repros orip kos Jisas siakup koianik, uou sur wemara, auruwon, “Näwäu, na, isan ui aru jäkäi muraun itok, utianik, nan ronkat pakas keser. Na is rapoire murota, is eposek saräm.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisas kon ipous kiro ro atomara, auruwon, “Isas aisom. Na eposek saräm.” Kiro ses opokar, Jisas nukas kiro ro repros orip jekur mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Keseria, Jisas nukas auruwon, “Is okoro onok keserim na pote karauk roasiret wa awarau. Utianik, na Anut kamuk raiäu ro* siakup potea, nan enmat näu sarewon ätär muruta, apaisai. Apaisonuk, na Moses nukan sintore ämän tainornam, opur oianik, Anut jou muruta, kiro epar roasiret erekapu äpu maiei, na ätäi eposek saremon.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Kiro ses opok, Jisas ko Kapaneam mena potonuk, Rom marai roat akan ro näwäu nukas pemara, kon sarau ro jekuraun rai Jisas auruwon, ");
INSERT INTO bbr2013_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Näwäu, isan sarau ro ko sip näwäu oianik, ko tätäi näwäu orip ariäu senek wa, ko owa patan opok nini rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jisas nukas ätäi auruwon, “Is potoita, kiro ro jekur mam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kiro marai roat akan ro näwäu nukas ätäi Jisas auruwon, “Näwäu, is onok aru miäim ro, okon, na isan owa wa potau. Utianik, na onsaus karar äieta, isan sarau ro ko eposek saräi. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Is nais roat näunäu akan inkaruru raiäim. Karauk marai roat ak isan inkaruru raiäi. Isan kar marai ro auriäim, ‘Na okoro opok koi,’ aurita, koiäu. Kar auriaim, ‘Na enro opok pot,’ aurita, poteäu. Isan sarau ro ko ‘Na okoro sarau mo,’ aurita, sarau miäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisas ko kiro marai roat akan ro näwäu nukan ämän roianik, ko karkairianik, roasiret ko tainori potoin keser awarowon, “Is epar senes awarom, is kar Israel ro okoro ro senek kon wou epar mowon wa aparmin. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Is ak epar senes awarom, roasiret san peäwon pakan pak san neäwon pakan pak koianik, Abraham, Aisak, Jekop pak koi Anut nukan kamwareäwon mena tururmoi, Anut nuka pak taneanik, erek o je rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Utianik, karauk roat ak Anut nukan amukup ämän orip rain ak oi kurwarnuk, pututu rawaiei, kiro roasiret ak akan aiakpanak kartitirianik, wai rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Keseria, Jisas nukas marai roat akan ro näwäu auruwon, “Na nan mena man! Is nan won epar momon apaisom. Kiro epar päi.” Kiro ses opokar, marai roat akan ro näwäu nukan sarau ro eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jisas ko Pita nukan owa toneanik, ko Pita nukan tanau asir sip enip sopou orip patan opok nini rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jisas nukas kiro asiren ipou atonuk, sip kiro asir opok rawon ute manowon. Kiro asir ko siräianik, Jisas nukan o jekur muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Iukärir sarenuk, karauk roasiret akas roasiret sosop osou aru akan woiaka uru rain Jisas rawa imware koin. Jisas nukas kiro roasiret osou aru orip oksaus äienuk, kiro osou aru kiro roasiret pakan utware manoin. Jisas nukas nais karauk roasiret sip orip jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ko kiro kesernuk, ak kiro ämän Anut nukan ämän roianik, areawon ro, Aisaia nukas arewon, ‘Kiro ro nukasar iken sip pak osou aru pak jäkäi mukianik, oi manowon.’ Kiro epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Roat sosop ak Jisas siakup tururmoi, karirim kator rauna, kos apwareanik, kon tamareäu roat Galili An Unik karaima potaun rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Kar sintore ämän tamareäu ros Jisas siakup koumara, Jisas auruwon, “Tamareäum ro, na erapok manam is na orip orip tainoise manam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisas nukas ätäi auruwon, “Kurukan opur sei raut ak ninaun ou orip, ai raut ak ninaun tou orip, utianik, Ro Nukan Mokoi ko ninaun omoi wäpik.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Jisas nukan tamareäu ro karas Jisas auruwon, “Näwäu, amke na is utoirota, pote isan moni up kureita, ätäi koi, na tainoise manam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jisas nukas ätäi auruwon, “Na is tainoir. Meiein roat akasar akan jaunakat meiein up kurwaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisas ko kon tamareäu roat pak ous opok erek toneanik, manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Urir näwäu peanik, an ekur pakurnuk, ous mas an unik uru naurwon. Utianik, Jisas ko ekep ninowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kon tamareäu roat akas poteanik, ko turarianik, aurin, “Näwäu, na ik sareik. Ik anas oike jauru!” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisas nukas ätäi awarowon. “Owon ak iminerai? Akan woiaka epar mowon kiro eteinak!” Keseria, ko siräianik, urir pak mas an pak kewatonuk, utoirin. Kiro mas an kon rawon siar päurar rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Kesernuk, roat erekapu ronkat sosop oianik, aka aka äiein, “Okoro ko owo ro rä? Urir mas an ori kon ämän tainorir!” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kiro ses opok Jisas ko Gadara roasiret akan omnokou opok, an unik karaima kasakup potowon. Kiro mena roat meiäi up kurwareäi omoi pakas kar ro oirori kiro up uru rairinus, peanik, Jisas apu opok tararirin. Kiro roat ori au osou aru orip otop sareirin. Roasiret erekapu ak kiro otop roat ori iminewateanik, kiro apu pakas wa poteäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kiro roat ories Jisas sakau urweanik, keser auririn, “Na Anut nukan Mokoi, na iu owoseitaun koum? Na iu usu itaun koum ra? Iken wasareikaun ses rusa wa, tawa kowai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kiro roat ori raiäirin opok, poat sosop ak kiro opok atapukar senek o je rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Keseria, kiro osou aru akas Jisas sakau ämän aurin, “Na ik äsimoikaurumata, ik enro po raut rai akan woiaka uru äsimoikota, nam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisas nukas osou aru awarowon, “Ak manowe!” Keseria, kiro osou aru ak po raut akan woiaka uru ute tonoin. Kiro po raut ak kurte iminemoi, om aru opokas pote an unik uru nopteanik, an jemana, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Po kamwareäin roat ak kiro onok aparianik, kurte akan näu mena imine poteanik, kiro roat ori osou aru orip owoseirin ämän erekapu karauk roasiret awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Keseria, kiro menan roasiret erekapu Jisas aparaun potoin, ak pote ko aparianik, akan omnokou utomoi, kar mena manaun rai sakau ämän aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jisas ko ätäi ous opok toneanik, Galili An Unik kureanik, kon mena Kapaneam potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Karauk roat akas kar sip ro kon isou ipou tipinewon orip patan opok mianik, Jisas rawa imäi koin. Kiro roat akan woiaka Jisas mesin epar moin apwareanik, kiro ro isou ipou tipinewon orip auruwon, “Mokoi, nan won päurar rawai, is nan onok aru jäkäi musom.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Keser aurnuk, karauk sintore ämän tamareäi roat akas akan woiaka uruas aka aka keser ronkatein, “Kiro ro ko Anut jeje ämän auru.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jisas ko kiro roat akan ronkat äpu momara, awarowon, “Ak owon akan woiaka uruas kiro ronkat aru ourai? ");
INSERT INTO bbr2013_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Is owo ämän äiäun itok, owo ämän äiäun itok wa? ‘Nan onok aru jäkäi musom,’ is keser äiem ra, ‘Na siräinam, manam,’ is keser äiem ra? Is owo ämän äiem, ak akan woiaka is mesin epar maiei? ");
INSERT INTO bbr2013_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Utianik, ak Ro Nukan Mokoi ko enip orip, ko okoro omnokou pakan onok aru jäkäi maun itok äpu maun is keseram.” Keseria, kos kiro sip ro auruwon, “Na siräinam, nan mat oinam, nan mena man!” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kesernuk, kiro ro siräianik, kon mena manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Roasiret ak kiro onok aparianik, ak Anut nukan enip jou moin. Owon, kos Jisas sakau nurunuk, kos roat siräi mareäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisas ko Kapaneam mena utomara, apu opok pote, kar ro kon enip Matiu ko takis aiauk oiäwon ro kon sarau miäwon owa tane rawon aparwon. Ko Matiu keser auruwon, “Na koi, is tainoir.” Keser aurnuk, Matiu ko siräianik, Jisas tainori manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisas ko Matiu nukan owa o jenuk jenuk, karauk takis aiauk oiäin roat pak, onok aru miäin roat pak peanik, Jisas kon tamareäu roat pak tane raiäin patan opok pe erek tane o jein. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Karauk Parisi roat akas kiro roat apwareanik, Jisas nukan tamareäu roat totwaroin, “Akan tamareäwon ro ko owon kiro takis oiäi roat pak onok aru miäi roat pak erek o jera?” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisas ko kiro ämän roianik, awarowon, “Roasiret sip wäpik ak dokta siakup wa poteäi, roasiret sip orip karar epar ak dokta siakup potaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ak kiro ämän Anut nukas äiewon ak pote onoktapau itanenai, äpu maiei. ‘Opur amkeanik, is iraiei kiro is woi eräu utou.’ Ak kiro onok wa keserau, ak karauk roat akanun woiakati mianik, sarwaraiei kiro isan woi ereai. Is roasiret onok eposek miäi urwaraun kowau wa. Is roasiret onok aru miäi urwaraun koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Kiro ses opok Jon, an jomareäwon ro nukan tamareäu roat akas Jisas siakup pemana, keser totorin, “Ik Parisi roat pak karauk omre opok o utiäum. Nan tamareäum roat owon ak o wa utiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisas nukas ätäi awarowon, “Kar ro ko asir awau owaurnuk, kon jaukut pak raunuk, akan woiaka aru miäi ra? Wa! Karauk roat akas kiro ro asir owon imäi manona, ko ak pak rawau wa, kiro ses opok, ak woiaka aru mianik, o utaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Kar ros kon omjo kiräiwon, omjo si awau oianik, omjo mustäi opok wa näke mai. Kiro omjo an kosoriäu ses opok, omjo awau eteinak sareanik, kon omjo ätäi kiräimara, amarer näwäu saräi. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Kar ros wain an awau meme kerau mustäi opok wa äräine miäu. Ko kesernuk rai, kiro wain an awau sipar kurarianik, meteran meme kerau kiräianik, wain an omnokou opok kour nai. Kiro meme kerau nais erek jäkäiai. Wain an awau ko meme kerau awau opok äräine mota, au eposek rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisas ko roasiret kiro ämän maronuk maronuk, kar Juda ro näwäu kos Jisas siakup pe uou sur weanik, auruwon, “Isan asinak rusapai meiewon, utianik, na potea, nan ipon ko opok mota, ko ätäi siräiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Keser aurnuk, Jisas ko siräianik, kiro ro tainori potowon. Kon tamareäu roat nais ak erek potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kar asir ko keir sip orip orip oiäu, kiro sip nukan woisan 12 orip rawon. Jisas ko manonuk manonuk, ko Jisas mekesup pemara, Jisas nukan omjo peteu atowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Kiro asir kon wou uruas ronkatewon, ‘Is kon omjo karar atoita, is ätäi eposek saräm.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jisas ko ätäi pirirmara, kiro asir aparwon, kos keser äiewon, “Asinak, nan won päurar rawai. Na is mesin won epar momon, okon, na eposek saräm.” Kiro ses opokar kiro asir ätäi eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Keseria, Jisas ko ro näwäu nukan owa potowon. Roasiret ak kar asinak meienuk, karauk roat ak paraur we rain, karauk roasiret akas waiauk kure rain apwarwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Kos awarowon, “Ak roasiret erekapu kasik nowe! Kiro asinak ko meiäu wa, ko erar nini rau!” Jisas nukas keser äienuk, roasiret akas ko apari ioin. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Roasiret ak erekapu kasik ute nona, Jisas ko kiro asinakun ou waru uru tonomara, kon ipou oirori atonuk, kiro asinak ätäi siräiwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ko kiro onok keserwon ämän kiro omsau erekapu manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisas ko kiro mena utomara, apu opok potonuk potonuk, ro amiawa utup oirories ko tainori pote rai, sakau urweirin. “Devit nukan Mokoi, na iwenun wonti mutoinam, na iu sareit.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisas ko kar owa tononuk, kiro ro ories ko siakup tonosa, kos au totwatowon, “Awan woiawa is au sarwataun mesin epar moir ra?” Ories ätäi keser äieirin, “Näwäu, io, na itok, keseitam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Jisas nukas awan amiawa ateanik, äiewon, “Awan woiaka is mesin epar moirin, okon, awan amiawa uräiäi!” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jisas nukas keser äienuk, kiro roat orien amiawa orärewon. Jisas nukas ätäi keser sakau ämän awatowon, “Au pote, roasiret wa awarau!” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Utianik, kiro roat ori au kasik neanik, Jisas nukas jekwatowon kiro omsau erekapu ämän areirin. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jisas kon tamareäu roat pak manaurna, karauk roasiret akas kar ro ok utup osou aru orip Jisas rawa imäi koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Keserna, Jisas nukas kiro osou aru ok utup ro pak raiäwon oi kurewon. Kesernuk, kiro ro arewon, roasiret ak ronkat sosop oianik, keser äiein, “Ik kiro onok meter Israel roasiret kamuk opok aparau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Utianik, Parisi roat akas keser arein, “Ko kiro osou aru akan näwäus ko sakau nurunuk, ko osou aru oi kurwareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisas ko näu mena pak eteinak mena pak erekapu poteanik, ko akan tururiäi owa roasiret ämän marowon. Anut nukas roasiret kamwaraun kowai Ämän Eposek sakau marowon. Ko roasiret sip atap atap orip sarwareäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ko roasiret sosop koi tururna, apwareanik, wouti mowon, owon, ak kar ros wa sarwareäu, ak akan ronkat atap atap rain kiro onok ak sipsip kamwaraun roat wäpik senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Keseria, Jisas nukas kon tamareäu roat keser awarowon, “Kiro woia o sosop itok sare rau, kiro woia o ariaun sarau roat sosop wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ak kiro woi atak ro ko aurna, kos karauk sarau roat äsimwaronuk, akas pote kiro o turur maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisas nukas kon tamareäu roat 12 orip urwaronuk, kouna, osou aru oi kuräun pak, roasiret sip atap atap orip jekwaraun pak sakau arowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","4","Okoro Jisas nukan tamareäu roat 12 orip, ak Anut nukan ämän oi ariain roat* akan enmaka kesek: Saimon kon kar enip Pita, kon amakun enip Andru, Jems kon amak Jon ori, au Sebedi nukan mokoit ori. Filip, Bartolomiu, Tomas, Matiu ko takis oiäwon ro, Jems ko Alfius nukan mokoi, Tadias, kar Saimon ko kar tupsiu enip Serot pakan, Judas Iskariot kos Jisas kon iwäi jaukut ipiakap marowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisas nukas kiro roat 12 orip äsimwareanik, awarowon, “Ak karauk omsau pakan roasiret akan omsau pak, ak Samaria akan karauk näu mena wa potau. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Utianik, ak Israel roasiret sipsip senek ämäi räi opok potowe. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ak potea, keser awaraiei, ‘Anut nukas roasiret kamwaraun omre siarakap pe rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ak pote keseraiei, roasiret sip orip jekware maiei, meiein roasiret ätäi siräiware maiei, roasiret sip repros orip jekware maiei pak osou aru roasiret opok rai oi kuräiei. Ak kiro sarau maiei, keser ronkateanik, äiewe, ‘Ik kiro sakau erar oumun, keseria, ikes karauk roat akas ik aiauk ikaun wa awaram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ak karauk aiauk akan jo päisau uru joke maiei, wa oi manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ak apu opok manauria, kar ros kon jo ra, omjo ra, su ra, kar naruauk ra wa oi manaiei. Sarau miäu ro kos kiro osap epar oiäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Utianik, ak kar näu mena ra eteinak mena toneanik rai, ak roasiret akan onok jekur apwaraiei, owo ro kon onok eposek ra, owo ro kon onok aru ra, ak kiro roat eposek pak jekur rawaieis, ätäi kiro mena utware manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ak kiro roat akan owa tonea rai, ak keser äiäiei, ‘Iken woiok ak pak eposek rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kiro owan ros ak imwareanik, eposek kamwaronuk, akan jekur rawaun ämän kiro ro pak rawai. Utianik, inok ro ko ak kon owa wa imware tononuk, akan jekur rawaun ämän ko pak wa rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Karauk roat akas akan ämän rowau utomoi, jekur wa kamwarona rai, ak kiro mena utoinai, akan onok aru ätär maraun akan isorak pakan maimai putarwe. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Is ak epar senes awarom, wasarewaraun ses opok Sodom Gomora roasiret usu äiäknak owaiei, utianik, kiro menan roasiret ak usu näwäu senes owaiei.” Jisas nukas nukan ämän oi ariain roat keser awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisas nukas ätäiar keser awarowon, “Ak rowe, is ak sipsip senek en sei raut rai kamuk opok äsimwaroita, pote rawaiei. Keseria, ak män senek päurar pote rai apu jekur aparaiei, ak ai manap akan onok tainorna, ak päurar rawe. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ak karauk roat jekuriar apwarwe. Karauk roat akas ak sakatwareanik, wasarewaraun ro siakup imware potaiei. Ak sakatwaromoi, akan tururiäi owa atap atap imware potea, mänkäsiwaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ak isan enim pakas sarau mona, apwareanik, karauk roat akas karapus owa kurwaraun akan kamwareäin roat näunäu opok imware potaiei. Keserna, kiro ses opok akas ak pak karauk omsau pakan roat pak, isan ämän awaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Karauk roat akas ak karapus owa kurwaraun imware potona, ak imineanik, ‘Ik owose aräu’, ‘Ik owo ämän ätäi awarau’, keser ronkateanik, ak woiaka aru wa mau. Kiro ses opok, ak Anut nukas ronkat aronuk, ak aräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ak kiro ämän akan oiaksaus akasar wa aräi. Akan momonakan Osou Näu nukasar ronkat aronuk, ak aräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Karauk roat akasar akan aunakat pak amunakat pak, akan iwäinakat akan ipiakap marona, kiro iwäinakat akas akwarona, meiäiei. Momonakat akas akan mokoit keseriar kesewarona, akwaraiei, keserna, mokoit akas nais ätäi piririanik, akan momonakat keseriar kesewaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Utianik, ak isan sarau muriäin, okon, roat akas akanun kasiak peanik, sauk maraiei. Inok ro ko isan sarau wa utai, ko orip orip sakau me rawai, tawa wasarewaraun ses opok, Anut nukas ko ätäi imäiai. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Utianik, ak kiro näu menan roat akas ak opok onok aru marona rai, ak ätäi kar näu mena imine manaiei. Is ak epar senes awarom ak Israel akan mena näunäu sarau erekapu patarau wa opok Ro Nukan Mokoi ätäi kowai. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Kar skul mokois kon tamuriäwon ro itimorau senek wa, kar sarau ros kon kameäu ro itimorau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Keseria, kiro mokoi kon ronkat kon tamuriäwon ro senek sareanik, kiro epar kon wou näu saräi. Sarau ro nais keseriar, ko kon kameäwon ro senek sareanik, kon wou näu sarai. Karauk roat akas is akan kamwareäu ro Bielsebul nukan enip is opok muraiei, akas ak isan tamareäimin roat opok enmak aru senes maraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Jisas nukas ätäiar awarowon, “Keseria, ak karauk roat wa iminewarau. Owo osap rusapai oturu ämäi rau, kiro amop päi. Owo ämän ämäi rau, roat ak kiro äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Isan ämän umtutu awaroram akas pak sanpeu aräiei. Is ak owo ämän akararnak äiäurar awaromin, akas pak roasiret amiakap siräia, tai raianik, ämän amop awaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ak karauk roat akas roat akwariain meiäi, kiro roat ak wa iminewarau, akas ak akwarianik, akan totomaka aru marau senek itok wa. Ak Anut karar iminäiei, kos epar akan enmaksau pak totomaka orip erekapu ep näwäu uru kurwaraun itok. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Na aiauk eteinak wan toia senekus ainak simnak oiroror kau miäum. Kar ainak nan momonas utom äienuk, kiro ainak omnokou opok wa utonuk, nai. Anut nukas ai raut eposek kamwareäu, okon, kos ak nais eposek kamwarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Kos akan tapiaka urik karar karar kiro erekapu ninarewon rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Keseria, ak wa iminäu, Anut nukan amuk opok ak roat eposek, akas ai raut itimware rai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisas nukas ätäiar äiewon, “Inok ros ko roasiret amiakap ‘Is kon jauk’ äiäi, isas nais isan moni omar oik rau kon amukup kiro ro ‘Ko isan jai’ äiäm. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Utianik, inok ros ko ‘Is kon jauk’ roasiret amiakap wa äienuk rai, isas nais isan Moni omar oik rau kon amukup kiro ro ‘Ko isan jai’ wa äiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jisas nukas ätäi awarowon, “Ak keser wa ronkatewe, ko okoro omsau opok roasiret tamurai rawaun kou rai wa äiäu. Is ak pak tamuräi rawaun kowau wa, utianik, ak pak weräiäun is marai oi koimin. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Is mokoit akan woiaka pirwaroita, akan momonakat pak iwäi muratäiei. Asinakut akan aninakat pak iwäi muratäiei. Asiret nais akan pusirakat pak iwäi muratäiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Roasiret ak tupsiu karar ätäi aka aka iwäi saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Inok mokoi ko kon momok, anakun wous meieanik, ko isanun wous meiäu wa, ko isan tamareäim ro wa rawai. Inok ro ko kon mokoi, asinakun wous meieanik, ko isanun wous meiäu wa, ko isan tamareäim ro wa rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Inok ro ko kon am äpäs ämäianik, is tainoirau wa, kiro ro ko isan tamareäim ro wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Utianik, inok ro nukasar kon totok awau rawaun sarau mai, kiro ro kon totok aru mai. Utianik, inok ro ko isanun ronkatemara, kon enipsau utiäu, kiro ro kon totok awau orip orip rawai. Ko wa meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Kos keser awarowon, “Inok ros ak imwareanik, jekur kamwareäu, kiro ros is pakur erek imäiriäu. Inok ros is imäiriäu, kiro ro ko Anut pakur erek imäiäu. Kiro keseraun Anut nukas is äsimoirnuk, koimin. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Inok ro ko kar ro Anut nukan ämän roianik, areawon ro äpu mianik, ko kiro ro imäiäu, tawa omar oik ko osap kiro ämän roianik, areawon ro owon senek owai. Inok ro ko kar ro tuku ariäu äpu mianik, ko kiro ro imäiäu, tawa ko osap kiro ro tuku owon senek owai. ");
INSERT INTO bbr2013_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Inok ros kar ro enip näwäu wäpik ko isan onok tainoriäu äpu mianik, ko kiro ro an ore nurai, is ak epar senes awarom, kiro ro Anut nukas wa sumkäinai, tawa ko epar omar oik osap eposek owai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisas nukas kon tamareäu roat 12 orip, sarau maun ämän awareanik, ko kiro mena utomara, karauk mena kiro mena siakupaiar pote Anut nukan ämän roasiret marowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","An jomareäwon ro, Jon ko karapus owa raianik, Krais nukas owosewon ko kiro ämän roianik, kon tamareäu roat Jisas siakup äsimwaronuk, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Kos ak Jisas keser totoraun awarowon, “Ik äpu kar ro näwäu kowai äiein. Na kiro ro ra, ara, ik kar ro tawa kowai kumäu ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisas nukas kiro roat ätäi awarowon, “Ak owo ämän roumoi, akan amiakas owo onok apari kiro erekapu, ätäi pote Jon aurwe. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Amiak utup roat ak ätäi amiak uräräumoi, ätäi om apari. Isiaka tipinewon roat ak ätäi apu arirai. Roat sip repros orip ak ätäi eposek sarei. Raiaka utup roat ak ätäi ämän jekur roi. Meiein roat ak ätäi awau siräiein. Saruku roat ak Anut nukan Ämän Eposek roi. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Inok ro ko isanun wou epar mianik, ko sakau tai rawai, kiro ro kon wou näu saräi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jon nukan tamareäu roat ak ute manona, Jisas nukas Jon nukan ämän roasiret turur rain opok awarowon. Ko keser totwarowon, “Ak ro wäpik mena om puru opok Jon siakup owo aparaun potoin? Ak kar pakpak uriris atonuk aparau potoin ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ak owo pote aparin? Ak kar ro omjo eposek mer amke rawon pote aparin ra? Kesek roat ak omjo eposek eposek orip mer amkeanik, ak kamwareäin roat näunäu akan mena eposek opok raiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Utianik, ak owo aparau potoin, is airoie. Ak kar Anut nukan ämän roianik, areawon ro aparaun potoin ra? Kiro epar senes. Is epar awarom, ko Anut nukan ämän roianik, areäu ro. Kos karauk Anut nukan ämän roianik, areäi roat itimware rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Anut nukan ämänis Jon mesin keser äiewon, ‘Anut nukas äiewon, “Rowe, isan ämän oi aräun ro äsimorta, amke koi, nan apu tuku sare musai.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Is ak epar senes awarom, Jon nukas okoro omnokou pakan roasiret erekapu itimware rau. Utianik, inok ro ko Anut nukan amuk opok enip jou wäpik, kos äiäu, ‘Anut isan kamoireäu ro näwäu, is kon inkaruru raim’ kiro ros Jon itimori rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","An jomareäwon ro, Jon nukan ämän areawon ses rurisapai koi utou, karauk roat sakau orip akas Anut akan Näwäu senek ak kamwaraun sakau ataurin. Keseria, ak Anut nukan kamwaraun onok eposek aru murin. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Jon päu wa opok, meter Anut nukan ämän roianik, areain roat pak Moses nukan sintore ämän pak akas Anut ik kamoikaun kowai rai ämän miäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Kiro roat akas keser äiein, ‘Elaija ätäi kowai.’ Ak kiro roat akan ämän roianik, akan woiaka epar moin rai, ak äpu Jon kosar ko Elaija, kowai äiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Roasiret raiaka orik ak kiro ämän rowe! ");
INSERT INTO bbr2013_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Utianik, is rusapaian roasiret ak owo senek awaram? Ak mokoit eteinanak akas om sorik opok tane raumana, karauk mokoit pak sipiräiäun keser urwareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ik asir oiäin parau urumun, utianik, ak karäu wa.’ ‘Ik op meieäin sir wemun, utianik, ak waiäu wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon ko pemara, karauk omre opok ko o pak wain an pak wa jeäwon. Kesernuk, roasiret akas keser äiein, ‘Kiro ro ko osou aru ko opok rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Utianik, Ro Nukan Mokoi kowon, ko o pak wain an pak jenuk, roasiret akas keser äiein, ‘Kiro ro aparwe! Ko o pak wain an sosop jeäu. Ko takis oiäi roat pak onok aru miäin roat pak akan jaunaka!’ Ak keser äiein. Utianik, Anut nukan ronkat eposek ak tawa aparia, äpu maiei kon onok eposek senes.” ");
INSERT INTO bbr2013_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Karauk mena kiro pakan roasiret, ak Jisas nukas kon kurur atap atap ätär marowon. Ak kiro aparianik, akan onok aru utomoi, ak woiaka pirirau wa. Keserna, Jisas nukas kiro menan roasiret kewarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ko äieu, “Korasin roasiret, is ak apware woiti mou. Betsaidar roasiret, ak nais apware woiti mou. Is kiro kurur näwäu atap atap Taia menan roasiret pak Saidon menan roasiret pak ak kiro kurur ätär maromin senek maro, kiro Airen roasiret ak woiaka aru monuk, kurte omjo sirop takeanik, aitap opok tane rawoi. Kiro onok keserin kiro akan onok aru pakan ätäi woiaka piririn! ");
INSERT INTO bbr2013_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Is ak epar senes awarom, tawa Anut nukas ätäi koi roasiret wasarewaraun ses opok Taia pak Saidon roasiret pak ak usu äiäknak owaiei, utianik, rusapaian roasiret ak usu näwäu senes owaiei! ");
INSERT INTO bbr2013_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ak Kapaneam roasiret, ak akasar omar oik tonaiei ra? Epar senes, ak wa tonaiei. Anut nukas ak up uru ep näwäu opok känkurwarai. Okoro kurur ak ätär marom senek Sodom menan roasiret ak nais kesek kurur ätär maromin maro, ak rurisapai rawoi! ");
INSERT INTO bbr2013_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Keserianik, is ak awarom, ak äpu maiei, Anut nuka ätäi koi roasir wasarewaraun ses opok Sodom usu äiäknak owaiei, utianik, rusapaian roasiret usu näwäu senes owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kiro ses opok Jisas nukas äiewon, “Moni, na karar omar pak omnokou pak akan Näwäu, is nan enmat jou mom, owon, na nan onok eposek äpu miäin roasiret pak skul manoin roasiret akan amiakap ämäi maromon. Utianik, na kiro onok eposek äpu wa roasiret erekapu ätär maromon. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Moni kiro onok epar nakasar nan ronkatis kesermon. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Isan Monias osap erekapu isan ipi opok mowon. Kar ros kon Mokoi äpu wa miäu, momok nuka karar äpu. Kar ros kiro mokoin momok äpu mau senek wa, kon mokois karar momok äpu. Kiro mokois roasiret kosar sare mareanik, kon momok ätär maronuk, ak nais ko äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Roasiret, ak sarau sakau momoi, usu näwäu orip orip ämäi ariai, rusapai ak erekapu is siarap kouna, sume rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ak okoro ämän isas ak tamaromin oianik, tainoraiei. Owon, is kasi wa peäu, is roasiret eposek sarwareäim. Keserita, akan woiaka päurar rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ak isan ämän tainornai, kiro usu näwäu wa, ak tainoraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kar Juda akan sumiäi omre opok, Jisas kon tamareäu roat pak ak wit woi kamukas potoin. Kon tamareäu roat ak sou akwaronuk, kiro woian wit nemauk oianik, jein. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Karauk Parisi roat akas kiro onok keserin aparianik, akas Jisas aurin, “Apar! Nan tamareäum roat akas iken sumaun omre opok kiro onok aru keseri. Ak iken sintore ämän espäiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisas nukas ätäi awarowon, “Devit kon roat pak sou akwaronuk, owosein? Ak kiro ämän ninarein ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Devit kon roat pak sou akwaronuk, Anut nukan tup owa toneanik, bret kiro Anut nurin oianik, jein. Ak sintore ämän tainorau wa, kiro bret sepuk roat akas wa jeäi, Anut kamuk raiäin roat karar kiro jaun itok. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ak Moses nukan sintore ämän buk ninarai ra, sumaun omre opok Anut kamuk raiäin roat akas Anut osap nuriäi ou näwäu opok sarau miäi. Kiro roat ak sumaun omre opok sintore ämän jekur wa tainoriäi, utianik, ak Anut nukan amuk opok ämän wäpik. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Is ak epar senes awarom, kar ro okoro rau kos Anut nukan osap nuriäi ou itimori rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Anut nukan ämänis keser äieu, ‘Ak opur amkeanik, is iraiei, kiro is woi ererau utou. Ak kiro onok wa keserau. Karauk roat akanun woiakati mianik, sarwaraiei, kiro epar is woi ereräi.’ Ak kiro ämän onoktapau äpu momana, ak karauk roat onok aru wa miäi akan enmakap keser sätwaromoi, ak onok aru moin rai wa awarau. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ro Nukan Mokoi ko karar sumaun omre kameäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisas kiro mena utomoi, ko Juda akan tururiäi owa tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kiro owa kar ro ko ipou aru orip rawon. Karauk roat akas Jisas kar onok aru monuk, aparaun rai, ko totorin, “Iken sintore ämän tainorianik, ik iken sumaun omre opok roat sip orip jekuraun itok ra, wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisas nukas ätäi keser awarowon, “Kar ron sipsip sumaun omre opok up uru nai, ak owosäiei? Ak kiro sipsip up uruan imäi oi maiei ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ro ko totok orip, ko sipsip itimori rau, okon, iken sintore ämänis io aikowon ik karauk roat sumaun omre opok sarwaram.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Kos kiro ro ipou aru orip auruwon, “Nan ipon kur.” Keser aurnuk, kiro ros kon ipou kurenuk, kar ipou näu rau senek, kon ipou eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Kesernuk, Parisi roat ak ute maneanik Jisas wäun ämän atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisas ko nuka wäun ämän roianik, ko kiro mena ute manowon. Roasiret sosop ko tainori potona, kos sip roasiret erekapu jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jisas nukas kiro roasiret sakau ämän awarowon, “Ak is mesin karauk roasiret wa awaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ko kiro ämän keser awarowon, kiro Anut nukan ämän roianik, areawon ro Aisaia nukas ämän jer wewon kiro ämän rusa epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Anut nukas äiewon, ‘Okoro isan sarau ro, ko isakasar sare momin, konun isan woias meiewon, konun isan woi näu sarewon. Isan Osou Näu ko opok äsimorta, kos ätäi koi karauk omsau pakan roasiret wasarewaram ämän erekapu awarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ko wa kewarai, ko apu opok ämän näwäu wa are ariäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Kos karauk roat sakau wäpik rai sarwarai, karauk roat akas akan jaunakat sakau wäpik sarwareäi kos sarwarai. Kon sarau kiro mowos tawa kon wasarewaraun onok eposekus karauk onok eposek erekapu itimorai. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Omsau erekapu roasiret konun akan woiaka epar mianik, ko kame rawaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kiro ses opok, karauk roat akas kar ro osou aru nukas amuk utup sareanik, ok utupre mowon Jisas siakup imäi koin. Jisas nukas kiro osou aru kiro ro opokan oi kurenuk, kiro ro aremara, ko ätäi amuk amarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Jisas nukas kiro onok keserwon roasiret akas aparianik, karkairmana, ak äiein, “Kiro Devit nukan Mokoi ra, ko wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi roat ak kiro ämän roianik, akas roasiret keser awaroin, “Ko Bielsebul, eitek aru akan kamwareäu ro näwäu, nukas sakau nurunuk, ko osou aru oi kureäu,” keser äiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisas ko akan ronkat äpu momara, keser äiewon, “Kar omsau pakan roasiret ak aka aka weräianik, aka aka inäimoi, ak om rumuk wa rawaiei. Kar menan roasiret ak nais aka aka weräianik, aka aka inäimoi, ak aru maiei. Kar tupsiu nais keseriar keseraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Utianik, kiro osou aru ak Satan nukan mena rai akan jaunakat pak aka aka weräianik, aka aka inäimoi, ak owose rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Akas is mesin keser arein, ‘Ko Bielsebul nukas sakau nurunuk, ko osou aru oi kureäwon.’ Kiro onok keseriäim maro, inokos akan tamareäi roat sakau aronuk, akas osou aru oi kureäi? Akan tamareäi roat akas akan ämän kiro itok wa äiäiei! ");
INSERT INTO bbr2013_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Utianik, is Bielsebul nukas sakau wa iriäu, Anut nukan Osou Näu nukas is sakau ironuk, is osou aru oi kureäimin. Keseria, ak kiro äpu maiei Anut nukan kamwaraun ses ak siarakap rusapai koi rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kar ros kar sakau ron owa kiräi tonea, amke ko kiro ou atak ro ipou isou muris sisikäi mianik, kon owan osap erekapu owai. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Inok roasir isan jai wa, ko isan iwäi jai. Inok roasir is sareirianik, karauk roat is siarap imware kowau wa, ko roasiret emwaronuk, ak mane kureäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Keseria, is ak epar senes awarom, inok ro ko onok aru miäu pak ämän aru areäu, Anut nukas kiro onok aru jäkäi mai, utianik, inok ro ko Anut nukan Osou Näu jeje ämän aurai, Anut nukas kiro ron onok aru wa jäkäi murai. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Inok roasir ko Ro Nukan Mokoi enip opok ämän aru monuk, Anut nukas kiro kon onok aru jäkäi murai, utianik, ko Anut nukan Osou Näu opok ämän aru äiäu, Anut nukas kiro ämän rusapai wa jäkäi murai, tawa nais wa jäkäi murai. Kiro ron onok aru mowon ko ämän orip, ko keseriar orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jisas nukas ätäi awarowon, “Am eposek apariäi, kiro kon nemauk nais eposek. Am aru kiro kon nemauk nais aru. Roat ak am kon nemauk aparianik, ak äpu maiei kiro am näu ra aru ra. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ak roat aru, män raut senek. Akan woiaka uru onok aru ok pe rau? Owoseanik, akan oiaksaus ämän eposek areäi? ");
INSERT INTO bbr2013_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ro eposek ko kon ronkat eposek orip ko ämän eposek kon wou uruas penuk, areäu. Ro aru ko kon ronkat aru orip ko ämän aru miäu. Owo ronkat kon wou uru rau, kiro kon oksau pakas ämän miäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Anut nuka ätäi koi okoro omnokou pakan roasiret wasarewaraun ses opok, ak owo ämän sepuk sepuk ariain, Anut amukup owose ariain ak keseriar aräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Akan owo ämän areain, kiro ämänisar ätäi aka wasarewarai. Ak ämän eposek areain Anut keseriar wasarewareanik, ak roasiret eposek äiäi. Ak ämän aru areain keseriar wasarewareanik, ak roasiret onok aru miäin äiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kiro ses opok karauk sintore ämän tamareäi roat pak karauk Parisi roat pak akas Jisas aurin. “Tamareäumon ro, rusa, nan kar kurur ätär mukota, ik aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisas nukas ätäi awarowon, “Ak rusapaian roasiret, ak onok aru miäin. Ak Anut nukan ämän wa tainoriäi. Akas is kar kurur moita, aparaun rai totoiroi ra? Wa senes wa! Is Anut nukan ämän roianik, areäwon ro Jona nukan kurur karar kiro epar ätär maroita, ak kiro epar aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jona ko omre 3 orip pak pututu 3 orip ko was näwäu nukan wou uru rawon senek, Ro Nukan Mokoi nais keseriar, omre 3 orip pak pututu 3 orip ko up uru rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Tawa, Anut nuka ätäi koi okoro omnokou pakan roasiret wasarewaraun ses opok Niniwa roasiret meiein ätäi siräianik, Anut nukan amuk opok rusapaian roasiret pak erek tai raianik, auraiei, ‘Rusapaian roasiret ak onok aru miäi’. Owon, Niniwa roasiret ak Jona nukas Anut nukan ämän marowon, akan onok aru utomoi, ätäi woiaka piririanik, Anut mesin akan woiaka epar moin. Is ak epar senes awarom, rusa okoro opok kar ro rau ko näwäu, kos Jona itimori rau. Ak kiro ro näwäu nukan ämän rowau utoi. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tawa Anut nuka ätäi koi okoro omnokou pakan roasiret wasarewaraun ses opok, Siba omsau kamwareäwon asir ko meiewon ätäi siräianik, ko Anut nukan amukup tai raianik, aurai, ‘Rusapaian roasiret ak onok aru miäi’. Owon, kiro asik ko apu opok om rumuk koumoi, kamwareäwon ro Solomon nukan ämän rowau kowon. Is ak epar senes awarom, okoro opok kar ro rau, ko näwäu, kos Solomon itimori rau. Ak kiro ro näwäu nukan ämän rawau utoi!” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","44","Jisas nukas ätäi äiewon, “Osou aru ro opiakapan oi kurena, ko potea, ro wäpik mena sume rawaun omoi itanäi. Ko pote sumaun omoi warnuk, kiro osou aru ko ätäi ronkateanik, äiewon, ‘Is ätäi isan mustäi owa potam.’ Keseria, ko ätäi pote kiro ou om kasar jekur moin, erar rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Aparianik, ko pote karauk osou aru 7 orip akan onok aru senes orip imwareanik, ätäi kiro owa erek rawaun koin. Keseria, kiro osou aru rautes kiro ro opok onok aru senes mona, kiro ko kon meter aru rawon senek wa, ko rusa aru senes rau. Kiro onok keseriar rusapaian roasiret opok päi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisas ko roasiret pak owa arenuk arenuk, kon anak amakut pak koin. Ak kasik koi tai raianik, keser arein, “Ik Jisas pak aräun koum.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Keseria, kar ros apwareanik, kos tone Jisas keser auruwon, “Nan anin amunat pak na apaisaun ak koi kasik tai rai, ak na pak aräun rai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisas nukas ätäi kiro ro auruwon, “Isan ani inok? Isan amaiat inokot?” ");
INSERT INTO bbr2013_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Keseria, Jisas nukas kon tamareäu roat ipous ätär mareanik, awarowon, “Apwarwe, roasiret okoro opok rai, kiro isan ani amaiat! ");
INSERT INTO bbr2013_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Inok roasir ko isan Moni omar oik rau kon ronkat tainoriäu, kiro roasir epar ko isan ani, isan äpi, isan amai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jisas ko ninowon ou utomara, pote Galili An Unik kasakup tane raumoi, roasiret Anut nukan ämän maraun keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Roasiret sosop sosop senes koi ko siakup turur surwate rauna, ko kar ous oik tone tane raunuk, roasiret ak an kasakup tai rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ko totok* ämänisar onok sosop awariäwon. Ko keser awarowon, “Kar omre opok kar ro o uku kuräun kon woia potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ko kiro o uku woia kuräun oi potonuk potonuk, karauk o uku apu opok nekure rawon. Kesernuk, ai rautes pe oi jein. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Karauk o uku ai marmar opok nekurein. Omnokou eposek sosop wa, okon, kiro o uku kurte tu peanik, käwäu orip sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Utianik, san sakau peanik, kiro o uku tu pein erekapu rurnein. Akan kinip om wou uru rapor nau wa, okon, erekapu kusakusaianik, uräi kurein. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Karauk o uku amurik katuau sop uru neanik, tu pein. Katuaus oi jenuk, jekur tone murau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Utianik, karauk o uku omnokou eposek opok noin, kiro o uku tu peanik, nau murkurein. Karauk nemauk sosop senes murkurein, karauk nemauk sosop murkurein, karauk nemauk karar karar murkurein.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jisas nukas kiro totok ämän aware kureanik, ko keser äiewon, “Roasiret ak raiaka orip raroi, ak kiro totok ämän roianik, onoktapau äpu maiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jisas nukan tamareäu roat ak ko siakup keresir koianik, totorin. “Owon na totok ämänis roasiret ämän awareäum?” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisas nukas ätäi keser awarowon, “Anut nukas roasiret kamwaraun onok meter ämäi rawon. Rusapai ak isan tamareäim roat, okon, kiro onoktapau ätär marom. Utianik, karauk roasiret ko kiro onoktapau ätär marau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kar ro ko karauk ronkat eposek orip, kiro ro Anut nukas karauk ronkat eposek nais nurai. Kesernuk, ko ronkat eposek senes owai. Utianik, inok ro ko ronkat eposek wäpik, Anut nukas kon ronkat eteinak ate rau kiro erekapu ätäi senri owai. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Is totok ämänis karauk roasiret awareäim, is kiro keserita, ak owo osap akan amiakas apariai, sinuk, ak jekur wa apariai, ak owo ämän akan raiakas roiäi, sinuk, ak jekur wa roianik, onoktapau äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Keseria, Anut nukan ämän roianik, areawon ro Aisaia ko kiro roat akanun areawon, rusapai epar peu. Anut keser äiäu, ‘Ak ämän akan raiakas roiäi, sinuk, ak jekur wa roianik, onoktapau äpu miäi, ak osap amiakas apariäi, sinuk, ak jekur wa apariäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Kiro roasiret ak wa ronkateäi, kiro akan raiaka itur we mianik, amsinemoi raiäin, Ak kiro onok wa keseraiei, akan amiakas owo onok aparaiei, akan raiakas owo ämän rowaiei, akan ronkat eposek penuk, ak kiro onoktapau äpu maiei, ak akan onok aru utomoi, ätäi woiaka pirirna, is akan onok aru jäkäi maram.’ Anut nukas keser äieu. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Rusapai, ak isan ämän tamareäimin roat ak akan woiaka näu saräiei! Akan amiakas osap aparaiei, akan raiakas ämän roiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Is ak epar senes awarom, meter Anut nukan ämän roianik, areain roat pak karauk roat Anut nukan amuk opok eposek raiäi pak, ak kiro osap ak rusapai apari senek aparaun rai keserin, ak aparau wa. Ämän rusapai ak roi senek meteran roat ak rowam rai keserin, ak rowau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Keserianik, Jisas nukas kon ämän tamareäu roat keser awarowon, “Ak kar ros woia o uku kurewon, kiro totok ämän kon onoktapau kesek ak rowe. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Roat sosop ak Anut nukas kon roasiret kamwaraun ämän awaronuk, roiäi, kon onoktapau ak jekur äpu wa, kiro roasiret ak o uku apu opok noin senek. Keserna, Satan ko kurte ak opok peanik, Anut nukas kon ämän akan woiaka uru mowon kurte oikureäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Karauk o uku ai marmar opok neanik, tu pein, kiro kon onok kesek, karauk roasiret ak Anut nukan ämän roianik, oumoi, kurte nepipiriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Utianik, kiro ämän eposek akan woiaka uru orip orip wa raiäu. Keseria, kiro ämän eposek mesin karauk onokun akan woiaka aru monuk, kiro Anut nukan ämän erekapu utiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Karauk roasiret ak o uku amurik katuau sop uru tu pein, kiro kon onok kesek, karauk roasiret ak Anut nukan ämän roiäi, utianik, ak okoro omnokou pakan onok ronkateanik, osap sosopun akan woiakas meieanik, Anut nukan ämän utiäi. Kiro ämän eposek ak oin kiro amurik katuaus o uku oi jeäu senek jekur wa muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Karauk o uku kiro omnokou näu eposek opok neanik, tu pein, kiro kon onok kesek, karauk roasiret ak ämän roianik, akan woiaka uru moin. Ak kiro Anut nukan ämän onoktapau jekur äpu moin, kiro ämän eposek oin o sosop muriäu senek, karauk nemauk sosop senes 100 orip muriäu, karauk nemauk sosop 60 orip muriäu, karauk nemauk karar karar 30 orip muriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisas nukas kar totok ämän kon ämän tamareäu roat keser awarowon, “Anut nukan roasiret kamwaraun onok kesek, kar ros wit uku eposek kon woia wewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kesernuk, kar umtutu roasiret erekapu ninona, kiro ron iwäi jaukus peanik, kon wit uku wewon woia amurik uku aru kureanik, ko ute manowon, ");
INSERT INTO bbr2013_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Rai rai, kiro wit uku tu peanik, amurik aru pak erek tu penuk, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Kiro woi kameäi sarau roat akas woi atak ro siakup poteanik, keser aurin, ‘Näwäu, iken ronkat na o uku eposek nan woia wemon rai äiemun. Kiro amurik aru nan woia owose pe rau?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kos ätäi keser awarowon, ‘Kiro iken iwäi jaunok karas kiro keserwon.’ Kon sarau roat akas ätäi woi atak ro keser aurin, ‘Nan ronkat ik pote kiro amurik aru ure kuräm ra?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kiro ros keser awarowon, ‘Wa, ak amurik aru urearir wit pak uräiei, okon, kiro wa keserau. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ak amurik utona, wit pak erekur rawaurair. Tawa wit näu owaun ses opok ak amke amurik aru oia, sisikäi mianik, makaiei, wit näu karar oianik, isan o miäim owa pote muraiei!’” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisas nukas kon tamareäu roat kar totok ämän keser awarowon, “Anut nukas roasiret kamwareäu onok kesek. Kar ros kar am enip marmar uku eteinak senes oianik, kon woia wewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Kiro marmar uku ko eteinak senes, karauk o uku senek wa, utianik, kiro marmar uku tu peanik, karauk woian o uku erekapu itimwareäu, kiro am näwäu senes saräi. Kiro am mu näwäu sarenuk, ai raut ak koi kiro am iporu opok tou mokuräiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jisas nukas kon tamareäu roat kar totok ämän keser awarowon. “Anut nukas roasiret kamwareäu onok kiro kar marasin enip jis senek. Kar asires kiro jis eteinak oianik, plaua kap 40 orip ore oumara, tururmoi, etwairnuk, kiro plaua noroianik, mup näwäu sareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Kiro ämän sosop Jisas nukas roasiret totok ämän pakas awareäu, ko kar ämän amop äiäu wa, ko totok ämän pakas karar awareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ko kiro totok ämän areäu kiro Anut nukan ämän roianik, areawon ro nukas ämän roasiret awariäwon, kiro ämän rusapai epar peu. Kos keser jer wewon, ‘Is totok ämän pakas roasiret ämän awareäim. Ämän omnokou ate mowon ses opok pote rusapai ämäi rawon is ak awarom.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisas ko roat sosop utwareanik, ko owa tonowon, kon tamareäu roat akas peanik, keser aurin, “Na ik kiro amurik uku aru woia tu pewon nukan totok ämän onoktapau aikam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisas nukas ätäi keser awarowon, “Ro o uku eposek weäwon, kiro Ro Nukan Mokoi. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Woi kiro okoro omnokou, o uku eposek kiro Anut nukas kamwareäu roasiret, amurik aru kiro ak Satan nukan roasiret. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Amurik uku aru woia kurewon ro, kiro iken iwäinok, Satan. Woian o uku owaun ses iken Anut nuka ätäi koi roasiret wasarewarai, o owaun roat kiro Anut nukan sarau eitek. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Keseria, amurik aru sisikäianik, ep opok makaiei, tawa Anut nukas wasarewaraun ses opok, okoro omnokou opok keseriar keseraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ro Nukan Mokoi nukas kon sarau eitek äsimwaronuk, koia, akas Anut nukan roasiret kamuk opok karauk roasiret onok aru maun äiein pak, karauk roat erek onok aru miäi pak erekapu oikurwarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kiro roasiret ak ep näwäu jerera, uru känkurwaraiei, ak ep uru ne waianik, akan aiakpanak kartitir rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kiro ses opok, Anut akan momonaka nukas roasiret kamwaraun onok amop penuk, roasiret woiaka epar moin ak san nukan arou senekus merek kurwarai. Roasiret ak raiaka orip, kiro ämän roianik, onoktapau äpu maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisas nukas keser äiewon, “Omnokoukan roasiret ak Anut nukan roasiret saräun kiro kesek, kar ros kon aiauk sosop bokis uru mianik, kon woia ämäi mowon. Kiro ro nuka meienuk, kar ros kiro bokis aiauk orip aparianik, kos pak ätäi ämäi mowon. Ko nepipirmara, kon osap erekapu karauk roat aronuk, kau mona, kos pak kiro aiauk oianik, pote kiro woi kau mowon. Kesermara, kiro aiauk bokis uru rawon, kon sarewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisas nukas ätäi äiewon, “Anut nukas roasiret kamwareäu onok kar kiro kesek. Kar ro ko karoroi eposek eposek aiauk näwäus kau maun itane ari rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ko kar karoroi eposek senes aparianik, ko ätäi pote kon osap erekapu karauk roat aronuk, kau mona, kos pak kiro aiauk oumara, pote kiro karoroi eposek kau mowon. Keseria, kiro karoroi kon senes sarewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisas nukas ätäiar äiewon, “Anut nukas roasiret kamwareäu kon onok kar kiro kesek. Karauk was oiäin roat akas was owaun jo an unik näwäu opok kureanik, was sosop aru pak näu pak sepuk oin. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Was sosopus jo ok penuk, ak kiro jo was orip ate reurna, kasakup kounuk, ak taneanik, was wasarewaroin. Was eposek akan maro opok mokurein, was aru oi käkänkurein. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Kiro totok ämän kon onok kesek, Anut nukas ätäi koi roasiret wasarewaraun ses opok, kon sarau eitek akas Satan nukan roasiret ak Anut nukan roasiret pak erek turur rain pakan wasare imwareanik, ep näwäu orip orip jere raiäu opok pote ep unik uru kurewarna, ak akan aiakpanak kartitirianik, wai rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisas nukas kon tamareäu roat totwarowon, “Ak kiro ämän onoktapau ak äpu ra?” Akas ätäi ko aurin, “Io, ik äpu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Jisas nukas keser awarowon, “Kiro ämän kon onoktapau kesek. Sintore ämän tamareäu ro ko Anut nukan kamwaraun onok äpu momara, ko isan tamareäim ro saräun, ko toneanik, kiro owan osap meteran pak awau pak oi koiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisas ko kiro totok ämän awareanik, kiro mena ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Keseria, ko nukan mus mena ätäi potowon. Ko roasiret akan tururiäi owa tone Anut nukan ämän marowon. Roasiret akas kon ämän roianik, karkairin. Keseria, akas keser äiein, “Kiro ro ronkat eposek pak karauk onok erapakan owon? ");
INSERT INTO bbr2013_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ko kurur atap atap maun sakau erapakan owon? Ko ou miäwon ro nukan mokoi wa ra? Maria kiro kon anak ra? Jems, Josep, Saimon, Judas kiro kon awakut ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kon äpiaukut okoro opok rai ra? Ko kiro onok erapakan owon?” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ak keser areanik, Jisas sumkäinein. Keserna, Jisas nukas keser awarowon, “Karauk mena Anut nukan ämän roianik, areawon ro, ko enip jou orip, roasiret akas akan woiakas konun epar miäi, utianik, nukan mena enip jou wäpik, okon, kon roasiret pak kon tupsiu pak akas ko sumkäinein.” ");
INSERT INTO bbr2013_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kiro pakan roasiret akan woiaka epar mau wa, okon, ko kiro mena karauk kurur sosop ätär marau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","12","Kiro ses opok, Herot ko Galili provins kameäwon ro näwäu king. Meter Herot nukas kon amak Filip nukan wau Herodias senri owon. Kesernuk, an jomareäwon ro, Jon nukas Herot keser auruwon, “Na nan amunan asir Herodias oumon. Kiro na sintore ämän espäumon!” Jon nukas keser aurnuk, Herot ko Jon wäun ronkatewon, utianik, ko Juda roasiret akas Jon Anut nukan ämän roianik, areawon ro äiäin. Keseria, Herot ko ak rauna, apwareanik, iminewarowon. Iminemara, ko karauk roat awaronuk, poteanik, Jon sakateanik, ipou muris sisikäimana, karapus owa kurein. Herot nukan anakus an jowon omre tararmana, roasiret sosop tururmoi, kiro omre jou me rain. Kiro omre opok, Herodias nukan asinak ko roasiret amiakap pe kare rawon. Kesernuk, Herot ko kiro asinak makun aparianik, kon wou näu sarewon. Ko kiro asinak makun pak paip mia, kos keser auruwon, “Is epar senes aisom, na owo osap owaun is airota, isas na erekapu isam.” Kiro asinakus kon anak totormara, ko anakun ronkat oianik, ätäi koi Herot keser auruwon, “Na an jomareäwon ro, Jon nukan pou patirnam, kon tapau wou kar maro opok mia, oi koi iram.” Kiro asinak nukas Herot keser aurnuk, ko roianik, ko wou usu sarewon. Utianik, roasiret ko pak tane o je rain akan amiakap kiro asinak pak paip momara, epar äiewon ämän ronkatemara, ko utau senek wa. Keseria, ko kiro asinakun ämän tainoria, kon sarau ro auruwon, “Na pote, Jon nukan pou patir.” Kon sarau ro kar keser aurnuk, ko pote Jon karapus owa rawon pakan pou patirwon. Jon nukan tapau wou kar maro opok mianik, oi koumoi, kiro asinak nurunuk, kos pak oi pote kon anak nuruwon. Jon kon tamareäwon roat akas kon enipsau karar oianik, pote up kurein. Rai rai, Herot nukas Jisas nukan sarau mowon ämän roumara, kos kon sarau roat keser awarowon, “Kiro an jomareäwon ro, Jon ko meiewon ätäi up uruas ätäi siräi pewon, okon, ko kiro kurur atap atap maun sakau orip.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisas ko Jon meiewon ämän roianik, ko ous oumara, kiro mena utomoi, nukarar ro wäpik mena om puru opok manowon. Kesernuk, roasiret ak Jisas manowon ämän roianik, akan mena utomoi, apu pakas ak ko tainori potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisas ko kasakup pote sumomara, ous opokas neanik, roasiret sosop rain apwareanik, ko akanun wouti momara, karauk roasiret sip orip jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jisas nukan tamareäu roat akas iukärir o jaun ses opok ko pe keser aurin, “Om iru okoro ro wäpik mena raum. Na roasiret äsimwarota, akan mena mena atap atap pote o kau momoi, jaurai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Keser aurna, Jisas nukas ätäi kon ämän tamareäu roat keser awarowon, “Kiro roasiret ak owose manaiei? Akasar o jaun araiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Akas ätäi ko keser aurin, “Ik o sosop oi kowau wa. bret 5 orip pak was oiroror pak oi koumun rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jisas nukas kon ämän tamareäu roat awarowon, “Kiro o oi koi is irowe.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ko roasiret awaronuk, ak amurik opok tane rauna, kos kiro bret 5 orip pak was oiroror pak oianik, omar oik eisane aparmara, Anut ‘pere’ auruwon. Ko kiro bret pärärmara, kon tamareäu roat aronuk, akas pak oianik, roasiret arona, jein. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Roasiret erekapu ak kiro o jeanik, nokomaka pewon. Kiro o autau raunuk, Jisas nukan tamareäu roat akas basket 12 orip oianik, joke mona, kiro basket erekapu ok pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","O jein roat 5,000 orip, asiret mokoit pak ak o jein ninarewarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Keseria, Jisas nukas kon tamareäu roat awaronuk, “Ak ous oik tonea, Galili An Unik karaima amke potaiei.” Awaromara, nuka roasiret äsimwaronuk, akan mena mena manaiei rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","24","Ko roasiret äsimwaronuk, manona, ko nukarar omtapau oik tonea, Anut auri rawon. Iukärir, omiri kounuk kounuk, Jisas nukarar kiro pakar raunuk raunuk, kiro ous kon tamareäu roat akas oi potoin ko an unik näu kamuk opok potonuk, urir näwäu peanik, kiro ous atonuk anas kiro ous kururur maurwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tapera, om teine kounuk kounuk, 3 klok pote 6 klok opok senek, Jisas ko ätäi kon tamareäu roat rain opok an unik oikas ari ari kowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Kon tamareäu roat akas ko an atat kounuk, aparianik, ak sakau iminein. Keser äiein, “Kiro kar op!” Äianik, ak sakau imineanik, aru piorin. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Kurte Jisas nukas awarowon, “Ak sakau rawe. Okoro isaka. Ak wa iminäu!” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita nukas ätäi keser auruwon, “Näwäu, kiro epar na raroi, is airota, an oikas na raum opok potam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisas nukas ätäi auruwon, “Io, na koi!” Keser aurnuk, Pita ko ous oikas pitir nomara, an oikas Jisas rawon opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Kesernuk, Pita ko urir näwäu nukas an unik uru kururur maurnuk, aparianik, ko sakau näu imineanik, urwewon, “Näwäu, na is sareir!” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jisas nukas kon ipou kurte ateanik, keser auruwon, “Nan won epar momon kiro eteinak senes. Na owon ronkat oirori oumon?” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jisas ko Pita ori ätäi pote ous opok tonosa, urir utowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Jisas nukan tamareäu roat ak ous uru rain ak kon enip rororin. Ak keser äiein, “Epar senes, na Anut nukan Mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jisas kon tamareäu roat pak ak Galili An Unik kure poteanik, Genesaret omnokou kasakup potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kiro pakan roasiret ak äpu moin kiro Jisas kou. Kesermana, akas ämän surna, kiro omnokou pakan roasiret karauk roasiret sip orip Jisas siakup imware koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Karauk roasiret akas Jisas keser sakau aurin, “Na kiro sip roasiret utwarota, akas koi nan omjo peteu ataiei.” Keseria, sip roasiret akan ipiakas Jisas nukan omjo atianik, ak erekapu näu sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Karauk Parisi roat pak sintore ämän tamareäi roat pak ak Jerusalem menas koianik, Jisas keser totorin, ");
INSERT INTO bbr2013_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Owon nan tamareäum roat akas iken askanai akan sintore ämän wa tainoriäi? Ak o jauri akan ipiak an wa kosoriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisas nukas owon Anut nukan ämän wa tainoriäi, ak akan askanai akan onok karar tainoriäi? ");
INSERT INTO bbr2013_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Anut nukas äiewon, ‘Na nan momon aninan ämän tainor.’ Ko ätäi äiewon, ‘Inok ro ko kon momok anak jeimarai, karauk roat akas ko wena, meiäi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Utianik, ak keser ämän miäi, ‘Inok ro ko osap orip kon momok anak ori sarwataun itok. Utianik, ko au awateäu. “Is kiro osap Anut nuraun karar sare momin rau. Keseria, is au sarwatau senek wa.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ak Parisi roat keser äiäi, ‘Kiro itok, ko kon momok anak wa saräi.’ Kiro onokus ak Anut nukan ämän tonoi mianik, akan askanain ämän karar epar tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ak sätäiäin roat! Anut nukan ämän roianik, areawon ro Aisaia nukas ak mesin epar äiewon. Ko keser jer wewon, ");
INSERT INTO bbr2013_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Anut nukas äiewon, “Kiro roasiret akas erar oiaksaus isan enim rororiäi, utianik, akan woiakas isanun meiäu wa. Ak isan ämän awareäim ak jekur wa tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ak kar ron sintore ämän tainoria, ak keser äiäi kiro Anut nukan ämän. Ak sät ämän tainorianik, ak isan enim erar rororiäi!” ’” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jisas nukas roasiret sosop urwarnuk, ko siakup kouna, keser awarowon, “Ak okoro ämän awaram roinai, jekur äpu maiei! ");
INSERT INTO bbr2013_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Kar ro ko o jeäu kis Anut nukan amukup ukun wa kureäu. Ronkat aru wou uru rau siräienuk, kon oksaus äiäu kis epar ko ukun kureäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kiro ses opok kon tamareäu roat akas ko siakup koianik, keser aurin, “Na kiro ämän aremon mesin Parisi roat ak kiro ämän roianik, akan woiaka aru moin, na kiro äpu ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jisas nukas ätäi kon tamareäu roat awarowon, “Isan Moni ko omar oik rau, ko woi orip. O uku nuka ipous wäu wa, kiro erekapu akan kinip orip siräi kuräi. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ak kiro utwarona, rawe, kiro roat ak amiak utup, ak kar jaunakat amiak utup apu ätär marau senek wa. Kar ro amuk utup kos kar amuk utup jauk apu ätär murim rai, au jauk ori erek erek owateanik, up uru naieir.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Keser äienuk, Pita nukas Jisas keser auruwon, “Na kiro totok ämän onoktapau ik aikota, rowam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisas nukas awarowon, “Is ak ämän sosop ätär maromin sinuk, akan ronkat eposek senes saräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ak kiro onok äpu wa ra? Owo o jeäi kiro pimur uru ne raiäu, kiro ätäi pimur uruas koianik, neäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Utianik, ronkat aru woiaka uru raiäu siräienuk, oiaksau opokas peäu, kiro ronkatis karar roasiret epar ukun kurwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Woiaka uruas roasiret ak kiro ronkat aru keser oiäi: Ak roasiret akwarona, meiäun ronkateäi, ak ro oin asiret aru maraun ronkateäi, ak karauk memes onok maun ronkateäi, ak osap päu owaun ronkateäi, ak osap aparianik, meswareäu, ak ämän sät äiäun pak, roasiret enmakap ämän maun pak ronkateäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kiro onok aru kis roasiret ukun kurwareäu. Utianik, ak ipiak an kosorau wa, o jeäin kis roasiret Anut nukan amuk opok ukun wa kurwareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jisas ko kiro mena utomoi, kar omsau Taia näu mena pak Saidon näu mena kamuk opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kar Kenan asir ko kiro mena raiäwon, ko pemara, Jisas auruwon, “Näu ro, na Devit nukan Mokoi, na isanun wonti moinam, is sareir! Isan asinak osou aru nukas erekapu aru mowon rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Utianik, Jisas nukas kiro asir ätäi kar ämän aurau wa. Kon tamareäu roat akas ko siakup peanik, keser aurin, “Kiro asir ko ik tainoike koi rai, ur orip koura, okon, na ko äsimorta, ätäi manai!” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Keserna, kos ätäi awarowon, “Israel roasiret ak sipsip senek kamwaraun ro wäpik. Isan moni nukas kiro Israel roasiret akanun karar is äsimoirnuk, kamwaraun koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Keser awaronuk, kiro asir ko Jisas siakupai pemara, ate waianik, keser auruwon, “Näu ro, na is sareir.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisas nukas ätäi keser auruwon, “Ik mokoit akan o oianik, enat wa kure mareäum. Kiro onok aru.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Kesernuk, kiro asires Jisas keser auruwon, “Näu ro, kiro epar äiem, utianik, enat ak akan momonakat patan opok o jena, karauk o usip omnokou opok nonuk, akan enat akas kiro o usip jeäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Kesernuk, Jisas nukas kiro asir auruwon, “Asir, nan won epar momon kiro näwäu senes! Nan owo onok is na sareisaun airom, kiro sareisam.” Jisas ko kiro asir keser aurnukar, kiro asiren asinak ko ätäi eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jisas ko kiro mena utomoi, Galili An Unik kasakup potowon. Ko kar omtapau opok toneanik, tane rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Karauk roasiret akas karauk roasiret sosop, amiak utup roat, isoraka aru roat, pak oiaka utup roat pak, karauk sip roat pak ak Jisas nuka siakup imware koi maroin. Kos kiro roasiret sip orip erekapu jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Kesernuk, ak ko kiro onok keserwon aparianik, ak ronkat sosop oin. Oiaka utup roat ak ätäi eposek arein, isiaka mämäinewon roat ak ätäi tuku sarein, amiaka utup roat ak amareanik, osap aparin, wa ariain isorak aru roat ak ätäi ariein, karauk roat ak sip atap atap orip ak eposek sarein. Kesernuk, kiro roasiret akas Israel akan Anut enip rororin. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisas nukas kon tamareäu roat ur warnuk, kouna, keser awarowon, “Is okoro roasiret ak omre 3 orip o wäpik ik pak erek erar rain apwareanik, woiokti mou. Ak apu opok pote sous meiäiei. Keseria, is erar akan mena äsimwaroita, manau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Kon tamareäu roat akas ätäi keser aurin, “Ik okoro ro wäpik mena raum, okoro roasiret sosop, ik o erapakan oianik, roasiret arota, jaiei?” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisas nukas ätäi awarowon, “Ak bret esap esap rau?” Akas ätäi aurin, “Ik o sosop oi kowau wa, bret 7 orip pak karauk was eteinanak pak rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Keserna, Jisas nukas ätäi roasiret omkapai tanewe räi awaronuk, ak tanein. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Kos bret 7 orip pak was pak oianik, Anut ‘pere’ auruwon. Keserianik, kon tamareäu roat aronuk, akas pak kiro roasiret arona, jein. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Roasiret ak kiro o jeanik, erekapu nokomaka pewon. Karauk o autau utoin Jisas nukan tamareäu roat akas basket 7 orip oianik, kiro o jein autau joke mona, ok pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","O jein roat ak 4,000 orip, utianik, asiret mokoit pak ak ninarewarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Keseria, Jisas nukas kiro roasiret äsimwaronuk, akan mena mane kurena, ko ous oik toneanik, Magadan omnokou opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Karauk Parisi pak Sadusi roat pak akas Jisas ate aparaun koin. Keseria, ak Jisas aurin, “Na kar kurur ätär muk. Keserta, ik äpu mam, na Anut omar oik rau nukasar kiro sakau isiäu.”  ");
INSERT INTO bbr2013_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Utianik Jisas nukas ätäi keser awarowon, “Ak iukärir san nomara, omar osou sarenuk, aparianik, ak keser äiäi, ‘Ariwa omre eposek.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tapera ak omar osou pak mokup pak aparianik, keser äiäi, ‘Om nai.’ äiäi. Ak omar aparia, kiro onok ak epar äpu miäi. Utianik, owo onok rusapai peu, ak kiro onoktapau äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ak roasiret aru, ak Anut nukan onok eposek wa tainoriäi! Akas is kar kurur moita, aparaun totoiroi ra? Utianik, is ak kiro kurur wa ätär maram! Jona nukan kurur karar ätär maroita, kiro epar ak aparaiei.” Keser awareanik, Jisas ko utware manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisas nukan tamareäu roat ak rakuswarnuk, karauk bret owau wa, ak erar Galili An Unik kureanik, karaima potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jisas nukas kon tamareäu roat keser awarowon, “Ak Parisi pak Sadusi roat pak akan bret makona, noroiäwon marasin enip jis jekur aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Aka aka keser areanik, äiein, “Ik bret oi kowau wa, okon, ko kiro ämän aikou.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisas ko akan ämän are rain äpu momara, kos keser totwarowon, “Ak owon keser arerai? ‘Ik bret oi kowau wa.’ Akan woiaka epar moin kiro eteinak! ");
INSERT INTO bbr2013_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Utianik, ak ronkat eposek wäpik ra? Is bret 5 orip oumoi, pärärianik roat 5,000 orip aroita, jein, ak kiro ronkatäu wa ra? Ak basket esap esap oianik, bret autau joke mona, ok pewon? ");
INSERT INTO bbr2013_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","11","Kar ses opok, is bret 7 orip oianik, roat 4,000 orip aroita, jein ak kiro ronkat oin ra? Ak basket esap esap oianik, bret autau oi joke mona, ok pewon? Owon ak kiro ronkatäu utoi? Rusapai is ak bret mesin awarau wa. Is ak Parisi pak Sadusi roat pak akan jis kiro jekur aparaun rai is ak awarom!” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kesernuk, kon tamareäu roat ak ätäi äpu moin. Jisas ko bret makona, noroiäwon marasin enip jis kinun awarau wa, utianik, ko ak Parisi pak Sadusi roat pak akan ämän tamareäi jekur wasarewaraun rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisas kon tamareäu roat pak ak Sisaria-Filipai provins opok poteanik, kon tamareäu roat keser totwarowon, “Roasiret akas Ro Nukan Mokoi inok äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ak ätäi aurin, “Karauk roasiret akas keser äiäi, ‘Ko an jomareäwon ro, Jon.’ Karauk roasiret akas keser äiäi, ‘Ko Elaija.’ Karauk roasiret akas äiäi, ‘Ko Jeremaia ra, ara, ko Anut nukan ämän roianik, areawon ro kar rä.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Keser aurna, Jisas nukas kon tamareäu roat awarowon, “Akasar is inok äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon-Pita nukas ätäi auruwon, “Na Krais, na Anut ko awau orip orip raiäu nukan mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisas nukas Saimon ätäi keser auruwon, “Saimon, Jona nukan mokoi, na nepipir! Kar omnokoupaian ros kiro ämän na aisau wa, utianik, nan ämän kiro isan moni omar oik rau kosar na ätär musowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Keseria, is na aisom, na Pita, aitapau senek. is isan roasiret kiro aitapau oik turur maram, utianik, meiäun onokus kiro roasiret wa aru marai. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Is nan enmat näwäu isom. Nas roasiret wasarewarea, kar ro keser auram, ‘Na kiro onok keseraun itok.’ Na kar ro keser auram, ‘Na kiro onok wa keserau.’ Inok roasir na omnokou opok auram, ‘Na kiro onok wa keserau,’ Anut nukas nais omar oik keseriar aurai. Inok roasir nas omnokou opok auram, ‘Na kiro onok keseraun itok.’ Anut nukas nais omar oik keseriar aurai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Keseria, Jisas nukas kon tamareäu roat ämän keser awarowon, “Ak karauk roasiret ko Krais ak keser wa awarau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kiro ses opok, Jisas nukas kon tamareäu roat amop ämän marowon, “Is Jerusalem mena potoita, kiro pakan roat näunäu pak, Anut kamuk raiäi roat näunäu pak, sintore ämän tamareäi roat pak akas is tätäi näwäu iraiei. Is tätäi näwäu irianik, akas iworona, meiäm, utianik, omre 3 opok, is ätäi siräiam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita nukas Jisas ämäi ämäi kasakup keraun imäi manowon. Pita nukas kermara, keser auruwon, “Wa senes! Kiro onok na opok wa päi!” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Kesernuk, Jisas nukas ätäi piritirianik, Pita keser auruwon, “Satan, na is mekesirap man! Na isan ami pe wa sor rau, is apu anaraurim opok. Na roat akan ronkat karar tainoriäum, na Anut nukan ronkat eposek wa tainoriäum.” ");
INSERT INTO bbr2013_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ko Pita keser aurianik, ko kon tamareäu roat awarowon, “Inok ro is tainoire päun, ko nukanun wa ronkatäi, ko kon am äpäs nukasar ämäianik, is tainorai. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Inok ro ko kon totok awau rawaun ronkateäu kiro kon totok aru mai. Utianik, inok ro kon totok isanun meiäi, kiro ro kon totok orip orip jekur eposek rawai. Ko eposek rawaun apu itanai. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kar ro omnokoupaian osap erekapu oumara, ko meiäi. Kiro osapus nukan totok awau rawaun owose saräi? Ko owo osap oianik, ätäi nukan totok awau rawaun kau mai? Wa, ko ätäi nukasar nukan totok kau mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Utianik, Ro Nukan Mokoi kon momokun arou pak, kon sarau eitek raut pak erek koianik, roasiret wasarewarai. Inok roasiret ak onok eposek miäin, ko osap eposek arai. Inok roasiret ak onok aru miäin, ko osap wa arai. Ko roasiret erekapu wasarewarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Is ak epar senes awarom, karauk roat ak okoro omnokou opok rai, karauk wa meiäiei, utianik, ak rauna raunar, Ro Nukan Mokoi kamwareäwon ro näwäu senek kounuk, ak aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Omre 6 orip utia, Jisas nukas Pita, Jems, kon amak Jon pak ak karar kos imwaromara, kar omtapau rumukäu oik tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ak akan amiak opok, Jisas nukan enipsau pirirmara, atap pewon aparin. Kon neputapau san amuk senek aparin, kon omjo nais san nukan merek senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Kesernuk, ak Moses, Elaija ori au peanik, Jisas pak are rairin apwatoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Keseria, Pita nukas Jisas keser auruwon, “Näwäu, ik okoro opok rawaun eposek! Na äuta, is okoro opok akan jan ou 3 orip mam, kar nan, kar Moses nukan, kar Elaija nukan.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ko keser arenuk arenuk, kar iou ärneu senes koi kurururwaronuk, Anut nukas kar ämän kiro iou uruas keser arewon, “Kiro mokoi epar isan senes, is konun isan woias meieäim, is kon onok aparianik, isan woi näu sareäu. Ak kon ämän rowaiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kiro ses opok, Jisas nukan tamareäu roat akas kiro pätu roianik, ak sakau imineanik, om tonoi rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Keserna, Jisas ak siarakap pemara, atwareanik, kos keser awarowon, “Ak siräwe. Ak wa iminäu!” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kesernuk, ak siräianik, akan amiakas aparin, ak kar ro aparau wa, Jisas karar rawon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jisas kon tamareäu roat pak omtapau ute ne ne rai, ko ak keser ämän awarowon, “Ak okoro onok ak amiakap pewon aparin ak pote kar roasir wa aurau, utianik, Ro Nukan Mokoi meiemara, ätäi up uruas siräienuk, kiro ses opok ak owo onok aparin kiro epar roasiret awaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Utianik, Jisas nukan tamareäu roat akas ko keser totorin, “Sintore ämän tamareäi roat akas owon Elaija ko amke kowai äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisas nukas ätäi keser awarowon, “Ak kiro epar äiäi, Anut nukan ämänis keser äiewon, Elaija ko amke koia, ko ätäi osap erekapu jekur mai. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Utianik, is ak epar awarom, Elaija ko amke kowon, roasiret ak ko jekur äpu mau wa, akas akan ronkatis onok aru atap atap ko opok keserin. Ak ko keser rain siar akan onok aru Ro Nukan Mokoi opok kir keseraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ko keser arenuk, kon tamareäu roat ak äpu moin, ko an jomareäwon ro, Jon nuka mesin äieu rai äiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","15","Jisas kon tamareäu roat pak roasiret sosop turur rain opok potona, kar ros Jisas siakup peanik, uou sur wemara, äiewon, “Näwäu, na isan mokoi mesin wonti moinam, ko jekur muram! Ko sip arus ate kareäu. Ko kesernuk, orip orip ep uru neäu. Kar muti an opok neäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Is ko nan tamareäum roat rawa imäi koimin, utianik, akas ko jekurau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisas nukas roasiret kewareanik, awarowon, “Ei, owon akan woiaka epar mau wa! Ak tapiaka sakau miäi. Omre esap esap is ätäi ak pak rawam? Omre esap esap is akanun ätäi woias meiäm. Ak kiro mokoi is siarap imäi kowe.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ak kiro mokoi imäi kouna, Jisas nukas kiro osou aru kiro mokoi opok rawon sakau kernuk, kiro ses opokar osou aru kiro mokoi ute manowon. Kiro mokoi ätäi eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ko kesernuk, Jisas nukan tamareäu roat akas ämäi ämäi peanik, Jisas keser totorin, “Ik owo onokun kiro osou aru oi kuräun senek itok wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jisas nukas ätäi awarowon, “Ak akan woiaka epar moin kiro eteinak senes. Kesek, okon, ak itok wa. Is ak epar awarom, akan woiaka epar moin kiro am uku eteinak marmar senek, akas okoro omtapau keser auraiei, ‘Na okoro pakas siräinam, enro opok pot,’ keser aurna, ko potai. Akan woiaka epar senes mia, ak owo sarau maun kiro maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Utianik, kar apu pakaimas kiro osou aru oikuräu senek wa. Anut aurmana, o utomoi, kiro pakas karar epar keseraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kar ses opok, Jisas kon tamareäu roat pak erek Galili potaun pote rai, kos keser awarowon, “Karauk roat akas Ro Nukan Mokoi sakateanik, karauk roat akan ipiaka opok maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kiro roat akas ko wena, meiäi. Keserna, omre 3 opok ko ätäi up uruas siräiai.” Kon tamareäu roat ak kiro ämän roianik, akan woiaka usu senes sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kiro ses opok Jisas kon tamareäu roat pak Kapaneam mena potona, Anut osap nuriäi owa takis aiauk oiäin roat akas koi Pita totorin, “Akan ämän tamareäwon ro ko takis aiauk tup owa miäu ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita nukas äiewon, “Io, ko miäu.” Keseria, Pita ko owa tononuk, Jisas nukas amke ko totorwon, “Saimon nan ronkat owo senek? Okoro omsau kamwareäin roat näunäu akas inok roat pakan takis aiauk owaiei? Akan omsau pakan roat ra, karauk omsau pakan roat?” ");
INSERT INTO bbr2013_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Keser aurnuk, Pita nukas ätäi Jisas auruwon, “Kar omsau pakan roat akas aiauk maiei!” Jisas nukas ätäi ko keser auruwon, “Keseria, okoro omsau pakan roat ak takis aiauk wa maiei, ak erar rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Utianik, ik kiro roat pak wa ketäiäm. Keseria, na nan huk oinam, pote an unik opok huk kureinam, was amke owam. Kiro was kon au uru kar aiauk rau paraine apari owam. Kiro itok, nas kiro aiauk oi pote tup owa arota, kiro aiauk iwen erek karar.” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kar omre opok, Jisas nukan tamareäu roat akas, ko rawa koianik, ak keser totorin. “Inok ro näwäu senes ko Anut nukan roasiret kamuk opok rau?” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Keseria, Jisas nukas kar mokoi eteinak aura kounuk, kiro mokoi roat amiakap kamuk tai momara, awarowon, ");
INSERT INTO bbr2013_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“Is ak epar senes awarom. Utianik, ak akan woiaka ätäi piririanik, okoro mokoinakut senek saräu wa, kiro ak Anut nukan roasiret wa saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Inok ro nukasar kon enip wa rororai, ätäi okoro mokoinak senek saräi, kiro ro epar kos karauk roat itimwareanik, Anut nukan amuk opok ro näwäu saräi. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Inok ros isanun ronkatemara, ko kar mokoi okoro mokoinak senek imäianik, jekur kameäu, kiro ko is imäiriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jisas nukas ätäi awarowon, “Kar mokoinak is mesin kon wou epar mowon kar ros ko onok aru ätär muronuk raroi, kiro onok aru senes. Karauk roat akas aiauk usuäu oianik, kiro ron pou opok muris pararar mianik, an unik uru känkurena, nai, kiro itok, kiro usu eteinak. Warnuk, tawa omar oik, ko usu näwäu senes owai. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wopur senes, karauk omnokou pakan roat akas onok aru mianik, kiro onokus karauk roasiret eposek akan woiaka epar moin utiäi. Kiro onok aru epar peäu, utianik, kiro ro kiro onok aru miäu, wopur, ko tawa usu näwäu senes owai. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Utianik, nan ipon ra ison ra, kis onok aru maun reusona rai, nan kiro ipon ra ison ra patirnam, känkuram, kiro itok. Na orip orip eposek awau rawam. Na kiro wa keserta rai, na kiro ipon oirori ra, ison oirori orip pak erekapu ep wa koseriäu uru kureisaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Utianik, nan amunauk kararas onok aru maun reusonuk rai, kiro amunauk kiro etkoi kuräm amunauk karar kiro itok. Na orip orip awau rawam. Na kiro keserta rai, na kiro amunauk oirori orip pak erekapu ep orip orip jeräu mena kureisaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jisas nukas ätäiar awarowon, “Ak jekur rowe, ak keser wa ronkatäu okoro mokoit ak erar mokoinakut rai wa äiäu. Wa! Is ak epar awarom, omar oik akan kamwareäwon sarau eitek rai, ak orip orip isan Moni omar oik rau kon amuk opok tai raiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Kiro owon, Ro Nukan Mokoi ko roasiret wasarein ätäi imwaraun kowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kar ro kon sipsip 100 orip, utianik, ko kon sipsip karar ämäienuk, akan ronkat owosäiei? Ko wa itanäi ra? Wa. Ko karauk sipsip 99 orip omtapau opok utwaronuk, amurik je rauna rauna, ko kar sipsip ämäiewon pote itanäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Is ak epar senes awarom, kiro ro ko pote kiro sipsip ämäiewon itane aparmoi, ko wou näu sareanik, nepipirwon. Ko karauk 99 sipsip akanun näwäu nepipirau wa, owon ak ämäiäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kiro kon onok kesek akan Momonaka ko omar oik rawos okoro mokoit eteinanak utwaronuk, wa wasaräiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jisas nukas ätäi awarowon, “Utianik, nan jaunas na opok onok aru monuk, nas ko siakup potea, kon onok aru mowon mesin auram. Utianik, aukararnak ämäi ämäi kiro keseraieir. Keserta, kos nan ämän rounuk rai, kiro itok nas nan jaun ätäi ki imäum. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Utianik, ko nan ämän rowau utonuk rai, na ro karar ra ro oirori imwateanik, ak ko pak koi taneanik, kon wou ätäi piriraun auraieir. Keseria, kiro ro oirories kon ämän tuku rai aparaieir. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Keserna, ko akan ämän rowau utonuk rai, ak roasiret woiaka epar moin kiro ron onok aru mowon kon ämän awarona, akas pak ko saräiei. Utianik, ko roasiret akan ämän keseriar rowau utonuk rai, ak ko keser auraiei, ‘Na won epar mau wa ro senek, na takis oiäu ro senek, na ik pak wa turur rawam.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jisas nukas ätäi äiewon, “Is ak epar senes awarom, omnokou opok, inok roasir ak auraiei, ‘Na kiro onok wa keserau’ Anut nukas nais omar oik keseriar aurai. Omnokou opok, inok roasir ak auraiei, ‘Na kiro onok itok keser,’ Anut nukas nais omar oik keseriar aurai. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Is ak ätäiar awarom, okoro onkapai kar omre opok ro oirories awan woiaka karar mianik, au ämän ateanik, owo osap owaun Anut auraieir, isan Moni ko omar oik rau kos au kiro osap atai. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Keseria, ro oirori ra 3 orip akas is mesin ronkateanik, isan enip pakas ak turur raiäi, kiro is ak pak rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kiro ses opok Pita nukas Jisas siakup koianik, keser totorwon, “Näwäu, utianik, isan jaias orip orip is opok onok aru monuk, omre esap esap is kon onok aru jäkäi muram? Omre 7 orip ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jisas nukas ätäi keser auruwon, “Is keser wa aisom. Utianik, is 70 orip keserai kiro 7 orip na aisom. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ak rowe, Anut nukan kamwareäu onok kiro senek: Kar ses opok kar omsau kamwareäwon ro näwäus kon sarau roat akan aiauk amuk owaun pote totwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ko osap amuk owaun kiro onok kesernuk kesernuk, kiro omre opokar karauk roat akas kar ro, ko ro näwäu nukan aiauk sosop ten milion owon imäianik, koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kiro sarau ros kiro aiauk amuk ätäi nurau senek wa. Kesernuk, kiro ro näwäu nukas ko keser auruwon, ‘Is naka pak nan asik pak nan mokoit pak erekapu is ak aiauk wa oiäin sarau roat senek sare maroita, nan osap pak erekapu karauk roat akas ak kau marona, is kiro aiauk amuk ätäi kiro pakan irona, owam.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Kiro sarau ros kamwareäwon ro näwäu ko siakup pemara, wopur ämän keser auruwon, ‘Na isanun wonti mo. Is nan aiauk oimin erekapu ätäi na isam.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Omsau kamwareäwon ro näwäu nukas kiro ro mesin wouti momara, kos kiro ro keser auruwon, ‘Na isan aiauk oumon kiro is ätäi wa irau. Is kiro aiauk tamkäsirowon.’ Ko keser aurnuk, kiro sarau ro ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Utianik, kiro sarau ro ko ute maneanik, apu opok kar sarau ro jauk kon aiauk amuk eteinak owon tararmara, kos kon jauk pou ate siermara, keser auruwon, ‘Na isan karauk aiauk erar oumon ätäi amuk erekapu kurte iram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Kesernuk, kiro sarau jaukus omnokou opok kurir ninomara, wopur ämän orip kiro sarau jauk auruwon. ‘Na isanun wonti mota, is nan aiauk amuk ätäi isam.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Utianik, kos kon sarau jaukun ämän rowau wa, kos kiro ro auruwon. ‘Utianik, na isan aiauk erar oumon ätäi irau wa, okon, is na karapus owa musam. Na isan aiauk kiro amuk ätäi iromata, epar na ute manam.’ Keser aurianik, ko kiro ro karapus owa kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kesernuk, kon karauk sarau jaukut akas ak kiro onok aparianik, ak woiakati maronuk, akas akan kamwareäwon ro näwäu kiro ämän erekapu pote aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Keseria, kamwareäwon ro nukas kon sarau ro aru urirawa, siakup kounuk, kos keser auruwon, ‘Na sarau ro aru senes. Na isan aiauk erar isota, oumon, nas is aiauk wäpik airota, is epar rai isan aiauk amuk na pakan ätäi owau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Isas nanun woiti momin, nas nan sarau jaun mesin wonti mau utomon. Isas nanun kesermin senek, nas pak konun keserau utomon. Na onok aru mom.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Keseria, kiro omsau kamwareäwon ro ko kasak penuk, kiro sarau ro karapus owa kuremara, ko sarau näwäu senes nurmoi, ko keser auruwon, ‘Na ätäi isan aiauk amuk erekapu iram.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisas nukas kiro ämän patarianik, ätäi keser awarowon, “Akan woiaka sakau monai, akan jaunakat akas onok aru moin erekapu jäkäi maraiei. Ak wa keserna rai, kiro omsau kamwareäwon ro nukas kon sarau ro keseru senek, kiro onok keseriar isan Moni ko omar oik rau kos nais ak erekapu, kiro onok kesewarai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisas nukas roasiret kiro ämän mare kuremara, ko Galili provins utia, Judia provins Jordan An karaima rau opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Potonuk, roasiret sosop sip orip ko tainori potona, kos kiro opok karauk roasiret sip orip jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Karauk Parisi roat akas Jisas ate aparaun ko siakup koianik, keser totorin. “Iken sintore ämänis äieu, kar asir onok aru mau wa, kon komus kon ronkatis utaun itok ra, wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisas nukas ätäi keser awarowon. “Ak Anut nukan ämän kesek rau wa ninareäi ra? ‘Amke Anut nukas ro pak asir pak ate matowon.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","‘Kiro onokun, ro kon wau ori erekur atap raianik, awan enmaksau karar tururaieir.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Keseria, kiro ro asir ori awan enmaksau atap atap oiroror rawau wa, utianik, awan enmaksau karar senek sare rawai. Keserianik, Anut nukas au karar enmaksau senek turur matowon, okon, kar roasires ätäi wa inäi matau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Kesernuk, Parisi roat akas Jisas keser aurin. “Nan ämän epar maro, Moses nukan sintore ämänis owon keser aikowon, kar ro kon asir utonuk, manaun kar jer wemara, kon wau nurai, kiro kesermara, epar kon wau utonuk, manai? Ko owon keser äiewon?” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisas nukas ätäi awarowon, “Moses nukas akan woiaka sakau mona, apwareanik, roat ak asiret owaroin, utwarona, manaun itok awarowon. Utianik, meter ro asir pak atwate mowon ses opok, kiro onok kesek rawau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Is ak epar awarom, inok ro kon wau sapum onok mau wa, kiro ros kon wau erar utomoi, ko kar asir owai, kiro ko nukasar kon asir utomoi, ko nukasar roasiret ouratäiäi sintore ämän espäiai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Parisi roat ak manona, Jisas nukan tamareäu roat akas ko keser aurin, “Asir pak rawaun onok kesek, okon, iken ronkat roat ak asir wa owaiei erar rawaiei, kiro onok itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Keserna, Jisas nukas ätäi keser awarowon, “Kiro ämän roasiret erekapu tainorau senek wa. Utianik, Anut nukas karar karauk roasiret sakau maronuk, ak kiro ämän tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ak rowe! Karauk roat ak asir wa oiäin, kon onoktapau kesek: karauk roat akan aninakat akas sip aru orip an jowaroin, okon, ak mokoi mau senek wa. Utianik, karauk roat akas karauk roat aru maroin, okon, ak asir owau senek wa. Karauk roat ak Anut nukan sarau oianik, ak asir wa oiäi. Owo ro ko okoro ämän roumoi, tainoraun ko tainoraura.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Kiro ses opok, roasiret akas akan mokoinakut Jisas nukas akan tapiaka atomara, Anut nukas ak sakau araun rai auraun ko siakup imware koin. Utianik, kon tamareäu roat akas kiro roasiret kewaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Keserna, Jisas nukas kon tamareäu roat awarowon, “Ak kiro mokoit utwarona, is siarap kowaiei. Ak wa tämarau. Roasiret ak okoro mokoinakut senek, ak äpu Anut akan kamwareäu ro näwäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ko kon ipou kiro mokoit akan tapiakap mianik, Anut ak mesin aurmara, ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kar ro ko Jisas siakup koumara, auruwon, “Tamareäum ro, is owo onok eposek kesermoi, isan totom orip orip awau rawai?” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Keser aurnuk, Jisas nukas auruwon, “Na owon onok eposek maun is totoirom? Kar ro karar ko eposek. Utianik, na awau rawauria, sintore ämän erekapu tainoram.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Kiro ros ätäi Jisas auruwon, “Owo sintore ämän?” Keser aurnuk, Jisas nukas ätäi kiro ro auruwon, “Sintore ämän kesek, ‘Na kar ro weta, wa meiäu’, ‘Na kar ron asir wa imäi ariäu’, ‘Na karauk roat akan osap wa päu owau’, ‘Na kar ron enkup sät ämän wa mau’, ");
INSERT INTO bbr2013_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","‘Na nan momon anin orien ämän erekapu tainor,’ ‘Na nakanun wonas meieäum senek, karauk roat akanun keseriar keseram.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kiro mokoi awaus ätäi keser auruwon, “Is kiro sintore ämän erekapu tainoriäim. Utianik, owo onok eposek is keserau wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisas nukas kiro ro ätäi keser auruwon, “Utianik, na ro eposek senes saräuria, na potoinam, nan osap erekapu karauk roat are kureta, akas kiro osap kau mona, kiro aiauk oinam, saruku roat osap wäpik kiro aiauk inäi aram. Na keserta, nan osap sosop senes omar oik rawai. Keseria, na koi is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kiro mokoi awau ko kiro ämän roianik, kon wou usu sarenuk, ko ute manowon. Owon, ko osap sosop orip, okon, kiro onok keserau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Keseria, Jisas nukas kon tamareäu roat awarowon, “Is ak epar senes awarom. Roat osap sosop orip ak Anut nukan roasiret saräun kananäiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Is kiro ämän ätäi awarom. Kar opur kamel ko omjo näkeäi nil nukan amarer uruas tonaun kananäi. Utianik, roasiret osap sosop orip ak Anut nukan roasiret saräun sakau kananäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kon tamareäu roat akas kiro ämän roianik, ak karkairmoi, äiein, “Keseria, Anut nukas inok ro imäienuk, ko pak erek orip orip rawai?” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisas nukas apwaromara, awarowon, “Roat akas kiro onok keseraun itok wa. Utianik, Anut nukas karar kiro onok erekapu keseraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ko keser äienuk, Pita nukas ätäi auruwon. “Na ik apaik, ik iken osap erekapu utomoi, na tainoise koumun. Ik owo osap owam?” ");
INSERT INTO bbr2013_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisas nukas ätäi awarowon, “Is ak epar senes awarom, omnokou awau penuk, Ro Nukan Mokoi ko enip näwäu orip kamwareäu ro nukan sia opok tanenuk, kiro ses opok ak is tainoireäin roat ak nais kamwareäi roat akan sia 12 orip opok taneanik, akan sarau Israel akan tupsiu karar karar 12 orip akan onok wasarewaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Inok roasir isan enim jou maun ronkateanik, ko kon ou, kon awak, kon amak, kon äpiauk, kon momok, kon anak, kon mokoit, kon asinakut, kon omnokou utomoi, isan onok tainorwon, tawa Anut nukas kiro osap ute kowon senek, 100 orip nurunuk, ko orip orip eposek awau rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Rowe, roat sosop ak rusapai enmaka näwäu orip rai, tawa ak enmaka wäpik erar ro senek rawaiei. Utianik, roat rusapai erar rai, tawa akas enmaka näwäu orip rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jisas nukas ätäi äiewon, “Anut nukan kamwareäwon onok kesek rau. Kar omre tapera senes, wain woi atak ro nukas kon woia sarau maun karauk roat amket opok rai itanware potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ko pote karauk roat tarwareanik, keser awarowon, ‘Ak isan wain woia, pote sarau mona, is ak aiauk omre karar opokan aiauk keseriar aram.’ Kesernuk, kiro roat akas ior aurna, ko ak äsimwaronuk, kon woia sarau maun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Kiro woi atak ro ko ätäi 9 klok senek amket opok ätäi potea, karauk roat erar tai rain apwarwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Keseria, kos kiro roat awarowon, ‘Ak nais pote isan wain woia sarau mona, is ak aiauk aram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kesernuk, kiro roat ak sarau maun manona, ko ätäi 12 klok keseriar keserwon. Rai rai, ko 3 klok kir keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kiro ro ko 5 klok utonuk, ätäi amket opok potea, ko karauk roat kiro opok erar rain apwarwon. Kos awarowon, ‘Ak owon okoro opok erar rai?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Kiro roat akas ätäi ko keser aurin, ‘Ik kar ros sarau ikau wa, okon, ik erar raum.’ Akas keser aurna, kos ätäi kiro roat awarowon, ‘Ak pote isan wain woia sarau mowe.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Keseria, iukärir sarenuk, woi atak ro nukas sarau roat kamwareäwon ro näwäu auruwon, ‘Na sarau roat urwarota, kouna, akan aiauk ar. Ruris pote sarau moin roat ak aiauk amke aroinam, tawa amke pote sarau moin roat ak ätäi aiauk ruris aram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kiro roat atap atap ak rusapai pote, sarau moin omre karar opokan aiauk oin. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Keserna, amke pote sarau moin roat akas ‘Ik aiauk sosop senes owam’ rai ronkatein, utianik, ak nais keseriar omre karar opokan aiauk oin. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Ak kiro aiauk oianik, woi atak ro pak korkorurianik, ak keser aurin, ‘Kiro roat ak ruris pote, sarau eteinak moin. Ik taperar pote, sarau momun sanas atap pakakaikowon. Utianik, ik aiauk näwäu ikau wa. Kiro roat aiauk oin senek ik nais kesekur ikom.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Keser äiena, kiro woi atak ros kar sarau ro keser auruwon, ‘Jai, is na sät aisau wa. Is na pak ämän ateanik, aisomin, na okoro omre karar opok sarau mota, is omre karar opokan aiauk isam, keser aisoita, naka io rai airomon. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Rusapai na nan aiauk oinam, nan mena ute man. Kiro ro ko ruris koi sarau mowon ko nais na oumon siar nuraurim. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Okoro isan aiauk, okon, isakasar ronkateanik, kiro onok keserim. Is kiro onok eposek keserim, owon na won aru mom?’” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Keseria, Jisas nukas äiewon, “Kiro roat ak enmak näwäu wa ruris rai ak amke rawaiei. Amke rai roat ak enmak orip ak ruris rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jisas kon tamareäu roat 12 orip ak erek Jerusalem mena pote pote rai, kos ämän ämäi awarowon, ");
INSERT INTO bbr2013_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ak isan ämän rowe! Rusapai ik Jerusalem mena potota, kiro pakan roat akas Ro Nukan Mokoi Anut kamuk raiäi roat näunäu pak, sintore ämän tamareäi roat pak, akan ipiak opok maiei. Kiro roat akas akan ämän roianik, wena, meiäun ämän ataiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Akas ko karauk omsau pakan roat akan ipiak opok mona, kiro roat akas ko jeje ämän auria, mänkäsi oumana, am äpäs opok äsäi mona, meiäi. Utianik, omre 3 opok Anut nukas ko ätäi siräi mai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Utianik, kiro ses opok, Sebedi nukan waus kon mokoit ori Jisas siakup imwate koia, ko kar osapun totoraurwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisas nukas kiro asir auruwon, “Na owo osap owam?” Kiro asires ätäi keser auruwon, “Na is pak paip keser mam. Isan mokoit ori okoro tawa awas na kamwaraun ro näwäu sareta, kar mokois ipon näu kaima tanäi, kar mokois ipon saunan kaima tanäi, au na pak rawaieir.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ko keser äienuk, Jisas nukas ätäi awarowon, “Kiro ämän totoiroi kon onoktapau ak äpu mau wa. Is kiro an kap opok rau jam, au kiro an jaun itok ra?” Kiro mokoit ories ätäi auririn, “Iu kiro an jaun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisas nukas kiro mokoit ori ätäi awatowon, “Kiro epar, au isan kap pakan an jaurir, utianik, inok ro ko isan ipi näu kaima tone tanäi, inok ro ko ipi saunan kaima tone tanäi, kiro isan sarau wa. Isan Monias karauk roat akan omoi jekur marowon rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jisas nukan karauk tamareäu roat 10 orip akas kiro ämän roianik, ak kiro mokoit ori mesin kasiaka pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisas nukas kon tamareäu roat awaronuk, ak koi erekapu tururna, kos keser awarowon, “Ak äpu kiro omnokoupaian roat akan karauk kamwareäin roat näunäu akas akan enmak rorormoi, akan roasiret kamwareäi. Roasiret akan roat näunäu akas roasiret akan ämän tainoraun sakau ämän awareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ak isan roat ak kiro onok wa keserau. Utianik, kar ros akan näwäu rawam äienuk, kiro itok, amke ko akan sarau ro rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kar ros ‘is enim jou orip amke rawam’ äienuk rai, kiro itok, amke ko akan sarau ro (slev) senek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Kiro senek, Ro Nukan Mokoi karauk roasiret akas ko isanaraun kowau wa. Wa! Ko karauk roasiret sarwaraun kowon. Ko meieanik, roasiret sosop ätäi Anut nuka rawa imware tonai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisas kon tamareäu roat pak Jeriko mena potona, roasiret sosop akas tainware potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Amiawa utup ro oirori au apu kasakup tane rairin. Au Jisas pe itimwate manaurnuk, ämän roianik, awas keser ur weirin, “Näwäu, na Devit nukan Mokoi, na iwenun wonti mutoinam, iu sareit.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Roasiret sosop akas kiro ro ori kewateanik, ur uter rai sakau näu awatoin. Utianik, au akan ämän rowau wa, au kakapar sakau ur weanik, keser äieirin, “Näwäu, na Devit nukan Mokoi. Na iwenun wonti mutoinam, iu sareit.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jisas ko tai raianik, kiro roat ori urwatomara, awatowon, “Is au owoswataun airoir?” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Kiro roat ories ätäi auririn, “Näwäu, na iwen amiok uräre mutota, iu om aparamur.” ");
INSERT INTO bbr2013_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jisas ko kiro ro orien wouti momara, ko awan amiak ipous atonuk, kiro ses opokar awan amiak urärenuk, ätäi apu aparirin. Keseria, au ko tainori manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Jisas ko kon tamareäu roat pak Jerusalem näu mena potaun pote rai, Betfasi mena Olivet omtorou opok potomana, Jisas nukas kon tamareäu ro oirori äsimwatomara, awatowon, “Au enro mena eteinak opok potea, opur donki kon nak pak muris pararar moin rair aparinair, mur uräinäir, kiro donki nak orip is siarap imäi kower. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Utianik, kar ros au totwatonuk rai, kiro donki atak ro keser aurwer, ‘Kiro donki kon nak ori iken Näwäu, ko au pak sarau orip.’ Keseria, ko kurte au äsimwatonuk, kowaieir.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Kiro onok kar Anut nukan ämän roianik, areäwon ro nukas ämän äiewon kiro erekapu peu. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ak Saion* roasiret keser awaraiei, ‘Akan omsau kamwaraun ro näwäu kou. Ko nukasar kon enip wa rororiäu, ko donki opok taneanik, kou.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Keseria, Jisas nukan tamareäu ro ories kon ämän awatowon siar keseririn. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Keseria, au donki nak Jisas siakup imäi koianik, awan omjo rumukäu donki nukan mekesu opok puris rue mosa, Jisas nuka oik tone tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Karauk roasiret sosop akas akan omjo oianik, apu opok puris rue potoin. Karauk roasiret akas ukumai pisau senek patir okukureanik, apu opok puris rue potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Keseria, karauk roasiret akas Jisas kamuk mianik, amke potoin. Karauk roasiret akas ruris tainoria, keser ur we we potoin, “Devit nukan Mokoi enip oik jou murau. Kiro ro ko Näwäu nukan enip pakas kou, jou murau, Anut nukan enip karar oik jou murau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisas ko Jerusalem näu mena tononuk, kiro menan roasiret akas ko aparianik, karkairmoi, keser äiein, “Kiro ro inok?” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ko pak erek potoin roasiret akas keser awaroin, “Ko Jisas, Anut nukan ämän roianik, areäu ro. Ko Nasaret mena Galili provins pakan.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisas ko Anut osap nuriäi ou näwäu tempel owa toneanik, roasiret ak osap kau momana, amuk we rain opokan Jisas nukas emwaronuk, erekapu manoin. Ko roat akan aiauk amuk we oiäin patan pak ainak moi rain bokis pak oianik, känkukurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Kos kiro roat awarowon, “Anut nukan ämän jer we moin rau, ‘Isan osap iriäi ou näwäu kiro roasiret akas is pak airäun ou äiäiei.’ Utianik, rusapai akas päu roat akan ämäi rawaun omoi senek sare moi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisas ko Anut osap nuriäi ou näwäu owa raunuk, karauk roat amiak utup pak isorak aru pak ko siakup kouna, kos jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","16","Mokoit akas kiro owa raianik, keser ur wein, “Devit nukan Mokoi kon enip rororau.” Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak ak Jisas nukas karauk kurur atap mowon aparianik, kiro mokoit akan ämän roianik, woiaka aru monuk, akas Jisas keser totorin, “Na kiro ämän arei roum ra?” Jisas nukas ätäi awarowon, “Io. Is roim. Utianik, ak Anut nukan ämän kiro wa ninareäi ra? ‘Na mokoit pak karauk mokoit eteinak apur jeäi pak kosar ämän ätär maronuk, akas nan enmat eposek senes roror musaiei.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jisas ko kiro roat utwareanik, näu mena ute pote, ko Betani mena ninowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Jisas ko kon tamareäu roat pak ak tapera senes ätäi näu mena kowaun koirai, Jisas ko sou wewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ko apu kasakup kar am uran senek aparianik, siakup potowon. Utianik, kiro am nemauk murau wa, ko käwäu sapai raunuk, aparwon. Keserianik, kos kiro am auruwon. “Na nemauk ätäiar wa muram. Wa senes.” Kos keser aurnukar, kiro am kurte kusakusaiwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Kon tamareäu roat akas kiro onok aparmoi, karkairianik, akas keser äiein, “Kiro am owose kurte rurneu?” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jisas nukas ätäi kon tamareäu roat awarowon, “Is ak epar senes awarom, akan woiaka epar mianik, ak ronkat oirori wa owaiei, is kiro am keserim senek, ak nais kir keseraiei. Utianik, ak kiro onok karar wa keseraiei. Wa senes! Ak enro omtapau auraiei, ‘Na siräunam, an unik uru pitikänir nam!’ aurna, ko keserai. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Keseria, ak akan woiaka epar mianik, owo onok Anut nukas keseraun auraiei, ko kiro onok keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisas ko ätäi Anut osap nuriäi ou näwäu owa tonea, roasiret Anut nukan ämän tamare raunuk raunuk, Anut kamuk raiäi roat näunäu pak karauk ämän tamareäi roat pak ak ko siakup koianik, ko totorin, “Na owo sakau oianik, kiro onok keseriäum? Inos kiro sakau na isowon?” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jisas nukas ätäi kiro roat awarowon, “Isas pak kar ämän totwaraurim. Akas amke isan ämän onoktapau kiro totwaraurim airona, isas pak is owo sakau pakas kiro onok keseriäim kiro onoktapau ak awaram. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","An jomareäwon ro, Jon, kon sakau erapakas kowon? Kiro sakau Anut nukas nuruwon ra, ara kar ro nukas kiro sakau nuruwon ra?” Ak kiro ämän roianik, aka aka areanik, äiein, “Ik ko owo räi aurau? Ik ko Anut nukan sakau pakas an jomareäwon äieta, kos aikai, ‘Keseria, ak owon akan woiaka epar mau utoin?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Utianik, ‘Kon sakau kiro ro nukas nuruwon,’ keser aurta, roasiret akas ik owoseikaiei rai iminewaroin. Owon, ak Jon ko Anut nukan ämän roianik, areawon ro keser sakau ronkateäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Keseria, akas Jisas ätäi aurin, “Ik äpu wa.” Kos ätäi kiro roat awarowon, “Is nais, inokos is sakau ironuk, kiro onok keseriäim ak wa awaram.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisas nukas ätäi awarowon, “Akan ronkat owo senek? Kar ro ko mokoi oirori orip. Kiro ros kon urek mokoi pote, auruwon, ‘Mokoi, rusa na wain woia pote sarau mo.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Kiro mokois ätäi kon momok auruwon, ‘Is woia manau utom.’ Keser äiewonus, ko ätäi ronkat oianik, woia pote sarau mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Kiro ros kon etei mokoi keseriar pote, auruwon, ‘Na nais wain woia pote sarau mo.’ Kos ätäi auruwon, ‘Io, moni, is manam.’ Utianik, ko keser aurianik, ko woia manau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kiro ses opok, owo mokois kon momokun ämän tainoru?” Roasiret akas keser äiein, “Urek mokois kon momokun ämän tainorwon.” Keseria, Jisas nukas kiro roat awarowon, “Is ak epar senes awarom, takis aiauk oiäin roat pak apu pakan asiret pak ak amke Anut nukan roasiret sarei. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","An jomareäwon ro, Jon ak opok koianik, apu eposek ätär marowon, ak konun akan woiaka epar mau wa. Keserna, takis aiauk oiäin roat pak apu pakan asiret pak akas akan woiaka konun epar moin. Ak kiro roasiret akan onok apwareanik, akas akan onok aru pakan ätäi wa piririanik, konun woiaka epar wa moi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisas nukas awarowon, “Ak kar totok ämän rowe. Kar ro ko omnokou näwäu orip, ko wain woi momara, wain uku weanik, porim wate mowon. Kiro woia wain nemauk äsisiraun up tuweanik, woi kamäun ou rumukäu kämioik mowon. Woi erekapu jekur raunuk, karauk roat kon woia sarau maun kau mareanik, sarau mona mona, kiro woi atak ro nuka ko kar mena atapuk manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Wain nemauk murunuk, owaun ses kounuk, kiro woi atak ros kon karauk sarau roat awaronuk, ‘Karauk wain nemauk owaun kiro woi kumeäin roat rai opok potowe,’ keser awaronuk, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wain woi kameäin roat akas kiro sarau roat 3 orip sakau atwareanik, kar ro wena, manowon, kar ro wena, meiewon, kar ro ko aiaukus wena, meiewon. Ak keserna, ");
INSERT INTO bbr2013_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","kiro woi atak ros ätäi kon sarau roat sosop äsimwaronuk, ak wain woi kameäin roat siarakap potoin. Kiro roat akas sarau roat 3 orip amke akwaroin siar, kiro sarau roat sosop ak nais kir akwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Keserna, kiro ros nukan mokoi senes äsimornuk, kiro roat rain opok potowon. Momokus keser ronkatewon, ‘Ak isan mokoin ämän roumoi, wa aru muraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Utianik, kiro woi kameäin roat akas woi atak ron mokoi kounuk, aparianik, ak keser äiein, ‘Kos kon momok meienuk, kon osap erekapu owai. Ik ko weta, meienuk, kon wain woi ik owam. Kiro ik keseram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Keseria, ak kiro mokoi wain woian imäi neanik, woi kasakupai wena, meiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisas nukas roat rain awarowon, “Akan ronkat owo senek? Woi atak ro ko wain woia koia, kiro woi kameäin roat owosewarai?” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Akas ko aurin, “Kos kiro aru roat erekapu akware kureanik, ko ätäi karauk roat ak kiro wain woi kamäun imwarai. Tawa kiro wain murunuk, owaun ses opok kiro wain woi kamäiei roat akas woi atak ro karauk wain nemauk nuraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisas nukas ätäi awarowon, “Ak Anut nukan ämän kiro äieu ninareäi ra? Kiro ou tutu ou miäin roat akas aru äumoi, sauk moin. Rusapai, kiro ou tutu kamuk opokan ou tutu sakau eposek sarewon. Näwäu nukasar kiro tutu sarau näwäu nuruwon, kiro eposek senes ik aparum.” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jisas nukas kiro roat awarowon, “Meter Anut nukas ak kamwareäwon, rusapai Anut nukas ak utwareanik, karauk roasiret ak kon sarau eposek muriäi kos kiro roasiret kamwarai.  ");
INSERT INTO bbr2013_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Inok roasir kiro tutu opok siotorai, kiro roasir erekapu pitpatir, usipnirnaräi. Kiro tutus kar ro opokup nonuk, kiro ro ko maimai senek saräi.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Anut kamuk raiäi roat näunäu pak Parisi roat pak akas Jisas nukan totok ämän roianik, ak äpu moin, ko akan onok mesin äieu. ");
INSERT INTO bbr2013_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Keseria, akas kipakar Jisas sakataurin. Utianik, ak äpu roasiret akas Jisas ko Anut nukan ämän roianik, areäu ro rai ronkatein, okon, ak roasiret iminewaromoi, utoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisas nukas totok ämän pakas roasiret keser awarowon, ");
INSERT INTO bbr2013_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Anut nukas kamwareäu onok kiro kesek. Kar omre opok kamwareäwon ro näwäu king nukas kon mokoi asir owaurnuk, o makaurwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Keseria, kon sarau roat äsimwaronuk, pote kiro roat kos meter awarowon, awarianik, imware koi ak kon o makai opok kowaiei. Utianik, ak kiro roat awaroin kowau utoi. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Keserna, kos kon karauk sarau roat sakau ämän orip äsimwareanik, awarowon, ‘Is ruris o makaurim. Isan bulmakau sawai pak opur sirau orip erekapu weanik, mis momin. Ak asir owaun o makomin opok kowe.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Utianik, kon sarau roat äsimwaronuk, ak pote kiro ämän awarona, kiro roat akas akan ämän rowau wa, ak akan sarau opok atap atap manoin. Kar ro ko kon woia potowon. Kar ro ko kon stua opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Karauk roat akas kon sarau roat sakatwareanik, jeje ämän awaromoi, akwarona, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Keserna, kamwareäu ro näwäu king ko kasak penuk, kon marai roat äsimwaronuk, pote kiro roat erekapu akware kureanik, akan näu mena episai makoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","9","Keseria, kos kon karauk sarau roat awarowon, ‘Is asir owaun o makomin. Utianik, is roasiret awaromin ak koi o jau utoi, okon, ak näu apu opok potoinai, roasiret sosop apwareanik, awarona, o makam opok kowaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kos keser äienuk, kon sarau roat akas apu opok erekapu pote roasiret eposek pak aru pak erek awarona, kon o jaun owa erekapu koi ok pe rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Keserna, kamwareäu ro näwäu ko kiro owa tonea, kar ro ko omjo eposek orkäu wa aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kiro omsau kamwareäu ro näwäu nukas kiro ro keser auruwon. ‘Jai, na owon omjo eposek orkäu wa, na okoro owa pemon?’ Utianik, kiro ro ko aräu wa, ko äpik rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Keseria, kiro ro näwäus kon sarau roat awarowon, ‘Ak kiro ron isou ipou pak, muris parararnai, kasik oi känkurena, ko pututu wai rai aukpanak kartitir rawai.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jisas nukas keser äiewon, “Anut nukas roasiret sosop ko siakup kowaun urwareäu, utianik, ko roasiret sosop wa sare mareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kiro ämän äiewon roianik, Parisi roat akas kasik nemana, aka aka Jisas atonoraun ämän atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Keseria, akas akan karauk tamareäi roat pak Herot nukan ämän tainoriäi roat pak ak Jisas rawa äsimwarona, koin. Ak koianik, keser aurin, “Tamareäum ro, ik äpu na epar ämän areäumon ro. Na ro akan ronkat wa roiäum. Enmak orip roat karar na wa apwareäum. Na Anut nukan ämän epar senes ik ätär mukiäum. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Keseria, nan ronkat owo senek? Ik takis aiauk Sisa nuram ra utau? Nas ik aikam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisas ko nuka ate aparaun ämän moin äpu momara, kos ätäi awarowon, “Ak sätäiäi roat, ak owon is ate aparoi? ");
INSERT INTO bbr2013_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ak kar takis miäi aiauk oi ätär murona, is aparam!” Akas kiro aiauk oi koi nurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Kos totwarowon, “Okoro aiauk opok enip totok orip inokon?” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Akas ätäi aurin, “Sisa* nukan.” Keser aurna, Jisas nukas ätäi awarowon, “Keseria, ak Sisa nukan osap kiro Sisa nuraiei. Anut nukan osap, kiro Anut nuraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ak kiro ämän roianik, ronkat sosop oumana, ute manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Kiro omre opakar, Sadusi roat akan ronkat kesek, roat meieäi, ätäi wa siräiäiei rai äiäi, akas Jisas siakup pemana, keser totorin, ");
INSERT INTO bbr2013_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tamareäum ro, meter Moses nukas keser äiewon, ‘Kar ro ko asir oumara, kon wau mokoi wäpik meie ute manonuk, kon amakus pak awakun wäimäs oumara, mokoi mai, kiro mokoi awak meiewon nukan mokoi senek saräi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Utianik, kar muti kar ro kon mokoit orip. Mokoi urektapau asir oumara, ko mokoi wäpik meiewon. Keseria, kar amunakas kon wäimäs owon. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ko nais mokoi wäpik meiewon. Keseriar pote, kiro roat 7 orip akas kiro asir oin, erekapu mokoi wäpik erar meiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Keserianik, kiro wäimäs asir rawonus, ruris meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kiro asir roat 7 oripas oin, tawa meiein roasiret ätäi siräiäiei ses opok, kiro asir inon tuku rawai? Omnokou opok, kiro roat 7 orip meiein akas kiro asir karar oin.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Keser aurna, Jisas nukas ätäi keser awarowon, “Ak Anut nukan ämän pak kon sakau pak ak äpu wa. Keseria, ak sätäpu roat senes! ");
INSERT INTO bbr2013_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Roasiret meiein ätäi siräianik, ak Anut nukan sarau eitek omar oik rai senek rawaiei. Ak wa ouratäiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Anut nukasar meiein roat ak ätäi siräiäiei rai äiewon. Ak kiro ämän ninareäi ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Is Apraham, Aisak, Jekob akan Eit.’ Anut ko roat meiein akan Eit wa, ko roat orip orip awau raiäi akan Eit.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Keser awaronuk, roasiret ak kon ämän eposek roianik, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jisas nukas kiro ämän Sadusi roat awaronuk, ak ätäi aräu senek wa. Kesernuk, Parisi roat ak kiro ämän roumoi, tururianik, ");
INSERT INTO bbr2013_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Parisi ro kar sintore ämän tamareäu ro nukas Jisas ate aparaun keser totorwon, ");
INSERT INTO bbr2013_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tamareäum ro, owo sintore ämän kiro näwäu senes?” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Kesernuk, Jisas nukas ätäi auruwon, “‘Na nan won pak nan totomat pak nan ronkat pak nan Näwäu, Anut nukanun erekapu meie.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kiro sintore ämän epar mäwäu senes, amke rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Kar sintore ämän näwäu kiro kon onok kesek. ‘Na nakanun meieäum senek, nan jaunan keseriar meie.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Moses nukan sintore ämän pak Anut nukan ämän roianik, areain roat akan ämän pak kiro sintore ämän näwäu oirori opok sakau miäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jisas nukas karauk Parisi roat ko siakup koi turur rauna, kos totwarowon, ");
INSERT INTO bbr2013_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Akan ronkatis Krais ko inok äiäi? Ko inokon mokoi?” Akas ätäi ko aurin, “Ko Devit nukan Mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jisas nukas ätäi awarowon, “Owose Osou Näus Devit ronkat nurunuk, kos Krais kon Näwäu äiäwon? ");
INSERT INTO bbr2013_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Devit nukas äiewon, ‘Anut Näwäu nukas isan Näwäu auruwon, “Na isan ipi näu kaima taneta, isas nan iwäi jaunat erekapu itimwareanik, nan isonap mareita, nan inkaruru rawaiei.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Devit nukasar ‘Krais ko isan Näwäu’ äiewon. Keseria, owose ak Krais ko kon mokoi äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Keseria, kiro omre opokas pote, kar ros Jisas karauk ämän aurau wa, ak ko sakau imineanik, kar ämän totorau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Keseria, Jisas nukas roasiret pak kon tamareäu roat pak ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ko keser awarowon, “Tamareäi roat pak Parisi roat pak akas ak sintore ämän tamareäi, kiro Moses nukan sintore ämän senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Keserianik, ak kiro ämän arorai ak roianik, erekapu tainorwe. Utianik, akan onok keseriäi, ak kiro wa tainorau. Owon? Ak erar ämän sosop miäi, utianik, aka kiro ämän wa tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Akas usu sosop roasiret arona, ak kiro usu oi kuräu senek wa. Utianik, kiro usu roasiret ariai ak ätäi wa sarwareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ak owo onok keseria, kiro erekapu keserna, roasiret akas apaikaun rai keseriäi. Ak roat apwaraun räi, ak karauk Anut nukan ämän kar pepa eteinak opok jer weanik, akan oioraka, ipiaka opok muris rakir miäi. Ak akan Anut auraun omjo opok mer eposesek mako muriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Keseria, ak o jeäi owa pak tururiäi owa pak omoi eposek eposek opok amke tanäun akan woiaka meiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ak akan ronkat kesek roat akas amket opok, ‘pere,’ awareanik, ipiak atomoi, ‘Tamareäi roat,’ keser awarona, akan woiaka näu sareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Utianik, ak isan tamareäimin roat, karauk roat akas ak tamareäi roat rai keser wa awaraiei. Ak erekapu tupsiu karar. Akan tamareäu ro karar. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Keseria, ak kar onkapan ro ‘Moni’ rai wa aurau. Akan Momonaka karar ko omar oik rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Karauk roat akas ak ‘iken kamoikeäi roat’ keser wa äiäiei. Akan kamwaraun ro kiro is karar Krais. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ak kamuk opok, inok ro näwäu saräun ko akan sarau ro senek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Inok ro nukasar kon enip rororai kiro ron enip Anut nukan amukup näwäu wa saräi. Inok ro ko nukasar kon enip wa rororai, kiro ro kon enip jou orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Jisas nukas ätäi äiewon, “Ei! Ak sintore ämän tamareäi roat Parisi roat pak. Ak wopurut! Ak sätäiäi roat! Anut nukas roasiret kamwaraun apu akas soriäi. Ak akasar kiro opok wa toneäi. Utianik, roasiret kiro opok tonauri keseriäi, akas akan apu tonaun sor rai.  ");
INSERT INTO bbr2013_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ei! Ak sintore ämän tamareäi roat Parisi roat pak, ak wopurut! Ak sätäiäi roat. Ak wäimäs asiret atonwareanik, akan owan osap erar oi maneäi. Karauk roat akan amiakap nais ak Anut aurianik, ämän rumukäu miäi. Keseria, tawa Anut nukas koi wasarewaraun ses opok, ak usu näwäu senes owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ei! Ak sintore ämän tamareäi roat, Parisi roat pak, ak wopurut, ak sätäiäi roat. Ak mas an siakup pak omnokou opok pak erekapu arianik, kar ro akan onok tainoraun rai itaneäin. Ak kiro ro akan onok tainoraun itanein, ko akan onok aru erekapu tainormara, ko ep wa koseriäu uru nai, aka naiei senek nai. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Ei! Wopurut! Ak amiaka utup roat. Akas karauk roat apu ätär mareäi. Keseria, akas keser ämän areai, ‘karauk roat ämän awareanik, akas Anut osap nuriäi ou näwäu nukan enip ateäi, kiro ämän sakau wa. Utianik, ak aiauk gol owa rau nukan enip ateäi, kiro ämän epar sakau orip, ak kiro ämän jekur tainoriäi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ak otop, ak amiaka utup roat! Owo osap kiro näwäu senes? Anut osap nuriäi ou kiro näwäu ra, aiauk gol nukas ou ate miäin kiro näwäu ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Kar ämän akas keser äiäi. ‘Utianik, kar ros ämän areanik, opur amkeäi patan nukan enip atai, kiro ämän sakau wa, kiro wa tainorau. Utianik, kar ro ko opur amkea, patan opok kar osap oik raunuk, kon enip atai, kiro ämän epar sakau saräi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ak amiaka utup roat! Owo osap kiro Anut nukan amuk opok näwäu? Anut nukan opur amkeäi patan ra, kiro osap patan opok rau ra? Osap kiro opur amkeäi patan opok rau, kiro patanis kiro osap eposek sareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Keseria, kar ro kon ämänis sakau mianik, ko opur amkeäi patan nukan enip atai, ko erekapu osap patan opok rau akan enmak erek ateäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Utianik, kar ro ko Anut osap nuriäi ou näwäu nukan enip ateanik, kon ämän kiro sakau mai, ko kiro ou nukan enip pak Anut owa rau nukan enip pak erek ateäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Utianik, kar ros omar enip ateanik, kon ämän sakau mai, ko Anut nukan taneäu patan pak Anut nuka patan opok tane rau awan enmawa erek ateäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ei! Ak sintore ämän tamareäi roat, Parisi roat pak, ak wopurut! Ak sätäiäi roat! Akan woian onin eteinak karar karar 10 orip inäianik, surwate mianik, karar sur oi Anut nuriäi. Utianik, ak karauk sintore ämän näwäu kiro utomoi, wa tainoriäi. Kiro sintore ämän ak tainorau wa kiro onok kesek: ak karauk roat pak onok eposek wa miäi. Ak karauk roat akanun woiakati wa miäi. Ak karauk roat jekur wa kamwareäi. Ak kiro onok eposek näwäu erekapu tainori rai, epar ak karauk onok eteinanak erek tainoraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ak amiaka utup roat! Ak keseria, kamkeris akan o ur opok naurnuk, ak kiro emeriai. Utianik, opur kamel näwäu ak o ur orip nikateäi. Ak sintore ämän eteinanak tainoriäi, utianik, ak sintore ämän näwäu wa tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ei! Wopurut! Ak sintore ämän tamareäi roat, Parisi roat pak, ak sätäiäi roat! Keseria, ak akan kap pak maro pak oi mekesupan an kosoriäi. Utianik, ak onok aru sosop miäi, okon, akan woiaka uru ukun sosop rau, ak kiro wa kosoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ak Parisi roat, ak amiaka utup! Ak amke akan kap wou uru ukun rau kiro kosoria, ätäi kasikan enipsau opok kosorna, kiro ukun wäpik eposek saräi! ");
INSERT INTO bbr2013_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ei! Wopurut! Ak sintore ämän tamareäi roat Parisi roat pak, ak epar sätäiäi roat! Ak op up opok mer eposek amke muriäi senek, kiro mer roat akas apariai kiro eposek senes. Utianik, up uru op nuka poomreanik, sou aru rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Kiro keseriäu senek akan onok nais kesekur, roasiret akas apwareanik, ‘ak roat eposek’ äiäi. Utianik, akan woiaka uru ak onok aru senes mia, sät ämän areai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jisas nukas ätäiar awarowon, “Ak sintore ämän tamareäi roat Parisi roat pak, ak wopurut! Ak sätäiäi roat. Keseria, ak Anut nukan ämän roianik, areain roat akan up opok patan eposek käi miäi. Ak roat akan woiaka epar moin, akan up opok mer eposek amke mareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Utianik, ak keser äiäi, ‘Ik iken asonokot pak meter erek raumun senek maro, ik kiro roat wa akwarowom.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Akan ämänisar aka ätäi amop marou, ak akan momonakat akas meter Anut nukan ämän roianik, areain roat akwarona, meiein ak akan mokoit. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Keseria, akan momonakat akas keserin siar, ak nais keseriar karauk Anut nukan ämän roianik, areai roat akwarona, meiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ak män aru nukan mokoit! Anut nukas ep wa koseriäu opok kurwarnuk, ak owose imine manaiei? ");
INSERT INTO bbr2013_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Is epar senes awarom, ak rowaiei, isas Anut nukan ämän roianik, areai roat pak ämän tamareäi roat pak äsimwaroita, ak rai opok kowaiei. Akas karauk roat akwarona, meiäiei. Karauk roat am äpäs opok äsäiware mona, meiäiei. Karauk roat akan tururiäi owa mänkäsi owaraiei. Karauk roat akas emwarona, imine pote kar näu mena potona, ätäi kiro pakan emwarona, kar näu mena potaiei. Ak keser keser ari rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Keserianik, karauk roat akas meter roat woiaka epar moin akwarona, meiein, kiro usu ak opok päi. Abel ko onok eposek miäwon ro wena, meiewon, keseriar pote Sekaraia, ko Berekia nukan mokoi kir keserin. Ak Sekaraia Anut osap nuriäi ou näwäu pak jou miäi patan kamuk opok wena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Is ak epar senes awarom. Kiro onok meter akan askanai akas keserin mesin ak rusapaian roasiret ak kiro usu näwäu owaiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisas nukas Jerusalem mena aparmara, äiewon, “O, Jerusalem, Jerusalem! Akas Anut nukan ämän roianik, areain roat akwarona, meiein. Ak karauk roat ämän oi ariain roat Anut nukas äsimwarowon, aiaukus akwarona, meiein. Is omre sosop, kakarau anak nukas kon nakut saus kururware raiäu senek, isan ipias roasiret kamware rawaurimin. Utianik, roasiret akas is ak kesewaraun wa utoiroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ak rowe, Anut kon osap nuriäi ou ute manonuk, kiro ou erekapu aru saräi. ");
INSERT INTO bbr2013_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Is ak epar senes awarom, rusapai is manoita, ak is ätäi wa apairaiei, pote tawa, akasar keser äiäiei, ‘Anut nukasar kiro ro sare mai, ko Näwäu nukan enip pakas kowai.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisas ko Anut osap nuriäi ou näwäu enip tempel owa rawonus, ute ne manaurnuk, kon tamareäu roat akas koianik, aurin, “Na okoro ou jekur aparnam man.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kos ätäi keser awarowon, “Kiro itok, ak osap erekapu apari. Utianik, is ak epar senes awarom, iwäi jaunakat akas koia, kiro ou erekapu aru maiei. Kiro ou moin aiauk erekapu uräi naiei. Kar aiauk kon omoi wa rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Keserianik, Jisas ko Olivet omtapau opok pote tane raunuk raunuk, kon tamareäu roat akarar ko siakup koianik, akas ko keser totorin, “Esepa kiro onok päi? Na ik aikota, rowam, owo onok amke penuk, ik kiro omre äpu mam?” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kos ätäi awarowon, “Ak sakau tai rawe. Karauk roat akas pemana, ak sät ämän awaraiei. Ak kiro akan ämän wa rowau. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Karauk roat akas pemana, isan enim ateanik, keser äiäiei. ‘Is Krais is ak ätäi imwaraun ro pem.’ Roat sosop akas kesek ämän roianik, epar äiäiei. Ak, isan tamareäim roat, ak kiro roat akan ämän wa tainwarau. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Utianik, ak amke marai kowai ämän pak marai jejep pak siarakap kounuk, roumoi, ak wa karkairau. Kiro onok epar amke päi. Utianik, wasarewaraun ses kiro kurte wa pekeräi. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kar omsau pakan roasiret akas siräianik, kar omsau pakan roasiret pak iwäi muratäianik, weräiäiei. Karauk omsau opok mim päi. Karauk omsau opok roasiret sou om rumukäu rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kiro onok erekapu päi kiro kon onok kesek, kar asir ko mokoi owaun amke tätäi näwäu oiäu senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Keseriar, kiro ses opok ak isan tamareäimin roat akan iwäi jaunakat akas sakatwareanik, usu näwäu aromoi, akwarona, meiäiei. Omnokou pakan roasiret erekapu akas akanun kasiaka peanik, sauk maraiei. Ak isan tamareäimin roat, okon, ak roasiret akas kesewaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Roasiret sosop akan woiaka epar moin, kiro ses opok akan woiaka epar moin utaiei. Kesermana, aka aka akan jaunakat pak iwäi muratäianik, ak imwareanik, akan iwäi jaunakat akan ipiakap maraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ak keserna keserna, Satan nukan ämän roianik, areäi roat akas peanik, roasiret sosop sätwarona, ak akan ämän tainoraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ak kiro onok näwäu sarenuk, roasiret sosop akan jaunakat akanun woiakati miäin, ak kiro onok eposek utaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Utianik, inok ro isan sarau wa utai, ko orip orip sakau me rawai tawa wasarewaraun ses opok, Anut nukas ko ätäi imäiai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Roasiret akas Anut nukan Ämän Eposek omsau erekapu roasiret awarona, roasiret ak kiro ämän äpu momoi, roi rauna rauna, epar kiro wasarewaraun ses kowai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisas nukas ätäi äiewon, “Ak kar osap aru senes kiro meter Anut nukan ämän roianik, areawon ro Daniel nukas arewon päi aparaiei. Kiro osap aru senes peanik, Anut nukan omoi näu eposek opok pe tai rawai. (Ak kiro ämän ninarein raroi, jekur ronkatäiei.) ");
INSERT INTO bbr2013_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kiro ses opok roasiret ak Judia provins opok rai ak omtorou opok imine tonaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Kar ro ko ou oik rawai, ko neanik, kon osap owa rau wa tone owai. Ko kurte erar imine manai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kar ro woia sarau me rawai, ko kon mer eposek owa rau koi wa owai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kiro ses opok, asiret ak amaiwo orip pak asiret mokoit apur jerai orip, ak wopuräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ak Anut auraiei, ‘Om nai ses opok ra, iken sumaun omre opok, kiro osap aru kowai wa iminäiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ak kiro usu näwäu meter wa oiäin. Omnokou awau pewon ses opokas koi rusapai rau, tawa nais kesek usu ätäi wa päi. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Utianik, Anut nukas omre rumukäu kurte katu sarewon, owon, ko kiro onok keserau wa maro, roasiret sosop wa rawoi. Ko karauk roasiret imwaraun sarware mowon, okon, kiro onok kurte keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kar ros pemara, keser awarai, ‘Krais okoro pe rau!’ ra, ‘Ko enro rau!’ rai, awaronuk, ak kon ämän roianik, woiaka epar wa mau. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Karauk roat akas pemana, sätäianik, keser äiäiei, ‘Is Krais.’ Karauk roat akas äiäiei, ‘Is Anut nukan ämän roianik, areäim ro.’ Keseria, ak kurur näunäu pak karauk sarau atap atap maiei. Ak karauk roasiret Anut nukas nukan sare marowon, sätwaraurmana, akan amiakap kiro onok keseraiei. Sätwarona, ak Anut nukan roasiret akan onok tainorianik, ak Anut nukan onok utaun rai keseraiei. Utianik, akas kiro onok kesewaraun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Is ak kiro ämän awaromin jekur rowe. Owo onok tawa päun rau pak rusapai pak is ak awarom. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Keseria, karauk roat akas pemana, keser awaraiei, ‘Ro Nukan Mokoi ko ro wäpik mena koi rau.’ Keser awarona, ak wa pote aparau. Kiro roat akas ätäi awaraiei, ‘Ko kowon enro owa ämäi rau.’ Keser awarona rai, ak akan ämän roianik, woiaka epar wa mau. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ro Nukan Mokoi kowaun ses kurte päi, san peäu pakas ermänirmara, nopte san neäu opok nopteäu senek keseriar kowai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Opur meieanik, poomre rawai kiro opok, epsimai sosop kiro opur pomou jaun pote tururaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jisas nukas ätäiar äiewon, “Kiro usu näwäu senes erekapu pe manonuk, san ko pututu senek saräi, keir ko merek wa kuräi, pai omar opokas atere kowaiei. Keserna, omar oikan osap sakau rain erekapu ritratorai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kiro onok kesernuk rai, kar osap omar oikas kounuk, ak äpu maiei kiro Ro Nukan Mokoi kowai. Roasiret omnokou opok rai ak imine wai rauna rauna, Ro Nukan Mokoi omar oik iou pakas sakau näwäu orip arou pakas kounuk, aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Keseria, kos kar Anut nukan sarau eitek aurnuk, parau urwenuk, jejep näwäu saräi. Kos karauk Anut nukan sarau eitek äsimwaronuk, omsau erekapu poteanik, Anut nukas kon roasiret sare marowon, imware koi turware maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas nukas ätäi awarowon, “Am suwaro nukas ak san tawaun onok ätär marai. Keseria, suwaro erekapu käianik, am käwäu awau ätäi tu penuk rai, ak kiro äpu maiei, kiro san näwäu päun ses. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kiro senek tawa kiro onok atap atap penuk, ak äpu maiei, Ro Nukan Mokoi kowaun ses katu sare rau. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Is epar senes awarom, okoro roasiret rusapai rai ak wa meiäiei opok kiro onok keser päi ak aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Omar omnokou pak rau kiro erekapu wasaräieir. Utianik, isan ämän wa wasaräi, orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisas nukas ätäi äiewon, “Kar ros Ro Nukan Mokoi kowaun omre wa äpu mai. Anut nukan sarau eitek nais ak äpu wa. Kon mokoi nuka nais ko äpu wa. Isan moni nuka karar ko kiro omre äpu. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Meter Noa rawon ses opok roasiret akas akan onok atap atap keser rain senek Ro Nukan Mokoi ätäi kowai ses opok roasiret kir keser rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Joi näwäu päu wa opok roasiret ak o je rai, an je rai, ro asir oi rai, ak keser rauna rauna, Noa ko ous uru tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Utianik, ak kiro onok päun ronkatäu wa. Keseria, joi näwäu peanik, kiro roasiret erekapu ämäi marowon. Kiro onok keserin senek ak keserna keserna, Ro Nukan Mokoi ätäi kowai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Kiro ses opok, ro oirori au woia sarau me rawaieir opok sarau eitek akas koi kar ro imäianik, kar ro ute manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Asir oirori au ma rei rawaieir opok, kar asir koi imäianik, kar asir ute manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kesek okon, ak awau tai rawe. Owon, ak akan Näwäu nukan kowaun omre ak äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Utianik, kar ou atak ro kos kar päu ro owo ses pututu pe kon ou uraianik, owa tonaun äpu momara, ko wa ninai, ko awau tai raiäu. Ko kiro ro inikernuk, kon owa wa uräi tonai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ak nais keseriar orip orip jekur kame rawe. Owon? Ro Nukan Mokoi ko sareper kowai, kon kowaun omre ak äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jisas nukas ätäi awarowon, “Inok sarau ro ko ronkat eposek orip ämän tainoriäu? Kiro ro karar kon kameäu ros sare monuk, kos karauk sarau roasiret kamwareanik, akan o are rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Kiro sarau ro ko keserai, kon kameäu ro kounuk, ko nepipirai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Is epar senes awarom, kiro sarau ro ko kon ro näwäus kon osap erekapu kamäun sare murai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Utianik, kar sarau ro ko ronkat eposek wa, ko keser ronkatäi, ‘Isan kamoireäu ro ko kurte kowau utou.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Kesermara, kos karauk sarau jaukut, akwaromara, ko an sakau jemara, rauk käi rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","51","Ko kesernuk kesernuk, kon kameäu ro sareper koumara, mänkäsir oianik, emernuk, sätäiäi roat pak pote raianik, aukpanak kartitirmara, wai rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisas nukas ätäi awarowon, “Anut nukas roasiret kamwaraun omre päi kiro kon onok kesek. Asiret makun 10 orip akas akan lam oianik, kar ro asir awau owon ak pote apu pakan tararmoi, imäiäun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kiro asiret makun 10 orip karaima 5 orip ak akan ronkat eposek wa, karaima 5 orip akan ronkat eposek orip. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kiro asiret ronkat eposek wäpik akas akan lam oi koin, utianik, ak an sosparar owau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Utianik, asiret ronkat eposek orip akas akan lam pakan an botol orip ok pewon oiar koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Kiro asir owon ro ko kurte kowau wa. Kesernuk, kiro asiret 10 orip ak amoswaronuk, ninoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ak ninona ninona, pututu kar ros keser ur wewon, ‘Asir awau owon ro ki kou! Ak apu opok pote tararnai, imäi kowe!’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Asiret 10 orip ak kiro ur roumana, siräianik, akan lam jekurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Keseria, kiro asiret 5 orip ak ronkat eposek wäpik akas jaunakat ronkat eposek orip awaroin, ‘Ik akan lam pakan an mikou rawai ik äräiene mukowe. Iken lam an wäpik, okon, koserauru.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Utianik, kiro asiret ronkat eposek orip akas ätäi keser awaroin, ‘Wa, iken an okoro ak pak itok wa mai, iken lam pakan karar rau. Ak awau stua pakan atapur pote, kau mowe.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Keserianik, kiro asiret ronkat eposek orip wa, ak stua opok an kau maun manona manona, asir owon ro kowon. Asiret ronkat eposek orip ak ko kounuk, aparia, ko pak o jaun owa erek tonoin. Keserna, im pene moin. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Keserna, kiro asiret 5 orip ronkat eposek wäpik ak ätäi koia, keser äiein, ‘Näwäu, Näwäu, na ik im tue muk.’” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Aurna, kiro ros ätäi keser awarowon, “Epar senes, utianik, is ak äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Keseria, Jisas kiro totok ämän aware kureanik, ko roasiret ätäi keser awarowon, “Ro Nukan Mokoi ko kowaun omre ak äpu wa, okon, ak awau tai rawe.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Anut nukas roasiret kamwaraun omre päi kiro kon onok kesek. Kar ro kon ou ute ko kar mena atapuk manaurmara, kon sarau roat awaronuk, ak kouna, kon osap erekapu akan ipiakap marowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ko akan onok aparianik, aiauk atap atap keseriar arowon. Ko kar ro aiauk 5,000 orip nuruwon, kar ro ko 2,000 orip nuruwon, kar ro ko 1,000 orip nuruwon. Kesermara, ko utware manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kesermoi, ko manonuk manonuk, kiro ro ko aiauk 5,000 orip owon ko kiro aiaukus sarau momara, ätäi kar 5,000 kiro sarau pakan owon. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kar ro ko keseriar aiauk 2,000 orip owon ko nais sarau momara, ätäi kar 2,000 owon. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Utianik, kar ro ko aiauk 1,000 orip owon, ko kiro aiauk up tueanik, up uru ämäi monuk, rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Omre sosop manonuk, kiro kamwareäu ro kon sarau roat aiauk arowon, kiro aiaukun ämän jekuraun ätäi kowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kiro sarau ro ko aiauk 5,000 owon ko siakup pemara, keser auruwon, “Näwäu, meter na is aiauk 5,000 iromon, is kiro aiaukus sarau momoi, ätäi kar 5,000 oimin. Okoro apar!” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Kesernuk, kon kameäu ros ätäi keser auruwon, “Na sarau ro eposek. Na sarau eteinak jekur kamemon, okon, is na sarau näwäu opok musoita, na sarau kamäm. Keseria, na is pak pea, nepipir rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kesernuk, kar sarau ro ko aiauk 2,000 owon, ko nais pemara, keser auruwon, “Näwäu, nas is aiauk 2,000 iromon. Na okoro apar. Is ätäi sarau mianik, kar 2,000 oimin.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Kesernuk, kiro kamwareäu ros auruwon, “Na sarau ro eposek. Na sarau eteinak jekur kamemon, okon, is na sarau näwäu opok musoita, na sarau kamäm. Keseria, na is pak pea, nepipir rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kesernuk, kar sarau ro aiauk 1,000 owon ro ko nais pemara, keser auruwon, “Näwäu, is äpu na kurte kasat peäu ro. Keseria, kar ros kon woia o uku weäwon, na kiro pakan o siräi oiäum. Na kar ros kon woia o uku kureäwon, na kiro pakan o jare oiäum. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Keseria, is iminemoi, nan aiauk 1,000 iromon, is kiro aiauk oi pote omnokou uru up tue momin. Nan aiauk okoro apar.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Keser aurnuk, kon kameäu ros kiro sarau ro keser auruwon, “Na sarau ro aru! Na ro wäskupu senes. Kar ros kon woia o uku weäwon, is kon o siräi oiäim ra? ");
INSERT INTO bbr2013_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Keseria, na isan aiauk benk opok murau owon utomon. Is ätäi keser koita, kiro aiauk pak karauk aiauk pak owam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Keser aurmoi, kos karauk sarau roat awarowon, “Ak ko pakan aiauk 1,000 senri oianik, 10,000 orip ro nuraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Kos ätäi awarowon, “Is epar senes awarom, inok ro ko osap sosop orip, ko sarau miäu, kiro ro ko Anut nukas karauk osap sosop senes nurai. Keseria, kiro ro osap sosop orip saräiei. Utianik, inok ro ko osap eteinak orip sarau wa miäu, kon osap erekapu senri owam. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Kiro wäskupu ro aru, ak ko imäinai, kaik känkurena, pututu ne rawaura. Ko roat waianik, aiakpanak kartitir rai pak erek rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Kiro ses opok Ro Nukan Mokoi ko kamwareäu ro näwäu king senek, ko kounuk, Anut nukan sarau eitek pak erek kowaiei. Keserianik, ko kon patan opok taneanik, roasiret wasarewarai. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Omnokoupaian roasiret omsau sau rai, ak erekapu ko siakup kouna, kos karauk roasiret karaima inäi marea, karauk roasiret karaima inäi marai. Roat akas sipsip meme ori kamwareanik, inäi mareäi senek, sipsip karaima inäi mareanik, meme karaima inäi mareäi senek keserai. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kos roasiret woiaka epar moin ak kon ipou näu kaimas marai, karauk roasiret ak woiaka epar mau wa ko ak ipou saunan kaima marai. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Keseria, kamwareäu ro näwäu king nukas keser awarai, “Roasiret isan ipi näu kaima rai, ak isan Monias sare marowon. Meter omnokou päu wa opok, isan Monias nukan kamwareäu mena akan sare marowon, ak owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Kos keser awarai, ‘Is sou raimin, akas is o irona, jemin. Is an pätirwon, akas is an irona, jemin. Is kar menan ro senek koimin, akas akan owa imäiri tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Is omjo wäpik, erar raimin, akas omjo irona, takemin. Is sip raimin, akas koi kamoiroin. Is karapus owa raimin, akas pote apairoin.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Kos keser awaronuk, roat eposek akas ätäi ko keser auraiei, ‘Näwäu, esepa na sou raumon, ik na o isomun? Esepa na an pätisonuk, ik na an isomun? ");
INSERT INTO bbr2013_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ik owo ses opok na kar menan ro senek apaisianik, iken owa imäisi potomun? Esepa ik na omjo wäpik raumon apaisianik, omjo isomun? ");
INSERT INTO bbr2013_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Na owo ses opok sip raumon ra karapus owa raumon, ik pote apaisomun?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ak keser aurna, kiro kamwareäu ro näwäu king nukas ätäi awarai, ‘Ak epar senes awarom, ak isan kar ro kon enip näwäu wa, ak ko sarein, kiro ro karar sarau wa, ak kiro is sareiroin.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Keserianik, kos kiro roasiret kon ipou saunan kaima rain, keser awarai, ‘Ak euruwe, Anut nukan amuk opok ak ämän näwäu orip. Ak ep wa koseriäu opok pote. Kiro ep isan monias Satan kon sarau eitek pak erek sare marowon kiro opok ak erek ne rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Kiro owon, is meter sou iworowon ak is o irau wa, is an pätirwon, ak is an irau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Is kar menan ro senek koimin, akas akan owa imäiri potau wa. Utianik, is omjo wäpik raimin, akas kar omjo irau wa. Is sip orip raimin akas kamoire rawau wa. Is karapus owa raimin ak is pote apairau wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Keser awaronuk, akas ko ätäi auraiei, ‘Näwäu, na esepa sou raumon ik apaisomun, na esepa an pätison, na esepa na kar menan ro senek koumon, na esepa na omjo wäpik raumon, na esepa sip orip raumon, na esepa karapus owa pote raumon, ik na sareisau wa?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Kiro kamwareäu ro näwäu king nukas ätäi ak keser awarai, ‘Is ak epar senes awarom, ak isan kar ro kon enip näwäu wa, ak ko saräu wa, kiro ak is saroirau wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Keseria, kiro roasiret ak ep näwäu wa koseriäu opok ne rawaiei, utianik, roasiret eposek ak karar epar orip orip awau rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisas nukas kiro ämän aware kurea, kiro omre opokar kon tamareäu roat awarowon, ");
INSERT INTO bbr2013_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ak äpu sumaun omre kon enip Pasowa* omre oirori manonuk, kiro omre päi. Ro Nukan Mokoi kiro ses opok kon iwäi jaukut akas aru murianik, am äpäs opok äsäi maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Kiro ses opokar karauk Anut kamuk raiäi roat näunäu pak, mena kameäi roat näunäu pak akas Anut kamuk raiäi roat akan kamwareäu ro näwäu, kon enip Kaiapas nukan owa pote tururin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Keseria, ak Jisas sakau ateanik, wena, meiäun ämän ämäi ämäi atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Utianik, ak äiein, “Ik ko kiro sumaun omre opok wa wäu, roasiret akas siräianik, akas ik pak näwäu weräiäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Betani mena kar ro, kon enip Saimon, meter ko sip repros orip raiäwon, Jisas tone kon owa rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Keseria, ko owa tanea, o jenuk jenuk, kar sarau asires botol eposek uer sou eposek orip oi peanik, Jisas nukan tapau opok kourwon. Kiro asir meter aiauk näwäus kiro uer kau mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jisas nukan tamareäu roat akas kiro onok aparianik, kasiak penuk, keser äiein, “Owon kiro asires uer sou eposek orip erar kouru? ");
INSERT INTO bbr2013_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ik kiro uer karauk roat arota, kau mona, kiro pakan aiauk näwäu oianik, saruku roasiret araun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Keserna, Jisas ko akan ronkat äpu momara, kos keser awarowon, “Owon ak kiro asir wousarianik, usu nuri? Ko kiro onok eposek senes is opok keseru. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Saruku roasiret ak pak orip orip rawaiei. Utianik, is ak pak orip orip ekep wa rawam. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Kiro asir ko uer sou eposek orip isan enimsau opok kourwon, kiro is meieita, up kureiraun enimsau wäräu jekuri mou. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Is ak epar senes awarom, roat akas okoro Anut nukan Ämän Eposek omnokou erekapu roasiret aware arianik, kiro onok okoro asires keserwon kiro nais awaraiei. Keseria, roasiret ak konun ronkatäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","15","Jisas nukan tamareäu roat 12 orip pakan kar ro, kon enip Judas Iskariot, ko Anut kamuk raiäi roat näunäu siarakap potomara, kos keser totwarowon, “Is Jisas akan ipiaka opok maroita, akas is owo osap iraiei?” Kesernuk, akas aiauk 30 orip ninareanik, ko nurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Kiro ses Judas ko Jisas kon iwäi jaukut ipiakap maun apu itane rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Bret jis wäpik amke jeäin omre karar amke penuk, Jisas nukan tamareäu roat akas ko keser totorin, “Ik nan Pasowa* omre opok o jaun omoi erapok jekur musau?” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Keserna, kos kon tamareäu roat keser awarowon, “Ak Jerusalem näu mena tonoinai, kiro opok kiro ro keser aurwe. ‘Iken Näwäus, keser aikowon, “Isan utware manaun omre siarap ki peu, okon, is isan tamareäim roat pak Pasowa omre opok nan owa koi o jam.” ’” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kesernuk, Jisas nukas kon tamareäu roat kiro ämän awarowon siar, ak pote, Pasowa omre opok o jaun omoi jekur moin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Iukärir sarenuk, Jisas kon tamareäu roat pak kiro owa o jaun tanein. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ak taneanik, o je je rai, kos keser awarowon, “Is ak epar senes awarom, kar ro ak kamuk rau kos is isan iwäi jaiat akan ipiakap murai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ko keser äienuk, akan woiaka usu sarein. Ak karar karar akas ko keser totorin, “Näwäu, na is mesin äiem ra? Is wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisas nukas ätäi awarowon, “Kiro ro ko is ori erek maro karar opok kon bret ur opok mianik, oura, kos is isan iwäi jaiat akan ipiakap murai. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Anut nukan ämänis äiewon siar, Ro Nukan Mokoi manai, utianik, kiro ros kon iwäi jaukut akan ipiakap marowon, kiro ro ko wopur. Kiro ro anakus an jowon ses opok meiewon maro, kiro usu eteinak. Keserau wa, okon, tawa omar oik ko usu näwäu senes owai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Kiro ro Jisas kon iwäi jaukut ipiakap maraun ro, Judas kos keser äiewon, “Tamareäum ro, epar isas na keseisam ra?” Keser aurnuk, Jisas nukas ätäi auruwon, “Io, nakasar ki äiem.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jisas kon tamareäu roat pak tane o je je rai, ko bret oumoi, Anut ‘pere’ aurmara, ipous pärärianik, kon tamareäu roat aromara, äiewon, “Ak oinai, jeie. Okoro isan enimsau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Keseria, ko ätäi wain an kap orip oumoi, Anut aurmara, kon tamareäu roat aromara, awarowon, “Ak erekapu okoro kap pakan an jeie. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Okoro isan karian, Anut nukas kiro karianas ak pak paip awau mou. Isan karian kournuk, kis roasiret sosop akan onok aru jäkäi marai. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Is ak epar senes awarom, is ätäi okoro wain nemauk pakan an wa jam, pote is kar wain an awau kiro isan Monian kamwaraun mena ak pak ätäi jam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Kesermana, ak kar sir wemoi, kasik neanik, Olivet omtapau opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jisas nukas kon tamareäu roat awarowon, “Rurisa okoro pututu kar onok is opok penuk, ak aparianik, ak is utoirea, imine manaiei. Anut nukan ämänis keser äieu. ‘Kiro sipsip kameäu ro isas weita, sipsip raut ak imine atap atap manoutaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Kiro keserna, is meieanik, ätäi siräianik, amke Galili provins opok potoita, ak tainori potaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita nukas Jisas ätäi auruwon, “Onok aru na opok penuk, aparianik, ak erekapu na utoisi manaiei. Is karar na wa utoisam.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jisas nukas ätäi keser auruwon, “Is na epar senes aisom, rusapai pututu kakarau ur wäu wa opok nas isan enim ämäi momata, ‘Is ko äpu wa’ rai 3 orip äiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita nukas ätäi auruwon, “Epar senes, is kesek ämän wa äiäm. Utianik, is na pak erek meiäm.” Kesernuk, karauk tamareäu roat akas nais keseriar aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisas kon tamareäu roat pak kar om enip Getsemani poteanik, keser awarowon, “Ak okoro opok tane rauna, is enro opok Anut aurau potom.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Kos Pita pak Sebedi nukan mokoit ori pak imware manowon. Kon wou aru senes monuk, ko nepipirau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Jisas nukas kiro roat 3 orip awarowon, “Isan woi usuäu senes monuk, waiauk patirnuk, meiäurim. Ak is pak okoro opok awau tai rawe.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ko kiro omoi utomara, nukararnak pote ämäi raia, ko wou kumase nini rai, Anut keser auruwon. “O Moni, nas is opiapan usu oi kuräm kiro itok. Utianik, na isan ronkat wa tainorau, na nakan ronkat karar tainor.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Keseria, ko kon tamareäu roat 3 orip ak nini rain opok pe apwareanik, rurawarowon. Ko Pita auruwon, “Ak is kamoireanik, tai rawau owon utoi? ");
INSERT INTO bbr2013_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ak wa ninau, awau tai raianik, Anut aurwe. Keseraiei, Satan nukas wa ate apwarai. Is äpu ak onok eposek keserauriäi, utianik, akan enmaksau sakau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Keseria, ko ätäiar Anut auraun potea, Anut keser auruwon, “O Moni, is okoro meiäun kap nas wa oi kureta, is kiro jeita rai, itok nan onokur tainor.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ko ätäi pe kon tamareäu roat ak ätäiar keseriar nini rain apwarwon. Ak amos atomaronuk, awau tai rawau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Keseria, ko ätäi utware Anut auraun manowon. Ko amke Anut auruwon siar kiro ämänir ätäi mane auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Utianik, ko ätäi pemara, kon tamareäu roat nini rain apwareanik, rurawaria, keser awarowon, “Ak ninianik, sume rai ra? Ak rowe! Ro Nukan Mokoi sakateanik, roat onok aru miäi akan ipiaka opok maun ses kou. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Aparwe! Enro ros is isan iwäi jaiat ipiaka opok muraun ki kou. Ak sirauwe! Ik pote ko tararau manau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisas nukas kon tamareäu roat kiro ämän awaronuk awaronukar, kon tamareäu roat 12 orip pakan kar kon enip Judas nukas ko siakup kowon. Menan roat näunäu pak, Anut kamuk raiäi roat näunäu pak akas roat sosop Jisas sakau ataun äsimwarona, Judas tainori potoin. Ak weräiäin siräp pak utupauk pak ate koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas nukas meter kiro roat keser awarowon, “Is kiro ro pote oktokorita, ak äpu maiei kiro ro karar ak sakataiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Keseria, Judas ko kurte Jisas siakup potomara, keser auruwon, “Pere, tamukiäu ro!” aurianik, oktokoruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Kesernuk, Jisas nukas ätäi auruwon, “Jai, na owosäun koumon rai na kurte keser.” Ko keser äienuk, kiro roat akas kurte pemana, Jisas sakau atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Keserna, kar ro Jisas pak rawonus, kos kon siräp rumukäu oumara, Anut kamuk raiäi roat akan kamwareäi ro näwäu nukan sarau ro wem raiar kon rauk käu patir kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Kesernuk, Jisas nukas kiro ro auruwon, “Nan siräp oinam, ätäi kon jowa joke mo. Roat ak siräpis weräiäin ak siräpis akwarona, meiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Utianik, na äpu wa ra? Is isan Moni aurita, kos is sareirianik, kon sarau eitek sosop omsau 12 orip akan marai roat senek itimwaraiei kiro äsimwaraun itok. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Utianik, isan Monias sareirnuk rai, kon ämän buk opok rau kiro epar wa päi. Okon, kiro onok nukasar is opok päun äiewon päura.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Keseria, Jisas nukas kon iwäi jaukut awarowon, “Ak weräiäun utupauk pak siräp pak oianik, is päu ro senek sakatoirianik, iworaun koi ra? Is omre orip orip Anut osap nuriäi ou näwäu owa roasiret tamareäimin, ak kiro opok sakatoirau utiäin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Utianik, ak kiro onok keserna, Anut nukan ämän roianik, areai roat akas kon ämän jer we moin kiro epar pewon.” Keserna, kiro ses opok kon tamareäu roat erekapu imine manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Kiro roat akas Jisas sakau ateanik, Anut kamuk raiäu ro näwäu senes kon enip Kaiapas nukan owa imäi potoin. Kiro opok sintore ämän tamareäi roat pak menan roat näunäu pak erek turur rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Kiro roat akas Kaiapas nukan owa Jisas imäi tonona, Pita ko potonar, ämäi ämäi keres keres potowon. Keserna, Pita tonea, kiro opok om kameäi roat pak taneanik, Jisas owoseanik, ätäi imäi nona, aparam rai rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Anut kamuk raiäi roat näunäu pak karauk Juda roat näunäu pak akas karauk sät ämän Jisas opokup momana, owose wena, meiäun rai keserin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Roat sosop peanik, ko opokup sät ämän moin. Utianik, ak kon onok wasare aparin, ko kar onok aru mau wa. Roat sosop ämän mona, kar ro oiroror pe tai rairin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Awas keser äieirin, “Kiro ros keser äiewon, ‘Is kiro Anut osap nuriäi ou näwäu uräianik, omre 3 orip ätäi mam,’ kos keser äiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Keserna, Anut kamuk raiäu ro näwäu senes, Kaiapas nukas akan amiakap tai raumara, ätäi Jisas keser totorwon, “Na owon kiro roat akan ämän aisoin ätäi awarau utom? Na owosemon, okon, na enmatap ämän miäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Utianik, Jisas ko aräu wa. Okon, Kaiapas nukas ätäiar auruwon, “Na Anut, ko orip orip awau raiäu, nukan enip atea, nan ämän sakau momoi, na ik aik, na Krais, Anut nukan Mokoi ra, wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Keser aurnuk, Jisas nukas ätäi auruwon, “Io, naka äiem senek. Is ak erekapu epar senes awarom, kiro ses opok, Ro Nukan Mokoi ko Anut, ko sakau näwäu orip nukan ipou näu kaima taneanik, omar oik iou pakas ätäi kowai, aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Kaiapas ko kiro ämän roumara, nukan omjo kiräianik, keser äiewon, “Kiro ro ko Anut jeje ämän auru! Ik owon karauk roat awarota, koi kon enip opok karauk ämän maiei? Ko Anut jeje ämän auruwon, ak roin. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Karo, akan ronkat ko owosäiei?” Akas ätäi äiein, “Ko ämän orip, okon, wena, meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Kesermana, akas Jisas opokup sinok kurea, ipiakas wein. Karauk roat akas sipou purianik, ");
INSERT INTO bbr2013_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","akas ko aurin, “Na Krais, na ämän roianik, areäumon ro rai, na ik aik, karo, inos na iwosou?” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ko Anut kamuk raiäi roat akan kamwareäu ro näwäu, Kaiapas nukan ou kiro kasakupai tane raunuk, kar sarau asires pemara, auruwon. “Na Galili provins pakan ro, Jisas nukan jauk.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Keser aurnuk, Pita nukas kiro roat amiakap Jisas nukan enip ämäi mianik, äiewon, “Na kiro ämän äiem kiro kon onoktapau is äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Keseria, ko ätäi ou rorokpai tai raunuk, kar sarau asires pemara, roasiret awarowon, “Okoro ro nais ko Nasaret menan, Jisas pak ariäu ro.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Kesernuk, Pita nukas ipou oik mianik, ätäi äiewon, “Epar senes, is kiro ro äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Rai rai, karauk roat atapuk rainus, Pita siakup pemoi, keser aurin, “Epar senes, na Jisas nukan tamusiäu ro kar. Nan arem pätunas na amop musou.” ");
INSERT INTO bbr2013_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Utianik, Pita nukas ipou kämioik momara, ätäiar äiewon, “Epar senes, is ak awarom! Is sät ämän mam kar usu is opok päi. Is kiro ro äpu wa!” Ko keser äienuk äienukar, kakarau ur wewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Kesernuk, Pita ko Jisas nukas ämän meter auruwon, ätäi ronkatewon. “Kakarau ur wäu wa opok, na isan enim ämäi momata, ‘is ko äpu wa’ rai 3 orip äiäm.” Keseria, Pita ko kasik neanik, näwäu waiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Om teinenuk, tapera, Anut kamuk raiäi roat näunäu pak karauk menan roat näunäu pak, akas Jisas wena, meiäun ämän atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Keseria, ko muris ipou parar mia, Rom akan kamwareäu ro Pailot ipokup maun imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas ko Jisas kon iwäi jaukut ipiakap marowon ro Pailot nukas Jisas wenuk, meiäun aparianik, ko ätäi Jisas nukanun wouti momara, ätäi pote Anut kamuk raiäi roat näunäu pak karauk roat näunäu pak ko kiro aiauk 30 orip owon ätäi araun potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ko pote, kiro roat awarowon, “Is onok aru momin kiro ro ko kar onok aru mau wa, isas kon iwäi jaukut ipiakap momin, okon, ko wena, meiäuru.” Akas ätäi aurin, “Kiro onok ikes kesermun ra? Nakasar kesermon apar!” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Keser aurna, Judas ko kiro aiauk Anut osap nuriäi ou näwäu owa känkurea, ute pote nukasar pomur oumara, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Anut kamuk raiäi roat näunäu akas kiro aiauk oianik, äiein, “Kiro ojap momun aiauk, kiro iken sintore ämänis äiewon, kiro ukun orip, okon, ik Anut osap nuriäi ou näwäu pakan aiauk pak wa turur mau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ak kiro aiauk oumoi, mis ate miäi roat akan kar omnokou kau mianik, kar menan roasiret meiena, kiro opok up tuewaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Keserianik, kiro om enip ‘Karian omnokou’ äiäi. Kiro omnokou rusapai nais enip atorai. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Meter Anut nukan ämän roianik, areawon ro Jeremaia nukas kiro ämän arewon kiro epar peu. ‘Akas kiro aiauk 30 orip Israel roasiret akas kiro ojap moin aiauk oianik, kiro mis ate miäin roat akan omnokou kau moin. Kiro Anut nukas is airowon siar.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisas Pailot nukan amuk opok tai mona, Pailot nukas totorwon. “Na Juda roasiret akan kamwareäum ro näwäu king ra?” Jisas nukas ätäi auruwon, “Io, naka äiem senek.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Utianik, Anut kamuk raiäi roat näunäu pak karauk menan roat näunäu pak, akas Jisas enip opok ämän sätäuna, kos ätäi kar ämän awarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Keserna, Pailot nukas auruwon, “Utianik, kiro ämän nan enmatap moi, na rowau wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Keser aurnuk, Jisas nukas kar ämän eteinak ätäi aurau wa. Kesernuk, Pailot ko ronkat sosop owon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Akan sumaun omre enip Pasowa* opok, Rom akan kamwareäu ro näwäu king nukas woisan karar karar kiro omre opok kar ro karapus owa raiäu utonuk, maneäu. Roasiret akasar koi tururianik, kar ro utona, manaun aurna, kos kiro ro utonuk, maneäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kiro ses opok kar ro kon enip Bar-Abas kon enip jou aru orip ko karapus owa raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Keseria, roasiret koi tururna, Pailot nukas awarowon. “Akan ronkat is inok ro utoita, ko manai? Bar-Abas ra, Jisas ko Krais äiäi ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailot ko äpu Juda roasiret ak Jisas nukan onok eposek mesin kasiak peäi, okon, ak ko siakup imäi koin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Keserna, Pailot ko ämän wasarewareäu sia opok tane raunuk, kon waus kar ämän sur murumara, auruwon, “Nas kar onok aru kiro ro opok wa keserau. Kiro ro ko onok eposek miäu. Is pututu nini epire ko aparmin, okon, isan woi usuäu senes sareu.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Anut kamuk raiäi roat näunäu pak karauk roat näunäu akas roasiret raiaka atomoi, awaroin, “Pailot aurwe, Bar-Abas utota, man. Jisas weta, meiäura.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pailot nukas ätäiar roasiret totwarowon, “Akan ronkat okoro ro oirori, is inok ro utoita, manai?” Akas ätäi aurin, “Bar-Abas utota, manai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Keserna, Pailot nukas ätäi awarowon, “Jisas, ko Krais äiäi, is ko owosäm?” Akas oiaksau karar mianik, aurin, “Ko am äpäs opok äsäi mo!” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailot nukas awarowon, “Owon? Ko owo onok aru keserwon?” Akas ätäi ko am äpäs opok äsäi mota, meiäun rai sakau äiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ko roasiret apwarowon ak weräiäun senek sarena, Pailot ko kar ämän mau senek wa, okon, an maro orip oumara, roasiret amiakap kon ipou an kosorwon. Kos äiewon, “Okoro isan usu wa, isas kiro ro weita, wa meiäi. Akasar keseraun keserwe!” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Roasiret akas ätäi aurin, “Owosäi ko meienuk rai, kiro usu ika pak iken mokoit pak erek owauram.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Keserna, Pailot nukas Bar-Abas utonuk, manowon. Kesermara, kos kon kar marai ro aurnuk, kos Jisas mänkäsirianik, karauk marai roat aronuk, akas am äpäs opok äsäi maun imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Marai roat akas Jisas Pailot nukan ou enip Pretoriam owa imäi potona, karauk marai roat owa rain erek koi ko karirim kator rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Keseria, marai roat akas kon omjo jäkäi murianik, kar omjo osou ko opok kuror murin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Keseria, ak kar rumäkät katuau orip oumoi, tatmaianik, kon tapau opok kuror moin. Kar aitauk oianik, kon ipou näu kaima moin. Keseria, ak ko siakup uoraka sur wea, jeje ämän aurin. “Na Juda akan kamwareäum ro näwäu, king, ik nan enmat jou mom.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Akas ko sinok amuk urarianik, ipokupan aitauk senri oumoi, kiro aitaukusar tapau purin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ak ko jeje ämän erekapu auri kureanik, kiro omjo ko opokupan jäkäi oumana, ätäi kon omjo orke murin. Keseria, ak ko imäianik, am äpäs opok äsäi maun imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Rom akan marai roat akas Jisas am äpäs opok wäun apu opok imäi potona potona, kar ro ko Sairini menas ätäi näu mena tonaun kowon. Kon enip Saimon, ak ko apu opok tararianik, sakau atea, Jisas nukan am äpäs oianik, Saimon ämäi muruna, ko Jisas tainori potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ak kar om enip Golgota potoin. Kiro om enip onoktapau kesek ‘op tapau sekerem’. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Keseria, akas wain an amkasuwei tiu senek orip momoi, keputirianik, Jisas jaura rai nuraurin. Utianik, ko kiro wain an menopakus märäkärwon tiurnuk, ko jau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Keseria, marai roat akas Jisas am äpäs opok äsäi mianik, ak kon omjo atapane owaun rai, aiauk oianik, satu sipiräiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Keseria, ak Jisas am äpäs opok äsäi mianik, kiro opok kame rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ak ko äsäi mianik, tapakup karauk roat akas kar ämän enkup moin ak keser jer we moin. ‘Okoro ro Jisas, ko Juda roasiret akan kamwareäu ro näwäu, king.’ ");
INSERT INTO bbr2013_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Keseria, Jisas am äpäs opok äsäi momana, akas onok aru moirin ro oiroror imwateanik, kar ro Jisas nukan ipou näu kaima äsäi moin, kar ipou saunan kaima äsäi moin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Keserna, roasiret akas apu pakas pe mane rai, ko aparianik, tapiaka känkänirmoi, jeje ämän auri auri maneäi. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ak keser äiein, “Nas keser äiemon, na Anut osap nuriäi ou näwäu uräianik, omre 3 orip ätäi ou awau mam äiemon. Keseria, na Anut nukan Mokoi maro, nakasar ätäi nakan enmatsau sareanik, am äpäs opokan ute ne.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak akas nais keseriar jeje ämän aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Ak keser äiein, “Ko karauk roasiret sarwareäwon, nukasar ätäi nukan enipsau saräu senek wa! Ko Juda roasiret akan kamwaraun ro näwäu king maro, ko am äpäs opokas ute nonuk rai, ik kiro aparianik, iken woiok konun epar mam. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kon wou Anut nukanun epar momara, äiäu, ‘Is Anut nukan Mokoi.’ Keseria, Anut nukas ko saräi ra, ik apari rawau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Kiro onok aru moirin roat ories nais ko keseriar jeje ämän auririn. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sankeu san näu kamuk, san jeräu wa, om erekapu pututu senek sare pote 3 klok iukärir. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Keser raunuk raunuk, 3 klok siakup sarenuk, Jisas nukas keser urwewon, “Eloi, eloi, lama sabaktani.” Kiro ämän onoktapau kesek. ‘Isan Anut, isan Anut, na owon is utoirom?’ ");
INSERT INTO bbr2013_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Kesernuk, karauk roasiret kiro opok tai rain akas kiro ur roianik, äiein, “Kiro ro ko Elaija urura!” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Keseria, kar ros kurte mane kar osap jaimirmir senek oianik, wain an tiu mia, aitauk opok momara, Jisas jaun nurauruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Utianik, karauk roasiret akas kiro ro aurin, “Ik kame rauta, Elaija nukas koi, saräi ra, ik apari rawau!” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jisas nukas ätäiar kakaparnäkäu urwenuk, kon osou nukasar utonuk, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kiro ses opokar, omjo Anut osap nuriäi ou näwäu owa äsäi moin rawon, oikas kiräi nopte, oirori sarewon. Kesernuk, mim näwäu pemara, aitapau näunäu kamukasar käi kurwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Keseria, op up nais om käienuk, meten roasiret ak akan woiaka Anut nukanun epar mianik, meiein, ak ätäi erekapu siräiein. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jisas ko ätäi siräienuk, kiro meiein roasiret siräiein ak Jerusalem näu mena potona, roasiret sosop akas apwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Marai roat akan ro näwäu ko kon marai roat pak ak Jisas kume rain, mim pemara, onok atap atap penuk, aparianik, ak sakau imineanik, äiein, “Epar senes, kiro ro ko Anut nukan Mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Asiret sosop meter Galili provins pakas Jisas isanaraun tainori koin, ak erek atapukas tai raianik, Jisas owosäiei rai apari rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Kiro asiret kamuk, kar asir kon enip Maria ko Magdala menan, pak kar asir kon enip Maria ko Jems Josep orien aninawa, pak kar asir ko Sebedi nukan wau, pak rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Iukärir sarenuk, kar ro aiauk sosop orip ro kowon. Kon enip Josep, ko Arimatea menan, ko nais kar Jisas nukan tamareäwon ro. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ko Pailot siakup potomara, Jisas nukan kopeu owaun totorwon. Kesernuk, Pailot nukas kon marai roat awaronuk, akas Jisas nukan kopeu oi nurin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Keserna, Josep nukas Jisas nukan kopeu oianik, omjo awau eposek ärneus kurur mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ko kon up awau nukasar nukan wäräu tuwe mowon, Jisas nukan kopeu kiro aireu uru mowon. Keseria, aiauk näwäu oumara, aireu oksau pene mianik, ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria ko Magdala menan pak kar asir kon enip Maria, au kiro up siakup taneanik, apari rairin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ninoinus, tapera, sumaun ses opok Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak ak Pailot pak koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Akas keser aurin, “Ro näwäu, ik kar ämän meter kiro ro sätäiäwon, ros keser äiewon roumun ronkatem, ‘Tawa omre 3 orip utia, is ätäi siräiäm’ äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kesek, okon, nas nan marai roat awarota, akas kiro op up jekur kume rawaiei, pote omre 3 orip utaiei. Keserta, kon tamareäwon roat akas kon kopeu wa päu owaiei. Na kiro wa keserta roi, akas kon kopeu päu owaiei. Na kiro wa keserta roi, akas kon kopeu päu oumoi, roasiret keser awaraiei, ‘Ko meieanik, ätäi up uruas siräiwon.’ Meter ko keser sät äiewon, ‘Is Krais.’ Ak rurisa keser sätäiäi, ‘Ko meieanik, ätäi siräiwon.’ Kiro rusapaian sät ämänis meter arewon sät ämän itimorai.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Keser aurna, roumara, Pailot nukas kiro roat näunäu awarowon, “Karauk marai roat imwaroinai, pote kiro up jekur sakau kamäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Keseria, ak pote up opok aiauk näwäu muris parar momoi, okäk mianik, karauk marai roat akas kiro up kume rain. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sumoin ses manonuk, tapera Tup Näu opok Magdala menan Maria pak kar Maria ori au Jisas nukan up aparaun potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kurte mim näwäu penuk, Näwäu nukan kar sarau eitek omar ute nemara, aitapau näwäu up oksau pene moin opakan eroror momara, ko kiro opok tane rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Kon neputapau ermän nukan merek senek. Kon omjo iou ärneu senek. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Marai roat up kame rain, ak ko aparmoi, karkairianik, sakau iminemoi, ak roat meiein senek ninoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ak keserna, Anut nukan sarau eitekus kiro asiret ori awatowon, “Au wa iminäu. Is äpu au kiro ro ko Jisas am äpäs opok äsäi moin meiewon aparaun itanerair. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ko okoro opok rawau wa. Meter ko äiewon siar ätäi siräiewon. Au ko nini moin omoi koi aparwer. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Au kesernair, kurte potoinair, kon tamarowon roat awaraieir. Jisas ko up pakas ätäi siräiewon, ko amke Galili provins potonuk, ak tainori potaiei. Ak kiro opok pote aparaiei. Isan ämän okoro awatom jekuriar ronkatäieir.” ");
INSERT INTO bbr2013_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Kiro asiret ori au imineirin sinuk, kurte up utia, nepipirmoi, kon tamarowon roat awaraun potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","10","Apu opok potosa, Jisas nukas kurte pe tarwatianik, awatowon, “Orie.” Keser awatonuk, awas ko siakup peanik, kon isou atomoi, kon enip jou murusa, Jisas nukas kiro asiret ori awatowon, “Au wa iminäu. Au pote isan tamareäimin roat awarona, Galili pote apairaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Kiro asiret ori au apu opok potosa potosa, karauk up kamein marai roat akas näu mena poteanik, Anut kamuk raiäi roat näunäu kiro onok pewon erekapu awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Anut kamuk raiäi roat näunäu pak menan roat näunäu pak aka aka ämän ateanik, aiauk sosop oianik, marai roat aroin. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Akas marai roat keser awaroin. “Ak keser äiäiei, ‘Ik pututu ninota ninota, kon tamareäwon roat akas peanik, kon kopeu päu oi manoin.’ keser awaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Keserna, Pailot ko kiro ämän rounuk rai, ikes ko keser auram, ak kar onok aru mau wa, okon, ak kiro onokun woiaka aru wa mau.” ");
INSERT INTO bbr2013_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Keseria, marai roat akas kiro aiauk oianik, ämän awaroin siar tainorin. Keserna, kiro ämänis Juda akan omsau erekapu pote iporwon. Kiro ämän Juda roasiret rusapai keseriar areai. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisas nukan tamareäwon roat 11 orip ak Galili poteanik, Jisas nukas meter awarowon kiro omtapau opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Kiro opok, ak ko aparianik, rororin. Utianik, tamarowon roat karauk ak ronkat oiroror orip. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisas ko ak siarakap pemara, keser awarowon, “Anut nukas omar pak omnokou pak kamäun kiro sakau erekapu is irowon. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Keseria, ak omsau sau erekapu potoinai, roasiret ak isan ämän tamarona, akan woiaka pirirmoi, isan tamareäim roat sarena, akas pote, Moni nukan enip pak Mokoi nukan enip pak Osou Näu nukan enip pakaima, roasiret an jomaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ak kiro ämän ätär maromin akas pak ätäi roasiret ätär maraiei. Keserna, is ak pak orip orip rawam, keseriar pote wasarewaraun ses kowai.”");
INSERT INTO bbr2013_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Anut nukan Mokoi, Jisas Krais*, kon Ämän Eposek keser onoktorowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Meter Anut nukan ämän roianik, areawon ro* Aisaia, Anut nukan ämän keser jer weanik, äiewon, “Rowe, isan ämän oi areäun ro äsimorta, amke koi, nan apu tuku sare musai. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Kar ro ko ro wäpik mena om puru opok urwera, ‘Näwäu nukan apu jekur sare muruwe. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","An jomareäwon ro, Jon ko ro wäpik mena pewon. Peanik, roasiret ämän awaromara, äiewon, “Ak woiaka pirirnai, akan onok aru sumkäineinai, kouna, isas an jomaroita, Anut nukas akan onok aru jäkäi marai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judia provins pakan roasiret pak Jerusalem menan roasiret pak Jon siakup potoin. Poteanik, akan onok aru Anut aurna, Jon nukas Jordan an opok an jomarowon*. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon ko opur kamel urik oumara, takeanik, ko kar opur kerau, let senek, kon nokou tapau opok takewon. Kon mer näu mokoi wäpik. Ko o eposek wa jeäwon, kon o sonkäpit upes an pak karar jeäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kos keser awarowon, “Kar ro ruris koura. Kon sakaus isan sakau itimorai. Is ro eposek wa, okon, kon isou pakan su oi kuräun senek itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Isas anas an jomariäim, kos Anut nukan Osou Näu oripas an jomarai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kiro ses opok, Jisas Nasaret mena Galili provins utomoi, kounuk, Jon nukas Jordan an opok Jisas an jomurowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisas an ute kasakup penuk, apari rauna, kurte omar kerererianik, Anut nukan Osou Näu ai manap senek ko opok tapakup nowon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kesernuk, kar ron pätu senekus omar oikas keser urwewon, “Na isakan mokoi senes, isan woias nanun meieäu. Isan woi nanun näu sareu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kiro ses opokar, Anut nukan Osou Näus Jisas ko ro wäpik mena om puru opok äsimornuk, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ko ro wäpik mena om puru opok, omre 40 orip raunuk raunuk, Satan nukas ate aparwon. Jisas ko opur raut pak rawon. Anut nukan sarau eitek* rautes koianik, ko isanarin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Roat akas Jon karapus owa mona, Jisas nukas Galili provins poteanik, Anut nukan Ämän Eposek roasiret awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jisas nukas keser awarowon, “Ak rowe, rusapai, omre Anut nukas roasiret kamwaraun sare mowon rusapai kowon rau, okon, akan onok aru utomoi, akan woiaka pirirnai, Anut nukan Ämän Eposek mesin woiaka epar mowe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kar omre opok, Jisas ko Galili An Unik kasakup pote rai, Saimon kon amak Andru ori apwatowon. Au was owaun jo an unik opok kure rairin. Owon, au awan sarau was oiäirin roat ori. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisas nukas apwatomara, keser awatowon, “Au koi is tainoirsa, isas au roasiret imwaraun onok ätär matam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kurte au awan was oiäirin jo utomoi, Jisas tainori manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jisas ko ätäiar ari ari maneanik, Sebedi nukan mokoit ori Jems Jon ori apwatowon. Au ous opok tane raia, awan was owaun jo kiräwon, okon, näke rairin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Au nais keseriar Jisas nukas urwatonuk, au awan momonawa Sebedi, kon sarau roat pak ous opok rauna, utwaromoi, Jisas tainori manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ak Kapaneam mena Juda akan sumaun omre opok potoin. Kiro opok, ak Juda akan tururiäi owa tonomoi, Jisas nukas onoktoroi roasiret näu ämän tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Roasiret ak kon ämän roianik, karkairin. Owon, ko akan sintore ämän tamareäi roat* akas awareäi senek awarau wa. Ko kar ro enip orip senekus ämän awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Kiro ses opok, kar ro ko osou aru orip kiro tururiäi owa rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kiro osou aru keser urwewon, “Nasaret menan Jisas, na ik owoseikaun koum? Na ik aru mukaun koum ra? Is na äpu, na ro eposek tuku senes, Anut nuka pakaima koumon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Utianik, Jisas nukas kiro osou aru sakau ämän aurmara, äiewon, “Na asornam, kiro ro ute man!” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Keser aurnuk, kiro osou arus kiro ro ate kareanik, näwäu piormoi, ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kesernuk, roasiret ak erekapu kiro onok aparianik, karkairmoi, aka aka tototein, “Kiro owo onok peu? Ämän awau rä? Kiro ro ko enip orip senek, kos osou aru raut sakau ämän awaronuk, ak kon ämän roianik, tainoriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Keseria, kurte Galili provins pakan roasiret ak Jisas owo sarau me kowon, erekapu roin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jisas ko Juda akan tururiäi ou utomoi, Jems Jon ori pak, Saimon Andru orien owa erek tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","31","Saimon nukan tanau asir ko sip enip sopou orip pasar opok nini rawon. Roasiret akas kurte Jisas ko mesin aurna, Jisas nukas kiro asir siakup tone tai raumara, kon ipou ate siräi monuk, kiro sip kurte ute manonuk, ko roat akan o mis marowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","San nonuk, iukärir roasiret akas akan jaunakat sip orip pak karauk osou arus akan woiaka uru rain pak, imware Jisas siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","34","Näu menan roasiret koianik, kon ou rorokup turur rain. Kos roasiret sosop sip atap atap orip jekwarowon. Kos osou aru sosop emwarowon. Kiro osou aru ak Jisas äpu, okon, Jisas nukas ak aräun tämarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Om jekur teinäu wa, tapera senes, Jisas siräimara, ko kar mena ro jejemak wäpik opok poteanik, Anut auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","37","Saimon kon jaukut pak erek ko itane potoin. Pote tararmana, aurin, “Roasiret akas na itaneisorai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Keserna, Jisas nukas awarowon, “Ik okoro opok karauk mena okoro mena siakup rai opok potau. Is kiro opok nais Anut nukan ämän awaram. Owon, is kiro onokun Anut nukas äsimoirnuk, koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Keseria, ko Galili provins erekapu ariemoi, Juda akan tururiäi owa atap atap opok Anut nukan ämän mare mare, osou aru pakur emwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Kar ro sip repros orip Jisas siakup koianik, uou sur wemoi, ämän sakau auruwon, “Näwäu, na isan ui aru jäkäi muraun itok, utianik, nan ronkat pakas keser. Na is rapoire murota, is eposek saräm.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jisas nukas kiro ron wouti momara, kon ipou kiro ron enip opok mianik, auruwon, “Isas aisom, na eposek saräm.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kiro sip repros kurte ute manonuk, ko eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Jisas nukas ko sakau auruwon, “Is okoro onok keserim na pote karauk roasiret wa awarau. Utianik, na Anut kamuk raiäu ro* siakup potea, nan enmat näu sarewon ätär muruta, apaisai. Apaisonuk, na Moses nukan sintore ämän tainornam, opur oianik, Anut jou muruta, kiro epar roasiret erekapu äpu maiei, na ätäi eposek saremon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Utianik, kiro ro ko Jisas nukan ämän tainorau wa, ko potea, roasiret ämän erekapu awarowon. Kesernuk, Jisas ko näu mena amop tonau senek wa. Ko mena kasakup ro wäpik opok rawon. Utianik, roasiret sosop kar mena kar menan erekapu ko siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Karauk omre manonuk, roasiret ak Jisas Kapaneam mena ätäi kowon owa rau kiro ämän roin. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Roasiret sosop koi kiro owa tururmana, omoi erekapu oi kuremoi, ou rorokpai nais erekapu ok pe apu sorin. Keserna, Jisas nukas roasiret näu ämän tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Karauk roat akas kar sip ro kon isou ipou tipinewon manau senek wa roat 4 oripas kakure koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Roasiret sosop akas apu sor rauna, kiro ro Jisas siakup imäi tonau senek wa, okon, ak äpäs tit ou sakatou oik tonomoi, Jisas rawon tapakupas ou sau tueanik, kiro amarer uruas sip ro pasar orip Jisas nepukup mona, nowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jisas nukas akan woiaka ko mesin epar moin apwareanik, kiro sip ro isou ipou tipinewon keser auruwon, “Mokoi, is nan onok aru jäkäi musom.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Keser aurnuk, karauk sintore ämän tamareäi roat tane rain akan woiaka uruas keser ronkatein, “Kiro ro owon keser äieu? Ko Anut jeje ämän auru. Kar omnokou pakan ros ko onok aru jäkäi mau senek itok wa. Anut nukas karar epar ko onok aru jäkäi maraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kiro ses opokar, Jisas kon wou uruas owo ronkat akan woiaka uru rau äpu momara, keser awarowon, “Ak owon akan woiaka uru kiro ronkat ourai? ");
INSERT INTO bbr2013_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Is owo ämän äiäun itok, owo ämän äiäun itok wa? Is isou tipinewon ro keser auram, ‘Nan onok aru jäkäi musom’ ra? Is isou tipinewon ro keser auram, ‘Na siräinam, nan mat oumoi, manam.’ auram ra? Is owo ämän äiem, ak akan woiaka is mesin epar maiei? ");
INSERT INTO bbr2013_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","11","Utianik, Ro Nukan Mokoi, ko enip orip, ko okoro omnokou pakan onok aru jäkäi maraun itok räi äpu maun is kiro keseram.” Keser awareanik, kos sip ro isou tipinewon auruwon, “Isas na aisom, siräianik, nan mat oinam, nan mena man!” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kiro ro siräinik, roasiret amiakap kurte kon mat oumara, manowon. Roasiret ak kiro onok aparia, karkairianik, Anut nukan enip jou muromoi, äiein, “Meter ik kesek onok wa apariäumun.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisas an unik kasakup ätäi noptowon. Roasiret koi ko siakup tururna, kos Anut nukan näu ämän tamaraun onoktorowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jisas ari ari maneanik, Alfius nukan mokoi kon enip Liwai, ko takis aiauk oiäu owa tane rawon aparianik, auruwon, “Na koi, is tainoir.” Keser aurnuk, Liwai siräianik, tainori manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisas nukas takis aiauk oiäin roat pak onok aru miäin roat pak erek Jisas tainori koin pak kon tamareäu roat pak ak erek Liwai nukan owa turur o je tane rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Keserna, karauk Parisi* akan sintore ämän tamareäi roat näunäu, akas Jisas kiro onok aru miäi roat pak, takis oiäi roat pak erek o je rauna, aparianik, akas Jisas nukan tamareäu roat awaroin, “Ko owon onok aru miäi roat pak takis oiäi roat pak erek o jera?” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisas nukas kiro ämän roianik, ätäi awarowon, “Roasiret sip wäpik ak dokta siakup wa poteäi, roasiret sip orip karar epar dokta siakup poteäi. Kiro senek, is roasiret onok eposek miäi urwaraun kowau wa. Is roasiret onok aru miäi urwaraun koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Kar omre opok, Jon an jomareäwon ro nukan tamareäu roat pak Parisi roat pak akas Anut nuka ronkatäun o ute raiäin. Karauk roat akas koianik, Jisas totorin, “Jon nukan tamareäu roat pak Parisi roat pak Anut nuka ronkatäun o utiäi. Owon nan tamareäum roat ak o wa utiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisas nukas ätäi awarowon, “Kar ro ko asir awau owaurnuk, kon jaukut pak ak o utaun itok ra? Wa, ak o wa utaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Utianik, kar omre opok, karauk roat akas kiro ro asir owon imäi manona, ko ak pak rawau wa. Kiro ses opok ak woiaka aru monuk, o utaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Kar ro kon omjo kiräiwon ko omjo si awau oianik, omjo mustäi opok wa näke mai. Ko kesernuk rai, an kosoriäu ses opok, kiro omjo si awau eteinak sareanik, kon omjo mustäi ätäi kiräimara, amarer näwäu saräi. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Kar ros wain an awau meme kerau mustäi opok wa äräine miäu. Ko kesernuk rai, kiro wain an awau sipar kurarianik, meteran meme kerau kiräianik, wain an omnokou opok kour nai. Kiro meme kerau nais erek jäkäiai. Wain an awau ko meme kerau awau opok äräine mota, au eposek rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Juda akan sumiäin omre opok, Jisas kon tamareäu roat pak wit woi kamukas potoin. Pote rai, kon tamareäu roat akas karauk wit nemauk ate oumoi, pinoi, jein. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Karauk Parisi roat akas kiro onok keserin apwareanik, Jisas aurin, “Apar! Tup omre opok sumaun ses, owon nan tamareäum roat akas kiro onok keserin? Iken sintore ämänis äieu sumaun ses opok kiro asu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisas nukas ätäi awarowon, “Ak Devit kon roat pak sou akwaronuk, owosein ak kiro jer ninaräu wa ra? ");
INSERT INTO bbr2013_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Anut kamuk raiäwon ro näwäu, Abiatar raunuk, Devit nukas Anut nukan owa toneanik, bret kiro Anut nurin oi jewon. Kiro bret asu, Anut kamuk raiäin roat akas karar kiro bret jaun itok. Utianik, Devit nukas kiro bret jemoi, kon roat aronuk, ak nais jein.” ");
INSERT INTO bbr2013_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jisas nukas ätäi awarowon, “Anut nukas amke roasiret atware mowon. Ko ak mesin ronkateanik, sumaun omre mowon. Kiro sumaun omre opok, roasiret eposek rawaiei, ak wa aru maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Keserianik, Ro Nukan Mokoi, ko kararas sumaun omre kumeäu. Ko owo onok keseraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jisas ko ätäi Juda akan tururiäi owa tonowon. Kiro owa kar ro kon ipou meiewon orip rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Karauk roasiret akas Jisas nukas sumaun omre opok kiro ro raporai ra, wa rai aparaun kame rain. Owon, akan ronkat ko sumaun omre opok kiro ro jekurnuk, ak ko enkup ämän maurmana, apari rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jisas nukas kiro roat akan ronkat äpu momara, kiro ro ipou meiewon orip auruwon, “Na roasiret amiakap siräinam, koi!” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jisas nukas roat näunäu totwarowon, “Iken sintore ämän nukas ik sumaun omre opok, onok eposek mam ra, onok aru mau, äieu ra? Ik roat ätäi imwarau ra, ara akwarota, meiäiei ra?” Kos keser awaronuk, akas ätäi kar ämän aurau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jisas nukas kiro roat apwaromara, kasak pewon. Owon, akan woiaka sakau mona, apwareanik, ko wou usu sarewon. Kos kiro ro ipou aru orip keser auruwon, “Nan ipon kur!” Ko ipou kurenuk, kon ipou kurte näu sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kesernuk, Parisi roat ak kurte owan ute kasik nea, Herot nukan roat pak tururia, Jisas wäun ämän atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisas kon tamareäu roat pak kiro mena utomoi, Galili An Unik siakup noin. Galili provins pakan roasiret sosop erek potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Roasiret sosop Jisas nukan sarau mowon roianik, ko siakup koin. Judia provins kipakan roasiret pak, Jerusalem näu menan roasiret pak, Idumia provins kipakan roasiret pak, Jordan An kasakup raiäin roasiret pak, roasiret Taia mena karaiman pak Saidon mena karaiman pak raiäin erek ko siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisas nukas kiro roasiret sosop apwareanik, kon tamareäu roat awarowon, “Roasiret sosop is suoiraiei, okon, ak kar ous oi koi, rapor mona rau, is suoirna rai, kiro opok tone tanäm.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Meter Jisas nukas roasiret sosop jekwarowon, okon, kiro mesin sip roasiret akas akan ipiakas Jisas ataurin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Karauk roasiret akan woiaka uru osou aru rautes rakurein. Kiro roasiret akas Jisas aparianik, ak uoraka sur wemoi, sakau urwein, “Epar, na Anut nukan Mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Utianik, Jisas nukas sakau ämän awarowon, “Ak is mesin karauk roasiret wa awaraiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisas ko omtapau opok toptowon. Ko karauk roat ko pak rawaun sare maraun urwaronuk, kiro roat ak Jisas siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kos roat 12 orip sare marowon. Ak ‘Anut nukan ämän oi ariaun roat’ enip marowon. Ak Anut nukan näu ämän karauk roasiret araun sare mareanik, äsimwaraun keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Jisas nukas nukan sakau ak osou aru roasiret akan woiaka uru rai emwaraun ak arowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Kos roat 12 orip sare marowon. Akan enmaka kesek: Saimon (kon kar enip awau Jisas nukas mowon Pita), Jems (Sebedi nukan mokoi), kon amak Jon (awan enmawa awau matowon, Boanerges, kiro enmawa onoktapau ‘om taiäu nukan mokoi ori’), Andru, Filip, Bartolomiu, Matiu, Tomas, Jems (ko Alfius nukan mokoi), Tadias, kar Saimon (ko kar tupsiu enip Serot pakan), Judas-Iskariot (kos Jisas kon iwäi jaukut ipiakap marowon). ");
INSERT INTO bbr2013_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisas ko ätäi owa tononuk, roasiret sosop ätäi kiro opok koi turur rauna, Jisas kon tamarowon roat pak ak o jau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jisas nukan kinjaukut ak Jisas nukas kiro onok keserwon ämän roianik, akas äiein, “Ko otop sareu.” Äianik, ak imäiäu koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Karauk sintore ämän tamareäin roat näunäu ak Jerusalem mena rainus, ute nopteanik, ämän keser awaroin, “Bielsebul, kon kar enip Satan, kiro eitek aru nukan osou Jisas nukan wou uru tone kame rau. Bielsebul ko karauk eitek aru kamwareäu kos Jisas sakau nurunuk, osou aru oi kurwareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Keser äiena, Jisas nukas urwarnuk, siakup kouna, kar totok* ämän keser awarowon, “Satan nukas owose ätäi Satan emeriäu? ");
INSERT INTO bbr2013_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Omsau karar pakan roasiret ak aka aka weräianik, aka aka inäumoi, ak om rumuk wa rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Karar owan roasiret ak nais aka aka weräianik, aka aka inäumoi, ak aru maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satan, kamwareäu eitek aru nukan tupsiu ak aka aka weräianik, aka aka inäiaiei, ak sakau wa rawaiei. Ak erekapu wasaräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Kar ros kar sakau ron owa ou kiräi tonea, osap erar wa owai. Amke ko kiro ou atak ro ipou isou muris sisikäi mianik, kon owan osap erekapu owai. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Is epar senes awarom, Anut nukas roasiret akan onok aru pak, akan jeje ämän pak erekapu jäkäi mai. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Utianik, inok ro ko Anut nukan Osou Näu jeje ämän aurai, Anut nukas kiro ron onok aru wa jäkäi murai. Kiro onok aru ko opok orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jisas nukas keser awarowon, owon, akas meter keser äiein, “Osou aru nukas kon wou uru tone kame rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kiro ses opok, Jisas nukan amakut aniaka pak koin. Ak kasik tai raumana, kar ro ko Jisas rawon auraun äsimoroin. ");
INSERT INTO bbr2013_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Roasiret sosop akas Jisas kator rain, Jisas aurin, “Nan anin amunat pak kasik en tai rai itaneisorai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Keser aurna, Jisas nukas ätäi kiro ro totorwon, “Isan ani inok? Isan amaiat inokot?” ");
INSERT INTO bbr2013_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Keser äianik, roasiret ko siakup koi tane rai, amukus apwaromara, awarowon, “Apwarwe, roasiret okoro opok rai, kiro isan ani amaiat! ");
INSERT INTO bbr2013_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Inok roasir ko Anut nukan ronkat tainoriäu, kiro roasir epar ko isan ani, isan äpi, isan amai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisas nukas onoktoroi roasiret Galili An Unik kasakup ämän tamarowon. Roasiret sosop senes koi ko siakup tururna, ko kar ous oik tone tane rawon. Roasiret ak erekapu an kasakup tai rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","3","Jisas nukas totok ämänisar onok sosop tamarowon. Ko ämän keser awarowon, “Ak rowe. Kar ro o uku kuräun kon woia potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","O uku kurenuk, karauk apu opok nowon. Kesernuk, ai rautes pe oi jein. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Karauk o uku ai marmar opok ne kurein. Omnokou eposek sosop wa, okon, kiro o uku kurte tu peanik, käwäu orip sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Utianik, san sakau peanik, kiro o uku tu pein erekapu rurnein. Kinip om wou uru rapor nau wa, okon, erekapu kusakusaianik, urai kurein. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Karauk o uku amurik katuau sop uru neanik, tu pein. Katuaus oi jenuk, jekur taiäun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Karauk o uku omnokou eposek opok noin. Kiro o uku tu peanik, näwäu sarianik, nemauk sosop murkurein. Karauk nemauk karar karar 30 orip murkurein. Karauk nemauk sosop 60 orip murkurein. Karauk nemauk sosop senes 100 orip murkurein.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jisas nukas kiro totok ämän aware kureanik, ko keser awarowon, “Roasiret ak raiaka orip raroi, ak kiro ämän roianik, onoktapau äpu maiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Roasiret ak Jisas ute manona, kon tamareäu roat 12 orip pak karauk roat Jisas pak erek raiäin akas kiro totok ämän onoktapau owo senek rai Jisas totorin. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kos ätäi keser awarowon, “Anut nukas roasiret kamwaraun onok meter ämäi rawon. Rusapai ak, isan tamareäim roat, okon, kiro onoktapau ätär maram. Utianik, karauk roasiret kasik rai, is ak erar totok ämänis karar awaram. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Keserna, Anut nukan ämän roianik, areawon ro Aisaia nukas meter jer wewon rusapai epar peu. Ko keser äiewon, ‘Ak owo osap akan amiakas apariäi, sinuk, ak jekur wa apariäi. Ak owo ämän akan raiakas roiäi, sinuk, ak jekur wa roianik, onoktapau äpu maiei. Ak onoktapau äpu moin maro, akan woiaka pirirna, Anut nukas akan onok aru erekapu jäkäi marowo.’ Aisaia nukas keser jer wewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Keserianik, Jisas nukas kon tamareäu roat keser awarowon: “Kiro totok ämän onoktapau ak äpu wa, ra? Is karauk totok ämän awarom ak owose äpu maiei? ");
INSERT INTO bbr2013_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kiro o uku kar ros woia kurewon, kiro Anut nukan ämän. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Karauk roasiret ak kiro o uku apu opok nowon senek. Ak Anut nukan ämän roin. Erar raiakas rouna, kurte Satan nukas peanik, akan woiaka uruan ämän oi kureäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Karauk roasiret ak o uku ai marmar opok nowon senek. Ak ämän roianik, oumoi, kurte nepipiriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Utianik, kiro ämän akan woiaka uru neanik, omre rumukäu ekep wa raiäu, owon, karauk roat akas ak kiro ämän oin äpu mianik, usu araiei. Keseria, akan woiaka aru momana, Anut nukan ämän roianik, oin kurte erekapu utiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Karauk roasiret ak o uku amurik katuau sop uru tu pein, kiro kon onok kesek, karauk roasiret ak Anut nukan ämän roiäi, utianik, rai rai, ak okoro omnokou pakan onok ronkateanik, osap sosopun akan woiakas meieanik, Anut nukan ämän utiäi. Kiro ämän eposek oin katuaus o uku oi jeäu senek jekur wa muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Karauk roasiret ak o uku omnokou näu eposek opok nowon senek. Ak Anut nukan ämän roin, akan woiaka uru momoi, rapor tainoriäi kiro ämän eposek oin o sosop muriäu senek. Karauk nemauk karar karar 30 orip muriäu, karauk nemauk sosop 60 orip muriäu, karauk nemauk sosop senes 100 orip muriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisas nukas awarowon, “Ak arou aioimana, baket uru ra, pasar inkaruru ämäi miäi ra? Wa, ak arou aioianik, kämioik äsäi miäi. Kiro epar. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Keserna, owo osap akan woiaka uru ämäi raiäu, erekapu amop päi. Owo osap roat akas kururur miäi, tawa erekapu arou merek opok penuk, roasiret aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Roasiret ak raiaka orip, ak kiro ämän roianik, onoktapau äpu maiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jisas nukas ätäiar awarowon, “Ak kiro ämän roi jekur ronkatewe. Ak karauk roat osap ariai senek, Anut nukas ak osap arai. Ak roat osap sosop arona, Anut nukas nais ak ätäi osap sosop arai. Kos ak osap sosop arai. Keseriar, ak karauk roat opok owo onok miäi senek, Anut nukas ak opok nais keseriar keserai. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Kar ro ko karauk ronkat eposek orip, kiro ro Anut nukas karauk ronkat eposek nurai. Utianik, inok ro ko ronkat eposek wäpik, Anut nukas kon ronkat eteinak ate rau kiro erekapu ätäi senri owai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jisas nukas kar ämän awarowon, “Anut nukas roasiret kamwareäu onok kiro kesek: kar ro kon omnokou opok o uku kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Pututu kiro ro ko niniäu, sankeu siräianik, kon karauk sarau miäu opok manowon. Kiro o uku tu pemana, owose näunäu sarein kiro ro ko äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Omnokousar sarau monuk, o uku tu pemoi, tonomara, muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","O näu murunuk, woi atak ros panin atomara, patirai. Owon, o owaun ses pewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisas nukas ätäi awarowon, “Anut nukas roasiret kamwareäu onok owo senek rau awaram? Is kar totok ämän awaroita, rowe! ");
INSERT INTO bbr2013_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kiro onok kar am marmar uku kesek. Kiro am uku karauk senek wa, ko eteinak senes. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Akas kiro am uku omnokou opok wena, kos jaukut itimware, ko am näwäu senes sareäu. Kiro am näwäu sarenuk, ai akas kiro am iporu opok jokoru rawaun tou maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisas nukas roasiret Anut nukan ämän onoktapau orip wa awareäu, ko totok ämänis karar akan ronkat rau siar awariäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ko kar ämän onoktapau orip roasiret awarau wa. Ko totok ämänis karar awariäwon. Utianik, kon tamareäu roat karar nuka pak erek rauna, kos ämän onoktapau erekapu ätär marowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kiro omre opokar, om ironuk, Jisas nukas kon tamareäu roat awarowon, “Ik an unik karaima aisen potau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ak roasiret sosop utwareanik, kon tamareäu roat ak kiro ous Jisas meter tone rawon opok toneanik, erek manoin. Karauk ous nais ak pak erek manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Urir näwäu peanik, an ekur pakurornuk, an ous uru nonuk, an ok päurwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisas ko ous mekesup täptäp opok nini rawon. Kon tamareäu roat akas turarianik, aurin, “Tamukiäum ro, ik anas oike jauru! Na ikenun wa ronkatem ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisas nukas siräimara, urir kermara, an ämän sakau auruwon, “Äiäk! Na ut!” Urir utonuk, an amuk patirmara, päurar tipine rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jisas nukas kon tamareäwon roat awarowon, “Ak owon imine rai? Ak isan onok sosop aparin, utianik, ak isanun woiaka epar mau wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ak sakau imineanik, aka aka arein, “Kiro ro inok? Urir mas an ori kon ämän tainorir.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jisas kon tamareäu roat pak ous oianik, an unik karaima kasakup, Gadara roasiret akan omnokou opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jisas ko ous utomoi, omnokou opok pitir nonuk, kar ro osou aru orip ko op up uru rawonus, koianik, Jisas tararwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ko op mareäi akan aireu uru niniäwon. Kar ros ko sakatau senek itok wa. Ak ko mur sakaus isou ipou pararar miäi, sinuk, kos kiro mur sakau patiriäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Roat akas ko orip orip ipou isou mur sakaus pak sen pak pararar miäin. Utianik, kos kiro mur sakau pak sen pak erekapu pitpatir kureäwon. Kiro ro sakau senes, okon, kar ros ko itimorau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ko orip orip pututu, sankeu, op miäi aireu pak omtapau oik pak raianik, sakau urwemoi, nukasar aiaukus nukan enipsau pitpatiriäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","7","Kos Jisas atapukas aparianik, kurte koumara, Jisas nukan isou siakup uou sur wemara, ko keser sakau urwewon, “Jisas, na Anut kämioik rau nukan mokoi. Na is owoseiraurum? Is Anut nukan enip sakau ateanik, aisom, na is usu wa irau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Kiro ros keser auruwon, owon, Jisas nukas amke auruwon, “Osou aru, na kiro ro ute, man!” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisas nukas ko keser totorwon, “Nan enmat inok?” Kos ätäi auruwon, “Isan enim Sosop. Owon, ik osou aru sosop kiro ron wou uru raum.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Keserianik, osou aru akas ik kar omnokou opok wa äsimoikau rai Jisas sakau ämän aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Po raut sosop kar omtorou karaima o je rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Keseria, kiro osou aru akas Jisas sakau ämän aurin, “Ik äsimoikota, kiro po raut rai akan woiaka uru nam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Keser aurna, Jisas nukas awarowon, “Itok, ak manowe!” Keser awaronuk, osou aru sosop kiro ro utomana, kiro po raut akan woiaka uru tonoin. Kiro po raut sosop 2,000 orip. Ak iminemoi, kurte om aru opokas poteanik, an unik uru neanik, an jemana, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Kiro po kamwareäin roat ak kiro onok aparianik, kurte imine potomoi, akan mena pak karauk kiro mena siakupaian roasiret erekapu awaroin. Awarona, roianik, roasiret erekapu owo onok pewon aparaun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Akas Jisas siakup koianik, kiro ro meter osou aru orip rawon rusapai ko omjo takeanik, ronkat eposek orip tane raunuk, aparin. Roasiret ak kiro aparianik, iminein. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Roasiret ak Jisas nukas kiro onok keserwon aparianik, akas pote, karauk roasiret po raut owosein ämän pak, ro meter osou aru sosop kon wou uru rawon ko eposek sarewon ämän pak erekapu awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Roasiret kiro ämän roianik, ak Jisas akan omnokou utomoi, kar mena manaun rai sakau ämän aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Keserna, Jisas nukas kon ous oik tonaurnuk, kiro ro meter osou aru orip rawon eposek sarewon kos Jisas sakau auruwon, “Is na pak manam, na is ior airam ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Keser aurnuk, Jisas nukas ätäi ko ior aurau wa. Kos kiro ro keser auruwon, “Na nan mena potoinam, Anut nukas na mesin wouti momara, okoro onok keseisowon nan tupsiu erekapu awaram.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Keser aurnuk, kiro ros poteanik, näu mena 10 orip, enip Dekopolis, kiro pakan roasiret Jisas nukas ko owoseanik, sarewon ämän aware ariewon. Roasiret erekapu ak kiro ämän roumoi, karkairianik, ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisas ko ous opok tonomara, Galili An Unik karaimas karaimas ätäi potowon. Ko an kasakupai usnokou opok nonuk, roasiret sosop koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","23","Juda akan tururiäi ou kumeäwon ro kar, kon enip Jairas, ko koianik, Jisas aparmara, isou siakup uou sur wemoi, sakau ämän auruwon, “Isan asinak meiäuru. Na koinam, nan ipon ko opok mota, ko ätäi eposek saräi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jisas an utomoi, ko kiro ro pak erek potoirin. Kesernuk, roasiret sosop ak erek Jisas tainori manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Roasiret ak kamuk kar asir rau. Ko keir sip orip orip oiäu, kiro sip nukan woisan 12 orip rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jekwareäin roat sosop akas ko jekurmana, tätäi sosop nuriäin. Kon aiauk kiro jekuriäi roat opok patariäwon. Utianik, kon sip utau wa, ko sip näwäu oi rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ko karauk roat akas Jisas mesin ämän mona, roianik, roasiret kamuk raumoi, ko Jisas mekesup peanik, Jisas nukan omjo atowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ko keser ronkatewon, “Is kon omjo karar atoita, is ätäi eposek saräm.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Keseria, ko omjo atonuk, kon sip kiro kurte utowon. Ko rowon kon enipsau opok sip rawau wa. Ko eposek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jisas nukas kon sakau manonuk, äpu mianik, pirirmoi, awarowon, “Inokon ipous isan omjo atou?” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kon tamareäwon roat akas aurin, “Roasiret sosop turur rai kotomaisoi, nas owon ‘inokon ipous is atoirou’ räi awaromon?” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Utianik, Jisas nukas inokos keseirowon rai amukusar itanewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Kiro asir owo onok ko opok pewon äpu momara, ko näwäu iminemoi, Jisas siakup uou sur weanik, kon ämän erekapu epar auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Kesernuk, Jisas nukas auruwon, “Asinak, nan won epar mowon, okon, nan enmatsau eposek sarewon. Na won päurar orip man. Nan sip erekapu utai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisas nukas arenuk arenuk, karauk roat ak Juda akan tururiäi ou kumeäwon ro Jairas nukan owas koianik, Jairas aurin, “Jairas, nan asinak meiewon. Na owon tamareäu ro sarau nuram?” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisas nukas kiro ämän roianik, Jairas auruwon, “Na wa iminäu, nan won epar mo!” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ko keser aurianik, roasiret sosop imwarau wa. Pita, Jems, Jon (Jems nukan amak) ak karar Jisas tainori potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","39","Ak Jairas nukan owa kouna, roasiret sosop akas wai rai, käi mirori rain. Jisas nukas apwareanik, awarowon, “Owon ak käi mirori rai? Ak owon wairai? Kiro asinak meiäu wa, ko erar nini rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jisas keser äienuk, ak ko apari ioin. Kos roasiret kasik naun äsimwaronuk, nona, asinak nukan momok anak ori pak, kon tamareäwon roat 3 orip pak, ak karar asinak nukan ou waru uru imware tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Toneanik, kos asinak nukan ipou ateanik, Juda ämänis keser auruwon: “Talita kum”, kiro ämän onoktapau kesek, ‘Asinak isas aisom, na siräu.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kesernuk, kiro asinak kurte siräi ariäwon. Kiro asinak kon woisan 12 orip. Roasiret rain ak kiro kurur aparianik, näwäu karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jisas nukas ämän sakau awarowon, “Ak kiro onok aparin karauk roasiret wa awarau. Rusapai ak kiro asinak karauk o nuruwe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisas kiro mena utomoi, kon tamareäwon roat pak erek nukan mus mena manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sumaun omre opok, Juda akan tururiäi owa tonomara, Anut nukan ämän onoktoroi tamarowon. Roasiret sosop kon ämän roumoi, karkairianik, arein, “Kiro ro ko ämän erapakan owon? Inokos ko ronkat eposek nurunuk, kos kurur atap atap miäu? ");
INSERT INTO bbr2013_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kiro ro ko iken ou miäu ro ra? Ko Maria nukan mokoi ra? Kon amakut Jems, Josep, Judas (Jut), Saimon, kon äpiaukut pak erek ak okoro opok raiäi ra?” Ak keser aremana, ak ko sumkäinein. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Keserna, Jisas nukas akan ämän äpu mianik, awarowon, “Karauk mena Anut nukan ämän roianik, areäu ro, ko enip jou orip, roasiret akas akan woiaka konun epar miäi, utianik, nukan mena senes ko enip jou wäpik, okon, nukan roasiret pak nukan tupsiu pak akas ko sumkäineäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Keserna, ko kiro mena karauk kurur mau senek wa. Ko kon ipou sip roasiret karar karar opok monuk, näu sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jisas nukas roasiret kon ämän mesin woiaka epar mau wa, apwareanik, ronkat sosop owon. Keserianik, Jisas kon mena utomoi, karauk mena poteanik, roasiret Anut nukan ämän tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Kiro ses opok, Jisas nukas kon tamareäu roat 12 orip urwarnuk, siakup kouna, osou aru oi kuräun sakau aromoi, ro oirori oirori äsimwarowon. Ak oirori oirori sarau maun awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Keseria, kos ak keser awarowon, “Ak apu opok potaun kar osap wa owau. Ak naruauk karar oi manowe. Utianik, ak karauk o ra, akan jo ra, karauk aiauk osap kau maun akan jo päisau uru ra, wa oi manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ak akan su karar momoi, omjo oirori wa oi manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ak kar mena potona, kiro pakan roasiret akas imwarona rai, kiro roat akan owa karar rawaiei. Tawa kiro ou utomoi, kar mena potaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Kiro pakan roasiret akas imwarau utomoi, akan ämän rowau utona rai, ak akan owa wa tonaiei. Ak kiro mena ute manaurna, akan onok aru ätär maraun akan isoraka pakan maimai putarwe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ko keser aware kurenuk, kon tamareäu roat akas mena atap atap poteanik, Anut nukan ämän roasiret tamareanik, awaroin, “Ak akan onok aru utoinai, woiaka pirirwe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ak osou aru sosop emwaremana, am ukuauk pakan uer oianik, sip roasiret sosop akan enmaksau opok mianik, jekwarona, näu sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kiro omsau kamwareäwon ro king Herot-Antipas ko rowon, owon, kiro omsau pakan roasiret erekapu Jisas nukan onok äpu moin. Karauk roasiret akas keser äiein, “Kiro an jomariäwon ro Jon, ko meiewon ätäi up uruas siräi pewon, okon, ko kiro kurur atap atap maun sakau orip.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Karauk akas äiein, “Kiro Elaija.” Karauk äiein, “Ko kar Anut nukan ämän roianik, areäu ro. Ko meten Anut nukan ämän areain roasiret senek.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Utianik, Herot nukas kiro ämän roumara, äiewon, “Meter, is Jon nukan pou patir kuremin, utianik, ko meiewon ätäi siräi pewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Ko iminewon, owon, meter Herot nukasar kon amak, Filip, nukan wau, kon enip Herodias, senri owon. Kiro ses opok, Jon nukas Herot auruwon, “Na nan amunan asir oumon, kiro na sintore ämän espäiemon.” Kesernuk, Herot nukas roat awaronuk, poteanik, Jon sakatemoi, ipou muris sisikäimana, karapus owa kurein. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","20","Herodias nukas Jon mesin wou aru momara, wenuk, meiäun keserwon, utianik, Herot ko Jon iminewon. Ko äpu Jon ko Anut nukan ämän roiäu ro. Ko onok eposek miäwon, okon, Herot nukas Jon rapor kamäurnuk, Herodias nukas wäu senek wa. Herot nukas Jon nukan ämän roumara, ronkat sosop oianik, ko Jon nukan ämän ätäi ätäi jekur rowaurwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Rai rai, Herodias nukas Jon wäun kar apu aparwon. Herot ko anakus an jowon omre tararmana, kos kon ou kameäin roat näunäu pak, kon marai roat näunäu pak, Galili provins akan roat näunäu pak erek, äs me jaun imwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Kiro ses opok, Herodias nukan asinak makun koumoi, kiro roat näunäu amiakap karenuk, Herot kon jaukut pak aparianik, akan woiaka näu sarein. Keseria, Herot nukas kiro asinak auruwon, “Nan ronkat owo osap owaun airota, is na isam. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Is ämän epar aisom, is na pak paip momoi, na owo osap owaun airota, is na isam. Na isan omnokou kameäim karaimas isaun airota, kiro itok, is na karaimas isam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Keser aurnuk, kiro asinak kaik neanik, anak totorwon, “Is owo owaun aurau?” Anakus ätäi auruwon, “Nas kesek aur. An jomareäwon ro, Jon nukan tapau wou owaun auram.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Keseria, kos kurte ätäi ro näwäu siakup peanik, auruwon, “Nas rusapaiar, an jomareäwon ro, Jon nukan tapau wou kar maro opok moinam, is iram.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Keser aurnuk, Herot nukan wou usu sarewon. Utianik, kon jaukut pak karauk roasiret ko pak tane o je rain amiakap kiro asinak pak paip mowon, okon, ko kiro paip mowon ämän utaun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Keseria, kos kurte kon marai ro kar äsimornuk, kos Jon siakup pote Jon nukan pou patirmoi, kon tapau kerem oi kowaun auruwon. Keseria, kiro ro karapus owa poteanik, Jon nukan pou patirwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Kos kiro tapau wou kar maro opok mianik, oi koumoi, kiro asinak nurunuk, kos pak oi pote kon anak nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jon nukan tamareäwon roat akas kiro ämän roumoi, koianik, nukan enipsau oi pote up kurein. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Meter Jisas nukas kon ämän oi ariai roat nukas mena atap atap äsimwarowon, ätäi nuka siakup koin. Ak pote owo sarau pak owo ämän roasiret tamaroin pak erekapu ko koi aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Utianik, roasiret sosop akas pote koi, pote koi arna, okon, Jisas kon roat pak o jau senek wa. Keserianik, Jisas nukas awarowon, “Ikarar kar mena ro wäpik opok sumau manau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Keseria, ak akarar ous oianik, kar mena ro wäpik opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Utianik, roasiret sosop ak kiro mena utona, apwareanik, ak erekapu mena utomoi, isorakas kurte ak sinsin potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Keserna, Jisas nukas ous ute nemara, roasiret sosop turur rain apwareanik, akanun wouti mowon. Owon, kon ronkat kiro roasiret ak sipsip senek ak kamwareäu ro wäpik. Keserianik, kos ak ämän sosop onoktoroi tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","36","Rai rai, san naurnuk, kon tamareäwon roat akas siakup koianik, aurin, “Okoro mena ro wäpik, san nauru, okon, nas roasiret äsimwarota, mena atap atap maneanik, ak o kau me jaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Utianik, Jisas nukas ätäi awarowon, “Akasar jaun o araiei.” Akas ätäi totorin, “Utianik, nan ronkat roasiret erekapu eteinanak jaun kiro aiauk 200 kina senekus pote bret kau maun itok. Ik o kiro aiauk näwäu kureanik, o kau momoi, araun, itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisas nukas awarowon, “O erasek rau? Potoinai, aparwe!” Ak äpu momoi, ätäi aurin, “Bret 5 orip pak was oirori pak rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Keser aurna, Jisas nukas ätäi kon tamareäu roat awarowon, “Roasiret amurik eposek opok sarpeter marona, tane potaiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Keseria, roasiret ak erekapu tanein. Karauk roat 100 orip tanein, karauk roat 50 orip tanein. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Keserna, Jisas nukas bret 5 orip pak was oirori pak oianik, omar oik eisane aparmara, Anut ‘pere’ auruwon. Aurmara, bret pärärianik, kon tamareäu roat akas roasiret araun arowon. Was oirori pärärianik, nais kir keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","43","Roasiret ak erekapu kiro o jeanik, nokomaka penuk, Jisas nukan tamareäu roat akas roasiret akas o jein o autakau utoin basket 12 orip oumana, joke moin. Kiro basket erekapu ok pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Roat kiro o jein 5,000 orip. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kiro ses opokar, Jisas nukas kon tamareäu roat äsimwaronuk, ous opok toneanik, an unik karaimas Betsaida mena amke manona, Jisas nukarar roasiret akan mena äsimwaraun rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ko roasiret äsimwaronuk, manona, ko nukarar om nepu opok Anut auraun tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Iukärir, omiri kounuk kounuk, ous an unik näu kamuk raunuk, Jisas nukarar an kasakup rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","49","Jisas nukas kon tamareäu roat sarau näwäu momoi, ous nukan amauk reurin manau senek wa, uriris pairnuk, aparwon. Om teine kounuk kounuk, Jisas nuka an unik oikas ari ari kowon. Jisas nuka kon tamareäu roat itimware potaurwon, utianik, ak ko an opokas ari rawon aparianik, akas ko op rai ronkateanik, pierin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ak näwäu iminein. Keserna, kos kurte awarowon, “Ak woiaka sakau rawe! Okoro isaka, ak wa iminäu!” ");
INSERT INTO bbr2013_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Keser awaromoi, Jisas nuka ous opok toneanik, ak pak erek raunuk, urir utowon. Ak karkairianik, ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ak Jisas nukas roat bret arowon kiro onok keserwon nukan onoktapau jekur äpu mau wa, okon, akan woiaka sakau maronuk, ak kon onok äpu mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jisas kon tamareäu roat pak ak an unik kure poteanik, Genesaret omnokou kasakup poteanik, kiro opok ous mur kure moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","55","Ous utonuk, roasiret kiro opok Jisas äpu mianik, ak kiro omnokou opok atap atap mena poteanik, karauk roasiret Jisas erapok rau rai awarona, sip roasiret pasar opok mareanik, imware koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Näu mena ra, mena eteinak ra, apu opok ra, ko erapok ariäwon opok ak sip roasiret om sorik opok marona, rain. Ak Jisas keser sakau aurin, “Na kiro sip roasiret utwarota, koi akas nan omjo peteu ataiei.” Keseria, sip roasiret akan ipiakas Jisas nukan omjo ateanik, ak erekapu näu sarein. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","2","Karauk Parisi roat pak karauk sintore ämän tamareäin roat pak Jerusalem näu mena utomoi, koumana, Jisas siakup tururmoi, Jisas nukan karauk tamareäu roat ak Parisi akan sintore ämän tainorianik, akan ipiaka an kosorau wa, ak erar o je rain apwarin. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Parisi roat pak Juda* roat näunäu pak ak akan askanain sintore ämän jekur tainorianik, akan ipiaka wa an kosoriäi, o wa jeäin. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","O kau maun omoi amket opokas ätäi owa koianik, ak amke an jowaiei, warnuk, ak o wa jaiei. Ak karauk askanai akan sintore ämän sosop tainoriäin. Ak kiro ämän äiäu senek akan kap, maro, patan pak erekapu an kosoriain.) ");
INSERT INTO bbr2013_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Keseria, kiro Parisi roat pak ämän tamareäin roat pak akas Jisas keser totorin, “Nan tamareäumon roat akas owon akan askanai akan onok wa tainoriäi? Ak o jauri akan ipiaka an wa kosoriäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisas nukas ätäi awarowon, “Meter Anut nukan ämän roianik, areawon ro Aisaia nukas ak sätäiäin roat mesin epar äiewon. Ko keser jer wewon, ‘Anut nukas äiewon, “Kiro roasiret akas erar oiaksaus isan enim rororiäi, utianik, akan woiakas isanun meiäu wa. Ak isan ämän awareäim ak jekur wa tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ak kar ron sintore ämän tainoria, ak keser äiäi kiro Anut nukan ämän. Ak sät ämän tainorianik, ak isan enim erar rororiäi!” ’ ");
INSERT INTO bbr2013_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ak Anut nukan sintore ämän utomoi, akan askanai akan onok sakau ateanik, tainoriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jisas nukas ätäi keser awarowon, “Ak Anut nukan ämän utianik, akan askanai akan ämän tainormoi, akasar akan ronkat tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses nukas meter awarowon, ‘Na nan momon aninan ämän tainor.’ ‘Inok ro kon momok anak jeimarai karauk roat akas ko wena, meiäi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Utianik, ak keser ämän miaäi, ‘Inok ro ko osap orip kon momok anak ori sarwataun itok. Utianik, ko au awateäu. “Is kiro osap Anut nuraun karar sare momin rau. Keseria, is au sarwatau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Keseria, rusapai ko kon momok anak ori wa kamwateäu. Ak kiro onok eposek auriai. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Keserianik, ak akan askanai akan onok tainorianik, Anut nukan ämän tonoi miäi. Ak karauk onok kesek sosop keseriäi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jisas nukas roasiret ätäi urwarnuk, kouna, awarowon, “Ak erekapu isan ämän roinai, jekur ronkat oumoi, äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Kar osap kasik rawon kar ro nukan wou uru toneäu, kiro osapus Anut nukan amukup ro ukun wa kureäu. Utianik, kiro ron ronkat aru wou uru rau siräienuk, kon oksaus äiäu kis epar ko ukun kureäu.  ");
INSERT INTO bbr2013_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Roasiret ak raiaka orip raroi, ak kiro ämän roianik, kon onoktapau äpu maiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jisas ko kiro roasiret utwareanik, owa tononuk, kon tamareäu roat akas kiro ämän äiewon onoktapau mesin totorin. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Keserna, Jisas nukas ätäi awarowon, “Akan ronkat eposek wa ra? Ak kiro onok äpu wa ra, osap kasikrawon kar ro nukan wou uru neäu, kiro osapus Anut nukan amukup ro ukun wa kureäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Kiro o jeäi kiro wou uru wa neäu, kiro pi pimur uru äräreiäu, ätäi pimur uruas koianik, neäu.” Ämän kiros, Jisas nukas o erekapu jaun kiro itok äiewon. Kar o asu rawau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jisas nukas ätäi awarowon, “Ronkat aru roasiret akan woiaka uru raiäu, siräianik, oiaksau opokas peäu, kiro ronkatis karar epar ukun kurwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","22","Woiaka uruas roasiret ak kiro ronkat aru keser oiäi; ak sapum onok aru maun ronkateäi, ak jaunakat akan osap päu owaun ronkateäi, ak roasiret akwarona, meiäun ronkateäi, ak karauk roat akan asiret aru maraun ronkateäi, ak osap sosop meswaronuk, owaun ronkateäi, ak karauk roasiret opok onok aru sosop maun ronkateäi, ak sät ämän maun ronkateäi, ak karauk roasiret mesin wa ronkatwareäi, ak erar onok aru maun ronkateäi, ak jaunakat akan osap aparianik, meswareäu, ak jaunakat akan enmakap sät ämän maun ronkateäi, ak karauk roat akan ämän rowau utiäi, ak otop onok miäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kiro onok aru erekapu akan woiaka uru raumoi, kasik neäu, kis Anut nukan amuk opok ak ukun kurwareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jisas nukas kiro ämän me kureanik, kiro mena utomoi, Taia mena siakup potowon. Ko kar owa tone raunuk, kar ros ko kiro opok rauräi äpu murau senek wa rai ronkatewon, sinuk, ko ämäiäu senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kesernuk, kiro ses opokar, kar asir kon asinak osou aru wou uru raiäu, kos Jisas kiro opok rau ämän roumara, kurte koianik, Jisas siakup uou sur wewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Kiro asir Juda asir wa. Ko Grik asir, kon mena Fonisia, Siria provins pakan. Kos Jisas keser sakau auruwon, “Osou aru isan asinakun wou uru rau, nas oi kur.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kesernuk, Jisas nukas ätäi auruwon, “Amke ik Juda akan mokoit o arau. Mokoit akan o oianik, en wa kure mareäum. Kiro onok aru.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Kiro asires ätäi auruwon, “Näu ro, kiro epar, utianik, enat patan inkaruru raianik, mokoit akan o usip nonuk, oi jeäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Keser aurnuk, Jisas nukas ätäi auruwon, “Na eposek ämän airom. Na ätäi manam. Kiro osou aru nan asinakun wou uru rawon kiro ute manowon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Kiro asir kon owa poteanik, aparwon kon asinak pasar opok nini raun, osou aru wou uru rawon ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisas ko Taia mena utomara, Saidon omnokou itimormoi, näu mena 10 orip enip Dekopolis omnokou kamuk opok Galili An Unik siakup potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Karauk roasiret akas kar ro rauk otop saremoi, menopauk usu sarewon orip Jisas siakup imäi koin. Ak Jisas sakau aurin, “Nan ipon kiro ro opok mo.” ");
INSERT INTO bbr2013_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Keseria, Jisas nukas roasiret utwareanik, ko imäi keresir manowon. Aukarar raianik, Jisas nukan ipouaukus kiro ron rauk oirori uru mowon. Kon sinok oumara, ron menopauk opok mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kos omar eisane aparianik, kon wou usuäu saremara, suornuk, Juda ämänis kiro ro keser auruwon, “Epata!” Kiro ämän onoktapau kesek ‘Im tue!’ ");
INSERT INTO bbr2013_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Keser aurnuk, kiro ron rauk näu sarenuk, ko ämän jekur rowaun itok. Kon menopauk näu sarenuk, ko ämän rapor onoktoroi arewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Kiro ses opok, Jisas nukas roasiret sakau awarowon. “Ak kiro onok apari mesin pote karauk roasiret wa awarau.” Jisas nukas ätäi ätäi ak sakau ämän keser awarowon, sinuk, ak kon ämän tainorau wa, ak ämän sue kurein. ");
INSERT INTO bbr2013_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Roasiret akan ämän roianik, ak erekapu karkairianik, äiein, “Ko owo onok miäu erekapu onok eposek senes. Kos roasiret raiaka otop jekwaronuk, ämän roiäi, menopauk usuäu sarewon ätäi ämän jekur areai. Kos keseriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","2","Kiro ses opok, roasiret sosop koi tururin. Ak o wäpik rauna, Jisas nukas kon tamareäu roat urwarnuk, kouna, awarowon, “Is kiro roasiret akanun woiti mou. Ak is pak omre 3 orip rain, okon, rusa ak o wäpik rai. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Is kiro roasiret äsimwaroita, akan owa potaiei, ak apu opok pote amkoririwaromoi, owarai. Karauk ak apu rumukäu koin.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Keser awaronuk, kon tamareäu roat akas ätäi aurin, “Ik okoro ro wäpik omnokou opok raum. Ik erapakan o oianik, roasiret arota, jaiei?” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisas nukas totwarowon, “Ak bret esap esap rau?” Akas ätäi aurin, “7 orip.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Keserna, Jisas nukas roasiret onkapai tanäun awaronuk, ak tanein. Kos bret 7 orip oumara, Anut ‘pere’ aurmoi, bret pärärianik, kon tamareäu roat aronuk, akas pak roasiret arona, jein. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ak karauk upinan was eteinanak orip, okon, Jisas nukas kiro oianik, Anut aurmoi, kon tamareäu roat aronuk, akas pak roasiret aroin. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Roasiret ak kiro o jeanik, erekapu nokomaka pewon. Karauk o autakau utoin raunuk, Jisas nukan tamareäu roat akas basket 7 orip oianik, kiro o jein autau joke mona, ok pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","10","Kiro o jein roasiret ak 4,000 orip. Jisas nukas ak akan mena äsimwaronuk, manona, ko kon tamareäwon roat pak ous opok toneanik, Dalmanuta omnokou opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Karauk Parisi roat akas koianik, Jisas ate aparaun aurin, “Na kar kurur ätär mukota, kiro epar ik äpu mam, na Anut omar oik rau nukasar kiro sakau isiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ko wou suornuk, awarowon, “Rusapaian roasiret owon is kar kurur ätär maraun airoi? Is ak epar senes awarom, kiro ses opok is kar kurur wa ätär maroita, aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Keser awareanik, Parisi roat utwaromoi, ous opok ätäi toneanik, an unik karaimas potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisas nukan tamareäu roat ak rakuswarnuk, karauk bret owau wa, ak erar manoin. Ous opok kar bret eteinak karar rawon oi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jisas nukas ak sakau ämän keser awarowon, “Ak Parisi pak Herot nukan roat pak akan bret makona, noroiäwon marasin enip jis ak jekur aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","17","Kon tamareäwon roat akas aka aka areanik, arein, “Ik bret oi kowau wa, okon, ko kiro ämän aikou.” Jisas nukas akan äkän äpu mianik, “Ak bret wäpik mesin owon arerai? Is ak pak om ses rumukäu raianik, onok sosop tamaromin, owon ak kiro onok jekur ronkatäu wa? Ak isan onok äpu wa ra? Akan woiaka sakau sarera? ");
INSERT INTO bbr2013_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ak amiakas apari, sinuk, ak osap jekur aparau wa ra? Ak raiakas roiäi, sinuk, ak ämän jekur rowau wa ra?. Ak meten onok ätäi ronkatäu senek itok wa ra? ");
INSERT INTO bbr2013_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Is bret 5 orip oumoi, pärärianik, roat 5,000 orip aroita, jein, ak o autakau erasek jowa joke moin?” Akas ätäi aurin, “Jo 12 orip.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jisas nukas ätäi totwarowon, “Kar ses opok is bret 7 orip oianik, pärärmoi, roat 4,000 orip aroita, jein, akas o autakau erasek jowa joke moin?” Akas aurin, “Jo 7 orip.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Keseria, kos awarowon, “Ak rusapai isan onok äpu mau wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ak Betsaida mena kouna, karauk roat akas kar ro amuk utup imäi koianik, ämän sakau Jisas keser aurin, “Nan ipon okoro ro opok mo.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jisas nukas kiro ro amuk utup nukan ipou ateanik, mena kasakup imäi manowon. Kiro ron amuk uru sinok kureanik, kon ipous kiro ron amuk opok mianik, totorwon, “Na kar osap aparaun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ros apwareanik, auruwon, “Is roasiret apwarom. Ak am senek ari rai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jisas nukas ätäi kon ipou ron amuk opok monuk, ko sakamarnuk, ko rapor amareanik, ätäi osap erekapu rapor apwarwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jisas nukas kiro ro kon owa äsimorianik, auruwon, “Na ätäi mena wa tonau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisas kon tamareäu roat pak erek Sisaria-Filipai mena atap atap potoin. Apu opok pote pote rai, kos kon tamareäu roat totwarowon, “Roasiret akas is inok äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ak ätäi aurin, “Karauk roasiret akas keser äiäi, ‘Ko an jomareäu ro, Jon.’ Karauk akas äiäi, ‘Ko Elaija.’ Karauk akas äiäi, ‘Ko Anut nukan ämän roianik, areäwon ro kar.’ äiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Keser aurna, Jisas nukas ätäi aka totwarowon, “Akasar is inok aiäi?” Pita nukas ätäi auruwon, “Na Krais, Anut nukas kon roasiret ätäi imwaraun äsimoisonuk, koumon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Pita nukas keser aurnuk, Jisas nukas ak sakau awarowon, “Kiro epar, utianik, kiro ämän ak karauk roasiret wa awarau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Kiro ses opok, Jisas nukas onoktoroi ämän tamareanik, kon tamareäu roat keser awarowon, “Ro Nukan Mokoi, tätäi sosop oumara, Juda roat näunäu pak Anut kamuk raiäi roat pak sintore ämän tamareäi roat pak erek akas isan ämän rowau utomoi, sumkäinäiei. Akas is iworona, meiäm. Utianik, omre 3 opok is ätäi siräiam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Kos kiro ämän amop maronuk, Pita nukas ko kasakup imäi maneanik, kermara, auruwon, “Wa senes wa! Kiro onok na opok wa päi!” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Utianik, Jisas nukas piririanik, kon tamareäu roat apwareanik, Pita keser kerwon, “Satan, na is mekesirap man! Na Anut nukan ronkat eposek wa tainoriäum, na roat akan ronkat karar tainoriäum.” ");
INSERT INTO bbr2013_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Keseria, ko roasiret sosop pak kon tamareäu roat pak urwarnuk, kouna, keser awarowon, “Inok ro is tainoire päun, ko nuka mesin wa ronkatäi, kon am äpäs nukasar ämäianik, is tainoirai. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Inok ro ko kon totok awau rawaun ronkateäu kiro kon totok aru mai. Utianik, inok ro ko isanun pak Anut nukan Ämän Eposek pakaima meiäi, kiro ro kon totok orip orip jekur eposek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Kar ro omnokoupaian osap erekapu oumara, ko meiäi. Kiro osapus nukan totok awau rawaun owose saräi? ");
INSERT INTO bbr2013_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ko owo osap oianik, ätäi nukan totok awau rawaun kau mai? Wa, ko ätäi nukasar nukan totok kau mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Inok ro rusapaian roasiret onok aru miäin akan amiakap is tainoraun iminäi, kos is äpu wa äianik, isan ämän ämäi mai, is Ro Nukan Mokoi, tawa isan monian arou näwäu pak sarau eitek eposek raut erek koi isas nais kiro ro äpu wa äiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jisas nukas ätäi awarowon, “Is ak epar awarom, karauk roat ak okoro omnokou opok rai, karauk wa meiäiei, utianik, ak rauna raunar, Anut nukan kamwaraun onok sakau orip amop päi aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Omre 6 orip utia, Jisas nukas Pita, Jems, Jon pak imware, omtapau rumukäu oik tonomara, ak karar rain. Akan amiakap Jisas nukan enipsau pirirmara, atap pewon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kon omjo san nukan merek senek jeremara, ärneu senes sarewon. Omnokou opok kar ron omjo ärneu senes kesek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kesernuk, ak Elaija Moses ori au peanik, Jisas pak arere rairin apwatoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita nukas Jisas auruwon, “Tamukiäum ro, ik okoro opok rawaun eposek. Na äuta, ik akan jan ou 3 orip mam, kar nan, kar Moses nukan, kar Elaija nukan.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","7","Ak imineanik, Pita nukas owo ämän maun äpu wa, okon, ko erar keser äienuk, kar iou näwäu omar oikas ak kurururware mowon. Kar oksaus kiro iou uruas, äiewon, “Kiro mokoi isakan senes, is konun isan woias meieäim. Ak kon ämän rapor rowaiei!” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Keser äienuk, akan amiakas aparin, ak kar ro aparau wa, Jisas karar ak pak erek rawon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ak omtapau ute ne ne rai, Jisas nukas sakau ämän keser awarowon, “Okoro onok ak amiakap pewon aparin ak pote kar roasir wa aurau. Ro Nukan Mokoi, meiemara, ätäi up uruas siräunuk, kiro ses opok owo onok aparin kiro epar roasiret awaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Keseria, ak kiro ämän ämäi ämäi atomoi, ak aka aka äiein, “Up uruas ätäi siräiaun, kiro owo onok rä?” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Akas Jisas totorin, “Juda akan sintore ämän tamareäi roat akas owon Elaija ko amke kowai äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jisas nukas ätäi awarowon, “Ak kiro epar äiäi, Elaija ko amke koianik, osap erekapu jekur mora. Utianik, Anut nukan ämän jer we moin rau owon keser äieu, ‘Ro Nukan Mokoi tätäi sosop ounuk, roasiret akas ko sumkäinäiei’? ");
INSERT INTO bbr2013_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Utianik, is ak epar awarom, Elaija ko amke kowon, roasiret akas akan ronkatis onok aru atap atap ko opok keserin. Ak kiro onok ko opok keseraiei mesin meter Anut nukan ämän jer we moin rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jisas kon tamareäu roat 3 orip ak karauk tamareäu roat siarakap koianik, akas roasiret sosop koi tururin pak, karauk sintore ämän tamareäi roat akas ak pak aurate rain apwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Roasiret akas Jisas kounuk, aparmana, karkairianik, kurte ko siakup potea, ‘Pere,’ aurin. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jisas nukas totwarowon, “Ak owon ak pak ämänis weräirai?” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kar ro, roasiret kamuk rau kos ätäi auruwon, “Tamukiäum ro, isan mokoi osou aru wou uru raunuk, ok utup raunuk, na siatap imäi koim. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kiro osou arus ko sakau ateanik, oi omnokou opok känkurenuk, au sipar kurarianik, aukpanak kartitirmoi, enip tipine kureäu. Is nan tamareäum roat osou aru emeraun rai awaromin. Utianik, ak emeraun itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisas nukas roasiret kewareanik, ätäi äiewon, “Roasiret rusapai rai, akan ronkat owo senek ak woiaka epar mau senek wa. Omre esap esap is ätäi ak pak rawam? Omre esap esap is akanun ätäi woias meiäm? Kiro mokoi is siarap imäi kowe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Keseria, ak kiro mokoi imäi Jisas siakup kouna, osou arus Jisas aparianik, kurte kiro mokoi ate karemara, känkurenuk, omnokou opok kurir momara, nini taitairmoi, au sipar kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisas nukas mokoin momok totorwon, “Omre esap esap ko kiro keser rawon?” Momokus ätäi auruwon, “Mokoi eteinak pakar keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kiro osou arus orip orip ep mik oi kureäu, an unik uru oi kureäu wenuk, meiäun keseriäu. Utianik, na kar onok keseraun itok raroi, na iwenun wonti moinam, iu sareitam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Keseria, Jisas nukas auruwon, “Na owon keser äiem, ‘Na kar onok maun itok ra?’ airom. Kar ro is mesin wou epar miäu, kos onok erekapu keseraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Keser aurnuk, mokoin momokus kurte urweanik, äiewon, “Is na mesin woi epar mowon, utianik, isan woi epar mowon, kiro eteinak, okon, nas is sareir.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisas nukas roasir sosop kurte ko siakup kouna, apwareanik, osou aru sakau auruwon, “Na, osou ok utup, rauk otop, is na aisom, na kiro mokoi rurisa utoinam, man. Na ätäi kon wou uru wa tonam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Keser aurnuk, kiro osou aru piormoi, mokoi sakau ate kareanik, ute manonuk, mokoi op meiewon senek nini rawon. Roasiret sosop akas aparianik, äiein, “Ko meiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Utianik, Jisas nukas kon ipou ateanik, rurarnuk, siräiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Keseria, Jisas ko ute owa tonomoi, kon tamareäu roat pak akarar raianik, akas ko totorin, “Ik owo onokun kiro osou aru oi kuräu senek itok wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Kos ätäi awarowon, “Ak Anut karar auri rawaiei, kiro onok kararas epar osou aru emeraiei. Kar onokus kiro itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Ak kiro mena utomoi, Galili provins kampai ari ari potoin, owon, ko kon tamareäu roat ämän tamareäu, okon, Jisas kar ros ko erapok rau äpu maun utowon. Kos keser awarowon, “Karauk roasiret akas Ro Nukan Mokoi sakateanik, roat akan ipiaka opok maiei. Ko wena, meieanik, omre 3 opok ko ätäi up uruas siräiai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ak kiro ämän onoktapau äpu wa. Utianik, ak iminemoi, ko kar ämän totorau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ak Kapaneam mena koumoi, kar owa toneanik, Jisas nukas totwarowon, “Ak apu opok koi rai, owo ämän arein?” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Akas ko kar ämän ätäi aurau wa, owon, apu opok, ‘inok ro näwäu senes enip orip karauk roat itimwareäu?’ aka aka keser äiein. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Keseria, Jisas nukas tanemara, kon roat 12 orip urwarnuk, kouna, awarowon, “Inokos ro enip näwäu orip saräun, ko erar ep ro senek raianik, karauk roat akan sarau ro senek sareanik, roasiret erekapu isanwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","37","Keser awareanik, kar mokoinak imäumoi, ak kamuk tai momara, pokäir raianik, awarowon, “Inok ros isanun ronkatemoi, kar mokoi okoro mokoinak senek imäianik, jekur kameäu, kiro ko is imäiriäu. Inok ros is imäiriäu, ko is karar wa imäiriäu, kiro ko isan moni is äsimoirnuk, koimin, imäiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon nukas Jisas auruwon, “Tamukiäum ro, ik kar ro nan enmat pakas osou aru oi kurenuk, aparmun. Ko iken jaunok wa, okon, ik kiro ro kiro onok wa keserau rai aurumun.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisas nukas ätäi awarowon, “Ak ko wa tämurau. Kar ros kar kurur isan enim pakas miäu, kos is kurte wa jeimairai. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Inok ro ko iken iwäi jaunok wa, kiro iken jaunok. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Is ak epar senes awarom, inok ros ak isan jaiat rai äpu mareanik, an jaun an arai, kiro ro Anut nukas wa sumkäinai, tawa ko epar omar oik osap eposek owai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Kar mokoinak is mesin kon wou epar mowon kar ros ko onok aru ätär muronuk raroi, kiro onok aru senes. Karauk roat akas aiauk usuäu oianik, kiro ron pou opok muris pararar mianik, an unik uru känkurena, nai, kiro itok, kiro usu eteinak. Warnuk, tawa omar oik, ko usu näwäu senes owai. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nan iponas onok aru monuk rai, nan ipon kar patir känkuräm, kiro itok. Keserianik, ipon karar orik na orip orip eposek awau rawam. Na kiro wa keserta rai, kiro ipon oirori orip pak erekapu ep wa koseriäu uru kureisaiei.  ");
INSERT INTO bbr2013_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kiro mena mamat sosopus roasiret akan enmaksau tukware raunuk, ak wa meiäiei, kiro ep wa koserai. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Nan isonas onok aru monuk rai, kar ison patirnam, känkuräm. Keserianik, ison karar orik na orip orip eposek awau rawam. Na wa keserta rai, ison oirories na kiro mena ep näwäu wa koseriäu uru känkureisaiei.  ");
INSERT INTO bbr2013_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Kiro mena mamat sosopus roasiret akan enmaksau tukware raunuk, ak wa meiäiei, kiro ep wa koserai. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Nan amunauk kararas onok aru monuk, reusunuk rai, kiro amunauk kiro etkoi känkuräm, amunauk karar kiro itok. Na orip orip eposek awau rawam. Na kiro wa keserta rai, na ran amunauk oirori orip pak erekapu ep näwäu orip orip jeräu mena kureisaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kiro mena mamat sosopus roasiret akan enmaksau tukware rawai, sinuk, ak wa meiäiei, kiro ep wa koserai. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Siu o opok kureäi kiro o wa poomreäu senek, Anut nukas kon roasiret ate aparaun usu ariäu, okon, ak sakau sareanik, wa wasaräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Siu osap eposek, o wa poomreäu. Utianik, siu nukan sakau manonuk rai, kiro sakau ätäi owose owai? Onok eposek siu sakau senek akan woiaka uru moinai, kiro onokun ak jaunakat pak wa weräiäu, ak woiaka karar orip eposek rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisas kiro mena utomoi, Judia provins opok Jordan An kasakup potowon. Roasiret sosop ätäi koumoi, tururianik, Jisas nukas kon onok tainorianik, Anut nukan ämän tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Karauk Parisi roat koianik, ko ate aparaun keser totorin, “Iken sintore ämänis äieu, ro kon wau utaun itok ra, wa?” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisas nukas ätäi awarowon, “Moses nukas owo sintore ämän sakau awarowon?” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Akas ätäi aurin, “Moses nukas keser aikowon, kar ro kon asir utonuk, manaun ko kar jer wemara, kon wau nurai. Kesermara, epar ko wau utonuk, manai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisas nukas ätäi awarowon, “Moses nukas akan woiaka sakau mona, apwarwon, okon, kiro sintore ämän jer we arowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Utianik, meter Anut nukas omnokou ate mowon ses opok, ko ro pak asir pak ate matowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","8","Kiro onokun, ro kon momok anak ori utwatomara, kon wau ori erekur atap raianik, awan enmaksau karar tururaieir. Keseria, kiro ro asir ori awan enmaksau atap atap oiroror rawau wa, utianik, awan enmaksau karar senek sare rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Keserianik, Anut nukas au karar enmaksau senek turur matowon, okon, kar roasires ätäi wa inäi matau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jisas keser awareanik, ätäi owa tononuk, kon tamareäu roat akas kiro ämän mesin totorin. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kos ätäi awarowon, “Inok ro kon wau utomara, ko kar asir owai, kiro, ro asir ouratäiäi akan sintore ämän espäianik, onok aru kon wau opok mai. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kiro senek keseriar, waus kon komuk utomara, ko kar ro pote owai, kiro asires sintore ämän espäianik, onok aru kon komuk opok mai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","14","Karauk roasiret akas akan mokoinakut Jisas nukas kon ipou akan tapiaka ateanik, sakau araun rai, imware koin. Utianik, kon tamareäu roat akas kiro roasiret kewarona, Jisas nukas kiro onok aparianik, ko wou aru momoi, kon tamareäu roat keser awarowon, “Ak kiro mokoit utwarona, ak is siarap kowaiei. Ak wa tämarau. Roasiret ak okoro mokoinakut senek, ak äpu Anut ko akan kamwareäu ro näwäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Is ak epar senes awarom, inok roasir ko mokoinak senek saräu wa, ko Anut nukan roasir tuku wa rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Keser awareanik, Jisas nukas mokoinakut imware oi wauk orori kurwareanik, kon ipou akan tapiakap momara, Anut nukas ak jekur kamwaraun auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisas nukas kiro mena ute manaun siräi nonuk, kar ros ko siakup kurte koianik, uou sur wemoi, totorwon, “Tamukiäum ro eposek, is owo onok eposek kesermoi, isan totom awau orip orip rapor rawai?” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jisas nukas ätäi auruwon, “Na owon is ro eposek airom. Kar ro karar ko eposek. Kiro Anut karar. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Na iken sintore ämän äpu. ‘Na kar ro weta, wa meiäu, na kar ron asir wa imäi ariau, na karauk roat akan osap wa päu owau, na kar ro nukan enkup sät ämän wa mau, na nan jaunan osap erar owaun wa sätäiäu, na nan momon anin orien ämän erekapu tainor,’ kiro na äpu.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Kiro ros ätäi auruwon, “Näu ro, meter is eteinak opok kiro sintore ämän erekapu tainori koi, rusapai nais keseriar raim.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisas nukas kiro ämän roianik, kiro ro mesin wous meieanik, amukus aparmara, auruwon, “Kiro itok, kar onok karar na itimoisi rau. Na pote, nan osap erekapu karauk roat are kureta, akas kiro osap kau mona, kiro aiauk oinam, saruku roat osap wäpik kiro aiauk inäi aram. Na kiro keseria, tawa omar oik osap sosop owam. Na pote, kiro onok kesernam, koi is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Kiro ro ko osap sosop orip, okon, kiro ämän roumara, ko wou usu sarenuk, nepu aru mianik, ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Kesernuk, Jisas nukas kon tamareäu roat amukus apwarea, awarowon, “Roat osap sosop orip ak Anut nukan roasiret saräun kananäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kon tamareäu roat kiro ämän roianik, karkairina, Jisas nukas ätäi awarowon, “Mokoit, kar omnokou pakan ro Anut nukan ro saräun kos sarau sakau mai. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kar opur kamel ko omjo näkeäi nil nukan amarer uruas tonaun kananäi. Utianik, roasiret osap sosop orip ak Anut nukan roasiret saräun kiro näwäu kananäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Keser awaronuk, kon tamareäu roat ak näwäu karkairianik, kesek aurin, “Keseria, Anut nukas inok ro imäienuk, ko pak erek orip orip rawai?” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisas nukas apwareanik, awarowon, “Roat akas kar onok keseraun itok wa, Anut nukas karar kiro onok keseraun itok. Anut nukas owo onok keseraun ronkatemoi, erekapu keseraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ko keser äienuk, Pita nukas auruwon, “Rou! Ik iken osap erekapu utomoi, na tainoise koumun!” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Jisas nukas ätäi auruwon, “Is na epar aisom, inok ro isanun ronkateanik, Anut nukan Ämän Eposek araun, kon mena, awakut, amakut, äpiaukut, anak, momok, mokoit, omnokou pak utwareanik, kowon, tawa Anut nukas kiro osap ute kowon senek sosop, 100 orip senek, ätäi nurai. Ko rusapai okoro omnokou opok, ou sosop, awakut, äpiaukut, anakut, mokoinakut, pak omnokou sosop ak oianik, rawaiei. Utianik, kiro ses opokar, karauk roat akas ko onok aru muriäi. Utianik, tawa ko orip orip eposek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Roat sosop ak rusapai enmaka näunäu orip rai, tawa ak enmaka wäpik ro senek rawaiei. Utianik, roat rusapai erar rai, tawa akas enmaka näunäu orip rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisas nukas kon tamareäu roat pak Jerusalem näu mena toptaun ari ari pote rai, Jisas nuka amke potowon. Kon tamareäu roat akas ko kiro mena tonaurnuk, ronkat sosop oin. Roasiret akas tainware kouna, iminein. Jisas nukas kon tamareäu roat 12 orip ätäi imwareanik, owo onok ko opok päi awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Kos keser awarowon, “Rowe. Ik rusapai Jerusalem mena potota, karauk roat akas Ro Nukan Mokoi Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak akan ipiaka opok maiei. Keseria, kiro roat akas akan ämän roianik, wena, meiäun ämän ateanik, karauk omsau pakan roat akan ipiaka opok maiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Akas ko jeje ämän aurianik, opokup sinok kuremoi, mänkäsirianik, wena, meiäi. Utianik, omre 3 opok, ko ätäi siräiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Keser awaronuk, Jems Jon ori, Sebedi nukan mokoit ori, awas Jisas siakup koumoi, keser totoririn, “Tamukiäum ro, iwes na iu sareitaun aisamur siar na kiro ämän tainoraun aisom.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Keseria, Jisas nukas ätäi awatowon, “Awas is owo onokus au sarwataun airoir?” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Awas keser auririn, “Nas iu pak paip keser mam, tawa nas kamwaraun ro näwäu sareanik, iu imäitota, karas nan ipon näu kaima tanäi, karas saunan kaima tanäi. Keseitota, iu na pak rawamur.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisas nukas ätäi awatowon, “Kiro ämän totoiroir kon onoktapau au äpu mau wa. Is kiro an kap opok rau jam, au kiro an jaun itok ra? Is an joianik, tätäi näwäu owam siar, au kiro senek owaun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","40","Awas ätäi auririn, “Io, iu itok.” Keseria, Jisas nukas awatowon, “Kiro epar. Kiro an kap opok rau is jam, au nais jaieir. Is an joianik, tätäi owam, au nais keseriar an jowaieir, utianik, inokos isan ipi näu kaima tone tanäi, inokos isan ipi saunan kaima tanäi, kiro isan sarau wa. Anut nukasar karauk roasiret sare mareanik, akan omoi jekur marowon rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jisas nukan tamareäu roat 10 orip akas kiro ämän roianik, ak Jems Jon ori mesin kasiaka pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Keserna, Jisas nukas ak urwarnuk, siakup kouna, awarowon, “Ak äpu, okoro omnokou pakan roat akan karauk kamwareäin roat näunäu akas akan enmak jou momoi, akan roasiret kamwareäi. Roasiret akan roat näunäu akas roasiret akan ämän tainoraun sakau ämän awareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ak isan roat, ak kiro onok wa keserau. Utianik, kar ros akan ro näwäu rawam äienuk rai, kiro itok amke ko akan sarau ro senek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kar ros is enim jou orip rawam äienuk rai, amke ko roasiret erekapu akan sarau ro (slev) senek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Owon, Ro Nukan Mokoi karauk roasiret akas ko isanaraun kowau wa. Wa! Ko karauk roasiret sarwaraun kowon. Ko meieanik, roasiret sosop ätäi Anut nuka rawa imware tonai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jisas kon tamareäu roat pak Jeriko mena potowon. Akas roasiret sosop pak ätäi kiro mena ute nonuk, kar amuk utup ro enip Bartimeas, Timeas nukan mokoi, ko apu kasakup tane rawon. Kos roasiret osapun nik mareäwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ko Nasaret menan ro, Jisas koura äuna, roianik, kos urwäun onoktoreanik, äiewon, “Jisas, Devit nukan mokoi, na isanun wonti moinam, is sareir.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Roasiret sosop akas kerianik, aurin, “Na asor!” Utianik, ko sakau urwewon, “Devit nukan mokoi, na isanun wonti moinam, is sareir!” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Kesernuk, Jisas nukas tai raumara, roasiret awarowon, “Ko aurna, koi.” Ak kiro ro amuk utup urianik, aurin, “Kos na urweisou, okon, na won näu saremoi, na siräi, koi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Keseria, kos kon omjo rumukäu känkureanik, kurte siräianik, Jisas siakup kowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Kesernuk, Jisas nukas auruwon, “Isas na owosisaun airom?” Kesernuk, kiro ro amuk utupus auruwon, “Tamukiäum ro, is ätäi ami urarenuk, apu aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisas nukas ätäi auruwon, “Itok, na man. Nan won epar momon, okon, na ätäi amun urarenuk, apu aparam.” Kiro ses opokar, kon amuk urarenuk, ätäi apu aparianik, ko Jisas tainori potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","2","Jisas ko kon tamareäu roat pak Jerusalem näu mena potaun pote rai, Betfasi pak Betani mena kamuk omtorou enip Olivet opok potomana, Jisas nukas kon tamareäu ro oirori äsimwatomara, awatowon, “Au enro mena aparum opok potoinair. Kar donki nak muris pararar moin rau, mur uräinäir, kiro donki nak imäi kower. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Utianik, kar ros au kiro donki nak owon ourair rai totwatonuk rai, awas ätäi aurwer, ‘Iken Näwäus okoro donki sarau orip äiewon. Sarau patirianik, ätäi kurte äsimornuk, kowai.’ keser aurwer.” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","5","Au poteanik, kar opur donki nak apu kasakup ou rorokpai muris pararar moin, aparirin. Au mur uraresa, karauk roat kiro opok tai rain, akas awatoin, “Au owon mur donki nak pakan uräurair?” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Awas Jisas nukas ämän awatowon siar, keseriar kiro ämän ätäi awaroirin. Roat akas ior äuna, au donki oi koirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Keseria, au donki nak Jisas siakup imäi koianik, awan omjo rumukäu donki nukan mekesu opok puris rue moisa, Jisas nuka oik tone tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Roasiret sosop akas akan karauk omjo apu opok tai potaun puris rue mokurein. Karauk roasiret ak woia apu siakupaian poteanik, kar am ukumai pisau senek patir okukureanik, apu opok puris rue potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Roasiret akas Jisas kamuk mianik, karauk amke potona, karauk ruris tainoria, ak erekapu keser ur we we potoin, “Anut nukan enip jou murau. Kiro ro ko Näwäu nukan enip opokas kou, ik koi kon enip jou murau, ko Anut nukas sareäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Devit, iken askanai, nukan kamwaraun ses pera. Kiro kamwaraun ses päi opok ik rapor rawam. Anut nukan enip karar oik jou mau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Keserna, Jisas nukas Jerusalem mena toneanik, Anut osap nuriäi ou näwäu enip tempel* nukan porim rorokpai tonowon. Ko osap erekapu jekur aparwon. Utianik, kiro ses iukärir, san naurnuk, okon, kon tamareäu roat 12 orip pak ak Jerusalem mena utomoi, ätäi Betani mena potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Jisas ko kon tamareäu roat pak ak tapera senes ätäi Betani mena utomoi, apu opok pote pote rai, Jisas ko sou wewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ko am uran senek enip fik käwäu orip atapukas aparianik, am nemauk rau rai aparaun siakup potowon. Kiro am nemauk muraun ses wa, okon, ko am nemauk aparaun siakup pote, nemauk murau wa aparwon. Am käwäu karar rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Keserianik, Jisas nukas kiro am keser auruwon, “Kar ros nan nemauk ätäi wa oi jai. Na nemauk ätäiar wa muriäwam.” Kon tamareäu roat ak kiro ämän roin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ak Jerusalem mena koianik, Jisas ko Anut osap nuriäi ou näwäu enip tempel owa toneanik, roasiret ak osap kau momana, aiauk amuk we rain opokan Jisas nukas emwaronuk, erekapu imine manoin. Kos roat akan aiauk amuk we oiäin patan pak ainak me rain bokis pak oianik, kour kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Kos roasiret osap kau maun tempel owa oi koiäin tämarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kos roasiret ämän tamareanik, awarowon, “Anut nukan ämän jer we moin kesek rau, ‘Isan ou kiro roasiret omsau atap atap pakan koianik, akas is pak aräun ou äiäiei.’ Anut nukan ämän kesek rau ra, wa? Utianik, akas okoro ou päu roat akan ämäi rawaun omoi senek sare moin.” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Keser awaronuk, karauk Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak ak kiro ämän roianik, ko wena, meiäun apu onoktoroi itanäurin. Roasiret erekapu kon ämän eposek roianik, karkairin, owon, kiro roat näunäu akas Jisas iminein. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Iukärir, om iraurnuk, Jisas kon tamareäu roat pak erek ak Jerusalem näu mena ute potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pote ninoinus, tapera, ak apu opok ari ari poteanik, am uran kinip käwäu pak erekapu meiewon, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Keseria, Pita nukas Jisas nukas kukam kiro onok keserwon ätäi ronkateanik, Jisas auruwon, “Tamukiäum ro, apar! Kukam, na kiro am aru mam aurumon. Rusapai ko meiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisas nukas ätäi auruwon, “Na Anut mesin won epar mo! ");
INSERT INTO bbr2013_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Is ak epar senes awarom, kar ros kiro omtapau aurai, ‘Na siräunam, an unik uru pitikänir nam!’ Keser aurianik, ko wou oirori wa mai, kon wou epar mowon sakau momara, kiro om tapau kon ämän tainorai. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Keserianik, is ak awarom, ak owo onok Anut nukas keseraun rai auraun, akan woiaka epar oripas auraiei. Kos akan ämän tainorianik, ko kiro onok keserai. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ak Anut auraun tai rauna, kar ros ak aru maraun ämän ronkatemoi, akas kiro ron onok aru jäkäi muraiei. Ak keserna, akan momonaka omar oik rau kos nais akan onok aru jäkäi marai.  ");
INSERT INTO bbr2013_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ak kar ron onok aru wa jäkäi muruna rai, akan momonaka omar oik rau kos nais akan onok aru wa jäkäi marai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ko keser awaromoi, ak poteanik, Jerusalem mena ätäi tonoin. Jisas kos Anut osap nuriäi ou näwäu owa ari raunuk, Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak karauk roat näunäu pak Jisas siakup koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ak koianik, Jisas keser totorin, “Na owo sakau oianik, kiro onok keseriäum? Inokos na kiro sakau isowon?” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jisas nukas ätäi awarowon, “Isas nais ak kar ämän totwaraurim. Akas amke isan ämän onoktapau kiro totwaraurim airona, isas pak is owo sakau pakas kiro onok keseriäim onoktapau ak awaram. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Jon, an jomareäwon ro, ko Anut nukas sakau nuruwon ra, ara, roat akas sakau nurin ra? Akas is kiro onoktapau airowe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kesernuk, ak aka aka areanik, äiein, “Ik ko owo rai aurau? Ik ko Anut nukan sakau pakas an jomareäwon äieta, kos aikai, ‘Keseria, ak owon akan woiaka epar mau utoin’. ");
INSERT INTO bbr2013_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Utianik, ik ko ro pakan sakau orip äieta, kiro nais itok wa.” (Roasiret akan ronkat Jon epar Anut nukan ämän roianik, areawon ro kar, okon, kiro roat näunäu ak roasiret akas owo onok ak opok keseraiei rai ronkateanik, iminein.) ");
INSERT INTO bbr2013_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Keserianik, ak ätäi Jisas aurin, “Ik äpu wa.” Keserna, Jisas nukas ätäi awarowon, “Is nais, inokos is sakau ironuk, kiro onok keseriäim ak wa awaram.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisas nukas ak totok ämänis tamareanik, awarowon, “Kar ro ko wain woi mianik, wain uku wemoi, porim wate mowon. Kos woia wain nemauk asisiraun up tuweanik, woi kamäun ou rumukäu kämioik mowon. Woi erekapu jekur raunuk, karauk roat kon woia sarau maun kau mareanik, sarau mona mona, nuka kar omsau atapuk pote rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wain nemauk murunuk, owaun ses penuk, kiro woi atak ros kon sarau ro kar kiro wain woia sarau me rain roat rawa potaun awaronuk, karauk wain nemauk oi nuruna, oi kowaun rai, äsimornuk, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Utianik, kiro woi kame rain roat akas kiro sarau ro sakau ateanik, wemoi, erar äsimorna, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Keserna, ko ätäi kar sarau ro äsimornuk, potonuk, ak ko nais keseriar kon tapau puromoi, aru murianik, erar äsimorna, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Keserna, kos ätäiar kar sarau ro äsimornuk, potowon. Ko nais wena, meiewon. Wain woi atak ros kon sarau roat sosop äsimwaronuk, potona, karauk erar akwaroin, karauk akwarona, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Keserna, ro karar rau ko äsimoraun itok. Kiro kon mokoi senes kon wous konun meiewon. Keseria, kos kon mokoi ruris äsimorianik, ronkatewon, ‘Ak isan mokoin ämän roumoi, wa aru muraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Utianik, kiro woi kameäin roat akas ko kounuk, aparianik, äiein, ‘Kiro woi atak ron mokoi kou. Kon momok meienuk, kos kon momokun osap erekapu owai. Ik ko weta, meienuk, kon wain woi ik owam. Kiro ik keseram.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Keseria, ak kiro mokoi sakau ateanik, wena, meiewon. Keseria, kon enipsau woi kasakup känkurein.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisas nukas roat rain totwarowon, “Akan ronkat woi atak ro nukas kiro sarau roat owoswarai? Ko koumara, kiro woi kameäin roat akwaronuk, meiena, kon wain woi karauk roat akan ipiakap marai. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Kiro Anut nukan ämän jer wein ak ninaräu wa ra? ‘Kiro ou tutu ou miäin roat akas aru äumoi, sauk moin. Rusapai, kiro ou tutu kamuk opokan ou tutu sakau eposek sarewon, Anut nukasar kiro tutu sarau näwäu nuruwon, kiro eposek senes ik aparum,’ jer keser rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jisas nukas keser awaronuk, Juda roat näunäu akas ko kiro opokar sakau ataurin, owon ak äpu ko kiro totok ämän akan onok senek awarowon. Ak roasiret iminewareanik, ak ko sakau atau senek wa. Keseria, ak ko utomoi, manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Juda roat näunäu akas karauk Parisi roat pak Herot nukan ämän tainoriäi roat pak Jisas nuka ämän atonoraun äsimwarona, koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Koianik, akas Jisas aurin, “Näu ro, ik äpu na epar ämän areäum ro. Na kar ron ronkat wa roiäum. Enmak orip roat karar na wa apwareäum. Na Anut nukan onok epar ik ätär mukiäum. Nan ronkat owo senek? Takis aiauk Sisa nurau kiro onok eposek ra, wa? ");
INSERT INTO bbr2013_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ikes kiro takis aiauk nuram ra, utau?” Jisas ko amuk atomoi, ämän moin äpu momara, ätäi awarowon, “Ak owon is ami atorai? Ak takis miäi aiauk karar oi ätär muruna, is aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Akas kiro aiauk karar oi koi nuruna, Jisas nukas awarowon, “Okoro aiauk opok enip totok orip inokon rau?” Akas ätäi aurin, “Sisa nukan.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Keserianik, Jisas nukas ätäi awarowon, “Keseria, ak Sisa nukan osap kiro Sisa nuraiei. Anut nukan osap, kiro Anut nuraiei.” Ak kiro ämän eposek roianik, ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","19","Karauk Juda akan roat näunäu, enmak Sadusi*, akas äiäi, roat meiäi ätäi wa siräiäiei rai äiäi. Kiro omre opokar, karauk Sadusi roat pemana, Jisas keser totorin, “Tamareäum ro, meter Moses nukas ik ninaräun keser jer wewon, ‘Kar ro ko asir orip ko meiemara, kon wau mokoi wäpik meie ute manonuk, kon amakus awakun wäimäs oumara, mokoi mai. Kiro mokoi penuk, kiro ro meiewon nukan mokoi senek saräi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Utianik, kar muti kar ro kon mokoit 7 orip. Mokoi urektapau asik oumara, ko mokoi wäpik meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Keseria, kar amunakas kon wäimäs owon. Ko nais mokoi wäpik meiewon. Kesernuk, kar amunakas kiro asir oianik, keseriar keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Keseriar pote, kiro roat 7 orip kiro asir oin, erekapu mokoi wäpik erar meiein. Keserianik, kiro wäimäs asir rawonus, ruris meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kiro asir roat 7 oripas oin, tawa meiein roasiret siräiäiei omre opok siräuna, kiro inokon asir rawai? Omnokou opok, kiro roat 7 orip meiein akas kiro asir karar oin.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisas nukas ätäi awarowon, “Ak Anut nukan ämän pak kon sakau pak äpu wa. Keseria, ak sätäpu roat senes! ");
INSERT INTO bbr2013_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Roasiret meiein ätäi siräiaiei, kiro ses opok, ak wa ouratäiäi. Ak erekapu Anut nukan sarau eitek omar oik rai senek rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Moses nukas roat meiein, siräiäi mesin jer wewon. Kiro ämän rusapai amop rau. Ak kon ämän kesek ninaräu wa ra? Meter ep arou am eteinak opok jeremara, Anut nukas kon enip keser mowon, Moses auruwon, ‘Is Apraham, Aisak, Jekob akan eit.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Anut ko roat meiein akan eit wa. Ko roat orip orip awau raiäi akan eit. Akan ämän kiro eposek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Kar sintore ämän tamareäu ro Jisas nukas kiro ämän eposek Sadusi roat awarowon roianik, kos koumoi, Jisas totorwon. “Iken sintore ämän erekapu kamuk opok, owo sintore ämän kiro näwäu senes?” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Kesernuk, Jisas nukas ätäi awarowon, “Kiro sintore ämän epar näwäu senes amke rau, ‘O, Israel* roasiret, ak rowe. Anut iken Näwäu, nuka karar ko iken Näwäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Na nan won pak nan totomat pak nan ronkat pak nan sakau pak nan Näwäu, Anut nukanun erekapu meie.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Kar sintore ämän näwäu kiro kon onok kesek, ‘Na nakanun meieäum senek, nan jaunan keseriar meie.’ Kiro sintore ämän oiroror au näwäu. Kar sintore ämänis au itimwatau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Keser äienuk, kiro sintore ämän tamareäu ros Jisas ätäi auruwon, “Näu ro, na äiem kiro epar ämän. Anut nuka karar epar iken Näwäu. Kar eit Anut senek rawau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ik opur wemoi, amkeanik, Anut nuraun kiro onok eposek. Utianik, ik iken woiok pak iken ronkat pak iken sakau pak Anut nukanun meieanik, ikas ikanun meieäum senek, iken jaunokot ika siarokop rai roasir mesin keseriar meiäun, kiro onok oirori au eposek näwäu senes.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas nukas kiro ron ronkat eposek äiewon, roianik, ko auruwon, “Om ses rumukäu wa, na Anut nukan roasiret pak erek rawam.” Kos keser aurnuk, roasiret akas Jisas ätäi kar ämän totoraun iminein. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisas nukas Anut osap nuriäi ou näwäu tempel owa roasiret tamare raumara, totwarowon, “Owon sintore ämän tamareäi roat akas Krais ko Devit nukan mokoi äiäi? ");
INSERT INTO bbr2013_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Devit nukasar Osou Näus ko ronkat nurunuk, äiewon, ‘Anut Näwäu nukas isan Näwäu auruwon, “Na isan ipi näu kaima taneta, isas nan iwäi jaunat erekapu itimwareanik, nan isonap mareita, nan inkaruru rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Devit nukasar “Krais ko isan Näwäu” äiewon, keseria, owoseanik, akas ko kon mokoi äiäi?’” Keser äienuk, roasiret sosop ak kon ämän roi rain akan woiaka näu sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisas nukas ämän tamareanik, awarowon, “Ak sintore ämän tamareäi roat rai opok jekur aparwe. Kiro roat ak omjo eposek mianik, nepipir ariai. Roasiret akas kiro roat amket opok pe apwareanik, ‘pere’ awarianik, ipiak atona, kiro roat akan woiaka näu sareäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Juda roasiret akan tururiäi owa ra, o jaun owa pemoi, ak tanäun omoi eposek oiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kiro roat akas wäimäs asiret sätwareanik, akan owan osap erar oi maneäi. Karauk roat akan amiakap nais ak Anut aurianik, ämän rumukäu miäi. Tawa, Anut nukas koi wasarewaraun ses opok, kiro roat ak usu näwäu senes owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisas ko Anut osap nuriäi ou näwäu owa aiauk bokis siakup tane rawon. Roasiret sosop akas aiauk Anut nuriäi bokis uru moin, aparwon. Roasiret ak aiauk sosop orip akas aiauk näwäu moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Utianik, kar wäimäs asir ko osap sosop wäpik, kos pemara, aiauk eteinak oiroror, 2toia senek, bokis uru mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisas nukas kon tamareäu roat urwarnuk, siakup kouna, awarowon, “Is epar senes awarom, okoro wäimäs asir ko osap sosop wa, kos aiauk näwäu senes mowon. Kos karauk roasiret erekapu itimware rau. ");
INSERT INTO bbr2013_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Okoro roasiret erekapu ak akan aiauk sosop rau, karauk aiauk karar oumoi, Anut nurin. Utianik, okoro asir ko wa senes. Ko kon aiauk erekapu Anut nuru, ko o kau maun kar aiauk rawau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisas ko Anut osap nuriäi ou näwäu enip tempel owa rawonus, ute ne manaurnuk, kon tamareäu ro karas keser auruwon, “Tamukiäum ro, na okoro ou moin apar! Aitapau näunäus ou eposek eposek moin rau jekur apar.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisas nukas ätäi auruwon, “Kiro itok, utianik, na okoro ou erekapu aparum tawa iwäi jaunakat akas koianik, kiro ou erekapu aru maiei. Kiro ou moin aiauk erekapu uräi naiei. Kar aiauk kon omoi wa rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","4","Keserianik, Jisas ko Olivet omtapau opok tone tanemoi, Anut osap nuriäi ou näwäu aisas apari raunuk raunuk, Pita, Jems, Jon, Andru, ak karar Jisas pak raumoi, keser totorin, “Kiro onok esepa päi? Owo onok amke penuk, ik kiro omre äpu mam?” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jisas nukas awarowon, “Ak sakau tai rawe. Karauk roat akas peanik, ak sät ämän awaraiei. Ak akan ämän wa rowau. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tawa roat sosop akas koianik, isan enim atomoi, keser äiäiei, ‘Isakasar is Krais, ak ätäi imwaraun ro pem.’ Roasiret sosop akas kesek ämän roianik, epar äiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ak marai kowai ämän pak marai jejep pak siarakap kounuk, roumoi, ak wa karkairau. Kiro onok epar amke päi. Utianik, wasarewaraun ses kiro kurte wa pekeräi. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kar omsau pakan roasiret akas siräianik, kar omsau pakan roasiret pak iwäi muratäianik, weräiäiei. Karauk omsau opok mim näwäu päi. Karauk omsau opok roasiret sou om rumukäu rawaiei. Kiro onok erekapu päi kiro onok kesek, kar asir ko mokoi owaun amke tätäi näwäu oiäu senek. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Kiro ses opok, ak sakau tai rawe. Karauk roat akas ak sakatwareanik, akan roat näunäu akan amiakap imware poteanik, Juda akan tururiäi owa ak mänkäsiwaraiei. Ak, isan tamareäimin roat, okon, akas omnokou pakan omsau kameäi roat näunäu amiakap isan ämän awaraun sakau tai rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Roasiret akas Anut nukan Ämän Eposek omsau erekapu roasiret awarona, roasiret ak kiro ämän äpu moi rauna rauna, epar kiro wasarewaraun ses kowai. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Roat ak sakatwarona, akas roat näunäu amiakap ämän mareanik, owo ämän aräm rai ronkat sosop wa owau. Kiro ses opokar Anut nukas ämän awaraun arai. Anut nukan Osou Näus akan oiaksau pakas äiäi. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Karauk roat ak akan aunakat, amunakat, akas akan iwäi jaunakat akan ipiaka opok marona, akwarona, meiäun rai maraiei. Karauk momonakat akas akan mokoit keseriar kesewaraiei. Mokoit akas nais akan momonakat aninakat sumkäinewareanik, akan iwäi jaunakat akan ipiakap marona, akwarona, meiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ak, isan tamareäimin roat, okon, roasiret erekapu ak mesin kasiaka peanik, sauk maraiei. Utianik, inok ro ko isan sarau wa utai ko orip orip sakau me rawai, tawa wasarewaraun ses opok, Anut nukas ko ätäi imäiai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisas nukas ätäi awarowon, “Ak kar osap aru senes kiro meter Anut nukan ämän roianik, areäwon ro Daniel nukas arewon päi aparaiei. Kiro osap aru senes peanik, Anut nukan omoi näu eposek opok pe tai rawai. (Ak kiro ämän ninarein raroi, jekur ronkatäiei.) Kiro ses opok, roasiret ak Judia provins opok rai ak omtorou opok imine tonaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Kar ro ko ou oik rawai, ko neanik, kon osap owa rau wa tone owai. Ko kurte erar imine manai. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kar ro woia sarau me rawai, ko kon mer eposek owa rau koi wa owai. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kiro ses opok, asiret amaiwo orip pak asiret mokoi apur jerai pak, ak wopuräiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ak Anut auraiei, ‘Om nai ses, kiro onok aru wa päi.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ak meter kiro usu näwäu wa oiäin. Anut nukas omnokou ate mowon ses opokas koi rusapai rau kesek usu kar wa pewon, tawa nais kesek usu ätäi wa päi. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Utianik, Näwäu nukas omre rumukäu kurte katu sarewon, owon, ko kiro onok keserau wa maro, roasiret sosop wa rawoi. Ko karauk roasiret imwaraun sarware mowon, okon, kiro onok kurte keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kiro ses opok, kar ros pemara, keser awarai, ‘Krais okoro pe rau!’ ra, ‘Ko enro rau!’ rai, awaronuk, ak kon ämän roianik, woiaka epar wa mau. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Karauk roat akas pemana, sätäianik, keser äiäiei, ‘Is Krais.’ Karauk roat akas äiäiei, ‘Is Anut nukan ämän roianik, areäim ro.’ Keseria, ak kurur näunäu pak karauk sarau atap atap maiei. Ak karauk roasiret Anut nukas nukan sare marowon, sätwaraurmana, akan amiakap kiro onok keseraiei. Sätwarona, ak Anut nukan roasiret akan onok tainorianik, ak Anut nukan onok utaun rai keseraiei. Utianik, akas kiro onok kesewaraun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Keserianik, ak sakau tai rawe. Owo onok tawa päun is erekapu ak awaromin.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","25","Jisas nukas ätäiar äiewon, “Kiro usu näwäu senes erekapu pe manonuk, ‘san ko pututu senek saräi, keir ko merek wa kuräi, pai omar opokas räkäi kowaiei. Keserna, omar oikan osap sakau rain erekapu ritratorai.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Kiro onok kesernuk rai, roasiret akas Ro Nukan Mokoi omar oik iou pakas sakau näwäu orip arou pakas kounuk, aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Keseria, kos Anut nukan sarau eitek äsimwaronuk, omsau erekapu pak omar oik pak erekapu potomana, Anut nukas kon roasiret sare marowon, imware koi turware maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisas nukas ätäi awarowon, “Ak am suwaro nukan onok jekur ronkatewe. Am suwaro nukas ak san tawaun onok ätär marai. Keseria, suwaro erekapu käianik, am käwäu awau ätäi tu penuk rai, ak kiro äpu maiei, kiro san näwäu päun ses. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kiro senek, tawa kiro onok atap atap penuk, ak äpu maiei, Ro Nukan Mokoi ätäi kowaun ses katu sare rau. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Is epar senes awarom, okoro roasiret rusapai rai ak wa meiäiei opok kiro onok keser päi ak aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Omar omnokou pak rau kiro erekapu wasaräieir. Utianik, isan ämän wa wasaräi, orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jisas nukas ätäiar äiewon, “Kar ros Ro Nukan Mokoi kowaun omre wa äpu mai. Anut nukan sarau eitek nais ak äpu wa. Kon mokoi nais ko äpu wa. Momok karar ko äpu. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Kesek onok, okon, ak jekuriar tai rawe. Kiro omre esapa kowai ak äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Kiro kesek, kar ro ko kon ou utia, kar mena atapuk manauriäu. Kos kon ou ute manaurianik, kon sarau roat kon ou kamäun raiäi. Akan sarau atap atap mianik, ou rorokup kameäu ro sakau auriäu, ‘Jekur kame rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kesek onok, okon, ak jekur kamäiei. Ak äpu wa, ou atak ro esapa ätäi kowai. Ko iukärir kowai ra, pututu kowai ra, kakarau äienuk, kowai ra, om teinenuk kowai ra? Ak äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ak wa jekur kame rauna rai, ko kurte koianik, ak nini rauna, koi tarwarai. ");
INSERT INTO bbr2013_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Okon, is ak okoro ämän awarom. Kiro epar, is roasiret erekapu okoro ämän awarom. Ak jekuriar kame rawe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Omre oirori utonuk, okoro tup roasiret bret jis wäpik jeäi, enip Pasowa* penuk, Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak akas Jisas sakau ateanik, wena, meiäun ämän ämäi ämäi atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Utianik, ak äiein, “Ik ko kiro sumaun omre opok wa wäu, roasiret akas siräianik, ik pak näwäu weräiäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Betani mena, kar ro enip Saimon, meter ko sip repros orip raiäwon, Jisas nukas kon owa tone raumara, o jaun patan siakup tane rawon. O jenuk jenuk, kar asires botol eposek uer sou eposek enip nar orip oi pewon. Kiro asir ko meter aiauk näwäus kiro uer sou eposek kau mowon. Kos kiro botol kakareanik, uer sou eposek orip Jisas nukan tapau opok kourwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Karauk roat rain ak kiro onok aparianik, akan woiaka aru momana, aka aka äiein, “Owon kiro asires uer sou eposek orip erar sakaru? ");
INSERT INTO bbr2013_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ik kiro uer roat arota, kau mona, kiro pakan aiauk näwäu, woisan karar pakan aiauk senek, oianik, saruku roasiret araun itok.” Keseria, ak kiro asir sakau keirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisas nukas akan ronkat äpu mianik, awarowon, “Ak kiro asir utona, rawai. Ak owon ko wousarianik, usu nuri? Ko kiro onok eposek senes is opok keseru. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Saruku roasiret ak pak orip orip rauna, akas orip orip ak sarwaraun itok. Utianik, is ak pak orip orip ekep wa rawam. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kos owo onok keseraun keserwon. Ko uer sou eposek orip isan enimsau opok kourwon, kiro is meieita, up uru naun enimsau wäräu jekuri mou. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Is ak epar senes awarom, roat akas okoro Anut nukan Ämän Eposek omnokou erekapu roasiret aware arianik, kiro onok okoro asires keserwon kiro nais awaraiei. Keseria, roasiret ak konun ronkatäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Keseria, Jisas nukan tamareäu roat 12 orip pakan kar ro, kon enip Judas Iskariot, ko Anut kamuk raiäi roat näunäu siarakap Jisas akan ipiakap maun potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ak kiro ämän roianik, nepipirmoi, aiauk nuraun paip moin. Keserna, Judas ko Jisas akan ipiakap maun apu itane rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bret jis wäpik amke jeäin omre karar amke pewon. Kiro omre opok Juda roasiret ak akan Pasowa sipsip nak wemoi, amkeanik, jeäin. Keseria, Jisas nukan tamareäu roat akas Jisas aurin, “Ik nan Pasowa omre opok o jaun omoi erapok pote jekur musau?” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Keser aurna, kos kon tamareäu roat oiror äsimwatomara, awatowon, “Au kiro mena potaieir opok, kar ro ko an oremara, pea, au tarwatai. Awas ko tainori potower. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ko owa tononuk, au kiro owan ou atak ro aurwer, ‘Iken tamukiäu ro äiewon, “Is isan tamareäim roat pak Pasowa o jaun ou waru erapok rau?” keser äiewon.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ko kar ou waru näwäu osap jekur mowon kamiauk oik rau ätär matai. Au kiro opok iken o jaun omoi jekur mower.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Au poteanik, näu mena tonomoi, Jisas nukas awatowon siar aparianik, kiro owa Pasowa o jaun omoi jekur moirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Iukärir sarenuk, Jisas nukas kon tamareäu roat 12 orip pak koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ak taneanik, o je je rai, kos keser awarowon, “Is ak epar senes awarom, kar ro ak kamuk rau kos isan iwäi jaiat akan ipiakap murai. Kiro ro ko rurisa is pak o je rau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ko keser äienuk, ak akan woiaka usu sarein. Ak karar karar akas ko keser totorin, “Na is mesin äiem ra? Is wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisas nukas ätäi awarowon, “Kiro ro ko isan roat 12 orip pak raiäu. Ko is ori erek maro karar opok kon bret ur opok mianik, oura. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Anut nukan ämänis äiewon siar, Ro Nukan Mokoi meiäi, utianik, kiro ros kon iwäi jaukut akan ipiakap marowon, kiro ro ko wopur. Kiro ro ko anakus an jowon ses opok meiewon maro, kiro usu eteinak. Keserau wa, okon, tawa omar oik ko usu näwäu senes owai.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ak o je je rauna, Jisas nukas bret oumoi, Anut aurmara, ipous pärärianik, kon tamareäu roat aromara, äiewon, “Ak oinai, jeie. Okoro isan enimsau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Keseria, ko ätäi kap wain an orip oumoi, Anut aurmara, kon tamarowon roat aronuk, ak erekapu okoro kap pakan an jein. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kos awarowon, “Okoro isan karian, Anut nukas kiro karianas ak pak paip awau mou. Isan karian kiro kournuk, roasiret sosop sarwarai. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Is ak epar senes awarom, is ätäi okoro wain nemauk pakan an wa jam, pote is kar wain an awau kiro isan Monian kamwaraun mena ätäi jam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kesermana, ak kar sir wemoi, kasik neanik, Olivet omtapau opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jisas nukas kon tamareäu roat keser awarowon, “Ak is utoirea, imine manaiei. Anut nukan ämän kesek jer we moin rau, äieu, ‘Kiro sipsip kumeäu ro isas weita, sipsip raut ak imine atap atap manoutaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Utianik, is meieanik, ätäi siräianik, amke Galili provins opok potoita, ak tainoire potaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita nukas auruwon, “Ak erekapu na utoisi manona rai, is karar na wa utoisam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jisas nukas ätäi keser auruwon, “Is na epar senes aisom, rusapai pututu kakarau ur oirori wäu wa opok, na isan enim ämäi momata, is ‘ko äpu wa’ rai 3 orip äiäm” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Utianik, Pita nukas sakau auruwon, “Epar senes, is kesek ämän wa äiäm. Is na pak erek meiäm.” Jisas nukan tamareäu roat akas nais keseriar äiein. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisas kon tamareäu roat pak kar om enip Getsemani poteanik, kos awarowon, “Ak okoro opok tane rauna, is Anut auraurim.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","34","Kos Pita, Jems, Jon pak imware maneanik, kon wou aru monuk, ko nukasar nukanun wouti momara, keser awarowon, “Isan woi usuäu senes monuk, waiauk patirnuk, meiäurim. Ak okoro opok awau tai rawe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ko keresir maneanik, omnokou opok wou kumäse ninomara, Anut nukas kiro usu ko opok wa päun rai Anut auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kos auruwon, “O Moni, na owo sarau keseraun itok. Nas is opiapan usu oi kuräm. Utianik, na isan ronkat wa tainorau, na nakan ronkat karar tainor.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Keser aurianik, ko kon tamareäu roat nini rain opok pe apwareanik, rurawarowon. Keseria, ko Pita auruwon, “Saimon, na nini raum ra? Na is kamoireanik, is pak ekep tai rawau senek wa ra? ");
INSERT INTO bbr2013_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ak wa ninau, awau tai raianik, Anut aurwe. Keseraiei, Satan nukas wa ate apwarai. Is äpu ak onok eposek keseraun ronkateäi, utianik, akan enmaksau sakau rawau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Keseria, ko poteanik, ätäi Anut kiro ämän meter auruwon siar keseriar auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ko ätäi koianik, kon roat ätäi nini rain, apwarwon. Ak amos atomaronuk, awau tai rawau senek wa. Akas ko owo ämän auraun äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Jisas nuka ätäi Anut auraun utware manowon. Kos ätäiar koianik, rurawarianik, awarowon, “Ak ninianik, sume rai ra? Kiro itok, äiäk! Aparwe! Ro Nukan Mokoi sakateanik, roat onok aru miäi akan ipiaka opok maun ses kou. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Enro ros is isan iwäi jaiat ipiaka opok muraun ki kou. Ak sirauwe! Ik pote ko tararau manau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisas nukas kon tamareäu roat kiro ämän awaronuk awaronuk, kon tamareäu roat 12 orip pakan kar kon enip Judas, ko siakup kowon. Juda roat näunäu pak, Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat akas roat sosop Jisas sakau ataun äsimwarona, Judas tainori potoin. Ak weräiäin siräp pak utupauk pak ate koin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas nukas meter kiro roat keser awarowon, “Is kiro ro pote oktokorita, ak äpu maiei kiro ro karar ak sakau atoinai, ko marai roat akan ipiakap mona, imäi manaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Keseria, Judas ko kurte Jisas siakup potomara, keser auruwon, “Pere, tamukiäum ro!” aurianik, oktokorowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Roat ak ko äpu mianik, Jisas sakau atoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kar ro ak kamuk tai rawonus, kos kon siräp rumukäu oumara, Anut kamuk raiäu ro näwäu nukan sarau ro wem raiar kon rauk käu patir kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Kesernuk, Jisas nukas roat awarowon, “Ak weräiäun utupauk pak siräp pak oianik, is päu ro senek sakatoirianik, iworaun koi ra? ");
INSERT INTO bbr2013_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Is omre orip orip Anut osap nuriäi ou näwäu owa roasiret tamareäimin, ak kiro opok sakatoirau utiäin. Utianik, ak kiro onok keserna, Anut nukan ämän areai roat akas kon ämän jer we moin kiro epar pewon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Keserna, kiro ses opokar, kon tamareäwon roat erekapu imine manoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Kar mokoi awau niniäwon omjo karar takewon, Jisas tainori potowon. Roat akas ko sakataurna, ko kon niniäwon omjo akan ipiaka opok utomara, pirim imine manowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Kiro kameäin roat ak Jisas sakau atoin, akas Anut kamuk raiäu ro näwäu senes nukan owa imäi potoin. Kiro opok Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak Juda roat näunäu pak erek turur rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita ko ämäi ämäi potonar, keres keres potowon. Keserna, Pita owa toneanik, kiro opok ou kameäi roat pak taneanik, ep uke rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Anut kamuk raiäi roat näunäu pak karauk Juda roat näunäu pak akas karauk ämän Jisas opokup momana, owose wena, meiäun rai keserin, utianik, ak kar kesek ämän itanäu senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Roat sosop peanik, sät ämän ko opokup moin, utianik, karar ämän ak mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Keserna, karauk roat pe tai raianik, kiro sät ämän moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ik Jisas nukas kiro ämän äiewon, roumun. Kos keser äiewon, ‘Is kiro Anut osap nuriäi ou näwäu roat akas ipiakas moin, uräianik, omre 3 orip utia, is kar ou awau mam. Roat akas kiro ou wa maiei.’ Ko keser ämän äiewon, ik roumun.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Utianik, akan ämän kiro erekapu itok wa, ak ämän sepuk sepuk moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Keserna, Anut kamuk raiäu ro näwäu senes akan amiakap tai raumara, Jisas totorwon, “Na owon kiro roat ämän aisoin ätäi awarau utom? Na owosemon, okon, na enmatap ämän miäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Utianik, Jisas ko asor raianik, ämän aräu wa. Anut kamuk raiäwon ro näwäu senes nukas ätäiar totorwon, “Na Krais, kiro ro Anut nukas roasiret ätäi imwaraun äsimornuk, kowon ra? Na iken Näwäu nukan Mokoi ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisas nukas ätäi auruwon, “Okoro is karar. Is ak epar senes awarom, Ro Nukan Mokoi ko Anut sakau näwäu orip, nukan ipou näu kaima taneanik, omar oik iou pakas kowai, ak aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Anut kamuk raiäu ro näwäu senes kiro ämän roumara, nukan omjo kiräianik, roat rain totwarowon, “Ik owon karauk roat awarota, koi kon enip opok karauk ämän maiei? ");
INSERT INTO bbr2013_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ko Anut jeje ämän auruwon, ak roin. Akan ronkat owosäiei?” Akas ätäi äiein, “Ko ämän orip, okon, wena, meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Kesermana, ak Jisas opokup sinok urarianik, kon amuk omjos pararar momoi, ipiakas weanik, aurin, “Na ämän roianik, areäum ro rai, na ik aik, kiro inos na iwosou?” Keserna, Jisas kameäin roat akas ko imäianik, wein. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ko ou kasakupai tane raunuk, Anut kamuk raiäu ro näwäu senes nukan sarau asir kar pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Kos Pita ep uke rawon aparianik, sakamarmoi, auruwon. “Na Nasaret menan ro, Jisas pak raiäumon.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Utianik, Pita nukas ätäi auruwon, “Na kiro ämän äiem kiro kon onoktapau is äpu wa.” Keser äianik, ko ou rorokupai siakup potonuk, kar kakarau urwewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kiro sarau asir ko ororokpai tai rawon aparianik, kos roasiret siakup tai rain, awarowon, “Kiro ro ko kar Jisas nukan tamuriäu ro.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pita nukas ätäi awarowon, “Is kon tamuriäu ro wa.” Rai rai, karauk roat Pita siakup tai rain, akas aurin, “Na epar ko pak ariäum, owon, na nais Galili provins pakan ro.” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Utianik, Pita nukas ipou kämioik momara, ätäiar äiewon, “Epar senes is ak awarom! Is sät ämän mam kar usu is opok päi. Is kiro ro äpu wa!” ");
INSERT INTO bbr2013_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ko keser äienuk äienukar, kakarau ätäi ur wewon. Pita ko Jisas nukas meter ämän auruwon ätäi ronkatewon. “Kakarau ur oirori wäu wa opok, na isan enim ämäi momata, ‘is ko äpu wa,’ rai 3 orip äiäm”. Keseria, Pita ko näwäu waiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Om teinenuk, tapera, Anut kamuk raiäi roat näunäu, Juda roat näunäu, sintore ämän tamareäi roat, kaunser roat erekapu pak akas Jisas wena, meiäun ämän atoin. Ak Jisas muris ipou parar mianik, Pailot nukan ipoukup maun imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Keserna, Pailot nukas Jisas totorwon “Na Juda roasiret akan kamwaraun ro näwäu king ra?” Jisas nukas ätäi auruwon “Kiro nakas äiem senek.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Anut kamuk raiäi roat näunäu akas kon enip opok sät ämän sosop moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Keserna, Pailot nukas ätäiar totorwon, “Na ätäi ämän mau owon utom? Na kiro ämän nan enmatap moi, na rowau wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Utianik, Jisas nukas kar ämän ätäi aurau wa. Kesernuk, Pailot ko ronkat sosop owon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Akan sumaun omre enip Pasowa* opok, Rom akan kamwareäu ro näwäu nukas woisan karar karar kiro omre opok kar ro karapus owa raiäu utonuk, maneäu. Roasiret akasar koi tururianik, kar ro utona, manaun aurna, ko kiro ro utonuk, maneäu. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kiro ses opok, kar ro kon enip Bar-Abas ko karapus owa rawon. Meter kiro mena roat akan kamwareäwon ro näwäu pak weräianik, Bar-Abas nukas kar ro wenuk, meiewon. Keseria, ko karapus owa kurein rawon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Roasiret sosop akas peanik, Pailot keser totorin “Nas Pasowa sumaun ses orip orip kar karapus ro utota, maniäu. Rusapai nas kiro onok keseriar keseram.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Keser aurna, Pailot nukas ätäi awarowon, “Akan ronkatis, is Juda akan kamwareäu ro näwäu utoita, ak pak potai ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailot ko äpu Anut kamuk raiäi roat näunäu ak Jisas nukan onok eposek mesin kasiaka penuk, okon, ak ko siakup imäi koin. Keseria, kos kiro ämän totwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Utianik, Anut kamuk raiäi roat näunäu akas roasiret raiaka atomoi, awaroin, “Pailot aurwe, ‘Bar-Abas utota, manai.’ keser aurwe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Keserna, Pailot nukas ätäiar totwarowon, “Okoro ro ko Juda akan kamwareäu ro näwäu äiäi, is owosäm?” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Akas sakau urwein “Ko am äpäs opok äsäi mo.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailot nukas awarowon, “Owon? Ko owo onok aru keserwon?” Akas näwäu senes urwein, “Ko am äpäs opok äsäi mo!” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Roasiret akan woiaka näu saräun Pailot nukas Bar-Abas utonuk, manowon. Kesermara, kos Jisas marai roat akan ipiakap monuk, akas ko mänkäsirianik, karauk marai roat arona, akas pak ko am äpäs opok äsäi maun imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Marai roat akas Jisas Pailot nukan owa, enip Pretoriam, imäi poteanik, karauk marai roat owa rain erek urwarna, ak koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Keseria, marai roat akas kar omjo osou ses kure murianik, kar rumäkät katuau orip oumoi, tatmaianik, kon tapau opok kuror moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Akas sakau aurin, “Na Juda akan kamwareäum ro näwäu king, ik nan enmat jou mom.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ak amaukus kon tapau ätäi ätäi purianik, sinok amuk uru kurein. Ak ko siakup uoraka sur weanik, ro näwäu senek kon enip kämioik moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ak keser jeje ämän aurianik, ätäi omjo osou ko opokupan jäkäi oumoi, kon omjo ätäi orke murin. Keseria, ak ko am äpäs opok äsäi maun imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Rom akan marai roat akas Jisas am äpäs opok we maun apu opok imäi potona potona, kar ro ko Sairini menas, Aleksanda Rufus orien momonawa, näu mena tonaun kowon. Kon enip Saimon. Ak ko apu opok tararianik, sakau ateanik, Jisas nukan am äpäs oianik, Saimon ämäi muruna, ko Jisas tainori potowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ak Jisas kar om enip Golgota imäi potoin. Kiro om enip onoktapau kesek ‘op tapau sekerem’. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Keseria, akas wain an kar marasin tiu enip mair orip, momoi, keputirianik, Jisas jaura rai nuraurin. Utianik, Jisas ko jau utowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Keserianik, akas Jisas am äpäs opok äsäi moin. Kon omjo osap orip ak atpane owaun rai aiauk oianik, satu sipiräiein. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","San penuk, 9 klok senek, ak ko am äpäs opok äsäi moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Kiro ämän roasiret akas meter kon enip opok ämän moin, kon tapau opok keser jer we moin, ‘Juda akan kamwareäu ro näwäu, king.’ ");
INSERT INTO bbr2013_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Akas roat oiroror au onok aru moirin imwateanik, kar ro Jisas nukan ipou näu kaima äsäi moin, kar ipou saunan kaima äsäi moin. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Keserna, Anut nukan ämän meter jer wein siar, “Akas ko roat aru pak erek turur moin.” Kiro ämän epar pewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Roasiret akas apu pakas pe mane rai, ko aparianik, tapiaka känkänirmoi, jeje ämän aurianik, äiein, “A! Nas keser äiemon, na Anut osap nuriäi ou näwäu uräianik, omre 3 orip ätäi ou awau mam. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Keserianik, nakasar ätäi nakan enmatsau sareanik, am äpäs opokan ute ne.!” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak akas nais keseriar jeje ämän keser äiein, “Ko karauk roasiret sarwareäwon, nukasar ätäi nukan enipsau saräu senek wa! ");
INSERT INTO bbr2013_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ko Krais, Juda akan kamwareäu ro näwäu king maro, ko am äpäs opokas ute nonuk rai, ik kiro aparianik, iken woiok konun epar mam.” Kiro päu roat ories nais ko keseriar jeje ämän auririn. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sankeu, san kamuk, san jeräu wa, om erekapu pututu senek sare pote 3 klok iukärir. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Keser raunuk raunuk, 3 klok siakup, Jisas nukas keser urwewon, “Eloi, Eloi, lama sabaktani.” Kiro ämän onoktapau kesek ‘Isan Anut, isan Anut, na owon is utoirom?’ ");
INSERT INTO bbr2013_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Kesernuk, karauk roasiret kiro opok tai rain, akas kiro ur roianik, äiein “Rowe! Kiro ro ko Elaija urura.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Keseria, kar ros kurte potea, kar osap jaimirmir senek oianik, wain an tiu mia, aitauk opok momoi, Jisas jaun rai nurauromara, roasiret awarowon, “Ik kame rauta, Elaija nukas koi, ko am äpäs opokan imäi mai ra, apari rawau.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Kiro ses opokar, Jisas nukas sakau urwemara, kon osou nukasar utonuk, ko meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Keseria, omjo Anut osap nuriäi ou näwäu owa äsäi moin rawon, oikas kiräi nopte, oirori sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Marai kamwareäu ro näwäu ko Jisas siakup erekur tai raianik, kon ur wewon roumoi, ko meiewon onok aparianik, kos äiewon, “Epar senes, kiro ro ko Anut nukan Mokoi!” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Karauk asiret akas atapukas tai raianik, apari rain. Kiro asiret kamuk, kar asir kon enip Maria ko Magdala menan, kar asir kon enip Maria ko Jems (ko eteinak äiein) Josep orien aninawa, pak kar asir kon enip Salome pak, rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kiro asiret meter Jisas Galili provins raunuk, ko isanaraun tainori poteäin. Karauk asiret sosop ak Jisas pak erek Jerusalem menas koin, ak nais erek rain. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Kiro Fraide, osap jekuraun ses. Tup etei kiro Juda akan sumaun omre. Keseria, iukärir sarenuk, kar ro kon enip Josep ko Arimatea menan, ko Juda kamwareäin roat näunäu akan sarau jaunaka, kos Anut okoro omnokou kamäun ätäi kowai rai kame raiäwon. Ko Pailot iminäu wa, siakup potomara, Jisas nukan kopeu oumoi, up uru kuräun totorwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailot nukas Jisas kurte meiewon ämän roianik, ko karkairwon. Ko karauk roat äsimwaronuk, marai kamwareäu ro näwäu koi aurna, ko kounuk, Pailot nukas totorwon, “Jisas meiewon ra?” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Kiro marai ros ior aurnuk, Pailot nukas Josep auruwon, “Itok, nas op kopeu oi manam.” ");
INSERT INTO bbr2013_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Keseria, Josep nukas karauk omjo ärneu kau mianik, Jisas nukan kopeu am äpäs opokan oumoi, omjos kurur momara, aireu uru mowon. Keseria, aitapau näwäu oumara, aireu oksau pene mowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria ko Magdala menan, Maria ko Josep nukan anak ori au Aramatia menan Josep nukas Jisas kiro aireu uru mowon aparirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sumaun ses manonuk, Maria ko Magdala menan, kar Maria ko Jems nukan anak, Salome pak ak am anakas sou eposek orik kau mianik, oi koumana, Jisas nukan enipsau opok joutor muraurin. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","3","Tup Näwäu opok, taperar senes, ak kiro aireu aparaun apu opok pote räi, aka aka arein, “Inokos kiro aiauk näwäus up oksau pene moin oi erororai?” ");
INSERT INTO bbr2013_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Utianik, ak jekur aparianik, kiro aiauk näwäu senes oi kurein aparin. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Keseria, ak kiro aireu uru toneanik, mokoi awau omjo ärneu orip aireu uru ipou näu kaima tane rau aparianik, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Kos awarowon, “Ak wa iminäu. Ak Jisas Nasaret menan, am äpäs opok äsäi moin, itanäun koin. Ko ätäi siräiewon! Ko okoro opok rawau wa. Kiro omoi ko nini moin ak aparwe. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Utianik, ak potoinai, kon tamariäwon roat pak Pita pak awarowe, ‘Jisas ko amke Galili provins opok potonuk, ak tainori potaiei. Ak ko meter awarowon siar kiro opok aparaiei,’ ak keser awarowe.” ");
INSERT INTO bbr2013_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ko keser awaronuk, kiro asiret ak karkairianik, ronkat sosop oumoi, kiro aireu utomana, imine manoin. Ak näwäu imineanik, kar ro ämän aurau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tup Näu opok, taperar, Jisas nukas ätäi siräianik, ko amke Maria ko Magdala menan, meter kiro asir pakan osou aru 7 orip emwarowon siakup potonuk, kos ko aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Keseria, Maria poteanik, kiro roat meter Jisas pak raiäin, woiaka aru monuk, wai rain awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Maria nukas keser awarowon, “Jisas awau raunuk, is ko aparmin.” Ak kon ämän roianik, akan woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kar omre opok, Jisas nukan tamariäwon roat ori oiroror au näu mena utomoi, manaun ari ari manoirin. Au akan apu opok Jisas aparirin. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Awas ätäi poteanik, karauk tamariäwon roat awaroirin, “Iu Jisas apu opok aparmurin!” Utianik, ak awan ämän roianik, akan woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kar omre opok, kon tamariäwon roat 11 orip o jena jena, Jisas nukas ak siarakap penuk, akas ko aparin. Kos kewareanik, awarowon, “Ak owon akan woiaka epar mau wa, ak woiaka sakau moin? Is ätäi siräimin, roat ak is apairoin akas akan ämän roianik, ak owon woiaka epar mau wa? Kiro onok eposek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Keserianik, kos ak awarowon, “Ak omsau sau erekapu potoinai, isan Ämän Eposek roasiret erekapu tamarowe. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Inok roasir kiro ämän roianik, kon wou epar monuk, ak ko an jomurna, ko Anut nukas ätäi imäiai. Inok roasir kon wou epar mau wa, ko kiro ro utai, ko ämän orip. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Roasiret akan woiaka epar mianik, ak kiro onok keseraun itok. Akas isan enim ateanik, osou aru emwaraiei. Akas kar omsau pakan ämän meter äpu wa rain araiei. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Akas män aru ipiakas atwarona, kiro mänis ak wa aru maraiei. Akas an aru jaun meiäun senek jeanik, ak wa meiäiei. Akas akan ipiaka sip roasiret opok marona, kiro roasiret amiaka muraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jisas Näwäu ko kiro ämän aware kurenuk, Anut nukas imäienuk, omar oik tonowon. Ko Anut nukan ipou näu kaima tane rau. ");
INSERT INTO bbr2013_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Kesernuk, kon tamariäwon roat ak omsau sau erekapu poteanik, Jisas nukan ämän roasiret awaroin. Näwäu nuka ko ak pak sarau erek monuk, akas kiro onok meter awarowon siar keserna, karauk roat kiro onok aparianik, kon ämän meter äiewon epar ak äpu moin.");
INSERT INTO bbr2013_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiofilus, na Anut nukan wonas meieäum ro. Meten roat näunäu akas meter Jisas nukas onok ätär mukowon. Kiro jer wein. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Meter karauk roat akas kiro onok aparianik, äiein jer wein. Keseria, is nais erek kiro ämän roianik, na jer we musom. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Is Luk, meter is kesekur kiro ämän onok rowaun totwaraun arimin, is erekapu roumoi, jer we musom. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Keseria, na äpu mo, kiro ämän na ätär musom kiro epar senes. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Kiro ses opok Herot ko Juda omsau kameäwon ro näwäu, kiro opok kar ro ko Anut kamuk raiäwon ro* kon enip Sekaraia, kon waun enip Elisabet, ko nais Anut kamuk raiäin roat akan kinjaunaka. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Kiro ro kon wau ori au Anut nukan amuk opok eposek raianik, kon ämän erekapu tainoriäir au onok aru wäpik. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Utianik, au mokoi wäpik, owon, Elisabet ko mokoi wa miäwon. Keseria, Elisabet Sekaraia ori au koiam senes sareirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Kar omre opok Sekaraia kon sarau maun ses penuk, ko Anut jou muraun tup owa tone Anut nukan amuk opok sarau me rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Anut kamuk raiäin roat akan onok kesek, ak aiauk sipiräieanik, Sekaraia nukas Anut osap nuriäi ou näwäu* owa sarau mau tonowon. Keseria, osap sou eposek orip makaun ko nurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kiro ses opok, Sekaraia ko Anut nukan osap sou eposek makaun opok, roasiret sosop ak kasik tai raianik, ak Anut auri rain. Ko Anut nukan owa jou muraun tononuk, ");
INSERT INTO bbr2013_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Anut nukan sarau eitek* ko siakup pemara, ipou näu kaima epit sou eposek pe rawon opokas pe tai rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sekaraia ko Anut nukan sarau eitek aparianik, karkairmara, iminewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Anut nukan sarau eitekus auruwon, “Na wa iminäu. Anut nan ämän aurumon rowon. Okon, nan wat Elisabet ko kar mokoi owai. Na kon enip Jon mam. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kiro mokoi penuk, naka pak karauk roat asiret näunäu sosop ak woiaka ereraiei. Akan woiaka näu saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ko Anut nukan amuk opok ro näwäu rawai. Ko an wain pak, an sakau pak wa jai. Ko anak wou uru raunuk, Anut nukan Osou Näu kiro mokoi pak orip orip rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kos Israel* roasiret sosop akan woiaka piririanik, ätäi akan Anut Näwäu siakup imware potai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ko Näwäu amukup amke potai. Ko ro sakau orip Elaija senek rawai. Kos mokoit pak akan momonakat pak ätäi erek turur marai. Kos roasiret akan ronkat aru miäi ätäi ronkat eposek pirir marai. Kos Näwäu nukan roasiret jekur marai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraia nukas Anut nukan sarau eitek ätäi auruwon, “Kiro onok epar penuk, is owose äpu mau? Is koiam senes saremin, isan asir nais emas senes sarewon, kiro onok owose päi?” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Anut nukan sarau eitekus auruwon, “Is Gabriel. Is Anut nukan amuk opok tai raiäim. Is Anut nukasar äsimoirnuk, kiro ämän eposek aisau koimin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Utianik, na isan ämän tainorau utomoi, na kiro onok keserum, okon, kiro paip musom penuk, na wa aräm, on utup sare rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Anut jou muraun owa ko kesernuk kesernuk, roasiret ak kasik raianik, Sekaraia owo sarau mora rai ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ko ätäi kasik nemara, ko aräu senek wa. Kesernuk, roasiret ak äpu moin ko tup owa kar onok penuk, aparwon. Ko are marau senek wa, okon, ko owo ämän awaraun ipousar ätär maronuk, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sekaraia, kon sarau miäwon ses manonuk, ko kon mena manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Rai rai, kon wau Elisabet amaiwo saremara, ko keir 5 orip kon mena ute manau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kos äiewon, “Rusapai, Anut nukas sareiromara, ko isan memes jäkäi murowon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabet ko amaiwo raunuk raunuk, keir 6 orip Anut nukas ätäi kon sarau eitek Gabriel, Galili provins kar mena enip Nasaret mena äsimornuk, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Anut nukan sarau eitekus kar asir makun, kon enip Maria, aparaun äsimornuk, potowon. Maria ko kar ro, enip Josep, owaun sare murin. Josep ko Devit nukan askanai pakan. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Anut nukan sarau eitek ko kiro asir Maria siakup pemara, auruwon, “Pere, Maria, Anut na pak rau. Anut nakanun wou eposek sarewon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria kiro ämän roumara, karkairianik, ronkat sosop owon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anut nukan sarau eitekus ätäi auruwon, “Maria, na wa iminäu. Anut na pak rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na tawa amaiwo sarianik, kar mokoi an jowam. Kiro mokoin enip Jisas mam. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ko ro näwäu sarianik, Anut kämioik rau nukan mokoi rawai. Anut nukas ko roasiret kamwaraun äsimorai. Kon askanai Devit rawon senek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ko Jekob nukan kinjaukut kamwaraun ro näwäu orip orip rawai. Kon roasiret wa utwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maria nukas ätäi Anut nukan sarau eitek auruwon, “Is kar ro pak ninau wa, okon, kiro onok owose is opok päi?” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anut nukan sarau eitekus Maria ätäi auruwon, “Anut nukan Osou na opok kowai. Anut nukan sakau na opok rawai. Keseria, kiro mokoi Anut nukan Mokoi äiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Maria, meter nan epaut Elisabet ko emas mowon mokoi wa owai äiein, ko rusapai amaiwo rau. Kon keir 6 orip manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Owo onok Anut nukas keseraun ko keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maria nukas ätäi Anut nukan sarau eitek auruwon, “Is Anut nukan sarau asir, kiro osap nas äiem senek is opok päura.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Keseria, Anut nukan sarau eitekus Maria ute manowon. Kiro ses opok, Maria siräianik, Elisabet aparaun Judia provins omtorou opok kon epauk aparau potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Maria ko Sekaraia nukan owa tonomara, Elisabet auruwon, “Pere.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","42","Elisabet ko Maria nukas ‘Pere’ aurnuk, kiro mokoi kon wou uru rawon karkairianik, siräiewon. Anut nukan Osou Näu Elisabet opok ok penuk, Elisabet ko Anut jou murianik, Maria auruwon, “Na asir sakau orip, nas asiret erekapu okoro omsau pakan na karar enmat jou kämioik musaiei. Na kiro mokoi an jowam eposek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Owon, kiro onok eposek is opok peu? Isan Näwäu nukan anak ko is rawa kou. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Is nas ‘Pere.’ airota, isan mokoi woi uru rau karkairianik, wou erermara, siräiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Na asir nan won epar senes sarewon, okon, nan won ereram. Anut nukasar aisowon siar nan won epar senes saräi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria nukas Anut jou murumara, äiewon, “Is totom orip erekapu Näwäu jou murim. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Isan woi näu sareu, owon, Anut nukas is sareiromara, imäirou. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Is, kon sarau asir enim näwäu wäpik, rusapai is kämioik murou. Rusapai pote tawa pak roasiret erekapu okoro omnokou pakan äiäiei, kiro asir kon wou erer rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Owon, kiro onok näwäu Anut sakau orip nukasar keserwon. Anut nukan enip eposek. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Meteran roasiret pak rusapaian roasiret pak ak Anut jou muraiei, kon wouti ak pak rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kon sakau näwäus kiro roat akan enmaka jou miäi, kos akan enmaka tonoi marai. Kiro roat akan enmak kämioik miäi, ak utwaronuk, sepuk sepuk manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Anut nukas kamwareäi roat näunäu akan taneäi sia pakan oi kurwaronuk, nona, kos ätäi roat enmaka wäpik sarwareanik, akan enmaka oik mareanik, omoi eposek opok marai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Anut nukas sou rai roat o eposek arai. Ko roat osap sosop orip äsimwaronuk, erar maneäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Meter Anut nukas iken askanai opok paip marowon. Kos Apraham kon kinjaukut pak äiewon ak sarwaram. Keseria, ko ik Israel kon sarau roasiret sareikowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ko ik Israel roasiret meter iken askanai Apraham pak kon tupsiu pak paip marowon rusapai kon wou eposek momara kou.” Maria keser äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria ko keir 3 orip Elisabet pak rawonus, ätäi nukan mena manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabet ko an jowaun ses kounuk, ko mokoi an jowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Kon menan roasiret pak kon tupsiu pak ak kiro ämän roumana, ak poteanik, ko pak woiaka erermoi, nepipirin. Owon, Anut nukas wou eposek sare muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Israel akan onok, mokoi omre 8 orip utonuk, kon enip kerau patiriäin*. Kiro mokoi omre 8 orip utomoi, kon enip kerau patiraun kon tupsiu pak erek imäi tup owa tonoin. Kiro ses opok, kon tupsiu akas momokun enip Sekaraias tunaror maurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Kon anakus ätäi awarowon, “Kiro wa. Kon enip Jon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Kon tupsiu akas ätäi Elisabet aurin, “Nan kar tupsiu enip Jon rawau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kon tupsiu akas ätäi kon momok totorin, ko ok utup aräu senek wa, okon, kon tupsiu akas kon mokoi enip maun ipiakas ätär murin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekaraia nukas kon ipous pepa opok jer wäun awaronuk, kar pepa oi nuruna, oumara, jer keser wewon, ‘Kon enip Jon’. Roasiret ak kiro enip aparmana, ak karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kiro ses opok Sekaraia ko ok utup rawon, ko ätäi arewon. Ko nepipirianik, Anut nukan enip jou muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Kon om jaukut ko siakup raiäin kiro ämän erekapu roumoi, ak iminemoi, kiro ämän erekapu Judia provins omtorou opok jou manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Roasiret ak kiro ämän roumoi, karauk totwaroin, “Kiro mokoi tawa ko owo sarau mai? Kiro mokoi Anut nukan ronkat pak kon sakau näwäu ko pak rau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Jon nukan momok, Sekaraia ko Anut nukan Osou Näu kon wou uru raunuk, ko Anut nukan enip keser jou muruwon, ");
INSERT INTO bbr2013_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ik Israel akan Anut Näwäu nukan enip jou murau. Kos koianik, ik kon roasiret sareikeanik, ätäi kau mukowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kos kon sarau ro Devit nukan tupsiu pakan kar ro ik ätäi kau mukaun äsimornuk, kowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Meter Anut nukas kon ämän roianik, ariain roat* akan oiaksau pakas äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ko äiewon, kos iken iwäinokot pak karauk roat ik aru mukiäi pakan ätäi imäikai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Kos äiewon, ko iken kinjaunokot eposek kamwareanik, sarwarmara, kon paip meter mowon ronkateu. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ko iken asanok Apraham epar senes auruwon. Kiro ämän rusapai ik opok epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ik ko iken iwäinokot akan ipiakapan imäikai. Ik wa iminäu, ik Anut nukan sarau wa utau. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Keseria, ik omnokou opok raia, ik kon amukup orip orip kon sarau eposek tuku tainori mam. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Na, isan mokoi, tawa nan enmat Anut kämioik rau nukan ämän roianik, ariäu ro senek aisaiei. Na Näwäu nukan apu sare murianik, amke potam. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Na roasiret ätär marota, ak äpu maiei, kos akan onok aru jäkäi maromoi, ak ätäi imwarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Iken Anut Näwäu ko ikenun wous meieanik, ko keserai. Ko omar oikan om merek ik opok äsimorai. Kiro merekus ik ätäi imäikai. ");
INSERT INTO bbr2013_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Kiro merekus roat pututu rai pak meiäuri pak merek kurwarai. Kon wou eposek sareanik, apu ätär mukai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kiro mokoi Anut nukan sakau orip urek sarewon. Ko ro wäpik mena pote rawon. Rai rai, Israel roasiret akan amiakap pemara, Anut nukan ämän tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kiro ses Elisabet ko Jon an jowon opok, kar ro näwäu Sisa-Okastas ko kiro ses opok kiro omsau pakan roasiret erekapu enmaka owaraun ämän surmarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Kiro mena kar ro kon enip Sairinias ko Siria provins kameäwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Roasiret erekapu akan askanai pewon opok ak karar karar akan enmaka buk opok wäun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josep ko Nasaret menas siräimara, Galili provins pakas pote Betlehem mena, Juda provins opok potowon. Ko Devit nukan askanai, okon, ko kiro opok kon enip wäun potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Josep ko kon wau Maria owaun sare murin amaiwo orip, enip erek wäun imäi potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Pote Betlehem mena rauna rauna, Maria ko an jowaun ses pewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Maria kon kaman mokoi an jowon. Omjos kururur momara, bulmakau akan o jeäin maro uru nini mowon. Kiro mena kar ou waru erar rawau wa, om erekapu oi kurein. Owon, roasiret kiro mena enmak wäu potoin akas om erekapu oi kurein. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kiro om ses opok, kiro mena kasakup karauk sipsip kamwareäin roat ak kiro pututu akan sipsip kamware ninoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Anut nukan sarau eitek ak siarakap penuk, Anut nukan arou näwäu kiro roat opiakap merek kurwarowon. Kiro roat akas kiro arou näwäu apari iminein. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Anut nukan sarau eitekus awarowon, “Ak wa iminäu, owon, is ak ämän eposek ak rawa oi koim. Okoro ämän mesin roasiret erekapu nepipiraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Rusapai pututu akan askanai Devit nukan mena, kar ro ak sarwaraun an jowon. Ko Krais* Näwäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ak kiro onok äpu maiei. Ak potoinai, kiro mokoi kon anakus bulmakau o jeäin maro opok nini momoi, omjos kururur mowon rau, ak pote aparwe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","14","Keser arenuk arenuk, omar oikan Anut nukan sarau eitek sosop pemana, Anut nukan enip jou mianik, sir wein. Ak keser sir wein, “Anut ko sakau orip, ko omar oik rau. Omnokou pakan roasiret ak onok eposek mona, Anut nukan wou eposek sareu, akan woiaka päurar rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kiro Anut nukan sarau eitek manona, sipsip kamwareäi roat aka aka arein, “Kir, ik Betlehem mena potea, ik kiro osap pewon Anut nukas aikowon pote aparau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Keseria, sipsip kamwareäin roat akas kurte poteanik, Maria kon komu Josep ori pote tarwatianik, kiro mokoi bulmakau akan maro uru nini rawon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Sipsip kamwareäin roat kiro mokoi aparianik, kon momok anak ori Anut nukan sarau eitekus ämän awarowon siar kiro ämän erekapu awatoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Roat kiro opok rain kiro ämän roianik, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maria ko kiro ämän roianik, kon wou uru erekapu me rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Keseria, sipsip kamwareäi roat ätäi akan mena poteanik, Anut jou murianik, sir wein. Owon, ak akan amiakas kiro mokoi aparin, Anut nukan sarau eitekus awarowon siar keseriar pote aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Omre 8 orip utonuk, kiro mokoin enip kerau patirianik, kon enip Jisas moin. Kiro enip meter Anut nukan sarau eitekus Maria amaiwo saräu wa opok kiro enip mowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Maria Josep ori omre 40 orip manonuk, anak ko mokoi pak ätäi eposek saräun, Anut nukan owa tonoirin. Owon, meter Moses nukas äiewon, ‘Aninakat, momonakat akas akan mokoit Anut nukan amuk opok imware pote Anut nuraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kiro Anut nukan sintore ämän opok rau. ‘Kiro mokoit urektapau ak amke naiei, kiro mokoit ak Anut Näwäu nuruwe.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Au Anut jou muraun ai manap oirori sintore ämänis äiewon siar oi tonoirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Kiro ses opok kar ro Jerusalem mena rawon. Kon enip Simeon. Ko Anut nukan amukup ro eposek raiäwon. Ko orip orip Anut jou muriäwon ro. Ko kar ro Israel roasiret ätäi imwarau kowaun kume rawon. Anut nukan Osou Näus Simeon pak rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Anut nukan Osou Näus Simeon auruwon, “Na kurte wa meiäm. Na kiro ro Näwäu nukas äsimorai, kon enip Krais aparmata, epar na meiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Keseria, Anut nukan Osous kiro ro äsimornuk, tup owa tonowon. Jisas nukan momok anak ori awan mokoi imäianik, tup owa meter akan asanakat akas keseriäin senek keseraun tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","29","Simeon nukas Jisas Maria ipokupan imäumara, Anut nukan enip kämioik keser jou muruwon. Ko äiewon, “Näwäu, rusapai nan sarau ro utota, päurar meiaura. Isan woi äiäurar rawai. Meter na is paip muromon, rusapai epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Isan amias nas ik imäikaun paip momon pewon aparim. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Na okoro roasiret amiakap okoro paip jekur maromon aparim. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kiro mokoinak kos kon arou kar omsau pakan roat opok arou marai. Kos nan Israel roasiret akan enmaka jou näwäu marai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Josep Maria ori au Simeon nukas ämän awatowon roianik, au karkairianik, ronkat sosop oirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon nukas jekur rawaun ämän awaromara, Jisas nukan anak Maria keser auruwon, “Na rou, okoro mokoi ko Israel roasiret sosop akas kon ämän wa tainoraiei, akas ko aru muraiei. Karauk roasiret sosop akas kon ämän tainoraiei, kos ak ätäi imwarai. Kiro Anut nukas taku mowon roasiret akas kon enip opok ämän aru muraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Keseria, roasiret akan ronkat amop päi. Tawa na wonti mianik, kiro kar siräp senekus nan waunauk patirai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kiro ses opok, Anut nukan ämän roianik, ariäwon asir kar, ko kiro tup owa raiäwon. Kon enip Ana. Ko kar ro kon enip Panuel nukan asinak, ko Asa nukan kinjauk. Ko emas sarewon. Meter ko ro owon opok, woisan 7 orip kon komu ori rairin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Rai, rai, kon komu meiewon, ko ro wäpik erar rawon. Kon woisan 84 orip. Ko tup ou näwäu opok Anut jou muraun wa utiäu, ko orip orip toneäu. Ko o utomara, Anut auri raiäu. Ko Anut nukan sarau pututu sankeu orip miäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kiro ses opok, ko Anut jou murau pewon. Kos Jerusalem menan roasiret tururin opok kiro mokoin ämän ätäi roasiret imwaraun kiro kame rain awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ak kiro onok Anut nukan sintore ämänis äiewon erekapu keseria, ätäi Galili provins, Nasaret mena potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Jisas ko sakau orip ko näwäu saremara, kon ronkat sosop orip. Anut nukas kon wou näu orip ko orip orip isanarwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jisas nukan momok anak ori woisan karar karar opok, Jerusalem mena kar tup enip Pasowa*, kiro jou muraun maneäir. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jisas kon woisan 12 orip sarenuk, kon momok anak ori au tup aparaun maneäirin siar Jerusalem mena erek manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Kiro tup enip Pasowa. Kiro tup patarianik, ak ätäi Nasaret mena koin. Jisas ko mokoi tenemai. Ko Jerusalem mena rawon. Kon momok anak ori au Jisas tup owa rau au äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Awan ronkat kesek Jisas ko karauk roasiret pak potou rai, ute manoin. Kiro omre potoin opok, au Jisas tararau wa. Keseria, momok anak ori au poteanik, Jisas nukan kas jaukut rawa itane potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Au Jisas itaneirin, itaneirin. Aparau warnuk, ätäi Jerusalem mena itanäu manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Au ko itane pote, omre 3 opok, au ko Anut nukan osap nuriäin ou näwäu owa pote rawon aparirin. Ko sintore ämän tamareäi roat* näunäu pak kamuk tane rawon. Ko pote tane rai kiro roat arena, roi rai, kos ätäi ämän totware rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Kiro roat kon ämän roumana, ak karkairin. Kon onok eposek, okon, kos ämän ätäi awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kon momok anak ori au ko tup owa rawon pote aparianik, karkairirin. Anakus kon mokoi auruwon, “Isan mokoi, na owon iu kiro onok keseitom? Iu momon ori nanun woiok usuäu sareu, iu na itaneise omre rumukur orip orip ari ramurin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jisas nukas ätäi awatowon, “Au owon is itaneire arieir? Au äpu wa, is isan monian owa raim” ");
INSERT INTO bbr2013_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Utianik, au kiro ämän onoktapau kos awatowon au äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Keseria, ko ätäi kon momok anak ori Nasaret mena tainwate potowon. Momok anak ories Jisas owo sarau ämän auriair erekapu tainoriäu. Kon anakus kiro ämän erekapu kon wou uru me rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisas ko ronkat eposek orip näwäu sarewon. Anut pak roasiret pak ak ko aparianik, ak woiaka kurein. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kiro ses opok, omsau pakan ro näwäu Sisa-Taibirias ko kiro omnokou woisan 15 orip kameäwon. Pontias-Pailot ko Judia provins kamwareäu ro. Herot ko Galili provins kamwareäu ro, kon awak Filip ko Ituria pak Trakonitis provins pak kameäu ro. Laisenias ko Abilena provins kameäu ro. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Annas Kaiapas ori, au Anut kamuk raiäirin roat ori näunäu senes. Kiro ses opok, Jon, Sekaraia nukan mokoi ro wäpik mena om puru opok raunuk, Anut nukan ämän ko opok kowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Keseria, Jon nukas Jordan An kasakup kiro omnokou opok erekapu pote arianik, Anut nukan ämän roasiret mareanik, awarowon, “Akan woiaka pirirnai, akan onok aru sumkäineinai, kouna, isas an jomaroita, Anut nukas akan onok aru jäkäi marai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Okoro ämän meter kar ro Anut nukan ämän roianik, areawon ro Aisaia nukas kon buk opok keser jer wewon, “Kar ro, ko ro wäpik mena om puru opok urwera. ‘Näwäu nukan apu jekur sare muruwe. Kon apu tuku muruwe. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Kiro omtorou rau erekapu jekur om wäiei. Kiro apu mänine rau, tuku sarewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Roasiret ak äpu maiei, kiro Anut nukas akan onok aru jäkäi mareanik, imäikaun kowai, aparaiei.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Keseria, roasiret sosop Jon nukas an jomaraun* kouna, Jon nukas awarowon, “Ak män nukan tupsiu senek, akan onok aru senes. Anut ak akwaraun kowai ses opok, ak owose imine manaiei? ");
INSERT INTO bbr2013_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ak akan onok aru sumkäineinai, akan woiaka pirirwe. Kiro karauk roat äpu maiei akan onok aru pakan ätäi piririn. Ak akan ronkat keser wa oumoi, äiäu, ‘Apraham ko iken askanai. Keseria, Anut nukas ik sareikonuk, ik eposek rawam.’ Anut ko okoro aiauk rusapai oumara, Apraham nukan kinjaukut ate maun itok. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anut nukan ipous man ateanik, am rurukup me rau. Kar am nemauk näu wa muriäwon, Anut nukas kiro man oumara, am näu wa muriäu patirianik, ep unik uru kurenuk, jeräi.” Jon nukas keser awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Keseria, roasiret akas ätäi totorin, “Ik owosemoi, eposek saräm?” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Jon nukas ätäi awarowon, “Owo roasir ko omjo oirori orip rawai, kar oianik, kar ro ko omjo wäpik ro nurai. Inok ro ko o sosop orip, ko kesekur keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Karauk takis aiauk oiäin roat, ak an jomaraun koianik, Jon totorin, “Näu ro, ik owosäu?” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Jon nukas ätäi awarowon, “Akan kamwareäu ro nukas aiauk owaun awarowon siar owe. Ak sätäumoi, roasiret akan aiauk sosop erar wa päu owau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Karauk marai roat akas nais pemana, ko totorin, “Ik owosäu?” Kos ätäi awarowon, “Ak karauk roat sepur akwaria, ämän sätwareanik, akan aiauk wa päu owau. Ak akan sarau pakan aiauk karar owe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Roasiret akan woiaka uruas ronkat sosop momoi, äiein, “Jon kiro ro ko Krais ra, ko wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Keseria, Jon nukas roasiret erekapu awarowon, “Is ak epar anas an jomareäim. Kar ro ruris koura, kon sakaus isan sakau itimorai. Is ro eposek wa, okon, is kon isou pakan su oikuräun senek itok wa. Kos ak Anut nukan Osou Näu ep oripas an jomarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ko sauwor ipous ate rau, kiro sauworis wit oreanik, oik monuk, uriris kiro wit sinok utarianik, wit näu oianik, kon owa seper mai, sinok apoi oianik, ep wa koseriäu opok makai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon nukas Anut nukan ämän pak karauk ämän eposek sosop roasiret woiaka pirir maraun pak awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","22","Roasiret erekapu Jon nukas an jomaronuk, rauna rauna, Jisas ko nais, Jon nukas an jomuruwon. Jisas an jomurumara, ko Anut aurnuk aurnuk, omar im tuewon. Kesermara, omar oikas Anut nukan Osou Näu ai manap senek ko opok koianik, tapakup nowon. Omar oikas kar ron pätu senek äiewon, “Na isakan mokoi senes. Isan woias nanun meieäu. Isan woi nanun näu sareu.” Rai rai, Jon nukas Herot, Galili akan kamwareäwon ro näwäu, roasiret amiakap kerianik, auruwon. Owon, ko kon amakun asir enip Herodias, Filip nukan asir owon, pak karauk onok aru mowon auruwon. Keseria, Herot nukas kasak pemara, onok aru senes momara, Jon karapus owa kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas ko woisan 30 orip momara, sarau onoktorowon. Roasiret akan ronkatis äiein Jisas ko Josep nukan mokoi, äiein. Josep ko Irai nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Irai ko Matat nukan mokoi, Matat ko Liwai nukan mokoi, Liwai ko Melki nukan mokoi, Melki ko Jamoi nukan mokoi, Jamoi ko Josep nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep ko Matatias nukan mokoi, Matatias ko Emos nukan mokoi, Emos ko Neam nukan mokoi, Neam ko Esli nukan mokoi, Esli ko Nagai nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai ko Meat nukan mokoi, Meat ko Matatias nukan mokoi, Matatias ko Semen nukan mokoi, Semen ko Josek nukan mokoi, Josek ko Joda nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda ko Joanan nukan mokoi, Joanan ko Resa nukan mokoi, Resa ko Serubabel nukan mokoi, Serubabel ko Sealtiel nukan mokoi, Sealtiel ko Neri nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri ko Melki nukan mokoi, Melki ko Erai nukan mokoi, Erai ko Kosam nukan mokoi, Kosam ko Ermaram nukan mokoi, Ermaram ko Er nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er ko Josua nukan mokoi, Josua ko Eliesa nukan mokoi, Eliesa ko Jorim nukan mokoi, Jorim ko Matat nukan mokoi, Matat ko Liwai nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai ko Simeon nukan mokoi, Simeon ko Juda nukan mokoi, Juda ko Josep nukan mokoi, Josep ko Jonam nukan mokoi, Jonam ko Eliakim nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim ko Melea nukan mokoi, Melea ko Mena nukan mokoi, Mena ko Matata nukan mokoi, Matata ko Natan nukan mokoi, Natan ko Devit nukan Mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Devit ko Jesi nukan mokoi, Jesi ko Obet nukan mokoi, Obet ko Boas nukan mokoi, Boas ko Salmon nukan mokoi, Salmon ko Nason nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason ko Aminarap nukan mokoi, Aminarap ko Atmin nukan mokoi, Atmin ko Hesron nukan mokoi, Hesron ko Peres nukan mokoi, Peres ko Juda nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda ko Jekob nukan mokoi, Jekob ko Aisak nukan mokoi, Aisak ko Apraham nukan mokoi, Apraham ko Tira nukan mokoi, Tira ko Nahor nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor ko Seruk nukan mokoi, Seruk ko Reu nukan mokoi, Reu ko Pelek nukan mokoi, Pelek ko Eber nukan mokoi, Eber ko Sela nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela ko Kenan nukan mokoi, Kenan ko Arpaksat nukan mokoi, Arpaksat ko Sem nukan mokoi, Sem ko Noa nukan mokoi, Noa ko Lamek nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek ko Metusela nukan mokoi, Metusela ko Enok nukan mokoi, Enok ko Jaret nukan mokoi, Jaret ko Makalalel nukan mokoi, Makalalel ko Kenan nukan mokoi, ");
INSERT INTO bbr2013_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan ko Enos nukan mokoi, Enos ko Set nukan mokoi, Set ko Adam nukan mokoi, Adam ko Anut nukan Mokoi. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisas ko Jon nukas an jomurnuk, Jordan An pakas Osou Näu orip kasakup penuk, Osou Näus ko ro wäpik mena om puru opok imäi, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Kiro ro wäpik mena om puru opok, omre 40 orip ko o wäpik rawon raunuk raunuk, Satan nukas Jisas ate aparwon. Kiro ses opok ko kar o jau wa. Ko sou näwäu wewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Satan ko Jisas rawa pemara, auruwon, “Na, Anut nukan Mokoi raroi, na okoro aiauk aurta, bret etäunuk, je.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jisas nukas ätäi Satan auruwon, “Anut nukan ämänis äieu, ‘Ro bret karar jeanik, awau wa rawai.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","7","Keseria, Satan nukas ätäi Jisas imäumara, omtapau oik imäi toptomara, omnokou erekapu ätär muria, auruwon, “Na is jou murota, na okoro omnokou pakan sakau pak okoro omnokou pak kiro osap eposek erekapu na isam. Na is jou murota, okoro omnokou Anut nukas is irowon na aparum, rusapai isas kiro erekapu na isam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisas nukas ätäi Satan auruwon, “Anut nukan ämän äieu, ‘Na nan Näwäu karar jou mur. Na Anut nukan sarau karar muram.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Keseria, Satan nukas ätäi Jisas imäiemara, Jerusalem tup ou näwäu kämioik tone momara, auruwon, “Utianik, na Anut nukan Mokoi raroi, nakarar kiro pakas pokitir nopot. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anut nukan ämänis äieu, ‘Anut nukas kon sarau eitek nanun awaronuk, na päurar imäisi ne musaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Akas nan ipon karaima karaima atianik, oi ne musaiei. Keserna, kar aiaukus na ison wa wäi.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisas nukas ätäi auruwon, “Ei, Anut nukan ämänis äieu, ‘Na nan Näwäu, Anut wa ate apar.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Keseria, Satan ko Jisas ute manowon. Erekapu ute manau wa, ko tawa Jisas ätäi ate aparaun kame rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Keseria, Jisas ko Anut nukan Osou sakau näu orip Galili provins ätäi potowon. Roasiret kon sarau mowon ämän arena, erekapu omsau erekapu roin. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ko orip orip roasiret akan tup owa Anut nukan ämän awareäunuk, roasiret erekapu kon ämän roianik, Jisas nukan enip jou muriäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Keseria, Jisas ko meter Nasaret mena raianik, urek sarewon, sumaun ses tup opok, kon onok keseriäwon senek, ko tup owa tonowon. Ko siräianik, Anut nukan ämän roasiret amiakap ninaräu potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Anut nukan ämän roianik, areawon ro Aisaia nukan buk oi nurin. Kos kiro buk tupäi moin, uraremara, jer keser rawon ninare marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Anut nukan osou is pak rau, owon, nukasar is roasiret aru moin pak saruku roasiret pak Anut nukan Ämän Eposek awaraun äsimoirnuk, koimin. Ak karapus raiäin roat ak karapus owa utoinai, manowe. Ak amiak utup roat ak rusapai jekur apu aparwe. Anut nukasar is äsimoirnuk, roat sarau aru me rain ätäi imwaraun, koimin. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kiro ses Anut Näwäu nukas kon roasiret onok aru pakan imwaraun peu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Keser ninareanik, ätäi kiro buk tupäimara, kameäwon ro nurumoi, ko pote tanewon. Kiro turur rain roasiret erekapu akan amiakas Jisas karar aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Kos awarowon, “Ak rusapai roi rauna, is okoro ämän ninare marom roi. Kiro ämän rusapai epar peu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Roasiret ak Jisas oksau pakan ämän eposek roumoi, kon enip jou murianik, kiro ämän eposek awarowon, ronkat sosop oin. Keserianik, aka aka arein, “Kiro mokoi Josep nukan ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisas nukas ätäi awarowon, “Epar senes, ak is kiro ämän keser airaiei, ‘Na dokta, na nakasar ätäi nakan enmatsau jekur mo.’ Ak is keser airaiei. ‘Kiro onok Kapaneam mena onok atap atap kesermon senek, kiro ik roumun senek nakan mena keseriar keser.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Is ak epar senes awarom, roasiret ak Anut nukan ämän roianik, areawon ro nukan menanus kon ämän wa roiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ak jekur rowe, meter Israel omsau, Elaija rawon ses opok, karauk wäimäs asiret sosop rain. Kiro ses opok woisan 3 orip pak keir 6 orip pak kar om omar oikas nau wa, kiro ses opok sou ses näwäu omsau erekapu pewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Keseria, Anut nukas Elaija kar Israel asir opok äsimorau wa, ko Elaija kar mena enip Sarepat, Saidon omsau kiro opok kar wäimäs asir opok äsimorwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Keserianik, kiro ses opok Anut nukan ämän roianik, areawon ro Elaisa rawon opok, Israel roasiret sosop ak sip repros orip aru marowon rain, ko kar ro jekur mau wa. Neaman ko karar, Siria provins pakan ro karar jekur mowon.” Jisas nukas keser awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Roasiret ak erekapu turur rain, ak kiro ämän roumana, kasiaka näwäu pewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ak siräianik, Jisas suorna, mena kasik kaima om korosi opok sir naun suor potoin. Kiro mena kar omtapau siakup imäi potoin. Kiro pakas suorna, sir naun rai imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ak ko keserna, kos ak unik uruas itimwareanik, manowon. Ak ko aparin, ko sakau orip, okon, erar apai rauna, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisas ko Galili provins Kapaneam mena pote rawon. Kar tup opok, kiro pakan roasiret Anut nukan ämän kiro opok mare rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Kiro pakan roasiret ak kon ämän roianik, karkairin. Owon, ko kar ro enip orip senekus ämän awarnuk, roin. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","34","Kiro tururiäi owa, kar ro ko osou aru kon wou uru rawon. Ko kakapar piermara, äiewon, “Nasaret menan Jisas, na ik owoseikaun koum? Utianik, na ik aru mukaun koum ra? Is na äpu, na ro eposek tuku senes Anut nuka pakaima koumon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisas nukas osou aru sakau ämän auruwon, “Na asornam, kiro ro utoinam, man.” Kiro osou aru kiro ro wou uru rawon, ute manaurmara, roasiret amiakap kiro ro omnokou opok ämäi tirmoi, ko aru mau wa, erar ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Roasiret ak kiro onok keserwon aparmana, karkairianik, aka aka keser arein, “Kiro owo ämän? Kiro ro kon sakaus omsau pakan osou aru sosop sakau ämän awaronuk, ak kon ämän roumana, roat akan woiaka uru rain utware manoin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Keseria, Jisas nukan sarau mowon ämän omsau erekapu manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisas ko roasiret pak akan tururiäi owa rain utwareanik, kar ro Saimon nukan owa potowon. Saimon nukan tanau asir ko sip enip sopou orip, nini rawon. Roasiret ak Jisas kiro asir jekuraun aurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisas nukas Saimon nukan tanau asir sip orip nini rawon siakup tone tai raumara, kiro sip sakau ämän auruwon. Aurnuk, kiro sip kurte ute manowon. Kiro sip asir utomara manowon, kiro asir ko siräumara, karauk roat akan o mis momara, kamware rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","San nonuk, kiro roat akan jaunakat sip aru orip Jisas siakup imware kouna, Jisas nukan ipous sip roat karar karar akan tapiaka opok maronuk, akan sip aru jekwaronuk, näu sarein. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kiro osou aru ak sip roat sosop opok rain, ak erekapu ute manoin. Kiro osou aru akas piormana, äiein, “Epar, na Anut nukan Mokoi.” Jisas nukan sakaus osou aru akan oiaksau utup sarewon, akas ätäi aurau senek wa. Owon, ak äpu Jisas ko Anut nukan Mokoi. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tapera senes, Jisas rawon mena utomoi, kar mena ro jejemak wäpik opok potowon. Roasiret ak ko itanein. Itane pote aparianik, ak ko siakup potoin. Ak ko tararmana, akas ko utona, manaun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kos ätäi awarowon, “Is karauk mena Anut nukan ämän pote tamaram. Kiro onokun Anut nukas is äsimoirnuk, koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Keseria, Judia provins erekapu tururiäi owa, Anut nukan ämän pote tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kar omre opok, Jisas ko Galili An Unik, (kiro an unik kon kar enip Genesaret) ko kiro an kasakup tai raunuk, roasiret ak kos Anut nukan ämän maronuk, rowaun, Jisas sorotorna, ko keres keres an kasakup potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisas ko ous oirori kiro an kasakup us nokou opok rairin aparwon. Kiro ous atak roat aka ous oikas neanik, akan was oiäin jo an kosor rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisas nukas Saimon nukan ous oik tonomara, Saimon auruwon, ous an unik opok suornuk, potaun auruwon. Keserianik, ko kiro ous oikas tone tanemara, roasiret Anut nukan ämän mare rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Jisas nukas roasiret Anut nukan ämän mare rawonus, Saimon auruwon, “Ous an näu kamuk oi potoinam, nan jaunat pak ätäi was oiäin jo kureinai, was owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimon nukas Jisas ätäi auruwon, “Näwäu, rusa pututu ik was oiäin jo kuremun kuremun, ik kar was eteinak owau wa. Rusa nas äiem, okon, is ätäi kuräm.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jisas nukan ämän tainoria, akan was oiäin jo kurena, nonuk, was sosop kiro jo opok nowon, owau senek wa, akan jo kiräi kuräurwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Keseria, akas akan jaunakat kar ous opok rain urwarona, koin. Kiro jo was sosop orip ate reurna, kiro ous oirori opok was sosop senes sarewon. Was akan usuäus kiro ous an unik uru naurwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Saimon-Pita ko kiro was aparianik, näwäu iminewon. Kos kiro onok aparmoi, ko Jisas siakup pemara, uou sur weanik, Jisas auruwon, “Näwäu, na is utoirnam, man. Owon, is onok aru miäim ro.” Kon jaukut erek rain, ak nais erek kiro onok aparianik, näwäu iminein. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi nukan mokoit ori, Jems Jon ori, au Saimon pak erek ariain, ak kiro onok aparia, karkairirin. Jisas nukas Saimon-Pita auruwon, “Na wa iminäu, na okoro was rusapai oum senek, tawa na roasiret keseriar imwaram.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Keseria, ak akan ous kiro an kasakup oi pote mia, kiro osap erekapu utia, ak Jisas tainori manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Kar omre opok, Jisas ko kar näu mena potowon. Kiro mena kar ro sip aru repros orip rawon. Kiro ro ko koi Jisas aparmara, uou sur weanik, Jisas auruwon, “Näwäu, na isan ui aru jäkäi muraun itok, utianik, nan ronkat pakas keser. Na is rapoire murota, is eposek saräm.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisas nukas wouti momara, kiro ron tapau atomara, auruwon, “Isas aisom, na eposek saräm.” Kiro ses opokar, kiro ron repros ui manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jisas nukas kiro ro sakau ämän auruwon, “Is okoro onok keserim na pote karauk roasiret wa awarau. Utianik, na Anut kamuk raiäu ro siakup potea, nan enmat näu sarewon ätär muruta, apaisai. Apaisonuk, na Moses nukan sintore ämän tainornam, opur oianik, Anut jou muruta, kiro epar roasiret erekapu äpu maiei, na ätäi eposek saremon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Kiro ro Jisas nukas ämän auruwon tainorau wa, ko potomara, roasiret erekapu awarowon. Roasiret sosop ak kiro ämän roumana, ak Jisas kon ämän rowaun pak akan sip jekur maraun pak koin. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Jisas nukas Anut auraun ko omnokou roasiret wa raiäi opok poteanik, Anut auriäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Kar omre opok, Jisas ko Anut nukan ämän roasiret maronuk maronuk, karauk Parisi* roat näunäu pak sintore ämän tamareäi roat pak, ak erekapu Galili provins pakan, pak Judia provins pakan pak Jerusalem näu menan pak koianik, ak kiro opok tane rain. Näwäu nukan sakau Jisas opok raunuk, ko roasiret sip orip jekur maraun itok. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Kesernuk, karauk roat akas kar ro patan opok mianik, Jisas siakup ämäi koin. Kiro ro kon enipsau erekapu meiewon, ko siräi manau senek wa. Ak kiro ro ämäianik, Jisas owa rawon opok nepukup maurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Owa roasiret sosop rauna, ak ou rorok pakaima tonau senek wa. Keseria, kiro roat akas ou sakatou apsasawou oik toneanik, kiro ou sakatou tuwemana, kiro oikas kiro sip ro Jisas tai rawon opok nepukup mona, nowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jisas nukas akan woiaka epar moin apwaromara, ko kiro sip ro auruwon, “Jai, nan onok aru jäkäi musom.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Kiro Parisi roat pak sintore ämän tamareäin roat pak aka aka ronkatein, “Okoro owo onok? Okoro owo ros Anut ate aparau? Kar omnokou pakan ros ko onok aru jäkäi mau senek wa. Anut nukas karar epar ko onok aru jäkäi maraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jisas ko akan ronkat woiaka uru äpu momara, awarowon, “Ak akan woiaka uru owon kiro ronkat ourai? ");
INSERT INTO bbr2013_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Is owo ämän äiäun itok, owo ämän äiäun itok wa? ‘Nan onok aru jäkäi musom,’ is keser äiäm ra, ‘Na siräinam, manam,’ is keser äiäm ra? Is owo ämän äiäm, ak akan woiaka is mesin epar maiei? ");
INSERT INTO bbr2013_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Utianik, ak Ro Nukan Mokoi ko enip orip, ko okoro omnokou pakan onok aru jäkäi maun itok äpu maun is keseram.” Keseria, kos kiro ro kon ipou isou meiewon auruwon, “Isas aisom, na siräinam, nan mat oinam, nan mena man!” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Jisas nukas kiro ro keser aurnuk, ko kurte siräimara, roasiret erekapu turur rain amiakap ko kon mat oumara, Anut jou murianik, kon mena manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko manonuk, kiro roasiret ak erekapu karkairianik, iminemoi, ak Anut nukan enip jou murumana, äiein, “Ik rusapai kar onok atap aparum.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kiro onok kesermara, Jisas ko potomara, kar ro enip Liwai ko roasiret akan takis aiauk oiäu, kon sarau miäwon owa tane raunuk, aparwon. Jisas nukas Liwai auruwon, “Na koi, is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Keser aurnuk, Liwai nukas siräianik, osap erekapu utomoi, Jisas tainori manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kar omre opok, Liwai ko Jisas pak kon owa poteanik, o je rain. Kon owa kon sarau jaukut pak karauk roat pak tururianik, Jisas pak o jein. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Karauk Parisi roat pak sintore ämän tamareäi roat pak akas ämän sosop mianik, Jisas nukan tamareäu roat* totwaroin, “Ak owon takis oiäi roat pak roat onok aru miäi pak erek o jerai?” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisas kiro ämän roumara, kos ätäi awarowon, “Roat ak sip wäpik, ak dokta siakup wa poteäi. Inok ro ko sip orip karar ko dokta siakup poteäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Kiro senek, is roasiret onok eposek miäi urwaraun kowau wa. Is roasiret onok aru miäi ak akan woiaka piriraun koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Karauk roat akas Jisas totorin, “Jon nukan tamareäu roat ak kar muti o wa jeäi. Ak Anut karar auri raiäi. Parisi akan tamareäi roat, nais ak keseriar keseriäi. Utianik, nan tamareäum roat ak o pak an pak sosop jeäi. Ak owon keseriäi?” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisas nukas ätäi awarowon, “Kar asir ro owaun ses opok, kiro ro raunuk, kon jaukut koi rauna, o utaun itok ra? Is epar awarom, Kiro onok wa keseraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Utianik, tawa kiro ro asir owaun ko karauk roat akas ak pakan imäi manona, kiro epar kiro ses opok, ak o utaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Keseria, kos kar totok ämän awarowon, “Kar ros kon meteran omjo kiräianik, ko kon omjo awau pakan omjo si eteinak patirnuk, kiräianik, mustäi opok wa näke miäu. Kar ros kiro onok kesernuk, kon omjo awau aru mianik, kiro omjo si awau eteinak, omjo mustäi ori eposek wa sarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Kar ros wain an awau meme kerau mustäi opok wa äräine miäu. Ko kesernuk rai, kiro wain an awau sipar kurarianik, meteran meme kerau kiräianik, wain an omnokou opok kour nai. Kiro meme kerau nais erek jäkäiai. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wain an awau ko meme kerau awau opok äräine mota, au eposek rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kar ro ko wain an meten jeanik, ko awau utiäu. Ko keser äiäi, ‘Mustäi kiro eposek.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Kar tup etei sumiäi omre opok, Jisas ko kon tamareäu roat pak, wit woi kamukas potoin. Kon tamareäu roat akas wit nemauk oianik, nuakemoi, je je potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Karauk Parisi roat akas apwareanik, äiein, “Ak owon sumaun ses opok sarau morai? Kiro ak Moses nukan sintore ämän aru morai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisas nukas ätäi awarowon, “Ak Devit kon weräiäi roat pak sou akwaronuk, Anut jou murin pakan bret jein, ak äpu ra, äpu wa? ");
INSERT INTO bbr2013_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ko Anut nukan owa tonomara, kiro bret Anut jou muriäin patan opok rawon oumara, kon roat pak jein. Kiro ep roat akas jaun itok wa. Anut kamuk raiäi roat akas karar jeäin. Utianik, Devit nukas kon roat pak jein. Ak kiro jer ninaräu wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Keseria, Jisas nukas awarowon, “Ro Nukan Mokoi, nukasar kiro sumaun omre kameäu, ko owo onok keseraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Kar tup etei sumaun omre opok Jisas ko tup owa tonomara, Anut nukan ämän roasiret mare rawon. Kar ro kon ipou karaima meiewon orip ko kiro tup owa rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Raunuk, karauk Parisi roat pak sintore ämän tamareäi roat pak Jisas enkup ämän maun kiro ro jekurnuk, aparaun rai kame rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jisas ko kiro roat akan ronkat äpu momara, kiro ipou meiewon ro auruwon, “Na siräinam, roasiret amiakap koi.” Kiro ro siräumara, roasiret amiakap koi tai rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Keseria, Jisas nukas Parisi roat awarowon, “Is ak totwaraurim, iken sintore ämän nukas sumaun omre opok onok eposek maun äiein ra, onok aru maraun äiein? Kar ro jekurau ra, aru murau?” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Keseria, Jisas nukas roasiret erekapu apware kuremara, kiro ro auruwon, “Nan ipon kure.” Kiro ro auruwon siar kesernuk, kon ipou näu ätäi meter eposek rawon senek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Utianik, Jisas nukas kiro kesernuk, aparia, roat näunäu ak kasiaka penuk, aka aka Jisas wena, meiäun ämän atoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kar ses opok, pututu Jisas ko Anut auraun omtorou opok tone Anut auri rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Tapera, kon tamareäu roat urwarnuk, kouna, roat 12 orip sare marowon. Keser sare maromara, Anut nukan ämän omsau oi ariaun roat* enmak marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","16","Kiro roat sare marowon, akan enmak kiro: Saimon (Jisas nukas ko kar enip Pita mowon), kon amak Andru, Jems, kon amak Jon pak, Filip, Bartolomiu, Matiu, Tomas, kar Jems (Alfius nukan mokoi), kar Saimon (ko kar tupsiu enip Serot pakan), Judas (Jems nukan mokoi), kar Judas Iskariot kos Jisas kon iwäi jaukut akan ipiakap marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Jisas kon ämän oi ariaun roat sare mareanik, ko ne, om urun opok kon sarau roasiret sosop pak karauk roasiret sosop, Judia provins pakan pak, Jerusalem menan pak, Taia menan pak, Saidon menan pak kiro omnokou erekapu kiro pakan koi turur rain opok nowon. Kiro roasiret ak kon ämän rowau koin, karauk roasiret sip aru orip pak, osou aru orip pak, Jisas nukas jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Roasiret ak kon omjo atona, eposek sariai. Kon sakau kiro pakas potomara, roasiret sip orip eposek sariai. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisas nukas kon tamareäu roat apwaromara, awarowon, “Inok roasiret ak äpu akasar akan totomaka sarwarau senek wa, akararnak onok eposek mau senek wa, ak woiaka eposek saräiei. Anut nukas ak kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ei, ak rowe, inok roasiret ak Anut nukan onok eposek owaun sarau sakau maiei ak woiaka eposek saräiei. Owon, Anut akan sarau moin apwareanik, sarwarai. Ei, ak rowe, rusapai ak wairai, ak akan woiaka näu sare rawe. Tawa ak nepipiraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tawa ak Ro Nukan Mokoi tainori arina, roasiret akas ak mesin kasiaka pemana, akan enmaka aru maiei, kiro keserna, ak akan woiaka näu sarewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Kiro onok ak opok keserna, ak woiaka aru wa mau, woiaka näu moinai, nepipirwe. Owon, ak kiro onok keseraiei, Anut nukas karauk osap eposek sare marowon omar oik rau tawa owaiei. Meter akan askanai Anut nukan ämän roianik, areain roat kiro onok aru ak opok keseriar keseraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Jisas nukas ätäi äiewon, “Ak roasiret ak rusapai osap sosop orip, ak rusa jekur nepipir rai, tawa ak saruku saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ak roasiret ak rusapai o sosop jeanik, nokomaka pera, tawa ak sou akwarai. Ak roasiret ak rusapai nepipirianik rai, tawa ak woiakati mianik, wai rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Ak rusapai jekur rauna, meter akan askanai akas sät eitek akan ämän roianik, areain roat, akan enmaka jou mareäin senek roasiret akas akan enmaka jou maraiei. Ak wopurut, tawa ak usu näwäu owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Jisas nukas ätäiar äiewon, “Ak rowe, akan iwäi jaunakat pak wa weräiäu. Roasiret akas akan enmakap sät ämän mona, akas onok eposek kiro roasiret opok maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ak kiro roat akas ak aru maraun areai, akas pak jekur rawaun ämän awarowe. Ak kiro roat akas ak aru maraun arina, akas Anut aurna, Anut nukas kiro roat sarwarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Utianik, kar ros nan sipon näu kaimas purnuk, ätäi pirirnam, sipon sau kaimas nuruta, purai. Utianik, kar ros nan omjo rumukäu ounuk rai, nas wa tämurau. Utota, nan kar omjo nais owaura. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Kar ros nan osap owaun aisonuk, na wa tämurau. Na ko nuram. Kar ros nan osap oi manonuk, ätäi amuk iram rai wa aurau. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Owo onok eposek karauk roat akas ak opok keseraun ronkataiei, akas kiro onok eposek karauk roat opok keseriar keseware. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Karauk roat akas akanun woiakas meieäi, akas nais ätäi kiro roat akanun karar woiaka meieäi. Keserna, Anut nukas ak kar osap eposek arai ra? Onok aru miäin roat nais ak keseriar keseriäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Akas karauk roat kar onok eposek ak opok moin, akas nais ak eposek kamwaraiei, owo osap eposek owaiei? Roat onok aru miäi ak nais kiro onok keseriar keseriäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ak kar ro akan osap nurianik, akan ronkat ko kiro osap ätäi arai, owo osap eposek Anut nukas ak arai? Onok aru miäu ro nais ko kar ro osap nurunuk, kon ronkat, kiro ros osap ätäi nuraun rai ronkatäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ak kiro onok utomana, akan iwäi jaunakat akanun woiakati maronai, jekur sarware. Ak onok eposek akan iwäi jaunakat opok mowe. Ak roat osap aroinai, ätäi akas pak akan osap ikaurai rai wa ronkatäu. Ak keseraiei, tawa ak osap näwäu owaiei, ak Anut Näwäu nukan mokoit epar rawaiei. Anut ko roat osap erar ariäu, akas ko wa auriäi. Roat eposek pak, roat aru pak, Anut nukasar rapor kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Akan momonaka, Anut nukas karauk roasiret akanun woiakati miäu senek, ak nais karauk roat akanun woiakati mianik, sarwaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisas nukas ätäi äiewon, “Ak karauk roat akan onok wa wasarewaräiei. Ak keserna, Anut nukas nais akan onok wa wasaräi. Ak kar ron onok aru wa aparau. Ak keserna, Anut nukas nais akan onok aru wa aparai. Ak kar ron onok aru utona, Anut nukas akan onok aru utomarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ak karauk roat osap ariai senek, Anut nukas ak osap arai. Ak roat osap sosop arona, Anut nukas nais ak ätäi osap sosop arai. Kos akan jowa ätäi osap sosop jokeanik, jo suormara, ätäiar osap sosop jowa jokonuk, akan jo ok päi. Ak kiro osap sosop owaiei. Ak karauk roat opok owo onok miäi senek, Anut nukas ak opok nais keseriar keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jisas nukas kar totok ämän awarowon. “Kar ro amuk utup, kos kar ro amuk utup jauk apu ätär muraun itok ra, wa ra? Ko jauk kesernuk, kiro roat oirori amiaka utup jauk ournuk rai, jauk ori erekur owateanik, up uru naieir. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Kar mokoi ko kon tamareäu ro itimorau senek wa. Ko tawa ämän erekapu roianik, jekur tainoria, epar ko kon tamareäu ro senek sarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Na owon jaunan amuk opok us eteinak oikuräun aparum? Nakan amun opok am sawau rau na aparau senek wa ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nakan amunauk opok am sawau näwäu raunuk, na owose nan jaunan amuk opok us oi kuräun aurum, ‘Jai, is nan amun opok us oi kure musam rai aurum?’ Na sätwareäum ro, amke am sawau näwäu nakan amun opok rau oi kureinam, ätäi eposek apu aparianik, epar jaunan amuk opok us rau oi kure mur.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jisas nukas awarowon, “Am eposek raiäu, ko nemauk aru wa muriäu. Am aru ko nemauk eposek wa muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Am erekapu rau, akan nemauk karar muriäu. Wer nemauk ko äriauk mu opok wa muriäu. Roat ak uran nemauk isiau amurik pakan oiäi ra? Wa senes wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ro eposek ko kon ronkat eposek orip ko ämän eposek kon wou uruas siräi penuk, areäu. Ro aru ko kon ronkat aru orip ko ämän aru miäu. Owo ronkat kon wou uru raiäu, kiro siräi penuk, kon oksau pakas ämän miäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Jisas nukas ätäi äiewon, “Ak owon, is ‘Näwäu, Näwäu.’ airiäi? Ak owon isan ämän wa tainoriäi? ");
INSERT INTO bbr2013_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ak rowe! Kar ro ko is rawa koianik, isan ämän roumara, tainoriäu. Is kon onok ak opok ätär marota, aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kiro ro isan ämän roumara, tainoriäu, kiro onok kesek. Kar ro ko ou maurmara, amke up tuwe noptomara, aiauk tararmara, ou tutu sakau kurewon. Om näwäu nomara, joi näwäu nowon, kiro ou ko sakau rawon. Owon, ko aiauk opok ou mowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kar ro ko isan ämän roumara, tainorau wa, ko kesek, ko ou us nokou opok ou up tuemara, ou mowon, ko ou sakau mau wa. Om näwäu nomara, joi näwäu nowon, kiro ou erekapu joies oi manowon. Kiro ro ko Anut nukan ämän roumara, wa tainoriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisas ko Anut nukan ämän roasiret erekapu mare kuremara, ko Galili an kasakup Kapaneam mena manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kiro mena kar ro, ko marai roat akan kamwareäu ro näwäu, nukan sarau ro ko sip orip. Kon sarau ro kon sarau ämän aurnuk, jekur tainoriäu. Keseria, kon ro näwäu konun wous meiewon. Kiro ro sip näwäu oumara, meiäurnuk, kiro ro näwäu ko kon sarau ro nukanun wouti mowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Keseria, kiro ro näwäu ko Jisas Kapaneam mena pe rawon ämän roumara, kos karauk Juda* akan roat näunäu äsimwaronuk, koi kon sarau ro jekuraun aurau potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kiro roat akas Jisas siakup tonomana, ämän sakau aurin, “Kiro ros ik jekur kamoikeäu kon sarau ro meiäuru, okon, nas potoinam, jekur mo. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ko ik Juda roasiret jekur sareikeäu. Kosar iken tururianik, Anut nuka jou muraun ou mowon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Keseria, Jisas ko kiro ro näwäu nukan sarau roat tainware potowon. Ko mena siakup potonuk, kiro ro näwäu nukas Jisas ämän keser surmurowon, “Näwäu, is onok aru miäim ro, okon, na isan owa wa potau. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Is ro aru, okon, is na siatap potau senek itok wa. Utianik, na onsaus karar äieta, isan sarau ro ko eposek saräi. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Is nais roat näunäu akan inkaruru raiäim. Karauk marai roat ak isan inkaruru raiäi. Isan kar marai ro auriaim, ‘Na okoro opok koi,’ aurita, koiäu, kar auriaim, ‘Na enro opok pot,’ aurita, poteäu. Isan sarau ro ko ‘Na okoro sarau mo,’ rai aurita, sarau miäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisas ko kiro ämän roumara, ko karkairwon. Ko ätäi pirirmara, kiro roasiret ko tainori potoin awarowon, “Is epar senes awarom, is kar Israel ro okoro ro senek kon wou epar mowon wa aparmin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kiro roat akan näwäu nukas äsimwarowon ak ätäi poteanik, kiro sarau ro eposek sarewon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Om ses katu manonuk, Jisas kar mena enip Nein, kiro mena potowon. Kon tamareäu roat pak karauk roasiret sosop pak erek potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Jisas ko kiro mena porim rorokpai siakup raunuk, kar ro meiewon imäi koin, Ro meiewon kon anak kar mokoi wäpik, kon mokoi kiro karar, kon komu nais meter meiewon. Kiro mena roasiret sosop kiro asik pak erek tainori koin. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Näwäu ko kiro asik aparianik, wouti mowon. Ko kiro asir auruwon, “Na wa waiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ko kiro ro meiewon siakup poteanik, ro meiewon patan opok ipou mowon. Kesernuk, roat ak meiewon ro patan orip ämäi koin ak kiro opok tai rain. Jisas nukas äiewon, “Mokoi, is aisom, na siräu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Kiro ro meiewon ätäi siräumara, kon patan opok tane raumara, ko arewon. Keseria, Jisas nukas kiro mokoi imäiemara, kon anak nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kesernuk, roasiret erekapu iminemoi, Anut nukan enip jou murianik, ak äiein, “Anut nukan ämän roianik, areawon ro kar ik kamuk kowon. Anut kon roasiret sarwarau kowon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Roasiret ak Judia provins pak karauk omnokou Judia siakup pak manoutomana, ak kiro onok Jisas nukas sarau mowon ämän ari ari arein. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Jon nukan tamareäu roat akas Jisas nukas onok erekapu Jisas nukas keserwon aparianik, Jon koi aurin. Keseria, Jon nukas kon tamareäu roat ori, Jisas siakup äsimwatia, keser totoraun awatowon, “Roat akas kar ro näwäu kowai äiein. Na kiro ro ra, ara, ik kar ro ruris kowai kumäm ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kiro roat ories Jisas siakup koianik, totoririn, “An jomareäu ro, Jon nukas ik na totoisaun äsimoitowon, ‘Na koi Israel roasiret imwaraun koumon ra, ik kar ro kowai kamäm?’” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kiro ses opok Jisas nukas roasiret sosop sip aru orip jekwarowon. Osou aru orip roat erek jekwarowon. Karauk roat amiak utup orip amiaka urarenuk, ak ätäi om aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Keseria, Jisas nukas ätäi kiro roat ori awatowon, “Ak owo ämän roumoi, akan amiakas owo onok apari kiro erekapu, ätäi pote Jon aurwe. Amiak utup roat ak ätäi amiak uräianik, om apari. Isiaka tipinewon roat ak apu arirai. Roat sip repros orip ak ätäi eposek sarei. Raiaka otop roat ak ätäi ämän jekur roi. Meiein roat ak ätäi awau siräiein. Saruku roat ak Anut nukan Ämän Eposek roi. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Inok ro ko isanun wou epar mianik, ko sakau tai rawai, kiro ro kon wou näu saräi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jon nukan tamareäu roat ori manosa, Jisas nukas Jon nukan ämän roasiret turur rain awarowon, “Ak ro wäpik mena om puru opok Jon siakup owo osap aparaun potoin? Ak kar pakpak uriris atonuk aparau potoin ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ak owo pote aparin? Ak kar ro omjo eposek mer amke rawon pote aparin ra? Kiro roat ak omjo eposek orip ak osap sosop orip pak ak mena ou eposek opok raiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ak is airowe, ak owo aparau potoin? Anut nukan ämän roianik, ariäwon ro kar ra? Kiro epar senes. Is epar awarom ko Anut nukan ämän roianik, ariäu ro. Kos karauk Anut nukan ämän roianik, ariai roat itimware rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Jon kiro ro meter Anut nukan ämän nukas äiewon, ‘Anut nukas äiewon “Is isan ämän oi areäun ro äsimorta, amke koi, nan apu tuku sare musai.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Is ak epar senes awarom, Jon nukas okoro omnokou pakan roasiret erekapu itimware rau. Utianik, inok ro ko Anut nukan amuk opok enip jou wäpik, kos äiäu, ‘Anut isan kamoireäu ro näwäu, is ko inkaruru raim’ kiro ros Jon itimori rau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Roasiret erekapu kiro ämän roumoi, karauk roasiret pak karauk takis aiauk oiäi roat pak akas äiein, “Epar Anut nukan onok tuku eposek.” Meter, ak Jon nukas an jomarowon, okon, ak keser äiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Parisi roat pak sintore ämän tamareäi roat pak ak Anut nukan onok eposek tainorau utiäi. Keseria, Jon nukas an jomaraun awaronuk, utoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisas nukas roasiret awarowon, “Is rusapaian roasiret owo senek äiäm? Is akan onok owo senek äiäm? ");
INSERT INTO bbr2013_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ak mokoit eteinanak akas om sorik opok tane raumana, karauk mokoit pak sipiräiäun keser urwareäi, ‘Ik asir oiäin parau urumun, utianik, ak karäu wa.’ ‘Ik op meieäin sir wemun, utianik, ak waiäu wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","An jomareäwon ro, Jon pemara, karauk omre opok, ko o pak wain an pak wa jeäwon. Kesernuk, akas aurin, ‘Jon ko osou aru orip,’ äiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ro Nukan Mokoi koumara, ko wain an o pak jenuk, akas äiein, ‘Okoro ro aparwe, ko po senek o sosop jeäu. Ko aiauk oiäi roat pak onok aru miäi roat pak o jeäu.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Anut nukan Osou Näu oin roasiret ak epar kiro Anut nukan ronkat eposek äpu maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Kar Parisi ro nukas Jisas kon owa o jaun imäi potowon. Jisas ko kiro owa poteanik, o jaun tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kiro mena kar asir ko onok aru orip raiäwon. Kos Jisas Parisi ro nukan owa o jera ämän roumara, ko kar botol eposek uer sou eposek päun oumara, kowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Kiro asir pemara, Jisas siakup tai raumara, wai rawon. Kon amuk urokus Jisas nukan isou opok nowon. Keseria, kon tapau urik rumukäus kiro amuk urok Jisas nukan isou opok tätäi kuremara, kon isou oktokormara, kiro uer oianik, Jisas nukan isou opok kourwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kesernuk, kiro Parisi ro kiro aparmara, ronkatewon, ‘Okoro ro ko Anut nukan ämän roianik, areawon ro maro, ko äpu mai, kiro asir inokos ko atou. Ko äpu mai kiro asir ko apu pakan asir.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisas nukas kiro Parisi ro nukan ronkat äpu momara, äiewon, “Saimon, is kar ämän aisaurim.” Saimon nukas ätäi Jisas auruwon, “Näwäu nan ämän airota, rowam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisas nukas keser auruwon, “Ro oirori au poteanik, kar ro opok aiauk oianik, auririn ‘Nan aiauk amuk tawa ätäi isamur.’ Kar ro ko aiauk 500 orip owon, kar ros nais keseriar ko aiauk 50 orip owon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Au ätäi kon aiauk nurau senek wa, okon, kiro aiauk atowon ros awatowon, ‘Au kiro aiauk mesin wa ronkatäu, is erar atom.’ Kiro roat oirori, inokos kiro ro mesin wous näwäu meiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimon nukas ätäi keser äiewon, “Isan ronkat kiro ro ko aiauk sosop 500 orip owon.” Jisas nukas ätäi Saimon auruwon, “Na kiro ämän epar senes äiem.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Keseria, Jisas nukas kiro asir rawon pakaima pirirmara, Saimon auruwon, “Na okoro asir amunas aparum ra? Is nan owa pemin, na isan isi an kosoraun an irau wa, utianik, okoro asir ko amuk urokus isan isi an kosorianik, kon tapau urikus tätämuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","46","Na is nan owa imäiri pemon na is oktokoirau wa, okoro asires is peita, kos isan isi oktokormara, utoirau wa. Na uer isan tapi opok kourau wa, utianik, okoro asires isan isi uer sou eposekus erekapu jomurowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Keseria, rusapai is aisom, kon onok aru sosop miäu, isas kon onok aru erekapu jäkäi murim. Owon, kon wou isanun meiewon. Utianik, inok ro ko onok aru eteinak mowon, isas kon onok aru jäkäi murimin. Kos isanun wou uru eteinak meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Keseria, Jisas nukas kiro apu pakan asir auruwon, “Isas nan onok aru erekapu jäkäi musom.” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Karauk roat ak erek ko pak o je rain kiro ämän roumana, aka aka arein, “Okoro ro inok, ko onok aru jäkäi maraun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jisas nukas kiro asir auruwon, “Nan won is mesin epar momon, okon, na ätäi eposek saremon. Keseria, rusapai nan won päurar orip man.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kar omre opok, Jisas ko kon tamareäu roat 12 orip ak näu mena pak mena eteinanak pak poteanik, Anut nukan ämän roasiret maroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kiro ses opok, osou aru karauk asiret akan woiaka uru rau Jisas nukas oi kurwarowon. Kar asir kon enip Maria ko Magdala menan Jisas nukas osou aru 7 orip oi kure muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Kar ro kon enip Kusa, ko Herot nukan ou kameäwon ro. Herot ko kiro omsau kameäwon ro näwäu. Kiro ro nukan asir kon enip Jona pak kar asir enip Susana pak karauk asiret pak ak Jisas kon tamareäu roat pak tainwareanik, manoin. Kiro asiret akas akan aiauk pak osap pak oianik, Jisas kon tamareäu roat pak sarware manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","5","Roasiret mena atap atap pakan Jisas siakup koin erekapu koi tururna, Jisas nukas kar totok ämän awarowon, “Kar ro o uku kuräun kon woia potowon. Karauk o uku apu opok noin. Kesernuk, roat akas taiein, ai rautes pe oi jein. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Karauk o uku aiauk opok noin. Kiro o uku tu pein. Kiro omnokou an wäpik. Keseria, kiro o uku tu pemara, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Karauk o uku amurik katuau sop uru neanik, tu pein. Katuaus oi jenuk, jekur taiäun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Karauk o uku omnokou eposek opok noin. Kiro o uku omnokou eposek opok noin, kiro o uku eposek tu pein. Tu peanik, ak näu sosop murin, karauk näu 100 orip murin.” Jisas keser äiemara, roasiret awarowon, “Roasiret ak raiaka orip raroi, ak kiro totok ämän roianik, onoktapau äpu maiei!” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Jisas nukan tamareäu roat akas kiro totok ämän onoktapau owo senek rai totorin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Kos ätäi awarowon, “Anut nukas roasiret kamwaraun onok meter ämäi rawon. Rusapai ak isan tamareäim roat, okon, kiro onoktapau ätär marom. Karauk roasiret ak totok* ämän karar roiäi. Keseria, ak amiakas apariäi apariäi, sinuk, jekur wa apariäi. Ak ämän raiakas roiäi roiäi, sinuk, onoktapau äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jisas nukas keser äiewon, “Kiro totok ämän kon onoktapau kesek: Kiro o uku, kiro Anut nukan ämän. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Karauk o uku apu opok noin, kiro kesek, roasiret ak Anut nukan ämän roin, rouna, Satan nukas peanik, akan woiaka uruan ämän oi manowon. Kon ronkat, ko kesernuk, ak woiaka epar wa mona, Anut nukas ak ätäi wa imwarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Karauk o uku ai marmar opok noin, kiro kesek, roasiret ämän roin, roianik, nepipirin. O uku kinip omnokou uru nau wa. Kon onoktapau kesek, akan woiaka epar moin, kiro eteinak. Atonwaraun ses opok, ak Anut nukan ämän utaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Karauk o uku amurik katuau sop uru noin, kiro kesek, roasiret ämän roin, roianik, ari ari poteanik, usu atap atap oianik, woiaka aru mona ra, omnokou pakan osap pak omnokou pakan onok pak aparianik, nepipirmana ra, Anut nukan ämän tamkäswareäi. Keseria, kiro o uku eposek sarau wa. Wa. Ak Anut nukan ämän erekapu utoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Kiro o uku omnokou eposek opok noin, kiro kon onoktapau kesek, roasiret ämän roianik, sakau atoin, akan woiaka epar sarein. Ak sakau raiäi. Kiro keseriar, ak o uku muriäu senek sosop muriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Jisas nukas ätäi äiewon, “Kar ros arou aioimara, baket uru ra, patan inkaruru wa miäu. Ko arou aioianik, kämioik äsäi monuk, karauk roat owa pemana, kiro arou apariäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Owo osap akan woiaka uru ämäi rau erekapu amop päi. Owo osap roat akas kururur miäi erekapu arou merek opok penuk, roat aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ak jekur rainai, ämän rowe. Utianik, kar ro ko karauk ronkat eposek orip, kiro ro Anut nukas karauk ronkat eposek nurai. Utianik, inok ro ko ronkat eposek wäpik, utianik, kon ronkatis isaka ronkat eposek orip äiäu, Anut nukas kon ronkat eteinak ate rau kiro erekapu ätäi senri owai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kiro ses opok, Jisas nukan anak amakut pak Jisas aparau koin. Kiro opok roasiret sosop turur rain, okon, ak Jisas siakup tonau senek wa. Keseria, ak ou rorokpai tai rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Karauk roat akas apwaromana, pote, Jisas aurin, “Nan anin amunat pak na apaisau koin, kasik en tai rai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kiro keser aurna, Jisas nukas ätäi kiro roasiret awarowon, “Inok roasiret ak Anut nukan ronkat tainoriäi, kiro roasiret ak epar isan ani amaiat.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kar omre opok Jisas ko kon tamareäu roat pak ous eteinak opok tonea, awarowon, “Ik karaima aisen potau.” Awaronuk, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Kamuk potona potona, Jisas ko ninowon. Ninonuk ninonuk, urir näwäu pemara, kiro ous anas oi jauruwon. Kesernuk, roat erekapu iminein. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jisas nukan tamareäu roat akas potomana, Jisas turarianik, aurin, “Näwäu, ik anas oike jauru.” Kos siräianik, kiro urir an pak kewatonuk, päurar rairin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Kos ätäi kon tamareäu roat awarowon, “Akan woiaka epar moin esewon?” Ak iminemoi, ronkat sosop oianik, äiein, “Okoro owo ro? Kos urir pak an pak awatonuk, au kon ämän roumoi, tainorir.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Kiro keser kureanik, Jisas nuka pak kon tamareäu roat pak kiro ous pakas Gadara mena, Galili provins karaima potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Ous pote kasakupai pote sumonuk, Jisas pitikänir nowon. Kiro mena kar ro ko osou aru orip rawon. Ko Jisas siakup pewon. Ko om ses rumukäu, ko omjo wa takeäu ko pirim raiäu. Ko owa wa niniäu. Wäpik, ko op up kureäin omoi niniäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Kiro ros Jisas aparmara, piormara, koi Jisas nukan isou siakup uou sur wewon. Kos sakau urwemara, Jisas auruwon, “Jisas, na Anut kämioik rau nukan mokoi. Na is owoseiraurum? Is Anut nukan enip sakau ateanik, aisom, na is usu wa irau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ko keser auruwon, owon, meter Jisas nukas kiro osou aru kiro ro opok man auruwon. Keseria, kiro osou aru nukas piorwon. Orip orip kiro osou aru nukas kiro ro wou uru raiäu. Karauk roat akas kiro ro orip orip kame raiäi. Ak ko mur sen oripas isou ipou rakir miäi. Kos mur sakau pak sen pak pitpatir kureäwon. Kiro osou aru nukas kiro ro imäianik, ro wäpik mena miäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas nukas totorwon, “Nan enmat inok?” Kos ätäi auruwon, “Isan enim Sosop.” Kiro owon, osou aru sosop kiro ro nukan wou uru rai. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Keseria, kiro osou aru akas Jisas aurin, “Ik ep näwäu opok wa äsimoikau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Karauk poat sosop omtorou karaima o je rain. Keseria, kiro osou aru akas Jisas sakau ämän aurin, “Ik utoikota, kiro poat rai akan woiaka uru nam.” Keser aurna, Jisas nukas awarowon, “Itok, ak manowe!” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Keser awaronuk, kiro osou aru akas kiro ro utomoi, kiro poat akan woiaka uru tonoin. Kiro po raut ak kurte potea, om aru opokas pitikänäir noin. Ak neanik, an unik uru neanik, an jemana, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Kesernuk, po kamwareäi roat ak kiro onok aparmana, kurte imine manoin. Ak poteanik, kiro ämän kiro mena pak omsau pak erekapu awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kiro pakan roasiret ak kiro ämän roumana, ak koi Jisas siakup koianik, kiro ro osou aru oi kure muruwon aparin. Ak kiro ro ko ronkat eposek orip omjo takemara, Jisas nukan isou siakup tane raunuk, aparin. Aparianik, roasiret ak iminein. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kiro roat ak Jisas nukas kiro ro jekurwon aparia, akas karauk roat äpu wa rain, kiro onok keserwon erekapu pote awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Keseria, kiro omnokou Gerasa mena siakup kiro pakan roasiret akas Jisas aurin, “Na ik utoikonam, man.” Ak iminemana, Jisas keser aurin. Keseria, Jisas kon tamareäu roat pak ous oik toneanik, akan mena ätäi manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","39","Kiro ro ko meter osou aru orip rawon eposek sarewon, kos potomara, Jisas sakau auruwon, “Näwäu, is na pak manam, na is ior airam ra?” Utianik, Jisas nukas ätäi kiro ro auruwon, “Na nan mena potoinam, Anut nukas okoro onok na opok keserwon pote roasiret awar.” Keser aurnuk, kiro ro ko kon mena potomara, Jisas nukas kon osou aru oi kure muruwon kon menan roasiret erekapu awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisas kon tamareäu roat pak ätäi karaima kouna, roasiret ak kouna, apwareanik, ak nepipirin. Owon ak Jisas kon tamareäu roat pak ak kamware rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Kar ro kon enip Jairas, ko Juda akan tururiäi ou kumeäwon ro kar. Kos Jisas nukan isou siakup pemara, uou sur wemoi, Jisas kon owa potaun auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Owon, kon asinak karar kon woisan 12 orip ko meiäuru. Jisas kiro ro tainori potonuk potonuk, roasiret sosop erekapu karaima karaima tainori potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Kiro kamuk kar asir ko keir sip orip orip oiäu, pote kiro sip nukan woisan 12 orip rawon. Kar ros ko jekur mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Kiro asir ko Jisas siakup pemara, Jisas nukan omjo peteu atonuk, ko sip aru utowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisas nukas roasiret totwarowon, “Inokos is kotomairou?” Roasiret akas äiein, “Ik äpu wa.” Pita nukas auruwon, “Näwäu, roasiret sosop na siatap raianik, nan omjo kotomari.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisas nukas äiewon, “Kar ro kos is kotomairowon. Is äpu, owon, isan karauk sakau manowon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Kiro asir kiro onok keserwon ämäi mau senek warnuk, roasiret amiakap pemara, Jisas nukan isou siakup uou sur wewon. Kiro asires kon ämän erekapu Jisas auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisas nukas kiro asir auruwon, “Asinak, nan won epar momon, okon, nan sip manonuk, nan won päurar orip man.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisas ko kiro asir aurnuk aurnuk, kar ro Jairas nukan owas koumara, Jairas auruwon, “Jairas, nan asinak meiewon, na tamareäu ro sarau wa mur.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisas nukas kiro ämän roumara, Jairas auruwon, “Na wa iminäu. Nan won epar mo. Kiro asinak rau, ko meiäu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisas ko kiro ron owa poteanik, Pita, Jon, Jems pak kiro asinakun momok anak ori karar imware tonowon. Kos karauk roasiret tämaronuk, ak kasik rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kiro pakan roasiret ak kiro asinakun woiakati maronuk, wai rain. Jisas nukas awarowon, “Ak owon wai rai? Kiro asinak meiäu wa. Ko nini rau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Keser äienuk, kiro pakan roasiret ak Jisas nukan ämän roianik, ak ioin. Akan ronkat ko erar sätäu rai äiein. Owon, ak äpu kiro asinak meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisas nukas kiro asinakun ipou atomara, urwemoi, auruwon, “Asinak, na sirau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kesernuk, kiro asinak meiewon kon totok ätäi penuk, siräiewon. Jisas nukas kiro asinak o nuruna, jaun awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Kon momok anak ories kiro onok aparia, karkairirin. Utianik, Jisas nukas kiro onok keserwon, karauk roat wa awarau rai sakau awatowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisas nukas kon tamareäu roat 12 orip awaronuk, kouna, ko osou aru oi kuräun pak sip aru jekwaraun pak sakau arowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Keseria, kos Anut nukas roasiret kamwaraun kowai ämän eposek maraun pak sip aru jekwaraun pak äsimwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jisas nukas kon tamareäu roat awarowon, “Ak apu opok potaun kar osap wa owau. Ak naruauk ra, jo ra, karauk o ra, aiauk wa oi manaiei. Omjo nais wa oi manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ak kiro mena potona, kiro pakan roat akas imwarona, kiro roat akan owa karar rainai, Anut nukan ämän roasiret marowe. Anut nukan ämän awaroinai, ätäi kiro owa karar koi rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Karauk roat akas akan ämän rowau utomoi, jekur wa kamwarona rai, ak kiro mena utoinai, akan onok aru ätär maraun akan isiaka pakan maimai putarwe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kiro tamareäu roat kiro mena utia, mena atap atap erekapu potoin. Anut nukan Ämän Eposek mare mare, roasiret sip orip jekware mare mare, mena atap atap erek iporin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Kiro ses opok, Herot ko Galili provins kamwareäwon ro, kiro onok atap atap Jisas nukas keserwon aurin roumara, ko ronkat sosop owon. Owon, karauk roat akas äiein, “Kiro an jomariäwon ro Jon, ko meiewon ätäi up uruas siräi pewon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","9","Karauk roat akas ronkateanik, äiein, Elaija ätäi sirawon. Karauk akas äiein, kar meteran Anut nukan ämän roianik, areawon ro ätäi siräiewon, Keseria, Herot nukas äiewon, “Is Jon nukan pou patir kuremin, kiro inok ro apari?” Herot nukas Jisas aparau manam rai ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jisas nukan ämän oi ariai roat ak mena atap atap Anut nukan ämän oi arianik, ätäi koin. Akas Jisas owo osap keserin erekapu aurin. Jisas nukas imware pote, akararnak kar mena enip Betsaida, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Roasiret sosop akas ak kiro opok potoin roianik, tainware potoin. Kos potomara, roasiret Anut nukas kamwaraun koura ämän awaromara, karauk roasiret ui aru orip pak sip orip pak jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Iukärir sarenuk, Jisas nukan tamareäu roat akas Jisas siakup poteanik, keser aurin, “Näwäu, okoro roasiret äsimwarota, manaiei, ak mena siakup poteanik, o kau mianik, je je akan mena manaurai, Owon, okoro mena ro wäpik.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jisas nukas ätäi awarowon, “Akasar o jaun araiei.” Akas ätäi äiein, “O sosop wa. Ik bret 5 orip pak was oirori karar rau. Nan ronkat ik mena potomoi, o karauk roat sosop akan kau marau ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Kiro roat ak 5,000 orip. Keseria, Jisas nukas kon tamareäu roat awarowon, “Kiro roasiret ak 50 orip sarpeter marona, tane potaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kon tamareäu roat akas kon ämän tainorianik, keserin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jisas nukas kiro bret 5 orip pak kiro was oirori pak oumara, omar oik eisane aparmara, Anut ‘pere’ aurmoi, pärärmara, kon tamareäu roat akas roasiret inäi araun arowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kiro roasiret erekapu kiro o jeanik, ak nokomaka penuk, Jisas nukan tamareäu roat akas basket 12 orip oumana, roasiret akas o jein o autakau utoin joke moin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kar omre Jisas ko nukarar Anut auri rawon, kon tamareäu roat ko siakup potona, Jisas nukas totwarowon, “Roasiret akas is inok äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","20","Akas ätäi aurin, “Karauk roasiret akas keser äiäi, ‘Ko an jomareäwon ro, Jon.’ Karauk roasiret akas keser äiäi, ‘Ko Elaija.’ Karauk roasiret akas äiäi, ‘Ko Anut nukan ämän roianik, areawon ro kar meiewon ätäi siräiewon.’” Keser aurna, Jisas nukas kon tamareäu roat totwarowon, “Akas is inok äiäi?” Pita nukas äiewon, “Na Krais, Anut nukan Mokoi senes. Ik ätäi imäikaun kos na äsimoisonuk, koumon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Keseria, Jisas nukas kon tamareäu roat sakau ämän kiro karauk roasiret wa awarau rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kos ätäi kon tamareäu roat awarowon, “Is, Ro Nukan Mokoi, tätäi sosop oita, Juda roat näunäu pak Anut kamuk raiäi roat pak sintore ämän tamareäi roat pak erek akas isan ämän rowau utomoi, sumkäinäiei. Akas is iworona, meiäm. Utianik, omre 3 opok, Anut nukas is ätäi siräi murai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Kos roat erekapu awarowon, “Inok roasir is tainoire päun ko nuka mesin wa ronkatäu, omre orip orip nukasar kon am äpäs ämäumara, is tainoirai. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Inok ro ko kon totok awau rawaun ronkateäu kiro kon totok aru mai. Utianik, inok ro kon totok isanun meiäi, kiro ro kon totok orip orip jekur eposek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Kar ro omnokoupaian osap erekapu oumara, ko meiäi, kiro osapus nukan totok awau rawaun owose saräi? Kiro osapus ko wa isanarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Owo ro is tainoraun iminäi, kos is äpu wa äianik, isan ämän ämäi mai, is, Ro Nukan Mokoi, tawa isan arou näwäu pak monian arou pak sarau eitek eposek akan arou pak kiro uruas koita, isas nais äiäm, ‘Is kiro ro äpu wa’. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Is ak epar senes awarom, karauk roat ak okoro omnokou opok rai, karauk wa meiäiei, utianik, ak rauna raunar, Anut nukan kamwaraun onok amop päi aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jisas kiro ämän erekapu kon tamareäu roat aware kuremara, omre 8 orip manonuk, kos Pita, pak Jon Jems ori pak imwaromara, omtorou oik Anut auraun tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jisas nukas Anut aurnuk aurnuk, kon nepu piririanik, kar ro senek etäiwon. Kon omjo ärneu senes sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Keserianik, kurte kar ro oirori peanik, Jisas pak erek are rairin. Kiro roat ori Moses Elaija ori. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Au omar oikas Anut nukan arou näwäu opokas koianik, au Jisas pak are rairin. Kiro Anut nukan ronkat rusapai ko Jerusalem mena toneanik, meiäun keser arein. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita kon jaukut ori pak ak erekapu ninoin, ätäi siräianik, Jisas nukan arou näwäu pak kiro ro oirori ko pak tai rain apwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kiro roat ori Jisas ute omar oik manoisa manoisa, Pita nukas Jisas auruwon, “Näwäu, ik okoro opok rawaun eposek. Nas äuta, ik okoro opok ou 3 orip mam. Kar nan, kar Moses nukan, kar Elaija nukan.” Pita jekur ronkateanik, ko aräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ko keser are raunuk raunuk, ious koumara, kururur marowon. Kiro tamareäu roat 3 orip ak imine rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Iou uruas kar oksaus keser äiewon, “Kiro isakan mokoi senes. Kiro isakasar äsimorimin. Ak kon ämän jekur rowe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kiro oksau äiewon utonuk, Jisas nukarar rawon. Jisas nukan tamareäu roat ak aräu wa. Ak ronkat sosop momoi, asor rain. Jisas nukas kon tamareäu roat keser awarowon, ak kiro onok rusapai apari karauk roasiret wa awarau rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kiro ninoinus, tapera, Jisas nuka pak kiro roat 3 orip Jisas tainori manoin. Omtorou oikas utomoi, kouna, roasiret sosop akas apwarea, koi tarwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kar ro kiro roasiret kamuk rawon urwemara, äiewon, “Näwäu is na aisom, isan mokoi karar, okon, na aparaun aisom. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Osou aru ko opok raianik, piormara, kirekirerianik, pote, au sipar kurariäu. Kiro osou aru ko utau senek wa, okon, kon enipsau aru sareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Is nan tamareäum roat kiro osou aru oikurewe awaromin ak oikuräu senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisas nukas roasiret kewareanik, ätäi awarowon, “Ak rusapaian roasiret, akan ronkat owo senek ak woiaka epar mau senek wa, ak tapiaka sakau miäi. Is ak pak ekep wa rawam.” Keser awareanik, Jisas nukas kiro ro auruwon, “Nan mokoi okoro opok imäi koi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kiro mokoi kounuk kounuk, kiro osou aru nukas kiro mokoi suor känkurenuk, Jisas nukas kiro osou aru kiro mokoi ute manaun kakurarwon. Kiro osou aru ute manonuk, kiro mokoi jekur mianik, kon momok ätäi nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Roasiret ak erek turur rain Anut nukan sakau aparianik, ak karkairin. Roasiret ak Jisas nukas kiro kurur keserwon aparianik, ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Keseria, Jisas nukas kon tamareäu roat awarowon, “Ak isan ämän rusapai awarom wa känkuräu. Is Ro Nukan Mokoi sakatoirianik, roat akan ipiak opok muraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jisas nukas kiro ämän awarowon, kon tamareäu roat ak kiro ämän onoktapau äpu wa. Keseria, ak iminemoi, ko totorau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Jisas nukan tamareäu roat ak aka aka ketäianik, äiein, “Ik kamuk inok ro näwäu rau?” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","48","Jisas nukas ak ronkatein äpu momara, kar mokoi eteinak imäiemara, nuka siakup tai momara, kos awarowon, “Inok ro kos isanun ronkatemara, okoro mokoi imäianik, jekur kamäi, ko is pakur erek imäirai. Inok ros is imäirai, ko kiro ro is äsimoirnuk, koimin ko nais erek imäiäi. Inok ro ko rusa ak kamuk opok enip näwäu wa, kiro ro ko näwäu saräi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon nukas Jisas auruwon, “Näwäu, ik kar ros nan enmat opokas osou aru oi kurenuk, aparmun. Ik kiro onok wa keserau rai aurumun, owon, ko iken jaunok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisas nukas auruwon, “Ak ko wa tämurau, owon, inok ro ko akan iwäi jaunaka wa, kiro akan jaunaka.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisas ko okoro omnokou utomara, omar oik tonaun omre katu sarenuk, äpu momara, Jerusalem mena tonaun ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Keseria, kon karauk tamareäu roat amke äsimwaronuk, pote kar Samaria mena siakup kon ninaun om jekur maun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kiro Juda akan tup Näwäu aparaun ses opok Jisas ko kiro opok potaun kowon. Kesernuk, kiro pakan roat akas Jisas imäiäu utoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kon tamareäu ro oirori Jems Jon ori au kiro ämän roianik, äieirin, “Näwäu, ik Anut aurta, omar oikan ep urweta, koi okoro menan roat erekapu koi jerwaraun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jisas nukas ätäi piririanik, kewatowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Keseria, ko kon tamareäu roat pak kar mena manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Jisas kon tamareäu roat pak Jerusalem mena potona potona, kar ros Jisas auruwon, “Na erapok manam is na pak erek tainoise manam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisas nukas ätäi auruwon, “Kurukan opur sei raut ak ninaun ou orip, ai raut ak ninaun tou orip, utianik, Ro Nukan Mokoi ko ninaun omoi wäpik.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisas nukas kar ro auruwon, “Na tainoir.” Kiro ros ätäi ko auruwon, “Näwäu, is utoirota, pote isan moni up kureita, ätäi koi na tainoise manam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jisas nukas auruwon, “Meiein roat akasar akan jaunakat meiein up kurwaraiei. Na potoinam, Anut nukas okoro omnokou erekapu kamwaraun koura, kiro ämän eposek roasiret pote awar.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kar ros Jisas auruwon, “Is isan tupsiu pote ‘pere’ awaroita, ätäi koita, na tainoisam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisas nukas ätäi kiro ro auruwon, “Inok ro ko apu tuku sare manai, ätäi mäine rai, ko apu tuku senes wa sare manai. Kesek ro ko Anut nukas kamwareäu roasiret kamuk opok sarau ro eposek wa rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jisas nukas roat 72 orip sare maromara, ro oirori oirori amke mena atap atap Jisas nuka potaun opok äsimwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kos kiro roat keser awarowon, “Kiro woia o sosop ariaun itok sare rau, utianik, kiro woia o ariaun sarau roat sosop wa. Ak kiro woi atak ro ko aurna, kos karauk sarau roat äsimwaronuk, akas pote kiro o turur maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Potowe, is ak sipsip senek enat aru opok äsimwarom. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ak akan jo pak, aiauk bek pak, su pak wa oi manau. Ak apu kamuk karauk roat tarwaroinai, ak wa are marau. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ak karauk roat akan owa tonaun erar wa tonaiei, amke tonaun ‘Anut ak pak rau,’ rai awaroinai, owa tonowe. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Kiro owan ros ak imwareanik, eposek kamwaronuk, akan jekur rawaun ämän kiro ro pak rawai. Utianik, inok ro ko ak kon owa wa imware tononuk, akan jekur rawaun ämän ko pak wa rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Inok roat akas ak akan owa rawaun imwaraiei, ak kiro owa karar rawaiei. Ak kiro owan owo o pak an pak arona, jewe. Owon, kiro sarau roat akan sarau moin ak osap owaiei. Ak karauk owa wa potau, kiro owa karar rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Ak näu mena potona, inok ros ak kon owa imware tone, o aronuk, jeie. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Kiro mena roasiret sip orip jekur maroinai, kiro pakan roasiret keser awarowe, ‘Anut, okoro omnokou pakan kamwaraun ro näwäu ak siarakap peu.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","11","Utianik, ak kar mena potona, kiro pakan roasiret akas ak wa imwarona rai, ak apu kamuk potoinai, awarowe, ‘Ak akan mena maimai iken isiok opok rau utarta, akan mena ätäi nai, kiro ak äpu maiei akan onok eposek wa.’ Is ak epar awarom, Anut nukas roasiret kamwaraun omre siarakap pe rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Is ak epar senes awarom, okoro omnokou wasarewaraun ses opok roasiret Sodom mena meter onok aru me rain epis kiro mena jerwarowon, kiro pakan roasiret ak tätäi äiäknak owaiei, kiro menan roasiret rusapai rai ak isan ämän roumoi, wa tainoriäi ak tawa tätäi näwäu senes owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jisas nukas ätäi awarowon, “Korasin roasiret, is ak apware woiti mou. Betsaidar roasiret, ak nais apware woiti mou. Is kiro kurur näwäu atap atap Taia menan roasiret pak Saidon menan roasiret pak ak kiro kurur ätär maromin senek maro, kiro Airen roasiret ak woiaka aru monuk, kurte omjo sirop takeanik, aitap opok tane rawoi. Kiro onok keserin kiro akan onok aru pakan ätäi woiaka piririn! ");
INSERT INTO bbr2013_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Is ak epar senes awarom, tawa Anut nukas ätäi koi roasiret wasarewaraun ses opok Taia pak Saidon roasiret pak ak usu äiäknak owaiei, utianik, rusapaian roasiret ak usu näwäu senes owaiei! ");
INSERT INTO bbr2013_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ak Kapaneam roasiret, ak akasar omar oik tonaiei ra? Epar senes, ak wa tonaiei. Anut nukas ak up uru ep näwäu opok känkurwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jisas nukas kon tamareäu roat awarowon, “Inok roasiret akas akan ämän rowaiei, kiro ak isan ämän nais rowaiei. Inok roasiret akas akan ämän rowau utaiei, kiro ak isan ämän nais wa rowaiei. Inok roasir isan ämän roianik, tainorau utai, kiro ro inokos is äsimornuk, koimin kon ämän nais wa tainorai. Jisas nukas kiro ämän awaromara, äsimwaronuk, manoin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kiro tamareäu roat 72 orip ätäi akan woiaka ererwon orip koianik, Jisas aurin, “Näwäu, ikes nan enmat pakas roasiret osou aru orip rain awarota, kiro osou aru iken ämän roumana, ute manoin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisas nukas ätäi awarowon, “Is apari raita, Satan ko omar oikas ermäniriäu senek nowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ak rowe, isan sakau ak aromin. Män aru rek ori opok ak ariaun itok. Akas ak wa tukwaraiei. Satan iken iwäi jaunok nukan sakau erekapu itimoraun sakau is ak aromin. Kar osapus ak aru wa maraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Utianik, osou aru akan ämän tainorin mesin ak wa nepipirau. Anut nukas akan enmak omar oik jer we mowon mesin ak nepipirwe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Kiro omre opok Jisas ko Osou Näu orip kon wou erermara, äiewon, “Moni, na karar omar pak omnokou pak akan Näwäu, is nan enmat jou mom, owon, na nan onok eposek äpu miäin roasiret pak skul manoin roasiret pak akan amiakap ämäi maromon. Utianik, na kiro onok eposek äpu wa roasiret erekapu ätär maromon. Moni kiro onok epar nakasar nan ronkatis kesermon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Isan Monias osap erekapu isan ipi opok mowon. Kar ros kon Mokoi äpu wa miäu, Momok nuka karar äpu. Kar ros kiro Mokoin Momok äpu mau senek wa, kon Mokois karar Momok äpu. Kiro Mokois roasiret nukasar nukan sare mareanik, kon Momok ätär maronuk, ak nais ko äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Keseria, Jisas nukas pirirmara, kon tamareäu roat ämän ämäi keser awarowon, “Ak osap akan amiakas apari akan woiaka erer orip rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Is epar senes ak awarom, meter Anut nukan ämän roianik, areain roat pak omsau kamwareäin roat sosop pak ak kiro osap ak rusapai apari senek aparaun rai keserin, ak aparau wa. Ämän rusapai ak roi senek meteran roat ak rowam rai keserin, ak rowau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kar sintore ämän tamareäu ro ko Jisas ate aparaun pemara, Jisas keser auruwon, “Ro Näwäu, Is owosemoi, totom awau orip orip rawaun owam?” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisas nukas ätäi kiro ro auruwon, “Akan sintore ämän buk opok owo jer wein, akan ronkat kiro ämän onoktapau owo senek?” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Kiro ros Jisas ätäi auruwon, “Na nan wonas pak nan totomatas pak nan ronkatis pak nan sakaus pak nan Näwäu, Anut nukanun erekapu meie. Na nakanun meieäum senek, nan jaunan keseriar meie.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisas nukas äiewon, “Kiro epar senes na kiro keseram, na orip orip rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kiro ro ko nukasar nukan enip jou mam rai, ko pemara, Jisas ätäi totorwon, “Sintore ämänis isan jai inok mesin äieu?” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisas nukas ätäi auruwon, “Kar ro ko Jerusalem menas Jeriko mena nowon. Kiro apu kamuk karauk päu roat akas weanik, aru murianik, kon osap erekapu oianik, ute manoin. Kiro ro eparar meiäun rauk ser rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kiro ro wein apu opok nini raunuk raunuk, kar ro Anut kamuk raiäu ro ko nais kiro apu pakas nowon. Ko kiro ro aparmara, imineanik, apu kasakupas manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kiro apu pakar kar Liwai* ro, ko Anut kamuk raiäi roat sarwareäu ro, ko nais kiro apu pakas kowon. Ko nomara, kiro ro apu opok nini rawon aparmara, ko nais apu kasakupas manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Utianik, kar iwäi jauk ko Samaria* menan, ko nais kiro apu pakasar kowon. Ko kiro ro apu opok nini rawon aparmara, wouti näwäu mowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ko kiro ro siakup potomara, am nemauk pakan an pak an wain oumoi, kiro ron ui opok momara, ui laplap sies pararar murianik, kiro ro ämäi oi kon donki opok momara, kar ou kiro apu siakup rau opok imäi potomoi, jekur kame ninowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ninoinus, tapera, kiro Samaria ro nukas aiauk oianik, kiro ou atak ro nurumara, auruwon, ‘Na okoro ro jekur kame rau, nan owo osap okoro ro opok utam, is ätäi koita, na kau musam.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jisas nukas kiro ämän patarmara, kiro sintore ämän tamareäu ro auruwon, “Nan ronkat, kiro roat 3 orip inokos kiro ro päu roat akas wein ko kon jauk senek sarewon?” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Kiro sintore ämän tamareäwon ros Jisas ätäi auruwon, “Kiro ro päu roat akas apu opok wein mesin wouti mowon ro.” Jisas nukas auruwon, “Na potoinam, keseriar keser.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jisas ko kon tamareäu roat pak kiro ämän mare kurea, ko kar mena kounuk, kar asir kon enip Marta, nukas kon owa imäi potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Kon awak enip Maria ko pemara, Jisas siakup tane raumara, Jisas nukan ämän roi rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta ko nukarar sarau momoi, wou aru monuk, koi Jisas auruwon, “Näwäu, is isakarar sarau moram, isan awai aurta, koi is sareirai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jisas nukas ätäi Marta auruwon, “Na sarau momata, osap sosopun ronkat oum. ");
INSERT INTO bbr2013_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Karar onok karar na itimoisi rau. Maria ko kiro onok eposek owaun sare mowon. Kar ros ko kiro pakan wa oi kuräi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kar omre opok, Jisas ko nukarar Anut auri rawon. Ko Anut auri kurenuk, kon kar tamareäu ros auruwon, “Näwäu, Jon ko kon tamareäu roat Anut auraun ätär mareäu, senek, nas nais ik Anut auraun ätär muk.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisas nukas ätäi awarowon, “Ak Anut keser aurwe, Iken Momonek, nan enmat eposek ik jou musiäum. Nan kamoikaun ses okoro omnokou erekapu koi itok mai. Nan onsau omar oik tainoriäi senek, ik nais omnokou pakan erek tainoram. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Omre orip orip ik nas o ikam. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ikes karauk roat akan onok aru ik opok mukiäi jäkäi mareäum senek, nas pak iken onok aru jäkäi muk. Na ik osap ate apaikaun opok wa kureikam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Kos ätäi awarowon, “Utianik, ak kamuk kar ro ko jauk orip raroi, ko kon jaukun owa pututu potomara, aurai, ‘Jai, is o iro. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Isan jai awau ko rusapai kou, ik o erekapu je kuremun, ik ko nuraun o wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Kiro ro ko owas raumara, keser aurai, ‘Is im penemin. Isan mokoit pak ninom. Nas is sarau wa irau. Is siräianik, o isau senek wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Is epar senes awarom, kiro ro owa rauwus siräianik, kon jaukun ronkatäu utou. Ko kon jauk, okon, orip orip totornuk, siräianik, o nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Keseria, is epar senes awarom, ak owo osap owaun Anut aurna, kos osap arai. Ak owo osap itanäiei, ak aparaiei. Ak im ut koukourna, Anut nukas im tue marai. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Inok roasir ko osap owaun Anut aurai, ko osap owai; inok roasir osap itanäi, ko aparai; inok roasir ko Anut nukan im ut koukourai, ko Anut nukas imtue murunuk, owa tonai. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Kar ron mokois momok aurai, ‘Moni, is was jam,’ aurnuk, momokus kar män aru oi nuriäu ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Utianik, kon mokois ‘Moni, is kakarau wawak jam,’ aurnuk, momokus on oi nuriäu ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ak roat onok aru orip, akas akan mokoit o eposek araun äpu miäi. Iken momonok omar oik rau, ko onok eposek orip, akas ko Osou Näu araun aurna, kos ak arai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kiro ses opok Jisas nukas kar ro osou aru orip ok utup rawon jekur mowon. Kiro osou aru manonuk, kiro ro ätäi arewon. Roasiret kiro opok turur rain ak kiro onok aparianik, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Karauk roat akas äiein, “Kiro Bielsebul ko karauk eitek aru kamwareäu kos Jisas sakau nurunuk, osou aru oi kurwareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Karauk roat akas ko ate aparaun kos kurur atap atap kesernuk, aparaun aurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisas nukas akan ronkat äpu momara, awarowon, “Karar omsau, ak aka aka weräianik, aka aka inäiaiei, ak ekep wa rawaiei. Ak erekapu aru maiei. Karar tupsiu ak aka aka weräianik, aka aka inäiäiei, ak jekur wa rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Utianik, Satan nukan kin karar aka aka weräianik, aka aka inäiäiei, ak owose sakau rawaiei? Akas is Bielsebul nukan sakau pakas osou aru oi kurwaroram airiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Utianik, is Bielsebul nukan sakau pakas osou aru oi kurwaroram rai, inokos akan mokoit osou aru oi kurwaraun sakau ariäu? Akan mokoit akasar kiro onok wasarewaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Epar senes wa, is kiro Anut nukan sakaus osou aru oi kurwariäim. Kiro epar äpu maiei, Anut nukan kamwaraun ses ak siarakap rusapai koi rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Rowe. Kar ro ko sakau orip ko muk puri pak atomara, kon ou kamenuk, kiro kon osap wa päu owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Utianik, kar ro ko sakau näwäu senes orip pemara, kiro ro wenuk, kos kiro ron muk puri pak senri oumara, kon osap erekapu oumara, karauk roat inäi arai. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Inok roasir isan jai wa, ko isan iwäi jai. Inok roasir is sareirianik, karauk roat is siarap imware kowau wa, ko roasiret emwaronuk, mane kureäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Jisas nukas ätäi äiewon, “Osou aru ro opiakapan oi kurena, ko potea, ro wäpik mena sume rawaun omoi itanäi. Ko pote sumaun omoi warnuk, ko keser äiäi, ‘Is ätäi isan mustäi owa potam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Keseria, ko ätäi pote kiro ou om kasar jekur moin, erar rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aparianik, ko pote karauk osou aru 7 orip akan onok aru senes orip imwareanik, ätäi kiro owa erek rawaun koin. Keseria, kiro osou aru rautes kiro ro opok onok aru senes mona, meter kiro ro ko aru raiäu, rusapai ko erekapu aru senes rau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisas nukas roasiret turur rain opok kiro ämän mare kurenuk, kar asires kiro kamuk raianik, kakurarmara, auruwon, “Kiro asir inokos naka musomara, kameisowon ko epar wou ererai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jisas nukas ätäi äiewon, “Wäpik. Inok roasiret ak Anut nukan ämän erekapu roianik, tainoriäi, ak epar nepipiraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Roasiret koi turur rauna rauna, Jisas nukas awarowon, “Ak rusapaian roasiret ak aru senes. Ak kurur atap atap moita, aparam rai, ronkatein. Is kurur atap atap sosop wa ätär maram. Anut nukan ämän roianik, areäwon ro, Jona nukan kurur karar kiro epar ätär maram. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Meter Anut nukas Jona opok ko kiro kurur Niniwe roasiret ätär marowon senek, rusapai is, Ro Nukan Mokois, kiro kurur rusapaian roasiret karar ätär maram. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Tawa Anut nukas wasarewaraun ses opok, Siba omsau kamwareäwon asir ko meiewon ätäi siräianik, rusapaian roasiret pak koumana, akan onok aru amop marai. Owon, kiro asir ko mena atapukas Solomon nukan ämän eposek rowau kowon. Rusapai is epar senes awarom, kar ro näwäus Solomon itimori rau. Is rusapai okoro raim, utianik, ak nais isan ämän rowau utoi. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tawa, Anut nuka ätäi koi okoro omnokou pakan roasiret wasarewaraun ses opok Niniwa roasiret meiein ätäi siräianik, Anut nukan amuk opok rusapaian roasiret pak erek tai raianik, auraiei, ‘Rusapaian roasiret ak onok aru miäi’. Owon, Niniwa roasiret ak Jona nukas Anut nukan ämän marowon, akan onok aru utomoi, ätäi woiaka piririanik, Anut mesin akan woiaka epar moin. Is ak epar senes awarom, rusa okoro opok kar ro rau ko näwäu, kos Jona itimori rau. Ak kiro ro näwäu nukan ämän rowau utoi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jisas nukas ätäi äiewon, “Roat ak arou aioianik, baket uru ra, ou waru uru wa ämäi miäi. Ak arou aioianik, kämioik äsäi miäi. Keserna, roasiret ak owa tonaun kiro arou merek aparianik, ak owa tonaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Nan amunauk kiro enmatsau pakan arou. Nan amunauk eposek rawai, kiro akan enmaksau arou senek jere rawai. Utianik, nan amunauk aru saräi, nan won uru nais erekapu pututu saräi. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kiro mesin ak jekur rawe, warnuk, kiro arou woiaka uru rau koserai. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Utianik, akan enmaksaun arou eposek orip orip jere rawai, kiro arou owa jereanik, merek kure rau senek.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisas nukas roasiret Anut nukan ämän erekapu mare kurenuk, kar Parisi ros Jisas kon owa o jaun auruwon. Keseria, Jisas ko pak o jaun potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kiro Parisi ros o jaun ses opok Jisas ko Anut nukan amukup eposek saräun kon ipou an kosorau wa, aparianik, karkairwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kesernuk, Jisas nukas kiro ro auruwon, “Ak Parisi roat akan maro kap pak mekesuk opok jekur an kosoriäi, ukun wäpik, utianik, ak onok aru sosop miäi, okon, akan woiaka uru ukun näwäu rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Akan ronkat eposek wa. Ak äpu wa rä? Anut nukas akan woiaka ate mowon, akan enmaksau nais kosar ate mowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ak kiro o akan maro uru rau kiro roat osap wäpik roat arowe. Ak keserna, ak erekapu ukun wäpik saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ak Parisi roat, ak jekur rowe. Ak woian o erekapu näwäu pak eteinak pak 10 orip atap atap inäianik, surwate mianik, karar sur oi Anut nuriäi. Kiro onok eposek kesermana, ak Anut mesin woiaka epar wa miäi. Ak kiro onok eposek pak karauk onok eposek keseraun wa utau. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ak Parisi roat, ak roasiret tururiäi owa ak tanäun omoi eposek oiäi. Ak amket opok roasiret akas karauk roasiret amiakap pere awarona, akan enmaka rororna, aka nepipiriäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Wopurut, ak op up roat akas mer wa amke muriäi senek. Roasiret ak kiro wa apariäi, ak kiro opok tai arina rai, ak ukun orip saräiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Kar sintore ämän tamareäu ros kiro ämän roianik, auruwon, “Näwäu, na kiro ämän äiem, kiro ik nais woiok aru mukou.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Keser aurnuk, Jisas nukas äiewon, “Ak sintore ämän tamareäi roat nais, ak sintore ämän kiro osap usu senek roasiret akan enmaksau opok ämäi mareäi. Utianik, akas kiro usu ämäiaun wa sarwareäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Wopurut. Akas Anut nukan ämän roianik, areain roat akan up opok patan eposek käi miäi. Kiro roat akan askanai akas akwarona, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ak kiro up opok patan eposek käi marona, ak karauk roasiret ätär mareäi, akan ronkat akan askanai akan onok eposek. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Kiro onok Anut nukan ronkat eposek nukas äiewon, ‘Is ak rawa Anut nukan ämän roianik, areai roat pak ämän oi ariai roat pak äsimwaram. Karauk aru maraiei, karauk akwarona, meiäiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Keseria, rusapaian roasiret akas akan askanai akan usu owaiei. Anut nukas ätäi kiro roat akwarona, meiein akanun sarwareanik, akwarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Kiro epar meter roat akas omnokou ate mowon ses opok ak Abel wena, meiewon pote, akas Sekaraia* kos Anut jou muriäin patan pak kon omoi eposek pak kamuk opok wena, meiewon. Akas kiro roasiret eposek erekapu akwarona, meiein. Is epar senes awarom, rusapaian roasiret ak kiro usu erekapu owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Sintore ämän tamareäi roat, wopurut, ak Anut nukan ämän karauk roat opok ämäi miäi. Ak akasar jekur wa tainoriäi. Karauk roat tainori tonam äiäi akasar apu soriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisas ko kiro owa rawon ute kasik nonuk, sintore ämän tamareäi roat pak Parisi roat pak akas ko mekesup sät ämän sosop mianik, totorin. ");
INSERT INTO bbr2013_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Kos ätäi owo äienuk, ko wena, meiäun rai jekur oksau apai rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Jisas ko arenuk arenuk, roasiret sosop tururmana, aka aka suosuotein. Jisas nukas amke kon tamareäu roat awarowon, “Ak Parisi roat akan bret makona, noroiäwon marasin enip jis jekur aparaiei. Ak akan ämän eposek mitu orip roinai, jekur aparwe. Kiro ämän erekapu epar wa, okon, jekur aparwe. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Owon, osap kururur raiäi kiro erekapu amop päi, owo osap ämäi miäi roasiret äpu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Keseria, ak owo ämän pututu, ämäi araiei, amop arou opok rowaiei. Ak owo ämän äiäurar owa im penemoi, araiei kiro ou oikas tone sakau araiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jisas nukas ätäi äiewon, “Isan jaiat, is epar awarom, ak kiro roat, karauk roat akwarona, meiäiei ak wa iminewarau. Tawa, kiro roat akas ak ätäi aru marau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Is ak inok iminäun ätär maram. Ak Anut Näwäu karar iminewe. Ko sakau näwäu orip. Kos ak tawa akwarianik, ep näwäu uru känkurwarai itok. Kiro epar awarom, ak ko karar iminewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Amket opok, ai simnak 5 orip aiauk 2 toia oripas kau miäi. Anut nukas ai karar karar jekur kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Kiro karar wa, ko akan tapiaka urik karar karar erekapu ninarewon rau. Ak wa iminäu, Anut nukan amukup akas kiro ai eteinanak itimware rai. Anut ak kamwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Jisas ätäiar awarowon, “Is epar awarom, inok roasir kos roasiret omnokou opok, ‘is kon jauk’ awaronuk, is Ro Nukan Mokois nais keseriar Anut nukan sarau eitek akan amiakap ‘kiro ro ko isan jai’ äiäm. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Owo ros roasiret omnokou opok isan jai rai wa awarai, isas nais keseriar Anut nukan sarau eitek akan amiakap ‘kiro ro ko isan jai’ rai wa äiäm. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Utianik, owo ro kos ämän aru Ro Nukan Mokoin enip opok monuk, Anut nukas kiro onok aru jäkäi murai. Owo ros jeje ämän Anut nukan Osou Näu nukan enkup ämän mai, Anut nukas kiro ron onok aru wa jäkäi murai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Owo ros ak tururiäi owa, roat näunäu amiakap imware potona, ak araun ronkat sosop wa owau. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Sakau tai rawe. Anut nukan Osou Näus kiro ses opokar ak owo ämän aräun ätär marai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Kar ros kiro roasiret erekapu turur rain opok siräumara, Jisas auruwon, “Näwäu, nas isan awai, aurta, kiro osap iken moniokos meieanik, utomti manowon inäi owamur.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisas nukas ätäi auruwon, “Is awan osap pak, awaka pak inäi mataun kowau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Keseria, kos roasiret awarowon, “Ak jekur tai rawe, ak okoro omnokou pakan osapun woiakas wa wäu. Inok ro ko osap sosop orip ko kiro osap opakas totok awau rawaun wa owai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Kos ätäi totok ämän awarowon, “Kar ro ko osap sosop orip ro kon woia o sosop raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Kiro ro kon wou uruas ronkatemara, äieu, is owosäu, is okoro osap turur maun omoi wäpik. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Keseria, nukasar ronkatemara, äiewon, ‘Isan ou eteinak okoro erekapu uräi kureita, kar ou näwäu moita, kiro owa osap erekapu kuräm.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kesermoi, kos äiäi, ‘Rusa, is o sosop orip, okon, is okoro o woisan sosop orip jeanik, nepipir rawam, Is sarau ätäi ätäi wa mam, erer raia, o an pak karar je je rawam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Anut nukas kiro ro auruwon, ‘Na ronkat wäpik ro. Rusapai pututu na meieta, okoro osap erekapu inokos owai?’ ");
INSERT INTO bbr2013_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Inok ro ko osap sosop turur miäu, ko kiro onok keserai, ko Anut nukan amuk opok saruku ro rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Keseria, Jisas nukas kon tamareäu roat awarowon, “Ak akan enmaksau mesin ronkateanik, ‘Ik owo o jemoi, rawau?’ ‘Ik owo omjo takäu?’ keser wa äiäu, Totomaka kiro näwäu senes, o näwäu wäpik. Akan enmaksau näwäu senes, omjo kiro näwäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ak ai raut apwarwe. Ak o uku wa weäi, ak o arianik, pote owa wa turur miäi. Kiro Anut nukasar o aronuk, jeäi. Akas kiro ai raut itimware rai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Inok ro ak kamuk opok kon ronkat sosopus okoro omnokou opok omre rumuk rawaun itok? Ko keserau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ak onok eteinak keseraun itok warnuk, ak owon onok näwäu keseraun ronkatei? ");
INSERT INTO bbr2013_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ak kurukan am musip aparwe. Ak sarau wa miäi, omjo nais akasar wa ate miäi. Utianik, is ak epar senes awarom, meter kamwareäwon ro Solomon ko kon omjo eposek miäwon, kiro omjo am musip eposek senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kurukan amurik erar kiro Anut nukas omjo areäu. Kiro amurik rurisa rawai, kiro ariwa epis erekapu jerai. Kiro amurik erar raiäi kiro Anut nukas omjo areäu. Akan woiaka epar moin kiro eteinak! Ak äpu mowe, Anut nukas ak nais kamwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Keseria, ak woiaka aru wa mau, ak ronkat sosop o jaun wa mau. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Anut nukan ämän wa roiäi roat ak okoro omnokou pakan osap owaun ronkateäi. Iken momonek ko äpu kiro osap sarau orip, okon, kos ak arai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ak Anut nukan mena tonaun amke ronkatena, kos ätäi kiro osap erekapu ak arai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Jisas nukas ätäiar äiewon, “Ak wa iminäu, mokoit iken momonek Anut nukas kiro osap sare mowon roasiret ko akan kamwareäu ro näwäu ronkatemoi, äiäi, kos kiro osap ak arai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Akan osap erekapu karauk roat aroinai, aiauk oinai, kiro aiauk roat osap wäpik orip arowe. Ak akan woiaka jekur mowe, ak osap omar oikan sosop turur maun ronkatewe. Kiro opok kar osap wa itanäiei. Owon, kiro opok kar päu ros päu owaun tonau senek wa. Kar susurauk toneanik, kiro osap wa aru mai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Keseria, owo mena nan osap turur miäum opok nan won nais kiro mena rau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jisas nukas ätäi awarowon, “Ak owo onok päi jekur kame rawe. Ak mer makoinai, arou aioinai, apu apari rawe. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Kar ro ko kon wau ori päursa, kon sarau ros kame raiäu senek keserwe. Kon ro näwäu pe im ut wenuk, kon sarau roat akas akan ro näwäu kurte pote im tue muraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kiro ro näwäus kon sarau roat apwaromara, näwäu nepipirai. Owon, ak ninau wa. Is epar senes awarom, kon omjo awau oi mianik, roasiret tanewe awareanik, o arai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Kiro roat ak akan ro näwäu aparianik, nepipiraiei, ko pututu päi nais ak nepipiraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ak äpu, kar ou atak ro ko kiro päu ro kon owa päu owaun omre äpu maro, ko wa ninai, ko awau tai raiäu. Ko kiro ro inikernuk, kon owa wa uräi tonai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ak nais keseriar jekur kame rawe. Owon, Ro Nukan Mokoi ko sareper kowai, kon kowaun omre ak äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita nukas Jisas auruwon, “Näwäu, okoro totok ämän kiro ik aikom ra, roasiret erekapu awarom.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jisas nukas ätäi auruwon, “Inok sarau ro ko ronkat eposek orip ämän tainoriäu? Kiro ro karar kon kameäu ros sare monuk, kos karauk sarau roasiret kamwareanik, akan o are rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Kiro sarau ro keser rawai, kon kameäu ro kounuk, ko nepipirai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Is epar senes awarom, kiro sarau ro ko kon ro näwäus kon osap erekapu kamäun sare murai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Utianik, kar sarau ro ko ronkat eposek wa, ko keser ronkatäi, ‘Isan kameiriäu ro ko kurte kowau utou.’ Kesermara, kos karauk sarau jaukut, akwaromara, ko an sakau jemara, rauk käi rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ko kesernuk kesernuk, kon kameäu ro sareper koumara, kiro ro mänkäsir oumara, woiaka epar mau wa roat akan mena emer kuräi. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kiro sarau ro ko äpu kon ro näwäus sarau äsimorai, kiro sarau ro kurte wa manonuk, kiro sarau ro tätäi näwäu owai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Utianik, kar sarau ro ko ro näwäu nukan ronkat äpu wa, sarau eposek wa monuk, kiro ro tätäi eteinak owai. Utianik, Anut nukas kar ro kon ipou opok osap kamäun miäu, tawa kiro ro pakan ätäi osap sosop owam rai aurai. Ko kar ro osap sosop senes kamäun miäu, ko kiro ro pakan ätäi osap senri owai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jisas nukas äiewon, “Is okoro omnokou opok ep tukuraun koimin. Isan ronkat kiro ep jere potora, kiro eposek. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Is amke tätäi näwäu owam. Kiro usu kame rai, isan woi uru usu näwäu mora. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Akan ronkat is okoro omnokou pakan roasiret pak tamuräi rawaun koimin rai äiein. Wa senes is epar awarom, is okoro omnokou pakan roasiret atap atap inäiwaraun koimin. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Rusapai kar tupsiu pakan roasiret 5 orip inäiäiei. Roasiret 3 orip karaima inäianik, rawaiei, roasiret 2 orip ak karaima rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Keseriar roat ak akan mokoit pak iwäi muratäiei, mokoit akas akan momonakat pak iwäi muratäiei. Asiret ak akan asinakut pak iwäi muratäiei. Asinakut ak akan aninakat pak iwäi muratäiei. Asiret ak akan pusirakat pak iwäi muratäiei, Pusirakat nais akas keseriar keseraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jisas nukas roasiret awarowon, “Ak iou mokup näwäu kounuk, aparianik, akas ronkateäi, ‘Kiro om nai.’ Kiro ak epar äiäi, om neäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ak urir pemara, roros orip penuk aparia, akas ‘Kiro san sakau päun ses’, äiäi. Kiro epar senes peäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ak sät äiäi roat, ak omar aparia, kiro owo omre päun äpu miäi. Ak owoseanik, omre rusapai owo päun kiro ak äpu wa?” ");
INSERT INTO bbr2013_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Jisas ätäi äiewon, “Akasar jekur ronkatemoi, ämän jekur wa wasareäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Utianik, na kar ros na wasarewareäu ro nukan amukup imäisi potonuk, au apu opok pote räi, ämän jekur atower. Warnuk, kos na wasarewareäu ro opok imäisi potonuk, kos na polis nukan ipou opok musonuk, kos karapus owa kureisai. ");
INSERT INTO bbr2013_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Na kiro owas ätäi kasik naun erar wa äsimoisaiei. Utianik, na aiauk näwäu maun aisowon keseriar erekapu marota, epar na kasik utoisona, manam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kiro ses opok, karauk Galili roat Anut jou muruna, Pontias-Pailot nukas akwaronuk, meiein. Keseria, karauk roat akas Jisas aurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisas nukas awarowon, “Kiro Galili roat Pailot nukas akwaronuk, meiein akan ronkat kiro roat meiein akan onok aru pakas meiein ra, kiro Galili roat karauk rusa rai akan onok eposek, okon, ak wa meieäi ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wa senes, epar wa. Ak erekapu onok aru orip. Is epar awarom, ak akan woiaka wa pirirna rai, ak kiro roat meiein senek ak nais keseriar meiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kiro roat 18 orip meter Siroam mena ou uräi nomara, akwaronuk, meiein, akan ronkat kiro roat ämän näwäu orip meiein, karauk roat Jerusalem mena rain, ak ämän wa ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Is epar senes awarom. Kiro epar wa. Utianik, akan woiaka wa pirirna roi, ak kiro roat meiein senek meiäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Keser awaromara, Jisas nukas kar totok ämän marowon, “Kar ro ko wain woia uran uku wewon. Ko orip orip kiro uran nemauk muru rai pote apariäu, näu wa muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Keseria, kos kiro woi kameäwon ro auruwon, ‘Is woisan 3 orip okoro uran nemauk muru rai aparau koimin, ko murau wa, okon, is patiram, owon, ko omnokou nukan sirau erar patarura?’ ");
INSERT INTO bbr2013_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kiro sarau ros ätäi auruwon, ‘Näwäu, karar woisan opok utota, raunuk, is omnokou kiro mu opok kureta kureta, pote nemauk murai rä aparam. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kiro woisan opok, wa murunuk rai, epar na koi tore kuräm. Nemauk murunuk rai, kiro eposek, rawaura.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Kar sumaun omre opok, Jisas ko roasiret tururiäi owa Anut nukan ämän roasiret mare rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kiro opok kar asir ko osou aru orip woisan 18 orip rawon ko tuku siräi tai rawau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisas nukas kiro asir aparmara, wouti momara, urunuk, ko siakup kounuk, auruwon, “Asir, nan sip aru jäkäi musom.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Kos kon ipou kiro asiren tapau atonuk, kiro asir ko tuku siräumara, Anut jou muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Kiro tururiäi ou kameäwon ro nukas Jisas kiro onok kesernuk, aparmara, kasak pewon. Owon, Jisas nukas sumaun omre opok kiro asir jekur mowon. Keseria, kiro ros roasiret awarowon, “Omre 6 opok, kiro sarau maun ses, kiro omre opok jekur maraun itok. Sumaun omre opok kiro jekur maraun senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Näwäu nukas ätäi kiro ro auruwon, “Ak sätäiäi roat! Ak sumaun omre opok akan bulmakau ra donki pakan mur uraianik, imware pote an ariäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Okoro asir ko Apraham nukan kin pakan, Satan nukas woisan 18 orip imäumara, sakau ateanik, rawon. Epar kon usu sumaun omre opok jäkäi muraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Kos keser äienuk, kon iwäi jaukut ak oioraka nowon. Karauk roasiret kiro owa turur rain ak kiro onok eposek aparianik, jou murin. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Keseria, Jisas nukas roasiret totwarowon, “Is Anut nukas roasiret kameäu onok owo senek rau awaram? ");
INSERT INTO bbr2013_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kiro kon onok kesek, kar ros ko marmar uku oumara, woia wewon. Kiro am uku eteinak tu pemara, am näwäu sareäu. Kesernuk, ai akas pemana, kiro am iporu opok tou moin. Kiro senek, amke roasiret karar karar Anut nukan ämän tainoriäi, tawa roasiret sosop akas tainoraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jisas nukas ätäi äiewon, “Is Anut nukan kameäwon onok owo senek ätär marau? ");
INSERT INTO bbr2013_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kiro onok kesek, kar asires jis eteinak oianik, plaua näwäu orip ore oumara, tururmoi, etwairnuk, kiro plaua noroianik, mup näwäu senes sareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","24","Jisas ko Jerusalem mena pote rai, näu mena pak eteinanak mena pak Anut nukan ämän roasiret mare mare potowon. Kar ros totorwon, “Näwäu, Anut koi wasarewaraun ses opok roat esap esap apu eposek opok tonaiei? Isan ronkat sosop wa.” Jisas nukas ätäi awarowon, “Ak sakau mia, apu eteinak pakas tonaiei. Owon, roat sosop ak kiro apu eteinak pakas tonam äiäiei ak tonau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kiro ou rorok kameäu ros im penenuk, ak tonea, kasikas raianik, im ut koukourianik, äiäiei, ‘Näwäu, ik im tue muk’ auraiei. Kos ak ätäi awarai, ‘Is ak äpu wa, meter ak wa apwareäim.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Kesernuk, akas ätäi auraiei, ‘Ik na pak raianik, o pak an pak erek jeäum, na iken mena Anut nukan ämän aikiäum.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Kos ätäi awarai, ‘Ak erapakan pein is äpu wa. Ak onok aru miäi roat, ak enes eur manowe!’ ");
INSERT INTO bbr2013_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kiro opok tätäi näwäu orip orip oi rawaiei. Anut nukan kamwaraun onok amop penuk, akas Apraham, Aisak, Jekop pak Anut nukan ämän roianik, areai roat pak Anut pak rauna, apwaraiei. Utianik, ak kar mena atap raianik, akan aiakpanak kartitirianik, wai rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kiro ses opok, san peäwon pakan roasiret pak san neäwon pakan roasiret pak roasiret okoro omnokou pakan erekapu peanik, koi Anut nukan kamwareäwon mena tururianik, Anut pak o je rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Roat ak enmak näwäu wa ruris rai, ak amke rawaiei. Amke rai roat ak enmak orip, ak ruris rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kiro ses opok, karauk Parisi roat akas peanik, Jisas aurin, “Na okoro mena wa rawau, utoinam, kar mena man. Owon, Herot ko na iwose kuräun keserura.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jisas nukas ätäi awarowon, “Akas potoinai, kiro kawarur ro pote aurwe, is rusapai ariwa pak roasiret osou aru orip pak sip aru orip jekware maram, omre 3 opok orio is isan sarau patarianik, sumam. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Utianik, is rusa, ariwa, orio sarau me Jerusalem mena potam. Owon, Anut nukan ämän roianik, areawon ro Jerusalem mena karar wena, meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jisas nukas Jerusalem mena aparmara, äiewon, “O, Jerusalem, Jerusalem! Akas Anut nukan ämän roianik, areain roat akwarona, meiein. Ak karauk roat ämän oi ariain roat Anut nukas äsimwarowon, aiaukus akwarona, meiein. Is omre sosop, kakarau anak nukas kon nakut saus kurur ware, raiäu senek, isan ipias roasiret kamware rawaurimin. Utianik, roasiret akas is kesewaraun wa utoiroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ak rowe, Anut kon osap nuriäi ou ute manonuk, akasar akan ou kamäiei. Is epar senes awarom, Ak is ätäi wa apairaiei. Is ak epar senes awarom, rusapai is manoita, ak is ätäi wa apairaiei, pote tawa, akasar keser äiäiei, ‘Anut nukasar kiro ro sare mai, ko Näwäu, nukan enip pakas kowai.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Kar sumaun omre opok, Jisas ko kar Parisi ro näwäu nukan owa o jaun potowon. Roat akas ko owosäi rai jekur apai rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","3","Kar ro ko kon ipou isou erekapu norowon, kiro ro Jisas siakup kounuk, Jisas nukas aparmara, kos sintore ämän tamareäi roat pak Parisi roat totwarowon, “Kar ro sumaun omre opok jekur maun itok ra wa?” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kiro roat akas ätäi kar ämän aräu wa. Keseria, Jisas nukas kiro sip ro jekur momara, äsimornuk, kon mena manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Keseria, kos awarowon, “Ak akan mokoi ra donki ra sumaun omre opok an up uru ouri nonuk, ak owosäiei? Kiro omre opok pote imäiäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Akas ko ätäi kar ämän aurau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisas nukas roat o jaun pe, omoi eposek ouna, apwareanik, kos kiro roat kar totok ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kar ros na o näwäu jaun urweisonuk, na potoinam, omoi eposek opok wa tanäu. Kiro ros kar ro näwäu nais erek uruwon kiro omoi eposek opok pe tanäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kiro ro na usowon ros pemara, aisai, ‘Kiro omoi tane raum okoro ro näwäu nuruta, tanäi.’ Keseria, na roat enmaka wäpik pak pote tanäun oiot nai. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Utianik, na kar ros o jaun urweisonuk, potoinam, karauk roat ruris tane rai opok tone tane. Keseria, kiro o atak ro pemara, aisai, ‘Jai, na kämioik omoi eposek opok tone tane.’ Kesernuk, karauk roat tane rai ak na jou musaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Owon, inok ro ko nukasar kon enip rororai, kiro ron enip Anut nukan amukup näwäu wa saräi. Inok ro ko nukasar kon enip wa rororai, kiro ro ko enip jou orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Keseria, Jisas nukas totok ämän maromara, kiro ro o atak ro auruwon, “Na o näwäu mis moinam, nan jaunat ra nan amunat aunat ra nan tupsiu wa urwarau. Owon, kiro roat akas na ätäi amuk o jaun urweisaiei. Nas owo onok kesermon ätäi akas nais keseriar keseisaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Utianik, na äs näwäu moinam, roat osap wäpik orip pak roat isoraka ipiaka aru orip pak amiaka utup orip roat o jaun urwar. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kiro onok keserta, nan won näu sarai. Kiro roat akas na ätäi urweisau senek wa. Keserta, roat eposek ak meieanik, ätäi siräuna, Anut nukas na jekur kamoisai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Kar ro ko kiro opok tane rawon kiro ämän roumara, Jisas auruwon, “Inok ro ko Anut nukan kameäu onok amop päi ses opok Anut pak o jeanik, ko eposek nepipir rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Utianik, Jisas nukas ätäi auruwon, “Kar ro ko äs näwäu momara, roat sosop kiro o koi jaun ämän surmarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Äs erekapu me kuremara, o jaun ses opok kon sarau ro äsimornuk, kiro roat kos meter awarowon, koi o jaun pote awarowon, ‘Ak kowe, o jaun ses pe rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kiro roat karar karar akas ätäi kiro sarau ro aurin. Kar ros kiro sarau ro auruwon, ‘Is omnokou rusapai kau momin, is aparau manaurim. Nan ro näwäu pote aur ko wou aru wa mau.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Karas äiewon, ‘Is rusapai bulmakau 10 orip kau momin, okon, ak jekur sarau morai ra, wa rä rai apwarau manaurim. Is wa potam. Nan ro näwäu pote aur. Ko wou aru wa mau.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Karas äiewon, ‘Is asir rusapai oimin, okon, is wa potam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Keseria, kiro sarau ro ätäi potomara, kon ro näwäu kiro roat akas aurin ämän erekapu auruwon. Kiro ro näwäu ko kasak pemara, kon sarau ro auruwon, ‘Na kurte näu menan porim ororokpai pak apu opok pak potoinam, roat osap wäpik orip pak amiak utup orip pak isoraka aru orip roat isan owa imware koi.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Kiro sarau ros kiro ämän tainorianik, ätäi pemara, äiewon, ‘Näu ro, is nan ämän airomon erekapu tainorimin, karauk omoi sosop erar rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Keseria, sarau ro ätäi kon ro näwäus äsimorianik, auruwon, ‘Na apu kasakup potoinam, roat erekapu sakau ämän awarota, kouna, kiro omoi rau erekapu owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Owon, is epar senes awarom, kiro roat amke o jaun awaromin, ak isan patan opok o wa jaiei.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","26","Kar omre, roasiret sosop Jisas tainori potona, kos ätäi pirirmara, roasiret keser awarowon, “Utianik, inok ro isan tamuriäim ro saräun kon momok anak pak kon wau pak kon mokoit pak nuka pak akanun orip orip ronkatwaraiei, ko isan tamuriäim ro wa rawai. Ko isanun karar wous meiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Kar ro is tainoireanik, ko kon am äpäs ämäiäu wa, ko isan tamuriäim ro wa saräi. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Kar ro ko ou maun, ko tane raumara, jekur ronkateäu. Kiro ou pataraun itok ra, wa ra rai ronkateäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ko kiro onok keserau wa, kiro ou kurte wa patarnuk, karauk roat akas kiro ou patarau wa aparia, iowaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Akas äiäiei, ‘Kiro ro ou mowon ko kurte sarau patarau senek wa,’ keser äiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Utianik, kar omsau pakan kamwareäu ro ko kon marai roat pak kar omsau pakan kamwareäu ro pak kon marai roat sosop pak weräiäun, kiro ro näwäu ko jekur tane raumara, kar ro näwäu pak owose weräiäun jekur ronkateäu. Kon marai roat pak karauk marai roat pak weräiäun itok ra, wa ra, keser ronkateäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Kon ronkat ko karauk roat pak weräiäun itok warnuk, kon iwäi jauk atapuk raunuk raunuk kon kar sarau ro äsimornuk, pote kar ro tararmara, aurai, ‘Ik ak pak weräiäu utom.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jisas ko kiro ämän aware kuremara, awarowon, “Kiro apu karar. Inok ro ko isan tamuriäim ro rawaun, ko kon osap erekapu sumkäinemara, kiro osapun ronkat sosop wa mai, ko isan tamuriäim ro tuku rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jisas nukas ätäi äiewon, “Siu eposek kiro mitu. Utianik, kon mitu pote tiu sarenuk, ätäi mitu saräun senek itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Kiro siu woia pak karauk sarau pak maun senek itok wa. Ik erar oi kureäum. Ak raiaka orip raroi, ak kiro ämän rowe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Kar omre, takis oiäin roat pak karauk onok aru miäi roat pak ak Jisas nukan ämän rowau koin. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Karauk Parisi roat pak sintore ämän tamareäi roat pak akas ko aparianik, äiein, “Okoro ro ko onok aru miäi roat pak o jeäu. Kiro onok eposek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","4","Keserna, Jisas nukas totok ämänis awarowon, “Utianik, kar ro ko kon sipsip 100 orip. Keseria, sipsip karar ämäunuk, kiro ro owosäi? Ko kiro sipsip 99 orip utwaronuk, amurik je rauna rauna, potomara, kiro sipsip karar ämäuwon, itane pote aparmoi, imäi kowai. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","6","Ko kiro sipsip pote itane oumara, nepipirianik, kuor ämäi oianik, kon mena potai. Keseria, kon jaukut erekapu urwarnuk, kouna, awarai, ‘Ak is pak koi nepipirwe, owon isan sipsip kar ämäuwon itane aparim, okon, rusapai ik äs näwäu mau.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Kiro onok senek is epar senes awarom, roat 99 orip ak onok tuku eposek miäi omar oik ak nepipiraiei. Utianik, kar ro kon onok aru mowon sumkäineanik, kon wou piririanik, epar miäu, omar oik ak näwäu senes nepipiraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jisas nukas ätäi awarowon, “Utianik, kar asir kon aiauk eposek 10 orip, karar ämäunuk, ko owosäi? Ko arou aioi oumara, kon owa om kasarmara, omoi erekapu jekur aparai. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Kiro aiauk karar itane apari oumara, kon jaukut urwaronuk, koi tururna, awarai, ‘Isan aiauk ämäuwon itane apari oim, okon, ak is pak nepipirwe.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kiro onok kesek, is epar senes awarom, kar ro ko onok aru miäu ko kon wou ätäi pirirmara, wou epar monuk, Anut nukan sarau eitek akas omar oik keseriar näwäu nepipiraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jisas nukas ätäi kar totok ämän keser awarowon, “Kar ro ko mokoi oirori orip. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Etei mokois pemara, kon momok keser auruwon, ‘Moni, na isan osap inäinam, is ir!’ Kesernuk, momonawas kon osap inäianik, kon mokoit ori atap atap atowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Rai rai, kiro etei mokoi kon osap erekapu aiaukun surmara, ko kiro pakan aiauk oumoi, kar mena atapuk rawaun ute manowon. Ko kiro omsau atapuk potomara, kon aiauk erekapu onok aru opok känkurewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kon owo osap rawon erekapu patarnuk, kiro ses opok kiro omsau opok sou näwäu senes pewon. Ko kar osap rawau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","16","Keseria, kiro mokoi ko kiro mena kar ro rawa pote sarau maun totornuk, kiro ros kiro mokoi kon poat kamwaräun äsimorwon. Ko sou näwäu raumara, kiro poat o jena, ko erek jaun ronkatewon, owon, kar ros ko o nurunuk, jau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Rai rai, kon ronkat eposek penuk, äiewon, ‘Isan monian sarau roat ak o eposek sosop jerai, okoro opok o wäpik rai rai, is meiäurim. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Isan moni siakup potoita, auram, “Moni, is Anut nukan amukup pak nan amunap is onok aru momin. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na is nan mokoi rai wa airau, nan sarau ro senek mur.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Keser ronkatemoi, ko siräumara, kon mena momok siakup potowon. Ko atapuk kounuk kounuk, kon momokus atapukas aparmara, kon mokoi mesin wouti monuk, kurte pote pokäirmara, oktokormoi, imäi kowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Kon mokois momok auruwon, ‘Moni, is Anut nukan amukup pak nan amunap is onok aru senes momin, okon, nas is nan mokoi rai wa airau.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Utianik, kon momokus kon sarau roat urwaromara, awarowon, ‘Omjo eposek kurte oi peinai, take muruwe. Kar ring oinai, kon ipou opok muruwe. Su oinai, kon isou opok muruwe. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Keseria, potoinai, isan bulmakau nak eposek weinai, mis mowe. Ik ko pak o jemoi, nepipirau. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Isan mokoi okoro, ko meiewon raimin ko ätäi koi tarairou, ko erekapu manou rai äiemin, is ätäi aparim.’ Kesermana, ak o näwäu mis moin. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Keserna keserna, mokoi urektapau ko woia rawonus, mena sinakup pemara, owa sir weanik, nepipir käi mirorir rain rowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Keserna, kos kar sarau ro urirawa, nonuk, totorwon, ‘Kiro owa owoserai käi miroriräi?’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kiro sarau ros ätäi auruwon, ‘Nan amun ätäi mena kowon, okon, nan momonas nepipirmara, kon bulmakau nak eposek wemara, ko pak tanäun äs morai, owon, kon mokoi ute manowon ätäi kowon.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Kiro mokoi urektapau ko kasak näwäu pemara, ko owa tonau wa. Keseria, momokus koumara, kon wou näu saräun ämän auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Utianik, kos momok auruwon, ‘Is okoro woisan sosop opok, is nan sarau ro senek sarau sosop me raimin, nan ämän jekur tainoriäim. Isan jaiat pak äs maun kar meme wa iromon. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Utianik, nan mokoi kiro ko nan osap erekapu oi pote känkuremara, kounuk, nan bulmakau nak eposek we murum.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Momokus ätäi auruwon, ‘Isan mokoi, na is pak orip orip raiäum, isan osap rau kiro erekapu nan. ");
INSERT INTO bbr2013_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ik erek nepipirau iken woiok eposek saräu, owon, nan amun okoro ko meiewon raimin, rusapai ko ätäi koi rau. Ko erekapu manowon raimin, rusapai ätäi imäiemin koi rau.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Kar omre opok, Jisas nukas kon tamareäu roat totok ämän keser awarowon, “Kar ro ko osap sosop orip kos kar sarau ro kon osap kamäun sare muruwon. Kiro sarau ro ko sarau monuk monuk, karauk roat akas kiro osap atak ro aurin, ‘Nan sarau ro ko aiauk sepuk sepuk käkänkurewon.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Keseria, ko ämän roumara, kon sarau ro urirawa, kounuk, auruwon. ‘Is roat akas na owo kesermon airona, roimin. Kiro epar ra? Kiro ämän eparnuk rai, na isan sarau ro wa rawam. Na potoinam, inokot akas isan osap erar oin enmak jer we oinam, koi irota, aparam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Kiro sarau ros ronkatemara, kon wou uruas äiewon, ‘Isan kamoireäu ro ko is ätäi sarau maun wa imäirai. Is om wäun sakau wäpik, is karauk roat o nik maraun, oior nai. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Rusapai is äpu is owosäm, isan näwäu is sarau opok ätäi wa imäironuk, isan jaiat akas akan owa imäiri potaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Keser ronkatemara, kos roat meter kon näwäu nukan osap erar aronuk, oin, urwarnuk, kouna, kos kar ro keser auruwon, ‘Na isan ro näwäun osap esap esap oumon?’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Kiro ros ätäi auruwon, ‘Is uer mis 100 orip mis maun äräine oimin.’ Kiro sarau ros auruwon, ‘Na kurte taneinam, kiro meten 100 orip jer rau känkureinam, rusapai am käwäu awau opok mis 50 orip jer we mo.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Kesermara, kos ätäi kar ro auruwon, ‘Na osap esap esap oumon?’ Kos keser auruwon, ‘Is rais bek 100 orip oimin.’ Kiro sarau ros ätäi auruwon, ‘Na am käwäu awau okoro oianik, kurte taneinam, bek 80 orip jer we mo.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Kiro sarau ro kon ronkat eposek keseria, kon ro näwäus kiro ro aru nukan enip oik muruwon. Kiro sarau ro ko ronkat eposek orip senek keserwon. Okoro omnokou pakan roasiret ak akasar aka sarwaraun ronkat eposek orip sarau maun itok. Ak roat Anut nukan arou merek eposek opok rai itimware rai. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Is epar senes awarom, ak akan aiauk saruku roasiret sarwaraun, arona, kiro roasiret ak akan jaunakat senek saräiei. Tawa kiro aiauk patarna, Anut nukas ak kon mena eposek opok iware tonai. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Inok ro ko osap eteinak jekur kamäi, ko osap näwäu nais kamäi. Inok ro ko sarau eteinak jekur wa kameäu, ko sarau näwäu nais jekur wa kamäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Utianik, ak omnokoukan osap aru jekur kamäu wa, inokos ak osap eposek jekur kamäun arai? ");
INSERT INTO bbr2013_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Utianik, ak karauk roat akan osap jekur wa kamena, inokos kar osap eposek ak araun sare marowon arai? Kar ros wa arai. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Sarau ro kararas ko ro oirori opok sarau mau senek wa. Owon, ko karan wous meieanik, kar ron wous wa meiäi. Ko kar ron ämän jekur tainorianik, sarau eposek momoi, kar sumkäineanik, kon ämän jekur wa tainoriäu. Ak Anut nukan sarau pak aiaukun sarau pak erek turur mau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Karauk Parisi roat ak aiaukun woiakas weäi. Keseria, ak kiro ämän roumana, akas Jisas oiakas mirikirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisas nukas ak apwareanik, ätäi awarowon, “Ak akan ronkat, ak karauk roat akan amiakap roat eposek äiäi, Anut ko akan ronkat woiaka uru rau äpu mareäu. Kiro roat akan ronkatis osap näwäu wouswariäi, kiro onok Anut nukan amuk opok aru senes. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Meter roasiret akas Moses nukan sintore ämän ninareäin pak Anut nukan ämän roianik, areain roat akan ämän orip orip areain. Ak keserna keserna, Jon pewon. Jon penuk, rusapai isas Anut nukan kamwareäwon ämän mare arieita, roasiret sosop Anut nukan roasiret saräun sakau miäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Okoro omnokou omar pak wasaräieir, utianik, Anut nukan sintore ämän eteinak kar wa ämäiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Ro kon asir utia, kar asir owai kiro ro roasir ouratäiäi akan sintore ämän espäiau. Owo ro ko kar asir kon komus utowon, owai, ko nais keseriar kiro sintore ämän espäiau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Kar ro ko osap sosop orip raiäwon, ko omjo eposek eposek mianik, orip orip jekur nepipir raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Kar saruku ro kon enip Lasarus, kon enipsau opok ui sosop murianik, aru muri rawon. Ko kiro ro aiauk sosop orip nukan ou rorokpai raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ko kiro ro aiauk sosop orip ro o jenuk, o usip patan inkaruru nonuk, aparianik, kiro o usip jaun raiäu. Kesernuk, enat akas koumoi, kon ui merakariäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Kiro saruku ro meiewon ses opok, kon totok Anut nukan sarau eitek akas imäianik, Apraham rawon opok omar oik imäi tonoin. Rai rai, kiro ro näwäu nais meienuk up kurein. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kon totok ep näwäu jere rawon opok nowon. Kiro pakas ko Lasarus Apraham ori eposek atapuk raunuk, aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Keseria, kiro ros urwewon, ‘Moni Apraham, is okoro up uru ep opok tätäi sosop oi raim, isanun wonti muroinam, Lasarus aurta, koi kon ipous an atomara, isan menomauk opok murai.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Apraham nukas ätäi kiro ro auruwon, ‘Isan mokoi, naka meter omnokou opok raianik, osap sosop erekapu oumata, nepipir raumon, na kiro ronkate. Lasarus ko osap wäpik erar wopure rawon, okon, rusapai ko okoro mena nepipir rau. Na tätäi näwäu oi rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ik okoro kamuk anrak näwäu rau, roat okoro opok rai ak kiro anrak espäi potau senek wa, akas nais okoro opok espäi kowau senek wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Kiro ros ätäi Apraham auruwon, ‘Keseria, is na aisom. Moni Apraham, ätäi Lasarus äsimorta, nea, isan tupsiu awaronuk, woiaka piriraun awarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Kiro opok isan amaiat awaiat 5 orip rai opok nea, awaronuk, ak nais is tätäi ouram opok wa kowaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Apraham nukas ätäi kiro ro auruwon, ‘Nan tupsiu meter Moses nukan sintore ämän pak Anut nukan ämän roianik, areain roat akas ämän jer we moin ak aparianik, tainoraurai. ");
INSERT INTO bbr2013_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kiro ros ätäi Apraham auruwon, ‘Moni Apraham, kiro nais itok wa, kiro ämän ak wa tainoraiei, utianik, kar ro meiewon siräimara, pote ak awaronuk, kiro epar akan onok aru miäi pakan ätäi akan woiaka piriraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Apraham nukas ätäi äiewon, ‘Utianik, ak Moses nukan ämän pak Anut nukan ämän roianik, areain roat akan ämän wa tainoriäi, kar ro meiewon, ätäi siräiäi nais aparmoi, akan woiaka wa piriraiei.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Kar omre opok, Jisas nukas kon tamareäu roat awarowon, “Onok atap atap roasiret onok aru maraun päi. Kiro ro inokos kiro onok aru oi kowai, kiro ro ko wopur senes. Anut nukas kiro ro aru murai. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Kar ros kar mokoi eteinak onok aru ätär murunuk raroi, kiro onok aru senes. Karauk roat akas aiauk usuäu oianik, kiro ron pou opok muris pararar mianik, ko an unik uru känkurena, nai, kiro itok, kiro usu eteinak. Warnuk, tawa omar oik ko usu näwäu senes owai. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ak owo onok keseraiei, jekur ronkatewe. Nan jaun ko onok aru monuk rai, nas ko keram. Ko ätäi kon wou pirirmara, kounuk rai, nas kon onok aru jäkäi mur. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Utianik, kos na omre karar opok onok aru 7 orip musonuk, kos ätäi na siatap orip orip koianik, äiäi, ‘Jai, is woiti murou,’ keser aisonuk, nas kon onok aru erekapu jäkäi mur.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisas nukan ämän oi ariai roat akas Näwäu aurin, “Na iken woiok epar maun sakau muk.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jisas nukas ätäi awarowon, “Akan woiaka epar moin, kiro am uku eteinak marmar senek, ak okoro wer mu auraiei, ‘Na siräinam, mas an opok pote tai rau,’ aurna, kos akan ämän tainorai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Utianik, kar ro ak kamuk opok rau ko kar sarau ro orip. Kiro sarau ro ko woia sarau miäu ro ra, sipsip kameäwon ro raiäu. Iukärir sarau patarmara, penuk, nas ‘na kurte peinam, sia opok pe taneinam, nan o je’ keser auriäum ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wa senes. Nas ko keser auram, ‘Na isan o mis mur. Na an joinam, is o jeita, kamoiri rau. Is o je kureita, tawa na o jam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kiro sarau ros kon ro näwäu nukan ämän tainorianik, kon sarau karar miäwon. Kiro ro näwäus ätäi kon sarau ro sarau miäu kon enip jou wa muriäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Akas nais keseriar keserwe, karauk roat akas ak sarau maun awarona, sarau mia, äiewe, ‘Is sarau ro enim näwäu wäpik, is erar sarau rai sarau moram.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jisas ko Jerusalem näu mena pote rai, ko Samaria provins pak Galili provins kamuk potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ko kar mena tononuk, roat 10 orip ak sip repros orip atapukas senek tai rain tarwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Akas urweanik, äiein, “Jisas, näu ro, ikenun wonti mukoinam, ik sareik.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisas nukas apwaromara, awarowon, “Ak potoinai, Anut kamuk raiäi roat opok akan enmaksau ätär marowe.” Ak potona potona, kiro sip repros manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Karar ro ko aparwon kon sip aru manonuk, ko ätäi koumara, sakau urwemara, Anut jou muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Koi, omnokou opok Jisas nukan isou opok uou sur wemara, jou muruwon. Kiro ro ko Samaria* provins pakan. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Kesernuk, Jisas nukas äiewon, “Roat 10 orip jekwaromin, roat 9 orip ak erapok manoin? ");
INSERT INTO bbr2013_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Okoro Samaria ro ko atapukan. Owon nukarar koumara, Anut jou muru?” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jisas nukas kiro ro auruwon, “Na siräinam, man. Na nan won epar momon, okon, na eposek sareisai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Karauk Parisi roat akas Jisas totorin, “Anut ätäi kamoikaun esepa kowai?” Kos ätäi awarowon, “Anut ätäi ak kamwaraun kounuk, ak ko amiakas wa aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kar ros wa äiäi, okoro peu koi aparwe, aisen peu aparwe. Utianik, ak rowe, Anut ak kamwaraun rusapai ak siarakap pe rau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Keser awareanik, kos kon tamareäu roat awarowon, “Kar omre päi kiro opok akan ronkat ak Ro Nukan Mokoi aparam rai äiäiei, utianik, ak ko wa aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Karauk roat akas awaraiei, ‘Aisen aparwe!’ ‘Okoro opok aparwe!’ Ak kiro roat akan ämän roinai, epar rai wa tainware manau. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ro Nukan Mokoi kowaun ses opok, omar käiemara, ermänirmara, karaima poteäu senek. Ro Nukan Mokoi kowaun ses opok, kiro onok senek keser kowai. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Utianik, amke ko tätäi sosop oumara, okoro omnokou pakan roat näunäu akas ko wena, meiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Meter Noa rawon ses opok, roasiret akas keserin senek, rusapai nais Ro Nukan Mokoi kowaun ses opok keseriar keseraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Roasiret ak o je rai, an je rai, ro asir oi rai, ak keser rauna rauna, Noa ko ous uru tononuk, joi näwäus koumara, roasiret erekapu oware jenuk, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lot rawon ses opok nais keseriar keserin, roasiret erekapu an o pak jeanik, nepipir rain. O kau mianik, osap ätäi aiaukun arianik, woia o uku we rai, ou awau me rai nepipir rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kiro ses opok, Lot kiro mena ute manonuk, ep näwäu salfa* orip omar oikas koumara, kiro pakan roasiret erekapu jerwarnuk, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ak keser rain senek, rusapai nais keseriar keserna keserna, Ro Nukan Mokoi ko amop kowai. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Kiro ses opok, ro ko ou oik rawai, kon osap owa rau owaun wa nai. Kar ro ko woia rawai, ätäi kon mer eposek owaun mena wa potai. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ak Lot nukan asir ronkatewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Inok ro ko kon totok isanun wa meiäi, kiro ro kon totok erekapu wasaräi. Inok ro ko kon totok isanun meiäi, kon totok orip orip awau rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Is epar senes awarom, kiro ses opok pututu ro oirori au patan karar opok ninaieir Anut nukan sarau eitek akas kar imäianik, kar ute manaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Asir oirori au ma rei rawaieir opok, kar asir koi imäianik, kar asir ute manaiei.  ");
INSERT INTO bbr2013_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ro oirori au woia sarau me rawaieir, kar imäianik, kar ute manaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Kiro ämän roianik, kon tamareäu roat akas totorin, “Näwäu, kiro onok erapok päi?” Jisas nukas ätäi awarowon, “Erapok opur meieanik, poomre rawai, kiro opok epsimai sosop kiro opur pomou jaun pote tururaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Keseria, Jisas nukas kar totok ämän kon tamareäu roat ak orip orip Anut aurianik, kos ak kurte wa sarwarnuk, akan woiaka aru wa mau rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Kos äiewon, “Kar näu mena, kar ämän wasarewareäwon ro ko Anut nukan ämän wa tainoriäu. Karauk roat akan ämän roianik, jekur wa sarwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kiro mena nais kar wäimäs asir ko orip orip kiro ro opok koumara, auriäu, ‘Isan iwäi jaias is aru murauru na is sareir.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","5","Kiro ros kurte kiro asir saräu wa. Rai rai, kon wou uruas ronkatemara, äiewon, ‘Is Anut nukan ämän wa tainoriäim, karauk roasiret mesin wa ronkateäim. Is apu kiro epar, utianik, okoro wäimäs asir ko is sarau näwäu iriäu, okon, is ko saräm. Ko wa sareita, orip orip is siarap kounuk, is wäsuk irai.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisas nukas ätäi äiewon, “Ak kiro ämän wasarewareäwon ro aru nukan ämän rowe. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Anut nukas kon roasiret sare marowon, akas omre orip orip sankeu pututu sarwaraun waiena, kos ak sarwaraun itok ra? Omre rumuk rai rai sarwarai ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Is epar senes awarom, ko akan wai roumara, kurte sarwarai. Tawa Ro Nukan Mokoi ätäi kowai ses opok ko okoro omnokou pakan roasiret akan woiaka epar moin aparai ra, wa?” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jisas nukas karauk roasiret akasar akan ronkatis akan onok erekapu eposek äiäi, karauk roat akan onok aru rai äiäi totok ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Kar muti, ro oirori au Anut auraun tup ou näwäu uru tonoirin. Kar ro ko Parisi ro kar ro ko takis aiauk oiäwon ro. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kiro Parisi ro ko nukarar tai raumara, Anut aurmoi, äiewon, ‘Anut, is na pere aisom. Is karauk roat senek wa. Is sätwareanik, osap erar wa oiäim, sintore ämän wa utiäim. Is karauk akan asiret wa imware ariaim. Keseria, is na pere aisom. is kiro takis aiauk oiäu ro aisen tai rau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Is tup orip orip omre oirori opok na jou musianik, o wa jeäim. Na jou musianik, isan osap erekapu 10 orip surwate mianik, karar sur na isiäim.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Utianik, kiro takis aiauk oiäu ro ko atapukas tai raumoi, kon oiok omar oik mau wa, ko wouti momara, äiewon, ‘O Anut Näwäu, is onok aru orip, nas is sareir.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Is epar senes awarom, kiro takis aiauk oiäu ro, ko Anut nukan amuk opok eposek sarewon, kiro Parisi ro ko wa. Owon, inok ro ko nukasar kon enip rororai, kiro ron enip Anut nukan amukup näwäu wa saräi. Inok ro ko nukasar kon enip wa rororai, kiro ro ko enip jou orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Karauk roasiret akas akan mokoinakut Jisas nukas kon ipou akan tapiaka opok kon sakau araun rai, imware koin. Kon tamareäu roat akas kiro roasiret apwaromana, kewaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Keserna, Jisas nukas ak mokoinakut kiro onok keserin aparianik, urwarnuk, kouna, kon tamareäwon roat keser awarowon, “Ak mokoinakut utwarona, is siarap kowaiei, ak wa tämarau. Roasiret ak okoro mokoinakut senek sareanik, ak äpu Anut akan kamwareäu ro näwäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Is epar senes awarom, inok roasir ko mokoinak senek saräu wa, Anut nukas kon kameäu ro näwäu wa rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kar Juda akan kamwareäu ro näwäus pemara, Jisas totorwon, “Ro eposek, is owosemoi, isan totom awau orip orip rawai?” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jisas nukas kiro ro ätäi auruwon, “Na owon is ro eposek airom? Kar okoro omnokou pakan ro ko eposek wa. Anut karar eposek. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Na sintore ämän äpu, na kar ron asik wa imäi ko pak ariau, na kar ro weta, wa meiäu, na karauk roat akan osap wa päu owau, na kar ro nukan enkup sät ämän wa mau, nan momon anin orien ämän erekapu tainor.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Kiro ros ätäi auruwon, “Meter is eteinak opok, kiro sintore ämän erekapu tainori koi, rusapai nais keseriar raim.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jisas ko kiro ämän roumara, ätäi auruwon, “Kiro itok, karar onok karar na itimoisi rau. Na pote, nan osap erekapu karauk roat are kureta, akas kiro osap kau mona, kiro aiauk oinam, saruku roat osap wäpik kiro aiauk inäi aram. Na kiro keserta, tawa na omar oik osap sosop owam. Kiro onok kesernam, na koi is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kiro ro ko osap sosop orip. Keseria, kiro ämän roumara, kon wou usu sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jisas nukas kiro ron wou usu sarewon aparmara, äiewon, “Roat osap sosop orip ak Anut nukas kamwaraun sarau sakau maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Kar opur kamel ko omjo näkeäi nil nukan amarer uruas tonaun kananäi. Ro aiauk sosop orip ko Anut nukan ro senes saräun kiro sarau sakau kananäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Roat kiro ämän roianik, akas totorin, “Keseria, Anut nukas inok ro imäienuk, ko pak erek orip orip rawai?” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisas nukas awarowon, “Owo onok roat akas keseraun itok wa, Anut nukas keseraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Keseria, Pita nukas äiewon, “Ik iken mena pak iken osap pak erekapu utia, na tainoise koumun.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jisas nukas äiewon, “Is epar awarom, inok ro ko Anut nukan roasiret sarwaraun mesin ronkateanik, kon mena, wau, amakut, awakut, momokut pak utwareanik, kowon, Anut nukas rusapai omnokou opok kiro osap ute kowon senek sosop ätäi nurai. Kos tawa ko totok awau orip orip rawaun sakau nurai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisas nukas kon tamareäu roat 12 orip kasakup imware potomara, keser awarowon, “Ak rowe, ik Jerusalem mena tonam. Kiro ämän meter Anut nukan ämän roianik, areai roat akas Ro Nukan Mokoi mesin äiein, kiro ämän erekapu rusapai epar päi. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Jerusalem menan roat akas ko kar omsau pakan roat näunäu akan ipiakap muraiei. Akas kiro ro jeje ämän aurianik, onok aru murianik, opokup sinok kuräiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Akas kiro ro mänkäsirianik, wena, meiäi. Utianik, omre 3 opok, ko ätäi siräiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kon tamareäu roat ak kiro ämän roin kon onoktapau ak äpu wa. Kiro ämän onoktapau ak opok ämäi rawon. Ak Jisas nukas kiro ämän awarowon jekur ronkatäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisas ko Jeriko mena penuk, kar ro amuk utup ko apu opok tane raia, osap nik mareäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ko roasiret apu opok arina, roumara, kos totwarowon, “Kiro owoserai?” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Akas ätäi aurin, “Nasaret menan Jisas kou.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Kos urwemara, äiewon, “Jisas, Devit nukan Mokoi, na isanun wonti moinam, is sareir.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Karauk roat akas amke ko siakup potoin akas kerianik, aurin, “Na asor.” Utianik, kiro ros ätäi näwäu urwewon, “Jisas, Devit nukan Mokoi, na is sareir.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","41","Keseria, Jisas nukas sumianik, kiro ro amuk utup ko siakup imäi kowaun awarowon. Ko siakup imäi kouna, Jisas nukas auruwon, “Isas na owosisaun airom?” Kos ätäi äiewon, “Näwäu, is ätäi ami uraienuk, apu aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Keseria, Jisas nukas auruwon, “Nan won epar momon, okon, na ätäi amun urareinam, apu apar.” ");
INSERT INTO bbr2013_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ko keser äienuk, kurte amuk uräianik, ko ätäi om aparwon. Keserianik, ko Anut jou murumara, Jisas tainori potowon. Roasiret ak kiro onok aparmana, ak erekapu Anut jou muroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisas ko Jeriko mena tonomara, Jerusalem mena manaun manowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kiro mena kar ro ko takis aiauk oiäwon ro, kon enip Sakias, ko aiauk sosop orip. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ko Jisas ro owo senek, koura rai aparaun keserwon, Sakias ko ro rumukäu wa, ko katunak. Keseria, roasiret sosop akas Jisas sorotorin ko aparau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Keseria, ko koteteip amke kurte potomara, kar am rumuk aparmara, kiro am oik tonowon, Ko äpu Jisas ko kiro am siakupas kowai. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jisas ko kiro am siakup pemara, kiro am oik Sakias rawon aparianik, auruwon, “Sakias, na am oikas kurte ne. Is rusapai pututu nan owa ninam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Keser aurnuk, Sakias ko am oikas kurte nomara, ko nepipirmara, Jisas kon owa imäi potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Roat ak kiro onok aparmana, kasiaka penuk, äiein, “Kiro ro ko onok aru miäu ron owa o jau potou.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakias nukas kiro ämän roianik, siräumara, Jisas auruwon, “Näwäu, isan osap erekapu inäianik, karauk roat osap wäpik wopure rai aram. Is meter karauk roat sätwareanik, akan osap erar päu oimin, ätäi kiro osap oimin pak karauk osap sosop pak aram.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisas nukas ätäi äiewon, “Okoro ro ko nais ik senek Apraham nukan kinjauk. Keseria, rusapai roasiret okoro owan Anut nukas ätäi imwarou. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ro Nukan Mokoi ko roat wasarein itanwareanik, imwaraun kowon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Roasiret kiro ämän rouna rouna, Jisas nukas kar totok ämän marowon. Ko Jerusalem mena siakup rawon. Keseria, roat akan ronkat Anut nukas rusapai kon roasiret kamwarau kou äiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Keseria, kos awarowon, “Kar ro ko kamwareäu ro pakan tupsiu. Ko omsau atapuk kon näu mena kamäun enip owaun potomara, ätäi kowaun ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ko manaurmara, kon sarau roat 10 orip urwaromara, ko siakup potona, karar karar aiauk 2,000 orip aromara, awarowon, ‘Ak okoro aiauk arom sarau nuruwe. Is ätäi koita, owam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kon menan roat akas akan woiakas konun meiäu wa. Keseria, roat akas karauk roat äsimwarona, potomoi, kiro omsau ko potowon pakan roat awaroin, ‘Ik kiro ro ko ik kamoikaun sare murau wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Utianik, kiro ro kon omsau kamwaraun enip oumara, ätäi kowon. Ko ätäi koumara, kiro sarau roat aiauk are manowon, sarau mianik, karauk aiauk oi ra wa rai äpu maun urwarnuk, ko siakup pein. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Kar ro amke pemara, äiewon, ‘Näwäu, kiro aiauk 2,000 iromon sarau mianik, ätäi aiauk 2,000 oimin.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Kiro ro näwäu nepipirmara, auruwon, ‘Kiro eposek, na sarau ro eposek, na osap eteinak jekur kamemon, okon, kiro mena ten orip kamwaram.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Kar sarau ro pemara, äiewon, ‘Näwäu, kiro aiauk 2,000 iromon sarau mianik, aiauk 1,000 oimin.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kiro ro näwäu nukas auruwon, ‘Na kiro mena 5 orip kamäm.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Kar sarau ro pemara, äiewon, ‘Näwäu, nan aiauk iromon omjo sies otpar ämäi musomin, okoro rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Is na imineisomoi, kesermin, owon, na ro kurte kasat peäum. Karauk roat akas osap mona, raiäu, nas erar oi maneäum. Karauk roat akas o uku wein, nas o erar oiäum. Keserta, is na imineisomoi, kiro onok kesermin.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","23","Kos ätäi auruwon, ‘Na sarau ro aru, nakan ämänisar ätäi naka wasareisai. Na äpu, is kasi kurte peäu, owo osap isan wa is erar oiäim, Keseria, na owon isan aiauk benk opok murau utomon? Is ätäi keser koita, kiro aiauk pak karauk aiauk pak owam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Keseria, kos kon kameäi roat siakup tai rain awarowon, ‘Kiro aiauk kon ipou pakan senri oinai, kiro sarau ro aiauk 4,000 orip nuruwe.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Akas ätäi kiro ro aurin, ‘Näwäu, kiro ro ko aiauk 4,000 orip!’” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Kos ätäi awarowon, “Is epar senes awarom, inok ro ko osap sosop orip, ko sarau miäu, kiro ro ko Anut nukas karauk osap sosop senes nurai. Inok ro ko osap wäpik ko eteinak orip, ko sarau wa miäu, Anut nukas kiro ro pakan osap erekapu senri owai. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Utianik, kiro roat meter is okoro näu mena wa kamäu äianik, iwäi muroin, kiro roat imware koumoi, is amiap akwarona, meiäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisas ko kiro totok ämän aware kuremara, amke Jerusalem mena tonaun potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","30","Ko kar om enip Betfasi pak Betani mena omtorou enip Olivet opok pemara, kon tamareäu ro oirori amke äsimwatianik, awatowon, “Au mena karaima rau opok potoinair, kar donki nak pararar moin rau, imäi kower. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Utianik, kar ros au kiro donki nak owon ourair rai totwatonuk, awas ätäi aurwer, ‘Iken Näwäus okoro donki sarau orip äiewon.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Au poteanik, Jisas nukas ämän awatowon siar aparirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Au poteanik, kiro donki nak muris rakir moin mur uräuna uräuna, kiro donki atak ro pemara, awatowon, “Au mur donki pakan owon uräurair?” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Awas ätäi kiro ro auririn, “Iwen Näwäus kiro donki sarau orip äiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Au kiro donki nak Jisas siakup imäi poteanik, akan karauk omjo rumukäu kiro donki nukan mekesu opok puris rue mianik, Jisas nukan ipou atona, ko kiro donki oik tone tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ko donki pakas potonuk potonuk, roasiret akas akan omjo apu opok tai potaun puris rue me potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ko Jerusalem mena siakup, omtapau Olivet nukan apu siakup potowon. Kon tamareäu roat pak roasiret erekapu ak onok atap atap kos meter keserwon aparin ak nepipirmoi, Anut nukan enip oik jou murianik, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ak äiein, “Ik okoro kamoikaun ro näwäu Anut Näwäu nukan enip pakas kou jou murau. Omar oik akan woiaka päurar rawai. Anut nukan enip kämioik jou murau.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ak kiro onok keserna, karauk Parisi roat akas Jisas aurin, “Näu ro, nan tamareäum roat awarota, asoraurai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisas nukas ätäi awarowon, “Is epar senes awarom, ak asorna, okoro aiauk apu opok rai akasar urweanik, Anut nukan enip jou muraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Jisas ko Jerusalem mena aparmara, wouti näwäu momara, äiewon, “Ak rusapai owo onok woiaka päurar rawaun äpu maiei, kiro eposek. Utianik, okoro onok ämäi rau, ak aparau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Karauk omre päiei, nan iwäi jaunat akas kasiaka penuk, pe erekapu aru musaiei. Ak aiaukus porim ate miäi senek, karaima karaima karirim katoisaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Akas peanik, na erekapu aru musianik, nan roasiret kiro opok rai erekapu akwarona, meiäiei. Kar aiauk kiro opok rau kon omoi utona, wa rawai. Anut nukas ak imwarau kowon, ak äpu mau wa. Keserianik, kiro usu owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Keser äianik, Jisas nuka Jerusalem mena tonowon. Jisas ko tup ou näwäu owa tonomara, roat osap kau me rain emwaronuk, erekapu imine manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Kos awarowon, “Meter Anut nukan ämän jer we moin, ‘Anut nukas äiewon, “Isan ou kiro roasiret akas is pak aräun ou, utianik, akas okoro päu roat akan ämäi rawaun omoi senek sare moin.” ’” ");
INSERT INTO bbr2013_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Omre orip orip, Jisas ko kiro tup owa tone raumara, Anut nukan ämän roasiret tamareäu. Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak roasiret kamwareäi roat näunäu akas Jisas wäun rai ämän ate rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Utianik, ak kiro onok keseraun kar apu aparau wa. Owon, roasiret ak orip orip Jisas nukan ämän roiäi. Ak kon kar ämän utaun senek itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","2","Kar omre opok, Jisas ko tup ou näwäu owa roasiret tamareanik, Anut nukan Ämän Eposek mare rawon. Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak karauk kamwareäi roat näunäu, akas pemana, Jisas aurin, “Na owo sakau oianik, kiro onok keseriäum? Inokos na sakau isowon? Na ik aik.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Jisas nukas ätäi keser awarowon, “Isas nais ak totwaraurim, is airowe, Jon ko an jomareäwon ro, ko Anut nukas sakau nuruwon ra, ara, roat akas sakau nurin?” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Keseria, aka aka areanik, äiein, “Ik ko owo räi aurau? Utianik, ko Anut nukan sakau pakas an jomareäwon äieta, kos äiäi, keseria, ak owon akan woiaka epar mau utoi rai aikai. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Utianik, ik ko ro pakan sakau orip äieta, okoro roasiret akas ik aiaukus iwoikona, meiäm, owon, ak Jon ko Anut nukan ämän roianik, areäu ro rai sakau ronkateäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kesermana, akas äiein, “Jon inokos sakau nuruwon ik äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jisas nukas ätäi awarowon, “Is nais, inokos is sakau ironuk, kiro onok keseriäim ak wa awaram.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisas nukas kiro totok ämän roasiret maromara, awarowon, “Kar ro ko wain woi momara, karauk roat kiro woia sarau maun kau mareanik, sarau mona mona, nuka omsau atapuk pote om ses rumukäu rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wain nemauk murunuk, owaun ses penuk, kiro woi atak ros kon kar sarau ro kiro wain woia sarau me rain roat rawa karauk wain nemauk oi nuruna, oi kowaun rai, äsimornuk, potowon. Utianik, kiro woi kame rain roat akas kiro sarau ro wemana, wain nemauk wäpik orip erar äsimorna, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Keserna, ätäi kar sarau ro äsimornuk, potowon. Ko nais keseriar wemana, aru murianik, erar äsimorna, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Keserna, kos ätäi kar äsimornuk, potowon. Ko nais keseriar keserin. Ak ko nais weanik, kasik känkurena, nowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Keseria, kiro wain woi atak ros äiewon, ‘Is owosäu? Isan mokoi karar isan woias konun meieäim äsimoram. Ak kon ämän roumoi, wa aru muraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Keseria, kon mokoi karar äsimornuk, potowon. Kiro roat akas kon mokoi aparmana, aka aka äiein, ‘Kiro woi atak ron mokoi kou. Kon momok meienuk, kos kon momokun osap erekapu owai, okon, ik ko weta, meienuk, okoro wain woi iken saräi. Kir ik kesernam.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Keseria, ak kiro mokoi wain woian imäi neanik, woi kasakupai wena, meiewon. Jisas nukas totwarowon, ‘Kiro wain woi atak ros kiro sarau roat owoswarai? ");
INSERT INTO bbr2013_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ko koumara, kiro sarau roat erekapu akwaronuk, meiena, kiro wain woi karauk roat akan ipiakap marai.’” Roasiret ak kiro totok ämän roumana, äiein, “Kiro onok wa keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisas nukas ak sakau apwareanik, totwarowon, “Kiro ämän Devit nukas meter jer wewon, kon onoktapau owo senek? ‘Kiro ou tutu ou miäin roat akas aru äumoi, sauk moin. Rusapai, kiro ou tutu kamuk opokan ou tutu sakau eposek sarewon.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","‘Inok roasir kiro tutu opok siotorai, kiro roasir erekapu pitpatir usipnirnaräi. Kiro tutus kar ro opokup nonuk, kiro ro ko maimai senek saräi.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sintore ämän tamareäi roat pak Anut kamuk raiäi roat näunäu akas Jisas kiro opokar sakau ataurin, owon, ak äpu ko kiro totok ämän akan onok mesin awarowon. Ak roasiret iminewareanik, ak ko sakau atau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Keseria, ak karauk roat kau marianik, äsimwarona, koin. Kiro roat akas ik roat eposek äiäun rai sätäumana, Jisas apari rain. Ko owo ämän sät äienuk, sakatianik, omsau akan ro näwäu opok imäi potaun rai keserin. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Kiro kau maroin roat akas pemana, Jisas totorin, “Näwäu, ik äpu nan ämän ätär mukiäum, kiro epar. Ik äpu na roat näunäu wa iminewareäum, na Anut nukan onok karar epar ätär mukiäum. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nan ronkat owo senek? Moses nukan sintore ämän opok, ik Rom akan kamwarau ro näwäu aiauk nuraun itok ra, wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","24","Jisas nukas ätäi akan sät ämän äpu momara, awarowon, “Is kar aiauk ätär murowe. Okoro aiauk opok inokon totok enip orip rau?” Akas ätäi aurin, “Sisa* nukan.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jisas nukas awarowon, “Owo osap Sisa nukan kiro Sisa nuruwe, owo osap Anut nukan kiro Anut nuraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ak roasiret akan amiakap kon ämän roin sakau atau senek wa, ak kon ämän awarowon roianik, ronkat sosop oi rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","28","Karauk Juda akan roat näunäu, enmaka Sadusi*, akas äiäi, roat meiäi ätäi wa siräiäi rai äiäi. Karauk Sadusi roat akas pemana, Jisas aurin, “Näwäu, Moses nukan sintore ämän opok keser jer wewon, ‘Kar ro kon wau mokoi wäpik meie ute manonuk, kon amakus awakun wau oumara, mokoi mai. Kiro mokoi meiewon ron senek saräi.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Utianik, kar muti kar ro kon mokoit 7 orip. Mokoi urektapau asik oumara, ko mokoi wäpik meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Keseria, kon amakus kiro asir owon. Ko nais mokoi wäpik meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Keseria, kar amunakas kiro asik owon, ko nais mokoi wäpik meiewon. Keseriar pote kiro roat 7 orip kiro asik oin erekapu mokoi wäpik, meiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kiro roat erekapu meiena, kiro asir ruris meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kiro asir roat 7 oripas oin, tawa meiein roasiret siräiäiei omre opok sirauna, kiro inokon asir rawai? Omnokou opok, kiro roat 7 orip meiein akas kiro asir karar oin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jisas nukas ätäi awarowon, Rusapai roasiret awau rai rai ak epar ouratäiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kiro roasiret eposek ak meieanik, tawa awau orip orip rawaun siräiäiei, ak ätäi wa ouratäiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ak Anut nukan sarau eitek senek saremoi, ätäi wa meiäiei. Ak meieanik, siräiein, keseria, ak Anut nukan mokoit asinakut awau orip orip rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moses nukas roat meiein, siräiäi mesin äiewon. Rusapai kiro ämän amop rau. Meter ep arou am eteinak opok jeremara, ko Anut enip keser mianik, äiewon, Apraham, Aisak, Jekop akan Eit. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Keseria, Anut ko roat meiein akan Eit wa, roat orip orip awau raiäi akan Eit. Kon amuk opok kiro askanai meiein ak erekapu awau rai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Karauk sintore ämän tamareäi roat akas äiein, “Näu ro, kiro ämän äiem eposek.” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Keseria, kar ros Jisas kar ämän ätäi totoraun iminein. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisas nukas roasiret awarowon, “Owon roasiret akas Krais ko Devit nukan Mokoi äiäi? ");
INSERT INTO bbr2013_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Devit nukasar Buk Song opok keser jer wemara, äiewon, ‘Anut Näwäu nukas isan Näwäu auruwon, “Na isan ipi näu kaima taneta, isas nan iwäi jaunat erekapu itimwareanik, nan isonap mareita, nan inkaruru rawaiei.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Devit nukasar ‘Krais ko isan Näwäu’ äiewon, keseria, owoseanik, akas ko kon mokoi äiäi?” ");
INSERT INTO bbr2013_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","46","Roasiret ak erekapu ämän roi rauna rauna, Jisas nukas kon tamareäu roat awarowon, “Ak sintore ämän tamareäi roat akan onok jekur aparwe. Kiro roat ak omjo eposek mianik, nepipir ariai. Roasiret akas kiro roat apu opok ra, amket opok ra pe apwarea, uoraka sur wena, kiro roat aka nepipiriäi. Ak Juda roasiret akan tururiäi owa ra, o jaun omoi ra pemoi, tanäun omoi eposek oiäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kiro roat akas wäimäs asiret sätwareanik, akan owan osap erar oi maneäi. Karauk roat akan amiakap nais ak Anut aurianik, ämän rumukäu miäi. Tawa, Anut nukas koi wasarewaraun ses opok, kiro roat ak usu näwäu senes owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisas ko tup ou näwäu owa raunuk raunuk, roat osap sosop orip akas aiauk Anut nuriäi tup owan bokis uru mona, apwarwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kar wäimäs asir pemara, aiauk eteinak oirori, 2 toia senek, Anut nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisas ko kiro aparmara, äiewon, “Is epar senes awarom, okoro wäimäs asir ko aiauk näwäu senes mowon. Kos karauk roasiret erekapu itimware rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Okoro roasiret erekapu ak akan aiauk sosop rau, karauk aiauk karar oumoi, Anut nurin. Utianik, okoro asir ko aiauk wäpik senes. Ko kon aiauk erekapu Anut nuru, ko o kau maun kar aiauk rawau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Karauk Jisas nukan tamareäu roat akas äiein, “Aiauk eposekus ou ate moin pak mer eposek roat akas Anut nurin pak aparwe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Jisas nukas ätäi awarowon, “Kiro osap ak rusapai apari, omre päi opok iwäi jaunakat akas koianik, kiro ou erekapu aru maiei. Kiro ou moin aiauk erekapu uräi naiei. Kar aiauk kon omoi wa rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jisas nukan tamareäu roat akas ätäi totorin, “Näwäu, kiro onok esepa päi? Owo onok amke penuk, kiro ik äpu mam?” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Kos ätäi awarowon, “Ak jekur apai rawe. Karauk roat akas ak sätwaraiei. Roat sosop akas pemana, isan enim atea, keser äiäiei, ‘Is Jisas ätäi imwaraun ro pe raim.’ ‘Omre rusapai peu,’ äiäiei. Ak kiro roat pote wa tainwarau. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ak marai kowai ämän pak marai jejep pak siarakap kounuk, roumoi, ak wa karkairau. Kiro onok epar amke päi. Utianik, wasarewaraun ses kiro kurte wa pekeräi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Keseria, kos ätäi awarowon, “Kar omsau pakan roasiret akas siräianik, kar omsau pakan roasiret pak iwäi muratäianik, weräiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Okoro omnokou opok mim näwäu omsau atap atap päi. Karauk omsau sou näwäu senes päi. Karauk omsau sip näwäu atap atap päi. Omar oik onok atap atap pak iminäun osap pak päi ak aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Utianik, kiro osap kurte wa päi. Amke akan iwäi jaunakat akas ak sakatwareanik, aru maraiei. Ak isan tamareäim roat isan ämän are ariaiei, okon, ak tururiäi owa akan ämän roianik, karapus owa maraiei. Ak imwarea, omsau kamwareäi roat näunäu akan ipiakap maraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ak kiro onok kesewarona, akas isan ämän eposek awaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Kiro omre kurte wa päi opok, akan woiaka päurar moinai, owo ämän aräun ronkat sosop wa mau. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Owon, isakasar kiro ämän pak ronkat eposek ak aram. Keserita, akan iwäi jaunakat akas ak sät ämän moi rai wa awaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Akan momonakat, aninakat, aunakat, amunakat pak akan kinjaunakat pak akan jaunakat akasar, ak akan iwäi jaunakat akan ipiak opok maraiei, karauk ak akwarona, meiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ak isan tamareäim roat, okon, roasiret erekapu ak mesin kasiaka peanik, sauk maraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Utianik, ak jekur rawaiei, akan tapiaka urik erekapu eposek rawai, karar wa siräi nai. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ak sakau tai rawe. Keserna, akan totomaka orip orip awau rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jisas nukas ätäi äiewon, “Ak Jerusalem kon iwäi jaukut akas pe karirim katorna, aparia, ak äpu maiei kiro Jerusalem mena rusapai erekapu aru maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Keserna, roasiret ak Juda provins rai omtorou oik imine manaiei. Roat ak Jerusalem mena raiäi, kiro mena ute kasik imine manaiei. Jerusalem mena kasakup raiäi roat, kiro mena wa tonaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kiro omre usu näwäu ses päi, kiro Anut nukas roat akan onok aru miäi ätäi amuk arai. Meter Anut nukan ämän areai roat akas jer wein, kiro epar päi. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kiro ses opok, asiret amaiwo orip pak asiret mokoit apur jerai orip ak wopuräiei. Usu näwäu okoro omnokou opok päi. Anut nukas kasak pemara, kiro roat aru marai. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Karauk roat weräianik, siräpis akwarona, meiäiei. Karauk roat karapus maraun imwareanik, kar omsau potaiei. Keseria, kar omsau pakan roasiret akas okoro mena pe oi rauna rauna, pote Anut nukasar akan ses patarai äiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisas nukas ätäiar äiewon, “Tawa san, keir, päi opok onok atap atap päi. Okoro omnokou opokas urir näwäu mas an opok siräienuk, roasiret ak kiro roumoi, erekapu iminäiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Roasiret ak kiro osap omnokou opok päi rai kame raianik, ronkat sosop mia, akan woiaka uru näwäu iminäiei. Amiaka koririrai, owon, omar oikan osap sakau rain erekapu ritratorai. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kiro onok kesernuk rai, roasiret akas Ro Nukan Mokoi omar oik iou pakas sakau näwäu orip arou pakas kounuk, aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kiro osap penuk penuk, ak sakau tai rainai, wa iminäu, ak omar oik eisane rawe, owon, Anut ak imwaraun ses ki kou.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Keseria, Jisas nukas ätäi kon tamareäu roat kar totok ämän awarowon, “Ak am suarou pak karauk am ronkatewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Utianik, am suarou käienuk, kiro ak äpu miäi, kiro san tawaun ses pera. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kiro keseriar, ak kiro onok atap atap penuk, ak äpu maiei, Anut kamwaraun ses pe rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Is epar senes awarom, okoro roat rusapai rai ak wa meiäiei opok, kiro kesek onok päi, ak aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Okoro omar omnokou pak erekapu wasaräieir, utianik, isan ämän wa wasaräi, orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Ak jekur tai rawe. Warnuk, ak an sakau orip orip jaiei kiro raiaka käiäi. Ak okoro omnokou pakan osapun ronkat sosop owaiei. Keseria, kiro onokus ak aru mare raunuk raunuk, kiro omre opok Anut Näwäu nuka kurte koi ak tarwarai. Kiro mukus opur weäi senek kesewarai. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Kiro onok, roat erekapu okoro omnokou rai opok päi. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ak omre orip orip jekur sakau tai raianik, Anut nukas ak sakau araun orip orip auraiei. Keserna, kiro onok ak opok penuk, ak wa aru marai. Ak Ro Nukan Mokoi amukup jekur tai rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Omre orip orip, Jisas nukas roasiret Anut nukan ämän tup owa tamareäu. Pututu ko omtapau enip Olivet kiro opok ninau poteäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Roasiret ak Jisas nukan ämän rowaun orip orip taperar poteäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","2","Kar tup enip Pasowa*, roasiret bret jis wäpik orip jeäi omre pe raunuk, Anut kamuk raiäin roat näunäu pak sintore ämän tamareäi roat pak akas roasiret iminewareanik, Jisas wena, meiäun ronkat ämäi ämäi oin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas Iskariot ko kar Jisas nukan tamareäu ro. Satan nukas Judas nukan wou uru tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kesernuk, Judas ko Jisas pak karauk tamareäu roat rain utwaromara, Anut kamuk raiäi roat näunäu pak roat tup ou kameäi pak rawa pote Jisas owose akan ipiakap maraun awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ak kiro ämän roumana, ak nepipiria, akas ko aiauk nuraun rai a atoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ko ior äumara, ko owose Jisas roat näunäu akan ipiakap maraun apu itane rawon. Keseria, kar omre roasiret sosop wa tururiäi opok ak ipiakap maraun kame rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Kiro omre bret jis wäpik jeäi omre pewon. Kiro ses opok, Juda roasiret ak sipsip nak mantapau wemoi, patan opok amkea, Anut jou muriäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Keseria, kiro omre penuk, Jisas nukas Pita Jon ori äsimwatomara, keser awatowon, “Au potoinair, sumaun omre enip Pasowa opok o jaun omoi jekur mower.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Awas ätäi auririn, “Ik erapok o jekurau?” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Kos ätäi awatowon, “Au kiro mena potaieir opok, kar ro ko an oremara, pea, au tarwatai. Kiro ro owa tonai opok tainori tonower. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Tonoinair, kiro ou atak ro aurwer, ‘Iken Näwäus na aisou, isan tamareäim roat pak sumaun omre opok o jaun ou waru erapok rau?’ ");
INSERT INTO bbr2013_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Keser aursa, kos ou waru kar näwäu kämioik rau ätär matonuk, au kiro opok ik o jaun omoi jekur mower.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Au poteanik, Jisas nukas awatowon siar aparianik, kiro owa o jaun omoi jekur moirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasowa o jaun ses penuk, Jisas kon tamareäu roat pak o jaun tanein. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Kos awarowon, “Isan woias ak pak is amke okoro o jeita, epar tawa tätäi näwäu senes oita, meiäm. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Is epar senes awarom. Is kiro pasowa o ätäi wa jam. Anut okoro omnokou kamäun amop kowai ses opok kiro epar ätäi jam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Keseria, Jisas nukas kap oumara, Anut aurmara, äiewon, “Okoro an wain kap orip oinai, akasar aka aka je nurate pote. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Is epar awarom, is tawa okoro wain nemauk pakan an wa jam. Tawa Anut okoro omnokou kamäun amop kounuk, kiro epar is ätäi jam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Keseria, ko bret oumara, Anut ‘pere’ aurianik, ipous pararianik, kon tamareäu roat aromara, äiewon, “Ak oinai, jeie. Okoro isan enimsau. Is okoro onok keserim apari ak tawa isanun ronkateinai, isan enim pakas keseriar pote keserwe.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ak o je kurena, bret keserwon senek, wain an kap orip oumara, äiewon, “Okoro wain an kiro isan karian, Anut nukan paip awau kiro opok pasar rau, kiro ak arom, jeie. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Utianik, inokos is isan iwäi jaiat ipiakap murai, kiro ro ko is pak erek tane rau. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ro Nukan Mokoi ko kiro apu meter Anut nukas sare muruwon tainori manai. Utianik, kiro ros kon iwäi jaukut akan ipiakap marowon kiro ro ko wopur.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Keseria, kon tamareäu roat aka aka äiein, “Kiro onok inokos keserai?” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisas nukan tamareäu roat aka aka ketäumoi, äiein, “Inok ik kamuk opok ro näwäu?” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisas nukas awarowon, “Okoro omnokou pakan kamwareäi roat ak roasiret akan sarau roat senek kamwareäi. Kiro roat näunäu akas äiäi, ‘Ik iken roasiret jekur kamwareäum.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ak kiro onok senek wa keserau. Ro ak kamuk opok näwäu rau ko mokoi eteinak senek rawai. Akan kamwaraun ro näwäu ko sarau ro senek rawai. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Inok ro ko näwäu? Kiro ro tane raumara, o jaun urweäu. Ko ro näwäu ra? Ro o wemoi, oi koiäu, ko ro näwäu ra? Kiro ro tane raumara, o jaun urweäu ko epar ro näwäu. Utianik, is akan ro näwäu is ak kamuk sarau ro senek sarwaroram. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Is opok usu näwäu peäwon, ak is pak orip orip raianik, is wa utoire maneäi. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Keseria, isan monias ak kamwaraun sakau irowon senek isas nais ak karauk roasiret kamwaraun sakau arom. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Keseria, ak isan mena taneanik, isan patan pakan o pak an pak jaiei. Ak nais kamwareäi roat akan sia opok tanea, Israel akan tupsiu 12 orip akan onok wasarewaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisas nukas äiewon, “Saimon, Saimon. Satan nukas ak wit nemauk seperiäi senek na ate apaisaun Anut nukas auruwon siar keserai. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Is nan won sakau maun rai Anut aurimin. Nan won ätäi is opok pirirmoi, is siarap koumata, nas ätäi nan sarau jaunat akan woiaka sakau mar.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita nukas ätäi Jisas auruwon, “Näwäu, is na pak karapus owa potea, meiäun raim.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jisas nukas Pita ätäi auruwon, “Is epar senes aisom, Rusapai pututu, kakarau urwäu wa opok, nas isan enim ämäi momata, ‘Is ko äpu wa’ rai 3 orip äiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Keseria, Jisas nukas kon tamareäu roat awarowon, “Kar muti is ak Anut nukan ämän roasiret awaraun äsimwaromin opok, ak kar aiauk ra, jo ra, su ra wa oi manaiei, ak kar osap owaun ronkatein ra?” Akas ätäi äiein, “Ik kar osapun ronkatäu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jisas nukas ätäi awarowon, “Rusapai kiro onok atap, inok ro ko aiauk orip ra, jo orip ra, ko kiro owai. Inok ro ko siräp rumukäu wäpik, ko kon kar omjo karauk roat aronuk, kau mona, ko kiro pakan aiauk oumara, kar siräp rumukäu kau mai. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Is epar awarom, meter jer weanik, äiein, ‘Akas kiro ro ko onok aru miäi roasiret pak turur maiei.’ Kiro jer wein ämän epar rusapai is opok päi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kon tamareäu roat akas ätäi äiein, “Näwäu, siräp rumuk oirori okoro rau.” Kos ätäi awarowon, “Ak kiro ämän ekep wa mau äiäk.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jisas kiro mena utia, kar omtapau enip Olivet ko kiro opok orip orip maneäu opok potonuk, kon tamareäu roat akas ko tainori potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Kiro mena potea, kos keser awarowon, “Ak orip orip Anut aurna, Satan nukas ak wa ate apwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Keseria, ko ak utwareanik, kar ros ai wäun aiauk atapuk känkurenuk, poteäu senek opok potomara, kon uou sur wemoi, Anut auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Kos äiewon, “Moni, nakasar okoro usu is opok rau jäkäi mo. Utianik, na isan ronkat wa tainorau, nan ronkat karar tainor.”  ");
INSERT INTO bbr2013_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kesernuk, Anut nukan sarau eitekus omar oikas koumara, ko sakau muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisas ko usu näwäu owaun ronkatemara, Anut sakau auruwon. Kesernuk kesernuk, kon musas karian senekus omnokou opok nowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ko Anut auri kuremara, siräianik, pote kon tamareäu roat rain opok potowon. Ak woiaka aru mianik, erekapu ninoin apwarwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Kos rurawaremara, awarowon, “Ak owon ekep nini rai? Siräinai, Anut aurwe. Keserna, Satan nukas ak wa ate apwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jisas nukas kon tamareäu roat are maronuk maronuk, roat näunäu sosop, Judas tainori pote Jisas sakau atau potoin. Judas ko Jisas nukan tamuriäu ro. Kos amke Jisas siakup potomara, oktokorowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jisas nukas totorwon, “Judas, na Ro Nukan Mokoi kon iwäi jaukut akan ipiakap maraun koi oktokorum ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kon tamareäu roat akas kiro onok keserin aparia, äiein, “Näwäu, ik ak pak weräiäun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Keseria, karas siräp rumukäu oumara, Anut kamuk raiäwon ro näwäu senes nukan sarau ro wem raiar kon rauk näu kaima patir kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jisas nukas kiro onok aparmara, awarowon, “Kiro onok wa keserau.” Keseria, kos kiro ron rauk käu ate oi monuk, ätäi kon rawon senek sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Keseria, Jisas nukas Anut kamuk raiäi roat pak roat näunäu pak tup ou kameäi roat pak awarowon, “Ak weräiäun utupauk pak siräp pak oianik, is päu ro senek sakatoirianik, iworaun koi ra? ");
INSERT INTO bbr2013_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Is tup owa omre orip orip ak pak raiäimin, ak kiro opok atoiraun utiäin. Utianik, rusapai kiro akan ses. Okoro omnokou pakan pututu ko sakau orip.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Keseria, Jisas sakau ate oumoi, Anut kamuk raiäu ro näwäu senes nukan owa imäi potoin. Pita ko potonar, ämäi ämäi keres keres potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Karauk roat akas ep kasik tukurin, Pita ko karauk roasiret kiro ep uke rain opok potomara, erek ep uke rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kar sarau asires ep arou opok kon nepu jekur aparmara, äiewon, “Is äpu okoro ro ko Jisas pak ariäwon ro.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pita nukas ätäi äiewon, “Is kiro ro äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Rai rai, kar ros kon nepu aparmara, äiewon, “Na nais kon tamusiäu ro.” Kos ätäi äiewon, “Is kon tamuriäu ro wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ätäi rai rai kar ros äiewon, “Okoro ro ko Jisas pak ariäu is äpu. Ko Galili provins pakan ro.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kos sakau momara, äiewon, “Na kiro ämän aurem kiro is äpu wa.” Ko keser äienuk äienuk, kakarau urwewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Kesernuk, Näwäu nukas pirirmara, Pita sakamarwon. Pita ko Jisas nukas meter auruwon ämän ätäi ronkatewon. ‘Rusapai pututu kakarau urwäu wa opok, na isan enim ämäi momata, is ko äpu wa rai 3 orip äiäm.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ko kiro ämän ronkatemara, kasik nomara, wouti monuk, näwäu waiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Kiro roat Jisas kame rain akas ko jeje ämän aurianik, mänkäsioin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kon amuk omjos pararar momoi, sipou purianik, totorin, “Na äu, inos na iwosou?” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Keseria, jeim arianik, karauk aru ämän aurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Om teinenuk, tapera, roat näunäu pak Anut kamuk raiäi roat näunäu pak sintore ämän tamareäi roat pak erek tururia, wasarewareäi roat näunäu opok Jisas imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Akas totorin, “Na Krais, Anut nukas äsimoisonuk, koumon ra?” Kos ätäi awarowon, “Utianik, is Krais awaroita, akan woiaka epar wa maiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Isas ätäi ak totwaroita, akas isan ämän ätäi wa airaiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Tawa Ro Nukan Mokoi ko Anut sakau näwäu orip nukan ipou näu kaima tane rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Akas ätäi aurin, “Keseria, na Anut nukan Mokoi ra?” Kos ätäi awarowon, “Io, aka äiäi senek, is Anut nukan Mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Keseria, akas äiein, “Ik karauk roat kamware rauta, akas koi kon enkup kar ämän wa maiei. Owo ämän nukan oksaus ämän äienuk, roumun. Nukan ämänisar nuka wasare murai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","2","Keseria, roat näunäu ak erekapu siräianik, Jisas Pailot nukan amuk opok imäi potea, kon enip opok ämän sätäia, äiein, “Okoro ro kos iken roasiret akan ronkat aru mia, awareäu ak takis aiauk wa mau rai, äienuk, roiäumun. Kos äiäu, is Krais, roasiret kamwaraun ro näwäu rai awareäu. Keseria, ik na siatap imäi koum.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailot nukas Jisas totorwon, “Na Juda roasiret akan kamwaraun ro näwäu king ra?” Jisas nukas äiewon, “Kiro naka äiem senek.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailot nukas Anut kamuk raiäi roat pak roasiret turur rain pak awarowon, “Is okoro ros kar onok aru mowon aparau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Akas ätäi sakau ämän mianik, keser äiein, “Kos roasiret amiakap onok aru ätär mareäu. Ko Judia provins erekapu keserwon. Ko Galili provins opok onoktoreanik, rusapai Jerusalem mena keserau kou.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailot ko kiro ämän roumara, totwarowon, “Okoro ro ko Galili provins pakan ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Akas ko Galili provins pakan äiein roumara, kos Herot siakup äsimorwon. Herot ko Galili provins kameäwon ro näwäu. Kiro ses opok, ko kon mena utomara, Jerusalem mena pote rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Jisas ko Herot rawa imäi potona, Herot ko Jisas aparmara, näwäu nepipirwon, owon, ko Jisas nukan enip roiäu, om ses rumukäu ko owose aparam rai rawon. Ko Jisas nukas karauk kurur atap atap kesernuk, aparaun ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Keseria, kos Jisas ämän sosop totorwon, Jisas nukas kar ämän ätäi aräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Anut kamuk raiäin roat akas tonomana, Jisas nukan enip opok sät ämän sosop moin. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herot kon marai roat pak, akas Jisas ir murianik, jeje ämän sosop aurin. Keseria, Herot nukas kon marai roat awaronuk, kon omjo eposek Jisas orke muria, ätäi Pailot rawa äsimornuk, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herot Pailot ori au meter iwäi rairin, rusapai kiro ses opok au jaiateir. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","14","Herot nukas Jisas ätäi Pailot rawa äsimornuk, kos Anut kamuk raiäi roat näunäu pak kamwareäi roat näunäu pak roasiret erekapu pak urwarnuk, koi tururna, Pailot nukas awarowon, “Akas okoro ro ätäi is siarap imäi koianik, roasiret onok aru ätär mareäu rai airoin. Is akan amiakap totormin is kos kar onok aru mowon aparau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Utianik, Herot ko nais keseriar keserwon. Ko Jisas nukas onok aru mowon aparwon maro, kos is jer we murunuk, aparwom. Okoro ro ko kar onok aru mau wa, ko owon erar wena, meiäi? ");
INSERT INTO bbr2013_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Isan marai roat awaroita, mänkäsi oumoi, utona, manai.”  ");
INSERT INTO bbr2013_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Akan onok, Pasowa* sumaun omre opok orip orip Pailot nukas kar karapus ro utonuk, maneäu. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Roat erekapu akas urweanik, äiein, “Bar-Abas erar utota, manai. Jisas weta, meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Meter kiro mena roat akan kamwareäwon ro näwäu pak weräianik, Bar-Abas nukas kar ro wenuk, meiewon. Keseria, ko karapus owa kurena, rawon.) ");
INSERT INTO bbr2013_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pailot nukas ätäi Jisas utonuk, manaun roasiret awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Roasiret akas ätäi urweanik, sakau äiein, “Ko am äpäs opok we mota, meiäura.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pailot nukas ätäi awarowon, “Ko owo onok aru keserwon? Is kos kar onok aru keserwon aparau wa. Ko erar weta, meiäun itok wa. Is isan marai roat awaroita, mänkäsi oumoi, utona, manai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Akas ätäi kakaparar urweanik, äiein, “Ko am äpäs opok we mota, meiäura.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Keserna, Pailot nukas roasiret akan ämän tainorwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pailot nukas Bar-Abas kiro ro kar ro wenuk, meiewon utonuk, manonuk, ko Jisas marai roat akan ipiakap marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Rom akan marai roat akas Jisas am äpäs opok wäun apu opok imäi potona potona, kar ro ko Sairini menas näu mena tonaun kowon. Kon enip Saimon. Apu opok tararia, sakau atea Jisas nukasar kon am äpäs ämäi potowon kiro oianik, Saimon ämäi muruna, Jisas tainori potowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Roasiret sosop Jisas tainori potoin. Kiro kamuk karauk asiret ko aparmana, woiakati maronuk, konun waiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jisas nukas ätäi pirirmara, awarowon, “Jerusalem asiret. Ak isanun woiakati momoi, wa waiäu, ak akan mokoit pak aka mesin waiewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ak jekur rowe, tawa kiro omre päi opok aka äiäiei, ‘Asiret ewit ak nepipiraiei. Asiret ak mokoi mau wa ak nais nepipiraiei. Asiret ak mokoi apur wa jeäi ak nais nepipiraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Keseria, kiro ses opok, roasiret akas omtapau näunäu awaraiei, ‘Ik koi, tonoike mowe.’ Akas omtapau eteinak awaraiei, ‘Ik koi kururur mukia, ämäi mukowe.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Utianik, ak ro eposek keser aru muruna, ak ro aru opok owo onok kesewaraiei?” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ro oirori au meter onok aru moirin nais Jisas pak meiäun kiro mena erek imwate potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Kiro mena enip Golgota, enip onoktapau kiro kesek, ‘op tapau sekerem’. Kiro opok peanik, Jisas pak kiro ro oirori au onok aru moirin erek am äpäs opok äsäiware maroin. Kar ro Jisas nukan ipou näu kaima äsäi moin, kar ipou saunan kaima äsäi moin.  ");
INSERT INTO bbr2013_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisas nukas äiewon, “Moni, kiro onok keseri, ak äpu wa, nas akan onok aru jäkäi mar.” Keseria, marai roat akas aiauk oianik, satu sipiräieanik, kon omjo aka inäi owaun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Roasiret ak tai rai Jisas apai rauna rauna, kamwareäi roat näunäu akas ko ir muria, jeje ämän aurin, “Ko karauk roasiret sarwareäwon. Ko Krais kiro ro Anut nukas äsimornuk, kowon maro, nukasar nuka saräun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","37","Rom akan marai roat akas nais ko pe jeje ämän aurmana, wain an tiu nurianik, aurin, “Na epar Juda roasiret akan kamwareäum ro näwäu ra, na am äpäs utoinam, no.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Kon tapau opok keser jer we moin, ‘Okoro ro ko Juda roasiret akan kamwareäu ro näwäu king.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Kiro ro aru oirori erek am äpäs opok äsäi matoin, karas Jisas jeje ämän keser auruwon, “Na Krais ra roi, nakasar nan enmatsau sareinam, iu sareit.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ro karas jauk kermara, auruwon, “Na Anut iminäu utom ra? Ik erekapu usu karar oum. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Iu kiro usu oumur kiro itok, owon iu onok aru momurin, kiro meiäun itok. Okoro ro ko kar onok aru keserau wa ko ro eposek erar meiäun itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Keseria, kos ätäi Jisas auruwon, “Jisas tawa na ik kamoikau kowaun ses opok na is ronkateir.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisas nukas kiro ro auruwon, “Is na epar paip musom, rusapai na is pak omar oik rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sankeu san näu kamuk, san jeräu wa, omnokou erekapu pututu sare pote, 3 klok iukärir. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","San jerau wa opok, kiro omjo tup ou näwäu owa äsäi moin rawon oikas kiräi nopte oirori sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jisas nukas urwemara, äiewon, “Moni, rusapai isan totom nan ipon opok musom.” Ko keser äiemara, kon osou nukasar utomoi, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Marai roat akan kamwareäu ro näwäu ko kiro onok aparianik, Anut nukan enip jou murmara, äiewon, “Epar senes, okoro ro ko onok aru wa miäu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Roasiret ak owo onok penuk, apwaraun koi tururin, ak kiro onok aparmana, ak woiakati näwäu maronuk, ätäi akan mena ute manoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisas nukan jaukut pak asiret Galili provins pakas Jisas tainori koin ak erek atapukas tai raianik, kiro onok keserin apai rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kar ro kon enip Josep ko Arimatea menan, Judia provins raiäu. Ko roasiret amiakap ro eposek raiäu. Ko Juda kamwareäin roat näu näu akan sarau jaunaka. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Ko karauk roat näunäu akan ronkat Jisas wena, meiäun äiein akan ämän tainorau wa. Ko Anut okoro omnokou kamäun ätäi kowai rai kame raiäwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Kiro ro ko Pailot siakup potomara, Jisas nukan kopeu oumoi, up uru kuräun totorwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Keseria, kos Jisas nukan kopeu am äpäs opokan oumara, omjo ärneus kururur murianik, aireu uru moin. Kiro up aiauk näwäu uru tuein. Kiro uru meter kar ro up kuräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Kiro Fraide, osap jekuraun ses opok keserin. Tup etei, kiro Juda akan sumaun ses. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kiro asiret meter ak Galili provins pakan Jisas tainori koin, ak erek Josep tainori potea, kiro aireu uru Jisas nukan kopeu owose maiei rai ak apari rain. ");
INSERT INTO bbr2013_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Keseria, kiro asiret ak ätäi akan mena potea, am anakas sou eposek päun jekur mianik, sumaun omre penuk, ak sintore ämän tainorianik, sumoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Tup Näu opok, taperar senes asiret ak kiro am anakas sou eposek ate moin oianik, Jisas nukan enipsau opok joutor muraun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Poteanik, kiro aiauk näwäus Jisas nukan up oksau pene moin erororin aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Keseria, ak kiro up uru tonea, Jisas nukan kopeu aparau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ak kiro onok keserwon aparianik, ronkat sosop oi rauna rauna, Anut nukan sarau eitek oirori awan omjo ärneu senes orip kurte pemasa, amiakap tai rairin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Merek näwäus akan amiawa senirnuk, kiro asiret ak iminemoi, akan totomaka manonuk, ak omnokou apai rauna rauna, kiro sarau eitek ories awaroirin, “Ak owon ro awau raiäu meieäin roat akan mena itanerai? ");
INSERT INTO bbr2013_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ko okoro opok rawau wa, ko siräi manowon. Ak kiro ämän meter Galili provins opok raumara, awarowon ronkatewe. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Ro Nukan Mokoi sakau ateanik, onok aru miäi roat akan ipiakap marona, akas ko am äpäs opok wena, meiäi. Omre 3 opok ko ätäi siräiäi.’” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kesernuk, ak kiro ämän Jisas nukas meter äiewon ronkatein. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Keseria, kiro asiret akas up utia, kiro osap aparin erekapu karauk roat pak kon tamarowon roat 11 orip turur rain opok pote awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Kiro asiret akan enmaka kiro, Maria ko Magdala menan, Joana, Jems nukan anak Maria, karauk asiret pak erek potoin, akas kiro onok aparin, Jisas nukan tamariäwon roat awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Utianik, kiro roat akan ronkat kiro asiret ak sätäi räumoi, ak woiaka epar mau wa.  ");
INSERT INTO bbr2013_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Utianik, Pita ko kiro ämän roumoi, siräumara, kurte kiro up opok potomara, kiro up uru omjo ärineu karar aireu uru rawon aparwon. Ko ätäi owa potomara, kiro onok keserwon, ronkat sosop oi rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kiro omre opok, Jisas nukan tamariäwon roat oirori au kar om enip Emeas mena potoirin. Kiro menas Jerusalem mena potaun atapuk wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Au aukarar apu opok pote rai, kiro onok pewon are are potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Au are potosa potosa, Jisas nukas awan mekesirawap pemara, tainwate erek potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Au ko jekur kon nepu aparau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jisas nukas totwatowon, “Au oworäi are potorair?” Kos keser totwatonuk, au awan woiaka uru usu sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ro karan enip Kliopas nukas ätäi auruwon, “Na kar menan ro rusapai Jerusalem mena koumon, okon, na kiro onok umara pewon na äpu wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Kos ätäi totwatowon, “Owo onok umara pewon?” Awas ätäi auririn, “Kiro onok Nasaret menan Jisas opok keserwon. Ko Anut nukan ämän areäu ro näwäu. Anut nukan amukup pak roasiret erekapu akan amiakap kon sarau pak ämän pak sakau senes. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Iken Anut kamuk raiäi roat näunäu pak kamoikeäi roat näunäu akas sakau ateanik, am äpäs opok wena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Iken ronkat kos ik Israel roasiret imäikau kou äiemun. Rusapai tapera omre 3 opok kar onok pewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Karauk asiret ik pak erek raiäi akas ik aikona, ik karkairmun. Ak tapera senes up opok potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ak kon enipsau aparau wa. Akas ätäi koianik, ik aikoin, Anut nukan sarau eitek ories Jisas ko ätäi siräiewon aikoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Keseria, iken roat karauk kiro up opok potea, asiret akas awaroin siar aparin. Ak kon enipsau aparau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Keseria, Jisas nukas awatowon, “Awan ronkat rumukäu wäpik. Meter Anut nukan ämän roianik, areai roat akas kiro ämän äiein, au awan woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Au äpu wa ra? Krais ko tätäi näwäu oumara, tawa ätäi ko Anut nukan sakau owai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kos Moses nukan ämän pakaima onoktoroi awatomara, karauk Anut nukan ämän roianik, areai roat akan ämän pak awatowon. Kos nuka mesin jer wein ämän onoktapau erekapu awatowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ak Emeas mena siakup pein. Jisas ko sätäumara, ko kar apu pakas manaurwon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Awas au pak rawaun sakau ateanik, auririn, “Om irai, okon, na ik pak ne ninam, na wa manau.” Keseria, ko tonomara, au pak rawon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","O jaun ses, Jisas nukas bret oianik, Anut aurmara, bret eneanik, kiro roat ori atowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Au kiro onok kesernuk, aparia, au äpu moirin kiro Jisas karar. Keseria, ko kiro pakasar ämäiewon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Kesernuk, au awaka awaka äieirin, “Iu apu opok komurin, kos kiro ämän onoktapau Anut nukan ämän opokas aitowon, kiro omre opokar iwen woiok siräiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Au kiro ämän areanik, kiro omre opokar siräianik, Jerusalem mena ätäi potoirin. Poteanik, Jisas nukan tamariäwon roat 11 orip pak karauk jaunakat pak erek owa turur rain opok pote tarwaroirin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Kiro owa rai roat akas kiro roat ori awatoin, “Epar senes Näwäu ko ätäi siräiewon. Saimon ko aparwon.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Keseria, kiro ro ories ätäi kiro onok apu opok pewon erekapu awaroirin. Awas äieirin, “Kos bret ene itonuk, iu ko äpu momurin.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kiro roat ories kiro onok aparirin arena arena, Jisas nukasar kurte ak kamuk opok pemara, awarowon, “Akan woiaka päurar rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Akas karkairmana, iminein, owon, akan ronkat ak op aparum äiein. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kos ätäi awarowon, “Ak owon, karkairianik, iminei? Owon ak ronkat sosop ourai? ");
INSERT INTO bbr2013_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ak isan ipi isi ek aparwe, okoro isaka pe raim. Ak isan ipi atoinai, ak äpu maiei. Op akan enmaksau is apairoi senek wa.”  ");
INSERT INTO bbr2013_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ko keser awaromara, kon ipou pak isou pak ätär marowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ak erar nepipirin. Utianik, ak akan woiaka epar mau wa, ak ronkat sosop oi rain. Kos totwarowon, “Ak karauk o jaun rau ra?” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Akas was jerewon oi koi nurin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ko kiro was oumara, akan amiakap jenuk, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Kos awarowon, “Is okoro onok meter ak pak raia, kiro ämän awaromin. Kiro osap meter is mesin Moses nukan sintore ämän jer pak Anut nukan ämän roianik, areain roat akan ämän pak Buk Song opok jer wein päi awaromin, rusapai epar peu.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kos akan ronkat are rawa ak Anut nukan ämän awarowon äpu moin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kos awarowon, “Kiro ämän opok keser jer wein, ‘Krais ko tätäi näwäu oumoi, meieanik, ätäi omre 3 opok siräiäi.’ ");
INSERT INTO bbr2013_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kon enip opokas kon ämän roasiret marona, akan woiaka pirirna, Anut nukas akan onok aru jäkäi marai. Ak kiro sarau Jerusalem mena onoktoraiei. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Akas okoro onok akan amiakas apari omsau erekapu pote awarowe. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Kiro Osou Näu isan Monias ak araun paip marowon, kiro isas rusapai äsimorita, ak opok kowai. Ak Jerusalem mena rauna rauna, kiro Osou Näus koi ak sakau marai.” ");
INSERT INTO bbr2013_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","51","Keseria, Jisas nukas kon tamariäwon roat imwaromara, Betani mena manowon. Kiro opok kon ipou oik momara, kon tamariäwon roat jekur rawaun ämän aware aware utware manowon. Anut nukas ko omar oik imäi tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kesernuk, kon tamarowon roat woiaka ererwon orip, ätäi Jerusalem mena potoin. ");
INSERT INTO bbr2013_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ak orip orip Anut osap nuriäi owa raianik, Anut auria, jou muri rain.");
INSERT INTO bbr2013_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Meter meter Anut ko okoro omnokou ate mau wa opok, Ämän rawon. Kiro Ämän ko Jisas. Ämän ko Anut nuka pak rawon. Ämän ko nukasar Anut. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ko meter meter Anut nuka pak atakan orip orip raiäwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Kiro Ämänis osap erekapu ate mowon. Karauk osap ko amukmuti kar apu pakas päu wa. Osap erekapu pewon Ämänisar ate mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Awau atakan orip orip rawaun sakau ko opok rau, kiro atakan rawaun sakaus arou roasiret maronuk, apariäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Kiro arous pututu merek kurenuk, merek sareäu. Pututus kiro arou itimorau senek itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kar ro pewon. Kon enip Jon. Ko Anut nukas äsimornuk, kowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Kos roasiret kiro arou mesin awarau kowon. Kesernuk, roasiret erekapu ak kiro ämän roianik, akan woiaka kiro ämän mesin epar maun awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Jon nuka ko kiro arou wa. Ko erar kiro arou ruris pera, kon ämän amke okoro omnokou opok roasiret kiro arou mesin awarau kowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kiro arou epar. Kiro arou peras okoro omnokou pakan roasiret erekapu arou kurwarnuk, akan woiaka uru merek kuräi. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Kosar okoro omnokou ate mowon. Ko okoro omnokou opok koi rawon, utianik, okoro omnokou pakan roasiret ak ko äpu mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ko kon urek sarewon mena potowon, utianik, kiro opok kon tupsiu akas nepipirianik, ko imäiäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Keserna, karauk roasiret akan woiaka epar moin akas ko imäiein. Keseria, kos kiro roasiret akan woiaka konun epar moin imwareanik, ak Anut nukan mokoit asinakut sare marowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ak Anut nukan mokoit saräun ak okoro omnokou pakan momonakat akan karianas atware mau wa. Anut nukan Osou Näus ate marowon, okon, Anut nuka karar akan momonaka. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kiro Ämän ro senek äräräumara, ik kamuk opok koi rawon. Kos kon wou näu oripas, ik sareikeanik, kon epar onok ätär mukowon. Ko kon momok, Anut, nukan mokoi karartapau. Keseria, momokun sakau näwäu oi kounuk, ik kiro sakau aparmun. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jon nukas ko mesin äiewon. Kos roasiret keser awarowon, “Is kiro ro mesin meter keser awareäimin, ‘Kar ro ko is mekesirap ruris pera, ko isan Näwäu. Is päu wa opok ko rawon.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ik roasiret eposek wa, utianik, kon wou näu oripas ik orip orip sareikeanik, jekur kamoikeäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Anut nukas kon sintore ämän Moses nukan ipokup monuk, kos roasiret kiro ämän tainoraun awariäwon, utianik, Anut nukas Jisas Krais* äsimornuk, kon wou näu oripas sareikonuk, kon mokoi nukas kon onok epar pak kon wou näu pak ätär mukowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Kar ros Anut nukan nepu aparau wa. Anut nukan mokoi karar ko ran Anut, okon, ko momok siakup raumara, kos ik momok ätär mukiäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Juda* roat näunäu akas Jerusalem menas karauk Anut kamuk raiäi roat* pak karauk Liwai roat pak erek äsimwarona, pote Jon totorin, “Na ro inok?” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Keserna, Jon nukas kiro ämän ämäi mau wa, kos roasiret erekapu rauna ämän amop awarowon, “Is Krais* wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Akas ätäi totorin, “Keseria, na inok? Na Anut nukan ämän roianik, areäum ro Elaija ra?” Kos ätäi awarowon, “Wa.” Akas ätäi totorin, “Na Anut nukan ämän roianik, areäum ro* Anut nukasar sare musowon ik kume raumun ro ra?” Kos awarowon, “Wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Akas ätäiar keser totorin, “Keseria, nakas ik aik, nan ronkat na inok? Ik roat näunäu akas äsimoikona, koumun, ik ämän ätäi oi pote awaram, okon, na inok ro raroi nakasar aikam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jon nukas keser äiewon, “Meter Anut nukan ämän roianik, areawon ro Aisaia nukas keser jer wewon ‘Kar ron pätus ro wäpik mena om puru opok urwemoi, keser äieu, “Näwäu nukan apu jekur sare muruwe. Kon apu tuku sare muruwe.” äiewon.’ Is kiro ro.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Karauk Parisi* roat akas kiro roat äsimwarona, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Akas ätäi ko keser totorin, “Utianik, na Krais Anut nukas kon roasiret ätäi imwaraun sare musau wa, na Elaija wa, na kiro Anut nukan ämän roianik, areäum ro nais wa raroi, keseri, na owon roasiret an jomariäum?” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","27","Jon nukas ätäi keser awarowon, “Is roasiret anas an jomareäim. Utianik, kar ro ak kampai tai rau ak ko äpu wa, kiro ro ko is mekesirap ruris koura, utianik, ko ro näwäu, is ro eposek wa, okon, is kon isou pakan su oi kuräun kiro itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Betani mena, Jordan an kasakup karaima, san peäwon pakaima kiro opok, Jon nukas roasiret an jomareäwon opok, kiro onok erekapu pewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ninoinus, tapera, Jon ko Jisas kounuk, aparmara, äiewon, “Ak aparwe, enro ro ko Anut nukan sipsip nak senes. Kos okoro omnokou pakan roasiret akan onok aru miäi jäkäi maraun kou. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Is kiro ro mesin meter ämän marea, awaromin, ‘Kar ro ko is mekesirap ruris pera, ko isan ro näwäu awaromin, owon, is päu wa opok, ko rawon.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Isakasar kiro ro ko inok is äpu wa, utianik, is koi Israel* roasiret ko ätär maraun an jomareäim.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Jon nukas ätäiar äiewon, “Is Anut nukan Osou Näu omar oikas, ai manap senek, koumara, ko pak rawon aparmin. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Isaka nais is ko äpu wa, utianik, Anut nukas roasiret akan onok aru pakan piriraun anas an jomaraun sarau irowon. Kos airowon, ‘Isan Osou Näu koi kar ro pak raunuk, na äpu mam, kiro ro karar kos roasiret Osou Näus an jomarai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jon nukas ätäiar äiewon, “Is kiro onok keserwon isakasar aparmin. Is epar senes awarom, ko Anut nukan Mokoi senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ninoinus, tapera, Jon nukan tamareäu ro oirori Jon nuka pak ätäi kiro opok tai rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ko Jisas potonuk, aparmara, äiewon, “Aparwe, kiro Anut nukan sipsip nak senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kiro tamareäu roat ori au Jon nukas kiro ämän awatowon roumasa, au Jisas tainori manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisas nukas kiro roat ories ruris tainori potoirin pirir apwatomara, totwatowon, “Au owo itaneir?” Awas ätäi auririn, “Näu ro, tamukiäum ro, na erapok raiäum?” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Kesersä, kos ätäi awatowon, “Au aparau pewer.” Keseria, au ko tainori potea, kon raiäu ou aparirin. Aparia, au ko pak pote ninoirin. Owon? Kiro omre iukärir senes, om iraun siakup. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andru ko Saimon-Pita nukan amak, ko jauk ori koirin. Ko Jon an jomareäu ro nukan ämän roianik, jauk ori Jisas tainoririn. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Tapera ko Jisas nukan ou utia, amke potomara, kon awak Saimon tararmara, auruwon, “Ik Mesaia aparmun.” (Kiro enip Mesaia Ibru ämän, Grik ämänis Krais äiäi. Ko kiro ro Anut nukas kon roasiret ätäi imwaraun sare mowon.) ");
INSERT INTO bbr2013_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andru nukas Saimon Jisas siakup imäi potonuk, Jisas nukas aparmara, äiewon, “Na Saimon, Jon nukan mokoi. Tawa nan enmat Sifas rawai.” (Kiro enip Sifas pirirmoi, Pita äiäiei. Kiro enip nukan onoktapau kiro ‘aitapau’.) ");
INSERT INTO bbr2013_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Jisas ninowonus, tapera, ko Galili provins opok potaun ronkatewon. Ko poteanik, kar ro enip Filip tararmara, auruwon, “Na pe, is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip ko Betsaida menan. Kiro Andru Pita orien mena. ");
INSERT INTO bbr2013_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Kesernuk, Filip pote, Nataniel tararmara, auruwon, “Ik kar ro tararmun. Meter Moses nukas sintore ämän buk opok kiro ro mesin jer wewon pak, karauk Anut nukan ämän roianik, areain roat akas nais ko mesin jer wein. Kon enip Jisas, Nasaret menan, Josep nukan mokoi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniel nukas äiewon, “Nasaret mena kiro eteinak. Kar osap eposek Nasaret menas kowai ra?” Kesernuk, Filip nukas ätäi auruwon, “Na peinam, apar.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nataniel ko Jisas siakup potonuk potonuk, Jisas nukas aparmara, äiewon, “Aparwe! Okoro ro kou, ko Israel ro tuku senes. Ko kar sät ämän wa miäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniel nukas ätäi Jisas ko totorwon, “Na is owose äpu murom?” Jisas nukas ätäi auruwon, “Is na Filip urweisau wa opok, na am uran siakup tane raumon apaisomin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniel ko kiro ämän roumara, auruwon, “Näu ro, tamukiäum ro, na Anut nukan Mokoi, na Israel roasiret kamwaraun ro näwäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisas nukas ätäi auruwon, “Is na am uran siakup tane raumon aisomin mesin na won epar mom ra? Tawa nan amunas kurur näunäu atap atap aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jisas nukas ätäiar auruwon, “Is na epar senes aisom, tawa omar im tuenuk, Anut nukan sarau eitek* raut Ro Nukan Mokoi rawa tone koi, tone koi, rauna, na apwaram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Omre oiroror manonuk, Jisas nukas Filip Nataniel ori urwatowon, kar mena enip Kena, Galili provins opok, kar ro omre 3 opok, asir owon. Jisas nukan anak ko kiro roasir ori ourateirin awan owa rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ak Jisas kon tamareäu roat nais erek kiro roasir ori ourateirin owa kowaun urwarona, koi rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ak wain an erekapu patarna, Jisas nukan anakus Jisas keser auruwon, “Roasiret wain an patar kurein.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jisas nukas ätäi auruwon, “Ani, is na owo onok keseraun wa air. Isan sarau maun omre päu wa rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Kon anakus ätäi wain an kameäi sarau roat awarowon, “Kos ak owo ämän awaronuk, ak kiro ämän tainorwe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Kiro owa mis näunäu 6 orip rawon. Kiro Juda akan onok an jowaun keseriäi. Kiro mis näunäu karar karar, dram näwäu senek. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jisas nukas tamareäu roat awarowon, “Okoro mis uru an erekapu ok pe mowe.” Akas kon ämän roumana, kiro mis uru an äräinein. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Keserna, kos awarowon, “Karauk an ore oinai, pote, kiro o kameäu ro nuruwe.” Keseria, akas kiro an oremoi, oi pote nurin. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","10","O kameäu ro ko kiro an oi potoin jewon. Kiro an wain etäiewon. Ko äpu wa ak kiro wain an erapakan oin. Kiro sarau roat ak karar erapakan oin ak äpu. Keseria, kiro o kameäu ros asir awau owon ro urwenuk, kounuk, keser auruwon, “Roat ak amke wain eposek arona, jeäi, kiro wain eposek erekapu jena, tawa wain eposek wa arona, jeäi. Utianik, na okoro wain eposek mota, rawon, rusapai oi koum!” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kiro kurur, Jisas nukas amke Kena mena, Galili provins opok, kon sakau näwäu ätär maronuk, kon tamareäu roat ko mesin akan woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kiro keser kurea, Jisas kon anak amakut pak kon tamareäu roat pak Kena mena ute, Kapaneam mena potea, kiro opok om rumukurar rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kiro ses opok, Juda roasiret akan tup aparaun omre Ijip omsau ute koin ronkateäi tup, enip Pasowa* siakup pe raunuk, Jisas ko Jerusalem näu mena potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ko Anut osap nuriäi tup ou näwäu* uru tonomara, roat akas bulmakau, sipsip, ai raut oumana, kiro tup owa aiaukun karauk roat arona, akas kau mona, aiauk oi rain opok tone apwarwon. Karauk roat aiauk amuk weäi nais erek tone rain apwarwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Keseria, kos karauk mur oumara, im sakau irkiemoi, kiro opur raut erekapu tup owan emwaronuk, manoin. Kiro roat aiauk amuk weäi roat akan patan erekapu kour kure maronuk, akan aiauk erekapu mane kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Kiro roat akas ai raut aiaukun karauk roat araun rain kos sakau ämän awarowon, “Kiro osap erekapu oi manowe! Ak isan monian ou kiro amket maun mena senek wa sare mau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kon tamareäu roat akas Jisas nukas kiro ämän äiewon roumana, kar ämän Anut nukan buk opok rau ätäi ronkatein. Kiro ämänis keser äieu, ‘Is nan ou tuku jekur eposek rawaun mesin woi uruas ep senek jerenuk, okon, is sarau sakau moram.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Juda roat näunäu akas Jisas nukas kiro onok keserwon aparmana, ätäi totorin, “Na ik owo kurur ätär mukota, ik äpu mam, kiro na Anut nukas sakau isowon?” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jisas nukas ätäi awarowon, “Utianik, akas okoro Anut osap nuriäi tup ou näwäu uräuna, isas omre 3 orip ätäi siräi mam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Akas ätäi totorin, “Nan ronkat, na okoro tup ou näwäu omre 3 orip maun itok ra? Roat ak okoro ou moin woisan 46 orip utomoi, patarin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Utianik, Jisas kiro tup ou mesin äiäu wa, ko nukan enipsau mesin äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Keseria, Anut nukas Jisas meiewon ätäi siräi murunuk, kiro ses opok, kon tamareäwon roat akas kiro ämän kos meter awarowon ämän kiro ätäi ronkatein. Anut nukan ämän kiro nuka mesin jer wein rawon pak Jisas nukas awarowon ämän mesin pak akan woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisas ko Pasowa omre opok, Jerusalem näu mena raumara, kurur atap atap kesernuk, roasiret sosop ak kiro aparianik, akan woiaka ko mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Utianik, Jisas ko kiro roasiret mesin kon wou epar mau wa, owon, akan woiaka uru akan ronkat äpu mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ko nukasar kiro roasiret akan woiaka uru owo senek rau äpu marowon, okon, kar ros kiro roasiret akan onok mesin aurau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kar ro enip Nikodimas, ko kar Juda roasiret akan ro näwäu. Ko Parisi ro. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kar pututu, ko Jisas rawon owa potomara, keser auruwon, “Näu ro, ik äpu na tamukiäum ro näwäu. Anut nukasar na äsimoisonuk, koumon. Na kurur atap atap keseruram senek kar ros keserau senek wa. Anut nukasar kiro ro pak raunuk, epar ko kiro kurur keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jisas nukas ätäi auruwon, “Is epar senes aisom. Inok ro ko ätäi awau wa saräi, kiro ro ko Anut nukan kamwaraun mena kamäun wa aparai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimas nukas ätäi Jisas totorwon, “Ro ko urek sarewon owose ätäi mokoi eteinak saräi? Ko ätäi anak wou uru tonomoi, ätäi awau saremara, naun senek itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jisas nukas ätäi äiewon, “Is epar senes aisom. Inok ro ko an pak Anut nukan Osou Näu orip an jowau wa, ko Anut nukan kamwaraun omoi wa tonai. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Roat ak akan enmaksau momonakat aninakat pakan oiäin, utianik, Anut nukan Osou Näus iken totomok awau orip orip rawaun sakau ikiäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na okoro ämän aisom mesin ronkat sosop wa owau. Ak ätäi awau sarewe. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Urir ko nukasar pemara, maneäu. Na kon jejep karar roiäum, utianik, ko erapakas pemara, manou, na äpu wa. Kiro senek, roasiret erekapu ak Anut nukan Osou Näus awau sarein ak keseriar keseraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimas nukas ätäi auruwon, “Kiro onok owose päi?” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jisas nukas auruwon, “Na okoro Israel omsau pakan roasiret tamareäum ro näwäu, na owose kiro onok äpu mau wa? ");
INSERT INTO bbr2013_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Is na epar senes aisom. Ik kiro ämän rusapai aisoram kiro ik erekapu äpu mianik, aparmun. Utianik, ak kiro ämän rowaun utoi. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Is ak okoro omnokou pakan onok awaromin woiaka epar wa mona rai, omar oikan onok awaram nais woiaka epar wa maiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Okoro omnokou pakan kar ro omar oik wa tone rau. Wa, Ro Nukan Mokoi karar ko omar ute kowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Meter Moses nukas ro wäpik mena, om puru opok, män totok amauk opok, äsäi mowon senek, roat akas Ro Nukan Mokoi nais keseriar keseraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Keseria, inok roasiret ak ko mesin akan woiaka epar miäi akan totomaka awau orip orip rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Anut nukas okoro omnokou pakan roasiret mesin wous meiemara, kon mokoi karartapau äsimornuk, kowon. Ko kiro onok kesernuk, inok roasir ko mesin wou epar mai, ko wa meiäi, kon totok orip orip awau rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Owon, Anut nukas kon mokoi okoro omnokou opok roasiret wasarewaraun ro senek Anut nukan amukup ak ämän orip awaraun äsimorau wa, utianik, ko roasiret akan onok aru pakan imwaraun äsimorwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Inok roasir ko kon mokoi mesin wou epar mowon ko Anut nukan amuk opok ämän wäpik. Utianik, inok roasir ko mesin wou epar mau wa, ko ämän orip. Owon, ko Anut nukan Mokoi karartapau mesin wou epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Anut nukas okoro omnokou pakan roasiret keser wasarewarai; Anut nukan arou merek okoro omnokou opok kowon, utianik, okoro omnokou pakan roasiret ak erekapu okoro omnokou pakan onok aru mianik, pututu rawaun woiakas meieäi. Akan woiaka uru onok aru maun karar keseriäi. Keseria, ak kiro Anut nukan arou mesin woiakas meiäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Inok roasiret onok aru miäu, ko Anut nukan arou merek owaun utai. Kiro arou merekus ko onok aru miäu amop muraurnuk, iminemara, kiro arou merek opok wa kowai. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Inok roasir ko onok eposek keserai, ko arou merek opok peäu. Owon, kiro roasir sarau monuk, kiro karauk roat akas ko aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kiro keser kureanik, Jisas ko kon tamareäu roat pak Jerusalem näu mena utia, Judia provins opok pote om rumukurar raumara, roasiret an jomareäwon*. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jon ko nais kar an enip Ainon, Salim mena siakup roasiret an jomare rawon. Kiro mena an sosop rau, roasiret sosop ko rawa nona, kos an jomare rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Kiro ses opok, Herot nukas Jon ko karapus owa kuräu wa opok, ko keser ari rawon.) ");
INSERT INTO bbr2013_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jon nukan tamareäu roat pak kar Juda ro pak ak Anut nukan amukup eposek saräun an joiäi onok mesin ketäiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Keseria, Jon nukan karauk tamareäu roat akas potomana, Jon keser aurin, “Tamukiäum ro, naka meter kiro ro mesin äiemon Jordan an kasakup san peäwon pakaima naka pak rawon ätäi ronkate. Rusapai, roasiret erekapu ko rawa potona, kos an jomarora.” ");
INSERT INTO bbr2013_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jon nukas ätäi awaromara, äiewon, “Kar ro ko nukasar kar onok keseraun senek itok wa, utianik, Anut nukas sakau nurunuk, epar kiro onok keserai. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ak meter ‘Is Krais wa’ awaromin roin, utianik, Anut nukas is amke äsimoirnuk, koimin. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Kar ros asir ounuk, kiro asir kon wau. Ak rowe, kiro ron jaukut akan jaunaka kon asir ori are raunuk, roumana, nepipiriäi. Keseriar kiro ro kounuk, is nepipirim. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Kon enip näwäu saräi, isan enim eteinak saräura. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Kiro ro ko omar oikas kowon kos karauk roat erekapu itimware rau. Okoro omnokou pakan roasiret ak okoro omnokou pakan osap mesin areäi. Kiro ro ko omar oikas kowon, kos okoro omnokou pakan roasiret erekapu itimware rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ko nukasar kon amukus osap aparwon pak karauk ämän raukus rowon pak roasiret awareäu, utianik, roat sosop kon ämän roianik, woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Inok ro kon ämän jekur roumara, tainorai, ko owo ämän Anut nukas äiäu kiro epar senes amop murai. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kiro ro ko Anut nukas äsimorwon, ko Anut nukan ämän eposek miäu, owon, Anut nukas kon Osou Näu erekapu nuriäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Momokus kon mokoi mesin wous meieanik, kon sakau erekapu kon ipokup mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Inok roasir ko kon mokoi mesin wou epar momoi, kon ämän jekur tainornuk, kon totok orip orip awau rawai. Utianik, inok roasir ko kon ämän sumkäinenuk, kon totok orip orip rawaun sakau wa owai. Anut nukas ko mesin orip orip kasak pe raunuk, usu nuriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jisas nukas Jon itimormara, roasiret sosop an jomaronuk, ko tainori rai kiro karauk roat akas Parisi roat awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Utianik, Jisas nukas roasiret an jomarau wa, kon tamareäu roat akas an jomareäin.) ");
INSERT INTO bbr2013_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Keseria, Näwäu nukas kiro ämän roumara, ko Judia provins utomara, ätäi Galili provins potowon, ");
INSERT INTO bbr2013_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ko kiro apu tainori, Samaria provins pakas potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Keseria, ko Samaria provins opok, kar mena enip Sikar pewon. Kiro mena, kar omnokou meter Jekop nukas kon mokoi Josep utomuruwon siakup rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kiro mena kar an oreäi up meter Jekop nukas up tue mowon rawon. Jisas ko apu rumukäu koianik, enip usu sarewon. San näu kamuk, okon, ko pemara, kiro an up siakup tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Kon tamareäu roat ak erekapu näu mena o kau maun manona, Jisas nukarar kiro opok rawon. Raunuk, kar Samaria* asir ko an oräu nonuk, Jisas nukas kiro asir auruwon, “O asir, is an pätirou, na an ore irota, jam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Kesernuk, kiro asires ätäi auruwon, “Na Juda ro, is Samaria asir, na owon is an isaun totoirom?” Juda roasiret ak Samaria provins pakan roasiret pak ak iwäi senek raiäi, ak karar jaiate wa raiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jisas nukas ätäi auruwon, “Asir, na Anut nukas owo osap isaun paip musai, pak is pak äpu murom maro, na is airam, ‘Na is an irota, jam.’ Keserta, is na orip orip awau rawaun an isam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Kiro asires ätäi auruwon, “Näu ro, okoro an up uru upisa rau, na an oräun baket wäpik. Keseria, na kiro an orip orip awau rawaun äiem erapakan oräu? ");
INSERT INTO bbr2013_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Okoro an up iken askanai Jekop nukas utomukowon. Ko kon mokoit pak kon opur raut pak ak erekapu kiro an ore jeäin. Nan ronkat Jekop ko ro eteinak, na ro näwäu ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jisas nukas ätäi auruwon, “Roasiret ak okoro an jeanik, ätäi an pätwarai. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Utianik, inok roasir isas an nurita, jai, ko ätäi an wa pätirai. Kiro an isas nuram, kiro kon wou uru, an unik ok pe raiäu senek, raunuk, ko orip orip awau rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Kiro asires ätäi Jisas auruwon, “Näu ro, is kiro an irota, jam. Keserita, is ätäi an wa pätirai. An oräun ätäi wa kowam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jisas nukas ätäi auruwon, “Na potoinam, nan komut imäinam, ätäi koi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Kiro asires ätäi auruwon, “Is ro wäpik.” Jisas nukas auruwon, “Naka ro wäpik äiem, kiro epar senes airom. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Owon, meter na roat 5 orip owaromon. Kar ro rusapai na pak rau, kiro nan komut senes wa. Na kiro ämän airom, kiro epar.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Kiro asires ätäi auruwon, “Näu ro, rusapai is na äpu musom, na Anut nukan ämän roianik, areäum ro. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Iken asanokot ak okoro omtapau opok tururia, Anut jou muriäin. Utianik, ak Juda roasiret akas Jerusalem näu mena karar Anut jou muraun äiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Keseria, Jisas nukas kiro asir auruwon, “Asir, na isan ämän mesin nan won epar mo. Kar omre päi ses opok, roasiret ak iken momonek okoro omtapau opok ra, Jerusalem näu mena ra, wa jou muraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Utianik, ak Samaria roasiret, ak Anut jou muriäi, utianik, ak ko jekur äpu mau wa. Ik Juda roasiret ik ko äpu mianik, jou muriäum. Owon, Anut nukas amke Juda roasiret pakaima okoro omnokou pakan roasiret imwaraun paip mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Kar omre päi, roasiret akan woiaka epar senes moin, ak epar apu tuku tainorna, Osou Näus sarwarnuk, ak moni rapor jou muraiei. Epar, kiro omre rusapai pe rau. Isan monias roasiret ak kiro onok pakas jou muruna, apwareanik, kon wou näu saräi. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Anut ko osou. Keseria, roasiret akas ko jou muraun kon Osou Näu kararas ak sarwarnuk, ak epar apu tainorianik, ko jou muraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Kiro asires Jisas auruwon, “Is äpu Krais kowai. Kos koianik, onok erekapu ätär mukai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Kesernuk, Jisas nukas ätäi äiewon, “Kiro is karar. Rusapai is na pak areram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ko kiro ämän arenuk arenuk, kon tamareäu roat ätäi koianik, kiro asir pak are rawon aparmana, karkairin. Utianik, kar ros keser wa totorwon, ‘Na owo osap owaurmata, areram? Na owon kiro asir pak areram?’ ");
INSERT INTO bbr2013_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","29","Keseria, kiro asires kon an oräun mis kiro opok utomoi, mena potomara, roasiret awarowon, “Ak kar ro aparau pewe. Kos is owo onok meter kesermin erekapu amop muri airowon. Akan ronkat ko Krais ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Keseria, kiro roasiret akas akan näu mena utia, Jisas aparau potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Kiro ses opokar, kon tamareäu roat akas Jisas o jaun rai sakau aurin, “Näwäu, na o je.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Utianik, kos ätäi awarowon, “Is o orip, kiro o ak äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kesernuk, tamareäu roat aka aka areanik, äiein, “Kar ros ko o omuri kowon ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisas nukas keser awarowon, “Isan o kiro Anut nukan sarau okoro omnokou opok maun äsimoirnuk, koimin, kon sarau pataraun ronkat tainoruram. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Karauk roat akas keser äiäi, ‘Keir 4 orip utia, o awau woian owau,’ utianik, is ak epar senes awarom, woi jekur amiakas aparwe! Awau woian o näu murianik, urek newon owaun itok. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Inok ro ko kiro woian o oiäu, Anut nukas totok orip orip awau rawaun sakau ko nurai. Keseria, inok ro o uku weäu pak, inok ro o näu woian oiäu pak, au erek nepipiraieir. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Kiro ämän äiäi epar senes, ‘kar ros o uku wenuk, kar ros awau woian o oiäu.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Is ak äsimwaroita, kiro woia ak sarau wa miäi opok erar pote o owaiei. Karauk roat akas sarau näwäu moin pakan, ak akan o owaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Samaria provins pakan roasiret sosop akan näu mena rain ak Jisas mesin akan woiaka epar moin, owon, kiro asires Jisas nukas kon onok meter keserwon ämän erekapu auri kurewon mesin awaronuk, roin. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Keseria, Samaria roasiret Jisas siakup koumana, ko ak pak rawaun aurin. Keseria, ko ak pak omre oirori rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","42","Roasiret sosop ak kon ämän roumana, akan woiaka epar momana, kiro asir aurin, “Ik nas ämän aikomon roumun kiro mesin iken woiok epar mau wa, owon, ikasar kon ämän roumoi, iken woiok epar mukou. Ik äpu ko karar epar okoro omnokou pakan roasiret onok aru miäi pakan ätäi imwaraun ro koi rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisas kon tamareäu roat pak kiro mena omre oirori utomana, ätäi Galili provins potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jisas nukasar äiewon, “Anut nukan ämän roianik, areäu ro ko nukan omsau opok kon enip jou wäpik, okon, kon ämän tainorau utoi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Utianik, ko Galili potonuk, kiro pakan roasiret nepipirianik imäiein, owon, ak Pasowa omre opok Jerusalem näu mena toneanik, kurur atap atap kesernuk, aparaun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Keseria, Jisas Kena mena meter an wain senek etäiwon mena ätäi potowon. Kar gavman ro näwäu Kapaneam mena kon mokoi sip orip rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ko Jisas Judia provins pakas Galili kowon roumara, ko potomoi, kon mokoi Kapaneam mena meiäurnuk, jekuraun rai totorau potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jisas nukas roasiret rain awarowon, “Ak, woiaka epar wa miäi roasiret. Ak kurur atap atap aparianik, kiro ses karar akan woiaka epar maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kiro ro näwäu nukas auruwon, “Näu ro, na is pak wa kouta rai, isan mokoi meiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Kesernuk, Jisas nukas auruwon, “Na wa iminäu, na ätäi pot, nan mokoi wa meiäi, awau rawai.” Kiro ro ko Jisas nukan ämän mesin wou epar momara, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ko apu opok, potonuk potonuk, kon sarau roat akas kurte koianik, aurin, “Nan mokoi meiäu wa, eposek rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kos totwarowon, “Owo ses opok, ko eposek sarewon?” Akas ätäi aurin, “Kukam sankeu, san näu kamuk, kon sip ute manowon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Keseria, momokus kiro ses opakar Jisas nukas ‘Nan mokoi awau rawai’ auruwon ätäi ronkatewon. Keseria, nuka pak kon tupsiu pak erek akan woiaka Jisas mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Meter Jisas nukas Judia provins utomoi, Galili provins koianik, kar kurur mowon. Kiro ses opok, ko ätäiar koumoi, kiro kurur keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Keser kurea, Jisas ko Juda roasiret akan kar tup aparaun omre penuk, ko Jerusalem näu mena tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Kiro menan porim rorok, enip Sipsip akan ororok siakup, kar an unik enip, Betesda rawon. (Kiro enip Ibru ämänis.) Kiro an kasakup ou rumukäu 5 orip rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Kiro owa sip roasiret sosop, amiak utup roasiret, isiaka aru roasiret pak roasiret isiaka meiewon pak rain. Ak kiro an amuk iriraun kume raiäin. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ak kiro keseriäi, owon, karar muti karar muti Anut Näwäu nukan sarau eitek kiro an unik uru nonuk, an amuk irirnuk, aparia, inok sip ro amke kiro an opok nonuk, kon sip manai. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kiro opok, kar ro woisan 38 orip siräi manau senek wa rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisas ko kiro ro rawon aparwon. Ko kiro ron woisan rumuk sip orip rawon äpu mianik, kiro ro totorwon, “Nan ronkat na ätäi eposek saräun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Kiro sip ros ätäi auruwon, “Näu ro, okoro opok an amuk iririäu opok kar ros is sareirianik, imäiri ne an opok kureiraun ro wa. Is nam raitar, karas kurte neäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Kesernuk, Jisas nukas auruwon, “Na siräinam, nan pasar oinam, ute man.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kiro ses opokar kiro ron sip ute manonuk, ko kurte siräianik, kon pasar oumara, manowon. Kiro omre Juda akan sumaun ses, enip Sabat. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Keseria, Juda roat näunäu akas kiro sip ro eposek sarewon aurin, “Okoro sumaun omre, iken sintore ämänis äieu ‘Na nan pasar sumaun omre opok wa ämäi ariäu.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Kiro sip ros ätäi awarowon, “Kiro ro is jekuri mowon, nukas ‘Na nan pasar oinam, man’, rai airowon, okon, is kesermin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Akas ätäi totorin, “Kiro ro inos aisonuk, na kiro onok kesermon? Ik kiro ro ätär muk.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Utianik, kiro ro eposek sarewon ko inokos jekur mowon nuka nais äpu wa. Roasiret sosop kiro opok rauna, okon, Jisas ko kiro kamukas manowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kar omre opok, Jisas nukas kiro ro tup ou näwäu owa tararmara, auruwon, “Na rou, na rusapai eposek sarem, keseria, na ätäi ätäi onok aru wa keserau. Na keserta rai, ätäi usu näwäu senes owam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kesernuk, kiro ros Jisas äpu momoi, potomara, Juda roat näunäu Jisas nukas ko jekur mowon rai pote awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jisas ko sumaun omre opok kiro onok keserwon, okon, Juda roat näunäu ak Jisas aru muraun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisas nukas awarowon, “Isan moni ko orip orip sarau mora, okon, is nais sarau moram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Keseria, kiro ämänis Juda roat näunäu siräi maronuk, ak kasiaka näwäu penuk, Jisas wena, meiäun keserin. Ko sumaun omre nukan sintore ämän itimorwon, pak nukasar awarowon, ‘Anut isan moni’. Ko kiro ämän keser äiewon, ko nukasar isaka Anut äiewon. Akan ronkat ko onok aru oiroror mowon, okon, ak ko wena, meiäun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Keseria, Jisas nukas akan ronkat äpu momara, ätäi keser awarowon, “Is ak epar senes awarom, Mokoi ko kar onok kon ronkat pakaima keserau wa, ko kon Momokus owo onok kesernuk aparmara, kon Mokois keseriar keseriäu. Owo onok Momokus kesernuk, kon Mokois nais keseriäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Momokus kon Mokoin wous meiemara, owo onok nukas keseriäwon siar kon Mokoi tamuriäu. Ko kon Mokoi onok eposek senes ätär murunuk, ak ko kiro onok keserai aparianik, karkairaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Momokus meiäi roat siräi mareanik, totomaka awau orip orip rawaun ariäu senek, kon Mokois nais kon ronkat pakas karauk roat keseriar kesewarai. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Momokus roasiret wa wasarewarai. Kiro sarau erekapu kon Mokoi nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Keseria, roasiret erekapu Momok nukan enip jou muriäi senek, kon Mokoin enip nais jou muriäi. Momokus Mokoi äsimornuk, kowon, okon, inok ro ko Mokoin enip wa jou murai, Momokun enip nais wa jou murai. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Is epar senes awarom, inok ro ko isan ämän roumara, is äsimoirnuk, koimin ro mesin kon wou epar mai, kon totok orip orip awau rawai. Kos kiro ron onok wa wasare murai. Kos meiäun onok itimorwon, rusapai awau orip orip rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Is ak epar senes awarom, omre päi äiein rusapai ek pe rau, meiein roat ak Anut nukan Mokoin ämän rowaiei. Kon ämän rowaiei roat ak siräumoi, orip orip awau rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Moni ko nukasar awau rawaun sakau orip. Kos Mokoi kiro sakau nuruwon. Kesernuk, ko nais nukasar awau rawaun sakau orip. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ko Ro Nukan Mokoi, okon, Momokus roasiret wasarewaraun sakau nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Ak kiro ämän roumoi, ronkat sosop wa owau. Omre päi opok meiein roasiret ak kon ämän roumana, ak siräianik, up uruas kowaiei. Roasiret ak onok eposek miäin, ak ätäi siräimoi, akan totomaka orip orip awau rawaun owaiei. Kiro roasiret ak onok aru miäin ak siräuna, wasarewaraun ros akan onok aru aparmoi, ak erekapu aru maiei awarai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisas nukas ätäi awarowon, “Is isan ronkat pakas kar onok wa keseriäim. Isan monias is owose roasiret wasarewaraun aironuk, is keseriar wasarewareäim. Keseria, isan wasarewareäim onok eposek, owon, is isakasar isan ronkat pakas wa keseriäim. Is Moni nukasar roasiret wasarewaraun ronkat ironuk, keseriäim. Is isan woi ereraun wa keseriäim, is kiro ro is äsimoirnuk, koimin nukan wou ereraun keseriäim. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Ak rowe, isakasar isaka mesin ämän maroita, karauk roat ak isan ämän mesin akan woiaka epar wa maiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Utianik, kar ros is mesin ämän maronuk, ak kon ämän roumoi, akan woiaka epar maun itok. Jon ko an jomareäwon ro, ko isan enim amop me ariäwon. Ak erekapu kon ämän rowaun rai potoin. Is ak epar senes awarom, kiro ro ko is mesin ämän äiewon kiro epar senes. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Omnokou pakan roat ak isan enim amop me ariain roat mesin ekep ronkatwarau wa, utianik, isan ronkat Anut nukas akan onok aru pakan imwaraun, is ak okoro ämän ko mesin awarom. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jon ko arou senek, roasiret arou marowon. Ak kon arou aparianik, nepipirmoi, om ses katu kiro arou opok raiäin. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kar onok is mesin äiäu. Kiro Jon nukan ämän itimoriäu. Kiro sarau isan monias is maun irowon, is rusapai moram. Ak kiro sarau aparianik, äpu maiei ko is äsimoirnuk, koimin. Kiro onokun, okoro sarau rusapai moram Jon nukas äiewon amop murou. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Moni nukasar is äsimoirnuk, koimin, nukasar isan enim amop murowon. Ak kon pätu rowau wa. Ak kon nepu aparau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ak isan monias is äsimoirnuk, koimin, ko mesin akan woiaka epar mau wa, okon, kon ämän nais akan woiaka uru rawau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ak orip orip Anut nukan ämän ninareäi, kiro akan ronkat Anut nukan jeris ak awau orip orip rawaun rai keseriäi. Kiro jer wein kiro is mesin äiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Utianik, ak is rawa awau orip orip rawaun kowau utoi. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Is roat akas isan enim jou muraun rai wa awarom. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Utianik, is akan onok äpu. Ak Anut mesin woiakas wa meiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Is monian sakau orip koimin. Ak isan ämän rowau utoi, utianik, kar ro ko nukan sakau orip kounuk, ak kon ämän roiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ak akan jaunakat akas akan enmak jou maraun keseriäi. Utianik, kiro enip näwäu Anut nuka pakaima karar koiäu, ak kiro owaun utorai. Ak kiro onok tainormoi, is mesin akan woiaka owose epar maiei? ");
INSERT INTO bbr2013_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Is ak isan monian amukup akan enmakap ämän moram rai wa ronkatewe. Wa senes wa. Kiro ro Moses meter akan ronkat ‘ko ik sareikai’ rai, ko jou muroin, kos akan enmakap ämän mai. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ak Moses nukan ämän roumoi, akan woiaka epar moin maro, ak isan ämän nais roumoi, woiaka epar mowoi. Owon, kos kiro ämän is mesin jer wewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Utianik, ak kiro ämän kos jer wewon roumoi, akan woiaka epar mau wa, okon, owose isan ämän nais ak roumoi, woiaka epar maiei?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jisas ko kiro ämän roasiret are kuremara, ous atat kon tamareäu roat pak Galili An Unik karaima potoin. Kiro an unik kon kar enip Taiberias. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kos roasiret sip orip jekwaronuk, roasiret sosop ko kiro kurur keserwon aparianik, ak tainori potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jisas ko omtorou opok tonomara, kon tamareäu roat pak tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Kiro Juda akan tup apariäi ses opok, Juda akan askanai Moses pak meter Ijip omsau ute koin ronkateäi tup, enip Pasowa, siakup pe rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisas ko amuk kurewon, roasiret sosop ko siakup kouna, apwaromara, kos kon tamareäu ro Filip keser totorwon, “Ik o erapakan kau momoi, okoro roasiret arota, jaiei?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jisas ko owo onok nukasar keseraun äpu momara, Filip nukan ronkat ate aparaun totorwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip nukas ätäi äiewon, “Utianik, roasiret sosop rai, keseria, ik aiauk 200 kina oripas bret kau mianik, roasiret erekapu karar karar o eteinanak arota, jaiei. Kiro nais itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","Kar Jisas nukan tamareäu ro Andru, ko Pita nukan amak, kos Jisas auruwon, “Kar mokoi kon bret bari 5 orip, pak was oiroror pak ate rau. Utianik, roasiret sosop kiro o araun senek itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Amurik eposek sosop rawon. Keseria, Jisas nukas kon tamareäu roat awarowon, “Ak roasiret awarona, tanäiei.” Keseria, tamareäu roat akas roasiret tanäun awarona, ak erekapu tane potoin. Kiro tanein roat sosop, 5,000 orip. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ak tanena, Jisas nukas kiro mokoin bret oumara, Anut ‘pere’ aurianik, pärärnuk, kon tamareäu roat akas kiro roasiret tane rain erekapu are potoin. Was nais oumara, keseriar kesernuk, roasiret jeanik, ak nokomaka pewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kiro roasiret erekapu nokomaka penuk, Jisas nukas kon tamareäu roat awarowon, “Ak kiro o autau utoin wa sakarau erekapu turur maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Keseria, akas kiro o roasiret akas autau utoin turur momana, basket 12 orip ok pe moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Roasiret ak kiro kurur Jisas nukas keserwon aparmana, äiein, “Epar senes, okoro ro ko Anut nukan ämän roianik, areäu ro meter Anut nukas okoro omnokou opok äsimornuk, kowaun äiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ak Jisas sakau ateanik, akan kamwareäu ro näwäu king sare maun ronkate rain. Jisas ko akan ronkat äpu momoi, ko nukarar ak utware omtorou oik tonomara, rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Iukärir sare kounuk kounuk, Jisas nukan tamareäu roat Galili An Unik kasakup nemana, ous oik toneanik, ätäi Kapaneam mena potaun potoin. Om kiritirmoi, pututu sarenuk, Jisas ko ak siarakap kowau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Urir sakau näwäu senes peanik, mas an siräi mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","20","Jisas nukan tamareäu roat an unik kamuk pote rauna, Jisas ko kiro an unik oikas ari ari, kiro ous ak potoin opok kowon. Ak ko aparianik, sakau iminena, kos awarowon, “Okoro isaka. Ak wa iminäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Kesernuk, ak woiaka ereria, kiro ous uru imäi mona, tononuk, ous kiro mena potaun keserin opok kurte potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ninoinus, tapera, roasiret sosop ak an unik karaima rain ak äpu kukam ous karar rawon aparin. Ak äpu Jisas ko kon tamareäu roat pak kiro ous oikas manau wa. Tamareäu roat akarar manoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Karauk ous Taiberias mena utomoi, an unik kasakup poteanik, meter Näwäu nukas Anut aurmara, roasiret bret aronuk, jein opok pein. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Roasiret ak Jisas kon tamareäu roat pak apwarau wa, okon, ak karauk ous oik toneanik, Jisas itane Kapaneam mena potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Roasiret akas pote, Jisas an kasakup karaima tararianik, totorin, “Näu ro, na okoro opok esepa koumon?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jisas nukas ätäi awarowon, “Is epar senes awarom, ak is kurur atap atap ätär maromin mesin itaneirau wa, ak kiro bret aromin nokomaka pewonus, tainori koi. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ak kiro o kurte poomreäu mesin wa sarau sakau mowe, ak o awau orip orip rawaun mesin sarau mowe. Kiro o Ro Nukan Mokois arai, owon, momonok Anut nukas kon wou erermara, sakau nuruwon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Keseria, akas ätäi Jisas totorin, “Ik owo sarau momoi, Anut nukan ronkat tainorau?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Keserna, Jisas nukas ätäi keser awarowon, “Anut nukan sarau kesek, ak kiro ro Anut nukas äsimornuk, kowon mesin akan woiaka epar mowe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ak kiro ämän roumoi, akas ätäi keser totorin, “Na owo kurur mota, ik apaisomoi, iken woiok epar mai? Na owosäm? ");
INSERT INTO bbr2013_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Iken asanokot meter ro wäpik mena om puru opok kar o enip mana* jein. Meter Anut nukan ämänis keser äiewon, ‘Kos ak omar oikan bret aronuk, jein.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jisas nukas ätäiar awarowon, “Is epar senes awarom, Moses nukas omar oikan bret arau wa. Isan monias epar omar oikan bret ariäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kiro bret Anut nukas ariäu, ko omar oikas koianik, okoro omnokou opokan roasiret awau orip orip rawaun sakau ariäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Keseria, akas Jisas aurin, “Näu ro, nas ik orip orip kiro bret ikam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jisas nukas ätäi awarowon, “Isakasar is kiro awau orip orip rawaun bret. Inok roasir is siarap koumara, kon wou is mesin epar mai, kiro roasir ko sou wa wäi, ko an wa pätirai. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Utianik, is meter awaromin, ak is apairoin, sinuk, akan woiaka isanun epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Isan monias roasiret is irowon, ak erekapu is siarap kowaiei. Inok roasir ko is siarap kowai, isas ko wa emeram. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Owon, is isakan ronkatis sarau maun omar ute kowau wa, kiro äsimoirowon ro nukan sarau muraun äsimoirnuk, koimin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Kiro äsimoirowon ro nukan ronkatis äsimoirnuk, koimin, okon, kos kar roasir is irai isas ko wa utam. Tawa omnokou wasaräun omre opok, ätäi ko awau orip orip rawaun siräi muram. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Inok roasir mokoi aparmara, kon wou epar mai ko awau orip orip rawai. Epar, kiro isan monian ronkat. Isas okoro omnokou wasaräun ses opok kiro roasir ätäi siräi muram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Juda roat näunäu ak Jisas nukas ko omar oikan bret äiewon roumana, ak kasiaka penuk, kon enkup ämän sosop moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Keseria, akas aka aka areanik, äiein, “Okoro ro ko Jisas, Josep nukan mokoi. Kon momok anak ori ik äpu. Owoseanik, ko rusa äieu ‘is omar oikas koimin’ äieu?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisas nukas awarowon, “Ak aka aka wa tukätäiäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Kar ro ko nukarar kon ronkatis is siarap kowau senek wa, moni nukasar kon ronkat siräi murianik, is siarap imäi kowai. Meienuk, tawa wasaräun ses opok, isas ätäi ko siräi muram. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Karauk Anut nukan ämän roianik, areain roat akas keser jer wein, ‘Roasiret erekapu Anut nukas tamarai.’ Inok roasir monian ämän roumara, tainorai ko is siarap kowai. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Kar ros Momonok wa apari rau. Kiro ro ko Anut pak rawonus, kowon ko karar Momonok aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Is epar senes awarom, inok roasir kon wou is mesin epar mai, kiro roasir ko orip orip awau rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Isakasar awau orip orip rawaun bret. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Meter akan asanakat ro wäpik mena om puru opok kar o enip ‘mana’ jein, ak erekapu meiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Utianik, kiro bret omar utomara, kowon, inok ro kiro bret jai ko wa meiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Is kiro awau orip orip rawaun bret omar oikas koimin, inok ro ko kiro bret jai, ko awau orip orip rawai. Kiro bret nurita, jai, kiro isakan tokou. Kiro omnokou pakan roasiret aroita, ak awau orip orip rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ko keser awaronuk, Juda roasiret aka aka ämänis tukätäumoi, äiein, “Kiro ro nukasar nukan tokou ik jaun owose ikai?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jisas nukas ätäi keser awarowon, “Is epar senes awarom, inok roasir ko Ro Nukan Mokoin tokou karian pak wa jenuk rai, kiro roasir ko awau orip orip wa rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inok roasir ko isan tokou karian pak jai, kon totok awau orip orip rawai. Tawa wasarewaraun ses opok isas ko ätäi awau rawaun siräi muram. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Isan tokou kiro epar o isan karian kiro epar an. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inok roasir ko isan tokou karian pak jai, kon totok is pak pasairi rawai, isan totom nais ko pak pasar rawam. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Isan moni orip orip awau rau nukas is äsimoirowon. Is kon sakau pakas awau raim, kiro keseriar, inok roasir isan tokou jai ko awau orip orip rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Okoro bret omar utomara, kowon, kiro bret akan asanakat akas jeanik, meiein senek wa. Inok roasir ko okoro bret jai ko awau orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisas nukas Kapaneam mena, Juda roasiret akan tururiäi owa, kiro ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Jisas nukan tamareäu roat sosop ak kon ämän roumana, äiein, “Kiro ämän usuäu, inok ro ko tainoraun itok?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisas nukas kon tamareäu roat akan ronkat aru moin äpu momara, awarowon, “Kiro ämänis akan ronkat aru marou ra? ");
INSERT INTO bbr2013_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Utianik, ak Ro Nukan Mokoi meter rawon mena ätäi tononuk, aparmoi, ak owosäiei? ");
INSERT INTO bbr2013_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Osou Näus ro awau rawaun sakau nurai. Iken enmoksaus ik wa sareikai. Kiro ämän is awarom, kiro Osou Näus irowon. Ak kiro ämän roianik, ak awau rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Utianik, karauk roasiret ak kamuk opok rai, akan woiaka epar mau wa.” Kiro roat akan woiaka epar mau wa, Jisas ko meterar äpu mowon. Kiro ros ko iwäi jaukut ipiakap murai ro, ko nais äpu mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Keseria, kos äiewon, “Kiro onokun is awaromin, utianik, isan monias ro is siarap kowaun sakau wa nurunuk rai, kiro ro is siarap wa kowai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jisas nukas kiro ämän äiewon mesin, nukan karauk tamareäu roat ak ko ute manoin. Ak ko ätäi tainori ariäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Keserna, Jisas nukas kon tamareäu roat 12 orip totwarowon, “Ak nais is utoire manaiei ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Saimon-Pita nukas ätäi ämän auruwon, “Näwäu, ik inok rawa manau? Nakan ämän kiro awau orip orip rawaun ämän aikom. ");
INSERT INTO bbr2013_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Rusapai ik iken woiok na mesin epar mukonuk, naka ro tuku senes, na Anut pakas koumon äpu musom.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jisas nukas ätäi awarowon, “Isakasar ak 12 orip sare maromin. Utianik, karar ro ko ak kamuk opok kon wou uru osou aru orip rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","(Ko Saimon-Iskariot nukan mokoi, Judas mesin äiewon. Ko Jisas nukan tamareäu ro, utianik, kos tawa Jisas kon iwäi jaukut akan ipiakap mai.) ");
INSERT INTO bbr2013_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jisas ko kiro ämän aware kuremara, ko Galili provins mena apari apari potowon. Ko ätäi Judia provins potau wa, owon, Juda roat näunäu akas wena, meiäun apu itane rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kiro Juda roasiret akan tup ak wain woia ser ou opok raiäin omre* pe rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Keseria, Jisas nukan amakut akas aurin, “Na okoro mena utoinam, Judia provins opok man. Keseria, nan tamareäum roat nasar kurur atap atap mota, ak apaisaurai. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kar ro ko enip jou muraun kon sarau wa ämäi miäu. Na roasiret akan amiakap nan sarau miäum, Keserta, okoro omnokou pakan roasiret erekapu äpu musaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kon amakut kiro ämän moin, owon, ak nais ko mesin akan woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jisas nukas ätäi awarowon, “Isan potaun omre päu wa rau. Utianik, ak omre sepuk sepuk potaun itok. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Okoro omnokou pakan roasiret ak sauk wa mareäi, ak is sauk muriäi. Isas ak okoro omnokou pakan onok aru miäi awareäim, okon, ak kiro mesin is sauk muriäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Isan omre päu wa rau, okon, is kiro omre tup aparaun wa potam, akarar potowe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ko keser awaromara, ko Galili provins rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Kon amakut erekapu ak kiro ou eteinak opok raiäi nukan tup aparaun Jerusalem näu mena tonona, ko ämäi ämäi ruris tainware tonowon. Ko amop potau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Kiro tup opok Juda roat näunäu akas ko itanemana, äiein, “Kiro ro ko erapok rau?” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Roasiret sosop kiro kamuk aka aka ospasi pakaima Jisas mesin äiein, “Ko ro eposek.” Keserna, karauk akas äiein, “Wa, ko roasiret sätwareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Utianik, kar ros ämän amop aräu senek wa, owon, ak Juda roat näunäu iminewaroin. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Kiro tup jou muriäi omre kamuk opok raunuk, Jisas nukas tup ou näwäu owa tonomara, roasiret amop Anut nukan ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Juda roat näunäu ak Jisas nukas ämän marowon roumana, karkairianik, äiein, “Okoro ro ko skul näwäu opok manau wa, ko owose kiro ämän äpu miäu?” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisas nukas akan ämän roumara, awarowon, “Is okoro ämän awarom kiro isan ronkat pakaima wa, kiro Anut nukan ämän, nukasar is äsimoirnuk, koimin. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Inok ro ko Anut nukan ronkat tuku tainoraun rawai ro, is okoro ämän moram Anut nuka pakan ra, isan ronkat pakas moram ra, ko äpu mai. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Inok ro ko nukan ronkat pakas ämän äiäu, ko nukan enip jou maun keseriäu. Inok ro kon äsimorwon ron enip jou muraun ämän miäu, ko wa sätäiäu, kiro ro ko tuku. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Meter Moses nukas sintore ämän awarowon, ak erekapu äpu. Ak kiro sintore ämän jekur tainorau wa. Ak owon is iworaun keserurai?” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Roasiret sosop rain akas äiein, “Osou aru nan won uru rau. Inokot akas na iwosauri?” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jisas nukas ätäi awarowon, “Is kurur karar momin ak aparmana, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ak rowe, Moses nukas akan mokoit akan enmak kerau patiraun* sintore ämän arowon. Keserianik, ak sumaun omre opok akan enmak kerau patariäi. Kiro enmak kerau patiraun onok Moses pakas kowau wa, kiro askanai pakas kowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kiro ak Moses nukan sintore ämän tainoraun akan mokoit akan enmak kerau sumaun omre opok patiriäi. Isas kar ron enipsau sumaun omre opok erekapu jekur momin mesin akas is pak owon iwäi rai? ");
INSERT INTO bbr2013_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ak akan amiakas owo osap eposek wa wasare aparau. Ak onok eposek pakas osap erekapu raporiar wasarewe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Karauk Jerusalem roasiret akas Jisas nukas kiro ämän awarowon roianik, äiein, “Okoro ro ko Juda akan roat näunäu akas wena, meiäun areai ra? ");
INSERT INTO bbr2013_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Aparwe, ko roasiret amiakap ämän amop arera. Kar ros ko enkup ämän mau wa. Roat näunäu akan ronkat ko epar Krais ra? ");
INSERT INTO bbr2013_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ik okoro ron mena äpu, utianik, Krais penuk, ko erapakas pewon kar ros äpu wa mai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisas tup ou näwäu uru roasiret ämän maromara, sakau awarowon, “Ak isaka pak isan mena pak epar äpu ra? Is isan ronkat pakas kowau wa, kiro ros äsimoirowon ko epar senes rau. Ak ko äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Utianik, is ko äpu. Is ko pak raimin, kos äsimoirnuk, koimin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Keser äienuk, roumana, kiro roat akas ko sakau ataurin. Kar ros sakau atau wa, owon, kon sakau ataun omre päu wa rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Utianik, karauk roasiret sosop kiro kamuk rain akan woiaka epar moin, owon, akas äiein, “Krais kounuk, okoro ron kurur atap atap miäu kos itimorai ra? Iken ronkat ko wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Roasiret akas Jisas nukas kurur atap atap mowon mesin ämän sosop ospasi äuna, Parisi roat akas roumoi, Anut kamuk raiäi roat näunäu pak tururmana, akan marai roat Jisas sakau ataun äsimwarona, potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Keseria, Jisas nukas awarowon, “Is ak pak ekep wa rawam. Is kiro ros äsimoirnuk, koimin ko rawa ätäi manam. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kiro ses opok, akas is itaneiraiei, utianik, ak is wa apairaiei. Is rawam mena ak wa kowaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ko keser arenuk, Juda roat näunäu aka aka arein, “Okoro ro erapok manaurmara, ik ko wa tararam aikou? Ko Grik omsau iken karauk roasiret rai opok potomara, kiro opok Grik roasiret tamaraun äieu ra? ");
INSERT INTO bbr2013_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ko owo mesin äumara, ‘Ak is itaneiraiei, utianik, ak is wa apairaiei. Is rawam mena ak wa kowaiei,’ äieu, kiro ämän onoktapau owo senek?” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Kiro ser owa raiäin tup pataraun omre opok kiro kon omre näwäu senes. Kiro omre opok Jisas nukas siräumara, amop keser äiewon, “Rowe, inok roasir ko an pätirnuk, ko is siarap koumara, an jai. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Meter Anut nukan ämänis äiewon, ‘Inok roasir is mesin wou epar mai, kon wou uru orip orip rawaun an ok pemara, kure nai.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ko Anut nukan Osou Näu mesin äiewon, ‘Inok ro ko mesin wou epar mai kiro Osou Näu owai,’ äiewon. Kiro ses, Jisas ko omar oik tonau wa, okon, Anut nukas Osou Näu äsimornuk, kowau wa rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Roasiret akas kiro ämän roumoi, äiein, “Epar senes, kiro ro ko Anut nukan ämän roianik, areäu ro. Anut nukas äsimornuk, kowaun rai äiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Karauk akas äiein, “Ko Krais, Anut nukas kon roasiret ätäi imwaraun äsimornuk, kowon.” Utianik, karauk akas äiein, “Krais ko Galili pakas päi ra? Wa senes wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Anut nukan ämänis äiein, ‘Krais ko Devit nukan tupsiu pakas päi, ko Betlehem mena meter Devit rawon opok päi.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Keseria, roasiret ak Jisas mesin ronkat sosop mianik, aka aka inäumoi, tupsiu oiroror sarein. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Karauk roat akas ko sakau ataurin, utianik, kar ros ko sakau atau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Keseria, kiro tup owan marai roat ak ätäi Anut kamuk raiäi roat näunäu pak Parisi roat pak siarakap potona, akas keser awaroin, “Ak owon ko imäi kowau utoi?” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Keserna, marai roat akas ätäi awaroin, “Ko ämän mora senek, kar ros kesek ämän wa miäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Keseria, Parisi roat akas ätäi awaroin, “Kos ak nais atonwarou ra? ");
INSERT INTO bbr2013_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ik roat näunäu pak Parisi roat kamuk opok, kar ro ko mesin wou epar mowon ra? Wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Utianik, okoro roasiret ak sintore ämän äpu wa, ak ko mesin woiaka epar moin, ak Anut nukas erekapu aru marai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","51","Nikodimas kiro ro ko meter Jisas siakup potowon ko kiro roat näunäu akan jaunaka, kos keser awarowon, “Iken sintore ämänis kar ron ämän erar wasare murau, äieu ra? Wa senes wa. Ik kon oksaus ämän aikonuk, kon ämän owo senek mai roia, epar kon ämän wasare murau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Akas ko ätäi aurin, “Utianik, na nais, na Galili ro ra? Na Anut nukan ämän jekur ninareinam, äpu mo, Anut nukan ämän roianik, areäun ro kar ko Galili provins pakas wa päi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Keseria, roasiret ak akan mena atap atap manona, Jisas ko Olivet omtapau opok tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jisas ko Olivet omtapau opok tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ninowonus, tapera senes, siräianik, ätäi tup owa tonowon. Roasiret erekapu ak ko siakup koi tururna, ko tanemara, Anut nukan ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Sintore ämän tamareäi roat* pak Parisi roat pak akas kar asir ko kar ro pak ariewon sakau ateanik, koi roasiret akan amiakap tai moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Akas pemana, Jisas aurin, “Näu ro, okoro asir ko kar ro pak ariewon aparmun. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Iken sintore ämän Moses nukas ikowonus keser äieu, ‘Kiro keserai asir ko aiaukus weta, meiäi.’ Nan ronkat owo senek?” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Akas Jisas kiro ämän atonorianik, sakau ataun rai keserin. Jisas ko kuoinemara, ipous omnokou opok jer we rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Akas ko kakap totor rauna, kos ak apwaromara, awarowon, “Inok ro ko meter onok aru wa miäu, kos amke kiro asir aiaukus wenuk, meiäura.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Keseria, ko ätäiar kuoinemara, omnokou opok jer wewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ak kiro ämän arenuk, roumana, näu roat ak karar karar erekapu amke ute manona, karauk roat ruris manoin. Jisas ko nukarar omnokou opok jer we we raunuk, kiro asir ko siakup tai rawon siar rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Kos kiro asir aparmara, auruwon, “Kiro roat esein? Na onok aru momon äiäun ro kar rawau wa ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Kiro asires auruwon, “Näu ro, kar ro rawau wa.” Kesernuk, Jisas nukas ätäi auruwon, “Kiro itok, is nais na onok aru momon rai wa aisam. Utianik, na potoinam, kiro onok aru ätäiar wa keserau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Kar omre opok, Jisas nukas roasiret awarowon, “Isakasar, is okoro omnokou pakan roasiret akan arou. Inok roasir is tainoirai, ko pututu wa ariäu, kon totok arou opok orip orip rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisi roat akas kiro ämän roumoi, Jisas ätäi aurin, “Na kiro ämän ko mesin arem, kiro epar wa, kiro nakan ronkat pakaima areram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jisas nukas awarowon, “Wa, kiro epar. Is okoro ämän isaka mesin äiem, okoro ämän awarom kiro epar senes. Is erapakas koimin, ätäi erapakas manam, is äpu. Is erapakas koimin, ätäi erapakas manam, ak äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Akas okoro omnokou pakan onokus roasiret wasarewareäi. Isas kar roasir nukan onok wa wasare muriäim. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Utianik, isas roasiret wasarewaraun maro, is jekur wasarewarowom. Owon, is isakarar rawau wa, isan moni äsimoirowon ro, nuka is pak rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Akan sintore ämän opok ämän keser jer wein rau, ‘ro oiroror awan ämän karar maieir kiro ämän epar senes’. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Is isaka mesin awareäim, isan moni kos is äsimoirowon ko nais is mesin äiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Akas ätäi totorin, “Nan momon kiro erapok rau?” Jisas nukas ätäi awarowon, “Ak is woweiroi, isan moni nais wowäiei. Ak is äpu muroi maro, isan moni nais äpu mowoi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jisas tup ou näwäu owa, aiauk miäin omoi siakup raumara, kiro ämän erekapu awarowon. Kar ros ko sakau atau senek wa, owon, kon sakau ataun omre päu wa rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jisas nukas ätäi awarowon, “Is manoita, akas is itaneiraiei. Utianik, ak is wa apairaiei. Ak onok aru orip orip momoi, meiäiei. Is manam mena ak wa manaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Keseria, Juda roat näunäu akas kiro ämän roumoi, äiein, “Ko owosäun keser äieu, ‘Is manam mena ak wa manaiei’? Ko nukasar nuka wenuk, meiäi ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jisas nukas keser awarowon, “Ak okoro omnokou pakan tupsiu. Is omar oikan. Ak okoro omnokou pakan, utianik, is okoro omnokou pakan wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Kiro onokun, is awarom, ak akan onok aru orip orip momoi, meiäiei. Ak is Anut nukas äsimoirnuk, koimin mesin woiaka epar mau wa, okon, ak erekapu akan onok aru orip meiäiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Akas ätäi totorin, “Keseria, na inok?” Jisas nukas awarowon, “Is meter awaromin, kiro senek. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Is akan onok keseriäi ämän sosop awaromoi, akan onok wasaräun itok. Utianik, kiro ro is äsimoirnuk, koimin, kon onok epar senes. Kon ämän erekapu roimin, kiro ämän okoro omnokou pakan roasiret mareäim.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ko kon momok oik rau mesin awarowon, ak äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Keseria, kos awarowon, “Tawa akas Ro Nukan Mokoi am äpäs opok äsäi mona, kiro ses opok, Anut nukas is äsimoirnuk, koimin, ak äpu maiei. Keseria, ak äpu maiei, is isan ronkat pakas kar onok wa keseriäim, utianik, isan monias karar aironuk, is äiäim. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Kiro äsimoirnuk, koimin ro, ko is pak rau, ko is utoironuk, isakarar rawau wa, owon, is owo onok keserita, ko wou ereriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Roasiret sosop kon ämän roianik, konun akan woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jisas nukas Juda roasiret kiro ses opokar kon ämän roianik, konun woiaka epar moin keser awarowon, “Utianik, ak isan ämän jekur tainoraiei, kiro ak isan tamareäim roat senes saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Kiro ak Anut nukan epar ämän äpu maiei. Okoro epar ämänis ak onok aru pakan imwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Akas ätäi ko aurin, “Ik iken askanai Apraham nukan tupsiu, ik kar ses opok, karauk roat akan sarau roat wa raumun. Nan ronkat owo senek, okon, ik sarau aru pakan ätäi imwaram aikom?” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Keser aurna, Jisas nukas ätäi awarowon, “Is epar senes awarom, inok roasir ko onok aru miäu, ko kiro onok aru nukan sarau ro. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Sarau ro ko, kon ro näwäun owa ekep wa raiäu, mokoi epar kon momokun owa orip orip raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Keseria, Anut nukan Mokois akan onok aru jäkäi maronuk rai, ak onok aru nukan sarau roat wa rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Is äpu ak Apraham nukan tupsiu, utianik, ak isan ämän tainorau utoi, is iworona, meiäun keseri. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Is isan monias ätär murowon siar areram, utianik, ak akan momonakas awaroin siar keseriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Juda roat akas Jisas nukan ämän roumoi, äiein, “Apraham kiro iken momonok.” Jisas nukas ätäi awarowon, “Apraham ko akan momonaka maro, kon onok eposek keseriäu siar keserwoi. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Is epar ämän Anut nukas airowon awareäim, utianik, rusa akas is iworam rai keseri. Apraham ko kiro onok wa keseriäwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ak akan momonakas keseriäu siar keseriäi.” Akas ätäi aurin, “Iken aninokot ak kar ro pak ariemana, ik mukau wa. Anut nuka karar ko iken momonok. Ik kon mokoit senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jisas nukas ätäi awarowon, “Anut ko akan momonaka maro, ak akan woiakas is mesin meiewoi, owon, is Anut nuka pak raiminus, koimin okoro raim. Is isan ronkat pakas kowau wa, kosar is äsimoirnuk, koimin. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Utianik, ak owon isan ämän nukan onoktapau jekur äpu wa? Kiro onokun, ak isan ämän jekur rowaun utoi. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Akan momonaka Satan, okon, ak kon ämän tainoraun keseriäi. Ko meter meter, roat akwarnuk meiäi ro, ko epar ämän rowaun utiäu, owon, ko orip orip sätäiäu. Ko sät ämän mianik, ko kon onok kosar tainoriäu, owon, ko sätäiewon ro. Ko sät äiäi roat akan momonaka. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Is epar ämän mareäim, okon, ak isan ämänis akan woiaka epar mau utou. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Akan ronkat is onok aru moram rai ronkateäi, ak isan onok aru kiro amop mowe. Utianik, is epar ämän mom raroi, ak owon isan ämän mesin woiaka epar mau utoi? ");
INSERT INTO bbr2013_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Anut nukan mokoi, ko Anut nukan ämän roiäu. Utianik, ak Anut nukan mokoit wa, okon, ak kon ämän rowau utoi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Juda roat akas ätäi Jisas aurin, “Na Samaria* provins pakan ro, na osou aru orip.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jisas nukas ätäi awarowon, “Osou aru is opok wa rau. Wäpik, is isan moni nukan enip jou karar muriäim, utianik, akas isan enim wa jou muriäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Isakasar isan enim wa jou miäim. Kar ro rau, kos isan onok aparianik, wasareiromoi, kosar isan enim jou murauru. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Is ak epar senes awarom, inok roasir ko isan ämän roianik, tainoriäu, ko wa meiäi. Wa senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Akas kiro ämän roumoi, ätäi aurin, “Ik rusapai äpu mom, osou aru na opok rau. Apraham pak Anut nukan ämän roianik, areain roat pak ak meiein. Na nakasar keser äiem, inok roasir ko isan ämän roianik, tainorai, ko wa meiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na rou, iken askanai Apraham ko meiewon. Nan ronkat na ro näwäu Apraham itimori raum ra? Anut nukan ämän roianik, areain roat nais meiein. Nan ronkat na inok ro senek saräurmata, äiem?” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jisas nukas ätäi awarowon, “Utianik, is isakasar isan enim jou momoi, kiro enim pakas kar osap wa owam. Isan monias karar isan enim jou muriäu. Kiro Anut karar, kiro, akas iken eitek äiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Utianik, ak ko äpu wa. Is karar ko äpu. Utianik, is ko äpu wa awaroita maro, kiro is ak sätäiäi roat senek sarewom, utianik, isaka ko äpu, okon, kon ämän erekapu tainoriäim. ");
INSERT INTO bbr2013_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Meter akan askanai Apraham ko kiro kowaun omre penuk, aparaun ronkatemara, nepipirwon. Kos epar aparmara, nepipirwon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Akas ätäi aurin, “Nan woisan 50 orip wa. Owose na is Apraham aparmin äiem?” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jisas nukas ätäi awarowon, “Is ak epar senes awarom, Apraham ko päu wa opok is raimin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Keser äienuk, akas aiauk oianik, Jisas wäurna, ko ämäi ämäi kiro tup ou näwäu owan ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jisas ko ari ari potomara, kar ro kon anakus amuk utup orip mowon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kon tamareäu roat akas totorin, “Näu ro, inokos onok aru mowon, okon, kiro ro anakus amuk utup orip mowon? Nukas onok aru mowon ra, kon momok anak ories onok aru moirin ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jisas nukas ätäi awarowon, “Kiro ro amuk utup ko nukas onok aru mau wa, kon momok anak ori au nais kar onok aru mau wa. Kiro Anut nukan sakau amop penuk, aparaun keser mowon rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Rusapai, om teineu, sankeu, is inokos is äsimoirnuk, koimin nukan sarau murau. Pututu sarenuk, ik sarau mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Is okoro omnokou opok raita, isaka karar okoro omnokou pakan roasiret akan arou senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","7","Jisas kiro ämän are kuremara, omnokou opok sinok kurewon. Kiro sinok sänsän ätäiewon oumoi, kiro ron amuk utup opok pasar murianik, auruwon, “Na potoinam, Siroam An Unik opok nan amun an kosor.” Kiro Siroam kon enip onoktapau ‘äsimornuk, manowon.’ Kesernuk, kiro ro potomara, kiro an unik opok kon amuk an kosornuk, amuk amaremara, om eposek aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kesernuk, ko siakup rain roasiret pak karauk roasiret ak meter ko apu opok raumara, roasiret o nik mareäwon aparin akas ko eposek sarenuk, aparianik, aka aka arein, “Okoro ro ko meter apu opok tane raumara, roasiret o nik mareäwon ro ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Karauk akas äiein, “Epar, okoro ro ko karar.” Karauk akas äiein, “Wa, okoro ko wa. Kar ro ko senek.” Keserna, kiro ro nukasar äiewon, “Is meter roasiret o nik mareäimin, kiro is karar.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Akas ko totorin, “Nan amun owose urarewon?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Kos ätäi awarowon, “Kiro ro Jisas äiäi, kos sänsän an orip oumara, isan ami opok joutor momara, pote Siroam An Unik opok amun an kosoraun airowon. Is pote keserita, isan ami urarewon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Akas ko ätäi totorin, “Kiro ro ko erapok rau?” Kos ätäi awarowon, “Ko erapok rau, is äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Kiro roat akas meter amuk utup rawon ro imäianik, Parisi roat siarakap imäi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisas nukas sänsän oumara, kiro ron amuk utup jekur mowon kiro sumaun omre opok keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Parisi roat akas kiro meter amuk utup rawon ro owose amun uräiewon rai totorin. Kiro ros awarowon, “Kos sänsän an orip oumara, isan ami opok monuk, is pote ami an kosorianik, ami uräimoi, om aparim.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Karauk Parisi roat akas äiein, “Kiro ro ko kiro onok keserwon, ko Anut pakas kowau wa, owon, ko sumaun omre pakan sintore ämän tainorau wa.” Keserna, karauk akas äiein, “Ro onok aru miäu, kos owose kurur atap atap okoro keseru senek keserai?” Keseria, aka aka inäiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Keseria, Parisi roat akas kiro ro ätäiar totorin, “Na kos nan amun utup ätäi jekur musowon äiem, utianik, nan ronkat kiro ro inok?” Kiro ros ätäi awarowon, “Ko Anut nukan ämän roianik, areäu ro.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Juda roat näunäu ak kiro ro kon amuk uräiewon nukan ämän äiewon mesin akan woiaka epar mau wa, okon, kiro ron momok anak orien ämän jekur rowaun rai urwatoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Keseria, akas kon momok anak ori totwatoin, “Okoro awan mokoi ra? Awas ko amuk utup momurin äieirin. Kesersa, rusapai owose kon amuk urarewon?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kon momok anak ories äieirin, “Iu äpu kiro iwen mokoi, ko amuk utup momurin. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Utianik, owose kon amuk uräiewon, kiro iu äpu wa. Inok ros kon amuk urare muruwon kiro nais iu äpu wa. Ko urek sarewon, nuka totorwe. Nukasar äiäun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Kon momok anak ori au keser äieirin, owon, Juda roat näunäu akas tururiäi owan emwataiei rai imineirin. Inok ros Jisas ko Krais äienuk rai, epar senes, Juda roat akas kiro ro tururiäi owa wa rawai rai äiäin, okon, au imineirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kiro onokun, kon momok anak ories, ko näwäu sarewon nukasar aräura rai äieirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Akas ätäiar kiro ro urweanik, aurin, “Na Anut nukan amuk opok epar ämän mam. Ik äpu kiro ros nan amun jekur mowon, ko onok aru miäu ro.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Kiro ros ätäi awarowon, “Kiro ro ko onok aru miäu ra, wa rä, is äpu wa. Utianik, is meter ami utup raimin. Rusapai om aparim. Is kiro karar äpu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Akas ätäi totorin, “Kos na owosisowon? Nan amun utup owose jekur musowon?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Kos ätäi awarowon, “Isan ämän meter awaromin, ak owon isan ämän rowau utoinus, ätäi rowaun totoiroi? Ak nais kon tamareäu roat saräun rai keseri ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Akas jejermana, aurin, “Na karar na kiro ron tamusiäu ro. Utianik, ik Moses nukan tamukiäu roat. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ik äpu Anut nukas Moses auruwon. Ik äpu wa kiro ro ko erapakas pewon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Kiro ros ätäi awarowon, “Is akan ämän roianik, karkairim! Ak äpu wa, ko erapakas pewon, utianik, kos isan ami utup jekur murowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ik äpu Anut ko roat onok aru miäi akan ämän wa roiäu. Roat ko jou murianik, kon ämän tainoriäi karar akan ämän roiäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Meter omnokou ate mowon ses opok, koi rusapai, kar ros kar ro amuk utup jekur mowon äuna wa roiäum, rusapai karar. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kiro ro ko Anut pakas wa kowon maro, ko kiro kurur keseraun itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Parisi ak kiro ron ämän arewon roumana, akas ätäi keser aurin, “Na aninas musowon ses opok onok aru orip urek saremon keseri nas rusapai ik tamukaurum ra?” Keser aurianik, kiro ro owan emerna, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jisas ko kiro onok keserin ämän roumoi, ko pote kiro ro tararmara, totorwon, “Nan won Ro Nukan Mokoi mesin epar mom ra, wa?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Kiro ros ätäi auruwon, “Näu ro, kiro inok ro rä? Airota, is ko mesin isan woi epar mam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Kesernuk, Jisas nukas auruwon, “Na kiro ro amunas aparmon, kiro ro nukasar rusapai na are musora.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Kiro ros auruwon, “Näwäu, isan woi epar murou.” Keseria, kiro ros Jisas nukan isokup uou sur wemara, jou muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisas nukas äiewon, “Is okoro omnokou opok roasiret akan onok wasarewaraun koimin. Roat ak amiaka utup orip ak amiaka uraräiei, roat amiaka amare rai, ak amiaka utup saräiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Keser äienuk, karauk Parisi roat ak ko siakupai rain kiro ämän roianik, totorin, “Ik nais amiok utup orip ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jisas nukas ätäi awarowon, “Ak amiaka utup orip maro, ak ämän wäpik, utianik, akas ik amiok orip raum äiäi, okon, ak ämän orip rai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisas nukas ätäiar äiewon, “Is epar senes awarom, kar ro ko sipsip niniäi porim rorok opakas wa toneäu, ko porim urai toneäu, kesek ro, ko päu ro. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Rorok opakas toneäu ro, kiro ko sipsip kamwareäu ro senes. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Kiro porim rorok kameäwon ros im tue muriäu, kiro sipsip kameäwon ros kon sipsip karar karar akan enmaka atonuk, kiro sipsip raut ak kon pätu roumana, ko tainori maneäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ko kasik imware nomara, nuka amke potonuk, kiro sipsip ak ruris tainori poteäi, owon, ak kon pätu äpu moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ak karauk roat wa tainwareäi. Ak karauk roat akas urwarna, imineware manaiei, owon, ak akan pätiaka äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisas nukas kiro totok ämän awarowon, utianik, ak kiro totok ämän nukan onoktapau äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jisas nukas ätäi äiewon, “Is epar senes awarom, Isakasar is sipsip akan porim rorok. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Karauk roat ak amke pein ak päu roat. Sipsip raut akan ämän rowau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Isaka karar is porim rorok senes. Inok ro isan rorok opokas päi is ko jekur kamäm. Ko owa tonomara, ätäi pote o jaun om eposek apari owai. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Päu ro ko pe, päu oianik, aru marau peäu. Is ak totomaka orip orip rawaun sakau araun koimin. Keseria, ak kar osapun wa wasaräiei, orip orip jekur rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Isaka karar sipsip kamwareäim ro eposek. Sipsip kamwareäu ro eposek ko nukas kon sipsip mesin meiäun rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Kar ro aiaukun sarau mianik, ko sipsip kamwaraun ro senes wa. Ko opur sei kounuk, aparmara, kiro sipsip utwaromara, imine manonuk, kiro opur seis pe karauk tukware jenuk, karauk imine mane kuräiei, owon, kiro ro ko erar aiaukun sarau miäu, kon sipsip mesin wa ronkatäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Isakasar is sipsip kamwareäim ro eposek. Isan monias is äpu muriäu isas nais moni äpu miäim senek, is isan sipsip äpu mareäim, akas nais is äpu muriäi. Ak isan sipsip, okon, is ak mesin meiäun keserim. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Isan karauk sipsip ak okoro porim uru rawau wa. Is ak nais imwarea, okoro porim uru maroita, ak isan ämän roianik, erek karar tupsiu rauna, is ak erekapu kamwaram. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Isan monias is mesin wous meieäu, owon, is isan sipsip mesin meiemoi, ätäi siräiam. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Isan enimsau utoita, kar ros erekapu iwori kuräu senek wa, is sakau orip isan ronkat pakas isakasar isan enimsau utomoi, isakasar isan enimsau ätäi owaun itok. Kar ros is wa tämurai. Isan monias is kiro keseraun airowon siar keseram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Juda roasiret ak kiro ämän roianik, karaima karaima inäiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Roat sosop akas äiein, “Osou aru kon wou uru tononuk, ko otop sareäu. Ik owon kon ämän rowaun raiok enmoram?” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Utianik, karauk roat akas äiein, “Osou aru orip ro ko ämän eposek keser wa aräi. Osou aru orip ros owose roat amiaka utup jekware mai?” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kiro ses opok, Jerusalem näu mena kar tup aparaun omre näwäu pewon. Omre näwäu kiro meter Anut osap nuriäi tup ou näwäu sare murianik, im tuein* ätäi ronkatäun omre näwäu. Kiro omre opok, roros näwäu senes peäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisas ko kiro tup owa meter Solomon nuka raiäwon omoi äiäi opok tonomara, ari rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Keseria, Juda roasiret ko siakup pe tururmana, totorin, “Esapa na aikam, na Krais? Na rusapai amop aikam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jisas nukas ätäi awarowon, “Is meter ak awaromin, utianik, akan woiaka epar mau wa. Okoro kurur atap atap erekapu moni nukan enip pakas moram, kiro isan enim amop me rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Utianik, ak isan sipsip wa, okon, akan woiaka is mesin epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Isan sipsip ak isan ämän roiäi. Is ak äpu, ak is tainoireäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Is ak totomaka awau orip orip rawaun sakau aroita, ak wa meiäiei. Kar ros ak isan ipiapan wa imware manai. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Kiro roasiret isan monias irowon. Ko näwäu senes karauk roasiret erekapu itimware rau, okon, kar ros ak monian ipokupan oi kuräun senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Is isan moni ori iu karar.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Keser äienuk, Juda roat akas ätäi aiauk oianik, ko wäurin. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Utianik, Jisas nukas awarowon, “Is akan amiakap, isan monian kurur atap atap kesermin, akan ronkat is owo kurur atap atap momin mesin iworauri?” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Juda roat akas aurin, “Na kiro kurur atap atap kesermon mesin ik wa keisom, utianik, na jeje ämän momon. Na erar ro, na isaka Anut äiemoi, Anut nukan omoi owaurta, okon, kiro mesin ik na iwosaurum.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisas nukas ätäi awarowon, “Akan sintore ämän opok jer we moin rau, Anut nukas äiewon, ‘Akasar aka eitek, Anut senek.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anut nukan ämän ko sätäiäu wa, epar senes äiewon. Meter Anut nukas roat awarowon, ‘Ak eitek, Anut senek.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Keseria, moni nukasar sare mareanik, äsimoirnuk, koimin, akan ronkat owo senek? Isas is Anut nukan mokoi raim äieita, ak owon is jeje ämän mom airoi? ");
INSERT INTO bbr2013_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Is isan monian sarau wa murita rai, ak isan ämän mesin woiaka epar wa mau. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Utianik, is kon sarau moita, ak is mesin woiaka epar mau wa raroi, ak isan kurur mesin woiaka epar mowe. Keseria, ak epar äpu isan Moni is pak raunuk, is ko pak erek raim.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ak kiro ämän roianik, ak ätäi ko sakau ataurin, sinuk, ko itimware manowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","41","Jisas ko ätäi kiro mena Jordan An kasakup meter Jon nukas roasiret an jomarowon opok potowon. Ko karauk omre kiro opok raunuk, roasiret sosop ko siakup koin. Akas äiein, “Jon nukas kar kurur mau wa, utianik, kon ämän erekapu kiro ro mesin äiewon kiro epar.” ");
INSERT INTO bbr2013_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kiro mena, roasiret sosop akan woiaka ko mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kar ro sip orip kon enip Lasarus, ko Betani mena raiäwon. Kiro mena Maria kon amak Marta ori raiäirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Kiro Maria kosar meter uer sou eposek Jisas nukan isou opok kourmara, kon tapau urik rumukäus tätäi muruwon. Kiro asir nukan äpiauk Lasarus ko sip orip. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Kiro asiret ories Jisas ämän surmurianik, äieirin, “Näwäu, nan jaun ko mesin wonas meieäum ko sip orip rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisas ko kiro ämän roumara, äiewon, “Kiro sipas ro wa meiäi. Kiro roasiret ak Anut nukan sakau aparianik, kon enip oik maiei. Kiro apu opokas Anut nukan Mokoi enip jou näwäu owai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisas ko Marta, kon awak Maria, Lasarus pak akanun kon wous meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ko Lasarus sip rau ämän roumara, utianik, kiro rawon mena omre oirori rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kiro omre oirori manonuk, kon tamareäu roat awarowon, “Ik ätäi Judia provins potau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kesernuk, kon tamareäu roat akas aurin, “Näwäu, Juda roasiret akas na aiaukus iwosaurna, koumun, omre rumukäu manau wa, na ätäi kiro mena potaun ronkatem ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jisas nukas ätäi awarowon, “Omre karar opok sarau kiro 12 aua orip, tapera pote iukärir kiro epar. Keseria, inok ro ko sankeu ariäu ko aiaukus wa siotorai, owon, ko omnokou pakan arou apariäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Utianik, ro ko pututu ariäu, ko aiaukus siotorai, owon, ko arou wäpik.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisas kiro ämän aware kuremara, awarowon, “Iken jaunok Lasarus ko nini rau, is potoita, ko siräi muram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Kon tamareäu roat akas aurin, “Ko nini rau raroi, ko ätäi eposek saräi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jisas ko or ämän momara, Lasarus nini rau awarowon, utianik, ko äpu Lasarus meiewon. Tamareäu roat akan ronkat ko epar nini rau rai äiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Keseria, Jisas nukas ätäi amop awarowon, “Lasarus ko meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Utianik, is ak mesin ronkateanik, ko pak pote rawau wa, owon, is akan woiaka epar maun rai kesermin. Ik ko aparau manau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jisas keser äienuk, Tomas nukan kar enip Didimas nukas kon sarau jaukut awarowon, “Kir, ik erek ko pak meiäu manau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisas ko kon tamareäu roat pak Betani mena siakup pena, karauk roat akas Lasarus meiewon, up uru momun omre 4 orip manowon rai aurin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Kiro mena Jerusalem siakup. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Keseria, Juda roasiret sosop ak Marta Maria ori awan äpinawa meiewon woiaka eposek saräun rai siarawap koi rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta ko Jisas koura ämän roumara, ko Jisas apu opok tararaun potowon. Maria ko owa rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta nukas pote Jisas tararmara, auruwon, “Näwäu, na okoro opok raumon maro, isan äpi wa meiewo. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Utianik, rusapai nais is äpu na owo osap owaun Anut aurta, kos na isai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jisas nukas ätäi Marta auruwon, “Nan äpin ätäi siräiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta nukas ätäi äiewon, “Io, is äpu, tawa roasiret erekapu ätäi siräiäiei ses opok, ko nais siräiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisas nukas ätäi auruwon, “Siräianik, awau rawaun onoktapau kiro is karar. Inok roasir ko isanun wou epar momara, meiäi, utianik, ko awau rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Roat erekapu awau rai, akan woiaka isanun epar maiei, ak wa meiäiei. Ak awau orip orip rawaiei. Na kiro ämän mesin won epar mou ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Kos ätäi äiewon, “Näwäu, epar senes, isan woi nanun epar mou. Na Krais, Anut nukan Mokoi, na okoro omnokou opok kon roasiret ätäi imwaraun sare musonuk, koumon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta ko kiro ämän are kureanik, ätäi owa potomara, Maria ospasi pakas auruwon, “Iken tamukiäu ro pemara, ko na apaisam äieu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria kiro ämän roumara, kurte siräumoi, Jisas tararau potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisas ko mena tonau wa, ko Marta tararwon menar rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Juda roasiret ak Maria pak koi rain, Maria ko kurte siräimara, kasik nonuk, aparianik, akan ronkat ko up opok waiäu potou rai tainori potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria ko Jisas rawon opok pote tararmara, kon isokup uou sur wemara, auruwon, “Näwäu, na okoro opok raumon maro, isan äpi wa meiewo.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria ko kon äpiauk mesin wouti momara, waienuk, karauk roasiret ko pak erek potoin ak nais woiakati maronuk, waiena, Jisas ko ak apwaromara, ko nais wouti momara, wou aru sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Kos totwarowon, “Ak ko erapok up kurein?” Akas aurin, “Näwäu, na aparau pe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jisas ko wouti näwäu senes momara, waiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Kesernuk, roasiret akas äiein, “Aparwe, ko Lasarus mesin kon wous epar meiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Utianik, karauk roasiret akas äiein, “Okoro ros kar ro amuk utup orip jekur monuk, om aparwon. Ko owon Lasarus saräun utonuk, meiewon?” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisas ko ätäi wouti näwäu momara, Lasarus aireu uru moin siakup potowon. Kiro aireu aiauk näwäus im pene moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisas nukas awarowon, “Kiro aiauk oi kurewe.” Kiro ro meiewon, kon äpiauk Marta nukas äiewon, “Näwäu, ko up kuremun omre 4 orip utom, okon, sou aru senes päi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisas nukas auruwon, “Is na meter aisomin, nan won is mesin epar mota, Anut nukan sakau näwäu aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Keseria, akas kiro aiauk im pene moin pakan oi kurena, Jisas nukas omar eisanemara, äiewon, “Moni, na isan ämän orip orip roiäumon, okon, is na ‘pere’ aisom. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Is äpu na isan ämän orip orip roiäumon is okoro roasiret rai mesin äiem, iu kiro kurur keserta, akan woiaka nas is äsimoirta, koimin epar maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisas ko keser auri kuremara, näwäu urweanik, äiewon, “Lasarus, na kasik koi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Kiro meiewon ro siräimara, kasik kowon. Kon isou ipou neputapau enipsau erekapu omjos kururur moin. Jisas nukas awarowon, “Kiro omjo uräi kureinai, utona, manai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Juda roasiret sosop ak Maria aparau koin Jisas nukas kiro kurur keserwon aparmana, akan woiaka ko mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Utianik, karauk roat ak Jisas nukas kiro kurur keserwon aparianik, potomoi, Parisi roat awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Keseria, Parisi roat akas Anut kamuk raiäi roat näunäu pak karauk roat näunäu urwarna, ak koi tururmana, äiein, “Kiro ro ik owosäu? Ko kurur atap atap mora. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ik kiro ro utota, kiro onok keseriar keser raunuk rai, roasiret erekapu akan woiaka konun epar maiei. Keserna, Rom akan roat näunäu akas pemoi, ika aru mukianik, iken omsau pak tup ou näwäu pak erekapu aru maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Kar ro kon enip Kaiapas ko kiro woisan opok Anut kamuk raiäu ro näwäu senes, kos awarowon, “Ak kar ronkat raika uru wa rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ak äpu wa ra? Karar ros karar roasiret akan omoi oianik, meiäun itok. Iken roasiret erekapu aru maiei itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiapas ko kon ronkat pakas kiro onok keseraun äiäu wa, ko Anut kamuk rawaun ro näwäu senes, okon, Anut nukas kiro onok keseraun ronkat nurunuk, ko tawa Jisas meieanik, okoro Juda roasiret sarwaraun rai arewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko Juda roasiret akanun karar meiäu wa. Ko meieanik, Anut nukan roasiret okoro omnokou opok erekapu turur maromara, Anut siakup koi marai. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Kaiapas keser äienuk, kiro omre opokar, Juda roat näunäu akas Jisas owose wena, meiäun rai onoktoroi a atoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Keserna, Jisas ko Judia provins opok ätäi amop ariäu wa. Ko kiro mena utomara, pote, ro wäpik omnokou siakup kar mena enip Epraim, kon tamareäu roat pak rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kiro sumaun omre Pasowa siakup penuk, roasiret Jerusalem näu mena siakupaian erekapu Anut nukan amuk opok eposek saräun akan onok atap atap keseraun näu mena tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ak Jisas tup owa penuk, aparaun rai tone kame raumoi, aka aka arein, “Akan ronkat owo senek? Ko okoro sumaun ses päi ra, wa päi?” ");
INSERT INTO bbr2013_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Kiro Anut kamuk raiäi roat näunäu Parisi roat pak akas roasiret awaroin, “Jisas erapok rawai, ak aparianik, ik koi aikona, pote sakau atam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Juda akan tup aparaun omre, enip Pasowa, omre 6 orip raunuk, Jisas ko Lasarus nukan mena Betani tonowon. Kiro mena meter Jisas nukas Lasarus meiewon siräi mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ko kiro opok tononuk, ak ko pak o jaun mis moin. Marta ko o wenuk wenuk, Lasarus ko karauk roat pak ak Jisas pak erek pasar opok tane rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Keserna, Maria nukas uer sou eposek enip nar, aiauk näwäus kau maun senek oumara, Jisas nukan isou opok kourmara, kon tapau urik rumukäus tätäi muruwon. Kiro uer sous kiro owa erekapu ok pewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","Kesernuk, Jisas nukan kar tamareäu ro Judas Iskariot, kos tawa Jisas iwäi jaukut akan ipiakap marai, kos äiewon, “Kiro uer aiauk näwäu, woisan karar pakan aiauk senek, owaun itok. Ik karauk roat arota, kau mona, aiauk oia, saruku roasiret sarwaraun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ko kiro ämän äiewon, saruku roasiret mesin ronkatäu wa, owon, ko päupu ro. Ko Jisas nukan tamareäu roat akan aiauk jo kameanik, ko kiro jowan aiauk päu oiäwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisas nukas kiro ämän roumara, äiewon, “Utona, rawai. Ko is up kureiraiei ses opok, okoro onok keseru tawa ronkatäura. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Saruku roasiret ak pak orip orip rawaiei, utianik, is ak pak orip orip ekep wa rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","10","Juda roasiret sosop, ak Jisas Betani mena rau ämän roumana, ak kiro opok potoin. Ak Jisas karar aparaun potau wa, ak Lasarus meiewon Jisas nukas up uruan siräi mowon aparau potear arin, Keseria, Anut kamuk raiäi roat näunäu akas Lasarus nais wena, meiäun a atoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Owon, ko mesin Juda roasiret sosop ak sumkäinewaromoi, Jisas mesin woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ninowonus, tapera, roasiret sosop kiro tup enip Pasowa aparaun pein ak Jisas Jerusalem näu mena koura ämän roin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Keseria, akas ukumai pisau senek patir oianik, Jisas kowaun apu opok tararau poteanik, keser urwein, “Anut nukan enip jou murau. Kiro ro Näwäu nukan enip opokas kou, jou murau. Ko Israel akan kamwaraun ro näwäu, king.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisas ko kar donki nak aparmara, kiro oikas potowon. Meter Anut nukan ämänis äiewon senek epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Kiro ämänis keser äiewon, ‘Ak Saion* näu menan roasiret, ak wa iminäu. Akan kamwaraun ro näwäu ko donki nak pakas taneanik, kou.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kon tamareäu roat kiro onok amke keserin kiro ämän onoktapau ak äpu wa. Utianik, tawa Jisas omar oik tonowon ses opok, ak kiro ämän Anut nukan ämän opok rau ronkatemoi, äiein, ko Jisas mesin äiewon. Ak roasiret akas Jerusalem mena keserin ronkatear arin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Roasiret ak Jisas nukas Lasarus siräi mowon ses opok, ko pak rain, ak arirai kiro ämän karauk roasiret awareäin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Kiro onokun, roasiret ak Jisas tararau potoin. Owon, kos kiro kurur keserwon roin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Keserna, Parisi roat aka aka äiein, “Aparwe, ik ko tämuraun itok wa. Okoro omsau pakan roasiret erekapu ko tainori.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Karauk Grik omsau pakan roat akas, karauk roat kiro sumaun ses, Jerusalem näu mena, Anut nukan enip jou maun tonona, erek tainware tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Kiro Grik roat akas Filip, ko Betsaida menan ro, aparmana, aurin, “Ik Jisas aparaurum.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Keserna, Filip nukas pote Andru aurianik, awas potomoi, Jisas auririn. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisas nukas awatowon, “Ro Nukan Mokoi enip jou owaun omre rusapai peu. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Is ak epar senes awarom, wit nemauk omnokou opok nau wa, kiro karar tai rawai. Utianik, ko omnokou opok nomoi, ätäi tu pemara, nemauk sosop murai. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Inok ro ko kon totokun wous meieanik, okoro omnokou pakan osapun ronkatäi, ko aru saräi. Utianik, inok ro okoro omnokou pakan osap sumkäinemara, kon totokun wous wa meiäi, kon totok awau orip orip rawaun sakau owai. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Inok ro ko isan sarau murai, ko is tainoirai. Kiro mena is pote rawam opok isan sarau ro nais erek is pak pote rawai. Inok ro ko isan sarau murai, isan monias kon enip kämioik murai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisas nukas äiewon, “Rusapai isan woi usu sarenuk, ronkat sosop oim. Moni, na kiro tätäi owaun omre utota, is opok wa päu rai, äiäu ra? Wa. Is kiro omre tätäi näwäu owaun mesin koimin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Moni, nan enmat nakasar näwäu kämioik mo.” Kesernuk, kar oksaus omar oikas äiewon, “Is meter isan enim näwäu jou momin, ätäiar näwäu jou mam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Roasiret sosop ak kiro opok turur rain kiro ämän roumana, äiein, “Kiro ermänis äiera.” Karauk akas äiein, “Anut nukan sarau eitekus koi aurura.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Utianik, Jisas nukas awarowon, “Kiro ämän rusapai ak roi, is sareiräun wa, kiro ak sarwaraun. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Rusapai, Anut nukas okoro omnokou pakan roasiret wasarewaraun pe rau. Keseria, kos okoro omnokou kameäu ro näwäu oi känkuräi. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Is roat akas oik kuoiri muruna, isas roasiret erekapu enonwaroita, is siarap kowaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ko owose meiäun ämän äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Roasiret akas ätäi aurin, “Ik meter iken sintore ämän opok kesek roumun, Krais ko päi, wa meiäi, ko orip orip rawai. Nas Ro Nukan Mokoi kämioik kuor maiei owon keser äiem? Ro Nukan Mokoi kiro inok?” ");
INSERT INTO bbr2013_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisas nukas ätäi awarowon, “Kiro arou ak kamuk omre rumuk wa rawai. Arou merek raunukar, ak apu apari ariewe, pututu sarenuk rai, wa. Roat ak pututu ariai ak om jekur wa apariäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ak kiro arou merek oumana, ko mesin akan woiaka epar mowe. Keserna, ak arou pakan roasiret saräiei.” Jisas ko kiro ämän aware kuremara, ko utware manomoi, ämäiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisas nukas kurur atap atap akan amiakap keserwon, utianik, ko mesin akan woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Meter Anut nukan ämän roianik, areawon ro Aisaia nukan oksaus arewon epar peu, ‘Näwäu, ikes na mesin ämän are armun, inokos iken ämän mesin wou epar mowon? Anut nukas inok kon sakau ätär muruwon?’ ");
INSERT INTO bbr2013_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kiro onokun akan woiaka epar mau utoi. Owon, Aisaia nukas nais äiewon, ");
INSERT INTO bbr2013_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Anut nukas akan amiaka utup sare mareanik, akan ronkat pene marowon. Keseria, akan amiakas jekur wa aparaiei, ak jekur wa ronkatäiei. Kar, ak akan onok aru utomoi, ätäi woiaka pirirna, is akan onok aru jäkäi maram.’ Anut nukas keser äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaia nukas Jisas nukan sakau aparmara, ko mesin arewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Roat sosop pak karauk Juda roat näunäu erek ak Jisas mesin woiaka epar moin. Utianik, ak Parisi roat iminewareanik, akan woiaka epar moin äiäu wa. Akan tururiäi owan emwarona, manaiei rai ronkateanik, keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ak Anut nukas akan enmaka kämioik maraun utomoi, ak roat akas akan enmaka jou maraun rai keseriäin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisas nukas urwemara, ämän keser äiewon, “Inok roasir is mesin kon wou epar miäu, ko isanun karar wou epar mau wa, ko isan Moni is äsimoirowon konun erek wou epar miäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Inok ro ko is apairou, ko isan moni is äsimoirnuk, koimin nais aparu. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Is okoro omnokou pakan arou senek koimin. Kiro roasiret is mesin akan woiaka epar mianik, ak pututu wa rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Inok roasir isan ämän roumara, tainorau wa, is ko wa wasare muram. Is okoro omnokou pakan roasiret wasarewaraun kowau wa. Is roasiret onok aru miäi pakan ätäi imwaraun koimin. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Utianik, inok roasir ko is sumkäineirianik, isan ämän tainorau utai, kiro ämänisar ko epar wasare murai. Is okoro ämän awarom, kiro ämänisar ak tawa wasarewarai. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Is okoro ämän isan ronkat pakas mau wa, monias is äsimoirnuk, koimin, kosar kiro ämän erekapu aironuk, awarom. ");
INSERT INTO bbr2013_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Is äpu inok ro monian ämän tainorai, ko orip orip awau rawai. Keseria, ämän erekapu okoro awarom, kiro monias airowon siar awarom.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasowa, kiro tup apariäi omre, meter Israel roat akan askanai Ijip omsau ute koin ronkateäin omre penuk, Jisas ko äpu ko okoro omnokou utia, kon momok rawa omar oik tonaun omre siakup pe rau. Jisas ko kon roasiret okoro omnokou opok rai akanun wous meiewon. Ko keseriar raianik, pote, kon enipsau ak sarwaraun meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jisas kon tamareäu roat pak pututu o jena jena, Satan nukas Judas, ko Saimon-Iskariot nukan mokoi, Jisas roat näunäu akan ipiakap maronuk, wena, meiäun ronkat nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisas ko äpu momokus sakau erekapu kon ipokup mowon. Ko äpu Anut nukas ko äsimornuk, kowon, ätäi Anut rawa tonai. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Keseria, Jisas nukas o je rain opok siräimara, kon omjo rumukäu oi mianik, kar taur oumara, kon käkänik opok takewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Maro opok an we momara, kon tamareäu roat karar karar akan isoraka an kosor mareanik, kiro taur käkänik opok takewon kis akan isoraka pakan an tätäi marowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Jisas nukas akan isoraka erekapu an kosor mare mare pote, Pita siakup kounuk, Saimon-Pita nukas Jisas auruwon, “Näwäu, na isan isi an kosoraurum ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jisas nukas ätäi Pita auruwon, “Okoro onok rusapai keserim na äpu wa, tawa epar na äpu mam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita nukas ätäi auruwon, “Na isan isi wa an kosoram. Wa senes!” Jisas nukas ätäi auruwon, “Is nan ison an wa kosorita rai, na isan tamuseäim ro wa rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Jisas nukas keser aurnuk, Pita nukas ätäi auruwon, “Näwäu, keseria, na isan isi karar wa an kosorau, isan ipi pak tapi pak erek an kosor mur!” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisas nukas ätäi auruwon, “Inok ro ko an jowon, ko ukun wäpik, ko ätäi an wa jowai. Ko kon isou karar an kosorai, owon, kiro isou om aru tai ariäu. Ak erekapu akan woiaka uru ukun wäpik, eposek rai. Utianik, kar ro, ko karar kon wou uru ukun orip rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisas ko Judas nukas nuka kon iwäi jaukut ipiakap murai äpu momara, äiewon, “Ak erekapu akan woiaka uru ukun wa. Kar ro ko karar kon wou uru ukun orip.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisas nukas akan isoraka an kosor mareanik, kon omjo rumukäu ätäi oumara, momoi, kon omoi pote tanewon. Jisas nukas ak tane rain totwarowon, “Ak isan tamareäim roat, is rusapai akan isoraka an kosorim, ak kiro onoktapau äpu ra? Is rusapai kiro onok keserim, kon onoktapau awaraurim. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ak is pak areanik, airiäi, ‘Näwäu, tamukiäum ro.’ Ak kiro epar äiäi, kiro isakasar, akan tamareäim ro, akan Näwäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Is, akan Näwäu, isas akan isoraka rusapai an kosorim apari kiro onok keserim senek, tawa akas nais jaunakat akan isoraka keseriar an kosor marowe. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Is ak kiro onok ätär marom apari, is erar ro senek sareanik, ak sarwaromin, akas nais kiro onok tainorwe. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Is epar senes awarom, okoro omnokou opok, kar sarau ros kon kameäu ro itimorau senek wa. Kiro ro ko kon ro näwäus sarau maun äsimornuk, kos potomoi, kon äsimorwon ro näwäu wa itimorai. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Rusapai ak okoro ämän arom roi, kiro epar. Ak okoro ämän awarom roumana, ak tainorianik, isaka keserim senek kesermana, ak orip orip nepipir rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Jisas ätäi awarowon, “Is ak erekapu ukun orip awarau wa. Karar ro mesin äiemin. Inok roat isakasar sare maromin, kiro is äpu. Utianik, kiro ämän meter Anut nukan ämän oi areain roat akas äiein rusapai epar peu. Ak keser äiein, ‘Kiro ro ko is pak o jera, kos is iwäi murai.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Is rusapai okoro ämän awarom, tawa epar penuk, akan woiaka epar mianik, epar ak is äpu muraiei. Is orip orip raiäim. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Is epar senes awarom, inok ros roat isan ämän oi ariaun äsimwaromin imwareanik, jekur kamwarai, ko is pakur erek imäirai. Inok ros is imäirai, ko kiro ro is äsimoirnuk, koimin ko nais erek imäiäi.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisas nukas kiro ämän kon tamareäu roat awaromara, kon wou usu sarenuk, ämän ämäi mau senek warnuk, amop mianik, äiewon, “Is epar senes awarom, kar ro ak kamuk rau kos is isan iwäi jaiat akan ipiakap murai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ko kiro ämän awaronuk, ak karkairmoi, aka aka amiakas ananateanik, ronkatemana, äiein, “Ko inok ro mesin äieu?” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jisas nukan tamareäu ro kar Jisas nukas konun wous sakau meieäu, ko Jisas siakup tane rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Keseria, Saimon-Pita nukas tapaus kuiermara, auruwon, “Nas totor, ko inok ro mesin äieu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kiro ro Jisas siakup tane rawon, Jisas totoraun keresir potomoi, totorwon, “Näwäu, na inok mesin äiem?” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisas nukas ätäi auruwon, “Isan bret autau ur opok momoi, kiro ro nurita, jenuk, kiro ros karar is iwäi murai.” Keser äiemara, kon bret autau oumoi, ur opok momara, Judas, Saimon-Iskariot nukan mokoi nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas ko Jisas nukas bret oi nurunuk, Satan nukas Judas sakau ateanik, kon ronkat erekapu kamewon. Keseria, Jisas nukas Judas auruwon, “Na owon ekep raum. Na owo onok keseraun raroi kurte keser.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kon karauk tamareäu roat tane rain Jisas nukas kiro ämän Judas auruwon, ak kiro arewon ämän onoktapau äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas ko akan aiauk kameäu ro, okon, akan ronkat Jisas nukas ko pote o kau maun aurura, ara, karauk saruku roat aiauk araun aurura ra, rai äiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Keseria, Jisas nukas Judas bret autau nurunuk, oumoi, pututu kasik nomara, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ko kasik nomoi, manonuk, Jisas nukas kon tamareäu roat awarowon, “Rusapai, Ro Nukan Mokoin enip jou oi rau. Roasiret kiro aparianik, Anut nukan enip jou näwäu maiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Roasiret akas Jisas nukan enip jou orip rau aparianik, ak Anut nukan enip jou muruna rai, kiro ses opokar Anut nukas kon mokoin enip kon sakaus kämioik murai. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Isan mokoit, is ekep ak pak wa rawam. Is meter Juda roat näunäu awaromin senek rusapai ak nais awarom, ak is itaneiraiei, utianik, ak is manam opok ak manaun itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Is rusapai ak kar sintore ämän awau awarom, ‘Ak aka aka akan jaunakat akanun woiakas meiewe. Is ak mesin woias meieäimin senek akas nais jaunakat akanun woiakas meiewe.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ak karar karar jaunakat akanun woiakas meiemana, sarwarna, kiro roat akas ak epar äpu maraiei ak isan tamareäim roat senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Pita nukas Jisas totorwon, “Näwäu, na erapok uteike manaun aikom.” Jisas nukas Pita ätäi auruwon, “Pita, rusapai na is manaurim mena na tainoire manaun senek itok wa. Tawa epar is tainoiram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Kesernuk, Pita nukas ätäi auruwon, “Näwäu, na is owon na manam opok wa tainoisau rai airom? Is na sareisaun meiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisas nukas ätäi auruwon, “Na epar is sareiräun meiäm ra? Pita, is epar senes aisom, rusapai pututu, kakarau urwäu wa opok, pe totoisona, na isan enim ämäi momata, ‘is ko äpu wa’ rai 3 orip äiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisas nukas kon tamareäu roat awarowon, “Ak ronkat sosop oumoi, woiaka usu wa saräu. Anut mesin akan woiaka epar moinai, isanun nais woiaka epar mowe. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Isan monian owa ou waru sosop rau. Is akan rawaun om jekuraun manaurim. Kiro epar wa maro, is ak wa awarowom. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Is tone ak rawaun om jekur momoi, ätäi koianik, ak imwaroita, ak tone, isaka pak erek rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Is kiro mena manaurim opok kiro menan apu ak äpu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomas nukas auruwon, “Näwäu, na manaurum mena ik äpu wa. Ik owose kiro menan apu äpu mam?” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jisas nukas ätäi auruwon, “Isakasar is apu, isakasar is epar ämän onoktapau, isakasar is totomaka awau orip orip rawaun onoktapau. Inok ro ko moni rawa tonaun kar apu pakaima tonau senek wa, isan enim pakas karar tonai. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ak rusapai is äpu muroi raroi, isan moni nais äpu maiei. Rusapai ak ko äpu mianik, amiakas ko apari.” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip nukas auruwon, “Näwäu, ik momonok ätär mukota, kiro iken woiok epar mam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisas nukas auruwon, “Filip, omre rumukäu senes is ak pak raimin, na is äpu murau wa ra? Inok ro ko is apairowon, ko isan moni aparwon. Keseria, na owon moni ätär muk äiem? ");
INSERT INTO bbr2013_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filip, is moni pak raim, moni ko is pak rau, kiro nan won epar mau wa ra?” Jisas nukas kon tamareäu roat awarowon, “Is ak okoro ämän rusapai awarom, kiro isan ronkat pakas awarau wa. Isan moni ko is pak raumara, kon sarau mora. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Is Moni pak raim, Moni nais is pak rau mesin akan woiaka epar mowe. Warnuk, is kurur miäim apariai ronkatewe. Kiro akan woiaka epar maun siräi marai. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Is ak epar senes awarom, inok roasiret isanun woiaka epar moin kiro roasiret ak is kurur miäim senek maiei. Is moni rawa tonam, okon, epar senes, akas is itimoiromoi, kurur näwäu senes maiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ak isan roasiret, okon, owo onok keseraun airaiei is keseram. Keserna, mokois kon momokun sakau ätär marai. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ak isan roasiret, okon, owo osap owaun, airona, isas ak aram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisas nukas ätäiar awarowon, “Ak akan woiakas isanun meie raroi, ak isan sintore ämän kiro tainoraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Is isan moni aurita, kos ak sarwaraun Osou Näu arai. Ko ak pak orip orip rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kiro Osou Näu ko epar ämän areäu. Okoro omnokou pakan roasiret ak ko wa imäiaiei, owon, ak ko wa apariäi, ak ko wa äpu miäi. Utianik, ak isan jaiat, ak ko äpu moin, owon, ko ak pak raiäu, okon, ak pak rawai. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Is ak utwaroita, aun mokoit senek akarar wa rawaiei, is ak rawa ätäi kowam. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Omre katunak rai rai, okoro omnokou pakan roasiret ak is ätäi wa apairaiei. Utianik, ak isan tamareäim roat karar akas is apairaiei. Isaka awau raim senek, ak nais awau rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kiro omre päi ses opok, ak äpu maiei, moni is pak rau, is ak pak raim, ak nais is pak rai. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Inok ro ko isan sintore ämän roumara, jekur tainoriäu, kiro ro ko isanun wous meieu. Keseria, isan monias nais kiro ro nukanun wous meiäi. Isaka nais isan woias kiro ro mesin meieita, is isakasar ko ätär muram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ko keser äienuk, kar tamareäu ro enip Judas, ko Judas-Iskariot wa, kos auruwon, “Näwäu, owo onokun ik nan tamukiäum roat nakasar ätär mukota, äpu musam, utianik, okoro omnokou pakan roasiret na wa apaisaiei?” ");
INSERT INTO bbr2013_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisas nukas ätäi auruwon, “Inok roasir kon wous isanun meieäu, isan ämän tainorai, isan monias kiro ro nukanun wous meiäi. Iu moni ori kiro ro siakup koianik, ko pak orip orip rawamur. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Inok ro ko isanun wous meieäu wa, ko isan ämän wa tainoriäu. Okoro ämän ak rourai, kiro ämän isan wa, kiro Moni nukasar is äsimoirnuk, koimin nukan ämän. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Is ak pak okoro omnokou opok raumoi, kiro ämän erekapu awaromin. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Isan monias kon Osou Näu isan omoi oumoi, ak sarwaraun äsimornuk, kowai. Kos koianik, onok erekapu tamarai. Kos akan ronkat siräi maronuk, ak meter awaromin ämän ätäi ronkatäiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Is ak utware manaurim, okon, isas ak woiaka erer rawaun ämän awaraurim. Is woiaka erer rawaun onok ak arom. Isan woiaka erer rawaun onok kiro okoro omnokou pakan roasiret akas ak ariäi senek wa. Ak karkairianik, woiaka usu saremoi, wa iminäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Is utware manaun okoro ämän awaromin roin. Is maneanik, ätäi ak rawa kowam. Akan woiakas isanun meiäi, kis akan woiaka ereraiei, owon, is isan moni rawa tonam. Ko näwäu senes, kos is erekapu itimoire rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Is okoro ämän rusapai awarom, kiro omre päu wa rau, ak awarom, tawa kiro onok penuk, akan woiaka epar maiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","31","Is ak pak ämän ekep wa aräm, owon, okoro omnokou kameäu ro siräieu. Kos is itimoiraun sakau wäpik, utianik, okoro omnokou pakan roasiret äpu maiei isan woias moni mesin meiemara, owo onok moni nukas aironuk, is keseriäim. Siräuna, ik ute manau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisas nukas äiewon, “Isaka wain mur senes. Isan moni ko wain woi atak ro. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Isan iporu näu wa muriäu kiro monias patir kureäu. Owo iporu näu muriäu, kos itarianik, karauk isuruk oi kuremara, katu pitpatirnuk, näu sosop muriäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ak okoro ämän aroita, roin, okon, kos akan ukun erekapu kosorwon, ak ukun wäpik. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ak is pak pe pasairi rawaiei, is nais ak pak pasarware rawam. Kar am iporu ko nukarar nemauk murau senek wa, ko mu opok pasar raumara, epar nemauk muriäu. Kiro onok senek, ak is pak pasairi rawaiei, ak sarau eposek mona, Anut wou ererai. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Isaka wain mur, ak wain iporu. Inok roasir ko is pak pasairi rawai, isas nais ko pak rawam. Ko nemauk sosop murai. Ak is pak wa pasairi rawaiei, ak kar onok keserau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Inok ro is opok pasairi wa rawai, ko am iporu patiriäi senek patirna, mokup räi, kiro iporu oumoi, ep opok känkurena, jere kuräi. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Akas is pasairna, isan ämän ak opok pasar rawai, akan ronkat pakas owo osap owaun totoiraiei, kiro ak owaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Isan tamareäim ro eposek, ko isan ämän roasiret awarai, kiro isan moni kon enip jou näwäu kämioik mai. Kiro keseraiei, ak isan tamareäim roasiret senes sarena, Anut nukan wou ererai. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Monias isanun wous meieäu senek isas nais akanun woias meieäim, okon, ak isaka siarap rauna, is akanun woias meiäm. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Is isan monian sintore ämän tainorita, ko orip orip kon wous isanun meieäu senek, ak isan sintore ämän tainorna, isan woias akanun orip orip meiäm. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Is akanun isan woi erer rau. Is kiro ämän akan woiaka isan woi senek saräun awaromin. Keseria, akan woiaka näwäu senes ereraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Isan sintore ämän kesek, is akanun woias meieäim senek, akas nais karauk roasiret akanun woiakas meiewe. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kar ros kon jauk saräun kon enipsau karauk roat aronuk, akas wena, meienuk rai, ik äpu kiro epar ko kon jaukun wous meiewon. Kiro woiakas meiäun onokus karauk woiakas meiäun onok erekapu itimoriäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ak isan sintore ämän awaromin siar tainoraiei, kiro ak isan jaiat. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Rusapai isas ak sarau roat räi wa awaram. Sarau ro ko kon kameäu ron ronkat äpu wa, kesek okon, ak isan jaiat awarom. Owon, owo ämän isan monias airowon, kiro ak erekapu awaromin. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Akas is ak pak rawaun rai sare murau wa, isakasar ak isan tamareäim roat sare maromin. Akas poteanik, o uku wena, o sosop muraun sare maromin. Kiro o orip orip rawaiei. Ak isan tamareäim roat, okon, owo osap owaun moni aurna, kos ak arai. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Keseria, is ak kiro sintore ämän sakau awarom tainorwe. Ak karar karar akan jaunakat akanun woiakas meiewe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisas nukas ätäi äiewon, “Utianik, okoro omnokou pakan roasiret akas ak sauk marona rai, ak ätäi ronkatewe, kiro onok amke isaka keseriar sauk muroin senek ak opok nais keseriar keseraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ak omnokou pakan roasiret senek maro, kiro roasiret akas akanun woiakas meiewoi. Utianik, ak kiro roasiret senek wa. Keserna, isas ak okoro omnokou pakan sare maromin, okon, okoro omnokou pakan roasiret akas ak sumkäinewaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kar ämän amke awaromin ronkatewe ‘sarau ro ko kon kameäu ro itimorau senek wa’. Ak is aru muroin senek ak nais aru maraiei. Utianik, kiro roasiret akas isan ämän tainorin maro, akan ämän nais tainorwoi. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ak isan roasiret, okon, kiro onok ak opok keseraiei. Kiro omnokou pakan roat kiro ros äsimoirnuk, koimin ak ko äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Is koi, kiro roat akan onok aru mesin wa awaromin maro, ak onok aru keserin mesin ämän orip wa rawoi. Akan onok aru miäi, kiro ak is sauk muriäi. Utianik, rusapai ak äpu, ak is sauk muriäi, okon, akan onok aru ämäi mau senek wa. Kiro onokun, ak ämän orip rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Inok roasiret akas ak is sauk murona rai, ak isan moni nais sauk muraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Is ak kamuk karauk kurur roat akas keserau senek wa momin. Ak isas kiro kurur momin wa aparin maro, ak ämän orip wa rawoi. Utianik, isas sarau momin aparianik, akas iu moni ori sauk mutoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kiro onok akan sintore ämän opok jer we moin epar peu. ‘Roasiret ak is erar sauk muroin.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Osou Näu isan roasiret sarwaraun moni pak rau, isas ak rawa äsimorta, kowai. Kiro Osous Anut mesin epar ämän miäu. Ko moni pak rau kowai. Kos koumara, isan ämän amop mai. ");
INSERT INTO bbr2013_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ak nais is sarau onoktoroimin opok is pak rain, okon, akas isan ämän oumoi, karauk roasiret awaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Jisas nukas kon tamareäu roat ätäi awarowon, “Is akan woiaka epar moin wa utau rai okoro ämän awaromin. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Roat akas ak onok aru morai rai, akan tururiäi owan emwaraiei. Omre päi ses opok, roat akas ak akwarona, meiäiei. Ak kiro onok keseraiei, akas ika Anut nukan sarau eposek mururam rai äiäiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kiro onok aru ak opok keseraiei roat ak is isan moni ori äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Is okoro ämän awarom, tawa omre päi ses opok keserna, ak okoro ämän ätäi ronkatäiei. Is kiro ämän meter awarau wa, owon, is ak pak raimin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Jisas nukas ätäi äiewon, “Rusapai is kiro ros äsimoirnuk, koimin mena ätäi manaurim, ak kamuk kar ros na erapok manaurum rai totoirau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Rusapai is kiro ämän awarom, kis akan woiaka aru senes marou. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Is okoro ämän awaromin kiro epar senes. Is utware manoita, kiro ak sarwaraun itok. Is wa manoita rai, ak sarwaraun ro wa kowai. Is manoita, isas ak sarwaraun Osou äsimorta, kowai. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ko kounuk, kos okoro omnokou pakan roasiret akan onok aru miäi amop maronuk, tuku rawaun onok pak Anut nukan wasarewaraun onok pak jekur tamarai. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kos akan onok aru miäi amop marai, owon, ak isanun woiaka epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kos ak tuku rawaun onoktapau ätär marai, owon, is isan moni rawa tonam, ak is ätäi wa apairaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Wasarewaraun onok nais ätär marai, owon, okoro omnokou kameäu ro, Satan, ko monias kon onok aru erekapu wasare murianik, ko ämän orip äieu. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Is ämän sosop awaraun itok, utianik, ak rusapai ämän erekapu äpu mau senek itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Tawa kiro Osou Näu kounuk, kos Anut nukan epar ämän ak opok amop mai. Kon ronkat pakas ämän wa awarai. Kos ämän Anut nuka pakan koiäu ak awarai. Kos nais owo onok tawa päi ak awarai. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Isas ko owo ämän aurita, oumara, ak awarai, okon, kos isan enim jou murai. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Owo osap monian ipokup rau kiro isan, kiro mesin is awarom owo ämän isas Osou Näu nurita, kos ak awarai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisas nukas ätäi äiewon, “Karauk omre rai rai, ak is ätäi wa apairaiei. Ätäi karauk omre manonuk, ak ätäiar is apairaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Karauk tamareäu roat aka aka äiein, “Kiro ämän owo senek äieu? Kos ik aikomara, ‘karauk omre rai rai, ik ko wa aparam äieu, ätäi karauk omre manonuk, ik ko ätäi aparam’ aikou. Ätäiar aikowon, ‘kiro owon, is isan moni rawa manam.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Ak ätäi ätäi totorin, “Ko owo ämän aikaurmara, ‘karauk omre’ äieu. Ik kon ämän äieu onoktapau äpu mau senek wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisas nuka kon tamareäu roat akas kiro ämän mesin totoraurin äpu momara, awarowon, “Is keser äiemin, ‘karauk omre rai rai, ak is ätäi wa apairaiei, ätäiar karauk omre manonuk, ak is ätäi apairaiei,’ kiro ämän mesin aka aka tototäi ra? ");
INSERT INTO bbr2013_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Is epar senes awarom, ak woiakati aru mianik, ak waiaiei. Keserna, okoro omnokou pakan roasiret ak nepipiraiei. Ak, isan roasiret, woiaka aru mai, utianik, akan woiaka ätäi näu saremoi, nepipiraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Kar asir ko mokoi owaun ko wou aru miäu. Owon, ko tätäi näwäu owaun omre siakup pe rau. Utianik, ko mokoi oumara, ko ätäi kiro tätäi mesin wa ronkateäu. Ko mokoi mesin nepipiriäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kiro onok senek, ak opok päi. Rusapai ak woiakati marou, utianik, is ak ätäi apwaroita, akan woiaka erermoi, nepipiraiei. Kiro nepipiraiei kar ros akan woiaka uruan oi kuräu senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Kiro omre päi ses opok, akas is kar osap mesin wa totoiraiei. Is eparar senes awarom, ak isan roasiret, owo osap owaun moni auraiei, kos arai. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Meter raumun opok koi rusapai ak isan enim ateanik, kar osap owaun wa aurin. Rusapai ak aurna, kos aronuk, owaiei. Keseria, ak näwäu nepipiraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisas nukas ätäi kon tamareäu roat awarowon, “Is rusapai or ämänis awarom. Omre epar päi ses opok, or ämänis wa awaram. Moni mesin amop awaram. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kiro omre opok, ak isan enim ateanik, kar osap owaun moni auraiei. Is sakau orip, okon, akas isan enim ateanik, moni aurna, kos roianik, akan ämän tainorai. Keseria, isas akanun ko wa auram. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Is Anut pak raiminus, koimin mesin akan woiaka epar moin. Ak nais akan woiakas isanun meieäi, okon, moni nukasar akanun wous meieäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Is isan moni pak raiminus, okoro omnokou opok koimin. Keseria, rusapai is okoro omnokou utomoi, ätäi isan moni rawa tonam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Keser awaronuk, Jisas nukan tamareäu roat akas aurin, “Rusapai, na amop arem, or ämänis aräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Rusapai ik äpu mom na osap erekapu äpu, na kar ron ronkat erekapu äpu miäum, okon, na kon ämän wa totoram. Kiro mesin iken woiok epar mou, na Anut nuka pak raumonus, koumon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jisas nukas ätäi awarowon, “Ak rusapai akan woiaka epar moi! ");
INSERT INTO bbr2013_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Utianik, omre siakup pera, epar senes, rusapai pe rau, karauk roat akas ak erekapu emwarona, atap atap akan mena imine manoutaiei. Ak is utoire manona, isaka karar tai rawam. Utianik, is kararnak wa rawam, owon, isan moni ko is pak rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Is ak kiro ämän akan woiaka uru päurar rawaun awarom. Okoro omnokou opok ak usu näwäu oia, woiakati marai. Utianik, ak sakau tai rawe, owon, isakas okoro omnokou pakan sakau erekapu itimorimin.” ");
INSERT INTO bbr2013_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisas kiro ämän kon tamareäu roat aware kureanik, omar oik eisane aparmara, Anut aurmoi, äiewon, “Moni, omre rusapai peu, nan mokoin enip jou orip kämioik mur, keserta, mokois nais nan enmat jou kämioik musai. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na okoro roasiret erekapu kamwaraun sakau ko nurumon keseria, nakas roasiret ko nurumon kos awau orip orip rawaun sakau arai. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Awau orip orip rawaun onoktapau kiro, naka Jisas Krais pak äpu matoi. Na karar, na Anut, nas Jisas Krais äsimorta, kowon äpu moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Is okoro omnokou pakan roasiret nan sakau enmat jou orip pak ätär maromin. Is nas nan sarau maun äsimoiromon kiro erekapu patarmin. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Moni, meter okoro omnokou päu wa opok, is na pak raianik, enim jou orip raimin. Rusapai nan amun opok kiro enip jou orip ätäi irota, is na pak rawam. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Is nakasar okoro omnokou pakan roasiret sare mareanik, is iromon, nan sakau ätär maromin. Meter kiro roasiret nan sare maromon rain, nas is irota, akas nan ämän tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ak rusapai äpu moin osap erekapu is iromon, kiro naka pakas kowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nan ämän airomon, erekapu awaroita oin. Ak äpu kiro epar is na pak raiminus, koimin. Nas äsimoirta, koimin mesin akan woiaka epar marou. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Is ak mesin na aisom, is okoro omnokou pakan roasiret mesin aisau wa. Utianik, okoro roasiret nakasar is iromon mesin aisom, owon, kiro roasiret nan. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Isan roasiret kiro nan, nan roasiret kiro isan. Karauk roasiret ak isan roasiret akan onok aparianik, ak äpu maiei isan enim jou orip. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Is okoro omnokou opok ekep wa rawam. Rusapai is na rawa tonram, utianik, ak okoro omnokou opok rawaiei. O moni, nan onok eposek senes, nas kiro roasiret kamwareanik, nakan sakau is iromon kiro sakaus, ak sakau marota, rawaiei. Keseria, iwaka woiok karar raumur senek, ak nais woiaka karar me rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Is ak pak raianik, kiro sakau nas is iromon pakaima kamwareäim. Is jekur kamwaromin, kar ro wasaräu wa. Kiro tamareäim ro karar Anut nukas ko oikuräun apu raunuk rai, ko oikuräi. Kiro nan ämän meter äiemon epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Is rusapai na raum opok tonaurim. Okoro omnokou opok, is kiro ämän ak rowaun äiem, owon, isan woi erekapu ereriäu senek kiro akan woiaka uru nais keseriar ereraiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Is nakas ämän iromon awaromin. Kiro mesin okoro omnokou pakan roasiret akas ak sauk maroin. Owon, is okoro omnokou pakan wa. Isan roasiret ak nais okoro omnokou pakan wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Is na ak okoro omnokou pakan imware oik tonaun aisau wa, na ak sarwaraun mesin is aisom. Keserta, ro aru Satan nukas ak wa aru marai. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Is okoro omnokou pakan wa, okon, ak nais okoro omnokou pakan wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nan ämän erekapu epar senes. Nakasar nan epar ämänis akan woiaka uru sakau maronuk, ak nan roasiret tuku saräiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nas is okoro omnokou opok roasiret kamuk opok äsimoirta, koimin senek, isas nais ak okoro omnokou pakan roasiret kamuk äsimwaromin. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Is ak sarwaraun isan enimsau na isom. Keserita, ak nan roasiret tuku senes rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Is ak mesin karar aisau wa, inok roasiret isan tamareäim roat akas kiro ämän awarona, roumoi, akan woiaka epar morai ak nais sarwaraun mesin na aisom. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Isan ronkat okoro roasiret erekapu akan woiaka karar me rawaiei. Moni, naka is pak rauta, is nais na pak raim senek keseraiei. Keseria, ak iu pak rawaun is aisom. Keserna, okoro omnokou pakan roasiret akas nas is äsimoirta, koimin mesin akan woiaka epar maiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nas is kiro enip jou iromon senek, isas nais ak enmaka jou aromin, okon, iu karar raumur senek ak nais woiaka karar me rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Is ak pak pasar raim senek na is pak pasar raum. Keseria, okoro omnokou pakan roasiret äpu maiei, nakasar is äsimoiromoi, na nan won is mesin meieäum senek, na nais isan roasiret akanun wonas keseriar meieäum. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","O moni, nakasar kiro roasiret is iromon is na aisom, is tone rawam opok ak nais is pak erek tone rawaiei. Keseria, meter okoro omnokou ate mau wa opok, nas nan wonas isanun meieanik, kiro enim jou iromon ak aparaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O moni, na onok eposek miämon ro, okoro omnokou pakan roasiret ak na äpu musau wa. Okoro roasiret nas is äsimoiromon äpu miäi, ak karar epar is pakas na äpu musoi. ");
INSERT INTO bbr2013_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Isas nan enmat ak opok amop musomin ätäiar amop musam. Keserita, naka is mesin wonas meieäum senek, akas nais karauk roat mesin akan woiakas meiena, is ak pak rawam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisas ko Anut auri kuremara, kon tamareäu roat pak kar an enip Kitron kure potoin. Kiro an kasakup kon tamareäu roat pak kar woi enip Olivet woia potoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas ko Jisas kon iwäi jaukut ipiakap maun ro ko äpu Jisas kiro woia orip orip kon tamareäu roat pak poteäu. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Keseria, Judas nukas karauk Anut kamuk raiäi roat näunäu akan sarau roat pak Parisi roat akan sarau roat pak Rom akan marai roat pak imwaromara, kiro woia potoin. Ak karauk arou pak weräiäin osap pak oiar koin. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisas ko kiro onok päun erekapu äpu mowon, okon, kos ak siarakap potomara, totwarowon, “Ak inok itanerai?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Akas äiein, “Ik Nasaret menan Jisas itanem.” Kos awarowon, “Okoro is karar.” Judas ko ak pak erek tai rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisas nukas ‘okoro is karar’ awaronuk, ak karkairianik, iminemana, onkapai kurir ninoin. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Kos ätäiar awarowon, “Ak inok itane koi?” Akas äiein, “Nasaret mena Jisas.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisas nukas awarowon, “Is amke awaromin, okoro is karar. Ak is itaneiroi rai, okoro roat is pak rai utwarona, manaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kiro ämän ko meter äiewon siar epar päun keser awarowon. Ko meter äiewon, ‘Moni, is okoro roat nakasar iromon kar ro wasaräu wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon-Pita nukas kon siräp rumukäu oumara, Anut kamuk raiäu ro näwäu senes nukan sarau ro wem raiar kon rauk käu näu kaima patir kurewon. Kiro sarau ron enip Markus. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jisas nukas Pita sakau auruwon, “Nan siräp ätäi kon jowa joke mota no. Kiro tätäi monias irowon, nan ronkat is kiro tätäi wa owam ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","13","Keseria, Rom akan marai roat pak akan kamwareäu ro näwäu pak Juda roat näunäu akan sarau roat pak akas Jisas sakau ateanik, ipou muris rakirmoi, amke Annas siakup imäi potoin. Annas ko Kaiapas nukan tanau. Kaiapas ko kiro woisan opok Anut kamuk rawaun ro näwäu senes murin. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kiro Kaiapas nukas meter Juda roat näunäu keser awarowon, ‘Karar ros roasiret erekapu akan omoi oianik, meiäun itok’ rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Saimon-Pita pak Jisas nukan tamareäu ro kar pak au Jisas tainori potoirin. Anut kamuk raiäu ro näwäu senes nukas kiro tamareäu ro kar äpu mowon, okon, ko Jisas tainormara, owa tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita ko kasik ororokpai tai rawon. Kiro kar tamareäu ros ätäi kasik nomara, kiro rorok kameäu asir kos Pita owa imäi tonaun aurnuk, imäi tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kesernuk, kiro asires Pita auruwon, “Na nais kiro ros tamusiäwon ro ra?” Pita nukas ätäi auruwon, “Wa, is kon tamareäu ro wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Kiro ses opok roros, okon, kiro pakan roat pak ou kameäi roat ak ep tukurianik, ep uke rain. Pita ko nais potomara, ak pak erek ep uke rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Kiro ses pakar, Annas nukas Jisas kon tamareäu roat mesin pak kon ämän roasiret mareäwon mesin pak totorwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisas nukas auruwon, “Is roasiret akan tururiäi owa pak tup ou näwäu owa pak ämän mareäimin. Kiro opok, Juda roasiret erekapu koi tururiäi, is kar ämän ämäi ämäi awarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na owo onokun is totoirom? Kiro roasiret ak isan ämän roin na ak totwar. Is owo ämän awaromin ak äpu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisas nukas kiro ämän arenuk, kar marai ros Jisas sipou purmara, äiewon, “Na Anut kamuk raiäu ro näwäu keser auriäumon ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jisas nukas ätäi kiro ro auruwon, “Utianik, is ämän sätäiemin maro, owo sät ämän momin rai okoro roasiret awar. Utianik, is epar ämän äiem rai, na is owon sipi purum?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Keseria, Annas nukas Jisas ipou mur oripar Anut kamuk raiäwon ro näwäu senes, Kaiapas siakup äsimornuk, potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon-Pita ko tai rawon omoiar tai raumara, ep uke rawon. Karauk roat akas ätäi totorin, “Epar senes, na kiro ros tamusiäwon ra?” Kos sätäumara, äiewon, “Is kon tamureäu ro wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Kesernuk, kar Anut kamuk raiäwon ro näwäu senes nukan sarau ro pewon. Kiro ro Pita nukas rauk patirwon ro Markus nukan kinjaukus pemara, totorwon, “Na kiro ro pak woia erek rain apaisomin ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita nukas ätäi äiewon, “Wa senes wa. Is kiro ro äpu wa.” Ko keser äienuk äienuk, kakarau urwewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Marai roat akas Jisas Kaiapas nukan owas imäianik, kiro omsau kameäu ro näwäu nukan owa imäi potoin. Kiro ro ko Rom omsau pakan. Kiro tapera senes keserin. Juda roat näunäu akas kiro ro näwäu nukan owa tonau wa, owon, akan ronkat ak kon owa tonomoi, Anut nukan amuk opok ukun orip saremoi, Pasowa o wa jam rai keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Keseria, ak ko kasik kume rauna, Pailot nukas kasik nomara, roat totwarowon, “Okoro ros owo onok keserwon ak aparianik, imäi koi?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Akas ätäi äiein, “Ko onok aru keserau wa maro, ik ko na siatap wa imäi kowom.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailot nukas awarowon, “Ak ko imäi potoinai, akan sintore ämän tainornai, kon onok aru mowon aparwe.” Keseria, Juda akan roat näunäu akas ätäi keser aurin, “Iken ipiokos kar ro weta, meiäun itok wa. Kiro onok Rom akan.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Meter Jisas nukas nuka meiäun ämän mianik, ko kiro onok pakas meiäun äiewon. Kon ämän rusapai epar päuru. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Keseria, Pailot ko ätäi owa tonomara, Jisas urunuk, tononuk, totorwon, “Na Juda roasiret akan kamwaraun ro näwäu king ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jisas nukas ätäi auruwon, “Kiro ämän äiem nakan ronkat pakas ra, karauk roat akas na aisoin is totoirom ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pailot nukas ätäi auruwon, “Nan ronkat is Juda ro ra? Na owosemon ämän is äpu wa. Nakan roasiret pak Anut kamuk raiäi roat näunäu pak akasar na is rawa imäisi koin. Na owosemon? Is air.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jisas nukas äiewon, “Isan kamäun mena okoro omnokou opok rawau wa. Wa senes wa. Isan kamäun mena okoro omnokou opok rau maro, isan tainoireäi roat akas isan kaima sareirianik, weräuna, is Juda roat akan ipiakap wa muruwoi. Utianik, isan kamäun mena okoro omnokou pakan wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kesernuk, Pailot nukas ätäi totorwon, “Keseria, na kar menan kamwaraun ro näwäu epar ra?” Jisas nukas ätäi auruwon, “Kiro ämän nakan ronkat pakas peu kiro epar. Isan anias okoro omnokou opok kiro onokun murowon. Is epar ämän äiäm, kiro isan sarau. Inok roasir epar ämän tainoriäu, ko isan ämän roiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailot nukas Jisas auruwon, “Epar ämän, kiro owo senek?” Pailot nukas kiro ämän aurianik, ko ätäi kasik Juda roat rain opok nomara, awarowon, “Is okoro ros kar onok aru mowon aparau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Utianik, ak äpu iken onok, is orip orip woisan karar karar opok, Pasowa sumaun omre opok, karapus ro karar utoita, maneäu. Keseria, akan ronkat is ‘Juda roasiret akan kamwaraun ro näwäu’ utomaroita, manai ra?” ");
INSERT INTO bbr2013_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Akas ätäi Pailot sakau kakurarianik, äiein, “Wa senes wa. Ko wa. Bar-Abas utomukota, manai.” (Bar-Abas ko kar päu ro aru.) ");
INSERT INTO bbr2013_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Keser aurna, Pailot nukas kon marai roat Jisas imäi mänkäsiraun awaronuk, mänkäsirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Marai roat akas rumäkät katuau orip oumana, tatmaianik, kon tapau opok kuror murin. Keseria, omjo osou king nukan senek oianik, orke murin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ko siakup pemana, ätäi ätäi jeje ämän aurin, “Na Juda roasiret kamwaraun ro näwäu king orip orip rawam!” Keser aurmoi, sipou purin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailot nukas ätäi kasik nomara, roasiret awarowon, “Ak aparwe. Is ko kasik ak amiakap imäi koim, kiro ak äpu maiei is okoro ron kar onok aru mowon aparau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Keseria, Jisas mur katuau king nukan at orip pak omjo osou orip kasik nonuk, Pailot nukas awarowon, “Aka äiein ro okoro aparwe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Keser awaronuk, Anut kamuk raiäi roat näunäu pak tup ou näwäu kameäi roat pak akas Jisas aparmana, Pailot sakau ämän aurin, “Am äpäs opok we mota, meiäura. Am äpäs opok we mota, meiäura.” Keserna, Pailot nukas awarowon, “Akasar imäinai, am äpäs opok äsäi mowe. Is ko weita, meiäun kar onok aru kos keserwon wa aparim.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Utianik, akas ätäi Pailot aurin, “Iken sintore ämänis keser äieu, kiro ro meiäura, owon, nukasar ‘is Anut nukan Mokoi’ rai äiewon.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailot ko kiro ämän roumara, sakau iminewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Keseria, Pailot nukas ätäi owa tonomara, Jisas totorwon, “Na owo menan?” Ko keser auruwon, utianik, Jisas nukas kar ämän ätäi aurau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pailot nukas Jisas ätäi auruwon, “Na owon is are murau utom? Na äpu wa ra? Roat näunäu akas is sakau iroin. Is na utoisoita, manaun itok. Na am äpäs opok iwosoita, meiäun itok.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisas nukas ätäi auruwon, “Na is am äpäs opok äsäi muram äiem, kiro Anut nukasar kiro keseraun sakau isowon. Utianik, inok ros is imäirianik, nan ipon opok murowon, kiro ron onok arus nan onok aru erekapu itimori rau.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pailot ko Jisas nukas kiro ämän äienuk, roumara, owo apu pakas Jisas utonuk, manaun rai ronkatewon. Utianik, roasiret akas ätäi keser urwein, “Na kiro ro utota, manonuk rai, na Sisa* nukan jauk wa rawam. Inok ro ko nukasar is kamwaraun ro näwäu äiäi, ko Sisa nukan iwäiauk.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailot ko kiro ämän roianik, Jisas imäumara, ne wasarewareäi sia opok tanewon. Kiro omoi Ibru ämänis Gabata äiäi. (Ämän onoktapau ‘ai pasar’.) ");
INSERT INTO bbr2013_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pasowa tup aparaun omre ariwa päi, okon, ak rusapai senek akan osap jekur miäi. San näu kamuk opok, Pailot nukas roasiret awarowon, “Akan kamwaraun ro näwäu aparwe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Akas ätäi urwein, “Wena, meie! Wena, meie! Am äpäs opok wena, meiäura!” Pailot nukas awarowon, “Akan ronkat isas akan kamwareäu ro näwäu am äpäs opok weita, meiäura ra?” Anut kamuk raiäi roat näunäu akas äiein, “Ik kamoikeäu ro kar wa rau. Sisa karar ko iken kamoikeäu ro näwäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ak keserna, Pailot nukas Jisas am äpäs opok wena, meiäun marai roat ipiakap marowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ak Jisas imäi potona, ko nukasar nukan am äpäs ämäumara, näu mena utomoi, kar om enip ‘Op Tapau Sekerem’ omtorou opok tonowon. Ibru ämänis kiro mena Golgota äiäi. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Keseria, kiro mena, am äpäs opok äsäi moin. Kar ro oirori au nais Jisas pak erek am äpäs atap atap karaim karaim äsäi matoin. Jisas ko kiro ro ori kampai äsäi moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailot nukas kar jer keser we mowon, ‘Nasaret menan Jisas. Ko Juda roasiret akan kamwareäu ro näwäu, king.’ Keser jer wemoi, am äpäs opok äsäi moin kon tapakup we mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ak näu mena siakup, Jisas äsäi moin. Keserna, roasiret sosop kiro jer Jisas nukan tapakup we mowon ninareäin. Kiro jer Ibru ämän, Rom ämän pak Grik ämänis pak wewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Kesernuk, Anut kamuk raiäi roat näunäu akas Pailot aurin, “Na owon kiro ro ko Juda roasiret kamwareäu ro näwäu king rai jer we momon? Nukasar ‘Is Juda roasiret kamwareäim ro näwäu, king’, äiewon. Na owon keser jer we mau utom.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Keserna, Pailot nukas ätäi awarowon, “Isas owo ämän jer we momin kiro äiäk, keseriar rawaura.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Marai roat akas Jisas am äpäs opok äsäi momoi, kon omjo 4 orip inäianik, karar karar oin. Kon omjo rumukäu orkewon nais oiar arin. Kiro omjo karar rumukäu erekapu näkein. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Marai roat akas aka aka äiein, “Kiro omjo wa kiräiäu. Ik aiauk oianik, satu sipiräieanik, aparau inokos owai.” Keserna, kiro ämän meter jer wein epar pewon. ‘Akas isan omjo aka aka inäi oin. Isan omjo rumuk mesin aiauk sipiräieanik, oin.’ Kiro onok marai roat akas keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisas nukan am äpäs siakup kon anak pak, kon änäiauk pak, Klopas nukan wau enip Maria pak, Magdala menan Maria erek, ak kiro opok tai rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisas nukas nukan anak pak kon tamuruwon ro mesin wous meieäu pak apwatomara, anak keser auruwon, “Asir, okoro ro, ko nan mokoi senes.” ");
INSERT INTO bbr2013_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Keseria, ätäi kiro tamuruwon ro auruwon, “Okoro asir, kiro nan anin.” Kesernuk, kiro ses opokar, Jisas nukan anak kiro tamuruwon ros kon owa imäi pote me rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisas ko äpu rusapai Anut nukas okoro omnokou opok sarau maun auruwon, sarau erekapu patarwon. Keseria, Jisas nukas äiewon, “Is an pätiru.” Kesernuk, kiro ämän meter Anut nukan buk opok äiewon siar kiro epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kar maro wain an tiu orip siakup rawon, okon, ak kar osap jaimirmir senek oumana, kiro wain an tiu sourmoi, amauk opok mianik, kon oksau opok moin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisas ko kiro wain an tiu jemara, äiewon, “Rusapai sarau ki pataru.” Keser äiemara, ko kon tapau akuräi nonuk, kon osou utonuk, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kesernuk, Juda akan kamwareäi roat näunäu akas am äpäs opok äsäi maroin roat isoraka piriporurna, kurte meiena, imware naun Pailot aurin. Ak keser totorin, owon, kiro omre osap jekur miäi. Akan sumaun omre ariwa, okon, akan ronkat ak kiro roat akan enmaksau utwarona, kiro omre opok am äpäs opok rawaun senek wa, okon, keser äiein. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Keseria, marai roat akas potomana, kiro roat ori Jisas pak äsäi matoin isorawa porurin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ak Jisas ko meiewon aparianik, kon isou porurau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Utianik, kar marai ros kon marais Jisas nukan kasak uru wenuk, kurte karian an orip kounuk, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Ro nukasar kiro onok keserin aparmara, äiewon, “Kiro onok epar pewon.” Ko nukasar äpu ko epar ämän karar äieu. Keseria, ak nais akan woiaka epar mowe.) ");
INSERT INTO bbr2013_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Kiro onok keserin kiro meter Anut nukan buk opok äiewon, epar peu. Keser äiewon, ‘Akas kon kar isuauk wa poruraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Kar ämän meter Anut nukan buk opok nais äiewon, ‘Roasiret kiro ro marais wein ui kur orip aparaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kiro keserna, kar ro kon enip Josep, ko Arimatea menan, ko Jisas nukan enipsau am äpäs pakan oi manaun pe Pailot auruwon. Josep ko nais Jisas nukan tamuriäwon ro, utianik, ko Juda akan kamwareäi roat näunäu iminewareanik, ko Jisas mesin wou epar mowon ämäi mowon. Pailot nukas ‘io’ aurnuk, ko pote, Jisas nukan enipsau am äpäs pakan owon. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimas kiro ro ko meter Jisas aparaun pututu potowon, ko nais koumara, Josep pak Jisas nukan enipsau owaun potowon. Ko kar am ankas sou eposek peäu oumara, potowon. Kiro am ankas kon usu 30 kilo orip. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Kiro roat ories Jisas nukan enipsau oumasa, am ankas sou eposek joutor mianik, omjos kon enipsau rakir moirin. Kiro onok Juda akan roat meiäi up kurwaraun keseriäi senek keserin. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jisas am äpäs opok äsäi moin siakup, kar plaua woi rawon. Kiro plaua woia kar aireu awau tuein. Kiro uru meter kar ro mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Kiro ses opok, Juda roasiret akan sumaun omre päurnuk, kiro aireu siakup rawon, okon, au Jisas imäi pote kiro aireu uru moirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Tup Näu opok, pututu om teine kounuk kounuk, Magdala menan Maria ko Jisas up opok aparaun potowon. Ko potomara, kiro aiauk näwäus im pene moin oi kurein aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Kos ätäi kurte, Saimon-Pita pak Jisas nukas kon tamareäu ro kar ko mesin wous meieäu pak au siarawap potomara, awatowon, “Karauk roat akas Näwäu nukan enipsau up uruan imäi manoin. Ko erapok pote ämäi moin rau rä! Ik äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Keseria, Pita kiro tamureäwon ro ori siräumoi, up opok potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kiro ro Pita ori au erek kurte potoirin. Kiro ros Pita itimormara, kurte ko tet amke up opok potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ko poteanik, up kasikas kuoinemara, aireu uru amuk kurewon. Ko omjo Jisas nukan enipsau kururur moin rawon aparwon. Ko up uru tonau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Saimon-Pita ko ruris pemara, aireu uru tonomara, kiro omjo rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Kar omjo tapau opok rakir moin nais rawon aparwon. Kiro omjo kar omjo pak turur rawau wa ko kar ros jekur miäu senek keser monuk, rawon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kesernuk, kiro ro ko amke up opok pewon ko nais aireu uru tonowon. Ko kiro osap aparmara, kon wou epar mowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kiro ses opok, ak kiro ämän Anut nukan buk opok ko ätäi siräiäi rai äiewon jekur äpu mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Keseria, kiro tamatowon roat ori au ätäi mena ute potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maria ko kiro up siakup tai raumara, wai rawon. Ko wai wai raianik, kuoinemara, kiro up uru amuk kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Anut nukan sarau eitek oirori omjo ärneu oripas Jisas nukan enipsau nini moin opok tane rairin. Kar tapau pakas tane rawon, karas isou pakas tane rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Awas Maria keser totoririn, “Asir, na owo mesin wonti musonuk, waieram?” Kos ätäi awatowon, “Isan Näwäu nukan enipsau oi manoin. Is äpu wa erapok moin rä!” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ko keser äianik, pirirmara, Jisas tai rawon aparwon. Kiro asir ko Jisas nukan nepu aparianik, äpu mau senek wa, ko wou wewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Keseria, Jisas nukas totorwon, “Na owo itanemata, waieram?” Maria kon ronkat kiro woi kameäwon ros raumara, keser äieu rai, auruwon, “Ro näu, nas kon enipsau oi manomon raroi, kon enipsau erapok oi pote momon airota, pote imäiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisas nukas auruwon, “Maria.” Kesernuk, Maria kon pätu roumoi, piririanik, Jisas jekur aparianik, äpu muromara, Ibru ämänis keser äiewon, “Rabonai.” Kiro ämän onoktapau kesek, ‘Tamukiäum ro’. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisas nukas ätäi auruwon, “Is isan moni rawa tonau wa raim, okon, nas is wa atoirau. Utianik, na potoinam, isan tamareäimin roat awar, ‘Is isan moni rawa tonaurim. Ko nais akan momonaka, isan Anut, akan Anut erek.’” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Keseria, Maria nukas potomara, Jisas nukan tamareäwon roat awarowon, “Is Näwäu ätäi siräiwon aparmin.” Jisas nukas auruwon ämän kiro tamareäwon roat erekapu awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Jisas nukan tamareäwon roat ak Juda akan roat näunäu iminewareanik, akan raiäi owa im sakau penemoi, rain. Tup näwäu opok, pututu, Jisas nukas kon tamareäwon roat kamuk pe tai raumara, awarowon, “Ak akan woiaka päurar rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ko keser awaromara, kon ipou wein pak kon kasak uru marais wein ui kur ätär marowon. Kon tamareäwon roat ak Näwäu aparmoi, nepipirianik, woiaka ererin. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisas nukas ätäi awarowon, “Ak akan woiaka päurar rawai. Isan monias is äsimoirnuk, koimin senek isas nais keseriar ak äsimwarom.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Keser awareanik, kon au osou ak opiakap urmara, äiewon, “Akan woiaka uru Osou Näu owe. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Keseria, akas karauk roat akan onok aru jäkäi marona rai, Anut nukas nais kiro roat akan onok aru erekapu jäkäi marai. Utianik, akas karauk roat akan onok aru wa jäkäi marona rai, Anut nukas nais akan onok aru wa jäkäi marai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jisas kon tamareäwon roat amiakap pewon ses opok, kon tamareäwon ro kar kon enip Tomas, kon kar enip Didimas, ko ak pak rawau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ko ätäi penuk, kon jaukut akas aurin, “Ik Näwäu aparmun.” Tomas nukas ätäi awarowon, “Utianik, isan amias kon ipou ui kur aparita, isan ipias kon kasak uru marais wein ui kur opok moita, kiro epar isan woi epar mam.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tup manonuk, kar omre Jisas nukan tamareäwon roat ak erekapu ätäi owa im sakau penemoi, turur rain. Kiro ses opok, Tomas pak erek rain. Im sakau penein, utianik, Jisas ko ätäi pemara, kon tamareäwon roat kamuk pe tai raumara, awarowon, “Ak akan woiaka päurar rawai.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Keseria, kos Tomas auruwon, “Nan iponauk isan kasi opok moinam, isan ipi apar. Na ronkat sosop utoinam, nan won epar mo.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Kesernuk, Tomas nukas Jisas auruwon, “Na isan Anut is jou musiäim, na isan Näwäu.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jisas nukas auruwon, “Na is apairmata, nan won epar mom ra? Karauk roat ak is apairau wa, akan woiaka epar moin kiro roat akan woiaka näwäu ereraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisas nukas kon tamareäwon roat amiakap kurur atap atap keserwon, okoro buk opok erekapu jer we mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Utianik, Jisas ko Krais, kiro ro Anut nukas kon roasiret ätäi imwaraun äsimornuk, kowon, ko nais Anut nukan Mokoi senes mesin akan woiaka epar maun rai jer wemin. Keseria, ak ko mesin akan woiaka epar mianik, ak awau orip orip rawaiei. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Omre rumukurar manonuk, Jisas nukasar ätäi Galili An Unik siakup kon tamareäwon roat amiakap pewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Kiro opok kon tamareäwon roat kesek rain, akan enmak Saimon-Pita, Tomas (kon kar enip Didimas), Nataniel (Nataniel ko Kena menan Galili provins pakan), Sebedi nukan mokoit ori pak Jisas nukan kar tamateäwon roat ori pak ak erek rain. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon-Pita nukas kon jaukut keser awarowon, “Is was owaun manaurim.” Kesernuk, kon jaukut akas nais aurin, “Ik erek na pak was owau manam.” Keseria, kiro roat erekapu ak ous opok toneanik, manoin. Kiro pututu ak kar was owau wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Om teine kounuk kounuk, Jisas ko Galili An Unik kasakup tai rawon aparin. Utianik, kon tamareäwon roat akas Jisas owo ro rai wou wein. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Keserna, kos totwarowon, “O, Jaiat, ak karauk was oin ra?” Akas ätäi aurin, “Wa senes wa. Ik kar was owau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Kos ätäi awarowon, “Akan was oiäi jo oinai, ous kasakup ipiaka näu kaimas kureinai, karauk was owaiei.” Keser äienuk, akas Jisas nukan ämän tainorianik, akan was oiäi jo ipiaka näu kaima kureanik, ätäi ate reurna, ous oik päu senek wa, owon, was sosop ok pe rau. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Keseria, Jisas nukas kon tamareäwon ro kar konun wous meieäu kos Pita auruwon, “Kiro ro us nokou opok tai rau, kiro iken Näwäu!” Saimon-Pita ko akan Näwäu us nokou opok tai rau auruwon roumara, ko kon omjo oi momara, sarau me rawon kurte oi orkemara, an unik uru pokir neanik, an äsäi potowon. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Karauk tamareäwon roat ak ous opokas was jo ok pewon orip reur an kasakup koin, owon, us nokou atapuk wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ak kasakup koianik, ep jere rawon aparin. Kiro ep opok, karauk was rawon pak bret ep somuk rawon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Keserna, Jisas nukas awarowon, “Ak karauk was rusapai oin oi kowe.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon-Pita nukas kurte ous oik tonomara, was jo orip reur kasakupai kowon. Was näunäu sosop, 153 orip rain. Was sosop jo ok pewon, utianik, jo wasas kiräiäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisas nukas awarowon, “Ak o jau pewe.” Kesernuk, kon tamareäwon ro karas sakau mianik, ‘na inok ro’ rai totorau wa. Owon, ak äpu kiro Näwäu nuka. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Keseria, Jisas nukas ep somuk pemara, bret oumara, arowon. Ko was nais keseriar keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisas meieanik, ätäi up uruas siräiwon ses opok amke kon tamareäwon roat owa rain opok oirorpai amiakap pewon. Rusapai okoro keserwon kiro 3 amiakap pewon. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jisas kon tamareäwon roat pak o je kuremana, Jisas nukas Saimon-Pita totorwon, “Saimon, Jon nukan mokoi, nas okoro roat rai itimwareanik, nan won is mesin meieäum ra?” Kos ätäi auruwon, “Io, Näwäu, naka äpu. Is nanun woi ereru.” Jisas nukas auruwon, “Na isan sipsip nakut o aram.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ätäi Jisas nukas totorwon, “Saimon, Jon nukan mokoi, na epar nan won is mesin meieäum ra?” Kos auruwon, “Io, Näwäu, naka äpu. Is nanun woi ereru.” Jisas nukas auruwon, “Na isan sipsip jekur kamwar.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ätäiar, Jisas nukas totorwon, “Saimon, Jon nukan mokoi, na isanun won ereru ra?” Pita ko Jisas nukas ätäiar 3 orip totorawa, kon wou usuäu sarenuk, auruwon, “Näwäu, owo onok erekapu nakasar äpu. Na äpu is nanun woi ereru.” Jisas nukas auruwon, “Na isan sipsip nakut o aram. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Is na epar senes aisom, na mokoi awau opok, na erapok manaun ronkatemata, maneäum. Tawa na koiam sareanik, nan ipon kuorta, karauk roat akas muris rakisianik, na kar mena potaun utam opok imäisi potaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Jisas ko kiro ämän äiewon owo onok pakas Pita meieanik, Anut nukan enip kämioik maun äiewon.) Keseria, Jisas nukas Pita auruwon, “Na is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pita nukas mäinemara, Jisas nukas tamareäwon ro kar ko mesin wous meieäu, ruris au siarawap pe tai raunuk, aparwon. (Meter Jisas pak o jein ses opok kiro ros siakup tane raumara, totorwon, “Näwäu, inok ros na iwäi jaunat ipiakap musai?”) ");
INSERT INTO bbr2013_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita nukas kiro ro aparmara, Jisas totorwon, “Näwäu, okoro ro ko owosäi?” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisas nukas ätäi auruwon, “Utianik, isan ronkatis is ko utoita, raunuk raunuk, is ätäi kowam, na owon kiro mesin ronkat sosop oum? Naka, is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kesernuk, kiro tamureäwon ro wa meiäi rai ämän erekapu Jisas mesin woiaka epar moin roasiret opok potonuk erekapu roin. Utianik, Jisas nukas ko wa meiäi rai äiäu wa. Ko keser äiewon, “Utianik, isan ronkatis is ko utoita, raunuk raunuk, is ätäi kowam, na owon kiro mesin ronkat sosop oum?” ");
INSERT INTO bbr2013_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jisas nukan tamuruwon ro kos rusapai kiro onok mesin ämän äianik, kosar okoro ämän jer wewon. Ik äpu okoro kon ämän äiewon, kiro epar senes. ");
INSERT INTO bbr2013_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisas nukas karauk onok sosop nais keserwon. Utianik, is kiro karauk onokun ämän karar karar buk opok jer erekapu wemin maro, isan ronkat kiro buk sosop okoro omnokou opok rawaun omoi wäpik.");
INSERT INTO bbr2013_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O jai Tiofilus, na Anut nukan wonas meieäum ro. Is amke Jisas nukas onok eposek keserwon pak kos sarau mowon pote, ko omar oik tonowon pak, kiro ämän erekapu jer we musianik, aisomin. Jisas ko Anut nukas omar oik imäi tonau wa opok, ko Anut nukan Osou Näu nukan sakau oripas kon ämän oi ariai roat* sare marowon kon ämän jekur awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jisas ko meieanik, ätäi awau siräumara, kon tamareäwon roat amiakap orip orip peäu. Omre 40 orip ko kesernuk, ak äpu moin epar nukasar kiro ko meiäu wa, ätäi siräiewon. Kos ak Anut nukas ätäi koi kamwaraun ämän awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kar muti ko erek ak pak pe raumara, awarowon, “Ak Jerusalem näu mena wa ute manau. Ak kame rauna, Osou Näu meter moni nukas ak araun paip marowon kiro mesin awareäim kiro kos arai. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Meter Jon nukas roasiret anas an jomarowon*. Utianik, omre rumuk wa, Anut nukas nukan Osou Näus ak an jomarai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kar omre opok, Jisas nukan ämän oi ariain roat erekapu Jisas pak ätäi tururianik, akas Jisas totorin, “Näwäu, kiro ses opok na iken iwäinokot emwareanik, Israel* roasiret okoro Judia provins ätäi aram ra?” ");
INSERT INTO bbr2013_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Keserna, Jisas nukas ätäi awarowon, “Kiro akan sarau wa. Isan moni nukasar kon sakaus kiro omre isas okoro omnokou kamwaraun sare mowon. Ak kiro omre äpu mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Utianik, Anut nukan Osou Näu ak opok kounuk, kiro ses opok ak sakau oripas Jerusalem näu mena pak Judia provins pak Samaria provins pak, omsau sau erekapu potomoi, isan enim roasiret awaraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ko kiro ämän aware kurenuk, Anut nukas ko omar oik imäi tonowon. Ak apai rauna rauna, kar ious pemara, ko kururur mowon, ak ko aparau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","11","Ko erekapu manonuk, ak omar oik aparam rai eisane rauna rauna, ro oirori awan omjo ärneu oripas kurte ak siarakap pe tai raumasa, äieirin, “Galili provins pakan roat, ak owon okoro opok tai raumana, omar oik eisane rai? Kiro Jisas ko rusapai Anut nukas ak opakan imäianik, omar oik tonou apari senek, tawa ätäi keseriar kowai aparaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Keseria, Jisas nukan ämän oi ariai roat ak Olivet omtapau utomana, ätäi Jerusalem näu mena tonoin. Kiro omtapau Jerusalem mena siakup rau. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ak näu mena tonomoi, akan ou waru kämioik raiäin opok tonoin. Kiro roat akan enmaka Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomiu, Matiu, Jems ko Alfius nukan mokoi, Saimon ko kar tupsiu enip Serot pakan, Judas ko Jems nukan mokoi. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Kiro roat Jisas mesin woiaka karar mianik, Anut aurna, karauk asiret pak Jisas nukan anak Maria pak kon amakut pak erek ak nais orip orip tururianik, Anut auriai. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","16","Kar omre roasiret akan woiaka Jisas mesin epar moin 120 orip turur rain opok, Pita nukas akan amiakap siräumara, äiewon, “O jaiat, Judas nukas, Jisas marai roat akan ipiakap marowon. Kiro mesin meter Anut nukan osous Devit nukan oksau pakas äiewon kiro rusapai epar peu. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas ko meter iken sarau jaunok, Jisas nukas ik pak erek sarau maun sare mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Kiro ro Judas onok aru mianik, aiauk oumara, kiro aiaukus omnokou eteinak kau mowon. Kiro opok nukasar am iporu opok pomur oumara, meienuk, kon nokou tapau puturmoi, pimur erekapu omnokou opok kourwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Roasiret erekapu ak Jerusalem mena rain ak kiro ämän roumana, ak kiro omnokou enip Akeldama moin. Kiro ämän kon onoktapau Karian omnokou.) ");
INSERT INTO bbr2013_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kiro ämän meter Buk Song opok keser jer wewon, ‘Kon ou erar rawaura, kar ros kiro owa wa rawai.’ Kar ämän Buk Song opok nais rau, keser äiewon, ‘Kar ros kon sarau owoura.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Keseria, ik rusapai kar ro ika kamuk erek ariäu, kiro ses opok Jisas Näwäu ik pak erek raunuk, kiro ro ko erek rawon sare mau. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Meter Jon nukas roasiret an jomarowon ses opok koi, Jisas sarau onoktorowon pote kiro ses opok Anut nukas Jisas ätäi omar oik imäi tonowon. Kar ro ko kiro onok erekapu kon amukus aparwon ik ko sare mau. Ko ik pak sarau erek mia, Jisas ätäi siräiewon ämän roasiret maraura.” ");
INSERT INTO bbr2013_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pita nukas keser äienuk, akas ro oirori sare matoin. Kar ro Josep, Bar-Sabas äiäi, kon kar enip Jastus. Kar ro kon enip Mataias. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Keseria, ak Anut keser aurin, “Näwäu, na roat akan ronkat woiaka uru äpu. Keseria, nakas okoro roat ori rair, owo ro nan sarau musaun sare momon ätär muk. ");
INSERT INTO bbr2013_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Ko Judas nukan omoi oumara, sarau mai. Judas kiro sarau Jisas nukan ämän oi araun utomoi, ko om aru opok manowon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Keseria, akas kiro roat ori kamuk inok sare maun satu sipiräiein. Mataias nukan aiauk eposek pewon. Keseria, ak Mataias sare moin. Keserianik, ko ämän oi ariai roat 11 orip rain pak pote tururwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kar omre, enip Pentikos* penuk, roasiret akan woiaka Jisas mesin epar moin karar owa turur rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Rauna rauna, kar jejep urir sakau senekus kurte omar oikas kounuk, roasiret kiro owa rain ak erekapu kiro jejep näwäu roin. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kesermara, ak ep arou menop senekus koi käumara, roat karar karar akan tapiakap iporwon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kiro roat erekapu Anut nukan Osous akan ronkat erekapu kamwareanik, sakau maronuk, ak ämän atap atapus karauk omsau pakan ämänis arein. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kiro opok, Juda roasiret ak Jerusalem mena rain. Karauk Juda roasiret Anut jou muriäi omsau atap atap pakas koin pak erek rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ak kiro jejep roumana, roasiret sosop kiro ou siakup tururin. Roasiret akan woiaka epar moin ak akan menan ämänis atap atap arein roumana, ak erekapu karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ak karkairmana, ronkat sosop mianik, äiein, “Kiro roat ak keser arei ak erekapu Galili provins pakan roat. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Utianik, ik erekapu karar karar iken menan ämän arena, roum. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","10","Ik erekapu omsau atap atap pakan, Partia, Midia, Elam, Mesopotemia, Judia, Kapadosia, Pontus, Esia provins pakan pak karauk Prigia, Pampilia, Ijip pak Libia Sairini mena siakup pak karauk Rom näu mena pakan koi raum. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ik karauk Juda roat pak karauk kar omsau pakan roat Juda akan onok tainorin roat pak ik karauk Krit omsau pak Arebia provins pakan koi raum. Utianik, Galili roat ak Anut nukas kurur atap atap keserwon mesin iken ämän atap atapus arena, ik erekapu roum.” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ak keser äumana, karkairianik, ronkat sosop oumoi, aka aka tototein, “Kiro owosei?” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Keserna, karauk roat akas jeje ämän awaromana, äiein, “Kiro roat an sakau jeanik, keseri.” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pita nuka pak Jisas nukan ämän oi ariai roat 11 orip erek siraumana, kos ämän roasiret keser awarowon, “Ak Juda roasiret pak karauk roasiret erekapu Jerusalem näu mena koi rai, ak rowe. Ak isan ämän maraurim okoro onok pewon kon onoktapau awaraurim ak jekur rowe. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Akan ronkat okoro roat an sakau jeanik, raiaka käieu aikoin. Utianik, rusapai okoro 9 klok tapera karar keseru. Keserianik, okoro roat ak an sakau jau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Rowe! Anut nukan ämän roianik, areawon ro* Joel nukas kiro onok mesin äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Anut nukas äiewon, ‘Omre wasaräun ses siakup, is isan Osou Näu erekapu roasiret opok äsimoram. Keserita, akan mokoit asinakut owo onok tawa päi aräiei, is akan mokoit onok atap atap ätär maroita, aparaiei. Koiam roat nine epiräiei. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Epar senes kiro ses opok is isan Osou Näu sakau orip isan sarau roasiret opok äsimoram. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kurur atap atap omar omnokou ori opok matam. Kiro ses opok omar oikas karian pak, ep arou pak, epit pak päi. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","San wa jerai, pututu senes saräi. Keir karian senek osou saräi. Kiro osap penuk, Anut nukan omre sakau näwäu päi. Kiro omre näwäu arou näu orip. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Inok roasir Näwäu keser aurai, “Näwäu, isan onok aru pakan imäir,” keser aurnuk, kiro roasir Näwäu nukas imäiäi.’ Joel nukas keser jer wewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israel roasiret! Ak okoro ämän rowe! Anut nukas Jisas Nasaret menan ro sare momara, äsimornuk, kowon. Anut nukan sakaus kiro ro sarau sakau mowon. Ko ak kamuk kiro sarau monuk, ak kiro aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Meter Anut nukasar Jisas akan ipiak opok maraun apu sarewon. Keseria, akas ko onok aru miäi roat akan ipiakap marona, akas ko am äpäs opok äsäi mianik, wena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Utianik, Anut nukas kiro ro ätäi siräi mowon. Ko kon meiewon tätäi kiro opok utomoi, imäi manowon. Jisas ko op up uru rawaun itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kiro mesin Devit nukas äiewon, ‘Näwäu ko is siarap orip orip raiäu. Ko is siarap raumara, sakau muriäu. Keseria, kar osapus is wa itimoirai. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Keseria, isan woi erernuk, nepipiraun ämän mom. Is äpu is ro meiäun itok, utianik, is kiro osap eposek owaun kame raim. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Owon, na is utoirota, meieäi akan mena wa rawam. Nan sarau ro eposek utota, up uru wa pomoräi. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Na awau orip orip rawaun apu ätär muriäum. Na is pak rauta, kiro nan amun opok is nepipirianik, rapor rawam.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","O Jaiat, Israel roasiret, is iken askanai Devit mesin epar awaraurim. Ko meienuk, roasiret akas up uru kurein. Kon up rusapai okoro rau. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ko Anut nukan ämän roianik, areawon ro ko äpu Anut nukas paip muruwon. Anut nukas ämän sakau orip auruwon, ‘tawa nan kar asan päi. Ko roasiret nas kamwarom senek kos nais kamwarai.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Devit ko tawa Anut nukas owosäi ko äpu momara, Krais* ätäi siräiäi mesin keser äiewon, ‘Ko meieäi akan mena utonuk, wa rawai. Ko Anut nukan ämän areawon ro, ko Anut nukas paip muruwon äpu Anut nukas utonuk, kon enipsau wa pomoräi.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Keseria, Anut nukas kiro Jisas siräi mowon, okon, epar ik erekapu iken amiakas aparmoi, äpu mianik, kon ämän awarom. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Rusa kon momok Anut nukas ko kämioik imäi toneanik, nukan ipou näu kaima tane mowon rau. Kos meter auruwon siar Jisas kon Osou Näu nuruwon. Keseria, ak okoro onok aparmoi, roi. Kiro Jisas nukas kon Osou Näu ik opok äsimoru. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Devit ko omar oik tonau wa. Utianik, ko nukasar äiewon, ‘Anut nukas isan Näwäu auruwon, “Na isan ipi näu kaima taneta, isas nan iwäi jaunat itimwareanik, nan isonap maroita, nan inkaruru rawaiei.” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ko keser keser äiewon, okon, ak Israel roasiret erekapu ak kiro ämän äpu mowe, kiro Jisas karar akas ko am äpäs opok äsäi mona, meiewon, Anut nukas kon enip Krais mowon, ko iken Näwäu sare mowon rau.’” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Roasiret ak kiro ämän roumana, ak woiaka aru momana, Pita pak karauk Jisas nukan ämän oi ariai roat pak awaroin, “O Jaunokot, ik rurisa owosäu?” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","39","Pita nukas keser awarowon, “Ak erekapu karar karar akan onok aru miäi utoinai, woiaka pirirmoi, Jisas Krais nukan enip pakaimas an jowe. Keserna, Anut nukas akan onok aru jäkäi maromara, kon Osou Näu arai. Meter Anut nukas kon Osou Näu ak akan mokoit pak karauk omsau pakan roasiret pak erek araun paip mowon. Kos äiewon, ‘Inok roasir isas urweita, is ko isan Osou Näu nuram.’” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pita sakau ämän sosop awaromara, äiewon, “Ak jekuriar tai rawe! Keseria, ak roat aru pak wa aru maiei.” ");
INSERT INTO bbr2013_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Karauk roasiret ak Pita nukan ämän roumoi, woiaka epar momana, an join. Kiro ses opok roasiret 3,000 orip an join. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Roasiret ak akan woiaka epar moin orip orip Jisas nukan ämän oi ariai roat pak tururmana, akan ämän rowaun tup apariain. Ak jaunakat sarwareäi. Ak akan o jaun tururianik, Anut nukan o jeäi. Ak omre orip orip Anut auriai. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Anut nukas kon ämän oi ariai roat akan ipiaka opok kurur atap atap kesernuk, roasiret erekapu kiro aparmana, iminein. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Roasiret akan woiaka epar moin karar tururianik, akan osap kiro jaunakat pak erek akan karar. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Roasiret osap sosop orip, ak akan omnokou pak akan osap pak karauk roat aromoi, aiauk oianik, kiro aiauk inäimana, roasiret osap wäpik ariai. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ak erekapu woiaka karar mianik, omre orip orip Anut osap nuriäi ou näwäu* owa tonomoi, tururiäin. Akan owa atap atap tururia, o je je ariein. Ak woiaka epar momoi, woiaka erer orip o jeäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ak orip orip Anut nukan enip jou muriäi. Karauk roasiret akas ak apwareanik, akan woiaka näu saremoi, omre orip orip Näwäu nukas karauk roasiret ätäi imwaronuk, ak roasiret woiaka epar moin pak erek turur rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kar muti iukärir, Pita Jon ori Anut auraun Anut osap nuriäi ou näwäu owa tonauririn. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Kiro opok, kar rorok enip Eposek äiäi opok roat akas kar ro kon isou aru manau senek wa, ämäianik, kiro opok pe moin. Kiro ro anakus isou aru keseriar mowon. Kiro ros omre orip orip roasiret osap nuraun rai nik mareäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Kiro omre opok, Pita Jon ori kiro tup owa tonaursa, kiro ros apwatomara, aiauk nuraun totwatowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita Jon ories ko sakamarmasa, Pita nukas auruwon, “Na iu apait!” ");
INSERT INTO bbr2013_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kesernuk, kiro isou aru ro Pita Jon ori kar osap iraieir rai apwate rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kesernuk, Pita nukas auruwon, “Is aiauk wäpik. Kar osap epar is isaurim. Is Nasaret menan Jisas Krais nukan sakau pakaima aisom, na siräinam, ari!” ");
INSERT INTO bbr2013_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Keserianik, Pita nukas kiro ron ipou näu kaimas atomara, siräi monuk, kurte kiro ron isou sakau sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ko siräumara, tai ariäwon. Kesermara, ko ori pak erek tup owa tainwate tonomara, pokir pokirmara, Anut nukan enip jou mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Roasiret kiro tup owa rain ak erekapu kiro ro siräi arimara, Anut nukan enip jou maronuk, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ak äpu kiro rosar meter tup ou nukan rorok enip Eposek siakup tane raumara, roasiret osap nik mareäwon. Kiro onok mesin karkairmana, ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Kiro ro meter isou aru mowon kos Pita Jon ori siarawap tai raunuk raunuk, roasiret erekapu karkairmana, kurte koianik, kiro owa enip Solomon nukan enip moin kasikaima ak siarakap koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita ko kiro onok aparianik, roasiret awarowon, “Israel roasiret, ak owon kiro kurur aparianik, kiro mesin ronkat sosop ourai? Akan ronkat iwen onok eposek senes, okon, iwen sakaus okoro kurur keserum rai sakau apaitoi ra? Wa senes wa!. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Iken askanai akan Anut pak Apraham, Aisak, Jekop akan Anut nukas kon sakau näwäu kon sarau ro Jisas nurunuk, kon enip kämioik mowon. Kiro ro akasar kon iwäiakut akan ipiakap moin. Pailot nukas ko utonuk, manaun äiewon akas kon ämän rowau wa. Ak ko sumkäinein. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Kiro ro ko Anut nukas äsimornuk, kowon. Ko onok eposek orip. Utianik, akas ko sumkäinein. Ak Pailot urwemana, aurin, ‘Na kiro ro kos kar ro wenuk, meiewon utota, man.’ Pailot nukas ko äsimornuk, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Orip orip awau rawaun apu ätär mareäu ro akas wena, meiewon. Utianik, Anut nukas ko ätäi siräi mowon. Roat akas wena, meiewon ätäi siräiewon iwen amiokos aparmurin, okon, ak rusapai awarom. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Kiro Jisas nukan sakaus okoro ro isou aru jekur mowon. Ak rusapai apari, ko Jisas mesin wou epar mowon, okon, kiro ro sakau muruwon. Ak ko aparnai, äpu mowe. Iu äpu Jisas nukan sakau epar, kiro sakau pakaima okoro ro jekur momur. Ak erekapu kiro aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","O Jaiat, ik äpu ak akan roat näunäu pak kamwareäin roat pak Jisas ko inok ak äpu wa, okon, ak ko keserin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Anut nukas meter kiro onok mesin kon ämän roianik, areain roat akan oiaksaus äiein, ‘Nukan Krais ko tätäi näwäu owai.’ Kiro ämän äiein epar pewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Keseria, ak akan ronkat pak onok aru pak utoinai, akan woiaka Anut mesin pirirwe. Ak keserna, kos akan onok aru jäkäi marai. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ak kiro keserna, Anut nukas ak sakau awau arai. Kos Krais äsimornuk, ak rawa kowai. Kiro ro meter Anut nukas sare mowon kon enip Jisas. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Rusapai ko omar oik ätäi tonowon rau. Ko kiro ses Anut nukas osap erekapu ätäi awau sare maun kame rau. Kiro kon ämän meter kon ämän roianik, areain roat awaronuk, akas roasiret awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moses nukas ko mesin keser äiewon, ‘Anut Näwäu nukas is äsimoirowon senek tawa kon ämän roianik, areäu ro kar äsimorai. Kiro ro akan jaunaka senes. Ak kos ämän awarai roinai, kon ämän erekapu tainorwe. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Inok roasir kiro Anut nukan ämän roianik, areäu ron ämän wa tainornuk rai, ko Anut nukan roasiret pak wa rawai. Ko Anut nukas aru murai.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","25","Anut nukas meter Apraham pak paip keser mianik, äiewon, ‘Nan askanai pakas okoro omnokou pakan roasiret jekur rawaun sakau aram.’ Kos kon ämän roianik, areain roat pak kiro paip mowon. Kon ämän roianik, areain roat meter pein Samuel pakas pote rusapai pein, akas nais kiro onok rusapai peu mesin äiein. Keseria, rusapai kiro paip epar pewon, akasar aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Keserianik, Anut nukas kon sarau ro ak karar karar jekur rawaun pak onok aru pakan pirirwe rai, awaraun sare momara, amke ak Israel roasiret rawa äsimornuk, kowon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Jon ori roasiret ämän awarona awarona, Karauk Anut nukan kamuk raiäin roat pak Anut osap nuriäi ou kameäi roat akan näwäu pak karauk Sadusi* roat nais erek au rawa koin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pita Jon ories Anut nukas Jisas meiewon pakan ätäi siräi mowon awau rau rai, roasiret awaroirin. Ak kiro ämän roumana, kasiaka pein. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Keseria, kiro roat akas Pita Jon orien ämän aparaun sakau atwatoin. Utianik, ak iukärir senes sarenuk, aparianik, karapus owa kurwatoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Utianik, roasiret sosop kiro opok rain awan ämän roianik, akan woiaka epar moin. Roasiret akan woiaka epar moin 5,000 orip sarein. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Tapera, Juda roasiret akan roat näunäu pak kamwareäin roat näunäu pak sintore ämän tamareäi roat* pak ak Jerusalem näu mena koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kiro roat potomana, Anut kamuk raiäu ro näwäu senes, enip Annas, pak Kaiapas pak Jon pak Aleksanda pak karauk Annas nukan tupsiu pak tururin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Jon Pita ori akan amiakap pe tai matea, totwatoirin, “Kiro ro isou aru ro owose jekursa, om tai manou? Au owo sakaus kiro onok keseririn? Au inon enip pakas keseririn?” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Pita ko Anut nukan Osou Näus sakau murunuk, kiro roat awarowon, “Ak roasiret kamwareäin roat näunäu, ak rusapai iu ro isou aru jekur momurin mesin totoitoi. Ak owose okoro ro eposek sarewon rai totoitoi. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Keserianik, ak erekapu Israel roasiret pak äpu maiei, Jisas Krais Nasaret menan kon sakaus kiro ro nukan isou sakau mowon. Kesernuk, ko rurisa ak amiakap tai rau. Akas ko am äpäs opok wein. Ko meienuk, Anut nukas ko ätäi up uruan siräi mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kiro Jisas karar mesin meter Anut nukan ämänis äiein, ‘Kiro ou tutu ou miäin roat akas aru äiein, rusapai kiro ou tutu eposek senes sarewon.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Kos karar ak imwaraun itok. Kon enip karar sakau orip. Roasiret kon enip pakas urwena, imwarai. Kar ros okoro omnokou pakan imäikaun senek itok wa.” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kiro roat näunäu ak Pita Jon ories sakau ämän momasa, iminäu wa, apwatianik, ronkat sosop oin. Ak äpu kiro roat ori skul sosop manau wa, au erar roat ori. Keseria, ak äpu au meter Jisas tainori ariairin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kiro ro kon isou eposek sarewon ko au pak tai rawon aparin, okon, ak kar ämän aräu senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","16","Kesermana, akas kiro owan äsimwatona, kasik nosa, aka aka ämän keser atoin, “Ik kiro roat ori owosewatau? Okoro Jerusalem menan roasiret ak erekapu kiro kurur awas keseririn äpu moin, ik ämäi mau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Utianik, kiro onok omsaukan roasiret awarona, rowaiei, okon, ik kiro roat ori Jisas nukan enip pakas karauk roasiret wa tamarau rai tämatau.” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kesermana, roat näunäu akas Jon Pita ori ätäi urwatona, owa tonosa, sakau awatoin, “Au ätäi ätäi Jisas nukan enip pakas karauk roasiret ämän wa awarau.” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita Jon ories ätäi awaroin, “Ak akasar akan ämän wasarewe. Anut nukan ronkat owo senek, ik akan ämän tainorau ra Anut nukan ämän tainorau? Kiro akasar ronkatewe. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ik kiro onok iken amiokos erekapu aparmoi, roumun, okon, kon ämän wa utam. Roasiret erekapu awaram.” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Keseria, roat näunäu akas ätäiar Jisas nukan ämän roasiret awarona, akwataiei rai, sakau ämän awateanik, utwatona, manoirin. Kiro ro kon isou aru jekur moirin kon woisan 40 orip itimorwon. Roasiret erekapu aparianik, Anut nukan enip jou murianik, Anut nukas kiro kurur keserwon mesin akan woiaka epar moin. Keseria, roat näunäu ak roasiret iminewareanik, ak kiro roat ori tämataun apu wäpik. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Roat näunäu akas Pita Jon ori utwatona, manosa, au ätäi akan jaunakat akan owa turur rain opok potoirin. Au roat näunäu akas ämän erekapu awatoin awas pote, jaunakat awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ak kiro ämän roumana, ak erekapu woiaka karar mianik, tururmana, Anut keser aurin, “O Anut Näwäu, okoro omnokou omar pak mas an pak osap erekapu nakasar ate momon. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Meter nan Osou Näu iken askanai, nan sarau ro Devit nukan oksau pakas keser äiewon, ‘Karauk omsau pakan roasiret owon kasiaka perai? Kiro roasiret owon akan ronkat atap atap morai? ");
INSERT INTO bbr2013_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Okoro omnokou pakan roat näunäu ak akan weräiäun osap jekur momana, Anut Näwäu pak kon mokoi ik imäikaun sare mowon Krais pak weräiäun keserin.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Epar senes, Herot pak Pontias-Pailot pak karauk omsau pakan roasiret pak Israel roasiret aka pak erek okoro Jerusalem näu mena tururmana, Jisas nakan sarau ron enip tonoi muraun keserin. Nakasar ko sare momon. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ak sarau erekapu meter nakasar nan sakau ronkat orip pak sare momon epar päun tainorin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","O Näwäu, na rusapai kiro roat akas ämän aru ik opok morai rou! Ik nan sarau roasiret mesin ronkateikoinam, sareikota, ik nan ämän roasiret sakau mareanik, wa iminäm. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Na nan ipon sip roasiret opok mota, ak ätäi eposek saräiei. Na nan sarau mokoi eposek Jisas nukan enip pakas kurur atap atap mo.” ");
INSERT INTO bbr2013_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ak Anut auri kurena, kiro owa rain opok mim senek pewon. Kesermara, kiro roasiret ak erekapu Anut nukan Osou Näus sakau kamwaronuk, Anut nukan ämän aremana, iminäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kiro roat akan woiaka Jisas mesin epar moin ak erekapu woiaka karar momoi, ronkat karar moin. Kar ron osap kon karar rai äiäu wa. Owo osap karan erekapu atpanianik, erek oiäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jisas nukan ämän oi ariai roat ak Jisas Krais meieanik, ätäi siräiewon mesin sakau areanik, iminäu wa. Keserna, Anut nukas kon wou näu oripas ak sarwarnuk, ak rapor rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Kiro ses opok, kar ro ko kar osapun wasaräu wa. Karauk roasiret akas akan omnokou ra, ou orip ra karauk roat aromana, kiro pakan aiauk oin. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kiro aiauk oi koianik, akas Jisas nukan ämän oi ariai roat koi arona, akas nais kiro aiauk inäianik, akan jaunakat osap wäpik roat ariai. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kiro ses opok, kar ro kon enip Josep ko Liwai* nukan tupsiu pakan ko Saiprus omsau pakan ro rawon. Jisas nukan ämän oi ariai roat akas ko Barnabas auriai. Kiro enip onoktapau, roat akan woiaka päurar rawaun ämän mareäu ro. ");
INSERT INTO bbr2013_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ko nais kon kar omnokou eteinak kar ro nurunuk, kau mowon. Kiro omnokou pakan aiauk oumara, Jisas nukan ämän oi ariain roat koi arowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Utianik, kar ro kon enip Ananaias, kon waun enip Safaira ori raiäir. Au awan omnokou karauk roat arianik, aiauk oirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Kon wau ori au a ateanik, karauk aiauk awakan owa ämäi moirin. Au sätäumasa, awan aiauk erekapu oi koumur äiäun rai, karauk aiauk oi pote Jisas nukan ämän oi ariai roat aroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Keseria, Pita ko kiro onok keseririn äpu momara, Ananaias auruwon, “Na Satan owon utota, nan ronkat erekapu kamenuk, Anut nukan Osou Näu atonormata kiro omnokou pakan karauk aiauk ämäi momata, karauk oi koum? ");
INSERT INTO bbr2013_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kiro omnokou meter karauk roat akas kau mau wa opok kiro omnokou nan. Rusapai karauk roat kiro omnokou aromon kau mianik, aiauk isoin kiro nakan aiauk. Na owo ronkat oumata, kiro onok aru keserum? Na ro atonorau wa, na Anut atonorum.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananaias ko kiro ämän roumara, omnokou opok ourmara, meiewon. Roasiret ak kiro opok rain kiro ämän roumana, karkairianik, sakau iminein. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Kesernuk, karauk mokoit awau akas pemana, kiro meiewon ro omjos kururur mianik, ämäi maneanik, up kurein. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Rai rai, Ananaias nukan wau Safaira ko kiro onok keserwon äpu wa, owa pewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita nukas kiro asir aiauk ätär muromara, totorwon, “Na is air, au komut ori awan omnokou pakan aiauk oirin okoro karar ra?” Kiro asires auruwon, “Io, aiauk omnokou pakan omurin kiro karar.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Keseria, Pita nukas ätäi auruwon, “Na owon komut ori a ateanik, Anut nukan Osou Näu ate aparir? Kiro roat nan komut ämäi pote up kurein senek, rusapai na meieta, nais imäisi pote, up kureisaun rorokpai tai rai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pita nukas keser äienuk, kurte kiro asir kon isou siakupai kurir momara, meiewon. Kiro roat owa peanik, asir meiewon aparmoi, kon enipsau oi ämäianik, pote kon komu up kurein siakup pote up kurein. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Keserianik, roasiret woiaka epar moin pak kiro menan roasiret pak erekapu kiro onok keserin roumana, karkairianik, sakau näu iminein. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jisas nukan ämän oi ariai roat akas roasiret akan amiakap kurur atap atap keserin. Roasiret akan woiaka Jisas mesin epar moin woiaka karar mia, koi meter Solomon nukan tane raiäwon ou kasikaima tururin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Roasiret akas akan sarau aparianik, akan enmaka jou mareäin, sinuk, akas ak pak tururaun iminein. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Utianik, roasiret sosop senes akan woiaka Näwäu mesin epar moin, ak pak erek koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Keserna, roasiret akas karauk roasiret sip orip patan opokas imware koi apu opok nine maroin. Akan ronkat, san penuk, Pita potonuk kon totokus karauk sip roasiret opok nonuk, ak eposek saräun rai keserin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Keseria, roasiret sosop Jerusalem näu mena siakupan akan jaunakat sip orip pak roasiret osou aru orip imware pena, ak eposek sarein. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Keseria, Anut kamuk raiäu ro näwäu senes kon sarau jaukut pak erek rain, ak erekapu Sadusi roat. Ak Jisas nukan ämän oi ariain roat mesin kasiaka penuk, aru maraun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kesermana, akan marai roat akas Jisas nukan ämän oi ariai roat sakau atwareanik, karapus owa karauk roat maroin opok erek pote kurwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","20","Utianik, kiro pututu kar Anut nukan sarau eitekus* pemara, kiro karapus ou imtuemara, Anut nukan ämän oi ariai roat imware kasik nomara, awarowon, “Ak tup näwäu owa potoinai, kiro pakan roasiret awau orip orip rawaun ämän awarowe.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jisas nukan ämän oi ariai roat kiro ämän tainormana, om teinenuk, tup näwäu owa toneanik, kiro pakan roasiret Anut nukan ämän mare rain. Anut kamuk raiäu ro näwäu senes nukas kon sarau jaukut pak Juda akan roat näunäu urwarna, koi erek tururin. Ämän karar atea, akan marai roat akas Jisas nukan ämän oi ariai roat karapus owan ak siarakap imware kowaun äsimwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","23","Keseria, marai roat ak kiro roat karapus owan imwarau potoin. Ak owa tone apwaroin warnuk, ätäi potea, roat näunäu awaroin, “Ik karapus owa poteanik, im sakau pene moin aparmun. Kiro karapus ou kamein roat ak kiro ou sakau kame rain apwaromun. Utianik, ik im tue owa toneanik, kiro roat apwarau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anut kamuk raiäi roat näunäu pak kiro tup ou kamwareäi roat akan ro näwäu ak kiro ämän roumana, Anut nukan ämän oi ariai roat owoswarou rai ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Keserna keserna, kar ros pemara, awarowon, “Ak rowe, kiro roat akas karapus owa kurwaroin, ak potomana, iken tup ou näwäu owa Anut nukan ämän roasiret marorai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Keser awarona, tup ou kameäwon ro näwäus kon marai roat pak akas Jisas nukan ämän oi ariai roat pote imware koin. Utianik, roasiret akas ak aiaukus akwaraiei rai iminewareanik, ak akwarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Akas imware pemana, roat näunäu akan amiakap tai maromana, Anut kamuk raiäi roat akan näwäus totwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ik ak kiro ron enip roasiret ätäi wa awarau rai sakau awaromun, utianik, ak iken ämän tainorau wa. Akan ämänis Jerusalem näu mena erekapu iwaurewon. Kesermana, akas äiein, ikes kiro ro weta, meiäun äiemun rai akas kiro ämän sät aikoin.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita pak karauk Jisas nukan ämän oi ariai roat akas ätäi äiein, “Ik Anut nukan ämän karar tainoram. Ik roat akan ämän wa tainoram. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Akas Jisas am äpäs opok äsäi mona, meiewon. Iken askanai akan Anut nukas meiewon pakan ätäi siräi mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Anut nukas ko imäi kämioik toneanik, kon ipou näu kaimas mowon. Kiro Jisas rurisa iken kamoikaun ro ko iken onok aru pakan imäikaun ätäi siräi mowon. Keseria, ik Israel roasiret iken woiok pirirta, iken onok aru pakan jäkäi mukaun keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Kiro onok keserin ik iken amiokosar aparmun, okon, okoro ämän areram. Anut nukan Osou Näus nais okoro ämän äiäu. Inok roasir Anut nukan ämän jekur tainoriäu Anut nukas kon Osou Näu nuriäu.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Roat näunäu ak kiro ämän roumana, ak kasiaka näwäu penuk, kiro roat akwarona, meiäun kesewaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","35","Keserna, kar Parisi ro näwäu kon enip Gameliel, ko nais sintore ämän tamareäwon ro näwäu kiro opok raiäu, karauk roasiret ak kon ämän jekur tainoriäi. Kos roat näunäu amiakap siräumara, kiro Jisas nukan ämän oi ariai roat kasik imware naun awarowon. Kasik imware nona, kos awarowon, “O jaiat, Israel roat, ak owo onok okoro roat opok keseraun, ak rapor ronkateinai, keserwe. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ak äpu, woisan rumukäu wa opok, kar ro kon enip Teudas nukas pemara, isaka ro näwäu rai äumara, nukasar kon enip jou oik me ariäu. Kesernuk, roat 400 orip ko tainorin. Karauk roat akas ko we rauna, meienuk, kon tainoriäi roat ak erekapu imine manoutoin. Kon onok ätäi päu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Rai rai, roat näunäu akas roasiret akan enmaka buk näwäu opok wäun ses, kar ro kon enip Judas, ko Galili provins pakan pemara, roasiret sosop ko aparmana, tainorin. Ko nais roat akas we kurena, meienuk, kon tainoriäi roat ak nais erekapu imine manoutoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Keseria, is kiro onokun ak awarom, ak kiro roat mesin kurte kasiaka wa päu. Akan owo onok keseriäi kiro roat akan ronkatis raroi, kiro ekep wa rawai, rai rai, wasaräi, okon, utwarona, rawe. Utwaroinai, apware rawe. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Utianik, kiro ronkat Anut pakas kowon ronkat roi ik tämarau senek itok wa. Ik kiro onok keseram, kiro ik Anut pak weräiäu senek weräiäm.” ");
INSERT INTO bbr2013_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kiro roat näunäu ak Gameliel nukan ronkat eposek arowon roianik, tainorin. Keseria, akas kon ämän tainoria, Jisas nukan ämän oi ariäi roat urwarna, pena, mur katuau oripas mänkäsi owaromoi, ak Jisas nukan enip ätäi roasiret wa awarau rai tämarea, utwarona, manoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Keserna, Jisas nukan ämän oi ariai roat, ak roat näunäu utwaromoi, kasik nea, woiaka näwäu ererin. Owon, Anut ko ronkatewon ak itok Jisas nukan enip pakas tätäi oin. ");
INSERT INTO bbr2013_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Omre orip orip, ak Anut osap nuriäi tup ou näwäu owa pak roasiret akan owa atap atap potomoi, akas Jisas Krais nukan ämän eposek roasiret tamareäin. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kiro ses opok, roat sosop Jisas mesin akan woiaka epar mianik, karauk Juda roat Grik ämän miäi akas Juda roat ak Ibru ämän miäi kewareanik, awaroin, “Omre orip orip ak akan wäimäs asiret sarwareäi. Utianik, ak iken wäimäs asiret wa sarwareäi.” ");
INSERT INTO bbr2013_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Keseria, Jisas nukan ämän oi ariai roat akas kiro roat akan woiaka Jisas mesin epar moin erekapu urwarna, koi tururna, awaroin, “Ik Anut nukan ämän roasiret awaraun sarau utomoi, roasiret orip orip o araun kiro onok itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kesek okon, akasar iken jaunokot 7 orip ak kamuk sare marowe. Kiro roat ak Anut nukan Osou Näu pak ronkat eposek orip sare marowe. Kiro sarau kiro roat opok marota, kiro sarau akas maiei. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ika omre orip orip Anut auria, kon ämän roasiret aware ariäm.” ");
INSERT INTO bbr2013_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Roasiret akan woiaka epar moin ak akan ämän roumoi, nepipirmana, akas roat kesek sare maroin: Stiven, kon wou epar senes mowon, Anut nukan Osou Näus kon ronkat erekapu kameäwon, Filip, Prokorus, Nikanor, Timon, Parmenas, Nikolas. Kiro Nikolas ko kar omsau pakan ro, Antiok menan, meter kon wou piriria, Anut nukan ämän tainorianik, koi Juda roasiret pak enip owon. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kiro roat 7 orip sare maroin ak Jisas nukan ämän oi ariäi roat akan amiakap pe tai maroin. Keserna, akas Anut auria, sarau sakau maun akan ipiaka kiro roat akan tapiakap maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Keseria, Anut nukan ämän Jerusalem mena erekapu oi potoin. Roasiret sosop kiro mena rain akan woiaka Jisas mesin epar mianik, ko tainorin. Karauk Anut kamuk raiäi roat sosop ak nais akan woiaka Jisas mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kiro ro Stiven Anut nukas kon wou näu oripas ko isanarianik, sakau nurunuk, kos roasiret akan amiakap kurur atap atap kesernuk, aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Utianik, karauk Juda roat akas kiro onok aparianik, kasiaka penuk, ko pak ketäiein. Kiro roat ak akan owa atapur tururiäi. Akan tururiäi ou enip Sarau Roat Wa akan ou äiäi. (Enip onoktapau, kiro roat meter sarau roat slev raiäi, rusapai kiro sarau utoin.) Karauk ak Sairini menan, karauk Aleksandria menan, karauk Silisia omnokou pakan, karauk Esia provins pakan roasiret kiro opok tururiäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Anut nukan Osou Näus Stiven ronkat eposek nurunuk, kar ros kon ämän itimorau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Keseria, akas kon enip opok ämän sätäumoi, karauk roat aiauk areanik, akan woiaka siräi momana, awaroin, “Epar senes, kos Moses Anut ori jeje ämän roasiret awarowon roumun.” ");
INSERT INTO bbr2013_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Keseria, ak kiro sät ämän roumana, roasiret pak menan roat näunäu pak sintore ämän tamareäin roat ak kasiaka penuk, Stiven pote sakau ateanik, roat näunäu amiakap reur potoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Keseria, karauk roat ko enkup sät äiäun erek tainware potomoi, äiein, “Okoro ro ko orip orip Anut osap nuriäi tup ou näwäu pak, Moses nukan sintore ämän aru wa tainorau rai roasiret awareäu.” ");
INSERT INTO bbr2013_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Kos äiewon, “Kiro Nasaret menan Jisas nukas iken okoro tup ou näwäu uräi kuräi. Kos iken onok Moses nukas ätär mukowon utonai, awau onok tainorwe awarowon.” Kos keser äienuk, roumun. ");
INSERT INTO bbr2013_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Roat näunäu kiro opok rain akas Stiven sakau aparin, kon neputapau Anut nukan sarau eitek nukan neputapau san jereäu senek jerewon aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Keseria, Anut kamuk raiäu ro näwäu senes nukas akan ämän roumara, Stiven totorwon, “Kiro ämän äiäi epar ra?” ");
INSERT INTO bbr2013_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","3","Stiven nukas ätäi äiewon, “O jaiat, moniat, ak rowe! Meter iken amkinip jaunok Apraham ko Haran omsau potau wa opok, Anut ko arou sakau oripas Mesopotemia omsau ko siakup pemara, auruwon, ‘Na nan omnokou pak nan jaunat pak utwaroinam, kar omnokou na ätär musaurim opok pot.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kesernuk, Apraham ko Mesopotemia omsau utia, Haran omsau opok pote rawon. Kiro omsau pote rawa rawa, kon momok meienuk, Anut nukas äsimornuk, okoro omnokou ik rusapai raum opok koi rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Anut nukas Apraham kar omnokou nukan senes saräun nurau wa. Wa senes wa. Ko kar om eteinanak nais nurau wa. Utianik, Anut nukas ko okoro omnokou mesin paip muromara, auruwon, ‘Tawa naka meieta, nan asanat okoro omnokou aram.’ Kiro ses opok Apraham ko mokoi wäpik raunuk, Anut nukas kiro paip muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Anut nukas keser auruwon, ‘Nan asanat ak karauk omsau opok pote rawaiei. Kiro omnokou opok pote rawaiei kiro akan omnokou senes wa. Keserna, kiro omsau pakan roat akas nan tupsiu woisan 400 orip sarau roat senek sare marea, aru maraiei. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Utianik, tawa isas kiro omsau pakan roasiret aru maroita, ak ätäi okoro omnokou opok koumana, isan enim jou muraiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Keseria, Anut nukas paip awau enip ‘enmaka kerau pätiraun’ Apraham auruwon. Anut nukas keser aurnuk, Apraham nukan mokoi Aisak penuk, omre 8 opok mokoin enip kerau pätirwon. Rai rai, Aisak nukan mokoi Jekop pewon. Kiro mokoi ko iken askanai 12 orip akan momonaka. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","10","Jekop nukan mokoit, iken amkinip jaunokot akas akan amunaka Josep mesin kasiaka penuk, karauk omsau pakan roat aiaukun arona, akas kau mona, aiauk oin. Kiro roat akas ko Ijip omsau imäi potoin. Utianik, Anut ko Josep utau wa. Ko pak erek raumara, ko sareanik, kon usu erekapu jäkäi muruwon. Josep ko Ijip akan kamwareäwon ro näwäu ori raiäu ses opok, Anut nukas ronkat eposek nuruwon. Kamwareäwon ro nukas Josep ro eposek aparmara, kos Josep kiro omsau pak kon owan osap pak kamäun sarau nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Keseria, kiro ses opok Ijip omsau pak Kenan omsau pak om nau wa, okon, sou näwäu penuk, roasiret ak usu näwäu oin. Iken askanai o owau senek itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jekop nukas o Ijip omsau rau ämän roumara, kon mokoit onoktoroi äsimwaronuk, Ijip omsau o kau maun potoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kiro o patarianik, ak ätäi o owaun Ijip omsau potona, Josep nukas kon awakut keser awarowon, ‘Is Josep, akan amunaka.’ Kesernuk, Ijip kamwareäwon ro ko Josep nukan tupsiu äpu marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Keseria, Josep kon awakut äsimwaronuk, pote kon momok Jekop pak kon tupsiu 75 orip koi ko pak Ijip omsau rawaun ämän surmarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Keserna, Jekop kon tupsiu pak Ijip omsau pote raumara, nuka pak iken asanokot 12 orip pak erekapu meiein. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Keseria, karauk roat akan enmaksau ätäi imware koi, Sekem mena meter kiro omnokou Apraham nukas Amo nukan tupsiu pakan kau mowon opok koi up kurwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Meter Anut nukas Apraham pak ak kiro omsau ute manaun paip muruwon, kiro paip epar päun siakup penuk penuk, iken askanai ak Ijip omsau opok rain akan tupsiu sosop sarein. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Keseria, kiro ses opok kar ro Ijip akan kamwareäwon ro pewon. Kiro ro ko Josep nukan enip äpu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kiro ro näwäus iken amkinip jaunokot sätwaromara, onok aru mareanik, akan mokoinakut kasik oi känkurwarona, meiäurai rai, sakau ämän maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kiro ses opok, Moses pewon. Kiro mokoi aparin kon nepu eposek senes. Keseria, momok anak ories kiro mokoinak awan owa ämäi mosa, keir 3 orip rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Rai rai, ko kasik imäi ne mona, kamwareäwon ro nukan asinakus imäumara, kon mokoi senek kamewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Roat akas Moses Ijip akan onok eposek erekapu ätär murin. Ko enip näwäu orip sarewon. Owo sarau maun pak ämän aräun pak ko itok. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moses ko woisan 40 orip sarenuk, kon jaukut Israel roasiret owose sarau morai rai apwarau potaun ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Kar omre opok, ko kar Ijip ros kar Israel ro wemara, aru muruwon, aparianik, kos Israel ro saremara, kiro Ijip ro wenuk, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses nukan ronkat kiro kon jaukut keser ronkatäiei, ‘Anut ko Moses nukan ipou pakas ik sareikauru.’ Utianik, ak keser ronkatäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ätäi kar omre opok, Moses kar Israel ro kon jauk ori awaka awaka weräi rairin opok pewon. Ko au weräi rairin pote patwatomara, awatowon, ‘Ei, au owon jaun ori awaka awaka weraurair?’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Jauk aru muri rawon ros Moses suor kuremara, auruwon, ‘Na inokos ik kamoikeanik, wasareikaun ro sare musowon? ");
INSERT INTO bbr2013_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Kukam nas kar Ijip ro we kureta, meiewon senek, rusapai nais is iworaurum ra?’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses ko kiro ämän roumara, kon ronkat Ijip akan ro näwäu kiro ämän roianik, sakau atoiria, iworonuk, meiäm raumara, ko imine Midian omsau potowon. Kiro opok pote, ko mokoi oirori orip sarewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Woisan 40 orip manonuk, Anut nukan sarau eitek karas Sainai omtapau siakup ro wa raiäi mena Moses siakup pewon. Kiro eitek am eteinak pakas ep arou uru rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses ko kiro onok pewon aparmara, ronkat sosop oianik, jekur aparaun siakup potonuk, Anut nukas keser auruwon rowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Anut nukas äiewon, ‘Is Anut nan askanai akan eit. Apraham, Aisak, Jekob is akan eit.’ Moses ko karkairianik, aparaun sakau iminewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Kesernuk, Näwäus auruwon. ‘Na nan ison pakan su oi mo. Owon, kiro omoi na tai raum kiro omnokou asu. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ijip omsau pakan roat akas isan roasiret opok onok aru maroin is aparianik, ak sarwaraun waiein roimin. Is rusapai kiro usu pakan imwaraun nem. Keseria, rusapai is na Ijip omsau ätäi äsimoisoita, potam.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Kiro Moses karar meter roat kon ämän rowau utomana, aurin, ‘Na inokos ik kamoikeanik, wasareikaun ro sare musowon?’ Ko Anut nukasar kiro roat kamwaraun äsimoronuk, pote ätäi imware kowaun ro sare muruwon. Anut ko kiro sarau eitek am eteinak opokas pewon nukan ipou pakas Moses sakau nuruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Keseria, Moses nukas Israel roasiret imware koumara, kurur atap atap Ijip omsau opok kesermara, pote mas an enip Osou opok kesermara, pote ro wäpik mena keserwon. Woisan 40 orip ko keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Kiro Moses kararasar Israel roasiret awarowon, ‘Anut Näwäu nukas is äsimoirowon senek tawa kon ämän roianik, areäun ro kar äsimorai. Kiro ro akan jaunaka senes.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Kiro ro Moses kararasar roasiret pak erek ro wäpik mena turur rawon. Ko Sainai omtapau opok Anut nukan sarau eitekus eposek rawaun ämän aurnuk, Moses nukas iken askanai kiro ämän awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Utianik, iken askanai ak kon ämän rowau utoin. Akan woiaka pirirmana, Ijip omsau rawaun ätäi ronkatein. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Keseria, roasiret akas Eron aurin, ‘Nas ik karauk eitek totok ate mukota, amke ik pak potaiei. Kiro Moses ko ik Ijip omsau pakan imäiki kowon, ko eras manowon rä ik äpu wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kiro omre opokar, ak kar bulmakau nak nukan totok ate mianik, ak kiro sät eitek opok opur amkea, kon enip jou murin. Ak kiro osap akan ipiakasar ate momana, akan woiaka ererin. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Keserna, Anut nukas ak mekesirak arowon. Ak san keir pak pai pak akan enmak opokas tup apariäi. Anut nukan ämän roianik, areawon ro Emos nukas keseriar jer wewon, ‘Ak Israel roasiret ak meter woisan 40 orip ro wäpik mena rain, ak bulmakau pak sipsip pak wemana, amkeanik, tup aparmana, ak isan enim jou murau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ak Molok nukan tup ou ser pak akan eitek Repan nukan pai totok pak ak ämäi potoin. Kiro osap totok meter akas ate mianik, akan enmak jou murin. Keseri, okon, is ak utwareanik, äsimwaroita, Babilon* omsau opok pote rawaiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Meter iken askanai ak ro wäpik mena rain, akan tup ou seris moin. Anut nukas Moses kiro ser ou nukan totok ätär murunuk, aparwon. Anut nukas ko ou kesekur mo räi auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Rai rai, kiro Anut nukan ser ou mokoit akas oumoi, ämäimana, Josua karauk roasiret pak Anut nukas sarwareanik, kiro omnokou pakan roasiret emwaronuk, ak kiro omnokou oianik, kiro ser ou moin. Iken askanai akas kiro omnokou opok akan tup ou ser ou oi koi mona, rawon pote Devit pewon ses opok. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Anut nukas Devit nukan onok eposek aparianik, ko wou näu sarewon. Devit nukas Anut auruwon, ‘Meter Jekop nukas na jou musiäwon. Rusapai is kar tup ou sakau musaun rai aisom.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Utianik, Anut nukas wa mam aurnuk, kon mokoi Solomon nukas kiro tup ou muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","49","Utianik, Anut Näwäu ko roat akas ou miäi owa wa raiäu. Anut nukan ämän roianik, areäu ro Aisaia nukas jer wewon senek, ‘Näwäu nukas keser äiewon, “Omar oik kiro isan tanäun pasar senek. Omnokou kiro isan isi me rawaun omoi. Isan ou owo senek muraiei? Isan sumaun mena erapok rau? ");
INSERT INTO bbr2013_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Isan ipiasar kiro osap erekapu ate momin.” ’ ");
INSERT INTO bbr2013_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","O, rusapaian roasiret, ak akan asanakat raiäin senek. Akan woiaka kiro roat ak Anut nukan ämän eparar wa roiäin senek, ak nais ämän wa roiäi. Ak akan asanakat senek. Ak Anut nukan Osou Näu nukan ämän wa tainoriäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Akan askanai akas Anut nukan ämän roianik, areain roat erekapu akwarona, meiein. Ak kiro roat Anut nukan sarau ro eposek kowai äiein nais akwarona, meiein. Rusapai nais akas kiro sarau ro eposek kon iwäi jaukut ipiakap marona, ko wena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Meter Anut nukan sarau eitek akas ak Juda roasiret Anut nukan sintore ämän aroin, utianik, ak kiro tainorau wa.” ");
INSERT INTO bbr2013_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ak kiro ämän roumana, aiakpanak kartitirmana, Stiven mesin kasiaka pewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Utianik, Anut nukan Osou Näus Stiven ko sakau nurunuk, ko omar oik sakau aparmara, Anut nukan arou sakau näwäu pak Jisas ko Anut nukan ipou näu kaima tai rawon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Kiro aparmara, äiewon, “Rowe, omar oik is Ro Nukan Mokoi nukas Anut nukan ipou näu kaima tai rau aparim.” ");
INSERT INTO bbr2013_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Keser äienuk, akan ipiakas raiaka pene momana, ak ätäi sakau urweanik, erekapu siräianik, kurte pote Stiven sakau atoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ak kiro omoian ate reur ne mena kasakup oi känkurena, nonuk, ko aiaukus wein. Stiven wäun roat akas akan omjo rumukäu oi mianik, kar ro enip Sol siakup turur mona, kame rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ak Stiven aiaukus wena wena, kos keser auruwon, “Jisas Näwäu, na isan osou ou!” ");
INSERT INTO bbr2013_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ko uou sur wemara, ätäi sakau urwemoi, äiewon, “Näwäu, na kiro roat akan onok aru jäkäi mar.” Ko keser äianik, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sol ko ak Stiven wena, meiewon aparianik, kon wou ererwon. Kiro omre karar opokar, kiro Juda roat Jerusalem menan roasiret akan woiaka epar moin onoktoroi aru mare rauna, ak erekapu Judia provins opok pak Samaria provins opok imine mane kurein. Jisas nukan ämän oi ariai roat karar ak Jerusalem mena rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Karauk roat akan woiaka epar moin akas Stiven mesin woiakati maronuk, sakau waianik, up kurein. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Utianik, Sol ko roasiret woiaka epar miäi aru mareanik, akan owa karar karar tonomara, roasiret akan woiaka epar moin rewareanik, imware karapus owa koi kurwareäwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Kiro roasiret ak imine manoin ak karauk mena poteanik, Anut nukan ämän karauk roasiret maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip ko kar näu mena Samaria provins opok potomara, Krais nuka mesin roasiret ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Roasiret ak Filip nukan ämän roumana, kos Jisas nukan enip pakas kurur atap atap keserwon aparianik, ak kon ämän jekur roi rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Karauk roasiret sosop ak osou aru akan woiaka uru rawon, kos Jisas nukan enip opakas oi kurwaronuk, piorianik, manoin. Roasiret sosop akan enmaksau meiewon ariäu senek wa pak, karauk roasiret isiaka aru pak kos jekwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Keseria, kiro Samaria provins pakan roasiret akan woiaka uru näwäu nepipirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kar ro ko kiro mena raiäu, kon enip Saimon. Ko orip orip os ämänis kurur atap atap kesernuk, Samaria menan roasiret aparianik, ak epar rai akan woiaka epar moin. Kos äiäu, “is ro näwäu”. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Roasiret erekapu, roat näunäu pak karauk roat enmaka näwäu wa, ak kon ämän jekur roi raiäi. Akas kiro eitek enip ‘Sakau Näwäu’ omnokou opok pemara, kos Saimon äräräwon äiäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ko kon os ämänis omre orip orip kurur atap atap miäu, okon, ak ko tainoriäin. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Utianik, Filip nukas Anut koi kamwaraun ämän pak Jisas Krais nukan ämän roasiret awarowon. Kiro ses opok roasiret ak akan woiaka pirirna, an jomaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon nais kon wou epar mowon. Ko an joi kuremara, Filip pak ari raumara, Filip nukas kiro kurur atap atap keserwon aparmara, ronkat sosop owon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Karauk Jisas nukan ämän oi ariai roat ak Jerusalem mena raiäi, Samaria provins pakan roasiret ak Anut nukan ämän roianik, akan woiaka epar moin roumana, akas Pita Jon ori kiro provins äsimwatona, potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Kiro ro ori au Samaria provins neanik, kiro roat akan woiaka epar moin Anut nukan Osou Näu owaurai rai Anut auririn. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ak Jisas nukan enip pakas karar an join, okon, Anut nukan Osou Näu akan woiaka uru nau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Keseria, Pita Jon ories awan ipiaka, kiro roasiret akan woiaka epar moin akan tapiaka opok marona, Anut nukan Osou Näu ak opok nowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Saimon ko kiro Jisas nukan ämän oi ariai roat ories roasiret akan tapiaka atona, Anut nukan Osou Näu oin aparmara, aiauk ataun oi koumara, awatowon, “Au kiro sakau is erek irower. Keseria, inok ro isan ipi kon tapau opok moita, ko nais Anut nukan Osou Näu owai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita nukas ätäi auruwon, “Anut nukas kiro sakau erar ikiäu, nan ronkat Anut nukan osou kiro aiaukus kau miäi rai ronkatäm ra? Wa senes wa. Na keser ronkatem, nan aiauk orip ep näwäu opok nam. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Okoro sarau iu momur kiro nan sarau wa. Anut nukan amuk opok nan won uru eposek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Keseria, nan won ätäi pirirnam, kiro onok aru sumkäineinam, Anut aurta, kiro nan ronkat aru jäkäi musai. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Na osap sosop owaun wonas weäum. Nan won uru onok aru nukas na sakatoisi rau apaisom.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Saimon nukas ätäi Pita keser auruwon, “Awas Anut Näwäu is sareiräun aurwer. Keserna, kiro onok awas airoir is opok wa päi.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Jisas nukan ämän oi ariain roat ori au Jisas nukan ämän roasiret mare kuremasa, au ätäi Jerusalem näu mena poteanik, apu opok mena mena Samaria provins opok awas Jisas nukan Ämän Eposek mare mare potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kar Anut nukan sarau eitekus peanik, Filip auruwon, “Na siräinam, apu Jerusalem menas Gasa mena poteäi opok pot. Kiro apu ro wäpik menas potowon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Keseria, Filip ko siräumara, potowon. Kiro apu opok ko kar ro aparwon. Kiro ro ko Itiopia omsau kameäwon asir enip Kandasi nukan aiauk kameäu. Ko Jerusalem mena Anut jou muromara, karis pakas ätäi kon mena potaun pote rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ätäi kon mena pote pote rai, kon karis opok tanemara, kar buk meter kar Anut nukan ämän roianik, areawon ros jer wewon, ninare ninare potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Anut nukan Osou Näus Filip auruwon, “Na kiro karis siakup tone tararnam, erek potower.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Keseria, Filip ko kurte siakup tonomara, kiro ämän Anut nukan ämän roianik, areawon ro Aisaia nukas jer wewon ninare potowon rowon. Keseria, Filip nukas kiro ro totorwon, “Na kiro ämän ninareram onoktapau na äpu ra?” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Kiro ros ätäi Filip auruwon, “Kar ros kiro ämän onoktapau ätär murunuk, kiro epar is onoktapau äpu mam. Is owose kiro ämän onoktapau äpu mam?” Keseria, kos Filip auruwon, “Na karis oik peinam, is siarap tane.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Kiro jer ko ninarewon kiro Anut nukan ämän areawon ro nukas keser jer wewon, ‘Akas ko sipsip senek wena, meiäun sakau ate koin. Ko sipsip nak senek kon urik patirna, ko piorau wa. Kiro ro ko kar ämän aräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Roat akas kon enip tonoi muria, ak kon ämän jekur wasare murau wa. Kar ros kon tupsiu amop mau senek wa. Ak ko wena, meiewon. Ko okoro omnokou opok rawau wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Kiro ro näwäus Filip auruwon, “Na is air Anut nukan ämän roianik, areawon ro kiro inok mesin äieu? Nuka mesin äieu ra, kar ro mesin äieu ra?” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kesernuk, Filip nukas kiro ämän onoktapau pakas Jisas nukan ämän eposek auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Au apu opok potea, kar an unik rawon, opok peirin. Ko an unik aparmara, äiewon, “An okoro rau, na is an jomuraun itok ra?” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip nukas auruwon, “Nan won epar senes momon roi, is na an jomusaun itok.” Kos ätäi Filip auruwon, “Isan woi epar mom, Jisas ko Krais, Anut nukan mokoi senes.” ");
INSERT INTO bbr2013_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Keseria, kos kon sarau roat awaronuk, akas karis atona, sume raunuk, Filip kiro ro ori an opok noirin. Kiro opok Filip nukas kiro ro näwäu an jomurowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Au keseria, an utia, apu opok peanik, kurte Anut nukan Osou Näus Filip imäi manowon. Kiro ro näwäu ko ätäi Filip aparau wa. Kiro ro ko wou uru nepipirmara, kon mena ätäi potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip ko Asdot mena pote tue momara, karauk mena mena Anut nukan ämän roasiret aware aware potomara, ko Sisaria mena potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Sol nukas Jisas nukan tamareäu roat akware kuräun ämän sakau mowon. Keseria, kos Anut kamuk raiäi roat akan näwäu siakup potonuk, jer we nurunuk, Damaskus mena pote Juda roasiret akan tururiäi owa potea, inok roasir akan woiaka Jisas mesin epar moin tarwaromara, sakau atwareanik, Jerusalem mena imware kowaun auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Keseria, Sol ko Damaskus mena pote pote, ko kiro näu mena siakup tononuk, kurte kar arou näwäu ermän senek omar oikas ko opok kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Kesernuk, Sol ko omnokou opok ouri nonuk, kar ron pätu senekus keser auruwon rowon, “Sol, Sol, na is owon onok aru muroram?” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Kos ätäi äiewon, “Näwäu, na inokos?” Kiro pätus ätäi äiewon, “Is Jisas nukas na is onok aru muroram. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Na siräinam, kiro näu mena ton. Tawa, kar ros koumara, na owo onok keseraun aisai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Kiro roat ak Sol pak potoin ak karkairianik, apik tai rain. Ak kiro pätu roin, kar ro aparau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Keseria, Sol ko siräia, kon amuk amarewon, ko amuk utup sareanik, apu aparau senek wa. Kesernuk, kon ipou atea Damaskus näu mena imäi tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ko omre 3 orip amuk utup rawon. Kiro ses opok ko wou aru monuk, o pak an pak jau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Kar Jisas nukan tamareäwon ro ko Damaskus mena rawon kon enip Ananaias, ko Näwäu nukas nine epir pakaima, auruwon, “Ananaias.” Kos ätäi äiewon, “Näwäu, is okoro raim.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Näwäu nukas auruwon, “Na siräinam, kiro apu enip Tuku opok potoinam, Judas nukan owa kar ro kon enip Sol, ko Tarsas näu menan pote totwar. Kiro ro ko Anut auri rau. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Sol nukas nine epir pakaima, kar ro kon enip Ananaias nukas pemara, kon amuk atonuk, ätäi apu aparaun ätär muruwon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaias nukas ätäi auruwon, “Näwäu, is kiro ro Jerusalem mena nan roasiret aru mareäu ämän sosop airona, roimin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Anut nukan kamuk raiäi roat näunäu akas ko kiro onok aru maun sakau nurin. Okoro menan roasiret na jou musiäi kos Jerusalem mena imware potea, karapus owa kuräun pewon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Utianik, Näwäu nukas ätäi auruwon, “Na isas aisom pot. Kiro ro ko isan ämän oi ariaun sarau ro sare momin. Kos karauk omsau pakan roasiret pak akan kamwaraun roat näunäu pak Israel roasiret pak isan ämän awarai. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Isakasar ko is mesin usu näwäu owaun ko ätär muram.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Keseria, Ananaias ko Sol rawon owa potomara, kon ipou Sol opok momara, auruwon, “Jai Sol, Jisas näwäu nukasar na apu koumon opok pewon. Kosar is na rawa äsimoirnuk, koim. Na ätäi om aparnam, Anut nukan Osou Näu na opok ok päura.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kesernuk, kurte osap kes senek Sol nukan amuk opok rawon jäkäi nonuk, ko ätäi om aparwon. Keseria, ko siräinuk, karauk roat akas ko an jomurin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Keseria, Sol ko o jemara, ko ätäi kon iris sarewon. Sol ko karauk omre Jisas nukan tamareäwon roat pak Damaskus mena rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ko siräumara, pote Juda roasiret akan tururiäi owa potomara, roasiret Anut nukan ämän maromara, äiewon, “Jisas Krais ko Anut nukan mokoi senes.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Roasiret erekapu ak kon ämän roumana, karkairin, akas äiein, “Okoro ro kos Jerusalem menan roasiret akas Jisas nukan enip ate jou mona, kos aru mareäu. Ko okoro mena inok roasiret akan woiaka Jisas mesin epar moin imwareanik, Jerusalem mena pote aru maraun kowon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Utianik, Sol nukan ämän marowon sakau näwäu senes sarenuk, Juda roasiret Damaskus mena rain ak kon ämän roianik, karkairin, kos sakau awareanik, äiewon, “Jisas ko Krais, kiro ro Anut nukas ik ätäi imäikaun äsimornuk, kowon.” Kesernuk, roasiret ak kon ämän sätäu rai aurau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Omre sosop manonuk, Juda roat näunäu ak tururianik, Sol wena, meiäun a atoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Karauk roat akas Sol wena, meiäun ämän roumana, Sol aurna, rowon. Roat ak kiro mena porim rorok erekapu kameanik, Sol kasik nonuk, wena, meiäun rai pututu sanpeu orip orip kame rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kar pututu kon tainoriäi roat akas imäianik, pote ou amarer opokas kar kopser näwäu uru nonuk, menan porim kasikaima imäi mona, neanik, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sol Jerusalem mena potomara, karauk Jisas nukan tamareäwon roat pak tururaun potowon. Utianik, kiro roat ak erekapu ko aparmana, iminein. Akan ronkat ko sätäura äiein. Iminemoi, kon ämän akan woiakas epar mau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Keseria, Barnabas nukas Sol saremara, Jisas nukan ämän oi ariai roat siarakap imäi tonowon. Kos karauk roat, Sol nukas Jisas apu opok aparnuk, Näwäus auruwon erekapu awarowon. Barnabas nukas karauk roat Sol nukas Damaskus mena Anut nukan ämän sakau marowon nais erekapu awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Keseria, Sol kiro roasiret pak Jerusalem mena raia, karauk mena Jerusalem mena siakup erekapu potomara, Jisas nukan ämän sakau mare ari rawon. Ko iminäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Karauk Juda roat ak Grik ämän miäi akas Pol pak ämänis ketäianik, kiro roat akas kasiaka penuk, Sol wena, meiäun ronkatein. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Karauk roat akan woiaka epar moin roat akas kiro roat akan ronkat äpu momoi, Sol Sisaria mena imäi poteanik, kon mena Tarsas äsimorin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Keseria, Judia provins pak Galili provins pak Samaria provins pakan roasiret woiaka epar moin ak päurar rain. Ak weräiäu wa, kiro pakan roasiret akan woiaka epar mianik, Anut Näwäu pak kon Osou Näu pak awas ak sakau marosa, päurar raia, sosop sarein. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita ko mena erekapu Anut nukan ämän mare ari rawon. Kar omre opok, ko kar mena enip Lida kiro menan roasiret akan woiaka epar moin apwarau potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kiro mena kar ro kon enip Inias aparwon. Kiro ro kon enipsau erekapu meiewon, ko woisan 8 orip pasar sau opok karar nine rawon manau senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita nukas kiro ro aparmara, auruwon, “Inias, rusapai, Jisas nukas na jekusi mai. Na siräinam, nan pasar jekur mo.” Kesernuk, kiro ro ko kurte siräiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kiro Lida menan roasiret pak, Saron menan roasiret pak ak kiro onok aparia, Näwäu mesin akan woiaka piririn. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Kar Jisas nukan tamareäwon asir ko Jopa mena raiäwon, kon enip Tabita. Grik ämänis Dorkas äiäi. Ko orip orip onok eposek karauk roasiret osap wäpik kos sarwareäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Kiro ses opok, ko sip näwäu oumara, meiewon. Kon enipsau an jomuri momana, ou waru kämioik mona, rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida mena kiro Jopa mena siakup rau. Keseria, Jisas tainoriäi roat ak Pita ko Lida mena rau ämän roumana, akas ro oirori äsimwatona, pote Pita keser auririn, “Na ik siarokop kurte koi.” ");
INSERT INTO bbr2013_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Keseria, Pita nukas siräumara, kiro roat ori pak potowon. Ko kiro mena potonuk, akas imäianik, kiro ou waru opok imäi tonoin. Wäimäs asiret ak erekapu Pita siakup koi tururia, ate waiein. Akas kiro omjo pak karauk osap Dorkas nukas ate mianik, arowon Pita ätär murin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita nukas roasiret erekapu kasik äsimwaronuk, nona, ko kon uou sur wemara, Anut auruwon. Keser kurea, kos pirirmara, kiro asir nine moin opok amuk kure aparmara, äiewon, “Tabita, na siräu.” Kesernuk, kiro asir ko ätäi amuk pitainemara, Pita aparianik, siräumoi, kon patan opok tanewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita nukas ko siakup potea, kon ipou atomara, siräi murunuk, kiro meiewon asir siräiewon. Pita nukas roasiret Anut nukanun woiaka epar moin pak wäimäs asiret pak urwarnuk, pena, kos Dorkas ätär marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kiro ämän Jopa menan roasiret akas oi erekapu pote awarona, roasiret sosop akan woiaka Näwäu mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita ko Jopa mena omre sosop rawon. Ko kar ro bulmakau nukan keraus osap ate miäwon ro enip Saimon pak rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Kar ro ko Sisaria mena raiäu, kon enip Konilias. Konilias ko Rom akan marai roat 100 orip kamwareäu ro näwäu. Kiro marai roat ak Itali omsau pakan. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ko Anut nukan ämän tainoriäu. Ko kon tupsiu pak Anut jou muriäi. Kos Juda saruku roasiret sarwareäu. Ko omre orip orip Anut auriäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kar omre opok iukärir, Anut nukan sarau eitek karas nine epir pakaima ko siakup pemara, auruwon, “Konilias.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kos kiro Anut nukan sarau eitek sakau aparmara, imine orip äiewon, “Näwäu, is air.” Anut nukan sarau eitekus ätäi auruwon, “Anut nan auriäum pak sarau eposek miäum pak aparmara, ko nanun wou ereru. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Keseria, na rusapai nan karauk roat Jopa mena äsimwarota, pote kar ro kon enip Saimon-Pita imäi kowaiei. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ko kar ro kon enip Saimon ko bulmakau nukan keraus osap ate miäu owa mas an kasakup raiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","8","Kiro Anut nukan sarau eitek manonuk, Konilias nukas kon sarau roat ori pak kar marai ro ko Anut nukan ämän tainoriäu ro pak urwaronuk, ko siakup kouna, kos Anut nukan sarau eitekus owo ämän auruwon, erekapu awaromara, Jopa mena äsimwaronuk, manoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","10","Pote ninoinus, kar omre opok, kiro roat Jopa mena apu opok potona potona, san kamuk opok, Pita ko Anut auraun ou oik tonowon. Ko sou wenuk, o jaun ronkatewon. Ko o mis moin jekur mona mona, ko nine epir pakas senek kar osap aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ko omar im tuewon aparwon, kiro opakas kar osap nineäin omjo näwäu senek newon. Kar osapus karaim karaim atonuk, äiäur äiäur omnokou opok nowon aparwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Kiro osap nineäin omjo senek uru opur atap atap sosop, män, jamai, ai raut pak apwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Keseria, kar ron pätu senekus auruwon, “Pita, na siräinam, kiro opur akwaroinam, je.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pita nukas ätäi äiewon, “Näwäu, is kiro wa keseram. Is opur ukun orip aru wa jeäim.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Keseria, kiro ron pätus ätäi auruwon, “Owo osap Anut nukas eposek sare mowon, nas ukun orip rai wa äiäu.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Kiro ron pätus kiro ämän 3 orip keser aurnuk, kiro osap nineäin omjo senek ätäi omar oik tonowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pita ko kiro epir aparwon onoktapau owo senek rai ronkat sosop me rawon. Kiro ses opokar, Konilias nukas kon roat äsimwaronuk, pote, Pita imäiäun ko owo owa rawon äpu momana, pote, kon ou porim rorokpai tai rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Akas pemana, kiro pakan roat totwaroin, “Okoro opok kar ron enip Saimon-Pita rau ra?” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita ko kiro nini epir pakaima senek aparwon onoktapau äpu maun ronkate raunuk raunuk, Anut nukan Osou Näus auruwon, “Pita, roat 3 orip na apaisaun kasik pe tai rai. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Keseria, na ronkat sosop wa owau, nan osap jekur moinam, ak tainware man, kiro roat isas na imäisaun äsimwaroita, koin.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Keseria, Pita nukas kasik nomara, kiro roat tarwaromara, awarowon, “Kiro ro ak itane koi kiro is karar. Ak owon koi?” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Akas ätäi Pita aurin, “Konilias ko Rom akan marai roat kamwareäu ro näwäu nukas ik äsimoikonuk, koumun. Ko Anut nukan ämän tainoriäu, ko Anut orip orip jou muriäu. Juda roasiret akas ko mesin woiakas meiäi. Kar Anut nukan sarau eitekus na kon owa imäisi potaun äiewon. Keseria, nan ämän mota, rowai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Keseria, Pita nukas kiro roat owa imware tonomara, o aronuk, jena, ninoinus, tapera, siräianik, ko karauk Jopa menan roat woiaka epar moin imwareanik, kiro Sisaria menan roat koin tainware potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Ak pote, kamuk ninoinus, tapera, Sisaria mena tonoin. Konilias ko kon tupsiu pak roat ko siakup rai kon owa koi kame rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kame rauna rauna, Pita ko Konilias nukan owa penuk penuk, Konilias nukas potomara, Pita siakup jou muraun uou sur wewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kesernuk, Pita nukas ipou ate siräi mianik, auruwon, “Na siräu! Is Anut wa, is erar ro.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita ko Konilias pak are are kon owa tonea, roasiret sosop turur rain apwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Keseria, Pita nukas awarowon, “Ak äpu, Juda akan sintore ämän äieu, ‘Juda roasiret ak karauk omsau pakan roasiret akan owa wa tonau, ak ukun orip,’ äiäi. Utianik, Anut nukas is rusapai amop ätär murianik, äiewon, ‘karauk omsau pakan roasiret ukun orip wa awarau, ak eposek, ukun wäpik.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Keseria, is imäirau potoin is siräumoi, kar ämän totwarau wa, tainware koimin. Is ak rusapai totwaraurim. Ak is owon roat äsimwarona, pote imäiri koin?” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","31","Konilias nukas ätäi auruwon, “Omre 3 orip manowon opok, is iukärir isan owa Anut auri raimin opok, kurte kar ro ko omjo ärneu orip isan ami opok pe tai raumara, airowon, ‘Konilias, Anut ko nan aurumon ämän rowon. Nan sarau karauk roasiret sarwareäum kos naka mesin wou ereru. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Na karauk roat Jopa mena äsimwarota, pote kar ro enip Saimon-Pita imäi kowaiei. Ko kar ro kon enip Saimon ko bulmakau nukan keraus osap ate miäu ro nukan owa, mas an kasakup rau.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Keseria, is kiro ses opokar na imäisaun roat äsimwaroita, pote na imäisi koi. Na onok eposek mianik, ak pak koum. Ik rusapai Anut nukan amuk opok Anut nukas owo ämän aikaun äiewon rowaun tururianik, na kamoisi raum.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita nukas ätäi äiewon, “Is rusapai epar äpu mom, Anut ko karar ron wous wa meiäu, ko roasiret erekapun mesin wous meiäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Inok ro ko Juda ro ra, kar omsau pakan ro ra, ko Anut iminemoi, onok eposek mai, Anut nukas ko mesin wou ereai. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ak kiro ämän äpu, Anut nukas Jisas Krais nukan ämän eposek amke ik Israel roasiret ikowon. Ik Anut pak päurar turur rawaun Jisas mukowon, Jisas ko omnokou pakan roasiret erekapu akan Näwäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ak äpu, meter Jon nukas an jowaun mesin awarowon, kiro ämänis kiro ses opok Galili provins opok onoktoroi pemara, Judia provins erekapu potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ak äpu kiro Jisas Krais Nasaret menan, Anut nukas ko sakau pak Osou Näu pak nuruwon. Ko omsau erekapu ari ari potomara, Anut nukan ämän mareanik, roasiret sip aru orip jekur maromoi, osou aru roasiret akan woiaka uru rain kos oi kurewon. Anut nukan sakau ko pak rawon, okon, ko keseriäwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ik iken amiokos kos okoro Israel omnokou pak Jerusalem mena keserwon aparmun, okon, awarom. Roat akas ko am äpäs opok äsäi mona, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Utianik, omre 3 opok, Anut nukas ko ätäi awau siräi murunuk, roasiret akas aparin. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ko roasiret erekapu akan amiakap päu wa. Kiro roat nukasar kon sakau aparaun sare marowon akan amiakap pewon, kiro ik. Ko siräianik, ik pak pe erek o jemoi, an jewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kos ik roasiret opok Anut nukan ämän eposek awaroinai, amop marowe räi sakau ämän ikomara, keser aikowon. Ko Anut nukas roasiret meiein pak awau rai pak wasarewaraun sare muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Anut nukan ämän roianik, areain roat akas nais meter ko mesin areanik, äiein. Roasiret ak erekapu konun woiaka epar maiei, Anut nukas Jisas nukan enip pakas akan onok aru jäkäi marai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita ko kiro Anut nukan ämän maronuk maronuk, Anut nukan Osou Näu kiro roasiret kon ämän roi rain opok nowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Juda roat akan woiaka epar moin, ak Pita pak Jopa menas erek koin, ak Anut nukan Osou Näu karauk omsau pakan roat opok nais nonuk, aparmana, karkairianik, ronkat sosop oin. ");
INSERT INTO bbr2013_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","47","Juda roat ak kiro roat ämän atap atapus Anut jou muroin roin. Keseria, Pita nukas äiewon, “Okoro roasiret ak Anut nukan Osou Näu ik oumun senek ak nais kesekur rusapai oi, okon, kar ros ak an jowaun wa tämarai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Keseria, kos Jisas nukan enip opokas an jomarowon. Keseria, akas Pita karauk omre ak pak rawaun rai aurin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Jisas nukan ämän oi ariai roat pak karauk roat akan woiaka epar moin ak karauk omsau pakan roasiret Anut nukan ämän roumoi, woiaka piririn roin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","3","Keseria, Pita ko Jerusalem mena ätäi potonuk, kiro Juda roat woiaka epar moin ak Juda akan onok tainoria, akan enmak kerau patirin akas Pita kermana, aurin, “Na karauk omsaukan roat akan enmak kerau patirau wa, akan mena potomata, ak pak o jemon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Keser aurna, Pita nukas owo onok erekapu ko opok pewon awaromara, äiewon, ");
INSERT INTO bbr2013_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Kar omre, is Jopa mena raia, Anut auri raita raita, kurte kar osap nineäin omjo näwäu senek epir pakaima, omar oikas kar osapus karaim karaim atonuk, is siarap nowon aparmin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","7","Kiro osap nineäin omjo senek uru opur sosop rain, karauk opur sei, karauk aim, karauk ai atap atap apwaromin, Keseria, is kar ron pätu senekus airowon roimin, ‘Pita, na siräinam, kiro opur apwarom akwaroinam, je.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Kesernuk, isas ätäi aurmin, ‘Näwäu is kiro opur ukun orip is jaun itok wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Kiro ron pätu senekus omar oikas ätäi airowon, ‘Owo osap Anut nukas eposek sare mowon nas ukun orip rai wa äiäu.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","11","Kiro onok 3 orip kesernuk, kiro osap ätäi omar oik tonowon, Kiro ses opokar roat 3 orip ak Sisaria menas, is kiro owa raimin opok äsimwarona, tonoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Anut nukan Osou Näu nukas na ronkat sosop wa owau rai aironuk, okoro jaiat 6 orip ak Jopa menas is pak erek Sisaria mena potomoi, Konilias nukan owa erek tonomun. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Konilias nukan owa tonota, kos Anut nukan sarau eitek kon owa pe tai raumara, auruwon, na karauk roat Jopa mena äsimwarota, pote kar ro kon enip Saimon-Pita imäi kowaiei räi auruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kos na pak nan tupsiu pak kiro owa rai, koi Anut nukan ämän awaronuk, Anut nukas ak imwarai. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Kesernuk, is pote Anut nukan ämän awaroita awaroita, Anut nukan Osou Näu amke ik opok nowon senek ak opok nais keseriar nowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Keseria, is kiro opok Näwäu nukan ämän äiewon epar äpu momin. Jon nukas roasiret anas an jomareäwon, utianik, akas Anut nukan Osou Näu oripas an jomaraiei rai äiewon ronkatemin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Kiro onok amop, Anut nukas kiro karauk omsau pakan roat akan enmak kerau patirau wa, kiro sakau iken woiok epar mowon sakau oumun senek ak nais keseriar oin. Is owo sakau oripas Anut nukan sarau tämurau?” ");
INSERT INTO bbr2013_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ak Pita nukan ämän roumana, akan woiaka erermoi, Anut nukan enip jomuria, äiein. Keseria, karauk omsau pakan roat nais ak Juda roasiret senek Anut nukas orip orip rawaun woiaka piriraun itok äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stiven wena, meiewon ses opok, woiaka epar moin roat ak omsau erekapu imine manoin. Karauk roat Fonisia provins opok manoin. Karauk roat Saiprus omsau pak Antiok mena pak manoin. Ak poteanik, Juda roasiret karar Jisas nukan ämän mare ariein. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Utianik, karauk Saiprus pak Sairini menan roat akas Antiok mena potomoi, roasiret Grik omsau pakan nais akan enmak kerau patirau wa Jisas nukan ämän maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Anut nukan sakau ak pak raunuk, roasiret sosop akan woiaka pirirmoi, Jisas mesin woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalem menan woiaka epar moin roat ak kiro ämän roumana, akas Barnabas Antiok mena äsimorna potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ko potomara, Anut nukas kon wou näu oripas ak sarwarowon apwaromara, kon wou uru nepipirwon. Keseria, kos roasiret akan woiaka epar moin sakau maun ronkat siräi marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabas ko ro eposek, ko Anut nukan Osou Näu orip kon wou sakau epar mowon. Keseria, roasiret sosop akan woiaka piririanik, Näwäu mesin woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Keseria, Barnabas ko Sol Tarsas mena rawon tararaun manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Ko pote tararmara, ätäi Antiok mena imäi kowon. Kiro woisan opok, au kiro opok raia, woiaka epar moin roasiret sosop Anut nukan ämän mare rairin. Kiro mena roasiret akas amke roasiret akan woiaka epar moin enip Kristen aroin. Kiro enip onoktapau ‘Krais tainoriäi roasiret.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Kiro ses opok, karauk Anut nukan ämän roianik, areai roat ak Jerusalem menas Antiok mena noin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ro karan enip Agabus, Anut nukan sakau orip siräumara, äiewon, tawa okoro omnokou opok sou näwäu senes päi räi awarowon. Kiro sou näwäu Rom nukan kameäwon omsau erekapu päi. (Sisa-Klodias omsau kameäwon ro rawon opok kiro epar pewon.) ");
INSERT INTO bbr2013_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Keseria, Jisas nukan tamareäwon roat akas roasiret akan woiaka epar moin Judia provins rai sarwaraun aiauk surmaraun a atoin. Erekapu akan aiauk atap atap aparianik, karauk surmaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Keseria, ak aiauk seper momara, Barnabas Sol ori awan ipiakap mona, kiro woiaka epar moin roasiret kamwareäi roat näunäu araun oi potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Kiro ses opok roat ak Jisas tainorin, Herot-Agripa nukas aru mareanik, karauk sakau atwaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Kos kon marai roat awaronuk, akas Jon nukan amak Jems siräp rumukäus wena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herot ko kiro onok keserwon, Juda roasiret ak nepipirin aparia, karauk roat äsimwaronuk, pote Pita nais sakau ataun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Kiro omre Pasowa opok Pita pote sakau atea karapus owa mianik, marai roat 16 orip ko kamäun sare maroin. Amke roat 4 orip kame rain, pote sumona, karauk roat 4 orip koin, keser keser pote 16 orip. Herot nukan ronkat kiro Pasowa omre manonuk, roasiret akan amiakap imäi potea, wena, meiäun rai ronkatewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Keseria, Pita ko karapus owa kureanik, marai roat akas ko jekur kame rain. Roasiret akan woiaka epar moin Jerusalem menas Pita saräun mesin pututu Anut orip orip auri rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ariwa senek Herot nukas Pita kasik imäi naurnuk, Pita kon ipou muris rakir moin, marai ro oirori au Pita kamuk mianik, kame rausa rausa, Pita ninowon. Kar marai ro oirories ororokpai kame tai rairin. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kurte senes, Anut nukan sarau eitek pe owa kamuk tai raunuk, arou näwäus kiro owa erekapu merek kurewon. Anut nukan sarau eitekus Pita nukan sau onoktapau atomara, siräi mianik, auruwon, “Na kurte siräu.” Keser äienuk, kiro mur kon ipou opok rakir moin nukarar uräwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Keseria, Anut nukan sarau eitekus auruwon, “Nan omjo katu takeinam, nan ison opok su mo. Na omjo rumukäu kurururnam, is tainoir.” ");
INSERT INTO bbr2013_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Keser aurnuk, Pita nukas Anut nukan sarau eitek tainori kasik nowon. Pita nukan ronkat, kiro onok Anut nukan sarau eitekus kesera, kiro nine epirem rai äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Au marai roat oirori ororokpai tai rairin pak karauk kasik tai rain erekapu itimware ne kasik näu mena manaun porim siakup pesa, kiro rorok im nukarar tue matonuk, au kasik noirin. Au ne, apu tainori manea, kiro Anut nukan sarau eitek Pita ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Keseria, Pita ko kiro onok keserwon äpu momara, äiewon, “Is rusapai äpu mom, kiro onok epar senes. Anut nukas kon sarau eitek äsimornuk, Herot nukan sakau pakan pak kiro onok Juda roasiret akas is aru muraurin pakan ätäi imäirou.” ");
INSERT INTO bbr2013_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ko kiro onok äpu momara, ko Jon-Mak nukan anak, Maria nukan owa potowon. Roasiret sosop ak kiro owa turur raumana, Anut auri rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ko potomara, oun porim rorok wewon. Kesernuk, kar sarau asir kon enip Roda nukas inokos kiro rorok wera räi aparaun kowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ko Pita nukan pätu roumara, nepipirianik, ko im tuäu wa, ko ätäi kurte potomara, karauk roasiret Pita kasik tai rau räi awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Akas ko ätäi aurin, “Na sätäiem.” Kos awarowon, “Is epar awarom, Pita kasik tai rau.” Kesernuk, akas ätäi äiein, “Kiro Anut nukan sarau eitek.” ");
INSERT INTO bbr2013_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ak arena arena, Pita ko orip orip ou rorok we rawa, owan roat akas pote im tueanik, Pita aparin. Ak ko aparianik, karkairin. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita kon ipous asoraun awaronuk, ak a sorna, ko Anut nukas owose kasik imäi ne mowon kiro ämän jekur awarowon. Ko keser awareanik, ko ak ätäiar awarowon, “Kiro ämän Jisas nukan amak Jems pak karauk roat akan woiaka epar moin pak awarowe.” Ko keser aware kuremara, ko kar mena ute manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kiro marai roat ak Pita kame ninoin tapera Pita aparau warnuk, aka aka näwäu iminemoi, ronkat sosop oin. Aka aka äiein, “Pita esewon?” ");
INSERT INTO bbr2013_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Keseria, Herot nukas Pita manowon ämän roumara, ko kasak penuk, marai roat Pita itanäun äsimwarowon. Ak Pita itanein, itanein aparau warnuk, kos Pita kamein marai roat jekur totwaromara, karauk marai roat akas kiro marai roat akwarona, meiäiei awaronuk, ak kon ämän tainorin. Rai rai, Herot ko Judia provins pakas Sisaria mena nopte rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herot ko Taia mena pak Saidon menan roasiret akanun kasak näwäu pewon. Kesernuk, ak tururianik, ko pak aräu koin. Kar ro enip Blastas, ko Herot nukan ou kameäwon ro, ak ko pak woiaka karar maun arein. Akan o Herot nukan omsau pakan oiäi, okon, ak Herot siakup poteanik, kon kasak peäwon ämän utaun räi aurin. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Herot nukasar kar omre sare miäu opok, kon omjo eposek momara, kon patan opok tanemara, roasiret ämän marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Roasiret akas ätäi ätäi urwemana, äiein, “Kiro ros aräu wa, eitek näwäus arera.” ");
INSERT INTO bbr2013_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herot ko kiro sät ämän rai awarau wa, ko Anut nukan enip jou murau wa, okon, Anut nukan sarau eitekus kurte nomara, aru mowon. Ko sip näwäu oumara, rumuris kon wou uru raianik, tuke jena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Roasiret sosop Anut nukan ämän roumana, akan woiaka piririn. ");
INSERT INTO bbr2013_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas Sol ori awan sarau patarmasa, ätäi Jerusalem mena ute potoirin. Jon-Mak erek imäi manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Kiro Antiok mena roat woiaka epar moin ak kamuk opok karauk Anut nukan ämän roianik, areai roat pak karauk Anut nukan ämän tamareäi roat pak rain. Kiro opok Barnabas, Simeon (ko ro mokup äiäi), Lusius (ko Sairini menan), Manain, (ko Herot nukas penewon mokoi) pak Sol erek rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kar omre opok, Anut nukan enip jou mianik, o utomoi, rauna rauna, Anut nukan Osou Näus akan ronkat opok pemara, awarowon, “Barnabas Sol ori au isan sarau maun sare matom.” ");
INSERT INTO bbr2013_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Keser awaronuk, ak o an pak utomoi, Anut aurianik, akan ipiaka kiro roat orien tapiakap mia, äsimwatona, manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Barnabas Sol ori Anut nukan osous äsimwatia, Selusia menas ous pakaima Saiprus omsau mas an kamuk opok potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Au Salamis mena poteanik, Juda roasiret akan tururiäi owa toneanik, Anut nukan ämän maroirin. Jon-Mak nukas au sarau sarwateäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Ak Saiprus omsau erekapu pote, kar mena enip Papos poteanik, kiro mena kar Juda ro ko os ämän sosop orip kon enip Bar-Jisas pote tararin. Kos is Anut nukan ämän roianik, areäimin ro rai sätäiäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Kiro ro ko kiro om kameäwon ro Sergius-Paulus nukan sarau ro. Sergius-Paulus ko ro ronkat eposek orip ro. Kiro ro näwäus Barnabas Sol ori Anut nukan ämän mona, rowaun urwatonuk, kon owa potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Utianik, kiro os ämän areäu ro, kon kar enip Elimas (Grik ämänis Elimas äiäi, ‘os ämän areäu ro’) kos awan ämän tonoi matowon. Kiro ros kon ro näwäu nukan wou epar mowon, tämuraun keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","10","Keseria, Sol kon kar enip Pol, ko Anut nukan Osou Näu orip kos kiro os ämän areäu ro kakap sakamarmara, auruwon, “Na Satan nukan mokoi. Na roat onok eposek miäin akan iwäi jaunaka, roat sätwaraun onok nan ronkat opok ok pe rau. Nas Anut nukan ämän epar orip orip kiro sät ämän räi äiäum. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Anut nukan sakaus rusapai na opok nonuk, nan amun utup saräi. Na merek wa aparam, pote Anut nukasar nan amun oraienuk, epar ätäi om aparam.” Kiro ses opokar, Elimas amuk putut kariewon. Kesernuk, ko karauk roat akas ipou atea, apu ätär muraurai rai ipiaka ataun ari rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kiro ro näwäu nukas kiro kurur aparmara, näwäu karkairianik, Anut Näwäu nukan ämän roumara, kon wou epar mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pol kon jaukut ori Papos mena utia, ous opokas Perga mena Pampilia provins opok peirin. Jon-Mak ko kiro mena utwatianik, ätäi Jerusalem mena potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Au Perga mena utia, kar näu mena enip Antiok Pisidia provins opok peirin. Kiro omre opok sumaun ses, okon, au potea, Juda roasiret akan tururiäi owa pote taneirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kiro tururiäi ou kameäi roat näunäu Moses nukas sintore ämän jer wewon pak Anut nukan ämän roianik, areain roat akan jer wein pak ninare kuremana, akas Pol Barnabas ori awatoin, “Jaunokot, ak iken roasiret karauk ämän tuku saräun rau raroi, iken roasiret awarowe.” ");
INSERT INTO bbr2013_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Keseria, Pol nukas siräumara, roasiret a soraun awaronuk, a sorna, awarowon, “Israel roasiret pak karauk omsau pakan roasiret ak okoro opok rai Anut jou muriäi, ak isan ämän rowe. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Okoro Israel roasiret akan Anut Näwäu nukas iken askanai sare mareanik, sarwarnuk, Ijip omsau opok sosop senes sarein. Anut nukan sakau näwäus iken kinjaunokot Ijip omsau opok sarau aru wopur orip me rain opokan imware kowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Woisan 40 orip ro wäpik mena om puru opok akas onok aru sosop miäin, utianik, kos ak jekur kamwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kos Kenan omsau pakan mena näunäu 7 orip akan roasiret erekapu aru maromara, kiro omnokou kon roasiret akan senek saräun arowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Kiro ses Jekop kon tupsiu pak Ijip omsau tone rainus, pote Kenan omsau opok koin kiro erekapu woisan 450 orip. Kenan omsau opok Anut nukas roasiret kamwaraun roat sare mareäu. Kiro pakas pote Anut nukas kon ämän roianik, areau ro Samuel sare mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Roasiret akas omsau kamwaraun ro näwäu king sare maraun Samuel aurna, Anut nukas Sol, Kis nukan mokoi, Benjamin nukan askanai pakan sare muruwon. Ko woisan 40 orip roasiret kamware rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Utianik, Anut nukas king Sol utomara, Devit ak kamwaraun sare monuk, ko kamwareäu ro näwäu rawon. Okoro ro Anut nukas ko mesin äiewon. ‘Devit ko Jesi nukan mokoi, aparianik, isan woi ko mesin meiem. Owo onok ko keseraun auriäim ko kiro ämän erekapu tainoriäu.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Jisas ko Devit nukan tupsiu pakan, Israel roasiret onok aru pakan imwaraun kon paip mowon siar kowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jisas ko sarau mau wa opok, amke Jon nukas roasiret akan onok aru pakan piririanik, kouna, kos an jomarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Jon ko äpu kon sarau pataraun ses penuk, roasiret keser awarowon, ‘Akan ronkat is inok? Is kiro ro ak ätäi akan onok aru pakan imwaraun kame rai ra? Is kiro ro wa, ko ruris pera. Is ro erar, is ko siakup poteanik, kon su mur uraiäu senek itok wa.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","O jaiat, ak Apraham nukan tupsiu pakan pak karauk omsau pakan roat ak Anut jou muriäi, Anut nukas imäikaun ämän kiro Anut nukas ik opok äsimornuk, kowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem mena rain roasiret pak akan kamwareäi roat näunäu pak ak Jisas ko ätäi imäikaun ro äpu wa. Akas Jisas wena, meiewon. Keseria, ak Anut nukan ämän roianik, areain roat akan ämän sumaun omre opok orip orip ninareäi erekapu iporwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Akas ko kar onok aru keserwon meiäun senek aparau wa, utianik, ak ko erar wena, meiäun Pailot sakau aurna, wena, meiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ak kiro onok meter Anut nukan ämän areain roat akas äiein erekapu tainorin. Akas ko am äpäs opakan oi neanik, kar aireu uru moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Utianik, Anut nukas meiewon pakan ätäi awau siräi mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Omre sosop ko pemara, kon sarau roat meter Galili provins pakas Jerusalem mena poteäi opok, ak pak ari rawon. Akan amiakas aparianik, ak iken roasiret awareäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ik rusapai kiro Anut nukan ämän eposek Anut nukas iken askanai paip marowon awarom. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kiro paip rusapai Anut kos Jisas siräi murunuk, ik akan mokoit pak epar senes ätär mukou. Kiro ämän Buk Song opok jer wein epar pewon. ‘Na isan mokoi, rusapai is nan momon sarem.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kiro epar Anut nukas ko meiewon pakan siräi mowon, ko wa pomoräi. Kiro Anut nukas meter äiewon, Is ak jekur rawaun ämän Devit nuraun paip murumin, kiro ämän mesin akan woiaka epar maiei.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Keseria, Buk Song opok jer keser rau, ‘Na nan sarau ro eposek utota, up uru wa pomoräi.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Ik äpu, Devit ko roasiret amiakap Anut mesin wous meiemara, kon ämän erekapu tainori rawon. Rai rai ko meienuk, kon asakut akan up siakup up kurena, ko poomrewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Utianik, kiro ro Anut nukas siräi mowon ko pomoräu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Isan jaiat, ak rowe, ak kiro ämän epar äpu maun awarom. Jisas nukas epar akan onok aru jäkäi marai. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Moses nukan sintore ämän karar tainoraiei, Anut nukas akan onok aru wa jäkäi marai. Inok ro Jisas mesin wou epar mowon kon onok aru erekapu jäkäi murianik, ko ro tuku sare murai. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","O jaiat, ak jekur tai rawaiei. Ak keserna, okoro onok akas äiein ak opok wa päi. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Karauk Anut nukan ämän roianik, areai roat akas äiein, ‘Rowe, ak aru ämän miäi roat, ak Anut nukan ämän rowau utomoi, ak ronkat sosop oianik, sepuk sepuk meiäiei. Okoro sarau rusapai aka rauna, is keseram kiro akan woiaka epar wa maiei. Karauk roat akas ak jekur awaraiei nais ak woiaka epar wa maiei.’” ");
INSERT INTO bbr2013_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kiro ämän roasiret mare kuremana, Pol Barnabas ori kasik manaursa, roasiret akas kar sumaun ses opok ämän kesek ätäi maraun awatoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Keseria, Juda roasiret pak karauk omsau pakan roasiret pak erekapu ak Anut jou muria, Pol Barnabas ori apu opok tainwate nona, kiro ro ories Anut nukas kon wou näu oripas ak sarwarnuk, kon onok eposek tainoraun awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Kar sumaun omre opok, kiro menan roat sosop Anut nukan ämän rowaun koi tururin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Karauk Juda roasiret ak roasiret sosop Anut nukan ämän rowaun koi tururna, apwarea, woiaka aru mareanik, kasiaka pewon. Ak Pol nukan enkup ämän momana, äiein, ‘Pol kiro ämän sätäura.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Keserna, Pol Barnabas ories sakau ämän awaroin, “Anut nukan ämän ak Juda roasiret amke marona, rowaun itok, utianik, ak kon ämän rowau utona, kiro onokun akasar äiäi, ‘Ik awau orip orip rawaun sakau owau senek wa.’ Ik rusapai ak utwarea, karauk omsau pakan roasiret opok pote maram. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Owon, Näwäu nukas meter sakau ämän keser aikowon, ‘Is ak karauk omsau pakan roasiret akan arou senek marom. Erekapu omsau pakan roasiret akas sarwarna, Anut nukas ätäi imwarai.’” ");
INSERT INTO bbr2013_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Karauk omsau pakan roasiret ak kiro ämän roumana, ak nepipirianik, Anut nukan ämän oik jou murin. Kiro roasiret Anut nukas orip orip awau rawaun sare marowon ak akan woiaka piririanik, epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Anut nukan ämän kiro omsau erekapu oi manoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Keseria, Juda roasiret akas kiro menan asiret osap sosop orip Anut jou muriäi pak karauk roat näunäu pak akan woiaka siräi marona, ak Pol Barnabas ori akan menan emwatona, manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ak kiro onok keserna, Pol Barnabas ori akan onok aru ätär maraun awan su oianik, maimai isorawa opakan utarianik, Aikonium mena manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Au ute manosa, Jisas nukan tamareäwon roat ak Antiok mena rai Anut nukan Osou Näus kamwaronuk, ak nepipir rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol Barnabas ori Aikonium mena Juda roasiret akan tururiäi owa toneanik, Antiok näu mena keserin senek, roasiret Anut nukan ämän sakau arona, roasiret sosop Juda roasiret pak karauk omsau pakan roasiret pak ak akan woiaka Jisas mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Utianik, karauk Juda roasiret akan woiaka epar mau wa, akas karauk omsau pakan roasiret akan woiaka siräi marona, ak Kristen roasiret mesin kasiaka pein. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Utianik, Pol Barnabas ori au Aikonium mena om rumuk raianik, Anut nukan ämän roasiret sakau maroin. Keseria, Anut nukas kon wou näu oripas au sarwateanik, sakau atonuk, kurur atap atap moirin. Kiro keserna, Anut nukas roasiret kon ämän epar senes tamarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Kiro menan roasiret erekapu ak inäianik, karauk Jisas nukan ämän oi ariai roat tainwaroin, karauk roasiret ak Juda roasiret akan onok tainorin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Keseria, karauk Juda roasiret pak karauk omsau pakan roasiret pak akan roat näunäu erek tururia, akas Jisas nukan ämän oi ariai roat aru marea, aiaukus akwarona, meiäun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Jisas nukan ämän oi ariai roat ak kiro ämän roumana, Laikonia provins akan näu mena oirori enmaka Listra Derbi ori pak karauk omnokou kiro mena siakup imine manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Kiro opok ak Jisas nukan Ämän Eposek roasiret maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Kiro Listra mena kar ro ko kon isou meiewon orip rawon. Ko anakus isou meiewon oripar an jowon, okon, ko ariäu senek wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","10","Ko tane raumara, Pol nukas Anut nukan ämän arewon roi rawon. Pol ko kiro ron wou epar mowon äpu momara, ko eposek saräun itok, sakau aparianik, roasiret amiakap auruwon, “Na siräinam, isonas omtau.” Kurte, kiro ro kon isou meiewon pokirianik, om taiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Roasiret ak kiro kurur Pol nukas keserwon aparmana, akan ämänis urwemana, äiein, “Iken eitek oraut ro senek äräräumoi, ik opok koi.” ");
INSERT INTO bbr2013_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Keseria, akas Barnabas ko enip Sus moin. Pol ko ämän areawon ro, okon, kon enip Ermis moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kiro sät eitek Sus nukan kamuk raiäwon ro, kon tup ou kiro mena kasik rau, ko kiro ämän roumara, karauk bulmakau sawai pak am musip mer eposek pak oumoi, mena porim siakup pewon. Kon roasiret pak kiro Jisas nukan ämän oi ariain roat akan enmaka opok amkea, jou maraun pein. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","15","Jisas nukan ämän oi ariai roat Barnabas Pol ori, au kiro onok keseraurin raumasa, au awan woiawa aru mianik, awan omjo kiräianik, kurte kiro roasiret kamuk poteanik, awaroin, “Iken jaunokot, ak kiro onok owon keserauri? Ik roat aka senek, ik eitek wa. Ik okoro opok Anut nukan ämän eposek awarau koumun. Ik ak kiro sät eitek sumkäineinai, Anut ko awau raiäu, kos omar pak omnokou pak mas an pak osap erekapu ate mowon, ko mesin karar akan woiaka epar mowe. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Meter kos roasiret owo onok keseraun tämarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Utianik, Anut ko ämäiäu wa, kos ik onok eposek ätär mukiäu. Kos om äsimornuk, kounuk, akan woia o uku eposek tu penuk, o jemana, aka nepipiriäi.” ");
INSERT INTO bbr2013_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Jisas nukan ämän oi ariain roat ories kiro roasiret ak opur patan opok amkea, iu wa jou mutau rai awaroirin. Utianik, ak kiro onok keserna, awas ak tämaraun sarau sakau senes mosa, ak kiro onok utoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Keserna keserna, karauk Juda roat Antiok näu mena Pisidia provins pakan pak Aikonium menas pemana, kiro pakan roasiret akan woiaka karar maun ämän maromoi, akan ronkat ätäi pirir mareanik, keser awaroin, “Ak kiro roat aiaukus akwarowe.” Keser awarona, akas Pol aiaukus wein. Keserianik, akan ronkat ko meieu aumana, ak ko mena kasik ate reur ne känkurein. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Utianik, roasiret akan woiaka epar moin ak Pol siakup pemana, karirim kator rauna rauna, Pol ko siräianik, kiro mena ätäi tonowon. Ninoirinus, tapera, Barnabas Pol ori au Derbi mena manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pol Barnabas ori au Derbi mena raia, Anut nukan Ämän Eposek marona, roasiret sosop akan woiaka piriria, Jisas tainorin. Keseria, Pol Barnabas ori au ätäi Listra mena potea, kiro pakas ätäi Aikonium mena potea, kiro pakas Antiok näu mena Pisidia provins opok potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Keseria, au kiro roasiret akan woiaka sakau marea, akan woiaka epar moin wa utau rai ronkat sakau maroin. Awas awaroin, “Ik erekapu Anut nukan kamoikaun mena tonaun usu sosop oia tonau.” ");
INSERT INTO bbr2013_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Au mena karar karar opok potea, roasiret woiaka epar moin pak erek tururia, kiro pakan roasiret kamwaraun roat sare maroin. Ak karauk omre opok, o utomoi, Anut aurianik, au Anut nukan ipou opok maroirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Kiro Pisidia provins erekapu aria, ak ätäi Pampilia provins opok koin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Anut nukan ämän Perga menan roasiret marea, Atalia mena noin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kiro menas ous opokas ätäi Antiok mena potoirin. Kiro mena meter roasiret akas Anut kon wou näu oripas ak sarwataun aurna, Jisas nukan ämän roasiret maraun äsimwatoin, kiro sarau au rusapai erekapu pataririn. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ak Antiok näu mena pemana, kiro pakan roasiret woiaka epar moin au onok erekapu keseririn pak owose Anut nukas karauk omsau pakan roasiret woiaka epar maun apu ätär marowon mesin awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ak omre rumuk, kiro roat akan woiaka epar moin pak rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Karauk roat akas Judia provins pakas Antiok näu mena koumana, woiaka epar moin roasiret awaroin. “Ak Moses nukas sintore ämän jer wewon akan enmak kerau patirna, kiro apu pakas karar Anut nukas ak orip orip rawaun imwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol Barnabas ori au kiro ämän roumasa, woiawa aru matonuk, kiro roat pak ketäiein. Keseria, kiro pakan roat akas karauk roat näunäu pak Pol Barnabas ori pak kiro ämän Jisas nukan ämän oi ariai roat pak roat näunäu Jerusalem mena rai tone awaraun sare maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Roasiret akas äsimwarona, ak Fonisia pak Samaria provins opokas potea, karauk omsau pakan roasiret akan woiaka piririn, kiro omsau pakan roasiret akan woiaka epar moin awaroin. Ak kiro ämän roianik, akan woiaka ererin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ak Jerusalem mena tonona, kiro roat woiaka epar moin pak Jisas nukan ämän oi ariai roat pak roat näunäu pak akas apwareanik, nepipirin. Pol Barnabas ories Anut nukas ak pak sarau mowon erekapu awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Utianik, karauk Parisi* roat woiaka epar moin akas siräumoi, äiein, “Kiro karauk omsau pakan roat ak Anut nukan ämän tainoraun, ak akan enmak patiria, Moses nukan sintore ämän erekapu tainoraiei.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Keserna, Jisas nukan ämän oi ariai roat pak roat näunäu pak ak tururianik, kiro ämän jekur wasare aparaun keserin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Kiro ämän are kurena, Pita nukas siräumara, awarowon, “Isan jaiat, ak äpu, meter Anut nukas ak kamuk is karauk omsau pakan roasiret kon ämän araun sare murowon. Keseria, ak nais Anut nukan Ämän Eposek roia, akan woiaka piriraurai. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Anut ko roat akan woiaka uru äpu. Keseria, kos akan woiaka epar moin aparmara, ik Osou Näu ikowon senek ak keseriar arowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kos ik ak pak atap atap inäi mukau wa, akan woiaka epar moin, okon, kos akan woiaka uru onok aru jäkäi marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Keseria, ak owon Anut ate aparaun usu näwäu roat akan woiaka epar moin akan enmaka opok maroi? Meter iken kinjaunokot pak ika pak kiro usu ämäiäun itok wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ak rowe, Jisas nukas kon wou näu oripas ik sareikonuk, iken woiok epar mota, kos ik imäikaun kesermun senek, ak nais imwaraun keseriar keserai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Roasiret erekapu asor rauna, Barnabas Pol ories, awan ipiawas Anut nukas kurur atap atap karauk omsau pakan roasiret opok marowon ämän awarona, roi rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Ak erekapu are patarna, Jems nukas ätäi äiewon, “Jaiat, ak isan ämän rowe. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon nukas ak rusapai Anut nukas amke kos karauk omsau pakan roasiret akanun ronkateäu awarowon, kiro pakan karauk roasiret kon senes sare marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","16","Meter Anut nukan ämän roianik, areain roat akas keseriar äiäin. Keser äiein, ‘Anut nukas äiewon, “Tawa ätäi koita, kiro Devit nukan ou ätäi mam. Is kiro ou erekapu aru mowon ätäi jekur mam. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Keseria, karauk omsau pakan roasiret ak nais Näwäu tainoraiei, kiro roasiret isakasar sare maromin.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Anut nukas keser äiewon.’ Ko meter roasiret kiro ämän awarowon, ak roin.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Keseria, Jems nukas are potomara, äiewon, “Kiro isan ronkat, ik karauk omsau pakan roasiret akan woiaka Anut siakup kowaun usu wa arau. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Utianik, ik ak jer we marea, keser awarau, ak o sät eitek nukan enip pakas jou muria, araiei kiro o wa jau. Owon, kiro o ukun orip. Ak karauk opur roat akas pou äsisiriäi kiro opur wa jau. Ak karian nais wa jau. Ak kar ron asik ra kar asiken ro pak wa ariäu rai awarau. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ik äpu mena karar karar Moses nukan sintore ämän omre orip orip sumaun omre opok tururiäi owa ninare marona, roiäi. Keseria, karauk omsau pakan roasiret erekapu äpu kiro onok 4 orip Juda roasiret amukup aru senes. Okon, ik kiro ämän jer we marau.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Keseria, kiro pakan Jisas nukan ämän oi ariai roat pak roat näunäu pak kiro menan roasiret akan woiaka epar moin pak akas ämän atea, akan karauk roat sare marea, Barnabas Pol ori pak äsimwaraurin. Akas Judas, kon kar enip Bar-Sabas, Sailas ori sare matoirin. Kiro roat ori au karauk roat akan amiakap onok eposek orip raiäirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ak keser jer wemoi, äsimwaroin, O iken jaunokot, ik Jisas nukan ämän oi ariäum roat pak okoro pakan roat näunäu pak iken woiok ak mesin nepipirianik, ak iken jaunokot karauk omsau pakan roat Antiok mena rai pak Siria provins rai pak Silisia provins rai jer we mareanik, ‘pere’ awarom. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Ik roumun, iken karauk roat akas poteanik, enmak kerau patiraun ämän awaroin roin kiro ämän mesin akan woiaka aru mowon. Utianik, ikes ak kiro ämän pote araun awarau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Keseria, ik erekapu tururianik, ro oirori ak awaraun äsimwatomun. Au iken jaunokot Pol Barnabas ori pak potaieir. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Pol Barnabas ori au Jisas nukan sarau mona, karauk roat akas akwaraurna, meiäurin. Utianik, au awan totomakan ekep ronkatäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Keseria, ikes Judas, Sailas ori ak opok äsimwatom. Awan oiaksau pakas okoro jer we marom senek keseriar awaraiei. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Anut nukan Osou Näu ik opok raunuk, ik karauk usu ak opok wa maram. Okoro onok karar keserwe. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ak karauk sät eitek jou maraiei kiro pakan o wa jau. Ak karian wa jau. Ak opur roat akas pou äsisiriäi kiro opur wa jau. Ak kar ron asir ra kar asiren ro pak wa ariäu. Ak kiro ämän tainorna, ak eposek rawaiei. Pere. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kiro roat sare maroin äsimwarona, Antiok poteanik, roasiret akan woiaka Jisas mesin epar moin turur mareanik, kiro pas jer wein aroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Roasiret ak kiro jer wein akan woiaka päurar rawaun ninareanik, ak näwäu nepipirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Sailas ori au Anut nukan ämän roianik, areairin roat ori, okon, au roasiret akan woiaka eparar moin ämän sosop aria, akan woiaka sakau maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Kiro mena omre rumukur rainus, kiro menan roasiret jekur rawaun ämän awateanik, Jisas nukan ämän oi ariai roat rawa äsimwatoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Utianik, Sailas ko Antiok mena rawaun ronkat owon. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pol Barnabas ori au om rumuk, Antiok raianik, au karauk roat pak roasiret Anut nukan ämän tamaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Om rumukurar rai rai, Pol nukas Barnabas auruwon, “Ik ätäi potomoi, kiro mena atap atap meter Anut nukan ämän tamaromun, iken Kristen jaunokot ak itok rai ra owose rai apwarau potoinamur.” ");
INSERT INTO bbr2013_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ko keser äienuk, Barnabas nukas Jon-Mak imäiar potaun äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Utianik, Pol nukan ronkat ko Jon-Mak pak manau utowon. Meter ko ak pak Pampilia provins raianik, sarau patarau wa, ko utwaromara, ätäi kon mena manowon. Keseria, Pol nukas Jon-Mak imäi potaun utowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Au sakau ketäumasa, atap atap manoirin. Barnabas ko Jon-Mak imäumara, ous atat Saiprus potoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pol ko Sailas imäumara, ute manaurnuk, roasiret akan woiaka epar moin akas Näwäu nukas au sarwataun kon ipokup matona, manoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Ko Siria provins pak Silisia provins kiro pakan woiaka epar moin roat sakau mare mare potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ko Antiok mena utia, Derbi menas pote ätäi Listra mena potowon. Kar ro kon enip Timoti, kon wou Jisas mesin epar mowon kiro mena rawon. Kon anak nais kon wou epar mowon, ko Juda asir. Timoti nukan momok ko Grik ro. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listra menan Kristen roasiret pak Aikonium menan Kristen roasiret pak akas Timoti nukan onok eposek äiäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Keseria, Pol nukas Timoti imäi erek manaurmara, kon enip kerau patir muruwon. Kiro pakan Juda roasiret ak äpu Timoti nukan momok ko Juda ro wa, okon, Pol nukas Juda roasiret ak woiaka aru wa maun rai kiro onok keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ak erekapu näu mena aria, meter Jisas nukan ämän oi ariai roat pak roat näunäu pak Jerusalem mena a atea, jer wein kiro ämän roasiret woiaka epar moin awareanik, awaroin. Ak kiro ämän karar tainoraun rai awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Keseria, kiro roasiret akan woiaka epar moin sakau mareanik, omre karar karar karauk roasiret woiaka piririanik, Kristen roasiret sosop sarein. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol kon jaukut pak ak Prigia provins pak Galesia provins opok karar poteanik, Anut nukan ämän roasiret maroin. Ak karaima potau senek wa, owon, Anut nukan Osou Näu nukas Esia provins karaima Anut nukan ämän wa pote aräu rai tämarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Ak pote Misia akan omnokou taku opok potea, ak Bitinia omnokou opok tonaun keserin. Utianik, Jisas nukan osous tämaronuk, kiro omnokou opok tonau wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Keseria, ak Misia omsau itimori potea, Troas mena noin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Troas mena pututu, Pol kar nine epir senek pakaima aparwon, kar Masedonia provins pakan ros pe amuk opok täumara, auruwon, “Na mas an kureinam, Masedonia koinam, ik sareik.” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pol ko kiro epir pakaima aparmara, aikonuk, iken osap jekur momoi, Masedonia provins potomun. Iken ronkat Anut nukas kiro provins pakan roasiret Anut nukan Ämän Eposek arau potaun urweikou. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ik kar ous pakas Troas mena utia, Samotres omnokou opok potomoi, kiro mena ninomunus, tapera, Niopolis mena potomun. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Kiro pakas Masedonia provins akan näu mena enip Filipai potomun. Kiro näu mena Rom akas kamwareäi. Ik kiro mena karauk omre raumun. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Sumaun ses opok, kiro mena kasik an kasakup nomun. Iken ronkat kiro an kasakup roasiret akas Anut auraun omoi rau rai ronkatemun. Ik tone tane rauta, karauk asiret tururaun kouna, ikes Anut nukan ämän maromun. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Kiro opok kar asir rau. Kon enip Lidia, ko Taiatira menan. Kiro asir nukan sarau kesek, ko omjo eposek senes aiwer aiaukun ariäu. Kiro asir ko Anut jomuriäu, keseria, Näwäu nukas kon wou im tuenuk, Pol nukas Anut nukan ämän mowon jekur roi rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Keseria, kiro asir nuka pak kon tupsiu pak kon sarau roasiret kon owa rain ak erekapu an join. Keseria, kos ik aikowon, “Utianik, akan ronkat is Näwäu mesin woi epar mom ak is pak isan owa potea, o jau.” Keser aikomoi, sakau mukonuk, ik ko tainori potomun. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Kar omre opok, ik Juda roasiret tururianik, Anut auriai mena pote pote rai, apu opok kar sarau asir ko osou aru orip tararmun. Kiro asir osou aru orip owo onok tawa päi roasiret awaronuk, kon kameäi roat akas aiauk sosop karauk roat pakan oiäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Kiro asires Pol kon jaukut pak, erek tainware potomara, keser urwewon, “Okoro roat ak Anut Näwäu omar oik rau nukan sarau roat. Ak Anut nukas owose ätäi imwaraun ämän mare arirai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ko kiro ämän omre sosop tainware arirai kesernuk, Pol nukas kiro sarau asiren wouti monuk, pirirmara, kiro osou aru auruwon, “Is Jisas nukan enip pakaima, aisom, na kiro asir utoinam, man!” Kesernuk, osou aru kiro ses opokar kiro asir utomara, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Kiro asir kameäi roat ak kiro asir ätäi sarau monuk, aiauk owau senek wa räi ronkatemoi, kasiaka penuk, Pol Sailas ori sakau atwatoin. Keseria, akas kiro roat ori, roat näunäu turur rain akan amiakap ate rewate potoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ak roat näunäu amiakap imwate potea, äiein, “Okoro Juda roat akas iken menan roasiret ämän atap awareanik, akan woiaka siräi maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Awas onok atap atap roasiret ätär maroirin. Kiro onok iken sintore ämän tainorau wa. Ik Rom omsau pakan roasiret, okon, ik kiro onok kiro roat ories keserir ik wa tainoram.” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Keseria, roasiret akas onoktoroi Pol Sailas ori akwatoin. Keserna, wasarewareäi roat näunäu akas marai roat awarona, awan omjo oi kureanik, mänkäsiwataun awaroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ak sakau mänkäsi owatomoi, karapus owa kurwateanik, kiro ou kameäwon ro ko kiro roat ori jekur kamwataun sakau ämän aurin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Kiro ou kameäu ro ko akan sakau ämän roumara, kiro roat ori kar ou waru kamuk rau uru kurwatomoi, awan isorawa sakau rakir matomara, im sakau pene moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Pututu om näu kamuk Pol Sailas ori au Anut jou muri sir we rairin. Karauk karapus roat ak erek owa rain ak roi rain. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kurte senes, mim näwäu pemara, kiro karapus ou erekapu rikorwon. Kesernuk, kiro owan ou rorok nukarar tuewon. Kiro mur nais roat ipiakap rakir moin nukarar urare kurewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Kiro ou kameäwon ro, ko siräumara, im erekapu tue kurewon aparmara, kon ronkat karapus roat erekapu imine manoin äiemara, ko kon siräp rumuk oumoi, nukasar nukan enip tutunaun keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kesernuk, Pol nukas urwemara, äiewon, “Ei! Ik imine manau wa, ik erekapu raum, na nakasar nan enmatsau wa aru mau.” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Keseria, kiro ou kameäwon ros karauk roat awaronuk, arou oi pena, ko iminemara, pote Pol Sailas orien isorawa siakup uou sur wewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Keseria, kos kasik imwate nea, awatowon, “Näwäu ori, is owoseita, Anut nukas is ätäi imäirai?” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Awas ätäi auririn, “Nan won Jisas mesin karar epar mota, Anut nukas nan tupsiu pak ätäi imwarai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Keseria, awas Anut nukan ämän kon tupsiu pak matona, roin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kiro pututu, kiro ros imwatomara, awan ui erekapu jekur matowon. Keserianik, nuka pak kon tupsiu pak erek an join. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kos Pol Sailas ori kon owa imwate potomara, o atonuk, jeirin. Ko kon tupsiu pak Anut mesin woiaka epar moin, okon, akan woiaka uru nepipirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Tapera, Rom akan roat näunäu akas marai roat äsimwarona, pote karapus ou kameäwon ro aurin, kiro roat ori utwatona, manaieir. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Keseria, kiro ou kameäwon ros Pol auruwon, roat näunäu akas au karapus owas utoinair, manower äiein awatom, “Au ute manower. Awan woiawa päurar maner!” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Pol nukas marai roat awarowon, “Ik kar onok aru, keserau wa, utianik, ik roasiret amiakap erar mänkäsi oi koin. Ik Rom omsau pakan roat. Ik karapus owa kureikoin rusapai ämäi ämäi äsimoikauri ra? Wa senes! Rom akan roat näunäu akasar koumoi, ik utoikona, manam.” ");
INSERT INTO bbr2013_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Kiro marai roat akas poteanik, kiro ämän Rom akan roat näunäu awaroin. Ak Pol Sailas ori Rom omsau pakan roat ämän roin äpu momana, ak iminein. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Keseria, akasar poteanik, wopurut ori rai awateanik, kiro roat ori kasik imwate neanik, awatoin au okoro mena wa rawau räi awateanik, äsimwatoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Pol Sailas ori au kiro owa utomoi, Lidia nukan owa potoirin, Kiro opok potea, roat woiaka epar moin sakau rawaun ämän awarea, utware manoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pol Sailas ori Lidia nukan mena utia, Amfipolis mena tonoirin. Au Amfipolis menas pote Apolonia mena potoirin. Au kiro mena nais utia, Tesalonaika mena peirin. Kar Juda akan tururiäi ou rau opok tonoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pol ko kiro tururiäi owa tonomara, sumaun omre 3 orip kiro mena raumara, orip orip keseriäu senek Anut nukan ämän ninaremara, eparar senes tamaraun awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Kos Anut nukan ämän ninaremara, onoktapau awarowon, “Anut nukas Jisas ko tätäi näwäu oumara, meieanik, ätäi siräiaun sare mowon. Kiro Jisas is rusapai kon ämän awaroram, kiro Krais, kiro ro Anut nukasar ik imäikaun sare mianik, äsimorwon.” ");
INSERT INTO bbr2013_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Karauk Juda roasiret ak Pol nukan ämän epar äianik, Pol Sailas ori pak tururin. Karauk Grik roasiret ak Anut nukan ämän tainoriäi pak karauk asiret näunäu nais Jisas mesin woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Karauk Juda roat ak kiro onok aparmana, ak akan woiaka ak mesin aru mareanik, näu apu opok poteanik, roat onok aru miäin imwarona, kiro roat aru akas karauk roasiret akan woiaka siräi maroin. Keseria, ak Jason nukan owa poteanik, Pol Sailas ori roasiret akan amiakap imwate kowaun pote ou karirim katorin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ak kiro roat ori apwatau warnuk, akas Jason nukan ou rorok erekapu siräi kureanik, owa tonomoi, Jason pak karauk roat akan woiaka epar moin imwareanik, menan roat näunäu amiakap tai maromoi, äiein, “Kiro roat Pol Sailas ori au omsau erekapu onok aru me arirai. Au rusapai kiro onok keseraun iken mena peirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Keseria, Jason nukas kon owa matonuk, rairin. Au Sisa nukan ämän wa tainoriäir. Awas keser äiäir, okoro omsau opok kar kamoikaun ro rau, kon enip Jisas.” ");
INSERT INTO bbr2013_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Roasiret pak roat näunäu pak ak kiro ämän roumana, akan woiaka aru moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Menan roat näunäu akas, Jason pak roat woiaka epar moin pak ak aiauk sosop mona, epar utwarona, manaiei rai, awaroin. Kesermana, ak ätäi akan owa manoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kiro pututu, roat akan woiaka epar moin akas Pol Sailas ori ämäi ämäi äsimwatona, Beria mena potoirin. Au Beria mena tonea, Juda akan tururiäi owa tonoirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria menan Juda roasiret akan onok eposek, akan onokus Tesalonaika menan roasiret akan onok itimware rai. Ak Anut nukan ämän roianik, woiaka ererianik, Pol nukas Anut nukan ämän omre orip orip ninareäu, kon ämän epar äpu maun akasar jekur ninareäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Keseria, Juda roasiret sosop kiro mena rai akan woiaka epar moin. Karauk Grik roat näunäu pak akan asiret näunäu ak nais akan woiaka Jisas mesin epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Rai rai, Juda roasiret Tesalonaika mena rai ak Pol Beria mena Anut nukan ämän marora ämän roumana, ak kiro mena tonea, kiro pakan roasiret Pol Sailas ori emwataun woiaka siräi maroin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Keseria, kiro pakan roat woiaka epar moin akas Pol äsimorna, kar mena mas an kasakup rau opok manowon. Sailas Timoti ori au karar Beria mena rairin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Kiro roat ak Pol imäi Atens mena pote kuremana, ak ätäi Beria mena potaurna, Pol nukas Sailas Timoti ori kurte pote ko tararsa, sakau ämän awataun awaronuk, ämän oi potoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","17","Pol ko Atens mena potomara, Sailas Timoti ori kamwate rai rai, kiro menan sät eitek akan totok sosop akan ipiakas ate moin aparmara, ko wouti näwäu senes mowon, Keseria, omre orip orip, Pol ko Juda roasiret akan tururiäi owa potomara, Juda roat pak karauk omsau pakan roasiret akan woiaka epar moin Anut nukan ämän tamarowon. Ko amket opok poteanik, inok roasiret koiäi Anut nukan ämän mareäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Ko arenuk arenuk, karauk tamareäi roat akan enmaka Epikurian roat pak Stowik roat pak ak pemana, Pol pak ämänis ketäiein. Ko Jisas meiewon ätäi siräiewon ämän mare rawon, karauk akas äiein, kiro a sakau ro owo ämän äi ari ra? Karauk roat akas äiein, “Ko karauk omsau pakan eitek enip äi arira.” ");
INSERT INTO bbr2013_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Keseria, akas Pol imäianik, Ariopagas tururiäi mena wasarewareäi roat näunäu amiakap imäi potea, äiein, “Ik kiro awau ämän nakas roasiret mareäum mota, ik rowam. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nan karauk ämän ik roumun awau, okon, ik wou wem, ik kiro awau ämän onoktapau jekur aikota roianik, äpu mam.” ");
INSERT INTO bbr2013_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Okoro Atens menan roasiret pak karauk omsau pakan roasiret kiro opok raiäin ak erekapu orip orip ämän awau arena, roia, ak kar sarau wa miäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Keseria, Pol nukas Ariopagas menan roat näunäu amiakap siräumara, äiewon, “Atens menan roasiret, is ak apwaromin, akan woiaka akan eitek jou maraun woiaka epar näwäu senes miäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Is akan tup apariai opok ariemin, is akan eitek jou mareäi patan opok keser jer we moin apwaromin. Kar patan opok ak keser jer we moin ‘Okoro eitek kiro ik kon enip äpu wa nukan patan.’ Ak kiro eitek äpu wa jou muriäi, okon, is kiro eitek kon ämän awaraurim. Kon enip Anut. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Anut nukas okoro omnokou opok osap erekapu rau kiro kos ate mowon. Ko omar omnokou pak awan Näwäu. Ko tup ou roat akas moin opok wa raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ko kar osap wäpik sarenuk, roasiret akas ko nurau senek itok wa, owon, osap erekapu kon. Ko kosar totomaka osou orip pak, karauk osap erekapu roasiret nukasar ariäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ik roasiret rusapai okoro raum, Anut nukas ro karar opokas atoike monuk, kiro tupsiu opokas käianik, omnokou erekapu iporaun mukowon Anut nukasar omre pak mena rawaun pak sare momara, ate marowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Anut nukasar kiro onok keserwon. Owon, roat akas ko atapuk rau rai wa itanäiei, utianik, Anut ko atapuk rawau wa, ko ik siarokop rau. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Ik rusapai ko pak raumoi, kos sakau ikonuk, omnokou opok raiäum. Meter akan äpu miäi roat akas keser jer wein, ‘Ik nais ik kon mokoit.’ ");
INSERT INTO bbr2013_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Keseria, ik Anut nukan mokoit raum, okon, iken ronkat akas Anut ko gol*, silva* aitapau senek rai wa äiäu. Roat akas akan ronkat pakaima ipiakas ate moin rai wa ronkatäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Meter roat ak kiro onok ak äpu wa, okon, ak osap sosop jou maun ate mona, Anut nukas ak aru marau wa. Rusapai Anut nukas omnokou pakan roasiret erekapu akan woiaka piriraun rai ämän sakau marou. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Ko kar omre roasiret erekapu wasarewaraun sare mowon rau. Kiro omre opok kos roasiret akan onok wasarewarai. Ko jekuriar wasarewarai. Kos kar ros wasarewaraun sare mowon. Kiro ro meienuk, Anut nukas ätäi siräi muruwon. Keseria, ik äpu kiro epar.” ");
INSERT INTO bbr2013_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Roasiret ak Pol nukan ämän roat meiein siräiäiei ämän roumana, karauk roat akas ko apari ioin, karauk akas äiein, “Ik ätäi kiro ämän tamukota, rowam.” ");
INSERT INTO bbr2013_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Ak akan woiaka epar mau warnuk, Pol kiro turur rain pakan utwaromara, manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Karauk roat ak kamuk rai, ak Pol nukan ämän tainoria, akan woiaka epar moin. Kar ro kon enip Daionisias, ko Ariopagas menan näu ro, pak kar asir kon enip Damaris pak karauk roasiret pak erek akan woiaka epar moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Pol ko Ariopagas menan roat näunäu amiakap are kuremara, Atens näu mena utia, Korin näu mena potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","3","Kiro opok ko kar Juda ro tararmara, ko pak rawon. Kiro ro kon enip Akwira, Pontus provins opok ureknewon. Kon wau enip Prisila ori, au Rom näu menas rusapai koirin, owon, Sisa-Klodias nukas kon omsau opok Juda roasiret wa rawau, manaiei rai awaronuk, ak Rom näu mena ute manoin. Keseria, Pol ko kiro Juda ro asir ori apwatau poteanik, au pak rawon. Au ser ou ate mianik, karauk roat aromoi, aiauk oiäir. Kiro Pol nukan sarau miäu senek, okon, ko au pak kiro sarau me rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Pol nukas sumaun ses opok tururiäi owa, Juda roasiret pak Grik roasiret akan woiaka piriraun ämän orip orip mareäwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sailas Timoti ori au Masedonia provins pakas Pol siakup potona, Pol ko kar sarau mau wa, ko Anut nukan ämän karar Juda roasiret Jisas ko Krais rai awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Karauk Juda roasiret ak kon ämän rowau utianik, jeimarna, kos akan onok aru ätär maraun kon omjo pakan maimai us putarianik, awarowon, “Anut nukas ak aru maronuk rai, kiro isan usu wa, kiro akan usu. Isan woi näu raunuk, rusapai is karauk omsau pakan roasiret Anut nukan ämän awaraun potam.” ");
INSERT INTO bbr2013_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Keseria, ko utwaromara, pote kar ro enip Titius-Jastas nukan owa pote rawon. Ko Anut jou muriäu ro. Kon ou Juda roasiret akan tururiäi ou siakup raiäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Kiro tururiäi ou kameäu ro kon enip Krispas, ko kon tupsiu pak karauk Korin roasiret pak ak Pol nukan ämän roumana, woiaka epar momoi, ak an join. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kar pututu, Näwäu nukas Pol nine epir senek pakaima auruwon, “Na wa iminäu, isan ämän roasiret awaraun wa utau. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Is na pak raim. Kar ros na pak iwäi momara, wa aru musai, owon isan roasiret sosop ak okoro mena rai.” ");
INSERT INTO bbr2013_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Keseria, Pol ko kiro mena woisan karar keir 6 orip raumara, roasiret Anut nukan ämän tamare rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","13","Rom akan roat näunäu akas kar ro enip Galio, ko Grik omsau kamäun sare murin. Ko kiro omsau kameäwon ses opok Juda roasiret ätäi tururianik, Pol sakau atomana, wasarewareäi roat näunäu opok imäi potomana, äiein, “Okoro ro ko iken roasiret Anut jou muraun onok atap tamareäu. Ik kon ämän tainorta rai, ik Sisa nukan sintore ämän wa tainoram.” ");
INSERT INTO bbr2013_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol nukas ätäi awaram äienuk, Galio nukas Juda roasiret awarowon, “Ak Juda roasiret, rowe! Okoro ro ko kar iken omsau pakan sintore ämän utau wa. Ko kar onok aru senes mau wa. Ko kiro onok keserwon maro, is akan ämän epar awarowom. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Utianik, kiro akan sintore ämänin koi airoi, kiro akasar jekur mowe. Is kiro ämän wa aparam.” ");
INSERT INTO bbr2013_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Kos keser awareanik, äsimwaronuk, kasik noin. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Kasik nomana, ak kasiaka penuk, kar ro ko akan tururiäi ou kameäu ro enip Sostenes sakau ateanik, Galio nukan ou siakup erar wein. Galio ko kiro onok keserin ko ronkatäu wa. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pol ko Korin mena omre sosop roasiret akan woiaka epar moin pak rawonus, ous pakas utwaromara, Siria provins potaurwon. Prisila Akwira ori au Pol pak erek potoirin. Pol ko ous oik tonau wa opok Senkria mena Juda akan onok tainorianik, kon tapau kurum sarewon, owon, ko kar onok keseraun Anut paip muruwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Efesas mena pemana, kiro opok Prisila Akwira ori utwatomara, Pol nukarar Juda roasiret akan tururiäi owa Anut nukan ämän marau manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Akas ko omre rumuk ak pak rawaun aurin, kos awarowon, “Is ak pak ekep wa rawam,” räi awarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ko manaurmara, keser awarowon, “Anut nukas ätäi okoro opok koi aironuk, is epar kowam.” Keseria, ko ous oumara, Efesas mena utomara Sisaria mena potowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Ko Sisaria mena potomara, Jerusalem näu mena toptomoi, roasiret woiaka epar moin ämän awaromara, Antiok mena ätäi manowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol ko Antiok mena om rumukurar rawonus, manowon. Ko Galesia provins pak Prigia provins opok mena atap atap ariemara, roasiret akan woiaka epar moin sakau mare mare ari rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Kar Juda ro ko kon enip Apolos, ko Aleksandria näu mena urek sarewon, ko Efesas mena pewon, Ko ämän eposek miäu, ko Anut nukan ämän erekapu eposek äpu mowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Karauk roat akas ko Jisas nukan onok jekur tamuruna, kos pak ätäi Jisas nukan ämän tuku karauk roasiret tamarowon. Utianik, ko Jon nukan an jomareäwon onok karar ko äpu. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Ko Juda roasiret akan tururiäi owa tonomara, ko roasiret iminewarau wa, Anut nukan ämän sakau marowon. Kesernuk, Prisila Akwira ori au kon ämän roumoi, awan owa imäi poteanik, awas karauk Jisas nukan ämän ko äpu wa jekur tamuroirin. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apolos ko Anut nukan ämän Akaia provins maraun manaurnuk, Efesas menan Kristen roasiret akas kon ronkat sakau muruna, Akaia provins pakan Kristen roasiret ko imäiäun rai, jer we nuruna, oiar potowon. Keseria, kiro omsau opok, Apolos nukas potomara, Anut nukas kon wou näu oripas roasiret sarwarnuk, akan woiaka epar moin, kiro roasiret jekur sarwarowon. ");
INSERT INTO bbr2013_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ko karauk roasiret akan amiakap, Juda roat ämänis sakau kewareanik, kos Anut nukan ämän ninareanik, tamarowon, epar Jisas ko Krais, kiro ro ko Anut nukas äsimornuk, ak imwaraun kowon ro. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","2","Apolos ko Korin näu mena Akaia provins opok raunuk raunuk, Pol ko Prigia provins utomara, ari ari pote, Efesas näu mena pewon. Kiro opok, karauk roat woiaka epar moin tarwaromara, totwarowon, “Ak akan woiaka epar momana, Anut nukan Osou Näu oin ra?” Akas ätäi aurin, “Osou Näu rau ik äpu wa.” ");
INSERT INTO bbr2013_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Keserna, Pol nukas ätäi totwarowon, “Ak owo onok pakaima an join?” Akas ätäi äiein, “Ik Jon nukan onok pakaimas tainorianik, an jomukoin.” ");
INSERT INTO bbr2013_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pol nukas ätäi äiewon, “Meter Jon nukas roasiret akan onok aru pakan pirirna, an jomarowon. Kos roasiret kiro ro rusapai koura, konun akan woiaka epar maun rai keser awarowon. Kiro ro ko Jisas.” ");
INSERT INTO bbr2013_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ak kiro ämän roumana, ak Jisas mesin woiaka epar moin karauk roasiret ätär maraun an join. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pol nukas kon ipou kiro roasiret akan tapiakap maronuk, Anut nukan Osou Näu ak opok penuk, akas karauk omsaukan ämän atap atap ak meter äpu wa momana, kis Anut nukan enip jou murin. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kiro roasir erekapu ak 12 orip senek. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pol keir 3 orip kiro mena raumara, ko Juda roasiret akan tururiäi owa tonomara, orip orip Anut nukan ämän epar äpu maun sakau ämän awarowon. Ko ak pak raumara, Anut okoro omnokou koi kamäun ämän erekapu mare rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Karauk roasiret akan woiaka sakau monuk, ak kon ämän rowau utomoi, äiein, “Kiro Näwäu nukan Apu tainoraun ämän tamukiäu kiro ämän sätäiäu.” Keser äiena, Pol ak utwareanik, kos Jisas nukanun woiaka epar moin roasir imwaromara, Tiranus nukan ämän ateai owa potoin. Omre karar karar roasiret pak ämän wasareäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Pol ko kiro onok keserwon. Woisan oirori ko kesernuk, kiro Juda roasiret pak Grik roasiret Esia provins raiäi pak ak erekapu Anut nukan ämän roin. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Anut nukas Pol nukan ipokup kurur näwäu atap atap keserwon. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Roasiret kiro onok aparianik, akas päm si pak karauk omjo eteinak pak oianik, Pol nukan enipsau kotomarianik, sip roat siarakap potomoi, akan opiakap mona, sip aru pak osou aru ak opok rakurein ute maneäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Karauk Juda roat akas nais pote ariemana, osou aru oi kuraun, ak Jisas nuka enip ateanik, osou aru jäkäi oi kuraun keserin. Karauk akas osou aru awareäi, “Is kiro Jisas, Pol nukas awareäu, kon enip pakas ak kurte manaun sakau awarom.” ");
INSERT INTO bbr2013_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Kar Juda akan Anut kamuk raiäwon ro näwäu enip Skeva, kon mokoit 7 orip akas kiro onok keseriäi. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Utianik, kar omre opok kiro osou arus awarowon, “Is Jisas Pol ori äpu. Ak inokot?” ");
INSERT INTO bbr2013_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kiro ro ko osou aru oripas kasak pemara, kiro roat 7 orip sakau akwaria, näwäu senes aru marea, akan omjo erekapu kiräi maronuk, päm pirim kon owas imine manoin. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Juda roasiret pak Grik roasiret ak Efesas mena raiäi ak kiro ämän roumana, erekapu sakau iminein. Keseria, akas Jisas nukan enip näwäu kämioik jou murin. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Roasiret akan woiaka epar moin akas pemana, akan onok aru keseriäin erekapu amop moin. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Karauk roat meter otin amkeäin ak akan buk uru os ämän jer wein rau erekapu oi koianik, roasiret akan amiakap ep näwäu uru amke kurein. Ak kiro buk karauk roat aroin maro, ak aiauk sosop 60,000 kina senek owaun itok. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Anut nukan ämän omsau erekapu iporomoi, sakau senes pewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kiro onok erekapu keserianik, Pol ko Masedonia provins pak Akaia provins pakas potea, Jerusalem näu mena potaun ronkatewon. Kon ronkat pakaima äiewon, “Is kiro opok potoita, Rom näu mena nais pote aparam,” äiewon. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Keseria, kos Timoti Erastus ori kon sarau sareäirin roat ori äsimwatonuk, Masedonia provins potosa, nuka Esia provins om rumukur rawon. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Kiro ses opok, karauk roat ak Anut nukan apu tainorau utomoi, ämänis auratein. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kar ro ko kon enip Demitrias, ko kar aiauk enip silva pakas karauk osap ate miäu. Kos kiro aiauk silva pakas kiro sät eitek enip Atemis nukan tup ou totok eteinanak sosop ate monuk, karauk roat akas kau mona, ko kiro pakan aiauk sosop oiäu. Keseria, kos roat sosop silva sarau aronuk, mona, ko aiauk näwäu oiäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kos kiro roat pak roat osap sosop ate miäi pak turur maromara, awarowon, “Jaiat, ak äpu iken aiauk eposek sosop kiro sarau pakas peäu. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kiro ro enip Pol nukas owo ämän äiäu akasar roinai, aparwe. Kos äiäu, roat akas akan ipiakas eitek totok ate miäi, kiro sät eitek. Keseria, kos okoro Efesas mena pak Esia provins pakan roasiret sosop senes erekapu awaronuk, ko karar tainori. ");
INSERT INTO bbr2013_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Kiro Pol nukan ämänis iken aiauk sarau aru mukaun itok. Kiro karar wa, roasiret akas kiro asir Atemis iken eitek näwäu nukan tup ou ätäi wa jou maiei. Kiro asir roasiret erekapu Esia provins pak kiro omnokou erekapu jou muriäi, kon sakau wasaräi.” ");
INSERT INTO bbr2013_vpl VA