﻿USE sofia;
DROP TABLE IF EXISTS sofia.bbb_vpl;
CREATE TABLE bbb_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bbb_vpl WRITE;
INSERT INTO bbb_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","2","Iko zinume ijia Godi fu aesakae igiakiro saove ije amaeriae. Ro ae sakae ado ijia ire bino fuka baki ro fune do ijare ijia nafuekoga ve ireobo fu ijia titute. Ro do ado ijia fune Godido Kavene ijiaru fu ijia oenoene. ");
INSERT INTO bbb_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","5","Areme Godi fune maza ije kuamoga fu are ije titutema ijia sanamoga fu ijene gamo fuka oemae. Ijiege rena fune uri titutema ijene abe atasena sanaema ije fu abe gue nijaga titutema fu abe gue nijae. Ijadufuo fu uri sanaema ije fu kua, Mazareno kuae. Ro titutema ije fu kua, Mugeno kuae. Ro ire ije fu mazani amure ijia amaeria furikoga ve ijia titutei. ");
INSERT INTO bbb_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","8","Areme Godi fune do ije kuamoga fu atana guegue rei. Do gue fu kuamoga fu kabo ijia nakoga gue fu ume ijia nafuemo fu are ririkua ije kua, Saoveno kuae. Fu ijiege amaeriama furikoga ve una ijia titutemo fune mu inokiro rei. ");
INSERT INTO bbb_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Areme Godi fu una do ume ije nafuema ije kuamoga fu una besu nafuekoga sakae gue fu iriare. ");
INSERT INTO bbb_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Godi fu are ije iriarema ije fu kua, Sakaeno kuaga are ije do nafuema ije fu kua, Davareno kuae. Bu ijiege revoga fu ije giamo fuka oemae. ");
INSERT INTO bbb_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Areme Godi fu uri uije ni binobino ije kiamoga bu sakae ado ijia tavuae. Ro ifiri gue sunine bu ijo ijiebe ijia tavuakoga gue bu ire vuiti igeki ijiebe ijia tavuae. ");
INSERT INTO bbb_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","13","Ire boge bu sunine kiravoga Godi ije giamo fuka oemae. Fu ijiege rekoga ve fu ijia titutemo fune una mu inokubeke rei. ");
INSERT INTO bbb_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Areme Godi fu kuae, Na ire binobino ije kiaga bu kave ijia sanaga are akaegue fu ve titutekiro gue fu sanake. Ro bure irena nijasuoga no maza besubesu ro asame ro juaevasia ro maza mamekanu ije giana vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Asame ijiakiro mazani ijiebe kave ijia irena sakae ige sanaejake. ");
INSERT INTO bbb_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ijadufuo fune uri ire sanavo inokiro ka mamekanu ije amaeriae. Mazani ije fu maza ijia sanadufuo ro asame ije fu muge sanadufuo ije amaeriae. Fune ijiege rei areme kuke ire zuvi ije amaeriae. ");
INSERT INTO bbb_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","19","Areme fune uri sanaema ije bu sakae ige sanadufuo ije kena kave ijia nae. Fu ijiege rega are akaegue fu ve titutekiro gue fu sanake. Godi fune ire ije bu reva ije giamo fuka oemae. Ijiege rena fune ve titutemoga fune una mu inokiro kiro inokiro rei. ");
INSERT INTO bbb_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Areme Godi fu kuae, Ni ire oe ruvo binobino do ijia oenoekiro ume binobino bu kave ijia oenoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Ijadufuo Godi fune kuaemoga kijume mamekanu ijiakina ire ni binobino do ijia oenoejo ije bune do ijia oenoe. Ijiege re areme fune kuke kuaemoga ume binobino kave ijia oenoejo ije bune ijia oenoevoga fu ije giamo fuka oemae. ");
INSERT INTO bbb_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","23","Areme fune ire boeje do ijia oenoevo ijiakiro ume kave ijia oenoevo ije daro miana kia, Ni ame nafena boeje reno kiae. Fu ijiege rema furimoga ve ijia titutemo fune una mu umui fague rei. ");
INSERT INTO bbb_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","25","Areme Godi fune fina kuaekoga fanu ni binobino mamekanu ro isesina ni uria tarare ijia ro sidove ijia oenoedufuo ije bu sakae ado ijia oenoe. Bu ijia oenoevoga Godi fu ije giamo fuka oemae. ");
INSERT INTO bbb_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","27","Areme Godi fu kuae, No iviama ema no vareki ije amaeriake. No amaeriaga bure aesakae boeje igia fanu taraeko ro aeko binobino ije samuagiake. Ro kuke bure umekina kijume isesina ro mamekanu ije samuagiake. Fu ijiege kuaena fune e fari ro bara fu vareki ije amaeriae. ");
INSERT INTO bbb_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Areme Godi fune bu daro miana kia, Ni va ame uruvana tuanaekina bure are irore boeje igia karifo. Bure karina ire boeje sakae igia naovo ije samuagiake. Ro kuke nane daro miaedo jare fanu boeje bu sakae ado igia oenoevo ijiakina ume boeje kave gufia oenoevo ije samuagiake. Ro kuke jare kijume ro ire boeje do ijia oenoevo ije samuagiake. ");
INSERT INTO bbb_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","30","Ro ifo boeje ja idufuo ro ire vuiti igeki ije nane joefuo ijifureki naejiae. Ro kuke fanu boeje binobino ro ume kave ijia oenoevo ijiebuo ire bu idufuo ije na vajomakina ia binobino nane amaeriaevano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Godi fu ijiege kuaekoga ire boeje bune fu kuaema ijiege rei. Godi fu ire boeje fu amaeriaema ije giamo fuka oemae. Godi fu umui fague ro dikine besu ijia fu aesakae igiakiro saove ro ire boeje amaeria furi. ");
INSERT INTO bbb_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Ijiege rena Godi fu maza ijia ire boeje ige amaeriama furi. ");
INSERT INTO bbb_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Ro maza seveni (7) ije Godi fu ire boeje fu amaeriamo ije fu ijia furi. ");
INSERT INTO bbb_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Maza seveni ije fu abe daro mana fu akae remoga fu abe irigi nijae. Ijadufuo maeje Godi fu maza ijia fu ire boeje ume igia ro saove gufia naovo ije amaeriama furinoga fune ijia arena fi. ");
INSERT INTO bbb_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","5","Godi fu ijiege fina rekinu ire boeje ume igia ro saove gufia naovo gue no giavo ro giavo baki ije amaeriae. Maza ije Godi fu ire boeje amaeriaema ijia sakae ado ijia ifiri ro ire uije bino bu naebe ijia tavuae. Ijadufuo maeje Godi fu ve be fu naebe kuamo fu dae. Ro kuke fu erare ijia oenoekinu sakae rudufuo ije fuka baki. ");
INSERT INTO bbb_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Rove do ije fume sakae guove ijia ajiana sakae ije safikirame. ");
INSERT INTO bbb_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Areme Godi E Ireobo ije fune sakae ijia matuana abe e fari amaeri. Areme fune uri e ijadufuo udo ijia ivua ije fu oerukinu oenoedufuo ijene ufenogana e ije fune ijia uri oeru. ");
INSERT INTO bbb_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Ijiege rena Godi E Ireobo fune uri juare be are mazani ajiamo naka ijia mena ive ina Ideni kuae. Areme fune e ije fu amaerima ije mesirina juare ijia nujae. ");
INSERT INTO bbb_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Areme fune juare ijia uije binobino ije kiamo bu ijia tavuana sunine ka ni mukore ije kirae. Ro juare ukua ijia ine inokiro bu ijia irei. Ine be ije e bu nubuna ikuva bu oekuva baki. Ro ine be ije e bu nubu ikuva bu vame binobino ise ro ma bu mukore vierafedufuo ijare ijia manine. ");
INSERT INTO bbb_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Ro do be fu juare Ideni safikirakiro ijia kanana keke vae. Fu kana kekena dabe atana inokiro kiro inokiro rei. ");
INSERT INTO bbb_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Do be ije Fisoni fu kanana aesakae Avira ijia vae. (Ro do ijia ire gorodi ije fuka ma uruvana. ");
INSERT INTO bbb_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Ro kuke ire udi mukore urivo ijiakina mune ni mukore bu moni mamekanu fuaevejo ije bu ijia karivo.) ");
INSERT INTO bbb_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Ro do be ije Gaeoni fu kanana aesakae Kusi ijia ura vae. ");
INSERT INTO bbb_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Ro una do be ije Taegirisi fu kanana aesakae Asiria ijia vae. Ro do be ijeja Ufiretisi. ");
INSERT INTO bbb_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Areme Godi fune e fari ije mesiri juare Ideni ukua ijia nujae. Fu ijia nujaga fure juare ijia ire boeje amaeriakinu samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Godi fu e ije mesiri ijia nuja areme kuae, Ine boeje juaru igia ireva ijiebuo fo ije ni nubu ine. ");
INSERT INTO bbb_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Ro ine besu juare ukua ijia manino ije e bu nubu ina vame ise ro ma ije vierafevo ijiaru sunine fuone ije ade nubu ino. Ro a faememare nubu ikuma aka maza besu ijia baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Areme E Ireobo Godi fu kuae, E gure na amaeriva ije fu fuosukua oenoekuma na vierafe fuka naebe mareke. Ijadufuo na vierafe naka kai fuone ma be fu ifejadufuo ije amaerikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Ijadufuo fune uri sakae ijia matuana fanu ro ume boeje binobino amaeriae. Areme Godi fune kaenamiana e ije fino ije nijaekoga fu giakinu ive buone ije imiae. Ijadufuo fanu ro ume boeje bu vame ijiege rena ive buone ije kei. ");
INSERT INTO bbb_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Ijiege rena e ije fune uri fanu ijiakina ume boeje ijiebuo ive ije imiae. Rove ire boeje fu imiaema ijia kai fuone ma besukua be fu naebe ijia gae. ");
INSERT INTO bbb_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Areme E Ireobo Godi fune e ije kuamo fu una ni ireobo nae. Fu ni naekoga Godi fu uri ikene ane fuone be damukoga surive fuone ije fu una ifekurae. ");
INSERT INTO bbb_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Godi fune ikene ije abe bara amaeri areme mesirina e ije fino ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Areme e ije fune uri bara ije gama areme kuae, Iviama ijare ire gure na gaga fuka na vareki. Ane fuone ije fu ane none igia abei. Ro kuke birage fu ije fune none igia atae. Ijadufuo fuje na barano kuake ijadufuo maeje fu e fari ijadufuo guove ijia abe amaerimano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Ijiege reva ijadufuo iviama e fari ije fu asoe ijiakiro asie fuone uniakona va bara fuone ijieki mazievo ijia bune buosiki vajae besu reke. ");
INSERT INTO bbb_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Ro e fari ijiakiro bara ije buka detaba rove bu naebe vierafe ro kuke bu jaediamo baki. ");
INSERT INTO bbb_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Areme E Ireobo Godi fune fanu boeje fu amaeriaema ije uve ijia fu ire tabare ije fuka e biesiriamo ije amaeri. Ijadufuo ire tabare ije fune ro bara ije fino ijia kekei. Fu kekena bara ije biesirina kuae, A Godi fube ma kua ine juare ukua gare manino ije ade fo fuone nubu ino kuae? ");
INSERT INTO bbb_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","3","Fu ijiege kuamoga bara ije fu una kuae, No Godi fu kuo, Ja ine fo boeje ni nubu ikiro ine besu gare manino ijiaru fo fuone jade nubu iro niriaevono kue. Ro ja niriaekuva jaka maza besu ijia oekono kue. ");
INSERT INTO bbb_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","5","Bara ije fu ijiege kuaramoga tabare fu una kuae, Godi fuka kufuimedo ja oekuva baki. Fu vierafero ja nubu ikuva ja fu vareki rekiro fu ijadufuo kuriaere. Ja ikuva ja vame ise ro ma boeje jaka vierafekiro fu ijadufuo ja biesiriaemano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Bara ije fu vua ije fiemo fuka oeseremo fu una dakude ine ije gae. Fu gake ine ije fuka ma mukore ro kuke fu nubu ikuma fuka maekiro fu ije vierafe. Ro kuke fu vame ise ro ma ije mukore vierafekiro fu ije vierafe. Ijadufuo fune uri ine fo bino nubuna igana gue fu kena baru fuone ije vajamo fudua kena i. ");
INSERT INTO bbb_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Bu ine sunine ije nubu inama furiko bu ijia Godi fu irerefuo kuriaere bu vua vierafei. Areme bu ijia uri bue ganamigake bune detaba irei. Ijadufuo buka jaedia bu uri suviene turana vajae buone ije okuriae. ");
INSERT INTO bbb_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ijiege rena bune kari fieke Godi E Ireobo ije fune ve jiaema ijia juare uvo ijia urana romo bu fiena uri ine ijia ufuaena saui. ");
INSERT INTO bbb_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Rove E Ireobo Godi fu uri e fari ije kumei, A izieburekino kumei? ");
INSERT INTO bbb_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Ro e fari ije fu una gue kumei, Na are juare ijia ura romo na fievo naka judie ijadufuo na igi saui. Ijadufuo maeje naka detabaga na kona sauivano kumei. ");
INSERT INTO bbb_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Fu ijiege kuarao Godi fu kumei, Erare kua a detabano kuae? Abe ifo ije na kuriaereva ije nubuna imano kumei? ");
INSERT INTO bbb_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Ro e fari ije fu una gue kumei, Na bara ije a abe nujaejiema ijare ifo ije damu igana miemo na abe ivano kumei. ");
INSERT INTO bbb_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","E fari ije fu ijiege kuaramoga Godi fu una bara ije kumei, Ije a irerefuo ijiege remano kumei? Fu ijiege kumenoga bara ije fu una gue kume, Na tabare ijare biesirimoga na ine fo na ijene damuna ivano kumei. ");
INSERT INTO bbb_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Ijadufuo Godi fu uri tabare ije kuae, Aka isema kema ijadufuo na a dabe isekafake. A fanu boeje ige na amaeriaeva ijiebuo uve ijia a osukua aka vajae fiane abeke. Godi nare kuaedo a devatua dabe sakaedo ijia medirunoeke. Ro kuke one a fivako ije a sakae kuokuo ijiaru inoeke. ");
INSERT INTO bbb_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ro kuke nare kuaedo a maza boeje bara ijiaki zienamikinu karivake. Ro maza boeje uifari one ijiakiro bara ijadufuo uifari ije buka bue nibijaekinu oenoeke. Ro kuke e bu diake utaenamaga a sakiakuma bu kana nigofo one dabe furasekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Godi fu tabare ije ijiege kuara areme una bara ije kuae, A ijiege rema ijadufuo a e fudiemo ro ame nafemo ijia aka vajae fiane ma ireobo abena isejavaeke. A ijiege renoeno ijia aka uria baru one ije vierafeke. Ro fure a samuagakinu vua kuarake a ijia fiekinu fivakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Ro una e fari ije fu kua, A bara one ijadufuo vua ije fiena irinana una ifo na kuriaereva ije damuna i. A ijiege rema ijadufuo na sakae ige vafuke. Na ijiege rega a koro daro one ijia giriesana me ikinu fivake. ");
INSERT INTO bbb_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","A ijiege rema ijadufuo sakae ige fuka fiene ma ro seki uruvana bu ijia tavuana iraraeke. Ro aeje a taraebo ijia oenoekinu ire one rerena inoeke. ");
INSERT INTO bbb_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","A koro fuare ijiakuma giriesana imega ire ije fu sakae ijia nake. A ijiege rekinu fivakuma baronega bu dabe una sakae ijia mako ruke. Na sakae ijia abena a amaeraeva ijadufuo a una sakae ijia sakae rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","21","Areme Godi fune fanuve surive ijia kena saguma areme kena saejiae. Ijiege rekoga Adamu fu ve ijia uri bara ije ive ina Ivi kuae. Ijadufuo maeje fu e uine nijavo ijiebuo asie. ");
INSERT INTO bbb_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Areme E Ireobo fu kuae, E gure iviama fune una no vareki rei. Fune izege no vua ma ro ise no vierafevo ije fudua fune ijiege vierafe. Ijadufuo no vierafe noka rorukuraga fu juare ige arena keke vake. Na ijiege rekina fube ine fo e bu nubu ina maza boeje ma karivako ije nubu ina ma fivakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Ijadufuo E Ireobo Godi fune Adamu rorukuramo fune juare Ideni arena keke vae. Fune kekena va aesakae ije Godi fu abena fu amaerima ijia korufuo ire uije binobino ona amaeriakinu samuakiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Areme Godi fune juare Ideni irifo are mazani ajiamo nake ijia anera gue ro sime uiki miane igege naeno ije kena ijia nae. Bure ine ije e bu nubu ina ma karivadufuo ije iraraeve. ");
INSERT INTO bbb_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Areme Adamu fune bara fuone Ivi mesiri oenoena fune e fudie. Fu e fudiena ame fari be bietena kuae, Ivia E Ireobo fuka na mukore ifejiemo na e fari bietevano kuae. Ijadufuo fu uri ame ije abe ive ina Keini kuae. ");
INSERT INTO bbb_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ro rade Ivi fu una ame fari be dua bietena abe ive ina Eboro kuae. Areme e Eboro fune mave-sifi samuagiakoga Keini fu juare mei. ");
INSERT INTO bbb_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Ro rade maza be Keini fune juare fuone ije masina ire bino kena E Ireobo zinone ufujae. ");
INSERT INTO bbb_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","5","Fu ijiege rekoga Eboro fudua fune mave-sifi amure nafeva ijia be farena abe E Ireobo zinone ifaejae. Eboro fu ijiege remoga E Ireobo fuka Eborokiro zinone fu ifaejema ije oemare. Ro una Keinido zinone ije fu naebe oemarei. Ijadufuo Keini fu ije gamo fuka defarui. ");
INSERT INTO bbb_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","7","Fu ijiege remoga Godi fu kuae, A irerefuo ziema ijadufuo aka naebe oemare? A mukore kemabitie zinone one ije naka oemareke. Rove a ire ise ije rema ijadufuo ise ije fune viene one gumaeji sauina a samua fine. Fu vierafe aka maza boeje fu irinakega fu a samuagakiro fu ije vierafe. Rove ade mamoekiro nika giriesana ise ije iraraenoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Areme maza be Keini fu urina uvia fuone Eboro kuae, Rono juare gamia oenoeke vano kuae. Fu ijiege kuamoga bune va makave ijia oenoevo ijia Keini fu urina ine dabe iviene fuone kanamoga funeka ijia barone. ");
INSERT INTO bbb_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Areme Godi fu uri Keini kumei, Uvia one Eboro fu izieburekino kumei? Fu ijiege kumemoga Keini fu una gue kumei, Na uvia none ije na nare maza boeje samuavo baki. Ijadufuo fu iziebure oenoeno ije nake naebe gae. ");
INSERT INTO bbb_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Fu ijiege kumemoga Godi fu kuae, Vame ije a kema ije fuka ma ise. Uvia one a kanaema ijadufuo kavuane ije fu sakaedo ijia usiaema ije nane gae. Kavuane ije fu vierafe na fu vafaekiro fu ije e igege nimena na kurarieme. ");
INSERT INTO bbb_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","A ijiege rema ijadufuo na a vafaedo ame maza boeje ijiege rekinu fivake. Ro maza boeje i one a meno ubae ije fuka iserekinu vake. Fune sakae ijare e igege itire akekoga uvia one ijadufuo kavuane a kana fu usiaena ijia arimo fu i. ");
INSERT INTO bbb_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ijadufuo a oenoene sakae ijia juare mekuma ire uije ije bu mukoe tavuakuva baki. Ro kuke a ae besu dasu fikuma baki ro ame diaegia ura oenoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Godi fu ijiege kuaramoga Keini fu una gue kuae, Vajae fiane ije a na dabe ijiege kafiekuveno ije fuka ma gikikimana na izege ijene bijuke? ");
INSERT INTO bbb_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Na nidua one igia na fivo ije ane rorekuriedo nane va na ebe are sao mumabo ijia ura oenoeke. Na va ijia oenoega erare na biediekuma bu kaniekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Keini fu ijiege kuaramoga E Ireobo fu una kuae, Ije fu baki. Erare oenoene a kanakuma na daro maedo are iraraena e uruvana kaniakono kuae. Ijadufuo E Ireobo fune nuga fuone ijene Keinido vajae ijia nijae. Fu ijiege nijaekina e bu oenoene Keini biekuva bube kanake. ");
INSERT INTO bbb_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ijadufuo Keini fu E Ireobo ijadufuo nidua ijia fu finoeno ije fune arena uri are mumabo ijia vae. Fune va are maza ajiamo nake are be bu kua, Diaeigia Oenoevono kuavo ijia fikiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Ijiege rena e Keini fune bara fuone abena ame fari be bietena abe ive ina e Inoki kuae. Areme Keini fune uri are sidove ireobo be keinama areme abe ame fuone ije nabuikei. ");
INSERT INTO bbb_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Areme e Inoki fune uri ame fari fuone Irade e Meujaerodo asoe ije bietei. Ro Meujaero fu uriro e Metiusaero e Ramekido asoe ije bietei. ");
INSERT INTO bbb_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Ro e Rameki fune uri bara fuone inokiro bara Adakiro Zira ijene kei. ");
INSERT INTO bbb_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","22","Ro bara Ada fu uri e Jabaro bietei. Ro e Jabaro fu e ije eranebe bu fanu ro ume binobino samuagiakinu fanu surive ijia are isesina sana karinoejo ijiebuo asae. Ro Jaborodo uvia fuone e Juboro fu e ije eranebe bu bibo ufekinu gita kanavo ijiebuo asae. Ro bara Zira fu uri ame fuone e Tuboro Keini ije nafei. Ro e Tuboro Keini fu ire ajane ni binobino ro sime dudone ijieki ije amaeriamo. Ro maki fuone ije bara Nama. ");
INSERT INTO bbb_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","24","Areme maza be Rameki fu uri bara fuone Adakiro Zira kiae, Vua ige na kuariavo ije fiefo. E be fune na kaniemo na ijadufuo ve kanavo fu baronei. Ro Keini bu kanaeva ijadufuo bu una ve e bino kaniakuva ije na vierafe bu e seveni (7) ijiege kaniake. Ro una irere ige nare reva bu ijadufuo ve kaniekuva ije na vierafe e seveni (7) ije bakiro bu e seveniti seveni (77) ijiege kania bu oekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","26","E Adamekiro bara fuone bu ame fari bedua bietei. Areme Ivi fu kuae, Godi fune fari none Eboro e Keini fu kanamo fu baronema ijadufuo una bedua miemano kuae. Ijadufuo fu abe ive ina Seti kuae. Ro e Seti fune uri fari fuone be bietena e Inosi kuae. Ijiege rena maza ijia ema bune uri zinuevena E Ireobo ijadufuo ive akae ije dabe aroekinu baname isoekafana ruae. ");
INSERT INTO bbb_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","2","Ro e ive ige isoeva ige ijeja e Adamudo uifari ije bu izege uinuvena ruaeva ijene. (Mazani ije Godi fu e amaeriaema ije fune fue ganamikinu ijia e fu vareki ijene amaeriae. Fu baru bara amaeriana uri daro miana ive buone fu kia Eno kuae.) ");
INSERT INTO bbb_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","5","Adamu fu fivakuma juaevasia uvani aderedi teti (130) ijiege furi. Areme Adamu fune ame fari be fu vareki ije bietena abe ive ina Seti kuae. Ro fu kuke ame kabae ro fari bino duaku tuana areme juaevasia naene aderedi teti (930) ijiege furiko fu ijia barone. ");
INSERT INTO bbb_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ro fari fuone Seti fu fivakuma juaevasia uvani aderedi faeve (105) ijiege furiko fu ijia fari fuone e Inosi kuavo ije bietei. ");
INSERT INTO bbb_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","8","Seti fu anafa fuone bino duaku tuana areme fune juaevasia naene aderedi tuero (912) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","11","Ro maza ije Inosi fu fima ije fu juaevasia naeniti (90) ijiege furiko fu ijia ame fari be ive fuone e Kenane ije bietei. Ro fu ame bino duaku tuanae areme rade fune juaevasia naene aderedi faeve (905) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","14","Ro e Kenane fu fina vakuma juaevasia seveniti (70) ijiege furiko fu ijia fari fuone e Mararero bietei. Ro Kenane fu ame fuone uruvana tuanae areme rade fune juaevasia naene aderedi teni (910) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","17","Fu baronekoga fari fuone e Mararero fu fivakuma juaevasia sisiti faeve (65) ijiege furikoga fu uri fari fuone e Jaredi bietei. Areme rade e Mararero fu kuke una ame bino duaku tuana areme fu juaevasia eti aderedi naeniti faeve (895) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","20","Areme Jaredi fune fi vakuma juaevasia uvani aderedi sisiti tu (162) ijiege furikoga fu uri fari fuone e Inoki bietei. Ro rade fu juaevasia uruvana fikinu una ame bino duaku tuanama areme juaevasia naeni aderedi sisiti tu (962) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","22","Jaredi fu baronekoga fari fuone e Inoki fu juaevasia sigisiti faeve (65) ijiege furiko fu uri fari fuone e Metusara bietei. Ro rade e Inoki fu juaevasia tiri aderedi (300) fu fi ruaema ije fu una kuke ame bino tuanae. Ro maza ije e Inoki fuka uri Godi mukore oetuana fuosiki maza boeje goruvekinu finoe. ");
INSERT INTO bbb_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","24","Fu ijiege renoena juaevasia tiri aderedi sigisiti faeve (365) ijiege furiko fume ijia bakiremo e bu naebe gae. Ijadufuo maeje fune Godire mesirina vako bu rerega baga bu ijarei. ");
INSERT INTO bbb_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","27","Areme Metusara fune fi vakuma juaevasia uvani aderedi eti seveni (187) ijiege furikoga fu fari fuone e Rameki bietei. Ro fu juaevasia uruvana ijia finoekinu ame bino tuana areme juaevasia naeni aderedi sigisiti naeni (969) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","29","Metusara fu baronekoga fari fuone e Remeki fu juaevasia uvani aderedi eti tu (182) ijiege furiko fu bara abena ame fari be bietei. Remeki fu ame ije bietena ijiege kuae, Ae sakae ige Godi fu abe isekafaema ijia ame igare irufui ige no abekinu isejavaena ruovo ije bijukurakono kuae. Remeki fu ijiege kuaena ame ije abe ive ina Noa kuae. ");
INSERT INTO bbb_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Areme Remeki fune una juaevasia faeve aderedi naeniti faeve (595) ijiege fikinu ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Areme fune juaevasia seveni aderedi seveniti seveni (777) ijiege furiko fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Remeki fu baronekoga Noa fune fivakuma juaevasia faeve aderedi (500) ijiege furi. Fu ijiege finoekinu fari fuone inokubeke e Semikina Emikina e Jefeti ije tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Areme maza ijia e uine bu tuanavo ije funeka ma uruvana rekoga ae sakae ige fune e ijare iraraeme. Ro e uine ije bu tuanaeva ijia bu kuke e bara ije uruvana tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ijadufuo Kavene adaki bino kave ijia oenoejo ije bu bara ni mukore ije oenoejo ijene giae. Ijadufuo bu arina bara ije bu giana oemarevo ijene bino buone kei. ");
INSERT INTO bbb_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Areme E Ireobo fu kuae, Iviama igia una gafege vako ijia kavene none ije nabe areke fu ema ijena maza jiamadogo fivake. Ijadufuo maeje bu ema ijadufuo bume juaevasia uruvana (120) ijiege karivake. ");
INSERT INTO bbb_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Areme maza ijia rade e ije bu kari ruaeva ijia e gue buka e mamekanu. Ijadufuo maeje isuibe ijia bune kavene adaki ije kave gufia oenoevo ijiebe arina bara ume igeko ije kena ame tuanaeva ijadufuo uifari gue buka e daroki ro ka e mamekanu. ");
INSERT INTO bbb_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","6","Maza ijia e boeje aesakae igia oenoevo ije buka maza boeje vame ise ijiaru renoevo. Ro kuke bu maza boeje ise renoejo ijadufuo nigofo buone fune ise ijare irarae. E ije Godi fu amaeriana aesakae igia uniaema ijiebe ijiege revo ijadufuo E Ireobo fu ijene giamo fuka ireobo oefiae. ");
INSERT INTO bbb_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Ijadufuo fu kuae, Ivia na e boeje na amaeriaeva ijiakina ume ro fanu binobino ije boeje naka uinituga bu furike. Ijadufuo maeje ire boeje nare amaeriaedo bu ijiege renoeko na fina giaga fuka ireobo oefiadiemono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","E Ireobo fu ire boeje fu amaeriaema ijia fu e Noa fuosukua fuone izege fu finoeno ijene gamo fuka ireobo oemarei. ");
INSERT INTO bbb_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Ro e Noado vame fuone fu kenoekinu finoema suvuare fuone ije ijiege. ");
INSERT INTO bbb_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Fu bara abei ro anafa fuone inokubeke. Ame be ive fuone ije e Semi ro be ije e Emi ro be e Jefeti. Maza ijia e Noa fuosukua fuka e mukore. Fu maza boeje Godiki goruvekinu vame maturaema ijiaru kenoe. ");
INSERT INTO bbb_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Rove e boeje bu una Godido nidua ijia buka vame ise ma uruvana renoekinu bue bijaena kananamikinu ijiege renoe. Ijadufuo ise ijare are irore boege fune irarae. ");
INSERT INTO bbb_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Godi fu fina gake aesakae ige funeka ise ijare irarae ijadufuo maeje e boeje bu vame ise umigi ije kenoeve. ");
INSERT INTO bbb_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Godi fu ije gana uri Noa kuae, E boeje na giaga buka ise ma uruvana renoeve. Ijadufuo na e boeje naka kaniana uinituga e besukua be fu naebe una ijia fivake. ");
INSERT INTO bbb_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ro aeje ni urina vanage be ine saefurasi ijia kena amaerine. Ro a vanage amaerimo ije ni guove boeje amaeriane. Ro kuke ni vanage ikene guove ro ado ije ni ire kazine tano kuavo ijare abena mukoreigia kamanoena arekina do fu naebe ijia arudufuo. ");
INSERT INTO bbb_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Ro a amaerikuma ni jiagado fuone ije uvani aderedi fifiti mitasi (150) ijiege amaeri ro kakare ije tuaedi faeve mitasi (25) ijiege amaerine. Ro kuke kabo fuone ije ni fifitini mitasi (15) ijiege amaerine. ");
INSERT INTO bbb_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Ro nine are ado ije sakurane. Ro kuke ni birune ado ijia tire isekube foti-fo (44) senitamita ijiege amaeri ufuaenoena arene. Ro ni gire be ado ro be ukua ro be rotire ijiege sane. Areme ni ikene ijia viene be umatene. ");
INSERT INTO bbb_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","A vanage amaeri furino ijia na safua ireobo be kuaga fu aesakae igia firana e ro ire boeje oeruvo ije kaniana kame uinituke. Ro ire besukua be fube arega fu aesakae igia oenoeke. ");
INSERT INTO bbb_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ro aeje na vierafe na vua be osiki kuaena avenamina abe marekina na agane one ijena karauniake. Ijadufuo ni bara one ijiakina anafa one ro bararafa buone ijena vanage ijia ajiane. ");
INSERT INTO bbb_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","20","Areme nine fanu ro ume ni binobino ijia ubae ro irave ijene kaenamia ajiaekina bube oena uibiteke. ");
INSERT INTO bbb_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ro kuke nine ire binobino fanu ijiebuo ro jone ja ikinu karidufuo ijene karina ijia ajiano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Areme Noa fune urina ire boeje Godi fu kuaraema ijiege rema furi. ");
INSERT INTO bbb_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Noa fune ire boeje rema furinoga Godi fu kuae, Ni agane one boeje foteke ijene kaenamia vanage ijia ajiane. E boeje aesakae igia oenoeva ijiebuo uve ijia a osukua aka vame maeje na oemadiedufuo ijia kenoe. ");
INSERT INTO bbb_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","A vanage garia ajiakuma ni fanuve ma binobino irave seveni ro ubae seveni ijene kaenamiana ijia ajiane. Ro kuke ni fanu ise Godi fu kuriaerema ije ni binobino irave ro ubae ijene kaenamiana ijia ajiane. ");
INSERT INTO bbb_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Areme nine kuke ume ni binobino ijia irakiro ubae ijia seveni ijiege giakinu kaenamia ijia uniane. A ijiege rekina bube oefurikiro bu uria karikina una sakae igia uije nijake. ");
INSERT INTO bbb_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ro ivia igia vakuma muge seveni furino ijia na ve ireobo kuaga fu muge foti (40) ro maza foti (40) ijiege dake. Na ve ije kuaga fu dana ire boeje na amaeriaeva bu ni uria karina oe ruvo ije arafiriaga buka isejavaema oefurikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Ijiege rena e Noa fune ire boeje E Ireobo fu kuaraema ijiege rema furi. ");
INSERT INTO bbb_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Fu fina ruoma juaevasia sigisi aderedi (600) ijiege furiko aesakae igia safua fu ijia firae. ");
INSERT INTO bbb_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Safua fu ijiege firamoga e Noa fune bara fuone ijiakina anafa ro bararafa buone ijene kaenamiana bune subinaena vanage ijia ajiae. ");
INSERT INTO bbb_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","10","Noa fune kuke fanukina ume ni binobino irave ro ubae ivo ro ivo baki ijene kaenamiana fuina ijia ajiae. Noa fune ire boeje Godi fu kuaraema ijiege rema furi areme muge seveni furikoga safua ireobo fu ijia firae. ");
INSERT INTO bbb_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Juaevasia ije safua fu firaema ije Noa fu juaevasia sigisi aderedi (600) ijiege furi. Ro juaevasia ijia asame ririkua ijadufuo fura inokiro ro muge inokubeke furima ijia do ije fume sakae ijia ajiae. Fu ajiakoga ve ma ireobo fu ude naebe aesakae igia daema ijare saove ijia dana ari. ");
INSERT INTO bbb_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Ve ije fu ijiege dakinu vakuma muge foti (40) ro maza foti ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Ijiege rekoga mazani besu ijia Noa fune bara fuone ro anafa fuone inokubeke e Semikina Emi ro Jefeti ije ro bararafa buone ijena bune vanage ijia ajiae. ");
INSERT INTO bbb_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","16","Bu ajiakoga fanu aeko ro taraeko ni binobino ro ume ni binobino isesina ro mamekanu ije oeruvo ubae ro irave boeje budua Noado ruakoga fu kaenamiana vanage ijia ajiae. Bune izege Godi fu kuaema ijiege rena bune ijia ajiama furikoga Godi fu viene dabe bijukurae. ");
INSERT INTO bbb_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Areme rena ve ije fune mazani foti (40) ijiege dakoga safua fune aesakae igia nafue. ");
INSERT INTO bbb_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","19","Safua ije fu ijiege firana ajia vakuma nafare mamekanu boeje fune okuriakoga vanage ije fune do ado ijia nanianoene. ");
INSERT INTO bbb_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Rove safua ije fu naebe ijia iri ro fuka nafuena ajia vakuma nafare ije seveni mita (7) ijiege asidiana ajia vae. ");
INSERT INTO bbb_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Safua ije fu ijiege nafuekoga ire boeje aesakae igia oerunoejo ije buneka oefuri. Fanu aeko ro taraeko ro ume ni binobino boeje buka oefurikoga e boeje budua oefuri. ");
INSERT INTO bbb_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ire boeje aesakae igia oeruvo buka oefuri. ");
INSERT INTO bbb_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","E Ireobo ijare ire boeje fanu ro ume ro e boeje ni uria karijo ijene kame mukoreigia ijiege arafiriamo bu oefuri. Ro fune e Noakiro e ije fu kaenamia vanage ijia ajiaema ijiebe buosukua bu naebe oe. ");
INSERT INTO bbb_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Ro safua ije nafuema ije fu naebe migegire si ro fu uria ijiege nako vakuma muge uvani aderedi fifiti (150) ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Rove Godi fu Noakina fanu boeje binobino bu fuina vanage ijia ajiaeva ije fuka maza boeje bu vierafekinu samuagiamo. Ijadufuo Godi fu majaufi ije kuamo fu ufikoga safua ije nafuema fune ijia zinuive sina una ari. ");
INSERT INTO bbb_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","3","Ijiege rekoga do ije sakae guove gumia ajiavo ije bune arekoga ve ije kave gufia damo ije fune ijia tui. Areme do ije fune soneigia sina una ariko vakuma muge uvani aderedi fifiti (150) ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Areme asame umui gue ro dikine inokiro ijadufuo fura inokiro ro muge inokubeke furikoga vanage fu una ari ruoma nafare Ararateno kuavo ijia arei. ");
INSERT INTO bbb_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Do ije fu ijiege sone sina arikinu vakuma asame umui guegue ijadufuo maza amure ijia nafare kubi ije bu ijia una samadire. ");
INSERT INTO bbb_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Areme maza foti (40) ijiege furikoga Noa fune uri viene daovena ume kadia ijene dabe nujamo fune vae. Ume ije fu vaema fu naebe una ruae. Ro fume kave ijia oenoeko vakuma do ije funeka mukoreigia sina ari. ");
INSERT INTO bbb_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Areme Noa fune una kuke ume tuvuaeki ijene nujamo fu do ije ninakokiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Rove do ije fu naebe sina furi ijadufuo ume fu naebe umeke ari. Fu kave ijia afuodinoega iseremo fu una ruoma vanage ije namo ijia romo Noa fu umui abuena dabe una aru vae. ");
INSERT INTO bbb_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ijiege rena do ije fuka naebe simoga Noa fu fina maza seveni (7) ijiege furikoga fu una kuke ume tuvuaeki ije dabe nujamo fu vae. ");
INSERT INTO bbb_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Areme ve nakisirema ijia ume ije fune ine oriveno kuavo ijadufuo a iviaeko ije datura biekunana una ruae. Ijadufuo Noa fu ijia gana vierafero safua ije fune sina furimaro fu ijiege vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ro Noa fune una samua fivakuma maza seveni (7) ijiege furinoga fune una kuke ume tuvuaeki ije dabe nujamo fu kekena vae. Ro ume ije fu keke vaema ijare fu naebe una ruae. ");
INSERT INTO bbb_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Areme Noado mazani bu bieteva ije fune ruoma sigisi aderedi uvuane (601) ijiege abei. Fu ijiege abekoga juaevasia besu ijadufuo mazani amure ijia sakae ijia do ije fune si furi. Do ije fune ijiege simoga Noa fune uri vanage ijia kenifuri gake aesakae boeje funeka iriarei. ");
INSERT INTO bbb_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ijiege rena vakuma asame inokiro furikoga do boeje fune mukoreigia si furi. ");
INSERT INTO bbb_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Areme Godi fune uri Noa kuae, Nine bara one ro farirafa one ro bararafa buone ijena vanage ije arena aesakae ijia ari vane. ");
INSERT INTO bbb_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Ro kuke nine ume ro fanu boeje binobino oeruvo ijiakina fanu binobino aesakae ijia oenoejo ije kaenamiana ari vane. A kaenamia ari vaekina bure nafemanamiga fu aesakae boeje igia iraraeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Ijadufuo Noa fune bara fuone ro anafa ro bararafa buone ijene kaenamiana sisime ije arena ari vae. ");
INSERT INTO bbb_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Ijadufuo fanu ro ume ni binobino ro fanufanu boeje aesakae igia oenoejo ije bune bue maziemaziena una ume ijia ari. ");
INSERT INTO bbb_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Areme Noa fune uri Godi oemarejakiro zinone ijadufuo fata be ufe. Fu ufema areme uri fanu ro ume ni binobino bu zinone ifaejedufuo Godi fu kuaema ijene kaniana ijia Godi zinone ifaejae. ");
INSERT INTO bbb_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Noa fu zinone ijiege ifaejemoga E Ireobo fu zinone udi mukore ije fiemo fuka oemae. Ijadufuo fu fue kuae, Na vierafega ema bu katiki ijia vakuma e mamekanu revo ije buka ire ise boeje rekuae vierafenoedufuo. Rove nabe una aesakae ige vafuke. Ro nabe izege na ire binobino ni uria karivo ige na ke arafiriaeva ijiege rade una kuke arafiriake. ");
INSERT INTO bbb_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Areme fu kuke kuae, Maza boeje aesakae ige fu navako ijia e bu veze ui okinu ro masidufuo ije fu uria ijiege navake. Ro kuke maza veze fu iduane urikinu ro fete uridufuo ro kuke veze fu ve marekinu ro ve dadufuo ije fu uria ijiege navake. Ro kuke ro veze fu ve titutekinu ro ve irasedufuo maza ije bu uria ijiege rekinu nao vake. ");
INSERT INTO bbb_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Areme Godi fune Noakina anafa fuone ijene daro mia areme kiae, Nine ame uruvana tuanaga uifari jone ijiebe are irore boegia iraraefo. ");
INSERT INTO bbb_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Ro fanu boeje bu sakae ado ijia oenoevo ijiakina ume ro kijume davare ijia oenoevo ije buka ja jumekinu oenoeke. Na bu nane kena una daro jone ijia uniae. ");
INSERT INTO bbb_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ijadufuo iviama fanukina ume ro kijume ije nine kania buvua ikinu ro ifo ije duaku ni turana inoefo. Ire boeje bune jone ja ijia turana inoekiro na ije arejiae. ");
INSERT INTO bbb_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ro ire besu ije fanu birage uria kavuane usiaemo ijiaru jade ivo. Ire ijiaru na kuriaeredo jabe ike ijadufuo maeje jone ja karivako ije fu kavuane ijare reko ja ije karive. ");
INSERT INTO bbb_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ro erare ema be kana fu baronekuma e ije bu dabe isekafake. Ro fanu be fu ema be saki fu baronekuma nare ve dabe isekafaga fu baroneke. ");
INSERT INTO bbb_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Ema ije Godi nare abe na vareki amaeri ijadufuo erare ema be kana fu baronekuma fu duaku bu kana fu baroneke. ");
INSERT INTO bbb_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ro jaeje ni ame nafega bu aesakae igia uruvana rena ijia nafemanamino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Areme Godi fune Noakina anafa fuone ije kiae, ");
INSERT INTO bbb_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","10","Na iviama ja ro uifari jone ije bu rade urivo ije kuke ire boeje binobino ume igia oeruvo ume ro fanu aeko ro taraeko ije bu aena vanage ijia ari ruaeva ijena vua kuaena amaerike. ");
INSERT INTO bbb_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Na vierafe rade nabe una do kuaga fu firana ire boeje ume igia oenoejo ije buone kari vako ijene kena kave ijia kaniafuke. Ro safua kuaga fu firana aesakae ige abe una arafiriga fu iserekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ijiege rena Godi fu kiae, Vua ije na ja ro ire boeje jaena ume igia oerunoejo ro kuke uifari rade urivo ije jaena kuaena mareva ije na nuga be nijake. Ro vua ije na jaena kuaena mareva ije fu maza boeje ijiege na vake. ");
INSERT INTO bbb_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ro nuga ijeja na anuage ijia abena nijake. Ro ije fu nuga none na a ro e boeje are irore igia oenoeva ijena na naebe una do kuaga fu firana ja arafiriadufuo na kuaena nijaeva fu maza boeje ijia na vadufuo ijene. ");
INSERT INTO bbb_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","15","Na ijiege nijaekina na amite kua fu saove garia utike anuage fu ijia samo ijia na vua irere na ude ja ro ume ro fanu binobino ije jaena kuaeva ije vierafeke. ");
INSERT INTO bbb_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","17","Maza ije na anuage ije gavo ijia na una vua none izege na ire boeje umeigia ni uria karinoevo ije jaena kuaena mareva ije vierafeke. Ro anuage ije fu nuga none na ire boeje ume igia oeruvo ije jaena kuaena mareva ijene ");
INSERT INTO bbb_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noado anafa inokubeke ije bu Noana sisime ijia usiae makave ijia vaeva ive buone ijeja Semikina Emikina Jefeti ijene. Ro e Emi fu e Kenanido asoe. ");
INSERT INTO bbb_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","E Noado anafa inokube ije bu e boeje aesakae irore igia karinoeva ijiebuo asaerafa. ");
INSERT INTO bbb_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Noa e ije ire binobino sakae ijia omo ijare ire vaenino kuavo ije amure abe sakae ijia okoga bu ijia uije abena ojana ruae. ");
INSERT INTO bbb_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Maza be Noa fune do vaeni ina nigofo iseremo fu ugone fuone fu saema ije azosema detaba are fuone ijia name. ");
INSERT INTO bbb_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Fu ijia nakoga Emi e Kenanido asoe fu aru va gake asoe fuone fu detaba namo fu gae. Fu gana una keke va uviarafa fuone inokiro ijene kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Areme Semikiro Jefeti bune ugone be abena ijueneke irana guegue farena vae. Bune ijuenijue aru vakuma asoe buone namo ijia usiaena ni gariebure rerekinu ugone dabe nakarae. Bu asoebuo detaba naga bu ga fuka isediakiro bu ijadufuo ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","25","Bu ijiege rekoga Noa fu navakuma nigofo fuone fune una maremoga fu ijia fari fuone iviene izege fu rema ije fiemo fuka naebe oemarei. Ijadufuo fuka urina kuravajana kuae, Maza boeje Kenani fu fivako ije fuka ire ise ro irufui uruvana biediakinu vake. Maza boeje Kenani fuka una uviarafa fuone ijiebuo moni baki i mejianoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Ro fu kuke kuae, No Godi E Ireobo ijadufuo oemarejana aroeke. Ijadufuo maeje fu Semido Godi ijene. E Kenani fuka maza boeje e Semido moni baki i mejanoeke. ");
INSERT INTO bbb_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Ro e Jefeti fuje fu Godire maza boeje daro maga fu aesakae ireobo abedufuo. Ro e Jefetido uifari ije bu maza boeje e Semido uifari ijena besu karinoeke. Ro e Kenanido uifari ije bu kuke maza boeje una e Jefetido uifari ijiebuo moni baki i mejianoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","29","Ro safua ije firaema ijuone ijia Noa fu una kuke juaevasia tiri aderedi fifiti (350) ijiege fivae. Ro Noa juaevasia fuone foteke fu fi vaema ije naene aderedi fifiti (950) ijiege furikoga fu ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ro ige e Noado anafa inokubeke e Semikina Emikina Jefeti ijiebuo uine ijene. Safua ije fu firaema ijuone ijia ame inokubeke ije bu urina anafa buone ige tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ro e Jefetido farirafa ijiebuo ive ijeja e Gomekina Magogikina Madaekina Javanekina Tubarokina Mesekikina e Tirasi ijene. Ro e agane binobino eranebe bu e igiebuo ive ijia nabukaraeva ije bu e ijiebuo uifari ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ro e Gomedo uifari ijeja e Asekenasi ijiakina e Rifati ro e Togama ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ro e Javanedo uifari ijeja e Erisako ijiakina e Sifiiniko ijiakina e Saefurasiko ijiakina e Rodiko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","E ijiebuo uifari ijeja e ije bu davare irifo ijia karinoekinu davare ui tura naeva ijia karinoevo ijene. E uifari ije bu e Jefetido ijiebe isama buone binobino kuaenoekinu atana aesakae binobino ijia karinoe. ");
INSERT INTO bbb_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ro una e Emido farirafa ijeja e Kusiko ijiakina e Ijifitiko ijiakina e Ribiako ijiakina e Kenaniko ijene. Ro e agane binobino eranebe bu e igiebuo ive ijia nabukaraeva ije bu e ijiebuo ufuifari ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ro una e Kusido uifari ijeja e aesakae Sibako ijiakina e Avirako ijiakina e Sabetako ijiakina e Ramiako ijiakina e Sabetekako ijene. Ro e Ramado uifari ijeja e Sibako ijiakina e aesakae Dedaniko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","E Kusi fu fari fuone bietena abe Nimiroti kuae. E ijare amure aesakae igia e aesakae binobino ijia karinoeva ijena azo mukore kena e boeje iraraena kaniae. ");
INSERT INTO bbb_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Fu E Ireobo ijare ifejamo ijadufuo fu e be sume mukoe bijamo rei. Ijadufuo iviama e boeje bu kuaevo, No vierafe E Ireobo ijare a ifejaga a e Nimiroti fu e sume mukoe bijamo ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Ro amure aesakae ije fu azo ijia iraraena kema ijeja Bebironikina Erikikina Akate ro Karine ijene kei. Ro aesakae inokiro kiro inokiro ije bu ae sakae ireobo Bebironia guove ijia. ");
INSERT INTO bbb_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Fu ijiege re areme va aesakae Asiria ijia kekena sidove mamekanu Nineva ro Reoboteri ro Kara ro Reseni ijene sae. Ro sidove Reseni fu sidove anuigi inokiro Ninevakiro Kara bu kariva ukua ijia. ");
INSERT INTO bbb_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Ro e Ijifitido uifari ijeja e aesakae Ridiako ro e Anameko ro e Reabiko ro e Nafetuko ijia kariva ijene ");
INSERT INTO bbb_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Ro kuke e aesakae Fatirusiko ro e Kasiruko ro e Kafito ijia kariva ijene. Ro e Kuriti ijiebuo uifari ijeja e Firisitaeniko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Ro una e Kenanido fari amure e Saedonikiro iviene fuone e Eti ijiebuo uifari ijeja: e ije eranebe ive buone ijia nabuikaraeva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Ro kuke e Kenanido uifari gue ijeja e aesakae Jebusaetiko ijiakina e Amoraetiko ro e Gegasaetiko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Ro kuke e aesakae Ivaetiko ijiakina e Akaetiko ro e Sinaetiko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","19","Ro kuke e aesakae Avadaetiko ijiakina e Zemaraetiko ro e Amataeti ijia karinoeva ijene. E Kenanido uifari ijiebe ma uruvana rena vakuma aesakae Sidoni ikene ijiege vakuma aesakae Gera are Gaza ivuake ijia vae. Ijiege rekoga uifari gue bu una mazani ajiamo nake ijia karija vakuma Sodome ro Gomora ro Atema ro Zeboimi aesakae Rasa ivuake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","E uifari ije bu e Emido ijiebe ijiege atana ae sakae buone binobino ijia karikinu ro isama buone binobino ijia kuaeve. ");
INSERT INTO bbb_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Ro una Semi e Jefetido boge ijadufuo uifari ijeja e Iburuko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ro e Semido anafa ijeja e Eramikina Asukina Afakasatikina Rudikina e Arame ijene. Ro e uifari buone ijeja e ije eranebe bu ive buone ijia nabuikaraeva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ro una e Aramedo uifari ijeja e Usiko ijiakina e Uruko ijiakina e Getako ro e Miseko ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Ro e Semido fari e Afakasati fu uri fari fuone e Sira bietemoga Sira fu uri fari fuone e Iba bietei. ");
INSERT INTO bbb_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ro Iba fu uri anafa inokiro nafena be fu abe ive ina Ferekino kuae. Ro ive Fereki ijadufuo maeje e boeje aesakae igia kariva ije bu maza ijia dabe atana guegue rei. Ro una ame be ije fu abe ive ina e Jokitanino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ro e Jokitanido uifari ijeja e Aremodateko ijiakina e Serefiko ijiakina e Asamavetiko e Jerako ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","29","Ro kuke uifari gue ijeja e Adoramiko ijiakina e Usavoko ijiakina e Dikiroko ro e Obariko ijene. Ro uifari gue ijeja e Abimaeroko ijiakina e Sibako ijiakina e Ofiko e Avirako e Jobabeko ijene. Ame boeje bu e Jokitanido uifari ijene. ");
INSERT INTO bbb_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ro e Jokitanido uifari ijiebe aesakae Mesa ijia karijana una are Sifa nafaeneke mazani ajiamo nake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","E uifari ije bu e Semido ijiebe ijiege atana aesakae buone binobino ijia karinoekinu isama buone binobino ijia kuaenoe. ");
INSERT INTO bbb_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","E uifari boeje igia isoena kuaevo ije bu e Noado uifari ijiebe aesakae buone binobino ijia karija vaeva ijene. Safua ireobo ije firaema ije rade Noado anafa inokube ijiebe urina ame uije nijavoga bu ijia tuamanamina uri atana aesakae buone binobino ijia karijana vakinu isama buone binobino kuaena vae. ");
INSERT INTO bbb_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Ro iko zinume ijia e boeje ige aesakae boegia karinoeva ije bu isama besu vua kuaena fienamivo. ");
INSERT INTO bbb_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ro e gue bu aesakae mazani ajiamo nake ijia oenoena are amarama be gana ijia kari. Ro are amarama ije fu ae sakae Bebironia guove ijia. ");
INSERT INTO bbb_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Bu aesakae ijia karina bue kuae, Rono ire makoe ijia ire gikikimana mune igeki bu ae sadufuo ijene amaeriano kuae. Ijadufuo bu urina ire mune igeki bu are sadufuo ije amaeria areme uri ire be bu ijia azina naga fu kamadufuo ijene amaeriae. ");
INSERT INTO bbb_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Bu ijiege re areme kuae, Roga no sidove ireobo be amaerima areme ijia karikinu gire ireobo jiagado be sana ajia vakuma saove gafe niriaefo. No ijiege rekuva no fuka maraduoke ro kuke noka e ifiki reke. No ijiege rekina no naebe dabe giegisa aesakae igia binobino karinoeke. ");
INSERT INTO bbb_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Bu ijiege kuaena renoejoga E Ireobo Godi fu sidove ireobo bu kena kariva ijiakiro gire jiagado bu saeva ije giakiro arina ruae. ");
INSERT INTO bbb_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","E Ireobo fu ire ije bu revo ije giana kuae, Iviama e gure bune guri isama besu vua kuae fienamive. Ro kuke bune zinuevena are gare save. Ijadufuo no giana areke bu uria ijiege karina sakuva no vierafe bu va rade ire mamekanu binobino rekuae vierafekuva buneka redufuo. ");
INSERT INTO bbb_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Ijadufuo roga no arina isama buone gume bu besu kuaena fienamivo ijene dabe bieturaejiaga bube rade una vua kuaena fienamino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Ijadufuo E ireobo fune e ije bu besu afuina kariva ijene dabe jijiae. Fu ijiege remoga bune uri dabe giegisana are irore ijia vagana sidove ireobo ije bu savo ije bu ijia arena vae. ");
INSERT INTO bbb_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Ro sidove ije bu sakuae reva ije bu kua Babero. Ijadufuo maeje E Ireobo fu sidove ijia arina isama besu bu kuaevo ijene dabe bieturaejiae. Ro kuke fu sidove ijia e ije bu besu afui kariva ijene kame jijiamo bu dabe giegisana are irore igia vae. ");
INSERT INTO bbb_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Ro e Semido uifari ije ijiege. Safua ije nafuema ijueneke ijia juaevasia inokiro furikoga rade Semi fu fi vakuma juaevasia uvani aderedi (100) ijiege furikoga fu ijia ame fari e Afasati ije nafei. ");
INSERT INTO bbb_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Ro rade e Semi fu una juaevasia faeve aderedi (500) ijiege fikinu una ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","13","Ro Semido fari e Afasati fu fivakuma juaevasia teti faeve (35) ijiege abeko fu ijia ame fari e Sira ije nafei. Ro rade e Afasati fu una juaevasia fo aderedi tiri (403) ijiege finoekinu ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","15","Ro e Sira fu fi vakuma juaevasia teti (30) ijiege furiko fu ame fari e Iba nafei. Ro rade Sira fu una kuke juaevasia fo aderedi tiri (403) ijiege finoekinu una ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","17","Ro e Iba fu fi vakuma juaevasia teti fo (34) ijiege furiko fu ijia ame fari e Fereki biete. Ro rade e Iba fu una kuke juaevasia fo aderedi teti (430) ijiege finoekinu una ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","19","Ro e Fereki fu fivakuma juaevasia teti (30) ijiege furiko fu ijia ame fari e Reu biete. Ro rade Fereki fu una juaevasia tu aderedi naene (209) ijiege finoekinu una kuke ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","21","Ro e Reu fu fivakuma juaevasia teti tu (32) ijiege abekoga fu ame fari fuone e Serugi biete. Ro rade Reu fu una kuke juaevasia tu aderedi seveni (207) ijiege finoekinu una kuke ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","23","Ro e Serugi fu juaevasia teti (30) ijiege abekoga fu uri ame fari fuone e Neo biete. Areme rade Serugi fu una kuke juaevasia tu aderedi (200) ijiege finoekinu una kuke ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","25","Ro e Neo fu fivakuma juaevasia tuaedi naeni (29) furiko fu ame fari e Tera ije biete. Areme e Neo fu una kuke juaevasia uvani aderedi naenitini (119) ijiege finoekinu una kuke ame bino duaku tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Ro e Tera fu fivakuma juaevasia seveniti (70) ijiege abeko fu farirafa fuone e Aburamekina Neokina e Erane ije tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Ro una e Terado uifari ije fu ijiege Terado anafa ijeja e Aburamekina Neokina Erane ijene. Ro e Erane fu uri fari fuone e Roti biete. ");
INSERT INTO bbb_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Rove e Erane fu asoe fuone Tera fu uria fikoga fu uria e nikaki ijia baronei. Fu sidove fuone isekube bu fu nafeva bu kua Eano kuavo sidove Bebironi guove ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","30","Ro e Aburame fu uri bara fuone Sera abekoga Neo fu uri uvia fuone e Eranedo kabae bara Miruka abei. Ro bara Mirukakiro e Isika ijiebuo asoe ijeja e Erane. Ro bara Sera fuje fu debire. ");
INSERT INTO bbb_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Maza be Tera fune sidove fuone iseke Eano kuavo Bebironi guove ijia fina areme uri fari fuone Aburamekiro bara fuone Sera ije kaenamiana vae. Tera fu ino baraki ijiakiro asaefuo e Eranedo fari Roti ijene kaenamiana fune urina aesakae Kenani ijia vakiro vae. Bu Kenani vakuae vakuma sidove Eraneno kuavo ijia kari. ");
INSERT INTO bbb_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Bu ijia karivakuma Tera fu juaevasia tu aderedi faeve (205) ijiege abeko fune ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Bu ijia kariva ijia E Ireobo fu Aburame kuae, Ni urina aesakae one ijiakina agane one ijiakina asoe one ijadufuo are ije arena urina vaga nare aesakae be nijasaga a ijia fine. ");
INSERT INTO bbb_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","A ijia vaga na daro maga ame uije one a tuanamo ije buka e uruvana reke. Ro nare a daro mana samuagakinu marejaga a una e uruvana ifejiana marejiake. Ro kuke nare daro mana ive one dabe ma ireobo reke. ");
INSERT INTO bbb_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ro nare e ije erarebe bu a marejavo ijene daro miana samuagiakinu marejiake. Ro erarebe bu a kuravajana vafakuva ije nare una ve bu kuravajiana vafiake. Ro e boeje aesakae igia karinoeva ije na one duvado ijia bu marejiake. ");
INSERT INTO bbb_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Ijadufuo Aburame fune fivakuma juaevasia seveniti faeve (75) ijiege abenoga fune izege E Ireobo fu kuaraema ijiege fune sidove Erane arena vakiro uri. Aburame fune zinuivena urina vakoga bara fuone Serakina kaju fuone e Roti bune urina fuina vae. E Aburame fune uri sinuome fuone maeje boeje ro e fuone moni baki imeno ije fu Erane ijia fikinu kema boeje ije kaenamiana vae. Aburame fune ijiege rena agane fuone ijene kaenamiana vakuma Kenani ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Areme fune are ije ukua ijia urana vakuma are akae Sekemi ine anuigi Moreno kuavo ije manino ijia kekei. (Ro maza ijia e Kenaniko bu uria aesakae ijia kariva bu ijia vae.) ");
INSERT INTO bbb_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Areme E Ireobo fu are ijia arina Aburame biena kuae, Aesakae ije na abena uifari one ije miakiro kuaeva ije ijifurekino kuae. Areme Aburame fune urina are ije E Ireobo fu arina biema ijia fata be fu ijia fuone baname isoedufuo ije mune ijia tuana nana amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Aburame fune ijiege rei areme rade fune una urina nafaeneke una are ikene ijia vae. Fu urina are sidove Betiero are mazani koeno nake ro sidove Ai una mazani ajiamo nake ije ukua ijia fanu surive ijia ae sana finoe. Aburame fune kuke ijia mune ijia tuana E Ireobo ijadufuo fata amaerima ijia fuone baname isoe. ");
INSERT INTO bbb_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Ijiege rena Aburame fune ijia fijana una Kenani are ikene bu e Ijifitiko kanikuriaeva ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","13","Areme vasia ka ma ireobo fu aesakae Kenani ijia kekemoga Aburame fune biona ari gamia aesakae Ijifiti ijia maza isekube fikiro vae. Ijiege rena Aburame fune vakuma e Ijifitiko bu oenoeva ijia ura vakiro uri bara fuone Sera kuae, Aeje aka bara ni mukore. Ijadufuo e Ijifitiko bu a gakuva buka kanie na baroneke bu a abenamake. Ijadufuo bu a gana kuakuva ni kiako a maki noneno kiaekina bu kaniedufuo ije bu arekiro bume mukoreigia samuaguoga no buina ijia karino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Fu ijiege kuarana bune vakuma Ijifiti ijia usiaevoga e Ijifiti bune gake Sera fuka bara ni mukore. ");
INSERT INTO bbb_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Ijadufuo e Kini Ferodo imevo gue bune Sera gana va Kini Fero kuarae. Bu kuaravoga fune kiamo bune bara Sera mesirina are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Kini Fero fu bara Sera gamo fuka oe maemo fuka Aburame dabe mukoreigia oetuana ifejae. Fu ifejana mave-sifi ro kau ro kamero ro doniki iravekiro ubae ro e moni baki imenoevo bara ro baru ijene uruvana vajae. ");
INSERT INTO bbb_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Rove E Ireobo fu Sera ije fu va Kini Ferodo are ijia fino ijadufuo fuka adame ise ma uruvana ije kiamoga bu Kini ijiakiro e boeje ijia kariva ijiebuo ruae. ");
INSERT INTO bbb_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Ijadufuo Kini Fero fune kuriaerena kiamo bu Aburame mesiri rovoga fu uri madina kuae, A irere none rema ije kuarie na fiene? A bara gure fu ma onekuma ni ijiege samanukua kuarie na fiekuma. ");
INSERT INTO bbb_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","A irerefuo biesiriena kie fu maki noneno kiemoga na abei? A ma isema rema ijadufuo bara one ije ijifurekino ni una mesirina keke vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Kini Fero fune ijiege kuara areme uri e fuone imevo ije kiamoga bune Aburamekiro bara fuone ro ire boeje Aburame fu kema ijiakuma kuriaeremoga bune Ijifiti arena vae. ");
INSERT INTO bbb_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Ijiege rena Aburame fune aesakae Ijifiti ijia urina una ikene ijia ufuaena Kenani ikene ijia fikiro vae. Aburame fune uri bara fuone ijiakiro ire boeje fu kema ijene kaenamiana vae. Fu vakoga e kaju fuone Roti fune fuosiki vae. ");
INSERT INTO bbb_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","E Aburame fuka mave kina kaukina goti uruvana zarae. Ro kuke fuka ire siruvakiro gorodi ma uruvana. ");
INSERT INTO bbb_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Ijiege rena Aburame fune urina ijia fijana una are Betuero nake ijia vae. Fu ijia fijana vakuma are Betuero gue re ro Ai gue rema ukua ije fu ude fata zinone ifaejedufuo fu ufema ijia kekei. Aburame fune ijia kekena uri fata ijia E Ireobo ijene baname isoekafae. ");
INSERT INTO bbb_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Ro e Roti fu duaku fuka mave kina kaukina goti uruvana sae ro kuke fuka e agane fuone ro e fuone imevo ije uruvana kaenamia vae. ");
INSERT INTO bbb_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ijadufuo are kafare e inokiro bu besu karinoedufuo ije fuka naebe mani. Bu besu karike mave-sifi kiro kau buone ije bu vajoma inoedufuo ije fu naebe moni ijadufuo maeje buka fanuve ma uruvana. ");
INSERT INTO bbb_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Ijadufuo mazani be e ije Rotido imevo ijiakiro Aburamedo ije bu bue madinami. (Ro mazani ije e Kenanaetiko ijiakiro e Ferizaetiko ije bu uria aesakae ijia kariva ijia bu ijiege rei.) ");
INSERT INTO bbb_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Areme Aburame fu urina Roti kuae, No nosiki nono agane ro e one imevo bu e none ijena madinamivo ije fuka naebe marei. ");
INSERT INTO bbb_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Ijadufuo roga no va nuvuone binobino karinoene. Ni koro are akare izia a oenoekiro vierafema ijia vakiro na akaegue vane. ");
INSERT INTO bbb_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Areme Roti fune uri manina are amare do Jodeni fu kana vakuma are Zoa ijia kekema ije rerei. Ro are amare ije fu do uruvana fuka E Ireobo ijare juare mema igeki ro kuke fuka aesakae Ijifiti vareki ijene gae. (Ro maza ije Godi fu are Sodomekiro Gomora fu naebe kena isekafiaema ijia fu ijiege rei.) ");
INSERT INTO bbb_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Ijadufuo Roti fune uri are Jodeni amare ijene abena ijia fijana una are mazani ajiamo nake ijiege vae. Ijadufuo e ino kajuki ije bu ijiege rena buone unianamina vae. ");
INSERT INTO bbb_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Ijiege rena Aburame fune are Kenani ijia finokoga e Roti fu urina Jodeni amare ije sidove mamekanu bu karinoeva kafare are Sodome uvuake ijia are muvuaka sana ijia finoe. ");
INSERT INTO bbb_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Ro e Sodomeko ije buka e omise bu E Ireobo fake ise uruvana revo. ");
INSERT INTO bbb_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ijiege rena Roti fune vakoga rade E Ireobo fu una Aburame kuae, Ije a fino ijia manina are irore boeje rerene. ");
INSERT INTO bbb_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Nare are ije a rerema ijene akiro uifari one ije miake. Are ije nane abe a maedo fune maza boeje one redufuo. ");
INSERT INTO bbb_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ro kuke na uifari one ma uruvana vajaga bu ajare ige e bu dadufuo baki igege reke. ");
INSERT INTO bbb_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ijadufuo ni va are foteke ije ganoene ijadufuo maeje sakae ije na abe a madufuo ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Ijadufuo Aburame fune are faraena biona ine akae Mamureno kuavo bu ireva are Eburoni guove ijia vae Fu va ijia fi areme uri fata be fu zinone ifaejadufuo ije sae. ");
INSERT INTO bbb_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","2","Maza ije Aburame fu are Eburoni fima ijia kini inokirokiro inokiro (4) bu urina kini umui fague (5) ijena bijae. Ro kini inokirokiro inokiro ijiebuo ive ijeja Kini Amarafero are Bebironiako ijiakina Kini Arioki are Erasako ijene. Ro Kini Kedorama are Eramiko ijiakina Kini Tidaro are Goemiko ije bu gue rei. Ro kini faeve (5) ije gue reva ijeja Kini Bera are Sodomeko ijiakina Kini Biasa are Gomorako ijiakina Kini Sina are Adimako ro Kini Simeba are Zeboimiko ro Kini are Berako ije bu gue rei. ");
INSERT INTO bbb_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Ijiege rena kini faeve ije bune are amare Sidimino kuavo ijia e buone bijaevo ijene kena besu afui. (Ro ive Sidimi ijadufuo maeje ijeja Davare Soruki). ");
INSERT INTO bbb_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Ijadufuo maeje juaevasia tuero (12) guove ije fu kini Kedoramare samuagiakoga bu rotire fuone ijia karinoe. Ro una juaevasia tetini (13) guove ijia bu fu ijuonena una fuina bijae. ");
INSERT INTO bbb_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","6","Bu ijiege re vakuma una juaevasia fotini (14) ijia kini boeje bune uri e bijaevo bune ije kaenamiana una Kini Kedoramana besu rei. Areme bune uri e Refaetiko aesakae Asiteroti Kaneme karijo ijiakina e Zusaetiko ije bu aesakae Emi karijo ijiakina e Emaetiko ije aesakae Save Kiriataemi karijo ijiakina e Oraetiko uruo Sia ivuake ijia karijo ije bure iraraena kaniae. Bu kaniana kame arafiria vakuma are Ero Farane ae sao ijie usiae. ");
INSERT INTO bbb_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Areme bune una kuderiana ro are Kedesi ijia usiaena e Amarekaetiko ijiebuo aesakae ije iraraena abei. Areme bu uri e Amoraetiko ije bu are Asesoni Tema ijia kariva ije kaniae. ");
INSERT INTO bbb_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Areme are Sodomekina Gomorakina Adimakina Zeboimikina Zoa ijiebuo kini ije bune e bijaevo buone ije kaenamiana are amare Sidimi ijia bijaekuae vae. Bu vakoga kini fo Kedoramakina Taedorokina Emiraferokina kini Arioki ije buina bijae. ");
INSERT INTO bbb_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Ro are amare ije fuka ire kazine bu kua ta ire tore igeki e kamakiamo ije fuka uruvana ijia. Ijadufuo are Sodomekiro Gomora ijiebuo kini ijiakiro e bijaevo buone buka giriesana subinae vakuae vakuva buka ta ijia urae. Bune ijia urana oekoga kini inokubeke bu e buone bijaevo ijena subinae nafare ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Bu subinae vakoga kini inokirokiro inokiro ije bune uri e Sodomekiro Gomorako ijiebuo sinuome ijiakina ire ivo buone boeje buka bune karijiana vae. ");
INSERT INTO bbb_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ro e Aburamedo kaju fuone e Roti fu Sodome ijia fino ijadufuo bu uri fu duaku mesiri areme uri sinuome fuone boeje buka karina vae. ");
INSERT INTO bbb_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Ijiege rekoga e be fu aza uve ijia kona Aburame fino ijia vae. Fu va ijia kekena ire boeje izege rema ijene Aburame e Iburuko ije kuarae. Ro Aburame fu Mamure e Amoraetiko ijiebuo ine sio ije ireva ivuake ijia fino. Ro e Mamurekina uviarafa fuone inokiro e Esikorokiro Ana bu una Aburamena besu rei. ");
INSERT INTO bbb_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ijadufuo e Aburame fu fieke kaju fuone e Roti bune tona mesiri vaeva fiena fune uri e bijaevo fuone ije are fuone ijia kariva ijene e tiri aderedi eitini (318) ijiege kaenamiana afui. Areme fune uri kini inokirokiro inokiro ije reriana arafiria vakuma are Dani ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Bu va Dani ijia usiaena fune uri e fuone ije kena atana binobino uniama areme bune mugu e ani ije arafirana kaniae. Bune ijiege kaniana kame arafiriana are Oba Damasikasi ikene ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Bu arafiria vakuma faradia areme uri Rotido sinuome boeje kini inokirokiro inokiro ije bu kariva ijene kamaziae. Areme Aburame fune kuke kaju fuone Roti mesiri areme sinuome fuone ijiakina bara bino ro e gue bu toenamiana kaenamia vako ijene kaenamiana una ruae. ");
INSERT INTO bbb_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ijiege rena Aburame fune kini Kedoramakiro kini gue ije iraraena kaniakuriamo bu subi vakoga fu una ruomo ijia fu are Sodomeko kini ije bie. Fu are amare bu kua Kinido Amareno kuavo ijia bie. ");
INSERT INTO bbb_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Ro kini Mekizideki fu are Seremiko ijiebuo kini ro kuke fu Godi ka E Daroki ijadufuo zinone ifaejemo. Ijadufuo fu keke Aburame biena uri do vaeni ijiakiro burete ije kena vajae. ");
INSERT INTO bbb_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Areme fu uri Aburame daro ma areme baname isoena kuae, Godi E Daroki aesakae igiakiro saove ije amaeriaema ije fu a daro makono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Ro e boeje buka Godi E Daroki ije fu a ifejana daro mamoga a iraraena e ani one ije kaniaema ijadufuo ive dabe aroekono kuae. Areme Aburame fune uri sinuome fu kena ruaema ijene bino (1/10) karina e Mekizideki vajae. ");
INSERT INTO bbb_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Ijiege rekoga rade e Sodomekobuo kini ije fu uri Aburame kuae, Sinuome boeje a kema ije fu one ijadufuo ni kekiro e boeje ni una ke uniaejieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","23","Fu ijiege kuaramoga Aburame fu una kua, Na E Ireobo Godi E Daroki ije aesakae igiakiro saove ije amaerima ijadufuo ive ijia kuarana kuaedo na ire one bino nabe kena vake. Na ijiege rekina rade abe noesina kuaeko Aburame fuka e sinuo baki ro na nare ifejavoga fu sinuome zaraemano kuaeke. ");
INSERT INTO bbb_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Aburame fu ijiege kuara areme kua, Na sinuome one nabe kekiro name irere e none imevo bu iva na ijiaru kedufuo. Ro e ije naena reva e Anakina Esikorokina Mamure ije ni arega bu sinuome irere bino bu bue kekuae vierafeva ijene kena vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Areme rade e Aburame fu nimamaena fieke E Ireobo fu kumei, Nare ire afiki bino bu one vuakuvejo ijia samuagakinu ro nare ire mamekanu bino kena a vajakuvejo ijadufuo ade jumemono kumei. ");
INSERT INTO bbb_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Fu ijiege kuaramoga Aburame fu una kuae, E Ireobo none iviama nana ame baki. Ro a ame be naebe miemo ije erare ire ije a vajiekuveno ije kena samuagiake? Ijadufuo iviama na Erisa e Damasikasiko fu noefuo moni baki imeno na ije kuaga fure sinuome none boeje kena samuagiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Fu ijiege kuaramoga E Ireobo fu una Aburame kuae, Na vierafe e Eriesa fube sinuome one ije kedufuo. Ro funeka ame ma one ijare sinuome one ije samuagiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Areme E Ireobo fune Aburame mesiri ae makave ijia kekena kuae, Ni kakena saove gafia ire zuvi ije ireva giakinu mimatana da giane. Ire zuvi ije bu zaraeva ijiegero uifari one buka ijiege zaraekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","E Ireobo fu ijiege Aburame kuaramoga fu vua ije abe ma vierafei. Ijadufuo E Ireobo fu ijene gana oemarema ijadufuo fu kua, Ane maturaemano kuana mesirimo fu kai fuone rei. ");
INSERT INTO bbb_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Areme E Ireobo fune uri ijiege kuae, Naeje na E Ireobo nare a are Eri aesakae Bebironi guove ijia mesirana igia sakae igene abena maga fu one rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Rove Aburame fu una kuae, E Ireobo ire boeje samuagiamo na izege gana vierafero ae sakae ige fu ma nonero na ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Fu ijiege kuaramoga E Ireobo fu kuae, Ni va fanuve mave-kau be ro goti be ro fanuve mave-sifi be ijene kaniana ke rone. Ro fanu ijeja bu juaevasia inokubeke furiva ijene kaniane. Ro kuke ni ume tuvuaeki be ro ume fisino kuavo ije be ijiege kena rono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Areme Aburame fune va kekena fanuve ije kaniana ke ukua ijia ufusena kari Godido ruae. Areme fune uri fanuve ije karina inokiro nae. Areme fune uri ume inokiro ijene kena fotikuma ado ijia nae. ");
INSERT INTO bbb_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Fu ijiege rekoga ume buruome ijiebe arina fanuve ije ikuae rovoga Aburame fu uri kaniakuriamo bu vae. ");
INSERT INTO bbb_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Areme ve fune titutekuveno ijia Aburame fu ni ireobo nae. Fu ni naena uri gake fune ka ve ireobo titutemoga fuka ireobo jumei. ");
INSERT INTO bbb_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Fu ijege remoga E Ireobo fu kuae, Aburame ni mukoreigia vierafene uifari one ije bu e aebeko igege ebuo sakae ijia juaevasia fo aderedi (400) ijiege bu moni baki imekinu isejavaeke. ");
INSERT INTO bbb_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Rove nare e aesakae ijia karina e none kiaga bu buefuo moni baki imevo ije kame isekafiake. Ro e none bu aesakae ije arena una usiae ruakuva bu ka sinuome uruvana karina ruadufuo. ");
INSERT INTO bbb_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ro aeje a juaevasia ireobo fivakuma tuvuae bija areme a sone oemarekinu baronega bu abe mako ruke. ");
INSERT INTO bbb_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Ro uifari one ije bu e binobuo aesakae ijia karivakuma e uifari one bune inokirokiro inokiro ijiege vako ijia bu sone una sakae igia ruake. Ro e Amoraetiko ije na samuake bu ise ma uruvana rekuva na ijia sone kena isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Areme maza fune kona ve titutemo ijia fu gake ire be sukore miane naeno igeki ijare fanuve ado ijia romo fu gae. Ro kuke fuka ire ikuo sae igeki ijare fanuve ije fu buvuana naema ije kafare ijia ruvako fu gae. ");
INSERT INTO bbb_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Areme maza ijia E Ireobo fune Aburameki vua be kuaena marei. E Ireobo fu kuae, Nare kuaedo na are ije gamia Ijifiti ijia ruoma are do Iufureti fu kana vaema ije na abena uifari one ije miake. ");
INSERT INTO bbb_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Ro kuke na aesakae ige e Kenanaetikobuo ijiakina e Kenizaetikobuo ijiakina e Kedimonaetikobuo ijene kena bu vajiake. Ro kuke na aesakae e Itaetiko ro e Ferizaetiko ro e Refaetiko ro e Amoraetiko ro e Kenanaetiko ijiebuo ije kena una uifari one ije vajiake. Ro kuke na aesakae e Gegazaetiko ijiakina e Jebusaetiko ijiebuo boeje foteke kena uifari one ijia vajiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Ijiege rei ro bara Sera e Aburamedo bara ije ame bino naebe tuanae. Rove fu Ega bara Ijifitiko be fu fuefuo moni baki imeno. ");
INSERT INTO bbb_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Ijadufuo Sera fu uri Aburame kuae, Naeje fune E Ireobo ijare naebe ifejiena ma rejiema ijadufuo na ame bino naebe tuanae. Ijadufuo na vierafe a bara gare fu noefuo imeno ijiaki naekuma fute ame bino nafe vajiega na samuagiakono kuae. Sera fu ijiege kuaramoga Aburame fu vierafega fu ma kuaramoga fune oemarei. ");
INSERT INTO bbb_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Ijadufuo Sera fune uri Ega kuamoga fu Aburameki naenoe. (Ro ije fu rema ije Aburame fu Kenane ijia finoena juaevasia teni furikoga fu ijierei). ");
INSERT INTO bbb_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","5","Ijiege rena Aburame fune bara Egaki naenoga fu e fudie. Areme Ega fu gake fune e fudiemaga fuka aroekarana una Sera oe isema vierafei. Ijadufuo Sera fu uri Aburame kuae, Aka isema rema ijadufuo Ega fuka na oe isema vierafe. Fuje na nare kuavoga a fuosiki nae rove iviama fune gaga fuka e fudiema ijadufuo fu una oe isema na vierafeme. Ro ise ije na nare rei ro are rekuma ije fune E Ireobo ijare guona vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Sera fu ijiege kuaramoga Aburame fu kuae, Daro ije fu one ro fuje fume rotire one ijia oefuo imeno. Ijadufuo ni izege a vierafema ijia reno kuae. Ijadufuo bara Sera fune uri Ega vame omise ijia ziegafana remoga fune uri kona vae. ");
INSERT INTO bbb_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","8","Bara Ega fune kona vakuma are sao ijia do be sakae tire ijia ajiamo ivuake ijia fine. Ro do ije fu vame ije bu are Sua ijia vako ivuake ijia. Fu ijia finoga E Ireobo ijadufuo anera fu arina ijia bie. Fu biena kuae, Bara gure Serado imeno gure a bara izeko? A izia vakiro ruomono kuae. Fu ijiege kuaramoga fu una kuae, Na bara ije fu na samuagiemo ije gana kona ruovono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","10","Ega fu ijiege kuaramoga anera fu kuae, Ade kona vakiro bano ni una va fuefuo imene. Ro aeje nare ifejana daro maga uifari one ije buka ma uruvana e bu dadufuo baki ijiege reke. ");
INSERT INTO bbb_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ro kuke aeje a ame fari be bietena ive fuone ije a Isimaero kuake. Ijadufuo maeje ige a oefiane abena nimeno ije E Ireobo fune fie. ");
INSERT INTO bbb_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ro fari one Isimaero fuka mave kuriae ijiege renoega e uruvana buka fuina zienamike. Fu ijiege rena fuka agane fuone ije arena va fuebe finoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Areme bara Ega fune uri fue kuae, Naneka ma Godi gae rove na naebe barone na uria igifure fivono kuae. Fu ijiege kuaena uri E Ireobo ije fu vua kuaraema ije fu kua, Godi ije fu fina giemo ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Bu ijadufuo e ije bu do ije are Kedesikiro Bereti ukua ijia mako bu do jiavo ije bu kua Do Ije E Ije Maza Boeje Ijia Fina Vako Ije Fu Giamo Ijeno kuavo. ");
INSERT INTO bbb_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","16","Ijiege rena bara Ega fune Aburamedo ame fari be bietena abe ive ina Isimaero kuae. Ro maza ije Aburame fu juaevasia eti sigisi (86) ijiege furima ijia fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Areme maza ije Aburame fu juaevasia fu bieteva ije fune naeniti naeni (99) ijiege furikoga ijia E Ireobo fu arina fuone ruae. Fu arina kuae, Naeje na Godi ka e daroki ijene. Ijadufuo ni vua irere ige na kuaravo ije maza boeje fiena iriniakinu vame ma ijiaru kenoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Na osiki vua kuaena marekina rade na ifejana daro maga uifari one ije buka ma uruvana rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","4","Areme Aburame fu vua ije fiemo fuka ma ireobo oeserei ijadufuo fu uri Godi aroena tuana nikubae fuone ijia dijei. Fu ijia dijemoga Godi fu kua, Ivia na osiki vua ige kuaena abe mareke. Nare kuaedo a e uruvana aesakae binobino ijia kariva ijiebuo asae reke. ");
INSERT INTO bbb_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ro iviama ive one Aburame ro rade ive one ije bu kua Eburameno kuake. Ijadufuo maeje nare ifejana daro maga a e boeje aesakae binobino ijia kariva ijiebuo asae buone reke. ");
INSERT INTO bbb_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ro nare uifari one ma uruvana vajaga gue bu kini rekiro gue buka e uruvana rena urina aesakae binobino ijia karinoedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","8","Na akina uifari one ije rade ruovo ijena vua ige na rekiro kuaena abe mareva ije nabe toteke. Ro vua ije fume uria ijia na vadufuo. Ro kuke na akina uifari one ije bu rade ruovo ijiebuo Godi redufuo. Nare aesakae ige Keneni a e aebeko igege ro fino ije abena akina uifari one ije foteke miaga bu buone abena maza boeje ijia karivake na Godi buone rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Areme Godi fu una kuke Eburame kuarana kuae, Na vierafe adua uifari one ije bu rade urivo ijena janika vua irere na ude jaena kuaena mareva ije maza boeje vierafena renoefo. ");
INSERT INTO bbb_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Anika uifari one ijena ame fari boeje ja nafevo ije ka kena vajae suri kania ufuna nuga nafo. ");
INSERT INTO bbb_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","13","Ijadufuo iviama igia una gafege vako ijia ja ame fari nafega bu mu eiti (8) ijiege furivo ije nika kena vajae suri kania ufu nuga naejiafo. Ro kuke e one moni baki imevo ijiebuo farirafa ije bu gire jone ijia nafevo ijiakina e aebinoko ja fuaevena kaenamiaeva bu are jone ijia karivo ije e fari ije nika vajae suri buone kania ufuna nuga naejiafo. A ijiege rekina e boeje bu ijia giana vierafero vua na osiki kuaena mareva ije fu maza boeje ijiege namoro bu ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Ro e fari eranebe bu naebe vajae suri buone kania ufuvo e ije bu e none baki. Ijadufuo maeje bu vua irere na jaena kuaena mareva ije bu naebe iriniena ijia renoevono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Areme Godi fu una Eburame kuae, Ivia igia una gafege vako ijia bara one ijadufuo ive ije a naebe una Sarae kuake. Ro ive fuone ije a Sera kuake. ");
INSERT INTO bbb_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ijadufuo maeje nare ifejana daro maga fu ame fari be bieteke. Ro nare daro maga fu e aesakae binobino ijia karivo ijiebuo asie redufuo. Ro kuke nare ifejaga uifari fuone ijiebuo uve ijia e gue bu uri kini rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Godi fu ijiege kuaramoga Eburame fu vua ije fiemo fuka ireobo oeseremo fu tuana ume ijia dije. Fu ume ijia nana kikinu fue kuaemo, Eove fu juaevasia uvani aderedi (100) furima ije fu izege ame nafedufuo? Ro kuke Sera fune ma barasire ro juaevasia fuone ije fune naeniti (90) furima ije fu izege ame nafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Areme fune uri Godi kuae, A vierafe fube maredo fari none Isimaero fu sinuome none boeje kena samuakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Rove Godi fu una kuae, Nana ijiege rekuva baki. Ro na vierafe naka bara one Sera ifejaga fu ame fari be oefuo bietega ive fuone ije a Aeseki kuake. A ijiege rekina vua irere na kuaena mareva ije fu uria uifari fuone ijena ijia navake. ");
INSERT INTO bbb_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Ro una Isimaerodo a kuariema ije nane fie. Ijadufuo fuje na daro maga fu ame uruvana tuanaga uifari fuone ije buka ma uruvana reke. Ro nare ifejana daro maga fu ame ifiki tuero (12) ijiebuo asoe reke. Ro nare ifejaga uifari fuone buka ma uruvana rega bu aesakae binobino ijia karinoedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ro Sera fu iviane ame fari one e Aeseki nafega na irere na Aesekido rekiro kuaeva ije na ifejaga fu rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Godi fu vua ijiege Eburame kuarama furi areme fune ijia nujana vae. ");
INSERT INTO bbb_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Fu vakoga mazani besu ijia Eburame fu Godi irinana uri fari fuone Isimaero ijiakina ame fari boeje gire fuone ijia kariva ijene vajae surive buone kania ufuna nuga naejiae. Ro ame fari ije gue bu e ije bu fuefuo moni baki imevo ijiebuo anafa bu gire fuone ijia nafeva ijene. Ro e gue fu ae bino ijia fuaevema bu fuefuo imevo ijene kena vajae surive buone kania ufuna nuga naejiae. ");
INSERT INTO bbb_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","26","Ro Eburame bu bieteva juaevasia ije fune naeniti naeni (99) ijiege furi ro Isimaero fu tetini (13) ijiege furikoga bu mazani besu ijia vajae surive buone kania ufuna nuga nijae. ");
INSERT INTO bbb_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Ijadufuo e fari boeje bu Eburamedo gire ijia karijo ije bune vajae surive buone kania ufuna nuga naejiae. ");
INSERT INTO bbb_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Areme E Ireobo fune ine akae are Mamure ireva ijia Eburame bie. Ro maza ije fu uvuoka manina fuka fete uruime. Ijadufuo Eburame fu are muvuaka fu fanu surive ijia saema viene ijia fine. ");
INSERT INTO bbb_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","3","Fu ijia fine giake e inokubeke bu makave gafia ireva fu giae. Ijadufuo funeka migegire kekena biediakiro difurina vae. Fune vakuma bu ireva ijia auge sana kurituana sakae ijia bija areme kiae, E kusesie jade asidiena vako. Ijadufuo maeje nanaka ja ifejiakiro vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Ijadufuo ni ine zinume igia karike na do jiajia roga ja dia jone kuokuo ijene sofo. Jaka na aguariena are none igia ruae ijadufuo naka ifejiakiro vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Na ire bino vajiaga ja i fu deufiaga ja daro abena vano kiae. Eburame fu ijiege kuariamoga bune oemarena kua, Ije fune maredo no ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Areme Eburame fune migegire va are gafia kekena uri bara fuone Sera kuae, Iviama migegire uri farava one maeje a nijaema ijene abena bino ifaejeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Areme fune difuri are fu mave samuagiamo ijia kekena mave-kau saruegi iviama ubaeremo ijene be fare. Areme fune abena e fuone imeno ije mana kuamo fune migegire abe kana buvuana kirakiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Ijiege rena Eburame fune uri muijekina fanu ije korufuo kena va e ijene ine zinume ijia gorumiavo bu i. ");
INSERT INTO bbb_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Areme bune urina kuae, Ro bara one Sera fu iziebureno kuae? Bu ijiege kuavoga fu kiae, Fu gafe are muvuaka gari fino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Fu ijiege kuariamoga e be fu urina kuae, Na vaekina asame naeni (9) furiga na una ruakuva bara one Sera fu ame be bietekono kuae. Fu ijiege kuarako Sera fu viene ivuake ijia fido fu vua ije bu kuaevo ije fie. ");
INSERT INTO bbb_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Eburamekiro bara fuone Sera buneka ma eoradiae ro kuke Sera fu fue fino ije fune arei. ");
INSERT INTO bbb_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Ijadufuo fu mauike fue kikinu kuae, Naeje naneka mukoreigia barasirenamie. Ro na baru none ijiaki naedufuo ije na fuka naebe manino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Areme E Ireobo fune urina Eburame kuae, Sera fu irerefuo kikinu kuae nane barasirenamiedo na izege ame bietekuva bano kuaeme? ");
INSERT INTO bbb_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","A vierafe E Ireobo fuka naebe manido fu ire bino redufuo? E ije fu ijiege kuarama areme fu urina Eburame kuae, Asame naeni ijiege furiga na una ruovo ijia bara one fu ame fari bietekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Ro Sera fu kima ije fu kuariakuma fuka jumema ijadufuo fu fena kia, Na naebe kivano kuae. Ro E Ireobo fu urina kuae, Ane ma kimo na gaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Ijiege rena e inokubeke ije bune are be bu irena nese Sodome rerevo ijia vakuae vae. Bune vakoga Eburame fu nuvedia vame unia bu vakega fu una ruakiro fune buina vae. ");
INSERT INTO bbb_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Areme E Ireobo fu una fue kuae, Na ire bino rekiro vierafekuva nabe Eburame ni sauikurake. Ro naka ude nijae fu vierafeke na rade sone ire bino reke. ");
INSERT INTO bbb_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Ro rade uifari fuone ije buka e anuigi ro kuke buka e daroki reke. Ro kuke na duvado fuone ijia aesakae boeje marejiana daro miake. ");
INSERT INTO bbb_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Nare fu abeva ijadufuo fure rade anafa ro uifari fuone ijene kuriaerena kuariaga bu na irinieke. Bu na iriniena ire ma ijiaru rekinu vame ma ijia kenoeke. E boeje bu ijiege renoekuva naka ire boeje na fuefuo rekiro kuaeva ijene rejakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Areme E Ireobo fu Eburame kuae, E Sodomekiro Gomorako ise bu revo ije bu kuavo ije na fiega fuka ma omise ro kuke fuka ma ireobo reme. ");
INSERT INTO bbb_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ijadufuo naka arina va ise buone e bu buesina kuaega na fievo ije giaga fu kufui ro maga na giakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Areme e inokiro ije bu ijia Eburame nujana bune Sodome nake vakoga E Ireobo fu una Eburameki fi. ");
INSERT INTO bbb_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Ijiege rena Eburame fune E Ireobo kuae, A e ije bu ire ise reva ije ane kaniakuvene. Ro a vierafe fune maredo a e masoki ijiakuma kaniake? ");
INSERT INTO bbb_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Ro a vierafe e masoki fifiti (50) ijiege bu sidove ijia karikuva abe uria e foteke ijene kaniake? Ro a uria kafiamo ijadufuo e fifiti masoki ije ijia kariva ije a uria karauniake? ");
INSERT INTO bbb_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ro na ma vierafega e ise revo ije a kaniakuveno ije abe e masoki ijiakuma kaniake. A ijiege rekuma ije fuka naebe maredufuo. Ro a e ume igeko ijiebuo ise ije a kena mazie giamo ije na vierafe aka mukoreigia vame ma ijia mazie giano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Eburame fu E Ireobo ijiege kuaramoga fu una kuae, Na e masoki fifiti bu Sodome guove ijia karikuva e ijiakiro sidove ije nabe abe isekafake. ");
INSERT INTO bbb_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Rove Eburame fuka una kuae, Nanaka ema ro na vua ijiege a kuaradufuo ije naka daro baki. Ijadufuo a isekie ige na una kuke giriesana kuarakuvejo ije nime giena areke na kuarane. ");
INSERT INTO bbb_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Ro a vierafe e masoki ije bume e sibaneke fotifaeve (45) ijiege sidove ijia karikuva abe uria sidove ijene abe kafakono kuae? Ro E Ireobo fu una kuae, Bu e sibaneke fotifaeve ijiege ijia karikuva na vierafe nabe sidove ijene abe isekafakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Fu ijiege kuaramoga Eburame fuka una kuke kuae, Ro bu e sibaneke foti (40) ijiege karikuva a izege rekono kuae? Ro E Ireobo fu una kuae, Bu e sibane foti ijiege karikuva ije dua nabe sidove ijene abe arafiriakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Fu ijiege kuaramoga Eburame fuka una kuae, E Ireobo ade na ziegafiemo. Ni areke naka una kuke kuarane. A vierafe bu e sibaneke teti (30) ijiege ijia karikuva ije a izege rekono kuae. Ro E Ireobo fu una kuae, Ije dua na vierafe nabe kena isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Ro Eburame fu una kuke kuae, A isekie naka uria giriesa ijia kuarakuvejone ni giena areke na kuarane. A vierafe bu e tuaedi (20) ijiege karikuva a izege rekono kuae? Ro E Ireobo fu kuae, Bu e tuaedi sidove ijia karikuva ije dua nabe abe isekafakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Ro Eburame fu una kuke kuae, E Ireobo a isekie na vua rane igiaru kuarakiro vierafe ijadufuo ade na ziegafiemo. A vierafe bu e sibaneke umui gue gue (10) ijiege karikuva abe uria sidove ijene abe isekafakono kuae? Fu ijiege kuaramoga E Ireobo fu una kuae, Bu e umui gue gue ijiege ijia karikuva sidove foteke ijie nabe abe isekafakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","E Ireobo fu vua ijiege una Eburameki kuaema furi areme fune ijia nujana vae. Fu vakoga Eburame fune gue una are vae. ");
INSERT INTO bbb_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","2","Mazani ije E Ireobo ijadufuo anera inokiro bu sidove Sodome ruaeva ije mufuo besu ijia e Roti fu sidove ijadufuo isuo bu kirakuraeva ijadufuo viene ije e bu ro ijia koto revo ijia fine. Roti fu ijia fino bu rovo fune giana ka migegire urina biediakiro vae. Fu va bu ireva ijia auge sana kuri tuakafiana kiae, Ekisesie, naka ja ifejiakiro vierafei. Ijadufuo jabe ro gire none gafia dia jone sonaro muge igiaru naena naoekiro suoke mu gamia nine izege ja vakuae ruovo ijia vano kiae. Rove anera ije bu una kuae, Nobe aena vakiro no vierafe no sidove guove igia naokono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Bu ijiege kuaravoga Roti fuka faememarena soesoemoga anera ije bune fuina gire fuone ijia vae. Areme Roti fune kekena e fuone imevo ijene kiamoga bune migegireigia uri burete ire isiti usiaeva baki ije ifaejekinu ire ka mukore ije amaerima vajiavoga bu i. ");
INSERT INTO bbb_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","5","Areme bune ni naokuvejo ijia e Sodomeko e fari boeje mumokana ro e baraki ije bu biona ijia ruae. Bu usiae Rotido are ije ninukurana uri kumei, E ije bu a gakuae ruaeva ije bu iziebureki? A iviama e ijene kiaga bu usiae roga no giane. E fari Sodomeko ige buka buina fudaenamina ise rekuae vierafevano kumei. ");
INSERT INTO bbb_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","7","Bu ijiege kumevoga Roti fu fiena keke makave ijia manigana viene dabe bijukuriae. Areme fu kiae, E gurie, kairafano ja isekie vame ije ja rekuae vierafeva ije fuka ma omiseno arefo. ");
INSERT INTO bbb_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Igia fie, kabaerafa none inokiro kabaekua ije bu gufifureki. Ijadufuo na kia bu usiae roga ni kaenamia va buina irere ja vierafeva ijene refo. Ro e ige naena kariva ije bu na giekuae ruae ijadufuo na vierafe naka bu mukoreigia samuagiakono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Roti fu ijiege kuariamoga buka ziena kumei, E gare aebeko gare iviama vua ije a kuaemo ije arena garege vane. Aeje a era vareki a vua irere no kuaruokuvene? Vua a kuaemo ije ijia irine ro bakuma aeje no dabe vame ma ise ijia rekono kume. Bu ijiege kuarakinu bune ajia Roti vaja dabe garege akoena bune viene kania tuakuae arafiri. ");
INSERT INTO bbb_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Rove anera inokiro guove ije kariva ijiebe urina Roti fare dabe una guove ijia nuja areme uri viene dabe kanae. ");
INSERT INTO bbb_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Bu ijiege re areme uri e boeje makave ijia ireva ijene ni buone kame kuzejiae ijadufuo bu izege ni nafaena viene daovekuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Areme anera inokiro ije bu uri Roti kuae, A anafa one gue ro sibarafa ro uviarafa gue bube sidove igia kari? A e one gue bu igia karivoga no vierafe aka migegire kaenamiana sidove ige arena keke vadufuo. ");
INSERT INTO bbb_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Ijadufuo maeje no sidove ige abe isekafakuae vierafe. E Ireobo fu e igiebe ire ise ka ma omise ijene reko fu giaga fuka iseme ijadufuo fu kuoga no are ige Sodome abe isekafakuae ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Anera bu ijiege Roti kuaravoga fune va e fari inokiro ije bu kabaerafa fuone kekuae revo ijene kiae, Iviama migegire roga no usiae subinae vafo. Ijadufuo maeje E Ireobo fu are ige dabe isekafakuveno kiae. Roti fu ijiege kuariamoga e fari ije bu vierafe ro fu kufuimena varaemenoro bu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Areme suoke ve iko abaesamo ijia anera bu vierafe Roti fuka migegire keke kona vakiro bu uri Roti kuae, Migegire bara one ijiakiro kabaerafa one inokiro ijene kaenamiana are ige arena keke vane. Anika keke kona vaekina sidove ige fu isejavaemo ije adua a naebe ijia baronenono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Bu ijiege kuaravoga e Roti fuka uri ireobo totenami. Rove E Ireobo fu Roti gamo fuka oefiae. Ijadufuo anera fuone ije bu uri Rotikiro bara fuone ro kabaerafa inokiro ije umui karana sidove ije arena usiae. ");
INSERT INTO bbb_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Areme anera be fu uri Roti kuae, Ige a vako ije ade va amare ivuake gafiebure fino. Ro kuke ade una dakude manina igia rerekiro anika vajae one ijadufuo kona uruo gafia vaekina a naebe baroneno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Rove Roti fu una kuae, Ja isekie jade no ijiege revo. Ja na ireobo vierafeva ijadufuo janeka mukoreigia na marejiena kenujie. Ro uruo gafe fuka uria mumabo ijadufuo na vakuva na migegire gafia kekekuva baki. Na vierafe na uria vame vako ijia irufui fu biediekuma nane baroneke. ");
INSERT INTO bbb_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Ro are iseke gare gafo are ije fuka ivuake garifureki. Ijadufuo ja isekie ni arega na ijia vaekina ise ije fube na kaniega na baroneno kiae. Ro are iseke ije bu kua Zoano kuavo ijadufuo maeje fuka are isekube. ");
INSERT INTO bbb_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","22","Ro anera ije fu una kuae, Ije fune maredo na are iseke ije a kiema ije nabe abe isekafake. Ijadufuo ni migegire keke kona vane ijadufuo maeje a uria igia fikuma nabe are ige abe isekafake. Ro na vierafe na samuake ane va gafia kekega na sone are ige isekafakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Areme mazani fune ajia ruomo ijia e Roti fune kona vakuma Zoa are iseke ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Fune iko ijia kekekoga sarorubaigia miane sarufa ijare saove ijia ve igege dana sidove Sodomekiro Gomora ijia ari. ");
INSERT INTO bbb_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Miane ije fu arina sidove inokiro ijiakiro are boeje amare ijia kariva ijene arafiriae. Miane ijare arina are amare ijia e boeje karinoeva ijene sakiamo bu oe furi. Ijiege rekoga ire uije boeje binobino bu juare ijia ovo ije funeka miane ijare naena arafiriama furi. ");
INSERT INTO bbb_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Ro Rotido bara ije fu kona vako ijia fu una ire ijene gakiro dakudekuma fune ijia baronena mune rei. ");
INSERT INTO bbb_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Areme nituame suoke Eburame fune vakuma gafe E Ireobo fu biema ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Fu ijia kekena nese Sodomekiro Gomora bu kariva ijiakina are amare ije gake fune miane ijare udabeme. Miane u ije fu izege bu ire izui ifaejega fu umo ijiege fuka ireobo umo. ");
INSERT INTO bbb_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Ro maza ije E Ireobo fu are amare Roti fu fino ijene kena isekafiaema ijia Eburame fu naebe totei. Ijadufuo Godi fu kaju fuone Roti kuamo fu keke kona vae. ");
INSERT INTO bbb_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ijiege rena e Roti fu are Zoa ijia fikiro fuka jumei. Ijadufuo fune kabaerafa inokiro ije kaenamiana uri uruo gafia ajia vae. ");
INSERT INTO bbb_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Areme maza be kabae amure ijare una iviene ije kuae, Asoe nuvuone ije fune eoreme. Ro aesakae irore igia e fari ije buka baki ijadufuo fu erare no sanamuoga no ame tuanakuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ijadufuo roga no ire vaeni kugi be amaerina asoe nuvuone maga fu ine. Fu ina nigofo iserega no muge fuina naokina no e fudiena ame tuanano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Areme bune muge do kugi amaerina mavoga fu abena i. Fu vaeni ijene abe ina arekoga kabae fuone amure fu urina asoe fuone ijiaki nae. Ro asoe fuone fuka nigofo iserema ijadufuo vame ijiege bu revo ije fuka naebe mukoe giana vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Ijiege rena nituame kabae amure ije fune una iviene fuone ije kuae, Na muge nane fuosiki nae. Ijadufuo ni roga no kuke ivia muge do kugi be amaeri maga fu ina nigofo iserene. Fu ijiege rega ni ase muge fuosiki naene. No ijiege rekina no nosiki noka asoe nuvuone ijadufuo ame fudiena nafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ijadufuo muge ijia bune do vaeni jiana asoe buone vajavo fu ina nigofo iserei. Areme kabae iviene fune uri asoe fuone ijiaki nae. Ro asoe fuone ije fu kuke do ina nigofo iserema ijadufuo ire ije bu revo ije fu naebe giana vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Ijadufuo Rotido kabaerafa inokiro bu vame ijiege rena asoe buone ijadufuo e fudie. ");
INSERT INTO bbb_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Areme kabae amure ije fu uri ame fari be bietena abe ive ina e Moabi kuae. Ijadufuo e ije bu e Moabaetiko ije iviama kariva ijiebuo asae. ");
INSERT INTO bbb_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Ro kabae iviene ije fu dua fu ame fari be bietena abe ive ina e Benami kuae. Ijadufuo e ije fu e Amonaetiko ije iviama kariva ijiebuo asae. ");
INSERT INTO bbb_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","2","Ijiege rena Eburame fune are Mamure ijia fijana una Kenani ikene ijia are Kedesikiro Sua ukua are Gera ijia fijana vae. Fu are Gera ijia maza aokube finoena areme rade e Gerako bu bara fuone Serado kuavo fu kia, Fu maki noneno kiae. Ijadufuo kini Abimereki are Gera samuamo ije fu fiena uri kiamoga bu Sera mesirina fuone vae. ");
INSERT INTO bbb_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Ro muge be Godi fu Abimereki naka urana kuae, Aka ise rema ijadufuo a baroneke. Ijadufuo maeje a bara baruki ije abemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Rove kini Abimereki fu naebe Seraki nae. Ijadufuo fu uri Godi kua, Na bara ijiaki na naebe nae ro kuke fu fake ise be na naebe rei. Ro a vierafe fune maredo a e none igena no a kame isekafuoke? ");
INSERT INTO bbb_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Ro ije fune Eburamere korufuo kuae, Bara ije fu maki noneno kuae. Ro kuke bara ige fudua fu kuo, Eburame fu maki noneno kuae. Ijadufuo irere na reva ije nane mukoreigia vierafena rei ro na naebe isema revano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Fu ijiege kuaramoga Godi fu una kuke naka ijia Abimereki kuae, Ije fune mare. A naebe isema rei ijadufuo maeje nare vame a ise redufuo ije bijukuraejae ro kuke nare bara ijadufuo vajae ije a niriaedufuo ije bijukuraevoga a naebe vajae fuone niriae. ");
INSERT INTO bbb_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ijadufuo ni iviama bara ije kuaga fu una baru fuone ijadufuo vane. Baru fuone fu e be fu Godido vua vierafemono kuae. Ijadufuo a kuarakuma fure oefuo baname isoega irere a rema ije abe baroneke. Ro bara ije a naebe abe una nujajakuma na igifureki jukuarado a ro e one ijena jaka oekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Godi fu naka ijia ijiege kuaramoga kini Abimereki fu suoke mugamia urina e fuone mamekanu ije kumeno bu ijia afui. Bu afuivoga fu vua irere fu muge naka ijia naema ijene kuariamoga buka ireobo jumei. ");
INSERT INTO bbb_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","10","Areme Abimereki fune Eburamedo kiamo bu mesiri rovoga fu kuae, Vame ije a irere ije rei? No afine irere ije e one ijena jone reva ijadufuo a e none igena nuvuone ise rejuokiro vierafe? Ro a irerefuo na ijiege remano kuae? ");
INSERT INTO bbb_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Kini Abimereki fu ijiege kuaramoga Eburame fu kua, Na vierafero e bino are igia kariva buka Godi jumevo bakiro na ijiege vierafei. Na vierafero na kiako fu bara noneno kiakuva e bute na kaniena bara none abekiro na ijadufuo ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Ro Sera fune ma maki none ijadufuo maeje fu asoe none ijadufuo kabae. Rove asie nuvuone bu binobino ijadufuo na ijene abei. ");
INSERT INTO bbb_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ijadufuo mazani ije Godi fu kiemo na asoe none ijadufuo are ije arena aesakae binobino ijia na fija ruaeva ijia fu nane ijiege kuarae, Ane ma na oetuakuma ebe fu noefuo kuakuma ni kuako fu maki noneno kuano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Eburame fu ijiege kuaramoga kini Abimereki fu ijia uri Sera mesiri una Eburame nujajae. Areme fune kuke uri mave sifikina mave-kaukina e moni baki imenoejo ije gue kena Eburame vajae. ");
INSERT INTO bbb_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Areme fune uri Eburame kuae, Aesakae foteke ije fune none. Ijadufuo ni koro a izia fikiro vierafekuma ni va ijia fino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Areme fu una Sera kuae, Maki one ije na ire siriva ma uruvana (1000) ije vajake ijadufuo maeje noka one isema rei. Ro kuke no ijiege vajaga e boeje bu vierafero aja isema rema bakiro bu ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Ro Kini Abimereki fune vame ise ije Serado rei ijadufuo E Ireobo fune kini ijadufuo bara ro e fuone imejo ijiebuo bara ije bijukuriamoga bu naebe una ame tuanae. Ijadufuo Eburame fune una Kini Abimerekikiro e fuone boeje ijiebuo baname isoe. Fu baname isoekina Godi fu una Abimereki ifejaga irufui ijia namo ije fu una bakireke kinido bara ijiakina e fuone imevo ijiebuo bara ije bu una ame tuanadufuo. ");
INSERT INTO bbb_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","3","Ijiege rena Eburame fune eorema ijia E Ireobo fune izege fu kuaema ijiege rena Sera daro mamoga fu e fudiena ame fari be bietei. Ro Sera ame ije fu bietema ije fune maza ije Godi fu kuaema ijia bietei. Areme Eburame fu ame ije abe ive ina Aeseki kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","5","Ro maza ije Aeseki bu bieteva ije Eburamedo juaevasia ije fune uvani aderedi (100) ijiege furi. Ijadufuo fune mu eiti (8) ijiege furikoga Eburame fune izege Godi fu kuaraema ijiege rena uri ame ijene abe surive kanaufuijae. ");
INSERT INTO bbb_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Ro Sera fu kuae, Godi fu na ifejiema ijadufuo naka oemareve. Ijadufuo e uruvana bu fiega nane barasire rove na una ame bieteva bu ije fiekuva buka naena kikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Areme Sera fu kuke kuae, No Eburameki none eoradue rove na uria ame fari bietena abe muije vajavo ijadufuo e bu ije fiekuva buka oeseradiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Areme ame ije fune ubaerena mui atomoga Eburame fu fuefuo iro ma ireobo be i. ");
INSERT INTO bbb_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Areme maza be Sera fu fina gake Ega bara Ijifitiko ijadufuo fari e Isimaero fu uri Aeseki dabe varaemekinu kisamoga Sera fu urina Eburame kuae, Ni bara Ega nuvuefuo imeno ijiakiro fari fuone ije kiaga bu vane. Na bara ijadufuo fari ije fu ire one boeje Aeseki fu kedufuo ije gue kedufuo ije naka isediemono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Rove e Isimaero fudua fu Eburamedo fari ijadufuo Sera fu vua ije Eburame kuaramoga fu fiemo fuka ireobo oefiae. ");
INSERT INTO bbb_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Rove Godi fu una Eburame kuae, Ade fari one Isimaerokiro bara Ega ije ireobo vierafekiro nime irere Sera fu kuamo ijiege rene. Ijadufuo maeje na Aesekido duvado ijia uifari one na vajako kuaeva ijene vajake. ");
INSERT INTO bbb_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ro Ega bara ije joefuo imeno ijadufuo fari fuone ije fu uria fari one. Ijadufuo na uria ifejaga uifari fuone buka e uruvana rena aesakae be bure abena karikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Areme nituame suoke Eburame fune urina irekina kamui ije fanu surive ijia saguiva bu do jiavo ije be abe Ega mae. Areme Aburame fune fari fuone kuamoga fune bara Egaki bune vae. Bara Ega fune vakuma are Biasiba aesao ijia totenamina oenoe. ");
INSERT INTO bbb_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","16","Fu ijia oenoeko do boeje fuka furinoga fune fari fuone mesiri tarare titume ijia nujana fune va mumabo gafia fuebe fi. Fu fina vierafeba urina fue kuae, Fari none fu baronekuma naka izege oemarekinu igia fikuva bakino kuaena fune ijia zinuevena fi nimene. ");
INSERT INTO bbb_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","18","Ijiege rena ame ije fune ijia fina nimenoga Godi fu fie. Ijadufuo Godido anera fu saove gufia Ega vua kuarana kumei, Ega a irerefuo oefiane abene. Ade jumemo ijadufuo maeje Godi fu fari ije fu nimeno ije fune fie. Ijadufuo a fino ije arekiro uri va mesirina ifejaga fu nitene. Na vierafe ame ije na daro mana ifejaga uifari fuone buka ma e uruvana rena aesakae be karikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Areme Godi fune Ega ni fuone nafaejaemo fu do ije bu mako guove ijia jiavo ijene gae. Areme fu va kamui fanu surive ijia amaeriva ijene abena do jiamo fu iritoejemo fu abena fari fuone ijae. ");
INSERT INTO bbb_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Areme ame ije fune are sao Ferani ijia finoeko Godi fu samuako fu ubaerena uri e sume mukore bijamo ije rei. ");
INSERT INTO bbb_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Areme asie fuone fune uri fuefuo bara Ijifitiko be gana abe mae. ");
INSERT INTO bbb_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Areme maza ijia Abimerekikiro Faekoro e bijaevo ijiebuo e ireobo bu vakuma Eburame fino ijia usiaena kuae, Ire boeje a rerenoeno ije fune Godire kuarako a ijia renoene. ");
INSERT INTO bbb_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ijadufuo nika Godido nidua ijia akae be nijana kuaekina a naebe na ro anafa none ro uifari none ije biesiruodufuo. Na aeje naka ma rejavo ijadufuo aduaku nika na ro e none igia kariva ige no marejuono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Areme Eburame fu kuae, Ke ije na vierafe na ijiege rekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Areme Eburame fune uri do ije bu mako ijia jiavo ije e Abimerekido imevo ije bu iraraena abeva ijadufuo vafaena uri Abimereki vua kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Fu ijiege kuaramoga Abimereki fu kuae, Na e ije erare rema ije naka naebe gae. A vua ije a naebe migegire nijasie ro ige a ivia amure kuariega na fievono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Areme Eburame fu mave kiro kau ije gue kena Abimereki vajae areme e inokiro ije bune ijia vua kuae avenamina abe marei. ");
INSERT INTO bbb_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Eburame fu ijiege re areme uri mave-sifi fu saema ijadufuo ame irave seveni atana irigi uniae. ");
INSERT INTO bbb_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Fu ijiege atana uniamoga Abimereki fu urina kuae, A mave-sifi ame seveni gare a kena be uniaema ije a irerefuo ijiege remo ni maeje kuarie na fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Ro Eburame fu kuae, A nime mave-sifi ame seveni ije kene. A mave-sifi ame ige oemarekinu kemo ijia na vierafero mako ige fu nonero na ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ijadufuo are ije bu e inokiro ijiebe ijiege reva ijadufuo bu ive ina Biasibano kuae. Ijadufuo maeje e inokiro bu ijia vua bue kuae avenamina abe mareva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ijiege rena Eburamekiro Abimereki bune are Biasiba ijia vua kuae mare areme rade e Abimerekikiro Faekoro bune una ae sakae Firisitia ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","34","Areme Eburame fune uri ine tamarisiki ije abena Biasiba ijia o areme uri E Ireobo Godi ijia fivako ijene fuone baname isoena aroe. Areme Eburame fune are Firisitia ijia ka maza jiamadogo fivae. ");
INSERT INTO bbb_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Areme rade maza be Godi fu Eburame izege fu irinamo ijene biesiri gakiro vierafei. Ijadufuo Godi fu urina kume, Eburameno kumenoga fu una gue onukuana kumei, Na igifurekino kumei. ");
INSERT INTO bbb_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Areme Godi fu kume, Urina Aeseki fari one ka besu a ma ireobo oetuamo ijene mesirina uri are Moraea ijia vane. A ijia vaga na uruo be nijasaga a ijia fari one ije abe kanana na zinone ifaejieno kumei. ");
INSERT INTO bbb_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Ijadufuo nituame suoke mugamia Eburame fune urina sinuome fuone ro miane fu zinone ifaejedufuo ije bino atama areme karina fanuve doniki ado ijia nana ivia kiriae. Areme fune uri e fuone imejo inokiro ro mave doniki ro fari fuone Aeseki ije kaenamiana bune are ije Godi fu kuaema ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Bune vakuma mu inokubeke furikoga fu ijia uruo ije Godi fu kuaema ijene gae. ");
INSERT INTO bbb_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Areme fune una e fuone imejo inokiro ije kiae, Jani fanu doniki ijena igia karike na ame igiaki no va gafia Godi aroena baname isoe areme una rono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","7","Areme Eburame fune miane fu zinone ifaejedufuo ije karina Aeseki vajamo fu karikoga fuje fu miane ijiakiro sime iseke ije kena bune vae. Bune buosiki uruo ijia ajia vako ijia Aeseki fu uri Eburame kuae, Ate, miane no zinone ifaejedufuo ije none igi karina ruove. Rove mave-ame ije no zinone ifaejedufuo ije izieburekino kuae? ");
INSERT INTO bbb_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","9","Fu ijiege kuaramoga Eburame fu kuae, Farino, mave-ame ije no zinone ifaejedufuo ije fu Godire korufuo muokono kuae. Areme bune vakuma are ije Godi fu kuaema ijia usiae. Bu va ijia usiae areme Eburame fune uri fata zinone ifaejedufuo ije mune ijia kari nana amaerima areme uri miane ije karina fata ado ijia nae. Fune ijiege re areme fune uri fari fuone Aeseki farena toma areme dabena miane ado ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","12","Areme fune uri sime abena Aeseki bijakuvenoga Godido anera ije fu saroruba saove ijia kumei, Eburame, Eburame, arene! A fari one ije ade kana ro ire be fuone remo. Ijadufuo maeje iviama na gaga aka Godi mukoreigia aguaekinu irinamo ijadufuo a fari one besu a ireobo oetuamo ije aka uria oemarekinu abe na miekiro vierafemano kumei. ");
INSERT INTO bbb_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Areme Eburame fu dakude gake mave-kumate ijadufuo nigofo muane ijare kaesa tarare ijia kena saguma manino fu gae. Ijadufuo fune va mave-ije farena dabe una ro kekena ijare abena Godi zinone ifaejegaro fari fuone fu ijare arei. ");
INSERT INTO bbb_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Ijadufuo Eburame fu are ije ive ina kuae, E Ireobo Korufuo Vajuokono kuae. Ijadufuo iviama are ije bu kua, E Ireobo ijadufuo uruo ijia fu vajuokono kuavo. ");
INSERT INTO bbb_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","17","Areme E Ireobo ijadufuo anera ije fu saove ijia una kuke Eburame kumei, E Ireobo fu kuae, Aka na iriniema ijadufuo a fari one a ma ireobo oetuamo ije abe kanana na zinone ifaejiekiro naebe abe rui. Ijadufuo na ive none ijia kuranamina kuaedo nare daro ka ireobo maga uifari one buka ire zuvi saove gufia ireva ro kuke davare ajare game fu zaraema ijiege buka e uruvana reke. Ro kuke bure e ani buone ije iraraena kaniana aesakae ro sidove buone ije keke. ");
INSERT INTO bbb_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ro kuke aka na iriniema ijadufuo na uifari one ijiebuo duvado ijia nare e aesakae binobino ijia kariva ije marejiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Areme Eburamekiro fari fuone ije bune una ari vakuma e fuone imejo ije kariva ijia usiae. Areme fune bu kaenamiana bune besu una are Biasiba ijia vae. Areme Eburame fune Biasiba ijia maza sibaneke ijia finoe. ");
INSERT INTO bbb_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","24","Eburame fu ijia fino ijia rade maza be bu ebe iviene fuone e Neodo bara Miruka ame eiti (8) fu tuanaema ijene kuarae. Ro ame ijiebuo ive ijeja boga ije e Uzi ro uviarafa fuone ije e Buzikina Kemuero e Aramedo asoe ijene. Ro e Kesetikina e Ezokina Firudasikina e Jidirafiki e Betuero bara Ribekado asoe ijene. Eburamedo uvia e Neodo bara Miruka fu ame uije eti (8) ijiege tuanae. Ro e Neo fu una bara Ruma bara ije fu fuefuo imeno ijiaki naenoga fu ame bino duaku tuanae. Ro ame amure ije Teba ro be ije Garami ro be ije e Tarasi ro iviene ije e Maka ijene tuanae. ");
INSERT INTO bbb_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Ijiege rena Sera fune juaevasia uvani aderedi tuaedi seveni (127) ijiege fi vakuma areme fune are Eburoni aesakae Kenane guove ijia baronemoga Eburame fu urina fuefuo sisimei. ");
INSERT INTO bbb_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","4","Eburame fu sisimena areme Serado surive fu ijia nakoga fu vakuma e Itaeteko kariva ijia kekena kiae, Naeje na e aebeko na igia jaena fivo. Ijadufuo ni jare sakae be kiega na fuaevena bara none ijadufuo surive abe ijia mako runo kiae. ");
INSERT INTO bbb_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","6","Eburame fu ijiege kuariamoga e Itaetiko bu una gue kuae, E ireobo no ige kuarako ni fiene. Aeje aka e anuigi be a noena igia fino ijadufuo bara one ijadufuo surive ije abena mako nuvuone maeje no ruiva ijia nujane. No vierafe no oe marekinu mako nuvuone ije be kuaga a bara one ije abe ijia nujakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","8","E Itaetiko bu ijiege kuaravoga Eburame fune uri bu kurituakafia areme uri kiae, Ja vierafega jane oemaredo na bara none abe igia mako rukuva nine ja isekie Efironi e Zorado fari ije kuagafo. ");
INSERT INTO bbb_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ja kua fu sakae fuone ubine ijia munie Makeferano kuavo ije kiega na fuaevefo. Ja kuaga fu izege vierafekuma fu iviama e boeje nidua jone igia moni foteke izege fu vierafema ijene kiega na fuaevefo. Na ijiege fuaevena abe none rekina na e none oekuva na kena ijia uniano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Ro e Efironi e Itaetiko fu sidove viene ije e boeje bu besu afuina vua kuaevo fu ijia fina vua fieme. ");
INSERT INTO bbb_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","E boeje bu karina fievo ijia e Efironi fu urina e Eburame kuae, Na aesakae ao none ije ro mako ije dua na a vajake. Na e none ige bu afuiva nidua buone ijia na sakae ao ijene abe a maga a bara one ijadufuo surive abe munie ijia nujakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","13","Rove Eburame fu vierafero are e boeje bu fiero fu uri e Itaetiko ijene kurituakafia areme una e Efironi kuae, A isekie ni vua ige na kuarakuvejo ige mukoe fiene. Sakae ao ije a kiemo ije nane fuaeveke. Ijadufuo ni moni izege na vajavo ije nime oemarekinu abeke na bara none ijadufuo surive ije abe ijia mako runo kuae. ");
INSERT INTO bbb_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","15","Eburame fu ijiege kuaramoga e Efironi fu una gue kuae, E ireobo igia fiene. Sakae ao ijadufuo moni ijeja fo aderedi siruva ijiaru. Ro ije a vierafega fune marejoga ni bara one ijadufuo surive abe ijia mako runo kuae. ");
INSERT INTO bbb_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Ijadufuo Eburame fune siruva fo aderedi ije e Efironi fu e boeje ijiebuo nidua ijia kuaema ijene kanafuina amaeri. Fu siruva ije kena izege e bisinisi bu sinuome sikere revo ijiege sikere giakinu amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Ijadufuo vua ige ijeja izege e Efironi fu sakae fuone ije Makefera are Mamure ivuake ijia namo ijene abe una Eburame mamo fu abe una fuone rema ijene. E Efironi fu sakae ao ijiakina mako ro ine ije fu vakuma izia irima ije foteke fu kena Eburame vajae. Efironi fu ire boeje ijene kena e Itaetiko boeje bu sidove viene ijia afuina vua kuaevo ijiebuo niome ijia kena una Eburame vajae. ");
INSERT INTO bbb_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ijiege rena Eburame fune uri bara fuone Serado surive abena aesakae Kenani guove munie Makefera ijia nujae. ");
INSERT INTO bbb_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Ijadufuo e Itaetiko ijiebuo aesakae ao ijiakiro munie ije sakae ijia namo ije fune una Eburamedo remoga fu abe una e uniadufuo amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","E Eburame fune eore rove E Ireobo fuka uria ire binobino fu renoeno ijia daro makinu marejamo. ");
INSERT INTO bbb_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Ijadufuo Eburame fu maza be uri e be isuibe fuefuo imeno fu ire boeje Eburamedo are ijia naovo ije samuagiamo ijene kuae, Anika oge none igia faradiena kieko na vua one a kuariemo ije naka rekono kiega na fiene. ");
INSERT INTO bbb_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Na vierafe aka Godi E Ireobo sakae igiakiro saove gufadufuo ive ijia kurana kiega na fiene. Ni a kie a fari none igadufuo bara ije a naebe e aesakae Kenani igia kariva ijia rereke. ");
INSERT INTO bbb_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ro aka va aesakae na nafieva ijia uviarafa none ijia kariva ijiebuo uve ijia fari none ijadufuo bara rerekono kiega na fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ro e fuone imeno ije fu una gue kuae, Ro na va barafuo kiaga bara be fu naebe are fuone ije arena uri aesakae igia ruakiro vierafekuma na izege reke? Nabe fari one ije kuaga fure una aesakae one ijia vakono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Fu ijiege kuaramoga Eburame fu una kuae, A fari none ade kuaga fu una aesakae none gamia vako. ");
INSERT INTO bbb_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Naeje fune E Ireobo Godi saove gufe samuamo ijare mesiriena igia ruae. Na uri igia ruaga asoe none ijadufuo are ijiakiro uviarafa none ijiebuo aesakae ije nane ijia arena ruae. Ro fune ma vierafe fu aesakae ige abena una uifari none ije miakono kie. Ijadufuo E Ireobo fu anera fuone ije kuaga fu ude vake. Fure va vame one ijene amaeri fu marega a bara gamia rerena mesiri una ro fari none nujaejake. ");
INSERT INTO bbb_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Ro bara kabaekua be fu naebe oemarekinu osiki ruakiro vierafekuma ijare vua ige a kie na rekono kiema ije ame totena ijareke. Ro vame fu iserekuma ade fari none kuaga fu una aesakae none ijia vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Ijadufuo e Eburamedo imeno ije fune uri e fuone ireobo ijadufuo oge ijia farei. Fu ijia farena Eburame kuae, Na vierafe na a kuariemo ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","E Eburamedo imeno ije fune ijiege rena uri e ireobo fuone ijadufuo fanu kamero umui guegue kena uri sinuome maeje gue kena ijia nama areme fune vae. Areme fune vakuma sidove e Neo fu finoema are Mesefotemia una ikene ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Fune vakuma sidove ivuake irifo do bu mako ijia jiavo ijia kekei. Areme fune fanu kamero fuone ijene ijia unia bu naoko fu ijia fine. Ro maza ije fune ve jiaema bara bune do jiake ruadufuo ijia fu ijia fine. ");
INSERT INTO bbb_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Ijiege rena e Eburamedo imeno ije fune urina baname isoe. Fu kuae, E ireobo none ijadufuo Godi E Ireobo nine vua ije a ude e ireobo none ijiaki kuaema ije vierafene. A ije vierafena ifejiega vua irere na ruaeva ije fuka marene. ");
INSERT INTO bbb_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Iviama nane do ige bara sidove gufia karivo bu ro jiadufuo igia manive. ");
INSERT INTO bbb_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Bara ije bu roga na bara be kuako, A isekie sukore one a do jiaema ijia do jia mie na ino kuake. Na ijiege kuaga fu kieko, Do ije igifurekino ike na bino jiana fanu kamero one ije vajiano kieke. Fu ijiege kuariemo ijia na vierafero bara ije are Aeseki e oefuo imeno fu abedufuo a vierafema ijene ro na ijiege vierafene. Na ire ije fu iviama rekuma na vierafero vua izege a e ireobo none kuaraema ije fune riaremaro na ijiege vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","E ije Eburamedo imeno ije fune baname ijiege isoema furikuveno ijia bara Ribeka fune sukore fuone abena ijia kekei. Ro bara Ribeka fu e Betuerodo kabae ro fu e Eburamedo uvia e Neodo fari. Ro e Neodo bara ije Miruka. ");
INSERT INTO bbb_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","17","Rebeka fu bara kabaekua fu baruna naeno baki ro kuke fuka bara ni mukore. Bara ije fune kekena va sukore fuone abe do jiana una vakiro romoga e ije fune kekena bie. Fu biena kuae, Bara gure a isekie, sukore one ijia do be jia miega na ino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Fu ijiege kuamoga bara ije fune sukore do fu jiaema ijene abe nijakoga fu do ijia i. ");
INSERT INTO bbb_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","E ije fune do ina furinoga bara ije fu uri kuae, Ni manike na do jiana kamero one ijene vajiaga bu ino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Areme fune migegire do fu jiaema ijene dabe ire ije bu do jia usiaga fanu bu ivo ijia usiae. Areme fune una mako ijia do jiakiro vae. Fu ijiege rekinu do jiana kamero boeje ruoriama furi. ");
INSERT INTO bbb_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Bara ije fu ijiege rekoga e ije fu mauike manina bara ije veri arega fu bara ije E Ireobo fu vierafe fu biekiro vierafema ijene ro fu bara bega fu ije gakiro vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Ro bara ije fune do jiana kamero boeje ruoriama furinoga e ije fu ijia gana vierafega bara ije fu bara maeje E Ireobo fu vierafema ijene. Ijadufuo fune uri muki bu gorodi ijia amaeriva bu moni ireobo fuaevejo ijene abena bara Rebeka mae. Areme fune uri madare farane navo inokiro bu gorodi ijia amaeriva ije karana vajae. ");
INSERT INTO bbb_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","E ije fu ijiege rei areme uri kuae, A isekie ni asoe one kua na fiene. Ro are one ije fube manido na e none ijena muge igiaru ijia naekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Areme bara ije fu una kuae, Na asoe none ive ije e Betuero. Ro fuje fu e Neokiro bara Miruka ijiebuo fari. ");
INSERT INTO bbb_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Ro asoe none ijadufuo are fu manido ja va ijia naoke. Ro kuke fanu kamero ijiebuo ire bu ivo ije are nuvuone ijia buka ma uruvanano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Areme e ije fune uri ijia auge sana E Ireobo dabe aroena baname isoe. ");
INSERT INTO bbb_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Fu baname isoena ijiege kuae, Naka e ireobo none ijadufuo Godi E Ireobo ijadufuo oemareve. Fu e ireobo none fu maza boeje ifejamo ije fuka naebe totei. Ijadufuo E Ireobo funeka mesirie ruoma e ireobo none ijadufuo agane ije kariva ijia kekemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Areme bara ije fune una difurina asie fuone ijadufuo are ijia kekena vua boeje izege fu rema ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Ro bara Ribekado maki fuone ije ive fuone Rebani. Ijadufuo Rebani fu uri Ribekado udo muki fu akoema ijiakiro madare farane fu naema ijene giae. Fu ije giae ro kuke fu vua ije e gafe fu Ribeka kuaraema ijene fiena fune kekei. Fune kekena difuri vakuma e gafe fu mako do game kamero bu irifo ijia naoko fu manino ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Areme fune e Eburamedo imeno ijene kuae, Kaeno, E Ireobo fune a marejana ifejae. Ijadufuo a manino arekiro no nobiki vako rone. Are a nae ro kuke kamero one bu naodufuo ije fu manido a ijia naekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Areme e Eburamedo imeno ijiakiro e fuone fuina vaeva ije bune are ijia aru vakoga e Rebanido imeno ije fune uri fanu kamero ije dokina ire ije kamero bu ivo ijene vajiae. Areme fune kuke uri do e ije bu dia sodufuo ijene jiana abe ijia nijaejiae. ");
INSERT INTO bbb_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ijiege rena bune ire ikuvejo ijia e Eburamedo imeno ije fu kiae, Na vierafe na sone ire idufuo ro iviama na vierafe naka vua na ruaeva ijene kuariana oedasu areme na ijare ire ikono kiae. Fu ijiege kuariamoga Rebani fu kuae, Ke ni vua a vierafema ije kuae na fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","35","Ijadufuo e ije Eburamedo imeno fu uri kiae, Naeje na e Eburamedo imejo beno kiana fune ijia uri zinuivena fu vaema ijene kuariae. Fu kia, Na e ireobo none ije fune E Ireobo ijare daro ma ireobo mae. Ijadufuo fuka sinuome zarae ro kuke fu fanu mave-ro goti ro fanu kamero ijiakina doniki ije vajae. Ro kuke fuka ire gorodikina sirivakina e fari ro bara fuone imejo ije vajae. ");
INSERT INTO bbb_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Ro kuke e ireobo none ijadufuo bara Sera fune barasire rove fu ame fari bietemoga e ireobo none fu sinuome fuone boeje fu samuagiamo ije kena una fari fuone ije vajae. ");
INSERT INTO bbb_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Na e none ireobo ije fu kiemoga na E Ireobo kuraedo vua irere fu kuariema ije na irinana reke. Fu kie, A fari none ijadufuo bara ije rerekuma ade are Keinani guove ijia reremono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Ro ni va asoe none ro agane none ijiebuo are ijia bara fuefuo rereno kie. ");
INSERT INTO bbb_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Fu ijiege kiemoga na una e ireobo none kuae, Ro bara ije fu naebe nosiki ruakiro vierafekuma na izege rekono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Na ijiege kuaravoga e Eburame fu una ijiege kuarie, E Ireobo none ije na maza boeje irinavo ijare anera fuone kuaga fu obiki vake. Fure ifejana vame samadirejaga a bara migegire bieke. Ro fure ifejaga a e none ro asoe none ijadufuo agane ijia bara fuefuo rerena mesiri nujaejake. ");
INSERT INTO bbb_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ro a va agane none giaga bu bara be naebe kuakuva ijare a vua ije a nosiki kuaena marema ije nime totena ijaredufuo. ");
INSERT INTO bbb_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ijadufuo na ro mako ije bu do jiavo ijia keke manina mauike oe none ijia baname isoe. Na baname isoena kua, Eburame e ireobo none ijadufuo Godi E Ireobo ni iviama ifejiena irere na rekiro ruaeva ije abena samadirejiene. ");
INSERT INTO bbb_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Iviama nane mako ige bu do jiavo igi manive. Ro bara nikaki be fu sukore fuone abe do jiakiro roga na kuaga fu sukore fuone ijia do jia miega na ike. ");
INSERT INTO bbb_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Ro bara ije fu oemarenaro fanu kamero none ijiebuo do jia vajiakuma na vierafero bara ije Godi are e none ireobo ijadufuo fari ijadufuo vierafema ijero na ijiege vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Nane baname ijiege isoema furimo ijia na gake bara Ribeka fu sukore fuone abe mako ijia do ijiakiro vuako na gae. Na gana uri kuae, Aesekie ni do be jiana miega na ino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Na ijiege kuavoga bara ije fune saroruba uri sukore fuone abena ume ijia nijae. Areme fune kie, Do ije ijifurekino ni jia ike na fanu kamero one ijiebuo do jiana vajiamo kie. Areme nane do jia ikoga fune kamero ijiebuo do ijiana vajiako bu i. ");
INSERT INTO bbb_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Areme na urina kua, Asoe one ije erano kuavoga fu kie, Asoe none ije e Betero fu e Neokiro bara Miruka ijiebuo farino kie. Fu ijiege kuariemoga na uri muki abe udo ijia akoza areme uri madane farane ije naejae. ");
INSERT INTO bbb_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Na ijiege re areme uri ijia auge sana E Ireobo baname isoe kuae, Naka e ireobo none Aburamedo Godi E Ireobo ijene ireobo oemareve. Ijadufuo maeje aka na mesirie urari ruoma e none ireobo ijadufuo agane ije bie. A mesirie romoga nane uvia fuone ijadufuo asae fuone kabae ijene e none ireobo ijadufuo fari fu abedufuo ijene gae. ");
INSERT INTO bbb_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ijadufuo a vierafega a e ireobo none ijene vame maeje fuone rena kabae one ije abe fari fuone ije makuma ni a isekie nine ijiege kuarie na fiene. Ro a bakuma ni bano kiega na una vame be vierafegano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Areme Rebanikiro Beturero bu una gue kuae, Vua ige fune ma E Ireobo Godi ijadufuo vierafe ijia a ruaejoga no vierafe no una vua irere kuaekuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Ijadufuo Ribeka fu guaraejifurekino ni mesiri vaga fu izege E Ireobo Godi fu kuaema ijiege fu e ireobo one ijadufuo fari ije manino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Rebanikiro Betuero bu ijiege kuaravoga e ije Eburamedo imeno fu vua ije fiemo fuka oeseremo fu uri ijia auge sana Godi baname isoena oemarejae. ");
INSERT INTO bbb_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Areme fu uri uniae tamae ije gorodi ijia amaeriva bu uro kiriavo ijiakina ire siriva ro sinuome fu sadufuo ije bino karana ke Ribeka vajae. Areme fune kuke uri ire bino bu moni mamekanu fuaevejo ije karana ke maki fuone ijiakiro asie fuone ije vajiae. ");
INSERT INTO bbb_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Areme e Eburamedo imeno ijiakiro e gue ije fuina vaeva ije bune ire ikinu do ina areme bune ijia naoe. Areme nituame suoke bune urivoga e Eburamedo imeno ije fu uri kiae, Na vierafe nane ivia una e none e ireobo fino ijia vakiro vierafevano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Rove bara Ribekado maki ijiakiro asie fuone ije bu uri kuae, Ije fune mare ro ni areke fu fura besu ro ba inokiro (10) ijiege noena finaro nine sone ijare vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Rove e ije fuka uri kiae, Jabe no vafievo. Ijadufuo maeje na ige na ruaeva ije fune E Ireobo Godi ijare irufui none ijene ifejie. Ijadufuo na vierafe nane migegire una e none ireobo ije fino ijia vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Fu ijiege kuariamoga bu kuae, Ke ni areke no kabae nuvuone kumega fu ro vua irere fu vierafema ije kuaruoga no fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Areme bune Ribeka kumevoga fu romo bu kuae, Abe oemaredo a e igiaki vakono kuavoga fu kiae, Ke na vierafe na fuosiki vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","60","Ijadufuo bune uri Ribekakiro e fuefuo imeno ije kiavoga bu uri e Eburamedo imeno ijiakiro e ije bu fuina ruaeva ijena vakuvejoga bune uri fu daro mana baname ijiege isoe, No vierafe anafa one a tua namo ijiebuo uije ije buka ma uruvana ajare e bu davo baki ijiege reke. Ro kuke bure e ani buone ije iraraena kaniakuriana sidove buone ije kekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ribekakiro bara kabaekua fuone gue bune uri sinuome buone kari fanu kamero ijadufuo ado ijia nama areme bune uri e Eburamedo imeno ijena vakuae bune vae. ");
INSERT INTO bbb_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Ro Aeseki fune ruoma ae sao ijia do be bu ruiva bu kua, E ni uria fino fu na giemono kuavo ijia finoene. Ro are ije fu una Kenani ikene ijia. ");
INSERT INTO bbb_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Ijiege rena Aeseki fune maza be ve nakisirema ijia va oenoeno ijia fu gake fanu kamero bino bu rovo fu giae. ");
INSERT INTO bbb_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ro Ribeka fu vakuma Aeseki gana uri fanu kamero ado fu fino ijia umakoena ari. ");
INSERT INTO bbb_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Fu arina e ije Eburamedo imeno ije kuae, A vierafega e gafe ruomo ije erareno kuae? Fu ijiege kuaramoga e ije fu una kuae, E ije fu e ireobo none ijadufuo fari ijareno kuamoga Ribeka fu uri ugone fuone abe ni fuone okurae. ");
INSERT INTO bbb_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Areme bune ruoma Aeseki manimo ijia usiaena e Eburamedo imeno ije fune uri vua irere boeje fu rema ijene Aeseki kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Fu ijiege kuarama furi areme Aeseki fune uri Ribeka mesirina asie fuone Serado are muvuaka ijia vae. Areme Aeseki fune ijia uri Ribeka abena buosiki besu karinoe. Ro Aeseki fu ude asie fuone baronemoga fuka oe fiaeguma finoe ro rade fu Ribeka abena ireobo oetuaema ijadufuo fu una oemarekinu fi vae. ");
INSERT INTO bbb_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","E Eburame fu una bara bedua ive fuone Ketura ijene abei. ");
INSERT INTO bbb_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Bara Ketura fu ame umui fague ro dikine besu ijiege tuanae. Ro ive buone ijeja e Zimiranikina e Jokisanikina e Medanikina e Midianikina e Isibakikina e Sua ijene. ");
INSERT INTO bbb_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ro e Jokisani fu uri ame Sibakiro Dedani nafei. Ro e Dedanido uifari ijeja e Esuraetikina e Retusaetikina e Reumaeti ijene. ");
INSERT INTO bbb_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ro e Mediani fu uri ame umui fague nafei ro ive buone ijeja e Ifakina e Efakina e Anokikina e Abidakina e Erida ijene. Ro ame ije bu bara Keturado uifari ijene. ");
INSERT INTO bbb_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Areme Eburame fune uri sinuome fuone boeje fu samuagiamo ije kena una fari fuone Aeseki vajamo fu samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ro fu uria fino ijia fu uri ame fari ije bara fuone gue ijiebe nafe vajaeva ijene sinuome vajiama areme kiamo bune uri sakae ije Aeseki fu fino ije arena una uri are maza ajiamo nake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","10","E Eburame fune fi vakuma ma eorena juaevasia uvuvani aderedi seveniti faeve (175) ijiege furikoga fune ijia baronei. Ro fu baronemoga anafa fuone e Aesekikiro Isimero bu vajae surive fuone abena va mako be bu kua Mekeferano kuavo are Mamure ivuake ijia nujae. Ro mako ije bu e Eburamedo agane bu oega bu kena ijia uniavo ijene. Ro ae sakae ije fu e Efironi e Zoado fari e Itaetiko ijadufuo sakae ije Eburame fu fuaevema ijene. Ijadufuo Eburame kiro bara fuone Sera bu oevo bu kena sakae ijia uniae. ");
INSERT INTO bbb_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Eburame fu baronekoga rade Godi fu fari fuone Aeseki daro mamo fu are be bu kua E Ni Uria Fino Fu Na Giemono kuavo ijia fi. ");
INSERT INTO bbb_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ro suvuare ige fu e Isimerodo kuae. Ro e Isimero fu bara Ijifitiko Egano kuavo fu Serado i meno fu nafena Eburame maema ijene. ");
INSERT INTO bbb_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Ro Isimerodo anafa fu tuanaema ijiebuo ive ije ijiege. Ro fari amure e Nebaeotikina e Kedakina e Adebirikina e Mibisamikina e Misimakina e Dumakina e Masa ijene. Ro ame gue ijiebuo ive ijeja e Edatikina e Temakina e Jeturukina e Nafisikina e Kedema ijene. ");
INSERT INTO bbb_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ro ive ije ige bu e Isimerodo farirafa tuero (12) ijiebuo ive ijene. Ro ive buone bu i miaeva ije bu sidove buone ijiakiro are muvuaka bu sana karinoevo ije nabuikaramiaeva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ro Isimero fu fi vakuma juaevasia uvuvani aderedi teti seveni (137) ijiege furimo fune baronei. ");
INSERT INTO bbb_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Ijiege rena Isimero fu baroneko rade uifari fuone bu urina are ijia kafare be Avirakiro Seno kiavo ukua ijia kari. Ro are ije fu Ijifiti ivuake ijia ro kuke fu are maza ajiamo nake vame bu are Asiria vako ivuake ijia. E Isimerodo uifari ije bu Eburamedo agane ije uniana va buebino karinoe. ");
INSERT INTO bbb_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","20","Ro vua ige fu e Eburamedo fari e Aesekido suvuare. Aeseki fu fi vakuma juaevasia foti (40) ijiege furinoga fu uri bara fuone Ribeka abei. Ro Ribeka fu e Betuerodo kabae ro fu e Rebanido maki ijene. (Ro e Betuerokiro Rebani bu e Aramiako bu aesakae Mesofotemia ijia ruae.) ");
INSERT INTO bbb_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Bara Ribeka fu ame bino naebe nafekoga fune juaevasia tuaedi (20) ijiege furi. Ijadufuo Aeseki fu uri fuefuo E Ireobo baname isoe. Fu baname isoemoga E Ireobo fu baname fuone ije fiena ifejamoga Ribeka fu e fudie. ");
INSERT INTO bbb_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Ro ame fu fudiema ije fu ufariki ijadufuo ame inokiro bu devatua fuone ijia bue nigaraevo fu fie. Ijadufuo Ribeka fu una fue kuaemo, Ire ije fu irerefuo ijiege none remono kuae. Ijadufuo fune va Godido baname isoega fu maeje nijaekiro fu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Ijadufuo fune baname isoemoga Godi fu vua ijadufuo maeje Ribeka nijae. Fu nijaena kuae, E mamekanu inokiro bu aesakae inokiro samuadufuo ije bu devatua one ijia kari. Ijadufuo ame ije a nafemo ijiebuo uifari ije bu rade urikuvejo ije bu bue nigaraekinu karike. Ro ame be ije fuka e daroki reke ro be ije fu baki. Ro ame amure ije fu una ame iviene ije fuefuo imekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","26","Areme maza ije Ribeka fu ame nafedufuo ije romoga fune ame inokiro nafei. Ro ame amure ijadufuo vajae surive fuone fu kavuane ro vajae jau fuone fuka nibe ire ugone igeki. Ijadufuo ive fuone bu Iso kuae. Ro ame be bu bietevo fu ari Isodo dia tare ijia uti fare ijadufuo ive fuone bu Jekafu kuae. Ro Aesekido juaevasia ije fu sigisiti (60) ijiege abema ijia Ribeka fu ame inokiro ije nafei. ");
INSERT INTO bbb_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ijiege rena ame ino uviaki ije bune besu ubaeradiae. Ro e Iso fuje fu urina e be sume mukoe bijamo rei ijadufuo fu maza boeje fu are ijia dasu fino baki ro fu keke oenoeno. Ro e Jekafu fu ebe mauike are ijiaru fikinu mave-samuagiamo. ");
INSERT INTO bbb_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Ro e Aeseki fuka fari fuone e Iso ireobo oetuamo. Ijadufuo maeje e Iso fu sume mukoe bijana fanu kania ruoga bu kirana ivo. Rove bara fuone Ribeka fuje fari fuone Jekafu oetuamo. ");
INSERT INTO bbb_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","30","Areme maza be Jekafu fu ire dodoki be kirama fino ijia Iso fu sume bijanoena una vasiakuma ijia keke. Ijadufuo fu uri Jekafu kuae, Naeje naka ireobo vasiorieve. Ijadufuo ire kavuane ije a kiraema ije be afe miega na ino kuae. (E Iso fu ijiege rema ijadufuo i fuone bu kua Idomino kuae.) ");
INSERT INTO bbb_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Fu ijiege kuamoga Jekafu fu una kua, Ije fune mare rove na vierafe aka daro ije ame amure bu kevo ije a abena una na miekono kiekuma na ije ire ige vajakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Ijadufuo Iso fu una gue kuae, Naeje nanaka vasia oriena baronekuvejo ijadufuo daro ije fu irere na ma rejiekuma baki ijadufuo na vierafe naka abena una a makono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Fu ijiege kuamoga Jekafu fu una kuae, Ije fune mare rove nine iviama akae be nijana kie a daro one a na miekono kiega na fieno kuae. Ijadufuo Iso fune uri Jekafu kuae, Na vierafe na ijiege rekono kuana fune uri daro fuone ije abena una Jekafu mae. ");
INSERT INTO bbb_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Areme Jekafu fune uri ire burede ijiakiro ire ije fu kiraema ije bino afena Iso vajamo fu ina oemare areme fune vae. Ro vua ige fu izege e Iso fu fari amure daro ije bu abevo ije abe una isekube vierafema ijene. ");
INSERT INTO bbb_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ijiege rekoga vasia be duaku are ijia kekei. Ro vasia ije fu Eburamedo mazani ije fu finoeko fu kekema ijieki. Ijadufuo Aeseki fu una biona are Gera ijia e Firisitaeniko ijiebuo Kini Abimereki fu fino ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Fu va ijia finoenoga E Ireobo fu arina Aeseki biena kuae, Ade una gamia Ijifiti vako. Ani sakae ige na kuavo igia fine. ");
INSERT INTO bbb_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","A igia finoene ro naeje nabe a abuozake ro naka maza boeje osiki oenoekinu ifejana daro make. Na vua irere na rekiro Asoe one ije kuaraeva ije nabe areke. Ro naka ire ijene rena are irore ige dabe uifari one ijena ja miake. ");
INSERT INTO bbb_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ro kuke na ifejaga uifari one ije buka e ma uruvana ire zuvi saove gufia ireva ijiege rega na aesakae boege abe bu miake. Areme na uifari one ijiebuo duvado ijia na e aesakae boeje igia kariva ije ifejiana daro miake. ");
INSERT INTO bbb_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Naka a ifejana daro make ijadufuo maeje Eburamere vua boeje na kuaravo ije fuka mukoe iriniekinu ro akae none ije mukoe samuagiaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","7","Ijadufuo Aeseki fune are Gera ijia fino ijia e fari ije bu uri bara fuone ijene gana kuarae. Bu kuavoga fu kia, Bara ije fu maki noneno kiae. Ijadufuo maeje Ribeka fuka bara ni mukore ijadufuo fu kiako fu maki nono kiakuma e ijia karivo ije buka kana areme bara fuone ije abekiro fu ijadufuo ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Ijiege rena Aeseki fune ijia fivakuma juaevasia sibaneke ijiege furi. Areme maza be Aeseki fu bara fuone Ribeka uimimoga Kini Abimereki fu gire fuone tire bu umateva ijia fina giae. ");
INSERT INTO bbb_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Areme fune uri kiamoga bune Aeseki mesiri rovoga fu urina kuae, Bara gure fu bara one, rove a irerefuo kuae fu maki nono kuae? Abimereki fu ijiege kuaramoga. Aeseki fu kua, Na vierafero na kiako fu bara nono kiakuva jaka kaniekiro na ijadufuo ijiege kuariaevano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Fu ijiege kuaramoga Abimireki fu kuae, A vame ije a rema ije a irerefuo ijiege rei? A e none be fu oenoene bara one ije mesiri oenoekuva ise ije aneka koro rei. Ijadufuo maeje are vua kufui kuaema ijadufuo bu ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Ijadufuo Kini Abimereki fune uri e fari boeje oevisusaejiana kiae, Ja e be jade oenoene e igiakiro bara fuone ije vame ise bino buone revo. Ro ja faememarena ise bino buone rekuva e ije na kia bu kana fu baronekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Areme Aeseki fune aesakae ijia juae mena uije oma areme masi. Ro ire ije fu masina kanafuima ije fuka ma uruvana. Fu ire uije sibaneke oe rove fu una kanafui ma ije fuka aderedi (100) asi vae. Ijadufuo maeje E Ireobo fuka fu mukoreigia ifejana daro mae. ");
INSERT INTO bbb_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Ijadufuo Aeseki maza boeje fuka e anuigi rena uri sinuome zaraezaraeki rena fivae. ");
INSERT INTO bbb_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Ijadufuo maeje fuka mave-kiro kau ma uruvana sae ro kuke e fuone imevo ije buka ma uruvana. Ijadufuo e Firisitaeniko bu ijene gavo buka naebe oemare ijadufuo buka oe isema fu vierafevo. ");
INSERT INTO bbb_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Bu ijiege revo ijadufuo bu urina e Eburamedo mako ije fu uria fikoga e fuone imevo bu ruiva bu ijia do jiavo ije buka una afisei. ");
INSERT INTO bbb_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Ijadufuo Kini Abimereki fu urina Aeseki kuae, Aeje a iviama aneka e daroki rena noeje ane asidue. Ijadufuo ni are ige a fino ije ni arena uri vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Ijadufuo Aeseki fune urina are Gera amare ijia are sana maza sibaneke ijia finoe. ");
INSERT INTO bbb_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Aeseki fu ijia finoekinu mako ije e Firisitaeniko bu afiseva ijene una runa amaeriakinu ive asoe fuone fu ude imiaema ijene una ijiege imiae. Ro mako ije bu e Firisitaeniko ijiebe e Eburame asoe fuone fu iko baroneko bu ijia afikuriaeva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Areme e Aesekido imevo ije bune uri are Gera amare ijia mako iviaeko be duaku ruma ijia do be gana amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Bu do ije ruma arevoga e Gerako mave-samuagiavo ije bu usiaena una e Aesekido imevo ijena do ije dabe vafaena madinami. Bu kia, Do ije fu nuvuono kiae. Bu ijiege reva ijadufuo Aeseki do mako ije fu abe ive ina kuae Madinamivano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Areme e ije Aesekido imevo ije bu una mako be duaku ruma areme ijia do jiavoga bu una kuke ijadufuo vafaena e ijena madinami. Ijadufuo Aeseki fu mako do ijene kake abe ive ina kua Vafaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ijiege rena Aeseki fune are ije arena una va are be ijia fi areme uri mako be duaku rui. Ro mako ije fu ruima ijare e Gerako ije bu naebe ijia vua bino kuae. Ijadufuo Aeseki fu uri mako do ijene ive ina kua Dazevano kuae. Fu kuae, E Ireobo fune iviama are igeno dazena karinoedufuo ijene no muoe. Ijadufuo no igia karina daro abena ire boeje renoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ijiege rena Aeseki fune ijia finoena areme fune una urina are Biasiba ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Aeseki fu va Biasiba ijia naema E Ireobo fu muge besu ijia ari nakaurana kuae, Naeje na asoe one Eburamedo Godi ijene. Ijadufuo ade jumemo ro naeje nane osiki oenoeve. Nare a daro maga uifari one ije buka ma uruvana zaraeke. Ijadufuo maeje nane ude Eburame e none imeno ijiege ijene ijuina kuaeva ijadufuo na ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Ijadufuo Aeseki fune uri fata be bu zinone ifaejedufuo ije ufema areme ijia E Ireobo ijene baname isoena aroe. Fu ijiege rena fune are sana ijia finoekoga e fuone imevo ije bune una kuke mako be dua iviaeko do jiadufuo ijene rui. ");
INSERT INTO bbb_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Areme maza be Kini Abimereki fu Ausati e fuone uguae kuaramo ijiakiro Fikoro e bijaevo ijiebuo e ireobo ijena are Gera ijia urina Aeseki gakuae ruae. ");
INSERT INTO bbb_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","E ije bu ro Aeseki gavoga fu urina kiae, E gure ude jaka naena kai ma reva baki. Jaka na ijuonena rorukurievo na aesakae jone arena uri igia ruae. Ro ja irerefuo una na giekuae ruaevano kiae? ");
INSERT INTO bbb_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","29","Fu ijiege kuariamoga bu urina kuae, No iviama ijare vierafega E Ireobo fuka osiki. Ijadufuo no vierafe noka vua be aena kuaena abe mareke. No vierafe aka iviama samadukua kuaruona kuoko nabe ja kania ro vajae fiane bino vajiakono kuoga no fiene. Ijadufuo maeje no naebe vajae fiane bino a no naebe vajae ro noka marejana kuavoga ame mauike aesakae nuvuone arena uri ruae. Ijadufuo no vierafega fune E Ireobo ijare a daro mana marejaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Bune ijiege kuaema areme Aeseki fune uri ire ka ma ireobo be kanafuima areme bune besu ire ijiakina do ijene i. ");
INSERT INTO bbb_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Areme nituame suoke e boeje bune urina e Ireobo ive ijia kuarana kuae nobe nuvue ziegafanamikiro noka besu kafae karikono kuaena abe marei. Ijiege rena Aeseki fune uri buina mukoreigia iviene uvia igege ananamima areme bune ijia nujana una aesakae buone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","33","Areme ve ijia e ije Aesekido imevo ije bu usiaena mako ije bu do jiadufuo ruiva ijene Aeseki kuarae. Bu kua, No do iviaeko be gaevano kuavoga fu do ije abe ive ina Sibano kuae. Ro Siba ijadufuo maeje ijeja Vua Kuaena Avenami. Ijadufuo iviama sidove ije e bu kua Biasibano kuavo. ");
INSERT INTO bbb_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Ro e Iso fu fivakuma juaevasia foti (40) ijiege furikoga fu uri bara inokiro aesakae Itaetiko ijene kei. Ro bara be ive fuone ije Jiudi fu e Birido kabae. Ro be ive fuone ije Basemate fu e Eronido kabae. ");
INSERT INTO bbb_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Bara inokiro ijiebe uri e Aesekikiro bara fuone Rebeka ijiebuo karivo ije buka dabe arafirijiae. Ijadufuo maeje Iso fu bara Itaetiko ije kema ijadufuo bu naebe oemare. ");
INSERT INTO bbb_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","2","Ijiege rena Aeseki fune ma eorena niome fuone fune iserei. Ijadufuo fu uri fari fuone amure e Isodo kiamoga bu mesiri ruae. Bu mesiri romoga asoefuo fu kuae, Farinono kuamoga fu onukuana kuae, Na igifurekino kuae. Areme Aeseki fu kuae, Iviama naeje naneka eoradie ijadufuo maza be na baronedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","4","Ijadufuo ni juvuave one kena va noefuo sume bijana fanuve be kanana abero ire mukore na idufuo ije kirama abe roga na ine. Na ire ije abe ina areme daro none abe una a manaro na baroneno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","6","Aeseki fu vua ijiege Iso kuarako bara fuone Ribeka fu mauike manina vua ije bu kuaevo ije fie. Ijadufuo Iso fune kekena sume bijana vakoga Ribeka fu uri fari fuone iviene e Jekafu vua kuarae. Fu kua, Jekafu farino asoe one fu vua ige uvia one Iso kuaramo na mauike fie. ");
INSERT INTO bbb_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Fu kuarana kua, Ani va fanuve bino kaniana ro ire mukore be noefuo kirana amaerima miega na ine. Na abe areme na E Ireobo ijadufuo nidua ijia daro none abena una a ma areme rade na barone. ");
INSERT INTO bbb_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Ijadufuo farino ni mukoreigia vua ige na kuaravo ije fiena ijiege rene. ");
INSERT INTO bbb_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ni va mave-goti no samuagiavo ijia ame mukore ubaeradiaeva ijia inokiro kena roga na ire mukore be asoe one fu oemarekinu idufuo ijene amaerina kirane. ");
INSERT INTO bbb_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Na kiga a abena va asoe one ije maga fu ina areme daro fuone ije a mana rade fu baroneno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Fu ijiege kuaramoga Jekafu fu una asie fuone kuae, Asieno, uvia none fu vajae jau nae ro naeje nana baki. ");
INSERT INTO bbb_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Ijadufuo asoe none fu na faradie fiega na biesirivo fu fiekuma na vierafe fube daro mieke. Rove fuka una na kuravajiena vafiekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Fu ijiege kuaramoga asie fuone fu kua, Farino fu a kuravajamo ije ni arega ije fu nana na abene. Ro aeje nime va mave-goti na kuaravo ije kena ro vajieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Ijadufuo fune va ire ije asie fuone fu kuaraema ije kena ro vajamoga fu kena ire ma mukore Aeseki fu oemarekinu idufuo ijene amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Areme Ribeka fu urina fari fuone amure e Isodo ugone ni mukore fu are ijia naema ijene kena una ame iviene e Jekafu saejae. ");
INSERT INTO bbb_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Fu ijiege re areme uri fanuve goti surive ijene kena umui ijiakiro kuri ije okuriaejae. ");
INSERT INTO bbb_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Areme fune uri ire ma mukore ije fu amaerima ijiakiro burete fu ifaejema ijene kena fari fuone Jekafu vajae. ");
INSERT INTO bbb_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Fu vajamoga Jekafu fune kena va asoe fuone kuae, Ate asoeno ige abeno kuae. Fu ijiege kuamoga Aeseki fu urina kua, Farinodoe, a e ige a Iso ke a eraneno kuae? ");
INSERT INTO bbb_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Areme Jekafu fu kuae, Na Iso fari one amure ije nare. Ro ire ije a kiema ije nane kirana abe igifureki ruae. Ijadufuo asoese ni urina fanuve ige na kirana ruaeva ije abe i fu madaga ni daro one ije abe mieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Ro Aeseki fu kuae, Farino a ire ije a izege ka migegire kena ruaemono kuae. Ro Jekafu fu biesirina kuae, Na E Ireobo Godi one ijare ifejiemo na kevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Fu ijiege kuaramoga Aeseki fu uri Jekafu kuae, Farino, ni biona ivuake igia roga na faradana fiega ane ma Iso ro a erarega na fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Fu ijiege kuaramoga Jekafu fune biona Aeseki fino ivuake ijia vakoga fu fare fie areme kuae, Itire one ige na fiega aka Jekafure kuaemo igeki rove farane one ije na fare fiega fu Isodo farane igekino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","24","Rove Aeseki fu naebe mukoreigia biekudina fie ro fume Jekafudo vajae u ije fare fiero fu Isodo faranero fu ijiege vierafei. Ijadufuo fune oemarena daro makiro vierafeba una kuke kuae, A e ige ane ma Iso areno kuamoga Jekafu fu biesirina kua, Ke ije nane ma Iso nareno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Areme Aeseki fu kuae, Farino nine ire ije a kena ruaema ije kena roga na ina areme daro none a mano kuae. Fu ijiege kuaramoga Jekafu fune ire ijiakina do vaeni ijene kena asoe fuone ije vajamo fu i. ");
INSERT INTO bbb_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Areme Aeseki fune uri Jekafu kuae, Farino, ni biona ivuake igia roga na uimidano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Ijadufuo Jekafu fune biona Aeseki uimimoga fu uri sinuome fu saema udi ije fiena uri daro mae. Fu mana kuae, Fari none ijadufuo udi ije fuka aesakae ije E Ireobo fu daro maema ijieki. ");
INSERT INTO bbb_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ijadufuo Godire saove ijia ve uruvana daga sakae ige fu saruigi rekina uije ma uruvana ro ire vaeni iviaeko buka uruvana tavuake. ");
INSERT INTO bbb_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Ro e aesakae gue ijia karivo uruvana bu una oefuo imekinu ro a kurituakafake. Ro are uviarafa one ijiebuo e ireobo rega asie one ijadufuo farirafa ije budua a kurituakafake. Ro erare a kuravajana vafavo ije Godire ve bu kuravajiana vafiake. Ro erare a ifejana daro mamo ije Godire ve daro miana ifejiake. ");
INSERT INTO bbb_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Aeseki fu Jekafu daro mamoga fune migegire kekena vakoga uvia fuone Iso fu rade ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Areme fudua fune ire ma mukore be amaerina kirama abe asoe fuone fino ijia ruae. Fu abe kekena kuae, Ate asoeno, ni urina ire ige na oefuo ifaejeva ije abe ina daro one na mieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Fu ijiege kuaramoga Aeseki fu kuae, A e gure a erareno kuae? Fu ijiege kuaramoga Iso fu kuae, Na Iso fari one amure ije nareno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Areme Aeseki fuka ireobo safuikinu uri kua, E ije bite erare fanuve ije kaniana romoga na ina daro none nane abe fu makoga a rade aru ruae? Ijadufuo daro ije nane abe fuone maedo fune maza boeje fuosiki na vadufuo ijadufuo na una izege abekuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Fu ijiege kuaramoga Iso fu vua ije asoe fuone fu kuaemo ije fiemo fuka ma isei. Ijadufuo fu uri urukeigia vijena nimekinu kuae, Ate asoeno, ni daro ije be duaku na mieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Ro Aeseki fu una kuae, Farino daro ije fune uvia one ijare biesiriemoga daro one a abedufuo ije nane abena una fu maevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Fu ijiege kuaramoga Iso fu kuae, Ive Jekafu ijadufuo maeje e biesiriamo ro fuje fune ma e ijieki. Ijadufuo maeje ige fu rema ije fu mazani inokiro na ijiege biesirie. Fu ijiege rena daro ame amure bu kevo ije nare abedufuo ije fune fure abei ro ivia fu kuke daro none a miedufuo ijene abejiemano kuae. Fu ijiege uri asoe fuone kuae, Ro a vierafe daro none be fube uria nado a abe na miekono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Fu ijiege kuaramoga Aeseki fu una kuae, Farinodoe, na daro ije fu e ireobo one redufuo ro e agane fuone boeje bu fuefuo imedufuo ije nane kena fu vajae. Ro kuke nane daro ije fu uije ro ine vaeni uruvana odufuo ije nane kena fu vajae. Ijadufuo farinodoe na ire be na una oefuo redufuo ije fuka ma bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Fu ijiege kuaramoga Iso fu uri asoe fuone soesoena kuae, Asoeno a isekie ni gaga daro be uria navoga ni abena naduaku mieno kuana fune ma urukeigia nimei. ");
INSERT INTO bbb_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Fu ijiege nimenoga asoe fuone fu kuae, Farino, are ije a finoedufuo ije a sakae saruebaki ro ka iriaeki ijia finoeke. Ro kuke sakae one ije fube ve dajiaeke. ");
INSERT INTO bbb_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ro aeje aka oemarekinu dazena finoekuma baki ro aka una e guena bijaekinu finoeke. Ro kuke aka uvia one ijadufuo moni baki imenoedufuo. A ijiege fuosiki nigaraenoeba uri fu abuena va osukua aebe finoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Iso fu daro ije asoe fuone fu abe una Jekafu maema ijadufuo fuka Jekafu ziegafana oe ise vierafe. Ijadufuo fu mauike fue kuae, Na oenoene ate fu barone na nimekiro vako ijia naka Jekafu kanakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ijadufuo Ribeka fu vua ije fiena uri kiamo bu Jekafu mesirina rovoga fu urina kuae, Uvia one ije fuka ziemo ijadufuo fuka naebe oemarei. Ijadufuo fu a biedakuma fuka kanakiro kuaemo na fie. ");
INSERT INTO bbb_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","45","Ijadufuo farino, ni ige na kuaravo ijiege rene. Anike migegire kona va sidove Erani maki none Rebani fino ijia va fuosiki maza sibaneke ijia fine. A maza sibaneke va ijia fike uvia one fu ire a rema ijadufuo defaruiga zienoeno ije fu una totega na ijare vua nijaga ni una rone ijadufuo maeje ame none inokiro ja maza besu ijia ja uniakodufuo ije naka isedie. ");
INSERT INTO bbb_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Areme Ribeka fu urina Aeseki kuae, Na Isodo bararafa are Itaetiko ije kame miako naneka isedieme. Ijadufuo Jekafu fu una igia bara Itaetiko abekuma na funeka isediedufuo ro bakuma naka baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Areme Aeseki fune Jekafu kumeno fu romo fu anaema areme kuae, A bara abekiro vierafekuma ade bara Kenanaetiko ije abeno. ");
INSERT INTO bbb_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ro nika va aesakae Mesofotemia ijia asae one Betuerodo are ijia e Rebani kaju one ijadufuo kabaerafa ijia be abene. ");
INSERT INTO bbb_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Na baname isoega Godi ka ma e daroki ijare bara ije one a abeno ijadufuo duvado ijia a daro maga a ame uruvana tua nake. A ijiege rekina are e boeje are irore igia karinoeva ijiebuo asoe reke. ");
INSERT INTO bbb_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Godire izege fu Eburame daro maema ijiege fu a ro uifare one ijene ijiege daro miake. Ro fure daro maga a aesakae ige Godi fu Eburame maema ije ja ijia kariva ijene foteke abe a makono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Aeseki fune Jekafu ijiege kuarana daro mamoga areme fune are Mesofotemia Rebani fino ijia vae. Ro e Rebani fu e Betuero e Aramiako ijadufuo fari ro kuke fu bara Ribekado maki. Ro Ribeka fuje fu Jekafukiro Isobuo asie. ");
INSERT INTO bbb_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","8","Areme rade e Iso fune fieke Aeseki fune Jekafu daro mana kuamo fu are Mesofotemia vaema ijiakiro izege fu bara Kenanaetiko abedufuo ije fu kuriaerena bijuima ijene fie. Ro kuke fu izege Jekafure orafa iriniana are Mesofotemia vaema ijiakiro izege fu bara Kenanaetiko ije fu abedufuo fu naebe oemarema ijene fie. ");
INSERT INTO bbb_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Ijadufuo fune va e Eburamedo fari e Isimaerodo kabae Marati bara Nebotido uvia ijene abei. ");
INSERT INTO bbb_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Areme Jekafu fune are Biasiba arena uri zinuevena una are Erani nake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Fune vakuma maza fune kokuveno ijia fu are be ijia kekena ijia naekiro fi. Areme fune uri are fu naedufuo ijene amaerima uri mune be abe adua nijana ijia ni nae. ");
INSERT INTO bbb_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Fu ijia naema naka nae gake siae ijare umeigia sana saove ijia ajia vakoga Godido anera ijiebe ijia ajia arive. ");
INSERT INTO bbb_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Areme fu kuke gake E Ireobo fu ivuake ikene fuone ijia manino fu gae. E Ireobo fu ijia manina kuae, Naeje na E Ireobo na Eburamekiro Aeseki ijiebuo Godi nare. Ijadufuo nare ae sakae ige a namo ije abe a ro uifari one ije miake. ");
INSERT INTO bbb_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Ro uifari one buka kuokuo ije bu dakuva baki ijiege e uruvana reke. Ro bure aesakae igia karijana dabe biona binobino vake. Ro kuke nare a ro uifari one ijiebuo duvado ijia e boeje aesakae irore igia karijo ije daro miake. ");
INSERT INTO bbb_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ro ni vierafe iziebure a oenoeno ije nana uria ijia osiki oenoeke. Nare a samuaga oenoena areme mesira una sakae igia ruake. Nabe a abuoza vakiro naka osiki oenoekina irere na kuaraeva ije naka rena furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Areme Jekafu fune urina fue kuae, E Ireobo fuka igia fine! Fu are igia fiko na naebe mukoe gaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Ro Jekafu fuka juimo fu kuae, Are ige fuka are ni be. Na vierafe naka Godido are igia aru five. Are ige fu saove gufadufuo viene fu daovena namo ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Areme nituame suoke mugamia Jekafu fune mune fu abe nigofo nijaema ije abena nuga fu ijia gakinu oenoedufuo ije sana amaerima areme fune oere abe ado ijia usiana abe una Godi mae. ");
INSERT INTO bbb_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Fu ijiege re areme are ije fu abe ive ina Betero kuae. Ro ive Betero ijadufuo maeje ijeja Godido Are. Ro are ije ude bu Ruzino kuavo. ");
INSERT INTO bbb_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","21","Ijiege re areme Jekafu fune uri E Ireobo ijiaki vua be kuae avenamina abe marei. Fu kuae, E Ireobo a vame ige na vako ijia mukoreigia samuagiena irekina sinuome ijene ifejiega na oemarekinu oenoena areme una ruoma na asoe none ijadufuo are ijia kekekuva naka maza boeje a oetuakinu baname isoe kafake. ");
INSERT INTO bbb_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Ro mune ige na abe amaerima sana nuga nijana vako ije e boeje no una are igia a dabe nidosakinu arorana baname isoekafake. Na ijiege re ro uri ire boeje are ifejiena vajiema ije akaegue (1/10) kena una a vajakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","2","Ijiege rena Jekafu fune una kuke urina vakuma are be maza ajiamo nake e bino bu karivo ijia vae. Fu ijia kekena gake mako ireobo be bu do jiana mave-buone vajiavo fu ije gae. Ro mave-sifi ije bu atana inokubeke afuima areme bu do ikuae irifo ijia umeke naona ufuaenoena arei. Ro mako ijadufuo itire bune mune ireobo ijia dabe bijukurae. ");
INSERT INTO bbb_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Ro mazani ije mave-sifi boeje bune ro ijia besu afuivo ijia e ije bu samuagiavo ije bune va mune ireobo ije abe bio nijae. Areme bune do jiana mave-sifi boeje ijiama areme bune mune ije abe una are fuone ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jekafu fu ire boeje giama areme urina e ije mave-sifi samuagiavo ijene kiae, Kairafano, ja izia ruaevano kiae? Fu ijiege kuariamoga e ije bune una gue kuae, Noeje no are Erani ijia ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Bu ijiege kuaravoga Jekafu fu una kuke kiae, Ro ja e Neodo asae e Rebani kuavo ije jabe vierafevano kiae? Fu ijiege kiamoga e ije bu kua, Ke e ije none vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Bu ijiege kuaravoga fu kiae, Ro fube ma fino kiamoga bu kua, Fu ma fine. Ro ni garia gane Rebanido kabae Resero fu mave-sifi uruvana kaenamia ruomo ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Areme Jekafu fu una kiae, Maza ige fuka uria rove jane kaenamia ruove. Ijadufuo ni kaenamia do jia vajia bu iga nine una kaenamia va bu garasi ino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Fu ijiege kuariamoga bu kuae, Nobe ijiege rekiro no areke boeje bu igia rua furiga no ijare mune abe bio nijaeme do jiana mave-sifi ije ijiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","10","Bu uria ijiege irena Jekafu kuaravo ijia bara Resero fu asoe fuone ijadufuo mave-sifi boeje kaenamiana ijia kekei. Areme Jekafu fu gake kaju fuone e Rebanido kabae Resero fu romoga fune va mako itire bu bijukuraeva ije abe bio nijae. Fu ijiege rei reme fune uri do jiana e Rebanido mave-sifi ijene ijiae. ");
INSERT INTO bbb_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Areme Jekafu fuka oemaemoga fu uri bara ije abe uimina ireobo nimei. ");
INSERT INTO bbb_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Fu nimena areme uri kuae, Naeje na asoe one ijadufuo agane bara Ribekado farino kuae. Fu ijiege kuaramoga bara ije fune una difurina va asoe fuone fino ijia kekena vua ije kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Fu va kuaramoga asoe fuone fu kaju fuone ijadufuo vua ije fiena fune difuri Jekafu biekiro ruae. Fu ro gumia kekena uro urasena uimi areme mesirina una are fuone ijia vae. Areme Jekafu fune uri vua boeje fu izege rena vaema ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Fu ijiege kuaramoga Rebani fu kuae, Ke, ije ane ma kuarieme ijadufuo aeje ane ma kavuane none besuno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Rebani fu ijiege kuarama arekoga Jekafu fune una asame besu ijia fuosiki fi. Areme maza be Rebani fune Jekafu kuae, Noeje no agane ijadufuo a irerefuo ame ijia noefuo moni baki imedufuo? Ijadufuo a vierafe na moni izege a vajakono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","17","Ro e Rebani fu kabaerafa inokiro ro amure ijadufuo ive ije Ria ro iviene ije bara Resero. Ro bara Riado niome ije fume sibaneke maeje. Ro Resero fuje fuka bara nikubae mukore. ");
INSERT INTO bbb_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Ijadufuo Jekafu fuka bara Resero ireobo oetuae. Ijadufuo fu uri e Rebani kuae, Na vierafe a kabae one Resero abe miega na juaevasia umui fague ro dikine inokiro (7) ijiege oefuo imejano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Fu ijiege kuaramoga Rebani fu una kuae, Na bara ige nabe abe e bino miadufuo. Ro na vierafe naka abe a make. Ijadufuo aeje ni nosiki-igia fino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Rove Jekafu fuka Resero ireobo oetuaema ijadufuo fu juaevasia seveni (7) ijiege fu bara Reserodo imeko mazani fune migegire furikiro ubine ijia ruome. ");
INSERT INTO bbb_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ijadufuo Jekafu fune uri Rebani kuae, Maza ije a kiema ije fune furi ijadufuo ni iviama kabae one Resero ijene abe miemo kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Ijadufuo Rebani fune uri iro ije be bu maninamikuae ivo kanafuima areme uri e uruvana kumeno bu iro ije sarei. ");
INSERT INTO bbb_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Areme muge ijia Rebani fu uri Resero fu aregana una Ria kabae fuone amure ije mesiri nujaejamo fu Jekafuki nae. ");
INSERT INTO bbb_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Rebani fu ijiege rei areme uri bara kabaekua Zirufano kuavo fu fuefuo imeno ijene mesiri Ria nujaejae fu fuefuo imekiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Areme nituame suoke ijia Jekafu fu uri gake fu bara Riaki naemaga fuka ireobo zie. Ijadufuo fu va Rebani kuae, Na i boeje na menoeva ije na Resero abekiro na ijadufuo rei. Rove a irerefuo na biesiriena ijiege remano kuae? ");
INSERT INTO bbb_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Fu ijiege kuaramoga Rebani fu kuae, No vame nuvuoenina no kenoevo ije no kabae iviefari ije no ude ke baru vajiavo baki. ");
INSERT INTO bbb_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Ijadufuo ni samuake fura ige ja maninamiva ije fu furiga na sone Resero abe mano kuae. Ro na ijiege rekuva ije a una kuke juaevasia seveni (7) ijiege noefuo igia fina imega na Resero abe mano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Fu ijiege kuaramoga Jekafu fune oemare areme rade fura ije bu maninamiva ije fune furinoga Rebani fu kuke una kabae fuone Resero abena Jekafu mamo fu abei. ");
INSERT INTO bbb_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Areme Rebani fune bara kabaekua fuone imeno be bara Bira mesiri Resero nujaejamo fu fuefuo imei. ");
INSERT INTO bbb_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Ijiege rena Jekafu fune bara Resero mesirina fuosiki nae. Ro Jekafu fuka Resero ireobo oetuagaro Ria fume sibaneke oetuae. Areme fune kuke una Rebanido ime vakuma juaevasia seveni ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ijiege rena E Ireobo Godi fu gake Jekafu fu Ria sibaneke oetuagaro Resero fuka ireobo oetuamo fu ije gae. Ijadufuo fu Ria oemarejana ifejamo fu ame nafekoga Resero fu debirei. ");
INSERT INTO bbb_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Areme Ria fune e fudiena ame fari be bieteina abe ive ina Rubeni kuae. Ijadufuo maeje fu kuae, Iviama E Ireobo fune irufui none ije giema ijadufuo na vierafe Jekafu fune una na oetuakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Ijiege rena Ria fune una kuke fudiena ame fari be bietei. Areme fu kuae, E Ireobo fu una ame fari bedua mie ijadufuo maeje fu giega Jekafu fu na naebe mukoe oetuamono kuae. Areme fu ame ije abe ive ina Simioni kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Areme Ria fu una kuke e fudiena ame fari be bietei. Ijadufuo fu kuae, Iviama ijare baru none fuka nanaru oetuakinu vierafeke. Ijadufuo maeje na ame fari inokubeke nafevano kuaena fune uri ame ije ive ina Rivae kuae. ");
INSERT INTO bbb_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Areme fu una kuke e fudiena ame fari be bietei. Areme fu kuae, Iviama naka E Ireobo ijadufuo oemareke. Ijadufuo fu uri ame ije abe ive ina Juda kuae. Areme Ria fu ijia ame fu nafeno ije fune ijia arei. ");
INSERT INTO bbb_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ro Resero fu Jekafudo ame bino fu naebe nafe vajae ijadufuo fu uvia fuone ije oe isema vierafena fu ziegafae. Fu ijiege rena uri baru fuone Jekafu kua, A iviama nosiki naega na ame bino nafene ro a bakikuma naka baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Fu ijiege kuaramoga Jekafu fu vua ije fiemo fuka defarui ijadufuo fu urina Resero kua, Vame ije ame nafedufuo fune Godire fuone vierafema ijia bijukurae. Ro naeje na izege Godi asina vame ijiege rekono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Fu ijiege kuaramoga Resero fu kuae, Ni Bira bara ije fu noefuo imeno ije fuosiki naega fu ame nafega na fuone duvado ijia ame ijene kena none samuagiano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","5","Areme fune bara Bira kuamoga fu baru fuone Jekafuki naenoga fu efudiena ame be bietei. ");
INSERT INTO bbb_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Areme Resero fu kua, Iviama Godi fune irere na vierafeva ijene mukoreigia giena na vafarie. Ijadufuo fu baname none fiena ame fari ige miemano kuaena abe ive ina Deni kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","8","Areme Bira fu una kuke e fudiena Jekafudo ame fari bedua bietei. Ijadufuo Resero fu kua, Na uvia none ijiaki nigaraena ruoma nane nare iraraena fu asivano kuaena fune uri ame ije abe ive ina Natari kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Areme maza be Ria fu vierafega ame fu nafeno ije fune ijia arei. Ijadufuo fu uri Zirufa bara ije fuefuo imeno ije mesirina Jekafu nujaejamo fu abei. ");
INSERT INTO bbb_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","11","Ijiege rena bara Zirufa fune Jekafudo ame fari be biete. Areme Ria fune uri kuae, Magoeno kuaena uri ame ija abe ive ina Gedino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","13","Ro rade Zirufa fu una kuke Jekafudo ame fari bedua bietei. Ijadufuo Ria fu oemaemo fu kuae, Iviama naeje naneka oemadieme. Ijadufuo bara boeje bu na kieko Bara Oemaremo Ijieno kiekono kuaena fune uri ame ije abe ive ina Ase kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Areme mazani ije juare masivo ijia Rubini fu va juare ijia oenoena ine menidirekino kuavo ije bino giae. (Ro ine menidireki ije bu bara ame nafevo baki ije bu ine ije nafe ikuva bu e fudieke). Ijadufuo Rubini fu ine ije bino nafena kari ro asie fuone Ria vajae. Ro Resero fu uri kuae, Aesekie ni ine manidireki ije ame one fu ke ruaema ije bino na vajieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Fu ijiege kuamoga Ria fu una gue kuae, A baru none ane abena one rei. Ro a irerefuo una kuke fari none ijadufuo ine menidireki ije abekuveno kuae. Fu ijiege kuaramoga Resero fu una kuae, A fari one ijadufuo ine menidireki bino vajiekuma ivia muge na kuaga a Jekafuki naekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Areme Jekafu fu vuiti juare gamia oenoena mufuo fu una are romoga Ria fu va vame gafia biena kuae, Ivia muge a nosiki naeke. Ijadufuo maeje na fari none ijadufuo ine menidireki nane kena a fuaevevano kuae. Ijadufuo Jekafu fune muge urina Riaki nae. ");
INSERT INTO bbb_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","18","Ijiege rena Godi fune Riado baname ije fiena ifejamoga fune una kuke e fudie. Areme fune ame fari bedua nafenoga fune Jekafudo ame umui fague rei. Areme Ria fu kuae, Godi fune na irerefuo bara ije none imeno ije na abena baru none maeva ijadufuo ve gue una vame maeje none remano kuae. Areme fune ame ije abe ive ina Isakano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","21","Areme Ria fu una kuke Jekafudo ame bedua nafemo fune ame umui fague ro dikine besu rei. Areme fu kuae, Godi fuka ire ma mukore ije na miedo iviama baru none fuka oemarekinu na mesirieke. Ijadufuo maeje nane ame umui fague ro dikine (6) ijiege nafe vajae. Ijadufuo fune ame ije abe ive ina Zeburuni kuae. Areme radekuma ije fu ame kabae be bietena abe ive ina Daenano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Areme Godi fune Reserodo baname ije fu isoema ijene fie ijadufuo fu ifejamoga fu ame nafei. ");
INSERT INTO bbb_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Ijadufuo Resero fune e fudiena ame fari be bietei. Areme fu urina kuae, Godi fune iviama oefiane none na abeva ije dasumie ijadufuo fu ame fari ige mie. ");
INSERT INTO bbb_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Areme fune ame ije abe ive ina Josofuno kua areme kuke kuae, Na vierafe E Ireobo fu una ame fari bedua miekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Ijiege rena Resero fu Josofu bietemoga Jekafu fune urina Rebani kuae, Iviama nane una are none ijia vakiro vierafe. Ro izege na oefuo i mukoreigia mekinu ifejaeva ije ane vierafe. Ijadufuo ni bara none ro ame none boeje na keva ijene vajiega na kaenamiana vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","28","Rove Rebani fu una kuae, A vierafe a none oemarekuma ni igiafine. Na adame na fieva ijadufuo duvado ijia na gaga E Ireobo fu one duvado ijia ige a nosiki fima ijia funeka na daro miena ifejie. Ijadufuo ni irere a vierafema na naebe vajaeva ije ni kiega na fuaeveno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Fu ijiege kuaramoga Jekafu fu una kuae, Na vierafe a izege oefuo imekinu fanuve one samuagiavoga buka ma uruvana reva ije ane vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Ude mave-sifi one bu naebe uruvana rei rove mazani ije na ruaeva ijia buka ma uruvana rei. Ro are boeje iziebure na oenoeva ijia E Ireobo fuka a daro mana mukoreigia ifejamoga ire boeje buka maradiae. Ro naeje na izege reke? Ijadufuo iviama nine irere na rade ijia bijua fidufuo ije vajieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","32","Fu ijiege kuaramoga Rebani fu kuae, Ro a vierafega na irere ije abena a fuaevekono kuae? Ro Jekafu fu una kuae, A na moni ijia fuaevedufuo ije na isedieme. Ro a oemarekuma ni vua ige na vierafeva ijiege rene. Na vierafe naka uria mave-sifi one ije samuagiake. Na vierafe na mave-sifi ame kazine ro goti ame ni turaeturaeki one boeje karina va none samuagiakiro vierafe. Ijadufuo na vierafe a ire ijiege na fuaevedufuo ");
INSERT INTO bbb_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Na ijiege rekina maza rade a na gieke vuako ijia a vua giaga mave-sifi ro goti ni bino none baki bu ijia oenoevoga a ijia giana vierafero nane nare iniemevaro a ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Areme Rebani fune una kuae, Vua ije aka ma kuariemo ijadufuo nane oemarei. Ijadufuo nine ije a kuariemo ijiege reno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Rove Rebani vua ije fu kufuimena kuae ijadufuo maeje rade Jekafu fu vakoga Rebani fu mazani besu ijia kekena goti baru ro bara ni turaeki ro abaeki ro mave-sifi kazine boeje kaenamiana una va ae be ijia uniae. Areme fune farirafa fuone kiamo bu va samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Areme Rebani fune urina are be ka ma mumabo ijia vae. Ro are ije fu vaema ije bu muge inokubeke ijiege akoena vako ijia vagana Jekafu fu ijia arena vae. Fune ijiege vakoga Jekafu fu urina mave-sifi gue kazine ro turaeturaeki baki ijene samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Areme maza be Jekafu fune va ine binobino fofirakina amoni ro ine fireni kiaje ikuki bino buvuana surive gue azovo buka turaeturaeki rei. ");
INSERT INTO bbb_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Fu ijiege rena fune ine kiae ije karina va do ije mave-sifi binobino bu ro ivo ijia urui. Fu ijia uruima ijadufuo maeje mave ijia bu ijia do ikuae ruovo ije bu ine ije rotire ijia bue nakusenamivo. ");
INSERT INTO bbb_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Ijadufuo maza ije fanu goti bu ro ine ijiebuo rotire ijia nakusenamivo bu ame turaeturaeki ije nafevo. ");
INSERT INTO bbb_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Ijiege rena Jekafu fune mave-sifikiro goti fuone ije atana ije fu be uniaga goti fu bino uniae. Ro nikubae buone bu una game Rebanido mave-sifi kazine ro goti ni turaeturaeki ije bu ireva ijanake uniae. Ro fu naebe karina Rebanido ijiakuma besu uniae ijadufuo fanu fuone fuka migegire uruvana rei. ");
INSERT INTO bbb_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ro maza ije Jekafu fu giaga fanu irave daroki ije bu bue nakusenamikuvejo ije fune uri ine kiaeje turaeturaeki ije karina va do bu ivo ijia urumo. Fu ijiege rekina fanuve bu do ije ikuae ruovo ije bu ine ijiebuo kafare ijia nakusenaminoekiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Ro fanu garuki ije bu ro do ijia bue nakusenamivo ije Jekafu fu ine kia ije urujiamo baki. Ijadufuo Rebanido fanu boeje buka garuki ijiaru ro Jekafudo ije buka vajae maturaena ubaeradiae. ");
INSERT INTO bbb_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Ro Jekafu fu Rebani ni sauikurana vame ije rema ijadufuo rade sinuome fuone fuka ma uruvana zarae. Fu sinuome ijiaru zaraema bakiro fu kuke e fuone i mevo ijiakina mave-sifi kina kamerokina doniki ijia ka uruke zarae. ");
INSERT INTO bbb_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ijiege rena maza be Jekafu fu fieke kaju fuone Rebanido anafa fari ije bu kuae, Iviama Jekafu funeka e anuigi rena sinuome zarae. Ijadufuo maeje fu ire boeje asoe nuvuone fu kema ije fune fure kari furimano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Ro kuke Jekafu fu oenoekinu gake kaju fuone ije fudua fu naebe izege fu ude oemarekinu renoema ijiege renoeno fu gae. ");
INSERT INTO bbb_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Areme maza be E Ireobo fu Jekafu kuae, Nine una urina asaerafa one ijiakiro uviarafa one ijiebuo sakae ijia vane. Ro a vako ije naeje na osiki ijia vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Ijadufuo Jekafu fune e fuone imevo ije kiamo bu bara Resorokiro Ria kumevo bu are ije fanu fuone boeje bu afuina oenoevo ijia fu biekuae ruae. ");
INSERT INTO bbb_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Bu rovoga Jekafu fu urina kiae, Na gaga asoe jone ije fu naebe una ude izege fu nosiki maremo ijiege reme. Rove asoe none ijadufuo Godi ije fuka uria nosiki. ");
INSERT INTO bbb_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ro izege na daro mena asoe jone ijadufuo imeva ije bara inokiro gure jane giena vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Rove fuka uria na biesirikinu ire ije fu vajiekono kiemoga na ijadufuo imeva ije ma uruvana fu naebe kena vajie. Rove Godi fuka na mukoe samuagie ijadufuo fu naebe na kanie ro ire bino rei. ");
INSERT INTO bbb_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Na mazani ije Rebani fu kie, Na mave goti turaeturaeki ije a vajakono kiemo ije mave goti boeje buka ame turaturaeki uruvana nafevo. Ro fu oenoena una kiemo na goti kazinekiro abare ririseva ije vajakono kiemo ije mave-goti boeje buka ame ni ijieki uruvana nafevo. ");
INSERT INTO bbb_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Ijadufuo Godi fu ijiege rekinu asoe jone ijadufuo mave boeje funeka karina na vajie. ");
INSERT INTO bbb_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Ro mazani ije mave goti kumate bu buone nakusenamivo ijia na muge naka naena mave goti kazine ro abaeki iriseva ijiakina turaturaeki ijene giae. ");
INSERT INTO bbb_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ro Godido anera ije fu na kie, Jekafuno kiemoga na onukuana kuae, Na igifurekino kuae ");
INSERT INTO bbb_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Na ijiege onukuavoga fu kie, Mave goti kumate boeje bu nakusenamivo ije buneka turaturaeki ro kazinekiro abaeki ririseva ijiaruno kie. Na ijiege revo ijadufuo maeje na Rebani vame izege fu one remo ije nane gae. ");
INSERT INTO bbb_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Naeje na Godi ije na are Befuero ijia biedaeva ije nare. Na ijia biedavoga a vua be nosiki kuaena nuga be ijia nijae. Ro nuga ijeja a mune ijia sana amaerima areme oere abe ijia usiae. A ijiege rekina a ijia gakinu oenoekiro a ijiege rei. Ijadufuo iviama sinuome one ije kanafuima areme ni una urina sakae ije bu a bietanaeva ijia vano kiemano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Jekafu fu ijiege kuariamoga Riakiro Resero bu una kuae, No asoe nuvuone ijadufuo ire ma bino no una irere ijene kekuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Fu noeje fuka bara ae binoko igege kame fuaevena moni ije fu abema ije fune inama furi. ");
INSERT INTO bbb_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Ro kuke asoe nuvuone ijadufuo ire boeje ige Godi fu kena una a vajaema ije funeka anafa nuvuone ijena nuvuone. Ijadufuo nine Godi irere fu kuaramo ijia reno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Bu ijiege kuaravoga Jekafu fune una Kenani asoe fuone e Aeseki fino ijia vakiro sinuome fuone kanafui. Areme fune uri ame fuone ijiakiro bararafa fuone ije kaenamiana fanu kamero ijia uniae. Areme fune uri e fuone imevo ije kiamo bu uri ire fuone maeje boeje fu Mesefotemia ijia fikinu karima ijiakina fanu fuone boeje fu saema ijene kaenamiana bune ude vakoga Jekafu rade mani. ");
INSERT INTO bbb_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Bu uria vakuae sinuome kanafuinoevo ijia Rebani fune kekena are mave fuone fu uniana samuagiamo ijia mave u ijene ufukiro vae. Fu ijia vakoga bara Resero kabae fuone fu are ijia aruna asoe fuone ijadufuo godi kufui fu fuone baname isoemo fu uijaema ijene mauike abei. ");
INSERT INTO bbb_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Ijiege rena Jekafu fu naebe Rebani nijaemo fu vierafekoga fune mauike kona vae. ");
INSERT INTO bbb_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Jekafu fune migegireigia urina ire fuone boeje fu kema ijene karima areme fune kona vakuma do Iufureti tuana fune ura Giriedi are uruo ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Areme fune mu inokubeke furikoga bu ijia sone Jekafu fu kona vaema ijene Rebani kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Ijadufuo Rebani fune uri e gue kaenamiana rade nuvediana vakuma mazani seveni (7) ijiege furiko bu ijia bu uruo Giriedi ijia Jekafu bie. ");
INSERT INTO bbb_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Rebani fu rade Jekafu bie ro ude fu naemaga Godi fu ari naka urana kuae, A va Jekafu biekuma ade vua ise ro ma bino fu kuarakumano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ro Jekafu fune ude uruo be makave ijia kekena are muvuaka fuone sae. Fu ijiege rekoga Rebani fu dua fu e fuone ijena uruo Giriedi erafa fuone bu kariva ijia are muvuaka buone sae. ");
INSERT INTO bbb_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Areme Rebani fune urina Jekafu kuae, A irerefuo na biesiriena kabaerafa none ijene e dibureko igege kaenamiana kono ruae? ");
INSERT INTO bbb_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","A ruakiro vierafekuma ni kuarie na fieke a ruakuma. A irerefuo ame mauike fekuriena ruae? A ruakiro kuarie bitie naka zaekiro dideve ijia oemarekinu a dua urukafakinu mesira ro vame nujaga a ruake. ");
INSERT INTO bbb_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","A areke na asaerafa none ijiakiro kabaerafa none ijene anadiakinu ui midiaga a kaenamia ruakuma. A vame ije a naebe ijiege rei ro aka isema rei. ");
INSERT INTO bbb_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Na a dabe isema rena vajae fiane vajae bitie na daro nado na ijiege redufuo. Rove na muge naevaga asoe one ijadufuo Godi ijare naka urana kie, Ade va ire ise bino one remono kie. ");
INSERT INTO bbb_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Rove na vierafe aka oe ireobo una migegire asoe one ijadufuo are ijia vakiro vierafe ijadufuo a ije kona ruomo ije fune marei. Rove aka godi none na baname isoevo na are ijia nijavo a ijene a iniemejie ruaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Rebani fu ijiege kuaramoga Jekafu fu una kuae, Na vierafero bigake a kabaerafa one ije una tura vakiro na jumena mauike kona ruae. ");
INSERT INTO bbb_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nine e boeje no igifure kari gavono ni sinuome nuvuone boeje no naeva ijia rerene. A ijia rerenoega ire one be fu ijia navoga ni abene. Ro e ije erare ire one ije abe ruaema ije nika kana fu baroneno kuae. Rove Resero fu asoe fuone ijadufuo ire fu baname isoemo ije fu iniemena abe ruaema ije Jekafu naebe vierafema ijadufuo fu ijiege kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Areme Rebani fune urina Jekafu are muvuaka ije fu saema ijia aruna oenoekinu ire fuone ijene rerei. Fi ijiege rerena vakuma Riado are ijiakiro bara inokiro moni baki imevo bu karivo ijia aruna rerei. Fu ire fuone ije ijia rerenoega baga fune kuke kekena kabae fuone Resero fu fino ijia vae ");
INSERT INTO bbb_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Rebani fu ijiege rerena vuakoga Resero fune uri godi kufui fu abe vaema ije abena kamero ijadufuo kamui ijia kedena ado ijia ajiana fine. Fu dabe ijiege nurie fikoga Rebani fu are boeje rere fune furi. ");
INSERT INTO bbb_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Areme Resero fu urina asoefuo biesirina kuae, E ireobo nana noe fivo ijadufuo na izege urikuva baki. Ijadufuo ade na ziegafiemono kuae. Ijiege rena Rebani fune are boeje rerenoegake godi fuone fu baname isoemo ije fuka baki. ");
INSERT INTO bbb_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Fu ijiege rerenoenoga Jekafu fu ije gamo fuka ma ireobo defarui. Ijadufuo fu urina kuriaekuriaeki Rebani kuae, Naeje na ise ije na irere ije rei? Ro akae ije na irere ije abe tuaseva ijadufuo a na reriena dabe arafirie ruae? ");
INSERT INTO bbb_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ro a ro sinuome none boeje a ro rerema ijia ire one na abe ruaeva ije ane gana abei? Ane abevoga ni abe samadukua guria nijaga e one ro none bu ijia gana erare fu mukoe rema bu ije vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Nana osiki finoeko fune juaevasia tuaedi (20) ijiege furi. Nare osiki finoeva ijadufuo mave-kiro goti one buka ma uruvana nafemanami. Ro kuke one a saema ijia be a naebe kiemo na kana i. ");
INSERT INTO bbb_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Na mave bino bu oenoena siroe kuriae ijiebe sakia i ro bu irufui abega na ro kuaravo ije a fiena amaerimo baki. Ro mave bu ijiege revo ije naneka nosukua irufui ije abevo. Fanu kuriae bu muge ro maza ijia ro mave one sakiaga na ro a kuaravo ije aka una na kiega nare irufui ijene amaeriavo. ");
INSERT INTO bbb_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Naka maza kekena kanie ro muge iduadiemo ije na fievo baki. Ro naka ijia faememarena oefuo isejavaena ari fi ro ni mukore naevo baki. ");
INSERT INTO bbb_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Na juaevasia tuaedi (20) na osiki fina ijiege isejavae. Na juaevasia fotini (14) ije na kabaerafa one ijiebuo imekiro sigisi (6) ije na mave one a saema ijiebuo imei. Na ijiege ime rove a uria na biesiriena ire none a vajieko kiemoga na imeva ije ma uruvana a naebe kena vajie. ");
INSERT INTO bbb_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Ro asaerafa none e Eburame ro Aeseki ijiebuo Godi ije fu naebe nosiki oenoeno bitie naeje ane isuibe rorukuriega nane ikiriasa vadufuo. Rove e Ireobo Godi fu irufui none ijiakiro i ije izege na oefuo menoeva ije fune gie. Ijadufuo fune fure muge noka ijia a samadukua visuna noesina kuaraemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Jekafu fune ijiege gikikimana kuarama furinoga Rebani fu una kuae, Ire boeje guraeje a abema ijiakina kabaerafa none inokiro ijiakiro anafa buone ije buneka none ijiaru. A ire none boeje ane ijifureki karima fune furi ijadufuo ro iviama na una izege rena bu kaenamiake? ");
INSERT INTO bbb_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ijadufuo na vierafe naka osiki vua kuae avenaminina abe mareke. Ijadufuo roga no mune guria kena sa amaerikina no ije gavo ijia no una vua irere no osiki kuaeva ijene vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Areme Jekafu fune urina mune be bu ijia gakinu oenoedufuo ijene abena ijia sana amaerima areme ijia arei. ");
INSERT INTO bbb_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Jekafu fune ijiege rema areme uri e fuone imevo ijene kiamo bune kuke mune bino kari ijia akoena ajiae. Areme bune ivuake irifo ijia karina Rebanina besu ire ina oemarei. ");
INSERT INTO bbb_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Bu ijiege reva ijadufuo Rebani are ije fu abe ive ina Jega Saradutano kuae. Rove Jekafu fuje fu abe ive ina kua Garidino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Areme Rebani fu urina Jekafu kuae, Mune ige no karina naeva ije no osiki ijia gakinu oenoedufuo ijeneno kuae. Jekafu fu Rebaniki vua ijiege kuaeva ijadufuo are ije fu kua Garidino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Ro kuke are ijadufuo ive be bu kua Mizifaro kuae. Ijadufuo maeje Rebani fu kuke kuae, Na vierafe E Ireobo ijare no osiki iziebure no oenoevo ijia samuaguoko no kuaema ijadufuo bu ijiege kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Rebani fu ijiege kuara areme kuke kuae, Ade bara kabaerafa none ije isema samuagiamo ro ade una bara bino kemo. Ro a ijiege rekuma ni vierafero Godi funeka samadukua guoko no oenoevoro a ijiege vierafene. ");
INSERT INTO bbb_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Ro ni mune ige na kari naeva igiakiro mune gare a abe saema ije giane. ");
INSERT INTO bbb_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Mune ije bu nuga nuvuone no ijia giakinu oenoedufuo. Naeje nabe oenoene nuga ige no naeva ijene asina ura a kana ro vajae fiane vajake. Ro a dua abe nuga ije asina na kanie ro vajae fiane vajieke. ");
INSERT INTO bbb_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ro no oenoene izege rekuva na vierafe Eburamekiro Neo ijiebuo Godi ro kuke asoe buone ijadufuo Godi ijare no kena mazie guokono kuae. Areme Jekafu fune uri asoe fuone Aesekido Godi ijadufuo ive ijia kurana kuae vua ije fube totekiro fuka uria vierafekinu oenoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","55","Bune ijiege kuaena Jekafu fune uri fanu be kana dabe uruo makave ijia Godi oemarejana zinone ifaejei. Areme fune uri ire kirama areme erafa fuone ije kiamo bu ro besu afuina i. Bu ire ije uruo makave ijia ina naoeva suoke Rebani fune uri kabaerafa ijiakiro asaerafa ijene ui midiana anadiama areme fune una are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ijiege rena Jekafu fune urina vakiro vakoga Godido anera bino bu arina vame ijia bie. ");
INSERT INTO bbb_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Fu ijiege biedia areme uri kuae, Are ige Godi fu ijia fino ijeno kuae. Ijadufuo fu uri are ije ive ina kuae, Maranaemino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","4","Ijiege rena Jekafu fune bo fuone e Iso aesakae Idome ijia fino ije vua ijiege nijamoga e vua abe oenoevo ije bu vua ijene abena vae. Ro vua fu ijiege nijana kiae, Ni va e ireobo none Iso kua, Na uvia one Jekafu e ije oefuo imeno ije nare vua ige a kuarave. Na kaju none e Rebaniki finoevo ijadufuo na naebe migegire urina vuae. Ro na fina areme ivia ijare nane una ruove. ");
INSERT INTO bbb_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Nana mave kau ro ro gotikina donikikina kamero ijene ka uruvana sae. Ro kuke na e none moni baki imevo bara ro baru ije uruvana. Ijadufuo e ireobo none a isekie a na oemarejiekuma ni ijiege kuariega na fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Jekafu fu ijiege kuariamo bu vaeva una usiaena kuae, No vua one abena Iso kuarakuae vae. Rove no vaga uvia one ije fune a biedakiro e fuone uruvana fo aderedi (400) ijiege kaenamiana vame ruomono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","E ije bu vua ijiege Jekafu kuaravoga fu vua ije fiemo fuka oe ireobo fiaemo fu uri jumei. Ijadufuo fune uri e ije fuina vako ije ke atana be uniakinu be uniae. Areme fune uri mave-sifi ro goti ro kau ro fanu kamero ije duaku ke atana binobino uniae. ");
INSERT INTO bbb_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Fu vierafero Iso fu e fuone ijena ro fu biena uri e guena bijaekuva gue bu subi vakiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Areme Jekafu fune uri Godi baname isoena kuae, Godi asae none Aesekikiro Eburame ijiebuo Godi baname none ige na isoena kuaravo igene fiene. E Ireobo none a kie, Ni una urina aesakae one ijiakiro e uviarafa one kariva ijia vano kie. A ijia vaga nare a samuagana ifejaga ire boeje fuka mareno kie. ");
INSERT INTO bbb_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Na nosukua naka izege maza boeje ijuebaki rena ire boeje oetuana mukoreigia ma ijiaru a nijasiema ijiege renoekuva baki. E Ireobo none ude na do Jodeni tuana ruvaeva ije name mudu ijiaru abe bijuasana ruvae. Rove iviama naka una zaraezaraeki ruovo ijadufuo na e igene kame atana igifureki inokiro uniavo ige giene. ");
INSERT INTO bbb_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Na vierafe uvia none Iso fu ruakuma fuka e boeje ige bara ro baru ije kanuoga noka oe furidufuo. Ijadufuo naka judiemono E Ireobo baname ige na isoena kuaravo igene fiena ifejuone. ");
INSERT INTO bbb_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","A kie nare a samuagana ifejakinu marejaga a mukoreigia e uruvana ire ajare davare irifo gamia naovo e bu dadufuo baki ijiege vajakono kiema ijene vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Jekafu fune ijiege baname isoema furina fune ijia nae. Areme nituame suoke fune urina uvia fuone Iso subijakiro fuefuo subine mukore ijiaru kanafui. Ijiege rena Jekafu fune uri mave-goti irave tu aderedi (200) ke areme kumate tuaedi (20) ijene kei. Areme fune uri mave-sifi irave tu aderedi (200) ke areme kumate tuaedi ijene kei. Fu ijiege re areme uri fanu kamero teti agi ije ke areme uri mave-kau irave foti (40) ro kumate teni (10) ijiege ke. Areme fune fanu doniki irave tuaedi ke ro kumate teni ijene kei. ");
INSERT INTO bbb_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Areme Jekafu fune uri mave ijiakiro fanuve ijene ke atana binobino uniae. Areme fune uri e fuone imevo ije kiamo bune kaenamiana ude vae. Fu e be kua, Ni fanu one kaenamia ude oebe datura vakiro e be fu ura fuone ije kaenamia ukua be vano kuae. Fu e fuone boeje ijiege kuariamoga bune fanu buone kaenamiana ijiege vae. ");
INSERT INTO bbb_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Fu ijiege kuaria areme uri e ije ude vako ije kuae, A vaga uvia none Iso fu ruomo a biedana kuako, E Ireobo one ije era? Ro ja izia vakuae ruo ro kuke fanu guraeje ja erado ijene samuagiavono kiakuma ni vua igene kuarane. ");
INSERT INTO bbb_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","19","Ni kua, Fanu ije fu Jekafu e ije oefuo imeno ijadufuo. Fu kena e ireobo fuone e Iso ije naejaemano kuano kuae. E Jekafu fune vua ijiege e ije ude vako ije kuara areme una e fuone gue rade nuvevo ije vua ni besu ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Jekafu fu ijiege kuara areme una e fuone gue ije kiae, Ja Esau biekuva nika mukoreigia kuarana kua, E Jekafu e ije oefuo imeno ije fu rade nuveduoko no ruovono kuano kiae. Ro Jekafu ijiege fu rema ije fu vierafero fu fanu ro mave ijiege Iso naejaga fu ije giana una oe dasuna fuosiki oemarekiro fu ijiege vierafe. Ro kuke fu vierafero Iso fu ire ijene kekuma fu Jekafu vaga fu biekuma fu ise fuone ije gana arekiro fu ijadufuo ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Ijiege rena Jekafu fune subine ijene ijiege kanafuima kiamo bu kena ude vakoga fuje fu una ijia nae. ");
INSERT INTO bbb_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Areme muge besu ijia Jekafu fune uri bararafa fuone ije ro bara inokiro bu fuefuo imevo ijiakina farirafa fuone boeje ireveni (11) ijene kaenamiana ari do Jaboke ijia ifejiamo bune tuana gara vae. ");
INSERT INTO bbb_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Fu ijiege kaenamia unia areme fune kuke uri sinuome fuone boeje gara vakuma furi areme fune fuosukua do iga fi. ");
INSERT INTO bbb_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Areme e be fu muge ijia kekena Jekafu fare arafirimo fu dabe daturakiro jiekena renoeko fune vakuma ve irasekiro saname. ");
INSERT INTO bbb_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Areme e ije fu gake funeka Jekafure iraraena giriesamoga fu uri Jekafu o surimoga funeka o nafe abuemo fune ijia daro furi. ");
INSERT INTO bbb_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Areme e ije fu uri Jekafu kuae, Ve irasemono abuezeke na vano kuae. Rove Jekafu fu kua, Na a na abuezakuva baki ro a na daro be miekuma na ijare arega a vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Ro e ije fu una Jekafu kuae, Ro ive one ije erano kuamoga fu kua, Na ive none ije Jekafuno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Areme e ije fu kuae, Ivia ive one ije bu una Jekafu kuanoekuva baki. A Godi fu farada dabe mamoga aka giriesae. Ro kuke ema buka a dabe vame ise ijia arafiravoga aka are iraraena bu asidiae. Ijadufuo ive one ije bu Isurerono kuakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","E ije fu ijiege kuaramoga Jekafu fu una kuae, Ro a ive one ije eraga ni kie na fieno kuae. Rove e ije fu una kuae, A irerefuo ive none ije fiekiro kiemono kuae. Areme e ije fune uri daro fuone ije Jekafu ma areme fune ijia arena vae. ");
INSERT INTO bbb_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Ijiege rena Jekafu fu una fue kuae, Na Godi e ije nikubae fuone ije nane gae rove na naebe barone na uria igifureki fivono kuae. Ijadufuo fu are ijene abe ive ina Feniero kuae. ");
INSERT INTO bbb_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Areme maza fune keke namoga Jekafu fune uri Feniero arena vakiro vagake fuka isere ijadufuo maeje oge fuone ije fu izege mukoe bierekuma baki. ");
INSERT INTO bbb_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ijadufuo maza ijia ruoma iviama ige e Isureroko bu fanu oge birage ije bu inoevo baki. Ijadufuo maeje e ije Jekafu farema ije fu oge fuone ijia kanaema ijadufuo bu ijiege revo. ");
INSERT INTO bbb_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Ijiege rena Jekafu fune ruomo gake uvia fuone Iso fune e fari fo aderedi (400) ijiege kaenamiana vuakoga fu gae. Ijadufuo fune uri anafa fuone boeje ke atana gue Ria uniaejaga gue fu Resero uniaeja gue fu atana bara inokiro fuone imevo ije uniaejiae. ");
INSERT INTO bbb_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Areme fune bara inokiro fuone imevo ijiakiro anafa buone boeje kiamo bune ude irei. Bu ude irekoga fune uri Riakiro anafa fuone ije kiamo bu ura ijuone buone ijia irekoga fune Reserokiro Josofu kiamo bu ura ijuone ijia irei. ");
INSERT INTO bbb_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jekafu fune ijiege kiamo bune ijiege irejavakuma arekoga fune ude vakoga bu rade ijuone fuone ijia merui. Jekafu fuka Iso mukoreigia aguae ijadufuo fu vakinu kukuma kuri tuakafakinu fu ruomo nidua ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Rove Iso fuka Rove Iso fuka difurina ruoma keke Jekafu uro urasena dabe ui mi. Areme bune uri buosiki buone niraefiranami. ");
INSERT INTO bbb_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Bune ijiege niraema areme Iso fune uri bara ije bu ame ije mediruiva ije giama areme uri Jekafu kuae, E boeje gure aena ruaeva ije eranebeno kuae. Iso fu ijiege kuaramoga Jekafu fu kuae, E ijeja Godire fuone izege fu na marejiemo ijia fu e ige vajiema ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Areme bara inokiro fuone imevo ije bu dua bune anafa buone ije meruna ro Iso manino ijia usiaena auge sana kuri tuakafae. ");
INSERT INTO bbb_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Bu ijiege rena bune bio vakoga bara Riakiro anafa bu dua bune usiae besu ijiege rena vakoga rane ije Reserokiro Josofu ijiebe usiae Iso kuri tuakafae. ");
INSERT INTO bbb_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Areme Iso fune uri Jekafu kuae, Ro e gafe gue fanu meru vuako na biediaeva ije eranebe? Bu irere abeva ijadufuo bu buebino ijiege meruna vuakono kuae. Fu ijiege kuaramoga Jekafu fu kuae, Na vierafero na ijiege a subijana naejaga a ije giana una none oemarekiro na ijene ijiege revano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Rove Iso fu una kuae, Uviano na vierafe ire boeje na fune mani ma ijadufuo ni una one keno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Ro Jekafu fu una kuae, Uviano a na giega fuka oemadavoga ni a isekie subine ije na a vajavo ije oemarekinu kene. Na nikubae one ije gavo ije naka Godido nikubae igege gave. A iviama aka una nosiki kai mukore rei. ");
INSERT INTO bbb_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ijadufuo a isekie ni subine none ije na oefuo kena ruaeva ijene kene. Na fuka Godire na marejiena ire boeje na vierafeva ijene na vajiemano kuae. Jekafu fu Iso dabe ijiege soesoemoga fu ijuone vaba una oemarekinu kari. ");
INSERT INTO bbb_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Areme Iso fune uri Jekafu kuae, Nine uri sinuome kanafuiga na ude vake a rade nuvedieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Fu ijiege kuaramoga Jekafu fu una kuae, Na vierafe ame none buka vajae sakiasakiana fiadiae. Ro kuke mave-none ijiakiro fanu boeje bu ame buone ijiakuma buka naebe manido bu izege giriesana vakuva baki. Na uri meruna una kuke vakuva buneka oe furidufuo. ");
INSERT INTO bbb_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Ijadufuo a isekie ni are ude vake na sone rade nuvedane. Na agebara ro fanu ije kaenamia sone igia vuakuma Idomi ijia biedano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Jekafu fu ijiege kuaramoga Iso fu kuae, A ijiege kuaemo ijadufuo ni areke na e none bino a uniaejaga fu sone aena vuano kuae. Rove Jekafu fu una kuae, A ije ade vierafemo na bado vuakono ni vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","17","Areme Iso fune ve ijia urina fu una Idomi ruakoga Jekafu fu una urina are Sukoti ijia vae. Fu va ijia kekena are fuone ro fanu ijiebuo ijene sama ijia nae. Ijadufuo are ije bu kua Sukotino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ijiege rena maza ije Jekafu fu aesakae Mesofotemia arena uri ruaema ije fuka mukoreigia ruoma sidove Sekame aesakae kena ijia kekena fune uri sidove ivuake irifo ijia are muvuaka sae. ");
INSERT INTO bbb_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Jekafu fune uri e Sekamedo asoe e Emodo uifari ijiebuo sakae ao be ire siruva uvani aderedi ijiege karana fuaeve. ");
INSERT INTO bbb_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Areme Jekafu fune uri fata zinone ifaejedufuo be ijia sama areme abena e Isureroko ijiebuo Godi ije nabuikena kua, Eroeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Areme maza be bara Daena e Jekafukiro bara Ria ijiebuo kabae ije fu bara Kenanaetiko ije giakiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Ro e Emodo fari e Sekame fu e Ivaetiko ijiebuo are ije fure samuamo. Ijadufuo fu bara Daena gana umuikeno fu ijuonemo fu faememarena mesiri oenoe. ");
INSERT INTO bbb_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sekame fu bara ije gamo fuka mae ijadufuo fuka uri vua fuone bino ijia kuarana oe fuone dabe dakudega Daena fu oe fu vierafekiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Ijadufuo e Sekame fu uri asoe fuone e Amo kuae, Ani bara ije mesiri miega na abeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ro Jekafu fu gake kabae fuone fuka jaevema ijadufuo fu naebe oemarekinu oenoeno fu gae. Ro ame fari fuone boeje bune mave buone ije kaenamiana usiae vaeva ijadufuo fu naebe vua bino kuae ro ire bino rei. Ro fume ijia arene fikoga ame bu una ruae. ");
INSERT INTO bbb_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Areme Sekame asoe fuone fune ro Jekafuki vua kuaekiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ijiege rekoga anafa ije bu una ruovo ijia bu vua ije izege Daena fu rema ije fievo buka oe fiadiae ro ka defarudiae. Ijadufuo maeje Sekame fuka vame ma ome ise ijene rena Daena dabe ijiege arafiri. Ro kuke fuka E Isureroko ijiebuo ive ijene kame arafiriae. ");
INSERT INTO bbb_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","E Emo fune uri Jekafu kuae, Fari none e Sekame fuka kabae one ije oe ireobo fu vierafe. Ijadufuo abe kabae one ije kuaga fu fari none ije manike. ");
INSERT INTO bbb_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","No vierafe jaka kabaerafa nuvuone ije kekiro no ve kabaerafa jone ije kene. ");
INSERT INTO bbb_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","No ijiege rekina ja aesakae nuvuone igia oemarekinu karidufuo. Ja aesakae nuvuone gue fuaevena ijia juae me ro ijia oemarekinu oenoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Ro fari fuone e Sekame fu dua fu uri Jekafukiro farirafa ije anadiana kiae, Ja isekie nika areke na daena abefo. Ja ijiege rekuva naka irere boeje ja vierafeva ije vajiake. ");
INSERT INTO bbb_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Ro a sinuome irere vierafekuma ni kuariega na fiene. Ro bara ijadufuo moni ije a biona ajia izege a vierafema kiekuma naka uri fuaeveke. Ijadufuo a nime kabae one ijiaru abe miega na abeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Rove Jekafudo anafa ije bu vame ka omise ije e Sekame fu Daena fake rema ijare buka ma isediae. Ijadufuo bu uri asoefuoki biesiriana vua ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Bu kiae, No maki nuvuone ige nobe kuaga fu e vajae surive buone ije naebe kania ufuna nuga naeva ije maniake. Ijadufuo maeje fu e ijieke ije maniakuma fuka no jaeve dabe muoke ijadufuo vame ije noka iseduo. ");
INSERT INTO bbb_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ro ja maki nuvuone ige abekuva no vierafe jaka izege no vajae surive nuvuone kania ufuiva ijiege e fari ije ja dua jaka vajae suri jone kania ufuke. ");
INSERT INTO bbb_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Areme no ijare ja kabae nuvuone kekiro no ve jone keke. No ijiege re areme no jaena besu rena jaena biezinamina karinoeke. ");
INSERT INTO bbb_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Ro ja vame nuvuone ige no suri nuvuone kania ufuvo ije ja naebe ijiege rekuae vierafekuva no vierafe none kabae nuvuone mesirina uri vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Ijadufuo Emokiro fari fuone ro e boeje bu fieke vua ije fuka magana bu abe ma vierafei. ");
INSERT INTO bbb_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Ijadufuo bu naebe saroe ro buka migegire urina vua bu kuariaeva ijiege rei. Ijadufuo maeje Sekame fuka Jekafudo kabae ijene ireobo vierafe. Ro e Sekame fuka e anuigi agane fuone boeje buka fu mukoe aguaekinu irinavo. ");
INSERT INTO bbb_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Ijiege rena Emokiro Sekame bune va sidove ijadufuo viene ijia e kaerafa buone boeje bu ijia ruaeva ije vua ijene dabe ijia kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Bu kiae, E ije buka kaerafa nuvuone mukore ijadufuo arega bu jaena oemarekinu ijia ura oenoefo. No sakae nuvuone ije fuka ireobodo bu ijia karinoekuva ije fu mareke. Areme bu kabaerafa nuvuone ige keke no ve buone kedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","No e fari boeje noka izege bu keva ijiege rena vajae suri nuvuone kania ufukuva buka noena besu oemarekinu karinoeke. ");
INSERT INTO bbb_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Ire boeje bu abeva ijiakiro mave ro fanu boeje bu saeva ije fune nuvuone ijadufuo vua ige ka kuaena avenamiga no kiaga bu noena besu karino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Areme e boeje sidove guove ijia kariva ije bune urina vua ije e Emokiro fari fuone bu kuaevo ijene avediana abe marei. Areme e fari boeje bune uri vajae suri buone ijene kani ufui. ");
INSERT INTO bbb_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Areme rade maza inokubeke furima e bu uria matane visina kariva ijia Jekafudo anafa inokiro Simionikiro Rivae bara Daenado makirafa ijiebe urina sime buone bu kena bijaevo ijene kei. Bu kena mauike sidove guove ijia aruna oenoekinu e fari boeje buneka kaniavo bune oe furi. ");
INSERT INTO bbb_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Bu ijiege re areme uri e Sekamekiro asoe fuone e Emo ije duaku sime ijiebe kame kaniavo bu oe. Bu oekoga Simionikiro Rivae bune va e Sekamedo are ijia aruna maki buone Daena mesirina bune usiae vae. ");
INSERT INTO bbb_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Bu ijiege vakoga Jekafudo anafa gue bune Daenado ziena uri sidove ijia aruna oenoekinu sinuome boeje buone ije kei. Ijadufuo maeje bu are ijia maki buone dabe vame isema reva ijadufuo. ");
INSERT INTO bbb_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bu aruna ire boeje maeje ijia naovo ijiakina mave-kau ro sifi ro doniki ijene buone kei. Areme bune kuke are boeje sidove irifo ijia kariva ije duaku kemiae. ");
INSERT INTO bbb_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Bu ijiege rena uri bara ro ame boeje kaenamia areme uri kuke sinuome buone boeje binobino ijene karina bune vae. ");
INSERT INTO bbb_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Bu ijiege revoga Jekafu fu urina kiae, Iviama jane irufui amaerina mie. Ijadufuo e Kenanaetiko ro Feresaetiko ijiakiro e boeje aesakae igeko buneka na ziegafieke. Na e fari ije noka e sibanekuado e boeje igeko bu besu kuae fienamina una naena bijaekuva buneka kanuo noneka oe furidufuono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Jekafu fu ijiege kuariamoga bu una kuae, No ude vierafe no ijiege rekuva baki. Rove maki nuvuone ije buka dabe bara ome ise be fu vame ijia vajae fuone abe e miako bu dabe arafirivo ijiege arafiri. Ijadufuo no ijene ijiege kevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Areme Godi fune Jekafu kuae, Iviama ni migegire biona va are Betero ijia fata be a ijia none baname isoedufuo ije ufene. Naeje na Godi ije a uvia one Iso ga kona are Betero romoga na biedaeva ije nareno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Ijadufuo Jekafu fune uri agane fuone ijiakina e boeje eranebe fuina kariva ijene kiae, Iviama ni godi jone boeje e ae binoko ijiebuo ije ja naeva ja ma vierafevo ije ka ijuegafiafo. A nine uri jone amaerenamikinu sinuome jone iviaeko ijene safo. ");
INSERT INTO bbb_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Ivia none are ige no karivo ije arena uri are Betero ijia va Godi none ije fu maza boeje are iziebureki na oenoeva ijia nosiki oenoekinu irufui na biediavo ijia ifejiemo ijadufuo fata no ijia fu zinone ifaejadufuo ije ufeno kiae. ");
INSERT INTO bbb_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Jekafu fu ijiege kuariamoga e boeje bune uri godi buone binobino bu naeva ijiakina adane gibore buone boeje karina una Jekafu vajae. Bu vajavoga fu karina are Sekame ijia ine okino kuavo ije zinume ijia mako rui. ");
INSERT INTO bbb_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Areme maza ije Jekafu fune anafa ijena bune urikuvejoga e boeje are isesina sidove irifo ijia kariva ije buka ireobo jumei. Ijadufuo bu naebe urina bu kaniakuae nuvediana kame arafiriae. ");
INSERT INTO bbb_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Bu arekoga Jekafu fune e fuone ijena vakuma are Ruzi ijia usiae. Ro are ije iviama bu kua Beterono kuavo ro are ije fu Kenani guove ijia. ");
INSERT INTO bbb_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Ijiege rena Jekafu fune va ijia kekena fata be Godido ufema areme are ije abe ive ina Betorono kuae. Ijadufuo maeje maza ije Jekafu fu uvia fuone Iso gana ko ijia romoga Godi fu ijia arina bie. ");
INSERT INTO bbb_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Areme rade bara Debora bara ije Rebeka ifejamo ije fu baronemoga bu abena Betero ijia ine Oki ije manino zinume una ikine ijia mako rui. Ijadufuo are ije Jekafu fu abe ive ina kuae, Ine bu ijia niraena oefiane abeva ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Areme Jekafu fune aesakae Mesofotemia ijia urina una vakiro vako ijia Godi fu una kuke arina bie areme uri daro mae. ");
INSERT INTO bbb_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Godi fu daro mana kuae, Ivia ive one Jekafu bu kuavo ije fune furi. Ijadufuo ivia una gafege vako ije ive one bu Isurero kuakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Areme Godi fune urina kuae, Naeje na Godi ka ma doroki ijene. Ijadufuo ni ame ma uruvana tuanaga bu e uruvana rena bure uri aesakae binobino kena karine. Ro asaerafa one ijiebuo uifari ije gue bu e mamekanu rena aesakae gue samuagiake. ");
INSERT INTO bbb_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Nare sakae ije na abe Eburamekiro Aeseki miaeva ije abe a madufuo. Ro a baronekuma rade na kuke abe una uifari one rade urivo ije miakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Godi fu Jekafu ijiege kuarama areme fune ijia arena vae. ");
INSERT INTO bbb_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","15","Fu vakoga Jekafu fu uri are ije Godi fu ari vua kuaraema ijia mune gue karina fata be fu ijia gakinu oenoedufuo ijene sae. Fu ijiege sa areme uri ine orive oere ijiakiro do vaeni ijene kena ado ijia usiana daro miae. Areme fune are ijene abe ive ina Beterono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Areme Jekafukiro agane fuone bune are Betero arena bune are Efurati vakuae vae. Bu uria vame vako ijia bara Reserodo mazani fu ame bietedufuo ije fune ruae. Ijadufuo Resero fu ijia zinuevena ame arafirina fune ma isejavaeme. ");
INSERT INTO bbb_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Resero fu ijiege e arafirina vakuma ame ije nafenoga bara ije fu ifejiamo ije fu urina kuae, Aneka ame fari bedua bietemano ade jumemono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Bara ije fuefuo imeno fu ijiege kuarako Resero fune ijia gue baronena vakuma oe kana ufui. Ro Resero fune baronekuveno ijia fu ame ije abe ive ina Beneni kuae. Rove asoe fuone Jekafu fu una abe ina Bezimanino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Ijiege rena Resero fune baronemoga Jekafu fu suri fuone ije abena vame ije bu Efurati vako irifo ijia mako rui. Ro are ije iviama bu kua, Beturiemeno kuavo. ");
INSERT INTO bbb_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Areme Jekafu fune mune be fu ijia gakinu oenoedufuo ijene abe amaerima areme abe ijia sae. Ro mune ije bu abe Reserodo mako viene ije saeva ije iviama fu uria ijia maniga bu gavo. ");
INSERT INTO bbb_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Ijiege rena Jekafu fune kuke biona vakuma are Ida gire jiagadogo bu sana ajiaeva ije manino ikene una gara ijia are sana ijia finoe. ");
INSERT INTO bbb_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Ro maza ije Jekafu fu uria sakae ijia finoeno ijia fari fuone e Reubini fu uri bara Bira asoe fuone ijadufuo imeno ije daturae. Reubini fu ijiege remoga asoe fuone ije fu vua ije fiemo fuka ma ise. ");
INSERT INTO bbb_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ro Jekafudo anafa boeje buka ame tuero (12) ijiege. Ro Jekafudo bara Ria ame fu nafena ije amure ijeja e Reubikina ro Simionikina Rivaekina ro e Judakiro Isika ro e Zeburuni ijene. ");
INSERT INTO bbb_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ro una bara Reserodo anafa ijeja e Josofukiro Bezimani ijene. ");
INSERT INTO bbb_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ro una bara Bira Reserodo imeno ijadufuo anafa ijeja e Denikiro Nafetari ijene. ");
INSERT INTO bbb_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ro una Zirufu bara Riado imeno ijadufuo anafa ijeja e Gadikiro Esa ijene. Ame ije boeje bu Jekafudo anafa bu aesakae Mesofotemia ijia karina nafeva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ijiege rena Jekafu fune una are Mamure are Eburoni ivuake ije asoe fuone e Aeseki fino ijia ruae. Fu una sakae ije asae fuone Eburamekiro Aeseki bu karinoeva ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Ro Aeseki fuje fu fivakuma juaevasia uvani aderedi eti (180) ijiege furiko fu tuvuae bijana barone. ");
INSERT INTO bbb_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Fu baronemoga anafa fuone e Isokiro Jekafu ijiebe dabe nujae. ");
INSERT INTO bbb_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Ijiege ro e ive ige ijeja e Iso ro ive fuone be bu kua, Idomino kuavo ijadufuo uifari ijene. ");
INSERT INTO bbb_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","E Isodo bara fu kema ije fu bara Kenanaetiko ijene kei. Ro bara amure ije Ada fu e Eroni e Ivaetiko ijadufuo kabae. Ro bara be ive fuone ije Oribama fu e Ana e Zibionedo fari are Ivaetiko ijadufuo kabae ijene abei. ");
INSERT INTO bbb_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Ro bara be ive fuone ijeja Basemati fu e Isimerodo kabae ro kuke fu bara Nebaotido uvia ijene abei. ");
INSERT INTO bbb_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Areme bara Ada fu uri fari fuone e Erifazi nafekoga bara Basemati fu uri fari fuone e Rejurero nafei. ");
INSERT INTO bbb_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Fu ijiege nafekoga bara Oribama fu e Jeusikina Jaramekina e Kora ijene nafei. Ame boeje ije bu e Isodo bara ijiebe aesakae Kenani ijia karina nafeva ijene. ");
INSERT INTO bbb_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Areme Iso fune uri agebara fuone ro e fuone boeje fuina besu karivo ijene merui. Areme fune kuke uri sinuome ro fanu ro mave binobino fu saema ro ire fuone boeje fu sakae Kenani ijia fina abema ijene abenama fune vae. ");
INSERT INTO bbb_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Fu uvia fuone Jekafuki besu karidufuo ije fu naebe mani ijadufuo maeje sakae ije fuka isekube. Ro kuke buka fanu ro mave ma uruvana saeva ijadufuo bu izege besu karikuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Ijadufuo fune urina Idome are uruo ijia finoekiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ijadufuo e ije aesakae Idome ijia kariva ije bu e Isodo uifari ijiebe. ");
INSERT INTO bbb_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","E Isodo bara Ada fu ame besu e Erifazi nafenoga fu urina ame fari umui fague ije nafei. Ro ive buone ijeja e Temanekina Omakina Zefokina e Tatamekina e Kenasi ijene. Ro Iso fu kuke bara be dua Timinano kuavo ije abena ame fari e Amareki ije nafei. Ro e Isodo bara Basemati fari e Rejurero ije fu fina una ame fo (4) ijiege nafe. Ro ame ijiebuo ive ijeja e Nafatikina e Zerakina Samakina e Miza ijene. ");
INSERT INTO bbb_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Ro Isodo bara Oribama fu ame fari inokubeke e Jeusikina Jaremekiro e Kora ijene nafei. ");
INSERT INTO bbb_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Ro e Isodo uifari ijiebuo e mamekanu ijeja e Temanekina Omakina Zefokina Kenazikina Korakina Gatamekina e Amareki ijene. E ije bu e Isodo bara Ada ijadufuo fari amure e Erifazido farirafa ijene. ");
INSERT INTO bbb_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","19","Ro una e agane Nafatikina Zerakina Samakina ro Miza ije bu Isodo fari e Rejurerodo uifari. Ijadufuo e uifari ije bu bara Basematido anafa ijia uinuvena ruaeva ijene. Ijadufuo uifari boeje ije bu e Isodo bara Oribama e Anado kabae ijadufuo anafa e Jeusikina Jaremekina ro Kora ijiebuo uifari ruaema ijene. ");
INSERT INTO bbb_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Ro e ije bu iko zinume ijia sakae Idome abena kariva ije bu e Sia e Oraetiko ijadufuo anafa ijiebuo uifari ijie be ijia kari. Ro e Siado anafa ijeja e Rotamekina Sobarokina Zibionikina Anakina Disonikina Ezakina e Disane ijeja. Ijadufuo e ui ije sakae Idome ijia kariva ije bu e Siado anafa ijiebuo agane ijia uinuve ruaeva ijiebe ijia kari. ");
INSERT INTO bbb_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ro e Rotane fu e agane Orikina Emane ijiebuo uifari ijiebuo asae. Ro e Rotanedo maki ijeja bara Timina. ");
INSERT INTO bbb_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ro e Sobaro fu e agane Arivanekina Manatikina Ebarokina Sefokina e Onama ijiebuo asae. ");
INSERT INTO bbb_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ro kuke e Siado fari e Zibioni fu ame inokiro e Aeakiro Ana ijene tuanae. (E Anare amure ae sao ijia mave doniki ije samuagianoeno ijia fu asoe fuone ijadufuo do bu mako ijia jiavo ijene gae.) ");
INSERT INTO bbb_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","26","Ro e agane Emidanekina Esibanekina Itivanekina Serane ije bu e Anado fari e Disane ijadufuo anafa. Ro kuke e Ana fu e agane ijiebuo asae buone ijene. Ro e Anado maki ije bara Oribama. ");
INSERT INTO bbb_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ro e Eza fu e agane Biranekina Zavanekina Akane ijiebuo uifari ijiebuo asae. ");
INSERT INTO bbb_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ro e agane Uzikiro Arane ijiebuo asae buone ijeja e Disane. ");
INSERT INTO bbb_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Ijadufuo e Oraetiko ijiebuo uifari ije sakae Idome ijia kariva ijiebuo ive ije ijiege. E Rotanekina Sobarokina Zibionikina Anakina Disonikina ro Ezakina e Disane ijene. ");
INSERT INTO bbb_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Ro ude e Isureroko bu kini bino naebe kevo bu aesakae Isurero samuaeva ijia bu kini igiebe aesakae Idome samuana ruae. ");
INSERT INTO bbb_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Ro kini amure ijeja kini Bera e Biodo fari are Dinaba ijare samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ro una ijuone fuone ijeja kini Jobabi e Zerado fari are Bozira ijare samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ro ura ijuone fuone ije kini Usame are Temanaetiko ijare. ");
INSERT INTO bbb_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ro una ijuone fuone ije kini Adabi e Bedadido fari are Avitiko ijare samuagiae. (Kini ijare e are Midianeko ijena are Moabi ijia bijaema areme fure e fuone ijena iraraena kaniae). ");
INSERT INTO bbb_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","37","Ro ura ijuone ije Kini Samira are Maserekako ijare samuagiae. Ro ura ijuone fuone ije Kini Soro are Rebotiko ije fu do irifo ijia fino ijare samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Areme Kini Soro fu baronekoga ura ijuone fuone ije Kini Baranane e Akabo fari ijare samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Areme Kini Akabodo fari ije fu baronekoga ijuone fuone ije Kini Adade fure samuagiae. Ro sidove fuone fu kema ive ije Fau ro kini ijadufuo bara ije Metabero. Ro bara Metabero fu e Matiredido kabae ro asae fuone ije e Mezarabi. ");
INSERT INTO bbb_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Ro e Iso fu e agane binobino bu are Idomeko ijia kariva ijiebuo uifari buone ijene. Ro agane ijiebuo ive ijeja e Timinakina Arivakina Jefetikina Oribamakina Erakina Finonekina Kenazikina Temanekina Mibizakina Medierokina Irame ijene. Ro sakae iziebure agane binobino bu kariva ije bune agane buone ijiebuo ive ijia nabuikena ijia kari. ");
INSERT INTO bbb_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Ijiege rena e Jekafu fune una ro Kenani are ije asoe fuone fu finoema ijia finoe. ");
INSERT INTO bbb_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ro Jekafukiro agane fuone ijiebuo suvuare ije ijiege. E Jekafudo fari Josofu e ije juaevasia sevenitini (17) ijiege furima ije fu bofari fuone bara Birukakiro Zirufa ijiebuo ame ijena mave-sifi ijiakiro mave-goti ije samuagianoe. (Ame bofari ije bu Jekafudo bara inokiro ijiebuo ame ijene). Josofu fu maza be oenoena ro kekena asoe fuone Jekafu ire ise bino bofari fuone ijiebe renoejo fu giaema ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Ro Jekafu fu fari fuone e Josofu fuka ma ireobo oetuamo ro ame gue ije fume sibaneke oetuamo. Ijadufuo maeje Jekafu funeka ma eove rema ijia fu Josofu bietema ijadufuo fuka mukoreigia oetuamo. Ijadufuo maza be fu ugone ka ni mukore be saguma dabe mamo fu abiese. Jekafu fu Josofu ijiege oetuagaro ame gue fu naebe uruke oetuamoga bofari bu ije gavo buka defarudiae. ");
INSERT INTO bbb_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ijadufuo bofari ije buka Josofu dabe nibijakinu ro vua ma ijiaru kuaravo baki. ");
INSERT INTO bbb_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Areme maza be Josofu fu naka be naena una bofari ijene naka ijadufuo maeje kuariamo buka una ma urukeigia ziegafae. ");
INSERT INTO bbb_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Josofu fu urina bofari ije kiae, Ni mauike karike na naka igene kuariaga fiefo. ");
INSERT INTO bbb_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Na naka naena gaga no besu juaru gafia ire vuiti ije asena ufuanoeve. No ijiege renoejo ijia vuiti none na ufuaeva ije buka uri arire irekoro jone bu una none na ufuaeva ije kurituakafavo na giaevana kiae. ");
INSERT INTO bbb_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Fu ijiege kuariamoga bofari ije bu urina kuae, Ijiekido a vierafe a are e kini ireobo rena una no samuaguokiro a ijiege vierafemano kuae? Ijadufuo ame bofari ije bune Josofu naka ije fu naema ijiakiro ise ije izege bure redufuo fu kuariaema ijadufuo buka fu urukeigia ziegafae. ");
INSERT INTO bbb_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Areme rade Josofu fu una kuke naka be duaku nae areme uri bofari ije kuariae. Fu kuariana kiae, Na naka be duaku naevano kiae. Fu kia, Naka ije na nae gake mazani ro asame ro zuvi ireveni (11) ijiege bu una na kurituakafievo na giaevano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Josofu fu ijiege kuaria areme fune kuke una va asoe fuone ije naka besu ijene kuarae. Fu ijiege kuariamoga asoe fuone fuka uri madima kuriaerena kuae, A naka ije izeki ijene naena ura kuaenoene? A vierafero no e bofari one igiakiro asie one ro asoe one ro na e boeje noka a auge sana kurituakafakiro a ijiege vierafemano kuae? ");
INSERT INTO bbb_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Ijadufuo bofari ije buka uri Josofu oe isema vierafe rove asoe fuone ije fuka uria naka ije Josofu fu naema ije fu irerefuo naema fu ijene ireobo oenoekinu vierafenoe. ");
INSERT INTO bbb_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Areme bune oenoena maza be Josofudo bofari ije bune are Sekeme ijia asoe buone ijadufuo mave-sifi ije samuagianoekuae vae. ");
INSERT INTO bbb_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Areme maza sibaneke furikoga Jekafu fu uri Josofu kuae, Na vierafe a are Sekeme bofari one bu mave-sifi samuagiakuae vaeva ijia nuvediakono kuae. Fu ijiege kuaramoga Josofu fu una kuae, Ate ije fune maredo na nuvedia vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","15","Fu ijiege kuaramoga asoe fuone fu uri kuae, Va gafia giaga bofari one bune mukoe oenoe ro kuke mave-sifi bune mukoe oenoevoga ni giana una ro kuarie na fieno kuae. Asoe fuone fune ijiege kuarama areme kuamoga Josofu fune Eburoni isove ijia urina Sekeme nakiro vae. Josofu fu vakuma Sekeme kekena ijia ura bofari fuone ije rerianoe. Fu ijia rerianoenoga e be fu ruoma keke biena kuae, A ige a irere rerenoeno kuae? ");
INSERT INTO bbb_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Fu ijiege kuaramoga Josofu fu kuae, Na bofari none ije bu igia mave-sifi samuagianoevo na ijene rerianoeve ro abe giaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Fu ijiege kuaramoga e ije fu kuae, Bofari one ije ige bu baki. Ro na fie bu are Dotani ijia vakuae kuaevo na fievano kuae. Ijadufuo Josofu fune reriana game bofari bu oenoejo ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ro fume uria mumabo gufia vuakoga bofari ije bu gana uri naka ije fu naema ijadufuo fu kanakuae bue kuaena amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Areme bu gake fune ruoma ivuaremoga bune una bue kuae, E ije naka naema ije fune gafaeji ruome. ");
INSERT INTO bbb_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Ijadufuo roga no fare kanana dabe mako bu ijia do jiavo fu sima ijia abiesefo. Ro no vaga asoefuo fu kuokuma no kuako fune fanu kuriae taraeko ijiebe sakivano kuake. No ijiege renaro kari gaga naka fuone fu naema ijadufuo maeje fu izege rega no gano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Bofari gue bu ijie kuaevoga e Rubini uvia fuone be fu una Josofu babuena kiae, Na vierafe no fu kanadufuo ije fu naebe marei. ");
INSERT INTO bbb_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Rove nime roga fare dabe are etura igia mako ije bu dofuo ruiva ijia abiesekiro jade kanaga fu baronemono kiae. E Rubini vua ije fu ijiege oe vierafena vafaema ije fu vierafe fu ijiege rena Josofu mauike mesirina abe una nujaga fu una asoe fuone ijadufuo ruakiro fu ije ijierei. ");
INSERT INTO bbb_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Ijiege rena Josofu fune vakuma game bofari bu oenoevo ijia kekemoga bofari bune uri ugone ni mukore jiagadogo ije fu abiesema ijene fare dasuaejae. ");
INSERT INTO bbb_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Areme bune fare dabe mako be bu dofuo ruiva fune sima ijia abiese. ");
INSERT INTO bbb_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Areme bune karina ire ivo ijia saroruba bu gake e Isimaraetiko uruvana gue bu aesakae Giriati ijia una gamia Ijifiti vakuae rovo bu giae. Ro e ije bu re udiudiki boeje kena fuaevekuae karina mave kamero buone ado ijia nama ruove. ");
INSERT INTO bbb_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","27","Ijadufuo Josofudo bo buone be e Juda fu urina uviarafa gue kiae, Na vierafe no e Josofu iviene nuvuone ma ije kana fu baronekuma ire maeje noka irere abekuva baki. Ro kuke no ise rena e kana fu baronena kavuane usiaekuma ije no izia sauike? Josofu fuka iviene nuvuone fuka noena kavuane ro vajae besu. Ijadufuo na vierafe no kanana vajae fiane madufuo ije arekiro roga nome dabe e Isimaraeroko ijiebuo fuaeveno kiae. Juda fu ijiege kuariamoga bofari boeje bune oemare. ");
INSERT INTO bbb_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ijadufuo e Midianaetiko gue bu vame ijane rovoga Josofudo bofari ije bune mako ijia Josofu umui kevo fu ajiae. Areme bune mesiri usiae e Midianaetiko miagana kiavo bu ire siruva tuaedi (K400) ijiege fu fuaeve. E ije bu Josofu fuaevena bune mesirina gamia aesakae Ijifiti ijia ari vae. ");
INSERT INTO bbb_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ijiege rekoga e Rubini fu rade una va mako ije bu Josofu fare abieva ijene gake fu bakiga fuka ma ireobo oefiaemo fu uri sinuome fuone farae. ");
INSERT INTO bbb_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Areme fu una keke bofari ijene kiae, Ame ije mako gafe fu baki ro ije naeje na izege rekono kiae? ");
INSERT INTO bbb_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Ijiege rena ame bofari ije bune uri mave-goti be kanana kavuane dabe Josofudo ugone fu abiemo ijene azi. ");
INSERT INTO bbb_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Bu azima areme abena una va gafia usiaena asoe buone ije nijae. Bu nijaena kuae, Ate kame ugone ige no are sao gamia abeva ige gaga fu fari one Josofudo ro fu eradoga gano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Areme asoe buone fu gake fune ma fari fuone ijadufuo ugone fu abiemo ijene. Ijadufuo Jekafu fuka uri vijena nimekinu kiae, Ugone ige funeka fari none ijadufuo! Na vierafe buneka fanu kuriae taraeko ijiebe fari none ije bune saki dabe buvuase igana ugone bu dabe ijia aberevano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Areme Jekafu funeka oefiaemoga fu uri sinuome fuone faradia faraema areme uri ugone ise bu sana oefiane abevo ijene sama areme fuka maza jiamadogo fari fuone ijadufuo oefiane abei. ");
INSERT INTO bbb_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Jekafu fu ijiege remoga anafa fuone boeje bu fu dasumakinu ifejakuae ruae. Rove fuka ijuonena uri kiae, Na fari none ijadufuo oefiane ige na abevo ije na arekuva baki. Ro oefiane ige na abevo ije na ijiakuma barone vano kiae. Jekafu fune uri fari fuone ijadufuo nimekinu oefiane ma ireobo abei. ");
INSERT INTO bbb_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Ijiege rekoga e Midianaetiko bune Josofu fuaevena abe va gamia Ijifiti usiae. Bu usiaena buse Josofu abe una e Fotifado fuaeve. Ro e Fotifa fu e ireobo be fu e azo keva gue bu kini ijadufuo are ije juo karijo ije samuagiamo. ");
INSERT INTO bbb_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Ijiege rena maza ijia e Juda fu uviarafa fuone bu nafare ijia karijo ije uniana fune urina are isekube Adurameno kuavo ijia e Iraki fikiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","3","Juda fune ijia fivakuma uri e Suado kabae bara kenaneko ijene gana abei. Areme bara fuone fu uri ame fari be nafenoga fu abe ive ina e Eri kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Areme Judado bara ije fune una kuke ame bedua nafenoga fu abe ive ina e Onani kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Areme fu una kuke ame fari be nafenoga Juda fu abe ive ina e Sira kuae. Ro maza ije e Juda fu are Akezibi ijia fino ijia bu ame ije bietei. ");
INSERT INTO bbb_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Ijiege rena Juda fune ijia fivakuma areme fune uri bara Tama gana mesiri fari fuone boga e Eri ije nujaejamoga fu abei. ");
INSERT INTO bbb_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Rove e Erido vame fu vierafekinu kenoeno ije fuka ma omise. Ijadufuo E Ireobo fu ije gaga fuka naebe oemaemoga fu kanamo fune baronei. ");
INSERT INTO bbb_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","E Eri fu baronemoga Juda fu una fari fuone ririkua e Erido iviene e Onane kuae, Akae nuvuone fune ijiege namo ijadufuo ni va uvia one ijadufuo bara amune ijene abene. A ijiege rekina bara ijare uvia one ije baronema ijadufuo ame uifari bino tuanano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Rove e Onane fu vierafero ame ije fu nafekuma bu ma fuone rekuva bakiro fu ijiege vierafe. Ijadufuo maza ije fu kavuare fuone ijiaki naema ije safine fuone ije fu areko fu makave ari. Fu ijiege rekina fube uvia fuone Erido ame tuanakiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Rove E Ireobo fu Onane vame ije fu rema ije fuka naebe oemarei ijadufuo fu e Onane kuke kanamo fune baronei. ");
INSERT INTO bbb_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Areme Juda fune uri asaefuo Tama kuae, Nine una va orafa one ijena finokiro ade una baru be manimo. Ani va finoekinu samuake ame none iviene e Sira fu ubaerega ni una ro manino kuae. Ro Juda ijiege fu kuaema ije fu ma kuaema baki. Fu vierafero bigake Godi fu kaniaemo bu oeva ijiege Godi fu fudua kana fu barone bigakiro fu ijadufuo ijiege kuarae. Ijadufuo bara asae fuone Tama fune una urina orafa fuone ijiebuo vae. ");
INSERT INTO bbb_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Areme juaevasia sibaneke furikoga Judado bara e Suado kabae ije fune baronei. Fu baronemoga Juda fune bara fuone ijadufuo oefiane abenoena furinoga fu uri kai fuone e Ira are Adurameko ijiaki bune are Timina ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Juda fu ijia vakoga ebe fiena va bara Tama kuae, Asae one baru ije fune Timina ijia mave-u ufukiro vaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ro bara Tama fu gake Judado fari iviene e Sira fune e ireobo rei rove asaefuo e Juda fu naebe migegire kuamo fu fari fuone mani. Ijadufuo Tama fune uri ugone bara amune bu savo ije fu saema ijene azose. Areme fune uri ugone fae be abe nikubae ije okura areme fune vae. Fune va vame ije bu are Timina vako ukua ijia sidove iseke Enaemeno kuavo ijadufuo viene bu usiaevo ijia samuana fine. ");
INSERT INTO bbb_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Fu ijia fikoga e Juda fu ro Tama gana vierafero fu bara be fu vame ijia oenoeno ijero fu ijiege vierafe. Ijadufuo maeje Tama fune ugone fae abena nikubae fuone okuraema ijadufuo fu naebe mukoreigia gana vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Ijadufuo Juda fune gakinu vame ikene ijia ufuaena vakuma gare fu fino ijia kekei. Areme fu uri kuae, Naka osiki naekiro vierafevano kuae. Juda fu ijiege kuamoga Tama fu una kuae, Ro na osiki naekuva ire maeje a irere ije na miekono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Ro Juda fu kuae, Na vierafe naka mave goti none gafe na saeva ijia irore maejia abe makono kuae. Ro bara Tama fu una kuae, Ke ije fune mare. Ro nika sinuome one be abe miega na farekina a ije vierafekuma abe arekiro a va mave goti ije fare nijieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Bara Tama fu ijiege kuaramoga Juda fu kuae, Ro a vierafe na irere abe maekina naka ijadufuo mave goti fare nijakono kuae. Ro Tama fu kuae, Ni ire guraeje a abe ive one isoema ijiakiro soe fuone ro mudu one ije ke vajieno kuae. Ijadufuo Juda fune uri ire ijene kena vaja areme fune va fuosiki naenoga Tama fu e fudie. ");
INSERT INTO bbb_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Areme Tama fune una va are fuone gafia kekena ugone fae ije fu abe nikubae okuraema ijene ira nija areme fune uri ugone bara amune bu savo fu azo naema ijene una sae. ");
INSERT INTO bbb_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Areme Juda fune uri Ira e kai fuone ije kuamo fu mave goti irore ije farena abe bara ije makiro vae. Fu mave-goti ije abe bara ije magaro ire ije fu abe ive fuone isoema ijiakiro mudu ije fu kena vajaema ijene una kekiro vae. Rove e Ira fu va bara ije rerenoega fu baki. ");
INSERT INTO bbb_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","E Ira fu bara ije rerenoega baga fu uri e ijia oenoevo ijia kiae, Bara ije fu vajae fuone abe fuaevenoeno ije fu vame irifo igia fino na gaeva ije fu izieburekino kiae? Fu ijiege kuariamoga e ijia oenoevo ije bu kuae, No bara ije fu ijiege ura vajae fuone abe fuaevenoeno ije are igia fu bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","E ije bu ijiege kuaravoga Ira fu una va Juda kuae, Bara ije na va rerenoega fu baki. Ro na e ijia oenoevo ije kiavoga bu kie no are igia bara ijieki ije bu bakino kievo na ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Ira e Judado kai ije fu ijiege kuaramoga Juda fu kuae, Na vierafe naka bara ijene fuaevekiro vierafe rove a naebe bie. Ro no uria sinuome none ijene kekiro uri bara ijene rerenoekuva e buka guona kisuodufuo. Ijadufuo sinuome ije ni arega bara ije fu fue keno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Areme rade asame inokiro furima ijia bu ebe ro Juda kuae, Bara asae one Tama fuka urana v ame igia vajae fuone dabe fuaevenoeno kuae. Fu ijiege renoena areme iviama fune e fudiena fino kuae. E ije bu vua ijiege Juda kuaravoga fu kiae, Ni va bara ije mesiri dabe miane ifaejema ijia ifaejega fu naena baroneno kiae. ");
INSERT INTO bbb_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Areme e ije bune bara ije mesiri dabe miane ifaejekuae vakoga fu uri vua asae fuone e Juda nijana ijiege kumei, E ige na fudieva ije na e ije fu sinuome ige na faradiaeva ije vajiema ijadufuo fudie. Ijadufuo ni ro ire ige bu abe ive isoevo ijiakiro mudu ige giaga eradoga giano kumei. ");
INSERT INTO bbb_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Areme Juda fune vierafegake sinuome ije bune ma fuone fure kena bara ije vajae. Ijadufuo fu uri e ije kiae, Bara ije vua ije funeka ma kuae. Na vame maeje na redufuo ije naka naebe ijiege nuvei. Na bara ije naka abe fari none ije madufuo rove naka isema revano kuae areme rade Juda fu naebe una va bara Tamaki nae. ");
INSERT INTO bbb_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Ijiege rena vakuma maza ije Tama fune e nafekuveno ijia bu gake ame ije bu ufariki. ");
INSERT INTO bbb_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Areme Tama fune danuna ame nafekuveno ijia ame be fu umui abuemoga bara ije Tamado imeno ije fu ame ijadufuo umui ijia farei. Areme fune uri kaje kavuane ijia abena umui ijia kira areme kuae, Ame ige fu amureno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","30","Rove ame ije fu una umui merukoga uvia fuone ijare ude ari. Ijadufuo bara ije Tamado imeno ije fu kuae, Aneka koro giriesama arimano kuae. Areme fune uri ame amure ije abe ive ina e Ferezi kuae. Ro rade ame ije kaje kavuane kiraeva ije fu arimoga fu abe ive ina Zera kuae. ");
INSERT INTO bbb_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ijiege rena e Midianaetiko ije bune Josofu fuaevena mesiri ari vakuma gamia Ijifiti usiae. E ije bune usiaena buse Josofu dabe una Fotifa e ije e Ijifitiko ijiebuo kini ijadufuo are ije juo karijo ije samuamo ijiebuo e ireobo ije fuone fuaeve. ");
INSERT INTO bbb_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Areme e Josofu fune e ireobo fuone e Ijifitiko ijadufuo are ijia fina fuefuo imei. Fu ijia fina imekoga E Ireobo Godi fuka Josofu marejana mukoreigia ifejakoga fu ire boeje mukoreigia renoe. ");
INSERT INTO bbb_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","4","Josofu fu ijiege renoenoga e ireobo fuone ije fu gake Godi fune fu mukoreigia ifejako fu ire boeje mukoreigia renoeno ijadufuo fuka ireobo oemarei. Ijadufuo Fotifa fu Josofu kuamoga fu fuefuo ire boeje samuagiakinu ro e boeje are ijia imevo ije samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Maza ije Fotifa fu Josofu kuamo fu fuefuo ire boeje samuagiaema ijia Godi E Ireobo fu Josofudo duvado ijia e Fotifa daro mana fu mukoreigia ifejae. E Ireobo fu ijiege re areme uri ire boeje gire ijia naovo e ijia karivo ije ro aesakae fuone ijene marejana mukoreigia ifejae. ");
INSERT INTO bbb_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","7","Ijadufuo Fotifa fuka uri ire boeje fu abema ije fuka kena una Josofudo umui tare ijia nana kuamoga fure samuagiae. Ro Fotifa fu naebe una ire ijene vierafe ro fume oenoena kiaga bu ire ijiaru vajaga fu inoe. Ro e Josofu fuka e nikubae mukore ro kuke fuka e daroki. Areme rade maza be e ireobo fuone ijadufuo bara ije fu oenoekinu gaba urina Josofu kuae, Ani ro nosiki naeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Fu ijiege kuamoga Josofu fu ijuonena kuae, Na e ireobo none fu ire boeje gire igia naovo ije fuka kena una daro none ijia naejie. Fu na ma vierafema ijadufuo fu naebe una ire ijene uruvana vierafei. ");
INSERT INTO bbb_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","E boeje are guove igia imejo ije bu e anuigi baki. Naeje nare nosukua ire boeje fu vajiema ije samuagiave ro a osukua a bara fuone. Ijadufuo ro na izege uri Godi fu fina gieke na nidua fuone ijia vame ka omise ije rekono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bara ije fuka maza boeje Josofuo ijiege kuaru rove fu naebe fuosiki nae ro kuke fu naebe fu ivuake ijia oenoe. Ro fuka una fu aguaena mukoreigia samuae. ");
INSERT INTO bbb_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Areme maza be Josofu fune una gire ijia i fuone ijene mekiro aru vae. Ro maza ije e gire ijia buka ma baki. ");
INSERT INTO bbb_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Ijadufuo Josofu fu vakoga bara ije fu urina ugone jiagadogo fu abiema ijia farena uri kuae, Ani ro nosiki naono kuae. Bara ije fu ijiege kuamoga Josofu fu ijuonena keke kona vaga ugone fu ijia arene vakoga bara ijare abei. ");
INSERT INTO bbb_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","14","Ijiege rena Fotifado bara ije fu gake e Josofu fune kona keke makave ijia vake ugone fuone ije fu uria ijia namoga fu vierafeba uri vijena e konamoga e fari gue makave ijia imevo bu dabe abuena ruae. Bu rovoga fu kiae, Kame igia gafo. E Iburuko ije baru none fu fuaevena mesiri are ige fu nujaema ijare vame ige kema ige gafo. E ije fu igia aruna nosiki naekiro umuikiemo na vijevoga fu keke kona vae. ");
INSERT INTO bbb_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Fu keke kona vaga ugone fuone fu guraeji arena vaemano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Bara ije fu ijiege kuaria areme ugone fu abe ijia nijana fikoga Josofudo e ireobo fu vaema muge una ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Areme bara ije fu uri vua ijene dabe barufuo kuarae. Fu kuae, E Iburuko ije a fuaevena are igia nujaema ije fuka vame ise ije rena ige na naeva igia aruna na kie. ");
INSERT INTO bbb_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Rove naka urina uruke vijevoga fu keke kona makave ijia vagana ugone fuone fu igia arena vaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Areme Josofudo e ireobo fu bara fuone ijare vua ijeja kuaramoga fu fiemo fuka defarui. ");
INSERT INTO bbb_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","21","Ijadufuo fu uri e Josofu dabe kini ijadufuo dibure are be bu e dibureko uniana samuagiavo ijia nujae. Rove maza ije Josofu fu dibure fino ijia E Ireobo Godi fuka uria ijia fuosiki fikinu samuae. E Ireobo fuka Josofu marejana ifejakoga fu ire boeje binobino mukoreigia renoe. Ijadufuo e ireobo dibure samuamo ijiakiro e dibureko gue bu vame fuone mukore ije fu kemo ijene gae. ");
INSERT INTO bbb_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ijadufuo e ireobo dibure samuamo e ireobo ije fu Josofu abenoga fure una e dibure karivo ije gue samuagiakinu ro ire boeje binobino ijia redufuo fu ije kuariako bu renoe. ");
INSERT INTO bbb_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Ijadufuo rade e ireobo e dibureko samuagiamo ije fu i fuone fu meno boeje fu abena una Josofudo umui tare ijia nijana fu naebe una ijene ireobo vierafe. Ijadufuo maeje E Ireobo fu Josofuki oenoekinu mukoreigia samuana ifejakoga fu ire boeje mukoreigia renoe. ");
INSERT INTO bbb_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Areme rade maza be E Ijifitiko ijiebuo kini fu e inokiro kevo bu fuefuo imei. E be fu do vaeni bu kinido vese ruovo fu ije samuamo ro be fu burete ifaejemo. Ijadufuo rade maza sibaneke furikoga e inokiro bu ire be kini fu naebe oemarema ijene rei. ");
INSERT INTO bbb_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Ijadufuo kini Fero fu e inokiro ijene kena e ireobo e dibureko samuagiamo ije vajamoga fu kena are ije Josofu fu dibure fino ijia uniae. ");
INSERT INTO bbb_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","5","Ijadufuo e ireobo ijare e inokiro ijene kaenamia Josofu uniaejana kuamo fure samuagiae. E inokiro ije kinido burete ifaejemo ijiakiro do vaeni samuamo ije bu dibure ijia kari vakuma rade maza be e inokiro bu naka buone binobino naoe. Ro naka ijiebuo maeje bu binobino. ");
INSERT INTO bbb_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","7","Areme nituame suoke Josofu fu giaeja ruoma e inokiro ije giake buka naebe oemarei ro bu oefiaeguma kariva fu giae. Ijadufuo fu uri e inokiro ije kiae, Ja irerefuo iviama uikubae jone ja naebe oemare ro jaka oefiaeguma karivano kiae? ");
INSERT INTO bbb_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Fu ijiege kiamoga bu kuae, No e inokiro no naka nuvuone bino ivia muge naoe. Rove fu erare naka ijiebuo vua maeje kuaruoga no fiekuva bakino kuae. Bu ijiege kuaravoga fu kiae, Naka ijiebuo vua maeje kena kuaena giadufuo ije fu Godire korufuo redufuo. Ro ni naka izege ja naona irere ja giaeva ije kuarie na fieno kiae. ");
INSERT INTO bbb_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Josofuo fu ijiege kuariamoga e ije Kini Ferodo do vaeni bu amaeria ruoga fu samuamo ijare amure uri naka fuone ijene kuarae. Fu kua, Na nae gake ine bu do vaeni amaeriavo be fu nidua none igia manino na gae. Ro ine ije fu ajiana gome inokubeke atakoro fune migegire vi irasena fune suni kirakiro isuma areme fune fo fuone uruvana kiriavo na giae. ");
INSERT INTO bbb_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ro naeje na Kini Ferodo kafusi ijene umui none ijia fare. Ijadufuo nane uri ine ijadufuo fo ijene turana kafusi ijia musama abena Kini mavo fu ino na gaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Fu ijiege kuaramoga Josofu fu kuae, Naka ijadufuo maeje fu ijiege kuae, Ine vaeni gome inokubeke fu ataema ije fu maza inokubeke ijene. ");
INSERT INTO bbb_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Kini Fero fu maza inokubeke furike fu kuaga a dibure ige arena keke vake. A vaga fu i one ije e bu do vaeni amaeri ruoga a kena kini vajamo ije a ude mema fu ije kuaga a una meke. ");
INSERT INTO bbb_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Ro fu kuaga a i one una mekuma a isekie ni na ireobo vierafene. Ni noefuo Fero kuarana kuaga fu kenujiega na are ige arena keke vuane. ");
INSERT INTO bbb_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Naeje na aesakae none ije fu e Iburuko bu oenoejo ijia. Rove bu ebe na naebe oemarejieva ijadufuo bu mesiriena dabe ebuo are igia nujieva na iviama dibure igia five. Nana ire ise be na irere ije reva baki rove bume dabe dibure nijievano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Josofu fu ijiege kuaramoga e be ije Kinido burete mukore ifaejemo ije fu vua ije fie. Fu fieke Josofu fu naka ijadufuo maeje funeka mukoreigia kuaramoga fu fiena uri naka fuone fu naema ijene kuarae. Ijadufuo fu urina kuae, Na naka nae gake na kamui inokubeke nigofo none igia kei. ");
INSERT INTO bbb_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Ro kamui be ije na ado ijia nakeva buka burede ni binobino mukore Kini fu idufuo bu ifaejeva ijiebe ijia kari. Rove bune ume ijiebe arina nigofo none ijia ire burede ije bune ifurivano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","19","Fu ijiege kuaramoga Josofu fu kuae, Kamui inokube ije a giaema ijeja maza inokube ijene. Ro iviama igia vakuma maza inokubeke furino ije rade Kini fu kiaga bu a dabe ine ijia kira abieseke. Bu dabe ijiege kira abiesega a baronekuma ume ijiebe ro a dabe buvua ina furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ro nituame ije fune Kini Ferado mazani bu bieteva ijene. Ijadufuo Fero fune ire ireobo kanafuima areme e fuone imevo mamekanu ije kiamo bu ro i. Fu ijiege kia areme kuke e fuone imevo inokiro burete ifaejemo ijiakiro do vaeni samuamo ijene bie kiae. Ijadufuo bune dibure are ijia e inokiro ijene kaenamia e fuone imevo ijiebuo nidua ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","E boeje bu ijia afuikoga Kini fu urina e ije fu do vaeni ije bu ke ruovo ije samuamo ijene i fu meno ije abe una mae. ");
INSERT INTO bbb_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","23","Kini fu ijiege regaro una e be ije fu burete mukore ifaejemo ije fu kiamo bu kaje dabe uro ijia kirana abe ine ijia kira abiese. Bune izege Josofu fu kuariaema ijiege rei. Rove e ije fu Kinido do vaeni bu ke ruovo ije samuamo ije fu naebe una Josofudo vua ije fu Kini kuaradufuo fu kuaraema ije vierafe ro fuka totei. ");
INSERT INTO bbb_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","2","Areme vakuma juaevasia inokiro furikoga Kini Fero fu naka be nae. Fu nae gake fu do ireobo Naerono kuavo uvuoka ijia manine. Fu ijia manikoga mave kau seveni ubaeradiana maturaeva ijiebe do guove ijia ajia usiae. Areme bune vajoma ije inoeve. ");
INSERT INTO bbb_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","4","Bu ijiege inoekoga kau una kuke seveni (7) ijiege budua bu una do ijia ajiae. Ro kau rane ije ajiaeva ije buka garuradiana suri nujiama ikene ane ajiausiae. Bu ajiausiaena bune va kau bino ije bu do zinuine ijia vajoma inoejo ije ivuake ijia oenoeve. Bu ijia oenoekinu mave-kau seveni (7) gue ije ubaeradiana maturaeva ije sakiana buvua ivo Fero fu giana uri. ");
INSERT INTO bbb_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","6","Fu ijiege nae areme una kuke naka bedua nae gake kumune seveni (7) ijiege bu ane besu ijia kiraeva fu giae. Ro kumune ome maeje fu bijiaema ije fuka mukoreigia bijanoema arei. Areme fu una kuke gake kumune seveni (7) ijiege bu una kuke ane besu ijia kiriavo fu giae. Ro kumune rane ije ajiaevo fu giaema ije buka isesina ro kuke fune majaufi are mazani ajiamo nake ufemo ijare ufina turakorenoena arei. ");
INSERT INTO bbb_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Kumune isesina seveni (7) ijiebe una kumune gue ije bune mukoreigia maradiaeva ijene kame ivoga fu giana uri. ");
INSERT INTO bbb_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ijiege rena Fero fu naema suoke urina naka ije fu naema ije vierafega fuka naebe marei. Ijadufuo fu kiamogana bu urina aesakae Ijifiti guove ijia e kineki ije ro e mukoe vierafevo ije kiamoga bu kaenamiana ijia afui. E boeje bune ijia afuivoga fune urina naka fu naema ijene kuariae. Rove e besukua be fu naebe naka fuone ijadufuo maeje una kini kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Areme e ije kini ijadufuo do vaeni bu vese ruovo ije samuamo ije fu urina kini kuae, Na iviama ijare vua be na kuaradufuo na totiemo na areva na ije vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Na e kai none ije farava mukore ifaejemo ijiakiro na ije no are ude ziegafuona kaenamuo dibure unue. A dibure unuomo no e ije dibure juo karijo ijiebuo e ireobo ijadufuo are ijia kari. ");
INSERT INTO bbb_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ro muge be e inokiro ije no naka bino naoe rove naka ije no fuosiki naoeva ijiebuo maeje fuka binobino. ");
INSERT INTO bbb_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ro e Iburuko be e dibure juo karijo ijiebuo e ireobo ijadufuo imeno ije fu noena ijia fino. No naka nuvuone besubesu no naoeva ijene kuaravoga fuka naka ijiebuo maeje mukoreigia kuarue. ");
INSERT INTO bbb_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Ro naka ijiebuo maeje fu kuaruema ije ire maeje buneka izege fure kuaruema ijiege riarei. A i none ije a dasuaejiema ije ane abe una igie mie. Ro una kai none ije ane kiamoga bune kaje dabe uro ijia kirana abe ine ijia kiramo fune baronemano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Fu ijiege kuaramoga kini Fero fune kiamoga bune migegire dibure ijia Josofu mesirina ruae. Bu mesiri rovoga fune uri do ruema ijia mena areme uri ugone fuone iviaeko sama areme fune kini fino nidua ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Areme Josofu fune ijia manikoga kini fu urina kuae, Na naka be nae rove fu erare maeje kuariekuma baki. Ro na fie bu kie e bu naka naovo vua maeje are kuariamono kievo na fievano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Kini Fero fu ijiege kuaramoga Josofu fu una gue kuae, Kini e ireobo none, naeje naka baki. Rove Godi fu manido fure naka ijadufuo maeje a fiekiro vierafema ije fure kuarakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Areme kini fune urina kuae, Na naka naena gake naeje na do Naero zinuine ijia manive. ");
INSERT INTO bbb_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Na ijia manina giake mave kau seveni (7) ka ubaeradiana maturaeva ijiebe do ijia ajia usiaena bune vajoma inoeve. ");
INSERT INTO bbb_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Areme na una giakoga kau seveni (7) ka garuradiana ane samadireva ijiebe una kuke do ijia ajiae. Mave kau ije buka ma omise bu ude aesakae Ijifiti igia oenoevo na giaeva baki ijiebe ijia ajiae. ");
INSERT INTO bbb_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kau ise ane ajia usiaeva ije bune uri kau maeje ubaeradiaeva ije kame foteke sae. ");
INSERT INTO bbb_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Rove kau ije bu kame iva ije bu giaro bu naebe iva igeki. Ijadufuo maeje buje buka ma mukoreigia garuradiana suri nujiama areva na ije giana uri. ");
INSERT INTO bbb_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Areme na una kuke naka beduaku naena kumune seveni ijene giae. Kumune seveni ije bu ane besu ijia kiriana ome buone buneka mukoreigia bijana duma arei. ");
INSERT INTO bbb_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Ro na una kuke nae gake kumuve seveni bino dua una ane besu ijia kiriavo na giae. Ro kumune ije buka ane isesina bu majaufi feteki are ine baki ijia ufino ijare ufina nijako buneka garuradiae. ");
INSERT INTO bbb_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Kumune ije garuradiaeva ijiebe urina una seveni gue ije bu mukore ubaeradiaeva ijene kame ivo na giae. Na naka inokiro ije naena una e kineki ijene kuariae rove maeje bu naebe una kuarievano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Kini Fero fu ijiege kuaramoga Josofu fu kuae, Naka one inokiro ijiebuo maeje bu ni besu. Ro ije fu Godire izege fu rade redufuo fu ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Mave kau seveni a giaema ijeja juaevasia seveni ro una kumune seveni ubaeradiaeva ijiebuo maeje fune besu juaevasia seveni ijene. ");
INSERT INTO bbb_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Ro una kau seveni suri uniama ane ijiaru ije bu do ijia ajiaeva ijiakina kumune garuki ije majaufi ijare nijako bu garuradiaeva ijeja juaevasia seveni fuka vasia kekedufuo ijene. ");
INSERT INTO bbb_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Naka ije fune izege na kuaraeva fune ijiege redufuo Godi fune irere fu rade rekuveno fu ijene nijasae. ");
INSERT INTO bbb_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ijadufuo juaevasia seveni guove ijia aesakae Ijifiti igia ire ije fuka ma zaraeke. ");
INSERT INTO bbb_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Ro una rade juaevasia seveni ruakuma ije fuka vasia ma ireobo kekena aesakae ige fuka dabe nibe reke. Fu ijiege kekemo ije e bu izege una juaevasia maeje fu ude furima ije vierafekuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Ijadufuo maeje maza ije fuka ma omise ijare roga vasia ije fu keke are ige miane igege naeke. Fu ijiege kekemo ije bu izege una mazani maeje bu ude biediae ije vierafekuva baki. ");
INSERT INTO bbb_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Naka inokiro ijiebuo maeje na kuaravo ijeja fune Godire korufuo iviama igiebure rekiro fune ijiege vierafena kanafuido fu arekuma bakiro fu redufuo. ");
INSERT INTO bbb_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Ijadufuo a arekuma bakiro nika e be mukoe vierafekinu kenoeno ijia abega fure aesakae ige foteke samuaene. ");
INSERT INTO bbb_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ro kuke e bino ke areme kiaga bu uije binobino ivo bu ovo ijene bino karinoedufuo. Bu juaevasia seveni guove ije ire zaraemo ijia ijiege karidufuo. ");
INSERT INTO bbb_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","E ije kuariaga buka juaevasia seveni maeje ire zaraemo ijia ire ijene karine. Ani e ijene kena daro miaga bu ire ije karina sidove mamekanu guove ijia ujaka sana ijia nane. ");
INSERT INTO bbb_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ire ijeja e aesakae Ijifiti igia karivo ijiebuo. Bu juaevasia seveni Ijifiti igia vasia roga bu idufuo ijene. No ijiege mukoreigia rekuva vasia ije fu naebe aesake ige dabe arafiridufuo. ");
INSERT INTO bbb_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Josofu fu ijiege kuaramoga kini Ferokiro e mamekanu fuone imevo ije bune vua ijene fiena abe marei. ");
INSERT INTO bbb_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Areme Fero fune una e fuone kiae, No e mukore be e Josofu vareki fu mukore kemo ije no era abekuva bakino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Kini Fero fu ijiege kuaria areme una Josofu kuae, Vua boeje ige a kuaema ije funeka Godire korufuo nijasakoga a kuae. Ijadufuo no vierafega e a vareki mukoe vierafena kenoeno ije be igia fuka baki ro ane are osukua. ");
INSERT INTO bbb_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ijadufuo na a kuaga are aesakae none igadufuo e ireobo rena samuake. A ijiege samuake e boeje ige bume vua a kuariamo ijia fiekinu kenoeke. A daro none na abeva rotire ijia fina e boeje isesina ro mamekanu ro ire boeje samuagiake. ");
INSERT INTO bbb_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Ijadufuo ivia na a abega are aesakae Ijifiti foteke samuakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kini ije fune Josofu ijiege kuaraema areme uri umui rini fuone ije fu kini redufuo bu abe daro mana abiesejaeva ijene damui. Fu damuna abe una Josofu umui ijia abiesejae. Areme fune uri ugone ni mukore bu saguiva ijene kiamo bu abe abieseja areme uri uniae be bu zine igege iramo bu ire gorodi ijia amaeriva ijene dabe uro ijia kirajae. ");
INSERT INTO bbb_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Areme kini Fero fune kiamo bu uri fata sariotino kuavo ije fuone be abena Josofu mamo fu ijia ajia fi. Areme Fero fune uri dabe aroena e juo karijo ijene kiamo bune mesirina usiae vae. Bu ude usiae vakinu kume, Bio vafono kumei. Ijiege rena kini Fero fune Josofu daro mana kuamoga fu aesakae Ijifiti ro ire boeje ijia naovo ijene samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Areme Fero fune urina e Josofu kuae, Na kini Fero nare kuaedo e binobino bu Ijifiti igia ire binobino renoekuva buka ude a kuara a giake bu sone rade renoedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Ijadufuo Fero fune uri Josofu ive be ina e Zafenati Faniano kuae. Areme fune uri e zinone ifaejemo be Ijifitiko ive fuone Fotifera fu sidove ireobo Oni ijia fino ijadufuo kabae fuone Asenati ije dabe mae. ");
INSERT INTO bbb_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Ijiege rena Josofu fune juaevasia teti (30) ijiege furikoga fu ijia uri zinuevena Fero e ije aesakae Ijifiti ije samuamo ijadufuo imei. Josofu fune kini ijadufuo are ijia fikinu kekena va are binobino ijia gianoekinu i menoe. ");
INSERT INTO bbb_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Areme juaevasia seveni ije fuka ire ma uruvana igia zarae. ");
INSERT INTO bbb_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Aesakae ije funeka ire zaraemoga Josofu fu ijia ura oenoekinu kumune gue fuaevena kanafui sidove binobino ijia nanoe. Fu sidove besubesu irifo ijia juare bu menoeva ijia kumune kanafui. ");
INSERT INTO bbb_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Juaevasia ijia ire ije funeka ma urukeigia zaraemoga Josofu fu sidove besubesu ijia ire ije fu kanafuimo ije funeka ma uruvana ire davare ajare igeki. Ijadufuo Josofu fu ire fu dakinu karinoeno ije fu ijia aregana fume karina afui. ");
INSERT INTO bbb_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ro maza ije vasia ireobo fu naebe kekema ijia Josofudo bara Asenati fu ame inokiro nafei. ");
INSERT INTO bbb_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Areme Josofu fu kuae, Godi fune na ma rejiena ifejiemo ijadufuo nane izege na isejavaeva ijiakiro asoe none ijadufuo agane ije nane totevano kuae. Ijadufuo fune uri fari fuone amure ije abe ive ina Manasano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Areme fu una kuae, Godi fune aesakae ige na fina isejavaevo igia ame vajie. Ijadufuo fu urina ame iviene ije abe ive ina Ifiremino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Areme juaevasia seveni (7) ije ire zaraema ije fune ruoma ubine ijia kekei. Areme juaevasia seveni (7) ma ise ire daturamo ije fune ijia zinueve. Ro ije fune izege Josofu fu ude kuaema ije riarema ijadufuo aesakae Ijifiti ijia ire ijia fu uria mani. Ro una aesakae gue Ijifiti ivuake ijia karinoeva ije buneka ire daturae. ");
INSERT INTO bbb_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Ijiege rena vakuma e Ijifitiko bune zinuevena vasia abekinu uri Kini irefuo dabe kuakuae. Bu dabe kuakuavoga fu kiae, Ni una va Josofu fino ijia vaga fu irere kuariaga ijene fiena reno kiae. ");
INSERT INTO bbb_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ro vasia ije aesakae Ijifiti ijia funeka ma ireobo kekei ijadufuo Josofu fune uri ire kumune ije fu aesakae binobino ijia kanafui naema ijene karina e Ijifitiko ijiebuo fuaeve. ");
INSERT INTO bbb_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Vasia ije funeka aesakae irore boejia keke ijadufuo e boeje binobino bune Ijifiti ijia Josofudo kumune fuaevekuae ruae. ");
INSERT INTO bbb_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","2","Areme maza be Jekafu fu fieke aesakae Ijifiti ijia e buka ire kumune uruvana ivo fu fie. Ijadufuo fu urina farirafa fuone ije kiae, Ja irerefuo dazena karina vierafeve? E aesakae Ijifiti kariva buka ire kumune uruvana ivo bu kuarievo na fie. Ijadufuo ni va ijia kumune bino fuaeve roga no idufuo ro bakuva noneka isejavaena oekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Ijadufuo Josofudo uviarafa teni (10) ije bune urina aesakae Ijifiti ijia kumune fuaevekuae bune vae. ");
INSERT INTO bbb_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Ro Jekafu fu Josofudo iviene fuone e Bezimani ije fu naebe abena nujaejiae. Ijadufuo maeje fu vierafero fu nujaejia bu mesiri vakuva fu vajae fiane bino biediakumaro fu ijare. ");
INSERT INTO bbb_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Fu arekoga bofari gue bune e ijena Ijifiti ijia kumune fuaevekuae vae. Ijadufuo maeje Kenani ijia fuka vasia ma ireobo kekei. ");
INSERT INTO bbb_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Ro maza ije e Josofu fu e ireobo rena aesakae Ijifiti samuamo ijadufuo fure kumune ije riena e boeje ijiebuo fuaeveno. Ijadufuo uviarafa ije bune vakuma gamia usiaena va Josofu fino ijia usiaena uri nidua fuone ijia atogesana kurituakafae. ");
INSERT INTO bbb_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Bune ijiege revoga Josofu fune samadukua giana vierafe rove fu biesiriana e bino igege vua kuriaekuriaeki kuariae. Fu uri kiae, Ja e gure ja e izekono kiae. Fu ijiege kiamoga bu uri kuae, Noeje no e Kenaniko no igia ire kumune fuaevekuae ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Josofu buje fune samadukua giana vierafe rove bofari ije bu naebe mukoe gana vierafe. ");
INSERT INTO bbb_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Ro Josofu fune naka fuone izege fu naena bu giaema ije fune vierafe. Ijadufuo fu urina kiae, Jaeje jaka kufuimena ura oenoekinu aesakae nuvuone ige no avaeguonoeve. Ja oenoekinu guoga no iziebure mamoena isema renoeko ro iziebure none mukoe revo ja ijene guonoejono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Fu ijiege kuariamoga bu kuae, E ireobo nonoka baki. Noeje nome e one imejo no kumune fuaevekuae ruae. ");
INSERT INTO bbb_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Ijadufuo a isekie, no e ige noka gaegi ijiaru ruae. Ro nonoka e ma no biesiriana ro ja avaegianoevo bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Ro Josofu fu una kiae, Jaka kufuimeve. Ja igia oenoekinu are iziebure no naebe samuavo ja ijene guonoevono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Ro ame ije bu una kuae, No ame tuero (12) ige no e be e Kenaniko ijadufuo anafa ro noeje noka gaegi ijiaru. Ro ame iviene nuvuone be fune baronei ro be ma iviama ije fu uria asoe nuvuone ijiaki gafia fino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Rove Josofu fuka una kiae, Na vua besu nane kuariave. Jaeje jaka kufuimena ro no avae guonoeve. ");
INSERT INTO bbb_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Naka kinido ive ijia kurana kuariavono ige fiefo. Ja ame iviene jone gafe ja naebe mesiri igia ro na gakuva jaeje ja una vakuva baki ro jaka igia karidufuo. Na vierafe na ijiege rena giaga ja irerefuo igia ruaeva na ije maeje gake. ");
INSERT INTO bbb_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Ro e boeje jaeje na kia bu faradia igia karike e be fuka una va ame iviene gafe mesiri ruake. Ja mesiri igia roga na ijare vua jone ja kuarieva maeje gake. Ro bakuma naka kini kuaraedo na vierafe jaka kufuimena no avae guonoevono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Josofu fu vua ijiege kuariama areme kaenamia dibure ijia uniamo bu mu inokubeke ijia kari. ");
INSERT INTO bbb_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Areme mu inokube furinoga Josofu fu uri kiae, Naeje na e be Godi ma vierafekinu jumevo. Ijadufuo na vierafe na vame be rerena karauniaga ja vake. ");
INSERT INTO bbb_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ijadufuo ja vierafega jane ma kuarievoga na vierafe e besu fu dibure igia fike. Fu igia fike e gure gue ni kumune ije ja fuaeveva ijene kena una va agane jone gafe bu vasia abevo ije vajiafo. ");
INSERT INTO bbb_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Areme nine iviene jone be ijene mesiri una roga na gafo. Ja ijiege rega na ijia giana vierafero jane ma kuarievo ijadufuo nabe kaniaga ja oekono kiae. Josofu fu ijiege kuariamoga bune oemarena buone avenami. ");
INSERT INTO bbb_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Areme bu una bue kuae, Iviama vame ige binobino bu nuvuone reko no isejavaevo ije noneka vajae fiane izege no uvia nuvuone Josofu vajaeva ijadufuo no ijene abeve. Noka fu dabe arafirina irufui vajavo fuka vajae fiaemoga fuka no soesoena anadue. Rove vua fuone noka naebe fiejae ijadufuo iviama irufui ige no ijene abevono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ro e Josofudo bo fuone be fu urina kiae, Nana ijadufuo ja ame ije kanavoga na vafiavoga jaka naebe fie. Ijadufuo iviama irufui ige no abevo ije no ame ije no kanavo fu baronema ijadufuo irufui ige no ijena abevone kiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Ro Josofu fu vua irere bu kuaevo ije fune fie rove bofari ije bu vierafero fu naebe fiemoro bu ijiege vierafei. Ijadufuo maeje bofari ijiebuo vua ije bu Josofu kuaravo ije fu e bese fiena una Josofu kuaramo. ");
INSERT INTO bbb_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Ijiege rena Josofu fu vua buone bu kuaevo ije fiega funeka oe uruke fiaemoga fu arena va sauina ireobo nimei. Areme fune maemoga fu una kekena e kiamoga bu uri nidua buone ijia e Simioni farena umui kame ijueneke kiriaejae. ");
INSERT INTO bbb_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Areme Josofu fune urina e imevo ije kiamoga bune uri kumune ije karina bofari ijiebuo kamui ije bu kena vaeva ijia riejiae. Ijiege rena fune kuke kiamoga bu uri moni buone bu kumune fuaevekuae kena vaeva ijene karina una e besubesu ijiebuo kamui bu kumune riejiaeva ire ijia kedejiae. Areme fu kiamoga bune kuke uri ire bu ikinu una vadufuo ijiakuma vajiae. Josofu fu ijiege rena ire boeje kiako bune kanafujiama fune furi. ");
INSERT INTO bbb_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Areme Josofudo bofari ije bune uri kumune bu fuaeveva ije karina mave doniki ado ijia nana saguma areme bune una vae. ");
INSERT INTO bbb_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Bune una vakuma vame gafia are be ijia naokuae kari. Bu kariva ijia e be fu mave doniki fuone ije ire vajakiro uri kamui doekuma fuka moni fuone fu kumune fuaevema ijene una kamui ire ijia giae. ");
INSERT INTO bbb_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Areme fu una uviarafa gue ijene kiae, Na moni none na kumune fuaeveva ije e Ijifitiko buka kena una kamui none ire igi kedejieva ige giano kiae. Fu ijiege kuariamoga ame boeje bu vua ije fievo buka urukeigia judiae. Ijadufuo buka safuikinu una bue kuae, Godi vame ije fute irere ije rejuemano kuae? ");
INSERT INTO bbb_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Bu ijiege reva bune una vakuma Kenane asoe buone Jekafu fino ijia usiaena vua izege bu reva ijene fu kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bu kuae, No vakoga e ireobo aesakae Ijifiti samuamo ije fuka vua gikikimana no kuarue. Fu vierafero noeje no mauike aesakae buone ijia ura avae gianoevoro fu ijadufuo no umui bijuona vua gikikimana kuarue. ");
INSERT INTO bbb_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Fu ijiege kuaruomoga no kuae, Nono are ige ura mauike avae gianoevo baki ro noeje noka e ma. ");
INSERT INTO bbb_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","No ame boeje tuero ije noka gaegi ro asoe nuvuone ije fu besu. Ro ame iviene besu fune baronei ro ma iviene ijiaru fu uria Kenani ijia asoe nuvuone ijiaki fino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","No ijiege kuaravoga e ireobo ije fu kuo, Na vierafe na vame be rena ja biesiria giaga jane ma kuarievo na ije giakono kue. Ro e besu fu igia fikiro gue ni kumune ije karina una agane jone gafe vasia abevo ijene vajiano kue. ");
INSERT INTO bbb_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Ro ja una ruakuva nika iviene jone ije mesiri una ige na fivo igia ruafo. Ja ijiege rekuva na ma vierafero ja avai guonoevo baki ro jaka e maro na ijiege vierafeke. Areme na uvia jone Simioni abe una nujaejiaga ja ura ire binobino ja vierafeva ije renoeno kuekmano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ame ije bu ijiege asoe buone kuarama areme ame boeje bune uri kamui ije bu kumune keva ije kame i kuderiae. Bu ijiege usiasema areme giake e besubesu moni buone bu ke vaeva ije e Ijifitiko ije bu kame una kamui buone ijia kedejiaevaga bu giae. Ame ije bu asoe buone ijena ire ijene giavo buka ireobo judiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Ijadufuo Jekafu fu uri kiae, Ja anafa none jare ijiege rena ame none inokiro jane kame izege uniaejie. Ude ja Josofu babue areme una Simioni babue. Ro iviama ja una kuke Bezimani mesiri vakuae kieve. Jaja ijiege abekoke naeje naneka ma urukeigia isejavaevo jabe gievono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Jekafu fu ijiege kuariamoga e Rubini fu uri asoefuo ijiege kuarae. Ate, ame ije abe nujaejiega nare mesiri vane. Na mesiri vaekina na naebe una mesiri ruakuva nine ve ame fari none inokiro ije kaniaga bu oeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Rove Jekafu fu una kuae, Na fari none ige nabe nujaejiake. Ijadufuo maeje uvia fuone Josofu ije fune baronei ro fune fuosukua uria fine. Ro kuke naeje nane eoradie ijadufuo ja mesiri vaga ire ise be fu fuone rekuma jaka una oefiane abe na mieke. Ja oefiane abe miekuva funeka ijare kaniega nane baronekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","2","Ro are Kenani ijia fuka vasia ma ireobo kekei ro Jekafudo agane kumune bu Ijifiti ijia fuaevena ke ruaeva ije bune kira ina furi. Ijadufuo Jekafu fu una anafa fuone kiae, Ni una va kumune binodua fuaevoga no ino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Rove Juda fu una Jekafu kuae, Ate e ireobo ije are Ijifiti samuamo ije fuka vua daro darokuma kuaruomo no ruae. Fu kuo no nuvuonukua una vakuva fube kuoga no fu gake. Ro no iviene nuvuone ije mesirina vakuva fu ijare kuoga no va fu gakono kue. Ijadufuo a uvia nuvuone Bezimani mesiri nujaejuo fu noena vakuma no ijare kumune bino fuaevena ruake. Ro fu naebe noena vakuma no kumune bino nobe fuaeve ruakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Juda fu ijiege asoe fuone kuaramoga Jekafu fu urina kuae, Ja irerefuo e ireobo ije kua no iviene nuvuone be gafia fino kuae. Vame ije jaka irufui binobino kekena na vajievono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Ro anafa bu urina kuae, Fune e ijare ka korufuo no abero agane nuvuone ijiebuo duna binobino kuarue. Fu kuo, Ja asoe jone fube uria fi ro kuke jabe iviene jone beno kue. Ro no iviene nuvuone no mesiri vadufuo fu kuaruokuveno ije noka naebe vierafe ijadufuo no ijiege kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Areme Juda fune urina asoe fuone kuae, Ni e Bezimani nujaejuoga no migegire vaekina no kumune fuaevena una ro ikinu karine. Ro bakuma a ro no ro anafa nuvuone ije boeje noka isejavaena oeke. ");
INSERT INTO bbb_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Nare kuavo ijadufuo ni nujaejiega na mesiri vaekina no una rone. Ro na naebe mukoreigia mesirina una ruakuva ni irufui ije arega fu maza boeje nosiki navane. ");
INSERT INTO bbb_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","A maza nuvuone no va gamia usiae una ruaekino una vadufuo ije aka dabe fareko funeka saroemono kuae. No ude Bezimani mesiri vaeva bitie iviamaige none ire karina una ruae. Rove no naebe ijiege rei ro noka mazani nuvuone dabe igifure nisevono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Ro asoe buone fu urina kiae, Ja vierafe Bezimani fu jaena vakuma nine ire ma bino aesakae nuvuone igia naovo ije karina vaekina e ireobo are Ijifiti samuamo ije vajafo. Ni ire oere udi mukore urimo ijiakina munikokina ia udi mukore urimo ijiakina ine fititasi fo ire makame igeki ijiakina ine arimoni ijadufuo fo ijene karina vaekina e ije vajafo. ");
INSERT INTO bbb_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Ro kuke ni moni ja kumune fuaevedufuo ijene kero bino nime moni ije bu bigiake kena una kamui jone ijia kedeva ijadufuo kena vafo. ");
INSERT INTO bbb_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Ni ije kena nine uvia jone Bezimani mesirina jaena migegire una vafo. ");
INSERT INTO bbb_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Na Godi e daroki ije baname isoega fure e ireobo ije are Ijifiti samuamo ije oe fuone dabe dakudega fu ja giana oefiane abeke. Fu oefiane abena e Bezimanikiro uvia one be ijene ke uniaejaga ja kaenamia una ruake. Ro na ijeja ame none gue bu una kuke ijiege oega na oefiane abekuva ije fure marekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Areme ame gaegi ije bune urina sinuome buone maeje bino bu kini subijadufuo ro moni ka ma uruvana bino duaku kari Bezimani mesirina bune Ijifiti vae. ");
INSERT INTO bbb_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Bune vakuma Ijifiti usiaena bune aruna Josofu fino ijia vakoga fu uri Bezamani gae. Fu ga areme uri e fuone imeno ije kuae, Ni e ige kaenamiana are none ijia vane. A kaenamia va ijia unia bu karike ni fanu be kana kiraga bu maza uvuoka manino ijia naena ire ino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Josofu fu ijiege kuaramoga e fuone imeno ije fune urina ije fu kuaraema ijiege rena fune uviarafa fuone kaenamiana are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Fu kaenamia ijia vakoga buka ireobo jumena una bue kuae, Noeje bu irerefuo kaenamuona igia ruove? Bu bite maza ije no iko igia rovoga bu moni ije kena una kamui nuvuone ijia keva bu ijadufuo kaenamuona ruove. Bu ijadufuo toenamuo ruodo bu no kanuo areme kuoga no fuefuo moni baki imenoeke fu mave doniki nuvuone ije una fuone kekiro remono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","21","Areme bune vakuma kini ijadufuo are gafia usiaena bune va e ije Josofudo imejo ijiebuo e ireobo ije kuae, E ireobo a isekie igia fiene. No ude ro igia Ijifiti kumune fuaevena none una vakuae vae. No vakuma vame gafia ve mumoga no naokuae kariva ijia no kamui nuvuone besubesu ijia moni ije no kumune fuaeveva ije no una kamui ijia kuarae. Ro moni ije no karaeva ije no una kena igie ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Ro moni ige no una kuke kumune binodua fuaevekuae no ije kena ruae. Ro moni ije fu erare kena kamui nuvuone ijia kedema ije noka naebe vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Ro e ije Josofudo imejo ijiebuo e ireobo ije fu uri kiae, Ije fune ijeno jade una ijadufuo ireobo vierafevo. Moni ije fune Godi jone ije ja asoe jone ijena fuone baname isoevo ijare kena una ijia kedejiae. Ijadufuo maeje na moni jone ja kumune fuaeveva ije nane foteke kevano kiana fune va e Simioni mesirina una ro nujaejiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Areme e ije Josofudo imejo ijiebuo e ireobo ije fune kaenamiana va Josofudo are ijia uniamo bu karikoga fune va do jiana ro miamo bu dia buone sokoga fu mave doniki buone ire vajiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Ro Josofudo uviarafa ije maza uvuoka bu fuina ire ikono kiaeva ijadufuo bu urina sinuome bu Josofu vajadufuo ijene kanafui. ");
INSERT INTO bbb_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Areme bune karigake Josofu fune romoga bu uri sinuome ije kena ja vaja areme uri fu aguarana fu manino ijia auge sana kurituakafae. ");
INSERT INTO bbb_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Bu ijiege revoga Josofu fune izege bu ruaeva ijadufuo kuariama areme urina kiae, Ro asoe jone ja ude ro kuarieva ije fube uria ma fino kiae? ");
INSERT INTO bbb_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Ro ame gaegi ije bu urina kuae, Ke asoe nuvuone fu oefuo imeno ije fu uria ma fino kuae. Bu ijiege kuara areme una kuke Josofu kurituakafae. ");
INSERT INTO bbb_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Areme Josofu fune urina ame ije giaeja vakuma e Bezimani iviene fuone maeje asie fuone ijare buobiki nafema ije gae. Fu gana uri kiae, A ame gare fu iviene jone ije ja fuesina kuarieva ijeno kiae. Areme fu uri Bezamani kuae, Farino na vierafe Godire a marejakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Fu ijiege kuaramo fuka oefiaemoga fu migegire urina guove fu naeno ijia aruna nimei. Ijadufuo maeje Bezimani fuka ma ireobo oetuamo ro kuke fuka ma iviene fuone. ");
INSERT INTO bbb_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Fu aru va nimena furi areme uri nikubae fuone do soma areme una keke zinune manimega e fuone imejo ije kiae, Ire ije ja kiraeva ijene vajuo no ino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Areme Josofu fune fuosukua fata be ijia fina ire ikoga uviarafa fuone fu kiavoga bu buosukua fata be ijia karina ire i. Ro kuke e Ijifitiko ije duaku fu kiamo bu fata be ijia karina ire buone i. Ijadufuo maeje e Ijifitiko ije bu e Iburuko ijena bu besu ire inoevo baki. ");
INSERT INTO bbb_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Ro Josofudo uviarafa fata ije bu karina ire ivo ije nikubae buone bu una Josofu fino nake ijiege karina ire i. Ro fata ije bu kariva ije bu ame amure ijare fikoga gue bu ijia karijana vakuma areme ame iviene ijare ubine ijia fikoga bu ire i. Bu ijiege karina ire ivo ijia bu uri korubuo izege bu kariva ijene ganamivo buka oeseradiae. ");
INSERT INTO bbb_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Ro ire buone ije bu ivo ije bu re ije Josofudo fata ijia naeva bu ijia tuana vajiavo bu i. Ro ire ije bu ivo ije e Bezimani buka ire ma uruvana vajae ro ame gue ije bume sibaneke vajiae. Ijiege rena Josofudo uviarafa ije buka maza ma ije abena fuina besu oemarekinu irekina do ijene i. ");
INSERT INTO bbb_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Areme Josofu fune urina e ije bu fuone imevo ijiebuo e nigofo ije fu are fuone ije samuamo ije vua izege fu redufuo ijene kuarae. Fu kuae, Ni e gure ruaeva ijiebuo kamui ije bu ire ke vadufuo ije vierafekina kumune bino karina ijia riejiane. Areme ni moni buone bu kumune fuaeveva ijene karina una kamui buone ijia abie kedejiane. ");
INSERT INTO bbb_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Areme ni ame iviene ijadufuo kamui ije kumune diboure rie ro itire ni kafusi none ire siriva ijia amaeriva ije abe ijia kedeno kuae. Josofu fu ijiege e fuone imeno ijene kuaramoga e ije fune ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Areme bune naoeva suoke mugamia bune urina doniki buone kena bune una vakuae vae. ");
INSERT INTO bbb_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ijiege rena bune sidove ije sibaneke arena vako ijia Josofu fu urina e fuone imeno ije kuae, Iviama urina e ige vako ijene nuvediane. A nuvedia va biediakuma ni kia, E ireobo none fuka ja marejiae ro ja irerefuo una ise ije fuone rei. Ja irerefuo kafusi fuone bu ire siriva ijia amaeriva ije iniemena abe ruovono kiane. ");
INSERT INTO bbb_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Ire kafusi ja abe ruovo ije fuka ijia do ino. Ro kuke fu kafusi ijare ire bino bu rekuvejo ije nijaeko fu ijia giamo ja ije abe ruaevano kiane. Vame ije ja reva ije jaka ma ise ije revano kiane. ");
INSERT INTO bbb_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Ijadufuo e ije Josofudo imeno ije fune nuvediana ja biediana Josofu vua izege fu kuaraema ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Rove Josofudo uviarafa ije bu urina kuae, E Ireobo a vua ije irere kuaemo ije no naebe vierafe. Noka E Ireobodo ive kurae no ire ise ijieki ije noka naebe rei. ");
INSERT INTO bbb_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Ro moni ije kamui nuvuone no kumune keva ire ijia bu kedeva ije none Kenani giana kara una gafia vua vajiae. Ro no irerefuo e ireobo one ijadufuo are ijia ire siriva ro gorodi ije iniemeke? ");
INSERT INTO bbb_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ni kamui nuvuone ijia reregaga kafusi ije erare abejoga e ije nika kana fu baronekiro e ige gue noeje ni arega no una oefuo moni baki imeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Bu ijiege kuaravoga e Josofudo imeno fune urina kiae, Ije fune maredo nane ja kuarieva ijiege reke. Ijadufuo na vierafe na e ije erare kafusi ije abema ijiaru mesiri una vaga fu noefuo moni baki imekiro e gure gue jaeje ni vano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Areme ame gaegi ije bune migegire kamui bu keva ijene kari ume ijia na areme bune kamui itire fadia irae. ");
INSERT INTO bbb_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","13","Bu fadiana irakoga e ije Josofudo imeno ije fune urina ame boga ijadufuo kamui ijia zinuivena kafusi ije rerei. Fu rerena ruoma Bezimanido kamui ijia kafusi ije kei. Fu ame iviene ijadufuo kamui ijia kafusi ijene kemoga uviarafa fuone buka ma oefiadiamoga bu urina ugone buone farae. Areme bune doniki buone kena una gamia Ijifiti sidove ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","15","Juda fune uviarafa fuone kaenamiana una vakuma gamia keke gake Josofu fu uria are fuone ijia fine. Fu ijia fino bu usiaena nikubae fuone ijia tuana ume ijia dijevoga fu urina kiae, Ja izege rega ja una ruove? Ja vierafekuae nabe giakono kuaena ja ijiege revano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Juda fu urina kuae, E Ireobo no vierafe no vua irere kuarakuva baki. Ro kuke no izege kuaeko ire ije no naebe revano kuaeke? No isema rekuva ije fune Godire guona vierafeke. Ijadufuo ivia e boeje ige none oefuo moni baki imeke. Ro ade e ije fu kafusi abema ijiaru mesiri vakiro nika nodua toenamuono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Rove Josofu fu urina kiae, Na irerefuo ja kame isekafiakuva baki. Rove name vierafe na e ije erare kafusi ije abema ijiaru mesiriga fure noefuo moni baki imeke. Ro ame gue jaeje nine oemarekinu una are asoe jone fino ijia vano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Fu ijiege kuariamoga Juda fu va Josofu fino ijia kekena kuae, E ireobo aka daro ma ireobo kini fu abema a ijiege abei. Ro naeje name e be oefuo imenoevo. Ijadufuo a isekie vua ige na kuaekuvejo ije abe fiena ziemo. ");
INSERT INTO bbb_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Maza ije no ruaeva ije a kuo, Asoe jone fube uria fino ro jabe ame ivierafa binono kue? ");
INSERT INTO bbb_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","A ijiege kuomoga no kua, Asoe nuvuone fu uria fi ro kuke fune eore ro fu ame iviene besuno kuae. Ro ame ijadufuo bo fuone ije fune baronemano kuae. Ro fune ame ijare uria fine ro asoe fuone fuka ame ije mukoreigia oetuamono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","No ijiege kuaravoga a kuo, Ni va ame ije mesiri roga na gano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Ro kuke no kua, Ame ije fu asoe fuone ije nujana ruakuma asoe fuone fuka baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Rove a kuo, Ja iviene jone ja naebe mesiri ruakuva jabe una na giekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Ijadufuo no una vaeva vua ije none asoe nuvuone ijene ijiege kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","26","Areme asoe nuvuone fu vierafe no una ro kumune bino fuaevekiro kuomoga no kua nobe una vake. Rove no una vakuva noka iviene nuvuone mesiri vakuva no ijare e ireobo ije gake. Ro no bakuva nobe nidua fuone ijia vake. Ijadufuo no una vakuva iviene nuvuone ije fuka noena vano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","28","Juda fu ijiege kuarana kuae, E ireobo no asoe nuvuone fu kuke kuaruona kuo fu bara ije fu oetuamo ijare ame inokiro ijene nafe vajie. Rove ame bu fune sauimo fu naebe gako funeka maza ireobo furi. Ijadufuo fu bite bune fanu taraeko ijiebe sakina dabe buvua ivaro fu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Ro fu kuke kuo, Iviama naneka eoradieko ja una kuke ame gure mesiri vako ije fu va irufui bino biediakuma ije jane na irufui vajiekuva naneka baroneke. ");
INSERT INTO bbb_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Asoe nuvuone fuka Bezimani ma ireobo oetuamo. Ijadufuoro no una asoe nuvuonedo are ijia usiae ro fu gake Bezimani fu naebe noena ruaeva fuka baronedufuo. Ro irufui ije no noeje no konuvuo amaeri. ");
INSERT INTO bbb_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Na asoe none na kua na mukoreigia samua vaekina una mesiri ruako kuae. Ro kuke na kua, Na naebe mukoreigia samuaga fu irufui biekuma nare irufui ije abekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Ijadufuo e ireobo a isekie, ni ivie none kuaga fu vakiro nare are fuone ije abene. Nare are fuone abena oefuo moni baki imene ro Bezimani fu uviarafa gue ijena una are vadufuo. ");
INSERT INTO bbb_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ro Bezimani fu naebe nosiki una vakuma naka izege asoe none ijadufuo niome ije gake? Ro fu oefiane abekuma na izege irufui fuone dasumakuva bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Ijiege rena Josofu fu vua ije fiemo fuka ma ireobo oefiae ijadufuo fu izege rekuma baga fu uri e fuone imevo ije kiamoga bu are guove fu fino ije arena usiae vae. Bu usiae vakoga Josofu fu fuonukua uviarafa fuone ijena manino ijia fu urina ive fuone ijene samadukua visu kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Fu ijiege kuaria areme uri urukeigia nimeno e Ijifitiko ije bu fiena uri are kini fu fino ijia afuina vua ije dabe kuae. ");
INSERT INTO bbb_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Ijiege rena Josofu fu urina uviarafa fuone ijene kiae, Naeje na Josofu nare. Ro asoe none fube uria fino kiae? Josofu fu ijiege kuariamoga buka ireobo judiamo ijadufuo bu naebe una ve gue kuarae. ");
INSERT INTO bbb_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Ijadufuo fu uri uviarafa fuone kiae, Biona ivuake igia ruafo, Naeje na uvia jone Josofu e ije ja abena e Ijifitiko ijiebuo fuaeveva ije nare. ");
INSERT INTO bbb_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ro igia fie, jade ije ireobo vierafena abe kuaena jone nanamivo. Fune Godire e boeje ifejiana karauniakiro vierafena ude na abena nujiemoga na igia ruae. ");
INSERT INTO bbb_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Vasia ige fume juaevasia inokiro ijiaru aesakae igia kekei. Ro una juaevasia umui fague ijiege fu uriado vasia fu ruake. Ro vasia ije fu kekemo ijia fu erare juare iviaeko imekinu ro masikuma baki. ");
INSERT INTO bbb_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Ijadufuo fune Godire joefuo ude na abe nujiemo na igia ruaevado nare agane jone ifejiaga bu giriesa karivadufuo. Ro fu magoe abe nujiemo na igia ruaevado na vame ijieki ja naebe ma vierafeva ijia ja ro uifari jone ije karauniaga buka e uruvana reke. ");
INSERT INTO bbb_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Ijadufuo jaeje ja baki ro fune Godire na abe nujiemo na igia ruae. Fune Godire na abena kini Fero e igeko ijadufuo e ka ma ireobo be rei. Ijadufuo nare e Ijifitiko boeje ige ro aesakae ige foteke ijene samuagiave. ");
INSERT INTO bbb_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ijadufuo ni migegireigia una va asoe none kua, Fari one Josofu fu kume Godire na kiega na iviama e ireobo rena e Ijifitiko ije samuagiavono kuafo. Ro fube saroekiro nika migegireigia ige na fivo igia rono kuafo. ");
INSERT INTO bbb_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ro a ruakuma ni anafa one ijiakina asaerafa one ro mave-ro goti ro mave-kau ro ire jone boeje ja samuagiavo ije kaenamiana na fivo ivuake ijia are Gosonino kuavo ijia fine. ");
INSERT INTO bbb_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ro a aesakae Goseni abena ijia fike ro juaevasia umui fague guove ijia vasia kekemo ije nare a samuake. Ro a naebe ruakuma ije a agane one ijiakina fanuve one ije jaka vasia kaniaga ja isejavaena oekono kuafo. ");
INSERT INTO bbb_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Ro igia fie, iviama uviarafa none boeje gure ireva ro Bezimani a dua jane igifure samadukua gie. Ijadufuo jane ma vierafega nane ma ivie jone Josofu nare kuariave. ");
INSERT INTO bbb_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ijadufuo ni va asoe none ijene daro ireobo ige na abena igia Ijifiti fivo ijiakina ire boeje ja giaeva ijene kuarafo. Ja ijiege kuara areme nine migegire mesirina una igia ruano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Josofu fu vua ijiege kuariama furi areme uri uvia fuone Bezimani farena dabe uimina uri bue niraefiranami. ");
INSERT INTO bbb_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ijiege rena Josofu fune nimekinu uri uviarafa fuone boeje faradiana uimidiae. A areme fune va uviarafa fuone ijene besu fina vua kuae. ");
INSERT INTO bbb_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Bu ijiege rekoga e bune vua ije fiena dabe usiae kinido are fu fino ijia kuaena kuae Josofudo uviarafa ije bune ruaevano kuaevoga kini ro e mamekanu fuone bu vua ije fiena buka oemarei. ");
INSERT INTO bbb_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","18","Areme kini fune urina Josofu kuae, Uviarafa one kiaga bu mave-doniki buone kena una va gamia Kenani usiaena asoe buone ijiakina agane buone kaenamiana una igia ruafo. Bu roga nare Ijifiti guove igia are ma be ije miaga bu ijia karina ire boeje bu ijia tavuavo ijene karina oemarekinu inoeke. ");
INSERT INTO bbb_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Ro kuke ni uviarafa one kiaga bu fata ije bu ekiro sinuome ije kari ijia nana maniaerunanoevo gue kena vaekina bu ijia anafa ro bararafa buone ijia ijene ijia kaemaniana una Ijifiti rone. Ro kiaga buka bu asoe buone mesirina rone. ");
INSERT INTO bbb_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Ro bude ire buone boeje bu ijia naovo ije bu arena ruovo ije ireobo vierafevo. Ijadufuo maeje are Ijifiti guove igia ire maeje boeje naovo ije funeka buonedo bu kekono kiane. ");
INSERT INTO bbb_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","E Ijifitiko ijiebuo kini ije fu ijiege kuariamoga Jekafudo anafa ije bune urina ije fu kuariaema ijiege rei. Areme rena Josofu fune urina fata ije e bu kariko bu maniaerunoevo ije karina vajia areme uri ire bu ikinu una vadufuo ijene. ");
INSERT INTO bbb_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Areme Josofu fune urina ugone bu savo iviaeko bino karina uviarafa fuone ije besubesu vajiae. Ro iviene fuone Bezimani ije fu uri ugone bu savo iviaeko umui fague ro ire siriva tiri aderedi (300) ijiege kena vajae. ");
INSERT INTO bbb_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Areme fune urina ire ma ije Ijifiti ijia naovo ijene karina asoefuo naejama arevoga doniki teni (10) bu ije kari. Areme Josofu fune kuke kumunekina burete ro ire gue bu ikinu una Kenani vadufuo ijene karina nama arevo doniki teni bu ije kari. ");
INSERT INTO bbb_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Areme Josofu fune urina kiae, Ja una are vako vame ijia jade na ja abe e igiebuo fuaeveva ijadufuo una jone umui bijanamina madinamivo. Ro ja vakuva nime mauike kafaena vano kiamoga bune una vae. ");
INSERT INTO bbb_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","26","Areme Josofudo uviarafa ije bune Ijifiti arena una Kenani asoe buone Jekafu fino ijia vae. Bune va gafia usiaena urina asoe buone kuae, Josofu fu naebe barone ro fu uria fine. Fu aesakae Ijifiti ijia e ireobo rena are ije samuamono kuae. Rove asoe buone fu vua ije fiena fuka turanamina oeserei ijadufuo fu vua buone fu naebe ma vierafei. ");
INSERT INTO bbb_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","28","Rove ame bu urina vua boeje Josofu fu kuariaema ijene asoe buone kuarae. Bu ijiege kuaravoga Jekafu fu ije fie areme uri fata ije bu sinuome karina maniaerunoevo ije Josofuo fu kena vajiamo bu ruaeva ije giae. Areme fu ijia sone oe dasu areme uri kiae, Na iviama ijare ma vierafega fari none Josofu fuka uria fine. Ijadufuo na vierafe naka va fu ga areme rade na sone baronekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Areme Jekafu fune uri anafa fuone kiamoga bu sinuome buone boeje kanafuima areme bune urina Ijifiti vae. Fune vakuma sidove Biasiba ijia kekena uri asoe fuone e Aesekido Godi ije zinone ifaejana fuone baname isoe. ");
INSERT INTO bbb_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Areme muge ijia Jekafu fu nimamaena gake Godi fu kumei, Jekafu, Jekafuono kumenoga fu una gue onukuae. Fu onukuaena kume, Na igieno kumei. ");
INSERT INTO bbb_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Areme Godi fu arina kuae, Naeje na Godi besu ije asoe one fu baname isoemo ijene. Ijadufuo a Ijifiti vakiro jumemo ije arene. Ijadufuo maeje nare e uifari one ije ifejiaga buka e uruvana rega bure aesakae be abena karike. ");
INSERT INTO bbb_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ro a Ijifiti vakuma na osiki vake ro rade nare a mesira una igia ruake. Ro maza ije a baronemo ije fari one Josofu fu uria a ivuake ijia fina gake a baronekono kumei. ");
INSERT INTO bbb_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","7","Areme Jekafu fune agane fuone ijena urina are Biasiba arena bune Ijifiti vae. Ijiege rena farirafa ije bune urina Jekafukina bararafa ijiakina anafa buone isesina ije kaenamiana fata ije bu sinuome nana maniaerunoevo ije kini fu abe Jekafudo nijaema ijia uniae. Jekafu fune ijiege rena uri uifari fuone boeje funeka merui. Jekafu fu urina farirafa ro kabaerafa fuone ijiakina asaerafa kabae ro fari ije boeje fuka kaenamiae. Areme fune uri fanu fuone boeje binobino fu saema ijiakina sinuome fuone boeje fu Kenani ijia fikinu kema ije funeka karima areme bune Ijifiti vae. ");
INSERT INTO bbb_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","10","Ro Jekafudo anafa ije bu urina fuina aesakae Ijifiti vaeva ije ijiege. E Rubini fari fuone boga ije urina fu farirafa fuone e Anokikina Farukina Esironi ro e Kami ijene kaenamiae. Ro fari fuone e Simioni fu urina anafa fuone e Jemuerokina Jaminikina Oadikina Jakinikina e Zoare ro e Soro ije kaenamiana vae. Ro e Sorodo asie ije fu bara Kenanaetiko. ");
INSERT INTO bbb_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","12","Ro Jekafudo bara Riado fari e Rivae fu urina anafa fuone e Gesonikina Koatikina e Merari fu ijene kaenamiana vae. Ro e Juda fu uri farirafa fuone e Sirakina Ferezikina Zera ijene kaenamiae. Ro Judado anafa inokiro e Ekiro Onani ije bune ae sakae Kenani ijia oe. Ro fari fuone e Ferezi ije fu urina anafa fuone e Ezironikiro Amuri ijene kaenamiana vae. ");
INSERT INTO bbb_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","15","Ro bara Riado fari e Isaka fu uri anafa fuone e Torakina Fuvakina Jasubikina e Simironi ije kaenamiae. Ro e Zeburuni fu uri anafa fuone e Seredikina Eronikina e Jariro fu ijene kaenamia vae. Ro Jekafukiro bara fuone Ria ijiebuo anafa ijiakiro kabae buone Daena ro asaerafa ije bu are Padame Arame guove ijia nafeva ije boeje foteke buka e teti tiri (33) ijiege. ");
INSERT INTO bbb_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","18","Ro bu ame ijiaru bakiro Jekafu fu kuke anafa fuone bino duaku nafei. (Ro ame ije fu bara Zirufa fu bara ije e Rebani uria ijia mesirina kabae fuone Ria nujaejaema fu fuefuo imeno ijare nafena Jekafu vajae ijene). Ijadufuo Jekafukiro bara Zirufa ijiebuo fari e Gadi anafa fuone fu kaenamia vaema ijeja e Zefonikina Agikina Suni ro Ezibonikina e Eri ro Arodi ro Areri ijene. Ro fari buone be e Asa fu uri anafa fuone e Iminakina Isivakina Beraeakina kabae fuone Sera ijene kaenamiana vae. Ro e Beraea fudua fu anafa fuone inokiro e Ebakiro Marakiero ijene kaenamiana vae. Ro ame boeje Zirufa fu nafena Jekafu fu vajaema ije boeje buka sikisitini (16) ijiege. ");
INSERT INTO bbb_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","22","Ro una Jekafudo bara Resero ije fudua fu ame fotini (14) ijiege nafenoga bu uri ame buone bino duaku tuanae. Ro fari buone e Josofu ije fu va Ijifiti ijia fina areme uri bara Asenati e Fotiferado kabae ije abei. Ro e Fotifera fu e Oni ijiebuo e zinone ifaejemo be. Ro Josofukiro bara Asenati bu ame inokiro e Manasakiro Ifuremi ije nafei. Ro e Bezimani fu urina anafa fuone e Berakina Bekakina Asiberokina Gerakina Nemanikina Eikina Resikina Mufimikina Umifikina e Adi ijene nafei. ");
INSERT INTO bbb_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","25","Ro Jekafu fu kuke anafa fuone bino duaku nafei. Ijadufuo maeje bara fuone Resoro fu bara Bira bara ije fuefuo imeno ijene Jekafu kuamo fu abena ame bino nafei. Ro kuke Jekafudo bara Bira fu fuefuo imeno ije e Rebani fu abe kabae fuone Resero maema ije fu ame seveni (7) ijiege nafei. Ijadufuo anafa buone inokiro e Denikiro Natari ije buduaku anafa bino nafei. Ro e Denido fari ijeja e Usimi. Ro e Natarido farirafa ijeja e Jazierikina Gunikina Jezakina Sireme ijene. ");
INSERT INTO bbb_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","27","Ro Jekafudo agane boeje foteke bu fuina uri Ijifiti vaeva ije bu e sigisiti sigisi (66) ijiege. Ro farirafa ijiebuo bara ije bu naebe dae. Ro Josofukiro bara fuone Asenatikiro anafa buone inokiro ije bu Ijifiti ijia kariva ijiebe una agane ijena besu mazieva ije foteke buka e seveniti (70) ijiege. ");
INSERT INTO bbb_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","29","Ijiege rena bune vame ijia vako ijia Jekafu fune urina fari fuone Juda kuae, Ni are ude va gamia Ijifiti kekena Josofu kuaga fu ro gumia Gosoni bieduono kuamoga fune vae. Juda fune va gamia kekena Josofu kuamoga fune urina fata fuone bu ose ijia kiriaga bu maniarunoevo ijia ajiana fune gafia are Gosoni asoe fuone biekiro vae. Fune vakuma vame gafia asoe fuone biena uri fuosiki uro urasena maza jiagado bue niraefiranami. ");
INSERT INTO bbb_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Areme Jekafu fune uri Josofu kuae, Na vierafero ane baronemaro na ijiege vierafe. Rove a igifureki uria fine. Ijadufuo na vierafe nane oemarekinu barone vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Jekafu fu ijiege kuaramoga Josofu fu sone ijia urina uviarafa fuone ro e boeje vaeva ije kiae, Na vierafe naka una va kini Fero kuako jane Kenani arena ruaeva iviama jane igia usiaevano kuake. ");
INSERT INTO bbb_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Ro kuke jaeje ja e mave samuagiavo ijadufuo ja mave-ro goti ro mave-kau ro ire jone boeje ja samuagiavo ije jane ijiakuma ruaevano kuake. ");
INSERT INTO bbb_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","34","Ro ja vuaga kini fu kiako ja are jone ijia ja karinoevo ije ja irere ijene renoevono kiakuva ni kuako, Noeje no e mave-samuagiavono kuafo. Ro kuke no izege asaerafa nuvuone bu mave-samuagiavo ijiege nodua no uria mave samuagiavono kuafo. Ja ijiege kuarakuva fu kiaga ja aesakae Gosoni abena karike. Josofu fu vierafe uviarafa fuone buka ijiege kini Fero kuarake. Ijadufuo maeje e Ijifitiko ije bu e mave-samuagiavo ije ivuake ijia karinoevo baki ijadufuo fu ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Ijiege rena Josofuo fune uviarafa fuone umui fague (5) kaenamiana va kini ije gana kuae, E uviarafa none ro asoe none bune iviama Kenani arena urina ruae. Ro buka mave-ro goti ro mave-kau ro sinuome buone boeje bu foteke samuagiavo ije bune kaenamiana igia Gosoni karikuae ruaevano kuae. Areme Josofu fune urina uviarafa fuone ije kaenamiana funekini fino ijia vae. ");
INSERT INTO bbb_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Bu va ijia usiaevoga kini fune urina kiae, Ja i jone ja mevo ije ja i irere ije menoevono kiae? Ro Josofuodo uviarafa ije bu urina kuae E ireobo, no asaerafa nuvuone ije bu e mave-samuagiavo. Ijadufuo nodua none maza boeje mave-samuagavono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bu ijiege kuara areme kuae, No aesakae nuvuone Kenani ije fuka vasia ireobo kekema ijadufuo garasi boeje mave nuvuone bu inoedufuo ije fune saere furima ijadufuo no ije urina igia ruae. Ijadufuo a isekie ni kuoga no aesakae Gosoni ije abena ijia karino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Areme kini ije fune urina Josofu kuae, Asoe one ro uviarafa one bu ruaeva ije fune ka marei. ");
INSERT INTO bbb_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ijadufuo aesakae Ijifiti fu ijifureki ijadufuo ni asoe one ro uviarafa one ije kiaga bu va are ijia karine. Na vierafe are Gosoni fuka sakae mukore ijadufuo bu ijia karidufuo. Ro a vierafega e one gue bu mave-sifi mukoe samuagiavoga ni kiaga bu mave ro goti none ijene samuagiajieno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Areme Josofuo fune asoe fuone Jekafu mesirina ro kini ije nijaemoga Jekafu fu urina kini ije daro mae. ");
INSERT INTO bbb_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","9","Fu daro mamoga kini fu urina Jekafu juaevasia fu izege fina ruaema ijadufuo kuae. Fu ijiege kuamoga Jekafu fu urina kuae, Na juaevasia none na ae binobino ijia fijana ruaeva ije na juaevasia uvani aderedi teti (130) ijiege. Na juaevasia none buka sibaneke rove naka irufui ma uruvana biediae. Rove orafa none ijiakiro asaerafa none bu kari ruaeva ije buka juaevasia ma uruvana kari ruae rove bume irufui sibaneke biediaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jekafu fu ijiege kuara areme fune una kuke urina kini ije daro mana fune keke vae. ");
INSERT INTO bbb_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Areme Josofu fune urina kini vua izege fu kuaraema ijiege rena uri asoe fuone ro uviarafa fuone ije kaenamia Ijifiti guove ijia aesakae ka mukore be are Ramasesi ivuake ijia kiamoga bu va aesakae ije abena ijia kari. ");
INSERT INTO bbb_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Bu ijia karinoekoga Josofu fu urina asoe fuone ijiakina uviarafa ijiakina e boeje eranabe asoe fuone ijadufuo are ijia kariva ijene ifejiana ire vajiakinu mukoreigia samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Ro are Ijifiti ro Kenane guove ijia fuka vasia ma ireobo kekemoga e boeje buka vasia ireobo abena isejavae. ");
INSERT INTO bbb_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Ijadufuo Josofu fu urina kumune fu tuana mutuna uijaka ijia naema ije karina e Ijifitiko ijiakiro e Kenaniko ijiebuo fuaeveko bu moni vajavoga fu karina kinido are ijia nae. ");
INSERT INTO bbb_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Ijiege rekoga E Ijifitiko ije bune manido ire fuaekinu vakuma moni ije funeke furinoga bu una usiaena Josofu kuae, No moni nuvuone funeka furi. Ijadufuo kumune bino nime vajuone ro a bakuma noneka vasia abena oekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Ro Josofu fu urina kiae, Ja moni bakikuva ni fanuve jone ja samuagiavo ijia bino kena ro vajiega na kumune vajiano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Fu ijiege kuariamoga bune va fanuve osekina doniki ro mave-ro goti ije kaemaniana una ro Josofu vajavoga fu ve una kumune karina vajiae. Ijiege rena Josofu fu juaevasia besu guove ijia ijiege rekinu fanu ni binobino ije funeka karima furi. ");
INSERT INTO bbb_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Areme juaevasia be ijia e Ijifitiko ije bu una ro Josofu fino ijia usiaena kuae, E ireobo noka a biesirakuva baki ro vua ige noneka ma kuarave. No iviama moni nuvuone ijiakiro fanu no samuagiavo boeje bune furi ro una ire bino fuka ma baki. Ro iviama no fune no ro sakae nuvuone ijiaru uria naove. ");
INSERT INTO bbb_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Ijadufuo ade arega no vasia abena oekega aesakae nuvuone ige fuka ma iseremo. Ro anika kumune bino vajuoga no ikinu ro uije bino vajuoga no one. A ijiege rekina no aesakae nuvuone ige abe una kini ma areme nodua no uri fuefuo moni baki imeno kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","22","Areme vasia ije funeka Ijifiti guove ijia ma ireobo kekemoga e Ijifitiko boeje bu uri Josofu soesoe. Bu kuavoga fu urina aesakae buone boeje fuaevena ke una kini vajae areme fu kiamoga e ije bune kini ijadufuo moni baki imei. Ro e ije Godido zinone ifaejevo ijiaru bu sakae buone bu naebe kena fuaeve. Ijadufuo maeje buje bu kini ijare moni bu ire idufuo ije vajiamo. ");
INSERT INTO bbb_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","24","Areme Josofu fu urina e boeje kuariana kiae, Iviama aesakae jone igiakiro jaeje nane fuaevana kena una kini vajavo fune fue kei. Ro jaeje na uije vajiaga ja jone oke rove ja oenoeno masikuva ire gue janika kena ro kini ije vajafo. Ro ire gue ije ni karina uifuo nakiro gue ije ni karina agane jone ijena ino kiae. ");
INSERT INTO bbb_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Rove e ije bu urina kuae, E ireobo aneka marena no ifejuona karaunuemado noneka oemarekinu kini ijadufuo moni baki imekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Bu ijiege kuaravoga Josofu fu uri akae be nijana kiae, Ja kumune korema areme masina kamui faeve (5) ijiege kekuva, ni kamui besu ije abena kini ije makiro fo (4) ije ni jone keno kiae. Bu ijiege rekogaro e ije Godido zinone ifaejevo ije buosukua sakae buone bu naebe kena fuaeve ro bu uria korubuo samuagiae. ");
INSERT INTO bbb_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Ijiege rena e Isureroko ije bu are Gosoni Ijifiti guove ijia kariva ijia buka sinuome uruvana zaraekoga e uine buka ma e uruvana rei. ");
INSERT INTO bbb_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Ro Jekafu are Ijifiti fu fima ije fu juaevasia sevenitini (17) ijiege. Ro juaevasia fuone foteke fu fina ruoma e orema ije fu uvani aderedi foti seveni (147) ijiege. ");
INSERT INTO bbb_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Areme Jekafu fu vierafe fune iviama igiebo baronekiro fu Josofu kumeno fu aru vae. Josofu fu aru vakoga fu urina kuae, A iviama oge none igia faradiena E Ireobo Godido ive ijia kurana kuariega na fiene. Anika kieko a naeje abe abena igia Ijifiti mako rukono kiega na fiene. ");
INSERT INTO bbb_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Na baronekuva ade na abena Ijifiti igia mako rumo. Ro naeje nika mesiriena una va aesakae Kenani asaerafa none bu uniaeva ijia nujieno kuae. Fu ijiege kuaramoga Josofu fu una gue kuae, Vua irere a kuariemo ije na vierafe na ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Areme Jekafu fu una kuae, Anika E Ireobo ive ijia kurana kieko a ijiege rekono kiega na fieno kuae. Ijadufuo Josofu fune uri asoe fuone ijadufuo nidua ijia Godido ive ijia kurana kuae, Na ijiege rekono kuae. Areme Jekafu fu ijia tuana vakuma are fu naeno nigedo ijia dijena E Ireobo baname isoena oemarei. ");
INSERT INTO bbb_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ijiege reme maza sibaneke furikoga Josofu fu fieke asoe fuone Jekafu fu adame abema fu fie. Ijadufuo fune uri ame fuone inokiro Manasakiro Ifuremi ije kaenamiana Jekafu gakiro vae. ");
INSERT INTO bbb_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Josofu fu vakuma gafia kekemoga ebe gana una va Jekafu kuae, Fari one Josofu fu a gakiro ruomono kuae. Bu ijiege kuaramoga Jekafu fu vua ije fiekoga vajae fuone ije fu ijia una naekinemoga fu daro abei. Ijadufuo fune ije fu namo ije fu arena una uri arire fi. ");
INSERT INTO bbb_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Areme Josofu fune vakuma ijia kekemoga Jekafu fu urina kuae, Maza ije na are Ruzi Kenani guove ijia finoevo ijia Godi ije ka ma daroki ijare ijia ro na biediena daro mie. ");
INSERT INTO bbb_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","Fu daro miena vua be ijiege kuarie. Fu kie, Nare rade anafa one ma uruvana vajaga bure urina anafa ma uruvana tuanaga buka e uruvana reke. Uifari one buka e uruvana rena bure uri aesakae binobino kena karikono kie. Ro kuke fu kie nare aesakae ige abe miaga bu buone abena ijia kari vakono kie. ");
INSERT INTO bbb_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Ro ame fari one inokiro ije a Ijifiti ijia nafekoga na rade ruaeva ije bu ame none. Na izege na anafa none inokiro e Rubinikiro Simioni na keva ijiege ame one inokiro ije na none keke. ");
INSERT INTO bbb_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ro ame bino a rade tuanamo ije naeje na baki ro bune ame one reke. Ro rade ame one gue bu sinuome one gue kekuae vierafekuva bu una va e Ifuremekiro Manasa ijiebuo ijia kedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Na ijiege kuaevo ijadufuo maeje no aesakae Mesofotemia ijia arena una are Efurati Kenani guove ivuake ijia ruovo ijia asie one Resero fu barone ijadufuo fu naebe una ame bino tuanae. Fu baronemoga naka fuefuo ma ireobo oefiane abei. Areme surive fuone na abena vame ije bu Efurati vako irifo ijia mako ruvano kuae. (Ro are Efurati ije iviama bu kua Beturiemeno kuavo). ");
INSERT INTO bbb_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","10","Ro Jekafu funeka ma e orena ni fuone fune titute ijadufuo fu ame fari inokiro ije fu naebe mukoe giana vierafei. Ijadufuo fu urina Josofu kuae, Ame gure eranebe karivano kuae? Fu ijiege kuamoga Josofu fu kuae, Ame fari inokiro ije bu none fu Godire Ijifiti ijia vajiema ijeno kuae. Fu ijiege kuaramoga Jekafu fu kuae, Ni kaenamia ivuake ige na fivo igia roga na giane. Na vierafe naka daro none bu vajiakiro vierafevano kuae. Ijadufuo Josofu fune uri farirafa fuone inokiro ije kaenamia ivuake ijia vakoga Jekafu fu uri uro urasiana kame uimidiae. ");
INSERT INTO bbb_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Areme fu una dakudena Josofu kuae, Na aeje naka naebe gako funejuaevasia ma uruvana furi. Ijadufuo na vierafero ane baronedo nabe una a gakiro na ijiege vierafei. Rove Godi fuka na ifejieko na fina ruoma areme ivia nane anafa one inokiro ije giaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Areme Josofu fune anafa fuone inokiro ije kiamo bune Jekafudo oge ado bu kariva ije bu una ari. Bu arikoga fu uri Jekafu nidua ijia auge sana kurituakafano tuana vakuma uimutumutu sakae ijia dije. ");
INSERT INTO bbb_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Fu ijiege re areme uri ame amure e Manasa fu kuamo fu Jekafudo umui maeneke ijia manikoga ame iviene e Ifuremi fu kuamo fu umui aeneke ijie mani. ");
INSERT INTO bbb_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Rove Jekafu fune urina umui fuone maeneke ije fu abe una dakude ame iviene e Ifuremido nigofo ijia nijagaro aeneke ije fu abe una Manasa ame boga ijadufuo nigofo ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Areme fune uri daro fuone Josofu mana kuae, Na Godi ije vierafe asaerafa none e Eburamekiro Aeseki ijiebuo Godi ije bu baname isoekinu fuefuo imeva ije fu daro miena ifejieko na fi ruovo ijare ame ige daro miake. ");
INSERT INTO bbb_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ro kuke anera fuone ije bu na mukoreigia samuagieko na finoevo ijare bu marejiake. Na vierafe fure ame ige daro miaga bure maza boeje Eburamekiro Aeseki ro na ive nuvuone abe fare karivake. Bure izege no Godi irinakinu ma vierafevo ijiege budua Godi ma vierafekinu kari vake. Ro kuke Godi fu ifejiaga anafa buone ro asaerafa buone buka ma uruvana rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Areme Josofu fu gake Jekafu fu umui fuone maeneke ije fu abena Ifuremido nigofo ijia nijamo fuka naebe oemarei. Ijadufuo fu urina asoe fuone ijadufuo umui maeneke ije abe biona una Manasado nigofo ijia nijakiro rei. ");
INSERT INTO bbb_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Fu ijiege remoga Josofu fu kuae, Ate ije a isema reme. Ame boga ije fu igieno umui one maeneke ije abena nigofo fuone ijia nijano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Rove asoe fuone fu kuae, Farino na irere na revo ije nane vierafena reve. Na vierafe Manasado asaerafa buka ma uruvana reke. Rove Ifuremi iviene fuone ijadufuo asaerafa ijiebe fu asina ma e uruvana reke. Bu e uruvana rena bure ka ma e uruvana aesakae mamekanu gue kega karike. ");
INSERT INTO bbb_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Ijadufuo Jekafu ve ijia ame inokiro ije daro ige miae. Fu daro miana kiae, Maza rade e Isureroko bu bue daro manamikuva bu ive jone ijia kuriakinu reke. Bu kuae, No vierafe Godire izege fu e Ifuremikiro Manasa daro miakinu marejiaema ijiege fu kuke jadua daro miakinu ma rejiakono kuaeke. ");
INSERT INTO bbb_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Areme Jekafu fu Josofuo kuae, Naeje na baronekuvejo igia giene. Ro na vierafe Godire maza boeje osiki fi vake. Ro fure rade a samuagana mesirana asaerafa one ijiebuo aesakae ijia vake. ");
INSERT INTO bbb_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ijadufuo na e Amoraetiko ijiebuo aesakae Sekami na juvua magu none ijia kena iraraena kania kuriana abe a makiro uviarafa one ije bu bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","2","Areme Jekafu fune urina anafa fuone boeje kumeno bu besu afuivoga fu vua kuariae. Fu kiae, Anafano, naeje na Jekafu ro kuke e Isurero asoe jone ijene. Ijadufuo ni ro ige na fivo igia karike na irere fu rade jone ruadufuo ijene kuariafo. ");
INSERT INTO bbb_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Ro Rubini aeje a fari none amure ijene ijadufuo are daro none amure ije a abeke. Aeje aka ma e daroki ro are anafa none guriebuo uve ijia aeje aka ma aroekaranoeno. ");
INSERT INTO bbb_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Aeje aka e be naebe mukoe vierafekinu renoeno ro aka e be zabaenoeno. Ro a bara ije fu noefuo imeno ije mesirina fata none na naejo ijia nae ijadufuo a naebe na aguarie. A ijiege rema ijadufuo rade aeje abe e anuigi be rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Areme Jekafu fu uri e Simionikiro Rivae ije buesina kuae, Buje buka ino uviaki. Bu buosiki buka sinuome bu kena bijaenoevo ije kena ura zienoekinu e ije bume ijiebure kanianoeke. ");
INSERT INTO bbb_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Ijadufuo nabe vua buone bu mauike kuae fienamikinu renoevo ijia buina ijiege renoeke. Ro bu isema vierafena mave-kau ije bu ire ise bino revo baki ije bume kame arafiriana vajae fiane vajiavo. ");
INSERT INTO bbb_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Buka ma urukeigia ziena mujuebe defarure abenoekinu e gue vame ise ijia kanianoeve. Ijadufuo na bu kame isekafiakinu ro uifari buone naka kame giegisa uniaga bu urina e agane Isureroko ijena biedarena karinoekono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Areme Jekafu fune una Juda kuae, Aka e ani one kaniakinu are buone iraraega uviarafa one ije buka a dabe arorana kurituakafake. ");
INSERT INTO bbb_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ro kuke aeje aka fanu raejoni ige fu kuriaerena efunena e sakia buvua ino ijiege reke. A ijiege remo ijadufuo e buka a jumedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Juda fuka kini rena ire boege samuagiake ro rade uifari fuone budua bu maza boeje e gue samuagia vaga e anuigi be fu ruake. Bu ijiege rena e boeje aesakae binobino ijia karivo ije bu una e anuigi ije irinana ire ni mukore ije karina ro fu vajake. ");
INSERT INTO bbb_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Ro mave doniki fuone fu abena vaeni mukore ije baema zinume ijia kirake. Ro sinuome fuone ije fu karina va do vaeni ijia soke. ");
INSERT INTO bbb_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ro kuke ni fuone fuka abaeki ijadufuo maeje fu maza boeje ire vaeni ino. Ro fuka maza boeje muje uruvana ino ijadufuo ubae fuone buka abaekirake. ");
INSERT INTO bbb_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Ro Zeburuni fuje fu davare irifo ijia finoeke. Fu ijia fino ijadufuo sisime bu oemarekinu ro ijia ajiadufuo. Ro ae sakae fuone fu fino ubine fu vakuma Saedoni ijia irike. ");
INSERT INTO bbb_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Ro Isaka fuje fuka mave doniki igege mauike naemena ijia finoeke. ");
INSERT INTO bbb_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ro sakae fu fino ije fu ga fuka ma mukore. Ijadufuo fuka maza boeje oemarekinu e gue ifejiakiro fuka i gikikimana menoeke. ");
INSERT INTO bbb_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Ro e Deni fure fu e fuone ijene samuagiaga bu una besu e Isureroko ijena karinoeke. ");
INSERT INTO bbb_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Fu tabare igege ose ijiebuo dia tare ijia sakiaga e ije bu ose kena oenoevo ije bu ari kaniake. ");
INSERT INTO bbb_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Jekafu fu ijiege kuariama areme urina Godi kuae, E Ireobo naeje name a samuagana figa are no karaunuoga na gakono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Areme Jekafu fu urina Gedi fari fuone be ijadufuo kuae, Fuje bu e iniemejo ijiebe kanana bu subine vakuva fuka ve nuvediana buina bijaeke. ");
INSERT INTO bbb_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Ro Asado sakae ijia fuka ire maeje ijiaru bu ijia tavuadufuo. Ro ire ijiebe bu manido e kini ije buka oemarekinu idufuo. ");
INSERT INTO bbb_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Ro Natari fuje fuka fanuve diano kuavo mave-sifi igeki ijiege difuri oenoedufuo. Ro fure ame ni mukore ije nafedufuo. ");
INSERT INTO bbb_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Fu ijiege kuaria areme urina Josofu kuae, Fuje fuka ine vaeni maeje fu are isove do irifo ijia tavuana ajia vakinu fo mukoreigia kiramo igege reke. ");
INSERT INTO bbb_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Ro e ani fuone buka giriesana a kanakuae juvuave buone karina dabe arafirinoeve. ");
INSERT INTO bbb_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Rove fuone fu manino ije fu Jekafudo Godi ije ka ma daroki ijare ifejiaga fu giriesana manine. Ro Godi e ije fu mave-sifi mukoe samuagiamo ijieki ijare fu mukoreigia samuagame. ");
INSERT INTO bbb_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ro E Ije a ifejadufuo ije fu Godi ije asoe one fu baname isoemo ijare a ifejadufuo. Ro Godi E Ireobo ije fuka ma darokido fure ifejaga ve fu ume igia dakinu ro do kiaga bu sakae ijia ajiave. Ro fure ifejaga fanuve one ro ame one buka ma uruvana reke. ");
INSERT INTO bbb_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ro asoe one ijadufuo daro ije fuka ma ireobo. Ro daro ijare fuka ire maeje nafare ije isuibino ijia ireva ijia naovo ijene asidiave. Ijadufuo na baname isoega daro ije fu Josofu one roga a e ireobo rena are uviarafa one ije asidiake. ");
INSERT INTO bbb_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Ro Bezimani fuje fu siroe kuriae igege rena suoke ro mufuo ije fuka e ani fuone ije sakiana kame buvuasekono kuae. ");
INSERT INTO bbb_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Ro vua mukore ige e Jekafure maza ije fune baronekuveno ijia fu agane fuone tuero (12) ije kuariae. Ro daro ije fu vajiaema ije fune buone izege bu karikuvejo ije giakinu vajiae. ");
INSERT INTO bbb_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","31","Areme Jekafu fu urina kiae, Naeje nane iviamagiebo baronedufuo. Ijadufuo na baronekuva surive none ije nika abe una va gamia Makefera munie ijia nujiefo. Ro munie ije fu Eburamere e Efironi e Itaetiko ijadufuo ijene fuaeve. Ijadufuo bu e oevo ije bu ke va ijia uniavo. Ro munie ije fu Mamure are maza ajiamo nake ijia ro fu aesakae Kenani guove ijia. Munie ije bu Eburamekina Sera ro Aesekikiro Rebeka ijiebuo surive ije kena ijia uniae. Ro kuke Ria fu baronema ije na abena mako ijia nujae. ");
INSERT INTO bbb_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Ro aesakae ijia namo ijiakiro munie tire ije fu e Itaetiko ijiebuo e Eburame fu ijene fuaevemano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Jekafu fu vua boeje anafa fuone ijene kuariama furimoga fu una fata fuone ijia na areme fune ijia baronei. ");
INSERT INTO bbb_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Ijiege rena Jekafu fune baronemoga Josofu fuka tuana asoe fuone ado ijia dijena dabe uimikinu nimefiri. ");
INSERT INTO bbb_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Areme fune kiamoga bu uri e ije bu e oega bu muramura kena vajae buone aziriaga bu naebe buraevo ije kiavoga bu muramura abena Jekafudo vajae surive ijene azirae. Bu ijiege muramura ije abena Jekafudo surive ijene maza besubesu azirakinu nujana kari vakuma mazani foti (40) ijiege furi. Rove e Ijifitiko ijiebe Jekafu fu baronemoga bu dabe mazani seveniti (70) ijiege nuja karikinu fuefuo sisimei. ");
INSERT INTO bbb_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Bu ijiege fuefuo sisimena furinoga Josofu fu urina e Ijifitiko ijiebuo e mamekanu ije kiae, Ja na oemarejiekuva nine jasekie va noefuo vua ige kini Fero kuarafo. ");
INSERT INTO bbb_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Ni va kua, Asoe none fu iko baronekiro kie, Na baronekuva vajae surive none ije nika abena una gamia Kenani vano kiae. A abe va munie tire ijia unieno kiemoga nane fuosiki ijiege kuaena marei. Ijadufuo a isekie ni kiega na asoe none abe va Kenani ijia nujana una rono kuano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Josofu fu ijiege kuariamoga bune va Fero kuaravoga fu urina kiae, Nine una va Josofu kua, Ije fune maremano nine asoe one ijadufuo surive abena va a kuariema ijiege Kenani ijia nujana ni una rono kuano kiae. ");
INSERT INTO bbb_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Ijadufuo Josofu fune asoe fuone abe Kenani ijia nujakiro fune vae. Josofu fu vakoga kini Ferodo e fuone mamekanu fu ifejavo ro e mamekanu gue aesakae ije samuavo ije bune fuina vae. Ro kuke Josofudo e ijiakina uviarafa ijiakina agane buone boeje buka urina fuina vae. Ro kuke e bijaevo gue bu sarioti kekoga gue bu osi kena fuina vae. Ijiege rena e Isureroko ma uruvana bune vagana sinuome buone ijiakina anafa buone ro mave-kau ro ro goti ije bu ijia arena vae. ");
INSERT INTO bbb_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Bune vakuma do Jodeni tuana gara are bu ire vuiti mutuvo bu kua Atadino kuavo ijia usiaena ireobo oefiane abei. Bu ijiege rekoga Josofu fudua oefiane abena sisimeko vakuma mazani seven (7) ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Areme e Kenanaetiko bu ije giana urina kuae, E Ijifitiko ije buka ma ireobo oefiane abevono kuae. Ijadufuo bu urina are ije abe ive ina kuae, Abero Misiremino kuae. ");
INSERT INTO bbb_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Ijadufuo e Jekafudo anafa ije bune uri izege asoe buone fu kuariaema ijiege rei. Bune urina Jekafudo surive ije abena va Kenani munie tire bu kua Mekeferano kuavo ijia nujae. Ro are ije bu e oega bu kena va ijia uniavo ije fu e Efironi e Itaetiko ijadufuo rove fu Eburamere fuaevei. ");
INSERT INTO bbb_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Bu Jekafu abe mako ru areme rade Josofu fune uviarafa fuone ro e boeje ijena una Ijifiti vae. ");
INSERT INTO bbb_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ijiege rena Jekafu fune baronemoga Josofudo uviarafa ije buneka jumei. Ijadufuo bu urina bue kuae, No ude Josofu noka ire ise ije fuone revado bigake fuse una ve ise bino nuvuone rekuma no izege rekono kuae? ");
INSERT INTO bbb_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","Ijadufuo bu urina vua ige Josofu nijana kumei, Asoe nuvuone fu uria fino ijia fu kuo, Ni va a kuaga a uviarafa one ijiebuo ise ireobo ije bu one reva ije giana areno kue. Ijadufuo a isekie ni e ige no asoe one ijadufuo Godi ijadufuo imevo ije ire ise no ude one reva ije guona areno kuae. Bu vua ijiege Josofu nijavoga fu vua ije fiemo fuka oefiaemo fu uri nimei. ");
INSERT INTO bbb_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Areme Josofudo uviarafa ije bune ro Josofu fino ijia usiaena uri nidua fuone ijia auge sana kuri tuakafae. Areme bu uri kuae, No vierafe noka ivia oefuo moni baki imekuae vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Rove Josofu fu una kiae, Jade na ireobo jumevo. Nana Godi vareki bakido nabe uri ise jone ije gia kame isekafiadufuo. ");
INSERT INTO bbb_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Ja naeje jaka ire ise ijene none rei rove Godire fuone vierafema ijia fu na abena una ire maeje rei. Fu ire ijene rekina fu e boeje eranebe iviama irufui ige abevo ijia ifejiana karauniakiro fu ijadufuo ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ijadufuo naneka ma kuariavono jade jumevo. Na iviama naneka ja ro anafa jone ije samuagiakiro vierafevano kiae. Josofu fu vua ijiege kuariamoga uviarafa fuone bu vua ije fievo buka oemadiana vajae naekinenamiae. ");
INSERT INTO bbb_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Areme Josofu fune uviarafa fuone ijena Ijifiti ijia fina vakuma juaevasia uvani aderedi teni (110) ijiege furiko fu ijia eoremo fu baronei. ");
INSERT INTO bbb_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Fu fina vakuma e Ifuremido anafa ije bune uri ame buone nafekoga. E Manasado fari Makire fu uri ame fuone nafena bu kaenamiana ro Josofu nijaevoga fu oemarekinu giae. ");
INSERT INTO bbb_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Areme Josofu fune urina uviarafa fuone ije kiae, Naeje nane iviama igiebo baroneke. Ro na vierafe rade una gafega karivadufuo ije fu Godire ja samuagiake. Fure samuagiana kaenamiaga ja are ige Ijifiti arena uri aesakae ije fu Eburamekiro Aeseki ro Jekafu fu miako kiaema ijia vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Areme Josofu fu kiamoga e fuone ije bune urina Godido ive ijia kurana vua be fuina kuaena avenami. Fu kiae, Ni iviama kieko ja Godi fu kaenamiaga ja una aesakae fu muoko kuema ijia vakuva jaka surive none ije abe ijia vakono kiega na fieno kiae. ");
INSERT INTO bbb_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Areme fune juaevasi uvani aderedi teni (110) ijiege abenoga fune barone. Fu baronemoga bu uri ire ude mukore urimo ije kena vajae suri fuone ije azima areme abena mavua e oega bu savo ijia abie. ");
INSERT INTO bbb_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Ro maza ije Jekafu fu aesakae Ijifiti ari vaema ije fari fuone Josofu fune ude ijia fikoga fu rade vae. Ijadufuo Jekafu fune uri farirafa fuone gue ireveni (11) ro anafa buone boeje foteke ijene kaenamiana ijia vae. Ro e ije vaeva ijiebuo ive ijeja e Rubinikina Simionikina Rivaekina Judakina Isakakina Zeburunikina Bezimanikina Denikina Nataraekina Gadikina Asa ijene. Ro Jekafudo agane boeje foteke buka e seveniti (70) ijiege. ");
INSERT INTO bbb_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Bu ijia kari vakuma Josofukiro uviarafa fuone ro agane buone boeje buneka ijia oema furi. ");
INSERT INTO bbb_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Bune oe furikoga uifari buone buka uria biona ma e uruvana rena are Ijifiti ije buneka irarae. ");
INSERT INTO bbb_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ijiege rena vakuma juaevasia ma uruvana furikoga e iviaeko be fu urina kini rena e Ijifitiko ije samuagiae. Ro kini ije fu vame izege e Josofu fu ma isuibe e Ijifitiko bu vasia ma ireobo abevoga fu ifejiana karauniaema ije fu naebe mukoe vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Ijadufuo fu urina e fuone kiae, Na iviama fina gavone bune e Isureroko ije bune ma e uruvana rena no bune bure asiduovono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Fu ijiege kuaria areme kiae, E ani nuvuone bu karine noena bijaekuva E Isureroko ige bu nuvuefuo mani baki imevo ije buka buina rena uri no kanuona usiae subinae vake. Ijadufuo roga no vame izege no ije bijukuriadufuo ijene bino kuaena amaerino kiae. ");
INSERT INTO bbb_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Ijadufuo e Ijifitiko ije bune urina e bino kevo bu e Isureroko ije samuagiae. Bu e Ijifitiko ije dasumiana i gikikimana ije buefuo menoe. Bu ijiege rena uri e Isureroko ije kiavoga bu Kini iviaeko ijadufuo are mamekanu inokiro Fitomikiro Ramisi ije fu ire fuone fu zaraema ije nadufuo ije sae. ");
INSERT INTO bbb_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","E Ijifitiko ije bu e Isureroko ije kame vame gikikimana ijia uniavoga bu ijia isejavae. Rove buka uria e uine ma uruvana tuanana vakoga e Ijifitiko ije buka ireobo jumei. ");
INSERT INTO bbb_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","E Ijifitiko ije bu vierafe buka e Isureroko ije kame vame ma gikikimana ijia arafiriakuae bu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Ijadufuo bu uri E Isureroko ije kame vame ise ijia arafiriana kuriaereko buka i gikikimana menoe ijadufuo buka naebe oemare. Bu ijiege rena kiako bu i binobino mena ajare ro mune ije matuna biemarokinu ijia uruke isejavae. ");
INSERT INTO bbb_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Bu ijiege rekoga Kini Fero fu urina bara Iburuko Sifiakiro Fua ije bu bara e fudievo ije ifejiako bu e nafevo ijene vua ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","Fu kiae, Ja bara ije e fudieva ije ja ifejiako bu e nafevo ije giaga bu ame fari nafevoga ije kaniafo. Ro bu ame kabae nafevoga ni are bu ni uria karino kiae. ");
INSERT INTO bbb_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Rove bara ije buka Godi ma vierafevo ijadufuo bu naebe kini Fero fu kuariama ijiege rena ame fari ije kaniae ro bume ijia arei. ");
INSERT INTO bbb_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Ijadufuo kini Fero fu urina bara ije kumeno bu rovo fu kiae, Ja irerefuo ja naebe na kuariaeva ijiege rena ame fari ije kaniae ro ja areko bu ni uria karivano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Rove bara ije bu urina kini Fero kuae, Ame ije no naebe kaniaeva ijadufuo maeje bara Iburuko ije bu bara Ijifitiko bu revo ijiege revo baki. Ro buka giriesana ame buone nafeko no rade va giavono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Ijadufuo maeje Godi fuka bara ije bu bara gue ifejiako bu e nafevo ije marejiae. Ro kuke fu daro miamo budua buka ame buone nafei. Bu ijiege rekoga e Isureroko ije buka e ma uruvana rei. ");
INSERT INTO bbb_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ijadufuo kini Fero fu urina e fuone boeje kuariana kiae, Ni va ame fari katiki boeje ka kamodiana va do Naero ijia korekiro ame kabae ijiaru ni arega bu ni uria kari vano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","2","Ro e Rivaedo agane ijia ebe fu urina una e Rivaedo kabae ije abei. Fu abenoga bara ije fu e fudiena ame fari be bietei. Fu ame ije bietena gake ame ije fuka ame ni mukorega fu abena sauiko asame inokube furi. ");
INSERT INTO bbb_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Fu abena saui fina vakuma asame inokubeke furinoga fu dabe una izege sauidufuo ije fina vierafei. Fu vierafeba dabe kate be bu siduo ijia ufeva ijia sinuo guruema areme kata irifo ije fu ire be kazine ijare dabe irifo ije azinoena arei. Fu ijiege rekina do ije fube guove ijia aru vadufuo. Areme fune ame ije abena ijia kedena abe do irifo bua ije naema ijia nurie. ");
INSERT INTO bbb_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Areme fu kabae fuone kuamo fu va mumabo ijia manina ga arega ame ije fu izege rega fu gakiro fu ije vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ro kini Ferodo kabae ijiakiro bara ije fuefuo imevo ije bu do ruoekuae vaeva bu do Naero irifo ijia oenoeve. Bu ijia oenoevo ijia Ferodo kabae ije fu ame kate ijene gana uri bara be fuone imeno ije kuamo fu va kate ijene abena ruae. ");
INSERT INTO bbb_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Fu abena romoga Ferodo kabae ije fu abena biju ije dauvena gake ame ije bu abe utima kate ijia abieva fu gae. Fu gako ame ije fu ijia nimenoga Ferodo kabae ije fuka oefiaemo fu urina kiae, Ame ige fute bara Iburuko be ijadufuo ameno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Ro ame ijadufuo maki ije fu ijia manido fu urina Ferodo kabae ije kuae. Fube maredo na va bara Iburuko gafe kuaga fu ro ame ige abena oefuo samuakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Fu ijiege kuaramoga Ferodo kabae ije fu kuae, Ni va kua fu rono kumega ame ijadufuo maki ije fune asie fuone mesirikiro vae. ");
INSERT INTO bbb_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Areme ame ijadufuo asie fuone ije fune romoga Ferodo kabae fu uri bara ije kuae, A ni ame ige dabena va noefuo samuake na moni bino vajano kuae. Ijadufuo asie fuone ije fune uri ame ije dabena va are fuone kekena samuae. ");
INSERT INTO bbb_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Fu samuako ame ije fune ubaeremoga fu dabe una ro Ferodo kabae ije mamoga fu abena nifarikena ame fuone ijiege samuae. Areme fu urina kuae, Na ive fuone na Mosisi kuake ijadufuo maeje na do gamia dabe ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Ijiege rena fune abe samuana vakuma Mosisi fune e ireobo remoga maza be fu una e fuone ije izege bu i ka gikikimana ije mevo ijene giakiro vae. Fu va gianoeno ijia fu gake e Ijifitiko be ijare urina e Iburuko e fuone ije be kanamo fu gae. ");
INSERT INTO bbb_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Ijadufuo fu uri guegue rerega e baga fu urina e Ijifitiko ije kanamo fu baronemoga fu dabe ajare ijia ruma nurie. ");
INSERT INTO bbb_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Areme fune va naema nituame fu una vaga e fuone Iburuko inokiro bu bue bijaevo fu giana uri e be ije isema remo ije kuae, A irerefuo uvia one ije kanamono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Fu ijiege kuamoga e ije fu urina kuae, A erare kuaga a e ireobo rena no samuaguokinu ise nuvuone ke mazie guome? Ro a isuome e Ijifitiko ije a kanaema ijare riezaega a kuke nadua kaniekuveno kuae? Areme Mosisi fu urina fue kuae, Ire ige na reva ije bune gievano kuaena fuka jumei. ");
INSERT INTO bbb_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Areme maza ije kini Fero fu vua ije fiena fuka Mosisi kanakiro vierafei. Rove Mosisi fune uri kona va aesakae Midiani ijia kekena va mako be bu do jiavo irifo ijia fine. ");
INSERT INTO bbb_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Ro e Midianiko ijiebuo e zinone ifaejemo be fu ame kabae umuifague ro dikine inokiro (7) ijiege. Ijadufuo bu tinine buone karina do jiana asoe buone ijadufuo mave sifi ije vajiakuae ruae. ");
INSERT INTO bbb_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Rove bune e mave samuagiavo gue ijiebe usiaena bara ijene kuriaerega bu vakuae bu ijierei. Rove Mosisi fu urina bara ije ifejiana e mave-sife samuagiavo gue kuriaeremo bu arekoga fu do jiana bara ijiebuo mave ije vajiae. ");
INSERT INTO bbb_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Areme bara ije bune una asoe buone e Ruero fino ijia rovoga fu kiae, Ja izege reva ijadufuo ivia jaka migegire una ruaevono kiae? ");
INSERT INTO bbb_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Fu ijiege kiamoga bu kuae, E Ijifitiko be ijare ifejuona e mave-sife samuagiavo gue ije kuriaeremo bu vakoga fu do jiana mave-sife nuvuone vajiamoga no ijene migegire una ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Ro asoe buone fu urina kabaerafa ije kiae, Ro e ije fu iziebure ro ja irerefuo babuena ruae. Ni migegire kume fu roga burede bino kena vajaga fu ino kiae. ");
INSERT INTO bbb_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Areme Mosisi fune ro ijia buina finoena areme rade e Ruero fune uri kabae fuone Zifora abena Mosisi mae. ");
INSERT INTO bbb_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ijiege rena fu bara Zifora abenoga fu ame fari be bietei. Areme Mosisi fune urina kuae, Naka e aebeko igege urina aesakae igia ruaevano kuaena uri fari fuone abe ive ina Gesomino kuae. ");
INSERT INTO bbb_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bu ijiege rena ruoma juaevasia uruvana furikoga ijia e Ijifitiko ijiebuo kini ije fune baronei. Fu baronekoga e Isureroko ije bu ijia urina vajae fiane bu abena ruaeva ijadufuo aduinoekinu vijenoe. Bu ijiege renoejoga Godi fu oefiane ijiakiro irufui buone bu abevo ijene fie. ");
INSERT INTO bbb_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","25","Areme Godi fune ijia vua izege fu Eburamekina Aeseki ro Jekafu fu ijiebuo rekiro kuaema ije vierafei. Ijadufuo Godi fu una e Isureroko ijiebuo oefiane ije bu abevo ije ifejiakiro uruvana vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Areme maza be Mosisi fune jure fuone e Jetiro e Midianiko ijiebuo e zinone ifaejemo ijadufuo mave-sife ro goti ije samuagianoene. Fu samuagianoena areme kaenamiana una are sao ijia uruo akae Saenae manino nake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Fu va ijia oenoeno ijia fu tarare ije miane naeno ije gae rove miane ije fu tarare ije naeno baki. Ro Godido anera ije fume miane ije naeno ijia manine. ");
INSERT INTO bbb_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Areme Mosisi fu urina fue kuae, Miane fu nae rove tarare ije fu naeno baki ijadufuo na va ivuake ijia gakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ro E Ireobo Godi fu gake Mosisi fune miane naeno ivuake ijia romoga fu tarare uve ijia urina kume, Mosisi, Mosisino kumei. Ro Mosisi fu una gue kume, Na igiefurekino kumei. ");
INSERT INTO bbb_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Ro Mosisi fu ijiege kumenoga Godi fu kuae, Ade ivuake ijia ruomo ro nime dia surive one azone. Ijadufuo maeje are ije a manino ije aka are akae ijia manine. ");
INSERT INTO bbb_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Naeje na asaerafa one e Eburamekiro Aeseki ro Jekafu ijiebuo Godi ije bu baname isoevo ije nareno kumei. Godi fu ijiege kumenoga Mosisi fu fiena uri nikubae fuone okurae ijadufuo maeje fu Godido nikubae ije gakiro fuka jumei. ");
INSERT INTO bbb_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","8","Fu jumemoga Godi fu urina Mosisi kuae, Na e Ijifitiko ije bu izege e none Isureroko ijene kame vame gikikimana ijia reko bu isejavaevo ije nane gae. Ro kuke nane izege bu e Ijifitiko ijiebuo monibaki imenokinu aduina vijenoevo ije nane fie ro izege bu isejavaevo ije nane ifejiakiro vierafei. Ijadufuo ige na ari ruaeva ije na bu karauniaga bu e Ijifitiko ije arena usiae vakiro ruae. Na karauniaga bu e Kenanaetiko ijiakina e Itaetiko ijiakina e Amonaetiko ijiakina e Ferisaetiko ijiakina e Ivaetiko ijiakina e Jebusaetiko ije bu karinoeva ijiebuo are ije abeke. Ro aesakae ije bu abedufuo ije fuka saruegi ro ka ire boeje zaraemo. ");
INSERT INTO bbb_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Ijadufuo maeje na e none ijiebuo oefiane buone nane fie ro e Ijifitiko ije bu e none kame vame isema revo ije nane giae. ");
INSERT INTO bbb_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Ijadufuo iviama na kuaga a una va kini Fero e ije fu aesakae Ijifiti samuamo ije fino ijia kekena e none ije kaenamiana are ije arena keke vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Rove Mosisi fu una Godi kuae, Naeje nana e anuigi baki ijadufuo na izege va kini Fero kuarana e Isureroko ije kaenamiana are Ijifiti arena ruakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Ro Godi fu una Mosisi kuae, A kaenamiana keke ruakuma naeje na osiki oenoeke. Ijadufuo a e ije kaenamiana are Ijifiti arena una uruo ige na a biedaeva igia none baname isoemo ijia a gana vierafero Godi nare a kuavo a vaemaro a ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Rove Mosisi fu una gue kuae, Ro na va e Isureroko ije kiako na asaerafa jone ijiebuo Godi ijare na kiega na ja kaenamia keke vakiro ruaevano kiake. Ro bu una kieko, Ro ive fuone ije erano kiekuva na una izege kuariakono kuae? ");
INSERT INTO bbb_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Mosisi fu ijiege kuaramoga Godi fu una Mosisi kuae, A vaga bu ijiege kuakuva ni kia, Naeje na e ije fu maza boeje ijia fino ijeno kiane. Ro ni kia, E ije fu maza boeje ijia fino ijare kiega na jone ruaevano kiane. ");
INSERT INTO bbb_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Ro nine e Isureroko ije kia, Na E Ireobo asaerafa jone Eburamekina Aesekikina Jekafubuo Godi ijare na kiega na jone ruaevano kiane. Ro ive ije na kuaeva ije fu ive none ijene ijadufuo rade uifari jone budua bu ive none ije dabe ma vierafekinu maza boeje kurakinu vake. ");
INSERT INTO bbb_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Ijadufuo ni va e Isureroko ijiebuo e nigofo ije kaenamia besu afui areme kia, Asaerafa jone e Eburamekina Aesekikina Jekafu ijiebuo Godi ijare na biediemano kiane. Ro fu kie, Na Godi nare ja samuagiavo ro kuke nane izege e Ijifitiko ije bu ja kame vame isema revo ije nane giaevano kiane. ");
INSERT INTO bbb_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ro e Ijifitiko ijiebe bu kame vame ijia isekafiavo ijia na kaenamiana keke ruadufuo. Ro na kaenamia ruovo ije na kaenamiana are saruegi ro ine ro vajoma ro ire boeje ijia naovo ijia uniake. Ro are ije bu e Kenanaetiko ijiakina e Itaetiko ijiakina e Amoraetiko ijiakina e Ferisaetiko ijiakina e Jebusaetiko ijiebuo are ije miaga ja are ije abena ijia karike. ");
INSERT INTO bbb_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ro e Isureroko ijiebuo e nigofo ije bu vua irere a kuariamo ije bu fiedufuo. Bu vua ije fiega ni e ije kaenamiana va e Ijifitiko ijiebuo kini ije vua igene kuarane. Ja va kuarakuva ni kua, E Iburuko ijiebuo E Ireobo ije fune korufuo samadukua no biedue. Ijadufuo ni arega no va mu inokubeke are sao ijia karina E Ireobo Godi nuvuone ijadufuo zinone ifaejeno kuafo. ");
INSERT INTO bbb_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","20","Ro nane vierafega e Ijifitiko ijiebuo kini ije fube kiaga ja usiae vake. Rove nare daro none ijia ire sumiki bino fu jumedufuo ijia e Ijifitiko ije isekafiaga fu ije giana rade fu arega ja usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Nare e Ijifitiko ijiebuo vierafe kame kuderiaga bu ja aguariaekina ja usiae vakuva buka sinuome vajiaga ja kena vake ro jabe umui kiriasana vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Ro bara Isureroko besubesu ije bunika va bara Ijifitiko ije bu buina ae besu karijo ije giafo. Bu giaga bu ugone ro gorodi ro siriva ro ire zine igege iramo ije bu kena ijadufuo kiaga bu vajiafo. Bu vajiaga e Isureroko ije bu ire ije karina ame fari ro kabaerafa buone ije saejiakina bu vame ijiege rena e Ijifitiko ijiebuo sinuome ijene gue buone kena usiae vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","E Ireobo fu ijiege Mosisi kuaramo fu una gue kuae, Ro na vua ije e Isureroko kuaria bu naebe fiena ma vierafena kieko, E Ireobo fu naebe a biedaemano kiekuva na izerekono kuae? ");
INSERT INTO bbb_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Ro E Ireobo E Ireobo fu una Mosisi kuae, Ro ire ije a fare manino ije irereno kuae? Fu ijiege kuamoga Mosisi fu una kuae, Na mudu na bijuasanoejo ije farevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mosisi fu ijiege kuamoga E Ireobo fu una kuae. Ni mudu ije a farema ije abena sakaedo ijia akoeno kuamoga Mosisi fune ijiege rei. Fune mudu ije abena sakaedo ijia akoemoga mudu ije fu una tabare remo Mosisi fuka gana uri koe. ");
INSERT INTO bbb_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Areme E Ireobo E Ireobo fu urina Mosisi kuae, Ni daena ari tabare iviene ijia farena urino kuae. Fu ijiege kuamoga Mosisi fune daena ari tabare iviene ijia farena urimo fune una mudu rei. ");
INSERT INTO bbb_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Areme E Ireobo fu una Mosisi kuae, Nine va ijiege rega e Isureroko ije bu ijia gana vierafero fune ma asaerafa buone e Eburamekina Aesekikina Jekafu ijiebuo Godi ijare a biedaemaro bu ijiege vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","E Ireobo fu Mosisi ijiege kuara areme una kuke kuae, Ni umui one abena ugone one a ado abiema ijia abieno kuamoga fu E Ireobo irinana ijiege rei. Mosisi fu umui fuone abe ugone ijia abie areme una meru gake umui fuone fuka kati kunaena ka abaekirae. ");
INSERT INTO bbb_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Areme e Ireobo fu una Mosisi kuae, Ni una umui one abena ugone ijia abieno kuamoga Mosisi fu ijiege rei. Fu abe abiena una meru gake umui fuone fune subiema una vajae fuone ma igeki. ");
INSERT INTO bbb_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Mosisi fu ijiege remoga E Ireobo fu kuae, A ire gue na kuaraeva ije rega bu naebe ma vierafekuva ni una ige na nijasaeva ije rega bu ijia gana ma vierafene. ");
INSERT INTO bbb_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Ro a ire sumiki inokiro ije nidua buone ijia rega buka uria naebe ma vierafekuva nine una ige be rene. Ro ire be ije a redufuo ni va do Naero ijia jiana una ro sakae iriaeki ijia usiaga do ije fuka una kavuane reno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","E Ireobo fu ijiege kuaramoga Mosisi fu una kuae, Ro na vua kuaevo ije fuka totiekinu ro itire none fuka irufuinamimiemo. Na isuibe nane ijiege rena ruovo ijadufuo iviama a kuariemo ije na vierafe na uria ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Ro E Ireobo fu una Mosisi kuae, Ro a vierafega erare emabuo itire ro e ada tuguariaeva ro e itibaki ro e ni kuzeki ije amaeriae? E ijieki ije E Ireobo nare amaeriae. ");
INSERT INTO bbb_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ijadufuo ni vaga na kono ifejaga a vua kuaene. Ro vua izege a kuaedufuo ije nare nijasake a kuariano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Rove Mosisi fu una E Ireobo kuae, A isekie nika ebe kuaga fure vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Mosisi fu ijiege kuamoga E Ireobo fuka defaruimo fu urina kuae, Ro a uvia one Eroni e Rivaetiko ije a izege vierafe? Na vierafe fu e vua mukoe kuaemo ijadufuo fu manido fure vua one abe e gue kuariadufuo. Ro iviama fuje fu vame ijia a biedakiro ruodo fu ro a biedakuma fuka oemareke. ");
INSERT INTO bbb_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ijadufuo ni vua irere na kuaraeva ije fu kuaraga fure oefuo vua ije kuaene. Ro nare e inokiro ja ifejiana vua kuaekinu ro irere ja redufuo ije nijasiake. ");
INSERT INTO bbb_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Ro aeje a Godi igege rena vua irere fu kuaedufuo ije kuaraga fu una e ijene kuariake. A ijiege remo ije fu korufuo itire one ijia e ije kuariamo igeki. ");
INSERT INTO bbb_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ijadufuo ni mudu one abe vaekina a mudu ijare abena ire sumiki bino reno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","19","Ijiege rena Mosisi fu uria aesakae Midiani ijia fino ijia E Ireobo fu urina kuae, Ni una Ijifiti vane ijadufuo maeje e ije bu a kanakuae vierafeva ije bune oe furivano kuae. Ijadufuo Mosisi fune una va jure fuone e Jetiro fino ijia kekena kuae, Asekie abe oemaredo na iviama una va e none bu izege Ijifiti ijia kariva ije giano kuae. Fu ijiege kuaramoga Jetiro fu urina kuae, Ije fune maremano ni vano kuana uri anaema aremo fune vae. ");
INSERT INTO bbb_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Ijadufuo Mosisi fune uri sinuome fuone boeje ro bara fuone ijiakiro farirafa ije kaenamiana mave doniki ijia uniama areme bune una Ijifiti vakuae vae. Ro Mosisi fu kuke mudu ije E Ireobo fu abena daro maema ijiakuma abena vae. ");
INSERT INTO bbb_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Ijiege rena Mosisi fune Ijifiti vakiro vako ijia E Ireobo fu una kuke kuae, Iviama ane una Ijifiti vake ijadufuo nika ire sumiki boeje na daro mana kuarakinu nijasaeva ije kini Ferodo nidua ijia rene. Rove Ferodo vierafe ije nare dena gikikimana rega fube e ije arega bu usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Fu ijiege rekuma ni urina kua, E Ireobo fu kume, Na E Ireobo nare kume e Isureroko ije bu anafa none amureno kumemano kuane. ");
INSERT INTO bbb_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Na E Ireobo ije nare kume anafa none ije kiaga bu va none baname isoeno kume. Ro a faememarena naebe kiaga bu usiae vakuva nare ame fari one amure ije kanaga fu baroneko kumemano kuane. ");
INSERT INTO bbb_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Areme Mosisi fune Ijifiti vakiro vakuma vame ijia naekiro fino ijia E Ireobo fu uri Mosisi kanakiro rei. ");
INSERT INTO bbb_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","E Ireobo fu ijiege remoga Mosisido bara Zifora fu uri mune uiki ijia abena fari fuone ijadufuo vajae surive kana ufuna abe Mosisido dia ijia kamana farei. Ijadufuo maeje Zifora fu vierafero Mosisi fu fari fuone fu naebe vajae surive fuone kana ufuna nuga nijaedo E Ireobo fuka ziena kanakiro fu ijadufuo ijiege rei. Zifora fu ijiege remoga E Ireobo fu ijadufuo Mosisi fu naebe kanae ro fu ijia arei. ");
INSERT INTO bbb_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Areme maza sibaneke furikoga E Ireobo fu Eroni kuae, Va are sao ijia Mosisi bieno kuae. Ijadufuo Eroni fune urina uruo akae Saenae ije manino ijia Mosisi biekiro va ijia keke biena abe ui mi. ");
INSERT INTO bbb_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Areme Mosisi fune uri ire boeje E Ireobo fu kuaraema ijene una Eroni kuarae. Fu kuara areme uri ire sumiki bino fu redufuo ije E Ireobo fu nijaema ijene Eroni kuarae. ");
INSERT INTO bbb_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Areme bune va Ijifiti usiaena e Isureroko ijiebuo e nigofo boeje kaenamiana besu afui. ");
INSERT INTO bbb_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Bu kaenamia besu afuima areme Eroni fune urina vua boeje E Ireobo fu Mosisi kuaramoga fu una fu kuaraema ijene kuariae. Fu kuariama arekoga Mosisi fu uri nidua buone ijia ire sumiki ije E Ireobo fu nijaema ijene remo bu gae. ");
INSERT INTO bbb_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Areme E Isureroko ijiebuo e nigofo ije bu uri ire boeje Mosisi fu remo ije giana buka ma vierafei. Ijadufuo bu kuae, Vua ige no fiega fune ma E Ireobo ijare izege vajae fiane ige no abekinu renoevo ije gue ijadufuo fu no ifejuona dasumuokiro ruaemano kuae. Ijadufuo buka uri E Ireobo auge sana fuone baname isoe. ");
INSERT INTO bbb_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Areme Mosisikiro Eroni bune va e Ijifitiko ijiebuo kini Fero fino ijia usiaena kuae, E Isureroko ijiebuo Godi E Ireobo ije fu kumei, A e none arega bu usiae va ae sao ijia na aguariena iro be ino kumemano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Rove Fero fu urina kiae, E Ireobo ije ja kuaevo e ije era? Na irerefuo fu irinana e Isureroko ije arega bu usiae vake? Na E Ireobo ije na naebe gana vierafe ijadufuo nabe e Isureroko ije kiaga bu vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Fu ijiege kuariamoga Mosisikiro Eroni bu una gue kuae, Godi ije fu e Iburuko ijiebuo Godi ijare no bieduomo no gaeva ijadufuo no ije kuaravono kuae. Ijadufuo ni arega no va ae sao ijia maza inokube Godi nuvuone ije zinone ifaejane. Ro a naebe kuoga no irere E Ireobo Godi fu kuema ije rekuva fute ire ka ma ise bino nuvuone reke ro be fubite e bijaevo bino kiaga buka no kanuoga no oekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","Bu ijiege kuaravoga kini Fero fu urina Mosisikiro Eroni kiae, Ja irerefuo e jone Isureroko ije kiaga bu i ige bu menoevo ige arena vakuae kuaeve. E jone ije buka ma uruvana rove jane i ige bu mevo ije rega bu are vakuae reve. Ije ja revo ije arekiro kiaga bu iviama una i buone ije meno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Areme ve ijia kini Fero fu urina e mamekanu fuone bu e Isureroko ije bu moni baki imenoevo ije samuagiavo ijiakiro e Isureroko ijiebuo e mamekanu bu rotire buone ijia imevo ijene vua gikikimana kuariae. ");
INSERT INTO bbb_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","Fu kiae, Ja ivia igia una gafege jade nubuane ije bu tore ijiakuma biemaroga fu mune igege gikikimana rega bu kena are savo ijene e Isureroko ije vajiavo. Janika areke bu korubuo va rerena karina mune gikikimana ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Ja areke buka korubuo va rerena kari amaeriafo. Ro bu amaeriakuva nika kiaga bu uria mune izege bu ude amaeriavo ijiege amaeriakiro bude naba ije arena una guma amaeriavo. Bu bite i ije bu medufuo ije fu bakiga bu ijadufuo ijuonena kiega na kia bu va Godi buone ijene zinone ifaejekuae kieve. ");
INSERT INTO bbb_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Ijadufuo nika I gikikimana ijia vajiana kiaga bu maza boeje I ijene mekiro vua irere e iti kufuiki bu kuariaga bu fievo ije bu areno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Ijadufuo e mamekanu ije bu e Isureroko samuagiavo ije bune una va e Isureroko ije kuariae. Bu kia, Kini Fero fu kume fube una vajoma ije ja tore ijiakuma biemaroga bu mune igege gikikimana redufuo ije fube una bino vajiakono kumei. ");
INSERT INTO bbb_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ro jaka kojo va vajoma ije rerenoena ke areme una mune gikikimana ije amaeriake. Ro ja amaeriakuva jaka uria naba izege fu kiaema ijiege amaeriano kumei. ");
INSERT INTO bbb_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ijadufuo e Isureroko ije bune Ijifiti guove ijia oenoekinu vajoma ije rerenoe. ");
INSERT INTO bbb_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Rove e Ijifitiko ijiebuo e mamekanu ije buka urina e Isureroko ije kuriaerena kiae, Janika migegireigia vajoma ije rerena kari areme naba izege bu kiaeva ja uria ijiege amaeriano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Ro e Isureroko bu naebe mune gikikimana naba izege bu kiavo ijiege amaeriavone e Ijifitiko ijiebuo e mamekanu ije buka urina e Isureroko ijiebuo e nigofo ije ifiakinu kiavo ja irerefuo naba ije no kiavo ije ja naebe ijiege amaeriavono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Ijadufuo e Isureroko ijiebuo e mamekanu ije buka naebe oemareva ijadufuo bu va kini Fero fino ijia usiaena kuae, E Ireobo, a irerefuo no kame vame gikikimana ijia kafuomono kuae? ");
INSERT INTO bbb_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","E one bu vajoma ije bu tore ijiakuma biemarona mune gikikimana amaeriavo ije bu karina vajuovo baki. Rove buka kuokoke noka konuvuo va vajoma ije karina mune ije amaeriave. Ro irufui ije bu e one ijiebe reve ijadufuo maeje vajoma ije bu vajuovo bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Bu ijiege kuaravoga Fero fu una kiae, Vua ije ja kuaevo ije jame jare imekuae ijuonena kuaeve. Ja vierafe ja ijiege kuariega na kia ja va E Ireobo jone zinone ifaejekuae ja ijadufuo reve. ");
INSERT INTO bbb_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Ijadufuo ni una va imefo. Ja bube vajoma ije bu tore ijiakuma biemarona mune gikikimana amaeriavo ije vajiake. Ro ja amaeriakuva nika uria naba izege bu kiaeva ijiege amaeriano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Fero fu ijiege kuariamoga e Isureroko ijiebuo e nigofo ije bu vierafega buneka irufui ireobo abei. Ijadufuo maeje e Ijifitiko ijiebuo e mamekanu bu vierafe E Isureroko buka uria mune gikikimana bu are savo ije naba izege bu ude kuariaeva ijiege amaeriadufuo bu ije vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Areme e Isureroko ijiebuo e mamekanu ije bune kini Ferodo are ireobo ije arena usiae vagake Mosisikiro Eroni bu bu samuagiana kari. ");
INSERT INTO bbb_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Ijadufuo bu usiae biediana kiae, E Ireobo fu irere jare renoevo ije fune giae. Ijadufuo fu ja isekafiakiro fu kini Ferokina e fuone mamekanu ije kiaga bu no kame vame gikikimana ijia reve. Jare ijiege revo ijadufuo bute no kanuokuae revono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Areme Mosisi fune una va E Ireobo kuae, E Ireobo a irerefuo e one kame vame ise ijia isekafiame? A irerefuo na kiemo na igia ruae? ");
INSERT INTO bbb_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Na ive one ije nane kurana Fero kuarae rove fuka uria no kame vame ise ijia isekafuome. Ro kuke a irerefuo naebe ire be rena no karaunuokiro vierafemano kuae? ");
INSERT INTO bbb_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Mosisi fu ijiege kuaramoga Godi fu una kuae, Ivia na Fero ire be fuone rega a gake. Na daro none ije Fero nijaega fu ijia ga areme fu e none ije kiaga bu are fuone ige arena usiae vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Godi fu ijiege Mosisi kuara areme kuae, Naeje na Godi E Ireobo ijene. ");
INSERT INTO bbb_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Na maza ije na e Eburamekina Aeseki ro Jekafu na biediaeva ije naka Godi e ka ma daroki igege biediae. Rove maza ijia na ive none ije na kuae na E Ireobono kuaeva ije na naebe abe bu nijasiae. ");
INSERT INTO bbb_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Ro kuke nane buina vua kuae marena kia, Na e Kenanaetiko ijiebuo aesakae ije miaga bu abena e ae binoko igege ijia karike. ");
INSERT INTO bbb_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Ro iviama e Isureroko ije bu karina e Ijifitiko ijiebuo imenoekinu aduiga na fievo ijia na una vua izege na asaerafa jone ijena kuae mareva na ije vierafe. ");
INSERT INTO bbb_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Ijadufuo ni va e Isureroko ije kuariana kia, Na E Ireobo nare daro none ijia ire ka ma ise ijia buone re areme ja karauniake. Na vajae fiane jone izege jare isejavaekinu karina e Ijifitiko ijiebuo mani baki imekinu abevo ijia ifejiana karauniaga ja are ije arena usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Nare kaenamiaga ja e none rekiro nana Godi E Ireobo jone reke. Na ijiege rega ja ijia gie areme vierafero naeje na Godi jone ro nare izege ja e Ijifitikobuo ijiebuo rotire ijia karina irufui abevo na kaenamia keke ruaevaro ja ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nare kaenamiana keke aesakae ije na asaerafa jone Eburamekiro Aeseki ro Jekafu na miako kiaeva ijia uniaga ja jone abena ijia karike. Ijadufuo maeje naeje na E Ireobo jone na manido na ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Ijadufuo Mosisi fune va e Isureroko ije Godi vua boeje fu kuaraema ijene kuariae. Rove e fuone bu vua ije Mosisi fu kuariamo ije buka naebe fie. Ijadufuo maeje bu vajae fiane ijiakiro oe fiane ije buka ma uruvana abevo ijadufuo bu naebe fiekuae vierafe. ");
INSERT INTO bbb_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","Ijadufuo E Ireobo fu una Mosisi kuae, Ni va Fero e Ijifitiko ijiebuo kini ije gana kuaga fu e Isureroko ije kiaga bu are ige arena usiae vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Rove Mosisi fu una una kuae, E Isureroko ije bu vua ije a ude kuariemo na kuariaeva ije bu naebe fie. Ijadufuodo na vierafega Fero fudua fube vua none fieke. Ijadufuo maeje na e be na vua mukoe kuaenoevo bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Rove E Ireobo fu una Mosisikiro Eroni ije e Isureroko ijiakiro kini Fero ijiebuo kuariae. Fu kiae, Na E Ireobo nare kiaga ja e Isureroko ije kaenamia are Ijifiti ige arena usiae vakuvejo kiano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ro e Mosisikiro Eroni ijiebuo uifari ije bu uinuve ruaeva ije ijiege. E Rubini fu e Jekafudo fari amure ijene. Ro fuje fu ame fo (4) nafei ro ame ijiebuo ive ijeja e Anokina Farukina Ezironikina Kami ijene. Ro e ijiebuo ive ije bu asaerafa buone ijiebuo ive ije nabukaraniae. ");
INSERT INTO bbb_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ro e Simioni fuje fu ame fari sigisi (6) ijiege nafei ro ive buone ijeja e Jemuerokina Jaminikina Oedikina Jakinikina Zoakina e Soro ijene. Ro e Soro fu bara Kenanaetiko ije Simioni fu abema ijadufuo fari. Ro e boeje ige bu e Simionido agane. ");
INSERT INTO bbb_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Ro e Rivae fu ame inokube nafei ro ame ijiebuo ive ijeja e Gesonikina Koatikina e Merari ijene. Ro e Rivaedo juaevasia fu fina ruaema ije uvani aderedi teti seveni (137) ijiege. ");
INSERT INTO bbb_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ro e Gesoni fu ame fari inokiro nafei ro ame ijiebuo ive ijeja e Ribinikiro Simiae ijene. ");
INSERT INTO bbb_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ro e Koati fu ame fari fo (4) ijiege nafei ro ive buone ijeja e Ameramikina Isakina Ebironikina e Uzieri ijene. Ro e Koatido juaevasia fu fina ruaema ije uvani aderedi teti tiri (133) ijiege. ");
INSERT INTO bbb_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ro e Merari fuje fu ame fari inokiro nafei ro ive buone ijeja e Marikiro Musi ijene. Ro e ije bu e Revaedo agane ijiebe urina agane buone binobino afuina kari. ");
INSERT INTO bbb_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Ro e Amarame fu urina asoe fuone ijadufuo maki bara Jokabedi abenoga fu uri e Eronikiro Mosisi ije nafei. Ro e Amaramedo juaevasia fu fina ruaema ije fu uvani aderedi teti seveni (137) ijiege. ");
INSERT INTO bbb_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ro e Isa fuje fu ame fari inokube nafei ro ive buone ijeja e Korakina Nefegikina e Zikiri ijene. ");
INSERT INTO bbb_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ro e Usiero fudua fu kuke ame fari inokubeke nafei ro ive buone ijeja e Miserokina Erisafanikina e Sitiri ijene. ");
INSERT INTO bbb_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Ro Eroni fu urina e Aminadabedo kabae bara Erisiba e Nasonido maki ijene abei. Ro bara Erisiba fu urina ame e Nadabikina Abiukina Eriesakina e Itama ijene nafei. ");
INSERT INTO bbb_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ro e Kora fuje fu ame inokubeke nafei ro ive buone ijeja e Asirekina Erikanakina e Abiasafi ijene. Ro e boeje ije bu e Korado agane. ");
INSERT INTO bbb_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ro e Eriesa e Eronido fari ije fu uri e Futierodo kabae ije be abenoga fu uri e Finiasi bietei. Ro e boeje bu e Revaedo agane binobino ijiebuo e nigofo ijene. ");
INSERT INTO bbb_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Ijadufuo Godi fu Eronikiro Mosisi e inokiro ijene kiae, Jare e Isureroko ijiebuo agane binobino ije kaenamiana are Ijifiti arena usiae vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ijadufuo e inokiro ijiebe e Isureroko ije kaenamiana are Ijifiti arena usiae vakuae ude va Kini Fero biena fuina kuaeva ijene. ");
INSERT INTO bbb_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","29","Ro maza ije E Ireobo fu aesakae Ijifiti ijia Mosisi kuaraema ije fu ijiege kuarae. Fu kuae, Naeje na E Ireobo one. Ijadufuo ni va Kini Fero vua boeje na kuaraeva ijene kuarano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Rove Mosisi fu una E Ireobo ije kuae, Naeje naka e be vua mukoe kuaevo baki ijadufuo na vierafe kini Fero vua none fuka fiekuma baki. ");
INSERT INTO bbb_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Rove E Ireobo Godi fu urina Mosisi kuae, Nare aeje na abega a Ferodo nidua ijia Godi igege reke. Ro uvia one Eroni fu vua one fure abena e Godido vua vierafena kuaemo igege rena oefuo Fero kuaradufuo. ");
INSERT INTO bbb_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ijadufuo ni vua irere boeje na kuarakuvejo ije Eroni kuarane. A kuaraga fure oefuo Fero kuaga fu e Isureroko ije kiaga bu aesakae ige arena usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Ro na Ferodo vierafe ije naka bijukurake. Ro na nuga ro ire sumiki bino Ijifiti ijia rega fu giakuma fu uria ijiakuma vua one naebe fiedufuo. Fu ijiege rekuma E Ireobo nare daro none ijia are Ijifiti dabe mukoreigia arafiri areme na ijare sone e none Isureroko ije kaenamia keke ruake. ");
INSERT INTO bbb_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Na ijiege umui none akoena bu ke isekafia areme e Isureroko ije kaenamia keke roga e Ijifitiko bu sone ijia giena vierafero naeje na E Ireoboro bu ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","7","Ijadufuo Mosisikiro Eroni bune urina vua irere E Ireobo fu kuariaema ijiege rei. Ro maza ije bu Kini Ferona vua kuaraeva ije Mosisido juaevasia ije fu eiti (80) ro Eroni fuje fu eiti tiri (83) ijiege furiva ijia bu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Areme E Ireobo fu urina Mosisikiro Eroni kiae, Fero fu vierafega ja ire sumiki be rega fu gakiro kiakuma, ni Eroni kuaga fu mudu fu bijuanoeno ije abena nidua fuone ijia akoe fu una tabare rega fu gano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Ijadufuo Mosisikiro Eroni bune va irere E Ireobo fu kuariaema ijiege rena Eroni fune va mudu fuone fu bijuanoeno ije dabe Ferokiro e mamekanu fuone ijiebuo nidua ijia akoe. Fu dabe ijia akoemoga mudu ije fu una tabare rei. ");
INSERT INTO bbb_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Bu ijiege revoga kini Fero fu urina e fuone bino bu kine nanoevo ije kiamo bu iakina ine ro ire binobino bu vierafeva ije medinoena areme usiaena ire ni besu Eroni fu rema ijene rei. ");
INSERT INTO bbb_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Bu uri mudu buone bu bijuanoevo ije kena ume ijia korevoga mudu ije budua una tabare rei. Rove Eronido mudu ijare urina mudu buone ijene kame foteke sae. ");
INSERT INTO bbb_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Bu ijiege rei rove Fero fuka izege E Ireobo Godi fu kuariaema ijiege nigofo fuone fuka gikikimana rena Mosisikiro Eronibuo vua ije fuka naebe fie. ");
INSERT INTO bbb_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Areme E Ireobo fu urina Mosisi kuae, E Ferodo nigofo ije fune ma gikiki rei ijadufuo fube oemarekinu e none kiaga bu usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ijadufuo fu suoke maza ije fu do Naero ruvaema ijia vako ni va ijia biene. Ro a vakuma ni mudu one fu tabare rema ije abe va do irifo ijia samuana fine. ");
INSERT INTO bbb_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Ro Kini Fero fu vuakuma ni kua, E Ireobo ro e Iburukobuo Godi ije fu na kie, Va a kuaga a e none kia bu usiae vano kiemano kuane. A kiaga bu vaekina bu ae sao ijia na baname isoena kafiafirieno kie. Rove aka uria naebe fiema igege reme. ");
INSERT INTO bbb_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Ijadufuo E Ireobo ije fu kume, Na irere na rekuvejo ije rega a ijare na e izeki a ijia sone giekono kumei. Ijadufuo ni igia giekega na mudu ige na fareva ije abe do ado igia kanaga fu una dakudena kavuane rega ni gane. ");
INSERT INTO bbb_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ro kijume do igia oenoejo ije buka oe furiga do ige fuka muturena ka isema riga e Ijifitiko bube ikono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Areme E Ireobo fu uri Mosisi kuae, Ni Eroni kuaga fu mudu fuone dabe are Ijifiti guove ijia do isesina bu ivo ijiakina do mamekanu bu vako ijiakina do ije tura nafueva ijiakina do bu kaniva ijene nake kave ijia farei. Fu ijiege faremoga do boeje buka una kavuane rene. Ro kuke do bino bu ine ro sakae bu sukore amaeriava ijia jia naeva ije budua buka kavuane re furino kuae. ");
INSERT INTO bbb_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Areme Mosisikiro Eroni bune urina izege E Ireobo fu kuariaema ijiege rei. Eroni fune uri Ferokiro e fuone mamekanu ijiebuo nidua ijia mudu fuone dabe urina do Naero ije kanamoga do boeje buka una kavuane rei. ");
INSERT INTO bbb_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Do Naero fu una kavuane rekoga kijume do ijia oenoejo ije buka oekoga do ije funeka buraena ma isema ri ijadufuo e Ijifitiko do ije bu naebe una jiana i. Ijiege rena do boeje are Ijifiti guove ije buneka una kavuane re furi. ");
INSERT INTO bbb_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Areme e Ferodo e kine nanoevo ije budua bune usiaena ire ni besu Eroni fu rema ijene rei. Bu ijiege revoga Ferodo nigofo ije funeka una izege E Ireobo fu kuaema ijiege ka ma gikikimana rei. Ijadufuo fu Mosisikiro Eronibuo vua ije fu naebe fiero fuka uria faememare. ");
INSERT INTO bbb_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Ijadufuo Fero fune una urina are fuone ijia vagaro irere bu ni fuone ijia reva ije fuka naebe ireobo vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","25","Fu ijiege rekoga e Ijifitiko boeje bu va do Naero irifo ijia do ikuae sakae ijia runa rere. Ijadufuo maeje do maeje boeje buneka una iserema furi. Do boeje bu ijiege iserena naovakuma mu seveni ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Areme E Ireobo fu una Mosisi kuae, Nine una kuke va e Fero kua, E Ireobo ije fu kume ni e none kiaga bu usiae vaekina bu na dabe aroriekinu baname isoeno kumemano kuane. ");
INSERT INTO bbb_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ro a vua none ije a ijuonena naebe fiekuma E Ireobo nare a isekafana sabade ka ma uruvana ije kiaga bu aesakae one ijia ona iraraeke. ");
INSERT INTO bbb_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Ro do Naero ije fuka sabade ijare iraraega gue bu are one ijia ajia vuake. Bu ijia aruna are one guove ro suve one a riena naeno ijia ajia karike. Ro kuke buka e mamekanu one ijiebuo are ijiakina e one ijiebuo are ijia vuake. Bu ijia vua are ja ire ifaejevo ijiakina fata ja burete amaeriavo ijia aru karinoke. ");
INSERT INTO bbb_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ro kuke buka a ro e one mamekanu ijiakina e one ijiebuo vajae ijia ajia diroenokono kuae. Areme Eronikiro Mosisi bune una va kini Fero vua izege E Ireobo fu kuariaema ijene kuarae rove kini fu vua ije fuka naebe fie. ");
INSERT INTO bbb_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ijadufuo E Ireobo fune Mosisi kuae, Ni va Eroni kuaga fu mudu fuone fu bijuanoeno ije abena kave ijia farene. Fu abe kave ijia farega do isesina boeje bu ivo ijiakina do ije sakae tire ijia ajiavo ijiakina tura nafueva ije boeje buka sabade ijiebe iritoejeke. Bu ijiege rena are Ijifiti foteke ije okurano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Areme Eroni fune uri mudu fuone abena kave ijia farekoga sabade bune do boeje ijia usiaena aesakae boeje okurae. ");
INSERT INTO bbb_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Eroni fu ijiege remoga e kineki ije bune budua uri sinuome buone bu kine navo ije kena usiae sabade amaeriavoga bu usiae aesakae ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Rove Fero fu uri e fuone kiamoga bu Mosisikiro Eroni kaenamiana bu rovoga fu urina kiae, Ni E Ireobo jone ijadufuo baname isoega sabade ige bu arena vafo. Bu are vaga na e jone kia bu usiae vaekina bu E Ireobo jone zinone ifaejano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Rove Mosisi fu una Kini Fero kuae, Na oefuo baname isoekuva naka oemarekinu reke. Ijadufuo ni are maza nijaga na a ro e mamekanu one ijiakina e one ijiebuo baname isoega sabade boeje bu bakire vane. Bu bakire vakiro gue bu uria do Naero ijia oenoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Ijadufuo Fero fu urina Mosisi kuae, Ni isuome noefuo baname isoeno kuae. Ro Mosisi fu kua, Na maza ije a kiemo na ijiege rega a ijia sone gana vierafero godi bino umeigia bu E Ireobo Godi nuvuone ijieki bakiro a ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ro sabade ije bu e one mamekanu ijiakina e one boeje ije arafiriavo ije buneka oe furike. Ro bune sabade game do Naero ijia oenoevo ijiebe buosukua uria ijia oenoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Areme Eronikiro Mosisi bune Ferodo are ije arena bu una va gafia usiaena Mosisi fune uri sabade bu ruaeva ijadufuo E Ireobo baname isoe. ");
INSERT INTO bbb_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Areme E Ireobo fu Mosisido baname fu isoema ije fie ijadufuo sabade boeje bu are guove ro makave ro juare ijia oenoevo ije buka oe furi. ");
INSERT INTO bbb_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Bu oe furikoga e Ijifitiko ije bu numuna besu akoevoga bu ijia burae areme udi ka ma ise ijare aesakae foteke ije fuka irarae. ");
INSERT INTO bbb_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Areme Kini Fero fu gake sabade ije bune oevoga fuka una izege E Ireobo fu kuaema ijiege nigofo gikikimana rena Mosisikiro Eronibuo vua ije fu naebe fiejiae. ");
INSERT INTO bbb_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ijadufuo E Ireobo fu una Mosisi kuae, Ni Eroni kuaga fu mudu fuone fu bijuanoeno ije abena sakae ijia kanaga kuokuo ije bu una ugone rena aesakae Ijifiti foteke iraraeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Areme Mosisi fune va Eroni ijiege kuaramoga fu urina mudu fuone dabe sakae ije kanae. Fu ijiege kanamoga kuokuo ije fu una ugune rena aesakae Ijifiti ijia e ro fanu binobino ijia oenoeva ije nafiriae. ");
INSERT INTO bbb_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Bu ijiege revoga e Ijifitikobuo e kine navo ije budua bune uri sinuome buone bu kine navo ije kena uri ugune amaeriakuae re rove buka naebe manivo bu ijia arei. ");
INSERT INTO bbb_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ijadufuo e kineki ije bu uri Kini Fero kuae, Ire ige fune ma Godire remono kuae. Ro Fero fuka uria izege Godi fu kuaema ijiege nigofo gikikimana rena Mosisikiro Eronibuo vua ije fuka naebe fie. ");
INSERT INTO bbb_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Ijadufuo E Ireobo fu una kuke Mosisi kuae, Isuome suoke Fero fu do gamia vake. Ijadufuo ni va ijia biena kua, E Ireobo fu kume, E none ije arega bu usiae vaekina bu na baname isoena kafiafiriene. ");
INSERT INTO bbb_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ro ni kua, A irere na kuaravo ije a naebe rekuma na a isekafana umuanumua kiaga bu a ro e one mamekanu ijiakina e one ijiebuo vuake. Bu e one Ijifitiko ijiebuo are ro sakae ije buka iraraena okurake. ");
INSERT INTO bbb_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Ro are Goseni e none kariva ije na bijukuraga umuanumua ije bube ijia vake. Na ijiege rega a ijia gana vierafero naeje na E Ireobo ije ire boeje fina reko bu ume igia ruovo ijare ro a ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Na e none na vame ijiege rekiro e one na una vame be rega a ijia gana vierafeke. Ro vame sumiki ije na isuome rega a gakono kuane. ");
INSERT INTO bbb_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Areme E Ireobo fune urina umuanumua ma uruvana ije kiamoga bu kena Ferodo are ireobo ijiakiro e mamekanu fuone ro e Ijifitiko ijiebuo are ijia ruae. Umuanumua bu ijiege rena aesakae Ijifiti ije foteke arafirivoga funeka ma iserei. ");
INSERT INTO bbb_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Ijadufuo Kini Fero fu urina Mosisikiro Eroni ijiebuo kiamo bu kaemia rovoga fu kiae, Na vierafe ja va E Ireobo jone ijadufuo zinone ifaejeke. Ro zinone ifaejeke vakuae vierafekuva ja uria aesakae igia karikinu usiae vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Ro Mosisi fu una Fero kuae, No ijiege redufuo ije na vierafe fuka naebe mare. Ijadufuo maeje fanuve nuvuone no kaniana E Ireobo nuvuone ije zinone ifaejakuva e Ijifitiko ije buka naebe oemareke. Ro kuke no fanuve ije kaniana zinone ifaejega e Ijifitiko bu guokuva buka isediaga buka mune tuana kanuo no oedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Ijadufuo no vierafe noka mu inokubeke va ae sao ijia izege E Ireobo nuvuone fu kuaruema ijiege rena fuone zinone ifaejekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mosisi fu ijiege kuarae rove Fero fu una kuae, Na vierafe na kiaga ja va ae sao ijia E Ireobo ro Godi jone ije zinone ifaejake. Ro ja vakuva jade mumabo ijia vako ro nime ivuake ijia va zinone ifaejekinuro noefuo baname isoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Fu ijiege kuaramoga Mosisi fu kuae, Na isuome vakuva na E Ireobo baname isoega fu umuanumua ije kia bu a ro e mamekanu one ijiakina e Ijifitiko ije arena vake. Ro ade una no biesiruoga e none bu E Ireobo zinone ifaejeke vadufuo ije bu arevono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","31","Areme Mosisi fune Ferodo are ije arena una va gafia kekena fuefuo E Ireobo baname isoemoga fu fiena irere Mosisi fu kuaraema ijiege rei. Fu umuanumua ije kiamoga bu Ferokina e mamekanu fuone ijiakina e Ijifitiko ije arena vae ro umuanumua besukua be fu naebe una ijia oenoe. ");
INSERT INTO bbb_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Rove Ferodo nigofo fu uria gikikimana rei ijadufuo fu naebe e Isureroko ije kiamo bu usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Areme E Ireobo fu una Mosisi kuae, Va Kini Fero kua e Iburukobuo E Ireobo ije fu kume, E none kiaga bu usiae vaekina bu na baname isoena kafiafirieno kumei. ");
INSERT INTO bbb_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","3","Ro a vua none ige ijuonena naebe kiaga bu usiae vakuva na adame ka ma omise be kuaga fu e Ijifitiko fanu jone ijiebuo ruake. Fu fanuve ose ro doniki ro kamero ijiakina kau ro mave sifi ro goti jone boeje ijiebuo roga bu oeke. ");
INSERT INTO bbb_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Na E Ireobo nare e Ijifitiko ijiebuo fanuve ije ke be uniaga ro e Isureroko ijiebuo fanuve na ke be uniake. Na ijiege rega adame ka ma ise fu e Ijifitiko ijiebuo fanu ije kania bu oekiro e Isureroko ijiebuo ije bube oekono kumei. ");
INSERT INTO bbb_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Ro E Ireobo fu kume, Ire ije na vierafe na isuome aesakae Ijifiti igia rekono kumei. ");
INSERT INTO bbb_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Areme nituame E Ireobo fu urina irere fu kuaema ije remoga e Ijifitiko ijiebuo fanuve boeje buka oefuri. Ro e Isureroko ijiebuo fanuve boeje besukua be fu naebe baronei. ");
INSERT INTO bbb_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Ijadufuo kini Fero fu urina e fuone bino kiamo bu ire ije remo ije gakuae vae. Bu va ganoena areme una usiaena Fero kuae, Ire ije fu rema ijia e Isureroko ijiebuo fanuve boeje besukua be fu naebe barone ro bune e Ijifitiko ijiebuo fanuve ijiaru oevano kuae. Bu ijiege kuaravoga Kini Fero fune fie rove nigofo fuone fuka uria girei ijadufuo fu naebe e Isureroko ije kiamo bu usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Areme E Ireobo fu una kuke Mosisikiro Eroni kiae, Ni va are bu miane ifaejevo ijia tuvuare ije numufo. Ja numuga Mosisi fu tuvuare ije kena Kini Ferodo nidua ijia kave ijia korefo. ");
INSERT INTO bbb_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Fu kena kave ijia korega kuokuo ije fu are Ijifiti foteke ije okuraga e ro fanu boeje bu mibiare abeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ijadufuo Mosisikiro Eroni bune urina tuvuare sibaneke uruna Fero fu fino ijia vae. Bu va ijia usiae irekoga Mosisi fu urina Ferodo nidua ijia tuvuare ije kena kave ijia korei. Fu ijiege koremoga fu mibiare rena ari e ro fanuve boeje kunariamoga bu matane abei. ");
INSERT INTO bbb_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Bu ijiege revoga e ije kine navo ije bu naebe una Mosisi fino ijia ruae. Ijadufuo maeje e Ijifitiko boeje bu mibiare abekoga e kine navo ije budua bu mibiare abeva ijadufuo bu naebe una Mosisi fino ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Rove E Ireobo fune izege fu kuaema ijiege rena fuka Ferodo nigofo ije dabe gikikimana remoga fu Mosisikiro Eronibuo vua ije fu naebe fie. ");
INSERT INTO bbb_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Ijadufuo E Ireobo fu kuke una Mosisi kuae, Ni isuome suoke mugamia urina va Fero biena kua, E Ireobo e Iburuko ijiebuo Godi ije fu kume, E none kiaga bu usiae vaekina bu na baname isoena kafiafirieno kumemano kuane. ");
INSERT INTO bbb_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Ro kuke ni kua, Ivia na e one mamekanu ijiakina e one boeje ije kame ma urukeigia isekafia areme na kuke adua dabe ijiege isekafake. Na ijiege rega a ijia ga vierafero godi bino ume igia na vareki ije buka bakiro a ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ro kuke ni kua, Na ivia umui none ijia akoena adame ka ise ijia abena akina e one boeje kaniaga ja oe furi bitie na ijiege reke. ");
INSERT INTO bbb_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Rove na naebe ijiege re ijadufuo maeje a nane ijadufuo abe nujaevado name daro none fu izieki na ijiaru abe a nijasaga e bu vua ije dabe kuaena are irore boeje ijia vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ro aka uria aroekarakinu ijuonena e none a naebe kiamo bu usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ijadufuo isuome na ve ome mamekanu ka gaeki be fu ude Ijifiti guove igia arimo e bu ni buone ijia gaeva baki ije kuaga fu igia arike. ");
INSERT INTO bbb_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ijadufuo ni e one kiaga bu fanu binobino bu samuagiavo ijiakina ire binobino bu are makave ro juare ijia naeva ije boeje karina are guove ijia uniane. Ijadufuo maeje na vekiro iduane ka ma ise ijene kuaga fu arina e ro fanuve ije juare ijia oenoevo ije kaniaga bu oeke. ");
INSERT INTO bbb_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Areme Kini Ferodo e mamekanu gue bu vua ije E Ireobo fu kuaema ije fievo buka de judiae. Ijadufuo bu urina e buone imejo ijiakina fanuve buone ije kaenamiana are guove ijia uniae. ");
INSERT INTO bbb_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Ro e gue bu naebe vua ije E Ireobo fu ju kuariaema ije ma vierafe ijadufuo bu e buone imevo ijiakina fanu buone binobino bu uria juare ro ae makave ijia uniae. ");
INSERT INTO bbb_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","E Ireobo fu vua ijiege Kini Fero nija areme fune urina Mosisi kuae, Ni urina umui one kave ijia korega ve ome mamekanu ka gaeki ka ma ise ije fu arine. Fu arina e boeje ro fanu binobino ijiakina ine binobino bu ae sakae Ijifiti guove ijia ireva ije arafiriano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Fu ijiege kuaramoga Mosisi fune uri mudu fuone ije dabe saove gufia gakinu nifurimoga E Ireobo fune makibae ije kuamo fu ari. Fu arikoga saove fu kumena irakinu ari are ije kame arafiriae. E Ireobo ijare ire makibae ije kuamoga fu arina are ije dabe mukoreigia arafiri. Ro fuka ve ma ise ro iduane be e Ijifitiko bu karina ruaeva ijia ire ijieki be fu naebe gaeva ijare rei. ");
INSERT INTO bbb_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Ro are Ijifiti guove ijia fu ve ijiakiro iduane ijiebe dakinu arina ire boeje ae makave ro juare guove ijia naovo ije kame arafiriakinu e ro fanuve boeje arafiriae. Fu arina fiene boeje kaniamo bu saerekinu ine boeje buka tuana umeke vafuri. ");
INSERT INTO bbb_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Ro are ije ve ro iduane fu naebe ijia arikuma ufima ije fu are Goseni e Isureroko bu kariva ijia fu naebe ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Ijadufuo Kini Fero fu urina Mosisikiro Eroni vua nijiana kume, Iviama na vierafega nane ma isema rei. Ro irere E Ireobo fu remo ije fuka ma ijadufuo reme. Rove nare e none ijena noka ma isema revano kumei. ");
INSERT INTO bbb_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ro iduane igiakiro ve ige damo ije none ka mani ijadufuono ni nuvuefuo E Ireobo ije baname isoene. Naneka ma kuado na kiaga ja usiae vadufuo ro jade una igia maza jiamadogo karidufuo. ");
INSERT INTO bbb_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Fero fu ijiege kuaramoga Mosisi fu kua, Na maza ije na sidove ige arevo ijia na sone ijare umui none kafe ajiana E Ireobo ijadufuo baname isoekono kuae. Nane ve ije na keke vakuvejo ijia na baname isoega saove ige kumeno ijiakiro ve ige damo ije bu ijia arega a ijare vierafero ire boege fu E Ireobo ijadufuo ro a ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Rove na vierafega a ro e one mamekanu ije ja uria E ireobo ije ja jumevo baki. ");
INSERT INTO bbb_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Ro e Ijifitiko ijiebuo juare ijia ire firekisi bu begi amaeriavo ijiakina ire bari fu vuiti igeki bu ivo ije kame arafiriae. ");
INSERT INTO bbb_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Ro ire vuiti ije bino bu naebe arafiriae ijadufuo maeje bu rade kiravo. ");
INSERT INTO bbb_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Areme Mosisi fu Kini Fero ro sidove ije arena keke vako ijia fu umui fuone kake korena saove gufia gakinu E Ireobo ijadufuo baname isoe. Fu baname isoemoga saove ijiakina ve ije damo ijiakina iduane ije arimo ire fu ijia arei. ");
INSERT INTO bbb_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ro maza ije ire ije rema ije kini Fero fune ni fuone ijia giae. Rove fu una ise rena fu ro e mamekanu fuone ijena buka nigofo gikikimana rei. ");
INSERT INTO bbb_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ro Fero ijiege fu remo ije fune E Ireobo ijare ude Mosisi ijiege kuaraema ijadufuo fu naebe e Isureroko ije aremo bu usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Areme E Ireobo fune una Mosisi kuae, Kini Ferokiro e fuone mamekanu ijiebuo nigofo bu girevo ije E Ireobo nare kame ijiege rejiave. Na ijiege rejiaekina na ire sumiki ka daroki ije buone rega bu giake. ");
INSERT INTO bbb_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ro kuke jadua ja ije giakuva ja rade oenoene anafa jone ijiakina asaerafa jone ije izege na e Ijifitiko ije kame vame ise ijia isekafiana ire sumiki ije buone revo ije kuariake. Ro kuke e boeje jadua ja ije giavo ijia ja vierafero naeje naka ma E Ireoboro ja ijiege vierafeke. Ijadufuo ni iviama una va kini Fero gana vua kuarano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Ijadufuo Mosisikiro Eroni bune una Kini Fero fino ijia vae. Bu va ijia usiaena kuae, E Ireobo e Iburukobuo Godi ije fu kume, Aeje aka oemarekinu kabuaekabuaeki oe dasuna vua none fiena iriniekiro vierafemo baki. Ijadufuo ni e none arega bu usiae vaekina bu none baname isoena kafiafirieno kumei. ");
INSERT INTO bbb_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ro a uria vua none naebe fiena e none kiaga bu usiae vakuva na isuome kabamisu kiaga bu aesakae one igia ruake. ");
INSERT INTO bbb_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Ro kabamisu ije buka ma uruvana rena aesakae ige foteke iraraeke. Bure ijiege iraraena uri ire ijiakiro ine ije ve ome mamekanu ka gaeki fu arina arafiriaga arema ije boeje ka i furike. ");
INSERT INTO bbb_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Ro kuke kabamisu ije buka arina are one ijiakina e one mamekanu ro e Ijifitiko boeje ijiebuo ije iraraeke. Ro ire ije asaerafa jone bu iko ae sakae igia karinoeva ijia bu ire ijieki be naebe gaeva ijare rekono kuane. Ijiege rena Mosisikiro Eroni bune Kini Fero ijiege kuarama furina buna una vae. ");
INSERT INTO bbb_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Areme Kini Ferodo e mamekanu ije bu urina Fero kuae, A vierafega e ige fu maza izege no irufui vajuoruke? Ijadufuo arega e Isureroko ije bu usiae vaekina bu E Ireobo ro Godi buone ije baname isoena kafiafirine. Aeje aka ni nisuina fikoke are ige Ijifiti funeka ma iseremo ige gano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Bu ijiege kuaravoga Fero fu ijadufuo urina Mosisikiro Eroni vua nijiana kumenoga bu kaenamiana ruae. Bu rovoga fu urina kiae, Na vierafe jane ivia va E Ireobo jone ije baname isoena kafiafirike. Ro ja vierafe e ije eranebe vakono kiae? ");
INSERT INTO bbb_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Fu ijiege kiamoga Mosisi fu urina kuae, Na vierafe no e boeje anafa nuvuone fari ro kabae ro eove ije noka foteke vake. Ro kuke fanu nuvuone boeje noka kaenamiana vake. Ijadufuo maeje e boeje noka vaekina no E Ireobo nuvuone ije aguaena fuefuo iro ireobo be ikono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Bu ijiege kuaravoga Fero fu urina Mosisi kua, Naka E Ireobo one ijadufuo ive ijia kurana kuaedo nabe arega a bara ro ame one boeje kaenamia vake. Ijadufuo maeje nane samadukua gaga a vame be mauike nuriete rekiro vierafena reme. ");
INSERT INTO bbb_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Ijadufuo na vierafe a e fari ijiaru kaenamiana usiae va E Ireobo ijadufuo baname isoena kafiafirine. Ijadufuo maeje ane ijadufuo kiekie unamunaemano kuae. Kini Fero ije fu ijiege Mosisikiro Eroni kuaria areme uri e mamekanu fuone ije kiamo bu uri rorukuriavo bu Fero arena usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Areme E Ireobo fu uri Mosisi kuae, Ni umui one kafe ajiana Ijifiti nake akoega kabamisu bu aesakae ijia arine. Bu arina ire ro ine boeje ve ome mamekanu ka gaeki fu arina arafiriagaro nugune areva ije ka i furino kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Ijadufuo Mosisi fune urina mudu fuone abe aesakae Ijifiti kave ijia farei. Fu ijiege faremoga E Ireobo fu ijia majaufi ka ma ireobo ije maza ajiamo nake kuamoga fu aesakae ijia ufi. Majaufi ije fu maza ijia ijiege ufuikinu kabamisu boeje kaenamiana aesakae ijia ruako vakuma ve irasei. ");
INSERT INTO bbb_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Bu ijiege afuina ruoma arekoga aesakae Ijifiti foteke ije buneka ire kabamisu ijiebe irarae. Ro kabamisu ije bu ijiege afuiva ije ude ma isuibe be bu naebe ijiege afui ro kuke rade ijieki be bu gakuva baki. ");
INSERT INTO bbb_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Kabamisu ijiebe usiaena aesakae foteke ije iraraevoga fuka kaziaberei. Areme bune uri irekina ine sunine nugune ije majaufi ijiakiro ve ome mamekanu ka gaeki ije bu arina arafiriaga areva ije buneka foteke ina furi. Bu ina furikoga rade bu naebe una ia getiki bino aesakae Ijifiti guove ijia giae. ");
INSERT INTO bbb_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Areme Fero fune migegire una Mosisikiro Eroni kumeno bu rovoga fu kiae, Na vierafe naka E Ireobo Godi jone ijiakiro jone isema rei. ");
INSERT INTO bbb_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ijadufuo ni iviakinu ise none ige una giena aregaro E Ireobo Godi jone ije baname isoega fu ire ka ma ise ige nuvuone remo ije abe vano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kini Fero fu ijiege kuariamoga Mosisikiro Eroni bune una va Ferodo Godi baname isoe. ");
INSERT INTO bbb_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Mosisi fu baname isoemoga Godi fu maza koeno nake majaufi ka ma daroki be kuamo fu ufi. Fu ufina keke kabamisu boeje kari una Davare Kavuane nafuema ijia ari. Ro kabamisu besukua be fu naebe una are Ijifiti ijia fi. ");
INSERT INTO bbb_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Rove E Ireobo fu una kuke Ferodo nigofo ije bijukuramoga fu naebe e Isureroko ije kiamo bu usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Areme E Ireobo ije fune una kuke Mosisi kuae, Nine una kuke va saove gufia gakinu umui one kafe ajiaga ve ma ireobo fu titutega e bu izege ganamidufuo baki ije fu titutena aesakae foteke ije okurano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Ijadufuo Mosisi fune kake saove ijia gakinu umui kafe akoemoga mu inokubeke ijiege aesakae Ijifiti foteke ije fuka ve ma ireobo titutei. ");
INSERT INTO bbb_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Fu ijiege titutemoga E Ijifitiko ije bu izege bue ganamikuva baki ijadufuo mazani ije bume mauike are buone ijia kari. Ro una e Isureroko ijiebuo are ije fu maza nako bu ijia karinoe. ");
INSERT INTO bbb_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Ijadufuo Kini Fero fu una Mosisi kumeno fu romoga fu kuae, Nine ame ro bara ije kaenamiaga bu aena va E Ireobo one baname isoekinu fu kafiafirifo. Ro mave-sife ro goti jone boeje ijiakina mave-kau ije jade kaenamia vakiro ni igia arena vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Fero fu ijiege kuaramoga Mosisi fu urina kuae, A kuoga no vakuva ni kuoga noka fanuve nuvuone kena vaekina no E Ireobo Godi nuvuone ije zinone ifaejane. ");
INSERT INTO bbb_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","No vierafe fanuve nuvuone boeje noka kaenamia vadufuo ro bino nobe igia arena vake. Ijadufuo maeje no konuvuo fanu irere kena E Ireobo ije zinone ifaejana baname isoedufuo ije noka naebe vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Rove E Ireobo fu una Ferodo nigofo ije bijukuramoga fu naebe E Isureroko ije kiamo bu usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Ijadufuo kini Fero fuka urina vua gikikimana Mosisi kuarana kuae, Na a naka isediemono keke vane. Na ivia igia una gafege nikubae one ije nabe una igia gake. Ro na una igia a gakuva naka kanaga a baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Fero fu ijiege kuaramoga Mosisi fu una kuae, Vua irere a kuariemo ije ane ma kuariemo ijadufuo na vierafe rade abe una na giekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Areme E Ireobo fune ude Mosisi irere fu redufuo ijene kuarae. Fu kua, Na ire besukua rena Kini Ferokiro e Ijifitiko ijene kame isekafiake. Na ijiege rega Fero fu sone rade kiaga ja Ijifiti arena usiae vake. Ro maza ije fu kiaga ja vako ije funeka ma mukoreigia kuriaerega ja usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Ijadufuo ni e one Isureroko ije kiaga bu e Ijifitiko ije buina karivo ije kia bu ire binobino bu gorodi ro ire siriva ijia amaeriaeva ije bino vajiafo. ");
INSERT INTO bbb_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","(Ro maza ijia E Ireobo fuka e Ijifitiko ijiebuo oe ijene kame kuderiamoga buka uri e Isureroko ije mukoreigia oemarejakinu aguariae. Bu ijiege rekoga Ferodo e mamekanu ijiakina e Ijifitiko boeje bu uri Mosisi buka dabe e anuigi igege vierafei). ");
INSERT INTO bbb_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","5","Ijadufuo Mosisi fune uri izege E Ireobo fu kuaraema ije uri kini Fero kua, E Ireobo fu kume, Ivia muge ve ufirema ijia na Ijifiti guove ijia oenoeke. Na ijia oenoekinu e Ijifitiko ijiebuo ame amuifari ije kania bu oeke. Ro amure ije na Kini Fero e ije fata maeje abena fino ijadufuo ame amure ijia zinueve kana areme uri ame boeje ijiege kaniana vakuma bara ije bu e guebuo mani baki imevo ijiebuo ame ijia vake. Ro kuke na mave-kau ro fanuve ni binobino ijiebuo anafa amuifari ijene dua kania bu oeke. ");
INSERT INTO bbb_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Ro ire ije fu ude isuibe naebe rei ro kuke rade fu rekuma baki ijare rega e boeje are Ijifiti guove ijia kariva ije buka urukeigia sisimena isejavaeke. ");
INSERT INTO bbb_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Ro kuke mu besu ijia E Isureroko buka oemarekinu mauikeigia kariva ijadufuo siroe buone besukua be fube kuri ro omanike. Ijiege rena e Isureroko ije na kena vame be ijia kafiaga e Ijifitiko ije na vame be ijia kafiaga a giake. Na vame ijiege rega a ijia gana vierafero na E Ireobo nare ire ije revoro a ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mosisi fu ijiege kini Fero ije kuara areme kuae, E Ireobo fu ijiege rega e one mamekanu bu ro Mosisi na auge sana soesoekinu kieko ni uri e one kaenamiana keke vano kieke. Areme na ijare rade ae sakae arena keke vakono kuae. Mosisi fu vua ijiege kini Fero kuarama areme funeka ma ireobo ziegafana keke vae. ");
INSERT INTO bbb_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ro E Ireobo fune ude izege Fero fu redufuo ije fune Mosisi kuarae. Fu kua, Kini Fero fu uria totenamina vua one fuka fiejakuma baki. Fu ijiege rekuma nare ire sumiki daroki bino aesakae Ijifiti guove ijia rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Ijadufuo Mosisikiro Eroni bune ire sumiki daroki boeje Ferodo nidua ijia rei. Rove Godire nigofo fuone dabe gikikimana remoga fu naebe e Isureroko ije uniamo bu aesakae fuone arena usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","2","Ijiege rena Mosisikiro Eroni bu uria Ijifiti kariva ijia E Ireobo fu vua nijasiana kiae, Asame amure ja juaevasia iviaeko zinuevedufuo ije fune igifureki ruae. ");
INSERT INTO bbb_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ijadufuo ni vua ige na kuariakuvejo ije e Isureroko agane boeje kuariafo. Ni kuariana kia, Asame igadufuo ijia ro mu teni furino ijia e fari besubesu fuka agane fuone are besu karijo ijiebuo mave-sife ame ijia bino buone iraeraefo. ");
INSERT INTO bbb_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Ro agane be fanu buone bu idufuo ije fu ireobo ro agane fuone bu e sibanekekuma funika e are ivuake fuone ijia fino ijiaki fanuve ije abe buvua ivajuonamike. Ro kuke e agane bu iga fu manidufuo ijia giakinu refo. ");
INSERT INTO bbb_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Ro fanuve ja kaniadufuo ije ja mave-sife ame ro baga goti ame ijia kaniadufuo. Ro mave ije bu kumate juaevasia besu furima ro vajae maturaeva ijia giana kaniafo. ");
INSERT INTO bbb_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Areme nine gaga mazani fune fotini (14) abega ni e Isureroko agane boeje kiaga bu fanuve buone ije kaniake. ");
INSERT INTO bbb_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Areme ni e agane besubesu kiaga bu fanuve ijiebuo kavuane gue kena are izia bu karina fanuve ije idufuo ijiebuo viene ikene guegue ro ado ijia azifo. ");
INSERT INTO bbb_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Areme nine mazani besu ijia fanuve karina kuriemekiro siri ijiakuma mukoreigia ifaejekina bu karina burete ije bu ire isiti baki amaeriava ijiakuma idufuo. ");
INSERT INTO bbb_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ro fanuve bino bude kena iko ikinuro sukore kirana ivo. Ro kuke fanuve boeje foteke nigofo ro masiane ro de vuare ije nika miane ifaejena ifurifo. ");
INSERT INTO bbb_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ro bino bude isuofuo suba navo ro ja bino uria nakuva ije nika suoke karina miane ifaejega fu naena furifo. ");
INSERT INTO bbb_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Ro iro Fasova ije ja idufuo ije ja na aguarievo. Ijadufuo ja iro ije ikuva nika migegire ikina ja uri sinuome jone ro dia surive jone sakinu mudu ja bijuasadufuo ije kanafuina samuake. Ijadufuo maeje na maza ijia migegire ruovo ijadufuo ja ijiege reke. ");
INSERT INTO bbb_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Ja ijiege rena jane vakuae samuaeva ijia na muge ro e boeje are Ijifiti guove ijia karinoeva ijiebuo ame fari amuifari ijiakina fanuve buone ijiebuo ame amuifari ije kaniaga bu oeke. Areme na kuke e Ijifitiko ijiebuo godi ije kame isekafiaga bu ijia sone giena vierafero naeje naka E Ireoboro bu ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Ro jaeje fanuve kavuane ja kena are ja karivo viene guegue ro ado ijia aziva ijare nuga igege ijia namo ijadufuo na ijia gake. Na kavuane ije gakuva nabe ja kaniakiro na asidiana e Ijifiko ijiaru isekafiake. ");
INSERT INTO bbb_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Ro Fasova mazani ije nika abe ireobo oemarena vierafefo. Ro juaevasia besubesu ijia janika ijiege rekinu una izege E Ireobo nare Ijifiki ijia ja karauniaeva ije vierafekinu vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Areme E Ireobo fune urina Mosisikiro Eroni vua ije bu izege iro ina fu vierafedufuo ije kuariana nijasiae. Fu kiae, Ja oenoeno iro Fasova ije ikuva mazani seveni (7) ijiege jade burete ije bu ire isiti ijiakuma amaeriva ije ikiro nime burete ire isiti baki ijiaru inoeno kiae. Ro maza amure ijia nika ire isiti boeje are jone ijia naovo ije karina korefo. Ijadufuo maeje e be erare fu burete ije bu isiti ijiakuma amaeriaeva ije ikuma e ije bu rorukuraga fu E Isureroko ije arena vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Ro mazani ije bu iro ijo ijia amure ijiakiro mazani seveni (7) ije e boeje buka una besu afuina none baname isoekinu kafiafirieke. Ro kuke mazani ijia e bube imeke ro ire ijiaru bu uria kirana idufuo. ");
INSERT INTO bbb_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Ro mazani ije bu kua Burete Ire Isiti Bakino kuavo ijadufuo mazani ije janika abena mukoreigia samuafo. Ijadufuo maeje na mazani ijia asaerafa jone are Ijifiti ijia karauniana kaenamia keke ruae. Ijadufuo ja juaevasia besubesu mazani ije ruomo nika abena ireobo vierafekinu iro ina oemarefo. ");
INSERT INTO bbb_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ro kuke asame amure ijadufuo maza fotini (14) ijadufuo mufuo ijia vakuma tuaedi uvani (21) mufuo ije jade burete isitikuma amaeriaeva ije ijo. ");
INSERT INTO bbb_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Ro maza umuifague ro dikine inokiro ijiege ire isiti bino jade karina are jone ijia naovo. Ro e jone ro e ae binoko bino bu ijia jaena karijo ije bu burete ije ire isitikuma amaeriaeva ije ikuva e ije bu rorukuriaga bu E Isureroko ije arena vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","E Ireobo Godi fu vua ijiege kuariama furinoga Mosisi fu urina e Isureroko ijiebuo e nigofo ije kumeno bu besu afui. Bu afuivoga fu urina kiae, Ni va e Isureroko e besubesu ije kiaga bu mave-sife ro goti ame ijia giana kaniaga agane buone bu Iro Fasova ije ifo. ");
INSERT INTO bbb_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Ro ja ikuva nine ine kia iseke isofino kuavo ijia abe fanu kavuane ja kena disi ijia veseva ijia abiena abe viene guegue ro ado ijia azifo. Ro e jone besukua be fube are fuone ije arena keke vakiro buka are ijia karike fu vakuma ve irasefo. ");
INSERT INTO bbb_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Ja ijiege reke E Ireobo fu ijia oenoekinu e Ijifitiko ije kaniamo fu viene jone ijia fanu kavuane ije gakuma are jone fu asidiake. Ro fube anera fuone fu e kaniaga bu oevo ije kuaga fu are jone ijia aruna ame fari amure jone ije kaniaga bu oeke. ");
INSERT INTO bbb_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Ro vua ije na nijasiana kuariavo ije janika anafa jone ijena maza boeje abena mukoreigia samuafo. ");
INSERT INTO bbb_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Ro maza ije ja va are ije E Ireobo fu miako kiaema ijia ura vakuva janika juaevasia besubesu mazani ije abena ijiege iro Fasova ije ina oemarefo. ");
INSERT INTO bbb_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","27","Ja ijiege renoega anafa jone bu giana kiako, Ja irerefuo ijiege revo kiakuva ni kia, Iro ije no E Ireobo ije aguaevo ijadufuo no ijene ivo. Ijadufuo maeje no uria gamia Ijifiti kariva ijia E Ireobo fu e Ijifitiko ije kaniaga no fu asiduema ijadufuo no ijene oemarena iro Fasova ikinu ije vierafevono kiafo. Areme Mosisi fune e Isureroko ijene ijiege kuariama furinoga e boeje buka urina auge sana Godido baname isoe. ");
INSERT INTO bbb_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Areme e Isureroko boeje bune va vua irere E Ireobo fu Mosisikiro Eroni kuariaema ijiege rena uri mave sife ame bu kaniaeva ijadufuo kavuane ije kena are buone ijadufuo viene ikene gue gue ro ado ijia aziriae. ");
INSERT INTO bbb_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Bu ijiege rema furikoga E Ireobo fune ve ufirema ijia arina e Ijifitiko ijiebuo ame fari amuifari boeje kaniamo bu oe. Fu Kini Ferodo ame fari ijia zinuivena kania vakuma ka e dibure karivo ijiebuo ame ijiakuma kaniamo bu oe. Fu ijiege re areme uri kuke fanuve buone boeje binobino ijiebuo ame amuifari ijiakuma kaniamo bu oe. ");
INSERT INTO bbb_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","E Ireobo fu muge ve ufirema ijia ijiege remoga Kini Ferokina e fuone mamekanu ijiakina e Ijifiko boeje bu ijia sone uri ire ka ma omise ije buone rema ije gae. Ijadufuo e Ijifitiko boeje buka nirae ijadufuo maeje e besubesu ijadufuo are ijia ame amuifari fuone ije fune baronema ijadufuo bu ije nirae. ");
INSERT INTO bbb_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Areme muge besu ijia Kini Fero fu una Mosisikiro Eroni vua nijiana kumeno bu ruae, Bu rovoga fu urina kiae, Nine urina e jone Isureroko ije kaenamiana aesakae none ige arena va izege a kuariema ijiege E Ireobo jone ije baname isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Ro ja vakuva ni mave sifi ro goti ro kau boeje nika kaenamiana vafo. Ro na jade totekiro nika noefuo baname isoega E Ireobo fu na daro mieno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Areme e Ijifitiko ije bu urina e Isureroko ije kiae, No vierafe jaka migegire aesakae ige arena vake. Ro ja naebe vakuva no vierafe e boeje noneka oekono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Bu ijiege kuariavoga e Isureroko boeje bune urina farava ije bu ire isiti ijiakuma ifaejedufuo baki ije karina tinine bu burete ifaejevo ijia rie. Areme bune uri ugone ubine ijia karina tinine buone ije utina kamui buone ijia kedekinu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","E Isureroko ije bune urina izege Mosisi fu kuariaema ijiege rena uri e Ijifitiko ije ire gorodikina siriva ro ugone ni mukore ije inimiana kiavo bu vajiae. ");
INSERT INTO bbb_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Areme E Ireobo fu ve ijia e Ijifitiko ijiebuo oe ije kame kuderiamoga buka urina e Isureroko ije mukoreigia aguariana oemarejiae. Areme bu uri ire boeje bu kiavo ije karina vajiae. Bu vame ijiege reva ijia e Isureroko ije buka urina e Ijifitiko ijiebuo sinuome maeje boeje karina vae. ");
INSERT INTO bbb_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Areme e Isureroko ije bu are Ramisi ijia uri diake zinuevena vakuma are Sukote ijia usiae. Ro e ije vaeva ijia e fari ijiaru ije buka e sigisi aderedi taoseni (600,000) ijiege ro bara ijiakiro ame bu naebe dae. ");
INSERT INTO bbb_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Ro e ka ma uruvana e Isureroko baki ije abero mave-sife ro goti ro kau uruvana bu buina vae. ");
INSERT INTO bbb_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","E Isureroko ire bu idufuo ije bino bu naebe mukoreigia kanafui ijadufuo maeje bu e Ijifitiko ijiebe kuriaerevoga buka migegire usiae. Ijadufuo bume farava ire isiti baki ije bu karina vaeva ije ifaeje ikinu vae. ");
INSERT INTO bbb_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Ro e Isureroko are Ijifiti bu kariva ije bu juaevasia fo aderedi teti (430) ijiege kari. Bu ijia karina vakuma juaevasia ijiege furikoga ubine ijia E Ireobo ijadufuo agane boeje bu ijia Ijifiti arena usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Ro muge besu ije bune usiae vakuvejo ijia E Ireobo ije fuka e Isureroko ije mukoreigia giakinu samuagiana vakuma areme kaenamia Ijifiti arena keke vae. Ijadufuo iviama e Isureroko boeje bu juaevasia besubesu mazani ije ruomo buka muge ijadufuo una bue samuanamikinu E Ireobo ije baname isoevo. ");
INSERT INTO bbb_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Areme E Ireobo fu urina Mosisikiro Eroni kiae, Ja oenoeno Iro Fasova ije ikuva nika akae ige mukoreigia nuvediafo. Ro akae ijeja e ae binoko bu vajae surive buone naebe kania ufuna nuga naeva ije bube Iro Fasova ije idufuo. ");
INSERT INTO bbb_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Ro e bino bu joefuo mani baki imevo ja kaenamia ruaeva ije bu iro ije ikuae vierafekuva ni ude vajae surive buone kania ufuna nuga naejiafo. ");
INSERT INTO bbb_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Ro e bino bu safia ro jaena karinoevo ijiakina e bino ja kega bu joefuo imevo ije bude iro ije ivo. ");
INSERT INTO bbb_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Ro ire boeje ja idufuo ije nika are besu guove ijia karina ina furifo. Ro jade fanu gue karina usiae ae makave ijia inoevo. Ro fanuve ije ja kaniana ire ijadufuo kanafuivo ijiebuo ane bine jade kaniatuavo. ");
INSERT INTO bbb_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","48","Ro e Isureroko boeje bu Isurero guove ijia karivo ije buka iro ije ifo. Ro e ae binoko ijia e fari be fu vierafe fu iro ije ikiro vierafekuma fuka e fari eranebe are fuone ijia karivo ije kaenamiana vajae surive buone ije kania ufuna nuga naejiafo. Ja ijiege rega bu una e Isureroko igege rekina bu iro ije ifo. Ro e fari be erare fu naebe vajae surive fuone kana ufu nuga nijaema ije fude Iro Fasova ije ino. ");
INSERT INTO bbb_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Ijadufuo e ma Isureroko ijiakiro e ae binoko bu jaena karinoevo ije buka akae besu ije nuvena ijia kenoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Areme e Isureroko boeje bune urina vua irere boeje E Ireobo fu Mosisikiro Eroni kuariaema ijia nuvena ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Ro maza ijia E Ireobo fu e Isureroko agane boeje kaenamiana aesakae Ijifiti arena keke ruae. ");
INSERT INTO bbb_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","Areme E Ireobo fune urina Mosisi kuae, Nine ema ro fanuve ijiebuo ame amuifari ije kena noefuo irigi uniafo. Ijadufuo maeje E Isureroko ijiakina fanuve buone ijiebuo ame amuifari ije bu noneno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Ijadufuo Mosisi fu urina e boeje kuariana kiae, Mazani ige fuka ma anuigi ijadufuo maza ije abena ireobo vierafena iro kinu oemarefo. Ijadufuo maeje ja aesakae Ijifiti ijia e ijiebuo mani baki imenoenoga E Ireobo fu daro fuone ka anuigi ijia ja kaenamia keke ruae. Ijadufuo jabe burete ije ire isitikuma ifaejeva ije idufuo. ");
INSERT INTO bbb_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Ro ivia aesakae Ijifiti ja arena usiae vako ije ja asame Abibi ijia ja arena usiae vake. ");
INSERT INTO bbb_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Ijadufuo fu ja kaenamiana va aesakae saruegi e Kenanaetiko ijiakina e Itaetiko ro Amoraetiko ro Ivaetiko ijiakina e Jebusaetiko ijiebuo ijia uniakuva janika juaevasia besubesu asame Abibi (Efurukiro Masi) ijia iro ina mazani ije vierafefo. Ro aesakae ije E Ireobo fu ude abena asaerafa jone ije miakono kuaema ije fu ja kaenamiana una ijia vake. ");
INSERT INTO bbb_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","7","Ijadufuo ja mazani sikisi (6) ijiege ja burete iriaeki ire isiti baki amaeriaeva ijiaru ikinu karina vakuma mazani seveni ije abeno ijia ni E Ireobo ije aguaena iro ina fuone oemarefo. Ro ire bino isiti ijiakuma amaeriaeva ije gue jade karina gire ro are jone ivuake ije ja oenoevo ijia navo. ");
INSERT INTO bbb_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Ro jane va iro ikuvejo ijia nine anafa jone ije mukoreigia kuariana kia, Ire ije na revo ijadufuo maeje na Ijifiti ijia fijoga E Ireobo fu na mesiriena keke ruaema na ijadufuo ije revono kiane. ");
INSERT INTO bbb_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ja maza boeje ijiege rekinu vakuva fu nuga ije ja umui ro variatare jone ijia kiriaeva ijiege reke. Ro fu ijare ifejiaga ja Godido vua ije maza boeje kuaekinu oenoedufuo vierafeke. Ro jade totevo ijadufuo maeje funeka E Ireobo ijare daro fuone ka ma daroki ijia ja kaenamiana aesakae Ijifiti arena keke ruae. ");
INSERT INTO bbb_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ijadufuo ja juaevasia besubesu mazani ije fu ruakuma nika iro ina E Ireobo ijadufuo oemareno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","12","Mosisi fu ijiege kuariama areme kiae, Ja va e Kenanaetiko ijiebuo aesakae ije fu abe asaerafa jone ije miakono kiaema ije abena ijia karikuva ni e ro fanuve ijiebuo ame amuifari ije ka kena una E Ireobo vajafo. Ijadufuo maeje ame amuifari ije buka E Ireobo ijadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Ro ja mave-doniki ame amuifari ije ja una jone kekuae vierafekuva nine mave-sife ame ijia kena una E Ireobo zinone ifaejafo. Ro kuke ja naebe mave-doniki ijadufuo ame una kekuae vierafekuva nime kena kuri subifo. Ro una ame amuifari jone ijeja ni mave-sife ame ijia kena una Godi zinone ifaeja areme nine ame jone una kaenamiafo. ");
INSERT INTO bbb_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Ja ijiege rega ame fari one fu kuako ire ije a irerefuo ijiege remono kuaga ni kua, No aesakae Ijifiti ijia e binobuo mani baki karina ime. Rove E Ireobo ka ma daroki ijare kaenamuona keke ruaema ijadufuo no ijiege revono kuane. ");
INSERT INTO bbb_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","No E Ireobo ijare e Ijifitiko ijiebuo Kini Ferodo vierafe ije dabe gikikimana remoga fu naebe kuomo no usiae ruae. Ijadufuo E Ireobo fu e boeje aesakae Ijifiti ijia kariva ijiakiro fanuve buone ijiebuo ame amuifari ijene kaniae. Fu ijiege rema ijadufuo iviama na ije fanuve ijiebuo ame amuifari ije kena E Ireobo ije zinone ifaejave. Ro na ame amuifari none ije una mesirikiro vierafe ijadufuo na mave-sife ame amuifari ije abena Godi zinone ifaejavono kuane. ");
INSERT INTO bbb_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Ro vame ije na revo ije fu nuga nuvuone no variatare ro umui nuvuone ijia kiriavo igeki. Fu ijare ifejiega na ijia giana vierafero fu E Ireobo ijare daro fuone ka ma daroki ijia no kaenamuomo no aesakae Ijifiti arena usiae ruaemaro no ijiege vierafekono kuane. ");
INSERT INTO bbb_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Ijege rena mazani ije e Ijifitikobuo Kini Fero fu e Isureroko ije aremo bu usiae vaeva ije Godi fu naebe kaenamiana vame ivuake ije bu e Firisitaeniko ijiebuo aesakae ijia urana vako ijane vae. Ijadufuo maeje Godi fu vierafero fu kaenamiana ijane vakuma bu va vame ijia ebe bijaega bu giakuva buka una subinae Ijifiti vakiro fu ijadufuo naebe kaenamiana ijane vae. ");
INSERT INTO bbb_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Ijadufuo fu una kaenamiana ae sao ijia ufuaena una Davare Kavuane nafuema nake vae. Ro mazani ije e Isureroko bu aesakae Ijifiti arena usiae vaeva ije buka izege e bijaevo bu juvuamagu abena bijaekuae vako ijiege rena usiae vae. ");
INSERT INTO bbb_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Ro maza ije Mosisi fu keke vaema ije fu Josofudo vua ije fu kuariaema ijiege rena uri ane fuone ijene karina vae. Ijadufuo maeje Josofu fu ude e Isureroko ije kuariana kia, Ja maza ije Godi fu ja karauniaga ja usiae vakuva ni ane none karina usiae vano kiaema ijadufuo fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Ijiege rena e Isureroko bune are Sakote arena vakuma are Etame ae sao ivuake ijia usiaena kari. ");
INSERT INTO bbb_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Ro e Isureroko bu vako E Ireobo fu maza ije amite rero muge fu miane rena naena ude vakinu sanaejiakoke bu ijia gakinu nuvena vako. Fu ijiege rekina e Isureroko buka muge ro maza ijiakuma vakiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Ijiege rena amite ijiakiro miane ije fu muge ro maza ijia uineke buone ijia namo ije fu aremo baki. ");
INSERT INTO bbb_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Areme E Ireobo fu Mosisi kuae, E Isureroko ije kiaga bu una va are Fi Aerotikiro Migidoro ukua ijia are Bero Zefonikiro Davare Kavuane ije ivuake ijia karino kuae ");
INSERT INTO bbb_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Bu ijia karike kini Fero fu vierafero e Isureroko ije bu ae sao ukua ijia urana totenaminoevoro fu ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Areme na kini Ferodo nigofo dabe gikikimana rejake fu ja kame arafirianoeke. Bu ijiege arafirianoevo ijia na daro none ijia iraraena kini Ferokiro e fuone bijaenoevo ije kanianaga bu oe furike. Na ijiege rega e bu ijia daro none ijiakiro sanaema none ije gia areme una na E Ireobo na aguarieke. Areme e Ijifitiko ije bu ijia sone giena vierafero naeje na ma E Ireoboro bu ijiege vierafeno kuae. Ijadufuo e Isureroko ije bune uri izege E Ireobo fu kuariaema ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Areme e Ijifitiko ijiebuo Kini Fero fu fieke e Isureroko ije bune kame uniakona vaevaga fu fie. Ijadufuo fu uri e fuone mamekanu ijena bue kuae, Noneka isema vierafena uri e Isureroko ije bu nuvuefuo imevo ije kiavoga bu usiae vaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","8","Areme E Ireobo ije fune uri kini Ferodo nigofo ije dabe gikikimana rejamoga fu uri sarioti fuone abe areme uri e fuone bijaevo ije ke afui. Fu ijiege rena uri e mukoreigia bijaevo sigisi aderedi (600) ijiege kiamo bu sarioti buone maeje kari. Areme bune kuke uri sarioti gue ro e mamekanu bu samuagiadufuo ije kaenamiana uri e Isureroko ije kame arafiriana nuvediae. Rove e Isureroko ije bu usiaena vaeva ije buka darokuma oemarekinu vae. ");
INSERT INTO bbb_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Ijadufuo e Ijifitiko ijiebuo e bijaevo ijiakina e ije ose ro sarioti kena oenoejo boeje buka urina e Isureroko ije kame arafiriana vae. Bu arafiriana vakuma are inokiro Fi Aerotikiro Bero Zefoni ro Davare Kavuane e Isureroko ije bu kariva ivuake ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Areme e Isureroko ije bu giake e Ijifitiko ijiebuo kini ijiakina e bijaevo fuone bune bu ivuake ijia ruovoga buka ireobo jumei. Ijadufuo bu ro are E Ireobo fu ifejia ro bu ijadufuo uri fu vijena kumei. ");
INSERT INTO bbb_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bu ijiege vijekinu uri Mosisi kuae, A irerefuo no kaenamuona ae sao igia ruaema noneka oekuae reve? Ni iviama ire irufui gafe fu nuvuone ruomo ije gane. ");
INSERT INTO bbb_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","No uria Ijifiti kariva ijia none kuae, A ni areke noka igia karina e Ijifitiko ijiebuo mani baki imeno kuavo aka faememarei. A kaenamuo ruaema iviama noneka ae sao igia oekuae revono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Bu ijiege kuaravoga Mosisi fu urina kiae, Jade jumekiro nika giriesana irekega E Ireobo fu iviama ja karauniaga ja gake. Ro e Ijifitiko ijiebuo uikubae ja iviama giavo ije rade jabe una bu giake. ");
INSERT INTO bbb_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Jaeje nime ireke fu E Ireobo ijare joefuo bijaega ja gano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","16","Areme E Ireobo fu urina Mosisi kuae, A irerefuo manina oefiane abe na kieme? A ijiege remo ije arekiro e one kiaga bu davare ijia vane. Bu ijia vake ni rade mudu one a bijuanoeno ije abe davare ado ijia farega fu abe atana guegue rega e Isureroko bu ajare iriaeki ijia urana vane. ");
INSERT INTO bbb_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","18","Nare e Ijifitiko ijiebuo nigofo kame gikikimana rejiaga bu rade nuvediana davare ijia vuake. Bu ijia vuaga na daro none ijia kini Ferokiro e bijaevo ijiakiro sarioti fuone ijiakina e ose ke oenoevo ije kame arafiriake. Na ijiege arafiriaga e Ijifitiko bu ijia sone giena vierafero naeje na Godi E Ireobo ijenero bu ive none dabe ajiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Areme Godido anera ijiakiro amite bu ude vako e Isureroko bu nuvediavo ije bune una e Isureroko ijiebuo ijuone ijia nuvediakoga bu vae. ");
INSERT INTO bbb_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ro bu vakuma ro karivone amite ije fu arina e Isureroko ijiakiro e Ijifitiko ijiebuo ukua ijia arina namo. Fu ijia arina muge fu e Ijifitiko bu kariva ije fu tituteko bu ijia karivo. Ro una e Isureroko bu karivo ije fu sanaejiako bu ijia karivo ijadufuo muge bu bue ganamivo baki. ");
INSERT INTO bbb_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","22","Areme Mosisi fune urina umui fuone ije davare ado ijia akoena manikoga majaufi ka daroki ijare are una mazani ajiamo nake ijia ufi. Majaufi ije fu muge boeje ijiege ufikoga davare ije fuka dabe ukua ijia tura guegue faere igege kirana ajiakoga e Isureroko bu ukua ijia ajare iriaeki ijia urana gara vae. ");
INSERT INTO bbb_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Bu ijia urana vakoga e Ijifitiko ijiebuo e bijaevo ijiakina e ose ke oenoevo ijiakina e ije sarioti ke oenoevo bu rade ari ajare ado ijia nuvediana kaniakuae vae. ");
INSERT INTO bbb_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Rove E Ireobo fu ve irasekuveno ijia amite ijiakiro miane ijiebuo uve ijia e Ijifitiko ijiebuo e bijaevo ije izege bu revo ije giana uri vierafe buone kame bijukuriamo buka ijia uri totenami. ");
INSERT INTO bbb_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Fu uri sarioti buone ijiebuo dia ije bijukuriamoga bu vakuvega fuka ma iserei. Ijadufuo e Ijifitiko bu ije gana uri kuae, E Ireobo fuka e Isureroko igia vafaena noena bijaeme ijadufuo roga noka are ige arena vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Areme e Ireobo fu uri Mosisi kuae, Umui one davare ado ijia akoega davare ije fu una nafuena e Ijifitiko ijiakina sarioti buone ije ro e ije ose ke oenoevo ije okuriano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Ijadufuo Mosisi fune urina umui fuone davare ado ijia akoemoga davare ije fune ve irasekuveno ijia una izege fu ude namo ijiege nae. Davare ije fu una nafuemoga e Ijifitiko ije bu ajia subivo fuka iseremoga E Ireobo fu kame davare ijia korei. ");
INSERT INTO bbb_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Areme davare ije fu una nafuena e Ijifitiko ijiebuo sarioti ijiakina e ije ose ke oenoevo ijiakina e bijaevo ije bu e Isureroko ije nuvediana davare ijia vaeva ije boeje fuka okuriae. Fu okuriaemoga e besukua be fu naebe ajia kona vae ro e boeje buka davare ina ijia oe furi. ");
INSERT INTO bbb_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Bu ijiege rekoga e Isureroko buje bu davare ije fu dabe atana guegue faere igege kiraema bu ukua ajare iriaeki ijia urana gara vae. ");
INSERT INTO bbb_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Mazani ijia E Ireobo fu e Isureroko ije e Ijifitiko bu kaniakuae ruaeva ijene ifejiana karauniamoga bu ni buone ijia e Ijifitiko ije bu oena davare irifo ijia naovo ijene giae. ");
INSERT INTO bbb_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Areme ve ijia e Isureroko bu E Ireobo ijadufuo daro ije fu e Ijifitiko ije iraraena kaniaema ijene gae. Bu ije gana jumena una E Ireobo ma vierafe areme una Mosisi e fuefuo imeno ijene ma vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Areme Mosisikiro e Isureroko ije bu urina dua ige E Ireobo ije urukafae. Ro dua ije bu ijiege urui, Na E Ireobo dua urukafake ijadufuo maeje fure daro fuone ka ireobo ijia e Ijifitiko ije iraeraena asidiae. Ro fure e ije ose ke oenoevo ijiakina ose buone ije kame davare ijia korei. ");
INSERT INTO bbb_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","E Ireobo ije fu na daro miena kenujie ijadufuo na fuefuo dua urukafake. Fu ma Godi none ijadufuo na fu dabe aroeke. Ro fuje fu asoe none ijadufuo Godi ijadufuo na daro fuone ka ma ireobo ijadufuo dua urukafake. ");
INSERT INTO bbb_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","E Ireobo fu e azo mukoe kemo ijadufuo ive fuone ijeja fuka ma E Ireobo. ");
INSERT INTO bbb_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Fure Kini Ferodo e azo kevo ijiakina sarioti buone kame davare ijia koremoga e mamekanu fuone maeje buneka Davare Kavuane ijia oe furi. ");
INSERT INTO bbb_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Ro davare manebo ijare okuriamo bu mune igege davare dibuore ijia gama ari. ");
INSERT INTO bbb_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","E Ireobo umui one maeneke ije fuka ma daroki e bu jumedufuo. Ro umui one ijare e ani ije kania kame buvuase koremo. ");
INSERT INTO bbb_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Ro are daro one ka ma daroki ijia e ani one bijukuriana kame korei. Ro defarure one ijare tavuana buje fu nubuane igege nae. ");
INSERT INTO bbb_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Ro a davare ado ijia ufekoga fu dabe atana guegue faere igege kirana ajiae. Ro davare guove ije fuka ma gikikimana mune igege rei. ");
INSERT INTO bbb_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Ro e ani nuvuone ije buka aroekarana kuae, Nore bu kame arafiriana vakuma faradia areme uri sinuome buone maeje boeje kamazia areme ke atana irere no vierafeva ije kekono kuae. Ro kuke bu kuae, Nore sime nuvuone ma uiki ijare kena kaniaga bu oeke. ");
INSERT INTO bbb_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Rove E Ireobo are majaufi igege ufemoga davare ijare e Ijifitiko ije ka okuriamoga bu ire mune ka irufuima igege do ka ma ise ijia ari. ");
INSERT INTO bbb_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","E Ireobo godi ume igeko ije be erare fu a vareki ije fuka baki. Ro fu erare a maturaema ijiege mukoreigia maturaema baki. Ro fu erare ire sumiki ka daroki bino a remo ijiege rekuva baki. ");
INSERT INTO bbb_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","A umui one maeneke ka daroki ije akoemoga sakae igare e ani nuvuone ije kame inuosei. ");
INSERT INTO bbb_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ro aeje aka maza boeje e oetuamo ijadufuo a e ije a karauniaema ije mukoreigia samuagiakinu daro one ijia kaenamia vakuma are akae one ijia uniake. ");
INSERT INTO bbb_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Ro e boeje aesakae binobino ijia karinoeva ijiakiro e Firisitaeniko ije bu vua ije fiekuva buka dejudiana safusiake. ");
INSERT INTO bbb_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Ro e aesakae Idomiko ijiebuo e mamekanu bu ije fiekuva buka dejudiaeke. Ro kuke e Moabiko ijiebuo e daroki ije buka safusiaga bu jumeke. Ro e Kenanaetiko ije bu vua ije fiekuva buka safusiana darobirenamiake. ");
INSERT INTO bbb_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bu daro one ma daroki ije gakuva buka ireobo de judiaga bume mune igege avaebaki ireke. Ro bume mauike jumekinu ire giake e one a karauniaema ije bu usiae asidia vake. ");
INSERT INTO bbb_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ro E Ireobo a kaenamia vakuma are one ije a e Isureroko miakono kuaema ijia uniake. Ro are ije a umui one ijia saeva ije fu are akae ro a koro ijia fine. ");
INSERT INTO bbb_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Ro E Ireobo aeje aka maza boeje kini rena e one samuagiakinu vake. ");
INSERT INTO bbb_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","E Isureroko ije bu arina davare fu sina iriarema ijia urana gara vae. Bu ijiege vakoga E Ireobo ijare e Ijifitiko ijiebuo sarioti ijiakiro ose buone ijiakina e ije ose ke oenoejo ije bu davare ukua ijia ura vako ijene davare kuamoga fu una nafuena okuriae. ");
INSERT INTO bbb_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Ro bara Miriame e Eronido maki fu Godido vua vierafena kuaemo fu urina dideve fuone abena usiakinu vakoga bara boeje bu fu nuvena vae. Bu dideve buone ijiaru kame usiakinu dua uruikoga bara Miriamere buefuo dua ijiege urui. Ro dua ije fu ijiege uru, ");
INSERT INTO bbb_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","E Ireobo ije dua urukafafo. Ijadufuo maeje fure sanaema fuone ro daro fuone ijia E ije bu ose ke oenoejo ijiakiro ose buone ije kame do korei. ");
INSERT INTO bbb_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Areme Mosisi fu urina e Isureroko ije kaenamiana Davare Kavuane ije arena Sua ae sao ijia vae. Bu mu inokubeke do baki ae sao ijia oenoe. ");
INSERT INTO bbb_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Areme bu ruoma are Marano kuavo ijia usiaena do be gae. Rove do ije fuka kugi bu izege ikuva baki ijadufuo are ije bu kua Marano kuae. Ro vua Mara ijadufuo maeje kugi. ");
INSERT INTO bbb_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Ijiege rena e ije buka naebe oemareva ijadufuo bu urina Mosisi fuesina kuae. Bu bue karina kuae, No do ma izia iga fu maduokono kuae? ");
INSERT INTO bbb_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Bu ijiege bue karina kuavoga Mosisi fu uri E Ireobodo baname isoemoga fu ine ao be ijia namo ije nijae. Fu nijaemo Mosisi fu abena do ijia akoemoga do ije fu una mare. Areme E Ireobo fu are ijia akae bino bu ijia giana nuvediakinu karinoedufuo ije nijasia areme fu kuke ijia bu biesiriana giae. ");
INSERT INTO bbb_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Ijadufuo fu kiae, Naeje na E Ireobo ro Godi jone nare ja adame abega na karauniavo. Ijadufuo janika vua ige na kuariavo ije mukoreigia fiena vame maeje na vierafeva ijiaru renoefo. Ro kuke janika akae none boeje mukoreigia iriniana vua irere ja renoedufuo na kuariavo ijene renoefo. Ja ijiege renoekuva nabe adame ise na kena e Ijifitiko ije vajiaeva ijiege una ja vajiana isekafiake. ");
INSERT INTO bbb_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Areme E Isureroko ije bune urina are Irimi ijia vae. Ro are ijia fuka do isesina ijo ma uruvana tuero (12) ijiege bu sakae tire ajiavo. Ro kuke ine aname ije buka uruvana ijia ijadufuo bu ro ijia are sama areme ijia kari. ");
INSERT INTO bbb_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","E Isureroko boeje bune are Irimi arena vakuma Sini ae sao ijia usiae. Ro ae sao ije fu are Irimikiro Uruo Saenae ukua ijia. Ro e Isureroko aesakae Ijifiti bu arena ruaeva ije fune asame be furina una be ijadufuo mazani fifitini (15) ijia bu vakuma Sini ae sao ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","3","Areme e boeje bune urina Mosisikiro Eroni ziegafiana buesina kuae. Bu kuae, No Ijifiti ijia karivo ije noka irekiro fanu uruvana ivo. Ijadufuo E Ireobo fu Ijifiti ijia no kanuo no oe bitie ije fuka mareke. Rove jaka kaenamuona usiae ae sao igia ruaeva e boeje noka vasia abena oekuvejono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Bu ijiege kuaevoga E Ireobo fu urina Mosisi kuae, Ivia na joefuo ire saove gufia kuaga fu ve igege dana arike. Ijadufuo e boeje kiaga bu maza besubesu usiae va ire bu maza besu ijia idufuo ijiaru karifo. Na ijiege rena biesiria giaga bune vua none na kuariaeva ije mukoreigia nuvero bu bakiga na ije giake. ");
INSERT INTO bbb_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Ijadufuo kiaga bu maza sigisi ijia usiaena ire bu maza inokiro ijia idufuo ijiaru karina ro ifaejeno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Areme Mosisikiro Eroni bune urina e Isureroko e boeje kiae, Ivia mufuo igia ja sone ni jone irere remo ijia gana vierafero fune ma E Ireobo ijare are Ijifiti ijia ja kaenamiana keke ruaemaro ja ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ro isuome suoke ja E Ireobo ijadufuo sanaema ije gake ijadufuo maeje jane fuesina kuaevo fune fie. Nono irere rekuva baki ro jame ijia nuvuesina kuaevono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Mosisi fu ijiege kuaria areme kiae, Ja ijiege kuaevo ijadufuo E Ireobo fu ivia mufuo fanuve vajiaga ja ike. Ro isuome suoke ije fu una kuke burete vajiaga ja i fuka de ufiake. Ro izege ja zievo ije ja no ziegafuovo baki ro ja E Ireobo ije ziegafavono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mosisi fu ijiege kuariama areme una Eroni kua, Nine e Isureroko boeje kiaga bu usiaena E Ireobo ijadufuo nidua igia rone. Ijadufuo maeje bune irefuo zievo ije fu fiemano kiane. ");
INSERT INTO bbb_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Areme Eroni fune urina e boeje kuariakoga bune urina nikubae buone bu una kuderiana ae sao nake ijia rerei. Bu ijia irena rerekoga saroruba E Ireobo ijadufuo sanaema ijare amite uve ijia sanae. ");
INSERT INTO bbb_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Areme E Ireobo fune urina Mosisi kuae, Na e Isureroko ije bu karina zievo ije name fie. Ijadufuo ni kia, Ivia mufuo ja fanuve ike ro isuome suoke ije ja burete uruvana iga fuka uruvana de ufiake. Areme ja ijia sone vierafero naeje na Godi E Ireobo jone ijenero ja ijiege vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","14","Areme ve fune mukuveno ijia ume kuero ka ma uruvana ijiebe kena are ije e Isureroko bu kariva ije okuravoga funeka ume ijare irarae. Ro suoke sakae safine fu iriarekoga ire burete igeki ijiebe ae sao ajare ado ijia naovo bu giae. ");
INSERT INTO bbb_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Areme E Isureroko bu ire ije giana vierafero bubite irerero bu una bue kuae, Ire ije irerebe naovono kuae? Bu ijiege kuaevoga Mosisi fu urina e ije kiae, Ire ije ja giavo ije fu E Ireobo ijare ire ja idufuo ije vajiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Ro E Ireobo fu kume, Ni e boeje kiaga bu ire buone bu i fu de ufiadufuo ijiaru karifo. Ro ja karikuva ni e izege ja are besu ijia karivo ije manina karino kumei. ");
INSERT INTO bbb_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Ijadufuo e Isureroko ije bune izege Mosisi fu kuariaema ijiege rena e gue buka ma uruvana karikoga gue bu sibaneke kari. ");
INSERT INTO bbb_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Ro e ije bu uruvana kariva ijiakiro e ije sibaneke kariva ije buefuo fune mani. Ijadufuo e besubesu ire buone bu kariva ije buneka izege bu iga fu de ufiadufuo bu ijiege kari. ");
INSERT INTO bbb_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Areme Mosisi fune urina kiae, Ire ije ja kariva ije jade bino isuofuo suba navono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Rove e gue bu naebe Mosisido vua fu kuariaema ije irinana ijiege rei ro buka gue karina una suba nae. Ijadufuo suoke bu urina gake ire ije bu naeva ije buneka buraena fuzakinu rivo bu giae. Bu ijiege revoga Mosisi fune uri e ije bu ijiege reva ije ziegafiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ijiege rena maza boeje suoke ve irasemo ije e besubesu fune kekena va ire fu maza ijia iga fu manidufuo ijiaru manina karimo. Ro maza fune ajia ruomo ije ire nugune bu uria naeva ije bune maza kaniaga fu firaena bakiremo. ");
INSERT INTO bbb_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Bu ijiege rekinu vakuma ro maza sigisi abeno ije bu ire ma uruvana bu maza inokiro idufuo ijiege manina karivo. Areme e buone mamekanu boeje bu ro Mosisi ire izege bu kariva ijene kuaravo. ");
INSERT INTO bbb_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Bu ijiege kuaravoga Mosisi fu kuariana kia, E Ireobo fu kume, Isuome ije fu E Ireobo ijadufuo maza ka akae ja mauike karidufuo ijene. Ijadufuo nine ire irere ja ivia miane ifaejekinuro sukore kiradufuo ije kirafo. Ro ire nugune ja ifaejeva ije ni karina isuofuo nano kumemano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Areme E Isureroko ije bune izege Mosisi fu kuariaema ijiege rena ire nugune bu karina naeva nituame suoke urina giake bu naebe iserei ro fuzaeva bu giae. ");
INSERT INTO bbb_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","26","Ijadufuo Mosisi fu urina kiae, Ivia ja una makave jone ijia ire burete bino giakuva baki. Ijadufuo ire ije ja naeva boeje nika ivia i furifo. Ijadufuo maeje mazani ige fuka E Ireobo ijadufuo mazani akae ijadufuo jabe ire ifaejedufuo. Ro ja ire kanaufuikuva ije ni mazani sikisi ijia kanaufuikiro una mazani seveni ije nika mauike karino kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Mosisi fu ijiege kuariamoga e Isureroko boeje bune fie. Rove mazani seveni ijia e gue buka faememarena usiae ire kanaufuikuae vae rove buka ire bino naebe giae. ");
INSERT INTO bbb_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Bu ijiege revoga E Ireobo fu urina Mosisi kuae, Ja irerefuo maza boeje vua na kuariavo ije irinievo baki? ");
INSERT INTO bbb_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ro ni igia fiefo mazani ije ja mauike karivo ije E Ireobo nare abena miae. Ijadufuo na vakuma mazani sigisi ije abeno ijia naka ire burete ja mu inokiro iga fu manidufuo ije vajiake. Ijadufuo e besubesu fu mazani seveni ije abeno ije fuka mauike are fuone ijia fikiro fube kekena oenoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mosisi fu ijiege kuariamoga e boeje bu mazani seveni ije bu naebe usiaena imenoe ro bume mauike are buone ijia kari. ");
INSERT INTO bbb_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Areme e Isureroko ije bu urina ire burete igeki ije bu karina iva ije bu abe ive ina menano kuae. Ro ire mena ije fuka isuni abaeki igeki ka isekube ro mariene fuone fuka ire muni safine bu burete ijia azina ivo igeki. ");
INSERT INTO bbb_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Areme Mosisi fu urina kiae, E Ireobo Godi fu kumemado noka ire mena ije bino kena asaerafa nuvuone bu rade urivo ijiebuo naekina bu maza boeje ijia nao vake. No ijiege naekina asaerafa nuvuone bu ire mena ije E Ireobo fu aesakae Ijifiti ijia no kaenamuona ro ae sao ijia vajuomo no iva ije giano kumemano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Ijadufuo Mosisi fune ijiege kuaria areme uri Eroni kuae, Ni ire mena ije irufui fuone inokiro (2 kirogurami) ijiege karina kafusi ijia usiane. Areme ni abena E Ireobo ijadufuo nidua ijia uifari nuvuone ijiebuo nijaga fu ijia navano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Areme Eroni fu urina izege E Ireobo fu Mosisi kuaraema ijiege rena uri ire mena ije abena va mavua akae ijia abiena nijae. ");
INSERT INTO bbb_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Areme e Isureroko ije bu juaevasia foti (40) ijiege bu ae sao ijia oenoekinu ire mena ijiaru ikinu vakuma ae sakae Kenane ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Areme e Isureroko boeje bune izege E Ireobo fu kuariaema ijiege rena bune Sini ae sao ije arena bune are binobino ijia naojana vae. Bu ijiege rena vakuma ae be bu kua Refidimino kuavo ijia usiaena are muvuaka sana ijia kari. Rove are ijia do ije bu idufuo ije fuka baki. ");
INSERT INTO bbb_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Ijadufuo bu urina Mosisi ziegafana kuae, A iviama do ifejuoga no ino kuae. Bu ijiege kuaravoga Mosisi fu kia, Vua ije ja kuaevo ije arefo. Jaeje ja irerefuo maza boeje naena zienamikinu una E Ireobo ije dabe biesirina ire boeje kuakuaruvono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Rove e ije buka urukeigia do duadiaema ijadufuo buka uria faememarena Mosisi ziegafae. Bu ijiege ziegafana kuae, No Ijifiti ijia kariva ije noka irekiro do ije ikinu kari. Ro a irerefuo anafa nuvuone igiakina fanuve nuvuone ro no kaenamuo kekena ae sao do baki igia ruaema noneka oekuae revono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Bu ijiege kuaravoga Mosisi fuka urina E Ireobo baname isoena kuae, E ige bu dofuo na kievo ije na izege reke? Na vierafe na do naebe ifejiakuva buka mune tuana kaniekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Areme E Ireobo fu una Mosisi kuae, Ni urina e Isureroko ijiebuo e mamekanu ije bino kaenamiana aena ude vane. Ro a vakuma ni mudu one a abena do Naero kanaema ije abena vane. ");
INSERT INTO bbb_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Ro naeje na munuage Orebi manino ijia arina manike. Ijadufuo ni mudu one ije abe munuage ijadufuo kave ijia bijaga do fu abiesega e bu ino kuae. Areme Mosisi fune urina e Isureroko ijiebuo e mamekanu nidua buone ijia uri izege E Ireobo fu kuaraema ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Areme Mosisi fune urina are ije abe ive ina kua, Meribakiro Masano kuae. Ijadufuo maeje e Isureroko ijiebe are ijia E Ireobo ije biesirigakuae kuae, E Ireobo fu bite noena igia oenoeno ke fu bakino kuaeva ijadufuo fu abe ijiege ina kuae. ");
INSERT INTO bbb_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Areme e Amarakaetiko ije bune e Isureroko ije kaniakuae are Refidimi ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Bu ijia rovoga Mosisi fu urina Josua kuae, Nine e nuvuone gue kaenamiana va e Amarakaetiko ijena bijaene. Ro isuome naeje na Godido mudu ije abena umui none ijia farena uruo makave ijia manikono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Fu ije kuaramoga Josua fune urina izege Mosisi fu kuaraema ijiege rena uri e Amarakaetiko ijena bijaekuae vae. Bune vakoga Mosisi fu urina Eronikiro e Eri kaenamiana uruo ije fu kuaema makave ijia ajiana vae. ");
INSERT INTO bbb_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Ro maza ije Mosisi fu umui fuone kave ijia ajiamo ije buka e Isureroko ijiebe iraraena e Amarakaetiko ije kaniavo. Ro fu umui masaega fu una irasamo ije buka e Amarakaetiko ijiebe iraraena e Isureroko ije kaniavo. ");
INSERT INTO bbb_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mosisi fu ijiege rekinu vakuma funeka umui masaemoga Eronikiro Eri bune uri mune abena ijia nijavo fu ado ijia ari fi. Fu ijia ari fikoga bu farane fuone guegue ije faradiana kave ijia avae baki irereko vakuma maza ijia koe. ");
INSERT INTO bbb_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Bu ijiege faradiana irekoga ijadufuo Josua fu e Amarakaetiko ijena bijaena vakuma areme fure iraraena kaniae. ");
INSERT INTO bbb_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Areme E Ireobo fune urina Mosisi kuae, Ni irere fu ivia rema ijene abena buki one ijia isoene. Ijadufuo maeje ire ije fuka ire ireobo be ijadufuo e buka maza boeje fiena vierafedufuo. Ro kuke Josua fudua fuka vua ije fiena vierafedufuo. Ijadufuo maeje na e Amarakaetiko ijiebuo vua ije bu dabe ume igia kuaekinu vierafenoedufuo ije naneka mukoreigia masi korega fuka furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","16","Ijadufuo Mosisi fune urina fata be zinone ifaejedufuo ije sama areme abe ive ina kuae, E Ireobo fuka baname nuvuone fiena daro fuone ije nijasuomano kuae. Ijadufuo maeje umui none na kame saove ije E Ireobo ijadufuo fata maeje fu fino ijia korei. Ro E Ireobo fu maza boeje e Amarakaetiko ijiebuo uifari ije bu rade urivo ijena bijaekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Ro Jetiro e Midianaetiko ijiebuo e zinone ifaejemo ije fu Mosisido jure. Ro fu fieke Mosisi fu e Isureroko ije kaenamiana are Ijifiti arena keke vakoga Godi fuka bu ifejiakinu samuagiana ire binobino buone rema fu ijene fie. ");
INSERT INTO bbb_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Ro Mosisi fu ude bara fuone Ziforakiro anafa fuone inokiro e Gesomikiro Erieza kaenamiana Jetiro uniaejamo vako fu samuagiaejae. Ro ive Gesomi ijadufuo maeje ijeja, Naeje na e ae beko igege sakae igia oenoevo. ");
INSERT INTO bbb_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ro ive Erieza ijadufuo maeje ijeja, Asoe none ijadufuo Godi ijare e Ijifitiko ijiebuo kini ije fu na kaniedufuo ijia ifejiena kenujie. ");
INSERT INTO bbb_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","E Jetiro fune Mosisido bara ijiakina anafa fuone ije kaenamiana ae sao ijia urana vakuma Godido uruo akae ijadufuo zinume ije Mosisi fu fino ijia kekei. ");
INSERT INTO bbb_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Ro ude fune Mosisi vua nijana kumei, Na agebara one ijena a gake vuakono kumeno fu fiekoga bu rade vae. ");
INSERT INTO bbb_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ijadufuo Mosisi fune vua ije fiena keke vame gafia biekiro vae. Fune va vame gafia jure fuone ije biena uri auge sana kurituakafana abe uimi areme bune una Mosisido are muvuaka ijia vae. ");
INSERT INTO bbb_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Bune va ijia usiaena karikoga Mosisi fune uri vua boeje izege E Ireobo fu e Ijifitiko ijiakina kini buone ijiebuo remoga bu ijadufuo uri e Isureroko ije kiavo bu usiae vaeva ijene jure fuone Jetiro kuarae. Areme fune kuke uri irufui binobino e Isureroko bu vame ijia biediakinu vakoga E Ireobo fu izege ifejiaema ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","10","Mosisi fu vua ije kuaramoga Jetiro fu fiena fuka ireobo oemarei. Ijadufuo fu urina kuae, E Ireobo ije fuka magoe e Ijifitiko ijiakiro kini buone ijiebuo uve ijia ja karauniae. ");
INSERT INTO bbb_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ijadufuo iviama na vierafega E Ireobo ije fuka ma e anuigi ijadufuo fure godi kufui binobino ije ma mukoreigia asidiae. Ijadufuo maeje fu vame ijieki ijia e Ijifitiko ije bu aroekarana e Isureroko ije kame vame ise ijia isekafiavo ije ifejiamano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Jetiro fu izege kuaena uri fanuve foteke be abena Godido zinone ifaeje areme uri zinone binoduaku ifaejei. Fu ijiege renoenoga Eronikiro e Isureroko ijiebuo e mamekanu boeje bu ro fuina Godido nidua ijia ire burete ijene i. ");
INSERT INTO bbb_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Areme nituame suoke Mosisi fu urina irufui binobino e ijiebe abevo ije ifejiana amaeriakinu ijiege renoeko fune vakuma ve mui. ");
INSERT INTO bbb_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Fu ijiege renoekoga Jetiro fu fina ire boeje Mosisi fu renoeno ije gaga urina kuae, A i ije a meno ije a irere menoene? A suoke urina e ijiebuo irufui ijene dasumiako e bu a dabe utikurako fune ve mukiro vake. Vame ije a ijiege remo ije na gaga fuka naebe maremano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Fu ijiege kuaramoga Mosisi fu kuae, Na ijiege revo ijadufuo maeje e uruvana bu none ruovo ijia bu Godido vame maeje fu vierafema ije giana vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Ijadufuo e bu irufui bino biediana naebe oemarekinu karinoevo ije bu none ruoga nare irufui buone kena giavo. Na giaga erare fu ma re ro erare fu isema rema na ije samadukua fura kuariakinu ro Godido akae ije nijasiavono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","18","Mosisi fu ijiege kuaramoga Jetiro fu una kuae, Vame ije a remo ije fuka ma baki ijadufuo maeje a osukua fina ijiege rekuma fuka aemake. Ro kuke e ije bu one ruovo ije budua buka aemiadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ijadufuo na vierafe na vame ma be nijasaga a ijiege renoeke Godi fu ifejake. Ro a ijiege rena are e one ijiebuo akaegue ijia irufui buone kena una Godi kuarake. ");
INSERT INTO bbb_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ijadufuo ni are Godido akae ije nijasiakinuro vame maeje izege bu karikinu ro kenoedufuo ije kuariana nijasiane. ");
INSERT INTO bbb_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Ro kuke be ije ni e bino kega bu e mamekanu rekina bure e ma uruvana taoseni (1000) ijiege ro e aderedi (100) ro fifiti (50) ro teni (10) ijiege samuagiane. Ro e a kekuma ni e ije bu Godi jumekinu vame maeje ijiaru renoejo ijia kene. Ro kuke e buka bu ma vierafevo ro bu e biesiriavo baki ijene kene. ");
INSERT INTO bbb_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Areme ni kiaga bure e guebuo ise ije kena giane. Bu giaga irufui gue buka mamekanukuma bu kena una one rone. Ro bu isesinakuva bure ke giana asuseke. Bu ijiege rekina bu irufui ije a osukua abeno ije bino ifejana dasumaga a naeki rene. ");
INSERT INTO bbb_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ro a vua ige izege Godi fu kuaramo ijiege renoekuma a manido a e boeje ijiebuo irufui ije kuae irasega bu una oemarekinu are vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","25","Areme Mosisi fune Jetirodo vua ije fu kuaraema ijiege rena uri e Isureroko e fari bino bu i ije mukoe medufuo ijene kei. Areme fune kiamo bu e ijiebuo e mamekanu rena e ka uruvana taoseni ro aderedi ro fifiti ro teni ijiege samuagiae. ");
INSERT INTO bbb_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","E ijiebe i buone ije maza boeje ijiege mekinu e aeko ijiebuo irufui isesina ije ke giakinu asusei. Bu ijiege rekinu ro irufui mamekanu ije e aeko bu ke ruovo ije bu karina una Mosisido vaga fure giakinu amaeriamo. ");
INSERT INTO bbb_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Jetiro fune ijiege rena vua maeje bino Mosisi kuarana nijaema areme fune una vakuvenoga Mosisi fu urina anaema aremo fune una ae sakae fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Ro e Isureroko bu are Ijifiti arena ro are Refidimi ijia karinoena asame inokiro furikoga una asame be ijadufuo maza amure ijia bune urina ruoma Saenae ae sao ijia usiae. Areme bune uruo Saenae manino zinume ijia are muvuaka sama areme ijia kari. ");
INSERT INTO bbb_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Bu ijia karikoga Mosisi fune uruo ijia ajiana Godi biekiro vae. Fu vakoga E Ireobo fu uruo ijia Mosisi kumeno fu fiekoga fu E Isureroko ijiebuo vua igene kuarae. ");
INSERT INTO bbb_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","Fu kuae, Va e Isureroko ije kiae, Ja vame izege na E Ireobo nare e Ijifitiko ijiebuo reva ije jane gie. Ro kuke jaeje na ume biname ije fu ame fuone ije abe adave fuone ijia nijana vako ijiege na ja kaenamiana ige na fivo igia ruaeva ije jane gie. ");
INSERT INTO bbb_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","6","Ijadufuo ivia ja na iriniena akae none iriniakuva ja ma e none reke. Ja e boege bu aesakae igia oenoeva ijiebuo uve ijia jaeje jaka ma e none nare keva ijene. Ro ire boeje ae sakae igia naovo ije buka none ijiaru ijadufuo jaka e akae rena e zinone ifaejevo igege noefuo imeke. Ijadufuo ni una va e Isureroko ije ijiege kuariano kumei. ");
INSERT INTO bbb_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","E Ireobo fu ijiege kuaramoga Mosisi fune una ari va gamia kekena e Isureroko ijiebuo e mamekanu ije kumeno bu besu afui. Bu afuivoga fu urina vua boeje E Ireobo fu kuaraema ijene e boeje kuariae. ");
INSERT INTO bbb_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","E boeje bu vua ijene fiema areme urina besu afuina kuae, No vierafe ire boeje E Ireobo fu kuaraema ije no rekono kuae. Bu ijiege kuaravoga Mosisi fune una va vua ijene E Ireobo kuarae. ");
INSERT INTO bbb_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Ro E Ireobo fu una Mosisi kuae, Na a fino ijia vuakuva na amite ireobo rena ijia vua osiki vua kuaega e ije bu itire none ije fieke. Areme bu ijia sone una gafege a ma vierafekono kuae. Areme Mosisi fune uri E Isureroko ijiebuo vua ije bu una gue kuaeva ijene E Ireobo kuarae. ");
INSERT INTO bbb_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","11","Fu ijiege kuaramoga E Ireobo fu una Mosisi kuae, Ni una va e game kiaga bu iviakina isuome bu buone amaerenamikinu kanafuikina bu na baname isoena kafiafiriedufuo. Ro kiaga e boeje buka sinuome buone sona samuaekina nituame na Uruo Saenae ijia ari vuaga bu gieke. ");
INSERT INTO bbb_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Ro igia fie, ni uruo ije manino zinume ijia ine buvuana bijia ufuaenoena areme e ije kuriaerega bube ine ije asina ura uruo ivuake ijia vane. Ro e be erare fu dia fuone ijia ine ije asina ura vakuma e ije nika kanaga fu baronene. ");
INSERT INTO bbb_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Ro ja fu kanakuva ni mune tuana kana ro ba juvuave ijia bijaga fu baronekiro jade fu niriaevo. Ro ja ema ijiaru ijiege rekuva bakiro ni kuke fanuve ije duaku besu ijiege refo. Ja samuaga bu gibi ufekuva ijare e boeje ni uruo zinume ijia ajia vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","E Ireobo fu vua ijiege Mosisi kuarama furinoga fu una arina ruoma e Isureroko gume kariva ijia kekei. Areme fune uri kiae, Urina kanafui samuaekina no Godi baname isoena kafiafirino kiae. Mosisi fu ijiege kuariamoga bune urina sinuome buone sona amaeri. Fu ijiege kuaria areme kiae, E boeje nituage janika jone mukoe samuanamikiro maza aoke ijia jade barubara oenoejono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Areme nituame ve iraseko ijia fuka saove kumena vebu irakoga ijia amite ka ma ireobo ijare arina uruo ije utikurakoga gibi ma ireobo ijare ijia ufenoga bu fie. Uruo ije fu ijiege remoga e boeje are muvuaka ijia kariva ije buka ma ireobo oeseradiana de judiae. ");
INSERT INTO bbb_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Areme Mosisi fune urina e boeje kaenamiana Godi biekuae vakuma uruo zinume ijia usiaena ire ufuaenoena areme ijia irei. ");
INSERT INTO bbb_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Ro Uruo Saenae foteke fuka miane u ijare utikurae ijadufuo maeje E Ireobo ijare miane rena ijia ari ruae. Ro miane u ije fu una ajiaema ije fuka miane ma ijare ijia naena ajiakoga uruo ije fuka dabe ma urukeigia uvei. ");
INSERT INTO bbb_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Ijiege rena gibi ije fuka ma ireobo kumena vakoga Mosisi fu ijia Godi vua kuaramoga fu saove ijie una ve gue kuarae. ");
INSERT INTO bbb_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","21","Areme E Ireobo fune Uruo Saenae kubi ijia arina Mosisi kumeno fu uruo ijia ajiana vae. Fu ijia ajia vakoga Godi fu kuae, Una arina va e game kiaga bube ine ije a bijia ufuaenoema ije asina na giekuae ruovo. Ro bu faememare ine ije asidia ruakuva buka oeke. ");
INSERT INTO bbb_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Ro kuke e zinone ifaejevo ije budua bu na ivuake igia ruakuva buka mukoreigia kanaufui amaerima areme ruake. Ro bu bakuva naka budua kame isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","E Ireobo fu ijiege Mosisi kuaramoga Mosisi fu una kuae, E gume bube igia ajia ruadufuo. Ijadufuo maeje ane koro kuriaerena kuo janika uruo ige abena uruo akae igege vierafena jade ine ja ufu bijaeva ije asina iga ruovono kue. ");
INSERT INTO bbb_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Rove E Ireobo fu urina Mosisi kuae, Ni una ari va Eroni mesirina una osiki ajia rone. Ro e zinone ifaejevo ijiakina e boeje bube ine ja ufu bijaeva ije asina ura iga none ruovo. Ro bu uria faememarena ine ije asina ura ruakuva naka kame isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Areme Mosisi fune una ari va gamia kekena e boeje vua irere E Ireobo fu kuaraema ijene kuariae. ");
INSERT INTO bbb_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","2","Areme Mosisi fune e Isureroko boeje kumeno bu una besu afuivoga fu kiae, Godido vua akae ka mamekanu fu kuaema ije ijiege. E Ireobo naeje naka Godi jone. Ijadufuo maeje ja gamia e Ijifitiko ijiebuo mani baki imenoejoga nare ja kaenamiana keke ruae. ");
INSERT INTO bbb_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Ijadufuo jade godi binobino ijiebuo baname isoekiro nineka na nosukua none baname isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ro jade uri ire bino saove gufia ro ume igia ro kuke do guove ro sakae guove ijia naovo ijiebuo uikubae ije amaeriavo. ");
INSERT INTO bbb_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","6","Ro jade uri ire ja amaeriaeva ijiakiro godi binobino ije kuri tuakafiakinu buone baname isoevo. Ijadufuo maeje naeje na Godi E Ireobo jone ijene. Ijadufuo jade godi kufui ijene aroriakiro nime ive none ijiaru abe aroriefo. Ro eranebe bu na ijuonena ise renoevo ije nare kame isekafiake. Ro kuke na uifari buone bu rade urivo ije kame isekafiadufuo. Na e uifari ma uruvana ijiege bu rade urivo ije bu na oetuakinu ro akae none iriniakuva naka maza boeje bu oetuakinu vake. ");
INSERT INTO bbb_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Ro jade vame ise ijia ive none ije kurienoejo. Ijadufuo maeje naeje naka E Ireobo Godi jone ijene. Ijadufuo eranebe ive none abe isema kurienoekuva naka kame isekafiake. ");
INSERT INTO bbb_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Ro mazani seveni ije ja mauike karivo ijene ijadufuo nika abe akae rena mukoreigia samuafo. ");
INSERT INTO bbb_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","10","Ijadufuo ma eje mazani sigisi ije ja ijia imekinu ro ire binobino renoedufuo. Ro mazani seveni ije fu mazani none ijadufuo nika mazani ije abena mauike karifo. Ro mazani ije irasekuma e besukua be fube i besukua be meke. Ro ja anafa jone ijiakina e jone mani baki imenoevo ijiakina fanuve jone ja samuagiavo ije ro e ae binoko bu jaena aesakae jone ijia karivo ije besukua be fube mazani ijia imenoeke. ");
INSERT INTO bbb_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ijadufuo maeje na aesakae igiakiro saove gufe ro davare gamiakiro ire boeje guove ijia naovo ije E Ireobo nare mazani sigisi ijia fina amaeriae. Ro mazani seveni ije na mauike finoe. Ijadufuo mazani ije E Ireobo nare abe daro mavo fune akae rei. ");
INSERT INTO bbb_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Ro ame ije ni asoerafa ijiakiro asierafa jone ije mukoreigia aguariafo. Ja ijiege rekuva ja aesakae ije na miavo ijia maza jiamadogo ijia kari vake. ");
INSERT INTO bbb_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Ro jade oenoene e bino kaniaga bu oevo. ");
INSERT INTO bbb_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Ro kuke jade oenoene e binobuo bara turavo. ");
INSERT INTO bbb_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Ro jade oenoeno ebuo ire binobino iniemevo. ");
INSERT INTO bbb_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ro jade oenoeno e bino vua kufui ijia kuaena kame bu namiavo. ");
INSERT INTO bbb_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Ro jade e guebuo are ro bara buone ro e buone mani baki imevo ije giana rieziavo. Ro kuke jade mave-kau ro doniki ro ire buone bino ije giana rieziavono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Mosisi fune akae boeje kuariana nijasiama furiko. Ro maza ije e boeje bu nafare kubi ijia saove kumekoga saove irakoga miane ijia naena umo bu ije gavo buka ireobo judiamo bu mumabo gamia irena ire ijene remo ije gae. ");
INSERT INTO bbb_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","E Isureroko ije buka de judiamoga bu urina Mosisi kuae, Iviama vua ije ni are una no kuaruoga no fiene. No Godi fu korufuo no kuaruomo ije noka de juduome. Ijadufuo maeje fu korufuo no kuaruokuma noka oekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Bu ijiege kuaravoga Mosisi fu una kiae, Ja ire ige remo ije jade gana jumevo Godi fume ja biesiriaga ja daro fuone gana jumena fu irinaekina jabe una vame ise bino rekono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Areme e ije buka jumeva ijadufuo bu mumabo gamia irekoga Mosisire amite ije titute namo ijia urana Godi ivuake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Areme E Ireobo fune urina Mosisi kuae, Una va e Isureroko ije vua ige kuariane. Va kia, Na E Ireobo nane ma saove gufia ja vua kuariavoga jane irena adatire jone ijia kena fie. ");
INSERT INTO bbb_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Ijadufuo jade oenoene ire siriva ro gorodi ije karina godi kufui bino amaeriana buone baname isoekinu ro una na baname isoevo. ");
INSERT INTO bbb_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Ro ja fata none ije amaerikuva nine makoe ijia kena amaerifo. Ro fanuve ije ja kena foteke na zinone ifaejiedufuo ijeja mave-sife ro mave-kau ro mave-goti ijiaru kena zinone ifaejekinu none baname isoefo. Ro zinone ije ja ifaejekuva ije nineka va are ije nare kiavo ijia ifaejekinu none baname isoena kafiafirievodufuo. Ja are ijia ifaeje na ijia ari ro ja daro miake. ");
INSERT INTO bbb_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ro ja mune ijia karina noefuo fata ije amaerikuva jade karina kania tuasena amaerivo. Ro ja ijiege rekuva fata ije fuka naebe maturaedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Ro kuke ja fata none ije amaerikuva jade siaeje oejo. Ja ijiege rekuva ja kave ijia ajiakuva e be umeke irena vajae jone sauiki ije giake. ");
INSERT INTO bbb_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","2","Areme E Ireobo fu Mosisi kua, E Isureroko ije akae ige nijasiane. Ja nijasiana kia, Ja e Iburuko moni baki imedufuo be fuaevekuva e ije fu juaevasia sigisi (6) ijiege joefuo imeke. Ro juaevasia seveni (7) ije abeno ije ni kenujaga fu vafo. Ro jade kuaga fu mani bino una ja fuaeveno. ");
INSERT INTO bbb_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ro e ije fu mumokana ijare ro joefuo imenoeno ja kenujaga fu vakuma fude bara be abe vako. Ro fune e baraki ijare ro joefuo imenoena una vakuma e ijare fu bara fuone mesirina vake. ");
INSERT INTO bbb_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ro e ije fu romoga e ireobo fuone fu bara abe mamo fu abena ame fari ro kabae bino nafei. Ro rade e ireobo fuone fu e ije kenuja fu vakuma bara ijiakiro ame fuone ije bu e ireobo ijare fuone kegaro baru ijiaru arega fu vake. ");
INSERT INTO bbb_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","6","Ro e ije fu samadukua kuae fu e ireobo fuone ro age bara fuone ije ireobo oetuamono kuae. Rove fu uria kaenamia vakiro vierafekuma e ireobo fuone fu mesiri are bu koto fievo ijia vake. Fu mesiri va e boeje ijiebuo nidua ijia adane fuone dabe tugie zinume ijia umakazina tire bietejaga fu ijare maza boeje e ireobo ijadufuo imenoeke. ");
INSERT INTO bbb_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Ro e be fu kabae fuone abe e guebuo fuaevega fu moni baki imenoe bara ije jade izege ja e fari ije karauniaga bu vako ijiege kenujaga fu vako. ");
INSERT INTO bbb_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Ro bara ije fu e befuo imenoga fu bara ije abei. Ro rade fu naebe oemarema ijadufuo fu bara ije abena una e guebuo fuaevekiro vierafekuma fuka abena una asoe fuone ijadufuo fuaeveke. Ro fube bara ije abena una e aebinoko ijiebuo fuaeveke ijadufuo maeje fune vua izege fu bara ije mukoe samuako kuaena abe marema ijene abe tuasei. ");
INSERT INTO bbb_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Ro e be fu bara abe fari fuone maga fu fuefuo imekiro vierafekuma fuka abe kabae fuone igege samuakinu ifejake. ");
INSERT INTO bbb_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Ro e ije fu una bara be abekuma fuka bara fuone uigo ije ka uria abe bara fuone igege oetuakinu ire ro sinuome vajakinu samuake. ");
INSERT INTO bbb_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ro e ije fu naebe vame ijene rekuma fuka bara fuone uigo ije abuega fu vakiro bara ije fude una mani bino baru fuone vajamo. ");
INSERT INTO bbb_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","13","Ro e be erare e be kanaga fu baronemo e ije nika ve kanaga fudua fu baronefo. Ro fu e ije fu naebe kanakiro ijiege vierafe ro fume ijia kanamo fu baronema e ije fuka kona va are nare miavo ijia finoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Ro e be fuka defaruimo fu urina e be kanamo fu baronega fu kona fata bu zinone ifaejevo ijia fue kenujanamikiro vakuma e ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Ro erare fu asoe ro asie fuone kanakuma e ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Ro erare e fari be mauike nuriete mesirina abe va ebuo fuaeve ro baga fu kua fu fuefuo mani baki imenoeno ja gakuva e ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Ro erare fu asoe ro asie fuone ije buesina kuaena kuravajiakuva e ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","19","Ro ja oenoene e bino bu bue madinamivo ijia e be fu mune ro umuike kai fuone be kanamo fu naebe barone ro fume visi nama naekinega fu uri mudu abena oenoekuma e ije fu fu kanaema ije fuka e gue kiaga bu ifejakinu samuake fu fi vakuma maefo. Fu maekuma kai fuone fuka mazani fuone fu arafirijaema ijadufuo subijake. ");
INSERT INTO bbb_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Ro e be erare fu e bara ro baru be fu fuefuo mani baki imenoeno ije ine abena kanamo fu ve ijia baronekuma e ije nika mesirina abe isekafafo. ");
INSERT INTO bbb_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Ro e ije fu naebe migegire barone rove fu mu besu ro inokiro fi vakuma rade baronekuma e ireobo fuone jade abena isekafavo. Ijadufuo maeje e ije fuefuo imenoeno ije fune barone ijadufuo fu erare e ireobo ije ifejakuma baki. ");
INSERT INTO bbb_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Ro e fari bino bu oenoene bue bijaevo ijia bu bara e fudiema be kanavoga fume saroruba ame nafeno fune baronei. Ro bara ije fu matane be naebe abekuma e ije bara kanaema ije fuka mani izege baru fuone fu vierafena kuamoga e koto fiemo fu abe marema ijiege fuaevedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","25","Ro bara ije fune kanamo fu baronekuma ni e ije fudua kanaga fu baronefo. Ro fu kanana umuikiro dia fuone tuase ro niome nafe ro ubae damui ro kanana miane ifaejekuma ni vame besu izege fu bara ijadufuo rema ni ve una ijiege fuone refo. ");
INSERT INTO bbb_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","27","Ro e be erare bara ro baru be fu fuefuo mani baki imeno ije kanana ni nafe ro ubae damukuma e ireobo fuone ije fuka e ije kenujaga fu vake. Fu ijiege kenujaga fu vaekina e ireobo ije fube una niome ro ubae fuone ijadufuo fuaeveke. ");
INSERT INTO bbb_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Ro ja mave-kau kumate be fu muane fuone ijia e be bijamo fu baronekuma mave-kau ije nika mune tuana kanaga fu baronefo. Ro jade abe buvuana ikiro kuke e mave-kau koeki ije jade abena isekafavo. ");
INSERT INTO bbb_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Ro mave-kau ije fu uria oenoekinu e kaniako bu e koeki ije kuara rove fu naebe abena faere kirana ijia nujae. Ro fu areko fume ijia oenoeno e be utaro muane fuone ijia bija fu baronekuma mave ije nika mune tuana kanaga fu baronefo. Ro kuke e mave koeki ijedua nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Ro baga bu e mave-kau koeki ije kuako moni fuaeveno kuakuva fu moni izege bu kuaeva ijene foteke fuaevedufuo. Fu ijiege rekina fu fue kenujanamidufuo. ");
INSERT INTO bbb_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Ro kuke ja mave-kau kumate bino bu oenoeno ame kabae ro fari be kanaga fu baronekuma ni akae besu ije nuvena ijiege refo. ");
INSERT INTO bbb_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Ro mave-kau kumate ije fu oenoene e bara ro baru moni baki imevo ije be kana fu baronekuma e mave koeki ije fuka una e koeki fuone ije moni siriva teti (30) ijiege fuaevedufuo. Ro mave-kau ije nika mune tuana kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","34","Ro e be fu oenoene mako runa naebe bijukurae ro kuke fune bijui rove fu ke akoemoga mave-kau kumate ro doniki be fu va ijia urakuma e ije fuka fanuve ijadufuo una ve e koeki ije fuaeke. Areme fu fanuve ije baronema ije fuone abedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Ro ja mave-kau kumate be fu una e befuo ije kana fu baronekuma e inokiro ije buka urina mave-kau be ije uria manino ije abe fuaevena mani abe buone ata ivajuonamidufuo. Bu ijiege re areme kuke mave-kau ije baronema ijene abe buvuana buone ivajuonamike. ");
INSERT INTO bbb_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Ro ja vierafega mave-kau kumate ije fune maza boeje ijiege manina e kaniakinu ire binobino arafiria rove e koeki ije fu naebe abe faere kirana nujakuma e ije fuka mave-kau fuone uria manino ijia abe una kai fuone ije make. Areme fu mave-kau ije baronema ije fuone abeke. ");
INSERT INTO bbb_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","Ro e be erare mave-kau ro mave-sifi be iniemena abe kanae ro abe fuaevekuma e ije fuka mave-kau fuone ijia umui fague kena una mave-kau besu ije fu iniemema ijadufuo e koeki ije vajake. Ro fu mave-sife besu iniemekuma fu una mave-sife fuone ijia inokiro kiro inokiro kena mave ije fu iniemema ijadufuo e koeki ije vajake. E ije fuka irere fu iniemema ijadufuo ijene una fuaevedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","3","Ro e iniemeno fu are be mugu faraena iniemekuveno bu kanavo fu baronekuma e ije erare fu kanaema ije fu isema rema baki. Ro fume maza ijia oenoeno ijiege e inieki ije kana fu baronekuma ijare fu ma isema rena renoemo. E ije erare ire ije iniemekuma fuka ijadufuo ve una ire ijadufuo fuaeveke. Ro fu sinuome bino bakuma fuje bu abe una e guebue fuaevena moni abe una irere fu iniemema ije fuaeveke. Ro fuje fu una buefuo mani baki imenoeke. ");
INSERT INTO bbb_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Ro fu mave-kau ro doniki fu iniemema ije bu uria are fuone fu fanu samuagiamo ijia irevo bu giakuva fuka mave fuone ijia inokiro kena una ijadufuo ve fuaeveke. ");
INSERT INTO bbb_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Ro e be erare fanu fuone kaenamiana vaeni juare ro garasiki ije oenoeko bu garasi inoeno ijia bu urana va e befuo juare ijia ire fu oema ije ikuva e mave koeki ije fuka juare fuone ijia ire gue karina una ve e ijene vajadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Ro e be erare juare fuone ijia oenoene fiene kara ifaejemoga fu naena e befuo juare ijia kumune fu korema ije ro baga fu ufu naema ije naekuma e ije fuka ire ije naena arafiriaema ijadufuo una e juare koeki ije ve fuaevedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Ro e be fu moni ro ire anuigi fuone bino kena una e be vajamo fu oemarekinu fuefuo samuagiaejamoga fune e bese ro iniemei. Ro rade bu e inieki ije biekuva e ije iniemema ije fuka ire izege fu iniemema ijiege kena una e koeki ije vajake. Fu ijiege vaja areme una kuke sinuome fuone ijia izege fu iniemema besu ijiege karina ijiakuma vajadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Ro e inieki ije ja naebe biekuva e ije erare sinuome ije samuagiaema ije nika mesirina are bu koto revo ijia vafo. Fu ijia va samadukua furana kiako e be ijadufuo sinuome fu naebe iniememano kiadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Ro e be fu oenoene una e befuo juare ro are ijia mave-kau ro doniki ro sife ro sinuome ro ire bino fuone ijia naovo ije giana una ijadufuo vafaena bue madinanamikuva e inokiro ije nika kaenamia are bu koto revo ijia vadufuo. Ja kaenamiana ijia vaga e koto fievo bu e inokiro ijia erare isema rema ijene abe samadirega e ije fu una e be ijadufuo irere fu kema ijene una ve fuaeveke. Fu ijiege vaja areme una kuke sinuome fuone ijia izege fu iniemema besu ijiege karina ijiakuma vajadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","11","Ro e be erare fu oemarekinu e befuo mave-doniki ro sife ro mave gue ije samuagiakiro vierafena ke samuagiae. Ro fu samuagiamo ijia bu matane abe ro oe ro e bese inimieno fu naebe gae. Ijadufuo e koeki fu ije fiega fu naebe oemarekuma e inokiro buka sosi ijia vadufuo. Bu va sosi ijia Godido nidua ijia e ije sinuome samuagiamo ije fuka samadukua furana kuako fu e ijadufuo sinuome fu naebe iniememano kuaga e mave koeki fu fieke. Fu fiega sinuome fuone fu naebe iniemejoga fube una e ije kuaga fu una fu fuaeveno. ");
INSERT INTO bbb_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ro mave bune ma ebe iniemevoga e ije mave samuagiaema ije fu ijia sone una mave koeki ije fuaevedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Ro bune fanu taraeko ijiebe sakia buvua ijokuma e ije fuka fanu ijiebuo surive ro ane ije bino kena ro e koeki ije nijaega fu ijia giana vierafekina fube una fanuve ijadufuo fuaeveke. ");
INSERT INTO bbb_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Ro kuke e be fu oenoene va kai fuone be kuako, Ni mave-kau ro ose one be nujaejiega na mesiri vaekina na una mesiri rono kuaga fu abe nujaejamo fu mesiri vae. Rove e koeki fu naebe ijia fikoga fanu fu matane abe ro baronekuma e ije fanuve mesiri vaema ije fuka una e koeki ije fuaevedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Ro fu e koeki fune ijia fiko fu ijiege rekuma ije fube una ijadufuo fuaeveke. Ijadufuo maeje fune manido fuaevena mesiri va oenoeno fu irufui abema ije fune mani ijare okurae. ");
INSERT INTO bbb_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Ro e be erare fu oenoeno bara kabaekua be baruna naeno baki ije fuobiki naekuma e ije fuka bara ije abe areme mani kena una orafa fuone ije miake. ");
INSERT INTO bbb_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Ro asoe fuone e ije fu ijuonekuma e ije fuka uria mani izege e bu bara kabaekua kena fuaevevo ijiege kena una bara ijadufuo asoe ije fuaeveke rove bara kabaekua ije fube abeke. Ro kuke akae gue ijeja, ");
INSERT INTO bbb_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Bara be erare fu e masirikiakuma bara ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Ro e be erare fanuve ijena vame ise barabaru oenoevo ijene renoekuma e ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","Ro e be erare fu oenoeno godi binobino ijene zinone ifaejegaro E Ireobo na fu arekuma e ije nika kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","Ro jade oenoeno e ae binoko bu ro jaena karinoevo ije vame ise bino bu oefiadiadufuo ijia revo. Ja isuibe jadua ja e aebinoko igege rena aesakae Ijifiti ijia oefiaeguma karinoena ruae. Ro kuke ja vame izege e ae binoko bu ebuo are ijia oefiane abenoejo ije jane vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","24","Ro jade bara amune ro ame oeje ije vame ise bino bu oefiadiadufuo ijia revo. Ro ja ijiege rega bu una E Ireobo na kumekuva naka fiena ifejiadufuo. Ro kuke na ziekuva maza ije ja e anina bijaevo ijia buka bure iraraena kaniaga ja oeke. Bu ijiege kaniaga bararafa jone buka una amunamuigi rekiro anafa jone buka una oeje redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ro ja e none bino bu sinuome ro moni baki ije moni vajiaga bu una ve vajiavo ijia jade kiaga bu una kuke buone binodua ado nana vajiavo. ");
INSERT INTO bbb_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","27","Ro e be fu ugone fuone fu ado abiemo ije abe e befuo ire be fuaevema ije nika kuaga fu maza besu ijia abena una mane. Ijadufuo maeje fu ugone fuone be fu nakae naedufuo ije fuka baki. Ro kuke Godi naeje naka e oetuakinu giana oefiane abevo ijadufuo fu kiekuma na ifejake. ");
INSERT INTO bbb_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ro kuke jade Godisina vua ise bino kuaekinu ro e ireobo jone fu ja samuagiamo ijadufuo vua ise bino kuaena irufui miavo. ");
INSERT INTO bbb_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","30","Ro kuke igia fie ja ire kumunekiro vuiti ro ine orivi safine bune duikuva nika ude gue kena una na vajiefo. Ro kuke ni ame fari jone amure ijiakina mave-kau ro mave-sife ijiebuo ame amure ije nika kena una E Ireobo na vajiefo. Ro fanuve ijiebuo ame amure ijiaru ni areke bu mu seveni ijiege ove buone ijena oenoefo. Ro mu eiti abeno ije nika kena una na vajiefo. ");
INSERT INTO bbb_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","Ro jaeje jaka e none akae ijadufuo jade fanuve ije bu fanu taraeko ijiebe sakiana iremareva ije kena buvua ikiro nime kena siroe jone vajiafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","Ro igia fie jade ebuo vua kufui kuaenoevo. Ro kuke jade uri e be fu vame ise be rena koto remo ije ifejana vua kufui kuaena irufui fuone ije dasumavo. ");
INSERT INTO bbb_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Ro ja e boeje bu urina vame ise renoekuva jade urina bu ifejiavo. Ro bu koto revo ijia bu vua kufui ijia kuaena buone ifejanamikuva jade urina ijia nuvediavo. ");
INSERT INTO bbb_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Ro ja e moni ro sinuome baki be fu oenoeno koto remo ije jade vierafero fu e sinuome bakiro uri vua kufui ijia kuaena fu ifejiavo. ");
INSERT INTO bbb_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ro ja oenoeno e ani jone ijiebuo mave-kau ro doniki be fu sauima ije biekuva nika mesiri una va e koeki ije mafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ro ja oenoeno e ani jone ijadufuo mave-doniki be fu irufui be abekuma nika kenujaga fu vafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Ro ja oenoeno e sinuome baki be fu ire ise be rema ja mesiri koto rekuva nika izege ja jone vierafekinu ifejanamivo ijiege fuje vame besu ijiege vierafekinu ifejafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ro ja e be fu ise besukua be fu naebe rema ije jade kufui ijia vua fuesina kuae ro kanaga fu baronemo. Ijadufuo maeje E Ireobo nare e ije erare fu ijiege renoeno ije naka dabe isekafake. ");
INSERT INTO bbb_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","E koto fiemo ije fude moni e bu vajavo ije kena uri e ije fu ise rema ijene ifejamo. Ijadufuo maeje fu mani abekuma fu vame maeje rekuma baki rove fuka una e vua baki ije dabe isekafaga fu isejavaeke. ");
INSERT INTO bbb_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","Ro jade oenoeno e ae binoko bu ro jaena karinoevo ije vame ise bino bu oefiadiadufuo ijia revo. Ja isuibe jadua ja e aebinoko igege rena aesakae Ijifiti ijia oefiaeguma karinoena ruae. Ro kuke ja vame izege e ae binoko bu ebuo are ijia oefiane abenoejo ije jane vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Ro kuke igia fie, ja juare mekuva ni juaevasia sigisi (6) ijiege ijia juare jone mekinu ire kanafuina mukoreigia nafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Ro juaevasia seveni abeno ije juare za jone ije jade una mevo ro ni areke fu mauike ijia nadufuo. Ro ire nugune ije ja areva ije ni arega bu e ire baki ijiebe karina ifo. Ro irere nugune e ire baki bu karigaro areva ije ni arega bu fanuve taraeko ijiebe inoefo. Ro kuke vaeni jone ijiakiro ine orivi ja juare ijia oeva ije ni vame besu ijiege refo. ");
INSERT INTO bbb_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Ro ja imenoekuva ije ni mazani sigisi (6) ijia menoekiro mazani seveni (7) ije jade abena imevo. Ja ijiege rekina e ije bu joefuo moni baki imevo ijiakiro e ae binoko bu joefuo imevo ro fanuve jone ije budua bu mauike karike bu aemadiafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ro kuke igia fie ni vua irere boeje E Ireobo Godi na kuariavo ije mukoreigia fiena refo. Jade oenoeno godi binobino ijiebuo baname isoekinu ro ive buone ijia kurianoevo. ");
INSERT INTO bbb_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Ro ja juaevasia besu guove ijia iro inokubeke ije ikuva nika na aguariekinu renofo. ");
INSERT INTO bbb_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Ro ja oenoeno asame Abibi ije ja Ijifiti arena ruaeva ije fu ruomo ije nika iro bu kua Burede Isiti Bakino kuavo ijene ina oemarefo. Ro ja iro ijene ikuva nika vame izege na kuariaeva ijiege rekinu iro ijene ifo. Ro kuke jade mazani seveni guove ijia ire burede isiti ijiakuma amaeriaeva ijene ivo. Ro ja nidua none ijia ruavo ije nika zinone none kejiena ruakiro jade ikiriasa ruovo. ");
INSERT INTO bbb_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Ro iro be ja idufuo ije ja iro ije bu kua Juare Masivono kuavo ijene idufuo. Ro iro ije ja mazani ije ja zinuevena ire amure bu duiva ije masivo ijia ike. Ro kuke iro be ja idufuo ije ja iro bu kua Juare Masivokinu Naovo kuavo ijene idufuo. Ro iro ije ni juaevasia ubine ijia idufuo ijadufuo maeje ja asame ijia ire vaeni ro ine sunine jone ja oeva ije masivo. ");
INSERT INTO bbb_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Ro ja juaevasia besu guove ijia iro inokubeke ije ivo ijia e fari boeje nika ro E Ireobo Godi jone ige na kafiafiriekinu none baname isoena oemarejiefo. ");
INSERT INTO bbb_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ro igia fie maza ije ja fanuve kavuane kena na zinone ifaejiekuva jade burete ire isitikuma ifaejeva ije kena ifaejievo. Ro kuke ja oenoeno iro bino ivo ijia jade fanuve ije ja kaniana zinone ifaejievo ijadufuo saruone ije gue kena suba nakiro boeje nika i furifo. ");
INSERT INTO bbb_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","Ro ja juaevasia bino guove ijia ja ire jone binobino ja amure masivo ije nika ire jone maeje gue karina ro E Ireobo Godi jone igadufuo are ijia na vajiefo. Ro mave-goti ijadufuo ame ja kaniavo ije jade kena asie fuone ijadufuo muije ijia ifaejevo. ");
INSERT INTO bbb_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Ro igia fie na Godi nare anera be nujaga fu arina ja samuagiakinu ude vake ja ijia nuvena vakuma are na joefuo kanafuiva ijia usiaedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Ijadufuo nika mukoreigia vua fuone irinana rekiro jade vua fuone karatuakinu fu ijuonevo. Ro ja vua fuone karatuakuva fube vame ijare ije giana aredufuo. Ijadufuo maeje fuje na nare kuavo fu vuae ro kuke na kono nane fuosiki ijia oenoeve. ");
INSERT INTO bbb_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Ro ja vua boeje fu kuariamo ije mukoreigia fiekinu ro irere na kuariaeva ije renoekuva nare e ani jone bu ja ijuonena jaena bijaevo ije ziegafiana kame isekafiake. ");
INSERT INTO bbb_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ro kuke anera none fu ja kaenamiana ude vake ja ijia nuvena e Amoraetiko ijiakiro e Itaetiko ijiakiro e Kenanaetiko ijiakina e Ivaetiko ijiakiro e Jebusaetiko ijiebuo aesakae ijia ura vake. Fu kaenamia ijia ura vaga nare kono e boeje kaniana kame uinituke. ");
INSERT INTO bbb_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Ro jade oenoeno godi buone ijene auge sana kurituakafiakinu ro vame buone bu baname isoevo ijene gue mimatavo. Ro godi buone bu umui ijia amaeriavo ije nika kame kania tuasekinuro mune akae buone kame mutu korejiafo. ");
INSERT INTO bbb_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ro ja E Ireobo Godi jone ige nanaru baname isoena kafiafiriekuva nare daro miakinu ifejiana ire ro do maeje uruvana vajiake. Ro kuke ja adame abekuva nare ifejiaga adame jone bu furike. ");
INSERT INTO bbb_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Ro nare ijiege ifejiavo ijadufuo bara ije bu e fudiekuva bube irufui bino biediakinu ro debireke. Ro kuke nare ifejiaga jaka maza jiamadogo karina vake. ");
INSERT INTO bbb_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ro nare e aesakae gue bu jaena nigaraevo ije ire bino buone rega buka na jumeke. Ro nare e ijiebuo vierafe kame arafiriajiaga buka uri totenaminoeke. Ro nare ririkua ijia manina ka kuriaerega e ani jone bu subinae vake. ");
INSERT INTO bbb_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ro e Ivaetiko ijiakiro e Kenanaetiko ijiakina e Itaetiko e ani jone ije nare ubije abefo ka kuriae ije kiaga bu ude vakinu e ijene kaniaga bu dabe faraena subinae giegisa vake. ");
INSERT INTO bbb_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Ro igia fie na ijiege rekuva nabe juaevasia besu guove ijia e ije kaniakuriaga bu oekinu ro subinae vafuridufuo. Ro na uri e boeje foteke kania furikuva aesakae buone fuka taraebo rega fanu taraeko ije buka uruvana rega ja izege sakae foteke mukoe samuakinu ijia karikuva baki. ");
INSERT INTO bbb_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Ijadufuo name maza abekinu sibaneke kaniakinu ijiege revakuma bu e sibaneke rega ja ijare sone aesakae buone abeke. ");
INSERT INTO bbb_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Na E Ireobo nare aesakae jone kiane ije abe biona vakuma Davare Akaba nafuema ijia irina vakuma Davare Meditereniani namo ijia vake. Ro una ikene gue ije na ae sao ijia irina vakuma Do Iufureti ruvako ijia vake. Areme nare daro miaga ja aesakae ije abena karikinu e ijia karivo ije biokiake bu usiae vakuma ka furidufuo. ");
INSERT INTO bbb_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ro jade godi buone ijiakiro e ijena vua bino kuaena avenamivo. ");
INSERT INTO bbb_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ro jade bu kafiaga bu aesakae jone ijia karivo. Ro ja ijiege kafiakuva bure vierafe jone ijiakiro vame jone ije arafiriajiaga ja una none ise redufuo. Ro kuke ja godi buone aroriakinu baname isoekuva jaka kojo mukoreigia jone isekafanamidufuo. ");
INSERT INTO bbb_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Areme E Ireobo fune urina Mosisi kuae, Ni e Isureroko ijiebuo e mamekanu seveniti (70) ijiege ro e Eronikina Nadabikina Abiu ije kaenamia aena uruo ijia ajiana na biediefo. Ja ajiana ruoma uruo makave ivuake ijia usiaekuva ni sibaneke mumabo ijia auge sana na aroriekinu baname isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ro Mosisi nine a osukua na ivuake ijia ruakiro e bino bube ruovo. Ro e Isureroko bino bube uruo igia ajiana ruovono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Areme Mosisi fune una arina akae ijiakiro vua boeje izege bu redufuo ije E Ireobo fu kuaraema ijene e Isureroko ije kuariae. Fu ijiege kuariamoga e boeje bu urina kuae, No vierafe noka izege E Ireobo fu kuaraema no ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Areme Mosisi fune urina vua boeje E Ireobo fu kuaraema ijene isoe. Areme fune suoke mugamia urina e Isureroko ijiebuo agane tuero ije vierafekinu mune mamekanu uruvana karina zinume tuero (12) ijiege uruo zinume ijia akoena ajiae. ");
INSERT INTO bbb_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Areme fune urina e nikaki ije kiamoga bune va zinone ije bu una E Ireobo ijena kafaedufuo ije ifaejedufuo ijadufuo mave-kau bino kaniana va zinone ifaeje. ");
INSERT INTO bbb_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Ijiege rena Mosisi fune fanuve bu kaniaeva ijiebuo kavuane gue vesena sukore ijia usiaga gue fu vesena fata zinone ifaejevo ijia jijiakorei. ");
INSERT INTO bbb_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Areme fune urina E Ireobo ijadufuo akae boeje fu buki ijia isoema ije abena urukeigia dakoga e boeje bu karina fie. Bu fiema areme urina kuae, No vierafe iviama noneka vua irere boeje E Ireobo fu kuaema ije irinana rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Areme Mosisi fune urina fanu kavuane fu sukore ijia usiaema ije abena e ije jijiamadiakinu kiae, Kavuane igare vua boeje E Ireobo fu joefuo kuaema ijene abena maremono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","11","Areme fune uri Eronikiro Nadabikina Abiu ro e Isureroko ijiebuo e mamekanu seveniti (70) ije kaenamiana una uruo ijia ajia vakoga bu ni buone ijia e Isureroko ijiebuo Godi ijene gae. Ro fu manino dia rotire fuone bu gaeva ije fuka ire mune safaea igeki ro ire saove gufe amitebaki bu gavo ijieki ijene gae. Rove Godi fu naebe e Isureroko ije bu fu gaeva ijene ire ise bino buone rei. Ijadufuo bune ijia besu afui karina irekiro do ina oemare. ");
INSERT INTO bbb_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Areme E Ireobo Godi fu urina Mosisi kuae, Ni uruo kubi igia ajia ro fike na mune fae inokiro na akae ije e bu ijia giakinu kenoedufuo na isoeva ije kena vajane. ");
INSERT INTO bbb_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Ijadufuo Mosisi fune urina Josua e ije fu ifejamo ije kuana bune uruo ijia ajia vakuae Mosisi fune uri e mamekanu ije ijiege kuariae. Fu kia, Janika igia karike no vaekina una ruafo. Ro e eranebe bu irufui bino biediakuva ije Eronikiro Eri bu jaena iji kariva ijadufuo nine buone vaga bure ifejiana dasumiano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Fu ijiege kuaria areme bune Uruo Saenae ijia ajiana vakoga amite ijare arina uruo kubi ije uti kurae. ");
INSERT INTO bbb_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Areme E Ireobo ijadufuo sanaema ijare Uruo Saenae kubi ijia sanae. Fu ijiege sanakoga amite ije fu mazani sigisi (6) ijiege uruo ije utikurana vakuma mazani seveni ijia E Ireobo fu arina amite uve ijia Mosisi kumei. Ro e Isureroko gume bu uniana vaeva ije bu Godido sanaema ije gana vierafero fume miane uruo ijia naenoro bu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Areme Mosisi fune uruo ijia ajiana va amite uve ijia maza foti ro mu foti ijiege amite uve ijia finoe. ");
INSERT INTO bbb_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","2","Ijiege rena Mosisi fune ijia fikoga Godi fu urina kuae, Ni e Isureroko ije kiaga bu ire buone maeje binobino bu kevo ijene gue ke atana na vajiene. Ro e besubesu erare fu oemarekinu ire fuone maeje bino kena na vajiekiro vierafekuma ije ni karine. ");
INSERT INTO bbb_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","7","Ro ire bu karina na vajiedufuo ijeja bu ire gorodikiro siriva ijiakina buronisi ro mave-sifi u kazine ro kavuane ro getiki ro ugone abaeki ro fanu goti u ijia karina vajiedufuo. Ro kuke mave-sife surive bu kena kavuane amaeriaeva ijiakina fanuve surive ijiakina ine akesia ijene. Ro ire gue ije ine orive ijadufuo oere buraetiijia usiavo ijiakina ia ije bu oere ijia sana e Godido imejo ijene aziriavo ijiakina ia ije bu oere udi mukore urimo ijia savo ijene. Ro gue ije mune isesina mukore ka anuigi ijiakina uniae ni binobino e zinone ifaejevo bu savo ijia karina vajiefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Ro ni E Isureroko kiaga buka Are Muvuaka Akae be na ijia buina finoedufuo ije safo. ");
INSERT INTO bbb_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Ro are ije bu sa areme ire boeje guove ijia nadufuo ije buka izege nare kuariakuvejo bu ijiege vierafekinu sake. ");
INSERT INTO bbb_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Ro kuke ni kiaga bu mavua akae ije abena ige na kuariakuvejo ijiege amaerifo. Ja amaerikuva ni ine akesia fae ijia karina amaerifo. Ro jiamado fuone ije ni uvani aderedi teni (110) senitamita ijiege mina kania ro kave fuone ije sigisiti seveni (67) senitamita ijiege mina kaniafo. Ro una arirefuo ije ni sigisiti seveni (67) senitamita ijiege mina amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Ja ijiege kanianoena areme nine gorodi ijia abena mavua surive ro guove ije kamafo. Ro irifo ije ni ire gorodi ijia gue kena kama ufuaenoefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Ro ni rini fo (4) ijiege amaeriana dia fuone ine ijia uniana gie oenoedufuo ijia ufake maziena kiriafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","15","Ro giene ije ni ine akesia ijia buvua amaeria areme ire gorodi ijia kena foteke kamafo. Areme ni kena rini tire guegue ja kiriaeva ijia uniana arekiro jade una faradia ruvo. ");
INSERT INTO bbb_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Areme ni mune fae inokiro ije na akae isoena ke vajiakuva ije kena ijia safo. ");
INSERT INTO bbb_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Ro mavua biju ije nine ire gorodi ijiaru kena amaerifo. Ro biju ijadufuo ive bu kua Mesi Sitino kuaevo ro ive ijadufuo maeje ijeja are ije Godi E Ireobo fu e ijiebuo ise giana aremo. Ro biju ijadufuo jiamado ije nine uvani aderedi teni (110) senitamita ijiege mina amaeri ro tave fuone ijeja sigisiti seveni (67) senitamita ijiege mina amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Areme ni gorodi ijia ire serubimi inokiro amaeriana kena biju ado ubine gue gue ijia kamaga bu besu ifefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Ro ire serubimi ije ja amaeriakuva ni ume ige bu adave iravo igege amaeriaga bu biju ado ijia uivajuonami irena biju ije okuradufuo. ");
INSERT INTO bbb_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Areme nine mune fae inokiro na akae isoeva ijene kena mavua guove ijia sa areme biju fuone ijia abe bijukurafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ja ijiege rekina na mavua biju ijadufuo ado ire serubimi inokiro bu ireva ijiebuo ukua ijia arina ja biediakinu akae none boeje e Isureroko ije nijasiake. ");
INSERT INTO bbb_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","24","Ro ja fata amaerikuva ni ine akesia ijia kena amaerifo. Ro jiagado fuone naeniti (90) senitamita ijiege mi ro baraeki fuone ni foti faeve (45) senitamita ro arire fuone sigisiti seveni (67) senitamita ijiege mina amaerifo. Areme nine ire gorodi ijia karina fata ije foteke kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Areme ni gorodi gue ijia kena seveni (7) senitamita ijiege mukoreigia amaerima areme abena fata ikene ubae ijia kama ufuaenoena arefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","27","Areme ni rini tiki fo (4) ijiege amaeria areme kena dia fuone fo (4) ijadufuo ubae ije ja gorodi ijia kamaeva ivuake ijia kiriaekina ja ijia giena oenoefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Ro giene fuone ije ni ine akesia ijia ufusena amaeria areme gorodi ijia kena foteke kamaekina ja ijare kena fata ije giena oenoefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Areme nine firetekiro kafusi ijiakina sukore ro disi bino amaeriaekina e bu vaeni kena ro fata ijia usiaekuva ja ijare kena vesedufuo. Ro ja ire ije amaeriakuva boeje nika ire gorodi ijiaru karina amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Ro fata ije ni abena Are Akae ijia nijafo. Areme nine burete ije ja maza boeje none baname isoena oemarejiekuae abe ruovo ije abena fata ijia nijafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","Ro nine ire ja kedoro ifaejega fu sanadufuo ije be amaerifo. Ro ja amaerikuva nine gorodi ijia abena baraeki amaeri ume ijia nija areme nine be amaeri ado ijia arire safo. Areme nine kave ijia ukie fuone ire kusare fu iko uti ro ajia irasemo ijiege isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Ro nine kia fuone sigisi ijiege gorodi ijia amaeriama kena ove ije arire manino kave ijia kamaga fuka besu ifefo. Ro ja amaeriakuva nine inokubeke ikene gue kama ro inokubeke gue kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Areme nine kuke gorodi ijia abena kafusi uruvana ine amoni fu iko kirakiro utina irasemo ijiege amaeriafo. Ja ijiege amaeria areme ni kafusi inokubeke ijiege kena maziena kia fuone besubesu ijia kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Ro nine una kuke kafusi ude ja amaeriaeva ijieki fo (4) ijiege amaeriana ke ire ije kedoro ifaeje navo ja amaerina arire saeva ijadufuo kave ijia kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Areme nine kafusi gue amaeria areme besubesu abe kia fuone fu bijaema rotire ijia kamajana ajia vafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Ro kafusi boeje ja amaeriaeva ijiakiro ire kedoro ifaejevo ijadufuo kia fuone ijiakina ove ije boeje nika gorodi ijia kena besu foteke amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Areme nine ire raete seveni (7) ijiege amaeria areme kena kiae ijiebuo ubine ijia kamaekina bu uineke ijia sanafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Ro ire ije ja kena raete vafaedufuo boeje nika gorodi ijia kena amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Ro ire ije ja kedoro ifaeje nadufuo ijiakina kia fuone ro kafusi ije boeje nika gorodi teti kiro (30kg) ijiege kena amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Ro ire boeje ja amaeriadufuo ije nineka izege na uruo ijia kuariaeva ijiege mukoe vierafekinu amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Ro Are Muvuaka guove E Ireobo na ijia oenoedufuo ije nika ugone fae teni (10) mukore bu mave-sifi u kazine ro kavuane ijia kena saguiva ijia abena kirakurafo. Ro ni e ugone mukoe sagumo ijia kuaga fu ugone fae teni ije karina ire serubimi adaki ijieki ijadufuo kavene ijene ugone besubesu ijia saguna amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Ro ugone fae boeje jiagadogo buone besubesu ije nika tuero (12) mitasi ijiege mina ufusefo. Ro kakare buone ni tu (2) mitasi ijiege mina ufusefo. ");
INSERT INTO bbb_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Areme ni ugone umui fague ije ke besu ireobo sagukiro fague ije ke besu ijiege sagufo. ");
INSERT INTO bbb_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","5","Ro ni ugone amure ja kena saguiva ijadufuo ubine gue ijia tire fifiti (50) ijiege amaeria. Areme ni kuke una be ijadufuo ubine ijia tire fifiti (50) ijiege amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Areme nine gorodi ijia ire kimae igeki fifiti (50) ijiege amaeria kina ja ijare kena ugone inokiro ije ke besu nana kiriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Ro ni mave-goti u ijia kena ugone ireveni (11) saguikina ja ijare abena Are Muvuaka ijadufuo ado ije okuradufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Ro ugone boeje ja saguna amaeriavo ijiebuo kakare ijiakina jiagado ije nika besu amaeriafo. Ro jiagado fuone ije ni tetini (13) mitasi ijiege mina sagukiro kakare ije tu (2) mitasi ijiege mina sagufo. ");
INSERT INTO bbb_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Areme ni ugone umui fague ije kena besu nana sagu areme ni sigisi ijiege kena una besu nana sagufo. Ja ijiege sagu areme ni ugone umui dikine ja saguiva ije abe davatoena nijafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Areme ni ugone be ijadufuo ubine ijia ubae fuone fifiti (50) ijiege amaeria areme ni una kuke be ijadufuo ubine ijia ubae fuone fifiti (50) ijiege amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ja ijiege amaeria areme ni ire buronisi ijia abena ire kimae igeki fifiti (50) ijiege amaeriaekina ja ijiebe kena ugone inokiro ijiebuo ubae ije kena una besu kuriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Ro ugone ado kabuane ijadufuo ubine ja unakoeva ije ni arekina fu ijare Are Muvuaka kabuane ijadufuo isuo kave ijene okuradufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Ro una Are ikene guegue ijadufuo ugone ubine ije ni teti (30) senitamita ijiege uniakoekina bu ijiebe isuo ikene ijene okuradufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Areme nine una kuke ugone inokiro ijiege amaeriafo. Ro be ije ni mave-sife surive ijia amaeri areme safire kavuane ijia abena azifo. Ro be ije ni fanu surive ijia kena saguna amaeriakina ja ijare abena sife surive ijadufuo ado ijia okuradufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Ro Are Muvuaka Akae ijadufuo isuo boeje nine ine akesia ijia buvuatuana safo. ");
INSERT INTO bbb_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Ro isuo besubesu arire fuone ije ni faeve (5) mita ijiege mina amaeriafo. Ro una kakare fuone ije ni sigisiti seveni (67) senitamita ijiege mina amaeriafo ");
INSERT INTO bbb_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Ro isuo boeje besubesu ja amaeriakuva ni ubine uniakoekina ja isuo be abe una ijiakuma kamana kanadufuo. Ro isuo boeje ja amaeriakuva nika ni besu amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","22","Ro ja Are Muvuaka ikene guegue jiagadogo ijadufuo isuo ije amaeriakuva ni tuaedi (20) ijiege guefuo amaeriaro una tuaedi guefuo amaeriafo. Ro ja isuo besubesu ijadufuo tugie buone amaeriakuva nine ire siriva ijia abena inokiro ijiege maziena amaeriakina ja kena rotire ijia nadufuo. Ja ijiege amaeriakina tugie foti (40) ja ikene gue nakiro una foti (40) ja gue nadufuo. Ro una kabuane maza koeno nake ijadufuo isuo ije ni sigisi (6) ijiege amaeriafo. Areme ni ire siruva ijia kena tugie inokiro ijiege maziena amaeriakina ja kena isuo besubesu ijadufuo rotire ijia nadufuo. Ro isuo kabuane gue gue ijadufuo tugie boeje ja amaeriavo ije jaka tuero (12) ijiege amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Areme nine ire inokiro bu Are kabuane ije maza koeno nake kusoe inokiro ije faradia iredufuo ije amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Ja ijiege amaeriakina fu ijare isuo zinume ijia ajia vakuma kave gafia fare manidufuo. Areme ni rini be ire inokiro ijiebuo ubine ijia abiedufuo ije amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Ro kabuane guegue ijadufuo isuo ja amaeriadufuo ije ja isuo eiti (8) ijiege amaeriake. Ro kuke tugie buone ja siriva ijia amaeriavo ije ja sikisitini (16) ijiege amaeriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Ro ni ine akesia ja Are Muvuaka isuo ijadufuo kakare ijia kaniadufuo ije fifitini (15) asefo. Ja ijiege asekina faeve (5) ja kena ikene gue uniakiro faeve ije ja kena una ikene gue uniadufuo. Ro faeve ije ja kena isuo kabuane una maza koeno nake ijadufuo ijuone ijia uniadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Ro ine jiagadogo ije ja kena isuo boeje ja kari kamavo ijadufuo ukua ijia uniana ufuaenoena aredufuo. ");
INSERT INTO bbb_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Areme nine gorodi ijia abena isuo boeje ro ine ije kakare uniadufuo ije kamakinu okuriafo. Ro kuke nine ire gorodi ijia kena rini ije fu ine kakare ije ivia faradiadufuo ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","Ro Are Muvuaka ije ja sadufuo ije nika izege na uruo ijia kuariaeva ijiege safo. ");
INSERT INTO bbb_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Areme nine e ugone mukoe sagumo be kuaga fu ugone ni mukore kazine ro kavuane ijene mave-sife u ijia kena sagufo. Fu ijiege sagu areme kaje fanu u ijia ufiva ijia kena fanuve adaki igeki ugone ado ijia saguna amaeriake. ");
INSERT INTO bbb_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Areme nine ine fo (4) ja ine akesia ijia amaeriana gorodi ijia okuriadufuo ije kena tugie ije ja ire siriva ijia amaeriaga bu ine ije faradia iredufuo ijadufuo ado ijia safo. Areme ni ire kimae igeki ja ire gorodi ijia amaeriadufuo ije kena ugone ubine ijia kiriafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","34","Areme nine ugone ubine kena Are Muvuaka Akae guove ine fo ijia kuriaga fu Are Akae ijiakiro Are Ma Akae ije ke ata guegue redufuo. Areme nine mavua akae ije mune fae inokiro saeva ije abena ugone ije kiraeva ijuone gafa Are Ma Akae ijia nija areme nine biju fuone ije abe bijukurafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Areme nine fata ije ja amaeriva ije abena ugone ije kiraeva ijadufuo uineke una Are ikene umui maeneke ijia nijafo. Ro nine ire kedoro ifaeje navo ije abena una ikene gue umui aeneke ijia nijafo. ");
INSERT INTO bbb_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","Ro Are Muvuaka viene ijadufuo ugone ije ni fanu u kazine ro kavuane ijia kena sagu areme ni e ugone mukore isoemo ijia kuaga fu ukie ni binobino ijia isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Ro ugone ja abe kirakuva ni tugie ine akesia faeve (5) ja ire gorodi ijia kena kamaeva ijia kena safo. Areme ni ire buronisi ijia kena ire tugie ije faradia iredufuo ije umui fague amaeriafo. Areme ni ire kimae igeki ja gorodi ijia amaeriadufuo ijia kena ugone ubine ijia kiria areme kena tugie ijia kuriafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Ro fata zinone ifaejedufuo ije ni ine akesia ijia kena amaerifo. Ro ja amaerikuva jiagadogo ro baraeki fuone ije nika ni besu tu aderedi tuaedi faeve (225cm) senitamitasi ijiege mina amaerifo. Ro una arirefuo ije uvuvani aderedi teti (130cm) senitamita ijiege mina amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Ro fata ubine ijadufuo kusoe besubesu ijia ni gome buone besubesu ijiege bijianaga fuka besu ifedufuo. Areme ni ire buronisi ijia abena fata boeje kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","4","Ro ni guruone ja ijia tuvuare numudufuo ijiakina disi binobino ro ire kimae igeki ijiakina faniki bu ijia miane karana oenoevo ije amaeriafo. Ro ire boeje ni ire buronisi ijia kena amaeriafo. Areme ni ire buronisi ijia ire ja miane ifaejedufuo ije amaeri areme ire buronisi ijia rini fo (4) amaeriana kusoe fuone ijia kamaekina ja giene ijia uniana giedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Ro ja ire miane ifaejevo ije amaerikuva ni abena fata ije zinone ifaejedufuo ijadufuo rotire ijia nijafo. Ro ja abe nijakuva fube fata zinone ifaejevo ije niriake ro fume ajia ukua ijia iridufuo. ");
INSERT INTO bbb_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","7","Ro ni ine akesia ijia buvuana giene amaeria areme ire buronisi ije abena foteke kamafo. Ja ijiege kamaekina ja ijare kena fata ijadufuo rini fuone ikene guegue ijia uniana gie oenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Ro fata zinone ifaejedufuo ja amaerikuva ije nika izege na uruo ijia kuariaeva ijiege ine fae ijia kena mavua suave igege amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","11","Ro Are Muvuaka ijadufuo makave ije ni ugone ni mukore ijia kena kirakurafo. Ro ugone ije ja are ikene aeneke ije kiradufuo ije jiagado fuone ije ni foti faeve (45) mita ijiege mina sagufo. Areme ni tugie ja ugone ije kiradufuo tuaedi (20) ijiege amaeria areme ni ire buronisi ijia abena ire baraeki bu tugie ije faradia iredufuo ijene tuaedi (20) ijiege amaeriafo. Ja ijiege amaeria areme ni ire kimae igeki ijiakiro rini bu tugie ijia kiriadufuo ije ire siruva ijia abena amaeriafo. Ro Are Muvuaka makave ikene umui maeneke ije ni kuke besu ijiege mina amaerina kirakurafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Ro Are Muvuaka makave maza koeno nake ije ni ugone jiagadogo fuone tuaedi tu (22) mita ijiege mina sagufo. Areme ni tugie teni (10) ijiege amaeria ro ire baraeki bu tugie ije fadia iredufuo ije teni (10) ijiege amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Ro una Are Muvuaka makave maza ajiamo nake ije jiagadogo fuone ije ni tuaedi tu (22) mita ijiege mina amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Ro ugone viene bu aruvo ijadufuo ikene guegue ije ni sigisi mita (6) ijiege mina sagufo. Ja ijiege sagu areme ni kuke tugie buone inokubeke guefuo ro inokubeke guefuo ijene amaeria areme ni ire baraeki bu tugie ijene faradia iredufuo ije amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Ro ugone ja Are makave ijadufuo viene ije kiradufuo ije ni mave-sife u kazine ro kavuane ijia kena sagu. Areme ni e ukie mukore isoemo ijia kuaga fu ugone ijia ukie mukore ijene ijia isoefo. Ro ugone ijadufuo jiagadogo ije ni naeni mita (9) ijiege mina sagufo. Areme ni tugie fo (4) ugone ije kiradufuo ije amaeria areme ire baraeki bu tugie ije fadia iredufuo ije amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Ro Are Muvuaka makave ijadufuo tugie boeje ja uruna ugone kiriadufuo ije nika ire kimae igeki ro rini ije ja ire siruva ijia amaeriavo ijia kena ivia kiriafo. Ro ire baraeki bu tugie faradia iredufuo ije bu buronisi ijia amaeriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Ro Are makave ijadufuo jiagado ije ni foti faeve (45) mita ijiege mina amaerikiro kakare ije ni tuaedi tu (22) mita ijiege amaerifo. Ro ugone ja kirana ajiadufuo ije ni tu mita ijiege ajiadufuo. Ro ugone ja saguna Are ije kirakuradufuo ije nika ugone ni mukore ijia karina sagufo. Areme ni ire buronisi ijia abena ire baraeki bu tugie faradia iredufuo ije amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Ro ire gue ja karina Are Muvuaka guove ijia imedufuo ijiakina asuge ije ugone ivia faradiadufuo ije nika ire buronisi ijia kena amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Ro ni e Isureroko ije kuariaga bu ine orive oere ma bu ifaejena sanaga fu maza boeje ijia nae vadufuo ije bino kena ruaekina bu muge raete ijia usiana ifaejega bu sanadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Ro kuke ni Eronikiro anafa fuone ije kiaga buka Are Muvuaka guove are Ma Akae na fidufuo ro kuke mavua akae ije namo bu ugone ijia kirakuraeva uine ijia ire raete ifaejedufuo ije karina ro ijia narudufuo. Bu ijiege rekina mufuo ijia bu ifaejega fu naena vakuma ve iraserudufuo. Ro vua ige na kuariavo ije e Isureroko ijiakiro uifari buone ije buka maza boeje ijiege rekinu vano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","E Ireobo fune Mosisi ijiege kuarama areme kuae, Nine e Isureroko ijiebuo uve ijia e Eronikiro anafa fuone e Nadabikiro Abiu ro Eriesa ro Itama ijene kena irigi uniane. A bu kena ijiege uniaekina bure e zinone ifaejevo ijiege rena noefuo imedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Ro ni ugone akae bino uvia one Eronido amaeriakina fu ugone ije sakuma E Isureroko bu ije gana fu mukoreigia aguaedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Ro ni e fari bino na vierafe vajiako bu ire bino mukoreigia amaeriavo e ijieki ijia kega bu Eronido ugone fu sadufuo ijene amaeriane. Bu ugone ijiege fuefuo saguna amaeriajaekina fu ke sana e zinone ifaejemo ije rena noefuo imenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Ro ugone bu amaeriadufuo ije bu igege amaeriadufuo. Bu ugone biregato ijia irina gagare gufa abiedufuo ijiakina ugone kazine jiagadogo ijiakina ugone ifodino kuavo bu ugone kazine ado ijia abiedufuo ijene amaeriake. Areme bu kaje biregato kiradufuo ijiakina seti ukie ni mukore isoeva ijiakina ugone fu nigofo abiedufuo ijiakina ugone fu guge ijia dasuvaedufuo ijene amaeriadufuo. Ro ugone binobino ijieki ije uvia one Eronikiro anafa fuone bu sadufuo ije amaeriaejiaekina bu sana e zinone ifaejevo ije rena noefuo imenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ni e ije ire binobino amaeriavo ije kiaga bu mave-sife u kazine ro kavuane ro garame zine igege iramo ijia kena ufima areme ni ugone ni mukore ije saguna amaeriane. ");
INSERT INTO bbb_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Ro bu ugone ifodino kuavo ije sagukuva ni kiaga bu mave-sife u kazine ro kavuane ro kaje garame zine igege iramo ijia karina ugone ni mukore ije saguna ukie ni binobino ijia isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Areme ni ugone fae bino kena ire ifodi bu saguiva ubine gue ijadufuo biruame guegue ijia nana saguikina bu ijare kena farane ijia ivia kiriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Areme ni ugone fae ni besu ijia kena una ifodi ubine gumafo ijia sagukina bu ifodi ije abe abiesena ijare kena biregato ijia iva kiradufuo. Ro bu ugone fae ijene amaerikuva ni mave-sife u kazine ro kavuane ro garame zine igege iramo ijia karina ufima areme abena ugone ni mukore ije saguna amaeridufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","10","Ro ni mune anuigi mukore bu kua Onikisino kuavo ijia inokiro ke areme nine e Jekafudo anafa tuero (12) ije amure ijia vakuma iviene ijia usiaeva ijiebuo ive ijene ijia isoefo. Ro ive sigisi (6) ije ni mune be ijia isoekiro sikisi ije be ijia isoefo. ");
INSERT INTO bbb_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Ro ja isoekuva ni e ije mune anuigi mukore ijiebuo vajae ijia ive isoemo ijia be kuaga fu mune inokiro ije kena e Jekafudo anafa ijiebuo ive ijene ijia isoefo. Fu mune ijiebuo vajae ijia bijia karakinu ive isoe areme ire gorodi ijia kena mune ubae ijia kamana amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Areme ni kena ugone ifodino kuavo ijadufuo farane ijia nana saguikina bu oenoene savo e bu ijia giana una e Isureroko ijiebuo agane tuero (12) ije vierafenoedufuo. Ro kuke Eroni fu maza boeje ive buone ije abena farane fuone ijia abienoega E Ireobo na ije gavo ijia na una e none vierafeke. ");
INSERT INTO bbb_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","14","Ro ni gorodi mukore ijia kena mune inokiro ijiebuo are bu kamana naodufuo ije inokiro amaeriadufuo. Areme ni seni inokiro bu kaje ijia ufiva igeki ijene gorodi ijia kena amaeria areme kena ire gorodi inokiro ja mune ke nana kamaeva ijia besu ifena soevefo. ");
INSERT INTO bbb_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Areme nine e zinone ifaejemo ijadufuo ugone be fu guge ijia abiena Godi irere fu vierafejamo ije fiekinu renoedufuo ijene amaerifo. Ro ja amaerikuva ni mave-sife u kazine ro kavuane ro kaje garame zine igege iramo ijia karina ugone ni mukore be ifodi ja amaeriva ijiege saguna amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Ro ja ugone ije sagukuva ni abe mukoreigia enafuna sagu areme nine abe una kuke davatoe nijana sagufo. Ro ugone ijadufuo jiagado ijiakiro kakare fuone ijeja tuaedi tu (22) senitamita ijiege mina sagufo. ");
INSERT INTO bbb_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","20","Areme ni mune isesina ni mukore ije kena ugone ijia raeni fo (4) ijiege nana bijia kiriafo. Ro raeni amure ije ni mune tofasi ro rubi ro ganeti ijene kena bijia kiriafo. Ro ura be ije ni mune tekosi ro safaea or mune getiki emarodi ijene bijia kiriafo. Ro ura be ije ni mune jasiniti ro egati ro ametisi ijene bijia kiriafo. Ro rane ije ni mune beriro ro onikisi ro jasifa ijene kena bijia kiriafo. Ro mune isesina ni mukore boeje nika gorodi ijia kena amaeria areme kena ijia kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Ro mune tuero (12) ije ja kena ugone ijia bijia kiriavo ijiebuo vajae ijia ni Jekafudo anafa tuero ijiebuo ive ijene ijia isoefo. Ja ijiege isoekina ja oenoekinu ijia giana una e Isureroko ijiebuo agane tuero ijene vierafenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Ro ugone guge abiedufuo ja amaeriva ijadufuo soe fuone inokiro kiro inokiro ije ni ire gorodi ijia abena kaje ufiva igeki ije amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","24","Areme ni gorodi ijia abena rini inokiro amaeriana ke ugone guge ijadufuo ja amaeriva ijadufuo biruame inokiro kave ijadufuo ijia kiriafo. Areme ni seni ije kena rini inokiro ijia kiriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Areme ni seni ubine inokiro ije kena ire gorodi ije bu abena ugone ifodi ijadufuo ubine farane ado gue gue bu ubae amaeriva ijia ivia kuriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Areme nine una ire gorodi ijia rini inokiro amaeriana ke ugone guge ijadufuo ubine gue gue gumafuo ijia kiriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Areme ni kuke una ire gorodi ijia rini inokiro amaeriana ke ugone ifodi ubine guegue guma devatua ivuake ijia kiriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Ro nine kaje kazine inokiro kena ugone guge ijadufuo ubine inokiro guma ijia kiriana ivia ari ifodi ubine guegue ijia kiriafo. Ja ijiege rekina ugone guge ije bu abiesevo ije fube uroena dasua akoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Ja ijiege amaeriaekina maza ije Eroni fu Are Akae ijia aru vako fu ugone guge ije e Isureroko ijiebuo agane tuero (12) ijiebuo ive isoeva ije abe oe fuone ado ijia abiega E Ireobo na ije gavo ijia na maza boeje una e none vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Ro ni mune fae inokiro Urimikiro Tumimi ijene kena ugone guge ijadufuo ja saguiva ijia kedekina Eroni fu kena Are Ma Akae na fivo ijia aru vuake. Ro maza bino fuka ugone guge ijadufuo ije abe oe fuone ado ijia abiekina fu e none bu izege redufuo na kuaravo ije fu mune ijiebe nijaeke fu ijia renoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Ro ugone jiamadogo bu ire ifodi rotire ije sadufuo ije ni mave-sife u kazine ijia kena amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Ro ni uro ijadufuo tire ije amaeri areme ugone maduibo ijia abena ubine fuone tuanana saguikina fube faraedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","34","Areme e ukie mukoe isoevo ijia kuaga fu kaje kazine ro kavuane ijia kena ugone kazine ijadufuo ubine ijia ine fomigureniti ijadufuo fo bino ijene ukie isoedufuo. Areme ni bero isesina bu gorodi ijia amaeriaeva bu zurevo ijene gue ukie ije isoeva kafare ijia bijia kiriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Ja ugone ije ijiege saguikina Eroni fu zinone ifaejekuma fu ugone ije abe abiena Are Ma Akae na fivo ijia aru ruadufuo. Fu ijia aru ruakinuro una keke vako ije fu bero ijiebe akugua igege zurega na fiekina nabe kanaga fu baronedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","37","Ro ni gorodi ijia abena ire isekube baraeki amaeri areme ado ijia vua isoefo. Ro vua ije ja isoedufuo ije ni kua E Ireobo Ijadufuo E Akaeno kuana isoena abe e zinone ifaejemo ijadufuo ugone fu nigofo utima ijia kaje kazine ijare abena kirafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Fu ijiege abiekina e Isureroko bu oenoeno ise buone ijadufuo na zinone ifaejiekuva E Ireobo na ise buone ijadufuo irufui ije na kena una Eroni vajaga fure abeke. Ro e Isureroko bu oenoeno zinone ni binobino kena ro ise buone ijadufuo na zinone ifaejekuva naka uria bu oemarejiake. ");
INSERT INTO bbb_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Ro ja Eronido ugone jiagadogo ijiakiro ugone be fu nigofo utidufuo ije sagukuva nika ugone ni mukore ijia kena sagufo. Ro kuke ni ugone fae fu guge ijia dasuvaedufuo ije amaeri areme kaje mukore ni binobino ijia kena ukie ni mukore bino ijia isoena amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Areme ni Eronido anafa ijiebuo setikiro ugone bu guge ijia suvaedufuo ijene amaeria areme ni nigosubuo buone ijene amaeriafo. Ja ijiege amaeriaekina bu ugone ijene savo ijia ja giana vierafero bu e mamekanu jonero ja bu aguariakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","E Ireobo fu ijiege Mosisi kuarama areme kuae, Nine ugone ije karina uvia one Eronikiro farirafa fuone saejiane. Areme ni ine orivi oere ijia abena usiaejiana daro miaekina bure e zinone ifaejevo rena imenoeke. ");
INSERT INTO bbb_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","Ro ni ugone mukore ijia kena tarasi buone ije biregato ro auge ijia mina sagujiaekina bu ke sana vajae buone okuriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Ro Eronikiro anafa fuone bu maza boeje Are Muvuaka Akae ije E Ireobo na fivo ijia ro are guove Ma Akae ijia na baname isoekuva buka tarasi ije ke sana aru vadufuo. Bu ijiege rekuva nabe kaniaga bu oedufuo. Ro akae ije fume ijiege navaekina Eronikiro uifari fuone bu rade urivo ije bu ijia nuvena kenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","2","Ro Eronikiro anafa fuone ja kaenamiana E Ireobo na vajiega bu e zinone ifaejevo rena noefuo imedufuo ije ni ige na kuariavo ijiege refo. Ja bu kena daro miakuva ni mave-kau kumate besu ijiakiro mave-sife kumate inokiro naebe garuradiaeva ijia giana faradiafo. Areme nine ire farava vuiti ijia amaeriaeva ije gue usia areme ni ine orivi oere ijia usiana burete gue amaeriafo. Ro burete ijiakiro bisikiti ije ja amaeriakuva jade ire isiti usiaena ijiakuma biemarona amaeriavo. Areme ni bisikiti bino oere baki amaeria areme nine oere ado ijia usiafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Areme nine burete ja amaeriakuva ije kena kamui kede areme mave-kau ijiakiro mave-sife inokiro ije ja na zinone ifaejekuae keva ijene kena ruafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ja ijiege kari areme ni Eronikiro anafa fuone kaenamia ro Are Muvuaka E Ireobo na fivo viene ijia usiaena kiaga bu do foteke ruoefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Bu do ruoega nine sinuome e zinone ifaejevo bu savo ijene karina Eroni saejafo. Ni setikiro ugone jiamadogo ijiakina ugone ifodi ro ugone guge ijia ije kena saejafo. Areme ni ugone ifodi ijadufuo soe fuone kena biregato ijia ivia kiriajafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Ja ijiege saeja areme nine ugone fu nigofo utidufuo ije abe nigofo ijia utija areme ire baraeki ijene abe kiraejafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Ja ijiege re areme nine oere ije bu e usiaejiana daro miavo ije abena nigofo ijia usiaejafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","9","Areme nine anafa fuone kaenamiana seti buone saejia areme ni ugone fae ije guge ijia suvaedufuo ije suvaejiakinu nigofo buone subu saejiafo. Ja Eronikiro anafa fuone kega bu Godido imenoekuva ni vame ige na kuariavo ijiege rejiafo. Ja ijiege rekina bure maza boeje uifari buone ijena na ijiege zinone ifaejiekinu vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","11","Areme nine mave-kau kumate ijia mesirina ro Are Muvuaka uine na fivo ijia nujafo. Ja ijia nuja areme nine Eronikiro anafa fuone kiaga bu umui buone mave-kau ijadufuo nigofo ijia naga ni mave ije kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Fu baronega ni kavuane bino vesena fata zinone ifaejevo ijadufuo gome fuone ja amaeriadufuo ijia areme nine kavuane gue vesena ke fata ije zinone ifaejevo ijadufuo zinume ije usia korefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Areme nine fanu saruone ijiakina sinuosinuo fuone boeje ijiakina saruone ije fu devuare okuraema ijiakina diane ro guaemati inokiro ije kena fata ije ja zinone ifaejevo ijia ifaejefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Ro fanu kumate ijadufuo birage ijiakina surive ro de ije kena usiae are bu naovo ijadufuo makave ijia ifaejefo. Ijadufuo maeje zinone ije ja ifaejevo ijare e ijiebuo ise ije abena vake. ");
INSERT INTO bbb_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","16","Ro nine mave-sife kumate be abena ro Eronikiro anafa fuone kiaga bu umui buone fanuve ijadufuo nigofo ijia farekega ni kana fu baronefo. Ro kavuane ije ni vesena fata zinone ifaejevo ijadufuo ikene guegue ijia jijiamadifo. ");
INSERT INTO bbb_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Areme nine mave-sife maeje abe buvuasema areme de ijiakina masiane ije karina do soma kena nigofo ijiakuma besu nafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Ja ijiege re areme ni mave-sife foteke ije karina fata zinone ifaejevo ijia ifaejefo. Ja ijiege fanuve ije foteke kena E Ireobo na zinone ifaejekina na udi fuone mukore ije fiena oemaredufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Ro ni kuke mave-sife kumate be abena ro Eronikiro anafa fuone kiaga bu nigofo ijia farena irekega ni kanaga fu baronefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Areme nine kavuane ije gue vesena Eronikiro anafa fuone ijiebuo adane maeneke ijia aziriafo. Ro gue ije vesena umui maeneke mafore buone ijiakiro dia maeneke ijadufuo mafore ijia aziriafo. Ro kavuane gue ije vesena fata ikene guegue ijia jijiamadifo. ");
INSERT INTO bbb_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Areme ni fanu kavuane ja vesena fata zinone ifaejevo ado ijia naeva ije gue vesena oere ja e nigofo usiajiana daro miavo ije gue vesena ijiakuma amaerima abe Eronikiro anafa fuone ijiebuo nigofo ro ugone buone ijia jijiamadifo. Ja ijiege rekina Eronikiro anafa fuone ijiakina ugone bu savo ije bu akae rega bu Godido i ije menoeke. ");
INSERT INTO bbb_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Ro mave-sife ije ja abena Eronikiro anafa fuone ije daromiadufuo ijadufuo saruone ro sinuosinuo boeje saruone ijiakuma saguima ijiakina diane ro guaemati inokiro ro oge maeneke ijadufuo saruone ije karina besu nafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Areme nine kamui ije ja burete ire isiti baki amaeriaeva ja kena E Ireobo ijadufuo nidua ijia nijavo ijia burete be ro bisikiti be ro burete baraeki be bu oere ijiakuma amaeriava ijene karafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Areme nine karina Eronikiro anafa fuone vajiaga bu karina una E Ireobo ijadufuo nidua ijia kave ijia kuriatefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Areme ni karina una zinone ije ja ude ifaejeva ado ijia ifaejefo. Ja ijiege ifaejega na udi mukore ije urimo ije fiekuva na oemaediedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Ro fanuve ijadufuo guoguo ije ni ufuna abe E Ireobo nidua none ijia kave kuriaetekinu abe E Ireobo na zinone igege mie areme nine una jone abefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Ro fanu oge ijiakiro guoguo ije buka akae ijadufuo karina irigi be nafo. ");
INSERT INTO bbb_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Ro e Isureroko bu oenoene na zinone ifaejievo ije fanu oge ijiakiro guoguo ije nika karina irigi be nafo. Ijadufuo maeje fanuve ije buka akae ijadufuo karina Eronikiro anafa fuone ije vajiaga bure karina idufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Ro Eroni fu baronekuma ugone fuone akae ije ni karina uifari fuone ije vajiafo. Ro bu oenoene daro miaga bu i ije zinone ifaejevo ije mekuva ni ugone ije vajiaga bu safo. ");
INSERT INTO bbb_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ro Eronido ame be erare fu e zinone ifaejemo rena Are Muvuaka guove ijia imenoekuma fuka ude ugone ije sanoeke fu vakuma mazani seveni furike. Fu ijiege re areme rade ijare fu manido fu E Ireobo nidua none ijia imenoeke. ");
INSERT INTO bbb_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Areme nine mave-sife kumate ja abena Eronikiro anafa fuone ije ja daro miakuae kanaeva ije birage gue karina va are akae be ijia sukore kira ifaejefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Ro fu naekuma ni kara areme burete ije ja kamui ijia kedeva ije karana Eronikiro anafa ije vajiaga bu buosukua kena va Are Muvuaka viene ijia ifo. ");
INSERT INTO bbb_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Ro ire ije bu kena maza ije bu noefuo imekuae bu daro miavo ijia kena ise buone ijadufuo zinone ifaeje. Ijadufuo ire ije buka akaedo e bino bube ike. ");
INSERT INTO bbb_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Ro fanu birage ijiakiro burete gue bu uria naona va ve irasekumaga ije nika karina miane ifaejefo ijadufuo maeje ire ije buka akae. ");
INSERT INTO bbb_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","Ro ja Eronikiro anafa fuone kena daro miaga bu i ije zinone ifaejevo ije imekuva nika mazani seveni guove ijia ire boeje na kuariaeva ije re furifo. ");
INSERT INTO bbb_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Ro mazani besubesu guove ijia nika mave-kau kumate ijia kaniana e boeje ijiebuo ise ijadufuo zinone ifaejefo. Ja ijiege rekina zinone ijare fata ije abe ise ijene so amaeriga ni ine orivi oere ijia abena fata ije usiaga fu maturaefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Ro janika fura besu guove ijia maza besubesu ijiege rekega fata zinone ifaejevo ije fata ije fuka ma akae refo. Fata ije fuka akae rega e bino ro ire bino bu fata ije niriaekuva bu dua buka akae redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Ro igia fie maza besubesu janika mave-sife ame juaevasia besu furima ijia inokiro kaniana zinone ifaejerufo. ");
INSERT INTO bbb_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Ro fanu be ije ni suoke ijia abena zinone ifaejekiro be ije mufuo ijia abena ifaejefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Ro fanu sife amure ije ja abe zinone ifaejekuva ni farava uvani kiro ijiege abe ro orive oere butoro besu ro vaeni botoro besu ijiege kena besu biemaroma areme abena fanuve ijiakuma zinone ifaejefo. ");
INSERT INTO bbb_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Ro una mufuo ijeja nine izege ja suoke reva ijiege fanu-sife ame be abe ro ni ire faravakiro oere ro vaeni ijiege kena zinone ifaejefo. Ro ije fu ire ijiebuo zinone ijadufuo ja ijiege ifaejekuva E Ireobo na udi ije fiena oemareke. ");
INSERT INTO bbb_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Ro zinone ije ja ifaejevo ije jaka uifari jone ijena maza boeje ijiege rekinu vafo. Ro ja zinone ije ifaejekuva nika Are Muvuaka na fivo ijadufuo viene ijia ifaejedufuo. Ijadufuo maeje na are ijia arina e none biediana buina vua kuaedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Na are ijia e Isureroko ije biediakega sanaema none fu ijia sanaga are ije fuka akae redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Na ijiege rega Are Muvuaka Akae ijiakiro fata ije zinone ifaejevo ije fuka akae reke. Ro Eronikiro anafa fuone na kena daro miana irigi uniaekina bu e zinone ifaejevo rena noefuo imenoeke. ");
INSERT INTO bbb_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","46","E Isureroko bu ijiege rena ire boeje na kuariaeva ije re furikuva E Ireobo na Godi buone rena buina finoeke. Areme bu ijia vierafero nare daro none ijia Ijifiki gamia kaenamiana keke ruaevaro bu ijiege vierafedufuo. Ijadufuo maeje naeje naka E Ireobo Godi buone ijene. ");
INSERT INTO bbb_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Ro nine ine akesia ijia buvuana fata isekube ja ire udiki ifaejedufuo ije amaerifo. ");
INSERT INTO bbb_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ro ja amaerikuva baraeki fuone ro jiagado ije ni foti faeve (45) senitamita ijiege mina amaerifo. Ro una arire ijadufuo ni naeniti (90) senitamita ijiege mina amaerifo. Ro fata biruame guegue ijia ni gome bijianana amaeriga fuka besu ifedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Areme nine gorodi ijia abena ado ijiakiro ikene ro gome fuone boeje kamafo. Ja ijiege re areme nine gorodi gue kena fata ijadufuo ubae irifo ijene kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Areme nine kuke gorodi ijia rini tiki inokiro kiro inokiro amaeriana ke fata biruame ijadufuo rotire guegue ijia kiriaekina ja giene kena ijia uniana gie oenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Ro giene fuone ije ni ine akesia ijia buvuana amaeria areme gorodi ijia abena foteke kamafo. ");
INSERT INTO bbb_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Ro fata ije ja ire udiki ifaejedufuo ije ni abena Mavua Akae ije bu nijana ugone ijia kirakuraeva ijadufuo uine ijia nijafo. Ro naeje na mavua akae ijadufuo biju bu kua Mesi Sitino kuavo na ijia e ijiebuo ise giana arevo ijia ja biediake. ");
INSERT INTO bbb_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","Ro maza boeje suoke Eroni fu ire raete bu naovo ije amaeriakiro aru ruomo ijia fuka ire udi mukore urivo ije kena ifaejega bu udi uridufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Ro mufuo fu una kuke raete ije kara ifaejekiro ruomo ije fu besu ijiege redufuo. Ro Eroni fu ire udiki ije fu ifaejemo ije fu arekuma baki ro fuka maza boeje uifari fuone bu rade urivo ijena ijiege rekinu vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Ro fata ije jabe fanu ro kumune ro vaeni safine bino ijia usiana zinone ifaejekiro nime ire udiki ijiaru ifaejedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Ro juaevasia besu guove ijia Eroni fuka fanuve ije bu abena ise ijadufuo zinone ifaejeva ijadufuo kavuane gue vesena fata ijadufuo gome guegue ijia usiakina buka maturaedufuo. Ro kuke uifari fuone bu rade urivo ije bu duaku buka juaevasia besubesu ijiege rekinu vadufuo. Ijadufuo maeje fata ije fu E Ireobo none ijadufuo fuka ma akaeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","12","Areme E Ireobo fu una Mosisi kuae, Maza ije a aesakae Isurero guove ijia e danoeno ijia ni e besubesu kuaga fuka izege fu rade ma fi vadufuo ijadufuo una E Ireobo na mani fuaeveno kuae. Buka ijiege rekina maza ije bu e danoevo ijia fube irufui bino biediake. ");
INSERT INTO bbb_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","14","Ro e besubesu eranebe juaevasia buone fu tuaedi (20) ijiege furi ro bio vaeva ive buone ije bu buki e davo ijia isoeva ije buka mani izege e mamekanu bu kuaena nijavo ijene fuaevedufuo. Ro e boeje moni ije bu fuaevevo ije bu E Ireobo na vajieve. ");
INSERT INTO bbb_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Ro moni ije bu E Ireobo na fuaevedufuo ije buka buone izege bu ma karivadufuo ijadufuo fuaeveke. Ro moni ije bu fuaevedufuo ije e sinuome zaraeva ijiakiro e sinuome baki ije boeje buka besu enafuna fuaeveke. ");
INSERT INTO bbb_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Ro moni ije bu fuaevevo ije ni karikina ja kena Are Muvuaka Akae na fivo ijene samuakinu vadufuo. Ro moni ije bu karivo ije fu jone ja ma karivadufuo ja ijene fuaeveje. Ja ijiege rekina na ijia giana oemarekinu bu samuagiano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","18","E Ireobo fu Mosisi ijiege kuara areme kuae, Nine ire buronisi ijia abena disi dibueki bu umui sodufuo ijene amaeri. Ro a amaerikuma ni abena Are Muvuaka ro fata zinone ifaejevo ije ukua ijia nijana do jiana ijia usiane. ");
INSERT INTO bbb_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","20","Do ije abe ijia nijaekina Eronikiro anafa fuone bu ijia umuikiro dia buone sodufuo. Areme rade bu Are Muvuaka ijia aruna E Ireobo ijadufuo nidua ro fata ijia zinone ifaejedufuo. Bu maza boeje buka ijiege rekinu vadufuo ro bakuma naka kaniaga bu oedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Eronikiro anafa fuone buka umuikiro dia tare buone soekina bube oeke. Ro akae ije fu ijiege naga Eronikiro uifari fuone buka maza boeje ijia nuvena renoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","23","E Ireobo fu ijiege Mosisi kuara areme kuae, Ni ire udi mukore urimo ijiakiro ia be bu kua meno kuavo ijadufuo safine irufui fuone sigisi (6) kiro ijiege vesene. Areme ni kuke ire sinamoni udi mukore urimo irufui fuone tire (3) kiro ijiege abene. Ro kuke ire keini udi mukore urimo ije irufui fuone tire (3) kiro ijiege abene. ");
INSERT INTO bbb_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","25","Areme nine kuke ire kasia irufui fuone sigisi (6) kiro ijege abe areme ni ine orivi oere butoro fo (4) ijiege karine. Ni ire boeje karina besu biemaroma areme abena ire oere akae udi mukore urimo bu e nigofo usiaejiana daro miavo ijene amaerine. ");
INSERT INTO bbb_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","28","Areme nine oere akae ije abena Are Muvuaka Akae na fivo ijiakiro mavua akae ijiakina fata ro sinuome fuone ro ire bu kedoro ifaeje navo ijiakiro sinuome fuone ijiakina fata ije bu ire udi mukore urimo ifaejevo ijene usiaejiakinu daro miane. Ro kuke ni fata ije zinone ifaejevo ijiakiro sinuome fuone boeje ijiakina disi bu ijia umui ro dia sodufuo ijene oere akae ije usiaejiakinu daro miane. ");
INSERT INTO bbb_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Ire boeje are guove ijia noavo ije nika kena ijiege daromiaekina buke ma akae redufuo. Bu ijiege akae rekina e ro ire bino bu sinuome ije niriakiakuva budua buka akae redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Areme nine kuke oere akae ije abena Eronikiro anafa fuone nigofo ijia usiaejiana daro miaekina bu e zinone ifaejevo rena noefuo imenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Areme nine e Isureroko ije kuariana kia, Oere akae ige ja uifari jone bu rade urivo ijena abe ijiege e nigofo usiaejiana daro miaga bu noefuo imenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Ro oere ije jade abena ire isekuma binobino ijene usiaejiakinu ro e mujue ije usiaejiavo. Ijadufuo maeje oere ije fuka ma akae ijadufuo abe mukoreigia samuakiro kuke jade oere ni ijieki bino jone amaeriavo. ");
INSERT INTO bbb_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Ro erare fu oere ijieki bino amaeriana ke e bu zinone ifaejevo baki ije aziriakuma e ijiege renoevo ije bu e none bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","35","Areme E Ireobo fu kuke Mosisi kuae, Ni ire udiki gue karina ire udi mukore urimo ije be amaerine. Ro ire ije a kena amaeridufuo ijeja ine murine ijiakina ire suvuame igeki onikano kuavo ijiakina ine garubami surive ijiakina ine faranikisenisi ijene. Areme ni e oere udi mukore urimo ije amaeriamo be kuaga fu ire boeje karina oere udi mukore urimo ijene amaerine. Areme ni soro abena ijiakuma usiana amaeriga fuka ni mukore ro ka akae redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Ni ire udiki bu amaerivo fu girema ije fae be abena mune ijia matuma arega fu kuokuo refo. Areme ni abena Are Muvuaka ije na ja biediavo ijia aruna Mavua Akae ije namo uineke ijia jijiakorefo. Ro ire ije fuka mukore ro ka ire akae jone ijadufuo ni abena vame maeje ijia renoekinu samuafo. ");
INSERT INTO bbb_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Ro kuke jade ire udi mukore urimo ijieki bino jone amaerivo. Ijadufuo maeje ire ije fu E Ireobo ijadufuo nidua ijia fuka ma akae. ");
INSERT INTO bbb_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Ro kuke erare fu ire udi mukore urimo ijieki bino amaeriana ke udi fuone maeje fu urimo ijene rifienoeno e ije fube e none rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","3","Areme E Ireobo fune kuke Mosisi kuae, Nane e Judado agane guove ijia e Uredo asae ro e Urido fari Bezarero ijene Kavene Akae ije abe nujaejana daro mae. Na daro ije fu izege ire boeje mukoreigia vierafedufuo ijiakina ire binobino mukoreigia amaeriake fu ijanaridufuo ijene mae. ");
INSERT INTO bbb_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Na daro ije maedo fure fina ire binobino fu izege amaeriadufuo ije isoena naekina fu ijia giakinu ire gorodi ro siriva ro boronizi ijia karina ire binobino amaeriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Fu ijiege rekinu mune ni mukore ije atana ire binobino ka mukore ije amaeriakinu ro ine buvua karona ire binobino amaeriakinu ro ire ni binobino uruvana amaeriake. ");
INSERT INTO bbb_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ro kuke na e Denido agane guove ijia e Aisimasido fari e Oriabi daro mana kuaedo fu e Bezareroki besu imenoeke. Ro kuke na e bino duaku daro ma ireobo miaedo bure ire binobino mukoreigia amaeriadufuo. Ijadufuo bure irere boeje bu amaeriadufuo na kiaeva ijene amaeriake. ");
INSERT INTO bbb_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","E ijiebe Are Muvuaka Akae na finoedufuo ijiakiro mavua akae ijiakina biju fuone bu kua Mesi Sitino kuavo ijiakiro ire binobino Are Muvuaka guove ijia amaeriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","9","Ro ire gue bu amaeriadufuo ije bu fata ijiakina sinuome fuone ijiakiro ire bu kedoro ifaeje nadufuo bu gorodi ijia amaeridufuo ijiakiro sinuome fuone ije amaeriake. Ro be ije bu fata ije bu ire udi mukore urimo ijiakiro fata ije bu zinone ifaejedufuo ijiakina sinuome fuone ije amaeriake. Ro be ije bu disi bu ijia umui ro dia do sodufuo ijiakina ire ije disi fare manidufuo ije amaeriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","Ro be ije bu sinuome ije e zinone ifaejevo bu savo ije Eronikiro anafa fuone bu sana i ije zinone ifaejevo ije medufuo ijene amaeriake. ");
INSERT INTO bbb_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Ro be ije bu oere ije bu e nigofo usiaejiana daro miavo ijiakina are akae ijadufuo ire udi mukore urimo ijene amaeriake. Ro ire boeje bu amaeriakuva buka mukoreigia izege na kuariaeva ijiege vierafekinu amaeriano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","13","E Ireobo fu Mosisi ijiege kuarama areme kuae, Ni e Isureroko ije kia mazani ije mauike karijo ije fuka mazani akae ro kuke fu mazani none. Ijadufuo buka mazani ijene abena mukoreigia samuadufuo. Ja mazani ijene abe ijiege samuavo ijia ja vierafero nana Godi jone ro jaeje ja e none ro ja ijiege vierafeke. Ro kuke ja vierafero na E Ireobo nare ja kena e akae revaro ja ijiege vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","15","Ijadufuo mazani ije mauike karijo ije nika abe mukoreigia samuafo. Ijadufuo maeje mazani ije fuka mazani akae. Ijadufuo e be erare fu mazani ijia imenoekinu abe arafirikuma e ije nika kanaga fu baronefo. Ro ja imenoekuva ni mazani sigisi ijia imenoekiro mazani seveni ije fuka mazani none akae ijadufuo ja mauike karidufuo. ");
INSERT INTO bbb_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Ijadufuo e Isureroko ije nika maza boeje mazani ije abena mukoreigia samuakinu vafo. ");
INSERT INTO bbb_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Na E Ireobo na mazani sigisi ije na abena sakae igiakiro saove gufe amaeriae ro mazani seveni (7) ije na naebe imei ro name mauike fi. Ijadufuo ja maza boeje ijiege rekinu vako ijia ja una izege nare jaena mazani mauike karivo ijadufuo kuaena mareva ja ije vierafekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Godi fu uruo Saenae ijia vua ijene Mosisi kuarama furi areme fu urina mune fae inokiro fu umui fuone ijia akae ije isoema ijene kena Mosisi vajae. ");
INSERT INTO bbb_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Areme E Isureroko bu gake Mosisi fu uruo ijia ajia vaema fu naebe migegire ari romoga bu samua kariba urina Eroni fino ijia afui. Areme bu urina kuae, E ige fu Ijifiti ijia no kaenamuona ruaema ije fu iziebureki irere abeno ije noka naebe vierafei. Ijadufuo no vierafe aka nuvuefuo godi be amaerikina fure no kaenamuona vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","E Isureroko bu ijiege kuaravoga Eroni fu urina kiae, Ni ire ije bu gorodi ijia amaeriava ije bararafa jone ijiakiro anafa ro kabaerafa jone bu adane ijia kuriaeva ije boeje karina ro vajieno kiae. ");
INSERT INTO bbb_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Eroni fu ijiege kuariamoga e boeje bune uri rini ije bu adane kuriaeva bu ire gorodi ijia amaeriaeva ijene karina ro Eroni vajae. ");
INSERT INTO bbb_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Bu karina vajavoga Eroni fu ire ijene karina ifaejemo fune firaemoga fu kena mave-kau ame ije gorodi ijia amaeri. Fu amaerima furinoga e Isureroko ijiebuo e mamekanu ije bu urina e boeje kiae, E Isureroko igie, ja Ijifiti ijia karinoevoga godi ije fu ja kaenamiana keke ruaema godi ije ijifurekino kiae. ");
INSERT INTO bbb_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ijadufuo Eroni fune vua buone ije fie areme urina mave-kau ije fu gorodi ijia amaeri saema uine ijia fata zinone ifaejedufuo ije sae. Fu ijiege sama areme fune urina E Isureroko ije kiae, Isuome noka E Ireobo nuvuone aguaena iro ikono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Fu ijiege kuariamoga nituame bune suoke mugamia urina fanuve bu zinone ifaejedufuo ijiakina gue bu besu afui ire ina Godi oemarejadufuo ije kena ruae. Areme e ije bune karina iro ijene i rove iro ije bu dabe una ni be i. Bu ijiege rena do kugi ikinu baru bara fudaenamina vame ise ije renoe. ");
INSERT INTO bbb_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Bu ijiege revoga E Ireobo fu urina Mosisi kuae, E none ije a gamia Ijifiti kaenamia ruaema ije buneka ire ise rena na ijuoneve. Ijadufuo ni migegire una ari vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","E ije buneka vua irere na kuariaeva bu ijia nuvediana kenoevo baki. Ro buneka migegire arena una godi buone be ire gorodi ijia amaeriva ijene fuone zinone ifaejekinu kafiafirive. Bu ijiege rekinu kuaevo fune godi buone bu gorodi ijia amaeriva ijare Ijifiti gamia bu kaenamia kekena ruaemano kuaeve. ");
INSERT INTO bbb_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Na e Isureroko ije bu irerefuo oe buone ije buka gikikimana revo ije nane giana vierafei. ");
INSERT INTO bbb_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ijadufuo naka defarudiedo na kaniaga buka bakireke. Ijadufuo ade na bijukuriemo. Na ijiege kania furi areme na una a ro uifari one ijiaru daro miaga buka ma e uruvana rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Rove Mosisi fuka una e Isureroko ije vafaena buefuo E Ireobo Godi fuone kuae, E Ireobo aka daro one ma ireobo ijia a e one bu Ijifiti ijia kariva ije karauniamoga bu usiae ruae. Ro a irerefuo aka una e one ije ireobo ziegafiame? ");
INSERT INTO bbb_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","A e Ijifitiko ijiebe kuaeko a e one ije kaenamiana keke nafare ijia kaniana kame uinitukiro vaemano kuaedufuo ije abe vierafe? Ijadufuo a ziemo ije arekiro nime una oe dasu vierafe areme vame ije a e one ijiebuo rekuveno ije arene. ");
INSERT INTO bbb_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Ro ni e one mamekanu e Eburamekiro Aeseki ro Jekafu ije vierafene. Ni vua izege a buina kuaena kia na uifari jone ka ma uruvana vajiaga bu ire zuvi ije saove gufia irevo bu davo baki ijiege rekono kiaema ije vierafene. Ro kuke a kia, Na aesakae ije miaga bu buone abena ijia kari vakono kiaema ije vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mosisi fu ijiege kuaramoga E Ireobo fu ijia una oe dasu vierafe areme ise ije fu e fuone ijiebuo rekiro kuaema ije fu ijarei. ");
INSERT INTO bbb_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Areme Mosisi fune uri mune fae inokiro ije Godi fu akae fuone isoema ije kena una ari ruae. ");
INSERT INTO bbb_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Ro mune ije fune Godire korufuo adiana amaeriakinu akae fuone ije ijia isoe. ");
INSERT INTO bbb_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ijiege rena Mosisikiro Josua bune uruo ijia una ari ruovo ijia Josua fu fieke e ije bu unia saeva ije bu vijekinu omanivo fu fie. Areme fu una Mosisi kuae, E game no unia ruaeva ije na fie buka bue bijaevo na fievano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Ro Mosisi fu una gue kuae, Na vierafega bu ebe kaniakuriaga bu subi vakinu vije ro niraevo baki ro kuke bu e kaniakuriana oemarevo baki. Ro na fiega buka dua uruna oemarevo na fievano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Areme Mosisi fune ruoma ivuarema ijia fu mave-kau ame ije bu gorodi ijia amaerina saeva ijiakiro dua ije bu uruvo ije giamo fuka ireobo defarui. Ijadufuo fu urina mune inokiro ije fu kena ari ruomo ije kame uruo zinume ijia koremo bu arina tuasei. ");
INSERT INTO bbb_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mosisi fuka ireobo defaruimoga fu urina mave-kau ame ije bu amaerina saeva ije nafena dabe miane ifaeje. Fu ifaejemoga ire ije fune una firaemo fu abena mutumoga fu una kuokuo rei. Areme fune do jiana ijiakuma biemaroma areme fune e Isureroko ije kiamo bu jiana i. ");
INSERT INTO bbb_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Fu ijiege rema areme urina Eroni kuae, E ige bu irere abeva ijadufuo a arekoga bu urina ire ka ise ije revano kuae? ");
INSERT INTO bbb_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Mosisi fu ijiege kuaramoga Eroni fu una kuae, E ireobo none ade na ziegafiemo. Ijadufuo maeje buneka e ijiebe korubuo iserekuae vierafenoevo ije ane giana vierafe. ");
INSERT INTO bbb_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bu kie, No e ige fu Ijifiti gamia kaenamuona keke ruaema ije fu izerema ije noka naebe vierafei. Ijadufuo ni godi be nuvuefuo amaeriga fure no samuaguono kie. ");
INSERT INTO bbb_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Ijadufuo na kia, Ni erare ire gorodi buone bu savo ijene bino nakuva ni kena rono kiavoga e ije naeva ije bu kena vajie. Bu vajievoga na karina miane ifaejema arevoga mave-kau ame ije fume korufuo ijia urimano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Areme Mosisi fu gake Eroni fu e ije naebe mukoe samuagiako bune e ani buone ijiebuo nidua ijia korubuo ive buone kame arafiranamina una ire ise ije renoevo fu giae. ");
INSERT INTO bbb_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Ijadufuo fu va are bu sana kariva viene ijia manina urukeigia vijena kumei. E ije erarebe ja vierafega ja Godido akaegue ijia irekuva ni ige na manivo ijia ruano kumei. Fu ijiege kumenoga e Rivaeti boeje bune usiaena fu manino ijia afui. ");
INSERT INTO bbb_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Areme Mosisi fu urina kiae, E Ireobo e Isureroko ijiebuo Godi ije fu kume, Ni sime jone kena una are gafia vakinu uviarafa jone ijiakina kairafa jone ro e jaena ivuake ijia karijo ije kaniana vakuma ubine gafa gue ijia furino kumemano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Fu ijiege kuariamoga e Rivaetiko ije buka ve ijia Mosisi irinana uri e tiri taoseni (3,000) ijiege kaniavo bu oe. ");
INSERT INTO bbb_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Areme Mosisi fu urina e Rivaetiko ije kiae, Iviama jane kojo kena e akae re ijadufuo maeje jaka Godi irinana anafa ro uviarafa jone jaka kaniae. Ijadufuo E Ireobo funeka ivia ja daro miaemano kiae. ");
INSERT INTO bbb_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Areme nituame Mosisi fune urina e Isureroko ije kiae, Jaeje janeka ise ma ireobo rei. Rove iviama na una uruo ijia ajia va E Ireobo ijiaki vua kuaeke vake. Na va fuosiki vua kuaega fu marekuma fu bite ise jone giana arekono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Mosisi fune ijiege kuariana fune una uruo ijia ajiana E Ireobo ijiaki vua kuaekiro vae. Fu va E Ireobo ije biena kuae, E game buneka ise ma ireobo ijene rei. Bune godi buone be ire gorodi ijia amaeriana buone baname isoekinu kafiafiriae. ");
INSERT INTO bbb_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Ijadufuo E Ireobo a isekie ni ise buone ije giana arene ro a bakuma ni ive none ije a buki ije e one ijiebuo ive a isoema ije masi akoejieno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Rove E Ireobo fu una kuae, Ije ane ma kuarieme rove na vierafe name e ije erare bu none ise reva na ive buone ijiaru masi koreke. ");
INSERT INTO bbb_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Ijadufuo ni una va e ije kaenamiana keke are na kuaraeva ijia vane. Ro igia fie ja vakuva anera none fu ude vakinu ja samuagiadufuo. Ro maza ije na bu kena isekafiadufuo ije fu uria ijia name. Ijadufuo na va maza ije abekuva na ijia sone e ije eranebe bu ise revo ije na ijia ise buone ijadufuo kame isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","E Ireobo fu Mosisi ijiege kuarama areme fune adame ni be ije kuamoga fu e ijiebuo ruae. Ijadufuo maeje bu korubuo mave-kau ije bu Eroni kuavoga fu gorodi ijia amaerima ijene abe una godi buone igege baname isoekinu kafiafirivajadufuo fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Areme E Ireobo fu una Mosisi kuae, Nine urina e one a gamia Ijifiti kaenamia ruaema ijena are ige arena vane. Nine e one ije kaenamiana uri aesakae ije na e Eburamekina Aesekina Jekafu ro uifari buone ijena miako kiaeva ijia vane. ");
INSERT INTO bbb_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ro igia fie a vakuma nare anera none be kuaga fu ude vakinu ja samuagae. Fu ijiege samuagakinu vakega nare kono e Amoraetiko ijiakina e Kenanaetiko ro e Itaitiko ro e Ferisaetiko ro e Ivaetiko ijene ro e Jebusaetiko ije kaniakuriake ja are buone ijia urana vake. ");
INSERT INTO bbb_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Ro aesakae ije ja abeke vako ije fuka saruegi ro kuke fuka ire uruvana zaraemo. Rove na kono nabe jaena vake. Ijadufuo maeje jaeje jaka e nigofo gikikimana vua mukoe fievo baki. Ijadufuo na jaena vakuva na bigake vame ijia kaniaga ja oe furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","E Ireobo fu vua ijiege e Isurero kuariamoga e ije bu vua ije fiena buka uruvanaigia niraena oefiane abei. Areme rade bu naebe una uniae bino uro buone ijia kiriae. ");
INSERT INTO bbb_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Ijadufuo maeje E Ireobo fune ude Mosisi kuriaerena kuae, Ni e ije kuariana kia nigofo buone buka ma gikikimana. Ijadufuo na maza aokube buina vakuva na bigake vame kania bu oe furike. Ijadufuono ni kia bu uniae tamae buone bu uro kiriavo ije iraga na ijia sone izege na buone redufuo ije vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Ijadufuo maza ije e Isureroko bu Uruo Saenae arena vakuvejo ijia bu naebe una uniae tamae buone ije uro ijia kiriae. ");
INSERT INTO bbb_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Ro e Isureroko bu vakuma iziebure bu naokuae are amaerivo ije Mosisi fune are isekube sibaneke mumabo ijia samo. Ro are iseke ije bu kua, Are Vua Kuaevono kuavo. Ijadufuo e be erare vierafe fu E Ireobo ijiaki vua kuaekiro vierafemo ije fu ijia vako. ");
INSERT INTO bbb_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Ro maza bino Mosisi fu kekena are ijia vako ije e Isureroko bu usiaena are buone viene ijia irena gako fu vakuma are iseke guove ijia aru vako. ");
INSERT INTO bbb_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ro maza ije Mosisi fu are guove ijia aru vako ije amite ka maduibo ije fu arina are iseke viene ijia namo. Fu ijia nakoke E Ireobo fu amite uve ijia Mosisi vua kuaramo. ");
INSERT INTO bbb_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Ro e Isureroko boeje bu amite ije fu arina are ijadufuo viene ijia naga bu gavo ije buka kurituakafakinu aoge sana baname isoevo. ");
INSERT INTO bbb_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Ijadufuo maeje E Ireobo fuka e be fu kai fuone ije uikubae guria ganamikinu vua kuaevo ijiege E Ireobo fuka Mosisiki uikubae guria gananamikinu vua kuaevo. Bu kuaema furivone Mosisi fu una keke are fuone ijia vako. Ro e Nanido fari Josua e ije Mosisi ifejamo ije fu uria are ijia fino. ");
INSERT INTO bbb_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Areme Mosisi fu urina E Ireobo ije kuae, E ige na kaenamia aesakae ige na ruaeva ije ane are ma kiemoga na kaenamia ruae. Rove e ije bu eranebe naena vadufuo ije a naebe kuarie. Rove a kie na ive one ije nane gana vierafe ro kuke a na giemone fuka oemadamono kie. ");
INSERT INTO bbb_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ijadufuo ane ma none oemarekuma ni iviama vame one a vierafena kemo ije nijasiene. A ijiege nijasiekina na a mukoreigia gana vierafe areme na maza boeje izege a oemadadufuo ije vierafekinu vane. Ro kuke E Ireobo e ige buneka ma e one are koro kema ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Ro E Ireobo fu una kuae, Mosisi na vierafe naka kono osiki vakinuro daro maga a e ani one ije iraraena asidiaekina a oemarekinu dazena finoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Fu ijiege kuaramoga Mosisi fu una gue E Ireobo kuae, A vierafe a naebe noena vakiro vierafekuma ade kuoga no are ige arena vano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ro a naebe noena vakuma e bu izege a gana vierafero aka no mukoreigia oetuana samuaguomoro bu ijiege vierafeke. Ijadufuo anika noena vaekina e bu noeje buka e ni bino guokiro e ume igeko ije bu ni bino giano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Rove E Ireobo fu una Mosisi kuae, Na vierafe naka ije a kuariemo ijiege redufuo. Ijadufuo maeje aeje nane mukoreigia gana vierafe ro kuke izege a renoeno ije na gaga naka oemadiemono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Fu ijiege kuaramoga Mosisi fu una kuae, E Ireobo a isekie na vierafe naka sanaema one anuigi ije gakiro vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Rove E Ireobo fu una kuae, Na vierafe naka kono ude vakinu vame none maeje izege na kevo ije nijasake. Ro kuke na nidua one ijia ive none E Ireobo ije abe samadukua kuaraga a fieke. Naeje na E Ireobo ijadufuo na e izene giana oefiane abekuva na ijiege redufuo. Ro kuke na e izene ma rejiakiro vierafekuva ije na ijiege redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Ro na uikubae none ijiaru nabe abena a nijasake ijadufuo maeje e ije bu uikubae none gievo ije buke oevo. ");
INSERT INTO bbb_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Rove na manivo ikene ige fu munuage be igifureki ijadufuo ni ro munuage ado ijia ajia manine. ");
INSERT INTO bbb_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","A ijia ajia manike na sanaema none ijiakuma asida vane. Ro aeje na abe munuage tire ijia nuja areme umui none ijia niome one ije okuriaga a ijia fike na asida vake. ");
INSERT INTO bbb_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Areme na una umui none abe vake a ijare ijuone none ijiaru giekiro uikubae none abe gadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Areme E Ireobo fu una Mosisi kuae, Ni mune fae a ude kema ijieki inokiro kaniatuana adia amaeriaekina na ijia vua irere na ude mune ijia isoevoga a kena tuasema ije una ijia isoene. ");
INSERT INTO bbb_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ijadufuo nine kanafui samuaekina isuome suoke a uruo Saenae kubi ijia ajiana na biediene. ");
INSERT INTO bbb_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Ro mave-sifi ro kau bino bube uruo zinume ijia vajoma inoevo ro kuke e bino bube uruo ijia ajia oenoevo. Ro e bino bube aena uruo ijia ajia ruovono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Ijadufuo Mosisi fune mune fae inokiro binodua kaniatuana adia amaeriama areme nituame suoke fune izege E Ireobo fu kuaraema ijiege rena fune mune fae inokiro ije kena uruo ijia ajia vae. ");
INSERT INTO bbb_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Fu ijia ajia vakoga E Ireobo fu amite uve ijia una arina Mosisi manino ijia fuosiki mani. Fu ijia mani areme uri ive fuone ije kuranamina kuae, Naeje na E Ireobo nareno kuae. ");
INSERT INTO bbb_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Areme E Ireobo fune Mosisi manino uine ijia asina vakinu urukeigia kuae, Naeje na E Ireobo ro Godi ije fu e giana oefiane abekinu marejiamo ijene. Ro kuke na migegire defaruivo baki. Ro kuke naka maza boeje e oetuakinuro irere na rekiro kuaevo ije na arevo baki. ");
INSERT INTO bbb_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Na e uifari taoseni ije bu ise buone ijia oe kuderiavo ije naka uria bu oetuakinu ise buone boeje giana areke. Rove eranebe bu uria ise rekuae vierafevo ije nabe giana aredufuo. Ro naka uria orafa buone ijiebuo ise bu reva ijadufuo anafa buone ijiakina asaerafa buone ijiakiro uifari buone rade urivo ijene kame isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","E Ireobo fu vua ijiege kuaemo Mosisi fu fiena migegire tuana ume ijia dijena Godido baname isoe. ");
INSERT INTO bbb_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Fu Godi baname isoena kuae, E Ireobo ane ma na giega fu oemadavoga a isekie ni urina noena vane. E Isureroko ige buka nigofo gikikimana rove ni vame nuvuone no isema kenoekinu ise revo ije guona arekiro kaenamuoga no una e one renokuae. ");
INSERT INTO bbb_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Areme E Ireobo fu una Mosisi kuae, Na iviama na e Isureroko ijiebuo vua be buina kuaena abe mareke. Na nidua buone ijia ire sumiki mamekanu bino na naebe ude e umeigia kariva ijiebuo reva ijieki bino reke. Na ire ije rega e boeje bu jaena karinoevo ije bu ni buone ijia E Ireobo daro none na joefuo ire ije revo bu ijene giake. ");
INSERT INTO bbb_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Ijadufuo ni vua irere boeje na ivia kuariavo ije mukoreigia iriniana renoefo. Ja ijiege iriniekuva nare joefuo ude vakinu e Amoraetiko ijiakina e Kenanaetiko ijiakina e Itaetiko ro Ferisaetiko ro e Ivaetiko ro e Jebusaetiko ijene kaniakuriakinu vake ja rade vuake. ");
INSERT INTO bbb_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Ro igia fie mazani ije jane vakuma aesakae ijia ura vako ijia jade e ijieko ije bino kai revo. Ro ja bu kairekuva buka ja biesiriana kaenamiaga ja una godi buone baname isoekinu ire ise bino redufuo. ");
INSERT INTO bbb_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Ijadufuo ja aesakae buone ijia ura vakuva ni fata buone bu zinone ifaejevo ije farae korefo. Ro kuke ni ire buone boeje bu kena ma vierafekinu kurituakafiana baname isoevo ijiakiro godi kufui buone ijene kame kania tuasekinu matusefo. ");
INSERT INTO bbb_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ro jade godi buone binobino ije kame aroriana kurituakafiakinu buone baname isoevo. Ijadufuo maeje E Ireobo naeje na godi kufui ije bu na asidiana oe jone ije samuagiavo ije naka ma ireobo ijuonevo. ");
INSERT INTO bbb_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","Ijadufuo jade e aesakae ijeko bino kai revo ijadufuo maeje bu oenoene godi kufui buone ije baname isoekinu zinone ifaejekuva buka kiaga ja bu ifejiadufuo. Ro kuke bu kiaga ja ire ije bu godi kufui ijiebuo zinone ifaejevo ije bino kame idufuo. ");
INSERT INTO bbb_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ro kuke ja bigiake anafa jone ijiebe kabaerafa buone ije bino kega bara ijiebe farirafa jone ije kame oe kuderiaga bu va godi kufui buone ijiebuo baname isoekinu kame aroriadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","Ro jade oenoene ire gue kame godi igege amaeriana buone baname isoevo. ");
INSERT INTO bbb_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","Ro igia fie ni na kuariaeva ijiege Iro Ije Burete Isiti Bakino kuavo ijadufuo iro ije ja ivo ije nika juaevasia besubesu ijiege ikinu vafo. Ro ja oenoene iro ije ikuva ni asame Abibi guove ijia mazani seveni ijiege abena ifo. Ijadufuo maeje ja asame Abibi ijia Ijifiti arena usiae ruae. ");
INSERT INTO bbb_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","20","Ro igia fie ame fari jone amuifari ijiakiro mave-sife ro kau ijiebuo ame kumate amuifari boeje buneka none. Ro ja mave doniki kumate amuifari ije ja una jone kekuae vierafekuva nine mave-sifi ame ijia abena una ijadufuo na zinone ifaejiefo. Ro ja fanu doniki ije ja naebe una abekuae vierafekuva nime fare kuri dasubifo. Ro ame fari amuifari ije ni una jone kaenamiafo. Ro ja oenoene una nidua none ijia na baname isoekuae ruovo ije jade ikiriasana ruovo. ");
INSERT INTO bbb_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Ro maza ije ja imenodufuo ije jane mazani sigisi (6) ijiaru imenoeke. Ro mazani seveni (7) ije nika abena mauike karikiro jade mazani ijia juare mekinuro kuke jade mazani ijia juare iviaeko masivo. ");
INSERT INTO bbb_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","Ro iro ije Uije Amure Masivono kuavo ijadufuo ije nika juaevasia boeje ijiege ikinu vafo. Ro kuke iro ije Are Muvuakano kuavo ijadufuo ije ni asame ije ja ire uije jone masivo ubine ijia ikinu vafo. ");
INSERT INTO bbb_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Ro juaevasia besu guove ijia e fari boeje nika ro E Ireobo e Isureroko ijiebuo Godi ige none maza inokubeke baname isoekinu aroriefo. ");
INSERT INTO bbb_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ja ijiege rekuva E Ireobo nare e boeje bu aesakae ije ja vakuvejo ijia kariva ije kaniakuriana aesakae jone ja karidufuo ije abe biona ireobo rejiake. Ro rade e boeje bu maza inokubeke iro ikinu E Ireobo Godi none baname isoevo ije fu erare una ja asidiana aesakae jone ijene abekuva baki. ");
INSERT INTO bbb_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","Ro ja na zinone ifaejiekuva jade burete ije ire isiti ijia amaeriva ije kena fanu kavuane ijiakuma na zinone ifaejievo. Ro fanuve ije ja kaniana Iro Fasova ivo ije bino jade kena suba navo. ");
INSERT INTO bbb_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Ro ni juaevasia besubesu guove ijia ire binobino ja juare jone ijia amure masivo ije nika karina ro E Ireobo ijadufuo are ijia nafo. Ro kuke jade mave-goti ame kaniana ke una asie fuone ijadufuo muije ijia vesena kira ivono kiae. ");
INSERT INTO bbb_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","E Ireobo fune Mosisi ijiege kuarama areme una kuae, Ni vua boeje ige na kuaraeva ijene isoene. Ijadufuo maeje na vierafe naka vua ijiebuo duvado ijia e Isureroko ijena vua kuaena avenamikiro vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Ijiege rena Mosisi fune mu foti ro maza foti ijiege fu E Ireobo ijiaki uruo ijia finoe. Ro maza ije fu ijiege finoema ijia fu ire ro do bino fuka naebe inoe. Ro maza ije fu finoema ijia fu mune fae ijia kena E Ireobo ijadufuo akae teni (10) fu e Isureroko vajiaema ijene isoe. ");
INSERT INTO bbb_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ro maza ije Mosisi fu mune fae ije fu akae teni (10) isoema ije kena una ari vaema ijia uikubae fuone fuka sanae rove korufuo fu naebe ganamina vierafei. Ro uikubae fuone ije fu ijiege sanaema ijadufuo maeje fu E Ireobo ijiaki vua kuaenoekoga sanaema fuone ijare fu abei. ");
INSERT INTO bbb_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Ijadufuo Eronikiro e Isureroko boeje bu Mosisido uikubae ije fu sanaema ije gavo buka dejudiamoga bu naebe fu ivuake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Rove Mosisi fu urina Eronikina e mamekanu boeje kumeno bu rovoga fu urina vua kuariae. ");
INSERT INTO bbb_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Areme rade e Isureroko boeje bune Mosisi manino ijia afuima areme karikoga fu urina akae boeje E Ireobo fu uruo Saenae ijia kuaraema ijene kuariae. ");
INSERT INTO bbb_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Mosisi fune vua boeje kuariama furi areme urina ugone ubine be abena uikubae fuone ije okurae. ");
INSERT INTO bbb_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ro maza bino Mosisi fu oenoeno are ije E ireobo fu fino ijia aru vako ije fu ugone ubine fu uikubae okuraema ije ira nija areme aru vako. Ro maza ije fu una keke ruomo ije fu vua irere boeje E Ireobo fu e Isureroko bu redufuo fu kuaraema ijene kuariamo. ");
INSERT INTO bbb_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Ro maza ije fu vua kuariamo ije E Isureroko bu gavone uikubae fuone fuka saname. Ro fu furimo ije fu una ugone ubine abe uikubae fuone okuramo ro fu una E Ireobo ijiaki vua kuaeke vako ije fu una ira nijamo. ");
INSERT INTO bbb_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","3","Ni safita 31:15-17 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","9","Ni safita 25:1-7 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Mosisi fu e Isureroko kuariae, Nine e jone erane bu ire binobino mukoe vierafekinu amaeriavo ije kiaga bu ire boeje Godi fu kuariaema ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Ro sinuome ije ja Are Muvuaka ije sadufuo ije ni fanu surive inokiro ja Are Muvuaka ije kirakuradufuo ijiakiro ire kimae igeki ijiakina isuo ro ine kakare kaniadufuo ijiakina tugiekiro ire ije tugie fadia iredufuo ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","13","Areme nine mavua akae ijiakiro giene fuone ijiakina biju fuone ro ugone ije mavua namo ije kirakuradufuo ijiakina fata ijiakiro giene fuone ro sinuome fuone boeje ro burete ije bu Godi vajadufuo ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","15","Areme nine ire raete tua kuriadufuo ijiakina sinuome fuone ijiakiro raete ro oere buone ije amaeriafo. Ro kuke ni fata ije ire udi mukore urimo ije ifaeje nadufuo ijiakina giene fuone ijiakiro oere bu e aziriana daro miavo ijiakina ire udi mukore urimo ijiakiro ugone ije Are Muvuaka viene kiradufuo ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","Areme nine fata zinone ifaejedufuo ijiakina fata iseke ije miane ifaejedufuo ire buronisi ijia amaeriva ijiakiro giene fuone ijiakina disi bu umui do sodufuo ijiakiro fata fuone ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","18","Areme nine ugone ije Are Muvuaka Akae ijadufuo makave ijia kira ufuaenoedufuo ijiakina ugone be ja viene ije kiradufuo ijiakiro tugie ro ire ije bu tugie ije faradia iredufuo ijene amaeriafo. Areme nine asuge ije ugone ubine mamafadiadufuo ijiakina kaje ja ugone ije kiradufuo ijene amaeriafo. ");
INSERT INTO bbb_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","Ja ijiege amaeria areme nine kuke ugone ni mukore e zinone ifaejevo bu sana are guove Ma Akae ijia imedufuo ijene amaeriano kiae. (Ro ugone ije bu Eronikiro farirafa fuone ijiebe sadufuo ijene). ");
INSERT INTO bbb_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","21","Mosisi fune E Isureroko ijene ijiege kuariama furinoga bune una are buone ijia vae. Areme e ije eranebe bu oemarekinu ire buone ije E Ireobo vajakuae vierafeva ije bune ire buone maeje boeje binobino bu Are Muvuaka Akae ije sadufuo ijene karina ruae. Bu sinuome boeje bu Godi baname isoekinu dua urudufuo ijiakina ugone ije e zinone ifaejevo bu savo ije amaeriadufuo ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Areme e boeje bara ro baru bune urina bidikina ada giborekiro umui rigi ro uniae binobino bu gorodi ijia amaeriaeva ijene karina E Ireobo zinone igege vajae. ");
INSERT INTO bbb_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Areme bune kuke uri ugone abaeki ni mukore ijiakina ugone bu mave-goti u ijia saguiva ijiakiro mave-sife surive bu kavuane amaeriaeva ro fanu surive ni mukore gue ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Bu ijiege karina ruakoga e ije eranebe oemarevo bu ire siruvakina buronisi ro ine akesia bu ire binobino amaeriadufuo ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Ro bara boeje eranebe ugone mukoreigia saguvo ije budua bune uri kaje ni mukore binobino kazine ro kavuane bu ufiva ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Bu ijiege kari areme kuke uri kaje bu mave-goti u ijia ufiva ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Areme e Isureroko ijiebuo e mamekanu ije bune mune bu kua onikisino kuavo ijiakina mune isesina mukore ka anuigi bu ugone ifodi ijiakiro ugone bu guge ijia savo ijia bijia kiriadufuo ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","E mamekanu ije bune ire ije kari areme uri oere bu raete ijia usiavo ijiakina oere ije bu sana e daro miavo ijiakiro ire udi mukore urimo ijene karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Ijiege rena e Isureroko boeje eranebe oemarevo ije bune urina ire buone mukore ni binobino ijene karina E Ireobo vajakuae ruae. Ro ire boeje bu karina ruaeva ije bu Are Muvuaka Akae ije Mosisi fu sadufuo E Ireobo fu kuaema bu ijadufuo karina ruae. ");
INSERT INTO bbb_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","35","(-) 35:30–36:7 Ni safita 31:1-11 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","38","(-) 8-38 Ni safita 26:1-37 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","29","(-) 1-9 Ni safita 25:10-22 ijia dane. 10-16 Ni safita 25:23-30 ijia dane. 17-24 Ni safita 25:31-40 ijia dane. 25-29 Ni safita 30:1-10 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","20","(-) 1-7 Ni safita 27:1-8 ijia dane. 8 Ni safita 30:17-21 ijia dane 9-20 Ni safita 27:9-19 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Ro maza ije bu Are Muvuaka Akae ije saeva ijia Mosisi fu e Rivaeti ije kiamoga bu sinuome binobino irere bu kena are ije saeva ijene isoe. Ro e Rivaeti ije bu Eroni e zinone ifaejemo ijadufuo fari e Itama ijare samuagiakoga bu imei. Ro Are Muvuaka Akae ije bu mune inokiro ije Godi fu akae fuone teni ijene isoena abe Mosisi maema ije bu gucve ijia nijavo. ");
INSERT INTO bbb_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Ijiege rena e Judado agane be e Erido asae e Bezarero e Urido fari ije fune ire boeje izege E Ireobo fu Mosisi kuaraema ijiege amaeriama furi. ");
INSERT INTO bbb_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Ro e Oriabi e Aesamakido fari fu e Denido agane be ijare uri fu e Bezarero ifejae. E Oriabi fuka e be ugone mukoe sagukinu ro ukie ni binobino mukoe isoemo. Ro ugone fu sagumo ije fu kaje kazine ro kavuane ijia kena ugone binobino sagumo. ");
INSERT INTO bbb_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","26","Ro e Isureroko ire gorodikiro siruva ro buronisi izege bu kena Are Muvuaka Akae ijene saeva ije ijiege. Ire gorodi boeje bu karina ruaeva ijadufuo irufui ije fuka eiti aderedi teti (830) kiro ijiege. Ro ire siruva ije bu tu taoseni eiti aderedi naenitini (2819) kiro ijiege karina vajae. Ro e Isureroko e fari boeje eranebe juaevasia tuaedi (20) asiva ije buka ma e uruvana (603,550) ijiege. Ro e besubesu bume ire siruva sibane isekube ijiege kena E Ireobo vajae. ");
INSERT INTO bbb_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Ro ire ije bu tugie Are Muvuaka Akae ijadufuo isuo ijiakiro faere ijadufuo tugie ije faradia iredufuo bu amaeriaeva ije besubesu bu ire siruva tuaedi eiti (28) kiro ijiege kena amaeriae. Ro kuke ire siruva boeje foteke irufui buone ije fuka tu taoseni eiti aderedi (2800) kiro ijiege. ");
INSERT INTO bbb_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Ro ire siruva nugune naenitini (19) kiro ijiege bu kena ire kimae igeki ijiakiro ire ije bu ugone ijia uniana kuriadufuo ijiakina tugie ijiebuo ubine amaeriae. ");
INSERT INTO bbb_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Ro ire buronisi bu karina E Ireobo vajaeva ije boeje foteke fuka tu taoseni fo aderedi tuaedi faeve (2425) kiro ijiege. ");
INSERT INTO bbb_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","31","E Bezarero fu ire buronisi ijene kena Are Muvuaka Akae viene ijadufuo ire ije bu tugie faradiana iredufuo ijene amaeriae. Ro ire fata ije bu zinone ifaejevo ijiakiro sinuome fuone boeje ije fu kuke ire buronisi ijia kena amaeriae. Areme fu kuke ire buronisi ije kena Are Muvuaka Akae makave ijadufuo faere ijiakiro viene ijiebuo ire ije tugie faradia iredufuo ijene amaeriae. Fu ijiege re areme uri ire ije bu kena ugone Are Muvuaka Akae ijia kiradufuo ijiakiro ugone be bu irifo ijia kiradufuo ije boeje fu ire buronisi ijia kena amaeriae. ");
INSERT INTO bbb_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Areme bune uri ugone ka ma mukore e zinone ifaejevo bu sana Are Muvuaka Akae guove ijia imedufuo ijene mave-sife u kavuane ro kazine ijia kena saguna amaeriae. Areme bune kuke ugone Eroni fu sana zinone ifaejedufuo ije Godi fu Mosisi kuaraema ijene amaeriae. ");
INSERT INTO bbb_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","31","(-) 2-7 Ni safita 27:6-13 ijia dane. 8-21 Ni safita 28:15-30 ijia dane. 22-31 Ni safita 28:31-43 ijia dane. ");
INSERT INTO bbb_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Areme e Isureroko ije bune izege E Ireobo fu Mosisi kuaraema ijiege rena uri Are Muvuaka Akae E Ireobo fu fidufuo bu sakuae amaeriaeva ijiakina sinuome fuone boeje ijene amaeriama furi. ");
INSERT INTO bbb_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Areme bune ire boeje karina ro Mosisi vajae. Ro sinuome fuone gue ijeja ire kimae igeki ijiakina isuo ijiakina ine kakare kaniadufuo ijiakina tugiekina ire ije tugie faradia iredufuo ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","35","Ro mave-sife surive kavuane ijiakiro fanu surive mukore be ijiakina ugone jiadadogo ijiakiro mavua akae ijiakina giene ro biju fuone ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","37","Ro kuke fata ijiakina sinuome fuone ro burete ije bu Godi vajavo ijiakina ire kedoro ifaeje navo bu gorodi ijia amaeriva ijiakiro sinuome fuone ijiakina raete ro oere fuone ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","Ro fata ije bu ire udi mukore urimo ije ifaejevo bu gorodi ijia amaeriva ijene. Ro kuke oere bu e aziriana daro miavo ijiakina ire udi mukore urimo ijiakina ugone bu Are Muvuaka Akae viene kiravo ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","Ro fata be bu zinone ifaejevo ijiakiro sinuome fuone bu ire buronisi ijia amaeriva ijiakina giene fuone ijiakina disi bu umui do sovo ijiakina fata fuone ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","Ro ugone bu Are Muvuaka Akae irifo ije kiradufuo ijiakina tugiekina ire ije tugie faradia iredufuo ijiakina ugone viene ijadufuo faere ije kiradufuo ijene. Ro kajekina asuge bu ugone ubine ivia faradiadufuo ijiakina sinuome boeje bu Are Muvuaka guove ijia nadufuo ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","Ro ugone akae ka ma mukore Eronikiro farirafa bu sana Are Muvuaka Akae guove ijia imedufuo ijene. ");
INSERT INTO bbb_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Ijiege rena e Isureroko ije bune izege E Ireobo fu Mosisi kuaraema ijiege ire boeje rema furi. ");
INSERT INTO bbb_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Areme Mosisi fune ire boeje bu amaeriaeva ije mukoreigia gianoena gake buneka ire boeje izege E Ireobo fu kuaraema ijiege amaeriaevaga fu giae. Ijadufuo fune urina e ijiebuo una Godido baname isoena daro miae. ");
INSERT INTO bbb_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","2","Areme E Ireobo fu Mosisi kuae, Are Muvuaka Akae ije a sadufuo na kuaraeva ije ni asame amure ijadufuo mazani amure ijia sane. ");
INSERT INTO bbb_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Areme ni Mavua Akae ije bu Godido akae teni isoena ijia abieva ijene abe guove ijia nija areme ugone abe kirakurane. ");
INSERT INTO bbb_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Areme nine fata ijene abe aru guove ijia nijaeme sinuome ijadufuo ije karina ijia nane. A ijiege kari naeme ni kuke ireraetitua nadufuo ije abe aru are fuone ijia nija aremeraetifuone ije ijia nane. ");
INSERT INTO bbb_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Ro nine fata ire udi mukore urimo ifaejedufuo ije ire gorodi ijia amaeriva ije abe are nijane. Fata ije abe aruna Mavua Akae ije namo ivuake uine ijia nija areme nine ugone abe Are Muvuaka Akae viene makave ije kirakurane. ");
INSERT INTO bbb_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Areme nine fata zinone ifaejedufuo ije abe aru viene ivuake ijia nijane. ");
INSERT INTO bbb_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Ro ni disi umui do sodufuo ije abe aru fata zinone ifaejedufuo ije guere ro isuo viene guerema ukua ijia nijane. Areme nine do jiana disi ijia usia fu iritoejene. ");
INSERT INTO bbb_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","A ijiege re areme ni ugone jiagadogo ije abena Are Muvuaka ijadufuo irifo ije kirakurane. Areme nine ugone viene ijia kiradufuo ije abena kirano kuae. ");
INSERT INTO bbb_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Areme E Ireobo fune Mosisi kuae, Nine Are Muvuaka Akae ijiakina sinuome fuone boeje ijene oere akae ijare abe jijiamadiane. A ijiege rekina buka akae rene. ");
INSERT INTO bbb_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Areme nine kuke fata ije zinone ifaejedufuo ijiakiro sinuome fuone boeje oere akae ijare abena jijiamadiane. A ijiege rega fata ijiakiro sinuome fuone buka akae rene. ");
INSERT INTO bbb_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Ro kuke nine disi bu ijia umui do sodufuo ijiakiro fata fuone ije oere abe jijiamadiaga buka ire akae rene. ");
INSERT INTO bbb_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","A ijiege re areme ni Eronikiro farirafa fuone ijene kiaga bu Are Muvuaka Akae viene ijia rone. Bu ijia roga ni kia bu doma ijia foteke ruoene. ");
INSERT INTO bbb_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","14","Areme ni Eroni kuaga fu ugone ije e zinone ifaejevo bu sadufuo bu saguiva ijene saejane. Areme ni oere akae ije abe nigofo fuone ijia usiaejaekina fu e zinone ifaejevo igege rena noefuo imene. Areme nine kuke farirafa ije kia bu roga seti ije saejiane. ");
INSERT INTO bbb_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Areme nine izege asoe buone ije a rejaema ijiege oere abe nigofo buone ijia usiaejiane. A ijiege rekina bu e zinone ifaejevo igege rena noefuo imeke. Ro a oere akae ije abe bu usiaejiaema ije buje buneka uifari buone ijena maza boeje i ijiege mekinu vadufuo. ");
INSERT INTO bbb_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Areme Mosisi fune urina vua boeje izege E Ireobo fu kuaraema ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ijadufuo juaevasia be ijadufuo asame amure ro mazani amure ijia Mosisi fune Are Muvuaka Akae ijene sae. ");
INSERT INTO bbb_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Mosisi fune zinuivena uri ire ije isuo faradia iredufuo ije kari nana oenoena areme uri isuo ijene karina ado ijia nae. Areme fune uri ine kakare ije kena bijianoena areme uri tugie buone ijene kena sae. ");
INSERT INTO bbb_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Mosisi fune ijiege nanaena areme uri fanu surive be bu Are Muvuaka Akae ado ije kiradufuo ije abe irana kirae. Areme fune una kuke fanu surive be ijene abe irana ado ijia akozena kirae. Mosisi fune izege e Ireobo fu kuaraema ijiege rena are ijene sae. ");
INSERT INTO bbb_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Areme fune uri mune inokiro ije Godi fu akae fuone teni isoema ijene kena Mavua Akae guove ijia sae. Fu ijiege re areme fune uri giene ijia kena Mavua Akae ijadufuo rini ijia uniana biju fuone ijia dabe bijui. ");
INSERT INTO bbb_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Areme fune Mavua Akae ije abena Are Muvuaka Akae guove are fuone ijia nijae. Areme fune izege E Ireobo fu kuaraema ijiege rena uri ugone abena are Mavua Akae fu namo ijene ka mukoreigia kirakurana bijukurae. ");
INSERT INTO bbb_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Areme fune fata be ijene abena Are Muvuaka guove ugone bu Mavua Akae ije kirakuraeva ije una ikene ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Areme fune izege E Ireobo fu kuaraema ijiege rena burede ije bu kana E Ireobo vajaeva ijene karina ijia nae. ");
INSERT INTO bbb_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Areme fune kuke uri ire raete ifaeje nadufuo ijene abe are Are Muvuaka Akae guove ijia nijae. Fu abe aruna fata ije namo ije gara gue ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Areme fune E Ireobo ijadufuo nidua ijia urina izege fu kuaraema ijiege rena raete ijene karina ijia nae. ");
INSERT INTO bbb_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mosisi fu ijiege re areme fune uri fata ije ire gorodi ijia amaeriva ijene abe aru guove ugone kiraeva ivuake ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Areme fune izege E Ireobo fu kuaraema ijiege rena uri ire udi mukore urimo ijene ke ifaeje. ");
INSERT INTO bbb_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","29","Mosisi fune uri ugone abena Are Muvuaka Akae viene ijia kirae. Areme fune uri fata zinone ifaejedufuo ije abe ugone viene ije kiraeva makave ijia nijae. Ro fata ije bu ijia fanu ro ire vuiti ro kumune ijene izege E Ireobo fu kuaraema ijiege rena zinone ifaejevo. ");
INSERT INTO bbb_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","32","Ro disi umui sovo ije fu abena fata bu zinone ifaejevo ijiakina Are Muvuaka Akae ijiebuo ukua ijia nijae. Areme fune uri do jiana usiamo fu iritoejei. Ro Eronikiro farirafa bu oenoena Are Muvuaka Akae ijia aruna va ro kuke bu fata ijia zinone ifaejevo ije bu izege E Ireobo fu kuariaema ijiege rena disi ijia umuikiro dia buone sovo. ");
INSERT INTO bbb_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Areme Mosisi fune ugone jiagado ijene dabe Are Muvuaka Akae ijiakina fata zinone ifaejevo ijadufuo faere makave irifo ije foteke kiranoena furi. Areme fune uri ugone jiagadogo ije abena makave ijadufuo viene bu aruvo ijene bijukurae. Areme Mosisi fune ire boeje rena vakuma furi. ");
INSERT INTO bbb_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","35","Areme amite ireobo ijare arina Are Muvuaka Akae ijene okurakoga E Ireobo ijadufuo sanaema ijare arina Are Muvuaka Akae guove ijia sanae. Ro ire ije fu ijiege remo ijadufuo Mosisi fu naebe Are ijia aru vae. ");
INSERT INTO bbb_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Ro E Isureroko bu karinoena amite fu una ajia vako bu ijare uri Are Muvuaka Akae ije faraena una are be vako. Ro bu gaga amite fu uria arina okuramo ije bu Are Muvuaka ije faraena vako baki. Ro bu gaga amite fune una ajia vako bu ijare uri una are be vako. ");
INSERT INTO bbb_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Bu maza boeje are binobino bu oenoevo ije E Ireobo fuka amite rena ari Are Muvuaka Akae ijia okurako bu gavo. Ro maza ije bu oenoevo ije fu amite ijare arina are ado ijia okuramo ro muge ije fu miane ijare are ado ijia vuijena sanamo. ");
INSERT INTO bbb_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","54","(-) Nabasi safita 1:1–6:21 fu izege Mosisi fu Uruo Saenae ijia e Isureroko boeje ijiebuo ive ije fu buki ijia isoema ijene kuae. Ro kuke bu akae ije e Rivaeti bu nuvedufuo ijiakiro akae gue ije bu izege e ifejiaga bu maturaedufuo ijene kuae. ");
INSERT INTO bbb_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","34","(-) ");
INSERT INTO bbb_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","51","(-) ");
INSERT INTO bbb_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","49","(-) ");
INSERT INTO bbb_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","31","(-) ");
INSERT INTO bbb_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","21","(-) ");
INSERT INTO bbb_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","23","Areme E Ireobo fu Mosisi kuarana kuae, Va Eronikiro farirafa fuone ije kuariaga bu e Isureroko ijiebuo baname mukore igene isoene. Ro baname bu isoedufuo ije bu igege isoe, ");
INSERT INTO bbb_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","No baname isoega E Ireobo fu maza boeje ja daro miakinu ro ja samuagiake. ");
INSERT INTO bbb_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Ro fure maza boeje jone oefiane abena ja ni veradianoekinu ifejiake. ");
INSERT INTO bbb_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Ro kuke no baname isoega E Ireobo fu mumaza ja oemarejiana ifejiaga ja dazena mukoreigia kafae karinoeke. ");
INSERT INTO bbb_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Ro Eronikiro farirafa fuone ije bu e Isureroko ijiebuo ive none ijia kiena baname buefuo isoekuva nare kono bu daro miakinuro ifejiake. ");
INSERT INTO bbb_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","89","(-) ");
INSERT INTO bbb_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","26","(-) ");
INSERT INTO bbb_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","14","(-) ");
INSERT INTO bbb_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","16","Ro maza ije e Isureroko bu Godido Are Akae ije sa furikoga amite ijare arina Are ado ijia okurae. Ro maza boeje amite fu muge arina Are ado ijia namo ije fuka miane igege naeno. ");
INSERT INTO bbb_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Ro kuke maza ije amite ije fu Are ado ije arena uri kafe vakone e Isureroko bu Are ije faraena amite ije nuve vako. Ro amite ije fu vako ije fu arena ijia namone e Isureroko bu ijia are buone ijia sana karivo. ");
INSERT INTO bbb_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","E Ireobo fu vame ijiege e Isureroko ije kuariakoga bu ijia fiekinu kenoe. Ro fu vakuma bu karidufuo kiamone bu ijia kari ro fu vakiro kiamo ije bu vako. Ijadufuo maza ije amite fu arina Are Muvuaka Akae ado ijia namone bu uria ijia kari. ");
INSERT INTO bbb_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Ro amite fu maza jiamado Are Muvuaka Akae ado ijia namo ije e Isureroko bu E Ireobo irinana bu vako baki ro bu ijia karivo. ");
INSERT INTO bbb_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Ro maza bino amite ije fu maza sibaneke uria Are Muvuaka Akae ado ijia namo ije e Isureroko bu Godi irinana ijia kari. Ro fu vano kiamone bu vako. ");
INSERT INTO bbb_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Ro maza bino amite ije fu muge besu fu ijia na ro suoke fune bio vako. Ro fu bio are be vakone budua bu uri nuve vako. Ro maza gue amite fu muge ro maza ijia bio vakone e Isureroko buka uri sinuome abena uri nuve vako. ");
INSERT INTO bbb_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Ro maza bino amite fu juaevasia besu ro asame besu ro ba maza inokiro uria ijia namone bu uria ijia karivo. Amite ije fu ijia nama areme uri bio vakone e Isureroko budua uri ijia nuve vae. ");
INSERT INTO bbb_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Ijadufuo e Isureroko ae sao ijia bu urana oenoekinu ro are bu sana karinoeva ije bu izege E Ireobo fu Mosisi kuarako fu kuariamo bu ijia fiekinu renoe. ");
INSERT INTO bbb_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","32","(-) ");
INSERT INTO bbb_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Areme e Isureroko bu uruo akae Saenae ije arena bune maza inokubeke vame ijia vae. Ro maza ije bu vako ije E Ireobo ijadufuo Mavua Akae ije fu ude vako e Isureroko bu izia karidufuo fu ije nijasiamo. ");
INSERT INTO bbb_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Ro maza besubesu ije bu vaeva ije E Ireobo ijadufuo amite ijare afisaejiakoga bu vae. ");
INSERT INTO bbb_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Ijadufuo maza ije bu mavua akae ije abena vakuvejo ije Mosisi fu baname igene isoemo, E Ireobo ni urina e ani one ije kame giegisa uniaga bu subi vane. ");
INSERT INTO bbb_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Ro maza ije bu mavua akae ije nija karijo ije Mosisi fu baname isoena kua, E Ireobo ni una ro e agane one Isureroko ije ka ma uruvana ijena finoene. ");
INSERT INTO bbb_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","2","Ro e Isureroko boeje buneka zinuevena uri irufuo binobino bu abevo ijadufuo ziena kuaenoejoga E Ireobo fu ije fie. Ijadufuo fuka ma ireobo defaruimoga fu miane kuamoga fu bu kariva uve ijia ari. Fu ijia arina uri are ikene akaegue naenoga e boeje bu urina Mosisi uruke igia vijena kume, Ro no ifejuomono kumei. Bu ijiege kumejoga Mosisi fu uri Godi baname isoemoga miane fu ijia vafae. ");
INSERT INTO bbb_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ijadufuo are ije e bu kua Taberano kuavo. Ijadufuo maeje E Ireobo ijadufuo miane ijare ije bu kariva ijia arina are ije naema ijadufuo bu ijiege kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Ro e ae binoko ije bu e Isureroko ijena vako ije bu urina izege ire maeje bu Ijifiti ijia karina ivo ije vierafena buka naebe oemarei. Ijadufuo bu ijene kuaenoekoga e Isureroko budua buka naebe oemareva ijadufuo bu uri kuae, Noka ireobo fanuve ikuae vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Bu ijiege kuaekinu kuae, No Ijifiti ijia kariva ije kijume ije nome karina ivo. Ro kuke noka tanabaekina marubae ro onioni ro ire maeje gue ijene ivo. ");
INSERT INTO bbb_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Rove iviama no ijiege revo baki noka naenitua burete mena ijiaru ivo ijadufuo no vierafe ire ije no ivo ije noka ijaredufuo. ");
INSERT INTO bbb_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Ro ire burete mena ije fu ifo ijadufuo sunine isesina abaeki igeki. ");
INSERT INTO bbb_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Ijadufuo e Isureroko bu ire ije sakae ado ijia arivo ije karina va mune mutuga fu kuokuo reme. Areme e bune sukore ijia ifaejema areme bune kena burete baraeki ije amaeriavo. Ro burete baraeki ije bu ivo ije mariene fuone fu ine orivi ijadufuo safine ijiakuma ifaejevo ijieki. ");
INSERT INTO bbb_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Ro burete mena ije bu arivo ije bu muge asame safine ijiakuma are ije bu karijo ijia arimo. ");
INSERT INTO bbb_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Areme Mosisi fu fieke e boeje agane besubesu bu are buone makave ijia irena niraevoga fu fie. Ro E Ireobo fu ije fiemo fuka ma ireobo defaruimoga Mosisi fu ije fiemo fuka ireobo oefiae. ");
INSERT INTO bbb_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Ijadufuo fu E Ireobo ije kuae, A irerefuo e Isureroko ijiebuo irufui ije kame na vajieme? Ro na irere ije one isema reva ijadufuo a na kiega na e boeje samuagiakinu ro irufui buone ije abe ruove? ");
INSERT INTO bbb_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nana asoe buone baki ro kuke buje bu anafa none baki. Ro a irerefuo na kiega na bara ije fu ame fudiadiamo igege na e ige kame ijiege fudiadiana are ije a asaerafa buone ije miakiro kiaema ijia vakiro ruove? ");
INSERT INTO bbb_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ro na e boeje ige bu uria fanufuo kuaekinu kievo fanu vajuo no ino kievo ije na izia kena vajiake? ");
INSERT INTO bbb_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ro kuke e ige buka e uruvana ro nana e besu ijadufuo naka naebe manido na bu samuagiake. Ijadufuo maeje irufui buone buka ma uruvana. ");
INSERT INTO bbb_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ro iviama a na dabe ijiege kafiemo ije nika kaniega na baronedufuo. Ro a na giega fu oemadakuma ni ifejiega ige na isejavaekinu ruovo ije na areno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Areme E Ireobo fu Mosisi kuae, Ni e Isurerokobuo e mamekanu seveniti (70) ijiege e bu giana aguariavo ije kiaga bu urina aena Are Muvuaka Akae no afuivo makave ijia ireno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Bu aena ijia irega na ari obiki vua kuae areme Kavene none ije na abe a nujaejaeva ije gue kena bu uniaejiane. Na ijiege rekina bu a ifejana e boeje ijiebuo irufui ije a abemo ije dasumaga a naebe osukua una ijiege irufui abeke. ");
INSERT INTO bbb_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ro ni e Isureroko boeje kiaga bu Godido nidua ijia ise buone visuna buone amaerenamikina E Ireobo fu isuome fanuve vajiaga bu ine. Ro ije bu fanufuo karina niraekinu kuae, No fanuve ikuva noka izege Ijifiti ijia no oemarekinu karinoeva ijiege karikono kuaevo ije E Ireobo fune fie. Ijadufuo iviama fu fanuve vajiaga ja ike. ");
INSERT INTO bbb_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","20","Ro fanuve ja ikuva ije ja maza besu ro inokiro ro umui fague ro fura besu ijiaru ikuva baki. Ro jaka asame besu guove ijia ma uruvana ina vakuma janeka ziare ufena ijuoneke. Ijadufuo maeje E Ireobo fu jaena fino ije ja fu ijuonena fanufuo niraekinu kuaevo, No irerefuo Ijifiti are maeje arena ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Areme Mosisi fu urina E Ireobo ije kuae, Naka e ma uruvana sigisi aderedi tauseni (600,000) ijena igia manikoga a kie na asame besu ijadufuo guove ijia na fanuve vajiakono kie. ");
INSERT INTO bbb_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Ro a vierafe fanu sifi ro fanu kau ije fube manido fu e boeje bu iga bu manike? Ro kuke kijume boeje do davare ijia oenoevo ije e ige bube iga bu manikono kuae? ");
INSERT INTO bbb_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Areme E Ireobo fu Mosisi kuae, A vierafe daro none ije fu naebe manido na ire ije na kuaeva ije reke? Ijadufuo iviama ni samuaga na ire na kuaeva ije re ro baga a gano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","E Ireobo fu ijiege Mosisi kuaramoga Mosisi fune vua ije fu kuaraema ije va e Isureroko ije kuariae. Areme fune e Isurerokobuo e mamekanu seveniti (70) ije fu kema ije kaenamiana Are Muvuaka Akae irifo ijia irena ufuaenoe. ");
INSERT INTO bbb_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Areme E Ireobo fu amite uve ijia ari Mosisiki vua kuaema areme fu uri Kavene fuone ije fu Mosisi nujaejaema ije una e seveniti (70) ije saejiae. Areme bu uri maza aokube ijiaru e boeje Godido vua ije urukeigia darokuma vua kuariae. ");
INSERT INTO bbb_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ro e mamekanu inokiro Eradadikiro Medadi bu naebe Are Muvuaka Akae ije buina vae. Ro bu uria are buone ijia kariva ijia Godido Kavene fu arina nirokiamo bu ijia uri Godido vua ije dabe urukeigia darokuma kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Bu ijiege revoga e nikaki be fu difurina va Mosisi kuae, E Eradadikiro Medadi bu are nuvuone gafi Godido vua ije dabe urukeigia darokuma kuaevono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Areme Josua e Nanedo fari ije fu uria momokana ijia ruoma iviama igia fu Mosisiki fikinu ro ifejamo. Ijadufuo fu uri Mosisi kuae, E ireobo ni e inokiro gafe bu vua ije kuaevo ije kuriaerega bu areno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Fu ijiege kuaramoga Mosisi fu una gue kuae, A vua ije a kuaemo a e gure bu i none na mevo ije abekuvejo a ijadufuo ziena kuaeme? Na vierafe E Ireobo ije fuka e fuone boeje Kavene fuone ije uniaejiakina buka uri Godido vua ije dabe darokuma kuaenoekiro naka ijE Ireobo vierafe. ");
INSERT INTO bbb_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Areme Mosisikiro e Isurerokobuo e mamekanu ije bune una are buone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Areme E Ireobo fune majaufi ije kuamoga fu davare ado ijia ufina ume kuero no kuavo ijene nijamoga ume ka ma uruvana bu kena e Isureroko are bu kariva ijia vae. Ro ume ije buka ma umera sakae ado ivuake ijia oena are bu kariva ijia ari. Ro ume gue bu sikene boeje guegue ije asina biona mumabo ijiakuma vae. ");
INSERT INTO bbb_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Ijadufuo e Isureroko bu ve ijia zinuevena ume ijia kianiako vakuma ve muna una ve irasema dabe maza ijiakuma vae. Ro e besubesu ume bu kaniaeva ije buka ma uruvana kukuma kaniae. Bu ume kame atana are buone ijia maza uviae. ");
INSERT INTO bbb_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Areme bune uri fanuve ije kena ikuvejo ijia E Ireobo fu giamo fuka defarui. Ijadufuo fu adame ka ma ise ije kuamo fu e boeje ijiebuo romoga bu adame ije abena isejavaena oe. ");
INSERT INTO bbb_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Bu ijiege reva ijadufuo are ije bu abe ive ina kuae Kibiroti Atavano kuae. Ijadufuo maeje bu e ije bu Ijifiti ire ijadufuo uruvana ijafuneva ijene ijia mako rui. ");
INSERT INTO bbb_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Areme e Isureroko ije bune urina aesakae Azeroti ijia va areme ijia are sanama kari. ");
INSERT INTO bbb_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","2","Ijiege rena mazani ije bu are Azeroti kariva ijia Miriamekiro Eroni bune uri Mosisi bara Kusaetiko fu abema ijadufuo ziena fuesina kuae. Bu kuae, E Ireobo ije fu Mosisi fuosukua duvado fuone ijiaru e ije vua kuariamo baki. Ro kuke fu duvado nuvuone ijia e ije vua kuariamo. Bu ijiege kuaevoga E Ireobo fu vua ije fie. ");
INSERT INTO bbb_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","(Ro e Mosisi fu e boeje bu aesakae igia oenoevo ijiebuo uve ijia fuje fuka e be kabuaekabuaekigia kenoeno.) ");
INSERT INTO bbb_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Ijadufuo E Ireobo fuka migegireigia Mosisikiro Eroni ro Miriame ijene kiae, Ja e inokubeke ije usiaena ro Are Muvuaka Akae viene e bu afuivo ijia besu ireno kiae. ");
INSERT INTO bbb_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","6","Areme fune amite uve ijia arina Are Muvuaka Akae ijadufuo viene ijia mani areme Eronikiro Miriame kiamo bune biona ivuake ijia vae. Areme fu kiae, Vua ige mukoreigia fiefo. Na e Godido vua vierafena kuaevo ije bu jaena karivo ije na naka ijia arina buina vua kuaevo. Ro ve bino bu nimamaena naena vua kuaevo. ");
INSERT INTO bbb_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Rove Mosisi e none imeno ije fuje na ijiege revo baki. Ro fuje fuka e be fu maza boeje noefuo i mukoe meno. ");
INSERT INTO bbb_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ijadufuo na fuosiki vua kuaevo ije naka nikubae guria ganamikinu vua kuaevo. Naka vame samadukua fu mukoe fiena vierafedufuo ijia kuaravo. Ro na vua ke sauina kuaravo baki. Fuje naka vame ijiege fuosiki vua kuaeko fu ijia E Ireobo na e izeki ije fu ijia giemo. Ro ja irerefuo fuesina kuaekuae jaka naebe jumei. ");
INSERT INTO bbb_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","E Ireobo fu vua ijiege Eronikiro Miriame kuariaga fuka defaruimoga fune bu uniana vae. ");
INSERT INTO bbb_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","11","Fu vakoga amite ije Are Muvuaka Akae ado ijia namo ije fune arena uri vae. Areme saroruba e ije bu gake Miriame fune vajae matane abaeki bu kua reforasino kuavo ije abena ijia manino bu gae. Ijadufuo Eroni fu ije gana una dakudena Mosisi kume, E Ireobo none a isekie, ade ise ije no one reva ijadufuo no kame isekafuomo. ");
INSERT INTO bbb_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Ro ade arega bara Miriame fu ame ije bu devatua ijia oega bu nafega bu vajae fudovo ijiege remono kumei. ");
INSERT INTO bbb_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","14","Ijadufuo Mosisi fune una E Ireobo ije kume, Godi none a isekie ni bara ije kenujano kumei. Rove E Ireobo fu una ijiege kuae, Miriamedo asoe ije fu nikubae fuone ijia vije ufemadikuma fuka jaevekinu maza seveni ijiege are makave ijia fuosukua fike. Ijiegero Miriame fuka Mosisi fuesina vua isema kuaema ijadufuo ni kuaga fu are makave ijia fuosukua fine. Fu ijia fi vakuma maza seveni ijiege furiga ni kuaga fu una aru rono kumei. ");
INSERT INTO bbb_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Ijadufuo Miriame fu makave ijia finoga e boeje bu naebe usiae oenoe. Ro buka are ijiaru karina vakuma maza seveni ijiege furikoga bu Miriame mesirina una aru ruae. ");
INSERT INTO bbb_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Areme rade bune aesakae Azeroti ije arena urina va ae sao Farane ijia are muvuaka sama areme ijia kari. ");
INSERT INTO bbb_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","2","Areme E Ireobo fu Mosisi kuae, Ni e Isureroko agane besubesu ijia kiaga bu e mamekanu buone kega bu mauike va aesakae Kenani ijia na abe e Isureroko ije miakuvejo ije ninako gano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Ijadufuo Mosisi fune ijiege E Ireobo fu kuaraema ijia nuvena e Isurerokobuo e mamekanu bino kena uniamoga bu uri ae sao Faraneno kuavo ije arena aesakae Keinani ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","24","(-) Safita 13:4-24 ige fu e ije Mosisi fu kiamoga bu aesakae Kenane ninakokuae vaeva ijiebuo ive ijene isoe. Ro kuke Mosisi fu vame izege e ije bu va aesakae ije ninako ganoedufuo ijene kuariana nijasiaema ijene. ");
INSERT INTO bbb_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Areme e ije bu aesakae ije ninako gakuae vaeva ije bu maza foti (40) ijiege furikoga bu una ruae. ");
INSERT INTO bbb_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","E ije bune una ro Kedesi are Farani Ae sao ije Mosisikina Eronikina e Isureroko boeje bu kariva ijia usiae. Areme e boeje bune besu afuikoga bu uri vua ije kuariana areme ifo ije bu Keinani ijia karina ruaeva ije kena nijasiae. ");
INSERT INTO bbb_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Bu ijiege nijasia areme uri Mosisi kuae, Are ije a kuomoga no ninakokuae vaeva ije fuka aesakae ma saruegi. Ro kuke fuka ire ma uruvana ijia zarae ijadufuo ifo ijia no tura ruaeva ije igifurekino ni giane. ");
INSERT INTO bbb_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Ro sidove buone buka mamekanu ro faere buone bu kiraeva ije buka ma gikikimana. Ro e ijia kariva ije buka ma e daroki ro e Anakido uifari ije buka e jiamadogo ro ka e daroki bu ijia kariva no giae. ");
INSERT INTO bbb_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Ro e Amarakaetiko ije bu aesakae ikene ijia kari. Ro e Itaetiko ijiakina e Jebusaetiko ijiakina e Amoraetiko ije bu uruo ijia karinoe. Ro e Keinanaetiko ije bu do Jodeni fu vaema ijia karijana una davare irifo ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Bu vua ijiege Mosisi kuaravoga e Isureroko bu vua ije fievo buka judiae. Ijadufuo e Kerabi fu urina Mosisido nidua ijia e ije kuriaeremoga vua ije bu kuaevo ije bu ijia arei. Bu arekoga fu urina e ije soesoena kiae, Ja irerefuo jumeve? Noeje no maniva ijadufuo vaga no e ijene kaniana sakae buone ije abeno kiae. ");
INSERT INTO bbb_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Kerabi fu ijiege kuariamoga e ije bu fuina vaeva ije buka urina kuae, E ije buka ma e daroki ijadufuo no izege va kaniana aesakae buone ije abekuva bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Ijadufuo e ije vaeva ije bu uri vua ise ijene e Isureroko boeje kuariana kia, Aesakae ije no va gaega fuka ma omise ro kuke e uruvana bu ijia oevo. Ro kuke e ijia kariva no giaeva ije buka e mamekanu buka no asidue. ");
INSERT INTO bbb_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Ro e Anakido uifari ije buka e jiamadogo mamekanu ubaeradiaeva ije bu ijia kariva no giae. No e ije giana ro una nuvuone ganamiga noeje noka ire mutura igekino kiae. ");
INSERT INTO bbb_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","2","Areme muge ijia e Isureroko boeje buka ma urukeigia niraena vijeko vakuma ve irasei. E boeje buka uri Mosisikiro Eroni madiana kiae, Janika areke no Ijifiti ijia ro ba ae sao ijia karinoena oega fuka marekuma. ");
INSERT INTO bbb_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Ro E Ireobo fu irerefuo no kaenamuona igia ruaema iviama e buneka no kanuoga none igia oedufuo. Bu kanuoga no oeke bararafa nuvuone ijiakina anafa nuvuone ije bune e ijiebe kaenamia vadufuo. Ijadufuo fube maredo noka una gamia Ijifiti vakono kuae? ");
INSERT INTO bbb_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Bu ijiege kuaena bune uri bue kuae, Noka e nigofo be abega fure no kaenamuona una Ijifiti vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","E ije bu ijiege kuaevoga Mosisikiro Eroni bu e Isureroko boeje bu afuiva ijiebuo nidua ijia tuana uimutumutu sakae ado ijia dije. ");
INSERT INTO bbb_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Ro Josua e Nanedo fari ijiakiro Kerabi e Jefunedo fari ije bu aesakae Keinani ninakokuae vaeva ije bune uri izege e Isureroko ije bu Godi ma vierafekuae totenamivo ije giavo buka ireobo oefiadiae. Ijadufuo bune uri ugone buone bu saeva ije kame farae. ");
INSERT INTO bbb_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Areme bune uri e Isureroko boeje bu ijia afuiva ije kiae, Aesakae ije no urana vakinu ninakoeva ije fuka mukore. ");
INSERT INTO bbb_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Ijadufuo E Ireobo fu no oemarejuokuma fure kaenamuona va aesakae ije ire zaraema ije abena no muoke. ");
INSERT INTO bbb_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Ijadufuo jade uri e ije aesakae ijia kariva ije jumena E Ireobo ije ijuonevo. Ijadufuo maeje godi buone ije bu vafaedufuo ije buka daro baki. Ro no E Ireobo ije fu noena ijadufuo no vakuva nore iraraena e ije kaniakono kiae. ");
INSERT INTO bbb_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Rove e Isureroko buka mune tuana e inokiro Kerabikiro Josua ije kaniakuae kuae. Bu ijiege kuaevoga E Ireobo ijadufuo sanaema ije fu arina Are Muvuaka Akae ije e Isureroko boeje bu besu afuiva ijia sanamoga bu gae. ");
INSERT INTO bbb_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Areme E Ireobo fu Mosisi kuae, E ije bu maza izege na oe isema vierafekinu na ijuoneke? Bu ire sumiki daroki ma uruvana ije na buone revo ije buka naebe giena ma vierafe. ");
INSERT INTO bbb_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ijadufuo naka adame ka ise be kuaga fu buone roga bu abena isejavaekinu oeke. Rove aeje naka daro mana ifejaga uifari one buka ma uruvana reke. Ro kuke buka e ige asidiana e daroki rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Rove Mosisi fu una kuae, E Ireobo e ige are daro one ijia gamia Ijifiti kaenamiana keke ruae. Ro a kame una ijiege isekafiakuma e Ijifitiko buka ije fiedufuo. ");
INSERT INTO bbb_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Bu izege are amite rena ari e one samuagiamo ro kuke bu izege e one bu ni buone ijia a gavo ije bune fie. Bu izege a maza ijia amite rena ude vakinu ro muge a miane rena vako no ijia nuvedavo ije bune fie. Ijadufuo a e ige kania furikuma bure e ije aesakae igia kariva ije kuariake. ");
INSERT INTO bbb_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","16","A e ije kame maza besu ije ijiege kaniaga bu oekuva e aesakae gue ijia kariva bu ije fieke. Bu ije fiekuva bu kuaeko, E Ireobo fu naebe manima ijadufuo e ije fu naebe kaenamiana keke aesakae ije fu abe miakiro kuaema ijia vae. Ijadufuo fu ae sao ijia kaniamoga bu oevano kuaeke. ");
INSERT INTO bbb_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Ijadufuo E Ireobo a isekie ni daro one ka ma ireobo ijia nijasuona ire ije a nuvuone rekiro kuaema ije rene. ");
INSERT INTO bbb_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","A koro kuae, Na E Ireobo naka migegire defarudiemo baki ro none na e oetuavo ije fuka maza boeje ijia navako. Ro kuke na e ije bu oe kuderiakinu na kumevo ije ise buone na giana arevo. Rove e ije eranebe uria ise revo ije na kame isekafiake. Na ijiege rekinu anafa buone ijiakiro uifari buone ijiebuo ise ije na uria kame isekafiakinu vake. ");
INSERT INTO bbb_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","E Ireobo a aka maza boeje e oetuamo ijadufuo a isekie ni izege a ise buone ije bu Ijifiti gamia zinuevena giana arekinu ruoma igia kekeima ijiege ni iviama ise buone ige giana areno kume. ");
INSERT INTO bbb_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","E Ireobo ije fu Mosisido vua ije fie areme una kuae, A ijiege kiemo ijadufuo ise buone ije nane giana arei. ");
INSERT INTO bbb_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","23","Ijadufuo nare vua ige ka gikikimana kuaedo e ije ada girenoejo ije bube are ije na abe bu miako kuaeva ijia vake. E boeje bune izege na Ijifiti ro ae sao ijia buina finoevo ije sanaema none bune gae. Ro kuke bune izege na daro none ijia ire sumiki ije buone revo bune gie. Rove buka na ijuonena naebe irinie ro buka una ise rekuae vierafevo. Ijadufuo e besukuae be fube aesakae ije gake. ");
INSERT INTO bbb_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ro Kerabi e i none meno ije fuosukua fu mukoreigia vierafena irere na kuariaeva ijia rei. Ijadufuo na mesirina aesakae ije fu gana ruaema ijia vaga uifari fuone bu aesakae ije abeke. ");
INSERT INTO bbb_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Ijadufuo jade e Amarakaetiko ijiakina e Keinanaetiko aesakae ije bu kariva ijia urana vako. Ro isuome nine una kuderiana Davare Kavuaneno ije nafuema nake una ae sao ijia vano kiae. ");
INSERT INTO bbb_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","27","Areme E Ireobo fune Mosisikiro Eroni kiae, Na e Isureroko ije ka ise uruvana renoejo ije maza boeje bu na ziegafieve. Ijadufuo nane vua buone boeje bu noesina kuaenoevo ije nane fie. ");
INSERT INTO bbb_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ijadufuo ni vua ige e ije kuariana va kia, Naeje na ma kuaria na vua irere ja kuaevo na fieva ije na reke. ");
INSERT INTO bbb_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Ja e boeje eranebe ja juaevasia tuaedi (20) ijiege furiva ro gafa asi vaeva ije ae sao igia oena dabe giegisana naojana vake. ");
INSERT INTO bbb_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ro e besukua be fube aesakae ije na ive none kuranamina abe ja miakiro kuaeva ijia ura vake. Ro fune Kerabi e Jefunado fari ijiakiro Josua e Nanedo fari ijiebe buosukua bu aesakae ijia vake. ");
INSERT INTO bbb_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","32","Ro anafa jone ije ja kuae bu e ijiebe buone kaenamiana vako kuaeva ije nare mukoreigia samuakinu kaenamiana vaga bu aesakae ije ja ijuoneva ije abena ijia oemarekinu karivake. Ro jaeje ja ae sao igia oena ijia furike. ");
INSERT INTO bbb_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Jare naebe maza boeje irere na kuariavo ijia renoejo ijadufuo anafa jone bu juaevasia foti (40) ijiege ae sao igia ura dia igia oenoeke. Bu ijia oenoekinu vakuma e boeje buka ijia oema furike. ");
INSERT INTO bbb_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Ro aesakae Keinani e jone bu va ninakonoeva ije buka mu foti (40) ijiege. Ijadufuo ja juaevasia foti (40) ijiege ja ae sao igia isejavaenoeke. Areme ja ijare vierafero na ire ise ja renoevo naka naebe oemarevo bakiro ja ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Vua ige E Ireobo nare kuaeva ijadufuo na e Isureroko boeje eranebe bu na ijuonena ise renoejo ije na kame isekafiake. Na kame ijiege isekafiaga e boeje buka aesao igia isejavaenoena areme ijia oena furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","37","Areme e ije bu kiavo bu are gafe ninakokuae vaeva bu una vua kufui dabe e boeje kuariavoga bu E Ireobo vua fuesina kuaeva ije fu adame kuamo fu buone romoga bu adame abena oe. ");
INSERT INTO bbb_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Ro e tuero bu ninakoena vaeva ijia e teni bu oegaro Josua e Nanedo fari ijiakiro Kerabi e Jefunado fari ijiebe buosukua bu naebe oe. ");
INSERT INTO bbb_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Ijadufuo Mosisi fune E Ireobo ijadufuo vua ije e Isureroko kuariamoga buka urukeigia niraena isejavae. ");
INSERT INTO bbb_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Areme nituame suoke mugamia bune urina kuae, Noka isema reva ijadufuo noka urina uruo irifo ijia aesakae ije E Ireobo fu no muoko kuaema ijia vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Rove Mosisi fu kiae, Jaeje jaka E Ireobo ije irinavo baki ijadufuo vua ije ja kuaevo ije fuka marekuma baki. ");
INSERT INTO bbb_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Ijadufuo ja vakuva E Ireobo fu jaena vakuma bakido e ani jone buka ja kaniake. ");
INSERT INTO bbb_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Ro ja va e Amarakaeti ijiakina e Keinanaetiko ije biediana buina bijaevo ijia buneka bu iraraena ja kaniaga ja oeke. Ijadufuo maeje ja fu ijuegafaeva ijadufuo fu ja ijuegafiakono kiae. ");
INSERT INTO bbb_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Ro e Isureroko bu Mosisido vua ije bune fie ro buka faememarena uruo ijia ajia vae. Bu vakoga Mosisi fuosukua fu uria Are Muvuaka Akae ijia samuana fi ro kuke mavua akae ije fu naebe buina vae. ");
INSERT INTO bbb_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Ijiege rena bune ajia vakoga e Amarakaetiko ijiakina e Keinanaetiko ije uruo ijia kariva ijiebe kaniakinu e Isureroko kame arafiriana ari vakuma are Oma ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","41","(-) ");
INSERT INTO bbb_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","50","(-) ");
INSERT INTO bbb_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","13","(-) ");
INSERT INTO bbb_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","32","(-) ");
INSERT INTO bbb_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","22","(-) ");
INSERT INTO bbb_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ijiege rena asame amure ijia e Isureroko boeje bune vakuma ae sao bu kua Zino kuavo ijia usiae. Areme bune are Kedesino kuavo ijia are muvuaka sama areme ijia kariva ijia bara Miriame Mosisido maki fu baronemoga bu abe ijia mako rui. ");
INSERT INTO bbb_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Ro are ijia do bu idufuo ije fuka baki ijadufuo e boeje bu ziena uri Mosisikiro Eroni vua ise buesina kuae. ");
INSERT INTO bbb_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","E boeje bu uri Mosisi madina kuae, Anika areke no izege e nuvuone gue bu Godido nidua ijia oeva nodua no besu ijiege oebitie fuka maredufuo. ");
INSERT INTO bbb_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Ro a irerefuo E Ireobo ijadufuo e igiakiro fanuve buone boeje kaenamiana ae sao igia ruaema noka ireobo vajae fiane abena oekuveje. ");
INSERT INTO bbb_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","A irerefuo no Ijifiti karivaga a kaenamuona keke are ige ka ma omise igia ruae? A kaenamuo ruaema noka ire vuiti ro isuni binobino ro kuke do maeje no inoedufuo ije fuka bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Bu ijiege Mosisikiro Eroni kuariavoga e inokiro bu usiae Are Muvuaka Akae viene ijia usiaena auge sana tuana uimutumutu sakaedo ijia dije. Bu ijiege rekoga E Ireobo ijadufuo sanaema ijare ije bu naovo ado ijia sanae. ");
INSERT INTO bbb_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","8","Areme E Ireobo fu uri Mosisi kuae, Ni uvia one Eroniki mudu one a bijuanoeno ije abe areme e Isureroko boeje kiaga bu usiaena are samadukua ijia afuine. Areme ni uri e boeje ijiebuo niome ijia munuage ije kuaga do fu ijia ariga e ro fanuve buone boeje bu do ijia iga fu oemadiano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Areme Mosisi fune uri izege E Ireobo fu kuaraema ijiege rena uri mudu fuone ije fu E Ireobo ijadufuo Are Muvuaka Akae fu fino ijadufuo nidua ijia nijaema ijene abei. ");
INSERT INTO bbb_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Areme fune Eroniki uri e boeje kiavo bu munuage irifo ijia kari ufuaenoena arei. Bu ijiege karikoga Mosisi fu urina kiae, E gure buzeme ka vua karatuavo gurie na ige kuariako fiefo. Ja vierafe noka joefuo ivia munuage igia do jiana miaga ja ikuae ja ijiege vierafevano kiae? ");
INSERT INTO bbb_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Areme Mosisi fune uri mudu fuone ije abena munuage ijia kana areme kuke una kanamoga do fu ijia ari. Areme e Isureroko bune fanuve buone ijena do ije abiesemo ijene i. ");
INSERT INTO bbb_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Rove Mosisikiro Eroni ire ije bu reva ije bu naebe una E Ireobo ijadufuo vierafe ijia nuvena rei. Ijadufuo fu una Mosisikiro Eroni kiae, Naeje naka E Akae. Rove ja e Isureroko ijiebuo nidua ijia ja naebe daro akae none ma vierafe ro jame uri daro jone ijia mune ije kanavo do ije fu ijia ari. Ijadufuo E Isureroko bu naebe na ma vierafekinu aguariedo jabe e ije kaenamiana aesakae ije na bu miakiro kuaeva ijia vake. ");
INSERT INTO bbb_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Ro e Isureroko bu dofuo ziena E Ireobo ijena madinamiva ije bu are Meriba ivuake ijia ijiege rei. Ro kuke E Ireobo fu are Meriba ijia vame fuone akae ijene e boeje nijasiamo bu gae. ");
INSERT INTO bbb_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Areme Mosisi fune are Kedesi ijia figana e bino kiamoga bu vua ige abena e Idomeko ijiebuo kini ije kuarakuae vae. Ro vua ije fu ijiege nijae, No uviarafa jone e Isureroko ije nore vua ige nijiave. A vajae fiane binobino bu nuvuone ruaeva ije ane fiena vierafei. ");
INSERT INTO bbb_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Ro kuke ane izege asaerafa nuvuone bu Ijifiti ijia ari vaeva ije ane vierafei. Noka juaevasia ma uruvana ijia karikoga e Ijifitiko ijiebe asaerafa nuvuonekiro no buka kame vame ise ijia kafuovoga noka ma uruvanaigia isejavaekinu buefuo moni baki imei. ");
INSERT INTO bbb_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Rove no E Ireobo ijadufuo baname isoevoga fu fiena anera fuone ije kuamoga fure no kaenamuona are Ijifiti arena keke ruae. Areme iviama no are Kedesi ae sakae one ivuake igia kari. ");
INSERT INTO bbb_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Ijadufuo a isekie ni areke no aesakae one ukua ijia urana vane. No ijia ura vakuva nobe juare jone ja meva ije arafiriake. Ro kuke nobe do jone bino ikiro nome vame urari vake. None vame vakuma kiane jone ije arena gara ura vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Rove e Idomeko ijiebuo kini ije fu una ve vua nijana kumei, Na vierafe jabe aesakae nuvuone guove ijia ura ruake. Ro ja igia ura ruakuva na e none kiaga bu jaena bijaekono kumei. ");
INSERT INTO bbb_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Bu ijiege kumevoga e Isureroko bu una kini ije kumei, No vierafe nome vame vakuae vierafei. Ro no e nuvuone ro fanuve ije bu do one bino ikuva no fuaeveke. No vierafe nobe ire bino rekiro nome mauike diake aesakae one ukua ijia ura vake. ");
INSERT INTO bbb_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","21","Rove e Idomeko ijiebuo kini fu una vua nijana kume, Ja aesakae nuvuone ige jade ura ruakuvano kumei. Areme kini ije fune uri e bijaevo fuone daroki ka ma uruvana ije abena bune e Isureroko ijena bijaekuae vae. Bu ijiege vakoga e Isureroko bu vame buone ije bu aregana bune una vame be ijane vae. ");
INSERT INTO bbb_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","24","Ijiege rena e Isureroko boeje bune are Kedesi ije arena vakuma Uruo Ori manino ijia usiae. Areme E Ireobo fune Uruo Ori aesakae Idome fu va irima ijia Mosisikiro Eroni kiae, Eroni fube aesakae ije na e Isureroko miakono kuaeva ijia vake. Ijadufuo maeje ja e inokiro ja vua none na do Meriba irifo ijia kuariaeva ije jaka naebe irinie. ");
INSERT INTO bbb_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","26","Ijadufuo ni Eronikiro fari fuone e Eriza ije kaenamia Uruo Ori ijia ajia vane. A va ijia Eroni ugone fu saema ije azona una fari fuone e Eriza ije sajane. Ijadufuo maeje e Eroni fu uruo ijia baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Areme Mosisi fune izege E Ireobo fu kuaraema ijiege rena uri e boeje ijiebuo nidua ijia Eronikiro fari fuone ije kaenamiana Uruo Ori ijia ajia vae. ");
INSERT INTO bbb_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Bune va ijia usiaena Mosisi fune uri Eronido ugone ije fu saema ije azona una fari fuone Eriza saejae. Areme Eroni fune uruo kave ijia baronemoga Mosisikiro Eriza bune uruo ije arena una ari vae. ");
INSERT INTO bbb_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Bune va gamia usiaevoga e boeje bu gake Eroni fu naebe una buina ari romoga bu vierafe fune uruo ijia baronei. Ijadufuo buka uri ireobo fuefuo niraekinu oefiane abeko vakuma mu teti (30) ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Areme rade maza ije e Aradiko ijiebuo kini ije fu are Kenani ikene ijia fino ije fu fieke e Isureroko bu are Atarime vakuae ruovo fu fie. Ijadufuo fune urina e fuone bijaevo ijena e Isureroko ije ruovo ije kaniakuria areme e gue fu faradiae. ");
INSERT INTO bbb_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Bu ijiege revoga e Isureroko bu uri E Ireobo ijena vua be kuae avenamina abe marei. Bu kuae, E Ireobo a ivia ifejuokuma no oefuo e ije iraraena sidove mamekanu buone ije noka foteke arafiriake. ");
INSERT INTO bbb_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Bu ijiege kuaevoga E Ireobo fu ije fiena uri e Isureroko ije ifejiamoga bure iraraena e Kenanaetiko ije kania furi areme are buone foteke ije arafiriaejiae. Ijadufuo are ije bu abe ive ina Omano kuae. Ro ive Oma ijadufuo maeje bu isekafiavo ijene. ");
INSERT INTO bbb_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Areme e Isureroko ije bune aesakae Idome datura gufarekuae bune urina Uruo Ori arena bune vame ije Davare Kavuane nafuema nake vako ijane ufuaena vae. Rove vame ije bu vaeva buka naebe oemarekinu vae. ");
INSERT INTO bbb_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Ijadufuo bu urina Godikiro Mosisi buesina kuae. Bu kuae, Noneka Ijifiti ijia kari ro ja irerefuo kaenamuona ae sao igia ruaeva noneka oekuae reve. No do ivo baki ro kuke nome ire mena ijiaru iko noneka ma iseduomono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Bu ijiege kuaevoga E Ireobo fu fiena uri tabare ma omise ije kiamoga bu e Isureroko ije sakiavoga e uruvana buka oe. ");
INSERT INTO bbb_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Ijadufuo bu ro Mosisi kuae, No vierafe noka isema rena E Ireobo ro a joesina vua isema kuae. Ijadufuo no vierafe a nuvuefuo E Ireobo baname isoega fu tabare ige karina vano kuae. Bu ijiege kuaravoga Mosisi fune uri e ijiebuo una E Ireobo baname isoe. ");
INSERT INTO bbb_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Fu baname isoemoga E Ireobo fu una Mosisi kuae, Ni ire be tabare igege amaerina abe kave ijia nijane. A ijia nijaekina e boeje bu oenoene tabare sakiaga bu kake ije gakuva bu una madiano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Ijadufuo Mosisi fune uri ire buronisi ijia abena ire tabare igeki ije amaerina abe ine kubi ijia nijae. Ijadufuo eranebe tabare sakiaga bu kake tabare ije Mosisi fu amaeri nijaema ije gavo ije fune migegire maega fu una fivako. ");
INSERT INTO bbb_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","35","(-) Safita 21:10-35 fu e Isureroko bu izege E Ireobo fu kuariaema bu ijia nuve vakuma are Kenani usiaedufuo ijene kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Areme e Isureroko ije bune aesakae Moabi amare ijia urana vakuma do Jodeni irifo gara are Jeriko ivuake ijia are muvuaka sana ijia kari. ");
INSERT INTO bbb_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","3","Ro Kini Beraki e Zifodo fari ije aesakae Moabi samuamo ije fu izege e Isureroko bu e Amoraetiko ijiebuo reva ije fie. Ro kuke e Moabaetiko ije budua bu fieke e Isureroko ije buka ma e uruvanagana buka ma ireobo jumei. ");
INSERT INTO bbb_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","5","Ijadufuo e Moabaetiko ije bu uri e mamekanu aesakae Midiani kariva ijene kume, E Isureroko ije buka ma e uruvana. Ijadufuo bu uri mave ige bu juare uruvana ijo ijiege rena uri ire nuvuone boege naovo ije buka arafiriakono kumei. Ijadufuo Kini Beraki e Zifodo fari ije fu uri e fuone kiamo bu Berame e Biodo fari ije fu are Feto do Iufuretisi irifo ijia fino ije mesirikuae vae. Fu kiae, Ni va Berame kua e ae beko bu are Ijifiti arena usiae ruaeva ijiebe bune aesakae none ivuake igia kari. ");
INSERT INTO bbb_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Ro e ije buka e daroki ijadufuo ni ro na ifejiena e ije kuravajiadufuo. A ijiege kuravajiakina bu darobirega na bite kaniakuriaga bu are ige arena vake. Ro na vierafega e ije erane a kuravajiamo ije buka irufui biediavo. Ro erane a daro miamo ije buka daro abevono kuano kiae. ");
INSERT INTO bbb_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Areme e Moabaetiko ijiakina e Midianaetiko ijiebuo e mamekanu ije bune uri moni ije bu Berame fuaevedufuo ije abena bune vae. Bune vakuma e Berame fino ijia usiaena vua ije Beraki fu kuariaema ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bu ijiege kuaravoga Berame fu kiae, Ni muge igiaru naena igia naoke E Ireobo fu vua izege kuariekuma na kuariaga ni isuome una vano kiae. Ijadufuo e mamekanu ije bune ijia fuina kari. ");
INSERT INTO bbb_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Areme muge ijia Godi fu arina Berame kuae, E ije eranebe aena ijia karivano kuae? ");
INSERT INTO bbb_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","11","Fu ijiege kuamoga Berame fu kuae, Na Beraki e Moabaetiko ijiebuo kini ije fu vua ijiege nijie. Fu kumei, E ma uruvana bu are Ijifiti arena usiae ruaeva ijiebe aesakae ige bune okurae. Ijadufuo a ro noefuo e ije kuravajiaga no kania bu usiae vano kumemano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Rove Godi fu una Berame kuae, A e gafe kuravajiakuma ade e ijena vako. Ijadufuo maeje e ije nane nare daro miaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Areme nituame suoke Berame fune urina Berakido e mamekanu ije kiae, Na E Ireobo fu kuriaerema ijadufuo nabe jaena vake. Ijadufuo ni jare una aesakae jone ijia vano kiae. ");
INSERT INTO bbb_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Fu ijiege kuariamoga e Moabaetiko ijiebuo e mamekanu ije bune una vaga usiaena Beraki kuae, No Berame none va vua one kuarae rove fu ijuonena naebe noena ruaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","16","Bu ijiege kuaravoga Beraki fuka una e mamekanu ka e anuigi e bu aguariavo ijiaru e uruvana kiamoga bu una kuke Berame fino ijia vae. Bune va gafia usiaena kuae, Beraki e Zifodo fari ije fu kume aesekie ade arega ire be fu a none ruadufuo ijene bijukuramo. ");
INSERT INTO bbb_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Anika ro noefuo e Isureroko ige kuravajiakina na irere boeje a vierafena kiekuma naka oemarekinu vajano kumei. ");
INSERT INTO bbb_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bu ijiege kuaravoga Berame fu una kiae, Beraki fu vierafe fuka gorodikiro siruva ijia ma uruvana na fuaevekiro vierafei. Rove nabe sinuome ijadufuo uri E Ireobo Godi none vua irere fu kuariemo ijene kara tuake. Ro kuke nabe none vierafeva ijia ire isekube ro ireobo be rena Godi none ije asike. ");
INSERT INTO bbb_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ijadufuo ni muge igiaru izege e jone gue bu ude ro naena naoeva ijiege igia naofo. Ja naoke na E Ireobo fu izege kuariemo na ije fieno kiae. ");
INSERT INTO bbb_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Areme muge ijia Godi fu una ari Berame kuae, E ije bu ro a kuavo ije nine buina vane. Ro a vakuma ade ire bino rekiro nime vua irere na kuaraeva ijiaru reno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Ijadufuo suoke Berame fune urina sinuome fuone karina mave-doniki ado ijia nana ivia kiriama areme fune e fuone imevo inokiro ije kaenamiana fune e Moabaetiko ijena vae. ");
INSERT INTO bbb_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Berame fune buina vakoga Godi fu ije gamo fuka ma ireobo defarui. Ijadufuo fu anera fuone ije kuamoga fu arina vame ije fu vako ijia iraraena mani. Fu ijia manikoga Berame fune doniki abena e fuone inokiro ijena vae. ");
INSERT INTO bbb_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Bu vakuma doniki ije fu gake E Ireobo ijadufuo anera ije fu sime farena vame ijia iraraena maninoga fu dasuvaena taraebo ijia vae. Ijadufuo Berame fu uri doniki ije kanana abe dakude una keke vame ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Areme anera ije fune una kuke va ine vaeni ijadufuo juare inokiro bu mena faere kirakuriaeva kafare kifiti bu vako ijia iraraena manine. ");
INSERT INTO bbb_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Ijadufuo doniki ije fu va gake E Ireobo ijadufuo anera ije fu ijia maninoga fu asi vakiro uri Beramedo dia ije dabe faere ijia umakazimoga fu uri doniki ije kanae. ");
INSERT INTO bbb_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Areme E Ireobo ijadufuo anera ije fune biona una va vame ma kifiti ije doniki fu izege dakudedufuo baki ijia mani. ");
INSERT INTO bbb_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Anera ije fu ijia maninoga doniki ije fu gana ijia umeke namoga Berame fuka ma ireobo defaruimo fu uri ine dabe urukeigia ifi. ");
INSERT INTO bbb_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Areme E Ireobo fu doniki ije dabe niromoga fu uri Berame kuae, Na irere reva ijadufuo a na maza inokubeke ifiemano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Doniki ije fu ijiege kuamoga Berame fu ije fiemo fuka oeserei. Areme fu urina doniki ije kuae, Are naeje aka dabe e ome ise igege rema ijadufuo na ije kanae. Ro na ivia sime fare ruovobitie na dabe bija a baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Berame fu ijiege kuaramoga doniki ije fu kuae, Naeje na mave-doniki one ije a maza boeje abena oenoeno ijene. Ro a vierafega nabe ude a dabe ijiege ire bino isema revano kuae? Fu ijiege kuamoga Berame fu kuae, A bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Areme E Ireobo fune ijia uri Beramedo ni ije ke kuderiamoga fu ijia anera ije fu sime farena vame ijia manino ijene gae. Fu ije ga areme uri fu manino ijia auge sana tua uimutumutu sakaedo ijia dije. ");
INSERT INTO bbb_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","33","Areme E Ireobo ijadufuo anera ije fu kuae, A irerefuo doniki one ije maza inokubeke ijiege ifi? Doniki one fu na gie ijadufuo fu maza inokubeke dasuvae. Ro fu naebe ijiege dasuvaebitie na ivia a kanaga doniki one na aredufuo. Ro igia fie, ige na ruaeva ije na a bijukurakiro ruae. Ijadufuo maeje irere a rekiro ruomo ije naka naebe oemarevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Areme Berame fu una E Ireobo ijadufuo anera ije kuae, Naka ma isema rei. Ijadufuo maeje a vame none bijukuriekiro ijia manikoga naka naebe mukoreigia gana vierafei. Ro iviama a irere na rekiro ruovo ije a naebe oemarekuma na vierafe nanaka una vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Areme anera ije fu una Berame kuae, Ni e Berakido e mamekanu bu ruaeva ijena vane. Ro igia fie a vakuma ade ire bino rekiro nime vua irere na kuaraeva ijiaru kuaenono kuae. Ijadufuo Berame fune urina e ije ruaeva ijena vae. ");
INSERT INTO bbb_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Areme Beraki fu fieke Berame fune vame romo fiena fune urina aesakae fuone Moabi ubine ijia sidove Are do Anoni ivuake ijia Berame biekiro vae. ");
INSERT INTO bbb_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Beraki fune va ijia biena uri Berame kuae, Na vierafe aka migegire ruakiro na ije vierafe rove a irerefuo naebe migegire ruae? A vierafero sinuome na vajakiro kuaeva ije na kufuimevaro a ijiege vierafemano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Fu ijiege kuaramoga Berame fu kuae, Ije ane ma kuae rove na ige kuarako fiene. Naeje nane igifureki ruae rove vua na kuaedufuo ije na vua none na vierafeva ije kuaekuva baki. Ro name vua irere Godi fu kuariema na ijiaru kuaekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Areme Berame fune Berakiki bune are Kirati Uzotino kuavo ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Bune va ijia usiaena Beraki fune fanuve kaukina mave-sifi ijene kena zinone ifaejegaro fanu birage gue fu kena Beramekiro e mamekanu fuina vaeva ije vajiae. ");
INSERT INTO bbb_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Areme nituame suoke Beraki fune Berame mesirina sidove Bamoti Bero ijia ajia vakoga Berame fu ijia mani nesena e Isureroko gume bu karinoeva ijene giae. ");
INSERT INTO bbb_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Areme Berame fune Kini Beraki kua, Ni noefuo mune ijia karina fata seveni (7) zinone ifaejedufuo ije nana amaeriane. A ijiege re areme nine mave-kau kumate seveni (7) ro mave-sifi kumate seveni ijiege noefuo kena rono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Fu ijiege kuaramoga Beraki fune mave-kau ijiakina mave-sifi kumate boeje fu kuaema ijene kena ruae. Fu kena romoga e inokiro ije bune mave-kau kumate besu ro sifi kumate besu ijiege ke maziena fata besubesu ijia zinone ifaejei. ");
INSERT INTO bbb_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Areme Berame fune Beraki kuae, Ani zinone one ijiebuo irifo ijia fike na nosukua gafiebureki vaga E Ireobo fu ijia biediena vua bino kuariero bagano kuae. Ro fu vua bino kuariekuma na una ro a kuarakono kuae. Fu ijiege kuarana areme Berame fune are etura nafare ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Fu ijia vakoga Godi fu arina biemoga Berame fu kuae, Na fata zinone ifaejedufuo ije nane seveni (7) ijiege amaeriae. Areme nane fata besubesu ijia mave-kau kumate besu ro sifi kumate besu ijiege maziena ijia zinone ifaejevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Fu ijiege kuaramoga Godi fu Berame kuae, Ni una va vua ige na kuaravo ijene Beraki kuarano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Areme Berame fune una va gake Kini Beraki fu uria e Moabaetiko ijiebuo e mamekanu ijena zinone fuone bu ifaejeva irifo ijia irei. ");
INSERT INTO bbb_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Areme Berame fune uri vua fuone ije ijiege kuae, Beraki e Moabaetiko ijiebuo kini ije fu aesakae Siria uruo ije mazani ajiamo nake ijia mesiriena una igia ruae. Areme fu kie, Ni e Jekafudo uifari ije kuravajia areme vua ma ise bino e Isureroko ije buesina kuaeno kie. ");
INSERT INTO bbb_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Rove na izege uri e ije Godi fu naebe kuravajiakiro vierafema ije kuravajiake? Ro kuke na izege e ije Godi fu naebe vua ise bino buesina kuaekiro vierafema ije buesina vua ise kuaeke. ");
INSERT INTO bbb_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Na nafare kubi ije mune ijiaru ireva ijia mani nesena bu giae. Ro bu ije na giaga buka turaekisana buebe irigi kafaena karinoeve. Ro kuke buka e ma uruvana rove bu e aesakae gue arafiriavo baki. ");
INSERT INTO bbb_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Ro erare e Jekafudo uifari ije ka ma uruvana davare ajare igege zaraema ije dake? Ro kuke erare e Isureroko ijiebuo uifari ije bu rade tuanavo ije dake? Ro na vierafe naka e maturaeva bu oevo na buenina ijiege baronekiro vierafevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Fu ijiege kuaemoga Kini Beraki fu fiena uri kuae, A vua ije a irere kuaeme? Na a na mesira ruaeva ije a e Isureroko e ani none ije kuravajiakiro na ijadufuo mesirana ruae. Rove a naebe kuravajia ro aka una bu daro miaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Fu ijiege kuaramoga Berame fu kuae, Na vua bino nabe none vierafeva ijia kuaeke. Ro name vua irere E Ireobo fu kuariema na ijiaru kuaekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Areme Kini Beraki fune uri Berame kuae, Ni roga no una are be ijia vaga a noefuo ijia manina e Isureroko ije akaeguekinu giana kuravajiano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Beraki fu ijiege kuara areme fune Berame mesirina are Zofimi uruo Fisiga kubi ijia vae. Bune va ijia usiae areme Beraki fune uri fata zinone ifaejedufuo seveni (7) ijiege amaeriae. Areme fune mave-kau kumate besu ro sifi kumate besu ijiege maziena fata besubesu ijia zinone ifaejevano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Areme Berame fune Kini Beraki kuae, Ani zinone one ige no ifaejeva ijia manike na gafia va E Ireobo ije bieno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Areme fune ijia vakoga E Ireobo fu ari ijia biena vua kuarae. Areme fu uri kuae, Nine una va Beraki vua ige na kuaravo ige kuarano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Ijadufuo fune una va gake Beraki fu e Moabaetiko ijiebuo e mamekanu ijena zinone fuone bu ifaejeva irifo ijia manine. Fu ijia maninoga Berame fu romoga fu kuae, E Ireobo fu vua izege kuaraemano kuae? ");
INSERT INTO bbb_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Fu ijiege kuamoga Berame fune uri vua ijiege kuae, Beraki e Zifodo fari gure vua ige na kuaravo ije mukoreigia fiene. ");
INSERT INTO bbb_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Godi fuje fu ema bakido fube vua kufuimeke. Ro kuke fu emabuo fari baki ijadufuo vua irere fu rekiro kuaemo ije fu aremo bakiro fuka reko fu riaremo. ");
INSERT INTO bbb_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Ro naeje fune fure daro miena kiemo na daro miaedo na izege arekuva baki. ");
INSERT INTO bbb_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Na gaga e Isureroko bu rade ise bino biediakuvejo baki. Ro Godi E Ireobo buone ije fuka buina oenoeno ro fuje bu kua fu Kini buoneno kuavo. ");
INSERT INTO bbb_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Fune Godire korufuo are Ijifiti ijia kaenamiana keke ruaema ijadufuo fune fure korufuo mave-kau kumate baego igege buefuo bijaemo. ");
INSERT INTO bbb_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ro fu erare e Isureroko ije kuravajiana kame isekafiakuma baki. Ro e bu ije giavo bu kuaeko, Kame Godire vame maeje e Isureroko ijiebuo remo ije gano kuaeke. ");
INSERT INTO bbb_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Ro e Isureroko ije buka fanu raejoni ije fu vasia oega fu fanu gue sakiana buvua ikiro samua namo igeki. Fu samuana fi vakuma fanu be gakuma fu sakina i furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Berame fu ijiege kuaemoga Beraki fu kuae, Ro a vierafega e ije a naebe kuravajiavoga ni e ije a daro miamo ije ijareno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Rove Berame fu una kuae, Na aeje nane kuarae. Na kua na ire boeje naka irere E Ireobo fu vierafema na ijiaru rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Kini Beraki fu Berame kuae, Ni roga na mesirana una are be ijia vane. Na vierafe no ijia vakuva Godi fu bite are ijia oemarega a e ije noefuo kuravajiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Ijadufuo Beraki fune Berame mesirina uruo Fio kubi ijia vakoga fu ijia mani nesena ae sao ije rere. ");
INSERT INTO bbb_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Areme Berame fune Kini Beraki kua, Ni noefuo mune ijia karina fata seveni (7) zinone ifaejedufuo ije nana amaeriane. A ijiege re areme nine mave-kau kumate seveni (7) ro mave-sifi kumate seveni ijiege noefuo kena rono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Fu ijiege kuamoga Beraki fune uri mave-kau kumate besu ro sifi kumate besu ijiege ke maziena ijia fata besubesu ijia zinone ifaejei. ");
INSERT INTO bbb_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Areme Berame fu gake E Ireobo fuka e Isureroko ije daro miana ifejiakiro vierafemaga fu ijene gae. Ijadufuo fu naebe una e Isureroko ije kuravajiakiro vierafe ro fume una dakudena e Isureroko ije bu ae sao ijia kariva ije nake rerei. ");
INSERT INTO bbb_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","3","Fu ijia mani gake e Isureroko ije buka agane buone binobino ijia afuina are muvuaka sana karinoeva fu giae. Fu ijiege manina giamoga Godido Kavene ije fu arina fu niromoga fu uri vua ijiege kuae, Vua ige e Berame e Beodo fari ije nare kuaeve. Na iviama ijare vame maeje nane mukoreigia giana vierafei. ");
INSERT INTO bbb_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Ro kuke na Godido vua ije naneka mukoreigia fievo. Na irere E Ireobo Ka E Daroki fu vierafe na giakiro fu vierafema na ije nimamaena giavo. Na giaga fuka oeseradiega na tuana uimutumutu sakaedo ijia dijevo. ");
INSERT INTO bbb_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Ro na e Isureroko ijiebuo are muvuaka bu sana karinoevo ije na giaga buka ma mukore. ");
INSERT INTO bbb_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Ro are buone mukore ije bu amare ijia kariva ije na giaga buka suve igege abe ira nirie. Ro kuke buka juare ije bu do irifo ijia meva ro kuke bu ine tabuave bu do irifo ijia ireva igeki. Ro buje buka ine ije udi mukore urimo E Ireobo ijare korufuo abena oema igeki. ");
INSERT INTO bbb_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Ro aesakae buone fuka ve uruvana daga uifari buone ije buka irere boeje bu vierafeva ije kedufuo. Ro kuke Kini buone fuka Kini Agagi asina ka e daroki rega e buka fukiro e fuone fu samuagiamo ijadufuo kame aroriake. ");
INSERT INTO bbb_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Buje bu Godire Ijifiti ijia kaenamiana keke ruae. Ro kuke fure daro miaga buka mave-kau kumate baego igege e ani buone ije iraraena kaniavo. Ijadufuo bure e aesakae gue bu buina bijaekuva buka bure iraraena juvuave buone ijia kame bijiana ane tuasedufuo. ");
INSERT INTO bbb_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Ro izege fanu raejoni fu e sakikiro saui namo igege E Isureroko ije buka e ani buone kaniakuae samua karinoevo. Ijadufuo fu erare bu kame niediakuma baki. Ro eranebe bu e Isureroko ifejiana marejiavo ije Godire bu marejiake. Ro eranebe bu e Isureroko kame isekafiavo ije Godire ve una bu kame isekafiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Berame fu ijiege kuaena e Isureroko ije daro miamoga Beraki fu ije gamo fuka ma ireobo defarui. Ijadufuo fu uri ubaeje sakinamikinu Berame kuae, Na aeje na kua a e ani none ije kuravajiano kuae rove aka maza inokubeke una bu daro miae. ");
INSERT INTO bbb_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Na aeje naka na ire gorodikiro siruva ije vajokiro kuae. Rove E Ireobo fu ire ije na a vajakiro kuaeva ije fu bijukurae. Ijadufuo a iviama una migegire are one ijia vano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","13","Fu ijiege kuaramoga Berame fu kuae, Na e ije a kiamoga bu mesiriekuae vuaeva ije nane kuariae. Na kia, Na vierafe Beraki fute ire gorodikiro siruva ma uruvana vajiekiro vierafe. Rove nabe uri vierafe none ijia ire ma ro ise bino redufuo. Ro kuke nabe irere E Ireobo fu vierafema ije asina una none vierafeva ijia reke. Ro name vua irere E Ireobo fu kuariema na ijiaru kuaeke. ");
INSERT INTO bbb_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Na iviama nane e none kariva ijia vakuvejo ijadufuo ni roga na vua be izege e Isureroko bu rade e one ijiebuo redufuo ije kuarano kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Vua ige Berame e Beodo fari ije nare kuaeve. Na iviama ijare vame maeje nane mukoreigia giana vierafevo. ");
INSERT INTO bbb_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ro kuke na Godido vua ije naneka mukoreigia fievo. Na irere E Ireobo Ka Daroki ijadufuo vierafe ije fu noefuo vierafema na ije nimamaena giavo. Na giaga fuka ni nafariemone na tuana uimutumutu sakaedo ijia dijevo. ");
INSERT INTO bbb_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Ro kuke na e ije fu e Isureroko no karaunuodufuo ije nane gae. Rove e ije fu iviama ruakuma baki ro sone rade ruake. Rade e Jekafudo uifari ijia e be fu uri Kini rena fure e Moabaetiko ijiakiro e Setido uifari bu ae sao ijia kariva ijene kame arafiriadufuo. ");
INSERT INTO bbb_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Ro fure e ani fuone aesakae Idomikiro Sia karivo ije kania areme aesakae buone ije abeke. Fu ijiege rega e Isureroko ije buka maza boeje ijiege e daroki rena kari vake. ");
INSERT INTO bbb_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Ro e Jekafudo uifari ijia E Ireobo be fu Kini rega fure e nugune bu uria sidove Ireobo ijia kariva ije ka uinitu furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Areme Berame fune una kuke e Amarakaetiko ije giana buesina vua ijiege kuae. Fu kuae, E aesakae boegeigia karinoeva ijiebuo uve ijia e Amaraetiko ije buka ma e daroki rove rade e ije buka bakirekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Berame fu vua ijiege kuae areme una dakude e Kenaetiko ije giana vua ijiege kuae. Fu kuae, Jaeje jaka ume buruome ige fu nafare kabo munuage ado ijia are fuone saema ijiege jaeje jaka are ma daroki ijia mukoreigia kari. ");
INSERT INTO bbb_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Rove rade bu e Asiriako ijiebe e jone ije kaenamiana va dibure unia areme rade bu ja kaniana uinitu furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Areme Berame fu kuke kuae, Godi fu ijiege rekuma fu e be erare uria una ijia fivakuma baki. ");
INSERT INTO bbb_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Ro e Saefurasiko ije bu sisime kena ro e Asiriako ijiakiro e Ebako ijena bijaekuva buka bure iraraena kania furike. Rove rade e Saefurasiko ije budua buka ebe kaniaga bu oe furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Berame fu vua ijiege kuaema furi areme fune una vakoga Beraki fudua fune una are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","18","(-) ");
INSERT INTO bbb_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","65","(-) ");
INSERT INTO bbb_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","11","(-) ");
INSERT INTO bbb_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Areme maza be E Ireobo fu Mosisi kuae, Ni nafare Abarimi makave ijia ajia vane. A va ijia manina are ije na abe e one Isureroko ije miakino kuaeva ije gane. ");
INSERT INTO bbb_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ro ni vierafe are ije a va manina gadufuo ije rade a izege uvia one Eroni fu uruo ijia baronema ijiege adua a ijia baroneke. ");
INSERT INTO bbb_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Ijadufuo maeje e boeje bu do Meriba ijia buka dofuo na ziegafiena noesina kuae. Naeje naka e akae rove e inokiro ja naebe urina e boeje ijiebuo nidua ijia na dabe e akae igege aroriekinu ro irinievano kuae. (Ro do Meriba fu ae sao bu kua Zinino kuavo ijia ro are ije fu are Kedesi ivuake ijia). ");
INSERT INTO bbb_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","16","Areme Mosisi fune baname isoena kuae, E Ireobo Godi none aeje aka e boeje ni uria karivo ijiebuo kavene ije samuagiamo. Ijadufuo a isekie ni E Ireobo be fu e Isureroko ige samuagiadufuo ije abe miane. ");
INSERT INTO bbb_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","A e ije abe miaekina fure e ige kaenamiana vaga bu azo kenoedufuo. A ijiege rekina ijadufuo e ige bube mave-sifi ije e samuagiavo baki igege renoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Fu ijiege kuaramoga E Ireobo fu una kuae, Ni Josua e Nanedo fari ije fu Godido Kavene abema ije kuaga fu roga umui nigofo nijana daro mane. ");
INSERT INTO bbb_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Areme nine e boeje ijiebuo nidua ijia e ije mesirina Eriza e zinone ifaejemo ijadufuo vaga fu umui nigofo nijana daro mane. Fu ijiege daro maga ni kua fu E Ireobo rena i ije e Isureroko samuagiadufuo ijene mene. ");
INSERT INTO bbb_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Ro ni daro ije a abema ije bino fu vajaekina e boeje bu fu aguaekinu irinane. ");
INSERT INTO bbb_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Ro Josua fu E Ireobo ijadufuo vierafe bino mukoreigia giakiro vierafekuma fuka vaga Eriza e zinone ifaejemo ije fu ifejadufuo. Fu ijia fuone vaga Eriza fu mune akae Urimino kuavo ije abena Godi irere fu rekiro vierafemo ije fiena una Josua kuarane. Areme Josuakiro e Isureroko boeje bu ijia sone irere bu redufuo Godi fu vierafemo bu ije giana samadireno kuae. ");
INSERT INTO bbb_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Ijadufuo Mosisi fune izege E Ireobo fu kuaraema ijiege rena uri Josua kuamo fu Eriza e zinone ifaejemo ijiakiro e boeje ijiebuo nidua ijia mani. ");
INSERT INTO bbb_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Fu ijia manikoga Mosisi fune izege E Ireobo fu kuaraema ijiege rena uri umui nigofo nijana daro mae. Areme fune kuamoga fu E Ireobo rena e Isureroko ije samuagiae. ");
INSERT INTO bbb_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","31","(-) ");
INSERT INTO bbb_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","40","(-) ");
INSERT INTO bbb_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","16","(-) ");
INSERT INTO bbb_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","54","(-) ");
INSERT INTO bbb_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","42","(-) ");
INSERT INTO bbb_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","56","(-) ");
INSERT INTO bbb_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","29","(-) ");
INSERT INTO bbb_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","34","(-) ");
INSERT INTO bbb_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","13","(-) ");
INSERT INTO bbb_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","Mosisi e Godido imeno ije fune baronekoga E Ireobo fu Josua e Nanedo fari ije fu e Mosisi ifejamo ije kuae, ");
INSERT INTO bbb_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","Iviama Mosisi e ije noefuo i meno ije fune baronei. Ijadufuo nika urina e none Isureroko boeje kaenamiana do Jodeni tuana gara aesakae ije na miakiro kuaeva ijia vane. ");
INSERT INTO bbb_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","Ro izege na Mosisi kuaraeva ijiege na are boeje iziebure a e ije kaenamiana diake ijia ura vako sakae ije na abe ja miake. ");
INSERT INTO bbb_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","5","Ro aesakae jone ijadufuo ubine ije fu ae sao ijare irina ari vakuma aesakae Rebanoni ijia vake. Ro ikene gue ije fu do ireobo Iufuretisi ruvaema ijare irina ari vakuma do davare Meditereniani nafuema are ukua ije na abe ja miake. Ro aesakae foteke ije fu e Itaetiko ijiebuo. Ro naeje na izege na e Mosisiki finoeva ijiege naka una obiki finoeke ro nabe a abuejana vake. Ro maza ije a uria fino ije e be fu erare iraraena a asidakuma baki. ");
INSERT INTO bbb_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","Ijadufuo anika giriesa daromena e none boeje kaenamia vaekina bu aesakae ije na ma isuibe asaerafa buone ije miakiro kiaeva ije abeke. ");
INSERT INTO bbb_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","Ro kuke nika giriesa daromena akae none boeje Mosisi fu vajaema ijene iriniakiro ade ijuonemo. Vua boeje anika iriniana urari kenoekiro ade dasuvaesuvaenoeno. A ijiege rekuma ire boeje a renoeno ije buka maredufuo. ");
INSERT INTO bbb_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","Ro maza boeje anika buki akae ige dakinu ro mumaza kena mukoreigia nigofo one ijia vierafenoene. A ijiege rena vua boeje bu isoeva ijene iriniana renoekuma ire boeje a remo ije buka maredufuo. ");
INSERT INTO bbb_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","Ro ude na kuaraeva ijiege nika uri giriesana daro mekiro ade jumekinu oefiane abeno. Ijadufuo maeje E Ireobo Godi one ige naeje naka are iziebureki a oenoeno ije na uria osiki ijia oenoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","Areme Josua fune uri e Isureroko agane binobino ijiebuo e mamekanu ije kiae, ");
INSERT INTO bbb_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","Ni va are muvuaka e bu karivo ijia oenoekinu e ije kiaga bu sinuome buone boeje kanafuina samuafo. Ja maza inokubeke furikuma ja do Jodeni tuana va gara aesakae ije E Ireobo Godi fu abe miaema ijene jone abeno kiae. ");
INSERT INTO bbb_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","Areme Josua fune urina e Rubenikiro Gadi ijiebuo agane ijiakina e Manasado agane gue ije ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","Fu kia, E boeje ni vua izege Mosisi e Godido imeno fu kuariaema ije vierafefo. Fu kiae, E Ireobo Godi jone fu aesakae be miaga ja ijia oemarekinu dasu karikono kiaema ije igifureki. ");
INSERT INTO bbb_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","Ijadufuo nine agebara ro fanuve jone boeje ijena aesakae Do Jodeni ikene una mazani ajiamo nake Mosisi fu miaema igia karifo. Ja igia karike e bijaevo jone bu juvua magu abena ude vake uviarafa jone bu rade nuvediafo. Bu ijiege vakinu uviarafa jone ifejiana e ani buone ije kaniakuria areme ijia karike. ");
INSERT INTO bbb_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","Bu ijia karikega uviarafa jone bu va aesakae ije E Ireobo fu miakono kiaema ijene abefo. Areme rade nine una do Jodeni tuana va gara maza ajiamo nake ijia aesakae ije Mosisi fu miaema ijia karino kiae. ");
INSERT INTO bbb_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","Josua fu ijiege kuariamoga e Rubenikiro Gadi ijiebuo agane ijiakina e Manasado agane bu urina kuae, No vierafe noka vua irere boeje a kuaruema ije reke. Ro a are iziebure vano kuokuma noka irinana vake. No vierafe noka izege Mosisi no irinaeva ijiege una a irinake. ");
INSERT INTO bbb_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","Ro no vierafe E Ireobo Godi fuka izege fu e Mosisiki finoema ijiege fuka una obiki finoeke. ");
INSERT INTO bbb_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","Ijadufuo anika giriesana daromene. Ro erare fu faememarenoekinu vua one ije karatuakinu ro a naebe irinakuma e ije noka mune tuana kanaga fu baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","E Isureroko bu are Akesia ijia are muvuaka sana kariva ijia e Josua fu e inokiro kiae, Ni va sakae do Jodeni gara ijia sidove ireobo Jeriko ivuake ijia mauike mukoreigia ninakono kiae. Fu ijiege kuariamoga bune vakuma gafia usiaevo funeka ve mumoga bu bara amune Reabi ebuo baru turanoeno ijadufuo are ijia naokuae vae. ");
INSERT INTO bbb_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","Rove e be fu va e Jerikobuo kini ije kuae, E Isureroko bino bune are ige ninakokuae muge ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","Ijadufuo kini ije fune uri bara Reabi vua ijiege nijana kumei, E ije bu ro are one ijia kariva ije buka ebe kiavo bu vame izege bu ro no kanuodufuo ijene gakuae ruae. Ijadufuo a kaenamiana roga na giano kumei. ");
INSERT INTO bbb_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","Rove bara Reabi fuka fena una kumei, Ije ane ma kuae. E bino bune ma ve nakisirema ijia are none igia ruae. Rove e ije bu e izeko ije naka naebe mukoreigia giae. ");
INSERT INTO bbb_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","Bu ve fune nakisirema sidove viene bu bijuvo ije fune ivuarema ijia bu vae. Ro bu vame izane vaeva ije naka naebe giae. Ijadufuo ja nuvediakuva ja biediakono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","(Bara Reabi fu e ije vua abe ruaeva ijene ijiege kuariae rove fune ude e ije avaegiakuae ruaeva ije fu kaenamiana are fuone ado fu ire firekisi nubuane igeki fu maza uviaema ijia urie.) ");
INSERT INTO bbb_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","Ijadufuo kinido e ije bune e ije reriana vakuma vame ije bu do Jodeni tuana vako ijia usiae. Bune ijiege usiae reriana vakoga bu gue sidove ijadufuo viene bijui. ");
INSERT INTO bbb_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","E ije bune ijia naokuae kariva ijia muge bara amune Reabi fune ajiana va are ado ijia kekena e ijena vua kuae. ");
INSERT INTO bbb_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","Fu kiae, Na vierafega E Ireobo aesakae ige fune abena e Isureroko ije ja miae. Ro kuke e aesakae igia kariva ije noka ma ireobo ja jumevano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","Ijadufuo maeje none izege ja are Ijifiti arena rovoga E Ireobo fu Davare Kavuane kuamo fu sikoga ja ijia urana ruaeva no ije fie. Ro kuke no izege ja do Jodeni irifo maza ajiamo nake ijia e Amoraetiko ijiebuo kini e Sionikiro Ogi ijiebuo e ije kaniana uinituva no ije fie. ");
INSERT INTO bbb_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","No ire ije ja reva ije fievo fuka oeseraduema ijadufuo noka jumei. Ro kuke e ige bu vua ije fieva ije bu izege uri daro abena bijaekuva baki. Ijadufuo maeje no vierafega E Ireobo Godi jone ije fuka Godi saove gufiakiro ume igadufuo Godi ijene. ");
INSERT INTO bbb_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","13","Ijadufuo ja isekie nika E Ireobo jone ijadufuo ive ijia kurana kieko ja agane none ijena jabe kanuokiro ja karaunuokono kiega na fiefo. Ijadufuo maeje maza ije ja ruaeva ije naka ja marejiae. Ijadufuo na vierafe jaka nuga be nijasiega na ijia gadufuo. Na ijia gana vierafero maza ije ja are ige tuguakuae ruovo ije ja orafa none ijiakina makirafa ro uviarafa ro anafa buone boeje ja karaunuokiro na ijiege vierafeno kiae. ");
INSERT INTO bbb_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","Areme e inokiro ije bune uri kuae, A no ifejuona karaunuokuma nodua no ja karauniake. Ijadufuo a no ruaeva ije a naebe e bino kuariakuma no vua irere no kuaraeva ije nobe toteke. Ro E Ireobo fu aesakae ige abe muokuma no akina agane one boeje karauniakono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","16","Ro bara Reabido are ije fu faere bu mune ijia kirana ajiaeva ijiakuma besu ifena sae. Ijadufuo fune urina kiae, Na vierafe na kaje abe kirana saene ijia abiesega ja ijia ari vake. Ro ja vakuva nine va uruo gafia sauina karifo. Jani maza inokubeke ijia sauina karike e ije bu ja reriana usiae vaeva ije bu una roga nine ijare una e jone kariva ijia vano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","18","Areme e inokiro ije bune vakuae uri vua ijiege bara ije kuarae. Bu kuae, No vua irere no a kuaraeva ije nobe toteke. Ijadufuo igia fiene. A maza ije no are one ige tuguakuae ruovo ijia nika kaje kavuane ijia abena isuo tire ije a kuomo no ariva ijia kirane. Ro orafa one ijiakina makirafa ro uviarafa one ijiebuo agane boeje nika kiaga bu mauike are one guove ijiaru karine. ");
INSERT INTO bbb_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","Ro erare fu are one ije arena keke vame ijia oenoeno bu kanakuva ije funeka korufuo irufui abeke. Ro agane one boeje bu uria are one ijia kariva ijia e bu kaniakuva irufui ije nore abeke. ");
INSERT INTO bbb_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","A irere ige no renoevo ije e bino kuariakuma no vua ige a kuomoga no kua no rekono kuaeva ije nobe rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","Bu vua ijiege kuaravoga bara Reabi fune uri kiae, Ije fune maredo nane ijiege rekono kiae. Areme fune e inokiro ije uniamoga bune kaje arina vae. Bu vakoga fu uri kaje kavuane abena isuo tire bu ariva ijia kirae. ");
INSERT INTO bbb_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","Areme e inokiro ije bune arina subinae vakuma uruo ijia maza inokubeke sauina kari. Bu ijia karikoga e ije bune usiae va rerianoega baga bu arena una ruae. ");
INSERT INTO bbb_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","Areme e inokiro ije bune uruo ije arena una do Jodeni tuana gara vae. Bune vakuma Josua e Nanedo fari ije fino ijia usiaena vua boeje izege bu are Jeriko ijia reva ijene Josua kuarae. ");
INSERT INTO bbb_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","Bu kuae, E Ireobo fu aesakae ije fune abena no mue. Ijadufuo maeje no giaga e boeje aesakae ijia kariva ije buka ma ireobo no jumevono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","Areme nituame suoke mugamia Josua fune e Isureroko boeje ijena bune are Akesia arena vakuma do Jodeni irifo ijia usiae. Bu ijia usiaena uri are muvuaka sama areme ijia kari rove bu naebe do tuana gara vae. ");
INSERT INTO bbb_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","Bu uria ijia kari vakuma mu inokubeke furiko ijia e buone mamekanu ije bune oenoekinu e boeje izege bu redufuo ije kuariae. ");
INSERT INTO bbb_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","Bu kiae, Ja karikinu giaga e Rivaeti Godido zinone ifaejevo bu E Ireobo Godi ijadufuo Mavua Akae ije abe giena vaga ni uri are muvuaka jone farae areme sinuome karina bu vako ijia nuvediafo. ");
INSERT INTO bbb_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","Ja vame ije bu vako ije ude ja naebe ijia vae ijadufuo nime bu vako ijia giakinu nuvediana vafo. Ro jade ivuake ijia buina biezinamina vako ro nime sibaneke mumabo ijia nuvediake bu Mavua Akae ije giena ude vano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","Areme Josua fune urina e boeje kiae, Nine uri ise jone ije Godi visu kuarakinu oe jone amaerinamifo. Ijadufuo maeje E Ireobo fuka isuome ire sumiki ka daroki bino nidua jone ijia rega ja giakono kiae. ");
INSERT INTO bbb_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","Areme nituame suoke Josua fune uri e zinone ifaejevo ije kiae, Urina Mavua Akae ije abe giena ude do ije tuana vake e boeje bu nuvediano kiae. Fu ijiege kuariamoga e zinone ifaejevo ije bune fu kuariaema ijiege rena uri Mavua Akae ije abe giena vakoga e boeje bune ijia nuvediana vae. ");
INSERT INTO bbb_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","Areme E Ireobo fune uri Josua kuae, Na ivia zinuevena a abe e Isureroko boeje ijiebuo nidua ijia a arorake. Na ijiege rega bu ijia gana vierafero na izege na Mosisiki oenoeva ijiege na una osiki oenoevoro bu a mukoreigia aguarakinu irinake. ");
INSERT INTO bbb_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","Ro kuke ni e zinone ifaejevo ije kia, Ja Mavua Akae ije abe vakuma do Jodeni irifo ijia usiaekuva ni ari do ije sibaneke tuana samua ireno kiae. ");
INSERT INTO bbb_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","Areme Josua fu urina e Isureroko ije kiae, Ni e boeje biona ivuake igia irekega E Ireobo jone fu vua izege kuariaga ja fiefo. ");
INSERT INTO bbb_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","Ivia Godi jone ije ni uria fino ije fu ire sumiki be rega ja ije gana vierafero fuje fu maza boeje jaena oenoeno ja ijiege vierafeke. Ro kuke fuka e Kenanaetikiro Itaetiko ijiakina e Ivaetikiro e Ferisaetiko ijiakina e Gegasaetikiro Amoraetiko ro e Jebusaetiko ije iraraena kaniakuriake. ");
INSERT INTO bbb_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","E aesakae irore ijiebuo E Ireobo ijadufuo Mavua Akae ije bu abe ude do Jodeni tuana vaga ja ijia nuveke. ");
INSERT INTO bbb_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","Ro ni e Isureroko ijiebuo agane tuero (12) guove ijia e besubesu kene. ");
INSERT INTO bbb_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","Ro maza ije e zinone ifaejevo bu E Ireobo ijadufuo Mavua Akae ije abena iko do ijia tuakuva Godi fu ire sumiki be joefuo reke. Do ije fu naebe una ruvake ro fuka dabe turasena nafue ajiake ro zinume fu sikono kiae. ");
INSERT INTO bbb_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","Areme e boeje bune uri are muvuaka ijiakina sinuome buone kanafuima bune do Jodeni tua vakuvejoga e zinone ifaejevo ije bu uri Mavua Akae ije abena ude vae. ");
INSERT INTO bbb_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","Ro maza ijia fuka ve vadefuo damo ijadufuo do Jodeni fuka ma ireobo firame. Rove maza ije e zinone ifaejevo bu Mavua Akae ije abe areme dia buone nafena do ijia bierevoga do ije fu ruomo ije fune ijia si. ");
INSERT INTO bbb_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","17","Fu ijiege sikoga do ije fuka ireobo niguna una ajia vakuma are Adame ijia vae. Ro are Adame fuka mumabo ijia ro fu sidove Zaretani ivuake ijia. Ro do Jodeni zinuine fu kanana davare bu kua Do Sorokino kuavo ijia vaema ije duaku funeka si furi. Areme e Mavua Akae abe oenoejo ije bune do Jodeni ukua ijia irekoga e boeje bu Mavua Akae ije fu manino ijia iriaeki asina bune gara vae. Ro do ije bu are Jeriko ivuake ijia tuana vae. ");
INSERT INTO bbb_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","2","E boeje bune do Jodeni tuana gara va furikoga E Ireobo fu Josua kuae, Ni e boeje ijiebuo agane tuero guove ijia e besubesu kene. ");
INSERT INTO bbb_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","Areme nine kiaga bu do uvuoka ije e zinone ifaejevo bu ireva ivuake ijia arina mune tuero (12) karana va are iziebureki bu naokuvejo ijia besu nano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","Ijadufuo Josua fune urina e boeje ijiebuo agane tuero uve ijia e tuero fu ude kema ije kiamo bu besu afui. ");
INSERT INTO bbb_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","Bu ijia afuivoga fu kiae, E besubesu nine va do Jodeni ukua ije e Mavua Akae abena ireva ijiebuo nidua ijia mune besubesu karana kamudiafo. Ro mune tuero ije ja kara vako ije ja e Isureroko agane tuero ijiebuo akaegue ijia karave. ");
INSERT INTO bbb_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","7","Ro maza rade anafa jone bu giana kiako mune ije bu irerefuo karana ijia naevano kiakuva ni vua maeje kuariafo. Ni kia, Mune ije bu maza ije E Ireobo fu do Jodeni abe ata guegue reko Mavua Akae fuone fu ijia urana vakoga no ijia karae. Ijadufuo mune ije bu karina ijiege naekina e Isureroko bu maza boeje ije giavo ijia bu Godi irere fu rema ije vierafekono kiano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","9","Ijadufuo e ije Josua fu keva ije bune uri vua irere E Ireobo fu Josua kuaramo fu kuariaema ijiege rena uri mune tuero do Jodeni fu sima ukua ijia karae. E tuero ije bune uri E Isureroko agane tuero ijiebuo ive ijia mune tuero karae. Areme bune kame kamudiana vakuma are bu naokuvejo ijia besu nana ajiae. Ijiege rena Josua fune kuke mune tuero ijia besu nana ajiae. Ro mune ije bu naeva ije iviama bu uria ijiege naove. ");
INSERT INTO bbb_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","18","Ijiege rena e zinone ifaejevo ije bu Mavua Akae ije abena uria do Jodeni ukua ije irei. Bu ijia irekoga e ije bune uri ire boeje E Ireobo fu Josua kuaraema ijene rema furi. Ro amure e Rubiniko ijiakina e Gadiko ro Manasako e akaegue ijiebuo e azo kevo ije bune urina juvua magu buone kena ude vakinu e Isureroko gue ije samuagiana kaenamia vakuma do Jodeni gara usiae. Ro e azo kevo ije buka ma uruvana e foti tauseni (40,000) ijiebe ude efunena E Ireobo ijadufuo nidua ijia aesakae Jeriko amare ijia urana vae. Bune ijiege rena vakoga e Isureroko boeje bu migegire nuvediana do gara vakuma furi. Areme e zinone ifaejevo ije bune rade E Ireobo ijadufuo Mavua Akae ije abena vakuma irifo gara ajiae. Areme do Jodeni fune una izege fu ude firamo ijiege una firae. Ro maza ijia E Ireobo fu e Isureroko ijiebuo nidua ijia e Josua dabe ijiege nidoena aroemoga e boeje bu ijene gae. Ijadufuo bu urina izege bu e Mosisi dabe nidoekinu aguaeva bu ijiege una e Josua dabe nidoena aguaekinu vae. ");
INSERT INTO bbb_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","Ro maza ije e Isureroko ije bu do Jodeni arena vaeva ije bu asame amure ijadufuo mazani teni ijia vae. Bune vakuma sidove Jeriko sakae una maza ajiamo nake ijia usiaena bune are Gigaro ijia are muvuaka buone sae. ");
INSERT INTO bbb_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","Areme Josua fune uri mune tuero ije bu do Jodeni ukua ijia kara vaema ije karina are Gigaro ijia besu nana amaeri. ");
INSERT INTO bbb_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","22","Josua fu ijiege re areme uri e Isureroko ije kiae, Ja maza rade uifari jone bu ja kiako mune ije bu irerefuo ijiege naevano kiakuva ni ijiege kuariafo. Ni kia, No do Jodeni noka iriaeki tuana ruae. ");
INSERT INTO bbb_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","Ijadufuo maeje E Ireobo Godi nuvuone ijare do Jodeni nuvuefuo bijumo fu sina iriarekoga no ijia urana ruae. Godi fu izege Davare Kavuane ije kuamo fu sikoga no iriaeki urana ruaeva ijiege fu una kuke Do Jodeni ijia ire besu ijene rei. ");
INSERT INTO bbb_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","Fu ijiege rekina e boeje aesakae irore igia kariva bu bite ijia gana vierafero E Ireobo ijadufuo umui ije fuka darokiro bu ijiege vierafeke. Ro kuke fu ijiege rekina jaka maza boeje E Ireobo Godi jone ije aguaekinu irinakono kiae. ");
INSERT INTO bbb_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","Areme e Amoraetiko ijiebuo kini boeje bu do Jodeni irifo una maza koeno nake kariva ijiakiro e Kenanaetiko ijiebuo kini boeje davare irifo ijia kariva ije bu vua ije fie. Bu izege E Ireobo fu do Jodeni kuamo fu sikoga e Isureroko boeje bu ijia urana vaeva bu ije fie. Bu vua ije fievoga buka ma ireobo oeseradiana ane ausiae ijadufuo bu izege uri giriesana e Isureroko ijena bijaekuva baki. ");
INSERT INTO bbb_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","Ijiege rena E Ireobo fu Josua kuae, Ni mune fae ijia kena sime uiki bino amaeria areme kena e Isureroko e fari eranebe bu surive buone naebe kania ufuiva ije kaenamiana nuga naejiano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","Ijadufuo Josua fune sime uiki bino amaeria areme kena are Gibiati Araroti ijia e Isureroko ijiebuo vajae surive ije kania ufuna nuga naejiae. ");
INSERT INTO bbb_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","7","Ro ude e fari bune bijaedufuo maniva ije bu Ijifiti arena usiae ruaeva ije bune vajae surive buone kania ufuna nuga naejiae. Rove e ije bu juaevasia foti (40) ijiege ae sao ijia oenoeva ije buka naebe Godi irinae. Ijadufuo Godi fu kia bube aesakae ije ire uruvana zaraema ije fu abe miakono kiaema ijia vako kiae. Ijadufuo e ije bune ae sao ijia oema furi. Areme E Ireobo fu uri anafa buone kemoga bure una orafa buone ijiebuo are ije abei. Rove e ije bu uria naebe kena nuga naejiae. Ijadufuo Josua fu e ijiebuo vajae surive ije kania ufuna nuga naejiae. ");
INSERT INTO bbb_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","E boeje bune ijiege rena mauike are muvuaka buone ijia kariko vakuma matane buone bu subiema furi. ");
INSERT INTO bbb_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","Areme E Ireobo fu uri Josua kuae, Na ivia Ijifiti ja karina e ijiebuo moni baki imekinu jaeve abeva ije nane abe akoevono kuae. Ijadufuo are ije iviama bu kua Gigarono kuavo. ");
INSERT INTO bbb_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","Ijiege rena bu uria are Gigaro amare are Jeriko ivuake ijia kariva ijia bu asame amure ijadufuo maza fotini ijia iro Fasova ije i. Bu iro ije ikinu izege E Ireobo fu Ijifiti ijia e Isureroko ijene kaenamia keke ruaema ijadufuo oemarei. ");
INSERT INTO bbb_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","Bu iro Fasova ije ima areme nituame bune ire gue aesakae ijia tavuavo ro ire vuiti bu ifaejeva ro kuke ire burete isiti baki bu ifaejeva ijene i. ");
INSERT INTO bbb_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","Bu ire ije kena ima areme rade burete mena ije bu ivo ije fune ve ijia furi. Fu furinoga e Isureroko ije bu rade naebe una burete mena ije inoe ijadufuo maeje bune uri zinuevena ire ije aesakae Kenani ijia tavuavo ijene i. ");
INSERT INTO bbb_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","Areme Josua fune are Jeriko ivuake ijia kekema ijia fu gake e be fu sime farena nikubae fuone ijia manino fu gae. Ijadufuo Josua fune vakuma fu manino ijia kekena kuae, A no ifejuokiro ruae ke a e ani nuvuone ijiebuo ruaemano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","Fu ijiege kuamoga e ije fu kuae, Na e ani ijiebuo ruaeva baki ro na E Ireobo ijadufuo e bijaevo ijiebuo e nigofo rekiro ruaevano kuae. Fu ijiege kuaramoga Josua fuka uri fu aguaena tua uimutumutu sakae ijia dijei. Areme fu uri e ije kuae, Nana E Ireobo ijadufuo imevo. Ro E Ireobo ije fu vua irere noefuo a kuaraemano kuae? ");
INSERT INTO bbb_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","Areme E Ireobo ijadufuo e bijaevo ijiebuo e nigofo ije fu urina kuae, Are ige a manino ije fuka akae. Ijadufuo ni dia surive one a saema ije azona nano kuamoga Josua fune ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","Ro are Jeriko faere ijadufuo viene boeje buka mukoreigia bijukuriaeva ijadufuo e sidove guove ijia karijo bu izege usiae vakinu ro una aru ruakuva baki. Ijadufuo maeje E Jerikoko ije buka e Isureroko ijene jumevo ijadufuo bu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","Areme E Ireobo fu Josua kuae, Iviama na are Jeriko ijiakiro kini fuone ro e bijaevo boeje nane kena a vajado a iraerena kania furike. ");
INSERT INTO bbb_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","Ijadufuo ni e bijaevo one ijena sidove ireobo ije kaginu ufuaenoene. Janika maza besubesu ijiege kaginu ufuaena oenoekinu vakuma maza sigisi ijiege furifo. ");
INSERT INTO bbb_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","Ro nine e zinone ifaejevo seveni ijiege kega bu vegu fanu sife kumate ijiebuo muane ije kena Mavua Akae ije bu abe vako ijia ude vafo. Ro maza seveni ijia ni e zinone ifaejevo ije kiaga bu sidove ireobo ije maza seveni ijiege ufuaenoekinu vegu ufefo. ");
INSERT INTO bbb_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","Ro ja fiega bu vegu ije ufena ka ifenana vako ja fiekuva ni e boeje kiaga buka urukeigia vijena jarekafafo. Ja ijiege rega sidove ijadufuo faere ije fu diduena ariga e fari boeje bu ijia aru vano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","Areme Josua e Nanedo fari ije fune e zinone ifaejevo ije kumeno bu rovoga fu kiae, Ni E Ireobo ijadufuo Mavua Akae ije abefo. Ro e zinone ifaejevo gue seveni ije kiaga bu vegu bino kena Mavua Akae bu abe vako ije uineke ijia vano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","Areme fune una e Isureroko ije kiae, E boeje nine iviama zinuevena sidove ireobo ijia ufuaenoefo. Ro bu vakuva e bijaevo ije nine Mavua Akae bu abe vako nidua ijia ude vano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","Josua fune ijiege kuariama furinoga e zinone ifaejevo seveni ije vegu seveni keva ije bune E Ireobo ijadufuo nidua ijia zinuivena vae. Bune vakinu vegu buone ufekinu vakoga e zinone ifaejevo gue bu E Ireobo ijadufuo Mavua Akae ije abena rade nuvediae. ");
INSERT INTO bbb_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","Ijiege rena e bijaevo ije bune ude vakoga e zinone ifaejevo ije bune ijuone buone ijia vakinu vegu ije ufena ifenana vae. Ro e bijaevo gue bu E Ireobo ijadufuo Mavua Akae ije bu abe vako ijadufuo ijuone ijia nuvediae. ");
INSERT INTO bbb_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","Ro Josua fune ude uri e boeje kiae, Jade uri urukeigia e bijaevo bu jarekafakinu bijaevo ijiege revo. Ro kuke jade vua kuaekiro nime vaga nare kiako ni vijeno kiaga ni ijare vijeno kiae. ");
INSERT INTO bbb_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","Ijadufuo bune uri E Ireobo ijadufuo Mavua Akae ije abena sidove ireobo ije kaginu ufuaenoe. Areme e boeje bune una va are muvuaka buone ijia naoe. ");
INSERT INTO bbb_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","Areme nituame suoke mugamia Josua fune urimoga e zinone ifaejevo ije bune urina Mavua Akae ije abei. ");
INSERT INTO bbb_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","E zinone ifaejevo seveni bune uri vegu kena Mavua Akae ije bu abe vako uineke ijia ufekinu vae. Bu ijiege vakoga e bijaevo gue bune ude vakoga gue bu Mavua Akae ijuone ijia nuvediae. Ro e ije vegu ufevo ije bu naebe arei ro buka uria ufena ifenakinu vae. ");
INSERT INTO bbb_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","Areme nituame bune una kuke sidove ireobo ije kaginu ufuaenoena areme bune una are buone ijia vae. Bu maza besubesu ijiege rekinu vakuma maza sigisi ijiege furi. ");
INSERT INTO bbb_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","Ro maza seveni ije irasemoga bune mu gamia urina izege bu ude reva ijiege una sidove ireobo ijia ufuaenoe. Ro maza ijiaru buka mazani seveni ijiege sidove ijia ufuaenoe. ");
INSERT INTO bbb_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","Areme bune maza radekumaeje ufuaena vako ijia e zinone ifaejevo ije bu uri vegu buone ufei. Bu ijiege ufekoga Josua fu uri e boeje kumei, E Ireobo sidove ije fune abena ja miae ijadufuo nika urukeigia vijena jarekafafo. ");
INSERT INTO bbb_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","Ro sidove ireobo ijiakiro e ijia karivo ro ire boeje guove ijia naovo ije nika arafiria furidufuo. Ro Reabi bara ije ebuo baru turamo ijiakiro agane fuone eranebe fuina gire besu karivo ije jade kaniavo. Ijadufuo maeje fu e nuvuone bu mauike avaegianoejo ije kena urie. ");
INSERT INTO bbb_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","Ro ire boeje bu E Ireobo ijadufuo sinuome ijadufuo ire bino jade mauike kevo. Ro ja uria faememarena ire ijia bino kekuva jadua buka kaniaga ja oe furike ro kuke e Isureroko boeje noka irufui abekinu ma ireobo isejavaeke. ");
INSERT INTO bbb_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","Ro ire boeje bu siruvakina gorodikina buronisi ro ajane ijia kena amaeriaeva ije buka akae. Ijadufuo no kena E Ireobo ijadufuo are bu ire mukore fuone gue navo ijia nakono kumei. ");
INSERT INTO bbb_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","Areme bune uri vegu ufekoga e boeje buka uruvanaigia vijena jarekafavoga sidove ijadufuo faere ije fuka diduena ari. Fu diduena arimoga e boeje bu ijia urana sidove ireobo ije abei. ");
INSERT INTO bbb_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","Areme bu uri e bara ro baru ro e nikaki ro eove ro barasiki ijiakiro anafa buone ije buka arafiriana furigana ro bara Reabikiro agane fuone ijiaru bu arei. Ro kuke buka mave-sifikina doniki ro kau ijiakina ire buone boeje sidove guove ijia naovo ije buka mukoreigia arafiriana uinitui. ");
INSERT INTO bbb_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","Areme Josua fune e inokiro ije bu mauike va are Jeriko ninakoeva ije kiae, Ni va bara ije ebuo baru turamo ijadufuo are ijia aruna izege ja fu ifejiakono kuaeva ijiege fu ro agane fuone boeje kaenamiana usiaeno kiae. ");
INSERT INTO bbb_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","Ijadufuo e nikaki ije bu are ije mauike ninakonoeva ije bune va bara Reabi mesiri areme uri asie asoe ro makirafa ro e fuone boeje kaenamiae. Areme bune kaenamiana vakuma e Isureroko ijiebuo are muvuaka bu karivo ivuake ijia uniae. ");
INSERT INTO bbb_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","Areme e Isureroko bu uri sidove ireobo ijiakiro ire boeje guove ijia naovo ije foteke ke ifaeje. Ro ire ije bu siruvakina gorodikina buronisi ro ajane ijia amaeriaeva ije bu karina va E Ireobo ijadufuo ire akae bu karina navo ijiakuma besu nae. ");
INSERT INTO bbb_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","Ijiege rena Josua fune Reabi bara ije ebuo baru turamo ijiakiro agane fuone fu naebe kaniae. Ijadufuo maeje Reabire e ije bu mauike are ije ninakokuae ruaeva ije kena urie. Josua fu ijiege Reabikiro agane fuone karauniamoga bu e Isureroko ijena juaevasia uruvana kari vae. ");
INSERT INTO bbb_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","Areme maza ijia Josua fu uri E Ireobo ive ijia kurana vua ijiege kuae, E be erare fu sidove Jeriko una sakiro vierafenoeno e ije fu E Ireobo ijare dabe isekafake. Ro erare fune zinuivena una sidove ije sakiro tugie urumo e ijadufuo ame fari amure ije fu baroneke. Ro kuke erare fu sidove ijadufuo viene mamekanu ije una amaeriakuma e ijadufuo fari iviene fu baronekono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","Ijiege rena E Ireobo fuka Josua marejana daro mamoga e bu ive fuone dabe e sakae ijia kariva ijia kuaena iravae. ");
INSERT INTO bbb_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","Rove E Isureroko ije buka ise rena uri sinuome ije bu arafiria furidufuo E Ireobo fu kuariaema ije naebe irinana ijiege rei. Ijadufuo maeje e Eikenino kuavo ije fu sinuome gue mauike kema ijadufuo E Ireobo fuka defaruimoga fu uri e Isureroko ije ziegafiae. Ro e Eikeni ije fu e Kamido fari ro e Kami fu e Zimirido fari ro e Zimiri fu e Zerado fari ro agane boeje ige bu e Judado uifari. ");
INSERT INTO bbb_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","Areme rade Josua fune are Jeriko ijia figa e fuone gue kiamo bu sidove Ai ije mauike ninakokuae vae. Ro sidove Ai fu sidove be Bete Aveni ivuake ijia. Ro kuke fu are Betero una ikene maza ajiamo nake ijia. ");
INSERT INTO bbb_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","Areme e ije bune una ro Josua kuae, Sidove ije a kuomo no vaeva ije no vaga buka e uruvana ijia kariva baki. Ijadufuo e bijaevo boeje foteke no irerefuo vakuva baki ijadufuo nime e tu tauseni (2,000) ro ba tiri tauseni (3,000) ijiaru kiaga bu va e ije kaniano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","Bu ijiege kuaravoga fu uri e tiri tauseni (3,000) ijiege uniamoga bu sidove ije dabe arafirikuae vae. Rove buka e Aiko ijiebe iraraena e ije vaeva ije kame arafiriavo bu una subi vae. ");
INSERT INTO bbb_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","Bu sidove Ai viene ijia e Isureroko ije kame arafiriana vakuma are ije bu mune atavo ijia usiaena e teti sigisi (36) ijiege kaniavo bu oe. Bu ijiege revoga e Isureroko bu ire ije gavo buka urukeigia oeseradiana ka darobitenamiae ");
INSERT INTO bbb_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","Areme Josua fune vame ije bu reva ije gamo fuka ireobo oefiae. Ijadufuo fu uri ugone fuone faradia farae areme tuana uimutumutu Mavua Akae ije namo uineke sakaedo ijia dijena nako vakuma ve mui. Fu ijiege rekoga e Isureroko ijiebuo e mamekanu boeje buduaku oefiane abena uri kuokuo datena nigofo buone ijia akoe. ");
INSERT INTO bbb_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","Areme Josua fu uri kuae, E Ireobo no do Jodeni gare kariva ije fune marema anika arekuma. A irerefuo no kaenamuona do Jodeni tuana igia e Amarakaetiko ije vajiagana bu no kanuove? ");
INSERT INTO bbb_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","Ijadufuo E Ireobo na una vua irere a kuarake? Iviama e Isureroko ige noeje bune e ani nuvuone ijiebe kame arafiruovo no una subinae ruae. ");
INSERT INTO bbb_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","Bu ijiege reva ijadufuo e Kenanaetiko ijiakina e aesakae bino ijia kariva bu ije fiekuva buka e boeje no okuruona kanuo furikuva nobe una aesakae igia karidufuo. Ijadufuo a izege rega e bu naebe ive one anuigi ije dabe arafirikono kuae? ");
INSERT INTO bbb_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","Josua fu ijiege kuaramoga E Ireobo fu una kuae, Ni una urine! A irerefuo sakaedo ijia ijiege name? ");
INSERT INTO bbb_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","E Isureroko ije buka ise rena vua na kuariaeva ije bu naebe irinie. Ro buka uri ire ije na kia karina are none ijia noefuo irigi nano kiaeva ije iniemei. Bu ire ijiaru iniemeva baki ro bu kuke vua kufuimena sinuome ije karina una buone ijiakuma urie. ");
INSERT INTO bbb_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","Bu ire ije reva ijadufuo bu izege e ani buone ije kaniakuva baga buka una kuderiana subinae ruae. Ijadufuo bu naebe e ije eranebe ise reva ije kania bu oefuri ro kuke irere bu keva ijene rere giana kame mutukore furikuva nabe una buina finoekiro na kame isekafiake. ");
INSERT INTO bbb_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","Ijadufuo ni e boeje kuariaga bu ise buone visukinu oe buone ije amaerenami areme isuome ijadufuo samuane. Ijadufuo maeje e Isureroko ijiebuo Godi E Ireobo ije na ige kuariako fiefo. E Isureroko ja ire ije ja iniemeva ije bu uria kari nakuva ja izege uri giriesana e ani jone ije iraraena kaniakuva baki. ");
INSERT INTO bbb_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","Ijadufuo suoke e Isureroko ije nine agane mamekanu jone besubesu ijia usiaena E Ireobo nidua none ijia roga na agane izare ise rema ije abe samadirefo. Areme ni agane guove ijia e gaegi besubesu bu usiaena nidua none ijia roga na agebara fuone ijia erare ise rema ije abe samadirefo. Na ijiege rega e ije fu agebara fuone ijena bu e besubesu usiae nidua none ijia roga na erare ise rema ije abe samadirega ja gafo. ");
INSERT INTO bbb_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","Areme nine e ije ise rena sinuome iniemema ije mesiri areme nine agebara ro sinuome fuone boeje foteke kame fuina miane ijia ifaejefo. Ijadufuo maeje fure vua ije na kuarieva fu naebe irinie ro kuke fuka e Isureroko ijiebuo ive ijia vame omise ijene remano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","Ijadufuo nituame suoke mugamia Josua fune e Isureroko ijiebuo agane besubesu kiamoga bu usiaena E Ireobo ijadufuo nidua ijia ruae. Bu rovoga fu uri e Judado agane ijene abei. ");
INSERT INTO bbb_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","Areme e Judado agane ije bune una kuke agane buone binobino ijia besubesu usiaena rovoga fu uri e Zeraetido e gaegi ijene kei. Areme e gaegi ije bune usiaena rovoga fu e Zimirikiro agebara fuone ijene kei. ");
INSERT INTO bbb_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","Areme e Zimirikiro agebara fuone ije bune e fari ijiaru besubesu usiaena rovoga E Ireobo fu e Eikeni e Kamido fari ijene abei. ");
INSERT INTO bbb_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","Ijiege rena e Josua fune uri e Eikeni kuae, Farino ni E Ireobo e Isureroko ijiebuo Godi ije dabe aroena fu aguaekinu vua maeje ijiaru kuariene. Ro ade na fekuriekiro nika ise one irere a rema ije visuna kuarieno kuae. ");
INSERT INTO bbb_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","Ro Eikeni fu una gue kuae, Na E Ireobo e Isureroko ijiebuo Godi ijadufuo nidua ijia naka ise rei. ");
INSERT INTO bbb_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","Na e Bebironiako ijiebuo ugone ni mukore ijiakina ire siruva tu aderedi (200) ro ire gurodi uvani (1) kirogurami ijiebe ijia naovo na giavo fuka rieziemoga na kei. Ro ire ije na keva ije na kame are muvuaka none rotire ijia mako runa urie. Ro ire siruva ije na abena ugone rotire ijia abiesevano kuae. ");
INSERT INTO bbb_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","Fu ijiege kuaramoga Josua fune e gue kiamo bu difurisaena va are muvuaka fuone ijia usiaena sinuome fu mako runa uriema ijene giae. Areme bu kuke ire siruva ije fu abena sinuome ijiebuo rotire ijia abiesema bu gae. ");
INSERT INTO bbb_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","Areme bune ire ije karina una va Josuakina e Isureroko boeje kariva ije nijasia areme bune kena una E Ireobo ijadufuo nidua ijia ume ijia nae. ");
INSERT INTO bbb_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","Bu ijia navoga Josua fune e Isureroko ijena Eikeni e Zerado fari ije mesiri areme uri anafa fuone kabae ro fari ijene kaenamiae. Areme bu kuke uri ire siruvakiro gurodi ro ugone fu iniemema ijene kari. Bu ire ije kari areme uri mave-kaukina sifikina doniki ro are muvuaka fuone ijiakina ire fuone boeje ijene kena bune are amare bu kua Akono kuavo ijia vae. ");
INSERT INTO bbb_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","Bu va ijia usiaena Josua fune Eikeni kuae, A irerefuo irufui ije abena no mue? A ijiege rema ijadufuo ivia E Ireobo fu irufui ige abena una a koro makono kuae. Fu ijiege kuara areme e Isureroko ije kiamo bu mune karana Eikeni kanavo fu baronei. Areme bu kuke agane fuone ijene mune tuana kaniavo bu oevoga bu kame miane ifaejei. ");
INSERT INTO bbb_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","Areme bune mune ma uruvana tuana Eikenido ado ijia akoena ajiae ro iviama mune ije bu uria ijiege naove. Ro are ije bu Akono kuavo ro ive ijadufuo maeje ijeja Irufui Abeno. Bu ijiege revoga E Ireobo fu ma defaruimo ije fu ijia arei. ");
INSERT INTO bbb_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","35","(-) ");
INSERT INTO bbb_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","27","(-) ");
INSERT INTO bbb_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","43","(-) ");
INSERT INTO bbb_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","23","(-) ");
INSERT INTO bbb_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","24","(-) ");
INSERT INTO bbb_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","33","(-) ");
INSERT INTO bbb_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","15","(-) ");
INSERT INTO bbb_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","63","(-) ");
INSERT INTO bbb_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","10","(-) ");
INSERT INTO bbb_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","18","(-) ");
INSERT INTO bbb_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","28","(-) ");
INSERT INTO bbb_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","51","(-) ");
INSERT INTO bbb_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","9","(-) ");
INSERT INTO bbb_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","45","(-) ");
INSERT INTO bbb_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","34","(-) ");
INSERT INTO bbb_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","16","(-) ");
INSERT INTO bbb_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","Areme Josua fune e Isureroko ijiebuo agane boeje tuero (12) ije kiamo bu are Sekemi ijia besu afui. Fu e Isureroko ijiebuo e maki ro e mamekanu buone ijiakina e koto fievo ro e ifiki buone ije kiavo bu una E Ireobo ijadufuo nidua ijia besu afui. ");
INSERT INTO bbb_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","Bu afuivoga Josua fune urina e boeje vua ijiege kuariae. Fu kiae, E Ireobo e Isureroko ijiebuo Godi ije fu ijiege kuae, Isuibe asaerafa jone ijiakina asae jone be e Tera Aburamekiro Neobuo asoe ije bu do Iufuretisi irifo ijia karinoeva bu godi kufui ijene baname isoekinu arorianoe. ");
INSERT INTO bbb_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","Rove nare asoe jone e Aburame are do irifo fu finoeno ijia mesirina keke are Keinani vae. Areme nare daro mavoga e uine fuone fuka ma uruvana rei. ");
INSERT INTO bbb_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","Nare Aburame ifejavoga fu fari fuone e Aeseki biete areme juaevasia uruvana furiko na kuke e Aeseki ifejavoga fu anafa inokiro e Jekafukiro Iso ijene nafei. Areme na uri aesakae Sia uruo irifo ije abena e Iso mae. Ro e Jekafu fu farirafa fuone ije fu kaenamiana aesakae Ijifiti ijia ari vae. ");
INSERT INTO bbb_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","Areme na e Mosisikiro Eroni kiavo bu sakae Ijifiti ijia vakoga na duvado buone ijia irufui ka ise mamekanu ije e Ijifitiko ije vajia areme na asaerafa jone kaenamiana keke ruae. ");
INSERT INTO bbb_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","Na kaenamiana ruoma do davare irifo ijia rovoga e Ijifitiko bu osekiro sarioti karina ja kame arafiria ruae. Bu nuvedia ruoma Do Kavuane nafuema irifo ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","Rove asaerafa jone buka uri E Ireobo na kumevoga na ifejiana karauniae. Nare titutema ije kuavoga fu e Ijifiti ijiakiro asaerafa jone ijiebuo ukua ijia nae. Areme nare kuke do davare ije kuavoga fu e Ijifitiko ije okuriamoga jane ni jone ijia gae. Nare ijiege rei areme kaenamia romoga ja juaevasia ma uruvana aesao ijia karinoe. ");
INSERT INTO bbb_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","Ro kuke nare ja kaenamiana e Amoraetiko ijiebuo aesakae ije bu do Jodeni irifo maza ajiamo nake kariva ijia vae. Ja ijia vakoga bu jaena bijae rove naka nare ifejiavoga ja iraraena e boeje kania furi areme aesakae buone ije kei. ");
INSERT INTO bbb_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","Ro e Moabiko ijiebuo kini Beraki e Zifodo fari ije fuka e Isureroko ije jaena bijaekiro samuae. Ijadufuo fu urina Berame e Biodo fari ije kumeno fu e Isureroko ije ja kuravajiana vafiakiro ruae. ");
INSERT INTO bbb_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","E Berame fu na baname isoena kumenoga na naebe fiena ifejae. Rove naka vierafe fuone ije dabe dakudevoga fu una ja daro miakinu vua ma ijiaru joesina kuaemoga na karauniavo ja irufui ije daoveabue. ");
INSERT INTO bbb_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","Areme jane uri do Jodeni tuana are Jeriko ijia vae. Ro e Jeriko ro Amoraeti ijiakiro e Ferizaeti ro Kenanaeti ijiakiro e Itaeti ro e Gegasaeti ijiakina e Ivaeti ro Jebusaetiko ije bu jaena bijaekuae ruae. Rove na nare ifejiavoga jaka jare giriesana iraraevoga bu subinae vae. ");
INSERT INTO bbb_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","Ro ja jare daro jone ijia e boeje ijiakiro e Amoraetiko ijiebuo kini inokiro ije juvuamagu jone ijia buina bijaena kaniaeva baki. Ro na nare ude vakoga e ani jone buka ijadufuo ireobo jumekinu ro ka totenamikoga ja kaniakuriae. ");
INSERT INTO bbb_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","Nare aesakae ije ja ijia juae meva baki ro kuke sidove ije ja ijia are saeva baki ijene vajiae. Ro jame are ijia karina ine vaeni juare ijiakiro ine orivi fo ije ja umui jone ijia oeva baki ijene inoeve. ");
INSERT INTO bbb_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","Ijadufuo ni godi kufui ije asaerafa jone bu sakae Mesofotemia do irifo ro sakae Ijifiti ijia karina buone baname isoenoeva ijene kame garege korefo. Ro nika uri E Ireobo ije oetuakinu irinana fuefuo ijuebaki imefo. ");
INSERT INTO bbb_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","Ro ja fu oetuakinu irinadufuo ije ja isediakuva ni ivia samadukua ja era oetuakinu irinadufuo ije kuaefo. Ja vierafe ja asaerafa jone ijiebuo godi kufui ije bu are Mesofotemia do irifo ijia karina buone baname isoeva ije baname isoekuva ni ijiege kuaefo. Ro kuke gaga ja e Amoraetiko ijiebuo godi kufui ije baname isoekuva ni ijiege kuaega na fiefo. Ro naeje na agane none boeje ijena no vierafe no nuvuosukua no uria E Ireobo ije oetuakinu irinakono kiae. ");
INSERT INTO bbb_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","Josua fu vua ijiege kuariamoga e boeje bu urina kuae, No E Ireobo ije ijuogafana una godi kufui ijiebuo baname isoekuva fuka naebe marei. ");
INSERT INTO bbb_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","Ijadufuo maeje fune Godi nuvuone ijare no asaerafa nuvuone ijena Ijifiti ijia karina ebuo moni baki imenoevoga fu ijia karaunuona kaenamuo keke ruae. Ro kuke fuka ire sumiki uruvana nidua nuvuone ijia rei. Fuka vame ijia aesakae boeje no asidiaejana ruaeva ijia mukoreigia samuaguokinu kaenamuo ruae. ");
INSERT INTO bbb_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","Fune E Ireobo ijare nidua nuvuone ijia e aesakae uruvana ijia kariva ijiakiro e Amoraetiko ijene kaniakuriae. Ijadufuo nodua no vierafe noka E Ireobo ije oetuakinu irinake. Ijadufuo maeje fuje fuka ma Godi nuvuone. ");
INSERT INTO bbb_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","Bu ijiege kuaevoga Josua fu kiae, Na vierafe ja fu oetuakinu irinadufuo ije jaka naebe mani. Ijadufuo maeje E Ireobo ije fuka Godi akae. Fu vierafe jaka maza boeje fu fuosukua fuone baname isoedufuo. Ro ja uria faememarena godi kufui ije buone baname isoekuva fuka defaruike. Ro kuke ise jone fube giana areke. ");
INSERT INTO bbb_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","Ro ja E Ireobo ije ijuonena uri e ae binoko ijiebuo godi kufui ije buone baname isoekuva fuka ire ise ro vajae fiane bino vajiake. Fu ude ja fuka marejiae rove ja una ijiege rekuva fuka kaniaga jaka oe furikono kiae. ");
INSERT INTO bbb_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","Rove e boeje buka una Josua kuae, No vierafe nobe ijiege rekiro noka una E Ireobo oetuakinu irinakono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","E boeje bu ijiege kuaevoga Josua fu una kiae, Jane kojo ijifureki itire jone ijia E Ireobo irinakuae kuaevono kiae. Fu ijiege kuariamoga e boeje bu kuae, Ke ije noneka konuvuo kuaedo no ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","Areme Josua fu kiae, Ja ijiege kuaevo ijadufuo nine iviama e ae binoko ijiebuo godi kufui ije ja buone baname isoevo ije nika kena mutu korefo. Ro oe jone ije ka kena una E Ireobo e Isureroko ijiebuo Godi ije vajano kiae. ");
INSERT INTO bbb_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","Ro e boeje bu una Josua kuae, No vierafe noneka E Ireobo Godi nuvuone ijiaru fufuru oetuana irinakinu fuone baname isoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","Ijadufuo Josua fune buina vua ijiege kuaena avenami. Areme fune uri e ijiebuo akae gikikimana bino bu ijia giakinu kenoedufuo ijene nae. ");
INSERT INTO bbb_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","Fu akae ije amaeriama areme kena E Ireobo ijadufuo buki bu akae fuone isoeva ijia isoe. Ro akae boeje Josua fu isoema ije fu are Sekeme ijia isoe. Areme fune mune ma ireobo be abena ine sio zinume E Ireobo ijadufuo Are Muvuaka Akae ivuake ijia nijae. ");
INSERT INTO bbb_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","Areme fune uri e boeje kiae, Mune ige fune vua irere E Ireobo fu no kuaruema ije fune fie. Ijadufuo ja oenoeno E Ireobo ijuegafakuva ja mune ije gavo ijia ja una vua irere jare kojo kuaeva ije vierafekono kiae. ");
INSERT INTO bbb_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","Areme Josua fune e boeje kiamo bu una aesakae buone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","Ro rade juaevasia uvani aderedi teni (110) ijiege furikoga Josua e Nanedo fari E Ireobo ijadufuo imeno ije fu baronei. ");
INSERT INTO bbb_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","Fu baronemoga bu abe sakae fuone Timinate Sera ijia mako rui. Ro sakae ije fu Ifuremi nafare ije ireva ukua ijia ro fu Uruo Gesi manino ivuake ijia. ");
INSERT INTO bbb_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","Ro maza ije Josuakiro e Isureroko ijiebuo e mamekanu bu ire boeje E Ireobo fu rega bu giavo ije bu uria kariva ijia E Isureroko buka E Ireobo ije mukoreigia oetuakinu vua fuone iriniae. ");
INSERT INTO bbb_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","Ro sakae Sekeme ije fu e Jekafure moni uvani aderedi siruva ijia kena Amo e Sekemedo asoe ijadufuo fuaevei. Ro kuke e Josofudo ane E Isureroko bu are Ijifiti ijia karina usiae ruaeva ije bu kena ijia mako rui. Ijadufuo sakae ije fu e Josofudo uifari ijiebuo. ");
INSERT INTO bbb_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","Ro e Eronido fari e Eriza fu baronemoga bu abe are Gibia aesakae Ifuremi uruo ijia mako rui. Ro sakae ije bu isuibe abena e Erizado fari e Finiasi maeva ijene. ");
INSERT INTO bbb_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Isuibe maza ije e Isureroko bu kini buone be naebe abeva ijia vasia ma ireobo be fu aesakae ijia kekei. Vasia ije fu kekemogana e Irimereki fu are Beturieme Juda guove ijia fi. Ijadufuo vasia ka ireobo ije romogana fu bara fuone Neomikiro anafa fuone inokiro e Maronikiro Kirioni ije kaenamiana uri aesakae Moabi ijia maza sibaneke fikiro vae. Ro e Irimereki ro agane fuone bu e Efarataetiko. ");
INSERT INTO bbb_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Areme rade e Irimereki fu aesakae Moabi ijia baronemoga bara fuone Neomi fu farirafa fuone inokiro ijena ijia fi. ");
INSERT INTO bbb_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","5","Fu buina ijia fivakuma farirafa ije bune uri bara Moabaetiko inokiro Ofakiro Ruti ijene kei. Areme bune ijia karivakuma juaevasia umui fague ro gue furinoga e Maronikiro Sirioni budua bune aoe. Bu aoekoga bara Neomi fu fuosukua bara asaerafa fuone ijena ijia fi. ");
INSERT INTO bbb_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Ijiege rena bara Neomi fu are Moabi fino ijia fu fieke Godi E Ireobo ijare e fuone are Juda kariva ijene ifejiako juare buone ije bune una ire zaraemo fu fie. Ijadufuo fune una Juda vakiro vierafena uri asaerafa fuone inokiro ijena sinuome buone kanafui. ");
INSERT INTO bbb_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","8","Neomi fune asaerafa fuone Ofakiro Ruti ijena bune aesakae Moabi arena una Juda ruakuae ruae. Bu ruoma vame ijia Neomi fu urina kiae, Ni una asierafa jone ijiebuo are ijia vafo. Na vierafe izege ja anafa none oeva ijena no marejueva ijiege E Ireobo fu ja marejiake. ");
INSERT INTO bbb_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","10","Ro kuke na vierafe E Ireobo ijare vame jone ije amaeriaejiaga ja una baru maniana buina are buone ijia dasuna mukoreigia karino kiae. Neomi fu ijiege kuariama areme uri uimidiana anadiae. Fu anadiamoga bune uri niraekinu kuae, No iseduodo noneka aena una e one ijiebuo vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Bu ijiege kuavoga Neomi fu una kiae, Asaerafa none maegurie, janika una are jone ijia vafo. Ja irerefuo naena vakuae vierafe? Ja vierafe na una kuke baru maniana ame nafega bu ubaeradiaga ja maniaekuae ja ije vierafe? ");
INSERT INTO bbb_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","13","Ije fu naebe maremano ni una vafo. Naeje nane barasirenamie ijadufuo na izege una baru maniakuva baki. Ro ja vierafe na ivia muge baru mani areme ame nafekuva jabe uria amune rena samua karike. Ja samua karike bu ubaeradiaga ja maniake? Asaerafano ije fuka naebe marei. Na vierafe ja vajae fiane ige na abevo ijiege jadua ja vajae fiane abekuva naka isedie. Na vierafega fune Godire vajae fiane ige na abena isejavaevo ije miemano kie. ");
INSERT INTO bbb_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","15","Neomi fu ijiege kuariamoga bune una kuke nirae. Areme bara Ofa fune uri asae fuone ije uimina anaema areme fune una e fuone ijiebuo vae. Fune vakoga Ruti fuka uria asae fuone ijiaki vakiro ireobo vierafe. Ijadufuo Neomi fu uri Ruti kuae, Uvia one ije fune una orafa fuone ro godi fuone ijiebuo vaemano ni aduaku una vano kuae. ");
INSERT INTO bbb_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Neomi fu ijiege kuaramoga Ruti fu una kuae, A na kuriarega na a abuezana una e none ijiebuo vadufuo ije naka isedie. Ijadufuo ni arega naka osiki vane. Na vierafe a iziebureki vakuma nadua na osiki ijia vake. Ro a iziebureki fino ije nadua na ijia osiki fike. Ro kuke na vierafe Godi one ije fuka Godi none ro e one ije buduaku buka e none. ");
INSERT INTO bbb_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Ro a iziebureki baronekuma nadua na ijia baronega surive none ije bu abe ijia mako ruke. Ro na vierafe ire boeje na kuaeva ije be na naebe rekuva E Ireobo fu na abe isekafieke. Ro bakikuma fu ire be irere ijare no ke giegisa unuokuma baki ro no oekuva ijia no unianamikono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Ijiege rena Neomi fu gake Ruti fu oe fuone boeje funeka fuosiki vakiro vierafemaga fu naebe una vua be kuarae. ");
INSERT INTO bbb_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Areme bara inokiro bune vakuma sidove Beturieme ijia usiae. Bu ijia usiaevoga e boeje are ijia kariva ije bu vua ije fievo buka oeseradiae. Ro kuke bara ijia kariva ije bu kuae, Bara ije fute ma Neomire ruoke fu bara erareno kuae? ");
INSERT INTO bbb_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Bu ijiege kuaevoga Neomi fu urina kiae, Ja ive none jade una Neomino kievo ijadufuo maeje ive Neomi ije Oemarevo. Ro ja kiekuva ni Marano kiefo. Ro ive Mara ijadufuo maeje ije Ja Isejavae. Ijadufuo maeje fune E Ireobo e Daroki ijare oe fiane boeje na vajie. ");
INSERT INTO bbb_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Na igia urina vaeva ije na agane none boeje ijena vae. Rove fune E Ireobo ijare mesiriemo na nosukua una ruae. Fune irufui uruvana na vajie ijadufuo ja irerefuo Neomi kievono kiae. ");
INSERT INTO bbb_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Ijiege rena Neomi fu asae fuone Ruti bara Moabaetiko ije mesirina una are Beturieme ruae. Ro ve ije bu ruaeva ije e boeje ijia kariva bu bari ire vuiti igeki ije asevo ijia bu una ruae. ");
INSERT INTO bbb_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Ro bara Neomi fu agane fuone be ive fuone Boezi ro e ije fu e Irimerekido agane be. Ro e Boezi fuka e anuigi ro kuke fuka e sinuome uruvana zarae. ");
INSERT INTO bbb_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Ro maza be bara Ruti fu uri asae fuone Neomi kuae, Ani kiega na va juare gamia e imevo ire bari bu asegana iremareva ije bino karine. Na vierafe e ije juare ijia imevo ije bu na giekuva buka kiega na buina ijia imekono kuae. Ruti fu ijiege kuaramoga Neomi fu kuae, Asaeno ije fune maremano ni ijiege reno kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Ijadufuo Ruti fune vakuma juare gamia kekena e ije imevo ije nuvedianoekinu ire bari ije bu asena karigaro gue bu duega bu ijia arevo fu ije karinoe. Ro kumune vare ije duevo ije e imevo bu karivo baki. Ro bu ijia arega e ire baki ijiakina bara amune ijiebe karivo. Ruti fu kumune ije karinoeno ijia fu fie fu Boezi e Irimerekido agane ijadufuo juare ijia oenoeno fu ije fie. ");
INSERT INTO bbb_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Ruti fu kumune ije karinoeno ijia e Boezi fu are Beturieme vaema una ijia keke. Areme fu uri e fuone imenoevo ije anadiana kiae, Na vierafe E Ireobo fu jaena. Fu ijiege kiamoga bu kuae, No vierafe E Ireobo fu a marejakono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Areme e Boezi fu uri Ruti gana una e ije fu e fuone imevo ije samuagiamo ijene kuae, Ro bara nikaki gafe fu erado kabaeno kuae? ");
INSERT INTO bbb_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Fu ijiege kuamoga e ije fu kuae, Bara ije fu bara sumiki be are Moabiko fu Neomiki ruaema ijare. (Ro e are Moabi ije bu Godi ma vierafevo baki.) ");
INSERT INTO bbb_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Ro bara ije fu na kie ani kiega na e one imevo ije nuvediana oenoekinu kumune vare ije bu areva ije karino kie. Ijadufuo fu suoke ijia ro imena ruoma aemaega fu maza isekube fino kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","9","E ije fu Boezi ijiege kuaramoga fune va Ruti fino ijia kekena kuae, Kabaeno vua ige na kuaravo ije mukoe fiene. A kumune vare ije karikuma ni juare igiaru karikiro ade va juare bino ijia karimo. Ani bara igena igia imenoekinu ro e fari ije bu iziebureki kumune asenoevo ije mukoe giakinu bara guena oenoene. E none imevo ije nane kuariaedo bube a vua bino kuara ro ire bino reke. Ro a oenoega do duadakuma ni va do ije e imevo bu jia naeva ijia ino kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Boezi fu ijiege kuaramoga Ruti fu uri auge sana fu kurituakafana kuae, Nanaka bara aebeko ro a irerefuo na marejiemono kuae? ");
INSERT INTO bbb_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Ruti fu ijiege kuamoga Boezi fu kuae, Na vua ije are izege baru one ije fu baronemoga a uri asae one Neomi samuaema na ije fie. Ro kuke a izege orafa one ijiakiro aesakae one ije arena uri e ae binoko ige a naebe vierafema ijena fino na ije fie. ");
INSERT INTO bbb_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","Ijadufuo na vierafe E Ireobo e Isureroko ijiebuo Godi ije a vierafena fuone ruaema ijare a marejakono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Boezi fu ijiege kuaramoga Ruti fu kuae, E ireobo na vierafe naka ire boeje a oemaedufuo ijiaru renoeke. Nana bara gue bu one imevo ijieki baki rove aka na marejiena vua soesoegi na oemaredufuo ijia kuariemono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","16","Areme maza uvuoka bu ire ijo ijia e Boezi fu Ruti kuae, Urina ro burete ige bu amaeriaeva ije bino kena ire vaeni igia sana ino kuae. Boazi fu ijiege kuamoga Ruti fune va e ije imevo bu kariva ijia buina fikoga Boezi fu burete ije bu amaeriaeva ije bino karina vajae. Fu karina vajamoga fune inama deufenoga ire nugune ije fu ijia arei. Areme fu una imekiro vakoga e Boezi fu urina e ije imevo ije kiae, Bara ige fu kumune vare ja asevo ije bino karikuma jade kuriaerevo. Ro nime kumune bino runa najaga fu karino kiae. ");
INSERT INTO bbb_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Boezi fu ijiege kuariama areko Ruti fune buina va juare ijia kumune vare ije karinoeko fune vakuma ve musire. Areme Ruti fune kumune vare fu karima ije mutuna kamui ijia besu rie. ");
INSERT INTO bbb_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Areme fune uri kamui ijiakiro ire nugune fu naema ije kena una vakuma Neomi fino ijia kekei. Fu ijia kekena uri kumune ijiakiro ire nugune fu igana kena ruaema ijene Neomi nijae. Ro maza ije Neomi fu kumune ma uruvana fu kena ruaema ije giamo fuka ireobo oeserei. ");
INSERT INTO bbb_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","20","Areme asae fuone Neomi fu urina kuae, Ivia a erado juare ijia imenoekinu kumune vare ije ke. Na vierafe Godire e ije fu a gana ifejaema ije marejakono kuae. Fu ijiege kuaramoga Ruti fu urina kuae, Na e Boezi kuavo ijadufuo juare ijia imevano kuae. Fu ijiege kuamoga Neomi fu kuae, Na vierafe E Ireobo ijare Boezi marejake. Ijadufuo maeje fu vame maeje fu barurafa nuvuone oeva ijiakiro no fu ma rejuomo ije fu naebe totei ro arema bakino kuae. Neomi fu ijiege Ruti kuara areme uri kuae, E Boezi fu agane nuvuone ma ijadufuo na vierafe fu no mukoreigia samuaguokono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Fu ijiege kuaramoga Ruti bara Moabaetiko fu urina kuae, Na iko vakoga fu kiemo na e ije bu imevo ijena kumune vare kariko bu asema furimano kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Areme Neomi fu kuae, Asaeno a bara ije bu e Boezido juare ijia imejo ije buina imenoekuma fuka mareke. Ro a e binobuo juare ijia imekuma bute vame ise bino one rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Neomi fu ijiege kuaraema ijadufuo Ruti fune va e Boezido juare ijia e ije imevo ijena imeko vakuma kumune vare bu asevo ije fune furi. Ro maza ije fu kumune vare karinoema ije fu asae fuone Neomiki fikinu imenoe. ");
INSERT INTO bbb_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Areme maza be Neomi fu Ruti kuae, Kabaeno na vierafe na baru be oefuo rereke. Na rerena kuaga fu a abenamaekina fure a mukoe samuagake. ");
INSERT INTO bbb_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Ro igia fie, Boezi e ije a bara ijena juare fuone ijia imema ije fu agane nuvuone ma ijadufuo vua ige na kuaravo ije mukoe fiene. Ivia muge e ije fu kumune vare ije e imevo bu aseva fu ijene fina mutuna kamui ijia rieke. ");
INSERT INTO bbb_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Ijadufuo ni do ruema areme ire udi mukore urimo ije azikinu ugone one mukore ije sane. Areme ni arina game fu fina kumune vare mutumo ijia vane. A gamia kekekuma ade migegire niome fuone ijia vako ro ani samuake fu ire ina furine. ");
INSERT INTO bbb_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Ro a fu samuafikuma ni are fu naeno ije mukoreigia gaekina fu ninaega ni mauikeigia aru va barasi fuone fu nakaena naema ije dia ijia kenifurina diaero fuone ijia naene. A ijia naega fure irere a redufuo ije kuarano kuae. ");
INSERT INTO bbb_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Bara Neomi fu ijiege kuaramoga Ruti fu kuae, Na ire boeje a kuariema ije na ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Areme fune ari vakuma game Boezi fu fina kumune vare mutumo ijia kekena ire boeje asae fuone fu kuaraema ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Areme e Boezi fune ire ikinu do ina furi areme kairafa fuone ije oemarejiana fune ninaekiro vae. Fune ninaeko bara Ruti fu mauike aruna vakuma Boezi fu naema ijia kekena barasi fu nakaema ije kenifurina diaero fuone ijia nae. ");
INSERT INTO bbb_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","9","Ruti fune ijia naekoga ve ufirema ijia Boezi fu iduaemo fiena fu uri gake bara ije fu ijia naemaga fuka oeserei. Ijadufuo fu urina kuae, A bara ige erano kuae. Fu ijiege kuamoga Ruti fu kuae, E ireobo na Ruti nare. Aeje aka agane nuvuone ijadufuo aesekie na vierafe anika na abenamieno kuae. ");
INSERT INTO bbb_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Ruti fu ijiege kuaramoga Boezi fu kuae, Kabaeno vua ije a kuaema ije fuka maredo na vierafe E Ireobo fu a marejake. Ijadufuo maeje izege a ude asae one Neomi a samuaema ije fune marei. Ro iviama a kie ni na abenamieno kiemo ije fuka marei. Aeje aka bara nikaki rove a naebe uri baru iviaeko ire uruvana zarae ro e sinuobaki ijia reriana maniakiro vierafei. ");
INSERT INTO bbb_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Ro e boeje sidove igia kariva ije bu vame izege a mukoreigia kenoeno ije bune vierafe. Ijadufuo kabaeno ade ireobo vierafemo irere a kuariema ije na ijiege reke. ");
INSERT INTO bbb_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Ije fuka ma naeje na baru one ijadufuo agane be ijadufuo na vierafe na a samuagake. Rove igia fie e agane one ma ivuake ijia e be fu igia fino. ");
INSERT INTO bbb_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Ijadufuono ni igia naeke na suoke sone fu kuaga fu oemarekuma fure a abenamake. Ro fu ijuonekuma na Godido ive ije kuraedo nare a abenamake. Ijadufuo ni igia naeke fu ve iraseno kuae. ");
INSERT INTO bbb_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Boezi fune ijiege kuaramoga Ruti fu diaero fuone ijia naema suoke mu gamia ve uria titutema ijia Boezi fune urina Ruti kuae, Ade are ige no kumune mutuvo ije a naema ijene e bino kuariamono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Boezi fu ijiege kuara areme kuae, Ni ugone one ije a ado abiema ijene abe guria ira nirieno kuae. Areme Boezi fune kumune vare uruvana karina ijia nana utima dabe Ruti abedejamo fune abena una asaefuo Neomi fino ijia vae. ");
INSERT INTO bbb_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Fune una vakuma gafia kekemoga Neomi fu urina kuae, Asaeno maegure a vaema ije a izege remano kuae? Fu ijiege kuamoga Ruti fu urina ire boeje Boezi fu rema ije asae fuone kuarae. ");
INSERT INTO bbb_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Ruti fu ijiege kuara areme kuae, Fu kie a una vakuma ade ikiriasana vakono kiena fu kumune vare igene kari vajiemano kuae. ");
INSERT INTO bbb_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Ruti fune ijiege kuaramoga Neomi fu kuae, Asaeno anime oe vafaema fike fu izege rega no gane. E Boezi fu izege dasu fikuma baki ro funeka vua ige fu ivia marekuma fu ijare dasu fikono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","2","Areme e Boezi fune vakuma sidove viene e bu ijia afuina vua kuaevo ijia kekena ijia fi. Fu ijia samua figake e Irimerekido agane ije fu kuaema ije fune ijia romoga Boezi fune urina kuae, E gare ro igia arifino kuae. Fu ijiege kuamoga e ije fune va Boezi fino ijia kekena arifikoga fune kuke sidove ijia e mamekanu teni (10) kiamo bu ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","E ije bune ijia besu afui karikoga Boezi fune urina e Irimerekido agane ije kuae, Iviama bara Neomi fune are Moabi arena una ruae. Ijadufuo iviama fu baru fuone baronema ijadufuo sakae ijene abe fuaevekiro vierafe. ");
INSERT INTO bbb_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ijadufuo a sakae ije fuaevekiro vierafekuma ni iviama e ige kariva ijiebuo niome igia fuaevene ro a isedakuma ni kuariega na fiene. Ro sakae ije e bino bube fuaeveke ijadufuo a vierafe a fuaevekuma ni fuaevene. Ro a bakuma ni ijiege kuariega na fuaeveno kuae. Boezi fu ijiege kuamoga e ije fu kuae, Na vierafe sakae ije nare fuaevekono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Fu ijiege kuaramoga Boezi fu urina kuae, Ije fune marei. Ro a Neomikiro Ruti bara Moabaetiko ijiebuo sakae ije fuaevekuma ije a kuke bara amune Ruti duaku abeke. A ijiege rekina farirafa jone ijiebe asoe buone Irimereki e ije baronema ijadufuo sakae ije uria abena korubuo samuadufuo. ");
INSERT INTO bbb_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Boezi fu ijiege kuaramoga e Irimerekido agane ije fu urina kuae, Ijiekido na vierafe sakae ije na fuaevedufuo vierafeva ije na ijareke. Ijadufuo maeje na bara Ruti abega fu ame fari bino nafekuma na vierafe na sakae none aberedufuo. Ijadufuodo nana ijarekono ni are fuaeveno kuae. ");
INSERT INTO bbb_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Ro isuibe are Isurero ijia bu maza boeje ijiege revo. E be erare fu sinuome ro sakae kena una e guebuo fuaeveno e ije fuka uri dia surive besu fuone ije dasoena abe una e ije sinuome fuaeveno ije mamo. E Isureroko bu vame ijiege rena sinuome buone kena una e guebuo fuaevejo. ");
INSERT INTO bbb_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Ijadufuo e Irimerekido agane ije fu urina Boezi kuae, Ni are sakae ije fuaeve areme bara amune ije abeno kuae. Fu ijiege kuarana uri dia suri fuone ije dasoena abe uri Boezi mae. ");
INSERT INTO bbb_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Areme Boezi fune urina e mamekanu ije abero e gue ijia kariva ije kiae, Ja ivia jane giekoga na ni jone ijia bara Neomi fake e Irimerekido anafa e Sirionikiro Maronibuo sakae ije fuaeve. ");
INSERT INTO bbb_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ro kuke Ruti bara amune Moabaetiko e Maronido bara ije iviama fune una bara none reke. Na bara amune ije abevo ijadufuo e ije oeva ijiebuo sakae ije fune una uifari fuone ijiebuo reke. Ro ive fuone ije fube bakireke ro fu uria sidove fuone ijadufuo buki bu isoeva ijia navake. Ijadufuo ivia na e boeje ige ja kariva nidua jone ijia bara amune ige abevo jane gievano kiae. ");
INSERT INTO bbb_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Boezi fu ijiege kuariamoga e mamekanu ije abero e gue ijia afuiva ije bune urina kuae, Ke ivia a nidua nuvuone ijia bara amune ije abeno none gae. Ijadufuo no vierafe E Ireobo ijare bara one ije daro maga fure izege e Isureroko bu bara Resorokiro Riabuo duvado ijia uinevena ruaeva ijiege fure uifari uruvana tuanake. Ro kuke no vierafe are Eferata ijia are e anuigi reke. Ro kuke are Betirieme ijia ive one fuka ireobo reke. ");
INSERT INTO bbb_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","Ro kuke izege e Judakiro bara fuone Temabuo fari e Ferezido uifari ije buka e daroki reva ijiege no vierafe bara one Rutido duvado ijia uifari one ije budua bu e daroki rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Bu ijiege kuarama arekoga Boazi fune uri bara fuone Ruti mesirina bune una are ijia vae. Areme E Ireobo ijare bara Ruti ifejamogana fu ame fari be biete. ");
INSERT INTO bbb_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Areme bara sidove ijia kariva ijiebe urina Neomi kuae, No E Ireobo ijadufuo oemareke ijadufuo maeje fu asae one Ruti ifejamo fu ame fari ije bietedo fure a mukoreigia samuagake. Ro kuke no vierafe fu aesakae Isurero ijia e ifiki be reke. ");
INSERT INTO bbb_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Ro a ame fari seveni ijiege nafema bitie no vierafe bu aeje bume isekube a ifejake. Ro izege bara asae one fu a ireobo oetuana mukoreigia samuagaema ije fuka ma ireobo. Ro no vierafe ame ije fu bietema ijare a ifejaga a una daro abeke. Ro kuke a barasirekuma fure a mukoreigia samuagakono kuae. ");
INSERT INTO bbb_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","17","Areme Neomi fune ame ije dabena vajaedo fuone ijia samuae. Ro bara are ijia kariva ijiebe e boeje kuariana kiae, Bara Ruti fu ame fari be bietema ijadufuo iviama Neomi fu una ame fari abemano kiae. Areme bu urina ame ije ive ina Obedi kuae. Ro rade Obedi fu uri e Jesi biete ro e Jesi fu uri e Devidi bietei. Ijadufuo e Obedi fu e Devidido asae ijene. ");
INSERT INTO bbb_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","22","Ro e Ferezido uifari ijia ruoma e Devidi ijia kekema ije ijiege. E Ferezi fu uri Ezironi biete ro Ezironi fu uri Rame biete ro Rame fu uri Aminadabi biete ro Aminadabi fu uri Nasoni biete ro e Nasoni fu uri Saramoni biete ro e Saramoni fu uri Boezi biete ro e Boezi fu uri Obedi biete ro e Obedi fu uri Jesi biete ro e Jesi fu uri Devidi biete. (Areme Devidi fu urina e ireobo rena e Isureroko ije samuagiae). ");
INSERT INTO bbb_vpl VALUES ("NH1_1","017_1_1","NEH","1","1","1","Suvuare ige Neamaea e Akaraejado fari fu isoema ijene. E Kini Atekesi fu e aesakae Fesiako ijene samuagiaema ije fu juaevasia tuaedi (20) ijiege furi. Ro juaevasia rane ije furima ijadufuo ubine ijia e Neamaea naeje na sidove ireobo Susano kuavo ijia fi. ");
INSERT INTO bbb_vpl VALUES ("NH1_2","017_1_2","NEH","1","2","2","Na ijia fivoga uvia none e Anani fu e bino kaenamiana aesakae Juda ijia urina ruoma na fivo ijia kekei. Areme na urina sidove Jerusareme fu izege namo ijiakiro e Jiusi gue ije bu are Bebironia ijia dibure karina una urina Jerusareme vaeva ije bu izege kariva ijene fiekiro kuariae. ");
INSERT INTO bbb_vpl VALUES ("NH1_3","017_1_3","NEH","1","3","3","Na ijiege kuariavoga bu kie, E Jiusi bu dibure karina una sakae buone ijia vaeva ije buneka ma isema isejavaekinu karivano kie. Ro Jerusareme isuo bu kiraeva ije buneka mutusevo fune farae ari ro kuke viene fuone boeje bune kara ifaejei. Ro e ae binoko ije bu ivuake irifo ijia karinoeva ije buka no nese guovono kie. ");
INSERT INTO bbb_vpl VALUES ("NH1_4","017_1_4","NEH","1","4","5","Bu ijiege kuarievo na fievo fuka oefiadiemoga na ijia ireobo nimei. Na ijiege rena maza sibaneke naka ire atona Godi saove gufe samuamo ije baname isoe. Na kuae, E Ireobo Godi saove gufe samuamo aeje aka ma e anuigi noka a aguaravo. A irere a rekiro kuaema ije aka totemo baki. Ro aka maza boeje eranebe a oetuana irere a kuariamo ije irinana renoevo ije aka mukoreigia samuagiakinu ma rejiana ifejiamo. ");
INSERT INTO bbb_vpl VALUES ("NH1_6","017_1_6","NEH","1","6","6","Ijadufuo baname none ige e oefuo imeno na e Isureroko e ije oefuo imevo ijiebuo mumaza isoevo ige ada irana fiekinu giene. No e Isureroko ige noka orafa nuvuone ijena noneka ma isema rei. ");
INSERT INTO bbb_vpl VALUES ("NH1_7","017_1_7","NEH","1","7","7","No nidua one ijia noneka isema rena irere no renoedufuo a kuaruomo ije noka renoevo baki. No akae one a Mosisi e oefuo imeno ije kuaramoga fu isoena abe muema ije noka irinana ijia kenoevo baki. ");
INSERT INTO bbb_vpl VALUES ("NH1_8","017_1_8","NEH","1","8","8","Ro ni vua izege a e Mosisi kuaraema ije vierafene. A kuae, Ja e Isureroko ije ja naebe maza boeje na iriniena irere na kuariavo ije renoekuva naka ja kame jijiakorega ja e asakae binoko ijena karijavake. ");
INSERT INTO bbb_vpl VALUES ("NH1_9","017_1_9","NEH","1","9","9","Ro ja va ijia karinoevo ijia ja una na iriniena irere na kuariavo ijia renoekuva na kaenamia una ruake. Ro bu ja kame are irore igia uniaga ja dabe giegisana vakuva naka uria ijia kaenamiana una ruake. Na kaenamia una roga ja sidove Jerusareme ije ja besu afuina ive none dabe aroedufuo na kiaeva ijia uniakono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH1_10","017_1_10","NEH","1","10","10","Ijadufuo E Ireobo e ije buka e one bu oefuo imevo. Are umui one ka ma daroki ro daro one ma ireobo ijia bu karauniae. ");
INSERT INTO bbb_vpl VALUES ("NH1_11","017_1_11","NEH","1","11","11","Ijadufuo ni ivia baname none igiakiro e one bu oefuo imevo bu oemarekinu a dabe arorakuvejo ijiebuo baname bu isoevo ijene fiejuone. Ni ifejiena baname none ige fie areme abe marejiena kini ige oe fuone ije dabe dakudega fu na giena oefiane abeno kuae. Ro mazani ije naeje na kini ijadufuo do vaeni bu vesena ke ruovo ije samuavo. ");
INSERT INTO bbb_vpl VALUES ("NH2_1","017_2_1","NEH","2","1","1","Areme Kini Atekesi aesakae ije fu samuama ije fune juaevasia tuaedi (20) abema ijia na asame Efuru ijia are fuone ijia fi. Na ijia fivoga bu kinido do vaeni be jiana abe vuakoga na abena kini makiro vae. Ro oefiane none ije na abenoevo ije kini na naebe kuarae. ");
INSERT INTO bbb_vpl VALUES ("NH2_2","017_2_2","NEH","2","2","2","Rove na maza be do abe kini makiro aru vakoga fu giena uri kie, A adame abema baki ro a irerefuo nikubae one ije aka oefiaedaema igeki? Na vierafe oefiane be fuka oe one ijia namono kie. Kini fu ijiege kiemo naka jumei. ");
INSERT INTO bbb_vpl VALUES ("NH2_3","017_2_3","NEH","2","3","3","Rove na una kuae, E ireobo na vierafe aeje aka maza boeje kini rena ijia fivake. Ro e ireobo none, oefiane ige na abevo ijadufuo maeje sidove none Jerusareme are ije asaerafa none ijiebuo surive naovo ije e ani nuvuone bu dabe arafiriva ije fuka uria ijiege isema name. Ro kuke sidove viene boeje bune kania tuasena kara ifaejeva ijadufuo na ije oefiane abevono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH2_4","017_2_4","NEH","2","4","4","Na ijiege kuaravoga kini ije fu una kie, Ijadufuo a irere abekiro vierafemano kie? Fu ijiege kiemoga na migegire una mauike oe none ijia Godi saove gufadufuo ije baname isoe. ");
INSERT INTO bbb_vpl VALUES ("NH2_5","017_2_5","NEH","2","5","5","Areme na uri kini kuae, E ireobo a na giega fu oemadakuma ni a isekie vua none ige na kuaravo ije fiena avediene. Areme ni kiega na una Juda ijia Jerusareme sidove ije asaerafa none bu uniaeva ijene va una sano kuae? ");
INSERT INTO bbb_vpl VALUES ("NH2_6","017_2_6","NEH","2","6","6","Areme kini Atekesikiro bara fuone ije fu fuosiki ijia fido bu vua none ije fie. Ijadufuo kini ije fu urina maza izege na vaekiro una ruadufuo ijadufuo kuariemoga na maza ijene kuarae. Na ijiege kuaravoga kini ije fune uri vua none ije avediena abe marei. ");
INSERT INTO bbb_vpl VALUES ("NH2_7","017_2_7","NEH","2","7","7","Areme na kuaga fu oemarekuma fu fasi bino isoena vajiega na kena vaekina e mamekanu are Iufureti maza koeno nake samuavo vajiadufuo ijene kuarae. Fu fasi isoena e mamekanu ije mukoe kuariana nijasiaekina bu maza ije na una Juda vakiro vako ije bube irufui bino vajiedufuo na ijadufuo kuarae. ");
INSERT INTO bbb_vpl VALUES ("NH2_8","017_2_8","NEH","2","8","8","Areme nane una kuke kini kuavoga fu fasi bedua isoena e Asafi e ije kini ijadufuo tarare bu ijia ine ufuvo ije samuamo ije nijae. Fu isoena kuaraga e Asafi fu fie vierafekina fu ine fae gikikimana na sidove faere bu kiraeva ijadufuo viene ije amaeriadufuo ijene vajiedufuo. Ro kuke gue na e bijaevo ije bu Godido are ijene juo karivo ijiebuo are gikikima ijadufuo viene ijene amaeriake. Ro gue na kari are none na fidufuo ije sadufuo ijene vajieke. Ro Godi fuka na marejiemo ijadufuo kini ije fuka ire boeje na kuaravo ijadufuo fasi ijene isoena vajie. ");
INSERT INTO bbb_vpl VALUES ("NH2_9","017_2_9","NEH","2","9","9","Areme fune uri e bijaevo ijiebuo e mamekanu gue ro e buone bijaevo ijiakiro e ose kena bijaevo gue bu na samuagiedufuo ijene uniaejie. Areme nane vakuma Iufureti are maza koeno nake e mamekanu kariva ijia kekena kini Atekesi fasi fu isoema ijene vajiae. ");
INSERT INTO bbb_vpl VALUES ("NH2_10","017_2_10","NEH","2","10","10","Rove e Bete Orani ijiebuo e ireobo Sanibaretikiro Tobia e Amonaetiko ije bu na una Juda vakiro vako ije fie. Bu fieke e be fu una e Jiusi aesakae Juda kariva ije ifejiakiro vako bu ije fievo buka naebe oemarei. ");
INSERT INTO bbb_vpl VALUES ("NH2_11","017_2_11","NEH","2","11","12","Nane va Jerusareme kekena ijia fina areme mu inokubeke furikoga na muge be ve ufirema ijia urina e naena vaeva ije gue kaenamiana mauike kekena makave ijia vae. Rove na Godi irere na Jerusaremedo rekiro fu kuariema ije na naebe e be kuarae. Ro fanu doniki bino ijia fuka baki ro fune none besu nare abe oenoevo ijiaru. ");
INSERT INTO bbb_vpl VALUES ("NH2_13","017_2_13","NEH","2","13","13","Ijadufuo na doniki none ije abena ve fu uria titutema ijia nane viene ije bu kua Amare Vieno kuavo una maza koeno nake ijane kekena makave ijia vae. Areme nane faere irifo ijia ufuaena vakuma mako do jiavo bu kua Siroe Taraekono kuavo ije asina vakuma viene be bu kua Kadure Korevo Vieneno kuavo ijia kekei. Na ijia ufuae vakinu sidove Jerusareme isuo ije bu kaniatuana mutuseva ijiakina viene ije bu kara ifaejeva ije ninakona vae. ");
INSERT INTO bbb_vpl VALUES ("NH2_14","017_2_14","NEH","2","14","14","Nane ijiege ninakona vakuma viene be bu kua Do Sakae Tire Ijia Ajiamono kuavo ijia kekena vakuma Kini Ijadufuo Do Nafuemano kuavo ijia kekei. Areme na kuke ninakona vagake vame ije nare fanu doniki abena vadufuo ije fuka naebe mani. ");
INSERT INTO bbb_vpl VALUES ("NH2_15","017_2_15","NEH","2","15","15","Ijadufuo nane e ije na kaenamia vako ijena none una amare ije bu kua Kidironino kuavo ijia ari. No ijia ari vakinu isuo ije bu matuiva ije ninakona vae. Areme nane ijia dakudena una na vaeva ijane una sidove viene be bu kua Amare Vieneno kuavo na keke vaeva ijane una sidove guove ijia aruna vae. ");
INSERT INTO bbb_vpl VALUES ("NH2_16","017_2_16","NEH","2","16","16","Ro ije na ijiege renoevo ije e Isureroko ijiebuo e mamekanu ije besukua be fu irere na renoevo ro na izia vaeva ije buka naebe giena vierafe. Ro irere na vierafena renoevo ije na e zinone ifaejevo ijiakiro e mamekanu ije naka kuariaeva baki. Ro kuke na e bino eranebe isuo ije ifejiena sadufuo ije na kuariaeva baki. ");
INSERT INTO bbb_vpl VALUES ("NH2_17","017_2_17","NEH","2","17","17","Na mauike nosukua ijiege renoena areme rade na ijare urina e mamekanu ijene kiae, Nine iviama irufui ige no urana kariva ige gafo. Sidove nuvuone Jerusareme buneka e ani nuvuone ijiebe dabe mutuna arafirima areva funeka mukoreigia iserei. Ro kuke viene nuvuone boeje buneka kara ifaejema furi. Ijadufuo roga no sidove Jerusareme isuo ije una kirama arekina e bube una no nese guono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH2_18","017_2_18","NEH","2","18","18","Nane e boeje ijiege kuariama areme na ijia sone urina izege Godi fu nosiki oenoekinu ifejiema ijene kuariae. Areme na kuke izege kini fu urina irere na rekiro vierafena kuaravo fu avediena abe marema ijene kuariae. Na ijiege kuariavoga e boeje bu urina kie, Ije fuka maremano ni roga noka urina Jerusareme sidove ijene una sano kie. Areme bune uri i mukore ijene mekuae ire boeje kanafui. ");
INSERT INTO bbb_vpl VALUES ("NH2_19","017_2_19","NEH","2","19","19","None ijiege kuaena ire boeje kanafuinoekoga e Sanibaretikina Tobiakina e Gesame e Arabiko ije bu ire ije no kanafuinoevo ije fie. Bu vua ije fiena kisuokinu no kame varaemena kuaevo, Ire ije ja irere ije abekuae renoevono kue? ");
INSERT INTO bbb_vpl VALUES ("NH2_20","017_2_20","NEH","2","20","20","Ja vierafe ja kini ijena bijaekuae vierafevano kuovoga na kiae, Noeje no e Godi saove gufe samuamo ijadufuo imevo. Ijadufuo are ige no sakuae kuaevo ije no vierafe fu ifejuoga no zinuevena sadufuo. Ja asaerafa jone bu ude Jerusareme igia kariva baki ijadufuo sidove ije fu jone baki. Ijadufuo i ige no mevo ije jabe ifejuokono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH3_1","017_3_1","NEH","3","1","32","(-) ");
INSERT INTO bbb_vpl VALUES ("NH4_1","017_4_1","NEH","4","1","2","Areme e Sanibareti e Sameriako ijiebuo e ireobo fu fieke e Jiusi ije none Jerusareme isuo ije una kiravo fu fie. Fu vua ije fiemo fuka defaruimo fu uri e kairafa ijiakina e Sameriako ijiebuo e azo kevo ijiebuo nidua ijia no kame utifaejena varaemei. Fu kuae, E Jiusi ka e garuki ije bu irere ije rekuae reve? Bu vierafe bu sidove ijene una sakuae vierafe. Bu vierafe bu zinone buone ije ifaejekuva zinone ijare bu ifejiake. Ro kuke bute vierafega bu maza besu sidove ije una sa furikuae bu ijiege vierafe. Mune ije bu kena are ije sakuvejo ije fune miane naena isere ro bu izege una karina sakuae revono kuae? ");
INSERT INTO bbb_vpl VALUES ("NH4_3","017_4_3","NEH","4","3","3","Ro kuke e Tobia e Amonaetiko ije fudua fune uri e Sanibareti ifejana kuae, Isuo buone bu savo ije siroe fokisi fu furiko mune bu kena nana ajiavo ijia bierekuma bu bite ka tuasena diduekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH4_4","017_4_4","NEH","4","4","4","Bu ijiege kuaevoga na fiena uri Godi baname ijiege isoe, O Godi ni vua buone izege bu kuaena no kame varaemevo ije fiene. A ije fie areme ni ifejuoga bu varane buone ije una korubuo gana jaevene. Ro ni e ae binoko kiaga bu ro e ije toenamiana kaenamia vaga bu are buone ijia isejavaene. ");
INSERT INTO bbb_vpl VALUES ("NH4_5","017_4_5","NEH","4","5","5","Bu e ige no are ige savo ijene guona kame varae mevo ijadufuo ise buone ade giana are ro totemono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH4_6","017_4_6","NEH","4","6","6","Na baname ijiege isoena Godi kuarae rove no naebe arei ro noka fiebarekine areme uri isuo ijene kirae. None isuo ijene kirako fune ajiana ukua ijia vae. Ijadufuo maeje e boeje buneka oemarekinu oe buone ijiakuma i ijene meve. ");
INSERT INTO bbb_vpl VALUES ("NH4_7","017_4_7","NEH","4","7","7","No ijiege rekoga e Sanibaretikiro Tobiakina e Arebiako gue ro e Amonaetiko ijiakiro e Asidodiko ije bu fieke noneka isuo ije mukoreigia kiravo bu fie. Ro kuke bu fieke none ijiege kirakinu kafare binobino none kirana ausekuvejo bu fievoga buka defarudiae. ");
INSERT INTO bbb_vpl VALUES ("NH4_8","017_4_8","NEH","4","8","8","Ijadufuo bune una besu afuina izege bu e Jerusaremeko noena bijaekinu ro ire ise bino nuvuone redufuo ije kuaena amaeri. ");
INSERT INTO bbb_vpl VALUES ("NH4_9","017_4_9","NEH","4","9","9","Rove no una Godi nuvuone ije baname isoena oefiane nuvuone ijene kuarae. No ijiege rekinu ro kuke e gue kevo bu no mumaza juo karikinu samuogue. ");
INSERT INTO bbb_vpl VALUES ("NH4_10","017_4_10","NEH","4","10","10","Ro e Jiusi ije isuo kiravo bu kuae, No irufui abeko noneka aemuome. Ro kuke isuo bu matuseva ubine buka ma uruvana ijadufuo isuo ije no izege kira furikuva bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("NH4_11","017_4_11","NEH","4","11","11","Ro maza besu ijia e ani nuvuone bu kuae, Buka naebe guevano rono mauike sauina va kaniaga bu oe furikina isuo ije bu kiravo ije buka areno kuae. ");
INSERT INTO bbb_vpl VALUES ("NH4_12","017_4_12","NEH","4","12","12","Rove bune e Jiusi gue bu e ani nuvuone ivuake ijia karivo ijiebe maza binobino ijia ro vua izege bu no kanuokuae kuaena amaerivo ije kuarue. ");
INSERT INTO bbb_vpl VALUES ("NH4_13","017_4_13","NEH","4","13","13","Ijadufuo na agane besubesu ijia e kevoga bu juvuamagu ro sime buone bu bijaevo ije kena isuo iziebure no uria kirana ajiavo ijia juo karijuokoga no imei. ");
INSERT INTO bbb_vpl VALUES ("NH4_14","017_4_14","NEH","4","14","14","Na giake e buka jumekinu revoga na uri e mamekanu ro e aeko ijene vua kuariae. Na kia, Ja e ije bu ja kaniakuvejo ije jade jumevo. Ijadufuo maeje E Ireobo nuvuone ije fuka e daroki e buka fu jumevo. Ijadufuo nika uri giriesana e uviarafa ijiakiro agebara jone ro gire jone ijiebuo bijaeno kiae. ");
INSERT INTO bbb_vpl VALUES ("NH4_15","017_4_15","NEH","4","15","15","Areme e ani ije bu fieke none vua izege bu mauike nuvuesina kuaena amaerivo ije none giana vierafevaga bu ije fie. Ijadufuo bu ijia sone una vierafero Godi fune vua buone sauiki ije bu kuaena amaerivo ije fune dabe iserejiaemaro bu ijiege vierafei. Bu ijiege vierafekoga e boeje no una isuo nuvuone iziebure no kiravo ijene kirae. ");
INSERT INTO bbb_vpl VALUES ("NH4_16","017_4_16","NEH","4","16","16","Bu ijiege rena ve ijia e none gue bu juvuamagu ro gunuore ije kena una e gue juo karijiako e gue no isuo kirae. Ijiege rena e nuvuone mamekanu ije buka e ije imevo ijene samuagiae. ");
INSERT INTO bbb_vpl VALUES ("NH4_17","017_4_17","NEH","4","17","17","Ro e mujue ije isuo kiravo ije umui gue bu juvuamagu faradiakiro umui gue bu mune kari vajiako bu isuo kirae. ");
INSERT INTO bbb_vpl VALUES ("NH4_18","017_4_18","NEH","4","18","18","Ro e boeje besubesu eranebe isuo kiravo ije bu sime buone buka kena madare buone ijia bijiana bue samuanakinu imei. Ro e ije fu e ani roga fu vegu ufemo ije fuka maza boeje nosiki oenoeno. ");
INSERT INTO bbb_vpl VALUES ("NH4_19","017_4_19","NEH","4","19","19","Areme e Neamaea na uri e mamekanu ije abero e buone rotire ijia imevo ro e boeje kuariana kiae, I ige no mevo ije noka ivuake guria besu afuina mevo baki. Ro noka dabe jijiana mumabo ijia nuvuebino menoeve. ");
INSERT INTO bbb_vpl VALUES ("NH4_20","017_4_20","NEH","4","20","20","Ijadufuo ja iziebure imenoevo ijia ja vegu fiekuva nika migegire una iziebure na manivo ijia afuifo. Ja ijia afuike Godi nuvuone ije fu nuvuefuo bijaeno kiae. ");
INSERT INTO bbb_vpl VALUES ("NH4_21","017_4_21","NEH","4","21","21","Ijadufuo maza boeje ve iko irasemo ijia vakuma ve titutemo ije e gue no juo karina samuako gue no isuo kiravo. ");
INSERT INTO bbb_vpl VALUES ("NH4_22","017_4_22","NEH","4","22","22","No ijiege renoevo ijia na e boeje kiae, E fari boeje ro e mumokana bu ifejiavo ije nika una besu afuina Jerusareme sidove guove igia naofo. Ja ijiege rekina muge ja no juokarijuokiro ro maza ije ja imeno kiae. ");
INSERT INTO bbb_vpl VALUES ("NH4_23","017_4_23","NEH","4","23","23","No ijiege revo ijadufuo nakina uviarafa none ro e none imevo ijiakina e azo kevo bu naena ruaeva ije ugone nuvuone no naebe azo nae. Ro kuke no do ruevo ro iziebure no oenoejo ije sinuome nuvuone no bijaevo ije noneka ijiakuma oenoevo. ");
INSERT INTO bbb_vpl VALUES ("NH5_1","017_5_1","NEH","5","1","1","Areme maza sibaneke furikoga e uruvana bara ro baru buka naebe oemareva ijadufuo bu ziena uri kairafa buone gue ijena madinami. ");
INSERT INTO bbb_vpl VALUES ("NH5_2","017_5_2","NEH","5","2","2","E gue bu kuae, No agane gue noka e uruvana ijadufuo no kari vakuae vierafekuva noka ire bino kedufuo. ");
INSERT INTO bbb_vpl VALUES ("NH5_3","017_5_3","NEH","5","3","3","Ro e gue bu kuae, Nono ire funeka furima ijadufuo no sakae nuvuone ijiakina ire vaeni juare no oeva ijiakina are nuvuone ije none kame una kaerafa nuvuone buone fuaeve. No vierafe ro no ijiege rekina bu mani vajuoga no kena una ire nuvuone fuaevekiro no ijadufuo ijiege revano kuae. ");
INSERT INTO bbb_vpl VALUES ("NH5_4","017_5_4","NEH","5","4","4","Ro kuke e gue bu kuae, No duaku no kairafa nuvuone gue kiavoga bu moni buone gue ifejuovoga no juare nuvuone ijiakiro gurefi vaeni juare ijiebuo una gamani takesi fuaevei. ");
INSERT INTO bbb_vpl VALUES ("NH5_5","017_5_5","NEH","5","5","5","Noeje no e Jiusi ijena noka besu gaegi ro kuke anafa buone ijiakiro nuvuone ije buka besu. Nonoka besu ijadufuo bu irerefuo ijiege reko no are ijiakiro sakae nuvuone ije kena una buone fuaeveve. Ro kuke noka ame nuvuone ije kiako bu una e guebuo moni baki imenoeve. Ro kabaerafa nuvuone gue noneka kena una kaerafa guebuo fuaevejo bune buefuo moni baki imenoeve. Ro kuke juare nuvuone ijiakiro gurefi vaeni juare nuvuone bune kaerafa nuvuone ijiebe fuaevena una buone kei. Ijadufuo iviama noeje noneka darobirenamue. ");
INSERT INTO bbb_vpl VALUES ("NH5_6","017_5_6","NEH","5","6","6","Ijadufuo na e ijiebuo vua ije bu ijiege ziena kuaevo ije fievo naka defarudie. ");
INSERT INTO bbb_vpl VALUES ("NH5_7","017_5_7","NEH","5","7","7","Ijadufuo na fina izege na redufuo ije vierafei. Areme nane uri e mamekanu ijiakiro e buone rotire ijia imevo ijene kumevo bu una besu afui. Bu afuivoga naka uri vua gikikimana kuariae. Na kia, Ja uviarafa jone maeje jaka isema rena mani bu kiavo ja vajiaeva ije kiakoke binodua kuke ado ijia nana vajiavono kiae. Na ijiege kuaria areme uri e boeje kumevo bu besu afuivoga na irufui ijene buina kuaena amaeri. ");
INSERT INTO bbb_vpl VALUES ("NH5_8","017_5_8","NEH","5","8","8","Na kiae, No uviarafa nuvuone e Jiusi ije gue bu korubuo e ae binoko ije kiavoga bune bu fuaevevoga bu buefuo moni baki imenoe. Ro iviama e kairafa ige gue noneka giriesana e ijene fuaevena una kaenamiae. Rove na fiega jaka uria una kuke uviarafa jone maeje kame e guebuo fuaevekoke no ijene una fuaevena kaenamiavono kiae. Na ijiege ka gikikimana kuariavoga e mamekanu bu fieke nane ma kuariavoga bu una izege kuariekuva baga bume kari fie. ");
INSERT INTO bbb_vpl VALUES ("NH5_9","017_5_9","NEH","5","9","9","Na ijiege kuariama areme kiae, Vame ije ja kevo ije jaka ma isema reve. Ijadufuo ni una Godi jumena fu irinakinu vame maeje renoefo. Ja ijiege renoekina e ani nuvuone ae binoko ije bube ise nuvuone bino guona umui bijuodufuo. ");
INSERT INTO bbb_vpl VALUES ("NH5_10","017_5_10","NEH","5","10","10","Na kairafa none ijiakina e none imevo ije noka manikiro kumune nuvuone ije e gue vajiavo. No vajiaekina bu rade una vajuokuae no ijadufuo ijiege re. Rove na vierafe bube una buone bino ado ijia nana vajuodufuo ije buka areke. ");
INSERT INTO bbb_vpl VALUES ("NH5_11","017_5_11","NEH","5","11","11","Ijadufuo ja iviama e guebuo juare ijiakina gurefi vaeni juare ro ine orive ro are buone ije ja keva ije nika migegire kena una vajiafo. Ro jade kiaga bu una ire buone binodua ado ijia nana vajiavono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH5_12","017_5_12","NEH","5","12","12","Na ijiege kuariavoga e mamekanu buka uri avediena ijiege kumei, Ije fune maredo noka ijiege reke. No vierafe noka sinuome buone irere no keva ijene una vajiake. Areme rade no naebe una ire buone bino kiaga bu vajuoke. Ro buje bu irere bu una vajuokono kueva ije no vierafe noka totega fu furino kiae. Areme nane uri e zinone ifaejevo ije kiavo bu aru ruae. Bu aruna irekoga na e mamekanu ijiakiro e ije buone rotire ijia imevo ije kiavo bu urina nidua buone ijia samadukua visu kuariana kia, Vua irere no kuaeva ije nobe totekiro noka ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH5_13","017_5_13","NEH","5","13","13","Areme nane uri ugone jiagadogo na abiesevo ijadufuo ubine ije abena kanakanae. Na ijiege kanakanakinu kiae, Godire e gure erare a vua ige kuaena naebe abe mimatakuma fu a abena kuokuo ijiege keseke. Ro fure ire one boeje a kema ijiakiro are one ije kamaza vake ame ijiege sinuo baki finoekono kiae. Na ijiege kuariama furikoga e boeje eranebe ijia ruaeva ije bu kumei, Maremano kumena bune uri E Ireobo ije oemarejae. Areme ve ijia e mamekanu ije bune uri vua bu kuaeva ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH5_14","017_5_14","NEH","5","14","14","Ijiege rena juaevasia tuaedi (20) ro teti tu (32) ukua ije e Atekesi fu kini rema ijia naeje na juaevasia tuero (12) ijiege e ireobo rena aesakae Juda samuae. Ro maza ijia nakina uviarafa none ije no ire ije e ireobo fu ino ije noka naebe i. ");
INSERT INTO bbb_vpl VALUES ("NH5_15","017_5_15","NEH","5","15","15","Ro e mamekanu bino na vareki ude daro kena kari ruaeva ije buka irufui uruvana e aeko buone ije vajiae. Bu karina e aeko boeje kiakoke buka maza gue ire siruvakina irekiro do vaeni bu idufuo ije uruvana karina ro vajiavo. Bu ijiege rekoga e ije rotire buone ijia imevo ije budua buka e aeko ije irufui vajiae. Ro mazani none na daro abena fiva ije na naebe bu reva ijiege rei. Rove naeje naka una vame ni be rei. Ijadufuo maeje naka Godi none ije jumevo ijadufuo na ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH5_16","017_5_16","NEH","5","16","16","Na maza boeje daro none ije naka abena Jerusareme sidove ijadufuo isuo ijene kirae. Ro kuke e ije noefuo imevo ije budua buka naena besu isuo ijene kirae. No ijiege regaro una sakae uruvana fuaevedufuo ijie noka naebe ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("NH5_17","017_5_17","NEH","5","17","17","Ro maza boeje naka e Jiusi uvane aderedi fifiti (150) ijiege ro e mamekanu gue ije kaenamiana fata none ijia ire vajiaga bu ivo. Na e Jiusi ijiaru ijiege ifejiana ire vajiavo baki. Ro na kuke e ae binoko eranebe bu are none ijia ruovo na ije ire vajiaga bu ivo. ");
INSERT INTO bbb_vpl VALUES ("NH5_18","017_5_18","NEH","5","18","18","Ro ire ije nare maza boeje kena kira vajiako bu ivo ije ijiege. Na mave-kau besu ro mave-sifi ka mukore sigisi (6) ro kukoruko ka uruvana ijiege kirana vajiavo. Ro kuke na vakuma maza teni (10) ijiege furino ije na do vaeni ka mukore ijia kena vese vajiaga bu ivo. Rove na naebe una e aeko ije kiako bu ire ro vaeni buone izege e mamekanu bu ijo ije bino karina vajie. Ijadufuo maeje na irufui buone ma ireobo ije bu abevo ije nane giana vierafei. ");
INSERT INTO bbb_vpl VALUES ("NH5_19","017_5_19","NEH","5","19","19","Ijadufuo na baname isoena kuae, O Godi ire boeje na e igiebuo revo ije giena vierafekiro ade totemono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH6_1","017_6_1","NEH","6","1","1","Areme e Sanebaratekina Tobiakina Gesemi e Arabiko ijiakina e ani nuvuone gue bu fieke isuo kafare bino no naebe arei ro noneka kira furivo bu fie. Ro isuo viene ijadufuo no amaeriaeva ije no uria naebe kena kamae. ");
INSERT INTO bbb_vpl VALUES ("NH6_2","017_6_2","NEH","6","2","2","Ro e inokiro e Sanebaratikiro Gesemi bu na vua nijiena kumei. A ni roga no are isekube bu Ono amare ijia kariva ijia bienamina vua kuaeno kumei. Rove na vierafe ije bu na kaniekuae kumei. ");
INSERT INTO bbb_vpl VALUES ("NH6_3","017_6_3","NEH","6","3","3","Ijadufuo na una vua nijiana kumei, Nanaka i anuigi be mevo ijadufuo na are mumabo ijieki ije nabe vuake. Na i ige arena ura ja gianoedufuo ije fuka ma bakino kumei. ");
INSERT INTO bbb_vpl VALUES ("NH6_4","017_6_4","NEH","6","4","4","Na ijiege kumevoga bu una kuke vua ni besu ijene maza inokiro kiro inokiro ijiena kuarie. Rove maza besubesu naka uria vua besu ijiege kuariae. ");
INSERT INTO bbb_vpl VALUES ("NH6_5","017_6_5","NEH","6","5","5","Areme e Sanebarati fune una kuke maza be fasi isoena e fuone imeno ije mavoga fu abena ro mie. Ro fasi fu isoema ije fu vierafe e boeje buka vua irere fu isoema ijene fiedufuo ijadufuo fasi ije fu naebe abe mukoreigia okurae. ");
INSERT INTO bbb_vpl VALUES ("NH6_6","017_6_6","NEH","6","6","7","Ro fasi ije fu ijiege isoe, E boeje are ivuake no irifo ijia karinoeva ije bu vua be kuaenoevono kie. Ro kuke e Gesemi fudua besu kie. E boeje bu kuae, Aeje a e Jiusi ijena jaka e ije bu no samuaguovo ije buina nigaraekuae vierafei. Ijadufuo a e one ijena isuo ije faraeva ije una same. Ro kuke aeje aka kini buone rekiro e vua kuaevo kiaga bu vua one ijene dabe usiaena Jerusareme ijia e boeje kuariavono kuae. Ijadufuo na vierafe vua ige kini fu rade fiedufuo. Ijadufuo ni roga no nosiki vua ije kuaena amaerino kie. ");
INSERT INTO bbb_vpl VALUES ("NH6_8","017_6_8","NEH","6","8","8","Areme na una vegue fasi isoe nijana kuae, Vua one ige a isoena kuariema ije aka kufuimena isoe. Nono ijiege vierafena revo baki. Ro vua ije ame are nigofo one ije vierafena kuariemano kuae. ");
INSERT INTO bbb_vpl VALUES ("NH6_9","017_6_9","NEH","6","9","9","Bu fasi ijiege isoe ijadufuo maeje bu vierafero noka jumekinu ro mamoedo nobe isuo ije kira furikiro bu ijiege vierafei. Rove naka baname isoena Godi kuae, Godi a ivia na daro miega na giriesana i ige uria meno kuae. ");
INSERT INTO bbb_vpl VALUES ("NH6_10","017_6_10","NEH","6","10","10","Areme maza be na e Deraeado fari Semaea e Metaberodo asae ije gakiro vae. Ro e ije fume uria gire fuone ijia fino ijia na vae. Na va fuosiki fivoga fu kie, E buka muge be a naebe vierafema ijia ro a kanake. Ijadufuo roga no nosiki mauike subinaena va Godido Are Akae ijia aruna viene kame bijuna ijia karino kie. ");
INSERT INTO bbb_vpl VALUES ("NH6_11","017_6_11","NEH","6","11","11","E Semaea fu ijiege kuariemoga na kuae, Nana e giana konoevo baki. A vierafero na kona va Are Akae ijia saui fikuva e bube kaniekiro a ijiege vierafe? Rove na vierafe nabe ijiege rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH6_12","017_6_12","NEH","6","12","12","Na ijiege kuara areme una sone fina vierafega vua ije fu Godire vierafejamo fu kuariema baki. Ro vua ije fu e Sanebaratikiro Tobia ijiebe fu fuaevena kuaga fu vua buone ije kuariemoro na ijiege vierafe. ");
INSERT INTO bbb_vpl VALUES ("NH6_13","017_6_13","NEH","6","13","13","Bu vierafero bu ijiege biesiriega na jumekina na ise be rega e bu ise none dabe e boeje kuariaga bu ive none dabe iserekiro bu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH6_14","017_6_14","NEH","6","14","14","Rove naka uri baname isoena Godi kuae, Godi e Sanebaratikiro Tobia vame bu kevo ije giane. Ro kuke bara Naodiakiro e gue vua kufuimena e kuariavo ije bu revo ije giane. Ijadufuo maeje bu na biesiriega na jumekiro bu reve ijadufuo ade giana arekiro nika kame isekafiano kuae. ");
INSERT INTO bbb_vpl VALUES ("NH6_15","017_6_15","NEH","6","15","15","Areme asame Otoba ijadufuo maza tuaedi faeve (25) ijia isuo ijiakiro viene boeje no kiravo ije foteke fune ijia furi. Ro isuo foteke no kiraeva ije no maza fifiti tu (52) ijiege furikoga no ijia kira furi. ");
INSERT INTO bbb_vpl VALUES ("NH6_16","017_6_16","NEH","6","16","16","Ijadufuo e ani nuvuone gue sakae nuvuone irifo ijia karinoeva bu vua ijene fievo buka judiae ijadufuo bu una ire be irere rekuva baga bume ijia arei. Ijadufuo maeje bu vierafega fune Godire daro muomoga no isuo ije kiraevaro bu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("NH6_17","017_6_17","NEH","6","17","17","Ro maza ijia Jiusi e mamekanu gue bu fasi bino isoena e Tobia naejako fu una vegue fasi isoe naejiamo. Ijadufuo maeje e Judako uruvana bune ude izege bu e Tobia ifejadufuo ijene kuaena mareva ijadufuo bu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH6_18","017_6_18","NEH","6","18","18","Bu ijiege reva ijadufuo maeje e Tobia fu e Jiusibuo e ireobo be ive fuone Sekania e Arado fari ijadufuo jure. Ro kuke Tobiado fari e Jeonane fu Mesurame e Jiusi ijadufuo kabae ijene abei. Ro e Mesurame fu e Berakaeado fari. ");
INSERT INTO bbb_vpl VALUES ("NH6_19","017_6_19","NEH","6","19","19","Ro kuke bu e ijiebe ro na kuariena kie Tobia fuka mukoe kemono kie. Bu ijiege ro kuariekinu ro una va vua none ije fu kuaravo. Tobia fu vierafe fuka fasi ijia vua jujuki isoena kuariega na fiena jumekiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH7_1","017_7_1","NEH","7","1","1","Areme nane uri viene no amaeriaeva kena isuo ijia kamae. Na ijiege re areme uri e sidove ijadufuo viene ije samuadufuo ijiakina e dua uruvo ijiakiro e Rivaeti ije bu i buone medufuo ijene kei. ");
INSERT INTO bbb_vpl VALUES ("NH7_2","017_7_2","NEH","7","2","2","Na ijiege re areme uri e inokiro bu sidove Jerusareme samuadufuo ijene kei. Na e uvia none Ananikiro Ananaea e ije fu e juo karijo ijiebuo are bu karijo ije samuamo ijene kei. Ro e Ananae fuka e mukore e buka fu ma vierafevo ro kuke fuka e boeje bu Godi irinavo ije asidiana Godi mukoreigia maza boeje irinamo. ");
INSERT INTO bbb_vpl VALUES ("NH7_3","017_7_3","NEH","7","3","3","Na e ije ke areme kiae, Ja suoke jade migegire sidove Jerusareme viene ijene azovo. Jani areke ve fu mukoe irasena maza naga ni sone azofo. Ro mufuo ja una bijuvo ije ni e viene samuavo bu uria imevo ije kiaga bu kena mukoe bijukuriano kiae. Areme nane kuke kiavo bune Jerusareme guove ijia e bino bu ifejiana sidove ijene juo karidufuo ije kei. Bu ijiege kekina e gue bu are iziebure bu juo karidufuo kiaeva bu ijia samuana iredufuo. Ro e gue bu are buone makave juo karino kiae. ");
INSERT INTO bbb_vpl VALUES ("NH7_4","017_7_4","NEH","7","4","4","Jerusareme sidove ije fuka ma ireobo rove e guove ijia kariva ije buka sibaneke. Ro kuke are uruvana gue buka naebe sae. ");
INSERT INTO bbb_vpl VALUES ("NH7_5","017_7_5","NEH","7","5","5","Ijadufuo Godi fu vierafe vajiemoga na e boeje ro e mamekanu buone ije kumevo bu besu afui. Areme na kiavo bu agane besubesu ijiebuo ive ije na isoedufuo ije kuarie. Rove e ije eranebe amure una aesakae Juda igia ruaeva ijiebuo ive nane buki bu e ive isoevo ijia giae. Ro buki ijia vua ije bu isoeva ije bu ijiege isoe: ");
INSERT INTO bbb_vpl VALUES ("NH7_6","017_7_6","NEH","7","6","6","Ro e ive igia isoeva ijeja e Jiusi ije bu maza ije kini Nebukaneja fu toenamiana kaenamia are fuone Bebironi ijia dibure uniaema ijiebuo asaerafa ijiebuo ive. E ijiebe aesakae Bebironi arena una uri sidove buone besubesu Jerusareme ro Juda guove ijia ruae. ");
INSERT INTO bbb_vpl VALUES ("NH7_7","017_7_7","NEH","7","7","73","(-) Ro safita 7:7-73 ije fu e ije eranebe bu Bebironi ebuo aesakae ijia karina areme una Jerusareme ruaeva ijene isoe. Ro e ije bu una ruaeva foteke ije buka e 42,360 ijiege. E ije una ruaeva ije bu kuke fanu osekina kamerokina doniki buone uruvana 8,136 ijiege kaenamia ruae. E ije ruaeva gue bu Jerusareme sidove ijia karikoga gue bu una va sidove buone binobino Juda guove ijia kari. ");
INSERT INTO bbb_vpl VALUES ("NH8_1","017_8_1","NEH","8","1","2","Ijiege rena e Isureroko boeje bu asame be romoga bune una sidove buone ijia karijana vae. Areme e boeje bune una Jerusareme ijia besu afui. Bu are viene bu kua Do Vieneno kuavo bu aruvo ijia afui. Areme bune uri Esura e akae isoekinu nijasiamo ije kuavo fu urina buki ije e Isureroko bu iriniadufuo ije E Ireobo fu Mosisi kuamo fu isoema ijene abei. Areme fune uri e boeje barubara ro eranebe bu mukoe fiena vierafevo bu afuiva ije nidua buone ijia mani. ");
INSERT INTO bbb_vpl VALUES ("NH8_3","017_8_3","NEH","8","3","3","Fu ijia mani areme uri Buki Akae ijene dabe suoke ve iko irasemo ijia dako vakuma maza uvuoka mani. Ro e boeje ijia kariva ije bu vua asune fuone ijene mukore fiekuae buka mauikeigia karina fiejae. ");
INSERT INTO bbb_vpl VALUES ("NH8_4","017_8_4","NEH","8","4","4","Ijiege rena Esura fune urina fata ije bu iviama saeva vua kuaedufuo ajia mani. Ro e ije bu fuina fata ijia umui maeneke ijia ireva ijeja e Matitiakina Semakina Anaea ro Uriakiro Irikaea ro e Maseja ijene. Ro e ije una umui aeneke ijia ireva ijeja e Fedaeakina Misero ro e Makijakina Asumi ro Asibadanakina e Zekaraea ro e Mesurame ijene. ");
INSERT INTO bbb_vpl VALUES ("NH8_5","017_8_5","NEH","8","5","5","Ro maza ije e Esura fu e boeje asidiana kave ijia ajia manino ije e boeje buka fu veri. Bu ijia karina veri gake fune Buki Akae ijene abe iramoga e boeje buka uri arire irei. ");
INSERT INTO bbb_vpl VALUES ("NH8_6","017_8_6","NEH","8","6","6","Areme Esura fune uri E Ireobo ro Godi ka daroki ijadufuo oemarei. Esura fu ijiege Godi oemaremoga e boeje buka uri umui kave ijia korekinu kumei, Mare maremano kumei. Bu ijiege kumena e boeje buka ijia auge sana tua ume ijia dijena E Ireobo dabe aroena baname isoe. ");
INSERT INTO bbb_vpl VALUES ("NH8_7","017_8_7","NEH","8","7","7","Areme bune una urina irekoga e Rivaeti ijiebe urina akae ijadufuo vua maeje una mukoreigia kuariakoga e boeje bu fie. Ro e Rivaeti ijiebuo ive ijeja e Jesuakina Banikina Serebiakina Jaminikina Akubikina Sabetae ro e Odia ijene. Ro e Maseakina Keritakina Azaraekina Jozabadikina Anani ro e Feraea ijene. ");
INSERT INTO bbb_vpl VALUES ("NH8_8","017_8_8","NEH","8","8","8","E ijiebe Godido Akae ije dama areme vua maeje kena una mukoreigia samadukua e boeje kuariae. Bu ijiege kuariaekina bu vua maeje mukoreigia fiena vierafekuae bu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH8_9","017_8_9","NEH","8","9","9","Areme e boeje bu akae ijare izege kuaemo bu ije fievo buka oe gamia niriakiamoga bu ijia uruvana nirae. Bu ijiege niraevoga e Rivaeti ije vua akae ijadufuo maeje kuariana nijasiavo ijiakina e Neamaeakiro Esura bu urina vafiae. Bu kiae, Mazani ige fuka E Ireobo Godi jone ijadufuo mazani anuigi be ijadufuo jade niraevo. ");
INSERT INTO bbb_vpl VALUES ("NH8_10","017_8_10","NEH","8","10","10","Ro nime urina va are jone gafia irekiro do vaeni maeje ja naeva ijene ina oemarefo. Areme ni ire jone mukore gue ja naeva ijene karina una e gue eranebe naebe naeva ijene ivajiafo. Ijadufuo maeje mazani ige fuka E Ireobo jone ijadufuo mazani akae ijadufuo jade karina oefiane abevo. Ro no vierafe E Ireobo fu ifejuoga no oemarekinu oenoevo ijia noka una daro abekono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH8_11","017_8_11","NEH","8","11","11","Bu ijiege revoga e Rivaeti bu urana oenoekinu e ije niraevo ije vafiae. Bu vafiakinu kiae, Maza igeki fuka akae ijadufuo mauike karikiro ije ja oefiane abekinu niraevo ije areno kiae. ");
INSERT INTO bbb_vpl VALUES ("NH8_12","017_8_12","NEH","8","12","12","Ijadufuo e boeje bune una va are buone ijia usiaena iro ina oemarei. Bu ijiege urukeigia oemarekinu uri ire ro sinuome buone maeje bu naeva ijene kena una e gue bu ire baki ijene ivajiae. Bu ijiege reva ijadufuo maeje e Rivaeti bune Godido Buki Akae mukoreigia dana nijasiavoga bu vua asune ije fiena vierafei. ");
INSERT INTO bbb_vpl VALUES ("NH8_13","017_8_13","NEH","8","13","13","Areme nituame agane binobino ijiebuo e mamekanu ijiakina e zinone ifaejevo ro e Rivaeti ije bune una Esura fino ijia vae. Bu vierafe buka va fuina karina akae ije fu irere kuaemo ijene una vua maeje mukoreigia fiekuae vae. ");
INSERT INTO bbb_vpl VALUES ("NH8_14","017_8_14","NEH","8","14","14","Bu va karina fievo ijia bu E Ireobo ijadufuo akae be fu Mosisi kuaraema bu ije fie. Ro akae ije fu kuae e Isureroko bu asame seveni abega bu iro bu kua Are Muvuakano kuavo ijene ivo ije buka are muvuaka sana ijia karino kuaema bu ije fie. ");
INSERT INTO bbb_vpl VALUES ("NH8_15","017_8_15","NEH","8","15","15","Ro kuke buka vua ijene dabe Jerusaremekina sidove boeje ijia e Isureroko ije kuariana nijasiake. Bu kuariaga e ije buka va uruo gafia ifiri binobino ine orivikina aname ro metorokiro ine gue afare mukore e bu rotire ijia karivo ijiebuo a ijene medufuo. Areme bu karina izege Godido akae fu kuaema ijiege are muvuaka sana ijia karino kiae. ");
INSERT INTO bbb_vpl VALUES ("NH8_16","017_8_16","NEH","8","16","16","Ijadufuo e Isureroko bune uri ifiri mena are buone besubesu ado ijia ajiana are isesina muvuaka ije sae. Ro gue bu are buone makave ijia are muvuaka sae. Ro gue bu Godido Are ijadufuo makave ijia sae. Ro gue bu viene bu kua, Do Vieno kuavo ro kuke viene be bu kua, Ifuremi Vieno kuavo ijiebuo makave ijia are muvuaka buone sae. ");
INSERT INTO bbb_vpl VALUES ("NH8_17","017_8_17","NEH","8","17","17","Ijiege rena e boeje eranebe bu va ebuo are ijia karina una Jerusareme ruaeva ije buka are muvuaka sana ijia karinoe. Ro are muvuaka bu saeva ije e boeje bu oeseradiavo buka oemarekinu ijia aru karinoe. Ijadufuo maeje ude maza ije e Nanedo fari e Josua fu e Isureroko samuagiaema ijia ruoma iviama ige iro ije bu kua Are Muvuaka Sana Karivono kuavo ije bu ivo baki. ");
INSERT INTO bbb_vpl VALUES ("NH8_18","017_8_18","NEH","8","18","18","Ro mazani amure bu zinuevena iro iva ijia vakuma ubine bu furiva ukua ije e Esura fuka maza besubesu Godido Buki Akae ije dakoga e Isureroko bu fie. Ro kuke iro ije bu oemarekinu ina vakuma mazani seveni (7) ijiege furi. Ro una maza eti (8) ije e boeje bune izege Godido Akae fu kuaema ijiege una besu afui. ");
INSERT INTO bbb_vpl VALUES ("NH9_1","017_9_1","NEH","9","1","1","Ijiege rena asame besu ijadufuo mazani tuaedi fo (24) ijia e Isureroko ije bune una besu afui. Buka sinuome uki vajae aziziavo ijene sama tuvuare datena nigofo akoena ire atokinu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("NH9_2","017_9_2","NEH","9","2","2","Areme e Isureroko ije bune e aebinoko ije uniana va buebino kari. Areme bune urina ise buone ijiakiro asaerafa buone ijiebuo ise bu reva ijene visuna Godi kuarae. ");
INSERT INTO bbb_vpl VALUES ("NH9_3","017_9_3","NEH","9","3","3","Ijiege rena suoke naeni kiroki ijia bune zinuivena E Ireobo Godi buone ijadufuo akae ije abena dako vakuma maza uvuoka abei. Areme maza dakudena maniko bune una kuke ise buone ije visuna Godi kuarakinu fuone baname isoena aroeko vakuma maza fo kiroki abei. ");
INSERT INTO bbb_vpl VALUES ("NH9_4","017_9_4","NEH","9","4","4","Bu ijiege aroekoga e Rivaeti ije bu fata ijia irena E Ireobo Godi buone ijadufuo urukeigia baname isoe. Ro e Rivaeti ijeja e Jesuakina Banikina Kadimierokina Sebaniakina Bunikina Serebiakina e Bani ro Kenani ijene. ");
INSERT INTO bbb_vpl VALUES ("NH9_5","017_9_5","NEH","9","5","5","Ro e Rivaeti gue bu urina kiae, E boeje ni urina E Ireobo Godi jone maza boeje ijia fivako ijadufuo ive sanaema ije dabe oemareno kiae areme bune kuke baname isoena kuae, E Ireobo no vierafega e boeje buka ive one ka anuigi ijene dabe maza boeje aroekinu oemarejake. ");
INSERT INTO bbb_vpl VALUES ("NH9_6","017_9_6","NEH","9","6","6","Ro aeje aka ma E Ireobo are saove gufe amaeri areme ire zuvi boeje amaeriae. Are sakae ige amaeri areme ire boeje binobino amaeriana ado ijia uniae. Ro kuke are davare ijiakiro ire boeje guove ijia oenoejo ije amaeriae. Ro are kiaga ire boeje bu maza boeje ijia karivako. Ro anera boeje saove gufia kariva ije buka a baname isoekinu kuri tuakafavo. ");
INSERT INTO bbb_vpl VALUES ("NH9_7","017_9_7","NEH","9","7","7","Aeje aka Godi E Ireobo ro are aesakae Bebironi guove are Eri ijia e Aburame abe areme mesirina keke vae. Ro kuke are ive fuone ijene abe una iviaeko ina Eburame kuae. ");
INSERT INTO bbb_vpl VALUES ("NH9_8","017_9_8","NEH","9","8","8","A gaga funeka maza boeje a irinana e ijuebaki remoga a fuosiki vua kuaena avenami. A kua na e Kenanaeti ro Itaeti ro Amoraeti ro Ferizaeti ro Jebusaeti ro Gegasaeti ijiebuo sakae ije kena una uifari fuone vajakono kuae. A sakae ije kena fu vajaekina uifari fuone bu rade ijia karike. Aka maza boeje vame maturaema ijiaru renoeno ijadufuo vua irere a kuaemo ije a totemo baki ro aka uria vierafemo. ");
INSERT INTO bbb_vpl VALUES ("NH9_9","017_9_9","NEH","9","9","9","A izege asaerafa nuvuone ije bu Ijifiti ijia isejavaenoevo ije ane giae. Ijadufuo bu Davare Kavuaneno kuavo ijia a ifejiakiro bu kumevoga ane fie. ");
INSERT INTO bbb_vpl VALUES ("NH9_10","017_9_10","NEH","9","10","10","A ire ka sumiki daroki ijene kini ijiakiro e mamekanu ro e Ijifitiko boeje ije buone rei. Ijadufuo maeje a giaga buka vame ma ise ijia e one ije kame isekafiana arafiriae. A ijiege rema ijadufuo e buka iviama uria ive one daroki ije dabe kuaenoeve. ");
INSERT INTO bbb_vpl VALUES ("NH9_11","017_9_11","NEH","9","11","11","A e one ijiebuo vame amaerina davare ije dabe ata guegue re areme kaenamia sakae iriaeki ijia bierena vae. Ro e ije bu e Isureroko kaniakuae kame arafiriana nuvediavo boeje aka kame davare ijadufuo daro ije fu ufemo ijia koremo bu mune igege do mane ijia arina do ina oe furi. ");
INSERT INTO bbb_vpl VALUES ("NH9_12","017_9_12","NEH","9","12","12","Ro maza ije a e Isureroko kaenamia vaema ije a amite rena vako bu ijia nuvedae. Ro una muge a miane rena ude naena sanakinu vako bu ijia gakinu nuvedae. ");
INSERT INTO bbb_vpl VALUES ("NH9_13","017_9_13","NEH","9","13","13","A Uruo Sanae manino kubi ijia a saove ijia arina e one ije vua kuariae. Areme a uri akae one mukore ijiakiro akae ije a e boeje kena besu enafuna kafiamo ije abe miae. ");
INSERT INTO bbb_vpl VALUES ("NH9_14","017_9_14","NEH","9","14","14","A ijiege mia areme kuke uri izege bu mazani one akae mauike karina baname isoevo ije abe mukoreigia samuadufuo ije kuariae. Ro kuke aka akae one binobino bu iriniadufuo ije Mosisi e one imeno ije kuamo fu isoena abe e one miae. ");
INSERT INTO bbb_vpl VALUES ("NH9_15","017_9_15","NEH","9","15","15","Buka vasia abevoga a ire burete saove ijia kena vajiamo bu i. Ro kuke bu do duadiamoga a munuage ijia kuamo do fu ijia abiesemoga bu i. A aesakae ije a abe miakono kiaema ije a kia ni va jone abena ijia karino kiae. ");
INSERT INTO bbb_vpl VALUES ("NH9_16","017_9_16","NEH","9","16","16","Rove asaerafa nuvuone buka aroekarae ro kuke buka nigofo gikikmana rena vua one a kuariaema ije buka naebe irinae. ");
INSERT INTO bbb_vpl VALUES ("NH9_17","017_9_17","NEH","9","17","17","Bu a irinadufuo ije buka ijuone ro kuke irere a buefuo rema ije buka naebe una ijene vierafei. Bu vame sumiki daroki boeje a rema ije buka totei ijadufuo buka aroekarana una korubuo e fu bu samuagiadufuo ijene abei. Bu e abega fure kaenamiana una Ijifiti ijia vaga bu e ijiebuo mani baki imekuae bu ijiege rei. Rove aka Godi ije ebuo ise giana aremo ijene. Ro aeje aka Godi ije e marejiakinu ro oetuamo ijene. Ro kuke aka migegire ziemo baki ro kuke one izege a e gia oefiane abeno ije fuka ma ireobo. ");
INSERT INTO bbb_vpl VALUES ("NH9_18","017_9_18","NEH","9","18","18","Bu godi kufui ijene ire gorodi ijia mave-kau ame igeki ije amaeri areme kuae fu godi ijare are Ijifiti ijia bu kaenamiana keke ruaemano kuae. Ro kuke buka E Ireobo oesina vua ka omise ije kuae. Rove aka naebe bu ijuenena giamemarei. ");
INSERT INTO bbb_vpl VALUES ("NH9_19","017_9_19","NEH","9","19","19","Ro ae sao ijia bu oenoeva ijia a naebe bu totena ijuegafiae. Ijadufuo maeje one izege a e giana oefiane abeno ije fuka ma ireobo. Ijadufuo maza ije a amite rena vako bu nuveda ro muge a miane rena naekinu vako bu ijia gakinu nuvedae. ");
INSERT INTO bbb_vpl VALUES ("NH9_20","017_9_20","NEH","9","20","20","Ro kuke aka Kavene one maeje fu vame maeje nijasiadufuo ijene abe miae. Ro aka ire mena ijene vajiamo bu i ro do duadiamoga a ifejiamo bu do i. ");
INSERT INTO bbb_vpl VALUES ("NH9_21","017_9_21","NEH","9","21","21","Ro juaevasia boeje foti (40) bu are sao ijia urana oenoeva ijia bu ire bino buka naebe nidue ro aka ifejiana irekiro do vajiamo bu i. Ro a ifejiamoga ugone buone bu savo ije buka naebe isuiko rei ro dia buone bu naebe ufiae. ");
INSERT INTO bbb_vpl VALUES ("NH9_22","017_9_22","NEH","9","22","22","Ro are asaerafa nuvuone ifejiamoga bu e aesakae binobino ijia kariva ijena bijaena bure iraraena kania areme sakae ijiakiro sidove buone ijene kei. Bu kena ijia kari vakuma sakae kiane ubine iziebure bu iriva ijia karijana vae. Ro kuke are ifejiamoga bu kini Saeoni aesakae Esiboni samuamo ijiakiro kini Oge aesakae Basiani samuamo ije iraraena kania areme aesakae buone ije buone kei. ");
INSERT INTO bbb_vpl VALUES ("NH9_23","017_9_23","NEH","9","23","23","Ro are ifejiamoga uifari buone ije bu ire zuvi gufe bu ireva ijiege buka e uruvana rei. Areme a kaenamiana romoga bu aesakae ije a asoerafa buone kaenamia roga bu abena ijia karidufuo a kiaema ije abena ijia kari. ");
INSERT INTO bbb_vpl VALUES ("NH9_24","017_9_24","NEH","9","24","24","Ro are ifejiamoga anafa buone bu e binobino sakae Kenani guove ijia kariva ije iraraena kaniakuria areme aesakae buone ijene kei. Areme a kuke e one ije daro miana ifejiamoga bu e kini Kenaniko ijiakiro e boeje aesakae ijia kariva ijene kena vame izege bu vierafeva ijia arafiriae. ");
INSERT INTO bbb_vpl VALUES ("NH9_25","017_9_25","NEH","9","25","25","Areme bu uri e daroki ije bu sidove mamekanu ijia karivo ije iraraena kaniakuria areme sidove buone ije kei. Bu ijiege re areme uri sakae mukore ire boeje ni binobino tavuavo ijene buone kei areme uri are buone bu ire mukore ijia naeva ijene kei. Areme bu kuke uri mako buone ije bu do jiavo bu runa amaeriaeva ijiakina ine orive ro ine bu fo tura ivo ro ire vaeni juare ijene buone kei. Areme bune uri ire maeje bu kariva ijene uruvana ivo buka deufiana ubaeradiae. Aka vame mukore ijene buefuo rema ijadufuo buka una one ireobo oemarei. ");
INSERT INTO bbb_vpl VALUES ("NH9_26","017_9_26","NEH","9","26","26","Rove bu naebe una a irinae ro buka ijuegafana akae one a kuariaema ije bu naebe ijia nuvei. Ro buka uri e one bu vua one vierafena kuaevo ije bu una oe kuderia one ruadufuo bu umui bijiana uruke kuariavo ije kaniae. Ro kuke buka maza boeje vua ise oesina kuae. ");
INSERT INTO bbb_vpl VALUES ("NH9_27","017_9_27","NEH","9","27","27","Ijadufuo a e ani buone kiamoga bu e ije kame vame gikikimana ijia arafiriana vajae fiane vajiae. Rove bu una a kumevoga a saove ijia fina fie. Ro aeje aka e mukoreigia oetuana marejiamo ijadufuo a e ije kiamo bu va e ani buone ijiebuo umui ijia faradia turana kaenamia usiae ruae. ");
INSERT INTO bbb_vpl VALUES ("NH9_28","017_9_28","NEH","9","28","28","Bu mazani ije bune una oe dasuna oemarekinu karivo ijia buka una kuke ise renoe. Ijadufuo a una kuke giamemarekoga e ani buone bu iraraena kaenamiana samuagiakinu kame vame gikikimana ijia arafiriae. Rove one izege a e oetuakinu marejiamo ije fuka ma anuigi. Ijadufuo a bu karauniakiro bu oe kuderiana kumevoga aka saove ijia fina fie. Ijadufuo a maza besubesu oefiane ro vajae fiane bu abevo ijia karauniae. ");
INSERT INTO bbb_vpl VALUES ("NH9_29","017_9_29","NEH","9","29","29","A akae ije bu izege a mukoreigia irinadufuo ije ane umui bijiana urukeigia kuariamo rove buka aroekarana vua one ijuone. Bu akae one izege e bu mukoreigia iriniaga bu ma karivadufuo ije buka dabe tuasei. Ro kuke nigofo buone buka gikikimana reva ijadufuo vua one ije buka naebe fie. ");
INSERT INTO bbb_vpl VALUES ("NH9_30","017_9_30","NEH","9","30","30","A juaevasia ma uruvana aka mauike fikinu e vua one vierafena kuaevo ije kiamoga bune e one vua jujuki ije kuariae. Rove buka naebe fiekuae vierafe ijadufuo a arekoga bu e ije bu ivuake ijia karivo ijiebe buina bijaena irarae kaniae. ");
INSERT INTO bbb_vpl VALUES ("NH9_31","017_9_31","NEH","9","31","31","Rove aeje aka Godi ije e marejiakinu ro giana oefiane abeno ijene. Ijadufuo a naebe ijuegafiakoga bu e foteke kania furi. ");
INSERT INTO bbb_vpl VALUES ("NH9_32","017_9_32","NEH","9","32","32","Ro Godi aeje aka Godi anuigi ro ka daroki ijene. Aka e oetuamo ijadufuo irere a rekiro kuaemo ije a totemo baki ro a uria vierafemo. Ijadufuo irufui ige no abevo ije guona ifejuokiro ade aremo. Isuibe e aesakae Asiriako ijiebuo kini ijiebe no kame vame omise ijia arafirue. Ro kuke maza ijia ruoma iviama ige e gue buduaku buka no irufui vajue. Bu kini nuvuone ijiakiro e mamekanu ro e zinone ifaejevo ijiakiro e vua one vierafena kuaevo ro asaerafa nuvuone ro e one boeje kame uruke arafiruovo noka uruvana isejavae. ");
INSERT INTO bbb_vpl VALUES ("NH9_33","017_9_33","NEH","9","33","33","Rove Godi no maza boeje ise rega a kena isekafuomo ije a isema remo baki. Ijadufuo no a kame ijiege kafuomo ije ane ma rei rove no nore isema rena vua one naebe iriniae. ");
INSERT INTO bbb_vpl VALUES ("NH9_34","017_9_34","NEH","9","34","34","Asaerafa nuvuone ijiakina kini ro e mamekanu ro e zinone ifaejevo ije bu akae one ije buka iriniavo baki. Ro kuke buka irere bu redufuo ijiakiro vua jujuki a kuariamo ije buka mukoe fievo baki. ");
INSERT INTO bbb_vpl VALUES ("NH9_35","017_9_35","NEH","9","35","35","Ro kuke aka bu daro miana ifejiana sakae maeje saruegi ije abe miamoga bu ijia karina vame one maeje anuigi a buone remo bu ijene oemarekinu karina renoe. Rove buka una oefuo imevo baki ro kuke bu vame buone omise bu kenoevo ije bu naebe arei. ");
INSERT INTO bbb_vpl VALUES ("NH9_36","017_9_36","NEH","9","36","36","No iviama none sakae saruegi mukore ige a abena asaerafa nuvuone ije miaga bu ire maeje ijia tavuavo ije kekinuro ifo turana idufuo a kiaema no ijia kari. None ijia kari rove no uria una kuke e ijiebuo mani baki imekinu vajae fiane abena isejavaeve. ");
INSERT INTO bbb_vpl VALUES ("NH9_37","017_9_37","NEH","9","37","37","Noka ise reva ijadufuo ire maeje nuvuone boeje binobino no sakae ige a muema igia kevo boeje bune kini ije a kiaga bu no samuaguovo ijiebe buone karive. Bu fanuve nuvuone binobino no samuagiavo ije bune karina kame buone bu vierafevo ijia renoeve. Ro kuke noeje bune bure samuaguovo ijadufuo no konuvuo nuvuone oemarevo ijia ire binobino renoevo baki. Ire boeje none buone izege bu vierafevo ijiaru renoevo ijadufuo iviama noneka irufui ma uruvana abeve. ");
INSERT INTO bbb_vpl VALUES ("NH9_38","017_9_38","NEH","9","38","38","No ijiege abena ruaeva ijadufuo iviama e Isureroko ige none igifureki oe besu vierafe kuaena abe isoeve. No nuvuosukua bakiro e nuvuone mamekanu ro e Rivaeti ro e zinone ifaejevo ije budua bune noena vua ije abe isoe nijavo ijene ka abe gikikimana revono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH10_1","017_10_1","NEH","10","1","39","(-) ");
INSERT INTO bbb_vpl VALUES ("NH11_1","017_11_1","NEH","11","1","36","(-) ");
INSERT INTO bbb_vpl VALUES ("NH12_1","017_12_1","NEH","12","1","47","(-) ");
INSERT INTO bbb_vpl VALUES ("NH13_1","017_13_1","NEH","13","1","1","Areme maza ijia e Isureroko boeje bune besu afuima kari fiekoga e Rivaeti ije bu urina Mosisido akae fu isoema ijene dabe una dae. Bu dakoga e boeje bu fievakuma vua kafare be fu kuae e Amonaetiko ijiakiro e Mobaetiko ije bube una Godido e ijena besu karino kuaema bu ijene fie. ");
INSERT INTO bbb_vpl VALUES ("NH13_2","017_13_2","NEH","13","2","2","Ijadufuo maeje isuibe maza ije e Isureroko bu aesakae Ijifiti arena usiae ruaeva ije e Amonaetiko ijiakiro e Mobaetiko ije buka naebe bu oemarejiana irekiro do ifejiana vajiae. Rove buka una e Isureroko ijene ire ise rekuae vierafei. Ijadufuo bu uri moni karana e Berame fuaeve arega fu e Isureroko ije kuravajiana vafiakiro bu ijiege rei. Ro Godi nuvuone fu Beramedo vua ije fu e Isureroko kuravajiakiro vierafema ije fu abe dakudemoga e Berame fume una vua ma ijiaru e Isureroko ijiebuo kuae. ");
INSERT INTO bbb_vpl VALUES ("NH13_3","017_13_3","NEH","13","3","3","Ijadufuo e Isureroko boeje bu ve ijia vua ije fiena uri e ae binoko ije kuriaerevoga bu naebe buina besu karinoe. ");
INSERT INTO bbb_vpl VALUES ("NH13_4","017_13_4","NEH","13","4","4","Ro vame ije bu rade rei ro ude e Iraeasibi e zinone ifaejemo ije fu Godido Are guove be bu ijia ire binobino navo ije samuamo. Ro kuke Iraeasibi fu Godido Are ijia guove be e Tobia mae. Rove e Iraeasibi ije fuka isema rei ijadufuo maeje e Tobia fu e Amonaetiko ro kuke fure ude e Isureroko isuo bu kiravo ijene bijukuriakiro renoe. ");
INSERT INTO bbb_vpl VALUES ("NH13_5","017_13_5","NEH","13","5","5","Ro are guove ije bu ude ire vuiti ije e Isureroko bu amure masina ke Godi zinone vajavo ijiakiro ire udi mukore urimo ijene ijia navo. Ro kuke disi bu kena Godido Are ijia imevo ijiakina ire buone maeje binobino bu kena Godido i ijadufuo ruovo ijene ijia navo. Bu ire vuiti ijiakina do vaeni ro oere bu e binobino Godido Are Akae ijia imevo ije vajiakuae ke ruovo ijene navo. ");
INSERT INTO bbb_vpl VALUES ("NH13_6","017_13_6","NEH","13","6","6","Ro mazani ije bu ijiege karina revo ije Neamaea naeje na Jerusareme ijia na baki. Ijadufuo maeje naeje nane una are Bebironia ijia Kini Atekesi ijene gakiro vae. Ro kini aesakae ije fu samuaema ije fu juaevasia teti tu (32) ijiege furiko na ijia una vae. Areme maza sibaneke furikoga rade na una Jerusareme ruakiro va kuavo fu kiemoga na una Jerusareme ruae. ");
INSERT INTO bbb_vpl VALUES ("NH13_7","017_13_7","NEH","13","7","7","Na maza ije na una igia ruaeva ijia na vame ise ije e Iraeasibi fu rena Godido Are guove be e Tobia maema ijene fie. ");
INSERT INTO bbb_vpl VALUES ("NH13_8","017_13_8","NEH","13","8","8","Na vua ije fievo naka naebe oemarei ijadufuo na Godido Are ijia aruna e Tobiado sinuome boeje fu guove ijia naema ijene karina makave ijia korei. ");
INSERT INTO bbb_vpl VALUES ("NH13_9","017_13_9","NEH","13","9","9","Areme na e ijia i mevo ije kiavoga bu are guove ije una amaerima fu maremoga bu abe Godido baname isoena daro mae. Bu ijiege rema areme uri sinuome binobino bu Godido Are ijia imevo bu kari usiae vaeva ijene karina una guove ijia nae. Areme bu kuke irekina isuni binobino iviaeko e bu karina Godi vajavo ijiakina ire udi mukore urimo ijene karina una are guove ijia nae. ");
INSERT INTO bbb_vpl VALUES ("NH13_10","017_13_10","NEH","13","10","10","Na ijiege rekinuro fieke bu ire ije bu karina e Rivaeti ije vajiadufuo navo ije bu naebe kena vajiaevo na ijene fie. Ro kuke e Rivaeti ijiakiro e dua uruvo ije bu guriguri ije samuagiavo ije bune i buone bu mevo ije arena una juare buone ijia vaeva na ijene fie. ");
INSERT INTO bbb_vpl VALUES ("NH13_11","017_13_11","NEH","13","11","11","Ijadufuo na uri e Isureroko ijiebuo e mamekanu ije vua gikikimana kuariae. Na kiae, Ja Godido are guove ijia i binobino ja mevo ije ja irerefuo arena vaevano kiae? Na ijiege kuariama areme e Rivaetiko ije kumevo bu una besu afuivoga na kiavo bu i buone una mei. ");
INSERT INTO bbb_vpl VALUES ("NH13_12","017_13_12","NEH","13","12","12","Areme e Judako boeje bune irekina do vaeni iviaeko ro oere ije bu amure masivo ijene karina Godido are guove bu sinuome navo ijia nae. ");
INSERT INTO bbb_vpl VALUES ("NH13_13","017_13_13","NEH","13","13","13","Bu kari rovoga na uri Seremia e zinone ifaejemo ijiakina Zadoke e ije akae nijasiamo ijiakina e Rivaeti be ive fuone Fedaea ijene kei. Areme na kiavoga bu Godido Are guove ije bu ire ro sinuome navo ijene samuae. Areme na uri Anane e Mataniado asae ro e Zakudo fari ije abevoga fu buone rotire ijia imei. Ro e ije buka e mukore bu i mukoe mevo e boeje bune giana vierafe. Ijadufuo na e ije kevoga bure ire ije e boeje bu kena Godido are ijia ruovo ijene gue karina e Rivaeti ije ivajiae. ");
INSERT INTO bbb_vpl VALUES ("NH13_14","017_13_14","NEH","13","14","14","Areme na uri Godi baname isoena kuae, Godi none ni i mukore igiakiro vame maeje na Godi none ijadufuo are igia mevo ije giena vierafekiro ade totemono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH13_15","017_13_15","NEH","13","15","15","Mazani ijia na oenoekinu giake e Judako bu mazani ije bu mauike karina Godi baname isoevo ijia karina ire gurefi ije musana do vaeni amaeriavo na giae. Bu ijiege rekinu uri irekina vaeni ro isunikina ire boeje binobino ijene riena kari fanu doniki ijia nana Jerusareme ijia mani fuaevekuae ruovo na giae. Ijadufuo naka vua gikikimana ju kuariana kiae, Jade Godido mazani ijia ire jone karina fuaevejono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH13_16","017_13_16","NEH","13","16","16","Na ijiege kuariakinuro giake e Taerako bu Jerusareme karivo duaku Godido mazani ijia kijumekina ire binobino karina ro Jerusareme guove ijia e Judako ijiebe fuaeveje. ");
INSERT INTO bbb_vpl VALUES ("NH13_17","017_13_17","NEH","13","17","17","Bu ijiege revoga na uri e Judako ijiebuo e mamekanu ije vua gikikimana kuariana kiae, Ja irerefuo vame ka omise ije rena mazani akae ije dabe arafirive? ");
INSERT INTO bbb_vpl VALUES ("NH13_18","017_13_18","NEH","13","18","18","Ja vierafe asaerafa jone bu izege revoga Godi nuvuone ije fu bu kame isekafiana uri sidove Jerusareme dabe arafiri? Iviama na giaga jaka una vame besu ijiege karina reve. Ja mazani akae ige dabe arafirivo ijadufuo na vierafe Godi fuka una e Isureroko ige no kame isekafuokono kiae. ");
INSERT INTO bbb_vpl VALUES ("NH13_19","017_13_19","NEH","13","19","19","Ijadufuo na oenoena ve fune tituteko Godido mazani ije fune ivuaremo ije na kiaga bu viene boeje bijuvo. Ro viene boeje na e none imevo gue kiaga bu samuavo ijadufuo e bino bu Godido maza ijia ire karina guove ijia fuaevejo baki. Bu ijiege bijuna karivakuma Godido mazani ije fune furimone na kiaga bu una azovo. ");
INSERT INTO bbb_vpl VALUES ("NH13_20","017_13_20","NEH","13","20","20","Na viene ijiege bijuvo rove e gue buka uria ire buone binobino karina fuaevekuae ruove. Ijadufuo ve mumone bu Jerusareme isuo makave gafa naovo. ");
INSERT INTO bbb_vpl VALUES ("NH13_21","017_13_21","NEH","13","21","21","Ijadufuo na keke giavo ije naka vua gikikimana kuariana kia, Ja irerefuo ro makave igia ijiege naove? Na rade una ro giaga ja uria ijiege rekuva naka e none imevo ije kiaga bu toenamiakono kiae. Ijadufuo rade e bino bu naebe una maza ije bu mauike karina baname isoevo ijia ire buone binobino karina ro fuaeve. ");
INSERT INTO bbb_vpl VALUES ("NH13_22","017_13_22","NEH","13","22","22","Na ijiege re areme uri e Rivaeti ije kiavoga bu va ise buone visu Godi kuarakinu oe buone ijia amaerenami. Bu ijiege rekina bu viene boeje samuaga nobe mazani ije mauike karina baname isoevo ije abe arafirikiro noka mukoreigia samuaga fuka akae reke. Areme na uri Godi baname isoena kuae, Godi none one a e oetuamo ije fuka ma ireobo ro fume ijiege navako. Ijadufuo ni kuke vame mukore ige be dua na revo ige giena marejiekiro ade na totemono kuae. ");
INSERT INTO bbb_vpl VALUES ("NH13_23","017_13_23","NEH","13","23","23","Areme mazani ijia na kuke giake e fari Judako ma uruvana buka bara aesakae binoko Asedodikiro Amani ro Moabiko ije kevo na giae. ");
INSERT INTO bbb_vpl VALUES ("NH13_24","017_13_24","NEH","13","24","24","Ijadufuo anafa buone ma uruvana bune e Asedodiko ijiebuo isama ijiakiro e guebuo isama ijene kuaeve. Bune ijiege rena isama nuvuone e Judako igiebuo ije bu kuaevo ije buneka toteve. ");
INSERT INTO bbb_vpl VALUES ("NH13_25","017_13_25","NEH","13","25","25","Bu ijiege abevoga naka ziena vua gikikimana kuariae. Ro e gue naka kaniana nigofo jau buone ijene faradiana usi. Areme naka kuriaerevoga bu uri Godi kurana akae gikikimana be nijae. Bu ijiege nijaekina rade bube anafa buone kiaga bu bara ae binoko samiakinu ro baru maniake. Ro kuke e fari ae binoko bube bara Isureroko ije samiake. ");
INSERT INTO bbb_vpl VALUES ("NH13_26","017_13_26","NEH","13","26","27","Ro igia fiefo, e Kini Soromani fuka e mukore ro kuke Godi fuka fu ireobo oetuamo. Fuje fu e ae sakae gue ijiebuo kini ijieki baki. Godi fu Soromani daro mamoga fu e Isureroko ijiebuo kini rei. Rove fu una bara ae binoko ije kemoga bara ijiebe vierafe fuone ijene dabe arafirivo fuka ise ireobo rei. Ijadufuo iviama na giaga jadua janeka una vame ka omise ni besu ijene reve. Ja Godi nuvuone fu maza boeje ja oetuamo ije jane totena ijuegafae. Ijadufuo maeje jane una bara ae binoko ijene keve. ");
INSERT INTO bbb_vpl VALUES ("NH13_28","017_13_28","NEH","13","28","28","Ro Joeada e Iraeasibi e ireobo zinone ifaejemo ijadufuo fari ije fu Sanebarate e Oronaetiko ijadufuo kabae ije abei. Ijadufuo na e ijene kuriaerena rorukuravo fu Jerusareme arena una are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("NH13_29","017_13_29","NEH","13","29","29","O Godi none, e ije bune ise rena e zinone ifaejevo ijiebuo ive kame arafiriae. Ro kuke bu e zinone ifaejevo ijiakiro e Rivaeti ijiebuo vua bu ire bino redufuo kuaena avenamiva ijene kame iserei. Ijadufuo ni vame ije bu kevo ijene giano kuae. ");
INSERT INTO bbb_vpl VALUES ("NH13_30","017_13_30","NEH","13","30","30","Areme na ire boeje e ae binoko ijiebuo bu kena ruaeva ijene kari korei. Na ijiege re areme uri e zinone ifaejevo ijiakiro e Rivaeti ije besubesu i fuone irere fu medufuo ijene nijasiae. Areme nane kiavo bu una i buone bu mevo ijene mei. ");
INSERT INTO bbb_vpl VALUES ("NH13_31","017_13_31","NEH","13","31","31","Ro na vakuma mazani zinone ifaejedufuo ruomo ije na e gue kiaga buka miane atana kari ruovo. Ro kuke na kiaga bu ire uije binobino bu zinuevena duivo ije karina ro e zinone ifaejevo ije vajiavo. Ijadufuo Godi none ni vame maeje na revo ije giena marejiene. ");
INSERT INTO bbb_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Suvuare ige ijeja izege Jesu Kuraesido asaerafa ije bu e Eburamedo ijia uinuvena ruoma e Devidido ijia usiaena ruoma Jesu bieteva ijene. ");
INSERT INTO bbb_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ro e uije ije bu uinuvena ruaeva ije ijiege. E Eburame fu fari fuone e Aeseki bietemoga fu uri fari fuone e Jekafu bietei. Fu Jekafu bietemoga fu uri e Judakiro uviarafa fuone ije nafei. ");
INSERT INTO bbb_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Areme Juda fu uri ame inokiro e Ferezekiro e Zera nafei ro asie buone ije bara Tama. Ro e Fereze fu uri fari fuone e Ezironi nafenoga fure uri fari fuone e Rame nafei. ");
INSERT INTO bbb_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","6","Ro e Rame fu uri fari fuone e Aminadabi nafenoga fu uri fari fuone e Nasoni nafei. Ro e Nasoni fu uri fari fuone e Saramoni nafenoga fu uri fari fuone e Boezi nafei. Ro e Boezido asie ije bara Reabi. Ro e Boezi fu uri bara Ruti abena e Obedi nafei. Ro e Obedi fu uri fari fuone e Jesi nafenoga fu uri fari fuone Devidi e ije fu Kini rema ije nafei. Areme Devidi fu uri fari fuone e Soromoni nafei ro asie fuone ije fu e Uraeado bara. ");
INSERT INTO bbb_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","10","Ro e Soromoni fu uri fari fuone e Reoboame nafenoga fu uri fari fuone e Abaeja nafei. Ro Abaeja fu uri fari fuone e Asa nafenoga Asa fu uri fari fuone e Jeosofati nafenoga fu uri fari fuone e Jorame nafei. Ro Jorame fu uri fari fuone e Azaraea nafenoga fu uri fari fuone e Jotami nafenoga fu uri fari fuone e Easi nafei. Ro Easi fu uri fari fuone e Esekaea nafenoga fu uri fari fuone e Manasa nafenoga fu uri fari fuone e Amoni nafei. ");
INSERT INTO bbb_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","14","Ro Amoni fu uri fari fuone e Josaea nafenoga fu uri fari fuone e Jekoniakiro iviefari fuone ije nafei. Areme e Bebironiko ijiebe usiae Jerusareme sidove ije kenama areme uri e Isureroko ije bune kaenamiana una are buone Babironi ijia vae. Areme rade e Jekonia fu uri fari fuone e Siritero nafenoga fu uri fari fuone e Zerubabero nafei. Ro e Zerubabero fu uri fari fuone e Abiudi nafenoga fu uri fari fuone e Eraeakimi nafenoga fu uri fari fuone e Ezo nafei. Ro Ezo fu uri fari fuone e Zedoke nafenoga fu uri fari fuone e Akimi nafenoga fu uri fari fuone e Eriudi nafei. ");
INSERT INTO bbb_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","17","Ro e Eriudi fu uri fari fuone e Erisa nafenoga fu uri fari fuone e Matani nafei. Ro e Matani fu uri fari fuone e Jekafu nafenoga fu uri fari fuone e Josofu bara Merido baru ije nafei. Ro bara Merire Jesu e ije bu kua Kuraesino kuavo e ije fu e boeje karauniakiro ruaema ijene biete. Ijadufuo e Eburame ijia ruoma e Devidi bu nafeva ijia e uije ije buka e fotini (14) ijiege. Ro una kuke e Devidido uifari ijia ruoma maza ije e Babironiko bu usiae Jerusareme sidove kena areme e Isureroko bu kaenamia Bebironi vaeva ijia e uije bu kuke e fotini (14) ijiege. Ro una maza ije bu kaenamia Babironi vaeva ijia ruoma e ije Godi fu abe e nuvuone E Ireobo rema ije bu bieteva ijia e uije bu kuke e fotini (14) ijiege. ");
INSERT INTO bbb_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijiege ro Jesu Kuraesi bu bieteva ije fu ijiege. Bara Meri asie fuone ije bu e Josofu manidufuo kuae. Ro fu uria kabaekua baruna naebe naema ijia fu fue ganami gake fu Kavene Akae ijadufuo daro ijia fu e fudiema fu ije gae. ");
INSERT INTO bbb_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Rove e Josofu fuka e mado fu naebe una Meri e ije fu fudiema ije mesirina dabe kuaegadufuo ije fu naebe ijiege rei. Ijadufuo fume oe fuone ijia Meri fu abedufuo ije fu mauike ijia arekiro fu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","21","Fu ijiege vierafenoenoga E Ireobo ijadufuo anera ijare ari naka urana kuae, Josofu e Devidido uifari ige bara Meri a abekiro jumemo ije fu bakino abene. Ro e ije fu fudiema ije fu Kavene Akae ijadufuo daro ijia fudiedo fu ame fari bietekuma a ive ina Jesu kuake. Ijadufuo maeje fure e fuone ijiebuo ise ije bu renoejo ije karauniakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ijiege ro ire boeje bu reva ije fune izege E Ireobo fu isuibe Asaea e vua fuone vierafena kuaemo ijadufuo oe ijia vierafejamo fu kuaema fune ijiakuma riarekiro fu ije ijierei. ");
INSERT INTO bbb_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ro vua ije fu kuaema ije bu ijiege isoe, Bara kabaekua be fu baruna naebe naeno fu e fudiena ame fari be bietega bu e Imanuero kuake. (Ro ive ijadufuo maeje Godi fu noena). ");
INSERT INTO bbb_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ijadufuo Josofu fune naema suoke urina izege E Ireobo ijadufuo anera fu kuaraema ijiege fune bara Meri abei. ");
INSERT INTO bbb_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Fu abe rove fu naebe fuosiki besu naekoga fu vakuma ame fuone amure ije biete. Fu bietemoga Josofu fu abe ive ina Jesu kuae. ");
INSERT INTO bbb_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ro maza ije bu Jesu are Betirieme sakae Judia guove ijia bieteva ijia fu e Erodire e ireobo rena aesakae ije samuamo. Ijiege rekoga rade e bino bu are mazani ajiamo nake ijia ruoma Jerusareme usiae. Ro e ije ruaeva ije bu karina zuvi ijia nuga sumiki bino rerevo ijiebe ruae. ");
INSERT INTO bbb_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bu usiaena e ije kiae, Ame iseke ije fu rade e Jiusibuo e ireobo redufuo ije bu izia bietei? No nuga fuone sumiki be ire zuvi ijare are mazani ajiamo nake ajia romo no gae. Ijadufuo no fuone baname isoena kuri tuakafakuae ruaevano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Bu ijiege kuarianoejoga e Erodikiro e boeje sidove Jerusareme guove ijia kariva bu vua ije fievo buka ireobo defarudiae. ");
INSERT INTO bbb_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ijadufuo Erodi fune urina e Godido zinone ifaejevo ijiebuo e mamekanu ijiakina e vua akae nijasiavo ije kumevo bu una besu afui. Bu afuivoga fu kiae, E ije Godi fu kuaga fu ruakono kuaeva ije ja vierafega bu are izia ijia bietevano kiae? ");
INSERT INTO bbb_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Fu ijiege kuariamoga bu kua, Godido buki akae bu isuibe isoeva ijia fu kuae, Ame ije bu are Betirieme sakae Judia guove igia bieteke. Ijadufuo maeje Maeka e Godido vua vierafena kuaemo ije fu ijiege isoena kuae, ");
INSERT INTO bbb_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Aesakae Judia guove ijia sidove mamekanu gue bu kariva ijiebuo uve ijia sidove Betirieme aeje aka sidove ma isekube baki. Ijadufuo maeje rade are ame fari be sidove ijia nafeke. A ame ije nafega fure rade E Ireobo rena e Isureroko none boeje samuagiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Bu ijiege kuaravoga Erodi fune e ije zuvi ijia nuga rerevo ije ruaeva ijene kiavo bu mauike kaenamia are fuone ijia vae. Bu vakoga fu urina maza ije bu veze zuvi ije fu ajiamo bu gaeva ijadufuo kuariae. ");
INSERT INTO bbb_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Fu kuariama areme uri kiae, Nine va ame ije mukoreigia rerenoena gakuva nika migegire una ro na kuariefo. Ja kuariega nadua va fu kuri tuakafana fuone baname isoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Erodi fu ijiege kuariamoga bune vakuae vakuma vame gafia una kuke zuvi besu ije bu are maza ajiamo nake fu ajiamo bu gaeva ijene gae. Zuvi ije fu ude vakoke bu gakinu nuvena vakuma ka are ije ame fu namo ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Bu usiaena zuvi ije manino ijene gavo buka ma urukeigia oemadiae. ");
INSERT INTO bbb_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Areme bune aru va gake ame ije fu asiefuo Meriki ijia kariva bu giae. Bu aru gia areme uri fuone augesana baname isoe. Areme bune uri kamui buone ijia ire gorodikina ire udi mukore urimo inokiro bu kua firenikisenisi ro meno kuavo ijene kena ame ije vajae. ");
INSERT INTO bbb_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Areme bune naoeva ijia Godi fu naka ijia urana kiae, Jade una Erodi fino ijia vakuva vano kiamoga bune urina vame be ijane una are buone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ijiege rena e zuvi davo ije bune una vakoga Josofu fu naemaga E Ireobo ijadufuo anera ijare arina naka urana kuarae. Fu kua, Ni migegire urina ame guraejiakiro asiefuo ijene kaenamiana uri kona va gamia are Ijifiti figa nare kuaga a una rone. Ijadufuo maeje e ireobo Erodi aesakae samuamo ije fu ame ije kanakiro rerenoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ijadufuo Josofu fune ve ufirema ijia urina ame ijiakiro asie fuone ije kaenamiana bune Ijifiti vae. ");
INSERT INTO bbb_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Bune va ijia karinoekoga e Erodi fune fi vakuma baronei. Ro ije bu ijiege reva ije bu izege Osia e Godido vua vierafena kuaemo fu isuibe kuaema ijiakuma riarekiro bu ije ijiege rei. Ro vua ije fu kuaema ije bu ijiege isoe, Na e ije bu aesakae Ijifiti guove ijia kariva ije uve ijia ame Fari none ije kumevo fu keke ruae. ");
INSERT INTO bbb_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Areme rade Erodi fu vierafega e ije zuvi ijia nuga rerevo ije buka fu biesirivaga fu urukeigia defarui. Ijadufuo fune urina e bijaevo fuone boeje kiae, Ni va are Betirieme ijia ame fari isesina juaevasia besu ro inokiro furiva boeje kaniafo. Ro kuke ni va are isesina Betirieme ivuake ijia ro juare bu meva ijia oenoekinu ame isesina boeje kania furino kiae. Ijadufuo maeje bune e ije ruaeva ijiebe zuvi ije fu veze manina sanamo bu gaeva ije kuaraeva ijadufuo fu ame ijieki ije kaniano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ro ije bu ijiege reva ije bu izege Jerimaea e Godido vua vierafena kuaemo fu isuibe kuaema ijiakuma riarekiro bu ije ijiege rei. Ro vua ije fu kuaema ije bu ijiege isoe, ");
INSERT INTO bbb_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Are Rama guove ijia e be nimeno na fie ro e ijeja bara Reserore anafa fuone ijiebuo nimene. Rove fu erare ifejakuma baki ijadufuo maeje ame boeje bune oe furivano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Areme e Erodi fune baronekoga E Ireobo ijadufuo anera ije fune una Ijifiti ijia arina Josofu naka urana ijiege kuarae. ");
INSERT INTO bbb_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Fu kua, Nine ame ijiakiro asiefuo ije kaenamiana una urina are Isurero ijia vane. Ijadufuo maeje e ije bu ame ije kanakuae rerenoejo ije bune oe furivano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ijadufuo Josofu fune ame ijiakiro asie fuone ije kaenamiana una urina Isurero ajia vae. ");
INSERT INTO bbb_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","23","Fu una Judia ijia fikiro vako ijia fu e Akerasi fu asoefuo Erodido are ije abena e ireobo rena aesakae Judia samuamo fu ije fie. Fu ije fiena fuka ireobo jumemoga E Ireobo ijadufuo anera ije fu una arina Josofu izege fu redufuo boeje funeka naka ijia urana kuarae. Ijadufuo fu are Judia fu ijia arena va Nasareti aesakae Gareri ijia are fuone sana ijia fi. Ro ijiege fu rema ije fu izege e Godido vua vierafena kuaemo fu kuaema ijiakuma riarekiro fu ije ijiege rei. Ro vua ije fu kuaema bu ijiege isoe, E ije Godi fu kuaga fu ruadufuo ije fu e are Nasaretikono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Areme maza ijia Joni e do ruoriamo ije fu sakae Judia guove ae sao ijia uri zinuivena e ije bu fuone ruovo ije vua nijasiae. ");
INSERT INTO bbb_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Fu vua nijasianoekinu e ije kuariana kiae, Vame jone ka ise ije ja mumaza renoejo ije arekiro una vame ma ijia kenoefo. Ijadufuo maeje maza ije Godi fu e fuone ijiebuo oe ije samuagiadufuo ije funeka ivuake igifurekino kiae. ");
INSERT INTO bbb_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ro Joni ijiege fu kuaema ije fu Asaea e Godido vua vierafena kuaemo ijare fuefuo isuibe ijiege kuae, E be fu ae sao ijia fina kumei, E Ireobo ijadufuo vame ije mukoreigia urari amaerina samuaga fu rono kume. ");
INSERT INTO bbb_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ro e Joni sinuome fuone fu samo ije fu fanu kamero u ijia amaeriae ro madare fuone ije fu kuke fanu suri ijia amaeri. Ro ire fuone fu ino ije fu mutuekiro muni vi ije ino. ");
INSERT INTO bbb_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Joni fu ijiege renoenoga e boeje are Jerusareme kariva abero aesakae Judia kariva ije bu biona fuone ruae. Bu ijiege rekoga e are isesina do Jodeni irifo ijia kariva ije bu vua fu kuaemo ije fiekuae ruae. ");
INSERT INTO bbb_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Bu biona ruakinu ise buone ije Joni kuarakoga fu kaenamiana do Jodeni ijia do ruoriae. ");
INSERT INTO bbb_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ro una e Feresi ijiakiro e Sejusi uruvana bu do ruekuae fuone rovoga fu giana uri kiae, E gare ka isema vierafenoekinu aroekaranoejo garie, Jaja vierafero jane ma renoedo Godi fube rade ja kame isekafiakiro ja ijiege vierafe. Jone izege ja e biesirianoekinu aroekaravo ije arefo. ");
INSERT INTO bbb_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ro ni una dasuna mukoreigia kenoega e bu vierafero ja ise jone ja kenoejo ije jane arevaro bu ijiege vierafefo. ");
INSERT INTO bbb_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ro jade kuaeko nono asae nuvuone Eburamedo uifarido Godi fube ijuoegafiakiro ijiege kuaevo. Rove igia fie, Godi fu e darokido fu mune gure kena una e Eburamedo anafa amaeriaga bure ae jone abekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Joni fu ijiege kuariana uri vua be ijiege mena kuariae. Fu kia, E bu ine bino bu naebe fo kiraga bu giavo ije buka dudone kame buvuana atasena miane ifaejevo. Ijiege ro jadua ja vame maeje ja naebe kenoekuva Godi fu ja kame miane ije naeno ijia korega ja ijia naoke. ");
INSERT INTO bbb_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ro eranebe ja vame ise jone boeje ja renoevo ije jane areva ije na kaenamia do ijia ja ruoriake. Ro E Ije fu rade nuvedie ruomo fu ruakuma fure kadure boeje oe jone ijia naovo ije kanana miane ifaejeke. Areme fu Kavene Akae ije abena ja nujaejiake. Fure fu ma e anuigi ro naeje na e anuigi baki. Ijadufuo nana naebe manido na dia suri fuone fu saema ije azojadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","E ije fu rade ruakuma fure e ige ja kame atake. Fu kame atana erarebe bu vame ise ije arena una vame ma ijia kenoevo ije fu kena be uniake. Ro erarebe ja vame ise ijia kenoejo ije fu kena una miane ije maza boeje naena vako ijia korekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Areme ve ije Joni fu ijiege renoeno ijia Jesu fu are Gareri ijia urina vakuma do Jodeni Joni fu e do ruoriamo ijia kekei. Fu vierafe Jonire fu do ruorakiro fu ijadufuo vae. ");
INSERT INTO bbb_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Fu vakoga Joni fu urina kuae, Nana a do ruoradufuo ije na vierafe fuka naebe mare ro na vierafe are na do ruorieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Fu ijiege kuaramoga Jesu fu kua, Ije ane ma kuae rove na vierafe abe arekiro a na do ruorieke. No ijiege rekina no maza boeje irere Godi fu kuaruomo ije bino nobe ijuonekiro noka maza boeje fu irinana renoekono kuae. Ijadufuo Joni fu vierafega fune magana fu uri Jesu do ruorae. ");
INSERT INTO bbb_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Areme Jesu fune do ije arena ajia ruomo ijia Godi fu saove ijadufuo viene daovekoga Kavene fuone fu ume tuvuaeki igege arina Jesudo nigofo ijia kunae. ");
INSERT INTO bbb_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Areme bu fieke vua be saove gufia kumei, E ije fuka Fari none na oetuavo ijene. Na vame fuone fu kenoeno ije na gaga fuka oemadiemono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Areme ve ijia Godido Kavene ije fune uri Jesu mesirina dabe ae sao ijia vakoga Setani fu biesiri. ");
INSERT INTO bbb_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesu fu va ae sao ijia ire atona oenoeko muge ro maza foti (40) ijiege furikoga funeka vasia oe. ");
INSERT INTO bbb_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Fu vasia oema ijia Setani fu kekena kuae, A ma Godido farikuma ni urina mune gure naovo ije kiaga bu una ire rega a ino kuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Fu ijiege kuamoga Jesu fu una kuae, Isuibe Godido vua bu buki akae ijia isoeva ije fu ijiege kuae, Barubara bube maza boeje ire ijiaru inoekiro buka Godido vua ije vierafena renoeke. ");
INSERT INTO bbb_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jesu fu ijiege kuaramoga Setani fune una kuke mesirina are sidove Jerusareme ijia vae. Fu mesirina vakuma are ireobo bu baname isoevo ijadufuo kubi gafia nujae. ");
INSERT INTO bbb_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Areme Setani fune uri Jesu kuae, A ma Godido farikuma ni ijia manina umakoena sakaedo gamia arine. Ijadufuo maeje isuibe buki akae ijia bu ijiege isoe, Godire anera fuone boeje kiaga bure a samuagake. Ro a umakoekuma bure dabena ari vakuma sakaedo ijia nujakuva abe arina oe kananamike. Ro kuke dia one ije abe kena mune ijia kaniatuasekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Fu ijiege kuaramoga Jesu fu una kuae, Godido vua bu isuibe isoeva ijia fu kuke ijiege kuae, Jade E Ireobo Godi jone maeje abe biesirivono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Areme Setani fune una kuke Jesu mesirina uruo ma kabo ijia ajia vae. Bu ijia ajia usiaena Setani fune uri are irore boege Jesu nijae areme kuke uri ire ni mukore boeje sakae ijia naovo ijene nijae. ");
INSERT INTO bbb_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Fu ijiege nijaema areme uri kuae, Kame ijia gane. A ivia igia na augesana baname isoekuma na ire boeje a giaema ije una a vajakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Areme Jesu fu una gue kuae, Setani garege vane. Ijadufuo maeje vua ije bune isuibe buki akae ijia isoena kuae, Janika E Ireobo Godi jone ma ijiaru fuosukua baname isoekiro jade una e gue iriniavono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Areme Setani fune ijia arena vakoga anera ijiebe arina Jesu ifejakinu samuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ijiege rena rade Jesu fu fieke Joni bune dabe dibure nujaeva fiena fune una urina are Gareri ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Fu va Nasareti keke rove fu naebe ijia finoe ro fu nana va are Kafoniamu ijia fi. Ro are ije fu do Gareri nafuema ivuake ijia ro fu are Zeburunekiro Nafetari guove ijia. ");
INSERT INTO bbb_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ro Jesu ije fu uri vaema ije fune izege Asaea e Godido vua vierafena kuaemo fu isuibe kuaema ijiakuma riarekiro fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ro vua ije fu kuaema ije bu ijiege isoe, E aesakae Zeburunekiro Nafetaribuo uifari ije bu do Jodeni gara vame ije davaeneke vaema irifo ijia kari. Ro e ijiebuo aesakae ije bu kua Garerino kuavo ro aesakae ije e Jiusi baki ije buka uruvana ijia kari. ");
INSERT INTO bbb_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","E ije bu vame ise titutema ijia karinoeva ije bu E Ireobo ijadufuo sanaema fuone anuigi ije bune gae. Ro kuke e ije bu vame ise titutema ijia kenoeko kavene buone buneka oekuvejo ije budua bu sanaema ije bune gaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Areme maza ijia Jesu fune uri zinuivena e ije vua nijasiae. Fu nijasiakinu kiae, Maza ije Godi fu oe jone ije samuagiadufuo ije funeka ivuareme. Ijadufuo oe ije ja ire ise binobino ume igadufuo vierafevo ije aregana una oe kuderiana Godido ruano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Areme maza be Jesu fu do Gareri daturako nafuema irifo ijia oenoene. Fu oenoeno ijia fu e kimae savo inokiro ino iviegi e Saemoni e ije bu kuke kua Fitano kuavo ijiakiro uvia fuone e Aduru ije biediae. Ro e inokiro ije bu ugie buone ije kena kijume okurianoeve. ");
INSERT INTO bbb_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu fu biediana kiae, Ni ire ije ja renoejo ije aregaro na nuvediefo. Ja na nuvediega na kijume ije ja karavo ijiege vame nijasiaga ja e kaenamiano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Fu ijiege kuariamoga bu naebe itire fuone abe akoe ro bume saroruba uri ugie buone ijene ijia arena uri fu nuve vae. ");
INSERT INTO bbb_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jesu fune kaenamiana vakuma una kuke ino iviegi e Jemisikiro Joni e Zebedido anafa ije giae. E inokiro ije bu asoe buone Zebedina vanage ijia karina ugie buone ije amaeriave. ");
INSERT INTO bbb_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Bu ijiege revo ijia Jesu fu kumenoga e inokiro ije bune migegire uri vanage buone ijiakiro asoe buone ije ijia arena ari Jesuna vae. ");
INSERT INTO bbb_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Areme Jesu fune ve ijia urina are Gareri guove ijia are isesina e Jiusi bu afuina vua kuaevo ijia aruna oenoekinu vua nijasianoe. Fu vua nijasianoekinu e boeje vua maeje Godi fu izege oe buone ije samuagiadufuo ijene kuarianoe. Fu ijiege renoekinu kuke e iseki boeje adame abekinu ro aekirariaeva ije karauniae. ");
INSERT INTO bbb_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Fu ijiege renoekoga e bu vua fuone ije dabe kuaena are Siria guove ijia oenoe. Ijadufuo e boeje ijia kariva ije bu vua ije fiena uri e adame ise binobino abevo ijiakina e vajae fiane ro kavene ise urasiaeva ro e ije bu itire sabaekiravo ijene kaenamiana fuone ruae. Bu kuke e vajae garadiaeva ije kaenamiana rovoga fu amaeriamo bu una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Fu ijiege renoenoga e ka uruvana bu uri fu nuvena dabe arafiri vae. E are Gareriko ije abero e sidove teni (10) guove ijia kariva ijiebe uri fu nuve vae. Ro kuke e sidove Jerusareme ijia kariva ijiakina e aesakae Judia kariva ijene ro e do Jodeni gara kariva uruvana ijiebe uri fu dabe arafiri vae. ");
INSERT INTO bbb_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","2","Areme maza be Jesu fu giake e uruvana bu fuone rovoga fu urina uruo ijia ajia vae. Fu ijia ajia vakoga e vua fuone fievo bu nuve ijia usiaena kari ufuaenoena arekoga fu uri zinuivena vua nijasiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Jesu fu vua nijasiana kiae, Erarebe bu Godido vierafe ijia kenoekuvega buka naebe manivo ije buka oemaredufuo. Ijadufuo maeje bu e ijieki ijiebe e ije Godi fu oe buone ijia samuagiamo ijena mazieke. ");
INSERT INTO bbb_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ro erarebe bu maza boeje ise buone ijiakiro e guebuo ise ijiebuo oefiane abenoejo e ije buka oemaredufuo. Ijadufuo maeje e ijiege renoejo ije Godire rade oefiane buone ije dasumiaga nido ije bu abenoejo ije bu areke. ");
INSERT INTO bbb_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ro erarebe bu maza boeje Godido nidua ijia kabuaekabuaeki karinoejo ije buka oemaredufuo. Ijadufuo maeje e ijieki ije Godi fu rade ire maeje fu vajiako kiaema ije kena vajiake. ");
INSERT INTO bbb_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ro erarebe bu maza boeje oe buone ijiakuma Godi irere fu vierafejiamo ijiaru irinana kenoekuae vierafenoejo ije buka ireobo oemaredufuo. Ijadufuo maeje e ijiege vierafenoejo ije Godire ire boeje niduaejiake bume maza boeje ijia oemarekinu karivake. ");
INSERT INTO bbb_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ro erarebe bu maza boeje una e gue vierafenoekinu buone oefiane abena ifejianoejo ije buka ireobo oemaredufuo. Ijadufuo maeje e ijiege renoejo ije Godire ve una buone oefiane abena ifejiake. ");
INSERT INTO bbb_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ro erarebe maza boeje oe buone buka maturaeva ije buka ireobo oemaredufuo. Ijadufuo maeje e ijieki ije bure Godi gake. ");
INSERT INTO bbb_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ro erarebe bu maza boeje e ume igia kariva ije vame kafaevo ije abe nijasiaga bu kafae karijo ije buka ireobo oemaredufuo. Ijadufuo maeje e ijiege renoejo ije Godire kena una anafa fuone reke. ");
INSERT INTO bbb_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ro erarebe bu maza boeje irere Godi fu vierafejiamo ijiaru kenoeko e buka vua ise buesina kuaekinu kame vame ise bu isejavaedufuo ijia renoevo ije buka ireobo oemaredufuo. Ijadufuo maeje bu ijiege isejavaenoejo ije bu e ije Godi fu oe buone ijia samuagiamo ijena besu mazieke. ");
INSERT INTO bbb_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ro kuke jadua jane una makae none ijia nuvedievo ijadufuo e buka vua ise joesina kuaekinu kame vame ise ijia arafiriake. Bu ijiege rega jaka vajae fiane abena isejavaedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ro bu ijiege rekuva nika urukeigia oemarefo. Ijadufuo maeje Godi fune ve gue ire maeje boeje joefuo saove ijia kanafuido ja ije kedufuo. Ro igia fie isuibe e Godido vua vierafena kuaevo ije e bu vame besu ijiege bu kame isekafiaevano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jesu fu vua ijiege kuaria vakuma uri vua be ijiege mena kuariae. Fu kia, Erarebe ja na nuvedievo ije ja e ume igia oenoeva ijiebuo soru ije bu ire sa iga fu madiavo igeki. E bu soru abe ire sa ikuva mariene ije fuka mukore. Ro soru mariene fuone ije fu bakirekuma ije fune ma bakido bu dabe akoega e bu ado ijia utanoeke. Ijiege ro ja na nuvedienoega fuka aemiaga ja ijia arekuva ije i ja noefuo menoejo ije funeka mukoe furidufuo. ");
INSERT INTO bbb_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ro kuke erarebe ja na nuvedievo ije jaeje ja e aesakae igia kariva ijiebuo raete igeki. Izege e bu sidove be uruo makave ijia kariva ijadufuo raete ije samadukua giavo ijiegero e buka raete jone ije giake. ");
INSERT INTO bbb_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ro kuke igia fie. Fu erare raete abe sanana nuriekuma baki ro buka abe samadukua nija fu sanake e bu ijia gakinu karike. ");
INSERT INTO bbb_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Vame besu ijiege ro ja uri vame none maeje na nijasiaeva ijene kenoekinu karivaga e bu ijia giafo. Bu vame maeje ja kenoevo ije giana una Asoe jone saove gufia fino ije dabe aroeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jesu fu ijiege kuaria vakuma areme kiae, Ja na ruaeva ije jade oe isema vierafevo. Jade vierafero na akae isuiko ijiakiro e Godido vua vierafena kuaevo ijiebuo vua bu isuibe isoeva ja giakinu karivo na ije kuriaerega ja arekiro na ijadufuo ruaevaro jade ijiege kuaevo. Ro na ruaeva ije name vua buone bu isoena nijasiaeva ijiebuo maeje rega fuka ijiakuma riaredufuo. ");
INSERT INTO bbb_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Naka ma kuariavo igia fiefo. Na sakae igiakiro saove ije bu uria naovo ijia na vierafe nabe vua akae ijiakiro vua bu isuibe isoeva ije besukua be asike. Ro na vierafe naka ire boeje bu isuibe kuae ruaeva ijiebuo maeje besubesu renoga buka ijiakuma riaredufuo. ");
INSERT INTO bbb_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ijadufuo erare akae boeje bu isoeva ijia akae isekube be naebe irinakinu una kairafa gue nijasiaga budua ijiege revo e ije fuka naebe mareme. Ijadufuo fu rade baronemo ijia fu e ije Godi fu oe buone ije samuagiamo ijia fube e anuigi reke. Ro erarebe bu akae boeje iriniakinu una kairafa gue nijasiaga budua ijiege revo ije fune mukoe renoene. Ijadufuo fu baronekuma fu e ije Godi fu oe buone ije samuagiamo ijiebuo uvia fuka e anuigi reke. ");
INSERT INTO bbb_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ijadufuo igia fie. E be erare e akae nijasiavo ijiakiro e Feresi ijiebuo vame bu kenoevo ije fu naebe asidiana mukoreigia kenoeno e ije fuka naebe manido fu e ije Godi fu oe buone ijia samuagiamo ijena mazieke. ");
INSERT INTO bbb_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesu fu vua ijiege kuaria areme uri kiae, E ije bu akae nijasiavo bu kuae, Jade e kania bu oevono kuaeva ije jane fie. Ijadufuo erare e kana fu baronemo e ije bu mesiri koto rena dabe isekafadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Rove na kuariako ni fiefo. Erare fu uvia fuone ije ziegafamo ije bu kuke mesiri koto rena dabe isekafadufuo. Ro kuke erare fu uvia fuone be kuako aka e omiseno kuamo, e ije bu mesiri dabe e mamekanu sosi akae samuavo ijiebuo vaga bu dabe isekafadufuo. Ro erare fu uvia fuone be kuako aka mukoe kemo bakino kuamo e ije fune korufuo vame amaerina are ise miane naeno ijia vake. ");
INSERT INTO bbb_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ijadufuo ro ja ire bino kena Godido are guove fata ijia zinone ifaejakuae vako ijia ni mukore vierafedufuo. A vierafega kai one be fu osiki zienamivoga ni ire a kena vako ije fata ivuake ijia naeme una migegire kekena vane. Ni una va kai one ije fuosiki kafaena oemare areme ni una zinone one ije kena Godi ifaejane. ");
INSERT INTO bbb_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ro igia fie a kai one be fuone ire ise be rema fu ijadufuo a mesira koto rekiro vierafekuma ni uria ije ja naebe e koto fiemo ije fino ijia usiaeva ijia ni migegire una fuosiki vua ije kuae irasena umui runamifo. Ro bakuma fu a mesirana dabe e koto fiemo ije fuone vaga a nidua fuone ijia vua one ije kuaeke. A kuaega fu vua one ije fiema areme fu una forisi kiaga bu a dabe dibuore nujake. ");
INSERT INTO bbb_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ro kuke igia fie bu a dabe dibure nuja a ijia fikinu moni izege bu kuaeva ijene fuaeve furina ijare a sone una kekekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesu fu ijiege kuaria areme kiae, E ije bu akae nijasiavo bu kuae, Jade ebuo bara turavono kuaeva ije jane fie. ");
INSERT INTO bbb_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Rove na kuariako ni fiefo. E be erare bara be gana fume mauike oe fuone ijia bara ijiaki naekiro ijiege vierafemo e ije fune bara ijiaki naeno igeki ijadufuo fune ise reme. ");
INSERT INTO bbb_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ijadufuo a vierafega niome one maeneke besu ijare rekoke a ise revoga ni fare nafe akoene. Fu niome one besu ijare ise rena vajae one boeje aguake fune dabe are ise miane naeno ijia akoekuvedo a ijiege rekuma ije funeka mareke. ");
INSERT INTO bbb_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ro kuke a vierafega umui one maeneke besu ijare ire ise faradiakoke a ise revoga ni ufu akoene. Fu umui one besu ijare ise rena vajae one ije aguake fune dabe are ise miane naeno ijia akoekuvedo a ijiege rekuma fuka marekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Ro kuke akae be bu isuibe isoeva ije fu kuae, Erare bara fuone be abena ro rade fu rorukurakiro vierafekuma fuka fefa isekube ijadufuo isoe mano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Rove na kuariako ni fiefo. E be erare fu bara be abe rove bara ije fu ebuo baru turamo ijadufuo fu rorukurakuma ije fune mare. Ro bara ije fu naebe ebuo baru turae ro baru fuone fume rorukuraga fu una va baru be manikuma bara ije fune ise rena ebuo baru turame. Ro baru erare fu una va bara ije bu abena abueva ije abeno ije fune ise rena ebuo bara turamono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Ro kuke akae be bu isuibe isoeva ije fu kuae, Ja Godido ive ijia kurana vua kuaekuva jade arevo ro nika irere ja kuaeva ije ka reno kuaeva jane fie. ");
INSERT INTO bbb_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","35","Rove na kuariako ni fiefo, Ja vua ijiege kuaenoekuva jade ire bino ijia kurariana vua kuaevo. Jade saove gufadufuo ive ro ume igadufuo ire binobuo ijiebuo ive ijia kuriana vua kuaevo. Ijadufuo maeje saove gufe Godi fu ijia fino ro ume ige dia fuone ije fu igia kore fino. Ro kuke jade sidove Jerusareme ive ijia kuravo ijadufuo maeje sidove ije fu Godi Kini ka anuigi ijadufuo are. ");
INSERT INTO bbb_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ro kuke jade nigofo jone ijia kanakanakinu kuaevo ijadufuo maeje ja daro bakido ja izege nigofo u jone kiaga bu abaeki ro kazine tavuadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ijadufuo ro a vua kuaega e bu kua vua ije abe ma kuaemono kuakuva ni keno kiane. Ro a vierafega a kufuimevoga ni bakino kiane. Ro a fena una kuke vua bino ubine ijia vierafena kuaemo ijeja a Setanire vierafejaga a ije dabe kuaemono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jesu fu ijiege kuaria areme kiae, E ije bu vua akae nijasiavo bu kuariana kia, Ja e be fu one ise rega ni ase una vegue ise reno kuaeva ije jane fie. ");
INSERT INTO bbb_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Rove na kuariako ni fiefo, e bino bu jone ise rekuva jade una vegue ise revo. Ijadufuo e be erare fu keke anogo one maeneke ijia kanakuma ni areke fu una kuke gue kanane. ");
INSERT INTO bbb_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ro kuke fu seti one a moni isekube ijia fuaevema ije abekiro fu uri a mesira dabe koto rekuma ni kuke ugone one maeje a ado abiemo a moni ireobo fuaevema ije abe mane. ");
INSERT INTO bbb_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ro kuke ebe fu a kuriaerena kuako, Ine none gure abe ivuake gafia mieno kuakuma ni abena biona va mumabo ijia mane. ");
INSERT INTO bbb_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ro e be fu ro ire binofuo kuakuma ni zinune abe mane. Ro fu kuako ire one ije mie na vaekina una abe mano kuakuma ni oemarekinu abe maga fu vane. ");
INSERT INTO bbb_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesu fu ijiege kuaria areme kiae, E ije bu vua akae nijasiavo bu kuariana kia, Kairafa jone ma ijiaru oetuakiro e ani jone ije ka ziegafiano kuaeva ije jane fie. ");
INSERT INTO bbb_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Rove na kuariako ni fiefo, E ani jone ije mukoreigia oetuaro e ije bu jone ise rekinu vajae fiane vajiavo ije ni buone baname isoefo. ");
INSERT INTO bbb_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ja ijiege rekina ja una Godi Asoe jone saove gufia fino ijadufuo anafa redufuo. Ijadufuo maeje fure mazani ije kuaga fu e ise ro ma ije oenoevo ijiebuo sanaejiako bu oenoeve. Ro kuke fu ve ije kuaga fu e ise ro ma renoevo ijiebuo dame. ");
INSERT INTO bbb_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ro ja uri e ije bu ja oetuavo ijiaru oetuakuva ije Godi fu irerefuo vame maeje bino jone rejiake? Vame ije bu e ise takesi abenoejo ijiebe ijiege kenoejo. ");
INSERT INTO bbb_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ro ja uri kairafa jone ja vierafeva ijiaru anadiavo ije ja vame mukore sumiki bino kena una e gue nijasiavo baki. Ro vame ijiege kenoevo ije bu e ije Godi ma vierafeva baki ijiebe ijiege renoevo. ");
INSERT INTO bbb_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ijadufuo jadua nika maturaena vame ma ijiaru kenoefo. Ijadufuo maeje Asoe jone saove gufia fino ije fuka maturaema ijadufuo jadua nika ijiege mukoreigia e gue oetuakinu karinoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesu fu ijiege kuaria areme kiae, Ja i jone maeje ja menoejo ijia jade vierafero are bu ebe kame aroruoro urina e niome ijia aroekaravo. Ro ja ijiege kenoekuva Godi Asoe jone saove gufia fino ije fube vame ma bino jone reke. ");
INSERT INTO bbb_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ijadufuo ja e ire baki ije ire bino vajiakuva jade aroekarana e niome ijia vajiavo. Ro ja ifejiakuae vierafekuva ni mauike sauina ifejiafo. Ro jade uri e ije bu vame ijia ro are e bu afuivo ijia vua ijia marenoejo ije matiavo. E ijiege renoejo ije bu kuae, Are e gariebe no kame aroruoro bu ijadufuo ijiege renoeve. Rove na ige kuariako fiefo. E ijiege renoevo ije bune ema ijiebe sibane ijifureki aroriave. Ijadufuo Godi fu irerefuo una ve vame ma bino e ijieki ijiebuo rejiake. ");
INSERT INTO bbb_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ro ja oenoene e iseki ijieki ije ifejiakuva ije nika sauina ifejiaekina kairafa jaena besu oenoejo ije bu irere ja revo ije bube giana vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ja mauike ijiege sauina renoekina Godi Asoe jone fu vame sauiki ja revo ije giakuma fu rade ve ijadufuo vame ma bino jone rejiano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesu fu ijiege kuaria areme kiae, Ja oenoene Godido baname isoekuva jade e iti kufuiki ije matiana buenina baname isoevo. Bu maza boeje Godido are ijia aruna vierafero are ebe fiejuoro buka uri arire irena baname jiamadogo isoevo. Ro kuke buka usiae makave ijia ijiege vierafenoekinu baname isoenoeve. Rove na kuariako ni fiefo, e ije ijiege renoevo ije bune ema ijiebe sibane ijifureki aroriave. Ijadufuo Godi fu irerefuo rade una vame ma bino ve ijadufuo buone rejiakuma baki. ");
INSERT INTO bbb_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ijadufuo ja oenoene baname isoekuva jade buenina vako. Ro nime mauike josukua va are guove jone ijia aruna viene kame bijuna ijia karina Asoe jone ije e bu gavo baki ijadufuo baname isoefo. Ja ijiege rekina Asoe jone fu baname sauiki ije ja isoeko fu giamo ije fu vame ma bino jone rejiake. ");
INSERT INTO bbb_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Ro ja oenoene baname isoekuva jade e Godi naebe ma vierafevo ije matiana baname buone ma baki ije bu kukuma isoevo ijiege baname isoevo. Bu vierafero bu baname ijiege jiamadogo isoe Godi fuka fiekiro bu ijiege vierafe. ");
INSERT INTO bbb_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ijadufuo jade bu kevo ijiege renoevo ijadufuo maeje Asoe jone ije fu irere ja fu kuakuae vierafeva ije fune isuibe giana vierafe. ");
INSERT INTO bbb_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ro ja baname isoekuva ni ijiege isoefo. Godi Asoe nuvuone kabo gufe samuamo. No ive one Akae ije aroeke. ");
INSERT INTO bbb_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","No vierafe are ro ire boeje ume igia naovo ije samuagiadufuo. Ro kuke no vierafe izege saove gufia bu kevo ijiege e ume igia kariva ije bu vame besu ijiege kenoedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ivia ire no mumaza inoedufuo ije vajuone. ");
INSERT INTO bbb_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ro ni izege e binobuo ise ije no giana arevo ijiege ni ise nuvuone guona arene. ");
INSERT INTO bbb_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ro ade no kena una vame ise ijia biesiruomo. Ro kuke ni ifejuoga no ire ise ije Setani fu kena vame nuvuone arafiruomo ijia akariakinu oenoene. ");
INSERT INTO bbb_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesu fu ijiege baname isoe nijasiama areme kiae, Ja ebe ise bino jone rega ja giana arekuva Godi Asoe jone kabo gufia fino ije fudua ise jone fu giana areke. ");
INSERT INTO bbb_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ro ja ebuo ise ije ja naebe giana arekuva Godi Asoe jone kabo gufia fino ije fu ise jone ja reva ije fube giana arekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Fu ijiege kuaria areme kiae, Ja oenoene ire bino atokuae vierafekuva jade uri e iti kufuiki bu kenoevo ijiege kevo. Bu kuae are e guebe giakuae bu usiae e niome ijia buka vasia abeva igege oenoeve. Rove na ige kuariako fiefo. Bu ijiege renoevo ije bune ema ijiebe sibane ijifure giana aroriave. Ijadufuo Godi fu irerefuo una bu kame aroriakuma baki. ");
INSERT INTO bbb_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Ijadufuo ja ire bino ijiege atokuva nime dazena do ruena nige bijama oemarekinu oenoefo. Ja ijiege rekina e gue bube ire ije ja atonoejo ije giana vierafedufuo. Ro fune Godi Asoe jone kabo gufia fino ijare fuosukua vame ije ja josukua mauike vierafena renoejo ije giakuma fu ire ma bino jone redufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ro kuke igia fie, jade ume igadufuo sinuome ro moni uruvana zaraena karivo. Ijadufuo maeje sinuome mukore boeje rade buka burae ro ire faruaebe ufusekinu ziribijiake ro kuke buka e iniekibe iniemejiake. ");
INSERT INTO bbb_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ijadufuo sinuome ume igadufuo ja uruke vierafevo ije arekiro nika una saove gufadufuo sinuome ijiebe uruke vierafekinu ijadufuo imefo. Sinuome ije bu ire faruae bube ufuse ro kuke bube ziribijiana isereke. Ro kuke e inieki bube aruna iniemero burae ro faraena isereke. ");
INSERT INTO bbb_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ijadufuo maza boeje nika ire jone maeje bu izia naovo ije oe jone nika ijia nadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Ro kuke igia fie, niome jone ije fu vajae jone foteke ijadufuo raete igeki. Ijadufuo niome jone ije fu makuma vajae jone boeje fu mukoe sanadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ro niome jone fu ise ije ja vierafevo ijare okurakuma vajae jone foteke fuka titutedufuo. Ijadufuo vajae jone foteke ijadufuo sanaema fu vafaekuma ije funeka mukoe titutedo ja izege una giriesana vame maeje ja abedufuo ije rerekuva baki. ");
INSERT INTO bbb_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Ro kuke igia fie e besu fu izege uri oe fuone boeje ijiakuma e mamekanu inokiro ijiebuo imekuma baki. Ro fu imekuma ije fu e be fuka mukoe oetuagaro una be ije fube mukoe ifejake. Ro kuke maza boeje e be ije fuka mukoreigia fuefuo imekinu irinake ro una e be ije fume nikatene ganoeke. Ijadufuo ja ume igadufuo sinuome ijiakiro moni ije uruke oetuakinu vierafekuva ije ja izege una mukoreigia Godi irinana maza boeje fuefuo imekuva baki. ");
INSERT INTO bbb_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ijadufuo na ige kuariako ni mukoe fiefo. Jade maza boeje uri vajae surive ijadufuo ire ro do ja i ro ugone ja sadufuo ije uruke vierafenoejo. Ijadufuo maeje ire ijiakiro sinuome ije bu anuigi baki. Ro vajae jone ijiakiro jone ja karivadufuo ijare fuka ma ireobo ijadufuo ja ijare ireobo vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ro kuke nine ume gufe bu oenoejo ije giafo. Buje bu ire uije okinu ro kanafuina navo baki rove fune Asoe jone saove gufia fino ijare bu funeka mukoreigia samuagiame. Ro jaeje ja ume isesina ije Godi fu oetuamo ijieki baki ijadufuo maeje jaeje ja Godido nidua ijia jaka ma anuigi. ");
INSERT INTO bbb_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ijadufuo erare fu vajae surive ijadufuo ire ije uruke vierafenoeno ije fu izege juaevasia fuone abe bio jiamadogo nijana fivake. ");
INSERT INTO bbb_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ro kuke jade karina ugone ja sadufuo ro kedufuo ijadufuo uruke vierafevo. Ro ni kusare tarare gamia ireva ije giafo. Buje bu imena korubuo ugone buone bu savo ije amaeriavo baki rove bume ijia irena ni buone ka mukore ije irave. ");
INSERT INTO bbb_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ro igia fie, e ireobo aesakae samuamo ro ka sinuome zaraema be e Soromoni fuka ugone uruvana ni mukore binobino ije kei. Rove ugone ni mukore fuone ije bu kusare ijiebuo buone ni binobino bu iravo ijare ugone ni buone ije fuka ma asidiae. ");
INSERT INTO bbb_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ro kuke igia fie, vajoma ije bu ivia ijia irega e bu giave ro isuome bu kara ifaejevone bune naona furive. Ire vajoma ije buka ire isesina rove Godi fuka uria bu samuagiame. Ijadufuo e gure ma vierafenoejo baki gurie jaeje ja vajoma ijieki bakino oefiane ja abenoejo ije arefo. Godi ja fuka ma mukoreigia samuagiame ijadufuo jaka fu ma vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ijadufuo jade uri ire ro do ro sinuome ijiebuo kari urukeigia vierafero note izia ire boeje kekiro karina ijiege vierafevo. ");
INSERT INTO bbb_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Vame ijiege ja karina sinuome ro ire ro do ijiebuo uruke vierafenoejo ije bu e ije Godi ma vierafevo baki ijiebe ijiege revo. Ro jaeje fu Asoe jone saove gufia fino ije fu irere boeje ja kena karivadufuo ije fune ude giana vierafemo. ");
INSERT INTO bbb_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ijadufuo ni izege Godi fu oe jone ije samuagiadufuo ije ireobo vierafero vame fuone maeje fu vierafema ijare abe ude vierafena kenoefo. Ja ijiege renoekinu karinoekuva fure korufuo una kuke ire ije ja kena karivadufuo ije binodua ifejiake. ");
INSERT INTO bbb_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ijadufuo irufui isuofuo ije jade karina uruke vierafevo. Ijadufuo maeje fu Godi Asoe jone ijare irufui isuome ja abedufuo ije fure ifejiake. Ijadufuo ni sone oe vafaena irufui ije fu maza binobino ijia ruovo ije besubesu giakinu karinoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesu fu ijiege kuariana kiae, Ja e guebuo ise ije naebe giana kuaekuva Godi fube ve ise jone ije giana kiake. ");
INSERT INTO bbb_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ijadufuo maeje Godi fu vame izege ja e guebuo ise ije giana kuaevo ijiege fu ve ise jone ije giana kiake. Ro kuke vame izege ja una e gue ijiebuo ja revo Godi fu una ve ja ijiege rejiake. ");
INSERT INTO bbb_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ijadufuo a irerefuo uvia one ijadufuo kadure isekube fu niome fuone ijia namo ije gana kuagaro una kadure ireobo ije fu niome one ijia namo ije a naebe game? ");
INSERT INTO bbb_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","5","A niome one kadure ije fu uria ijia namo ije a izege una uvia one kua, Uviano ro na ni kadure guraeje vajaema ije kejano kuake. E gure ka iti kufuiki gure, ude niome one ijia kadure ireobo ije vajaema ije ke akoe fu marega ni ijare una kadure isekube ije fu uvia one ijadufuo niome ijia namo ije gana ke akoene. A niome one kadure ije a naebe ke akoekuma ade una uvia one ijadufuo ije gana kuamo. ");
INSERT INTO bbb_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Ro kuke jade Godido vua akae ije abe va e ije bu vua maeje fiekuae ijuonevo ijene kuariavo. E ije bu ire moni ige bu kena mave ije vajiavo igeki. Mave ije bu ire moni ije kena irere abedufuo ije bu vierafeva bakido bu kame utautake. Ijiege ro ja naebe mukoe giakinu vua none maeje abe va e ije bu naebe oemarekinu fiekuae vierafeva ije kuariakuva buka ijuoneke. Buka adane bijuna una vua jone bu ke kuderiana una buone vierafeva ijia kuariakinu kame kaniana arafiriakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jesu fu ijiege kuaria areme kiae, Ja ire bino vierafekuva nika Asoe jone saove gufia fino ije kuarafo. Ja kuarakuva fu irere ja kuavo ije fuka vajiake. Ro ja ire be rerekuva nika giriesa faememarena rerekuva Godi fu nijasiaga ja gake. Ro kuke ja ire bino vierafena viene fuone ijia kanakanakuva fu viene daovena ifejiake. ");
INSERT INTO bbb_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ijadufuo maeje erarebe ja Godi maza boeje ire binofuo kuavo ije ja kedufuo. Ro erarebe ja rerevo ja giake. Ro kuke erarebe ja viene ijia kanakanavo ije fu viene daovena ifejiake. ");
INSERT INTO bbb_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ro igia fie, e be erare fari fuone fu irofuo kuakuma fube una mune abe make? ");
INSERT INTO bbb_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ro fu kijume ijadufuo kuakuma fube una tabare abe make? Ije fuka ma baki. ");
INSERT INTO bbb_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Jaeje ja e ise revo rove ame jone bu ijiege ire binofuo kiakuva jaka uri ire maeje bu kiavo ije kame vajiadufuo. Ijiege ro Asoe jone saove gufia fino ije fu erarebe bu kuakuva fu ire maeje vajiake. ");
INSERT INTO bbb_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ijadufuo ire boeje binobino ja renoejo ijia ja e gue kiaga bu joefuo ire bino rejiakuva ni jase izege bu joefuo reva ijiege ve una buefuo rejiafo. Ijadufuo maeje akae ije e Mosisikiro e Godido vua vierafena kuaevo bu isuibe isoeva ije no ijiege kenokuae bu ijadufuo isoevano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jesu fu e vua fuone fievo ije vua kuariavakuma areme kiae, Ja vame maeje ma karivako ije abekuae vierafekuva ni viene iseke ijia aru vafo. ");
INSERT INTO bbb_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ro vame ije fuka ma isekube ijadufuo bu e sibaneke ijia vake. Ro vame ije are baromuna vako ije fuka ma ireobo ijadufuo e uruvana buneka ijia vakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesu fu ijiege kuariama areme kiae, Ja oenoekuva ni e iti kufuiki ije bu vua none abe kuaenoejo ije mukoe giakinu oenoefo. Bu ja kariva ijia ruovo ije buka e ma ro mukoe kenoejo igeki. Rove oe buone ijia izege bu vierafenoejo ije buka siroe kuriae igeki. Bu jone ja ma vierafevo ije kame arafiriakuae renoeve. ");
INSERT INTO bbb_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ro izege ja bu ma vierafedufuo ije ja vame buone bu kenoevo ijia giadufuo. Ro igia fie, ine dubine ije fube manina fo maeje bu ijo ije kirake? Ro kuke fiene ise mibiamibiano kuavo juare ijia irevo ije fube fo maeje e bu ijo ije kirake? Ije fuka baki. ");
INSERT INTO bbb_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Ro ine mukore ije fuka manina fo fuone ka mukore ijiaru kirake ro fube fo ise ijiakuma kirake. Ro ine ise ije fube fo ise kirakinu ro fo maeje kirake. ");
INSERT INTO bbb_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ijadufuo ine ije bu irena fo maeje naebe kiravo ije bu ufuabuena ufuse miane ifaejega fu ijia nae furike. ");
INSERT INTO bbb_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ijadufuo e iti kufuiki ije bu vua none abe kuaenoejo ije ja vame buone ije bu kenoejo ja ijia giana vierafeke. ");
INSERT INTO bbb_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Ro igia fie, e boeje bu na kie, E Ireobono kievo. Rove na vierafe e boeje buka foteke una e ije Godi fu oe buone ije samuagiamo ijia buina maziekuva baki. Ro bune e ije bu Asoe none ije saove gufia fino ijadufuo i ije fu vierafemo ije renoejo ijiebe Godido e ijena mazieke. ");
INSERT INTO bbb_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ro vakuma maza ka anuigi ijia e uruvana bu uri kieko, E Ireobo no ive one ijia Godido vua abe e kuariaevano kieke. Ro kuke bu kieko no ive one ijia kavene ise rorukuriakinu vame sumiki bino revano kieke. ");
INSERT INTO bbb_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Areme na uri samadukua kiako, E gure ka Godi irinavo baki gurie, jaeje naka naebe vierafevano garege vano kiake. ");
INSERT INTO bbb_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Ijadufuo ro igia fie, erarebe bu vua none ige mukoe fiena iriniavo ije bu e ije fu mukoe vierafekinu are fuone ije munuage ado ijia saema ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Fu munuage ado ijia are sama arekoga ve dana do firana are ije abekiro arafirikoga majaufi ireobo fu ufina are ije nijae. Rove are ije fu naebe tuana farae ro fuka girenami. Ijadufuo maeje e ije are fuone fuka munuage gikikimana ijadufuo ado ijia sae. ");
INSERT INTO bbb_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ro e boeje erarebe bu vua none ige fienaro naebe mimatavo ije bu e ije fu naebe mukoe vierafena are fuone ije abe ajare ado ijia saema ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","E ije fu are fuone ajare ado ijia sama arekoga ve majaufikuma dana uri do firae. Fu firana keke are ije bijamoga fuka tua dijena faraesena iseremano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesu fu vua boeje ijiege kuariama furinoga e boeje ijia kariva ije bu vua fuone ije fievo buka oeseradiae. ");
INSERT INTO bbb_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ijadufuo maeje fu e buone ije vua akae nijasiavo ijieki ije fu baki ro fuka e daro ireobo abema igege nijasiae. ");
INSERT INTO bbb_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Areme Jesu fune e ije fuina oenoejo ijena uruo ije arena una arina vakoga e ka uruvana bune uri fu nuve. ");
INSERT INTO bbb_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Bu ijiege nuve vako ijia e be adame tatie igeki bu kua reforasino kuavo ije abema ijare kekena Jesu vako ijia ruae. Fu keke augesana kuae, E Ireobo a oemarekuma ni vajae none ige amaerijiega na una madieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Fu ijiege kuamoga Jesu fu umui akoena farekinu kuae, Na vierafeva na amaeradakono kuae. Fu ijiege kuarakoga saroruba adame fuone reforasi ije fu bakirei. ");
INSERT INTO bbb_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Areme Jesu fu urina kua, Ade va e bino irere na one reva ije kuariakiro nime ude va e Godi zinone ifaejamo ije vajae one abe fu nijaene. Areme ni ire bino kena e Mosisido akae ije fu kuaema ijiege una Godi zinone ifaejaga e bu ijia gana vierafero adame one fune bakiremaro bu ijiege vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","6","Areme maza be Jesu fune ruoma are Kafoniamu kekemoga e Romukobuo e ireobo be ijia fino ijare kekena fu bie. Fu vierafe Jesu fuka fu ifejakiro fu ijiege vierafe. Ijadufuo fu keke Jesu dabe soesoena kuae, E Ireobo e none i meno be fu adame ireobo abena funeka vajae garena are gafia name. Ro fuka vajae fiane ireobo abena isejavaemono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Fu ijiege kuaramoga Jesu fu kuae, Ije fune maredo na vua amaeriga fu una maekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jesu fu ijiege kuaramoga e ije fu kuae, E Ireobo nana e ma bakido a are none ijia abe vuake. Ro nime itire one ijia kuaega e none i meno ije fu una maene. Na ma vierafe a vua irere itire one ijia kuaekuma ire ije fuka reke. ");
INSERT INTO bbb_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ijadufuo maeje nadua na e none mamekanu vua irere bu kuarievo na ijia kenoevo. Ro kuke e bijaevo gue bu rotire none ijia imeve. Ijadufuo na e be kuako vano kuavone fu vako ro be kua rono kuavone fu ruomo. Ro na una e none imeno be kuako ire ige reno kuavone fu remono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","E ije fu ijiege kuaramoga Jesu fu vua ijene fiemo fuka urukeigia oesere. Ijadufuo fu una dakude e ije bu fu nuve vako ije kiae, Na are Isurero guove igia e bino e ige fu ma vierafemo ijiege ma vierafevo ije naka naebe giae. ");
INSERT INTO bbb_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ro naka ma kuariavo igia fiefo. Bu e Jiusi ijiaru bakiro buka e uifari binobino are irore boegia maza ajiamo ro koeno ijia e ma vierafevo uruvana e igeki ije bu e ije Godi fu oe buone ijia samuagiamo ijena maziedufuo. Bu e Eburamekina Aesekikina Jekafu ijena buina fata ijia karina ire ike. ");
INSERT INTO bbb_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Rove e Eburamedo uifari ije bu vierafe bu e ije Godi fu oe buone ije samuagiamo ijena besu karina ire idufuo ije Godi fu rorukuriaga bu usiaeke. Bu usiaena makave titutema ijia niraena ubae sakinamikono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesu fu ijiege kuariama areme una e ije kuae, A na ma vierafema ijadufuo irere a kuariema ije na ifejakono ni una vano kuae. Jesu fu e ije ijiege kuarakoga e fuone imeno ije fu ve ijia una mae. ");
INSERT INTO bbb_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Areme Jesu fu e Fitado are ijia aru vagake Fitado jurufuo bara ije fu vajae fete maga fu ijia name. ");
INSERT INTO bbb_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Fu ijia namoga Jesu fu aruna umui kenoga vajae fete ije urimo ije fune bakire. Fu bakiremoga bara ije fu urina bu samuagiakinu ire vajiae. ");
INSERT INTO bbb_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Areme ve fune musiremoga e uruvana bune uri e ije bu kavene ise nirokiaeva ijene kaenamiana Jesudo ruae. Bu rovoga Jesu fu kavene ise ije kuriaerena rorukuriamoga bu e ije arena usiae vakinu e boeje adame abevo ije amaeradiamo bu una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jesu fu ijiege remoga vua ije Asaea e Godido vua vierafena kuaemo fu isuibe kuaema ije funeka ijiakuma riare. Ro vua ije fu kuaema ije bu ijiege isoe, Fu korufuo adame nuvuone boeje binobino kiaga bu furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Areme maza be Jesu fu giake buka e uruvana fu fino ijia zaraevoga fu giae. Ijadufuo fu urina e vua fuone fievo ije kiamoga bune uri do ije daturako nafuema ije urana gara vae. ");
INSERT INTO bbb_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Bune iko vakuvejo ijia e vua akae nijasiamo be fu ruoma Jesu fino ijia kekei. Fu kekena Jesu kuae, E nijasiamo nane samuaedo a iziebureki vakuma na osiki ijia oenoekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Fu ijiege kuaramoga Jesu fu una gue kuae, Ije a ma kuae rove igia fie, Siroe taraeko fokisino kuavo ijiakiro ume ije bu mako ro nae buone bu amaeriaeva ijia karikinu oenoevo. Ro ema igiebuo fari ige naeje nana are none na ijia fikinu ro nae fu madiega na una uri i menoedufuo ije na bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Fu ijiege kuarakogaro e vua fuone fiemo be fudua fu kekena Jesu kuae, E Ireobo nanaka a nuvedakiro vierafe. Rove ni areke na va asoe none samua fu baronega na abe mako ru areme una nuvedano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Fu ijiege kuaramoga Jesu fu una gue kuae, E ije Godido vua fievo baki ije bune oeva igeki. Ijadufuo ni arega bure e ije oevo ije kena mako rune. Ro aeje ani urina na nuvedieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Areme Jesu fune vanage be ijia ajiamoga e vua fuone fievo ije bune fuina ijia ajiae. ");
INSERT INTO bbb_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Bu ijia ajiakoga saroruba majaufi ka ireobo ijare ijia ufikoke do ije funeka ufekoga vanage ije dabe dakudekiro reme. Rove Jesu fuje fune ni nae. ");
INSERT INTO bbb_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Majaufi ije fu ijiege remoga e vua fuone fievo ije bu uri Jesu sakinu kuae, E Ireobo noeje noneka oekuae revono ifejuono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Bu ijiege kuaravoga Jesu fu urina kiae, E gure ka naebe ma vierafevo gurie, ja irerefuo jumevono kiae. Fu ijiege kuaria areme urina majaufi ijiakiro do ije ufemo ije itire fuone ijia kuriaerena vafiae. Fu vafiamoga do ijiakiro majaufi ije bune ijia arekogana do ije fune una izege ude fu namo ijiege nae. ");
INSERT INTO bbb_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Fu ijiege remogana e vanage ijia kariva bu ire ije rema ijene gavo buka oeseradiae. Ijadufuo bu urina bue kuae, E ije fu e izekido fu majaufi ijiakiro davare gure vafiamo buka fu irinaevano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Areme Jesu fu vakuma aesakae Gadara do gara ijia kekei. Fu ijia kekemoga e inokiro kavene ise nirokiaeva ijiebe munua tire ije bu e oega bu ke uniavo ijia usiaena ruae. E inokiro ije buka e ise ro ka e daroki ijadufuo e bu are ije bu karijo ivuake ijia bu vako baki. ");
INSERT INTO bbb_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ijadufuo bu Jesu vakoga bu uri vijena kumei, Godido Fari gafe, a noeje kena izege rekiro vierafe? Iviama ige fu maza ma baki ijadufuo ade no kena isekafuomono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ro are ije bu ireva ivuake ijia buka mave uruvana ijia kuinoeve. ");
INSERT INTO bbb_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ijadufuo kavene ise inokiro ije bune uri Jesu soesoena kuae, A isekie ni kuoga no usiae mave gafe afuiva ijiebuo vano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ijadufuo Jesu fu urina kiae, Ja iviama e ije arena usiae vano kiae. Fu ijiege kiamoga kavene ise ije bune e inokiro ije arena usiae mave ije afuiva ijia vae. Areme saroruba mave ije bune subinaena uruo ireobo ijia arina do ina oe furi. ");
INSERT INTO bbb_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","34","Mave ije bu ijiege revoga e mave samuagiavo bu ire ije rema ije gana bune subinaena una sidove ireobo ijia vae. Bu va gafia usiaena ire ije rema ijene e boeje kuariae. Bu mave ije bu reva ije kuaria areme kuke uri e inokiro ije bu kavene ise ijiebe bu kame nirokiavo ije izege bu reva ije kuariae. Ijadufuo e boeje sidove guove ijia kariva ije bune uri Jesu biekuae usiaena vae. Bu va Jesu biena uri soesoena kuavoga fu sidove ije arena una are be ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Areme Jesu fune vanage abena do ije urana una gara are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Fu ijia vakoga e gue bu e vajae garema ije dabe fata ijia nujana abe fuone ruae. Bu rovoga Jesu fu uri izege e ije bu fu ma vierafeva ije giae. Ijadufuo fu uri e ije kuae, Farino a mamoemo ije arekiro giriesane. Ise one ije nane gana arevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Jesu fu ijiege kuaramoga e vua akae nijasiavo gue bu ije gana una mauike bue kuae, E ije erare fu Godi asikiroga fu vua ijiege kuaemono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Bu ijiege mauike karina bue kuaevoga fune giana uri kiae, Ja irerefuo oe ise ijiege vierafena karina kuaeve? ");
INSERT INTO bbb_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ja vierafe nabe e ige kuaga fu suve fuone kara tuana uri vake? Ke na kuako ise one ije nane gana arevano kuake? Vua inokiro ije na izare e gure kuaraga ja giena ma vierafedufuo? ");
INSERT INTO bbb_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ja na naebe ma vierafevo ijadufuo na nijasiaga ja ijia gana ma vierafeke. Ja ijia vierafero Ema Ijiebuo Fari ige na daro abedo na ume igia ebuo ise ije na giana arevoro ja ijiege vierafeke. Fu ijiege kuaria areme uri e vajae garema ije kuae, Ni urina suve one ije ke datena are vano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Fu ijiege kuamoga e ije fu uri suve fuone ije ke datena fune are vae. ");
INSERT INTO bbb_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Fune vakoga e boeje bu ije gavo buka dejudiamo bu uri Godi dabe aroe. Ijadufuo maeje Godi fu e ume igia oenoevo ije daro miaga bu ire sumiki ijieki ije revo. ");
INSERT INTO bbb_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ijiege rena Jesu fune are ije arena vako ijia fu e Matiu e takesi abenoeno ije bie. Fu are fu fina imeno ijia biena kuae, I one ije a meno ije arena na nuvedieno kuae. Jesu ijiege kuamoga Matiu fune ve ijia uri ire ije fu remo ije fuka ijia arena uri Jesu nuvena vae. ");
INSERT INTO bbb_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ijiege rena rade Jesu fune va e Matiudo are ijia kekena fuosiki fina ire i. Fu fuosiki ire ikogana e takesi abenoevo ijiakiro e ise renoejo uruvana bu usiae Jesukiro e vua fuone fievo ijena karina besu ire i. ");
INSERT INTO bbb_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Bu ijiege revogana e Feresi gue bu giana una e Jesudo vua fievo ije kiae, Ja e jone e vua nijasiamo ije fu irerefuo e takesi abevo ijiakiro e ise renoejo ijena ire imono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Bu ijiege kuariavoga Jesu fune fiena uri vua be ijiege mena kuariae, E adame baki ije fube e adame giamo ije vierafeke ijadufuo maeje fu ada baki. Ro fu e adagi ijare e adame giamo ije kuaga fu ifejaga adame fuone fu una maeke. ");
INSERT INTO bbb_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ro ni e Osea vua be fu isuibe kuaema ije rere dana vua maeje gafo. Ro vua ije fu kuaema ije bu ijiege isoe, Nana e bu fanuve ijia kaniana zinone ifaejevo ije na ireobo vierafevo baki. Ro na e ije bu una kairafa guebuo oefiane abevo ijare naka ireobo vierafevono kuae. Ijadufuo na ruaeva ije na e ije bu maturaeva ijiebuo ruaeva baki. Ro na e ije bu ise renoejo ije karauniakiro ruaevano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Areme Joni e do ruoriamo ijadufuo e vua fuone fievo ije bu ruoma Jesu fino ijia usiaena kuae, Nono e Feresi ijena maza boeje no ire atovo. Rove e one vua fievo ije bu naebe ijiege ire atovo ro buka ire ivono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Bu ijiege kuaravoga Jesu fu una vua be ijiege mena kuariae. Fu kiae, Maza ije barubara bu maninamikuae ire ijo ijia e baru ije fu ijia fike bu e ruaeva ije kia bu ire atona karina una oefiaeguma vakuva baki. Ro buka oemarekinu karina besu ire ike. Ro e bu ijia sone rade maza be baru ije fu bara ije mesirina ae be vakuma e bu ijia sone buefuo oefiane abena ire atokono kiae. Vame besu ijiege ro naeje na e ije fu bara abekuveno igeki. Ijadufuo na uria e vua none fievo ije buina finoejo ijia no oemarekinu ire besu ike. Ro maza rade e ani none ije bu na mesirie kanie na baronekuva ijia bu noefuo oefiane abena ire atokono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesu fu ijiege kuaria areme uri vua be izege e Feresi ijiebuo vame isuiko ijiakiro vame fuone iviaeko ije bube kena besu arunamidufuo ijadufuo mena kuariae. Fu kiae, E be fu erare ugone iviaeko be abena una isuiko ijiakuma sagukuma baki. Ijadufuo maeje fu ijiege rekuma ugone isuiko ije fuka ireobo faraekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Vame besu ijiege ro fu erare vuaeni iviaeko ije abena una kamui isuiko ije bu fanu surive ijia amaeriva ijia usiakuma baki. Ro fu ijiege rekuma ire kamui isuiko ije fuka susuikena faraega vuaeni iviaeko ije fudua fuka usiaekuma ije ire inokiro ije buneka isereke. Ijadufuo vuaeni iviaeko ije buka kena una kamui iviaeko ijia usiaekina ire inokiro ije buka marekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesu fu uria vua ije kuariamo ijia e ireobo be e Jiusibuo are isesina bu afuina vua kuaevo ije samuamo ije fu ruoma ijia kekei. Fu kekena Jesu manino nidua ijia augesana kuae, Na kabae none ije iviama funeka baronei. Rove na vierafe aka nosiki vaekina a umui one ijia vajae fuone ije farega fu una uri na oenoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ijadufuo Jesu fune urina fuosiki vakoga e vua fuone fievo ije bu buina vae. ");
INSERT INTO bbb_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ro bara be fu ijia buina vako ije fu kaegena fi ruako fune juaevasia tuero (12) ijiege furi. Rove kavuane arimo fu naebe furi. Bara ije fu Jesudo ijuone ijia nuve vakinu vierafero fu Jesudo ugone ubine ijia farekuva adame fuone fuka furikiro fu ijiege vierafena uri ugone ubine ijia niriae. ");
INSERT INTO bbb_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bara ije fu ijiege remoga Jesu fune fiena una dakude kuae, Kabaeno gufe ibe jumekiro nika giriesane. One a ma vierafema ijare adame one ije fune mukoe furimano kuae. Fu ijiege kuarako saroruba bara ije fune ijia una mae. ");
INSERT INTO bbb_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Areme Jesu fune e ireobo ijadufuo are ijia aru vagake e boeje bu ijia karina niraena ririki ufekinu uruvana omanive. ");
INSERT INTO bbb_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ijadufuo fu aruna kiae, Bara iseke ije fu naebe barone ro fume ninaemano ja niraevo ije arekiro ni usiae makave gafia vano kiae. Jesu fu ijiege kuariamoga e boeje bu uri fu dabe varaemena kisae. ");
INSERT INTO bbb_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Fune ijiege kiamoga e boeje bune usiae makave ijia vakoga Jesu fu bara iseke ije namo ijia aru vae. Fu aruna umui kenoga bara iseke barone namo ije fu una uri. ");
INSERT INTO bbb_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Fu ijiege remoga e boeje are sidove ivuake ijia karinoeva bu ire sumiki ije fu remo ijene fie. ");
INSERT INTO bbb_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Areme Jesu fune gire ije arena una gire be ijia vakoga e nikuzeki inokiro bu usiae fu nuvena vae. E inokiro bu nuve vakinu kumei, E Devidido uifari gafe, a no guoga oefiadakuma ni ifejuono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ijiege rena Jesu fune gire ijia aru vakoga e ni kuzeki inokiro ije budua ijia aru vae. Bu aru vakoga fu uri kiae, Jabe ma vierafedo na ni jone amaeradiaga bu una madiake? Fu ijiege kiamoga bu una kuae, E Ireobo no ma vierafega a manido a ni nuvuone ige una amaeriaejuokono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Areme Jesu fune uri niome buone ijia faradiakinu kia, Jone izege ja ma vierafeva ijare ni jone ije bu una nafaevono kiako ni buone bu ijia una nafae. ");
INSERT INTO bbb_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Bune ni nafaevoga Jesu fu kuriaerena kia, Ja vakuva e bino ire ije na rejiaeva ije jade kuariavono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Fu ijiege kuriaere rove buka faememarena Jesudo vua ije dabe are sidove ivuake ije karinoeva ijia kuaena vae. ");
INSERT INTO bbb_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ijiege rena e inokiro bune usiae vakoga bu una kuke e be mesirina Jesudo ruae. Ro e ije fu kavene ise ijare niroema fu vua kuaemo baki. ");
INSERT INTO bbb_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Bu e ije mesiri rovoga Jesu fu saroruba kavene ise ije kuamo fu e ije arena keke vakoga e ije fu ijia una vua kuae. Ijadufuo e boeje buka oeseradiamo bu kuae, No isuibe are Isurero igia ire ijieki be noka gaeva bakino kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ro e Feresi gue bu kuae, E ije fu kavene ise ijiebuo e ireobo ijadufuo daro ije abema ijadufuo fu kavene ise ije kiaga bu itire fuone ije fiena usiae vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ijiege rena Jesu fune are besubesu Gareri guove ijia ura gianoekinu va e Jiusibuo are isesina bu afuina vua kuaevo ijia aruna vua nijasianoe. Fu ijiege renoekinu e ije vua maeje Godi fu izege oe buone ije samuagiamo ijadufuo vua ije kuariae. Fu ijiege rekinu e ije bu vajaese binobino abevo ijiakina visinamiavo ije amaeriae. ");
INSERT INTO bbb_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Jesu fu ijiege renoekinu uri e boeje bu vame binobino ijia oefiaeguma oenoejo ije giamo fuka ireobo oefiae. Ijadufuo maeje e ije buka vame binobino mave-sifi ije bu e samuagiamo baki igege buka oefiane ro irufui abenoejo fu ije giae. ");
INSERT INTO bbb_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ijadufuo Jesu fu una dakude e vua fuone fievo ije kiae, Godido juare ijia ire ije na giaga buneka uruvana duive. Rove e ije juare masina ire ijene kanafui are ma ijia nadufuo ije buka sibanekua. ");
INSERT INTO bbb_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ijadufuo uri baname isoena Godi e juare koeki igeki ije kuaraga fu una e fuone imedufuo ije binodua kega bu vua fuone maeje abe e kuariafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu fune e vua fuone fievo tuero (12) ije kiamo bu rovoga fu daro fuone ije miae. Fu daro ije bu abena kavene ise kiaga bu e ije arena vadufuo ro e adame abevo ije amaeriadufuo ijene miae. ");
INSERT INTO bbb_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","3","Ro e vua fuone abe oenoevo tuero ive buone ije ijiege. Amure ije fu Saemoni e ije bu kua Fitano kuavo ijiakiro uviafuo e Aduru ijene kei. Areme fu e Zebedido anafa inokiro ino uviaki e Jemisikiro Joni ro e Firifikiro Batoromiu ije kei. Ro e Tomasikiro Matiu e ije takesi abeno ijiakiro e Arefiasedo fari Jemisikiro e Tadiasi ije kei. ");
INSERT INTO bbb_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Ro kuke Saemoni e ije bu kua Serotino kuavo ijiakiro Judiasi e ije bu kua Isikariotino kuavo e ije fu Jesu abe una e ise revo ije miaema ijene kei. ");
INSERT INTO bbb_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesu fu e tuero e i fuone medufuo ijene kena are tire ijia uniana vua ijiege kuariamo bu vae. Fu kiae, Ja vakuva jade e Jiusi baki ijiebuo aesakae ijia vako ro kuke jade e Sameriakobuo sidove ijia bino aru vako. ");
INSERT INTO bbb_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ro ja vakuva nime e Isureroko ije bu mave-sifi igege sauina ka isema karinoevo ijiebuo are ijia vafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ni va bu kariva ijia vua ige kuariana kia, Maza ije Godi fu e fuone ijiebuo oe ije samuagiadufuo ije fune ivuaremano kiafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ja va vua ije kuariakinu ro e adagi ije amaeria bu una madiakinu ro e oevo ije kiaga bu una urifo. Ro kuke ni e ije bu adame reforasi abevo ije amaeria bu una madiafo. Ro e ije bu kavene ise ijiebe nirokiaeva ijene kuriaerena kiaga bu e ije arena usiae vafo. Ro igia fie, daro none ige na vajiaeva ije ja monido fuaevena keva baki. Ijadufuo irere ja va renoevo ije jade una ve ijadufuo ire bino kekuae vierafevo. ");
INSERT INTO bbb_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ro kuke igia fie, jade ire gorodi ro siriva ro moni kavuane bino kedena oenoejo. ");
INSERT INTO bbb_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ro kamui ije jade kena oenoejo ro nime ugone ja savo ijiakiro dia suri ja savo ro mudu ja bijuanoejo ijiaru kena oenoefo. Ijadufuo maeje irere boeje e imenoejo bu kedufuo ije bu e ije bu ifejiavo ijiebe ja samuagiakinu ifejiake. ");
INSERT INTO bbb_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ro kuke igia fie, ja oenoena sidove mamekanu bino ijia vaga erare fu ja oemarejiakinu kaenamiavoga ni ijia fuina karifo. Ja ijia karina areme nine are ije arena vafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ro ja gire be ijia ajiakuva ni e ijia kariva ije mukoreigia anadiana oemarejiafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ro ja ijia ajia vaga bu ja oemarejiakinu kaenamiaga ni ifejiana baname isoena Godi kuaga fu bu samuagiafo. Ro bu naebe ijiege ja oemarejiana kaenamiaga jade baname isoena Godi kuaga fu bu samuagiamo. ");
INSERT INTO bbb_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ja maziena are tire ijia oenoega e bu naebe ja oemarejiana kaenamiakinu vua jone fiekuva ni are ro sidove ije arena vafo. Ro kuke ni uri dia suri jone ja savo ije azona kuokuo ije kaniakaniama areme ni are ije arena vafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ro vua ige naka ma kuariave, Maza radekuma ije Godi fu una ume igia e ise renoevo ije kena mazie giakuma ijia are Sodomekiro Gomora ije fume sibaneke kena isekafiake. Ro una e ije erarebe bu ja ijuoegafiavo ije fuka kame vame ise ijia isekafiaga bu isejavaeke. ");
INSERT INTO bbb_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ro igia fie, jaeje na ume kukoruko igege kena e ise siroe kuriae e sakiavo igeki uve ijia uniaga ja vake. Ijadufuo ja va i menoekuva ni mukoreigia jone samuanamikinu oe vafaena kabuaekabuaeki i jone ma ijiaru menoefo. Ro jade uri bijaekinu ro ire ise bino rega bu ijadufuo ja kame isekafiavo. ");
INSERT INTO bbb_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ro ja oenoekuva ni e ije mukoe giakinu oenoefo. E ije buka oenoene ja toenamiana kame e koto fievo ijiebuo vadufuo. Ro kuke buka e Jiusibuo are isesina bu vua kuaevo guove ijia ifiadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ro kuke ja noefuo i menoevo ijadufuo buka ja toenamia kame e kini bino ro e Romukobuo e mamekanu ijiebuo vadufuo. Bu kaenamia ijia vaga ja e mamekanu ije abero e Jiusi baki ijiebuo nidua ijia irena Godido vua maeje kuariadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Bu ja ijiege toenamiana kaenamia vaga jade uri oeseradiavo. Ro kuke jade vua irere ja bu kuariadufuo ije ro kuke izege ja kuariakuva ijadufuo oefiane abevo. Ja maza ijieki ije biediavo ijia vua irere ja una bu kuariadufuo ije ja jare vierafekuva baki. Ro vua ije fu Asoe jone ijadufuo Kavene Akae ijare vierafejiaga ja kuariadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Ro vakuma maza ijieki ije abekuma e buka uri uviarafa ro anafa buone ije korubuo kena una forisi vajiaga bu kania bu oeke. Ro kuke ame ije bu una kuderia orafa buone ije korubuo sikiaga forisi bu va kania bu oeke. ");
INSERT INTO bbb_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ja noefuo imevo ijadufuo e boeje buka ja ziegafiadufuo. Rove erarebe bu uria giriesa faememarena noefuo imena vakuma ubine ijia usiaevo e ije Godi fu karauniake. ");
INSERT INTO bbb_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ro kuke ja sidove be ijia vaga e bu ja kaniakinu vame ise bino jone rekuva ni sidove ije arena una be ijia vafo. Ro igia fie, sidove boeje are Isurero guove ijia karinoeva ije gue vua none ja naebe abe kuaria furiva ijia Ema ijiebuo Fari ige na una ruakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Jesu fu ijiege kuaria vakuma kia, E ije fu sikuru remo ije fu e fuone fu nijaemo ije asima baki. Ro kuke e monifuo imeno baki ije fu e ireobo fuone ije asima baki. ");
INSERT INTO bbb_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ijadufuo e ije fu sikuru remo ijiakiro e ije fu monifuo imeno baki ije bu e mamekanu buone matiana buenina kenoevo ije fune marei. Ro igia fie, e ije na bu kie aeje a Setani e kavene ise ijiebuo e ireobono kieve. Rove naeje nane ma E Ireobo jone. Ijadufuo bu na dabe ijiege kiekuva na vierafega e none ije jaeje bu kame ive ma omeise ijia imiadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ijadufuo e ise bu ire ise binobino jone rega jade giana jumevo. Ijadufuo maeje vame ise buone boeje binobino bu mauike nuriete renoejo ije rade Godi fu kena una e boeje ijiebuo niome ijia samadirega bu giake. ");
INSERT INTO bbb_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ro vua irere na mugu kuariavo ije ni jase maza ijia usiaena dabe e boeje kuariafo. Ro vua irere no mauike nuvuosukua kuaenoeva ije nika abe usiaena are irore boegia kuaria vafo. ");
INSERT INTO bbb_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ro jade e ije bu kavene jone bu bakiro bume vajae surive jone ijiaru kaniakuvejo ije giana jumevo. Ro e ije ja jumedufuo ije nika Godi ije fu surive abero kavene jone ije kena miane ije maza boeje naevako ijia korega ja naona bakiredufuo ijene jumefo. ");
INSERT INTO bbb_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ro igia fie, e bu ume isesina gue kena una e guebuo fuaevekuva buka moni isesina bino kedufuo. Ijiegero Godi Asoe jone ije fu fuone vierafema ijia fu ire ka isesina ijieki ije fu ijuoegafiamo baki ro fuka oetuakinu samuagiamo. ");
INSERT INTO bbb_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ro kuke nigofo u jone besubesu bu ijia ireva ije Godi fune vierafe. ");
INSERT INTO bbb_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ro ume isesina ijiakiro nigofo u ije buka ire isesina rove Godi fune fuone vierafema ijia ire ije fu uria mukoe samuagiame. Ro jadua jaka Godido ire anuigi fu oetuakinu mukoreigia samuagiamo ijadufuo jade jumevo. ");
INSERT INTO bbb_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ro erare fu e niome ijia oenoekinu kuae nana Jesudo aganeno kuaemo ije nase saove ijia Asoe none ije kuako e ije fu e noneno kuake. ");
INSERT INTO bbb_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ro erare fu e niome ijia na ijuonemo ije nase saove ijia Asoe none ijadufuo nidua ijia kuako e ije fu e none bakino kuakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","Jesu fu ijiege kuaria areme kiae, Umeigia na ruaeva ije na e ige kaenamia una besu afuikiro ruaeva bakiro na e ige dabe atakiro ruae. Na e dabe ataga e gue bu na iriniena una none ruakiro gue buka na ijuoegafieke. Bu ijiege rena fari fu uri asoe fuone ziegafake ro kabae fu uri asie fuone ziegafake. Ro kuke asaefuo fu uri asaefuo ziegafake. ");
INSERT INTO bbb_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ro e gariebure bume vajae fiane sibaneke vajiadufuo. Ro e ije bu vajae fiane ma uruvana vajadufuo ije buneka e aena gire besu karijo ijiebe a dabe arafiraga a isejavaeke. ");
INSERT INTO bbb_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ro kuke e be erare fu asoe ro asie ro fari ro kabae fuone ijene uruke oetuagaro na fume sibaneke oetuamo ije fu izege kuaeko nana Jesudo aganeno kuaeke. ");
INSERT INTO bbb_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ro erare fu naebe na oetuana uri makae none ijia nuvediena isejavaenoeno e ije fuka naebe manido fu e vua none fiemo reke. ");
INSERT INTO bbb_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ro erare fu ume igia maza boeje fuone vierafema ije oetuakinu kenoeno ije rade fu una izege vame ma fivako ije abekuma baki. Ro erare fu ume igia maza boeje fuone ma fivadufuo ije fuka toteganaro una e gue vierafekinu oetuana ifejianoeno e ije fu rade vame ma karivako ije abeke. ");
INSERT INTO bbb_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ro igia fie, erare fu ja oemarekinu kaenamiamo ije fu kuke na oemarekinu mesirieme. Ro erare fu na oemarekinu mesiriemo ije fu kuke e ije fu kiemo na ruaeva ije oemarekinu mesirime. ");
INSERT INTO bbb_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ro kuke erare fu e ije Godido vua vierafena kuaevo ije mukoreigia giana oemarekinu kaenamiana samuagiamo ije fune mare. Fu ijiege remo ijadufuo fu ire maeje Godi fu e fuone vajiamo ije gue kedufuo. Ro kuke erare fu e ije Godido vame ma ijiaru kenoeno ije mukoreigia gana oemarekinu mesirina samuamo ije fune mare. Fu ijiege remo ijadufuo fu ire maeje Godi fu e fuone vajiamo ije gue kedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ro igia fie, e be erare fu vierafero jaeje ja e vua none fievo ijero fu uri ire isesina bino ifejiamo ije Godire rade vame ma bino fuone rekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesu fune e vua fuone fievo ije vua ijiege nijasiama areme fune uri aesakae Gareri guove are isesina ijia oenoekinu e ijene vua maeje abe nijasiakinu kuarianoe. ");
INSERT INTO bbb_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Fu ijiege renoekoga Joni fu dibure ijia fina Kuraesi irere fu renoeno ije fie. Ijadufuo fune uri e vua fuone fievo gue kiamo bu Jesu kuagakuae vae. ");
INSERT INTO bbb_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Bune vakuma fu fino ijia usiaena kuae, Aeje a e ije Godi fu kua fu ruakono kuaema ije ke a bakido no una e be samuakono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Bu ijiege Jesu kuaravoga fu kiae, Nine una va Joni irere boeje ja fiekinu giaeva ijene kuarafo. ");
INSERT INTO bbb_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ro ni kua e ije bu ni kuzeva ije bune una ni nafaekinu ro e aekirariaeva ije bune una uri oenoeve. Ro e ije bu adame reforasi abeva ije bune una madiakoke e ada bijuki ije bune una vua fievono kuafo. Ro kuke kua e ije bu oeva ije bune una urikoke e iseki ije bune Godido vua maeje fieve. ");
INSERT INTO bbb_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ro kuke erare fu ire ige na renoejo ije fu naebe giana totenami ro fume zinune na ma vierafemo ije funika oemareno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","8","Jesu fu e Jonido vua fievo ije ijiege kuariamo bune vakoga fu una dakude e boeje bu afuiva ijene Jonisina kuariae. Fu kiae, Ja Joni fu are sao ijia oenoeno ja fiena usiae vaeva ije ja irere ije gakuae vae? Jabite e garuki be fu majaufi nubuane nijamo igeki ja ije gakuae vae. Ke, ja irere ijia gakuae vaeva ni kuarie na fiefo. Ro baga na vierafe jate ja e be fu ugone ni mukore sana ijia oenoeno ja ije gakuae vae. Na vierafe ije fu baki ijadufuo maeje e ijiege ugone mukore savo ije bu e mamekanu aesakae samuavo ijiebuo are maeje ijia karijo. ");
INSERT INTO bbb_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ro ja vaeva ije ja irere gakuae vae? Ja e Godido vua vierafena kuaemo ije gakuae vae ke ja era gakuae usiae vae? Ni kuarie na fiefo. Ke, na vierafe e ije ja gakuae vaeva ije fuje fu ma e anuigi. Fure e Godido vua vierafena kuaevo ije fu ma asidiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ijadufuo maeje Godi fune isuibe buki akae ije bu isoeva ijia fu e Jonido ijiege kuae, Na e vua none abe oenoeno be kuaga fu ude vuake. Fure ude vame one ije amaeria vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ro vua ige naka ma kuariavo fiefo. E mamekanu gue bu ude kari ruaeva ije bu Joni e do ruoriamo ijieki baki. Ro fune Jonire e anuigi ume igeko ije ma asidiae. Rove e ije erare fu Godi e ije fu oe buone ije samuagiamo ijiebuo uve ijia una e isekube remo e ijare fuka Joni ma asi. ");
INSERT INTO bbb_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ro maza ije Joni fu uri zinuivena Godido vua maeje fu abe kuariaema ijia ruoma iviama ige Godido e ije fu samuagiamo ije buneka ma e uruvana reve. E uruvana bune ise bu renoevo ije arena una Godi e ije fu oe buone samuagiamo ijena maziekuae buka giriesave. ");
INSERT INTO bbb_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ro maza ije e Godido vua vierafena kuaevo bu kariva ijia ruoma e Mosisido akae bu iko abeva ijia e ije buka karina maza ije Godi fu veze e fuone ijiebuo oe ijia samuagiadufuo ijene dabe karina kuaenoe. Bu vua ije dabe ijiege karina kuaena ruoma Joni e do ruoriamo ijadufuo maza ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ro ja vua buone ije jane ma vierafekuae samuaejoga na vierafe e Joni ja gaeva ijeja fu e Eraeja. Fu e ije bu kuae fu ruakono kuaeva ijene. ");
INSERT INTO bbb_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ijadufuo ja adanekikuva ni vua ige mukoreigia fiena ma vierafefo. ");
INSERT INTO bbb_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ro na be bijana kuariako ni fiefo. E ige iviama karina vua maeje naebe mukoe fievo ije buka ame isesina ige bu are ije e uruvana bu afuina ire fuaevejo ijia afuivo ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Ame isesina gue bu una gue kia, No joefuo zae vajaejia rove ja naebe dua uruve. Ro no sise bijaejiave rove ja naebe oefiane abena niraevono kiavo bu ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","E mamekanu jone ije budua buka karina ijiege reve. Bu Joni fu maza bino ire atokinu ro do kugi naebe ikinu ro kuke maza ije fu uri Godido vua maeje abe kuariamone bu gana buka ijuoneve. Bu kuae, E ije fuka kavene ise ijare niroemano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ro una Ema ijiebuo Fari ige na keke ire ikinu do vuaeni ivone bu una kuke ijene ijuoneve. Bu ijuonena kuaevo, Jame e guraeje gafo, fu ire boeje funeka abe i furina uri do vuaeni uibe ino gafo. Ro kuke fuka e ije takesi abenoevo ijiakiro e ise revo ijena kaikaranoeno kuaeve. Rove igia fie, e ma vierafevo ije bu Joni i irere fu menoeno ro na renoevo ije bune guona vierafei. Bu vierafe Godi irere fu vierafena remo ije fune mukoreigia remoro bu ijiege vierafevono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ijadufuo Jesu fu ve ijia urina sidove bino fu ude oenoekinu vame sumiki boeje e ijiebuo nidua ijia renoema ijene kame isekafiakiro buesina kuae. Ijadufuo maeje e ijia kariva ije bu ire ise bu revo ije bu naebe arena una oe kuderiana fu ma vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ijadufuo fu uri e ije kiae, E ije are Korazikiro Besaeda kariva ije na vierafe ire ka ma ise be fu jone rekono nika jumefo. Ja vame sumiki na nidua jone ijia renoeva ije na una e are Taeakiro Saedoni kariva ijiebuo revabitie e ije buka una ise buone ijadufuo oefiane abedufuo. Bu oefiane abena niraena ire atoga e bu ijia giana vierafero bune una oe kuderiaevaro bu ijiege vierafeke. ");
INSERT INTO bbb_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ro vua ige naka ma kuariavo fiefo, Vakuma rade maza ije Godi fu una e umeigia ise revo ije kena isekafiamo ijia e are Taeakiro Saedoni kariva ije fume sibaneke isekafiake. Ro una e ije are Besaedakiro Korazi kariva ije ja fuka kame vame ma ise ijia isekafiadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ro e Kafoniamuko jaeje jade vierafero Godi fu ja fuka kena aroriana kame kave gufia uniakiro jade ijiege vierafevo. Jaeje Godi fuka kame una are ise miane naeno ijia koredufuo. Ja vame sumiki ije na ni jone ijia renoevo ja gieva ije na ude e are Sodome kariva ijia revabitie e ije bune isuibe oe kuderiaevado Godi fube ude bu kena isekafiaema ijiege isekafiake. ");
INSERT INTO bbb_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ro igia fie, rade maza ije Godi fu e boegiebuo ise fu kena mazie giamo ijia fu e are Sodome kariva ije fume kena sibaneke isekafiake. Ro una e Kafoniamuko ije jaeje fuka kena vame ma ise ijia isekafiakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesu fu ve ijia ijiege kuariama areme una dakude Asoefuo baname isoena kuae, Godi Asoeno, aesakae igiakiro saove gufe samuamo naka ireobo one oemareve. Ijadufuo maeje a e ije bu umeigia vua mukoe vierafena kenoejo ije vua maeje a izege ire binobino remo ije aka kena bu nisauikuriae. A bu ijiege regaro vua maeje aka dabe una e isesina ije bu vierafe isesina keva ije samadirejiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ijadufuo Asoeno vame ijiege a vierafena kema ije ane one izege a kekiro vierafema a ijia kemano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesu fu ijiege baname isoema areme una e ije kiae, Ire boeje na vierafekinu renoevo ije fune Asoe none ijare kuariema na ijia renoeve. Rove fu erare na mukoreigia giena vierafekuma baki. Ro fune Asoe none ijare fuosukua na fune vierafe. Ro kuke fu erare Asoe none ije gana vierafema baki ro nane Fari fuone ige nare nosukua fu gana vierafe. Ro na kono era na vierafekuva na e ije ifejaga bu Asoe none ije mukoreigia gana vierafekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Jesu fu ijiege kuariama areme kiae, Erare fu irufui uruvana abenoeko funeka aemaevoga ni una none roga nare dasumane. ");
INSERT INTO bbb_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na vierafe naka ja samuagiakiro vierafe ijadufuo ni una agane none na samuagiavo ijena maziefo. Ro ni none roga na vame none maeje nijasiafo. Ijadufuo maeje nanaka e oe soegi ro kuke naka kabuaekabuaeki kenoejo. Ja naena maziekuva kavene jone bu dasu karidufuo. ");
INSERT INTO bbb_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ijadufuo maeje vame none ije fuka mukore ro i ije ja menoedufuo na vajiavo ije fuka gikikimana baki. ");
INSERT INTO bbb_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Jesu fu ijiege kuariama areme maza be fune e vua fuone fievo ijena va ire vuiti juare ijia urana oenoe. Ro maza ijeja bu mauike karina Godi baname isoekinu oemarevo. Ro e Jesudo vua fievo ije buka vasiaoriaema ijadufuo bune uri ire vuiti garine bino tuana inoeve. ");
INSERT INTO bbb_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Rove e Feresi gue bu ije giana una Jesu kuae, Eko, e vua one fievo buka isema rena maza akae ige dabe tuasevono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Bu ijiege kuaravoga Jesu fu una kiae, Ro ja buki akae ijia Kini Devidi fu e fuone ijena Godido are ijia aruna irere abeva ije jabe dana vierafe? Bu vasiaoriaema ijadufuo bu aruna burete ije karina i. Ro burete ije bu kena iva ije fuka akae ijadufuo e mujue bu ikuva baki. Ro bune e ije Godi zinone ifaejevo ijiebe buosukua burete ije ivo. ");
INSERT INTO bbb_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ro kuke ja e Mosisido akae fu isoema ijia dana gabitie ja gia e ije bu Godi zinone ifaejavo ije bu maza uruvana buka maza ije e bu mauike karivo ijadufuo akae ije dabe tuasena una imeva ja giake. Rove ije bu revo ije bu Godido niome ijia ise revo baki. ");
INSERT INTO bbb_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Vua ige naka ma kuariave. I ije Godi fu kiemo na mekiro ruaeva ijare fuka ma anuigi ro una i ije bu Godido are ijia mevo ije fume sibaneke isekube. ");
INSERT INTO bbb_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ro kuke isuibe buki akae bu isoeva ijia Godi fu ijiege kuae, Nana fanuve ije bu kaniana zinone ifaejievo ije na naebe oemadieme. Ro na e ije bu una e guebuo oefiane abena ifejiavo na ije ireobo oemarevono kuae. Ro ja vua ije mukoe gana vierafevobitie ja e ije bu ise bino naebe revo ije jabe ise bino kena bu namiake. ");
INSERT INTO bbb_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ijadufuo maeje Ema igiebuo Fari ige naeje fune Godire daro miena ire boeje kiega na samuagiave. Ijadufuo maza ije ja mauike karivo ijadufuo akae ije ja nuvevo ije nare kuariaga ja fiekinu kenoekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jesu fu ijiege kuariama areme fune vakuma e Jiusibuo are isekube bu afuina vua kuaevo ijia arui. ");
INSERT INTO bbb_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ro are guove ijia e be umui abe kiraema fu ijia fine ro kuke e gue budua bu ijia afuina kari. Bu vierafe buka Jesu fu ire bino isema rega bu kuakuae bu ijadufuo ni veri. Ijadufuo bu urina Jesu kuae, A vierafe fube maredo a maza akae mauike karivo ijia e iseki ije una amaeriakono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Bu ijiege kuaravoga Jesu fu una kiae, Ja e be erare a mave-sifi be dabema fu maza ije mauike karivo ijia va mako urakuma a izege reke? Abe ijia arega fu mako ijia manina isejavaeke? Na vierafe a ijiege rekuma baki ro aka va kenujaga fu ajia vadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ro mave-sifi ije bu anuigi baki ro ema ijare buka ire anuigi. Ijadufuo no maza akae mauike karivo ijia no e ifejiakuva ije no akae tuasevo baki ro none ma revono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesu fu ijiege kuaria areme una dakude e ije umui abe kiraema ije kuae, Eko umui one ije akoeno kuae. Ijadufuo e ije fune umui fuone ije akoemogana funeka una umui fuone maeje be ijieki rei. ");
INSERT INTO bbb_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesu fu ijiege remoga e Feresi gue bu una usiae makave ijia vame izege bu fu kanadufuo ije mauike bue kuaena ijunami. ");
INSERT INTO bbb_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Bu ijiege renoejoga Jesu fune giana uri are ije arena una are be vae. Fu vakogana e ka uruvana bu fu nuvena dabe arafiri vakoga fu adame buone boeje binobino ije amaeriamo bu una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Fu amaeriama areme kiae, Ja vaga ebe giana kiako, ja erare amaeriaemano kiaga jade kuariavono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ro Jesu ije fu kuriaerema ije funeka izege e Godido vua vierafena kuaemo e Asaea fu isuibe kuaema ijiakuma riare. ");
INSERT INTO bbb_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ro vua ije fu kuaema ije bu ijiege isoe, E ije Godi nare kuaga fu noefuo imenoene. Fuje naka ireobo oetuavo ro fu noefuo imeno ije na gaga fuka oemadieme. Ijadufuo na Kavene none fu nujaejaga fu e Jiusi baki ijene vua none abe kuariake. Fu kuariaga e boeje buka izege Godi nare rade bu karauniadufuo ije mukoe fiena vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ro fu vua kuariakuma fube madiakinu kuariake. Ro kuke fube vame ijia vua arana kuaenoega e bu fieke. ");
INSERT INTO bbb_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ro e ije bu vame maeje kenoekuae mamoevo ije fube kuriaekuriaeki kuariakinu ifejiake. Ro kuke fu e ije bu buone ma vierafevo ijia mamoevo ije ifejiaga bu una giriesana izege Godi fu rade karauniadufuo ije ma vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Fu ijiege rega e aesakae boegia karinoeva ije buka una fu ma vierafe furikono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Areme e bino bu uri e be ni kuzeki fu vua kuaemo baki ije mesirina Jesudo ruae. Ro e ije fu kavene ise ijare nirona dabe arafirimo ijadufuo fu vua kuae ro ni nafaemo baki. Bu e ije mesiri Jesudo rovoga fu urina kavene ise ije kuriaeremo fune e ije arena keke vae. Fu vakoga e ije fune ijia una vua kuaekinu ro ni nafae. ");
INSERT INTO bbb_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","E ije fu ijiege remoga e boeje bu vame sumiki ije Jesu fu rema ije gavo buka oeseradiae. Ijadufuo bu una bue kuae, Ja vierafega e ije fune e Devidido uifari ije fu ruakono kuaeva ijeno kuae? ");
INSERT INTO bbb_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Bu ijiege kuaenoejoga e Feresi ije bu fiena una kiae, E ije fu kavene ise Setani e Birizibuno kuavo ijadufuo e. Ijadufuo fure daro maga fu kavene ise ije kuriaerega bu fu irinana e ije arena usiae vakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Rove Jesu fune oe buone ijia izege bu vierafeva ije fune giaema ijadufuo fu uri vua be ijiege mena kuariae. Fu kiae, E aesakae besu ijia karijo ije bu uri ata guegue rena bue bijaekuva bu izege mukoreigia karike? Ro kuke sidove be ro agane be bu una bue nigaraekinu karikuva ije buone ma karivo ije fuka iseredufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ijiege ro Setanido are fu samuamo ijia kavene ise bu una bue nigaraekuva funeka mukoreigia iseredufuo. Ijadufuo bu ijiege rekuva bune dabe atavo ijadufuo bu izege una mukoe karikuva baki. ");
INSERT INTO bbb_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ja kuae nana Setani e Birizibuno kuavo ijare daro miega na kavene ise ije kuriaerega bu usiae vakono kuaeve. Rove ja vierafega e vua jone fievo ije bube Setanido daro ijia kavene ise ije rorukuriaga bu usiae vako? Na vierafe ije fu baki. Ijadufuo vua izege ja noesina kuaevo ije jaka mukoe vierafena kuaevo baki. ");
INSERT INTO bbb_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ro ja giega na Godido Kavene ijadufuo daro ijia kavene ise ije kuriaerena rorukuriavoga ja vierafedufuo. Ja ijia vierafero maza ije Godi fu una zinuivena e fuone ije samuagiadufuo ije fune igifurekiro ja ijiege vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ro kuke igia fie, e be fu erare va e daroki be ijadufuo are ijia ajiana sinuome fuone ije iniemekuma baki. Ro fu iniemekiro vierafekuma fuka ude e kuriae ije fare dabe toma areme fu sone sinuome fuone ije iniemejadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ro e be erare fu naebe na oemarejiemo e ije fu e none baki. Ro kuke erare fu naebe ifejiena e kaenamia una Godido ruomo e ije fuve e kuriaerena rorukuriaga bu giegisa vake. ");
INSERT INTO bbb_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","32","Ijadufuo na kuariako fie, Godire fuosukua ema ijiebuo ise bu revo ijiakiro vua ise bu kuaevo ije giana areke. Ro kuke erare fu vua ise bino una Ema ijiebuo Fari ige noesina kuaevo ije Godi fu giana areke. Rove erare bu vua ise una Kavene Akae fuesina kuaevo ije Godi fube giana aredufuo. Fu iviama ige ro maza boeje funeka ijiege navakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesu fu e Feresi ije ijiege kuariamo ijia fu kuke vua be ijiege mena kuariae. Fu kiae, Ja ine ma be fu manino ja gakuva ije ja vierafero fu fo maeje kirakiro ja ijiege vierafeke. Ro fu ine ise ijare manikuma ije ja vierafero fu fo ise kirakiro ja ijiege vierafeke. Ijadufuo ine ije fu ma ro ise ije ja fo buone bu kiravo ijia giana vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","E gure ka omise tabare gurie, Iviama vua ige na mena kuariaeva ije jaeje jaka ijieki. Ja e gure ka ise renoejo ije ja izege una vua ma kuanoeke? Ijadufuo maeje e ijiebuo oe ijia irere bu vierafevo ije bu itire buone ijia kuaenoevo. ");
INSERT INTO bbb_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ro e ije fu oe fuone ijia ire ma ijiaru vierafenoeno ije itire fuone fune vua ma ijiaru kuaenoeno. Ro e ije fu oe fuone ijia ire ise vierafenoeno ije itire fuone fune vua ise ijiaru kuaenoeno. ");
INSERT INTO bbb_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ro igia fie, rade Godi fu una e ume igia ise renoejo ije kena mazie giake. Fu maza ijia kiaga e boeje bu irerefuo vua omeise ije kuaenoeva bu ijene kuaraga fu fieke. ");
INSERT INTO bbb_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ijadufuo Godi fu vua jone ja ume igia kuaenoeva ijia mazie giana karauniakinu ro kena isekafiake. ");
INSERT INTO bbb_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Jesu fu ijiege kuariamoga e vua akae nijasiavo gue ro e Feresi gue bu urina una kuae, E nijasiamo no vierafe aka ire sumiki be rega no ijia gana a ma vierafedufuo. No ijia ma vierafero ane ma Godire kuamo a ruaemaro no ijiege vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Bu ijiege kuaravoga fu una kiae, E gure ka Godi mukoe vierafevo baki ka ise renoejo gure jare ire sumiki giakuae vierafei. Rove na vierafe iviama ire sumiki be nabe reke. Ro na sone rade ire sumiki besu fu e Jona e Godido vua vierafena kuaemo ije fuone rema ijieki be rega ja gadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","E Jona fu maza inokubeke ro muge inokubeke fu kijume ireobo be ijadufuo devatua ijia fi. Ijadufuo Ema igiebuo Fari ige nadua na sakae guove ijia maza inokube ro muge inokubeke ijia nake. ");
INSERT INTO bbb_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ro vakuma rade maza ije Godi fu e umeigia ise renoevo ijiebuo ise ije kena mazie giamo ijia e sidove Ninivako ije buka una vua ise e ige ja iviama kariva ije joesina kuaedufuo. Ijadufuo maeje bu e Jona vua ije fu kuariaema ije fiena bu una oe kuderiana ire ise boeje buka ijuoegafiae. Ro e Jona fuje fume e ume igeko rove e Ninivako buka vua fuone mukoreigia fiena irinae. Ro ivia naeje naka e anuigi be rove vua none ige jaka naebe fieve. ");
INSERT INTO bbb_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ro kuke e Sibako ijiebuo Kuini fu rade maza ije Godi fu e ume igiebuo ise ije kena mazie giamo ijia fu e ige ja fuka arafiriana vua ise joesina kuaeke. Bara ije fu aesakae ubine gue ijia fino rove fuka urina Kini Soromonido uguare maeje fu vierafena kuaemo ije fiekiro ruae. Ro e Soromoni fume sibaneke e isekube rove nare naka ma e anuigi be na igifureki manina vua kuariave. Rove vua none ige jaka naebe mukoe fiekinu ro na ma vierafevono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesu fu ijiege kuariama areme kiae, Na e vame ise kenoejo bu naebe oe kuderiavo ije bu izege redufuo na ije be mena kuariako ni fiefo. Maza ije e bu kavene ise ije kuriaerena rorukuraga fu e ije arena va ae sao ijia are fu fidufuo ije rerenoeke. ");
INSERT INTO bbb_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Fu rerenoega bakuma fu una fue kuaeko, Naneka una are na fina ruaeva ijia vakono kuaeke. Areme fune una ro are fu ude fima ije gaga funeka mukore iviaeko ro kadure bino bakiga fu gake. ");
INSERT INTO bbb_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Areme fune una kuke va kavene ise gue seveni (7) ka ma ise ijene kaenamia una ro are ijia aruna karike. Bu una ro e ije fu ude niromo fu ire ise sibaneke kenoema ije nirokuva rade fuka una biona ma ise ijia kenoeke. Ijadufuo e garuki gure ja iviama karijo ije jaeje jaka ijieki. Ijadufuo ire binobino ja renoejo ije ja oe jone ma ijiakuma renoevo baki. ");
INSERT INTO bbb_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesu fu uria e boeje vua kuariamo ijia asie fuone ijiakiro uviarafa fuone ije bu ruoma viene ijia usiaena fu samuana irei. ");
INSERT INTO bbb_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ijadufuo e be fu urina Jesu kuae, Asie one ijiakiro uviarafa one ije bu a vua kuarakuae ruaeva viene gufi samuana irevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Bu ijiege kuaravoga Jesu fu una kiae, Ro ja vierafega asie none ijiakiro uviarafa none maeje erano kiae? ");
INSERT INTO bbb_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jesu fu ijiege kuaria areme una dakude e vua fuone fievo ije umui bijiana kiae, Uviarafa ro asierafa none maeje ijeja e gure ja kariva ijene. ");
INSERT INTO bbb_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ijadufuo maeje erare fu irere boeje Asoe none saove gufia fino fu vierafema ijia kenoeno e ijare fu uvia none ro maki none ro asie none ma ijeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesu maza besu ijia ijiege kuarianaro fune are ije arena una keke do Gareri nafuema irifo ijia ari va ijia fi. ");
INSERT INTO bbb_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Fu ijia fina giake buka e uruvana usiae dabe utikuravoga fu uri vanage be ijia namo ijia ajiae. Jesu fu ijia ajiana kiamoga bu abe sibaneke biona do ijia nijavo fu fikoga e ije vaeva bu do irifo ijia irei. ");
INSERT INTO bbb_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Areme fune urina vua fuone boeje fu kuariaema ije fuka ke mena kuariae. Fu kiae, Ni e be juae meno fu juare fuone ijia uije daejukiro vaema ije vierafefo. ");
INSERT INTO bbb_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E ije fune va uije korenoeko uije gue bu duoena vame ije e bu oenoevo irifo ijia arivo bune ume ijiebe arina kari i. ");
INSERT INTO bbb_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Ro gue bu duena munuage ado ijia arina buneka tavuae rove girege buone bu naebe uruke sae. Ijadufuo maeje sakae maeje fu isekube ijadufuo bu tavua ajiavo fune maza keke kaniamo buneka saere. ");
INSERT INTO bbb_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ro uije gue bu duena fiene mibiamibia uve ijia arivo fune fiene ijare tavuana uije maeje fune okuriae. ");
INSERT INTO bbb_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ro uije gue bu duena sakae mukore safiki ijia arina buka mukoe tavuana suni kirae. Suni gue buka uruvana aderedi (100) ijiege kirakoga gue bu sibaneke sisiti (60) ijiege kirako gue bu teti (30) ijiege kirae. ");
INSERT INTO bbb_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ijiege ro erare fu adanekikuma ni vua ige mukoreigia fieno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Areme e Jesudo vua fievo bu urina ro Jesu kuae, Vua one boeje a e kuariamo ije a irerefuo ijiege mena kuariaemono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Bu ijiege kuaravoga Jesu fu una kiae, Na vame sauiki izege Godi fu e fuone ijiebuo oe ije samuagiamo ije nane e ije ja na nuvedievo ijene kuariana nijasiae. Ro una e gue ije nabe samadukua nijasiakiro name ijiege ke mena kuariake. ");
INSERT INTO bbb_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ijadufuo erare fu vua ijadufuo maeje gue fune fiena vierafema ije Godi fu ifejaga fu kuke vua fuone maeje binodua fiekinu fivake. Ro erare fu Godido vua ijadufuo maeje fu naebe mukoreigia fiekiro vierafemo ije Godi fu vierafe sibaneke ije fu vierafemo ije fuka kamazaga fume ijiege fivake. ");
INSERT INTO bbb_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ijadufuo maeje e ige iviama kariva bu vua boeje na kuariakinu ro izege na kena nijasiavo ije buneka giakinu fieve. Rove buka naebe fiero giaeva igege kenoeve. ");
INSERT INTO bbb_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ijadufuo na vierafe vua ije Asaea e Godido vua vierafena kuaemo fu isuibe kuaema ije fuka ma kuae. Ro vua ije fu kuaema ije bu ijiege isoe, Ja vua ije jane fieke rove vua ijiebuo maeje jabe mukoe vierafedufuo. Ro kuke jane giake rove irere ja giavo ije ja ma vierafekuva baki. ");
INSERT INTO bbb_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ijadufuo maeje e ijiebuo nigofo ije buneka mukoe irufui ro adane bu vua fiedufuo ije buneka korubuo bijukuriae. Ro kuke niome buone ije buka nisuiva ijadufuo bu ire bino giavo baki. Ro bu naebe ijiege rekuva bu bitie bu vame maeje giakinu ro vua maeje fieke. Ro kuke bu nigofo samadirekuva bu bitie una mukoreigia vierafena none roga nare amaeriake. ");
INSERT INTO bbb_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ro una e gure ja na nuvedievo ije fune Godire ni jone ijiakiro adane jone ijene mukoreigia amaeriaejiae. Ijadufuo jane mukoreigia giakinu ro vua none fiena vierafero nane ma Godido Fariro ja ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ro naka ma kuariavo igia fiefo. E Godido vua vierafena kuaevo boeje ro kuke e boeje bu Godido vame maeje ijiaru kenoeva ije buka vua maeje ige fiekuae karina ijafune. Ro kuke buka irere ige ja iviama giavo ijene giakuae ireobo ijafune. Rove ni buone ijia be buka naebe gae ro fie. ");
INSERT INTO bbb_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ijadufuo ni vua ije na abe e ije fu uije korenoema ijia mena kuariaeva ijadufuo maeje mukoe vierafeke na kuariafo. ");
INSERT INTO bbb_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ire uije gue bu duena vame ijia arivo ume ijiebe kari iva ijadufuo zinume maeje fu ijiege. E gue bu Godido vua maeje ige na izege Godi fu oe buone ije samuagiamo ije na kuariavo bune fie. Rove bu vua maeje bu naebe abe oe buone ijia nijave. Bu iko fieko fune Setanire kekena vua maeje ije fune abe vako ijene. ");
INSERT INTO bbb_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ro uije gue ije bu duena munuage ado sakae isekube namo ijia ariva ijeja e ije bu oemarekinu vua ije migegire fievo ijene. ");
INSERT INTO bbb_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Bu vua ije fie rove bu naebe abe oe buone ijia gikikimana vierafe. Ijadufuo e bu ise bino buone rena kame isekafiaga bu isejavaevo ijia buone ma vierafevo ije buneka migegire arevo ijene. ");
INSERT INTO bbb_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ro uije gue bu duena mibiamibia uve ijia arivo fiene ijiebe okuriaema ijeja e ije bu vua maeje fiekinu ro una izege bu ume igia oe marekinu karinoedufuo ije vierafevo ijene. Bu ijiege rekinu buka sinuome ro moni ireobo oetuakinu vierafevo ijare vua maeje bu fieva ije buneka toteve. Ijadufuo vua maeje bu fieva ije fu oe buone ijia tavuana ajia fo kiravo baki. ");
INSERT INTO bbb_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ro uije ije bu duena sakae ma ijia ariva ijeja e ije bu vua maeje fiena abe mukoreigia vierafevo ijene. Bu vua maeje fu oe buone ijia tavuana fo kiramoga buka uri vame maeje ma uruvana (100) renoe. Ro e gue bu sibaneke uruvana (60) reko gue bume sibaneke (30) ijiege revo. ");
INSERT INTO bbb_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu fu ijiege kuariama areme fu una kuke vua be ijiege mena kuariae. Fu kiae, Vame izege Godi fu e fuone ijiebuo oe ije samuagiamo ije fu e be juare fuone ijia uije mukore ije abe korema areme una are vaema ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Fune una vakoga muge be e boeje bune ni naokoga e ani be fu mauike kekena uije nibe ise ije abena uije maeje kafare ijia korema fune vae. ");
INSERT INTO bbb_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Areme uije maeje fune tavuana ajia fo fuone maeje amaerimo ijia e bu ijia sone uri uije ise ijene giae. ");
INSERT INTO bbb_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ijadufuo e fuone imejo ije bu usiaena kuae, E ireobo juare one aka uije maeje abe korei. Rove fiene nibe gure bu vame izege ijia tavuavono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Bu ijiege kuavoga fu kiae, Vame ije bu e ani none ijiebe revano kiae. Fu ijiege kuariamoga bu una gue kuae, Ro abe kuoga no va fiene ije boeje ka nafema kari koreno kuae? ");
INSERT INTO bbb_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","30","Bu ijiege kuaravoga fu kiae, Ja fiene mekuva jaka uije maeje ijiakuma nafeke. Ijadufuo ni ijia arega bu besu tavuafo. Na maza ije no ire uije kanafuivo ijia na e none kiaga bu ude fiene ise ije nafe ufuana kame miane ifaeje bu naoke. Areme bu uije maeje kanafuina una are none maeje ijia naejiekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu fu ijiege kuaria areme una kuke vua be mena kuariae. Fu kiae, Godi izege fu e fuone ijiebuo oe ije fu samuagiamo ije fu ire uije ka isekube ine sira sunine igeki e be fu abe oema ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ro ine sunine ije fuka isekube rove fu abe juare ijia okuma fu tavuana ka ine ireobo reke. Areme ume boeje bu ro ijia nae buone medufuo. Vame besu ijiege iviama Godido e ije bu sibaneke uruvana reve ro rade buka e ma uruvana una e fuone rekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu fu ijiege kuaria areme una vua bedua mena ijiege kuariae. Fu kiae, Iviama vame izege Godi fu e fuone ijiebuo oe ije samuagiamo ije fuka ire isiti fu remo ijiege reke. Bara ije fu ire farava ireobo disi ijia usiama ire isiti isekube abe ijiakuma biemarona nijakuma farava ije fuka ma ireobo ufe urikono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu vua fuone boeje fu e ije afuiva ije kuariaema ije bino fu naebe samadukua visuna kuariae. Ro vua boeje fuka ke mena kuariae. ");
INSERT INTO bbb_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ijadufuo vua izege e Asaea e Godido vua vierafena kuaemo fu isuibe kuaema ije fune ijiakuma riarei. Ro vua fu kuaema ije bu ijiege isoe, Na e ije vua kuariakuva nabe vua ijiebuo maeje samadukua kuariakiro vua boeje naka ke mena kuariake. Na vua maeje boeje sauiki ije Godi fu iko ire boeje ige naebe amaeriaema ijia bu sauina naovo ije naka kuariana nijasiaga bu fiekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Areme Jesu fune e ije ijia uniakona fune una are ijia aru vakogana e vua fuone fievo ije bune ijia nuvena aru vae. Bu usiaena kuae, Ni vua ije a abe fiene ijia mena kuariaema ijadufuo maeje kuaruo no fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Bu ijiege kuavoga fu una kiae, E ije fu uije maeje korema ijeja Ema ijiebuo Fari ige na. ");
INSERT INTO bbb_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ro juare ijeja aesakae boege ro uije maeje ijeja Godido e ije bu vame ma ijia kenoevo ijene. Ro fiene ijeja Setanido e ije ise renoejo ijene. ");
INSERT INTO bbb_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ro e ani ije fu fiene daejumo ije Setani. Ro maza ije uije kanafuivo ijeja maza radekuma ije Godi fu e ume ige ke mazie giadufuo ijene. Ro e ije uije kanafuivo ijeja Godido anera ijene. ");
INSERT INTO bbb_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ro fiene ije bu nafena uti miane ifaejevo ijiege maza radekuma ijia fu vame besu ijiege redufuo. ");
INSERT INTO bbb_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Maza ijia Ema ijiebuo Fari ige nare anera none ije kia bu aesakae boegia oenoeke. Bu Godido e ije fu oe buone ije samuagiamo ijiebuo uve ijia oenoekinu ire ise ije bu e ijiebuo ma vierafevo ije arafiriavo ijiakiro e ije ise revo ije kame miane ijia koreke. ");
INSERT INTO bbb_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Bu e ijene kame are ise miane naeno ijia ifaejega bu ijia naona niraekinu ubae sakinamike. ");
INSERT INTO bbb_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Areme e ije bu Godido vame maeje abeva ije bu Godi Asoe buone ijadufuo are fu samuamo ijia karike. Ro vajae buone ije buka mazani ije fu sanamo ijiege sanake bu ijia karike. Ijadufuo erare ja adanekikuva ni vua ige mukoe fiena vierafeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesu fu ijiege kuaria areme kiae, Godi izege fu e fuone ijiebuo oe ije fu samuagiamo ije fu ire gorodi be bu abena juare uve ijia mako runa nurieva ijieki. Bu abe nurievaga e be fu ijia juare menoena uri gorodi ije gana fune fuse una sakae atana okurama ijia arei. E ije fu ire ije gamo fuka oemaemoga fu una are ijia kekena sinuome fuone boeje karina una e guebuo fuaeve. Areme fune moni ijene kena una va e sakae kafare ije samuamo ije fuaevena fuone abei. ");
INSERT INTO bbb_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ro kuke Godi e fuone ijiebuo oe ije fu samuagiamo ije fu e ije fu mune ka ni mukore ije fuaevekiro rerenoeno ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E ije fu mune ijieki ije rerenoena be gakuma fuka oemareke. Fu oemarena una va sinuome fuone boeje kena una e guebuo fuaevena moni abena una mune mukore ije fuaevedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ro kuke igia fie. Godi izege fu e fuone ijiebuo oe ije samuagiamo ije fu ugie ije e bu abena do ona kijume binobino karavo ijieki. ");
INSERT INTO bbb_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bu ugie ije abe ona irega kijume bu ijia ivaema iritoejekuma bu meru dabe irifo ijia nijake. Areme bune karina kijume ije karana maeje bu kamui ijia kegaro ise ije bu kari koreke. ");
INSERT INTO bbb_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","50","Ijadufuo vakuma maza radekuma ijia vame ijieki ije fu reke. Godire anera ije kiaga bu arina aesakae boeje igia oenoekinu e kena atake. Bu atana e ise reva ije bu be uniagaro e ije vame maeje kenoeva ije bu be uniake. Areme bu e ije ise reva ije bu kame are ise miane naeno ijia korega bu ijia naona niraekinu ubae sakinamikono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu fu e vua fuone fievo ijene vua ijiege mena kuariama areme kiae, Ja vua boeje na kuariaeva ije jabe fievano kiamoga bu keno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ijadufuo fu una kiae, E akae nijasiamo be erare fu una Godi e ije fu oe buone ije samuagiamo ijena maziemo ije fu e are koeki igeki. E ije fu gire fuone ijia sinuome fuone boeje iviaeko ro isuiko ije fuka karina keke e boeje nijasiamo. Vame besu ijiege ro janika va e boeje Godido vua maeje isuiko ijiakiro vua none iviaeko ije kena ufake nijasiano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesu fu vua ijiege mena kuariama furina fune una are fuone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Fu ijia kekena va e Jiusibuo are isesina bu afuina vua kuaevo ijia aruna e ijia kariva ijene vua nijasiae. Fu vua nijasiamoga e bu vua fuone ije fievo buka oeseradiae. Ijadufuo bu una bue kuae, E ije fu izege vierafe mukore ijiakiro daro ije abena vame sumiki ije renoeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bu ijiege kuaekinu kuaevo, E ije fu Josofu e are samo ijiakiro bara fuone Meri e ije none giana vierafeva ijiebuo fari. Ro kuke fu e Jemisikina Josofu ro e Saemonikiro Judasi ijiebuo uvia. ");
INSERT INTO bbb_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","57","Ro makirafa fuone ije bu noena oenoejo ije none vierafe. Ijadufuo ire boeje fu izege ije renoeno kuaena buneka fu ijuone. Rove Jesu fu kiae, E are binobino ijiebe e ije Godido vua vierafena kuaemo ijadufuo vua ije buka mukoe fiena una fu irinavo. Ro una e agane fuone ijiakiro e sidove fuone ijia kariva ije buka una fu ijuoegafavono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ijadufuo Jesu fu sidove fuone ijia fu vame sumiki bino fu naebe uruvana rei. Ijadufuo maeje e fuone ije bu naebe fu ma vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Areme ve ijia e Erodi aesakae Gareri samuamo ije fu Jesudo vua ijene fie. ");
INSERT INTO bbb_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Fu fiena uri e fuone imejo ije kiae, Ire ijieki ije fu erare igia renoekuma baki. Ijadufuo na vierafe e ije fuka e Joni e do ruoriamo ijare una urina ire sumiki daroki ije remono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","E Erodi fu ijiege kuariaema ijadufuo maeje fure ude kiamo bu Joni fare tona mesiri dibure nujae. Ijadufuo maeje Joni fu maza boeje kuarana kua, Vame ije a uvia one Firifido bara Erodiase a abema ije aka akae tuasemano kuamo ijadufuo fu ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ro maza ijia Erodi fu vierafe fuka e fuone kia bu Joni kanaga fu baronekiro fu ijiege vierafe rove fu una e Jiusi ije jumei. Ijadufuo maeje e Jiusi ije bu ma vierafega e Joni fu ma e Godido vua vierafena kuaemo be. ");
INSERT INTO bbb_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Areme ve be e Erodido maza bu bieteva ije romoga e bu besu afuina ire i. Bu ire ikoga bara Erodiasedo kabae ije fu urina e boeje ijiebuo nidua ijia dua urumoga Erodi fuka oemae. ");
INSERT INTO bbb_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ijadufuo Erodi fuka uri e boeje ijiebuo niome ijia samadukua visuna bara ije kuae, A irere be vierafena kiekuma naka abe makono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Erodi fu ijiege kuaramoga bara ije fune izege asiefuo Erodiase fu ude kuaraema ijiege kuarae. Fu kua, Na vierafe aka iviama e kiaga bu va Joni e do ruoriamo ije kanana nigofo fuone ije ufuna abe tere ijia nijana abe ro mieno kuae. Bara ije fu Erodi ijiege kuaraema ijadufuo maeje asie fuone fu vierafe buka Joni kana fu baronekiro fu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Fu ijiege kuaramoga Erodi fuka ireobo oefiaemo fu arekiro vierafei. Rove fuka e boeje ire ivo niome ijia kuae, A ire be kiekuma na abe makono kuaema ijadufuo fume ijia rei. Ijadufuo Erodi fune e bijaevo fuone ije kiae, Ni va dibure ijia aru Joni kanana nigofo fuone ije ufuna abe una igia rono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ijadufuo e bijaevo ije bune vakuma dibure ijia usiaena Joni kana nigofo fuone ije ufui. Areme bune abena tere ijia nijana abe ro bara ije mavoga fune abena una asie fuone ije mae. ");
INSERT INTO bbb_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Areme rade e Jonido vua fievo ije bune va dibure ijia usiaena surive fuone abena va mako rui. Bu ijiege re areme bune vakuma Jesu fino ijia usiaena vua boeje izege bu reva ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Ijadufuo Jesu fu Jonido vua ije fiena fune uri vanage abena are etura ijia vae. Fu vakoga e boeje bune vua ije fiena uri are buone ije arena bune gue diake are fu vakiro vako ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Bu vakuma ijia usiaena karikoga Jesu fu rade vanage abena do ukua ijia urana vakuma ijia kekei. Areme fune ari kekena uri e boeje bu afuiva ije giana fuka buefuo oefiane abei. Ijadufuo fu urina e adagi boeje gue bu vaeva ijene adame buone ifejiana amaeriamo buka una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jesu fu e ijene ijiege ifejiakoke maza funeka kokiro reme. Ijadufuo e vua fuone fievo ije bu urina kuae, Are ige fuka etura ro kuke mazani gare fune gari kokiro vake. Ijadufuo ni e gure kiaga bu mazake va are gafia ire bu idufuo ije bino rerena fuaeveno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Bu ijiege kuarae rove Jesu fu una kiae, E ije na vierafe bube vakiro ni jare ire bino reregiana vajiaga bu ino kiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Fu ijiege kuariamoga bu una kuae, No ire ije fu bakiro no burete umui fague ro kijume inokiro ijiege igifureki ke ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ijadufuo fu urina kiae, Ni ire ije kari igia vajieno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Areme Jesu fune una dakude e boeje umui ijia vafiamo bune vajomado ijia ari kari. Bu ari karikoga fune uri burete umui fague ijiakiro kijume inokiro ije kei. Fu kena faradiaeme kake saove ijia Asoe fuone ije oemareja areme kena tuase. Areme fune kena e vua fuone fievo ije vajiamoga bu karina e boeje ijia kariva ijene vajiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Bu vajiavoga e boeje bu ire ije ivo fuka deufiavoga nugune ije bu e vua fuone fievo ijiebe kari. Bu karina tere ka uruvana tuero (12) ijiege utise. ");
INSERT INTO bbb_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ro e boeje ire iva ije e baru ijiaru bu daeva ije fuka ma uruvana faeve tauseni (5,000) ijiege. Ro bara ijiakiro ame isesina ije bu naebe ijiakuma dae. ");
INSERT INTO bbb_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Areme Jesu fune migegire e vua fuone fievo ije kiamo bu vanage be ijia ajiana bune do ije nafuema ijia urana gara vae. Bune vakoga Jesu fune gue uri e boeje vaeva ije kiamo bune una are buone ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bune vakoga fu gue una fuosukua uruo be ijia ajiana baname isoekiro vae. Fu va ijia fuosukua fina baname isoeko fune ve tituteme. ");
INSERT INTO bbb_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ro e vua fuone fievo ije buje bune vanage abena buneka do ukua garia vae. Ro kuke buka majaufi ireobo ije ufimo ijia vako ijadufuo do ije funeka ufena vanage ije dabe dakudekiro reme. ");
INSERT INTO bbb_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Areme Jesu fu ve naerema ijia fune uruo ije arena una arina do ado ijia bierena una e vua fuone fievo bu vako ijia biediakiro ruae. ");
INSERT INTO bbb_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Fu do ado ijia bierena ruomoga bu gana ka ireobo jumei. Bu vierafero fute barome ruomoro buka uri jumena vijei. ");
INSERT INTO bbb_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ijadufuo Jesu fu migegire kiae, Na nareno ibe jumekiro giriesano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ro Fita fu una gue kuae, E Ireobo a ije ane arega ni kiega na do ado guria bierena vuano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Fu ijiege kuamoga Jesu fu una gue kuae, Ni do ado ijia bierena rono kuae. Ijadufuo Fita fune vanage ijia arina una do ado ijia bierena Jesu ruomo ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Rove Fita fu una majaufi ireobo ije fu ufiko do ije fu ufeno ije gana fuka ireobo jumei. Fu ijiege jumekoga fune zinuivena gama arimo fu una Jesu kumei, E Ireobo na ifejiena kenujieno kumei. ");
INSERT INTO bbb_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Areme Jesu fune saroruba Fita umui kena kuae, Eko a zazaemo ijadufuo maeje one a ma vierafemo ije fuka isekube. ");
INSERT INTO bbb_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Bu ijiege rena bune una vanage ijia ajiakoga majaufi ije fu ufimo fune ijia arei. ");
INSERT INTO bbb_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Areme e boeje vanage guove ijia kariva ije buka uri fu augesana baname isoena kuae, No vierafe aka Godido Farino kuae. ");
INSERT INTO bbb_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ijiege rena bune vanage abena do ijia urana vakuma irifo gara are Genesareti kuavo ijia ari. ");
INSERT INTO bbb_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ro e are ijia kariva ije Jesu bune gana vierafe. Ijadufuo bu urina e ije are isesina ivuake ijia karinoeva ije vua nijiae. Bu vua nijiavoga bune urina e adagi boeje meruna Jesudo ruae. ");
INSERT INTO bbb_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Bu usiaena Jesu soesoe are fu kiaga bume ugone fuone ubine ijia niriaega bu una madiakuae bu ijiege rei. Ijadufuo e ije erarebe bu urina Jesudo ugone ubine ijia niriaeva ije adame buone ije funeka saroruba una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Areme e Feresi gue ro e vua akae nijasiavo ije bune Jerusareme ijia urina ruoma Jesu fino ijia usiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Bu usiaena kuae, E vua one fievo bu irerefuo vame isuiko asaerafa nuvuone ijiebuo no nuvediavo ije bu naebe ijia nuvediave. No asaerafa nuvuone ije bu ire ikuvejo ije ude buka umui do so areme ire ivo. Rove e one bu vame ije bu naebe ijiege renoeve. ");
INSERT INTO bbb_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Bu ijiege kuaravoga Jesu fu una kiae, Ro jadua ja irerefuo Godido vua ije jaka karatuakinu faememarena una vame jone isuiko ije renoeve. ");
INSERT INTO bbb_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ijadufuo maeje Godi fu kuae, Ame ije nika asieasoe jone ije aroriano kuae. Ro kuke erare fu vua ise bino una asieasoe ije kuariakuma nika kana fu baroneno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","6","Rove jare nijasiavo ije ja kuae, E be erare fu moni fuone bino fu ire fuaevena orafa fuone vajiakiro naejokuma ije fuka aregaro moni ije kena una Godi vajano kuae. Ijadufuo fu ijiege remo ije fu asoe fuone aguemo baki. Ja ijiege revo ijia ja Godido vua ije fu ja kuariamo ije jaka fiena faememarena una vame jone ijia renoeve. ");
INSERT INTO bbb_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","E gure ka iti kufuiki vua ijia marenoejo gurie, Na vierafe Asaea e Godido vua vierafena kuaemo vua irere fu isuibe joefuo kuaema ije fuka ma. ");
INSERT INTO bbb_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Ro vua fu kuaema ije bu ijiege isoe, E ije bume itire ijia kuae, No Godi aroevono kuae rove bu oe buone ijiakuma aroevo baki. ");
INSERT INTO bbb_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ro kuke baname buone bu isoena na vierafenoevo ije maeje fuka baki. Ijadufuo maeje bu Godido akae ije e nijasiavo bakiro bu ema ijiebuo akae ije kena e nijasiavono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Areme Jesu fune e boeje kumeno bu fuone rovoga fu urina kiae, Vua ige na kuariakuvejo ije mukoreigia fiena vierafedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ire ige no ivo fu ijare oe nuvuone kame umimiamo baki. Ro fune ire isekuma binobino no oe nuvuone ijia vierafena kuaenoevo ijare noka Godido nidua ijia naebe maturaemavo kiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Areme e vua fuone fievo ije bu urina kuae, No vierafe vua ije a kuaema ije e Feresi buka naebe oemarevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ijadufuo Jesu fu una vua be ijiege mena e ije kuariae. Fu kiae, E Feresi ije bu uije Asoe none saove gufia fino ijare oema baki ijieki. Ijadufuo rade bu uije ijene gire gamia nafeke. ");
INSERT INTO bbb_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ijadufuo ja buefuo jade ireobo vierafevo. E Feresi ije bu oenoekinu una e gue kaenamiana vame buone ijia vako ije buka e ni kuzeki. Ijadufuo maeje e be fu una be umui kena vakuma bu buosiki buka mako urakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Fu ijiege mena kuariamoga Fita fu una kuae, Ni vua ijadufuo maeje kuaruoga no fieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ijadufuo Jesu fu e vua fuone fievo ije kiae, Ja e boeje bu totenamiko jadua jaka uria totenami. ");
INSERT INTO bbb_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ro ni igia fie, E ije ire fu ino ije fu itire ijia iga fu ari devatua ijia kekena ro na vako. ");
INSERT INTO bbb_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ro vua irere fu oe fuone ijia vierafemo ije fu itire ijia kuaemo. Ijadufuo irere fu oe fuone ijia vierafemo ije fu isekuma ijare fu Godido nidua ijia fuka naebe maturae. ");
INSERT INTO bbb_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","E ije fu oe fuone ijia ire ise vierafemo ije fu e kaniaga bu oekinu ebuo bara turakinu ebuo sinuome iniemeno. Ro kuke fu vua kufuime kuaekinu una e guebuo vua ise kuaemo. ");
INSERT INTO bbb_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E ire ijiege renoeno ije fu Godido nidua ijia fuka maturaema baki. Ro ije una umui do naebe soma ire ino ije fu Godido nidua ijia ise remo bakino kiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesu fu ijiege kuariama areme fune e vua fuone fievo ijena are Genesareti arena bune una urina are Taeakiro Saedoni ivuake ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Bu ijia vakoga bara Keinanaetiko be are ijia fino ije fu kekena Jesu vijekinu ruae. Fu ruakinu kume, E Ireobo e Devidido uifari gafe, a na oefiadakuma ni ifejiene. Na kabae none fu kavene ise ijare dabe nirokoke funeka mukoreigia isejavaemono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Rove Jesu fu naebe una vua bino kuarae. Ijadufuo e vua fuone fievo ije bu uri Jesu soesoena kuae, Bara ije fuka kumekume ruako noka iseduomono kua fu vano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Bu ijiege kuarae rove Jesu fu una bara ije kuae, Godi fu kiemo na ruaeva ije na e Isureroko ijiaru ifejiakiro ruae. Na e Isureroko ije bu mave-sifi igege buosukua oefiaeguma giegisa oenoejo na ije ifejiakiro ruaevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ijadufuo bara ije fu uri nidua fuone augesana kuae, E Ireobo ni na ifejieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Rove Jesu fu una gue kuae, No ame isesina ijiebuo ire ije no kamaziana una siroe buone ije vajiakuva fuka naebe marekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Jesu fu bara ije ijiege kuaramoga fu una kuae, E Ireobo, ije ane ma kuarieme. Rove na vierafe siroe ije buka uria e bu samuagiavo ijiebuo fata rotire ijia ire nugune ije duena arivo ijene ikono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ijadufuo Jesu fu una gue kuae, Bara gure one a na ma vierafema ije fuka ma ireobo ijadufuo irere a vierafema ije na ifejakono kuae. Jesu fu bara ijene ijiege kuarakoga maza besu ijia kabae fuone fune una mae. ");
INSERT INTO bbb_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Areme Jesu fune are ije arena uri e vua fuone fievo ijena do Gareri nafuema irifo ijia ufuaena vae. Areme fune uruo be ajiana vakuma makave ijia fikoga ");
INSERT INTO bbb_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","e ka uruvana bu e adame binobino abeva ije kaenamiana fuone ruae. Bu e aekirariaeva ijiakina ni kuzeva ro itibireva ijiakina e adame abeva ijene kaenamia ijia ruae. Bu kaenamiana usiae Jesu fino ijia uniavoga fu amaeriamo bu una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jesu fu ijiege amaeriamoga e ije ae kirariaeva ije bune una uri oenoeko e ni kuzeva ije bu una ni nafaekoga e itibireva ije bu una vua kuae. Fu ijiege remoga e boeje bu ije giavo buka oeseradiamo bu uri e Isureroko ijiebuo Godi ijene dabe aroe. ");
INSERT INTO bbb_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Areme Jesu fune uri e vua fuone fievo ije kiamo bune una besu afuivoga fu kiae, Na e gure bu afuiva ije giaga naka buefuo ireobo oefiadie. Ijadufuo maeje bu maza inokubeke naena igia kari ijadufuo na vierafe buka ire baki. Ro na ire bino naebe vajiaga name kia bu una are buone ijia vakuva bubite nibuariana ari kaniakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jesu fu ijiege kuariamoga e vua fuone fievo ije bu una kuae, Noka are etura ire baki igia kari. Ijadufuo no izia ire kena e gure gorumiakono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Bu ijiege kuaravoga Jesu fu kiae, Ro ja burete bino ijia naevano kiae? Fu ijiege kiamoga bu kuae, No burete seveni ro kijume isesina sibaneke naevano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Areme Jesu fune e boeje kiamo bu ume ijia ari kari. ");
INSERT INTO bbb_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Bu ari karikoga fune uri burete ijiakiro kijume ije kena una Asoefuo oemarei. Areme fune ke tuasena una e vua fuone fievo ije vajiamo bu karina e ije vajiae. ");
INSERT INTO bbb_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Bu vajiavoga e boeje bu ivo buka deufiamo nugune gue bu iremare. Areme e Jesudo vua fievo ije bune urina ire nugune ijene karina tere seveni (7) ijiege uti. ");
INSERT INTO bbb_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ro e boeje bu ijia ire iva ije e baru ijiaru buka e fo tauseni (4000) ijiege. ");
INSERT INTO bbb_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Areme Jesu fune urina e boeje kiamo bune una are buone ijia vakoga fu gue uri vanage abena fune aesakae Magedara ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Areme maza be e Feresi ijiakiro e Sejusi gue bu Jesu biesirikuae ruae. Bu ruoma fu fino ijia usiaena kuae, A vierafega ane ma Godire kuamo a ruaejoga ni vame sumiki be niome nuvuone ijia rega no gana una a ma vierafeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bu ijiege kuarae rove Jesu fu una vua be ijiege bijana kuariae. Fu kiae, Ja oenoena fu ve jiaena saove garia kavuaega ja kuae fu ve marekuveno kuaevo. ");
INSERT INTO bbb_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ro suoke fu saove garia kaziga ja kuaevo fu ve ireobo dakuveno kuaevo. Ijadufuo ja mazani gare fu ve dakuve ro baki ije jane saove garia izege fu remo ijia gana kuaevo. Ro iviama na igifureki ire sumiki bino renoeko jane gieve rove ja ire ijiebuo maeje jaka naebe mukoe giana vierafeve. ");
INSERT INTO bbb_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","E gure ka isema renoekinu Godi ma vierafevo baki gure, jare ire sumiki be gakuae vierafei. Rove na vierafe nabe vame sumiki be rega ja gadufuo. Ro na vierafe name ire sumiki besu fu Jona e Godido vua vierafena kuaemo ije fuone rema ijieki be rega ja gakono kiae. Jesu fu ijiege kuaria areme fune e ije uniana vae. ");
INSERT INTO bbb_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Fu vakoga e Jesudo vua fievo ije bu uri vanage be abena do ije nafuema ije urana irifo gara vae. Ro maza ijia bu totiamoga burete bino bu idufuo ije buka naebe kena vae. ");
INSERT INTO bbb_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ijadufuo bu mauike buone karina una ijadufuo kuaeve. Bu ijiege karina kuaevo Jesu fu giana uri kiae, Ja oenoekuva ni e Feresi ijiakiro e Sejusi ijiebuo ire isiti ije mukoreigia akariafo. ");
INSERT INTO bbb_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jesu fu ijiege kuariamoga bu vierafero fubite burete bu naebe ke vuaeva ijadufuo kuaemoro bume mauike karina una bue kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Rove Jesu fune giana uri kiae, E gurie jone ma vierafevo ije fuka ma isekube. Nana ma burete ja naebe ke ruaeva ijadufuo kuariavo baki. Ro ja irerefuo una vua ijene dabe kuaeve? ");
INSERT INTO bbb_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Jaeje ja naena besu oenoeve rove jaka uria naebe mukoe vierafei. Ja burete faeve ka sibaneke ije na ke tuasena e boeje faeve tauseni (5,000) na gorumiaeva ijiakiro ire nugune ja tere ijia utiva ije jabe vierafei? ");
INSERT INTO bbb_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ro kuke ja burete seveni ije na ke tuasena e fo tauseni (4000) ije gorumiaeva ijiakiro ire nugune ja tere izege utiva ije jabe vierafei? ");
INSERT INTO bbb_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ja vame ije jane gie rove ja irerefuo naebe mukoe vierafei? Ro burete ije bu ire isiti ijiakuma amaeriavo na kuariaeva ije na ma ijadufuo kuariaeva baki. Ro name e Feresi ijiakiro e Sejusi ijiebuo vame ka ise bu kenoevo na ijadufuo ire isiti ijia mena kuariae. Ijadufuo ja ije vierafena mukoreigia giakinu oenoekiro jade una vame buone ka ise bu vierafena kenoevo ijia nuvediavono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Areme e vua fuone fievo ije bu ijia sone una vua maeje vierafei. Bu ijia vierafero fu ma ire isiti ijadufuo kuaema bakiro fu bure e Feresi ijiakiro e Sejusibuo vame bu nijasiavo ije akariakiro kuaemaro bu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Areme Jesu fune e vua fuone fievo ijena vakuma aesakae Sesaria Firifae ivuake ijia kekei. Fu ijia kekena uri kiae, Ja vierafega e bu Ema ijiebuo Fari ige na giekuva bu era vierafekono kiae? ");
INSERT INTO bbb_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Fu ijiege kuariamoga e vua fuone fievo bu una kuae, No vierafe e gue bu a gana vierafero a Joni e ije e do ruoriamo ijero bu ijiege vierafe. Ro gue bu vierafero a e Iraeja ro gue bu kuae a e Jerimaea ro ba a e Godido vua vierafena kuaemo beno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Bu ijiege kuaravoga Jesu fu una kiae, Ro jaeje ja izege vierafevano kiae? ");
INSERT INTO bbb_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Areme e Saemoni Fita fu una kuae, Na vierafega aeje aka Godi ije maza boeje ijia fivako ijadufuo Fari. E ije bu isuibe kuae fu ruakono kuaema ijeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Fu ijiege kuaramoga Jesu fu una kuae, E Saemoni e Jonado fari gare, na vierafe fune Godire a marejae. Ijadufuo maeje bu e binobe nijasaeva bakiro fune Asoe none saove gufia fino ijare oe one ijia vua ije vierafejamo a kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ijadufuo igia fie, Aeje iviama ive one na Fita kuake. Ro ive ijadufuo maeje tugie ka gikikima ijene. Ijadufuo na e none na ma vierafevo ije na kena a uniaejake. Na uniaejaga are samuagiaga buone ma vierafevo ije fuka gikikima reke. Ro Setanido e ije buka daro bakido bu vame one a kenoeno ije bube bijukuraejake. ");
INSERT INTO bbb_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ro kuke nare a daro maga a Godido vame maeje abe e boeje kuariana nijasiakinu samuagiake. Ro irere bino e bu ume igia renoejo ije a giaga fu isega a kuriaerena vafiamo ije Godi saove gufia fino ije fudua fu ijiege kuriaerena vafiake. Ro irere a giaga bune marega a oemareko bu renoejo ije Godi saove gufia fino ije fudua ijiege oemarejiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Areme Jesu fu uri e vua fuone fievo ije kuriaerena kiae, Jade va e gue kia nana Kuraesi e ije bu kuae fu ruakono kuaeva ijeno kuariakuvano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Areme Jesu fune ve ijia zinuivena uri fu baronedufuo ije fuka samadukua visuna e vua fuone fievo ije kuariae. Fu kiae, Na vierafe naka Jerusareme ijia e mamekanu nuvuone ro e akae nijasiavo ro e Godi zinone ifaejevo ije kariva ijia vake. Na ijia vaga bu na dabe vame ise binobino ijia arafiriena vajae fiane vajiega naka vajae fiane urukeigia abena isejavaeke. Na isejavaena vakuma buka kaniega na baronero mu inokubeke furike Godi fu kiega na una urikono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Areme Fita fuka uri Jesu umui kena va fuebe kekena kuae, E Ireobo vua ije na vierafe aka isema kuae. Na vierafe Godi fube ire ise ijieki ije kuaga fu one rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Fu ijiege kuaramoga Jesu fu una dakudena Fita kuae, Setani garege vane. Na gaga aka i ije Godi fu kiemo na mekiro ruaeva ijene bijukurieme. Ijadufuo maeje vua ije a vierafena kuariemo ije fu Godire vierafejaema baki. Ro vua ije ame ema are vierafena kuariemono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Areme Jesu fune una e vua fuone fievo ije kiae, E be erare fu dia makae none ijia nuvediekiro vierafekuma ni ire fuone boeje ume igadufuo ije ka ijuoegafiadufuo. Areme fu uri vajae fiane binobino bu fuone ruovo ijia ka uria faememarena noefuo imedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ijadufuo maeje erare fu una fuone izege fu ma fivadufuo ijiaru uruke vierafenoeno ije fu rade vame ma karivako ije abekuma baki. Ro erare fu maza boeje una e gue oetuana ifejiamo ije rade fu vame ma karivako ije abeke. ");
INSERT INTO bbb_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ro erare fu ume igadufuo sinuome ije uruke oetuagaro Godi fu ijuonemo e ije kavene fuone ije fune dabe abueme. Ro kuke fu ume igadufuo sinuome ijiebe ifejaga fu vame ma kari vako ije abekuma baki. ");
INSERT INTO bbb_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ijadufuo maeje Ema ijiebuo Fari ige nare maza radekuma ijia anera none ijena una Asoe none ijadufuo sanaema ijiakuma ruake. Areme na uri e besubesu izege bu kenoeva ijia giakinu ire maeje ro ire ise ije buone rejiadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ro vua ige naka ma kuariavo fiefo. Iviama e gure ja kariva ijia e gue jaka oe furidufuo. Ro gue ja ni uria kariva ijia Ema ijiebuo Fari ige na una Kini rena e boege samuagiakiro roga ja giekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Areme maza sigisi ijiege furikoga Jesu fune uri Fitakiro ino uviaki e Jemisikiro Joni ijene kaenamiana uruo ka ireobo be ijia ajia vae. ");
INSERT INTO bbb_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Bu ijia ajiana ire gakoga Jesudo vajae boeje fuka una nibe rei. Nikubae fuone ije fuka maza igege nakoga ugone fuone ije buka abaekirama ire bivare ije bu abe mazani ijia karavo ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Areme e inokubeke bu gake e Mosisikiro Eraeja bume saroruba ije bu ireva ijia Jesuna irena vua kuaevo bu giae. ");
INSERT INTO bbb_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijadufuo Fita fu uri Jesu kuae, E Ireobo aka magoe no kaenamuo igia ruae. Ijadufuo a vierafe fube maredo na are muvuaka inokubeke be one ro be Mosisido ro be Eraejado ijiege igia sano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Fita fu uria ijiege mani kuaemo ijia amite ka abaeki ijare e boeje bu ireva ije foteke okuriae. Areme Godi fu amite guove ijia kumei, E ije fu Fari none ma na ireobo oetuavo. Na i fu menoeno ije gaga naka ireobo oemadie ijadufuo ni vua fuone ije mukoe fieno kumei. ");
INSERT INTO bbb_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","E Jesudo vua fievo inokubeke bu vua ije fievo buka judiae ijadufuo bu tuana ume ijia dijena niome buone kame saui. ");
INSERT INTO bbb_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Bu ijiege revoga Jesu fu kekena umui karakinu kiae, Ja jumevo arekiro urino kiae. ");
INSERT INTO bbb_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Areme bu uri gake e inokiro ije bu bakiro fu Jesure fuosukua ijia manino bu gae. ");
INSERT INTO bbb_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ijiege re areme bune una uruo ijia ari vako ijia Jesu fu kiae, Ja ire gufe fu remo ja gaeva ije jade va e gue kuariavo. Jani areke Ema ijiebuo Fari ige na baronenaro una uriga ni ijare kuariano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Fu ijiege kuariamoga e vua fuone fievo bu una Jesu kuae, E vua akae nijasiavo ije bu kuae fu e Eraejare ude una ruakono kuae. Ro ije bu irerefuo ijiege kuaevano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ro Jesu fu una kiae, Ke ije ja ma kuae. Fu e Eraejare ude ro ire boeje mukoreigia kanafuina urari nadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Rove igia fie, e Eraeja vareki be fune ude ruae rove e bu naebe fu mukoreigia gana vierafei. Ro buka uri ire ise boeje binobino fuone rei. Ijadufuo Ema ijiebuo Fari ige nadua buka dabe vame besu ijiege ise binobino none rekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Areme e vua fuone fievo ije bu maza ijia sone vierafero fu Joni e do ruoriamo ijadufuo kuaemoro bu ijiege vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bune ijiege kuaekinu una ari ruoma e gume bu afuiva ijia usiaevoga e be fu migegire kekena Jesu manino nidua ijia auge sae. ");
INSERT INTO bbb_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Fu augesana kuae, E Ireobo a fari none gaga fu oefiadakuma ni ifejane. Fu kavene ise ijare nirona dabe arafirikoke fuka iti sabaefuigakinu isejavaeme. Fu ijiege rekinu ro maza bino fu kavene ise ijare dabe miane ijia akoega fu miane naekinu ro maza bino fuka do urame. ");
INSERT INTO bbb_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ijadufuo na mesiri e vua one fievo ije nijasiae rove bu ifejakuae rega buka naebe manimano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Fu ijiege kuaramoga Jesu fu uri kiae, E gure ka totenaminoekinu Godi ma vierafevo baki gurie igia fiefo. Ja vierafega na juaevasia izege jaena finoeke ja ijia una Godi ma vierafeke? Ame ije mesiri igia roga na gano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Fu ijiege kuariamoga e ije fune ame ije mesiri romoga Jesu fu uri kavene ise ije kuriaerena rorukurae. Fu ijiege rorukuramoga kavene ise ije fune ame ije arena keke vakoga saroruba ame ije fu una mae. ");
INSERT INTO bbb_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Areme e Jesudo vua fievo ije bune mauikeigia una ro Jesu kuae, Kavene ise ije nore ude rorukurae ro fu irerefuo naebe keke vaemano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Ro Jesu fu una kiae, Ijadufuo maeje Godi jaka ireobo vierafevo baki. Naka ma kuariavo igia fie, Jone ja Godi ma vierafevo ije fuka isekube ine sira sunine ijiekikuma ije jane mani. Ja manido ja uri nafare ije kuako, Ni nafe bio garia manino kuakuva fu ijiege reke. Ijadufuo ja ma vierafekuva ja manido ja ire boeje renoedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","23","Areme e vua fuone fievo ije bune una Gareri ijia besu afui. Bu besu afuivoga Jesu fu uri kiae, Iviama igiebure e bu Ema ijiebuo Fari ige na toenamiena dabe una e ise ije miake. Areme e ije bu dabe kaniega na baroneke. Rove maza inokubeke furike Godi fu kiega na una urikono kiae. Fu ijiege kuariamoga e vua fuone fievo ije buka ma ireobo oe fiane abei. ");
INSERT INTO bbb_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Areme Jesu fune e vua fuone fievo ijena ruoma are Kafoniamu ijia usiae. Ro e ije Godido Are ireobo ijadufuo moni ije karinoevo gue bu ijia usiae. Bu usiaena uri Fita kuae, A vierafega e ireobo one e nijasiamo ije fube moni ije bu Godido Are ireobo ijadufuo abievo ije ifejiana abiemono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ro Fita fu una kiae, Ke ije moni fu abiemono kiae. Fita fu e ije ijiege kuarianaro fune are ijia aru vae. Fu uria iko aru vakoga Jesu fu gafa urina kuae, Fita e vua gafe bu kuaraeva ije aeje a izege vierafemano kuae? A vierafega e mamekanu aesakae gue samuagiavo moni ije bu kiaga e bu oenoekinu karinoevo ije bu erado moni ije karinoeve? A vierafega bu anafa buone ijiebuo moni ke bu e aesakae binoko ijiebuo moni ije karivono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Jesu fu ijiege kuamoga Fita fu kuae, Moni ije bu e aesakae binoko ijiebuo karivono kuae. Areme Jesu fu una kuae, Ke ije aka ma kuarieme. Na vierafe e mamekanu aesakae samuagiavo ijiebuo anafa ije bu takesi abievo baki. Vame besu ijiege nadua na ma Godido Fari ijadufuo na irerefuo una Are fuone ijadufuo takesi abiekuva baki? ");
INSERT INTO bbb_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Rove no naebe moni abiekuva na vierafe e takesi karivo ije bute no ziegafuodufuo. Ijadufuo ni va davare ijia kimae sana kijume bino karane. A kijume amure be kekuma a itire fuone ijia moni be gadufuo. Areme ni moni ije abena va takesi abiene. Ro moni ije na vierafe fune takesi one ro none ije fune sibane manikono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Jesu fu ijiege kuariakoga maza besu ijia e vua fuone fievo ije bu una kuae, A vierafega e ije Godi fu oe buone ije samuagiamo ijia erare fuka e anuigino kuae? ");
INSERT INTO bbb_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Bu ijiege kuaravoga Jesu fu urina kiamo bu ame iseke ije mesirina ruae. ");
INSERT INTO bbb_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Areme fu kuamo ame iseke fu e boeje ijiebuo nidua ijia manikoga Jesu fu urina kiae, E besubesu ja irerefuo e anuigi rekuae vierafe? Naka ma kuariavo fiefo. Ja naebe vame jone ja e maki igege vierafena aroekarakinu kenoejo ije arena una ame iseke fu kabuaekabuaeki kenoeno ijiege kenoekuva ja izege una e ije Godi fu oe buone ije samuagiamo ijena mazieke. ");
INSERT INTO bbb_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ijadufuo e ije Godi fu oe buone ije samuagiamo ijiebuo uve ijia e anuigi redufuo ijeja e ije fu una ame iseke igege kabuaekabuaeki renoeno e ijare fuka e anuigi. ");
INSERT INTO bbb_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ijadufuo erare fu ame iseke be ive none ijia oemarekinu mesirimo ije fu kuke nadua oemarejiekinu mesiriemono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ro erare fu e ije bu ame isesina igege na ma vierafevo ije kame arafiriaga bu una ise renoekuva e ije ni mune ireobo be dabe uro fuone ijia kirana davare ukua ijia urana do idufuo. ");
INSERT INTO bbb_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ro e ume igia oenoevo ije isekijo. Ijadufuo maeje e ise renoejo ije bu una e gue biesiriakoke buka vame maeje arena una vame ise ije renoeve. Rove igia fie, e ije bu ijiege ise renoeve rove maza rade Godi fuka bu kame vame ise ijia isekafiakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Areme Jesu fu uri vua bino ijiege mena kuariae. Fu kiae, E be erare a vierafega fu umui one ro ba diatare one ijiebe a mesira dabe ise revoga na vierafe aka bino kaniatura koredufuo. A vierafe aka Godido vame maeje abekiro vierafekuma ni vajae one gue bu ise renoevo ije kena ijiege kaniaturane. A ijiege rekuma ije funeka maredufuo. Ro a naebe ijiege rekuma vajae one foteke ije funeka are ise miane naeno ijia vake. ");
INSERT INTO bbb_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ro kuke a vierafega fu niome one ijare a mesirana ise revoga ni niome one be nafe akoene. A ijiege rekuma ije fuka maredufuo. Ro a naebe ijiege rekuma niome besu ijare a dabe are ise miane naeno ijia akoega a ijia isejavaekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Jesu fu ijiege kuaria areme kiae, E ije bu ame isesina igege na ma vierafevo ije jade oenoekinu ni ikene giavo. Ijadufuo maeje na kuariako fie, e ijieki ijiebuo anera ije bu samuagiavo ije budua buka Godido nidua ijia oenoejo. Ijadufuo vame izege ja bu kame binobino renoejo ije mukoe vierafekinu renoedufuo. ");
INSERT INTO bbb_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ro na vua be bijana kuariako ni fiefo. E be fu mave-sifi fuone uruvana uvani aderedi (100) ijiege samuagiamo. Ro maza be mave-sifi ije ireva ijia besu fu oenoene sauikuma e ije ja vierafe fu izege redufuo? Fube kuaeko ije fune maremano are fu ijia oenoena baroneno kuaeke? ");
INSERT INTO bbb_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Fu ijiege rekuma baki ro fuka mave-sifi gue naenitinaeni (99) ije fu ijia unia areme va besu ije sauima ijene rerenoena gakuma fuka ma ireobo oemaredufuo. ");
INSERT INTO bbb_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Vame besu ijiege Asoe jone saove gufia fino fu e ije bu e isesina igege na ma vierafevo ije buje fuka ijiege vierafemo. Fu e ijieki ije besu fu va sauidufuo ije fuka naebe ijiege vierafemono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Jesu fu e boeje vua ijiege kuaria vakuma kiae, A uvia one be osiki Jesu ma vierafemo fu ise be a fake rekuma ni sone va mauike fuosiki besu karina kuaedufuo. Ro a kuaraga uvia one ije fune una oemarekinu vua one fiekuma ije jane una besu iviene uvia igege kafaenoeke. ");
INSERT INTO bbb_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ro a kuaraga fu naebe una oemarekinu vua one fiekuma ni va e besu ro ba inokiro ijiege kaenamia una va gane. A ijiege e inokiro kaenamia vaekina bu vua izege a fuosiki kuaemo ije ifejana kuaeke. ");
INSERT INTO bbb_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ro fu kuke e ijiebuo vua ije fu naebe oemarekinu fiekuma ni va e ije Godi ma vierafevo ije giadufuo. Ro gaga fu ijiakuma naebe oemarekuma nika kuriaerena kuaga fu va e ije Godi naebe ma vierafevo ijena finoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Jesu fu ijiege kuariavako ijia fu kuke kiae, Vua ige naka ma kuariave. Irere e bu umeigia renoega a vierafero fu ise ro a vafiamo ije Godi saove ijia fino ije fudua fu ijiege kuriaerena vafiake. Ro irere bu renoega a giana vierafero fu maro a oemareko bu renoevo ije Godi saove gufia fino ije fudua fu besu ijiege oemareke. ");
INSERT INTO bbb_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ro kuke igia fie, Ja e inokiro umeigia oenoene ire binofuo oe besu vierafena Asoe none saove gufia fino ije baname isoena kuakuva fuka fiena ifejiake. ");
INSERT INTO bbb_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ijadufuo maeje e inokiro ro inokubeke bu ive none ijia besu afuikuva na buina ijia fikono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Areme Fita fu urina Jesu kuae, E Ireobo, uvia none be fu nosiki Jesu ma vierafemo fu ire ise be none rekuma na gana areke. Ro fu uria faememarena maza boeje none ise rerukuma nabe maza seveni ijiaru gana arekono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Rove Jesu fu una kuae, Uvia one ije fu afake ise rega a maza seveni ijiaru gana arekuma ije na vierafega fuka naebe marei. Ro kuke a maza seveniti (70) ijiege gana arekuma ije dua fuka naebe marei. Ro fuka maza boeje uria faememarena una ise rerukuma nime gana oe one ijia areno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Areme Jesu fu vua be ijiege mena kuariae. Fu kiae, Godi izege fu e fuone ijiebuo oe ije fu samuagiamo ije fu ijieki. E kini be fu maza be vierafe fuka e fuone imevo ije kiaga bu fuina besu karina sinuome gue bu keva ijene kuaena amaerikiro vierafei. ");
INSERT INTO bbb_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ijadufuo fune urina ijiege rekoga bu e be ije fu sinuome ka moni ma ireobo ijiege kema ijene mesirina fuone ruae. ");
INSERT INTO bbb_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Fu kekena uri sinuome ije fu kema ijadufuo moni ije una e kini ijene fuaevekuvega fuka naebe manimo fu ijia arei. Ijadufuo e kini ije fu urina e fuone imejo gue kiae, Na vierafe ja e guriakiro agebara ro sinuome fuone boeje ka kena una e guebuo fuaevedufuo. Areme bu moni ije vajiaga ni kena ro sinuome ige fu karima ije fuaeveno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","E kini ije fu ijiege kuaemoga e ije fu vua ije fiemo fuka ireobo oefiae. Ijadufuo fu uri e kini ijadufuo nidua ijia augesana soesoe. Fu soesoena kuae, A isekie ni sone oe vafaena fike na oenoega moni bino biediekuva na una ro vajano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Areme e kini ije fu vua fuone ije fiena fuka una fuone oefiane abei. Ijadufuo fu kuamo fu naebe una moni ije fuaeve ro fume ijia arena keke vae. ");
INSERT INTO bbb_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Rove fu va oenoena areme una kai fuone be fu ude moni fuone isekube kuamo fu vajaema ije bie. Fu biena keke uro ijia farena kuae, Eko iviama migegire moni none a ima ije una vajieno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Fu ijiege kuaramoga kai fuone ije fu una kuae, Kaino a isekie, ni sone oe vafaena fike na oenoega moni bino biediekuma na una ro vajano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Rove e ije fu naebe una kai fuone ijadufuo oefiane abei fuka faememarena fare dabe dibure nujae. Areme fu kuae, Ni ijia fikinu moni none a ima ijene una fuaevena furi areme nine keke vano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","E ije fu ijiege remogana e kairafa gue bu gavo buka oefiadiae. Ijadufuo bu una va e ije izege fu rema ijene e kini ijene kuarae. ");
INSERT INTO bbb_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Areme e kini ije fune kiamo bu e ije mesiri rovoga fu urina kuae, E gure aka e ma baki aka e ise. Aka moni none ireobo abe i. Rove aka soesoemoga na kuavo a ijia arena vae. ");
INSERT INTO bbb_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nana a gavo fuka oefiadie ijadufuo na kuavoga a naebe una na fuaeve ro a ijia arena vae. Ro a irerefuo naebe una uvia one izege na reva ijiege una fuone oefiane abemano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Areme e kini ije fuka uruke defarui ijadufuo fu kiamo bu e ije fare dabe dibure nujavoga fu ijia fina isejavaekinu vajae fiane abei. Fu ijia fikinu kini ijadufuo moni fu ima ijene una fuaevena furimano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesu fu vua ijiege bija kuariama furikiro kiae, Ja e boeje ja e ise ije fu kema ijiege ja naebe kairafa jone ijiebuo ise ije mauike giana oe jone ijia arekuva fuka naebe mareke. Ja ijiege rekuva Godi Asoe none saove gufia fino ije fudua fu ise jone ije fube giana arekiro fuka kame vame ma ise ijia isekafiakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesu fu vua boeje kuariama furi areme fune uri Gareri arena are Judia guove do Jodeni ruvaema irifo gara ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Fu ijia vakoga e boeje bu nuvena ijia vako fu adame binobino bu abeva ijene amaeriamo bu una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Fu ijiege renoeno ijia e Feresi gue bu ro usiae Jesu biesirina kuae, A vierafe akae nuvuone fu kuaema ijiege e be fu bara fuone fu ire binobino naebe fu oemaedufuo ijia kenoekuma fube ijuonena rorukuraga fu vakono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Rove Jesu fu una gue kiae, Ro ja buki kafare be bu isoena kuae, Iko zinume ijia Godi ije ire boege amaeriaema ijare baru bara amaeriaemano kuaema ije jabe dana gae? ");
INSERT INTO bbb_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Ro kuke buki kafare be bu ijiege isoena kuae, E fari ije fu uri asoe fuone ijiakiro asie fuone ije arena una bara fuone abeke. Bu ijiege maninamina besu karinoejo ijia bu una buobiki vajae besu rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ijadufuo bu buobiki bu inokiro baki ro buka vajae besu. Ijadufuo bara ije Godire abena una e fari ijiaki besu maziema ije e bino bube ke atana binobino uniakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesu fu ijiege kuaemoga e Feresi ije bu urina kuae, Ro irerefuo Mosisi fu kuae, E be fu bara fuone ijuonena rorukuraga fu vakuma fu fefa be isoena kua, Ivia aeje a bara none bakino kuana abe maga fu vano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Bu ijiege kuaravoga Jesu fu urina kiae, Vua ije Mosisi fu isoena kuae ja bararafa jone rorukuriano kuaema ijadufuo maeje oe jone fuka ma gikikimana. Rove iko zinume ijia vame ije bu naebe ijiege rena ruae. ");
INSERT INTO bbb_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ro na kuariako fiefo. E be fu bara fuone abe ro rade fu ijuonena rorukuraga fu una bara be abekuma e ije fu bara ijene daturame. Ro bara fuone amure ije fu baru be naebe daturae ro fume rorukurakuma fuka naebe marekono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesu fu ijiege kuariamoga e vua fuone fievo bu una kuae, Ro a vierafega vame ije e bu bara kena ro rorukuriaga bu vako ije fuka gikikimanakuma no vierafe barubara maninamivo ije buka arekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Bu ijiege kuaravoga Jesu fu una kiae, Na vierafe e boeje bu vua ije a kuaema ijiege kenoekuva baki. Ro bune e ije erarebe Godi fu ifejiaga bu ijiege amuinamuigi oenoevo ijiebe ijiege renoeke. ");
INSERT INTO bbb_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ro irerefuo e fari gue bu naebe bara kevo ijadufuo zinume maeje bu binobino. E gue bune ijiege nafiae ro gue ije bune emabe ke ijiege amaeradiae. Ro e gue bu naebe bara kevo ije bu Godido imekuae bu ijadufuo akae oenoe. Ijadufuo e be erare fu vierafe fu manido fu ijiege bara baki finoekuma ije ni arega fu ijiege finoeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Areme e gue bu vierafe buka anafa buone ije kaenamiana Jesudo roga fu bu umui nigofo naejiakinu buefuo baname isoekuae bu ruae. Rove e vua fuone fievo ije buka naebe oemare ijadufuo bu urina e ije anafa kaenamia ruovo ije kuriaerei. ");
INSERT INTO bbb_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Rove Jesu fu una kiae, Ja ame isesina ije jade kuriaerekiro ni arega bu kaenamia ruafo. Ijadufuo maeje e ije erarebe bu ame isesina ije bu asoe buone ije ma vierafevo ijiege na ma vierafevo ije Godi fu e ijieki ijiebuo oe ije samuagiakiro vierafemano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Fu ijiege kuariama areme uri ame isesina ijene umui nigofo naejiakinu buone baname isoema areme fune are ije arena vae. ");
INSERT INTO bbb_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Areme maza be e be fu ro kekena Jesu kuae, E nijasiamo na vame maeje na irere ijene rekuva na vame ma karivako ije abekono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Fu ijiege kuaramoga Jesu fu una gue kuae, A irerefuo ire maeje rekiroga ireobo vierafena kieme? Fu e be erare fuka e ma baki ro fune e besu Godire fuosukua fu e ma. Ijadufuo a vame ma karivako ije abekiro vierafekuma ni Godido akae ije iriniano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","19","Jesu fu ijiege kuaramoga e ije fu una kuae, Ro akae ije na izene ije iriniakono kuae? Ro Jesu fu una gue kuae, Ade e bino kaniakinu ro e binobuo bara turakinu ro e binobuo ire iniemekinu ro e guebuo vua kufuimena kuaemo. Ro kuke nika asoe one ijiakiro asie one ije iriniakinu izege a koro one oetuanamimo ijiege ni una e gue oetuano kuae. ");
INSERT INTO bbb_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jesu fu ijiege kuaramoga e ije fu una kuae, Akae boeje a kuaemo ije nane iriniavo. Ro na una ire be ije na irere ije rekono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Areme Jesu fu una kuae, A vierafe aka maturaekuma ni va sinuome one boeje ke fuaevena moni abe e sinuo baki ije vajia areme ni una na nuvediene. A ijiege rekuma a vame ije maza boeje ma karivako ijene abekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ijadufuo e nikaki ije fu vua ije fiemo fuka ireobo oefiaemo fu oefiaeguma vae. Ijadufuo maeje fu vierafega fuka sinuome ma uruvana zarae. ");
INSERT INTO bbb_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Areme Jesu fu una e vua fuone fievo ije kiae, Vua ige na ma kuariave. E be erare fu sinuome uruvana zaraema ije fu agane ije Godi fu oe buone ije samuagiamo ijia buina besu maziedufuo ije fuka ma gikikimana. ");
INSERT INTO bbb_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ro igia fie, mave-kamero ije fu fanu ma ireobo be. Ro sieme tire ije fuka isekube ijadufuo fu tire ijia aru vakuma fuka ma gikikimana. Vame besu ijiege ro e ije sinuome zaraema fu e ije Godi fu oe buone ije samuagiamo ijia buina besu maziedufuo ije fuka ma gikikimanano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Ijadufuo e vua fuone fievo bu vua ije fievo buka oeseradiamo bu uri uruke vierafekinu bue kuae, E ije erare fune manido fu korufuo kenujanamikono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Bu ijiege kuaevoga Jesu fu kiae, Ema ije fu daro baki ijadufuo fu izege korofuo fue kenujanamikuma baki. Ro fune Godire fuosukua manido fu e boeje karauniakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Areme Fita fu una Jesu kuae, No ire nuvuone boeje none ijia arena uri a nuveda ruae. Ijadufuo no ire maeje no irere abekono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Bu ijiege kuaravoga Jesu fu una kiae, Vua ige na ma kuariave. Maza ije ire boeje bu una iviaeko revo ijia Ema ijiebuo Fari ige na fata none maeje sanaema ijia ajia fike. Ro e ije erarebe ja na nuvedievo ije jadua ja fata maeje tuero kena karike. Ja fata ijia karina e Isureroko agane tuero ijiebuo ise ije kena mazie giake. ");
INSERT INTO bbb_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ro erare fu are ro uviarafa fuone ijiakina makirafa ro orafa fuone ro anafa ijiakiro juare fuone ije noefuo ijuegafiamo e ije fu una kuke ire ma bino uruvana kedufuo. Ro kuke fu vame ma karivako ije abena ijia fi vake. ");
INSERT INTO bbb_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ro igia fie, erare be bu iviama korobuo kena e anuigi igege vierafenoejo ije bu rade una e isesina redufuo. Ro kuke erarebe bu iviama korobuo kena e isesina igege vierafena kenoejo ije rade buka e anuigi redufuo. ");
INSERT INTO bbb_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Ijadufuo e ije Godi fu oe buone ije samuagiamo ije fu e juare koeki ije fu suoke mugamia kekena va e kiaga bu fuefuo imejake fu moni vajiakuma igeki. ");
INSERT INTO bbb_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ijadufuo e ije fu vierafe fuka e bino kega bu fuefuo imeke. Ijadufuo fune va e ije kiae, Ja mazani besu noefuo imekuva na e besubesu moni sunine bino enafu vajiakono kiae. Fu ijiege kiamo bune oemarena juare fuone ijia imekuae vae. ");
INSERT INTO bbb_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Bune vakoga fune maza ajia ruaema ijia una kuke are bu ire fuaevejo ijia vaga e gue bu ijia irenoevo fu giae. ");
INSERT INTO bbb_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ijadufuo fu kekena kiae, Na vierafe jadua ja va juare none ijia imeke na moni besu enafu vajiano kiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Fu ijiege kuariamo bune vako fu una maza uvuoka ijia ro mufuo ijia fu una e bino duaku kemo bu fuefuo imekuae vae. ");
INSERT INTO bbb_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Fu una va fina vakuma maza fune kokuveno ijia una vaga e gue bu ijia irenoevo fu giae. Fu giana uri kiae, Ja irerefuo maza ige dabe nisena jame igia irenoevono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Fu ijiege kiamoga bu una gue kuae, No e bino bu naebe no buefuo imedufuo kueva ijadufuo no ijene irevano kuae. Ijadufuo fu urina kiae, Na vierafe nine jadua va kofu juare none ijia imeno kiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Areme ve fune musiremoga e ije juare koeki ije fune uri e ireobo fuone fu e imejo ije samuagiamo ijene kuae, E ije imevo ije kume bu roga ni moni buone ije vajiane. Ro moni a vajiakuma ni e ije erarebe bu rade vaeva ijia zinuivena vajiaja vakuma amure vaeva ijia furino kuae. ");
INSERT INTO bbb_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ijadufuo e ije rade maza kokuveno ijia imekuae vaeva ije bune i buone bu meva ijadufuo moni sunine buone abei. ");
INSERT INTO bbb_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ro e ije bu ude imekuae vaeva ije bu vierafero buka bure suoke zinuivena imena ruaedo bu moni sunine sibaneke ireobo abekuae bu ijiege vierafei. Rove e besubesu funeka moni sunine ni besu ijiaru abei. ");
INSERT INTO bbb_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Bu moni buone abe areme rade e ije bune una e juare koeki ijena zienami. ");
INSERT INTO bbb_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Bu urina kuae, E gure a rade kiaema ije bume maza isekube imei. Ro noeje noka suoke ijia zinuivena ruako maza kanue. Ro a irerefuo moni noeje a e ije bu rade ruaeva ijena besu enafu vajuemano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Bu ijiege kuaravoga e juare koeki ije fu urina e ije vua kuaemo ije kuae, Kaino nana ja biesiraeva baki. Ro vua irere na ja kuariaeva ije nane ijiege rena moni jone ije vajiave. ");
INSERT INTO bbb_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Na vierafe naka e ije bu rade imeva ijene moni izege na ja vajiavo ijiege una bu vajiakiro vierafe. Ijadufuo ni moni jone ige kena vafo. ");
INSERT INTO bbb_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ijadufuo maeje moni ije fu none ijadufuo na daro nado na kena izege na vierafeva ijia reke. Ro a ziemo ije abite ige na e vajuki rena moni enafu vajiaeva a ijadufuo ziemono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesu fu vua ijiege kuaria furikiro kiae, Vame besu ijiege e ije bu rane gamia ruovo ije ve be bu una ude vake. Ro e ije bu ude vako ije ve be bu una rane gamia ruakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu fu e vua fuone fievo tuero (12) ijena bune Jerusareme vakuae vako ijia fu e bu Jerusareme ijia fu dabe izege redufuo ijene mauike kuariae. ");
INSERT INTO bbb_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","Fu kiae, Igia fie, no vakuma Jerusareme usiaevo ijia Ema ijiebuo Fari ige naeje bu dabe e zinone ifaejevo ijiebuo e mamekanu ijiakina e vua akae nijasiavo ije miake. Areme e ije bu vua ise noesina kuaekinu na dabe kaniedufuo kuaeke. ");
INSERT INTO bbb_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","E ijiebe na dabe una e Jiusi baki ije miaga bure na abe uti ifaejena vi ufemadiekinu ifiema areme na dabe kurosi kanieke. Ro mu inokubeke furikuma Godi fu kiega na una urina ni uria fivakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Areme rade e Zebedido bara ijare farirafa fuone ijena Jesu fino ijia vae. Bara ije fu ire be vierafema ijadufuo fu va Jesu manino niome ijia augesana uri ire befuo kuarae. ");
INSERT INTO bbb_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Fu ijiege kuamoga Jesu fu urina kuae, Ro ire a vierafema ije a irere ijene vierafemano kuae? Ijadufuo bara ije fu una gue kuae, E Ireobo a isekie, na vierafe maza ije a una E Ireobo rena Godido e ije samuagiakiro ruomo ijia ame fari none inokiro ige be fu umui one maeneke ijia fikiro be fu aeneke ijia fino kuae. ");
INSERT INTO bbb_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Areme Jesu fu una kiae, Vua ije ja kuarievo ije ja naebe mukoe vierafe ro jame ijia kuarieve. Ja vierafero vajae fiane ige na abekuvejo ije jane manido jadua ja ijiege abekuae ja ije vierafevano kiae? Fu ijiege kuariamoga bu una gue kuae, No vierafe no manido no rekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Areme Jesu fu una kiae, Ire ije e bu none rega na isejavaekuvejo ije na vierafe jadua bu ijiege jone rega ja isejavaeke. Ro igia fie, e ije bu are umui none maeneke ro aeneke ijia karidufuo ije ja kuarievo ije nare rekuva baki. Ro are ije fu Asoe none ijare e ije fu kemo ijiebuo amaerijiamono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ijadufuo ve ijia e Jesudo vua fievo gue bu vua ije fievo buka defarudiamo bu urina ino uviaki ije ziegafiae. ");
INSERT INTO bbb_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ijadufuo Jesu fu urina e vua fuone fievo boeje kiamo bu besu afuivoga fu kiae, E Jiusi baki ijiebuo e mamekanu ije bu daro buone ijia e buone samuagiavo. Ro kuke e aeko ijiebuo e mamekanu ije bu daro buone ijia e aeko buone ije samuagiavo. ");
INSERT INTO bbb_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","28","Ro igia fie, jaeje jade vame ije bu kevo ijiege kenoevo. Erare fu uve jone ijia e anuigi rekiro vierafekuma e ije fuka una joefuo imedufuo. Ro erare fu e nigofo rekiro vierafekuma e ije funika una joefuo imedufuo. Ijiege ro Ema ijiebuo Fari ige na ruaeva ije na e ireobo rekiro ruaeva baki. Ro name e be fu e befuo imeno na ijiege rekiro ruae. Ro kuke na ruaeva ije na kurosi ijia baronena kavuane none ijia usiaena e boeje karauniakiro ruae. ");
INSERT INTO bbb_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Areme Jesu fune e vua fuone fievo ijena are Jeriko arena vakoga e ka uruvana bu usiaena bu nuvediae. ");
INSERT INTO bbb_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ro e ni kuzeki inokiro bu vame irifo ijia karido bu fieke Jesu fu ijia asidiana ruvako bu fie. Ijadufuo bu uri kumei, E Ireobo, e Devido uifari gare, a isekie ni no guona oe fiane abena ifejuono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Bu ijiege karina kumevoga e ijia ruovo ije buka urina kuriaerena vafiae. Rove e inokiro ije buka una urukeigia vijena kumei, E Ireobo, e Devidido uifari gare, a isekie ni no guona oe fiane abena ifejuono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ijadufuo Jesu fu vako ije fu ijia arena uri kiae, Ja vierafe na irere joefuo rekiro ja ije vierafevano kiae? ");
INSERT INTO bbb_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Fu ijiege kiamoga bu una gue kuae, E Ireobo no vierafe a ni nuvuone ige amaeriajuoga no una ni nafaeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Areme Jesu fu vua ije bu kumevo ije fiena fuka una buone oefiane abei. Ijadufuo fune uri ni buone ijia niriakiamoga bu ve ijia una ni nafae. Areme e inokiro ije buka ireobo oemadiamoga bu uri fu nuvena vae. ");
INSERT INTO bbb_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","2","Areme Jesu fune e vua fuone fievo ijena Jerusareme vakuae ruoma are Betifasi uruo Orivi kuavo ivuake ijia usiae. Areme Jesu fune urina e vua fuone fievo ije inokiro vua igene kuariae. Fu kiae, Va are gafia usiae gaga bu mave doniki be kiraeva fu ame fuone ijiakuma ijia manivoga ije irana kaenamia una na fivo igia ruafo. ");
INSERT INTO bbb_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ro ja va iraga e be fu kia, Ja irerefuo mave-doniki ije iravono kiaga ni kua, No E Ireobo ijare vierafega no ijene iravono kuafo. Ja ijiege kuarakuva fu arega ja kaenamia ruadufuo. ");
INSERT INTO bbb_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ro ire ije rema ije fune izege e ije Godido vua vierafena kuaemo fu isuibe kuaema ijiakuma riarei. ");
INSERT INTO bbb_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ro vua ije fu kuaema ije bu ijiege isoe, E Jerusaremeko ije E Kini jone fu mave doniki ado ijia ajia fina jone ruome. Ro fuje fuka e kabuaekabuaeki ijadufuo fu e bijaenoevo ijiebuo e ireobo ijiege ruomo baki. Ro fume mave doniki ame ijia ajia fina ruomono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ijadufuo e vua fuone fievo inokiro ije bune va vua irere Jesu fu kuariaema ijia nuvena ijiege rei. ");
INSERT INTO bbb_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Areme bune va doniki ijiakiro ame fuone ije kaenamiana una ruoma Jesu fino ijia usiae. Areme bune urina ugone buone bu ado savo ije azona mave doniki ado ijia riejavo Jesu fu ijia ajia fi. ");
INSERT INTO bbb_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Bu ijiege rekoga e boeje bu fuina ruaeva ije budua bune uri ugone buone gue bu ado saeva ijene azona vame ijia riejae. Ro e gue bu urina aname kia ije mukiena vame ijia riejae. ");
INSERT INTO bbb_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ijiege rena e boeje bune guegue irena vako Jesu fu ukua ijia vae. Fu ijia vakoga e boeje bu vijekinu kumei, No e Devidido Fari ige dabe aroeke. No vierafe Godi fu e ije fu E Ireobo ijadufuo ive ijia ruomo ije daro make. Ro noka Godido ireobo oemarekono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Bu ijiege oemarena jarekafakinu Jesu mesirina vakuma Jerusareme usiae. Ro e boeje sidove ijia kariva ije buka oeseradiamoga bu urina kuae, E ije fute erare ruomono kuae? ");
INSERT INTO bbb_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ro e boeje Jesuna vako ije bu urina kumei, E ige fu Jesu e ije Godido vua vierafena kuaemo ijene. Ro fuje fu e are Nasareti aesakae Gareri guove ijekono kumei. ");
INSERT INTO bbb_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ijiege re areme Jesu fune Godido Are bu baname isoevo makave ijia e ije bu ire binobino karina fuaevejo ije kuriaeremo bu usiae subi. Areme fu uri e ije bu karina moni dana vajuenamivo ijiakina e ije ume fuaevejo ijiebuo fata ije kame kuderiana sinuome buone ije kame diduekorejiae. ");
INSERT INTO bbb_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Areme fu urina kiae, Buki akae ije bu isuibe isoeva ijia Godi fu kuae, Are none ije bu ijia aruna baname isoevono kuae. Rove jare ijia aruna dabe una e iniekibuo are igege amaerivono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesu fu ijiege kuariama areme rade e ni kuzeki ijiakina e aekirariaeva ije bu Godido are ijia rovoga fu amaeriamo bu una madiae. ");
INSERT INTO bbb_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Rove e mamekanu Godido zinone ifaejevo ijiebuo e mamekanu ijiakina e vua akae nijasiavo ije bu vame mukore gue Jesu fu remo ije giavo buka defarudiae. Ro kuke bu giake ame isesina ije buka Godido are ijia aruna vijena kumevo, E Devidido Fari gare aroeno kumevo bu ije fie. ");
INSERT INTO bbb_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ijadufuo bu urina Jesu kuae, A ame isesina vua ije bu irere kuaevo ije abe fiemano kuae? Bu ijiege kuavoga Jesu fu una kiae, Na vua irere bu kuaevo ije nane fie. Ro jabe vua ije bu buki akae ijia isoeva ije dana vierafei? Ro vua ije bu isoeva ije bu ijiege isoe, Godire ame isesina ije mukoreigia vierafejiaga bu fu aroekono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jesu fu ijiege kuariama areme fune sidove ije arena una are Beteni ijia naekiro vae. ");
INSERT INTO bbb_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Bu va ijia naoeva suoke mugamia Jesu fune e vua fuone fievo ijena bune una Jerusareme ruakuae ruovo ijia fuka vasia oe. ");
INSERT INTO bbb_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Fu vasiaoemoga fu ine durime igeki bu kua figino kuavo ije be fu vame irifo ijia manino ije gae. Areme fune ura va gake ine ije fu naebe fo kirae ro fume a ijiaru manino fu gae. Ijadufuo fu ine ije kuae, Aeje abe una fo kirakono kuamoga ine ije fuka ve ijia saerei. ");
INSERT INTO bbb_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jesu fu ijiege remoga e vua fuone fievo bu ine ije saerema ije gavo buka oeseradiae. Ijadufuo bu kuae, Ine ije fu izege migegire saeremano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ro Jesu fu una kiae, Vua ige naka ma kuariave. Ja ire ijieki ije naebe giana zazae ro jame uri ma vierafekuva ja ine gure na kuavo fu saerema ijiege jadua ja ire ijieki bino reke. Ro ja ire ijiaru rekuva bakiro ja kuke uruo ireobo be kuako, Ni koro tuana davare ijia arino kuakuva fuka itire jone abeke. ");
INSERT INTO bbb_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ro kuke ja ma vierafekuva irere ja baname isoena Asoe jone kuavo ije fu vajiakono kuae. ");
INSERT INTO bbb_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Areme Jesu fune e vua fuone fievo ijena una Godido Are bu baname isoevo makave ijia vae. Fu ijia aruna vua nijasiamo ijia e Godido zinone ifaejevo ijiebuo e mamekanu ijiakina e Jiusibuo e mamekanu ije bu usiaena Jesu kuae, Daro ije a abena ire ije renoeno ije a izia abei? Ro kuke daro ije erare abe maemano kuae? ");
INSERT INTO bbb_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Bu ijiege kuaravoga Jesu fu una gue kiae, Na vierafe na duna besu kiaga ja una maeje kuarieke. Ja kuariekuva na ijare daro ige na izia abena ire igene renoejo na ije kuariake. ");
INSERT INTO bbb_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ro ja vierafe Joni e do ruoriamo daro ije fu abena e do ruoriamo ije fu Godire mae ke fu emabe maevano kiae? Jesu fu ijiege kuariamo bu uri dabe bue kuaena sagui. Bu kuae, Note una izege vegue kuarake? No uri kuako fu Godire maemano kuakuva fu una kuoko, Ro ja irerefuo naebe Joni ma vierafevano kuoke? ");
INSERT INTO bbb_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ro no kuako Joni daro ije fu emabe maevano kuakuva no vierafe e gure buka no kanuodufuo. Ijadufuo maeje e boeje bu ma vierafega e Joni fune ma e Godido vua vierafena kuaemo beno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ijadufuo bu una Jesu kuae, Duna ije a kuaruomo ijadufuo maeje noka naebe vierafevano kuae. Bu ijiege kuaravoga fu una kiae, Ijiekido na vierafe daro ige na izia abena ire igene renoevo ije nabe kuariakono kiae. ");
INSERT INTO bbb_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu fu ijiege kuaria areme una kiae, Iviama vua ige na kuariakuvejo ije ja izege vierafe? E be fu ame fari inokiro nafei areme fune maza be uri fari fuone boga ije kuae, Ivia ni va juare gafia imeno kuae. ");
INSERT INTO bbb_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Fu ijiege kuamoga fari fuone boga ije fu kuae, Na isediemono kuana ro rade fu una mukoreigia vierafena fune juare ijia vae. ");
INSERT INTO bbb_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Areme asoe fuone ije fune kuke va fari fuone iviene ije kuae, Ani ivia va juare gafia imeno kuae. Fu ijiege kuamoga fari fuone fu kuae, Ke asoeno na ijiege rekono kuae rove fu naebe vae. ");
INSERT INTO bbb_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ro ja vierafega ame inokiro ije erare fu asoe fuone fu vierafema ijia kemano kiae? Fu ijiege kiamo bu kuae, Fu ame fari boga ijareno kuae. Ijadufuo Jesu fu kiae, Ni vua ige na kuariakuvejo ije fiefo, E ije