﻿USE sofia;
DROP TABLE IF EXISTS sofia.bba_vpl;
CREATE TABLE bba_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES bba_vpl WRITE;
INSERT INTO bba_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Sɑnɑm mɛ Gusunɔ u hɑnduniɑ toruɑ, u wɔllu kɑ tem tɑkɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Tem dɑɑ wɑ̃ɑwɑ bitɑm. Gɑ̃ɑnu kun wɑ̃ɑ mɛ sɔɔ. Mɛn temɔ wɔru bɔkɔwɑ ɡɑ wɑ̃ɑ mi, mɑ yɑm wɔ̃kurɑ ɡu wukiri. Mɑ nim mu tɛrie tem mɛn wɔllu ɡiɑ. Nim mɛn wɔllɔwɑ Gusunɔn Hunde rɑ n bɛllimɔ. ");
INSERT INTO bba_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Yerɑ Gusunɔ u nɛɛ, yɑm bururɑm mu kooro. Ye u ɡeruɑ mɛ, mɑ mu koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Mɑ yɑm bururɑm mɛ, mu nùn wɛ̃re. Sɑɑ yerɑ u mu wunɑnɑ kɑ yɑm wɔ̃kuru. ");
INSERT INTO bba_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Mɑ u yɑm bururɑm sokɑ sɔ̃ɔ sɔɔ, yɑm wɔ̃kuru mɑɑ wɔ̃kuru. Mɑ sɔ̃ɔ sɔɔ ɡe kɑ wɔ̃ku te, n swĩinɑ mɑ n kuɑ tɔ̃ɔ ɡbiikiru. ");
INSERT INTO bba_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Mɑ Gusunɔ u nɛɛ, ɡɑ̃ɑnu nu tɛrio wɔllɔ nɡe ɡɔnɑ kpɑ mu n nim bɔnu sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Ye u ɡeruɑ mɛ, mɑ wom mu tɛriɑ mu nim mɛ bɔnu kuɑ. Sukum wɑ̃ɑ nim wɔllɔ, sukum mɑɑ wɑ̃ɑ temɔ. ");
INSERT INTO bba_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Mɑ u ɡɑ̃ɑ ni sokɑ wɔllu. Sɑɑ ye u yebɑ mɔ̀, sɔ̃ɔ sɔɔ kɑ wɔ̃kuru n swĩinɑ mɑ n kuɑ tɔ̃ru yiruse. ");
INSERT INTO bba_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Mɑ Gusunɔ u nɛɛ, nim mɛ mu wɑ̃ɑ wom dirum temɔ mu subenu koowo kpɑ tem ɡbebum mu terɑ. Ye u ɡeruɑ mɛ, mɑ n koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Mɑ u tem ɡbebum mɛ sokɑ tem, mɑ u mɑɑ nim sube nin bɑɑtere sokɑ nim wɔ̃ku. Mɑ n nùn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yerɑ u nɛɛ, tem mu ɡɑ̃ɑ dɑbinu kpiiyo, kɑ yɑkɑ si su ko n binu mɑrumɔ kɑ dɑ̃ɑ binuɡii bwese bwesekɑ ni nu nin bweseru mɔ nin mɑrum sɔɔ. Ye u ɡeruɑ mɛ, mɑ n koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tem mu ɡɑ̃ɑ dɑbinu kpiɑ, kɑ yɑkɑ bwese bwesekɑ si su binu mɑrumɔ, kɑ dɑ̃ɑ binuɡii bwese bwesekɑ ni nu bweseru mɔ nin mɑrum sɔɔ. Mɑ n nùn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Ye u yebɑ mɔ̀, sɔ̃ɔ sɔɔ kɑ wɔ̃kuru n swĩinɑ mɑ n kuɑ tɔ̃ru itɑse. ");
INSERT INTO bba_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Mɑ Gusunɔ u nɛɛ, fitilɑnu nu kooro wom dirum sɔɔ kpɑ nu sɔ̃ɔ sɔɔ kɑ wɔ̃kuru wunɑnɑ, kpɑ nu n sɔ̃ɔsimɔ sɑɑ ye wɔ̃su kɑ tɔ̃ɔ bɑkɑnu koo tore. ");
INSERT INTO bba_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","Kpɑ nu n sɑ̃ɑ fitilɑnu wom dirum sɔɔ nu kɑ tem yɑm bururɑsiɑ. Ye u ɡeruɑ mɛ, mɑ n koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","U fitilɑ bɑkɑnu yiru kuɑ, niyɑ sɔ̃ɔ kɑ suru. U mɑɑ kperi kuɑ. U sɔ̃ɔ kuɑwɑ u n kɑ bɑndu dii sɔ̃ɔ sɔɔ, mɑ u suru kuɑ u n kɑ bɑndu dii wɔ̃kuru. ");
INSERT INTO bba_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Mɑ u ni kpuro doke wɔllɔ nu n kɑ tem yɑm bururɑsie, ");
INSERT INTO bba_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kpɑ nu n sɑ̃ɑ sɔ̃ɔ sɔɔ kɑ wɔ̃kurun sunɔ, kpɑ nu n yɑm bururɑm kɑ yɑm wɔ̃kuru wunɑnɛ. Mɑ n nùn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Sɑɑ ye u yebɑ mɔ̀, sɔ̃ɔ sɔɔ kɑ wɔ̃kuru n swĩinɑ mɑ n kuɑ tɔ̃ru nnɛse. ");
INSERT INTO bba_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Mɑ Gusunɔ u nɛɛ, nim mu de hunde konibɑ dɑbi dɑbinu nu koorɑ mɛ sɔɔ, kpɑ ɡunɔsu su n yɔ̃ɔmɔ wom dirum sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Yerɑ u swɛ̃ɛ bɛkɛ tɑkɑ kuɑ kɑ yɛɛ kpuro yi yi sĩimɔ yi yibɑ nim mɛ sɔɔ bwese bwesekɑ. U mɑɑ ɡunɔsu kuɑ bwese bwesekɑ. Mɑ n nùn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Yen biru u yi domɑru kuɑ u nɛɛ, yi kɔwɑro yi dɑbiɑ yi yibu nim wɔ̃kun nim sɔɔ kpɑ ɡunɔsu su dɑbiɑ hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Sɑɑ ye u yebɑ mɔ̀, sɔ̃ɔ sɔɔ kɑ wɔ̃kuru n swĩinɑ mɑ n kuɑ tɔ̃ru nɔɔbuse. ");
INSERT INTO bba_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Mɑ Gusunɔ u nɛɛ, yɛɛ bwese bwesekɑ yi mɑruro tem sɔɔ. Yiyɑ kpɑɑku yɛɛ kɑ ɡbeeku yɛɛ kɑ yɛɛ yi yi rɑ kɑbiri, yi kpuro bwese bwesekɑ. Ye u ɡeruɑ mɛ, mɑ n koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","U ɡbeeku yɛɛ kuɑ bwese bwesekɑ kɑ kpɑɑku yɛɛ kɑ yɛɛ yi yi rɑ kɑbiri. Mɑ n nùn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Yen biru Gusunɔ u nɛɛ, kon tɔnu tɑkɑ ko u n sɑ̃ɑ nɛn weenɑsii mɑm mɑm, kpɑ u n sɑ̃ɑ ye nɑ tɑkɑ kuɑ kpuron wiruɡii. Yeyɑ tem kpuro kɑ swɛ̃ɛ kɑ ɡunɔsu kɑ kpɑɑku yɛɛ kɑ yɛɛ yi yi rɑ kɑbiri temɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Ye u ɡeruɑ mɛ, mɑ u tɔnu tɑkɑ kuɑ u kɑ nùn weenɛ mɑm mɑm. U bu kuɑwɑ durɔ kɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Mɑ u bu domɑru kuɑ u nɛɛ, i mɑruro i dɑbiɑ i hɑnduniɑ yibu yɑ n sɑ̃ɑ bɛɛɡiɑ kpɑ i n yɛɛ kpuro nɔmɑ sikerenɛ. Yiyɑ swɛ̃ɛ kɑ ɡunɔsu kɑ yɛɛ yi yi sĩimɔ temɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","U mɑɑ nɛɛ, wee ye i ko n dɑ di. Yeyɑ yɑkɔ bweseru bɑɑtere tem sɔɔ kpuro te tɑ rɑ binu mɑ, kɑ dɑ̃ɑ binuɡiru bɑɑtere te tɑ ten bweseru mɔ ten mɑrum sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Mɑ u mɑɑ hɑnduniɑn yɛɛ kpuro yi yi hunde mɔ yi sĩimɔ temɔ kɑ ɡunɔsu kpuro sɔ̃ɔwɑ u nɛɛ, nɑ bɛɛ yɑkɔ beku bɑɑɡere wɛ̃ i n dɑ di. Ye u ɡeruɑ mɛ, mɑ n koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Yerɑ u mɛɛrɑ kpuro ye u kuɑ, mɑ n nùn wɛ̃re ɡem ɡem. Sɑɑ ye u yebɑ mɔ̀, sɔ̃ɔ sɔɔ kɑ wɔ̃kuru n swĩinɑ mɑ n kuɑ tɔ̃ru nɔɔbɑ tiɑse. ");
INSERT INTO bba_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Nɡe mɛyɑ Gusunɔ u kɑ wɔllu kɑ tem kɑ kpuro ye yɑ wɑ̃ɑ sɔɔ tɑkɑ kuɑ u wiru ɡo. ");
INSERT INTO bba_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tɔ̃ru nɔɔbɑ tiɑse sɔɔrɑ u win sɔmɑ ye u kuɑ kpuro wiru ɡo mɑ u wɛ̃rɑ tɔ̃ru nɔɔbɑ yiruse. ");
INSERT INTO bba_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Mɑ u nɔɔbɑ yiruse te yi nɛnɛm win sɔ̃, u tu domɑru kuɑ yèn sɔ̃ te sɔɔrɑ u wɛ̃rɑ ye u kpuro tɑkɑ kuɑ u kpɑ. ");
INSERT INTO bba_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Sɑnɑm mɛ Yinni Gusunɔ u wɔllu kɑ tem tɑkɑ kuɑ, ");
INSERT INTO bba_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","dɑ̃ru ɡɑrɑ kun ɡinɑ kpiɑ tem sɔɔ, yɑkɑsu ɡɑsu kun mɑɑ kpiɑ domi Yinni Gusunɔ kun ɡinɑ ɡurɑ nɛɛsie sɑnɑm mɛ. Tɔnu mɑɑ sɑri wi u koo tem mɛ wuku. ");
INSERT INTO bba_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Adɑmɑ kɑkoru ɡɑru tɑ rɑ se tem di tu tem mɛ nikererɑsiɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Yen biruwɑ Yinni Gusunɔ u tɔnu mɔmɑ kɑ tem u nùn wɑ̃ɑrun wom wɛ̃sie win wɛ̃rɔ, mɑ tɔnu kuɑ wɑso. ");
INSERT INTO bba_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mɑ Yinni Gusunɔ u ɡbɑɑru kuɑ Edɛniɔ sɔ̃ɔ yɑri yerun berɑ, mɑ u tɔnu wi u kuɑ mi suɑ u doke sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mɑ u dɑ̃ɑ bwese bwesekɑ kpiisiɑ te sɔɔ, ni nu wɑɑbu wɑ̃ kɑ ni nu dim do, kɑ sere dɑ̃ɑ tèn binu nu koo tɔnu wɑ̃ɑru wɛ̃, kɑ mɑɑ tèn binu nu koo tɔnu ɡeɑ kɑ kɔ̃sɑ ɡiɑsiɑ. Dɑ̃nu yiru ye, nu wɑ̃ɑwɑ ɡbɑɑ ten suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Dɑɑru ɡɑrɑ wɑ̃ɑ ɡbɑɑ te sɔɔ, te tɑ tu nike nikeru sɑ̃ɑ. Min diyɑ tɑ yɑrɑ mɑ tɑ kɛri kuɑ nnɛ. ");
INSERT INTO bba_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Gbiikɑɑn yĩsirɑ Pisoni. Yeyɑ yɑ tem mɛ bɑ mɔ̀ Hɑfilɑ sikerenɛ. ");
INSERT INTO bba_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Tem mɛ sɔɔrɑ wurɑ ɡeɑ wɑ̃ɑ. Turɑre nubu duroruɡiɑ mɑɑ wɑ̃ɑ mi, kɑ kpee ɡobiɡinu. ");
INSERT INTO bba_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Kɛrɑ yirusen yĩsirɑ mɑɑ Gihoni. Yeyɑ yɑ tem mɛ bɑ mɔ̀ Kusi sikerenɛ. ");
INSERT INTO bba_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Kɛrɑ itɑsewɑ mɑɑ Tiɡiri. Yeyɑ yɑ kokumɔ tem mɛ bɑ mɔ̀ Asirin sɔ̃ɔ yɑri yeru ɡiɑ. Kɛrɑ nnɛsewɑ mɑɑ Efɑrɑti. ");
INSERT INTO bba_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Ye Yinni Gusunɔ u ɡbɑɑ te sɔɔru kuɑ u kpɑ Edɛniɔ, yerɑ u tɔnu wi suɑ u doke sɔɔ u kɑ tu wuku kpɑ u n tu kɔ̃su. ");
INSERT INTO bba_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mɑ u nùn woodɑ yeni wɛ̃ u nɛɛ, kɑɑ kpĩ ɑ ɡbɑɑ ten dɑ̃nu kpuron binu di. ");
INSERT INTO bba_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Adɑmɑ dɑ̃ɑ tèn binu nu koo tɔnu ɡeɑ kɑ kɔ̃sɑ ɡiɑsiɑ, ɑ ku rɑ ten binu di, domi dɔmɑ te ɑ nu di, kɑɑ ɡbiwɑ. ");
INSERT INTO bba_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","20","Kɑ temɑ Yinni Gusunɔ u ɡbeeku yɛɛ kpuro kuɑ kɑ ɡunɔsu kpuro, mɑ u kɑ ye kpuro nɑ tɔnu win mi, u kɑ wɑ mɛ u koo ye yĩsiru kɛ̃. Mɑ tɔnu wi, u yɑɑ sɑbenu kpuro kɑ ɡunɔsu kɑ ɡbeeku yɛɛ kpuro yĩsɑ kɑ̃. Yĩsi te tɔnu wi, u mɑɑ yɑɑ bɑɑyere kɑ̃ teyɑ bɑ kɑ ye sokumɔ. Adɑmɑ ye kpuro sɔɔ, sɑri ye yɑ kɑ nùn weenɛ ye yɑ koo nùn somi. Yen sɔ̃nɑ Yinni Gusunɔ u nɛɛ, n ǹ wɑ̃ tɔnu u n wɑ̃ɑ wi turo. Kon nùn ɡoo kuɑ u n sɑ̃ɑ nɡe wi, wi u koo nùn somi. ");
INSERT INTO bba_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yerɑ Yinni Gusunɔ u tɔnu wi dom mɔn bɑkɑru kpɛ̃ɛ u dweeyɑ. Mɑ u win yɛ̃sɑn kuku teeru wunɑ mɑ u yɛ̃sɑ ye kɔruɑ kɑ yɑɑ bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mɑ u tɔn kurɔ tɑkɑ kuɑ kɑ tɔn durɔn kuku te, te u wunɑ. Mɑ u kɑ nùn nɑ tɔn durɔ win mi. ");
INSERT INTO bba_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Yerɑ durɔ wi, u nɛɛ, wee tɛ̃, wini u wɑsi mɔ nɡe nɛɡii mɑm mɑm. Bɑ koo nùn sokuwɑ tɔn kurɔ, domi tɔn durɔn min diyɑ u yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yen sɔ̃nɑ durɔ u koo win tundo kɑ win mɛro deri kpɑ wi kɑ win kurɔ bɑ n mɑninɛ, kpɑ be yiru kpuro bu ko wɑsi tee. ");
INSERT INTO bba_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Sɑɑ ye sɔɔ, durɔ wi kɑ win kurɔ tererɑ bɑ wɑ̃ɑ. Sekurɑ kun mɑɑ ben ɡoo mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","N deemɑ wɑɑ yɑ bwisi bo ɡbeeku yɛɛ kpuro sɔɔ yi Yinni Gusunɔ u tɑkɑ kuɑ. Yerɑ yɑ nɑ kurɔ win mi, yɑ nùn bikiɑ yɑ nɛɛ, kɑ ɡem Gusunɔ u nɛɛ, i ku ɡbɑɑ tenin dɑ̃ɑ binu kpuro di? ");
INSERT INTO bba_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Mɑ kurɔ wi, u ye wisɑ u nɛɛ, sɑ rɑ ɡbɑɑ ten dɑ̃ɑ binu di ni, ");
INSERT INTO bba_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","mɑ n kun mɔ te tɑ wɑ̃ɑ suunu sɔɔ. Terɑ u nɛɛ, su ku mɑm ten binu bɑbɑ su sere di su ku kɑ ɡbin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Yerɑ wɑɑ ye, yɑ kurɔ wi wisɑ yɑ nɛɛ, i ǹ ɡbimɔ pɑi! ");
INSERT INTO bba_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Domi Gusunɔ u yɛ̃ dɔmɑ te i ten binu di, bɛɛn nɔni koo wukiɑrɑwɑ kpɑ i n sɑ̃ɑ nɡe win tii, i n ɡeɑ kɑ kɔ̃sɑ yɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Mɑ kurɔ wi, u wɑ dɑ̃ɑ te, tɑ kɑ dii dobu weenɛ tɑ wɑɑbu wɑ̃, tɑ koo mɑɑ kpĩ tu nùn ko bwisiɡii. Mɑ u ten bii ni sɔrɑ u di. U mɑɑ win durɔ wɛ̃ kɑ wi bɑ wɑ̃ɑsinɛ, mɑ wi, u mɑɑ di. ");
INSERT INTO bba_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Yerɑ be yiru kpuron nɔni wukiɑrɑ bɑ ɡiɑ mɑ tererɑ bɑ wɑ̃ɑ. Mɑ bɑ dɑ bɑ dɑ̃ɑ te bɑ mɔ̀ fiɡien wuru bɑkɑsu burɑ bɑ swɛɛnɑ bɑ kɑ tii ɡɑndi. ");
INSERT INTO bba_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Ye bɑ Yinni Gusunɔn nɔɔ nuɑ u bɔsu ɡbɑɑ te sɔɔ yokɑ, yerɑ bɑ dɑ bɑ nùn kukue ɡbɑɑ ten dɑ̃nun suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Adɑmɑ Yinni Gusunɔ u durɔ wi sokɑ u nɛɛ, mɑnɑ ɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Durɔ wi, u wisɑ u nɛɛ, ye nɑ wunɛn nɔɔ nuɑ ɡbɑɑru sɔɔ, bɛrum mɑn mwɑ domi tererɑ nɑ wɑ̃ɑ, mɑ nɑ kukuɑ. ");
INSERT INTO bba_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Gusunɔ u nɛɛ, wɑrɑ nun sɔ̃ɔwɑ mɑ tererɑ ɑ wɑ̃ɑ. Nɡe ɑ dɑ̃ɑ ten binu diwɑ te nɑ nɛɛ, ɑ ku di. ");
INSERT INTO bba_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Durɔ wi, u nɛɛ, kurɔ wi ɑ mɑn wɛ̃ u n kɑ mɑn wɑ̃ɑ wiyɑ mɑn dɑ̃ɑ ten binu wɛ̃ mɑ nɑ di. ");
INSERT INTO bba_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Mɑ Yinni Gusunɔ u kurɔ wi bikiɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ kuɑ mɛ. Mɑ u wisɑ u nɛɛ, wɑɑ yɑ mɑn kɔkurɑ nɑ kɑ di. ");
INSERT INTO bba_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Yinni Gusunɔ u wɑɑ ye sɔ̃ɔwɑ u nɛɛ, yèn sɔ̃ ɑ kuɑ mɛ, ɑ kuɑ bɔ̃rurɑ n yɛɛ kpuro kere. Wunɛn nukurɑ kɑɑ n dɑ kɑ kɑbiri. Temɑ kɑɑ n dɑ di sere kɑ wunɛn wɑ̃ɑrun nɔrɔ. ");
INSERT INTO bba_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Nɑ kon mɑɑ yibɛrɛ tɛɛru doke wunɛ kɑ kurɔ win bɑɑ sɔɔ, kɑ mɑɑ wunɛn bweseru kɑ win bweserun bɑɑ sɔɔ. Win bweserun ɡoo u koo nun wiru kɔrɑ, kɑɑ mɑɑ win nɑɑ tokuru mɛɛrɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Yerɑ u mɑɑ kurɔ wi sɔ̃ɔwɑ u nɛɛ, kon wunɛn ɡurɑn wɑhɑlɑ sosi. Kɑɑ n dɑ mɑwɑ kɑ nɔni swɑ̃ɑru. Wunɛn kĩru kpuro tɑ ko n wɑ̃ɑwɑ wunɛn durɔ sɔɔ, wiyɑ ko n mɑɑ sɑ̃ɑ wunɛn wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","19","U mɑɑ durɔ wi sɔ̃ɔwɑ u nɛɛ, yèn sɔ̃ ɑ wunɛn kurɔn ɡɑri wurɑ, mɑ ɑ dɑ̃ɑ ten binu di te nɑ nɛɛ, ɑ ku di, nɑ tem bɔ̃rusi wunɛn sɔ̃. Sɑ̃kunu kɑ ɑwĩiyɑ mu koo nun kpiiyɑ, wunɛn wɑ̃ɑru kpuro sɔɔ, nɔwiɑwɑ kɑɑ n dɑ ko kpɑ ɑ wɛnyɑ ɑ sere wunɛn dĩɑnu wɑ ɡberɔ. Yen biru kɑɑ ɡbi kpɑ bu nun sike temɔ, domi temɑ nɑ kɑ nun kuɑ. Kɑɑ mɑɑ wurɑ ɑ ko tem mɛ. ");
INSERT INTO bba_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Mɑ Adɑmu u win kurɔ yĩsiru kɑ̃ Efɑ, domi wiyɑ u sɑ̃ɑ tɔmbu kpuron mɛro. ");
INSERT INTO bba_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mɑ Yinni Gusunɔ u Adɑmu kɑ win kurɔ yɑɑ ɡɔnɑn yɑbenu kuɑ u bu sebusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Mɑ Yinni Gusunɔ u nɛɛ, wee tɔnu wi, u kuɑ nɡe mɛ nɑ sɑ̃ɑ, u ɡeɑ kɑ kɔ̃sɑ ɡiɑ. Tɛ̃ nɑ ǹ kon de u dɑ̃ɑ bii ni nu koo nùn wɑ̃ɑru wɛ̃ sɔri u di u n kɑ wɑ̃ɑ kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Yerɑ u nùn ɡirɑ Edɛnin ɡbɑɑ ten min di u dɑ u tem wuku mɛ u kɑ nùn mɔmɑ. ");
INSERT INTO bba_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nɡe mɛyɑ u kɑ Adɑmu ɡirɑ mɑ u wɔllun kɔ̃sobu doke Edɛnin ɡbɑɑ ten kɔnnɔwɔ, ɡe ɡɑ wɑ̃ɑ sɔ̃ɔ yɑri yerun berɑ ɡiɑ. Bɑ tɑkobi nɛni bɑ ye fĩɑmɔ mɑ yɑ bɑllimɔ sɔ̃ɔ sɔɔ nɡe dɔ̃ɔ yɑrɑ, bɑ kɑ dɑ̃ɑ tèn binu nu koo tɔnu wɑ̃ɑru wɛ̃ kɔ̃su. ");
INSERT INTO bba_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Yen biru Adɑmu kɑ win kurɔ Efɑ bɑ mɛnnɑ mɑ Efɑ u ɡurɑ suɑ u Kɑɛni mɑrɑ. Mɑ u nɛɛ, kɑ Yinni Gusunɔn somirɑ nɑ tɔnu tɑkɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Mɑ u mɑɑ ɡurɑ suɑ u Abɛli, Kɑɛnin wɔnɔ mɑrɑ. Abɛli wiyɑ u rɑ yɑ̃ɑnu kpɑre, Kɑɛni mɑɑ kuɑ ɡbee wuko. ");
INSERT INTO bba_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Sɔ̃ɔ mɛɛrun biru, Kɑɛni u kɑ win kɛ̃ru nɑ Yinni Gusunɔn mi, te tɑ sɑ̃ɑ win ɡberun dĩɑnu. ");
INSERT INTO bba_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Mɑ Abɛli mɑɑ kɑ wiɡiru nɑ te u ɡɔsɑ sɑɑ win yɑɑ sɑbenun bii ɡbiikinun di ni nu bɔɔru. Yinni Gusunɔ u kɑ Abɛli nɔni ɡeu mɛɛrɑ mɑ u win kɛ̃ru mwɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Adɑmɑ u ǹ kɑ Kɑɛni nɔnu ɡeu mɛɛrɑ, u ǹ mɑɑ win kɛ̃ru mwɛ. Mɑ Kɑɛni u mɔru bɑrɑ sere win wuswɑɑ burisinɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yerɑ Yinni Gusunɔ u Kɑɛni bikiɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ mɔru bɑre, mbɑn sɔ̃nɑ wunɛn wuswɑɑ burisinɛ. ");
INSERT INTO bba_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Geemɑ, ɑ̀ n ɡeɑ mɔ̀, wunɛn bwɛ̃rɑ ko n kpĩ. Ǹ n mɑɑ kɔ̃sɑn nɑ ɑ mɔ̀, durum yɑ kpĩ wunɛn dii kɔnnɔwɔ nɡe yɑɑ ɡɔbɑ yɑ nun mɑrɑ. Adɑmɑ ɑ de ɑ ye kɑmiɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Sɔ̃ɔ teeru Kɑɛni u win wɔnɔ Abɛli sɔ̃ɔwɑ u nɛɛ, su dɑ ɡberɔ. Sɑnɑm mɛ bɑ wɑ̃ɑ mi, yerɑ u win wɔnɔ wi sɛ̃re u ɡo. ");
INSERT INTO bba_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Mɑ Yinni Gusunɔ u dɑ Kɑɛnin mi, u nùn bikiɑ u nɛɛ, mɑnɑ wunɛn wɔnɔ Abɛli u wɑ̃ɑ. U wisɑ u nɛɛ, nɑ yɛ̃ ro? Nɛnɑ nɑ nɛn wɔnɔn kɔ̃so? ");
INSERT INTO bba_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mɑ Yinni Gusunɔ u kpɑm nɛɛ, mbɑ ɑ kuɑ mi. Wunɛn wɔnɔn yɛm mɛ mu yɑri temɔ, mu nɛn lɑɑkɑri seeye. ");
INSERT INTO bba_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Tɛ̃ kɑɑ ko bɔ̃ruro n kere tem mɛ ɑ derɑ mu wunɛn wɔnɔ win yɛm nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","À n tem mɛ wukɑ, mu ǹ mɑɑ nun dĩɑnu kuɑmmɛ sɑ̃ɑ sɑ̃ɑ. Kɑɑ n sɑ̃ɑwɑ kpiko kɑ yɑɑyɑɑre kowo hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Yerɑ Kɑɛni u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, wee, ɑ mɑn sɛɛyɑsiɑmɔ bi bu mɑn kere. ");
INSERT INTO bba_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","A mɑn ɡire ɡisɔ tem mɛn di. Nɑ dɔɔ nɑ n kukuɑ mi n tomɑ wunɛn min di, kpɑ nɑ n sɑ̃ɑ kpiko nɑ n yɑɑyɑɑre mɔ̀ hɑnduniɑ sɔɔ. Wi u mɑn wɑ kpuro, kpɑ u mɑn ɡo. ");
INSERT INTO bba_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Adɑmɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, ɑɑwo, n ǹ mɛ. Goo ù n nun ɡo, kon yɛ̃ro mɔru kɔsiɑwɑ tiɑ tiɑn nɔn nɔɔbɑ yiru. Mɑ u Kɑɛni yĩreru koosi, wi u nùn wɑ u ku kɑ nùn ɡon sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Mɑ Kɑɛni u doonɑ n tomɑ Yinni Gusunɔn min di, u dɑ u sinɑ Edɛnin sɔ̃ɔ yɑri yerun berɑ ɡiɑ, Nɔduɔ. Yĩsi ten tubusiɑnɑ yɑɑyɑɑren tem. ");
INSERT INTO bba_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Yen biru Kɑɛni kɑ win kurɔ bɑ mɛnnɑ mɑ kurɔ wi, u ɡurɑ suɑ u Enɔku mɑrɑ. Mɑ Kɑɛni u wuu ɡɑɡu bɑnɑ u ɡu sokɑ Enɔku nɡe win biin yĩsiru. ");
INSERT INTO bba_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enɔku wi, u Irɑdi mɑrɑ, Irɑdi mɑɑ Mɛhuyɑɛli mɑrɑ. Mɛhuyɑɛli u Mɛtusɑɛli mɑrɑ mɑ Mɛtusɑɛli u Lemɛki mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lemɛki wi, u kurɔbu yiru suɑ. Turon yĩsirɑ Adɑ, turoɡirɑ mɑɑ Silɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Adɑ u Yɑbɑli mɑrɑ. Wiyɑ u sɑ̃ɑ be bɑ wɑ̃ɑ kunɔ bɑ yɑɑ sɑbenu kpɑrɑmɔn bɑɑbɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Win wɔnɔn yĩsirɑ Yubɑli. Wiyɑ mɑɑ sɑ̃ɑ be bɑ rɑ mɔrɔkunu kɑ ɡuunu so kpuron bɑɑbɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Silɑ wi mɑɑ, u Tubɑli Kɑɛni mɑrɑ wi u rɑ dendi yɑ̃nu kpuro seku ye n sɑ̃ɑ sisu kɑ sii ɡɑndu. Win sesun yĩsirɑ Nɑɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Yerɑ Lemɛki u win kurɔbu sɔ̃ɔwɑ u nɛɛ, i mɑn swɑɑ dɑkio, bɛɛ nɛn kurɔbu, Adɑ kɑ Silɑ. Nɑ tɔnu ɡo bɛɛn sɔ̃ yèn sɔ̃ u mɑn mɛɛrɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Bɑ̀ n wi u Kɑɛni ɡo mɔru kɔsiɑ nɔn nɔɔbɑ yiru, bɑ koo nɛ Lemɛki mɔru kɔsiɑ nɔn wɑtɑ kɑ wɔkurɑ nɔɔbu kɑ yiru. ");
INSERT INTO bba_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adɑmu kɑ win kurɔ Efɑ bɑ mɛnnɑ kpɑm, mɑ Efɑ u ɡurɑ suɑ u bii tɔn durɔ mɑrɑ u nùn yĩsiru kɑ̃ Sɛti. U nɛɛ, domi Yinni Gusunɔ u kpɑm mɑn bii tɔn durɔ kɑ̃ u kuɑ Abɛlin kɔsire, wi Kɑɛni u ɡo. ");
INSERT INTO bba_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sɛtin tii, u bii tɔn durɔ mɑrɑ mɑ u nùn yĩsiru kɑ̃ Enɔsi. Sɑnɑm mɛ sɔɔrɑ tɔmbɑ Yinni Gusunɔ sɑ̃ɑru toruɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Wee nɡe mɛ bɑ Adɑmun bweserun yĩsɑ yoruɑ. Dɔmɑ te Gusunɔ u tɔn durɔ kɑ tɔn kurɔ tɑkɑ kuɑ u bu kuɑwɑ win weenɑsibu. ");
INSERT INTO bba_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","U bu sokɑ tɔmbu mɑ u bu domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Ye Adɑmu u kuɑ wɔ̃ɔ wunɑɑ teeru kɑ wɔkuru (130) u bii tɔn durɔ mɑrɑ wi u kɑ nùn weenɛ mɑm mɑm. Mɑ u nùn yĩsiru kɑ̃ Sɛti. ");
INSERT INTO bba_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sɛtin mɑrubun biru Adɑmu wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛnɛ (800). ");
INSERT INTO bba_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wunɑɑ teeru kɑ wɔkuru (930) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Ye Sɛti u kuɑ wɔ̃ɔ wunɔbu kɑ nɔɔbu (105), yerɑ u Enɔsi mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enɔsin mɑrubun biru, Sɛti wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛnɛ kɑ nɔɔbɑ yiru (807). ");
INSERT INTO bba_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wunɔbu kɑ wɔkurɑ yiru (912) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Ye Enɔsi u kuɑ wɔ̃ɔ wɛnɛ kɑ wɔkuru, yerɑ u Kenɑni mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenɑnin mɑrubun biru Enɔsi wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛnɛ kɑ wɔkurɑ nɔɔbu (815). ");
INSERT INTO bba_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wunɔbu kɑ nɔɔbu (905) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Ye Kenɑni u kuɑ wɔ̃ɔ wɑtɑ kɑ wɔkuru, yerɑ u Mɑhɑlɑlɛɛli mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mɑhɑlɑlɛɛlin mɑrubun biru Kenɑni wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛnɛ kɑ weeru (840). ");
INSERT INTO bba_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wunɔbu kɑ wɔkuru (910) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Ye Mɑhɑlɑlɛɛli u kuɑ wɔ̃ɔ wɑtɑ kɑ nɔɔbu, yerɑ u Yerɛdi mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yerɛdin mɑrubun biru Mɑhɑlɑlɛɛli wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛnɛ kɑ tɛnɑ (830). ");
INSERT INTO bba_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wɛnɛ kɑ wɔkurɑ nɔɔbu (895) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Ye Yerɛdi u kuɑ wɔ̃ɔ wunɑɑ wɑtɑ kɑ yiru (162), yerɑ u Enɔku mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Enɔkun mɑrubun biru Yerɛdi wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛnɛ (800). ");
INSERT INTO bba_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wunɑɑ wɑtɑ kɑ yiru (962) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Ye Enɔku u kuɑ wɔ̃ɔ wɑtɑ kɑ nɔɔbu, yerɑ u Mɛtuselɑ mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Mɛtuselɑn mɑrubun biru Enɔku wi, u kɑ Gusunɔ swĩinɑ. U bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ ɡoobɑ wunɔbu (300). ");
INSERT INTO bba_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","U kuɑwɑ wɔ̃ɔ ɡoobɑ wunɔbu kɑ wɑtɑ kɑ nɔɔbu (365). ");
INSERT INTO bba_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","U kɑ Gusunɔ swĩinɑ, yen biru u doonɑ wɔllɔ, domi Gusunɔ u nùn suɑwɑ wɑsiru. ");
INSERT INTO bba_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Ye Mɛtuselɑ u kuɑ wɔ̃ɔ wunɑɑ wɛnɛ kɑ nɔɔbɑ yiru (187), yerɑ u Lemɛki mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Lemɛkin mɑrubun biru Mɛtuselɑ wi, u bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɑtɑ kɑ wunɑɑ wɛnɛ kɑ yiru (782). ");
INSERT INTO bba_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","U kuɑwɑ wɔ̃ɔ nɛnɛ kɑ wunɑɑ wɑtɑ kɑ nɔɔbɑ nnɛ (969) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Ye Lemɛki u kuɑ wɔ̃ɔ wunɑɑ wɛnɛ kɑ yiru (182), u bii tɔn durɔ mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Mɑ u nùn yĩsiru kɑ̃ Nɔwɛ, u nɛɛ, winiwɑ koo sun somi bɛsɛn wɑsirɑru kɑ bɛsɛn sɔm sɛ̃sɔɡiɑ sɔɔ ye sɑ mɔ̀ yèn sɔ̃ Yinni Gusunɔ u tem bɔ̃rusi. ");
INSERT INTO bba_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nɔwɛn mɑrubun biru Lemɛki wi, u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛɛrɑ wunɔbu kɑ wɛnɛ kɑ wɔkurɑ nɔɔbu (595). ");
INSERT INTO bba_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","U kuɑwɑ wɔ̃ɔ nɑtɑ kɑ wunɑɑ wɑtɑ kɑ wɔkurɑ nɔɔbu kɑ yiru (777) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Ye Nɔwɛ u kuɑ wɔ̃ɔ nɛɛrɑ wunɔbu (500), yerɑ u Sɛmu kɑ Kɑmu kɑ Yɑfɛti mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Sɑnɑm mɛ tɔmbɑ kɔwɑrɑbu toruɑ hɑnduniɑ sɔɔ mɑ bɑ bii tɔn kurɔbu mɑrumɔ, ");
INSERT INTO bba_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Wɔllun tɔmbu ɡɑbɑ nɑ bɑ wɑ mɑ tɔmbun bii tɔn kurɔbu bɑ wɑ̃ mɑ bɑ tii kurɔbu ɡɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","4","Mɑ bɑ kɑ bu mɛnnɑ bɑ bibu mɑrɑ. Bii beyɑ bɑ kuɑ durɔ ɡbebunu hɑnduniɑ sɔɔ, ni nu rɑɑ yĩsiru yɑrɑ yellu. Mɑ Yinni Gusunɔ u nɛɛ, nɛn hunde kun ko n wɑ̃ɑ tɔmbu sɔɔ kɑ bɑɑdommɑɔ domi bɑ sɑ̃ɑwɑ be bɑ koo ɡbi. Kɑ mɛ, kon de bɑ n ɡinɑ wɑ̃ɑ wɔ̃ɔ wunɑɑ teeru. ");
INSERT INTO bba_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Domi u wɑ tɔmbun dɑɑ kɔ̃sɑ kpɛ̃ɑ hɑnduniɑ sɔɔ. Ben ɡɔ̃run bwisikunu nu rɑ n wɑ̃ɑwɑ kɔ̃sɑ sɔɔ bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mɑ win ɡɔ̃ru ɡɑ sɑnkirɑ yèn sɔ̃ u tɔmbu tɑkɑ kuɑ hɑnduniɑɔ. Yɑ nùn duɑ too sere win nukurɔ. ");
INSERT INTO bba_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Mɑ u nɛɛ, wi, u koo kpuro kpeerɑsiɑwɑ hɑnduniɑ sɔɔn di, sɑɑ tɔnun min di n kɑ ɡirɑri yɛɛyɔ yi yi rɑ sĩ kɑ yi yi rɑ kɑbiri kɑ ɡunɔsu. Domi win nukurɑ sɑnkirɑ yèn sɔ̃ u yebɑ kpuro tɑkɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Adɑmɑ Gusunɔ u kɑ Nɔwɛ nɔnu ɡeu mɛɛrɑ ");
INSERT INTO bba_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","10","domi u win woodɑbɑ mɛm nɔɔwɑ. U ǹ tɑɑrɛ mɔ win wɑɑti ye sɔɔ, mɑ u kɑ Gusunɔ swĩinɑ. Bii tɔn durɔbu itɑwɑ u mɑrɑ. Ben yĩsɑ wee, Sɛmu kɑ Kɑmu kɑ Yɑfɛti. ");
INSERT INTO bba_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Sɑɑ ye sɔɔ, hɑnduniɑn kɔ̃sɑ kpɛ̃ɑ Gusunɔn wuswɑɑɔ mɑ yɑ ɡɔbɑ bɑndɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Yerɑ u hɑnduniɑ mɛɛrimɑ u wɑ yen kɔ̃sɑ kpɛ̃ɑ domi hunde koni bɑɑyere yɑ yen dɑɑ sɑnkɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Mɑ u Nɔwɛ sɔ̃ɔwɑ u nɛɛ, nɑ ɡɔ̃ru doke n hunde konibɑ kpuro kpeerɑsiɑ, domi bɑ derɑ hɑnduniɑn ɡɔbɑ bɑndɑ. Kon bu kpeerɑsiɑ, be kɑ tem sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Adɑmɑ wunɛ Nɔwɛ, ɑ tii kpɑkoro bɑkɑru kuo kɑ dɑ̃ɑ dɑmɡiɑ, tɑ n dii sɔsu mɔ, kpɑ ɑ tu dɑ̃ɑ fĩifĩinu tɛɛni ten sɔɔwɔ kɑ tɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Amɛniwɑ kɑɑ tu koosinɑ. A de ten dɛ̃ɛbu bu n sɑ̃ɑ ɡɔm soonu ɡoobɑ wunɔbu (300) kpɑ ten yɑsum mu n sɑ̃ɑ ɡɔm soonu weerɑɑkuru, kpɑ ten ɡunum mu n sɑ̃ɑ ɡɔm soonu tɛnɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","A de tɑ n kpɛɛru mɔ wɔllɔ. Kpɛɛ te sɔɔ, kpɑ ɑ fɛnɛnti ko yen dɛ̃ɛbu kɑ yɑsum mu n sɑ̃ɑ ɡɔm soo teeru. Kpɑ ɑ kɔnnɔ yɑbɑ ten yɛ̃sɑɔ, ɑ kɛnutiru doke. A de tɑ n sɑ̃ɑ ɡidɑmbisɑ itɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Wee, kon de nim yibu bɑkɑru tu nɑ tem sɔɔ, tu hunde koni bɑɑyere kpeerɑsiɑ hɑnduniɑ sɔɔ. Ye yɑ wɑ̃ɑ tem sɔɔ kpuro yɑ koo ɡbiwɑ. ");
INSERT INTO bba_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Adɑmɑ wunɑ kon wure n kɑ nɛn ɑrukɑwɑni bɔke. Kɑɑ du kpɑkoro te sɔɔ, wunɛ kɑ wunɛn kurɔ kɑ wunɛn bibu kɑ ben kurɔbu sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Hunde koni bɑɑyere, yen yiruwɑ kɑɑ mɑɑ duusiɑ dwɑɑ kɑ niɑ kpɑkoro te sɔɔ kɑ wunɛ sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Gunɔsu kɑ yɛɛ yi yi rɑ kɑbiri, ye kpuron bwese bwesekɑ sɔɔ, yiru yiruwɑ yɑ koo nɑ wunɛn mi, ɑ kɑ ye fɑɑbɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","A mɑɑ dĩɑ ni bɑ rɑ di kpuro mɛnnɔ ɑ yi kpɑ nu ko wunɛ kɑ yɛɛ yin dĩɑnu. ");
INSERT INTO bba_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Mɑ Nɔwɛ u kuɑ kpuro ye Gusunɔ u nùn yiire. ");
INSERT INTO bba_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Yen biruwɑ Yinni Gusunɔ u Nɔwɛ sɔ̃ɔwɑ u nɛɛ, wunɑ nɑ wɑ ɑ mɑn mɛm nɔɔwɑmmɛ sɑɑ yenin tɔmbu sɔɔ. Yen sɔ̃, i duo kpɑkoro te sɔɔ, wunɛ kɑ wunɛn yɛnuɡibu kpuro. ");
INSERT INTO bba_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kpɑ ɑ kɑ yɛɛ yi kɑɑ kɑ yɑ̃kuru ko du yiru yirun wɑsi nɔɔbɑ yiru dwɑɑ kɑ niɑ, kɑ mɑɑ yɛɛ yi yi tien yiru yiru dwɑɑ kɑ niɑ, ");
INSERT INTO bba_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","kɑ mɑɑ ɡunɔsu yiru yirun wɑsi nɔɔbɑ yiru dɔɔ kɑ niu su kɑ wɑ su bweseru tiɑrɑ hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Domi sɔ̃ɔ nɔɔbɑ yirun biru kon de ɡurɑ yu nɛ sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru kpɑ n hunde koni bɑɑyere kɑm koosiɑ ye nɑ tɑkɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Mɑ Nɔwɛ u kuɑ kpuro ye Yinni Gusunɔ u nùn yiire. ");
INSERT INTO bba_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Sɑnɑm mɛ nim yibu bɑkɑrɑ tunumɑ, Nɔwɛ u mɔwɑ wɔ̃ɔ nɑtɑ (600). ");
INSERT INTO bba_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Mɑ u duɑ kpɑkoro te sɔɔ kɑ win kurɔ kɑ win bibu kɑ ben kurɔbu bu kɑ wɑ bu nim yibu bɑkɑ te suuri. ");
INSERT INTO bba_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Yɛɛ yi bɑ koo kɑ yɑ̃kuru ko kɑ yi yi tie kɑ ɡunɔsu kɑ yɛɛ kpuro yi yi kɑbirimɔ temɔ, ");
INSERT INTO bba_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","yen bɑɑyere yɑ duɑ kpɑkoro te sɔɔ yiru yiru dwɑɑ kɑ niɑ kɑ Nɔwɛ sɑnnu nɡe mɛ Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Sɔ̃ɔ nɔɔbɑ yirun biru nim yibu bɑkɑ te, tɑ tunumɑ tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Nɔwɛn wɔ̃ɔ nɑtɑsen suru yirusen sɔ̃ɔ wɔkurɑ nɔɔbu kɑ yiruse sɔɔ, yerɑ n sɑ̃ɑre nɡe bɑ wɔru bɔkɔ kɔriɑ mɑ nim mu kurɑmɑ kɑ dɑm tem di, mɑ ɡurɑ nɛmɔ nɡe wɔllɑ ɡɛ̃ɛrɑ. ");
INSERT INTO bba_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Gurɑ ye, yɑ nɑwɑ tem sɔɔ sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru. ");
INSERT INTO bba_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Tɔ̃ɔ te sɔɔrɑ Nɔwɛ duɑ kpɑkoro te sɔɔ, wi kɑ win kurɔ kɑ win bibu itɑ be, Sɛmu kɑ Kɑmu kɑ Yɑfɛti, kɑ mɑɑ ben kurɔbu itɑ, ");
INSERT INTO bba_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","be kɑ ɡbeeku yɛɛ kɑ yɑɑ sɑbenu kɑ yɛɛ yi yi rɑ kɑbiri kɑ ɡunɔsu kɑ sere ye yɑ kɑsɑ mɔ, ye kpuro bwese bwesekɑ. ");
INSERT INTO bba_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","16","Hunde koni bɑɑyere kpuro ɡesi, yɑ duɑwɑ kɑ Nɔwɛ sɑnnu ɡoo ɡe sɔɔ yiru yiru dwɑɑ kɑ niɑ, nɡe mɛ Gusunɔ u Nɔwɛ sɔ̃ɔwɑ. Mɑ Yinni Gusunɔ u nùn kɛnusi. ");
INSERT INTO bba_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","18","Gurɑ nɛmɔ mɑ nim mu kpɛ̃ɑmɔ tem sɔɔ sere sɔ̃ɔ weeru, mu tɛriɑmɔ mu kpɑkoro te yĩiyɑ mɑ tɑ seewɑ tem di tɑ ɡɛruɑ mɛn wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Mɑ mu kpɛ̃ɑmɔ mu sosimɔ sere mu ɡuu bɑkɑnu kpuro mwɛ tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Mu kpɑm ɡuniɑ ɡuunun wɔllun di sere ɡɔm soonu wɔkurɑ nɔɔbu. ");
INSERT INTO bba_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Mɑ hunde koni bɑɑyere hɑnduniɑ sɔɔ yɑ ɡu, sɑɑ tɔmbu sere kɑ yɑɑ sɑbenu kɑ ɡbeeku yɛɛ kɑ ɡunɔsu kɑ ye yɑ kɑbirimɔ temɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Ye yɑ wɛ̃siɑmɔ tem dirɑ sɔɔ kpuro ɡesi yɑ ɡuwɑ. ");
INSERT INTO bba_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Hunde konibɑ kpuro hɑnduniɑɔ bɑ kɑm kuɑwɑ, sɑɑ tɔnu sere yɛɛ nɑɑsu nnɛɡii kɑ yi yi rɑ kɑbiri kɑ ɡunɔsu. Kpurowɑ n kɑm kuɑ, mɑ n kun mɔ Nɔwɛ turo kɑ sere win tɔmbu kɑ yɛɛ yi yi wɑ̃ɑ kpɑkoro te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Mɑ nim mɛ, mu tɛrie hɑnduniɑ sɔɔ sɔ̃ɔ wunɑɑ weeru kɑ wɔkuru. ");
INSERT INTO bba_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Adɑmɑ Gusunɔ kun Nɔwɛ duɑri kɑ ɡbeeku yɛɛ kpuro kɑ yɑɑ sɑbe ni kpuro yi yi kɑ nùn wɑ̃ɑ kpɑkoro te sɔɔ. Mɑ u derɑ woo ɡɑ kuɑ tem sɔɔ mɑ nim mɛ, mu kɑɑrɑm toruɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Nim mɛ mu kurɑmɔ tem di mu yɔ̃rɑ, wɔllɑ mɑɑ kɛnuɑ, ɡurɑ yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nim mu doonɑmɔ fiiko fiiko. Sɔ̃ɔ wunɑɑ weeru kɑ wɔkurun biru mɑ mu kɑɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurɑ nɔɔbu kɑ yiruse sɔɔ, yerɑ kpɑkoro te, tɑ dɑ tɑ yɔ̃rɑ ɡuu te bɑ mɔ̀ Arɑrɑtin wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Nim mu kɑɑrɑmɔ sere n kɑ kuɑ suru wɔkuruse. Suru win tɔ̃ɔ ɡbiikiru sɔɔrɑ ɡuunun wii wɔllɑ terɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Ye n mɑɑ kuɑ sɔ̃ɔ weeru, mɑ Nɔwɛ u kpɑkoro ten fɛnɛnti wukiɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","U ɡbɑnɑmɡbɑɑru yɔ̃su tɑ n kɑ yɑɑyɑɑre mɔ̀ tɑ n dɑɑmɔ tɑ n wurɑmɑmɔ sere nim mu kɑ ɡberɑ temɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Yen biru u totobɛrɛru yɔ̃su u kɑ wɑ nim mù n kɑɑrɑ temɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Adɑmɑ totobɛrɛ te, tɑ ǹ ɑyeru wɑ mi tɑ koo surɑ. Mɑ tɑ wurɑ win mi, kpɑkoro te sɔɔ, yèn sɔ̃ nim ɡinɑ tie tem sɔɔ kpuro. Mɑ Nɔwɛ u nɔmu dɛmiɑ u tu mwɑ u doke kpɑkororu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","U mɑɑ mɑrɑ n kuɑ sɔ̃ɔ nɔɔbɑ yiru u sere mɑɑ totobɛrɛ te yɔ̃su. ");
INSERT INTO bba_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Tɑ wurɑmɑ win mi yokɑ tɑ dɑ̃ɑ wuru beku nɔɔ bɛri. Mɑ Nɔwɛ u ɡiɑ mɑ nim mu kɑɑrɑwɑ temɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Mɑ u mɑɑ mɑrɑ sɔ̃ɔ nɔɔbɑ yiru, u kpɑm totobɛrɛ te yɔ̃su. Tɑ ǹ mɑɑ wurɑmɛ win mi. ");
INSERT INTO bba_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Yen dɔmɑ terɑ n kuɑ Nɔwɛn wɔ̃ɔ nɑtɑ kɑ tiɑsen (601) suru ɡbiikoon tɔ̃ɔ ɡbiikiru. Mɑ u kpɑkoro te kpɛɛyɑ u deemɑ wee, nim mu kpɑ tem mu ɡberɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ye n kuɑ suru yirusen sɔ̃ɔ yɛndɑ nɔɔbu kɑ yiru, yerɑ u deemɑ wee, tem mu ɡberɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Yerɑ Gusunɔ u Nɔwɛ sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","i yɑrio kpɑkororun di wunɛ kɑ wunɛn kurɔ kɑ wunɛn bibu kɑ ben kurɔbu. ");
INSERT INTO bba_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","I kɑ yɛɛ bwese bwesekɑ kpuro yɑrio sɑɑ ɡunɔsu sere yɛɛ nɑɑsu nnɛɡii kɑ yɛɛ yi yi rɑ kɑbiri temɔ, kpɑ yi mɑrurɑ yi dɑbiɑ kpɑ yi tɛriɑ temɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Mɑ Nɔwɛ u yɑrɑ wi kɑ win kurɔ kɑ win bibu kɑ ben kurɔbu. ");
INSERT INTO bba_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Mɑ yɛɛ yi yi nɑɑsu nnɛ mɔ kpuro kɑ yi yi rɑ kɑbiri kɑ ɡunɔsu kpuro, yɑɑ bɑɑyere ɡesi ye yɑ wɑ̃ɑ temɔ kpurowɑ yɑ yɑrɑ ɡoon di, bɑɑyere kɑ yen bweseru. ");
INSERT INTO bba_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Sɑɑ yerɑ Nɔwɛ u yɑ̃ku yeru bɑnɑ mi u koo Yinni Gusunɔ sɑ̃. Mɑ u yɛɛ kɑ ɡunɔsu ɡɔsɑ bweseru bɑɑtere sɔɔ te bɑ rɑ kɑ yɑ̃kuru ko. Mɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ yɑ̃ku yee ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Mɑ Yinni Gusunɔ u yɑ̃ku ni mwɑ mɑ u tii sɔ̃ɔwɑ u nɛɛ, nɑ ǹ kon mɑɑ tem bɔ̃rusi tɔnun sɔ̃. Domi tɔnun ɡɔ̃run bwisikunu sɑ̃ɑwɑ kɔ̃sunu sɑɑ win birun di. Nɑ ǹ mɑɑ hunde konibɑ kpuro kpeerɑsiɑmɔ nɡe mɛ nɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Sere duniɑ yu kɑ kpe, duurubu kɑ ɡɛ̃ɛbun sɑɑ kɑ wooru kɑ yɑm susurun sɑɑ kɑ sɔ̃ɔ sɑ̃reru kɑ wuburun sɑɑ, kɑ sere mɑɑ sɔ̃ɔ sɔɔ kɑ wɔ̃kuru, yen ɡɑɑ kun kpeemɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yen biru Gusunɔ u Nɔwɛ kɑ win bibu domɑru kuɑ u nɛɛ, i mɑruro i dɑbiɑ kpɑ i yibu tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Hɑnduniɑn yɑɑ bɑɑyere kɑ ɡunɔ bɑɑɡere kɑ ye yɑ kɑbirimɔ temɔ kɑ swɑ̃ɑ bɑɑyere nim wɔ̃ku sɔɔ yɑ ko n bɛɛn bɛrum mɔ, domi nɑ bɛɛ ye kpuro nɔmu sɔndiɑ. ");
INSERT INTO bba_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Ye yɑ sĩimɔ yɑ wɑsi kpuro, yɑ ko n sɑ̃ɑwɑ bɛɛn dĩɑnu nɡe mɛ nɑ rɑɑ bɛɛ dɑ̃ɑ binu kɑ yɑkɑ bii wɛ̃, mɛyɑ nɑ mɑɑ bɛɛ ye kpuro wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Adɑmɑ i ku yɑɑ tem kɑ yen yɛm sɑnnu, i kun ye sɑke, domi yen yɛmɑ mu derɑ yɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","I n mɑɑ yɛ̃ mɑ hunde koni bɑɑyere ye yɑ tɔnu ɡo, kon ye win yɛm kɔsire bikiɑ. ");
INSERT INTO bba_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Wi u tɔnun yɛm yɑri, tɔnuwɑ koo mɑɑ yɛ̃ron yɛm yɑri, domi nɑ tɔnu tɑkɑ kuɑwɑ nɛn weenɑsii. ");
INSERT INTO bba_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Adɑmɑ i n mɑrurɑmɔ i n dɑbiɑmɔ kpɑ i tɛriɑ tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Gusunɔ u kpɑm Nɔwɛ kɑ win bibu sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","wee, nɑ wure nɑ kɑ bɛɛ nɛn ɑrukɑwɑni bɔkumɔ kɑ bɛɛn bwese te tɑ koo mɑrurɑ bɛɛn min di, ");
INSERT INTO bba_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","kɑ sere hunde koni bɑɑyere ye yɑ kɑ bɛɛ wɑ̃ɑ, sɑɑ ɡunɔsu sere yɑɑ sɑbenu kɑ ɡbeeku yɛɛ yi yi kɑ bɛɛ yɑrɑ kpɑkoro ten di kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Arukɑwɑni yerɑ, nim yiburu tɑ ǹ mɑɑ hunde konibɑ kpuro kɑm koosiɑmɔ, mɛyɑ tɑ ǹ mɑɑ hɑnduniɑ kpeesiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Arukɑwɑni ye nɑ wure nɑ bɔkumɔ kɑ bɛɛ kɑ hunde koni bɑɑyere sere kɑ bɑɑdommɑɔ, yen yĩreru wee. ");
INSERT INTO bba_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Terɑ ɡuru wɑɑ ye nɑ dokemɔ wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Nɑ̀ n ɡuru winu doke wɔllɔ, ɡuru wɑɑ ye, yɑ koo sɔ̃ɔsirɑ ni sɔɔ, ");
INSERT INTO bba_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","kpɑ n nɛn ɑrukɑwɑni yɑɑyɑ ye nɑ kɑ bɛɛ bɔkuɑ kɑ hunde koni bɑɑyere, kpɑ nim mu ku mɑɑ yibu mu sere bɑɑyere kɑm koosiɑ ye yɑ wɑsi. ");
INSERT INTO bba_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Guru wɑɑ ye, yɑ koo sɔ̃ɔsirɑ ɡuru wiru sɔɔ. Nɑ̀ n ye mɛɛrɑ kpɑ n ɑrukɑwɑni nɔru sɑriɡiɑ ye yɑɑyɑ ye yɑ wɑ̃ɑ nɛ Gusunɔ kɑ hunde koni bɑɑyeren bɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Nɛn ɑrukɑwɑni yen yĩrerɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nɔwɛn bibu itɑ be bɑ rɑɑ duɑ kpɑkoro te sɔɔ bɑ yɑrɑ, berɑ Sɛmu kɑ Kɑmu kɑ Yɑfɛti. Kɑmu sɑ̃ɑwɑ Kɑnɑnin tundo. ");
INSERT INTO bba_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Be itɑ beyɑ bɑ sɑ̃ɑ Nɔwɛn bibu. Ben min diyɑ hɑnduniɑɡibɑ tɛriɑrɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Sɑnɑm mɛyɑ Nɔwɛ u wukubu toruɑ u dɑ̃ɑ bii ni bɑ mɔ̀ resɛm duurɑ. ");
INSERT INTO bba_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Sɔ̃ɔ teeru u nin tɑm nɔrɑ yɑ nùn ɡoomɔ, mɑ u dɑ win kurɔ u kpunɑ tereru. ");
INSERT INTO bba_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Ye Kɑmu Kɑnɑnin tundo u win bɑɑn tere te wɑ u dɑ tɔɔwɔ u win mɔɔ kɑ wɔnɔ, Sɛmu kɑ Yɑfɛti sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Yerɑ bɑ nɑ bɑ kumbooro suɑ bɑ sɔndi ben senɔ bɑ kɑ birum birum sĩɑ bɑ ben tundon tereru wukiri. Bɑ ǹ tu wɑ yèn sɔ̃ bɑ ben wuswɑɑ sĩiyɛ. ");
INSERT INTO bba_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Sɑnɑm mɛ Nɔwɛn tɑm mu kpɑllɑ, yerɑ u nuɑ ye win bii yiruse u nùn kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Mɑ u nɛɛ, kɑm koorewɑ Kɑnɑni. U koo kowɑ win mɑɑbu kɑ win wɔnɔbun yoo. ");
INSERT INTO bba_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","U mɑɑ nɛɛ, bu Gusunɔ siɑro wi u sɑ̃ɑ Sɛmun Yinni. Wiyɑ u koo Kɑnɑni ko Sɛmun yoo, ");
INSERT INTO bba_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","kpɑ u mɑɑ Yɑfɛti dukiɑ sosiɑ, u de wi kɑ Sɛmu bɑ n wɑ̃ɑ sɑnnu, kpɑ Kɑnɑni u ko ben yoo. ");
INSERT INTO bba_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nim yibu bɑkɑ ten biru Nɔwɛ u kuɑ wɔ̃ɔ ɡoobɑ wunɔbu kɑ weerɑɑkuru (350). ");
INSERT INTO bba_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Win wɔ̃ɔ kpuro ɡɑ kuɑwɑ nɛnɛ kɑ wunɑɑ weeru kɑ wɔkuru (950) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Nɔwɛn bibu Sɛmu kɑ Kɑmu kɑ Yɑfɛti ben bweseru wee. Be itɑ kpuro bɑ bibu mɑrɑ nim yibu bɑkɑ ten biru. ");
INSERT INTO bba_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Be Yɑfɛti u mɑrɑ be wee, Gomɛɛ kɑ Mɑɡɔɡu kɑ Mɑdɑi kɑ Yɑfɑni kɑ Tubɑli kɑ Mɛsɛki kɑ Tirɑsi. ");
INSERT INTO bba_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Mɑ Gomɛɛ u seewɑ u mɑɑ Asikenɑsi kɑ Rifɑti kɑ Toɡɑɑmɑ mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Yɑfɑniwɑ u mɑɑ Elisɑ kɑ Tɑɑsisi kɑ Kitimu kɑ Dodɑnimu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Yɑfɛtin bwese terɑ tɑ dɑ tɑ sinɑ nim wɔ̃kun bɔkuɔ kɑ tem burenɔ. Miyɑ bɑ mɑrurɑ mɑ ben bɑɑwure u dɑ u sinɑ yɑm tem kɑ win bwese kɛrɑ, bɑ ben bɑrum ɡerumɔ. ");
INSERT INTO bba_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Be bɑ mɑɑ sɑ̃ɑ Kɑmun bibu, be wee, Kusi kɑ Misirɑimu kɑ Puti kɑ Kɑnɑni. ");
INSERT INTO bba_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Kusi u seewɑ mɑ u Sɑbɑ kɑ Hɑfilɑ kɑ Sɑbutɑ mɑrɑ kɑ Rɑemɑ kɑ Sɑbutekɑ. Rɑemɑ u mɑɑ seewɑ u Sebɑ kɑ Dedɑni mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kusi u mɑɑ bii mɑrɑ wi bɑ sokumɔ Nimurodu. Wiyɑ u ɡbiɑ u kuɑ wɔruɡɔ dɑmɡii hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Yinni Gusunɔ u derɑ u kuɑ tɑɑso ɡeon tii tii. Yen sɔ̃nɑ bɑ rɑ mɔndu ɡɑru ko bu nɛɛ, Yinni Gusunɔ u nun ko tɑɑso ɡeo nɡe Nimurodu. ");
INSERT INTO bba_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimurodu wi, u ɡinɑ ɡbiɑ u bɑndu di Bɑbɛliɔ kɑ Erɛkiɔ kɑ Akɑdiɔ kɑ Kɑlinɛɔ Sinɛɑn temɔ. ");
INSERT INTO bba_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Tem min diyɑ u yɑrɑ u dɑ Asirin temɔ. Mɑ u wuu sini bɑnɑ si bɑ mɔ̀ Ninifu kɑ Rehobɔtuhiro kɑ Kɑlɑsi, ");
INSERT INTO bba_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","kɑ mɑɑ Resɛni, Ninifu kɑ Kɑlɑsin bɑɑ sɔɔ. Wuu si kpuro su kuɑwɑ wuu bɔkɔ teu. ");
INSERT INTO bba_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misirɑimu wiyɑ u Ludibɑ mɑrɑ kɑ Anɑnibɑ kɑ Lehɑbubɑ kɑ Nɑfitubɑ ");
INSERT INTO bba_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","kɑ Pɑturusiɡibu kɑ Kɑfitoriɡibu kɑ Kɑsuluɡibu mìn di Filisitibɑn bweserɑ yɑrimɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kɑnɑni u mɑɑ Sidoni mɑrɑ. Wiyɑ u sɑ̃ɑ win bii ɡbiikoo. Mɑ u mɑɑ Hɛti mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Win bibun ɡɑbɑ bɑ kuɑ Yebusibɑ kɑ Amɔrebɑ kɑ Giriɡɑsibɑ ");
INSERT INTO bba_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","kɑ Hefibɑ kɑ Aɑkibɑ kɑ Sinibɑ ");
INSERT INTO bba_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","kɑ mɑɑ Aɑfɑdibɑ kɑ Semɑriɡibu kɑ Hɑmɑtibɑ. Yen biru Kɑnɑnin bwese kɛri yi, yi yɑrinɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Yi dɑ dɑ Sidoniɔ, Gerɑn berɑ ɡiɑ sere kɑ Gɑsɑɔ kɑ mɑɑ Sodomuɔ kɑ Gomɔrɑ ɡiɑ kɑ Adimɑ kɑ Seboimuɔ n kɑ ɡirɑri Lesɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Beyɑ bɑ sɑ̃ɑ Kɑmun bibu. Mɑ ben bɑɑwure u dɑ u sinɑ yɑm tem kɑ win bwese kɛrɑ, bɑ ben bɑrum ɡerumɔ. ");
INSERT INTO bba_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Be bɑ mɑɑ sɑ̃ɑ Sɛmu, Yɑfɛtin mɔɔn bibun bweseru beyɑ Heberubɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ben yĩsɑ wee, Elɑmu kɑ Asuri kɑ Aɑpɑsɑdi kɑ Ludi kɑ Arɑmu. ");
INSERT INTO bba_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Mɑ Arɑmu u seewɑ u mɑɑ Usi kɑ Uli mɑrɑ kɑ Getɛɛ kɑ Mɑsi. ");
INSERT INTO bba_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Aɑpɑsɑdi u mɑɑ Selɑ mɑrɑ. Mɑ Selɑ u mɑɑ Heberu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Mɑ Heberu u bii tɔn durɔbu yiru mɑrɑ. Turowɑ bɑ sokumɔ Pelɛɡi, yèn sɔ̃ win wɑɑti sɔɔrɑ duniɑɡibɑ tem bɔnu kuɑ. Win wɔnɔn yĩsirɑ mɑɑ Yokutɑni. ");
INSERT INTO bba_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Mɑ Yokutɑni wi, u mɑɑ Alimɔdɑdi mɑrɑ kɑ Selɛfu kɑ Hɑsɑmɑfɛti kɑ Yerɑɑ ");
INSERT INTO bba_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","kɑ Hɑdorɑmu kɑ Usɑli kɑ Dikilɑ ");
INSERT INTO bba_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","kɑ Obɑli kɑ Abimɑɛli kɑ Sɑbɑ ");
INSERT INTO bba_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","kɑ Ofiri kɑ Hɑfilɑ kɑ Yobɑbu. Be kpurowɑ bɑ sɑ̃ɑ Yokutɑnin bibu. ");
INSERT INTO bba_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Bɑ sinɑwɑ sɑɑ Mɛsɑn di sere kɑ ɡuu te tɑ wɑ̃ɑ sɔ̃ɔ yɑri yeru ɡiɑ te bɑ mɔ̀ Sefɑɑ. ");
INSERT INTO bba_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Be bɑ sɑ̃ɑ Sɛmun bibu berɑ mi. Mɑ ben bɑɑwure u dɑ u sinɑ yɑm tem kɑ win bwese kɛrɑ, bɑ ben bɑrum ɡerumɔ. ");
INSERT INTO bba_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nɡe mɛ Nɔwɛn bibun bweserun kɛri yi sɑ̃ɑ kɑ sere mɑɑ tem mi bɑ dɑ bɑ wɑ̃ɑ wɑ̃ɑ kɑ bɑrum mɛ kɛrɑ bɑɑyere yɑ rɑ ɡere, mɛyɑ mi. Ben min diyɑ hɑnduniɑn bweseru bɑɑtere tɑ yɑrɑ nim yibu bɑkɑ ten biru. ");
INSERT INTO bba_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","N deemɑ yellu hɑnduniɑ kpuro sɔɔ, bɑrum temɑ bɑ rɑ ɡere mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Mɑ bɑ seewɑ bɑ doonɑ sɑɑ sɔ̃ɔ yɑri yerun di bɑ bɑtumɑ deemɑ Sinɛɑn temɔ mɑ bɑ sin yeru kuɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Yerɑ bɑ ɡerunɑ bɑ nɛɛ, too, i de su biriki murɑ su ye wɔ̃ yu ɡberɑ. Mɑ bɑ kɑ biriki ye bɑnɑ kuɑ yèn sɔ̃ bɑ ǹ kpenu mɔ. Mɑ bɑ kɔntɑɑ kuɑ ben simɑɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Bɑ kpɑm nɛɛ, i de su wuu swĩi kpɑ su ɡidɑmbisɑ bɑni yèn wii kpiirɑ koo wɔllu ɡirɑri, kpɑ su yĩsiru yɑri kpɑ su ku yɑrinɑ hɑnduniɑ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Yerɑ Yinni Gusunɔ u sɑrɑmɑ u kɑ wuu ɡe kɑ ɡidɑmbisɑ ye mɛɛri ye tɔmbɑ bɑnimɔ mi. ");
INSERT INTO bba_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Mɑ u nɛɛ, be wee, bɑ sɑ̃ɑ bwese teeru bɑ mɑɑ bɑrum tem ɡerumɔ mɑ bɑ bwisikɑ bu yeni ko. Sɑɑ tɛ̃n di ɡɑ̃ɑnu kun bu yinɑrimɔ bu kɑ ko ye bɑ bwisikɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Yen sɔ̃, kon sɑrɑ n dɑ n ben bɑrum burisinɑ kpɑ bu ku mɑɑ nɔɔsinɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Yerɑ Yinni Gusunɔ u bu yɑrinɑsiɑ n tomɑ min di, bɑ wuu ɡen bɑnɑ deri bɑ dɑ bɑ pusɑ tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Yen sɔ̃nɑ bɑ wuu ɡe sokɑ Bɑbɛli, domi miyɑ Yinni Gusunɔ u bɑrum burisinɑ. Min diyɑ u mɑɑ tɔmbu kpuro yɑrinɑsiɑ bɑ pusɑ hɑnduniɑ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sɛmun bibun bweseru wee. Nim yibu bɑkɑ ten biru n kuɑ wɔ̃ɔ yiru yerɑ u Aɑpɑsɑdi mɑrɑ. N deemɑ sɑɑ ye sɔɔrɑ u mɔ wɔ̃ɔ wunɔbu (100). ");
INSERT INTO bba_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Aɑpɑsɑdin mɑrubun biru Sɛmu u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛɛrɑ wunɔbu (500). ");
INSERT INTO bba_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Ye Aɑpɑsɑdi u kuɑ wɔ̃ɔ tɛnɑ kɑ nɔɔbu mɑ u Selɑ mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Selɑn mɑrubun biru Aɑpɑsɑdi u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛɛru kɑ itɑ (403). ");
INSERT INTO bba_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Ye Selɑ u kuɑ wɔ̃ɔ tɛnɑ mɑ u Heberu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Heberun mɑrubun biru Selɑ u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛɛru kɑ itɑ (403). ");
INSERT INTO bba_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Heberu u kuɑ wɔ̃ɔ tɛnɑ kɑ nnɛ mɑ u Pelɛɡi mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Pelɛɡin mɑrubun biru Heberu u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ nɛɛru kɑ tɛnɑ (430). ");
INSERT INTO bba_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Pelɛɡi u kuɑ wɔ̃ɔ tɛnɑ mɑ u Rehu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Rehun mɑrubun biru Pelɛɡi u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ ɡoobu kɑ nɔɔbɑ nnɛ (209). ");
INSERT INTO bba_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Rehu u kuɑ wɔ̃ɔ tɛnɑ kɑ yiru mɑ u Seruɡu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruɡun mɑrubun biru Rehu u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ ɡoobu kɑ nɔɔbɑ yiru (207). ");
INSERT INTO bba_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Ye Seruɡu u kuɑ wɔ̃ɔ tɛnɑ mɑ u Nɑkori mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nɑkorin mɑrubun biru Seruɡu u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ ɡoobu (200). ");
INSERT INTO bba_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Ye Nɑkori u kuɑ wɔ̃ɔ tɛnɑ tiɑ sɑri mɑ u Terɑ mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Terɑn mɑrubun biru Nɑkori u mɑɑ bii tɔn durɔbu kɑ tɔn kurɔbu mɑrumɔ sere n kɑ kuɑ wɔ̃ɔ wunɑɑ teeru tiɑ sɑri (119). ");
INSERT INTO bba_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Terɑ u kuɑ wɔ̃ɔ wɑtɑ kɑ wɔkuru mɑ u Aburɑmu kɑ Nɑkori kɑ Hɑrɑni mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Terɑn bibun bweseru wee. Terɑ u Aburɑmu mɑrɑ kɑ Nɑkori kɑ Hɑrɑni. Mɑ Hɑrɑni u seewɑ u Lɔtu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Hɑrɑni wi, u ɡu ben wuu Uru sɔɔ, Kɑlɑden temɔ mi bɑ nùn mɑrɑ, win tundo Terɑ u sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Aburɑmu kɑ Nɑkori bɑ kurɔbu suɑ. Aburɑmun kurɔn yĩsirɑ Sɑɑrɑi, Nɑkoriɡiin yĩsirɑ mɑɑ Milikɑ. Wi kɑ Yisikɑ bɑ sɑ̃ɑwɑ Hɑrɑnin bibu. ");
INSERT INTO bba_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Sɑɑrɑi u sɑ̃ɑwɑ wĩro, u ǹ bii mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Yen biru Terɑ u win bii Aburɑmu suɑ kɑ Sɑɑrɑi Aburɑmun kurɔ kɑ Lɔtu Hɑrɑnin bii, bɑ seewɑ bɑ yɑrɑ sɑnnu Urun di Kɑlɑden temɔ bɑ dɔɔ Kɑnɑnin temɔ. Ye bɑ turɑ wuu ɡe bɑ mɔ̀ Kɑrɑniɔ mɑ bɑ sinɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Ye Terɑ u kuɑ wɔ̃ɔ ɡoobu kɑ nɔɔbu (205) mɑ u kpunɑ u ɡu Hɑrɑni mi. ");
INSERT INTO bba_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Yen biruwɑ Yinni Gusunɔ u Aburɑmu sɔ̃ɔwɑ u nɛɛ, ɑ seewo wunɛn tem di ɑ wunɛn wuu deri kɑ wunɛn tundon yɛnu ɑ dɑ tem ɡɑm mi kon nun sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Wunɛn min diyɑ kon de bwese bɑkɑru tu yɑri. Kon nun domɑru kuɑ kpɑ wunɛn yĩsiru tu kpɛ̃ɑ kpɑ ɑ ko domɑrun nuuru. ");
INSERT INTO bba_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Bɑɑwure wi u nun domɑru kuɑ, kon mɑɑ yɛ̃ro domɑru kuɑ. Wi u mɑɑ nun bɔ̃rusi, kon yɛ̃ro bɔ̃rusi. Wunɛn min diyɑ hɑnduniɑn tɔmbu kpuro bɑ koo domɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yerɑ Aburɑmu u swɑɑ wɔri nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ mɑ bɑ dɑ sɑnnu kɑ Lɔtu. Sɑnɑm mɛ bɑ yɑrɑ Hɑrɑnin di, Aburɑmu u mɔwɑ wɔ̃ɔ wɑtɑ kɑ wɔkurɑ nɔɔbu. ");
INSERT INTO bba_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","U win kurɔ Sɑɑrɑi suɑ kɑ Lɔtu win wɔnɔn bii kɑ ben ɑrumɑni ye bɑ mɔ kpuro kɑ sɔm kowo be bɑ wɑ Hɑrɑniɔ. Be kpurowɑ bɑ swɑɑ wɔri mɑ bɑ turɑ Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Ye bɑ turɑ mi, mɑ Aburɑmu u tem mɛ bukiɑnɑ sere u kɑ turɑ Sikɛmuɔ mi dɑ̃ɑ sɔ̃ɔ ɡɑ wɑ̃ɑ ɡe bɑ mɔ̀ Mɔre. Kɑnɑnibɑ mɑɑ wɑ̃ɑ tem mɛ sɔɔ, sɑɑ ye. ");
INSERT INTO bba_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Sɔ̃ɔ teeru yerɑ Yinni Gusunɔ u Aburɑmu kure u nɛɛ, wunɛn bibun bweserɑ kon tem mɛ wɛ̃. Mɑ u yɑ̃ku yeru bɑnɑ u kɑ Yinni Gusunɔ sɑ̃ wi u nùn kure mi. ");
INSERT INTO bba_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yen biruwɑ u seewɑ min di u dɑ ɡuuru ɡɑrun berɑ ɡiɑ Betɛlin sɔ̃ɔ yɑri yerɔ u win dii bekuruɡinu ɡirɑ. U Betɛli mɛɛrɑ sɔ̃ɔ kpee yeru ɡiɑ, Ayi mɑɑ sɔ̃ɔ yɑri yerɔ. Miyɑ u mɑɑ yɑ̃ku yeru bɑnɑ u Yinni Gusunɔ sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Mɑ u mɑɑ seewɑ u win sɑnum wɔri u dɔɔ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ Nɛɡɛbuɔ. ");
INSERT INTO bba_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Ye Aburɑmu u turɑ mi, yerɑ ɡɔ̃ɔrɑ tunumɑ tem mɛ sɔɔ. Mɑ u seewɑ u dɑ Eɡibitin temɔ u sinɑ mi, domi ɡɔ̃ɔ te, tɑ kpɛ̃ɑ win tem mi. ");
INSERT INTO bba_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Sɑnɑm mɛ bɑ Eɡibitin tem turuku kuɑ, Aburɑmu u win kurɔ Sɑɑrɑi sɔ̃ɔwɑ u nɛɛ, wee wunɛ kurɔ burɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Eɡibitiɡibu bɑ̀ n nun wɑ bɑ koo nɛɛ, ɑ sɑ̃ɑ nɛn kurɔ kpɑ bu mɑn ɡo bu nun deri. ");
INSERT INTO bba_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Nɑ nun kɑnɑmɔ, ɑ nɛɛ, wunɛ nɛn sesuwɑ kpɑ bu ku mɑn wɑhɑlɑ ko wunɛn sɔ̃, kpɑ ɑ wɑ ɑ nɛn wiru dwe. ");
INSERT INTO bba_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Ye bɑ turɑ Eɡibitiɔ, Eɡibitiɡibɑ wɑ mɑ kurɔ wi, u wɑ̃ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Eɡibiti sunɔn bwɑ̃ɑbɑ nùn wɑ mɑ bɑ nɑ bɑ sunɔ kurɔ win burɑm ɡɑri sɑɑriɑ, mɑ sunɔ u derɑ bɑ kɑ nùn nɑ win mi. ");
INSERT INTO bba_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mɑ u Aburɑmu ɡeɑ kuɑ ɡem ɡem kurɔ win sɔ̃. U nùn yɑ̃ɑnu kɑ̃ kɑ nɛɛ kɑ kɛtɛkunu kɑ kɛtɛku mɛrobu kɑ yooyoosu kɑ yoo tɔn durɔbu kɑ tɔn kurɔbu. ");
INSERT INTO bba_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Adɑmɑ Yinni Gusunɔ u sunɔ wi kɑ win yɛnuɡibu kpuro wɑhɑlɑ bɑkɑ doke Sɑɑrɑi, Aburɑmun kurɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Yerɑ u Aburɑmu sokɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ mɑn kuɑ mɛ. Mbɑn sɔ̃nɑ ɑ ǹ mɑn sɔ̃ɔwɑ mɑ wunɛn kurɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Mɑ ɑ nɛɛ, wunɛn sesuwɑ, ɑ derɑ nɑ nùn suɑ kurɔ. Tɛ̃ wunɛn kurɔ wee, ɑ nùn suo ɑ kɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mɑ u woodɑ wɛ̃ bu de u doonɑ kɑ win kurɔ kɑ win ye u mɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Mɑ Aburɑmu u seewɑ Eɡibitin di u wurɑ Nɛɡɛbu ɡiɑ wi kɑ win kurɔ kɑ ye u mɔ kpuro kɑ Lɔtu sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Aburɑmu u sɑ̃ɑwɑ dukiɑɡii. U yɑɑ sɑbenu mɔ kɑ sii ɡeesu kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Mɑ u sɑnum so Nɛɡɛbun di u dɑ Betɛli ɡiɑ u turɑ mi u rɑɑ win dii bekuruɡinu ɡirɑ Betɛli kɑ Ayin bɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Miyɑ u Yinni Gusunɔ sɑ̃wɑ mi u rɑɑ yɑ̃ku yeru bɑnɑ. ");
INSERT INTO bba_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","N deemɑ Lɔtu u mɑɑ yɑ̃ɑnu mɔ kɑ nɛɛ kɑ dii bekuruɡinu u kɑ Aburɑmu swĩi. ");
INSERT INTO bba_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Ben ɑrumɑni ye, yɑ kpɑ̃ sere yɑm mi bɑ wɑ̃ɑ mu ǹ turɑ bɑ n kɑ wɑ̃ɑ mi sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Yen sɔ̃nɑ sɑnnɔ ɡɑ duɑ Aburɑmun kpɑrobu kɑ Lɔtuɡibun suunu sɔɔ. N deemɑ Kɑnɑnibɑ kɑ Feresibɑ bɑ wɑ̃ɑ tem mɛ sɔɔ sɑnɑm mɛ. ");
INSERT INTO bba_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yerɑ Aburɑmu u Lɔtu sɔ̃ɔwɑ u nɛɛ, nɑ nun kɑnɑmɔ, ɑ ku de sikirinɔ ɡɑ n wɑ̃ɑ nɛ kɑ wunɛn suunu sɔɔ, ǹ kun mɛ nɛn kpɑrobu kɑ wunɛɡibun suunu sɔɔ. Domi bɛsɛ dusinɑ. ");
INSERT INTO bba_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","A ǹ tem wɑɑmɔ kpuro wunɛn wuswɑɑɔ? A de su kɑbɑnɑ. À n dɑ nɔm dwɑrɔ, kon dɑ nɔm ɡeuɔ, ǹ n mɑɑ nɔm ɡeu ɡiɑn nɑ ɑ dɑ, kon dɑ nɔm dwɑrɔ. ");
INSERT INTO bba_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Mɑ Lɔtu u nɔni seeyɑ u Yuudɛnin dɑɑrun berɑ mɛɛrɑ sere n kɑ dɑ wuu ɡe bɑ mɔ̀ Soɑri. U wɑ tem mu ɡeɑ sɑ̃ɑ mu nike nikeru mɔ nɡe ɡbɑɑ te Yinni Gusunɔ u kuɑ Edɛniɔ, ǹ kun mɛ Eɡibitin tem. N deemɑ Yinni Gusunɔ kun ɡinɑ Sodomu kɑ Gomɔrɑ kpeerɑsie. ");
INSERT INTO bba_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Yerɑ Lɔtu u Yuudɛnin wɔwɑ ye kpuro tii ɡɔsiɑ mɑ u dɑ sɔ̃ɔ yɑri yeru ɡiɑ. Mɛyɑ n kuɑ bɑ kɑ kɑrɑnɑ. ");
INSERT INTO bba_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Aburɑmu u sinɑ Kɑnɑnin temɔ, Lɔtu u mɑɑ dɑ u sinɑ wɔwɑ yen wusun bɔkuɔ mɑ u kɑ win dii bekuruɡinu susimɔ sere kɑ Sodomuɔ. ");
INSERT INTO bba_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Sodomuɡibu wee, tɔn kɔ̃sobɑ. Bɑ sɑ̃ɑwɑ durumɡibu mɑm mɑm Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Ye Lɔtu kɑ Aburɑmu bɑ kɑrɑnɑ bɑ kpɑ, yerɑ Yinni Gusunɔ u Aburɑmu sɔ̃ɔwɑ u nɛɛ, ɑ nɔni seeyo kpɑ ɑ sɔ̃ɔ yɑri yeru kɑ duu yeru mɛɛri n tomɑ kɑ sɔ̃ɔ yɛ̃si yɛ̃sikɑ. ");
INSERT INTO bba_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Domi tem mɛ ɑ wɑɑmɔ mi kpuro, wunɛ kɑ wunɛn bibun bweserɑ kon mu wɛ̃ kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Kon wunɛn bibun bweseru dɑbiɑsiɑ nɡe yɑnim. Wi u koo kpĩ u yɑnim ɡɑri wiyɑ u koo mɑɑ kpĩ u wunɛn bibun bweseru ɡɑri. ");
INSERT INTO bba_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","A seewo ɑ tem mɛ bɔsu kpɑ ɑ mɛn kpɑ̃ɑru wɑ nɡe mɛ mu nɛ. Domi wunɑ kon mu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Mɑ Aburɑmu u win dii bekuruɡinu kpɑrenu kuɑ u dɑ u sinɑ Mɑnden sɔ̃ɔwɔ, wuu ɡe bɑ mɔ̀ Heboronin bɔkuɔ. Mɑ u yɑ̃ku yeru bɑnɑ u kɑ Yinni Gusunɔ sɑ̃ mi. ");
INSERT INTO bba_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Sɑnɑm mɛ Amurɑfɛli u sɑ̃ɑ Sinɛɑn sunɔ, mɑ Ariɔku sɑ̃ɑ Elɑsɑn sunɔ, mɑ Kedolɑmɛɛ sɑ̃ɑ Elɑmun sunɔ, mɑ Tideɑli sɑ̃ɑ Goyimun sunɔ, ");
INSERT INTO bba_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","sɑnɑm mɛyɑ sinɑm be, bɑ tɑbu kuɑ kɑ Berɑ, Sodomun sunɔ, kɑ Birisɑ, Gomɔrɑn sunɔ, kɑ Sinɛɑbu, Adimɑn sunɔ, kɑ Semɛbɛɛ, Seboimun sunɔ, kɑ Belɑn sunɔ ye bɑ mɑɑ sokumɔ Soɑri. ");
INSERT INTO bba_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Beni kpurowɑ bɑ mɛnnɑ nim wɔ̃ku bɔruɡuu ɡe bɑ mɑɑ sokumɔ Sidimu, ɡen wɔwɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","N deemɑ wɔ̃ɔ wɔkurɑ yiruwɑ bɑ Kedolɑmɛɛ yoru diiyɑ, ɑdɑmɑ wɔ̃ɔ wɔkurɑ itɑse sɔɔ bɑ seewɑ bɑ kɑ tii yinɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Yerɑ wɔ̃ɔ wɔkurɑ nnɛse, Kedolɑmɛɛ kɑ sinɑm be bɑ wɑ̃ɑ kɑ wi, bɑ tɑbu dɑ mɑ bɑ Refɑbɑ tɑbu di Asiterɔtu Kɑɑnɑimuɔ, mɑ bɑ Susibɑ tɑbu di Hɑmuɔ, mɑ bɑ Emibɑ tɑbu di Sɑfe Kiriɑtɑimuɔ. ");
INSERT INTO bba_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Bɑ mɑɑ Horibɑ tɑbu di ben ɡuu te bɑ mɔ̀ Seiriɔ sere Pɑrɑnin sɔ̃ɔwɔ ɡe ɡɑ wɑ̃ɑ ɡbɑburun berɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yen biru bɑ ɡɔsirɑmɑ bɑ dɑ Eni Misipɑtiɔ, ye bɑ mɑɑ sokumɔ Kɑdɛsi. Miyɑ bɑ Amɑlɛkibɑ tɑbu wɔri bɑ kɑmiɑ ben tem kpuro sɔɔ kɑ Amɔrebɑ be bɑ tɛrie Hɑsɑsɔntɑmɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Yerɑ Sodomun sunɔ seewɑ kɑ Gomɔrɑn sunɔ kɑ Adimɑn sunɔ kɑ Seboimun sunɔ kɑ Belɑn sunɔ ye bɑ mɑɑ sokumɔ Soɑri, bɑ dɑ bɑ kɑ sinɑm be tɑbu yinnɑ Sidimun wɔwɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Sinɑm beyɑ Kedolɑmɛɛ, Elɑmun sunɔ, kɑ Tideɑli, Goyimun sunɔ, kɑ Amurɑfɛli, Sinɛɑn sunɔ, kɑ Ariɔku, Elɑsɑn sunɔ. Sinɑmbu nnɛ be, bɑ kɑ nɔɔbu be tɑbu mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sidimun wɔwɑ miyɑ kɔntɑɑn wɔrusu wɑ̃ɑ nɡe dɔkɔbɑ. Yerɑ Sodomun sunɔ kɑ Gomɔrɑn sunɔ bɑ duki suɑ bɑ dɑ bɑ wɔriki si sɔɔ. Be bɑ tie bɑ mɑɑ duki doonɑ ɡuunu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Be bɑ bu tɑbu di, bɑ Sodomu kɑ Gomɔrɑɡibun dukiɑ ɡurɑ kɑ ben dĩɑnu kpuro bɑ kɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Bɑ mɑɑ Aburɑmun wɔnɔn bii Lɔtu mwɑ wi u wɑ̃ɑ Sodomuɔ kɑ win dukiɑ kpuro bɑ kɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Yerɑ durɔ ɡoo wi u kpikiru suɑ Sodomun di u nɑ u Aburɑmu, Heberu wi sɔ̃ɔwɑ. N deemɑ Aburɑmu u sɔ̃ Mɑnden sɔ̃ɔwɔ. Mɑnde sɑ̃ɑwɑ Amɔren bweseru, Ɛsikoli kɑ Anɛɛn wɔnɔ, be bɑ ɑrukɑwɑni bɔkuɑ kɑ Aburɑmu. ");
INSERT INTO bba_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Ye Aburɑmu u nuɑ mɑ bɑ win wɔnɔn bii yoru mwɑ, yerɑ u win sɔm kowo wɔruɡɔbɑ ɡɔsɑ ɡoobɑ wunɔbu kɑ wɔkurɑ nɔɔbu kɑ itɑ (318) be bɑ mɑrɑ win yɛnuɔ u bu tɑbu yɑ̃nu wɛ̃. Mɑ u kɑ sinɑm be nɑɑ ɡirɑ sere Dɑnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Mɑ u win tɔmbu bɔnu kuɑ u kɑ bu wɔri wɔ̃kuru, wi kɑ win sɔm kowobu. U bu tɑbu di mɑ u bu nɑɑ swĩi sere Kobɑɔ, ye yɑ wɑ̃ɑ Dɑmɑsin sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","U dukiɑ ye kpuro wɔrɑmɑ mɑ u win wɔnɔn bii Lɔtu wɔrɑmɑ kɑ win ye u mɔ kɑ sere mɑɑ tɔn be bɑ rɑɑ mwɛɛrɑ kɑ ben kurɔbu. ");
INSERT INTO bba_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Ye Aburɑmu u Kedolɑmɛɛ kɑ sinɑm be bɑ wɑ̃ɑ kɑ wi tɑbu diimɑ u wee, Sodomun sunɔ u nùn sennɔ dɑ Sɑfen wɔwɑɔ ye bɑ mɑɑ sokumɔ sunɔn wɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mɑ Mɛɛkisidɛki, Sɑlɛmun sunɔ u kɑ pɛ̃ɛ nɑ mi kɑ tɑm. Durɔ wi sɑ̃ɑwɑ Wɔrukoon yɑ̃ku kowo. ");
INSERT INTO bba_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","U Aburɑmu domɑru kuɑ u nɛɛ, Gusunɔ, wi, wi u kpuro kere, u mɑɑ wɔllu kɑ tem tɑkɑ kuɑ, u koo nun domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Wiɡiɑ siɑrɑbu domi u nun wunɛn wɛrɔbu nɔmu bɛriɑ. Mɑ Aburɑmu u ye u wɑɑmɑ kpuron wɔkuru bɑɑteren wɔllɔ tiɑ tiɑ suɑ u Mɛɛkisidɛki wi wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Yen biru Sodomun sunɔ u Aburɑmu sɔ̃ɔwɑ u nɛɛ, ɑ mɑn tɔmbu wɛ̃ɛyɔ kpɑ ɑ dukiɑ suɑ yu ko wunɛɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Aburɑmu u Sodomun sunɔ wisɑ u nɛɛ, nɑ nɔmu suɑ wɔllɔ nɑ bɔ̃ruɑ kɑ Gusunɔn yĩsiru, wi, wi u kpuro kere u mɑɑ wɔllu kɑ tem tɑkɑ kuɑ, ");
INSERT INTO bba_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","mɑ nɑ ǹ ɡɑ̃ɑnu ɡɑnu suɑmɔ ni nu sɑ̃ɑ wunɛɡinu bɑɑ wɛ̃ɛ siirɑ, bɑɑ bɑrɑ wɛ̃ru kpɑ ɑ ku rɑ kɑ nɛɛ, wunɑ ɑ mɑn kuɑ dukiɑɡii. Nɑ ǹ ɡɑ̃ɑnu ɡɑnu suɑmɔ, ");
INSERT INTO bba_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","mɑ n kun mɔ ye nɛn ɑluwɑɑsibɑ bɑ di. Adɑmɑ ɑ de Anɛɛ kɑ Ɛsikoli kɑ Mɑnde be bɑ kɑ mɑn dɑ bu ben bɔnu suɑ. ");
INSERT INTO bba_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Yenibɑ kpuron biru Yinni Gusunɔ u kɑ Aburɑmu ɡɑri kuɑ kɑ̃siru sɔɔ u nɛɛ, Aburɑmu, ɑ ku bɛrum ko, nɛnɑ nɑ wunɛn tɛrɛru, wunɛn ɑre ko n kpɑ̃ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Aburɑmu nùn wisɑ u nɛɛ, Yinni Gusunɔ, mbɑ kɑɑ mɑɑ mɑn wɛ̃. Wee nɑ ɡɔɔ dɔɔ bii sɑri kpɑ Ɛliesɛɛ Dɑmɑsiɡii u ko nɛn tubi dio. ");
INSERT INTO bba_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Yèn sɔ̃ ɑ ǹ mɑn bii kɑ̃, nɛn yoo Ɛliesɛɛ wi bɑ mɑrɑ nɛn yɛnuɔ wiyɑ koo nɛn tubi di. ");
INSERT INTO bba_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Yerɑ Yinni Gusunɔ u Aburɑmu sɔ̃ɔwɑ u nɛɛ, n ǹ wi, u koo ko wunɛn tubi dio. Wunɛn tii tiin biiwɑ u koo wunɛn tubi di. ");
INSERT INTO bba_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mɑ Gusunɔ u kɑ nùn dɑ tɔɔwɔ u nɛɛ, ɑ wɔllu mɛɛrio kpɑ ɑ kperi ɡɑri, ɑ̀ n kɑɑ kpĩ. Nɡe mɛyɑ wunɛn bweserɑ koo dɑbiru nɛrɑ. ");
INSERT INTO bba_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Mɑ Aburɑmu u Yinni Gusunɔ nɑɑnɛ kuɑ. Yen sɔ̃nɑ Gusunɔ u nùn ɡɑrisi ɡemɡii. ");
INSERT INTO bba_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Mɑ u kpɑm nùn sɔ̃ɔwɑ u nɛɛ, nɛnɑ nɑ Yinni Gusunɔ, nɛ wi nɑ nun yɑrɑmɑ sɑɑ Urun di Kɑlɑden temɔ kpɑ n kɑ nun tem mɛni wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Adɑmɑ u wisɑ u nɛɛ, Yinni Gusunɔ, ɑmɔnɑ ko nɑ n kɑ yɛ̃ mɑ tem mɛni mu koo ko nɛɡim. ");
INSERT INTO bba_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mɑ Yinni Gusunɔ u nɛɛ, ɑ nɑɑ ɡbiibɑ wɔ̃ɔ itɑɡiɑ tɑmɑ kɑ boo niu wɔ̃ɔ itɑɡuu, kɑ yɑ̃ɑ kinɛru wɔ̃ɔ itɑɡiru kɑ kpɑruko kɑ totobɛrɛ buu kpɑ ɑ mɑn ye ɡoowɑ ɑ yi. ");
INSERT INTO bba_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Yerɑ Aburɑmu u yɛɛ yi kpuro mɛnnɑ u yi ɡo u bɛrɑnɑ yiru u yin bɛsi yi u kɑrinɑsiɑ, ɑdɑmɑ u ǹ ɡunɔsu bɛre si. ");
INSERT INTO bba_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yɑberekunu nu sɑrɑmɑ yɑɑ ɡoo ni sɔɔ, mɑ Aburɑmu u nu ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Ye sɔ̃ɔ duɔ, dom mɔn bɑkɑrɑ Aburɑmu wɔri mɑ bɛrum nùn mwɑ yɑm wɔ̃ku te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Yerɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, ɑ n yɛ̃ mɑ wunɛn bibun bweserɑ tɑ koo tem tukumɔ sinɑ mi bɑ koo bu yoru diisiɑ kpɑ bu bu nɔni sɔ̃ sere wɔ̃ɔ nɛɛru (400). ");
INSERT INTO bba_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","16","Adɑmɑ kon tem mɛn tɔmbu siri be bɑ koo bu yoo te diisiɑ. Wɔ̃ɔ dɑbirun biru bɑ koo yɑri tem min di kɑ dukiɑ bɑkɑ kpɑ bu kpɑm ɡɔsirɑmɑ mini, domi Amɔrebɑn durum kun ɡinɑ yibɑ n kɑ bu kpeerɑsiɑ. Adɑmɑ wunɛ kɑɑ tɔkɔ kowɑ kɔ̃ɔ kɔ̃ɔ kpɑ ɑ dɑ ɑ wunɛn bɑɑbɑbɑ deemɑ kɑ ɑlɑfiɑ. ");
INSERT INTO bba_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Ye sɔ̃ɔ kpɑ yɑm tĩrɑ niki niki, yerɑ Gusunɔ u kurɑmɑ yɑɑ bɛsi yin kpoo kpookɑ sɔɔ. U sɑ̃ɑ nɡe dɔ̃ɔ bokon wiisu kɑ dɔ̃ɔ yɑri. ");
INSERT INTO bba_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nɡe mɛyɑ u kɑ Aburɑmu ɑrukɑwɑni bɔkuɑ tɔ̃ɔ te sɔɔ u nɛɛ, wunɛn bweserɑ kon tem mɛni wɛ̃ sɑɑ dɑɑ piibu ɡe ɡɑ wɑ̃ɑ Eɡibitin tem nɔɔ burɑ yerun di sere dɑɑ bɑkɑ ten mi, te bɑ mɔ̀ Efɑrɑti. ");
INSERT INTO bba_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Tem mɛ, mu sɑ̃ɑwɑ Kenibɑn tem kɑ Kenisibɑɡim kɑ Kɑdimɔnibɑɡim ");
INSERT INTO bba_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kɑ Hɛtibɑɡim kɑ Feresibɑɡim kɑ Refɑbɑn tem, ");
INSERT INTO bba_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","kɑ Amɔrebɑn tem kɑ Kɑnɑnibɑn tem kɑ Giriɡɑsibɑn tem kɑ Yebusibɑn tem. ");
INSERT INTO bba_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Aburɑmu kɑ win kurɔ Sɑɑrɑi bɑ ǹ bii mɑrɑ. Wee Sɑɑrɑi wi, u yoo tɔn kurɔ ɡoo mɔ wi u sɑ̃ɑ Eɡibitiɡii. Win yĩsirɑ Aɡɑɑ. ");
INSERT INTO bba_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Mɑ Sɑɑrɑi u win durɔ sɔ̃ɔwɑ u nɛɛ, wee, Yinni Gusunɔ u mɑn kuɑ wĩro. Nɑ nun kɑnɑmɔ, ɑ kɑ nɛn yoo duo. Sɔrɔkudo kon bibu wɑ sɑɑ win min di. M ɑ Aburɑmu u win kurɔn ɡɑri wurɑ. ");
INSERT INTO bba_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Sɑɑ ye sɔɔrɑ Sɑɑrɑi u win yoo Aɡɑɑ wi suɑ u win durɔ kɑ̃ kurɔ. N deemɑ bɑ wɔ̃ɔ wɔkuru kuɑ kɔ Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Mɑ Aburɑmu u kɑ Aɡɑɑ mɛnnɑ mɑ Aɡɑɑ u ɡurɑ suɑ. Ye u wɑ u ɡurɑ mɔ, yerɑ u win yinni Sɑɑrɑi ɡɛndu wɔri. ");
INSERT INTO bba_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Mɑ Sɑɑrɑi u Aburɑmu sɔ̃ɔwɑ u nɛɛ, nɛn wɔmburu tu wɔri wunɛ sɔɔ. Nɑ nun nɛn yoo kɑ̃ kurɔ, ɑdɑmɑ ye u wɑ mɑ u ɡurɑ mɔ, yerɑ u mɑn ɡɛndu wɔri. Yinni Gusunɔwɑ koo sun siriɑ nɛ kɑ wunɛ. ");
INSERT INTO bba_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Aburɑmu u Sɑɑrɑi wisɑ u nɛɛ, wunɑ ɑ wunɛn yoo mɔ, ɑ kɑ nùn koowo nɡe mɛ ɑ kĩ. Sɑɑ yerɑ u Aɡɑɑ nɔni mɛni mɑ Aɡɑɑ u dukɑ suɑ win min di. ");
INSERT INTO bba_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Yinni Gusunɔn ɡɔrɑdo u nùn wɑ ɡbɑburɔ bwiɑ ɡɑɑn bɔkuɔ Surin swɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","U nɛɛ, Aɡɑɑ, Sɑɑrɑin yoo, mɑn diyɑ ɑ wee. Mɑnɑ ɑ dɔɔ. Aɡɑɑ u nɛɛ, nɑ dukɑ suɔwɑ nɛn yinni Sɑɑrɑin min di. ");
INSERT INTO bba_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Mɑ ɡɔrɑdo wi, u nùn sɔ̃ɔwɑ u nɛɛ, ɑ ɡɔsiro wunɛn yinnin mi, kpɑ ɑ nùn wiru kpĩiyɑ. ");
INSERT INTO bba_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Kon wunɛn bweseru dɑbiɑsiɑ sere ɡoo kun kpɛ̃ u tu ɡɑri. ");
INSERT INTO bba_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Wee ɑ ɡurɑ mɔ, kɑɑ bii tɔn durɔ mɑ kpɑ ɑ nùn yĩsiru kɛ̃ Isimɛɛli. Domi Yinni Gusunɔ u wunɛn nɔɔ nuɑ nɔni swɑ̃ɑ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Bii wi, u ko n sɑ̃ɑwɑ nɡe kɛtɛku ɡbeeku. U ko n kɑ tɔmbu kpuro nɔɔ ɡɔmunu mɔ̀. Tɔmbu kpuro bɑ koo mɑɑ kɑ nùn nɔɔ ɡɔmunu ko. U ko n kɑ win dusibu tondinɛ. ");
INSERT INTO bba_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Ye Yinni Gusunɔ u kɑ Aɡɑɑ ɡɑri yi kuɑ u kpɑ, mɑ Aɡɑɑ u nùn yĩsiru kɑ̃ u nɛɛ, wunɑ Yinni wi u wɑɑmɔ. Domi u tii bikiɑ u nɛɛ, kɑ ɡem nɑ Gusunɔ wɑ kɑ nɔni, mɑ nɑ wɑ̃ɑ nɑ ǹ ɡu? ");
INSERT INTO bba_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Yen sɔ̃nɑ bɑ dɔkɔ ye sokɑ Gusunɔ u mɑn wɑɑmɔ. Dɔkɔ ye, yɑ wɑ̃ɑwɑ Kɑdɛsi kɑ Bɑrɛdin bɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Yen biru Aɡɑɑ u Aburɑmu bii tɔn durɔ mɑruɑ, mɑ Aburɑmu u bii wi yĩsiru kɑ̃ Isimɛɛli. ");
INSERT INTO bba_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aburɑmun wɔ̃ɔ ɡɑ sɑ̃ɑwɑ wɛnɛ kɑ nɔɔbɑ tiɑ sɑnɑm mɛ bɑ Isimɛɛli mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ye Aburɑmu kuɑ wɔ̃ɔ wunɔbu tiɑ sɑri yerɑ Yinni Gusunɔ u nùn kure u nɛɛ, nɛnɑ nɑ Gusunɔ Dɑm kpuroɡii. A n sĩimɔ nɛn wuswɑɑɔ kpɑ ɑ kun tɑɑrɛ mɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Kon kɑ nun ɑrukɑwɑni bɔke kpɑ n wunɛn bweseru dɑbiɑsiɑ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Yerɑ Aburɑmu u yiirɑ mii mii u wuswɑɑ tem ɡirɑri. Mɑ Gusunɔ u kpɑm kɑ nùn ɡɑri kuɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","nɛn ɑrukɑwɑni wee, ye nɑ kɑ nun bɔkumɔ. Kon nun kowɑ bwese dɑbinun bɑɑbɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Bɑ ǹ koo mɑɑ nun soku Aburɑmu, bɑ koo nun sokuwɑ Aburɑhɑmu, ye yɑ ɡerumɔ bwese dɑbinun bɑɑbɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Kon de wunɛn bibu bu mɑrurɑ bu sosi sere bɑ ǹ ɡɑrirɔ, kpɑ bwesenu kɑ sinɑmbu bu kɔwɑrɑ wunɛn min di. ");
INSERT INTO bba_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Kon wure n kɑ bɛɛ nɛn ɑrukɑwɑni bɔke, wunɛ kɑ wunɛn bibu kɑ ben bweseru kpuro kpɑ nɑ n sɑ̃ɑ wunɛn Yinni kɑ wunɛn bweserun Yinni sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Kpɑ n wunɛ kɑ wunɛn bibun bweseru Kɑnɑnin tem mɛ wɛ̃, mɛ̀ sɔɔ ɑ wɑ̃ɑ mi, ɑ sɔru dimɔ. Mɛ kpuro mu koo ko beɡim sere kɑ bɑɑdommɑɔ kpɑ nɑ n sɑ̃ɑ ben Yinni. ");
INSERT INTO bba_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Mɑ u kpɑm Aburɑhɑmu sɔ̃ɔwɑ u nɛɛ, i nɛn ɑrukɑwɑni nɛnuɔ, wunɛ kɑ wunɛn bibun bweseru. A ku de bu ye duɑri wunɛn bweserɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Arukɑwɑni ye wee, ye nɑ kɑ bɛɛ bɔkumɔ, ye i ko nɛnɛ wunɛ kɑ wunɛn bibun bweseru. I ko i tɔn durɔ bɑɑwure bɑnɡo kuɑ wi u wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kpɑ yɑ n sɑ̃ɑ ɑrukɑwɑni yen yĩreru ye yɑ wɑ̃ɑ nɛ kɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","I n dɑ bii tɔn durɔ bɑɑwure bɑnɡo kue ù n sɔ̃ɔ nɔɔbɑ itɑ turɑ. N ǹ mɔ be bɑ mɑrɑ bɛɛn yɛnuɔ tɔnɑ, kɑ mɑɑ be i kɑ ɡobi dwɑwɑ tɔn tukobun mi. ");
INSERT INTO bba_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","I ko be kpuro bɑnɡo kuɑwɑ kpɑ nɛn ɑrukɑwɑni yen yĩreru tɑ n wɑ̃ɑ bɛɛn wɑsi sɔɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Tɔn durɔ wi bɑ ǹ bɑnɡo kue, i ko i nùn wunɑwɑ wiɡibun min di i ɡo. Domi u nɛn ɑrukɑwɑni sɑnkɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Gusunɔ u kpɑm Aburɑhɑmu sɔ̃ɔwɑ u nɛɛ, ɑ ku mɑɑ wunɛn kurɔ soku Sɑɑrɑi. Sɑɑrɑɑwɑ kɑɑ n dɑ nùn soku. ");
INSERT INTO bba_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Kon nùn domɑru kuɑ kpɑ u nun bii tɔn durɔ mɑruɑ. Nɛn domɑ ten sɑɑbu bwese dɑbinu kɑ sinɑmbu bɑ koo kɔwɑrɑ win min di. ");
INSERT INTO bba_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yerɑ Aburɑhɑmu u Gusunɔ yiirɑ mii mii u siriru tem ɡirɑri u yɛ̃ɛ mɑ u ɡeruɑ win tii sɔɔ u nɛɛ, bɑ koo mɑɑ tɔnu wɔ̃ɔ wunɔbuɡii bii mɑruɑ? Sɑɑrɑɑ wi u kuɑ wɔ̃ɔ wɛnɛ kɑ wɔkuru mini, u koo bii mɑ? ");
INSERT INTO bba_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Yerɑ u Gusunɔ sɔ̃ɔwɑ u nɛɛ, ɑ de Isimɛɛlin sɑnu sɑnusu su nun wɛ̃re kpɑ u nɛn tubi di. ");
INSERT INTO bba_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Mɑ Gusunɔ u nɛɛ, ɑɑwo, wunɛn kurɔ Sɑɑrɑɑwɑ koo nun bii tɔn durɔ mɑruɑ kɑm kɑm, kpɑ ɑ nùn yĩsiru kɛ̃ Isɑki. Wiyɑ kon wure n kɑ nɛn ɑrukɑwɑni bɔke ye yɑ ǹ kpeemɔ win bweserɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Mɛyɑ nɑ wunɛn kɑnɑru nuɑ te ɑ kuɑ Isimɛɛlin sɔ̃. Wee, kon mɑɑ nùn domɑru kuɑ kpɑ u mɑrurɑ, win bibu bu dɑbiɑ sere bɑ ǹ ɡɑrirɔ. U koo bibu wɔkurɑ yiru mɑ, kpɑ bii be, bu ko bwese bɑkɑrun kɛri wɔkurɑ yirun nuuru. ");
INSERT INTO bba_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Adɑmɑ nɛn ɑrukɑwɑni ye, yɑ ko n wɑ̃ɑwɑ Isɑkin mi, wi Sɑɑrɑɑ koo nun mɑruɑ ɡɑsɔku ɑmɑdɑɑre. ");
INSERT INTO bba_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Ye Gusunɔ u kɑ Aburɑhɑmu ɡɑri kuɑ u kpɑ, u nùn deri u doonɑ wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Yen biru Aburɑhɑmu u Isimɛɛli suɑ kɑ yobu kpuro be bɑ mɑrɑ win yɛnuɔ kɑ be u kɑ ɡobi dwɑ, tɔn durɔ be bɑ wɑ̃ɑ win yɛnuɔ kpuro ɡesi, mɑ u bu bɑnɡo kuɑ dɔmɑ te, nɡe mɛ Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Aburɑhɑmu u mɔwɑ wɔ̃ɔ wunɔbu tiɑ sɑri sɑnɑm mɛ u bɑnɡo kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Win bii Isimɛɛli u mɑɑ mɔwɑ wɔ̃ɔ wɔkurɑ itɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Sɔ̃ɔ tee terɑ bɑ Aburɑhɑmu kɑ win bii Isimɛɛli bɑnɡo kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Tɔn durɔbu kpuro be bɑ mɑrɑ win yɛnuɔ kɑ be u dwɑ tɔn tukobun mi, bɑ bu bɑnɡo kuɑwɑ kɑ wi sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Sɔ̃ɔ teeru Yinni Gusunɔ u Aburɑhɑmu kure Mɑnden sɔ̃ɔwɔ ye u sɔ̃ win dii bekuruɡirun kɔnnɔwɔ sɔ̃ɔ sɔɔ ɡbɑ̃ɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","U nɔni seeyɑ u mɛɛrɑ. Wee tɔn durɔbu itɑ bɑ yɔ̃ sɑruɔ. Ye u bu wɑ yerɑ u seewɑ u dukɑ dɑ ben mi, u yiirɑ ben wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Mɑ u ben tɔnwero sɔ̃ɔwɑ u nɛɛ, Yinni, ɑ̀ n wurɑ, ɑ yɔ̃ro, ɑ ku mɑn sɑrɑri ɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","I de bu nim tɑmɑ i kɑ bɛɛn kɔ̃ri kpɑkiɑ kpɑ i wɛ̃rɑ dɑ̃ɑ sɑɑru mini. ");
INSERT INTO bba_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Kon dɑ n dĩɑnu tɑmɑ fiiko kpɑ i di i kɑ dɑm wɑ. Yen biru kpɑ i sere swɑɑ wɔri i doonɑ. Bɛɛn nɑɑ te, tɑ bɛɛrɛ kuɑ. Yen sɔ̃, i de i nɛn yɑɑrɛ di. Mɑ bɑ nɛɛ, ɑ koowo nɡe mɛ ɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Yerɑ Aburɑhɑmu u ɡɔsirɑ kɑ sɛndɑru win dii bekuruɡirɔ Sɑɑrɑɑn mi. U nùn sɔ̃ɔwɑ u nɛɛ, ɑ wɑsi suo ɑ som sɑkɑkun nɔɔ itɑ suɑ ɑ buri kpɑ ɑ kirɑru sɔmɛ. ");
INSERT INTO bba_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Mɑ Aburɑhɑmu u dukɑ dɑ win nɑɑ ɡɔ̃ɔwɔ u nɑɑ kinɛ kpɛmbu ɡe ɡɑ wɑ̃ mwɑ u win sɔm kowo turo wɛ̃. Mɑ u ɡu ɡo u sɑwɑ fuuku. ");
INSERT INTO bba_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Aburɑhɑmu u nɑɑ boɡum suɑ kɑ bom kɑ yɑɑ sɑɑrɑ ye, u kɑ dɑ u yi tɔn ben wuswɑɑɔ. Win tii u dɑ u sinɑ bee tiɑ dɑ̃ɑ ten sɑɑrɔ sɑnɑm mɛ bɑ dimɔ nɡe mɛ ben komɑru. ");
INSERT INTO bba_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Yerɑ bɑ nùn bikiɑ bɑ nɛɛ, mɑnɑ wunɛn kurɔ Sɑɑrɑɑ u wɑ̃ɑ. Mɑ u nɛɛ, u wɑ̃ɑ dirɔ. ");
INSERT INTO bba_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Mɑ ben turon min di Gusunɔ u nɛɛ, ɡɑsɔku ɑmɑdɑɑre kon wurɑmɑ wunɛn mi. Sɑɑ ye sɔɔ, wee, wunɛn kurɔ Sɑɑrɑɑ u koo bii tɔn durɔ mɑ. N deemɑ Sɑɑrɑɑ u yɔ̃ u ɡɑri yi swɑɑ dɑki dii kɔnnɔwɔ ɡe ɡɑ wɑ̃ɑ sɔɔ win biruɔ. ");
INSERT INTO bba_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Aburɑhɑmu kɑ Sɑɑrɑɑ bɑ mɑɑ bukurɑ ɡem ɡem. Sɑɑrɑɑ kun sɑ̃ɑ wi u koo bii mɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Mɑ u tii yɛ̃ɛ u nɛɛ, tɛ̃ ye nɑ tɔkɔ kuɑ nɑ kpɑ, nɛn durɔn tii mɑɑ tɔkɔ kuɑ, yerɑ sɑ ko mɑɑ kpĩ su mɛnnɑbun nuku dobu wɑ? ");
INSERT INTO bba_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Mɑ Yinni Gusunɔ u Aburɑhɑmu sɔ̃ɔwɑ u nɛɛ, mbɑn sɔ̃nɑ Sɑɑrɑɑ u yɛ̃ɛ u nɛɛ, u koo bii mɑwɑ mi kɑ ɡem? Wi, wi u tɔkɔ kuɑ u kpɑ? ");
INSERT INTO bba_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Gɑ̃ɑnu ɡɑnu wɑ̃ɑ ni nu kɑ mɑn sɛ̃? Nɡe mɛ nɑ yi, suru nɔɔbɑ nnɛn biru kon wurɑmɑ kpɑ Sɑɑrɑɑ u bii tɔn durɔ mɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Mɑ Sɑɑrɑɑ u siki u nɛɛ, nɑ ǹ yɛ̃ɛ. Domi bɛrum nùn mwɑ. Adɑmɑ Yinni Gusunɔ u nɛɛ, weesɑ, ɑ yɛ̃ɛ. ");
INSERT INTO bba_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Mɑ tɔn be, bɑ seewɑ bɑ doonɔ. Bɑ wuswɑɑ tĩi Sodomun berɑ ɡiɑ. Mɑ Aburɑhɑmu u bu swɑɑ yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Yerɑ Yinni Gusunɔ u nɛɛ, ye kon ko, n weenɛ n ye Aburɑhɑmu beruɑ? ");
INSERT INTO bba_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","N ǹ ɡɑ̃ɑnun sɔ̃, Aburɑhɑmun bweserɑ koo kpɛ̃ɑ kpɑ tɑ n dɑm mɔ. Win min diyɑ hɑnduniɑn bwesenu kpuro nu koo domɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Domi wiyɑ nɑ ɡɔsɑ u kɑ win bibu kɑ ben bweseru woodɑ wɛ̃ bu nɛn swɑɑ swĩi kpɑ bɑ n sĩimɔ dee dee bɑ n nɛn kĩru mɔ̀, kpɑ n nɛn nɔɔ mwɛɛnu yibiɑ ni nɑ nùn kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Mɑ u nɛɛ, tɔmbun weeweenu kpɛ̃ɑ Sodomu kɑ Gomɔrɑɡibun dɑɑ kɔ̃sɑn sɔ̃. Ben durum yɑ bɑndɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Yen sɔ̃nɑ kon sɑrɑ kpɑ n wɑ bɑ̀ n mɔ̀ kɑ ɡem nɡe mɛ nɑ nɔɔmɔ. Ǹ kun mɛ, kpɑ nɑ n yɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Tɔn ben yiru bɑ ben swɑɑ wɔri bɑ doonɔ Sodomun berɑ ɡiɑ. Adɑmɑ Yinni Gusunɔ u ɡinɑ yɔ̃rɑ kɑ Aburɑhɑmu. ");
INSERT INTO bba_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Mɑ Aburɑhɑmu u nùn susi u nɛɛ, kɑ ɡem kɑɑ tɔn ɡeobu kɑ tɔn kɔ̃sobu ɡo sɑnnu? ");
INSERT INTO bba_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Sɔrɔkudo tɔn ɡeobu weerɑɑkuru bɑ ko n wɑ̃ɑ wuu ɡe sɔɔ, be bɑ wunɛn kĩru mɔ̀. Ǹ n mɑn nɑ, kɑɑ mɑɑ bu ɡowɑ? A ǹ wuu ɡen tɔmbu suuru kuɑmmɛ tɔmbu weerɑɑku ten sɔ̃? ");
INSERT INTO bba_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","N ǹ weenɛ ɑ tɔn ɡeobu kɑ tɔn kɔ̃sobu kpeerɑsiɑ sɑnnu kpɑ be kpuro bu ɑre tee wɑ. Yen bweserɑ kun kɑ nun weenɛ. Wunɛ wi kɑɑ hɑnduniɑ kpuro siri, ɑ ǹ kɑɑ ko ye n wɑ̃? ");
INSERT INTO bba_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mɑ Yinni Gusunɔ u nɛɛ, nɑ̀ n tɔn ɡeobu weerɑɑkuru wɑ Sodomun nukuru sɔɔ, kon wuu ɡe kpuro suuru kuɑ ben sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Aburɑhɑmu u kpɑm ɡɑri suɑ u nɛɛ, wee, nɑ kɑ̃kɑ nɑ kɑ nɛn Yinni ɡɑri kuɑ, nɛ wi nɑ sɑ̃ɑ tuɑ kɑ torom dirum. ");
INSERT INTO bba_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Sɔrɔkudo tɔnu weerɑɑku te sɔɔ, nɔɔbu koo kɑɑrɑ. Nɔɔbu yen sɑrirun sɔ̃ kɑɑ wuu ɡe kpeerɑsiɑ? Mɑ Yinni Gusunɔ u nɛɛ, nɑ ǹ ɡu kpeerɑsiɑmɔ nɑ̀ n tɔn ɡeobu weeru kɑ nɔɔbu wɑ ɡe sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Aburɑhɑmu u kpɑm nùn sɔ̃ɔwɑ u nɛɛ, sɔrɔkudo tɔn ɡeobu weeruwɑ bɑ ko n wɑ̃ɑ mi. Mɑ Yinni Gusunɔ u nɛɛ, kon wuu ɡe deri ɡen tɔnu weeru yen sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Aburɑhɑmu u nɛɛ, ɑ ku kɑ mɑn wɑsirɑ. Kon kpɑm ɡɑri ɡere. Ǹ n tɔn ɡeobu tɛnɑn nɑ yɑ wɑ̃ɑ mi mɑɑ ni? Mɑ Yinni Gusunɔ u nɛɛ, nɑ ǹ ɡu kɑm koosiɑmɔ nɑ̀ n tɛnɑ ye wɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Mɑ Aburɑhɑmu u nɛɛ, Yinni, wee nɑ kɑ̃kɑ nɑ kɑ nun ɡɑri mɔ̀. Ǹ n tɔn ɡeobu yɛndun nɑ tɑ mɑɑ wɑ̃ɑ mi ni? Mɑ Yinni Gusunɔ u nɛɛ, nɑ ǹ ɡu kpeerɑsiɑmɔ nɑ̀ n yɛn te wɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Aburɑhɑmu u kpɑm nɛɛ, ɑ suuru koowo, nɔn tee teniwɑ kon ɡɑri ɡere. Bɑɑ ǹ n wɔkurun nɑ tɑ wɑ̃ɑ mi ni? Mɑ Yinni Gusunɔ u nɛɛ, nɑ ǹ ɡu kpeerɑsiɑmɔ nɑ̀ n wɔku te wɑ. ");
INSERT INTO bba_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Yen biru Yinni Gusunɔ u doonɑ ye u kɑ Aburɑhɑmu ɡɑri kuɑ u kpɑ. Aburɑhɑmu u mɑɑ ɡɔsirɑ u dɑ win yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Tɔmbu yiru be bɑ rɑɑ Sodomun swɑɑ wɔri bɑ turɑ mi yokɑ. N deemɑ bɑ sɑ̃ɑwɑ Gusunɔn ɡɔrɑdobɑ. Wee, sɑɑ ye sɔɔ, Lɔtu u sɔ̃ wuun ɡbɑ̃rɑ kɔnnɔwɔ mi wuun wiruɡibu bɑ rɑ sinɛ. Ye u bu wɑ u seewɑ ");
INSERT INTO bba_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","u bu sennɔ dɑ u yiirɑ ben wuswɑɑɔ u nɛɛ, i dɑm koomɑ nɛn yinnibu, i de su dɑ nɛn yɛnuɔ i bɛɛn kɔ̃ri kpɑkiɑ i kpunɑ mi. Bururu kpɑ i yellu se i bɛɛn swɑɑ wɔri. Bɑ nɛɛ, ɑɑwo, tɔɔwɔwɑ sɑ ko kpunɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Adɑmɑ Lɔtu u bu nɔɔ ɡɛ̃ɛ bɑ sere wurɑ bɑ duɑ win yɛnuɔ. U tɔ̃ɔ bɑkɑ dim kuɑ kɑ pɛ̃ɛ ye bɑ kun seeyɑtiɑ doke mɑ bɑ di. ");
INSERT INTO bba_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Bɑ ǹ ɡinɑ kpunɑm kpɑ Sodomuɡibu bɑ kɑ yɛnu ɡe tɑrusi sɑɑ bukurobun di sere kɑ ɑluwɑɑsi yɑ̃kɑminɔ, wuu ɡen tɔn durɔbu kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Mɑ bɑ Lɔtu sokɑ bɑ nɛɛ, mɑnɑ durɔ be, bɑ wɑ̃ɑ be bɑ sɔbiɑ wunɛn yɛnuɔ yokɑ ye. A bu yɑrɑmɑ su kɑ bu kpunɑ nɡe tɔn kurɔbu. ");
INSERT INTO bba_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Mɑ Lɔtu u yɑrɑ u bu deemɑ yɛnu kɔnnɔwɔ, u ɡɑmbo kɛnuɑ birum birum. ");
INSERT INTO bba_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","U nɛɛ, kpɑɑsibu, i suuru koowo i ku dɑɑ kɔ̃sɑ ko mɛ. ");
INSERT INTO bba_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Wee, nɑ bii wɔndiɑbɑ yiru mɔ be bɑ kun ɡinɑ durɔ yɛ̃. I de n bɛɛ bu yɑrɑmɑ kpɑ i kɑ bu ko nɡe mɛ n bɛɛ wɛ̃re. Adɑmɑ durɔ beni, i mɑn bu derio domi sɔbɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Bɑ nɛɛ, wunɛ sɔɔwɑ, mɑ ɑ kĩ ɑ sun siri? A tii ɡɑwo min di, ǹ kun mɛ, ye sɑ ko nun kuɑ yɑ koo beɡiɑ kerɑ. Mɑ bɑ Lɔtu bɔrikiɑ kɑ dɑm sere bɑ kĩ bu win ɡɑmbo kɔrɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Sɑɑ yerɑ sɔɔ be, bɑ Lɔtu ɡɑwɑ bɑ sure yɛnuɔ bɑ ɡɑmbo kɛnuɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Mɑ bɑ tɔn be kpuro wɔ̃koru kpɛ̃ɛ be bɑ yɔ̃ yɛnu ɡen kɔnnɔwɔ sɑɑ ɑluwɑɑsi yɑ̃kɑminun di sere kɑ bukurobɔ. Yerɑ bɑ bɑbi bɑbi bɑ ǹ kɔnnɔ ɡe wɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Sɔɔ be, bɑ Lɔtu bikiɑ bɑ nɛɛ, wɑrɑ ɑ mɔ mini mɑɑ. Wunɛn bibun durɔbu kɑ wunɛn bii tɔn durɔbu kɑ tɔn kurɔbu. Be bɑ sɑ̃ɑ wunɛɡibu kpuro ɡesi, ɑ bu mɛnnɔ i yɑri minin di. ");
INSERT INTO bba_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Domi sɑ ko wuu ɡe kpeerɑsiɑ tɛ̃ yèn sɔ̃ tɔmbun weeweenu kpɛ̃ɑ ni bɑ Gusunɔ koosimɔ ɡen tɔmbun dɑɑ kɔ̃sɑn sɔ̃. Yen sɔ̃nɑ u sun ɡɔrimɑ su kɑ ɡu kɑm koosiɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Mɑ Lɔtu u yɑrɑ u dɑ u win bibun durɔ kɛ̃ɛrobu sɔ̃ɔwɑ bu seewo bu yɑri min di domi Yinni Gusunɔ u koo wuu ɡe kɑm koosiɑ. Adɑmɑ bɑ ɡɑri yi ɑtɑfiiru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Buru buru yɑm sɑ̃reru ɡɔrɑdo be, bɑ Lɔtu nɔɔ ɡɛ̃ɛ bɑ mɔ̀, ɑ seewo ɑ wunɛn kurɔ suɑ kɑ wunɛn bii wɔndiɑbɑ yiru be bɑ wɑ̃ɑ mini kpɑ i ku rɑ kɑm ko bɑ̀ n wuu ɡe kpeerɑsiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Ye bɑ wɑ mɑ Lɔtu u tɛɛmɔ, bɑ wi kɑ win kurɔ kɑ win bii wɔndiɑbɑ yiru yen nɔmu nɛnuɑ bɑ ɡɑwɑ bɑ kɑ yɑrɑ sere wuun biruɔ, domi Yinni Gusunɔ u ben wɔnwɔndu wɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Ye bɑ bu yɑrɑ bɑ kpɑ ben turo u nɛɛ, ɑ kɑ wunɛn hunde dukɑo, ɑ ku rɑ sĩirɑ, ɑ ku rɑ mɑɑ yɔ̃rɑ bɑtumɑ mi. A dukɑ doo ɡuunun berɑ ɡiɑ kpɑ ɑ ku rɑ kɑm ko. ");
INSERT INTO bba_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Mɑ Lɔtu u nɛɛ, ɑɑwo, yinni. ");
INSERT INTO bba_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Wee, ɑ mɑn durom kuɑ, ɑ mɑɑ mɑn wunɛn wɔnwɔndun kpɑ̃ɑru sɔ̃ɔsi ye ɑ kɑ nɛn hunde fɑɑbɑ kuɑ. Adɑmɑ nɑ ǹ kpɛ̃ n dukɑ turi ɡuu ten mi, wɑhɑlɑ ye, yɑ kun kɑ mɑn bɑbe kpɑ n kɑm ko. ");
INSERT INTO bba_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Wuu ɡeni wee, ɡɑ wɑ̃ɑ turuku, ɡɑ ǹ mɑɑ kpɑ̃. A de n dɑ n kuke mi, kpɑ n fɑɑbɑ wɑ. Ye u wɑ ɡɔrɑdo wi, u ǹ wisɑ, mɑ u nɛɛ, nɡe ɡɑ ǹ piibu sɑ̃ɑ ro? ");
INSERT INTO bba_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Mɑ ɡɔrɑdo wi, u nɛɛ, kon kpɑm nun durom kuɑ. Wuu ɡèn ɡɑri ɑ mɔ̀ mi, nɑ ǹ ɡu kpeerɑsiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","A hɑniɑ koowo ɑ dɑ ɑ kuke mi, domi nɑ ǹ kpɛ̃ n ɡɑ̃ɑnu ɡɑnu ko mɑ n kun mɔ ɑ turɑ mi. Yen sɔ̃nɑ bɑ wuu ɡe yĩsiru kɑ̃ Soɑri. Yen tubusiɑnɑ wuu piibu. ");
INSERT INTO bba_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","N deemɑ sɔ̃ɔ yɑrimɑ Lɔtu u sere duɑ Soɑriɔ. ");
INSERT INTO bba_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Yerɑ Yinni Gusunɔ u sɔ̃ɔ bisu kɑ dɔ̃ɔ nɛɛsiɑ sɑɑ wɔllun di Sodomu kɑ Gomɔrɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","U wuu si kpeerɑsiɑ kɑ sin tɔmbu kpuro kɑ sin bɑtumɑ kɑ ye yɑ kpiɑ mi kpuro. ");
INSERT INTO bba_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Adɑmɑ suɑru sɔɔ Lɔtun kurɔ u sĩirɑ, mɑ u ɡɔsirɑ bɔɔ kperu. ");
INSERT INTO bba_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ye n kuɑ buru buru yellu, yerɑ Aburɑhɑmu u dɑ u yɔ̃rɑ mi u rɑɑ kɑ Yinni Gusunɔ ɡɑri kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Ye u mɛɛrɑ Sodomu kɑ Gomɔrɑn berɑ kɑ bɑtumɑ yen mi ɡiɑ, u wɑ wee, dɔ̃ɔ wiirɑ seemɔ nɡe ɡbee burɔn dɔ̃ɔ wiiru. ");
INSERT INTO bba_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Sɑnɑm mɛ Gusunɔ u bɑtumɑ yen wusu kpeerɑsiɑmɔ, u Aburɑhɑmu yɑɑye mɑ u Lɔtu yɑrɑ kɑm koo bin min di. ");
INSERT INTO bba_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Yen biru Lɔtu u yɑrɑ Soɑrin di u dɑ u sinɑ ɡuuru ɡɑrun kpee wɔru sɔɔ kɑ win bii wɔndiɑbɑ yiru ye sɑnnu, domi u bɛrum bɑrɑ u sinɑ Soɑriɔ. ");
INSERT INTO bba_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Yerɑ win bii yerumɑ u win wɔnɔ sɔ̃ɔwɑ u nɛɛ, bɛsɛn tundo wee, u tɔkɔ kuɑ. Tɔn durɔ ɡoo mɑɑ sɑri berɑ mi, wi u koo sun suɑ nɡe mɛ sibɑ mɔ̀ tem bɑɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","A nɑ su bɛsɛn tundo tɑm nɔrusiɑ mu n kpɑ̃ kpɑ su de u kɑ sun kpunɑ kpɑ win bweseru tu ku ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Wɔ̃ku te, bɑ ben tundo tɑm nɔrusiɑ, mɑ yerumɑ u dɑ u win tundo kpunɛ, ɑdɑmɑ Lɔtu kun yɛ̃ sɑɑ ye bii wi, u nɑ u kpunɑ kɑ sɑɑ ye u seewɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Yen sisiru yerumɑ wi, u win wɔnɔ sɔ̃ɔwɑ u nɛɛ, wee, ɡĩɑ wɔ̃kuru nɑ derɑ bɛsɛn tundo kɑ mɑn kpunɑ. Su kpɑm nùn tɑm nɔrusiɑ wɔ̃ku te, kpɑ wunɛ ɑ mɑɑ dɑ u kɑ nun kpunɑ kpɑ win bweseru tu ku ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Mɑ bɑ wure bɑ ben tundo tɑm nɔrusiɑ wɔ̃ku te, mɑ wɔnɔ dɑ u nùn kpunɛ. Tundo kun yɛ̃ sɑɑ ye bii wi, u nɑ u kpunɑ kɑ sɑɑ ye u seewɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Mɑ Lɔtun bii tɔn kurɔbu yiru ye, bɑ win ɡuri suɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Bii yerumɑ wi, u mɑrɑ tɔn durɔ mɑ u nùn yĩsiru kɑ̃ Mɔɑbu. Yen tubusiɑnɑ nɛn tundon bii. Win min diyɑ Mɔɑbubɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Wɔnɔ wi, u mɑɑ mɑrɑ tɔn durɔ, mɑ u nùn yĩsiru kɑ̃ Bɛni Ami. Yen tubusiɑnɑ nɛn dusin bii. Win min diyɑ Amɔnibɑn bweserɑ mɑɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Yenibɑn biru Aburɑhɑmu u seewɑ Mɑnden di, mɑ u dɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ Nɛɡɛbuɔ Kɑdɛsi kɑ Surin bɑɑ sɔɔ, u dɑ u wɑ̃ɑ wuu ɡe bɑ mɔ̀ Gerɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Gerɑ miyɑ u rɑ n win kurɔ Sɑɑrɑɑ sokumɔ win sesu. Ye Gerɑn sunɔ Abimɛlɛki u nuɑ mɛ, yerɑ u Sɑɑrɑɑ suɑ kurɔ u yɛnu doke. ");
INSERT INTO bba_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Adɑmɑ Yinni Gusunɔ u Abimɛlɛki sɔ̃ɔwɑ dosu sɔɔ wɔ̃kuru u nɛɛ, wee, kɑɑ ɡbi tɛ̃ kurɔ win sɔ̃ wi ɑ suɑ mi, domi wi kɑ win durɔwɑ bɑ wɑ̃ɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","N deemɑ Abimɛlɛki u ǹ ɡinɑ kɑ Sɑɑrɑɑ mɛnnɑre. Yerɑ u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, kɑɑ tɔnu ɡo wi u kun tɑɑrɛ ɡɑɑ mɔ? ");
INSERT INTO bba_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","N ǹ win tiiwɑ u mɑn sɔ̃ɔwɑ mɑ win sesuwɑ? Mɑ kurɔ win tii u mɑɑ ɡeruɑ mɛ. Ǹ n mɛn nɑ, nɑ ǹ kɔ̃sɑ bwisikɑ nɛn ɡɔ̃ruɔ n sere mɑm nɛɛ, nɑ durum kuɑ kɑ nɛn nɔmɑ. ");
INSERT INTO bba_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Mɑ Yinni Gusunɔ u nùn wisɑ u nɛɛ, ɡeemɑ nɑ yɛ̃ mɑ ɑ ǹ tɑɑrɛ ɡɑɑ mɔ wunɛn ɡɔ̃ruɔ sɑnɑm mɛ ɑ yeni kuɑ. Yen sɔ̃nɑ nɑ ǹ dere ɑ nùn bɑbɑ kpɑ ɑ ku rɑ durum ko. ");
INSERT INTO bba_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Ǹ n mɛn nɑ, ɑ durɔ wi nùn win kurɔ wesio tɛ̃, domi nɛn sɔmɔwɑ u sɑ̃ɑ. U koo mɑɑ nun kɑnɑru kuɑ kpɑ ɑ ku ɡbi. À n mɑɑ yinɑ ɑ nùn kurɔ wi wesiɑ, i ko ɡbiwɑ wunɛ kɑ wunɛn tɔmbu kpuro. ");
INSERT INTO bba_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yerɑ Abimɛlɛki u seewɑ buru buru yellu u win bwɑ̃ɑbu kpuro mɛnnɑ u bu Yinni Gusunɔn ɡɑri yi sɑɑriɑ. Mɑ bɛrum bwɑ̃ɑ be mwɑ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Sɑɑ ye sɔɔrɑ Abimɛlɛki u Aburɑhɑmu bikiɑ u nɛɛ, ɑmɔnɑ ɑ kɑ sun kuɑ mɛ. Mbɑ nɑ nun torɑri ɑ kɑ sun durum bɑkɑ yenin bweseru sɔbi nɛ kɑ nɛn tɔmbu. A mɑn ɡɑ̃ɑnu kuɑ ni nu ǹ weenɛ bu tɔnu kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Mbɑ ɑ bwisikɑ ɑ kɑ yenin bweseru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Mɑ Aburɑhɑmu u wisɑ u nɛɛ, nɑ rɑɑ tɑmɑɑ bɑ ǹ Gusunɔn bɛrum mɔwɑ tem mini, kpɑ bu mɑn ɡo nɛn kurɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Adɑmɑ kɑ yen de kpuro u sɑ̃ɑwɑ nɛn sesu tundo turosi, sɑ ǹ sɑ̃ɑ mɛro turo. Mɑ nɑ nùn suɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Yen sɔ̃, sɑɑ mìn di Gusunɔ u mɑn yɑrɑ nɛn yɛnun di nɑ bɔsu, nɑ nùn sɔ̃ɔwɑ nɑ nɛɛ, u mɑn biru wukirio. Mi sɑ duɑ kpuro u n dɑ nɛɛ, u sɑ̃ɑwɑ nɛn sesu. ");
INSERT INTO bba_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Yerɑ Abimɛlɛki u nùn win kurɔ Sɑɑrɑɑ wesiɑ. Mɑ u mɑɑ nùn yoo tɔn durɔbu kɑ tɔn kurɔbu wɛ̃ kɑ yɑ̃ɑnu kɑ kɛtɛbɑ. ");
INSERT INTO bba_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Mɑ u nùn sɔ̃ɔwɑ u nɛɛ, nɛnɑ nɑ tem mɛ mɔ. A ɡɔsio mɛ sɔɔ, berɑ mi ɑ kĩ ɑ n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Mɑ u mɑɑ Sɑɑrɑɑ sɔ̃ɔwɑ u nɛɛ, wee wi ɑ sokumɔ wunɛn sesu mi, nɑ nùn sii ɡeesun ɡobi nɔrɔbu (1.000) wɛ̃ɛmɔ. Yeni yɑ koo wunɛn tɔmbu sɔ̃ɔsi mɑ ɑ dɛɛre, kpɑ bɑ n yɛ̃ mɑ ɑ ǹ kɔ̃sɑ ɡɑɑ kue. ");
INSERT INTO bba_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","N deemɑ Gusunɔ u rɑɑ Abimɛlɛki kɑ win kurɔ kɑ win yobu bɑrɑru kpɛ̃ɛ te tɑ ǹ derimɔ bu mɑ, ye u kɑ Sɑɑrɑɑ mwɑn sɔ̃. Yen sɔ̃nɑ ye u Sɑɑrɑɑ wesiɑ, Aburɑhɑmu u Gusunɔ kɑnɑ, mɑ u bu bɛkiɑ bu kɑ kpĩ bu mɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Yinni Gusunɔ u yɑɑye ye u rɑɑ Sɑɑrɑɑ sɔ̃ɔwɑ. U mɑɑ win nɔɔ mwɛɛru yibiɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Sɑɑrɑɑ u ɡurɑ suɑ mɑ u Aburɑhɑmu bii tɔn durɔ mɑruɑ win tɔkɔru sɔɔ, sɑɑ ye Gusunɔ u rɑɑ nùn burɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Aburɑhɑmu u bii wi yĩsiru kɑ̃ Isɑki. ");
INSERT INTO bba_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ye Isɑki kuɑ sɔ̃ɔ nɔɔbɑ itɑ u nùn bɑnɡo kuɑ nɡe mɛ Gusunɔ u rɑɑ nùn woodɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Aburɑhɑmu mɔwɑ wɔ̃ɔ wunɔbu (100) sɑnɑm mɛ bɑ win bii Isɑki mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sɑɑ ye sɔɔrɑ Sɑɑrɑɑ nɛɛ, Gusunɔ u mɑn yɛ̃ɛsu ɡo. Be bɑ mɑɑ nuɑ kpuro bɑ koo kɑ mɑn yɛ̃ɛwɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","U kpɑm nɛɛ, wɑrɑ koo rɑɑ Aburɑhɑmu sɔ̃ mɑ nɛ Sɑɑrɑɑ kon bii bɔm kɛ̃. Wee tɛ̃ nɑ nùn bii tɔn durɔ mɑruɑ win tɔkɔru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Bii wi, u kpɛ̃ɑ mɑ bɑ nùn bɔm kɑrɑ. Yerɑ Aburɑhɑmu u yɑɑ dii bɑkɑbu kuɑ dɔmɑ te. ");
INSERT INTO bba_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Ye Sɑɑrɑɑ wɑ mɑ bii wi Aɡɑɑ Eɡibitiɡii wi, u Aburɑhɑmu mɑruɑ u Isɑki yɛ̃ɛmɔ, ");
INSERT INTO bba_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","yerɑ u Aburɑhɑmu sɔ̃ɔwɑ u nɛɛ, ɑ yoo wi ɡiro kɑ win bii, domi win bii kun tubi dimɔ kɑ nɛn bii sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Gɑri yi, yi Aburɑhɑmu duɑ ɡem ɡem win bii Isimɛɛlin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Adɑmɑ Gusunɔ u Aburɑhɑmu sɔ̃ɔwɑ u nɛɛ, ɑ ku ɡɑri yi ɡɔburu wɑ wunɛn yoo wi kɑ win biin sɔ̃. A Sɑɑrɑɑ kuo ye u nun bikiɑ kpuro. Domi Isɑkin min diyɑ bwese bɑkɑ tèn nɔɔ mwɛɛru nɑ nun kuɑ tɑ koo yɑri. ");
INSERT INTO bba_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kon mɑɑ de wunɛn yoo win bii u ko bweseru ɡɑrun nuuru, domi wunɛn biiwɑ u sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ye n kuɑ sisiru Aburɑhɑmu u seewɑ buru buru yellu u dĩɑnu kɑ nim bwɑ̃ɑru suɑ u Aɡɑɑ wɛ̃. U mɑɑ nùn bii wi nɔmu bɛriɑ u nɛɛ, bu doo. Mɑ bɑ doonɑ bɑ dɑ bɑ torɑ ɡbɑburɔ te bɑ rɑ soku Beri Sebɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Ye bwɑ̃ɑ ten nim mu kpɑ, yerɑ u bii wi deri dɑ̃ɑ piibu ɡɑɡun sɑɑrɔ. ");
INSERT INTO bba_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Mɑ u dɑ u sinɑ n dɛsire n turɑ mi bɑ̀ n sɛ̃u tobɑ ɡɑ koo wen sɑkɑ. Domi u nɛɛ, u ǹ kpɛ̃ u n win bii mɛɛrɑ u n ɡbimɔ. Mi u sɔ̃ mi, mɑ u wurɑ tɑkɑnɑ u swĩ. ");
INSERT INTO bba_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Gusunɔ u bii win nɔɔ nuɑ mɑ win ɡɔrɑdo u Aɡɑɑ sokɑ wɔllun di u nɛɛ, mbɑ n nun mɔ̀, Aɡɑɑ. A ku nɑndɑ, domi Gusunɔ u bii win nɔɔ nuɑ mi u wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","A seewo ɑ dɑ ɑ nùn suɑ ɑ kɔkiri domi kon nùn ko bwese bɑkɑrun nuuru. ");
INSERT INTO bba_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Sɑɑ yerɑ Gusunɔ u kurɔ win nɔni wukiɑ mɑ u dɔkɔ ɡɑɑ wɑ mi. U dɑ u bwɑ̃ɑ te nim yibiɑ u bii wɛ̃ u nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Gusunɔ u wɑ̃ɑ kɑ bii wi, sɑnɑm mɛ u kpɛ̃ɑmɔ. U wɑ̃ɑ ɡbɑburɔ te bɑ mɔ̀ Pɑrɑni, mɑ u kuɑ tɛn towo. Win mɛro mɑɑ nùn kurɔ suɑ Eɡibitin tem di. ");
INSERT INTO bba_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Sɑɑ ye sɔɔrɑ Abimɛlɛki kɑ win tɑbu sunɔ wi bɑ mɔ̀ Pikoli bɑ nɑ Aburɑhɑmun mi. Bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ, sɑ wɑ mɑ Gusunɔ u wɑ̃ɑ kɑ wunɛ ye ɑ mɔ̀ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Yen sɔ̃, ɑ bɔ̃ruo kɑ win yĩsiru mɑ ɑ ǹ nɛ kɑ nɛn bibu kɑ nɛn debuminu bɔrɔ kɔ̃ɔ kom kuɑmmɛ, kpɑ ɑ nɛ kɑ nɛn tem mɛɡibu durom kuɑ nɡe mɛ nɑ nun kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Mɑ Aburɑhɑmu u nɛɛ, nɑ wurɑ, kon bɔ̃re. ");
INSERT INTO bba_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Adɑmɑ u Abimɛlɛki ɡerusi dɔkɔ ɡɑɑn sɔ̃ ye Abimɛlɛkin yobu bɑ nùn mwɑɑri. ");
INSERT INTO bba_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abimɛlɛki u nɛɛ, nɑ ǹ yɛ̃ wi u yen bweseru kuɑ. Mɛyɑ wunɛn tii, ɑ ǹ mɑɑ mɑn sɔ̃ɔre mɑ n kun mɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Mɑ Aburɑhɑmu u yɑ̃ɑnu kɑ kɛtɛbɑ suɑ u Abimɛlɛki wɛ̃, be yiru bɑ kɑ ɑrukɑwɑni bɔkuɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Mɑ Aburɑhɑmu u mɑɑ yɑ̃ɑ ɡbiibi ɡɔsɑ nɔɔbɑ yiru u yi nɛnɛm. ");
INSERT INTO bba_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Yerɑ Abimɛlɛki u nùn bikiɑ u nɛɛ, mbɑ kɑɑ kɑ yɑ̃ɑ ɡbiibi nɔɔbɑ yiru yeni ko. ");
INSERT INTO bba_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Aburɑhɑmu u nùn wisɑ u nɛɛ, ɑ nu mɔɔ kpɑ nu n sɑ̃ɑ seedɑ mɑ nɛnɑ nɑ dɔkɔ yeni ɡbɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Yen sɔ̃nɑ bɑ yɑm mi sokɑ Beri Sebɑ domi miyɑ bɑ ɑrukɑwɑni bɔkuɑ kɑ bɔ̃ri. Yĩsi ten tubusiɑnɑ dɔkɔ yèn nuurɔ bɑ bɔ̃ruɑ. ");
INSERT INTO bba_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Ye bɑ ɑrukɑwɑni bɔkuɑ bɑ kpɑ, yerɑ Abimɛlɛki kɑ win tɑbu sunɔ Pikoli bɑ ɡɔsirɑ bɑ wurɑ ben wuuɔ Filisitibɑn temɔ. ");
INSERT INTO bba_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Yen biru Aburɑhɑmu u dɑ̃ru ɡɑru duurɑ Beri Sebɑ mi, ni nu rɑ sɑɑ bɑkɑru ko. Mɑ u Yinni Gusunɔ sɑ̃wɑ mi. Yinni Gusunɔ wi, u ko n wɑ̃ɑwɑ kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Aburɑhɑmu u sinɑ Filisitibɑn tem mi, u tɛ. ");
INSERT INTO bba_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yenibɑ kpuron biruwɑ Gusunɔ u Aburɑhɑmun lɑɑkɑri mɛɛrɑ u nùn sokɑ u nɛɛ, Aburɑhɑmu. Mɑ Aburɑhɑmu u wurɑ u nɛɛ, nɛ wee, Yinni. ");
INSERT INTO bba_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Mɑ u nɛɛ, ɑ Isɑki wunɛn bii teere te suo wi ɑ kĩ mi, ɑ kɑ dɑ Mɔriyɑn temɔ kpɑ ɑ kɑ nùn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko ɡuuru ɡɑrun wɔllɔ te kon nun sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Yerɑ Aburɑhɑmu u seewɑ buru buru yellu u win kɛtɛku ɡɑɑri bɔkuɑ mɑ u win sɔm kowo ɑluwɑɑsibɑ yiru suɑ kɑ win bii Isɑki sɑnnu. U yɑ̃ku dɑ̃ɑ bɛsukɑ. Yen biru bɑ swɑɑ wɔri bɑ dɔɔ mi Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Bɑ sɑnum so sɔ̃ɔ yiru, yen itɑserɑ Aburɑhɑmu u yɑm mi wɑ sɑrun di ye u nɔni seeyɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Mɑ u win sɔm kowo be sɔ̃ɔwɑ u nɛɛ, i yɔ̃ro mini kɑ kɛtɛku. Nɛ kɑ nɛn bii sɑ dɔɔ ɡuu teɔnɔn mi, su sɑ̃ɑru ko kpɑ su wurɑmɑ su bɛɛ deemɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Mɑ Aburɑhɑmu u yɑ̃ku dɑ̃ɑ ye suɑ u win bii Isɑki sɔbi. Win tii u dɔ̃ɔ kɑ woburu suɑ u nɛni mɑ be yiru bɑ swĩinɛ. ");
INSERT INTO bba_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yerɑ Isɑki u nùn bikiɑ u nɛɛ, bɑɑbɑ. Aburɑhɑmu u nɛɛ, nɛ wee, nɛn bii. Isɑki nɛɛ, dɔ̃ɔ kɑ dɑ̃ɑ wee, ɑdɑmɑ mɑnɑ yɑ̃ku yɑ̃ɑrɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Aburɑhɑmu nùn wisɑ u nɛɛ, nɛn bii, Gusunɔ u koo tii win yɑ̃ku yɑ̃ɑru wɑɑwɑ. Mɑ be yiru ye, bɑ n dɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Ye bɑ turɑ mi Gusunɔ u rɑɑ nùn yĩreru kuɑ, Aburɑhɑmu u yɑ̃ku yeru kuɑ u yɑ̃ku dɑ̃ɑ ye tɛriɑ ten wɔllɔ, mɑ u win bii Isɑki bɔkuɑ u sɔndi mi. ");
INSERT INTO bba_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Yen biru Aburɑhɑmu u woburu suɑ u kɑ win bii Isɑki sɑkɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Yerɑ Yinni Gusunɔn ɡɔrɑdo u nùn sokɑ wɔllun di u nɛɛ, Aburɑhɑmu, Aburɑhɑmu. Mɑ u nɛɛ, nɛ wee, Yinni. ");
INSERT INTO bba_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Mɑ ɡɔrɑdo wi, u nɛɛ, ɑ ku rɑ bii wi bɑbɑ, ɑ ku nùn ɡɑ̃ɑnu ɡɑnu kuɑ. Domi nɑ ɡiɑ tɛ̃ mɑ ɑ mɑn nɑsie, ɑ ǹ mɑɑ kɑ mɑn wunɛn bii teere te yinɑri. ");
INSERT INTO bba_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Yerɑ Aburɑhɑmu u nɔni seeyɑ u sĩirɑ u yɑ̃ɑ kinɛru wɑ tèn kɔbɑ tɔ̃ki tɛ̃ke tɑ yɔ̃. Mɑ u dɑ u tu mwɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te kuɑ win biin ɑyerɔ. ");
INSERT INTO bba_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Mɑ u yɑm mi yĩsiru kɑ̃, Yinni Gusunɔ u koo bukɑtɑ wunɑnɑ. Yen sɔ̃nɑ bɑ rɑ mɔndu ko kɑ ɡisɔ bu nɛɛ, Yinni Gusunɔn ɡuurɔ bukɑtɑ yɑ koo wunɑnɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Yinni Gusunɔ u kpɑm Aburɑhɑmu sokɑ nɔn mɛɛruse wɔllun di u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","yèn sɔ̃ ɑ kuɑ mɛ, mɑ ɑ ǹ kɑ mɑn wunɛn bii teere te yinɑri, nɛ, Yinni Gusunɔ nɑ bɔ̃rumɔ kɑ nɛn tiin yĩsiru ");
INSERT INTO bba_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","kon nun domɑru kuɑ kɑ ɡem kpɑ n wunɛn bweseru dɑbiɑsiɑ nɡe wɔllun kperi, ǹ kun mɛ nɡe yɑni sɛɛri yi yi wɑ̃ɑ nim wɔ̃kun ɡoorɔ, kpɑ bɑ n ben yibɛrɛbɑ tɑɑre. ");
INSERT INTO bba_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Bwesenu kpuro hɑnduniɑ sɔɔ nu koo domɑru wɑ sɑɑ wunɛn bweserun min di, yèn sɔ̃ ɑ nɛn ɡɑri mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Mɑ Aburɑhɑmu u ɡɔsirɑmɑ u nɑ u win sɔm kowo be deemɑ bɑ wɔmɑ yɛnuɔ Beri Sebɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yenibɑn biruwɑ Aburɑhɑmu u nuɑ mɑ Milikɑ u mɑɑ kɑ win wɔnɔ Nɑkori bibu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","Win bii ɡbiikoon yĩsirɑ Usi. Usin wɔnɔbɑ Busi kɑ Kemuɛli wi u sɑ̃ɑ Arɑmun tundo, ");
INSERT INTO bba_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","kɑ Kesɛdi kɑ Hɑso kɑ Pilidɑsi kɑ Yidilɑfu kɑ Bɛtuɛli. ");
INSERT INTO bba_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Bɛtuɛliwɑ u Rebekɑ mɑrɑ. Bibu nɔɔbɑ itɑ ye Milikɑ u Aburɑhɑmun wɔnɔ Nɑkori mɑruɑ, berɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nɑkorin kurɔ ɡoo wi bɑ mɔ̀ Reumɑ u mɑɑ nùn bibu mɑruɑ. Berɑ Tebɑki kɑ Gɑhɑmu kɑ Tɑhɑsi kɑ Mɑɑkɑ. ");
INSERT INTO bba_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Sɑɑrɑɑ u kuɑwɑ wɔ̃ɔ wunɑɑ teeru kɑ nɔɔbɑ yiru (127) u sere ɡu. ");
INSERT INTO bba_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Heboroniɔwɑ u ɡu Kɑnɑnin temɔ mɑ Aburɑhɑmu u nɑ u win ɡɔɔ swĩ. ");
INSERT INTO bba_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","N deemɑ u ǹ win ɡoo te sikum kpɑ. Yerɑ u seewɑ u dɑ Hɛtibɑn mi, u bu sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","bɛɛn tii i yɛ̃ mɑ nɛ sɔɔwɑ bɛɛn tem mi. Yen sɔ̃, i mɑn tem dɔreo mi ko nɑ n dɑ nɛn tɔmbu sike kpɑ n dɑ n nɛn kurɔ sike mi tɛ̃, nɑ kun win ɡoru mɛɛrɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Mɑ Hɛti be, bɑ Aburɑhɑmu wisɑ bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","yinni, ɑ bɛsɛn ɡɑri swɑɑ dɑkio. Gusunɔ u nun kuɑwɑ sinɑ bii bɛsɛn suunu sɔɔ. A wunɛn kurɔ sikuo bɛsɛn wìn siki wɔru ɡɑ nun wɛ̃re sɔɔ. Goo kun kɑ nun ɡu yinɑrimɔ. ");
INSERT INTO bba_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Yerɑ Aburɑhɑmu u tɔn be yiirɑ u bu bɛɛrɛ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","U nɛɛ, ì n kĩ n nɛn kurɔ sike kpɑ nɑ kun win ɡoru mɛɛrɑ, i Eforoni Sokɑɑn bii sɔ̃ɔwɔ yèn bukɑtɑ nɑ mɔ, ");
INSERT INTO bba_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","kpɑ u mɑn Mɑkpelɑn kpee wɔru ɡe ɡɑ wɑ̃ɑ win ɡbee ɡoorɔ deriɑ kpɑ n nùn ɡobi kɔsiɑ nɡe mɛ̀n nɔɔ u ɡeruɑ, kpɑ ɡu ko nɛn siku yeru bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","N deemɑ Eforoni Hɛti wi, u sɔ̃ kɑ wuun wiruɡibu ɡbɑ̃rɑ kɔnnɔwɔ mi bɑ rɑ sinɛ. Mɑ u Aburɑhɑmu wisɑ Hɛti be kɑ be bɑ dumɔ min nɔni biru u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","ɑɑwo, nɛn yinni, nɑ nun ɡbee te kɑ̃wɑ kɑ kpee wɔru ɡe ɡɑ wɑ̃ɑ mi. A ɡu mɔɔ nɛn tɔmbu kpuron nɔni birɔ. A doo ɑ wunɛn kurɔ sike mi. ");
INSERT INTO bba_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Mɑ Aburɑhɑmu u yiirɑ tɔn ben wuswɑɑɔ ");
INSERT INTO bba_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","u Eforoni sɔ̃ɔwɑ u nɛɛ, ɑ mɑɑ nɛɡii swɑɑ dɑkio. Kon nun ɡbee ten ɡobi kɔsiɑwɑ. A yi mɔɔ kpɑ n nɛn kurɔ sike mi. ");
INSERT INTO bba_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Adɑmɑ Eforoni u Aburɑhɑmu sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","nɛn yinni, ɑ swɑɑ dɑkio ɑ nɔ. Mbɑ sii ɡeesun ɡobi nɛɛru (400) yɑ turɑ nɛ kɑ wunɛn bɑɑ sɔɔ. A wunɛn kurɔ sikuo kperu mi. ");
INSERT INTO bba_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Aburɑhɑmu u Eforonin ɡɑri yi wurɑ, mɑ u sii ɡeesun ɡobi nɛɛ te suɑ u Eforoni wɛ̃ Hɛtibɑ kpuron nɔni biru. Sii ɡeesun ɡobi yirɑ tenkubɑ bɑ rɑ kɑ kiɑru dwe sɑɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Nɡe mɛyɑ Eforonin ɡbee te kɑ ten kpee wɔru ɡe kɑ ten dɑ̃ɑ ni nu wɑ̃ɑ mi kpuro ");
INSERT INTO bba_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","yɑ kuɑ Aburɑhɑmuɡiɑ Hɛtibɑ kpuron nɔni biru kɑ sere be bɑ mɑɑ dumɔ ɡbɑ̃rɑ kɔnnɔn min di. ");
INSERT INTO bba_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Yen biruwɑ Aburɑhɑmu u win kurɔ Sɑɑrɑɑ sikuɑ Mɑkpelɑn kpee wɔru ɡe sɔɔ Mɑnden deedeeru Heboroniɔ Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Nɡe mɛyɑ ɡbee te Aburɑhɑmu u dwɑ Hɛti win mi, kɑ kpee wɔru ɡe, n kɑ kuɑ win tɔmbun siku yeru. ");
INSERT INTO bba_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Aburɑhɑmu wee, u tɔkɔ kuɑ ɡem ɡem. Yinni Gusunɔ u mɑɑ nùn domɑru kuɑ yɑbu bɑɑyere kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Sɔ̃ɔ teeru u win yobun tɔnwero wi u win yɛnun dukiɑ kpuro nɔmu sɔndiɑ sɔ̃ɔwɑ u nɛɛ, nɑ nun kɑnɑmɔ, ɑ wunɛn nɔmɑ dokeo nɛn tɔbuɔ, ");
INSERT INTO bba_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","kpɑ ɑ bɔ̃re kɑ Yinni Gusunɔn yĩsiru wi u sɑ̃ɑ wɔllu kɑ tem Yinni, mɑ ɑ ǹ kɑɑ nɛn bii kurɔ suɑ Kɑnɑnin bii wɔndiɑbɑ sɔɔ bèn suunu sɔɔ sɑ wɑ̃ɑ mini. ");
INSERT INTO bba_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Adɑmɑ kɑɑ dɑ nɛn temɔ sere nɛn wuuɔ ɑ nɛn bii Isɑki kurɔ kɑsuɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Yoo wi, u nùn wisɑ u nɛɛ, ɑ̀ ku tubɑ kurɔ wi, u ǹ ko n kĩ u mɑn swĩimɑ sere tem mini. N weenɛ n kɑ wunɛn bii dɑ tem mìn di ɑ yɑrimɑ? ");
INSERT INTO bba_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Aburɑhɑmu u nɛɛ, ɑɑwo, ɑ lɑɑkɑri ko ɑ ku rɑ kɑ nɛn bii dɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Gusunɔ, wɔllun Yinni, wi u mɑn yɑrɑmɑ nɛn bɑɑn yɛnu kɑ nɛn tem di, u kɑ mɑn ɡɑri kuɑ u bɔ̃ruɑ u nɛɛ, nɛn bibun bweserɑ u koo tem mɛ wɛ̃. Wiyɑ u koo de win ɡɔrɑdo u nun ɡbiiyɑ kpɑ ɑ kɑ nɛn bii kurɔ kɑsuɑmɑ min di. ");
INSERT INTO bba_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Kurɔ wi, ù kun kĩ u nun swĩimɑ ɑ dibu yɑrɑ bɔ̃ri yin min di. Adɑmɑ ɑ ku rɑ kɑ nɛn bii dɑ tem mi. ");
INSERT INTO bba_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Yerɑ yoo wi, u win nɔmɑ doke win yinni Aburɑhɑmun tɔbuɔ u kɑ bɔ̃ruɑ mɑ u koo ye kpuro ko mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Yen biru u yooyoosu wɔkuru wunɑ sɑɑ win yinnin yooyoosu sɔɔn di, domi win yinnin ɑrumɑni kpuro wɑ̃ɑwɑ win nɔmɑɔ. Mɑ u seewɑ u swɑɑ wɔri u dɑ Aburɑhɑmun wɔnɔ Nɑkorin wuuɔ Mɛsopotɑmin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Ye u turɑ wuu ɡen bɔkuɔ u win yooyoosu yiirɑsiɑ su kɑ wɛ̃rɑ dɔkɔ ɡɑɑn bɔkuɔ yokɑ, sɑɑ ye tɔn kurɔbɑ rɑ nim tɑkɑm nɛ. ");
INSERT INTO bba_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Yerɑ u nɛɛ, Gusunɔ, wunɛ wi ɑ sɑ̃ɑ nɛn yinni Aburɑhɑmu Yinni, nɑ nun kɑnɑmɔ, ɑ Aburɑhɑmu durom kuo, ɑ de ye nɑ kɑso nɑ n ye wɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Wee nɑ wɑ̃ɑ dɔkɔ yèn bɔkuɔ mi wuu ɡen wɔndiɑbɑ bɑ koo yɑrimɑ bu nim tɑkiri. ");
INSERT INTO bba_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Ben wi kon nim nɔrurɑm kɑnɑ n nɔ, kpɑ u win tooru sikɑ u nɛɛ, n nɔruo, kpɑ u mɑɑ nɛn yooyoosu kɛ̃, ɑ de wɔndiɑ wi, u n sɑ̃ɑ wi ɑ wunɛn bɔ̃ɔ Isɑki ɡɔsiɑ. À n kuɑ mɛ, ko nɑ n yɛ̃ mɑ ɑ nɛn yinni durom kuɑwɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","U kɑ ɡɑri yi ɡere u kpe, wee Rebekɑ u yɑrimɑ kɑ tooru. Rebekɑ wi, win tundowɑ Bɛtuɛli, Nɑkorin bii wi Milikɑ u nùn mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Wɔndiɑ wi, kurɔ burɔn tii tiiwɑ. Mɛyɑ u ǹ durɔ yɛ̃. U duɑ bwiɑɔ u nim tɑkɑ mɑ u kpɑm mɑkɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Yerɑ yoo wi, u dukɑ dɑ u kɑ nùn yinnɑ u nùn bikiɑ u nɛɛ, kɑɑ wurɑ ɑ mɑn nim kɛ̃ n nɔ fiiko wunɛn tooru min di? ");
INSERT INTO bba_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","U nɛɛ, oo. Mɑ u too te sɔbiɑ u nùn mu kɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Sɑnɑm mɛ u durɔ wi nim mɛ kɑ̃ u kpɑ u nɛɛ, kon mɑɑ wunɛn yooyoosu tɑkiriɑmɑ su nɔ su debu. ");
INSERT INTO bba_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Yerɑ u nim mɛ mu tie wisi kɑ sɛndɑru mi yɛɛ rɑ nim nɔ mɑ u dukɑ wurɑ bwiɑɔ u yooyoo si kpuro tɑkiriɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Durɔ wi, u nùn mɛɛrɑ kɑ biti, ɑdɑmɑ u mɑri u kɑ wɑ Yinni Gusunɔ ù n win sɑnum mɛ dorɑsiɑmɔn nɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Sɑnɑm mɛ yooyoo si, su nim nɔrɑ su kpɑ, durɔ wi, u wurɑn tɑɑbu yɑrɑmɑ ɡe ɡɑ ɡeɑ sɑ̃ɑ kɑ wurɑn sum bɛkɛ yiru yi yi bunu u nùn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Mɑ u nɛɛ, wɑrɑn biiwɑ ɑ sɑ̃ɑ. A ɡem mɔ, ɑ mɑn sɔ̃ɔwɔ, ɑyerɑ wɑ̃ɑ wunɛn bɑɑn yɛnuɔ n kɑ sɔbiɑ mi? ");
INSERT INTO bba_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Rebekɑ u nùn wisɑ u nɛɛ, nɛn bɑɑwɑ Bɛtuɛli wi Milikɑ u Nɑkori mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Bɛsɛn yɛnuɔ yɑkɑsu kɑ tɑkɑ kpuro yibɑwɑ, ɑyerɑ mɑɑ wɑ̃ɑ mi kɑɑ sɔbiɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Mɑ durɔ wi, u yiirɑ u Yinni Gusunɔ siɑrɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","Gusunɔɡiɑ siɑrɑbu wi u sɑ̃ɑ nɛn yinni Aburɑhɑmun Yinni, wi u kun dere win wɔnwɔndu kɑ win bɔrɔkiniru tu nùn dɛsirɑri. Mɑ u mɑn kpɑrɑ u kɑ dɑ sere win wɔnɔbun yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Mɑ Rebekɑ u dukɑ dɑ u win mɛron yɛnuɡibu ye kpuro sɑɑriɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","N deemɑ u sesu ɡoo mɔ, win yĩsirɑ Lɑbɑni. ");
INSERT INTO bba_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Lɑbɑni wi, u tɑɑbu ɡe kɑ sumi yi wɑ win sesu Rebekɑn nɔmɑɔ, u mɑɑ win ɡere kpuro nuɑ ye u nɛɛ, mɛsumɑ durɔ wi, u nùn sɔ̃ɔwɑ. Yerɑ u yɑrɑ kɑ dukɑ u durɔ wi sennɔ dɑ mi u wɑ̃ɑ kɑ win yooyoosu bwiɑn bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Ye u turɑ mi, u nɛɛ, ɑ seewo su dɑ yɛnuɔ, wunɛ wi Yinni Gusunɔ u domɑru kuɑ. Mbɑn sɔ̃nɑ kɑɑ n yɔ̃ tɔɔwɔ. Wɔɔ, nɑ nun ɑyeru kuɑ yɛnuɔ kɑ wunɛn yooyoosuɡiru kpuro. ");
INSERT INTO bba_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Ye durɔ wi, u turɑ yɛnu mi, Lɑbɑni u derɑ bɑ yooyoosun sɔmunu kusiɑ mɑ u su yɑkɑsu kɑ tɑkɑ wɛ̃ su di. Mɑ u nim tɑmɑ mɛ durɔ wi kɑ wiɡibu bɑ koo kɑ kɔ̃ri kpɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Mɑ bɑ nùn dĩɑnu yiiyɑ. Adɑmɑ u nɛɛ, nɑ ǹ ɡinɑ dimɔ mɑ n kun mɔ nɑ ɡɑri yi nɑ kɑ sĩimɔ ɡeruɑ nɑ kpɑ. Mɑ Lɑbɑni u nɛɛ, ɑ ɡeruo. ");
INSERT INTO bba_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Yerɑ u nɛɛ, nɑ sɑ̃ɑwɑ Aburɑhɑmun yoo. ");
INSERT INTO bba_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Yinni Gusunɔ u nɛn yinni wi domɑru kuɑ ɡem ɡem mɑ u kuɑ ɡobiɡii kpoko. U nùn yɑ̃ɑnu kɑ̃ kɑ kɛtɛbɑ kɑ yooyoosu kɑ kɛtɛkunu kɑ sii ɡeesu kɑ wurɑ kɑ yoo tɔn durɔbu kɑ tɔn kurɔbu. ");
INSERT INTO bba_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Win kurɔ Sɑɑrɑɑ u mɑɑ nùn bii tɔn durɔ mɑruɑ win tɔkɔru sɔɔ, mɑ u bii wi ye u mɔ kpuro wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","U mɑɑ mɑn bɔ̃rusiɑ sɑnɑm mɛ u nɛɛ, n ku rɑ win bii wi kurɔ suɑ Kɑnɑnin wɔndiɑbɑ sɔɔ, bèn temɔ u wɑ̃ɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Adɑmɑ n doo win dusibun mi, n nùn kurɔ kɑsuɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Nɑ nùn sɔ̃ɔwɑ nɑ nɛɛ, kurɔ wi, ù kun kĩ u mɑn swĩimɑ mɑɑ ni? ");
INSERT INTO bba_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Mɑ u mɑn wisɑ u nɛɛ, Yinni Gusunɔ wi u sɑ̃ɑmɔ u koo win ɡɔrɑdo ɡɔrimɑ u kɑ mɑn dɑ kpɑ u nɛn sɑnum dorɑsiɑ kpɑ n win bii kurɔ suɑmɑ win dusibun min di. ");
INSERT INTO bba_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Nɑ̀ n wurɑ nɑ dɑ win dusibun mi, nɑ dibu yɑrɑ nɛn bɔ̃rin di. Nɑ̀ n mɑɑ turɑ mi, mɑ bɑ kun mɑn ɡoo wɛ̃, kɑ mɛ, nɑ dibu yɑrɑ nɛn bɔ̃rin di. ");
INSERT INTO bba_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Ye nɑ tunumɑ bwiɑɔ ɡisɔ nɑ nɛɛ, Gusunɔ, wunɛ wi ɑ sɑ̃ɑ nɛn yinni Aburɑhɑmun Yinni, ɑ mɑn nɛn sɑnum mɛ dorɑsio. ");
INSERT INTO bba_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Wee, nɑ wɑ̃ɑ bwiɑ yen bɔkuɔ. Bii wɔndiɑ wi u koo nim tɑkɑm nɑ, mɑ nɑ nùn kɑnɑ nɑ nɛɛ, u mɑn nim kɛ̃ n nɔ win toorun di, ");
INSERT INTO bba_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","kpɑ u mɑn wisi u nɛɛ, n nɔruo kpɑ u mɑɑ nɛn yooyoosu tɑkɑ, ɑ de wɔndiɑ wi, u n sɑ̃ɑ kurɔ wi ɑ nɛn yinnin bii ɡɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","N kɑ nɛn ɡɔ̃ruɔ ɡɑri yi ɡere n kpe, mɑ Rebekɑ u yɑrimɑ kɑ win tooru. Mɑ u duɑ bwiɑɔ u nim tɑkɑmɑ. Mɑ nɑ nùn kɑnɑ nɑ nɛɛ, u mɑn nim kɛ̃ n nɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","U win tooru sɔbiɑ fuuku u nɛɛ, n nɔruo. Yen biru u koo mɑɑ nɛn yooyoosu tɑkiriɑmɑ su nɔ. Nɑ nɔrɑ mɑ u mɑɑ su kɑ̃ su nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Nɑ nùn bikiɑ nɑ nɛɛ, wɑrɑn biiwɑ u sɑ̃ɑ. U wisɑ u nɛɛ, Bɛtuɛliwɑ u sɑ̃ɑ win tundo wi Nɑkori kɑ Milikɑ bɑ mɑrɑ. Mɑ nɑ nùn tɑɑbu dokeɑ wɛ̃rɔ. Mɑ nɑ sumi doke win nɔmɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Yerɑ nɑ Yinni Gusunɔ kpunɑ wi u sɑ̃ɑ nɛn yinni Aburɑhɑmun Yinni. Mɑ nɑ nùn siɑrɑ yèn sɔ̃ u mɑn kpɑrɑ kɑ bɔrɔkiniru n kɑ nɑ n nɛn yinnin wɔnɔn debubu win bii suɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tɛ̃, ì n kĩ i nɛn yinni durom kɑ bɔrɔkiniru kuɑ, i mɑn sɔ̃ɔwɔ. Ì kun mɑɑ mɔ̀, i mɑn sɔ̃ɔwɔ, kpɑ n dɑ ɡɑm. ");
INSERT INTO bba_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Lɑbɑni kɑ Bɛtuɛli bɑ wisɑ bɑ nɛɛ, Yinni Gusunɔn min diyɑ yeni kpuro yɑ wee. Sɑ ǹ kpɛ̃ su yen ɡeɑ ǹ kun mɛ yen kɔ̃sɑ ɡere. ");
INSERT INTO bba_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Rebekɑ wee wunɛn wuswɑɑɔ. A nùn suo ɑ kɑ dɑ u n sɑ̃ɑ wunɛn yinnin biin kurɔ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Ye Aburɑhɑmun yoo wi, u ben ɡɑri yi nuɑ, mɑ u Yinni Gusunɔ kpunɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Yen biru u sii ɡeesu kɑ wurɑbɑ yɑrɑmɑ kɑ bekɑ u Rebekɑ kɑ̃. U mɑɑ win sesu kɑ win mɛro ɡɑ̃ɑ ɡeenu kɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Yenin biru durɔ wi kɑ win tɔmbu bɑ di bɑ nɔrɑ mɑ bɑ kpunɑ. Ye bɑ seewɑ bururu, yoo wi, u nɛɛ, i de n ɡɔsirɑ n wurɑ nɛn yinnin mi. ");
INSERT INTO bba_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Adɑmɑ Rebekɑn sesu kɑ win mɛro bɑ nɛɛ, ɑ de wɔndiɑ wi, u kɑ sun sinɑ sɑɑ fiiko nɡe sɔ̃ɔ wɔkurun sɑkɑ kpɑ ɑ sere doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","U bu wisɑ u nɛɛ, i ku mɑɑ de n tɛ, domi Yinni Gusunɔ u nɛn sɑnum dorɑsiɑ. Yen sɔ̃, i mɑn kɑro n dɑ nɛn yinnin mi. ");
INSERT INTO bba_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Yerɑ bɑ nɛɛ, su wɔndiɑ win tii soku su nɔ ye u koo ɡere. ");
INSERT INTO bba_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Mɑ bɑ Rebekɑ sokɑ bɑ nùn bikiɑ bɑ nɛɛ, ɑ wurɑ ɑ kɑ durɔ wi dɑ? Mɑ u nɛɛ, oo, kon dɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Mɑ bɑ ben sesu Rebekɑ kɑ yoo wi u nùn nɔɔri win birun di nɔɔ kɑnɑ bɑ doonɑ kɑ Aburɑhɑmun yoo wi kɑ tɔn be bɑ nùn yɔ̃sirimɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Bɑ Rebekɑ domɑru kuɑ bɑ nɛɛ, wunɑ bɛsɛn sesu, Gusunɔ u de ɑ ko tɔn dɑbinun mɛro, kpɑ wunɛn bibun bweseru tu ten yibɛrɛbɑ tɑɑre tu ben wusu mwɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Rebekɑ kɑ win yoo tɔn kurɔbu bɑ seewɑ bɑ yooyoosu sɔni bɑ durɔ wi swĩi bɑ n doonɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","N deemɑ Isɑki u wurɑmɑ dɔkɔn di ye bɑ mɔ̀ Gusunɔ u mɑn wɑɑmɔ, mɑ u dɑ u wɑ̃ɑ ɡbɑburɔ Nɛɡɛbuɔ. ");
INSERT INTO bba_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Sɔ̃ɔ teeru u yɑrɑ yokɑ u swɑɑ ɡɑwɑ u kɑ bwisiku. Yerɑ u nɔni seeyɑ u mɛɛrɑ sɑruɔ u yooyoosu wɑ su wee. ");
INSERT INTO bba_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Rebekɑn tii u mɑɑ nɔni seeyɑ u mɛɛrɑ u Isɑki wɑ mɑ u sɑrɑ yooyoon di ");
INSERT INTO bba_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","u yoo wi bikiɑ u nɛɛ, durɔ wɑrɑ u sisi yɑkɑsun di u kɑ sun yinnɑ mini. Yoo wi, u nɛɛ, nɛn yinniwɑ. Yerɑ Rebekɑ u sɔnditiɑ suɑ u tii wukiri nɡe mɛ ben komɑru. ");
INSERT INTO bba_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Ye bɑ kɑ Isɑki yinnɑ, yoo wi, u nùn ɡɑri yi kpuro sɑɑriɑ ye u kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Mɑ Isɑki u kɑ Rebekɑ dɑ win mɛro Sɑɑrɑɑn kuu bekuruɡirɔ. Mɑ u nùn suɑ win kurɔ. U nùn kĩɑ ɡem ɡem. Nɡe mɛyɑ Isɑkin nukurɑ kɑ yɛmiɑ win mɛron ɡɔɔn biru. ");
INSERT INTO bba_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Sɑɑrɑɑn ɡɔɔn biru Aburɑhɑmu u mɑɑ kurɔ suɑ. Kurɔ win yĩsirɑ Keturɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Kurɔ wi, u Aburɑhɑmu bibu nɔɔbɑ tiɑ mɑruɑ. Berɑ Simurɑni kɑ Yokusɑni kɑ Mɛdɑni kɑ Mɑdiɑni kɑ Yisibɑku kɑ Suɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Mɑ Yokusɑni u seewɑ u Sebɑ kɑ Dedɑni mɑrɑ. Dedɑnin bibun bweserɑ Asuribɑ kɑ Letusibɑ kɑ Lumibɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Mɑdiɑni u mɑɑ seewɑ u bibu mɑrɑ. Berɑ Efɑ kɑ Efɛɛ kɑ Enɔku kɑ Abidɑ kɑ Ɛlidɑ. Beni kpurowɑ bɑ sɑ̃ɑ Keturɑn bibu kɑ win nikurɔminu. ");
INSERT INTO bba_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Adɑmɑ ye Aburɑhɑmu u mɔ kpuro, Isɑki turowɑ u wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Mɑ u win kurɔ be bɑ tien bibu kɛ̃nu kɑ̃ kɑ̃. Yen biru u bu ɡirɑ Isɑkin min di, bɑ dɑ sɔ̃ɔ yɑri yerun berɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Aburɑhɑmu u tɔkɔ kuɑ kɔ̃ɔ kɔ̃ɔ, u kuɑwɑ wɔ̃ɔ wunɑɑ wɑtɑ kɑ wɔkurɑ nɔɔbu (175) mɑ u kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Yerɑ win bibu Isɑki kɑ Isimɛɛli bɑ nɑ bɑ nùn sikuɑ Mɑkpelɑn kpee wɔruɔ Eforoni Sokɑɑn biin ɡberɔ, Mɑnden deedeeru. Eforoni wi, u sɑ̃ɑwɑ Hɛti. ");
INSERT INTO bba_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Aburɑhɑmun tiiwɑ u ɡbee te dwɑ Hɛtibɑn mi. N deemɑ miyɑ bɑ rɑɑ win kurɔ Sɑɑrɑɑ sikuɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Aburɑhɑmun ɡɔɔn biru Gusunɔ u win bii Isɑki domɑru kuɑ. Sɑɑ ye sɔɔ, u wɑ̃ɑwɑ dɔkɔn bɔkuɔ ye bɑ mɔ̀ Gusunɔ u mɑn wɑɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Isimɛɛlin bibun bweseru wee. Isimɛɛli u sɑ̃ɑwɑ Aburɑhɑmun bii wi u kɑ Aɡɑɑ Eɡibitiɡii mɑrɑ. Aɡɑɑ wi, u sɑ̃ɑwɑ Sɑɑrɑɑn yoo wi u Aburɑhɑmu wɛ̃ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Isimɛɛli wiyɑ u seewɑ u bibu mɑrɑ. Ben yĩsɑ wee nɡe mɛ bɑ bɔm wɛ̃ɛnɑ. Nɛbɑyɔtuwɑ u sɑ̃ɑ win bii ɡbiikoo. Nɛbɑyɔtun wɔnɔbɑ Kedɑɑ kɑ Adibɛli kɑ Mibusɑmu ");
INSERT INTO bba_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","kɑ Mikimɑ kɑ Dumɑ kɑ Mɑsɑ ");
INSERT INTO bba_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","kɑ Hɑdɑdi kɑ Temɑ kɑ Yeturi kɑ Nɑfisi kɑ Kɛdimɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Mɑ be wɔkurɑ yiru yen bɑɑwure u kuɑ win bwese kɛrɑn wiruɡii. Ben tiin yĩsɑ bɑ ben wusu kɑ̃ kɑ ben ɡberu kpɑɑnɛbɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Isimɛɛli u kuɑwɑ wɔ̃ɔ wunɑɑ teeru kɑ wɔkurɑ nɔɔbu kɑ yiru. Yen biru u kpunɑ u ɡu u win bɑɑbɑbɑ deemɑ ɡɔriɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Win bibu bɑ wɑ̃ɑwɑ nɛnɛm bɑ kɑ Aburɑhɑmun bii be bɑ tie tondinɛ. Bɑ dɑ bɑ sinɑ Hɑfilɑ kɑ Surin tem bɑɑ sɔɔ Eɡibitin tem sɔ̃ɔ yɑri yeru ɡiɑ, Asirin swɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Aburɑhɑmun bii Isɑkin bibun bweseru wee. ");
INSERT INTO bba_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Ye Isɑki u kuɑ wɔ̃ɔ weeru yerɑ u Rebekɑ suɑ kurɔ. Rebekɑ u sɑ̃ɑwɑ Lɑbɑnin sesu. Ben bɑɑwɑ Bɛtuɛli Arɑmuɡii. Ben wuuwɑ mɑɑ Pɑdɑnɑrɑmu. ");
INSERT INTO bba_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Isɑki u Yinni Gusunɔ kɑnɑ win kurɔn sɔ̃ domi u kuɑ wĩro. Gusunɔ u win kɑnɑru mwɑ, mɑ win kurɔ Rebekɑ u ɡurɑ suɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Yerɑ bibɑ kuru kɑrɑnɑmɔ win nukurɔ. Mɑ u nɛɛ, mbɑn sɔ̃nɑ yenin bweserɑ mɑn deemɑ. Mɑ u Gusunɔ bikiɑ, mbɑ yenin tubusiɑnu. ");
INSERT INTO bba_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Yerɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, bwesenu yiruwɑ nu wɑ̃ɑ wunɛn nukurɔ. Bwese ni, nu koo kɑbɑnɑ sɑnɑm mɛ nu yɑrɑ wunɛn nukurun di. Nin teerɑ koo tensim dɑm kerɑ. Mɔɔ wiyɑ u koo win wɔnɔ wiru kpĩiyɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ye kurɔ win mɑru suru yibɑ, wee sikɑbɑrɑ bɑ wɑ̃ɑ win nukurɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Gbiikoo u yɑrɑ mɑ win wɑsi sɑnsu yibɑ, mɑ bɑ nùn yĩsiru kɑ̃ Esɑu . ");
INSERT INTO bba_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Yen biru yiruse mɑɑ yɑrimɑ. Win nɔmɑ Esɑun nɑɑ tokuru nɛni. Mɑ bɑ nùn yĩsiru kɑ̃ Yɑkɔbu . Isɑki u mɔwɑ wɔ̃ɔ wɑtɑ sɑnɑm mɛ bɑ bu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Bii be, bɑ seewɑ bɑ kpɛ̃ɑ. Esɑu u kuɑ tɑɑso ɡeo, u rɑ n wɑ̃ɑwɑ yɑkɑsɔ. Adɑmɑ Yɑkɔbu u kuɑwɑ tɔn sɛ̃ɛ wi u rɑ n wɑ̃ɑ yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Isɑki u Esɑu kĩru bo, domi u rɑ win tɑɑsorun yɑɑ tem. Mɑ Rebekɑ u mɑɑ Yɑkɔbu kĩru bo. ");
INSERT INTO bba_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Sɔ̃ɔ teeru nɡe mɛ Yɑkɔbu u ɑɡbɑɑrɑ ye yɑ swɛ̃ri mɔ̀, yerɑ Esɑu u wurɑmɑ tɑɑso ɡberun di kɑ wɑsirɑ bɑkɑru. ");
INSERT INTO bba_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yerɑ u Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, ɑ mɑn yɑbu swɑ̃ɑ ye sɔko n nɔ, domi nɑ wɑsirɑ too. Yen sɔ̃nɑ bɑ Esɑu sokɑ Edɔmu. Yen tubusiɑnɑ tɔn swɑ̃ɔ. ");
INSERT INTO bba_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Mɑ Yɑkɔbu u nɛɛ, ɑ ɡinɑ mɑn wunɛn bii yerumɑrun tubi dɔreo. ");
INSERT INTO bba_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esɑu u nɛɛ, n wee nɑ ɡɔɔ dɔɔ. Mbɑ nɛn yerumɑrun ɑrufɑɑni. ");
INSERT INTO bba_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Mɑ Yɑkɔbu nɛɛ, ɑ bɔ̃ruo ɡinɑ. Mɑ u bɔ̃ruɑ mɑ u win yerumɑru Yɑkɔbu dɔre. ");
INSERT INTO bba_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Sɑɑ yerɑ Yɑkɔbu u pɛ̃ɛ kɑ ɑɡbɑɑrɑ yè sɔɔ u swii doke suɑ u Esɑu wɛ̃. Esɑu u di u nɔrɑ mɑ u wiɡiru doonɑ. Nɡe mɛyɑ n kuɑ u kɑ win yerumɑru ɡɛmɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Gɔ̃ɔrɑ kpɑm duɑ tem mɛ sɔɔ, nɡe mɛ tɑ rɑɑ kuɑ Aburɑhɑmun wɑɑti. Mɑ Isɑki u dɑ u wɑ̃ɑ Abimɛlɛki Filisitibɑn sinɑ bokon mi Gerɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Sɔ̃ɔ teeru Yinni Gusunɔ u Isɑki kure u kɑ nùn ɡɑri kuɑ u nɛɛ, ɑ ku rɑ dɑ Eɡibitiɔ. A de ɑ sinɑ tem mɛ kon nun sɔ̃ɔsi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","A ku doonɑ tem minin di. Ko nɑ n wɑ̃ɑ kɑ wunɛ kpɑ n nun domɑru kuɑ. Domi wunɛn bibun bweserɑ kon tem mɛ wɛ̃. Mɛsumɑ kon kɑ nɛn nɔɔ mwɛɛru yibiɑ te nɑ wunɛn tundo Aburɑhɑmu kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Kon de wunɛn bibun bweseru tu dɑbiɑ nɡe wɔllun kperi. Beyɑ kon mɑɑ tem mɛ kpuro wɛ̃. Ben min diyɑ hɑnduniɑn bwesenu nu koo domɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Domi Aburɑhɑmu u nɛn ɡere mɛm nɔɔwɑ, u mɑɑ nɛn woodɑbɑ swĩi ye nɑ nùn sɔ̃ɔwɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yerɑ n derɑ Isɑki u sinɑ Gerɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Ye u wɑ̃ɑ mi, tɔmbu bɑ̀ n nùn win kurɔn ɡɑri bikiɑ, u rɑ nɛɛ, win sesuwɑ yèn sɔ̃ u bɛrum mɔ̀ bu ku rɑɑ nùn ɡo ù n nɛɛ win kurɔwɑ. Domi Rebekɑ u sɑ̃ɑwɑ kurɔ burɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Nɡe mɛ u tɛɛmɔ wuu mi, yerɑ sɔ̃ɔ teeru Abimɛlɛki Filisitibɑn sunɔ wi, u mɛɛrimɑ sɑɑ win dirun fɛnɛntin di u wɑ wee, Isɑki kɑ Rebekɑ bɑ bɔndɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Mɑ u Isɑki sokusiɑ. Ye u nɑ, u nùn bikiɑ u nɛɛ, ɑse wunɛn kurɔwɑ Rebekɑ. Mɑ ɑ sun weesu kuɑ ɑ nɛɛ, wunɛn sesuwɑ? Isɑki u nùn wisɑ u nɛɛ, nɑ ǹ kĩ bu mɑn ɡowɑ. Yen sɔ̃nɑ nɑ kɑ ɡeruɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abimɛlɛki u nùn sɔ̃ɔwɑ u nɛɛ, mbɑn bweserɑ ɑ sun kuɑ mɛ. Wee, n dɑɑ tie fiiko ɡoo u kɑ wunɛn kurɔ wi kpunɑ, kpɑ ɑ rɑ de sɑ n sɑ̃ɑ tɑɑrɛɡibu. ");
INSERT INTO bba_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Sɑɑ yerɑ u kpɑrɑ u nɛɛ, wi u Isɑki ǹ kun mɛ win kurɔ bɑbɑ bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yenibɑ kpuron biru Isɑki u ɡberu kuɑ tem mi. Mɑ win dĩɑnu ɡeɑ kuɑ wɔ̃ɔ ɡe sɔɔ. Nu kuɑwɑ ye u duurɑn nɔn wunɔbu (100) yèn sɔ̃ Yinni Gusunɔ u nùn domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nɡe mɛyɑ Isɑkin dukiɑ yɑ kɑ kuurɑmɔ yɑ dɔɔ. Mɑ u kuɑ ɡobiɡii kpoko. ");
INSERT INTO bba_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","U yɑ̃ɑnu kɑ kɛtɛbɑ mɔ kɑ yoo dɑbinu. Yerɑ n derɑ Filisitibɑ bɑ kɑ nùn nisinu seewɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Mɑ bɑ dɔkɔ be win tundo Aburɑhɑmun yobɑ rɑɑ ɡbɑ kpuro kɔruɑ kɑ tem. ");
INSERT INTO bba_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Yerɑ Abimɛlɛki u nɛɛ, ɑ doonɔ bɛsɛn min di, domi ɑ sun dɑm kere. ");
INSERT INTO bba_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Mɑ Isɑki u doonɑ ben min di u dɑ u wɑ̃ɑ dɑru wɔwɑ ɡɑɑn mi, Gerɑn tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","U win tundo Aburɑhɑmun dɔkɔbɑ wiɑ ye Filisitibɑ bɑ rɑɑ kɔruɑ win ɡɔɔn biru. Mɑ u dɔkɔ be yĩsɑ kɑ̃ kɑ̃ nɡe mɛ win tundo u rɑ rɑɑ bu soku. ");
INSERT INTO bba_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Mɑ Isɑkin yoo be, bɑ dɔkɔ ɡbɑ wɔwɑ ye sɔɔ, bɑ nim ɡem kɑmɛ. ");
INSERT INTO bba_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Kɑ mɛ, Gerɑɡibun nɑɑ kpɑrobɑ nɑ bɑ Isɑkin nɑɑ kpɑrobu sɑnnɔ nɔɔ kuurɑ bɑ nɛɛ, ben dɔkɔwɑ. Mɑ Isɑki u dɔkɔ ye yĩsiru kɑ̃ Sikirinɔsu. ");
INSERT INTO bba_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Yerɑ Isɑkin yoo be, bɑ kpɑm dɔkɔ ɡɑɑ ɡbɑ, mɑ Gerɑɡibun nɑɑ kpɑro be, bɑ kpɑm nɑ bɑ kɑ bu sɑnnɑ dɔkɔ yen sɔ̃. Mɑ Isɑki u dɔkɔ ye yĩsiru kɑ̃ Yibɛrɛ. ");
INSERT INTO bba_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Mɑ u win kuru wukɑ sɑɑ min di u dɑ u sinɑ ɡɑm ɡiɑ. Mɑ u kpɑm dɔkɔ ɡbɑ mi. Adɑmɑ bɑ ǹ mɑɑ kɑ nùn sɑnnɛ. Mɑ u yɑm mi yĩsiru kɑ̃ Tii mɔru. ");
INSERT INTO bba_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yen biru Isɑki u doonɑ sɑɑ min di mɑ u dɑ Beri Sebɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Yerɑ Yinni Gusunɔ u nùn kure wɔ̃ku te, u nɛɛ, nɛnɑ nɑ Gusunɔ wunɛn tundo Aburɑhɑmun Yinni. A ku bɛrum ko. Ko nɑ n wɑ̃ɑ kɑ wunɛ. Kon nun domɑru kuɑ kpɑ n de wunɛn bweseru tu dɑbiɑ nɛn bɔ̃ɔ Aburɑhɑmun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Mɑ Isɑki u yɑ̃ku yeru bɑnɑ Beri Sebɑ mi, u Yinni Gusunɔ sɑ̃wɑ. U win kuu bekuruɡinu ɡirɑ, mɑ win yobɑ dɔkɔ ɡbɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Sɑɑ yerɑ Abimɛlɛki kɑ win bɔrɔ Ahusɑti kɑ sere mɑɑ win tɑbu sunɔ Pikoli bɑ seewɑ Gerɑn di bɑ Isɑki berɑm dɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Ye bɑ turɑ mi, yerɑ u bu bikiɑ u nɛɛ, mbɑn sɔ̃nɑ i mɑɑ mɑn nɑɑ swĩi. Domi bɛɛyɑ i mɑn tusɑ i ɡirɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Mɑ bɑ nùn wisɑ bɑ nɛɛ, sɑ yɛ̃ mɑ Yinni Gusunɔ u wɑ̃ɑ kɑ wunɛ. Yen sɔ̃nɑ sɑ nɑ ɑ kɑ sun ɑrukɑwɑni bɔke. ");
INSERT INTO bba_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ǹ n mɛn nɑ, ɑ bɔ̃ruo mɑ ɑ ǹ kɑɑ sun kɔ̃sɑ ɡɑɑ kuɑ nɡe mɛ sɑ nun ɡeɑ kuɑ sɑ derɑ ɑ doonɑ kɑ bɔri yɛndu bɛsɛn min di. Wee tɛ̃ Yinni Gusunɔ u nun domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Mɑ Isɑki u bu yɑɑrɛ kuɑ, bɑ di bɑ nɔrɑ mɑ bɑ kpunɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Yerɑ bɑ seewɑ buru buru yellu bɑ ɑrukɑwɑni ye bɔkuɑ kɑ bɔ̃ri. Mɑ Isɑki u derɑ bɑ doonɑ kɑ ɑlɑfiɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Yen tɔ̃ɔ terɑ Isɑkin yobu bɑ nɑ bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ bɑ nim wɑ dɔkɔ ye bɑ ɡbɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Mɑ u dɔkɔ ye yĩsiru kɑ̃ Sebɑ. Yen tubusiɑnɑ Nɔɔ mwɛɛru. Yen sɔ̃nɑ bɑ kɑ wuu ɡe sokumɔ Beri Sebɑ sere kɑ ɡisɔn ɡisɔ. Yen tubusiɑnɑ nɔɔ mwɛɛrun dɔkɔ. ");
INSERT INTO bba_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esɑu u mɔwɑ wɔ̃ɔ weeru u kɑ kurɔbu yiru suɑ. Berɑ Yuditi, Berin bii, kɑ Bɑsimɑti, Elonin bii. Be kpuro bɑ sɑ̃ɑwɑ Hɛtibɑ. ");
INSERT INTO bba_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Adɑmɑ kurɔ be, bɑ Isɑki kɑ Rebekɑ nuki sɑnkɑ to. ");
INSERT INTO bba_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Sɑnɑm mɛ Isɑki u tɔkɔ kuɑ, win nɔni dɑm dwiiyɑ, u ǹ mɑɑ yɑm wɑɑmɔ, mɑ u win bii yerumɑ sokɑ u nɛɛ, Esɑu. Esɑu u nɛɛ, nɛ wee. ");
INSERT INTO bba_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Mɑ Isɑki u nɛɛ, wee nɑ tɔkɔ kuɑ, nɑ ǹ mɑɑ nɛn ɡɔɔn tɔ̃ru yɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Yen sɔ̃, nɑ nun kɑnɑmɔ tɛ̃, ɑ seewo ɑ wunɛn sɛ̃ɛ bwɑ̃ɑru kɑ wunɛn tɛndu suɑ ɑ dɑ yɑkɑsɔ ɑ mɑn yɑɑ ɡoowɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Kpɑ ɑ kɑ mɑn ye yɑɑ dibu kuɑ nɡe mɛ nɑ rɑ kɑ̃ ɑ kɑ mɑn nɑɑwɑ n di kpɑ n nun domɑru kuɑ n sere ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Mɑ Esɑu u seewɑ u dɑ yɑkɑsɔ u kɑ ɡbeeku yɑɑ ye ɡoomɑ. N deemɑ Rebekɑ u nɔɔmɔ ye Isɑki u win bii Esɑu sɔ̃ɔmɔ. ");
INSERT INTO bba_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Yerɑ u win bii Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, wee nɑ nuɑ wunɛn bɑɑ u wunɛn mɔɔ Esɑu sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","u doo u nùn yɑɑ ɡoowɑmɑ kpɑ u kɑ nùn ye yɑɑ dibu kuɑ u di kpɑ u nùn domɑru kuɑ Yinni Gusunɔn wuswɑɑɔ u sere ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tɛ̃ nɛn bii, ɑ nɛn ɡɑri nɔɔwɔ yi kon nun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","A doo boo ɡɔ̃rɔ ɑ mɑn boo binu yiru tɑmɑ ni nu wɑ̃ kpɑ n nu wunɛn bɑɑbɑ kuɑ nɡe mɛ u rɑ kɑ̃, ");
INSERT INTO bba_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","kpɑ ɑ kɑ nùn dɑɑwɑ u di, kpɑ u nun domɑru kuɑ u sere ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yɑkɔbu u win mɛro wisɑ u nɛɛ, wee, nɛn mɔɔ u sɑnsu mɔ ɑdɑmɑ nɛnɑ kun mɔ. ");
INSERT INTO bba_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","À ku tubɑ, nɛn bɑɑbɑ koo mɑn bɑbɑ kpɑ n ko wee kowo win mi. Kpɑ domɑ te nɑ kĩ mi, tu ko bɔ̃ri. ");
INSERT INTO bba_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Win mɛro nùn sɔ̃ɔwɑ u nɛɛ, nɛn bii, ɑ de bɔ̃ri yi, yi wɔri nɛn wirɔ. A ɡesi nɛn ɡɑri nɔɔwɔ kpɑ ɑ mɑn boo ni tɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Mɑ Yɑkɔbu u dɑ u kɑ boo ni nɑ u win mɛro wɛ̃. U kɑ yɑɑ dibu kuɑ bi Isɑki u rɑ kɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Yen biru u win bii ɡbiikoo Esɑun tɔ̃ɔ bɑkɑ yɑ̃nu suɑ ni nu wɑ̃ɑ dirɔ u nu Yɑkɔbu sebusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Mɑ u nùn boo bii nin ɡɔni tɛ̃kusi win nɔmɑɔ kɑ win wĩirɔ, domi u ǹ sɑnsu mɔ. ");
INSERT INTO bba_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Mɑ u dĩɑ duro ni kɑ pɛ̃ɛ ye u kuɑ win bii Yɑkɔbu nɔmu bɛriɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Sɑɑ yerɑ Yɑkɔbu u kɑ nu dɑ win tundon mi, u nɛɛ, bɑɑbɑ. Mɑ tundo u wurɑ u nɛɛ, nɛ wee, wunɑ were nɛn bii. ");
INSERT INTO bba_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yɑkɔbu u win tundo wisɑ u nɛɛ, nɛnɑ Esɑu, wunɛn bii yerumɑ. Wee, nɑ kuɑ nɡe mɛ ɑ ɡeruɑ. A seewo ɑ sinɑ ɑ nɛn tɑɑsorun yɑɑ tem, kpɑ ɑ mɑn domɑ te kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Mɑ Isɑki u nùn bikiɑ u nɛɛ, ɑmɔnɑ ɑ kɑ ye wɑ fuuku mɛ, nɛn bii. Yɑkɔbu u nùn wisɑ u nɛɛ, Gusunɔ wunɛn Yinniwɑ u mɑn ye ɡɑwɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Mɑ Isɑki u nɛɛ, ǹ n mɛn nɑ, ɑ susimɑ nɛn bii, n nun bɑbɑ n wɑ ɑ̀ n sɑ̃ɑ Esɑun nɑ kɑ ɡem. ");
INSERT INTO bba_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yɑkɔbu u susi win bɑɑbɑ Isɑkin mi, mɑ u nùn bɑbɑ u nɛɛ, Yɑkɔbun nɔɔwɑ nɑ nɔɔmɔ, ɑdɑmɑ Esɑun nɔmɑ nɑ bɑbɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","U ǹ nùn tubɑ yèn sɔ̃ win nɔmɑ sɑnsu mɔ nɡe Esɑuɡiɑ. Adɑmɑ ye u kĩ u nùn domɑru kuɑ, ");
INSERT INTO bba_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","u ɡinɑ nɛɛ, wunɑ nɛn bii Esɑu kɑ ɡem? U wisɑ u nɛɛ, oo, nɛnɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Isɑki u nɛɛ, ɑ kɑ susimɑ n wunɛn tɑɑsorun yɑɑ tem kpɑ n nun domɑru kuɑ. Yɑkɔbu u kɑ susi win mi, mɑ u di. U mɑɑ tɑm suɑ u nùn wɛ̃ mɑ u nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Yen biru Isɑki u nùn sɔ̃ɔwɑ u nɛɛ, ɑ susimɑ ɑ mɑn sɔ̃su, nɛn bii. ");
INSERT INTO bba_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Yɑkɔbu u susi u nùn sɔ̃su. Isɑki u win yɑ̃nun nuburu nuɑ mɑ u nùn domɑru kuɑ u nɛɛ, wee nɛn biin nuburɑ kɑ ɡberun nuburu weenɛ te Yinni Gusunɔ u domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Gusunɔ u de ɡurɑ yɑ n dɑ nun nɛɛyɛ tem bɑrukɑɡim sɔɔ, kpɑ ɑ ɑlikɑmɑ kɑ resɛm wɑ n kpɛ̃ɑ n bɑndɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tɔn dɑbinu nu nun wiru kpĩiyɑ, kpɑ bwese dɑbinu nu nun yiirɑ. Kpɑ ɑ ko wunɛn mɛro bisibun yinni, kpɑ ben tii bu nun yiirɑ. Wi u nun bɔ̃rusi u koo bɔ̃ri wɑ. Wi u mɑɑ nun domɑru kuɑ, yɛ̃ro koo domɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Ye Isɑki u Yɑkɔbu domɑru kuɑ u kpɑ, sɑnɑm mɛ Yɑkɔbu u doonɑ kese, yerɑ win mɔɔ Esɑu u wurɑmɑ tɑɑsorun di. ");
INSERT INTO bba_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Mɑ u dĩɑnu kuɑ u kɑ dɑ win tundon mi, u nùn sɔ̃ɔwɑ u nɛɛ, bɑɑbɑ, ɑ seewo ɑ nɛn tɑɑsorun yɑɑ tem kpɑ ɑ mɑn domɑ te kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Win tundo Isɑki u nùn bikiɑ u nɛɛ, wunɑ were. U nɛɛ, nɛnɑ Esɑu wunɛn bii yerumɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Mɑ Isɑki u diirɑ ɡem ɡem u nɛɛ, ǹ n mɛn nɑ, wɑrɑ u mɑn ɡbeeku yɑɑ tɑmɑ nɑ temɑ ɑ sere tunumɑ, nɑ mɑɑ nùn domɑru kuɑ. Yɛ̃ro koo mɑɑ bɑrukɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Ye Esɑu u ɡɑri yi nuɑ win tundon nɔɔn di, yerɑ u wurɑ kuɑ kɑ nuku sɑnkirɑ bɑkɑnu, mɑ u win tundo sɔ̃ɔwɑ u nɛɛ, bɑɑbɑ, ɑ mɑɑ nɛn tii domɑru kuo. ");
INSERT INTO bba_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Isɑki u nɛɛ, wunɛn wɔnɔ u nɑ u wunɛn domɑru mwɑ kɑ bwisi. ");
INSERT INTO bba_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esɑu u nɛɛ, wee u mɑn tɑki di nɔn yiru nɡe mɛ win yĩsiru. U mɑn nɛn yerumɑru mwɑɑri. Gisɔ u mɑɑ nɛn domɑru mwɑ. A ǹ mɑɑ domɑru ɡɑru mɔ ɑ mɑn kuɑ? ");
INSERT INTO bba_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isɑki u nùn wisɑ u nɛɛ, wee nɑ nùn kuɑ wunɛn yinni, nɑ mɑɑ nùn win mɛro bisibu kpuro wɛ̃ bu ko win yobu. Nɑ mɑɑ sii dĩɑnu kɑ dɑ̃ɑ bii ni bɑ rɑ kɑ tɑm ko kpuron domɑru kuɑ. Ǹ n mɛn nɑ, mbɑ kon kpĩ n mɑɑ nun kuɑ, nɛn bii. ");
INSERT INTO bba_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esɑu u nɛɛ, ǹ n mɛn nɑ, domɑ teni tɔnɑwɑ ɑ mɔ, bɑɑbɑ? A mɑɑ mɑn domɑru kuo. Mɑ u wurɑ nɔɔ kpɛ̃ɛ u swĩ. ");
INSERT INTO bba_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Win tundo Isɑki u nùn sɔ̃ɔwɑ u nɛɛ, wee ye kon nun sɔ̃. Wunɛn tem kun bɑrukɑ wɑsi. Mɛyɑ ɡurɑ kun mɑɑ nɛmɔ wunɛn mi. Wunɛn tɑkobin ɑreyɑ kɑɑ n dimɔ ɑ n kɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Kɑɑ mɑɑ ko wunɛn wɔnɔn yoo. Adɑmɑ ɑ̀ n dɑ kɑ tii yinɑ, kɑɑ win yoru yɑri nɡe mɛ kɛtɛ yɑ rɑ yen suɡu fɛ̃re yu kɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Sɑɑ dɔmɑ ten diyɑ Esɑu u Yɑkɔbu tusɑ domɑ te ben tundo nùn kuɑn sɔ̃. Mɑ u ɡeruɑ win tii sɔɔ u nɛɛ, nɛn bɑɑbɑn ɡɔɔ turuku kuɑ. Win ɡɔɔ ɡbɑbu sindun biruwɑ kon nɛn wɔnɔ ɡo. ");
INSERT INTO bba_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Bɑ Rebekɑ ɡɑri yi dɔmɛyɑ yi win bii ɡbiikoo Esɑu u ɡeruɑ. Mɑ u win bii dɑ̃ɑko Yɑkɔbu sokusiɑ u nùn sɔ̃ɔwɑ u nɛɛ, n wee, wunɛn mɔɔ u kĩ u win mɔru kɔsiɑ u nun ɡo. ");
INSERT INTO bba_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tɛ̃ nɛn bii, ɑ nɛn ɡɑri swɑɑ dɑkio. A seewo ɑ kpikiru dɑ nɛn sesu Lɑbɑnin mi Hɑrɑniɔ. ");
INSERT INTO bba_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Kpɑ ɑ sinɑ mi sɔ̃ɔ mɛɛru ɡɑɑ sere wunɛn mɔɔn bwɛ̃rɑ yɑ̀ n kpunɑ. ");
INSERT INTO bba_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Win mɔru yɑ̀ n sɑrɑ wunɛn min di, u koo duɑri ye ɑ nùn kuɑ. Sɑnɑm mɛyɑ kon de ɑ ɡɔsirɑmɑ. Domi nɑ ǹ kĩ n bɛɛ yiru kpuro biɑ sɔ̃ɔ teeru. ");
INSERT INTO bba_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Yerɑ Rebekɑ u dɑ u Isɑki sɔ̃ɔwɑ u nɛɛ, nɑ kɑ nɛn wɑ̃ɑru wɑsirɑ Esɑun kurɔ benin dɑɑn sɔ̃, be bɑ sɑ̃ɑ Hɛtibɑ. Yɑkɔbu ù n mɑɑ kurɔ suɑ tem mini nɡe be, mbɑn wɑ̃ɑrɑ ko nɑ n mɑɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yerɑ Isɑki u Yɑkɔbu sokɑ u nùn domɑru kuɑ, mɑ u nùn sɔ̃ɔwɑ u nɛɛ, ɑ ku rɑ ko ɑ Kɑnɑni minin kurɔ suɑ. ");
INSERT INTO bba_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Yen sɔ̃, ɑ seewo ɑ dɑ Pɑdɑnɑrɑmuɔ, Bɛtuɛli wunɛn mɛron bɑɑbɑn yɛnuɔ kpɑ ɑ kurɔ suɑ mi, Lɑbɑni wunɛn dwɑɑnin bibu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kpɑ Gusunɔ Dɑm kpuroɡii u nun domɑru kuɑ, ɑ mɑrurɑ ɑ tɛriɑ ɑ kɑ ko bwese dɑbinun nuuru. ");
INSERT INTO bba_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Kpɑ u nun domɑru kuɑ wunɛ kɑ wunɛn bibun bweseru nɡe mɛ u Aburɑhɑmu kuɑ, kpɑ tem mɛ, mu ko wunɛɡim mi ɑ sɔru dimɔ, mɛ Gusunɔ u Aburɑhɑmu kɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Isɑki u derɑ Yɑkɔbu u dɑ Pɑdɑnɑrɑmu ɡiɑ Lɑbɑnin mi, wi u sɑ̃ɑ Bɛtuɛli Arɑmuɡiin bii, Yɑkɔbu kɑ Esɑun dwɑɑni. ");
INSERT INTO bba_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esɑu u wɑ mɑ Isɑki u Yɑkɔbu domɑru kuɑ mɑ u nùn ɡɔrɑ Pɑdɑnɑrɑmu ɡiɑ u win kurɔ kɑsu. U mɑɑ nuɑ mɑ sɑɑ ye u nùn domɑru kuɑmmɛ u nɛɛ, u ku rɑɑ kurɔ sue Kɑnɑnin bii tɔn kurɔbu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","U mɑɑ wɑ mɑ Yɑkɔbu u win bɑɑ kɑ win mɛron ɡɑri nuɑ mɑ u doonɑ Pɑdɑnɑrɑmu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Yerɑ u ɡiɑ mɑ Kɑnɑnin bii tɔn kurɔbun dɑɑ yɑ ǹ win bɑɑ wɛ̃remɔ. ");
INSERT INTO bba_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Mɑ u seewɑ u dɑ Isimɛɛlin mi, u win bii Mɑhɑlɑti, Nɛbɑyɔtun sesu suɑ kurɔ u doke kurɔ be u rɑɑ mɔ sɔɔ. Isimɛɛli wi, u sɑ̃ɑwɑ Aburɑhɑmun bii. ");
INSERT INTO bba_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yɑkɔbu u seewɑ sɑɑ Beri Sebɑn di u doonɑ Hɑrɑni ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","U turɑ yɑm ɡɑm. Miyɑ u sĩ domi sɔ̃ɔ u duɑ. Ye u kpunɑmɔ u kperu ɡɑru suɑ u tu wiru kpĩiri. ");
INSERT INTO bba_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Yerɑ u dosɑ u wɑ wee, sɛrɑ ɡɑɑ yɑ yɔ̃ temɔ mɑ yen wirɑ wɔllu ɡirɑri, mɑ u Gusunɔn ɡɔrɑdobɑ wɑ bɑ yɔɔmɔ bɑ sɑrɑmɑmɔ kɑ sɛrɑ ye. ");
INSERT INTO bba_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Yinni Gusunɔn tii u yɔ̃ yen wɔllɔ mɑ u kɑ nùn ɡɑri kuɑ u nɛɛ, nɛnɑ Gusunɔ, Aburɑhɑmu wunɛn debun Yinni kɑ Isɑkin Yinni. Tem mi ɑ kpĩ mi, wunɑ kon mu wɛ̃ kɑ sere mɑɑ wunɛn bibun bweseru. ");
INSERT INTO bba_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Wunɛn bibun bwese te, tɑ koo kowɑ nɡe yɑni sɛɛri kpɑ tu tɛriɑ tem mɛn ɡoonu nnɛ kpuro sɔɔ. Wunɛ kɑ wunɛn bibun bweserun min diyɑ hɑnduniɑn bwesenu kpuro nu koo domɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Wee nɑ wɑ̃ɑ kɑ wunɛ, ko nɑ n mɑɑ nun kɔ̃su yɑm kpuro mi ɑ dɔɔ kpɑ n mɑɑ kɑ nun wurɑmɑ tem mɛ sɔɔ. Domi nɑ ǹ nun derimɔ sere n kɑ ko nɡe mɛ nɑ nun sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yɑkɔbu u dom yɑndɑ mɑ u nɛɛ, Yinni Gusunɔ u wɑ̃ɑ mini kɑ ɡem. Nɑ ǹ dɑɑ mɑɑ yɛ̃ mɛ. ");
INSERT INTO bba_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Yerɑ bɛrum nùn mwɑ mɑ u nɛɛ, n wɑ̃ bu suunu mi nɑsiɑ. Gusunɔn yɛnuwɑ mini kɑ mɑɑ wɔllun duu yeru. ");
INSERT INTO bba_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Mɑ u seewɑ buru buru yellu u kpee te suɑ te u wiru kpĩiri mi, u ɡirɑ temɔ tu kɑ ko yĩreru. Mɑ u ten wɔllɔ ɡum wisi. ");
INSERT INTO bba_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","U yɑm mi yĩsiru kɑ̃ Betɛli. Yen tubusiɑnɑ Gusunɔn wɑ̃ɑ yeru. Adɑmɑ wuu ɡe ɡɑ wɑ̃ɑ mi, bɑ rɑ rɑɑ ɡu sokuwɑ Lusi. ");
INSERT INTO bba_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yen biru u nɔɔ mwɛɛru kɑrɑ u nɛɛ, Gusunɔ ù n kɑ mɑn wɑ̃ɑ, mɑ u mɑn kɔ̃su nɛn sɑnum mɛ sɔɔ, mɑ u mɑn dĩɑnu wɛ̃ kɑ yɑ̃ɑ ni kon sebe, ");
INSERT INTO bba_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","kpɑ n ɡɔsirɑ nɛn bɑɑbɑn yɛnuɔ kɑ ɑlɑfiɑ, wiyɑ ko n sɑ̃ɑ nɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Kpee te nɑ ɡirɑ mini, tɑ kuɑ yĩreru mɑ miyɑ n ko n ko win wɑ̃ɑ yeru. Ye u mɑɑ mɑn wɛ̃ kpuron wɔkuru bɑɑteren wɔllɔ kon nùn tiɑ tiɑ wesiɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Mɑ Yɑkɔbu u seewɑ u win sɑnum wɔri u dɑ sɔ̃ɔ yɑri yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Ye u Hɑrɑni turuku tiɑ, yerɑ u mɛɛrɑ u dɔkɔ ɡɑɑ wɑ yɑkɑsɔ. U wɑ wee, yɑ̃ɑ ɡɔ̃su ɡɑsu itɑ yɑ kpĩ yɑ wɛ̃rɑmɔ dɔkɔ yen bɔkuɔ, domi miyɑ bɑ rɑ yɑɑ sɑbenu nim kɛ̃ nu nɔ. Kpee te bɑ mɑɑ kɑ dɔkɔ yen nɔɔ wukiri tɑ kpɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Miyɑ yɑɑ sɑbenu kpuro rɑ mɛnnɛ, kpɑ bu kpee te swɛnyɑ dɔkɔn nɔɔn di bu nu nim kɛ̃, kpɑ bu kpɑm wure bu dɔkɔ ye wukiri kɑ kpee te. ");
INSERT INTO bba_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yɑkɔbu u yɑ̃ɑ nin kpɑrobu bikiɑ u nɛɛ, kpɑɑsibu, sɑɑ mɑn diyɑ i nɑ. Bɑ nùn wisɑ bɑ nɛɛ, bɛsɛ Hɑrɑniɡibɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","U bu bikiɑ u nɛɛ, i Lɑbɑni Nɑkorin bii yɛ̃? Bɑ nɛɛ, oo, sɑ nùn yɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Mɑ u nɛɛ, u sere bwɑ̃ɑ do? Bɑ nɛɛ, oo, u ɑlɑfiɑ mɔ. A ǹ mɑm win bii Rɑsɛli wɑ u wee mini kɑ win yɑ̃ɑnu? ");
INSERT INTO bba_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yɑkɔbu u nɛɛ, wee sɔ̃ɔ kpɑ̃, sɑɑ kun turɑ ɡinɑ i kɑ yɑɑ sɑbenu mɛnnɑ. I nu nim kɛ̃ɛyɔ kpɑ i kpɑm dɑ i nu kpɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Bɑ nùn wisɑ bɑ nɛɛ, sɑ ǹ kpɛ̃ sere yɑ̃ɑ ɡɔ̃su kpuro sù n mɛnnɑ. Sɑnɑm mɛyɑ sɑ rɑ kpee te swɛnyɛ dɔkɔn nɔɔn di su sere yɑ̃ɑnu nim kɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Sɑɑ ye u kɑ bu ɡɑri mɔ̀ mi, yerɑ Rɑsɛli u tunumɑ kɑ win tundon yɑ̃ɑnu, domi wiyɑ u sɑ̃ɑ nin kpɑro. ");
INSERT INTO bba_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Ye Yɑkɔbu u win dwɑɑni Lɑbɑnin bii Rɑsɛli wɑ kɑ win yɑ̃ɑ ɡɔ̃ɔ, u susi u kpee te swɛnyɑ dɔkɔn nɔɔn di mɑ u yɑ̃ɑ ni nim kɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Mɑ u Rɑsɛli tɔburɑ u nùn sɔ̃su. Mɑ durɔ wurɑ nɔɔ kpɛ̃ɛ u swĩ nuku dobun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","U Rɑsɛli sɔ̃ɔwɑ u nɛɛ, sɑ sɑ̃ɑwɑ dusinu. Domi nɛ Rebekɑn biiwɑ. Mɑ Rɑsɛli u dukɑ dɑ u win tundo ɡɑri yi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Ye Lɑbɑni u win dwɑɑnibu Yɑkɔbun lɑbɑɑri nuɑ, u dukɑ nɑ u nùn sennɑ. U nùn tɔburɑ u nùn bɔkɑsi u sɔ̃su, mɑ u kɑ nùn dɑ yɛnuɔ. Mɑ Yɑkɔbu u Lɑbɑni sɔ̃ɔwɑ kpuro ye u kɑ sĩimɔ. ");
INSERT INTO bba_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Yerɑ Lɑbɑni u nɛɛ, kɑ ɡem nɛ kɑ wunɛ yɛm temɑ. Mɑ Yɑkɔbu u sinɑ Lɑbɑnin mi suru tiɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yen biru Lɑbɑni u Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, kɑɑ mɑn sɔmburu kuɑ kɑm yèn sɔ̃ ɑ sɑ̃ɑ nɛn dusi? A mɑn sɔ̃ɔwɔ nyen nɑ kɑɑ mɑn mwɑɑri. ");
INSERT INTO bba_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","N deemɑ Lɑbɑni u bii tɔn kurɔbu yiru mɔ. Gbiikoon yĩsirɑ Leɑ, wɔnɔɡirɑ mɑɑ Rɑsɛli. ");
INSERT INTO bba_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Leɑn nɔni kun dɑm mɔ, ɑdɑmɑ Rɑsɛli kurɔ burɔwɑ, win wɑsi kɑ win wuswɑɑ yɑ ɡirimɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yɑkɔbu u Rɑsɛli kĩ. Mɑ u Lɑbɑni sɔ̃ɔwɑ u nɛɛ, kon nun sɔmburu kuɑ sere wɔ̃ɔ nɔɔbɑ yiru wunɛn bii Rɑsɛlin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Mɑ Lɑbɑni u nɛɛ, yɑ wɑ̃. N burɑm bo n nun wi kɛ̃, ye kon kɑ nùn durɔ ɡoo kɛ̃. Ǹ n mɛn nɑ, ɑ kɑ mɑn sinɔ. ");
INSERT INTO bba_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yerɑ n derɑ Yɑkɔbu u sɔmburu kuɑ wɔ̃ɔ nɔɔbɑ yiru Lɑbɑnin mi. Mɑ n nùn kuɑ nɡe sɔ̃ɔ yiru yèn sɔ̃ u Rɑsɛli kĩ. ");
INSERT INTO bba_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yen biru u Lɑbɑni sɔ̃ɔwɑ u nɛɛ, ɑ mɑn nɛn kurɔ wɛ̃ɛyɔ kpɑ n nùn yɛnu doke, domi nɛn tɔ̃rɑ yibɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Yerɑ Lɑbɑni u win wɔɔ berɑn tɔmbu mɛnnɑ kpuro mɑ u tɔ̃ɔ bɑkɑ dim kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Ye n kuɑ yokɑ, u win bii Leɑ suɑ u Yɑkɔbu duusiɑ mɑ bɑ mɛnnɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Mɑ u win yoo tɔn kurɔ Silipɑ suɑ u win bii Leɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Sisiru bururu, wee Yɑkɔbu deemɑ Leɑwɑ. Mɑ u Lɑbɑni sɔ̃ɔwɑ u nɛɛ, mbɑn bweserɑ ɑ mɑn kuɑ mɛni. N ǹ Rɑsɛlin sɔ̃nɑ nɑ nun sɑ̃wɑ ro? Mbɑn sɔ̃nɑ ɑ mɑn weesu kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Lɑbɑni u nɛɛ, n ǹ bɛsɛn komɑru bu wɔnɔ kurɔ kpɑɑru suɑ kpɑ mɔɔ u n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","A ɡinɑ kurɔ kpɑɑrun sɔ̃ɔ nɔɔbɑ yiru dɑkuro kɑ Leɑ. Yen biru sɑ ko mɑɑ nun wiɔnɔ wɛ̃. Kpɑ ɑ kpɑm mɑn sɔmburu kuɑ wɔ̃ɔ nɔɔbɑ yiru win sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Mɑ Yɑkɔbu u kuɑ nɡe mɛ. U sɔ̃ɔ nɔɔbɑ yiru ye dɑkurɑ kɑ Leɑ. Yen biru Lɑbɑni u nùn win bii Rɑsɛli kɑ̃ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Mɑ u mɑɑ win yoo tɔn kurɔ Bilihɑ suɑ u win bii Rɑsɛli wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yɑkɔbu u kɑ Rɑsɛli mɛnnɑ, u nùn kĩɑ n kere Leɑ. Mɑ u kpɑm Lɑbɑni sɔmburu kuɑ wɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ye Yinni Gusunɔ u wɑ mɑ Yɑkɔbu u ǹ Leɑ kĩ, mɑ u derɑ Rɑsɛli u kuɑ wĩro mɑ u Leɑ kuɑ bii mɛro. ");
INSERT INTO bba_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","U ɡurɑ suɑ u bii tɔn durɔ mɑrɑ mɑ u nùn yĩsiru kɑ̃ Rubɛni, u nɛɛ, Yinni Gusunɔ u wɑ mɑ bɑ mɑn ɡɛmɑ. Tɛ̃ nɛn durɔ u koo mɑn kĩɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yen biru u mɑɑ ɡurɑ suɑ u bii tɔn durɔ mɑrɑ mɑ u nɛɛ, Yinni Gusunɔ u nuɑ mɑ bɑ ǹ mɑn kĩ. Yerɑ u kɑ kpɑm mɑn wini kɑ̃. Yerɑ bɑ nùn yĩsiru kɑ̃ Simɛɔ. ");
INSERT INTO bba_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Simɛɔn biru u mɑɑ ɡurɑ suɑ u bii tɔn durɔ mɑrɑ, mɑ bɑ nùn yĩsiru kɑ̃ Lefi. Yerɑ u nɛɛ, tɛ̃rɑ nɛn durɔ u koo mɑn tii ɡɑwe, domi nɑ nùn bii tɔn durɔbu itɑ mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Lefin biru u mɑɑ ɡurɑ suɑ u bii tɔn durɔ mɑrɑ, mɑ u nɛɛ, tɛ̃ kon Yinni Gusunɔ siɑrɑ. Yen sɔ̃nɑ u bii wi yĩsiru kɑ̃ Yudɑ. Yen biru u ɡinɑ mɑrubu yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ye Rɑsɛli u deemɑ u ǹ kɑ Yɑkɔbu mɑrumɔ, yerɑ u kɑ win mɔɔ nisinu seewɑ. Mɑ u Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, ɑ de n kɑ nun mɑ. Mɑ n kun mɛ, kon ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yerɑ Yɑkɔbu u kɑ Rɑsɛli mɔru bɛsirɑ u nùn sɔ̃ɔwɑ u nɛɛ, nɛnɑ Gusunɔ n kɑ nun yinɑri ɑ mɑ? ");
INSERT INTO bba_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rɑsɛli u nɛɛ, too, yɑ ǹ tɑɑrɛ, nɛn yoo Bilihɑ wee, ɑ kɑ duo kpɑ n bibu wɑ sɑɑ win min di n tɑɑru sɔndi, kpɑ sɑ n wɑ̃ɑsinɛ. ");
INSERT INTO bba_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Mɑ u win yoo Bilihɑ suɑ u Yɑkɔbu wɛ̃ kurɔ. Yɑkɔbu u kɑ nùn mɛnnɑ, ");
INSERT INTO bba_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","yerɑ u ɡurɑ suɑ u Yɑkɔbu bii tɔn durɔ mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Rɑsɛli u nɛɛ, Gusunɔ u nɛn kɑnɑru nuɑ mɑ u mɑn siriɑ mɑ u mɑn bii tɔn durɔ kɑ̃. Yen sɔ̃nɑ u bii wi yĩsiru kɑ̃ Dɑnu. ");
INSERT INTO bba_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Dɑnun biru Bilihɑ u mɑɑ ɡurɑ suɑ mɑ u Yɑkɔbu bii tɔn durɔ mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rɑsɛli u nɛɛ, nɑ kɑ nɛn mɔɔ ɡɑbirinɑ ɡem ɡem nɑ nùn kɑmiɑ. Mɑ u bii wi yĩsiru kɑ̃ Nɛfitɑli. ");
INSERT INTO bba_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Sɑɑ ye Leɑ u deemɑ u mɑrubu yɔ̃rɑ, yerɑ u win yoo Silipɑ suɑ u Yɑkɔbu wɛ̃ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Mɑ Silipɑ u ɡurɑ suɑ u Yɑkɔbu bii tɔn durɔ mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leɑ u nɛɛ, ɑnnɑ ɑ nɛn wii dobu wɑ! Mɑ u nùn yĩsiru kɑ̃ Gɑdi. ");
INSERT INTO bba_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Gɑdin biru Silipɑ u kpɑm ɡurɑ suɑ u Yɑkɔbu bii tɔn durɔ mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Yerɑ Leɑ u nɛɛ, doo nɔɔruɡiiwɑ nɑ sɑ̃ɑ, domi tɔn kurɔbu bɑ koo mɑn soku doo nɔɔruɡii. Mɑ u nùn yĩsiru kɑ̃ Asɛɛ. ");
INSERT INTO bba_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Sɔ̃ɔ teeru doo ɡɛ̃ɛrun sɑɑ sɔɔ, yerɑ Rubɛni u seewɑ u dɑ yɑkɑsɔ u dɑ̃ɑ te bɑ sokumɔ mɑndɑrɑɡoren binu sɔrimɑ u kɑ win mɛro Leɑ wɔmɑ. Sɑɑ yerɑ Rɑsɛli u Leɑ sɔ̃ɔwɑ u nɛɛ, ɑ suuru koowo, ɑ mɑn wunɛn biin dɑ̃ɑ bii ni sɔko. ");
INSERT INTO bba_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leɑ u nùn wisɑ u nɛɛ, ye ɑ mɑn nɛn durɔ mwɑɑri n ǹ nun turɑ? Yerɑ ɑ kpɑm kĩ ɑ mɑn nɛn biin dɑ̃ɑ binu mwɑɑri? Rɑsɛli nɛɛ, ɑ suuru koowo, kon de bɛsɛn durɔ u kɑ nun du yokɑ ye, wunɛn biin dɑ̃ɑ bii nin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ye n kuɑ yokɑ Yɑkɔbu u ɡberun di wee, yerɑ Leɑ u seewɑ u dɑ u kɑ nùn yinnɑ mɑ u nɛɛ, nɛnɑ kɑɑ kɑ du ɡisɔ, domi nɛn biin mɑndɑrɑɡoren binɑ nɑ kɑ nun dwɑ. Mɑ Yɑkɔbu u kɑ nùn duɑ dɔmɑ te. ");
INSERT INTO bba_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Mɑ Gusunɔ u Leɑn kɑnɑru mwɑ, u ɡurɑ suɑ u Yɑkɔbu bii tɔn durɔ nɔɔbuse mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yerɑ u nɛɛ, Gusunɔ u mɑn nɛn ɑre wɛ̃, yèn sɔ̃ nɑ derɑ nɛn durɔ u nɛn yoo suɑ kurɔ. Mɑ u bii wi yĩsiru kɑ̃ Isɑkɑri. ");
INSERT INTO bba_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Isɑkɑrin biru Leɑ u kpɑm ɡurɑ suɑ u Yɑkɔbu bii tɔn durɔ nɔɔbɑ tiɑse mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Mɑ u nɛɛ, Gusunɔ u mɑn kɛ̃ɛ ɡeeru kɑ̃. Tɛ̃ nɛn durɔ u koo mɑn tii ɡɑwe u mɑn bɛɛrɛ doke yèn sɔ̃ nɑ nùn bii tɔn durɔbu nɔɔbɑ tiɑ mɑruɑ. Mɑ u bii wi yĩsiru kɑ̃ Sɑbuloni. ");
INSERT INTO bba_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Yen biru u bii tɔn kurɔ mɑrɑ mɑ u nùn sokɑ Dinɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Gusunɔ u mɑɑ Rɑsɛlin tii yɑɑye u win kɑnɑru mwɑ mɑ u nùn kuɑ bii mɛro. ");
INSERT INTO bba_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","U ɡurɑ suɑ u bii tɔn durɔ mɑrɑ mɑ u nɛɛ, Gusunɔ u mɑn sekuru yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Yerɑ u bii wi yĩsiru kɑ̃ Yosɛfu. U nɛɛ, kpɑ Yinni Gusunɔ u kpɑm mɑn bii tɔn durɔ sosiɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Sɑɑ ye Rɑsɛli u Yosɛfu mɑrɑ, yen biruwɑ Yɑkɔbu u Lɑbɑni sɔ̃ɔwɑ u nɛɛ, ɑ den mɑn kɑro mɛ, n we nɛn temɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Kpɑ ɑ de n kɑ nɛn kurɔbu kɑ nɛn bibu dɑ bèn sɔ̃ nɑ nun sɑ̃wɑ. A mɑɑ yɛ̃ kɔ mɛ̀n nɔɔ nɑ nun sɔmburu kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Mɑ Lɑbɑni u nùn wisɑ u nɛɛ, ɑ suuru koowo, ɑ de ɑ yɔ̃rɑ ɡinɑ. Domi nɑ wɑ mɑ wunɛn sɔ̃nɑ Gusunɔ u mɑn domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Yen sɔ̃, ɑ mɑn sɔ̃ɔwɔ nyen nɑ n weenɛ n nun kɔsiɑ, kpɑ n nun wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yerɑ Yɑkɔbu u nùn wisɑ u nɛɛ, wunɛn tii ɑ yɛ̃ nɡe mɛ̀n nɔɔ nɑ nun sɑ̃wɑ. A mɑɑ wɑ nɡe mɛ̀n nɔɔ wunɛn yɑ̃ɑ ɡɔ̃ɔ ɡɑ kuurɑ nɛn nɔmɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Domi yɑ̃ɑ ɡɔ̃ɔ piibuwɑ ɑ rɑɑ mɔ n sere tunumɑ wunɛn mi. Adɑmɑ ye nɑ tunumɑ, Yinni Gusunɔ u nun domɑru kuɑ mɑ ɡɑ kpɛ̃ɑ. Ǹ n mɛn nɑ, sɑɑ yerɑ̀ kɑɑ den mɑn yɔ̃su n nɛn tiin sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Mɑ Lɑbɑni u nùn wisɑ u nɛɛ, mbɑ kon nun wɛ̃. Yɑkɔbu u nɛɛ, nɑ ǹ kĩ ɑ mɑn ɡɑ̃ɑnu ɡɑnu wɛ̃. Ye kon nun sɔ̃ wee. À n wurɑ, ɑ de n kpɑm wunɛn yɑ̃ɑ ɡɔ̃ɔ ɡe suɑ n kpɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Gisɔ kon du wunɛn sɑbenu sɔɔ n mɛɛri mɛɛri n wɑ yɑ̃ɑnu kɑ bonu ni nu bɑusu mɔ kɑ yɑ̃ɑ nìn sɑnsu tĩri. Niyɑ kon ɡɔsi nɛnɛm nu n sɑ̃ɑ nɛn kɔsiɑru. ");
INSERT INTO bba_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Siɑrɑ ɡem mu koo sɔ̃ɔsirɑ sɑnɑm mɛ ɑ nɑ ɑ kɑ nɛn kɔsiɑru wɑ. Domi boo ni nu ǹ bɑusu mɔ kɑ yɑ̃ɑ ni nu ǹ tĩri nù n wɑ̃ɑ nɛɡinu sɔɔ, ɑ mɑn ɡɑrisio ɡbɛnɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Lɑbɑni u nùn wisɑ u nɛɛ, n kooro nɡe mɛ ɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Yen tɔ̃ɔ te, Lɑbɑni wi, u bonu kɑ yɑ̃ɑ ni nu bɑusu mɔ kɑ ni nu tĩri wunɑ u yi nɛnɛm mɑ u nu win bibu nɔmu bɛriɑ. ");
INSERT INTO bba_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yen biru u derɑ bɑ kɑ sɑbe ni tondɑ sɑɑ Yɑkɔbun min di nɡe sɔ̃ɔ itɑn sɑnum sɑkɑ. Mɑ Yɑkɔbu u ni nu tie kpɑrɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Sɑnɑm mɛ u nu kpɑrɑmɔ, yerɑ u dɑ̃nu ɡɑnun kɑ̃ɑsi beki burɑ u yin koro wɔrukisu yoruɑ yoruɑ nɡe mɛ bɑ rɑ kɑɑru yore. ");
INSERT INTO bba_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Mɑ u dɑ̃ɑ kɑ̃ɑsi yi suɑ u doke mi sɑbenu rɑ nim nɔ, domi miyɑ nu rɑ n yɔɔnɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Sɑnɑm mɛ, nù n yɔɔnɑ dɑ̃ɑ kɑ̃ɑsi yin bɔkuɔ, nu rɑ binu mɑwɑ ni nu bɑusu mɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yen biru Yɑkɔbu u ni nu tĩri kɑ ni nu bɑusu mɔ wunɑmɔ nɛnɛm u yiimɔ bee tiɑ nu ko wiɡinu. ");
INSERT INTO bba_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Ù n deemɑ yɑ̃ɑ dɑmɡinɑ nu yɔɔnɑmɔ, u rɑ dɑ̃ɑ kɑ̃ɑsi yi kɔ̃wɑ nin wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Adɑmɑ ù n wɑ ni nu ǹ ɡeɑ sɑ̃ɑ, niyɑ nu yɔɔnɑmɔ, u rɑ yi suewɑ min di kpɑ ni, nu n sɑ̃ɑ Lɑbɑniɡinu. ");
INSERT INTO bba_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Mɛyɑ Yɑkɔbu u kuɑ u kɑ dukiɑ wɑ yɑ kpɑ̃. U yɑ̃ɑnu kɑ bonu kɑ yooyoosu kɑ kɛtɛkunu kɑ yoo tɔn durɔbu kɑ tɔn kurɔbu mɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Sɔ̃ɔ teeru Yɑkɔbu u nuɑ Lɑbɑnin bibu bɑ ɡerumɔ bɑ mɔ̀, Yɑkɔbu u bɛsɛn tundon ɑrumɑni kpuro ɡurɑ mɑ u kuɑ dukiɑɡii. ");
INSERT INTO bba_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yen biru u wɑ mɑ Lɑbɑni kun mɑɑ nùn mɛɛrɑ nɡe yellu. ");
INSERT INTO bba_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Sɑɑ yerɑ Yinni Gusunɔ u Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, ɑ ɡɔsiro wunɛn bɑɑbɑn temɔ mi bɑ nùn mɑrɑ. Ko nɑ n kɑ nun wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Mɑ Yɑkɔbu u win kurɔbu Leɑ kɑ Rɑsɛli sokusiɑ bu nɑ win mi kpɑrɑ ɡberɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","U bu sɔ̃ɔwɑ u nɛɛ, nɑ wɑ bɛɛn bɑɑbɑ kun mɑɑ mɑn mɛɛrɑ nɡe yellu. Adɑmɑ Gusunɔ, nɛn bɑɑbɑn Yinni, u kɑ mɑn wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Bɛɛn tii i mɑɑ wɑ nɡe mɛ nɑ bɛɛn bɑɑbɑ sɔmburu kuɑ kɑ nɛn dɑm kpuro. ");
INSERT INTO bba_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Wee tɛ̃, u mɑn kɑm mɛɛrɑ, u nɛn kɔsiɑrun ɡɑri kɔsɑ sere nɔn wɔkuru. Adɑmɑ Gusunɔ kun dere u mɑn kɔ̃sɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Domi bɛɛn tundo wi, ù n nɛɛ, sɑbe ni nu bɑu bɑkɑsu mɔ niyɑ nu ko n sɑ̃ɑ nɛɡinu, ni kpurowɑ nu rɑ bɑu si ko. Ù n mɑɑ nɛɛ, ni nu bɑu piiminu mɔ, ni kpurowɑ nu rɑ ko mɛ. ");
INSERT INTO bba_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nɡe mɛyɑ Gusunɔ u kɑ bɛɛn tundon yɑ̃ɑ ɡɔ̃ɔ wɔrɑ u mɑn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Sɑɑ ye sɑbe ni, nu yɔɔnɑmɔ nɑ dosɑ. Dosu ɡe sɔɔ, nɑ nɔni seeyɑ wɔllɔ nɑ wɑ nin dwɑnu kpuro bɑusu mɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Mɑ Yinni Gusunɔn ɡɔrɑdo u mɑn sokɑ u nɛɛ, Yɑkɔbu! Yerɑ nɑ wurɑ nɑ nɛɛ, nɛ wee. ");
INSERT INTO bba_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","13","Mɑ u nɛɛ, wiyɑ Gusunɔ, wi, wi u mɑn kure Betɛliɔ mi nɑ kperu ɡirɑ nɑ ɡum wisi tɑ n kɑ sɑ̃ɑ yĩreru. Miyɑ nɑ mɑɑ nùn nɔɔ mwɛɛru kuɑ. Tɛ̃, n nɔni seeyo kpɑ n wɑ mɑ sɑbe nin dwɑnu kpuro bɑusu mɔwɑ. Domi u wɑ ye Lɑbɑni u mɑn kuɑ. Kpɑ n se tem minin di n wurɑ tem mi bɑ mɑn mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Rɑsɛli kɑ Leɑ bɑ nùn wisɑ bɑ nɛɛ, sɑ ǹ mɑɑ bɔnu ɡɑɑ mɔ bɛsɛn tundon mi. ");
INSERT INTO bba_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","U sun mɛɛrɑ nɡe sɔbu domi u sun dɔrɑ u bɛsɛn ɡobi di. ");
INSERT INTO bba_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Arumɑni ye Gusunɔ u nùn wɔrɑri yɑ mɑɑ kuɑ bɛsɛ kɑ bɛsɛn bibuɡiɑ. Ǹ n mɛn nɑ, ɑ koowo ye Gusunɔ u nun sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yen biru Yɑkɔbu u seewɑ u win kurɔbu kɑ win bibu yooyoosu sɔndi. ");
INSERT INTO bba_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Mɑ u win dukiɑ kpuro suɑ kɑ win sɑbe ni u wɑ Pɑdɑnɑrɑmuɔ. U swɑɑ wɔri u dɔɔ win tundo Isɑkin mi, Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Ye bɑ doonɔ, yerɑ Rɑsɛli u dɑ u win tundo Lɑbɑnin bũu wi bɑ mɔ̀ Terɑfimu ɡbɛnɑ. N deemɑ sɑɑ ye sɔɔ, Lɑbɑni u win yɑ̃ɑnun sɑnsu bɔɔrimɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Nɡe mɛyɑ Yɑkɔbu u kɑ Lɑbɑni nɔni wɔ̃kuɑ u doonɑ, u ǹ mɑɑ nùn ɡɑ̃ɑnu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","U win ye u mɔ kpuro ɡurɑ. Mɑ u dɑ u dɑɑ te bɑ mɔ̀ Efɑrɑti tɔburɑ u doonɑ Gɑlɑdin ɡuunu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Ye Yɑkɔbu u doonɑ, yen sɔ̃ɔ itɑserɑ bɑ nɑ bɑ Lɑbɑni sɔ̃ɔwɑ mɑ Yɑkɔbu u dukɑ suɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Mɑ Lɑbɑni u win tɔmbu suɑ bɑ Yɑkɔbu nɑɑ ɡirɑ. Sɔ̃ɔ nɔɔbɑ yiruwɑ bɑ kuɑ swɑɑ sɔɔ bɑ sere nùn nɑɑmwɛ Gɑlɑdin ɡuunɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","N deemɑ Gusunɔ u Lɑbɑni sɔ̃ɔwɑ dosu sɔɔ wɔ̃kuru u nɛɛ, ɑ tii lɑɑkɑri ko, ɑ ku rɑ Yɑkɔbu ɡɑ̃ɑnu ɡɑnu sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Ye u Yɑkɔbu nɑɑmwɛ mɛ, u deemɑ wee, u win kuu bekuruɡinu ɡire Gɑlɑdin ɡuu nin mi. Yerɑ bɑ mɑɑ beɡinu ɡirɑ mi, wi kɑ win tɔmbu. ");
INSERT INTO bba_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Yen biruwɑ u Yɑkɔbu bikiɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ mɑn kuɑ mɛ. A mɑn kɑm mɛɛrɑ ɑ kɑ nɛn bibu doonɑmɑ nɡe yoo be ɑ mwɛɛrimɑ tɑbu ɡberun di. ");
INSERT INTO bba_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Mbɑn sɔ̃nɑ ɑ dukɑ suɑ ɑsiri sɔɔ, ɑ ǹ mɑn nɔɔ kɑnɛ. À n dɑɑ mɑn sɔ̃ɔwɑ, kon de ɑ doonɑ kɑ nuku dobu bɑ n womusu mɔ̀, kpɑ bɑ n mɔrɔkunu kɑ ɡɑ̃ɑsu soomɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Wee, ɑ yinɑ n nɛn bibu kɑ nɛn debuminu nɔɔ kɑnɑ n bu bɔkɑsi ɑ sere doonɑ. Annɑ ɑ kɑ ɡɑri bɑkɑru kuɑ mɛ! ");
INSERT INTO bba_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Nɑ yiiko mɔ n kɑ nun kɔ̃sɑ kuɑ, ɑdɑmɑ Gusunɔ, wunɛn bɑɑbɑn Yinni, u mɑn sɔ̃ɔwɑ ɡĩɑ u nɛɛ, n lɑɑkɑri ko n ku rɑ nun ɡɑ̃ɑnu ɡɑnu sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Wee ɑ doonɔ wunɛn bɑɑbɑn yɛnuɔ ɡèn bɛkɛ ɑ rɑ n mɔ̀, ɑ ǹ mɑɑ wee mini. Adɑmɑ mbɑn sɔ̃nɑ ɑ nɛn bũu kpɛɛru ɡbɛnɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Mɑ Yɑkɔbu u Lɑbɑni wisɑ u nɛɛ, nɑ ǹ yɛ̃ ɑ̀ n kɑɑ rɑ mɑn wunɛn bibu wɔrɑri. Yen sɔ̃nɑ nɑ kuɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Adɑmɑ ɑ bũurio bɛsɛn sɔmunu sɔɔ tɔn beni kpuron wuswɑɑɔ. À n wunɛn ɡɑ̃ɑnu wɑ mi, kpɑ ɑ suɑ. Wìn mi ɑ wunɛn bũu kpɛɛru wɑ, kpɑ bu yɛ̃ro ɡo. N deemɑ Yɑkɔbu kun yɛ̃ mɑ win kurɔ Rɑsɛliwɑ u bũu kpɛɛ te ɡbɛnɑ u nɛni. ");
INSERT INTO bba_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Mɑ Lɑbɑni u duɑ Yɑkɔbun kuu bekuruɡirɔ kɑ Bilihɑɡirɔ kɑ Silipɑɡirɔ kɑ sere mɑɑ Leɑɡirɔ, ɑdɑmɑ u ǹ ɡɑ̃ɑnu wɑ. Ye u yɑrɑ Leɑn kurun di, mɑ u duɑ Rɑsɛliɡirɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Mɑ u kuu te bũurɑ u ǹ ɡɑ̃ɑnu wɑ. N deemɑ Rɑsɛli u bũu kpɛɛ te suɑ u doke win yooyoon ɡɑɑrin kɔkɔrɔ u sinɑri. ");
INSERT INTO bba_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Yerɑ u win tundo sɔ̃ɔwɑ u nɛɛ, ɑ ku kɑ mɑn mɔru ko, nɑ ǹ kpɛ̃ n se domi nɑ nɔmɑ nɛni. Lɑbɑni u win bũu kpɛɛ te kɑsu kuu te sɔɔ kpuro u ǹ wɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Sɑɑ yerɑ Yɑkɔbu u mɔru bɛsirɑ mɑ u kɑ Lɑbɑni sɑnnɔ wɔri u nɛɛ, torɑru mbɑ nɑ nun torɑri mɛ, ǹ kun mɛ kɔ̃sɑ yerɑ̀ nɑ nun kuɑ mɛ, ɑ kɑ mɑn nɑɑ ɡire kɑ dɑm. ");
INSERT INTO bba_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Sɑnɑm mɛ ɑ bɛsɛn yɑ̃nu bũurɑ mbɑ ɑ wɑ mi, ye yɑ sɑ̃ɑ wunɛn yɛnun ɡɑ̃ɑnu. A mɑn ye sɔ̃ɔsio nɛn tɔmbu kɑ wunɛɡibun wuswɑɑɔ, kpɑ bɑ n sɑ̃ɑ bɛsɛn seedɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Wee wɔ̃ɔ yɛndɑ nɑ kuɑ wunɛn mi. Wunɛn yɑ̃ɑnu ǹ kun mɛ wunɛn bonu yen ɡɑɑ kun nukuru yɑrire nɛn nɔmɑ sɔɔ. Mɛyɑ nɑ ǹ mɑɑ wunɛn yɑ̃ɑ ɡɔ̃ɔn di yɑ̃ɑ kinɛru ɡɑru suɑre n tem. ");
INSERT INTO bba_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Gbeeku yɑɑ yɑ̀ n wunɛn sɑberu ɡɑru ɡo, nɑ ku rɑ kɑ nun tu nɑɑwɛ. Nɛnɑ nɑ rɑ ten kɔsire wɛ̃. Ten te bɑ mɑɑ ɡbɛnɑ wɔ̃kuru ǹ kun mɛ sɔ̃ɔ sɔɔ, ɑ rɑ mɑn ten kɔsire bikiewɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Mɛyɑ nɑ rɑ n sɔ̃ɔ soore kpɑrɑ ɡberɔ, kpɑ wɔ̃kuru nɑ n wooru nɔrure, nɑ ǹ dweeyɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Nɡe mɛyɑ nɑ kuɑ sere wɔ̃ɔ yɛndu, nɑ nun sɔmburu kuɑwɑ wɔ̃ɔ wɔkurɑ nnɛ wunɛn bii tɔn kurɔbun sɔ̃, mɑ nɑ mɑɑ kuɑ wɔ̃ɔ nɔɔbɑ tiɑ yɑ̃ɑ ni kɑ boo nin sɔ̃. Kɑ mɛ, ɑ nɛn kɔsiɑrun ɡɑri ɡɔsiɑwɑ sere nɔn wɔkuru. ");
INSERT INTO bba_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Gusunɔ, wi, wi Aburɑhɑmu kɑ nɛn bɑɑbɑ Isɑki bɑ nɑsie ù kun dɑɑ kɑ mɑn wɑ̃ɑ, kɑɑ mɑn deriwɑ nɔm dirɑ. Wee, u nɛn wɔnwɔndu wɑ kɑ nɛn wɑhɑlɑ ye nɑ kuɑ. Yen sɔ̃nɑ u mɑn siriɑ ɡĩɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Yerɑ Lɑbɑni u nùn wisɑ u nɛɛ, wunɛn kurɔ be, bɑ sɑ̃ɑwɑ nɛn bibu. Bii beni bɑ mɑɑ sɑ̃ɑwɑ nɛn debuminu. Yɑ̃ɑ ɡɔ̃ɔ sini, su mɑɑ sɑ̃ɑwɑ nɛɡisu. Ye ɑ ɡesi wɑ mini kpuro nɛɡiɑ. Adɑmɑ nɑ ǹ kpɛ̃ n nɛn bibu kɑ nɛn debumii ni nɛnɛ. ");
INSERT INTO bba_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Yen sɔ̃ tɛ̃, ɑ de nɛ kɑ wunɛ su ɑrukɑwɑni bɔke kpɑ su yĩreru doke tɑ n sɑ̃ɑ yen seedɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Mɑ Yɑkɔbu u kperu suɑ u ɡirɑ yɑm mi, tɑ n kɑ sɑ̃ɑ yĩreru. ");
INSERT INTO bba_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Mɑ u win tɔmbu sɔ̃ɔwɑ u nɛɛ, i kpenu ɡurɑmɑ. Mɑ bɑ nu ɡurɑmɑ bɑ subɑ. Yen biru bɑ sinɑ bɑ di nin bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","48","Lɑbɑni u nɛɛ, kpee sube teni, tɑ sɑ̃ɑwɑ bɛsɛn seedɑ nɛ kɑ wunɛ. Yen sɔ̃nɑ ben bɑɑwure u yɑm mi yĩsiru kɑ̃ kɑ win bɑrum, Seedɑ yeru. ");
INSERT INTO bba_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Bɑ mɑɑ yɑm mi sokɑ Misipɑ domi Lɑbɑni u Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, Gusunɔ u bɛsɛn bɑɑwure ɡbɑrɑ su ku kɑ wɔrinɑ sɑ̀ n yɑrinɑ minin di. ");
INSERT INTO bba_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","À n nɛn bibu nɔni sɔ̃ɔmɔ, ǹ kun mɛ ɑ̀ n kurɔ kpɑo suɑ, n ǹ tɔnu koo sun siriɑ, Gusunɔwɑ koo sun siriɑ nɛ kɑ wunɛ. Yen sɔ̃, ɑ lɑɑkɑri ko. ");
INSERT INTO bba_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Kpee sube teni kɑ kpee te ɑ ɡirɑ mi, nu kuɑ seedɑ nɛ kɑ wunɛn bɑɑ sɔɔ. Mɛyɑ nɑ ǹ kpee ni sɑrɑmɔ n nun wɔri. A ku rɑ mɑɑ nu sɑrɑ ɑ mɑn wɔrimɑ. ");
INSERT INTO bba_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Sɑ̀ n kuɑ mɛ, Gusunɔ, Aburɑhɑmu kɑ Nɑkorin Yinni, u koo sun siriɑ. Mɑ Yɑkɔbu u mɑɑ bɔ̃ruɑ kɑ Yinni Gusunɔn yĩsiru, wi, wi win tundo Isɑki u nɑsie. ");
INSERT INTO bba_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Sɑɑ yerɑ u yɑ̃kuru kuɑ ɡuuru wɔllu mi, mɑ u win tɔmbu mɛnnɑ bɑ di sɑnnu. Yen biru bɑ kpunɑ mi wɔ̃ku te. ");
INSERT INTO bba_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Ye n kuɑ buru buru yellu, Lɑbɑni u seewɑ u win bibu kɑ win debuminu nɔɔ kɑnɑ u bu bɔkɑsi, mɑ u ben bɑɑwure domɑru kuɑ. Yen biru u ɡɔsirɑ u wurɑ win yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Yɑkɔbu u swɑɑ mɔ̀ u doonɔ, yerɑ Gusunɔn ɡɔrɑdobɑ bɑ kɑ nùn yinnɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Ye Yɑkɔbu u ɡɔrɑdo be wɑ, yerɑ u nɛɛ, Gusunɔn tɑbu kowobɑ beni. Mɑ u yɑm mi yĩsiru kɑ̃ Mɑhɑnɑimu. Yĩsi ten tubusiɑnɑ, sɑnsɑni yiru. ");
INSERT INTO bba_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yerɑ u sɔmɔbu ɡɔrɑ win mɔɔ Esɑun mi, Edɔmun temɔ mɛ bɑ mɑɑ mɔ̀ Seiri. ");
INSERT INTO bba_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","U bu woodɑ wɛ̃ u nɛɛ, ɑmɛniwɑ i ko nɛn tɔnwero Esɑu sɔ̃ i nɛɛ, nɛ Yɑkɔbu win bɔ̃ɔ, nɑ dɑ nɑ sinɑ Lɑbɑnin mi sere n kɑ kuɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Nɑ nɛɛ mɔ kɑ kɛtɛkunu kɑ yɑ̃ɑnu kɑ yoo tɔn durɔbu kɑ tɔn kurɔbu. Yerɑ nɑ nùn nɔɔsiɑmɔ u kɑ mɑn nɔnu ɡeu mɛɛri, wi, wi u sɑ̃ɑ nɛn tɔnwero. ");
INSERT INTO bba_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Sɔmɔ be, bɑ dɑ bɑ wurɑmɑ Yɑkɔbun mi, bɑ nɛɛ, sɑ turɑ wunɛn mɔɔ Esɑun mi, u mɑɑ sun sennɔ sisi kɑ tɑbu kowobu tɔmbu nɛɛru (400). ");
INSERT INTO bba_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Yerɑ bɛrum Yɑkɔbu mwɑ u nɑndɑ ɡem ɡem. Mɑ u tɔn be bɑ wɑ̃ɑ kɑ wi bɔnu kuɑ wuunu yiru kɑ win yɑ̃ɑnu kɑ kɛtɛbɑ kɑ yooyoosu. ");
INSERT INTO bba_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Mɑ u nɛɛ, bɑɑ Esɑu ù n nɑ u sube teeru wɔri u tu kɑmiɑ, te tɑ tie tɑ koo yɑri bɑɑni. ");
INSERT INTO bba_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Mɑ u kɑnɑru kuɑ u nɛɛ, Yinni Gusunɔ, nɛn bɑɑbɑ Aburɑhɑmu kɑ nɛn tundo Isɑkin Yinni, ɑ mɑn sɔ̃ɔwɑ n wuro nɛn temɔ mi bɑ mɑn mɑrɑ. Geɑ tɔnɑwɑ kɑɑ mɑn kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Nɑ ǹ turɑ n kɑ wunɛn durom bɑkɑm kɑ wunɛn bɔrɔkiniru kpuro wɑ te ɑ mɑn sɔ̃ɔsi, nɛ wi nɑ sɑ̃ɑ wunɛn bɔ̃ɔ. Domi nɑ Yuudɛni yeni tɔburɑwɑ kɑ nɛn dɛkɑ tɔnɑ. Adɑmɑ tɛ̃ nɛn tɔmbu kɑ nɛn sɑbenu kuɑ wuunu yiru. ");
INSERT INTO bba_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Nɑ nun kɑnɑmɔ ɑ mɑn wɔro sɑɑ nɛn mɔɔ Esɑun nɔmun di. Domi nɑ bɛrum mɔ̀ u ku rɑɑ sun wɔrimɑ u ɡo kɑ nɛn kurɔbu kɑ bibu sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Wunɑ ɑ mɑɑ ɡeruɑ kɑɑ mɑn durom kuɑ kpɑ ɑ nɛn bibun bweseru dɑbiɑsiɑ nɡe nim wɔ̃kun yɑnim mɛ ɡoo kun kpɛ̃ u ɡɑri. ");
INSERT INTO bba_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Yɑm miyɑ Yɑkɔbu u sɔbiɑ u kpunɑ. Mɑ u win yɑɑ sɑbenun sukum suɑ u kɑ win mɔɔ Esɑu kɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Sɑbe niyɑ boo ninu ɡoobu (200) kɑ boo kinɛnu yɛndu kɑ yɑ̃ɑ ninu ɡoobu kɑ yɑ̃ɑ kinɛnu yɛndu ");
INSERT INTO bba_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","kɑ nɑɑ mɛrobu weeru kɑ nɑɑ kinɛnu wɔkuru kɑ kɛtɛku mɛrobu yɛndu kɑ kɛtɛku dwɑnu wɔkuru, kɑ mɑm yooyoo mɛrobu tɛnɑ kɑ sin bii ni nu bom nɔrumɔ. ");
INSERT INTO bba_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","U ye kpuro suɑ u win yobu nɔmu bɛriɑ ɡɔ̃ɔ kɑ ɡɔ̃ɔ nɛnnɛnkɑ. Mɑ u bu sɔ̃ɔwɑ u nɛɛ, i n ɡbiɑ nɛn wuswɑɑɔ kpɑ i de ɡɔ̃ɔ si, su n swĩinɛ dɑndɑnkuru. ");
INSERT INTO bba_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Mɑ u ɡbiikoo sɔ̃ɔwɑ u nɛɛ, Esɑu nɛn mɔɔ ù n kɑ nun yinnɑ, ù n nun bikiɑ weren min diyɑ ɑ wee, mɑnɑ ɑ dɔɔ, weren sɑbenɑ ɑ ɡbiisie, ");
INSERT INTO bba_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ɑ nùn wisio ɑ nɛɛ, win bɔ̃ɔ Yɑkɔbuɡinɑ. Nu sɑ̃ɑwɑ kɛ̃ɛ te nɑ wi, nɛn tɔnwero mɔrisiɑmɑ. Nɛn tii nɑ wee biruɔ. ");
INSERT INTO bba_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Gɑri teeyɑ u yiruse sɔ̃ɔwɑ kɑ itɑse. Mɛyɑ u be kpuro sɔ̃ɔwɑ be bɑ sɑbe ni kpɑre ɡesi. ");
INSERT INTO bba_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Mɑ Yɑkɔbu u mɑɑ nɛɛ, i ɡeruo i nɛɛ, wee, nɛ win bɔ̃ɔ nɑ wee bɛɛn biruɔ. Domi u bwisikɑ win tii sɔɔ u nɛɛ, Esɑu ù n kɛ̃ɛ te nɑ ɡbiisie wɑ, win mɔru koo sure. Yen biru nɛ kɑ wi sɑ ko wɑɑnɑ nɔni kɑ nɔni. Sɔrɔkudo u koo mɑn dɑm koosiɑ kɑ nuku dobu. ");
INSERT INTO bba_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Kɛ̃ɛ te, tɑ ɡbiɑ mɑ u yɔ̃rɑ u kpunɑ mi, wɔ̃ku te. ");
INSERT INTO bba_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Yɑkɔbu u seewɑ wɔ̃ku te, u win kurɔbu yiru kɑ win yoo tɔn kurɔbu yiru kɑ win bibu wɔkurɑ tiɑ suɑ u dɑ u kɑ bu Yɑbɔkun dɑɑru tɔburɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Ye u bu tɔburɑsiɑ u kpɑ, mɑ u wurɑ u mɑɑ ye u mɔ kpuro tɔburɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Yɑkɔbu u tiɑ wi turo. Yerɑ durɔ ɡoo u nɑ u kɑ nùn ɡɑbirinɑ sere yɑm kɑ sɑ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Ye durɔ wi, u wɑ mɑ u ǹ kpɛ̃ u Yɑkɔbu surɑ, mɑ u win ɡɑ̃ɑ kpɔɔ so, ɡɑ sɔsiɑrɑ ye bɑ wɔri mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Yen biru durɔ wi, u nɛɛ, ɑ de n doonɑ, domi yɑm sɑ̃rerɑ wee. Yɑkɔbu u nùn wisɑ u nɛɛ, nɑ ǹ nun derimɔ ɑ doonɑ mɑ n kun mɔ ɑ mɑn domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Yerɑ durɔ wi, u bikiɑ u nɛɛ, ɑmɔnɑ wunɛn yĩsiru. U wisɑ u nɛɛ, Yɑkɔbu. ");
INSERT INTO bba_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Durɔ wi, u mɑɑ nɛɛ, bɑ ǹ mɑɑ nun sokumɔ Yɑkɔbu. Isireliwɑ bɑ koo nun soku yèn sɔ̃ ɑ kɑ Gusunɔ ɡɑbirinɑ kɑ mɑɑ tɔnu, mɑ ɑ kɑmiɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yerɑ Yɑkɔbu u nɛɛ, ɑ ɡem mɔ, ɑ mɑn wunɛn yĩsiru sɔ̃ɔwɔ. U nùn wisɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ nɛn yĩsiru bikiɑmɔ. Mɑ u nùn domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yɑkɔbu u yɑm mi yĩsiru kɑ̃ Peniɛli. Yĩsi ten tubusiɑnɑ, Gusunɔn wuswɑɑ. U nɛɛ, nɑ Gusunɔ wɑ nɔni kɑ nɔni, nɛn hunde mɑɑ fɑɑbɑ wɑɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Ye u Peniɛli tɔburɑ, mɑ sɔ̃ɔ u n yɑrimɔ. Sɑɑ dɔmɑ ten diyɑ u killimɔ kɑ ɡɑ̃ɑ te. ");
INSERT INTO bba_vpl VALUES ("GN32_33","002_32_33","GEN","32","33","33","Yen sɔ̃nɑ sere kɑ ɡisɔ Isirelibɑ bɑ ku rɑ yɑɑn sĩiru tem te tɑ kɑ ɡɑ̃ɑru sɔrinɛ, yèn sɔ̃ sĩiru miyɑ Gusunɔ u Yɑkɔbu so u kɑ kuɑ ɡɑ̃ɑruɡii. ");
INSERT INTO bba_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yenibɑn biru Yɑkɔbu u nɔni seeyɑ u wɑ wee, Esɑu u wee kɑ win tɑbu kowobu tɔnu nɛɛ te. Yerɑ Yɑkɔbu u win bibu bɔnu kuɑ u Leɑ nùn wiɡibu wɛ̃. Mɑ u mɑɑ Rɑsɛli wiɡii wɛ̃. Mɑ u mɑɑ win yoo tɔn kurɔbu yiru beɡibu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Mɑ u win yoo tɔn kurɔ be ɡbiisiɑ kɑ ben bibu, mɑ u derɑ Leɑ kɑ win bibu bɑ bu swĩi, yen biru Rɑsɛli kɑ win bii Yosɛfu bɑ swĩi. ");
INSERT INTO bba_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Mɑ Yɑkɔbu u besirɑ u bu ɡbiiyɑ u dɑ u yiirɑ nɔn nɔɔbɑ yiru win mɔɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Yerɑ Esɑun tii u mɑɑ dukɑ nɑ u Yɑkɔbu ɡɑbɑ wĩirɔ bɑ bɔkɑsinɑ bɑ sɔ̃sunɑ. Mɑ be yiru kpuro bɑ swĩ. ");
INSERT INTO bba_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Ye Esɑu u nɔni seeyɑ u Yɑkɔbun kurɔ be kɑ bii be wɑ, yerɑ u nɛɛ, berɑ̀ beni. Yɑkɔbu u nùn wisɑ u nɛɛ, bii be Gusunɔ u mɑn kɑ̃ win durom sɑɑbu, berɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Yerɑ yoo be, bɑ nɑ Esɑun wuswɑɑɔ bɑ yiirɑ. ");
INSERT INTO bba_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Mɑ Leɑ kɑ wiɡibu bɑ nɑ bɑ yiirɑ. Yen biru Rɑsɛli kɑ Yosɛfu bɑ mɑɑ nɑ bɑ yiirɑ. ");
INSERT INTO bba_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Mɑ Esɑu u mɑɑ Yɑkɔbu bikiɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ tɔn be kɑ sɑbe ni ɡbiisiɑmɑ nɛn mi. Yɑkɔbu u nùn wisɑ u nɛɛ, nɑ nun ye kpuro mɔrisiɑwɑ kpɑ ɑ kɑ mɑn nɔnu ɡeu mɛɛrin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Mɑ Esɑu u nɛɛ, nɛn wɔnɔ, sɑbe ni nɑ mɔ nɛn tii nu mɑn turɑ, ɑ wunɛɡinu nɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yerɑ Yɑkɔbu u nɛɛ, ɑɑwo, ɑ̀ n kɑ mɑn nɔnu ɡeu mɛɛrɑ, ɑ nɛn kɛ̃ɛ te mɔɔ. Domi ye ɑ mɑn dɑm koosiɑ kɑ nuku dobu nɑ wunɛn wuswɑɑ wɑɑsinɑwɑ nɡe Gusunɔɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ǹ n mɛn nɑ, ɑ nɛn kɛ̃ɛ te mɔɔ. Domi Gusunɔ u mɑn durom kuɑ u mɑn wɛ̃ kpuro yèn bukɑtɑ nɑ mɔ. Mɑ u Esɑu suuru kɑnɑ ɡem ɡem u sere kɛ̃ɛ te mwɑ. ");
INSERT INTO bba_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Mɑ u nɛɛ, ɑ seewo su doonɑ kpɑ nɑ n nun swɑɑ ɡbiiye. ");
INSERT INTO bba_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yɑkɔbu u nùn wisɑ u nɛɛ, nɛn tɔnwero, ɑ yɛ̃ mɑ nɑ bibu mɔ be bɑ kun ɡinɑ dɑm mɔ, kɑ yɑ̃ɑ binu kɑ kɛtɛ binu ni nu bom nɔrumɔ. Yen sɔ̃, sɑ̀ n derɑ bɑ sĩɑ too bɑɑ sɔ̃ɔ teeru, sɑbe ni kpuro nu koo ɡbisuku. ");
INSERT INTO bba_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yen sɔ̃, ɑ n ɡbiɑ, kpɑ nɛ kɑ bii be kɑ sɑbe ni, sɑ n wunɛn yirɑ swĩi kpurɛ kpurɛ sere su kɑ tunumɑ Seiriɔ mi ɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Mɑ Esɑu u nùn sɔ̃ɔwɑ u nɛɛ, to, kon nun nɛn tɔmbu ɡɑbu deriɑ. Yɑkɔbu u nɛɛ, ɑɑwo, tɔnwero, n de ɡesi durom wɑ wunɛn min di. ");
INSERT INTO bba_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Yen dɔmɑ terɑ Esɑu u ɡɔsirɑ u doonɑ Seiriɔ. ");
INSERT INTO bba_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Adɑmɑ Yɑkɔbu u dɑ Sukɔtuɔ. Ye u turɑ mi, u diru bɑnɑ mɑ u win sɑbenu kunu kuɑ. Yen sɔ̃nɑ bɑ yɑm mi sokɑ Sukɔtu. Yen tubusiɑnɑ, kunu. ");
INSERT INTO bba_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yen biru u seewɑ min di u turɑ kɑ ɑlɑfiɑ Kɑnɑnin temɔ mìn di u rɑɑ dɑ Pɑdɑnɑrɑmuɔ. Mɑ u win kunu ɡirɑ wuu ɡe bɑ mɔ̀ Sikɛmun bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tem mi u nu ɡirɑ mi, mɑ u mu dwɑ kɑ sii ɡeesun ɡobi wunɔbu (100) Hɑmɔrin bibun mi. Ben turon yĩsirɑ Sikɛmu. ");
INSERT INTO bba_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yerɑ u yɑ̃ku yeru kuɑ mi, u tu yĩsiru kɑ̃ u nɛɛ, Gusunɔwɑ u sɑ̃ɑ Isirelin Yinni. ");
INSERT INTO bba_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Sɑnɑm mɛ bɑ wɑ̃ɑ Sikɛmu mi, yerɑ Dinɑ, Leɑn bii tɔn kurɔ, wi u Yɑkɔbu mɑruɑ, u dɑ win wɔndiɑ kpɑɑsibun mi, be bɑ sɑ̃ɑ tem miɡibu. ");
INSERT INTO bba_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Mɑ Sikɛmu wi u sɑ̃ɑ Hɑmɔri, tem min sunɔn bii u Dinɑ wɑ. Mɑ u nùn ɡɑbɑ u sɛ̃re u kɑ kpunɑ. N deemɑ Hɑmɔri wi, u sɑ̃ɑwɑ Hefi. ");
INSERT INTO bba_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Sikɛmu wi, u Dinɑ kĩɑ ɡem ɡem sere u kɑ nùn ɡɑri kuɑ u wɑ u kɑ win ɡɔ̃ru sĩiyɛ win mi. ");
INSERT INTO bba_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Yen biruwɑ u win tundo sɔ̃ɔwɑ u nɛɛ, ɑ mɑn wɔndiɑ wini kɑsuo n suɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Sɑɑ ye sɔɔrɑ Yɑkɔbu u mɑɑ nuɑ mɑ bɑ kɑ win bii Dinɑ kpunɑ kɑ dɑm. Yerɑ u mɑri u ǹ ɡɑ̃ɑnu ɡeruɑ sere ye win bibɑ wɔmɑ kpɑrɑ ɡberun di. ");
INSERT INTO bba_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","7","Ye bɑ ɡɑri yi nuɑ, mɑ be kpuro bɑ mɔru bɛsirɑ ye Sikɛmu u kɑ Isirelin bweserun yĩsiru sɑnkɑ u kɑ ben sesu Dinɑ kpunɑ. Domi n ǹ weenɛ bu yen bweseru ko ben suunu sɔɔ. Yen biru Hɑmɔri, Sikɛmun tundo wi, u seewɑ u dɑ Yɑkɔbun mi, u kɑ nùn ɡɑri yi ko. ");
INSERT INTO bba_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Sɑnɑm mɛ u tunumɑ u nɛɛ, nɛn bii Sikɛmu u wunɛn bii wɔndiɑ wi bɑ mɔ̀ Dinɑn ɡɔɔ ɡbimɔ kĩrun sɔ̃. Yen sɔ̃, ɑ suuru koowo ɑ nùn wɔndiɑ wi kɛ̃ɛyɔ u suɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Domi bɛsɛn bibu bɑ̀ n suɑnɑ sɑ ko ko tiɑ bɛsɛ kɑ bɛɛ. Yen sɔ̃, i sun bɛɛn wɔndiɑbɑ wɛ̃ɛmɑ kpɑ su mɑɑ bɛsɛɡibu bɛɛ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Yen biru i ko n wɑ̃ɑ bɛsɛn tem mɛ sɔɔ, i n mɔ̀ ye i kĩ, i n tenkuru mɔ̀ kpɑ i dukiɑ wɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Yerɑ Sikɛmun tii u mɑɑ Yɑkɔbu kɑ win bii be bɑ tie sɔ̃ɔwɑ u nɛɛ, kon ko kpuro ye i mɑn sɔ̃ɔwɑ kpɑ i kɑ mɑn nɔnu ɡeu mɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Yen sɔ̃, i mɑn dokiri ɡobi bɛkɛ bureo kɑ kɛ̃ɛ dɑbinu nɡe mɛ̀n nɔɔ i kĩ. Kon ye kpuro wɛ̃ ì n ko ɡesi mɑn bii wi kɛ̃ n suɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Adɑmɑ yèn sɔ̃ Sikɛmu u Dinɑ sɑnkɑ, yen sɔ̃nɑ Yɑkɔbun bii be, bɑ wi kɑ win tundo Hɑmɔri wisɑ kɑ bwisi bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","n ǹ koorɔ su bɛsɛn sesu bɑnɡo sɑri wɛ̃, domi bɛsɛn mi, seku bɑkɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Ye sɑ bikiɑmɔ tɔnɑ, yerɑ bɛɛn tɔn durɔ bɑɑwure u bɑnɡo ko nɡe bɛsɛ. ");
INSERT INTO bba_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Sɑɑ yerɑ sɑ ko bɛsɛn wɔndiɑbɑ bɛɛ kɛ̃ kurɔbu kpɑ i mɑɑ sun bɛɛɡibu wɛ̃ kurɔbu kpɑ sɑ n wɑ̃ɑ sɑnnu su ko bwese teeru. ");
INSERT INTO bba_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Adɑmɑ ì n yinɑ i bɑnɡo ye ko, sɑ ko bɛsɛn wɔndiɑ mwɑwɑ kpɑ su doonɑ minin di. ");
INSERT INTO bba_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Gɑri yi, yi kɑ Sikɛmu kɑ win tundo nɑɑwɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","N ǹ mɑɑ tɛ Sikɛmu kɑ yi mɛm nɔɔwɑ domi u Yɑkɔbun bii wɔndiɑ wi kĩ too. N deemɑ wiyɑ u bɛɛrɛ bo win bɑɑbɑn yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Mɑ wi kɑ win tundo Hɑmɔri bɑ dɑ wuun ɡbɑ̃rɑ kɔnnɔwɔ mi bukurobu bɑ rɑ siri, bɑ bu sɔ̃ɔwɑ bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","tɔn beni bɑ kɑ sun do. Yen sɔ̃, su de bɑ n wɑ̃ɑ bɛsɛn tem mɛ sɔɔ bɑ n tenkuru mɔ̀. Domi tem mɛ, mu kpɑ̃. Kpɑ su ben wɔndiɑbɑ suɑ kurɔbu, kpɑ be, bu mɑɑ bɛsɛɡibu suɑ kurɔbu ");
INSERT INTO bba_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","kpɑ su ko bwese teeru. Yu kɑ koorɑ mɛ, sere bɛsɛn tɔn durɔ bɑɑwure u bɑnɡo ko nɡe mɛ ben tii bɑ sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yɑ̀ n koorɑ mɛ, berɑ̀ bɑ ben sɑbe ni mɔ kɑ ben dukiɑ. I de su ko mɛ kpɑ bu wɑ bu sinɑ kɑ bɛsɛ sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Be bɑ wɑ̃ɑ ɡbɑ̃rɑ kɔnnɔwɔ kpuro bɑ Hɑmɔri kɑ win biin ɡɑri yi nɔɔmɔ, mɑ tɔn durɔbu be bɑ yi nuɑ bɑ dɑ bɑ bɑnɡo ye kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Ye tɔn be, bɑ bɑnɡo ye kuɑ bɑ wɑ̃ɑ wɑhɑlɑ sɔɔ ɡinɑ, bɑ tɑmɑɑ ɡoo kun bu wɔrimɔ, yen sɔ̃ɔ itɑserɑ Yɑkɔbun bibu Simɛɔ kɑ Lefi, Dinɑn sesubu, bɑ ben tɑkobibɑ suɑ bɑ wuu ɡe wɔri bɑ ɡen tɔn durɔbu kpuro ɡo. ");
INSERT INTO bba_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Mɛyɑ bɑ mɑɑ Hɑmɔri kɑ win bii Sikɛmu ɡo. Mɑ bɑ ben sesu Dinɑ yɑrɑ Sikɛmun yɛnun di. ");
INSERT INTO bba_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Mɑ Yɑkɔbun bii be bɑ tie bɑ dɑ bɑ wuu ɡe wɔri bɑ ɡen yɑ̃nu ɡurɑmɑ yèn sɔ̃ bɑ ben sesu sɑnkɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Bɑ ben yɑ̃ɑnu kɑ kɛtɛbɑ ɡurɑ kɑ ben kɛtɛkunu kɑ yɑɑ sɑbe ni nu wɑ̃ɑ ben ɡberu kpɑɑnɛɔ ");
INSERT INTO bba_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","kɑ ben ɑrumɑni kpuro kɑ ben bibu kɑ ben kurɔbu. Ye tɔn be, bɑ mɔ ɡesi yɛnusɔ kpuro bɑ ɡurɑwɑ. ");
INSERT INTO bba_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yerɑ Yɑkɔbu u win bibu Lefi kɑ Simɛɔ sɔ̃ɔwɑ u nɛɛ, wɑhɑlɑ bɑkɑ i kɑ mɑn kɑsu mi. I derɑ nɛn bwɛ̃rɑ kun kpĩ. Domi Kɑnɑnibɑ kɑ Feresibɑ bɑ koo mɑn tusi. Yen biru bɑ̀ n dɑ nɔɔ tiɑ kuɑ bɑ mɑn wɔrimɑ bɑ koo sun kpeerɑsiɑwɑ mɑm mɑm, domi nɛn tɔmbɑ kun dɑbi. ");
INSERT INTO bba_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Mɑ bɑ Yɑkɔbu wisɑ bɑ nɛɛ, sɑ ko dewɑ bɑ n bɛsɛn sesu ɡɑrisi kurɔ tɑnɔ? ");
INSERT INTO bba_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Yenibɑn biru Gusunɔ u Yɑkɔbu sɔ̃ɔwɑ u nɛɛ, ɑ seewo ɑ dɑ Betɛliɔ kpɑ ɑ n wɑ̃ɑ mi, kpɑ ɑ mɑn yɑ̃ku yeru kuɑ mi nɑ rɑɑ nun kure sɑnɑm mɛ ɑ wunɛn mɔɔ dukɑ suurimɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yɑkɔbu u win tɔmbu sɔ̃ɔwɑ u nɛɛ, bũu ni i rɑɑ mɔ, i nu wunɔ bɛɛn suunu sɔɔn di, kpɑ i tii dɛɛrɑsiɑ i bɛɛn yɑ̃nu teɑ. ");
INSERT INTO bba_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Domi sɑ ko se su dɑ Betɛliɔ. Miyɑ kon Gusunɔ yɑ̃ku yeru kuɑ domi wiyɑ u mɑn somi sɑnɑm mɛ nɑ wɑ̃ɑ wɑhɑlɑ sɔɔ. Mɛyɑ u mɑɑ kɑ mɑn wɑ̃ɑ nɛn sɑnum kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Mɑ be kpuro bɑ ben bũu kpɛɛ ni bɑ wɑ sɑɑ tɔn tukobun min di ɡurɑ bɑ Yɑkɔbu wɛ̃ kɑ mɑɑ ben swɑɑ tonkunu. Mɑ u ye kpuro suɑ u sikuɑ dɑ̃ɑ bɑkɑru ɡɑrun nuurɔ Sikɛmu mi. ");
INSERT INTO bba_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yen biru bɑ seewɑ bɑ doonɑ min di. Mɑ Gusunɔ u derɑ tɔn be bɑ kɑ bu sikerenɛ mi, bɑ bɛrum soorɑ. Yen sɔ̃nɑ bɑ ǹ bu swɑɑ nɑɑmwɛ. ");
INSERT INTO bba_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yɑkɔbu u tunumɑ, wi kɑ win tɔn be, Lusiɔ ye bɑ mɑɑ sokumɔ Betɛli, Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yerɑ u Yinni Gusunɔ yɑ̃ku yee te bɑniɑ mɑ u tu yĩsiru kɑ̃ Gusunɔ u wɑ̃ɑ Betɛliɔ. Domi miyɑ u nùn kure sɑnɑm mɛ u win mɔɔ dukɑ suurimɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Yɑm miyɑ Deborɑ wi u Rebekɑ nɔɔri birun di u ɡu. Mɑ bɑ nùn sikuɑ Betɛlin ɡuurun nuurɔ dɑ̃ɑ bɑkɑru ɡɑrun korɔ. Yen sɔ̃nɑ bɑ dɑ̃ɑ te sokɑ ɡɔɔ wurin dɑ̃ru. ");
INSERT INTO bba_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yen biru Gusunɔ u kpɑm Yɑkɔbu kure Betɛliɔ mɑ u nùn domɑru kuɑ, sɑnɑm mɛ u wurɑmɑ Pɑdɑnɑrɑmun di. ");
INSERT INTO bba_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","U nɛɛ, wunɛn yĩsirɑ Yɑkɔbu, ɑdɑmɑ bɑ ǹ koo mɑɑ kɑ nun tu soku. Isireliwɑ bɑ ko n dɑ nun soku. ");
INSERT INTO bba_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","U mɑɑ nɛɛ, nɛ Gusunɔ nɑ sɑ̃ɑwɑ Dɑm kpuroɡii. A mɑruro kpɑ wunɛn bibu bu kɔwɑrɑ kpɑ bwese dɑbinu kɑ sinɑmbu bu mɑrurɑ wunɛn min di. ");
INSERT INTO bba_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Wunɛ kɑ wunɛn bibun bweserɑ i ko n tem mɛ mɔ mɛ nɑ Aburɑhɑmu kɑ Isɑki wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ye Gusunɔ u ɡɑri yi ɡeruɑ u kpɑ, u doonɑ wɔllɔ u Yɑkɔbu deri. ");
INSERT INTO bba_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Mɑ Yɑkɔbu u kperu suɑ u ɡirɑ bɑ n kɑ yɑɑye mɑ miyɑ Yinni Gusunɔ u kɑ nùn ɡɑri kuɑ. Mɑ u tu tɑm kɑ ɡum wisi kpɑ tɑ n kɑ sɑ̃ɑ Gusunɔɡiru. ");
INSERT INTO bba_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yerɑ u yɑm mi sokɑ Betɛli, domi miyɑ Gusunɔ u kɑ nùn ɡɑri kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yen biru Yɑkɔbu kɑ win tɔmbu bɑ seewɑ Betɛlin di bɑ dɔɔ Efɑrɑtɑɔ. Ye bɑ Efɑrɑtɑ turuku kuɑ, yerɑ Rɑsɛli u yiirɑ u mɑrɑ swɑɑ ye sɔɔ. Kurɔ wi, u wɑhɑlɑ kuɑ win mɑru bi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Sɑnɑm mɛ u wɑhɑlɑ mɔ̀, yerɑ mɑrusio u nùn sɔ̃ɔwɑ u nɛɛ, ɑ ku nɑndɑ, bii tɔn durɔwɑ ɑ mɑɑ wɑ. ");
INSERT INTO bba_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Ye u mɑrɑ u kpɑ u ɡɔɔ dɔɔ, yerɑ u win bii wi yĩsiru kɑ̃ Bɛni Oni. Yen tubusiɑnɑ, bii wi nɑ mɑrɑ kɑ wɑhɑlɑ. Adɑmɑ win tundo u nùn sokɑ Bɛnyɑmɛɛ. Yen tubusiɑnɑ mɑɑ, nɛn nɔm ɡeun bii . ");
INSERT INTO bba_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Mɑ Rɑsɛli u kpunɑ u ɡu. Bɑ nùn sikɑ Efɑrɑtɑn swɑɑɔ ye bɑ mɑɑ sokumɔ Bɛtelehɛmu. ");
INSERT INTO bba_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yerɑ Yɑkɔbu u kperu ɡɑru suɑ u ɡirɑ Rɑsɛlin siki ten mi, bɑ n kɑ nùn yɑɑye. Kpee te, tɑ wɑ̃ɑ mi sere kɑ ɡisɔn ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Min diyɑ u seewɑ u dɑ u win kuu bekuruɡiru ɡirɑ Miɡidɑli Edɛɛɔ. ");
INSERT INTO bba_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Sɑnɑm mɛ bɑ wɑ̃ɑ Miɡidɑli Edɛɛ mi, yerɑ ben turo Rubɛni u dɑ u kɑ win tundon kurɔ Bilihɑ kpunɑ. Mɑ tundo wi, u ye nuɑ. Yɑkɔbun bii tɔn durɔbu bɑ sɑ̃ɑwɑ wɔkurɑ yiru. ");
INSERT INTO bba_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Bibu wɔkurɑ yiru ye sɔɔ, Leɑɡibɑ Rubɛni wi, wi u sɑ̃ɑ Yɑkɔbun bii ɡbiikoo, kɑ Simɛɔ kɑ Lefi kɑ Yudɑ kɑ Isɑkɑri kɑ Sɑbuloni. ");
INSERT INTO bba_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Be bɑ mɑɑ sɑ̃ɑ Rɑsɛliɡibu, berɑ Yosɛfu kɑ Bɛnyɑmɛɛ. ");
INSERT INTO bba_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Be bɑ sɑ̃ɑ Bilihɑ, Rɑsɛlin yoon bibu, berɑ Dɑnu kɑ Nɛfitɑli. ");
INSERT INTO bba_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Silipɑ wi u sɑ̃ɑ Leɑn yoo, wiɡibɑ mɑɑ Gɑdi kɑ Asɛɛ. Bii be bɑ Yɑkɔbu mɑruɑ Pɑdɑnɑrɑmuɔ berɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yen biru Yɑkɔbu u turɑ win tundo Isɑkin mi, Mɑndeɔ, Kiriɑti Aribɑn bɔkuɔ ye bɑ mɑɑ mɔ̀ Heboroni. Miyɑ Aburɑhɑmu kɑ Isɑki bɑ sɔru di. ");
INSERT INTO bba_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isɑki u tɔkɔ kuɑ ɡem ɡem u kuɑwɑ wɔ̃ɔ wunɔbu kɑ wɛnɛ (180), mɑ u kpunɑ u ɡu u dɑ u win bɑɑbɑbɑ deemɑ. Win bibu Esɑu kɑ Yɑkɔbu bɑ nɑ bɑ nùn sikɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Esɑu wi bɑ mɑɑ sokumɔ Edɔmu win bibun bweseru wee. ");
INSERT INTO bba_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","U kurɔbu suɑ Kɑnɑnibɑn bweseru sɔɔ. Kurɔ ben yĩsɑ wee, Adɑ, Eloni Hɛtin bii, kɑ Oholibɑmɑ, Anɑn bii, Sibeoni Hefin debubu, ");
INSERT INTO bba_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","kɑ Bɑsimɑti, Isimɛɛlin bii, Nɛbɑyɔtun sesu. ");
INSERT INTO bba_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Adɑ u Esɑu Elifɑsi mɑruɑ. Mɑ Bɑsimɑti u Rewɛli mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Mɑ Oholibɑmɑ u Yeusi mɑrɑ kɑ Yɑlɑmu kɑ Kore. Bii be Esɑu u mɑrɑ Kɑnɑnin temɔ, berɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Mɑ u win kurɔbu suɑ kɑ bii be kpuro kɑ win tɔn be u mɔ kpuro, kɑ win yɑɑ sɑbenu kɑ win dukiɑ ye u wɑ Kɑnɑnin tem mi kpuro, mɑ u seewɑ u dɑ tem ɡɑm u kɑ win wɔnɔ Yɑkɔbu tondɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Domi ben yɑɑ sɑbenu dɑbi sere ɑyerɑ kun bu turi bu kɑ nu kpɑrɑ. Yen sɔ̃, bɑ ǹ kpɛ̃ bɑ n wɑ̃ɑ yɑm tem. ");
INSERT INTO bba_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Mɑ Esɑu u dɑ u wɑ̃ɑ Seirin ɡuunun berɑ ɡiɑ. Esɑu wiyɑ bɑ rɑ mɑɑ soku Edɔmu. ");
INSERT INTO bba_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Bii be u mɑrɑ, berɑ bɑ kuɑ Edɔmubɑ. Mɑ bɑ sinɑ Seirin ɡuunu ɡiɑ. Ben bweseru wee. ");
INSERT INTO bba_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Elifɑsi, Adɑn bii u seewɑ u Temɑni mɑrɑ kɑ Omɑɑ kɑ Sefo kɑ Gɑtɑmu kɑ Kenɑsi. Mɑ win kurɔ wi bɑ mɔ̀ Tinnɑ u nùn Amɑlɛki mɑruɑ. Rewɛli, Bɑsimɑtin bii u mɑɑ seewɑ u Nɑhɑti kɑ Serɑki kɑ Sɑmɑ kɑ Misɑ mɑrɑ. Berɑ bɑ kuɑ Rewɛlin bweseru. ");
INSERT INTO bba_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Be bɑ mɑɑ sɑ̃ɑ Oholibɑmɑn bibu, berɑ Yeusi kɑ Yɑlɑmu kɑ Kore. ");
INSERT INTO bba_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Be bɑ sɑ̃ɑ Esɑun bibun bweserun tore, berɑ mini. Esɑun bii ɡbiikoo Elifɑsi wiyɑ u sɑ̃ɑ bwese ninin sikɑdo, Temɑniɡibu kɑ Omɑɑɡibu kɑ Sefoɡibu kɑ Kenɑsiɡibu ");
INSERT INTO bba_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","kɑ Korebɑ kɑ Gɑtɑmuɡibu kɑ Amɑlɛkibɑ. Berɑ bɑ sɑ̃ɑ Adɑn bibu. ");
INSERT INTO bba_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Rewɛliwɑ u mɑɑ sɑ̃ɑ benin sikɑdo, Nɑhɑtiɡibu kɑ Serɑkibɑ kɑ Sɑmɑɡibu kɑ Misɑɡibu. Be kpurowɑ bɑ sɑ̃ɑ Bɑsimɑtin bibun bweseru. ");
INSERT INTO bba_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Be bɑ mɑɑ sɑ̃ɑ Oholibɑmɑn bibun bweserun nuuru, berɑ Yeusi kɑ Yɑlɑmu kɑ Kore. ");
INSERT INTO bba_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Sɑɑ Esɑun min diyɑ bwese ni kpuro nu mɑrurɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Seiri Horin bweserun diyɑ tɔn beni bɑ yɑrɑ. Mɑ bɑ kuɑ win bwese ten kɛrin nuuru. Beyɑ Lotɑni kɑ Sobɑli kɑ Sibeoni kɑ Anɑ ");
INSERT INTO bba_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","kɑ Disoni kɑ Esɛɛ kɑ Disɑni. Berɑ bɑ kuɑ Horibɑn sikɑdobɑ be bɑ wɑ̃ɑ Edɔmun temɔ sɑɑ yellun di. ");
INSERT INTO bba_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ye Lotɑni u seewɑ mɑ u Hori mɑrɑ kɑ Hemɑmu. N deemɑ Lotɑni wi, u sesu ɡoo mɔ wi bɑ mɔ̀ Tinnɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Mɑ Sobɑli u mɑɑ seewɑ u Alifɑni mɑrɑ kɑ Mɑnɑhɑti kɑ Ebɑli kɑ Sefo kɑ Onɑmu. ");
INSERT INTO bba_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Mɑ Sibeoni u mɑɑ bibu yiru mɑrɑ, Ayɑ kɑ Anɑ. Anɑ wiyɑ u bwii wɑ yìn min di nim sum mu yɑrimɔ sɑɑ ye u win tundon kɛtɛkunu kpɑrɑmɔ ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Wiyɑ u Disoni kɑ win sesu Oholibɑmɑ mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Be bɑ mɑɑ sɑ̃ɑ Disoniɡibu, berɑ Hɛmudɑni kɑ Ɛsibɑni kɑ Yitirɑni kɑ Kerɑni. ");
INSERT INTO bba_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Be bɑ mɑɑ sɑ̃ɑ Esɛɛɡibu, berɑ Bilɑni kɑ Sɑfɑni kɑ Akɑni. ");
INSERT INTO bba_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Mɑ Disɑni u mɑɑ Usi kɑ Arɑni mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","30","Beniwɑ bɑ kuɑ Horibɑn bwese kɛrin wiruɡibu Edɔmun temɔ, Lotɑni kɑ Sobɑli kɑ Sibeoni kɑ Anɑ kɑ Disoni kɑ Esɛɛ kɑ Disɑni. ");
INSERT INTO bba_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Sinɑm be bɑ bɑndu di di Edɔmuɔ Isirelibɑ bu sere mɑɑ bɑndu swĩi ben temɔ, be wee. ");
INSERT INTO bba_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Belɑ, Beorin bii, win wuun yĩsirɑ Dinɑbɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Ye Belɑ u ɡu mɑ Yobɑbu, Serɑkin bii, Botisirɑɡii u ɡɔnɑ kɔsire kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Ye Yobɑbu u ɡu mɑ Husɑmu Temɑniɡii u ɡɔnɑ kɔsire kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Ye Husɑmu u ɡu mɑ Hɑdɑdi, Bedɑdin bii u ɡɔnɑ kɔsire kuɑ. Wiyɑ u Mɑdiɑnibɑ ɡo Mɔɑbun bɑru kpɑɑnɔ. Win wuuwɑ Afiti. ");
INSERT INTO bba_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Ye Hɑdɑdi u ɡu mɑ Sɑmulɑ Mɑsirekɑɡii u ɡɔnɑ kɔsire kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Ye Sɑmulɑ u ɡu mɑ Sɔɔlu u ɡɔnɑ kɔsire kuɑ. Sɔɔlu wi, u sɑ̃ɑwɑ Rehobɔtuɡii. Wuu ɡe, ɡɑ wɑ̃ɑwɑ dɑɑ te bɑ mɔ̀ Efɑrɑtin ɡoorɔ. ");
INSERT INTO bba_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Ye Sɔɔlu u ɡu mɑ Bɑɑli Hɑnɑni, Akɑborin bii, u ɡɔnɑ kɔsire kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ye Bɑɑli Hɑnɑni u ɡu mɑ Hɑdɑri Pɑuɡii u ɡɔnɑ kɔsire kuɑ. Win kurɔn yĩsirɑ Mɛhetɑbɛli, Mɑtiredin bii, Mɛsɑɑbun debubu. ");
INSERT INTO bba_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Be bɑ mɑɑ sɑ̃ɑ Esɑun bweserun sikɑdobɑ bɑ kɑ wɑ̃ɑ Edɔmuɔ, be wee, Tinnɑ kɑ Alifɑ kɑ Yetɛti ");
INSERT INTO bba_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","kɑ Oholibɑmɑ kɑ Elɑ kɑ Pinɔni ");
INSERT INTO bba_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","kɑ Kenɑsi kɑ Temɑni kɑ Mibisɑɑ ");
INSERT INTO bba_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","kɑ Mɑdiɛli kɑ Irɑmu. Tem mi ben bɑɑwure u sinɑ, win yĩsirɑ bɑ rɑ kɑ mu soku. Be kpuro bɑ mɑrurɑwɑ sɑɑ Esɑun min di. ");
INSERT INTO bba_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yɑkɔbu u sinɑ Kɑnɑnin temɔ mi win tundo u rɑɑ sinɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Win bibun ɡɑri wee. Ye Yosɛfu u kuɑ wɔ̃ɔ wɔkurɑ nɔɔbu kɑ yiru, u yɑɑ sɑbenu kpɑrɑmɔ kɑ win mɑɑbu. U rɑ n wɑ̃ɑwɑ kɑ win tundo turosibu, Bilihɑ kɑ Silipɑn bibu sɑnnu. Yerɑ u rɑ ben tundo dɔmɛyɛ dɑɑ kɔ̃sɑ ye win mɑɑ be, bɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","N deemɑ Yɑkɔbu wi bɑ mɑɑ mɔ̀ Isireli u Yosɛfu kĩ n win bii be bɑ tie kpuro kere, yèn sɔ̃ tɔkɔru sɔɔrɑ u nùn mɑrɑ. Mɑ u nùn tɑko nɔni bwese bwesekɑɡiɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Ye win mɑɑbɑ wɑ ben tundo u nùn kĩ n be kpuro kere, yerɑ bɑ nùn tusiru seewɑ. Bɑ ku rɑ kpĩ bu kɑ nùn kĩru ɡɑri sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Sɔ̃ɔ teeru Yosɛfu u dosɑ. Yerɑ u win mɑɑbu dosu ɡe sɑɑriɑ. U bu sɔ̃ɔwɑ u nɛɛ, i swɑɑ dɑkio n bɛɛ nɛn dosu sɔ̃. Doo bɔkɑ sɑ bɔkumɔ ɡberɔ, yerɑ nɛn doo bɔkuru tɑ seewɑ tɑ yɔ̃rɑ, mɑ bɛɛɡinu nɑ nu tu sikerenɑ nu tu kpunɑmmɛ. Ye bɑ win ɡɑri nuɑ yerɑ bɑ nùn tusiru sosi ");
INSERT INTO bba_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","bɑ nɛɛ, wunɑ ɑ tɑmɑɑ kɑɑ ko bɛsɛn sunɔ kpɑ ɑ n sun kpɑre? Mɑ bɑ kpɑm nùn tusɑ bɑ sosi win dosu kɑ win ɡɑrin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Yen biru u kpɑm dosu ɡɑɡu kuɑ u ɡu win mɑɑbu sɑɑriɑ u nɛɛ, wee nɑ kpɑm dosɑ nɑ wɑ sɔ̃ɔ kɑ suru kɑ kperi wɔkurɑ tiɑ mɑn kpunɑmmɛ. ");
INSERT INTO bba_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","U mɑɑ ɡu win tundo sɔ̃ɔwɑ. Mɑ win tundo u nùn ɡerusi u nɛɛ, mbɑ wunɛn dosu ɡenin tubusiɑnu. Nɛ kɑ wunɛn mɛro kɑ wunɛn mɑɑbu sɑ ko nɑ su nun kpunɑwɑ? ");
INSERT INTO bba_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Win mɑɑbɑ kɑ nùn nisinu nɛni, ɑdɑmɑ win tundo u ye kpuro lɑsɑbu mɔ̀ win ɡɔ̃ruɔ. ");
INSERT INTO bba_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Sɔ̃ɔ teeru Yosɛfun mɑɑbɑ kɑ ben tundon sɑbenu kɔsɔru dɑ Sikɛmuɔ. ");
INSERT INTO bba_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Mɑ Isireli u Yosɛfu sɔ̃ɔwɑ u nɛɛ, n ǹ Sikɛmu ɡiɑ wunɛn mɑɑbɑ kɔsɔru dɑ? A nɑ n nun ɡɔri ben mi. Yosɛfu u nɛɛ, too. ");
INSERT INTO bba_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Mɑ Isireli u nɛɛ, ɑ doo ɑ mɛɛri bɑ̀ n bwɑ̃ɑ do kpɑ ɑ wɑ sɑbenu nù n mɑɑ ɑlɑfiɑ mɔ, kpɑ ɑ wurɑmɑ ɑ mɑn sɔ̃. Nɡe mɛyɑ u kɑ Yosɛfu ɡɔrɑ Sikɛmuɔ sɑɑ Heboronin di. ");
INSERT INTO bba_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Sɑnɑm mɛ u sirenɛ ɡbɑbu te sɔɔ, yerɑ durɔ ɡoo u kɑ nùn yinnɑ u nùn bikiɑ u nɛɛ, mbɑ ɑ kɑsu. ");
INSERT INTO bba_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yosɛfu u nɛɛ, nɛn mɑɑbɑ nɑ kɑsu. A ɡem mɔ ɑ mɑn sɔ̃ɔwɔ mi bɑ ben sɑbenu kpɑrɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Durɔ wi, u nɛɛ, bɑ doonɑ minin di. Domi nɑ nuɑ bɑ nɛɛ, bu doonɑ Dotɑni ɡiɑ. Mɑ Yosɛfu u win mɑɑbu nɑɑ ɡirɑ u bu deemɑ Dotɑniɔ. ");
INSERT INTO bba_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Ye bɑ nùn wɑ sɑrun di, u sere turi ben mi, bɑ wesiɑnɑ kɔ bu kɑ nùn ɡo. ");
INSERT INTO bba_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Bɑ sɔ̃ɔnɑ bɑ nɛɛ, bɛsɛn dosusuɡii wee u sisi. ");
INSERT INTO bba_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","I de su nùn ɡo tɛ̃ su kpɛ̃ɛ dɔkɔ kpiri ninin teeru sɔɔ, kpɑ su nɛɛ, yɑɑ kɔ̃sɑ ɡɑɑ yɑ nùn temɑ, kpɑ su wɑ mɛ win dosu si, su koo kɑ koorɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ye Rubɛni u nuɑ mɛ, u kɑsu u nùn fɑɑbɑ ko. Mɑ u nɛɛ, i ku de su nùn ɡo. ");
INSERT INTO bba_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","I nùn kpɛ̃ɛyɔ dɔkɔ kpiri teni sɔɔ ɡbɑburu mi. Adɑmɑ i ku nùn nɔmɑ doke. N deemɑ Rubɛni u bwisikumɔ u nùn wɔrɑ ben nɔmɑn di kpɑ u nùn ɡɔsiɑ ben tundon mi. ");
INSERT INTO bba_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Sɑɑ ye Yosɛfu u tunumɑ ben mi, bɑ nùn win tɑko nɔni bwese bwesekɑɡiɑ ye potɑri. ");
INSERT INTO bba_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","Mɑ bɑ nùn suɑ bɑ kpɛ̃ɛ dɔkɔ kpiri te sɔɔ, te tɑ ǹ nim mɔ. ");
INSERT INTO bba_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Yen biru bɑ sinɑ bɑ dimɔ. Ye bɑ nɔni seeyɑ bɑ tenku wuuru ɡɑru wɑ be bɑ sɑ̃ɑ Isimɛɛlibɑ bɑ swĩinɛ bɑ wee Gɑlɑdin di bɑ ben yooyoosu turɑre kɑ ɡum sɑwɑrɑm kɑ tim mɛ bɑ rɑ soku miru sɔbi bɑ kɑ dɔɔ Eɡibiti ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Mɑ Yudɑ u win mɑɑbu kɑ wɔnɔbu sɔ̃ɔwɑ u nɛɛ, ɑrufɑɑni yerɑ̀ sɑ ko wɑ sɑ̀ n bɛsɛn wɔnɔ ɡo sɑ tii mɑrisi. ");
INSERT INTO bba_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","I nɑ su dɑ su nùn Isimɛɛlibɑ dɔre, su ku nùn nɔmɑ doke. U sɑ̃ɑwɑ bɛsɛn yɛm domi bɛsɛn wɔnɔwɑ. Mɑ bɑ win ɡɑri wurɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ye Isimɛɛli be, be bɑ sɑ̃ɑ Mɑdiɑnin temɡibu, bɑ sɑrɔ, yerɑ Yosɛfun mɑɑbɑ nùn ɡɑwɑ bɑ yɑrɑ dɔkɔ kpiri ten min di bɑ nùn Isimɛɛli be dɔre kɑ sii ɡeesun ɡobi yɛndu, mɑ bɑ kɑ nùn doonɑ Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Mɑ Rubɛni u wurɑmɑ dɔkɔ kpiri ten mi, u deemɑ wee, Yosɛfu kun mɑɑ wɑ̃ɑ mi. Yerɑ u win tiin yɑberu nɛnuɑ u kɑrɑnɑ nuku sɑnkirɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Mɑ u ɡɔsirɑ u wiɡibu deemɑ u nɛɛ, bii wi kun mɑɑ wɑ̃ɑ mi ni! Nɛn wɑ̃ɑru! Mɑnɑ kon du! ");
INSERT INTO bba_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Sɑnɑm mɛyɑ bɑ boo kinɛru ɡo mɑ bɑ Yosɛfun yɑberu suɑ bɑ kɑ tu boo ɡen yɛm tɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Yerɑ bɑ ɡoo ɡɔrɑ ben tundon mi kɑ tɑko nɔni bwese bwesekɑɡiɑ ye, u nùn sɔ̃ u nɛɛ, u mɛɛrio ye bɑ wɑ. Win biin yɑberɑ mi? Nɡe n ǹ te. ");
INSERT INTO bba_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Ye u turɑ mi, Yɑkɔbu u yɑbe te tubɑ. Mɑ u nɛɛ, nɛn biin yɑberɑ mi. Gbeeku yɑɑ yɑ nùn kɑsukɑ yɑ temɑ. ");
INSERT INTO bba_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Yerɑ u win tiin yɑberu nɛnuɑ u kɑrɑnɑ mɑ u sɑɑki suɑ u deewɑ nuku sɑnkirɑnun sɔ̃. U win biin ɡɔɔ wooru sinɑ sɔ̃ɔ dɑbi dɑbinu. ");
INSERT INTO bba_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Win bii tɔn durɔbu kɑ tɔn kurɔbu kpuro bɑ nɑ bu kɑ nùn nukuru yɛmiɑsiɑ, ɑdɑmɑ u yinɑ u ben ɡoon ɡɑri nɔ. U nɛɛ, u koo win biin ɡɔɔ swĩwɑ sere u kɑ nùn nɑɑmwɛ ɡɔriɔ. Mɑ u ɡɔɔ wi swĩ n kɑ tɛ. ");
INSERT INTO bba_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Sɑɑ ye sɔɔ, Mɑdiɑni be, bɑ turɑ Eɡibitiɔ, mɑ bɑ Yosɛfu Potifɑɑ dore wi u sɑ̃ɑ Eɡibiti sunɔn sinɑ kpɑɑ kɔ̃sobun wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yen biru Yudɑ u win mɑɑbu kɑ wɔnɔbu deri u dɑ Hirɑn mi, Adulɑmuɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Miyɑ u Kɑnɑnin wɔndiɑ bii ɡoo wɑ wìn tundo bɑ mɔ̀ Suɑ. Mɑ u nùn suɑ kurɔ, bɑ mɛnnɑ. ");
INSERT INTO bba_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Kurɔ wi, u ɡurɑ suɑ u bii tɔn durɔ mɑrɑ, mɑ bɑ bii wi yĩsiru kɑ̃ Eru. ");
INSERT INTO bba_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","U mɑɑ wure u ɡurɑ suɑ u bii tɔn durɔ mɑrɑ, mɑ bɑ nùn yĩsiru kɑ̃ Onɑni. ");
INSERT INTO bba_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ye u Onɑni sɑrɑsiɑ, u kpɑm wure u ɡurɑ suɑ u bii tɔn durɔ mɑrɑ, mɑ bɑ nùn yĩsiru kɑ̃ Selɑ. Sɑɑ yè sɔɔ kurɔ wi, u Selɑ mɑrɑ, Yudɑ u ǹ wɑ̃ɑ mi. U dɑ u wɑ̃ɑwɑ Kisibuɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Eri, Yudɑn bii ɡbiikoo wi, u kpɛ̃ɑ mɑ win tundo u nùn kurɔ kɑsuɑ. Kurɔ win yĩsirɑ Tɑmɑɑ. ");
INSERT INTO bba_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ye Yinni Gusunɔ u wɑ mɑ Eri u sɑ̃ɑ tɔn kɔ̃so, mɑ u derɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Sɑɑ ye sɔɔrɑ Yudɑ u Onɑni sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn mɔɔn kurɔ suo ɑ yɛnu doke kpɑ ɑ nùn bweseru kɑsuɑ nɡe mɛ woodɑ yɑ ɡerumɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onɑni u wɑ mɑ kurɔ wi, ù n mɑrɑ, bii be, bɑ ǹ ko n sɑ̃ɑ wiɡibu. Yerɑ ù n kɑ nùn mɛnnɑmɔ u ku rɑ wure u tii wɑ kurɔ wi sɔɔ, u ku kɑ win mɔɔ bibu mɑruɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Ye Onɑni u mɔ̀ mi, yɑ ǹ Yinni Gusunɔ dore. Yen sɔ̃nɑ u mɑɑ derɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yerɑ Yudɑ u Tɑmɑɑ sɔ̃ɔwɑ u nɛɛ, ɑ doo ɑ ɡɔminiru di sere nɛn bii Selɑ ù n kpɛ̃ɑ. Domi u tii sɔ̃ɔwɑ u nɛɛ, Selɑ ù n kurɔ wi suɑ, u koo rɑ mɑɑ ɡbi nɡe win mɑɑbu. Mɑ Tɑmɑɑ u doonɑ u dɑ u wɑ̃ɑ win tundon yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Sɑnɑm dɔɔ sɑnɑm wee, Yudɑn kurɔ Suɑn bii u ɡu. Ye Yudɑ u yen ɡɔminiru di u kpɑ, win bwɛ̃rɑ wurɑmɑ, yerɑ bɑ dɑ Tinnɑɔ wi kɑ win bɔrɔ Hirɑ Adulɑmuɡii wi. Miyɑ bɑ Yudɑn yɑ̃ɑnun sɑnsu bɔɔrimɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Yerɑ ɡoo u dɑ u Tɑmɑɑ sɔ̃ɔwɑ u nɛɛ, wee wunɛn dwɑɑ tundo u dɔɔ Tinnɑɔ u kɑ win yɑ̃ɑnun sɑnsu bɔɔri. ");
INSERT INTO bba_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Ye u nuɑ mɛ, yerɑ u win ɡɔmini yɑ̃nu potɑ, mɑ u tii sɔnditiɑ wukiri nɡe kurɔ tɑnɔ, u dɑ u sinɑ wuu ɡe bɑ mɔ̀ Enɑimun kɔnnɔwɔ Tinnɑn swɑɑɔ. Domi u wɑ Selɑ u kpɛ̃ɑ, bɑ ǹ mɑɑ nùn wi wɛ̃ durɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Ye Yudɑ u sɑrɔ u nùn wɑ u sɔ̃ mi, mɑ u nùn ɡɑrisi kurɔ tɑnɔ yèn sɔ̃ u win wuswɑɑ sɔnditiɑ wukiri. ");
INSERT INTO bba_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Mɑ u susi win bɔkuɔ u kɑ nùn ɡɑri kuɑ u nɛɛ, su dɑ wunɛn yɛnuɔ n kɑ nun kpunɑ. Domi u ǹ yɛ̃ win biiɡii kurɔwɑ. Mɑ kurɔ wi, u nùn wisɑ u nɛɛ, mbɑ kɑɑ mɑn kɛ̃ ɑ̀ n kɑ mɑn kpunɑ. ");
INSERT INTO bba_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Mɑ Yudɑ u nɛɛ, kon de bu kɑ nun boo kpɛmu nɑɑwɑ. Kurɔ wi, u nɛɛ, ǹ n mɛn nɑ, ɑ mɑn ɡɑ̃ɑnu tɔrubɑ yiiyo sere ɑ̀ n boo ɡe mɔrisiɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","19","Yudɑ u nùn wisɑ u nɛɛ, mbɑ ɑ kĩ n nun tɔrubɑ yiiyɑ. Mɑ u nɛɛ, ɑ mɑn wunɛn tɑɑbu ɡe ɡɑ wunɛn yĩreru mɔ kɑ ɡen wɛ̃ɛ kɑ dɛkɑ ye ɑ nɛni wɛ̃ɛmɑ. Yerɑ u ye kpuro kurɔ wi wɛ̃, mɑ u dɑ u kɑ nùn kpunɑ. Yen biru kurɔ wi, u seewɑ u doonɑ. U dɑ u sɔnditiɑ ye wunɑ mɑ u mɑɑ win ɡɔmini yɑ̃ɑ ni doke. Amɛn biru u deemɑ wee, u ɡurɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yudɑ u win bɔrɔ Hirɑ Adulɑmuɡii wi ɡɔrɑ u kɑ boo ɡe kurɔ wi dɑɑwɑ, kpɑ u win yɑ̃ɑ ni u tɔrubɑ yii mi mwɑɑmɑ. Adɑmɑ ye u turɑ mi, u ǹ kurɔ wi wɑ. ");
INSERT INTO bba_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Yerɑ u yɑm min tɔmbu bikiɑ u nɛɛ, mɑnɑ kurɔ tɑnɔ wi u rɑɑ wɑ̃ɑ Enɑimun kɔnnɔwɔ swɑɑ sɔɔ mini. Mɑ bɑ nùn wisɑ bɑ nɛɛ, kurɔ tɑnɔ ɡoo sɑri mini. ");
INSERT INTO bba_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Yerɑ u ɡɔsirɑ Yudɑn mi, u nɛɛ, nɑ ǹ kurɔ wi wɑ. Yɑm min tɔmbu bɑ mɑɑ nɛɛ, kurɔ tɑnɔ ɡoo sɑri ben wuu mi. ");
INSERT INTO bba_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yudɑ u nɛɛ, ǹ n mɛn nɑ, u nɛnuɔ, ye u wɑ kɔ. Wee, nɑ kɑ nun boo kpɛmu ɡe ɡɔrɑ win mi, ɑ ǹ mɑɑ nùn wɑ. Yen sɔ̃, su ku de bu sun yɛ̃ɛ. ");
INSERT INTO bba_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Suru itɑn biru bɑ nɑ bɑ Yudɑ sɔ̃ɔwɑ bɑ nɛɛ, wunɛn biiɡii kurɔ Tɑmɑɑ u kurɔ tɑnɑru dimɔ sere u mɑm ten ɡurɑ suɑ. Mɑ Yudɑ u nɛɛ, bu nùn yɑro wuun di bu dɔ̃ɔ mɛni. ");
INSERT INTO bba_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Sɑnɑm mɛ bɑ kɑ nùn yɑriɔ wuun di, yerɑ u ɡɔrɑ bu Yudɑ tɑɑbu ɡe kɑ ɡen wɛ̃ɛ yi kɑ dɛkɑ ye sɔ̃ɔsi, kpɑ bu nùn sɔ̃ mɑ wi u ye kpuro mɔ, yɛ̃ron ɡurɑ u mɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Ye bɑ kɑ yɑ̃ɑ ni turɑ, Yudɑ u nu ɡiɑ mɑ u nɛɛ, kurɔ wi, u mɑn ɡem kere, domi nɑ yinɑ n nùn nɛn bii Selɑ wɛ̃ durɔ. Yen biru Yudɑ kun mɑɑ kɑ nùn mɛnnɑre. ");
INSERT INTO bba_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Sɑnɑm mɛ kurɔ wi, u mɑrubu turɑ yerɑ bɑ wɑ mɑ sikɑbɑrɑ bɑ wɑ̃ɑ win nukurɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Ye u yiire, yerɑ bii ben turo u nɔmɑ yɑrɑmɑ, mɑ mɑrusio u nɔmu ɡe sɔɔ wɛ̃ɛ wunɔmɡii ɡbinisi u nɛɛ, winiwɑ koo ɡbi u yɑrimɑ. ");
INSERT INTO bba_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Adɑmɑ u nɔmu ɡe wesiɑ, mɑ wi u kun dɑɑ nɔmɑ yɑre mi, u ɡbiɑ u yɑrimɑ. Yerɑ mɑrusio u nɛɛ, ɑnnɑ ɑ kɑ tii swɑɑ kɛniɑ mɛ! Yen sɔ̃nɑ bɑ nùn yĩsiru kɑ̃ Perɛsi. Yen tubusiɑnɑ, swɑɑ kɛniɔ. ");
INSERT INTO bba_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Yen biruwɑ wi bɑ wɛ̃ɛ wunɔmɡii ɡbinisi mi, u yɑrimɑ. Mɑ bɑ nùn yĩsiru kɑ̃ Serɑki. ");
INSERT INTO bba_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Isimɛɛlibɑ bɑ kɑ Yosɛfu dɑ Eɡibitiɔ. Mɑ Potifɑɑ Eɡibitiɡii u nùn dwɑ ben mi. Potifɑɑ wi, u sɑ̃ɑwɑ Eɡibiti sunɔn sinɑ kpɑɑ kɔ̃sobun wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yinni Gusunɔ u wɑ̃ɑ kɑ Yosɛfu, mɑ u nùn kuɑ tɔn bɑrukɑɡii. U wɑ̃ɑ win yinni Eɡibitiɡiin yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Yinni wi, u wɑ mɑ Yinni Gusunɔ u kɑ nùn wɑ̃ɑ, mɑ u mɑɑ nùn swɑɑ kusiɑmmɛ yɑbu bɑɑyere sɔɔ ye u mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yen sɔ̃, u kɑ nùn nɔnu ɡeu mɛɛrɑ u nùn kuɑ win yɛnun sɔm kowobu kpuron wiruɡii, mɑ win ye u mɔ kpuro u nùn nɔmu sɔndiɑ. ");
INSERT INTO bba_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Sɑɑ mìn di u Yosɛfu kuɑ win yɛnun sɔm kowobu kpuron wiruɡii mɑ u nùn ye u mɔ kpuro nɔmu sɔndiɑ, Yinni Gusunɔ u win yɛnu ɡe domɑru kuɑ kɑ ye u mɔ kpuro yɛnuɔ kɑ ɡberɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Potifɑɑ wi, u ye u mɔ kpuro deri Yosɛfun nɔmɑ sɔɔ. U ǹ mɑɑ yen ɡɑɑn ɡɑri yɛ̃ mɑ n kun mɔ win dĩɑ ni u koo doke nɔɔwɔ bɑɑsi. N wee Yosɛfu durɔ burɔwɑ. Win wɑsi kɑ win wuswɑɑ ɡirimɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Yerɑ sɔ̃ɔ teeru win yinnin kurɔ u nùn nɔni ɡirɑri mɑ u nɛɛ, ɑ de ɑ kɑ mɑn kpunɑ. ");
INSERT INTO bba_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Adɑmɑ Yosɛfu u yinɑ. U kurɔ wi sɔ̃ɔwɑ u nɛɛ, n wee, nɛn yinni u ǹ yɛnun ɡɑ̃ɑnun ɡɑri yɛ̃. Win ye u mɔ kpuro, nɛnɑ u nɔmu sɔndiɑ. ");
INSERT INTO bba_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","U ǹ mɑn dɑm kere yɛnu ɡe sɔɔ, u ǹ mɑɑ mɑn ɡɑ̃ɑnu yinɑri mɑ n kun mɔ wunɛ tɔnɑ yèn sɔ̃ ɑ sɑ̃ɑ win kurɔ. Yerɑ kon ɡɑ̃ɑ ninin bweseru ko kpɑ n Gusunɔ torɑri? ");
INSERT INTO bba_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Bɑɑdommɑwɑ kurɔ wi, u rɑ n kɑ nùn ɡɑri yi mɔ̀. Kɑ mɛ, Yosɛfu u yinɑ u kɑ nùn kpunɑ. U ku rɑ mɑm kɑ̃ bɑ n wɑ̃ɑ sɑnnu. ");
INSERT INTO bba_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Sɔ̃ɔ teeru Yosɛfu u duɑ dirɔ u kɑ win sɔmburu ko. N deemɑ yɛnu ɡen tɔnu ɡoo sɑri turuku. ");
INSERT INTO bba_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yerɑ kurɔ wi, u Yosɛfun bekuru nɛnuɑ u nɛɛ, ɑ kɑ mɑn kpunɔ. Yosɛfu u nùn beku te deriɑ u dukɑ yɑrɑ tɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Ye kurɔ wi, u wɑ mɑ u nùn beku te deriɑ u dukɑ yɑrɑ tɔɔwɔ, ");
INSERT INTO bba_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","yerɑ u win yɛnuɡibu sokɑ u nɛɛ, i nɑ i wɑ. Heberu wi nɛn durɔ kɑ nɑ u sun kɑm mɛɛrɑ. U kĩ u kɑ mɑn kpunɑ ɑdɑmɑ nɑ wurɑ kuɑ tɑ̃ɑ tɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Ye u nuɑ nɑ wurɑ kuɑ mɛ, u mɑn win bekuru deriɑ u dukɑ yɑrɑ tɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Mɑ kurɔ wi, u beku te yii yeru kuɑ sere win yinni u kɑ wurɑmɑ yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Sɑnɑm mɛ u wurɑmɑ mi, kurɔ wi, u nùn sɔ̃ɔwɑ u nɛɛ, yoo Heberu wi ɑ kɑ sun nɑɑwɑ mi, u mɑn duwi u kɑ mɑn sɑnku. ");
INSERT INTO bba_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Ye nɑ wurɑ kuɑ, yerɑ u mɑn win bekuru deriɑ u dukɑ yɑrɑ tɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Ye durɔ wi, u win kurɔn ɡɑri yi nuɑ, yerɑ u mɔru bɛsirɑ. ");
INSERT INTO bba_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Mɑ u Yosɛfu suɑ u doke pirisɔm dirɔ mi bɑ rɑ sunɔn pirisɔmbɑ doke. Miyɑ u wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Adɑmɑ Yinni Gusunɔ u wɑ̃ɑ kɑ wi. U mɑɑ nùn domɑru kuɑ u derɑ u kĩi ɡeeru wɑ pirisɔm kɔ̃sobun wiruɡiin mi. ");
INSERT INTO bba_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Mɑ wiruɡii wi, u nùn pirisɔm be bɑ wɑ̃ɑ mi kpuro nɔmu sɔndiɑ. Ye bɑ koo ko kpuro, wiyɑ rɑ yen woodɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Wiruɡii wi, u ku rɑ mɛɛri ye Yosɛfu u mɔ̀ domi Yinni Gusunɔ u wɑ̃ɑ kɑ wi. Mɑ u derɑ win ye u kuɑ kpuro yɑ wɛ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Yebɑ kpuron biru Eɡibiti sunɔn sɔm kowobun wiruɡibu yiru bɑ nùn torɑri. Turo u sɑ̃ɑ pɛ̃ɛ kowobun wiruɡii, turo mɑɑ wi u rɑ nùn nɔrɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mɑ u kɑ be yiru ye mɔru bɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","U bu doke pirisɔm kɔ̃sobun wiruɡiin dirɔ mi bɑ Yosɛfu kɛnuɑ. ");
INSERT INTO bba_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Pirisɔm kɔ̃sobun wiruɡii wi, u bu Yosɛfu nɔmu sɔndiɑ u n bu sɔmburu kuɑmmɛ. Mɑ bɑ sɔ̃ɔ mɛɛru kuɑ pirisɔm diru mi. ");
INSERT INTO bba_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Yerɑ wɔ̃kuru ɡɑru be yiru ye, bɑ dosɑ pirisɔm diru mi. Ben bɑɑwure kɑ wiɡuu kɑ ɡen tubusiɑnu nɛnɛm. ");
INSERT INTO bba_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ye Yosɛfu u nɑ ben mi bururu u bu mɛɛrɑ, yerɑ u deemɑ ben nuki sɑnkire. ");
INSERT INTO bba_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Mɑ u bu bikiɑ u nɛɛ, ɑmɔnɑ bɛɛn wuswɑɑ kɑ burisinɛ mɛ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Bɑ nùn wisɑ bɑ nɛɛ, sɑ dosɑwɑ. Goo mɑɑ sɑri wi u koo sun dosu si tubusiɑ. Yosɛfu u bu sɔ̃ɔwɑ u nɛɛ, n ǹ Gusunɔwɑ u rɑ n ɡɑ̃ɑnu kpuron tubusiɑnu yɛ̃? Ǹ n mɛn nɑ, i mɑn bɛɛn dosu si sɑɑrio. ");
INSERT INTO bba_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Mɑ wi u rɑ Eɡibiti sunɔ tɑm nɔrɑ wɛ̃, u win dosu Yosɛfu sɑɑriɑ u nɛɛ, nɛn dosu sɔɔ wee, nɑ resɛm dɑ̃ru wɑ nɛn wuswɑɑɔ tɑ kpiɑ. Dɑ̃ɑ te, tɑ kɑ̃ɑsi itɑ mɔ. Mɑ tɑ wɛ̃su kuɑ tɑ binu mɑrɑ nu ye. ");
INSERT INTO bba_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","N deemɑ nɑ Eɡibiti sunɔn nɔrɑ nɛni nɛn nɔmuɔ. Nɑ resɛm ye wɔkɑ nɑ ɡɑmɛ nɔrɑ ye sɔɔ. Mɑ nɑ ye suɑ nɑ nùn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Mɑ Yosɛfu u nùn sɔ̃ɔwɑ u nɛɛ, dosu ɡen tubusiɑnu wee. Kɑ̃ɑsi itɑ ye, sɔ̃ɔ itɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","N tie sɔ̃ɔ itɑ sunɔ u kɑ nun yɑrɑ pirisɔm di kpɑ u nun wesiɑ wunɛn sɔmburu sɔɔ. Kɑɑ kpɑm nùn win nɔrɑ wɛ̃ nɡe mɛ ɑ rɑ rɑɑ ko sɑnɑm mɛ ɑ sɑ̃ɑ win sɔm kowo. ");
INSERT INTO bba_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Adɑmɑ ɑ n mɑn yɑɑye sɑnɑm mɛ ɑ doo nɔɔru wɔri. Nɑ nun kɑnɑmɔ, ɑ mɑn durom kuo ɑ sunɔ nɛn ɡɑri sɔ̃ kpɑ ɑ mɑn yɑrɑ dii tenin di. ");
INSERT INTO bba_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Domi bɑ mɑn ɡbɛnɑwɑ sɑɑ Heberubɑn tem di, bɑ kɑ mɑn nɑ mini. Yen biru nɑ ǹ mɑɑ ɡɑ̃ɑnu kue bɑ kɑ mɑn kpɛ̃ɛmɑ pirisɔm diru mi. ");
INSERT INTO bba_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Ye pɛ̃ɛ kowobun wiruɡii wi, u wɑ mɑ Yosɛfu u wiɔnɔn dosu ɡe tubusiɑ n dorɑ, yerɑ u nɛɛ, wee, nɛn dosu sɔɔ, nɛnɑ mɑɑ birenu itɑ sɔɔwɑ nì sɔɔ bɑ rɑ pɛ̃ɛ doke. ");
INSERT INTO bba_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Bire te tɑ wɑ̃ɑ wɔllɔ, kirɑ bwese bwesekɑwɑ wɑ̃ɑ mi, ye bɑ yeesiɑ pɛ̃ɛ doo sɔɔ. Mɑ ɡunɔsu kirɑ ni dimɔ bire te sɔɔ, nɛn wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yosɛfu nùn wisɑ u nɛɛ, ɡen tubusiɑnu wee. Birenu itɑ ye, sɔ̃ɔ itɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","N tie sɔ̃ɔ itɑ sunɔ u kɑ wunɛn wiru burɑ kpɑ bu nun sɑ̃ɑrusiɑ dɑ̃ɑ wɔllɔ, ɡunɔsu su wunɛn yɑɑ di. ");
INSERT INTO bba_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Ye n kuɑ sɔ̃ɔ itɑ ye, Eɡibiti sunɔ u win mɑrubun tɔ̃ɔ bɑkɑru kuɑ. Mɑ u sɔm kowobu yiru ye yɑrɑ pirisɔm di, u bu yɔ̃rɑsiɑ win sɔm kowo be bɑ tien wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mɑ wi u rɑ nùn nɔrɑ wɛ̃ mi, u nùn wesiɑ win sɔmburu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Adɑmɑ bɑ pɛ̃ɛ kowobun wiruɡii wi sɑ̃ɑrusiɑ nɡe mɛ Yosɛfu u rɑɑ bu tubusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Yen biru sunɔn nɔri wɛ̃ɔ wi, u Yosɛfu duɑri. ");
INSERT INTO bba_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Wɔ̃ɔ yirun biru Eɡibiti sunɔn tii u dosɑ. Wee u yɔ̃ dɑru bɔ̃ɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Yerɑ nɑɑ mɛro burɛ nɔɔbɑ yiru yi yi bɔɔru yi yɑrimɑ dɑɑrun di yi dimɔ dɑru bɔ̃ɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Mɑ nɛɛ nɔɔbɑ yiru ɡɛɛ mɑɑ yɑrimɑ dɑɑrun di yi yi woore yi ǹ wɑɑbu wɑ̃, yi yɔ̃rɑ yiɔnɔn bɔkuɔ dɑru bɔ̃ɔ mi. ");
INSERT INTO bba_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Mɑ yi nɛɛ burɛ yi yi bɔɔru mwɛ. Mɑ u dom yɑndɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","U kpɑm dweeyɑ mɑ u dosɑ nɔn mɛɛruse. Wee, doo ɡɑ̃ɑ teeru sɔɔ, u doo wii ɡeenu nɔɔbɑ yiru wɑ ni nu bɛm mɔ swɛɛ swɛɛ. ");
INSERT INTO bba_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Mɑ doo winu nɔɔbɑ yiru ɡɑnu nu mɑɑ yɑrɑ niɔnɔn temɔ, ni nu sɑkosu sɑ̃ɑ nu ɡbere sɔ̃ɔ kɑ woon sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Doo wii sɑko si, su doo wii ɡeenu mwɛ mwɛ. Mɑ u dom yɑndɑ u deemɑ u dosɑwɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ye n kuɑ bururu win bwɛ̃rɑ kun kpunɛ. U sɔrobu kɑ bwisiɡibu kpuro sokɑ be bɑ wɑ̃ɑ Eɡibitiɔ. U bu win dosu si kpuro sɑɑriɑ. Adɑmɑ bɑɑ ben turo kun kpĩɑ u nùn dosu si tubusie. ");
INSERT INTO bba_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Sɑɑ ye sɔɔrɑ win nɔri wɛ̃ɔ wi, u nùn sɔ̃ɔwɑ u nɛɛ, ɡisɔrɑ nɑ yɑɑyɑ mɑ nɑ torɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Sɑnɑm mɛ ɑ mɔru kuɑ kɑ bɛsɛ wunɛn sɔm kowobu, mɑ ɑ derɑ bɑ sun kpɛ̃ɛ nɛ kɑ pɛ̃ɛ kowobun wiruɡii pirisɔm kɔ̃sobun wiruɡiin dirɔ, ");
INSERT INTO bba_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","bɛsɛ yiru ye, sɑ dosɑ wɔ̃ku teeru. Mɑ bɛsɛn bɑɑwure u win dosun tubusiɑnu nuɑ nɡe mɛ u dosɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","N deemɑ bɛsɛ kɑ Heberu bii ɡoowɑ sɑ wɑ̃ɑ mi, wi u sɑ̃ɑ pirisɔm kɔ̃sobun wiruɡiin yoo. Ye sɑ nùn bɛsɛn dosu si sɑɑriɑ, yerɑ u sun si tubusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Mɑ n kuɑ nɡe mɛ u bɑɑwure tubusiɑ. A mɑn wesiɑ nɛn sɔmburu sɔɔ, mɑ ɑ derɑ bɑ pɛ̃ɛ kowobun wiruɡii wi sɑ̃ɑrusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Ye Eɡibiti sunɔ u nuɑ mɛ, u Yosɛfu sokusiɑ. Mii mii bɑ nùn yɑrɑmɑ pirisɔm dirun di, u win toburu kɔnɑ kɑ win bɑɑ sɑnsu u yɑ̃nu kɔsɑ, mɑ u seewɑ u dɑ sunɔ win mi. ");
INSERT INTO bba_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Sunɔ u nùn sɔ̃ɔwɑ u nɛɛ, nɑ dosɑ. Goo kun kpĩɑ u mɑn dosu ɡe tubusie. Nɑ mɑɑ nuɑ ɑ rɑ dosu tubusie bɑ̀ n nun ɡu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Mɑ Yosɛfu u nùn wisɑ u nɛɛ, n ǹ nɛ, Gusunɔwɑ u koo nun ɡe tubusiɑ n dorɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Mɑ sunɔ u nɛɛ, wee, nɛn dosu sɔɔ nɑ yɔ̃ dɑru bɔ̃ɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Yerɑ nɑɑ mɛro burɛ nɔɔbɑ yiru yi yi bɔɔru yi yɑrimɑ dɑɑrun di yi dimɔ dɑru bɔ̃ɔwɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Mɑ nɛɛ nɔɔbɑ yiru ɡɛɛ mɑɑ yɑrimɑ dɑɑrun di yi yi woore yi ǹ wɑɑbu wɑ̃. Nɑ ǹ nɑɑ kɔ̃simii nin bweseru wɑɑre Eɡibitin tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Nɛɛ yi, yi nɛɛ ɡbiikii nɔɔbɑ yiru yi yi bɔɔru mi mwɛ. ");
INSERT INTO bba_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Adɑmɑ ye yi yi mwɛ mɛ, ɑ ǹ kɑɑ n mɑm yɛ̃ nɡe yi ɡɑ̃ɑnu mwɛ. Domi mɛ yi woore yellun di, mɛyɑ yi woore mi. Mɑ nɑ dom yɑndɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Yen biru nɑ kpɑm dosɑ nɑ doo ɡɑ̃ɑ teeru sɔɔ doo wii ɡeenu nɔɔbɑ yiru wɑ ni nu bɛm mɔ swɛɛ swɛɛ. ");
INSERT INTO bba_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Mɑ doo winu nɔɔbɑ yiru ɡɑnu nu mɑɑ yɑrɑ niɔnɔn temɔ ni nu sɑkosu sɑ̃ɑ nu ɡbere sɔ̃ɔ kɑ woon sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Doo wii sɑko si, su doo wii ɡee ni mwɛ mwɛ. Nɑ dosu ɡe nɛn sɔrobu sɑɑriɑ ɑdɑmɑ ben ɡoo kun mɑn ɡu tubusie. ");
INSERT INTO bba_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yosɛfu u nùn sɔ̃ɔwɑ u nɛɛ, ɡɑ̃ɑ teenɑ ɑ dosɑ. Gusunɔwɑ u nun sɔ̃ɔsi ye u koo ko. ");
INSERT INTO bba_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Nɑɑ mɛro burɛ nɔɔbɑ yiru ye, kɑ doo wii ɡeenu nɔɔbɑ yiru ye, wɔ̃ɔ nɔɔbɑ yiruwɑ. Ye kpuro yɑ sɑ̃ɑwɑ dosu teu. ");
INSERT INTO bba_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Nɛɛ nɔɔbɑ yiru yi yi woore yi ǹ wɑɑbu wɑ̃ mi, yi yi yɑrɑ yiɔnɔn biruɔ, kɑ doo wii sɑkosu nɔɔbɑ yiru si su ɡbere sɔ̃ɔ kɑ woon sɔ̃ mi, nu sɑ̃ɑwɑ wɔ̃ɔ nɔɔbɑ yiru yè sɔɔ ɡɔ̃ɔrɑ ko n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Gusunɔwɑ nun sɔ̃ɔsi ye u koo ko nɡe mɛ nɑ rɑɑ nun sɔ̃ɔwɑ, sunɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","N wee, wɔ̃ɔ nɔɔbɑ yiru sɔɔ, deburɑ ko n wɑ̃ɑ Eɡibitin tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Adɑmɑ yen biru ɡɔ̃ɔrɑ koo tem mɛ kpuro wɔri wɔ̃ɔ nɔɔbɑ yiru kpɑ tu kpɛ̃ɑ ɡem kɑ tiɑ sere bɑ ǹ koo mɑɑ debu ten yirɑ wɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ye ɑ kɑ dosu ɡe kuɑ nɔn mɛɛru, Gusunɔ u kĩ ɑ n yɛ̃ mɑ yɑ koo koorɑwɑ yɑ ǹ mɑɑ tɛɛmɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tɛ̃, sunɔ, n weenɛ ɑ bwisiɡii ɡoo kɑsu wi u lɑsɑbu mɔ, kpɑ ɑ nùn ko Eɡibitin wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Kpɑ ɑ mɑɑ tɔmbu ɡɑbu wunɑ be bɑ koo deburun sɑɑn dĩɑnu kpuro bɔnu ko subɑ nɔɔbu kpɑ bu nin sube teeru mwɑ bɑɑwuren mi. ");
INSERT INTO bba_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Kpɑ bu dĩɑ ni kpuro mɛnnɑ kɑ wunɛn yiiko bu doo bɔkunu bere birɑnu sɔɔ wuu bɑɑɡeren sɔ̃ kpɑ bɑ n nu kɔ̃su. ");
INSERT INTO bba_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Niyɑ nu ko n beruɑ tɔmbun sɔ̃ bɑ n kɑ ɡɔ̃ɔrun wɔ̃ɔ nɔɔbɑ yiru ye mɑrɑ ye yɑ wee tem mɛ sɔɔ, kpɑ tu ku rɑɑ kɑ tɔmbu kpuro ɡo. ");
INSERT INTO bba_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Mɑ Yosɛfun ɡɑri yi, yi Eɡibiti sunɔ dore kɑ win sinɑ ɑsɑkpɔbu kpuro. ");
INSERT INTO bba_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Yerɑ u bu bikiɑ u nɛɛ, mɑnɑ sɑ ko mɑɑ tɔnu wɑ wi u Gusunɔn Hunde mɔ nɡe wini. ");
INSERT INTO bba_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Mɑ u Yosɛfu sɔ̃ɔwɑ u nɛɛ, nɡe mɛ Gusunɔ u nun ye kpuro sɔ̃ɔsi, ɡoo mɑɑ sɑri wi u bwisi kɑ lɑsɑbu mɔ nɡe wunɛ. ");
INSERT INTO bba_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Kon nun ko nɛn yɛnu yɛ̃ro. Nɛn tɔmbu kpuro bɑ koo wunɛn ɡɑri mɛm nɔɔwɑ. Nɛn sinɑ ɡɔnɑ tɔnɑwɑ ko nɑ n kɑ nun kere. ");
INSERT INTO bba_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","U mɑɑ nɛɛ, wee, nɑ nun kuɑ Eɡibitin tem kpuron wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Yerɑ u win tɑɑbu ɡe ɡɑ win yĩreru mɔ potɑ win nɔmun di u Yosɛfu dokeɑ win nɔmuɔ. Mɑ u nùn yɑ̃ɑ burɑnu sebusiɑ. Yen biru u nùn yɔni wurɑɡii dokeɑ wĩirɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mɑ u derɑ bɑ nùn yɔɔsiɑ kɛkɛ sɔɔ ye dumi ɡɑwe yɑ wiɡiɑ swĩi. Gɑbɑ nùn ɡbiiye bɑ mɔ̀, i yiiro i yiiro. Nɡe mɛyɑ Eɡibiti sunɔ u kɑ Yosɛfu kuɑ tem mɛ kpuron wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Mɑ u kpɑm nùn sɔ̃ɔwɑ u nɛɛ, nɛ Eɡibiti sunɔ, nɛnɑ nɑ ɡeruɑ, Eɡibitin tem kpuro sɔɔ, ɡoo kun kpɛ̃ u ɡɑ̃ɑnu ko mɑ n kun mɔ kɑ wunɛn woodɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","46","Mɑ u Yosɛfu yĩsiru kɑ̃ Sɑfenɑti Pɑniɑki te tɑ sɑ̃ɑ be Eɡibitiɡibun yĩsiru. Mɑ u nùn Potiferɑn bii Asinɑti kɑ̃ kurɔ. Potiferɑ wi, u sɑ̃ɑwɑ wuu ɡe bɑ mɔ̀ Onin yɑ̃ku kowo. Yosɛfu u mɔwɑ wɔ̃ɔ tɛnɑ sɑnɑm mɛ Eɡibiti sunɔ u nùn kuɑ wiruɡii. Mɑ Yosɛfu u doonɑ u dɑ u Eɡibitin tem kpuro berɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Deburun wɔ̃ɔ nɔɔbɑ yiru ye sɔɔ, tem mu dĩɑnu kuɑ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yerɑ Yosɛfu u wuu bɑɑɡeren ɡbeɑn dĩɑnu mɛnnɑ wɔ̃ɔ nɔɔbɑ yiru ye sɔɔ, u nu beruɑ wuu ɡen birɑnu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Dĩɑ ni u mɛnnɑ mi, nin kpɑ̃ɑrɑ bɑndɑ sere bɑ ǹ kpɛ̃ bu nin ɡeeru ɡiɑ. Nu sɑ̃ɑwɑ nɡe yɑni sɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Gɔ̃ɔ ten sɑɑ yu sere nɑ, Asinɑti, Potiferɑn bii u Yosɛfu bii tɔn durɔbu yiru mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yen ɡbiikoowɑ Yosɛfu u yĩsiru kɑ̃ Mɑnɑse, u nɛɛ, domi Gusunɔ u derɑ nɑ nɛn wɑhɑlɑ kpuro duɑri kɑ mɑɑ nɛn bɑɑn yɛnu kpuro. ");
INSERT INTO bba_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Mɑ u yiruse yĩsiru kɑ̃ Efɑrɑimu, u nɛɛ, domi Gusunɔ u derɑ nɑ mɑrɑ tem mi nɑ nɔni swɑ̃ɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Sɑnɑm dɔɔ sɑnɑm wee, debu bɑkɑ ten wɔ̃ɔ nɔɔbɑ yiru yen bɑɑ doonɑ Eɡibitin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Mɑ wɔ̃ɔ nɔɔbɑ yiru ɡɔ̃ɔruɡiɑ yɑ tunumɑ nɡe mɛ Yosɛfu u rɑɑ ɡeruɑ. Gɔ̃ɔ te, tɑ tem bɑɑmɑ kpuro nɛnuɑ, mɑ n kun mɔ Eɡibitin tem tɔnɑ sɔɔ mi dĩɑnu wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Adɑmɑ ye ɡɔ̃ɔrɑ rɑ duɑ mi, tɔmbɑ Eɡibiti sunɔ wuri koosimɔ bu kɑ dĩɑnu wɑn sɔ̃. Mɑ u bu sɔ̃ɔwɑ u nɛɛ, bu doo Yosɛfun mi, kpɑ bu ko ye u koo bu sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Ye Yosɛfu u wɑ ɡɔ̃ɔrɑ tem mɛ kpuro nɛnuɑ, yerɑ u birɑ ni kpuro wukiɑ u tɔmbu dĩɑnu dɔremɔ. Gɔ̃ɔ te, tɑ kpɛ̃ɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Mɑ tɔmbɑ nɑɑmɔ Eɡibitiɔ tem kpuron di bu kɑ dĩɑnu dwe Yosɛfun mi, domi ɡɔ̃ɔ te, tɑ tem kpuro nɛni ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Ye Yɑkɔbu u nuɑ dĩɑnu wɑ̃ɑ Eɡibitiɔ, yerɑ u win bibu bikiɑ u nɛɛ, mbɑn sɔ̃nɑ i mɛɛrinɛ i ǹ ɡɑ̃ɑnu mɔ̀. ");
INSERT INTO bba_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Nɑ nuɑ mɑ Eɡibitiɔ dĩɑnu wɑ̃ɑ. Ǹ n mɛn nɑ, i seewo i dɑ i sun nu dwiɑmɑ kpɑ su wɑ sɑ n kɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Mɑ Yosɛfun mɑɑbu wɔkuru bɑ seewɑ bɑ dɑ Eɡibitiɔ bu kɑ dĩɑnu dwe. ");
INSERT INTO bba_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Adɑmɑ Yɑkɔbu kun wure Yosɛfun wɔnɔ Bɛnyɑmɛɛ u kɑ bu dɑ domi u nɛɛ, wɑhɑlɑ ɡɑɑ yɑ koo rɑ nùn deemɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Mɑ bɑ dĩɑ ni dwem dɑ Eɡibitiɔ kɑ Kɑnɑnibɑ ɡɑbu. Domi ɡɔ̃ɔrɑ wɑ̃ɑ Kɑnɑnin tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Sɑɑ ye sɔɔ, Yosɛfuwɑ u Eɡibitin tem kpɑrɑmɔ. Wiyɑ u tem min tɔmbu dĩɑnu dɔrɑsiɑmɔ. Ye win mɑɑ be, bɑ turɑ mi, bɑ nùn yiirɑ bɑ wiru tem ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Ye u bu wɑ u bu ɡiɑ, ɑdɑmɑ u kuɑ nɡe u ǹ bu yɛ̃. Mɑ u bu ɡerusi kɑ dɑm u nɛɛ, mɑn diyɑ i nɑ. Bɑ nùn wisɑ bɑ nɛɛ, sɑɑ Kɑnɑnin tem diyɑ sɑ nɑ su kɑ dĩɑnu dwe. ");
INSERT INTO bba_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Adɑmɑ kɑ mɛ, bɑ ǹ nùn tubɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Sɑɑ yerɑ u yɑɑyɑ dosu ɡe u rɑɑ kuɑ ben sɔ̃. Mɑ u bu sɔ̃ɔwɑ u nɛɛ, i nɑwɑ i kɑ bɛsɛn tem sɑriɑ mɛɛri kpɑ i wɑ mi sɑ dɑm kɔmiɛ. ");
INSERT INTO bba_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Bɑ nùn wisɑ bɑ nɛɛ, ɑɑwo, yinni, sɑ nɑwɑ su kɑ dĩɑnu dwe. ");
INSERT INTO bba_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Tɔn turowɑ u bɛsɛ kpuro mɑrɑ. Gemɑ sɑ ɡerumɔ, sɑ ǹ sɑ̃ɑ be bɑ tem sɑriɑ mɛɛrim nɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Adɑmɑ Yosɛfu u bu wisɑ u nɛɛ, weesɑ, i nɑwɑ i kɑ wɑ mi sɑ dɑm kɔmiɛ. ");
INSERT INTO bba_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Bɑ kpɑm nùn wisɑ bɑ nɛɛ, yinni, sɑ sɑ̃ɑwɑ bɛsɛ tɔnu wɔkurɑ yiru. Tɔn turowɑ u sun mɑrɑ Kɑnɑnin temɔ. Bɛsɛn wi u piiburu bo, wiyɑ sɑ deri yɛnuɔ kɑ bɛsɛn tundo, mɑ turo u sɑriru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yosɛfu kpɑm bu wisɑ u nɛɛ, weesɑ i mɔ̀. I nɑwɑ i kɑ bɛsɛn tem sɑriɑ mɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Wee nɡe mɛ kon kɑ bɛɛn lɑɑkɑri mɛɛri. Ì kun kɑ bɛɛn wɔnɔ wi u wɑ̃ɑ yɛnuɔ mi nɛ, sere kɑ Eɡibiti sunɔn yĩsiru i ǹ yɑriɔ minin di. ");
INSERT INTO bba_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Yen sɔ̃, i bɛɛn turo ɡɔrio u dɑ u kɑ nùn nɑ. Bɛɛ be i tie, bu bɛɛ doke pirisɔm dirɔ. Sɑɑ ye sɔɔrɑ sɑ ko wɑ ǹ n ɡem nɑ i ɡerumɔ. Mɑ n kun mɛ, sere kɑ Eɡibiti sunɔn yĩsiru, i nɑwɑ i kɑ tem sɑriɑ mɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Mɑ u bu kɛnusi pirisɔm dirɔ sɔ̃ɔ itɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Sɔ̃ɔ itɑse terɑ u bu sɔ̃ɔwɑ u nɛɛ, nɑ Gusunɔ nɑsie. Yen sɔ̃, i koowo mɛni kpɑ i wɑ i n kɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Ì n sɑ̃ɑn nɑ tɔn ɡeobu, i bɛɛn turo derio diru mini. Bɛɛ be i tie kpɑ i kɑ bɛɛn tɔmbu dĩɑnu dɑɑwɑ ɡɔ̃ɔ ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Kpɑ i kɑ mɑn bɛɛn wɔnɔ dɑ̃ɑko wi nɑɑwɑ. Sɑɑ yerɑ kon ɡiɑ mɑ ɡemɑ i ɡerumɔ, kpɑ su bɛɛ deri i n wɑ̃ɑ. Bɑ wurɑ mɛ, ");
INSERT INTO bba_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","mɑ bɑ sɔ̃ɔnɑ bɑ nɛɛ, kɔ̃sɑ ye sɑ bɛsɛn wɔnɔ Yosɛfu kuɑ yerɑ yɑ sun kɔsiemɔ tɛ̃, domi sɑ win nuku sɑnkirɑnu wɑ. Ye u sun suuru kɑnɑ sɑ ǹ wure. ");
INSERT INTO bba_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Rubɛni u bu sɔ̃ɔwɑ u nɛɛ, nɑ ǹ dɑɑ bɛɛ sɔ̃ɔwɑ nɑ nɛɛ, i ku bii wi kɔ̃sɑ ɡɑɑ kuɑ? Adɑmɑ i ǹ nɛn ɡɑri wure. Wee, tɛ̃ Gusunɔ u sun win yɛm bikiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sɑnɑm mɛ bɑ ɡɑri yi mɔ̀, bɑ ǹ yɛ̃ Yosɛfu u ben bɑrum nɔɔmɔ. Domi ɡoowɑ u rɑ bu ɡɑri tusie. ");
INSERT INTO bba_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Mɑ Yosɛfu u bu dɛsirɑri ɡinɑ u dɑ u swĩ. Yen biru u wurɑ u kɑ bu ɡɑri kuɑ. Mɑ u be sɔɔ Simɛɔ ɡɔsɑ u derɑ bɑ kɑ nùn yɔni bɔkuɑ be kpuron nɔni biru. ");
INSERT INTO bba_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yen biru u woodɑ wɛ̃ u nɛɛ, bu ben sɑɑkibɑ sɔɔ dĩɑnu yibio kpɑ bu ben bɑɑwuren ɡobi wesiɑ win sɑɑki sɔɔ, kpɑ bu be dĩɑnu kusenu kuɑ ni bɑ koo di swɑɑ sɔɔ. Mɑ bɑ kuɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Mɑ bɑ ben dĩɑ ni kɛtɛkunu sɔbi bɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Swɑɑ sɔɔ mi bɑ wɛ̃re, yerɑ ben turo u win sɑɑki kusiɑ u kɑ win kɛtɛku dĩɑnu kɛ̃. Mɑ u deemɑ ɡobi wee sɑɑki ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Mɑ u be bɑ tie sɔ̃ɔwɑ u nɛɛ, bɑ mɑn nɛn ɡobi wesiɑ. Yi wee nɛn sɑɑkiɔ. Yerɑ bɑ nɑndɑ bɑ ɡerunɑ bɑ nɛɛ, mbɑ Gusunɔ u sun kuɑ yeni. ");
INSERT INTO bba_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Mɑ bɑ wure bɑ swɑɑ wɔri bɑ turɑ ben tundon mi Kɑnɑnin temɔ. Bɑ nùn sɔ̃ɔwɑ kpuro ye n bu deemɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Bɑ nɛɛ, durɔ wi u sɑ̃ɑ Eɡibitiɡibun wiruɡii u sun ɡerusi u nɛɛ, sɑ nɑwɑ su kɑ ben tem sɑriɑ mɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Mɑ sɑ nùn wisɑ sɑ nɛɛ, sɑ sɑ̃ɑwɑ tɔn ɡeobu. Sɑ ǹ nɛ su kɑ ben tem sɑriɑ mɛɛri. ");
INSERT INTO bba_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Sɑ kpɑm nùn sɔ̃ɔwɑ sɑ nɛɛ, sɑ sɑ̃ɑwɑ tɔn turon bibu, bɛsɛ wɔkurɑ yiruwɑ ɑ mɑrɑ. Bɛsɛn turo sɑriru kuɑ. Wi u piiburu bo, u mɑɑ wɑ̃ɑ yɛnuɔ kɑ wunɛ. ");
INSERT INTO bba_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Yerɑ u sun wisɑ u nɛɛ, su nùn bɛsɛn turo derio. Bɛsɛ be sɑ tie, kpɑ su kɑ bɛsɛn tɔmbu dĩɑnu nɑɑwɑ ni nu koo bu turi ɡɔ̃ɔ ten sɔ̃, ");
INSERT INTO bba_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","kpɑ su kɑ nùn bɛsɛn wɔnɔ wi u wɑ̃ɑ yɛnuɔ mi nɑɑwɑ. Nɡe mɛyɑ u koo be kɑ ɡiɑ mɑ sɑ sɑ̃ɑ tɔn ɡeobu, sɑ ǹ weesu mɔ̀, sɑ ǹ mɑɑ sɑ̃ɑ be bɑ ben tem sɑriɑ mɛɛrim nɑ. Kpɑ u sun bɛsɛn turo wi wesiɑ. Mɛyɑ u koo be mɑɑ de su tenkuru ko ben tem mi. ");
INSERT INTO bba_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Ye bɑ ɡɑri yi ɡeruɑ bɑ kpɑ, yerɑ ben bɑɑwure u win sɑɑki kusiɑ. Be kɑ ben tundo bɑ wɑ wee, ben bɑɑwuren ɡobi yi u kɔsiɑ yi wɑ̃ɑ win sɑɑkiɔ. Mɑ bɛrum be kpuro mwɑ. ");
INSERT INTO bba_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Yerɑ Yɑkɔbu u nɛɛ, i ko de n nɛn bibu kpuro biɑwɑ. Domi wee, Yosɛfu u sɑriru kuɑ, nɑ mɑɑ Simɛɔ biɑ, tɛ̃ i kĩ i Bɛnyɑmɛɛ suɑ. Ye kpuro nɛ sɔɔrɑ yɑ wɔrimɔ. ");
INSERT INTO bba_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Rubɛni u ben tundo wisɑ u nɛɛ, ɑ ɡesi mɑn Bɛnyɑmɛɛ nɔmu sɔndio. Nɑ̀ kun kɑ nùn wurɑmɛ, nɛn bibu yiru wee, ɑ bu ɡoowo. ");
INSERT INTO bba_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yɑkɔbu u bu wisɑ u nɛɛ, nɛn bii u ǹ kɑ bɛɛ dɔɔ. Domi win mɔɔ u ɡu, wi turowɑ u mɑn tie. Yen sɔ̃, wɑhɑlɑ ɡɑɑ yɑ̀ n seewɑ yɑ nùn deemɑ ɡbɑburu sɔɔ, nuku sɑnkirɑru tɑ koo rɑ mɑn ɡo, domi nɑ tɔkɔ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Sɑnɑm dɔɔ sɑnɑm wee, ɡɔ̃ɔrɑ dɑm mɔ̀ Kɑnɑnin temɔ tɑ dɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ye Yɑkɔbu kɑ win bibu bɑ dĩɑ ni di bɑ kpɑ, ni bɑ rɑɑ dweemɑ Eɡibitin di mi, yerɑ u bu sɔ̃ɔwɑ u nɛɛ, i mɑɑ wuro Eɡibiti mi, i sun dĩɑnu fiiko dwiɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yudɑ u nùn sɔ̃ɔwɑ u nɛɛ, Eɡibitin wiruɡii wi, u sun sɔ̃ɔwɑ u sirewɑ u nɛɛ, su ku nɑ win wuswɑɑɔ mɑ sɑ ǹ bɛsɛn wɔnɔ Bɛnyɑmɛɛ nɛni. ");
INSERT INTO bba_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ǹ n mɛn nɑ, ɑ̀ n wurɑ u sun swĩi, sɑ ko dɑ su nun dĩɑnu dwiɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","À n mɑɑ yinɑ, sɑ ǹ dɔɔ. Domi durɔ wi, u nɛɛ, su ku rɑ nɛ win wuswɑɑɔ mɑ n kun kɑ bɛsɛn wɔnɔ wi. ");
INSERT INTO bba_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Mɑ Yɑkɔbu wi bɑ mɑɑ sokumɔ Isireli, u bu sɔ̃ɔwɑ u nɛɛ, ɡɑri kɔ̃si yiren bweserɑ i mɑn kuɑ mɛ, ye i nɛɛ, i mɑɑ wɔnɔ mɔ u bɛɛ tie. ");
INSERT INTO bba_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Bɑ nùn wisɑ bɑ nɛɛ, durɔ wi, u sun bikiɑ u sirewɑ u nɛɛ, ɑmɔnɑ sɑ sɑ̃ɑ. Wɑrɑ sun mɑrɑ. Bɛsɛn tundo u wɑ̃ɑ hunde sɔɔ? Sɑ mɑɑ wɔnɔ ɡoo mɔ? Mɑ sɑ nùn wisɑ ye u sun bikiɑ kpuro. Amɔnɑ sɑ ko n kɑ yɛ̃ mɑ u koo nɛɛwɑ su kɑ bɛsɛn wɔnɔ nɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yudɑ u win tundo Isireli sɔ̃ɔwɑ u nɛɛ, ɑ de bɛsɛn wɔnɔ wi, u kɑ mɑn dɑ kpɑ su doonɑ kpɑ bɛsɛ kpuro su ku rɑ ɡbi, bɛsɛ kɑ wunɛ kɑ bɛsɛn bibu. ");
INSERT INTO bba_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ye n nùn deemɑ kpuro nɛnɑ kon ye sɔbe kpɑ nɑ n sɑ̃ɑ tɑɑrɛɡii wunɛn mi, nɑ̀ kun kɑ nùn wurɑmɛ. ");
INSERT INTO bba_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Wunɛn tii ɑ wɑ sɑɑ mìn di sɑ ɡɑri yi mɔ̀, sɑ̀ n dɔɔn nɑ, sɑ n ɡɔsirɑmɛ nɔn mɛɛruse. ");
INSERT INTO bba_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Isireli u ɡeruɑ u nɛɛ, ǹ n mɛn nɑ, yɑ̀ n kuɑ tilɑsi, i ɡɑ̃ɑ burɑnu suo ni nu sɑ̃ɑ bɛsɛn tem miɡinu ni nu ǹ wɑ̃ɑ Eɡibitiɔ i kɑ durɔ wi dɑɑwɑ, nɡe ɡum sɑwɑrɑm kɑ tim fiiko kɑ turɑre fiiko kɑ dɑ̃ɑ mɑrum fiiko kɑ tii bi bɑ rɑ soku miru. ");
INSERT INTO bba_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Kpɑ i n ɡobi nɛni nɡe mɛ i rɑɑ kɑ dɑn nɔn yiru. Ì n turɑ mi, kpɑ i bu yiɔnɔ wesiɑ yi sɑ deemɑ bɛɛn sɑɑkibɑ sɔɔ. À ku tubɑ, bɑ yi duɑriwɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Yen biru i bɛɛn wɔnɔ wi suo kpɑ i dɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Gusunɔ Dɑm kpuroɡii u koo de durɔ wi, u bɛɛn wɔnwɔndu wɑ kpɑ u de i wurɑmɑ kɑ Simɛɔ kɑ Bɛnyɑmɛɛ. Nɑ̀ n kon mɑɑ bibu biɑn nɑ, to, kpɑ n biɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Mɑ bii be, bɑ kɛ̃ɛ ni suɑ kɑ ɡobi yi bɑ rɑɑ kɑ dɑn nɔn yiru kɑ Bɛnyɑmɛɛ sɑnnu. Mɑ bɑ seewɑ bɑ swɑɑ wɔri bɑ dɑ Eɡibitiɔ. Ye bɑ turɑ mi, bɑ dɑ Yosɛfun mi. ");
INSERT INTO bba_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Sɑnɑm mɛ Yosɛfu u bu wɑ kɑ Bɛnyɑmɛɛ sɑnnu, u win sɔm kowobun wiruɡii sɔ̃ɔwɑ u nɛɛ, ɑ tɔn be duusio nɛn dirɔ. Yen biru ɑ doo ɑ yɑɑ ɡo. Domi sɑnnɑ sɑ ko di sɔ̃ɔ sɔɔ ɡe nɛ kɑ be. ");
INSERT INTO bba_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Mɑ sɔm kowo wi, u kuɑ nɡe mɛ Yosɛfu u nùn sɔ̃ɔwɑ. U kɑ bu dɑ diru mi. ");
INSERT INTO bba_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Ye bɑ wɑ̃ɑ diru mi, yerɑ bɛrum bu mwɑ bɑ tii sɔ̃ɔwɑ bɑ nɛɛ, ɡobi yi bɑ wesiɑ bɛsɛn sɑɑkibɑ sɔɔ, yin sɔ̃nɑ bɑ kɑ sun nɑ mini, kpɑ bu sun mwɑ kɑ dɑm kɑ bɛsɛn kɛtɛkunu, kpɑ su ko ben yobu. ");
INSERT INTO bba_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yerɑ sɑɑ Yosɛfun dii kɔnnɔn di bɑ sɔm kowo wi sɔ̃ɔwɑ bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","yinni, ɑ sun suuru kuo. Ye sɑ ɡbiɑ sɑ nɑ mini sɑ dĩɑnu dwɑ, ");
INSERT INTO bba_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","sɑɑ ye sɑ kɑ nu dɔɔ yɛnuɔ, sɑ yɔ̃rɑ swɑɑɔ su kɑ wɛ̃rɑ. Yerɑ sɑ bɛsɛn sɑɑkibɑ kusiɑ mɑ sɑ deemɑ ɡobi yi sɑ kɔsiɑ kpuro wee, yi wɑ̃ɑ bɛsɛn bɑɑwuren sɑɑki sɔɔ. Yi wee, sɑ kɑ wurɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Domi sɑ ǹ yɛ̃ wi u yi wesiɑ bɛsɛn sɑɑkibɑ sɔɔ. Mɛyɑ sɑ mɑɑ kɑ ɡobi nɑ su kɑ wure su dĩɑnu dwe. ");
INSERT INTO bba_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Sɔm kowo wi, u bu wisɑ u nɛɛ, i ku nɑndɑ, i ku wururɑ. Gusunɔ, bɛɛn bɑɑbɑn Yinniwɑ u bɛɛ yi kɑ̃. Nɑ rɑɑ bɛɛn ɡobi yi mwɑ. Yen biru u bu Simɛɔ yɑrɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Mɑ u bu duusiɑ Yosɛfun yɛnuɔ u derɑ bɑ ben kɔ̃ri kpɑkiɑ, u mɑɑ ben kɛtɛkunu tɑkɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Mɑ Yosɛfun mɑɑ be, bɑ ben kɛ̃nu sɔɔru mɔ̀ sere u kɑ tunumɑ sɔ̃ɔ sɔɔ, domi bɑ nuɑ mɑ sɑnnɑ bɑ koo di kɑ wi. ");
INSERT INTO bba_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Ye Yosɛfu u tunumɑ yerɑ bɑ dɑ bɑ yiirɑ bɑ nùn kɛ̃ɛ ni wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Mɑ u ben ɑlɑfiɑ bikiɑ u nɛɛ, bɛɛn durɔ tɔkɔ wìn ɡɑri i ɡeruɑ mi, u bwɑ̃ɑ do? U wɑ̃ɑ hunde sɔɔ sere kɑ tɛ̃? ");
INSERT INTO bba_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Bɑ nùn wisɑ bɑ nɛɛ, bɛsɛn tundo, wunɛn bɔ̃ɔ u wɑ̃ɑ hunde sɔɔ, u bwɑ̃ɑ do. Mɑ bɑ kpɑm nùn yiirɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Ye Yosɛfu u nɔni seeyɑ u win wɔnɔ Bɛnyɑmɛɛ wɑ, yerɑ u bikiɑ u nɛɛ, bɛɛn wɔnɔ wìn ɡɑri i mɑn sɔ̃ɔwɑ mi, wiyɑ mini? Mɑ u Bɛnyɑmɛɛ domɑru kuɑ u nɛɛ, Gusunɔ u nun durom kuɑ nɛn bii. ");
INSERT INTO bba_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Mɑ u seewɑ fiɑ u bu deri u dɑ u swĩ dii sɔɔwɔ, domi win wɔnɔn kĩrɑ nùn nɛnuɑ too too. ");
INSERT INTO bba_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ye u swĩ u kpɑ, u wubɑ mɑ u yɑrimɑ. Kɑ mɛ, u mɑɑ tii dɑm kɑ̃ɑwɑ u ku kɑ swĩ ben wuswɑɑɔ. Mɑ u woodɑ wɛ̃ bu kɑ dĩɑ ni nɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Mɑ u sinɑ nɛnɛm, win mɑɑbu kɑ wɔnɔ mɑɑ nɛnɛm, Eɡibitiɡii be bɑ rɑ mɑɑ kɑ nùn di, be mɑɑ nɛnɛm. Domi Eɡibitiɡibu bɑ ku rɑ kɑ̃ bu kɑ Heberubɑ di sɑnnu yèn sɔ̃ bɑ bu ɡɑrisi disiɡibu. ");
INSERT INTO bba_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Yosɛfu u win mɑɑ be sinɑsiɑ nɡe mɛ bɑ kɑ kerɑnɛ sɑɑ ɡbiikoon di sere kɑ dɑ̃ɑkowɔ. Mɑ bɑ mɛɛrinɑ kɑ biti ye u kɑ bu sinɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Mɑ bɑ bu dĩɑ ni wɛ̃ɛmɔ ni nu wɑ̃ɑ Yosɛfun tɑbulu wɔllɔ, ɑdɑmɑ Bɛnyɑmɛɛɡinu nu sɑ̃ɑwɑ beɡinun nɔn nɔɔbu. Mɑ bɑ di bɑ nɔrɑ bɑ nuku dobu kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yosɛfu u win yɛnun sɔm kowobun wiruɡii sɔ̃ɔwɑ u nɛɛ, ɑ tɔn ben sɑɑkibɑ yibio nɡe mɛ ben bɑɑwure u koo kpĩ u sɔbe, kpɑ ɑ ben bɑɑwuren ɡobi wesiɑ win sɑɑkiɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Kpɑ ɑ nɛn nɔrɑ ye bɑ kuɑ kɑ sii ɡeesu doke ben yɑ̃kɑbun sɑɑkiɔ kɑ sere mɑɑ win dĩɑnun ɡobi. Sɔm kowo wi, u kuɑ kpuro nɡe mɛ Yosɛfu u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Bururu yɑm sɑ̃reru bɑ bu kɑrɑ bɑ doonɑ kɑ ben kɛtɛkunu. ");
INSERT INTO bba_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Ye bɑ swɑɑ wɔri n ǹ tɛ, yerɑ Yosɛfu u win sɔm kowo wi sɔ̃ɔwɑ u nɛɛ, ɑ tɔn be nɑɑ swĩiyɔ kpɑ ɑ bu sɔ̃ ɑ nɛɛ, mbɑn sɔ̃nɑ bɑ bu ɡeɑ kuɑ mɑ bɑ kɔ̃sɑ wesiɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Bɑ ǹ yɛ̃ mɑ nɔrɑ yerɑ nɛ wunɛn yinni nɑ rɑ kɑ tɑm nɔ, kpɑ n kɑ wɑ ye yɑ wee siɑ? Mbɑn sɔ̃nɑ bɑ kɔ̃sɑ yenin bweseru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Mɑ sɔm kowo wi, u bu nɑɑ swĩi. Ye u bu nɑɑmwɛ, u bu ɡɑri yi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Bɑ nùn wisɑ bɑ nɛɛ, mbɑn sɔ̃nɑ ɑ ɡɑri yinin bweseru ɡeruɑ. Sere kɑ Gusunɔ wi sɑ sɑ̃ɑmɔn yĩsiru, sɑ ǹ yenin bweseru kue. ");
INSERT INTO bba_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Bɛsɛ be sɑ kɑ nun ɡobi yi ɑ duɑri bɛsɛn sɑɑkibɑ sɔɔ nɑɑwɑ sɑɑ Kɑnɑnin di, bɛsɛrɑ sɑ ko mɑɑ sii ɡeesu ǹ kun mɛ wurɑ ɡbɛni wunɛn yinnin dirun di? ");
INSERT INTO bba_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Yen sɔ̃, wìn mi ɑ nɔrɑ ye wɑ, yɛ̃ro u ɡbi, kpɑ bɛsɛ be sɑ tie, su ko wunɛn yobu. ");
INSERT INTO bba_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Mɑ sɔm kowo wi, u bu wisɑ u nɛɛ, yɑ wɑ̃ ye i ɡeruɑ. Adɑmɑ wìn mi nɑ nɔrɑ ye wɑ, wi turowɑ u koo ko nɛn yoo. Bɛɛ be i tie, kpɑ i doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Mɑ ben bɑɑwure u win sɑɑki yi temɔ kɑ sɛndɑru u kusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Mɑ sɔm kowo wi, u nɑ u sɑɑki be mɛɛrɑ mɛɛrɑ sɑɑ bukuroɡiɑn min di n kɑ ɡirɑri ben yɑ̃kɑbuɡiɑɔ. Mɑ u nɔrɑ ye wɑ Bɛnyɑmɛɛn sɑɑkiɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Mɑ bɑ ben tiin yɑbenu nɛnuɑ bɑ kɑsukɑ nuku sɑnkirɑnun sɔ̃. Yerɑ bɑ mɑɑ ben kɛtɛkunu sɔmunu sɔbi bɑ wurɑ wuuɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yudɑ kɑ wiɡibu bɑ tunumɑ Yosɛfun yɛnuɔ bɑ deemɑ u ǹ ɡinɑ yɑrɑ. Mɑ bɑ yiirɑ win wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yosɛfu u bu sɔ̃ɔwɑ u nɛɛ, mbɑn bweserɑ i kuɑ mɛ. I ǹ yɛ̃ mɑ tɔnu nɡe nɛ u koo kpĩ u wɑ ye yɑ wee siɑ? ");
INSERT INTO bba_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Mɑ Yudɑ nùn wisɑ u nɛɛ, yinni, yen yerɑ̀ kon mɑɑ ɡere su kɑ yɑri tɑɑrɛn di. Domi Gusunɔ u sun wɑ mɑ sɑ sɑ̃ɑ tɑɑrɛɡibu. Tɛ̃ ɑ sun mɔɔ su ko wunɛn yobu, bɛsɛ kɑ wìn mi bɑ nɔrɑ ye wɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yerɑ Yosɛfu u nɛɛ, su ku wɑ mɛ bu nɛɛ, nɛnɑ nɑ yen bweseru kuɑ. Adɑmɑ wìn mi bɑ nɔrɑ ye wɑ, wiyɑ u koo ko nɛn yoo. Ǹ n mɛn nɑ, bɛɛ be i tie, i ɡɔsiro yɛnuɔ kɑ bɔri yɛndu i bɛɛn tundo deemɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Mɑ Yudɑ u mɑɑ Yosɛfu susi u nɛɛ, ɑ suuru koowo yinni, nɑ̀ n mɑɑ ɡɑ̃ɑnu ɡeruɑ, ɑ ku mɔru ko, domi ɑ sɑ̃ɑwɑ nɡe Eɡibitin sunɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Yinni, wunɑ ɑ sun bikiɑ ɑ nɛɛ, sɑ tundo mɔ? Sɑ wɔnɔ mɔ? ");
INSERT INTO bba_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Mɑ sɑ nun wisɑ sɑ nɛɛ, sɑ tundo mɔ u tɔkɔ kuɑ, kɑ wɔnɔ turo wi bɑ mɑrɑ tɔkɔru sɔɔ. Bii win mɔɔ u ɡu, wi turowɑ u tie win mɛron berɑ ɡiɑ. Bɛsɛn tundo wi, u mɑɑ nùn kĩ too. ");
INSERT INTO bba_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Ye sɑ yeni ɡeruɑ, yinni, mɑ ɑ nɛɛ, su kɑ nùn nɑ wunɛn mi, ɑ nùn wɑ kɑ nɔni. ");
INSERT INTO bba_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Mɑ sɑ wisɑ sɑ nɛɛ, n ǹ koorɔ bii wi, u bɛsɛn tundo deri, domi ù n nùn deri, tundo wi, u koo ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Mɑ ɑ sun sɔ̃ɔwɑ ɑ nɛɛ, sɑ̀ kun kɑ nùn sisi, su ku rɑ nɛ wunɛn mi. ");
INSERT INTO bba_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Sɑɑ ye sɑ turɑ bɛsɛn tundon mi, sɑ wunɛn ɡɑri yi nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Sɔ̃ɔ mɛɛrun biru mɑ u nɛɛ, su ɡɔsirɑmɑ mini su kɑ mɑɑ nùn dĩɑnu dwiɑ fiiko. ");
INSERT INTO bba_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Yerɑ sɑ nùn wisɑ sɑ nɛɛ, sɑ ǹ dɔɔ mɑ n kun mɔ kɑ bɛsɛn wɔnɔ sɑnnu, domi sɑ ǹ kpɛ̃ su nɑ wunɛn wuswɑɑɔ n kun kɑ wi. ");
INSERT INTO bba_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Mɑ bɛsɛn tundo u sun sɔ̃ɔwɑ u nɛɛ, sɑ yɛ̃ mɑ bibu yiruwɑ win kurɔ Rɑsɛli u nùn mɑruɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Ben turo u yɑrɑ yɛnun di, u ǹ mɑɑ nùn wɑ sere kɑ ɡisɔ. U yĩiyɔ mɑ ɡbeeku yɑɑ yɑ nùn sɛ̃re yɑ kɑsukɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Yen sɔ̃, sɑ̀ n mɑɑ nùn yiruse wi suɑri, ù n nuɑ wɑhɑlɑ ɡɑɑ yɑ nùn deemɑ, nuku sɑnkirɑnu koo be nùn ɡo, domi u tɔkɔ kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","31","Yen sɔ̃ tɛ̃, yinni, nɑ̀ n wurɑ bɛsɛn tundon mi, bii wi sɑri, sɑ ko de durɔ tɔkɔ te, tu ɡbi kɑ nuku sɑnkirɑnu bii win kĩrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Yen biru nɛ wi nɑ ɡɑri mɔ̀ mini, nɛnɑ nɑ tii bii wi sɔbi, domi nɑ nɛɛ, nɑ̀ kun kɑ nùn wurɑmɛ, n kuɑ nɛn sɔmunu sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Yen sɔ̃ tɛ̃, nɑ nun kɑnɑmɔ ɑ mɑn koowo yoo bii win ɑyerɔ, kpɑ wi kɑ be bɑ tie bu ɡɔsirɑ yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Domi nɑ ǹ yɛ̃ ɑmɔnɑ kon bɛsɛn tundo tusiɑ nɑ̀ n sĩɑ bii wi sɑri. Gusunɔ u ku de nɛn nɔni yi wɑ kɔ̃sɑ ye yɑ koo durɔ tɔkɔ te deemɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Yosɛfu u den kpɑnɑ u tii nɛnɛ Eɡibitiɡii be bɑ wɑ̃ɑ mi kpuron wuswɑɑɔ. Yerɑ u woodɑ wɛ̃ u nɛɛ, bu yɑrio min di. Mɑ be kpuro bɑ yɑrɑ bɑ bu deri wi kɑ win mɑɑbu u kɑ tii bu tusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","U wurɑ kuɑ sere Eɡibitiɡii be bɑ wɑ̃ɑ turuku mi, bɑ ye nuɑ, mɑ bɑ ye sunɔn yɛnuɡibu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yosɛfu u win mɑɑbu kɑ wɔnɔ wi sɔ̃ɔwɑ u nɛɛ, nɛnɑ Yosɛfu. Bɛsɛn bɑɑbɑ u wɑ̃ɑ hunde sɔɔ? Adɑmɑ bɑ kpɑnɑ bu nùn wisi domi bɛrum bu mwɑ win wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Mɑ u nɛɛ, i suuru koowo i susimɑ nɛn bɔkuɔ. Ye bɑ nùn susi, yerɑ u bu sɔ̃ɔwɑ u nɛɛ, nɛnɑ bɛɛn wɔnɔ Yosɛfu wi i dɔrɑ bɑ kɑ nɑ Eɡibiti mini. ");
INSERT INTO bba_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Tɛ̃, i ku nuki sɑnkirɑ, i ku mɑɑ tɑɑrɛ wɛ̃ɛnɑ ye i kɑ mɑn dɔrɑ. Domi Gusunɔwɑ u derɑ nɑ nɑ mini n kɑ bɛɛ fɑɑbɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Wee, ɡɔ̃ɔ ten wɔ̃ɔ yirusewɑ sɑ dɔɔ mini. N mɑɑ tie wɔ̃ɔ nɔɔbu yè sɔɔ ɡoo kun kpɛ̃ u duure u sere ɡɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Gusunɔn sinɑrɑ nɑ kɑ nɑ tem mini n kɑ bɛɛ dĩɑnu beruɑ kpɑ n bɛɛ yɑrɑ ɡɔ̃ɔ ten di n bɛɛn bweseru fɑɑbɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","N ǹ bɛɛ i derɑ nɑ nɑ mini. Gusunɔwɑ u derɑ nɑ nɑ, mɑ u mɑn kuɑ Eɡibiti sunɔn yɛnu yɛ̃ro kɑ win ye u mɔ kpuron wiruɡii kɑ sere mɑɑ tem mɛn wiruɡii. ");
INSERT INTO bba_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Yen sɔ̃, i ɡɔsiro fuuku bɛsɛn tundon mi, i nùn sɔ̃ i nɛɛ, ɑmɛniwɑ nɛ win bii Yosɛfu nɑ ɡeruɑ, Gusunɔ u mɑn kuɑ Eɡibitin tem wiruɡii, u de u nɑ fuuku. ");
INSERT INTO bba_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ù n nɑ kon de u sinɑ Gosɛniɔ kpɑ u n wɑ̃ɑ nɛn bɔkuɔ, wi kɑ win bibu kɑ win debuminu kɑ win yɑ̃ɑnu kɑ win kɛtɛbɑ kɑ win ye u mɔ kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Yèn bukɑtɑ u mɔ kpuro kon nùn wɛ̃, domi ɡɔ̃ɔrɑ mɑɑ tie wɔ̃ɔ nɔɔbu. Ù n wɑ̃ɑ nɛn bɔkuɔ, ɡɔ̃ɔ te, tɑ ǹ mɑɑ bu ɡoomɔ kɑ win yɛnuɡibu kɑ win ye u mɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Bɛɛ kpuro kɑ wunɛn tii Bɛnyɑmɛɛ, i wɑ kɑ nɔni mɑ nɛnɑ Yosɛfu, nɛ wi nɑ kɑ bɛɛ ɡɑri mɔ̀ mini. ");
INSERT INTO bba_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ǹ n mɛn nɑ, i doo i bɛsɛn tundo sɔ̃ nɡe mɛ nɛn yiiko yɑ nɛ Eɡibitiɔ kɑ ye i wɑ mini kpuro. I doo fuuku i nùn tɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Yen biru Yosɛfu u win wɔnɔ Bɛnyɑmɛɛ nɛnuɑ u bɔkɑsi wĩirɔ, mɑ u swĩ. Bɛnyɑmɛɛn tii u mɑɑ swĩ mi bɑ bɔkɑsinɛ. ");
INSERT INTO bba_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Ye u Bɛnyɑmɛɛ yɔ̃su, yerɑ u win mɑɑ ben bɑɑwure bɔkɑsi u sɔ̃su u kɑ swĩisimɔ. Yen biruwɑ bɑ kɑ nùn ɡɑri kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Ye Eɡibiti sunɔn yɛnuɡibɑ nuɑ mɑ Yosɛfun mɑɑbɑ tunumɑ, yerɑ yɑ sunɔn tii kɑ win tɔmbu dore. ");
INSERT INTO bba_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Mɑ u Yosɛfu sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn mɑɑ be sɔ̃ɔwɔ bu ben kɛtɛkunu sɔmunu sɔbio bu dɑ Kɑnɑnin temɔ ");
INSERT INTO bba_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","bu kɑ bɛɛn tundo kɑ bɛɛn yɛnuɡibu nɑ nɛn turuku. Kon bu tem ɡem wɛ̃ kpɑ bɑ n dĩɑ ɡeenu mɔ bɑ n dimɔ. ");
INSERT INTO bba_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","A mɑɑ bu sɔ̃ɔwɔ bu Eɡibitin sɑrɛtibɑ suo bu kɑ dɑ bu bɛɛn tundo kɑ ben kurɔbu kɑ ben bibu suɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Bu ku wururɑ ben ye bɑ koo derin sɔ̃, domi ɡɑ̃ɑ ni nu ɡeɑ sɑ̃ɑ Eɡibiti mini, niyɑ nu koo ko beɡinu. ");
INSERT INTO bba_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Mɑ Isirelin bii be, bɑ kuɑ mɛ. Yosɛfu u bu sɑrɛtibɑ wɛ̃ mɑ u bu dĩɑnu kusenu kuɑ ni bɑ koo di swɑɑɔ nɡe mɛ sunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","U ben bɑɑwure yɑbe kpɑɑru kɑ̃. Adɑmɑ yɑbe kpɑɑnu nɔɔbuwɑ u Bɛnyɑmɛɛ kɑ̃ kɑ sii ɡeesun ɡobi ɡoobɑ wunɔbu (300). ");
INSERT INTO bba_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Mɑ u ben tundo Eɡibitin ɡɑ̃ɑ ɡeenu mɔrisiɑ u nu kɛtɛkunu wɔkuru sɔbi. U dĩɑnu suɑ u bu wɛ̃ kɑ kuse ni bɑ koo di swɑɑɔ bɑ̀ n wee Eɡibitiɔ. Mɑ u mɑɑ ni kɛtɛku ninu wɔkuru sɔbi. ");
INSERT INTO bba_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Yen biru u derɑ win mɑɑ be, bɑ swɑɑ wɔri. Mɑ u bu sɔ̃ɔwɑ u nɛɛ, i suuru koowo, i ku rɑ sɑnnɑ swɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Mɑ bɑ doonɑmɑ sɑɑ Eɡibitin di bɑ nɑ ben tundo Yɑkɔbun mi Kɑnɑniɔ. ");
INSERT INTO bba_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Ye bɑ turɑ, bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ, Yosɛfu kun ɡu, u wɑsi. Wiyɑ u mɑm Eɡibitin tem kpuro kpɑre. Ye Yɑkɔbu u nuɑ mɛ, u kpɑnɑ u bu wisi, domi u ǹ nɑɑnɛ kue ye bɑ nùn sɔ̃ɔmɔ. ");
INSERT INTO bba_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Adɑmɑ ye bɑ nùn kpuro sɑɑriɑ ye Yosɛfu u bu sɔ̃ɔwɑ, mɑ u sɑrɛti be wɑ be u mɔrisiɑmɑ bu kɑ nùn suɑmɑ, yerɑ win bwɛ̃rɑ den yɛmiɑ mɑ win dɑm wurɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Yerɑ u nɛɛ, wee tɛ̃, nɛn bii Yosɛfu u wɑ̃ɑ hunde sɔɔ, nɛn bwɛ̃rɑ kpunɑ tɛ̃. Kon dɑ n nùn wɑ n sere ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Yɑkɔbu wi bɑ mɔ̀ Isireli u seewɑ u swɑɑ wɔri kɑ ye u mɔ kpuro u turɑ Beri Sebɑɔ. Miyɑ u Gusunɔ yɑ̃kuru kuɑ nɡe mɛ win tundo Isɑki u rɑ rɑɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Yerɑ wɔ̃kuru Gusunɔ u kɑ nùn ɡɑri kuɑ kɑ̃siru sɔɔ u nɛɛ, Yɑkɔbu, Yɑkɔbu. Mɑ u wurɑ u nɛɛ, nɛ wee. ");
INSERT INTO bba_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Mɑ Gusunɔ u nɛɛ, nɛnɑ Gusunɔ, wunɛn tundon Yinni. A ku bɛrum ko, ɑ doo Eɡibiti mi, domi miyɑ kon nun ko bwese bɑkɑrun nuuru. ");
INSERT INTO bba_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Nɛn tii kon kɑ nun dɑ kpɑ n mɑɑ kɑ nun wurɑmɑ. Yosɛfun nɔmu sɔɔrɑ kɑɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","6","Yɑkɔbu kɑ win tɔmbu kpuro bɑ seewɑ Beri Sebɑn di, mɑ win bibɑ nùn doke sɑrɛti sɔɔ kɑ ben tiin bibu kɑ ben kurɔbu. Sɑrɛti be, Eɡibiti sunɔwɑ u bu mɔrisiɑmɑ bu kɑ bu suɑ. Yen biru bɑ ben yɑɑ sɑbenu ɡurɑ kɑ ben dukiɑ ye bɑ wɑ Kɑnɑnin temɔ. Mɑ bɑ doonɑ Eɡibitiɔ, ");
INSERT INTO bba_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","wi kɑ win bii tɔn durɔbu kɑ tɔn kurɔbu kɑ mɑɑ win debuminu, win yɛnuɡibu kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Be bɑ sɑ̃ɑ Yɑkɔbun bweseru be bɑ nɑ Eɡibitiɔ, ben yĩsɑ wee. Rubɛni, win bii ɡbiikoo, ");
INSERT INTO bba_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","kɑ win bibu Enɔku kɑ Pɑɑlu kɑ Hɛsironi kɑ Kɑɑmi. ");
INSERT INTO bba_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simɛɔ kɑ win bibu Yɛmuɛli kɑ Yɑmini kɑ Ohɑdi kɑ Yɑkini kɑ Sokɑɑ kɑ sere Sɔɔlu wìn mɛro u sɑ̃ɑ Kɑnɑniɡii. ");
INSERT INTO bba_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Lefi mɑɑ kɑ wiɡibu Gɛɛsɔni kɑ Kehɑti kɑ Mɛrɑri. ");
INSERT INTO bba_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Yudɑ kɑ wiɡibu Eri kɑ Onɑni kɑ Selɑ kɑ Perɛsi kɑ Serɑki. Adɑmɑ Eri kɑ Onɑni bɑ ɡu Kɑnɑnin temɔ. Mɑ ben wɔnɔ Perɛsi wi, u Hɛsironi mɑrɑ kɑ Hɑmulu. ");
INSERT INTO bba_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isɑkɑri kɑ mɑɑ wiɡibu Tolɑ kɑ Pufɑ kɑ Yoobu kɑ Simuroni. ");
INSERT INTO bba_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Sɑbuloni mɑɑ kɑ wiɡibu Serɛdi kɑ Eloni kɑ Yɑlɛɛli. ");
INSERT INTO bba_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Beni kɑ sere win bii tɔn kurɔ Dinɑ bɑ sɑ̃ɑ Leɑn bibu be u Yɑkɔbu mɑruɑ Pɑdɑnɑrɑmuɔ. Be kɑ ben bibu bɑ sɑ̃ɑwɑ mi tɔnu tɛnɑ kɑ itɑ. ");
INSERT INTO bba_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Gɑdi kɑ mɑɑ wiɡibu Sifioni kɑ Hɑɡi kɑ Suni kɑ Ɛsiboni kɑ Eri kɑ Arodi kɑ Areli. ");
INSERT INTO bba_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Asɛɛ kɑ mɑɑ wiɡibu Yiminɑ kɑ Yisifɑ kɑ Yisifi kɑ Beriɑ kɑ ben sesu Serɑki. Mɑ Beriɑ u Heberu mɑrɑ kɑ Mɑɑkiɛli. ");
INSERT INTO bba_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Berɑ bɑ sɑ̃ɑ Yɑkɔbun bweseru be bɑ mɑɑ mɑrurɑ Silipɑn min di. Be kpuro bɑ sɑ̃ɑwɑ tɔnu wɔkurɑ nɔɔbu kɑ tiɑ. Silipɑ wi, u sɑ̃ɑwɑ Leɑn yoo wi Lɑbɑni win tundo u nùn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Yosɛfu kɑ Bɛnyɑmɛɛwɑ bɑ sɑ̃ɑ Rɑsɛlin bibu. ");
INSERT INTO bba_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Yosɛfu u wɑ̃ɑwɑ Eɡibitiɔ u kɑ Mɑnɑse kɑ Efɑrɑimu mɑrɑ. Bii ben mɛron yĩsirɑ Asinɑti. U sɑ̃ɑwɑ Potiferɑ, Onin yɑ̃ku kowon bii. ");
INSERT INTO bba_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Mɑ Bɛnyɑmɛɛ u seewɑ u Belɑ mɑrɑ kɑ Bekɛɛ kɑ Asibɛli kɑ Gerɑ kɑ Nɑmɑni kɑ Ehi kɑ Rɔsi kɑ Mupimu kɑ Hupimu kɑ Aɑdu. ");
INSERT INTO bba_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Be bɑ sɑ̃ɑ Yɑkɔbun bweseru be bɑ mɑɑ mɑrurɑ Rɑsɛlin min di, berɑ mi. Be kpuro bɑ kuɑwɑ tɔnu wɔkurɑ nnɛ. ");
INSERT INTO bba_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Bilihɑ u bibu yiru mɑrɑ, beyɑ Dɑnu kɑ Nɛfitɑli. Dɑnu u seewɑ u Husimu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Nɛfitɑli u mɑɑ seewɑ u Yɑsɛɛli kɑ Guni kɑ Yesɛɛ kɑ Silɛmu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Berɑ bɑ sɑ̃ɑ Yɑkɔbun bweseru be bɑ mɑɑ mɑrurɑ Bilihɑn min di. Be kpuro bɑ sɑ̃ɑwɑ mi tɔmbu nɔɔbɑ yiru. Bilihɑ wi, u sɑ̃ɑwɑ Rɑsɛlin yoo wi Lɑbɑni win tundo u nùn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Tɔn be bɑ kɑ Yɑkɔbu dɑ Eɡibitiɔ be bɑ sɑ̃ɑ win tiin yɛm, bɑ sɑ̃ɑwɑ tɔnu wɑtɑ kɑ nɔɔbɑ tiɑ, win bibun kurɔbu bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","N deemɑ Yosɛfu u mɑɑ bibu yiru mɑrɑ Eɡibiti mi. Mɑ Yɑkɔbun tɔmbu be bɑ sɑ̃ɑ win yɛm bɑ kɑ wɑ̃ɑ Eɡibitiɔ, ben ɡeerɑ kuɑ tɔnu wɑtɑ kɑ wɔkuru. ");
INSERT INTO bba_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Ye bɑ sisi mi, yerɑ Yɑkɔbu u Yudɑ ɡɔrɑ u dɑ u Yosɛfu sɔ̃ mɑ u dɔɔ Gosɛni ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Mɑ Yosɛfu u win kɛkɛ ye dumi ɡɑwe duɑ u kɑ dɑ Gosɛniɔ u kɑ win tundo Isireli yinnɑ. Ye bɑ yinnɑ u nùn ɡɑbɑ wĩirɔ u bɔkɑsi mɑ u swĩisi n kɑ tɛ. ");
INSERT INTO bba_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Mɑ Yɑkɔbu wi bɑ mɑɑ sokumɔ Isireli, u Yosɛfu sɔ̃ɔwɑ u nɛɛ, bɑɑ nɑ̀ n ɡu ɡisɔ, yɑ ǹ tɑɑrɛ, domi nɑ wunɛn wuswɑɑ wɑ, nɑ mɑɑ wɑ mɑ ɑ wɑ̃ɑ hunde sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yerɑ Yosɛfu u win mɑɑbu kɑ sere mɑɑ win tundon yɛnuɡii be bɑ tie sɔ̃ɔwɑ u nɛɛ, nɑ kon dɑ n sunɔ nɔɔsiɑ mɑ bɛɛ nɛn tundon yɛnuɡibu i tunumɑ, bɛɛ be i rɑɑ wɑ̃ɑ Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Kon nùn sɔ̃ mɑ yɑɑ sɑbenun sɔmburɑ i rɑ ko. I mɑɑ kɑ bɛɛn yɑ̃ɑnu kɑ bɛɛn kɛtɛbɑ nɑ, kɑ sere bɛɛn ye i mɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Yen sɔ̃, ù n dɑ bɛɛ bikiɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","sɔmbu terɑ̀ i rɑ ko, i nùn wisio i nɛɛ, yɑɑ sɑbenun nɔɔribɑ bu sɑ̃ɑ bɛɛn sɔmburu sɑɑ bɛɛn birun di sere kɑ ɡisɔ, bɛɛ kɑ bɛɛn bɑɑbɑbɑ. Nɡe mɛyɑ i ko wɑ i kɑ sinɑ Gosɛnin temɔ, domi Eɡibitiɡibɑ ku rɑ sɑbe kpɑrobu kɑ̃. ");
INSERT INTO bba_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","2","Yen biruwɑ Yosɛfu u win mɑɑ ben nɔɔbu suɑ bɑ dɑ Eɡibiti sunɔn mi. Mɑ Yosɛfu u nùn sɔ̃ɔwɑ u nɛɛ, nɛn mɑɑbu kɑ nɛn tundo bɑ nɑ sɑɑ Kɑnɑnin tem di kɑ ben yɑ̃ɑnu kɑ ben kɛtɛbɑ kɑ ben ye bɑ mɔ kpuro. Wee, bɑ wɑ̃ɑ Gosɛnin temɔ. Mɑ u win mɑɑ be Eɡibiti sunɔ tusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Sunɔ wi, u bu bikiɑ u nɛɛ, sɔmbu terɑ̀ i rɑ ko. Bɑ nùn wisɑ bɑ nɛɛ, yɑɑ sɑbenɑ sɑ rɑ kpɑre, yinni. Mɛyɑ mɑɑ bɛsɛn bɑɑbɑbɑn tii. ");
INSERT INTO bba_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Bɑ mɑɑ nɛɛ, sɑ nɑwɑ su kɑ sinɑ tem mi, domi yɑkɑ bekusu sɑri si bɛsɛn yɑɑ sɑbenu koo di, yèn sɔ̃ ɡɔ̃ɔ te, tɑ Kɑnɑnin tem nɛni. Yen sɔ̃nɑ sɑ nun kɑnɑmɔ ɑ de su sinɑ Gosɛnin temɔ. ");
INSERT INTO bba_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Yerɑ sunɔ wi, u Yosɛfu sɔ̃ɔwɑ u nɛɛ, wee, wunɛn tundo kɑ wunɛn mɑɑbu bɑ wɔmɑ wunɛn mi. ");
INSERT INTO bba_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Eɡibitin tem kpuro wee wunɛn nɔmuɔ. A de bu sinɑ Gosɛniɔ, domi min temɑ mu ɡeɑ sɑ̃ɑ. À n mɑɑ yɛ̃ ɡɑbɑ kpɑrɑbun hɑniɑ mɔ be sɔɔ, ɑ bu nɛn yɑɑ sɑbenu nɔmu sɔndio. ");
INSERT INTO bba_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Yen biru Yosɛfu u kɑ win tundo Yɑkɔbu dɑ Eɡibiti sunɔn mi, bɑ tɔbirinɑ. Mɑ Yɑkɔbu u sunɔ wi domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Yerɑ sunɔ u nùn bikiɑ u nɛɛ, wunɛn wɔ̃ɔ nyewɑ mini. ");
INSERT INTO bba_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yɑkɔbu u nùn wisɑ u nɛɛ, nɛn wɔ̃ɔ wunɑɑ teeru kɑ wɔkurɑ mi, mìn di nɑ hɑnduniɑ duɑ, nɑ mɑɑ sirenɛwɑ. Nɛn wɔ̃ɔ ɡɑ ǹ dɑbi, ɡɑ ǹ mɑɑ nuku dobu mɔ, mɛyɑ ɡɑ ǹ mɑɑ nɛn bɑɑbɑbɑɡuu turɑ ɡe bɑ kuɑ sɑnɑm mɛ bɑ wɑ̃ɑ hunde sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Mɑ Yɑkɔbu u kpɑm sunɔ domɑru kuɑ bɑ sere yɑrɑ win min di. ");
INSERT INTO bba_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yosɛfu u win tundo kɑ win mɑɑbu sin yeru kuɑ, u bu tem wɛ̃ Rɑmusɛsin berɑ ɡiɑ mi n ɡeɑ bo Eɡibitin tem sɔɔ, nɡe mɛ sunɔ u rɑɑ nùn sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Mɑ u win tundon yɛnuɡii be kpuro dĩɑnu wɛ̃ nɡe mɛ ben ɡeerɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Sɑnɑm dɔɔ sɑnɑm wee, ɡɔ̃ɔrɑ kpɛ̃ɑ tem mɛ sɔɔ. Bɑɑ dĩɑ burɑ kun mɑɑ wɑ̃ɑ. Eɡibitiɡibu kɑ Kɑnɑnibɑ bɑ wururɑwɑ kpuro ɡɔ̃ɔ ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Bɑ kɑ ben ɡobi kpuro dĩɑnu dwɑ. Mɑ Yosɛfu u ɡobi yi mɛnnɑ u yi sunɔn yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Sɑnɑm mɛ ɡobi kpɑ Eɡibitiɔ kɑ Kɑnɑniɔ, Eɡibitiɡibu kpuro bɑ nɑ bɑ Yosɛfu deemɑ bɑ nɛɛ, ɑ sun dĩɑnu wɛ̃ɛmɑ. Mbɑn sɔ̃nɑ sɑ ko ɡbi ɑ n sun mɛɛrɑ, domi bɛsɛn ɡobi kpɑ. ");
INSERT INTO bba_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yosɛfu u bu sɔ̃ɔwɑ u nɛɛ, ì kun ɡobi mɔ, i mɑn bɛɛn yɑɑ sɑbenu wɛ̃ɛmɑ kpɑ n bɛɛ dĩɑnu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Bɑ kɑ ben dumi kɑ yɑ̃ɑnu kɑ bonu kɑ nɛɛ kɑ kɛtɛkunu Yosɛfu nɑɑwɑ. Mɑ u kɑ ye kpuro bu dĩɑnu kɔsinɑ. Nɡe mɛyɑ bɑ kɑ ben sɑbenu kpuro dĩɑnu kɔsinɑ wɔ̃ɔ ɡe. ");
INSERT INTO bba_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Ye wɔ̃ɔ ɡe, ɡɑ doonɑ, bɑ kpɑm nɑ Yosɛfun mi, bɑ nɛɛ, yinni, sɑ ǹ kpɛ̃ su nun ɡɑ̃ɑnu beruɑ. Bɛsɛn ɡobi kpɑ, bɛsɛn yɑɑ sɑbenu kpuro mɑɑ wɑ̃ɑ wunɛn mi. A yɛ̃ mɑ ɡɑ̃ɑnu kun mɑɑ sun tie mɑ n kun mɔ bɛsɛn wɑsi kɑ bɛsɛn ɡbeɑ. ");
INSERT INTO bba_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Mbɑn sɔ̃nɑ kɑɑ n sun mɛɛrɑ sɑ n ɡbiɔ, kpɑ bɛsɛn ɡbeɑ yu kɑm ko. Yen sɔ̃, ɑ kɑ sun dĩɑnu kɔsinɔ kpɑ bɛsɛn ɡbeɑ yu ko sunɔɡiɑ kpɑ su ko win yobu. A sun dĩɑ bweseru wɛ̃ɛyɔ su duure ni sɑ ko rɑ di sɑ n kɑ wɑ̃ɑ, kpɑ ɡbeɑ ye, yu ku ko ɡbee diinu. ");
INSERT INTO bba_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Mɑ Yosɛfu u Eɡibitiɡibun ɡbeɑ kpuro sunɔ dwiɑ, domi ɡɔ̃ɔrɑ derɑ bɑ nùn ye dɔre. Yerɑ tem mɛ kpuro mu kuɑ sunɔɡim. ");
INSERT INTO bba_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Mɑ Yosɛfu u tɔmbu kpuro yɑrinɑsiɑ u bu yoo sɔmburu koosiɑ Eɡibitin tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Adɑmɑ u ǹ yɑ̃ku kowobun ɡbeɑ dwɑ, domi Eɡibiti sunɔ u woodɑ ɡɑɑ mɔ ye yɑ derɑ u rɑ bu dĩɑnu wɛ̃. Yen sɔ̃nɑ bɑ ǹ ben ɡbeɑ dɔre. ");
INSERT INTO bba_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Mɑ Yosɛfu u tɔmbu sɔ̃ɔwɑ u nɛɛ, ɡisɔ nɑ bɛɛ dwɑ bɛɛ kɑ bɛɛn ɡbeɑ i kuɑ sunɔn yobu. Wee, nɑ bɛɛ dĩɑ bweseru wɛ̃ɛmɔ i kɑ duure ɡbeɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Sɑnɑm mɛ dĩɑnu rɑ ye, i nu bɔnu koowo subɑ nɔɔbu, i sunɔ sube teeru wɛ̃ kpɑ i subɑ nnɛ tii yiiyɑ. Mi sɔɔrɑ ko i bweseru wunɑ i kɑ duure kpɑ i ye yɑ tie di, bɛɛ kɑ bɛɛn tɔmbu. ");
INSERT INTO bba_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Mɑ bɑ nɛɛ, wunɛn durom mɛ, mu sun fɑɑbɑ kuɑ. Tɛ̃ sɑ ko ko sunɔn yobu. ");
INSERT INTO bba_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Nɡe mɛyɑ Yosɛfu u kɑ woodɑ yeni yi, ye yɑ nɛɛ, bɑ n dɑ Eɡibitin ɡbeɑn dĩɑnu bɔnu ko subɑ nɔɔbu kpɑ sube teeru tu ko sunɔɡiru. Woodɑ ye, yɑ wɑ̃ɑ sere kɑ ɡisɔ. Yɑ̃ku kowobun ɡbeɑ tɔnɑwɑ yɑ ǹ kue wiɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Yɑkɔbu wi bɑ mɑɑ sokumɔ Isireli kɑ wiɡibu bɑ sinɑ Eɡibitin temɔ Gosɛnin berɑ ɡiɑ. Bɑ dukiɑ kpɑɑsinɑmɔ mi, bɑ mɑrurɑmɔ bɑ dɑbiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yɑkɔbu u kuɑ wɔ̃ɔ wɔkurɑ nɔɔbu kɑ yiru Eɡibitin temɔ. Mɑ win wɑ̃ɑrun sɑnɑm kpuro mu kuɑ wɔ̃ɔ wunɑɑ weeru kɑ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Ye win ɡɔɔ turuku kuɑ, u win bii Yosɛfu sokɑ u nùn sɔ̃ɔwɑ u nɛɛ, nɑ̀ n wunɛn kĩi ɡeeru wɑ, nɑ nun kɑnɑmɔ, ɑ wunɛn nɔmu dokeo nɛn tɔbuɔ ɑ kɑ bɔ̃re mɑ ɑ ǹ mɑn sikumɔ Eɡibitin tem mini. ");
INSERT INTO bba_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Sɑnɑm mɛ kon kpunɑ n ɡbi n nɛn bɑɑbɑbɑ deemɑ, ɑ nɛn ɡoru suo ɑ kɑ yɑri Eɡibitin di kpɑ ɑ tu sike ben sikɑɔ. Yosɛfu u nùn wisɑ u nɛɛ, kon ko nɡe mɛ ɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yɑkɔbu nɛɛ, ɑ bɔ̃ruo. Mɑ Yosɛfu u bɔ̃ruɑ. Yen biru Yɑkɔbu u yiirɑ win kpin yerun wiru ɡiɑ u Gusunɔ siɑrɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yenibɑ kpuron biru bɑ nɑ bɑ Yosɛfu sɔ̃ɔwɑ mɑ win tundo kun bwɑ̃ɑ do. Yerɑ u win bibu yiru Mɑnɑse kɑ Efɑrɑimu suɑ bɑ dɑ mi. ");
INSERT INTO bba_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Ye bɑ Yɑkɔbu nɔɔsiɑ mɑ win bii Yosɛfu u nɑ win mi, yerɑ u kookɑri kuɑ u seewɑ u sinɑ win kpinu wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Mɑ u Yosɛfu sɔ̃ɔwɑ u nɛɛ, Gusunɔ Dɑm kpuroɡii u mɑn kure Lusiɔ Kɑnɑnin temɔ mɑ u mɑn domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","U nɛɛ, kon mɑrurɑ n dɑbiɑ kpɑ n ko bwese dɑbirun nuuru kpɑ u nɛn bibun bweseru tem mɛ wɛ̃ bɑ n mu mɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Tɛ̃, Yosɛfu, wunɛn bibu yiru beni, Mɑnɑse kɑ Efɑrɑimu be bɑ nun mɑruɑ Eɡibitin tem mini n kɑ sere nun swĩimɑ mi, bɑ kuɑ nɛɡibu. Nɑ bu mɛɛrɑ nɡe Rubɛni kɑ Simɛɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Adɑmɑ bii be ɑ mɑrɑ benin biru, berɑ bɑ ko n sɑ̃ɑ wunɛɡibu. Ben mɑɑbun yĩsɑ bɑ koo kɑ tubi di. ");
INSERT INTO bba_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Nɑ yeni mɔ̀wɑ yèn sɔ̃ nɑ wunɛn mɛro Rɑsɛli kĩ. Ye sɑ wee Pɑdɑnin di u mɑn ɡbiiriwɑ swɑɑɔ Kɑnɑnin temɔ ye n tie fiiko su kɑ Efɑrɑtɑ du. Miyɑ nɑ nùn sikɑ. Efɑrɑtɑ yerɑ bɑ mɔ̀ Bɛtelehɛmu. ");
INSERT INTO bba_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Mɑ Isireli u Yosɛfun bibu mɛɛrɑ u nɛɛ, berɑ̀ mini. ");
INSERT INTO bba_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yosɛfu u win tundo wisɑ u nɛɛ, nɛn bibɑ mi, be Gusunɔ u mɑn kɑ̃. Mɑ Isireli u nɛɛ, ɑ de bu susimɑ nɛn bɔkuɔ kpɑ n bu domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","N deemɑ Isirelin nɔni dɑm dwiiyɑ tɔkɔrun sɔ̃. U ǹ mɑɑ kpɛ̃ u yɑm wɑ sɑ̃ɑ sɑ̃ɑ. Yen sɔ̃nɑ Yosɛfu u bu susisiɑ win bɔkuɔ. Mɑ Isireli u ben bɑɑwure bɔkɑsi u sɔ̃su. ");
INSERT INTO bba_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","U Yosɛfu sɔ̃ɔwɑ u nɛɛ, nɑ ǹ dɑɑ mɑɑ yĩiyɔ n nun wɑ. N wee, sere kɑ wunɛn bibɔ Gusunɔ u derɑ nɑ wɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Mɑ Yosɛfu u bii be seeyɑ sɑɑ win tundon tɑɑrun kɔkɔrun di, mɑ win tii u yiirɑ win wuswɑɑɔ u siriru tem turɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yen biru u Efɑrɑimu yɔ̃rɑsiɑ Isirelin nɔm dwɑrɔ, Mɑnɑse mɑɑ win nɔm ɡeuɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Adɑmɑ Isireli u win nɔm ɡeu dɛmiɑ u sɔndi Efɑrɑimun wirɔ wi u sɑ̃ɑ yɑ̃kɑbu. Mɑ u win nɔm dwɑru sɔndi Mɑnɑsen wirɔ. N deemɑ Isireli u yɛ̃ sɑ̃ɑ sɑ̃ɑ ye u mɔ̀. U yɛ̃ mɑ Mɑnɑsewɑ u sɑ̃ɑ yerumɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Mɑ u Yosɛfu domɑru kuɑ u nɛɛ, Gusunɔ wìn wuswɑɑɔ nɛn bɑɑbɑbɑ Aburɑhɑmu kɑ Isɑki bɑ ben wɑ̃ɑru di, wiyɑ u mɑn kpɑrɑ sɑɑ nɛn mɑrubun di sere kɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Win ɡɔrɑdo u mɑɑ mɑn wɔrɑ kɔ̃sɑ kpuron di. Gusunɔ wiyɑ u koo wunɛn bii beni domɑru kuɑ. Nɛn yĩsiru kɑ nɛn bɑɑbɑbɑ Aburɑhɑmu kɑ Isɑkin yĩsinɑ bɑ koo kɑ bu soku, kpɑ bu mɑrurɑ bu dɑbiɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Sɑnɑm mɛ Yosɛfu u wɑ mɑ win tundo u win nɔm ɡeu sɔndi Efɑrɑimun wirɔ, win nukurɑ kun dore, yerɑ u nɔmu ɡe nɛnuɑ u ɡɑwɑ Efɑrɑimun wirun di u sɔndi Mɑnɑsen wirɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Mɑ u nùn sɔ̃ɔwɑ u nɛɛ, n ǹ mɛ bɑɑbɑ, domi winiwɑ u sɑ̃ɑ yerumɑ. A wunɛn nɔm ɡeu sɔndio win wirɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Adɑmɑ u yinɑ u nɛɛ, nɑ yɛ̃ mɛ, nɛn bii, nɑ yɛ̃. Win tii u koo mɑɑ ko bwese bɑkɑrun nuuru. Adɑmɑ win wɔnɔ koo nùn kerɑ. Wiyɑ u koo ko bwese dɑbinun nuuru. ");
INSERT INTO bba_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","U bu domɑru kuɑ dɔmɑ te, u nɛɛ, Isirelibɑ bɑ̀ n domɑru mɔ̀, bɛɛn yĩsɑ bɑ koo kɑ ko bu nɛɛ, Gusunɔ u nun koowo nɡe Efɑrɑimu kɑ Mɑnɑse. Nɡe mɛyɑ u kɑ Efɑrɑimu ɡbiisiɑ. ");
INSERT INTO bba_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Mɑ Isireli u Yosɛfu sɔ̃ɔwɑ u nɛɛ, wee, nɑ ɡɔɔ turuku kuɑ. Adɑmɑ Gusunɔ u ko n kɑ bɛɛ wɑ̃ɑ kpɑ u kɑ bɛɛ wurɑ bɛɛn bɑɑbɑbɑn temɔ. ");
INSERT INTO bba_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Miyɑ kon nun tem ɡɑm sosiɑ mɛ nɑ ǹ wunɛn mɑɑbu kɑ wɔnɔ wɛ̃ɛmɔ. Tem mɛ, mu sɑ̃ɑwɑ mɛ nɑ mwɑ Amɔrebɑn nɔmɑn di kɑ tɑkobi kɑ tɛndu. ");
INSERT INTO bba_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yen biru Yɑkɔbu u win bibu sokɑ u nɛɛ, i mɛnnɑmɑ kpɑ n bɛɛ sɔ̃ ye n koo bɛɛ deemɑ ɑmɛn biru. ");
INSERT INTO bba_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","I nɑ i nɔ nɛn bibu, i mɑn swɑɑ dɑkio. ");
INSERT INTO bba_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubɛni, wunɛ nɛn bii yerumɑ, ɑ sɑ̃ɑwɑ nɛn dɑm. Wunɑ nɑ mɑrɑ nɛn ɑluwɑɑsiru sɔɔ. Wunɑ ɑ yiiko kɑ dɑm bo nɛn bibu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Adɑmɑ ɑ sɑ̃ɑwɑ nɡe nim torɑ, ɑ ǹ ɡɑyɑ mɔ. Yen sɔ̃nɑ ɑ ǹ kɑɑ ko wunɛn wɔnɔbun wiruɡii. Domi ɑ kɑ nɛn kurɔ Bilihɑ kpunɑ, ɑ nɛn kpin yeru disi doke. ");
INSERT INTO bba_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Wunɛ Simɛɔ kɑ Lefi, dɑɑ tiɑ i mɔ. I rɑ bɛɛn tɑkobi suewɑ kɑ ɡbɑnɑ i kɑ kɔ̃sɑ ko. ");
INSERT INTO bba_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Bɛɛn mɔrun sɔ̃ i tɔmbu ɡo. Bɛɛn nuku kɔ̃surun sɔ̃ i kɛtɛ kinɛnun nɑɑ sĩinu bɔɔrɑ. Yen sɔ̃, nɛn ɡɔ̃ru ɡu ku rɑɑ du bɛɛn kɑnkɑm wesiɑnɔ sɔɔ. Nɛn bwɛ̃rɑ yu ku rɑɑ kɑ bɛɛ mɛnnɛ. ");
INSERT INTO bba_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Bɛɛn mɔru yu ko bɔ̃rurɑ yèn sɔ̃ yɑ sɑ̃ɑ ɡbɑnɑɡiɑ. Mɛyɑ mɑɑ kɑ bɛɛn nuku ɡbisibu yèn sɔ̃ bu ǹ wɔnwɔndu mɔ. I ko n yɑrinɛwɑ bɛɛn tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Wunɛ mɑɑ Yudɑ, wunɛn mɑɑbu kɑ wɔnɔbu bɑ koo nun siɑrɑ. Kɑɑ wunɛn yibɛrɛbɑn wĩinu tɑɑre. Wunɛn tundo bisibu bɑ koo nun yiirɑwɑ. ");
INSERT INTO bba_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yudɑ nɛn bii, ɑ sɑ̃ɑwɑ nɡe ɡbee sunɔ kpɛmbu, ɡe ɡɑ yɑɑ ɡoomɑ ɡɑ wee, kpɑ ɡu kpɑm wurɑ ɡu yɑɑ sɑ̃kiriɑ. A sɛ̃ nɡe ɡbee sunɔ mɛro. Wɑrɑ koo kɑ̃ku u nun bɛsu. ");
INSERT INTO bba_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Bɑndɑ kun doonɔ wunɛn bweserun di. Sinɑ bɔrɑ kun kisirɑmɔ wunɛn nɔmun di, sere Silo ù n tunumɑ, kpɑ bwesenu kpuro nu nùn mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Wunɛn resɛm yɑ koo kuurɑ sere ɑ wunɛn kɛtɛku kɑ ɡen buu sɔri mi. Yen mɑrum mu koo nun tɑm wɛ̃ mu n kpɑ̃ sere ɑ kɑ mu wunɛn yɑ̃nu teɑ nɡe nim. ");
INSERT INTO bba_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Kpɑ wunɛn nɔni yi n sɔ̃ri tɑm mɛn sɔ̃. Kpɑ wunɛn donnu nu n buriri bom bekum sɔ̃. ");
INSERT INTO bba_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Wunɛ mɑɑ Sɑbuloni, kɑɑ n wɑ̃ɑwɑ nim wɔ̃kun ɡoorɔ mi ɡoo nimkusu rɑ yɔ̃re. Wunɛn tem mu ko n tɛriewɑ sere Sidoni ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Isɑkɑri, wunɛ ɑ sɑ̃ɑwɑ nɡe kɛtɛku dɑmɡuu. A rɑ kɑ̃ ɑ n wɑ̃ɑ tem nɔɔ burɑ yenun bɑɑbɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","A wɑ mɑ mi ɑ wɛ̃re n wɑ̃. Tem mɛ, mu mɑɑ ɡeɑ sɑ̃ɑ. Yen sɔ̃nɑ ɑ wurɑ ɑ sɔmunu suɑ kpɑ ɑ yoo sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Wunɛ mɑɑ Dɑnu, wunɑ kɑɑ n dɑ wunɛn bweserun ɡɑri wunɑnɛ Isirelibɑn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Kɑɑ n sɑ̃ɑwɑ nɡe surɔkɔru swɑɑ sɔɔ, te tɑ dumin nɑɑ sĩinu dwɛ̃ɛmɔ, mɑɑsɔbu bu kɑ fukurɑ yin wɔllun di. ");
INSERT INTO bba_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Yinni Gusunɔ, nɑ wunɛn fɑɑbɑ yĩiyɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Wunɛ mɑɑ Gɑdi, wɛrɔ dɑbirɑ tɑ koo nun wɔri, ɑdɑmɑ kɑɑ bu kɑmiɑ ɑ ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Asɛɛ, wunɛ mɑɑ, wunɛn tem mu ko n dĩɑ ɡeenu mɔ. Sinɑ dimɑ kɑɑ n dɑ di. ");
INSERT INTO bba_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Wunɛ mɑɑ Nɛfitɑli, ɑ sɑ̃ɑwɑ nɡe ɡinɑ ye yɑ tii mɔru kĩ, yɑ mɑɑ bii burɑnu mɑrumɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Wunɛ Yosɛfu, ɑ sɑ̃ɑwɑ nɡe kɛtɛku ɡbeeku ɡe ɡɑ wɑ̃ɑ bwiɑn bɔkuɔ. A sɑ̃ɑwɑ nɡe kɛtɛku buu ɡe ɡɑ wɑ̃ɑ ɡuurun ɡɑ̃ɑrɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Yibɛrɛbɑ bɑ nun nɔɔ kuurɑ, bɑ nun wɔri kɑ mɔru, bɑ nun sɛ̃ɛnu twee. ");
INSERT INTO bba_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Adɑmɑ wunɛn tɛndɑ kun wurure yèn sɔ̃ nɛn Yinni, Gusunɔ Dɑm kpuroɡii, u wunɛn nɔmɑ dɑm kɑ̃ɑ. Wi, wi u Isirelibɑ kpɑre, u bu ɡɑnuɑ nɡe kpee bɑkɑru, ");
INSERT INTO bba_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","wiyɑ u koo nun somi u nun domɑru kuɑ, kpɑ ɡurɑ yu nun nɛɛyɑ, kpɑ nim mu n yibɑ bwiiyɔ yi ɑ mɔ wunɛn tem sɔɔ. U koo mɑɑ wunɛn kurɔbu ko bii mɛrobu, kpɑ wunɛn sɑbenu nu mɑ. ");
INSERT INTO bba_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Wunɛn domɑru tɑ koo wunɛn bɑɑbɑbɑɡiru kerɑ. Tɑ kpɑ̃ tɑ ɡuunu kpuro kere. Domɑ te, tɑ ko n nun wɑ̃ɑsiwɑ, Yosɛfu, wunɛ wi ɑ sɑ̃ɑ nɛnɛm wunɛn mɑɑbu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Wunɛ mɑɑ Bɛnyɑmɛɛ, ɑ sɑ̃ɑwɑ nɡe dɛmɑku ɡe ɡɑ rɑ n yɑɑ ɡoomɔ bururu kɑ yokɑ ɡɑ n temmɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Nɡe mɛyɑ Isireli u kɑ win bibu domɑru kuɑ nɛnnɛnkɑ. Ye u mɑɑ bu sɔ̃ɔwɑ, yerɑ mi. Bii beyɑ bɑ kuɑ win bwese kɛri wɔkurɑ yiru ye. ");
INSERT INTO bba_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Yen biru Yɑkɔbu u win bibu yiire u nɛɛ, nɑ dɔɔ n nɛn tɔmbu deemɑ ɡɔriɔ. I mɑn sikuo nɛn bɑɑbɑbɑn sikirɔ, kpee wɔru sɔɔ ɡe ɡɑ wɑ̃ɑ Eforoni Hɛtin ɡberɔ. ");
INSERT INTO bba_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Kpee wɔru ɡerɑ ɡɑ wɑ̃ɑ Mɑkpelɑn ɡberɔ, Mɑnden deedeeru Kɑnɑnin temɔ. Gbee terɑ Aburɑhɑmu u dwɑ Eforoni Hɛtin mi, tu kɑ ko win tɔmbun siku yeru. ");
INSERT INTO bba_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Miyɑ bɑ Aburɑhɑmu sikuɑ kɑ win kurɔ Sɑɑrɑɑ, kɑ mɑɑ Isɑki kɑ win kurɔ Rebekɑ. Miyɑ nɑ mɑɑ Leɑ sikuɑ. ");
INSERT INTO bba_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Bɑ ɡbee te kɑ ten kpee wɔru ɡe dwɑwɑ Hɛtibɑn mi. ");
INSERT INTO bba_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Sɑnɑm mɛ Yɑkɔbu u win bibu ɡɑri yi sɔ̃ɔwɑ u kpɑ, yerɑ u win nɑɑsu suɑ u sɔndi kpin yeru wɔllɔ mɑ u ɡu u dɑ u win bɑɑbɑbɑ deemɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yerɑ Yosɛfu u dɑ u win tundo sɛ̃re u swĩisimɔ. ");
INSERT INTO bba_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Mɑ u win tiin dokotorobɑ yiire bu win tundon ɡoru tim sɑwɑ tu ku kɑ kɔ̃si. Mɑ bɑ tu tim mɛ sɑwɑmɔ ");
INSERT INTO bba_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","n kɑ kuɑ sɔ̃ɔ weeru. Eɡibitiɡibɑ ɡɔɔ wooru sinɑ sere sɔ̃ɔ wɑtɑ kɑ wɔkuru. ");
INSERT INTO bba_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Sɑnɑm mɛ bɑ ɡɔɔ woo ten bɑɑ kpɑ, Yosɛfu u Eɡibiti sunɔn yɛnuɡibu sɔ̃ɔwɑ u nɛɛ, i suuru koowo, nɑ̀ n kĩi ɡeeru wɑ bɛɛn mi, nɑ kĩ i mɑn sunɔ sɔ̃ɔwɑ i nɛɛ, ");
INSERT INTO bba_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","nɛn tundo u kɑ mɑn ɑrukɑwɑni bɔkuɑ u nɛɛ, wee, u koo ɡbi. Mɑ u mɑn bɔ̃rusiɑ u nɛɛ, ù n ɡu, n kɑ nùn doo n sike siki te u ɡbɑ sɔɔ Kɑnɑnin temɔ. Yen sɔ̃nɑ nɑ kĩ n dɑ mi, n nùn sike, kpɑ n ɡɔsirɑmɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Yerɑ sunɔ u nùn wisɑ u nɛɛ, ɑ seewo ɑ dɑ ɑ wunɛn tundo sike nɡe mɛ u nun bɔ̃rusiɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yosɛfu u seewɑ u dɑ u kɑ win tundo sike. Eɡibiti sunɔn sɔm kowobu kpuro bɑ nùn swĩi kɑ win yɛnun wiruɡibu kɑ Eɡibitin wiruɡibu ");
INSERT INTO bba_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","kɑ Yosɛfun yɛnuɡibu kɑ win mɑɑbu kɑ wɔnɔ, win tundon yɛnuɡibu kpuro ɡesi. Bibu kɑ yɑ̃ɑnu kɑ kɛtɛbɑ tɔnɑwɑ bɑ deri Gosɛniɔ. ");
INSERT INTO bba_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Kɛkɛ be dumi ɡɑwe kɑ mɑɑsɔbu bɑ mɑɑ Yosɛfu swĩi sere tɔn wɔru ɡe, ɡɑ kpɛ̃ɑ n bɑndɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Ye bɑ turɑ doo soo yerɔ te bɑ rɑ soku Atɑdi, Yuudɛnin dɑɑrun ɡuruɔ, miyɑ bɑ nɔɔɡiru suɑ tɑ̃ɑ tɑ̃ɑ bɑ ɡɔɔ wuri mɔ̀. Mɑ Yosɛfu u win tundon ɡɔɔ wooru sinɑ mi, sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Kɑnɑnin temɡibu bɑ ɡɔɔ woo te wɑ Atɑdin doo soo yeru mi, mɑ bɑ nɛɛ, wee, Eɡibitiɡibu bɑ ko n dɑmɡii ɡoon ɡɔɔ mɔ̀. Yen sɔ̃nɑ bɑ doo soo yee te sokɑ Abɛli Misirɑimu kɑ ben bɑrum. Tɑ wɑ̃ɑwɑ Yuudɛnin dɑɑrun ɡuruɔ. ");
INSERT INTO bba_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Nɡe mɛyɑ Yɑkɔbun bibɑ kuɑ ye u bu yiire. ");
INSERT INTO bba_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","Bɑ win ɡoru suɑ bɑ kɑ dɑ Kɑnɑnin temɔ bɑ sikuɑ kpee wɔru sɔɔ Mɑkpelɑɔ. Kpee wɔru ɡe, ɡɑ wɑ̃ɑ ɡberu ɡɑru sɔɔ Mɑnden deedeeru te Aburɑhɑmu u dwɑ Eforoni Hɛtin mi, tu kɑ ko win tɔmbun siku yeru. ");
INSERT INTO bba_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Ye Yosɛfu u win tundo sikuɑ u kpɑ, u ɡɔsirɑmɑ Eɡibitiɔ kɑ win mɑɑbu kɑ be bɑ kɑ nùn dɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Ye Yosɛfun mɑɑbɑ wɑ ben tundo u ɡu, yerɑ bɑ nɛɛ, sɔrɔkudo Yosɛfu koo sun tusi kpɑ u sun kɔ̃sɑ kpuro kɔsie ye sɑ rɑɑ nùn kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Mɑ bɑ nùn ɡɔriɑ bɑ nɛɛ, bɛsɛn tundo u sere ɡbi u sun woodɑ yeni wɛ̃ ");
INSERT INTO bba_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","u nɛɛ, su nun ɡɑri yini sɔ̃, ɑ be ɡem mɔ, ɑ kɑ sun suuru koowo ɑ bɛsɛn durum ye kpuron ɡɑri wunɔ wunɛn ɡɔ̃run di, domi sɑ nun torɑri. Yen sɔ̃, ɑ sun suuru kuo bɛsɛ be sɑ Gusunɔ, wunɛn bɑɑbɑn Yinni sɑ̃ɑmɔ. Sɑnɑm mɛ Yosɛfu u ɡɑri yini nuɑ u swĩ. ");
INSERT INTO bba_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Yerɑ win mɑɑ ben tii bɑ dɑ bɑ yiirɑ win wuswɑɑɔ bɑ nɛɛ, ɑ sun ɡɑrisio wunɛn yobu. ");
INSERT INTO bba_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Mɑ Yosɛfu u bu sɔ̃ɔwɑ u nɛɛ, i ku bɛrum ko, nɑ ǹ Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kɔ̃sɑ i rɑɑ bwisikɑ i mɑn kuɑ, ɑdɑmɑ Gusunɔ u kɔ̃sɑ ye ɡɔsiɑ ɡeɑ u kɑ tɔn dɑbinu fɑɑbɑ kuɑ nɡe mɛ sɑ wɑɑmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Ǹ n mɛn nɑ, i ku bɛrum ko, kon bɛɛ kɑ bɛɛn bibu nɔɔri. Mɑ u bu nukuru yɛmiɑsiɑ kɑ ɡɑri dori. ");
INSERT INTO bba_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yosɛfu u sinɑ Eɡibitiɔ wi kɑ win tundon yɛnuɡibu. Win wɑ̃ɑrun sɑnɑm kpuro kuɑwɑ wɔ̃ɔ wunɔbu kɑ wɔkuru (110). ");
INSERT INTO bba_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","U Efɑrɑimun bibu wɑ sere kɑ win debuminɔ. Mɛyɑ u mɑɑ Mɑnɑsen bii Mɑkirin bibu wɑ u sɔndi win tɑɑrɔ. ");
INSERT INTO bba_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yen biru u win mɑɑbu sɔ̃ɔwɑ u nɛɛ, nɑ kon ɡbi ɑdɑmɑ Gusunɔ u koo nɑ u bɛɛ yɑrɑ tem mɛn di, kpɑ u kɑ bɛɛ dɑ tem mɛ sɔɔ, mɛ̀n nɔɔ mwɛɛru u Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu kuɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Mɑ u bu sɔ̃ɔwɑ u nɛɛ, i bɔ̃ruo mɑ Gusunɔ ù n nɑ u bɛɛ yɑrɑ mi n tomɑ minin di, i ko nɛn kukunu suɑ i kɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yosɛfu u kuɑwɑ wɔ̃ɔ wunɔbu kɑ wɔkuru u kɑ kpunɑ u ɡu. Yerɑ bɑ win ɡoru tim sɑwɑ bɑ doke kpɑkororu sɔɔ Eɡibitiɔ.");
INSERT INTO bba_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Yɑkɔbu wi bɑ mɑɑ sokumɔ Isireli, win bibun yĩsɑ wee, be bɑ kɑ nùn nɑ Eɡibitiɔ, ben bɑɑwure kɑ win kurɔ kɑ bibu. ");
INSERT INTO bba_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Beyɑ Rubɛni kɑ Simɛɔ kɑ Lefi kɑ Yudɑ ");
INSERT INTO bba_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","kɑ Isɑkɑri kɑ Sɑbuloni kɑ Bɛnyɑmɛɛ ");
INSERT INTO bba_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","kɑ Dɑnu kɑ Nɛfitɑli kɑ Gɑdi kɑ Asɛɛ. ");
INSERT INTO bba_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Yɑkɔbun bibu kɑ win debumii ni, bɑ sɑ̃ɑwɑ tɔnu wɑtɑ kɑ wɔkuru. N deemɑ Yosɛfu, wi, u wɑ̃ɑ Eɡibitiɔ sɑnɑm mɛ. ");
INSERT INTO bba_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Sɑnɑm dɔɔ sɑnɑm wure Yosɛfu kɑ win mɑɑbu kɑ be bɑ wɑ̃ɑ win wɑɑti sɔɔ kpuro bɑ ɡu. ");
INSERT INTO bba_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Mɑ Isirelin bii be, bɑ mɑrurɑ bɑ dɑbiɑ bɑ tɛriɑ bɑ yibɑ tem mɛ sɔɔ bɑ kuɑ dɑmɡibu. ");
INSERT INTO bba_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Yen biru sunɔ kpɑo u bɑndu di wi u kun Yosɛfun wɑ̃ɑrun ɡɑri ɡɛɛ yɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Yerɑ u win tɔmbu sɔ̃ɔwɑ u nɛɛ, Isirelibɑ wee, bɑ sun dɑbiru kere bɑ mɑɑ sun dɑm kere. Ǹ n mɛn nɑ, kɑri bɑkɑ sɑ tii derie. ");
INSERT INTO bba_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tɑbu bù n dɑ seewɑ bɑ koo bɛsɛn wɛrɔbu somi bu kɑ sun tɑbu ko. Bɑ̀ n kpɑ bu sere sun kisirɑri bu doonɑ. Yen sɔ̃, i de su bu bwisi ɡɛɛ kɑsuɑ su kɑ ben mɑrubu yɔ̃rɑsiɑ kpɑ bu ku mɑɑ dɑbiru sosi. ");
INSERT INTO bba_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Mɑ bɑ bu sɔmɑn wiruɡibu ɡɔsiɑ be bɑ koo bu yoo sɔm sɛ̃sɔɡinu koosiɑ. Nɡe mɛyɑ bɑ kuɑ bɑ kɑ wuu mɑrosu bɑnɑ si bɑ sokumɔ Pitomu kɑ Rɑmusɛsi, si su kuɑ Eɡibiti sunɔn dukiɑ beru yenu. ");
INSERT INTO bba_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Adɑmɑ nɡe mɛ bɑ bu nɔni sɔ̃ɔmɔ, nɡe mɛyɑ bɑ mɑɑ dɑbiɑmɔ bɑ sosimɔ. Mɑ Eɡibitiɡibu bɑ bu tusɑ n bɑndɑ. ");
INSERT INTO bba_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Mɑ bɑ bu yoo sɔmburu doke. ");
INSERT INTO bba_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Bɑ birikibɑ murɑmɔ kɑ sɔndu, bɑ mɑɑ ɡbee sɔmɑ bɑɑyere mɔ̀. Mɑ ben wɑ̃ɑrɑ sɛ̃siɑ domi kɑ nuku kɔ̃surɑ bɑ kɑ bu sɔmɑ ye kpuro koosiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mɑ Eɡibiti sunɔ u Heberubɑn mɑrusio beni, Sifirɑ kɑ Puɑ sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","ì n Heberubɑn kurɔbu mɑrusiɑmɔ, ì n wɑ bii tɔn durɔwɑ bɑ mɑrɑ, i nùn ɡoowo. Ǹ n tɔn kurɔn nɑ, i nùn derio u n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Adɑmɑ mɑrusio be, bɑ Gusunɔ nɑsie. Yen sɔ̃nɑ bɑ ǹ kue nɡe mɛ sunɔ wi, u bu yiire. Bɑ bii be kpuro deriwɑ. ");
INSERT INTO bba_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mɑ u bu sokɑ u nɛɛ, mbɑn sɔ̃nɑ i kɑ kuɑ mɛ, i derɑ bii be, bɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Mɑrusio be, bɑ nùn wisɑ bɑ nɛɛ, Heberubɑn kurɔbu bɑ ǹ sɑ̃ɑ nɡe Eɡibitiɡibu. Ben wɑsi yi sɑ̃u. Bɑ rɑ mɑwɑ su sere tunumɑ. ");
INSERT INTO bba_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Mɑ Gusunɔ u mɑrusio be durom kuɑ u ben tii bibu kɑ̃ yèn sɔ̃ bɑ nùn nɑsie. Mɛyɑ mɑɑ Heberu be, bɑ dɑbiɑmɔ bɑ dɑm sosimɔ. ");
INSERT INTO bba_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Mɑ Eɡibiti sunɔ u win tɔmbu kpuro woodɑ wɛ̃ u nɛɛ, i Heberubɑn bii wɛ̃ɛ tɔn durɔbu kpuro kpɛ̃ɛyɔ dɑɑ bɑkɑ te bɑ mɔ̀ Nilu sɔɔ, kpɑ i bii wɛ̃ɛ tɔn kurɔbu deri. ");
INSERT INTO bba_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Durɔ ɡoo wɑ̃ɑ Lefin bweseru sɔɔ, win kurɔ mɑɑ sɑ̃ɑ win bwese te. ");
INSERT INTO bba_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Yerɑ sɑɑ ye sɔɔ, ye bɑ mɛnnɑ kɑ kurɔ wi, mɑ kurɔ wi, u ɡurɑ suɑ u mɑrɑ bii tɔn durɔ. U wɑ mɑ bii wi, u wɑ̃, mɑ u nùn beruɑ suru itɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Sɑɑ ye bii wi kun mɑɑ berurɔ, u kpɑkoro bwĩiɡiru kuɑ u tu kɔntɑɑ kɑ dɑ̃ɑ swĩi swĩinu tɛɛni, nim mu ku kɑ du mi, mɑ u bii wi suɑ u kpɛ̃ɛ sɔɔ. U dɑ u tu yi nɑɑ yɑrin suunu sɔɔ dɑɑ bɑkɑ ten ɡoorɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Mɑ bii win sesu u dɑ mi, u yɔ̃ n dɛsire u kɑ mɛɛrɑ u wɑ ye n koo bii wi deemɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Sɑɑ ye sɔɔrɑ Eɡibiti sunɔn bii tɔn kurɔ u nɑ dɑɑru mi, u kɑ wobure. Mɑ win yobɑ bɔsu dɑɑ ten bɔ̃ɔwɔ. Ye u kpɑkoro bwĩiɡii te wɑ, mɑ u yoo ben turo ɡɔrɑ u kɑ tu nɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Yerɑ u tu wukiɑ u deemɑ bii wɛ̃ɛrɑ tɑ wɑ̃ɑ mi, tɔn durɔ, tɑ sumɔ. Mɑ wɔnwɔndɑ nùn mwɑ u nɛɛ, Heberubɑn biiwɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Yerɑ bii win sesu besirɑmɑ u sunɔn bii wi sɔ̃ɔwɑ u nɛɛ, ɑ kĩ n dɑ n nun ɡoo kɑsuɑmɑ Heberubɑn kurɔbu sɔɔ wi u koo nun bii wi nɔɔriɑ? ");
INSERT INTO bba_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Mɑ sunɔn bii wi, u nɛɛ, oo, ɑ doo. Yerɑ wɔndiɑ wi, u dɑ u bii wɛ̃ɛ ten mɛro sokumɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Ye u nɑ, yerɑ sunɔn bii wi, u nɛɛ, ɑ bii wi mɔɔ ɑ mɑn nɔɔriɑ, kon dɑ nun yen kɔsiɑru wɛ̃. Kurɔ wi, u bii wɛ̃ɛ te suɑ u kɑ dɑ u nɔɔri. ");
INSERT INTO bba_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Sɑnɑm mɛ bii wi, u bɔm kɑrɑbu turɑ, yerɑ u kɑ nùn wurɑ, mɑ sunɔn bii wi, u nùn kuɑ nɡe win tiin bii mɑruro. U tii sɔ̃ɔwɑ u nɛɛ, nɑ nùn yɑrɑmɑwɑ nim di. Yen sɔ̃, win yĩsirɑ Mɔwisi. ");
INSERT INTO bba_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Sɑnɑm dɔɔ sɑnɑm wure, Mɔwisi u kpɛ̃ɑ. Yerɑ u win mɛro bisibu Heberubɑ berɑm dɑ, u wɑ bɑ sɔm sɛ̃sɔɡinu mɔ̀. Mɑ u mɑm Eɡibitiɡii ɡoo wɑ u ben turo soomɔ u kĩ u ɡo. ");
INSERT INTO bba_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Yerɑ Mɔwisi u mɛɛrɑ ɡee kɑ ɡiɔ, u ǹ ɡoo wɑ. Mɑ u Eɡibitiɡii wi so u ɡo. U nùn sikuɑ yɑni sɛɛri sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Yen sisiru u kpɑm wurɑ mi. Yerɑ u deemɑ Heberubɑ yiru bɑ sɑnnɑmɔ. Mɑ u bu yɑkiɑnɑ u wi u kun ɡem mɔ sɔ̃ɔwɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ wunɛn beruse soomɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Mɑ durɔ wi, u Mɔwisi wisɑ u nɛɛ, wɑrɑ nun kuɑ bɛsɛn wiruɡii ɑ kɑ sun siri. A kĩ ɑ mɑn ɡowɑ nɡe mɛ ɑ Eɡibitiɡii wi ɡo? Ye Mɔwisi u nuɑ mɛ, bɛrum nùn mwɑ. U nɛɛ, ǹ n mɛn nɑ, tɔmbu kpuro bɑ ɡɑri yi nuɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Sɑɑ ye Eɡibiti sunɔ u nuɑ ye yɑ koorɑ yerɑ u swɑɑ kɑsu u kɑ Mɔwisi ɡo. Adɑmɑ Mɔwisi u yɑkurɑ u doonɑ min di u dɑ u wɑ̃ɑ Mɑdiɑnin temɔ. Sɔ̃ɔ teeru u dɑ u sɔ̃ dɔkɔ ɡɑɑn bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Yerɑ Mɑdiɑnin yɑ̃ku kowon bii wɔndiɑbɑ nɔɔbɑ yiru bɑ nim tɑkɑm nɑ dɔkɔ mi, mɑ bɑ nim yibiɑ sɑbenun nim nɔru yerɔ ben bɑɑbɑn sɑbenu nu kɑ nɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Mɑ kpɑrobu ɡɑbɑ nɑ bɑ bu ɡire. Adɑmɑ Mɔwisi u seewɑ u bu sɑnnɑ u ben sɑbenu nim kɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Sɑɑ ye bɑ ɡɔsirɑ yɛnuɔ, ben tundo Rewɛlin mi, wi bɑ mɑɑ mɔ̀ Yetoro, u nɛɛ, ɑmɔnɑ i kɑ yellu wɔmɑ mɛ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Bɑ nùn wisɑ bɑ nɛɛ, Eɡibitiɡii ɡoowɑ u kɑ sun yinɑ ye kpɑro be, bɑ sun ɡire, sere u mɑm sun nim tɑkɑ u bɛsɛn sɑbenu kɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Yerɑ u win bii be bikiɑ u nɛɛ, mɑnɑ durɔ wi, u sere wɑ̃ɑ. Mbɑn sɔ̃nɑ i ǹ kɑ nùn nɛ. I doo i nùn sokumɑ u nɑ u di. ");
INSERT INTO bba_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Ye Mɔwisi u nɑ u di mɑ u wurɑ u kɑ sinɑ durɔ win mi. Mɑ u nùn bii ben turo kɑ̃ kurɔ, wi bɑ mɔ̀ Seforɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Kurɔ wi, u ɡurɑ suɑ u Mɔwisi bii tɔn durɔ mɑruɑ. Yerɑ Mɔwisi u nùn yĩsiru kɑ̃ kɑ win bɑrum Gɛɛsɔmu, yen tubusiɑnɑ, sɔɔ, domi u nɛɛ, u sɑ̃ɑwɑ sɔɔ tem tukumɔ. ");
INSERT INTO bba_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Sɑnɑm dɔɔ sɑnɑm wure, Eɡibiti sunɔ wi, u ɡu. Sɑɑ ye sɔɔ, Isirelibɑ bɑ weeweenu mɔ̀ bɑ wuri mɔ̀ ben yoo sɔmɑ yen sɔ̃. Ben wuri yi, yi Gusunɔ ɡirɑri, ");
INSERT INTO bba_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","mɑ u ben weeweenu nuɑ. N deemɑ u ǹ win ɑrukɑwɑni duɑri ye u kɑ ben bɑɑbɑbɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu bɔkuɑ. ");
INSERT INTO bba_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yerɑ u bu mɛɛrimɑ u ben wɔnwɔndu wɑ. ");
INSERT INTO bba_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Sɑɑ ye sɔɔ, Mɔwisi u win dokiri Yetoro, Mɑdiɑnin yɑ̃ku kowon sɑbenu kpɑre. U kɑ nu dɑ yɑkɑsɔ sɔ̃ɔ duu yeru ɡiɑ. Mɑ u turɑ sere ɡuu te bɑ mɔ̀ Horɛbuɔ te bɑ mɑɑ sokumɔ Sinɑi te Gusunɔ u tii ɡɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Yerɑ Yinni Gusunɔn ɡɔrɑdo u kɑ nùn ɡɑri kuɑ dɔ̃ɔ yɑrin di yi yi wɑ̃ɑ ɑwĩi ɡɛɛn suunuɔ. Mɔwisi u mɛɛrɑ u wɑ wee, ɑwĩi yi kpuro yi dɔ̃ɔ mɔ̀, ɑdɑmɑ yi ǹ dɔ̃ɔ mwɑɑrɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Mɑ u nɛɛ, kon ɡɛrɑ n kɑ̃si bɑkɑ te wɑwɑ, kpɑ n wɑ yèn sɔ̃ ɑwĩi yi, yi ǹ dɔ̃ɔ mwɑɑrɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Ye Yinni Gusunɔ u wɑ mɑ u ɡɛrɑ u kɑ wɑ, yerɑ u nùn sokɑ sɑɑ ɑwĩi yin suunu sɔɔn di u nɛɛ, Mɔwisi, Mɔwisi. Mɑ Mɔwisi u wurɑ u nɛɛ, nɛ wee. ");
INSERT INTO bba_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Gusunɔ u nɛɛ, ɑ ku susimɑ mini. A wunɛn sɑlubɑtɑ ye poto domi nɛnɑ nɑ wɑ̃ɑ mini, ");
INSERT INTO bba_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","nɛ wi nɑ sɑ̃ɑ wunɛn sikɑdobɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbun Yinni. Mɑ Mɔwisi u win wuswɑɑ beruɑ domi bɛrum nùn mɔ̀ u kɑ Gusunɔ mɛɛri. ");
INSERT INTO bba_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Yinni Gusunɔ u kpɑm nɛɛ, nɑ nɛn tɔmbun nɔni swɑ̃ɑru wɑ be bɑ wɑ̃ɑ Eɡibitiɔ. Nɑ mɑɑ ben weeweenu nuɑ dɑm mɛ bɑ bu dɔremɔn sɔ̃. Nɑ ben nuku sɑnkirɑnu yɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Yerɑ nɑ sɑrɑmɑ n kɑ bu wɔrɑ Eɡibitiɡibun nɔmɑn di, kpɑ n kɑ bu dɑ tem bɑkɑm ɡɑm sɔɔ mɛ mu ɡeɑ sɑ̃ɑ mu tim kɑ bom yibɑ. Tem mɛ sɔɔrɑ Kɑnɑnibɑ kɑ Hɛtibɑ kɑ Amɔrebɑ kɑ Feresibɑ kɑ Hefibɑ kɑ Yebusibɑ bɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Wee, nɑ Isirelibɑn weeweenu nuɑ. Nɑ mɑɑ dɑm mɛ wɑ mɛ Eɡibitiɡibɑ bu dɔremɔ. ");
INSERT INTO bba_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","A doo n nun ɡɔri tɛ̃ Eɡibiti sunɔn mi, ɑ nɛn tɔmbu Isirelibɑ yɑrɑmɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Mɔwisi u nùn wisɑ u nɛɛ, wɑrɑ rɑ n nɛ n kɑ dɑ Eɡibiti sunɔn mi, n Isirelibɑ yɑrɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Gusunɔ u nɛɛ, ko nɑ n kɑ nun wɑ̃ɑ. Sɑnɑm mɛ ɑ tɔn be yɑrɑmɑ Eɡibitin di, ɡuu tenin miyɑ i ko nɑ i mɑn sɑ̃. Yeniwɑ yɑ ko n sɑ̃ɑ yĩreru ɑ n kɑ yɛ̃ mɑ nɛnɑ nɑ nun ɡɔrɑ. ");
INSERT INTO bba_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Mɔwisi u Gusunɔ sɔ̃ɔwɑ u nɛɛ, ǹ n mɛn nɑ, kon dɑ Isirelibɑn mi, n bu sɔ̃ n nɛɛ, bɛsɛn sikɑdobɑn Yinniwɑ u mɑn ɡɔrimɑ ben mi. Adɑmɑ bɑ̀ n mɑn bikiɑ, ɑmɔnɑ win yĩsiru, mbɑ kon ɡere. ");
INSERT INTO bba_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Gusunɔ u nùn wisɑ u nɛɛ, nɛnɑ wi nɑ rɑ n wɑ̃ɑ. A Isirelibɑ wisio ɑ nɛɛ, wi u tii sokumɔ Wi u rɑ n wɑ̃ɑ, wiyɑ u nun ɡɔrimɑ ben mi. ");
INSERT INTO bba_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Mɛniwɑ nɛn yĩsiru sere kɑ bɑɑdommɑɔ. Mɛyɑ bɑ ko n dɑ mɑn soku sere kɑ ben bweserun bibɔ. Mɑ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑmɛniwɑ kɑɑ Isirelibɑ sɔ̃ ɑ nɛɛ, nɛ wi nɑ rɑ n wɑ̃ɑ nɑ sɑ̃ɑ bɛɛn sikɑdobɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbun Yinni, nɑ mɑɑ nun ɡɔrimɑ ben mi. ");
INSERT INTO bba_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","A doo ɑ Isirelibɑn ɡuro ɡurobu mɛnnɑ ɑ bu sɔ̃ ɑ nɛɛ, nɛ wi nɑ rɑ n wɑ̃ɑ, nɑ sɑ̃ɑ bɛɛn sikɑdobɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbun Yinni, nɑ mɑɑ nun kure nɑ kɑ nun ɡɑri kuɑ nɑ nɛɛ, nɑ bu wɑ, nɑ mɑɑ wɑ ye bɑ bu kuɑmmɛ Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Mɑ nɑ nɛɛ, kon bu yɑrɑ Eɡibitin di mi bɑ nɔni swɑ̃ɑru wɑɑmɔ. Kpɑ n kɑ bu dɑ Kɑnɑnibɑ kɑ Hɛtibɑ kɑ Amɔrebɑ kɑ Feresibɑ kɑ Hefibɑ kɑ Yebusibɑn temɔ mɛ mu tim kɑ bom yibɑ. ");
INSERT INTO bba_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Bɑ koo wunɛn ɡɑri wurɑ kpɑ wunɛ kɑ Isirelibɑn ɡuro ɡurobu i dɑ Eɡibiti sunɔn mi, i nɛɛ, nɛ wi nɑ rɑ n wɑ̃ɑ nɑ sɑ̃ɑ bɛɛ Heberubɑn Yinni, nɑ mɑɑ kɑ bɛɛ ɡɑri kuɑ. U de i dɑ ɡbɑburɔ i tondɑ nɡe sɔ̃ɔ itɑn sɑnum sɑkɑ kpɑ i nɛ bɛɛn Yinni yɑ̃kuru kuɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Nɑ yɛ̃ mɑ Eɡibiti sunɔ ù n nuɑ mɛ, u ǹ wurɑmɔ i dɑ mɑ n kun mɔ nɑ nùn nɛn dɑm sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Yen sɔ̃, kon nɛn nɔmu dɛmiɑ kpɑ n sɔm mɑɑmɑɑki bwese bwesekɑ dɑbinu ko Eɡibitiɔ. Yen biru bɑ koo bɛɛ ɡirɑ i doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","Sɑnɑm mɛ bɑ koo doonɑ bɑ ǹ doonɔ nɔm dirɑ. Domi kon de nɛn tɔmbu bu kĩi ɡeeru wɑ Eɡibitiɡibun mi. ");
INSERT INTO bba_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Bɛɛn tɔn kurɔ bɑɑwurewɑ u koo win beruse ǹ kun mɛ kɑ wi bɑ wɑ̃ɑ yɛnu teu sɔɔ burɑ yɑ̃ɑ ni bɑ kuɑ kɑ wurɑ kɑ sii ɡeesu kɑnɑ, kɑ mɑɑ bekɑ kpɑ bu ye kpuro ben bibu dokeɑ. Nɡe mɛyɑ i ko kɑ Eɡibitiɡibun ɑrumɑni ɡurɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Mɑ Mɔwisi u wisɑ u nɛɛ, nɑ tɔn be yɛ̃. Bɑ ǹ koo mɑn nɑɑnɛ ko. Bɑ ǹ ɡɑri yi swɑɑ dɑkimɔ. Bɑ koo nɛɛ, wunɛ Yinni Gusunɔ ɑ ǹ mɑn kure ɑ kɑ mɑn ɡɑri kue. ");
INSERT INTO bba_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Yinni Gusunɔ u nùn bikiɑ u nɛɛ, mbɑ ɑ nɛni wunɛn nɔmuɔ mi. Mɔwisi u nɛɛ, dɛkɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mɑ Yinni Gusunɔ u nɛɛ, ɑ ye kɔ̃ɔwɔ temɔ. Mɑ u ye kɔ̃ temɔ, mɑ yɑ ɡɔsiɑ wɑɑ. Yerɑ Mɔwisi u dukɑ suɑ yen min di. ");
INSERT INTO bba_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Yinni Gusunɔ u kpɑm nùn sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn nɔmu dɛmiɔ kpɑ ɑ yen siru nɛnɛ ɑ suɑ. Mɑ u win nɔmu dɛmiɑ u yen sii te nɛnuɑ u suɑ, mɑ yɑ kpɑm ɡɔsiɑ dɛkɑ win nɔmuɔ. ");
INSERT INTO bba_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Yinni Gusunɔ u mɑɑ nɛɛ, yeniwɑ kɑɑ ko, kpɑ bu ɡiɑ mɑ nɛ wi nɑ rɑ n wɑ̃ɑ nɑ kɑ nun ɡɑri kuɑ, nɛ wi nɑ sɑ̃ɑ ben bɑɑbɑbɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbun Yinni. ");
INSERT INTO bba_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Mɑ Yinni Gusunɔ u kpɑm nɛɛ, ɑ wunɛn nɔmu dokeo wunɛn yɑberun sɔɔwɔ tororɔ. Mɑ u doke, yen biru u wunɑ. Wee ɡɑ bururɑ nɡe wɛ̃su, ɡɑ bɑrɑ disiɡiru wɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Yinni Gusunɔ u kpɑm nɛɛ, ɑ mɑɑ wunɛn nɔmu ɡe wesio mi. U wesiɑ, mɑ u ɡe wunɑ. Mɑ ɡɑ kpɑm kuɑ nɡe mɛ ɡɑ rɑɑ sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Yinni Gusunɔ u nɛɛ, bɑ̀ kun nun nɑɑnɛ kue, bɑ̀ kun yĩre ɡbiikiru wure, bɑ koo yiruseru wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Bɑ̀ kun mɑɑ wure bɑɑ mɛ bɑ yĩrenu yiru ye wɑ, bɑ̀ n wunɛn ɡɑri yinɑ, ɑ dɑɑ bɑkɑ ten nim sɔko ɑ yɑri temɔ. Nim mɛ ɑ sɔkɑ mi, mu koo ɡɔsiɑwɑ yɛm temɔ. ");
INSERT INTO bba_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Yerɑ Mɔwisi u Yinni Gusunɔ wisɑ u nɛɛ, Yinni, ɡɑri ɡerubu bu rɑ n kɑ mɑn sɛ̃ yellun di, bɑɑ kɑ tɛ̃ ye ɑ kɑ mɑn ɡɑri mɔ̀, domi nɛn yɑrɑ bunu. ");
INSERT INTO bba_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Mɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, wɑrɑ tɔnun nɔɔ kuɑ. Wɑrɑ rɑ tɔnu ko soso. Wɑrɑ rɑ yɑm wɑɑsie. Wɑrɑ rɑ tɔnu ko wɔ̃ko. N ǹ nɛ, Yinni Gusunɔ wi ro? ");
INSERT INTO bba_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Ǹ n mɛn nɑ, ɑ doo tɛ̃. Kon nun somi. Kon nun sɔ̃ɔsi ye kɑɑ ɡere. ");
INSERT INTO bba_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Adɑmɑ Mɔwisi u nɛɛ, ɑɑwo, ɑ ɡoo ɡɔsio ɑ ɡɔri. ");
INSERT INTO bba_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Sɑɑ yerɑ Yinni Gusunɔ u kɑ Mɔwisi mɔru kuɑ. Mɑ u nɛɛ, n ǹ Aroni Lefi u sɑ̃ɑ wunɛn mɔɔ? Nɑ yɛ̃ mɑ ɡɑri ɡerubu kun kɑ nùn sɛ̃. Win tii wee, u nun sennɔ sisi. Ù n nun wɑ, win nukurɑ koo dorɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","A kɑ nùn ɡɑri koowo, kpɑ ɑ nùn sɔ̃ ye u koo ɡere. Nɛnɑ kon wunɛn nɔɔ kɑ win nɔɔ dendi, kpɑ n bɛɛ sɔ̃ɔsi ye i ko ko. ");
INSERT INTO bba_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Wiyɑ u koo tɔmbu wunɛn ɡɑri tusiɑ. U ko n sɑ̃ɑ nɡe wunɛn nɔɔ, kpɑ ɑ n sɑ̃ɑ nɛn kɔsire win sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Tɛ̃, ɑ dɛkɑ ye suo ye kɑɑ kɑ yĩreru ko, kpɑ ɑ n ye nɛni wunɛn nɔmuɔ. ");
INSERT INTO bba_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Yen biru Mɔwisi u doonɑ min di. U ɡɔsirɑ u dɑ win dokiri Yetoron mi. Ye u turɑ mi, u nùn sɔ̃ɔwɑ u nɛɛ, ɑ de n dɑ n nɛn dusibu wɑ mɛ bɑ kɑ wɑ̃ɑ Eɡibitiɔ. Mɑ Yetoro u nùn sɔ̃ɔwɑ u nɛɛ, ɑ doo kɑ bɔri yɛndu. ");
INSERT INTO bba_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","20","Mɑ Mɔwisi u win kurɔ kɑ win bibu suɑ u bu kɛtɛkunu yɔɔsiɑ bɑ dɑ Eɡibitin temɔ. U mɑɑ dɛkɑ ye suɑ ye Gusunɔ u nùn sɔ̃ɔwɑ u n nɛni mi. Domi Yinni Gusunɔ u rɑɑ nùn sɔ̃ɔwɑ u nɛɛ, be bɑ rɑɑ kɑsu bu nùn ɡo, be kpuro bɑ ɡu. Yen sɔ̃, u ɡɔsiro u dɑ Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, tɛ̃, ɑ doo Eɡibiti mi, kpɑ ɑ n yɑɑye yĩre ni nɑ nun nɔmu bɛriɑ, ɑ kɑ nu ko Eɡibiti sunɔn wuswɑɑɔ. Adɑmɑ kon win ɡɔ̃ru bɔbiɑsiɑ. U ǹ wurɑmɔ u tɔn be deri bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kpɑ ɑ nùn sɔ̃ ɑ nɛɛ, ɑmɛniwɑ nɛ, Yinni Gusunɔ nɑ ɡeruɑ, Isirelin bweseru tɑ sɑ̃ɑwɑ nɡe nɛn bii yerumɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Yen sɔ̃, u de nɛn bii wi, u doonɑ u kɑ mɑn sɑ̃. Ù n mɑɑ yinɑ, kon win bii yerumɑ ɡo. ");
INSERT INTO bba_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Swɑɑ sɔɔ mi Mɔwisi u yɔ̃rɑ u kpunɑ, miyɑ Yinni Gusunɔ u nùn sɛ̃re, u kĩ u nùn ɡo. ");
INSERT INTO bba_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Mɑ Seforɑ u kpee nɔɔ duroruɡiru suɑ u win bii bɑnɡo kuɑ, mɑ u win sen sɑrusu suɑ u kɑ Mɔwisin tiin tɔn durɔru bɑbɑ u nɛɛ, wee, nɑ wunɛn woro yɛmɡiru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Bɑnɡo yen sɔ̃nɑ u ɡeruɑ mɛ. Sɑnɑm mɛ sɔɔrɑ Yinni Gusunɔ u Mɔwisi deri. ");
INSERT INTO bba_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","N deemɑ Yinni Gusunɔ u rɑɑ Aroni sɔ̃ɔwɑ u nɛɛ, ɑ seewo ɑ Mɔwisi sennɔ dɑ ɡbɑburɔ. Aroni u seewɑ u dɑ mɑ u kɑ Mɔwisi yinnɑ ɡuu ten mi, te Gusunɔ u tii ɡɔsiɑ. Mɑ bɑ ɡɑbɑnɑ bɑ bɔkɑsinɑ nuku dobun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Yen biru Mɔwisi u Aroni sɑɑriɑ kpuro ye Yinni Gusunɔ u kɑ nùn ɡɔrimɑ, kɑ yĩre ni u nùn sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Mɑ Mɔwisi kɑ Aroni bɑ ɡurenɑ bɑ dɑ Eɡibitiɔ, bɑ Isirelibɑn ɡuro ɡurobu mɛnnɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Mɑ Aroni u bu ɡɑri yi kpuro sɑɑriɑ yi Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ mi. Mɑ Mɔwisi u tɔn be yĩre ni kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Yerɑ, bɑ nɑɑnɛ doke. Bɑ ɡiɑ mɑ Yinni Gusunɔ u wɑ nɡe mɛ bɑ bu nɔni sɔ̃ɔmɔ. Tɛ̃ u kĩ u bu fɑɑbɑ ko. Mɑ bɑ yiirɑ bɑ nùn sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Yen biru Mɔwisi kɑ Aroni bɑ seewɑ bɑ dɑ Eɡibiti sunɔn mi bɑ nɛɛ, ɑmɛniwɑ Isirelibɑn Yinni wi bɑ mɔ̀ Wi u rɑ n wɑ̃ɑ, u ɡeruɑ. U nɛɛ, ɑ de win tɔmbu bu dɑ ɡbɑburɔ bu sɑ̃ɑru ko. ");
INSERT INTO bba_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mɑ Eɡibiti sunɔ u nɛɛ, wɑrɑ bɑ mɔ̀ Wi u rɑ n wɑ̃ɑ, n kɑ sere nùn mɛm nɔɔwɑ, n de bɛɛ Isirelibɑ i doonɑ. Nɑ ǹ nùn yɛ̃. Nɑ ǹ mɑɑ derimɔ i doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Yerɑ bɑ nɛɛ, bɛsɛ Heberubɑn Yinniwɑ u sun kure u kɑ sun ɡɑri kuɑ. Yen sɔ̃, ɑ de su dɑ ɡbɑburɔ nɡe sɔ̃ɔ itɑn sɑnum sɑkɑ su kɑ nùn yɑ̃kuru kuɑ, kpɑ u ku rɑɑ sun bɑrɑ bɑkɑru kpɛ̃ɛ su ɡbi, ǹ kun mɛ u de bu sun ɡo tɑbu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mɑ Eɡibiti sunɔ u bu sɔ̃ɔwɑ u nɛɛ, wunɛ Mɔwisi kɑ Aroni, mbɑn sɔ̃nɑ i tɔn be sɔmburu yɔ̃rɑsiɑ. I doo i bɛɛn sɔmɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Wee, ye tɔn be, bɑ mɑrurɑ bɑ dɑbiɑ tɛ̃ tem mɛni sɔɔ, yerɑ i kĩ i ben sɔmburu yɔ̃rɑsiɑ? ");
INSERT INTO bba_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Dɔmɑ teyɑ Eɡibiti sunɔ u wiɡii be bɑ tɔn be kpɑre sɔmɑ ye sɔɔ, kɑ Isirelibɑn swɑɑ ɡbiobu sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","i ku rɑ mɑɑ tɔn be tɑkɑ nɔɔ wɛ̃ nɡe yellu bu kɑ birikibɑ ko. I de ben tii bu dɑ bu tɑkɑ nɔɔ kɑsu. ");
INSERT INTO bba_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Kɑ mɛ, i ku ben birikibɑn ɡeeru kɑwɑ mɛ bɑ rɑ rɑɑ ko yellu. Domi yikurɑ tɑ bu mɔ̀. Yen sɔ̃nɑ bɑ weeweenu mɔ̀ bɑ mɔ̀, bu dɑ bu ben Yinni yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","I de tɔn ben sɔmburu tu sɛ̃sɔ sosi, kpɑ bɑ n tu mɔ̀. Sɑnɑm mɛ, bɑ ǹ koo mɑɑ weesu swɑɑ dɑki. ");
INSERT INTO bba_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Mɑ be bɑ tɔn be kpɑre sɔmɑ ye sɔɔ mi, kɑ Isirelibɑn swɑɑ ɡbiobu bɑ nɑ bɑ bu sɔ̃ɔwɑ bɑ nɛɛ, ɑmɛniwɑ Eɡibiti sunɔ u ɡeruɑ. U nɛɛ, u ǹ mɑɑ bɛɛ tɑkɑ nɔɔ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Ǹ n mɛn nɑ, i doo i bɛɛn tɑkɑ nɔɔ kɑsu mi i ko wɑ. Adɑmɑ kɑ mɛ, sɑ ǹ ɡɑ̃ɑnu kɑwɑmɔ bɛɛn sɔmɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Mɑ tɔn be, bɑ yɑrinɑ bɑɑmɑ Eɡibitin tem sɔɔ, bɑ yɑkɑsu kɑsu bu kɑ tɑkɑ nɔɔ ko. ");
INSERT INTO bba_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Be bɑ bu kpɑre sɔmɑ ye sɔɔ, bɑ bu bɑɑsi bɑ mɔ̀, i bɛɛn sɔmɑ yibio tɔ̃ru bɑɑtere nɡe mɛ i rɑ rɑɑ ko, sɑnɑm mɛ bɑ bɛɛ tɑkɑ nɔɔ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Mɑ bɑ Isirelibɑn swɑɑ ɡbio be Eɡibiti sunɔn tɔmbɑ wunɑ soomɔ bɑ bu bikiɑmɔ, mbɑn sɔ̃nɑ i ǹ bɛɛn birikibɑn ɡeeru yibie ɡĩɑ kɑ ɡisɔ nɡe mɛ i rɑ rɑɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Sɑnɑm mɛ sɔɔrɑ Isirelibɑn swɑɑ ɡbio be, bɑ dɑ bɑ Eɡibiti sunɔ wuri koosimɔ bɑ mɔ̀, mbɑ n kuɑ, yinni, ɑ kɑ sun yenin bweseru kuɑmmɛ. ");
INSERT INTO bba_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Bɑ ku rɑ mɑɑ sun tɑkɑ nɔɔ wɛ̃. Kpɑ bɑ n mɔ̀ su birikibɑ muro. Yen biru sɑ̀ kun kue, kpɑ bɑ n sun soomɔ. N sere deemɑ, wunɛn tɔmbun tɑɑrɛwɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mɑ Eɡibiti sunɔ u bu wisɑ u nɛɛ, yikurobu bɛɛ, i ǹ ɡɑru kobu kĩ. Yen sɔ̃nɑ i ɡerumɔ, n de i dɑ i Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","I doo tɛ̃n tɛ̃ ɡe i bɛɛn sɔmburu ko. Goo kun mɑɑ bɛɛ tɑkɑ nɔɔ wɛ̃ɛmɔ. Adɑmɑ birikibɑn ɡee tee terɑ i ko n murɑmɔ mi. ");
INSERT INTO bba_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Isirelibɑn swɑɑ ɡbio be, bɑ wɑ mɑ ben wɑhɑlɑ yɑ sosimɔwɑ domi bɑ nɛɛ, bu ku rɑɑ ben birikibɑn ɡeeru kɑwe. Tɔ̃ru bɑɑtere kɑ ten sɔmburɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ye tɔn be, bɑ yɑrimɑ Eɡibiti sunɔn min di, bɑ Mɔwisi kɑ Aroni deemɑ bɑ yɔ̃ bɑ bu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Yerɑ bɑ bu sɔ̃ɔwɑ bɑ nɛɛ, Yinni Gusunɔ u bɛɛ wɑɑmɔ. U koo mɑɑ bɛɛ siri. Bɛɛyɑ i sun tusiru kɑsuɑ Eɡibiti sunɔ kɑ win tɔmbun mi. Wee, i tɑkobi doke ben nɔmuɔ bu kɑ sun ɡo. ");
INSERT INTO bba_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Mɑ Mɔwisi u wurɑ Yinni Gusunɔn mi, u nɛɛ, Yinni, mbɑ n derɑ ɑ tɔn be kɔ̃sɑ kuɑmmɛ. Mbɑn sɔ̃nɑ ɑ mɑn ɡɔrimɑ ben mi. ");
INSERT INTO bba_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Sɑɑ mìn di nɑ dɑ Eɡibiti sunɔn mi, nɑ kɑ wunɛn yĩsiru nùn ɡɑri sɔ̃ɔwɑ, u wunɛn tɔmbu ɡɔbɑ kuɑmmɛwɑ, ɑ ǹ mɑɑ bu wɔre sere kɑ tɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, tɛ̃ kɑɑ wɑ ye kon Eɡibiti sunɔ kuɑ. Kon nùn tilɑsi ko u kɑ bu yɔ̃su bu doonɑ. U koo mɑm bu ɡirɑwɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Mɑ Gusunɔ u kpɑm kɑ Mɔwisi ɡɑri kuɑ u nɛɛ, nɛnɑ Wi u rɑ n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Nɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu kure nɑ kɑ bu ɡɑri kuɑ. Bɑ mɑɑ ɡiɑ mɑ nɛnɑ nɑ sɑ̃ɑ Gusunɔ Dɑm kpuroɡii. Adɑmɑ bɑ ǹ tubɑ mɑ nɛn yĩsirɑ Wi u rɑ n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Nɑ mɑɑ kɑ bu ɑrukɑwɑni bɔkuɑ mɑ kon bu Kɑnɑnin tem wɛ̃ mu ko beɡim mɛ̀ sɔɔ bɑ sinɑ nɡe sɔbu. ");
INSERT INTO bba_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Nɑ Isirelibɑn weeweenu nuɑ mi bɑ yoru dimɔ Eɡibitiɡibun mi, nɑ mɑɑ nɛn ɑrukɑwɑni ye yɑɑye. ");
INSERT INTO bba_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","Yen sɔ̃, ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, nɛnɑ Wi u rɑ n wɑ̃ɑ, nɑ kon mɑɑ bu wɔrɑ sɑɑ wɑhɑlɑ ye Eɡibitiɡibɑ bu koosiɑmɔn di. Kon bu yɑkiɑ ben yorun di, kpɑ n nɛn dɑm sɔ̃ɔsi n Eɡibitiɡibu wɑhɑlɑ doke, kpɑ n nɛn tɔmbu fɑɑbɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Kon bu mwɑ bu ko nɛn tɔmbu, kpɑ n ko ben Yinni, kpɑ bu ɡiɑ mɑ nɛnɑ Wi u rɑ n wɑ̃ɑ, nɑ mɑɑ sɑ̃ɑwɑ ben Yinni nɛ wi nɑ bu yɑkiɑmɔ ben yoo sɔmɑ ye Eɡibitiɡibɑ bu koosiɑmɔn di. ");
INSERT INTO bba_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Nɑ kon bu duusiɑ tem mɛ sɔɔ, mɛ nɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu nɔɔ mwɛɛru kuɑ nɑ nɛɛ, kon bu wɛ̃ bɑ n mɔ. Nɛ wi nɑ rɑ n wɑ̃ɑ nɛnɑ nɑ ɡeruɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Yerɑ Mɔwisi u dɑ u Isirelibɑ ɡɑri yi sɔ̃ɔwɑ. Adɑmɑ bɑ ǹ nùn swɑɑ dɑki, domi ben yoo sɔm sɛ̃sɔɡii ni, nu kpɛ̃ɑ sere bɑ mwiɑ kpɑnɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","ɑ seewo ɑ dɑ ɑ Eɡibiti sunɔ sɔ̃ u be de Isirelibɑ bu doonɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Mɑ Mɔwisi u Yinni Gusunɔ wisɑ u nɛɛ, wee Isirelibɑ bɑ ǹ nɛn ɡɑri swɑɑ dɑki. Amɔnɑ Eɡibiti sunɔ u koo kɑ mɑn swɑɑ dɑki. Nɑ ǹ dɑɑ nun sɔ̃ɔwɑ mɑ ɡɑri ɡerubu rɑ n kɑ mɑn sɛ̃? ");
INSERT INTO bba_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Yen biru Yinni Gusunɔ u Mɔwisi kɑ Aroni woodɑ wɛ̃ ye bɑ koo Isirelibɑ kɑ Eɡibiti sunɔ sɔ̃ kpɑ bu kɑ Isirelibɑ yɑrɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Isirelin bii ɡbiikoo wi bɑ mɔ̀ Rubɛni, win bibun yĩsɑ wee, Enɔku kɑ Pɑɑlu kɑ Hɛsironi kɑ Kɑɑmi. Ben min diyɑ Rubɛnin bwese kɛri mɑrurɑ. ");
INSERT INTO bba_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Be bɑ mɑɑ sɑ̃ɑ Simɛɔbɑ, beyɑ Yɛmuɛli kɑ Yɑmini kɑ Ohɑdi kɑ Yɑkini kɑ Sokɑɑ kɑ Sɔɔlu wìn mɛro sɑ̃ɑ Kɑnɑniɡii. Ben min diyɑ Simɛɔn bwese kɛri mɑrurɑ. ");
INSERT INTO bba_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Be bɑ mɑɑ sɑ̃ɑ Lefin bibu, beyɑ Gɛɛsɔni kɑ Kehɑti kɑ Mɛrɑri. Ben min diyɑ Lefin bwese kɛri mɑɑ mɑrurɑ. Ben bɑɑbɑ Lefi wi, u kuɑwɑ wɔ̃ɔ wunɑɑ weeru itɑ sɑri u sere ɡu. ");
INSERT INTO bba_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Mɑ Gɛɛsɔni u seewɑ u bii tɔn durɔbu yiru mɑrɑ. Beyɑ Libini kɑ Simɛi. Mɑ bɑ mɑrurɑ bɑ kuɑ Gɛɛsɔnin bweseru. ");
INSERT INTO bba_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Be bɑ mɑɑ sɑ̃ɑ Kehɑtibɑ, beyɑ Amurɑmu kɑ Yisehɑri kɑ Heboroni kɑ Usiɛli. Mɑ ben bɑɑbɑ Kehɑti wi, u kuɑ wɔ̃ɔ wunɑɑ teeru kɑ wɔkurɑ itɑ u sere kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Be bɑ mɑɑ sɑ̃ɑ Mɛrɑribɑ, beyɑ Mɑkili kɑ Musi. Beni kpurowɑ bɑ kuɑ Lefin bwese kɛri. ");
INSERT INTO bba_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amurɑmu u win tiɔ Yokebɛdi suɑ kurɔ. Wiyɑ u kɑ Aroni kɑ Mɔwisi mɑrɑ. Amurɑmu wi, u kuɑwɑ wɔ̃ɔ wunɑɑ weeru itɑ sɑri u sere kpunɑ u ɡu. ");
INSERT INTO bba_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Be bɑ mɑɑ sɑ̃ɑ Yisehɑrin bibu, beyɑ Kore kɑ Nɛfɛɡi kɑ Sikiri. ");
INSERT INTO bba_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Be bɑ mɑɑ sɑ̃ɑ Usiɛlin bibu, beyɑ Mikɑli kɑ Elisɑfɑni kɑ Sitiri. ");
INSERT INTO bba_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aroni u Elisebɑ, Abinɑdɑbun bii suɑ kurɔ. Kurɔ wi, u sɑ̃ɑwɑ Nɑsonin sesu. Mɑ u kɑ Aroni bibu mɑrɑ. Berɑ Nɑdɑbu kɑ Abihu kɑ Eleɑsɑɑ kɑ Itɑmɑɑ. ");
INSERT INTO bba_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Be bɑ mɑɑ sɑ̃ɑ Koren bibu, beyɑ Asiri kɑ Ɛlikɑnɑ kɑ Abiɑsɑfu. Ben min diyɑ Koren bweserɑ mɑrurɑ. ");
INSERT INTO bba_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Mɑ Eleɑsɑɑ, Aronin bii wi, u Putiɛlin bii wɔndiɑ turo suɑ kurɔ. U kɑ nùn bii tɔn durɔ mɑrɑ. Bii win yĩsirɑ Finɛɛsi. Be sɑ wɑ mi kpuro, beyɑ bɑ sɑ̃ɑ Lefin bwese kɛrin wiruɡibu. ");
INSERT INTO bba_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Be sɔɔrɑ Yinni Gusunɔ u Mɔwisi kɑ Aroni ɡɔsɑ bu kɑ Isirelibɑ yɑrɑ sɑɑ Eɡibitin di. U nɛɛ, bɑ̀ n yɑriɔ bu de bɑ n swĩinɛ bweseru kɑ bweseru bɑ n sɔkɑ sɑ̃ɑ swɛɛ swɛɛ. ");
INSERT INTO bba_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Mɑ Mɔwisi wi kɑ Aroni wi, bɑ wurɑ bɑ dɑ bɑ Eɡibitin sinɑ boko wi kɑnɑ u de Isirelibɑ bu yɑri win tem di. ");
INSERT INTO bba_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Sɑnɑm mɛ Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ Eɡibitiɔ, ");
INSERT INTO bba_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","u nùn sɔ̃ɔwɑ u nɛɛ, nɛnɑ Wi u rɑ n wɑ̃ɑ. A Eɡibiti sunɔ sɔ̃ɔwɔ kpuro ye nɑ nun sɔ̃ɔmɔ mini. ");
INSERT INTO bba_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Mɑ Mɔwisi u Yinni Gusunɔ wisɑ u nɛɛ, wee, ɡɑri ɡerubu rɑ n kɑ mɑn sɛ̃. Eɡibiti sunɔ u koo wurɑ u mɑn swɑɑ dɑki? ");
INSERT INTO bba_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, wee, nɑ nun kuɑ nɛn kɔsire Eɡibiti sunɔn sɔ̃. Wunɛn mɔɔ Aroni u ko n mɑɑ sɑ̃ɑ wunɛn ɡɑri ɡero. ");
INSERT INTO bba_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Wunɑ kɑɑ nùn sɔ̃ ye nɑ nun sɔ̃ɔmɔ kpuro. Wiyɑ u koo mɑɑ Eɡibiti sunɔ sɔ̃, kpɑ u de Isirelibɑ bu doonɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","4","Kon de Eɡibiti sunɔn ɡɔ̃ru ɡu bɔbiɑ sere u ǹ bɛɛ swɑɑ dɑkimɔ, bɑɑ mɛ kon yĩre nɑnumɡii dɑbinu ko win temɔ. Yen sɔ̃, nɑ kon nùn nɛn dɑm sɔ̃ɔsi n win tɔmbu wɑhɑlɑ doke, kpɑ n nɛn tɔmbu Isirelibɑ yɑrɑ win tem di, bɑ n sɔkɑ sɑ̃ɑ swɛɛ swɛɛ nɡe tɑbu kowobu. ");
INSERT INTO bba_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Sɑnɑm mɛ nɑ nɛn dɑm sɔ̃ɔsi tem mi, mɑ nɑ Isirelibɑ yɑrɑ min di, sɑnɑm mɛyɑ Eɡibitiɡibɑ koo ɡiɑ mɑ nɛnɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Mɑ Mɔwisi kɑ Aroni bɑ kuɑ mɑm mɑm nɡe mɛ Yinni Gusunɔ u bu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Sɑnɑm mɛ bɑ kɑ Eɡibiti sunɔ ɡɑri yibɑ mɔ̀, Mɔwisi u mɔwɑ wɔ̃ɔ wɛnɛ, mɑ Aroni u mɔ wɔ̃ɔ wɛnɛ kɑ itɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Yen biru Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","Eɡibiti sunɔ ù n bɛɛ sɔ̃ɔwɑ u nɛɛ, i nùn yĩreru kuo te tɑ sɔ̃ɔsi mɑ nɛnɑ nɑ bɛɛ ɡɔrimɑ, sɑɑ ye sɔɔrɑ wunɛ Mɔwisi kɑɑ Aroni sɔ̃ u win dɛkɑ suo u ye kɔ̃ sunɔ win wuswɑɑɔ. Yɑ koo ɡɔsiɑ wɑɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Mɑ bɑ seewɑ bɑ dɑ Eɡibiti sunɔn mi, bɑ kuɑ ye Yinni Gusunɔ u bu sɔ̃ɔwɑ. Aroni u win dɛkɑ ye kɔ̃ sunɔ wi kɑ win bwɑ̃ɑbun wuswɑɑɔ. Mɑ yɑ ɡɔsiɑ wɑɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","12","Yerɑ Eɡibiti sunɔ u win bwisiɡibu kɑ win timɡibu kɑ win sɔrobu sokɑ. Ben bɑɑwure u dobo dobo kuɑ, u win dɛkɑ kɔ̃ mɑ yɑ ɡɔsiɑ wɑɑ. Adɑmɑ Aroniɡiɑ yɑ beɡii mwɛɛki. ");
INSERT INTO bba_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Kɑ mɛ, Eɡibiti sunɔn ɡɔ̃ru ɡɑ bɔbiɑ, u ǹ mɑɑ Mɔwisi kɑ Aronin ɡere swɑɑ dɑki, nɡe mɛ Yinni Gusunɔ u rɑɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, Eɡibiti sunɔn ɡɔ̃ru ɡɑ bɔbiɑ. U yinɑ tɔn be, bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Wee u koo dɑ dɑɑrɔ buru buru yellu. A doo ɑ kɑ nùn yinnɑ dɑɑrun ɡoorɔ kpɑ ɑ n dɛkɑ ye nɛni, ye yɑ rɑɑ ɡɔsiɑ wɑɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Kpɑ ɑ nùn sɔ̃ ɑ nɛɛ, nɛ Gusunɔ Heberubɑn Yinniwɑ nɑ nun ɡɔrimɑ win mi. U de nɛn tɔmbu bu dɑ bu mɑn sɑ̃ ɡbɑburɔ. Nɑ wɑ mɑ sere kɑ tɛ̃ u ǹ ɡɑri yi swɑɑ sue. ");
INSERT INTO bba_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Yèn sɔ̃ u nɛɛ, u ǹ mɑn yɛ̃, yen sɔ̃nɑ nɑ nɛɛ, ɑmɛniwɑ u koo kɑ mɑn ɡiɑ, nɛ wi nɑ rɑ n wɑ̃ɑ. A dɑɑ ten nim soowo kɑ dɛkɑ ye ɑ nɛni mi, kpɑ n nim mɛ ɡɔsiɑ yɛm. ");
INSERT INTO bba_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Swɛ̃ɛ yi yi wɑ̃ɑ dɑɑ te sɔɔ, kpɑ yi ɡbi, kpɑ dɑɑ ten nim mu sɑnkirɑ sere Eɡibitiɡibu bu kpɑnɑ bu mu nɔ. ");
INSERT INTO bba_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Aroni sɔ̃ɔwɔ u win dɛkɑ suo u ye tĩi Eɡibitin nim kpuron wɔllɔ mɛ mu wɑ̃ɑ dɑɑnɔ kɑ yɛrusɔ kɑ sere kotosɔ kɑ wekenɔ. Mi nim mu wɑ̃ɑ kpuro ɡesi mu koo ɡɔsiɑwɑ yɛm, kpɑ yɛm mu n wɑ̃ɑ Eɡibitin tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Mɑ Mɔwisi kɑ Aroni bɑ kuɑ nɡe mɛ Yinni Gusunɔ u bu sɔ̃ɔwɑ. Aroni u win dɛkɑ ye suɑ, mɑ u dɑɑ ten nim so Eɡibiti sunɔ kɑ win bwɑ̃ɑbun wuswɑɑɔ. Mɑ mu ɡɔsiɑ yɛm. ");
INSERT INTO bba_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Swɛ̃ɛ yi yi wɑ̃ɑ dɑɑ te sɔɔ, yi ɡu. Mɑ dɑɑ ten nim mu sɑnkirɑ. Eɡibitiɡibɑ kpɑnɑ bu mu nɔ. Mɑ nim mɛ mu wɑ̃ɑ tem mɛ kpuro sɔɔ mu kuɑ yɛm. ");
INSERT INTO bba_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Adɑmɑ Eɡibitin sɔrobu bɑ mɑɑ kuɑ mɛ kɑ ben dobo dobo. Ye Eɡibiti sunɔ u wɑ mɛ, mɑ win ɡɔ̃ru ɡɑ bɔbiɑ, u ǹ Mɔwisi kɑ Aronin ɡɑri swɑɑ dɑki nɡe mɛ Yinni Gusunɔ u rɑɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Eɡibiti sunɔ u ɡɔsirɑ win yɛnuɔ. Gɑri yi, yi ǹ mɑm nùn nɑnde. ");
INSERT INTO bba_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Mɑ Eɡibitiɡibu kpuro bɑ tem ɡbɑ ɡbɑ dɑɑ ten ɡoorɔ bu kɑ nim wɑ bu nɔ, domi bɑ ǹ kpɛ̃ bu dɑɑ ten nim nɔ. ");
INSERT INTO bba_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mɑ dɑɑ ten nim mɛ, mu ɡɔsire yɛm n kɑ kuɑ sɔ̃ɔ nɔɔbɑ yiru sɑɑ dɔmɑ tèn di Yinni Gusunɔ u derɑ bɑ mu so. ");
INSERT INTO bba_vpl VALUES ("EX7_26","003_7_26","EXO","7","26","26","Yen biru Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ doo Eɡibiti sunɔn mi, ɑ nùn sɔ̃ ɑ nɛɛ, nɛ Yinni Gusunɔ nɑ nɛɛ, u de nɛn tɔmbu bu dɑ bu mɑn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX7_27","003_7_27","EXO","7","27","27","Ù n mɑɑ yinɑ u bu kɑrɑ bu doonɑ, kon de surenu yibu nu wɑhɑlɑ doke win tem sɔɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("EX7_28","003_7_28","EXO","7","28","28","Surenu koo mɑrurɑ dɑɑ bɑkɑ ten di, kpɑ nu ɡɑsirimɑ sere win yɛnuɔ kɑ win dii sɔɔwɔ kɑ win kpinu wɔllɔ n kɑ dɑ win bwɑ̃ɑbu kɑ win tɔmbun diɑɔ. Nu koo mɑm du sere doo koo yenɔ kɑ sonɔ. ");
INSERT INTO bba_vpl VALUES ("EX7_29","003_7_29","EXO","7","29","29","Sure ni, nu ko nu n kɑbirimɔ kpɑ nu win tii kɑ win tɔmbu kɑ win bwɑ̃ɑbu mɑkiri. ");
INSERT INTO bba_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Aroni sɔ̃ u doo u win nɔmu dɛmiɑ u dɛkɑ ye tĩi dɑɑnu kɑ yɛrusun wɔllɔ kpɑ surenu nu ɡɑsirimɑ nu nɑ nu n wɑ̃ɑ Eɡibitin tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Yerɑ Aroni u win nɔmɑ dɛmiɑ Eɡibitin dɑɑnu ɡiɑ, mɑ surenu nu ɡɑsirimɑ nu Eɡibitin tem wukiri. ");
INSERT INTO bba_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Adɑmɑ Eɡibiti sunɔn sɔro be, bɑ mɑɑ kuɑ mɛ, kɑ ben dobo dobo. Bɑ derɑ surenu nu ɡɑsirimɑ Eɡibitin temɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Mɑ Eɡibiti sunɔ u Mɔwisi kɑ Aroni sokɑ u nɛɛ, i Yinni Gusunɔ kɑnɔ u sure ni doonɑsiɑ nɛ kɑ nɛn tɔmbun min di, kpɑ n de tɔn be, bu doonɑ bu nùn yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Sɑnɑm mɛyɑ Mɔwisi u Eɡibiti sunɔ sɔ̃ɔwɑ u nɛɛ, nɑ wunɛn ɡere mɑrɑ, ɑ mɑn sɔ̃ sɑɑ yerɑ̀ dim dim kon Yinni Gusunɔ kɑnɑ wunɛ kɑ wunɛn tɔmbu kɑ wunɛn bwɑ̃ɑbun sɔ̃, u kɑ de sure ni, nu tondɑ bɛɛ kɑ bɛɛn yɛnusun di, kpɑ nu kun mɑɑ tie mɑ n kun mɔ dɑɑ bɑkɑru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","U wisɑ u nɛɛ, siɑ. Mɑ Mɔwisi u nɛɛ, n koo koorɑ mɛ, kpɑ ɑ ɡiɑ mɑ ɡoo sɑri wi u sɑ̃ɑ nɡe Gusunɔ bɛsɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Sure ni, nu koo kɑ nun tondɑ nu ɡɛɛrɑ wunɛn bwɑ̃ɑbu kɑ wunɛn tɔmbu kɑ bɛɛn yɛnusun di. Dɑɑ bɑkɑru tɔnɑ sɔɔrɑ nu ko nu n tie. ");
INSERT INTO bba_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Yen biru Mɔwisi kɑ Aroni bɑ yɑrɑ Eɡibiti sunɔn min di. Mɑ Mɔwisi u Yinni Gusunɔ nɔɔɡiru sue u sure ni ɡirɑ ni u Eɡibiti sunɔ wisi mi. ");
INSERT INTO bba_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Mɑ Yinni Gusunɔ u kuɑ nɡe mɛ Mɔwisi u bikiɑ. Yerɑ sure ni, nu ɡbisukɑ diɑɔ kɑ yɛnu yɑɑriɔ kɑ ɡbeɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Bɑ nu ɡurɑ bɑ mɛnnɑ mɛnnɑ. Mɑ nin nuburɑ yibɑ tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Ye Eɡibiti sunɔ u wɑ mɑ wɑhɑlɑ yɑ dwiiyɑ yerɑ u kpɑm win ɡɔ̃ru bɔbiɑsiɑ. U ǹ mɑɑ Mɔwisi kɑ Aroni swɑɑ dɑki, nɡe mɛ Yinni Gusunɔ u rɑɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Yen biru Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, u Aroni sɔ̃ɔwɔ u win dɛkɑ suo u tem so, kpɑ tuɑ yu ɡɔsiɑ ɡɑɑnikunu Eɡibitin tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mɑ bɑ kuɑ nɡe mɛ. Tuɑ kpuro yɑ ɡɔsiɑ ɡɑɑnikunu tem mɛ kpuro sɔɔ. Gɑɑnikuu ni, nu duɑ tɔmbu kɑ yɑɑ sɑbenu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Mɑ sɔrobu bɑ dobo dobo kuɑ bu kɑ mɑɑ ɡɑɑnikunu ko. Adɑmɑ bɑ kpɑnɑ. Gɑɑnikuu ni, nu wɑ̃ɑwɑ bɑɑmɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Yerɑ sɔro be, bɑ Eɡibiti sunɔ sɔ̃ɔwɑ bɑ nɛɛ, Gusunɔn tiin dɑmɑ mini. Adɑmɑ kɑ mɛ, Eɡibiti sunɔn ɡɔ̃ru ɡɑ bɔɔbu. U ǹ Mɔwisi kɑ Aronin ɡɑri swɑɑ dɑki nɡe mɛ Yinni Gusunɔ u rɑɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Yen biru Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ seewo buru buru yellu ɑ dɑ ɑ kɑ Eɡibiti sunɔ yinnɑ sɑnɑm mɛ u dɔɔ dɑɑrɔ, kpɑ ɑ nùn sɔ̃ ɑ nɛɛ, ɑmɛniwɑ nɛ Yinni Gusunɔ nɑ ɡeruɑ. U de nɛn tɔmbu bu dɑ bu mɑn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Ù n mɑɑ yinɑ nɛn tɔmbu bu doonɑ kon nùn ɡbɑbu swɛ̃ɛ suremɑ yi yi koo wi kɑ win bwɑ̃ɑbu kɑ win tɔmbu kuni. Eɡibitiɡibun yɛnusu kpurowɑ su ko n ɡbɑbu swɛ̃ɛ yibɑ kpɑ yi tem wukiri. ");
INSERT INTO bba_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Adɑmɑ dɔmɑ te, nɑ ǹ derimɔ ɡbɑbu swɛ̃ɛ yi dɑ Gosɛniɔ mi nɛn tɔmbɑ wɑ̃ɑ, kpɑ u ɡiɑ mɑ nɛ, Yinni Gusunɔ nɑ wɑ̃ɑ tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Kon nɛn tɔmbu kɑ win tɔmbu wunɑnɑ. Siɑwɑ yĩre te, tɑ koo sɔ̃ɔsirɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Yinni Gusunɔ u kuɑ nɡe mɛ. Gbɑbu swɛ̃ɛ wuuru tɑ Eɡibiti sunɔ kɑ win bwɑ̃ɑbun yɛnusu wɔri. Mɑ Eɡibitin tem kpuro mu sɑnkirɑ ɡbɑbu swɛ̃ɛ yin sɑɑbu. ");
INSERT INTO bba_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Yerɑ Eɡibiti sunɔ u Mɔwisi kɑ Aroni sokusiɑ u nɛɛ, i doo i bɛɛn Yinni yɑ̃ku te kuɑ tem mɛ sɔɔ, i ku yɑri. ");
INSERT INTO bba_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","Adɑmɑ Mɔwisi u wisɑ u nɛɛ, n ǹ koorɔ mɛ domi bɛsɛn yɑ̃kunu ko n sɑ̃ɑ tɑɑrɛ Eɡibitiɡibun nɔni sɔɔ. Sɑ̀ n mɑɑ yɑ̃ku tɑɑrɛɡinu kuɑ ben nɔni biru, bɑ ǹ koo sun kpenu kɑsuku? ");
INSERT INTO bba_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Yen sɔ̃, sɑ ko dɑwɑ ɡbɑburɔ mi n tomɑ nɡe sɔ̃ɔ itɑn sɑnum sɑkɑ su kɑ Gusunɔ bɛsɛn Yinni yɑ̃kuru kuɑ, nɡe mɛ u sun sɔ̃ɔwɑ su ko. ");
INSERT INTO bba_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Eɡibiti sunɔ u nɛɛ, kon de i dɑ i Gusunɔ bɛɛn Yinni yɑ̃kuru kuɑ ɡbɑburɔ, ɑdɑmɑ i ku tondɑ. Yen sɔ̃, i kɑnɑru koowo nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Mɑ Mɔwisi u nùn wisɑ u nɛɛ, wee, nɑ doonɔ wunɛn min di, n kɑ Yinni Gusunɔ kɑnɑ wunɛn sɔ̃. Siɑ ɡbɑbu swɛ̃ɛ yi, yi koo doonɑ wunɛ kɑ wunɛn bwɑ̃ɑbu kɑ wunɛn tɔmbun min di. Adɑmɑ ɑ ku mɑɑ sun yɑɑkoru ko ɑ yinɑ su dɑ su Gusunɔ bɛsɛn Yinni yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Yerɑ Mɔwisi u yɑrɑ Eɡibiti sunɔn min di, u dɑ u Yinni Gusunɔ suuru kɑnɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Mɑ Yinni Gusunɔ u kuɑ nɡe mɛ Mɔwisi u nùn bikiɑ. Gbɑbu swɛ̃ɛ yi, yi tondɑ Eɡibiti sunɔ kɑ win bwɑ̃ɑbu kɑ win tɔmbun min di. Yi ǹ mɑɑ tie mi, bɑɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Adɑmɑ kɑ mɛ kpuro, Eɡibiti sunɔn ɡɔ̃ru ɡɑ bɔbiɑ kpɑm mɑɑ, mɑ u yinɑ tɔn be, bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Yen biru kpɑm Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ doo Eɡibiti sunɔn mi kpɑ ɑ nùn sɔ̃ ɑ nɛɛ, ɑmɛniwɑ nɛ Heberubɑn Yinni Wi u rɑ n wɑ̃ɑ nɑ ɡeruɑ. Nɑ nɛɛ, u de nɛn tɔmbu bu doonɑ bu mɑn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Adɑmɑ ù kun bu yɔ̃su, mɑ u yen yinɑ yinɑminu mɔ̀ kpɑm, ");
INSERT INTO bba_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","wee, kon nɛn nɔm dɑmɡuu doke win dumi kɑ kɛtɛkunu kɑ yooyoosu kɑ kɛtɛbɑ kɑ yɑ̃ɑnu sɔɔ, win yɑɑ sɑbenu kpuro ɡesi ni bɑ kpɑrɑmɔ ɡberɔ. Adumɡbɛku bɑkɑ yɑ koo nu wɔri. ");
INSERT INTO bba_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Sɑɑ ye sɔɔ, kon Isirelibɑn sɑbenu kɑ Eɡibitiɡinu wunɑnɑ. Ye yɑ sɑ̃ɑ Isirelibɑn sɑbenu, yen ɡɑɑ kun ɡbimɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mɑ Yinni Gusunɔ u tɔ̃ru yi u nɛɛ, ù kun bu yɔ̃su, siɑwɑ kon yɑbu ye ko tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Yen sisiru Yinni Gusunɔ u kuɑ mɛ. Eɡibitiɡibun sɑbenu ɡbisukɑ kpuro, ɑdɑmɑ Isirelibɑn sɑbenu sɔɔ, bɑɑ teeru tɑ ǹ ɡu. ");
INSERT INTO bba_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Eɡibiti sunɔ u ye yɑ koorɑn lɑbɑɑri bikiɑ. U nuɑ mɑ Isirelibɑn sɑbenu sɔɔ bɑɑ teeru tɑ ǹ ɡu. Kɑ mɛ, win ɡɔ̃ru ɡɑ kpɑm bɔbiɑ, u ǹ wure tɔn be, bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Yinni Gusunɔ u kpɑm Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, i torom sɔko doowɔ i n nɛni, kpɑ Mɔwisi u mɛ yɛ̃kɑ wɔllɔ Eɡibiti sunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Torom mɛ, mu koo ɡɔsiɑ nɡe tuɑ, kpɑ mu Eɡibitin tem kpuro wukiri. Mu koo bwisinu wisi tɔmbu kɑ sɑbenu sɔɔ, kpɑ nu booboosu ko. ");
INSERT INTO bba_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Yerɑ bɑ torom mɛ sɔkɑ bɑ dɑ Eɡibiti sunɔn wuswɑɑɔ. Mɑ Mɔwisi u torom mɛ yɛ̃kɑnɑ wɔllɔ, mɑ mu kuɑ bwisinu tɔmbu kɑ sɑbenun wɑsi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Sɑɑ ye sɔɔ, sɔrobɑ kpɑnɑ bu yɑrimɑ Mɔwisin wuswɑɑɔ bwisi nin sɔ̃. Domi nu ben tii wisiwɑ nɡe Eɡibitiɡii be bɑ tie. ");
INSERT INTO bba_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Eɡibiti sunɔ u ǹ Mɔwisi kɑ Aronin ɡɑri swɑɑ dɑki. Yinni Gusunɔ u derɑ win ɡɔ̃ru ɡɑ bɔbiɑ ɡɑ sosi nɡe mɛ u rɑɑ Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Yerɑ Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ seewo buru buru yellu ɑ dɑ Eɡibiti sunɔn mi, kpɑ ɑ nùn sɔ̃ ɑ nɛɛ, ɑmɛniwɑ nɛ Gusunɔ Heberubɑn Yinni nɛ wi nɑ rɑ n wɑ̃ɑ nɑ ɡeruɑ. U de nɛn tɔmbu bu doonɑ bu mɑn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Domi tɛ̃, n ǹ mɔ win bwɑ̃ɑbu kɑ win tɔmbu tɔnɑ kon wɑhɑlɑ doke ye yɑ koo nɛn dɑm bɑkɑm sɔ̃ɔsi. Kɑ win tiiwɑ kpɑ u ɡiɑ mɑ ɡoo sɑri nɡe nɛ hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Nɑ̀ n dɑɑ nɛn nɔm dɑmɡuu dɛmiɑ nɑ wi kɑ win tɔmbu bɑrɑ kɔ̃suru kpɛ̃ɛ, u ǹ ko n dɑɑ mɑɑ wɑ̃ɑ hɑnduniɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Adɑmɑ nɑ derɑ u wɑ̃ɑ u kɑ nɛn dɑm wɑn sɔ̃, kpɑ nɛn yĩsiru tu kɑ nɔɔrɑ hɑnduniɑ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Wee u kɑ nɛn tɔmbu seewɑ sere kɑ tɛ̃. U ǹ dere bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Yen sɔ̃, siɑ ɑmɑdɑɑre kon de ɡuru kpenu nu nɛɛrɑ kɑ dɑm nìn bweseru nu ǹ koore Eɡibitin temɔ sɑɑ yen toren di sere n kɑ ɡisɔ ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Ǹ n mɛn nɑ, ɑ de bu win yɑɑ sɑbenu kuku yeru kuɑ, kɑ yɑbu ye u mɔ kpuro ɡberɔ. Domi ɡuru kpee ni, nu koo tɔmbu kpuro so ɡbeɑɔ kɑ yɑɑ sɑbenu kpuro ni nu ǹ kuku yeru wɑ, kpɑ sɑbe ni, kɑ tɔn be, bu kɑm ko. ");
INSERT INTO bba_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Yerɑ Eɡibiti sunɔn bwɑ̃ɑbu ɡɑbu be bɑ Yinni Gusunɔn ɡɑri nɑsie, bɑ derɑ ben yobu bɑ kɑ ben sɑbenu wɔmɑ yɛnuɔ fuuku fuuku. ");
INSERT INTO bba_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Be bɑ kun mɑɑ Yinni Gusunɔn ɡɑri ɡɑrɑ, bɑ ben yobu kɑ yɑɑ sɑbenu deri ɡbeɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn nɔmɑ suo wɔllɔ kpɑ ɡuru kpenu nu yɛ̃kɑmɑ Eɡibitin tem kpuro sɔɔ, tɔmbu kɑ sɑbenu kɑ ye yɑ kpiɑ ɡbeɑɔ kpuron wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Yerɑ Mɔwisi u win dɛkɑ suɑ u tĩi wɔllɔ, mɑ Yinni Gusunɔ u derɑ ɡuru kpenu nɛmɔ. Guru mɑɑkinu mɔ̀ nu ɡirɑrimɔ sere temɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Gurɑ yen bweserɑ kun nɛɛre Eɡibitin tem sɔɔ sɑɑ yen toren di. ");
INSERT INTO bba_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Mɑ ɡuru kpee ni, nu bɑɑyere kpuro so nu ɡo ye yɑ wɑ̃ɑ ɡbeɑɔ Eɡibitin tem sɔɔ, sɑɑ tɔmbu sere kɑ sɑbenu kɑ ye yɑ kpiɑ kpuro. Mɑ dɑ̃nu kpuro nu bɛsikirɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Gosɛnin berɑ mi Isirelibɑ bɑ wɑ̃ɑ tɔnɑwɑ ɡuru kpee ni, nu ǹ nɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Yerɑ Eɡibiti sunɔ u Mɔwisi kɑ Aroni sokusiɑ u nɛɛ, nɑ wɑ mɑ nɛnɑ nɑ torɑ. Gusunɔ wi u rɑ n wɑ̃ɑ u ɡem mɔ. Nɛ kɑ nɛn tɔmbu sɑ tɑɑrɛ kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","A Yinni Gusunɔ kɑnɔ domi ɡuru ɡbɑ̃suku ni, kɑ ɡuru kpee ni, nu den turɑ. Kon de i doonɑ, nɑ ǹ mɑɑ bɛɛ nɛnumɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Mɑ Mɔwisi u nùn wisɑ u nɛɛ, nɑ̀ n yɑrɑ wuun di kon nɛn nɔmɑ suɑ wɔllɔ n Yinni Gusunɔ kɑnɑ, kpɑ ɡuru ɡbɑ̃sukunu kɑ ɡuru kpenu nu mɑri ɑ kɑ ɡiɑ mɑ wiyɑ hɑnduniɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Adɑmɑ nɑ yɛ̃ mɑ wunɛ kɑ wunɛn bwɑ̃ɑbu i ǹ Yinni Gusunɔ nɑsiɑm kpɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Sɑɑ ye ɡurɑ ye, yɑ nɑ, wɛ̃su kɑ ɔɔsu kɑm kuɑ yèn sɔ̃ ɔɔsu yɑ nɔɔ kusiɑ, wɛ̃su mɑɑ wɛ̃su sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Adɑmɑ ɑlikɑmɑ yɑ ǹ kɑm kue yèn sɔ̃ yɑ ǹ sɑnɑm mɛ kpɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Yen biru Mɔwisi u yɑrɑ Eɡibiti sunɔn min di u dɑ wuun biruɔ. Mɑ u win nɔmɑ suɑ wɔllɔ u Yinni Gusunɔ kɑnɑ, mɑ ɡuru ɡbɑ̃sukunu kɑ ɡuru kpee ni, nu mɑri. Gurɑ kun mɑɑ nɛmɔ. ");
INSERT INTO bba_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Ye Eɡibiti sunɔ u wɑ mɛ, u win torɑru sosi. Wi kɑ win bwɑ̃ɑbɑ ben ɡɔ̃rusu bɔbiɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","U ǹ wure Isirelibɑ bu doonɑ nɡe mɛ Yinni Gusunɔ u rɑɑ ɡeruɑ sɑɑ Mɔwisin nɔɔn di. ");
INSERT INTO bba_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","2","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, nɑ derɑ Eɡibiti sunɔ kɑ win bwɑ̃ɑbun ɡɔ̃rusu bɔbiɑ, kpɑ n kɑ nɛn yĩre ni sɔ̃ɔsi ben suunu sɔɔ. Kpɑ wunɛn tii ɑ kɑ wunɛn bibu kɑ wunɛn debuminu sɔ̃ nɡe mɛ nɑ kɑ Eɡibitiɡibu yɑɑkoru kuɑ, kɑ yĩre ni nɑ sɔ̃ɔsi ben suunu sɔɔ kpɑ i n kɑ yɛ̃ mɑ nɛnɑ Gusunɔ wi u rɑ n wɑ̃ɑ. Ǹ n mɛn nɑ, ɑ doo Eɡibiti sunɔn mi. ");
INSERT INTO bba_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Mɔwisi kɑ Aroni bɑ dɑ sunɔ win mi, bɑ nɛɛ, ɑmɛniwɑ bɛsɛ Heberubɑn Gusunɔ wi u rɑ n wɑ̃ɑ u ɡeruɑ. U nɛɛ, sere dommɑ kɑɑ n yinɛ ɑ tii kɑwɑ win wuswɑɑɔ. A de win tɔmbu bu doonɑ bu nùn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","À n mɑɑ yinɑ ɑ bu kɑrɑ, wee, siɑ u koo de twee yi nɑ wunɛn tem kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Yi koo tɛriɑ yi tem wukiri. Bɑɑ tem bɑu bɑ ǹ wɑsi. Yi koo dĩɑ ni nu tie di ni ɡuru kpenu kun sɑnkɑ, kpɑ yi bɛɛn ɡbeɑn dɑ̃ɑ wurusu kpuro di. ");
INSERT INTO bba_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Yi koo wunɛ kɑ wunɛn bwɑ̃ɑbu kɑ Eɡibitiɡibu kpuron diɑ duuri yi yibu. Wunɛn bɑɑbɑbɑ kɑ wunɛn sikɑdobɑ bɑ ǹ yen bweseru wɑɑre sɑɑ mìn di bɑ wɑ̃ɑ hɑnduniɑ sɔɔ sere kɑ ɡisɔ. Mɑ Mɔwisi u seewɑ u yɑrɑ Eɡibiti sunɔn min di. ");
INSERT INTO bba_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Yerɑ Eɡibiti sunɔn bwɑ̃ɑbɑ nùn bikiɑ bɑ nɛɛ, sere dommɑ durɔ wini u ko n sun wɑhɑlɑ mɔ̀. A de tɔn be, bu doonɑ bu dɑ bu Gusunɔ ben Yinni sɑ̃. A ǹ wɑ mɑ bɛsɛn tem mu kɑm kobu dɔɔ? ");
INSERT INTO bba_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Mɑ bɑ derɑ Mɔwisi kɑ Aroni bɑ wurɑmɑ Eɡibiti sunɔn mi. Ye bɑ turɑ mi, yerɑ u bu sɔ̃ɔwɑ u nɛɛ, i doo i Gusunɔ bɛɛn Yinni sɑ̃, ɑdɑmɑ bɛɛ sɔɔ berɑ̀ bɑ koo dɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Mɔwisi u wisɑ u nɛɛ, bɛsɛ kpurowɑ, bibu kɑ bukurobu kɑ bɛsɛn yɑɑ sɑbenu. Sɑnnɑ sɑ ko dɑ. Domi tɔ̃ɔ bɑkɑrɑ sɑ ko Yinni Gusunɔ kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Mɑ Eɡibiti sunɔ u bu yɑɑkoru kuɑ u nɛɛ, Yinni Gusunɔ u kɑ bɛɛ dɑ bɑɑni, nɑ̀ n derɑ i dɑ kɑ bɛɛn kurɔbu kɑ bibu. Domi ɡɑ̃ɑ kɔ̃sunɑ i bwisikumɔ. ");
INSERT INTO bba_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Adɑmɑ bɛɛ tɔn durɔbu tɔnɑwɑ i ko dɑ. Domi mɛyɑ i bikiɑ. Yerɑ u derɑ bɑ bu ɡirɑ win min di. ");
INSERT INTO bba_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn dɛkɑ suo ɑ tĩi Eɡibitin tem sɔɔ kpɑ twee yi nɑ yi tem mɛ wukiri, yi kpuro di ye yɑ kpiɑ mi, ye ɡuru kpenu nu deri. ");
INSERT INTO bba_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Yerɑ Mɔwisi u win dɛkɑ ye suɑ u tĩi mi. Mɑ Yinni Gusunɔ u derɑ woo ɡɑɡɑ seemɑ sɑɑ sɔ̃ɔ yɑri yerun di tem mɛ sɔɔ. Woo ɡe, ɡɑ kuɑwɑ sɑɑ sɔ̃ɔ sɔɔn di sere kɑ wɔ̃kuru kpuro. Sisi bururu bɑ deemɑ twee wee yɑm kpuro yi woo ɡe, ɡɑ kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Twee yi, yi nɑ wuunu kɑ wuunu yi pusɑ Eɡibitin tem bɑɑmɑ. Yi dɑbiɑ yi sɑrɑ yi bɑ rɑɑ wɑɑre. Mɛyɑ bɑ ǹ mɑɑ yin bweseru wɑsi. ");
INSERT INTO bba_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Tem kpuro mu tĩrɑ twee yin sɑɑbu. Mɑ yi yɑkɑsu kɑ dɑ̃ɑ binu kpuro di, ni ɡuru kpenu kun dɑɑ sɑnkɑ. Wuru ɡɑɡɑ kun mɑɑ tie Eɡibitin tem sɔɔ dɑ̃ɑɔ kɑ dɑ̃ɑ kikisɔ. ");
INSERT INTO bba_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Yerɑ Eɡibiti sunɔ u Mɔwisi kɑ Aroni sokusiɑ fuuku u nɛɛ, nɑ Gusunɔ bɛɛn Yinni torɑ, mɛyɑ, nɑ mɑɑ bɛɛn tii torɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Tɛ̃, i mɑn suuru kuo nɔn tee teni kpɑ i Gusunɔ bɛɛn Yinni kɑnɑ u mɑn wɑhɑlɑ ɡɔɔɡiɑ yeni wunɑri. ");
INSERT INTO bba_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Mɑ Mɔwisi u yɑrɑ min di u dɑ u Yinni Gusunɔ suuru kɑnɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Yerɑ Yinni Gusunɔ u derɑ woo dɑmɡuu ɡɑ seemɑ sɑɑ sɔ̃ɔ duu yerun di ɡɑ kɑ twee yi doonɑ ɡɑ ɡure nim wɔ̃ku sɔɔ ɡe bɑ mɔ̀ Nɑɑ yɑri. Bɑɑ yin tiɑ kun tiɑre tem mɛ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Adɑmɑ Yinni Gusunɔ u kpɑm derɑ Eɡibiti sunɔn ɡɔ̃ru ɡɑ bɔbiɑ, u ǹ wure Isirelibɑ bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Yen biru Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn dɛkɑ tĩiyɔ wɔllɔ kpɑ yɑm wɔ̃ku sinumɡiru tu Eɡibitin tem wukiri, sere bu tu bɑbɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Yerɑ Mɔwisi u win dɛkɑ ye tĩi wɔllɔ mɑ yɑm wɔ̃kurɑ kuɑ Eɡibitin tem kpuro sɔɔ sɔ̃ɔ itɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Eɡibitiɡibɑ kun wɑɑnɑmɔ, ɡoo kun seere win yɛnun di sere sɔ̃ɔ itɑ ye. Adɑmɑ mi Isirelibɑ bɑ wɑ̃ɑ kpuro, yɑm bururɑm mu wɑ̃ɑwɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Eɡibiti sunɔ u Mɔwisi sokusiɑ u nɛɛ, i doo i Yinni Gusunɔ sɑ̃ kɑ bɛɛn kurɔbu kɑ bibu sɑnnu. Adɑmɑ i ku kɑ bɛɛn yɑɑ sɑbenu dɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Mɔwisi u wisɑ u nɛɛ, ǹ n mɛn nɑ, ɑ sun yɑɑ sɑbenu wɛ̃ɛyɔ domi n ǹ koo koorɑ sɑ kun nu mɔ su kɑ Gusunɔ bɛsɛn Yinni yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kɑ yɑ̃kunu ɡɑnu kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Yen sɔ̃, sɑ ko kɑ bɛsɛn yɑɑ sɑbenu dɑwɑ, bɑɑ sɑmu sɑ ǹ derimɔ. Domi miyɑ sɑ ko ɡɔsi ye sɑ ko kɑ nùn sɑ̃. Sɑ ǹ mɑɑ ɡinɑ yen ɡeeru yɛ̃ kɑ yen ye sɑ ko ɡɔsi sere sɑ̀ n turɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Adɑmɑ Yinni Gusunɔ u derɑ Eɡibiti sunɔn ɡɔ̃ru ɡɑ bɔbiɑ, u ǹ wure bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Mɑ sunɔ wi, u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ ɡɛsiro nɛn bɔkun di. A ku rɑ mɑɑ nɑ nɛn wuswɑɑɔ, domi dɔmɑ te nɑ mɑɑ nun wɑ, ɑ ɡuwɑ. ");
INSERT INTO bba_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Mɔwisi u nɛɛ, too, yɑ wɑ̃, ɑ ǹ mɑɑ mɑn wɑsi. ");
INSERT INTO bba_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","N deemɑ Yinni Gusunɔ u rɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, n tie wɑhɑlɑ tiɑ ye kon Eɡibitiɡibu kɑ ben sunɔ doke. Yerɑ yɑ koo de u bɛɛ yɔ̃su. U koo mɑm bɛɛ ɡirɑwɑ minin di kɑ dɑm. ");
INSERT INTO bba_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","A tɔn durɔ kɑ tɔn kurɔ bɑɑwure sɔ̃ɔwɔ u burɑ yɑ̃ɑ wurɑɡinu kɑ sii ɡeesuɡinu kɑnɑ win beruse Eɡibitiɡiin mi. ");
INSERT INTO bba_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","N deemɑ Yinni Gusunɔ u derɑ Eɡibitiɡibu bɑ kɑ Isirelibɑ nɔnu ɡeu mɛɛrɑ. Mɔwisi u mɑɑ sɑ̃ɑ tɔn boko sunɔn bwɑ̃ɑbu kɑ Eɡibitiɡii be bɑ tien nɔni sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Mɔwisi u sere doonɑ Eɡibiti sunɔn min di, u nùn sɔ̃ɔwɑ u nɛɛ, ɑmɛniwɑ Yinni Gusunɔ u ɡeruɑ. Wɔ̃kurun bɔnun sɑkɑwɑ u koo Eɡibitin tem bukiɑnɑ. ");
INSERT INTO bba_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Bii yerumɑbɑ kpuro bɑ koo ɡbi, sɑɑ wunɛn bii yerumɑn di, wi u koo wunɛn sinɑ ɡɔnɑ tubi di sere kɑ yoo tɔn kurɔn bii tɔn durɔ ɡbiikoowɔ. Yɑɑ sɑbenun bii ɡbiikii dwɑnu nu koo mɑɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Wuri bɛkɛ yi ko n wɑ̃ɑ Eɡibitin tem kpuro sɔɔ dɔmɑ te, yìn bweseru yi ǹ koore. Mɛyɑ yi ǹ koo mɑɑ wure yi ko. ");
INSERT INTO bba_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Adɑmɑ bɛsɛ Isirelibɑn mi, bɑɑ bɔ̃ɔ ɡɑ ǹ sun worimɔ sere kɑ bɛsɛn yɑɑ sɑbenɔ, kpɑ i n kɑ yɛ̃ mɑ Yinni Gusunɔ u sun wunɑnɛ kɑ bɛɛ Eɡibitiɡibu. ");
INSERT INTO bba_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Mɑ Mɔwisi u kpɑm nɛɛ, wunɛn bwɑ̃ɑbu kpuro bɑ koo nɑ bu kpunɑ nɛn wuswɑɑɔ bu mɑn sɔ̃ bu nɛɛ, n yɑrio kɑ nɛn tɔmbu kpuro be bɑ mɑn swĩi. Yen biru nɑ kon den yɑri n doonɑ. Ye u ɡɑri yi ɡeruɑ u kpɑ, mɑ u yɑrɑ Eɡibiti sunɔn min di kɑ mɔru bɑkɑ. ");
INSERT INTO bba_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Yinni Gusunɔ u rɑɑ nùn sɔ̃ɔwɑ u nɛɛ, Eɡibiti sunɔ kun wunɛn ɡɑri swɑɑ dɑkimɔ. Yerɑ yɑ koo de n mɑɑ sɔm mɑɑmɑɑkiɡinu ɡɑnu ko Eɡibitin temɔ. ");
INSERT INTO bba_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Mɔwisi kɑ Aroni bɑ sɔm mɑɑmɑɑkiɡii ni kpuro kuɑ Eɡibiti sunɔn wuswɑɑɔ ɑdɑmɑ Yinni Gusunɔ derɑ win ɡɔ̃ru ɡɑ bɔbiɑ mɑ u ǹ wure Isirelibɑ bu doonɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mɔwisi kɑ Aroni bu sere yɑri Eɡibitin di Yinni Gusunɔ u bu sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","suru winiwɑ u koo ko bɛɛn suru ɡbiikoo wɔ̃ɔ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","I Isirelibɑ kpuro sɔ̃ɔwɔ i nɛɛ, suru winin sɔ̃ɔ wɔkuru, ben yɛnu yɛ̃ro bɑɑwure u yɑ̃ɑ kinɛ kpɛndu ɡɔsi win yɛnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Yɛnu yɛ̃ro wìn tɔmbɑ kun dɑbiru turɑ bu kɑ yɑ̃ɑ ɡiriru tem, wi kɑ win beruse bu yɑ̃ɑru ɡɔsio te beɡibɑ koo kpĩ bu tem bu kpe. ");
INSERT INTO bba_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","I ko kpĩ i yɑ̃ɑru ǹ kun mɛ boo ɡɔsi, ɑdɑmɑ i de yɑ n sɑ̃ɑ kinɛru te tɑ wɔ̃ɔ tiɑ mɔ, kpɑ tɑ kun ɑlebu mɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","I ko nu berewɑ sere suru win sɔ̃ɔ wɔkurɑ nnɛ, kpɑ bɛɛ Isirelibɑ kpuro i nu ɡo dɔmɑ ten yokɑ kpɑɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","I ko nin yɛm suɑ i tɛɛniwɑ dinu mi i ko nin yɑɑ tem kɔnnɔsun beri berikɑ kɑ sin wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Wɔ̃ku terɑ bɑ koo yɑɑ ye wɔ̃ kpɑ bu ye di kɑ pɛ̃ɛ ye bɑ ǹ seeyɑtiɑ doke kɑ kpee wuru si su sosu sɑnnu. ");
INSERT INTO bba_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","I ku yen ɡɔmɑ tem, ǹ kun mɛ ye bɑ yikuɑ. I ye wɔ̃ɔwɔ ɡirum ɡirum kɑ yen wiru kɑ tɑɑnu kɑ bɔsɔ yɑ̃nu. ");
INSERT INTO bba_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Yɑ̀ n mɑɑ tiɑrɑ i ko ye wisiwɑ dɔ̃ɔ sɔɔ. I ku de yen ɡɑɑ yu yɑm sɑ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Wee mɛ i ko i n sɑ̃ɑ i kɑ ye di. I n sɔɔru sɑ̃ɑ i kɑ swɑɑ wɔri, i n ɡbɑburun yɑ̃nu doke, i n bokunu nɛni, kpɑ i di kɑ wɑsi kɑsɑnu, domi yɑ sɑ̃ɑwɑ tɔ̃ɔ bɑkɑru te i ko mɑn diiyɑ Gɔɔ sɑrɑribun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","Wɔ̃ku terɑ kon Eɡibitin tem bukiɑnɑ kpɑ n bii tɔn durɔ ɡbiikoo bɑɑwure ɡo, tɔmbun bibu kɑ yɑɑ sɑbenun binu. Mɛyɑ kon kɑ sɔ̃ɔsi mɑ Eɡibitiɡibun bũnu nu ǹ dɑm mɔ. Nɛ, Yinni Gusunɔwɑ kon ye ko. ");
INSERT INTO bba_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Yɛm mɛyɑ mu koo ko yĩreru te tɑ yɛnusu sɔ̃ɔsimɔ mi i wɑ̃ɑ. Nɑ̀ n yɛm mɛ wɑ, kon bɛɛ sɑrɑriwɑ. Kɛ̃si te, tɑ ǹ bɛɛ bɑbɑmɔ te kon kɑ Eɡibitiɡibu wɑhɑlɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","I ko i n dɑ tɔ̃ɔ te yɑɑyewɑ wɔ̃ɔ kɑ wɔ̃ɔ, kpɑ i mɑn tɔ̃ɔ bɑkɑru diiyɑ. Bɛɛn bibun bweseru bɑ ko n dɑ mɑɑ tu yɑɑyewɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Yinni Gusunɔ u mɑɑ nɛɛ, i ko kowɑ sɔ̃ɔ nɔɔbɑ yiru i ku pɛ̃ɛ di ye bɑ seeyɑ. Tɔ̃ɔ ɡbiikiru i ko pɛ̃ɛ seeyɑtiɑ yɑrɑ bɛɛn yɛnusun di. Domi bɛɛn ɡoo ù n ɡɑ̃ɑnu di ni nu seeyɑtiɑ mɔ sɔ̃ɔ nɔɔbɑ yiru ye, yu sere yibu, bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Tɔ̃ɔ ɡbiikiru kɑ tɔ̃ru nɔɔbɑ yiruse, i ko mɛnnɑwɑ i mɑn sɑ̃. I ku rɑ sɔmburu ɡɑru ko tɔ̃nu yiru ye sɔɔ, mɑ n kun mɔ bɛɛn dĩɑ ni i ko din kobu. ");
INSERT INTO bba_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","I ko n dɑ pɛ̃ɛ ye bɑ ǹ seeyɑtiɑ doken tɔ̃ɔ bɑkɑru di, domi tɔ̃ɔ te sɔɔrɑ nɑ bɛɛn bweseru kpuro yɑrɑ Eɡibitin tem di. Yen sɔ̃, bɛɛn bibun bweseru bɑ ko n dɑ tɔ̃ɔ bɑkɑru diwɑ tɔ̃ɔ te sɔɔ, sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Suru ɡbiikoon sɔ̃ɔ wɔkurɑ nnɛsen yokɑn di, pɛ̃ɛ ye bɑ ǹ seeyɑtiɑ dokewɑ i ko i n dimɔ sere kɑ win sɔ̃ɔ yɛndɑ tiɑsen yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Sɔ̃ɔ nɔɔbɑ yiru yen bɑɑ sɔɔ, bu ku rɑɑ pɛ̃ɛ seeyɑtiɑ wɑ bɛɛn yɛnusɔ. Domi wi u ɡɑ̃ɑnu di ni bɑ seeyɑtiɑ doke, bɑ koo yɛ̃ro ɡowɑ, bɑɑ ù n sɔɔn nɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Ǹ n mɛn nɑ, bɛɛn yɛnusu kpuro sɔɔ, i ku rɑ ɡɑ̃ɑnu di ni bɑ seeyɑtiɑ doke. ");
INSERT INTO bba_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Yen biru Mɔwisi u Isirelibɑn ɡuro ɡurobu sokusiɑ u nɛɛ, i yɑ̃ɑ kinɛ kpɛnnu ɡɔsio nɡe mɛ bɛɛn yɛnusu nɛ, kpɑ i nu ɡo ɡɔɔ u kɑ bɛɛ sɑrɑri. ");
INSERT INTO bba_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Kpɑ bɛɛn bɑɑwure u dɑ̃ɑ kiku ɡe bɑ mɔ̀ isɔpu suɑ u wɑsi yɑ̃ɑ yɛm sɔɔ mɛ mu ko n wɑ̃ɑ ɡbɛ̃ɛrɔ, kpɑ u tɛɛni win dii kɔnnɔn beri berikɑɔ kɑ ɡen wɔllɔ. Bɛɛn ɡoo u ku rɑɑ yɑri dirun di mɑ n kun mɔ yɑm sɑ̃rɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Sɑnɑm mɛ Yinni Gusunɔ u koo tem mɛ bukiɑnɑ u kɑ Eɡibitiɡibu ɡo, u koo yɛm mɛ wɑ bɛɛn dii kɔnnɔsun beri berikɑɔ kɑ sin wɔllɔ, kpɑ u bɛɛn diɑ sɑrɑri. U ǹ wurɑmɔ ɡɔɔn ɡɔrɑdo u du u bɛɛ ɡo. ");
INSERT INTO bba_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Bɛɛ kɑ bɛɛn bibun bweseru, mɛyɑ i ko i n dɑ tɔ̃ɔ bɑkɑ te di sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Sɑnɑm mɛ i tem mɛ duɑ, mɛ Yinni Gusunɔ u koo bɛɛ wɛ̃ nɡe mɛ u nɔɔ mwɛɛru kuɑ, i de tɔ̃ɔ bɑkɑ te, tu ko bɛɛn wororu. ");
INSERT INTO bba_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Bɛɛn bibu bɑ̀ n bɛɛ woro ten tubusiɑnu bikiɑ, ");
INSERT INTO bba_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","i ko bu wisi i nɛɛ, Gɔɔ sɑrɑribun yɑ̃kurɑ te sɑ kɑ Yinni Gusunɔ sɑ̃ɑmɔ, domi u bɛsɛ Isirelibɑn diɑ sɑrɑri, u ǹ sun ɡo sɑnɑm mɛ u Eɡibitiɡibu ɡoomɔ. Yen biru Isirelibɑ bɑ yiirɑ bɑ Gusunɔ sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Mɑ bɑ dɑ bɑ kuɑ dee dee ye Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ye n kuɑ wɔ̃kurun bɔnu, Yinni Gusunɔ u bii ɡbiikobu kpuro ɡo Eɡibitin temɔ, sɑɑ Eɡibiti sunɔn tiin bii ɡbiikoon di wi u koo win sinɑ ɡɔnɑ tubi di, sere kɑ be bɑ wɑ̃ɑ pirisɔm sɔɔn bii ɡbiikobu, n kɑ dɑ yɑɑ sɑbenun bii ɡbiikinɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Eɡibiti sunɔ kɑ win bwɑ̃ɑbu kɑ tɔn be bɑ tie Eɡibiti ye sɔɔ kpuro, bɑ seewɑ wɔ̃kuru bɑ wuri bɛkɛ kuɑ domi yɛnu ɡɑɡu sɑri ɡèn mi tɔn tiɑ tiɑ kun ɡu. ");
INSERT INTO bba_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Wɔ̃ku tee te sɔɔ, Eɡibiti sunɔ u Mɔwisi kɑ Aroni sokɑ, u nɛɛ, i seewo i doonɑ nɛn tɔmbun min di, bɛɛ kɑ bɛɛn tɔmbu Isirelibɑ. I doo i Yinni Gusunɔ sɑ̃ nɡe mɛ i ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","I kɑ bɛɛn yɑ̃ɑnu kɑ bɛɛn kɛtɛbɑ doo nɡe mɛ i ɡeruɑ, kpɑ i mɑɑ mɑn domɑru kɑnɑ bɛɛn Yinnin mi. ");
INSERT INTO bba_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Mɑ Eɡibitiɡibɑ Isirelibɑ bɑɑsi bu kɑ yɑri ben tem di fuuku, bɑ nɛɛ, domi sɑ ko ɡbi su kpe. ");
INSERT INTO bba_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Mɑ Isireli be, bɑ ben pɛ̃ɛ kpii te tɑ ǹ seeyɑtiɑ mɔ suɑ ɡbɛ̃ɑ sɔɔ bɑ tu bekɑ wukiri bɑ sɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","N deemɑ Isirelibɑ bɑ rɑɑ kuɑ nɡe mɛ Mɔwisi u ɡeruɑ, bɑ Eɡibitiɡibu burɑ yɑ̃ɑ ni bɑ kuɑ kɑ wurɑ kɑ sii ɡeesu kɑnɑ, kɑ mɑɑ bekɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Yinni Gusunɔ u mɑɑ derɑ tɔn be, bɑ kĩi ɡeeru wɑ Eɡibitiɡii ben mi. Mɑ bɑ bu wɛ̃ ye bɑ bikiɑ kpuro. Nɡe mɛyɑ bɑ kɑ Eɡibitiɡibun yɑ̃nu wɑ bɑ ɡurɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Isirelibɑ bɑ swɑɑ wɔri kɑ nɑɑsu sɑɑ Rɑmusɛsin di bɑ dɔɔ Sukɔtuɔ. Ben ɡeerɑ sɑ̃ɑ nɔrɔbun subɑ nɑtɑn sɑkɑ (600.000), tɔn kurɔbu kɑ bibu kɑ durɔ tɔkɔnu bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Mɑ bɑ kɑ ben yɑɑ sɑbenu dɑ dɑbi dɑbinu, kɛtɛbɑ kɑ yɑ̃ɑnu kɑ bonu. Tɔn tuko dɑbirɑ mɑɑ bu swĩi. ");
INSERT INTO bba_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Bɑ pɛ̃ɛ kuɑ kɑ pɛ̃ɛ kpii te bɑ ǹ seeyɑtiɑ doke, domi bɑ bu ɡirɑwɑ Eɡibitin di bɑ yɑrɑ kɑ sɛndɑru. Bɑ ǹ mɑɑ fɛɛ wɑ bu dĩɑ kusenu suɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","41","Gusunɔn tɔmbu Isirelibɑ bɑ kuɑwɑ Eɡibitiɔ wɔ̃ɔ nɛɛru kɑ tɛnɑ (430). Dɔmɑ te wɔ̃ɔ nɛɛru kɑ tɛnɑ ye, yɑ yibɑ, yerɑ be kpuro bɑ yɑrɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Wɔ̃ku te sɔɔ, Yinni Gusunɔ u Isirelibɑ kɔ̃su bɑ kɑ yɑrɑ Eɡibitin di. Yen sɔ̃nɑ wɔ̃ɔ kɑ wɔ̃ɔ Isirelibɑ bɑ ko n dɑ dom se wɔ̃ku te. Kpɑ bu Yinni Gusunɔ tɔ̃ɔ bɑkɑru diiyɑ, be kɑ ben bibun bweseru sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, woodɑ ye nɑ bɛɛ wɛ̃ɛmɔ Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑrun sɔ̃ wee. Sɔɔ ɡoo u ku rɑɑ ten yɑɑ dibu di. ");
INSERT INTO bba_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Adɑmɑ yoo tɔn tuko be i dwɑ kɑ ɡobi, mɑ i bu bɑnɡo kuɑ, bɑ koo kpĩ bu di. ");
INSERT INTO bba_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Sɔɔ wi u sɑrɔ, ǹ kun mɛ tɔn tuko ɡoo wi u sɔmburu mɔ̀ bɛɛn mi, u kɑ ɡobi wɑ, be yiru yen ɡoo kun yɑɑ dii bi dimɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","Dirɔwɑ i ko tɔ̃ɔ bɑkɑ ten yɑɑ dibu di. I ku rɑ kɑ yen yɑɑ yɑri tɔɔwɔ. Bɑɑ yen yɑɑ kuku teeru i ku rɑ kɔrɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Isirelibɑ kpurowɑ bɑ koo tɔ̃ɔ bɑkɑ te di. ");
INSERT INTO bba_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Sɔɔ ɡoo ù n tem yɑrimɑ u wɑ̃ɑ bɛɛn mi, ù n kĩ u tɔ̃ɔ bɑkɑ ten yɑɑ dibu di, i nùn bɑnɡo koowo kɑ win yɛnun tɔn durɔbu kpuro i sere yɑɑ dii bi di kɑ wi sɑnnu. Domi u ǹ ko n mɑɑ sɑ̃ɑ nɡe sɔɔ. Adɑmɑ bɑnɡo sɑriruɡii ɡoo kun bu dimɔ. ");
INSERT INTO bba_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Woodɑ tiɑ ye, yɑ kɑ bɛɛ kpuro yɑ̃, bɛɛ Isirelibɑ kɑ sere sɔɔ be bɑ wɑ̃ɑ bɛɛn mi. ");
INSERT INTO bba_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Mɑ Isirelibɑ bɑ kuɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Yen tɔ̃ɔ terɑ u mɑɑ Isirelibɑ yɑrɑ Eɡibitin di bwese kɛrɑ kɑ bwese kɛrɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","ɑ de Isirelibɑ bu ben bii tɔn durɔ ɡbiikobu kɑ ben yɑɑ sɑbenun bii ɡbiikii dwɑnu wunɑ nɛnɛm kpɑ ye kpuro yɑ n sɑ̃ɑ nɛɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Mɔwisi u Isirelibɑ sɔ̃ɔwɑ u nɛɛ, i n dɑ tɔ̃ɔ te yɑɑye tè sɔɔ Gusunɔ u bɛɛ yɑrɑmɑ kɑ win dɑm bɑkɑm sɑɑ Eɡibitin di, mi i yoru di. Yen sɔ̃, ì n tɔ̃ɔ ten yɑɑ dibu dimɔ, i ku rɑ pɛ̃ɛ ye bɑ seeyɑtiɑ doke di. ");
INSERT INTO bba_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Suru wì sɔɔ bɑ rɑ ɡɛ̃ɛbu tore, wi bɑ mɔ̀ Abibu, win tɔ̃ɔ ɡbiikiru sɔɔrɑ i yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yinni Gusunɔ u bɛɛn bɑɑbɑbɑ nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri sɑnnu u nɛɛ, u koo bu tem ɡem wɛ̃ mi tim kɑ bom yibɑ. Tem miyɑ Kɑnɑnibɑ kɑ Hɛtibɑ kɑ Amɔrebɑ kɑ Hefibɑ kɑ Yebusibɑ bɑ wɑ̃ɑ. Ù n kɑ bɛɛ turɑ tem mi, i n dɑ tɔ̃ɔ bɑkɑ teni di i kɑ nùn sɑ̃ suru win tɔ̃ɔ ɡbiikiru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Sɔ̃ɔ nɔɔbɑ yirun bɑɑ sɔɔrɑ i ko pɛ̃ɛ di ye bɑ ǹ seeyɑtiɑ doke. Yen nɔɔbɑ yirusen tii sɔɔrɑ i ko Yinni Gusunɔ tɔ̃ɔ bɑkɑru diiyɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Sɔ̃ɔ nɔɔbɑ yiru ye sɔɔ, i ku mɑɑ de pɛ̃ɛ ye yɑ seeyɑtiɑ mɔ ǹ kun mɛ seeyɑtiɑ ɡɑɑ yɑ n wɑ̃ɑ bɛɛn suunu sɔɔ tem mɛ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Dɔmɑ te i tɔ̃ɔ bɑkɑ te mɔ̀, i bɛɛn bibu sɔ̃ɔwɔ i nɛɛ, sɑ yeni mɔ̀wɑ su kɑ yɑɑyɑ ye Yinni Gusunɔ u sun kuɑ sɑnɑm mɛ sɑ yɑrɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Yeni yɑ ko n sɑ̃ɑwɑ nɡe yĩre te bɑ yoruɑ nɔmɑɔ, ǹ kun mɛ sirikɑnɑɔ, kpɑ i n Yinni Gusunɔn woodɑbɑ yɑɑyɑmɔ bɛɛn fɑɑɡi sɔɔ. Domi wiyɑ u bɛɛ yɑrɑmɑ kɑ win dɑm bɑkɑm Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Yen sɔ̃nɑ n weenɛ i tɔ̃ɔ bɑkɑ ten woodɑ yibiɑ wɔ̃ɔ bɑɑɡere, ten sɑɑ yɑ̀ n turɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","Sɑɑ ye Yinni Gusunɔ u derɑ bɛɛ Isirelibɑ i duɑ Kɑnɑnin temɔ, mɛ u bɛɛ kɑ bɛɛn bɑɑbɑbɑ nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri mɑ u bɛɛ mu wɛ̃, ");
INSERT INTO bba_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","i ko nùn bɛɛn bii tɔn durɔ ɡbiikobu kɑ bɛɛn yɑɑ sɑbenun bii ɡbiikii dwɑnu yiiyɑwɑ nɛnɛm n sɑ̃ɑ wiɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Adɑmɑ bɛɛn ɡoo ù n kĩ u win kɛtɛku buu ɡbiikuu nɛnɛ, u koo ɡu yɑkiɑwɑ kɑ yɑ̃ɑ buu. Ù kun mɑɑ kue mɛ, u koo ɡen wĩi sumɑ buɑwɑ u ɡo. I ko mɑɑ bɛɛn bii tɔn durɔ ɡbiikoo bɑɑwure yɑkiɑwɑ kɑ ɡobi. ");
INSERT INTO bba_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","Bɑɑ siɑ bɛɛn bibu bɑ̀ n dɑ bɛɛ bikiɑ bɑ nɛɛ, mbɑ yenin tubusiɑnu, kpɑ i bu wisi i nɛɛ, tɔ̃ɔ te Yinni Gusunɔ u sun yɑrɑmɑ kɑ win dɑm bɑkɑm Eɡibitin di, mi sɑ rɑɑ yoru di, terɑ sɑ yɑɑyɑmɔ mi. ");
INSERT INTO bba_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Domi sɑɑ ye Eɡibiti sunɔ u yinɑ mɑm mɑm su yɑri tem min di, yerɑ Yinni Gusunɔ u derɑ tem min bii tɔn durɔ ɡbiikobɑ ɡu ɡu kɑ mɑɑ yɑɑ sɑbenun bii ɡbiikii dwɑnu. Yen sɔ̃nɑ sɑ rɑ kɑ bɛsɛn yɑɑ sɑbenun bii ɡbiikii dwɑnu Yinni Gusunɔ yɑ̃kuru kue, kpɑ su bɛsɛn bii tɔn durɔ ɡbiikobu yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Yeni yɑ ko n sɑ̃ɑwɑ nɡe yĩre te bɑ yoruɑ nɔmɑɔ kɑ sirikɑnɑɔ kpɑ tɑ n sun yɑɑyɑsie mɑ dɑm bɑkɑmɑ Yinni Gusunɔ u kɑ sun yɑrɑ sɑɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Sɑnɑm mɛ Eɡibiti sunɔ u derɑ Isirelibɑ bɑ doonɑ, Yinni Gusunɔ u ǹ wure bu kpe kɑ swɑɑ ye yɑ dɔɔ Filisitibɑn temɔ, bɑɑ mɛ yɑ turuku bo. Domi u nɛɛ, u ǹ kĩ bu ɡɔ̃ru ɡɔsiɑ bu wurɑ Eɡibitiɔ sɑnɑm mɛ bɑ bu tɑbu wɔri. ");
INSERT INTO bba_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Yen sɔ̃nɑ u kɑ bu ɡbɑburun swɑɑ bɛɛri nim wɔ̃kun berɑ ɡiɑ, ɡe bɑ mɔ̀ Nɑɑ yɑri. Tɔn be, bɑ yɑrɑwɑ Eɡibitin di kɑ tɑbun sɔɔru. ");
INSERT INTO bba_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Mɑ Mɔwisi u Yosɛfun ɡoru suɑ bɑ kɑ dɑ, nɡe mɛ Yosɛfu u rɑɑ Isirelibɑ bɔ̃rusiɑ bu ko. U nɛɛ, bu de bu kɑ win ɡoru yɑri sɑnɑm mɛ Yinni Gusunɔ u koo bu yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isirelibɑ bɑ doonɑ Sukɔtun di bɑ dɑ bɑ ben sɑnsɑni kuɑ Etɑmuɔ ɡbɑbu dirirun nɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Yinni Gusunɔ u bu swɑɑ ɡbiiye ɡuru wii wuroru sɔɔ sɔ̃ɔ sɔɔ kɑ wɔ̃kuru. Wɔ̃kuru kpɑ tɑ n sɑ̃ɑ nɡe dɔ̃ɔ yɑri bɑkɑru tɑ n kɑ bu yɑm bururɑsie. ");
INSERT INTO bba_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Sɔ̃ɔ sɔɔ kɑ wɔ̃kuru ɡuru wii wuro te, tɑ ku rɑ biɑre tɔn ben wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Yen biru Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ bu wuro Pihɑ Hirotun berɑ ɡiɑ bu ben sɑnsɑni ɡirɑ Miɡidoli kɑ nim wɔ̃kun bɑɑ sɔɔ, Bɑɑli Sefonin deedeeru. Miyɑ i ko ɡinɑ yɔ̃rɑ nim wɔ̃kun bɔkuɔ, ");
INSERT INTO bba_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","kpɑ Eɡibiti sunɔ u n tɑmɑɑ bɛɛ Isirelibɑ i kɔ̃ɔrɑwɑ tem mɛ sɔɔ, mi ɡbɑburu tɑ bɛɛ sikerenɛ, ");
INSERT INTO bba_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","kpɑ n win ɡɔ̃ru bɔbiɑsiɑ u bɛɛ nɑɑ swĩi. Adɑmɑ kon wi kɑ win tɑbu kowobu dendi n kɑ nɛn yiiko sɔ̃ɔsi kpɑ Eɡibitiɡibu bu kɑ ɡiɑ mɑ nɛnɑ Yinni Gusunɔ. Mɑ Isirelibɑ bɑ kuɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Sɑnɑm mɛ bɑ Eɡibiti sunɔ sɔ̃ɔwɑ mɑ tɔn be, bɑ yɑkurɑwɑ, yerɑ wi kɑ win bwɑ̃ɑbu bɑ ben himbɑ ɡɔsiɑ. Bɑ nɛɛ, mbɑn bweserɑ sɑ kuɑ mini. Domi sɑ derɑ Isirelibɑ bɑ bɛsɛn yoru yɑrɑ bɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Mɑ Eɡibiti sunɔ u win tɑbu kɛkɛ sɔɔru kuɑ kɑ win tɑbu kowobu sɑnnu. ");
INSERT INTO bba_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","U tɑbu kɛkɛ nɑtɑ (600) suɑ yi yi ɡiɑ sɑ̃ɑ kɑ sere Eɡibitin tɑbu kɛkɛbɑ kpuro, yen bɑɑyere kɑ yen tɑbu kowo dɑmɡii. ");
INSERT INTO bba_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Sɑɑ yerɑ Yinni Gusunɔ u sunɔ win ɡɔ̃ru bɔbiɑsiɑ, mɑ u Isirelibɑ nɑɑ ɡirɑ bɑɑ mɛ u yɛ̃ mɑ Yinni Gusunɔwɑ u bu yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Eɡibitiɡibun tɑbu kowobu kɑ ben mɑɑsɔbu kɑ dumi, kɑ tɑbu kɛkɛbɑ bɑ bu nɑɑ ɡirɑ mɑ bɑ bu nɑɑmwɛ mi bɑ yɔ̃rɑ nim wɔ̃kun bɔkuɔ bɑ ben sɑnsɑni ɡirɑ Pihɑ Hirotun berɑ ɡiɑ Bɑɑli Sefonin deedeeru. ");
INSERT INTO bba_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Sɑnɑm mɛ Eɡibiti sunɔ u turuku kuɑ, Isirelibɑ bɑ nɔni seeyɑ bɑ wɑ wee, Eɡibitiɡibɑ kɛkuɑ bɑ wee. Mɑ bɛrum bu mwɑ ɡem ɡem, mɑ bɑ Yinni Gusunɔ nɔɔɡiru sue. ");
INSERT INTO bba_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Bɑ Mɔwisi sɔ̃ɔwɑ bɑ nɛɛ, siku yeru sɑriwɑ Eɡibitiɔ? Yen sɔ̃nɑ ɑ kɑ sun nɑ su ɡbi ɡbɑburu mini? A wɑ ye ɑ kɑ sun deemɑ ye ɑ sun yɑrɑmɑ Eɡibitin di? ");
INSERT INTO bba_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Sɑ ǹ dɑɑ nun sɔ̃ɔwɑ mɛ Eɡibitiɔ sɑ nɛɛ, ɑ sun derio su Eɡibitiɡibu yoru diiyɑ? Domi sɑ kĩru bo su bu yoru diiyɑ kɑ sere ye sɑ ko ɡbi ɡbɑburu mini. ");
INSERT INTO bba_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Yerɑ Mɔwisi u tɔn be wisɑ u nɛɛ, i ku bɛrum ko, i yɔ̃ro sɛ̃ɛ, kpɑ i wɑ nɡe mɛ Yinni Gusunɔ u koo bɛɛ fɑɑbɑ ko ɡisɔ. Domi Eɡibitiɡii be i wɑɑmɔ mini, i ǹ mɑɑ bu wɑsi sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","I yɔ̃ro sɛ̃ɛ, Yinni Gusunɔwɑ u koo bɛɛ sɑnnɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Mɑ Yinni Gusunɔ u Mɔwisi bikiɑ u nɛɛ, mbɑn sɔ̃nɑ i mɑn nɔɔɡiru mɔ̀. A Isirelibɑ sɔ̃ɔwɔ bu seewo bu dɑ wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Wunɛ mɑɑ, ɑ wunɛn dɛkɑ suo ɑ tĩi nim wɔ̃ku wɔllɔ kpɑ ɡu bɔnu ko yiru Isirelibɑ bu kɑ du bu tɔburɑ ɡe sɔɔ, ɡɑ n tem ɡbere. ");
INSERT INTO bba_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Nɛnɑ kon Eɡibitiɡibun ɡɔ̃rusu bɔbiɑsiɑ bu kɑ bu swĩi mi. Kpɑ n ben sunɔ kɑmiɑ kɑ win tɑbu kowobu kɑ win tɑbu kɛkɛbɑ kɑ win mɑɑsɔbu, kpɑ bu nɛn yiiko wɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Sɑɑ ye sɔɔrɑ bɑ koo ɡiɑ mɑ nɛnɑ nɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Sɑnɑm mɛ sɔɔ, Gusunɔn ɡɔrɑdo wi u Isirelibɑ ɡbiiye u ɡɔsirɑ ben biru ɡiɑ mɑ ɡuru wii wuro te, te tɑ rɑɑ bu ɡbiiye, tɑ mɑɑ wurɑmɑ biruɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Mɑ tɑ dɑ Eɡibitiɡibu kɑ Isirelibɑn sɑnsɑni yiru yen bɑɑ sɔɔ. Tɑ yɑm tĩri Eɡibitiɡibun berɑ ɡiɑ mɑ tɑ yɑm buriri Isirelibɑn mi ɡiɑ. Mɑ Isirelibɑ kɑ Eɡibitiɡibu bɑ ǹ susinɛ wɔ̃ku te kpuro. ");
INSERT INTO bba_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Ye bɑ turɑ nim wɔ̃ku ɡen mi, yerɑ Mɔwisi u win dɛkɑ tĩi ɡen wɔllɔ mɑ Yinni Gusunɔ u woo dɑmɡuu seeyɑ sɔ̃ɔ yɑri yerun di wɔ̃ku ɡiriru sɔɔ, ɡɑ derɑ nim wɔ̃ku ɡen nim mu bɔnu kuɑ yiru, mɑ ɡen suunu sɔɔ mi, n ɡberɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Nim mu kpɑɑsinɛ berɑ kɑ berɑ ben nɔm ɡeuɔ kɑ nɔm dwɑrɔ. Mɑ Isirelibɑ bɑ sĩɑ tem ɡbebum sɔɔ, bɑ tɔburɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Eɡibitiɡibu bɑ bu nɑɑ swĩi bɑ duɑ nim wɔ̃ku ɡen suunu sɔɔ, kɑ ben sunɔn dumi kɑ win tɑbu kɛkɛbɑ kɑ win mɑɑsɔbu. ");
INSERT INTO bba_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ye n kuɑ buru buru yellu, mɑ Yinni Gusunɔ u bu mɛɛrimɑ sɑɑ ɡuru wii wuro ten min di, mɑ u bu nɑndɑsiɑ. Be kpuro bɑ yɔ̃sunɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","U derɑ ben kɛkɛbɑn nɑɑsu wɔɔrɑmɔ, bɑ kpɑnɑ bu sĩ fuuku. Mɑ bɑ nɛɛ, su duki ɡɔsirɑ Isirelibɑn min di, domi Yinni Gusunɔ u kɑ sun sɑnnɑmɔwɑ ben sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Mɑ Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn dɛkɑ tĩiyɔ nim wɔ̃ku mi, kpɑ nim mɛ, mu wurɑmɑ mu Eɡibitiɡibu kɑ ben tɑbu kɛkɛbɑ kɑ mɑɑsɔbu wukiri. ");
INSERT INTO bba_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Mɔwisi u win dɛkɑ ye tĩi nim wɔ̃ku ɡen mi. Ye n kuɑ yɑm sɑ̃reru, mɑ nim mɛ, mu wurɑmɑ nɡe mɛ mu rɑɑ sɑ̃ɑ. Eɡibitiɡibu bɑ kĩ bu nim mɛ suuri, ɑdɑmɑ Yinni Gusunɔ u bu sure mɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Nim mɛ, mu wurɑmɑ mu Eɡibiti sunɔn tɑbu kɛkɛbɑ kɑ win mɑɑsɔbu kɑ tɑbu kowobu kpuro wukiri be bɑ Isirelibɑ nɑɑmwɛm dɑ nim wɔ̃ku ɡen suunu sɔɔ. Bɑɑ ben turo, u ǹ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Adɑmɑ Isirelibɑ bɑ sĩɑ tem ɡbebum sɔɔ nim wɔ̃ku ɡen suunuɔ. Domi nim mu kpɑɑsinɛwɑ berɑ kɑ berɑ ben nɔm ɡeuɔ kɑ nɔn dwɑrɔ. ");
INSERT INTO bba_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","31","Ye Isirelibɑ bɑ sɔm dɑmɡiru wɑ te Yinni Gusunɔ u Eɡibitiɡibu koosi mɑ bɑ ben ɡonu wɑ nim wɔ̃kun ɡoorɔ, yerɑ bɑ ɡiɑ mɑ Yinni Gusunɔwɑ u bu fɑɑbɑ kuɑ dɔmɑ te, sɑɑ Eɡibitiɡibun nɔmɑn di. Mɑ bɑ nùn nɑsiɑ bɑ sosi, bɑ nùn nɑɑnɛ kuɑ kɑ mɑɑ win ɡɔro Mɔwisi. ");
INSERT INTO bba_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Sɑɑ yerɑ Mɔwisi kɑ Isirelibɑ bɑ Yinni Gusunɔ siɑrɑbun womu kuɑ. Bɑ nɛɛ, kon Yinni Gusunɔ tɔmɑ kɑ womu domi u win wɛrɔbu tɑbu di. U dumi kɑ yin mɑɑsɔbu sure nim wɔ̃ku sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Yinni Gusunɔwɑ nɛn dɑm, wiyɑ nɑ siɑrɑmɔ kɑ nɛn womu. Wiyɑ u mɑn fɑɑbɑ kuɑ. Wiyɑ nɛn Yinni, kon nùn bɛɛrɛ wɛ̃. Wiyɑ nɛn bɑɑbɑn Yinni, kon nùn wɔlle suɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","U sɑ̃ɑwɑ tɑbu kowo kɑ ɡem. Win yĩsirɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","U Eɡibiti sunɔn tɑbu kɛkɛbɑ kɑ win tɑbu kowo dɑmɡibu sure nim wɔ̃ku sɔɔ ɡe bɑ mɔ̀ Nɑɑ yɑri. Win tɑbu kowo ɡisonkobɑ bɑ nim diirɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Nim mɛ, mu bu wukiri, mɑ bɑ numɑ temɔ nɡe kperu. ");
INSERT INTO bba_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yinni Gusunɔ, wunɛn nɔm ɡeu ɡɑ dɑm yiikoɡim mɔ. Geyɑ ɡɑ wunɛn wɛrɔbu munkɑ muku muku. ");
INSERT INTO bba_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Wunɛn sinɑndun kpɑ̃ɑru tɑ rɑ wunɛn wɛrɔbu tɑɑre. Wunɛn mɔru yɑ̀ n seewɑ, ɑ rɑ de bu dɔ̃ɔ mwɑɑrewɑ nɡe wĩi. ");
INSERT INTO bba_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","A wɛ̃ru wurɑ mɑ nim mu kpɑɑsinɑ mu sinum kuɑ berɑ kɑ berɑ nɡe ɡbɑ̃rɑru. ");
INSERT INTO bba_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Wɛrɔ u nɛɛ, u koo bu nɑɑ swĩi kpɑ u bu nɑɑmwɛ. U koo mɔru kɔsiɑ be sɔɔ nɡe mɛ u kĩ, kpɑ u tɑkobi womɑ u bu ɡo kɑ win nɔmɑ, kpɑ u ben dukiɑ bɔnu ko. ");
INSERT INTO bba_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Adɑmɑ ɑ wunɛn wom wɛ̃siɑ, mɑ nim mu bu wukiri. Bɑ numɑ bɑ kpunɑ nɡe dɔ̃ɔ kpenu mi nim mu duku. ");
INSERT INTO bba_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yinni Gusunɔ, mbɑ n kɑ nun weenɛ ye tɔmbɑ sɑ̃ɑmɔ kpuro sɔɔ. Mbɑ n kɑ nun dɛɛrɑru nɛ, wunɛ wi ɑ nɑnum mɔ. Mbɑ n kɑ nun weenɛ, wunɛ wi bɑ koo siɑrɑ. Mbɑ n kɑ nun weenɛ, wunɛ wi ɑ rɑ sɔm mɑɑmɑɑkiɡinu ko. ");
INSERT INTO bba_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Domi ɑ wunɛn dɑm sɔ̃ɔsi, mɑ tem bu mwɛ. ");
INSERT INTO bba_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Wunɛn wɔnwɔndu sɔɔrɑ ɑ wunɛn tɔmbu swɑɑ sɔ̃ɔsi be ɑ yɑkiɑ. A mɑɑ bu kpɑrɑmɑ kɑ wunɛn dɑm ɑ kɑ dɔɔ sere wɑ̃ɑ yee te ɑ bu nɔɔ mwɛɛru kuɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Tɔn tukobu bɑ ye nuɑ, mɑ bɑ diirumɔ. Filisitibɑ bɑ bɛrum soorɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Edɔmun sinɑmbun toronu kɑrɑ. Mɑ Mɔɑbun tɑbu durɔbu bɑ diirumɔ. Kɑnɑnibɑ kpuro, ben wɑsi dwiiyɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Bɛrum kɑ nɑndɑbu koo bu deemɑ subɑru sɔɔ. Wunɛn dɑm sɑɑbu bɑ koo mɑri sɔ̃ɔ sɔ̃ɔ nɡe kperu. Sere wunɛn tɔn be ɑ yɑkiɑ yorun di bu kɑ nim wɔ̃ku tɔburɑ, Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Kɑɑ kɑ bu dɑ kpɑ ɑ bu tɑ̃sisiɑ wunɛn tiin ɡuuru wɔllɔ, mi ɑ wunɛn wɑ̃ɑ yeru sɔɔru kuɑ. Terɑ tɑ sɑ̃ɑ wunɛn sɑ̃ɑ yeru te ɑ tii kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Wunɛ Yinni Gusunɔ, kɑɑ n bɑndu diiwɑ kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Sɑnɑm mɛ Eɡibiti sunɔn dumi kɑ win tɑbu kɛkɛbɑ kɑ mɑɑsɔbu bɑ duɑ nim wɔ̃ku sɔɔ, Yinni Gusunɔ u derɑ nim mu wurɑmɑ mu bu wukiri. Adɑmɑ u derɑ tem mu ɡberɑ nim wɔ̃ku ɡen suunu sɔɔ, mɑ Isirelibɑ bɑ tɔburɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Yen biruwɑ Aronin sesu Mɑriɑmu wi u sɑ̃ɑ Gusunɔn sɔmɔ, u bɑrɑ kpɑ̃ru suɑ mɑ tɔn kurɔbu kpuro bɑ nùn swĩi bɑ bɑrɑ kpɑ̃nu soomɔ bɑ yɑɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Mɑriɑmu u bu womu ɡeni kuɑ u nɛɛ, i Yinni Gusunɔ tɔmɔ kɑ womu, domi u nɑsɑrɑ wɑ kɑ win yiiko. Dumi kɑ yin mɑɑsɔbu u sure nim wɔ̃ku sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Yen biru Mɔwisi u Isirelibɑ kpɑrɑ sɑɑ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑrin di bɑ dɑ ɡbɑburɔ te bɑ mɔ̀ Suri. Sɔ̃ɔ itɑwɑ bɑ sĩɑ ɡbɑbu te sɔɔ bɑ ǹ nim wɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Mɑ bɑ turɑ Mɑrɑɔ ɑdɑmɑ nim mɛ bɑ wɑ mi, mu sosu, bɑ ǹ kpĩɑ bu nɔ. Yen sɔ̃nɑ bɑ yɑm mi sokɑ Mɑrɑ. Yen tubusiɑnɑ sosurɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Mɑ tɔn be, bɑ Mɔwisi wɔkisi bɑ nɛɛ, mbɑ sɑ ko nɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Mɔwisi u Yinni Gusunɔ nɔɔɡiru sue. Mɑ Yinni Gusunɔ u nùn dɛkɑ ɡɑɑ sɔ̃ɔsi. Ye u dɛkɑ ye suɑ u kɑre nim mɛ sɔɔ, mɑ mu dorɑ. Miyɑ Yinni Gusunɔ u win tɔmbu woodɑbɑ wɛ̃ kɑ woronu. Miyɑ u mɑɑ ben lɑɑkɑri mɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","U nɛɛ, ì n nɛ Gusunɔ bɛɛn Yinnin ɡere nuɑ sɑ̃ɑ sɑ̃ɑ, mɑ i mɔ̀ ye n mɑn wɛ̃re mɑ i nɛn woodɑbɑ mɛm nɔɔwɑ, nɑ ǹ kɑ bɛɛ bɑrɑ ni sɛɛyɑsiɑmɔ ni nɑ Eɡibitiɡibu kpɛ̃ɛ. Nɛnɑ Yinni Gusunɔ nɛ wi nɑ rɑ n bɛɛ bɛkiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Yen biru bɑ turɑ Elimuɔ mi nim bwii wɔkurɑ yiru yɑ wɑ̃ɑ kɑ kpɑkpɑ bɛ̃ɛ wɑtɑ kɑ wɔkuru. Mɑ bɑ ben sɑnsɑni ɡirɑ bwii yin bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Mɑ Isirelibɑn wuu te kpuro tɑ seewɑ Elimun di tɑ dɑ ɡbɑburɔ te bɑ mɔ̀ Sini te tɑ wɑ̃ɑ Elimu kɑ Sinɑin bɑɑ sɔɔ. Sɑɑ dɔmɑ tèn di bɑ doonɑ Eɡibitin di, bɑ kuɑwɑ suru tiɑ kɑ sɔ̃ɔ wɔkurɑ nɔɔbu bɑ sere turɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Mɑ be kpuro bɑ Mɔwisi kɑ Aroni wɔkisim wɔri ɡbɑburu mi. ");
INSERT INTO bba_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Bɑ nɛɛ, n dɑɑ sɑnɔ bo Yinni Gusunɔ u sun ɡo Eɡibitiɔ mi sɑ rɑ rɑɑ sinɛ su dĩɑnu di ni sɑ kĩ kɑ yɑɑ. Adɑmɑ wee, i kɑ sun nɑ ɡbɑbu teni sɔɔ ɡɔ̃ɔru tu kɑ sun ɡo bɛsɛ kpuro. ");
INSERT INTO bba_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Yen biru Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, tɛ̃ kon de dĩɑnu nu nɛɛrɑ wɔllun di nɡe ɡurɑ bɛɛ kpuron sɔ̃, kpɑ tɔmbu bɑ n dɑ yɑri bu ɡure bɑɑdommɑ mɛ̀n bukɑtɑ bɑ mɔ tɔ̃ɔ te. Nɡe mɛyɑ kon kɑ ben lɑɑkɑri mɛɛri n wɑ bɑ̀ n koo nɛn woodɑbɑ mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Sɔ̃ɔ nɔɔbɑ tiɑse, mɛ bɑ rɑ ɡuren nɔn yiruwɑ bɑ koo ɡurɑ kpɑ bu yen sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Mɑ Mɔwisi kɑ Aroni bɑ Isirelibɑ kpuro sɔ̃ɔwɑ bɑ nɛɛ, yokɑ ye, i ko ɡiɑ mɑ Yinni Gusunɔwɑ u bɛɛ yɑrɑmɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","Domi u koo bɛɛ yɑɑ wɛ̃ i tem yèn sɔ̃ u nuɑ i nùn wɔkisimɔ. I n yɛ̃ mɑ wiyɑ i wɔkisimɔ, n ǹ mɔ bɛsɛ. Siɑ bururu u koo mɑɑ bɛɛ dĩɑnu wɛ̃ i di i debu, kpɑ i win yiiko wɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Mɑ Mɔwisi u Aroni sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑn wuuru kpuro sɔ̃ɔwɔ ɑ nɛɛ, bu susimɑ Yinni Gusunɔ mi, yèn sɔ̃ u ben wɔkinu nuɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Sɑɑ ye Aroni u kɑ Isirelibɑn wuu te ɡɑri mɔ̀, bɑ sĩirɑ ɡbɑburu ɡiɑ bɑ wɑ wee, Yinni Gusunɔn yiikon ɡirimɑ sɔ̃ɔsirɑ ɡuru wii wuro te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","nɑ Isirelibɑn weeweenu nuɑ. A bu sɔ̃ɔwɔ mɑ yoki yɑm bere berebu bɑ koo yɑɑ tem kpɑ siɑ bururu bu dĩɑnu di bu debu kpɑ bu ɡiɑ mɑ nɛnɑ nɑ Gusunɔ ben Yinni. ");
INSERT INTO bba_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Ye n kuɑ yokɑ yerɑ kusu wuu bɑkɑrɑ nɑ tɑ tɛriɑ sɑnsɑni ye kpuro sɔɔ. Sisiru bururu mɑ tem kpuro mu kɑkoru sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Sɑɑ ye kɑko te, tɑ ɡberɑ ɡɑ̃ɑ piiminu tɛrie temɔ nɡe dĩɑ bimi. N sɑ̃ɑ nɡe ɡuru kpenu nu tem wukiri. ");
INSERT INTO bba_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Ye Isirelibɑ bɑ ye wɑ, bɑ sɔ̃ɔnɑ bɑ nɛɛ, mbɑ yeni. Domi bɑ ǹ ye yɛ̃. Mɔwisi u bu sɔ̃ɔwɑ u nɛɛ, yeniwɑ dĩɑ ni Yinni Gusunɔ u bɛɛ wɛ̃ɛmɑ i di. ");
INSERT INTO bba_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","U nɛɛ, yɛnu yɛ̃ro bɑɑwure u koo ɡurɑwɑ mɛ̀n nɔɔ win yɛnuɡibu bɑ koo di sɔ̃ɔ teeru nɡe mɛ ben ɡeerɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Mɑ Isirelibɑ bɑ kuɑ mɛ. Gɑbɑ ɡurɑ n kpɑ̃ n kere ɡɑbu. ");
INSERT INTO bba_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Yen biru bɑ ye yĩirɑ. Mɑ bɑ deemɑ wi u ɡurɑ n kpɑ̃ u ǹ sɑkɑ sɑre. Wi u mɑɑ ɡurɑ fiiko u ǹ sɑkɑ kɔmiɛ. Bɑɑwure u wɑ dee dee nɡe mɛ̀n nɔɔ u koo di. ");
INSERT INTO bba_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Mɔwisi u bu sɔ̃ɔwɑ u nɛɛ, bɛɛn ɡoo u ku de yu tiɑrɑ sere sisiru bururu. ");
INSERT INTO bba_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Adɑmɑ bɑ ǹ Mɔwisiɡiɑ nuɑ. Ben ɡɑbɑ derɑ yɑ tiɑrɑ sere sisiru bururu mɑ yɑ kɔ̃sɑ yɑ kɔkɔnu kuɑ. Yerɑ Mɔwisi u kɑ bu mɔru bɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Bururu bɑɑtere bɑ rɑ ɡurewɑ mɛ̀n nɔɔ bɑ koo di, ɑdɑmɑ sɔ̃ɔ ù n ye, yɑ rɑ yɑndewɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Alusumɑn sɔ̃ɔ nɔɔbɑ tiɑse, ben sɔ̃ɔ yirun dim sɑkɑwɑ bɑ ɡurɑ. Ben ɡuro ɡurobu kpuro bɑ nɑ bɑ Mɔwisi sɔ̃ɔwɑ bɑ nɛɛ, bɑ kuɑ mɛ. ");
INSERT INTO bba_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Mɑ u bu sɔ̃ɔwɑ u nɛɛ, Yinni Gusunɔ u ɡeruɑ u nɛɛ, siɑ tɔ̃ɔ wɛ̃rɑruɡirɑ te sɑ rɑ nùn derie, i sɔnwɔ ye i kĩ i sɔmɛ, kpɑ i yike ye i kĩ i yike. Kpɑ i sukum yi sere siɑ bururu. ");
INSERT INTO bba_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Bɑ ye yi sere sisiru bururu nɡe mɛ Mɔwisi u ɡeruɑ. Yɑ ǹ mɑɑ kɔ̃sɑ, yu sere kɔkɔnu ko. ");
INSERT INTO bba_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Mɔwisi u nɛɛ, i ye dio domi tɔ̃ɔ wɛ̃rɑruɡirɑ te i ko Yinni Gusunɔ deriɑ. Gisɔ i ǹ ye wɑsi temɔ. ");
INSERT INTO bba_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Sɔ̃ɔ nɔɔbɑ tiɑ i ko n dɑ ye ɡure. Adɑmɑ sɔ̃ɔ nɔɔbɑ yiruse, tɔ̃ɔ wɛ̃rɑruɡirɑ. Te sɔɔrɑ i ǹ ko ye wɑ i ɡurɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Kɑ mɛ, sɔ̃ɔ nɔɔbɑ yiruse te, tɔn ben ɡɑbɑ yɑrɑ bu wɑ bu kɑ ɡurɑ ɑdɑmɑ bɑ ǹ ɡɑ̃ɑnu wɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, sere dommɑ i ko i n nɛn ɡere kɑ nɛn woodɑbɑ yinɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","I yɑɑyo mɑ nɛ, Yinni Gusunɔ nɑ bɛɛ tɔ̃ɔ wɛ̃rɑruɡiru wɛ̃. Yen sɔ̃nɑ nɑ rɑ bɛɛ sɔ̃ɔ yirun dĩɑnu wɛ̃ sɔ̃ɔ nɔɔbɑ tiɑse. I de bɛɛn bɑɑwure u sinɑ u ku yɑri win wɑ̃ɑ yerun di u sɔmburu ko sɔ̃ɔ nɔɔbɑ yiruse te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Mɑ tɔn be, bɑ wɛ̃rɑ tɔ̃ɔ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Isirelibɑ bɑ dĩɑ ni sokɑ kɑ ben bɑrum mɑnnɑ. Yen tubusiɑnɑ, mbɑ yeni. Yɑ sɑ̃ɑwɑ nɡe dĩɑ bimɑ kpikɑ piibu. À n dendɑ, yɑ dowɑ nɡe kirɑ te bɑ kuɑ kɑ tim. ");
INSERT INTO bba_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Sɔ̃ɔ teeru Mɔwisi u nɛɛ, woodɑ wee ye Yinni Gusunɔ u bɛɛ wɛ̃ɛmɔ. I mɑnnɑ beruo, sɔ̃ɔ teerun dim sɑkɑ bɛɛn bibun bweserun sɔ̃ bu kɑ wɑ dĩɑ ni u bɛɛ wɛ̃ i di ɡbɑburɔ sɑnɑm mɛ u bɛɛ yɑrɑmɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Mɔwisi u mɑɑ Aroni sɔ̃ɔwɑ u nɛɛ, ɑ wekeru ɡɑru tɑmɑ ɑ mɑnnɑ doke sɔ̃ɔ teerun dim sɑkɑ, kpɑ ɑ tu yi Yinni Gusunɔn sɑ̃ɑ yerɔ, kpɑ yɑ n beruɑ bɛɛn bibun bweserun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Mɑ Aroni u ye suɑ u yi woodɑn kpɑkororun wuswɑɑɔ kpɑ yɑ n beruɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi woodɑ wɛ̃ u ko. ");
INSERT INTO bba_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Isirelibɑ bɑ mɑnnɑ ye diwɑ wɔ̃ɔ weeru, sere bɑ kɑ turɑ Kɑnɑnin tem nɔɔ burɑ yerɔ, tem mɛ̀ sɔɔ bɑ koo du bɑ n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Mɑnnɑn sɔ̃ɔ teerun dim sɑkɑwɑ bɑ rɑ soku omɛri. Omɛri ye, yɑ sɑ̃ɑwɑ ditiri nnɛn sɑkɑ. Omɛri wɔkurun sɑkɑwɑ bɑ rɑ soku efɑ. ");
INSERT INTO bba_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Isirelibɑn wuu te kpuro tɑ sĩimɑ sɑɑ ɡbɑburun di te bɑ mɔ̀ Sini, tɑ kɑ ten sɑnum dɔɔ nɡe mɛ Yinni Gusunɔ u bu sɔ̃ɔwɑ. Ye bɑ turɑ Refidimuɔ mɑ bɑ ben sɑnsɑni ɡirɑ, ɑdɑmɑ bɑ ǹ nim wɑ mi, bu nɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Miyɑ bɑ Mɔwisi nɔɔ kuurim wɔri bɑ nɛɛ, ɑ sun nim wɛ̃ɛyɔ su nɔ. Mɔwisi u bu sɔ̃ɔwɑ u nɛɛ, mbɑn sɔ̃nɑ i kɑ mɑn nɔɔ kuurimɔ. Nɡe mbɑ n kuɑ i kɑ Yinni Gusunɔn lɑɑkɑri mɛɛrimɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Adɑmɑ nim nɔru ɡɑ tɔn be bɑɑsi ɡiɑ mɑ bɑ Mɔwisi wɔkisimɔ bɑ mɔ̀, mbɑn sɔ̃nɑ ɑ sun yɑrɑmɑ Eɡibitin di. Kɑɑ kɑ de nim nɔru ɡu sun ɡo, bɛsɛ kɑ bɛsɛn bibu kɑ bɛsɛn yɑɑ sɑbenu. ");
INSERT INTO bba_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Mɑ Mɔwisi u Yinni Gusunɔ nɔɔɡiru sue u nɛɛ, mbɑ kon tɔn beni kuɑ. Wee, bɑ kĩ bu mɑn kpenu kɑsuku. ");
INSERT INTO bba_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, i sɑro i dɑ i n tɔn be ɡbiiye wunɛ kɑ ben ɡuro ɡurobu sɑnnu, kpɑ ɑ n wunɛn dɛkɑ ye nɛni yè ɑ kɑ dɑɑ ten nim so. ");
INSERT INTO bba_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Wee, kon yɔ̃rɑ wunɛn wuswɑɑɔ kperu ɡɑrun wɔllɔ Horɛbun ɡuurɔ, te bɑ mɑɑ sokumɔ Sinɑi, kpɑ ɑ kpee te so. Nim mu koo yɑri min di tɔn be, bu kɑ nɔ. Mɑ Mɔwisi u kuɑ mɛ, Isirelibɑn ɡuro ɡurobun wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Yerɑ u yɑm mi yĩsinu yiru kɑ̃ Teerɑ Mɑsɑ domi miyɑ Isirelibɑ bɑ nùn nɔɔ kuurɑ. Yiruse mɑɑ Mɛribɑ domi miyɑ bɑ Yinni Gusunɔn lɑɑkɑri mɛɛrɑ bɑ nɛɛ, Yinni Gusunɔ u wɑ̃ɑ bɛsɛn suunu sɔɔ? Nɡe u sɑri. ");
INSERT INTO bba_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Sɑnɑm mɛ sɔɔrɑ Amɑlɛkibɑ bɑ nɑ bɑ Isirelibɑ tɑbu wɔri Refidimuɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Yerɑ Mɔwisi u Yosue sɔ̃ɔwɑ u nɛɛ, ɑ durɔbu ɡɑbu ɡɔsio kpɑ i yɑri i dɑ i kɑ Amɑlɛkibɑ tɑbu ko siɑ. Nɛn tii kon dɑ n yɔ ɡuuru wɔllɔ nɑ n dɛkɑ ye sue wɔllɔ ye Gusunɔ u nɛɛ, nɑ n nɛni. ");
INSERT INTO bba_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yosue u Amɑlɛkibɑ tɑbu wɔri nɡe mɛ Mɔwisi u nùn sɔ̃ɔwɑ. Mɑ Mɔwisi kɑ Aroni kɑ Huri bɑ dɑ ɡuu ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Mɔwisi ù n win nɔmɑ sue wɔllɔ, Isirelibɑ bɑ rɑ n kɑmiɑmɔwɑ, ɑdɑmɑ ù n ye surɑ temɔ, Amɑlɛkibɑrɑ bɑ rɑ n bu kɑmiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Mɔwisin nɔmɑ yɑ mɔnyɑ mɑ bɑ kperu ɡɑru suɑ bɑ yi win kɔkɔrɔ mɑ u tu sinɑri. Mɑ Aroni kɑ Huri bɑ win nɔmɑ sue wɔllɔ, turo nɔm ɡeuɔ, turo mɑɑ nɔm dwɑrɔ. Mɑ win nɔmɑ suɑre wɔllɔ dim dim sere sɔ̃ɔ kɑ duɑ. ");
INSERT INTO bba_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Mɑ Yosue u Amɑlɛki kɑ win tɔmbu kɑmiɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ yeni yoruo tireru sɔɔ i kɑ ye yɑɑyɑ, kpɑ ɑ Yosue sɔ̃ mɑ kon de bu Amɑlɛkibɑ duɑri mɑm mɑm hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Yen biru Mɔwisi u yɑ̃ku yeru ɡirɑ mɑ u tu yĩsiru kɑ̃ Yinni Gusunɔwɑ nɛn tuutɑ. Domi wiyɑ u bu nɑsɑrɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","U nɛɛ, yèn sɔ̃ Amɑlɛkibɑ bɑ Yinni Gusunɔ seesi, yen sɔ̃nɑ u koo kɑ bu tɑbu ko sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Sɑɑ ye sɔɔ, Yetoro Mɑdiɑnibɑn yɑ̃ku kowo, wi u sɑ̃ɑ Mɔwisin dokiri, u nuɑ kpuro ye Yinni Gusunɔ u Mɔwisi kɑ win tɔmbu Isirelibɑ kuɑ sɑnɑm mɛ u bu yɑrɑmɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Mɑ u seewɑ u dɑ Mɔwisin mi kɑ Mɔwisin kurɔ Seforɑ kɑ win bibu yiru be u rɑɑ deri wi, Yetoron mi. N deemɑ, ye Mɔwisi u bii be mɑrɑ, u turo yĩsiru kɑ̃ Gɛɛsɔmu yèn sɔ̃ u wɑ̃ɑ tem tukumɔ u kɑ nùn mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Mɑ u yiruse yĩsiru kɑ̃ Ɛliesɛɛ yèn sɔ̃ Gusunɔ win bɑɑbɑn Yinniwɑ u nùn somi u nùn wɔrɑ Eɡibiti sunɔn nɔmun di. ");
INSERT INTO bba_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Mɑ Yetoro kɑ Mɔwisin kurɔ kɑ win bii be, bɑ turɑ mi Isirelibɑ bɑ ben sɑnsɑni ɡire ɡuu te bɑ mɔ̀ Sinɑiɔ. ");
INSERT INTO bba_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Sɑɑ yerɑ Yetoro u Mɔwisi ɡɔriɑ u nɛɛ, bu nùn sɔ̃ wee, u kɑ nùn win kurɔ nɑɑwɑ kɑ win bibu yiru ye. ");
INSERT INTO bba_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Ye Mɔwisi u nuɑ mɛ, yerɑ u yɑrɑ u win dokiri sennɔ dɑ. Ye u turɑ mi, mɑ u yiirɑ win wuswɑɑɔ. Yen biru u seewɑ bɑ bɔkɑsinɑ bɑ tɔbirinɑ. Mɑ Mɔwisi u kɑ nùn dɑ win dii bekuruɡirɔ. ");
INSERT INTO bba_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Mɑ u win dokiri wi sɑɑriɑ kpuro ye Yinni Gusunɔ u Eɡibitiɡibu kɑ ben sunɔ kuɑ be Isirelibɑn sɔ̃, kɑ sere nɔni swɑ̃ɑ te bɑ wɑ swɑɑ sɔɔ, kɑ nɡe mɛ Yinni Gusunɔ u bu yɑrɑ te sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Durom mɛ Yinni Gusunɔ u Isirelibɑ kuɑ mi, sɑnɑm mɛ u bu yɑrɑ Eɡibitiɡibun nɔmɑn di, yɑ Yetoro dore. ");
INSERT INTO bba_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Yerɑ u nɛɛ, nɑ Yinni Gusunɔ siɑrɑ wi u bɛɛ wɔrɑ sɑɑ Eɡibiti sunɔ kɑ win tɔmbun yorun di. ");
INSERT INTO bba_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Tɛ̃ nɑ ɡiɑ mɑ wiyɑ u bũnu kpuro kere. Domi u derɑ Eɡibitiɡibun nuku kɔ̃surɑ wɔri ben tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Mɑ u Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ kɑ yɑ̃kunu ɡɑnu. Yerɑ Aroni kɑ Isirelibɑn ɡuro ɡurobu bɑ nɑ bɑ di kɑ Mɔwisin dokiri wi sɑnnu bɑ kɑ Gusunɔ sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Yen sisiru bururu yerɑ Mɔwisi u sinɑ u kɑ Isirelibɑ siriɑ, mɑ tɔn be, bɑ yɔ̃ win wuswɑɑɔ sɑɑ bururun di sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Ye Yetoro u wɑ mɛ, yerɑ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, mbɑ ɑ tɔn be kuɑmmɛ mɛ. Mbɑn sɔ̃nɑ ɑ sɔ̃ wunɛ turo ɑ bu siriɑmmɛ sɑɑ bururun di sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Mɑ Mɔwisi u nùn sɔ̃ɔwɑ u nɛɛ, tɔn be, bɑ nɑɑmɔwɑ nɛn mi, n kɑ bu Gusunɔ bikiɑ ye u kĩ bu ko. ");
INSERT INTO bba_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Bɑ̀ n mɑɑ ɡɑri ɡɛɛ mɔ ben tii tiinɛ sɔɔ kpɑ n bu siriɑ n bu sɔ̃ɔsi ye Yinni Gusunɔ u kĩ. ");
INSERT INTO bba_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Yerɑ win dokiri wi, u nɛɛ, ye ɑ mɔ̀ mi, yɑ ǹ wɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Kɑɑ rɑ tii mɛɛrɑ kowɑ mi, kɑ sere mɑɑ tɔn be bɑ nun sikerenɛ mini. Domi sɔmbu te, tɑ kpɑ̃. A ǹ kpɛ̃ ɑ tu ko wunɛ turo. ");
INSERT INTO bba_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Tɛ̃ ɑ nɛn ɡɑri nɔɔwɔ, kpɑ Gusunɔ u nun somi. Bwisi yi kon nun kɛ̃ wee. A koowo tɔn ben wiruɡii Gusunɔn wuswɑɑɔ, kpɑ ɑ n dɑ kɑ ben ɡɑri de win mi. ");
INSERT INTO bba_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Kpɑ ɑ bu Gusunɔn woodɑbɑ tubusiɑ kɑ swɑɑ ye bɑ koo swĩi, kɑ sɔmɑ ye bɑ koo ko. ");
INSERT INTO bba_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kpɑ ɑ ɡɑbu ɡɔsi be sɔɔ, be bɑ koo kpĩ bu bu kpɑrɑ kpɑ yɛ̃robɑ n sɑ̃ɑ be bɑ Gusunɔ nɑsie, bɑ ɡem swĩi, bɑ ku rɑ nɔm birɑn kɛ̃nu mwɛ. Kpɑ ɑ ben ɡɑbu ko tɔmbu nɔrɔbun (1.000) wiruɡibu, ɡɑbu mɑɑ wunɔbun (100) wiruɡibu, ɡɑbu weerɑɑkurun wiruɡibu, ɡɑbu mɑɑ wɔkurun wiruɡibu. ");
INSERT INTO bba_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Beyɑ bɑ ko n dɑ tɔn be sirie bɑɑdommɑ kpɑ bɑ n dɑ kɑ ɡɑri yi yi sɛ̃ nɛ wunɛn mi. A de bu nun wunɛn sɔmunu kɑwɑ, kpɑ bu kɑ nun sɔbe. ");
INSERT INTO bba_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","À n kuɑ mɛ, mɑ Gusunɔ u nun kpɑre swɑɑ ye sɔɔ, kɑɑ kurɑ, kpɑ tɔn be, bu mɑɑ turi mi bɑ dɔɔ kɑ bɔri yɛndu. ");
INSERT INTO bba_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Mɔwisi u win dokirin ɡere wurɑ u kuɑ kpuro nɡe mɛ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","U tɔn be ɡɔsɑ Isirelibɑ sɔɔ be bɑ koo sɔmbu te kpĩ. Mɑ u ben ɡɑbu kuɑ tɔmbu nɔrɔbun (1.000) wiruɡibu, ɡɑbu mɑɑ wunɔbun (100) wiruɡibu, ɡɑbu weerɑɑkurun wiruɡibu, ɡɑbu mɑɑ wɔkurun wiruɡibu. ");
INSERT INTO bba_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Berɑ bɑ rɑ ɡɑri yi yi ǹ sɛ̃ siri. Yi yi sɛ̃ kpɑ bu kɑ Mɔwisi dɑɑwɑ. ");
INSERT INTO bba_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Yen biru win dokiri u nùn nɔɔ kɑnɑ mɑ u doonɑ u dɑ win temɔ. ");
INSERT INTO bba_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Yen biru Isirelibɑ bɑ doonɑ Refidimun di. Ye n kuɑ suru itɑsen tɔ̃ɔ ɡbiikiru sɑɑ mìn di bɑ yɑrɑ Eɡibitin di, yerɑ bɑ turɑ Sinɑin ɡbɑburɔ. Mɑ bɑ ben sɑnsɑni ɡirɑ ɡuu te bɑ mɔ̀ Sinɑin nuurɔ. ");
INSERT INTO bba_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Yerɑ Yinni Gusunɔ u Mɔwisi sokɑ ɡuu ten wɔllɔ u kɑ nùn ɡɑri ko. Ye u yɔɔwɑ mi, yerɑ Yinni Gusunɔ u nɛɛ, ɑmɛniwɑ kɑɑ Yɑkɔbun bibu Isirelibɑn bwese kɛri sɔ̃ ɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","i wɑ ye nɑ Eɡibitiɡibu kuɑ kɑ nɡe mɛ nɑ bɛɛ tii ɡɑwe nɑ suɑ kɑ nɛn nɔm dɑmɡuu nɡe mɛ ɡunɔ bɑkeru tɑ rɑ ten binu sue. ");
INSERT INTO bba_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Tɛ̃, ì n nɛn ɡere nuɑ, ì kun nɛn ɑrukɑwɑni kusie, i ko ko nɛn tiin tɔmbu n tɔmbu kpuro kere. Hɑnduniɑ kpuro sɑ̃ɑwɑ nɛɡiɑ, ");
INSERT INTO bba_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","ɑdɑmɑ bɛɛ i ko n sɑ̃ɑwɑ nɛn tɔn be nɑ ɡɔsɑ nɑ tii yiiye, kpɑ i n sɑ̃ɑ nɛn yɑ̃ku kowobu tɔn be bɑ tien sɔ̃. Gɑri yi kɑɑ Isirelibɑ sɔ̃wɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Yen biru Mɔwisi u sɑrɑmɑ u tɔn ben ɡuro ɡurobu sokusiɑ u bu sɔ̃ɔwɑ kpuro ye Yinni Gusunɔ u nɛɛ u bu sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Mɑ tɔn be kpuro bɑ wurɑ bɑ nɛɛ, ye Yinni Gusunɔ u ɡeruɑ kpuro, yeyɑ sɑ ko ko. Mɑ Mɔwisi u mɑɑ kɑ tɔn ben ɡere wurɑ Yinni Gusunɔn mi. ");
INSERT INTO bba_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, wee, kon nɑ wunɛn mi ɡuru wii wuro te tɑ sinum mɔ sɔɔ, kpɑ tɔn be, bu nɔ sɑnɑm mɛ nɑ kɑ nun ɡɑri mɔ̀, kpɑ bɑ n dɑ n nun nɑɑnɛ sɑ̃ɑ. Sɑɑ ye sɔɔrɑ Mɔwisi u den Yinni Gusunɔ tɔn ben ɡɑri yi tusiɑ. ");
INSERT INTO bba_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Yerɑ Yinni Gusunɔ u kpɑm nùn sɔ̃ɔwɑ u nɛɛ, ɑ doo ɑ tɔn be deemɑ ɑ bu sɔ̃ bu ben bekɑ teo bu tii dɛɛrɑsiɑ ɡisɔ kɑ siɑ, ");
INSERT INTO bba_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","kpɑ bɑ n sɔɔru sɑ̃ɑ bɑ n kɑ sɔ̃ɔ itɑse mɑrɑ. Domi sɔ̃ɔ itɑse te sɔɔrɑ nɛ, Yinni Gusunɔ kon sɑrɑmɑ Sinɑin ɡuurɔ be kpuro bu kɑ mɑn wɑ. ");
INSERT INTO bba_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Kɑɑ tɔn be yĩreru kuɑ mi bɑ koo yɔ̃rɑ ɡuu ten bɔkuɔ, kpɑ ɑ bu sɔ̃ bɑ n tii sɛ bu ku rɑɑ ɡuu te yɔ, bu ku mɑm susi ten ɡɑ̃ɑrɔ bu tu bɛsu. Ben wi u tu bɛsu, yɛ̃ro koo ɡbiwɑ. ");
INSERT INTO bba_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Bɑ ǹ nùn sɛ̃remɔ kɑ nɔmɑ, kpenɑ bɑ koo nùn kɑsuku, ǹ kun mɛ bu nùn sɛ̃ɛnu twee bu kɑ ɡo. Bɑɑ ǹ n yɑɑ sɑberun nɑ, mɛyɑ bɑ koo kɑ tu ɡo. Kɔbɑ yɑ̀ n swĩwɑ bɑ koo susi ɡuu ten bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Mɑ Mɔwisi u sɑrɑmɑ ɡuu ten min di, u tɔn be sɔ̃ɔwɑ u nɛɛ, bu tii dɛɛrɑsio bu kɑ Gusunɔ sɑ̃. Mɑ bɑ ben bekɑ teɑ. ");
INSERT INTO bba_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","U kpɑm bu sɔ̃ɔwɑ u nɛɛ, i ku rɑ kɑ bɛɛn kurɔbu bɑkunɑ i n sɔɔru sɑ̃ɑ i n kɑ sɔ̃ɔ itɑse te mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Sɔ̃ɔ itɑse ten bururu bɑ ɡuru kukiribu nuɑ, mɑ bɑ ɡuru mɑɑkinu kɑ ɡuru wii wuro te tɑ sinum mɔ wɑ ɡuu ten wɔllɔ. Mɑ kɔbɑ yɑ sumɔ tɑ̃ɑ tɑ̃ɑ sere tɔn be bɑ wɑ̃ɑ sɑnsɑni ye sɔɔ kpuro bɛrum bu mwɑ bɑ diirɑ. ");
INSERT INTO bba_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Yerɑ Mɔwisi u tɔn be yɑrɑmɑ ben sɑnsɑnin di bu dɑ bu kɑ Gusunɔ yinnɑ, mɑ bɑ yɔ̃rɑ ɡuu ten nuurɔ. ");
INSERT INTO bba_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Wiisu Sinɑin ɡuu te wukiri, domi Yinni Gusunɔ u sɑrɑmɑ kɑ dɔ̃ɔ u wɑ̃ɑ ten wɔllɔ. Wii si, su yɔɔmɔ nɡe dɔ̃ɔ bokon wiisu. Mɑ ɡuu te, tɑ yĩirumɔ kɑ dɑm. ");
INSERT INTO bba_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Kɔbɑ yen swĩi mɑɑ sosimɔ. Yerɑ Mɔwisi u ɡɑri ɡeruɑ, mɑ Gusunɔ u nùn wisɑ kɑ nɔɔɡii te tɑ sɑ̃ɑ nɡe ɡuru kukiribu. ");
INSERT INTO bba_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Nɡe mɛyɑ Yinni Gusunɔ u kɑ sɑrɑmɑ ɡuu ten wɔllɔ, mɑ u Mɔwisi sokɑ. Yerɑ Mɔwisi u yɔɔwɑ u dɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Mɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, ɑ sɑro ɑ tɔn be kirɔ ko ɡem ɡem bu ku rɑɑ susimɑ bu yĩre te sɑrɑ bu mɑn mɛɛri, kpɑ ben dɑbiru tu ku rɑɑ kɑm ko. ");
INSERT INTO bba_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Mɛyɑ yɑ̃ku kowobun tii, be bɑ rɑ mɑn susi, bu de bu tii dɛɛrɑsiɑ kpɑ n ku rɑ ben ɡɑbu ɡo. ");
INSERT INTO bba_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Mɑ Mɔwisi u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, tɔn be, bɑ ǹ yɔɔmɔ ɡuuru wɔllu mi. Domi ɑ sun kirɔ kuɑ ɡem ɡem ɑ nɛɛ n bu yĩreru kuo ɡuu ten bɔkuɔ mi bɑ koo yɔ̃rɑ. Kpɑ su tu ɡɑrisi ɡuu te ɑ tii yiiye. ");
INSERT INTO bba_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Yinni Gusunɔ u nɛɛ, ɑ sɑro ɑ dɑ kpɑ wunɛ kɑ Aroni i yɔɔmɑ, ɑdɑmɑ yɑ̃ku kowobu kɑ tɔn be bɑ tie, bu ku rɑɑ yĩre te sɑrɑ bu mɑn mɛɛri, kpɑ n ku rɑ ben ɡɑbu ɡo. ");
INSERT INTO bba_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Mɑ Mɔwisi u sɑrɑ u dɑ u tɔn be ɡɑri yi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Yen biru Gusunɔ u ɡɑri yini kpuro ɡeruɑ u nɛɛ. ");
INSERT INTO bba_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","Nɛnɑ Gusunɔ bɛɛn Yinni wi u rɑ n wɑ̃ɑ nɛ wi nɑ bɛɛ yɑrɑmɑ Eɡibitin tem di, nɑ bɛɛ yɑkiɑ sɑɑ yorun di. ");
INSERT INTO bba_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","Yen sɔ̃, i ǹ ko i ɡɑ̃ɑnu ɡɑnu sɑ̃ nɛ bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","I ku rɑ tii bwɑ̃ɑrokunu kuɑ ni nu sɑ̃ɑ ɡɑ̃ɑnun weenɑsinu ni nu wɑ̃ɑ wɔllɔ, ǹ kun mɛ temɔ, ǹ kun mɛ nim sɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","I ku rɑ yiirɑ i bwɑ̃ɑroku ɡɑɡu sɑ̃, domi nɛnɑ bɛɛn Yinni wi u rɑ n wɑ̃ɑ. Nɛ, Yinni nisinuɡiiwɑ, nɛ wi nɑ rɑ bɑɑbɑbɑn durum mɔɔru mwɛ ben bibun mi be bɑ mɑn tusɑn suunu sɔɔ sere kɑ ben sikɑdominun bibɔ. ");
INSERT INTO bba_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Adɑmɑ be bɑ mɑn kĩ, mɑ bɑ nɛn woodɑ nɑsie, nɑ rɑ ben bibun bweseru wɔnwɔndu kue sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Nɛnɑ bɛɛn Yinni wi u rɑ n wɑ̃ɑ. I ku rɑ nɛn yĩsiru soku kɑm. Wi u tu sokɑ kɑm, kon yɛ̃ro sɛɛyɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","I wɛ̃ro tɔ̃ɔ wɛ̃rɑruɡiru sɔɔ, kpɑ i tu ɡɑrisi te nɑ yi nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Sɔ̃ɔ nɔɔbɑ tiɑ i ko n dɑ bɛɛn sɔmɑ kpuro ko. ");
INSERT INTO bba_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Adɑmɑ sɔ̃ɔ nɔɔbɑ yiruserɑ tɑ sɑ̃ɑ tɔ̃ɔ wɛ̃rɑruɡiru te i nɛ Gusunɔ bɛɛn Yinni derie. Tɔ̃ɔ te sɔɔ, i ku rɑ sɔmburu ɡɑru ko, bɛɛ kɑ bɛɛn bibu, ǹ kun mɛ bɛɛn yobu, ǹ kun mɛ bɛɛn yɑɑ sɑbenu, ǹ kun mɛ sɔɔ be bɑ wɑ̃ɑ bɛɛn yɛnusɔ. ");
INSERT INTO bba_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Domi sɔ̃ɔ nɔɔbɑ tiɑn bɑɑ sɔɔrɑ nɑ kɑ wɔllu kɑ tem kɑ nim wɔ̃ku kuɑ kɑ bɑɑyere kpuro ye yɑ wɑ̃ɑ mi sɔɔ. Mɑ nɑ wɛ̃rɑ sɔ̃ɔ nɔɔbɑ yiruse. Yen sɔ̃nɑ nɑ sɔ̃ɔ nɔɔbɑ yiruse te domɑru kuɑ nɑ tu yi nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","I bɛɛn tundo kɑ mɛro bɛɛrɛ wɛ̃ɛyɔ kpɑ bɛɛn hunde yu wɑ yu dɑkɑɑ dɑ tem mɛ nɑ bɛɛ wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","I ku rɑ tɔnu ɡo. ");
INSERT INTO bba_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","I ku rɑ sɑkɑrɑru ko. ");
INSERT INTO bba_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","I ku rɑ ɡbɛni. ");
INSERT INTO bba_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","I ku rɑ ɡoo ɡɑri mɑni. ");
INSERT INTO bba_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","I ku rɑ bɛɛn tɔnusin diru binɛ ko, ǹ kun mɛ win kurɔ, ǹ kun mɛ win yobu, ǹ kun mɛ win yɑɑ sɑbenu, ye n sɑ̃ɑ wunɛn tɔnusin ɡɑ̃ɑnu kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Yen biru tɔn be kpuro bɑ ɡuru kukiribu kɑ kɔbɑn swĩi nuɑ mɑ bɑ ɡuru mɑɑkinu wɑ ɡuu ten wɔllɔ te wiisu wukiri. Yerɑ bɑ diirɑ bɑ dɑ bɑ yɔ̃rɑ n dɛsire. ");
INSERT INTO bba_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Bɑ Mɔwisi sɔ̃ɔwɑ bɑ nɛɛ, wunɛn tii, ɑ̀ n kɑ sun ɡɑri kuɑ, sɑ ko nun swɑɑ dɑki. Adɑmɑ ɑ ku de Gusunɔ u kɑ sun ɡɑri ko, kpɑ su ku rɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Mɑ Mɔwisi u tɔn be sɔ̃ɔwɑ u nɛɛ i ku bɛrum ko. Domi Yinni Gusunɔ u nɑwɑ u kɑ bɛɛn lɑɑkɑri mɛɛri kpɑ i n nùn nɑsie, i ku rɑ mɑɑ kɑ durum ko. ");
INSERT INTO bba_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Mɑ tɔn be, bɑ yɔ̃ n dɛsire sɑɑ ye Mɔwisi u ɡuru wii sinumɡii te susi mi Gusunɔ u wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bɛɛn tii i wɑ mɑ wɔllun diyɑ nɑ kɑ bu ɡɑri kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","Yen sɔ̃, i ku rɑ mɑɑ tii bwɑ̃ɑroku ɡɑɡu kuɑ kɑ wurɑ, ǹ kun mɛ kɑ sii ɡeesu, kpɑ i ɡu ko bɛɛn bũu. ");
INSERT INTO bba_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","Adɑmɑ i ko mɑn yɑ̃ku yeru bɑniɑ kɑ tem. Kpɑ i bɛɛn yɑɑ sɑbenu ɡɔsi i kɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kɑ siɑrɑbun yɑ̃kunu kuɑ ten wɔllɔ. Yɑm kpuro mi nɑ ɡɔsɑ i kɑ mɑn sɑ̃, ko nɑ n wɑ̃ɑ mi, kpɑ n bɛɛ domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ì n mɑn yɑ̃ku yeru bɑniɑmmɛ kɑ kpenu, i ku tu bɑni kɑ kpee ni i dɑ̃kɑ. Domi ì n kpee ni dɑ̃kɑ, i nu disi dokewɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","I ku rɑ de tɑ n yɔɔtiɑ mɔ, kpɑ bu ku rɑɑ kɑ bɛɛn tereru wɑ ì n yɔɔmɔ mi. ");
INSERT INTO bba_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑ woodɑ yeni wɛ̃ɛyɔ. ");
INSERT INTO bba_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","Ben ɡoo ù n win Isirelisi dwɑ yoo, yoo wi, u koo win yinni sɑ̃wɑ wɔ̃ɔ nɔɔbɑ tiɑ, nɔɔbɑ yiruse u koo yɑriwɑ yoo ten di u kun ɡɑ̃ɑnu kɔsie. ");
INSERT INTO bba_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Ù kun kurɔ mɔ u kɑ duɑ yoo te sɔɔ, wi turowɑ u koo yɑri. Ù n mɑɑ kurɔ mɔ bɑ kɑ nùn dwɑ, sɑnnɑ bɑ koo yɑri. ");
INSERT INTO bba_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Ǹ n win yinnin nɑ, u nùn kurɔ wɛ̃, mɑ u kɑ kurɔ wi bibu mɑrɑ, dɔmɑ te u yɑriɔ yorun di, u koo kurɔ kɑ win bibu win yinni deriɑwɑ kpɑ u yɑri wi turo. ");
INSERT INTO bba_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","Adɑmɑ yoo wi, ù n ɡeruɑ bɑtumɑ sɔɔ u nɛɛ, u win yinni kĩ kɑ mɑɑ win kurɔ wi, kɑ win bibu, yen sɔ̃, u ǹ yɑriɔ, ");
INSERT INTO bba_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","sɑɑ yerɑ yinni wi, u koo kɑ nùn dɑ Yinni Gusunɔn sɑ̃ɑ yerɔ. Miyɑ u koo nùn sɛririsiɑ sɑ̃ɑ yee ten ɡɑmboɔ, u nùn swɑɑ yɑbɑ kɑ sɔkurɑ. Kpɑ n sɑ̃ɑ yĩreru mɑ yoo wi, u sɑ̃ɑwɑ win yoo sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","Goo ù n mɑɑ win bii tɔn kurɔ dɔrɑ yoo, bɑ ǹ nùn yɑkiɑmɔ nɡe mɛ bɑ rɑ yoo tɔn durɔbu yɑkie. ");
INSERT INTO bba_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Win yinni ù n nùn suɑ kurɔ, mɑ u wɑ dɑ̃kuru yɑ ǹ kɑ nùn nɑɑwɛ u koo kpĩ u nùn win tɔmbu yɑkie. Adɑmɑ u ku rɑɑ nùn tɔn tuko yɑkie. Domi durɔ wi, u kuɑ nɑɑnɛ sɑriruɡii. ");
INSERT INTO bba_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Goo ù n yoo tɔn kurɔ dwɑ u kɑ win bii tɔn durɔ wɛ̃, u nùn kuo nɡe mɛ bɑ rɑ bii wɔndiɑ kue bɑ̀ n nùn suɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Goo ù n yoo suɑ kurɔ, yen biru ù n mɑɑ kurɔ kpɑo suɑ, u ku rɑɑ yoo win dĩɑnu kɑ win yɑ̃ɑ ni u rɑ rɑɑ nùn wɛ̃ kɑwɑ. Mɛyɑ mɑɑ ben wɑ̃ɑsinɑɑ sɔɔ, u ku rɑɑ de ɡɑ̃ɑnu ɡɑnu kɔsi. ");
INSERT INTO bba_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Ù kun mɑɑ nùn ɡɑ̃ɑnu itɑ yenin ɡɑɑ kuɑmmɛ, u de kurɔ wi, u yɑri yorun di u kun ɡɑ̃ɑnu kɔsie. ");
INSERT INTO bba_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","Wi u tɔnu so u ɡo, bɑ koo yɛ̃ron tii ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Adɑmɑ wi u kun kĩ u kɑ tɔnu ɡo sɑmbɑ sɔɔ, nɛ Yinni Gusunɔ kon yɑm ɡɑm ɡɔsi mi u koo kpikiru dɑ u kuke. ");
INSERT INTO bba_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Wi u win winsim mwɑ u ɡo nuku kɔ̃surun sɔ̃ kɑ bwisi, bu yɛ̃ro mɔɔ bu ɡo, bɑɑ ù n duɑ nɛn sɑ̃ɑ yerɔ u yɑ̃ku yeru nɛnuɑ u kɑ bɔ̃re. ");
INSERT INTO bba_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","Wi u win tundo so, ǹ kun mɛ win mɛro, bɑ koo yɛ̃ro mwɑ bu ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","Wi u tɔnun tii ɡbɛnɑ u dɔrɑ, ǹ kun mɛ u nùn kuɑ win yoo, bɑ koo yɛ̃ro mwɑ bu ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","Wi u win mɛro, ǹ kun mɛ win tundo kɔ̃sɑ ɡerusi, bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","Sɑɑ ye tɔmbu yiru bɑ sɑnnɑmɔ mɑ ben turo u win winsim so kɑ nɔm kuseru, ǹ kun mɛ u nùn kɑrɑ kɑ kperu u mɛɛrɑ kuɑ, mɑ yɑ kun nùn ɡo, bɑ ǹ wi u nùn so mi ɡoomɔ. Yɑ̀ n nùn kpĩ, ");
INSERT INTO bba_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","mɑ u rɑ sɑnɔ kuɑ u kɑ dɛkɑ sĩimɔ, wi u nùn mɛɛrɑ kuɑ mi, bɑ ǹ nùn ɡɑ̃ɑnu kuɑmmɛ. Adɑmɑ durɔ win sɔmbu te u koo rɑɑ ko ù n bwɑ̃ɑ do, wi u nùn mɛɛrɑ kuɑ mi, wiyɑ u koo tu ko, kpɑ u mɑɑ mɛɛrɑ yen nɔɔribun ɡobi kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","Goo ù n win yoo so kɑ bokuru u ɡo mii mii bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Adɑmɑ yoo wi, ù n kuɑ tɔ̃ɔ ɡiriru ǹ kun mɛ sɔ̃ɔ ɡirɑ yiru u sere ɡu, bɑ ǹ mɑɑ win yinni ɡɑ̃ɑnu kuɑmmɛ, domi yoo wi, u sɑ̃ɑwɑ win ɡobi. ");
INSERT INTO bba_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","Tɔn durɔbu ɡɑbu bɑ̀ n sɑnnɑmɔ, mɑ bɑ ɡurɑɡii wɔri sere win nukurɑ kɑ yɑrɑ, mɑ win ɡɑm kun mɛɛrɑ wɑ, yen mɛ kurɔ win durɔ u tɔn be bure, mɛyɑ bɑ koo kɔsiɑ siri kowobun wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Adɑmɑ kurɔ wi, ù n mɛɛrɑ ɡɑɑ wɑ, mɛɛrɑ yen bweserɑ bɑ koo mɑɑ bu ko. Ù n mɑɑ ɡun nɑ, bɑ koo bu ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","Ǹ n win nɔnin nɑ bɑ wunɑ bɑ koo mɑɑ beɡii wunɑwɑ. Ǹ n win dondun nɑ bɑ buɑ, bɑ koo mɑɑ beɡinu buɑwɑ. Ǹ n win nɔmɑn nɑ bɑ buɑ, bɑ koo mɑɑ beɡiɑ buɑwɑ. Ǹ n win nɑɑsun nɑ bɑ buɑ, bɑ koo mɑɑ beɡisu buɑwɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","Ǹ n mɑɑ dɔ̃ɔn nɑ bɑ nùn mɛni, bɑ koo mɑɑ be dɔ̃ɔ mɛniwɑ. Mɛɛrɑ yèn bweseru bɑ nùn kuɑ ɡesi, yen bweserɑ bɑ koo mɑɑ bu ko. ");
INSERT INTO bba_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","Goo ù n win yoo tɔn durɔ, ǹ kun mɛ tɔn kurɔn nɔnu kɔrɑ, u koo yoo wi kɑrɑwɑ u doonɑ nɔnu ɡen sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ǹ n mɑɑ win dondun nɑ u wunɑ, u koo nùn kɑrɑwɑ u doonɑ don ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","Kɛtɛ yɑ̀ n tɔnu kɔbɑ so yɑ ɡo, bɑ koo yen tii kpenu kɑsuku bu ɡowɑ, bɑ ǹ yen yɑɑ temmɔ. Yen biru bɑ ǹ mɑɑ yen yinni ɡɑ̃ɑnu kuɑmmɛ. ");
INSERT INTO bba_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Adɑmɑ kɛtɛ ye, yɑ̀ n dɑɑ ɡoo kɔbɑ sɔkure mɑ bɑ yen yinni sɔ̃ɔwɑ mɑ u ǹ kɑ ye ɡɑ̃ɑnu kue, bɑ koo win tii ɡowɑ kɑ kɛtɛ ye sɑnnu. ");
INSERT INTO bba_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Bɑ̀ n mɑɑ nùn ɡɑ̃ɑnu buren nɑ u wɑ u kɑ win wɑ̃ɑru yɑkiɑ, u koo ni kpuro kɔsiɑwɑ nɡe mɛ bɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kɛtɛ yen bweseru yɑ̀ n bii ɡoo kɔbɑ sɔkɑ, siri tee biyɑ bɑ koo ye kuɑ mi, kɑ yen yɛ̃ro. ");
INSERT INTO bba_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Adɑmɑ kɛtɛ ye, yɑ̀ n ɡoon yoo so yɑ ɡo, sii ɡeesun ɡobi tɛnɑ yen yinni u koo yoo win yinni wɛ̃, kpɑ bu kɛtɛ ye kpenu kɑsuku bu ɡo. ");
INSERT INTO bba_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","Goo ù n dɔkɔ mɔ, ǹ kun mɛ u wɔru ɡɑɡu ɡbɑ u deri u ǹ wukiri, mɑ ɡoon yɑɑ sɑberɑ wɔri mi, tɑ ɡu, ");
INSERT INTO bba_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","wi u dɔkɔ ye mɔ ǹ kun mɛ wɔru ɡe, u koo sɑbe ten kɔsire wɛ̃wɑ kpɑ u sɑbe ɡoo te suɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Goon kɛtɛ yɑ̀ n ɡooɡiɑ mɛɛrɑ kuɑ yɑ ɡo, bɑ koo kɛtɛ wɑsɑ ye dɔrɑwɑ bu yen ɡobi bɔnu ko. Kpɑ bu mɑɑ ye yɑ ɡu min yɑɑ bɔnu ko. ");
INSERT INTO bba_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Kɛtɛ ye, yɑ̀ n dɑɑ ɡɛɛ mɛɛrɑ koore, mɑ yen yɛ̃ro u yɛ̃ ɑdɑmɑ u ǹ ɡɑ̃ɑnu kue, u koo ye yɑ ɡu min kɔsire wɛ̃wɑ kpɑ wi, u ɡoo te suɑ. ");
INSERT INTO bba_vpl VALUES ("EX21_37","003_21_37","EXO","21","37","37","Goo ù n kɛtɛ ɡbɛnɑ u ɡo, ǹ kun mɛ u ye dɔrɑ, kɛtɛ nɔɔbuwɑ u koo kɔsiɑ tiɑ yen wɔllɔ. Ǹ n mɑɑ yɑ̃ɑrun nɑ, yɑ̃ɑnu nnɛwɑ u koo kɔsiɑ tee ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","3","Ye u ɡbɛnɑ mi, bɑ̀ n ye wɑ win nɔmɑ sɔɔ, ǹ n kɛtɛn nɑ, ǹ kun mɛ kɛtɛku, ǹ kun mɛ yɑ̃ɑru, mɑ yɑ ɡesi wɑsi, yen yiruwɑ u koo wɛ̃. Ù kun mɑɑ ɡɑ̃ɑnu mɔ, bɑ koo win tii dɔrɑwɑ. Goo ù n ɡbɛnɑ dɑ wɔ̃kuru, bɑ̀ n nùn mwɑ wɔ̃ku te, bɑ so bɑ ɡo, bɑ ǹ ɡoo win yɛm bikiɑmɔ. Adɑmɑ yɑm mù n sɑ̃rɑ bɑ sere nùn ɡo, be bɑ nùn ɡo mi, bɑ koo bu win yɛm bikiɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Bɛɛn ɡoo ù n win sɑbenu sure win winsim ɡberɔ, ǹ kun mɛ win dɑ̃ɑ ɡbɑɑrɔ, mɑ nu dĩɑnu ɑsɔrɔ kuɑ, win ɡberun dĩɑ ɡeenɑ u koo yɛ̃ro kɔsire wɛ̃, ǹ kun mɛ win dɑ̃ɑ mɑrum. ");
INSERT INTO bba_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","Goo ù n dɔ̃ɔ mɛnimɑ, dɔ̃ɔ wi, ù n duɑ ɡoon ɡberɔ, mɑ yɛ̃ron dĩɑnu kpuro dɔ̃ɔ mwɑɑrɑ, wi u dɔ̃ɔ mɛni mi, u koo dĩɑ ni nu dɔ̃ɔ mwɑɑrɑn kɔsire wɛ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","Goo ù n win winsim ɡobi, ǹ kun mɛ ɡɑ̃ɑnu berusiɑ, mɑ bɑ nu ɡbɛnɑ mi u beruɑ mi, bɑ̀ n ɡbɛnɔ wi wɑ ye u suɑ min nɔn yiruwɑ u koo kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","Bɑ̀ kun mɑɑ nùn wɑ, wìn mi bɑ ɡɑ̃ɑ ni ɡbɛnɑ u koo dɑwɑ Gusunɔn sɑ̃ɑ yerɔ u nɔmɑ suɑ wɔllɔ u bɔ̃re u nɛɛ, u ǹ ɡɑ̃ɑnu ɡɑnu sue ni bɑ nùn berusiɑ mi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Tɔmbu yiru bɑ̀ n ɡɑ̃ɑnu sikirinɛmɔ, ǹ n yɑɑ sɑberun nɑ, ǹ kun mɛ yɑ̃nu, ǹ kun mɛ ɡɑ̃ɑ ni nu kɔ̃ɔrɑ, be kpuro bɑ koo dɑwɑ Gusunɔn sɑ̃ɑ yerɔ u bu siriɑ. Ben wi u kun ɡem mɔ, ye bɑ sikirinɛ min wɑsi yiruwɑ u koo kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Goo ù n win winsim yɑɑ sɑberu ɡɑru sɑbusiɑ, mɑ tɑ bɔɔrɑ ǹ kun mɛ tɑ ɡu ǹ kun mɛ bɑ tu sɛ̃re bɑ mwɑ ɡoo kun wɑ, ");
INSERT INTO bba_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","wi bɑ tu sɑbusiɑ mi, u koo dɑwɑ Gusunɔn sɑ̃ɑ yerɔ u bɔ̃re u nɛɛ, u ǹ tu bɑbe. Sɑnɑm mɛyɑ, wi u sɑbe te mɔ mi, u koo durɔ win ɡere wurɑ kpɑ wi bɑ sɑbe te sɑbusiɑ u ku mɑɑ ɡɑ̃ɑnu ɡɑnu kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","Adɑmɑ bɑ̀ n sɑbe te ɡbɛnɑn nɑ win yɛnuɔ, u koo ten kɔsire wɛ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Ǹ n mɑɑ ɡbeeku yɑɑn nɑ yɑ tu mwɑ yɑ kɑsukɑ, u kɑ ten seedɑ nɑ u sɔ̃ɔsi. Sɑɑ ye, u ǹ mɑɑ ten kɔsire wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Goo ù n mɑɑ win winsim yɑɑ sɑberu bɔkurɑ, mɑ tɑ bɔɔrɑ ǹ kun mɛ tɑ ɡu sɑnɑm mɛ wi u tu mɔ u ǹ wɑ̃ɑ mi, bɑ koo nùn ten kɔsire wɛ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","Adɑmɑ ù n wɑ̃ɑ mi, bɑ ǹ mɑɑ nùn kɔsire wɛ̃ɛmɔ. Bɑ̀ n mɑɑ tu due kuɑn nɑ, ten due ɡobi yi, yi turɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Goo ù n wɔndiɑ kɔkurɑ u nùn bekuru doke, mɑ bɑ ǹ dɑɑ wɔndiɑ wi durɔ kɑ̃, wi u nùn bekuru doke mi, u koo dokiriru kpuro kowɑ nɡe mɛ bɑ rɑ ko, kpɑ u wɔndiɑ wi suɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","Bɑɑ wɔndiɑ win tundo ù n yinɑ bu suɑnɑ, kɑ mɛ, durɔ wi, u koo dokiriru kpuro kowɑ nɡe mɛ bɑ rɑ ko bu kɑ wɔndiɑ suɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Tɔn kurɔ sɔro ù n wɑ̃ɑ bɛɛn suunu sɔɔ, i nùn ɡoowo. ");
INSERT INTO bba_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","Wi u mɑɑ kɑ yɑɑ sɑberu kpunɑ, i yɛ̃ro ɡoowo. ");
INSERT INTO bba_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","Nɛ, Yinni Gusunɔ turowɑ i ko sɑ̃. Wi u yinɑ u bũu ɡoo sɑ̃ɑmɔ, i yɛ̃ro ɡoowo. ");
INSERT INTO bba_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","I ku sɔɔ ɡoo nɔni sɔ̃. I ku mɑɑ nùn tɑki di. I yɑɑyo mɑ bɛɛn tii i rɑɑ sɔru di Eɡibitin temɔ. ");
INSERT INTO bba_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","I ku ɡɔmini ɡoo nɔni sɔ̃, ǹ kun mɛ ɡobeku ɡoo. ");
INSERT INTO bba_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","Wi u bu nɔni sɔ̃ɔmɔ mɑ bɑ mɑn somiru kɑnɑ, kɑ ɡeemɑ nɑ bɛɛ sɔ̃ɔmɔ, kon bu somi. ");
INSERT INTO bba_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Kpɑ n de nɛn mɔru yu se bu bɛɛ ɡo tɑbu ɡberɔ, bɛɛn kurɔbu bu mɑɑ ko ɡɔminibu kpɑ bɛɛn bibu bu mɑɑ ko ɡobekubɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Bɛɛ Isirelibɑ sɔɔ, bɛɛn wi u sɑ̃ɑro ɡobi bɔkurɑ, u ku rɑɑ yi nim dokeɑ nɡe mɛ bwese tukunu nu rɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","Ì n ɡoon bekuru tɔrubɑ mwɑ, i nùn tu wesiɑ sɔ̃ɔ u sere du. ");
INSERT INTO bba_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Domi beku tee terɑ u mɔ mi, u kɑ win wɑsi wukiri. Yen sɔ̃, ɑ̀ n tu nɛni mbɑ u koo wukiri wɔ̃kuru. Sɑnɑm mɛ sɔɔ, ù n mɑn wuri koosimɑ, kon nùn wɔnwɔndu kuɑ, n nùn swɑɑ dɑki. ");
INSERT INTO bba_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","I ku rɑ mɑn kɔ̃sɑ ɡerusi, i ku rɑ mɑɑ bɛɛn wiruɡii bɔ̃re. ");
INSERT INTO bba_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","Ì n bɛɛn dĩɑ ɡbiikinu ɡɑ̃ i ku de n tɛ i sere kɑ nɛɡinu nɑ. I ku mɑɑ tɛ i kɑ bɛɛn bii tɔn durɔ ɡbiikobu yɑkiɑ domi bɑ sɑ̃ɑwɑ nɛɡibu. ");
INSERT INTO bba_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","Mɛyɑ i ko mɑɑ mɑn bɛɛn yɑɑ sɑbenun bii ɡbiikinu yiiyɑ nɛnɛm ɑdɑmɑ i ko de nu ɡinɑ bɔm nɔwɑ sɔ̃ɔ nɔɔbɑ yiru, nɔɔbɑ itɑse i sere kɑ mɑn nu yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Bɛɛn tii mɑɑ, i ko n wɑ̃ɑwɑ nɛnɛm nɛn sɔ̃, i n dɛɛre. Yen sɔ̃, i ku yɑɑ ɡɑɑ tem ye ɡbeeku yɑɑ yɑ ɡo yɑ deri. I ye bɔ̃nu wɛ̃ɛyɔ domi bɑ ǹ ye sɑke. ");
INSERT INTO bba_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","I ku lɑbɑɑri weesuɡiɑ kpɑrɑ. I ku mɑɑ tɔn kɔ̃so seedɑ weesuɡiɑ diiyɑ u kɑ yɑri. ");
INSERT INTO bba_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","Bɛɛn ɡoo u ku rɑɑ tɔn dɑbinun ɡere swĩi u kɑ kɔ̃sɑ ko. Mɛyɑ u ku mɑɑ bu swĩi bɑ̀ n ɡem sĩiyɑmɔ siribu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","I ku ɡoo siri kɑ wɔnwɔndu bɑɑ ù n sɑ̃ɑ bwɛ̃ɛbwɛ̃ɛ. ");
INSERT INTO bba_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","Ì n bɛɛn wɛrɔbun sɑberu ɡɑru wɑ tɑ kɔ̃ɔrɔ, kɛtɛwɑ? Ǹ kun mɛ kɛtɛku? I tu mɔɔ i kɑ nùn wurɑmɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Ì n mɑɑ win kɛtɛku wɑ ɡɑ wɔrumɛ kɑ sɔmunu, i ku doonɑ i nùn deri. I nùn somiɔ i kɑ ɡu seeyɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","Siribu sɔɔ, i ku wi u ɡem mɔ ɡem birɑ win bwɛ̃ɛbwɛ̃ɛrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","I ku seedɑ weesuɡiɑ wurɑ. I ku mɑɑ ɡoo ɡo wi u kun tɑɑrɛ ɡɑɑ kue. Domi wi u kuɑ mɛ, nɛ, Yinni Gusunɔ kon yɛ̃ro sɛɛyɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","I ku nɔm birɑn kɛ̃nu mwɑ domi nu rɑ tɔnu nɔni wɔ̃kewɑ ɡem swɑɑ sɔɔ kpɑ u kpɑnɑ u mu ɡere. ");
INSERT INTO bba_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","I ku wi u sɔru dimɔ bɛɛn suunu sɔɔ nɔni sɔ̃. Domi bɛɛn tii i yɛ̃ nɡe mɛ u bwisikumɔ, yèn sɔ̃ i rɑɑ sɔru di Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","Wɔ̃ɔ nɔɔbɑ tiɑn bɑɑ sɔɔrɑ i ko i n dɑ bɛɛn ɡberun dĩɑnu duure, kpɑ i nu ɡɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","Adɑmɑ wɔ̃ɔ nɔɔbɑ yiruse, i ko i bɛɛn ɡbeɑn tem kpuro deriwɑ mu wɛ̃rɑ, kɑ bɛɛn dɑ̃ɑ ɡbɑɑnɔ. Kpɑ i de be bɑ sɑ̃ɑ sɑ̃ɑrobu bu dɑ bu dĩɑnu kunɔnu ko be kɑ yɑɑ sɑbenu. ");
INSERT INTO bba_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","Mɛyɑ mɑɑ sɔ̃ɔ nɔɔbɑ tiɑn bɑɑ sɔɔrɑ i ko i bɛɛn sɔmɑ kpuro ko. Adɑmɑ nɔɔbɑ yiruse i ko wɛ̃rɑwɑ kɑ bɛɛn yobu kɑ sɔɔ be bɑ sɔmburu mɔ̀ bɛɛn mi, kɑ sere bɛɛn yɑɑ sɑbe ni i rɑ kɑ sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","Ye nɑ bɛɛ sɔ̃ɔwɑ kpuro, i ye mɛm nɔɔwɔ mɑm mɑm. Kpɑ i ku rɑ bũnu ɡɑnun yĩsiru siɑ i sere nɛɛ, ko i nu sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","Wɔ̃ɔ bɑɑɡere nɔn itɑwɑ i ko i n dɑ mɑn tɔ̃ɔ bɑkɑru kue. ");
INSERT INTO bba_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","Pɛ̃ɛ ye bɑ ǹ seeyɑtiɑ doken tɔ̃ɔ bɑkɑrɑ i ko ɡbi i ko. Sɔ̃ɔ nɔɔbɑ yiruwɑ i ko pɛ̃ɛ di ye yɑ kun seeyɑtiɑ mɔ nɡe mɛ nɑ rɑɑ bɛɛ yen woodɑ wɛ̃, wɔ̃ɔn suru ɡbiikoo wi bɑ mɔ̀ Abibu sɔɔ, domi sɑɑ yerɑ i yɑrɑ Eɡibitin di. Ì n kɑnɑru mɔ̀, ɡoo u ku rɑɑ nɑ nɛn wuswɑɑɔ u kun kɛ̃ru nɛni. ");
INSERT INTO bba_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","Yiruse kpɑ i mɑɑ bɛɛn ɡbeɑn dĩɑ ɡbiikinun yɑɑ kpɑɑbun tɔ̃ɔ bɑkɑru di. Yen biru ì n bɛɛn ɡberun dĩɑnu kpuro ɡɑ̃ kpɑ i mɑɑ yen tɔ̃ɔ bɑkɑru di, i n wɑ̃ɑ kunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","Nɡe mɛyɑ wɔ̃ɔ bɑɑɡere bɛɛ tɔn durɔbu i ko i n dɑ kɑ mɛnnɛ nɔn itɑ nɛn sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","Ì n mɑn yɑ̃kuru kuɑ, i ten yɑɑ ɡum dɔ̃ɔ mɛniɔ dɔmɑ te. Ì n mɑɑ ten yɑɑ dimɔ, i ku ye mɛnnɑ kɑ pɛ̃ɛ ye bɑ seeyɑtiɑ doke. ");
INSERT INTO bba_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","I n dɑ kɑ mɑn bɛɛn ɡberun dĩɑ ɡbiikii ni nu ɡeɑ sɑ̃ɑ nɑɑwɛ nɛn sɑ̃ɑ yerɔ. Domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. I ku boo buu yike kɑ ɡen mɛron bom. ");
INSERT INTO bba_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","Yenibɑ kpuron biru Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ u nɛɛ, kon bɛɛ nɛn ɡɔrɑdo ɡɔriɑmɑ u kɑ bɛɛ kpɑrɑ kpɑ u n bɛɛ kɔ̃su bɛɛn sɑnum sɔɔ. U koo kɑ bɛɛ dɑ tem mɛ nɑ bɛɛ sɔɔru kuɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Yen sɔ̃, i de i n tii sɛ kpɑ i nùn mɛm nɔɔwɑ, kpɑ i ku nùn nuki sɑnku. Domi u ǹ dɑ bɛɛ suuru kuɑmmɛ ì n torɑ, yèn sɔ̃ nɛn yiiko yɑ wɑ̃ɑ wi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Adɑmɑ ì n nùn mɛm nɔɔwɑ mɑm mɑm, mɑ i mɔ̀ dee dee ye nɑ bɛɛ yiire, nɛnɑ kon kɑ bɛɛn wɛrɔbu kpuro sɑnnɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Nɛn ɡɔrɑdo wi, u koo bɛɛ swɑɑ ɡbiiyɑ u kɑ bɛɛ turi sere tem mi Amɔrebɑ kɑ Hɛtibɑ kɑ Feresibɑ kɑ Kɑnɑnibɑ kɑ Hefibɑ kɑ sere Yebusibɑ bɑ wɑ̃ɑ. Kpɑ n be kpuro ɡo bɛɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Adɑmɑ ì n turɑ mi, i ku rɑ ben bũnu sɑ̃, i ku mɑɑ ben komɑnu sɑɑri. I ben bũu turɑnu suririo kpɑ i ben bwɑ̃ɑrokunu kɔsuku muku muku. ");
INSERT INTO bba_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Nɛ Gusunɔ bɛɛn Yinniwɑ i ko i sɑ̃ kpɑ n bɛɛ domɑru kuɑ, i n dĩɑnu mɔ kɑ nim. Mɛyɑ nɑ kon mɑɑ bɛɛ bɑrɑnu ɡbɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Nɑ ǹ mɑɑ derimɔ tɔn kurɔ ɡoon nukuru tu yɑri, mɛyɑ bɛɛn ɡoo kun mɑɑ mɔ̀ wĩro. Kon mɑɑ de bɛɛn hunde yu dɛ̃ɛyɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","Ye kon mɑɑ wure n ko wee. Be bɑ nuɑ i duɔ ben temɔ kpuro, kon de bu nɑndɑ, kpɑ bu yɑri bu doonɑ bɛɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Kon Hefi be, kɑ Kɑnɑni be, kɑ Hɛti be susunu kpɑre, kpɑ bu yɑri bu doonɑ tem min di. ");
INSERT INTO bba_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Adɑmɑ nɑ ǹ be kpuro ɡirɑmɔ wɔ̃ɔ tiɑn bɑɑ sɔɔ, tem mɛ, mu ku rɑɑ kɑ ko bɑnsu, kpɑ ɡbeeku yɛɛ yi bɛɛ yibusi. ");
INSERT INTO bba_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Fiiko fiikowɑ kon de bɑ n doonɑmɔ min di, sere i kɑ dɑbiɑ i tɛriɑ i sinɑ tem mɛ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","Tem mɛ kon bɛɛ wɛ̃ mi, mɛn nɔɔ burɑ yerɑ ko n wɑ̃ɑwɑ sɑɑ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑrin di sere n kɑ ɡirɑri Filisitibɑn nim wɔ̃kuɔ, kɑ mɑɑ sɑɑ Sinɑin ɡbɑburun di, sere n kɑ ɡirɑri dɑɑ te bɑ mɔ̀ Efɑrɑtiɔ. Tɔn be bɑ wɑ̃ɑ tem mi kpuro, kon bɛɛ bu nɔmu bɛriɑwɑ kpɑ i bu ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","I ku rɑ kɑ bu ɑrukɑwɑni ɡɑɑ bɔke. I ku mɑɑ ben bũu ɡoo sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Ì n ben bũnu sɑ̃ɑmɔ, nu ko n sɑ̃ɑwɑ bɛɛn yinɑ. Yen sɔ̃, i ku de ben ɡoo u n wɑ̃ɑ bɛɛn suunu sɔɔ kpɑ u ku rɑɑ bɛɛ torɑsiɑ nɛn swɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, i yɔɔmɑ Sinɑin ɡuuru mini, nɛn mi, wunɛ kɑ Aroni kɑ Nɑdɑbu kɑ Abihu kɑ Isirelibɑn ɡuro ɡurobu wɑtɑ kɑ wɔkuru, kpɑ i mɑn kpunɑ sɑrun di. ");
INSERT INTO bba_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Wunɛ Mɔwisi, kɑɑ mɑn susimɑ wunɛ turo. Be bɑ kɑ nun yɔɔmɑ bu yɔ̃ro mi bɑ wɑ̃ɑ mi. Tɔn be bɑ mɑɑ tie, bu ku rɑɑ yɔɔmɑ mini. ");
INSERT INTO bba_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Mɑ Mɔwisi u dɑ u tɔn be Yinni Gusunɔn ɡɑri kɑ win woodɑbɑ kpuro sɔ̃ɔwɑ. Mɑ be kpuro bɑ wurɑ kɑ ɡɔ̃ru teu bɑ nɛɛ, sɑ ko ko ye Yinni Gusunɔ u ɡeruɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Mɔwisi u Yinni Gusunɔn ɡɑri yi kpuro yoruɑ mɑ u seewɑ buru buru u yɑ̃ku yeru bɑnɑ ɡuu ten nuurɔ. U mɑɑ kpenu wɔkurɑ yiru ɡirɑ nɡe mɛ Isirelibɑn bwese kɛrin ɡeerɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Mɑ u Isirelibɑn ɑluwɑɑsibɑ ɡɑbu ɡɔrɑ bu kɑ Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ kpɑ bu nɑɑ kinɛnu ɡo bu kɑ siɑrɑbun yɑ̃kunu ko. ");
INSERT INTO bba_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Mɔwisi u yɑɑ yɛm mɛn bɔnu suɑ u doke ɡbɛ̃ɑ sɔɔ. Mɑ u sukum mɛ n tie yɛ̃kɑ yɑ̃ku yee ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Mɑ u woodɑn tire te suɑ u tu ɡɑrɑ tɔn ben wuswɑɑɔ. Mɑ bɑ nɛɛ, sɑ ko Yinni Gusunɔ mɛm nɔɔwɑ kpɑ su ko kpuro ye u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Mɑ Mɔwisi u yɛm mɛ suɑ u yɛ̃kɑ tɔn ben wɔllɔ u nɛɛ, yɛm mɛ wee, mɛ mu Yinni Gusunɔn nɔɔ mwɛɛru siremɔ te u bɛɛ kuɑ sɑnɑm mɛ u bɛɛ woodɑ yenibɑ kpuro wɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Mɑ Mɔwisi kɑ Aroni kɑ Nɑdɑbu kɑ Abihu kɑ Isirelibɑn ɡuro ɡurobu wɑtɑ kɑ wɔku te, bɑ ɡuu te yɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Mɑ bɑ Gusunɔ, be Isirelibɑn Yinni wi wɑ. N sɑ̃ɑre nɡe u yɔ̃ turɑru ɡɑrun wɔllɔ te bɑ kuɑ kɑ kpee booɡu ni nu bɑɑlimɔ weenɛ. Nu dɛɛrewɑ nɡe wɔllu te tɑ kun ɡuru wiru mɔ. ");
INSERT INTO bba_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Gusunɔ u ǹ Isirelibɑn ɡuro ɡuro be kɔ̃sɑ ɡɑɑ kue. Bɑ nùn wɑ mɑ bɑ di bɑ nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ yɔɔmɑ ɑ yɔ̃rɑ ɡuuru mini. Kon nun kpee bɛsi wɛ̃ mì sɔɔ nɑ woodɑ kpuro yoruɑ, tɔn be kɑ ben bibun bweseru bɑ n kɑ ye mɛɛrimɔ bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Mɑ Mɔwisi u seewɑ kɑ win bɔ̃ɔ Yosue. Adɑmɑ u sere ɡuu te yɔ, ");
INSERT INTO bba_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","u ɡuro ɡuro be sɔ̃ɔwɑ u nɛɛ, i yɔ̃ro mini, i sun mɑ sere su kɑ wurɑmɑ bɛɛn mi. Wee Aroni kɑ Huri bɑ wɑ̃ɑ kɑ bɛɛ. Bɛɛn ɡoo ù n ɡɑri ɡiri ɡɛɛ mɔ, u nɑ ben mi. ");
INSERT INTO bba_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Yen biru u yɔɔwɑ ɡuu ten wɔllɔ, mɑ ɡuru wii wurorɑ tu wukiri. ");
INSERT INTO bba_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","17","Yerɑ Yinni Gusunɔn yiikon ɡirimɑ yɑ sɔ̃ɔsirɑ mi. Isirelibɑ bɑ ye wɑ, yɑ sɑ̃ɑ nɡe dɔ̃ɔ boko. Mɑ ɡuru wii wuro te, tɑ Sinɑin ɡuu te wukiri sere sɔ̃ɔ nɔɔbɑ tiɑ. Sɔ̃ɔ nɔɔbɑ yiruse Yinni Gusunɔ u Mɔwisi sokɑ sɑɑ ɡuru wii wuro ten min di. ");
INSERT INTO bba_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Yerɑ Mɔwisi u duɑ ɡuru wii ten sɔɔwɔ mɑ u yɔɔwɑ ɡuu ten wɔllɔ. Miyɑ u wɑ̃ɑ sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru. ");
INSERT INTO bba_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ bu kɑ mɑn kɛ̃nu nɑɑwɑ. Ye bɑ wɛ̃ kɑ nuku tiɑ kpuro, ɑ mɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kɛ̃ɛ ni bɑ koo wɛ̃, niyɑ, wurɑ kɑ sii ɡeesu kɑ sii ɡɑndu, ");
INSERT INTO bba_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kɑ ɑnɑ bekunu ni bɑ wɔ̃kuɑ kɑ burɑ, kɑ mɑɑ ɡɑɑdurɑ kɑ ni bɑ swɛ̃rɑsiɑ kɑ sɛ̃ɛsu, kɑ ni bɑ wesɑ kɑ wɛ̃ɛ dɑmɡii kɑ yɑɑ sɑnsun bekɑ, ");
INSERT INTO bba_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","kɑ yɑ̃ɑ ɡɔni yi bɑ swɛ̃rɑsiɑ kɑ sɛ̃ɛsu, kɑ ɡɔni sinumɡii, kɑ dɑ̃ɑ dɑmɡiɑ, ");
INSERT INTO bba_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","kɑ ɡum mɛ bɑ rɑ kɑ fitilɑ sɔ̃re kɑ ɡum mɛ mu turɑre mɔ mɛ bɑ rɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ Gusunɔ u ye ɡɔsɑ nɛnɛm, kɑ turɑre ye bɑ rɑ dɔ̃ɔ doke, ");
INSERT INTO bba_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","kɑ kpee ɡobiɡinu nìn nɔni sɑ̃ɑ bɛrɔ wuru kɑ kpee ɡobiɡinu bwese bwesekɑ kɑ ni bɑ koo doke yɑ̃ku kowo tɔnweron yɑbe tɑrɑkpe sɔɔ kɑ sere mɑɑ win bɔɔ bɑrɑn wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","Yen biru i kɑ mɑn ye kpuro kuu bekuruɡiru kuo nɑ n kɑ wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","I ko tu kowɑ kɑ ten dendi yɑ̃nu kpuro nɡe mɛ kon bɛɛ sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","Bɑ koo kpɑkororu ko kɑ dɑ̃ɑ dɑmɡiɑ. Ten dɛ̃ɛbu bu ko n sɑ̃ɑwɑ ɡɔm soonu yiru kɑ bɔnu. Ten yɑsum mu ko n mɑɑ sɑ̃ɑwɑ ɡɔm soo teeru kɑ bɔnu kpɑ ten ɡunum mu n sɑ̃ɑ ɡɔm soo teeru kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Kpɑ ɑ tu wurɑ pote ten sɔɔwɔ kɑ tɔɔwɔ. Kpɑ ɑ ten ɡoonu nnɛ kpuro nɔɔ bɔkɑ kuɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Kpɑ ɑ wurɑn sumi ko wɑsi nnɛ ɑ doke ten ɡoo ɡookɑn yinnɑ yenu sɔɔ, yiru yɑ n mɛɛrinɛ bee tiɑ, yiru yeni yɑ n mɑɑ mɛɛrinɛ bee tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Yen biru ɑ dɑ̃ɑ pɔɔsi kɑsu yiru ɑ yi wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Kpɑ ɑ yi wɑsi kpɑkoro ten sumi sɔɔ beri berikɑ, yi n sɑ̃ɑ ten nɛnutii. ");
INSERT INTO bba_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Sumi yi sɔɔrɑ dɑ̃ɑ pɔɔsi yi, yi ko n dɑ n wɑ̃ɑ. Bɑ ǹ yi wunɑmɔ min di. ");
INSERT INTO bba_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Yen biru kɑɑ woodɑn kpee bɛsi yi kon nun wɛ̃ doke kpɑkoro te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","Kpɑ ɑ kpɑkoro te wukiritiɑ kuɑ kɑ wurɑ yɑ n kɑ tu sɑkɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","19","Kpɑ ɑ wɔllun kɔ̃sobu yirun weenɑsibu ko kɑ wurɑ ɑ mɑni wukiritiɑ yen ɡoo piiminun wɔllɔ ɡee kɑ ɡee. ");
INSERT INTO bba_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kpɑ yi n kpɑkoro ten wukiritiɑ ye kɑsɑ wukiri mɑm mɑm. Yi ko n wuswɑɑ kisinɛwɑ yi n mɛɛrinɛ. ");
INSERT INTO bba_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Kɑɑ woodɑn kpee bɛsi yi doke kpɑkoro te sɔɔ, ɑ sere ten wukiritiɑ ye doke. ");
INSERT INTO bba_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Yen wɔllɔwɑ ko nɑ n dɑ kɑ nun yinnɛ kɔ̃sobu yiru yen bɑɑ sɔɔ, kpɑ n nun nɛn woodɑbɑ kpuro wɛ̃ Isirelibɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, kɑɑ tɑbulu ko kɑ dɑ̃ɑ dɑmɡiɑ. Yen dɛ̃ɛbu ko n sɑ̃ɑwɑ ɡɔm soonu yiru, yen yɑsum mu ko n mɑɑ sɑ̃ɑ ɡɔm soo teeru, kpɑ yen ɡunum mu n sɑ̃ɑ ɡɔm soo teeru kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Kpɑ ɑ ye kpuro wurɑ pote, kpɑ ɑ mɑɑ yen ɡoo ɡookɑ nɔɔ bɔkɑ kuɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Yen biru kpɑ ɑ dɑ̃ɑ bɛsi piiminu ɡore yen ɡoo ɡookɑ mi, ni nu kɑ nɔm tɑrɑru yɑsum nɛ, ɑ kɑ sikerenɑ, kpɑ ɑ nin tii wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Kpɑ ɑ mɑɑ sumi nnɛ ko kɑ wurɑ ɑ doke tɑbulu yen ɡoo ɡookɑɔ mi yen nɑɑsu ɡire ɡire. ");
INSERT INTO bba_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Mi bɑ dɑ̃ɑ bɛsi piimii ni ɡoren bɔku bɔkukɑ sɔɔrɑ sumi yi, yi ko n wɑ̃ɑ, kpɑ bu dɑ̃ɑ pɔɔsi wɑsi yi sɔɔ, bɑ n dɑ kɑ tɑbulu ye sue. ");
INSERT INTO bba_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Dɑ̃ɑ pɔɔsi yi, yi ko n sɑ̃ɑwɑ dɑ̃ɑ dɑmɡiɑ kpɑ ɑ yi wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Yen biru kɑɑ ɡbɛ̃ɑ ko kɑ nɔri kɑ pɛrɛntibɑ kɑ ɡbɛ̃ɛ yorukunu, ye kpuro yɑ n sɑ̃ɑ wurɑɡiɑ kpɑ bɑ n dɑ kɑ dendi bɑ n yɑ̃ku tɑm wisimɔ. ");
INSERT INTO bba_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Kpɑ ɑ pɛ̃ɛ ye bɑ kɑ mɑn nɑɑwɑ sɔndi tɑbulu yen wɔllɔ. A ku rɑ de pɛ̃ɛ ye, yu biɑrɑ mi. A de yɑ n dɑ n wɑ̃ɑ nɛn wuswɑɑɔ bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","32","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, kɑɑ dɑbu ko kɑ wurɑ ɡeɑ, ɡɑ n kɑ̃ɑsi mɔ nɔɔbɑ tiɑ, ɡen yɛ̃si yɛ̃sikɑɔ itɑ itɑ. Kpɑ ɡen yɔ̃rɑtiɑ kɑ ɡen pɔturɑ kɑ ɡen kɑ̃ɑsi kɑ ɡen burɑ te tɑ kɑ dɑ̃ɑ mɑrum kɑ biibii weenɛ, ye kpuro yɑ n sɑ̃ɑ bɔri tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","A de kɑ̃ɑsi nɔɔbɑ tiɑ yen bɑɑyere yɑ n burɑnu itɑ itɑ mɔ ni nu kɑ biibii weenɛ. ");
INSERT INTO bba_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Kpɑ dɑbu ɡen pɔturɑn tii yɑ n burɑnu nnɛ mɔ ni nu kɑ dɑ̃ɑ mɑrum weenɛ. ");
INSERT INTO bba_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Mi kɑ̃ɑsi yiru yiru yi ɡbinnɛ kɑ pɔturɑ, kɑɑ nin temɔ burɑru koosiwɑ te tɑ kɑ dɑ̃ɑ mɑrum weenɛ. ");
INSERT INTO bba_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Burɑ te, kɑ kɑ̃ɑsi yi, ye kpuro yɑ n sɑ̃ɑ wurɑn bɔri tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","Yen biru kɑɑ fitilɑnu nɔɔbɑ yiru ko, kpɑ ɑ nu sɔndi sɔndi dɑbu ɡen wɔllɔ kɑ ɡen tiin wii kpiirɔ. Kpɑ bɑ n nu sɔ̃re nu n yɑm bururɑsie. ");
INSERT INTO bba_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Bɑku piibu ɡe bɑ ko n dɑ kɑ fitilɑ nin dɔ̃ɔ sɔmɛ kɑ mì sɔɔ nin torom mu ko n dɑ wɔriki, kɑɑ ye kpuro kowɑ kɑ wurɑ ɡeɑ. ");
INSERT INTO bba_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Dɑbu ɡe, kɑ ɡen dendi yɑ̃nu kpuro, wurɑn kilo tɛnɑn sɑkɑwɑ kɑɑ kɑ ye ko. ");
INSERT INTO bba_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Wunɛ Mɔwisi, ɑ de ɑ n sɔmbu te nɔni doke kpɑ ɑ kuu te ko tɑ n sɑ̃ɑ nɡe te nɑ nun sɔ̃ɔsi ɡuuru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ bekunu wɔkuru wesio kɑ wɛ̃ɛ dɑmɡii kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ, kɑ mɑɑ wɛ̃ɛ wunɔmɡii, kpɑ ɑ bekɑ ye burɑru dokeɑ tɑ n sɑ̃ɑ wɔllun kɔ̃sobun weenɑsibu. Kpɑ ɑ kɑ mɑn kuu bekuruɡiru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Bekɑ ye kpuro yɑ ko n nɛwɑ. Yen dɛ̃ɛbu bu ko n sɑ̃ɑwɑ ɡɔm soonu tɛnɑ yiru sɑri. Yen yɑsum mɑɑ ɡɔm soonu nnɛ. ");
INSERT INTO bba_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Bekɑ yen nɔɔbu nɔɔbuwɑ bɑ koo suɑ bu swɛɛnɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Yen biru kpɑ ɑ yen bɑɑyeren ɡoo bɑkɑ teerɔ wɛ̃ri doke kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ, yi bɑ koo rɑ kɑ ye sɔrenɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Wɛ̃ri weerɑɑkuukuubuwɑ kɑɑ doke bekɑ ye bɑ swɛɛnɑn bɑɑyeren ɡoo bɑkɑ teerɔ yi n nɔɔ kisinɛ. ");
INSERT INTO bba_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Yen biru kɑɑ sɔretinu weerɑɑkuru ko kɑ wurɑ bu kɑ bekɑ ye kpuro sɔrenɑ, kpɑ yu ko beku teeru kuu ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","Kpɑ ɑ mɑɑ bekunu wɔkurɑ tiɑ wesi kɑ boo sɑnsu ni bɑ koo kuu bekuruɡii te wukiri. ");
INSERT INTO bba_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Bekɑ ye kpuro yɑ ko n nɛwɑ. Yen dɛ̃ɛbu bu ko n sɑ̃ɑwɑ ɡɔm soonu tɛnɑ. Yen yɑsum mɑɑ ɡɔm soonu nnɛ. ");
INSERT INTO bba_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Bekɑ yen nɔɔbuwɑ bɑ koo ɡbi bu swɛɛnɑ kpɑ bu mɑɑ nɔɔbɑ tiɑ yeni swɛɛnɑ. Kpɑ bu nɔɔbɑ tiɑse ten sukum bue kuu ten wɔllɔ wuswɑɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Kpɑ ɑ wɛ̃ri weerɑɑkuukuubu doke bekɑ ye bɑ swɛɛnɑn bɑɑyeren ɡoo bɑkɑ teerɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Yen biru kɑɑ sɔretinu weerɑɑkuru ko kɑ sii ɡɑndu, kpɑ ɑ nu doke bekɑ yen wɛ̃ri yi sɔɔ, ɑ kɑ ye sɔrenɑ, yu ko beku teeru. ");
INSERT INTO bba_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Bɑ̀ n kɑ tu kuu te wukiri, beku te tɑ kuu te sɑre mi, ɑ de tɑ n sɑ̃ɑre kuu ten biruɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Kuu ten yɑsum ɡiɑ, bekɑ ye yɑ mɑɑ tiɑrɑ, ɑ de yɑ n sɑ̃ɑre beri berikɑ ɡɔm soo teeru. ");
INSERT INTO bba_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Kɑɑ bekunu yiru ko bu kɑ kuu te wukiri, teeru kɑ yɑ̃ɑ kinɛnun ɡɔni, yi bɑ swɛ̃rɑsiɑ, teeru mɑɑ kɑ yɑɑ ɡɔni sinumɡii, te tɑ ko n wɑ̃ɑ kpuron wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","Akɑsiɑn dɑ̃ɑ bɛsiyɑ kɑɑ ɡirɑ ɑ kɑ kuu te ko. ");
INSERT INTO bba_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","17","Dɑ̃ɑ bɛsi yi, yi ko n nɛwɑ. Yin dɛ̃ɛbu bu ko n sɑ̃ɑwɑ ɡɔm soonu wɔkuru kpɑ yin yɑsum mu n sɑ̃ɑ ɡɔm soo teeru kɑ bɔnu. Kpɑ ɑ yin bɑɑyere sɔretinu yiru dokeɑ yi n kɑ sɔrenɛ. ");
INSERT INTO bba_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Kuu ten sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ dɑ̃ɑ bɛsi yɛndɑ kɑɑ ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Kpɑ ɑ yi yɔ̃rɑtii kuɑ weeru kɑ sii ɡeesu ɑ doke yiru yiru, yin tiɑ sɔɔ temɔ, yi n kɑ sɔretii ni nɛni. ");
INSERT INTO bba_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Ten sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ bɛsi yɛndɑ kɑɑ mɑɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Kpɑ ɑ mɑɑ yi yɔ̃rɑtii weeru kuɑ kɑ sii ɡeesu bu doke yiru yiru yin tiɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Ten sɔ̃ɔ duu yeru ɡiɑ dɑ̃ɑ bɛsi nɔɔbɑ tiɑ kɑɑ ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Dɑ̃ɑ bɛsi yiru yiruwɑ kɑɑ doke ten ɡoo ɡɔmkinu yiruɔ biru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Dɑ̃ɑ bɛsi yi, yi ko n mɑninɛwɑ yiru yiru sɑɑ tem di sere kɑ wɔllɔ. Kpɑ ɑ sumi doke yi n kɑ sɔrenɛ wɔllɔ. Mɛsumɑ kɑɑ ɡoo ɡɔmkinu yiru yen dɑ̃ɑ bɛsi yiru yiru ye kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kpɑ yi kpuro yi n sɑ̃ɑ dɑ̃ɑ bɛsi nɔɔbɑ itɑ. Kpɑ ɑ yen bɑɑyere sɔɔ yɔ̃rɑtii doke yiru yiru yi bɑ kuɑ kɑ sii ɡeesu. ");
INSERT INTO bba_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","27","Yen biru kpɑ ɑ ten yɛ̃si itɑɔ ɑkɑsiɑn dɑ̃ɑ nɔɔbu nɔɔbu kɑre. ");
INSERT INTO bba_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Dɑ̃ɑ kɑretiɑ ye yɑ wɑ̃ɑ yɛ̃sɑ bɑɑyeren suunu sɔɔ mi, yen nɔɔ ɡɑ koo yɔ̃rɑwɑ dɑ̃ɑ ɡɔmkinɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Kpɑ ɑ mɑɑ dɑ̃ɑ bɛsi yi kɑ dɑ̃ɑ kɑretii yi wurɑ pote. Kpɑ ɑ mɑɑ wurɑn sumi ko yì sɔɔ bɑ koo dɑ̃ɑ kɑretii yi wɑsi wɑsi. ");
INSERT INTO bba_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","À n yenibɑ kpuro mɛnnɑ ɑ kpɑ, sɑɑ yerɑ kɑɑ den kuu bekuruɡii te ɡirɑ tɑ n sɑ̃ɑ nɡe te nɑ nun sɔ̃ɔsi ɡuu te bɑ mɔ̀ Sinɑin wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","Kpɑ ɑ mɑɑ beku kɑreru ko kɑ wɛ̃ɛ dɑmɡii kɑ wɛ̃ɛ ye bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wɛ̃ɛ wunɔmɡii. Kpɑ ɑ wɔllun kɔ̃sobun weenɑsibu ko beku te sɔɔ, kpɑ yɑ n sɑ̃ɑ burɑru. ");
INSERT INTO bba_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Kɑɑ ɑkɑsiɑn dɑ̃ɑ bɛsi sinumɡii nnɛ ko ɑ wurɑ pote kpɑ ɑ sɔretii wurɑɡii doke yi sɔɔ, yi kɑ beku kɑre te ɡɑbɑ. Kpɑ ɑ dɑ̃ɑ bɛsi yi yɔ̃rɑtii dokeɑ yi bɑ kuɑ kɑ sii ɡeesu. ");
INSERT INTO bba_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","34","Kpɑ ɑ beku kɑre te bwɛ̃ te tɑ ko n dii sɔɔ ɡe ɡɑ dɛɛre ɡem ɡem kɑ ɑdɛrɔ ɡe ɡɑ dɛɛre bɔnu sɑ̃ɑ. À n beku kɑre te bwɛ̃ ɑ kpɑ, ten sɔɔwɔwɑ kɑɑ kɑ kpɑkoro te dɑ ɑ yi tè sɔɔ woodɑn kpee bɛsi yiru ye, yɑ wɑ̃ɑ. Kpɑ ɑ kpɑkoro te wukiritiɑ dokeɑ dii te tɑ dɛɛre ɡem ɡem sɔɔ mi. ");
INSERT INTO bba_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Kɑɑ tɑbulu ye yiwɑ nɔm ɡeu ɡiɑ ɑdɛrɔ ɡe sɔɔ ɑ̀ n duɔ kuu ten mi, kpɑ ɑ dɑbu ɡe yi nɔm dwɑru ɡiɑ, tɑbulu ye kɑ dɑbu ɡe, nu n mɛɛrinɛ. ");
INSERT INTO bba_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","A kuu ten beku kɛnutiru wesio kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wɛ̃ɛ wunɔmɡii kɑ wɛ̃ɛ dɑmɡii, kpɑ ɑ beku te sɔmɑ dokeɑ. ");
INSERT INTO bba_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Kpɑ ɑ ɑkɑsiɑn dɑ̃ɑ bɛsi sinumɡii nɔɔbu wurɑ pote kpɑ ɑ yin bɑɑyere yɔ̃rɑtiɑ kuɑ kɑ sii ɡɑndu. Yen biru kpɑ ɑ sɔretii wurɑɡii doke yin bɑɑyere sɔɔ bu kɑ beku kɛnutii te bwɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, kɑɑ yɑ̃ku yeru ko kɑ ɑkɑsiɑn dɑ̃ɑ. A de ten ɡoonu nnɛ kpuro nu n nɛ, nu n sɑ̃ɑ ɡɔm soonu nɔɔbu nɔɔbu, kpɑ ten ɡunum mu n sɑ̃ɑ ɡɔm soonu itɑ. ");
INSERT INTO bba_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Kpɑ ɑ ten wɔllun ɡoo ɡɔmkinɔ kɑ̃ɑnu doke kpɑ ɑ nu sii ɡɑndu pote. ");
INSERT INTO bba_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Kɑɑ yɑ̃ku yee ten dendi yɑ̃nu kpuro kowɑ kɑ sii ɡɑndu. Niyɑ ɡbɛ̃ɛ ni bɑ koo kɑ torom ɡurɑ, kɑ kɑɑtonu kɑ kɑɑto donnuɡinu, kɑ ɡbɛ̃ɛ nì sɔɔ bɑ koo yɑɑ yɛm doke bu kɑ yɛ̃kɑ, kɑ dɔ̃ɔ ɡurɑtii. ");
INSERT INTO bba_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Kpɑ ɑ kɔkɔsɔ ko kɑ sii ɡɑndu kpɑ ɑ yen ɡoo ɡɔmkinɔ sii ɡɑndun sumi doke. ");
INSERT INTO bba_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Yen biru kpɑ ɑ ye suɑ ɑ doke yɑ̃ku yee ten kɔkɔrɔ kpɑ yen nɔɔ ɡu seemɑ wɔllɔ yɑ̃ku yee ten suunu suunukɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Kpɑ ɑ tu suɑtii yiru kuɑ kɑ ɑkɑsiɑn dɑ̃ɑ pɔɔsi ɑ yi sii ɡɑndu pote. ");
INSERT INTO bba_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Kɑɑ dɑ̃ɑ pɔɔsi yi wɑsi sumi yi sɔɔ bɑ n dɑ kɑ yɑ̃ku yee te sue. ");
INSERT INTO bba_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Kɑɑ yɑ̃ku yee te kowɑ kɑ dɑ̃ɑ bɛsi tɑ n wɔru mɔ, nɡe te nɑ nun sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","Yenibɑ kpuron biru Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ kuu bekuruɡii te kɑrɑ koosio. Yen sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ kpɑ ɑ bekunu kɑre ni bɑ wesɑ kɑ wɛ̃ɛ dɑmɡii. Bɑ̀ n ni kpuro swɛɛnɑ, nu ko ɡɔm soonu wunɔbu (100). ");
INSERT INTO bba_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","Bɑ koo bekɑ ye sɔrewɑ dɑ̃ɑ bɛsi sinumɡii yɛndu sɔɔ kɑ sɔretii kɑ sii dɛki yi bɑ kuɑ kɑ sii ɡeesu. Kpɑ dɑ̃ɑ bɛsi yin yɔ̃rɑtii yi n sɑ̃ɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Nɡe mɛyɑ yɑ ko n mɑɑ sɑ̃ɑ sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ, kpɑ ye yiru ye, yɑ n dɛ̃ɛbu nɛ. ");
INSERT INTO bba_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","Kɑrɑ yen sɔ̃ɔ duu yeru ɡiɑ kɑɑ bekunu kɑre dɑ̃ɑ bɛsi sinumɡii wɔkuru sɔɔ yi bɑ yɔ̃rɑtii kuɑ. Kɑrɑ yen yɑsum mu ko n sɑ̃ɑwɑ ɡɔm soonu weerɑɑkuru. ");
INSERT INTO bba_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Mɛyɑ yen sɔ̃ɔ yɑri yeru ɡiɑ yen yɑsum ko n mɑɑ sɑ̃ɑwɑ ɡɔm soonu weerɑɑkuru. ");
INSERT INTO bba_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","15","Yen suunu sɔɔ kɑɑ kɔnnɔ wĩɑ ɡɑ n sɑ̃ɑ ɡɔm soonu yɛndu. Kpɑ ɑ kɔnnɔ ɡen beri berikɑɔ bekɑ kɑre ɡɔm soonu wɔkurɑ nɔɔbu nɔɔbu dɑ̃ɑ bɛsi sinumɡii itɑ itɑ sɔɔ. Dɑ̃ɑ bɛsi yin bɑɑyere yɑ ko n yɔ̃rɑtiɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","Kɑrɑ yen kɔnnɔn tii sɔɔ, kɑɑ beku kɛnutiru doke, tèn yɑsum ko n sɑ̃ɑ ɡɔm soonu yɛndu. Wɛ̃ɛ dɑmɡiiyɑ kɑɑ kɑ tu ko kpɑ ɑ tu burɑru kuɑ kɑ wɛ̃ɛ wunɔmɡii kɑ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ. Kpɑ ɑ mɑɑ tu ɡɑbɑ kuɑ kɑ dɑ̃ɑ bɛsi sinumɡii nnɛ yi yi yɔ̃rɑtii mɔ. ");
INSERT INTO bba_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Kɑrɑ yen beku sɔretii kɑ yen sii dɛki yi, yì sɔɔ bɑ koo beku ni sɔresi, ye kpuro yɑ ko n sɑ̃ɑwɑ sii ɡeesu, kpɑ yen dɑ̃ɑ bɛsi sinumɡii yin yɔ̃rɑtii yi n sɑ̃ɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Kɑrɑ yen dɛ̃ɛbu bu ko n sɑ̃ɑwɑ ɡɔm soonu wunɔbu (100) kpɑ yen yɑsum mu n mɑɑ sɑ̃ɑ ɡɔm soonu weerɑɑkuru, kpɑ yen ɡunum mu n sɑ̃ɑ ɡɔm soonu nɔɔbu. Bɑ koo yen bekɑ wesiwɑ kɑ wɛ̃ɛ dɑmɡii kpɑ bu sii pɔɔsi yin yɔ̃rɑtii ko kɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Kuu bekuruɡii ten dendi yɑ̃nu kpuro, sii ɡɑndɑ bɑ koo kɑ nu ko. Mɛyɑ kuu te kɑ kɑrɑ yen ɡɑbɑtiɑn kurum kpuro yɑ ko n sɑ̃ɑwɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","Yerɑ Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ de Isirelibɑ bu dɑ̃ɑ ye bɑ mɔ̀ olifin binun ɡum ko mɛ mu ɡeɑ sɑ̃ɑ, bɑ n dɑ kɑ kuu ten fitilɑ sɔ̃re bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Kuu bekuruɡii ten ɑdɛrɔ ɡe sɔɔrɑ Aroni kɑ win bibu bɑ koo dɑ bu fitilɑ ni yi yi, beku kɑre ten biruɔ te tɑ woodɑn kpɑkororu beruɑ. Mɛyɑ fitilɑ ni, nu ko n dɑ n sɔ̃re sɑɑ yokɑn di sere kɑ bururu. Isirelibɑ bɑ koo woodɑ yeni nɛnɛwɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ wunɛn mɔɔ Aroni kɑ win bibu nnɛ ye wunɔ nɛnɛm Isirelibɑn suunu sɔɔn di kpɑ bɑ n sɑ̃ɑ nɛn yɑ̃ku kowobu. Bii berɑ Nɑdɑbu kɑ Abihu kɑ Eleɑsɑɑ kɑ Itɑmɑɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","A de bu wunɛn mɔɔ Aroni wi sɑ̃ɑ yɑ̃nu kuɑ ni nu koo win yiiko kɑ win ɡirimɑ sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Yen sɔ̃, be nɑ yen bwisi wɛ̃, ɑ bu woodɑ wɛ̃ɛyɔ bu kɑ nùn yɑ̃ɑ ni kuɑ ni u koo doke dɔmɑ te bɑ koo nùn tusiɑ tɔmbun wuswɑɑɔ kɑ sɑnɑm mɛ u win sɔmburu mɔ̀. ");
INSERT INTO bba_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Yɑ̃ɑ ni bɑ koo ko wee, bɔɔ bɑrɑ ye u koo doke win tororun wɔllɔ, kɑ yɑbe tɑrɑkpe, kɑ yɑberu kɑ tɑko ye bɑ sɔmɑ kuɑ kɑ dɑwɑni kɑ sere mɑɑ sɛ̃kɑtiɑ. Yenibɑ kpuro yɑ ko n sɑ̃ɑwɑ yɑ̃ɑ ni Aroni kɑ win bibu bɑ ko n dɑ doke bɑ̀ n yɑ̃kurun sɔmburu mɔ̀. ");
INSERT INTO bba_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Bɑ koo yɑ̃ɑ ni kpuro kowɑ kɑ beku ni bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ ni bɑ wunɔm doke, kɑ ni bɑ kuɑ kɑ wɛ̃ɛ dɑmɡii kɑ wurɑn wɛ̃ɛ siiri. ");
INSERT INTO bba_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, kɑɑ yɑbe tɑrɑkpe kowɑ kɑ beku te bɑ kuɑ kɑ wɛ̃ɛ dɑmɡii kpɑ ɑ ɡe burɑru kuɑ kɑ wɛ̃ɛ wunɔmɡii kɑ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wurɑn wɛ̃ɛ siiri. ");
INSERT INTO bba_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Kpɑ ɑ ɡu sɑri kuɑ yi bɑ koo kɑ ɡen senu sɔrenɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Kpɑ ɑ sɛ̃kɑtiɑ ko yɑ n sɑ̃ɑ beku nɔni tee kɑ yɑbe tɑrɑkpe ɡe. Kpɑ yɑ n yinusi ɡe sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","Yen biru ɑ kpee ɡobiɡinu yiru suo nìn nɔni sɑ̃ɑ bɛrɔ wuru, kpɑ ɑ Isirelin bibu wɔkurɑ yiru yen yĩsɑ yore ni sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Teerɔ ben nɔɔbɑ tiɑn yĩsɑ. Teerɔ mɑɑ nɔɔbɑ tiɑ benin yĩsɑ. Kɑɑ ye kpuro yorewɑ nɡe mɛ̀sum bɑ kerɑnɛ. ");
INSERT INTO bba_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Kɑɑ yĩsɑ ye yorewɑ kpee ni sɔɔ, nɡe mɛ bɑ rɑ yore sisɔ. À n ye yoruɑ ɑ kpɑ, kpɑ ɑ kpee ni wurɑ ɡore ɑ kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Kpɑ ɑ nu mɑni tɑrɑkpe ɡen sɑri sɔɔ. Aroni ù n nu doke win senɔ, niyɑ nu koo sɔ̃ɔsi mɑ kɑ Isirelibɑn yĩsinɑ u duɑ nɛn sɑ̃ɑ yerɔ, kpɑ nɛ, Yinni Gusunɔ nɑ n kɑ bu yɑɑye. ");
INSERT INTO bba_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Mi bɑ kpee ni ɡore mu ko n sɑ̃ɑwɑ wurɑ, ");
INSERT INTO bba_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","kpɑ ɑ yɔni wurɑɡii yiru tɑri ɑ yi sɔre wurɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","Kɑɑ bɔɔ bɑrɑ ko ye Aroni u ko n dɑ doke win tororɔ, u kɑ nɛ, Yinni Gusunɔn kĩru bikiɑ. Ye kɑ tɑrɑkpe ɡe, yɑ ko n sɑ̃ɑwɑ beku nɔni tee, kɑ burɑ teeru. ");
INSERT INTO bba_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Bɔɔ bɑrɑ yen ɡoonu nnɛ kpuro nu ko n nɛwɑ, nu n sɑ̃ɑ ɡɔm soonun bɔnu bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Kpɑ ɑ bɔɔ bɑrɑ ye sɔɔ kpee ɡobiɡii bwese bwesekɑ mɑni yu ko sĩɑ nnɛ. Kpee nin nɔni wee. Sĩi ɡbiikɑɑ sɔɔ, swɑ̃ɑru kɑ dɔm buuru, kɑ wuru beku. ");
INSERT INTO bba_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","Yiruse sɔɔ mɑɑ, swɑ̃ɑru kɑ booɡu kɑ sɔ̃ɔ tiro. ");
INSERT INTO bba_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","Itɑse sɔɔ, dɔm buuru kɑ nɔni bwese bwesekɑ kɑ ɡɑɑdurɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","Nnɛse sɔɔ, wuru beku kɑ bɛrɔ wuru, kɑ nɔni bwese bwesekɑ. Kpɑ ɑ ni kpuro wurɑ ɡore ɡore. ");
INSERT INTO bba_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Kpee bwese bwesekɑ wɔkurɑ yiru yen bɑɑtere sɔɔrɑ kɑɑ Isirelin bibun yĩsinu yore tiɑ tiɑ. Kɑɑ nu yorewɑ nɡe mɛ bɑ rɑ yore sisɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","Kɑɑ yɔni wurɑɡii yiru ko bɔɔ bɑrɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kpɑ ɑ tɑɑminu yiru ko kɑ wurɑ, ɑ sɔre bɔɔ bɑrɑ yen soo wɔrikisɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Tɑɑminu yiru ye sɔɔrɑ bɑ koo yɔni yi sɔre sɔre. ");
INSERT INTO bba_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Kpɑ ɑ bɔɔ bɑrɑ yen yɔni yi ɡbinisi tɑrɑkpe ɡen sɑriɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Yen biru kɑɑ mɑɑ tɑɑminu yiru ko kɑ wurɑ, ɑ nu doke bɔɔ bɑrɑ yen soo temkisɔ si su yɑbe tɑrɑkpe ɡe ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Kpɑ ɑ tɑɑminu yiru ko ɑ doke yɑbe tɑrɑkpe ɡen sɑrin nɔɔwɔ wuswɑɑɔ, sɛ̃kɑtiɑ yen wɔllu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Yen biru kɑɑ bɔɔ bɑrɑ yen tɑɑmii ni sɔɔ wɛ̃ɛ ɡɑɑdurɑɡii doke kpɑ ɑ yi ɡbinɛ yɑbe tɑrɑkpe ɡen tɑɑminu sɔɔ. Nɡe mɛyɑ kɑɑ kɑ ye sɔre yɑbe tɑrɑkpe ɡe sɔɔ, kpɑ yu ku kɑ bɑ̃ɑri. ");
INSERT INTO bba_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","Sɑɑ ye Aroni u duɔ kuu bekuruɡii ten mi, u ko n bɔɔ bɑrɑ ye dokewɑ win tororɔ yè sɔɔ bɑ Isirelibɑn bwese kɛri wɔkurɑ yiru yen yĩsɑ yoruɑ, kpɑ nɛ, Yinni Gusunɔ nɑ n kɑ bɛɛ yɑɑye bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Kɑɑ mɑɑ urimu kɑ tumimu doke bɔɔ bɑrɑ ye sɔɔ, kpɑ yɑ n wɑ̃ɑ Aronin tororɔ sɑɑ kpuro ye u duɔ nɛn sɑ̃ɑ yerɔ, kpɑ u kɑ ɡiɑ ye nɑ kĩ Isirelibɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, yɑbe tèn wɔllɔ yɑ̃ku kowo u koo yɑbe tɑrɑkpe ɡe sɔndi, kɑɑ tu kowɑ kɑ beku ɡɑɑdurɑɡiru. ");
INSERT INTO bba_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Kpɑ ɑ ten wĩirɔ sɔmɑ doke ɑ sinum koosiɑ tu ku rɑɑ kɑ ɡɛ̃ɛrɑ. Wĩi ten min diyɑ u koo wiru wɑsi ù n yɑbe te sebumɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Kpɑ ɑ mɑɑ ten temɔ tusɑnu doke nu n kɑ dɑ̃ɑ mɑrum ɡɑm weenɛ ni bɑ kuɑ kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wɛ̃ɛ wunɔmɡii, kɑ sere mɑɑ yɑnɡire piiminu wurɑɡinu ɑ kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Kpɑ ɑ de dɑ̃ɑ mɑrum weenɑsim mɛ kɑ yɑnɡire ni, nu n kpɑsɑ sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Yɑbe terɑ Aroni ko n dɑ n sebuɑ ù n sɔmburu mɔ̀ kuu bekuruɡii te sɔɔ. Mɛ̀n nɔɔ u duɔ, kɑ mɛ̀n nɔɔ u yɑriɔ nɑ kon dɑ n yɑnɡire nin wɔkinu nɔɔmɔwɑ, kpɑ n ku nùn ɡo kuu bekuruɡii te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","Kpɑ ɑ mɑɑ wurɑn bɑtɑni ko ɑ yore ye sɔɔ, wini sɑ̃ɑwɑ Yinni Gusunɔɡii. Kɑɑ ye yorewɑ nɡe mɛ bɑ rɑ yore sisɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Kpɑ ɑ bɑtɑni ye sɔresi Aronin dɑwɑnin wuswɑɑɔ kɑ wɛ̃ɛ ɡɑɑdurɑɡii. ");
INSERT INTO bba_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","U ko n ye dokewɑ bɑɑdommɑ ù n dɔɔ nɛn sɑ̃ɑ yerɔ, kpɑ nɛ, Yinni Gusunɔ n kɑ Isirelibɑn yɑ̃kunu mwɑ bɑɑ bɑ̀ n torɑnu ɡɑnu kuɑ sɑɑ ye bɑ yɑ̃ku ni mɔ̀. ");
INSERT INTO bba_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","Kpɑ ɑ mɑɑ tɑko kɑ dɑwɑni ko kɑ wɛ̃ɛ dɑmɡii, kɑ sɛ̃kɑtiɑ ye bɑ sɔmɑ doke. ");
INSERT INTO bba_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Kɑɑ mɑɑ Aronin bibu tɑkobɑ kuɑ kɑ mɑɑ sɛ̃kɑtii kɑ furɔsu, yɑ n sɑ̃ɑ ben burɑru te tɑ ben ɡirimɑ sɔ̃ɔsimɔ. ");
INSERT INTO bba_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Yen biru kɑɑ Aroni kɑ win bibu yɑ̃ɑ ni sebusiɑ, kpɑ ɑ bu ɡum tɑ̃re wirɔ ɑ kɑ sɔ̃ɔsi mɑ nɑ bu ɡɔsɑ bɑ n sɑ̃ɑ nɛn yɑ̃ku kowobu. ");
INSERT INTO bba_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","A bu sokoto kpirinu kuo kpɑ bu ku kɑ ben tereru wɑn sɔ̃. Kɑɑ ye kpuro kowɑ kɑ wɛ̃ɛ dɑmɡii. ");
INSERT INTO bba_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aroni kɑ win bibu bɑ ko n nu dokewɑ bɑ̀ n dɔɔ kuu bekuruɡii te sɔɔ, ǹ kun mɛ bɑ̀ n susiɔ yɑ̃ku yerɔ bu kɑ ben sɔmburu ko. Yerɑ yɑ koo de nɑ kun bu ɡo nɛn sɑ̃ɑ yerɔ, domi bɑ ǹ wɑ̃ɑ mi tereru. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ Aroni kɑ win bibun bweserun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, wee nɡe mɛ kɑɑ koosinɑ ɑ kɑ sɔ̃ɔsi mɑ nɑ Aroni kɑ win bibu ɡɔsɑ nɑ yi nɛnɛm bu kɑ ko yɑ̃ku kowobu nɛn sɑ̃ɑ yerɔ. A nɑɑ kinɛ kpɛndu suo kɑ yɑ̃ɑ kinɛnu yiru. A ku de yen ɡɑɑ yɑ n ɑlebu mɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Kpɑ ɑ pɛ̃ɛ ko kɑ ɑlikɑmɑn som, ɑ ku seeyɑtiɑ doke, kpɑ ɑ mɑɑ kirɑ wɔ̃ɔrɑnu ko nìn somɔ bɑ ǹ seeyɑtiɑ doke, kɑ kirɑ nìn som bɑ kɑ ɡum burinɑ. ");
INSERT INTO bba_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Kpɑ ɑ nu doke bireru sɔɔ ɑ kɑ dɑ yɑ̃ku yerɔ kɑ nɑɑ kinɛ kpɛn te, kɑ yɑ̃ɑ kinɛnu yiru ye, kpɑ ɑ kɑ ye kpuro yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Kpɑ ɑ de Aroni kɑ win bibu bu nɑ kuu ten kɔnnɔwɔ mi nɛ, Yinni Gusunɔ nɑ rɑ kɑ Isirelibɑ yinnɛ, kpɑ ɑ bu wobure kɑ nim. ");
INSERT INTO bba_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Kpɑ ɑ Aroni nùn win sɑ̃ɑ yɑ̃ɑ ni sebusiɑ. Niyɑ tɑko ye, kɑ yɑbe booɡuɡii te, kɑ yɑbe tɑrɑkpe ɡe, kɑ bɔɔ bɑrɑ ye. Kpɑ ɑ sɛ̃kɑtiɑ ye sɛ̃ke yɑbe tɑrɑkpe ɡen wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Kpɑ ɑ mɑɑ dɑwɑni suɑ ɑ doke win wirɔ, kpɑ ɑ wurɑn bɑtɑni ye suɑ yè sɔɔ bɑ yoruɑ, wini sɑ̃ɑwɑ Yinni Gusunɔɡii, ɑ doke win dɑwɑni yen wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Yen biru kpɑ ɑ mɑɑ ɡum suɑ ɑ tɑ̃re win wirɔ ɑ kɑ sɔ̃ɔsi mɑ nɑ nùn ɡɔsɑ nɑ yi u n sɑ̃ɑ nɛn yɑ̃ku kowo. ");
INSERT INTO bba_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Kpɑ ɑ mɑɑ win bibu soku ɑ bu tɑko be sebusiɑ, ");
INSERT INTO bba_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","ɑ bu ben sɛ̃kɑtii sɛ̃keɑ kpɑ ɑ bu ben furɔsu dokeɑ nɡe mɛ ɑ Aronin tii kuɑ. Sɑɑ dɔmɑ ten diyɑ bɑ koo ko yɑ̃ku kowobu sere kɑ bɑɑdommɑɔ. Yenibɑ kpuron biru, ɑmɛniwɑ kɑɑ de bu kɑ sɔmbu te tore. ");
INSERT INTO bba_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","Nɑɑ kinɛ te ɑ ɡɔsɑ mi, kɑɑ kɑ tu nɑwɑ kuu ten kɔnnɔwɔ, kpɑ Aroni kɑ win bibu bu ben nɔmɑ sɔndi nɑɑ yen wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Kpɑ ɑ ye sɑkɑ nɛn wuswɑɑɔ kuu ten kɔnnɔ mi. ");
INSERT INTO bba_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Kpɑ ɑ yen yɛm dɛkɑ kɑ niki biɑ ɑ tɛɛni yɑ̃ku yee ten kɑ̃ɑnɔ. Mɛ mu tie kpɑ ɑ yɛ̃kɑ ten temɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Kpɑ ɑ yen bɔsɔnun ɡum suɑ kɑ yen worun bɛsi bɑkɑ kɑ yen ɡɑbu swii kɑ yen ɡum sɑnnu, kpɑ ɑ ye kpuro mɛnnɑ ɑ dɔ̃ɔ doke yɑ̃ku yee ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Adɑmɑ nɑɑ kinɛ ten yɑɑ kɑ ten ɡɔnɑ kɑ ten bɔsɔ bisu, ye kpurowɑ kɑɑ dɔ̃ɔ doke bɛɛn sɑnsɑnin biruɔ. Yɑ̃ku te, tɑ ko n sɑ̃ɑwɑ te tɑ koo ben durum wukiri. ");
INSERT INTO bba_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","Yen biru bɑ koo kɑ yɑ̃ɑ kinɛ nin teeru nɑ, kpɑ Aroni kɑ win bibu bu ben nɔmɑ sɔndi ten wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Bɑ̀ n kuɑ mɛ bɑ kpɑ, yerɑ kɑɑ tu sɑkɑ kpɑ ɑ ten yɛm suɑ ɑ yɛ̃kɑ yɑ̃ku yee ten ɡoo ɡookɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Kpɑ ɑ ten yɑɑ bɔɔri bɔɔri ɑ yi kɑ ten wiru sɑnnu, kpɑ ɑ mɑɑ ten bɔsɔnu teɑ kɑ ten kɔ̃ri kpɑ ɑ ye kpuro sɔndi wii te kɑ ye ɑ bɔɔrɑ min wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","À n kuɑ mɛ ɑ kpɑ, kpɑ ɑ ye kpuro dɔ̃ɔ sɔ̃re yɑ̃ku yee ten wɔllɔ. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru tèn nuburɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","Kpɑ ɑ mɑɑ yɑ̃ɑ kinɛru yiruse teni suɑ. Kpɑ Aroni kɑ win bibu bu kpɑm ben nɔmɑ sɔndi ten wirɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Yen biru, kpɑ ɑ tu sɑkɑ ɑ ten yɛm suɑ ɑ tɛɛni Aronin soo nɔm ɡeuɡuuɔ, kɑ win bibun soo nɔm ɡeuɡisɔ, kɑ ben nɔm ɡeun niki bii bɑkɑnɔ, kɑ sere ben nɔm ɡeun nɑɑ niki bii bɑkɑnɔ. Yɛm mɛ mu tie, kpɑ ɑ mu yɛ̃kɑ yɑ̃ku yee ten ɡoo ɡookɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Kpɑ ɑ mɑɑ yɛm mɛ mu wɑ̃ɑ yɑ̃ku yee ten wɔllɔ suɑ ɑ mɛnnɑ kɑ ɡum mɛ bɑ rɑ kpuro tɑ̃re ye Gusunɔ u ɡɔsɑ nɛnɛm kpɑ ɑ mu wisi Aroni kɑ win bibun sɑ̃ɑ yɑ̃ɑ ni bɑ sebuɑn wɔllɔ. Nɡe mɛyɑ Aroni kɑ win bii be, kɑ ben sɑ̃ɑ yɑ̃ɑ ni kpuro, bɑ ko n sɑ̃ɑ nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","Kpɑ ɑ yɑ̃ɑ ten ɡum suɑ kɑ ten siru kɑ ten bɔsɔnun ɡum kɑ ten worun bɛsi bɑkɑ, kɑ ten ɡɑbu swii yiru kɑ yin ɡum sɑnnu, kɑ ten nɔm ɡeun nɔmu. Domi yɑ̃ɑ kinɛ te, tɑ ko n sɑ̃ɑwɑ te bɑ kɑ sɔ̃ɔsi mɑ nɑ Aroni kɑ win bibu ɡɔsɑ nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Kpɑ ɑ mɑɑ pɛ̃ɛ tiɑ suɑ ye bɑ ǹ seeyɑtiɑ doke, kɑ kirɑ wɔ̃ɔrɑ teeru kɑ kirɑ teeru tèn som bɑ kɑ ɡum burinɑ, sɑɑ birerun di te tɑ yii sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kpɑ ɑ ye kpuro Aroni kɑ win bibu nɔmu bɛriɑ kpɑ ɑ ben nɔmɑ suɑ ɑ kɑ sɔ̃ɔsi beri berikɑ nɛ, Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Yen biru kpɑ ɑ ye kpuro mwɑ ben nɔmɑn di ɑ ye sɔndi yɑ̃ku dɔ̃ɔ mwɑɑrɑ ten wɔllɔ kpɑ ɑ dɔ̃ɔ doke kpɑ yɑ n sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te tɑ mɑn nuburu dore. ");
INSERT INTO bba_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Kpɑ ɑ mɑɑ yɑ̃ɑ kinɛ te bɑ kɑ sɔ̃ɔsi mɑ nɑ Aroni kɑ win bibu ɡɔsɑ nɛnɛm min ɡuroɡuroru suɑ ɑ sɔ̃ɔsi beri berikɑ nɛn wuswɑɑɔ. À n kuɑ mɛ ɑ kpɑ, yɑɑ ye, yɑ ko n sɑ̃ɑwɑ wunɛɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","Kpɑ ɑ yɑ̃ɑ kinɛ ten nɔmu suɑ ɑ yiiyɑ wɔllɔ nɛn wuswɑɑɔ. Nɡe mɛyɑ kɑɑ kɑ sɔ̃ɔsi mɑ ɡuroɡuro te kɑ nɔmu ɡe, yɑ sɑ̃ɑwɑ nɛɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Mɛyɑ mɑɑ Isirelibɑ bɑ̀ n siɑrɑbun yɑ̃kunu mɔ̀ bɑ ko n dɑ yɑɑn ɡuroɡuroru kɑ yen nɔm ɡeun nɔmu wunɛ nɛnɛm nɛn sɔ̃ kpɑ bu ye Aroni kɑ win bibun bweseru wɛ̃ kpɑ yɑ n sɑ̃ɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","Aroni ù n mɑɑ ɡu, win bibun bweseru sɔɔrɑ bɑ koo turo wunɑ bu sɑ̃ɑ yɑ̃ɑ ni sebusiɑ bu nùn ɡum tɑ̃re wirɔ dɔmɑ te bɑ koo sɔ̃ɔsi mɑ u sɑ̃ɑ win kɔsire. ");
INSERT INTO bba_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Wi, wi u kuɑ Aronin kɔsire mi, u ko n yɑ̃ɑ ni dokewɑ sere sɔ̃ɔ nɔɔbɑ yiru. Wiyɑ u ko n dɑ du kuu ten mi, mi Yinni Gusunɔ u rɑ kɑ Isirelibɑ yinnɛ kpɑ u sɔmburu ko ɑdɛrɔ ɡe ɡɑ dɛɛre sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","Kɑɑ yɑ̃ɑ kinɛ te bɑ kɑ sɔ̃ɔsi mɑ nɑ Aroni kɑ win bibu ɡɔsɑ nɛnɛm yɑɑ suɑ ɑ yike sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Kuu ten kɔnnɔwɔrɑ Aroni kɑ win bibu bɑ koo yɑɑ ye kɑ pɛ̃ɛ ye yɑ wɑ̃ɑ bireru sɔɔ mi mɛnnɑ bu tem. ");
INSERT INTO bba_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Be tɔnɑwɑ bɑ koo yɑ̃ku dĩɑ ni di, ni bɑ kɑ ben durum wukiri sɑnɑm mɛ bɑ sɔ̃ɔsi mɑ nɑ bu ɡɔsɑ nɛnɛm nɛn sɔ̃. Tɔn tuko ɡoo u ku rɑɑ nu di, domi nu sɑ̃ɑwɑ dĩɑ ni bɑ wunɑ nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Nù n tiɑrɑ sere sisiru bu ku mɑɑ nu di. Bu nu wisio dɔ̃ɔ sɔɔ nu dɔ̃ɔ mwɑɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","A Aroni kɑ win bibu kuo mɑm mɑm nɡe mɛ nɑ nun sɔ̃ɔwɑ. Sɔ̃ɔ nɔɔbɑ yiruwɑ kɑɑ bu yen yɑ̃ku yɑ̃ki kuɑ ɑ kɑ sɔ̃ɔsi mɑ nɑ bu ɡɔsɑ nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","A n dɑ nɑɑ kinɛru ɡo yen tɔ̃ɔ bɑɑtere yɑ̃ku yee ten wɔllɔ, yen yɛm mu kɑ tɔmbun durum wukiri. Yɑ̃ku niyɑ nu koo yɑ̃ku yee te disi wɔkɑ. Yen biru kpɑ ɑ ɡum tɑ̃re ten wɔllɔ ɑ kɑ sɔ̃ɔsi mɑ tɑ wɑ̃ɑ nɛnɛm nɛn sɑ̃ɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Mɛyɑ kɑɑ n dɑ ko sere sɔ̃ɔ nɔɔbɑ yiru ye, yu kɑ yibu, kpɑ yɑ̃ku yee te, tɑ n sɑ̃ɑ nɛnɛm tɑ n dɛɛre. Yen sɔ̃, ye n koo tu ture kpuro, bɑɑ ǹ n tɔnun nɑ, u de u n dɛɛre. ");
INSERT INTO bba_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, wee ye kɑɑ n dɑ ko bɑɑdommɑ. Kɑɑ kɑ yɑ̃ɑ kinɛ kpɛmminu yiru wɔ̃ɔ tiɑɡinu yɑ̃kuru ko tɔ̃ɔ bɑɑtere, ");
INSERT INTO bba_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","teeru bururu, teeru mɑɑ yokɑ. ");
INSERT INTO bba_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","41","Bururu kɑ yokɑn yɑ̃ku nin bɑɑteren wɔllɔwɑ kɑɑ som kilo itɑ ye yɑ kɑ olifin binun ɡum yɑrum ditiri tiɑ kɑ bɔnu burinɛ doke, kɑ mɑɑ tɑm ditiri tiɑ kɑ bɔnu, kpɑ ɑ ye kpuro dɔ̃ɔ doke. Yen nuburɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","Yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii terɑ bɛɛn bibun bweseru bɑ ko n dɑ ko kuu bekuruɡii ten kɔnnɔwɔ nɛn wuswɑɑɔ sere kɑ bɑɑdommɑɔ. Miyɑ bɛɛ Isirelibɑ i ko kɑ mɑn yinnɑ, kpɑ n kɑ nun ɡɑri ko. ");
INSERT INTO bba_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Kpɑ yɑm mi, mu n sɑ̃ɑ nɛnɛm mu n dɛɛre nɛn yiikon sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","Nɛn tiiwɑ kon kuu te dɛɛrɑsiɑ kɑ yɑ̃ku yee te, n yi nɛnɛm kɑ sere mɑɑ Aroni kɑ win bibu bɑ n kɑ sɑ̃ɑ nɛn yɑ̃ku kowobu. ");
INSERT INTO bba_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Kpɑ nɑ n wɑ̃ɑ bɛɛ Isirelibɑn suunu sɔɔ i n mɑn sɑ̃ɑmɔ. ");
INSERT INTO bba_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Kpɑ i n yɛ̃ mɑ nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni nɛ wi nɑ bɛɛ yɑrɑmɑ Eɡibitin di. Kpɑ nɑ n kɑ bɛɛ wɑ̃ɑ. Nɛnɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, kɑɑ kpɑkororu ɡɑru ko tèn wɔllɔ bɑ ko n dɑ turɑre dɔ̃ɔ doke. Kɑɑ tu kowɑ kɑ ɑkɑsiɑn dɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Ten dɛ̃ɛbu kɑ ten yɑsum mu ko n nɛwɑ, mɛ kpuro mu n sɑ̃ɑ ɡɔm sooru tiɑ tiɑ, kpɑ ten ɡunum mu n sɑ̃ɑ ɡɔm soonu yiru. Kpɑ ɑ de ten ɡoo ɡɔmkinu nnɛn dɑ̃ɑ yu nɔɔ yɑri nɡe kɑ̃ɑnu. ");
INSERT INTO bba_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Kpɑ ɑ ten bɑɑmɑ kpuro wurɑ pote sere kɑ ten kɑ̃ɑnɔ. Kpɑ ɑ ten ɡoonu nnɛ nɔɔ bɔkɑ kuɑ kɑ wurɑ ɑ kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Kpɑ ɑ mɑɑ ten ɡoo ɡɔmkinɔ wurɑn sumi doke ten nɔɔ bɔkɑn temɔ, kpɑ bɑ n dɑ dɑ̃ɑ wɑsi yi sɔɔ, bu kɑ tu suɑ. ");
INSERT INTO bba_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Dɑ̃ɑ ye kɑɑ wɑsi sumi yi sɔɔ, yɑ ko n sɑ̃ɑwɑ ɑkɑsiɑn dɑ̃ɑ ye bɑ wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","À n kuɑ mɛ ɑ kpɑ, kpɑ ɑ kpɑkoro te suɑ ɑ yi ɑdɛrɔ ɡe sɔɔ beku kɑre ten deedeeru te tɑ nɛ, Yinni Gusunɔn woodɑn kpɑkororu beruɑ dii sɔɔ ɡe ɡɑ dɛɛre ɡem ɡem sɔɔwɔ. Miyɑ ko nɑ n dɑ kɑ nun yinnɛ. ");
INSERT INTO bba_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","8","Bururu bɑɑtere sɑɑ ye Aroni u fitilɑnu ɡum dokemɔ kɑ yokɑ bɑɑyere sɑɑ ye u nu sɔ̃rɑmɔ, u ko n dɑ turɑre dɔ̃ɔ dokewɑ kpɑkoro ten wɔllɔ. Nɡe mɛyɑ wi kɑ win bibun bweseru bɑ ko n dɑ ko sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Adɑmɑ i ǹ ko turɑre tukɑ dɔ̃ɔ doke kpɑkoro ten wɔllɔ. Mɛyɑ i ǹ mɑɑ yɑ̃ku dɔɔ mwɑɑrɑruɡinu mɔ̀ mi, ǹ kun mɛ i dĩɑnu ɡɑnu sɔndi mi, ǹ kun mɛ i tɑm wisi mi, i kɑ yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Wɔ̃ɔ kɑ wɔ̃ɔwɑ Aroni u ko n dɑ ten kɑ̃ɑ ni sɔɔ yɑ̃ku yɛm tɛɛni mɛ bɑ rɑ kɑ durum wukiri u kɑ tu disi wɔkɑ. Nɡe mɛyɑ wi kɑ win bibun bweseru bɑ ko n dɑ ko sere kɑ bɑɑdommɑɔ, kpɑ tɑ n yii nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","ɑ Isirelibɑ ɡɑrio. Be bɑ wɔ̃ɔ yɛndu turɑn diyɑ kɑɑ ɡɑri kpɑ ɑ de ben bɑɑwure u ɡobi ɡɛɛ wɛ̃ u kɑ win wɑ̃ɑru yɑkiɑ. Kpɑ n de wɑhɑlɑ yu bu suuri sɑɑ ye ɑ bu ɡɑrimɔ mi. ");
INSERT INTO bba_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Wi bɑ ɡɑrɑ, sii ɡeesun bɔri piibuwɑ u koo wɛ̃. Yi kpuro yi ko n nɛwɑ. Gobi yi, yi ko n sɑ̃ɑwɑ nɡe mɛ bɑ rɑ sɑ̃ɑ yerun ɡobi di. ");
INSERT INTO bba_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Be bɑ wɔ̃ɔ yɛndu turɑ kɑ be bɑ kere mɛ, beyɑ bɑ koo ɡobi yi wɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Gee tee terɑ bɑɑwure u koo wɛ̃. Gobiɡii kun wɛ̃ɛmɔ n sɑ̃ɑro kere, u kɑ win wɑ̃ɑru yɑkiɑ. Domi hunde tiɑ be kpuro bɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Gobi yiyɑ kɑɑ n dɑ kɑ kuu bekuruɡii ten sɔmburu ko. Nɡe mɛyɑ kon kɑ yɑɑyɑ mɑ Isirelibɑ bɑ ben wɑ̃ɑru yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","kɑɑ boo ko kɑ ɡen sɔwɑritiɑ, ye kpuro yɑ n sɑ̃ɑ sii ɡɑndu. À n ɡu kuɑ ɑ kpɑ, ɑ ɡu yiiyo yɑ̃ku yeru kɑ kuu bekuruɡii ten bɑɑ sɔɔ kpɑ bu ɡu nim tɑke. ");
INSERT INTO bba_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Nim mɛyɑ Aroni kɑ win bibu bɑ ko n dɑ kɑ ben nɔmɑ kɑ nɑɑsu kpɑkie bu kɑ dɛɛrɑ, ");
INSERT INTO bba_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","bu sere du kuu ten mi, bu kɑ ben sɔmburu ko, ǹ kun mɛ bu sere susi yɑ̃ku yerɔ bu kɑ yɑ̃kuru ko kpɑ bu ku rɑɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ bɛɛn bibun bweseru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","ɑ turɑre bwese bwesekɑ ye yɑ nuburu do suo, miru kilo nɔɔbu, kɑ sinɑmɔmu kilo yiru kɑ bɔnu, kɑ kɑnɛli kilo yiru kɑ bɔnu ");
INSERT INTO bba_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","kɑ kɑsi kilo nɔɔbu, kɑ sere olifin ɡum ditiri nɔɔbɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Ye kpurowɑ kɑɑ de wi u turɑre kobu yɛ̃ u mɛnnɑ u kɑ ɡum ko mɛ bɑ ko n dɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ nɑ ye ɡɔsɑ nɛnɛm. ");
INSERT INTO bba_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Gum mɛyɑ kɑɑ kuu te yɛ̃kɑ, kɑ nɛn woodɑn kpɑkoro te, ");
INSERT INTO bba_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","kɑ tɑbulu ye, kɑ yen dendi yɑ̃nu, kɑ dɑbu ɡe, kɑ ɡen dendi yɑ̃nu, kɑ sere kpɑkoro tèn wɔllɔ bɑ rɑ turɑre dɔ̃ɔ doke, ");
INSERT INTO bba_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","kɑ yɑ̃ku yee tèn mi bɑ ko n dɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu ko, kɑ ten dendi yɑ̃nu, kɑ boo ɡe, kɑ ɡen sɔwɑritiɑ. ");
INSERT INTO bba_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Nɡe mɛyɑ kɑɑ kɑ sɑ̃ɑ yɑ̃ɑ ni kpuro dɛɛrɑsiɑ kpɑ nu n yii nɛn sɔ̃. Ye n koo nu bɛsu kpuro, ɑ de yɑ n dɛɛre. ");
INSERT INTO bba_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Kpɑ ɑ mɑɑ Aroni kɑ win bibu ɡum mɛ tɑ̃re bɑ n kɑ sɑ̃ɑ nɛn yɑ̃ku kowobu. ");
INSERT INTO bba_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Mɛyɑ kɑɑ Isirelibɑ sɔ̃ ɑ nɛɛ, ɡum mɛ, mu ko n sɑ̃ɑwɑ dɛɛrɑm mɛ bɑ ko n dɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ yɑ wɑ̃ɑ nɛnɛm nɛn sɑ̃ɑrun sɔ̃. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ bɛɛ sɔɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Goo u ku rɑɑ mu sɑwɑ. Goo u ku rɑɑ mɑɑ mɛn bweseru ko. I ko nu yiwɑ nɛnɛm nɛn sɑ̃ɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Yen sɔ̃, ɡoo ù n yinɑ u mɛn bweseru kuɑ, ǹ kun mɛ u tɔn diro ɡoo mu tɛɛni, bɑ koo yɛ̃ro wunɑwɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Yerɑ Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ turɑre bwesenu itɑ kɑsuo ye yɑ nuburu do, kɑ mɑɑ turɑre ye bɑ mɔ̀ ɑnsɑm, ye kpuro yɑ n sɑkɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","Wi u turɑren kobu yɛ̃ kpɑ u ye kpuro mɛnnɑ u bɔru doke yu ko turɑre dɛɛrɑ ye bɑ kuɑ nɛnɛm nɛn sɑ̃ɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Kpɑ ɑ yen sukum buuru wunɑ, ɑ dɑ ɑ yi kuu bekuruɡii te sɔɔ, woodɑn kpɑkoro ten wuswɑɑɔ mi ko nɑ n dɑ kɑ nun yinnɛ. Kpɑ i ye yi nɛnɛm nɛn sɑ̃ɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Yen sɔ̃, ɡoo u ku rɑɑ turɑre yen bweseru ko win tiin sɔ̃. I ko ye yiwɑ nɛnɛm nɛn sɑ̃ɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Wi u yinɑ, u yen bweseru kuɑ win tiin sɔ̃, bɑ koo yɛ̃ro wunɑwɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","wee nɑ Bɛsɑlɛli, Urin bii, Hurin debubu ɡɔsɑ Yudɑn bweseru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","Nɑ nùn nɛn Hunde yibie u n kɑ sɔm bwese bwesekɑn bwisi mɔ, kpɑ u n yen ɑsɑnsi kpuro yɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","U koo kpĩ u yen kpunɑɑbɑ yi. U wurɑn sɔmburu yɛ̃, kɑ sii ɡeesu kɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Kɑ nɡe mɛ bɑ rɑ kpee ɡobiɡinu sɔɔ yore ni bɑ koo ɡore, kɑ sere mɑɑ dɑ̃ɑ dɑ̃kubu, ye kpuro ɡesi ye n sɑ̃ɑ burɑrun sɔmburu. ");
INSERT INTO bba_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Mɑ nɑ nùn Oholiɑbu, Ahisɑmɑkin bii wi u sɑ̃ɑ Dɑnun bweseru nɔmu sɔndiɑ u kɑ nùn somi. Yen biru nɑ mɑɑ ɡɑbu bwisi kɑ̃ be bɑ sɔmbu te yɛ̃. Be kpurowɑ bɑ koo mɛnnɑ bu sɔmbu te ko te nɑ nun sɔ̃ɔwɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Terɑ kuu bekuruɡii te, kɑ nɛn woodɑn kpɑkoro te, kɑ ten wukiritiɑ, kɑ sere mɑɑ kuu ten dendi yɑ̃ɑ ni nu tie, ");
INSERT INTO bba_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","kɑ tɑbulu ye, kɑ yen dendi yɑ̃nu, kɑ dɑbu wurɑɡuu ɡe, kɑ ɡen dendi yɑ̃nu, kɑ kpɑkoro tèn wɔllɔ bɑ ko n dɑ turɑre dɔ̃ɔ doke, ");
INSERT INTO bba_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","kɑ yɑ̃ku yee te, kɑ ten dendi yɑ̃nu, kɑ boo ɡe, kɑ ɡen sɔwɑritiɑ, ");
INSERT INTO bba_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","kɑ sere yɑ̃ɑ ni Aroni kɑ win bibu bɑ ko n dɑ sebe bu kɑ yɑ̃kurun sɔmburu ko, ");
INSERT INTO bba_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","kɑ ɡum mɛ bɑ ko n dɑ ɡɑ̃ɑnu yɛ̃ke bu kɑ sɔ̃ɔsi mɑ yɑ wɑ̃ɑ nɛnɛm nɛn sɑ̃ɑrun sɔ̃, kɑ sere turɑre nubu duroruɡiɑ ye. Ye kpurowɑ bɑ koo ko nɡe mɛ nɑ nun sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, i ko tɔ̃ɔ wɛ̃rɑruɡirun woodɑ mɛm nɔɔwɑwɑ mɑm mɑm. Domi tɑ ko n sɑ̃ɑwɑ nɛn ɑrukɑwɑnin yĩreru ye nɑ bɔkuɑ kɑ bɛɛ sere kɑ bɑɑdommɑɔ. Yĩre terɑ tɑ koo sɔ̃ɔsi mɑ nɛnɑ nɑ bɛɛ ɡɔsɑ nɑ yi nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","I n dɑ wɛ̃re tɔ̃ɔ wɛ̃rɑruɡii te sɔɔ. I ku tu ɡɑrisi nɡe sɑnɑm dirum. Wi u yinɑ mɑ u sɔmburu kuɑ te sɔɔ, bɑ koo yɛ̃ro wunɑwɑ bɛɛn suunu sɔɔn di bu ɡo. ");
INSERT INTO bba_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Yen sɔ̃, ɑlusumɑ tiɑ sɔɔ, sɔ̃ɔ nɔɔbɑ tiɑ i ko n dɑ sɔmburu ko, ɑdɑmɑ nɔɔbɑ yiruse te, tɑ ko n sɑ̃ɑwɑ tɔ̃ɔ wɛ̃rɑruɡiru te nɑ yi nɛnɛm nɛn sɔ̃. Bɛɛn wi u sɔmburu kuɑ tɔ̃ɔ te sɔɔ, bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","A de bɛɛ Isirelibɑ i n tɔ̃ɔ wɛ̃rɑruɡii ten woodɑ mɛm nɔɔwɑmmɛ, sere kɑ bɛɛn bibun bweserɔ, domi ɑrukɑwɑni ye, yɑ ko n wɑ̃ɑwɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Tɔ̃ɔ te, tɑ sɑ̃ɑwɑ yĩreru te tɑ ko n wɑ̃ɑ nɛ kɑ bɛɛn suunu sɔɔ. Domi sɔ̃ɔ nɔɔbɑ tiɑ sɔɔrɑ nɑ wɔllu kɑ tem tɑkɑ kuɑ nɑ kpɑ. Nɔɔbɑ yiruse mɑ nɑ sɔmburu deri nɑ wɛ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Ye Yinni Gusunɔ u kɑ Mɔwisi ɡɑri yi kuɑ ɡuu te bɑ mɔ̀ Sinɑiɔ u kpɑ, yerɑ u nùn kpee bɛsi yiru wɛ̃ yì sɔɔ win tii u woodɑbɑ yoruɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sɑnɑm mɛ tɔn be, bɑ wɑ Mɔwisi u tɛɛmɔ u ǹ sɑrɑmɛ sɑɑ ɡuu ten wɔllun di, bɑ dɑ bɑ mɛnnɑ Aronin mi, bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ, ɑ seewo ɑ sun yinni kuɑ wi u ko n sun swɑɑ ɡbiiye. Domi Mɔwisi wi u sun yɑrɑmɑ Eɡibitin tem di, sɑ ǹ yɛ̃ ye n nùn deemɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Yerɑ Aroni u bu sɔ̃ɔwɑ u nɛɛ, i bɛɛn kurɔbun swɑɑ tonku wurɑɡinu potirimɑ kɑ bɛɛn bibuɡinu i kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Mɑ be kpuro bɑ ben swɑɑ tonku wurɑɡinu potirɑ bɑ kɑ Aroni nɑɑwɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","U nu mwɑ u yɑniɑ mɑ u kuurɑ kuɑ ye yɑ kɑ nɑɑ buu weenɛ, u wurɑ ye wisi mi, mɑ yɑ kuɑ bwɑ̃ɑroku. Mɑ bɑ nɛɛ, bɛsɛn yinni wee, wi u sun yɑrɑmɑ sɑɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Ye Aroni u ye wɑ, yerɑ u yɑ̃ku yeru ɡirɑ bwɑ̃ɑroku ɡen wuswɑɑɔ. Mɑ u kpɑrɑ u nɛɛ, siɑ sɑ ko Yinni Gusunɔ tɔ̃ɔ bɑkɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Yen sisiru, bɑ seewɑ buru buru yellu mɑ bɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ kɑ siɑrɑbun yɑ̃kunu. Tɔn be, bɑ sinɑ bɑ di bɑ nɔrɑ, mɑ bɑ seewɑ bɑ kom bɛrɛtɛkɛ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Sɑɑ yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ sɑro fuuku domi wunɛn tɔn be ɑ yɑrɑmɑ Eɡibitin di mi, wee bɑ disi duurɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Bɑ swɑɑ ye deri kɔ ye nɑ nɛɛ bu swĩi. Wee bɑ tii wurɑn bwɑ̃ɑroku kuɑ ɡe ɡɑ kɑ nɑɑ buu weenɛ. Mɑ bɑ yiirɑ bɑ ɡu yɑ̃kuru koosi. Bɑ nɛɛ, ɡeyɑ ɡɑ ben yinni wi u bu yɑrɑmɑ sɑɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Mɑ u kpɑm nɛɛ, nɑ tɔn be wɑ, ben swɑɑ tɑu, bɑ ǹ kĩ bu wiru kpĩ. ");
INSERT INTO bba_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Tɛ̃ nɛn mɔru yɑ seewɑ. A de n bu kɑm koosiɑ. Adɑmɑ wunɛ, kon de wunɛn tɔmbu bu ko bwese bɑkɑru. ");
INSERT INTO bba_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Mɔwisi u Gusunɔ win Yinni suuru kɑnɑ u nɛɛ, Yinni, mbɑn sɔ̃nɑ ɑ kɑ wunɛn tɔmbu mɔru mɔ̀ be ɑ yɑrɑmɑ Eɡibitin di kɑ wunɛn dɑm bɑkɑm. ");
INSERT INTO bba_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Mbɑn sɔ̃nɑ kɑɑ de Eɡibitiɡibu bu ɡere bu nɛɛ, kɔ̃sɑ ɑ kĩ ɑ wunɛn tɔmbu kuɑ. Yen sɔ̃nɑ ɑ kɑ bu yɑrɑmɑ kpɑ ɑ bu ɡo ɡuunun berɑ ɡiɑ, ɑ bu kpeerɑsiɑ bɑ kun mɑɑ wɑ̃ɑ hɑnduniɑɔ. A wunɛn mɔru ye suresio, ɑ ku mɑɑ kɔ̃sɑ ye ko, ye ɑ kĩ ɑ bu kuɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","A wunɛn bwɑ̃ɑbu Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu yɑɑyo be ɑ nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri ɑ nɛɛ, kɑɑ de ben bibun bweseru tu dɑbiɑ nɡe wɔllun kperi, kpɑ ɑ bu tem mɛ kpuro wɛ̃ mɛ̀n ɡɑri ɑ kɑ bu kuɑ, bɑ n kɑ mu mɔ kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Mɑ Yinni Gusunɔ u kɔ̃sɑ ye deri ye u rɑɑ nɛɛ u koo win tɔmbu kuɑ mi. ");
INSERT INTO bba_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Sɑɑ yerɑ Mɔwisi u sɑrɑmɑ ɡuu ten wɔllun di u woodɑn kpee bɛsi yiru ye nɛni yèn beri yiru yiru kpuro bɑ yoruɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Kpee bɛsi yi, yi sɑ̃ɑwɑ yi Gusunɔn tii u kuɑ. Win tiiwɑ u mɑɑ yoruɑ yi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Ye bɑ sɑrɑm wee, Yosue u tɔmbun wurenu nuɑ nɡe mɛ bɑ ɡbisimɔ. U Mɔwisi sɔ̃ɔwɑ u nɛɛ, tɑbun wurenu wɑ̃ɑ sɑnsɑniɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Mɔwisi u nɛɛ, n ǹ be bɑ nɑsɑrɑ suɑn wurenu mi. N ǹ mɑɑ mɔ be bɑ dɛsiru mwɛɛrɑɡinu. Be bɑ womusu mɔ̀n wurenɑ nɑ nɔɔmɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Ye Mɔwisi u sɑnsɑni ye turuku kuɑ, u nɑɑ buu wurɑɡuu ɡe wɑ kɑ tɔn be bɑ yɑɑmɔ, mɑ u mɔru bɛsirɑ u kpee bɛsi yi surɑ u kɔsukɑ ɡuu ten nuurɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Mɑ u nɑɑ buu ɡe suɑ u dɔ̃ɔ mɛni. Mɑ u ɡe muniɑ muku muku u wisi nim sɔɔ. Mɑ u derɑ bɑ nim mɛ nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Mɑ u Aroni bikiɑ u nɛɛ, mbɑ tɔn be, bɑ nun kuɑ ɑ kɑ bu durum bɑkɑ yen bweseru koosiɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aroni u nùn wisɑ u nɛɛ, ɑ ku de wunɛn mɔru yu kpɛ̃ɑ. A yɛ̃ mɑ tɔn be, bɑ rɑ n bɔ kɔ̃sɑn kobu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Bɑ mɑn sɔ̃ɔwɑ bɑ nɛɛ, n bu yinni kuo wi u ko n bu swɑɑ ɡbiiye, domi wunɛ wi ɑ bu yɑrɑmɑ Eɡibitin tem di, bɑ ǹ yɛ̃ ye n nun deemɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Mɑ nɑ bu sɔ̃ɔwɑ nɑ nɛɛ, ben wi u wurɑn ɡɑ̃ɑnu mɔ u nu tɑmɑ. Ye bɑ kɑ nɑ, mɑ nɑ nu kpɛ̃ɛ dɔ̃ɔ sɔɔ. Yerɑ nɑɑ buu wurɑɡuu ɡe, ɡɑ yɑrimɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Mɔwisi u wɑ mɑ Aroni u kpɑnɑ u tɔn be nɔni doke, mɑ u derɑ bɑ mɔ̀ ye bɑ kĩ. Yerɑ n derɑ ben yibɛrɛbɑ bɑ bu yɑɑ kɑsikimɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Sɑnɑm mɛyɑ u yɔ̃rɑ sɑnsɑni yen duu yerɔ u nɛɛ, bɑɑwure wi u kɑ Yinni Gusunɔ yɔ̃, u nɑ nɛn berɑ ɡiɑ. Mɑ Lefibɑ kpuro bɑ mɛnnɑ win mi. ");
INSERT INTO bba_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Mɑ u nɛɛ, ɑmɛniwɑ Yinni Gusunɔ u ɡeruɑ. Bɛɛn bɑɑwure u win tɑkobi suo u n nɛni, kpɑ u n sirenɛ sɑnsɑni ye sɔɔ duu yee teerun di sere ten tensim mi. Kpɑ u win dusi kɑ win beruse kɑ win kpɑɑsi ɡo. ");
INSERT INTO bba_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Mɑ Lefi be, bɑ kuɑ nɡe mɛ Mɔwisi u bu yiire. Be bɑ ɡu dɔmɑ te, ben suunu sɔɔ, bɑ turɑ tɔnu nɔrɔbun subɑ itɑn sɑkɑ (3000). ");
INSERT INTO bba_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Yerɑ Mɔwisi u nɛɛ, ɡisɔrɑ i bɛɛn tii Yinni Gusunɔ wɛ̃ mɑm mɑm, ye bɛɛn bɑɑwure u kɑ win bii tɔn durɔ kɑ win dusi seesi. Yen sɔ̃, u bɛɛ domɑru kuɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Yen sisiru u tɔn be sɔ̃ɔwɑ u nɛɛ, wee, i durum bɑkɑ kuɑ. Yen sɔ̃, kon yɔ ɡuu ten mi, n Yinni Gusunɔ suuru kɑnɑ bɛɛn durum yen sɑɑbu. ");
INSERT INTO bba_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Yerɑ u ɡɔsirɑ u dɑ Yinni Gusunɔn mi, u nɛɛ, kuku, tɔn be, bɑ durum bɑkɑ kuɑ. Bɑ tii bwɑ̃ɑroku kuɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Nɑ nun kɑnɑmɔ ɑ bu suuru kuo. À kun mɑɑ suuru mɔ̀, ɑ nɛn yĩsiru wunɔ tire te sɔɔn di, tèn mi ɑ wunɛn tɔmbun yĩsɑ yoruɑ. ");
INSERT INTO bba_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Yinni Gusunɔ u Mɔwisi wisɑ u nɛɛ, wi u mɑn torɑri, yɛ̃ron yĩsirɑ kon wunɑ nɛn tireru sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Yen sɔ̃, ɑ doo ɑ tɔn be kpɑrɑ i dɑ sere yɑm mi nɑ nun sɔ̃ɔwɑ. Wee nɛn ɡɔrɑdo u ko n nun ɡbiiye mi. Adɑmɑ sɑɑ yɑ sisi yè sɔɔ kon tɔn be nɔmɑ doke n bu sɛɛyɑsiɑ ben durum sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Yen biru u tɔn be bɑrɑnu kpɛ̃ɛ yèn sɔ̃ bɑ derɑ Aroni u bu nɑɑ buu ɡe kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, i seewo i doonɑ minin di, wunɛ kɑ tɔn be ɑ yɑrɑmɑ Eɡibitin di, kpɑ i dɑ tem mi, mɛ̀n nɔɔ mwɛɛru nɑ kuɑ kɑ bɔ̃ri nɑ nɛɛ, kon mu Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu kɑ ben bibun bweseru wɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Kon nɛn ɡɔrɑdo ɡoo ɡɔri u n nun ɡbiiye kpɑ n nun Kɑnɑnibɑ kɑ Amɔrebɑ kɑ Hɛtibɑ, kɑ Feresibɑ kɑ Hefibɑ kɑ Yebusibɑ ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","I doo tem mɛ sɔɔ. Tim kɑ bom yibɑ mi. Adɑmɑ nɑ ǹ kɑ bɛɛ dɔɔ. Kpɑ n ku rɑ bɛɛ kɑm koosiɑ swɑɑɔ, domi bɛɛn swɑɑ tɑu. ");
INSERT INTO bba_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Ye tɔn be, bɑ lɑbɑɑri kɔ̃sɑ ye nuɑ, ben wɑsi dwiiyɑ. Bɑ ǹ mɑɑ ben burɑ yɑ̃nu ɡɑnu doke nuku sɑnkirɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ben swɑɑ tɑu. Nɑ̀ n kɑ bu sĩimɔ nɔni kpɑki teeru sɔɔ mɑm, kon bu kɑm koosiɑ. Bu ben burɑ yɑ̃nu potirio tɛ̃, kpɑ n wɑ ye kon bu kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Mɑ bɑ ǹ mɑɑ ben burɑ yɑ̃ɑ ni doke sɑɑ mìn di bɑ doonɑ Horɛbun ɡuu ten di. ");
INSERT INTO bba_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Mi Isirelibɑ bɑ ben sɑnsɑni ɡirɑ kpuro, Mɔwisi u rɑ kɑ kuu bekuruɡii te dewɑ u ɡirɑ mi n kɑ sɑnsɑni ye dɛsire. U tu sokɑ Yinni Gusunɔn kuru. Be bɑ kĩ bu Yinni Gusunɔ ɡɑ̃ɑnu bikiɑ berɑ bɑ rɑ yɑri sɑnsɑnin di bu dɑ kuu ten mi. ");
INSERT INTO bba_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Mɔwisi ù n yɑriɔ u dɔɔ kuu ten mi, tɔn be kpuro bɑ rɑ sewɑ bu yɔ̃rɑ ben kunun kɔnnɔwɔ bɑ n Mɔwisi mɛɛrɑ sere u kɑ du kuu te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Ù n duɑ mi, sɑɑ yerɑ ɡuru wii wuro te, tɑ rɑ sɑrɑmɛ tu yɔ̃rɑ kuu ten kɔnnɔwɔ kpɑ Yinni Gusunɔ u kɑ nùn ɡɑri ko. ");
INSERT INTO bba_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tɔn be kpurowɑ bɑ rɑ ɡuru wii wuro te wɑ, tɑ yɔ̃ kuu ten kɔnnɔwɔ. Kpɑ ben bɑɑwure u yiirɑ win kurun kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Yinni Gusunɔ u rɑ kɑ Mɔwisi ɡɑri kowɑ nɔni kɑ nɔni nɡe mɛ tɔnu u rɑ kɑ win bɔrɔ ɡɑri ko. Yen biru Mɔwisi u rɑ ɡɔsirɑmɛ u nɑ sɑnsɑniɔ. Adɑmɑ win bɔ̃ɔ ɑluwɑɑsi Yosue, Nunin bii, u ku rɑ yɑri kuu ten min di. ");
INSERT INTO bba_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Mɔwisi u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, wee, ɑ nɛɛ, n kɑ tɔn be doo tem mɛ sɔɔ. Mɛyɑ ɑ mɑɑ nɛɛ, ɑ mɑn yɛ̃ sɑ̃ɑ sɑ̃ɑ. Kɑɑ n kɑ mɑn nɔnu ɡeu mɛɛrɑ. Adɑmɑ ɑ ǹ mɑn sɔ̃ɔwɑ wi u koo mɑn yɔ̃siri. ");
INSERT INTO bba_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ǹ n mɛn nɑ, tɛ̃, ɑ mɑn wunɛn himbɑ sɔ̃ɔsio kpɑ n nun ɡiɑ, kpɑ n kpɑm wunɛn durom wɑ. A yɑɑyo mɑ tɔn be, bɑ sɑ̃ɑwɑ wunɛn tɔn be ɑ ɡɔsɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mɑ Yinni Gusunɔ u nɛɛ, nɛn tii kon kɑ nun dɑ kpɑ n nun nɑsɑrɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Mɔwisi u wisɑ u nɛɛ, ɑ̀ kun kɑ sun dɔɔ wunɛn tii, ɑ ku de su doonɑ minin di. ");
INSERT INTO bba_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Amɔnɑ bɑ koo kɑ tubu mɑ sɑ wunɛn kĩi ɡeeru wɑ, nɛ kɑ wunɛn tɔmbu, mɑ n kun mɔ ɑ kɑ sun dɑ. À n kɑ sun dɑ, sɑɑ yerɑ sɑ ko n sɑ̃ɑ nɛnɛm hɑnduniɑn tɔn be bɑ tie sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, kon ko nɡe mɛ ɑ mɑn bikiɑ. Domi nɑ nun yɛ̃ sɑ̃ɑ sɑ̃ɑ, ɑ mɑɑ nɛn kĩi ɡeeru wɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Mɔwisi u nɛɛ, ɑ mɑn wunɛn yiikon ɡirimɑ sɔ̃ɔsio. ");
INSERT INTO bba_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Yinni Gusunɔ u wisɑ u nɛɛ, kon nɑ n sɑrɑ wunɛn wuswɑɑɔ kɑ nɛn ɡirimɑ kpuro, kpɑ n nun nɛn yĩsiru sɔ̃, nɛ, Yinni Gusunɔ. Be nɑ kĩ n durom kuɑ, beyɑ nɑ rɑ durom kue. Be nɑ mɑɑ kĩ n wɔnwɔndu kuɑ, kpɑ n bu wɔnwɔndu kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Adɑmɑ nɑ ǹ derimɔ ɑ nɛn wuswɑɑ wɑ, domi ɡoo sɑri wi u koo nɛn wuswɑɑ wɑ kpɑ u n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Yen sɔ̃, ɑyeru ɡɑru wee nɛn bɔkuɔ kpee bɑɑ sɔɔ, mi kɑɑ kpĩ ɑ n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Sɑnɑm mɛ nɑ sɑrɔ kɑ nɛn yiikon ɡirimɑ, kon nun nɛn nɔmɑ wukiri kpee bɑɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Yen biru kon nɛn nɔmɑ wunɑ kpɑ ɑ nɛn biru wɑ, ɑdɑmɑ ɑ ǹ nɛn wuswɑɑ wɑsi. ");
INSERT INTO bba_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ kpee bɛsi yiru mɛnɔ ɑ dɑ̃ku nɡe yiɔnɔ. Kon kpɑm ɡɑri yi yore mi, yi yi rɑɑ wɑ̃ɑ kpee bɛsi yi sɔɔ, yi ɑ kɔsukɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","A sɔɔru koowo siɑ bururu yellu, ɑ yɔɔmɑ Sinɑin ɡuuru mi, kpɑ ɑ yɔ̃rɑ nɛn wuswɑɑɔ ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","A ku de ɡoo u kɑ nun yɔɔmɑ mi. A ku rɑ mɑɑ de n ɡoo wɑ ɡuu ten ɡɑm ɡum. Mɛyɑ ɑ ku mɑɑ de kɛtɛbɑ kɑ yɑ̃ɑnu, yen ɡɑɑ yu yɑkɑsu di ɡuu ten turuku. ");
INSERT INTO bba_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Mɑ Mɔwisi u kpee bɛsi yiru mɛnɑ u dɑ̃kɑ nɡe yiɔnɔ. U seewɑ buru buru yellu u yɔɔwɑ Sinɑin ɡuurɔ u kpee bɛsi yiru ye nɛni nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Yerɑ Yinni Gusunɔ u sɑrɑmɑ ɡuru wii wuroru sɔɔ u yɔ̃rɑ win bɔkuɔ. Mɑ u win tiin yĩsiru ɡeruɑ u nɛɛ, nɛnɑ nɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Mɑ u sɑrɑ Mɔwisin wuswɑɑɔ u nɔɔɡiru suɑ u nɛɛ, nɛnɑ Yinni Gusunɔ durom kɑ wɔnwɔnduɡii. Nɑ rɑ sɑku n sere mɔru ko. Nɛn tɔn ɡeeru kɑ nɛn bɔrɔkiniru tɑ kpɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Nɑ rɑ tɔmbu nɛn kĩru sɔ̃ɔsi sere kɑ bɑɑdommɑɔ. Nɑ rɑ tɔn be bɑ kɔ̃sɑ kuɑ bu ben durum suuru kue, ɑdɑmɑ nɑ ku rɑ tɑɑrɛɡii ɡɑrisi dɛɛro. Nɑ rɑ bɑɑbɑbɑn durum mɔɔru mwɛ ben bibun mi sere kɑ ben sikɑdominun bibɔ. ");
INSERT INTO bba_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Yerɑ Mɔwisi u yiirɑ fuuku u nùn sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Mɑ u nɛɛ, Yinni, ɑ̀ n kɑ mɑn nɔnu ɡeu mɛɛrɑ, nɑ nun kɑnɑmɔ, ɑ de ɑ kɑ sun dɑ. Wee, tɔn be, swɑɑ tɑobɑ. Adɑmɑ ɑ sun bɛsɛn dɑɑ kɔ̃sɑ kɑ bɛsɛn durum suuru kuo kpɑ ɑ sun ko wunɛɡibu. ");
INSERT INTO bba_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Mɑ Yinni Gusunɔ u nɛɛ, wee, nɑ kɑ bɛɛ ɑrukɑwɑni bɔkumɔ. Kon sɔm mɑɑmɑɑkiɡiɑ ko wunɛn tɔn be kpuron wuswɑɑɔ, yèn bweseru ɡoo kun koore tem ɡɑm. Tɔn be kpuro bèn suunu sɔɔ i wɑ̃ɑ, bɑ koo nɛ, Yinni Gusunɔn sɔmburu wɑ. Domi ɡɑ̃ɑ nɑnumɡinɑ kon bɛɛ kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Woodɑ ye nɑ bɛɛ wɛ̃ɛmɔ mi ɡisɔ, i ye mɛm nɔɔwɔ. Wee, kon Amɔrebɑ kɑ Kɑnɑnibɑ kɑ Hɛtibɑ kɑ Feresibɑ kɑ Hefibɑ kɑ Yebusibɑ ɡirɑ bɛɛn wuswɑɑn di. ");
INSERT INTO bba_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Wunɛ, Mɔwisi, ɑ n tii sɛ, kpɑ ɑ ku rɑ kɑ tem min tɔmbu ɑrukɑwɑni bɔke, mi i ko i du kpɑ bu ku rɑɑ ko bɛɛn yinɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Adɑmɑ i ko ben yɑ̃ku yenu surɑ kpɑ i ben bũu wi bɑ mɔ̀ Asitɑɑten sɑ̃ɑ yerun dɑ̃nu wukiri, kpɑ i win bwɑ̃ɑrokunu kɔsuku. ");
INSERT INTO bba_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","I ku rɑ bũu ɡoo sɑ̃ domi nɛn yĩsirɑ nisinuɡii. Nɑ ku rɑ wure bu mɑɑ yinni ɡoo sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","A n tii sɛ kpɑ ɑ ku rɑ kɑ tem min tɔmbu ɑrukɑwɑni bɔke. Domi bɑ̀ n ben bũnu ɡɑsirimɔ bɑ sɑ̃ɑmɔ bɑ yɑ̃kunu mɔ̀, bɑ koo bɛɛ soku i kɑ bu ko. Kpɑ ben yɑ̃ku yɑɑ yu bɛɛ binɛ ko i di. ");
INSERT INTO bba_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Sɔrɔkudo i ko bɛɛn bii tɔn durɔbu kurɔbu suɑ ben bii wɔndiɑbɑ sɔɔ, kpɑ kurɔ be, bu de bɛɛn bii be, bu nɛn sɑ̃ɑru deri bu tɔn ben bũnu sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","I ku rɑ sisu suɑ i kɑ tii bwɑ̃ɑroku kuɑ i sɑ̃. ");
INSERT INTO bba_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","I n dɑ pɛ̃ɛ ye bɑ ǹ seeyɑtiɑ doken tɔ̃ɔ bɑkɑru ko sɑɑ ye nɑ yi, suru wi bɑ mɔ̀ Abibu sɔɔ. Kpɑ i pɛ̃ɛ ye di sɔ̃ɔ nɔɔbɑ yiru nɡe mɛ nɑ bɛɛ yiire. Domi suru wi sɔɔrɑ i yɑrimɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","Bii ɡbiikoo tɔn durɔ bɑɑwure u ko n sɑ̃ɑwɑ nɛɡii, mɛyɑ mɑɑ yɑɑ sɑbenu kpuron bii ɡbiikii dwɑnu, ǹ n kɛtɛn nɑ, ǹ n mɑɑ yɑ̃ɑrun nɑ, ǹ kun mɛ boo. ");
INSERT INTO bba_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Ǹ n kɛtɛkun nɑ, i kɑ ɡen buu ɡbiikuu yɑ̃ɑ buu kɔsinɔ kpɑ ɡu ko yɑ̃ku yɑ̃ɑru. Ì kun mɑɑ kue mɛ, i ɡen wĩi sumɑ buo i ɡo. I ko bii ɡbiikoo tɔn durɔ bɑɑwure yɑkiɑwɑ kɑ ɡobi. I ku de ɡoo u nɑ nɛn wuswɑɑɔ u kun kɛ̃ru nɛni. ");
INSERT INTO bba_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","Alusumɑ sɔɔ, sɔ̃ɔ nɔɔbɑ tiɑ i ko sɔmburu ko, kpɑ i wɛ̃rɑ sɔ̃ɔ nɔɔbɑ yiruse, bɑɑ ǹ n duurubun sɑɑn nɑ, ǹ kun mɛ ɡɛ̃ɛbun sɑɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","I n dɑ ɡɛ̃ɛbun tɔ̃ɔ bɑkɑru ko sɑnɑm mɛ i ɑlikɑmɑ yè yɑ ɡbiɑ yɑ ye ɡɛ̃ɛbu toruɑ, kpɑ i Kunun tɔ̃ɔ bɑkɑru ko sɑnɑm mɛ i bɛɛn dɑ̃ɑ binu sɔrimɔ, wɔ̃ɔ ɡɑ̀ n kpeeyɔ. ");
INSERT INTO bba_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Wɔ̃ɔ tiɑ sɔɔ, nɔn itɑwɑ tɔn durɔ bɑɑwure u koo nɑ nɛ Gusunɔ, Isirelibɑ Yinnin sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","I ku bɛrum ko. Kon bwese ni ɡirɑ bɛɛn wuswɑɑn di, kpɑ n bɛɛn tem yɑsiɑsiɑ. Goo kun kɑ̃kɔ u mu binɛ ko sɑnɑm mɛ i mɑn tɔ̃ɔ bɑkɑru diiyɑmmɛ nɔn itɑ ye, wɔ̃ɔ kɑ wɔ̃ɔ. ");
INSERT INTO bba_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","I ku mɑn yɑ̃ku yɑɑn yɛm wɛ̃ kɑ pɛ̃ɛ ye bɑ seeyɑtiɑ doke sɑnnu. Ì n Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru mɔ̀, i ku de ten yɑɑ yu tiɑrɑ sere sisiru bururu. ");
INSERT INTO bba_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","Wɔ̃ɔ kɑ wɔ̃ɔ i n dɑ kɑ bɛɛn ɡbeɑn dĩɑ ɡbiikinu nɛ, nɛ, Yinni Gusunɔn sɑ̃ɑ yerɔ. I ku rɑ boo buu yike kɑ ɡen mɛron bom. ");
INSERT INTO bba_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ ɡɑri yi yoruo domi yiyɑ nɛn ɑrukɑwɑnin wiru ye nɑ kɑ bɛɛ bɔkumɔ, wunɛ kɑ Isirelibɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Mɔwisi u wɑ̃ɑ mi kɑ Yinni Gusunɔ sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru. U ǹ dĩɑnu di, u ǹ mɑɑ nim nɔrɑ. Mɑ Yinni Gusunɔ u ɑrukɑwɑni yen ɡɑri yoruɑ kpee bɛsi yi sɔɔ, yiyɑ woodɑ wɔku te. ");
INSERT INTO bba_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Ye Mɔwisi u kɑ Yinni Gusunɔ ɡɑri kuɑ u kpɑ, u sɑrɑmɑ Sinɑin ɡuurun di u woodɑn kpee bɛsi yiru ye nɛni, win wuswɑɑ yɑ bɑllimɔ. Adɑmɑ win tii u ǹ yɛ̃ mɛ. ");
INSERT INTO bba_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aroni kɑ Isirelibɑ kpuro bɑ nùn mɛɛrɑ bɑ wɑ wee, win wuswɑɑ bɑllimɔ mɑ bɑ bɛrum bɑrɑ bu nùn susi. ");
INSERT INTO bba_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Adɑmɑ u bu sokɑ, mɑ Aroni kɑ Isirelibɑn ɡuro ɡurobu bɑ nɑ win mi, u kɑ bu ɡɑri kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Yen biru Isirelibɑ kpuro bɑ nùn susi, mɑ u bu woodɑ ye kpuro sɑɑriɑ ye Yinni Gusunɔ u nùn wɛ̃ Sinɑin ɡuuru wɔllu mi. ");
INSERT INTO bba_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Ye u kɑ bu ɡɑri kuɑ u kpɑ, u win wuswɑɑ sɔnditiɑ wukiri. ");
INSERT INTO bba_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Ù n dɑ Yinni Gusunɔn kuu ten mi u kɑ nùn ɡɑri ko, u rɑ sɔnditiɑ ye wunɛwɑ sere ù n kpɑm yɑrimɑ. Ù n yɑrimɑ min di, yerɑ u rɑ Isirelibɑ sɔ̃ ye Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Kpɑ bu win wuswɑɑ wɑ yɑ bɑllimɔ. Yen biruwɑ u rɑ ye sɔnditiɑ wukiri sere ù n kpɑm duɔ u kɑ Yinni Gusunɔ ɡɑri ko. ");
INSERT INTO bba_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Mɔwisi u Isirelibɑ kpuro mɛnnɑ u bu sɔ̃ɔwɑ u nɛɛ, wee ye Yinni Gusunɔ u sun sɔ̃ɔwɑ su ko. ");
INSERT INTO bba_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Alusumɑ tiɑ sɔɔ, sɔ̃ɔ nɔɔbɑ tiɑ sɑ ko n dɑ bɛsɛn sɔmɑ kpuro ko. Adɑmɑ sɔ̃ɔ nɔɔbɑ yiruse yɑ ko n sɑ̃ɑwɑ tɔ̃ɔ wɛ̃rɑruɡiru te sɑ ko Yinni Gusunɔ deriɑ. Yen sɔ̃, bɛsɛn wi u sɔmburu kuɑ te sɔɔ, bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Bɑɑ dɔ̃ɔ i ku rɑ sɔ̃re tɔ̃ɔ te sɔɔ, bɛɛn yɛnusɔ. ");
INSERT INTO bba_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Mɔwisi u kpɑm Isirelibɑ sɔ̃ɔwɑ u nɛɛ, wee ye Yinni Gusunɔ u bɛɛ yiire. ");
INSERT INTO bba_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","U nɛɛ, i kɑ nùn kɛ̃nu nɑɑwɑ kɑ nuku tiɑ bɛɛn ye i mɔ sɔɔ. Kɛ̃ɛ nìn bweseru i ko i kɑ nɑ wee. Niyɑ wurɑ kɑ sii ɡeesu kɑ sii ɡɑndu, ");
INSERT INTO bba_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","kɑ bekɑ ye bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ, kɑ beku wunɔmɡinu kɑ mɑɑ ni bɑ wesɑ kɑ wɛ̃ɛ dɑmɡii kɑ sere ye bɑ kuɑ kɑ boo sɑnsu, ");
INSERT INTO bba_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","kɑ yɑ̃ɑ kinɛnun ɡɔni yi bɑ sɛ̃ɛsu doke kɑ ɡɔni dɑmɡii kɑ ɑkɑsiɑn dɑ̃ɑ, ");
INSERT INTO bba_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","kɑ ɡum mɛ bɑ koo kɑ fitilɑnu sɔ̃rɑ, kɑ ɡɑ̃ɑ nubu duroruɡinu ni bɑ ko n dɑ doke ɡum sɔɔ mɛ bɑ rɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ Gusunɔ u ye ɡɔsɑ nɛnɛm, kɑ turɑre sɔɔ ye bɑ rɑ dɔ̃ɔ doke ");
INSERT INTO bba_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","kɑ kpee ɡobiɡinu nìn nɔni sɑ̃ɑ bɛrɔ wuru ni bɑ koo doke yɑbe tɑrɑkpe ɡe sɔɔ, kɑ ni bɑ koo doke bɔɔ bɑrɑ yen wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","Bɛɛn bɑɑwure wi u mɑɑ sɔmbu ten bwisi mɔ, u nɑ u tu ko nɡe mɛ Yinni Gusunɔ u ɡeruɑ, ");
INSERT INTO bba_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","ye u nɛɛ, su kuu bekuruɡiru koowo mi sɑ ko n dɑ nùn sɑ̃, kpɑ su ten wukiritii ko yi bɑ kuɑ kɑ boo sɑnsu kɑ yɑɑ ɡɔni, kɑ sɔretii ni, kɑ dɑ̃ɑ bɛsi yi, kɑ dɑ̃ɑ kɑretii yi, kɑ ten dɑ̃ɑ bɛsi sinumɡii kɑ yin yɔ̃rɑtii, ");
INSERT INTO bba_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","kɑ woodɑn kpɑkororu kɑ ten wukiritiɑ kɑ ten dɑ̃ɑ pɔɔsi yi bɑ ko n dɑ kɑ tu sue, kɑ beku kɑre te tɑ ko n tu beruɑ dii te tɑ dɛɛre ɡem ɡem sɔɔ, ");
INSERT INTO bba_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","kɑ tɑbulu ye, kɑ yen dendi yɑ̃nu kpuro, kɑ sere dɑ̃ɑ pɔɔsi yi bɑ ko n dɑ kɑ ye sue, kɑ pɛ̃ɛ ye bɑ koo yi yen wɔllɔ, ");
INSERT INTO bba_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","kɑ dɑbu ɡe, kɑ ɡen dendi yɑ̃nu kpuro, kɑ ɡen fitilɑnu, kɑ nin ɡum, ");
INSERT INTO bba_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","kɑ kpɑkoro tèn wɔllɔ bɑ ko n dɑ turɑre dɔ̃ɔ doke, kɑ sere ten dɑ̃ɑ pɔɔsi yi bɑ ko n dɑ kɑ tu sue, kɑ ɡum mɛ bɑ ko n dɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ Gusunɔ u ye ɡɔsɑ nɛnɛm kɑ turɑre ye bɑ ko n dɑ dɔ̃ɔ doke, kɑ beku kɛnutii te bɑ koo doke kuu ten kɔnnɔwɔ, ");
INSERT INTO bba_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","kɑ yɑ̃ku yeru kɑ ten kɔkɔsɔ ye bɑ koo ko kɑ sii ɡɑndu, kɑ ten dɑ̃ɑ pɔɔsi yi bɑ ko n dɑ kɑ tu sue kɑ ten dendi yɑ̃nu, kɑ boo ɡe, kɑ ɡen sɔwɑritiɑ, ");
INSERT INTO bba_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","kɑ kuu ten kɑrɑn bekunu, kɑ yen sii pɔɔsi kɑ yin yɔ̃rɑtii kɑ sere mɑɑ kɑrɑ yen kɔnnɔn beku kɛnutiru ");
INSERT INTO bba_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","kɑ kuu ten ɡɑbɑtiɑn kurumbɑ kɑ ten wɛ̃ɛ, ");
INSERT INTO bba_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","kɑ bekɑ ye bɑ koo kɑ kuu ten dendi yɑ̃nu kpuro bɔke, kɑ sere sɑ̃ɑ yɑ̃ɑ ni Aroni kɑ win bibu bɑ ko n dɑ doke bu kɑ sɔmburu ko kuu ten mi. ");
INSERT INTO bba_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ye Mɔwisi u ɡɑri yi ɡeruɑ u kpɑ mɑ Isirelibɑ kpuro bɑ doonɑ win min di. ");
INSERT INTO bba_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Yen biru, be bɑ ɡɑri yi ɡɔ̃ru doke, bɑ kɑ kɛ̃ɛ ni nɑ kɑ nuku tiɑ bu kɑ Yinni Gusunɔn kuu te ko, kɑ ten dendi yɑ̃nu kpuro kɑ yɑ̃ɑ ni yɑ̃ku kowobu bɑ ko n dɑ doke bu kɑ sɔmburu ko kuu ten mi. ");
INSERT INTO bba_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Tɔn durɔbu kɑ tɔn kurɔbu be bɑ ɡɔ̃ru doke bu kɑ Yinni Gusunɔ kɛ̃ru nɑɑwɑ, bɑ kɑ swɑɑ tonkunu kɑ sumi kɑ tɑɑminu kɑ sɛɛnin bɑtɑnibɑ, ye yɑ sɑ̃ɑ wurɑn ɡɑ̃ɑnu kpuro ɡesi, ben bɑɑwure u kɑ nɑ mɑ u yi kɑ kɛ̃ɛ wɛ̃ɛbun wororu. ");
INSERT INTO bba_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Be bɑ mɑɑ bekɑ mɔ ye bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ, kɑ beku wunɔmɡinu kɑ mɑɑ ni bɑ wesɑ kɑ wɛ̃ɛ dɑmɡii kɑ sere mɑɑ ye bɑ kuɑ kɑ boo sɑnsu, kɑ yɑ̃ɑ kinɛnun ɡɔni yi bɑ sɛ̃ɛsu doke, kɑ ɡɔni dɑmɡii, ye kpurowɑ bɑ kɑ nɑ Yinni Gusunɔn kuu ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Be bɑ mɑɑ sii ɡeesu mɔ, kɑ sii ɡɑndu, bɑ kɑ nɑ bɑ yi kɑ kɛ̃ɛ wɛ̃ɛbun wororu. Be bɑ mɑɑ ɑkɑsiɑn dɑ̃ɑ mɔ bɑ kɑ nɑ sɔmbu ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Tɔn kurɔ be bɑ mɑɑ wɛ̃ɛ tɑribu yɛ̃, bɑ wɛ̃ɛ bwese bwesekɑ tɑrɑ, ɡɑɑdurɑɡii, kɑ booɡuɡii kɑ wunɔmɡii, kɑ wɛ̃ɛ dɑmɡii, bɑ kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Mɑ ben ɡɑbu be bɑ sɔmbu ten yɛ̃ru kɑ ten kĩru mɔ, bɑ boo sɑnsun wɛ̃ɛ tɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Be bɑ mɑɑ sɑ̃ɑ wiruɡibu bɑ kɑ kpee ɡobiɡinu nìn nɔni sɑ̃ɑ bɛrɔ wuru nɑ bu kɑ yɑbe tɑrɑkpe ɡe kɑ bɔɔ bɑrɑ ye burɑru koosi. ");
INSERT INTO bba_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Mɑ ɡɑbɑ kɑ ɡum nɑ mɛ bɑ koo kɑ fitilɑnu sɔ̃rɑ, kɑ ɡɑ̃ɑ nubu duroruɡinu ni bɑ ko n dɑ doke ɡum sɔɔ mɛ bɑ rɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ Gusunɔ u ye ɡɔsɑ nɛnɛm, kɑ turɑre sɔɔ ye bɑ rɑ dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Isirelibɑ sɔɔ, be bɑ tii wɛ̃ bu kɑ somi sɔmbu te sɔɔ, te Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ mi, bɑ kɑ ben kɛ̃ɛ ni nɑwɑ kɑ nuku tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Mɔwisi u kpɑm Isirelibɑ sɔ̃ɔwɑ u nɛɛ, wee, Yinni Gusunɔ u Bɛsɑlɛli Urin bii ɡɔsɑ wi u sɑ̃ɑ Hurin debubu Yudɑn bweseru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Mɑ u nùn win Hunde yibiɑ u bwisi kɑ lɑɑkɑri kɑ yɛ̃ru wɑ u kɑ sɔm bwese bwesekɑ ko. ");
INSERT INTO bba_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","U koo kpĩ u sɔmbu ten bɑɑyeren kpunɑɑ yi. Ye u koo ko, yerɑ wurɑ kɑ sii ɡeesu kɑ sii ɡɑndun sɔmburu, ");
INSERT INTO bba_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","kɑ kpee ɡobiɡinun dɑ̃kubu kɑ nin ɡorebu kɑ dɑ̃nun dɑ̃kubu, sɑ̃ɑ yee ten burɑ yɑ̃nu bɑɑniren sɔmburu ɡesi. ");
INSERT INTO bba_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Yen biru Gusunɔ u mɑɑ bu bwisi kɑ̃, wi kɑ Oholiɑbu wi u sɑ̃ɑ Ahisɑmɑkin bii Dɑnun bweseru sɔɔ, bu kɑ ɡɑbu sɔmbu te sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Berɑ u yɛ̃ru wɛ̃ bu kɑ sɑ̃ɑ yee ten burɑ yɑ̃nu ko kpɑ bu bekɑ ye kpuro burɑru kuɑ. U bu yɛ̃ɛ te wɛ̃wɑ sɑ̃ɑ yee ten sɔmɑ bɑɑyere kpuron sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Bɛsɑlɛli kɑ Oholiɑbu kɑ tɔn be Yinni Gusunɔ u bwisi kɑ yɛ̃ru kɑ lɑɑkɑri wɛ̃ bu kɑ kuu ten sɔmburu kpuro ko, bɑ koo tu kowɑ nɡe mɛ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Mɑ Mɔwisi u Bɛsɑlɛli kɑ Oholiɑbu sokusiɑ kɑ sere be Yinni Gusunɔ u mɑɑ sɔmbu ten bwisi kɑ yɛ̃ru kɑ̃ mɑ bɑ tii wɛ̃ kɑ nuku tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Mɑ bɑ kɛ̃ɛ ni mwɛɛrɑ Mɔwisin min di, ni Isirelibɑ bɑ wɛ̃ Yinni Gusunɔn kuu ten sɔ̃. Adɑmɑ bururu bɑɑtere bɑ rɑ n mɑɑ kɑ kɛ̃ɛ ni nɑɑmɔwɑ Mɔwisin mi kɑ kĩru. ");
INSERT INTO bba_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Mɑ tɔn be bɑ sɔmbu te mɔ̀ mi, ben bɑɑwure u ɡinɑ win sɔmburu deri, ");
INSERT INTO bba_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","mɑ bɑ nɑ Mɔwisin mi, bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ, tɔmbɑ kɑ kɛ̃nu nɑɑmɔ n kere mɛ̀n bukɑtɑ sɑ mɔ su kɑ sɔmbu te ko te Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Yerɑ Mɔwisi u derɑ bɑ kpɑrɑ bɑ nɛɛ, ɡoo u ku mɑɑ kɑ kɛ̃nu nɑ kuu ten sɔ̃. Mɛsumɑ u kuɑ u kɑ kɛ̃ɛ ni yɔ̃rɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Domi ni bɑ wɛ̃ kɔ nu koo turi nu tiɑrɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Tɔn be bɑ sɔmbu ten yɛ̃ru mɔ mi, bɑ kuu te kuɑ kɑ bekɑ wɔku te bɑ wesɑ kɑ wɛ̃ɛ dɑmɡii kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ, kɑ wɛ̃ɛ wunɔmɡii. Mɑ bɑ wɔllun kɔ̃sobun weenɑsibu kuɑ yɑ kuɑ burɑru bekɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Beku nin teerun dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu tɛnɑ yiru sɑri. Ten yɑsum mɑɑ ɡɔm soonu nnɛ. ");
INSERT INTO bba_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Yen biru bɑ bekɑ yen nɔɔbu suɑ bɑ swɛɛnɑ. Nɡe mɛyɑ bɑ mɑɑ kuɑ kɑ nɔɔbu ye yɑ tie. ");
INSERT INTO bba_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Mɑ bɑ yen bɑɑyeren ɡoo bɑkɑ teerɔ wɛ̃ri doke kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ, yi bɑ koo rɑ kɑ ye sɔrenɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Wɛ̃ri weerɑɑkuukuubuwɑ bɑ doke bekɑ ye bɑ swɛɛnɑn bɑɑyeren ɡoo bɑkɑ teerɔ yi n nɔɔ kisinɛ. ");
INSERT INTO bba_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Yen biru bɑ sɔretinu weerɑɑkuru kuɑ kɑ wurɑ bɑ kɑ bekɑ ye kpuro sɔrenɑ mɑ yɑ kuɑ beku teeru kuu ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Bɑ mɑɑ bekunu wɔkurɑ tiɑ wesɑ kɑ boo sɑnsu bu kɑ kuu bekuruɡii te wukiri. ");
INSERT INTO bba_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Beku nin bɑɑteren dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu tɛnɑ, ten yɑsum ɡɔm soonu nnɛ. ");
INSERT INTO bba_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Mɑ bɑ bekɑ yen nɔɔbu suɑ bɑ swɛɛnɑ. Mɑ bɑ mɑɑ nɔɔbɑ tiɑ ye yɑ tie swɛɛnɑ nɛnɛm. ");
INSERT INTO bba_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Mɑ bɑ wɛ̃ri weerɑɑkuukuubu doke bekɑ ye bɑ swɛɛnɑn bɑɑyeren ɡoo bɑkɑ teerɔ. ");
INSERT INTO bba_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Mɑ bɑ sɔretii kuɑ weerɑɑkuru kɑ sii ɡɑndu bu kɑ bekɑ ye kpuro sɔrenɑ, kpɑ bekunu wɔkurɑ tiɑ ye, yu ko beku teeru. ");
INSERT INTO bba_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Mɑ bɑ yɑ̃ɑ kinɛnun ɡɔni swɛ̃rɑsiɑ bɑ swɛɛnɑ bu kɑ kuu te wukiri. Mɑ bɑ mɑɑ yɑɑ ɡɔni sinumɡii ɡɛɛ swɛɛnɑ yi bɑ koo sɔndi ye kpuron wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Yen biru bɑ ɑkɑsiɑn dɑ̃ɑ bɛsi kɑsu yi bɑ koo ɡirɑ yi kɑ ko kuu ten dɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dɑ̃ɑ bɛsi yin dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu wɔkuru, yin yɑsum mɑɑ ɡɔm soo teeru kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Mɑ bɑ yi sɔretii dokeɑ yiru yiru yi biru kisinɛ. ");
INSERT INTO bba_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Dɑ̃ɑ bɛsi yɛndɑ bɑ kuɑ bu kɑ ɡirɑ kuu ten sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Mɑ bɑ yen bɑɑyere yɔ̃rɑtii yiru kuɑ kɑ sii ɡeesu. Mɑ bɑ yi doke mi sɔretii yi, yi wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Mɑ bɑ mɑɑ dɑ̃ɑ bɛsi yɛndu kuɑ bu kɑ ɡirɑ ten sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Mɑ bɑ yen bɑɑyere yɔ̃rɑtii yiru dokeɑ yi bɑ kuɑ kɑ sii ɡeesu. ");
INSERT INTO bba_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Dɑ̃ɑ bɛsi nɔɔbɑ tiɑ bɑ kuɑ bu kɑ ɡirɑ ten biruɔ sɔ̃ɔ duu yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Bɑ mɑɑ dɑ̃ɑ bɛsi yiru kuɑ bu kɑ doke tiɑ tiɑ ten ɡoo ɡɔmkinɔ biru ɡiɑ, ");
INSERT INTO bba_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","yi n kɑ yiɔnɔ mɑninɛ sɑɑ tem di sere kɑ wɔllɔ mɑ bɑ yi sumi wɑsi wɔllɔ. Mɛsumɑ bɑ ɡoo ɡɔmkinu yiru ye kpuro kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Nɡe mɛyɑ bɑ dɑ̃ɑ bɛsi nɔɔbɑ itɑ kuɑ bu kɑ ɡirɑ kuu ten biru ɡiɑ, yin bɑɑyere kɑ yen yɔ̃rɑtii yiru yi bɑ kuɑ kɑ sii ɡeesu. Mɑ yi kuɑ yɔ̃rɑtii wɔkurɑ nɔɔbu kɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","32","Yen biru bɑ ten yɛ̃si itɑɔ ɑkɑsiɑn dɑ̃ɑ nɔɔbu nɔɔbu kɑre. Mɑ bɑ sɔ̃ɔ yɑri yeruɡiɑ deri. ");
INSERT INTO bba_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Dɑ̃ɑ kɑretiɑ ye yɑ wɑ̃ɑ yɛ̃sɑ bɑɑyeren suunu sɔɔ mi, yen nɔɔ ɡɑ yɔ̃rɑ dɑ̃ɑ ɡɔmkinɔ. ");
INSERT INTO bba_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Mɑ bɑ dɑ̃ɑ bɛsi yi kɑ dɑ̃ɑ kɑretii yi wurɑ pote. Mɑ bɑ wurɑn sumi kuɑ yì sɔɔ bɑ koo dɑ̃ɑ kɑretii yi wɑsi wɑsi. ");
INSERT INTO bba_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Mɑ bɑ beku kɑreru kuɑ kɑ wɛ̃ɛ dɑmɡii kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ, kɑ wɛ̃ɛ wunɔmɡii. Mɑ bɑ wɔllun kɔ̃sobun weenɑsibu kuɑ beku te sɔɔ, yɑ kuɑ ten burɑru. ");
INSERT INTO bba_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Yen biru bɑ dɑ̃ɑ bɛsi sinumɡii nnɛ kuɑ bɑ wurɑ pote, mɑ bɑ sɔretii wurɑɡii doke yi sɔɔ yi kɑ beku kɑre te ɡɑbɑ. Mɑ bɑ dɑ̃ɑ bɛsi yi yɔ̃rɑtii dokeɑ yi bɑ kuɑ kɑ sii ɡeesu. ");
INSERT INTO bba_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Mɑ bɑ kuu ten beku kɛnutiru wesɑ kɑ wɛ̃ɛ dɑmɡii kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ, kɑ wɛ̃ɛ wunɔmɡii mɑ bɑ beku te sɔmɑ dokeɑ. ");
INSERT INTO bba_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Bɑ ɑkɑsiɑn dɑ̃ɑ bɛsi sinumɡii nɔɔbu kuɑ bu kɑ beku kɛnutii te bwɛ̃, kɑ sɔretii yi yi koo tu ɡɑbɑ, mɑ bɑ dɑ̃ɑ bɛsi yi furɔsu kɑ sii dɛki kuɑ bɑ ye kpuro wurɑ pote. Mɑ bɑ yin bɑɑyere yɔ̃rɑtiɑ kuɑ kɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bɛsɑlɛli u Yinni Gusunɔn woodɑn kpɑkoro te kuɑ kɑ ɑkɑsiɑn dɑ̃ɑ. Ten dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu yiru kɑ bɔnu. Ten yɑsum kɑ ten ɡunum mu nɛwɑ, ye kpuro ɡɔm soo teeru kɑ bɔnu bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Mɑ u tu wurɑ pote ten sɔɔwɔ kɑ tɔɔwɔ. Mɑ u ten ɡoonu nnɛ ye, nɔɔ bɔkɑ kuɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Mɑ u wurɑn sumi kuɑ wɑsi nnɛ u doke ten ɡoo ɡookɑn yinnɑ yenu sɔɔ, yiru yɑ mɛɛrinɛ bee tiɑ, yiru yeni yɑ mɑɑ mɛɛrinɛ bee tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Mɑ u dɑ̃ɑ pɔɔsi kuɑ yiru u yi wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Mɑ u yi wɑsi kpɑkoro ten sumi yi sɔɔ beri berikɑ. Yiyɑ bɑ ko n dɑ kɑ tu sue. ");
INSERT INTO bba_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Yen biru u kpɑkoro te wukiritiɑ kuɑ kɑ wurɑ. Wukiritiɑ yen dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu yiru kɑ bɔnu, yen yɑsum mɑɑ ɡɔm soo teeru kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","8","Mɑ u wɔllun kɔ̃sobun weenɑsibu yiru kuɑ kɑ wurɑ u mɑni wukiritiɑ yen ɡoo piiminun wɔllɔ ɡee kɑ ɡee. ");
INSERT INTO bba_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Mɑ yi kpɑkoro ten wukiritiɑ ye kɑsɑ wukiri mɑm mɑm. Yi wuswɑɑ kisinɛwɑ yi mɛɛrinɛ. ");
INSERT INTO bba_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","U tɑbulu ye kuɑ kɑ ɑkɑsiɑn dɑ̃ɑ. Yen dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu yiru, yen yɑsum mɑɑ ɡɔm soo teeru. Mɑ yen ɡunum mɑɑ sɑ̃ɑ ɡɔm soo teeru kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","U ye kpuro wurɑ pote mɑ u ye nɔɔ bɔkɑ kuɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Mɑ u dɑ̃ɑ bɛsi piiminu ɡore yen ɡoo ɡookɑ mi, ni nu kɑ nɔm tɑrɑrun yɑsum nɛ u kɑ sikerenɑ mɑ u mɑɑ nin tii wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Mɑ u sumi nnɛ kuɑ kɑ wurɑ u doke yen ɡoo ɡookɑɔ mi yen nɑɑsu ɡire ɡire. ");
INSERT INTO bba_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Sumi yi, yi wɑ̃ɑ mi bɑ dɑ̃ɑ bɛsi piimii ni ɡoren bɔku bɔkukɑɔ. Yi sɔɔrɑ bɑ koo dɑ̃ɑ pɔɔsi wɑsi bu kɑ tɑbulu ye suɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Mɑ u dɑ̃ɑ pɔɔsi yiru kuɑ u wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Yen biru u tɑbulu yen dendi yɑ̃nu kuɑ. Niyɑ pɛrɛntibɑ kɑ nɔri kɑ ɡbɛ̃ɑ kɑ ɡbɛ̃ɛ yorukunu nì sɔɔ bɑ ko n dɑ tɑm doke bu kɑ yɑ̃kunu ko. U ye kpuro kuɑwɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Mɑ bɑ dɑbu ɡe sekɑ kɑ wurɑ. Gen yɔ̃rɑtiɑ kɑ ɡen pɔturɑ kɑ ɡen kɑ̃ɑsi kɑ ɡen burɑ te tɑ kɑ dɑ̃ɑ mɑrum kɑ biibii weenɛ, ye kpuro yɑ sɑ̃ɑwɑ bɔri tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Kɑ̃ɑsi nɔɔbɑ tiɑ ɡɑ mɔ. Gen yɛ̃si yɛ̃sikɑɔ kɑ̃ɑsi itɑ itɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Gen kɑ̃ɑsɑ bɑɑyere, burɑnu itɑwɑ yɑ mɔ. Nu kɑ dɑ̃ɑ mɑrum kɑ biibii weenɛ. ");
INSERT INTO bba_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Dɑbu ɡen pɔturɑn tii yɑ burɑnu nnɛ mɔ ni nu kɑ dɑ̃ɑ mɑrum kɑ biibii weenɛ. ");
INSERT INTO bba_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Mi kɑ̃ɑsi yiru yiru yi ɡbinnɛ kɑ pɔturɑ, u min temɔ burɑru koosiwɑ te tɑ kɑ dɑ̃ɑ mɑrum weenɛ. ");
INSERT INTO bba_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Burɑ ni kɑ kɑ̃ɑsi yi, ye kpuro yɑ sɑ̃ɑwɑ wurɑn bɔri tiɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Yen biru bɑ fitilɑ nɔɔbɑ yiru ye kuɑ kɑ nin bɑku kɑ mi torom mu ko n dɑ wɔriki. Ye kpurowɑ bɑ kuɑ kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Wurɑ ye bɑ kɑ dɑbu ɡe kɑ ɡen dendi yɑ̃nu kpuro kuɑ, yɑ sɑ̃ɑwɑ kilo tɛnɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Yen biru bɑ mɑɑ kpɑkororu kuɑ tèn wɔllɔ bɑ ko n dɑ turɑre dɔ̃ɔ doke. Ten dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soo teeru. Ten yɑsum mɑɑ ɡɔm soo teeru. Ten ɡoonu nnɛ ye, yɑ nɛwɑ. Ten ɡunum mɑɑ ɡɔm soonu yiru. Mɑ bɑ derɑ ten ɡoo ɡɔmkinu nnɛn dɑ̃ɑ yɑ nɔɔ yɑrɑ nɡe kɑ̃ɑnu. ");
INSERT INTO bba_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Mɑ bɑ kpɑkoro te kpuro wurɑ pote, sere kɑ ten kɑ̃ɑnɔ mɑ bɑ tu nɔɔ bɔkɑ kuɑ kɑ wurɑ bɑ kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Mɑ bɑ sumi nnɛ kuɑ kɑ wurɑ bɑ doke ten ɡoo ɡɔmkinɔ nɔɔ bɔkɑ yen temɔ yi mɛɛrinɛ yiru yiru. Sumi yi sɔɔrɑ bɑ koo dɑ̃ɑ pɔɔsi yiru wɑsi beri berikɑ yi bɑ ko n dɑ kɑ tu sue. ");
INSERT INTO bba_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Mɑ bɑ dɑ̃ɑ pɔɔsi yi kuɑ kɑ ɑkɑsiɑn dɑ̃ɑ bɑ yi wurɑ pote. ");
INSERT INTO bba_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Yen biru be bɑ rɑ turɑre ko bɑ ɡum mɛ kuɑ mɛ bɑ ko n dɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ Gusunɔ u ye ɡɔsɑ nɛnɛm, kɑ sere mɑɑ turɑre ye bɑ ko n dɑ dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Mɑ bɑ yɑ̃ku yee te kuɑ kɑ ɑkɑsiɑn dɑ̃ɑ. Ten ɡoonu nnɛ ye kpuro yɑ nɛwɑ. Yɑ sɑ̃ɑ ɡɔm soonu nɔɔbu nɔɔbu. Ten ɡunum mɑɑ ɡɔm soonu itɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Mɑ bɑ derɑ kɑ̃ɑnu nu yɑrɑ ten wɔllun ɡoo ɡɔmkinɔ mɑ bɑ yɑ̃ku yee te kpuro sii ɡɑndu pote. ");
INSERT INTO bba_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Mɑ bɑ ten dendi yɑ̃nu kpuro kuɑ kɑ sii ɡɑndu. Niyɑ ɡbɛ̃ɛ ni bɑ koo kɑ torom ɡurɑ, kɑ kɑɑtonu, kɑ kɑɑto donnuɡinu, kɑ ɡbɛ̃ɛ nì sɔɔ bɑ koo yɑɑ yɛm doke bu kɑ yɛ̃kɑ, kɑ dɔ̃ɔ ɡurɑtii. ");
INSERT INTO bba_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Mɑ bɑ kɔkɔsɔ kuɑ kɑ sii ɡɑndu, bɑ ye suɑ bɑ doke yɑ̃ku yee ten kɔkɔrɔ mɑ yen nɔɔ ɡɑ seemɑ wɔllɔ yɑ̃ku yee ten suunu suunukɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Mɑ bɑ yen ɡoo ɡookɑɔ sumi doke yì sɔɔ bɑ koo dɑ̃ɑ pɔɔsi wɑsi. ");
INSERT INTO bba_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Mɑ bɑ ɑkɑsiɑn dɑ̃ɑ pɔɔsi yiru kuɑ bɑ sii ɡɑndu pote. ");
INSERT INTO bba_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Mɑ bɑ dɑ̃ɑ pɔɔsi yi wɑsi sumi yi sɔɔ beri berikɑ yi bɑ ko n dɑ kɑ yɑ̃ku yee te sue. Bɑ tu kuɑwɑ kɑ dɑ̃ɑ bɛsi mɑ tɑ wɔru mɔ. ");
INSERT INTO bba_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Mɑ bɑ boo ɡe kuɑ kɑ ɡen sɔwɑritiɑ, ye kpuro yɑ sɑ̃ɑwɑ sii ɡɑndu. Bɑ nu mwɛɛrɑwɑ tɔn kurɔbun mi be bɑ rɑ sinɛ sɑ̃ɑ yee ten kɔnnɔwɔ. N deemɑ sii ɡɑn niyɑ nu rɑ n sɑ̃ɑ ben diɡi. ");
INSERT INTO bba_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Bɑ kuu te kɑrɑ koosi kɑ beku dɑmɡinu. Yen sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ yen dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu wunɔbu (100). ");
INSERT INTO bba_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","Mɑ bɑ dɑ̃ɑ bɛsi sinumɡii yɛndu suɑ yi kuɑ kɑrɑ yen dɑ̃ɑ. Mɑ bɑ yin yɔ̃rɑtii kuɑ kɑ sii ɡɑndu. Yen biru bɑ mɑɑ yin beku sɔretinu kuɑ kɑ sii ɡeesu. Mɑ bɑ sii ɡeesun dɛki kuɑ bu kɑ bekɑ ye tɑɑre. ");
INSERT INTO bba_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Kɑrɑ yen sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ, yen bekunun dɛ̃ɛbu sɑ̃ɑwɑ ɡɔm soonu wunɔbu (100). Mɑ bɑ nu sɔre kɑrɑ dɑ̃ɑ sɔɔ nɡe mɛ bɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑruɡii ni kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Sɔ̃ɔ duu yeru ɡiɑ kɑrɑ yen bekunun dɛ̃ɛbu sɑ̃ɑwɑ ɡɔm soonu weerɑɑkuru. Mɑ bɑ nu sɔre kɑrɑ dɑ̃nu wɔkuru sɔɔ ye yɑ sɔretii mɔ nɡe mɛ bɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑruɡii ni kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Yen sɔ̃ɔ yɑri yeru ɡiɑ mɑɑ, yen dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu weerɑɑkuru. ");
INSERT INTO bba_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","15","Kɑrɑ beku ni nu wɑ̃ɑ kɑrɑ yen kɔnnɔn beri berikɑɔ, nin dɛ̃ɛbu bu sɑ̃ɑwɑ ɡɔm soonu wɔkurɑ nɔɔbu nɔɔbu. Mɑ bɑ nu kɑrɑ dɑ̃nu kuɑ itɑ itɑ, ten bɑɑtere kɑ ten yɔ̃rɑtiɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Bɑ kɑrɑ yen bekunu kpuro kuɑwɑ kɑ wɛ̃ɛ dɑmɡii. ");
INSERT INTO bba_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Kɑrɑ dɑ̃ɑ nin yɔ̃rɑtii, sii ɡɑndɑ bɑ kɑ yi kuɑ. Yen sɔretii ni nu wɑ̃ɑ dɑ̃ɑ ye sɔɔ, kɑ sii dɛki yi, ye kpuro yɑ sɑ̃ɑwɑ sii ɡeesu. Mɑ bɑ dɑ̃ɑ nin wɔllɔ sii ɡeesu pote. Dɑ̃ɑ ni kpuro nu sɔrenɛwɑ kɑ sii dɛki yi. ");
INSERT INTO bba_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Bɑ kɑrɑ kɔnnɔ ɡen beku kɛnutii te kuɑwɑ kɑ wɛ̃ɛ dɑmɡii mɑ bɑ tu burɑru kuɑ kɑ wɛ̃ɛ wunɔmɡii kɑ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ. Ten yɑsum sɑ̃ɑwɑ ɡɔm soonu yɛndu, ten ɡunum mɑɑ ɡɔm soonu nɔɔbu nɡe mɛ kuu ten beku teerɑ yɑsum nɛ. ");
INSERT INTO bba_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Dɑ̃ɑ bɛsi sinumɡii nnɛ sɔɔrɑ bɑ beku kɑre te sɔre, mɑ bɑ yin yɔ̃rɑtii kuɑ kɑ sii ɡɑndu. Bɑ yin wii wɔllɔ sii ɡeesu pote nɡe furɔ. Mɑ bɑ yin sɔretinu kɑ sere yin sii dɛki yi kuɑ kɑ sii ɡeesu. ");
INSERT INTO bba_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Kuu bekuruɡii te, kɑ kɑrɑ yen ɡɑbɑtiɑn kurum kpuro yɑ sɑ̃ɑwɑ sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mɔwisi u Lefibɑ sɔ̃ɔwɑ bu sisun dooru ko si kuu bekuruɡii te, tɑ di, tè sɔɔ bɑ koo Yinni Gusunɔn woodɑn kpɑkoro te doke. Itɑmɑɑ, Aroni yɑ̃ku kowon biiwɑ u sɑ̃ɑ ben wiruɡii. ");
INSERT INTO bba_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bɛsɑlɛli, Urin bii, Hurin debubu, Yudɑn bweseru sɔɔ, u kuu ten sɔmburu kuɑ kpuro te Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiɑbu, Ahisɑmɑkin bii, Dɑnun bweseru sɔɔ, wiyɑ u Bɛsɑlɛli somi u kɑ sɔmbu te kuɑ. Wiyɑ u ɡɑ̃ɑ dɑbinu kuɑ kuɑ. U sɔmɑn kpunɑɑbɑ kuɑ, u kpee ɡobiɡinu dɑ̃kɑ, mɑ u bekunu burɑru kuɑ kɑ wɛ̃ɛ wunɔmɡii kɑ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Wurɑ ye Isirelibɑ bɑ wɛ̃ bɑ kɑ kuu bekuruɡii te, kɑ ten dendi yɑ̃nu kpuro kuɑ yɑ sɑ̃ɑwɑ kilo nɛnɛ kɑ wɑtɑ kɑ wɔkurɑ nɔɔbu kɑ yirun (875) sɑkɑ. Bɑ ye yĩirɑwɑ kɑ ben sɑ̃ɑ yerun sɑkɑku. ");
INSERT INTO bba_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Sii ɡee si Isirelibɑ bɑ mɑɑ wɛ̃ sɑnɑm mɛ bɑ bu ɡɑrimɔ, su kuɑwɑ kilo nɔrɔbun subɑ itɑ kɑ wɔkurɑ nɔɔbu kɑ yirun (3.017) sɑkɑ. Bɑ su yĩirɑwɑ kɑ ben sɑ̃ɑ yerun sɑkɑku. ");
INSERT INTO bba_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Tɔn be bɑ sii ɡee si wɛ̃, ben ɡeerɑ sɑ̃ɑwɑ tɔnu nɔrɔbun subɑ nɑtɑ kɑ itɑ, kɑ nɛɛrɑ wunɔbu kɑ weerɑɑkuru (603.550). N deemɑ be bɑ wɔ̃ɔ yɛndu turɑ, kɑ be bɑ kere mɛ, berɑ bɑ ɡɑrɑ. Ben bɑɑwure u wɛ̃wɑ ɡɑrɑmu nɔɔbu. ");
INSERT INTO bba_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Sii ɡeesun kilo nɔrɔbun subɑ itɑwɑ (3.000) bɑ kɑ kuu bekuruɡii te kɑ ten beku kɑre ten dɑ̃ɑ bɛsin yɔ̃rɑtii wunɔbu (100) kuɑ. Yen bɑɑyere, kilo tɛnɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Mɑ bɑ mɑɑ kɑ sii ɡeesun kilo wɔkurɑ nɔɔbu kɑ itɑ ye yɑ tie sɔretii ni, kɑ dɑ̃ɑ bɛsi yin furɔsu, kɑ sii dɛki yi kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Sii ɡɑn ni Isirelibɑ bɑ mɑɑ mɛnnɑ, nu kuɑwɑ kilo nɔrɔbun subɑ yiru kɑ wunɑɑ teeru kɑ nnɛ (2.124). ");
INSERT INTO bba_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Sii ɡɑn niyɑ bɑ kɑ kuu ten kɔnnɔn dɑ̃ɑ bɛsi sinumɡiin yɔ̃rɑtii kuɑ kɑ yɑ̃ku yee te, kɑ ten kɔkɔsɔ ye, kɑ ten dendi yɑ̃nu. ");
INSERT INTO bba_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Kɑ niyɑ bɑ mɑɑ kuu ten kɑrɑ dɑ̃nun yɔ̃rɑtii, kɑ yen kɔnnɔn pɔɔsin yɔ̃rɑtii kɑ sere kuu te, kɑ kɑrɑ yen ɡɑbɑtiɑn kurum kpuro kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Bɑ yɑ̃ku kowobun yɑ̃ɑ ni kuɑ kɑ yɑ̃ɑ sɑnsun beku ni bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ ni bɑ wunɔm doke. Mɑ Mɔwisi u derɑ bɑ Aronin sɑ̃ɑ yɑ̃ɑ ni kuɑ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Bɑ yɑbe tɑrɑkpe ɡe kuɑ kɑ beku te bɑ kuɑ kɑ wɛ̃ɛ dɑmɡii, mɑ bɑ ɡe burɑru kuɑ kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wɛ̃ɛ wunɔmɡii kɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Bɑ wurɑ ye bɛsukɑwɑ teere teere bɑ doke doke yɑbe tɑrɑkpe ɡen bekuru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Mɑ bɑ ɡu sɑri yiru kuɑ bu kɑ ɡen senu sɔrenɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Yɑbe tɑrɑkpe ɡe kɑ ɡen sɛ̃kɑtiɑ yɑ sɑ̃ɑwɑ beku nɔni tee, mɑ bɑ sɛ̃kɑtiɑ ye yinusi yɑbe te sɔɔ. Bɑ ye kuɑwɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Mɑ bɑ kpee ɡobiɡinu yiru nìn nɔni sɑ̃ɑ bɛrɔ wuru wurɑ ɡore nì sɔɔ bɑ Isireli bibun yĩsɑ yorusi nɡe mɛ bɑ rɑ yore sisɔ. ");
INSERT INTO bba_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Mɑ bɑ nu mɑni sɑri yi sɔɔ nu kɑ sɔ̃ɔsi mɑ Isirelin bwesenu kpuron yĩsɑ Aroni u sɔɔwɑ sɑnɑm mɛ u duɔ sɑ̃ɑ yee ten mi. Mɛyɑ bɑ ye kpuro kuɑ nɡe mɛ Mɔwisi u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Bɑ mɑɑ bɔɔ bɑrɑ ye kuɑ. Ye kɑ yɑbe tɑrɑkpe ɡe, yɑ sɑ̃ɑwɑ beku nɔni tee kɑ burɑ teeru. ");
INSERT INTO bba_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Bɔɔ bɑrɑ yen yɑsum kɑ yen dɛ̃ɛbu mu nɛwɑ. Ye kpuro ɡɔm soonun bɔnu bɔnu. ");
INSERT INTO bba_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Mɑ bɑ ye kpee ɡobiɡinu bwese bwesekɑ mɑni sĩɑ nnɛ. Kpee nin nɔni wee. Sĩi ɡbiikɑɑ sɔɔ, swɑ̃ɑru kɑ dɔm buuru kɑ wuru beku. ");
INSERT INTO bba_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","Yiruse sɔɔ mɑɑ, swɑ̃ɑru kɑ booɡu kɑ sɔ̃ɔ tiro. ");
INSERT INTO bba_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","Itɑse sɔɔ, dɔm buuru kɑ nɔni bwese bwesekɑ kɑ ɡɑɑdurɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","Nnɛse sɔɔ, wuru beku kɑ bɛrɔ wuru kɑ nɔni bwese bwesekɑ. Bɑ ye kpuro wurɑ ɡore ɡorewɑ bɑ sere mɑni bɔɔ bɑrɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Mɑ bɑ nin bɑɑtere sɔɔ Isirelin bibun yĩsinu yoruɑ tiɑ tiɑ, domi ben bɑɑwuren yĩsiru tɑ sɑ̃ɑwɑ Isirelibɑn bwese kɛrɑ tiɑn yĩsiru. ");
INSERT INTO bba_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Mɑ bɑ bɔɔ bɑrɑ ye wurɑn yɔni yiru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Mɑ bɑ tɑɑminu yiru kɑ sɔretinu yiru kuɑ kɑ wurɑ, mɑ bɑ tɑɑmii ni doke bɔɔ bɑrɑ yen soo wɔrikisɔ. ");
INSERT INTO bba_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Tɑɑminu yiru ye sɔɔrɑ bɑ wurɑn yɔni yiru ye sɔre. ");
INSERT INTO bba_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Mɑ bɑ bɔɔ bɑrɑ yen yɔni yi ɡbinisi yɑbe tɑrɑkpe ɡen sɑriɔ mi wurɑn sɔretii ni, nu wɑ̃ɑ, kpɑ yɑ n kɑ sɔndi tororu wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Mɑ bɑ mɑɑ wurɑn tɑɑminu yiru kuɑ bɑ doke bɔɔ bɑrɑ yen soo temkisɔ si su yɑbe tɑrɑkpe ɡe ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Mɑ bɑ mɑɑ tɑɑminu yiru kuɑ kɑ wurɑ bɑ nu doke yɑbe tɑrɑkpe ɡen sɑrin nɔɔwɔ wuswɑɑɔ sɛ̃kɑtiɑ yen wɔllu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Yen biru bɑ bɔɔ bɑrɑ yen tɑɑmii ni sɔɔ wɛ̃ɛ ɡɑɑdurɑɡii doke bɑ yi ɡbinuɑ yɑbe tɑrɑkpe ɡen tɑɑminu sɔɔ. Nɡe mɛyɑ bɑ kɑ ye sɔre yɑbe tɑrɑkpe ɡe sɔɔ yu ku kɑ bɑ̃ɑri. Bɑ ye kuɑwɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Yɑbe tèn wɔllɔ bɑ yɑbe tɑrɑkpe ɡe sɔndi, bɑ tu wesɑwɑ kɑ wɛ̃ɛ ɡɑɑdurɑɡii. ");
INSERT INTO bba_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Mɑ bɑ ten wĩirɔ sɔmɑ doke bɑ sinum koosiɑ kpɑ tu ku rɑɑ kɑ ɡɛ̃ɛrɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Mɑ bɑ ten temɔ tusɑnu doke ni nu kɑ dɑ̃ɑ mɑrum ɡɑm weenɛ. Bɑ nu kuɑ kɑ wɛ̃ɛ dɑmɡii kɑ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wɛ̃ɛ wunɔmɡii. ");
INSERT INTO bba_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Mɑ bɑ mɑɑ wurɑn yɑnɡire piiminu kuɑ bɑ nu doke bɑ kɑ sikerenɑ, nu kpɑsɑ sɑ̃ɑ kɑ tusɑ ni. ");
INSERT INTO bba_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Bɑ ye kuɑwɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Mɑ bɑ Aroni kɑ win bibu tɑkobɑ kuɑ kɑ wɛ̃ɛ dɑmɡii. ");
INSERT INTO bba_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","Mɛyɑ bɑ mɑɑ dɑwɑni ye kuɑ kɑ furɔsu si su sɑ̃ɑ ben burɑru te tɑ ben ɡirimɑ sɔ̃ɔsimɔ, kɑ sokoto kpirinu. Bɑ ye kpuro kuɑ kɑ wɛ̃ɛ dɑmɡii. ");
INSERT INTO bba_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Bɑ mɑɑ sɛ̃kɑtiɑ ye wesɑ kɑ wɛ̃ɛ dɑmɡii bɑ burɑru koosi kɑ wɛ̃ɛ yi bɑ wɔ̃kuɑ kɑ burɑ kɑ mɑɑ ɡɑɑdurɑ kɑ wɛ̃ɛ wunɔmɡii. Mɛyɑ bɑ ye kpuro kuɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Bɑ bɑtɑni wurɑɡiɑ ye kuɑ bɑ yoruɑ ye sɔɔ, wini sɑ̃ɑwɑ Yinni Gusunɔɡii. Bɑ ye yoruɑwɑ nɡe mɛ bɑ rɑ yore sisɔ. ");
INSERT INTO bba_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Mɑ bɑ ye sɔresi dɑwɑni yen wɔllɔ kɑ wɛ̃ɛ ɡɑɑdurɑɡii nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Isirelibɑ bɑ Yinni Gusunɔn kuu bekuruɡii te kuɑ bɑ kpɑ. Bɑ ye kpuro kuɑwɑ nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Mɑ bɑ kɑ Mɔwisi ten yɑ̃nu kpuro nɑɑwɑ. Niyɑ bekɑ ye kɑ yen sɔretinu kɑ dɑ̃ɑ bɛsi yi kɑ dɑ̃ɑ kɑretii yi kɑ dɑ̃ɑ bɛsi sinumɡii yi kɑ yin yɔ̃rɑtii ");
INSERT INTO bba_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","kɑ yɑ̃ɑ kinɛnun ɡɔni yi bɑ swɛ̃rɑsiɑ kɑ yɑɑ ɡɔni sinumɡii yi kɑ beku kɑre te ");
INSERT INTO bba_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","kɑ Yinni Gusunɔn woodɑn kpɑkoro te kɑ ten nɛnutii kɑ ten wukiritiɑ, ");
INSERT INTO bba_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","kɑ tɑbulu ye kɑ yen dendi yɑ̃nu kɑ pɛ̃ɛ ye bɑ rɑ yi yen wɔllɔ, ");
INSERT INTO bba_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","kɑ dɑbu wurɑɡuu ɡe kɑ ɡen fitilɑnu kɑ nin dendi yɑ̃nu kɑ nin ɡum, ");
INSERT INTO bba_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","kɑ kpɑkoro wurɑɡiru tèn wɔllɔ bɑ ko n dɑ turɑre dɔ̃ɔ doke, kɑ ɡum mɛ bɑ ko n dɑ kpuro tɑ̃re bu kɑ sɔ̃ɔsi mɑ Gusunɔ u ye ɡɔsɑ nɛnɛm, kɑ turɑre nubu duroruɡiɑ ye kɑ kuu ten kɔnnɔn beku kɛnutiru, ");
INSERT INTO bba_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","kɑ yɑ̃ku yee te bɑ kuɑ kɑ sii ɡɑndu kɑ ten kɔkɔsɔ sii ɡɑnduɡiɑ kɑ ten nɛnutii kɑ sere ten dendi yɑ̃nu kpuro kɑ mɑɑ boo ɡe kɑ ɡen sɔwɑritiɑ, ");
INSERT INTO bba_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","kɑ kuu ten kɑrɑn bekunu kɑ yen dɑ̃nu kɑ nin yɔ̃rɑtii kɑ yen kɔnnɔn beku kɛnutiru kɑ yen wɛ̃ɛ kɑ yen ɡɑbɑtiɑn kurumbɑ, kɑ sere sɑ̃ɑrun dendi yɑ̃nu kpuro ni bɑ koo dendi kuu te sɔɔ, ");
INSERT INTO bba_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","kɑ sɑ̃ɑ yɑ̃ɑ ni Aroni kɑ win bibu bɑ ko n dɑ doke bɑ̀ n sɔmburu mɔ̀ sɑ̃ɑ yee ten mi. Niyɑ nu koo ben ɡirimɑ sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Isirelibɑ bɑ sɔmbu te kuɑwɑ mɑm mɑm nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Ye Mɔwisi u yɑ̃ɑ ni mɛɛrɑ u kpɑ, yerɑ u wɑ bɑ nu kuɑwɑ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. Mɑ u bu domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","suru ɡbiikoon tɔ̃ɔ ɡbiikiru sɔɔrɑ kɑɑ nɛn kuu te ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","À n tu ɡirɑ ɑ kpɑ, kpɑ ɑ woodɑn kpɑkoro te suɑ ɑ doke te sɔɔ, kpɑ ɑ tu ɡɑndi kɑ beku kɑre te. ");
INSERT INTO bba_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Kpɑ ɑ tɑbulu ye duusiɑ kɑ yen dendi yɑ̃nu, kɑ mɑɑ dɑbu ɡe, kpɑ ɑ ɡen fitilɑnu doke nin ɑyenɔ. ");
INSERT INTO bba_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Kɑɑ mɑɑ de bu kpɑkoro wurɑɡiru tèn mi bɑ ko n dɑ turɑre dɔ̃ɔ doke yi woodɑn kpɑkororun deedeeru. Kpɑ ɑ mɑɑ beku kɛnutiru doke kuu ten kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","Kpɑ ɑ mɑ yɑ̃ku yee te yi ten ɑyerɔ kuu ten kɔnnɔn deedeeru. ");
INSERT INTO bba_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","Kpɑ ɑ boo ɡe yi yɑ̃ku yee te kɑ kuu ten bɑɑ sɔɔ kpɑ ɑ ɡu nim yibiɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Kpɑ ɑ kuu ten kɑrɑ ye ɡirɑ ɑ kɑ sikerenɑ, kpɑ ɑ yen kɔnnɔn beku kɛnutiru doke. ");
INSERT INTO bba_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","Yen biru kɑɑ ɡum yɛ̃kɑ kuu te sɔɔ kɑ ten dendi yɑ̃nu kpuro sɔɔ. Nɡe mɛyɑ kɑɑ kɑ sɔ̃ɔsi mɑ tɑ sɑ̃ɑ sɑ̃ɑruɡiru. ");
INSERT INTO bba_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Mɛyɑ kɑɑ mɑɑ yɑ̃ku yee te ɡum mɛ yɛ̃kɑ kɑ ten dendi yɑ̃nɔ. Nɡe mɛyɑ kɑɑ kɑ sɔ̃ɔsi mɑ tɑ sɑ̃ɑ sɑ̃ɑruɡiru. ");
INSERT INTO bba_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Kɑɑ mɑɑ boo ɡen tii kɑ ɡen sɔwɑritiɑ ɡum mɛ yɛ̃kɑ ɑ kɑ sɔ̃ɔsi mɑ ɡɑ sɑ̃ɑ sɑ̃ɑruɡuu. ");
INSERT INTO bba_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","Yen biru kɑɑ kɑ Aroni kɑ win bibu nɑ kuu ten kɔnnɔwɔ, kpɑ ɑ bu wobure kɑ nim dirum. ");
INSERT INTO bba_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Kpɑ ɑ Aroni sɑ̃ɑ yɑ̃ɑ ni sebusiɑ ɑ nùn ɡum mɛ tɑ̃re ɑ kɑ sɔ̃ɔsi mɑ u sɑ̃ɑ nɛn yɑ̃ku kowo. ");
INSERT INTO bba_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Mɛyɑ kɑɑ mɑɑ win bibu sɔ̃ bu susimɑ kpɑ ɑ bu tɑko be sebusiɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Yen biru kpɑ ɑ mɑɑ bu ɡum mɛ tɑ̃re nɡe mɛ ɑ ben tundo kuɑ. Nɡe mɛyɑ kɑɑ kɑ sɔ̃ɔsi mɑ bɑ sɑ̃ɑ nɛn yɑ̃ku kowobu, be kɑ ben bibun bweseru sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Mɔwisi u kuɑ kpuro nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Ye n kuɑ wɔ̃ɔ yirusen suru ɡbiikoon tɔ̃ɔ ɡbiikiru sɑɑ mìn di bɑ yɑrimɑ Eɡibitin di, yerɑ Mɔwisi u Yinni Gusunɔn kuu te ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","U ɡbiɑ u dɑ̃ɑ bɛsi yin yɔ̃rɑtii ɡirɑ mɑ u dɑ̃ɑ bɛsi yi doke sɔɔ, mɑ u yi dɑ̃ɑ kɑre. Mɑ u dɑ̃ɑ bɛsi sinumɡii ɡirɑ. Mɑ u bekɑ ye wukiri yin wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Mɑ u boo sɑnsun bekɑ ye sɔndi bekɑ yen wɔllɔ. Mɑ u yɑɑ ɡɔni yi suɑ u kɑ ye kpuro wukiri nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Mɑ u woodɑn kpee bɛsi yi suɑ u doke yin kpɑkoro te sɔɔ. Mɑ u dɑ̃ɑ pɔɔsi yi bɑ rɑ kɑ tu sue wɑsi yin bɛri yenɔ. Mɑ u ten wukiritiɑ doke. ");
INSERT INTO bba_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Mɑ u kɑ kpɑkoro te nɑ u yi kuu ten dii te tɑ dɛɛre ɡem ɡem sɔɔ, mɑ u beku kɑre te doke u kɑ kpɑkoro te ɡɑndi nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Mɑ u tɑbulu ye doke nɔm ɡeu ɡiɑ ɑdɛrɔ ɡe sɔɔ, ɑ̀ n duɔ kuu ten mi. ");
INSERT INTO bba_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Mɑ u pɛ̃ɛ ye yoruɑ tɑbulu wɔllɔ mɑm mɑm, ye bɑ kɑ Yinni Gusunɔ nɑɑwɑ, nɡe mɛ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Mɑ u dɑbu ɡe doke nɔm dwɑru ɡiɑ tɑbulun deedeeru. ");
INSERT INTO bba_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Mɑ u ɡu fitilɑnu sɔndi u sɔ̃rɑ Yinni Gusunɔn wuswɑɑɔ nɡe mɛ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Mɑ u kpɑkoro wurɑɡii te doke ɑdɛrɔ ɡe sɔɔ beku kɑre ten bɔkuɔ te tɑ woodɑn kpɑkoro te ɡɑndi. ");
INSERT INTO bba_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Mɑ u turɑre dɔ̃ɔ doke ten wɔllɔ, nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Mɑ u beku kɛnutiru doke kuu ten kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Mɑ u yɑ̃ku yee te yi kuu ten kɔnnɔwɔ. Mɑ u yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kɑ ɑbɔru ɡɑru kuɑ mi, nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Mɑ u boo ɡe doke yɑ̃ku yee te kɑ kuu ten bɑɑ sɔɔ. Mɑ u ɡu nim yibiɑ, mɛ bɑ koo kɑ tii dɛɛrɑsiɑ sɑ̃ɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Mɛyɑ Mɔwisi kɑ Aroni kɑ win bii tɔn durɔbu bɑ rɑ kɑ ben nɔmɑ kɑ nɑɑsu kpɑkie, ");
INSERT INTO bba_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","bɑ̀ n duɔ kuu ten mi, ǹ kun mɛ bɑ̀ n yɑ̃ku yee te susiɔ, nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Mɑ Mɔwisi u kuu te kɑ yɑ̃ku yee te kɑrɑ koosi. Mɑ u beku kɛnutiru doke yen kɔnnɔwɔ. Nɡe mɛyɑ u kɑ sɔmbu te wiru ɡo. ");
INSERT INTO bba_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Sɑnɑm mɛyɑ ɡuru wii wuro te, tɑ kuu te wukiri mɑ Yinni Gusunɔn yiikon ɡirimɑ yɑ tu yibɑ. ");
INSERT INTO bba_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Mɔwisi u ǹ mɑɑ kpĩɑ u kuu te du yèn sɔ̃ ɡuru wii wuro te, tɑ yɔ̃ ten wɔllɔ mɑ Yinni Gusunɔn yiikon ɡirimɑ ye, yɑ yibɑ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Sɑɑ ye Isirelibɑ bɑ wɑ̃ɑ ɡbɑburɔ, ɡuru wii wuro te, tɑ̀ n seewɑ kuu ten wɔllun di yerɑ bɑ rɑ se bu swɑɑ wɔri. ");
INSERT INTO bba_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Adɑmɑ tɑ̀ kun seewe, bɑ ku rɑ swɑɑ wɔri. ");
INSERT INTO bba_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Isirelibɑn sɑnum mɛ kpuro sɔɔ, Yinni Gusunɔn ɡuru wii wuro te, tɑ rɑ n wɑ̃ɑwɑ win kuu ten wɔllɔ sɔ̃ɔ sɔɔ. Ǹ n kuɑ wɔ̃kuru, dɔ̃ɔwɑ tɑ rɑ n kɑ weenɛ.");
INSERT INTO bba_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Yinni Gusunɔ u Mɔwisi sokɑ sɑɑ win kuu bekuruɡii tèn mi bɑ rɑ nùn sɑ̃n di. ");
INSERT INTO bba_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","U nùn sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ben ɡoo ù n kĩ u nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ, u koo kpĩ u kɛtɛ ɡo, ǹ kun mɛ yɑ̃ɑru. ");
INSERT INTO bba_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Ǹ n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirɑ yɛ̃ro u mɔ̀ kɑ kɛtɛ, kɛtɛ ye, yɑ ko n sɑ̃ɑwɑ kɛtɛ kinɛru te tɑ ǹ ɑlebu ɡɑɑ mɔ. U koo yɑ̃ku te kowɑ nɛn sɑ̃ɑ yerun kɔnnɔwɔ, kpɑ u kɑ nɛ, Yinni Gusunɔn durom wɑ. ");
INSERT INTO bba_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","U koo win nɔmɑ sɔndiwɑ kɛtɛ yen wiru wɔllɔ ye nɛ Gusunɔ nɑ wurɑ yu kɑ win durum wukiri. ");
INSERT INTO bba_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","U koo kɛtɛ ye ɡowɑ nɛ, Yinni Gusunɔn wuswɑɑɔ nɛn kuu ten kɔnnɔwɔ. Aronin bibu be bɑ sɑ̃ɑ yɑ̃ku kowobu, beyɑ bɑ koo yen yɛm suɑ kpɑ bu mu yɛ̃kɑ bu kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Yen biru bɑ koo sɑbe te kokuwɑ kpɑ bu ten yɑɑ bɔtiri. ");
INSERT INTO bba_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Yɑ̃ku kowo berɑ bɑ koo yɑ̃ku dɑ̃ɑ yi yi kpɑ bu dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Dɔ̃ɔ wi sɔɔrɑ bɑ koo ye kpuro doke kɑ yen wiru kɑ yen ɡum. ");
INSERT INTO bba_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Bɑ koo yen bɔsɔ yɑ̃nu kɑ yen wɔbunu kpuro teɑwɑ kpɑ yɑ̃ku kowobu bu ye kpuro dɔ̃ɔ doke. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu nìn nuburɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","Goo ù n mɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀ kɑ yɑ̃ɑru, ǹ kun mɛ kɑ boo, yɑ̃ɑ kinɛrɑ u koo ɡo, ǹ kun mɛ boo kinɛru te tɑ ǹ ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","U koo tu sɑkɑwɑ yɑ̃ku yerun sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ Yinni Gusunɔn wuswɑɑɔ kpɑ yɑ̃ku kowobu bu ten yɛm suɑ bu yɛ̃kɑ yɛ̃kɑ bu kɑ yɑ̃ku yerun nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","U koo yɑɑ ye bɔtiriwɑ kpɑ u kpɛ̃ɛ yɑ̃ku dɔ̃ɔ sɔɔ kɑ yen wiru kɑ yen ɡum sɑnnu. ");
INSERT INTO bba_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","U koo yen bɔsɔ yɑ̃nu kɑ yen wɔbunu suɑ u teɑwɑ, kpɑ yɑ̃ku kowo u ye kpuro suɑ u dɔ̃ɔ doke, yu dɔ̃ɔ mwɑɑrɑ mɑm mɑm. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru tèn nuburɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","Goo ù n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀ kɑ ɡunɔsu, kpɑrukonɑ u koo kɑ tu ko, ǹ kun mɛ totobɛrɛnu. ");
INSERT INTO bba_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Yɑ̃ku kowo u koo kɑ ɡunɔ ɡe nɑ yɑ̃ku yerɔ. Kpɑ u ɡen wiru burɑ kpɑ u ɡen yɛm yɛ̃kɑ yɛ̃kɑ yɑ̃ku yee ten yɛ̃sɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","U koo ɡen sɑnsu wukiriwɑ kpɑ u ɡen yɔ̃ɔru wĩɑ u kɔ̃ yɑ̃ku yerun sɔ̃ɔ yɑri yeru ɡiɑ mì bɑ rɑ torom wisi. ");
INSERT INTO bba_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Kpɑ u ɡu bɛrɑ bɛsi yiru u kun sɔsiɑnɛ. Yen biruwɑ u koo ɡu dɔ̃ɔ kpɛ̃ɛ, kpɑ ɡu dɔ̃ɔ mwɑɑrɑ. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru tèn nuburu tɑ koo nɛ Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","Goo ù n kĩ u Yinni Gusunɔ yɑ̃kuru kuɑ kɑ win dĩɑ binnu, somɑ u koo suɑ, u mu burinɑ kɑ ɡum kɑ sere turɑre ye bɑ rɑ dɔ̃ɔ doke yɑ̃ku yerɔ. ");
INSERT INTO bba_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","U koo kɑ ye dɑwɑ Aronin bibun mi be bɑ sɑ̃ɑ yɑ̃ku kowobu. Ben turowɑ u koo som mɛn nɔm wɔɔ teeru sɔkɑ u doke yɑ̃ku yerun wɔllɔ kɑ turɑre ye kpuro kpɑ u dɔ̃ɔ doke. Yerɑ yɑ koo de Gusunɔ u n yɛ̃ro yɑɑye. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru tèn nuburɑ koo Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Som mɛ mu tie mu ko n sɑ̃ɑwɑ Aroni kɑ win bibuɡim. Mu kuɑwɑ mi dĩɑ dɛɛrɑnu, domi bɑ kɑ nu Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","À n Yinni Gusunɔ yɑ̃kuru kuɑmmɛ kɑ kirɑ ni bɑ wɔ̃ɔwɑ, kɑɑ nu kowɑ kɑ som mɛ bɑ ɡum yɛ̃kɑ ǹ kun mɛ mɛ bɑ kɑ ɡum burinɑ bɑ ǹ seeyɑtiɑ doke. ");
INSERT INTO bba_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Bɑ̀ n koo yɑ̃ku te kon nɑ kɑ kirɑ ni bɑ sɔnwɑ, bɑ koo nu kowɑ kɑ som buu te bɑ burinɑ kɑ ɡum, seeyɑtiɑ sɑri. ");
INSERT INTO bba_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Yen biru bɑ koo nu muririwɑ kpɑ bu ɡum yɛ̃kɑ nin wɔllɔ. Yɑ ko n sɑ̃ɑwɑ yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Bɑ̀ n koo yɑ̃ku te kon nɑ, kɑ kirɑ te bɑ koo wɔ̃, bɑ koo tu kowɑ kɑ som buuru te bɑ burinɑ kɑ ɡum. ");
INSERT INTO bba_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Bɑ koo kɑ yɑ̃ku kirɑ te dɑwɑ Yinni Gusunɔn sɑ̃ɑ yerɔ. Kpɑ u tu yɑ̃ku kowo wɛ̃ u kɑ tu dɑ yɑ̃ku yerɔ. ");
INSERT INTO bba_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","U koo ten ɡɑru murɑ te tɑ koo de Yinni Gusunɔ u n yɛ̃ro yɑɑye kpɑ u tu dɔ̃ɔ doke yɑ̃ku yee ten mi, kpɑ tu dɔ̃ɔ mwɑɑrɑ. Tɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru tèn nuburɑ koo Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kirɑ ni nu tie, Aroni kɑ win bibɑ bɑ ni mɔ. Nu kuɑwɑ mi dĩɑ dɛɛrɑnu domi bɑ kɑ nu Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","Kirɑ ni bɑ koo kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko kpuro, bu ku rɑɑ nu seeyɑtiɑ doke, bu ku rɑɑ mɑɑ nu tim doke. ");
INSERT INTO bba_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kɑɑ kpĩ ɑ kɑ wunɛn dĩɑ ɡbiikinu Yinni Gusunɔ nɑɑwɑ. Adɑmɑ ɑ ǹ kɑ nu yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu mɔ̀ yɑ̃ku yerɔ. ");
INSERT INTO bba_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Dĩɑ ni ɑ kɑ yɑ̃kuru mɔ̀ kpuro, kɑɑ nu bɔru dokewɑ. A ku duɑri ɑ kun tu doke. Domi bɔru tɑ sɑ̃ɑwɑ wunɛ kɑ Gusunɔn ɑrukɑwɑnin yĩreru. Yen sɔ̃nɑ bɑ ko n dɑ tu doke yɑ̃kuru bɑɑtere sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","Ì n kĩ i kɑ bɛɛn ɡberun dĩɑ ɡbiikinu nɑ Yinni Gusunɔn mi, i ko i nu sɔmɛwɑ kpɑ i nu nɑm i sere kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Kpɑ i kɑ nu ɡum burinɑ, i turɑre sɔndi nin wɔllɔ. Yɑ ko n sɑ̃ɑwɑ yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Yɑ̃ku kowowɑ u koo som mɛ mu sɑ̃ɑ Gusunɔɡim dɔ̃ɔ doke kɑ sere mɑɑ turɑre ye. Yerɑ yɑ koo de Gusunɔ u n yɛ̃ro yɑɑye. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀ Yinni Gusunɔn mi kɑ kɛtɛ kinɛru, ǹ kun mɛ kɑ kɛtɛ niɑ, yen ye u wɑ kpurowɑ u koo kɑ nɑ, yɑ kun ɡesi ɑlebu mɔ. ");
INSERT INTO bba_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","U koo win nɔmu sɔndiwɑ kɛtɛ yen wiru wɔllɔ kpɑ u ye sɑkɑ kuu ten kɔnnɔwɔ mi bɑ rɑ Yinni Gusunɔ sɑ̃. Kpɑ yɑ̃ku kowo Aronin bibu bu yen yɛm yɛ̃kɑ bu kɑ sɑ̃ɑ yerun nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Wee ye bɑ koo Yinni Gusunɔ dɔ̃ɔ dokeɑ, yerɑ ɡum mɛ mu bɔsɔ yɑ̃nu tɛ̃ke, ");
INSERT INTO bba_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kɑ ɡɑbu swii yiru kɑ yin ɡum mɛ mu yi tɛ̃ke yɛ̃si yɛ̃sikɑɔ, kɑ yen buro ɡe ɡɑ yen woru wukiri. Bɑ koo ɡu wĩɑwɑ kɑ ɡɑbu swii sɑnnu. ");
INSERT INTO bba_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Yɑ̃ku kowobɑ bɑ koo ye kpuro dɔ̃ɔ doke yu dɔ̃ɔ mwɑɑrɑ kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru sɑnnu. Yɑ ko n sɑ̃ɑwɑ yɑ̃ku tèn nuburɑ koo Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀ kɑ yɑ̃ɑru, yɑ̃ɑ te u wɑ kpurowɑ u koo kɑ nɑ, bɑɑ ǹ n nirun nɑ, tɑ kun ɡesi ɑlebu mɔ. ");
INSERT INTO bba_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Ǹ n yɑ̃ɑ kpɛndun nɑ, u koo kɑ tu dɑwɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Kpɑ u win nɔmɑ sɔndi ten wiru wɔllɔ u sere tu sɑkɑ Yinni Gusunɔn kurun kɔnnɔwɔ. Sɑɑ yerɑ yɑ̃ku kowobu bɑ koo ten yɛm suɑ bu yɛ̃kɑ bu kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Wee ye bɑ koo Yinni Gusunɔ dɔ̃ɔ dokeɑ, yerɑ ten ɡum, kɑ ten siru kpuro te bɑ koo burɑ sɑɑ ten ɡɑbu wɑ̃ɑn di, kɑ ɡum mɛ mu bɔsɔnu wukiri, ");
INSERT INTO bba_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kɑ ten ɡɑbu swii, kɑ ten ɡum mɛ mu wɑ̃ɑ yɛ̃sɑɔ kɑ ten buro ɡe ɡɑ woru wukiri, ɡe bɑ koo wĩɑ kɑ ɡɑbu swii sɑnnu. ");
INSERT INTO bba_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Yɑ̃ku kowo u koo ye kpuro dɔ̃ɔ dokewɑ yɑ̃ku yerɔ, kpɑ yɑ n sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","Goo ù n mɑɑ kɑ boo yɑ̃kuru mɔ̀, u koo kɑ ɡu dɑwɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","U koo win nɔmɑ sɔndiwɑ boo ɡen wiru wɔllɔ kuu ten kɔnnɔwɔ, kpɑ u sere ɡu sɑkɑ. Kpɑ yɑ̃ku kowobu bu ɡen yɛm suɑ bu yɛ̃kɑ yɑ̃ku yerun nɔɔ bɔkɑɔ bu kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Wee ye bɑ koo Yinni Gusunɔ dɔ̃ɔ dokeɑ, yerɑ ɡum mɛ mu ɡen bɔsɔ yɑ̃nu tɛ̃ke, ");
INSERT INTO bba_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kɑ ɡɑbu swii yiru kɑ ɡum mɛ mu yi tɛ̃ke kɑ ɡen buro ɡe ɡɑ woru wukiri, ɡe bɑ koo wĩɑ kɑ ɡɑbu swii sɑnnu. ");
INSERT INTO bba_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Yɑ̃ku kowowɑ u koo ye kpuro dɔ̃ɔ doke mu dɔ̃ɔ mwɑɑrɑ. Kpɑ yɑ n sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru tèn nuburɑ koo Yinni Gusunɔ dore. Yen ɡum kpuro mu ko n sɑ̃ɑwɑ Yinni Gusunɔɡim. ");
INSERT INTO bba_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","Yen sɔ̃nɑ bɑɑ ǹ n sɑɑ yeren nɑ, mi i wɑ̃ɑ kpuro, i woodɑ yeni mɛm nɔɔwɔ sere kɑ bɑɑdommɑɔ, yerɑ i ku yɑɑ ɡum di, i ku mɑɑ yen yɛm di. ");
INSERT INTO bba_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","ɑ Isirelibɑ woodɑ yenibɑ sɔ̃ɔwɔ ɑ nɛɛ, ɡoo ù n Yinni Gusunɔn woodɑ ɡɑɑ torɑ u kun yɛ̃, wee ye u koo ko. ");
INSERT INTO bba_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","Ǹ n yɑ̃ku kowon nɑ u torɑ, mɑ win torɑ te, tɑ Isirelibɑ kpuro torɑsiɑ, u koo kɑ kɛtɛ kinɛ kpɛmbu nɑwɑ ɡe ɡɑ ǹ ɑlebu ɡɑɑ mɔ, u ɡo u kɑ win torɑ ten suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","U koo kɑ kɛtɛ ye dɑwɑ Yinni Gusunɔn kurun kɔnnɔwɔ, kpɑ u win nɔmɑ sɔndi yen wiru wɔllɔ u sere ye sɑkɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Yen biru kpɑ u yen yɛm suɑ u kɑ dɑ kuu ten sɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","U koo kɑ mu win niki biɑ dɛkɑwɑ, kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru kuu ten beku kɑre ten berɑ ɡiɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Yen biru u koo yɛm mɛ yɛ̃kɑ kpɑkoro tèn mi bɑ rɑ turɑre dɔ̃ɔ doken kɑ̃ɑnɔ te tɑ wɑ̃ɑ kuu ten sɔɔwɔ, kpɑ u mɛn sukum wisi yɑ̃ku yerun temɔ te tɑ wɑ̃ɑ kuu ten kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","U koo yɑɑ yen ɡum kpuro wunɑ mɛ mu wɑ̃ɑ bɔsɔ yɑ̃nu sɔɔ, ");
INSERT INTO bba_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kɑ yen ɡɑbu swii, kɑ ɡum mɛ mu ɡɑbu swii yi wukiri yɛ̃si yɛ̃sikɑɔ, kɑ buro ɡe ɡɑ woru wukiri, ɡe bɑ koo wĩɑ kɑ ɡɑbu swii sɑnnu. ");
INSERT INTO bba_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Ye bɑ rɑ wĩɛ bɑ̀ n siɑrɑbun yɑ̃kuru mɔ̀ ɡesi, yerɑ bɑ koo mɑɑ wĩɑ yeni sɔɔ. Yen biru yɑ̃ku kowo tɔnwerowɑ u koo ye dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","12","U koo ye yɑ tie kpuro ɡurɑwɑ u kɑ dɑ sɑnsɑnin biruɔ mi bɑ ɡɔsɑ bɑ n dɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun torom kube. Miyɑ u koo yen ɡɔnɑ kɑ yɑɑ ye yɑ tie kpuro dɔ̃ɔ doke torom mɛn wɔllɔ, kɑ yen wiru kɑ yen wɔbunu kɑ yen bɔsɔ yɑ̃nu. ");
INSERT INTO bba_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","Isirelibɑ kpuro bɑ̀ n Gusunɔn woodɑ ɡɑɑ sɑrɑ bɑ ǹ kɑ bɑɑru, bɑ torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Adɑmɑ bɑ̀ n tubɑ mɑ bɑ torɑwɑ mi, bɑ koo nɑɑ kinɛ kpɛmbu ɡowɑ bu kɑ ben torɑ ten suuru kɑnɑ. Bɑ koo kɑ nɑɑ kinɛ te dɑwɑ Yinni Gusunɔn kurun kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Kpɑ Isirelibɑn wiruɡibu bu ben nɔmɑ sɔndi nɑɑ yen wiru wɔllɔ kpɑ ben turo u ye sɑkɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Yɑ̃ku kowo tɔnwerowɑ u koo yen yɛm fiiko suɑ u kɑ dɑ kuu ten mi. ");
INSERT INTO bba_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Sɑɑ ye sɔɔrɑ u koo yɛm mɛ dɛkɑ kɑ win niki biɑ kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru kuu ten beku kɑre ten deedeeru. ");
INSERT INTO bba_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Yen biru, kpɑ u mɑɑ kpɑkoro tèn mi u rɑ turɑre dɔ̃ɔ doken kɑ̃ɑnu yɛm yɛ̃kɑ. Yɛm mɛ mu tie, kpɑ u mu wisi yɑ̃ku yerun temɔ te tɑ wɑ̃ɑ kuu ten kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Yen biru u koo yɑɑ yen ɡum kpuro suɑ u dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Nɡe mɛ u rɑɑ kuɑ win tiin torɑrun sɔ̃, nɡe mɛyɑ u koo ko Isirelibɑ kpuron torɑ ten sɔ̃ kpɑ Gusunɔ u sere bu suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Yen biru kpɑ u kɑ yɑɑ ye yɑ tie dɑ sɑnsɑnin biruɔ kpɑ bu ye doke dɔ̃ɔ sɔɔ nɡe mɛ bɑ rɑɑ kuɑ wi, yɑ̃ku kowon torɑrun sɔ̃. Yɑ̃ku te, tɑ sɑ̃ɑwɑ Isirelibɑ kpuro bu kɑ ben torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","Isirelibɑn wiruɡii ɡoo ù n Gusunɔn woodɑ ɡɑɑ sɑrɑ u ǹ kɑ bɑɑru, u torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Adɑmɑ ù n tubɑ mɑ u torɑ, boo kinɛrɑ u koo ɡo te tɑ ǹ ɑlebu ɡɑɑ mɔ u kɑ yɑ̃kuru ko. Kpɑ Gusunɔ u nùn win torɑ te suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Ù n kɑ boo ɡe nɑ, u koo win nɔmɑ sɔndiwɑ boo ɡen wɔllɔ kpɑ u ɡu sɑkɑ mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinun yɑɑ sɑke. Yɑ̃ku te, tɑ sɑ̃ɑwɑ torɑrun suuruɡiru. ");
INSERT INTO bba_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Yɑ̃ku kowo wi, u koo kɑ win niki biɑ yɛm mɛ dɛkɑwɑ kpɑ u mu yɛ̃kɑ yɑ̃ku yerun kɑ̃ɑnu sɔɔ. Yɛm mɛ mu tie, kpɑ u mu wisi yɑ̃ku yee ten temɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","U koo yɑɑ yen ɡum kpuro suɑwɑ u dɔ̃ɔ doke nɡe mɛ bɑ rɑ siɑrɑbun yɑ̃kuru ko. Nɡe mɛyɑ yɑ̃ku kowo tɔnwero wi, u koo ko u kɑ wiruɡii win torɑrun suuru kɑnɑ. Sɑɑ ye sɔɔ, Gusunɔ u koo nùn tu suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","Tɔn diro ɡoo ù n Gusunɔn woodɑ ɡɑɑ sɑrɑ u ǹ kɑ bɑɑru, u torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Adɑmɑ ù n tubɑ mɑ u torɑwɑ, boo niu ɡe ɡɑ ǹ ɑlebu ɡɑɑ mɔwɑ u koo kɑ yɑ̃kuru ko Gusunɔ u kɑ nùn win torɑru suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","U koo win nɔmɑ sɔndiwɑ boo ɡen wiru wɔllɔ kpɑ u ɡu sɑkɑ mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun yɑɑ sɑke. ");
INSERT INTO bba_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Yen biru, yɑ̃ku kowo u koo nɑ u yɛm mɛ dɛkɑ kɑ win niki biɑ, kpɑ u mu yɛ̃kɑ yɑ̃ku yerun kɑ̃ɑnɔ, kpɑ u yɛm mɛ mu tie wisi yɑ̃ku yee ten temɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Yen biru, bɑ koo yɑɑ yen ɡum kpuro wĩɑwɑ nɡe mɛ bɑ rɑ siɑrɑbun yɑ̃kuruɡim wĩɛ. Kpɑ yɑ̃ku kowo u mu dɔ̃ɔ mɛni, kpɑ mɛn nuburu tu Yinni Gusunɔ dore. Nɡe mɛyɑ yɑ̃ku kowo wi, u koo kɑ toro wi suuru kɑnɑ. Sɑɑ ye sɔɔ, Gusunɔ u koo nùn suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","Toro wi, ù n mɑɑ kĩn nɑ, u kɑ yɑ̃ɑ kpɛndu yɑ̃kuru ko, yɑ̃ɑ nirɑ u koo kɑ nɑ u ɡo, te tɑ ǹ ɑlebu mɔ, u kɑ win torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Ù n kĩ u tu ɡo, u koo win nɔmɑ sɔndiwɑ ten wiru wɔllɔ kpɑ u tu sɑkɑ mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun yɑɑ ɡo. ");
INSERT INTO bba_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Yen biru yɑ̃ku kowo u koo yɛm mɛ dɛkɑ kɑ win niki biɑ u mu yɛ̃kɑ yɑ̃ku yerun kɑ̃ɑnɔ. Yɛm mɛ mu tie kpɑ u mu wisi sɑ̃ɑ yee ten temɔ. ");
INSERT INTO bba_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Yen biru u koo yen ɡum wĩɑwɑ nɡe mɛ bɑ rɑ siɑrɑbun yɑ̃kuruɡim wĩɛ. Yɑ̃ku kowowɑ u koo mɛ kpuro dɔ̃ɔ doke kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru sɑnnu. Nɡe mɛyɑ yɑ̃ku kowo wi, u koo ko u kɑ toro wi suuru kɑnɑ. Sɑɑ ye sɔɔrɑ Yinni Gusunɔ u koo nùn win torɑ te suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","Su tɛ̃ nɛɛ, ɡoo u bɔ̃ruɑ mɑ u koo seedɑ di ɡɑ̃ɑ ni u wɑn sɔ̃, ɑdɑmɑ u ǹ ɡeruɑ ye u wɑ, ǹ kun mɛ ye u yɛ̃. Sɑɑ ye sɔɔ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Su tɛ̃ kpɑm nɛɛ, ɡoo u ɡɑ̃ɑnu bɑbɑ ye yɑ disi mɔ u kun kɑ bɑɑru, ɑɑ, yɑɑ sɑbe te bɑ ku rɑ din ɡorɑ? Ǹ kun mɛ ɡbeeku yɑɑ ye bɑ ku rɑ din ɡorɑ? Ǹ kun mɛ yɑɑ ye yɑ rɑ kɑbirin ɡorɑ? Sɑɑ ye sɔɔ, yɛ̃ro u disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Su mɑɑ tɛ̃ nɛɛ, ɡoo ù n win winsim bɑbɑ wi u disi ɡɛɛ mɔ yi yi koo nùn tiɑ, n deemɑ u ǹ yɛ̃, mɑ u rɑ ye tubɑ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Torɑru ɡɑru wee mɑɑ. Su tɛ̃ nɛɛ, ɡoo u bɔ̃ruɑ u win winsim kɔ̃sɑ kuɑ ǹ kun mɛ u nùn ɡeɑ kuɑ, u ǹ bwisikɑ, ù n deemɑ ɡɑri yi, ɡɑri ɡiriyɑ u ɡeruɑ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Goo ù n torɑ nin ɡɑru kuɑ, u koo yen tuubɑ kowɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Adɑmɑ u sere torɑ ten suuru wɑ, u koo yɑ̃ɑ niru ǹ kun mɛ boo niu ɡowɑ u kɑ Yinni Gusunɔ yɑ̃kuru kuɑ. Yen biru yɑ̃ku kowo u koo nùn suuru kɑnɑbun wororu koosi, kpɑ u sere win torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","Goo ù kun kpɛ̃ u yɑ̃ɑ niru ǹ kun mɛ boo niu wɑ u kɑ torɑrun yɑ̃kuru ko, u koo kpĩ u kpɑrukonu yiru ǹ kun mɛ totobɛrɛnu yiru kɑsu. Gunɔ ɡen teuwɑ bɑ koo kɑ torɑrun yɑ̃kuru ko. Kpɑ bu mɑɑ kɑ teu ɡeni yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Bɑ koo ɡinɑ yɑ̃ku kowo wi ɡunɔ ɡe wɛ̃wɑ ɡe bɑ kɑ torɑrun suuru kɑnɑbu nɑ mi, kpɑ u ɡen wĩiru buɑ u kun sɔsie. ");
INSERT INTO bba_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Kpɑ u ɡen yɛm dɛkɑ u yɛ̃ke yɑ̃ku yerun nɔɔ bɔkɑɔ, mɛ mu tie kpɑ u wisi ten temɔ. Yɑ ko n sɑ̃ɑwɑ torɑrun yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Yen biru yɑ̃ku kowo u koo ɡunɔ yiruse suɑ nɡe mɛ woodɑ yɑ ɡeruɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ɡɑru ko. Kpɑ u nùn suuru kɑnɑbun wororu koosi. Nɡe mɛyɑ Gusunɔ u koo kɑ yɛ̃ro suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","Goo ù kun kpɛ̃ u kpɑrukonu yiru ye wɑ, ǹ kun mɛ totobɛrɛnu yiru ye, u kɑ som buuru kilo nnɛ nɑ u kɑ yɑ̃kuru ko kpɑ u kɑ win torɑrun suuru wɑ. Adɑmɑ u ku mu ɡum doke, u ku mɑɑ mu turɑre doke, domi u kɑ mu nɑwɑ u kɑ win torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","U koo kɑ som mɛ dɑwɑ yɑ̃ku kowon mi kpɑ yɑ̃ku kowo wi, u mɛn nɔm kure teeru sɔkɑ u dɔ̃ɔ doke mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. Som nɔm kure tee te, tɑ koo de Yinni Gusunɔ u n yɛ̃ro yɑɑye. Yɑ̃ku terɑ tɑ koo de u win torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Sɑɑ ye sɔɔ, yɑ̃ku kowo wi, u koo wi u torɑ suuru kɑnɑbun wororu koosi. Kpɑ Gusunɔ u nùn win torɑrun suuru kuɑ. Kpɑ yɑ̃ku kowo u mɛ mu tie suɑ win tiin sɔ̃, nɡe ɡberun dĩɑnun yɑ̃kunu. ");
INSERT INTO bba_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","ɡoo ù n ɡɑ̃ɑnu nɛni ni n weenɛ u Yinni Gusunɔn wɛ̃, mɑ u ǹ yɛ̃ mɑ Yinni Gusunɔɡinɑ, wee ye u koo ko win torɑ ten sɔ̃. Kɑɑ nùn yɑ̃ɑ kinɛru te tɑ ǹ ɑlebu ɡɑɑ mɔn ɡeeru burɑwɑ te u koo kɑsu u kɑ nɑ u kɑ torɑrun sɔmbun yɑ̃kuru ko. Kɑɑ ten ɡee te burɑwɑ kɑ sii ɡeesun ɡobi yi bɑ rɑ di Yinni Gusunɔn kuu bekuruɡirɔ. ");
INSERT INTO bba_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Kpɑ u kɑ ɡɑ̃ɑ ni u nɛni mi nɑ. Yen biruwɑ u koo mɑɑ kɑ nin bɔnu nɔɔbusen tiɑ nɑ. Yɑ̃ku kowowɑ u koo ye wɛ̃. Yɑ̃ku kowo wiyɑ u koo nùn torɑrun yɑ̃kuru kuɑ, kpɑ u sere suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","Goo ù n Yinni Gusunɔn woodɑ ɡɑɑ sɑrɑ, bɑɑ u kun yɛ̃, u torɑwɑ mi. Yen torɑrɑ ko n nùn wɑ̃ɑsiwɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Yen sɔ̃, u koo kɑ yɑ̃ɑ kinɛru te tɑ ǹ ɑlebu ɡɑɑ mɔ dɑwɑ yɑ̃ku kowon mi, win torɑ ten sɔ̃ nɡe mɛ n weenɛ u kɔsiɑ. Kpɑ yɑ̃ku kowo u nùn suuru kɑnɑbun wororu koosi. Sɑɑ ye sɔɔrɑ Gusunɔ u koo nùn suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Yɑ ko n sɑ̃ɑwɑ torɑrun sɔmbun yɑ̃kuru. Domi yɛ̃ro u Yinni Gusunɔ torɑriwɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_20","004_5_20","LEV","5","20","20","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV5_21","004_5_21","LEV","5","21","21","ɡoo ù n win winsim weesu kuɑ ɡɑ̃ɑ ni u nùn berusie sɔɔ, ǹ kun mɛ u bɔkurɑ, ǹ kun mɛ u ɡbɛnɑ, ǹ kun mɛ u kɑwɑ, ");
INSERT INTO bba_vpl VALUES ("LV5_22","004_5_22","LEV","5","22","22","ǹ kun mɛ u ɡɑ̃ɑnu dɔbɑ mɑ u siki, ǹ kun mɛ u bɔ̃ri weesuɡii kuɑ, ");
INSERT INTO bba_vpl VALUES ("LV5_23","004_5_23","LEV","5","23","23","tɔnu win bweseru u Yinni Gusunɔ torɑriwɑ mi. U koo ɡɑ̃ɑ ni u ɡbɛnɑ mi wesiɑ, ǹ kun mɛ ni u kɑwɑ mi, ǹ kun mɛ ye bɑ nùn berusiɑ mi, ǹ kun mɛ ye u dɔbɑ mɑ u siki, ");
INSERT INTO bba_vpl VALUES ("LV5_24","004_5_24","LEV","5","24","24","ǹ kun mɛ yèn bɔ̃ri u kuɑ mi. Adɑmɑ n ǹ mɔ ye tɔnɑ u koo wesiɑ. U koo mɑɑ yen bɔnu nɔɔbusen tiɑ kɔsiɑwɑ dɔmɑ te u koo win torɑrun sɔmbun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV5_25","004_5_25","LEV","5","25","25","U koo kɑ yɑ̃ɑ kinɛru dɑwɑ yɑ̃ku kowon mi, te tɑ ɡɑ̃ɑ nin ɡobin sɑkɑ turɑ bu kɑ ye Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV5_26","004_5_26","LEV","5","26","26","Yinni Gusunɔn wuswɑɑɔrɑ yɑ̃ku kowo u koo nùn suuru kɑnɑbun wororu koosi. Yen biru Gusunɔ u koo yɛ̃ro suuru kuɑ, bɑɑ ǹ n mɛren nɑ win torɑrɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","ɑ Aroni kɑ win bibu woodɑ yeni wɛ̃ɛyɔ ɑ nɛɛ, wee ye yɑ sɑ̃ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun woodɑ. Ten yɑ̃ku yɑɑ yɑ ko n wɑ̃ɑwɑ dɔ̃ɔ sɔɔ wɔ̃ku ɡiriru, kpɑ bu ku de dɔ̃ɔ wi, u ɡbi sere yɑm mu kɑ sɑ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","Yen biru yɑ̃ku kowo u koo win tɑko sebewɑ kɑ win sokoto kpiriru kpɑ u yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii ten torom ɡurɑ u yi yɑ̃ku yee ten bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","Yen biruwɑ u koo win yɑ̃ɑ ni potɑ kpɑ u kpɑɑnu doke u sere torom mɛ suɑ u kɑ yɑri sɑnsɑnin di. Kpɑ u kɑ mu dɑ yɑm mi bɑ ɡɔsɑ mɛn sɔ̃ u yi mi. ");
INSERT INTO bba_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","Dɔ̃ɔ wi u mwɑɑrɑmɔ yɑ̃ku yee ten mi, bɑ ǹ koo de u ɡbi pɑi! Bururu bɑɑtere yɑ̃ku kowo u ko n dɑ tu dɑ̃ɑ dokewɑ. Yen wɔllɔwɑ u koo yɑ̃ku yɑɑ sɔndi kɑ sere siɑrɑbun yɑ̃ku ɡum. ");
INSERT INTO bba_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Dɔ̃ɔ u ko n wɑ̃ɑwɑ yɑ̃ku yee te sɔɔ sere kɑ bɑɑdommɑɔ, bɑ ǹ koo de u ɡbi. ");
INSERT INTO bba_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Yɑ̃ku te bɑ rɑ ko kɑ ɡberun dĩɑnun woodɑ wee. Aronin bibɑ bɑ ko n dɑ kɑ tu de yɑ̃ku yerɔ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Kpɑ ben wi u yɑ̃kuru mɔ̀ dɔmɑ te, u som nɔm kure teeru sɔkɑ mɛ bɑ kɑ yɑ̃kuru nɑ mɛ bɑ ɡum wisi, kɑ turɑre kpuro, kpɑ bu ye kpuro mɛnnɑ bu dɔ̃ɔ doke kpɑ ten nuburu tu Gusunɔ dore kpɑ u n yɛ̃ro yɑɑye. ");
INSERT INTO bba_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","10","Som mɛ mu tiɑrɑ Aroni kɑ win bibɑ bɑ koo mɛ di. Yerɑ yɑ ko n sɑ̃ɑ beɡiɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru sɔɔ. Adɑmɑ bɑ koo mu diwɑ Yinni Gusunɔn kuu bekuruɡirun yɑɑrɑɔ. Bɑ ǹ mɛ pɛ̃ɛ seeyɑtiɑ dokemɔ. Yɑ sɑ̃ɑwɑ nɛnɛm nɡe yɑ̃ku te bɑ kuɑ bu kɑ torɑrun suuru wɑn dĩɑnu, ǹ kun mɛ te bɑ rɑ kɑ torɑru sɔmɛn dĩɑnu. ");
INSERT INTO bba_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Aronin bii tɔn durɔ bɑɑwurewɑ u koo dĩɑ ni di. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ win bibun bweseru sɔɔ sere kɑ bɑɑdommɑɔ. Tɔn tuko wi u koo nu bɑbɑ kpuro u koo ɡbiwɑ. ");
INSERT INTO bba_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, yɑ̃ku te Aroni kɑ win bibu bɑ koo Yinni Gusunɔ kuɑ wee. ");
INSERT INTO bba_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Bɑ̀ n Aroni kɑ win bibu tusiɑ mɑ bɑ kuɑ nɛn yɑ̃ku kowobu, sɑɑ dɔmɑ ten diyɑ bɑ ko n dɑ som kilo itɑ kɑ yɑ̃kuru ko tɔ̃ɔ bɑɑtere, tiɑ kɑ bɔnu bururu, yokɑ mɑɑ tiɑ kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","Bɑ koo som mɛ mɔmwɑ buturu buturu, kpɑ bu mɛ sɔmɛ siru sɔɔ kɑ ɡum, kpɑ mɛn nuburu tu nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Yɑ̃ku kowo wi bɑ ɡum tɑ̃re bɑ ɡɔsɑ Aronin bibu sɔɔ u kɑ nùn kɔsire ko, win tii u koo tu kowɑ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ nɛ, Yinni Gusunɔn sɔ̃. Bɑ koo som mɛ dɔ̃ɔ dokewɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Yɑ̃ku te yɑ̃ku kowon tii u kuɑ, bɑ koo de tu dɔ̃ɔ mwɑɑrɑwɑ mɑm mɑm, bɑ ǹ koo tu di. ");
INSERT INTO bba_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, yɑ̃ku te bɑ koo ko bu kɑ suuru kɑnɑn woodɑ wee. Yɑm mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun yɑ̃ku yɑɑ sɑke, miyɑ bɑ koo yɑ̃ku tenin yɑɑ sɑkɑ. Yɑ ko n sɑ̃ɑwɑ ɡɑ̃ɑ dɛɛrɑnu. ");
INSERT INTO bba_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Yɑ̃ku kowo wi u koo yɑ̃ku te ko wiyɑ u koo ye di. U koo ye diwɑ yɑm dɛɛrɑmɔ, kuu ten yɑɑrɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","Tɔn tuko wi u koo yɑ̃ku yɑɑ ye bɑbɑ kpuro u koo ɡbiwɑ. Yɑ̃ku yɑɑ yen yɛm mù n wisi win yɑberɔ u koo tu teɑwɑ yɑm dɛɛrɑm mi. ");
INSERT INTO bba_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bɑ̀ n tu sɑwɑ wekeru sɔɔ te bɑ kuɑ kɑ sɔndu, bɑ koo weke te kɔrɑwɑ. Ǹ n mɑɑ weke te bɑ kuɑ kɑ sii ɡɑndun nɑ, bɑ koo tu teɑwɑ sɑ̃ɑ sɑ̃ɑ kɑ nim. ");
INSERT INTO bba_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Yɑ̃ku kowo tɔn durɔ bɑɑwurewɑ u koo kpĩ u tu di domi tɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu. ");
INSERT INTO bba_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Adɑmɑ bɑ ǹ koo torɑrun yɑ̃ku yɑɑ tem tèn yɛm bɑ kɑ duɑ sɑ̃ɑ yerɔ. Bɑ koo ye dɔ̃ɔ dokewɑ yu dɔ̃ɔ mwɑɑrɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, yɑ̃ku te bɑ rɑ ko bu kɑ torɑru sɔmɛn woodɑ wee. Yɑ̃ku te, tɑ ko n sɑ̃ɑwɑ yɑ̃ku dɛɛrɑru. ");
INSERT INTO bba_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Mi bɑ rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun yɑɑ sɑke, miyɑ bɑ koo mɑɑ ten yɑɑ sɑkɑ, kpɑ bu yɑɑ yen yɛm yɛ̃kɑ yɑ̃ku yerun nɔɔ bɔkɑɔ bu kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Yɑɑn mi bɑ koo kɑ Yinni Gusunɔ yɑ̃kuru kuɑ wee, yerɑ yen ɡum kpuro, kɑ yen siru kɑ bɔsɔ yɑ̃nun ɡum, ");
INSERT INTO bba_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kɑ yen ɡɑbu swii yiru, kɑ ɡum mɛ mu yi tɛ̃ke yɛ̃si yɛ̃sikɑ, kɑ yen buro ɡe ɡɑ woru wukiri. ");
INSERT INTO bba_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Yɑ̃ku kowo u koo ye kpuro dɔ̃ɔ dokewɑ yɑ̃ku yerɔ Yinni Gusunɔn sɔ̃. Yɑ̃ku te, tɑ sɑ̃ɑwɑ te tɑ koo torɑru sɔmɛ. ");
INSERT INTO bba_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Yɑ̃ku kowo tɔn durɔ bɑɑwurewɑ u koo tu di. Bɑ koo tu diwɑ yɑm dɛɛrɑmɔ domi tɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu. ");
INSERT INTO bba_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","Yen woodɑ ye, yɑ sɑ̃ɑwɑ tiɑ kɑ torɑrun yɑ̃kuruɡiɑ. Yɑ̃ku kowo wi u yɑ̃ku te kuɑ, wiyɑ u yen yɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Goo ù n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ, yɑ̃ku kowo wi u nùn tu kuɑ wiyɑ u ten ɡɔnɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Yɑ̃ku te bɑ kuɑ kɑ ɡberun dĩɑnu bɑ wɔ̃ɔwɑwɑ? Aɑwo, bɑ sɔnwɑwɑ? Yɑ̃ku kowo wi u tu kuɑ wiyɑ u tu mɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Adɑmɑ ni bɑ kɑ ɡum burinɑ kɑ ni bɑ ǹ yeesie, bɑ koo nu Aronin bibu bɔnu kuɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","Siɑrɑbun yɑ̃kurun woodɑ wee. ");
INSERT INTO bba_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀, u koo kirɑ bwesenu itɑ kowɑ. U koo ɡbiikinu ko kɑ ɡum nu kun seeyɑtiɑ mɔ, kpɑ u yirusenun som ɡum yɛ̃kɑ nu kun seeyɑtiɑ mɔ, kpɑ u itɑsenun som burinɑ kɑ ɡum u sɔmɛ. ");
INSERT INTO bba_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kirɑ nin biru, u koo pɛ̃ɛ ye bɑ seeyɑtiɑ doke sosi mi, kɑ sere win siɑrɑbun yɑ̃kunun yɑɑ. ");
INSERT INTO bba_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Bɑ koo yɑ̃ku dĩɑ nin bɑɑniren sukum suɑwɑ wɔllɔ bu Yinni Gusunɔ sɔ̃ɔsi. Yerɑ yɑ ko n sɑ̃ɑ wi u yɛm yɛ̃kɑɡinu. ");
INSERT INTO bba_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Dɔmɑ te bɑ siɑrɑ bin yɑ̃kuru kuɑ, yen dɔmɑ terɑ bɑ koo ten yɑɑ di, bɑ ǹ koo de ten yɑɑ yu yɑm sɑ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","Adɑmɑ ɡoo ù n yɑ̃kuru kuɑ u kɑ win nɔɔ mwɛɛru yibiɑ ǹ kun mɛ win tii ù n ɡɔ̃ru doke u kɑ nɛ, Yinni Gusunɔ kɛ̃ru wɛ̃, u koo kpĩ u ten yɑɑn sukum di yen tɔ̃ɔ te, kpɑ u sukum yi sere sisiru. ");
INSERT INTO bba_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Adɑmɑ yɑ̀ n mɑɑ wure yɑ tiɑrɑ sɔ̃ɔ itɑseru bɑ koo ye dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bba_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Goo ù n siɑrɑbun yɑ̃ku yɑɑ ye yɑ tiɑrɑ sere sɔ̃ɔ itɑ temɑ, Gusunɔ kun mɑɑ yɛ̃ron yɑ̃ku te mwɑɑmɔ. U win yɑ̃kuru ɡɑrisiwɑ mi kɑm domi yɑɑ ye, yɑ disi duurɑ. Wì u mɑɑ ye temɑ, yɛ̃ro u torɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","Mɛyɑ bɑ̀ n mɑɑ kɑ yɑ̃ku yɑɑ ɡɑ̃ɑnu bɑbɑ ni nu disi mɔ, bɑ koo ye dɔ̃ɔ mɛniwɑ, bɑ ǹ ye dimɔ. Wi u kun disi mɔ, wiyɑ koo yɑ̃ku yɑɑ tem, ");
INSERT INTO bba_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ɑdɑmɑ ɡoo ù n wɑ̃ɑ disi ɡɛɛ sɔɔ u kɑ siɑrɑbun yɑ̃kuru dimɔ te bɑ Yinni Gusunɔ kuɑ, bɑ koo yɛ̃ro ɡirɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Goo ù n mɑɑ tɔnu bɑbɑ wi u disi mɔ, ǹ kun mɛ yɑɑ ɡɑɑ ye yɑ sɑ̃ɑ seseru, ǹ kun mɛ ɡɑ̃ɑnu ɡɑnu ni nu disi mɔ, mɑ u kɑ siɑrɑbun yɑ̃kuru di te bɑ Yinni Gusunɔ kuɑ bɑ koo yɛ̃ro ɡirɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bu ku yɑɑ ɡɑɑn ɡum di nɡe yɑ̃ɑru ǹ kun mɛ kɛtɛ, ǹ kun mɛ boo. Bu ku yen ɡɑɑn ɡum di. ");
INSERT INTO bba_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Sɑbe te ɡbeeku yɑɑ yɑ ɡo, ǹ kun mɛ te tɑ ɡu, i ko i kpĩ i kɑ ten ɡum ɡɑ̃ɑnu ko. Adɑmɑ i ǹ mu dimɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Goo ù n yɑ̃kurun yɑɑn ɡum di mɛ bɑ kɑ Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ, bɑ koo yɛ̃ro ɡirɑwɑ wiɡibun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","I ku ɡunɔ ɡɑɡun yɛm di ǹ kun mɛ yɑɑ ɡɑɑ, bɑɑ mi i dɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Wi u mu di, bɑ koo yɛ̃ro ɡirɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","ɑ Isirelibɑ woodɑ yeni wɛ̃ɛyɔ ɑ nɛɛ, ɡoo ù n nɛ Yinni Gusunɔ siɑrɑbun yɑ̃kuru kuɑmmɛ, u koo wunɑwɑ ye yɑ sɑ̃ɑ nɛɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Win tiiwɑ u koo kɑ nɛ, Yinni Gusunɔ yen ɡum kɑ yen ɡuro ɡuroru nɑɑwɑ u kpɑrɑ nɛn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Yɑ̃ku kowowɑ u koo yen ɡum mɛ dɔ̃ɔ doke yɑ̃ku yerɔ. Adɑmɑ yɑɑ ɡuro ɡuro te, tɑ ko n sɑ̃ɑwɑ Aroni kɑ win bibuɡiru. ");
INSERT INTO bba_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Yɑ̃ku yɑɑ yen nɔmu nɔm ɡeuɡuu ɡɑ ko n mɑɑ sɑ̃ɑwɑ Aroni kɑ win bibuɡuu. ");
INSERT INTO bba_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Yɑɑ nɔmu ɡe, ɡɑ ko n sɑ̃ɑwɑ Aronin biiɡuu wi u yɛm yɛ̃kɑ mɑ u yɑɑ ɡum mɛ doke yɑ̃ku yerɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Yɑɑ nɔmu ɡe, ɡe bɑ mɑn sɔ̃ɔsi, kɑ yen ɡuro ɡuro te bɑ kpɑrɑ nɛn wuswɑɑɔ sɑnɑm mɛ bɑ siɑrɑbun yɑ̃kuru mɔ̀ mi, yerɑ yɑ ko n dɑ n sɑ̃ɑ Aroni kɑ win bibuɡiɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu sɔɔ, yeniwɑ yɑ ko n sɑ̃ɑ Aroni kɑ win bibuɡiɑ dɔmɑ tèn di bɑ koo bu ɡum tɑ̃re bu kɑ ko yɑ̃ku kowobu. ");
INSERT INTO bba_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Woodɑ yerɑ Yinni Gusunɔ u Isirelibɑ wɛ̃ɛmɔ bu kɑ Aroni kɑ win bibu yɑɑ ye wɛ̃ sɑɑ dɔmɑ tèn di bɑ bu ɡum tɑ̃re bu kɑ ko yɑ̃ku kowobu. Bɑ ko n dɑ bu ye kuewɑ sere kɑ ben bibun bweserɔ. ");
INSERT INTO bba_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Nɡe mɛyɑ bɑ ko n dɑ ko bɑ̀ n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀, ǹ kun mɛ bɑ̀ n yɑ̃kuru mɔ̀ kɑ ɡberun dĩɑnu, ǹ kun mɛ bɑ̀ n torɑrun yɑ̃kuru mɔ̀, ǹ kun mɛ bɑ̀ n yɑ̃kuru mɔ̀ te bɑ rɑ kɑ torɑru sɔmɛ, ǹ kun mɛ te bɑ rɑ ko bu kɑ tɔnu ɡum tɑ̃re u sere sɔmburu tore, ǹ kun mɛ bɑ̀ n siɑrɑbun yɑ̃kuru mɔ̀. ");
INSERT INTO bba_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Yinni Gusunɔwɑ u Mɔwisi woodɑ yeni wɛ̃ ɡbɑburɔ, Sinɑin ɡuurɔ, tɔ̃ɔ te u bu woodɑ wɛ̃ bu kɑ nùn yɑ̃kunu kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","3","ɑ Aroni kɑ win bibu sokuo Yinni Gusunɔn kurun kɔnnɔwɔ. Kpɑ ɑ de bu kɑ ben yɑ̃ku yɑ̃nu nɑ kɑ ɡum mɛ bɑ rɑ ɡɑ̃ɑnu tɑ̃re bu kɑ nu ɡɔsi Yinni Gusunɔn sɔ̃ kɑ nɑɑ kinɛ te bɑ koo kɑ torɑrun yɑ̃kuru ko kɑ yɑ̃ɑ kinɛnu yiru kɑ bire te tɑ pɛ̃ɛ mɔ ye bɑ ǹ seeyɑtiɑ doke. A mɑɑ Isirelibɑ kpuro mɛnnɔ mi. ");
INSERT INTO bba_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Mɑ Mɔwisi u Yinni Gusunɔn ɡɑri yi wurɑ u Isirelibɑ kpuro mɛnnɑ sɑ̃ɑ yee ten kɔnnɔ mi. ");
INSERT INTO bba_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Mɑ u bu sɔ̃ɔwɑ u nɛɛ, wee ye Yinni Gusunɔ u ɡeruɑ su ko. ");
INSERT INTO bba_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Mɑ u derɑ Aroni kɑ win bibu bɑ nɑ u bu woburɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Mɑ u Aroni win tɑko sebusiɑ kɑ sɛ̃kɑtiɑ ye, kɑ yɑbe booɡuɡii te, kɑ yɑbe tɑrɑkpe ɡe, ɡe u ɡbinisi yɑbe booɡuɡii te sɔɔ kɑ ɡen sɛ̃kɑtiɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Mɑ u bɔɔ bɑrɑ ye sɔndi win tororu wɔllɔ. Mɑ u urimu kɑ tumimu doke bɔɔ bɑrɑ yen sɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Mɑ u dɑwɑni ye bɔkuɑ win wirɔ. Mɑ u wurɑn bɑtɑni ye mɑni nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Mɔwisi u ɡum mɛ suɑ u sɑ̃ɑ yee te yɛ̃kɑ kɑ ten dendi yɑ̃nu kpuro, mɑ tɑ kuɑ nɛnɛm Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Mɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru yɑ̃ku yerun wɔllɔ, kɑ ten dendi yɑ̃nɔ kɑ boo sii ɡɑnduɡuu ɡe, kɑ ɡen yɔ̃rɑtiiyɔ, ye kpuro yɑ n kɑ sɑ̃ɑ Gusunɔn kuu bekuruɡiruɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Mɑ u Aroni ɡum mɛ tɑ̃re wirɔ u kɑ nùn wunɑ nɛnɛm u ko yɑ̃ku kowo. ");
INSERT INTO bba_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Yen biru Mɔwisi u mɑɑ Aronin bibu sokɑ u bu tɑkobɑ dokeɑ kɑ sɛ̃kɑtii kɑ furɔsu nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Mɔwisi u mɑɑ kɑ nɑɑ kinɛru nɑ te bɑ koo kɑ torɑrun yɑ̃kuru ko. Mɑ Aroni kɑ win bibu bɑ ben nɔmɑ sɔndi nɑɑ kinɛ ten wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Mɑ Mɔwisi u ye sɑkɑ u yen yɛm dɛkɑ kɑ win niki biɑ u tɛɛni yɑ̃ku yerun kɑ̃ɑnu wɔllɔ kɑ sere mɑɑ ten nɔɔ bɔkɑɔ u kɑ sikerenɑ. Nɡe mɛyɑ u kɑ kuu te dɛɛrɑsiɑ. Mɑ u mɑɑ yɛm yɛ̃kɑ kuu ten temɔ. Nɡe mɛyɑ u kɑ kuu te kuɑ nɛnɛm tèn mi bɑ ko n dɑ torɑnun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Mɑ u yen ɡum mɛ suɑ mɛ mu bɔsɔ yɑ̃nu tɛ̃ke kɑ yen buro ɡe ɡɑ woru wukiri kɑ yen ɡɑbu swii yiru ye, kɑ yin ɡum sɑnnu. Ye kpurowɑ u dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Adɑmɑ u nɑɑ kinɛ ten tii kɑ ten bisu kɑ ten ɡɔnɑ yɑrɑwɑ tɔɔwɔ u dɔ̃ɔ doke nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","U mɑɑ kɑ yɑ̃ɑ kinɛru nɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun sɔ̃. Mɑ Aroni kɑ win bibu bɑ ben nɔmɑ sɔndi yɑ̃ɑ ten wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Mɑ Mɔwisi u tu sɑkɑ u ten yɛm yɛ̃kɑ u kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Mɑ u yɑ̃ɑ ten yɑɑ bɔɔrɑ, yen biru u ten wiru dɔ̃ɔ doke kɑ ten ɡum kɑ yɑɑ ye u mururɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Mɑ u ten nuki kɑ ten kɔ̃ri teɑ kɑ nim. Mɑ u yɑ̃ɑ kinɛ ten yɑɑ doke dɔ̃ɔ sɔɔ yɑ̃ku yeru wɔllɔ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. Mɑ yɑ̃ku ten nuburɑ Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Yen biru u mɑɑ kɑ yɑ̃ɑ kinɛru yiruse nɑ te bɑ koo kɑ Aroni kɑ win bibu tusiɑ mɑ bɑ sɑ̃ɑ yɑ̃ku kowobu. Aroni kɑ win bibu bɑ ben nɔmɑ sɔndi yɑ̃ɑ ten wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Mɑ Mɔwisi u tu sɑkɑ, u ten yɛm suɑ u tɛɛni Aronin soo nɔm ɡeuɡuuɔ kɑ nɔm ɡeun niki bii bɑkɑɔ kɑ mɑɑ win nɔɔ nɔm ɡeuɡuun niki bii bɑkɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Mɑ u mɑɑ Aronin bibu sokɑ u bu yɑɑ yɛm mɛ tɛɛni ben soo nɔm ɡeuɡisɔ, kɑ mɑɑ nɔm ɡeun niki bii bɑkɑnɔ kɑ ben nɑɑ nɔm ɡeuɡisun niki bii bɑkɑnɔ. Mɑ u yɛm mɛ mu tie yɛ̃kɑ yɑ̃ku yee ten nɔɔ bɔkɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Mɑ u yen ɡum suɑ kɑ yen siru kɑ yen nukin ɡum kɑ yen buro kɑ yen ɡɑbu swii kɑ sere yen nɔm ɡeu. ");
INSERT INTO bba_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Mɑ u pɛ̃ɛ suɑ bireru sɔɔ ye bɑ ǹ seeyɑtiɑ doke kɑ kirɑ te bɑ kuɑ kɑ ɡum kɑ sere mɑɑ kirɑ sɔndɑnu. Mɑ u ye kpuro sɔndi yɑɑ ɡum mɛn wɔllɔ kɑ yɑ̃ɑ nɔmu ɡen wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Yen biru u ye Aroni kɑ win bibu wɛ̃. Mɑ u nɛɛ, bu ye Yinni Gusunɔ wɛ̃ɛyɔ. Kpɑ bu ye sɔ̃ɔsi beri berikɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Yen biru u ye kpuro mwɑ ben nɔmɑn di u dɔ̃ɔ mɛni yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii ten wɔllɔ. Mɑ yen nuburɑ Yinni Gusunɔ dore. Nɡe mɛyɑ bɑ kɑ Aroni kɑ win bibu wunɑ nɛnɛm. ");
INSERT INTO bba_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Mɑ Mɔwisi u yɑ̃ɑ ten ɡuro ɡuroru suɑ u tu sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. Mɑ tɑ kuɑ Mɔwisiɡiru nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Mɔwisi u ɡum mɛ suɑ kɑ yɛm fiiko mɛ mu wɑ̃ɑ yɑ̃ku yeru wɔllɔ, mɑ u mu Aroni yɛ̃kɑ kɑ win sɑ̃ɑ yɑ̃nɔ kɑ sere mɑɑ win bibun wɔllɔ kɑ ben sɑ̃ɑ yɑ̃nu sɔɔ. Nɡe mɛyɑ u kɑ ye kpuro dɛɛrɑsiɑ u yi nɛnɛm. ");
INSERT INTO bba_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Mɑ Mɔwisi u Aroni kɑ win bibu sɔ̃ɔwɑ u nɛɛ, i yɑ̃ku yɑɑ ye sɑɑwo Yinni Gusunɔn wuswɑɑɔ. Miyɑ i ko i ye di kɑ pɛ̃ɛ ye yɑ wɑ̃ɑ bire te sɔɔ. Bɛɛyɑ i ko ye di nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Yɑɑ kɑ pɛ̃ɛ ye yɑ tiɑrɑ, i ko ye kpuro dokewɑ dɔ̃ɔ sɔɔ yu dɔ̃ɔ mwɑɑrɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","I ko i n wɑ̃ɑwɑ kuu ten kɔnnɔ mi sere sɔ̃ɔ nɔɔbɑ yiru. I ǹ yɑriɔ min di. Domi sɔ̃ɔ nɔɔbɑ yiruwɑ i ko i ko bɑ n bɛɛ tusiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Yinni Gusunɔwɑ u yenin woodɑ wɛ̃ i n dɑ ko nɡe mɛ i wɑ sɑ kuɑ ɡisɔ i kɑ bɛɛn torɑnun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Ǹ n mɛn nɑ, i ko i sinɑwɑ kuu ten kɔnnɔ mi sere sɔ̃ɔ nɔɔbɑ yiru, wɔ̃kuru kɑ sɔ̃ɔ sɔɔ. Kpɑ i win woodɑbɑ mɛm nɔɔwɑ i ku rɑ kɑ ɡbin sɔ̃. Woodɑ be Yinni Gusunɔ u mɑn wɛ̃ berɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Mɑ Aroni kɑ win bibu kpuro bɑ kuɑ ye Yinni Gusunɔ u bu yiire sɑɑ Mɔwisin min di. ");
INSERT INTO bba_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Sɔ̃ɔ nɔɔbɑ itɑse, Mɔwisi u Aroni kɑ win bibu sokɑ kɑ sere Isirelibɑn ɡuro ɡurobu. ");
INSERT INTO bba_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","U Aroni sɔ̃ɔwɑ u nɛɛ, ɑ nɑɑ kinɛ kpɛndu suo ɑ kɑ yɑ̃kuru ko wunɛn torɑrun sɔ̃, kpɑ ɑ yɑ̃ɑ kinɛru kɑsu ɑ kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. A ǹ kɑɑ de yen ɡɑɑ yɑ n ɑlebu mɔ. Kpɑ ɑ kɑ ye kpuro Yinni Gusunɔ yɑ̃kuru kuɑ sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Yen biru kɑɑ Isirelibɑ sɔ̃ ɑ nɛɛ, bu boo kinɛru suo ben torɑrun yɑ̃kurun sɔ̃ kɑ nɑɑ buu kɑ yɑ̃ɑru ye kpuro yɑ n wɔ̃ɔ tiɑ tiɑ mɔ, kpɑ yɑ kun ɑlebu ɡɑɑ mɔ. Bɑ koo kɑ ye yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kowɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Kpɑ ɑ mɑɑ kɑ nɑɑ kinɛru kɑ yɑ̃ɑ kinɛru nɑ bu kɑ siɑrɑbun yɑ̃kuru ko Yinni Gusunɔn mi, kɑ som mɛ bɑ burɑ kɑ ɡum. Domi Yinni Gusunɔ u koo bɛɛ kure mi ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Bɑ kɑ ye kpuro nɑ kuu ten mi ye Mɔwisi u bikiɑ. Mɑ be kpuro bɑ nɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Mɔwisi u nɛɛ, i koowo ye Yinni Gusunɔ u ɡeruɑ. Kpɑ u de win yiiko yu bɛɛ kure. ");
INSERT INTO bba_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Mɔwisi u Aroni sɔ̃ɔwɑ u nɛɛ, ɑ susimɑ yɑ̃ku yeru mini, kpɑ ɑ wunɛn tiin torɑrun yɑ̃kuru ko kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru. Yen biru kpɑ ɑ mɑɑ wunɛn tɔmbu Isirelibɑn torɑnun yɑ̃kuru ko nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Mɑ Aroni u susi yɑ̃ku yee ten bɔkuɔ. Mɑ u nɑɑ kinɛ kpɛm te ɡo win torɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Mɑ win bibɑ nùn yen yɛm wɛ̃. Mɑ u mu dɛkɑ kɑ niki biɑ u tɛɛni sɑ̃ɑ yerun kɑ̃ɑnu sɔɔ, mɑ u mɛ mu tie wisi yɑ̃ku yee ten temɔ. ");
INSERT INTO bba_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Yen biru u yɑɑ yen ɡum suɑ u dɔ̃ɔ doke kɑ yen ɡɑbu swii yiru kɑ yen buro ɡe ɡɑ woru wukiri nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Adɑmɑ yen yɑɑ kɑ yen ɡɔnɑ, tɔɔwɔwɑ u dɑ u ye dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Yen biru Aroni u yɑ̃ɑ te sɑkɑ bu kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. Mɑ win bibɑ ten yɛm suɑ bɑ nùn wɛ̃. Mɑ u mu yɛ̃kɑ u kɑ yɑ̃ku yee ten nɔɔ bɔkɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Yen biru bɑ yɑ̃ɑ ten yɑɑ bɔɔrɑ bɑ Aroni wɛ̃ kɑ ten wiru. Mɑ u ye kpuro dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","U ten nuki teɑ kɑ ten kɔ̃ri u sɔndi yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii ten wɔllɔ u dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Yen biru u Isirelibɑn yɑ̃kunu kuɑ. U boo ɡe sɑkɑ ɡe bɑ koo kɑ yɑ̃kuru ko tɔmbun torɑnun sɔ̃ mɑ u kuɑ nɡe mɛ u rɑɑ yɑ̃ku ɡbiikii te kuɑ kɑ nɑɑ kinɛ kpɛmbu ɡe. ");
INSERT INTO bba_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Yen biru u yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ nɡe mɛ woodɑ yɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Mɑ u ɡberun dĩɑnu suɑ u kɑ yɑ̃kuru kuɑ. U som nɔm kureru suɑ u dɔ̃ɔ doke yɑ̃ku yerun wɔllɔ bururu bɑɑteren yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","U kɛtɛ ye kɑ yɑ̃ɑ kinɛ te sɑkɑ bɑ kɑ siɑrɑbun yɑ̃kuru kuɑ Isirelibɑn sɔ̃. Mɑ win bibu bɑ nùn yen yɛm wɛ̃ u kɑ mu yɛ̃kɑ yɑ̃ku yerun nɔɔ bɔkɑɔ u kɑ sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Mɑ bɑ mɑɑ nùn kɛtɛ yen ɡum wɛ̃ kɑ yɑ̃ɑ ten siru kɑ mɑɑ ten ɡum mɛ mu ten bɔsɔ yɑ̃nu tɛ̃ke kɑ sere mɑɑ ten ɡɑbu swii kɑ mɑɑ ten buro ɡe ɡɑ woru wukiri. ");
INSERT INTO bba_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","Mɑ u yɑɑ yen ɡum sɔndi yen ɡuro ɡurorun wɔllɔ. Yen biru u ɡum mɛ dɔ̃ɔ doke yɑ̃ku yeru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Mɑ Aroni u yɑɑ yen ɡuro ɡuro ni suɑ kɑ yen nɔm ɡeu ɡe, u sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ nɡe mɛ Mɔwisi u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Sɑnɑm mɛ Aroni u torɑnun yɑ̃kunu kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kɑ siɑrɑbun yɑ̃kunu kuɑ u kpɑ, yerɑ u nɔmɑ suɑ wɔllɔ u Isirelibɑ domɑru kuɑ. Yen biru u sɑrɑ yɑ̃ku yerun di. ");
INSERT INTO bba_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Mɔwisi kɑ Aroni bɑ duɑ kuu ten mi. Ye bɑ yɑrɑ, mɑ bɑ tɔmbu domɑru kuɑ. Sɑɑ yerɑ Yinni Gusunɔ u bu win yiikon ɡirimɑ sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Mɑ dɔ̃ɔ yɑri yɑrɑ win wuswɑɑn di yi dɑ yi yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te mwɑ kɑ yɑ̃ku ni nu tien yɑɑ ɡum mɛ. Mɑ Isirelibɑ kpuro bɑ ye wɑ. Mɑ bɑ nuku dobun kuuki wɔri bɑ yiirɑ sere temɔ. ");
INSERT INTO bba_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Aronin bibu Nɑdɑbu kɑ Abihu ben bɑɑwure u win dɔ̃ɔ ɡurɑtiɑ suɑ bɑ dɔ̃ɔ ɡure, mɑ bɑ turɑre doke mi. Yen biru bɑ kɑ Yinni Gusunɔ dɑɑwɑ kuu bekuruɡirɔ. Nɡe mɛyɑ bɑ kɑ dɔ̃ɔ tuko dɑ kuu ten mi. N deemɑ Yinni Gusunɔ u bu ye yinɑri. ");
INSERT INTO bba_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Yerɑ u derɑ dɔ̃ɔ u yɑrɑ u bu di mɑ bɑ ɡu mi. ");
INSERT INTO bba_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Mɑ Mɔwisi u Aroni sɔ̃ɔwɑ u nɛɛ, Yinni Gusunɔ u ǹ dɑɑ bɛɛ sɔ̃ɔwɑ u nɛɛ, u kĩwɑ be bɑ nùn susimɔ bu win dɛɛrɑru nɑsiɑ, kpɑ bu nùn bɛɛrɛ wɛ̃ tɔmbu kpuron wuswɑɑɔ? Mɑ Aroni u win nɔɔ mɑri. ");
INSERT INTO bba_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Mɑ Mɔwisi u Misɑɛli kɑ Elisɑfɑni Usiɛlin bibu sokɑ. Usiɛli wi, u sɑ̃ɑwɑ Aronin tundon wɔnɔn bii. Mɔwisi u bu sɔ̃ɔwɑ u nɛɛ, i nɑ i bɛɛn wɔnɔbun ɡonu suɑ kuu ten min di i kɑ nu dɑ sɑnsɑnin biruɔ. ");
INSERT INTO bba_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Mɑ bɑ nɑ bɑ ɡoo ni suɑ kɑ nin tɑkobɑ sɑnnu bɑ kɑ dɑ sɑnsɑnin biruɔ nɡe mɛ Mɔwisi u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Mɑ Mɔwisi u Aroni kɑ win bibu yiru be bɑ tie Eleɑsɑɑ kɑ Itɑmɑɑ sɔ̃ɔwɑ u nɛɛ, i ku bɛɛn winu deri diinu, i ku mɑɑ bɛɛn yɑ̃nu ɡɛ̃ɛku nuku sɑnkirɑnun sɔ̃ kpɑ Gusunɔ u ku rɑɑ bɛɛ ɡo kpɑ u kɑ Isirelibɑ mɔru ko. Adɑmɑ i de bɛɛn mɛro bisibu Isirelibɑ bu swĩ be dɔ̃ɔ u din sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Bɛɛn tii i ku doonɑ kuu ten kɔnnɔn di kpɑ i ku rɑ kɑ ɡbin sɔ̃. Domi ɡum mɛ bɑ bɛɛ tɑ̃re mi, mu bɛɛ kuɑwɑ mi Yinni Gusunɔn yɑ̃ku kowobu. Mɑ Aroni kɑ win bii be, bɑ kuɑ ye Mɔwisi u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Yinni Gusunɔ u Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","11","ɑ ǹ kɑɑ tɑm bɔɔbɔm ɡɑm nɔ wunɛ kɑ wunɛn bibu ì n dɔɔ nɛn kuu bekuruɡirɔ, kpɑ i ku rɑ kɑ ɡbin sɔ̃. Kpɑ i kɑ kpĩ i wunɑnɑ ye yɑ sɑ̃ɑ sɑ̃ɑruɡiɑ kɑ ye yɑ ǹ sɑ̃ɑ sɑ̃ɑruɡiɑ. Mɛyɑ i ko i mɑɑ kpĩ i wunɑnɑ ye yɑ dɛɛre kɑ ye yɑ ǹ dɛɛre. Mɛyɑ i ko i mɑɑ kpĩ i Isirelibɑ Gusunɔn woodɑbɑ kpuro sɔ̃ɔsi ye u Mɔwisi wɛ̃. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɛɛn bibun bweserɔ. ");
INSERT INTO bba_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Mɔwisi u Aroni kɑ win bibu yiru be bɑ nùn tie, Eleɑsɑɑ kɑ Itɑmɑɑ sɔ̃ɔwɑ u nɛɛ, i som mɛ suo mɛ bɑ kɑ yɑ̃kunu kuɑ mu tiɑrɑ. Kpɑ i kɑ mu pɛ̃ɛ ko ye i kun seeyɑtiɑ doke. Kpɑ i ye di yɑ̃ku yerun bɔkuɔ. Domi nu kuɑwɑ mi dĩɑ dɛɛrɑnu. ");
INSERT INTO bba_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","I ko ye diwɑ yɑm dɛɛrɑm sɔɔ. Yerɑ yɑ ko n sɑ̃ɑ wunɛ kɑ wunɛn bibuɡiɑ nɡe mɛ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Mɛyɑ wunɛ kɑ wunɛn bii tɔn durɔbu kɑ tɔn kurɔbu i ko i yɑɑ nɔmu ɡe bɑ kpɑrɑ mi di kɑ ɡuro ɡuro te bɑ sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. Yerɑ yɑ ko n sɑ̃ɑ wunɛ kɑ wunɛn bibuɡiɑ Isirelibɑ bɑ̀ n siɑrɑbun yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Isirelibɑ bɑ ko n dɑ kɑ yen nɔmu ɡe kɑ ɡuro ɡuro te nɛwɑ kɑ sere mɑɑ yɑɑ ɡum mɛ bɑ rɑ dɔ̃ɔ doke yɑ̃ku yerun wɔllu mi. Bɑ̀ n ye kpuro sɔ̃ɔsi beri berikɑ bɑ kpɑ, yɑ koo kowɑ wunɛ kɑ wunɛn bibuɡiɑ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Yerɑ Mɔwisi u torɑrun yɑ̃ku boo ɡe bikiɑ. Adɑmɑ u deemɑ bɑ ɡu dɔ̃ɔ mɛni. Yerɑ u kɑ Aronin bibu yiru Eleɑsɑɑ kɑ Itɑmɑɑ mɔru bɑrɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","mbɑn sɔ̃nɑ i ǹ boo ɡen yɑɑ temɛ Yinni Gusunɔn kuru mini. Domi ɡɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu. Yinni Gusunɔ u bɛɛ ɡu wɛ̃wɑ i kɑ Isirelibɑ kpuron torɑnun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Adɑmɑ i ǹ kɑ ɡen yɛm duumɛ Yinni Gusunɔn kuu ten sɔɔwɔ. N deemɑ i ko i rɑɑ ɡen yɑɑ temwɑ kuu ten mi nɡe mɛ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aroni u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ yɛ̃ ye n mɑn deemɑ sɑnɑm mɛ Isirelibɑ bɑ Yinni Gusunɔ yɑ̃kuru kuɑ ben torɑnun sɔ̃ kɑ mɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru. Yen dɔmɑ te, nɑ̀ n torɑrun suurun yɑ̃ku ten yɑɑ di, yɑ koo Gusunɔ dore? Aɑwo! Yɑ ǹ Gusunɔ doremɔ. ");
INSERT INTO bba_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Mɑ Aronin wisi bi, bu Mɔwisi dore. ");
INSERT INTO bba_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","bu Isirelibɑ sɔ̃ɔwɔ bu nɛɛ, yɛɛ yi bɑ koo kpĩ bu di wee. ");
INSERT INTO bba_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Bɑ koo kpĩ bu yɑɑ di ye yɑ nɑɑ kɑburosu mɔ mɑ yɑ rɑ tukɑ ko. ");
INSERT INTO bba_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","Adɑmɑ bɑ ǹ yɛɛ dimɔ yi yi rɑ tukɑ ko tɔnɑ mɑ yi ǹ nɑɑ kɑburosu mɔ. Nɡe mɛyɑ bɑ ǹ yooyoo temmɔ yèn sɔ̃ ɡɑ ǹ nɑɑ kɑburosu mɔ bɑɑ mɛ ɡɑ rɑ tukɑ ko. Bɑ koo ɡu ɡɑrisiwɑ yɑɑ disiɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Bɑ ǹ koo yɑɑ ye bɑ mɔ̀ dɑmɑɑ tem bɑɑ mɛ yɑ rɑ tukɑ ko yèn sɔ̃ yɑ ǹ nɑɑ kɑburosu mɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Mɛyɑ bɑ ǹ koo mɑɑ wukun yɑɑ tem domi ɡɑ ǹ nɑɑ kɑburosu mɔ bɑɑ mɛ ɡɑ rɑ tukɑ ko. Bɑ koo ɡu ɡɑrisiwɑ yɑɑ disiɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Mɛyɑ bɑ ǹ koo mɑɑ kurusɔ di. Gɑ nɑɑ kɑburosu mɔ ɑdɑmɑ ɡɑ ku rɑ tukɑ ko. Bɑ koo ɡu ɡɑrisiwɑ yɑɑ disiɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Bu ku yɛɛ yi di, bu ku mɑɑ yin ɡonu bɑbɑ. Bɑ koo yi ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","Yɛɛ yi yi mɑɑ wɑ̃ɑ dɑɑnɔ kɑ nim wɔ̃kuɔ, yi yi wɑ̃ɑ nim sɔɔ ɡesi kpuro yi bɑ koo di wee. Yiyɑ yi yi kɛ̃ɛritii mɔ kɑ kokosu sɑnnu. ");
INSERT INTO bba_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Adɑmɑ yi yi kun kɛ̃ɛritii mɔ kɑ kokosu sɑnnu, bɑ koo yi ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Bɑ ǹ koo yi di. Mɛyɑ bu ku mɑɑ yin ɡonu bɑbɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Yɛɛ yi yi ɡesi wɑ̃ɑ nim wɔ̃ku sɔɔ, kɑ dɑɑnɔ, mɑ yi ǹ kɛ̃ɛritii kɑ koko si mɔ, bɑ koo yi ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","Gunɔsu sɔɔ, si bɑ koo ɡɑrisi disiɡisu wee, siyɑ ɡunɔ bɑkeru kɑ sere mɑɑ si su rɑ swɛ̃ɛ di kɑ si su rɑ yɑɑ di ");
INSERT INTO bba_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","kɑ yɑberekunu kɑ sere si su kɑ nu weenɛ ");
INSERT INTO bba_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","kɑ ɡbɑnɑmɡbɑɑnu kɑ mɑɑ si su kɑ nu weenɛ ");
INSERT INTO bba_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","kɑ tɑɑtɑɑnu kɑ booro kɑ sere si su kɑ su weenɛ kɑ kɑsɑ kɑ si su kɑ ye weenɛ, ");
INSERT INTO bba_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","kɑ booro bweseru ɡɑru kɑ nim kpɑkpɑyɛ, kɑ booro dɑ̃ɑ kɔ̃ɔru ");
INSERT INTO bba_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","kɑ ɡunɔ ɡbɑmɡbɑyɑku kɑ ɡunɔ si su rɑ swɛ̃ɛ din bweseru ");
INSERT INTO bba_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","kɑ swɑ̃ɑ wĩɑku kɑ si su kɑ ye weenɛ kɑ kɔ̃ɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","I ku mɑɑ kɔkɔmii ni nu kɑsɑ kɑ nɑɑsu mɔ di. ");
INSERT INTO bba_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Adɑmɑ ni sɔɔ, i ko i kpĩ i di ni nu rɑ yɔ̃ɔku tem sɔɔ ");
INSERT INTO bba_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","nɡe tweɑ kɑ ɡbɔɔ kɑ ni nu kɑ ye weenɛ. ");
INSERT INTO bba_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Adɑmɑ ni nu tie nu kɑsɑ kɑ nɑɑsu mɔ mi, i ku nu di. ");
INSERT INTO bba_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","Yɛɛ ɡɛɛ wɑ̃ɑ yìn ɡoru tɔnu ù n bɑbɑ u koo ko disiɡii. U ko n disi mɔwɑ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Wi u yin ɡoru sɔɔwɑ, u koo win yɑ̃nu teɑwɑ. Kpɑ u n wɑ̃ɑ disi sɔɔ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","28","Yɛɛ yi i ko i ɡɑrisi disiɡii yi wee. Yiyɑ yi yi ǹ nɑɑ kɑburosu mɔ kɑ yi yi ku rɑ tukɑ ko kɑ sere yi yi nɑɑsu nnɛ mɔ yi sĩimɔ kɑ nɑɑ sɛ̃nu. Wi u yin ɡɑɑ bɑbɑ u disi duurɑwɑ mi sere kɑ tɔ̃ɔ ten yokɑɔ. Wi u mɑɑ yin ɡoru sɔɔwɑ u koo win yɑ̃nu teɑwɑ kpɑ u n disi mɔ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","Yɛɛ yi yi kɑbirimɔ sɔɔ wee yi i ko i ɡɑrisi disiɡii. Yiyɑ ɡunɔ yɑntɑru kɑ ɡunɔ kiikiiru kɑ dɛbɑ kɑ ye yɑ kɑ ye weenɛ kpuro ");
INSERT INTO bba_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","kɑ duurubɛɛku kɑ sureru kɑ korombɔɔru kɑ sokoro kɑ sunɔ nɑki. ");
INSERT INTO bba_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Yi kpurowɑ i ko i ɡɑrisi disiɡii yɛɛ yi yi kɑbirimɔ sɔɔ. Wi u yin ɡɑɑn ɡoru bɑbɑ u ko n disi mɔwɑ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Yin ɡɑɑn ɡoru tɑ̀ n wɔri dendi yɑ̃nu sɔɔ ni bɑ kuɑ kɑ dɑ̃ɑ ǹ kun mɛ kɑ bekuru ǹ kun mɛ kɑ ɡɔnɑ ǹ kun mɛ kɑ sɑɑki, dendi yɑ̃ɑ ni, nu disi duurɑwɑ mi. Bɑ koo nu dokewɑ nim sɔɔ sere kɑ tɔ̃ɔ ten yokɑɔ. Yen biru nu sere dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Yen ɡɑɑ yɑ̀ n wekeru ɡɑru wɔri te bɑ kuɑ kɑ sɔndu, ye yɑ wɑ̃ɑ mi sɔɔ kpuro yɑ disi duurɑwɑ mi. Bɑ koo weke te kɔrɑwɑ. Bɑ̀ n nim doke weke te sɔɔ, mɑ nim mɛ, mu tɑ̃rɑ dĩɑnu sɔɔ ǹ kun mɛ nɔrurɑ ɡɑɑ sɔɔ, bɑ koo ye kpuro ɡɑrisiwɑ disi. ");
INSERT INTO bba_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Bɑ̀ n nim doke weke te sɔɔ, mɑ nim mɛ, mu dɑ̃ɑre dĩɑnu sɔɔ ǹ kun mɛ nɔrurɑ ɡɑɑ sɔɔ, bɑ koo ye kpuro ɡɑrisiwɑ disi bɑɑ ǹ n weke tere sɔɔn nɑ yɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Mi yɑɑ yen ɡoru tɑ wɔri kpuro ɡesi, doo koo yerɔ ǹ kun mɛ pɛ̃ɛ wɔ̃ɔ yerɔ, bɑ koo ye kpuro kɔsukuwɑ. Domi ye kpuro yɑ disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Yɑɑ ɡoo te, tɑ̀ n wɔri dɔkɔ sɔɔ ǹ kun mɛ dɑɑrɔ, i ǹ ko i nim mɛ ɡɑrisi disi. Adɑmɑ wi u tu bɑbɑ u disi duurɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Tɑ̀ n wɔri dĩɑ bwese te bɑ koo duure sɔɔ, dĩɑ bwese te, tɑ ǹ disi duure. ");
INSERT INTO bba_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Adɑmɑ bɑ̀ n dɑɑ dĩɑ bwese te wɑsɑn nɑ bu kɑ di, tɑ disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","Yɑɑ ye bɑ rɑ di yɑ̀ n kɑ tii ɡu, wi u yen ɡoru bɑbɑ, yɛ̃ro u disi duurɑwɑ mi sere n kɑ ko tɔ̃ɔ ten yokɑ. ");
INSERT INTO bba_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Wi u yen yɑɑ temɑ ǹ kun mɛ u yen ɡoru sɔɔwɑ, u koo win yɑ̃nu teɑwɑ kpɑ u n disi mɔ sere kɑ tɔ̃ɔ ten yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","I ku yɛɛ yi yi kɑbirimɔn yɑɑ tem ");
INSERT INTO bba_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","kɑ yi yi rɑ kɑ nukuru sĩ kɑ yi yi kɑbirimɔ kɑ nɑɑsu nnɛ ǹ kun mɛ yi yi nɑɑ dɑbinu mɔ. I ko ye kpuro deriwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","I ku de yɛɛ yin bweseru yi bɛɛ ko disiɡibu. ");
INSERT INTO bba_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Domi nɛ Gusunɔ nɑ sɑ̃ɑwɑ bɛɛn Yinni. I ko i tii dɛɛrɑsiɑ kpɑ i n dɛɛre. Domi nɑ sɑ̃ɑwɑ Dɛɛro. Yen sɔ̃nɑ i ǹ ko i tii disi doke kɑ yɛɛ yi yi kɑbirimɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Nɛnɑ nɑ bɛɛ yɑrɑmɑ Eɡibitin di nɑ n kɑ sɑ̃ɑ bɛɛn Yinni. Yen sɔ̃, i de i n dɛɛre. Domi nɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","Woodɑ yeni kpurowɑ nɑ yi yɛɛ kpuron sɔ̃ kɑ ɡunɔsu kɑ yɛɛ yi yi wɑ̃ɑ nimɔ kɑ sere yi yi kɑbirimɔ. ");
INSERT INTO bba_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Yerɑ yɑ koo de i n dɑ yɑɑ wunɑnɛ ye bɑ koo kɑ yɑ̃kuru ko kɑ ye bɑ ǹ kɑ yɑ̃kuru mɔ̀. Mɛyɑ mɑɑ yɑ koo bɛɛ sɔ̃ɔsi yɑɑ ye i ko i di kɑ ye i ǹ dimɔ. ");
INSERT INTO bba_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Yinni Gusunɔ u Mɔwisi woodɑ wɛ̃ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, tɔn kurɔ ù n ɡurɑ suɑ mɑ u bii tɔn durɔ mɑrɑ, u ko n disi mɔwɑ sɔ̃ɔ nɔɔbɑ yiru nɡe sɑnɑm mɛ u yɑsɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Sɔ̃ɔ nɔɔbɑ itɑse, kpɑ bu win bii wi bɑnɡo kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Adɑmɑ kurɔ wi, u ko n wɑ̃ɑwɑ disi sɔɔ sɔ̃ɔ tɛnɑ kɑ itɑ kpɑm u sere dɛɛrɑ yɛm mɛ u yɑrin sɔ̃ mɑrubun sɑɑ. U ku rɑɑ sɑ̃ɑ yɑ̃nu ɡɑnu bɑbɑ, u ku rɑɑ mɑɑ dɑ Gusunɔn kuu bekuruɡirɔ sere tɔ̃ɔ te, tu kɑ turi. ");
INSERT INTO bba_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Ǹ n mɑɑ tɔn kurɔn nɑ u mɑrɑ, u ko n wɑ̃ɑwɑ disi sɔɔ ɑlusumɑ yiru. Yɑ ko n sɑ̃ɑwɑ nɡe sɑnɑm mɛ u yɑsɑ mɔ̀. Yen biru u koo kowɑ sɔ̃ɔ wɑtɑ kɑ nɔɔbɑ tiɑ u sere dɛɛrɑ win yɛm mɛ mu yɑrin sɔ̃ mɑrubun sɑɑ. ");
INSERT INTO bba_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","Tɔn kurɔ wi u mɑrɑ, win dɛɛrɑsiɑbun sɑɑ yɑ̀ n turɑ, u koo kɑ yɑ̃ɑru wɔ̃ɔ tiɑɡiru nɑwɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. Kpɑ u totobɛrɛru ǹ kun mɛ kpɑruko suɑ u kɑ win torɑrun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Yɑ̃ku kowowɑ u koo kɑ ye yɑ̃kuru ko. Kpɑ u nùn win torɑrun suuru kɑnɑ. Sɑɑ ye sɔɔrɑ u koo dɛɛrɑ win yɛm mɛ mu yɑrin sɔ̃. Woodɑ yeniwɑ nɛ, Yinni Gusunɔ nɑ wɛ̃ɛmɔ tɔn kurɔ wi u bii mɑrɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Ù kun yɑ̃ɑru wɑ, u koo totobɛrɛnu yiru ǹ kun mɛ kpɑrukonu yiru kɑsu. Nin teuwɑ u koo kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko kpɑ u mɑɑ kɑ teu ɡeni torɑrun yɑ̃kuru ko. Yɑ̃ku kowowɑ u koo nùn yɑ̃ku te kuɑ. Sɑɑ ye sɔɔrɑ u koo dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","ɡoo ù n mɔsiru mɔ wɑsi sɔɔ, ǹ kun mɛ debu, ǹ kun mɛ bɑu kpiku ɡe ɡɑ kɑ bɑrɑ disiɡiru weenɛ, bɑ koo kɑ yɛ̃ro dɑwɑ yɑ̃ku kowo Aronin mi ǹ kun mɛ win bibun turon mi. ");
INSERT INTO bba_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Yɑ̃ku kowo wiyɑ u koo bɑrɑ te mɛɛri. Ù n deemɑ bɑu ɡe, ɡɑ sɑn kpikisu mɔ, mɑ ɡɑ wɔru mɔ, sɑɑ ye sɔɔrɑ u koo ɡere mɑ yɛ̃ro u bɑrɑ disiɡiru bɑrɔ. ");
INSERT INTO bba_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Ù n mɑɑ bɑu kpiku ɡɑɡu mɔ mɑ ɡɑ ǹ wɔru mɔ, mɑ ɡen sɑnsu kun buriri, yɑ̃ku kowo u koo kɑ yɛ̃ro dɑwɑ diru ɡɑru sɔɔ u kɛnusi sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Sɔ̃ɔ nɔɔbɑ yiruse, yɑ̃ku kowo ù n wɑ bɑu ɡe, ɡɑ ǹ yɑbi, u koo mɑɑ nùn kɛnusiwɑ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Sɔ̃ɔ nɔɔbɑ yiruse te, yɑ̃ku kowo u koo mɑɑ nùn yɑrɑwɑ u mɛɛri. Ù n deemɑ ɡɑ ǹ yɑbi bɑɑmɑ, u koo yɛ̃ro sɔ̃wɑ mɑ u dɛɛre, yɑ sɑ̃ɑwɑ debu, kpɑ u win yɑ̃nu teɑ u dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Amɛn biru, debu ye, yɑ̀ n yɑbi ɡɔnɑ ye sɔɔ, yɛ̃ro u koo mɑɑ wurɑwɑ yɑ̃ku kowo u nùn mɛɛri. ");
INSERT INTO bba_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Yɑ̃ku kowo wi, ù n nùn mɛɛrɑ mɑ u deemɑ yɑ yɑbi win ɡɔnɑ sɔɔ, u koo yɛ̃ro sɔ̃wɑ mɑ u ǹ dɛɛre, u bɑrɑ disiɡiru mɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","Goo ù n bɑrɑ disiɡiru bɑrɔ, bɑ koo kɑ nùn dɑwɑ yɑ̃ku kowon mi. ");
INSERT INTO bba_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Yɑ̃ku kowo wiyɑ u koo nùn mɛɛri. Ù n bɑu kpiku wɑ mi, mɑ bɑu ɡen sɑnsu buriri, mɑ ɡɔnɑ ye, yɑ boo kuɑ, ");
INSERT INTO bba_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","yɑ sɑ̃ɑwɑ bɑrɑ disiɡii te tɑ torumɔ yɛ̃ron ɡɔnɑ sɔɔ. Yɑ̃ku kowo u koo yɛ̃ro ɡɑrisiwɑ disiɡii. U ǹ mɑɑ nùn kɛnusimɔ. ");
INSERT INTO bba_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","Adɑmɑ yɑ̃ku kowo ù n mɔsi mɔsiminu wɑ nu yɑbi yɛ̃ron ɡɔnɑ kpuro sɔɔ, sɑɑ win wirun di sere kɑ nɑɑsɔ, ");
INSERT INTO bba_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","u koo yɛ̃ro ɡɑrisiwɑ u dɛɛre, domi win wɑsi kpuro yi bururɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Adɑmɑ dɔmɑ te bɑ boo swɑ̃ɔ wɑ win wɑsi sɔɔ, bɑ koo nùn ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Yɑ̃ku kowon tiiwɑ u koo nùn mɛɛri. Ù n deemɑ boo swɑ̃ɔ u wɑ̃ɑ mi, u koo nùn ɡɑrisiwɑ disiɡii, domi yɑ sɑ̃ɑwɑ bɑrɑ disiɡiru. ");
INSERT INTO bba_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Adɑmɑ win wɑsi yi, yì n kɔsɑ, mɑ yi bururɑ kpuro, u koo mɑɑ dɑwɑ u yɑ̃ku kowo wɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Yen biru, yɑ̃ku kowo u koo ye mɛɛriwɑ. Ù n wɑ yɑ bururɑ, sɑɑ ye sɔɔ, u koo yɛ̃ro ɡɑrisiwɑ u dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","Goo ù n win bwisi kpɑkɑ sɔɔ ");
INSERT INTO bba_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","mɔsiru ɡɑru wɑ, mɑ u deemɑ tɑ buriri, ǹ kun mɛ tɑ sɔ̃ri, yɛ̃ro u koo dɑwɑ u tii sɔ̃ɔsi yɑ̃ku kowon mi. ");
INSERT INTO bba_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Yɑ̃ku kowo wi, u koo nùn mɛɛriwɑ. Ù n deemɑ mɔsi te, tɑ wɔru mɔ, mɑ win wɑsin sɑnsu su bururɑ, sɑɑ ye sɔɔrɑ yɑ̃ku kowo u koo nùn ɡɑrisi disiɡii. Bɑrɑ disiɡirɑ tɑ yɑrimɔ sɑɑ bwisi kpɑkɑ yen min di. ");
INSERT INTO bba_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Adɑmɑ yɑ̃ku kowo ù n wɑ mɑ sɑn kpikisu sɑri mɔsi ten wɔllɔ, yen biru mɔsi te, tɑ ǹ wɔru mɔ, mɑ tɑ buriri fiiko, u koo durɔ wi kɛnusiwɑ dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Mɔsi te, tɑ̀ n ɡɔnɑ yɑbi, yɑ̃ku kowo u koo nùn ɡɑrisiwɑ disiɡii domi bɑrɑ disiɡirɑ tɑ nùn deemɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Adɑmɑ mɔsi te, tɑ kun yɑbi, tɑ sɑ̃ɑwɑ bwisi kpɑkɑ. Sɑɑ ye sɔɔ, yɑ̃ku kowo u koo ɡere mɑ yɛ̃ro kun disi mɔ. ");
INSERT INTO bba_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","Goo ù n dɔ̃ɔ mwɑɑrɑ mɑ yen boo kpɑkɑ sɔɔ bɑu kpiku ɡɑ yɑrɑ, ǹ kun mɛ bɑu sɔ̃ɔ, yɑ̃ku kowo u koo yɛ̃ro mɛɛriwɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Gen sɑnsu sù n kuɑ kpikisu mɑ wɔru ɡɑ sɔ̃ɔsire ɡɔnɑ ye sɔɔ, sɑɑ ye sɔɔ bɑrɑ disiɡirɑ tɑ sɔ̃ɔsirɑ mi. Yɑ̃ku kowo u koo nùn ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Adɑmɑ yɑ̃ku kowo ù n wɑ mɑ sɑn kpikisu sɑri bɑu ɡe sɔɔ, ɡɑ ǹ mɑɑ wɔru mɔ, mɑ ɡɑ buriri fiiko, u koo yɛ̃ro kɛnusiwɑ dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo nùn mɛɛri. Ù n wɑ bɑu ɡe, ɡɑ yɑbi win ɡɔnɑ sɔɔ, u koo nùn ɡɑrisiwɑ disiɡii. Tɑ sɑ̃ɑwɑ bɑrɑ disiɡiru. ");
INSERT INTO bba_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Adɑmɑ bɑu ɡe, ɡɑ kun yɑbi, mɑ ɡɑ bururɑ fem fem, dɔ̃ɔ mwɑɑrɑ kpɑkɑ yerɑ. Sɑɑ ye sɔɔ, yɑ̃ku kowo u koo nùn ɡɑrisiwɑ u dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","Tɔn durɔ ǹ kun mɛ tɔn kurɔ ù n bɑu ɡɑɡu mɔ win wirɔ, ǹ kun mɛ win tonkurorɔ, ");
INSERT INTO bba_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","yɑ̃ku kowo u koo ɡu mɛɛriwɑ. Gɑ̀ n wɔru mɔ mɑ ɡen sɑnsu su ǹ sinum mɔ, mɑ su swɛ̃rɑmɑ nɡe dɔm buuru, yɑ̃ku kowo u koo yɛ̃ro ɡɑrisiwɑ disiɡii. Yɑ sɑ̃ɑwɑ wii kpɑkɑ ye yɑ wɑ̃ɑ wirɔ, ǹ kun mɛ tonkurorɔ. ");
INSERT INTO bba_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Yɑ̃ku kowo wi, ù n wɑ yɑ wɔru mɔ, mɑ sɑn wɔ̃kusu sɑri, u koo yɛ̃ro kɛnusiwɑ dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo mɑɑ yɛ̃ro mɛɛriwɑ. Ù n deemɑ wii kpɑkɑ ye, yɑ ǹ yɑbi mɑ yɑ sɑnsu mɔ si su kɑ dɔm buuru weenɛ, mɑ su ǹ wɔru mɔ, ");
INSERT INTO bba_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","yɛ̃ro u koo win sɑnsu kɔniwɑ. Adɑmɑ u ǹ kpɑkɑ ye kɔnimɔ. Yen biruwɑ yɑ̃ku kowo u koo mɑɑ nùn kɛnusi dirɔ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo ye mɛɛriwɑ. Wii kpɑkɑ ye, yɑ̀ kun yɑbi, mɑ yɑ ǹ tĩre yɑ ɡɔnɑ kere, yɑ̃ku kowo u koo nùn ɡɑrisiwɑ u dɛɛre. U koo win yɑ̃nu teɑ. Sɑɑ ye sɔɔ, u dɛɛrɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Adɑmɑ wii kpɑkɑ ye, yɑ̀ n dɑ̃kuru yɑbi, yɑ̃ku kowo u koo mɑɑ nùn mɛɛriwɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","Ù n wɑ yɑ yɑbi ɡɔnɑ ye sɔɔ, yɑ̃ku kowo u ǹ mɑɑ kɑsumɔ yɛ̃ro ù n sɑn dɔm buuru mɔ. U koo nùn ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Wii kpɑkɑ ye, yɑ̀ kun yɑbi, mɑ yen sɑnsu tĩrɑ, yɛ̃ro u bɛkurɑwɑ mi. U ǹ mɑɑ disi mɔ. Yɑ̃ku kowowɑ u koo ɡere mɑ u dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","Tɔn durɔ ɡoo ǹ kun mɛ tɔn kurɔ ɡoo ù n win ɡɔnɑ sɔɔ bɑu kpikisu wɑ, ");
INSERT INTO bba_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","yɑ̃ku kowowɑ u koo nùn mɛɛri. Ù n bɑusu ɡɑsu wɑ si su ǹ buriri sɑ̃ɑ sɑ̃ɑ, bɑu si, su ǹ sɛ̃. U koo yɛ̃ro ɡɑrisiwɑ u dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","Goo ù kun seri mɔ wirɔ, wii kpɑrɑruɡiiwɑ bɑ koo yɛ̃ro ɡɑrisi. U dɛɛrewɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Ǹ n wuswɑɑ ɡiɑn nɑ u ǹ seri mɔ, yɛ̃ro u sɑ̃ɑwɑ wii kpɑrɑruɡii. Kɑ mɛ, yɛ̃ro u dɛɛrewɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Adɑmɑ wii kpɑrɑ te sɔɔ, bɑu ɡɑɡu ɡɑ̀ n sɔ̃ɔsirɑ ɡɑ sɔ̃ri, bɑrɑ disiɡirɑ tɑ torumɔ mi. ");
INSERT INTO bba_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Yɑ̃ku kowowɑ u koo ɡu mɛɛri. Ù n deemɑ wii kpɑrɑ te, tɑ bɑu kpikisu mɔ su kɑ bɑrɑ disiɡiru weenɛ, wi u su mɔ mi, u bɑrɑ disiɡiru bɑrɔwɑ mi. U ǹ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","Yɑ̃ku kowo u koo nùn ɡɑrisiwɑ disiɡii win wii bɑu ɡen sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","Wi u bɑrɑ disiɡiru mɔ kpuro, u koo yɑ̃nu dokewɑ ni nu ɡɛ̃ɛre, u ku furɔ doke, kpɑ u win wuswɑɑ wukiri kpɑ u n nɔɔɡiru sue u n mɔ̀, disiɡii, disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","U ko n sɑ̃ɑwɑ disiɡii sere win bɑrɑ disiɡii te, tu kɑ kpe. Yen sɔ̃nɑ u ko n wɑ̃ɑ yeru mɔ bee tiɑ u n kɑ tɔmbu dɛsire. ");
INSERT INTO bba_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","49","Bɑ̀ n disi ɡɔmi ɡɛɛ wɑ yi sɔ̃ri ǹ kun mɛ yi sɑ̃ɑ nɡe wuru biresu yɑ̃nu ɡɑnu sɔɔ, ni bɑ kuɑ kɑ yɑ̃ɑ sɑnsu ǹ kun mɛ kĩɑ si bɑ kuɑ kɑ wɛ̃ɛ dɑmɡii ǹ kun mɛ yɑɑ ɡɔnɑ, bɑu ɡe, yɑ̃ku kowo u koo ɡu mɛɛriwɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Yɑ̃ku kowo wi, ù n yɑ̃ɑ ni mɛɛrɑ u koo nu yiwɑ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Yen sɔ̃ɔ nɔɔbɑ yiruse te, u koo wure u mɑɑ yɑ̃ɑ ni mɛɛriwɑ. Ù n deemɑ disi ɡɔmi yi, yi yɑbi bɑɑmɑ, mɑ bɑ ǹ kpɛ̃ bu yi wĩɑ, sɑɑ ye sɔɔ, u koo nu ɡɑrisiwɑ yɑ̃ɑ disiɡinu. ");
INSERT INTO bba_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Sɑɑ ye sɔɔrɑ yɑ̃ku kowo u koo yɑ̃ɑ ni dɔ̃ɔ mɛni. Bɑɑ bɑ̀ n nu kuɑ kɑ wɛ̃su ǹ kun mɛ kɑ wɛ̃ɛ dɑmɡii ǹ kun mɛ kɑ yɑ̃ɑ sɑnsun wɛ̃ɛ ǹ kun mɛ kɑ mɑm ɡɔnɑ, kɑ mɛ, bɑ koo ye kpuro dɔ̃ɔ mɛniwɑ. Domi bɑ ǹ kpɛ̃ bu disi ɡɔmi yi wĩɑ. Dɔ̃ɔwɑ u koo ye ɡo. ");
INSERT INTO bba_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","Adɑmɑ yɑ̃ku kowo ù n wɑ ɡɔmi yi, yi ǹ yɑbi yɑ̃ɑ ni sɔɔ, ");
INSERT INTO bba_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","u koo de bu nu teɑwɑ kpɑ bu mɑɑ nu diru kɛnusi sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo wure u mɑɑ nu mɛɛriwɑ. Ù n deemɑ disi ɡɔmi yi ǹ kɔsɑ, yi ǹ mɑɑ yɑbi, bɑ koo yɑ̃ɑ ni ɡɑrisiwɑ disiɡinu kpɑ bu nu dɔ̃ɔ doke. Domi disi ɡɔmi yi, yi nu di biruɔ ǹ kun mɛ wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Adɑmɑ yɑ̃ku kowo ù n deemɑ disi ɡɔmi yi, yi bururɑ, u koo ye wɔkɑwɑ yɑ̃ɑ nin min di. ");
INSERT INTO bba_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Yen biru yì n mɑɑ wurɑmɑ yɑ̃ɑ ni sɔɔ, yi ko n sɑ̃ɑwɑ disi ɡɔmi. Bɑ koo yɑ̃ɑ ni dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bba_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Bɑ̀ n yɑ̃nu ɡɑnu teɑ ni nu disi ɡɔmi kpiɑ, mɑ disi ɡɔmi yi, yi wĩɑrɑ, bɑ koo wure bu mɑɑ nu teɑwɑ bu sere nu ɡɑrisi nu dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Yeniwɑ yɑ sɑ̃ɑ disi ɡɔmin woodɑ yi yi rɑ kpi yɑ̃nu sɔɔ ye bɑ kuɑ kɑ wɛ̃su ǹ kun mɛ kɑ wɛ̃ɛ dɑmɡii ǹ kun mɛ kɑ ɡɔnɑ. Woodɑ yerɑ yɑ koo sɔ̃ɔsi yɑ̃ɑ ni nu dɛɛre kɑ ni nu kun dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","wee nɡe mɛ bɑ koo kɑ tɔnu dɛɛrɑsiɑ wi u rɑɑ bɑrɑ disiɡiru mɔ. Bɑ koo kɑ nùn dɑwɑ yɑ̃ku kowon mi, ");
INSERT INTO bba_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","kpɑ yɑ̃ku kowo u kɑ nùn yɑri sɑnsɑnin di u nùn mɛɛri. Ù n deemɑ u bɛkurɑ, ");
INSERT INTO bba_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","yɑ̃ku kowo u koo nùn sɔ̃wɑ ye bɑ koo kɑ nùn dɛɛrɑsiɑ. U koo ɡunɔminu yiru suɑ ni bɑ rɑ kɑ yɑ̃kuru ko kɑ sere dɑ̃ɑ ye bɑ mɔ̀ sɛduru kɑ wɛ̃ɛ wunɔmɡii kɑ dɑ̃ɑ kiku ɡɑɡun kɑ̃ɑsɑ ɡe bɑ mɔ̀ isɔpu. ");
INSERT INTO bba_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Yɑ̃ku kowo u koo de bu ɡunɔ ɡen teu sɑkɑwɑ wekeru sɔɔ te bɑ kuɑ kɑ sɔndu te tɑ nim ɡem mɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Yen biru u koo ɡunɔ ɡe ɡɑ wɑsi mi, kɑ sɛdurun dɑ̃ɑ ye, kɑ wɛ̃ɛ wunɔmɡii yi, kɑ isɔpun kɑ̃ɑsɑ ye dokewɑ yɛm mɛ sɔɔ, mɛ bɑ wisi nim sɔɔ mi. ");
INSERT INTO bba_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","U koo ye yɛ̃kɑwɑ nɔn nɔɔbɑ yiru wi bɑ koo dɛɛrɑsiɑn wɔllɔ. Yen biru u koo nùn ɡɑrisiwɑ u dɛɛre kpɑ u ɡunɔ ɡe yɔ̃su ɡu doonɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","Wi u koo tii dɛɛrɑsiɑ, u koo win yɑ̃nu teɑwɑ kpɑ u win sɑnsu kɔni, kpɑ u wobure nim sɔɔ. Sɑɑ ye sɔɔrɑ bɑ koo nùn ɡɑrisi u dɛɛre. Yen biru, u koo kpĩ u wurɑmɑ sɑnsɑniɔ. Adɑmɑ u koo kowɑ sɔ̃ɔ nɔɔbɑ yiru tɔɔwɔ u kun due win kuu bekuruɡirɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Sɔ̃ɔ nɔɔbɑ yiruse te, u koo win sɑnsu kɔniwɑ kɑ win seri kɑ win toburu kɑ win nɔni burosu. Ye yɑ sɑ̃ɑ sɑnsu kpuro ɡesi, u koo kɔniwɑ. U koo mɑɑ win yɑ̃nu teɑwɑ kpɑ u wobure u dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","Sɔ̃ɔ nɔɔbɑ itɑse, u koo yɑ̃ɑnu yiru suɑ ni nu ǹ ɑlebu mɔ kɑ yɑ̃ɑ nii teeru wɔ̃ɔ tiɑɡiru kɑ som kilo nɔɔbɑ nnɛ mɛ bɑ burinɑ kɑ ɡum kɑ sere mɑɑ ɡum litirin bɔnu. ");
INSERT INTO bba_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Yɑ̃ku kowo wi u koo tɔnu wi dɛɛrɑsiɑ u koo nùn tusiɑ Yinni Gusunɔn wuswɑɑɔ kuu ten kɔnnɔwɔ kɑ mɑɑ win yɑ̃ku dĩɑnu. ");
INSERT INTO bba_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","Yɑ̃ku kowo u koo yɑ̃ɑ nin teeru suɑwɑ kpɑ u kɑ tu yɑ̃kuru ko te bɑ rɑ kɑ torɑru sɔmɛ kɑ sere ɡum litirin bɔnu ye, kpɑ u ye kpuro sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Kpɑ u tu sɑkɑ yɑm dɛɛrɑm mi, mi bɑ rɑ torɑrun yɑ̃kuru kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun yɑɑ sɑke. Domi torɑrun yɑ̃ku yɑɑ kɑ ye bɑ rɑ kɑ torɑnu sɔmɛɡiɑ yɑ sɑ̃ɑwɑ dĩɑ dɛɛrɑnu ni nu koo ko yɑ̃ku kowoɡinu. ");
INSERT INTO bba_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Yɑ̃ku kowo u koo torɑrun yɑ̃ku yɑɑ yen yɛm suɑ u tɛɛni wi u dɛɛrɑsiɑmɔn soo nɔm ɡeuɡuuɔ kɑ win nɔm ɡeun niki biɑ bɑkɑɔ kɑ sere win nɔɔ nɔm ɡeuɡuun niki biɑ bɑkɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Yɑ̃ku kowo u koo mɑɑ ɡum litirin bɔnu ye wisiwɑ win nɔm dwɑrun nɔm wɔɔrɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Kpɑ u kɑ win nɔm ɡeun niki biɑ ɡum mɛ dɛkɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Yen biru, kpɑ u ɡum mɛ mu tie tɛɛni wi u dɛɛrɑsiɑmɔn soo nɔm ɡeuɡuuɔ kɑ mɑɑ win nɔm ɡeun niki biɑ bɑkɑɔ kɑ win nɔɔ nɔm ɡeuɡuun niki biɑ bɑkɑɔ. U koo mu tɛɛniwɑ mi u rɑɑ yɛm mɛ doke. ");
INSERT INTO bba_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Kpɑ u mɑɑ mɛ mu tie win nɔmɑ sɔɔ doke yɛ̃ron wiru wɔllɔ kpɑ u nùn dɛɛrɑsiɑbun wororu koosi Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","Kpɑ u nùn torɑrun yɑ̃kuru kuɑ. Nɡe mɛyɑ u koo kɑ nùn dɛɛrɑsiɑ. Yen biruwɑ u koo yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡirun yɑɑ ɡo. ");
INSERT INTO bba_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","Kpɑ u ye dɔ̃ɔ doke yɑ̃ku yerɔ kɑ kɛ̃nu. Nɡe mɛyɑ u koo kɑ yɛ̃ro torɑrun yɑ̃kuru kuɑ kpɑ u dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","Wi u bɑrɑ disiɡiru mɔ mɑ u ǹ dɑm mɔ u kɑ yɑ̃ku yɑɑ sɑberu wɑ, yɑ̃ɑ teerɑ u koo kɑsu u kɑ yɑ̃kuru ko te tɑ sɑ̃ɑ torɑrun sɔmbuɡiru. Yɑ̃ku kowo u koo kɑ tu suuru kɑnɑbun wororu ko Yinni Gusunɔn wuswɑɑɔ. Yen biru durɔ wi, u koo som kilo itɑ wɛ̃ mɛ bɑ burɑ kɑ ɡum kɑ sere mɑɑ ɡum litirin bɔnu. ");
INSERT INTO bba_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","U koo mɑɑ kɑ kpɑrukonu yiru nɑ ǹ kun mɛ totobɛrɛnu yiru nɡe mɛ win wɑɑrɑ nɛ. Bɑ koo ɡen teu ɡo win torɑrun suurun sɔ̃. Kpɑ bu mɑɑ kɑ teu ɡe ɡɑ tie yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","Win dɛɛrɑsiɑbun sɔ̃ɔ itɑserɑ u koo kɑ ye kpuro yɑ̃ku kowo nɑɑwɑ sɑ̃ɑ yerun kɔnnɔwɔ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Yɑ̃ku kowo wi, u koo yɑ̃ɑ te mwɑ kɑ ɡum litirin bɔnu ye, kpɑ u ye kpuro sɔ̃ɔsi beri berikɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Yen biru u koo yɑ̃ɑ te sɑkɑ kpɑ u ten yɛm suɑ u tɛɛni wi u rɑɑ bɑrɑ disiɡiru mɔn soo nɔm ɡeuɡuuɔ kɑ win nɔm ɡeun niki biɑ bɑkɑɔ kɑ sere mɑɑ win nɔɔ nɔm ɡeuɡuun niki biɑ bɑkɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Yen biru yɑ̃ku kowo wi, u koo ɡum mɛ wie win nɔm dwɑrun nɔm wɔɔrɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Kpɑ u kɑ win nɔm ɡeun niki biɑ ɡum mɛ dɛkɑ u yɛ̃kɑ nɔn nɔɔbɑ yiru Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","U koo mɑɑ ɡum mɛ tɛɛni wi u rɑɑ bɑrɑ disiɡiru mɔn soo nɔm ɡeuɡuuɔ kɑ nɔm ɡeun niki biɑ bɑkɑɔ kɑ sere win nɔɔ nɔm ɡeuɡuun niki biɑ bɑkɑɔ. U koo mu dokewɑ mi u rɑɑ ɡesi yɛm tɛɛni. ");
INSERT INTO bba_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Yen biru ɡum mɛ mu tie win nɔmɑɔ, u koo mu wisiwɑ wi u rɑɑ bɑrɑ disiɡiru mɔn wirɔ u sere nùn dɛɛrɑsiɑbun wororu kuɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Yen biru, u koo ɡunɔ ɡen teu ɡo, ɡèn bweseru u wɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Bɑ koo kɑ ɡen teu torɑrun suurun yɑ̃kuru ko. Teu mɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kɑ som mɛ, kɑ ɡum mɛ. Kpɑ yɑ̃ku kowo wi, u wi u rɑɑ bɑrɑ disiɡiru mɔ dɛɛrɑsiɑbun wororu kuɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Woodɑ yeniwɑ wi u bɑrɑ disiɡiru mɔ mɑ u ǹ dɑm mɔ u koo swĩi u kɑ dɛɛrɑsiɑbun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","sɑnɑm mɛ i ko i du Kɑnɑnin temɔ mɛ kon bɛɛ wɛ̃, nɑ̀ n derɑ disi ɡɔmi yi kpiɑ diru ɡɑru sɔɔ tè sɔɔ i wɑ̃ɑ, ");
INSERT INTO bba_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","wi u dii te mɔ, u koo dɑwɑ u yɑ̃ku kowo sɔ̃ u nɛɛ, wee u ɡɑ̃ɑnu wɑɑmɔ win dirɔ nɡe disi ɡɔmi. ");
INSERT INTO bba_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Yɑ̃ku kowo wi, u sere du u kɑ dii te mɛɛri, u koo dewɑ bu ten yɑ̃nu kpuro yɑrɑ kpɑ yɑ̃ɑ nin tii nu ku rɑɑ disi duurɑ. Yen biru u koo du kpɑ u disi ɡɔmi yi mɛɛri. ");
INSERT INTO bba_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Ù n deemɑ ɡɔmi yi sɑ̃ɑ nɡe wuru bekusu, ǹ kun mɛ yi sɔ̃ri, kpɑ yi n sɑ̃ɑ nɡe wɔru ɡɑnɑ ye sɔɔ, ");
INSERT INTO bba_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","u koo yɑriwɑ kpɑ u dii te kɛnɛ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Sɔ̃ɔ nɔɔbɑ yiruse, yɑ̃ku kowo u koo wurɑ diru mi. Ù n deemɑ disi ɡɔmi yi yɑbi dii ten ɡɑni sɔɔ, ");
INSERT INTO bba_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","u koo de bu dii ten kpenu wɔɔriwɑ nìn mi disi ɡɔmi yi, yi kpiɑ bu kɑ nu yɑri wuun di bu kɔ̃ mi n kun dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","U koo dewɑ bu dii ten sɔɔwɔ kpuro kɛrɑ kpɑ bu yɑnim mɛ bɑ kɛrɑ mi yɑri wuun biruɔ mi n kun dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Yen biru kpɑ bu kpee kpɑɑnu kɔsire ko. Kpɑ bu wure bu dii te tɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","Amɛn biru, disi ɡɔmi yi, yì n mɑɑ wurɑmɑ dii te sɔɔ, ");
INSERT INTO bba_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","yɑ̃ku kowo u koo mɑɑ sewɑ u dɑ u tu mɛɛri. Ù n deemɑ disi ɡɔmi yi, yi mɑɑ kpiɑ dii ten ɡɑni sɔɔ, sɑɑ ye sɔɔ, n ǹ mɑɑ koorɔ bu yi wĩɑ min di. Dii te, tɑ disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Bɑ koo tu surɑwɑ kpɑ bu ten kpenu kɑ dɑ̃ɑ kɑ tem ɡurɑ bu kɑ dɑ wuun biruɔ mi n kun dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Wi u duɑ diru mi sɑnɑm mɛ bɑ tu kɛnusi, u disi duurɑwɑ mi sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Wi u kpunɑ mi, ǹ kun mɛ u ɡɑ̃ɑnu di mi, u koo win yɑ̃nu teɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","Sɑnɑm mɛ bɑ dii te sɔnwɑ bɑ kpɑ, yɑ̃ku kowo ù n wurɑ u kɑ tu mɛɛri, mɑ u deemɑ disi ɡɔmi yi sɑri, u koo dii te ɡɑrisiwɑ tɑ dɛɛre. Domi disi ɡɔmi yi, yi doonɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Bu kɑ dii ten dɛɛrɑsiɑbun woronu ko, bɑ koo ɡunɔsu yiru kɑsuwɑ kɑ dɑ̃ɑ ye bɑ mɔ̀ sɛduru kɑ kiku ɡe bɑ mɔ̀ isɔpu kɑ wɛ̃ɛ wunɔmɡii. ");
INSERT INTO bba_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","U koo ɡunɔ ɡen teu sɑkɑwɑ wekeru sɔɔ te bɑ kuɑ kɑ sɔndu tɑ nim ɡem mɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Yen biru, u koo ɡe ɡɑ wɑsi suɑ kɑ sɛduru ye, kɑ isɔpu ye, kɑ wɛ̃ɛ wunɔmɡii yi, kpɑ u ye kpuro doke ɡunɔ ɡe bɑ sɑkɑn yɛm mɛ sɔɔ, mɛ bɑ wisi nim sɔɔ mi, kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru dii te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","U koo kɑ ɡunɔ ɡen yɛm mɛ bɑ wisi nim sɔɔ mi, disi wɔkɑ kɑ ɡunɔ ɡe ɡɑ wɑsi kɑ sɛduru ye, kɑ isɔpu kɑ wɛ̃ɛ wunɔmɡii yi. ");
INSERT INTO bba_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Kpɑ u ɡunɔ ɡe ɡɑ wɑsi yɔ̃su ɡu doonɑ yɑkɑsɔ. Sɑɑ ye sɔɔrɑ u koo dii te dɛɛrɑsiɑbun wororu koosi kpɑ tu dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Woodɑ yenibɑrɑ bɑ ko n dɑ swĩi bɑrɑ disiɡiru kɑ wii kpɑkin sɔ̃ ");
INSERT INTO bba_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","56","kɑ mɔsiru kɑ debu kɑ disi ɡɔmi yi yi rɑ kpi yɑ̃nu sɔɔ kɑ diɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Woodɑ yerɑ yɑ koo sɔ̃ɔsi ɡɑ̃ɑ ni nu dɛɛre kɑ ni nu kun dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","i Isirelibɑ sɔ̃ɔwɔ i nɛɛ, ben ɡoo ù n kentu kpikɑ mɔ, u kuɑwɑ mi disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Yɑ rɑ wĩ? Yɑ ku rɑ wĩ? Kɑ mɛ, u kuɑwɑ mi disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","Kpin yee tè sɔɔ u kpunɑ kpuro, tɑ disi duurɑwɑ mi, kɑ sere mɑɑ ɡɑ̃ɑ ni u sinɑri kpuro. ");
INSERT INTO bba_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Wi u mɑɑ kpin yee te bɑbɑ kpuro u koo win yɑ̃nu teɑwɑ kpɑ u wobure kɑ nim. Adɑmɑ kɑ mɛ, yɛ̃ro u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Wi u mɑɑ sinɑ mi bɑrɔ wi, u sinɑ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure kɑ nim. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Wi u bɑrɔ wi bɑbɑ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure kɑ nim. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Bɑrɔ wi, ù n ɡoo yɑ̃ɑtɑm sie, yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Gɑ̃ɑ ni bɑrɔ wi, u sɔni kpuro, nu kuɑwɑ mi disiɡinu. ");
INSERT INTO bba_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Gɑ̃ɑ ni u sɑkusi kpuro, wi u nu bɑbɑ yɛ̃ro u kuɑwɑ mi disiɡii sere kɑ yokɑɔ. Wi u mɑɑ nu sɔɔwɑ yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Wi u derɑ bɑrɔ wi, u nùn bɑbɑ, mɑ u ǹ niɛ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, yɛ̃ro u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Bɑrɔ wi, ù n dendi yɑ̃nu bɑbɑ ni bɑ kuɑ kɑ sɔndu bɑ koo nu kɔsukuwɑ. Nù n mɑɑ sɑ̃ɑn nɑ ni bɑ kuɑ kɑ dɑ̃ɑ, bɑ koo nu teɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","Sɑnɑm mɛ kentu ye, yɑ wĩibu yɔ̃rɑ, u koo kowɑ sɔ̃ɔ nɔɔbɑ yiru u sere dɛɛrɑ. U koo win yɑ̃nu teɑ kpɑ u wobure kɑ nim. Sɑɑ ye sɔɔ, u dɛɛrɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Sɔ̃ɔ nɔɔbɑ itɑse u koo kpɑrukonu yiru ǹ kun mɛ totobɛrɛnu yiru suɑ u kɑ dɑ Gusunɔn kurun kɔnnɔwɔ kpɑ u nu yɑ̃ku kowo wɛ̃. ");
INSERT INTO bba_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Yɑ̃ku kowo u koo nin teu ɡowɑ torɑrun sɔ̃. Kpɑ u kɑ teu ɡeni yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko kpɑ u nùn dɛɛrɑsiɑbun wororu koosi Yinni Gusunɔn wuswɑɑɔ kpɑ u dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","Goon sen nim mù n yɑri, u koo woburewɑ. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Mù n yɑ̃nu ɡɑnu tɑ̃re, ǹ kun mɛ ɡɔnɑ ye bɑ rɑ wukiri, bɑ koo ye teɑwɑ kɑ nim. Adɑmɑ kɑ mɛ, yɑ ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Kurɔ kɑ durɔ bɑ̀ n mɛnnɑ, be kpuro bɑ koo woburewɑ kɑ nim. Adɑmɑ kɑ mɛ, bɑ koo bu ɡɑrisiwɑ disiɡibu sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","Tɔn kurɔ ù n yɑsɑ mɔ̀, bɑ koo nùn ɡɑrisiwɑ disiɡii sɔ̃ɔ nɔɔbɑ yiru. Wi u nùn bɑbɑ kpuro u kuɑwɑ mi disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Kpin yee tè sɔɔ u kpunɑ kpuro, tɑ kuɑwɑ mi disiɡiru. Ye u mɑɑ sinɑri kpuro yɑ kuɑwɑ mi disiɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Wi u mɑɑ kurɔ win kpin yeru bɑbɑ, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Goo ù n bɑbɑ ye kurɔ wi, u sinɑri, yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Gɑ̃ɑ ni nu wɑ̃ɑ win kpin yee ten wɔllɔ ǹ kun mɛ ye u sinɑrin wɔllɔ, wi u yen ɡɑɑ bɑbɑ, u kuɑwɑ mi disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Tɔn durɔ ɡoo ù n kɑ nùn mɛnnɑ, mɑ win yɛm mu nùn tɑ̃re, durɔ wi, u kuɑwɑ mi disiɡii sere sɔ̃ɔ nɔɔbɑ yiru. Kpin yee tè sɔɔ u ɡesi kpunɑ tɑ mɑɑ disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","Tɔn kurɔ wi u yɛm wĩimɔ, win yɑsɑn sɑɑ bɑɑsi, ǹ kun mɛ, mu wĩimɔ mu win yɑsɑn sɑɑ kerɑ, bɑ koo nùn ɡɑrisiwɑ disiɡii yɛm wĩi bin sɑɑ kpuro sɔɔ nɡe win yɑsɑn sɑɑ. ");
INSERT INTO bba_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Kpin yee tè sɔɔ u kpunɑ kpuro kɑ ye u sinɑri kpuro, yɑ kuɑwɑ mi disiɡiɑ nɡe sɑnɑm mɛ u win yɑsɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Wi u kpin yee te bɑbɑ, ǹ kun mɛ sin yee te, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u kuɑwɑ mi disiɡii sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","Sɑnɑm mɛ yɛm mɛ, mu yɔ̃rɑ u koo kowɑ sɔ̃ɔ nɔɔbɑ yiru bu sere nùn ɡɑrisi wi u dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Yen sɔ̃ɔ nɔɔbɑ itɑse sɔɔrɑ u koo kpɑrukonu yiru ǹ kun mɛ totobɛrɛnu yiru kɑsu kpɑ u kɑ yɑ̃ku kowo dɑɑwɑ Gusunɔn kuu ten kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Kpɑ yɑ̃ku kowo u nin teu suɑ u kɑ torɑrun suurun yɑ̃kuru ko kpɑ u mɑɑ teu ɡeni suɑ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. Yen biruwɑ u koo kurɔ wi dɛɛrɑsiɑbun wororu koosi Yinni Gusunɔn wuswɑɑɔ kpɑ u dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","Yinni Gusunɔ u kpɑm Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, i Isirelibɑ sɔ̃ɔwɔ i nɛɛ, bu de bu kɑ nɛn kuu te tɑ wɑ̃ɑ ben suunu sɔɔ tondɑ sɑnɑm mɛ bɑ disi mɔ kpɑ bu ku rɑɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Woodɑ yeni yɑ wɑ̃ɑwɑ kentuɡibun sɔ̃ kɑ wìn sen nim mu yɑri ");
INSERT INTO bba_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","kɑ tɔn kurɔ wi u yɑsɑ mɔ̀ kɑ tɔn durɔ wi u yɛm wĩimɔ win tɔn durɔrun di kɑ tɔn kurɔ wi yɛm wĩimɔ win tɔn kurɔrun di kɑ mɑɑ tɔn durɔ wi u kɑ tɔn kurɔ disiɡii kpunɑ. ");
INSERT INTO bba_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Aronin bii be bɑ ɡu Yinni Gusunɔn kurɔ yèn sɔ̃ bɑ kɑ turɑre tukɑ dɑ mi, ben ɡɔɔn biruwɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ɑ wunɛn mɔɔ Aroni sɔ̃ɔwɔ ɑ nɛɛ, u kun dɑ du kiri kiri kuu ten dii te tɑ dɛɛre ɡem ɡem sɔɔ mi woodɑn kpɑkororɑ wɑ̃ɑ kɑ ten wukiritiɑ kpɑ u ku rɑɑ ɡbin sɔ̃. Domi kpɑkoro ten wukiritiɑn wɔllɔwɑ kon tii sɔ̃ɔsi ɡuru wii wuroru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Dɔmɑ te u duɔ mi, u koo kɛtɛ kinɛ kpɛndu kɑsuwɑ u kɑ win torɑrun yɑ̃kuru ko. Kpɑ u mɑɑ yɑ̃ɑ kinɛru kɑsu u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Yen biru u koo win tɑko doke kpɑ u sokoto kpiribu doke kɑ sɛ̃kɑtiɑ. Ye kpuro yɑ ko n sɑ̃ɑwɑ ye bɑ kuɑ kɑ wɛ̃ɛ dɑmɡii kpɑ u dɑwɑni bɔke. U koo woburewɑ u sere yɑ̃ɑ ni kpuro doke. ");
INSERT INTO bba_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Isirelibɑ bɑ koo mɑɑ boo kinɛnu yiru wɛ̃ u kɑ ben torɑnun yɑ̃kunu ko kpɑ bu nùn yɑ̃ɑ kinɛru wɛ̃ u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","Ù n koo yɑ̃kuru tore, u koo ɡinɑ win tii kɑ win yɛnuɡibun torɑnun yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ te. ");
INSERT INTO bba_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Yen biru kpɑ u boo kinɛnu yiru ye suɑ u kɑ dɑ Yinni Gusunɔn wuswɑɑɔ kuu ten kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Kpɑ u nu tubu tubu koosi u kɑ wɑ ɡe ɡɑ sɑ̃ɑ Yinni Gusunɔɡuu kɑ ɡe bɑ koo yɔ̃su ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Boo ɡe ɡɑ sɑ̃ɑ Yinni Gusunɔɡuu, ɡerɑ u koo kɑ torɑrun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Ge bɑ koo mɑɑ yɔ̃su ɡbɑburɔ, ɡerɑ bɑ koo kɑ torɑrun suurun wororu ko. Wɑsirɑ bɑ koo kɑ ɡu nɑ Yinni Gusunɔn wuswɑɑɔ bu sere ɡu yɔ̃su ɡu doonɑ ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","Aroni u koo ɡinɑ ɡbiwɑ u win tiin kɛtɛ kinɛ te ɡo win torɑnun sɔ̃ kɑ sere mɑɑ win yɛnuɡibuɡinun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Kpɑ u dɔ̃ɔ ɡɛ̃ɛ ɡurɑ sɑɑ yɑ̃ku yerun di yi bɑ yibie dɔ̃ɔ ɡurɑtii sɔɔ kpɑ u turɑre buuru sɔkɑ nɔm kurenu yiru kpɑ u kɑ ye kpuro du dii te tɑ dɛɛre ɡem ɡem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","U koo turɑre ye doke dɔ̃ɔ ɡɛ̃ɛ yi sɔɔ Yinni Gusunɔn wuswɑɑɔ kpɑ yen wiisu su woodɑn kpɑkoro ten wukiritiɑ wukiri kpɑ u ku rɑɑ kɑ ɡbin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Yen biru kpɑ u kɛtɛ yen yɛm suɑ u dɛkɑ kɑ win niki biɑ kpɑ u mu yɛ̃kɑ kpɑkoro ten wukiritiɑ sɔɔ sɔ̃ɔ yɑri yeru ɡiɑ. Kpɑ u mɑɑ ko mɛ kpɑkoro ten wuswɑɑɔ nɔn nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","Yen biruwɑ u koo mɑɑ boo ɡe ɡɑ sɑ̃ɑ Yinni Gusunɔɡuu mi ɡo Isirelibɑ kpuron torɑnun sɔ̃ kpɑ u ɡen yɛm suɑ u kɑ dɑ dii te tɑ dɛɛre ɡem ɡem sɔɔ kpɑ u mu yɛ̃kɑ woodɑn kpɑkoro ten wukiritiɑ wɔllɔ kɑ mɑɑ ten wuswɑɑɔ nɡe mɛ u kuɑ kɑ kɛtɛ yen yɛm. ");
INSERT INTO bba_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Kpɑ u dii te tɑ dɛɛre ɡem ɡem dɛɛrɑsiɑbun wororu koosi u kɑ ten disi wɔkɑ yi tɑ duurɑ Isirelibɑn torɑnu kɑ ben mɛm nɔɔbu sɑrirun sɔ̃. Nɡe mɛyɑ u koo ko u kɑ dii dɛɛrɑ ten disi wɔkɑ, domi tɑ wɑ̃ɑ disiɡibun suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Goo kun ko n wɑ̃ɑ dii ten sɔɔwɔ sɑnɑm mɛ Aroni u koo du mi, u kɑ torɑnun yɑ̃kuru ko sere u dɑ u kɑ yɑrimɑ. U koo win tii kɑ win yɛnuɡibun torɑnun yɑ̃kuru ko. Yen biru kpɑ u mɑɑ Isirelibɑ kpuroɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","Ù n yɑriɔ, u koo dɑwɑ yɑ̃ku yerɔ kpɑ u tu dɛɛrɑsiɑbun wororu koosi. Yen biru kpɑ u kɛtɛ ye, kɑ boo ɡen yɛm suɑ u tɛɛni yɑ̃ku yerun kɑ̃ɑnu nnɛ yen bɑɑyere sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","U koo yɛm mɛ dɛkɑwɑ kɑ win niki biɑ u yɛ̃kɑ nɔn nɔɔbɑ yiru yɑ̃ku yee ten wɔllɔ. Nɡe mɛyɑ u koo kɑ tu dɛɛrɑsiɑ Isirelibɑn torɑnun di kpɑ u tu yi nɛnɛm Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","Sɑnɑm mɛ u dii te tɑ dɛɛre ɡem ɡem dɛɛrɑsiɑ u kpɑ, kɑ dii dɛɛrɑ te, kɑ yɑ̃ku yeru, u koo de bu kɑ boo ɡe ɡɑ wɑsi mi nɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Aroni u koo win nɔmɑ kpuro sɔndiwɑ boo ɡen wiru wɔllɔ kpɑ u Isirelibɑn torɑnu kpuro tuubɑ ko kɑ mɛm nɔɔbu sɑri te bɑ kuɑ kpuro. Kpɑ u boo ɡe torɑ ni kpuro sɔbi kpɑ u de ɡoo u ɡu ɡirɑ u kɑ dɑ ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Nɡe mɛyɑ boo ɡe, ɡɑ koo kɑ Isirelibɑ kpuron torɑnu sɔbe ɡu kɑ doonɑ ɡbɑburɔ mi ɡoo kun wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","Yen biru u koo wurɑ kuu ten mi, kpɑ u win sɑ̃ɑ yɑ̃ɑ ni u doke potiri u nu yi mi. ");
INSERT INTO bba_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Kpɑ u wobure yɑm dɛɛrɑmɔ kpɑ u win tiin yɑ̃nu doke. Yen biru kpɑ u yɑri u nɑ u yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko win tiin sɔ̃ kɑ sere mɑɑ Isirelibɑn sɔ̃. Yen biru kpɑ u torɑrun yɑ̃kuru ko win tiin sɔ̃ kɑ sere Isirelibɑn sɔ̃. Kpɑ u suuru kɑnɑbun woronu ko win tii kɑ Isirelibɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Yen biru kpɑ u yɑɑ yen ɡum dɔ̃ɔ doke yɑ̃ku yerɔ ye bɑ kɑ torɑrun yɑ̃kuru kuɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","Wi u boo ɡe ɡirɑ u kɑ dɑ ɡbɑburɔ u koo win yɑ̃nu teɑwɑ kpɑ u wobure u sere du sɑnsɑniɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Kɛtɛ ye, kɑ boo ɡen yɛm mɛ bɑ kɑ dɑ dii te tɑ dɛɛre ɡem ɡem sɔɔ torɑnun sɔ̃, bɑ koo yen yɑɑ kɑ yen ɡɔni kɑ yen bisu yɑrɑwɑ ben sɑnsɑnin di bu dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Wi u ye kpuro dɔ̃ɔ mɛni u koo win yɑ̃nu teɑwɑ kpɑ u wobure u sere wurɑmɑ sɑnsɑniɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkuruse, i nɔɔ bɔkuo kpɑ i bɛɛn sɔmɑ deri sere kɑ sɔbɔ be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Domi tɔ̃ɔ te sɔɔrɑ bɑ koo bɛɛ torɑrun yɑ̃kuru kuɑ bu kɑ bɛɛ dɛɛrɑsiɑ. Nɡe mɛyɑ i ko i kɑ dɛɛrɑ bɛɛn durum kpuron di Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Tɔ̃ɔ te, tɑ koo kowɑ tɔ̃ɔ wɛ̃rɑruɡiru kpɑ i n dɑ nɔɔ bɔke. Kpɑ yɑ n sɑ̃ɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Amɛn biru yɑ̃ku kowo wi bɑ ɡum tɑ̃re bɑ ɡɔsɑ u kɑ ko yɑ̃ku kowo tɔnwero win bɑɑbɑn kɔsire, wiyɑ u koo sɑ̃ɑ yɑ̃ɑ ni doke ni bɑ kuɑ kɑ wɛ̃ɛ dɑmɡii. ");
INSERT INTO bba_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Wiyɑ u ko n dɑ yɑ̃kuru ko u kɑ dii te tɑ dɛɛre ɡem ɡem dɛɛrɑsiɑ kɑ sere dii dɛɛrɑ te, kɑ yɑ̃ku yee te, kɑ yɑ̃ku kowobu kɑ sere mɑɑ Isirelibɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. Wɔ̃ɔ tiɑ sɔɔ, bɑ ko n dɑ yɑ̃kuru kowɑ Isirelibɑ kpuron torɑnun sɔ̃ nɔn teeru. Mɑ Aroni u kuɑ kpuro ye Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","ɑ Aroni kɑ win bibu kɑ sere Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, woodɑ wee ye nɛ, Yinni Gusunɔ nɑ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isirelibɑ sɔɔ ɡoo ù n kĩ u sɑberu ɡɑru sɑkɑ sɑnsɑniɔ ǹ kun mɛ mi u wɑ̃ɑ kpuro, u koo ɡinɑ kɑ tu nɑwɑ nɛn kuu bekuruɡirun kɔnnɔwɔ u kɑ tu yɑ̃kuru ko nɛ, Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","Yɛ̃ro u kun kue mɛ, bɑ koo nùn sɑbe ten yɛm bikiɑwɑ domi u yɛm yɑriwɑ mi. Sɑɑ ye sɔɔ, bɑ koo yɛ̃ro yɑrɑwɑ Isirelibɑn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Woodɑ yeni yɑ koo dewɑ Isirelibɑ bu kɑ ben yɑɑ sɑbenu nɑ yɑ̃ku kowon mi nɛn kuu ten kɔnnɔwɔ bu ɡo nɛ, Yinni Gusunɔn wuswɑɑɔ. Kpɑ bu ku rɑɑ tu ɡo mi bɑ turɑ. Kpɑ tɑ n sɑ̃ɑ siɑrɑbun yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Yɑ̃ku kowowɑ u koo ten yɛm mɛ yɛ̃kɑ yɑ̃ku yerɔ kuu ten kɔnnɔwɔ. Kpɑ u ten ɡum dɔ̃ɔ doke mɛ̀n nuburu tɑ koo nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Nɡe mɛyɑ Isirelibɑ bɑ ǹ mɑɑ kɑ bũnu yɑ̃kuru kuɑmmɛ nìn bwɑ̃ɑrokunu nu kɑ bonu weenɛ. Yeni yɑ ko n wɑ̃ɑwɑ ben tiin sɔ̃ kɑ ben bibun bibun sɔ̃ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","Ǹ n mɛn nɑ, Isireli ɡoo, ǹ kun mɛ sɔɔ ɡoo wi u wɑ̃ɑ ben suunu sɔɔ, ù n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀, ǹ kun mɛ yɑ̃kunu ɡɑnu, ");
INSERT INTO bba_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","mɑ u ǹ kɑ nu nɛ nɛ, Yinni Gusunɔn kurun kɔnnɔwɔ u kɑ nin yɑɑ ɡo, bɑ koo yɛ̃ro yɑrɑwɑ ben suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","Wee woodɑ ye nɛ, Yinni Gusunɔ nɑ mɑɑ wɛ̃ɛmɔ. Isireli ɡoo, ǹ kun mɛ sɔɔ ɡoo wi u wɑ̃ɑ ben suunu sɔɔ ù n yɛm di, bɑɑ ǹ n mɛren nɑ mu sɑ̃ɑ, nɛ, Yinni Gusunɔwɑ kon yɛ̃ro wɔrimɑ n nùn yɑrɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Domi yɛm sɔɔrɑ hunde koni kpuron wɑ̃ɑrɑ wɑ̃ɑ. Nɑ derɑ i yɛm dendimɔ yɑ̃ku yerɔ i kɑ bɛɛn torɑnun suuru wɑ. Yɛm mɛyɑ mu rɑ de tɔnu u win torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Yen sɔ̃nɑ nɑ nɛɛ, Isirelibɑn ɡoo ǹ kun mɛ sɔɔ ɡoo bɛɛn suunu sɔɔ u ǹ yɛm dimɔ. ");
INSERT INTO bba_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","Bɛɛ Isirelibɑn ɡoo ǹ kun mɛ sɔɔ ɡoo wi u wɑ̃ɑ bɛɛn suunu sɔɔ, ù n yɑɑ ɡɑɑ mwɑ tɑɑsoru sɔɔ ǹ kun mɛ ɡunɔ ɡɑɡu ɡe bɑ rɑ di, u koo yɑɑ ye, ǹ kun mɛ ɡunɔ ɡen yɛm yɑriwɑ kpɑ u mu yɑnim wukiri. ");
INSERT INTO bba_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Domi hunde koni ye yɑ wɑsi kpuro, yen wɑ̃ɑrɑ wɑ̃ɑwɑ yen yɛm sɔɔ. Yen sɔ̃nɑ nɑ nɛɛ, i ku hunde koni ɡɑɑn yɛm di. Domi yɛm sɔɔrɑ wɑ̃ɑrɑ wɑ̃ɑ. Wi u mɑɑ yinɑ u mu di, bɑ koo yɛ̃ro wunɑwɑ wiɡibun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","Bɛɛ Isirelibɑn ɡoo, ǹ kun mɛ sɔɔ ɡoo wi u wɑ̃ɑ bɛɛn suunu sɔɔ, ù n yɑɑ ɡoru di ǹ kun mɛ yɑɑ ye ɡbeeku yɑɑ yɑ ɡo, yɛ̃ro u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Adɑmɑ kɑ mɛ, u ko n sɑ̃ɑwɑ disiɡii sere kɑ tɔ̃ɔ ten yokɑɔ u sere dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Ù kun win yɑ̃ɑ ni teye, mɑ u ǹ woburɑ, u koo win torɑrun ɑre mwɑ. ");
INSERT INTO bba_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, nɛnɑ nɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","I ku rɑ ko ye bɑ rɑ ko Eɡibitiɔ mi i rɑɑ sinɑ. I ku mɑɑ ko ye Kɑnɑnibɑ mɔ̀ mi nɑ kɑ bɛɛ dɔɔ. I ku ben komɑnu swĩi. ");
INSERT INTO bba_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Adɑmɑ i nɛn woodɑbɑ kɑ nɛn yiirebu mɛm nɔɔwɔ kpɑ i ye swĩi. Domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ǹ n mɛn nɑ, i nɛn ɡere kɑ nɛn woodɑbɑ mɛm nɔɔwɔ. Wi u ye mɛm nɔɔwɑ u ko n wɑ̃ɑwɑ yen sɔ̃. Nɛ Yinni Gusunɔwɑ nɑ yeni ɡerumɔ. ");
INSERT INTO bba_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","Nɛnɑ nɑ woodɑ yenibɑ wɛ̃ɛmɔ. Nɑ nɛɛ, bɛɛn ɡoo u ku rɑɑ kɑ win dusi tɔn kurɔ kɔ̃ɔ mɛnnɑ. ");
INSERT INTO bba_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","I ku bɛɛn tundo sekuru doke i kɑ bɛɛn mɛro kɔ̃ɔ mɛnnɑ. Domi u sɑ̃ɑwɑ bɛɛn mɛro. ");
INSERT INTO bba_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","I ku kɑ bɛɛn mɛron nisi ɡoo kɔ̃ɔ mɛnnɑ, domi ì n kuɑ mɛ, i bɛɛn tundo sekuru dokewɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","I ku kɑ bɛɛn sesu tundo turosi ǹ kun mɛ mɛro turosi kɔ̃ɔ mɛnnɑ bɑɑ bɑ̀ kun bɛɛ seeye yɛnu teu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","I ku kɑ bɛɛn nikurɔbu kɔ̃ɔ mɛnnɑ bɑɑ ù n sɑ̃ɑn nɑ tɔn durɔn bii, ǹ kun mɛ tɔn kurɔn bii. Domi wi u kuɑ mɛ, u tii sekuru dokewɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","I ku kɑ bɛɛn tundon kurɔ ɡoon bii kɔ̃ɔ mɛnnɑ domi u sɑ̃ɑwɑ bɛɛn sesu. ");
INSERT INTO bba_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","I ku kɑ bɛɛn tiɔ kɔ̃ɔ mɛnnɑ, domi u sɑ̃ɑwɑ bɛɛn tundon dusi. ");
INSERT INTO bba_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","I ku mɑɑ kɑ bɛɛn mɛron wɔnɔ ǹ kun mɛ win mɔɔ kɔ̃ɔ mɛnnɑ. Domi u sɑ̃ɑwɑ bɛɛn mɛron dusi. ");
INSERT INTO bba_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","I ku mɑɑ bɛɛn tundon wɔnɔ ǹ kun mɛ win mɔɔ sekuru doke i kɑ win kurɔ kɔ̃ɔ mɛnnɑ. Domi kurɔ wi, u sɑ̃ɑwɑ nɡe bɛɛn tiin mɛro. ");
INSERT INTO bba_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","I ku kɑ bɛɛn biɡii kurɔ kɔ̃ɔ mɛnnɑ, domi u sɑ̃ɑwɑ bɛɛn biin kurɔ. ");
INSERT INTO bba_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","I ku kɑ bɛɛn wɔnɔ ǹ kun mɛ bɛɛn mɔɔn kurɔ kɔ̃ɔ mɛnnɑ. Ì n kuɑ mɛ, i nùn sekuru dokewɑ. ");
INSERT INTO bba_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","I ku kɑ tɔn kurɔ kɔ̃ɔ mɛnnɑ kpɑ i mɑɑ kɑ win bii kɔ̃ɔ mɛnnɑ, ǹ kun mɛ win nikurɔbu, domi bɑ sɑ̃ɑwɑ mi dusinu. Ì n kuɑ mɛ, yɑ sɑ̃ɑwɑ mi torɑ bɑkɑru. ");
INSERT INTO bba_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","I ku bɛɛn kurɔn wɔnɔ ǹ kun mɛ win mɔɔ suɑ kurɔ sɑnɑm mɛ kurɔ win tii u wɑ̃ɑ wɑ̃ɑru sɔɔ. Domi yɑ koo nisinu mɑ. ");
INSERT INTO bba_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","I ku kɑ tɔn kurɔ mɛnnɑ sɑnɑm mɛ u yɑsɑ mɔ̀, domi u sɑ̃ɑwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","I ku kɑ bɛɛn winsim kurɔ kɔ̃ɔ mɛnnɑ. Ì n kuɑ mɛ, i tii disi koosiwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","I ku kɑ bɛɛn bii yɑ̃kuru ko bũu wi bɑ mɔ̀ Mɔlɔkun mi. Domi ì n kuɑ mɛ, nɛ, Yinni Gusunɔn yĩsirɑ i sɑnkɑ mi. I n yɛ̃ mɑ nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","I ku kɑ bɛɛn tɔn durɔsi kɔ̃ɔ mɛnnɑ nɡe mɛ i rɑ kɑ tɔn kurɔ ko. Domi yɑ sɑ̃ɑwɑ seku bɑkɑru. ");
INSERT INTO bba_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","I ku kɑ yɑɑ sɑberu kɔ̃ɔ mɛnnɑ nɡe tɔn kurɔ. Domi ì n kuɑ mɛ, i tii disi dokewɑ. Nɡe mɛyɑ mɑɑ tɔn kurɔ ɡoo u ku rɑɑ de yɑɑ sɑberu tu kɑ nùn mɛnnɑ. Yɑ sɑ̃ɑwɑ seku bɑkɑru. ");
INSERT INTO bba_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","I ku de komɑ ninin bweseru nu bɛɛ ko disiɡibu. Domi niyɑ bwese tuku nini nu rɑ ko ni kon ɡirɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Bɑ tem mɛn tii disi doke, mɑ nɑ mu sɛɛyɑsiɑ mɑ mu mɛn tɔmbu yɑrinɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Bɛɛ Isirelibɑ kɑ bɛɛ sɔbu bɛɛ be i wɑ̃ɑ Isirelibɑ sɔɔ, i nɛn ɡere kɑ nɛn woodɑ ye mɛm nɔɔwɔ. Kpɑ i bwese nin komɑ sekuruɡii ni deri. ");
INSERT INTO bba_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Be bɑ rɑɑ sinɑ tem mɛ sɔɔ i sere nɑ, bɑ komɑ ni kuɑ mɑ tem mɛ, mu disi duurɑ. ");
INSERT INTO bba_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Ǹ n mɛn nɑ, bɛɛn tii i ku mu disi doke kpɑ mu ku rɑɑ mɑɑ bɛɛ yɑrinɑsiɑ nɡe yelluɡibu. ");
INSERT INTO bba_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Domi be bɑ komɑ nin ɡɑru sɑɑrɑ Isirelibɑ kpuro sɔɔ, bɑ koo bu wunɑwɑ ben tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Nɛnɑ Gusunɔ bɛɛn Yinni. I de i nɛn ɡere kɑ nɛn woodɑ ye mɛm nɔɔwɑ mɑm mɑm. Kpɑ i ku bwese tuku nin komɑnu swĩi ni bɑ rɑ ko i sere tunumɑ mini. Kpɑ i ku rɑ tii disi doke. ");
INSERT INTO bba_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","ɑ Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, i de i n dɛɛre, domi nɛ Gusunɔ bɛɛn Yinni nɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Yen sɔ̃, bɛɛn bɑɑwure u win tundo kɑ win mɛro bɛɛrɛ wɛ̃ɛyɔ kpɑ u n dɑ wɛ̃re tɔ̃ɔ wɛ̃rɑruɡiru sɔɔ. Nɛnɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","I ku tii bũnu wɛ̃, i ku rɑ mɑɑ bwɑ̃ɑroku ɡɑɡu seku. ");
INSERT INTO bba_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","Ì n nɛ, Yinni Gusunɔ siɑrɑbun yɑ̃kuru kuɑmmɛ, i tu koowo nɡe mɛ tɑ koo kɑ mɑn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","I ko ten yɑɑ diwɑ dɔmɑ te i kɑ ye yɑ̃kuru kuɑ ǹ kun mɛ sisiru. Adɑmɑ ye yɑ tiɑrɑ sɔ̃ɔ itɑse, i ko ye dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Ì n ye di sɔ̃ɔ itɑse, nɑ ǹ yɑ̃ku te mwɑɑmɔ. Domi yɑɑ ye, yɑ disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Wi u ye di u koo win torɑrun ɑre wɑ, domi u ǹ ye ɡɑrisi nɛɡiɑ. Bɑ koo yɛ̃ro wunɑwɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","Ì n bɛɛn dĩɑnu ɡɛ̃ɛmɔ, i ku ɡɛ̃ ye yɑ wɑ̃ɑ ɡbee ɡoorɔ. I ku mɑɑ bɛɛn ɡberun dĩɑnu kunɔnu ko. ");
INSERT INTO bba_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Mɛyɑ i ku mɑɑ resɛm ɡberu sɔɔ resɛm kunɔnu ko kɑ mɑɑ resɛm ye yɑ wɔrumɑ. I ko ye deriwɑ sɑ̃ɑrobu kɑ sɔbun sɔ̃. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","I ku ɡbɛni, i ku mɑɑ bɛɛn winsim weesu kuɑ ǹ kun mɛ i nùn nɔni wɔ̃ke. ");
INSERT INTO bba_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","I ku bɔ̃ri weesuɡii ko kɑ nɛn yĩsiru. Domi ì n kuɑ mɛ, i nɛn yĩsiru sɑnkɑwɑ. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","I ku bɛɛn winsim dɑm dɔre. I ku mɑɑ nùn ɡɑ̃ɑnu mwɑɑri kɑ dɑm. I ku bɛɛn sɔm kowon kɔsiɑru nɛnɛ sere yɑm mu kɑ sɑ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","I ku soso wɔmɛ. I ku mɑɑ ɡɑ̃ɑnu yi wɔ̃kon wuswɑɑɔ ni nu koo nùn surɑ. I de bɛɛn dɑɑ yu sɔ̃ɔsi mɑ i mɑn nɑsie nɛ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","I ku murɑfitiru ko siribu sɔɔ. I ku ɡoon bwɛ̃ɛbwɛ̃ɛru ǹ kun mɛ win dɑm mɛɛri i kɑ nùn siri. Adɑmɑ i ko i bu siriwɑ nɡe mɛ bɑɑwuren ɡem mu nɛ. ");
INSERT INTO bba_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","I ku ɡɑri weesuɡii kpɑrɑ bɛɛn tɔnusin sɔ̃. I ku mɑɑ nùn ɡɑri mɑni yi yi koo nùn ɡo. ");
INSERT INTO bba_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","I ku bɛɛn winsim tusi ɡɔ̃ruɔ. Adɑmɑ i nùn ɡerusio kpɑ i ku rɑ tii durum sɔbi win sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","I ku bɛɛn winsim mɔru kɔsie. I ku mɑɑ kɑ ɡoo mɔru nɛnɛ. I bɛɛn tɔnusi kĩɔ nɡe bɛɛn tii. Nɛ Yinni Gusunɔwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","I de i nɛn woodɑ yenibɑ mɛm nɔɔwɑ. I ku de yɛɛ bwese bwesekɑ yu yɔɔnɑ. I ku dĩɑ bwesenu yiru duure ɡbee teeru sɔɔ. I ku yɑ̃nu doke ni bɑ kuɑ kɑ wɛ̃ɛ bwesenu yiru. ");
INSERT INTO bba_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","Goo ù n kɑ yoo tɔn kurɔ kɔ̃ɔ mɛnnɑ wi bɑ durɔ kɑ̃, ɑdɑmɑ bɑ ǹ ɡinɑ nùn yɑkie win yorun di, yɛ̃ro u koo yen ɡobi kɔsiɑwɑ, ɑdɑmɑ bɑ ǹ bu ɡoomɔ. Domi kurɔ wi, u ɡinɑ sɑ̃ɑ yoo. ");
INSERT INTO bba_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Durɔ win torɑrun sɔ̃, u koo kɑ yɑ̃ɑ kinɛru nɑ Yinni Gusunɔn wuswɑɑɔ win kurun kɔnnɔwɔ u kɑ torɑrun sɔmbun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Kpɑ yɑ̃ku kowo u nùn torɑrun suurun wororu koosi nɛ Yinni Gusunɔn wuswɑɑɔ. Sɑɑ ye sɔɔrɑ u koo win torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","Sɑnɑm mɛ i duɑ Kɑnɑnin temɔ i kpɑ, mɑ i dɑ̃ɑ bwese bwesekɑ duurɑ, i ko yen mɑrum ɡɑrisiwɑ disiɡim, wɔ̃ɔ itɑ. I ǹ mu dimɔ. ");
INSERT INTO bba_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Wɔ̃ɔ nnɛsen mɑrum mɛ yɑ koo mɑ, mu ko n sɑ̃ɑwɑ nɛ Yinni Gusunɔɡim, i kɑ mɑn siɑrɑ tɔ̃ɔ bɑkɑrun sɑɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Sɑɑ wɔ̃ɔ nɔɔbusen diyɑ bɛɛn tii i ko i n dɑ dɑ̃ɑ mɑrum mɛ sɔri i di. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","I ku ɡɑ̃ɑnu ɡɑnu di kɑ yɛm. I ku wɛɛ ǹ kun mɛ ɡuru wiru mɛɛri i kɑ bikiɑru ko. ");
INSERT INTO bba_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","I ku bɛɛn wirun ɡoo ɡookɑn seri kɔni bwɛɛrɛkɛ. I ku mɑɑ bɛɛn toburun beri berikɑ kɔni. ");
INSERT INTO bba_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","I ku bɛɛn wɑsi muriri ɡoon ɡɔɔn sɔ̃. I ku mɑɑ bɛɛn wɑsi yore. Nɛ, Yinni Gusunɔwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","I ku bɛɛn bii wɔndiɑbɑ sekuru doke i bu kurɔ tɑnɑru kpɛ̃ɛ sɑ̃ɑru ɡɑrun sɔ̃, kpɑ sɑkɑrɑru kɑ sekuru sɑriru tu ku rɑɑ yibu tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","I n dɑ tɔ̃ɔ wɛ̃rɑruɡiru yɑɑye kpɑ i nɛn kuu bekuruɡiru bɛɛrɛ wɛ̃. Nɛ, Yinni Gusunɔwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","I ku dɑ be bɑ rɑ ɡɔribu sokun mi ǹ kun mɛ sɔrobun mi kpɑ i ku rɑ kɑ tii disi doke. Domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","I wi u seri kpiki mɔ kpuro kpunɔ kpɑ i durɔ tɔkɔ bɛɛrɛ wɛ̃. I mɑɑ nɛ, Yinni Gusunɔ nɑsio. Domi nɛnɑ nɑ sɑ̃ɑ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","Sɔɔ ɡoo ù n wɑ̃ɑ bɛɛn tem sɔɔ, i ku nùn dɑm dɔre. ");
INSERT INTO bba_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","I ko i nùn kuɑwɑ nɡe kpɑɑ yɛ̃ro, kpɑ i nùn kĩɑ nɡe bɛɛn tii. Domi bɛɛn tii i rɑɑ sɔru di Eɡibitiɔ. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","I ku murɑfitiru ko siribu sɔɔ, kɑ ɡɑ̃ɑ yĩirubu sɔɔ, kɑ kilobɑ sɔɔ kɑ sɑkɑkunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","I de bɛɛn kilobɑ kɑ bɛɛn sɑkɑkunu ye kpuro yɑ n sɑ̃ɑ dee dee. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye ɡeruɑ, nɛ wi nɑ bɛɛ yɑrɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","I nɛn woodɑbɑ kpuro mɛm nɔɔwɔ kpɑ i ye swĩi. Nɛ, Yinni Gusunɔwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ben ɡoo ǹ kun mɛ sɔɔ wi u wɑ̃ɑ be sɔɔ ù n win bii suɑ u kɑ bũu wi bɑ mɔ̀ Mɔlɔku yɑ̃kuru kuɑ, bɑ koo nùn kɑsukuwɑ bu ɡo. ");
INSERT INTO bba_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Nɛ, Yinni Gusunɔwɑ kon nùn wɔri kpɑ n nùn wunɑ nɛn tɔmbun suunu sɔɔn di yèn sɔ̃ u kɑ win bii Mɔlɔku yɑ̃kuru kuɑ mɑ u nɛn kuru disi doke u nɛn yĩsi dɛɛrɑru sɑnkɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Isirelibɑ bɑ̀ n yinɑ bu durɔ win bweseru ɡo, mɑ bɑ nùn mɛɛrɑ u dɑɑ yen bweseru mɔ̀, ");
INSERT INTO bba_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","nɛn tiiwɑ kon nùn wɔri wi kɑ win yɛnuɡibu kpuro kpɑ n nùn yɑrɑ win tɔmbun suunu sɔɔn di kɑ sere be bɑ mɑɑ Mɔlɔku ye sɑ̃ɑmɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","Goo ù n bikiɑru dɑ ɡɔri sokobun mi ǹ kun mɛ sɔrobun mi, kon nùn wɔriwɑ kpɑ n nùn wunɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","I de i n dɛɛre, domi nɛn tii nɑ dɛɛre. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Nɛnɑ Yinni Gusunɔ wi u bɛɛ ɡɔsɑ i n kɑ dɛɛre. I ko i nɛn woodɑbɑ mɛm nɔɔwɑwɑ kpɑ i sĩ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","Goo ù n win tundo ǹ kun mɛ win mɛro bɔ̃rusi, bɑ koo yɛ̃ro ɡowɑ kpɑ win yɛm mu wɔri win tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","Goo ù n kɑ ɡoon kurɔ kpunɑ, bɑ koo kurɔ wi kɑ durɔ wi ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Goo ù n kɑ win tundon kurɔ kpunɑ, u win tundo sekuru dokewɑ. Bɑ koo yɛ̃ro ɡowɑ kɑ kurɔ wi sɑnnu kpɑ ben yɛm mu wɔri ben tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Goo ù n kɑ win biin kurɔ kpunɑ, bɑ koo yɛ̃ro ɡowɑ kɑ kurɔ wi sɑnnu. Domi seku bɑkɑrɑ bɑ kuɑ mi. Ben yɛm mu koo wɔriwɑ ben tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Tɔn durɔ ù n kɑ win tɔn durɔsi kpunɑ nɡe mɛ bɑ rɑ kɑ tɔn kurɔ mɛnnɛ, bɑ koo be yiru ye kpuro ɡowɑ. Domi ɡɑ̃ɑ kɔ̃sunɑ bɑ kuɑ mi. Ben yɛm mu koo wɔriwɑ ben tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Goo ù n bii kɑ mɛro suɑ kurɔ, torɑ bɑkɑrɑ mi. Bɑ koo be kpuro dɔ̃ɔ mɛniwɑ. Kpɑ yen bweseru yɑ kun wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Goo ù n mɑɑ kɑ yɑɑ sɑberu mɛnnɑ nɡe mɛ bɑ rɑ kɑ tɔn kurɔ mɛnnɛ, bɑ koo yɛ̃ro ɡowɑ kɑ yɑɑ sɑbe ten tii. ");
INSERT INTO bba_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Tɔn kurɔ ù n mɑɑ kɑ yɑɑ sɑberu mɛnnɑ nɡe mɛ bɑ rɑ kɑ tɔn durɔ mɛnnɛ, bɑ koo nùn ɡowɑ kɑ yɑɑ sɑbe ten tii. Kpɑ ben yɛm mu wɔri ben tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","Goo ù n win sesu tundo turosi ǹ kun mɛ mɛro turosi suɑ kurɔ u kɑ kpunɑ, bɑ tii sekuru dokewɑ mi. Bɑ koo bu wunɑwɑ ben tɔmbun suunu sɔɔn di. Durɔ wi, u koo win torɑrun ɑre sɔbewɑ. Domi u kɑ win sesu kpunɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Goo ù n kɑ tɔn kurɔ mɛnnɑ wi u yɑsɑ mɔ̀, mɑ yen yɛm mɛ mu yɑrɑ u mu wɑ, bɑ koo be yiru ye yɑrɑwɑ Isirelibɑn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","I ku kɑ bɛɛn mɛron wɔnɔ ǹ kun mɛ win mɔɔ ǹ kun mɛ bɛɛn tiɔ kɔ̃ɔ mɛnnɑ. Domi i sɑ̃ɑwɑ dusinu. Wi u kuɑ mɛ, u koo yen ɑre wɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Goo ù n kɑ win tundon wɔnɔ ǹ kun mɛ tundon mɔɔn kurɔ kpunɑ, u bu sekuru dokewɑ. Kurɔ wi, kɑ durɔ wi, bɑ koo ben torɑnun ɑre wɑ. Bɑ ǹ bii mɑrumɔ sere bu kɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Goo ù n win wɔnɔ ǹ kun mɛ win mɔɔn kurɔ suɑ, u torɑwɑ mi. U win wɔnɔ ǹ kun mɛ win mɔɔ wi sekuru dokewɑ mi. Kurɔ wi, kɑ durɔ wi, bɑ ǹ bibu mɑrumɔ. ");
INSERT INTO bba_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","I de i nɛn woodɑbɑ kɑ nɛn yiirebu mɛm nɔɔwɑ kpɑ i kɑ ye sɔmburu ko, kpɑ tem mi nɑ kɑ bɛɛ dɔɔ mu ku rɑɑ bɛɛ yɑrinɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","I ku bwese nin komɑnu swĩi ni nɑ kon bɛɛ ɡirɑ. Domi komɑ niyɑ bɑ kuɑ nɑ kɑ bu yinɑ. ");
INSERT INTO bba_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Nɑ bɛɛ sɔ̃ɔwɑ nɑ nɛɛ, bɛɛyɑ i ko i n ben tem mɛ mɔ. Nɛnɑ kon bɛɛ mu wɛ̃. Tem mɛ, mu tim kɑ bom yibɑ. Nɛnɑ Gusunɔ bɛɛn Yinni nɛ wi nɑ bɛɛ wunɑ sɑɑ bwese ni nu tien di. ");
INSERT INTO bba_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Yen sɔ̃nɑ i ko i wunɑnɑ yɑɑ ye i ko i di kɑ ye i kun dimɔ kɑ sere mɑɑ ɡunɔ si i ko i di kɑ si i ǹ dimɔ kpɑ i ku rɑ bɛɛn tɔmbu disi doke yɛɛ yi, kɑ ɡunɔ sin sɔ̃ ye nɑ ɡesi nɛɛ, i ku di mi. ");
INSERT INTO bba_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","I de i n dɛɛre i n wɑ̃ɑ nɛn sɔ̃, domi nɑ dɛɛre. Nɛ, Yinni Gusunɔwɑ nɑ bɛɛ wunɑ nɛnɛm bwese ni nu tien suunu sɔɔn di i n kɑ sɑ̃ɑ nɛɡibu. ");
INSERT INTO bba_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","Goo ù n wɑ̃ɑ bɛɛn suunu sɔɔ, tɔn kurɔ ǹ kun mɛ tɔn durɔ mɑ u rɑ ɡɔribu soku ǹ kun mɛ u rɑ sɔroru ko, bɑ koo yɛ̃ro kpenu kɑsukuwɑ kpɑ win yɛm mu wɔri win tii sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, yɑ̃ku kowo u ku rɑɑ tii disi doke u wiɡii ɡoon ɡoru bɑbɑ ");
INSERT INTO bba_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","mɑ n kun mɔ win mɛro kɑ win tundon ɡoru kɑ win tiin biiɡiru kɑ win wɔnɔ kɑ win mɔɔɡiru ");
INSERT INTO bba_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","kɑ sere win sesu wi u kun durɔ yɛ̃ɡiru wi bɑ ǹ ɡinɑ sue. ");
INSERT INTO bba_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Isirelibɑn suunu sɔɔ, yɑ̃ku kowo wi, u sɑ̃ɑwɑ ben ɡuro ɡuro. Yen sɔ̃, u ǹ koo tii disi doke kɑ ben ɡoon ɡoru. ");
INSERT INTO bba_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","Goo ù n ɡu, yɑ̃ku kowobu bu ku rɑɑ ben wii suunun seri kɔni, bu ku rɑɑ mɑɑ ben toburun beri berikɑ kɔni. ");
INSERT INTO bba_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Mɛyɑ bu ku rɑɑ mɑɑ tii muriri wɑsi sɔɔ. Bɑ ko n wɑ̃ɑwɑ nɛ Gusunɔ ben Yinnin sɔ̃. Bɑ ǹ nɛn yĩsiru sɑnkumɔ. Domi beyɑ bɑ ko n dɑ mɑn yɑ̃kunu kue ni nu sɑ̃ɑ nɛn dĩɑnu. Yen sɔ̃, bɑ ko n dɛɛrewɑ. ");
INSERT INTO bba_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Bɑ ǹ koo kurɔ tɑnɔ ǹ kun mɛ wi bɑ ɡɑbɑ bɑ kɑ kpunɑ suɑ kurɔ. Bɑ ǹ mɑɑ kurɔ wi u win durɔ yinɑ suɑmɔ. Domi bɑ ko n dɛɛrewɑ bɑ n wɑ̃ɑ nɛ, Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Isireli bɑɑwurewɑ u koo yɑ̃ku kowo ɡɑrisi tɔn dɛɛro. Domi wiyɑ u rɑ kɑ bɛɛn yɑ̃kunu nɛ, nɛ, Yinni Gusunɔn mi. Yen sɔ̃, bɑ ko n dɛɛrewɑ, domi nɛ, Yinni Gusunɔ nɑ dɛɛre. Nɛnɑ nɑ bɛɛ ɡɔsɑ i n kɑ mɑɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Yɑ̃ku kowo ɡoon bii wɔndiɑ ù n tii sekuru dokemɔ u kurɔ tɑnɑru dimɔ, win tundowɑ u sekuru dokemɔ. Bɑ koo bii wɔndiɑ wi dɔ̃ɔ mɛniwɑ. ");
INSERT INTO bba_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","Yɑ̃ku kowo wi bɑ ɡum tɑ̃re wirɔ u kuɑ yɑ̃ku kowo tɔnwero, mɑ bɑ nùn sɑ̃ɑ yɑ̃nu dokeɑ, u ku mɑɑ win seri sɑnku ɡoon ɡɔɔn sɔ̃. Mɛyɑ u ku mɑɑ win yɑ̃nu ɡɛ̃ɛku. ");
INSERT INTO bba_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","U ku rɑɑ ɡoru ɡɑru susi u tii disi doke, bɑɑ ǹ n win tundo ǹ kun mɛ win mɛron ɡorun nɑ. ");
INSERT INTO bba_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","U ǹ mɑɑ yɑriɔ nɛn kurun di ɡoon ɡorun sɔ̃, u ku kɑ kuu te disi doken sɔ̃. Domi bɑ nùn ɡum tɑ̃re u n kɑ sɑ̃ɑ nɛnɛm. Nɛ, Yinni Gusunɔwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","Wɔndiɑ wi u kun durɔ yɛ̃wɑ yɑ̃ku kowo tɔnwero u koo suɑ kurɔ. ");
INSERT INTO bba_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","U ǹ koo ɡɔmini ɡoo suɑ kurɔ ǹ kun mɛ kurɔ wi bɑ yinɑ ǹ kun mɛ kurɔ wi bɑ ɡɑbɑ bɑ kɑ kpunɑ ǹ kun mɛ kurɔ tɑnɔ. Adɑmɑ wɔndiɑ wi u kun durɔ yɛ̃wɑ u koo suɑ win dusibu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Kpɑ u ku rɑɑ bwese tukuru doke win bweseru sɔɔ. Nɛ Yinni Gusunɔwɑ nɑ nùn ɡɔsɑ u n kɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, bɑɑ kɑ win bibun bweserɔ ɡoo ù n ɑlebu ɡɑɑ mɔ win wɑsi sɔɔ, yɛ̃ro kun kpɛ̃ u dɑ nɛn kuu te sɔɔ u nɛ, Yinni Gusunɔ dĩɑnu ɡɑnu yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Alebuɡii ɡoo kun kpɛ̃ u nɛn sɔmbu te ko, ɑɑ wɔ̃kowɑ? Aɑ kɔ̃ri bɑrɔwɑ? Ǹ kun mɛ yɛ̃ron wuswɑɑ yɑ kɔsikirewɑ? ");
INSERT INTO bba_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","Ǹ kun mɛ yɛ̃ron nɑɑsu ǹ kun mɛ win ɡɑ̃serɑ bɔɔrewɑ? ");
INSERT INTO bba_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","Ǹ kun mɛ yɛ̃ro u kundu kpiɑwɑ? Ǹ kun mɛ u sɑ̃ɑwɑ tɔn kɔmiɑkubu? Ǹ kun mɛ yɛ̃ron nɔni kpiɑwɑ? Ǹ kun mɛ yɛ̃ro tɑɑtɑɑru ǹ kun mɛ debu mɔwɑ? Ǹ kun mɛ win tĩɑ bii kɔsikirɑ? ");
INSERT INTO bba_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Wi u ɑlebu ɡɑɑ mɔ wɑsi sɔɔ ɡesi Aronin bweseru sɔɔ, u ǹ kpɛ̃ u nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ. U ǹ mɑɑ kpɛ̃ u kɑ dĩɑnu ɡɑnu nɑ u kɑ yɑ̃kuru ko nɛn kuu te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Adɑmɑ u koo kpĩ u nɛ, Yinni Gusunɔn dĩɑ dɛɛrɑnu di. ");
INSERT INTO bba_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Win ɑlebun sɔ̃nɑ u ǹ kpɛ̃ u susi yɑ̃ku yerɔ kɑ kuu ten beku kɑre ten mi. Kpɑ u ku rɑɑ nɛn kuu te disi doke. Nɛ, Yinni Gusunɔwɑ nɑ rɑ yɑ̃ku kowobu ɡɔsi bɑ n kɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Mɑ Mɔwisi u Aroni kɑ win bibu kɑ Isirelibɑ kpuro ɡɑri yi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","ɑ Aroni kɑ win bibu sɔ̃ɔwɔ ɑ nɛɛ, bɑ n tii sɛ dĩɑ ni Isirelibɑ bɑ kɑ mɑn nɑɑwɑmmɛ sɔɔ, kpɑ bu ku rɑɑ nɛn yĩsi dɛɛrɑ te sɑnku. Nɛnɑ nɑ sɑ̃ɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Ben bweseru sɔɔ, ɡoo ù n nu susi, mɑ u disi ɡɛɛ mɔ, bɑ koo yɛ̃ro yɑrɑwɑ nɛn sɔmburun di. ");
INSERT INTO bba_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","Aronin bweseru sɔɔ, ɡoo ù n bɑrɑ disiɡiru mɔ, ǹ kun mɛ ù n kentu kpikɑ mɔ, u ǹ yɑ̃ku dĩɑ ni dimɔ sere ù n dɛɛrɑ, ");
INSERT INTO bba_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","kɑ sere wi u ɡoru bɑbɑ ǹ kun mɛ wìn sen nim mu wĩɑ ǹ kun mɛ wi u yɑɑ ɡɑɑ bɑbɑ ye yɑ disi mɔ ǹ kun mɛ wi u ɡoo bɑbɑ wi u disi mɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","Wi u yen ɡɑɑ bɑbɑ ɡesi, u disi duurɑwɑ mi sere kɑ yokɑɔ. U ǹ kpɛ̃ u yɑ̃ku dĩɑ ni di mɑ n kun mɔ u woburɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Ù n woburɑ, yokɑn di u dɛɛrɑ, u koo kpĩ u nɛn dĩɑ ni di. Domi niyɑ nu sɑ̃ɑ win dĩɑnu. ");
INSERT INTO bba_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Mɛyɑ yɑ̃ku kowo ɡoo kun yɑɑ ɡoru temmɔ ǹ kun mɛ yɑɑ ye ɡbeeku yɑɑ ɡɑɑ yɑ ɡo u ku rɑɑ kɑ tii disi doken sɔ̃. Nɛ, Yinni Gusunɔwɑ nɑ yeni ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","Bɑ koo nɛn woodɑbɑ mɛm nɔɔwɑwɑ domi bɑ̀ n nɛn dĩɑnu disi doke, bɑ koo ben torɑrun ɑre sɔbe kpɑ bu ɡbi. Nɛ, Yinni Gusunɔwɑ nɑ bu ɡɔsɑ bɑ n kɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","Tɔn diro kun yɑ̃ku dĩɑ ni dimɔ bɑɑ yɑ̃ku kowon sɔm kowo ǹ kun mɛ win sɔɔ. Yɛ̃ro kun yɑ̃ku dĩɑ ni dimɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Adɑmɑ yoo wi yɑ̃ku kowo u dwɑ kɑ wi bɑ mɑrɑ win yɛnuɔ, bɑ koo kpĩ bu dĩɑ ni di. ");
INSERT INTO bba_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Yɑ̃ku kowon bii tɔn kurɔ ù n tɔn diro suɑ durɔ, ù ku rɑɑ yɑ̃ku dĩɑ ni di. ");
INSERT INTO bba_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Adɑmɑ bii wi, ù n sɑ̃ɑ ɡɔmini ǹ kun mɛ win durɔ u nùn yinɑ, mɑ u ǹ kɑ durɔ wi mɑrɑ, mɑ u ɡɔsirɑ win tundon yɛnuɔ u sɔ̃ nɡe sɑnɑm mɛ u ǹ durɔ sue, u koo kpĩ u dĩɑ ni di. Mɑ n kun mɛ, tɔn diro u ku dĩɑ ni di. ");
INSERT INTO bba_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","Tɔn tuko ɡoo ù n nu di u ǹ kɑ bɑɑru, u koo nin kɔsire yɑ̃ku kowo wɛ̃wɑ. Yen biru kpɑ u nùn nin bɔnu nɔɔbun tiɑ sosiɑ. ");
INSERT INTO bba_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Yɑ̃ku kowobu bu ku rɑɑ dĩɑ ni disi doke nì Isirelibɑ bɑ kɑ yɑ̃kuru kuɑ Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Bɑ̀ n nu di sɑnɑm mɛ n ǹ weenɛ bu nu di, bɑ Isirelibɑ torɑnu sɔbimɔwɑ. Nɛnɑ Yinni Gusunɔ, nɛ wi nɑ rɑ yɑ̃kunu dɛɛrɑsie. ");
INSERT INTO bba_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","ɑ Aroni kɑ win bibu kɑ Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, ɡoo be sɔɔ ǹ kun mɛ sɔɔ ɡoo wi u wɑ̃ɑ ben suunu sɔɔ, ù n kĩ u yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko kɑ kĩru, ǹ kun mɛ u kɑ nɔɔ mwɛɛru ɡɑru yibiɑ, ");
INSERT INTO bba_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","nɛ, Yinni Gusunɔ n sere tu mwɑ, yɑɑ sɑbe dɔɔ ɡe ɡɑ ǹ ɑlebu mɔ ɡerɑ u koo kɑ nɑ, nɑɑ, ǹ kun mɛ yɑ̃ɑru, ǹ kun mɛ boo, yɑ n ɡesi sɑ̃ɑ dwɑ. ");
INSERT INTO bba_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","U ǹ koo kɑ yɑɑ sɑberu nɑ te tɑ ɑlebu ɡɑɑ mɔ. Domi ù n kɑ tu yɑ̃kuru kuɑ, nɑ ǹ mwɑɑmɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Goo ù n siɑrɑbun yɑ̃kuru mɔ̀ kɑ kĩru ǹ kun mɛ u kɑ nɔɔ mwɛɛru ɡɑru yibiɑ, u koo tu kowɑ kɑ sɑbe te tɑ ǹ ɑlebu ɡɑɑ mɔ n sere win yɑ̃ku te mwɑ. ");
INSERT INTO bba_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Ǹ n mɛn nɑ, bu ku kɑ sɑbe wɔ̃ko nɑ, ǹ kun mɛ te tɑ kɔ̃ri bɔɔre, ǹ kun mɛ te bɑ so bɑ kɔsiki, ǹ kun mɛ te tɑ boo boosu ǹ kun mɛ tɑɑtɑɑru mɔ ɡɔnɑɔ. Bu ku kɑ yen ɡɑɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Bɑ koo kpĩ bu kɑ yɑɑ sɑbe tèn wɑsin bee tiɑ kpɑ̃ɑru bo kɛ̃run yɑ̃kuru ko. Adɑmɑ bu ku kɑ tu nɔɔ mwɛɛruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Bu ku rɑɑ kɑ yɑɑ sɑbe tèn tĩɑrɑ kɔrɑ ǹ kun mɛ bɑ wĩɑ nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ. Bu ku mɑɑ yen bweseru yɑɑ sɑberu ɡɑru kuɑ bɑ̀ n duɑ ben temɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","Bu ku kɑ nɛ, Yinni Gusunɔ sɑbe ten bweseru yɑ̃kuru kuɑ te bɑ wɑ sɔbun mi. Domi sɑbe tèn wɑsi bɑ mɛɛrɑ kuɑ, tɑ sɑ̃ɑwɑ nɡe sɑbe te tɑ ɑlebu mɔ. Nɛ, Yinni Gusunɔ, nɑ ǹ yɑ̃ku ten bweseru mwɑɑmɔ. ");
INSERT INTO bba_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","bɑ̀ n kɛtɛ buu mɑrɑ ǹ kun mɛ yɑ̃ɑru ǹ kun mɛ boo, ɡɑ koo kowɑ sɔ̃ɔ nɔɔbɑ yiru kɑ ɡen mɛro. Adɑmɑ sɑɑ sɔ̃ɔ nɔɔbɑ itɑsen di, bɑ koo kpĩ bu kɑ ɡu yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. ");
INSERT INTO bba_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Bu ku rɑɑ yɑɑ sɑberu ɡɑru ɡo kɑ ten buu sɔ̃ɔ teeru. ");
INSERT INTO bba_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Bɑ̀ n nɛ, Yinni Gusunɔ siɑrɑbun yɑ̃kuru kuɑmmɛ, bu tu koowo nɡe mɛ kon kɑ tu mwɑ. ");
INSERT INTO bba_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Yen dɔmɑ terɑ bɑ koo ten yɑɑ di. Bɑ ǹ yen ɡɑɑ tiɑmɔ sere sisiru. ");
INSERT INTO bba_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","Bɑ koo nɛn woodɑ ye mɛm nɔɔwɑwɑ kpɑ bu ye swĩi. ");
INSERT INTO bba_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Bu ku rɑɑ nɛn yĩsiru sɑnku kpɑ bu wɑ bu mɑn bɛɛrɛ wɛ̃ ben suunu sɔɔ. Nɛnɑ nɑ Yinni Gusunɔ wi u bɛɛ ɡɔsɑ i n kɑ dɛɛre. ");
INSERT INTO bba_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Nɛnɑ nɑ bɛɛ yɑrɑ sɑɑ Eɡibitin di nɑ n kɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","2","Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, tɔ̃ɔ bɑkɑ nì sɔɔ i ko i n dɑ mɛnnɛ i mɑn sɑ̃, ni wee. ");
INSERT INTO bba_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","Alusumɑ tiɑ sɔɔ, sɔ̃ɔ nɔɔbɑ tiɑ i ko i n dɑ sɔmburu ko, sɔ̃ɔ nɔɔbɑ yiruse, i ko i wɛ̃rɑ kpɑ i mɛnnɑ i kɑ mɑn sɑ̃. Yen tɔ̃ɔ te, i ku rɑ sɔmburu ɡɑru ko. I ko i tu diwɑ nɛn sɔ̃ bɑɑ mi i wɑ̃ɑ kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Tɔ̃ɔ bɑkɑ ni nu mɑɑ tie, nì sɔɔ i ko i mɛnnɑ i kɑ mɑn sɑ̃, nin tɔ̃nu wee. ");
INSERT INTO bba_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Yinni Gusunɔ u nɛɛ, wɔ̃ɔn suru ɡbiikoon sɔ̃ɔ wɔkurɑ nnɛsen yokɑn di, i Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru dio nɛ, Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Yen sɔ̃ɔ wɔkurɑ nɔɔbuse sɔɔrɑ i ko i pɛ̃ɛ ye bɑ kun seeyɑtiɑ doken tɔ̃ɔ bɑkɑru tore. I ko i kowɑ sɔ̃ɔ nɔɔbɑ yiru i n pɛ̃ɛ dimɔ ye bɑ kun seeyɑtiɑ doke. ");
INSERT INTO bba_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Alusumɑ yen tɔ̃ɔ ɡbiikiru sɔɔrɑ i ko i mɛnnɑ i mɑn sɑ̃. Yen tɔ̃ɔ te, i ku rɑ sɔmburu ɡɑru ko. ");
INSERT INTO bba_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Alusumɑ yen tɔ̃ɔ bɑɑtere i ko i n dɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuewɑ. Sɔ̃ɔ nɔɔbɑ yiruse, i ko i kpɑm mɛnnɑ i mɑn sɑ̃. Yen tɔ̃ɔ te, i ku sɔmburu ɡɑru ko. ");
INSERT INTO bba_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","10","Yinni Gusunɔ u mɑɑ Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, ì n duɑ tem mɛ kon bɛɛ wɛ̃ sɔɔ, mɑ i dĩɑnu ɡɑ̃, i ko i kɑ dĩɑ ɡbiikii ni i ɡɑ̃ mi yɑ̃ku kowo dɑɑwɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Kpɑ yɑ̃ku kowon tii u mɑn nu tusiɑ tɔ̃ɔ wɛ̃rɑruɡirun sisiru kpɑ n wɑ n kɑ bɛɛ nɔnu ɡeu mɛɛri. ");
INSERT INTO bba_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Yen tɔ̃ɔ te, i ko i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ kɑ yɑ̃ɑru wɔ̃ɔ tiɑɡiru te tɑ ǹ ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","I ko i mɑɑ som kilo nɔɔbɑ tiɑ mɛ i kɑ ɡum burinɑ sɔndi kpɑ ye kpuron nuburu tu nɛ, Yinni Gusunɔ dore. Yen biru kpɑ i tɑm litiri tiɑ kɑ bɔnu tɑ̃re som mɛn wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","I ǹ ko i dĩɑ ɡbiikii nin pɛ̃ɛ di ǹ kun mɛ nin bimɑ ye bɑ sɔnwɑ ǹ kun mɛ ye bɑ kɔsukɑ sere dɔmɑ te i kɑ nɛ, Yinni Gusunɔɡiɑ nɑ. I ko woodɑ yeni mɛm nɔɔwɑwɑ mi i wɑ̃ɑ kpuro sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","Yinni Gusunɔ u mɑɑ Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, i ko i mɑɑ ɑlusumɑ ɡɑriwɑ nɔɔbɑ yiru sɑɑ tɔ̃ɔ wɛ̃rɑruɡirun sisirun di dɔmɑ tèn di i kɑ bɛɛn dĩɑ ɡbiikii ni, nɛ, Yinni Gusunɔ nɑɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","I ko i ɡɑriwɑ sɔ̃ɔ weerɑɑkuru sere n kɑ ko tɔ̃ɔ wɛ̃rɑruɡiru nɔɔbɑ yirusen sisiru. Kpɑ i mɑɑ nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","I ko i kɑ pɛ̃ɛ yiru nɑ sɑɑ bɛɛn yɛnun di yèn bɑɑyere bɑ kuɑ kɑ som kilo itɑ kɑ pɛ̃ɛ seeyɑtiɑ. Bɛɛn ɡberun dĩɑ ɡbiikii niyɑ i ko i kɑ yen som mɛ ko, kpɑ yɑ̃ku kowo u ye sɔ̃ɔsi beri berikɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Yen biru, i ko i nɛ, Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ kɑ yɑ̃ɑnu nɔɔbɑ yiru ni nu wɔ̃ɔ tiɑ tiɑ mɔ kpɑ nu kun ɑlebu ɡɑɑ mɔ kɑ mɑɑ kɛtɛ kinɛ kpɛm teeru kɑ yɑ̃ɑ kinɛnu yiru kɑ sere tɑm. Kpɑ ye kpuron nuburu tu nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","I ko i mɑɑ boo ɡo bɛɛn torɑnun yɑ̃kurun sɔ̃ kɑ mɑɑ yɑ̃ɑnu yiru ni nu wɔ̃ɔ tiɑ tiɑ mɔ siɑrɑbun yɑ̃kurun sɔ̃ ");
INSERT INTO bba_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","kɑ pɛ̃ɛ ye sɑnnu. Yɑ̃ku kowo u koo kɑ ye kpuro Yinni Gusunɔ dɑɑwɑwɑ u nu tusiɑrun wororu koosi. Kpɑ ye kpuro yɑ n sɑ̃ɑ nɛ, Yinni Gusunɔɡiɑ. Ye kpuron biru, yɑɑ ye kpuro yɑ koo kowɑ yɑ̃ku kowoɡiɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Yen tɔ̃ɔ te, i ko mɛnnɑwɑ bɛɛ kpuro i mɑn sɑ̃. I ǹ mɑɑ sɔmburu mɔ̀ dɔmɑ te. Mi i wɑ̃ɑ kpuro, i ko i woodɑ yeni mɛm nɔɔwɑwɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","Ì n bɛɛn ɡberun dĩɑnu ɡɛ̃ɛmɔ, i ku ni nu wɑ̃ɑ bɛɛn ɡbee ɡoorɔ ɡɛ̃. Yen biru i ku mɑɑ nu kunɔnu ko. I ko i nu sɑ̃ɑrobu kɑ sɔbu deriɑwɑ. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","24","Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, wɔ̃ɔn suru nɔɔbɑ yirusen tɔ̃ɔ ɡbiikiru sɔɔ, i ko i wɛ̃rɑwɑ kpɑ i kɔbi so Gusunɔ u kɑ bɛɛ yɑɑyɑ. Tɔ̃ɔ te, i ko i mɛnnɑwɑ kpɑ i mɑn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","I ku rɑ sɔmburu ɡɑru ko. Kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","wɔ̃ɔn suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurusewɑ i ko i yɑ̃kuru ko bɛɛn torɑnun suurun sɔ̃. I ko i mɛnnɑwɑ kpɑ i nɔɔ bɔke kpɑ i mɑn sɑ̃. Kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","I ku rɑ sɔmburu ɡɑru ko tɔ̃ɔ te sɔɔ. Domi tɔ̃ɔ te sɔɔrɑ bɑ koo bɛɛ torɑnun suuru kobun woronu koosi Gusunɔ bɛɛn Yinnin wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Wi u kun nɔɔ bɔkue yen tɔ̃ɔ te, bɑ koo nùn wunɑwɑ win tɔmbun suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Wi u mɑɑ sɔmburu kuɑ tɔ̃ɔ te sɔɔ, kon de bu yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","I ku rɑ sɔmburu ɡɑru ko tɔ̃ɔ te. Yɑ ko n sɑ̃ɑwɑ woodɑ kɑ bɑɑdommɑɔ kɑ bɛɛn bibun bweserɔ. Mi i wɑ̃ɑ kpuro, i ko ye mɛm nɔɔwɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Yɑ ko n sɑ̃ɑwɑ nɡe tɔ̃ɔ wɛ̃rɑruɡiru kpɑ i nɔɔ bɔke. I ko i wɛ̃rɑwɑ sɑɑ surun sɔ̃ɔ nɔɔbɑ nnɛn yokɑn di sere kɑ yen sisirun yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","34","Yinni Gusunɔ u Isirelibɑ sɔ̃ɔwɑ sɑɑ Mɔwisin nɔɔn di u nɛɛ, sɑɑ wɔ̃ɔn suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurɑ nɔɔbun di, i ko i Kunun tɔ̃ɔ bɑkɑru diwɑ sɔ̃ɔ nɔɔbɑ yiru i kɑ nɛ, Yinni Gusunɔ sɑ̃. ");
INSERT INTO bba_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Yen tɔ̃ɔ ɡbiikiru, i ko i mɛnnɑ i mɑn sɑ̃. I ku rɑ sɔmburu ɡɑru ko tɔ̃ɔ te. ");
INSERT INTO bba_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Tɔ̃ɔ bɑɑtere i ko i n dɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuewɑ sere n kɑ ko sɔ̃ɔ nɔɔbɑ yiru ye. Yen sɔ̃ɔ nɔɔbɑ itɑse, i ko i kpɑm mɛnnɑwɑ i mɑn sɑ̃ kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ. Tɔ̃ɔ te, i ku rɑ sɔmburu ɡɑru ko. Tɑ sɑ̃ɑwɑ ɡɑ̃ɑ ɡirinu. ");
INSERT INTO bba_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","Yenibɑ kpuro yɑ sɑ̃ɑwɑ tɔ̃ɔ bɑkɑ ni i ko i di nɛ Yinni Gusunɔn sɔ̃. Kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ kɑ bɛɛn ɡberun dĩɑnu kɑ siɑrɑbun yɑ̃kunu kɑ tɑm. Yɑ̃kuru bɑɑtere kɑ ten tɔ̃ru. ");
INSERT INTO bba_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Mɛyɑ i ku mɑɑ tɔ̃ɔ wɛ̃rɑruɡiru duɑri kɑ yɑ̃ku ni i rɑ mɑn kue kɑ sere mɑɑ kɛ̃ɛ ni i rɑ kɑ nɛ kɑ mɑɑ nɔɔ mwɛɛrun yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurɑ nɔɔbuse sɔɔ, ì n bɛɛn ɡberun dĩɑnu ɡɑ̃, i ko i tɔ̃ɔ bɑkɑru diwɑ sɔ̃ɔ nɔɔbɑ yiru i kɑ mɑn bɛɛrɛ wɛ̃. Yen tɔ̃ɔ ɡbiikiru kɑ yen tɔ̃ru nɔɔbɑ itɑse, i ko i wɛ̃rɑwɑ i ku sɔmburu ɡɑru ko. ");
INSERT INTO bba_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Yen tɔ̃ɔ ɡbiikii te, i ko i dɑ̃ɑ mɑrum burɑm suɑ kɑ kpɑkpɑ wurusu kɑ dɑ̃ɑ wuru bɑkɑsu si su rɑ n wɑ̃ɑ dɑɑrɔ kpɑ i n nuku dobu mɔ̀ nɛn wuswɑɑɔ sɔ̃ɔ nɔɔbɑ yiru ye. ");
INSERT INTO bba_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Wɔ̃ɔ bɑɑɡere i ko i n dɑ tɔ̃ɔ bɑkɑ te diwɑ i kɑ mɑn bɛɛrɛ wɛ̃ suru nɔɔbɑ yiruse ye sɔɔ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Bɛɛ Isirelibɑ kpurowɑ i ko i n wɑ̃ɑ kunu sɔɔ sere sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Kpɑ bɛɛn bibun bweseru tu kɑ ɡiɑ mɑ nɑ ben sikɑdobɑ sinɑsiɑ kunu sɔɔ sɑnɑm mɛ nɑ bu yɑrɑmɑ Eɡibitin di. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Nɡe mɛyɑ Mɔwisi u Isirelibɑ tɔ̃ɔ bɑkɑ ni sɔ̃ɔwɑ ni bɑ ko n dɑ di bu kɑ Yinni Gusunɔ bɛɛrɛ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bu nùn olifin ɡum kɑsuo mɛ mu ɡeɑ bo kpɑ fitilɑnu nu n kɑ sɔ̃re yokɑ bɑɑyere. ");
INSERT INTO bba_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aroni u koo kɑ ɡum mɛ dɑwɑ nɛ, Yinni Gusunɔn kuu bekuruɡii ten mi, beku kɑre ten wuswɑɑɔ te tɑ woodɑn kpɑkoro te ɡɑnuɑ. Kpɑ u de fitilɑ ni, nu n sɔ̃re yokɑn di sere yɑm mu kɑ sɑ̃rɑ. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ ben bibun bweserɔ. ");
INSERT INTO bba_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aroni u koo fitilɑ ni sɔndiwɑ dɑbu wurɑɡuun wɔllɔ kpɑ nu n sɔ̃re wɔ̃kuru bɑɑtere sere yɑm mu kɑ sɑ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ pɛ̃ɛ wɔkurɑ yiru wɔ̃ɔwɔ yen bɑɑyere yɑ n sɑ̃ɑ kilo nɔɔbɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Kɑɑ ye yorewɑ nɛn wuswɑɑɔ tɑbulu wurɑɡiɑ yen wɔllɔ sĩɑ yiru, yen bɑɑyere sɔɔ pɛ̃ɛ nɔɔbɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Sĩɑ bɑɑyeren wɔllɔ kɑɑ turɑre ɡeɑ sɔndi kpɑ bu ye dɔ̃ɔ mɛni nɛn sɔ̃ pɛ̃ɛ yen ɑyerɔ kpɑ n bɛɛ yɑɑyɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Tɔ̃ɔ wɛ̃rɑruɡiru bɑɑtere, bɑ ko n dɑ mɑn pɛ̃ɛ yen bweseru yiiyewɑ kpɑ yɑ n yii mi bɑɑdommɑ. Yɑ ko n sɑ̃ɑwɑ woodɑ bɛɛn bibun bweseru sɔɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Pɛ̃ɛ ye bɑ kɔsire kuɑ mi, yɑ ko n sɑ̃ɑwɑ Aroni kɑ win bibuɡiɑ. Bɑ koo ye diwɑ yɑm dɛɛrɑmɔ. Pɛ̃ɛ ye, yɑ sɑ̃ɑwɑ nɛnɛm domi nɛnɑ bɑ ye wɛ̃ sɑnɑm mɛ bɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀. Aronin bweserɑ tɑ ko n dɑ ye di sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","11","Sɔ̃ɔ teeru Isirelibɑn ɡoo kɑ Eɡibitiɡii ɡoon bii wì u kɑ Isireli tɔn kurɔ mɑrɑ bɑ sɑnnɑ. Kurɔ Isireli win yĩsirɑ Selomiti, Debirin bii, Dɑnun bweseru sɔɔ. Selomitin bii wi, u Gusunɔn yĩsiru ɡɑri kɑm ɡerusimɔ u bɔ̃rusimɔ. Yerɑ yɑnde bɑ kɑ nùn dɑ Mɔwisin mi. ");
INSERT INTO bba_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Mɑ bɑ nùn yii bɑ kɑ mɑrɑ bu wɑ ye Yinni Gusunɔ u koo ɡere. ");
INSERT INTO bba_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","i kɑ durɔ wi yɑrio sɑnsɑnin di. Be bɑ mɑɑ nuɑ u nɛ Yinni Gusunɔ ɡɑri kɑm ɡerusi mi, kpɑ bu ben nɔmɑ sɔndi win wirɔ bu kɑ seedɑ di kpɑ Isirelibɑ kpuro bu nùn kpenu kɑsuku bu ɡo. ");
INSERT INTO bba_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Yen biru woodɑ yeniwɑ kɑɑ Isirelibɑ wɛ̃ ɑ nɛɛ, wi u nɛ, Yinni Gusunɔ ɡɑri kɑm ɡerusi, yɛ̃ro u koo yen ɑre wɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Wi u ɡesi nɛ, Yinni Gusunɔ ɡɑri kɑm ɡerusi, bɑ koo yɛ̃ro ɡowɑ. Isirelibɑ kpurowɑ bɑ koo nùn kpenu kɑsuku bu ɡo. Bɑɑ ù n sɑ̃ɑn nɑ sɔɔ, bɑ koo nùn ɡowɑ yèn sɔ̃ u nɛ, Yinni Gusunɔ ɡɑri kɑm ɡerusi. ");
INSERT INTO bba_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","Goo ù n win winsim ɡo, bɑ koo mɑɑ yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Goo ù n win winsim yɑɑ sɑberu ɡo, u koo ten kɔsire wɛ̃wɑ wɑsiru. Hundewɑ yɑ hunden kɔsire. ");
INSERT INTO bba_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Goo ù n mɑɑ win winsim mɛɛrɑ kuɑ, mɛɛrɑ yen bweserɑ bɑ koo yɛ̃ro ko. ");
INSERT INTO bba_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Wi u ɡoo buɑ, bɑ koo mɑɑ yɛ̃ro buɑwɑ. Wi u ɡoon nɔni wĩɑ, bɑ koo mɑɑ yɛ̃ron nɔni wĩɑwɑ. Wi u ɡoon dondu buɑ, bɑ koo mɑɑ yɛ̃roɡiru buɑwɑ. Kɔ̃sɑ ye tɔnu u win tɔnusi kuɑ kpuro, yerɑ bɑ koo mɑɑ nùn kɔsie. ");
INSERT INTO bba_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Wi u yɑɑ sɑberu ɡo, u koo ten kɔsire wɛ̃wɑ. Wi u mɑɑ tɔnu ɡo, bɑ koo mɑɑ yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Woodɑ tiɑ yerɑ bɑ koo kɑ bɛɛ kɑ bɛɛn sɔbu siri. Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Mɑ Mɔwisi u Isirelibɑ kpuro ye sɔ̃ɔwɑ. Mɑ bɑ durɔ wi u Yinni Gusunɔ ɡɑri kɑm ɡerusi mi yɑrɑ sɑnsɑnin di bɑ nùn kpenu kɑsukɑ bɑ ɡo. Nɡe mɛyɑ bɑ kɑ kuɑ ye Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","2","Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ ɡuu te bɑ mɔ̀ Sinɑin wɔllɔ u nɛɛ, bɛɛ Isirelibɑ ì n duɑ tem mɛ sɔɔ, mɛ kon bɛɛ wɛ̃ mi, i ko i dewɑ bɛɛn ɡbeɑn tem mu wɛ̃rɑ nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Wɔ̃ɔ nɔɔbɑ tiɑ sɔɔrɑ i ko i bɛɛn ɡbeɑ duure kpɑ i bɛɛn resɛm ɡbɑɑnu sɔmɛ i nin dɑ̃nu kɔni. Kpɑ i yen mɑrum sɔri. ");
INSERT INTO bba_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Adɑmɑ wɔ̃ɔ nɔɔbɑ yiruse, yɑ ko n sɑ̃ɑwɑ wɔ̃ɔ wɛ̃rɑruɡuu Yinni Gusunɔn sɔ̃. Bɛɛn ɡbenu nu koo wɛ̃rɑwɑ mɑm mɑm. I ku rɑ nu dĩɑnu duure, i ǹ ko i mɑɑ bɛɛn resɛm kɔni. ");
INSERT INTO bba_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Bɑɑ dĩɑ ni nu wɔrumɑ sɑnɑm mɛ i ɡɛ̃ɛmɔ mɑ nu kpiɑ kɑ tii, i ǹ nu ɡɛ̃ɛmɔ. I ǹ mɑɑ resɛm sɔrimɔ ye yɑ kɑ tii mɑrɑ. Domi bɛɛn ɡbeɑ yɑ koo wɛ̃rɑwɑ mɑm mɑm wɔ̃ɔ ɡe sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Adɑmɑ wɔ̃ɔ wɛ̃rɑruɡuu ɡe sɔɔ, ye yɑ kpiɑ kɑ tii, yerɑ i ko i di bɛɛ kɑ bɛɛn sɔm kowobu kɑ bɛɛn yobu kɑ sere mɑɑ sɔɔ be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ ");
INSERT INTO bba_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","kɑ bɛɛn yɑɑ sɑbenu kɑ ɡbeeku yɛɛ. Ye tem mɛ, mu koo kpi yerɑ i ko i di. ");
INSERT INTO bba_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","I ko i wɔ̃ɔ nɔɔbɑ yirun subɑ nɔɔbɑ yiru deriwɑ yu doonɑ. Ye kpuro yɑ sɑ̃ɑwɑ mi, wɔ̃ɔ weerɑɑkuru tiɑ sɑri. ");
INSERT INTO bba_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Yen wɔ̃ɔ dɑ̃ɑkun suru nɔɔbɑ yirusen sɔ̃ɔ wɔkuru, tɔ̃ɔ te bɑ torɑrun yɑ̃kuru kuɑ mi, i ko i kɔbi wurɑwɑ kɑ kuuki tem mɛ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Wɔ̃ɔ weerɑɑkurusen wɔ̃ɔ ɡe, ɡɑ ko n sɑ̃ɑwɑ nɛnɛm nɛ, Yinni Gusunɔn sɔ̃. Kpɑ i kpɑrɑ mɑ bɑɑwure u tii mɔ. Wɔ̃ɔ ɡe sɔɔ, bɑ koo ɡbee te ɡoo u rɑɑ dɔrɑ ǹ kun mɛ te bɑ nùn mwɑɑri wesiɑwɑ tu ko wiɡiru. Wi u rɑɑ mɑɑ yoru dimɔ, u koo yɑkiɑrɑ u wurɑ win yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Nɡe mɛyɑ i ko n dɑ wɔ̃ɔ weerɑɑkuru bɑɑteren yɑkiɑbun tɔ̃ɔ bɑkɑru di. I ko i wɛ̃rɑwɑ wɔ̃ɔ ɡe sɔɔ. I ǹ dĩɑnu ɡɑnu duurumɔ. I ǹ mɑɑ dĩɑnu ɡɑnu ɡɛ̃ɛmɔ ni nu kɑ tii kpiɑ. Mɛyɑ i ǹ mɑɑ resɛm sɔrimɔ ye yɑ mɑrɑ resɛm ɡbɑɑrɔ te bɑ ǹ sɔnwɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Domi nuku dobun wɔ̃ɔwɑ ɡe i ko i wunɑ nɛnɛm nɛ Yinni Gusunɔn sɔ̃. Adɑmɑ bɛɛn ɡbeɑn dĩɑnɑ i ko i di. ");
INSERT INTO bba_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","Wɔ̃ɔ ɡe sɔɔ, bɑɑwure u koo win tem mwɑwɑ mɛ bɑ rɑɑ nùn mwɑɑri. ");
INSERT INTO bba_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Ì n tem dɔrɑmɔ, ǹ kun mɛ ì n dwemɔ, bɛɛn ɡoo u ku rɑɑ win winsim nɔni wɔ̃ke. ");
INSERT INTO bba_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Wi u kĩ u win ɡberu dɔrɑ, u koo ɡinɑ lɑsɑbu kowɑ u wɑ mɛ̀n nɔɔ tɑ koo dĩɑnu mɑ sere wɔ̃ɔ weerɑɑku te, tu kɑ yibu tè sɔɔ bɑ rɑ yɑkiɑbun tɔ̃ɔ bɑkɑru ko tè sɔɔ yɛ̃ro u koo tu wesiɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Nɡe mɛ wɔ̃su su dɑbiru nɛ, nɡe mɛyɑ ɡbee ten ɡobi yi ko n kpɑ̃ɑru nɛ. Wɔ̃sun sukum mɛ mu tie mù kun dɑbi sere wɔ̃ɔ weerɑɑku te, tu kɑ yibu, ten ɡobi yi ǹ ko yi n kpɑ̃. Domi ye bɑ koo ɡɛ̃ ɡbee te sɔɔ, yerɑ u dɔrɑmɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Bɛɛn ɡoo u ku rɑɑ win winsim nɔni wɔ̃ke. I ko i mɑn nɑsiɑwɑ domi nɛnɑ nɑ sɑ̃ɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","I nɛn woodɑbɑ mɛm nɔɔwɔ kpɑ i sĩ ye sɔɔ. Sɑɑ ye sɔɔrɑ i ko i sinɑ tem mɛ sɔɔ kɑ bɔri yɛndu. ");
INSERT INTO bba_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Tem mɛ, mu koo dĩɑnu ko ni nu koo bɛɛ turi kpɑ i n kɑ wɑ̃ɑ bɔri yɛndu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Sɔrɔkudo i ko i tii bikiɑ i nɛɛ, mbɑ i ko i di wɔ̃ɔ nɔɔbɑ yiruse te. Domi i ǹ wɔ̃ɔ ɡe sɔɔ dĩɑnu duurumɔ, i ǹ mɑɑ ɡɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Kon bɛɛ domɑru kuɑ wɔ̃ɔ nɔɔbɑ tiɑse kpɑ bɛɛn ɡbeɑ yu wɔ̃ɔ itɑn dĩɑnu mɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Wɔ̃ɔ nɔɔbɑ itɑse sɔɔ, i ko i dĩɑnu duure kpɑ bɛɛn dĩɑ ɡurunu nu n tie sere i kɑ wɔ̃ɔ nɔɔbɑ nnɛsen dĩɑnu ɡɛ̃. ");
INSERT INTO bba_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","Goo kun tɔnu tem dɔremɔ kpɑ yɛ̃ro u n mu mɔ sere kɑ bɑɑdommɑɔ, domi nɛ, Yinni Gusunɔwɑ nɑ tem mɔ, i mɑɑ wɑ̃ɑwɑ nɛn mi nɡe sɔbu. ");
INSERT INTO bba_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Yen sɔ̃nɑ mi i sinɑ kpuro, i ko i tem yɑkiɑbun woodɑ ye mɛm nɔɔwɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Bɛɛ sɔɔ, ɡoo ù n kuɑ sɑ̃ɑro, mɑ u win tem sukum dɔrɑ, win dusi ɡoo ù n ɡobi mɔ, u koo kpĩ u mu yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Yɛ̃ro ù kun mɑɑ dusi ɡoo mɔ wi u koo mu yɑkiɑ, win tii u koo kookɑri kowɑ u kɑ mu yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","U koo wɔ̃su ɡɑriwɑ si su tie wɔ̃ɔ weerɑɑku te, tu kɑ sere yibu kpɑ u si kpuron ɡobi kɔsiɑ kpɑ tem mɛ, mu ko wiɡim. ");
INSERT INTO bba_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Ù kun ɡobi wɑ u kɑ mu yɑkiɑ, u koo mu wi u tem mɛ dwɑ deriɑ sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi. Yen biru u koo kpĩ u wurɑ tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","Yinni Gusunɔ u nɛɛ, ɡoo ù n win diru dɔrɑ te tɑ wɑ̃ɑ wuu ɡbɑ̃rɑruɡuu sɔɔ, wɔ̃ɔ tiɑ u mɔ u kɑ tu yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Yɛ̃ro ù n kpɑnɑ u dii te yɑkiɑ wɔ̃ɔ tiɑ yen bɑɑ sɔɔ, tɑ koo kowɑ wi u tu dwɑɡiru sere kɑ bɑɑdommɑɔ. U ǹ mɑɑ tu wesiɑmɔ bɑɑ yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Adɑmɑ dii te tɑ wɑ̃ɑ wuu ɡe ɡɑ ǹ ɡbɑ̃rɑru mɔ sɔɔ, bɑ koo tu yɑkiɑwɑ nɡe mɛ bɑ rɑ tem yɑkie. Bɑɑ ǹ n mɛren nɑ, wi u rɑɑ dii te mɔ, bɑ koo nùn tu wesiɑwɑ yɑkiɑbun tɔ̃ɔ bɑkɑru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Adɑmɑ Lefibɑn wusu kɑ ben diɑ, bɑ ko n dɑ kpĩ bu ye yɑkie sɑɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Wi u Lefibɑn ɡoon diru dwɑ, yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ, u koo yɑriwɑ dii ten min di kɑ wuu ɡen min di. Lefibɑn diɑ yɑ sɑ̃ɑwɑ ben tiiɡinu Isirelibɑɡinun suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Gbee ni nu mɑɑ kɑ ben wusu sikerenɛ, ben ɡoo kun kpɛ̃ u nu dɔrɑ. Domi berɑ bɑ nu mɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","Yinni Gusunɔ u nɛɛ, wunɛn Isirelisi ù n sɑ̃ɑru duurɑ, mɑ u ǹ kpɛ̃ u tii nɔɔri, ɑ de ɑ nùn somi u kɑ win wɑ̃ɑru di. Nɡe mɛyɑ kɑɑ mɑɑ sɔɔ kuɑ kpɑ u wɑ u sinɑ tem mɛ sɔɔ wunɛn bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","À n nùn ɡɑ̃ɑnu bɔkurɑ, ɑ ku nùn ɑre kɑsusi. A de ɑ nɛ Gusunɔ wunɛn Yinni nɑsiɑ, kpɑ wunɛn winsim u wɑ u n wɑ̃ɑ wunɛn bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","À n nùn ɡobi bɔkurɑ ǹ kun mɛ dĩɑnu, ɑ ku nim doke. ");
INSERT INTO bba_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Nɛ Gusunɔ bɛɛn Yinniwɑ nɑ ye ɡeruɑ. Nɛnɑ nɑ bɛɛ yɑrɑ sɑɑ Eɡibitin di n kɑ bɛɛ Kɑnɑnin tem wɛ̃ kpɑ nɑ n sɑ̃ɑ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","Yinni Gusunɔ u mɑɑ nɛɛ, wunɛn Isirelisi ù n sɑ̃ɑru duurɑ mɑ u nun tii dɔre, ɑ ku nùn yoo sɔmɑ koosiɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","U ko n sɑ̃ɑwɑ wunɛn sɔm kowo, u n wɑ̃ɑ wunɛn yɛnuɔ sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Yɑkiɑbun tɔ̃ɔ bɑkɑ te, tɑ̀ n tunumɑ, kɑɑ nùn yɑkiɑwɑ wi kɑ win bibu kpɑ u wurɑ u win yɛnuɡibu deemɑ, u win sikɑdobɑn ɡbeɑ tubi di. ");
INSERT INTO bba_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Domi bɑ sɑ̃ɑwɑ nɛn yobu be nɑ yɑrɑmɑ Eɡibitin di. Bɑ ǹ koo bu dɔrɑ nɡe mɛ bɑ rɑ yobu dɔre. ");
INSERT INTO bba_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","A ku nùn dɑm dɔre. A sɔ̃ɔsio mɑ ɑ nɛ Gusunɔ wunɛn Yinni nɑsie. ");
INSERT INTO bba_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","À n yobu kĩ, bwese tuku ni nu kɑ nun sikerenɛwɑ kɑɑ yoru mwɛɛri bɑ n sɑ̃ɑ wunɛɡibu. ");
INSERT INTO bba_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Kɑɑ kpĩ ɑ sɔbun bibu dwe be bɑ wɑ̃ɑ wunɛn yɛnuɔ kɑ sere be bɑ mɑrɑ bɛɛn tem sɔɔ. À n bu dwɑ, bɑ ko n sɑ̃ɑwɑ wunɛɡibu. ");
INSERT INTO bba_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Wunɛn bibun bweseru tɑ koo kpĩ tu bu tubi di sere kɑ bɑɑdommɑɔ. Adɑmɑ ɡoo u ku rɑɑ win Isirelisi dɑm dɔre. ");
INSERT INTO bba_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","Sɔɔ ɡoo ù n wɑ̃ɑ wunɛn yɛnuɔ, mɑ u kuɑ ɡobiɡii, mɑ Isireli ɡoo u sɑ̃ɑru duurɑ, mɑ u tii sɔɔ wi dɔre, ǹ kun mɛ sɔɔ win dusi ɡoo, ");
INSERT INTO bba_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","Isireli wi, u koo kpĩ u tii yɑkiɑ ǹ kun mɛ win dusi ɡoo u nùn yɑkiɑ ");
INSERT INTO bba_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ǹ kun mɛ win bɑɑn mɔɔ ǹ kun mɛ win bɑɑn wɔnɔ ǹ kun mɛ ben bii ɡoo ǹ kun mɛ win dusi ɡoo ɡesi. Wi u mɑɑ tii dɔrɑ mi, ù n dɑm wɑ u kɑ tii yɑkiɑ, u koo kpĩ u tii yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Bɑ koo wɔ̃sun ɡeeru ɡɑriwɑ wi kɑ wi u nùn dwɑ sɑɑ mìn di u tii dɔrɑ sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi. Win yɑkiɑbun ɡobin ɡeeru tɑ ko n sɑ̃ɑwɑ nɡe ɡobi yi bɑ koo sɔm kowo kɔsiɑ wɔ̃ɔ si sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Wɔ̃su sù n mɑɑ tie su kpɑ̃ yɑkiɑbun tɔ̃ɔ bɑkɑru tu sere turi, u koo win yɑkiɑbun ɡobi kɔsiɑwɑ nɡe mɛ wɔ̃ɔ sin ɡeerɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Wɔ̃su sù kun mɑɑ dɑbi sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi, u koo win yɑkiɑbun ɡobi kɔsiɑwɑ nɡe mɛ wɔ̃ɔ sin ɡeerɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Ù n wɑ̃ɑ win yinnin mi, yinni wi, u koo nùn kowɑ nɡe mɛ bɑ rɑ sɔm kowo kue. U ǹ koo nùn dɑm dɔre. ");
INSERT INTO bba_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Ù kun kpĩɑ u tii yɑkie kɑ swɑɑ yen ɡɑɑ, u koo yɑkiɑrɑ wi kɑ win bibu yɑkiɑbun tɔ̃ɔ bɑkɑru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isirelibɑ bɑ sɑ̃ɑwɑ nɛ, Yinni Gusunɔn yobu be nɑ yɑrɑ Eɡibitin di. Nɛ Gusunɔ nɑ sɑ̃ɑwɑ ben Yinni. ");
INSERT INTO bba_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Nɑ nɛɛ, i ku bwɑ̃ɑroku ɡɑɡu sɑ̃. I ku rɑ mɑɑ ɡɑ̃ɑnu ɡɑnun weenɑsinu ko. I ku mɑɑ kperu ɡɑru ɡirɑ te bɑ ɡɑ̃ɑnu ɡɑnun weenɑsinu koosi kpɑ i yiirɑ i sɑ̃. Domi nɛnɑ nɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","I tɔ̃ɔ wɛ̃rɑruɡiru yɑɑyo kpɑ i nɛn kuu bekuruɡiru bɛɛrɛ wɛ̃. Nɛ, Yinni Gusunɔwɑ nɑ ye ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","Ì n nɛn woodɑbɑ mɛm nɔɔwɑ mɑ i ye swĩi, ");
INSERT INTO bba_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","kon de ɡurɑ yu nɛ yen sɑɑ sɔɔ kpɑ tem mu dĩɑnu wɛ̃ kpɑ dɑ̃nu nu binu mɑ. ");
INSERT INTO bba_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","I ko n dĩɑnu ɡɛ̃ɛmɔwɑ sere bɛɛn resɛm yu kɑ sɔribu turi. Kpɑ resɛm ye, yɑ n mɑɑ wɑ̃ɑ duurubun sɑɑ. I ko i di i debu kpɑ i n wɑ̃ɑ kɑ bɔri yɛndu bɛɛn tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","Kon de ɑlɑfiɑ yɑ n wɑ̃ɑ tem mɛ sɔɔ. Goo kun bɛɛ bɑɑsimɔ ì n dò. Kon de yɛɛ ɡɔbi yi doonɑ. Mɛyɑ tɑbu kun mɑɑ duɔ tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","I ko i bɛɛn yibɛrɛbɑ nɑɑ ɡirɑwɑ kpɑ i bu tɑkobi sɔkiri i kɑmiɑ. ");
INSERT INTO bba_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Bɛɛn nɔɔbu bɑ koo kpĩ bu tɔmbu wunɔbu (100) nɑɑ swĩi bu ɡo. Kpɑ bɛɛn wunɔbu bu tɔmbu nɔrɔbun subɑ wɔkuru (10.000) nɑɑ swĩi bu ɡo kɑ tɑkobi. ");
INSERT INTO bba_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Kon kɑ bɛɛ nɔnu ɡeu mɛɛri kpɑ n de i mɑrurɑ i kɔwɑrɑ kpɑ n de nɛn ɑrukɑwɑni yɑ n wɑ̃ɑ sere kɑ bɛɛn bibun bibɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","I ko i bɛɛn dĩɑ ɡurunu di sere nu tiɑrɑ kpɑ i kpɑɑnu kɔsire ko bɛɛn birɑnɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Kon de bu nɛn wɑ̃ɑ yeru ɡirɑ bɛɛn suunu sɔɔ. Nɑ ǹ mɑɑ bɛɛ biru kisimɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Nɑ kon sĩimɔwɑ bɛɛn suunu sɔɔ kpɑ nɑ n sɑ̃ɑ bɛɛn Yinni kpɑ i n mɑɑ sɑ̃ɑ nɛn tɔmbu. ");
INSERT INTO bba_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Nɛnɑ Gusunɔ bɛɛn Yinni, nɛ wi nɑ bɛɛ yɑrɑ sɑɑ yorun di Eɡibitiɔ. Nɛnɑ nɑ Eɡibitiɡibun dɑm dɔrebu kpeerɑsiɑ. Tɛ̃ i ko i kpĩ i sĩ n kun kɑ sekuru. ");
INSERT INTO bba_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","Yinni Gusunɔ u nɛɛ, ì kun nɛn woodɑbɑ mɛm nɔɔwɛ, mɑ i ǹ sĩimɔ ye sɔɔ, ");
INSERT INTO bba_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","mɑ i nɛn ɑrukɑwɑni yinɑ, i nɛn woodɑbɑ biru kisi, i ǹ kɑ bu sɔmburu kue, ");
INSERT INTO bba_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","wee ye kon bɛɛ kuɑ. Kon bɛɛ bɛrum tiɑ kpɑ n de wɑsi sun bɑkɑru tu bɛɛ wɔri i woorɑ sere bɛɛn nɔni yi tondɑ kpɑ i n wɑhɑlɑ mɔ̀. Kɑm sɔɔrɑ i ko i bɛɛn dĩɑnu duure. Domi bɛɛn yibɛrɛbɑrɑ bɑ koo nu di. ");
INSERT INTO bba_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Kon bɛɛ biru kisi kpɑ bɛɛn yibɛrɛbɑ bu bɛɛ kɑmiɑ. Kpɑ be bɑ bɛɛ tusɑ bu bɛɛ dɑm dɔre. I ko i duki yɑkikirɑwɑ bɑɑ bɑ̀ kun bɛɛ nɑɑ ɡire. ");
INSERT INTO bba_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","Yenibɑ kpuron biru, ì kun mɑn mɛm nɔɔwɛ, kon bɛɛ sɛɛyɑsiɑ too too bɛɛn torɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Kon bɛɛn dɑm buɑ mɛ̀n sɔ̃ i tii sue. Kon de wɔllu tu bɔbiɑ nɡe sisu kpɑ ɡurɑ yu ku nɛ. Kpɑ tem mu bɔbiɑ nɡe sii ɡɑndu. ");
INSERT INTO bba_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","I ko i bɛɛn dɑm dɔrɑwɑ kɑm sɔɔ. Domi tem mu ǹ dĩɑnu mɔ̀. Mɛyɑ dɑ̃nu nu ǹ mɑɑ mɑrumɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","Ì n mɑn seesimɔ, kon bɛɛ sɛɛyɑsiɑ too too bɛɛn torɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Kon bɛɛ ɡbeeku yɛɛ suremɑ yi bɛɛn bibu ɡo sere kɑ bɛɛn yɑɑ sɑbenɔ kpɑ i kun mɑɑ dɑbi kpɑ bɛɛn swɛɛ yi ɡbi. ");
INSERT INTO bba_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","Sɛɛyɑsiɑ bini bù kun mɑɑ dere i ɡɔ̃ru ɡɔsie, mɑ i mɑn seesimɔ, ");
INSERT INTO bba_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","nɛn tii kon bɛɛ seesi kpɑ n mɑɑ bɛɛ sɛɛyɑsiɑ too too n kere yellu bɛɛn torɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kon de tɑbu bu bɛɛ wɔri yèn sɔ̃ i nɛn ɑrukɑwɑni kusiɑ. Ì n mɛnnɑ i kukuɑ bɛɛn wusɔ, kon de bɑrɑru tu bɛɛ wɔri kpɑ yibɛrɛbɑ bu bɛɛ nɔmɑ turi. ");
INSERT INTO bba_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Kon de ɡɔ̃ɔru tu nɑ. Sɑɑ ye sɔɔ, tɔn kurɔbu wɔkuru bɑ koo pɛ̃ɛ wɔ̃wɑ doo teu sɔɔ kpɑ bu kɑ bɛɛ nɑɑwɑ ye yɑ ǹ bɛɛ debumɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","Yenibɑn biru ì kun mɑn mɛm nɔɔwɛ, mɑ i mɑn seesimɔ, ");
INSERT INTO bba_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","nɛn tii kon bɛɛ seesi kɑ mɔru kpɑ n bɛɛ sɛɛyɑsiɑ nɔn nɔɔbɑ yiru n kere yellu bɛɛn torɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","I ko i ɡɔ̃ɔru wɑ sere i bɛɛn bibu tem. ");
INSERT INTO bba_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Kon bɛɛ tusi sere n bɛɛ ɡunɡuu nìn mi i rɑ yɑ̃kuru ko kɔsuku kɑ bwɑ̃ɑrokunu ni i rɑ kɑ sɔ̃ɔ sɑ̃. Kon bɛɛn ɡonu sɔndi bwɑ̃ɑroku nin kɛ̃kin wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Kon bɛɛn wusu ɡɔsiɑ bɑnsu kpɑ n bɛɛn sɑ̃ɑ yenu kɔsuku. Nɑ ǹ mɑɑ bɛɛn yɑ̃kunu mwɑɑmɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Kon bɛɛn tem kɑm koosiɑ. Bɛɛn yibɛrɛ be, bɑ koo nɑ bu sinɑ mi, kpɑ biti yu bu mwɑ. ");
INSERT INTO bba_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Kon de bu bɛɛ tɑbu wɔri kpɑ i yɑrinɑ i dɑ tem tukumɔ. Kpɑ bɛɛn wusu su ko bɑnsu. ");
INSERT INTO bba_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","35","Sɑɑ yè sɔɔ i ko i n wɑ̃ɑ tem tukum mi, bɛɛn tem mɛ, mu koo wɛ̃rɑ, wɛ̃rɑ bi i ǹ dɑɑ mu wɛ̃ɛre. ");
INSERT INTO bba_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","Be bɑ koo tiɑrɑ bɑ n wɑ̃ɑ yibɛrɛbɑn temɔ, kon de bu nuki sɑnkirɑ. Bɑɑ wuru kokosun dɑmu, ɡɑ koo de bu dukɑ yɑkurɑwɑ. Bɑ koo yɑkurɑwɑ nɡe be bɑ yibɛrɛbɑ wɑ bɑ tɑbu yɑ̃nu nɛni bɑ kɑ bu nɑɑ ɡire. Bɑ koo wɔrukuwɑ bɑɑ ɡoo ù kun bu nɑɑ swĩi. ");
INSERT INTO bba_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Bɑ koo wɔrikinɑwɑ nɡe be bɑ ɡoonɑmɔ tɑbu sɔɔ kɑ tɑkobi. Bɑ ǹ kpɛ̃ bu yɔ̃rɑ bu ben yibɛrɛbɑ mɑ. ");
INSERT INTO bba_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Bɑ koo ɡbiwɑ bwese tukunun suunu sɔɔ. Kpɑ yibɛrɛbɑ bu bu kɑm koosiɑ. ");
INSERT INTO bba_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Be bɑ koo tiɑrɑ yibɛrɛbɑn tem mi, bɑ koo woorɑwɑ kɑ nuku sɑnkirɑnu ben torɑnun sɔ̃ kɑ ben bɑɑbɑbɑɡinun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","Isireli be bɑ tiɑrɑ, bɑ koo ben torɑnu tuubɑ ko kɑ ben bɑɑbɑbɑɡinu ni bɑ kuɑ nɛ, Yinni Gusunɔn wuswɑɑɔ kɑ sere seesi bi bɑ mɑn seesi. ");
INSERT INTO bba_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","Bɑ koo ɡiɑ mɑ nɛnɑ nɑ bu seesi mɑ nɑ kɑ bu dɑ tem tukumɔ ben yibɛrɛbɑn mi. Sɑɑ ye sɔɔrɑ bɑ koo tii kɑwɑ ben nɑɑnɛ sɑrirun sɔ̃ kpɑ bu ɡiɑ mɑ nɛnɑ nɑ bu sɛɛyɑsiɑmɔ ben torɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","Sɑɑ ye sɔɔ, kon nɛn ɑrukɑwɑnibɑ yɑɑyɑ ye nɑ bɔkuɑ kɑ ben bɑɑbɑbɑ. Berɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu. Kon mɑɑ nɛn nɔɔ mwɛɛru yɑɑyɑ te nɑ kuɑ ben tem sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Ben biru, tem mɛ, mu koo wɛ̃rɑ. Sɑɑ ye sɔɔrɑ bɑ koo sɛɛyɑsiɑbu wɑ yèn sɔ̃ bɑ nɛn woodɑbɑ deri. ");
INSERT INTO bba_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Adɑmɑ bɑɑ bɑ̀ n wɑ̃ɑ tem tukumɔ ben yibɛrɛbɑn mi, nɑ ǹ bu derimɔ mɑm mɑm. Nɑ ǹ bu biru kisimɔ, nɑ ǹ mɑɑ bu kpeerɑsiɑmɔ. Nɑ ǹ nɛn ɑrukɑwɑni ye kusiɑmɔ. Domi nɑ sɑ̃ɑwɑ Gusunɔ ben Yinni. ");
INSERT INTO bba_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ben ɑrufɑɑnin sɔ̃ kon ɑrukɑwɑni ye yɑɑyɑ ye nɑ kɑ ben bɑɑbɑbɑ bɔkuɑ mi, ye yɑ derɑ nɑ bu yɑrɑ Eɡibitin di bwesenu kpuron nɔni biru, mɑ nɑ kuɑ ben Yinni. Nɛnɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Woodɑ kɑ sɔ̃ɔsi niniwɑ Yinni Gusunɔ u Mɔwisi wɛ̃ Sinɑin ɡuurɔ u kɑ Isirelibɑ sɔ̃. ");
INSERT INTO bba_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","ɑ Isirelibɑ woodɑ yeni sɔ̃ɔwɔ ɑ nɛɛ, ɡoo ù n nɔɔ mwɛɛru kuɑ u nɛɛ, u koo nɛ, Yinni Gusunɔ tɔnu kɛ̃, u koo kpĩ u ɡobi kɔsiɑ tɔnu win ɑyerɔ nɡe mɛni u kɑ win nɔɔ mwɛɛru yibiɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","Sɑɑ tɔn durɔ wi u wɔ̃ɔ yɛndu mɔn di n kɑ dɑ wɔ̃ɔ wɑtɑɡii, sii ɡeesun ɡobi weerɑɑkurɑ u koo kɔsiɑ nɡe mɛ bɑ rɑ sɑ̃ɑ yerun ɡobi kɔsi. ");
INSERT INTO bba_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Ǹ n tɔn kurɔn nɑ, sii ɡeesun ɡobi tɛnɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Tɔn durɔ wi u mɔ wɔ̃ɔ nɔɔbu n kɑ dɑ wɔ̃ɔ yɛnduɡii, sii ɡeesun ɡobi yɛndɑ u koo kɔsiɑ. Ǹ n mɑɑ tɔn kurɔn nɑ, sii ɡeesun ɡobi wɔkuru. ");
INSERT INTO bba_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Sɑɑ tɔn durɔ suru tiɑɡii sere n kɑ dɑ wɔ̃ɔ nɔɔbuɡii, sii ɡeesun ɡobi nɔɔbuwɑ u koo kɔsiɑ. Ǹ n mɑɑ tɔn kurɔn nɑ, sii ɡeesun ɡobi itɑwɑ u koo kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Goo ù n mɑɑ wɔ̃ɔ wɑtɑ mɔ ǹ kun mɛ ù n kere mɛ, sii ɡeesun ɡobi wɔkurɑ nɔɔbuwɑ u koo kɔsiɑ. Ǹ n mɑɑ tɔn kurɔn nɑ, sii ɡeesun ɡobi wɔkurɑ u koo kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Goo ù n sɑ̃ɑ sɑ̃ɑro too, mɑ u ǹ kpɛ̃ u kɔsiɑ mɛ bɑ ɡeruɑ, bɑ koo kɑ yɛ̃ro dɑwɑ yɑ̃ku kowon mi, kpɑ yɑ̃ku kowo wi, u nùn sɔ̃ mɛ̀n nɔɔ u koo kɔsiɑ nɡe mɛ win wɑɑrɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","Goo ù n nɛ, Yinni Gusunɔ nɔɔ mwɛɛru kuɑ mɑ u koo mɑn yɑɑ sɑberu kɛ̃ te bɑ rɑ kɑ yɑ̃kuru ko, yɑɑ sɑbe te, tɑ ko n sɑ̃ɑwɑ nɛɡiru. ");
INSERT INTO bba_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Bɑ ǹ kɑ tu ɡɑru kɔsinɑmɔ te tɑ kun wɑ̃. Bɑɑ tɑ̀ kun mɑɑ wɑ̃, bɑ ǹ kɑ tu ɡɑru kɔsinɑmɔ te tɑ wɑ̃. Kɑ mɛ, bɑ̀ n mɑɑ kɑ tu kɔsinɑ, ni yiru kpuro nu ko n sɑ̃ɑwɑ nɛɡinu. ");
INSERT INTO bba_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Goo ù n kɑ yɑɑ sɑberu nɑ te bɑ ku rɑ kɑ yɑ̃kuru ko, bɑ koo kɑ tu dɑwɑ yɑ̃ku kowon mi. ");
INSERT INTO bba_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Kpɑ yɑ̃ku kowo u tu mɛɛri u ten ɡeeru burɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Wi u kɑ yɑɑ sɑbe te nɑ, mɑ u kĩ u tu yɑkiɑ, ɡee te yɑ̃ku kowo u nùn bure, terɑ u koo kɔsiɑ. Kpɑ u mɑɑ ɡee ten bɔnu nɔɔbun tiɑ sosi. ");
INSERT INTO bba_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","Goo ù n win diru Yinni Gusunɔ kɑ̃, yɑ̃ku kowowɑ u koo dɑ u tu mɛɛri kpɑ u ten ɡeerun sɑkɑ ɡere. Gee te u ɡeruɑ mi, terɑ bɑ koo kɑ sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Adɑmɑ ù n kĩ u win dii te yɑkiɑ, u koo ɡinɑ ɡee te yɑ̃ku kowo u burɑ mi kɔsiɑwɑ kpɑ u ten wɔllɔ bɔnu nɔɔbusen tiɑ sosi dii te, tu sere mɑɑ ko wiɡiru. ");
INSERT INTO bba_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","Goo ù n mɑɑ win ɡberu Yinni Gusunɔ wɛ̃, bɑ koo ten ɡeeru burɑwɑ. Dĩɑ ni bɑ koo duuren kpɑ̃ɑrɑ bɑ koo mɛɛri. Nɡe tɛ̃ bɑ̀ n dĩɑ ni bɑ mɔ̀ ɔɔsu duurɑ, mɑ nu kilo ɡoobɑ wunɔbu (300) kuɑ, sii ɡeesun ɡobi weerɑɑkurɑ bɑ koo kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Ǹ n sɑ̃ɑn nɑ yɑkiɑbun tɔ̃ɔ bɑkɑrun diyɑ u ɡbee te wɛ̃, ten ɡobi kpurowɑ u koo kɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Ù n ɡbee te Yinni Gusunɔ wɛ̃ yɑkiɑbun tɔ̃ɔ bɑkɑrun biru, yɑ̃ku kowo u koo ten ɡobi kɑwɑwɑ. U koo wɔ̃ɔ si su tie sere yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turin ɡobi kɔsiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Yɛ̃ro ù n kĩ u win ɡbee te yɑkiɑ, u koo kɔsiɑwɑ ye bɑ burɑ mi, kpɑ u yen bɔnu nɔɔbun tiɑ sosi ɡbee te, tu sere mɑɑ ko wiɡiru. ");
INSERT INTO bba_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Ù kun tu yɑkie, mɑ bɑ tu ɡoo dɔre, u ǹ mɑɑ kpɛ̃ u tu yɑkiɑ win tii. ");
INSERT INTO bba_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ, tɑ koo kowɑ Yinni Gusunɔɡiru. Yɑ̃ku kowobɑ bɑ ko n tu mɔ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","Goo ù n Yinni Gusunɔ ɡberu wɛ̃ te u dwɑ, n ǹ mɔ te u tubi di, ");
INSERT INTO bba_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","yɑ̃ku kowowɑ u koo tu mɛɛri kpɑ u ten ɡeeru burɑ. U koo wɔ̃su ɡɑriwɑ si su tie yɑkiɑbun tɔ̃ɔ bɑkɑru tu kɑ turi. Wɔ̃ɔ si kpuron ɡobiyɑ u koo ɡere kpɑ ɡobi yi, yi ko Yinni Gusunɔɡii. ");
INSERT INTO bba_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Adɑmɑ yɑkiɑbun tɔ̃ɔ bɑkɑru tɑ̀ n tunumɑ, ɡbee te, tɑ ko n sɑ̃ɑwɑ wi u rɑɑ nùn tu dɔreɡiru. ");
INSERT INTO bba_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Bɑ koo ɡɑ̃ɑnu kpuron ɡeeru burɑwɑ nɡe mɛ bɑ rɑ sɑ̃ɑ yerun ɡobi kɔsi. N deemɑ ɡobi yin tiɑn bunum mu rɑ n sɑ̃ɑwɑ ɡɑrɑmu wɔkuru. ");
INSERT INTO bba_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","Goo u ku rɑɑ win yɑɑ sɑberun buu ɡbiikuu Yinni Gusunɔ kɛ̃. Domi ɡɑ sɑ̃ɑwɑ Yinni Gusunɔɡuu kɔ yèn sɔ̃ ɡɑ sɑ̃ɑ buu ɡbiikuu. Bɑɑ ǹ n yɑ̃ɑrun nɑ ǹ kun mɛ kɛtɛ, ɡɑ sɑ̃ɑwɑ Yinni Gusunɔɡuu. ");
INSERT INTO bba_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Gɑ̀ n mɑɑ sɑ̃ɑn nɑ sɑbe te bɑ ku rɑ kɑ yɑ̃kuru kon buu ɡbiikuu, wi u kɑ tu nɑ u koo kpĩ u tu yɑkiɑ ù n ɡee te yɑ̃ku kowo u nùn bure kɔsiɑ kpɑ u mɑɑ ten bɔnu nɔɔbun tiɑ sosi. Ù n kpɑnɑ u tu yɑkiɑ, yɑ̃ku kowo u koo kpĩ u tu ɡoo dɔre nɡe mɛ u ten ɡeeru bure. ");
INSERT INTO bba_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","Gɑ̃ɑ ni bɑ Yinni Gusunɔ kɑ̃ sere kɑ bɑɑdommɑɔ, ɑɑ tɔnuwɑ? Ǹ kun mɛ yɑɑ sɑberɑ? Ǹ kun mɛ ɡbee te u tubi diwɑ? Gɑ̃ɑ ni bɑ ɡɔsɑ bɑ yi Yinni Gusunɔn sɔ̃ ɡesi, n ǹ mɑɑ koorɔ u nu yɑkiɑ ǹ kun mɛ u nu dɔrɑ. Nu ko n sɑ̃ɑwɑ Yinni Gusunɔɡinu sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Bɑɑ ǹ n tɔnun nɑ n ǹ koorɔ u nùn yɑkiɑ. Bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","I ko i n dɑ Yinni Gusunɔ bɛɛn ɡberun dĩɑnun subɑ wɔkuru sɔɔ tiɑ yiiyewɑ sere kɑ dɑ̃ɑ mɑrumɔ. ");
INSERT INTO bba_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Goo ù n kĩ u ye yɑkiɑ, u koo yen ɡee te kɔsiɑwɑ kpɑ u mɑɑ yen bɔnu nɔɔbun tiɑ sosi. ");
INSERT INTO bba_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Mɛyɑ mɑɑ yɑɑ sɑbenu sɔɔ. Yɑ̃ɑrɑ? Kɛtɛwɑ? Boowɑ? Sɑbe ni bɑ kpɑre ɡesi, wɔkuru bɑɑteren wɔllɔ Yinni Gusunɔ u teeru mɔ. ");
INSERT INTO bba_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Wi u sɑbe ni mɔ, u ǹ koo ɡɔsi te tɑ wɑ̃ ǹ kun mɛ te tɑ kun wɑ̃. U ǹ mɑɑ kɑ tu ɡɑru kɔsinɑmɔ. Bɑɑ ù n kɑ tu ɡɑru kɔsinɑ, ni yiru kpuro nu ko n sɑ̃ɑwɑ Yinni Gusunɔɡinu. N ǹ koorɔ bu nu yɑkiɑ. ");
INSERT INTO bba_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Woodɑ yenibɑrɑ Yinni Gusunɔ u Mɔwisi wɛ̃ Isirelibɑn sɔ̃ Sinɑin ɡuurɔ.");
INSERT INTO bba_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Ye Isirelibɑ bɑ yɑrimɑ Eɡibitin di, yen wɔ̃ɔ yirusen suru yirusen tɔ̃ɔ ɡbiikiru sɔɔrɑ Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ win kuu bekuruɡirɔ, ɡbɑbu te bɑ mɔ̀ Sinɑiɔ. ");
INSERT INTO bba_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","U nɛɛ, i Isirelibɑn tɔn durɔbu kpuro ɡɑrio, wunɛ kɑ Aroni, yɛnu kɑ yɛnu, bwese kɛrɑ kɑ bwese kɛrɑ, kpɑ i bɑɑwuren yĩsiru yore. ");
INSERT INTO bba_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","I bu ɡɑrio be bɑ wɑ̃ɑ tɑbu wuunu sɔɔ, sɑɑ be bɑ wɔ̃ɔ yɛndu mɔn di sere kɑ be bɑ kere mɛ, be bɑ koo kpĩ bu tɑbu ko. ");
INSERT INTO bba_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Bwese kɛrɑ bɑɑyeren ɡuro ɡurowɑ u koo bɛɛ somi. ");
INSERT INTO bba_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Be bɑ koo bɛɛ somi mi, beyɑ, Elisuri, Sedeurin bii, Rubɛnin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","kɑ Selumiɛli, Surisɑdɑin bii, Simɛɔn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","kɑ Nɑsoni, Aminɑdɑbun bii, Yudɑn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","kɑ Nɛtɑnɛɛli, Suɑrin bii, Isɑkɑrin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","kɑ Eliɑbu, Helonin bii, Sɑbulonin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","kɑ Elisɑmɑ, Amihudun bii, Efɑrɑimu, Yosɛfun biin bweseru sɔɔ, kɑ Gɑmuliɛli, Pedɑsurin bii, Mɑnɑse, Yosɛfun bii turo ɡoon bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","kɑ Abidɑni, Gideonin bii, Bɛnyɑmɛɛn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","kɑ Akiesɛɛ, Amisɑdɑin bii, Dɑnun bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","kɑ Pɑɡiɛli, Okirɑnin bii, Asɛɛn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","kɑ Eliɑsɑfu, Dewɛlin bii, Gɑdin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","kɑ sere Ahirɑ, Enɑnin bii, Nɛfitɑlin bweseru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Guro ɡuro be bɑ ɡɔsɑ mi, bɑ sɑ̃ɑwɑ Isirelibɑn tɑbu sinɑmbu. ");
INSERT INTO bba_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Mɑ Mɔwisi kɑ Aroni bɑ tɔmbu wɔkurɑ yiru ye suɑ bèn yĩsinu bɑ siɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","Mɑ bɑ Isirelibɑ kpuro sokɑ bɑ mɛnnɑ wɔ̃ɔn suru yirusen tɔ̃ɔ ɡbiikiru sɔɔ, mɑ bɑ bu ɡɑrɑ bwese kɛrɑ kɑ bwese kɛrɑ, yɛnu kɑ yɛnu, sɑɑ tɔn durɔ be bɑ wɔ̃ɔ yɛndu mɔn di sere kɑ be bɑ kere mɛ, mɑ bɑ ben yĩsɑ yoruɑ. ");
INSERT INTO bba_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Mɔwisi u bu ɡɑrɑ Sinɑin ɡbɑburɔ nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","43","Bɑ Isirelibɑn bwese kɛrɑ bɑɑyeren tɔmbu ɡɑrɑ yɛnu kɑ yɛnu. Mɑ bɑ ben yĩsɑ yoruɑ sɑɑ be bɑ wɔ̃ɔ yɛndu mɔn di, be bɑ koo kpĩ bu tɑbu ko. Bɑ ɡɑrim toruɑwɑ kɑ Rubɛni, Yɑkɔbun bii ɡbiikoon bwese kɛrɑ. Tɔn ben ɡeeru wee. Rubɛnin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɔɔbɑ tiɑ kɑ nɛɛrɑ wunɔbu (46.500). Simɛɔn bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ nɔɔbɑ nnɛ kɑ ɡoobɑ wunɔbu (59.300). Gɑdin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɔɔbu kɑ nɑtɑ kɑ weerɑɑkuru (45.650). Yudɑn bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wɑtɑ kɑ wɔkurɑ nnɛ kɑ nɑtɑ (74.600). Isɑkɑrin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ nnɛ kɑ nɛɛru (54.400). Sɑbulonin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ nɔɔbɑ yiru kɑ nɛɛru (57.400). Efɑrɑimu, Yosɛfun biin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɛɛrɑ wunɔbu (40.500). Mɑnɑse, Yosɛfun biin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ tɛnɑ kɑ yiru kɑ ɡoobu (32.200). Bɛnyɑmɛɛn bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ tɛnɑ kɑ nɔɔbu kɑ nɛɛru (35.400). Dɑnun bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wɑtɑ kɑ yiru kɑ nɑtɑ kɑ wunɔbu (62.700). Asɛɛn bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ tiɑ kɑ nɛɛrɑ wunɔbu (41.500). Nɛfitɑlin bweseru sɔɔ, bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ itɑ kɑ nɛɛru (53.400). ");
INSERT INTO bba_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Tɔn be Mɔwisi kɑ Aroni kɑ Isirelibɑn ɡuro ɡurobu wɔkurɑ yiru ye, bɑ ɡɑrɑ, ben ɡeerɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Bɑ bu ɡɑrɑwɑ sɑɑ be bɑ wɔ̃ɔ yɛndu mɔn di sere kɑ be bɑ kere mɛ, be bɑ koo kpĩ bu tɑbu ko. ");
INSERT INTO bba_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Be kpuron ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ nɑtɑ kɑ itɑ kɑ nɛɛrɑ wunɔbu kɑ weerɑɑkuru (603.550). ");
INSERT INTO bba_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Bɑǹ Lefibɑn bweserɔ tɔmbu ɡɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","yèn sɔ̃ Yinni Gusunɔ u rɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","Isirelibɑ sɔɔ, ɑ ku Lefibɑn bweserun tɔmbu ɡɑri. ");
INSERT INTO bba_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Kɑɑ de bu nɛ, Yinni Gusunɔn kuu te nɔɔriwɑ kɑ ten dendi yɑ̃nu kɑ ye yɑ wɑ̃ɑ mi kpuro, beyɑ bɑ ko n dɑ ye kpuro sɔbe. Kpɑ bu ben kunu ɡirɑ bu kɑ nɛ, Yinni Gusunɔn kuu te sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Isirelibɑ bɑ̀ n seewɑ, Lefibɑrɑ bɑ ko n dɑ kuu te kure. Bɑ̀ n koo mɑɑ ben sɑnsɑni ɡirɑ, bɑ ko n dɑ Yinni Gusunɔn kuu te ɡirewɑ. Tɔn tuko ù n tu bɛsu, bɑ koo nùn ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Isireli be bɑ mɑɑ tie, bɑ koo sinɑwɑ ben bwese kɛrɑn wuuru sɔɔ, ben bɑɑwure u yɔ̃rɑ mi ben ɡidi bɔrɑ yɑ ɡire nɡe mɛ bɑ bu bɔnu sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Adɑmɑ Lefibɑ bɑ koo ben sɑnsɑni ɡirɑwɑ bu kɑ kuu te sikerenɑ mi woodɑn kpɑkororɑ wɑ̃ɑ. Nɡe mɛyɑ bɑ koo kɑ tu kɔ̃su. Sɑɑ ye sɔɔ, Isirelibɑ bɑǹ mɑɑ wɑsi bu tu susi n sere kɑ bu mɔru ko. ");
INSERT INTO bba_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Mɑ Isirelibɑ bɑ Yinni Gusunɔn woodɑ ye kpuro mɛm nɔɔwɑ mɑm mɑm ye u Mɔwisi wɛ̃ mi. ");
INSERT INTO bba_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","Isirelibɑ bɑ̀ n ben sɑnsɑni ɡirɑmɔ, ben bɑɑwure u koo win kuru ɡirɑwɑ win bweserun ɡidi bɔrɑn bɔkuɔ. Bɑ koo ben kuu ni ɡirɑwɑ bu kɑ nɛ, Yinni Gusunɔn kuu te sikerenɑ, kpɑ beɡii ni, nu n kɑ tu dɛsire fiiko. ");
INSERT INTO bba_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Sɔ̃ɔ yɑri yeru ɡiɑrɑ Yudɑbɑ bɑ koo ben sɑnsɑni ɡirɑ ben ɡidi bɔrɑn bɔkuɔ be, kɑ ben tɑbu kowobu. Ben tɑbu sunɔn yĩsirɑ Nɑsoni, Aminɑdɑbun bii. ");
INSERT INTO bba_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ nɔrɔbun subɑ wɑtɑ kɑ wɔkurɑ nnɛ kɑ nɑtɑ (74.600). ");
INSERT INTO bba_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","7","Be bɑ ko n wɑ̃ɑ ben wuuru sɔɔ berɑ, Isɑkɑrin bwese kɛrɑ kɑ Sɑbulonin bwese kɛrɑ. Isɑkɑrin tɑbu sunɔn yĩsirɑ Nɛtɑnɛɛli, Suɑrin bii. Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ nɔrɔbun subɑ weerɑɑkuru kɑ nnɛ kɑ nɛɛru (54.400). Sɑbulonibɑn tɑbu sunɔn yĩsirɑ Eliɑbu, Helonin bii. ");
INSERT INTO bba_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ nɔrɔbun subɑ weerɑɑkuru kɑ nɔɔbɑ yiru kɑ nɛɛru (57.400). ");
INSERT INTO bba_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Be kpurowɑ bɑ sɑ̃ɑ Yudɑbɑn tɑbu kowobu mɑ ben ɡeerɑ kuɑ nɔrɔbun subɑ wunɔbu kɑ wɛnɛ kɑ nɔɔbɑ tiɑ kɑ nɛɛru (186.400). Isirelibɑ bɑ̀ n sɑnum seewɑ, berɑ bɑ ko n dɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑrɑ Rubɛnibɑ bɑ koo ben sɑnsɑni ɡirɑ ben ɡidi bɔrɑn bɔkuɔ be, kɑ ben tɑbu kowobu. Ben tɑbu sunɔn yĩsirɑ Elisuri, Sedeurin bii. ");
INSERT INTO bba_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Ben tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɔɔbɑ tiɑ kɑ nɛɛrɑ wunɔbu (46.500). ");
INSERT INTO bba_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","14","Be bɑ ko n wɑ̃ɑ ben wuuru sɔɔ, berɑ Simɛɔn bwese kɛrɑ kɑ Gɑdin bwese kɛrɑ. Simɛɔbɑn tɑbu sunɔn yĩsirɑ Selumiɛli, Surisɑdɑin bii. Ben tɑbu kowobu bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ nɔɔbɑ nnɛ kɑ ɡoobɑ wunɔbu (59.300). Gɑdiɡibun tɑbu sunɔn yĩsirɑ Eliɑsɑfu, Dewɛlin bii. ");
INSERT INTO bba_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Ben tɑbu kowobɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɔɔbu kɑ nɑtɑ kɑ weerɑɑkuru (45.650). ");
INSERT INTO bba_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Be kɑ Rubɛnin tɑbu kowobu kpuro bɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wunɔbu kɑ weerɑɑkuru kɑ tiɑ kɑ nɛɛru kɑ weerɑɑkuru (151.450). Beyɑ bɑ koo ko yiruse bɑ̀ n swɑɑ wɔriɔ. ");
INSERT INTO bba_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Yen biru, Lefibɑ bɑ koo Yinni Gusunɔn kuru suɑ kpɑ bɑ n wɑ̃ɑ tɑbu kowo wuunu yiru ye yɑ ɡbiɑ kɑ wuunu yiru ye yɑ wɑ̃ɑ biruɔn suunu sɔɔ. Ben tii bɑ ko n swĩinɛwɑ nɡe mɛ bɑ rɑ kɑ sinɛ sinɛ bɑ̀ n sɑnsɑni ɡirɑmɔ. Ben bɑɑwure u koo yɔ̃rɑwɑ win ɡidi bɔrɑn bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Sɔ̃ɔ duu yeru ɡiɑrɑ Efɑrɑimubɑ bɑ koo ben sɑnsɑni ɡirɑ ben ɡidi bɔrɑn bɔkuɔ be, kɑ ben tɑbu kowobu. Ben tɑbu sunɔn yĩsirɑ Elisɑmɑ, Amihudun bii. ");
INSERT INTO bba_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɛɛrɑ wunɔbu (40.500). ");
INSERT INTO bba_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","23","Ben wuuru sɔɔrɑ Mɑnɑsebɑ kɑ Bɛnyɑmɛɛbɑ bɑ koo ben sɑnsɑni ɡirɑ. Mɑnɑsebɑn tɑbu sunɔn yĩsirɑ Gɑmuliɛli, Pedɑsurin bii. Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ tɛnɑ kɑ yiru kɑ ɡoobu (32.200). Bɛnyɑmɛɛbɑn tɑbu sunɔwɑ Abidɑni, Gideonin bii. Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ tɛnɑ kɑ nɔɔbu kɑ nɛɛru (35.400). ");
INSERT INTO bba_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Be kpuro kɑ Efɑrɑimun tɑbu kowobun ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ wunɔbu kɑ nɔɔbɑ itɑ kɑ wunɔbu (108.100). Berɑ bɑ ko n sɑ̃ɑ itɑse bɑ̀ n swɑɑ wɔriɔ. ");
INSERT INTO bba_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑrɑ Dɑnubɑ bɑ koo mɑɑ ben sɑnsɑni ɡirɑ ben ɡidi bɔrɑn bɔkuɔ be, kɑ ben tɑbu kowobu. Ben tɑbu sunɔn yĩsirɑ Akiesɛɛ, Amisɑdɑin bii. ");
INSERT INTO bba_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wɑtɑ kɑ yiru kɑ nɑtɑ kɑ wunɔbu (62.700). ");
INSERT INTO bba_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","30","Ben wuuru sɔɔrɑ Asɛɛbɑ kɑ Nɛfitɑlibɑ bɑ koo du. Asɛɛbɑn tɑbu sunɔn yĩsirɑ Pɑɡiɛli, Okirɑnin bii. Ben tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ tiɑ kɑ nɛɛrɑ wunɔbu (41.500). Nɛfitɑlibɑn tɑbu sunɔn yĩsirɑ Ahirɑ, Enɑnin bii. Win tɑbu kowobun ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ itɑ kɑ nɛɛru (53.400). ");
INSERT INTO bba_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Be kpuro kɑ Dɑnubɑ ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ wunɑɑ wɑtɑ itɑ sɑri kɑ nɑtɑ (157.600). Isirelibɑ bɑ̀ n swɑɑ wɔri, kpɑ ben bɑɑwuren ɡidi bɔrɑ yɑ n bu ɡbiiye, berɑ bɑ koo be bɑ tie swĩi biruɔ. ");
INSERT INTO bba_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Isireli be bɑ koo kpĩ bu tɑbu ko, ben ɡeerɑ kuɑwɑ nɔrɔbun subɑ nɑtɑ kɑ itɑ kɑ nɛɛrɑ wunɔbu kɑ weerɑɑkuru (603.550). Bɑ bu ɡɑrɑwɑ bwese kɛrɑ kɑ bwese kɛrɑ, yɛnu kɑ yɛnu. ");
INSERT INTO bba_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Bɑǹ Lefibɑn bweseru ɡɑrɑ yèn sɔ̃ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u ku bu ɡɑri. ");
INSERT INTO bba_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Mɑ Isirelibɑ bɑ kuɑ mɑm mɑm ye Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. Ben bɑɑwure u win sɑnsɑni ɡirɑwɑ mi ben ɡidi bɔrɑ yɑ ɡire. Yen biru, bɑ̀ n seewɑ bɑ swɑɑ wɔriɔ, bɑ rɑ n swĩinɛwɑ bwese kɛrɑ kɑ bwese kɛrɑ, yɛnu kɑ yɛnu. ");
INSERT INTO bba_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Tɔn be bɑ wɑ̃ɑ Aroni kɑ Mɔwisin bwese kɛrɑ sɔɔ sɑnɑm mɛ Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ Sinɑiɔ, ben yĩsɑ wee. ");
INSERT INTO bba_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Bibu nnɛwɑ Aroni u mɔ. Gbiikoon yĩsirɑ Nɑdɑbu. Be bɑ mɑɑ tie berɑ, Abihu kɑ Eleɑsɑɑ kɑ Itɑmɑɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Be kpurowɑ bɑ ɡum tɑ̃re bu kɑ ko yɑ̃ku kowobu, mɑ bɑ bu yi nɛnɛm sɔmbu ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Adɑmɑ Nɑdɑbu kɑ Abihu bɑ ɡu sɑ̃ɑ yerun kɔnnɔwɔ Sinɑin ɡbɑburɔ sɑnɑm mɛ bɑ kɑ Yinni Gusunɔ turɑre tukɑ dɑɑwɔ bu kɑ yɑ̃kunu ko. N deemɑ ben ɡoo kun bii mɑrɑ. Mɑ n tiɑ Eleɑsɑɑ kɑ Itɑmɑɑ kɑ sere ben bɑɑbɑ Aroni wi u rɑ n bu kpɑre yɑ̃ku kobun sɔmburu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","ɑ de Lefin bibun bweseru tu nɑ kpɑ ɑ tu Aroni nɔmu sɔndiɑ sɔmbu ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Bɑ ko n dɑ n wɑ̃ɑwɑ Gusunɔn kurun kɔnnɔwɔ bu kɑ ten sɔmburu ko Aroni kɑ Isirelibɑ kpuron ɑyerɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Beyɑ bɑ koo kuu te, kɑ ten dendi yɑ̃nu kpuron sɔmburu ko Isirelibɑn ɑyerɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Kɑɑ woodɑ wɛ̃wɑ ɑ nɛɛ, Aroni kɑ win bibɑ bɑ ko n Lefibɑ mɔ bu kɑ sɑ̃ɑ yee ten sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Adɑmɑ Aroni kɑ win bibu tɔnɑwɑ bɑ koo yɑ̃kuru ko. Goo ù n yɑ̃kuru kuɑ, mɑ n kun be, bɑ koo yɛ̃ro ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","wee nɑ Lefibɑ wunɑ Isirelibɑn suunu sɔɔn di bɑ n kɑ sɑ̃ɑ Isirelibɑn bii tɔn durɔ ɡbiikobun kɔsire, kpɑ bu ko nɛɡibu. ");
INSERT INTO bba_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Domi sɑɑ mìn di nɑ Eɡibitiɡibun bii ɡbiikobu ɡo, sɑɑ min diyɑ nɑ Isirelibɑn bii ɡbiikobu kɑ ben yɑɑ sɑbenun bii ɡbiikinu tii yiiyɑ. Mɑ bɑ kuɑ nɛɡibu. Nɛnɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ Sinɑin ɡbɑburɔ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","ɑ Lefin bibun bweseru ɡɑrio yɛnu kɑ yɛnu, bweseru kɑ bweseru. Ben tɔn durɔ bɑɑwurewɑ kɑɑ ɡɑri sɑɑ be bɑ suru tiɑ mɔn di sere kɑ be bɑ kere mɛ. ");
INSERT INTO bba_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Mɑ Mɔwisi u bu ɡɑrɑ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Be bɑ sɑ̃ɑ Lefin bibu berɑ, Gɛɛsɔni kɑ Kehɑti kɑ Mɛrɑri. ");
INSERT INTO bba_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Be bɑ sɑ̃ɑ Gɛɛsɔnin bibu kɑ ben bweseru berɑ, Libini kɑ Simɛi. ");
INSERT INTO bba_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Be bɑ sɑ̃ɑ Kehɑtin bibun bweseru berɑ, Amurɑmu kɑ Yisehɑri kɑ Heboroni kɑ Usiɛli. ");
INSERT INTO bba_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Be bɑ mɑɑ sɑ̃ɑ Mɛrɑribɑ kɑ ben bweseru berɑ, Mɑkili kɑ Musi. Beni kpurowɑ bɑ sɑ̃ɑ Lefin bibun bweseru. ");
INSERT INTO bba_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Gɛɛsɔnin min diyɑ Libinin bweseru kɑ Simɛin bweseru tɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Tɔn durɔ be bɑ ɡɑrɑ be bɑ suru tiɑ mɔ kɑ be bɑ kere mɛ Gɛɛsɔnin bweseru sɔɔ ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ nɔɔbɑ yiru kɑ nɛɛrɑ wunɔbu (7.500). ");
INSERT INTO bba_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Gɛɛsɔnibɑ bɑ rɑ ben sɑnsɑni ɡirewɑ Yinni Gusunɔn kurun biruɔ sɔ̃ɔ duu yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Ben kpɑron yĩsirɑ Eliɑsɑfu, Lɑɛlin bii. ");
INSERT INTO bba_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ye Gɛɛsɔnin bweseru tɑ ko n dɑ ko kuu bekuruɡii te sɔɔ yerɑ, kuu ten beku kɑrenu ni bɑ koo doke ten sɔɔwɔ kɑ ten tɔɔwɔ kɑ ten kɔnnɔwɔ ");
INSERT INTO bba_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","kɑ ten yɑɑrɑɔ kɑ yɑɑrɑ yen kɔnnɔwɔ kɑ sere mɑɑ ten wɛ̃ɛ kpuro. ");
INSERT INTO bba_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Kehɑtin min diyɑ Amurɑmuɡibu kɑ Yisehɑriɡibu kɑ Heboroniɡibu kɑ Usiɛliɡibun bwese kɛri mɑɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Tɔn durɔ be bɑ ɡɑrɑ Kehɑtin bwese te sɔɔ, be bɑ suru tiɑ mɔ kɑ be bɑ kere mɛ, ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ nɔɔbɑ itɑ kɑ nɑtɑ (8.600). ");
INSERT INTO bba_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Kehɑtibɑ bɑ rɑ ben sɑnsɑni ɡirewɑ kuu ten sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Ben kpɑron yĩsirɑ Elisɑfɑni, Usiɛlin bii. ");
INSERT INTO bba_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Kehɑti berɑ bɑ ko n dɑ woodɑn kpɑkoro ten sɔmburu ko kɑ tɑbulu ye, kɑ dɑbu ɡe, kɑ yɑ̃ku yenu kɑ kuu ten dendi yɑ̃nu kpuro kɑ dii dɛɛrɑrun beku kɑre te. Beyɑ bɑ ko n dɑ ye kpuron sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Wi u sɑ̃ɑ Lefibɑ kpuron ɡuro ɡuro wiyɑ, Eleɑsɑɑ, Aroni yɑ̃ku kowon bii. Wiyɑ u tɔn be kpuro kpɑre be bɑ sɑ̃ɑ yee ten sɔmɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Mɛrɑrin min diyɑ Mɑkiliɡibu kɑ Musiɡibun bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Tɔn durɔ be bɑ ɡɑrɑ be bɑ suru tiɑ mɔ kɑ be bɑ kere mɛ, ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ nɔɔbɑ tiɑ kɑ ɡoobu (6.200). ");
INSERT INTO bba_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Ben kpɑron yĩsirɑ Suriɛli, Abihɑilin bii. Bɑ rɑ ben sɑnsɑni ɡirewɑ sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Beyɑ bɑ Yinni Gusunɔn kuu ten dɑ̃ɑ bɛsi kɑ ten dɑ̃ɑ pɔɔsi kɑ ten ɡberebɑ kɑ ten yɔ̃rɑtii kɑ ten sɔm yɑ̃nu kpuro nɔmu sɔndiɑ, ");
INSERT INTO bba_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","kɑ sere ten kɑrɑ dɑ̃nu kɑ ten yɔ̃rɑtii kɑ ten kurumbɑ kɑ ten wɛ̃ɛ. ");
INSERT INTO bba_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Mɔwisi kɑ Aroni kɑ win bibu bɑ rɑ ben sɑnsɑni ɡirewɑ kuu ten kɔnnɔwɔ sɔ̃ɔ yɑri yeru ɡiɑ. Domi beyɑ bɑ ko n dɑ sɔmburu ko kuu te sɔɔ Isirelibɑn sɔ̃ kpɑ bɑ n tu kɔ̃su tɔn tuko ɡoo u ku rɑɑ kɑ tu susin sɔ̃, kpɑ u ku rɑɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lefi tɔn durɔ be Mɔwisi kɑ Aroni bɑ ɡɑrɑ be bɑ suru tiɑ mɔ kɑ be bɑ kere mɛ, nɡe mɛ Yinni Gusunɔ u ɡeruɑ, ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ yɛndɑ yiru (22.000). ");
INSERT INTO bba_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑn bii tɔn durɔ ɡbiikobu ɡɑrio sɑɑ be bɑ suru tiɑ mɔn di sere kɑ be bɑ kere mɛ, kpɑ ɑ bu ɡɑri bɑɑwure kɑ win yĩsiru. ");
INSERT INTO bba_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Yen biru, kpɑ ɑ Lefibɑ wunɑ ɑ yi nɛnɛm bɑ n sɑ̃ɑ nɛ Yinni Gusunɔɡibu Isirelibɑn bii ɡbiikobun ɑyerɔ. Mɛyɑ kɑɑ mɑɑ mɑn ben yɑɑ sɑbenu yiiyɑ Isirelibɑn yɑɑ sɑbenun bii ɡbiikinun ɑyerɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Mɑ Mɔwisi u Isirelibɑn bii ɡbiikoo be ɡɑrɑ nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Mɑ be kpuron ɡeerɑ kuɑ tɔnu nɔrɔbun subɑ yɛndɑ yiru kɑ ɡoobu kɑ wɑtɑ kɑ wɔkurɑ itɑ (22.273). ");
INSERT INTO bba_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Yinni Gusunɔ u kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","ɑ Lefibɑ wunɔ nɛnɛm kpɑ bu ko bii ɡbiikoo be kpuron kɔsire. Mɛyɑ kɑɑ mɑɑ ko kɑ ben yɑɑ sɑbenu kpuro, nu ko Isirelibɑn yɑɑ sɑbenun buu ɡbiikuu bɑɑɡeren kɔsire. Bɑ ko n wɑ̃ɑwɑ nɛn sɔ̃. Nɛnɑ Yinni Gusunɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Bɑ̀ n kĩ bu Isirelibɑn bii ɡbiikobu ɡoobu kɑ wɑtɑ kɑ wɔkurɑ itɑ (273) be bɑ Lefibɑ dɑbiru kere mi yɑkiɑ, ");
INSERT INTO bba_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","sii ɡeesun ɡobi nɔɔbuwɑ kɑɑ mwɑ ben bɑɑwuren wɔllɔ. Gobi yin tiɑn bunum mu sɑ̃ɑwɑ ɡɑrɑmu wɔkuru nɡe mɛ bɑ kɑ yi dimɔ sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Aroni kɑ win bibɑ kɑɑ yi nɔmu bɛriɑ bu kɑ Isirelibɑn bii ɡbiikobu yɑkiɑ be bɑ Lefibɑ dɑbiru kere. ");
INSERT INTO bba_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Mɑ Mɔwisi u ɡobi yi mwɛɛrɑ u yi bii ɡbiikoo ben yɑkiɑbun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Mɑ yi kuɑ sii ɡeesun ɡobi nɔrɔbu kɑ ɡoobɑ wunɔbu kɑ wɑtɑ kɑ nɔɔbu (1.365) nɡe mɛ bɑ kɑ yi dimɔ sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Mɑ u yi kpuro Aroni kɑ win bibu wɛ̃ nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","i Kehɑtin bweserun tɔmbu ɡɑrio Lefin bibun bweseru sɔɔ, yɛnu kɑ yɛnu, ");
INSERT INTO bba_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","sɑɑ be bɑ wɔ̃ɔ tɛnɑ mɔn di n kɑ ɡirɑri be bɑ mɔ wɔ̃ɔ weerɑɑkurɔ, be bɑ koo kpĩ bu Yinni Gusunɔn kuu ten sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Sɑ̃ɑ yerun dii te tɑ dɛɛre ɡem ɡem sɔɔrɑ bɑ koo sɔmburu ko. Sɔmbu te bɑ koo ko wee. ");
INSERT INTO bba_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Bɑ̀ n seewɑ bɑ doonɔ, Aroni kɑ win bibɑ bɑ koo beku kɑre te sɔsiɑ te tɑ wɑ̃ɑ dii te tɑ dɛɛre ɡem ɡem kɔnnɔwɔ, kpɑ bu tu woodɑn kpɑkoro te wukiri. ");
INSERT INTO bba_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Ten wɔllɔwɑ bɑ koo ɡɔni dɑmɡii tɛriɑ kpɑ bu mɑɑ yin wɔllɔ beku booɡuɡiru sɔndi kpɑ bu sere kpɑkoro ten nɛnutii wɑsi. ");
INSERT INTO bba_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","Bɑ koo beku booɡuɡiru tɛriɑwɑ tɑbulu yen wɔllɔ mi bɑ rɑ pɛ̃ɛ sɔndi kpɑ bu yen wɔllɔ ɡbɛ̃ɛnu sɔndi kɑ nɔri kɑ pɛrɛntibɑ kɑ tɑm kpɑrɑbɑnu, kpɑ bu ku de pɛ̃ɛ yu biɑrɑ mi bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Yen biruwɑ bɑ koo ye kpuron wɔllɔ beku wunɔmɡiru wukiri kpɑ bu ɡɔni dɑmɡii sɔndi. Bɑ̀ n kpɑ, kpɑ bu tɑbulu yen nɛnutii wɑsi. ");
INSERT INTO bba_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","Yen biru, bɑ koo mɑɑ beku booɡuɡiru suɑ bu dɑbu ɡe wukiri kɑ ɡen fitilɑnu kɑ ɡen bɑkusu kɑ ɡen torom ɡurɑtii kɑ ɡum kpɑrɑbɑnu, ɡen dendi yɑ̃nu kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Bɑ koo dɑbu ɡe, kɑ ɡen dendi yɑ̃ɑ ni kpuro dokewɑ bɔɔru sɔɔ te bɑ kuɑ kɑ ɡɔni dɑmɡiɑ. Yen biru, kpɑ bu tu sɑ̃ɑrusiɑ dɑ̃ɑ pɔturɑ sɔɔ ye bɑ koo kɑ tu suɑ. ");
INSERT INTO bba_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","Kpɑ bu mɑɑ beku booɡuɡiru suɑ bu wukiri kpɑkoro ten wɔllɔ mi bɑ rɑ turɑre dɔ̃ɔ doke kpɑ bu mɑɑ tu ɡɔni dɑmɡii wukiri. Yen biru, kpɑ bu ten nɛnutii wɑsi. ");
INSERT INTO bba_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","Kpɑ bu kuu ten dendi yɑ̃nu kpuro suɑ bu nu kure kɑ beku booɡuɡiru. Yen biru, kpɑ bu nu doke bɔɔru sɔɔ te bɑ kuɑ kɑ ɡɔni dɑmɡii kpɑ bu bɔɔ te sɑ̃ɑrusiɑ dɑ̃ɑ pɔturɑ sɔɔ ye bɑ koo kɑ tu suɑ. ");
INSERT INTO bba_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","Kpɑ bu mɑɑ torom ɡurɑ yɑ̃ku yerun di. Yen biru, kpɑ bu tu beku wunɔmɡiru wukiri. ");
INSERT INTO bba_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ten wɔllɔwɑ bɑ koo ten dendi yɑ̃ɑ ni kpuro doke. Niyɑ, dɔ̃ɔ ɡurɑtii kɑ kɑɑto donnuɡinu kɑ kɑɑto ni nu tie kɑ ɡbɛ̃ɛ ni bɑ rɑ kɑ yɛm yɛ̃ke, kpɑ bu ye ɡɔni dɑmɡii wukiri. Yen biru, kpɑ bu yen nɛnutii wɑsi. ");
INSERT INTO bba_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","Aroni kɑ win bibu bɑ̀ n dendi yɑ̃ɑ ni kpuro wukiri bɑ kpɑ, Kehɑtin bweserɑ tɑ koo nɑ tu nu suɑ tu sɔbe. Adɑmɑ tu ku rɑɑ dendi yɑ̃ɑ nin tii bɑbɑ bɑ̀ kun nu bekuru wukiri kpɑ tu ku rɑɑ ɡbi. Isirelibɑ bɑ̀ n seewɑ bɑ swɑɑ wɔri, Kehɑtin bwese terɑ tɑ ko n dɑ sɑ̃ɑ yɑ̃ɑ ni sɔbe. ");
INSERT INTO bba_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","Eleɑsɑɑ, Aroni yɑ̃ku kowon biiwɑ u ko n dɑ mɑɑ dɑbu ɡen ɡum ɡɑri yɛ̃, kɑ sere turɑre nubu duroruɡiɑ ye, kɑ bururu kɑ yokɑn yɑ̃ku te bɑ rɑ ko tɔ̃ɔ bɑɑtere kɑ ɡum mɛ bɑ rɑ ɡɑ̃ɑnu tɑ̃re bu kɑ nu ɡɔsi bu yi nɛnɛm nɛ, Yinni Gusunɔn sɔ̃. Wiyɑ u koo nɛ, Yinni Gusunɔn kuu te nɔni doke kɑ ye yɑ wɑ̃ɑ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Yinni Gusunɔ u mɑɑ Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","19","i de i Kehɑtin bweseru nɔni doke kpɑ tu ku rɑɑ ɡbi tɑ̀ n sɑ̃ɑ yɑ̃ɑ nin sɔmburu mɔ̀. Wee mɛ kɑɑ ko. Wunɛ Aroni kɑ wunɛn bibu, i ko i kɑ bɑɑwure dɑwɑ win ɑyerɔ kpɑ i nùn sɔ̃ɔsi yɑ̃ɑ nìn sɔmburu u koo ko. ");
INSERT INTO bba_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Bu ku rɑɑ du mi, bu kɑ sɑ̃ɑ yee ten dendi yɑ̃nu kpuro mɛɛri kpɑ nɛ, Yinni Gusunɔ n ku rɑ bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","ɑ Gɛɛsɔnin bwese kɛrɑn tɔmbu ɡɑrio yɛnu kɑ yɛnu. ");
INSERT INTO bba_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Kɑɑ bu ɡɑriwɑ sɑɑ be bɑ wɔ̃ɔ tɛnɑ mɔn di sere n kɑ ɡirɑri be bɑ mɔ wɔ̃ɔ weerɑɑkurɔ, be bɑ koo kpĩ bu ɡesi sɑ̃ɑ yee ten sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","Wee sɔmbu te Gɛɛsɔnin bweseru tɑ koo ko. ");
INSERT INTO bba_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Tɑ ko n dɑ kuu ten bekɑ sɔbewɑ kɑ ten ɡɔni dɑmɡii yi bɑ rɑ wukiri wɔllɔ kɑ sere ten kɔnnɔn beku kɑre te, ");
INSERT INTO bba_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","kɑ ten yɑɑrɑn bekɑ kɑ yen kɔnnɔn beku kɑreru kɑ ten wɛ̃ɛ kɑ ten sɔm yɑ̃ɑ ni nu tie. Ye kpuron sɔmburɑ bɑ koo ko. ");
INSERT INTO bba_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Gɛɛsɔnin bweseru tɑ̀ n sɔmburu mɔ̀, Aroni kɑ win bibɑ bɑ koo tu nɔni doke, beyɑ bɑ koo tu sɔ̃ yè tɑ koo ko. ");
INSERT INTO bba_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Sɔmɑ ye kpurowɑ Gɛɛsɔnin bweseru tɑ koo ko. Itɑmɑɑ, yɑ̃ku kowo, Aronin biiwɑ u koo bu kpɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Mɛrɑrin bwese kɛrɑn tɔmbu ɡɑrio yɛnu kɑ yɛnu. ");
INSERT INTO bba_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Kɑɑ ben tɔn durɔbu ɡɑriwɑ sɑɑ be bɑ wɔ̃ɔ tɛnɑ mɔn di n kɑ dɑ be bɑ mɔ wɔ̃ɔ weerɑɑkurɔ, be bɑ koo kpĩ bu ɡesi kuu ten sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Wee sɔmbu te bɑ koo bu nɔmu bɛriɑ. Beyɑ bɑ ko n dɑ kuu ten dɑ̃ɑ bɛsi sɔbe kɑ ten dɑ̃ɑ pɔɔsi kɑ ten ɡberebɑ kɑ ten yɔ̃rɑtii, ");
INSERT INTO bba_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","kɑ mɑɑ ten yɑɑrɑn kɑrɑ dɑ̃nu kɑ ten yɔ̃rɑtii kɑ ten kurumbɑ kɑ ten wɛ̃ɛ kɑ sere ten dendi yɑ̃ɑ ni nu tie. Bɑ koo bɑɑwure wɛ̃wɑ ye u koo sɔbe. ");
INSERT INTO bba_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Sɔmɑ yeniwɑ Mɛrɑrin bwese kɛrɑ yɑ ko n dɑ ko kuu te sɔɔ. Itɑmɑɑ yɑ̃ku kowo Aronin biiwɑ u koo bu nɔni doke. ");
INSERT INTO bba_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","49","Mɔwisi kɑ Aroni kɑ Isirelibɑn yɛnu yɛ̃robu bɑ Lefibɑn bwese kɛri yinin tɔmbu ɡɑrɑ, yiyɑ, Kehɑti kɑ Gɛɛsɔni kɑ Mɛrɑri. Bɑ bu ɡɑrɑwɑ yɛnu kɑ yɛnu sɑɑ be bɑ wɔ̃ɔ tɛnɑ mɔn di sere n kɑ dɑ be bɑ mɔ wɔ̃ɔ weerɑɑkurɔ, be bɑ koo kpĩ bu sɔmburu ko kuu te sɔɔ ɡesi nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. Be bɑ ɡɑrɑ Kehɑtin bweseru sɔɔ, ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ yiru kɑ nɑtɑ kɑ wunɔbu kɑ weerɑɑkuru (2.750). Gɛɛsɔnin bweseru sɔɔ mɑɑ, ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ yiru kɑ nɑtɑ kɑ tɛnɑ (2.630). Mɛrɑrin bweseru sɔɔ, ben ɡeerɑ mɑɑ kuɑ tɔmbu nɔrɔbun subɑ itɑ kɑ ɡoobu (3.200). Mɑ Lefibɑ kpuron ɡeerɑ kuɑ tɔmbu nɔrɔbun subɑ nɔɔbɑ itɑ kɑ nɛɛrɑ wunɔbu kɑ wɛnɛ (8.580). Bɑ ben bɑɑwure sɔ̃ɔwɑ ye u koo ko kɑ ye u koo sɔbe nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bu bu yɑro sɑnsɑnin di, be bɑ disi mɔ ɡɔnɑn bɑrɑ disiɡinun sɔ̃, ǹ kun mɛ kentun sɔ̃, ǹ kun mɛ ɡoru ɡɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Yɛ̃ro u sɑ̃ɑwɑ tɔn kurɔ? I ko i nùn yɑrɑwɑ kpɑ u ku rɑɑ sɑnsɑni ye disi doke, yèn suunu sɔɔ nɛ, Yinni Gusunɔ nɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Mɑ Isirelibɑ bɑ Yinni Gusunɔn woodɑ ye mɛm nɔɔwɑ. Mɑ bɑ tɔmbu kpuro yɑrɑ be bɑ disi mɔ mi, nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Yinni Gusunɔ u mɑɑ kpɑm Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, tɔn kurɔwɑ? Aɑ, tɔn durɔwɑ? Ù n win winsim torɑ, Yinni Gusunɔwɑ u torɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Yɛ̃ro u koo win torɑ te tuubɑ kowɑ kpɑ u ɡɑ̃ɑ nìn sɔ̃ u torɑ mi wesiɑ, kpɑ u yen bɔnu nɔɔbun tiɑ sosi. ");
INSERT INTO bba_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Wi bɑ koo ɡɑ̃ɑ ni wesiɑ, ù kun wɑ̃ɑ mɑ uǹ mɑɑ ɡoo mɔ wi bɑ koo nu wɛ̃, Yinni Gusunɔwɑ bɑ koo nu wɛ̃, kpɑ nu ko yɑ̃ku kowoɡinu. U koo mɑɑ yɑ̃ɑ kinɛru wɛ̃ te bɑ koo kɑ nùn win torɑrun yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Yɑ̃kuru bɑɑtere tèn sukum bɑ wĩɑ nɛnɛm Yinni Gusunɔn sɔ̃, tɑ ko n sɑ̃ɑwɑ yɑ̃ku kowoɡiru. ");
INSERT INTO bba_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Kpuro ye bɑ wɛ̃ Yinni Gusunɔn sɔ̃, yɑ kuɑwɑ yɑ̃ku kowoɡiɑ. U koo kpĩ u ye yi nɛnɛm win tiin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","ɑ Isirelibɑ kpuro sɔ̃ɔwɔ ɑ nɛɛ, tɔn kurɔ ɡoo ù n nɑɑnɛ sɑrirun kookoosu mɔ̀, ");
INSERT INTO bba_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","mɑ win durɔ u tɑmɑɑ durɔ ɡoo u kɑ nùn kpunɑ, bɑɑ mɛ ɡɑnu sɑri ni nu nùn sɔ̃ɔsimɔ mɑ u kɑ ɡoo kpunɑ, mɛyɑ uǹ mɑɑ seedɑɡii ɡoo mɔ wi u nùn wɑ u ye mɔ̀, durɔ win tii uǹ mɑɑ kɑ nùn ye mwɛ, ");
INSERT INTO bba_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","sɔrɔkudo uǹ ye kue, ɑdɑmɑ kɑ mɛ, nisinun sɔ̃, uǹ nùn nɑɑnɛ sɑ̃ɑ, mɑ u tɑmɑɑ u sɑkɑrɑru kuɑwɑ kɑm kɑm, ");
INSERT INTO bba_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","bɑɑ ǹ n mɛren nɑ, durɔ wi, u koo kɑ win kurɔ wi dɑwɑ yɑ̃ku kowon mi kɑ ɔɔsun som kilo itɑ. Uǹ ɡum dokemɔ som mɛ sɔɔ. Mɛyɑ uǹ mɑɑ turɑre sɔndimɔ mɛn wɔllɔ. Domi tɑ sɑ̃ɑwɑ yɑ̃kuru te tɑ nisinu yɑɑyɑmɔ. ");
INSERT INTO bba_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","Sɑɑ ye sɔɔ, yɑ̃ku kowo u koo kɑ nùn dɑwɑ sɑ̃ɑ yerɔ Yinni Gusunɔn wuswɑɑɔ, ");
INSERT INTO bba_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","u yɔ̃rɑsiɑ, kpɑ u domɑ nim suɑ wekerun di te bɑ kuɑ kɑ sɔndu, kpɑ u tuɑ sɔkɑ sɑ̃ɑ yerun temɔ u kɑ nim mɛ burinɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","U koo de kurɔ wi, u yɔ̃rɑ Yinni Gusunɔn wuswɑɑɔ kpɑ u nùn win yɑsɑ potɑ, kpɑ u kɛ̃ɛ te sɔndi kurɔ win nɔmɑɔ. Sɑɑ ye sɔɔ, yɑ̃ku kowon tii u ko n nim sosurɑm nɛni mɛ mu kɑ bɔ̃ri nɑɑmɔ, ");
INSERT INTO bba_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","kpɑ u kurɔ wi bɔ̃rusiɑ u nɛɛ, sɑɑ ye ɑ wɑ̃ɑ wunɛn durɔn yɛnuɔ, tɔn durɔ ɡoo ù kun kɑ nun kpunɛ, mɑ ɑǹ tii disi doke, Gusunɔ u ku de ɑ bɔ̃ri wɑ yi nim mɛ, mu koo kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Adɑmɑ mɑ ɑ kɑ durɔ ɡoo kpunɑ, ɑ tii disi kuɑ, ");
INSERT INTO bba_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","Yinni Gusunɔ u nun sɛɛyɑsiɑ, kpɑ u nun wĩroru kpɛ̃ɛ kpɑ wunɛn nukuru tu mɔsi sere bɑ n dɑ nun sie bɑ̀ n tɔmbu bɔ̃rusimɔ. ");
INSERT INTO bba_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Gusunɔ u de nim mɛ mu kɑ bɔ̃ri nɑɑmɔ mi, mu du wunɛn nukurɔ kpɑ wunɛn nuku te, tu mɔsi, kpɑ wunɛn mɑrutuu ɡu ɡberɑ. Sɑɑ ye sɔɔrɑ, kurɔ wi, u koo ɡere u nɛɛ, ɑmi! ");
INSERT INTO bba_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","Yɑ̃ku kowo u koo bɔ̃ri yi yorewɑ tireru sɔɔ kpɑ u yi teɑ kɑ nim sosurɑm mɛ, ");
INSERT INTO bba_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","mɛ mu kɑ bɔ̃ri nɑɑmɔ kpɑ u mu kurɔ wi nɔrusiɑ, kpɑ nim mɛ, mu du win nukurɔ mu nùn kɔ̃sɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Yen biru yɑ̃ku kowo u koo nisinun kɛ̃ɛ te mwɑ kurɔ win nɔmɑn di kpɑ u tu sɔ̃ɔsi beri berikɑ, kpɑ u kɑ sere tu dɑ yɑ̃ku yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Yen biru u koo kɛ̃ɛ ten som nɔm kure teeru suɑ kpɑ u mu dɔ̃ɔ mɛni yɑ̃ku yerɔ kpɑ Yinni Gusunɔ u kurɔ wi yɑɑyɑ. Yen biru kpɑ u kurɔ wi nim sosurɑm mɛ nɔrusiɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Ù n kurɔ wi nim mɛ nɔrusiɑ mɑ u disi mɔ, u kuɑ nɑɑnɛ sɑriruɡii win durɔn mi, nim mɛ, mu koo kɑ nùn bɔ̃ri nɑɑwɑ, kpɑ mu nùn kɔ̃sɑ kuɑ, win nukuru tu mɔsi kpɑ win mɑrutuu ɡu ɡberɑ, kpɑ bɑ n dɑ nùn sie bɑ̀ n tɔmbu bɔ̃rusimɔ. ");
INSERT INTO bba_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Adɑmɑ ù kun disi mɔ, u tii nɛnuɑ dee dee, bɑ koo nùn ɡɑrisiwɑ tɑɑrɛ sɑriruɡii. Sɑɑ ye sɔɔ, u koo bibu wɑ u mɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","Yeniwɑ yɑ sɑ̃ɑ kurɔ kɑ durɔn nisinun woodɑ. Kurɔ ù n win durɔ nɔni wɔ̃kuɑ u sɑkɑrɑru kuɑ, ");
INSERT INTO bba_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ǹ kun mɛ durɔn nisinu nù n seewɑ, ù n win kurɔ tɑɑrɛ weesuɡiɑ wɛ̃ɛmɔ, yɑ̃ku kowo u koo kɑ nùn dɑwɑ Yinni Gusunɔn wuswɑɑɔ, kpɑ u ko mɑm mɑm ye woodɑ ye, yɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Durɔ u ko n sɑ̃ɑ tɑɑrɛ sɑriruɡii. Adɑmɑ kurɔ ù n torɑ u koo ten ɑre wɑ. ");
INSERT INTO bba_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ɡoo ù n tii wunɑ nɛnɛm u kɑ tii Yinni Gusunɔ wɛ̃, ");
INSERT INTO bba_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","yɛ̃ro uǹ koo tɑm ɡɑm nɔ, bɑɑ mɛ bɑ kuɑ kɑ resɛm. Uǹ mɑɑ resɛm bekɑ ǹ kun mɛ ɡbebɑ dimɔ. ");
INSERT INTO bba_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Sɑɑ ye u tii Gusunɔ wɛ̃ mi, uǹ ɡɑ̃ɑnu dimɔ ye bɑ kuɑ kɑ resɛm. ");
INSERT INTO bba_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","Uǹ mɑɑ win seri kɔnimɔ sere win tii wɛ̃ɛbun tɔ̃ɔ te, tu kɑ yibu. U koo win seri deriwɑ yi n kpɛ̃ɑmɔ, kpɑ u n wɑ̃ɑ Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","U ku rɑɑ mɑɑ susi ɡoru ɡɑrun bɔkuɔ u sere tu bɑbɑ, ");
INSERT INTO bba_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","bɑɑ ǹ n win bɑɑn ɡorun nɑ, ǹ kun mɛ win mɛroɡiru, ǹ kun mɛ win wɔnɔ kɑ win mɔɔɡiru, ǹ kun mɛ win sesuɡiru. Domi seri yi u sɔɔwɑ mi, yi sɔ̃ɔsimɔ mɑ u tii Gusunɔ wɛ̃ɛwɑ. ");
INSERT INTO bba_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Win tii wɛ̃ɛbun sɑɑ ye sɔɔ, u ko n wɑ̃ɑwɑ Yinni Gusunɔn sɔmburun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","Wi kɑ ɡoo bɑ̀ n wɑ̃ɑ sɑnnu mɑ yɛ̃ro u ɡu suɑru sɔɔ, mɑ u disi duurɑ, u koo win seri kɔniwɑ sɔ̃ɔ nɔɔbɑ yiruse dɔmɑ te u tii dɛɛrɑsiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Sɔ̃ɔ nɔɔbɑ itɑse, u koo kɑ yɑ̃ku kowo kpɑrukonu yiru nɑɑwɑ, ǹ kun mɛ, totobɛrɛnu yiru, sɑ̃ɑ yerun kɔnnɔwɔ, ");
INSERT INTO bba_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","kpɑ yɑ̃ku kowo u ɡen teu ɡo, u kɑ durɔ win torɑrun suuru bikiɑ kpɑ u kɑ yiruse yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko. Yen biru kpɑ u nùn dɛɛrɑsiɑbun wororu koosi. Yen tɔ̃ɔ te, u dɛɛrɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Kpɑ u mɑɑ wure u tii Yinni Gusunɔ wɛ̃. Sɑɑ yerɑ u koo yɑ̃ɑ kinɛru wɔ̃ɔ tiɑɡiru ɡo u kɑ win torɑru sɔmɛ. Adɑmɑ tɔ̃ɔ ɡbiikii ni u rɑɑ tii wɛ̃ mi, nu kɑm kuɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","Be bɑ tii Gusunɔ wɛ̃n woodɑ wee. Goo ù n tii wunɑ nɛnɛm Yinni Gusunɔn sɔ̃, mɑ u yen tɔ̃ru yibiɑ te u burɑ bɑ koo kɑ nùn dɑwɑ Yinni Gusunɔn sɑ̃ɑ yerun kɔnnɔwɔ. ");
INSERT INTO bba_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Miyɑ u koo kɑ win kɛ̃ru nɑ Yinni Gusunɔn mi. Niyɑ yɑ̃ɑ kinɛru wɔ̃ɔ tiɑɡiru te tɑǹ ɑlebu mɔ, u kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko, kɑ mɑɑ yɑ̃ɑ niru wɔɔ tiɑɡiru te tɑǹ ɑlebu mɔ u kɑ torɑrun yɑ̃kuru ko. Kpɑ u mɑɑ kɑ yɑ̃ɑ kinɛru nɑ te tɑǹ ɑlebu mɔ u kɑ siɑrɑbun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","U koo mɑɑ kɑ pɛ̃ɛ nɑ bireru sɔɔ ye bɑǹ seeyɑtiɑ doke, yen ɡɛɛ yi n kpɑ̃ yèn som bɑ kɑ ɡum burinɑ, yen ɡɛɛ yi kun mɑɑ kpɑ̃ yi bɑ koo ɡum tɛɛni. ");
INSERT INTO bba_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","Yen biru kpɑ yɑ̃ku kowo u kɑ kɛ̃ɛ ni nɑ Yinni Gusunɔn mi, kpɑ u torɑrun yɑ̃kunu ko kɑ sere yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu. ");
INSERT INTO bba_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Kpɑ u mɑɑ siɑrɑbun yɑ̃kunu ko kɑ yɑ̃ɑ kinɛ te, kɑ pɛ̃ɛ ye yɑ wɑ̃ɑ bire te sɔɔ, ye bɑǹ seeyɑtiɑ doke, kɑ som mɛ, kɑ tɑm mɛ. ");
INSERT INTO bba_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Sɑɑ ye sɔɔ, wi u tii wɛ̃ mi, u koo win seri yi kɔniwɑ Yinni Gusunɔn sɑ̃ɑ yerun kɔnnɔwɔ, kpɑ u yi kpɛ̃ɛ mi bɑ siɑrɑbun yɑ̃kurun dɔ̃ɔ sɔ̃ruɑ. ");
INSERT INTO bba_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","Yen biru yɑ̃ku kowo u koo yɑ̃ɑ kinɛ ten nɔmu suɑ te bɑ sɑwɑ mi, kpɑ u pɛ̃ɛ kɑ kirɑ teeru suɑ birerun di, kpɑ u ye kpuro sɔndi durɔ win nɔmuɔ wi bɑ kɔnɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Yen biru yɑ̃ku kowo u koo ye Yinni Gusunɔ sɔ̃ɔsi, kɑ sere yɑɑ yen ɡuro ɡuroru kɑ yen tɑɑ teeru sɑnnu, kpɑ yu ko wi yɑ̃ku kowoɡiɑ. Woro nini kpuron biruwɑ wi u tii Yinni Gusunɔ wɛ̃ mi, u koo den kpĩ u tɑm nɔ. ");
INSERT INTO bba_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","Yerɑ yɑ sɑ̃ɑ be bɑ tii wunɑ nɛnɛm Yinni Gusunɔn sɔ̃n woodɑ. Yɑ̃ku niyɑ bɑ koo mɑɑ ko. Bɑ̀ n mɑɑ dɑm mɔ bu kɑ Yinni Gusunɔ kɛ̃nu ɡɑnu wɛ̃ nini bɑɑsi, bɑ koo kpĩ bu ko. Adɑmɑ bɑɑ ǹ n mɛren nɑ, bɑ koo nùn wɛ̃wɑ ye bɑ nɔɔ mwɛɛru kuɑ nɡe mɛ yen woodɑ yɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","ɑ Aroni kɑ win bii tɔn durɔbu sɔ̃ɔwɔ ɑ nɛɛ, wee nɡe mɛ bɑ ko n dɑ ɡere bɑ̀ n Isirelibɑ domɑru kuɑmmɛ. ");
INSERT INTO bba_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","Bɑ ko n dɑ nɛɛwɑ, Yinni Gusunɔ u bɛɛ domɑru kuɑ, kpɑ u bɛɛ kɔ̃su. ");
INSERT INTO bba_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Yinni Gusunɔ u kɑ bɛɛ nɔnu ɡeu mɛɛri kpɑ u bɛɛ durom kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Gusunɔ u bɛɛ mɛɛrimɑ, kpɑ u bɛɛ bɔri yɛndu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","Yɑ̃ku kowo ù n nɛn yĩsiru sokusinɑ mɛ, sɑnɑm mɛ u Isirelibɑ domɑru kuɑmmɛ, sɑɑ yerɑ kon domɑ te mwɑ. ");
INSERT INTO bba_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Sɑnɑm mɛ Mɔwisi u Yinni Gusunɔn kuu te ɡirɑ u kpɑ, u tu ɡum yɛ̃kɑ, te kɑ ten dendi yɑ̃nu kpuro, tɑ n kɑ sɑ̃ɑ nɛnɛm Yinni Gusunɔn sɔ̃. Kɑ yɑ̃ku yee te kɑ ten dendi yɑ̃nu ye kpurowɑ u ɡum yɛ̃kɑ u wunɑ nɛnɛm Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Yerɑ Isirelibɑn bwese kɛrɑ bɑɑyeren ɡuro ɡuro be bɑ rɑɑ tɔmbu ɡɑrɑ mi, bɑ susimɑ. ");
INSERT INTO bba_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Ben bɑɑwure u kɑ win kɛ̃ru nɑ. Kɛ̃ɛ niyɑ nɛɛ wɔkurɑ yiru kɑ kɛkɛ nɔɔbɑ tiɑ ye nɛɛ ɡɑwe. Bɑ kɛkɛ yi wukiritii kuɑ. Wiruɡibu yiruwɑ bɑ mɛnnɑ bɑ kɛkɛ tiɑ kɑsu bɑ wɛ̃. Mɑ ben bɑɑwure u nɑɑ tiɑ wɛ̃. Mɑ bɑ kɑ ye nɑ Yinni Gusunɔn sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","ɑ ye kpuro mɔɔ nɛn kuu ten sɔmburun sɔ̃, kpɑ ɑ ye Lefibɑ bɔnu kuɑ nɡe mɛ ben bɑɑwuren sɔmburɑ sɑ̃ɑ yu kɑ nùn somi. ");
INSERT INTO bba_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Mɑ Mɔwisi u kɛkɛ be kɑ nɛɛ yi mwɑ mɑ u yi Lefibɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","U Gɛɛsɔnin bwese kɛrɑ kɛkɛ yiru wɛ̃ kɑ nɛɛ nnɛ ben sɔmburun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","U Mɛrɑrin bwese kɛrɑ kɛkɛ nnɛ wɛ̃ kɑ nɛɛ nɔɔbɑ itɑ, ben sɔmburun sɔ̃. N deemɑ Itɑmɑɑ yɑ̃ku kowo Aronin biiwɑ u bu kpɑre. ");
INSERT INTO bba_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Uǹ Kehɑtibɑ yen ɡɑɑ wɛ̃. Domi sɑ̃ɑ yerun dendi yɑ̃nun tiiwɑ be, bɑ rɑ sue ben senɔ. ");
INSERT INTO bba_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Dɔmɑ te bɑ yɑ̃ku yee te ɡum yɛ̃kɑ tɑ n kɑ sɑ̃ɑ nɛnɛm Yinni Gusunɔn sɔ̃, Isirelibɑn bwese kɛrin wiruɡibu bɑ kɑ ben kɛ̃nu nɑ yɑ̃ku yee ten wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ de Isirelibɑn ɡuro ɡuro be, bu nɑ tiɑ tiɑ, ben bɑɑwure u n win kɛ̃ru mɔ u kɑ tu sɔ̃ɔsi yɑ̃ku yee ten sɔ̃, ben bɑɑwure u n win tɔ̃ru mɔ. ");
INSERT INTO bba_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","83","Wee nɡe mɛ bɑ kɑ kɛ̃ɛ ni nɑɑsinɑ. Tɔ̃ɔ ɡbiikiru Nɑsoni, Aminɑdɑbun bii, Yudɑn bweseru sɔɔ, wiyɑ u kɑ wiɡiru nɑ. Tɔ̃ru yiruse Nɛtɑnɛɛli, Suɑrin bii, Isɑkɑrin bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru itɑse Eliɑbu, Helonin bii, Sɑbulonin bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru nnɛse Elisuri, Sedeurin bii, Rubɛnin bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru nɔɔbuse Selumiɛli, Surisɑdɑin bii, Simɛɔn bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru nɔɔbɑ tiɑse Eliɑsɑfu, Dewɛlin bii, Gɑdin bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru nɔɔbɑ yiruse Elisɑmɑ, Amihudun bii, Efɑrɑimun bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru nɔɔbɑ itɑse Gɑmuliɛli, Pedɑsurin bii, Mɑnɑsen bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru nɔɔbɑ nnɛse Abidɑni, Gideonin bii, Bɛnyɑmɛɛn bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru wɔkuruse Akiesɛɛ, Amisɑdɑin bii, Dɑnun bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru wɔkurɑ tiɑse Pɑɡiɛli, Okirɑnin bii, Asɛɛn bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Tɔ̃ru wɔkurɑ yiruse Ahirɑ, Enɑnin bii, Nɛfitɑlin bweseru sɔɔ, u mɑɑ kɑ wiɡiru nɑ. Wee ye ben bɑɑwure u kɑ nɑ. Yerɑ ɡbɛ̃ɛru te bɑ kuɑ kɑ sii ɡeesu, tèn bunum mu sɑ̃ɑ kilo tiɑ kɑ ɡɑrɑmu ɡoobɑ wunɔbu (300), kɑ mɑɑ ɡbɛ̃ɛru ɡɑru te bɑ ko n dɑ kɑ yɛm yɛ̃ke. Bɑ mɑɑ te kuɑwɑ kɑ sii ɡeesu. Ten bunum mu sɑ̃ɑwɑ ɡɑrɑmu nɑtɑ kɑ wunɔbu (700). Bɑ ni kpuron bunum yĩirɑwɑ kɑ sɑ̃ɑ yerun yĩirutiɑ. Mɑ bɑ ɡbɛ̃ɛnu yiru ye sɔɔ, som doke mɛ bɑ burinɑ kɑ ɡum bu kɑ yɑ̃kuru ko. Ben bɑɑwure u kɑ nɔrɑ wurɑɡiɑ nɑ ye bɑ turɑre yibie. Nɔrɑ yen bunum mu sɑ̃ɑ ɡɑrɑmu wunɔbu (100). Bɑ mɑɑ kɑ kɛtɛ kinɛru kɑ yɑ̃ɑ kinɛru kɑ yɑ̃ɑ kpɛndu wɔ̃ɔ tiɑɡiru nɑ. Ye itɑ kpurowɑ bɑ koo kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko, kpɑ bu kɑ boo kinɛru nɑ te bɑ koo kɑ torɑrun yɑ̃kuru ko, kɑ mɑɑ nɑɑ kinɛnu yiru kɑ yɑ̃ɑ kinɛnu nɔɔbu kɑ boo kinɛnu nɔɔbu kɑ yɑ̃ɑ kpɛmminu nɔɔbu wɔ̃ɔ tiɑɡinu ni bɑ koo kɑ siɑrɑbun yɑ̃kunu ko. ");
INSERT INTO bba_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Kɛ̃ɛ ni bɑ kuɑ dɔmɑ te, yɑ̃ku yee ten sɔ̃, ni kpuron ɡeerɑ kuɑwɑ ɡbɛ̃ɛnu wɔkurɑ yiru ni bɑ kuɑ kɑ sii ɡeesu kɑ sere mɑɑ sii ɡeesun ɡbɛ̃ɛnu ɡɑnu wɔkurɑ yiru ni bɑ ko n dɑ kɑ yɛm yɛ̃ke, kɑ mɑɑ nɔri wurɑɡii wɔkurɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Gbɛ̃ɛ nin bɑɑteren bunum mu sɑ̃ɑwɑ kilo tiɑ kɑ ɡɑrɑmu ɡoobɑ wunɔbu (300). Ni bɑ rɑ kɑ mɑɑ yɛm yɛ̃ke mi, nin teerun bunum mɑɑ sɑ̃ɑwɑ ɡɑrɑmu nɑtɑ kɑ wunɔbu (700). Gbɛ̃ɛ ni kpuron bunum mu kuɑwɑ kilo yɛndɑ nnɛ, nɡe mɛ bɑ rɑ yĩire sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Nɔri wurɑɡii yi, yin bɑɑyeren bunum mu sɑ̃ɑwɑ ɡɑrɑmu wunɔbu (100). Mɑ nɔri wɔkurɑ yiru ye kpuron bunum mu kuɑ kilo tiɑ kɑ ɡɑrɑmu ɡoobu (200). Bɑ yin bɑɑyere turɑre yibie ye bɑ koo dɔ̃ɔ doke. ");
INSERT INTO bba_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Yen biru bɑ yɑɑ sɑbenu wɛ̃. Niyɑ nɑɑ kinɛnu wɔkurɑ yiru kɑ yɑ̃ɑ kinɛnu wɔkurɑ yiru kɑ yɑ̃ɑ kpɛmminu wɔ̃ɔ tiɑɡinu wɔkurɑ yiru ni bɑ koo kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu ko kɑ mɑɑ som mɛ bɑ rɑ kɑ yɑ̃ku te ko, kɑ mɑɑ boo kinɛnu wɔkurɑ yiru ni bɑ koo kɑ torɑnun yɑ̃kuru ko, ");
INSERT INTO bba_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","kɑ kɛtɛ kinɛnu yɛndɑ nnɛ, kɑ yɑ̃ɑ kinɛnu wɑtɑ kɑ boo kinɛnu wɑtɑ kɑ yɑ̃ɑ kpɛmminu wɔ̃ɔ tiɑɡinu wɑtɑ. Ni kpurowɑ bɑ koo kɑ siɑrɑbun yɑ̃kunu ko. Kɛ̃ɛ niniwɑ bɑ kuɑ sɑnɑm mɛ bɑ yɑ̃ku yee te ɡum yɛ̃kɑ tɑ n kɑ sɑ̃ɑ nɛnɛm Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Sɑnɑm mɛ Mɔwisi u duɑ Yinni Gusunɔn kuu ten mi, u Yinni Gusunɔn nɔɔ nɔɔmɔ. Nɔɔ ɡe, ɡɑ weewɑ wɔllun kɔ̃sobun weenɑsibu yiru yen bɑɑ sɔɔn di, ye yɑ wɑ̃ɑ woodɑn kpɑkoro ten wukiritiɑn wɔllɔ. Min diyɑ Gusunɔ u kɑ nùn ɡɑri mɔ̀. ");
INSERT INTO bba_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Aroni sɔ̃ɔwɔ ɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","ù n fitilɑnu nɔɔbɑ yiru ye doke dɑbu ɡe sɔɔ, u de nu n yɑm bururɑsie wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Mɑ Aroni u kuɑ mɛ. U nu doke doke dɑbu ɡen wuswɑɑɔ nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Bɑ dɑbu ɡe kuɑwɑ kɑ wurɑ bɔri tiɑ sɑɑ ɡen wɔllun di sere n kɑ dɑ temɔ, kɑ sere burɑ ni bɑ ɡu kuɑ. Mɔwisi u derɑ bɑ ɡu kuɑwɑ nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","ɑ Lefibɑ wunɔ Isirelibɑn suunu sɔɔn di kpɑ ɑ bu dɛɛrɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Wee nɡe mɛ kɑɑ ko ɑ kɑ bu dɛɛrɑsiɑ. Kɑɑ bu nim yɛ̃kɑwɑ mɛ mu koo ben torɑnu wukiri. Kpɑ ɑ de bu ben wɑsin sɑnsu kɔni. Kpɑ bu ben yɑ̃nu teɑ kpɑ bu tii dɛɛrɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Yen biru bɑ koo kɛtɛ kinɛ kpɛmbu suɑ kɑ som mɛ bɑ kɑ ɡum burinɑ kɑ kɛtɛ kinɛ kpɛmbu ɡɑɡu bu kɑ torɑrun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Kpɑ ɑ Isirelibɑ kpuro mɛnnɑ kuu ten kɔnnɔwɔ, kpɑ ɑ de Lefibɑ bu susimɑ ");
INSERT INTO bba_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","nɛ, Yinni Gusunɔn wuswɑɑɔ, kpɑ Isirelibɑ bu ben nɔmɑ sɔndi Lefi ben wiru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Kpɑ Aroni u Lefi be sɔ̃ɔsi beri berikɑ nɛ, Yinni Gusunɔn wuswɑɑɔ nɡe yɑ̃kuru te Isirelibɑ bɑ kɑ nɑ. Sɑɑ ye sɔɔ, bɑ bu wunɑwɑ mi nɛnɛm nɛn sɔmburun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lefibɑ bɑ koo mɑɑ ben nɔmɑ sɔndi kɛtɛ kinɛ nin wiru wɔllɔ. Yen biru kpɑ Aroni u teeru ɡo ben torɑrun suurun sɔ̃ kpɑ u kɑ teeru yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru ko u sere bu dɛɛrɑsiɑbun woronu koosi. ");
INSERT INTO bba_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Kɑɑ de Lefibɑ kpuro bu se bu yɔ̃rɑ Aroni kɑ win bibun wuswɑɑɔ, kpɑ ɑ bu sɔ̃ɔsi beri berikɑ nɡe yɑ̃kuru nɛ, Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Kɑɑ Lefibɑ wunɑwɑ nɛnɛm Isirelibɑn suunu sɔɔn di, kpɑ bɑ n wɑ̃ɑ nɛn sɔmburun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Yenibɑn biru bɑ koo sɔmburu ko nɛn sɑ̃ɑ yerɔ. Kɑɑ bu dɛɛrɑsiɑwɑ kpɑ ɑ bu sɔ̃ɔsi beri berikɑ nɡe yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Domi bɑ mɑn bu wɛ̃wɑ mɑm mɑm bɑ kuɑ Isirelibɑn bii ɡbiikobu kpuron kɔsire. ");
INSERT INTO bba_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ben bii ɡbiikobu kpuro bɑ sɑ̃ɑwɑ nɛɡibu sɑɑ tɔmbun bii ɡbiikobun di n kɑ dɑ yɑɑ sɑbenun binɔ. Nɑ bu wunɑwɑ nɛnɛm bɑ kuɑ nɛɡibu, sɑɑ mìn di nɑ bii ɡbiikobu ɡo Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Nɑ Lefibɑ mwɑ Isirelibɑn bii ɡbiikobun ɑyerɔ. ");
INSERT INTO bba_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Nɑ bu wunɑwɑ nɑ Aroni kɑ win bibu wɛ̃, bu kɑ sɔmburu ko Isirelibɑn sɔ̃ sɑ̃ɑ yerɔ, kpɑ bɑ n sɑ̃ɑ nɡe yɑ̃kuru te Isirelibɑ bɑ wɛ̃ ben torɑnun sɔ̃. Sɑɑ ye sɔɔ, Isireli be, bɑǹ susimɔ nɛn kuu ten bɔkuɔ n sere bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Mɔwisi kɑ Aroni kɑ Isirelibɑ kpuro bɑ kuɑ mɑm mɑm ye Yinni Gusunɔ u ɡeruɑ Lefibɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lefibɑ bɑ tii dɛɛrɑsiɑ bɑ ben yɑ̃nu teɑ, mɑ Aroni u bu sɔ̃ɔsi beri berikɑ nɡe yɑ̃kuru. Mɑ u bu torɑrun suuru kɑ dɛɛrɑsiɑbun woronu koosi. ");
INSERT INTO bba_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Yen biruwɑ Lefi be, bɑ nɑ Yinni Gusunɔn kuu ten mi, bɑ ben sɔmburu toruɑ Aroni kɑ win bibun nɔni biru, nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u ko ben sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","Lefi be bɑ wɔ̃ɔ yɛndɑ nɔɔbu mɔ kɑ be bɑ kere mɛ, beyɑ bɑ koo sɔmburu ko nɛn kuu te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","Be bɑ wɔ̃ɔ weerɑɑkuru turɑ, bɑ koo yɑriwɑ ben sɔmburun di mɑm mɑm. Bɑǹ mɑɑ mɑn sɔmburu kuɑmmɛ. ");
INSERT INTO bba_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Bɑ ko n dɑ ben Lefisibu somi bɑ̀ n sɔmburu mɔ̀. Adɑmɑ ben tii bɑǹ ko n mɑɑ sɔmburu mɔ mi. Nɡe mɛyɑ kɑɑ Lefibɑ kuɑ ben sɔmburun swɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Ye Isirelibɑ bɑ yɑrimɑ Eɡibitin di yen wɔ̃ɔ yirusen suru ɡbiikoo sɔɔ, yerɑ Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ Sinɑin ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","U nɛɛ, Isirelibɑ bɑ ko n dɑ Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru diwɑ sɑɑ ye nɑ yi sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Yerɑ suru winin sɔ̃ɔ wɔkurɑ nnɛsen yokɑ, sɑnɑm mɛ sɔ̃ɔ duɑ. Bɑ koo tu diwɑ nɡe mɛ ten woodɑ yɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Mɑ Mɔwisi u Isirelibɑ sɔ̃ɔwɑ nɡe mɛ bɑ koo kɑ Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru di. ");
INSERT INTO bba_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Mɑ bɑ tɔ̃ɔ te di suru ɡbiikoon sɔ̃ɔ wɔkurɑ nnɛse yen yokɑ sɑnɑm mɛ sɔ̃ɔ duɑ, Sinɑin ɡbɑburu mi, nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ bu ko. ");
INSERT INTO bba_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Yen dɔmɑ te, tɔmbu ɡɑbɑ wɑ̃ɑ be bɑ disi mɔ ɡorun sɔ̃. Bɑǹ kpĩɑ bɑ tɔ̃ɔ bɑkɑ te di. Mɑ bɑ dɑ bɑ Mɔwisi kɑ Aroni deemɑ. ");
INSERT INTO bba_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Bɑ bu sɔ̃ɔwɑ bɑ nɛɛ, wee sɑ disi mɔ ɡorun sɔ̃. Yen sɔ̃, kɑɑ sun yinɑri su kɑ bɛsɛn yɑ̃kuru nɑ Yinni Gusunɔn wuswɑɑɔ tɔ̃ɔ te sɔɔ, nɡe Isireli be bɑ tie? ");
INSERT INTO bba_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Mɑ Mɔwisi u nɛɛ, i yɔ̃ro n bikiɑ ye Yinni Gusunɔ u koo mɑn sɔ̃ bɛɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","ben ɡoo ǹ kun mɛ ben bibun bweseru sɔɔ, ɡoo ù n disi mɔ ɡorun sɔ̃, ǹ kun mɛ u wuu dɑ, kɑ mɛ, u koo Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru diwɑ nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Adɑmɑ bɑ koo tu diwɑ suru yirusen sɔ̃ɔ wɔkurɑ nnɛsen yokɑ sɑnɑm mɛ sɔ̃ɔ duɑ. Kpɑ bu ten yɑɑ tem kɑ pɛ̃ɛ ye bɑǹ seeyɑtiɑ doke kɑ mɑɑ kpee wuru si su sosu. ");
INSERT INTO bba_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Bu ku yen ɡɑɑ deri sere sisiru bururu. Bɑǹ mɑɑ yen kukunu kɔrɑmɔ. Bu de bu yen woodɑ mɛm nɔɔwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Goo ù n dɛɛre mɑ uǹ wuu de, mɑ u kɑ sere yinɑ u Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑ te di, bɑ koo yɛ̃ro yɑrɑwɑ Isirelibɑn sɑnsɑnin di, yèn sɔ̃ u yinɑ u kɑ win yɑ̃kuru nɑ ten sɑɑ sɔɔ. Yɛ̃ro u koo win torɑ ten ɑre mwɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","Sɔɔ ɡoo ù n wɑ̃ɑ bɛɛn suunu sɔɔ, u tɔ̃ɔ bɑkɑ te dimɔ, u koo tu diwɑ nɡe mɛ nɑ ten woodɑ yi. Bɛɛ kɑ sɔbu, woodɑ tiɑ yerɑ nɑ bɛɛ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Dɔmɑ te Mɔwisi u Yinni Gusunɔn kuu te ɡirɑ u kpɑ, ɡuru wii wurorɑ tɑ tu wukiri sɑɑ yokɑ yen di n kɑ ɡirɑri bururɔ. Mɑ tɑ yɑm bururɑsie nɡe dɔ̃ɔ kuu ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Nɡe mɛyɑ tɑ tu wukiri sɑɑ dɔmɑ ten di. Wɔ̃kuru kpɑ tɑ n yɑm buriri. ");
INSERT INTO bba_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Guru wii wuro te, tɑ̀ n seewɑ Yinni Gusunɔn kuu ten wɔllun di, Isirelibɑ bɑ rɑ kuu te wukewɑ bu doonɑ. Kpɑ bu mɑɑ yɔ̃rɑ mi ɡuru wii wuro te, tɑ yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Nɡe mɛyɑ bɑ rɑ kɑ Yinni Gusunɔn ɡere tubu ù n kĩ bu kuu te ɡirɑ, ǹ kun mɛ, ù n kĩ bu tu wukɑ. Guru wii wuro te, tɑ̀ n wɑ̃ɑ kuu ten wɔllɔ, bɑ ku rɑ doonɛ min di. ");
INSERT INTO bba_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Tɑ̀ n yɔ̃rɑ kuu ten wɔllɔ n kɑ tɛ, Isirelibɑ bɑ rɑ Yinni Gusunɔn woodɑ mɛm nɔɔwɛwɑ, bɑ ku rɑ doonɛ min di. ");
INSERT INTO bba_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Tɑ̀ n yɔ̃rɑ sɑɑ fiiko, miyɑ bɑ rɑ ben sɑnsɑni ɡire sɑɑ fiiko. Yen biru kpɑ bu se bu doonɑ Yinni Gusunɔ ù n nɛɛ, bu se bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Gɑsɔ ɡuru wii wuro te, tɑ rɑ yɔ̃re yɑm tem, sɑɑ yokɑn di sere kɑ bururɔ, ǹ kun mɛ sɔ̃ɔ teeru kɑ wɔ̃ku teeru. Adɑmɑ tɑ̀ n seewɑ, Isirelibɑ bɑ rɑ sewɑ bu swɑɑ wɔri. ");
INSERT INTO bba_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Adɑmɑ tɑ̀ n yɔ̃rɑ kuu ten wɔllɔ sɔ̃ɔ yiru ǹ kun mɛ suru tiɑ ǹ kun mɛ wɔ̃ɔ tiɑ Isirelibɑ bɑ ku rɑ kuu te wuke, mɑ n kun mɔ bɑ ɡuru wii wuro te wɑ tɑ seewɑ. ");
INSERT INTO bba_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Bɑ ku rɑ se, bɑ ku rɑ mɑɑ sinɛ, mɑ n kun mɔ Yinni Gusunɔ u bu woodɑ wɛ̃. Bɑ rɑ win woodɑ swĩiwɑ nɡe mɛ u Mɔwisi sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","ɑ de bu kɔbi yiru seku kɑ sii ɡeesu yi bɑ ko n dɑ so bu kɑ tɔmbu mɛnnɑ kpɑ bu bu sɔ̃ bu seewo bu doonɑ sɑnsɑnin di. ");
INSERT INTO bba_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Bɑ̀ n kɔbi yiru ye so sɑnnu, tɔmbu kpurowɑ bɑ koo mɛnnɑ wunɛn mi, Yinni Gusunɔn kuu ten wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Adɑmɑ bɑ̀ n yin tiɑ so, Isirelibɑn wiruɡibu kɑ ben yɛnu yɛ̃robɑ bɑ koo mɛnnɑ wunɛn mi. ");
INSERT INTO bba_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Bɑ̀ n kɔbɑ so bɑ kuuki koosi, be bɑ ben sɑnsɑni ɡire Yinni Gusunɔn kuu ten sɔ̃ɔ yɑri yeru ɡiɑ, berɑ bɑ koo ɡbi bu doonɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Bɑ̀ n mɑɑ wure bɑ so bɑ kuuki koosi, be bɑ ben sɑnsɑni ɡire sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ kpɑ be, bu mɑɑ doonɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Adɑmɑ bɑ̀ n kĩ bu tɔmbu kpuro mɛnnɑ, bɑ koo kɔbɑ sowɑ bɑ kun kuuki kue. ");
INSERT INTO bba_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","Aroni kɑ win bibu, be, be bɑ sɑ̃ɑ yɑ̃ku kowobu, be tɔnɑwɑ bɑ ko n dɑ kɔbi yi so. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ ben bibun bweserɔ. ");
INSERT INTO bba_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Ì n duɑ bɛɛn tem sɔɔ, i tɑbu mɔ̀ kɑ bɛɛn yibɛrɛbɑ i ko i kɔbi yi sowɑ i n kuuki koosimɔ kpɑ nɛ, Yinni Gusunɔ n kɑ bɛɛ yɑɑyɑ n bɛɛ wɔrɑ yibɛrɛ ben nɔmɑn di. ");
INSERT INTO bba_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Ì n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu mɔ̀, ǹ kun mɛ siɑrɑbun yɑ̃kunu tɔ̃ɔ bɑkɑru sɔɔ, ǹ kun mɛ tɔ̃ɔ ni i rɑ di surun tɔ̃ɔ ɡbiikiru sɔɔ, ǹ kun mɛ nuku dobun sɑɑ ɡɑɑ sɔɔ, i ko i n dɑ kɔbi sowɑ. Nɡe mɛyɑ kon kɑ bɛɛ yɑɑyɑ. Nɛnɑ Gusunɔ bɛɛn Yinni. ");
INSERT INTO bba_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Ye Isirelibɑ bɑ yɑrimɑ sɑɑ Eɡibitin di, yen wɔ̃ɔ yirusen suru yirusen sɔ̃ɔ yɛnduse sɔɔrɑ, ɡuru wii wurorɑ seewɑ Yinni Gusunɔn kuu ten wɔllun di. ");
INSERT INTO bba_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Mɑ Isirelibɑ bɑ seewɑ Sinɑin ɡbɑburun di bɑ swɑɑ wɔri nɡe mɛ bɑ woodɑ yi bu kɑ swĩinɑ. Mɑ ɡuru wii wuro te, tɑ dɑ tɑ yɔ̃rɑ Pɑrɑniɔ. ");
INSERT INTO bba_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Dɔmɑ te, ben see ɡbiikibɑ bɑ seewɑ mi, sɑnɑm mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ bu dɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","16","Yudɑbɑn tɑbu kowo wuurɑ tɑ ɡbiɑ tɑ swɑɑ wɔri bɑ ben ɡidi bɔrɑ nɛni. Be bɑ mɑɑ wɑ̃ɑ wuu te sɔɔ, beyɑ Isɑkɑribɑ kɑ Sɑbulonibɑ. Nɑsoni, Aminɑdɑbun biiwɑ u sɑ̃ɑ Yudɑbɑn tɑbu sunɔ. Isɑkɑribɑn tɑbu sunɔwɑ mɑɑ Nɛtɑnɛɛli, Suɑrin bii. Sɑbulonibɑn tɑbu sunɔwɑ mɑɑ Eliɑbu, Helonin bii. ");
INSERT INTO bba_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Bɑ Yinni Gusunɔn kuu te kuruɑ. Mɑ Gɛɛsɔnibɑ kɑ Mɛrɑribɑ be bɑ sɑ̃ɑ Lefin bweseru bɑ ten yɑ̃nu suɑ bɑ kɑ swɑɑ wɔri bɑ Yudɑbɑn tɑbu wuu te swĩi. ");
INSERT INTO bba_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","20","Yen biruwɑ Rubɛnin bwese kɛrɑ kɑ yen tɑbu kowo wuuru, bɑ Lefi be swĩi. Be bɑ mɑɑ wɑ̃ɑ tɑbu wuu te sɔɔ, berɑ Simɛɔbɑ kɑ Gɑdibɑ. Rubɛnibɑn tɑbu sunɔn yĩsirɑ Elisuri, Sedeurin bii. Simɛɔbɑn tɑbu sunɔn yĩsirɑ Selumiɛli, Surisɑdɑin bii. Gɑdibɑn tɑbu sunɔn yĩsirɑ mɑɑ Eliɑsɑfu, Dewɛlin bii. ");
INSERT INTO bba_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Yen biru Kehɑtibɑrɑ bɑ swĩi be, be bɑ sɑ̃ɑrun dendi yɑ̃nu sɔɔwɑ. Lefi be bɑ ɡbiɑ bɑ koo kuu te ɡirɑwɑ Kehɑtibɑ bu sere tunumɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","24","Kehɑtibɑn biru, Efɑrɑimun bwese kɛrɑ yɑ swĩi kɑ yen tɑbu kowo wuunu bɑ ben ɡidi bɔrɑ ɡbiisie. Beyɑ Mɑnɑsebɑ kɑ Bɛnyɑmɛɛbɑ. Efɑrɑimubɑn tɑbu sunɔn yĩsirɑ Elisɑmɑ, Amihudun bii. Mɑnɑsebɑn tɑbu sunɔn yĩsirɑ Gɑmuliɛli, Pedɑsurin bii. Bɛnyɑmɛɛbɑn tɑbu sunɔn yĩsirɑ Abidɑni, Gideonin bii. ");
INSERT INTO bba_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","27","Yen biruwɑ Dɑnun bwese kɛrɑ kɑ yen tɑbu kowo wuunu bɑ bu swĩi bɑ ben ɡidi bɔrɑ nɛni. Beyɑ Asɛɛbɑ kɑ Nɛfitɑlibɑ. Beyɑ bɑ kuɑ tɔn be kpuro kpuron biru kɔre. Dɑnubɑn tɑbu sunɔn yĩsirɑ Akiesɛɛ, Amisɑdɑin bii. Asɛɛbɑn tɑbu sunɔn yĩsirɑ Pɑɡiɛli, Okirɑnin bii. Nɛfitɑlibɑn tɑbu sunɔn yĩsirɑ Ahirɑ, Enɑnin bii. ");
INSERT INTO bba_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Nɡe mɛyɑ Isirelibɑ bɑ swĩinɛ bɑ kɑ swɑɑ wɔri be kɑ ben tɑbu kowobu. ");
INSERT INTO bba_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Mɔwisi u Hobɑbu win kurɔn sesu, Rewɛli Mɑdiɑnin bii sɔ̃ɔwɑ u nɛɛ, sɑ dɔɔwɑ tem mi Yinni Gusunɔ u sun nɔɔ mwɛɛru kuɑ u sun wɛ̃. A nɑ ɑ kɑ sun dɑ, kpɑ su kɑ nun durom mɛ bɔnu ko, mɛ Yinni Gusunɔ u bɛsɛ Isirelibɑ nɔɔ mwɛɛru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Hobɑbu u nùn wisɑ u nɛɛ, nɑǹ kɑ bɛɛ dɔɔ. Kon dɑwɑ nɛn temɔ sere nɛn yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Mɑ Mɔwisi u nùn wisɑ u nɛɛ, ɑ suuru koowo ɑ ku sun deri. Domi ɑ ɡbɑbu te yɛ̃ mi sɑ wɑ̃ɑ mi. A de ɑ sun ɡbiiyɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","À n sun swĩi sɑ ko kɑ nun durom mɛ bɔnu ko, mɛ Yinni Gusunɔ u koo sun kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Mɑ Isirelibɑ bɑ Yinni Gusunɔn ɡuu te deri bɑ sĩɑ sɔ̃ɔ itɑ. Mɑ bɑ kɑ Yinni Gusunɔn woodɑn kpɑkororu ɡbiɑ bu kɑ yɑm kɑsu mi bɑ koo wɛ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Guru wii wuro te, tɑ rɑ n wɑ̃ɑwɑ ben wɔllɔ sɔ̃ɔ sɔɔ bɑ̀ n swɑɑ wɔri. ");
INSERT INTO bba_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Woodɑn kpɑkoro te, tɑ̀ n seewɑ Mɔwisi u rɑ nɛɛwɑ, Yinni, ɑ seewo ɑ yɔ̃rɑ, kpɑ ɑ wunɛn yibɛrɛbɑ yɑrinɑsiɑ. Kpɑ be bɑ mɑɑ nun tusɑ bu duki wunɛn wuswɑɑn di. ");
INSERT INTO bba_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Bɑ̀ n mɑɑ woodɑn kpɑkoro te yi, u rɑ nɛɛwɑ, Yinni Gusunɔ, ɑ wurɑmɑ ɑ n wɑ̃ɑ Isireli dɑbi dɑbi ten suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Sɔ̃ɔ teeru Isirelibɑ bɑ kɑ Yinni Gusunɔ wɔki. Ye u nu nuɑ, yɑǹ nùn dore. Mɑ u kɑ bu mɔru kuɑ, u derɑ dɔ̃ɔ u nɑ u ben sɑnsɑnin bee tiɑ mwɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Yerɑ Isireli be, bɑ Mɔwisi wuri koosi. Mɑ u Yinni Gusunɔ kɑnɑ. Mɑ dɔ̃ɔ wi, u yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Mɑ bɑ yɑm mi yĩsiru kɑ̃ Tɑberɑ, yèn sɔ̃ dɔ̃ɔ u yɑburɑ ben suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Sɔ̃ɔ teeru tɔn tukobu be bɑ Isirelibɑ swĩimɑ ben ɡbɛnubu seewɑ, kɑ sere mɑɑ Isirelibɑn tii bɑ wɔkinu toruɑ bɑ mɔ̀, wɑrɑ u koo sun yɑɑ wɛ̃ su tem. ");
INSERT INTO bba_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Domi sɑ yɑɑye swɛ̃ɛ yi sɑ rɑ rɑɑ wɑ su tem fɑɑrɑ kɑ ɡbɛsɛnu kɑ wĩɑru kɑ ɑyo kɑ ɑlumɑsɑnu kɑ ɑlumɑsɑnu ɡɑnu. ");
INSERT INTO bba_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Wee tɛ̃ sɑ ɡberɑmɔ sɑǹ mɑɑ ɡɑ̃ɑnu wɑɑmɔ sɑ dimɔ mɑ n kun mɔ mɑnnɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mɑnnɑ ye, dĩɑ bim kpikɑ yɑ kɑ weenɛ. ");
INSERT INTO bba_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","9","Wɔ̃kuru Gusunɔ u rɑ dewɑ yu sɑrɑmɑ kɑ kɑkoru kpɑ sisiru bururu tɔmbu bu yɑrimɑ bu ɡurɑ. Bɑ rɑ ye nɑmwɑ, ǹ kun mɛ bu suni soru sɔɔ. Kpɑ bu ye swɛ̃ wekerɔ. Bɑ rɑ mɑɑ kɑ ye kirɑru ko. Mɑnnɑ ye, yɑ rɑ n numɔwɑ nɡe kirɑ te bɑ sɔnwɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Mɔwisi u nuɑ mɑ Isirelibɑ bɑ wɔki yɛnu kɑ yɛnu, bwese kɛrɑ kɑ bwese kɛrɑ. Mɑ Yinni Gusunɔn mɔru seewɑ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Yerɑ Mɔwisin nukurɑ sɑnkirɑ, u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, mbɑn sɔ̃nɑ ɑǹ kɑ mɑn nɔnu ɡeu mɛɛrɑ. Mbɑn sɔ̃nɑ ɑ kɑ mɑn nuki sɑnkumɔ mɛ, ye ɑ kɑ mɑn tɔn be nɔmu bɛriɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Nɛnɑ nɑ tɔn ben ɡurɑ suɑ? Nɛnɑ nɑ bu mɑrɑ? Mbɑn sɔ̃nɑ ɑ mɑn sɔ̃ɔmɔ n bu bɔkio nɡe mɛ bii mɛro u rɑ win bii bɔki, kpɑ n kɑ bu dɑ sere mi ɑ ben bɑɑbɑbɑ nɔɔ mwɛɛru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Mɑnɑ kon yɑɑ wɑ n tɔn beni kpuro wɛ̃. Domi wee bɑ mɑn wuri koosimɔ, bɑ mɔ̀, n bu yɑɑ wɛ̃ɛyɔ bu tem. ");
INSERT INTO bba_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Nɛ turo nɑǹ kpɛ̃ n bu sɔbe. Domi sɔmu ni, nu bunu. ");
INSERT INTO bba_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Nɑ nun kɑnɑmɔ, ɑ̀ n kɑ mɑn nɔnu ɡeu mɛɛrɑ, ye kɑɑ kɑ mɑn deri mɛsum, ɑ mɑn ɡoowo. A ku de nɑ n wɑ̃ɑ nɔni swɑ̃ɑru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ mɑn Isirelibɑn ɡuro ɡurobu wɑtɑ kɑ wɔku te tɑ sɑ̃ɑ wiruɡibu mɛnnɑmɑ. A de bu nɑ nɛn kuu ten mi kɑ wunɛ sɑnnu. ");
INSERT INTO bba_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Miyɑ nɛn tii kon nɑ n ɡɑri ko. Kon Hunde wi u wɑ̃ɑ wunɛ sɔɔn dɑm sukum wunɑ n bu wɛ̃ kpɑ bu wɑ bu nun somi ɑ kɑ tɔn be kpɑrɑ. Kpɑ bɑ kun sɑ̃ɑ wunɛ turon sɔmunu. ");
INSERT INTO bba_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Kɑɑ Isirelibɑ sɔ̃ ɑ nɛɛ, bu tii dɛɛrɑsio siɑn sɔ̃. Bɑ koo yɑɑ tem domi nɑ ben wɔkinu nuɑ ni bɑ mɑn koosimɔ. Bɑ mɔ̀, wɑrɑ u koo bu yɑɑ wɛ̃ bu tem, domi sɑnɑm mɛ bɑ wɑ̃ɑ Eɡibitiɔ bɑ ye kpuro mɔ. Adɑmɑ tɛ̃ nɛ, Yinni Gusunɔ kon bu yɑɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","N ǹ sɔ̃ɔ teeru tɔnɑ bɑ koo ye tem, ǹ kun mɛ, sɔ̃ɔ yiru, ǹ kun mɛ, sɔ̃ɔ nɔɔbu, ǹ kun mɛ sɔ̃ɔ wɔkuru, ǹ kun mɛ, sɔ̃ɔ yɛndu. ");
INSERT INTO bba_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Suru ɡirɑ bɑ koo ye tem sere yu yɑri ben wɛ̃run di, yu bu tusi. Domi bɑ nɛ, Yinni Gusunɔ yinɑ, nɛ wi nɑ wɑ̃ɑ ben suunu sɔɔ. Bɑ mɑn wɔkisi bɑ mɔ̀, mbɑn sɔ̃nɑ bɑ yɑrɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Mɔwisi u Yinni Gusunɔ wisɑ u nɛɛ, tɔn durɔbu nɔrɔbun subɑ nɑtɑwɑ (600.000) Isirelibɑ bɑ sɑ̃ɑ, bèn suunu sɔɔ nɑ wɑ̃ɑ. Yerɑ ɑ nɛɛ, kɑɑ bu yɑɑ wɛ̃ bu tem sere suru ɡirɑ mɑm mɑm? ");
INSERT INTO bba_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Domi wee, bɑɑ sɑ̀ n bɛsɛn yɑ̃ɑnu kɑ kɛtɛbɑ kpuro ɡo, ǹ kun mɛ su nim wɔ̃kun swɛ̃ɛ kpuro mwɛɛri, ye kpuro yɑǹ bu turi. ");
INSERT INTO bba_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Yinni Gusunɔ u Mɔwisi wisɑ u nɛɛ, ɑ tɑmɑɑ nɛ nɔm kpiribuɡiiwɑ? Tɛ̃ kɑɑ wɑ ye nɑ nun sɔ̃ɔwɑ yɑ̀ kun koo koorɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Mɑ Mɔwisi u yɑrɑ u dɑ u Yinni Gusunɔn ɡɑri yi tɔn be sɔ̃ɔwɑ. U Isirelibɑn ɡuro ɡurobu wɑtɑ kɑ wɔkuru mɛnnɑ. Mɑ u derɑ bɑ sinɑ bɑ kɑ kuu te sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Yinni Gusunɔ u sɑrɑmɑ ɡuru wii wuroru sɔɔ. Mɑ u kɑ Mɔwisi ɡɑri kuɑ. Mɑ u Hunde ye u Mɔwisi wɛ̃n dɑm sukum suɑ u ɡuro ɡuro be wɛ̃. Mɑ ɡuro ɡuro be, bɑ sɑ̃ɑru wɔri nɡe Gusunɔn sɔmɔbu, ɑdɑmɑ n ǹ kɑ tɛ. ");
INSERT INTO bba_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Ben yiru ɡɑbu Ɛlidɑdi kɑ Mɛdɑdi bɑ sinɑ ben sɑnsɑniɔ, bɑǹ de Yinni Gusunɔn kuu ten mi. Adɑmɑ kɑ mɛ, Hunde u bu yɔɔwɑ. Mɑ bɑ mɑɑ sɑ̃ɑru mɔ̀ sɑnsɑni mi. ");
INSERT INTO bba_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Yerɑ ɑluwɑɑsi ɡoo u seewɑ u dɑ u ye Mɔwisi sɔ̃ɔwɑ u nɛɛ, wee Ɛlidɑdi kɑ Mɛdɑdi bɑ sɑ̃ɑru mɔ̀ nɡe Gusunɔn sɔmɔbu bɛsɛn sɑnsɑniɔ. ");
INSERT INTO bba_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Yerɑ Yosue Nunin bii, wi u sɑ̃ɑ Mɔwisin sɔm kowo sɑɑ win ɑluwɑɑsi piiburun di, u Mɔwisi sɔ̃ɔwɑ u nɛɛ, nɛn yinni, ɑ bu yinɑrio bu sɑ̃ɑ te ko. ");
INSERT INTO bba_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Mɔwisi u nùn sɔ̃ɔwɑ u nɛɛ, ɑ nisinu mɔ̀wɑ nɛn sɔ̃? Gusunɔ u de win Hunde yu du Isirelibɑ kpuro sɔɔ, kpɑ bu ko win sɔmɔbu. ");
INSERT INTO bba_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Yen biru Mɔwisi kɑ ɡuro ɡuro be, bɑ doonɑ sɑnsɑni yen min di. ");
INSERT INTO bba_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Yerɑ Yinni Gusunɔ u woo seeyɑ sɑɑ nim wɔ̃kun di. Mɑ woo ɡe, ɡɑ kɑ kusunu nɑ nu tɛriɑ sɑnsɑni ye sɔɔ kpuro nɡe sɔ̃ɔ teerun sɑnum sɑkɑ. Kusu ni, nu tem wukiriwɑ ɡɔm soonu yirun sɑkɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Tɔ̃ɔ te, bɑ kusunu ɡurɑwɑ sere kɑ wɔ̃kurɔ. Yen sisiru bɑ mɑɑ ɡurɑ. Be bɑ ɡurɑ fiiko, berɑ bɑ kilo nɔrɔm nɔrɔm subɑ dɑbinu ɡurɑ. Mɑ bɑ kusu ni tɛriɑ bɑ kɑ ben sɑnsɑni sikerenɑ. ");
INSERT INTO bba_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Sɑnɑm mɛ bɑ kusu ni nɔɔ kpɛ̃ɛ, yerɑ Yinni Gusunɔn mɔru seewɑ mɑ u Isirelibɑ nɔni swɑ̃ɑ bɑkɑru kpɛ̃ɛ. ");
INSERT INTO bba_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Mɑ bɑ yɑm mi yĩsiru kɑ̃ kɔdɛn sikiru. Domi miyɑ bɑ bu sikɑ be bɑ binɛ kuɑ too yɑɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Sɑɑ min diyɑ Isirelibɑ bɑ seewɑ bɑ dɑ Hɑserɔtuɔ. Mɑ bɑ yɔ̃rɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Mɔwisi u kurɔ ɡoo suɑ wi u sɑ̃ɑ Etiopiɡii. Yerɑ Mɑriɑmu kɑ Aroni bɑ Mɔwisi wĩimɔ. ");
INSERT INTO bba_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Bɑ nɛɛ, Mɔwisi tɔnɑn min diyɑ Yinni Gusunɔ u rɑ kɑ Isirelibɑ ɡɑri ko? Aɑwo! U rɑ mɑɑ kɑ bu ɡɑri ko sɑɑ bɛsɛn min di. Yerɑ Yinni Gusunɔ u ɡɑri yi nuɑ. ");
INSERT INTO bba_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","N deemɑ Mɔwisi u suuru mɔ too. Goo sɑri wi u nùn suuru kere hɑnduniɑ ye sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Mɑ Yinni Gusunɔ u Mɔwisi kɑ Aroni kɑ Mɑriɑmu sɔ̃ɔwɑ u nɛɛ, bɛɛ kpuro i doo nɛn kuu bekuruɡirɔ. Mɑ bɑ dɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Mɑ Yinni Gusunɔn tii u sɑrɑmɑ ɡuru wii wuro te sɔɔ, u nɑ u yɔ̃rɑ win kuu ten kɔnnɔwɔ. Mɑ u Aroni kɑ Mɑriɑmu sokɑ. Mɑ be yiru ye, bɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","Mɑ u bu sɔ̃ɔwɑ u nɛɛ, i nɛn ɡɑri swɑɑ dɑkio. Nɛn sɔmɔ be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ, kɑ̃siru sɔɔrɑ nɑ rɑ bu tii sɔ̃ɔsi, kpɑ n kɑ bu ɡɑri ko dosu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Adɑmɑ n ǹ mɛ nɑ rɑ kɑ Mɔwisi nɛn sɔm kowo ɡɑri ko. Domi u sɑ̃ɑwɑ nɑɑnɛɡii nɛn tɔmbu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Nɔɔ kɑ nɔɔwɑ nɑ rɑ kɑ nùn ɡɑri ko, n ǹ mɑɑ mɔ kɑ̃siru sɔɔ nɑ rɑ nùn tii sɔ̃ɔsi. U rɑ mɑn wɑwɑ sɑ̃ɑ sɑ̃ɑ nɡe mɛ nɑ sɑ̃ɑ. Ǹ n mɛn nɑ, mbɑn sɔ̃nɑ iǹ bɛrum kue i kɑ nɛn sɔm kowo Mɔwisi wĩi. ");
INSERT INTO bba_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mɑ Yinni Gusunɔ u kɑ bu mɔru kuɑ. Yen biru u doonɑ. ");
INSERT INTO bba_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Yerɑ ɡuru wii wuro te, tɑ doonɑ. Mɑ Gusunɔ u derɑ bɑrɑ disiɡirɑ Mɑriɑmu wɔri u bɑu kpikisu yɑrɑ nɡe wɛ̃su. Mɑ Aroni u Mɑriɑmu mɛɛrɑ u deemɑ bɑrɑ disiɡirɑ tɑ nùn mwɑ. ");
INSERT INTO bba_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Yerɑ Aroni u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ mɑn suuru kuo. A ku de su bɛsɛn torɑrun ɑre wɑ te sɑ kuɑ nɡe ɡɑri bɑkɑsu. ");
INSERT INTO bba_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","A ku de Mɑriɑmu u n sɑ̃ɑ nɡe bii wi bɑ mɑrɑ ɡoru mɑ win wɑsin bee tiɑ yɑ kɔ̃sɑ. ");
INSERT INTO bba_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Yerɑ Mɔwisi u Yinni Gusunɔ nɔɔɡiru sue u nɛɛ, ɑ nùn bɛkio. ");
INSERT INTO bba_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mɑ Yinni Gusunɔ u nɛɛ, Mɑriɑmun tundo ù n nùn yɑ̃ɑtɑm sie wuswɑɑɔ bɑǹ koo nùn kɛnusi ɡinɑ sɔ̃ɔ nɔɔbɑ yiru sekurun sɔ̃? Ǹ n mɛn nɑ, bu nùn yɑro sɑnsɑnin di sɔ̃ɔ nɔɔbɑ yiru, yen biru kpɑ bu kɑ nùn wurɑmɑ yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Mɑ bɑ Mɑriɑmu yɑrɑ sɔ̃ɔ nɔɔbɑ yiru sɑnsɑnin biruɔ. Adɑmɑ Isirelibɑ bɑǹ doonɛ sere ye Mɑriɑmu u wurɑmɑ. ");
INSERT INTO bba_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Yenibɑn biru Isirelibɑ bɑ seewɑ Hɑserɔtun di bɑ dɑ bɑ sinɑ Pɑrɑnin ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","ɑ tɔmbu ɡɔsio bu kɑ Kɑnɑnin tem sɑriɑ mɛɛrim dɑ, mɛ nɑ bɛɛ Isirelibɑ wɛ̃ɛmɔ. Bwese kɛrɑ bɑɑyere sɔɔ, tɔn turowɑ kɑɑ ɡɔsi u dɑ. Yɛ̃ro u ko n sɑ̃ɑwɑ bwese kɛrɑ yen wiruɡii turo. ");
INSERT INTO bba_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Mɑ Mɔwisi u Yinni Gusunɔn ɡere wurɑ. U tɔn be ɡɔsɑ u bu ɡɔrɑ sɑɑ Pɑrɑnin ɡbɑburun di. Be u ɡɔsɑ mi, be kpuro bɑ sɑ̃ɑwɑ Isirelibɑn wiruɡibu. ");
INSERT INTO bba_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Ben yĩsɑ wee. Rubɛnin bweseru sɔɔ, Sɑmuɑ, Sɑkurin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","Simɛɔn bweseru sɔɔ, Sɑfɑti, Horin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","Yudɑn bweseru sɔɔ, Kɑlɛbu, Yɛfunɛn bii. ");
INSERT INTO bba_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","Isɑkɑrin bweseru sɔɔ, Yiɡuɑli, Yosɛfun bii. ");
INSERT INTO bba_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","Efɑrɑimun bweseru sɔɔ, Osee, Nunin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","Bɛnyɑmɛɛn bweseru sɔɔ, Pɑɑti, Rɑfun bii. ");
INSERT INTO bba_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","Sɑbulonin bweseru sɔɔ, Gɑdiɛli, Sodin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","Yosɛfun bweseru sɔɔ, be bɑ sɑ̃ɑ Mɑnɑsen bwese kɛrɑ, Gɑdi, Susin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","Dɑnun bweseru sɔɔ, Amiɛli, Gemɑlin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","Asɛɛn bweseru sɔɔ, Seturi, Mikɑɛlin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","Nɛfitɑlin bweseru sɔɔ, Nɑkɑbi, Fofusin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","Gɑdin bweseru sɔɔ, Gewɛli, Mɑkin bii. ");
INSERT INTO bba_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Tɔn be bɑ siɑ mi, beyɑ Mɔwisi u ɡɔsɑ u ɡɔrɑ bu kɑ tem mɛn sɑriɑ mɛɛrim dɑ. Mɑ u Osee Nunin bii yĩsiru kɑ̃, Yosue. ");
INSERT INTO bba_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Mɔwisi u sere bu ɡɔri u bu sɔ̃ɔwɑ u nɛɛ, i doo Kɑnɑnin temɔ sɑɑ mɛn sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑn di kpɑ i kɑ dɑ ɡuunun berɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Kpɑ i tem mɛn sɑriɑ mɛɛri kpɑ i wɑ mɛn tɔmbu bɑ̀ n dɑm mɔ, bɑ̀ kun mɑɑ dɑm mɔ, bɑ̀ n dɑbi, bɑ̀ kun mɑɑ dɑbi. ");
INSERT INTO bba_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","I ko i mɑɑ mɛɛri tem mɛ, mù n ɡeɑ sɑ̃ɑ, mù kun mɑɑ ɡeɑ sɑ̃ɑ. Kpɑ i mɛɛri mɛn wusu sù n ɡbɑ̃rɑnu mɔ, sù kun mɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Kpɑ i mɑɑ mɛɛri mù n koo dĩɑnu ko, mù kun mɑɑ mɔ̀, mù n dɑ̃nu mɔ, mù kun mɑɑ mɔ. I wɔruɡɔru koowo. Kpɑ i kɑ mɛn dɑ̃ɑ mɑrum wɔmɑ. N deemɑ sɑɑ ye sɔɔrɑ resɛm ɡbiikɑɑ yɑ rɑ ye. ");
INSERT INTO bba_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Yen biruwɑ tɔn be, bɑ seewɑ bɑ tem mɛn sɑriɑ mɛɛrim dɑ sɑɑ ɡbɑburu te bɑ mɔ̀ Sinin di n kɑ dɑ Rehɔbuɔ, Hɑmɑtin swɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Bɑ duɑ tem mɛ sɔɔ sɑɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑn di mɑ bɑ kɑ dɑ sere Heboroniɔ mi Ahimɑni kɑ Sesɑi kɑ Tɑlimɑi, Anɑkin bibun bweserɑ wɑ̃ɑ. Heboroni ye, yɑ Eɡibitin wuu ɡe bɑ mɔ̀ Soɑni tɔkɔru kere kɑ wɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Mɑ bɑ tunumɑ wɔwɑ ye bɑ mɔ̀ Ɛsikoliɔ. Miyɑ bɑ resɛm kɑ̃ɑsɑ burɑ kɑ sere yen swɑɑru. Mɑ bɑ ye sɔɔwɑ be yiru bɑ sɑ̃ɑrusie kɑ dɛkɑ. Bɑ mɑɑ dɑ̃ɑ mɑrum ɡɑm suɑ mɛ bɑ mɔ̀ ɡerenɑdi kɑ fiɡi. ");
INSERT INTO bba_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Bɑ wɔwɑ ye yĩsiru kɑ̃ Ɛsikoli, yèn sɔ̃ miyɑ Isirelibɑ bɑ resɛm swɑɑru burɑ. ");
INSERT INTO bba_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Sɔ̃ɔ weerun biru ɡɔro be, bɑ wurɑmɑ. ");
INSERT INTO bba_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Ye bɑ tunumɑ, bɑ wurɑ Kɑdɛsiɔ, Pɑrɑnin ɡbɑburɔ, mi Mɔwisi kɑ Aroni kɑ Isirelibɑ kpuro bɑ wɑ̃ɑ. Mɑ bɑ ɡeruɑ ye bɑ wɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Bɑ nɛɛ, too, sɑ dɑ tem mi ɑ sun ɡɔrɑ mi. Kɑ ɡem tem mɛ, mu tim kɑ bom kokumɔwɑ. Mɛn dɑ̃ɑ mɑrum ɡɑm wee sɑ kɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Adɑmɑ tɔn be bɑ wɑ̃ɑ mi, bɑ dɑm mɔ. Ben wusu su kpɑ̃ su mɑɑ ɡbɑ̃rɑnu mɔ. Sɑ mɑɑ Anɑkin bibun bweseru wɑ mi, be bɑ rɑ n ɡunu. ");
INSERT INTO bba_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Mɑ Amɑlɛkibɑ bɑ wɑ̃ɑ mɛn sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ. Mɑ Hɛtibɑ kɑ Yebusibɑ kɑ Amɔrebɑ bɑ wɑ̃ɑ ɡuunun berɑ ɡiɑ. Kɑnɑnibɑ bɑ mɑɑ wɑ̃ɑ nim wɔ̃ku ɡe bɑ mɔ̀ Mɛditerɑnɛn bɔkuɔ, kɑ sere Yuudɛnin dɑɑrun ɡoorɔ. ");
INSERT INTO bba_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Yerɑ tɔmbɑ Mɔwisi wɔkisim seewɑ. Mɑ Kɑlɛbu u bu mɑrisiɑ u nɛɛ, su dɑ su tem mɛ mwɑ mu ko bɛsɛɡim. Sɑ ko nɑsɑrɑ wɑ. ");
INSERT INTO bba_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Adɑmɑ tɔn be bɑ kɑ nùn tem mɛ mɛɛrim dɑ mi, bɑ nùn siki bɑ nɛɛ, sɑǹ kpɛ̃ su kɑ tem mɛn tɔmbu sɑnnɑ. Domi bɑ sun dɑm kere. ");
INSERT INTO bba_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Mɑ bɑ seewɑ bɑ tem mɛ nɑnum sosi Isirelibɑn wuswɑɑɔ. Bɑ nɛɛ, tem mi sɑ bɔsu mi, mu rɑ tɔmbu ɡowɑ be bɑ kĩ bu sinɑ mi. Be sɑ wɑ mi kpuro bɑ ɡunuwɑ. ");
INSERT INTO bba_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Sɑ mɑm Anɑkin bibun bweseru wɑ mi, be bɑ sɑ̃ɑ dooɡo bweseru. Ben wuswɑɑɔ sɑ sɑ̃ɑwɑ nɡe twee. Mɛyɑ ben tii bɑ koo sun ɡɑrisi. ");
INSERT INTO bba_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Ye Isirelibɑ bɑ ɡɑri yi nuɑ bɑ kpɑ, yerɑ bɑ nɔɔɡiru suɑ bɑ swĩ wɔ̃ku ɡiriru. ");
INSERT INTO bba_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Mɑ bɑ Mɔwisi kɑ Aroni wɔkisim wɔri bɑ nɛɛ, mbɑn sɔ̃nɑ sɑǹ dɑɑ yɑnde ɡu Eɡibitiɔ, ǹ kun mɛ ɡbɑburu mini. ");
INSERT INTO bba_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mbɑn sɔ̃nɑ Yinni Gusunɔ u kɑ sun nɑ tem mini bu sun ɡo kɑ tɑkobi kpɑ bɛsɛn kurɔbu kɑ bɛsɛn bibu bu ko yibɛrɛbɑɡibu. N burɑm bo su wurɑ Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Mɑ bɑ wesiɑnɑ bɑ nɛɛ, su bɛsɛn tii kpɑro kuɑ, kpɑ su wurɑ Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Ye Mɔwisi kɑ Aroni bɑ nuɑ mɛ, yerɑ bɑ kibɑri bɑ wuswɑɑ tem ɡirɑri Isirelibɑ kpuron wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Yerɑ be sɔɔ, be bɑ tem mɛn sɑriɑ mɛɛrim dɑ mi, Yosue, Nunin bii kɑ Kɑlɛbu, Yɛfunɛn bii bɑ ben tiin yɑ̃nu ɡɛ̃ɛkɑ nuku sɑnkirɑnun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Bɑ ɡeruɑ bɑ nɛɛ, tem mɛ sɑ mɛɛrim dɑ mi, mu wɑ̃ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Tim kɑ bomɑ mu kokumɔ mi. Gusunɔ ù n kɑ sun nɔnu ɡeu mɛɛrɑ, u koo kɑ sun dɑ mi, kpɑ u sun mu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Yen sɔ̃, i ku nùn seesi, kpɑ i ku tɔn ben bɛrum ko. Domi bɑ koo kowɑ nɡe bɛsɛn dĩɑnu. Ben bũnu kun bu kɔ̃sumɔ. Adɑmɑ Yinni Gusunɔ u ko n kɑ sun wɑ̃ɑ. I ku ben bɛrum ko. ");
INSERT INTO bba_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Sɑɑ ye Isirelibɑ bɑ ɡerunɑmɔ bu Kɑlɛbu kɑ Yosue kpenu kɑsuku, sɑɑ yerɑ Yinni Gusunɔn yiiko yɑ sɔ̃ɔsirɑ win kuu ten wɔllɔ Isirelibɑ kpuron wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, sere sɑɑ yerɑ̀ Isirelibɑ bɑ ko n mɑn ɡɛmɑ. Sere sɑɑ yerɑ̀ bɑ koo den mɑn nɑɑnɛ ko, bɑɑ mɛ nɑ mɑɑmɑɑki dɑbinu kuɑ ben suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Kon bu bɑrɑnu kpɛ̃ɛwɑ, kpɑ n bu ɡo. Adɑmɑ wunɛ kon de wunɛn bweseru tu kpɛ̃ɑ tu dɑm ko n kere Isireli be bɑ tie. ");
INSERT INTO bba_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Yerɑ Mɔwisi u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, wunɑ ɑ Isirelibɑ yɑrɑmɑ Eɡibitin di kɑ wunɛn dɑm. Eɡibitiɡibu bɑ̀ n nuɑ ye ɑ Isirelibɑ kuɑ, ");
INSERT INTO bba_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","bɑ koo ye Kɑnɑnibɑ sɔ̃. N deemɑ ben tii bɑ nuɑ mɑ wunɑ ɑ Isirelibɑ kpɑre, ɑ rɑ tii bu sɔ̃ɔsi nɔni kɑ nɔni. Bɑ mɑɑ nuɑ mɑ wunɑ ɑ bu kɔ̃su. Domi ɑ rɑ n bu swɑɑ ɡbiiye sɔ̃ɔ sɔɔ kɑ ɡuru wii wuroru, wɔ̃kuru kpɑ ɑ n wɑ̃ɑ dɔ̃ɔ yɑrɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Wee tɛ̃, ɑ̀ n wunɛn tɔn be kpeerɑsiɑ nɔn teeru, bwese tuku ni nu wunɛn ɡɑri nuɑ, nu koo ɡere nu nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","wunɛ Yinni Gusunɔ ɑǹ dɑm mɔ ɑ kɑ wunɛn tɔn be kpɑrɑ ɑ kɑ dɑ tem mi ɑ bu nɔɔ mwɛɛru kuɑ. Yen sɔ̃nɑ ɑ nɑ ɑ bu ɡo ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Yen sɔ̃ tɛ̃, nɑ nun kɑnɑmɔ ɑ de ɑ wunɛn dɑm bɑkɑm sɔ̃ɔsi nɡe mɛ ɑ ɡeruɑ ɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","ɑ sɑ̃ɑwɑ suuruɡii. Wunɛn durom mu kpɑ̃. A rɑ tɔmbu ben torɑnu suuru kue. A ku rɑ toro deri ɑ kun nùn sɛɛyɑsie. Mɛyɑ ɑ rɑ bɑɑbɑbɑn torɑnun mɔɔru mwɛ ben bibun mi, sere kɑ ben sikɑdominɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Yen sɔ̃, Yinni, ɑ tɔn be, ben torɑnu suuru kuo. A wunɛn wɔnwɔndu yɑɑyo. A yɑɑyo nɡe mɛ ɑ rɑ n bu suuru kuɑmmɛ sɑɑ mìn di ɑ bu yɑrimɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mɑ Yinni Gusunɔ u nɛɛ, kon bu suuru kuɑ nɡe mɛ ɑ kɑnɑ. ");
INSERT INTO bba_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Adɑmɑ sere kɑ nɛn wɑ̃ɑru kɑ sere mɑɑ nɛn yiiko ye yɑ tem kpuro yibɑ, ");
INSERT INTO bba_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","23","Isireli be, bɑǹ duɔ tem mɛ sɔɔ, bu sere mu wɑ, mɛ nɑ bɔ̃ruɑ nɑ nɛɛ, kon ben bɑɑbɑbɑ wɛ̃. Domi bɑ nɛn yiiko ye wɑ kɑ sɔm mɑɑmɑɑkiɡii ni nɑ kuɑ Eɡibitiɔ kɑ ɡbɑburɔ. Bɑ mɑɑ nɛn lɑɑkɑri mɛɛrɑ ɡbɑburɔ nɔn dɑbinu, mɑ bɑǹ nɛn ɡere mɛm nɔɔwɛ, bɑ mɑn ɡɛmɑ. ");
INSERT INTO bba_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Adɑmɑ yèn sɔ̃ Kɑlɛbu, nɛn sɔm kowo uǹ bwisikɑ nɡe be, mɑ u nɛn ɡere swĩi mɑm mɑm, kon de u du tem mɛ sɔɔ, mɛ u berɑm dɑ kpɑ win bibun bweseru tɑ n mu mɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Adɑmɑ Amɑlɛkibɑ kɑ Kɑnɑnibɑrɑ bɑ wɑ̃ɑ tem mi, wɔwɑ sɔɔ. Yen sɔ̃, siɑ i ɡɔsiro i dɑ ɡbɑburɔ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑri ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","nɑ nuɑ Isirelibɑ bɑ mɑn wɔkisimɔ. Sere sɑɑ yerɑ̀ bɑ koo mɑn wɔkisim mɑri. ");
INSERT INTO bba_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","I bu sɔ̃ɔwɔ i nɛɛ, sere kɑ nɛn wɑ̃ɑru kon bu kuɑwɑ nɡe mɛ bɑ ɡerumɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Gbɑburu miniwɑ bɑ koo dɛllɑ bu ɡbi, be, be bɑ ɡesi ɡɑrɑ be bɑ wɔ̃ɔ yɛndu mɔ kɑ be bɑ kere mɛ, bɑ kɑ mɑn wɔkisi. ");
INSERT INTO bba_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Ben ɡoo kun duɔ tem mi, mɛ nɑ bɛɛ nɔɔ mwɛɛru kuɑ, i kɑ sinɑ, mɑ n kun mɔ Kɑlɛbu, Yɛfunɛn bii, kɑ Yosue, Nunin bii. ");
INSERT INTO bba_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Adɑmɑ ben bii be bɑ nɛɛ, bɑ koo ko yibɛrɛbɑn yobu mi, beyɑ kon de bu du tem mɛ sɔɔ, kpɑ bɑ n wɑ̃ɑ mi, mɛ be, bɑ ɡɔburu wɑ mi, ");
INSERT INTO bba_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","kpɑ be, bu dɛllɑ ɡbɑburu mini bu ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ben bii be, bɑ koo sirenɑ wɔ̃ɔ weeru ɡbɑburu mi, ben bɑɑbɑbɑn mɛm nɔɔbu sɑrirun sɔ̃ sere bu kɑ ɡbisuku bu kpe. ");
INSERT INTO bba_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Nɡe mɛ bɑ kuɑ sɔ̃ɔ weeru bɑ kɑ tem mɛn sɑriɑ mɛɛrɑ, nɡe mɛyɑ kon mɑɑ de bu ko wɔ̃ɔ weeru ɡbɑburɔ ben torɑnun sɔ̃. Sɔ̃ɔ wee ten tɔ̃ɔ bɑɑtere tɑ ko n sɑ̃ɑwɑ nɡe wɔ̃ɔ tiɑ. Sɑɑ ye sɔɔrɑ bɑ koo ɡiɑ mɑ ɡɑ̃ɑ ɡirinɑ nɑ̀ kun kɑ bu wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Nɛ, Yinni Gusunɔwɑ nɑ yeni ɡeruɑ. Mɛyɑ kon bu kuɑ domi bɑ mɑn seesi ben nuku kɔ̃surun sɔ̃. Bɑ koo ɡbisukuwɑ ɡbɑburu mi, kpɑ ben ɡonu nu kɑm ko mi. ");
INSERT INTO bba_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Be Mɔwisi u rɑɑ ɡɔsɑ bɑ kɑ tem mɛn sɑriɑ mɛɛrim dɑ, ye bɑ wurɑmɑ bɑ wɔki, mɑ bɑ tem mɛ nɑnum doke, ");
INSERT INTO bba_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","beyɑ Yinni Gusunɔ u so u ɡo, ");
INSERT INTO bba_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","mɑ n kun mɔ Yosue, Nunin bii kɑ Kɑlɛbu, Yɛfunɛn bii. ");
INSERT INTO bba_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Mɑ Mɔwisi u dɑ u Yinni Gusunɔn ɡɑri yi Isirelibɑ kpuro sɔ̃ɔwɑ. Mɑ ben nuki sɑnkirɑ ɡem ɡem. ");
INSERT INTO bba_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Mɑ bɑ seewɑ buru buru yellu bɑ yɔɔwɑ ɡuuru wɔllɔ bɑ mɔ̀, Yinni, bɛsɛ wee sɑ ko dɑ mi ɑ nɛɛ, su dɑ mi. Sɑ torɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Yerɑ Mɔwisi u nɛɛ, mbɑn sɔ̃nɑ i Yinni Gusunɔn woodɑ sɑrɑ kpɑm. Ye i mɔ̀ mi, yɑǹ kɑ bɛɛ ɡɑm dɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","I ku dɑ, domi Yinni Gusunɔ uǹ kɑ bɛɛ wɑ̃ɑ. I ku de bɛɛn yibɛrɛbɑ bu bɛɛ kɑmiɑ. ");
INSERT INTO bba_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amɑlɛkibɑ kɑ Kɑnɑnibɑ bɑ wɑ̃ɑ bɛɛn wuswɑɑɔ. Bɑ koo mɑɑ bɛɛ ɡo kɑ tɑkobi, domi i Yinni Gusunɔ biru kisi. Uǹ ko n mɑɑ wɑ̃ɑ kɑ bɛɛ. ");
INSERT INTO bba_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Kɑ mɛ, bɑ dɑ ɡuuru wɔllu mi. Adɑmɑ bɑǹ kɑ Yinni Gusunɔn woodɑn kpɑkoro te de. Mɛyɑ Mɔwisin tii kun mɑɑ kɑ bu de. ");
INSERT INTO bba_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Sɑɑ ye sɔɔrɑ Amɑlɛkibɑ kɑ Kɑnɑni be bɑ wɑ̃ɑ ɡuurun berɑ mi, bɑ nɑ bɑ Isirelibɑ wɔri. Mɑ bɑ bu ɡo ɡo bɑ kɑ dɑ sere Hɔɔmɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ì n duɑ tem mɛ̀n nɔɔ mwɛɛru nɑ bɛɛ kuɑ sɔɔ, i kɑ sinɑ, ");
INSERT INTO bba_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","mɑ i nɛ, Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑmmɛ, ǹ kun mɛ nɔɔ mwɛɛrun yɑ̃kuru, ǹ kun mɛ kɛ̃ru ɡɑru te i kuɑ kɑ kĩru, ǹ kun mɛ tɔ̃ɔ bɑkɑrun yɑ̃kuru, i ko i tu kowɑ kɑ yɑ̃ɑru, ǹ kun mɛ kɑ kɛtɛ, ǹ kun mɛ kɑ boo, kpɑ yɑ̃ku ten nuburu tu mɑn dore. ");
INSERT INTO bba_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Wi u koo kɑ yɑɑ sɑberu ɡɑru yɑ̃kuru nɑ, u koo som sɔndimɑwɑ kilo itɑ mɛ bɑ burinɑ kɑ ɡum ditiri tiɑ kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Ǹ n mɑɑ yɑ̃ɑrun nɑ bɑ kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀, ǹ kun mɛ siɑrɑbun yɑ̃kuru, bɑ koo tɑm ditiri tiɑ kɑ bɔnu sɔndiwɑ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Ǹ n mɑɑ yɑ̃ɑ kinɛrun nɑ, bɑ kɑ yɑ̃kuru mɔ̀, bɑ koo som sɔndimɑwɑ kilo nɔɔbɑ tiɑ, mɛ bɑ burinɑ kɑ ɡum ditiri yiru, ");
INSERT INTO bba_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","kɑ sere tɑm ditiri yiru. Bɑ̀ n ye kpuro dɔ̃ɔ doke, yen nuburu tɑ koo mɑn dore. ");
INSERT INTO bba_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Ǹ n mɑɑ kɛtɛn nɑ, bɑ kɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru mɔ̀, ǹ kun mɛ siɑrɑbun yɑ̃kuru, ǹ kun mɛ nɔɔ mwɛɛrun yɑ̃kuru, ǹ kun mɛ yɑ̃kuru ɡɑru, ");
INSERT INTO bba_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","bɑ koo som kilo nɔɔbɑ nnɛ mɛ bɑ burinɑ kɑ ɡum ditiri itɑ sɔndiwɑ yɑɑ ye sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","kɑ sere tɑm ditiri itɑ. Sɑɑ ye sɔɔ, bɑ̀ n ye kpuro dɔ̃ɔ doke, yen nuburu tɑ koo mɑn dore. ");
INSERT INTO bba_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Nɡe mɛyɑ bɑ ko n dɑ ko bɑ̀ n kɑ kɛtɛ yɑ̃kuru mɔ̀, ǹ kun mɛ yɑ̃ɑ kinɛru, ǹ kun mɛ yɑ̃ɑ kpɛmbu, ǹ kun mɛ boo kpɛmbu. ");
INSERT INTO bba_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Yɑ̃kuru bɑɑterewɑ i ko i n dɑ kue mɛ, nɡe mɛ ten woodɑ yɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Isireli bɑɑwurewɑ u ko n dɑ ko mɛ, ù n yɑ̃kuru mɔ̀ tèn nuburɑ koo mɑn dore. ");
INSERT INTO bba_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Sɔbu be bɑ wɑ̃ɑ sɑɑ fiiko, ǹ kun mɛ be bɑ tɛ mi, bɑ̀ n yɑ̃kuru mɔ̀ tèn nuburɑ koo nɛ, Yinni Gusunɔ dore, bɑ koo kowɑ nɡe mɛ. ");
INSERT INTO bba_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Woodɑ tiɑ yerɑ bɑɑwure u koo swĩi. Yɑ ko n mɑɑ wɑ̃ɑwɑ sere kɑ bɛɛn bibun bweserɔ. Nɛ, Yinni Gusunɔ, nɑǹ bɛɛ Isirelibɑ kɑ sɔbu wunɑnɑmɔ. ");
INSERT INTO bba_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Woodɑ tiɑ yerɑ i ko i swĩi bɛɛ kpuro. ");
INSERT INTO bba_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","ɑ Isirelibɑ woodɑ yeni sɔ̃ɔwɔ ɑ nɛɛ, sɑnɑm mɛ i ko i du tem mɛ sɔɔ, mi nɑ kɑ bɛɛ dɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","mɑ i dĩɑnu kuɑ i kɑ di i ko i yen sukum suɑwɑ i mɑn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","I ko i som buri kpɑ i mɑn kirɑru kuɑ i kɑ nɑ kpɑ i tu sɔ̃ɔsi beri berikɑ, nɡe mɛ i rɑ kɑ bɛɛn dĩɑ ɡbiikinu nɛ i sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Nɡe mɛyɑ i ko i kɑ mɑn kirɑ ɡbiikiru wɛ̃ te i wɔ̃ɔwɑ. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","23","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, tɛ̃wɑ? Ǹ kun mɛ siɑwɑ? Ì n nɛn woodɑ ɡɑɑ sɑrɑ iǹ kɑ bɑɑru, ye nɑ bɛɛ kɑ bɛɛn bibun bweseru wɛ̃ sɑɑ wunɛn min di, ");
INSERT INTO bba_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","mɑ ɡoo kun torɑ te wɑ, bɛɛ kpurowɑ i ko i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ kɑ nɑɑ kinɛ kpɛmbu tèn nuburɑ koo mɑn dore. Kpɑ i som kɑ tɑm mɛ bɑ rɑ sɔndi mi, doke kɑ sere mɑɑ boo kinɛru, torɑ ten suurun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Yɑ̃ku kowowɑ u koo Isirelibɑ kpuro dɛɛrɑsiɑbun wororu koosi. Kpɑ be kpuro bu ben torɑrun suuru wɑ. Domi bɑ torɑwɑ bɑǹ kɑ bɑɑru, mɑ bɑ kɑ ben yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru nɑ kɑ torɑrun yɑ̃kuru nɛ, Yinni Gusunɔn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Kon bu ben torɑ te suuru kuɑ kɑ mɑɑ sɔɔ be bɑ wɑ̃ɑ ben suunu sɔɔ. Domi bɑ torɑwɑ bɑǹ kɑ bɑɑru. ");
INSERT INTO bba_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","Ǹ n mɑɑ tɔn turon nɑ u torɑ uǹ kɑ bɑɑru, u koo boo niu wɔ̃ɔ tiɑɡuu ɡowɑ win torɑ ten sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Yɑ̃ku kowowɑ u koo nùn dɛɛrɑsiɑbun wororu kuɑ. Ù n tu kuɑ u kpɑ yɛ̃ro u koo suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Isirelibɑ kɑ sɔbu kpuro woodɑ tiɑ yerɑ bɑ ko n mɔ ben ɡoo ù n torɑ uǹ kɑ bɑɑru. ");
INSERT INTO bba_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","Adɑmɑ ben ɡoo ù n yɛ̃ mɑ torɑrɑ u kɑ mɔ̀, u mɑn torɑriwɑ. Bɑ koo nùn yɑrɑwɑ win tɔmbun min di. ");
INSERT INTO bba_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Domi u nɛn ɡɑri ɡɛmɑ, mɑ u nɛn woodɑbɑ sɑrɑ. Bɑ koo nùn yɑrɑwɑ win tɔmbun min di kpɑ u win torɑrun ɑre sɔbe. ");
INSERT INTO bba_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Sɑnɑm mɛ Isirelibɑ bɑ wɑ̃ɑ ɡbɑburɔ bɑ ɡoo mwɑ u dɑ̃ɑ ɡurɑmɔ tɔ̃ɔ wɛ̃rɑruɡiru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Be bɑ nùn wɑ, bɑ kɑ nùn dɑ Mɔwisi kɑ Aronin mi kɑ Isirelibɑ kpuron mi. ");
INSERT INTO bba_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Mɑ bɑ nùn kɛnusi dirɔ ɡinɑ, domi bɑǹ yɛ̃ ye bɑ koo nùn kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, bɑ koo yɛ̃ro yɑrɑwɑ sɑnsɑnin di kpɑ bu nùn kpenu kɑsuku bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Mɑ bɑ nùn yɑrɑ sɑnsɑnin di bɑ kpenu kɑsukɑ bɑ ɡo, nɡe mɛ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bu tii sɑri kuo yi n sɑ̃ɑre ben yɑbenun swɑɑ buɑɔ kpɑ bu yi wɛ̃ɛ ɡɑɑdurɑɡii sɔ̃re. ");
INSERT INTO bba_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Bɑ̀ n sɑri yi wɑ, yi sɑ̃ɑre, bɑ koo nɛn woodɑbɑ yɑɑyɑ bu ye mɛm nɔɔwɑ. Sɑɑ ye, bɑǹ mɑɑ ben tiin ɡɔ̃ru kĩru mɔ̀ bu sere ko nɑɑnɛ sɑriruɡibu, bu dɑ bu bũnu ɡɑsiri. ");
INSERT INTO bba_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Nɡe mɛyɑ bɑ koo kɑ nɛn woodɑbɑ yɑɑyɑ, kpɑ bu kɑ ye mɛm nɔɔwɑ kpɑ bɑ n sɑ̃ɑ nɛnɛm nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Nɛnɑ nɑ sɑ̃ɑ Gusunɔ wi u bu yɑrɑ Eɡibitin di nɑ n kɑ sɑ̃ɑ ben Yinni. ");
INSERT INTO bba_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Kore, Yisehɑrin bii, Kehɑtin debubu, Lefin bweseru sɔɔ, kɑ Dɑtɑni kɑ Abirɑmu, Eliɑbun bibu kɑ Oni, Pelɛtin bii, Rubɛnin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","be kpurowɑ bɑ Mɔwisi seesi, kɑ sere mɑɑ tɔmbu ɡoobu kɑ weerɑɑkuru (250) ɡɑbu be bɑ sɑ̃ɑ Isirelibɑn wiruɡii be bɑ nɑɑnɛ sɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Yerɑ bɑ mɛnnɑ bɑ Mɔwisi kɑ Aroni sokɑ bɑ nɛɛ, yɑ den turɑ mɛ, bɛsɛ Isirelibɑ kpuro sɑ sɑ̃ɑwɑ be Gusunɔ u ɡɔsɑ. U mɑɑ wɑ̃ɑ bɛsɛ kpuron suunu sɔɔ. Mbɑn sɔ̃nɑ i tɑmɑɑ i sun kere, bɛsɛ, Gusunɔn tɔn be sɑ tie. ");
INSERT INTO bba_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Sɑnɑm mɛ Mɔwisi u ɡɑri yi nuɑ, yerɑ u wuswɑɑ tem ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","U Kore kɑ win tɔn be sɔ̃ɔwɑ u nɛɛ, siɑ bururu, Yinni Gusunɔ u koo sun sɔ̃ɔsi wi u sɑ̃ɑ wiɡii kɑ wi u ɡɔsɑ. U koo mɑɑ de yɛ̃ro u nùn susi. ");
INSERT INTO bba_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Tɛ̃, wunɛ Kore kɑ wunɛɡibu, i dɔ̃ɔ ɡurɑtii suo. ");
INSERT INTO bba_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","Siɑ kpɑ i turɑre dɔ̃ɔ doke Yinni Gusunɔn wuswɑɑɔ. Sɑ ko wɑ wi u koo ɡɔsi u n sɑ̃ɑ wiɡii. Aǹ wɑ bɛɛ Lefin bibu i bɑndɑ? ");
INSERT INTO bba_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Mɔwisi u kpɑm Kore sɔ̃ɔwɑ u nɛɛ, i swɑɑ dɑkio bɛɛ Lefibɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Ye Yinni Gusunɔ u bɛɛ ɡɔsɑ Isirelibɑ sɔɔ, i kɑ win sɔmburu ko win kuru sɔɔ, kpɑ i n sɑ̃ɑ win tɔmbun sɔm kowobu, yɑǹ bɛɛ turɑ? ");
INSERT INTO bba_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","U wurɑ wunɛ Kore kɑ wunɛɡibu i nùn susi, yerɑ i mɑɑ yɑ̃ku kowobun sɔmburu kĩ? ");
INSERT INTO bba_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Ǹ n mɛn nɑ, Yinni Gusunɔwɑ i seesimɔ. Domi wɑrɑ rɑ n Aroni i n kɑ sere nùn wɔki. ");
INSERT INTO bba_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Yerɑ Mɔwisi u ɡɔrɑ bu dɑ bu Dɑtɑni kɑ Abirɑmu, Eliɑbun bibu sokumɑ. Adɑmɑ bɑ yinɑ bu nɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Bɑ nɛɛ, wee Mɔwisi u derɑ sɑ tem deri mi tim kɑ bom mu kokumɔ, mɑ u kɑ sun nɑ ɡbɑburu mini u kɑ sun ɡo. Yeni yɑǹ nùn turɑ? Yerɑ u kĩ u mɑɑ sun dɑm dɔre? ");
INSERT INTO bba_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Uǹ kɑ sun nɛ tem mi tim kɑ bom mu kokumɔ. Uǹ mɑɑ sun resɛm ɡbɑɑnu wɛ̃. U tɑmɑɑ u koo sun nɔni wɔ̃kewɑ? U doo, sɑǹ wee. ");
INSERT INTO bba_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Mɑ mɔru yɑ Mɔwisi mwɑ, u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, ɑ ku ben yɑ̃kuru mwɑ. Nɑǹ bu kɛtɛku mwɑɑrire. Nɑǹ mɑɑ ben ɡoo kɔ̃sɑ kuɑre. ");
INSERT INTO bba_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Mɔwisi u mɑɑ Kore sɔ̃ɔwɑ u nɛɛ, wunɛ kɑ wunɛɡibu i nɑ siɑ Yinni Gusunɔn wuswɑɑɔ, kpɑ Aroni u n wɑ̃ɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Kpɑ bɛɛn bɑɑwure u win dɔ̃ɔ ɡurɑtiɑ suɑ u turɑre dɔ̃ɔ doke Yinni Gusunɔn wuswɑɑɔ. Yi kpuro yi ko n sɑ̃ɑwɑ mi, ɡoobu kɑ weerɑɑkuru (250). Wunɛ kɑ mɑɑ Aroni i ko i n mɑɑ bɛɛɡiɑ nɛni. ");
INSERT INTO bba_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Mɑ ben bɑɑwure u win dɔ̃ɔ ɡurɑtiɑ nɛni u dɔ̃ɔ doke. Mɑ bɑ turɑre doke. Bɑ dɑ bɑ yɔ̃rɑ Yinni Gusunɔn kurun kɔnnɔwɔ kɑ Aroni kɑ sere mɑɑ Mɔwisi. ");
INSERT INTO bba_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Mɑ Kore u Isirelibɑ kpuro mɛnnɑ Mɔwisi kɑ Aronin sɔ̃, kurun kɔnnɔ mi. Yerɑ Yinni Gusunɔn yiikon ɡirimɑ yɑ sɔ̃ɔsirɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mɑ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","i doonɔ tɔn ben min di, domi kon bu ɡowɑ mi tɛ̃n tɛ̃ ɡe. ");
INSERT INTO bba_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Mɑ Mɔwisi kɑ Aroni bɑ wuswɑɑ tem ɡirɑri bɑ nɛɛ, Gusunɔ wunɑ ɑ hunde koni kpuro wɑ̃ɑru wɛ̃. Tɔn turon torɑrun sɔ̃nɑ kɑɑ tɔmbu kpuro ɡo? ");
INSERT INTO bba_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Yinni Gusunɔ u Mɔwisi wisɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","ɑ de tɔn be, bu se Kore kɑ Dɑtɑni kɑ Abirɑmun bɔkun di bu dɑ n tomɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Mɔwisi u seewɑ kɑ Isirelibɑn ɡuro ɡurobu bɑ dɑ bɑ Abirɑmu kɑ Dɑtɑni deemɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Sɑɑ yerɑ u Isirelibɑ sɔ̃ɔwɑ u nɛɛ, i tondo sɑɑ tɔn kɔ̃so ben kunun di. I ku mɑɑ ben ɡɑ̃ɑnu bɑbɑ. Ì n mɑɑ yinɑ i kuɑ mɛ, i ko i ɡbi ben torɑ nin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Mɑ tɔn be kpuro bɑ kɑ Kore kɑ Dɑtɑni kɑ Abirɑmu tondɑ. Mɑ Dɑtɑni kɑ Abirɑmu bɑ yɑrɑ bɑ wɑ̃ɑ ben kunun kɔnnɔwɔ kɑ ben bibu kɑ ben kurɔbu kɑ ben debuminu. ");
INSERT INTO bba_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Mɑ Mɔwisi u nɛɛ, tɛ̃ i ko i ɡiɑ mɑ Gusunɔwɑ u mɑn ɡɔsɑ n kɑ sɔmɑ ye ko ye i wɑɑmɔ nɑ mɔ̀. Nɑǹ ye mɔ̀ kɑ nɛn ɡɔ̃ru kĩru. ");
INSERT INTO bba_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Tɔn be, bɑ̀ n ɡu nɡe mɛ tɔmbu kpuro bɑ rɑ ɡbi, n ǹ Yinni Gusunɔ u mɑn ɡɔsɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Adɑmɑ Yinni Gusunɔ ù n ɡɑ̃ɑ nɑnumɡinu kuɑ, u derɑ tem mu nɔɔ bɑɑrɑ mu bu mwɛ kɑ ye bɑ mɔ kpuro, kpɑ bu dɑ ɡɔribun wɑ̃ɑ yerɔ, sɑɑ yerɑ, i ko i ɡiɑ mɑ tɔn be, bɑ Yinni Gusunɔ ɡɛmɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Sere Mɔwisi u kɑ ɡɑri ɡere u kpe, mɑ mi bɑ yɔ̃ mi, mu bɛsirɑ. ");
INSERT INTO bba_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","Mɑ tem mu nɔɔ bɑɑrɑ mu Kore kɑ win yɛnuɡibu kɑ ben ɑrumɑni kpuro mwɛ, kɑ sere mɑɑ Dɑtɑni kɑ Abirɑmu kɑ ben yɛnuɡibu, kɑ ben ɑrumɑni kpuro. ");
INSERT INTO bba_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Mɑ bɑ duɑ ɡɔribun wɑ̃ɑ yerɔ wɑsiru, kɑ sere ben ye bɑ mɔ kpuro. Mɑ tem mɛ, mu bu wukiri. Nɡe mɛyɑ bɑ kɑ doonɑ Isirelibɑn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Isireli be bɑ wɑ̃ɑ mi, sɑnɑm mɛ bɑ tɔn ben wuri nuɑ, yerɑ bɑ duki yɑkikirɑ. Domi bɛrum bu mwɑ, tem mu ku rɑɑ ben tii mwɛ. ");
INSERT INTO bba_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Mɑ dɔ̃ɔ yɑrɑ yɑ nɑ, yɑ tɔmbu ɡoobu kɑ weerɑɑku (250) te di, te tɑ turɑre dɔ̃ɔ dokemɔ mi. ");
INSERT INTO bba_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","ɑ Eleɑsɑɑ, Aroni yɑ̃ku kowon bii sɔ̃ɔwɔ ɑ nɛɛ, u tɔmbu ɡoobu kɑ weerɑɑku ten dɔ̃ɔ ɡurɑtii yi wunɔ sɑɑ dɔ̃ɔn di. Domi yi sɑ̃ɑwɑ Yinni Gusunɔɡii. Adɑmɑ u yin dɔ̃ɔ yɛ̃ɛ ɡuro u kɑ dɑ u yɑri n tomɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Kpɑ u de bu dɔ̃ɔ ɡurɑtii yi so yi ko fɛrɛ fɛrɛ kpɑ bu kɑ yi yɑ̃ku yeru wukiri. Domi Yinni Gusunɔwɑ bɑ kɑ yi turɑre dɔ̃ɔ dokeɑ, kpɑ ye kpuro yɑ n sɑ̃ɑ yɑɑyɑtiɑ Isirelibɑn mi. ");
INSERT INTO bba_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Mɑ yɑ̃ku kowo Eleɑsɑɑ u dɔ̃ɔ ɡurɑtii yi bɑ kuɑ kɑ sii ɡɑndu mi ɡurɑ, bɑ kɑ yɑ̃ku yerun wukiritii kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Mɑ yɑ kuɑ yɑɑyɑtiɑ Isirelibɑn sɔ̃ ye yɑ bu sɔ̃ɔmɔ mɑ ɡoo kun kpɛ̃ u Yinni Gusunɔ turɑre dɔ̃ɔ dokeɑ, mɑ n kun mɔ be bɑ sɑ̃ɑ Aronin bibun bweseru. Wi u mɑɑ yinɑ u kuɑ mɛ, bɑ koo yɛ̃ro kuɑwɑ nɡe mɛ bɑ Kore kɑ wiɡibu kuɑ. Domi mɛyɑ Yinni Gusunɔ u Aroni sɔ̃ɔwɑ, sɑɑ win sɔm kowo Mɔwisin nɔɔn di. ");
INSERT INTO bba_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Yerɑ sisiru bururu Isirelibɑ kpuro bɑ kɑ Mɔwisi kɑ Aroni wɔki bɑ mɔ̀, wee i derɑ Yinni Gusunɔn tɔmbɑ ɡu. ");
INSERT INTO bba_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Sɑnɑm mɛ tɔn be kpuro bɑ mɛnnɑmɔ bu kɑ Mɔwisi kɑ Aroni seesi, yerɑ bɑ mɛɛrɑ Yinni Gusunɔn kurun berɑ ɡiɑ, mɑ bɑ wɑ ɡuru wii wuroru tɑ tu wukiri. Mɑ Yinni Gusunɔn yiiko yɑ sɔ̃ɔsirɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Mɔwisi kɑ Aroni bɑ dɑ kuu ten mi. ");
INSERT INTO bba_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Mɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","i yɑrio tɔn ben suunu sɔɔn di. Kon bu ɡowɑ nɔni kpɑki teeru. Mɑ Mɔwisi kɑ Aroni bɑ yiirɑ bɑ wuswɑɑ tem ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Mɔwisi u Aroni sɔ̃ɔwɑ u nɛɛ, ɑ dɔ̃ɔ ɡurɑtiɑ ye suo, kpɑ ɑ dɔ̃ɔ suɑ yɑ̃ku yerun di ɑ doke ye sɔɔ, kpɑ ɑ turɑre doke mi, kpɑ ɑ dɑ tɔn ben mi ɡiɑ fuuku ɑ bu dɛɛrɑsiɑbun wororu koosi. Domi Yinni Gusunɔn mɔru yɑ seewɑ. Kɛ̃si kɛ̃si bɑrɑru tɑ toruɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Aroni u dɔ̃ɔ ɡurɑtiɑ ye suɑ nɡe mɛ Mɔwisi u ɡeruɑ. U dɑ tɔn ben mi. Mɑ u deemɑ kɛ̃si kɛ̃si bɑrɑru tɑ toruɑ tɔn ben suunu sɔɔ. Mɑ u turɑre dɔ̃ɔ doke, u bu dɛɛrɑsiɑbun wororu koosi. ");
INSERT INTO bba_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Mɑ u yɔ̃rɑ be bɑ ɡu kɑ be bɑ wɑsin bɑɑ sɔɔ. Mɑ bɑrɑ te, tɑ yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_14","005_17_14","NUM","17","14","14","Tɔmbu nɔrɔbun subɑ wɔkurɑ nnɛ kɑ nɑtɑ kɑ wunɔbuwɑ bɑ ɡu yen dɔmɑ te (14.700), be bɑ ɡu Koren torɑrun sɔ̃ bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU17_15","005_17_15","NUM","17","15","15","Yen biru Aroni u ɡɔsirɑ u dɑ Mɔwisin mi, Yinni Gusunɔn kuu ten kɔnnɔwɔ. Mɑ bɑrɑ te, tɑ yɔ̃rɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_16","005_17_16","NUM","17","16","16","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU17_17","005_17_17","NUM","17","17","17","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, ben bwese kɛrɑ bɑɑyeren wiruɡii u kɑ dɛkɑ tiɑ nɑ, ");
INSERT INTO bba_vpl VALUES ("NU17_18","005_17_18","NUM","17","18","18","kpɑ ɑ ben bɑɑwuren yĩsiru yore win dɛkɑ sɔɔ, kpɑ ɑ Aronin yĩsiru yore Lefin bwese kɛrɑn dɛkɑ sɔɔ. Domi bwese kɛrɑ bɑɑyeren wiruɡii u ko n win dɛkɑ mɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_19","005_17_19","NUM","17","19","19","Yen biru kpɑ ɑ dɛki yi yi nɛn kuu bekuruɡirɔ, mi nɑ rɑ kɑ bɛɛ yinnɛ. ");
INSERT INTO bba_vpl VALUES ("NU17_20","005_17_20","NUM","17","20","20","Wi nɑ ɡɔsɑ, win dɛkɑ yɑ koo kpɑrɑ. Sɑɑ yerɑ kon Isirelibɑ mɑrisiɑ wɔki ni bɑ bɛɛ koosimɔ min sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU17_21","005_17_21","NUM","17","21","21","Mɔwisi u Isirelibɑ kpuro ye sɔ̃ɔwɑ. Mɑ bwese kɛrɑ bɑɑyeren wiruɡii u dɛkɑ tiɑ wɛ̃. Mɑ yi kpuro yi kuɑ dɛki wɔkurɑ yiru. Mɑ Aronin dɛkɑ yɑ wɑ̃ɑ beɡiin suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU17_22","005_17_22","NUM","17","22","22","Mɔwisi u kɑ dɛki yi dɑ Yinni Gusunɔn wuswɑɑɔ kuu bekuruɡiru mi. ");
INSERT INTO bba_vpl VALUES ("NU17_23","005_17_23","NUM","17","23","23","Bururu yɑm sɑ̃reru Mɔwisi u duɑ kuru mi, mɑ u deemɑ Aronin dɛkɑ ye yɑ sɑ̃ɑ Lefibɑn dɛkɑ, yɑ kpɑrɑ yɑ wɛ̃su kuɑ sere yɑ binu mɑrɑ nu ye. ");
INSERT INTO bba_vpl VALUES ("NU17_24","005_17_24","NUM","17","24","24","Mɑ Mɔwisi u dɛki yi ɡurɑ Yinni Gusunɔn wuswɑɑn di, u kɑ dɑ Isirelibɑ kpuron wuswɑɑɔ bu kɑ wɑ kpɑ ben bɑɑwure u win dɛkɑ suɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_25","005_17_25","NUM","17","25","25","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ kɑ Aronin dɛkɑ wuro ɑ yi woodɑn kpɑkoro ten wuswɑɑɔ, yɑ n kɑ sɑ̃ɑ seedɑ Isirelibɑn sɔ̃ be bɑ mɑn seesi. Nɡe mɛyɑ bɑǹ mɑɑ kɑ mɑn wɔkimɔ n sere bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU17_26","005_17_26","NUM","17","26","26","Mɑ Mɔwisi u kuɑ kpuro nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU17_27","005_17_27","NUM","17","27","27","Yerɑ Isirelibɑ bɑ nɑ bɑ Mɔwisi sɔ̃ɔwɑ bɑ nɛɛ, wee, sɑ ɡbimɔ sɑ dɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU17_28","005_17_28","NUM","17","28","28","Wi u ɡesi Yinni Gusunɔn kuu te susi, u rɑ ɡbiwɑ. Mɛyɑ sɑ ko n ɡbimɔ sɑ n dɔɔ? ");
INSERT INTO bba_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Yinni Gusunɔ u Aroni sɔ̃ɔwɑ u nɛɛ, wunɛ kɑ wunɛn bibun bweseru kɑ Lefibɑ kpurowɑ i ko i bɛɛn torɑnun ɑre sɔbe ì n torɑ Yinni Gusunɔn sɑ̃ɑ yerɔ. Adɑmɑ wunɛ kɑ wunɛn bibun bweseru tɔnɑwɑ i ko bɛɛn torɑnun ɑre sɔbe ni i kuɑ yɑ̃ku kobun sɔmburu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Ì n dɑ kuu bekuruɡii ten wuswɑɑɔ, mi woodɑn kpɑkoro te, tɑ wɑ̃ɑ, ɑ de wunɛn tundo bisibu Lefibɑ bu nɑ bu kɑ bɛɛ somi, wunɛ kɑ wunɛn bibu. ");
INSERT INTO bba_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Bɑ ko n dɑ kowɑ ye ɑ bu sɔ̃ɔwɑ kuu ten nɛnubu sɔɔ. Adɑmɑ bɑǹ sɑ̃ɑrun dendi yɑ̃nu ɡɑnu bɑbɑmɔ, ǹ kun mɛ yɑ̃ku yeruɡinu, kpɑ i ku rɑ kɑ ɡbin sɔ̃, wunɛ kɑ be. ");
INSERT INTO bba_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Beyɑ bɑ ko n dɑ bɛɛ somi kpɑ bɑ n dɑ kuu ten sɔmburu ko. Tɔn tuko ɡoo kun susimɔ mi. ");
INSERT INTO bba_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Bɛɛn tii i ko n dɑ sɔmburu kowɑ yɑ̃ku yerɔ kɑ dii te tɑ dɛɛre ɡem ɡem mi. Nɡe mɛyɑ nɛn mɔru kun mɑɑ kɑ seemɔ Isirelibɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Nɑ bɛɛn tundo bisibu Lefibɑ ɡɔsɑ Isirelibɑn suunu sɔɔn di. Bɑ sɑ̃ɑwɑ nɛɡibu, ɑdɑmɑ nɑ bɛɛ bu wɛ̃wɑ bu kɑ kuu ten sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Wunɛ kɑ mɑɑ wunɛn bibu, bɛɛɡiɑ yɑ̃ku kobu yɑ̃ku yerɔ kɑ sere ye yɑ sɑ̃ɑ dii te tɑ dɛɛre ɡem ɡem sɔmɑ. Sɔmbu terɑ i ko i ko. Nɛnɑ nɑ bɛɛ tu wɛ̃ɛmɔ. Tɑ sɑ̃ɑwɑ kɛ̃ɛ ɡeeru. Tɔn tuko ɡoo ù n mɑn susi, kon nùn ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Yinni Gusunɔ u Aroni sɔ̃ɔwɑ u nɛɛ, wee, yɑ̃ku ni Isirelibɑ bɑ kɑ mɑn nɑɑwɑmmɛ kpuro sɔɔ, kon bɛɛ bɛɛn sɑriɑ wɛ̃ wunɛ kɑ wunɛn bibu. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Yɑ̃ku ni bɑ koo mɑn kuɑ, bɑ̀ n kpɑ, nìn sukum kɑɑ n mɔ, ni wee, torɑrun yɑ̃kunu, kɑ yɑ̃ku ni bɑ rɑ kɑ torɑru sɔmɛ, kɑ ɡberun dĩɑnun yɑ̃kunu, kɑ kɛ̃nu. Bɑ̀ n yɑ̃ku ni sɔɔ nɛɡiɑ wĩɑ, sukum mɛ mu tiɑ wunɛ kɑ wunɛn bibɑ i mɛ kpuro mɔ. ");
INSERT INTO bba_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","I ko i dɑ i mu diwɑ yɑm dɛɛrɑmɔ. Wunɛ kɑ wunɛn bii tɔn durɔ bɑɑwurewɑ i ko mu di. I ko mu ɡɑrisiwɑ dĩɑ dɛɛrɑnu. ");
INSERT INTO bba_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","Wee ye yɑ ko n mɑɑ sɑ̃ɑ bɛɛɡiɑ. Yerɑ kɛ̃ɛ ni bɑ kɑ mɑn nɑɑwɑ bɑ sɔ̃ɔsi beri berikɑ. Yɑ ko n sɑ̃ɑwɑ wunɛ kɑ wunɛn bibuɡiɑ. Be bɑ dɛɛre wunɛn yɛnuɔ kpuro, berɑ bɑ koo ye di. ");
INSERT INTO bba_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","Kɑɑ mɑɑ dĩɑ ɡbiikii ni bɑ kɑ mɑn nɑɑwɑn tii suɑ. Gumɑ? Aɑ, ɑlikɑmɑwɑ? Aɑ, tɑm kpɑmɑ? Wunɛ kɑ wunɛn bibɑ i ko n ye mɔ. ");
INSERT INTO bba_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Dĩɑ ɡbiikii ni bɑ kɑ mɑn ɡesi nɑɑwɑ kpuro, nu ko n sɑ̃ɑwɑ wunɛ kɑ wunɛn bibuɡinu. Be bɑ dɛɛre wunɛn yɛnu sɔɔ, berɑ bɑ koo nu di. ");
INSERT INTO bba_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","Gɑ̃ɑ ni bɑ mɑɑ yi nɛn sɔ̃ mɑm mɑm, nu ko n sɑ̃ɑwɑ bɛɛɡinu. ");
INSERT INTO bba_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Bii tɔn durɔ ɡbiikoo kɑ yɑɑ sɑberun buu dɔɔ ɡbiikuu ɡe bɑ koo mɑn wɛ̃, ye kpuro yɑ ko n sɑ̃ɑwɑ wunɛ Aroniɡiɑ. Adɑmɑ kɑɑ dewɑ bɑ n dɑ bii tɔn durɔ ɡbiikoo yɑkie kɑ sere mɑɑ yɑɑ ye bɑ ku rɑ kɑ yɑ̃kuru kon buu. ");
INSERT INTO bba_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Kɑɑ de bu ye yɑkiɑwɑ sɑɑ min di yɑ suru tiɑ mɔ, kɑ sii ɡeesun ɡobi nɔɔbu nɡe mɛ bɑ rɑ yi yĩire sɑ̃ɑ yerɔ. Gobi yin tiɑn bunum mu sɑ̃ɑwɑ ɡɑrɑmu wɔkuru. ");
INSERT INTO bba_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Adɑmɑ ɑǹ kɛtɛ buu dɔɔ ɡbiikuu yɑkiɑmɔ, ǹ kun mɛ yɑ̃ɑ buu, ǹ kun mɛ boo buu. Sɑbe nini kpuro nu sɑ̃ɑwɑ ni bɑ rɑ kɑ yɑ̃kuru ko. Kɑɑ nu ɡowɑ ɑ nin yɛm wisi yɑ̃ku yerɔ kpɑ ɑ nin ɡum dɔ̃ɔ doke kpɑ mɛn nuburu tu nɛ, Yinni Gusunɔ dore. ");
INSERT INTO bba_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Yen yɑɑ kpuro yɑ ko n sɑ̃ɑwɑ bɛɛɡiɑ nɡe mɛ siɑrɑbun yɑ̃kurun yɑɑ tɑɑ nɔm ɡeuɡiru kɑ ten ɡuro ɡuroru nu sɑ̃ɑ bɛɛɡinu. ");
INSERT INTO bba_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Yɑ̃kunu kpuro ni Isirelibɑ bɑ kɑ ɡesi nɑ nɛn mi, bɑ sɔ̃ɔsi beri berikɑ nɑ bɛɛ nu wɛ̃ɛmɔ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ wunɛ kɑ wunɛn bibun bweserun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Yinni Gusunɔ u mɑɑ Aroni sɔ̃ɔwɑ u nɛɛ, ɑǹ tem wɑsi Isirelibɑn suunu sɔɔ. Nɛnɑ kɑɑ n mɔ. Nɛnɑ nɑ sɑ̃ɑ wunɛn ɑrumɑni. ");
INSERT INTO bba_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","Ye Isirelibɑ bɑ wɑ kpuron wɔkuru bɑɑteren wɔllɔ, yen tiɑ ye bɑ rɑ mɑn wɛ̃, Lefibɑrɑ kon ye wɛ̃ ben sɔmbu te bɑ mɔ̀ nɛn sɑ̃ɑ yerɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Isireli be bɑ tie, bɑǹ mɑɑ susimɔ nɛn sɑ̃ɑ yerɔ bu sere tɑɑrɛ wɑ ye yɑ koo de bu ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Lefibɑrɑ bɑ koo sɔmburu ko nɛn sɑ̃ɑ yerɔ, beyɑ bɑ koo mɑɑ ben tiin torɑnu sɔbe ni bɑ koo ko mi. Bɑǹ ko bɑ n tem mɔ Isirelibɑn suunu sɔɔ. Yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ ben bibun bweserɔ. ");
INSERT INTO bba_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Adɑmɑ ye Isirelibɑ bɑ wɑ kpuron wɔkuru bɑɑteren wɔllɔ, yen tiɑ ye bɑ rɑ mɑn wɛ̃, yeyɑ yɑ ko n sɑ̃ɑ beɡiɑ. Yen sɔ̃nɑ nɑ nɛɛ, bɑǹ tem ɡɑm wɑsi nɡe Isireli be bɑ tie. ");
INSERT INTO bba_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","ɑ Lefibɑ sɔ̃ɔwɔ ɑ nɛɛ, Isirelibɑn ye bɑ wɑ kpuron wɔkuru bɑɑtere sɔɔ, yen tiɑ tiɑ ye bɑ rɑ mɑn wɛ̃, Lefi be, bɑ̀ n ye mwɑ yɑ kuɑ beɡiɑ, ben tii bu mɑɑ wɔkuru bɑɑtere sɔɔ tiɑ wunɔ nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Nɡe mɛyɑ ben tii bɑ koo mɑɑ kɑ ben kɛ̃nu nɑ ni nu sɑ̃ɑ nɡe ben ɡberun dĩɑnu, ǹ kun mɛ tɑm. ");
INSERT INTO bba_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Nɡe mɛyɑ bɑ ko n dɑ mɑɑ ye bɑ wɑ Isirelibɑn min di kpuron wɔkuru bɑɑteren wɔllɔ tiɑ wunɛ. Aroniwɑ bɑ ko n dɑ ye wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kɛ̃ɛ ni bɑ ɡesi wɑ kpuro bɑ ko n dɑ Gusunɔɡiɑ wunɛwɑ. Geɑ bɑ koo nùn wunɑ. ");
INSERT INTO bba_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Bɑ̀ n Gusunɔɡiɑ wĩɑ, ye yɑ tie yɑ ko n sɑ̃ɑwɑ beɡiɑ, nɡe mɛ Isireli be bɑ tie bɑ rɑ ben ɑlikɑmɑ ǹ kun mɛ ben tɑm tii yiiye, bɑ̀ n Gusunɔɡiɑ wĩɑ. ");
INSERT INTO bba_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Be kɑ ben yɛnuɡibu bɑ koo kpĩ bu dĩɑ ni di mi bɑ turɑ. Domi nu sɑ̃ɑwɑ ben sɔmburun kɔsiɑru. ");
INSERT INTO bba_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Bɑ̀ n ɡeɑ wunɑ nɛn sɔ̃, mɑ bɑ ye yɑ tie di, bɑǹ Isirelibɑn kɛ̃ɛ ni bɑ mɑn wɛ̃ disi doke, bɑǹ mɑɑ torɑru ɡɑru mɔ mi sɔɔ, bu sere ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Yinni Gusunɔ u Mɔwisi kɑ Aroni sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","i Isirelibɑ sɔ̃ɔwɔ i nɛɛ, wee ye nɛ, Yinni Gusunɔ nɑ ɡeruɑ. Nɑ nɛɛ, bu kɑ nɑɑ niɑ swɑ̃ɑ nɑ ye yɑ kun bɑu mɔ, kpɑ yɑ kun ɑlebu ɡɑɑ mɔ, kpɑ bɑ kun kɑ ye sɔmburu koore. ");
INSERT INTO bba_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Kpɑ bu ye yɑ̃ku kowo Eleɑsɑɑ nɔmu bɛriɑ. U ko de bu kɑ ye dɑwɑ sɑnsɑnin biruɔ kpɑ bu ye sɑkɑ win wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleɑsɑɑ wi, u koo nɑɑ yen yɛm dɛkɑwɑ kɑ win niki biɑ kpɑ u mu yɛ̃kɑ nɔn nɔɔbɑ yiru nɛn kurun kɔnnɔ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Kpɑ u de bu nɑɑ ɡirɑ ye dɔ̃ɔ mɛni win nɔni biru kɑ yen ɡɔnɑ kɑ yen yɛm kɑ yen bisu kpuro. ");
INSERT INTO bba_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Sɑɑ ye sɔɔrɑ u koo sɛdurun dɑ̃ɑ kɑ dɑ̃ɑ kiku ɡe bɑ mɔ̀ isɔpu doke dɔ̃ɔ wi sɔɔ, kɑ wɛ̃ɛ wunɔmɡii kpɑ ye kpuro yu dɔ̃ɔ mwɑɑrɑ kɑ nɑɑ ye sɑnnu. ");
INSERT INTO bba_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Yen biru Eleɑsɑɑ wi, u koo win yɑ̃nu teɑwɑ kpɑ win tii u wobure. Yen biru kpɑ u ɡɔsirɑ u wurɑ sɑnsɑniɔ. Adɑmɑ kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Wi u nɑɑ ye dɔ̃ɔ mɛni, u koo mɑɑ win yɑ̃nu teɑwɑ kpɑ u wobure. Win tii u ko n mɑɑ disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Wi u dɛɛre wiyɑ u koo dɑ u yen torom ɡurɑ kpɑ u mu yi sɑnsɑnin biruɔ mi disi kun wɑ̃ɑ. Miyɑ bɑ koo kɑ mu Isirelibɑ dɛɛrɑsiɑbun nim kuɑ. Nim mɛ, mu ko n sɑ̃ɑwɑ nɡe yɑ̃kuru torɑrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Wi u torom mɛ ɡurɑ, u koo win yɑ̃nu teɑwɑ. Kɑ mɛ, u ko n disi mɔwɑ sere kɑ yokɑɔ. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ Isirelibɑn sɔ̃, kɑ sere mɑɑ sɔɔ be bɑ wɑ̃ɑ ben suunu sɔɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","Wi u tɔn ɡoru bɑbɑ u ko n disi mɔwɑ sere sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Dɛɛrɑsiɑbun nim mɛyɑ bɑ koo nùn yɛ̃kɑ sɔ̃ɔ itɑse kɑ mɑɑ sɔ̃ɔ nɔɔbɑ yiruse, kpɑ u sere dɛɛrɑ. Adɑmɑ ù kun tii dɛɛrɑsie sɔ̃ɔ itɑse kɑ mɑɑ sɔ̃ɔ nɔɔbɑ yiruse te, u ko n disi mɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Wi u tɔn ɡoru bɑbɑ, mɑ uǹ tii dɛɛrɑsie, u nɛn kuru disi dokewɑ mi. Bɑ koo nùn yɑrɑwɑ Isirelibɑn suunu sɔɔn di. Domi bɑǹ nùn dɛɛrɑsiɑbun nim mɛ yɛ̃ke. Yɛ̃ro u ɡinɑ disi mɔwɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","Woodɑ ɡɑɑ wee mɑɑ. Goo ù n ɡu win kurɔ, be bɑ wɑ̃ɑ kuu te sɔɔ, u kɑ ɡu kɑ be bɑ duɑ mi, be kpuro bɑ disi duurɑwɑ mi, sere sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Weke te tɑ mɑɑ wɑ̃ɑ kuru mi, mɑ tɑǹ wukiri, ten tii tɑ disi duurɑwɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Wi u ɡoru bɑbɑ yɑkɑsɔ wi bɑ ɡo kɑ tɑkobi, ǹ kun mɛ wi u ɡɔɔ diro ɡu, kɑ mɑɑ wi u tɔnun kukunu ǹ kun mɛ sikiru bɑbɑ, be kpuro bɑ disi duurɑwɑ mi sere sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","Bu kɑ wi u disi duurɑ dɛɛrɑsiɑ, nɑɑ swɑ̃ɑ yen torom mɛyɑ bɑ koo doke ɡbɛ̃ɛru sɔɔ bu nim ɡem doke. ");
INSERT INTO bba_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Wi u dɛɛre wiyɑ u koo dɑ̃ɑ kiku ɡe bɑ mɔ̀ isɔpu suɑ kpɑ u ɡe wɑsi nim mɛ sɔɔ u kuu te yɛ̃kɑ kɑ sere dendi yɑ̃ɑ ni nu wɑ̃ɑ mi kɑ tɔn be bɑ wɑ̃ɑ mi. Nim mɛyɑ bɑ koo mɑɑ kɑ tɔnu bɑɑwure yɛ̃kɑ wi u tɔn ɡoru ǹ kun mɛ tɔn kukunu ǹ kun mɛ, sikiru bɑbɑ. ");
INSERT INTO bba_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Bɑ koo nùn nim mɛ yɛ̃kɑwɑ sɔ̃ɔ itɑse kɑ sɔ̃ɔ nɔɔbɑ yiruse. Yen biru wi bɑ mu yɛ̃kɑ mi, u koo win yɑ̃nu teɑwɑ kpɑ u wobure. Sɑɑ yokɑ yen diyɑ u dɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Adɑmɑ ɡoo ù n disi mɔ, mɑ bɑǹ nùn dɛɛrɑsiɑbun nim mɛ yɛ̃ke u kɑ dɛɛrɑ, bɑ koo nùn yɑrɑwɑ Isirelibɑn suunu sɔɔn di, yèn sɔ̃ u nɛn kuru disi doke. ");
INSERT INTO bba_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Yeni yɑ ko n sɑ̃ɑwɑ woodɑ sere kɑ bɑɑdommɑɔ Isirelibɑn sɔ̃. Wi u tɔnu dɛɛrɑsiɑbun nim mɛ yɛ̃kɑ, u koo mɑɑ win yɑ̃nu teɑwɑ. Wi u mɑɑ nim mɛ bɑbɑ kpuro u ko n disi mɔwɑ sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Tɔnu wi u disi mɔ, ɡɑ̃ɑ ni u bɑbɑ kpuro nu disi duurɑwɑ mi. Wi u mɑɑ nu bɑbɑ, yɛ̃ron tii u disi duurɑwɑ mi, sere kɑ yokɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Wɔ̃ɔn suru ɡbiikoo sɔɔrɑ Isirelibɑ kpuro bɑ tunumɑ ɡbɑburɔ te bɑ sokumɔ Sini, mɑ bɑ sinɑ Kɑdɛsiɔ. Miyɑ Mɑriɑmu u ɡu, mɑ bɑ nùn sikɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Sɑɑ ye sɔɔrɑ Isirelibɑ bɑ nim biɑ mɑ bɑ Mɔwisi kɑ Aroni seesi. ");
INSERT INTO bba_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Mɑ tɔn be, bɑ kɑ Mɔwisi wɔki bɑ nɛɛ, mbɑn sɔ̃nɑ ɑǹ dere Yinni Gusunɔ u yɑnde sun ɡo sɑnɑm mɛ u bɛsɛɡibu ɡoomɔ. ");
INSERT INTO bba_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Mbɑn sɔ̃nɑ ɑ kɑ bɛsɛ Gusunɔn tɔmbu nɑ ɡbɑburu sɔɔ mini su kɑ ɡbi bɛsɛ kɑ bɛsɛn yɑɑ sɑbenu. ");
INSERT INTO bba_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Mbɑn sɔ̃nɑ ɑ sun yɑrɑmɑ Eɡibitin di mɑ ɑ kɑ sun nɑ yɑm kɔ̃sum mini, mi sɑǹ kpɛ̃ su dĩɑnu ɡɑnu duure. Dɑ̃ɑ ye bɑ mɔ̀ fiɡie sɑri mini, resɛm mɑɑ sɑri, ɡerenɑdi mɑɑ sɑri. Mɛyɑ nim kun mɑm wɑ̃ɑ mɛ sɑ ko nɔ. ");
INSERT INTO bba_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Mɑ Mɔwisi kɑ Aroni bɑ tɔn be deri bɑ dɑ Yinni Gusunɔn kurun kɔnnɔwɔ. Mɑ bɑ yiirɑ bɑ wuswɑɑ tem ɡirɑri. Mɑ Yinni Gusunɔn yiiko yɑ sɔ̃ɔsirɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","ɑ wunɛn dɛkɑ suo kpɑ wunɛ kɑ wunɛn mɔɔ Aroni i Isirelibɑ mɛnnɑ kpɑ i kɑ kpee te ɡɑri ko be kpuron wuswɑɑɔ. Tɑ koo nim yɑrɑ i nɔ bɛɛ kɑ bɛɛn yɑɑ sɑbenu. ");
INSERT INTO bba_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Mɑ Mɔwisi u dɛkɑ ye suɑ ye yɑ wɑ̃ɑ Yinni Gusunɔn sɑ̃ɑ yerɔ nɡe mɛ Yinni Gusunɔn tii u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Mɑ wi kɑ Aroni bɑ Isirelibɑ kpuro sokɑ bɑ dɑ kpee ten mi. Yerɑ Mɔwisi u nɛɛ, i swɑɑ dɑkio i nɔ bɛɛ mɛm nɔɔ sɑribɑ. Kpee tenin min diyɑ sɑ ko de nim mu yɑri? ");
INSERT INTO bba_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Yerɑ Mɔwisi u kpee te so kɑ win dɛkɑ ye, nɔn yiru mɑ nim mu yɑrɑ n kpɑ̃ kpee ten min di. Mɑ tɔn be kpuro kɑ ben yɑɑ sɑbenu bɑ nim mɛ nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, yèn sɔ̃ i mɑn nɑɑnɛ birɑ iǹ mɑn bɛɛrɛ wɛ̃ Isirelibɑn wuswɑɑɔ, yen sɔ̃nɑ nɑǹ derimɔ i kɑ bu du tem mɛ sɔɔ, mɛ nɑ bu nɔɔ mwɛɛru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Gɑri yinin sɔ̃nɑ bɑ rɑ nim mɛ soku Mɛribɑn nim. Yen tubusiɑnɑ sɑnnɔn nim. Domi miyɑ Isirelibɑ bɑ Yinni Gusunɔ wɔkisi mɑ u bu win dɛɛrɑru sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Sɑɑ Kɑdɛsi min diyɑ Mɔwisi u Edɔmun sunɔ ɡɔriɑ bu nùn sɔ̃ nɡe mɛ be Isirelibɑ bɑ wɑhɑlɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","U nɛɛ, yellu, bɛsɛn bɑɑbɑbɑ bɑ dɑ Eɡibitiɔ. Miyɑ bɛsɛn bweserɑ sinɑ n kɑ tɛ. Mɑ Eɡibitiɡibu bɑ sun nɔni sɔ̃ɔwɑ bɛsɛ kɑ bɛsɛn bɑɑbɑ be. ");
INSERT INTO bba_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","Sɑɑ ye sɔɔrɑ sɑ Yinni Gusunɔ nɔɔɡiru sue sɑ nùn somiru kɑnɑ. Mɑ u bɛsɛn nɔɔ nuɑ u win ɡɔrɑdo ɡɔrimɑ u sun yɑrɑ Eɡibitin di. Wee tɛ̃ sɑ wɑ̃ɑ Kɑdɛsi mini wunɛn tem nɔɔ burɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Yen sɔ̃, sɑ nun kɑnɑmɔ ɑ de su wunɛn tem bukiɑnɑ. Sɑǹ kpeeyɔ kɑ bɛɛn ɡbeɑ ɡiɑ, sɑǹ bɛɛn resɛm ɡbɑɑnu duɔ, sɑǹ mɑɑ bɛɛn dɔkɔbɑn nim nɔrumɔ. Swɑɑ bɑkɑ sɑ ko mwɑ sɑǹ ɡɛrɑmɔ ɡɑm sere su kɑ bɛɛn tem sɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Adɑmɑ Edɔmun sinɑ boko wi, u nɛɛ, iǹ nɛn tem bukiɑnɑmɔ. Ì n mɑɑ yinɑ i nɑ, kon kɑ bɛɛ tɑbu ko. ");
INSERT INTO bba_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Mɑ Isirelibɑ bɑ nùn wisɑ bɑ nɛɛ, sɑ ko kpewɑ kɑ swɑɑ bɑkɑ. Bɛsɛ kɑ bɛsɛn yɑɑ sɑbenu sɑ̀ n wunɛn dɔkɔbɑn nim nɔrɑ sɑ ko yen ɡobi kɔsiɑ. A ɡesi de su wunɛn tem bukiɑnɑ su doonɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mɑ Edɔmun sinɑ boko wi, u nɛɛ, nɑǹ wurewɑ i nɛn tem bukiɑnɑ. Yerɑ Edɔmubɑn tɑbu kowobu bɑ seewɑ bɑ dɑ bɑ kɑ Isirelibɑ yinnɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mɑ bɑ yinɑ Isirelibɑ bu ben tem mɛ bukiɑnɑ bu doonɑ. Sɑɑ ye sɔɔrɑ Isirelibɑ bɑ ɡɔsirɑ, bɑ kpɑ ɡɑm ɡiɑn di. ");
INSERT INTO bba_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","23","Isirelibɑ kpuro, bɑ seewɑ Kɑdɛsi min di bɑ dɑ Horin ɡuurɔ, Edɔmun tem nɔɔ burɑ yerɔ. Miyɑ Yinni Gusunɔ u kɑ Mɔwisi kɑ Aroni ɡɑri kuɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","wee Aroni u koo ɡbi. Uǹ duɔ tem mɛ sɔɔ mɛ kon Isirelibɑ wɛ̃ yèn sɔ̃ iǹ nɛn woodɑ mɛm nɔɔwɛ ye nɑ bɛɛ wɛ̃ Mɛribɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Wunɛ Mɔwisi, ɑ Aroni kɑ win bii Eleɑsɑɑ suo ɑ kɑ bu dɑ Horin ɡuu ten wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Kpɑ ɑ Aronin sɑ̃ɑ yɑ̃nu potɑ ɑ nu Eleɑsɑɑ sebusiɑ. Domi miyɑ Aroni u koo ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Mɑ Mɔwisi u kuɑ ye Yinni Gusunɔ u nùn sɔ̃ɔwɑ. Wi kɑ Aroni kɑ Eleɑsɑɑ bɑ yɔɔwɑ ɡuu ten wɔllɔ Isirelibɑ kpuron nɔni biru. ");
INSERT INTO bba_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Ye bɑ turɑ mi, u Aronin sɑ̃ɑ yɑ̃ɑ ni potɑ u nu Eleɑsɑɑ sebusiɑ. Yen biru, Aroni u kpunɑ u ɡu ɡuu ten mi. Mɑ Mɔwisi kɑ Eleɑsɑɑ bɑ sɑrɑmɑ. ");
INSERT INTO bba_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Ye Isirelibɑ bɑ wɑ mɑ Aroni u ɡuwɑ, yerɑ be kpuro bɑ win ɡɔɔ swĩ sɔ̃ɔ tɛnɑ. ");
INSERT INTO bba_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Arɑdin sunɔ Kɑnɑniɡii wi u wɑ̃ɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ u nuɑ mɑ Isirelibɑ bɑ wee kɑ Atɑrimun swɑɑ. Yerɑ u dɑ u bu tɑbu wɔri, mɑ u ben ɡɑbu yoru mwɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Yerɑ Isirelibɑ bɑ Yinni Gusunɔ nɔɔ mwɛɛ teni kuɑ bɑ nɛɛ, Yinni Gusunɔ, ɑ̀ n sun tɔn beni nɔmu bɛriɑ, sɑ ko ben wusu kpeerɑsiɑwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mɑ u Isirelibɑn ɡɑri yi wurɑ u bu Kɑnɑni be nɔmu bɛriɑ. Mɑ bɑ Kɑnɑni be, kɑ ben wusu kpeerɑsiɑ. Yerɑ bɑ yɑm mi yĩsiru kɑ̃ Hɔɔmɑ. Yen tubusiɑnɑ bɑnsu. ");
INSERT INTO bba_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Yenibɑn biru, Isirelibɑ bɑ seewɑ Horin ɡuurun di mɑ bɑ kpɑ kɑ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑrin swɑɑɔ kpɑ bu kɑ Edɔmun tem bɛwɑ. Adɑmɑ bɑ tɛmɑnɑbu kpɑnɑ swɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Mɑ bɑ Yinni Gusunɔ kɑ Mɔwisi wɔkisim wɔri bɑ mɔ̀, mbɑn sɔ̃nɑ i sun yɑrɑmɑ Eɡibitin di. Su kɑ ɡbi ɡbɑburɔ? Domi dĩɑnu kɑ nim sɑri mini. Mɑnnɑ ye wee, yɑ sun tusɑ. Dĩɑ kɑmwɑ. ");
INSERT INTO bba_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Yerɑ Yinni Gusunɔ u bu wɛɛ dɛ̃ɛɡii sure mɑ ben dɑbirɑ ɡu. ");
INSERT INTO bba_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Yerɑ be bɑ tie bɑ nɑ bɑ Mɔwisi sɔ̃ɔwɑ bɑ nɛɛ, wee sɑ torɑ sɑ wunɛ kɑ Gusunɔ wɔkisi. Tɛ̃, ɑ Gusunɔ kɑnɔ u sun wɛɛ yi ɡirɑ yi tondɑ. Mɑ Mɔwisi u kɑnɑru kuɑ tɔn ben sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Yerɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ u nɛɛ, ɑ wɑɑn weenɑsiɑ koowo kpɑ ɑ ye bwɛ̃ dɛkɑn wɔllɔ. Wi wɑɑ yɑ dɔmɑ mɑ u wɑɑn weenɑsiɑ ye mɛɛrɑ, uǹ mɑɑ ɡbimɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Mɑ Mɔwisi u wɑɑ sii ɡɑnduɡiɑ ye kuɑ u ye bwɛ̃ dɛkɑn wɔllɔ. Wi wɑɑ yɑ dɔmɑ kpuro mɑ u wɑɑ sii ɡɑnduɡiɑ ye mɛɛrɑ, u ku rɑ mɑɑ ɡbi. ");
INSERT INTO bba_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Yenibɑn biru, Isirelibɑ bɑ swɑɑ wɔri mɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Obɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Sɑɑ Obɔtun di, bɑ mɑɑ seewɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Iye Abɑrimun ɡbɑburɔ, Mɔɑbun deedeeru, sɔ̃ɔ yɑri yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Sɑɑ min di, bɑ mɑɑ seewɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Serɛdin wɔwɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Sɑɑ Serɛdin di, bɑ mɑɑ dɑ bɑ ben sɑnsɑni ɡirɑ Aɑnɔɔn dɑɑrun ɡuru ɡiɔ, tèn nim mu kokumɔ Amɔrebɑn tem di mu dɔɔ ɡbɑburu ɡiɑ. Domi Aɑnɔɔ yɑ sɑ̃ɑwɑ Mɔɑbu kɑ Amɔrebɑn tem nɔɔ burɑ yeru. ");
INSERT INTO bba_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Yen sɔ̃nɑ Yinni Gusunɔn tɑbun tireru sɔɔ bɑ Fɑhɛbun ɡɑri mɔ̀ ye yɑ wɑ̃ɑ Sufɑn temɔ kɑ yen dɑɑ tori kɑ Aɑnɔɔ ");
INSERT INTO bba_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","kɑ yen dɑɑ tori yi yi wɑ̃ɑ Arin berɑ mɑ yi dɑ yi ɡirɑri Mɔɑbun tem nɔɔ burɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Sɑɑ min di, bɑ dɑ Beriɔ. Beri miyɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ tɔn be mɛnnɔ kpɑ n bu nim wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Yerɑ Isirelibɑ bɑ womu ɡeni kuɑ bɑ nɛɛ, nim, ɑ yɑrimɑ dɔkɔn di kpɑ su tɑki ko. ");
INSERT INTO bba_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Sinɑmbɑ bɑ dɔkɔ ye ɡbɑ. Dɑmɡibɑ bɑ ye ɡbɑ kɑ ben sinɑ dɛki. Yen biruwɑ Isirelibɑ bɑ seewɑ ɡbɑbu ten min di bɑ dɑ Mɑtɑnɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Sɑɑ Mɑtɑnɑn di, bɑ dɑ Nɑhɑliɛliɔ. Sɑɑ Nɑhɑliɛlin di, bɑ dɑ Bɑmɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Sɑɑ Bɑmɔtun di, bɑ mɑɑ dɑ wɔwɑ ɡɑɑn mi, Mɔɑbun temɔ, ɡuu te bɑ mɔ̀ Pisiɡɑn wɔllɔ ɡbɑburun deedeeru. ");
INSERT INTO bba_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Isirelibɑ bɑ Sihoni Amɔrebɑn sinɑ boko sɔmɔbu ɡɔriɑ bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","ɑ de su wunɛn tem bukiɑnɑ. Sɑǹ kpeeyɔ kɑ bɛɛn ɡbeɑ ɡiɑ, sɑǹ bɛɛn resɛm ɡbɑɑnu duɔ, sɑǹ mɑɑ bɛɛn dɔkɔbɑn nim nɔrumɔ. Swɑɑ bɑkɑ sɑ ko mwɑ, sɑǹ ɡɑm ɡɛrɑmɔ sere su kɑ bɛɛn tem yɑri. ");
INSERT INTO bba_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Adɑmɑ Sihoni u yinɑ Isirelibɑ bu kpe sɑɑ win tem di. Yerɑ u win tɑbu kowobu mɛnnɑ bɑ dɑ bɑ Isirelibɑ wɔri Yɑhɑsiɔ ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Mɑ Isirelibɑ bɑ bu ɡo ɡo bɑ ben tem mwɑ sɑɑ dɑɑ te bɑ mɔ̀ Aɑnɔɔn di n kɑ dɑ dɑɑ te bɑ mɔ̀ Yɑbɔkuɔ, sere n kɑ ɡirɑri Amɔnibɑn tem nɔɔ burɑ yerɔ. N deemɑ Amɔni be, bɑ ben tem nɔɔ burɑ yerɔ tem kɔ̃sobu yii. ");
INSERT INTO bba_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Mɑ Isirelibɑ bɑ Amɔrebɑn wusu kpuro mwɛɛrɑ bɑ sinɑ mi kɑ Hɛsiboniɔ kɑ ɡen bɑru kpɑɑnɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Hɛsiboni ye, yɑ sɑ̃ɑwɑ Sihonin tiin wuu. Sihoni wi, u rɑɑ kɑ Mɔɑbubɑ tɑbu kuɑ mɑ u bu tɑbu di sere u Mɔɑbubɑn tem mwɑ u kɑ nɑ sere dɑɑ te bɑ mɔ̀ Aɑnɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Yen sɔ̃nɑ wom kowobu bɑ rɑ mɔndu ko bu nɛɛ, i nɑ i Hɛsiboni bɑni. I nɑ i Sihonin wuu bɑni i ɡu ɡbɑ̃rɑru toosi. ");
INSERT INTO bba_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Domi dɔ̃ɔ u yɑrɑ Hɛsibonin di. Dɔ̃ɔ yɑrɑ yɑ yɑrɑ Sihonin wuun di. Mɑ u wuu ɡe bɑ mɔ̀ Ari Mɔɑbu di kɑ bũu ni nu wɑ̃ɑ Aɑnɔɔn ɡunɡunu wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Mɔɑbu, ɑ kɑm kuɑwɑ! Bɛɛ be i mɑɑ bũu wi bɑ mɔ̀ Kemɔsi sɑ̃ɑmɔ, i kɔ̃ɔrɑwɑ! Domi u derɑ Amɔrebɑn sinɑ boko Sihoni u tɔn durɔbu kɑ tɔn kurɔbu yoru mwɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Adɑmɑ sɑ Amɔrebɑ sɛ̃ɛnu twee. Mɑ Hɛsiboni yɑ wɔrukɑ. Mɑ tem mɛ kpuro mu kɑm kuɑ sere Diboniɔ n kɑ ɡirɑri Nɔfɑɔ, kɑ Mɛdebɑɔ. Sɑ ye kpuro kɑm koosiɑwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Nɡe mɛyɑ Isirelibɑ bɑ kɑ sinɑ Amɔrebɑn tem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Mɑ Mɔwisi u ɡɔrɑ bu dɑ bu Yɑsɛɛn sɑriɑ mɛɛri. Yen biru bɑ ye mwɑ kɑ yen bɑru kpɑɑnu mɑ bɑ Amɔre be bɑ wɑ̃ɑ mi ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Yen biru bɑ swɑɑ kɔsɑ bɑ dɑ Bɑsɑni ɡiɑ. Yerɑ Oɡu Bɑsɑnin sunɔ u seewɑ kɑ win tɑbu kowobu u bu tɑbu wɔrim dɑ Edɛɛɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Yerɑ Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ ku win bɛrum ko, domi kon nun nùn nɔmu sɔndiɑ, wi kɑ win tɔmbu kɑ ben tem kpuro, kpɑ ɑ bu kuɑ nɡe mɛ ɑ Sihoni, Amɔrebɑn sunɔ kuɑ wi u wɑ̃ɑ Hɛsiboniɔ. ");
INSERT INTO bba_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Mɑ Isirelibɑ bɑ bu ɡo, wi kɑ win bibu kɑ sere win tɔmbu. Bɑɑ tɔn turo, bɑǹ deri. Mɑ bɑ win tem mwɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Yen biru, Isirelibɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, sɔ̃ɔ yɑri yeru ɡiɑ, Yerikon deedeeru. ");
INSERT INTO bba_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Bɑlɑki, Siporin bii u wɑ ye Isirelibɑ bɑ Amɔrebɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Yerɑ Mɔɑbubɑ bɑ nɑndɑ Isirelibɑn dɑbirun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mɑ bɑ Mɑdiɑnibɑn ɡuro ɡurobu sɔ̃ɔwɑ bɑ nɛɛ, tɔn dɑbi teni, tɑ koo sun wɔri tu di nɡe mɛ nɛɛ yi rɑ yɑkɑsu di. Sɑɑ ye sɔɔ, Bɑlɑkiwɑ u sɑ̃ɑ Mɔɑbubɑn sunɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","Yerɑ u sɔmɔbu ɡɔrɑ Bɑlɑmu Beorin biin mi, Petoriɔ ye yɑ wɑ̃ɑ Efɑrɑtin dɑɑrɔ win tɔmbun temɔ, u nùn sɔ̃ɔwɑ u nɛɛ, wee, bweseru ɡɑrɑ yɑrimɑ sɑɑ Eɡibitin di mɑ tɑ hɑnduniɑ kpuro pusi. Tɑ mɑɑ mɑn turuku koomɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Yen sɔ̃, nɑ nun kɑnɑmɔ ɑ nɑ ɑ mɑn tɔn be bɔ̃rusiɑ. Domi bɑ mɑn dɑm kere. À n kuɑ mɛ, sɔrɔkudo kon kpĩ n bu kɑmiɑ n ɡirɑ nɛn tem di. Domi nɑ yɛ̃ mɑ wi ɑ domɑru kuɑ u rɑ domɑru wɑ. Wi ɑ mɑɑ bɔ̃rusi, u rɑ bɔ̃ri wɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Mɑ Mɔɑbubɑ kɑ Mɑdiɑnibɑn ɡuro ɡuro be, bɑ dɑ Bɑlɑmu sɔro win mi, bɑ kɛ̃nu nɛni. Ye bɑ turɑ mi, yerɑ bɑ nùn Bɑlɑkin ɡɑri yi sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bɑlɑmu u bu sɔ̃ɔwɑ u nɛɛ, i kpunɔ mini wɔ̃ku te, sisiru kpɑ n bɛɛ sɔ̃ ye Yinni Gusunɔ u mɑn sɔ̃ɔwɑ. Mɑ Mɔɑbun ɡuro ɡuro be, bɑ sinɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Yerɑ Yinni Gusunɔ u Bɑlɑmu bikiɑ u nɛɛ, tɔn berɑ̀ bɑ wɑ̃ɑ wunɛn mi. ");
INSERT INTO bba_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bɑlɑmu u Gusunɔ wisɑ u nɛɛ, Bɑlɑki Siporin bii, Mɔɑbubɑn sinɑ bokowɑ u tɔn be ɡɔrimɑ bu mɑn sɔ̃ bu nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","wee, bweseru ɡɑrɑ yɑrimɑ Eɡibitin di mɑ tɑ hɑnduniɑ pusi. Yen sɔ̃, n be nɑ n tɔn be bɔ̃rusi. Sɔrɔkudo u koo kpĩ u tɔn be wɔri u kɑmiɑ u ɡirɑ win tem di. ");
INSERT INTO bba_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Gusunɔ u Bɑlɑmu sɔ̃ɔwɑ u nɛɛ, ɑ ku dɑ. A ku tɔn be bɔ̃rusi domi nɑ bu domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Mɑ Bɑlɑmu u seewɑ buru buru u Bɑlɑkin sɔmɔ be sɔ̃ɔwɑ u nɛɛ, i wuro bɛɛn temɔ, domi Yinni Gusunɔ u yinɑ n kɑ bɛɛ dɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Mɑ tɔn be, bɑ seewɑ bɑ ɡɔsirɑ Bɑlɑkin mi. Mɑ bɑ nùn sɔ̃ɔwɑ mɑ Bɑlɑmu u yinɑ u nɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Yerɑ Bɑlɑki u mɑɑ wiruɡibu ɡɑbu sokɑ u ɡɔrɑ be bɑ ɡbiikobu dɑbiru kɑ bɛɛrɛ kere. ");
INSERT INTO bba_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Bɑ seewɑ bɑ dɑ Bɑlɑmun mi. Ye bɑ turɑ mi, yerɑ bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ, ɑmɛniwɑ bɛsɛn sinɑ boko Bɑlɑki, Siporin bii u ɡeruɑ. U nɛɛ, u nun kɑnɑmɔwɑ ɑ ku yinɑ ɑ nɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Domi u koo be nun bɛɛrɛ bɑkɑ wɛ̃. U koo ko kpuro ye ɑ nùn bikiɑ. A ɡesi nɑ ɑ nùn tɔn be bɔ̃rusiɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Yerɑ Bɑlɑmu u tɔn be wisɑ u nɛɛ, bɑɑ Bɑlɑki ù n mɑn win diru kɑ̃ te tɑ wurɑ kɑ sii ɡeesu yibɑ nɑǹ kpɛ̃ n ɡɑ̃ɑnu ko. Domi nɑǹ kpɛ̃ n Yinni Gusunɔn ɡere yinɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Kɑ mɛ, i kpunɔ wɔ̃ku te, kpɑ n bɛɛ sɔ̃ ye u mɑn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Mɑ Yinni Gusunɔ u Bɑlɑmu kure wɔ̃ku te, u nùn sɔ̃ɔwɑ u nɛɛ, tɛ̃ yèn sɔ̃ tɔn be, bɑ nɑ bu nun soku, ɑ seewo ɑ kɑ bu dɑ. Adɑmɑ kɑɑ kowɑ ye nɑ nun sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Bɑlɑmu u seewɑ buru buru, u win kɛtɛku niu ɡɑɑri bɔkuɑ mɑ u kɑ Mɔɑbubɑn ɡuro ɡuro be dɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Ye Bɑlɑmu u swɑɑ wɔri u win kɛtɛku sɔni mɑ win sɔm kowobu yiru bɑ nùn swĩi, yerɑ Yinni Gusunɔ u kɑ nùn mɔru kuɑ mɑ u nùn win ɡɔrɑdo ɡɔriɑ u bunɑnɑ swɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Ye kɛtɛku ɡe, ɡɑ ɡɔrɑdo wi wɑ u yɔ̃ swɑɑ suunuɔ u win tɑkobi womɛ, yerɑ ɡɑ ɡɛrɑ ɡɑ dɑ yɑkɑsɔ. Mɑ Bɑlɑmu u ɡu so, u kɑ ɡu swɑɑ sure. ");
INSERT INTO bba_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Mɑ ɡɔrɑdo wi, u dɑ u yɔ̃rɑ swɑɑ kisɑ ɡɑɑ sɔɔ, resɛm ɡbɑɑnu yirun ɡɑnin bɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Yerɑ kɛtɛku ɡe, ɡɑ mɑɑ Yinni Gusunɔn ɡɔrɑdo wi wɑ mɑ ɡɑ dɑ ɡɑ mɑni ɡɑni yin tiɑɔ. Mɑ ɡɑ Bɑlɑmun nɑɑsu kɑ ɡɑnɑ ye bɑɑri. Mɑ u ɡu so kpɑm. ");
INSERT INTO bba_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Yerɑ ɡɔrɑdo wi, u swɛnyɑ u dɑ wuswɑɑɔ, mi bɑǹ kpɛ̃ bu mɑɑ ɡɛrɑ ɡɑm. ");
INSERT INTO bba_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Yerɑ kɛtɛku ɡe, ɡɑ mɑɑ ɡɔrɑdo wi wɑ mɑ ɡɑ wɔrumɑ. Sɑɑ yerɑ Bɑlɑmu u mɑɑ ɡu soberu wɔri kɑ mɔru. ");
INSERT INTO bba_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Yerɑ Yinni Gusunɔ u derɑ kɛtɛku ɡe, ɡɑ nɔɔ wukiɑ ɡɑ ɡɑri ɡeruɑ ɡɑ nɛɛ, Bɑlɑmu, mbɑ nɑ nun kuɑ ɑ kɑ mɑn so mɛ sere nɔn itɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Mɑ u kɛtɛku ɡe wisɑ u nɛɛ, ɑ mɑn yɑɑkoru mɔ̀wɑ. Nɑ̀ n dɑɑ mɑm tɑkobi nɛni, nɑ n nun ɡo kɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Mɑ kɛtɛku ɡe, ɡɑ nùn wisɑ ɡɑ nɛɛ, nɑ sɑ̃ɑwɑ wunɛn kɛtɛku, ɑ rɑ mɑn sɔni bɑɑdommɑ sere n kɑ ɡisɔ ɡirɑri. Nɡe mɛyɑ nɑ rɑ nun kue? Mɑ Bɑlɑmu u wisɑ u nɛɛ, ɑɑwo, n ǹ mɛ. ");
INSERT INTO bba_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Sɑɑ yerɑ Yinni Gusunɔ u Bɑlɑmun nɔni wukiɑ mɑ u Gusunɔn ɡɔrɑdo wi wɑ u yɔ̃ swɑɑ suunu sɔɔ u win tɑkobi womɛ. Yerɑ u yiirɑ u wuswɑɑ tem ɡirɑri. ");
INSERT INTO bba_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Mɑ ɡɔrɑdo wi, u nùn bikiɑ u nɛɛ, mbɑn sɔ̃nɑ ɑ kɑ wunɛn kɛtɛku so mɛ, sere nɔn itɑ. Nɑ nɑwɑ n kɑ nun yɔ̃rɑsiɑ. Domi kɑrin swɑɑ ɑ swĩi mi. ");
INSERT INTO bba_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Kɛtɛku ɡe, ɡɑ mɑn wɑ mɑ ɡɑ ɡɛrɑ sere nɔn itɑ. Gɑ̀ kun dɑɑ ɡɛre mɛ, kon dɑɑ nun ɡowɑ kpɑ n ɡen tii deri. ");
INSERT INTO bba_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Mɑ Bɑlɑmu u ɡɔrɑdo wi sɔ̃ɔwɑ u nɛɛ, wee nɑ torɑ. Nɑǹ yɛ̃ mɑ ɑ wɑ̃ɑ swɑɑɔ. Tɛ̃, nɛn sɑnum mɛ, mù kun kɑ nun nɑɑwɛ, kon ɡɔsirɑ n wurɑ nɛn yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Mɑ ɡɔrɑdo wi, u nɛɛ, ɑɑwo. A kɑ tɔn be doo. Adɑmɑ ɡɑri yi kon nun sɔ̃, yiyɑ kɑɑ ɡere. Mɑ Bɑlɑmu u kɑ Bɑlɑkin tɔn be dɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Sɑnɑm mɛ Bɑlɑki u nuɑ mɑ Bɑlɑmu u wee, yerɑ u nùn sennɔ dɑ sere Mɔɑbubɑn wuuɔ ben tem nɔɔ burɑ yerɔ Aɑnɔɔn dɑɑrɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Mɑ Bɑlɑki u nùn sɔ̃ɔwɑ u nɛɛ, mbɑn sɔ̃nɑ ɑǹ nɛ sɑnɑm mɛ nɑ ɡbiɑ nɑ nun sɔmɔbu ɡɔriɑ. A tɑmɑɑ nɑǹ kpɛ̃ n nun ɡɑ̃ɑnu kɛ̃? ");
INSERT INTO bba_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Mɑ Bɑlɑmu u Bɑlɑki wisɑ u nɛɛ, ɡeemɑ, wee, nɑ nɑ wunɛn mi tɛ̃, ɑdɑmɑ nɑǹ ɡɛɛ mɔ n nun sɔ̃. Yinni Gusunɔwɑ u koo mɑn sɔ̃ ye kon nun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Mɑ Bɑlɑmu kɑ Bɑlɑki bɑ swɑɑ wɔrimɑ bɑ tunumɑ Kiriɑti Husɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Yerɑ Bɑlɑki u kɛtɛbɑ kɑ yɑ̃ɑnu ɡo u kɑ yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Yen sisiru bururu, Bɑlɑki u Bɑlɑmu suɑ bɑ yɔɔwɑ Bɑmɔtu Bɑɑliɔ. Min diyɑ bɑ Isirelibɑn sukum wɑɑmɔ. ");
INSERT INTO bba_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Mɑ Bɑlɑmu u Bɑlɑki sɔ̃ɔwɑ u nɛɛ, u nùn yɑ̃ku yenu nɔɔbɑ yiru kuo. Yen biru, kpɑ u kɛtɛ nɔɔbɑ yiru kɑ yɑ̃ɑ kinɛnu nɔɔbɑ yiru kɑsu. ");
INSERT INTO bba_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Mɑ Bɑlɑki u kuɑ ye Bɑlɑmu u nùn sɔ̃ɔwɑ. Mɑ wi kɑ Bɑlɑmu bɑ kɛtɛ yen tiɑ kɑ yɑ̃ɑ kinɛ teeru ɡo yɑ̃ku yee nin bɑɑteren wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Yerɑ Bɑlɑmu u Bɑlɑki sɔ̃ɔwɑ u nɛɛ, ɑ yɔ̃ro yɑ̃ku dɔ̃ɔ mwɑɑruɡii nin bɔkuɔ kpɑ nɛ n dɛsirɑ n dɑ ɡɑm ɡum. Sɔrɔkudo Yinni Gusunɔ u koo mɑn kure mi, kpɑ u mɑn sɔ̃ ye kon nun sɔ̃. Mɑ Bɑlɑmu u dɑ ɡunɡuru ɡɑrun wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Yerɑ Yinni Gusunɔ u nùn kure mɑ Bɑlɑmu u ɡeruɑ u nɛɛ, wee nɑ yɑ̃ku yenu nɔɔbɑ yiru kuɑ mɑ nɑ kɛtɛ kɑ yɑ̃ɑru ɡo yɑ̃ku yee nin bɑɑteren wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Sɑɑ yerɑ Yinni Gusunɔ u nùn sɔ̃ɔwɑ ye u koo Bɑlɑki sɔ̃, mɑ u nɛɛ, u ɡɔsiro u wurɑ Bɑlɑkin mi. ");
INSERT INTO bba_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Mɑ Bɑlɑmu u wurɑ u dɑ u Bɑlɑki deemɑ mi u win yɑ̃ku ni mɔ̀ kɑ Mɔɑbubɑn wiruɡibu ɡɑbu. ");
INSERT INTO bba_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Sɑɑ yerɑ Bɑlɑmu u ɡɑri ɡeruɑ u nɛɛ, wee Bɑlɑki Mɔɑbun sunɔ u derɑ nɑ nɑ sɑɑ Arɑmun di. Wiyɑ u derɑ nɑ sɑrɑmɑ sɑɑ sɔ̃ɔ yɑri yerun ɡuunun di. U nɛɛ, n be nɑ n Yɑkɔbun bweseru bɔ̃rusi. N be nɑ n kɑ be Isirelibɑ mɔru ko. ");
INSERT INTO bba_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Adɑmɑ kon tɔnu bɔ̃rusi wi Gusunɔ kun bɔ̃rusi? Amɔnɑ kon kɑ tɔnu mɔru ko wi Gusunɔ kun kɑ mɔru mɔ̀. ");
INSERT INTO bba_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Nɑ Isirelibɑ wɑɑmɔ ɡuunu wɔllɔ kɑ ɡunɡunu wɔllɔ bɑ wɑ̃ɑ nɛnɛm bɑǹ kɑ bweseru ɡɑru weenɛ. ");
INSERT INTO bba_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Goo kun kpɛ̃ u bu ɡɑri. Bɑ dɑbi nɡe yɑni sɛɛri mini. Wɑrɑ u koo kpĩ u ben bɔnu nnɛn sube teeru ɡɑri. Nɑ kɑnɑmɔwɑ n ɡbi nɡe Isireli be, be bɑ sɑ̃ɑ ɡemɡibu. Nɑ kĩwɑ nɛn wɑ̃ɑrun wii ɡoberu tɑ n sɑ̃ɑ nɡe beɡiru. ");
INSERT INTO bba_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Yerɑ Bɑlɑki u Bɑlɑmu bikiɑ u nɛɛ, mbɑ ɑ mɑn kuɑmmɛ mɛsum. Nɑ nun sokusiɑwɑ ɑ kɑ nɛn yibɛrɛbɑ bɔ̃rusi. Adɑmɑ wee domɑrɑ ɑ bu kuɑmmɛ. ");
INSERT INTO bba_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Mɑ Bɑlɑmu u nùn wisɑ u nɛɛ, ye Yinni Gusunɔ u mɑn sɔ̃ɔwɑ, n ǹ yerɑ kon ɡere? ");
INSERT INTO bba_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Bɑlɑki u mɑɑ Bɑlɑmu sɔ̃ɔwɑ u nɛɛ, ɑ mɑn swĩimɑ su dɑ ɡɑm ɡiɑ. Min di kɑɑ ben sukum wɑ n ǹ be kpuro. Be ɑ wɑ mi, kpɑ ɑ bu bɔ̃rusi. ");
INSERT INTO bba_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Mɑ u kɑ nùn dɑ sɑnsɑnin kɔ̃su yeru ɡɑrun mi, Pisiɡɑn ɡuuru wɔllɔ. Miyɑ u mɑɑ yɑ̃ku yenu nɔɔbɑ yiru kuɑ. Mɑ u nɑɑ kinɛru kɑ yɑ̃ɑ kinɛru ɡo yɑ̃ku yee nin bɑɑteren wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Mɑ Bɑlɑmu u Bɑlɑki sɔ̃ɔwɑ u nɛɛ, ɑ yɔ̃ro mi ɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu mɔ̀ mini, kpɑ n dɑ n nɔ ye Yinni Gusunɔ u koo mɑn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Yerɑ Yinni Gusunɔ u nɑ u kɑ Bɑlɑmu yinnɑ. Mɑ u nùn sɔ̃ɔwɑ ye u koo Bɑlɑki sɔ̃. Mɑ u nɛɛ, u wuro Bɑlɑki win mi. ");
INSERT INTO bba_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Mɑ u wurɑ u dɑ Bɑlɑkin mi u deemɑ u wɑ̃ɑ win yɑ̃kunun bɔkuɔ, wi kɑ Mɔɑbubɑn wiruɡibu. Sɑɑ yerɑ u Bɑlɑmu bikiɑ u nɛɛ, mbɑ Yinni Gusunɔ u nun sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Mɑ Bɑlɑmu u nɛɛ, Bɑlɑki, ɑ seewo ɑ swɑɑ dɑki. Wunɛ Siporin bii, ɑ swɑɑ tem kpĩiyɔ ɑ nɔ. ");
INSERT INTO bba_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Gusunɔ kun sɑ̃ɑ nɡe tɔnu u sere weesu ko. Uǹ sɑ̃ɑ nɡe tɔnu u sere kɔbiɑ ye u rɑɑ ɡeruɑ. Ye u ɡeruɑ, yerɑ u rɑ ko. Yèn himbɑ u mɑɑ yi, yɑ rɑ koorewɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Wee Gusunɔ u mɑn woodɑ wɛ̃ n Isirelibɑ domɑru kuɑ. Win tiiwɑ u bu tu kuɑ kɔ. Yen sɔ̃, nɑǹ kpɛ̃ n tu yinɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Uǹ torɑru ɡɑru wɑ Isirelibɑ sɔɔ. U sɑ̃ɑwɑ Gusunɔ ben Yinni, u mɑɑ wɑ̃ɑ kɑ be. U sɑ̃ɑwɑ ben sinɑ boko. U mɑɑ nuku dobu mɔ ben sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Wiyɑ u bu yɑrɑ Eɡibitin di. U bu dɑm wɛ̃ nɡe kɛtɛ ɡbeekiru. ");
INSERT INTO bba_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Sɔroru tɑǹ kpɛ̃ tu Isirelibɑ ɡɑ̃ɑnu kuɑ. Dobo dobo yɑǹ kpɛ̃ yu bu nɔni wɔ̃ke. Sɑɑ yɑ̀ n turɑ bɑ koo bu sɔ̃ bu nɛɛ, bu mɛɛrio ye Yinni Gusunɔ u kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Bɑ sɑ̃ɑwɑ nɡe ɡbee sunɔ ɡe ɡɑ rɑ yɑɑ mwɛ ɡu tem kpɑ ɡu yen yɛm nɔ ɡu sere dɑ ɡu kpunɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Mɑ Bɑlɑki u Bɑlɑmu sɔ̃ɔwɑ u nɛɛ, ɑ̀ kun kĩ ɑ bu bɔ̃rusi, ɑ ku bu domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Yerɑ Bɑlɑmu u nùn wisɑ u nɛɛ, nɑǹ dɑɑ nun sɔ̃ɔwɑ nɑ nɛɛ, kon kowɑ ye Yinni Gusunɔ u ɡeruɑ? ");
INSERT INTO bba_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Bɑlɑki u mɑɑ Bɑlɑmu sɔ̃ɔwɑ u nɛɛ, ǹ n mɛn nɑ, ɑ nɑ su dɑ ɡɑm ɡiɑ. Sɔrɔkudo Yinni Gusunɔ u koo wurɑ ɑ Isirelibɑ bɔ̃rusi nɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Mɑ Bɑlɑki u kɑ Bɑlɑmu dɑ Peorin ɡuuru wɔllɔ tèn min di bɑ ɡbɑburu mɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bɑlɑmu u Bɑlɑki sɔ̃ɔwɑ u nɛɛ, ɑ mɑn yɑ̃ku yenu nɔɔbɑ yiru kuo, kpɑ ɑ kɑ mɑn nɑɑ kinɛnu nɔɔbɑ yiru kɑ yɑ̃ɑ kinɛnu nɔɔbɑ yiru nɑɑwɑ, ");
INSERT INTO bba_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","mɑ Bɑlɑki u kuɑ ye Bɑlɑmu u nùn sɔ̃ɔwɑ mi. U nɑɑ kinɛru kɑ yɑ̃ɑ kinɛru ɡo yɑ̃ku yee nin bɑɑteren wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Ye Bɑlɑmu u wɑ mɑ Yinni Gusunɔ u yɔ̃rɑriwɑ u Isirelibɑ domɑru kuɑ, yerɑ uǹ mɑɑ bikiɑru kue Yinni Gusunɔn mi nɡe mɛ u rɑ rɑɑ ko yellu. Adɑmɑ u win wuswɑɑ tĩiwɑ ɡbɑburun berɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Ye u nɔni seeyɑ u wɑ Isirelibɑ bɑ ben sɑnsɑni ɡire bwese kɛrɑ kɑ bwese kɛrɑ, yerɑ Gusunɔn Hunde nùn yɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","Mɑ u ɡɑri ɡerubu wɔri u nɛɛ, nɛ, Bɑlɑmu, Beorin bii, wee ye nɑ ɡerumɔ. Nɑ rɑ yɑm wɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","Nɑ rɑ Gusunɔn nɔɔ nɔ. Wi, Dɑm kpuroɡii u rɑ de n kɑ̃sinu wɑ. Domi u rɑ mɑn tii sɔ̃ɔsi nɑ̀ n nùn sɑ̃ɑmɔ. ");
INSERT INTO bba_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","Bɛɛ Isirelibɑ Yɑkɔbun bweseru, bɛɛn kunu nu wɑ̃. ");
INSERT INTO bba_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","Nu tɛrie nɡe wɔwɑ mɑ nu sɑ̃ɑ nɡe ɡbɑɑ te tɑ wɑ̃ɑ dɑɑrun bɔkuɔ. Mɑ nu ɡire nɡe dɑ̃ɑ ni bɑ mɔ̀ sɛduru ni Yinni Gusunɔ u duurɑ dɑɑrun bɔkuɔ kɑ sere dɑ̃ɑ kiki si bɑ mɔ̀ ɑloɛsi. ");
INSERT INTO bba_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Bɑ nim mɔ mu yibɑ mu yɑrimɔ mu dɑ̃ɑ ɡbɑɑru nim yɛ̃kɑmɔ. Isirelibɑn sinɑ boko u koo Aɡɑɡi tɑbu di kpɑ win bɑndu tu dɑm ko. ");
INSERT INTO bba_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","Gusunɔwɑ u bu yɑrɑ Eɡibitin di kɑ win dɑm bɑkɑm nɡe kɛtɛ ɡbeekiru. Wiyɑ u rɑ de bu bwese tukunu kɑmiɑ nɔni kpɑki teeru kpɑ bu nu sɛ̃ɛnu twee bu nin kukunu kɔsuku bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Be wee bɑ kpunɑmɔ nɡe ɡbee sinɑnsu. Wɑrɑ u koo kpĩ u bu seeyɑ. Bɛɛ, Isirelibɑ, wi u bɛɛ domɑru kuɑ, u koo domɑru wɑ. Wi u mɑɑ bɛɛ bɔ̃rusi, u koo bɔ̃ri wɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Yerɑ Bɑlɑkin mɔru yɑ seewɑ sere u nɔmɑ yɛ̃kɑnɑ. Mɑ u nɛɛ, Bɑlɑmu, nɑ nun sokɑwɑ ɑ kɑ nɛn yibɛrɛbɑ bɔ̃rusi. Adɑmɑ wee ɑ bu domɑru kuɑ nɔn itɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Yen sɔ̃, ɑ doonɔ minin di tɛ̃, ɑ wurɑ wunɛn yɛnuɔ. Nɑ rɑɑ nɛɛ, kon nun ɡɑ̃ɑnu kɛ̃, ɑdɑmɑ Yinni Gusunɔ kun wure ɑ ye wɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Mɑ Bɑlɑmu u Bɑlɑki wisɑ u nɛɛ, nɑǹ dɑɑ wunɛn ɡɔro be sɔ̃ɔwɑ nɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","bɑɑ ɑ̀ n mɑn wunɛn diru kɑ̃, te tɑ wurɑ kɑ sii ɡeesu yibɑ nɑǹ kpɛ̃ n ɡeɑ ǹ kun mɛ kɔ̃sɑ ɡere mɑ n kun mɔ ye Yinni Gusunɔn u mɑn sɔ̃ɔwɑ? ");
INSERT INTO bba_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Tɛ̃ wee nɑ ɡɔsirɔ nɛn tɔmbun mi. Adɑmɑ ɑ nɑ ɑ nɔ yè Isirelibɑ bɑ koo wunɛn tɔmbu kuɑ siɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Mɑ u mɑɑ nɛɛ, wee ye nɛ Bɑlɑmu Beorin bii nɑ ɡerumɔ, nɛ wi nɑ rɑ yɑm wɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Nɑ rɑ Yinni Gusunɔn nɔɔ nɔ. Nɑ mɑɑ wi, Wɔrukoon himbɑ yɛ̃. Nɑ rɑ wi Dɑm kpuroɡiin kɑ̃sinu wɑ, domi u rɑ mɑn tii sɔ̃ɔsi nɑ̀ n nùn sɑ̃ɑmɔ. ");
INSERT INTO bba_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","Nɑ wɑ ye yɑ sisi, ɑdɑmɑ n ǹ mɔ ɡisɔ. Nɑ wɑ ye yɑ koo koorɑ, ɑdɑmɑ n ǹ tɛ̃. Wee kperɑ ɡɑɑ yɑrɑ Yɑkɔbun bweserun di. Sinɑ boko ɡoo u yɑrɑ Isirelibɑn suunu sɔɔn di, be, be bɑ sɑ̃ɑ Yɑkɔbun bweseru. Mɑ u kɑ win sinɑ dɛkɑ Mɔɑbubɑ soomɔ bɑɑ sɑburosɔ. Mɑ yɑ be bɑ tii suen bweserun winu kɔsukumɔ. ");
INSERT INTO bba_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","U mɑɑ Edɔmu be bɑ sɑ̃ɑ win yibɛrɛbɑn tem mwɑ mɛ bɑ mɔ̀ Seiri. Mɑ Isirelibɑ bɑ nɑsɑrɑ suɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Sinɑ boko wi, u win yibɛrɛbɑ tɑɑre. Mɑ u be bɑ rɑɑ tie ɡo u kpeerɑsiɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ye Bɑlɑmu u Amɑlɛkibɑ wɑ, yerɑ u nɛɛ, Amɑlɛkibɑrɑ bɑ dɑm bo duniɑ sɔɔ. Adɑmɑ bɑ koo bu kɑm koosiɑ sɔ̃ɔ teeru. ");
INSERT INTO bba_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ye Bɑlɑmu u mɑɑ Kenibɑ wɑ, yerɑ u nɛɛ, bɛɛ Kenibɑ, wee bɛɛn wɑ̃ɑ yerɑ nɑɑnɛ mɔ nɡe ɡunɔ sokuru te tɑ yii kpee bɑɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Adɑmɑ Asiriɡibu bɑ koo bɛɛ yoru mwɛɛri kpɑ bu bɛɛn wɑ̃ɑ yenu kɔsuku. ");
INSERT INTO bba_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Mɑ Bɑlɑmu u mɑɑ nɛɛ, Gusunɔ ù n ɡoon ɡɔɔn sɑɑ yi, yɛ̃ro u koo kpĩ u n wɑ̃ɑ? ");
INSERT INTO bba_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Goo nimkusu su koo nɑ sɑɑ Kitimun di kpɑ yibɛrɛbɑ bu Asiriɡibu kɑ Ebɛɛn bweseru sekuru doke. Adɑmɑ yibɛrɛ ben tii bɑ koo kɑm kowɑ. ");
INSERT INTO bba_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Yenibɑn biru, Bɑlɑmu u ɡɔsirɑ u dɑ win wuuɔ, mɑ Bɑlɑki u mɑɑ wurɑ win yɛnuɔ. ");
INSERT INTO bba_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Sɑɑ ye Isirelibɑ bɑ wɑ̃ɑ Sitimuɔ, yerɑ bɑ kɑ Mɔɑbubɑn wɔndiɑbɑ sɑkɑrɑru toruɑ. ");
INSERT INTO bba_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Mɑ wɔndiɑ be, bɑ derɑ Isireli be, bɑ ben bũu sɑ̃ɑru wɔri, bɑ kɑ bu di, bɑ kɑ bu nɔrɑ. Mɑ bɑ ben bũnu yiirɑ bɑ sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Bɑ tii bũu wi bɑ mɔ̀ Bɑɑli Peoriɡii wɛ̃. Mɑ Yinni Gusunɔ u kɑ bu mɔru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","U Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ Isirelibɑn wiruɡibu kpuro mɛnnɔ, kpɑ ɑ de bu be bɑ tɑɑrɛ mɔ ɡo sɔ̃ɔ sɔɔ nɛn wuswɑɑɔ. Sɑɑ yerɑ nɛn mɔru yɑ koo sure. ");
INSERT INTO bba_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Mɑ Mɔwisi u Isirelibɑn wiruɡibu sɔ̃ɔwɑ u nɛɛ, ben bɑɑwure u mɛɛrio win tɔmbu sɔɔ be bɑ Mɔɑbubɑn bũu wi bɑ mɔ̀ Bɑɑli Peoriɡii sɑ̃ɑmɔ, kpɑ u bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Sɑɑ yè sɔɔ Isirelibɑ bɑ wuri mɔ̀ Yinni Gusunɔn kurun kɔnnɔwɔ, sɑɑ yerɑ ben turo u kɑ kurɔ Mɑdiɑni ɡoo nɑ wiɡibun mi, Isirelibɑ kpuron wuswɑɑɔ kɑ Mɔwisin wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Ye Finɛɛsi, Eleɑsɑɑn bii, Aronin debubu u wɑ mɛ, yerɑ u seewɑ tɔn ben suunu sɔɔn di u yɑɑsɑ suɑ. ");
INSERT INTO bba_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","Mɑ u Isireli wi swĩi sere win kurɔ mɑ u bu yɑɑsɑ sɔkurɑ ben bɔsɔnɔ. Sɑɑ yerɑ wɑhɑlɑ yɑ yɔ̃rɑ Isirelibɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Yen dɔmɑ te, tɔmbu nɔrɔbun subɑ yɛndɑ nnɛwɑ (24.000) bɑ ɡu. ");
INSERT INTO bba_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","wee yɑ̃ku kowo Finɛɛsi, Eleɑsɑɑn bii, Aronin debubu, u nɛn mɔru suresiɑ ye u kɑ mɑn sɑnnɑ, Isirelibɑn suunu sɔɔ. Yen sɔ̃nɑ nɑǹ bu kpeerɑsie. ");
INSERT INTO bba_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Yen sɔ̃, ɑ nùn sɔ̃ɔwɔ ɑ nɛɛ, wee nɑ kɑ nùn ɑrukɑwɑni bɔkumɔ ye yɑ sɑ̃ɑ bɔri yɛnduɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Arukɑwɑni ye, yɑ koo de wi kɑ win bibun bweseru bɑ n sɑ̃ɑ yɑ̃ku kowobu sere kɑ bɑɑdommɑɔ. Domi u nɛ, Gusunɔ win Yinni sɑnnɑ. Mɑ yɑ derɑ Isirelibɑ bɑ ben torɑrun suuru wɑ. ");
INSERT INTO bba_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Isireli wi bɑ ɡo kɑ kurɔ Mɑdiɑni wi sɑnnu, win yĩsirɑ Simiri, Sɑlun bii. U sɑ̃ɑwɑ Simɛɔn bwese kɛrɑ tiɑn wiruɡii. ");
INSERT INTO bba_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Kurɔ Mɑdiɑni win yĩsirɑ mɑɑ Kosibi. Win tundon yĩsirɑ Suri. U sɑ̃ɑwɑ Mɑdiɑnibɑn bwese kɛrɑ tiɑn wiruɡii. ");
INSERT INTO bba_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Yinni Gusunɔ u mɑɑ Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","i Mɑdiɑnibɑ wɔrio, kpɑ i bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","Domi bɑ sɑ̃ɑwɑ bɛɛn yibɛrɛbɑ be bɑ bɛɛ torɑsiɑ ben bũu Bɑɑli Peoriɡiin sɔ̃ kɑ Kosibi, ben wiruɡii turon bii wɔndiɑn sɔ̃, wi bɑ ɡo sɑnɑm mɛ wɑhɑlɑ yɑ seewɑ Peoriɔ. ");
INSERT INTO bba_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Wɑhɑlɑ yen biru, Yinni Gusunɔ u Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑ, Aronin bii sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","i Isirelibɑn bii tɔn durɔbu ɡɑrio be bɑ wɔ̃ɔ yɛndu mɔ kɑ be bɑ kere mɛ, be bɑ koo ɡesi kpĩ bu tɑbu dɑ. I ko i bu ɡɑriwɑ bwese kɛrɑ kɑ bwese kɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Mɑ Mɔwisi kɑ Eleɑsɑɑ bɑ ye Isirelibɑ sɔ̃ɔwɑ Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, Yerikon deedeeru. ");
INSERT INTO bba_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","Bɑ nɛɛ, bu ɡɑrio ben be bɑ wɔ̃ɔ yɛndu mɔ kɑ be bɑ kere mɛ, be bɑ koo kpĩ bu tɑbu ko nɡe mɛ Gusunɔ u rɑɑ bu yen woodɑ wɛ̃ sɑnɑm mɛ bɑ yɑrimɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Bèn min di Rubɛni, Yɑkɔbun bii ɡbiikoon bwese kɛri toruɑ, berɑ Enɔku, wìn min di Ɛnɔkubɑn bwese kɛrɑ yɑrɑ, kɑ Pɑɑlu, wìn min di Pɑɑlubɑn bwese kɛrɑ yɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","kɑ Hɛsironi, wìn min di Hɛsironibɑn bwese kɛrɑ yɑrɑ, kɑ Kɑɑmi wìn min di Kɑɑmibɑn bwese kɛrɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Be bɑ sɑ̃ɑ Rubɛnin bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ itɑ kɑ tɔmbu nɑtɑ kɑ wunɔbu kɑ tɔmbu tɛnɑ (43.730). ");
INSERT INTO bba_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Eliɑbu, Pɑɑlun bii, ");
INSERT INTO bba_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","wiyɑ u Nɛmuɛli mɑrɑ, kɑ Dɑtɑni, kɑ Abirɑmu. Dɑtɑni wi, kɑ Abirɑmu bɑ sɑ̃ɑwɑ win ɡerunɑsibu. Beyɑ bɑ Mɔwisi kɑ Aroni seesi, mɑ bɑ kɑ Koren bibun bweseru yɔ̃rɑ sɑnɑm mɛ bɑ Yinni Gusunɔ seesi. ");
INSERT INTO bba_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Mɑ tem mu nɔɔ bɑɑrɑ mu bu mwɛ kɑ Koren tii sɑnnu. Mɑ dɔ̃ɔ u ɡɑbu di. Ben ɡeerɑ sɑ̃ɑ tɔmbu ɡoobu, kɑ weerɑɑkuru (250). Mɑ yɑ kuɑ kirɔ be bɑ tien sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Adɑmɑ Koren bibu bɑǹ dɔmɑ te ɡu. ");
INSERT INTO bba_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Bèn min di Simɛɔn bwese kɛri toruɑ berɑ, Nɛmuɛli, wìn min di Nɛmuɛlibɑn bwese kɛrɑ yɑrɑ, kɑ Yɑmini, wìn min di Yɑminibɑn bweserɑ yɑrɑ, kɑ Yɑkini, wìn min di Yɑkinibɑn bweserɑ yɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","kɑ Serɑki, wìn min di Serɑkibɑn bweserɑ yɑrɑ, kɑ Sɔɔlu, wìn min di Sɔɔlubɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Be bɑ sɑ̃ɑ Simɛɔn bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ yɛndɑ yiru kɑ tɔmbu ɡoobu (22.200). ");
INSERT INTO bba_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Bèn min di Gɑdin bwese kɛri toruɑ, berɑ Sefoni, wìn min di Sefonibɑn bwese kɛrɑ yɑrɑ, kɑ Hɑɡi, wìn min di Hɑɡibɑn bwese kɛrɑ yɑrɑ, kɑ Suni, wìn min di Sunibɑn bweserɑ yɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","kɑ Osini, wìn min di Osinibɑn bweserɑ yɑrɑ, kɑ Eri, wìn min di Eribɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Kɑ Arodi, wìn min di Arodibɑn bweserɑ yɑrɑ, kɑ Areli, wìn min di Arelibɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Be bɑ sɑ̃ɑ Gɑdin bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɛɛrɑ wunɔbu (40.500). ");
INSERT INTO bba_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","21","Bèn min di Yudɑn bwese kɛri toruɑ, berɑ Selɑ, wìn min di Selɑbɑn bwese kɛrɑ yɑrɑ, kɑ Perɛsi, wìn min di Perɛsibɑn bweserɑ yɑrɑ, kɑ Serɑki, wìn min di Serɑkibɑn bweserɑ yɑrɑ. Bèn min di Perɛsin bwese kɛri toruɑ, berɑ Hɛsironi wìn min di Hɛsironibɑn bwese kɛrɑ yɑrɑ, kɑ Hɑmulu wìn min di Hɑmulubɑn bweserɑ yɑrɑ. Yudɑn bibu yiru Eri kɑ Onɑni bɑ ɡu Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Be bɑ sɑ̃ɑ Yudɑn bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wɑtɑ kɑ wɔkurɑ nɔɔbu kɑ tiɑ kɑ nɛɛrɑ wunɔbu (76.500). ");
INSERT INTO bba_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Bèn min di Isɑkɑrin bwese kɛri toruɑ, berɑ Tolɑ, wìn min di Tolɑbɑn bweserɑ yɑrɑ, kɑ Pufɑ, wìn min di Pufɑbɑn bweserɑ yɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","kɑ Yɑsubu, wìn min di Yɑsububɑn bweserɑ yɑrɑ, kɑ Simuroni, wìn min di Simuronibɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Be bɑ sɑ̃ɑ Isɑkɑrin bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ nɔrɔbun subɑ wɑtɑ kɑ nnɛ kɑ ɡoobɑ wunɔbu (64.300). ");
INSERT INTO bba_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Bèn min di Sɑbulonin bwese kɛri toruɑ, berɑ Serɛdi, wìn min di Serɛdibɑn bwese kɛrɑ yɑrɑ, kɑ Heloni, wìn min di Helonibɑn bweserɑ yɑrɑ, kɑ Yɑlɛɛli wìn min di Yɑlɛɛlibɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Be bɑ sɑ̃ɑ Sɑbulonin bwese kɛri toruɑ, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wɑtɑ kɑ nɛɛrɑ wunɔbu (60.500). ");
INSERT INTO bba_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Yosɛfun bweseru sɔɔrɑ Mɑnɑse kɑ Efɑrɑimu bɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Mɑnɑsen biiwɑ Mɑkiri, wìn min di Mɑkiribɑn bwese kɛrɑ yɑrɑ. Mɑkiriwɑ u Gɑlɑdi mɑrɑ, wìn min di Gɑlɑdibɑn bwese kɛrɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Bèn min di Gɑlɑdin bwese kɛri toruɑ, berɑ Yesɛɛ, wìn min di Yesɛɛbɑn bwese kɛrɑ yɑrɑ, kɑ Helɛki wìn min di Helɛkibɑn bwese kɛrɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Kɑ Asiriɛli wìn min di Asiriɛlibɑn bweserɑ yɑrɑ, kɑ Sikɛmu wìn min di Sikɛmubɑn bweserɑ yɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","kɑ Semidɑ wìn min di Semidɑbɑn bweserɑ yɑrɑ, kɑ Hefɛɛ, wìn min di Hefɛɛbɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Selofɑdi Hefɛɛn bii, uǹ bii tɔn durɔbu mɑrɑ mɑ n kun mɔ tɔn kurɔbu tɔnɑ. Beyɑ, Mɑlɑ kɑ Nɔɑ, kɑ Hoɡulɑ, kɑ Milikɑ, kɑ Tirisɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Be bɑ sɑ̃ɑ Mɑnɑsen bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ yiru kɑ tɔmbu nɑtɑ kɑ wunɔbu (52.700). ");
INSERT INTO bba_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Bèn min di Efɑrɑimun bwese kɛri toruɑ, berɑ Sutelɑki, wìn min di Sutelɑkibɑn bwese kɛrɑ yɑrɑ, kɑ Bekɛɛ wìn min di Bekɛɛbɑn bweserɑ yɑrɑ, kɑ Tɑkɑni wìn min di Tɑkɑnibɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sutelɑkin biiwɑ Erɑni wìn min di Erɑnibɑn bwese kɛrɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Be bɑ sɑ̃ɑ Efɑrɑimun bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ tɛnɑ kɑ yiru kɑ tɔmbu nɛɛrɑ wunɔbu (32.500). Be kpuro bɑ sɑ̃ɑwɑ Yosɛfun bibu. ");
INSERT INTO bba_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Bèn min di Bɛnyɑmɛɛn bwese kɛri toruɑ, berɑ Belɑ, wìn min di Belɑbɑn bweserɑ yɑrɑ, kɑ Asibɛli wìn min di Asibɛlibɑn bweserɑ yɑrɑ, kɑ Akirɑmu wìn min di Akirɑmubɑn bweserɑ yɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","kɑ Sufɑmu wìn min di Sufɑmubɑn bweserɑ yɑrɑ, kɑ Hufɑmu wìn min di Hufɑmubɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Belɑn bibɑ Aɑdi kɑ Nɑmɑni. Aɑdin min diyɑ Aɑdibɑn bwese kɛrɑ yɑrɑ. Nɑmɑnin min diyɑ mɑɑ Nɑmɑnibɑn bwese kɛrɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Be bɑ sɑ̃ɑ Bɛnyɑmɛɛn bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɔɔbu kɑ tɔmbu nɑtɑ (45.600). ");
INSERT INTO bba_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Bèn min di Dɑnun bwese kɛrɑ toruɑ, berɑ Sukɑmu, wìn min di Sukɑmubɑn bwese kɛrɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ wɑtɑ kɑ nnɛ kɑ tɔmbu nɛɛru (64.400). ");
INSERT INTO bba_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Bèn min di mɑɑ Asɛɛn bwese kɛri toruɑ, berɑ Yiminɑ, wìn min di Yiminɑbɑn bweserɑ yɑrɑ, kɑ Yisifi wìn min di Yisifibɑn bweserɑ yɑrɑ, kɑ Beriɑ wìn min di Beriɑbɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","Beriɑn bweseru sɔɔrɑ Hebɛɛ u wɑ̃ɑ, wìn min di Hebɛɛbɑn bweserɑ yɑrɑ, kɑ Mɑɑkiɛli wìn min di Mɑɑkiɛlibɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asɛɛ u bii tɔn kurɔ mɔ wi bɑ sokumɔ Serɑki. ");
INSERT INTO bba_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Be bɑ sɑ̃ɑ Asɛɛn bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weerɑɑkuru kɑ itɑ kɑ tɔmbu nɛɛru (53.400). ");
INSERT INTO bba_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Be bɑ Nɛfitɑlin bwese kɛri toruɑ, berɑ Yɑsiɛli, wìn min di Yɑsiɛlibɑn bweserɑ yɑrɑ, kɑ Guni wìn min di Gunibɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Kɑ Yesɛɛ wìn min di Yesɛɛbɑn bweserɑ yɑrɑ, kɑ Silɛmu wìn min di Silɛmubɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Be bɑ sɑ̃ɑ Nɛfitɑlin bwese kɛri, berɑ mi. Ben ɡeerɑ sɑ̃ɑwɑ tɔmbu nɔrɔbun subɑ weeru kɑ nɔɔbu kɑ tɔmbu nɛɛru (45.400). ");
INSERT INTO bba_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Isireli be bɑ ɡɑrɑ mi, be kpuron ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ nɑtɑ kɑ tiɑ kɑ tɔmbu nɑtɑ kɑ wunɔbu kɑ tɛnɑ (601.730). ");
INSERT INTO bba_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ. ");
INSERT INTO bba_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","A bwese kɛri yi tem mɛ bɔnu kuo nɡe mɛ yin ɡeerɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Bwese kɛrɑ yèn tɔmbɑ dɑbiru bo, ɑ ye tem wɛ̃ɛyɔ mu n kpɑ̃. Bwese kɛrɑ yèn tɔmbɑ kun mɑɑ dɑbi kpɑ ɑ ye tem wɛ̃ fiiko. A yen bɑɑyere tem wɛ̃ɛyɔ nɡe mɛ yen tɔmbɑ ɡeeru nɛ. ");
INSERT INTO bba_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Adɑmɑ kɑɑ bu tem mɛ bɔnu kuɑwɑ kɑ tɛtɛ ɑ bu wɛ̃ bwese kɛrɑ kɑ bwese kɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Bɑ koo tem mɛ bɔnu kowɑ kɑ tɛtɛ bu kɑ bwese kɛrɑ bɑɑyere wɛ̃ nɡe mɛ yen tɔmbɑ ɡeeru nɛ. ");
INSERT INTO bba_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lefin bweseru sɔɔ, be bɑ ɡɑrɑ, berɑ Gɛɛsɔni wìn min di Gɛɛsɔnibɑn bwese kɛrɑ yɑrɑ, kɑ Kehɑti wìn min di Kehɑtibɑn bweserɑ yɑrɑ, kɑ Mɛrɑri wìn min di Mɛrɑribɑn bweserɑ yɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Be bɑ sɑ̃ɑ Lefin bwese kɛri, berɑ Libinɑn yɛnuɡibu, kɑ Heboronin yɛnuɡibu kɑ Mɑkirin yɛnuɡibu, kɑ Musin yɛnuɡibu, kɑ Koren yɛnuɡibu, Kehɑtiwɑ u Amurɑmu mɑrɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","Amurɑmun kurɔn yĩsirɑ Yokebɛdi. U sɑ̃ɑwɑ Lefin bii wi u mɑrɑ Eɡibitiɔ. Bii be u Amurɑmu mɑruɑ, berɑ Aroni, kɑ Mɔwisi, kɑ Mɑriɑmu ben sesu. ");
INSERT INTO bba_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Bii be Aroni u mɑrɑ, berɑ Nɑdɑbu, kɑ Abihu, kɑ Eleɑsɑɑ, kɑ Itɑmɑɑ. ");
INSERT INTO bba_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Adɑmɑ Nɑdɑbu kɑ Abihu bɑ ɡuwɑ sɑnɑm mɛ bɑ kɑ dɔ̃ɔ tuko duɑ Yinni Gusunɔn sɑ̃ɑ yerɔ bu kɑ yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Tɔn durɔ be bɑ suru tiɑ tiɑ mɔ bɑ ɡɑrɑ kɑ be bɑ mɛ kere, ben ɡeerɑ kuɑwɑ tɔmbu nɔrɔbun subɑ yɛndɑ itɑ (23.000). Bɑǹ bu ɡɑrɑ sɑnɑm mɛ bɑ Isirelibɑ ɡɑrimɔ domi bɑǹ kɑ bu tem bɔnu mɔ̀. ");
INSERT INTO bba_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Isireli be Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑ bɑ ɡɑrɑ Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, Yerikon deedeeru, berɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Isireli be kpuro sɔɔ, ɡoo sɑri mi, wi Mɔwisi kɑ yɑ̃ku kowo Aroni bɑ rɑɑ ɡɑrɑ Sinɑin ɡbɑburɔ, ");
INSERT INTO bba_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","mɑ n kun mɔ Kɑlɛbu, Yɛfunɛn bii kɑ Yosue, Nunin bii. Domi nɡe mɛyɑ Yinni Gusunɔ u rɑɑ bu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Selofɑdi, wi u sɑ̃ɑ Hefɛɛ kɑ Gɑlɑdi kɑ Mɑkiri kɑ Mɑnɑsen sikɑdobu Yosɛfun bweseru sɔɔ, u bii tɔn kurɔbu nɔɔbu mɑrɑ. Berɑ Mɑlɑ kɑ Nɔɑ kɑ Hoɡulɑ kɑ Milikɑ kɑ Tirisɑ ");
INSERT INTO bba_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","mɑ be, bɑ nɑ Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑn mi, kɑ wiruɡibun mi kɑ sere Isirelibɑ kpuron mi Yinni Gusunɔn sɑ̃ɑ yerun kɔnnɔwɔ bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","bɛsɛn tundo u ɡuwɑ ɡbɑburɔ. Uǹ wɑ̃ɑ Koren bibun wuuru sɔɔ be bɑ Yinni Gusunɔ seesi. U ɡuwɑ win tii tiin torɑnun sɔ̃. Adɑmɑ uǹ bii tɔn durɔ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","N weenɛ bu win bwese kɛrɑ deri yèn sɔ̃ uǹ bii tɔn durɔ mɔ? I sun tem wɛ̃ɛyɔ bɛsɛn tundon mɑɑbu kɑ wɔnɔbun suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Mɑ Mɔwisi u Yinni Gusunɔ kɑnɑ ben ɡɑri yin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mɑ Yinni Gusunɔ u nùn wisɑ u nɛɛ. ");
INSERT INTO bba_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","Selofɑdin bii be, bɑ ɡem mɔ. A bu tem wɛ̃ɛyɔ mɛ ben tundo u ko n dɑɑ mɔ. Kɑɑ bu mu wɛ̃wɑ ben tundon mɑɑbu kɑ wɔnɔbun suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Yen biru, kpɑ ɑ Isirelibɑ sɔ̃ ɑ nɛɛ, ɡoo ù n ɡu mɑ uǹ bii tɔn durɔ mɔ, win bii tɔn kurɔwɑ u koo win ɑrumɑni suɑ u tubi di. ");
INSERT INTO bba_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Ù kun mɑɑ bii tɔn kurɔ mɔ, win mɑɑbu kɑ wɔnɔbɑ bɑ koo win ɑrumɑni suɑ bu tubi di. ");
INSERT INTO bba_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Ù kun mɑɑ mɑɑbu kɑ wɔnɔbu mɔ, win tundon mɑɑbu kɑ wɔnɔbɑ bɑ koo win ɑrumɑni suɑ bu tubi di. ");
INSERT INTO bba_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Win tundo ù kun mɑɑ mɑɑbu kɑ wɔnɔbu mɔ, win mɛro bisi wi u fɛ̃ɛ fɛ̃ɛ bo wiyɑ u koo win ɑrumɑni tubi di. Yeni yɑ ko n sɑ̃ɑwɑ woodɑ Isirelibɑ sɔɔ nɡe mɛ nɛ, Yinni Gusunɔ nɑ ye Mɔwisi wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ɑ yɔɔwo Abɑrimun ɡuu tenin wii kpiirɔ, kpɑ ɑ nɔni seeyɑ ɑ tem mɛ mɛɛri mɛ kon Isirelibɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Yen biru, kpɑ ɑ kpunɑ ɑ ɡbi nɡe mɛ wunɛn mɔɔ Aroni u ɡu. ");
INSERT INTO bba_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","Domi iǹ woodɑbɑ mɛm nɔɔwɛ Sinin ɡbɑburɔ, sɑnɑm mɛ Isirelibɑ bɑ mɑn seesi. Iǹ mɑɑ mɑn bɛɛrɛ wɛ̃ ben wuswɑɑɔ sɑnɑm mɛ bɑ nim kɑnɑmɔ. Yerɑ n derɑ nɑ Mɛribɑn nim mɛ sokɑ Sɑnnɔn nim Kɑdɛsiɔ, Sinin ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Mɑ Mɔwisi u Yinni Gusunɔ sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","17","Yinni Gusunɔ, wunɛ wi ɑ tɑkɑ koorɑ kpuro hunde wɛ̃, ɑ ɡoo ɡɔsio, ɑ nùn ko wiruɡii wi u koo kpĩ u wunɛn tɔmbu kpɑrɑ kpɑ bɑ kun kɑ sɑ̃ɑ nɡe yɑ̃ɑ ni nuǹ kpɑro mɔ. ");
INSERT INTO bba_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Mɑ Yinni Gusunɔ u Mɔwisi wisɑ u nɛɛ, Yosue Nunin bii wee, wì sɔɔ nɛn Hunde u yibɑ. A nùn suo kpɑ ɑ nùn nɔmɑ sɔndi. ");
INSERT INTO bba_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Kɑɑ kɑ nùn dɑwɑ yɑ̃ku kowo Eleɑsɑɑn wuswɑɑɔ, kpɑ ɑ nùn ko wunɛn kɔsire Isirelibɑ kpuron nɔni biru. ");
INSERT INTO bba_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","A nùn wunɛn yiikon bɔnu wɛ̃ɛyɔ kpɑ Isirelibɑ kpuro bu nùn mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Yɑ̃ku kowo Eleɑsɑɑwɑ u ko n dɑ wɑ kpɑ Eleɑsɑɑ u mɑn kɑnɑ win sɔ̃ kɑ woro te bɑ rɑ ko kɑ urimu. Win ɡɑriyɑ Yosue kɑ Isirelibɑ kpuro bɑ ko n dɑ kɑ sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Mɑ Mɔwisi u kuɑ ye Yinni Gusunɔ u nùn sɔ̃ɔwɑ. U Yosue suɑ mɑ u kɑ nùn dɑ yɑ̃ku kowo Eleɑsɑɑn wuswɑɑɔ Isirelibɑ kpuron nɔni biru. ");
INSERT INTO bba_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Mɑ u nùn nɔmɑ sɔndi u nùn kuɑ win kɔsire nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","ɑ Isirelibɑ woodɑ yeni wɛ̃ɛyɔ. A nɛɛ, bu ku duɑri sɑɑ ye nɑ yi bɑ n dɑ kɑ mɑn kɛ̃nu nɑɑwɛ kpɑ bu mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ ni nu koo mɑn nuburu dore. ");
INSERT INTO bba_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","A bu sɔ̃ɔwɔ ɑ nɛɛ, tɔ̃ɔ bɑɑtere, yɑ̃ɑ kpɛmminu yiru ni nu wɔ̃ɔ tiɑ tiɑ mɔ kpɑ nu kun ɑlebu ɡɑɑ mɔ, niyɑ bɑ koo kɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Bɑ koo kɑ teeru yɑ̃kuru kowɑ bururu, teeru mɑɑ yoki kpɑɑ, ");
INSERT INTO bba_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","kɑ som kilo itɑ mɛ bɑ burinɑ kɑ olifin ɡum ditiri tiɑ kɑ bɔnu. ");
INSERT INTO bba_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Tɔ̃ɔ bɑɑteren yɑ̃ku te, tɑ ko n sɑ̃ɑwɑ nɡe yɑ̃ku nubu duroruɡii te bɑ nɛ, Yinni Gusunɔ kuɑ Sinɑin ɡuurɔ. ");
INSERT INTO bba_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Bururu bɑ ko n dɑ kɑ tɑm nɛwɑ ditiri tiɑ kɑ bɔnu nɛn sɑ̃ɑ yerɔ bu kɑ yɑ̃kuru ko kɑ yɑ̃ɑ te sɑnnu. ");
INSERT INTO bba_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Yokɑ, kpɑ bu mɑɑ mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑ kɑ yɑ̃ɑ tee te tɑ tie kɑ som kɑ tɑm nɡe mɛ bɑ rɑɑ kuɑ bururu. Tɑ ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru te tɑ koo nɛ, Yinni Gusunɔ nuburu dore. ");
INSERT INTO bba_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","Tɔ̃ɔ wɛ̃rɑruɡiru sɔɔ, yɑ̃ɑnu yiru ni nu wɔ̃ɔ tiɑ tiɑ mɔ mɑ nuǹ ɑlebu ɡɑɑ mɔ, niyɑ i ko i kɑ nɛ, Yinni Gusunɔ yɑ̃kuru kuɑ kɑ tɑm kɑ som kilo nɔɔbɑ tiɑ mɛ bɑ burinɑ kɑ ɡum. ");
INSERT INTO bba_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","I ko i n dɑ yɑ̃ku te kowɑ tɔ̃ɔ wɛ̃rɑruɡiru sɔɔ tɔ̃ɔ bɑɑteren yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii ni i rɑ ko bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","Suru bɑɑwuren tɔ̃ɔ ɡbiikiru sɔɔ, i ko i nɛ, Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑwɑ kɑ nɑɑ kpɛmi yiru, kɑ yɑ̃ɑ kinɛru, kɑ yɑ̃ɑ kpɛmminu nɔɔbɑ yiru, ni nu wɔ̃ɔ tiɑ mɔ. Kpɑ sɑbe nin bɑɑtere tɑ kun ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","I ko i kɑ ten bɑɑtere yɑ̃kuru kowɑ kɑ som mɛ bɑ burinɑ kɑ ɡum. ");
INSERT INTO bba_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","Yɑ̃ɑ kpɛmmii nin bɑɑtere mɑɑ kɑ som kilo itɑ mɛ bɑ burinɑ kɑ ɡum. Yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii niyɑ nu koo nɛ Yinni Gusunɔ nuburu dore. ");
INSERT INTO bba_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Ì n kɑ kɛtɛ yɑ̃kuru mɔ̀, tɑm ditiri itɑwɑ i ko i kɑ ko. Ì n kɑ yɑ̃ɑ kinɛru mɔ̀, tɑm ditiri yiruwɑ i ko i kɑ ko. Ì n mɑɑ kɑ yɑ̃ɑ kpɛmbu mɔ̀, tɑm ditiri tiɑ kɑ bɔnuwɑ i ko i kɑ ko. Yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii ni i ko i n dɑ ko wɔ̃ɔn suru bɑɑwuren tɔ̃ɔ ɡbiikiru sɔɔ, niyɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Yen biru, i ko i mɑɑ nɛ, Yinni Gusunɔ torɑrun yɑ̃kuru kuɑ kɑ tɔ̃ɔ bɑɑteren yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kɑ ten tɑm bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","Wɔ̃ɔn suru ɡbiikoon sɔ̃ɔ wɔkurɑ nnɛse sɔɔrɑ i ko i Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru di, nɛ, Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Suru win sɔ̃ɔ wɔkurɑ nɔɔbuse sɔɔrɑ i ko i tɔ̃ɔ bɑkɑru tore te i ko i di sɔ̃ɔ nɔɔbɑ yiru. Tɔ̃ɔ ni sɔɔ, pɛ̃ɛ ye bɑǹ seeyɑtiɑ dokewɑ i ko i di. ");
INSERT INTO bba_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Tɔ̃ɔ bɑkɑ ten tɔ̃ɔ ɡbiikiru sɔɔ, i ko i bɛɛn sɔmɑ deriwɑ, kpɑ i mɛnnɑ i nɛ, Yinni Gusunɔ sɑ̃. ");
INSERT INTO bba_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","I ko i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑwɑ kɑ nɑɑ kpɛmi yiru, kɑ yɑ̃ɑ kinɛru, kɑ yɑ̃ɑ kpɛmminu nɔɔbɑ yiru, ni nu wɔ̃ɔ tiɑ mɔ, kpɑ sɑbe nin bɑɑtere tɑ kun ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","I ko i kɑ yɑɑ sɑberu bɑɑtere yɑ̃kuru kowɑ kɑ som sɑnnu mɛ bɑ burinɑ kɑ ɡum. Ì n yɑ̃kuru mɔ̀ kɑ nɑɑ, som kilo nɔɔbɑ nnɛwɑ i ko i kɑ ko. Ì n kɑ yɑ̃ɑ kinɛru mɔ̀ som kilo nɔɔbɑ tiɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","Ì n mɑɑ kɑ yɑ̃ɑ kpɛmbu mɔ̀, som kilo itɑwɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Yen biru, kpɑ i boo kinɛru ɡo i kɑ torɑrun yɑ̃kuru ko. ");
INSERT INTO bba_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Yɑ̃ku ni kpurowɑ i ko i n dɑ ko tɔ̃ɔ bɑɑteren bururun yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Sɔ̃ɔ nɔɔbɑ yiru ye sɔɔ, i ko i nɛ, Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kuɑwɑ bɑɑdommɑ te tɑ koo mɑn nuburu dore tɔ̃ɔ bɑɑteren bururun yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Yen sɔ̃ɔ nɔɔbɑ yiruse, i ko i bɛɛn sɔmɑ deriwɑ kpɑ i mɛnnɑ i mɑn sɑ̃. ");
INSERT INTO bba_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","Gɛ̃ɛbun tɔ̃ɔ bɑkɑru sɔɔ, i ko i kɑ nɛ, Yinni Gusunɔ bɛɛn ɡbeɑn dĩɑ ɡbiikinu nɑɑwɑwɑ kpɑ i mɛnnɑ i mɑn sɑ̃. Iǹ dɔmɑ te sɔmburu ɡɑru mɔ̀. ");
INSERT INTO bba_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","I ko i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑwɑ ni nu nuburu do kɑ nɑɑ kpɛmi yiru, kɑ yɑ̃ɑ kinɛru, kɑ yɑ̃ɑ kpɛmminu nɔɔbɑ yiru ni nu wɔ̃ɔ tiɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","I ko i kɑ yɑɑ sɑberu bɑɑtere yɑ̃kuru kowɑ kɑ som sɑnnu mɛ bɑ burinɑ kɑ ɡum. Ì n yɑ̃kuru mɔ̀ kɑ nɑɑ, som kilo nɔɔbɑ nnɛwɑ i ko i kɑ ko. Ì n kɑ yɑ̃ɑ kinɛru mɔ̀ som kilo nɔɔbɑ tiɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Ì n mɑɑ kɑ yɑ̃ɑ kpɛmbu mɔ̀ som kilo itɑwɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Yen biru, kpɑ i boo ɡo i kɑ torɑrun yɑ̃kuru ko, ");
INSERT INTO bba_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","yɑ̃ku ni kpurowɑ i ko i n dɑ ko tɔ̃ɔ bɑɑteren bururun yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te bɑɑsi. Yɑɑ sɑbe ni nuǹ ɑlebu ɡɑɑ mɔwɑ i ko i n dɑ kɑ yɑ̃kuru ko, kɑ tɑm sɑnnu. ");
INSERT INTO bba_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","Suru nɔɔbɑ yirusen tɔ̃ɔ ɡbiikiru sɔɔ, i ku sɔmburu ɡɑru ko. I ko i mɛnnɑwɑ i Yinni Gusunɔ tɑkɑru ko. I ko i tɔ̃ɔ te diwɑ i n kɔbi soomɔ. ");
INSERT INTO bba_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","I ko Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ ni nu koo nùn nuburu dore, kɑ kɛtɛ kpɛmɑ, kɑ yɑ̃ɑ kinɛru, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔ̃ɔ tiɑ tiɑɡinu nɔɔbɑ yiru. Yɑɑ sɑbe ni kpuro nu ko n sɑ̃ɑwɑ ni nuǹ ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","I ko i kɑ yɑɑ sɑbe ten bɑɑtere yɑ̃kuru kowɑ kɑ som mɛ bɑ burinɑ kɑ ɡum. Ì n yɑ̃kuru mɔ̀ kɑ kɛtɛ, som kilo nɔɔbɑ nnɛwɑ i ko i kɑ ko. Ì n mɔ̀ kɑ yɑ̃ɑ kinɛru, som kilo nɔɔbɑ tiɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","Ì n mɑɑ mɔ̀ kɑ yɑ̃ɑ kinɛ kpɛmbu, som kilo itɑwɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","I ko i mɑɑ torɑrun yɑ̃kuru ko kɑ boo kinɛru. ");
INSERT INTO bba_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Yɑ̃ku niniwɑ i ko i n dɑ ko suru bɑɑwuren tɔ̃ɔ ɡbiikiruɡinu kɑ tɔ̃ɔ bɑɑtereɡinu kɑ nin som kɑ tɑm bɑɑsi. I ko nu kowɑ nɡe mɛ bɑ nin woodɑ yi. Nu ko n sɑ̃ɑwɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu ni nu koo nɛ, Yinni Gusunɔ nuburu dore. ");
INSERT INTO bba_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkuruse sɔɔ, i ku sɔmburu ɡɑru ko. I ko i mɛnnɑwɑ i Yinni Gusunɔ sɑ̃ kpɑ i nɔɔ bɔke. ");
INSERT INTO bba_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","I ko i Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑwɑ ni nu koo nùn nuburu dore, kɑ nɑɑ kpɛmɑ, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔ̃ɔ tiɑ tiɑɡinu nɔɔbɑ yiru. Yɑɑ sɑbe ni kpuro nu ko n sɑ̃ɑwɑ ni nuǹ ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Ì n yɑ̃kuru mɔ̀, i ko i nu kowɑ kɑ som mɛ bɑ burinɑ kɑ ɡum. Ì n yɑ̃kuru mɔ̀ kɑ nɑɑ, som kilo nɔɔbɑ nnɛwɑ i ko i kɑ ko. Ì n mɔ̀ kɑ yɑ̃ɑ kinɛru som kilo nɔɔbɑ tiɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","Ì n mɑɑ mɔ̀ kɑ yɑ̃ɑ kinɛ kpɛmbu, som kilo itɑwɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Yɑ̃ku ninin biru, i ko i yɑ̃kuru ko kɑ boo kinɛru bu kɑ bɛɛ bɛɛn durum wɔkɑ, torɑrun yɑ̃kuru kɑ tɔ̃ɔ bɑɑtereɡiru kɑ nin som kɑ tɑm bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","Suru nɔɔbɑ yirusen sɔ̃ɔ wɔkurɑ nɔɔbuse sɔɔ, i bɛɛn sɔmɑ derio ye i rɑ ko, kpɑ i mɛnnɑ i nɛ, Yinni Gusunɔ sɑ̃ kpɑ i mɑn tɔ̃ɔ bɑkɑru diiyɑ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Tɔ̃ɔ bɑkɑ ten tɔ̃ɔ ɡbiikiru sɔɔ, i ko i nɛ, Yinni Gusunɔ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑwɑ ni nu koo mɑn nuburu dore. I ko i nu kowɑ kɑ nɑɑ kpɛmi wɔkurɑ itɑ kɑ yɑ̃ɑ kinɛnu yiru, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ ni nu wɔ̃ɔ tiɑ tiɑ mɔ. Yɑɑ sɑbe ni kpuro nu ko n sɑ̃ɑwɑ ni nuǹ ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","I ko i kɑ yɑɑ sɑbe nin bɑɑtere yɑ̃kuru kowɑ kɑ som mɛ bɑ burinɑ kɑ ɡum. Ì n yɑ̃kuru mɔ̀ kɑ nɑɑ, som kilo nɔɔbɑ nnɛwɑ i ko i kɑ ko. Ì n mɔ̀ kɑ yɑ̃ɑ kinɛru, som kilo nɔɔbɑ tiɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","Ì n mɑɑ mɔ̀ kɑ yɑ̃ɑ kinɛ kpɛmbu, som kilo itɑwɑ i ko i kɑ ko. ");
INSERT INTO bba_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","I ko i mɑɑ yɑ̃kuru ko kɑ boo kinɛru bu kɑ bɛɛ bɛɛn durum wɔkɑ, tɔ̃ɔ bɑɑteren yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡii te i rɑ ko kɑ som kɑ tɑm sɑnnu bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","34","Tɔ̃ɔ bɑɑteren yɑ̃ku ni bɑɑsi, i ko i mɑɑ yɑ̃kunu ko kɑ yɑɑ sɑbe ni nuǹ ɑlebu ɡɑɑ mɔ kɑ mɑɑ som mɛ bɑ burinɑ kɑ ɡum, nɡe mɛ i rɑ ko sɑɑ tɔ̃ɔ bɑkɑ ten sɔ̃ɔ yirusen di n kɑ ɡirɑri ten sɔ̃ɔ nɔɔbɑ yiruse. Nɡe mɛniwɑ i ko i yɑ̃ku ni koosinɑ. Sɔ̃ɔ yiruse sɔɔ, i ko i yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ kpɛnnu wɔkurɑ yiru kɑ yɑ̃ɑ kinɛnu yiru, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ wɔ̃ɔ tiɑ tiɑɡinu kɑ mɑɑ boo kinɛru. Sɔ̃ɔ itɑse sɔɔ, i ko i yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ kpɛnnu wɔkurɑ tiɑ kɑ yɑ̃ɑ kinɛnu yiru, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ, wɔ̃ɔ tiɑ tiɑɡinu kɑ mɑɑ boo kinɛru. Sɔ̃ɔ nnɛse sɔɔ, i ko i yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ kpɛnnu wɔkuru, kɑ yɑ̃ɑ kinɛnu yiru kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ, wɔ̃ɔ tiɑ tiɑɡinu, kɑ boo kinɛru. Sɔ̃ɔ nɔɔbuse sɔɔ, i ko i yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ kpɛnnu nɔɔbɑ nnɛ kɑ yɑ̃ɑ kinɛnu yiru, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ, wɔ̃ɔ tiɑ tiɑɡinu, kɑ boo kinɛru. Sɔ̃ɔ nɔɔbɑ tiɑse, i ko i yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ kpɛnnu nɔɔbɑ itɑ kɑ yɑ̃ɑ kinɛnu yiru kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ, wɔ̃ɔ tiɑ tiɑɡinu, kɑ boo kinɛru. Sɔ̃ɔ nɔɔbɑ yiruse sɔɔ, i ko i yɑ̃kuru kowɑ kɑ kɛtɛ kinɛ kpɛnnu nɔɔbɑ yiru, kɑ yɑ̃ɑ kinɛnu yiru, kɑ yɑ̃ɑ kinɛ kpɛmminu wɔkurɑ nnɛ, wɔ̃ɔ tiɑ tiɑɡinu, kɑ boo kinɛru. ");
INSERT INTO bba_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","Tɔ̃ɔ bɑkɑ ten sɔ̃ɔ nɔɔbɑ itɑse sɔɔ, i bɛɛn sɔmɑ derio ye i rɑ ko, kpɑ i mɛnnɑ i kɑ nɛ, Yinni Gusunɔ sɑ̃, ");
INSERT INTO bba_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","kpɑ i mɑn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuɑ ni nu koo mɑn nuburu dore, kɑ kɛtɛ kinɛru, kɑ yɑ̃ɑ kinɛru kɑ yɑ̃ɑ kinɛ kpɛmminu nɔɔbɑ yiru wɔ̃ɔ tiɑ tiɑɡinu. Yɑɑ sɑbe ni kpuro nu ko n sɑ̃ɑwɑ ni nuǹ ɑlebu ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","I ko i yɑ̃ku nin bɑɑtere kowɑ kɑ som kɑ tɑm nɡe mɛ bɑ yen woodɑ yi. ");
INSERT INTO bba_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Kpɑ i mɑɑ yɑ̃kuru ko kɑ boo kinɛru bu kɑ bɛɛ bɛɛn durum wɔkɑ, tɔ̃ɔ bɑɑteren yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru kɑ ten som kɑ tɑm bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","Yɑ̃ku nini kpurowɑ i ko i nɛ, Yinni Gusunɔ kuɑ tɔ̃ɔ bɑkɑ te sɔɔ, kɑ sere mɑɑ yɑ̃ku ni i rɑ ko bɑɑdommɑ. Niyɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu ni i rɑ ko kɑ som kɑ tɑm, kɑ siɑrɑbun yɑ̃kunu, kɑ kɛ̃nu, kɑ sere mɑɑ ni i rɑ ko nɔɔ mwɛɛrun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Yeniwɑ Mɔwisi u Isirelibɑ kpuro sɔ̃ɔwɑ nɡe mɛ Yinni Gusunɔ u nùn yiire. ");
INSERT INTO bba_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Mɔwisi u Isirelibɑn bwese kɛrin wiruɡibu sɔ̃ɔwɑ u nɛɛ, wee woodɑ ye Yinni Gusunɔ u wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","U nɛɛ, ɡoo ù n nɔɔ mwɛɛru kuɑ mɑ u koo nùn kɛ̃ru wɛ̃, ǹ kun mɛ ù n bɔ̃ruɑ u nɛɛ, u koo tii nɛnɛ ɡɑ̃ɑnu ɡɑnun sɔ̃, uǹ win ɡɑri yi kɔbiɑmɔ. U koo win nɔɔ mwɛɛ te yibiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","Bii wɔndiɑ ù n Yinni Gusunɔ nɔɔ mwɛɛru kuɑ, ǹ kun mɛ, ù n bɔ̃ruɑ sɑnɑm mɛ u ɡinɑ wɑ̃ɑ win tundon nɔmɑ sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","mɑ tundo wi, uǹ nùn ye yinɑri sɑnɑm mɛ u yen ɡɑri nuɑ, sɑɑ ye sɔɔ, wɔndiɑ wi, u koo win nɔɔ mwɛɛ te yibiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","Adɑmɑ win tundo ù n nùn ye yinɑri sɑnɑm mɛ u yen ɡɑri nuɑ, sɑɑ ye sɔɔ, wɔndiɑ wi, uǹ mɑɑ nɔɔ mwɛɛ te yibiɑmɔ. Yinni Gusunɔ u koo nùn yen suuru kuɑ, domi win tundowɑ u nùn ye yinɑri. ");
INSERT INTO bba_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","Wɔndiɑ ɡoo ù n nɔɔ mwɛɛru kuɑ, ǹ kun mɛ ù n bɔ̃ruɑ n deemɑ uǹ bwisikɑ sɑɑ ye u bɔ̃ri yi mɔ̀, yen biru mɑ u durɔ suɑ, ");
INSERT INTO bba_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","mɑ win durɔ kun nùn ye yinɑri sɑnɑm mɛ u yen ɡɑri nuɑ, u koo win nɔɔ mwɛɛ te yibiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","Adɑmɑ win durɔ ù n ye yinɑ sɑnɑm mɛ u yen ɡɑri nuɑ, uǹ mɑɑ nɔɔ mwɛɛ te yibiɑmɔ te u kuɑ. Yinni Gusunɔ u koo mɑɑ nùn suuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","Tɔn kurɔ wìn durɔ ɡu, ǹ kun mɛ wi kɑ durɔ bɑ yinɑnɑ, ù n nɔɔ mwɛɛru kuɑ, u koo tu yibiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","Kurɔ mɔro ɡoo ù n nɔɔ mwɛɛru kuɑ, ǹ kun mɛ ù n bɔ̃ruɑ, ");
INSERT INTO bba_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","mɑ win durɔ kun nùn ye yinɑri sɑnɑm mɛ u yen ɡɑri nuɑ, kurɔ wi, u koo win nɔɔ mwɛɛ te yibiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Adɑmɑ win durɔ ù n nùn ye yinɑri sɑnɑm mɛ̀ sɔɔ u yen ɡɑri nuɑ, kurɔ wi, uǹ mɑɑ nɔɔ mwɛɛ te yibiɑmɔ. Yinni Gusunɔ u koo nùn suuru kuɑ domi win durɔwɑ u nùn ye yinɑri. ");
INSERT INTO bba_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Kurɔ mɔro ù n nɔɔ mwɛɛru kuɑ, ǹ kun mɛ ù n bɔ̃ruɑ u nɛɛ, u koo tii nɛnɛ ɡɑ̃ɑnu ɡɑnun sɔ̃, win durɔwɑ u koo de nɔɔ mwɛɛ te, tu koorɑ, ǹ kun mɛ tu wɔrumɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Sɑnɑm mɛ durɔ wi, u ɡɑri yi nuɑ, ù kun ye yinɛ, u yi wurɑwɑ. Kurɔ wi, u koo nɔɔ mwɛɛ te yibiɑwɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Adɑmɑ durɔ wi, ù n derɑ n tɛ u sere nùn ye yinɑri, durɔ wiyɑ u koo yen tɑɑrɛ wɑ. ");
INSERT INTO bba_vpl VALUES ("NU30_17","005_30_17","NUM","30","17","17","Woodɑ yeniwɑ Yinni Gusunɔ u Mɔwisi wɛ̃ wɔndiɑ kɑ win tundon sɔ̃, kɑ sere mɑɑ kurɔ mɔro kɑ win durɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","ɑ doo ɑ Mɑdiɑnibɑ mɔru kɔsiɑ kɔ̃sɑ ye bɑ Isirelibɑ kuɑn sɔ̃. Yen biruwɑ kon de ɑ kpunɑ ɑ ɡbi ɑ wunɛn bɑɑbɑbɑ deemɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Mɑ Mɔwisi u tɔn be sɔ̃ɔwɑ u nɛɛ, ɡɑbu bu ben tɑbu yɑ̃nu sebuo bu dɑ bu Mɑdiɑnibɑ wɔri kpɑ bu bu mɔru kɔsiɑ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Yen sɔ̃, bwese kɛrɑ bɑɑyere yu tɑbu kowobu nɔrɔbu (1.000) ɡɔsio. ");
INSERT INTO bba_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Mɑ Isirelibɑn bwese kɛrɑ bɑɑyere yɑ tɔmbu nɔrɔbu ɡɔsɑ. Mɑ ben ɡeerɑ kuɑ tɑbu kowobu nɔrɔbun subɑ wɔkurɑ yiru (12.000). ");
INSERT INTO bba_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Mɑ Mɔwisi u tɑbu kowobu nɔrɔbun subɑ wɔkurɑ yiru ye tɑbu ɡɔrɑ. Bɑ dɑwɑ kɑ Finɛɛsi, yɑ̃ku kowo Eleɑsɑɑn bii, u Yinni Gusunɔn kurun dendi yɑ̃nu nɛni kɑ kɔbi sɑnnu. ");
INSERT INTO bba_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Mɑ bɑ Mɑdiɑnibɑ tɑbu wɔri nɡe mɛ Yinni Gusunɔ u rɑɑ Mɔwisi sɔ̃ɔwɑ, mɑ bɑ ben tɔn durɔbu kpuro ɡo. ");
INSERT INTO bba_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mɑ bɑ ben sinɑmbu nɔɔbu ye ɡo. Berɑ, Efi kɑ Rekɛmu kɑ Suri kɑ Huri kɑ Rebɑ. Bɑ mɑɑ Bɑlɑmu Beorin bii ɡo. ");
INSERT INTO bba_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Adɑmɑ bɑ ben kurɔbu kɑ bibu yoru mwɛɛrɑ mɑ bɑ ben yɑɑ sɑbenu kɑ ben ɑrumɑnibɑ ɡurɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Mɑ bɑ ben wusu kɑ ben kpɑrɑ yenu dɔ̃ɔ mɛni. ");
INSERT INTO bba_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Mɑ bɑ kɑ ye kpuro doonɑ ye bɑ ɡurɑ, tɔmbu kɑ yɑɑ sɑbenu. ");
INSERT INTO bba_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","Mɑ bɑ kɑ ye kpuro nɑ Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑ kɑ Isirelibɑ kpuron mi sɑnsɑniɔ, Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, Yerikon deedeeru. ");
INSERT INTO bba_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Yerɑ Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑ kɑ Isirelibɑn wiruɡibu bɑ yɑrɑ ben sɑnsɑnin di bɑ bu sennɔ dɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Yerɑ Mɔwisi u kɑ tɑbu sinɑmbu mɔru kuɑ, kɑ nɔrɔm nɔrɔm wiruɡibu, kɑ wunɔm wunɔm wiruɡibu, be bɑ tɑɑ bi dɑ bɑ wee. ");
INSERT INTO bba_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","U nɛɛ, mbɑn sɔ̃nɑ i tɔn kurɔbu deri iǹ bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","I yɛ̃ mɑ berɑ Bɑlɑmu u bɔrie mɑ bɑ derɑ Isirelibɑ bɑ Yinni Gusunɔ torɑri Peorin ɡɑri sɔɔ, mɑ Yinni Gusunɔ u bu kɛ̃si kɛ̃si bɑrɑru sure. ");
INSERT INTO bba_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Yen sɔ̃ tɛ̃, i ben bii tɔn durɔbu kpuro ɡoowo kɑ tɔn kurɔ be bɑ durɔ yɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Adɑmɑ i tii wɔndiɑbɑ yiiyo be bɑǹ durɔ yɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","Be bɑ mɑɑ tɔnu ɡo, ǹ kun mɛ bɑ ɡoru bɑbɑ, bɑ koo yɑriwɑ sɑnsɑnin di sɔ̃ɔ nɔɔbɑ yiru, kpɑ bu tii dɛɛrɑsiɑ be kɑ ben yobu, sɔ̃ɔ itɑse kɑ sɔ̃ɔ nɔɔbɑ yiruse. ");
INSERT INTO bba_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","I ko i bɛɛn yɑ̃nu dɛɛrɑsiɑwɑ kɑ ɡɑ̃ɑnu kpuro ni bɑ kuɑ kɑ yɑɑ ɡɔnɑ, kɑ boo sɑnsu, kɑ sere mɑɑ ni bɑ kuɑ kɑ dɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Mɑ yɑ̃ku kowo Eleɑsɑɑ u tɑbu kowo be bɑ tɑbu dɑ mi sɔ̃ɔwɑ u nɛɛ, wee woodɑ ye Yinni Gusunɔ u Mɔwisi wɛ̃. U nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","wurɑ kɑ sii ɡeesu kɑ sii ɡɑndu kɑ sii wɔ̃kusu kɑ pɛɛrum, ");
INSERT INTO bba_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","sii si bɑ koo ɡesi kpĩ bu dɔ̃ɔ doke kpuro, i ko i su dɔ̃ɔ dokewɑ kpɑ i su dɛɛrɑsiɑ. Ye bɑǹ mɑɑ kpɛ̃ bu dɔ̃ɔ doke i ko i ye wɑsiwɑ dɛɛrɑsiɑbun nim sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","I ko i bɛɛn yɑ̃nu teɑwɑ sɔ̃ɔ nɔɔbɑ yiruse kpɑ i dɛɛrɑ. Yen biru i ko i kpĩ i wurɑmɑ sɑnsɑniɔ. ");
INSERT INTO bba_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","wunɛ kɑ yɑ̃ku kowo Eleɑsɑɑ kɑ Isirelibɑn yɛnu yɛ̃robu, i ɑrumɑni ye ɡɑrio ye Isirelibɑ bɑ mwɑɑmɑ mi, tɔmbu kɑ yɑɑ sɑbenu. ");
INSERT INTO bba_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","I ko i ye bɔnu kowɑ subɑ yiru yɑ n kpɑ̃ɑru nɛ, be bɑ tɑbu dɑɡiɑ kɑ be bɑǹ tɑbu deɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Be bɑ tɑbu dɑn bɔnu sɔɔ, wee ye i ko i wunɑ nɛ Yinni Gusunɔn sɔ̃. Yerɑ nɛɛrɑ wunɔbu (500) bɑɑyeren wɔllɔ i tiɑ wunɑ nɛn sɔ̃, tɔmbu sɔɔ kɑ kɛtɛbɑ sɔɔ, kɑ kɛtɛkunu sɔɔ, kɑ yɑ̃ɑnu kɑ bonu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Kpɑ ɑ ye yɑ̃ku kowo Eleɑsɑɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Be bɑǹ mɑɑ tɑbu den bɔnu sɔɔ, weerɑɑkuru bɑɑteren wɔllɔ, kɑɑ tiɑ tiɑ wunɑ nɛn sɔ̃ tɔmbu sɔɔ kɑ kɛtɛbɑ sɔɔ kɑ kɛtɛkunu sɔɔ kɑ yɑ̃ɑnu sɔɔ kɑ bonu sɔɔ, kɑ sere yɑɑ sɑbe ni nu tie sɔɔ, kpɑ ɑ ye Lefibɑ wɛ̃ be bɑ sɔmburu mɔ̀ nɛn sɑ̃ɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Mɑ Mɔwisi kɑ Eleɑsɑɑ bɑ kuɑ ye Yinni Gusunɔ u Mɔwisi yiire. ");
INSERT INTO bba_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Arumɑni ye bɑ ɡurɑ kpuro, yen ɡeeru wee. Yɑ̃ɑnu kɑ bonun ɡeerɑ sɑ̃ɑ nɔrɔbun subɑ nɑtɑ kɑ wɑtɑ kɑ wɔkurɑ nɔɔbu (675.000). ");
INSERT INTO bba_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","Kɛtɛbɑn ɡeerɑ sɑ̃ɑ nɔrɔbun subɑ wɑtɑ kɑ wɔkurɑ yiru (72.000). ");
INSERT INTO bba_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","Kɛtɛkunun ɡeerɑ sɑ̃ɑ nɔrɔbun subɑ wɑtɑ kɑ tiɑ (61.000). ");
INSERT INTO bba_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","Wɔndiɑbɑn ɡeerɑ mɑɑ sɑ̃ɑ nɔrɔbun subɑ tɛnɑ kɑ yiru, be bɑǹ durɔ yɛ̃ (32.000). ");
INSERT INTO bba_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Be bɑ tɑbu dɑn bɔnu yɑ kuɑ yɑ̃ɑnu nɔrɔbun subɑ ɡoobɑ wunɔbu kɑ tɛnɑ kɑ nɔɔbɑ yiru kɑ nɛɛrɑ wunɔbu (337.500). ");
INSERT INTO bba_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","Mi sɔɔ, bɑ nɑtɑ kɑ wɑtɑ kɑ wɔkurɑ nɔɔbu wunɑ Yinni Gusunɔn sɔ̃ (675). ");
INSERT INTO bba_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","Ben kɛtɛbɑn ɡeerɑ sɑ̃ɑ nɔrɔbun subɑ tɛnɑ kɑ nɔɔbɑ tiɑ (36.000). Mi sɔɔ, bɑ wɑtɑ kɑ wɔkurɑ yiru wunɑ Yinni Gusunɔ sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","Ben kɛtɛkunun ɡeerɑ sɑ̃ɑ nɔrɔbun subɑ tɛnɑ kɑ nɛɛrɑ wunɔbu (30.500). Mi sɔɔ, bɑ wɑtɑ kɑ tiɑ wunɑ Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","Tɔn be bɑ mwɛɛrɑn ɡeerɑ mɑɑ sɑ̃ɑ nɔrɔbun subɑ wɔkurɑ nɔɔbu kɑ tiɑ (16.000). Mi sɔɔ, bɑ tɛnɑ kɑ yiru wunɑ Yinni Gusunɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Mɑ Mɔwisi u Gusunɔɡiɑ kpuro yɑ̃ku kowo Eleɑsɑɑ wɛ̃ nɡe mɛ Gusunɔ u nùn sɔ̃ɔwɑ u ko. ");
INSERT INTO bba_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","43","Bɔnu ye bɑ Isireli be bɑ tie wɛ̃ yɑ nɛwɑ kɑ be bɑ tɑbu dɑɡiɑ. Yɑ sɑ̃ɑwɑ nɔrɔbun subɑ ɡoobɑ wunɔbu kɑ tɛnɑ kɑ nɔɔbɑ yiru kɑ nɛɛrɑ wunɔbu (337.500), ");
INSERT INTO bba_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","kɑ kɛtɛbɑ nɔrɔbun subɑ tɛnɑ kɑ nɔɔbɑ tiɑ (36.000) ");
INSERT INTO bba_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","kɑ kɛtɛkunu nɔrɔbun subɑ tɛnɑ kɑ nɛɛrɑ wunɔbu (30.500), ");
INSERT INTO bba_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","kɑ tɔmbu nɔrɔbun subɑ wɔkurɑ nɔɔbu kɑ tiɑ (16.000). ");
INSERT INTO bba_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Bɔnu ye Mɔwisi u Isireli be wɛ̃ sɔɔ, ye u wunɑ Yinni Gusunɔn sɔ̃, yerɑ tiɑ tiɑ weerɑɑkuru bɑɑteren wɔllɔ, tɔmbu sɔɔ, kɑ yɑɑ sɑbenu sɔɔ. Mɑ u ye kpuro Lefibɑ wɛ̃ be bɑ sɔmburu mɔ̀ sɑ̃ɑ yerɔ, nɡe mɛ Yinni Gusunɔ u nùn woodɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","Tɑbu kowobu nɔrɔm nɔrɔm wiruɡibu kɑ wunɔm wunɔm wiruɡibu bɑ mɛnnɑmɑ bɑ nɑ Mɔwisin mi. ");
INSERT INTO bba_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","Mɑ bɑ nùn sɔ̃ɔwɑ bɑ nɛɛ, sɑ tɑbu kowobu ɡɑrɑ be sɑ kpɑre. Bɑɑ tɔn turo uǹ kɑre be sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","Yen sɔ̃nɑ sɑ kɑ Yinni Gusunɔ tɑkɑrun kɛ̃nu nɑɑwɑ ni bɑ kuɑ kɑ wurɑ. Niyɑ sumi kɑ tɑɑminu kɑ swɑɑ tonkunu kɑ yɔni. Kpɑ nu n sɑ̃ɑ nɡe torɑrun yɑ̃kuru. ");
INSERT INTO bba_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","Mɑ Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑ bɑ kɛ̃ɛ ni kpuro mwɑ ni bɑ kuɑ kɑ wurɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","Kɛ̃ɛ ni tɑbu kowobun wiruɡii be, bɑ Yinni Gusunɔ wɛ̃ mi, nin bunum mu koo ko nɡe kilo wunɑɑ wɑtɑ kɑ wɔkurun sɑkɑ. ");
INSERT INTO bba_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","Adɑmɑ be bɑ sɑ̃ɑ tɑbu kowobu bɑ ben ɑrumɑni ye bɑ ɡurɑ tii yiiyɑwɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","Mɔwisi kɑ Eleɑsɑɑ bɑ kɑ kɛ̃ɛ ni kpuro dɑ bɑ yi Yinni Gusunɔn kurɔ, Yinni Gusunɔ u n kɑ win tɔmbu Isirelibɑ yɑɑye. ");
INSERT INTO bba_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","Rubɛnin bwese kɛrɑ kɑ Gɑdin bwese kɛrɑn tɔmbu bɑ yɑɑ sɑbenu mɔ nu dɑbi too. Mɑ bɑ wɑ mɑ Yɑsɛɛn tem kɑ Gɑlɑdin tem mu ɡeɑ sɑ̃ɑ ben yɑɑ sɑbenun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","Yerɑ bɑ dɑ bɑ Mɔwisi kɑ yɑ̃ku kowo Eleɑsɑɑ kɑ Isirelibɑn wiruɡibu deemɑ, bɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","wuu sini, Atɑrɔtu kɑ Diboni kɑ Yɑsɛɛ kɑ Nimurɑ kɑ Hɛsiboni kɑ Eleɑle kɑ Sebɑmu kɑ Nɛbo kɑ sere Beoni, ");
INSERT INTO bba_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","si Yinni Gusunɔ u derɑ bɛsɛ Isirelibɑ sɑ kɑmiɑ, sin tem mu ɡeɑ sɑ̃ɑ yɑɑ sɑbenun sɔ̃. Wee sɑ mɑɑ yɑɑ sɑbenu mɔ nu dɑbi. ");
INSERT INTO bba_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","Yen sɔ̃, ɑ̀ n kɑ sun nɔnu ɡeu mɛɛrɑn nɑ, ɑ de bu sun tem mɛ wɛ̃ bɛsɛ wunɛn sɔm kowobu. A ku de su Yuudɛni tɔburɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","Mɑ Mɔwisi u bu wisɑ u nɛɛ, bɛɛn mɛro bisibu bɑ koo dɑwɑ bɑ n tɑbu mɔ̀ kpɑ bɛɛ i n sɔ̃ mini? ");
INSERT INTO bba_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","Iǹ yɛ̃ mɑ i ko i bu mwiɑ kpɑnɑsiɑwɑ kpɑ bɑ kun kĩ bu dɑ tem mɛ Yinni Gusunɔ u bu wɛ̃ sɔɔ? ");
INSERT INTO bba_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","Nɡe mɛyɑ bɛɛn bɑɑbɑbɑ bɑ kuɑ yellu sɑnɑm mɛ sɑ wɑ̃ɑ Kɑdɛsi Bɑɑnɛɑɔ, ye nɑ bu ɡɔrɑ bɑ dɑ bɑ Kɑnɑnin tem sɑriɑ mɛɛrɑ. Ye bɑ dɑ bɑ turɑ sere Ɛsikolin wɔwɑɔ mɑ bɑ tem mɛn sɑriɑ mɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","Ye bɑ ɡɔsirɑmɑ, mɑ bɑ beɡibu Isirelibɑ mwiɑ kpɑnɑsiɑ bu ku kɑ dɑ tem mɛ Yinni Gusunɔ u bu wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","Yen tɔ̃ɔ te sɔɔ, Yinni Gusunɔ u mɔru bɛsirɑ mɑ u bɔ̃ruɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","tɔn be bɑ yɑrimɑ Eɡibitin di mi, be bɑ wɔ̃ɔ yɛndu mɔ kɑ be bɑ kere mɛ, ben ɡoo kun duɔ tem mɛ sɔɔ, mɛ u nɔɔ mwɛɛru kuɑ u Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu wɛ̃. Domi bɑ yinɑ bu win ɡere mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","Kɑlɛbu, Yɛfunɛn bii, Kenɑsin bweseru sɔɔ, kɑ sere Yosue, Nunin bii, be tɔnɑwɑ bɑ koo du tem mɛ sɔɔ yèn sɔ̃ bɑ nùn mɛm nɔɔwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","Yinni Gusunɔ u kɑ bɛɛn bɑɑbɑbɑ mɔru kuɑ mɑ u derɑ bɑ yɑɑyɑɑre kuɑ ɡbɑburɔ wɔ̃ɔ weeru sere be kpuro bɑ kɑ kpeerɑ, be, be bɑ kuɑ ye yɑǹ nùn wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","Wee, tɛ̃ bɛɛ, i kĩ i bɛɛn bɑɑbɑ ben yirɑ swĩi, kpɑ i de Yinni Gusunɔ u kpɑm mɔru bɛsirɑ kɑ bɛɛ Isirelibɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","Domi ì n ɡɛrɑ win swɑɑn di, u koo de bɛɛ kpuro i kpɑm tɛ ɡbɑburɔ. Sɑɑ ye sɔɔ, kpɑ i de bɛɛɡibu bu kɑm ko. ");
INSERT INTO bba_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","Mɑ bɑ Mɔwisi wisɑ bɑ nɛɛ, ɑɑwo. Sɑ ko bɛsɛn yɑɑ sɑbenu kɑrɑbɑ kuɑ kpɑ su mɑɑ wusu bɑni su ɡbɑ̃rɑnu toosi bɛsɛn kurɔbu kɑ bibun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","Yen biru, sɑ ko tɑbu yɑ̃nu suɑ kpɑ sɑ n ɡbiɑ su kɑ bɛsɛɡibu duusiɑ ben temɔ, mɛ bɑ bu wɛ̃. Sɑ ye sɔɔ, sɑ ko bɛsɛn kurɔbu kɑ bibu deriwɑ bɑ n wɑ̃ɑ wuu ɡbɑ̃rɑnuɡii si sɔɔ, tem mɛn tɔmbun sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","Sɑǹ wurɔ bɛsɛn yɛnusɔ mɑ n kun mɔ Isireli bɑɑwure u win tem mwɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","Sɑ̀ n tem mɛni wɑ ɡuru ɡee sɔ̃ɔ yɑri yeru mi, sɑǹ mɑɑ tem ɡɑm kĩ Yuudɛnin ɡuru ɡiɔ. ");
INSERT INTO bba_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","Mɑ Mɔwisi u bu sɔ̃ɔwɑ u nɛɛ, ǹ n mɛn nɑ, i de i bɛɛn nɔɔ mwɛɛru yibiɑ. I tɑbu yɑ̃nu suo kpɑ i dɑ i tɑbu ko kɑ wɛrɔbu nɡe mɛ Yinni Gusunɔ u bɛɛ yiire. ");
INSERT INTO bba_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","Bɛɛ kpuro, i Yuudɛni tɔburo nɡe mɛ Gusunɔ u kĩ kpɑ i n wɑ̃ɑ mi sere u kɑ win yibɛrɛbɑ ɡirɑ win wuswɑɑn di, ");
INSERT INTO bba_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","kpɑ u tem mɛ mwɑ. Sɑɑ ye sɔɔ, iǹ ko i n mɑɑ tɑɑrɛ ɡɑɑ mɔ. I ko i kpĩ i wurɑmɑ bɛɛn temɔ, kpɑ mu n sɑ̃ɑ bɛɛɡim. ");
INSERT INTO bba_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","Adɑmɑ ì kun kue mɛ, i Yinni Gusunɔ torɑriwɑ mi. Kpɑ i n yɛ̃ mɑ bɛɛyɑ i ko i torɑ ten ɑre sɔbe. ");
INSERT INTO bba_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","I doo i wusu bɑni bɛɛn kurɔbu kɑ bibun sɔ̃, kpɑ i mɑɑ kɑrɑbɑ ko bɛɛn yɑɑ sɑbenun sɔ̃. Yen biru kpɑ i nɑ i bɛɛn nɔɔ mwɛɛru yibiɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","Mɑ Gɑdiɡibu kɑ Rubɛni be, bɑ Mɔwisi wisɑ bɑ nɛɛ, Yinni, ye ɑ ɡeruɑ mi kpuro, sɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","Sɑ ko bɛsɛn kurɔbu kɑ bɛsɛn bibu kɑ bɛsɛn yɑɑ sɑbenu deri Gɑlɑdi mini. ");
INSERT INTO bba_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","Kpɑ bɛsɛ kpuro su Yuudɛni tɔburɑ sɑ n tɑbu yɑ̃nu nɛni su kɑ tɑbu ko Yinni Gusunɔn wuswɑɑɔ nɡe mɛ ɑ ɡeruɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","Yerɑ Mɔwisi u yɑ̃ku kowo Eleɑsɑɑ kɑ Yosue Nunin bii, kɑ Isirelibɑn bwese kɛrɑ bɑɑyeren wiruɡii woodɑ wɛ̃ ben sɔ̃. ");
INSERT INTO bba_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","U nɛɛ, Gɑdin bwese kɛrɑ kɑ Rubɛniɡiɑ bɑ̀ n tɑbu yɑ̃nu suɑ mɑ bɑ Yuudɛni tɔburɑ kɑ bɛɛ sɑnnu bu kɑ tɑbu ko Yinni Gusunɔn wuswɑɑɔ, mɑ bɑ bɛɛ somi i kɑ tem mɛ mwɑ, i bu Gɑlɑdin tem wɛ̃ɛyɔ mu ko beɡim. ");
INSERT INTO bba_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","Adɑmɑ bɑ̀ kun kue mɛ, i ko i bu tem wɛ̃wɑ bɛɛn suunu sɔɔ Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","Mɑ Gɑdiɡibu kɑ Rubɛni be, bɑ kpɑm nɛɛ, ye Yinni Gusunɔ u nun sɔ̃ɔwɑ kpuro, sɑ wurɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","Sɑ ko tɑbu yɑ̃nu suɑ su Kɑnɑnin tem wɔri nɡe mɛ Yinni Gusunɔ u ɡeruɑ kpɑ sɑ n bɛsɛn tem mɔ Yuudɛnin berɑ ɡee. ");
INSERT INTO bba_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","Mɑ Mɔwisi u Gɑdiɡii be kɑ Rubɛni be, kɑ Mɑnɑse, Yosɛfun biin bwese kɛrɑn bɔnu Amɔrebɑ kɑ Bɑsɑniɡibun tem kpuro wɛ̃, mɛn wuu mɑrosu kɑ mɛn bɑru kpɑɑnu, mi Sihoni kɑ Oɡu bɑ rɑɑ bɑndu dii. ");
INSERT INTO bba_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","Wuu si Gɑdiɡibɑ bɑ bɑnɑ, siyɑ Diboni kɑ Atɑrɔtu kɑ Aroɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","kɑ Atɑrɔtu Sofɑni kɑ Yɑsɛɛ kɑ Yoɡbeɑ, ");
INSERT INTO bba_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","kɑ Bɛti Nimurɑ kɑ Bɛti Hɑrɑni. Mɑ bɑ su ɡbɑ̃rɑnu toosi. Bɑ mɑɑ ben yɑɑ sɑbenu kɑrɑbɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","Wuu si Rubɛnibɑ mɑɑ bɑnɑ, siyɑ Hɛsiboni, ");
INSERT INTO bba_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","kɑ Eleɑle kɑ Kiriɑtɑimu kɑ Nɛbo kɑ Bɑɑli Mɛɔni kɑ Sibimɑ. Mɑ bɑ si kpuro yĩsinu kɔsɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","Mɑkiri Mɑnɑsen biin sikɑdominu, beyɑ bɑ Gɑlɑdin tem wɔri bɑ Amɔrebɑ ɡirɑ tem mɛn di mɑ bɑ mu mwɑ. ");
INSERT INTO bba_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","Mɑ Mɔwisi u bu tem mɛ wɛ̃ bɑ sinɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","Mɑnɑsen bii wi bɑ mɑɑ mɔ̀ Yɑiri, win sikɑdominɑ nu dɑ nu Amɔrebɑn bɑru kpɑɑnu wɔri nu mwɑ, mɑ nu nu sokɑ Yɑirin wusu. ");
INSERT INTO bba_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","Yen biru Nɔbɑki u Kenɑti wɔri u mwɑ, kɑ yen bɑru kpɑɑnu mɑ u ye sokɑ kɑ win tiin yĩsiru, Nɔbɑki. ");
INSERT INTO bba_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","2","Sɑnɑm mɛ Mɔwisi kɑ Aroni bɑ Isirelibɑ kpɑrɑmɑ wuuru kɑ wuuru Eɡibitin di Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, u yoruo mi bɑ dɑ dɑ. Ye u yoruɑ wee. ");
INSERT INTO bba_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","U nɛɛ, wɔ̃ɔn suru ɡbiikoon sɔ̃ɔ wɔkurɑ nnɛse sɔɔ yerɑ bɑ Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru di nɔn ɡbiikiru. Yen sisiru mɑ bɑ seewɑ bɑ yɑrɑ Rɑmusɛsin di Eɡibitiɡibun nɔni biru kɑ toro sindu. ");
INSERT INTO bba_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","Sɑɑ ye sɔɔ, Eɡibitiɡibu bɑ ben bii ɡbiikobu sikumɔ be bɑ ɡu sɑɑ ye Yinni Gusunɔ u kɑ ben bũnu siri. ");
INSERT INTO bba_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","Ye Isirelibɑ bɑ seewɑ Rɑmusɛsin di, bɑ dɑwɑ Sukɔtuɔ, bɑ ben sɑnsɑni ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","Sukɔtun di bɑ dɑ Etɑmuɔ tem sɑɑrɑm ɡɑm bɔkuɔ, bɑ ben sɑnsɑni ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","Sɑɑ Etɑmun di, bɑ nɑ Pihɑhirɔtuɔ ye yɑ wɑ̃ɑ Bɑɑli Sefonin deedeeru mɑ bɑ ben sɑnsɑni ɡirɑ Miɡidolin wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","Sɑɑ Pihɑhirɔtun di bɑ nim wɔ̃ku tɔburɑ bɑ dɑ Etɑmun tem sɑɑrɑm berɑ ɡiɑ. Bɑ sɑnum sowɑ sɔ̃ɔ itɑ mɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Mɑrɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","Sɑɑ mɑrɑn di bɑ tunumɑ Elimuɔ mi nim nɔnusu wɔkurɑ yiru kɑ kpɑkpɑ bɛ̃ɛ wɑtɑ kɑ wɔkurɑ wɑ̃ɑ mɑ bɑ ben sɑnsɑni ɡirɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","Sɑɑ Elimun di bɑ dɑ bɑ ben sɑnsɑni ɡirɑ nim wɔ̃kun bɔkuɔ ɡe bɑ mɔ̀ Nɑɑ yɑri. ");
INSERT INTO bba_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","Sɑɑ min di, mɑ bɑ dɑ berɑ mi bɑ mɔ̀ Sini, mi tem mu sɑ̃ɑ sɑɑrɑm. ");
INSERT INTO bba_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","Sɑɑ min di mɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Dofukɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","Sɑɑ min di mɑ bɑ dɑ Alusiɔ bɑ ben sɑnsɑni ɡirɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","Sɑɑ min di, mɑ bɑ dɑ Refidimuɔ bɑ ben sɑnsɑni ɡirɑ mi. Miyɑ Isirelibɑ bɑ nim biɑ bu nɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","Sɑɑ min diyɑ bɑ seewɑ bɑ dɑ berɑ mi bɑ mɔ̀ Sinɑi mi tem mu sɑ̃ɑ sɑɑrɑm bɑ ben sɑnsɑni ɡirɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","Sɑɑ min diyɑ bɑ dɑ Kiburɔti Hɑtɑfɑɔ bɑ ben sɑnsɑni ɡirɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Hɑserɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Ritimɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Rimɔɔ Pɛrɛsiɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Libinɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Risɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Kehelɑtɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ ɡuu te bɑ mɔ̀ Sɑfɛɛɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Hɑrɑdɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Mɑkelɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Tɑhɑtiɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Tɑrɑkiɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Mitikɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Hɑsimɔnɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Mɔserɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Bɛnɛ Yɑkɑniɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Hori Gidiɡɑdiɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Yotibɑtɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Aboronɑɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Ɛsioni Gebɛɛɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Kɑdɛsiɔ berɑ mi bɑ mɔ̀ Siniɔ, mi tem mu sɑ̃ɑ sɑɑrɑm. ");
INSERT INTO bba_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ ɡuu te bɑ mɔ̀ Horiɔ Edɔmun tem nɔɔ burɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","39","N deemɑ n kuɑ wɔ̃ɔ weeru sɑɑ min di bɑ yɑrimɑ Eɡibitin di. Sɑɑ ye, yɑ̃ku kowo Aronin wɔ̃ɔ wunɑɑ teeru kɑ itɑwɑ mi. Mɑ u yɔɔwɑ ɡuu ten wɔllɔ nɡe mɛ Yinni Gusunɔ u nùn sɔ̃ɔwɑ. Miyɑ u kpunɑ u ɡu wɔ̃ɔn suru nɔɔbusen tɔ̃ɔ ɡbiikiru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","Mɑ Arɑdin sinɑ boko wi u sɑ̃ɑ Kɑnɑniɡii u kɑ wɑ̃ɑ Kɑnɑni yen sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ, u nuɑ mɑ Isirelibɑ bɑ tunumɑ. ");
INSERT INTO bba_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","Ye Isirelibɑ bɑ seewɑ Hori min di, mɑ bɑ dɑ Sɑlumɔnɑɔ, bɑ ben sɑnsɑni ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","Sɑɑ min diyɑ dɑ bɑ ben sɑnsɑni ɡirɑ Punɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Obɔtuɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Iye Abɑrimuɔ Mɔɑbubɑn tem nɔɔ burɑ yerɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Diboni Gɑdiɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Alimɔɔ Dibilɑtɑimuɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","Sɑɑ min diyɑ bɑ dɑ bɑ ben sɑnsɑni ɡirɑ Abɑrimun ɡuunun berɑ ɡiɑ, Nɛbon deedeeru. ");
INSERT INTO bba_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","Ye bɑ doonɑ Abɑrimun ɡuunun di, bɑ nɑwɑ Mɔɑbubɑn wɔwɑɔ Yuudɛnin bɔkuɔ, Yerikon deedeeru. ");
INSERT INTO bba_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","Mɑ bɑ ben sɑnsɑni ɡirɑ mi, sɑɑ Bɛti Yɛsimɔtin di, n kɑ ɡirɑri Abɛli Sitimuɔ. ");
INSERT INTO bba_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, Yerikon deedeeru, u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, sɑnɑm mɛ bɑ koo Yuudɛni tɔburɑ bu du Kɑnɑnin temɔ, ");
INSERT INTO bba_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","bu tem mɛn tɔmbu kpuro ɡiro ben wuswɑɑn di kpɑ bu ben bwɑ̃ɑrokunu kɔsuku ni bɑ dɑ̃kɑ kɑ ni bɑ sekɑ, kɑ sere mɑɑ ben yɑ̃ku yenu. ");
INSERT INTO bba_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","Bu tem mɛ mɔɔ kpɑ bu sinɑ mi, domi nɑ bu mu wɛ̃wɑ mu n sɑ̃ɑ beɡim, ");
INSERT INTO bba_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","kpɑ bu tem mɛ bɔnu ko kɑ tɛtɛ nɡe mɛ ben bwese kɛrin tɔmbɑ ɡeeru nɛ. Bèn tɔmbu bɑ dɑbi, bu bu tem wɛ̃ɛyɔ mu n kpɑ̃. Be bɑǹ mɑɑ dɑbi kpɑ u bu wɛ̃ fiiko. Bɑ koo bwese kɛrɑ bɑɑyere yen tem wɛ̃wɑ berɑ ye bɑ tɛtɛ di kpɑ mu n sɑ̃ɑ beɡim. ");
INSERT INTO bba_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","Adɑmɑ bɑ̀ kun tem mɛn tɔmbu ɡire ben wuswɑɑn di, be bɑ deri mi, bɑ ko n sɑ̃ɑwɑ nɡe sɑ̃ki yi yi ko n ben nɔni sɔkumɔ, kɑ yɑbiri yi yi ko n bu sɔkirimɔ berɑ kɑ berɑ. Bɑ ko n sɑ̃ɑwɑ ben yibɛrɛbɑ tem mɛ sɔɔ, mi bɑ koo sinɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","Sɑɑ ye, beyɑ kon kuɑ ye nɑ rɑɑ ɡɔ̃ru doke n yibɛrɛ be kuɑ. ");
INSERT INTO bba_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bɑ̀ n duɑ Kɑnɑnin temɔ, mɛ mu koo ko beɡim, mɛn nɔɔ burɑ yenu wee. ");
INSERT INTO bba_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","Sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ mu koo nɔɔ yɔ̃rɑwɑ berɑ mi bɑ mɔ̀ Siniɔ mi tem mu sɑɑrɑm sɑ̃ɑ kpɑ ɡu mɑɑ dɑ Mɔɑbun tem bɔkuɔ. Nɔɔ ɡe, ɡɑ koo torewɑ nim wɔ̃ku bɔruɡuun bɔkuɔ, sɔ̃ɔ yɑri yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","Min di, kpɑ ɡu fukɑ ɡu dɑ Akɑrɑbimun ɡuunu ɡiɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑrɔ kpɑ ɡu berɑ mi bɑ mɔ̀ Sinin sukum sɑrɑ sere kɑ Kɑdɛsi Bɑɑnɛɑɔ, n kɑ dɑ Hɑsɑɑ Adɑriɔ sere kɑ Asimɔɔwɔ. ");
INSERT INTO bba_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","Sɑɑ Asimɔɔn di kpɑ ɡu mɑɑ dɑ Eɡibitin dɑɑ torɑ ɡɑɑn mi kpɑ ɡu dɑ ɡu yɔ̃rɑ nim wɔ̃kuɔ ɡe bɑ mɔ̀ Mɛditerɑnɛ. ");
INSERT INTO bba_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","Sɔ̃ɔ kpee yeru ɡiɑ mɛn nɔɔ ɡɑ koo yɔ̃rɑwɑ nim wɔ̃ku teu ɡen mi. ");
INSERT INTO bba_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","Sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ bɑ koo tem mɛn nɔɔ suɑwɑ sɑɑ nim wɔ̃ku ɡen min di n kɑ dɑ Horin ɡuurɔ. ");
INSERT INTO bba_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","Min di, bɑ koo de ɡu kpewɑ kɑ Hɑmɑtiɔ n kɑ nɑ Sedɑdiɔ. ");
INSERT INTO bba_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","Kpɑ ɡu doonɑ min di ɡu dɑ Siforoniɔ kpɑ ɡu dɑ ɡu yɔ̃rɑ Hɑsɑɑ Enɑniɔ. Miyɑ n ko n sɑ̃ɑ bɛɛn tem nɔɔ burɑ yeru sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","Sɔ̃ɔ yɑri yeru ɡiɑ mɑɑ, mɛn nɔɔ burɑ yerɑ koo torewɑ sɑɑ Hɑsɑɑ Enɑnin di kpɑ tu dɑ Sefɑmuɔ. ");
INSERT INTO bba_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","Sɑɑ Sefɑmun di kpɑ tu dɑ Ribilɑn berɑ ɡiɑ Ainin sɔ̃ɔ yɑri yeru ɡiɑ kpɑ tu Kinɛrɛtin dɑɑ burerun ɡooru bɛwɑ. ");
INSERT INTO bba_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","Sɑɑ min di, kpɑ tu dɑ Yuudɛnin berɑ ɡiɑ kpɑ tu dɑ tu yɔ̃rɑ nim wɔ̃ku bɔruɡuuɔ. Mi n ko n sɑ̃ɑ bɛɛn tem nɔɔ burɑ yeru miyɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","Ye Mɔwisi u Isirelibɑ ɡɑri yi sɔ̃ɔwɑ mɑ u mɑɑ nɛɛ, tem mɛyɑ mi, mɛ Yinni Gusunɔ u himbɑ kuɑ u bɛɛ bwese kɛri nɔɔbɑ nnɛ kɑ bɔnu wɛ̃ i bɔnu ko kɑ tɛtɛ. ");
INSERT INTO bba_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","15","Bwese kɛri yiru kɑ bɔnu yeni, Rubɛniɡiru kɑ Gɑdiɡiru kɑ Mɑnɑseɡirun bɔnu, bɑ ben tem mwɑ kɔ Yuudɛnin berɑ ɡee, Yerikon deedeeru, sɔ̃ɔ yɑri yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","yɑ̃ku kowo Eleɑsɑɑ kɑ Yosue Nunin bii, beyɑ bɑ koo tem mɛn bɔnu kobun wunɑnɔsu ko, ");
INSERT INTO bba_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","kpɑ ɑ ben bwese kɛrɑ bɑɑyeren di wiruɡii turo wunɑ u rɑɑ bu somi. ");
INSERT INTO bba_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","Be bɑ koo bu somi, beyɑ Kɑlɛbu, Yɛfunɛn bii, Yudɑn bweseru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","Kɑ Sɑmuɛli, Amihudun bii, Simɛɔn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","kɑ Ɛlidɑdi, Kisilonin bii, Bɛnyɑmɛɛn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","kɑ Buki, Yoɡilin bii, Dɑnun bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","24","kɑ Hɑniɛli, Efodun bii, Mɑnɑsen bweseru sɔɔ kɑ Kemuɛli, Sifitɑnin bii, Efɑrɑimun bweseru sɔɔ. N deemɑ Mɑnɑse kɑ Efɑrɑimun bwesenu nu sɑ̃ɑwɑ Yosɛfun bwese kɛri. ");
INSERT INTO bba_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","Kɑ Elisɑfɑni, Pɑɑnɑkin bii, Sɑbulonin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","kɑ Pɑtiɛli, Asɑnin bii, Isɑkɑrin bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","kɑ Ahihudu, Selɔmin bii, Asɛɛn bweseru sɔɔ, ");
INSERT INTO bba_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","kɑ Pedɑhɛli, Amihudun bii, Nɛfitɑlin bweseru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","Be Yinni Gusunɔ u ɡɔsɑ bu kɑ Isirelibɑn bwese kɛri Kɑnɑnin tem mɛ bɔnu kuɑ, berɑ mi. ");
INSERT INTO bba_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","Yinni Gusunɔ u kɑ Mɔwisi ɡɑri kuɑ Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, Yerikon deedeeru u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","ɑ Isirelibɑ sɔ̃ɔwɔ bu wusu ɡɔsi ben tem sɔɔ bu Lefibɑ wɛ̃ mi bɑ ko n wɑ̃ɑ kɑ sere mɑɑ kpɑrɑ yenu. ");
INSERT INTO bba_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","Lefibɑ bɑ koo sinɑwɑ wuu mɑrosu sɔɔ, kpɑ bɑ n tem mɔ mi bɑ ko n dɑ ben yɑɑ sɑbenu kpɑre. ");
INSERT INTO bba_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","Kpɑrɑ yee ni i ko i bu wɛ̃ mi, nin yɑsum mu ko n sɑ̃ɑwɑ ɡɔm soonu nɔrɔbu (1.000) sɑɑ ɡbɑ̃rɑrun beri berikɑn di, ");
INSERT INTO bba_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","kpɑ nin dɛ̃ɛbu bu n sɑ̃ɑ ɡɔm soonu nɔrɔbun subɑ yiru (2.000) sɔ̃ɔ yɑri yeru ɡiɑ, kɑ sɔ̃ɔ duu yeru ɡiɑ, kɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ, kɑ mɑɑ nɔm ɡeu ɡiɑ, kpɑ wuu ɡɑ n wɑ̃ɑ suunu sɔɔ. Nɡe mɛyɑ ben kpɑrɑ yee ni, nu ko n sɑ̃ɑ wuu bɑɑɡere sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","Bɑ koo bu wusu nɔɔbɑ tiɑ wɛ̃ mi wi u tɔnu ɡo u ko n dɑ kpikiru de, kɑ mɑɑ wusu ɡɑsu weeru kɑ yiru. ");
INSERT INTO bba_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","Wuu si kpuro su ko n sɑ̃ɑwɑ weeru kɑ nɔɔbɑ itɑ, kɑ sin kpɑrɑ yenu. ");
INSERT INTO bba_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","Isirelibɑn bwese kɛrɑ bɑɑyere yɑ koo Lefibɑ wusu wɛ̃wɑ nɡe mɛ yen tem mu kpɑ̃ɑru nɛ. Be bɑ dɑbi bɑ koo wɛ̃wɑ n dɑbi. Be bɑǹ mɑɑ dɑbi, kpɑ bu wɛ̃ fiiko. ");
INSERT INTO bba_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","Yinni Gusunɔ u Mɔwisi sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","ɑ Isirelibɑ sɔ̃ɔwɔ ɑ nɛɛ, bɑ̀ n Yuudɛni tɔburɑ bɑ duɑ Kɑnɑnin temɔ, ");
INSERT INTO bba_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","bu wusu ɡɑsu ɡɔsio mi wi u kun kĩ u kɑ tɔnu ɡo u ko n dɑ kpikiru de, ");
INSERT INTO bba_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","sere bu kɑ nùn dɑ bu siri tɔmbun wuswɑɑɔ. Nɡe mɛyɑ u koo kɑ yɑri wi u kĩ u nùn mɔru kɔsiɑn nɔmɑn di. ");
INSERT INTO bba_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","Wuu sìn mi bɑ ko n dɑ kpikiru de, su ko n sɑ̃ɑwɑ nɔɔbɑ tiɑ, ");
INSERT INTO bba_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","itɑ yɑ n wɑ̃ɑ Yuudɛnin sɔ̃ɔ yɑri yeru ɡiɑ, itɑ ye yɑ mɑɑ tie yɑ n wɑ̃ɑ Kɑnɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","Isireli ɡoo, ǹ kun mɛ sɔɔ wi u wɑ̃ɑ Isirelibɑn suunu sɔɔ, ù kun kĩ u kɑ tɔnu ɡo, u koo kpĩ u kpikiru dɑ wuu sin ɡɑɡun mi. ");
INSERT INTO bba_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","19","Goo ù n tɔnu so u ɡo kɑ ɡɑ̃ɑ ni bɑ kuɑ kɑ sisu, ǹ kun mɛ kɑ kperu, ǹ kun mɛ kɑ bokuru, u sɑ̃ɑwɑ tɔn ɡowo. Wi u ɡo min tɔnu u koo mɑɑ nùn mɔru kɔsie u ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","Goo ù n win winsim tusɑ u bɔriɑ, ǹ kun mɛ u nùn ɡɑ̃ɑnu kɑrɑ, ");
INSERT INTO bba_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ǹ kun mɛ u nùn so kɑ nɔmɑ u ɡo, bɑ koo yɛ̃ron tii ɡowɑ, domi u sɑ̃ɑwɑ tɔn ɡowo. Wi u ɡo min tɔnu u koo mɑɑ nùn mɔru kɔsie u ɡowɑ. ");
INSERT INTO bba_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","23","Goo ù kun mɑɑ kĩ u kɑ win winsim bɔriɑ, ǹ kun mɛ u nùn kɑrɑ kɑ ɡɑ̃ɑnu ǹ kun mɛ, u kɑ nùn kperu so u ɡo, ");
INSERT INTO bba_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","tɔmbu bɑ koo ye yɑ koorɑ min sɑriɑ mɛɛriwɑ bu kɑ yɛ̃ro siri wi u tɔnu ɡo mi. ");
INSERT INTO bba_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","Kpɑ bu nùn wiru dwe bu de u wurɑ wuu ɡèn mi u rɑɑ kpikiru dɑ, kpɑ u sinɑ mi sere yɑ̃ku kowo tɔnwero u kɑ ɡbi wi bɑ ɡum tɑ̃re wirɔ. ");
INSERT INTO bba_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","Wi u tɔnu ɡo mi, ù n yɑrɑ wuu ɡen min di, ɡèn mi u kpikiru dɑ mi, ");
INSERT INTO bba_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","mɑ wi u kĩ u nùn mɔru kɔsiɑ u nùn ɡo, yɛ̃ro kun tɑɑrɛ ɡɑɑ mɔ. ");
INSERT INTO bba_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","Domi wi u tɔnu ɡo mi, n weenɛ u sinɑwɑ wuu mi u rɑɑ kpikiru dɑ sere yɑ̃ku kowo tɔnwero u kɑ ɡbi. Yen biru u koo kpĩ u wurɑ win temɔ. ");
INSERT INTO bba_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","Woodɑ beniwɑ bɑ ko n dɑ swĩi, be kɑ ben bibun bweseru yɑm kpuro mi bɑ wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","Goo ù n tɔnu ɡo, tɔn dɑbirɑ bɑ koo yen seedɑ di bu sere yɛ̃ro ɡo. Tɔn turon seedɑ dibu kun turɑ bu kɑ tɔnu tɑɑrɛ wɛ̃ bu ɡo. ");
INSERT INTO bba_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","Bu ku nɔm birɑn kɛ̃ru mwɑ bu kɑ tɔn ɡowo deri. N weenɛ u ɡbiwɑ kɑm kɑm. ");
INSERT INTO bba_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","Bɑǹ mɑɑ nɔm birɑn kɛ̃ru mwɑɑmɔ bu kɑ de u dɑ wuu ɡèn mi bɑ rɑ kpikiru de, kpɑ u wurɑ win temɔ yɑ̃ku kowo tɔnwero ù n ɡu. ");
INSERT INTO bba_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","Bu ku rɑɑ tɔnu ɡo, domi yerɑ yɑ koo ben tem disi doke. N ǹ mɑɑ koorɔ bu mɛ dɛɛrɑsiɑ mɑ n kun mɔ bɑ yɛ̃ro ɡo, wi u tɔnu ɡo mi. ");
INSERT INTO bba_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","Bu ku rɑɑ tem mɛ disi doke mɛ̀ sɔɔ bɑ ko n wɑ̃ɑ, domi nɛ Yinni Gusunɔ, ko nɑ n wɑ̃ɑ kɑ be, nɛ wi nɑ rɑ n wɑ̃ɑ be Isirelibɑn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","Mɑnɑsen bweseru tɑ sɑ̃ɑwɑ Yosɛfun bwese kɛrɑ. Bwese te sɔɔ, Gɑlɑdi u sɑ̃ɑ Mɑkirin bii, Mɑnɑsen debubu. Gɑlɑdi win bweserun wiruɡibɑ bɑ dɑ bɑ Mɔwisi kɑ Isirelibɑn yɛnu yɛ̃robu deemɑ, ");
INSERT INTO bba_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","bɑ nɛɛ, Mɔwisi, wee sɑnɑm mɛ Yinni Gusunɔ u nun yiire ɑ Isirelibɑ tem bɔnu kuɑ kɑ tɛtɛ, u nun sɔ̃ɔwɑ u nɛɛ, ɑ bɛsɛn mɔɔ Selofɑdin tem win bii wɔndiɑbɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","Tɛ̃, bii wɔndiɑ be, bɑ̀ n durɔbu suɑ Isirelibɑn bwese kɛri yi yi tien ɡɑɑ sɔɔ, bɑ koo ben tem mɛ bɑ tubi di suɑwɑ bu bwese kɛrɑ yèn mi bɑ wurɑ sosiɑ. Aǹ wɑ mɑ bɛsɛn tem mu koo kɑɑrɑ mɛ bɑ sun wɛ̃ kɑ tɛtɛ? ");
INSERT INTO bba_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","Isirelibɑn yɑkiɑbun tɔ̃ru tɑ̀ n tunumɑ, bɑ koo ben bɔnu wunɑwɑ bɛsɛn min di bu ye bwese kɛrɑ yèn mi bɑ wurɑ sosiɑ. ");
INSERT INTO bba_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","Mɑ Mɔwisi u Isirelibɑ sɔ̃ɔwɑ u nɛɛ, Yosɛfun bweserun tɔn be, bɑ ɡem mɔ. ");
INSERT INTO bba_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","Wee ye Yinni Gusunɔ u ɡeruɑ Selofɑdin bii wɔndiɑbɑn sɔ̃. U nɛɛ, bɑ koo kpĩ bu durɔ suɑ wi bɑ kĩ, ɑdɑmɑ yɑ n ɡesi sɑ̃ɑ ben tundon bwese kɛrɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","Isirelibɑn bwese kɛrɑ ɡɑɑn tem muǹ duɔ bwese kɛrɑ ɡɑɑn tem sɔɔ. Isirelin bwese kɛrɑ bɑɑyere, yɑ koo yen tem nɛnɛwɑ mɛ yɑ tubi di. ");
INSERT INTO bba_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","Tɔn kurɔ bɑɑwure wi u tem wɑ u tubi di Isirelibɑn bwese kɛrɑ ɡɑɑ sɔɔ, u koo durɔ suɑwɑ win bwese kɛrɑ ye sɔɔ, u wɑ u kɑ win tundon tem mɛ u tubi di nɛnɛ. ");
INSERT INTO bba_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","Bwese kɛrɑ ɡɑɑn tem kun duɔ bwese kɛrɑ ɡɑɑn temɔ. Adɑmɑ Isirelibɑn bwese kɛrɑ bɑɑyere yɑ koo yen tem nɛnɛwɑ kem kem mɛ yɑ tubi di. ");
INSERT INTO bba_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","11","Mɑ Selofɑdin bii wɔndiɑ be, Mɑlɑ kɑ Tirisɑ kɑ Hoɡulɑ kɑ Milikɑ kɑ Nɔɑ bɑ Yinni Gusunɔn woodɑ ye wurɑ ye u Mɔwisi wɛ̃ mi. Mɑ bɑ ben tundon mɑɑbu kɑ wɔnɔbun bibu suɑ durɔbu. ");
INSERT INTO bba_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","Bɑ durɔbu suɑwɑ Yosɛfun bwese kɛrɑ sɔɔ, Mɑnɑsen bibun bweserɔ, mɑ tem mɛ bɑ tubi di muǹ mɛnɑnɛ kɑ ben tundobun tem. ");
INSERT INTO bba_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","Woodɑ kɑ yiire bi Yinni Gusunɔ u Isirelibɑ wɛ̃ Mɔwisin min di, Mɔɑbun wɔwɑɔ, Yuudɛnin bɔkuɔ, Yerikon deedeeru, biyɑ mi.");
INSERT INTO bba_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","Wee ɡɑri yi Mɔwisi u Isirelibɑ sɔ̃ɔwɑ sɑnɑm mɛ bɑ wɑ̃ɑ Yuudɛnin sɔ̃ɔ yɑri yeru ɡiɑ wɔwɑ ɡɑɑ sɔɔ, mi tem sɑɑrɑ wɑ̃ɑ, Sufun deedeeru, wuu sinin suunu sɔɔ, Pɑrɑni kɑ Tofɛli kɑ Lɑbɑni kɑ Hɑserɔtu kɑ Disɑhɑbu. ");
INSERT INTO bba_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","À n kpɑ kɑ Seirin ɡuurun swɑɑ, sɑɑ Horɛbun ɡuurun di, ɑ kɑ turi Kɑdɛsi Bɑɑnɛɑɔ, kɑɑ sĩwɑ sɔ̃ɔ wɔkurɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","Wɔ̃ɔ weeruse sɔɔ, mìn di Isirelibɑ bɑ yɑrimɑ Eɡibitin di, yen suru wɔkurɑ tiɑsen tɔ̃ɔ ɡbiikiru sɔɔrɑ Mɔwisi u Isirelibɑ sɔ̃ɔwɑ kpuro ye Yinni Gusunɔ u nɛɛ, u bu sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","Yɑ koorɑwɑ sɑnɑm mɛ Mɔwisi u Sihoni, Amɔrebɑn sinɑ boko wi u wɑ̃ɑ Hɛsiboniɔ kɑmiɑ u kpɑ mɑ u dɑ u Oɡu, Bɑsɑnin sinɑ boko wi u wɑ̃ɑ Edɛɛ kɑ Atɑrɔtuɔ kɑmiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","Mɔɑbubɑn temɔ, Yuudɛnin sɔ̃ɔ yɑri yeru ɡiɑ, miyɑ Mɔwisi u Isirelibɑ Yinni Gusunɔn woodɑbɑ sɔ̃ɔsibu toruɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","Mɔwisi u nɛɛ, Gusunɔ bɛsɛn Yinni u kɑ sun ɡɑri kuɑ Horɛbun ɡuurɔ u nɛɛ, sɑ sinɑ sɑ tɛ ɡuu ten ɡɑ̃ɑrɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","Ǹ n mɛn nɑ, su seewo su swɑɑ wɔri su dɑ ɡuunun berɑ ɡiɑ mi Amɔrebɑ bɑ wɑ̃ɑ kɑ Kɑnɑnin temɔ Yuudɛnin tem tɛɛrɑɔ kɑ ɡuunu ɡiɑ kɑ wɔwɑɔ kɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ kɑ nim wɔ̃kun ɡoorɔ kɑ Libɑniɔ sere n kɑ dɑ Efɑrɑtin dɑɑrɔ, ");
INSERT INTO bba_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","kpɑ su tem mɛ mɛɛri domi u sun mu nɔmu sɔndiɑwɑ. U nɛɛ, su doo su mu mwɑ domi u nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri u mu bɛsɛn bɑɑbɑbɑ Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu wɛ̃, be kɑ ben bibun bweseru. ");
INSERT INTO bba_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","Sɑɑ yè sɔɔ Yinni Gusunɔ u nɛɛ, su doo su tem mɛ mwɑ, nɛ Mɔwisi nɑ bɛɛ sɔ̃ɔwɑ nɑ nɛɛ, nɑ ǹ kpɛ̃ n bɛɛ sɔbe nɛ turo. ");
INSERT INTO bba_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","Gusunɔ bɛsɛn Yinni u derɑ i mɑrurɑ mɑ i dɑbiɑ nɡe wɔllun kperi. ");
INSERT INTO bba_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","Nɑ kɑnɑmɔ Gusunɔ bɛsɛn bɑɑbɑbɑn Yinni u de i dɑbiɑ i sosi kpɑ u bɛɛ domɑru kuɑ nɡe mɛ u bɛɛ nɔɔ mwɛɛru kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","Adɑmɑ i n yɛ̃ mɑ nɑ ǹ kpɛ̃ n bɛɛ sɔbe nɛ turo. ");
INSERT INTO bba_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","Ǹ n mɛn nɑ, i tɔmbu ɡɔsio bɛɛn bwese kɛrɑ bɑɑyere sɔɔ be bɑ yɛ̃ru kɑ bwisi mɔ, mɑ bɑ bɛɛrɛ mɔ tɔmbu sɔɔ, kpɑ n bu ko bɛɛn wiruɡibu. ");
INSERT INTO bba_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","Mɑ i mɑn wisɑ i nɛɛ, ye nɑ ɡeruɑ mi, yɑ wɑ̃. ");
INSERT INTO bba_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","Mɑ i kɑ tɔn be nɑ bɛɛn bwese kɛrɑ bɑɑyeren di mɑ nɑ bu suɑ nɑ bu kuɑ bɛɛn wiruɡibu, ɡɑbu nɔrɔm nɔrɔm (1.000) wiruɡibu, ɡɑbu wunɔm wunɔm wiruɡibu, ɡɑbu weerɑɑkuukuubun wiruɡibu, ɡɑbu mɑɑ wɔku wɔkubun wiruɡibu, mɑ nɑ ɡɑbu sɔmɑ wɛ̃ bu kɑ wiruɡii be kpɑrɑ bɛɛn bwese kɛrɑ bɑɑyere sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","Mɑ nɑ wiruɡii be woodɑ wɛ̃ nɑ nɛɛ, ben mɛro bisibu bɑ̀ n ɡɑri mɔ ben tii tiinɛ sɔɔ, ǹ kun mɛ, kɑ tɔn tuko, bu bu swɑɑ dɑkio kpɑ bu bu siriɑ dee dee. ");
INSERT INTO bba_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","Bu ku tɔmbun bɛɛrɛ mɛɛri bɑ̀ n sirimɔ. Bu bu swɑɑ dɑkio, bwɛ̃ɛbwɛ̃ɛ kɑ dɑmɡii. Bu ku ben ɡoo nɑsiɑ domi bɑ koo siriwɑ kɑ Yinni Gusunɔn yĩsiru. Bɑ̀ n kɑ ɡɑri ɡɛɛ yinnɑ yi yi bu sɛ̃siemɔ, bu kɑ yi nɑ nɛn mi bu mɑn sɔ̃ kpɑ n yi wɛ̃ɛri. ");
INSERT INTO bba_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","Nɡe mɛyɑ nɑ bɛɛ sɔ̃ɔsi sɑɑ ye sɔɔ, ye i ko i ko kpuro. ");
INSERT INTO bba_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","Yen biru, Gusunɔ bɛsɛn Yinni u sun nɔɔ kɑ̃ mɑ sɑ seewɑ Horɛbun ɡuurun di sɑ ɡbɑbu bɑkɑ nɑnumɡii te kpuro bukiɑnɑ te i yɛ̃ mi, mɑ sɑ kpɑ kɑ ɡuunun swɑɑɔ mi Amɔrebɑ bɑ wɑ̃ɑ nɡe mɛ Gusunɔ bɛsɛn Yinni u sun yiire. Mɑ sɑ turɑ Kɑdɛsi Bɑɑnɛɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","Miyɑ nɑ bɛɛ sɔ̃ɔwɑ nɑ nɛɛ, wee i tunumɑ Amɔrebɑn ɡuurɔ te Gusunɔ bɛsɛn Yinni u koo sun wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","I mɛɛrio wee, Gusunɔ bɛsɛn Yinni u bɛɛ tem mɛ nɔmu bɛriɑ. I seewo kpɑ i mu mwɑ nɡe mɛ wi, bɛsɛn bɑɑbɑbɑn Yinni u bɛɛ sɔ̃ɔwɑ. I ku bɛrum ko. I de i n wɔruɡɔru mɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","Mɑ bɛɛ kpuro i nɑ i mɑn deemɑ i nɛɛ, su tɔmbu ɡɔri bu dɑ bu tem mɛn sɑriɑ mɛɛri kpɑ bu wurɑmɑ bu sun sɔ̃ swɑɑ ye sɑ ko kpe, kɑ wuu sìn mi sɑ ko ɡbi su turi. ");
INSERT INTO bba_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","Bɛɛn ɡɑri yi, yi mɑn wɛ̃re, mɑ nɑ tɔmbu wɔkurɑ yiru ɡɔsɑ bɛɛn bwese kɛrɑ bɑɑyere sɔɔ tiɑ tiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","Mɑ bɑ doonɑ bɑ ɡuunun berɑ ɡiɑn swɑɑ mwɑ mɑ bɑ turɑ sere Ɛsikolin wɔwɑɔ. Mi kpurowɑ bɑ bɔsu bɑ mɛɛrɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","Mɑ bɑ tem mɛn dɑ̃ɑ binu sɔrimɑ bɑ kɑ sun nɑɑwɑ. Mɑ bɑ nɛɛ, tem mɛ, mu ɡiɑ sɑ̃ɑ mɛ Gusunɔ bɛsɛn Yinni u sun wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","Adɑmɑ i ǹ Gusunɔ bɛsɛn Yinnin ɡere mɛm nɔɔwɛ, domi i yinɑ i dɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","I nùn seesiwɑ bɛɛn kuu bekuruɡinu sɔɔ i nɛɛ, yèn sɔ̃ u sun tusɑ, yen sɔ̃nɑ u sun yɑrɑmɑ Eɡibitin di u kɑ sun Amɔrebɑ nɔmu sɔndiɑ, bu sun kpeerɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","I nɛɛ, mbɑn sɔ̃nɑ i ko i dɑ i bu wɔri. Bɛɛɡibu bɑ derɑ i mwiɑ kpɑnɑ domi bɑ nɛɛ, tɔn be, bɑ sun dɑm kere, bɑ sun ɡunum kere, bɑ mɑɑ ben wusu ɡbɑ̃rɑnu toosiwɑ n kɑ wɔllu ɡirɑri. Yen biru, bɑ mɑm Anɑkin bibun bweseru wɑ mi, be bɑ rɑ n sɑ̃ɑ dooɡobɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","Mɑ nɑ bɛɛ wisɑ nɑ nɛɛ, i ku nɑndɑ, i ku mɑɑ ben bɛrum ko. ");
INSERT INTO bba_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","Gusunɔ bɛsɛn Yinni u ko n sun ɡbiiye kpɑ win tii u sun sɑnnɑ nɡe mɛ u kuɑ bɛsɛn nɔni biru Eɡibitiɔ, ");
INSERT INTO bba_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","kɑ ɡbɑburɔ. Bɛɛn tii i wɑ mɑ u sun bɔki bɛsɛn sɑnum sɔɔ nɡe mɛ tɔnu u rɑ win bii bɔki sere sɑ kɑ turɑ mi sɑ dɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","Adɑmɑ kɑ mɛ, i ǹ Gusunɔ bɛsɛn Yinni nɑɑnɛ kue, ");
INSERT INTO bba_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","bɑɑ mɛ u rɑ n sun swɑɑ ɡbiiye u kɑ sun ɑyeru sɔ̃ɔsi mi sɑ ko yɔ̃rɑ. Wɔ̃kuru, u rɑ sun kpɑrewɑ u n bɛsɛn swɑɑ yɑm bururɑsie kɑ dɔ̃ɔ yɑrɑ, sɔ̃ɔ sɔɔ mɑɑ kɑ ɡuru wii wuroru. ");
INSERT INTO bba_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","Yinni Gusunɔ u bɛɛn weeweenu nuɑ, mɑ u mɔru kuɑ u bɔ̃ruɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","bɑɑ bɛɛn turo kun duɔ tem mɛ sɔɔ, mɛ mu ɡeɑ sɑ̃ɑ mi, mɛ u nɔɔ mwɛɛru kuɑ u bɛsɛn bɑɑbɑbɑ wɛ̃, ");
INSERT INTO bba_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","mɑ n kun mɔ Kɑlɛbu, Yɛfunɛn bii. Wiyɑ u koo mu wɑ. Wi kɑ win bibun bweserɑ u koo tem mɛ wɛ̃ mɛ u bɔsu u mɛɛrɑ mi, domi u win swɛɛ kpuro swĩiwɑ dee dee. ");
INSERT INTO bba_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","Yinni Gusunɔ u mɑɑ kɑ mɑn mɔru kuɑ bɛɛn sɔ̃, mɑ u nɛɛ, nɛn tii nɑ ǹ mɑɑ duɔ tem mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","Nɛn sɔm kowo Yosue, Nunin biiwɑ u koo du mi. Yen sɔ̃, n be nùn dɑm kɛ̃ɛyɔ, domi wiyɑ u koo bɛɛ Isirelibɑ kpɑrɑ u kɑ bɛɛ tem mɛ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","Mɑ Yinni Gusunɔ u nɛɛ, bɛɛ, i nɛɛ, yibɛrɛbɑ bɑ koo bɛɛn bibu ɡurɑwɑ. Adɑmɑ bii be, be bɑ ǹ ɡinɑ ɡeɑ kɑ kɔ̃sɑ yɛ̃ mi, beyɑ bɑ koo du tem mɛ sɔɔ kɑ Yosue sɑnnu. Beyɑ u koo tem mɛ wɛ̃ bɑ n mɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","Yen sɔ̃, bɛɛ i ɡɔsiro kpɑ i dɑ ɡbɑburu ɡiɑ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑrin berɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","Mɑ i mɑn wisɑ i nɛɛ, i torɑ Yinni Gusunɔn mi. Adɑmɑ tɛ̃, i ko dɑ i tɑbu ko nɡe mɛ wi, Gusunɔ bɛsɛn Yinni u ɡeruɑ. Mɑ i bɛɛn tɑbu yɑ̃nu suɑ i dɔɔ kɑ wɔbiɑ i kɑ ɡuunun berɑ ɡiɑ tɑbu wɔri. ");
INSERT INTO bba_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","Mɑ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, n bɛɛ sɔ̃ɔwɔ n nɛɛ, i ku rɑ dɑ i tɑbu ko. U ǹ wɑ̃ɑ kɑ bɛɛ. Yen sɔ̃, i ku dɑ, domi bɑ koo bɛɛ kɑmiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","Nɑ bɛɛ ye sɔ̃ɔwɑ ɑdɑmɑ i yinɑ i mɑn swɑɑ dɑki. I ǹ Yinni Gusunɔn ɡere mɛm nɔɔwɛ. Mɑ i ɡɔ̃ru bɔbiɑ i dɑ i tɑbu wɔri ɡuunun berɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","Sɑɑ yerɑ Amɔre be bɑ wɑ̃ɑ berɑ mi, bɑ yɑrimɑ bɑ bɛɛ kɑmiɑ Seiriɔ, mɑ bɑ bɛɛ nɑɑ swĩi nɡe tĩi sere bɑ kɑ ɡirɑri Horimɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","Ye i wurɑmɑ, i Yinni Gusunɔ weeweenu koosi. Adɑmɑ u ǹ bɛɛ swɑɑ dɑki. ");
INSERT INTO bba_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","Mɑ i sinɑ n kɑ tɛ Kɑdɛsi Bɑɑnɛɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","Yen biru mɑ sɑ ɡɔsirɑ sɑ dɑ kɑ ɡbɑburun swɑɑ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑrin berɑ ɡiɑ nɡe mɛ Yinni Gusunɔ u ɡeruɑ. Mɑ sɑ sirenɑ Seirin ɡuunɔ n kɑ tɛ. ");
INSERT INTO bba_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","wee sɑ sirenɑ ɡuunun berɑ mi ɡiɑ n kɑ tɛ. Su mɑɑ doo sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","U nɛɛ, n bɛɛ woodɑ yeni wɛ̃ n nɛɛ, i seewo i Seirin tem bɛwɑ mi bɛɛn mɛro bisibu Esɑun bibun bweseru bɑ wɑ̃ɑ. Bɑ ko n bɛɛn bɛrum mɔ, ɑdɑmɑ i n tii sɛ, ");
INSERT INTO bba_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","i ku rɑ bu wɔri. Domi u ǹ bɛɛ ben tem wɛ̃ɛmɔ bɑɑ mɛ̀n nɔɔ i ko i nɑɑsu sɔndi. Esɑun bibun bweserɑ u Seirin ɡuunun berɑn tem mɛ wɛ̃ bɑ n mɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","Dĩɑ ni i ko i di kɑ sere mɑɑ nim mɛ i ko i nɔ, i ko i ye kpuro dwewɑ ben mi. ");
INSERT INTO bba_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","Domi Gusunɔ bɛsɛn Yinni u bɛsɛn sɔmɑ kpuro domɑru kuɑ mɑ u sun kɔ̃su sɑnɑm mɛ sɑ ɡbɑbu bɑkɑ te bukiɑnɑmɔ. U wɑ̃ɑ kɑ bɛsɛ sere n kɑ kuɑ ɡisɔ wɔ̃ɔ weeru. Sɑ ǹ ɡɑ̃ɑnu bie. ");
INSERT INTO bba_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","Mɑ sɑ Seirin tem bɛwɑ mi bɛsɛn mɛro bisibu Esɑun bibun bweserɑ wɑ̃ɑ. Sɑ ǹ mɑɑ tem tɛɛrɑn swɑɑ mwɛ ye yɑ dɔɔ Elɑtiɔ kɑ Ɛsioni Gebɛɛɔ. Mɑ sɑ ɡɔsirɑ sɑ Mɔɑbun ɡbɑburun swɑɑ mwɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, su ku Mɔɑbubɑ nɔɔ kuuri, su ku bu tɑbu wɔri, domi u ǹ sun ɡɑ̃ɑnu nɔmu sɔndiɑmmɛ ben temɔ. Lɔtun bibun bweserɑ u Arin tem mɛ wɛ̃ bɑ n mɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","Yellu, Emibɑrɑ bɑ wɑ̃ɑ Arin tem mɛ sɔɔ. Bɑ sɑ̃ɑwɑ bwese te tɑ dɑm mɔ. Bɑ dɑbi bɑ mɑɑ ɡunu nɡe Anɑkin bibun bweseru. ");
INSERT INTO bba_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","Gɑbu bɑ tɑmɑɑ bɑ sɑ̃ɑwɑ Refɑbɑ nɡe mɛ Anɑkibɑ bɑ sɑ̃ɑ, ɑdɑmɑ Mɔɑbubɑ bɑ rɑ bu sokuwɑ Emibɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","Nɡe mɛyɑ mɑɑ Horibɑ bɑ rɑɑ wɑ̃ɑ Seirin temɔ yellu. Mɑ Esɑun bibun bweseru bɑ bu kpeerɑsiɑ mɑ bɑ sinɑ mi, nɡe mɛ bɛɛ Isirelibɑ i kuɑ tem mɛ Yinni Gusunɔ u bɛɛ wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","Yen biru, Yinni Gusunɔ u woodɑ wɛ̃ u nɛɛ, su seewo su swɑɑ wɔri kpɑ su Serɛdin dɑɑru tɔburɑ. Mɑ sɑ tu tɔburɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","Sɑɑ mìn di sɑ seewɑ Kɑdɛsi Bɑɑnɛɑn di sere sɑ kɑ Serɛdin dɑɑru tɔburɑ, n kuɑwɑ wɔ̃ɔ tɛnɑ kɑ nɔɔbɑ itɑ. Be bɑ rɑɑ sɑ̃ɑ tɑbu kowobu sɑ kɑ seemɑ bɑ ǹ mɑɑ wɑ̃ɑ nɡe mɛ Yinni Gusunɔ u rɑɑ ɡeruɑ kɑ bɔ̃ri. ");
INSERT INTO bba_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","Win tiiwɑ u bu nɔmɑ doke u kpeerɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","Sɑnɑm mɛ tɑbu kowo be kpuro bɑ ɡu bɑ kpɑ, ");
INSERT INTO bba_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","sɑnɑm mɛ sɔɔrɑ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, ");
INSERT INTO bba_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","tɛ̃, su Mɔɑbun tem nɔɔ burɑ yeru sɑro kpɑ su Arin tem bukiɑnɑ, ");
INSERT INTO bba_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","su nɑ Amɔnibɑn mi. Adɑmɑ su ku bu nɔɔ kuuri, su ku mɑɑ kɑ bu tɑbu ko. Domi u ǹ sun ɡɑ̃ɑnu wɛ̃ɛmɔ ben tem mɛ sɔɔ. Bɑ sɑ̃ɑwɑ Lɔtun bibun bweseru. Berɑ u mɑɑ tem mɛ wɛ̃ bɑ n mɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","Tem mɛ, mu rɑɑ sɑ̃ɑwɑ Refɑbɑn tem. Domi yellu Refɑbɑrɑ bɑ rɑɑ wɑ̃ɑ mi, be, be Amɔnibɑ bɑ rɑ soku Sɑnsumibɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","Bwese te, tɑ dɑm mɔ mɑ bɑ dɑbi. Bɑ ɡunuwɑ nɡe Anɑkibɑ. Adɑmɑ Yinni Gusunɔ u bu Amɔnibɑ nɔmɑ bɛriɑ, bɑ bu ɡirɑ mɑ bɑ sinɑ mi. ");
INSERT INTO bba_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","Nɡe mɛyɑ Yinni Gusunɔ u Esɑun bibun bweseru kuɑ be bɑ wɑ̃ɑ Seiriɔ. U derɑ bɑ Horibɑ ɡirɑ mɑ bɑ bu kpeerɑsiɑ bɑ sinɑ ben temɔ sere kɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","Kɑfitoriɡibu bɑ nɑ sɑɑ ben tem di bɑ Afi be bɑ wɑ̃ɑ bɑru kpɑɑnɔ n kɑ ɡirɑri Gɑsɑɔ kpeerɑsiɑ mɑ bɑ sinɑ ben wusɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","Yen biru, Yinni Gusunɔ u nɛɛ, su seewo su swɑɑ wɔri kpɑ su Aɑnɔɔn dɑɑru tɔburɑ. Wee u koo sun Sihoni Amɔre, Hɛsibonin sinɑ boko nɔmu bɛriɑ kɑ win tem. U nɛɛ, su doo su nùn wɔri kpɑ su kɑ nùn tɑbu ko. ");
INSERT INTO bba_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","Sɑɑ ɡisɔn di u koo de nɑndɑbu bu n wɑ̃ɑ hɑnduniɑn bwesenu kpuro sɔɔ bɛsɛn sɔ̃. Bɑ̀ n bɛsɛn dɑmu nuɑ, kpɑ bu diiri bɛrum sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","Sɑɑ Kedemɔtin di, nɑ sɔmɔbu ɡɔrɑ Sihoni, sinɑ bokon mi, kpɑ bu nùn bɔri yɛndun ɡɑri sɔ̃ bu nɛɛ, ");
INSERT INTO bba_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","u de su win tem bukiɑnɑ. Swɑɑ doowɑ sɑ ko n swĩi, sɑ ǹ ɡɑm ɡɛrɑmɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","Sɑ ko nùn dĩɑ ni sɑ ko di kɑ nim mɛ sɑ ko nɔn ɡobi kɔsiɑ. U ɡesi de su win tem bukiɑnɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","Esɑun bibun bweseru be bɑ wɑ̃ɑ Seiriɔ kɑ Mɔɑbubɑ be bɑ wɑ̃ɑ Arin temɔ bɑ wurɑ sɑ ben tem bukiɑnɑ. U mɑɑ de su win tem bukiɑnɑ su kɑ Yuudɛni tɔburɑ kpɑ su du tem mɛ Gusunɔ bɛsɛn Yinni u sun wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","Adɑmɑ Sihoni, Hɛsibonin sinɑ boko u yinɑ su sɑrɑ kɑ win temɔ. Domi Gusunɔ bɛsɛn Yinni u win ɡɔ̃ru bɔbiɑsiɑ u sun nùn nɔmu sɔndiɑ nɡe mɛ i wɑɑmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","Mɑ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, n mɛɛrio u sun Sihoni kɑ win tem nɔmu bɛriɑ. Su nùn wɔrio su tem mɛ mwɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","Mɑ Sihoni kɑ win tɑbu kowobu bɑ nɑ bɑ sun tɑbu wɔri Yɑhɑsiɔ. ");
INSERT INTO bba_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","Mɑ Gusunɔ bɛsɛn Yinni u sun nùn nɔmu bɛriɑ. Mɑ sɑ nùn kɑmiɑ wi kɑ win bibu kɑ win tɑbu kowobu kpuro. ");
INSERT INTO bba_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","Sɑ win wusu kpuro mwɛɛrɑ sɑ kɑm koosiɑ mɑm mɑm, mɑ sɑ tɔn durɔbu kɑ tɔn kurɔbu kɑ bibu kpuro kpeerɑsiɑ, bɑɑ tɔn turo kun tiɑre. ");
INSERT INTO bba_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","Mɑ sɑ ben yɑɑ sɑbenu kɑ ben ɑrumɑni ye sɑ ɡurɑ ben wuu si sɔɔ tii koosi. ");
INSERT INTO bba_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","Sɑɑ Aroɛɛn di ye yɑ wɑ̃ɑ Aɑnɔɔn dɑɑrun ɡoorɔ kɑ wuu ɡe ɡɑ wɑ̃ɑ wɔwɑɔ n kɑ dɑ sere Gɑlɑdiɔ, wuu ɡɑɡɑ kun kpĩɑ ɡu sun mɑ. Gusunɔ bɛsɛn Yinni u sun si kpuro nɔmu bɛriɑwɑ. ");
INSERT INTO bba_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","Adɑmɑ sɑ ǹ Amɔnibɑn tem bɑbe kɑ tem mɛ mu wɑ̃ɑ Yɑbɔkun dɑɑrun ɡoorɔ kɑ wuu si su wɑ̃ɑ ɡuunɔ kɑ sere mi Gusunɔ bɛsɛn Yinni u sun yinɑri su wɔri. ");
INSERT INTO bba_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","Yen biru, sɑ tem tureru yɔɔwɑ sɑ dɑ Bɑsɑniɔ. Mɑ Oɡu, Bɑsɑnin sinɑ boko kɑ win tɑbu kowobu bɑ nɑ bɑ sun tɑbu wɔri Edɛɛɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","Mɑ Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, su ku Oɡu win bɛrum ko domi u koo sun nùn nɔmu bɛriɑ, wi kɑ win tɑbu kowobu kɑ win tem kpuro. Sɑ ko nùn kuɑwɑ nɡe mɛ sɑ Sihoni, Amɔrebɑn sinɑ boko kuɑ, wi u wɑ̃ɑ Hɛsiboniɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","Mɑ Gusunɔ bɛsɛn Yinni u sun Oɡu, Bɑsɑnin sinɑ boko nɔmu bɛriɑ kɑ win tɑbu kowobu kpuro. Sɑ bu kɑmiɑ sɑ kpeerɑsiɑ, bɑɑ tɔn turo sɑ ǹ deri. ");
INSERT INTO bba_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","Sɑ win wusu kpuro mwɛɛrɑ, bɑɑ teu ɡɑ ǹ kpĩɑ ɡu sun mɑ. Siyɑ wusu wɑtɑ ye yɑ wɑ̃ɑ Aɑɡɔbun temɔ Bɑsɑniɔ. Oɡun temɑ sere mi. ");
INSERT INTO bba_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","Wuu si kpuro su ɡbɑ̃rɑnu mɔwɑ ni nu ɡunu, mɑ bɑ nu ɡɑmbo sisuɡii kuɑ bɑ rɑ kɑ kɛnɛ. Wusu mɑɑ wɑ̃ɑ su dɑbi mi, si bɑ ǹ ɡbɑ̃rɑnu toosi. ");
INSERT INTO bba_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","Sɑ si kpuro mwɛɛrɑ mɑ sɑ tɔn durɔbu kɑ tɔn kurɔbu kɑ bibu kpuro kpeerɑsiɑ nɡe mɛ sɑ Sihoni, Hɛsibonin sinɑ boko kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","Mɑ sɑ wuu sin yɑɑ sɑbenu kɑ sin ɑrumɑni ɡurɑ sɑ tii yiiyɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","Nɡe mɛyɑ sɑ kɑ Amɔrebɑn sinɑmbu yiru yen tem mwɑ Yuudɛnin sɔ̃ɔ yɑri yeru ɡiɑ sɑɑ Aɑnɔɔn dɑɑrun di n kɑ dɑ Hɛɛmɔɔn ɡuurɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","Sidoniɡibu bɑ rɑ Hɛɛmɔɔn ɡuu te sokuwɑ Sirioni, kpɑ Amɔrebɑ bu mɑɑ tu soku Seniri. ");
INSERT INTO bba_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","Sɑ Bɑsɑnin sinɑ boko Oɡun wusu kpuro tɑbu di. Siyɑ wuu si su wɑ̃ɑ ɡunɡuru wɔllɔ kɑ Gɑlɑdin temɔ kɑ Bɑsɑnin tem mɛ kpuro sɔɔ n kɑ ɡirɑri Sɑlikɑɔ kɑ Edɛɛɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","N deemɑ Refɑbɑn bweseru sɔɔ, Oɡu, Bɑsɑnin sinɑ boko, wi turowɑ u rɑɑ tie. Kpɑkoro sisuɡiru sɔɔrɑ bɑ win ɡoru doke. Kpɑkoro te, tɑ wɑ̃ɑ Amɔnibɑn wuu mɑro Rɑbɑɔ. Ten dɛ̃ɛbu sɑ̃ɑwɑ ɡɔm soonu nɔɔbɑ nnɛ. Mɑ ten yɑsum sɑ̃ɑ ɡɔm soonu nnɛ. ");
INSERT INTO bba_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","Sɑɑ ye sɔɔrɑ nɑ Rubɛnin bweseru kɑ Gɑdin bweseru tem mɛ wɛ̃ mɛ mu wɑ̃ɑ Aɑnɔɔn berɑ ɡiɑ Aroɛɛn sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ kɑ wuu si su wɑ̃ɑ Gɑlɑdin ɡuunun bee tiɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","Mɑ nɑ Mɑnɑsen bweserun bɔnu Gɑlɑdin tem sukum mɛ mu tie wɛ̃ kɑ Bɑsɑnin tem mi Oɡu u rɑɑ bɑndu dii. N deemɑ Aɑɡɔbun tem kɑ Bɑsɑnin tem mɛyɑ bɑ rɑ mɑɑ soku Refɑbɑn tem. ");
INSERT INTO bba_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","Yɑiri, Mɑnɑsen bii, u Aɑɡɔbun tem kpuro mwɑ n kɑ dɑ Gesuribɑ kɑ Mɑɑkɑtiɡibun tem nɔɔ burɑ yerɔ. Mɑ u wuu si su wɑ̃ɑ tem mɛ sɔɔ sokɑ Yɑirin wusu nɡe mɛ bɑ su sokumɔ sere kɑ ɡisɔn ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","Mɑ nɑ Mɑkiri Gɑlɑdin tem wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","Mɑ nɑ Rubɛnin bweseru kɑ Gɑdin bweseru Gɑlɑdin tem bee tiɑ wɛ̃ n kɑ dɑ Aɑnɔɔn dɑɑrɔ sere kɑ Yɑbɔkun dɑɑrɔ. Aɑnɔɔn dɑɑrɑ tɑ sɑ̃ɑ tem mɛn nɔɔ burɑ yeru sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ, mɑ Yɑbɔkun dɑɑru tɑ mɑɑ bu burɑnɛ kɑ Amɔnibɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","Ben tem mɛyɑ mu wɑ̃ɑ Yuudɛnin wɔwɑɔ, sɑɑ Genɛsɑrɛtin dɑɑ burerun di n kɑ dɑ nim wɔ̃ku bɔruɡuuɔ. Mɑ mu dɑ sere kɑ Pisiɡɑn ɡuurɔ sɔ̃ɔ yɑri yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","Sɑɑ ye sɔɔ, mɑ nɑ bɛɛ woodɑ yeni wɛ̃ nɑ nɛɛ, tɛ̃, wee Gusunɔ bɛsɛn Yinni u bɛɛ tem mɛ wɛ̃ i n mɔ. Tɛ̃, bɛɛ tɑbu kowobu kpuro, i bɛɛn tɑbu yɑ̃nu suo kpɑ i Yuudɛni tɔburɑ kɑ bɛɛɡibu Isirelibɑ sɑnnu. ");
INSERT INTO bba_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","Bɛɛn kurɔbu kɑ bɛɛn bibu kɑ bɛɛn yɑɑ sɑbe ni tɔnɑwɑ i ko i deri wuu si nɑ bɛɛ wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","I bɛɛn mɛro bisibu somiɔ sere Gusunɔ bɛsɛn Yinni u kɑ bu swĩi ben temɔ nɡe mɛ u bɛɛ kuɑ, kpɑ bu sinɑ tem mɛ sɔɔ mɛ u koo bu wɛ̃ Yuudɛnin sɔ̃ɔ kpee yeru ɡiɑ. Sɑɑ ye sɔɔrɑ i ko i wurɑ bɛɛn temɔ mɛ nɑ bɛɛ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","Mɑ nɑ Yosue woodɑ yeni wɛ̃ nɑ nɛɛ, win nɔni yi wɑ ye Gusunɔ bɛsɛn Yinni u sinɑmbu yiru ye kuɑ. Nɡe mɛyɑ u koo mɑɑ sinɑmbu kpuro kuɑ be u koo kɑ tɑbu ko sɑnɑm mɛ i Yuudɛni tɔburɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","I ku bu nɑsiɑ, domi Gusunɔ bɛsɛn Yinni u koo bɛɛ sɑnnɑ. ");
INSERT INTO bba_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","Sɑɑ ye sɔɔ, nɑ Yinni Gusunɔ suuru kɑnɑ nɑ nɛɛ, ");
INSERT INTO bba_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","Gusunɔ nɛn Yinni, ɑ nɛ wunɛn sɔm kowo wunɛn kpɑ̃ɑru kɑ wunɛn dɑm bɑkɑm kookoo ɡbiikisu sɔ̃ɔsi. Yinni ɡoo sɑri wɔllɔ kɑ temɔ wi u koo kpĩ u ko ye ɑ rɑ ko. ");
INSERT INTO bba_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","A de n Yuudɛni tɔburɑ kpɑ n tem burɑm mɛ wɑ ɡuru ɡiɔ mi ɡuu burɑnu wɑ̃ɑ kɑ mɑɑ Libɑni. ");
INSERT INTO bba_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","Adɑmɑ Yinni Gusunɔ u kɑ mɑn mɔru kuɑ bɛɛn sɔ̃ mɑ u yinɑ u nɛn kɑnɑru nɔ. U nɛɛ, yɑ turɑ mɛ. N ku mɑɑ nùn yen ɡɑri sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","U nɛɛ, n yɔɔwo Pisiɡɑn ɡuurun wii kpiirɔ kpɑ n nɔni seeyɑ n mɛɛri sɔ̃ɔ yɛ̃sɑn nɔm ɡeu ɡiɑ kɑ sɔ̃ɔ yɛ̃sɑn nɔm dwɑru ɡiɑ kɑ sɔ̃ɔ kpee yeru ɡiɑ kɑ sere mɑɑ sɔ̃ɔ yɑri yeru ɡiɑ. Adɑmɑ nɑ ǹ Yuudɛni tɔburɑmɔ. ");
INSERT INTO bba_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","U nɛɛ, n Yosue bwisi kɛ̃ɛyɔ kpɑ n nùn dɑm kɛ̃, n de u n wɔruɡɔru mɔ. Domi wiyɑ u koo Yuudɛni tɔburɑ kpɑ u Isirelibɑ kpɑrɑ u kɑ bu tem mɛ wɛ̃ mɛ kon wɑ mi. ");
INSERT INTO bba_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","Mɑ sɑ sinɑ wɔwɑ mi, Bɛti Peorin deedeeru. ");
INSERT INTO bba_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","Tɛ̃, bɛɛ Isirelibɑ, i yiirebu kɑ woodɑbɑ swɑɑ dɑkio be nɑ bɛɛ wɛ̃ɛmɔ. I ye mɛm nɔɔwɔ kpɑ i wɑ i n wɑ̃ɑ, kpɑ i du tem mɛ sɔɔ, mɛ Gusunɔ bɛsɛn bɑɑbɑbɑn Yinni u bɛɛ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","I ko i win woodɑbɑ mɛm nɔɔwɑwɑ nɡe mɛ nɑ bɛɛ ye wɛ̃. I ku ɡɑ̃ɑnu ɡɑnu sosi ye sɔɔ, i ku mɑɑ ɡɑ̃ɑnu ɡɑnu kɑwɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","Bɛɛn nɔni yi wɑ ye Gusunɔ bɛsɛn Yinni u kuɑ Bɑɑli Peoriɡiin sɔ̃. U tɔmbu kpeerɑsiɑ kpuro bɛɛ sɔɔ be bɑ dɑ bɑ nùn sɑ̃wɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","Adɑmɑ bɛɛ be i Gusunɔ bɛsɛn Yinni nɑɑnɛ sɑ̃ɑ, bɛɛyɑ i wɑ̃ɑ wɑ̃ɑru sɔɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","Wee nɑ bɛɛ yiirebu kɑ woodɑbɑ wɛ̃ nɡe mɛ Gusunɔ bɛsɛn Yinni u mɑn sɔ̃ɔwɑ n ko. I ko i ye mɛm nɔɔwɑwɑ tem mɛ u koo bɛɛ wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","Ì n ye mɛm nɔɔwɑ mɑ i ye swĩi dee dee, bwese ni nu tie nù n woodɑ ye nuɑ, nu koo bɛɛ ɡɑrisiwɑ yɛ̃robu kɑ bwisiɡibu, kpɑ nu nɛɛ, ɑnnɑ ɑ bwese bɑkɑ ten yɛ̃ru kɑ bwisi wɑ! ");
INSERT INTO bba_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","Sɑ̀ n Gusunɔ bɛsɛn Yinni somiru kɑnɑ u rɑ n kɑ sun wɑ̃ɑ sɑɑ kpuro. Bweseru ɡɑrɑ wɑ̃ɑ bɑɑ ni nu kpɑ̃ɑru bo sɔɔ, te tɑ Yinni mɔ nɡe mɛ? ");
INSERT INTO bba_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","Bweseru ɡɑrɑ wɑ̃ɑ bɑɑ ni nu kpɑ̃ɑru bo sɔɔ tèn yiirebu kɑ ten woodɑbɑ bɑ sɑ̃ɑ dee dee nɡe woodɑ be nɑ bɛɛ wɛ̃ ɡisɔ? ");
INSERT INTO bba_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","I n tii sɛ kpɑ i ku duɑri bɛɛn wɑ̃ɑru kpuro sɔɔ ye i wɑ kɑ nɔni. I ku mɑɑ de yu yɑri bɛɛn ɡɔ̃run di. I ye bɛɛn bibu kɑ mɑɑ bɛɛn bibun bibu nɔɔsio. ");
INSERT INTO bba_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","I tɔ̃ɔ te yɑɑyo tè sɔɔ i dɑ i yɔ̃rɑ Gusunɔ bɛsɛn Yinnin wuswɑɑɔ Horɛbun ɡuurɔ sɑnɑm mɛ u mɑn sɔ̃ɔwɑ u nɛɛ, n bɛɛ Isirelibɑ kpuro mɛnnɑmɑ win mi, kpɑ u bɛɛ win woodɑbɑ sɔ̃, kpɑ i ɡiɑ nɡe mɛ i ko i kɑ nùn mɛm nɔɔwɑ bɛɛn wɑ̃ɑrun tɔ̃ru kpuro sɔɔ kpɑ i mɑɑ ye bɛɛn bibu nɔɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","Mɑ i mɛnnɑmɑ i nɑ i yɔ̃rɑ ɡuu ten nuurɔ tèn min di dɔ̃ɔ buri yi yɑrimɔ yi wɔllu ɡirɑri dɔ̃ɔ wiisu kɑ ɡuru wii wuroru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","Mɑ Yinni Gusunɔ u kɑ bɛɛ ɡɑri kuɑ dɔ̃ɔ yɑrɑ sɔɔn di. I win nɔɔ nuɑ ɑdɑmɑ i ǹ nùn wɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","U kɑ bɛɛ ɑrukɑwɑni bɔkuɑ u nɛɛ, i win woodɑ wɔkuru mɛm nɔɔwɔ te u yoruɑ kpee bɛsi yiru sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","Sɑɑ ye sɔɔrɑ Yinni Gusunɔ u mɑn yiire n bɛɛ woodɑ wɛ̃ kpɑ i ye mɛm nɔɔwɑ tem mɛ i ko i mwɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","Wee, i ǹ Yinni Gusunɔn tii wɑ sɑnɑm mɛ u kɑ bɛɛ ɡɑri kuɑ dɔ̃ɔ yɑrɑ sɔɔn di Horɛbun ɡuurɔ. Yen sɔ̃, i n tii sɛ, ");
INSERT INTO bba_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","i ku rɑ kɑ nùn torɑri i bwɑ̃ɑrokunu ko ni nu kɑ tɔn durɔ weenɛ ǹ kun mɛ tɔn kurɔ, ");
INSERT INTO bba_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ǹ kun mɛ yɑɑ ye yɑ sĩimɔ tem sɔɔ, ǹ kun mɛ ɡunɔ, ");
INSERT INTO bba_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ǹ kun mɛ yɑɑ ye yɑ kɑbirimɔ temɔ, ǹ kun mɛ swɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","Ì n nɔni seeyɑ wɔllɔ i kɑ sɔ̃ɔ kɑ suru kɑ kperi mɛɛri kɑ kpuro ye yɑ wɑ̃ɑ mi, i ku de yu bɛɛ ɡɑwɑ i kɑ yiirɑ i ye sɑ̃. Yebɑ kpurowɑ Gusunɔ bɛsɛn Yinni u hɑnduniɑn bwesenu kpuro deriɑ nu n mɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","Adɑmɑ bɛɛ, u bɛɛ nɔmɑ nɛnuɑ u yɑrɑ Eɡibitiɡibun nɔni yi bɑ bɛɛ sɔ̃ɔmɔn di kpɑ i n kɑ sɑ̃ɑ win tɔmbu nɡe mɛ i sɑ̃ɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","Mɑ Gusunɔ bɛsɛn Yinni u kɑ mɑn mɔru kuɑ bɛɛn sɔ̃. U bɔ̃ruɑ u nɛɛ, nɑ ǹ Yuudɛni tɔburɑmɔ, nɑ ǹ mɑɑ duɔ tem ɡem mɛ sɔɔ, mɛ u koo bɛɛ wɛ̃ i n mɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","Miniwɑ kon kpunɑ n ɡbi. Nɑ ǹ Yuudɛni tɔburɑmɔ. Adɑmɑ bɛɛ, i ko ye tɔburɑ kpɑ i tem ɡem mɛ mwɑ i sinɑ mi. ");
INSERT INTO bba_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","I n tii sɛ kpɑ i ku duɑri ɑrukɑwɑni ye Gusunɔ bɛsɛn Yinni u kɑ bɛɛ bɔkuɑ. I ku rɑ tii bwɑ̃ɑrokunu kuɑ ni nu kɑ ɡɑ̃ɑnu weenɛ ni u bɛɛ yinɑri i ko. ");
INSERT INTO bba_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","Domi Gusunɔ bɛsɛn Yinni u sɑ̃ɑwɑ nɡe dɔ̃ɔ wi u rɑ kɑm koosie, u mɑɑ sɑ̃ɑ nisinuɡii. ");
INSERT INTO bba_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","Ì n sinɑ n kɑ tɛ tem mɛ Gusunɔ bɛsɛn Yinni u bɛɛ nɔɔ mwɛɛru kuɑ sɔɔ, mɑ i bibu kɑ debuminu wɑ, i ku rɑ nùn torɑri i tii bwɑ̃ɑrokunu kuɑ ni nu kɑ ɡɑ̃ɑnu weenɛ, i ku mɑɑ kɔ̃sɑ ɡɑɑ ko ye yɑ koo win mɔru seeyɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","Ì n torɑ ten bweseru kuɑ, nɑ bɛɛ sɔ̃ɔmɔ nɑ siremɔ ɡisɔ, wɔllu kɑ tem mu sɑ̃ɑ nɛn seedɑ mɑ i ko i ɡbiwɑ tem mɛ i ko i mwɑ mi sɔɔ Yuudɛnin ɡuru ɡiɔ. Bɛɛn wɑ̃ɑru tɑ ǹ dɑkɑɑ dɔɔ. Bɑ koo bɛɛ kpeerɑsiɑwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","Yinni Gusunɔ u koo de i n yɑrinɛwɑ bwese tukunun suunu sɔɔ kpɑ i kun dɑbi yɑ̃ɑtem mi u derɑ i yoru dimɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","Miyɑ i ko i bũnu sɑ̃ ni tɔmbɑ kuɑ kɑ dɑ̃ɑ ǹ kun mɛ kɑ kpenu ni nu ku rɑ yɑm wɑ, nu ku rɑ ɡɑri nɔ, nu ku rɑ mɑɑ nuburu nɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","Miyɑ i ko i Gusunɔ bɛsɛn Yinni kɑsu. Ì n nùn kɑsu kɑ bɛɛn ɡɔ̃ru kpuro, kɑ bɛɛn bwɛ̃rɑ kpuro, i ko i nùn wɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","Ye nɑ bɛɛ sɔ̃ɔwɑ mi kpuro yɑ̀ n koorɑ, mɑ i wɑ̃ɑ nɔni swɑ̃ɑru sɔɔ, i ko i ɡɔsirɑmɑwɑ Gusunɔ bɛsɛn Yinnin mi kpɑ i wure i nùn mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","Domi u sɑ̃ɑwɑ wɔnwɔnduɡii wi u kun bɛɛ derimɔ. U ǹ bɛɛ kpeerɑsiɑmɔ. U ǹ mɑɑ duɑrimɔ ɑrukɑwɑni ye u kɑ bɛɛn bɑɑbɑbɑ bɔkuɑ kɑ bɔ̃ri. ");
INSERT INTO bba_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","I bwisikuo ye yɑ koorɑ yellu, ye yɑ koorɑ tɛɛ tɛɛbun di sɑɑ mìn di Gusunɔ u tɔnu tɑkɑ kuɑ hɑnduniɑ sɔɔ. I bwisikuo ye yɑ koorɑ hɑnduniɑn ɡoonu nnɛ kpuro sɔɔ. Gɑ̃ɑ mɑɑmɑɑkiɡinu ɡɑnu nu koore nɡe nini? I nɔɔre bɑ ɡɑ̃ɑnu ɡerure nɡe mɛni? ");
INSERT INTO bba_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","Bweseru ɡɑrɑ wɑ̃ɑ te Yinni Gusunɔ u kɑ ɡɑri koore dɔ̃ɔ yɑrɑ sɔɔn di nɡe bɛɛ mɑ tɑ wɑ̃ɑ tɑ wɑsi? ");
INSERT INTO bba_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","Yinni ɡoo u win tɔmbu wɔrɑre ben yibɛrɛbɑn nɔmɑn di kɑ win dɑm bɑkɑm, kɑ lɑɑkɑri mɛɛribu, kɑ yĩrenu, kɑ sɔm mɑɑmɑɑkiɡinu, kɑ tɑbu, kɑ win dɑm kɑ ɡɑ̃ɑ nɑnumɡinu nɡe mɛ Gusunɔ bɛsɛn Yinni u Eɡibitiɡibu kuɑ bɛɛn wuswɑɑɔ? ");
INSERT INTO bba_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","Bɛɛyɑ i kuɑ seedɑ kpɑ i kɑ ɡiɑ mɑ Gusunɔ turowɑ u sɑ̃ɑ Yinni. Goo mɑɑ sɑri nɡe wi. ");
INSERT INTO bba_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","U derɑ i win nɔɔ nuɑ wɔllun di u kɑ bɛɛ sɔ̃ɔsinu wɛ̃ kpɑ i kɑ nùn mɛm nɔɔwɑ. U mɑɑ derɑ i dɔ̃ɔ wɑ temɔ mɑ u kɑ bɛɛ ɡɑri kuɑ wi sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","U bɛɛn bɑɑbɑbɑ kĩɑ mɑ u bɛɛ ɡɔsɑ bɛɛ be i sɑ̃ɑ ben bibun bweseru. Yen sɔ̃nɑ u bɛɛ yɑrɑmɑ Eɡibitin di kɑ win dɑm bɑkɑm. ");
INSERT INTO bba_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","U bɛɛ bwese tukunu ɡirɑ ni nu bɛɛ dɑbiru kɑ dɑm kere mɑ u bɛɛ kpɑrɑ u kɑ duɑ ben temɔ u bɛɛ mu wɛ̃ nɡe mɛ i wɑɑmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","Ǹ n mɛn nɑ, i bwisikuo ɡisɔ kpɑ i n yɛ̃ mɑ Gusunɔ turowɑ u sɑ̃ɑ Yinni wɔllɔ kɑ temɔ. Goo mɑɑ sɑri nɡe wi. ");
INSERT INTO bba_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","I win woodɑbɑ kɑ win yiirebu mɛm nɔɔwɔ bi nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, kpɑ i wɑ i n bɔri yɛndu mɔ bɛɛ kɑ bɛɛn bibun bweseru kpɑ bɛɛn wɑ̃ɑru tu dɑkɑɑ dɑ tem mɛ sɔɔ, mɛ Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","Mɔwisi u wusu itɑ ɡɔsɑ Yuudɛnin sɔ̃ɔ yɑri yeru ɡiɑ, ");
INSERT INTO bba_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","kpɑ su n sɑ̃ɑ kpiki yenu. Wi u tɔnu ɡo kɑ sɑmbɑ, u ǹ dɑɑ kɑ yɛ̃ro mɔru nɛni, u ko n dɑ kpikiru de mi, u kɑ win wɑ̃ɑru bere. ");
INSERT INTO bba_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","Rubɛnin tem sɔɔ, u Beseri ɡɔsɑ ye yɑ wɑ̃ɑ ɡunɡuru wɔllɔ mi ɡɑ̃ɑnu ku rɑ kpi. Gɑdin temɔ, u Rɑmɔti ɡɔsɑ ye yɑ wɑ̃ɑ Gɑlɑdiɔ. Mɑnɑsen tem sɔɔ, u Golɑni ɡɔsɑ ye yɑ wɑ̃ɑ Bɑsɑnin temɔ. ");
INSERT INTO bba_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","45","Mɔwisi u Isirelibɑ yiirebu kɑ woodɑbɑ kɑ sɔ̃ɔsinu wɛ̃ sɑnɑm mɛ bɑ yɑrimɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","Sɑɑ ye, bɑ wɑ̃ɑ Yuudɛnin sɔ̃ɔ yɑri yeru ɡiɑ wɔwɑɔ, Bɛti Peorin deedeeru, Sihoni, Amɔrebɑn sinɑ bokon temɔ wi u wɑ̃ɑ Hɛsiboniɔ. Wiyɑ Mɔwisi kɑ Isirelibɑ bɑ kɑmiɑ sɑnɑm mɛ bɑ yɑrimɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","Mɑ bɑ win tem mwɑ kɑ mɑɑ Oɡu, Bɑsɑnin sinɑ bokon tem. Amɔrebɑn sinɑmbu yiru ye, bɑ rɑɑ wɑ̃ɑwɑ bɑ bɑndu dii Yuudɛnin ɡuru ɡiɔ sɔ̃ɔ yɑri yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","Ben tem mɛn nɔɔ burɑ yerɑ dɑwɑ Aroɛɛɔ, Aɑnɔɔn dɑɑrun ɡoorɔ sere n kɑ ɡirɑri ɡuu te bɑ mɔ̀ Hɛɛmɔɔwɔ te bɑ mɑɑ sokumɔ Siɔni, ");
INSERT INTO bba_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","kɑ tem mɛ mu wɑ̃ɑ Yuudɛnin wɔwɑɔ sɔ̃ɔ yɑri yeru ɡiɑ n kɑ ɡirɑri nim wɔ̃ku bɔruɡuuɔ sere n kɑ dɑ ɡuu te bɑ mɔ̀ Pisiɡɑn nuurɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","Mɔwisi u Isirelibɑ kpuro sokusiɑ bɑ mɛnnɑ mɑ u bu sɔ̃ɔwɑ u nɛɛ, bɛɛ Isirelibɑ i woodɑ kɑ yiirebu swɑɑ dɑkio i nɔ bi nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ. I bu nɛnuɔ kpɑ i bu mɛm nɔɔwɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","Gusunɔ bɛsɛn Yinni u kɑ sun ɑrukɑwɑni bɔkuɑ Horɛbun ɡuurɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","N ǹ bɛsɛn bɑɑbɑbɑ tɔnɑ u kɑ ye bɔkuɑ, ɑdɑmɑ kɑ bɛsɛn tiiwɑ bɛsɛ be sɑ wɑ̃ɑ sɑ wɑsi mini ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","Yinni Gusunɔ u kɑ bɛɛ ɡɑri kuɑ nɔni kɑ nɔni ɡuuru wɔllɔ sɑɑ dɔ̃ɔ yɑrɑ sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","Sɑɑ ye sɔɔ, mɑ nɑ yɔ̃ bɛɛ kɑ win suunu suunukɑ sɔɔ nɑ kɑ bɛɛ tusiɑmɔ ye u ɡerumɔ, domi i ǹ yɔɔwe ɡuu ten wɔllɔ yèn sɔ̃ i dɔ̃ɔ win bɛrum mɔ. U nɛɛ, ");
INSERT INTO bba_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","wiyɑ u sɑ̃ɑ Gusunɔ bɛsɛn Yinni. Wiyɑ u sun yɑrɑmɑ Eɡibitin di mi sɑ rɑɑ wɑ̃ɑ sɑ yoru dimɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","U mɑɑ nɛɛ, sɑ ǹ ko n mɑɑ Yinni ɡoo mɔ wi bɑɑsi. ");
INSERT INTO bba_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","Su ku rɑ tii bwɑ̃ɑroku ɡɑɡu kuɑ ɡɑ n kɑ ɡɑ̃ɑnu weenɛ wɔllɔ, ǹ kun mɛ temɔ, ǹ kun mɛ nim sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","Su ku rɑ yiirɑ su nu sɑ̃. Domi wi, Gusunɔ bɛsɛn Yinni u sɑ̃ɑwɑ nisinuɡii. U rɑ bɑɑbɑbɑn durum mɔɔru mwɛ ben bibun mi, be bɑ nùn tusɑn suunu sɔɔ sere kɑ ben bibun bibɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","Adɑmɑ be bɑ nùn kĩ mɑ bɑ win woodɑbɑ mɛm nɔɔwɑmmɛ u rɑ ben bibun bweserun nɔrɔm nɔrɔm (1.000) wɔnwɔndu kue. ");
INSERT INTO bba_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","Su ku rɑ wi, Gusunɔ bɛsɛn Yinnin yĩsiru soku kɑm. Domi wi u win yĩsiru sokɑ kɑm, u koo yɛ̃ro sɛɛyɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","Su tɔ̃ɔ wɛ̃rɑruɡiru mɛm nɔɔwɔ su tu bɛɛrɛ wɛ̃ nɡe mɛ wi, Gusunɔ bɛsɛn Yinni u sun yiire. ");
INSERT INTO bba_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","Sɔ̃ɔ nɔɔbɑ tiɑ sɔɔrɑ sɑ ko n dɑ bɛsɛn sɔmɑ kpuro ko. ");
INSERT INTO bba_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","Adɑmɑ sɔ̃ɔ nɔɔbɑ yiruseru tɑ sɑ̃ɑwɑ Gusunɔ bɛsɛn Yinnin tɔ̃ru tè sɔɔ u wɛ̃rɑ. Yen sɔ̃, su ku rɑ sɔmburu ɡɑru ko bɛsɛ kɑ bɛsɛn bibu kɑ bɛsɛn sɔm kowobu kɑ bɛsɛn kɛtɛbɑ kɑ bɛsɛn kɛtɛkunu, bɛsɛn yɑɑ sɑbenu kpuro ɡesi, kɑ mɑɑ sɔɔ wi u wɑ̃ɑ bɛsɛn yɛnuɔ. Bɛsɛ kpuro sɑ ko wɛ̃rɑwɑ. ");
INSERT INTO bba_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","Su yɑɑyo nɡe mɛ sɑ rɑɑ yoru dimɔ Eɡibitiɔ, mɑ wi, Gusunɔ bɛsɛn Yinni u sun yɑrɑmɑ min di kɑ win dɑm bɑkɑm. Yen sɔ̃nɑ u sun yiire su tɔ̃ɔ wɛ̃rɑruɡii te mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","Su bɛsɛn tundobu kɑ bɛsɛn mɛrobu bɛɛrɛ wɛ̃ɛyɔ nɡe mɛ wi, Gusunɔ bɛsɛn Yinni u sun yiire kpɑ bɛsɛn wɑ̃ɑru tu dɑkɑɑ dɑ kpɑ sɑ n bɔri yɛndu mɔ tem mɛ u sun wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","Su ku rɑ tɔnu ɡo. ");
INSERT INTO bba_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","Su ku rɑ sɑkɑrɑru ko. ");
INSERT INTO bba_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","Su ku rɑ ɡbɛni. ");
INSERT INTO bba_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","Su ku rɑ ɡoo ɡɑri mɑni. ");
INSERT INTO bba_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","Su ku rɑ bɛsɛn tɔnusin kurɔ binɛ ko, ǹ kun mɛ win diru, ǹ kun mɛ win ɡberu, ǹ kun mɛ win sɔm kowo tɔn durɔ ǹ kun mɛ tɔn kurɔ, ǹ kun mɛ win kɛtɛ, ǹ kun mɛ win kɛtɛku, win ɡɑ̃ɑnu kpuro ɡesi. ");
INSERT INTO bba_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","Gɑri yiniwɑ Yinni Gusunɔ u nɔɔ suɑ ɡuuru wɔllɔ u bɛsɛ win tɔmbu kpuro sɔ̃ɔwɑ dɔ̃ɔ yɑrɑ sɔɔn di kɑ ɡuru wii wuroru sɔɔn di kɑ ɡuru wii sinumɡirun di, u ǹ ɡɑ̃ɑnu sosi. Yen biru, u ye yoruɑ kpee bɛsi yiru sɔɔ u mɑn wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","Sɑnɑm mɛ i Yinni Gusunɔn nɔɔ ɡe nuɑ ɡuru wii sinumɡiru sɔɔn di, ɡuuru wɔllɔ tèn mi dɔ̃ɔ u wɑ̃ɑ, yerɑ bɛɛn bwese kɛrin wiruɡibu kɑ bɛɛn ɡuro ɡurobu bɑ nɑ nɛ Mɔwisin mi. ");
INSERT INTO bba_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","Mɑ bɑ nɛɛ, wee Gusunɔ bɛsɛn Yinni u bu win yiikon ɡirimɑ kɑ win kpɑ̃ɑru sɔ̃ɔsi. Bɑ win nɔɔ nuɑ dɔ̃ɔ yɑrɑ sɔɔn di. Gisɔ, bɑ wɑ mɑ Gusunɔ u kɑ tɔmbu ɡɑri kuɑ mɑ bɑ wɑ̃ɑ bɑ ǹ ɡu. ");
INSERT INTO bba_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","Adɑmɑ mbɑn sɔ̃nɑ bɑ koo de dɔ̃ɔ boko wi, u bu di kpɑ bu ɡbi. Domi bɑ̀ n Gusunɔn nɔɔ nɔɔmɔ mɛ, bɑ koo ɡbi. ");
INSERT INTO bba_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","Wɑrɑ u Yinni Gusunɔ wi u rɑ n wɑ̃ɑn ɡɑri nɔɔre dɔ̃ɔ yɑrɑ sɔɔn di nɡe be, mɑ yɛ̃ro u wɑ̃ɑ u ǹ ɡu. ");
INSERT INTO bba_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","Yen sɔ̃, nɛ Mɔwisi, n susio Gusunɔ bɛsɛn Yinnin bɔkuɔ kpɑ n swɑɑ dɑki ye u ɡeruɑ. Yen biru, kpɑ n bu ye nɔɔsiɑ. Bɑ koo ye nɔ, kpɑ bu kɑ ye sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","Mɑ Yinni Gusunɔ u nuɑ ye bɑ mɑn sɔ̃ɔwɑ. Mɑ u nɛɛ, ye bɑ ɡeruɑ mi kpuro ɡɑri burɛyɑ. ");
INSERT INTO bba_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","Bɑ̀ n koo rɑɑ kpĩ bu nùn ben ɡɔ̃ru wukiɑ nɡe mɛ, bu kɑ nùn bɛɛrɛ wɛ̃ kpɑ bu win woodɑbɑ mɛm nɔɔwɑ, bɑ ko n dɑɑ bɔri yɛndu mɔ be kɑ ben bibun bweseru sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","Yen sɔ̃ tɛ̃, u nɛɛ, n doo n bu sɔ̃ bu wuro ben kuu bekuruɡinɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","Adɑmɑ u nɛɛ, nɛ, n sinɔ kɑ wi, kpɑ u mɑn woodɑbɑ kɑ sɔ̃ɔsinu kɑ yiirebu sɔ̃ ye kon bu wɛ̃ bu mɛm nɔɔwɑ tem mɛ u bu wɛ̃ɛmɔ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","Mɑ Mɔwisi u mɑɑ bu sɔ̃ɔwɑ u nɛɛ, i woodɑ be kpuro mɛm nɔɔwɔ mɑm mɑm be Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃. I ku rɑ ɡɑm ɡɛrɑ be sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","I swɑɑ ye swĩiyɔ mɑm mɑm kpɑ bɛɛn wɑ̃ɑru tu dɑkɑɑ dɑ kpɑ i n bɔri yɛndu mɔ tem mɛ wi, Gusunɔ bɛsɛn Yinni u koo bɛɛ wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","Mɔwisi u mɑɑ nɛɛ, wee woodɑ kɑ sɔ̃ɔsi ni Gusunɔ bɛsɛn Yinni u mɑn yiire n bɛɛ wɛ̃ i mɛm nɔɔwɑ tem mɛ i ko i mwɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","Nɡe mɛyɑ i ko i kɑ Gusunɔ bɛsɛn Yinni bɛɛrɛ wɛ̃ bɛɛn wɑ̃ɑrun tɔ̃ru kpuro sɔɔ kpɑ i win woodɑbɑ kɑ win yiirebu mɛm nɔɔwɑ be nɑ bɛɛ wɛ̃ɛmɔ bɛɛ kɑ bɛɛn bibu kɑ bɛɛn debuminu kpɑ bɛɛn wɑ̃ɑru tu wɑ tu dɑkɑɑ dɑ. ");
INSERT INTO bba_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","Bɛɛ Isirelibɑ, i ko i ye swɑɑ dɑkiwɑ kpɑ i ye mɛm nɔɔwɑ kpɑ i wɑ i n bɔri yɛndu mɔ kpɑ i mɑrurɑ i dɑbiɑ nɡe mɛ Gusunɔ bɛsɛn bɑɑbɑbɑn Yinni u sun sɔ̃ɔwɑ sɑnɑm mɛ u sun tem nɔɔ mwɛɛru kuɑ mi tim kɑ bom mu kokumɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","Bɛɛ Isirelibɑ, i swɑɑ dɑkio i nɔ. Gusunɔ bɛsɛn Yinni turowɑ u sɑ̃ɑ kpuron Yinni. ");
INSERT INTO bba_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","I nùn kĩɔ kɑ bɛɛn ɡɔ̃ru kpuro kɑ bɛɛn bwɛ̃rɑ kpuro kɑ bɛɛn dɑm kpuro. ");
INSERT INTO bba_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","Woodɑ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, i de bɑ n wɑ̃ɑ bɛɛn ɡɔ̃ruɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","I bɛɛn bibu yen keu kuo kpɑ i n dɑ kɑ bu yen ɡɑri ko yɛnuɔ kɑ swɑɑɔ ì n wuu dɔɔ kɑ sɑɑ ye i ko i kpunɑ kɑ sɑɑ ye i seewɑ. ");
INSERT INTO bba_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","I de yɑ n ɡbinisi bɛɛn nɔmɑɔ kɑ bɛɛn sirinɔ kpɑ i ku rɑ kɑ ye duɑri. ");
INSERT INTO bba_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","I ye yoruo bɛɛn diɑn ɡɑmbon kɑdiribɑ sɔɔ kɑ wuun duu yerun kɔnnɔsɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","Sɑnɑm mɛ Gusunɔ bɛsɛn Yinni u koo bɛɛ kpɑrɑ u kɑ dɑ tem mɛ u koo bɛɛ wɛ̃ sɔɔ, nɡe mɛ u bɛsɛn bɑɑbɑbɑ, Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu nɔɔ mwɛɛru kuɑ, i ko i wuu bɑkɑsu kɑ wuu burɔsu wɑ si i ǹ bɑnɛ, ");
INSERT INTO bba_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","kɑ yɛnu si su ɑrumɑni bwese bwesekɑ yibɑ ye i ǹ kɑsu kɑ dɔkɔbɑ be i ǹ ɡbɑ kɑ resɛmbɑ kɑ olifibɑ be i ǹ duure. ");
INSERT INTO bba_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","I ko i dĩɑnu wɑ siki siki i n dimɔ. Adɑmɑ i n tii sɛ kpɑ i ku rɑ Gusunɔ bɛsɛn Yinni duɑri wi u sun yɑrɑ Eɡibitin di mi sɑ yoru di. ");
INSERT INTO bba_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","I ko i nùn nɑsiɑwɑ kpɑ i n wi turon wɑ̃ɑru wɑ̃ɑ. Win yĩsirɑ i ko i n dɑ kɑ bɔ̃re. ");
INSERT INTO bba_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","I ku rɑ dɑ i bwese tuku ni nu kɑ bɛɛ sikerenɛn bũnu sɑ̃. ");
INSERT INTO bba_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","Domi Gusunɔ bɛsɛn Yinni u wɑ̃ɑ bɛsɛn suunu sɔɔ. U sɑ̃ɑwɑ nisinuɡii. Ǹ n mɛn nɑ, i n tii sɛ. I ku rɑ win mɔru seeyɑ kpɑ u bɛɛ kpeerɑsiɑ hɑnduniɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","I ku rɑ win dɑm mɛɛri i kɑ wɑ mɛ mu nɛ nɡe mɛ i kuɑ sɑnɑm mɛ i wɑ̃ɑ Mɑsɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","Adɑmɑ i win woodɑbɑ kɑ win sɔ̃ɔsinu kɑ win yiire bi u bɛɛ wɛ̃ mɛm nɔɔwɔ dee dee. ");
INSERT INTO bba_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","19","Ì n mɔ̀ ye yɑ wɑ̃ Yinni Gusunɔn nɔni sɔɔ, i ko i bɔri yɛndu wɑ kpɑ i tem ɡem mɛ mwɑ sɑnɑm mɛ u bɛɛn yibɛrɛbɑ ɡirɑ u kpɑ. Domi u bɛsɛn bɑɑbɑbɑ nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri u nɛɛ, u koo bu mu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","Sɔ̃ɔ teeru bɛɛn bibu bɑ̀ n bɛɛ bikiɑ bɑ nɛɛ, mbɑn sɔ̃nɑ Gusunɔ bɛsɛn Yinni u bɛɛ woodɑ beni kɑ sɔ̃ɔsi nini kɑ yiire bini wɛ̃, ");
INSERT INTO bba_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","kpɑ i bu wisi i nɛɛ, sɑ rɑɑ sɑ̃ɑwɑ Eɡibiti sunɔn yobu Eɡibiti mi, mɑ Yinni Gusunɔ u sun yɑrɑmɑ min di kɑ win dɑm bɑkɑm. ");
INSERT INTO bba_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","U sɔm mɑɑmɑɑkiɡinu kuɑ nu kpɑ̃ bɛsɛn nɔni biru. Niyɑ u kɑ Eɡibitiɡii be, kɑ ben sinɑ boko kɑ win yɛnuɡibu nɔni swɑ̃ɑru kpɛ̃ɛ. ");
INSERT INTO bba_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","Mɑ u sun yɑrɑmɑ min di u kɑ sun dɑ tem mɛ sɔɔ, mɛ u bɛsɛn bɑɑbɑbɑ nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri u nɛɛ, u koo bu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","Gusunɔ bɛsɛn Yinni u sun yiire u nɛɛ, su woodɑ be kpuro mɛm nɔɔwɔ, kpɑ su nùn bɛɛrɛ wɛ̃. Sɑɑ yerɑ bɔri yɛndɑ ko n sun wɑ̃ɑsi bɑɑdommɑ kpɑ u n sun kɔ̃su nɡe mɛ u mɔ̀ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","Sɑ̀ n woodɑ be kpuro mɛm nɔɔwɑ dee dee nɡe mɛ u sun yiire, sɑɑ yerɑ sɑ ko n sɑ̃ɑ ɡemɡibu win wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","Gusunɔ bɛsɛn Yinni u koo de i du tem mɛ i ko i mwɑ sɔɔ kpɑ u bwese dɑbi nini ɡirɑ bɛɛn wuswɑɑn di. Niyɑ, Hɛtibɑ kɑ Giriɡɑsibɑ kɑ Amɔrebɑ kɑ Kɑnɑnibɑ kɑ Feresibɑ kɑ Hefibɑ kɑ Yebusibɑ. Nu sɑ̃ɑwɑ mi bwesenu nɔɔbɑ yiru ni nu bɛɛ dɑbiru kere mɑ nu bɛɛ dɑm kere. ");
INSERT INTO bba_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","U koo bɛɛ bu nɔmu bɛriɑ kpɑ i bu kɑmiɑ i kpeerɑsiɑ. I ku rɑ kɑ bu ɑrukɑwɑni bɔke, i ku rɑ mɑɑ ben wɔnwɔndu ko. ");
INSERT INTO bba_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","I ku rɑ kɑ bu nɔɔ tiɑ ko i suɑnɑ bɛɛ kɑ be. I ku rɑ bɛɛn bii wɔndiɑbɑ ben bii ɑluwɑɑsibɑ kɛ̃ bu suɑ kurɔbu. I ku rɑ mɑɑ ben bii wɔndiɑbɑ kɑsu bɛɛn bii ɑluwɑɑsibɑ bu suɑ kurɔbu. ");
INSERT INTO bba_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","Domi bɑ koo de bɛɛn bibu bu ɡɛrɑ Yinni Gusunɔn swɑɑn di bu ben bũnu sɑ̃, kpɑ Yinni Gusunɔ u kɑ bɛɛ mɔru ko u bɛɛ kpeerɑsiɑ mii mii. ");
INSERT INTO bba_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","Wee nɡe mɛ i ko i bu kuɑ. I ko i ben bũu turɑnu suririwɑ, kpɑ i ben bwɑ̃ɑrokunu kɔsuku i dɔ̃ɔ mɛni. ");
INSERT INTO bba_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","Domi i sɑ̃ɑwɑ bwese te Gusunɔ bɛsɛn Yinni u wunɑ nɛnɛm hɑnduniɑn bwese ni nu tie sɔɔn di, kpɑ i n kɑ sɑ̃ɑ win tɔmbu. ");
INSERT INTO bba_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","N ǹ mɔ yèn sɔ̃ i bwesenu kpuro dɑbiru kere Yinni Gusunɔ u kɑ bɛɛ ɑrukɑwɑni bɔkuɑ. Bɛɛyɑ i mɑm piiburu bo bwesenu kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","Adɑmɑ Yinni Gusunɔ u bɛɛ kĩwɑ mɑ u kĩ u win nɔɔ mwɛɛru yibiɑ te u bɛɛn bɑɑbɑbɑ kuɑ. Yen sɔ̃nɑ u bɛɛ yɑrɑmɑ kɑ win dɑm bɑkɑm Eɡibiti sunɔn yorun di. ");
INSERT INTO bba_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","Yen sɔ̃, i de i n yɛ̃ mɑ Gusunɔ bɛsɛn Yinniwɑ u sɑ̃ɑ Gusunɔ. U rɑ win ɑrukɑwɑni nɛnɛ kɑ be bɑ win woodɑbɑ mɛm nɔɔwɑmmɛ sere kɑ ben bibun bweserun nɔrɔm nɔrɔmwɔ (1.000). Be bɑ nùn kĩ, u ku rɑ bu tɔnu kɑndu kue. ");
INSERT INTO bba_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","Adɑmɑ u rɑ be bɑ nùn tusɑ ben kɔ̃sɑ kɔsiewɑ u bu kpeerɑsiɑ yɑnde. ");
INSERT INTO bba_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","Yen sɔ̃, i win woodɑbɑ kɑ win yiirebu kɑ win sɔ̃ɔsinu mɛm nɔɔwɔ ni nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, kpɑ i kɑ ye sɔmburu ko. ");
INSERT INTO bba_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","Ì n woodɑ be swɑɑ dɑki, mɑ i bu mɛm nɔɔwɑ, u ko n ɑrukɑwɑni ye nɛniwɑ mɑm mɑm ye u kɑ bɛsɛn bɑɑbɑbɑ bɔkuɑ kɑ bɔ̃ri. ");
INSERT INTO bba_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","U koo bɛɛ kĩɑ kpɑ u bɛɛ domɑru kuɑ u de i dɑbiɑ. U koo bɛɛn bibu domɑru kuɑ kɑ dĩɑ ni i duurɑ kɑ dĩɑ binnu kɑ dɑ̃ɑ bii ni bɑ rɑ kɑ tɑm ko kɑ ni bɑ rɑ kɑ ɡum ko. U koo de bɛɛn nɑɑ ɡɔ̃su kɑ bɛɛn yɑ̃ɑ ɡɔ̃su kɑ bɛɛn boo ɡɔ̃su su kuurɑ tem mɛ sɔɔ, mɛ u nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri u nɛɛ, u koo bɛɛn bɑɑbɑbɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","U koo bɛɛ domɑru kuɑ n bwesenu kpuro kere. Bɛɛ sɔɔ, tɔn durɔ ɡoo, ǹ kun mɛ tɔn kurɔ ɡoo kun mɔ̀ wĩro. Mɛyɑ bɛɛn yɑɑ sɑberu ɡɑrɑ kun mɑɑ ɡimɑre mɔ̀. ");
INSERT INTO bba_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","Yinni Gusunɔ u koo de bɑrɑnu nu kɑ bɛɛ tondɑ. I yɛ̃ bɑrɑ kɔ̃su ni u rɑɑ Eɡibitiɡibu sure. U ǹ derimɔ ten ɡɑru tu bɛɛ deemɑ. Adɑmɑ be bɑ bɛɛ tusɑ, berɑ u koo nu sure. ");
INSERT INTO bba_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","I ko i bwesenu kpuro kpeerɑsiɑwɑ mɑm mɑm ni Yinni Gusunɔ u bɛɛ nɔmu bɛriɑ. I ku rɑ nin wɔnwɔndu ko, i ku rɑ mɑɑ nin bũnu sɑ̃. Domi bũu ni, nu ko n sɑ̃ɑwɑ yinɑ bɛɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","Sɔrɔkudo i ko i ɡere bɛɛn ɡɔ̃ruɔ i nɛɛ, bwese ni, nu bɛɛ dɑm kere. Amɔnɑ i ko i ko i kɑ nu ɡirɑ. ");
INSERT INTO bba_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","I ku nin bɛrum ko. I yɑɑyo ye Gusunɔ bɛsɛn Yinni u Eɡibitiɡibu kpuro kɑ ben sunɔ kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","Bɛɛn nɔni yi wɑ nɔni swɑ̃ɑ bɑkɑ te u bu kpɛ̃ɛ kɑ sɔm mɑɑmɑɑkiɡii ni u kuɑ kɑ win dɑm bɑkɑm mɛ u sɔ̃ɔsi sɑnɑm mɛ u bɛɛ yɑrɑmɑ tem mɛn di. Nɡe mɛyɑ u koo mɑɑ bwese ni kpuro kuɑ nìn bɛrum i mɔ mi. ");
INSERT INTO bba_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","U koo nu susu bɑkɑnu sure sere be bɑ kisirɑ bɑ kuku yenu kɑsu bu kɑ kpeerɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","I ku diiri bwese nin sɔ̃. Domi Gusunɔ bɛsɛn Yinni u kɑ bɛɛ wɑ̃ɑ wi, wi u kpɑ̃ mɑ u nɑnum mɔ. ");
INSERT INTO bba_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","U koo bɛɛ bwese ni kpuro ɡirɑ kpurɛ kpurɛ. I ǹ kpɛ̃ i nu kpeerɑsiɑ mii mii ɡbeeku yɛɛ yi ku kɑ bɛɛ yibusin sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","Gusunɔ bɛsɛn Yinni wi, u koo bɛɛ bu nɔmu bɛriɑ. U koo de bu duki su bɛɛn wuswɑɑn di sere bu kɑ kpeerɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","U koo bɛɛ ben sinɑmbu nɔmu bɛriɑ kpɑ i de ben yĩsiru tu ɡbi hɑnduniɑ sɔɔ. Ben ɡoo kun yɔ̃rɑmɔ bɛɛn wuswɑɑɔ. I ko i bu kpeerɑsiɑwɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","I ko i ben bwɑ̃ɑrokunu dɔ̃ɔ mɛniwɑ. I ku nin sii ɡeesu kɑ nin wurɑ ye bɑ nu sebusie binɛ ko i suɑ kpɑ yu ku rɑɑ ko bɛɛn yinɑ. Domi yɑ sɑ̃ɑwɑ disi wi, Gusunɔ bɛsɛn Yinnin mi. ");
INSERT INTO bba_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","I ku rɑ bwɑ̃ɑroku nin bweseru duusiɑ bɛɛn diɑɔ. Ì n kuɑ mɛ, i ko kɑm kowɑ kɑ ni sɑnnu. I ko i nu bwɛ̃rɑ yɑriwɑ, i nu ɡɑrisi disiɡinu. Domi nu koo kɑm kowɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","I woodɑ be mɛm nɔɔwɔ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ kpɑ bɛɛn hunde yu dɑkɑɑ dɑ, kpɑ i mɑrurɑ i dɑbiɑ, kpɑ i du tem mɛ sɔɔ, mɛ Yinni Gusunɔ u nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri u nɛɛ, u koo bɛɛn bɑɑbɑbɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","I yɑɑyo sɑnum bɑkɑm mɛ Gusunɔ bɛsɛn Yinni u derɑ sɑ sĩɑ ɡbɑburɔ sere wɔ̃ɔ weeru. Mɑ u bɛsɛn lɑɑkɑri mɛɛrɑ, u derɑ sɑ nɔni sɔ̃ɔrɑ su kɑ tii kɑwɑ kpɑ u kɑ bɛsɛn ɡɔ̃run bwisikunu ɡiɑ, kpɑ u wɑ sɑ̀ n ko win woodɑ mɛm nɔɔwɑn nɑ, ǹ kun mɛ su ye yinɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","U derɑ sɑ nɔni sɔ̃ɔrɑ sɑ wɑhɑlɑ kuɑ ɡɔ̃ɔrun sɔ̃, su kɑ tii kɑwɑ mɑ u sun mɑnnɑ wɛ̃, dĩɑ ni bɛsɛ kɑ bɛsɛn bɑɑbɑbɑ sɑ ǹ dɑɑ yɛ̃. Nɡe mɛyɑ u kɑ sun sɔ̃ɔsi mɑ tɔnu kun ko n wɑ̃ɑ dĩɑnu tɔnɑn sɔ̃ mɑ n kun mɔ wi, Gusunɔn ɡere kpuron sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","Wɔ̃ɔ weeru ye sɔɔ, bɛsɛn yɑ̃nu kun kpeere, bɛsɛn nɑɑsu kun mɑɑ mɔsire. ");
INSERT INTO bba_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","I n yɛ̃ mɑ Gusunɔ bɛsɛn Yinni u sun nɔni dokewɑ nɡe mɛ tɔnu u rɑ win bii nɔni doke. ");
INSERT INTO bba_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","I Gusunɔ bɛsɛn Yinnin woodɑbɑ mɛm nɔɔwɔ i sĩ win swɛɛ sɔɔ, kpɑ i nùn nɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","Gusunɔ bɛsɛn Yinni u koo bɛɛ duusiɑ tem ɡem sɔɔ, mi nim tori kɑ yɛrusu kɑ bwii dɑbirɑ wɑ̃ɑ wɔwi sɔɔ kɑ ɡuunɔ. ");
INSERT INTO bba_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","Alikɑmɑ kɑ dobi kɑ dɑ̃ɑ bii ni bɑ mɔ̀ resɛm kɑ fiɡi kɑ ɡerenɑdi yɑ kpiɑ tem mɛ sɔɔ mɑ mu olifin ɡum kɑ tim yibɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","Tem mɛ sɔɔ, i ko i dĩɑnu wɑ nu n kpɑ̃ i di, i ǹ mɑɑ ɡɑ̃ɑnu ɡɑnun yɑ̃ɑru mɔ̀. Mɛn kpenu nu ko n sii wɔ̃kusu mɔ, kpɑ mɛn ɡuunun sɔɔwɔ sii ɡɑndɑ n wɑ̃ɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","Sɑnɑm mɛ i dĩɑnu wɑ i di i debɑ, i Gusunɔ bɛsɛn Yinni siɑro tem ɡem mɛ u bɛɛ wɛ̃n sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","I n tii sɛ kpɑ i ku rɑ Gusunɔ bɛsɛn Yinni duɑri. I ku rɑ win woodɑbɑ kɑ win sɔ̃ɔsinu kɑ win yiirebu mɛm nɔɔbu yinɑ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","I ko i dĩɑnu wɑ i di i debu kpɑ i dii ɡeenu bɑni i n wɑ̃ɑ ni sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","Bɛɛn kɛtɛbɑ kɑ bɛɛn yɑ̃ɑnu kɑ bɛɛn bonu nu koo mɑrurɑ nu dɑbiɑ kpɑ bɛɛn sii ɡeesu kɑ bɛɛn wurɑ kɑ bɛɛn ɑrumɑni bwese bwesekɑ ye i mɔ yu kuurɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","Sɑɑ ye sɔɔ, i n tii sɛ kpɑ i ku rɑ tii suɑ i Gusunɔ bɛsɛn Yinni duɑri wi, wi u sun yɑrɑmɑ Eɡibitin di, mi sɑ rɑɑ yoru dimɔ. ");
INSERT INTO bba_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","U derɑ sɑ sĩɑ ɡbɑbu bɑkɑ nɑnumɡiru sɔɔ mi wɛɛ dɛ̃ɛɡii kɑ nii yi wɑ̃ɑ, mi tem mu ɡbere, nim sɑri, mɑ u derɑ nim mu kokumɑ kperun di bɛsɛn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","U sun mɑnnɑ wɛ̃ ɡbɑburu mi, sɑ di ye bɛsɛn bɑɑbɑbɑ bɑ ǹ dɑɑ yɛ̃. Mɑ u derɑ sɑ nɔni sɔ̃ɔrɑ su kɑ tii kɑwɑ kpɑ u kɑ bɛsɛn lɑɑkɑri mɛɛri u sere sun ɡeɑ kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","I n tii sɛ kpɑ i ku rɑ ɡere i nɛɛ, bɛɛn hɑniɑ kɑ bɛɛn tiin dɑmɑ i kɑ ɑrumɑni ye wɑ. ");
INSERT INTO bba_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","I yɑɑyo mɑ Gusunɔ bɛsɛn Yinniwɑ u bɛɛ dɑm wɛ̃ i kɑ ɑrumɑni ye wɑ. Mɑ u ɑrukɑwɑni ye sire ye u kɑ bɛsɛn bɑɑbɑbɑ bɔkuɑ kɑ bɔ̃ri nɡe mɛ i wɑɑmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","20","Ì kun Gusunɔ bɛsɛn Yinni mɛm nɔɔwɛ, mɑ i nùn duɑri, i dɑ i bũnu yiirɑmmɛ i sɑ̃ɑmɔ, nɑ bɛɛ sɔ̃ɔmɔ nɑ siremɔ ɡisɔ, i ko i kpeerɑwɑ nɡe mɛ u bwese ni kpeerɑsiɑ bɛsɛn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","Bɛɛ Isirelibɑ, i swɑɑ dɑkio i nɔ. Wee ɡisɔ, i ko i Yuudɛni tɔburɑ kpɑ i bwese bɑkɑnu ɡirɑ ni nu bɛɛ dɑm kere, kpɑ i ben wuu bɑkɑsu mwɑ si bɑ ɡbɑ̃rɑnu toosi nu ɡunu too. ");
INSERT INTO bba_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","I Anɑkibɑ yɛ̃. Bɑ dɑm mɔ, mɑ bɑ ɡunu. I mɑɑ nɔɔre bɑ ben ɡɑri ɡerumɔ bɑ mɔ̀, wɑrɑ u koo kpĩ u yɔ̃rɑ ben bweserun wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","Wee i ko bu ɡirɑ. Gisɔ i ko i ɡiɑ mɑ Gusunɔ bɛsɛn Yinnin tiiwɑ u ko n bɛɛ ɡbiiye nɡe dɔ̃ɔ wi u rɑ kpuro kɑm koosie. U koo de bu yɑrinɑ bɛɛn wuswɑɑn di u bu kpeerɑsiɑ. I ko i bu ɡirɑ kpɑ i bu kɑm koosiɑ fuuku nɡe mɛ Yinni Gusunɔ u bɛɛ sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","Sɑnɑm mɛ Gusunɔ bɛsɛn Yinni u koo bɛɛ bu ɡirɑ bɛɛn wuswɑɑn di, i ku rɑ tii suɑ i nɛɛ, bɛɛn ɡeɑn kobun sɔ̃nɑ Yinni Gusunɔ u bɛɛ duusiɑ tem mɛ sɔɔ. Domi bwese nin kɔ̃sɑn kobun sɔ̃nɑ u koo nu ɡirɑ bɛɛn wuswɑɑn di. ");
INSERT INTO bba_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","N ǹ mɔ ɡeɑ ye i mɔ̀n sɔ̃nɑ i ko i ben tem mɛ mwɑ. Ben kɔ̃sɑn kobun sɔ̃nɑ Gusunɔ bɛsɛn Yinni u koo bu ɡirɑ bɛɛn wuswɑɑn di, kpɑ win nɔɔ mwɛɛru tu kɑ sirerɑ te u bɛsɛn bɑɑbɑbɑ, Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu kuɑ kɑ bɔ̃ri. ");
INSERT INTO bba_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","I n yɛ̃ mɑ n ǹ mɔ bɛɛn ɡeɑn kobun sɔ̃nɑ Gusunɔ bɛsɛn Yinni u bɛɛ tem ɡem mɛ wɛ̃ɛmɔ i n mɔ. Domi i sɑ̃ɑwɑ bwese te tɑ ku rɑ mɛm nɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","I yɑɑyo nɡe mɛ i Gusunɔ bɛsɛn Yinnin mɔru seeyɑ ɡbɑburɔ. Sɑɑ dɔmɑ tèn di i yɑrimɑ Eɡibitin di sere i kɑ tunumɑ mini, i rɑ n nùn seesimɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","I win mɔru seeyɑ ɡuu te bɑ mɔ̀ Horɛbuɔ, mɑ u kɑ bɛɛ mɔru kuɑ u ɡɔ̃ru doke u bɛɛ kpeerɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","Sɑnɑm mɛyɑ nɑ yɔɔwɑ ɡuuru wɔllɔ n kɑ woodɑn kpee bɛsi mwɑ yì sɔɔ ɑrukɑwɑni ye Yinni Gusunɔ u kɑ bɛɛ bɔkuɑ yɑ yoruɑ. Nɑ sinɑwɑ miɡum sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru, nɑ ǹ di, nɑ ǹ mɑɑ nɔrɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","11","Sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru wee ten biru, yerɑ Yinni Gusunɔ u mɑn kpee bɛsi yiru ye wɛ̃, yì sɔɔ win tii u woodɑbɑ kpuro yoruɑ, be u bɛɛ sɔ̃ɔwɑ dɔ̃ɔ yɑrɑ sɔɔn di sɑnɑm mɛ i mɛnnɛ ɡuurun nuurɔ. Kpee bɛsi yiyɑ yì sɔɔ bɑ ɑrukɑwɑni yen woodɑ yoruɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","Mɑ u mɑn sɔ̃ɔwɑ u nɛɛ, n seewo kpɑ n sɑrɑ fuuku fuuku. Domi bɛɛ nɛn tɔn be nɑ yɑrɑmɑ Eɡibitin di, i kɔ̃sɑ kuɑ. I ɡɛrɑ fuuku win swɑɑn di ye u bɛɛ sɔ̃ɔsi. I sisu yɑniɑ i kɑ tii bwɑ̃ɑroku kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","Mɑ u mɑɑ nɛɛ, u wɑ mɑ i sɑ̃ɑwɑ bwese te tɑ deɡɑnɡɑm mɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","N be de u bɛɛ kpeerɑsiɑ, kpɑ u bɛɛn yĩsiru ɡo hɑnduniɑ sɔɔ, kpɑ u mɑn ko bwese dɑmɡiru te tɑ koo bɛɛ dɑbiru kerɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","Mɑ nɑ ɡɔsirɑmɑ nɑ sɑrɑmɑ ɡuu ten min di, tèn wɔllɔ dɔ̃ɔ u wɑ̃ɑ. Nɑ kpee bɛsi yiru ye nɛni yì sɔɔ ɑrukɑwɑnin woodɑ yɑ yoruɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","Mɑ nɑ mɛɛrɑ nɑ deemɑ wee, i Gusunɔ bɛsɛn Yinni torɑriwɑ kɑ ɡem. I sisu yɑniɑ i kɑ tii bwɑ̃ɑroku kuɑ ɡɑ kɑ nɑɑ buu weenɛ. Geemɑ, i ɡɛrɑwɑ fuuku fuuku win swɑɑn di ye u bɛɛ sɔ̃ɔsi. ");
INSERT INTO bba_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","Mɑ nɑ kpee bɛsi yiru ye nɑ nɛni mi mɛnnɑ nɑ surɑ nɑ kɔsukɑ bɛɛn wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","Yen biru, nɑ kpunɑ Yinni Gusunɔn wuswɑɑɔ sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru nɡe yellu, nɑ ǹ di, nɑ ǹ mɑɑ nɔrɑ bɛɛn torɑrun sɔ̃ te i kuɑ Yinni Gusunɔn nɔni sɔɔ mɑ tɑ win mɔru seeyɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","Mɑ bɛrum mɑn mwɑ win mɔru yen kpɑ̃ɑrun sɔ̃ ye yɑ derɑ u kĩ u bɛɛ kpeerɑsiɑ. Adɑmɑ dɔmɑ te, u kpɑm nɛn kɑnɑru mwɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","Yinni Gusunɔ u mɑɑ kɑ Aroni mɔru kuɑ too, mɑ u kĩ u nùn ɡo. Adɑmɑ nɑ mɑɑ kɑnɑru kuɑ win sɔ̃ tɔ̃ɔ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","Mɑ nɑ bwɑ̃ɑroku ɡe suɑ ɡe i kuɑ ɡɑ kɑ nɑɑ buu weenɛ mi, ɡèn sɔ̃ i torɑ, mɑ nɑ ɡu kpɛ̃ɛ dɔ̃ɔ sɔɔ. Nɑ ɡu muniɑ ɡɑ buuru kuɑ nɡe tuɑ mɑ nɑ ye wisi nim bwerɔ tèn nim mu sɑrɑmɑmɔ ɡuurun di. ");
INSERT INTO bba_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","I mɑɑ Yinni Gusunɔn mɔru seeyɑ Tɑberɑɔ kɑ Mɑsɑɔ kɑ Kiburɔti Hɑtɑfɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","Sɑnɑm mɛ u bɛɛ ɡɔrɑ Kɑdɛsi Bɑɑnɛɑɔ u nɛɛ, i doo i tem mɛ mwɑ mɛ u bɛɛ wɛ̃ɛmɔ, i nùn seesiwɑ wi, wi u sɑ̃ɑ Gusunɔ bɛɛn Yinni. I yinɑ i bɛɛn nɑɑnɛ doke wi sɔɔ. I ǹ mɑɑ win ɡere mɛm nɔɔwɛ. ");
INSERT INTO bba_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","I rɑ n Yinni Gusunɔ seesimɔwɑ sɑɑ mìn di nɑ bɛɛ yɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","Mɑ nɑ kpunɑ Yinni Gusunɔn wuswɑɑɔ nɑ nùn kɑnɑ sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru yèn sɔ̃ u nɛɛ, u koo bɛɛ kpeerɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","Mɑ nɑ nùn kɑnɑ nɑ nɛɛ, Gusunɔ nɛn Yinni, ɑ ku wunɛn tɔmbu kpeerɑsiɑ be bɑ sɑ̃ɑ wunɛn ɑrumɑni, be, be ɑ yɑkiɑ wunɛn kpɑ̃ɑrun sɑɑbu, mɑ ɑ bu yɑrɑmɑ Eɡibitin di kɑ wunɛn dɑm bɑkɑm. ");
INSERT INTO bba_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","A wunɛn sɔm kowobu, Aburɑhɑmu kɑ Isɑki kɑ Yɑkɔbu yɑɑyo. A ku wunɛn tɔmbun deɡɑnɡɑm kɑ ben nuku kɔ̃suru kɑ ben torɑnu mɛɛri, ");
INSERT INTO bba_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","kpɑ tɔn bèn tem di ɑ bu yɑrɑmɑ bu ku rɑɑ ɡere bu nɛɛ, wunɛ Yinni Gusunɔ ɑ ǹ kpɛ̃ ɑ kɑ bu dɑwɑ tem mɛ ɑ bu nɔɔ mwɛɛru kuɑ sɔɔ. A ǹ bu kĩwɑ. Yen sɔ̃nɑ ɑ bu yɑrɑmɑ ɑ kɑ de bu ɡbi ɡbɑburɔ. ");
INSERT INTO bba_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","N sere deemɑ bɑ sɑ̃ɑwɑ wunɛn tɔmbu kɑ wunɛn ɑrumɑni mɑ ɑ bu yɑrɑmɑ Eɡibitin di kɑ wunɛn dɑm bɑkɑm. ");
INSERT INTO bba_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","Sɑɑ ye sɔɔ, Yinni Gusunɔ u mɑn sɔ̃ɔwɑ u nɛɛ, n kpee bɛsi yiru dɑ̃kuo yi n kɑ yiɔnɔ weenɛ kpɑ n kpɑkororu ko kɑ dɑ̃ɑ kpɑ n yɔɔmɑ win mi ɡuuru wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","U koo mɑɑ woodɑ be bɑ rɑɑ wɑ̃ɑ kpee bɛsi yi nɑ kɔsukɑ sɔɔ yore kpee bɛsi yini sɔɔ, kpɑ n yi doke kpɑkororu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","Mɑ nɑ kpɑkoro te kuɑ kɑ ɑkɑsiɑn dɑ̃ɑ. Nɑ kpee bɛsi yiru ye dɑ̃kɑ yi kɑ yiɔnɔ weenɛ. Mɑ nɑ yɔɔwɑ ɡuu ten wɔllɔ nɑ kpee bɛsi yi nɛni. ");
INSERT INTO bba_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","Mɑ Yinni Gusunɔ u woodɑ wɔku te tɑ rɑɑ yoruɑ kpee bɛsi yiɔnɔ sɔɔ yoruɑ yini sɔɔ, be u rɑɑ bɛɛ sɔ̃ɔwɑ dɔ̃ɔ yɑrɑ sɔɔn di dɔmɑ te i kɑ mɛnnɑ ɡuu ten nuurɔ. Mɑ u mɑn yi wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","Mɑ nɑ ɡɔsirɑmɑ nɑ sɑrɑmɑ ɡuu ten wɔllun di. Mɑ nɑ kpee bɛsi yi doke kpɑkoro te nɑ kuɑ mi sɔɔ. Miyɑ yi wɑ̃ɑ nɡe mɛ Yinni Gusunɔ u mɑn yiire n ko. ");
INSERT INTO bba_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","Yen biru, bɛsɛ Isirelibɑ sɑ doonɑ Beerɔtu Bɛnɛ Yɑkɑnin di sɑ dɑ Mɔserɑɔ. Miyɑ Aroni u kpunɑ u ɡu mɑ sɑ nùn sikɑ mi. Mɑ win bii Eleɑsɑɑ u kuɑ yɑ̃ku kowo win ɑyerɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","Sɑɑ min di, mɑ sɑ dɑ Guduɡodɑɔ. Sɑɑ Guduɡodɑn di, mɑ sɑ dɑ Yotibɑtɑɔ, tem mi dɑru tori yibɑ. ");
INSERT INTO bba_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","Sɑɑ ye sɔɔrɑ Yinni Gusunɔ u Lefin bwese kɛrɑ ɡɔsɑ, mɑ u bu yiire u nɛɛ, berɑ bɑ ko n dɑ win woodɑn kpɑkororu sɔbe kpɑ bɑ n dɑ sɔmburu ko win sɑ̃ɑ yerɔ. Kpɑ bɑ n dɑ mɑɑ Isirelibɑ domɑru kue kɑ win yĩsiru. Sɔmbu terɑ bɑ rɑ ko sere kɑ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","Yen sɔ̃nɑ Lefibɑ bɑ ǹ tem wɑ ben mɛro bisibun suunu sɔɔ. Yinni Gusunɔɡiɑ yɑ sɑ̃ɑ ben tubi nɡe mɛ u bu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","Mɑ nɑ sinɑ ɡuuru wɔllu mi, sɔ̃ɔ sɔɔ weeru kɑ wɔ̃kuru weeru nɡe mɛ nɑ rɑɑ kuɑ yellu. Mɑ Yinni Gusunɔ u mɑɑ nɛn kɑnɑru mwɑ u nɛɛ, u ǹ mɑɑ bɛɛ kpeerɑsiɑmɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","Mɑ u mɑn sɔ̃ɔwɑ u nɛɛ, n seewo n dɑ n bɛɛ ɡbiiyɑ kpɑ i dɑ i tem mɛ mwɑ mɛ u bɔ̃ruɑ u nɛɛ, u koo bɛsɛn bɑɑbɑbɑ wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","Tɛ̃, bɛɛ Isirelibɑ, ye Gusunɔ bɛsɛn Yinni u kĩ, yerɑ i nùn nɑsiɑ, i n sĩimɔ win swɛɛ kpuro sɔɔ, kpɑ i nùn kĩɑ i n nùn sɑ̃ɑmɔ kɑ bɛɛn ɡɔ̃ru kpuro kɑ bɛɛn bwɛ̃rɑ kpuro, ");
INSERT INTO bba_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","kpɑ i win woodɑbɑ kɑ win yiirebu mɛm nɔɔwɑ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ kpɑ i wɑ i n bɔri yɛndu mɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","Domi wiyɑ u wɔllu mɔ kɑ tem kɑ ye yɑ wɑ̃ɑ mɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","Bɛɛn bɑɑbɑbɑ tɔnɑwɑ u kɑ ɑrukɑwɑni bɔkuɑ mɑ u bu kĩɑ. Yen biru, bwesenu kpuro sɔɔ, bɛɛyɑ u ɡɔsɑ bɛɛ be i sɑ̃ɑ ben bibu nɡe mɛ i wɑɑmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","Yen sɔ̃, i nùn tii wɛ̃ɛyɔ mɑm mɑm kpɑ i ku mɑɑ nùn seesi. ");
INSERT INTO bba_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","Domi u sɑ̃ɑwɑ wɔllun Yinni kɑ yinnibun Yinni. U kpɑ̃, u dɑm mɔ, mɑ u nɑnum mɔ. U ku rɑ ɡoon nɔnu mɛɛri, u ku rɑ mɑɑ nɔm birɑn kɛ̃ru mwɛ. ");
INSERT INTO bba_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","U rɑ ɡobekubɑ kɑ ɡɔminibu ben ɡem wɛ̃, kpɑ u sɔbu kĩru sɔ̃ɔsi u bu dĩɑnu kɑ yɑ̃nu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","Yen sɔ̃, i sɔbu kĩɔ bɛɛn tii, domi i rɑɑ sɔru di Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","I Gusunɔ bɛsɛn Yinni nɑsio kpɑ i wi turo sɑ̃. I kɑ nùn mɑninɔ, kpɑ i n dɑ bɔ̃re kɑ wi turon yĩsiru. ");
INSERT INTO bba_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","Wiyɑ n weenɛ i siɑrɑ domi u sɑ̃ɑwɑ bɛsɛn Yinni. U mɑɑ ɡɑ̃ɑ bɑkɑ nɑnumɡinu kuɑ bɛsɛn suunu sɔɔ sɑ wɑ kɑ nɔni. ");
INSERT INTO bba_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","Bɛsɛn bɑɑbɑbɑ bɑ sɑ̃ɑwɑ tɔmbu wɑtɑ kɑ wɔkuru sɑnɑm mɛ bɑ dɑ Eɡibitiɔ. Adɑmɑ tɛ̃, u derɑ sɑ dɑbiɑ nɡe wɔllun kperi. ");
INSERT INTO bba_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","I Gusunɔ bɛsɛn Yinni kĩɔ kpɑ i win yiirebu kɑ win sɔ̃ɔsinu kɑ win ɡere kɑ win woodɑbɑ mɛm nɔɔwɑ bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","Tɛ̃, nɑ ǹ kɑ bɛɛn bibu ɡɑri mɔ̀, be, be bɑ ǹ wɑ, bɑ ǹ mɑɑ yɛ̃ nɡe mɛ Gusunɔ bɛsɛn Yinni u win dɑm sɔ̃ɔsisinɑ. Adɑmɑ bɛɛn tiiwɑ nɑ kɑ ɡɑri mɔ̀, bɛɛ be i win kpɑ̃ɑru kɑ win dɑm bɑkɑm seedɑ kuɑ ");
INSERT INTO bba_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","kɑ sere mɑɑ mɑɑmɑɑki nɑnumɡiɑ ye u kuɑ u kɑ Eɡibitin sunɔ kɑ win temɡibu kpuro sɛɛyɑsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","I yɛ̃ ye u ben tɑbu kowobu kɑ ben dumi kɑ ben tɑbu kɛkɛbɑ kuɑ. U derɑ nim wɔ̃ku ɡe bɑ mɔ̀ Nɑɑ yɑri ɡɑ bu di sɑnɑm mɛ bɑ sun nɑɑ ɡire mɑ u bu kpeerɑsiɑ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","Mɑ u sun kɔ̃su ɡbɑburɔ sere sɑ kɑ tunumɑ mini. ");
INSERT INTO bba_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","U derɑ tem mu nɔɔ wukiɑ mu Dɑtɑni kɑ Abirɑmu, Eliɑbun bibu, Rubɛnin bweseru sɔɔ mwɛ kɑ ben yɛnuɡibu kɑ ben kuu bekuruɡinu kɑ be bɑ kɑ bu nɔɔ tiɑ kuɑ kpuro sɑnnu bɛsɛ Isirelibɑ kpuron wuswɑɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","Bɛsɛn nɔni yi ɡɑ̃ɑ bɑkɑ ni kpuro wɑ ni Yinni Gusunɔ u kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","Yen sɔ̃, i woodɑ be kpuro mɛm nɔɔwɔ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ kpɑ i dɑm wɑ i kɑ tem mɛ mwɑ mɛ̀ sɔɔ i ko i du mi, ");
INSERT INTO bba_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","kpɑ bɛɛn wɑ̃ɑru tu dɑkɑɑ dɑ tem mɛ sɔɔ, mɛ̀n nɔɔ mwɛɛru Yinni Gusunɔ u kuɑ kɑ bɔ̃ri u nɛɛ, u koo bɛsɛn bɑɑbɑbɑ kɑ ben bibun bweseru wɛ̃, mɛ̀ sɔɔ tim kɑ bom mu yibɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","Tem mɛ i ko i mwɑ mi, mu ǹ sɑ̃ɑ nɡe Eɡibitin tem mìn di i yɑrimɑ, mi ì n dĩɑnu duurɑ i kpɑ, i rɑ nu nim yɛ̃ke nɡe kɑrɑ mi bɑ kpee duurɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","Tem mɛni, mu sɑ̃ɑwɑ tem ɡuunuɡim kɑ wɔwiɡim mɛ̀ sɔɔ ɡurɑ yɑ rɑ nɛ. ");
INSERT INTO bba_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","Gusunɔ bɛsɛn Yinni u rɑ tem mɛ nɔɔriwɑ kpɑ u mu kɔ̃su sɑɑ wɔ̃ɔn torubun di sere ɡen kpeerɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","Ì n woodɑbɑ mɛm nɔɔwɑ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, mɑ i Gusunɔ bɛɛn Yinni kĩɑ mɑ i nùn sɑ̃ɑmɔ kɑ bɛɛn ɡɔ̃ru kpuro kɑ bɛɛn bwɛ̃rɑ kpuro, ");
INSERT INTO bba_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","u koo de ɡurɑ yu nɛ yen sɑɑ sɔɔ bɛɛn tem sɔɔ kpɑ ɑlikɑmɑ yu koorɑ i wɑ i ɡɛ̃ kpɑ i mɑɑ dɑ̃ɑ binu sɔri ni bɑ rɑ kɑ tɑm ko kɑ ni bɑ rɑ kɑ ɡum ko. ");
INSERT INTO bba_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","U koo mɑɑ de yɑkɑsu su kpi bɛɛn yɑɑ sɑbenun sɔ̃. I ko i mɑɑ deburu wɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","Yen sɔ̃, i n tii sɛ kpɑ i ku rɑ ɡɛrɑ swɑɑ ɡeɑn di i dɑ i bũnu yiirɑ i nu sɑ̃. ");
INSERT INTO bba_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","Domi yɑ koo de Yinni Gusunɔ u kɑ bɛɛ mɔru ko, kpɑ u wɔllu kɛnɛ ɡurɑ yu yɔ̃rɑ yu ku mɑɑ nɛ, kpɑ tem mu ku mɑɑ dĩɑnu ko kpɑ i ɡbi mii mii tem ɡem mɛ sɔɔ, mɛ u bɛɛ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","Gɑri yi nɑ bɛɛ sɔ̃ɔmɔ, i de yi n wɑ̃ɑ bɛɛn ɡɔ̃ruɔ kɑ bɛɛn nɔɔwɔ. I de yi n ɡbinisi bɛɛn ɡɑ̃senɔ kɑ bɛɛn sirinɔ kpɑ i n kɑ yi yɑɑye. ");
INSERT INTO bba_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","I ko i yi bɛɛn bibu keu kowɑ kpɑ i n dɑ bu yin ɡɑri sɔ̃ yɛnusɔ kɑ swɑɑɔ ì n wuu dɔɔ kɑ sɑnɑm mɛ i ko i kpunɑ kɑ sɑnɑm mɛ i seewɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","I yi yoruo bɛɛn diɑn ɡɑmbobɑn kɑdiribɑ sɔɔ kɑ wuu duu yerun kɔnnɔsɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","Ì n kuɑ mɛ, nɡe mɛ̀n nɔɔ wɔllu kɑ tem mu wɑ̃ɑ, nɡe mɛn nɔrɑ Yinni Gusunɔ u koo de bɛɛn wɑ̃ɑru tu dɛnyɑ tem mɛ sɔɔ, mɛ u bɛsɛn bɑɑbɑbɑ nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri u nɛɛ, u koo bu wɛ̃. ");
INSERT INTO bba_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","Ì n woodɑ be kpuro mɛm nɔɔwɑ be nɑ bɛɛ wɛ̃ mi, mɑ i kɑ be sɔmburu kuɑ i Gusunɔ bɛsɛn Yinni kĩɑ, mɑ i sĩɑ win swɛɛ kpuro sɔɔ, mɑ i kɑ nùn mɑninɛ mɑm mɑm, ");
INSERT INTO bba_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","sɑɑ ye sɔɔrɑ u koo bɛɛ bwese ni kpuro ɡirɑ ni nu bɛɛ dɑm kɑ dɑbiru kere mi, kpɑ i nin tem mwɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","Mi i nɑɑsu sɔndi kpuro mu koo kowɑ bɛɛɡim. Bɛɛn tem mɛn nɔɔ burɑ yerɑ ko n wɑ̃ɑwɑ sɑɑ tem sɑɑrɑn di sɔ̃ɔ yɛ̃sɑn nɔm dwɑrɔ n kɑ dɑ Libɑnin ɡuunɔ sɔ̃ɔ yɛ̃sɑn nɔm ɡeuɔ, sɑɑ mɑɑ dɑɑ bɑkɑ te bɑ mɔ̀ Efɑrɑtin di sɔ̃ɔ yɑri yerɔ, n kɑ ɡirɑri nim wɔ̃ku ɡe bɑ mɔ̀ Mɛditerɑnɛɔ sɔ̃ɔ duu yeru ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","Goo kun kpɛ̃ u yɔ̃rɑ bɛɛn wuswɑɑɔ u bɛɛ mɑ. Yɑm kpuro mi i ko dɑ tem mɛ sɔɔ, Gusunɔ bɛsɛn Yinni u koo de min tɔmbu bu bɛrum soorɑ kpɑ bɑ n nɑnde bɛɛn sɔ̃ nɡe mɛ u bɛɛ yen nɔɔ mwɛɛru kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","I swɑɑ dɑkio i nɔ. Domɑru kɑ bɔ̃ri wee. I ɡɔsio ye i kĩ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","Ì n Gusunɔ bɛsɛn Yinnin woodɑbɑ mɛm nɔɔwɑ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, i ko i domɑru wɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","Adɑmɑ ì n yinɑ i win woodɑbɑ mɛm nɔɔwɑ, mɑ i ɡɛrɑ win swɑɑn di ye nɑ bɛɛ sɔ̃ɔsimɔ ɡisɔ, mɑ i dɑ i bũnu sɑ̃wɑ ni i ǹ dɑɑ yɛ̃, i ko i bɔ̃ri wɑ. ");
INSERT INTO bba_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","Sɑnɑm mɛ Gusunɔ bɛsɛn Yinni u koo de i du tem mɛ i ko i mwɑ sɔɔ, ɡuu te bɑ mɔ̀ Gɑrisimun wɔllɔwɑ i ko i domɑrun ɡɑri kpɑrɑ kpɑ i mɑɑ bɔ̃rin ɡɑri kpɑrɑ ɡuu te bɑ mɔ̀ Ebɑlin wɔllɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","Guu ni, nu wɑ̃ɑwɑ Yuudɛnin ɡuru ɡiɔ, swɑɑ ye yɑ wɑ̃ɑ sɔ̃ɔ duu yeru ɡiɑn biruɔ, Kɑnɑnibɑn temɔ, be bɑ wɑ̃ɑ Yuudɛnin wɔwɑɔ, Giliɡɑlin deedeeru, Mɔren dɑ̃ɑ sɔ̃ɔn bɔkuɔ. ");
INSERT INTO bba_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","I ko i Yuudɛni tɔburɑ i dɑ i tem mɛ mwɑ mɛ Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃ɛmɔ. Mu koo ko bɛɛɡim kpɑ i sinɑ mi, ");
INSERT INTO bba_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","kpɑ i woodɑbɑ kɑ yiirebu kpuro mɛm nɔɔwɑ mɑm mɑm be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","Woodɑbɑ kɑ yiirebu wee ye i ko i mɛm nɔɔwɑ i kɑ sɔmburu ko bɛɛn wɑ̃ɑrun tɔ̃ru kpuro sɔɔ tem mɛ sɔɔ, mɛ Gusunɔ bɛsɛn bɑɑbɑbɑn Yinni u bɛɛ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","I ko i bwese ni i ko i ɡirɑ min bũnun sɑ̃ɑ yenu kpuro kɔsukuwɑ mɑm mɑm ɡuunɔ kɑ ɡunɡunɔ kɑ dɑ̃ɑ kubenɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","I ko i ben yɑ̃ku yenu suririwɑ, kpɑ i ben bũu turɑnu kɔsuku. I ko i ben bwɑ̃ɑrokunu bɔɔkuwɑ i dɔ̃ɔ mɛni kpɑ bu ku mɑɑ nin yĩsinu yɑɑyɑ yɑm mi kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","I ku bwese tuku nin komɑnu sɑɑri ì n Gusunɔ bɛsɛn Yinni sɑ̃ɑmɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","Yɑm mi u koo ɡɔsi u win wɑ̃ɑ yeru ko, miyɑ bɛɛ kpuro i ko i dɑ i nùn sɑ̃ kpɑ u bɛɛ win tii sɔ̃ɔsi mi. ");
INSERT INTO bba_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","Miyɑ i ko i n dɑ kɑ bɛɛn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu de kɑ siɑrɑbun yɑ̃kunu kɑ bɛɛn ye i mɔ kpuron wɔkuru bɑɑteren wɔllɔn tiɑ tiɑ kɑ bɛɛn ɡbeɑn dĩɑ ɡbiikinu kɑ kɛ̃nu kɑ mɑɑ kɛ̃ɛ ni i kuɑ i kɑ bɛɛn nɔɔ mwɛɛnu yibiɑ kɑ sere mɑɑ bɛɛn yɑɑ sɑbenun bii ɡbiikinu. ");
INSERT INTO bba_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","Gusunɔ bɛɛn Yinnin sɑ̃ɑ yeru miyɑ i ko i yɑ̃ku diirɑnun sukum di sɑnnu bɛɛ kɑ bɛɛn yɛnuɡibu kpɑ i n nuku dobu yibɑ yèn sɔ̃ u bɛɛ domɑru kuɑ ye i kuɑ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","Sɑɑ ye, i ǹ ko i mɑɑ Yinni Gusunɔ sɑ̃ nɡe mɛ sɑ mɔ̀ mini ɡisɔ mi bɑɑwure u mɔ̀ ye u kĩ. ");
INSERT INTO bba_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","Geemɑ, i ǹ ɡinɑ turɑ tem mɛ sɔɔ, mɛ Gusunɔ bɛsɛn Yinni u koo bɛɛ wɛ̃ kpɑ i n kɑ wɑ̃ɑru dimɔ bɔri yɛndu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","Adɑmɑ i ko i Yuudɛni tɔburɑ kpɑ i sinɑ tem mɛ sɔɔ mɛ u bɛɛ wɛ̃ɛmɔ mi. U koo bɛɛ wɛ̃rɑbu wɛ̃ sɑnɑm mɛ u koo bɛɛ wɔrɑ bɛɛn yibɛrɛbɑ kpuron nɔmɑn di be bɑ bɛɛ sikerenɛ kpɑ i sinɑ mi kɑ bɔri yɛndu. ");
INSERT INTO bba_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","Miyɑ Gusunɔ bɛsɛn Yinni u koo win wɑ̃ɑ yeru ɡɔsi mi u koo bɛɛ win tii sɔ̃ɔsi. Miyɑ i ko i n dɑ kɑ bɛɛn yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu de kɑ siɑrɑbun yɑ̃kunu kɑ bɛɛn ye i mɔ kpuron wɔkuru bɑɑteren wɔllɔn tiɑ tiɑ kɑ bɛɛn ɡbeɑn dĩɑ ɡbiikinu kɑ kɛ̃nu kɑ sere mɑɑ kɛ̃ɛ ni i kuɑ i kɑ bɛɛn nɔɔ mwɛɛnu yibiɑ nɡe mɛ nɑ rɑɑ bɛɛ sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","Gusunɔ bɛsɛn Yinnin sɑ̃ɑ yeru miyɑ i ko i nuku dobu ko bɛɛ kɑ bɛɛn bii tɔn durɔbu kɑ tɔn kurɔbu kɑ bɛɛn sɔm kowo tɔn durɔbu kɑ tɔn kurɔbu kɑ Lefi be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ yèn sɔ̃ bɑ ǹ ben tiin tem mɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","I n tii sɛ kpɑ i ku rɑ yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu ko yɑ̃ku turɑnu kpuron mi, ni i ko i wɑ. ");
INSERT INTO bba_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","Adɑmɑ i ko i nu kowɑ yɑm mi Yinni Gusunɔ u koo ɡɔsi bɛɛn bwese kɛri tiɑn temɔ kpɑ i ko mi kpuro ye nɑ bɛɛ yiiremɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","Arumɑni ye Gusunɔ bɛsɛn Yinni u koo bɛɛ wɛ̃ sɔɔ, mi i wɑ̃ɑ, i ko i kpĩ i yɑɑ ɡo i tem sɑɑ ye i kĩ. Be bɑ dɛɛre kɑ be bɑ kun dɛɛre, be kpuro bɑ koo kpĩ bu ye tem nɡe mɛ bɑ rɑ nɛmu kɑ ɡinɑ tem. ");
INSERT INTO bba_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","Yen yɛm tɔnɑwɑ i ǹ dimɔ. I ko i mu yɑriwɑ temɔ nɡe nim. ");
INSERT INTO bba_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","I ku rɑ wɔkuru bɑɑteren wɔllɔn tiɑ tiɑ di bɛɛn yɛnuɔ, ye i wunɑ ɑlikɑmɑ sɔɔ kɑ dɑ̃ɑ binu sɔɔ ni bɑ rɑ kɑ tɑm ko kɑ ni bɑ rɑ kɑ ɡum ko. I ku mɑɑ bɛɛn nɛɛ kɑ bɛɛn yɑ̃ɑnu kɑ bɛɛn bonun bii ɡbiikinu di bɛɛn yɛnusɔ kɑ kɛ̃nu kɑ kɛ̃ɛ ni i kuɑ i kɑ bɛɛn nɔɔ mwɛɛnu yibiɑ kɑ sere mɑɑ bɛɛn ɡbeɑn dĩɑ ɡbiikinu. ");
INSERT INTO bba_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","Adɑmɑ i ko i ye diwɑ sɑ̃ɑ yerɔ te Gusunɔ bɛsɛn Yinni u ɡɔsɑ bɛɛ kɑ bɛɛn bii tɔn durɔbu kɑ tɔn kurɔbu kɑ bɛɛn sɔm kowo tɔn durɔbu kɑ tɔn kurɔbu kɑ Lefi be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ. Miyɑ i ko i nuku dobu ko ɑrumɑni ye i ko i n mɔn sɔ̃. ");
INSERT INTO bba_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","I n tii sɛ sɑɑ kpuro ye i ko i n wɑ̃ɑ bɛɛn tem mɛ sɔɔ kpɑ i ku rɑ Lefibɑ biru kisi. ");
INSERT INTO bba_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","Sɑnɑm mɛ Gusunɔ bɛsɛn Yinni u koo bɛɛn tem yɑsiɑsiɑ nɡe mɛ u bɛɛ nɔɔ mwɛɛru kuɑ, sɑɑ ye, yɑɑ yɑ̀ n bɛɛ binɛ mɔ̀, i ko i kpĩ i ye tem nɡe mɛ i kĩ. ");
INSERT INTO bba_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","Sɑ̃ɑ yee te Gusunɔ bɛsɛn Yinni u ɡɔsɑ tɑ̀ n kɑ bɛɛ tomɑ, i ko i kpĩ i yɑɑ sɑbenu wunɑ bɛɛn nɑɑ ɡɔ̃ɔ kɑ bɛɛn yɑ̃ɑ ɡɔ̃ɔ kɑ bɛɛn boo ɡɔ̃ɔ sɔɔn di nɡe mɛ nɑ bɛɛ yiire, kpɑ i ye ɡo i tem bɛɛn yɛnusɔ nɡe mɛ i kĩ. ");
INSERT INTO bba_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","Wi u dɛɛre kɑ wi u kun dɛɛre, bɛɛ kpurowɑ i ko i ye tem nɡe mɛ bɑ rɑ nɛmu kɑ ɡinɑ tem. ");
INSERT INTO bba_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","Adɑmɑ i tii nɛnuɔ kpɑ i ku rɑ yɑɑ yen yɛm di domi yɛm mɛyɑ mu sɑ̃ɑ yen wɑ̃ɑru. N ǹ mɑɑ weenɛ i yɑɑ ye mɛnnɑ i di kɑ yen wɑ̃ɑru sɑnnu. ");
INSERT INTO bba_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","I ko i mu yɑriwɑ temɔ nɡe nim. ");
INSERT INTO bba_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","Ì n kuɑ mɛ, i ko i bɔri yɛndu wɑ bɛɛ kɑ bɛɛn bibun bweseru domi i kuɑ ye yɑ koo Yinni Gusunɔ wɛ̃re. ");
INSERT INTO bba_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","Adɑmɑ ye i Yinni Gusunɔ yiiyɑ kɑ kɛ̃ɛ ni i kuɑ i kɑ bɛɛn nɔɔ mwɛɛnu yibiɑ, i ko kɑ ye kpuro dɑwɑ win sɑ̃ɑ yerɔ te u ɡɔsɑ. ");
INSERT INTO bba_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","Ì n yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu mɔ̀, yɑɑ kɑ yen yɛm sɑnnɑ i ko i mɛnnɑ i yi Gusunɔ bɛsɛn Yinnin yɑ̃ku yeru wɔllɔ. Ì n mɑɑ siɑrɑbun yɑ̃kunu mɔ̀, i ko i yen yɛm yɑriwɑ yɑ̃ku yeru wɔllɔ kpɑ i yen yɑɑ tem. ");
INSERT INTO bba_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","I sɔ̃ɔsi ni kpuro swɑɑ dɑkio, i nu mɛm nɔɔwɑ ni nɑ bɛɛ wɛ̃ mi, kpɑ i wɑ i n bɔri yɛndu mɔ sere kɑ bɑɑdommɑɔ bɛɛ kɑ bɛɛn bibun bweseru, kpɑ i n mɔ̀ ye yɑ wɑ̃ yɑ Gusunɔ bɛsɛn Yinni doremɔ. ");
INSERT INTO bba_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","Gusunɔ bɛsɛn Yinni u koo bwese ni kpeerɑsiɑ ni i ko i ɡirɑ mi. Sɑnɑm mɛ i nu ɡirɑ i sinɑ nin temɔ, ");
INSERT INTO bba_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","i n tii sɛ kpɑ i ku rɑ de nu bɛɛ yinɑ mwɑ i nin kookoosu sɑɑri. I ku rɑ kɑsu i ɡiɑ nɡe mɛ nu rɑ kɑ nin bũnu sɑ̃, kpɑ i ɡere i nɛɛ, i ko i kowɑ nɡe mɛ. ");
INSERT INTO bba_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","I ku rɑ bu sɑɑri ì n Gusunɔ bɛsɛn Yinni sɑ̃ɑmɔ, domi bɑ̀ n sɑ̃ɑru mɔ̀, ɡɑ̃ɑ disiɡinɑ bɑ rɑ n mɔ̀ ni Gusunɔ u tusɑ. Bɑ rɑ mɑm ben bũnu yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡinu kuewɑ kɑ ben bii tɔn durɔbu kɑ tɔn kurɔbu. ");
INSERT INTO bba_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","I ko i woodɑ be kpuro mɛm nɔɔwɑwɑ be nɑ bɛɛ wɛ̃ mi. I ku rɑ ɡɑ̃ɑnu ɡɑnu sosi, i ku rɑ mɑɑ ɡɑ̃ɑnu ɡɑnu kɑwɑ be sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","Bɛɛn suunu sɔɔ, Gusunɔn sɔmɔ ɡoo ǹ kun mɛ yɑm wɑo ɡoo ù n bɛɛ mɑɑmɑɑkin ɡɑri sɔ̃ɔwɑ, ");
INSERT INTO bba_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","mɑ ye yɛ̃ro u bɛɛ sɔ̃ɔwɑ mi, yɑ koorɑ, mɑ u bɛɛ sɔ̃ɔwɑ u nɛɛ, i dɑ i bũnu sɑ̃ ni i ǹ dɑɑ yɛ̃, ");
INSERT INTO bba_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","i ku rɑ win ɡɑri nɔ. Domi Gusunɔ bɛsɛn Yinniwɑ u bɛɛn lɑɑkɑri mɛɛrimɔ u kɑ wɑ ì n nùn kĩn nɑ kɑ bɛɛn ɡɔ̃ru kpuro kɑ bɛɛn bwɛ̃rɑ kpuro. ");
INSERT INTO bba_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","Gusunɔ bɛsɛn Yinni turowɑ i ko i kɑsu kpɑ i nùn nɑsiɑ. I win woodɑbɑ nɔni dokeo, i nùn mɛm nɔɔwɑ, kpɑ i nùn sɑ̃ kpɑ i n kɑ nùn mɑninɛ. ");
INSERT INTO bba_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","I ko sɔmɔ wi, ǹ kun mɛ yɑm wɑo wi ɡowɑ wi u bɛɛ bɔriɑmɔ i kɑ Gusunɔ bɛsɛn Yinni deri wi u sun yɑrɑmɑ Eɡibitin di mi sɑ yoru di. I ko yɛ̃ro ɡowɑ yèn sɔ̃ u kĩ u bɛɛ ɡɛrɑsiɑ Gusunɔ bɛsɛn Yinnin swɑɑn di, ye u sun sɔ̃ɔwɑ su swĩi. Nɡe mɛyɑ i ko i kɑ kɔ̃sɑ kpeerɑsiɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","8","Bwese tukunu nu ko n bɛɛ sikerenɛ, ɡɑnu nu n wɑ̃ɑ turuku kpɑ ɡɑnu nu n wɑ̃ɑ n tomɑ hɑnduniɑn ɡoonu nnɛ kpuro sɔɔ, nu n bũnu sɑ̃ɑmɔ ni bɛɛ kɑ bɛɛn bɑɑbɑbɑ i ǹ dɑɑ yɛ̃. Sɔrɔkudo bɛɛn mɔɔ ǹ kun mɛ bɛɛn wɔnɔ ǹ kun mɛ bɛɛn bii tɔn durɔ ǹ kun mɛ tɔn kurɔ ǹ kun mɛ bɛɛn kurɔ ǹ kun mɛ bɛɛn bɔrɔ kĩnɑsi ɡoo u koo bɛɛ kɔkiri ɑsiri sɔɔ u nɛɛ, i dɑ i bũu ni sɑ̃. ");
INSERT INTO bba_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","I ku rɑ yɛ̃ro swɑɑ dɑki i win ɡɑri ɡem mwɑ. I ku rɑ mɑɑ win wɔnwɔndu ko i sere nùn biru wukiri. ");
INSERT INTO bba_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","Adɑmɑ i ko i nùn ɡowɑ. Wunɛ wi u kɔkurɑ, wunɑ kɑɑ ɡbi ɑ nùn kpenu kɑsukum tore ɑ kɑ ɡo, tɔn be bɑ tie bu sere nun swĩi. ");
INSERT INTO bba_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","I ko i nùn kpenu kɑsuku i ɡowɑ yèn sɔ̃ u kɑsu u bɛɛ ɡɛrɑsiɑ Gusunɔ bɛsɛn Yinnin swɑɑn di wi u sun yɑrɑmɑ Eɡibitin di mi sɑ yoru di. ");
INSERT INTO bba_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","Mɛyɑ n ko n sɑ̃ɑ kpɑ bɛɛ Isirelibɑ kpuro i nɔ, kpɑ i bɛrum soorɑ i ku mɑɑ kɑ kɔ̃sɑ yen bweseru ko bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","14","Sɔrɔkudo wuu si Gusunɔ u bɛɛ wɛ̃n teu sɔɔ, tɔn kɔ̃sobu ɡɑbu bɑ koo wuuɡibu kɔkiri bu nɛɛ, bu dɑ bu bũnu sɑ̃ ni, ni i ǹ dɑɑ yɛ̃. Ì n nuɑ mɛ, ");
INSERT INTO bba_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","i ko i ɡɑri yin kɑso kowɑ i yi wɛ̃ɛri kpɑ i yi bikikiɑ kɑ lɑɑkɑri i wɑ bɑ̀ n kɔ̃sɑ ye kuɑn nɑ kɑ ɡem. ");
INSERT INTO bba_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","Bɑ̀ n ye kuɑn nɑ, sɑɑ yerɑ i ko wuu ɡen tɔmbu kpuro ɡo kɑ ben yɑɑ sɑbenu kpɑ i wuu ɡen tii kpeerɑsiɑ kɑ ye yɑ wɑ̃ɑ ɡe sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","I ko i wuu ɡen ɑrumɑni kpuro mɛnnɑwɑ ɡen yɑɑrɑɔ mi bɑ rɑ mɛnnɛ, kpɑ i wuu ɡe kɑ ɑrumɑni ye kpuro dɔ̃ɔ mɛni muku muku. Yɑ ko n sɑ̃ɑwɑ nɡe yɑ̃ku dɔ̃ɔ mwɑɑrɑruɡiru te i Gusunɔ bɛɛn Yinni kuɑ. Wuu ɡe, ɡɑ ko n sɑ̃ɑwɑ bɑnsu sere kɑ bɑɑdommɑɔ. Bɑ ǹ mɑɑ su seeyɑmɔ. ");
INSERT INTO bba_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","19","I ku rɑ mɑɑ tii ɡɑ̃ɑnu yiiyɑ ɑrumɑni ye sɔɔ. Yɑ ko n sɑ̃ɑwɑ Gusunɔ bɛsɛn Yinniɡiɑ, kpɑ win mɔru yu wɑ yu sure. Ì n win nɔɔ nuɑ mɑ i win woodɑbɑ kpuro mɛm nɔɔwɑ be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, kpɑ i n mɔ̀ ye yɑ wɑ̃ win nɔni sɔɔ, u koo bɛɛ wɔnwɔndu kɑ durom kuɑ, kpɑ i dɑbiɑ nɡe mɛ u bɛsɛn bɑɑbɑbɑ yen nɔɔ mwɛɛru kuɑ kɑ bɔ̃ri. ");
INSERT INTO bba_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","Bɛɛ Isirelibɑ, i sɑ̃ɑwɑ Gusunɔ bɛsɛn Yinnin tɔmbu. Goo ù n ɡu, i ku rɑ bɛɛn wɑsin ɡɑm murɑ. I ku rɑ mɑɑ bɛɛn seri kɔni wuswɑɑ ɡiɑ. ");
INSERT INTO bba_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","Domi i sɑ̃ɑwɑ bwese te Gusunɔ bɛsɛn Yinni u ɡɔsɑ nɛnɛm. Hɑnduniɑn bwesenu kpuro sɔɔ, bɛɛyɑ u ɡɔsɑ i n kɑ sɑ̃ɑ win tɔmbu. ");
INSERT INTO bba_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","I ku rɑ ɡɑ̃ɑ disiɡinu di. ");
INSERT INTO bba_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","Yɛɛ yi i ko i di, yiyɑ nɑɑ kɑ yɑ̃ɑru kɑ boo ");
INSERT INTO bba_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","kɑ yɑɑ kpiku kɑ nɛmu kɑ kpɑsɑ kɑ kpee boo kɑ ɡini bukɑru kɑ kpee bɛrɑ kɑ ɡinɑ. ");
INSERT INTO bba_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","Yɛɛ yi yi nɑɑ kɑburosu yiru mɔ mɑ yi rɑ tukɑ ko, yi kpurowɑ i ko i di. ");
INSERT INTO bba_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","Adɑmɑ i ku rɑ yɑɑ di ye yɑ rɑ tukɑ ko tɔnɑ ǹ kun mɛ ye yɑ nɑɑ kɑburosu yiru mɔ tɔnɑ. Nɡe mɛyɑ i ku rɑ yooyoo di kɑ sɑɑtɑburu kɑ mɑɑ dɑmɑɑ . Yɛɛ yi, yi rɑ tukɑ ko ɑdɑmɑ yi ǹ nɑɑ kɑburosu yiru yiru mɔ. I ko i yi ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","I ku rɑ kurusɔ di ɡe, ɡe ɡɑ nɑɑ kɑburosu yiru yiru mɔ, ɑdɑmɑ ɡɑ ku rɑ tukɑ ko. I ko i ɡu ɡɑrisiwɑ disiɡuu. I ku rɑ yɛɛ yin ɡɑɑ di, i ku rɑ mɑɑ yin ɡɑɑn ɡoru bɑbɑ. ");
INSERT INTO bba_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","Yɛɛ yi yi wɑ̃ɑ nim sɔɔ i ko i di yiyɑ, yɛɛ yi yi kɛ̃ɛritii kɑ kokosu mɔ kpuro. ");
INSERT INTO bba_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","Adɑmɑ yi yi ǹ kɛ̃ɛritii kɑ kokosu mɔ, i ku rɑ yi di. I ko i yi ɡɑrisiwɑ disiɡii. ");
INSERT INTO bba_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","Gunɔ ɡe ɡɑ dɛɛre kpurowɑ i ko i di. ");
INSERT INTO bba_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","Adɑmɑ ɡunɔ si i ǹ dimɔ siyɑ, ɡunɔ bɑkeru kɑ yɑbereku kɑ ɡunɔ bɑke te tɑ rɑ n wɑ̃ɑ nim wɔ̃kuɔ ");
INSERT INTO bba_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","kɑ bɔsu sooku kɑ siro kɑ ye yɑ kɑ ɡu weenɛ kpuro ");
INSERT INTO bba_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","kɑ ɡbɑnɑmɡbɑɑru kɑ ye yɑ kɑ tu weenɛ kpuro ");
INSERT INTO bba_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","kɑ tɑɑtɑɑru kɑ booro kɑ kpɑruko yɑ̃ɑtɑm bɑrebu kɑ kɑsɑ kɑ ye yɑ kɑ ye weenɛ kpuro ");
INSERT INTO bba_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","kɑ booron bweseru bɑɑtere ");
INSERT INTO bba_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","kɑ ɡbɑmɡbɑyɑku kɑ tionko kɑ swɑ̃ɑ wĩɑku ");
INSERT INTO bba_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","kɑ nim kpɑkpɑyɛ kɑ bukɑɑbo kɑ ye yɑ kɑ ye weenɛ kpuro kɑ kpurɑbu kɑ sere kɔ̃ɔ. ");
INSERT INTO bba_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","I ko i kɔkɔmii ni nu rɑ yɔ̃ yɔ̃ ɡɑrisiwɑ disiɡinu. I ku rɑ nu di. ");
INSERT INTO bba_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","Adɑmɑ ni nu dɛɛre kpurowɑ i ko i kpĩ i di. ");
INSERT INTO bba_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","I ku rɑ yɑɑ ɡɑɑ di ye yɑ kɑ tii ɡu. I ye sɔɔ wi u wɑ̃ɑ bɛɛn yɛnuɔ kɛ̃ɛyɔ u di ǹ kun mɛ i ye sɔbu ɡɑbu dɔre. Domi i sɑ̃ɑwɑ Gusunɔ bɛsɛn Yinnin tɔmbu mɑm mɑm. I ku rɑ mɑɑ boo buu yike kɑ ɡen mɛron bom. ");
INSERT INTO bba_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","Wɔ̃ɔ bɑɑɡere, bɛɛn ɡbeɑn dĩɑnu sɔɔ, wɔkuru bɑɑteren wɔllɔ tiɑ tiɑwɑ i ko i n dɑ wunɛ, ");
INSERT INTO bba_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","kpɑ i n dɑ kɑ de Gusunɔ bɛsɛn Yinnin sɑ̃ɑ yerɔ te u ɡɔsɑ. I ko i tiɑ tiɑ ye wunɑ bɛɛn ɑlikɑmɑ sɔɔ kɑ dɑ̃ɑ bii ni bɑ rɑ kɑ tɑm ko sɔɔ kɑ ni bɑ rɑ kɑ ɡum ko sɔɔ, kpɑ i ye di mi, kɑ bɛɛn nɛɛ kɑ bɛɛn yɑ̃ɑnu kɑ bɛɛn bonun bii ɡbiikinu. Ye kpurowɑ i ko i n dɑ di mi, kpɑ i kɑ ɡiɑ nɡe mɛ i ko i n dɑ Gusunɔ bɛɛn Yinni nɑsie bɑɑdommɑ. ");
INSERT INTO bba_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","Sɑnɑm mɛ Gusunɔ bɛsɛn Yinni u koo bɛɛ domɑru kuɑ mɑ bɛɛn dĩɑnu nu koorɑ, sɔrɔkudo i ǹ kpĩɑ i kɑ tiɑ tiɑ ye nɑ ye i wunɑ wɔkuru bɑɑteren wɔllɔ yèn sɔ̃ bɛɛn ɡbɑburɑ tomɑ kɑ win sɑ̃ɑ yee te u ɡɔsɑ mi. ");
INSERT INTO bba_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","Sɑɑ ye sɔɔ, i ko i tiɑ tiɑ ye dɔrɑwɑ yè i wunɑ wɔkuru bɑɑteren wɔllɔ mi, kpɑ i yen ɡobi nɛnumɑ i kɑ nɑ Gusunɔ bɛsɛn Yinnin sɑ̃ɑ yerɔ te u ɡɔsɑ. ");
INSERT INTO bba_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","Miyɑ i ko i kɑ ɡobi yi nɛɛ dwe kɑ yɑ̃ɑnu ǹ kun mɛ bonu kɑ tɑm mɛ mu du kɑ mɛ mu bɔ ye yɑ koo kɑ bɛɛ nɑɑwɑ kpuro ɡesi kpɑ i ye di mi, i n kɑ Gusunɔ bɛɛn Yinni sɑ̃ɑmɔ, kpɑ i n nuku dobu mɔ̀ bɛɛ kɑ bɛɛn yɛnuɡibu. ");
INSERT INTO bba_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","Sɑɑ ye sɔɔ, i ku rɑ Lefibɑ duɑri be bɑ wɑ̃ɑ bɛɛn wusɔ, domi bɑ ǹ tem mɔ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","I ko i n dɑ wɔ̃ɔ itɑse kɑ wɔ̃ɔ itɑsen wɔkuru bɑɑteren wɔllɔn tiɑ tiɑ yiwɑ bɛɛn wusɔ, ");
INSERT INTO bba_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","kpɑ yɑ n sɑ̃ɑ Lefibɑɡiɑ be, be bɑ ǹ tem mɔ bɛɛn suunu sɔɔ kɑ sɔbuɡiɑ kɑ ɡobekubɑɡiɑ kɑ ɡɔminibuɡiɑ be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ, kpɑ bu di bu debu kpɑ Gusunɔ bɛsɛn Yinni u bɛɛ domɑru kuɑ bɛɛn sɔmɑ kpuro sɔɔ ye i mɔ̀. ");
INSERT INTO bba_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","I ko i n dɑ be bɑ bɛɛn dibu nɛni kɑrewɑ wɔ̃ɔ nɔɔbɑ yiru kɑ wɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","Wee nɡe mɛ i ko i kɑ woodɑ ye sɔmburu koosinɑ. Sɑnɑm mɛ bɑ dibu kɑrɑbun ɡɑri kpɑrɑ Yinni Gusunɔn sɔ̃, n weenɛwɑ be bɑ ben winsim ɡobi bɔkurɑ bu yɛ̃robu dii bi kɑrɑ, kpɑ bu ku mɑɑ bu ɡɑ̃ɑnu bikiɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","I ko i kpĩ i sɔbu bɑɑsi bu kɑ bɛɛ bɛɛn dibu kɔsiɑ, ɑdɑmɑ i ko i bɛɛn mɛro bisibu kɑrɑwɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","5","Ì n ɡesi Gusunɔ bɛsɛn Yinnin nɔɔ nuɑ, i win woodɑbɑ mɛm nɔɔwɑ mɑm mɑm be nɑ bɛɛ wɛ̃ɛmɔ ɡisɔ, u koo bɛɛ domɑru kuɑ tem mɛ u koo bɛɛ wɛ̃ sɔɔ kpɑ sɑ̃ɑro u kun wɑ̃ɑ bɛɛ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","U koo bɛɛ domɑru kuɑ nɡe mɛ u bɛɛ nɔɔ mwɛɛru kuɑ. I ko i bwese tuku dɑbinu ɡobi bɔkurɑ, ɑdɑmɑ bɛɛ, i ǹ ko i n ɡobi bɔkurɑbun bukɑtɑ mɔ. I ko i bwese tuku dɑbinu kerɑ, ɑdɑmɑ nu ǹ kpɛ̃ nu bɛɛ kerɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","Kɑ mɛ, bɛɛn ɡoo ù n sɑ̃ɑ sɑ̃ɑro tem mɛ Gusunɔ bɛɛn Yinni u koo bɛɛ wɛ̃n wuu ɡɑɡu sɔɔ, i ku rɑ ɡɔbiɑ i yinɑ i nùn ɡobi bɔkurɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","I ko i nùn bɔkurɑwɑ kɑ nuku tiɑ yìn bukɑtɑ u mɔ. ");
INSERT INTO bba_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","I lɑɑkɑri ko, kpɑ i ku rɑ nuku kɔ̃su bwisikunu ko i nɛɛ, wɔ̃ɔ nɔɔbɑ yiruse wee yɑ turuku koomɑ yè sɔɔ bɑ rɑ dibuɡibu kɑre, kpɑ i sɛ̃siɑ i yinɑ i nùn bɔkurɑ. Ì n kuɑ mɛ, u koo Yinni Gusunɔ nɔɔɡiru sue bɛɛn sɔ̃, kpɑ i yen tɑɑrɛn ɑre sɔbe. ");
INSERT INTO bba_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","I nùn bɔkuro kɑ nuku tiɑ. Ì n kuɑ mɛ, Gusunɔ bɛsɛn Yinni u koo bɛɛn sɔmɑ kpuro domɑru kuɑ ye i mɔ̀. ");
INSERT INTO bba_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","Sɑ̃ɑrobu bɑ ko n wɑ̃ɑwɑ tem mɛ sɔɔ sɑɑ kpuro. Yen sɔ̃nɑ nɑ bɛɛ woodɑ yeni wɛ̃ nɑ nɛɛ, i de i n sɑ̃ɑ nuku tiɑɡibu bɛɛn mɛro bisi be bɑ sɑ̃ɑ sɑ̃ɑrobu kɑ wɔnwɔndobu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","Bɛɛn Heberusi ɡoo, tɔn durɔ ǹ kun mɛ tɔn kurɔ ù n tii bɛɛ dɔre, u koo bɛɛ sɔmburu kuɑwɑ wɔ̃ɔ nɔɔbɑ tiɑ. Wɔ̃ɔ nɔɔbɑ yiruse i ko i nùn kɑrɑwɑ u doonɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","Ì n nùn kɑrɑmɔ, i ku de u doonɑ nɔm dirɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","I ko i nùn kɛ̃ru wɛ̃wɑ bɛɛn yɑɑ sɑbenu sɔɔ kɑ bɛɛn ɑlikɑmɑ sɔɔ kɑ tɑm sɔɔ, kpuro sɔɔ ɡesi ye Gusunɔ bɛsɛn Yinni u koo bɛɛ domɑru kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","I yɑɑyo mɑ i rɑɑ yoru di Eɡibitiɔ, mɑ Gusunɔ bɛsɛn Yinni u bɛɛ yɑkiɑ. Yen sɔ̃nɑ nɑ bɛɛ woodɑ yeni wɛ̃ɛmɔ ɡisɔ. ");
INSERT INTO bba_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","Bɛɛn yoo ɡoo ù n nɛɛ, u ǹ yɑriɔ bɛɛn min di yèn sɔ̃ u bɛɛ kɑ bɛɛn yɛnuɡibu kĩ, u mɑɑ dobu nɔɔmɔ bɛɛn mi, ");
INSERT INTO bba_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","sɑɑ ye sɔɔ, u koo ɡɑmbo ɡbɑlliwɑ kpɑ i sɔkurɑ suɑ i kɑ win swɑɑ yɑbɑ kpɑ u ko bɛɛn yoo sere kɑ bɑɑdommɑɔ. Nɡe mɛyɑ i ko i mɑɑ yoo tɔn kurɔn tii kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","I ku rɑ de n bɛɛ sɛ̃sie i kɑ yoo kɑrɑ u doonɑ bɛɛn min di yèn sɔ̃ sɔmbu te u bɛɛ kuɑ wɔ̃ɔ nɔɔbɑ tiɑ sɔɔ tɑ bɛɛ sɔm kowo wi i kɔsiɑmɔn ɑren nɔn yiru wɛ̃, kpɑ Gusunɔ bɛɛn Yinni u bɛɛ domɑru kuɑ ye i mɔ̀ kpuro sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","I ko i bɛɛn nɛɛ kɑ bɛɛn yɑ̃ɑnu kɑ bɛɛn bonun bii ɡbiikii dwɑnu Gusunɔ bɛsɛn Yinni yiiyewɑ. I ku rɑ kɑ bɛɛn nɛɛn bii ɡbiikinu sɔmburu ko, i ku rɑ mɑɑ bɛɛn yɑ̃ɑnun bii ɡbiikinun sɑnsu bɔɔri. ");
INSERT INTO bba_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","I ko i n dɑ nin yɑɑ temwɑ bɛɛ kɑ bɛɛn yɛnuɡibu wɔ̃ɔ bɑɑɡere Gusunɔ bɛsɛn Yinnin sɑ̃ɑ yerɔ te u ɡɔsɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","Yɑɑ sɑbe nin ɡɑru tɑ̀ n nɑɑsu bɑrɔ ǹ kun mɛ tɑ̀ n wɔ̃ko sɑ̃ɑ ǹ kun mɛ tɑ̀ n ɑlebu ɡɑɑ mɔ, i ku rɑ kɑ tu Gusunɔ bɛɛn Yinni yɑ̃kuru kuɑ. ");
INSERT INTO bba_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","I ko i ten yɑɑ temwɑ yɛnuɔ. Wi u dɛɛre kɑ wi u ǹ dɛɛre, be kpurowɑ bɑ koo ye tem nɡe mɛ bɑ rɑ nɛmu kɑ ɡinɑ tem. ");
INSERT INTO bba_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","Adɑmɑ i ku rɑ yen yɛm di. I ko i mu yɑriwɑ temɔ nɡe nim. ");
INSERT INTO bba_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","Suru wi bɑ mɔ̀ Abibu sɔɔ, i ku rɑ duɑri i Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑru di Gusunɔ bɛsɛn Yinnin sɔ̃. Domi suru wi sɔɔrɑ u bɛɛ yɑrɑ Eɡibitin di wɔ̃kuru. ");
INSERT INTO bba_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","Yɛɛ yi i ko i wunɑ bɛɛn yɑɑ sɑbenu sɔɔ i kɑ Gusunɔ bɛsɛn Yinni yɑ̃kuru kuɑ Gɔɔ sɑrɑribun tɔ̃ɔ bɑkɑ te sɔɔ, yiyɑ, yɑ̃ɑnu kɑ bonu kɑ kɛtɛbɑ. I ko i tɔ̃ɔ bɑkɑ te diwɑ Yinni Gusunɔn sɑ̃ɑ yerɔ te u ɡɔsɑ. ");
INSERT INTO bba_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","Tɔ̃ɔ bɑkɑ ten sɔ̃ɔ nɔɔbɑ yiru ye sɔɔ, i ǹ pɛ̃ɛ dimɔ ye bɑ seeyɑtiɑ doke. Ye bɑ ǹ seeyɑtiɑ dokewɑ i ko i di yèn sɔ̃ kɑ dukɑ i yɑrɑ Eɡibitin di. Ì n nɔni swɑ̃ɑrun pɛ̃ɛ ye dimɔ, nɡe mɛyɑ bɛɛn wɑ̃ɑru kpuro sɔɔ i ko i kɑ tɔ̃ɔ bɑkɑ te yɑɑyɑ tè sɔɔ i yɑrɑ Eɡibitin di. ");
INSERT INTO bba_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","Sɔ̃ɔ nɔɔbɑ yiru ye sɔɔ, i ǹ ko i de pɛ̃ɛ seeyɑtiɑ yɑ n wɑ̃ɑ bɛɛn tem mɛ kpuro sɔɔ. I ǹ mɑɑ yɑɑ ye i kɑ yɑ̃kuru kuɑ tɔ̃ɔ ɡbiikirun yokɑ yiimɔ sere sisiru bururu. ");
INSERT INTO bba_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","I ku rɑ tɔ̃ɔ bɑkɑ te di bɛɛn wusu kpuro sɔɔ mi Gusunɔ bɛsɛn Yinni u bɛɛ swĩi, ");
INSERT INTO bba_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","mɑ n kun mɔ wuu ɡe u ɡɔsɑ sɔɔ, mi win sɑ̃ɑ yeru tɑ wɑ̃ɑ. I ko i yɑ̃kuru kowɑ yokɑ sɑnɑm mɛ sɔ̃ɔ u duɑ nɡe sɑɑ ye i yɑrimɑ Eɡibitin din sɑkɑ. ");
INSERT INTO bba_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","I ko i yɑɑ sɑbe te wɔ̃wɑ kpɑ i tu tem yɑm mi Gusunɔ bɛsɛn Yinni u ɡɔsɑ mi. Ì n tɔ̃ɔ bɑkɑ te di i kpɑ, yen sisiru bururu, kpɑ i ɡɔsirɑ i wurɑ bɛɛn wusɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","Sɔ̃ɔ nɔɔbɑ tiɑ sɔɔ, i ko i pɛ̃ɛ diwɑ ye bɑ ǹ seeyɑtiɑ doke. Sɔ̃ɔ nɔɔbɑ yiruse, kpɑ i mɛnnɑ Gusunɔ bɛsɛn Yinnin sɔ̃. I ǹ ko i sɔmburu ɡɑru ko tɔ̃ɔ te sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","Sɑɑ yèn di i dĩɑnu ɡɛ̃ɛbu toruɑ, i ko i ɑlusumɑ ɡɑriwɑ yu kɑ ko nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","Yen biru, kpɑ i Gusunɔ bɛsɛn Yinni ɡɛ̃ɛbun tɔ̃ɔ bɑkɑru diiyɑ kpɑ i mɑɑ kɑ nùn kɛ̃nu nɑɑwɑ ye u domɑru kuɑ u bɛɛ wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","I ko i nuku dobu ko win wuswɑɑɔ win sɑ̃ɑ yee te u ɡɔsɑ sɔɔ bɛɛ kɑ bɛɛn bii tɔn durɔbu kɑ tɔn kurɔbu kɑ bɛɛn sɔm kowo tɔn durɔbu kɑ tɔn kurɔbu kɑ Lefibɑ kɑ sɔbu kɑ ɡobekubɑ kɑ ɡɔminibu, be kpuro ɡesi be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","I woodɑ be mɛm nɔɔwɔ kpɑ i kɑ sɔmburu ko. I yɑɑyo mɑ i rɑɑ sɑ̃ɑwɑ yobu Eɡibitiɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","Ì n bɛɛn ɡbeɑn dĩɑ bimiɡinu so i kpɑ, mɑ i bɛɛn resɛm binu ɡɑmɑ i kpɑ, i ko i Kunun tɔ̃ɔ bɑkɑru diwɑ sɔ̃ɔ nɔɔbɑ yiru. ");
INSERT INTO bba_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","I ko i nuku dobu kowɑ tɔ̃ɔ bɑkɑ te sɔɔ, bɛɛ kɑ bɛɛn bii tɔn durɔbu kɑ tɔn kurɔbu kɑ bɛɛn sɔm kowo tɔn durɔbu kɑ tɔn kurɔbu kɑ Lefibɑ kɑ sɔbu kɑ ɡobekubɑ kɑ ɡɔminibu be bɑ wɑ̃ɑ bɛɛn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","I ko i Gusunɔ bɛsɛn Yinni tɔ̃ɔ bɑkɑ te diiyɑwɑ sɔ̃ɔ nɔɔbɑ yiru sɑ̃ɑ yee te u ɡɔsɑ sɔɔ. Domi u koo bɛɛn ɡbeɑn dĩɑnu kɑ sɔmɑ ye i mɔ̀ kpuro domɑru kuɑ kpɑ i n wɑ̃ɑ nuku dobu sɔɔ mɑm mɑm. ");
INSERT INTO bba_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","Wɔ̃ɔ bɑɑɡere, nɔn itɑwɑ bɛɛn tɔn durɔbu kpuro bɑ ko n dɑ de Gusunɔ bɛsɛn Yinnin sɑ̃ɑ yerɔ te u ɡɔsɑ. Sɑɑ yerɑ, pɛ̃ɛ ye bɑ ǹ seeyɑtiɑ doken tɔ̃ɔ bɑkɑrun sɑɑ kɑ ɡɛ̃ɛbun tɔ̃ɔ bɑkɑrun sɑɑ kɑ kunun tɔ̃ɔ bɑkɑrun sɑɑ. Adɑmɑ bu ku dɑ mi kɑ nɔm dirɑ. ");
INSERT INTO bba_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","Ben bɑɑwure u koo kɑ kɛ̃ru dɑwɑ mɛ̀n nɔru u koo kpĩ ye Gusunɔ bɛsɛn Yinni u domɑru kuɑ u nùn wɛ̃ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","I ko i bɛɛn bwese kɛri sɔɔ siri kowobu kɑ wiruɡibu swĩiwɑ bɛɛn wusu kpuro sɔɔ si Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃. Kpɑ bɑ n dɑ tɔmbu siri ɡem sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","I ku rɑ siri kɑ murɑfitiru, i ku rɑ ɡoo ɡem wɛ̃ win bɛɛrɛn sɔ̃. I ku rɑ mɑɑ nɔm birɑn kɛ̃ru mwɑ domi tɑ rɑ lɑɑkɑriɡibun nɔni wɔ̃kewɑ kpɑ tu ɡemɡibun ɡere ɡɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","I ko i ɡem swĩiwɑ mɑm mɑm kpɑ i wɑ i n wɑ̃ɑ, kpɑ i tem mɛ mwɑ mɛ Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃ɛmɔ. ");
INSERT INTO bba_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","I ku rɑ bũu dɑ̃ru ɡɑru ɡirɑ yɑ̃ku yerun bɔkuɔ te i ko i Gusunɔ bɛsɛn Yinni bɑniɑ. ");
INSERT INTO bba_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","I ku rɑ mɑɑ kperu ɡɑru ɡirɑ tɑ n sɑ̃ɑ bũu, domi Gusunɔ bɛsɛn Yinni u ye kpuro tusɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","I ku rɑ Gusunɔ bɛsɛn Yinni yɑ̃kuru kuɑ kɑ kɛtɛ ǹ kun mɛ kɑ yɑ̃ɑru ǹ kun mɛ kɑ boo, yen ɡɑɑ yɑ̀ n bɑrɑru ɡɑru ǹ kun mɛ ɑlebu ɡɑɑ mɔ, domi yɑ sɑ̃ɑwɑ sese disiɡiru win mi. ");
INSERT INTO bba_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","3","Ì n dɑ dɑ i wɑ̃ɑ wuu si Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃ sɔɔ, sɔrɔkudo sɔ̃ɔ teeru wuu sin ɡɑɡu sɔɔ, tɔn durɔ ɡoo ǹ kun mɛ tɔn kurɔ ɡoo u koo Yinni Gusunɔ tɔnu kɑm kom kuɑ u dɑ u bũnu yiirɑ u sɑ̃, kɑ mɑm sɔ̃ɔ kɑ suru kɑ kperi kpuro. Yeyɑ yɑ ko n sɑ̃ɑ kɔ̃sɑ Gusunɔn nɔni sɔɔ domi n ǹ mɛ u bɛɛ yiire i ko. ");
INSERT INTO bba_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","Sɑnɑm mɛ i nuɑ bɑ nɛɛ, ɡoo u yen bweseru kuɑ, i ko i yen ɡɑri wɛ̃ɛriwɑ kɑ lɑɑkɑri. Ì n deemɑ yɛ̃ro u sese disiɡii te kuɑwɑ kɑ ɡem bɛɛ Isirelibɑn tem sɔɔ, ");
INSERT INTO bba_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","sɑɑ ye sɔɔrɑ i ko i kɑ yɛ̃ro dɑ wuun ɡbɑ̃rɑ kɔnnɔwɔ ǹ n tɔn durɔn nɑ, ǹ n mɑɑ tɔn kurɔn nɑ kpɑ i nùn kpenu kɑsuku i ɡo. ");
INSERT INTO bba_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","I ku rɑ ɡoo tɑɑrɛ wɛ̃ i ɡo mɑ n kun mɔ tɔmbu yiru ǹ kun mɛ itɑ bɑ win seedɑ di. Tɔn turon seedɑ dibu kun turɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","Seedɑɡii beyɑ bɑ koo ɡbi bu yɛ̃ro kpenu kɑsukum tore bu kɑ ɡo kpɑ tɔn be bɑ tie bu sere mɑɑ swĩi. Nɡe mɛyɑ i ko i kɑ kɔ̃sɑ ye wunɑ bɛɛn suunu sɔɔn di. ");
INSERT INTO bba_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","Goo ù n tɔnu ɡo ǹ kun mɛ ɡɑbu bɑ̀ n sɑnnɑ ǹ kun mɛ ɡoo ù n ɡoo mɛɛrɑ kuɑ, mɑ i kpɑnɑ i bu siriɑ, i seewo i kɑ bu dɑ yɑm mi Gusunɔ bɛsɛn Yinni u koo tii ɡɔsiɑ sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","I doo yɑ̃ku kowobu Lefibɑn mi kɑ siri kowobun mi kpɑ bu bɛɛ sɔ̃ nɡe mɛ i ko i siri bi koosinɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","I ko i kowɑ dee dee ye bɑ bɛɛ sɔ̃ɔwɑ sɑ̃ɑ yee ten min di tè Yinni Gusunɔ u tii ɡɔsiɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","I ko i woodɑ kɑ sɔ̃ɔsi ni bɑ bɛɛ wɛ̃ mi mɛm nɔɔwɑwɑ mɑm mɑm. I ku rɑ yen ɡɑɑ yinɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","Wi u tii suɑ mɑ u yinɑ u yɑ̃ku kowo wi u Gusunɔ bɛsɛn Yinnin sɔmburu mɔ̀ mi kɑ siri kowon ɡɑri swɑɑ dɑki, bɑ koo yɛ̃ro ɡowɑ. Nɡe mɛyɑ i ko i kɑ kɔ̃sɑ wunɑ bɛɛ Isirelibɑn suunu sɔɔn di ");
INSERT INTO bba_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","kpɑ tɔnu bɑɑwure wi u ye nuɑ u nɑndɑ kpɑ ɡoo u ku mɑɑ tii suɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","Sɑnɑm mɛ i duɑ i wɑ̃ɑ tem mɛ Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃ɛmɔ sɔɔ, mɑ i ɡeruɑ i nɛɛ, i kĩ i n sinɑ boko mɔwɑ nɡe mɛ bwese ni nu bɛɛ sikerenɛ nu mɔ, ");
INSERT INTO bba_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","wi Gusunɔ bɛsɛn Yinni u ɡɔsɑ, wiyɑ i ko i swĩi u ko sinɑ boko. U ko n sɑ̃ɑwɑ Isireli. I ku rɑ de sɔɔ wi i ǹ sɑ̃ɑ bwese teeru u ko bɛɛn sinɑ boko. ");
INSERT INTO bba_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","Sinɑ boko wi, u ǹ ko u n dumi mɔ dɑbi dɑbiru. U ǹ ko u n dɑ mɑɑ ɡɑbu ɡɔri Eɡibitiɔ bu dumi dweemɑ. Domi Yinni Gusunɔ u bɛɛ sɔ̃ɔwɑ u nɛɛ, u ǹ kĩ i mɑɑ wurɑ mi. ");
INSERT INTO bba_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","Win kurɔbu bɑ ǹ ko bɑ n dɑbi win ɡɔ̃ru ɡu ku rɑɑ kɑ ɡɛrɑ Gusunɔn min di. U ǹ koo mɑɑ tii sii ɡeesu kɑ wurɑ sweenɑ siki siki. ");
INSERT INTO bba_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","Sinɑ boko wi, ù n sinɑ ɡɔnɑ sinɑ u kpɑ, u koo de bu nùn woodɑ yeni yoruɑwɑ tireru sɔɔ ye yɑ ko n wɑ̃ɑ yɑ̃ku kowo Lefibɑn mi. ");
INSERT INTO bba_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","Tire te, tɑ ko n wɑ̃ɑwɑ win bɔkuɔ kpɑ u n dɑ tu ɡɑri tɔ̃ɔ bɑɑtere win wɑ̃ɑrun tɔ̃ru kpuro sɔɔ kpɑ u kɑ ɡiɑ nɡe mɛ u koo Gusunɔ win Yinni nɑsiɑ, u win woodɑbɑ kɑ win yiirebu mɛm nɔɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","Kpɑ u ku tii suɑ u n tɑmɑɑ u win Isirelisibu kerewɑ kpɑ u ku woodɑ yen ɡɑɑ yinɑ kpɑ wi kɑ win bibun bweserun bɑndu tu dɑkɑɑ dɑ Isirelibɑn suunu sɔɔ. ");
INSERT INTO bba_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","Yɑ̃ku kowo Lefibɑ kɑ be bɑ tie Lefin bweseru sɔɔ kpuro bɑ ǹ tem wɑsi nɡe Isireli be bɑ tie. Yɑ̃ku ni bɑ Yinni Gusunɔ kuɑ kɑ ɡɑ̃ɑ ni bɑ kɑ nùn nɑɑwɑ, yerɑ yɑ ko n sɑ̃ɑ ben dĩɑnu. ");
INSERT INTO bba_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","Bɑ ǹ tem wɑsi mu n sɑ̃ɑ ben tubi nɡe Isireli be bɑ tie. Adɑmɑ Yinni Gusunɔɡiɑ yɑ ko n sɑ̃ɑ ben tubi nɡe mɛ u bu sɔ̃ɔwɑ. ");
INSERT INTO bba_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","Yɑ̃ku yɑɑn mi bɛɛ Isirelibɑ i ko yɑ̃ku kowobu wɛ̃ ì n yɑ̃kuru kuɑ kɑ kɛtɛ ǹ kun mɛ kɑ yɑ̃ɑru ǹ kun mɛ kɑ boo, miyɑ yen nɔm fɑrɑm kɑ yen bɑɑ sɑburosu kɑ yen bɔsɔnu. ");
INSERT INTO bba_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","Kpɑ i mɑɑ bu bɛɛn dĩɑ ni i ɡbiɑ i ɡɑ̃ wɛ̃. Niyɑ, ɑlikɑmɑ kɑ dɑ̃ɑ bii ni bɑ rɑ kɑ tɑm ko kɑ ni bɑ rɑ kɑ ɡum ko kɑ sere bɛɛn yɑ̃ɑnun sɑn si i ɡbiɑ i bɔɔrɑ. ");
INSERT INTO bba_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","Domi bɛɛn bwese kɛri kpuro sɔɔ, Lefin bwese kɛrɑ Gusunɔ bɛsɛn Yinni u ɡɔsɑ bu kɑ sɔmburu ko win sɑ̃ɑ yerɔ be, kɑ ben bibun bweseru sere kɑ bɑɑdommɑɔ. ");
INSERT INTO bba_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","Lefi ɡoo ù n kĩ u yɑri Isirelin wuu ɡɑɡun di mi u wɑ̃ɑ u kɑ dɑ mi Yinni Gusunɔn sɑ̃ɑ yerɑ wɑ̃ɑ, ");
INSERT INTO bba_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","u koo kpĩ u win sɔmburu ko mi, Gusunɔ win Yinnin wuswɑɑɔ nɡe mɛ win mɛro bisibu Lefi be u deemɑ mi bɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","Bɑ koo nùn dim wɛ̃wɑ mu n kɑ beɡim nɛ bɑɑ mɛ u ye u rɑɑ mɔ dɔrɑ. ");
INSERT INTO bba_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","Ì n turɑ tem mɛ sɔɔ, mɛ Gusunɔ bɛsɛn Yinni u bɛɛ wɛ̃, i ku rɑ mɛn tɔmbun sɑ̃ɑru sɑɑri te Yinni Gusunɔ u tusɑ. ");
INSERT INTO bba_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","I ku rɑ de bɛɛ sɔɔ, ɡoo u kɑ win bii yɑ̃kuru ɡɑru ko. I ku mɑɑ de ɡoo u n sɔroru mɔ̀ bɛɛn suunu sɔɔ, ");
INSERT INTO bba_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ǹ kun mɛ u n ɡɔribu sokumɔ ǹ kun mɛ u n dobo dobobɑ mɔ̀. ");
INSERT INTO bba_vpl VALUES ("DT18_12","0