﻿USE sofia;
DROP TABLE IF EXISTS sofia.baoNT_vpl;
CREATE TABLE baoNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES baoNT_vpl WRITE;
INSERT INTO baoNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Atea, David, Abraham pãrami ca niiricʉ, Jesucristo ñicʉ̃ jʉ̃mʉa niiquĩricarãre owa tuurique nii: ");
INSERT INTO baoNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, Isaac pacʉ niiupi. Isaac, Jacob pacʉ niiupi. Jacob, Judá, to biri cʉ̃ bairã pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá, Fares, Zera jãa pacʉ niiupi. Cʉ̃ja paco Tamar niiupo. Fares, Jezrón pacʉ niiupi. Jezrón, Aram pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram, Aminadab pacʉ niiupi. Aminadab, Naasón pacʉ niiupi. Naasón, Salmón pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón, Booz pacʉ niiupi. Booz paco Rajab niiupo. Booz, Obed pacʉ niiupi. Cʉ̃ paco, Rut niiupo. Obed, Isaí pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí, Israel yepa macãrã wiogʉ ca niiricʉ David pacʉ niiupi. Wiogʉ David, Salomón pacʉ niiupi. Cʉ̃ paco pea Urías nʉmo ca niirico niiupo. ");
INSERT INTO baoNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón, Roboán pacʉ niiupi. Roboán, Abías pacʉ niiupi. Abías, Asá pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asá, Josafat pacʉ niiupi. Josafat, Jorán pacʉ niiupi. Jorán, Uzías pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías, Jotán pacʉ niiupi. Jotán, Acaz pacʉ niiupi. Acaz, Ezequías pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías, Manasés pacʉ niiupi. Manasés, Amón pacʉ niiupi. Amón, Josías pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías, Jeconías to biri cʉ̃ bairã pacʉ niiupi, israelitas're, Babilonia yepapʉ cʉ̃ja ca ñee waari cuure. ");
INSERT INTO baoNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babiloniapʉ cʉ̃ja ca ñee waaro jiro Jaconías, Salatiel pacʉ niiupi. Salatiel, Zorobabel pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel, Abiud pacʉ niiupi. Abiud, Eliaquín pacʉ niiupi. Eliaquín, Azor pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor, Sadoc pacʉ niiupi. Sadoc, Aquín pacʉ niiupi. Aquín, Eliud pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud, Eleazar pacʉ niiupi. Eleazar, Matán pacʉ niiupi. Matán, Jacob pacʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob, José pacʉ niiupi. José, María manʉ niiupi. María, Jesús, Mesías mani ca ĩigʉ paco niiupo. ");
INSERT INTO baoNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","To biri, Abraham niiquĩricʉ cʉ̃ ca niiri cuu mena, David menapʉre pʉa amo peti, dʉpore baparica penituaro niiri punaari peti nii wajoa nʉnʉa waaupa. Ñucã David niiquĩricʉ cʉ̃ ca niiri cuu mena, to biri israelitas're Babiloniapʉ cʉ̃ja ca ñee waari tabe menapʉre pʉa amo peti, dʉpore baparica penituaro niiri punaari peti nii wajoa nʉnʉa waaupa. Ñucã Babiloniapʉ israelitas're cʉ̃ja ca ñee waari tabe mena, to biri Mesías cʉ̃ ca baʉari tabepʉ menare, pʉa amo peti, dʉpore baparica penituaro niiri punaari peti nii wajoa nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo cʉ̃ ca baʉarique o biro biiupa: Cʉ̃ paco María, Josére manʉ cʉtirʉgo bii niiupo. José mena cõ ca niiparo jʉgueropʉra, Añuri Yeri cʉ̃ ca tii maji niirije jʉori, mee ʉtaagapʉ nii yerijãaupo. ");
INSERT INTO baoNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Cõ manʉ José pea, ca bojoca añugʉ niiri, bau niiropʉ Maríare, “ ‘To biro biimo,’ ĩi wede batetigʉra cõre ca cõacãpe niicu,” ĩi tʉgoeñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","“To biro yʉ tiigʉda,” cʉ̃ ca ĩi tʉgoeña niiri tabere, cʉ̃ ca quẽñaropʉ, jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃ cʉ̃re baua eari, o biro cʉ̃re ĩiupi: —José, David pãrami, Maríare nʉmo cʉtirʉgʉ uwiticãña. Cõ ca macʉ̃ jãñagʉa Añuri Yeri cʉ̃ ca tii maji niirije jʉori cõ ca bʉaricʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María jĩcʉ̃ macʉ̃ cʉtirucumo, “Jesús” cõ ca wãmeo tiipʉre. O biro wãme cʉtirucumi, cʉ̃ yaarã ñañarije cʉ̃ja ca tii niirijere ca ametʉenepʉ niiri —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ate niipetirije biiupa, Ʉmʉreco Pacʉ cʉ̃ yee quetire wede jʉgueri majʉ mena: ");
INSERT INTO baoNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Jĩcõ nomio, ʉmʉ mena ca nii ñaatigora, ʉtaaga nii, jĩcʉ̃ macʉ̃ cʉtirucumo, Emanuel cõ ca wãmeo tiipʉre,” cʉ̃ ca ĩiricarore biro to biijato ĩiro. (“Emanuel” ĩiro, “Ʉmʉreco Pacʉ mani mena niimi,” ĩirʉgaro ĩi.) ");
INSERT INTO baoNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","To biri José cãni wãcã, Ʉmʉreco Pacʉ pʉto macʉ̃ cʉ̃re cʉ̃ ca tii dotiricarore birora Maríare cõre nʉmo cʉtiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ména, cõ macʉ̃ Jesús cõ ca wãmeo tiiricʉ cʉ̃ ca baʉaparo jʉguero, cõ mena niitiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tii yepa macʉ̃ wiogʉ Herodes cʉ̃ ca niiri cuure, Judea yepa macã macã Belén'pʉ Jesús cʉ̃ ca baʉaricaro jiro, jĩcãrã ca majirã, muipũ cʉ̃ ca mʉa doori nʉña macã yepa macãrãpʉ, ñocõa cʉ̃ja ca biirijere ca buerã, Jerusalén're, ");
INSERT INTO baoNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","o biro ĩi jãiña eaupa: —¿Noo cʉ̃ niiti, judíos wiogʉ ca baʉaricʉ? Cʉ̃ ñocõre muipũ cʉ̃ ca mʉa doori nʉñapʉ niirã ĩari, cʉ̃re jãa ĩi nʉcʉ̃ bʉorã doojãwʉ —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","To biro cʉ̃ja ca ĩirijere tʉogʉ, wiogʉ Herodes pea ñee pee ĩi majiticã, bʉaro tʉgoeña paicoaupi. Ñucã Jerusalén macãrã cãa niipetirãpʉra to birora biiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","To biri wiogʉ Herodes pea, paia ʉparãre, doti cũuriquere jʉo bueri majare, jʉo nea poori: —Mesías, ¿noopʉ cʉ̃ baʉarʉgaupari? —cʉ̃jare ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","To biro cʉ̃ ca ĩi jãiñaro: —Judea yepa macã macã Belén'pʉ. O biro ĩi owaupi Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ: ");
INSERT INTO baoNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Mʉ Belén, Judea yepare ca niiri macã, tii yepa macã macãri ca nii majuropeeri macãri watoare, watoa macã macã méé mʉ nii. Mʉre jĩcʉ̃ wiogʉ baʉarucumi, yʉ yaarã, Israel yaa pooga macãrãre ca ĩa nʉnʉjeepʉ,” ĩi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","To cõrora Herodes pea, ca majirã wadore jʉo cojori, ñocõ cʉ̃ ca bau ea jʉorica cuure añuro cʉ̃jare jãiña tʉoupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","To biri Herodes Belén'pʉ cʉ̃jare tiicojogʉ, o biro ĩi cojoupi: —Waarãja, wimagʉ yee maquẽre añuro mʉja jãiña tʉo peticãwa. Cʉ̃re bʉarã, yʉ cãare mʉja queti tiicojowa, yʉ cãa, cʉ̃re yʉ ca nʉcʉ̃ bʉogʉ waapere biro ĩirã —cʉ̃jare ĩiupi Herodes. ");
INSERT INTO baoNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Wiogʉ to biro cʉ̃jare cʉ̃ ca ĩirijere tʉo yapanori jiro, ca majirã pea waacoaupa ñucã. Ñocõ, muipũ cʉ̃ ca mʉa doori nʉña macã yepapʉ niirã cʉ̃ja ca ĩaricʉ pea ñucã cʉ̃jare jʉgue nʉnʉa waa, wimagʉ cʉ̃ ca niiri tabe jotoa tua nʉcã eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ñocõ to biro cʉ̃ ca biiro ĩarã, ca majirã pea bʉaro ʉjea niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tii wiipʉ earã, wimagʉre, cʉ̃ paco María mena ca niigʉre ĩaupa. Cʉ̃re ĩarã, cʉ̃ja ãjʉro jupeari mena ea nuu, cʉ̃re ĩi nʉcʉ̃ bʉoupa. To biro tii, cʉ̃ja acacũmuarire pãa, oro, yucʉ díi ca jʉti añurije, mirra, cʉ̃re tiicojo nʉcʉ̃ bʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jiro quẽñaricaropʉ, “Herodes pʉto peera waaticãña,” ca ĩi wede majio ecoricarã niiri, cʉ̃ja yaa yepapʉ tua waarã, ape maa pee waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ca majirã cʉ̃ja ca tua waaro jiro, jĩcʉ̃, Ʉpʉ yʉʉ cʉ̃re queti wede bojari majʉ Josére cʉ̃ ca quẽñaropʉ cʉ̃re baua eari, o biro cʉ̃re ĩiupi: “Wãcãña. Wimagʉre, cʉ̃ pacore, Egiptopʉ jʉo duti waagʉja. Toopʉ mʉ niicãrucu ména. Jiro mʉre yʉ wederucu ñucã. Herodes wimagʉre cʉ̃re jĩa cõarʉgʉ mʉjare amagʉ doogʉ tiimi,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","To cõrora José pea wãcã, wimagʉre ami, cʉ̃ pacore jʉo, tii ñamira waacoaupa Egiptopʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Toopʉ niicãupa, Herodes cʉ̃ ca bii yairopʉ. O biro bii eaupa, Ʉmʉreco Pacʉ cʉ̃ yee quetire wede jʉgueri majʉ mena: “Egiptopʉ ca niigʉre yʉ jʉo cojowʉ yʉ Macʉ̃re,” cʉ̃ ca ĩi owa cũu jʉguequĩrique. ");
INSERT INTO baoNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herodes pea ca majirã cʉ̃re cʉ̃ja ca ĩi ditoriquere majiri, ajia ametʉacoari, Belén macãrã, tii macã wejari macãrã niipetirã ʉmʉa wimarãre pʉa cʉ̃ma ca cʉorã, cʉ̃ja jiro macãrã cãare jĩa peoticã dotiupi, ca majirã cʉ̃ja ca wedericarore biro, “To cãnacã cʉ̃ma ca cʉogʉ niicumi,” ĩi majiri. ");
INSERT INTO baoNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","O biri wãme bii eaupa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Jeremías niiquĩricʉ o biro cʉ̃ ca ĩi owarique: ");
INSERT INTO baoNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramápʉre acaro buirique wedeo, yacó, ñañaro tamʉo tʉgoeña pai otirique, wedeo. Raquel ĩimo, cõ punare otigo. ‘Otiticãña,’ ĩiriquere bootimo, mee, cõ puna cʉ̃ja ca bii yaicoarique ca niiro macã,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes cʉ̃ ca bii yairo jiro, jĩcʉ̃ Ʉpʉ yʉʉ cʉ̃re queti wede bojari majʉ, José, Egiptopʉ cʉ̃ ca niiro cʉ̃ ca quẽñaropʉ cʉ̃re baua eari, o biro cʉ̃re ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wãcãña. Wimagʉre, cʉ̃ pacore, jʉo tua waagʉja ñucã Israel yepapʉ. Mee wimagʉre ca jĩarʉgamiricarã bii yai peticoama,” cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","To biri José wãcã, wimagʉre, cʉ̃ pacore, Israel yepapʉ jʉo tuacoaupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","To biro bii pacagʉ, Herodes macʉ̃ Arquelao, cʉ̃ pacʉ wajoaye Judea yepa macãrã wiogʉ cʉ̃ ca niirijere queti tʉori, toopʉre waarʉgʉ uwi jañuupi. To biri cʉ̃ ca quẽñaropʉ Ʉmʉreco Pacʉ cʉ̃ ca wede majioricʉ niiri, Galilea yepa pee waacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Toopʉ eagʉ, Nazaret macãpʉ niigʉ waaupi. O biro bii eaupa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, “ ‘Nazaret macʉ̃ niimi,’ ĩiricʉ niirucumi,” cʉ̃ja ca ĩiricarore birora biro. ");
INSERT INTO baoNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tii rʉmʉrire Uwo Coeri majʉ Juan, Judea yepa macã yepa, ca yucʉ maniri yepapʉre Ʉmʉreco Pacʉ yee quetire wede eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","O biro ĩiupi: —Ñañarije mʉja ca tii niirijere tʉgoeña yeri wajoaya. Mee, Ʉmʉreco Pacʉ cʉ̃ ca dotipa cuu eacoaro bii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juan, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías o biro cʉ̃ ca ĩi owa jʉguericʉ niiupi: “Ca yucʉ maniri yepapʉ jĩcʉ̃ cʉ̃ ca acaro buirije o biro ĩi wedeo: ‘Ʉpʉre maa queno yueya; díámacʉ̃ maari cʉ̃re queno bojaya,’ cʉ̃ ca ĩiquĩricʉ.” ");
INSERT INTO baoNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan jutiro camello poa mena tiiricaro niiupa. Ñucã waibʉcʉ quejero daa menara wẽñaupi. Cʉ̃ baarique pea yejeroa, macãnʉcʉ̃ macãrã dobea oco, niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Cʉ̃ ca wederijere tʉorʉgarã, Jerusalén macãrã, Judea yepa niipetiro macãrã, dia Jordán pʉtori macãrã, niipetirã bojoca cʉ̃ pʉtopʉre earucuupa. ");
INSERT INTO baoNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ñañarije cʉ̃ja ca tiiriquere cʉ̃ja ca wede ametʉenero, Juan pea dia Jordán'pʉ cʉ̃jare uwo coeupi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Paʉ fariseos, to biri saduceos, cʉ̃re uwo coe dotirʉgarã cʉ̃ja ca dooro ĩagʉ, o biro cʉ̃jare ĩiupi Juan: —Añaa punaa, ¿ñiru mʉjare, Ʉmʉreco Pacʉ ñañaro cʉ̃ ca tiipe ca cõña doorijere, “Mʉja ametʉacãrucu,” mʉjare cʉ̃ ĩijãri? ");
INSERT INTO baoNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ñañarije mʉja ca tiirucurijere tii yerijãari, mʉja ca tʉgoeña yeri wajoarijere ĩñorã, ĩa majiricarora añuro niirique cʉti ĩño niiña. ");
INSERT INTO baoNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mʉja majuropeera, “Jãa, Abraham pãramerã jãa nii,” ĩi tʉgoeñaticãña. Yee méé mʉjare yʉ ĩi: Ʉmʉreco Pacʉa, ate ʉ̃tãgaarirena Abraham pãramerã tii jeeñocã majimi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mee, Ʉmʉreco Pacʉ bojoca ñañarãre, ñañaro cʉ̃ ca tiipe nii yerijãa. Niipetirije yucʉ, añurije ca dica cʉtitirijera, paa juderi pecamepʉ joe cõacãrique nii. ");
INSERT INTO baoNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","”Yʉa, añuro petira, ñañarije mʉja ca tii niirijere cʉ̃ja tʉgoeña yeri wajoajato ĩigʉ, oco mena mʉjare yʉ uwo coe. Yʉ jiro ca doogʉ pea yʉ ametʉenero do biro ca tiiya manigʉ niimi. Yʉa, cʉ̃ yee dʉpo juti ʉno cãare cʉ̃re ca jee cotepʉ ʉno méé yʉ nii. Cʉ̃a, Añuri Yeri mʉjapʉre cʉ̃ ca ñaajãa nʉcãro tiiri, ca ñañarije manirã mʉja ca tuaro tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Trigo quejerire cʉ̃ ca maa mʉene batepa tabere ami doomi. Ca ape peera teere queno cũurica tabepʉ queno cũu, tee quejeri peera pecame ca ʉ̃ʉ yatitiri pecamepʉ joe bate, tiirucumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús, Galilea ca niiricʉ, dia Jordán Juan cʉ̃ ca niiropʉ waaupi, “Yʉre cʉ̃ uwo coejato,” ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan pea cʉ̃re uwo coerʉgatigʉ, o biro cʉ̃re ĩiupi: —Yʉ pee yʉ nii, mʉ ca uwo coepʉa. ¿Ñee tiigʉ mʉ pee yʉ peere mʉ uwo coe dotigʉ dooti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —Añurucu. Mʉra yʉre uwo coecãña, Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojorore añurije mani ca tiipera niiro bii —ĩiupi. To biro cʉ̃ ca ĩiro, Juan pea Jesús're uwo coeupi. ");
INSERT INTO baoNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Juan cʉ̃ ca uwo coe yapanoro, Jesús cʉ̃ ca maa nʉcãrora, ʉmʉreco quejero pãa nʉcãcoaupa. To biro ca biiro Ʉmʉreco Pacʉ yʉʉ Añuri Yeri, buare biigʉ bau duwi doo, cʉ̃re ca ñaapea eagʉre ĩaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","To cõrora ʉmʉreco tutipʉ o biro ĩi wedeoupa: —Ani niimi yʉ Macʉ̃, yʉ ca maigʉ. Cʉ̃ mena bʉaro yʉ ʉjea nii —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jiro, Añuri Yeri ca bopori yepapʉ Jesús're amicoaupi, Satanás're ñañarije cʉ̃ tii doti eco ñaajato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Toopʉre cuarenta rʉmʉri, cuarenta ñamiri, baari méé biima ĩigʉ, queya tʉgoeñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","To biro cʉ̃ ca biiro, Satanás, Jesús pʉto eari, cʉ̃re ĩi buiyee ñaagʉ, o biro cʉ̃re ĩiupi: —Díámacʉ̃ra Ʉmʉreco Pacʉ Macʉ̃ra mʉ ca niijata, ate ʉ̃tãgaarire “Pan jee ñaaña,” ĩiña —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Ʉmʉreco Pacʉ wederique o biro ĩi: “Bojoca, baarique mena wado catitima. Niipetirije Ʉmʉreco Pacʉ wederique mena cãare caticã majima,” ĩi —cʉ̃re ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jiro Satanás, ca ñañarije maniri macã Jerusalén'pʉ cʉ̃re ami waa, Ʉmʉreco Pacʉ yaa wii jotoa bʉaro ca emʉari tabepʉ ami mʉa waari, ");
INSERT INTO baoNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","o biro cʉ̃re ĩiupi: —Díámacʉ̃ra Ʉmʉreco Pacʉ Macʉ̃ra mʉ ca niijata, anopʉ menara bupu duwi waagʉja. Ʉmʉreco Pacʉ wederique o biro ĩi: “Ʉmʉreco Pacʉ, cʉ̃ pʉto macãrãre mʉre ĩa nʉnʉjee doti cojorucumi, cʉ̃ja amori mena mʉre tuu ñeerucuma, jĩcãga ʉ̃tãga ʉno mena peera mʉ ca pʉata ñaatipere biro ĩirã,” ĩi —cʉ̃re ĩiupi Satanás. ");
INSERT INTO baoNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Ñucã Ʉmʉreco Pacʉ wederique o biro ĩi: “Ʉpʉ, mʉ Ʉmʉreco Pacʉre ĩi buiyee ñaaticãña,” ĩi —ĩiupi Satanás're. ");
INSERT INTO baoNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jiro ñucã Satanás, ʉ̃tãgʉ ca emʉaricʉ jotoapʉ Jesús're ami waa, ati yepa macã macãri, to biri tii macãri ca cʉorije niipetirijere cʉ̃re ĩño peoticãri, ");
INSERT INTO baoNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","o biro cʉ̃re ĩiupi: —Ate niipetirije mʉre yʉ tiicojorucu, mʉ ãjʉro jupea mena ea nuuri, yʉre mʉ ca ĩi nʉcʉ̃ bʉojata —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","To biro cʉ̃ ca ĩirora: —Waagʉja Satanás. Ʉmʉreco Pacʉ wederique o biro ĩi: “Ʉpʉ, mʉ Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉoya. Cʉ̃ jĩcʉ̃rena cʉ̃ ca ĩirore biro tii nʉnʉjeeya,” ĩi —cʉ̃re ĩi yʉʉupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","To cõrora Satanás pea, Jesús're camotaticoaupi. To biro cʉ̃ ca biiro, jĩcãrã Ʉmʉreco Pacʉ pʉto macãrã Jesús're tii nemorã eaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jiro Jesús, Juan're cʉ̃ja ca tia cũuriquere queti tʉori, Galilea yepa pee tuacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret macãre tuatigʉra, Zabulón, Neftalí jãa yaa yepa macã macã ʉtabʉcʉra tʉjaro ca niiri macã Capernaúm pee niigʉ waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ate to biro biiupa Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías, o biro cʉ̃ ca ĩiquĩricarore biro bii earo: ");
INSERT INTO baoNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Zabulón, Neftalí jãa yaa yepa, Jordán ape nʉña, dia pairi yaa buuro jotoare, Galilea, judíos ca niitirã cʉ̃ja ca niiri yepa, ");
INSERT INTO baoNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ʉmʉreco Pacʉre majitima ĩirã, ca naitĩaropʉ ca niirãre biro ca niiricarã, pairo ca boe baterijere ĩawa. Ñañaro ca bii yaiparã ca niirãre, ca boerije cʉ̃jare boe bate ñaacũmu eawʉ,” cʉ̃ ca ĩirique. ");
INSERT INTO baoNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tii tabe mena Jesús, añurije quetire o biro ĩi wede jʉoupi: “Ñañarije mʉja ca tii niirijere tʉgoeña yeri wajoa, Ʉmʉreco Pacʉ peere tʉo nʉnʉjeeya. Mee Ʉmʉreco Pacʉ cʉ̃ ca dotirije eacã dooro bii,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jiro Jesús, Galilea ʉtabʉcʉra tʉjaro waa nʉnʉa waarucugʉ, pʉarã jĩcʉ̃ punare ĩa bʉaupi. Jĩcʉ̃ Simón, ñucã cʉ̃ra Pedro ca wãme cʉtigʉ, apĩ Andrés, niiupa. Wai wajari maja niiri, cʉ̃ja bapi yucʉre cõañua niirã tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Cʉ̃jare ĩa, o biro cʉ̃jare ĩiupi Jesús: —Yʉ mena dooya. Yʉ pea waire mʉja ca waja bʉa majirore birora, bojoca, yʉre ca tʉo nʉnʉjeerã cʉ̃ja ca niiro ca tii majirã mʉjare yʉ tiirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","To biro cʉ̃jare cʉ̃ ca ĩiro, cʉ̃ja bapi yucʉre cũu, cʉ̃ mena waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ñucã too jʉguero jañuroacã pʉarã ĩa bʉaupi, Zebedeo puna Santiago, Juan, cʉ̃ja pacʉ mena cũmuapʉ cʉ̃ja bapi yucʉre ca jia jãa queno niirãre. Jesús pea cʉ̃jare jʉoupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","To cõrora cʉ̃ja pea cũmuare, cʉ̃ja pacʉre, cũu, cʉ̃ mena waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús, Galilea yepa niipetiropʉ cʉ̃ja ca nea poo juu bueri wiijeripʉ cʉ̃jare bue, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ añurije quetire wede, ñucã niipetirije bojoca cʉ̃ja ca diarique cʉtirijere, cʉ̃jare ca punirijere, cʉ̃jare ametʉene, tii yujuupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","To biro Jesús cʉ̃ ca tiirije pea, Siria yepa niipetiropʉ queti bate nʉcã peticoaupa. To biri Jesús pʉtore bojorica wãmeri ca diarique cʉtirã niipetirã, upʉri ca ñejerãre, ca wãtĩa jãa ecoricarãre, ñama diarique ca diarique cʉtirãre, ca bʉʉricarãre, jee dooupa. Jesús pea cʉ̃jare catioupi. ");
INSERT INTO baoNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Paʉ bojoca, Galilea macãrã, Decápolis yepa macã macãri macãrã, Jerusalén macãrã, Judea macãrã, to biri dia Jordán ape nʉña muipũ cʉ̃ ca mʉa doori nʉña macã yepa macãrã, niipetirã Jesús're cʉ̃re nʉnʉupa. ");
INSERT INTO baoNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Paʉ bojocare ĩari, Jesús pea ʉ̃tãgʉ ca nii mʉa waari buuropʉ maa waa, ea nuu waawi. To biro cʉ̃ ca biiro cʉ̃ buerã cãa cʉ̃ pʉto pee nea poo waawa. ");
INSERT INTO baoNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Cʉ̃ pea o biro cʉ̃jare ĩi bue jʉo waawi: ");
INSERT INTO baoNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Ʉjea niima, ca boo pacarã yeri ca yeri cʉtirã; Ʉmʉreco Pacʉ cʉ̃ ca dotiri tabea cʉ̃ja yaa tabe nii. ");
INSERT INTO baoNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ʉjea niima ñañaro ca tamʉorã, tʉgoeña tutuariquere tiicojo ecorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Ʉjea niima “O biro ca biirã jãa nii,” ca ĩitirã; Ʉmʉreco Pacʉ “Yʉ tiicojorucu,” cʉ̃ ca ĩirica yepare cʉo earucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Ʉjea niima, añurijere tiirʉgarã, oco jinirʉga, aʉa boa, biirãre biro ca bii tʉgoeñarã; cʉ̃ja ca tiirʉgarore biro cʉ̃jare ca bii bojaro ʉjea niirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Ʉjea niima ca boo paca ĩarã; Ʉmʉreco Pacʉ cãa cʉ̃jare boo paca ĩarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Ʉjea niima, cʉ̃ja yeripʉ añurije wado ca tʉgoeñarã; cʉ̃ja, Ʉmʉreco Pacʉre ĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Ʉjea niima, añuro jĩcãri mena niirique maquẽre ca pade niirã; Ʉmʉreco Pacʉ, “Yʉ puna,” cʉ̃jare ĩirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Ʉjea niima, añurijere tiima ĩirã, ñañaro cʉ̃ja ca tiirʉga nʉnʉjeerã; Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea cʉ̃ja yaa tabe nii. ");
INSERT INTO baoNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","”Ʉjea niirã mʉja niirucu, yʉ yee jʉori, bojoca ñañarije mʉjare ĩi tuti, ñañaro mʉjare tii, ñucã ĩi ditorãra mʉja menare niipetirije ñañarije ĩi, cʉ̃ja ca ĩiro. ");
INSERT INTO baoNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ʉjea niiña; añuro ʉjea niirã niiña. Ʉmʉreco tutipʉ añurijere pairo mʉja tiicojo ecorucu. Mʉja jʉguero ca dooricarã Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cãare o birora ñañaro cʉ̃jare tiirʉga nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","”Mʉja ati yepa macãrã moa mʉja nii. ¿Moa, ca ocarije to ca peticoajata, do biro pee biicãri ñucã nemo to oca eabogajati? Ca ocatirijepʉa ñee ʉno pee añuti. To biri macãpʉ cʉ̃ja ca cõarijere bojoca pea teere ʉta yaio batecãma. ");
INSERT INTO baoNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mʉja ati yepare ca ʉ̃ʉ boerije mʉja nii. Jĩcã macã ʉ̃tãgʉ jotoa ca niiri macã do biro pee bii yai majiti. ");
INSERT INTO baoNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ñucã jĩa boericagare upa coro doca pee cũurʉgarã méé jĩa tuama. To biro tiitirã, emʉaro pee peoma, wii ca niirã niipetirãre to ʉ̃ʉ boejato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Teere birora mʉja cãa, bojoca cʉ̃ja ca ĩa cojoro añurijere tii niiña. Añuro mʉja ca tii niirijere ĩari, niipetirã cʉ̃ja Pacʉ ʉmʉreco tutipʉ ca niigʉre cʉ̃ja ca baja peopere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","”Mʉja, “Doti cũuriquere, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca wede cũuquĩriquere, cõagʉ doogʉ doojacupi,” ĩi tʉgoeñaticãña. Teere cõagʉ doogʉ méé yʉ biiwʉ. Tee ca ĩirore biro tiigʉ doogʉ pee yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yee méé mʉjare yʉ ĩi: Ména, ati ʉmʉreco, ati yepa, ca niiro, doti cũuriquea, jĩcã tabeacã ʉnora, jĩcã wãmeacã ʉnora, yai nʉcãcoa biitirucu, tee niipetirije ca ĩirore biro ca biiparo jʉguerore. ");
INSERT INTO baoNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","To biri doti cũurique ca dotirijere bʉaro ca biitirijeacã ʉnorena tee ca ĩirore biro tii nʉnʉjeeti, aperã cãare “Tee ca ĩirore biro tii nʉnʉjeeya,” ĩi bue majioti, ca biigʉa, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre “Watoa macʉ̃ niimi,” ĩi ecorucumi. Doti cũurique ca ĩirore biro tii nʉnʉjee, ñucã aperã cãare “Tee ca ĩirore biro tii nʉnʉjeeya,” cʉ̃jare ca ĩi bue majio ca tiigʉa, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre “Ca nii majuropeegʉ niimi,” ĩi ecorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","”To biri doti cũuriquere jʉo bueri majare, fariseos're, Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojoro añurije tii niiriquere cʉ̃jare mʉja ca tii ametʉa nʉcãtijata, jĩcãti ʉno peera Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre mʉja eatirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","”Mʉja, mʉja ñicʉ̃ jʉ̃mʉapʉre: “Jĩaticãña. Ca jĩagʉa, jãiña bejeri majapʉ cʉ̃ja ca jãiña beje niigʉ tuacãrucumi,” ĩiriquere mʉja tʉojacupa. ");
INSERT INTO baoNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Yʉ pea o biro mʉjare yʉ ĩi: No ca boogʉ cʉ̃ yee wedegʉ mena ca ajiagʉa, jãiña bejeri majapʉ cʉ̃ja ca jãiña beje niigʉ tuacãrucumi. Ñucã cʉ̃ yee wedegʉre ñañarije ca ĩi tutigʉa, ʉparã ca nii majuropeerãpʉ cʉ̃ja ca jãiña beje niigʉ tuacãrucumi. Ñucã no ca boogʉ cʉ̃ yee wedegʉre, “Ca tʉgoeña majitigʉ,” ca ĩi tutigʉa, pecame ca ʉ̃ʉ yatitiri pecamepʉ ñañaro ca bii yaipʉ niirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","”To biri Ʉmʉreco Pacʉre mʉ ca tiicojo nʉcʉ̃ bʉorijere joe mʉenerica tutupʉ teere mʉ ca jee waajata, toopʉ niigʉra mʉ yee wedegʉre ñañaro mʉ ca tiiriquere mʉ ca tʉgoeña bʉajata, ");
INSERT INTO baoNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","tii tutu pʉtora tii nʉcʉ̃ bʉorʉgʉ mʉ ca jee waariquere cũu, mʉ yee wedegʉre ñañaro mʉ ca tiiriquere, cʉ̃ mena wederique queno jʉogʉja. To biro tii yapanoripʉ docare tua doo, tiicojo nʉcʉ̃ bʉorʉgʉ mʉ ca jee waariquere joe mʉeneña. ");
INSERT INTO baoNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Ñucã mʉre ca ĩa tutigʉ, ʉparãpʉre mʉre cʉ̃ ca wedejãarʉgajata, yoari mééra ca jãiña bejegʉ pʉtopʉ ami waarʉgʉ cʉ̃ ca tii niiropʉra cʉ̃ mena ameri wede quenoña, cʉ̃ pʉtopʉ mʉre cʉ̃ ca ami waatipere biro ĩigʉ. To biro mʉ ca tiitijata, ca coterã uwamarãpʉre mʉre tiicojo, ñucã cʉ̃ja pea mʉre tia cũu, tiicãrucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Yee méé mʉre yʉ ĩi: “Wapa tiirica tii ca tʉjari tiiacãpʉ mʉ ca wapa tiitijata, toore mʉ wititirucu”. ");
INSERT INTO baoNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","”Ñucã, “Mʉ nʉmo ca niitigopʉre tii epeticãña,” ĩiriquere mʉja tʉojacupa. ");
INSERT INTO baoNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Yʉ pea, no ca boogʉ jĩcõ nomiore, cõre tiirʉgarique mena ca ĩagʉa, mee cʉ̃ yeri cʉ̃ ca tʉgoeñarijepʉ cõ mena tiicã yerijãa waami,” yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","To biri mʉ capega díámacʉ̃ nʉña macãga ñañarije mʉ ca tiiro to ca tiijata, jade wee amiri yoaropʉ cõacãña. Jĩcã tabera mʉ upʉ macã tabe to ca bii yairo añujañu. Niipetiri upʉ menapʉra pecame ca ʉ̃ʉ yatitiri pecame pee mʉ ca cõa joe ecojata docare añuti. ");
INSERT INTO baoNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ñucã mʉ amo díámacʉ̃ nʉña ñañarije mʉ ca tiiro to ca tiijata, paa taari, yoaropʉ cõacãña. Jĩcã tabera mʉ upʉ macã tabe to ca bii yairo añujañu. Niipetiri upʉ menapʉra pecame ca ʉ̃ʉ yatitiri pecame pee mʉ ca cõa joe ecojata docare añuti. ");
INSERT INTO baoNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","”Ñucã o biro ĩirique niiupa: “No ca boogʉ cʉ̃ nʉmore cʉ̃ ca cõajata, ‘To biro cõ ca biirije jʉori cõre yʉ cõa,’ ĩirica pũurore tiicojorique niirucu,” ĩirique niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Yʉ pea o biro mʉjare yʉ ĩi: Jĩcʉ̃ cʉ̃ nʉmore, apĩ mena cõ ca tii epeti pacaro cõre cʉ̃ ca cõajata, cõ manʉ ca niitigʉpʉre cõ ca tiiro cõre tii buiyeegʉ tiimi. Ca manʉ cõaricore ca nʉmo cʉtigʉa, cʉ̃ nʉmo ca niitigopʉre tii epegʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","”Ñucã mʉja ñicʉ̃ jʉ̃mʉapʉre, o biro cʉ̃jare cʉ̃ ca ĩiriquere mʉja tʉojacupa: “ ‘Yee méé jãa ĩi,’ ĩirique mena, jãa tiicojorucu Ʉpʉre mʉja ca ĩiriquere, mʉja ca ĩiricarore biro tiiya,” ĩiriquere. ");
INSERT INTO baoNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Yʉ pea o biro mʉjare yʉ ĩi: Díámacʉ̃ra “Yee méé yʉ ĩi,” ĩiti majuropeecãña. “Ʉmʉreco quejero mena yʉ ĩi,” ĩiticãña. Ʉmʉreco quejeroa, Ʉmʉreco Pacʉ cʉ̃ ca duwiri tabe nii. ");
INSERT INTO baoNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ñucã, ati yepa mena cãare ĩiticãña. Ati yepa cãa, Ʉmʉreco Pacʉ cʉ̃ ca ʉta cũuri tabe niiro bii. Ñucã, “Jerusalén mena yʉ ĩi,” ĩiticãña. Tii macã, Wiogʉ do biro Ca Tiiya Manigʉ yaa macã niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ñucã, mʉja dʉpʉga mena cãare ĩiticãña. Mʉja poare jĩcã daarena ca botiri daa, ca ñiiri daa, ca niiro mʉja tii majiti. ");
INSERT INTO baoNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Mee, “Yʉ tiirucu,” “Yʉ tiiticu,” ĩirique menara añucã. Atere mʉja ca camotatijata, ca ñañagʉ yeere tiirã mʉja tii. ");
INSERT INTO baoNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","”O biro ĩiriquere mʉja tʉojacupa: “Mʉ capere cʉ̃ ca ñañojata, mʉ cãa to birora cʉ̃re tii ameña. Ñucã mʉ upire cʉ̃ ca paa peejata, mʉ cãa to birora cʉ̃re tii ameña,” ĩiriquere. ");
INSERT INTO baoNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","To biro ca ĩimijata cãare, yʉ pea o biro mʉjare yʉ ĩi: “Ñañaro mʉjare cʉ̃ja ca tiimijata cãare, ameticãña. Jĩcʉ̃ ʉno mʉja wajopuare cʉ̃ ca paajata, ape nʉña cãare paa dotiya. ");
INSERT INTO baoNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ñucã jĩcʉ̃ ʉno mʉjare wedejãacãri, mʉja jutirore cʉ̃ ca ẽmarʉgajata, jotoa mʉja ca jãñarito cãare cʉ̃ amicoajato,” ĩicãña. ");
INSERT INTO baoNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","No ca boogʉ, apeye ʉno jĩcã kilómetro mʉjare cʉ̃ ca jee waa dotijata, pʉa kilómetropʉ cʉ̃re jee waa bojaya. ");
INSERT INTO baoNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","No ca boogʉ apeye ʉno mʉjare ca jãigʉre, cʉ̃re tiicojoya. Mʉja yeere ca wajorã cãare, “Jãa wajoti,” ĩiticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","”Ñucã o biro ĩiriquere mʉja tʉojacupa: “Mʉ mena macʉ̃re mai, mʉre ca ĩa tutigʉ peera ĩa tuti, tiiya,” ĩiriquere. ");
INSERT INTO baoNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","To biro ca ĩimijata cãare, yʉ pea o biro mʉjare yʉ ĩi: Mʉjare ca ĩa tutirãre mai, ñañaro tiirʉgarã mʉjare ca nʉnʉrãre juu bue boja, tiiya. ");
INSERT INTO baoNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","To biro tiirã mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ puna mʉja niirucu. Cʉ̃a, cʉ̃ muipũre ca bojoca ñañarã, ca bojoca añurã, cʉ̃ja ca niiro cãare cʉ̃ ca ajiro tii, ñucã to birora ñañarije ca tiirã, añurije ca tiirã, cʉ̃ja ca niiri taberi cãare oco ca pearo tii, tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Mʉjare ca mairã wadore mʉja ca maijata, ¿ñee ʉno añurije mʉja tiicojo ecorãti? Roma maquẽ ca niipere wapa jee bojari majapʉ cãa, to birora biirique cʉtima. ");
INSERT INTO baoNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ñucã mʉja yaarã wadore mʉja ca añu dotijata, ¿ñee ʉno pee añurijere tii ametʉene nʉcãrã mʉja tiiti? Ʉmʉreco Pacʉre ca majitirãpʉ cãa, to biirijera biima. ");
INSERT INTO baoNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Mʉja Pacʉ, ʉmʉreco tutipʉ ca niigʉ añugʉ cʉ̃ ca niirore birora, mʉja cãa, añurã niiña —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","—Añurijere tii niirã, bojoca cʉ̃ja ĩajato ĩirã wado tiiticãña. To biro mʉja ca tiijata, mʉja Pacʉ, ʉmʉreco tutipʉ ca niigʉ, jĩcã wãme ʉnora añurijere mʉjare tiicojotirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","To biri ca boo pacarãre tii nemorã mʉja ca tiicojoriquere, bojoca niipetirãpʉre to biro mʉja ca tiirijere wede bate cojoticãña, watoara ca bii dito pairã, “Ca bojoca añurã niima” jãare cʉ̃ja ĩi nʉcʉ̃ bʉojato ĩirã, nea poo juu buerica wiijeripʉ, wiijeri watoa macã yeparipʉ, cʉ̃ja ca ĩi nucũ yujurore biro. Díámacʉ̃ mʉjare yʉ ĩi: To biro ca ĩirãra, mee bojoca to biro cʉ̃jare cʉ̃ja ca ĩi nʉcʉ̃ bʉorijera niicã, cʉ̃ja ca wapa taarije. ");
INSERT INTO baoNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","To biri mʉ, ca boo pacarãre mʉ ca tii nemojata, mʉ mena macʉ̃ ca nii majuropeegʉ cãare wedeticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yaioroacã mʉ jĩcʉ̃ra tiicã niiña. To biri mʉ Pacʉ yairopʉ mʉ ca tiirijere ca ĩagʉ, to biro mʉ ca tiirije wapare añurije mʉre tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","”Ñucã juu buerã, watoara ca bii dito pairã, bojoca jãare cʉ̃ja ĩajato ĩirã, nea poo juu buerica wiijeripʉre, ñucã wiije watoa macã yeparipʉre nucũcãri, cʉ̃ja ca juu bue nucũ yujurore biro biiticãña. Yee méé mʉjare yʉ ĩi: To biro ca tiirãra, mee, bojoca cʉ̃jare cʉ̃ja ca ĩi nʉcʉ̃ bʉorijera niicã, cʉ̃ja ca wapa taarije. ");
INSERT INTO baoNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mʉ pea mʉ ca juu buejata, mʉ yaa jawipʉ jãa waa, jope bia, mʉ Pacʉ mʉ mena yaioropʉ ca niigʉ wado cʉ̃ ca majiro juu bueya. To biri mʉ Pacʉ yaioropʉ mʉ ca tiirijere ca ĩagʉ, añurijere mʉre tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","”Ñucã juu buerã, Ʉmʉreco Pacʉre ca majitirã cʉ̃ja ca ĩirore biro, “Jĩcãti méé jãa ca ĩiro Ʉmʉreco Pacʉ jãare tʉorucumi,” ĩi tʉgoeñari, tii wãme wadorena bʉaro jañuro cʉ̃ja ca ĩicã dia waarore biro ĩiticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Cʉ̃jare biro biiticãña. Mʉjara, mee mʉja Pacʉ mʉja ca jãiparo jʉgueropʉra mʉja ca boorijere maji yerijãami. ");
INSERT INTO baoNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Mʉja o biro ca ĩi juu bueparã mʉja nii: “Jãa Pacʉ, ʉmʉreco tutipʉ ca niigʉ, mʉ wãme ĩi nʉcʉ̃ bʉorica wãme to niijato. ");
INSERT INTO baoNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Mʉ ca dotirije to doojato. Ʉmʉreco tutipʉre mʉ ca boori wãme mʉ ca tiirore birora tiiya ati yepa cãare. ");
INSERT INTO baoNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Mecʉ̃ jãare tiicojoya, to cãnacã rʉmʉra jãa ca baapere. ");
INSERT INTO baoNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ñañarije jãa ca tiiriquere jãare acoboya, aperã ñañaro jãare cʉ̃ja ca tiirijere jãa ca acoborucurore biro. ");
INSERT INTO baoNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ñañarije ca bii buiyeerijere jãa ca tiiro tiiticãña; tiitigʉra ñañarijere jãare ametʉeneña. Ʉpʉ niirique, do biro ca tiigʉ manigʉ niirique, ca añu majuropeegʉ niirique, mʉ yee to birora ca niicõa niirije nii. To biro to biijato,” ĩiña. ");
INSERT INTO baoNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","”Aperã ñañaro mʉjare cʉ̃ja ca tiiriquere mʉja ca acobojata, mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ cãa, ñañarije mʉja ca tiirijere mʉjare acoborucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Aperã ñañaro mʉjare cʉ̃ja ca tiirijere mʉja ca acobotijata, Ʉmʉreco Pacʉ cãa, ñañarije mʉja ca tiiriquere mʉjare acobotirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","”Betiri juu bue niirã, watoara ca bii dito pairã, bojoca, “Betiri juu buerã tiima,” jãare cʉ̃ja ĩi ĩajato ĩirã, tʉgoeñarique pairã cʉ̃ja ca niirore biro biiticãña. Yee méé mʉjare yʉ ĩi. To biro ca biirãra, “Teere tiirã tiima,” bojoca cʉ̃jare cʉ̃ja ca ĩi nʉcʉ̃ bʉorijera niicã, cʉ̃ja ca wapa taarije. ");
INSERT INTO baoNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mʉ pea betiri mʉ ca juu buejata, mʉ poare wʉa peo queno, ca jʉti añurije wada, mʉ diámacʉ̃re waa coe, tiiya, ");
INSERT INTO baoNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","bojoca, “Betiri juu bue niigʉ tiimi,” cʉ̃ja ca ĩi ĩa majitipere biro ĩigʉ. To biro mʉ ca tiiro, mʉ Pacʉ yairopʉ ca niigʉ, yairopʉ tiiriquere ca ĩagʉ wado, añurijere mʉre tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","”Õpẽcõarã baa yaiocã, no ca boorora bii yaicã, jee dutiri maja jãa waa jee duticã, cʉ̃ja ca tii niiri yeparena pairo apeye cʉti, jee cũu cʉo, tii niiticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Apeye mʉja yee ca niipere, ʉmʉreco tutipʉ, õpẽcõa ʉnora baati, boati, jee dutiri maja cãa jãa waari jee dutiti, cʉ̃ja ca biiri tabepʉre queno cũuña. ");
INSERT INTO baoNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","To biri mʉja apeye ca niiri tabera niirucu, mʉja yeri cãa. ");
INSERT INTO baoNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","”Capegaaria, upʉ maquẽ ca jĩa boericari nii. To biri mʉja cape añurije to ca niijata, mʉja upʉ niipetiro ca boerijere cʉorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mʉja cape ñañarije to ca niijata, mʉja upʉ niipetiropʉra ca naitĩaropʉ niicãrucu. Ca boerije mʉjare ca niimiriquera ca naitĩarije to ca bii ñañacoajata, ¿no cõro peti to naitĩagajati, ca naitĩa majuropeerijepʉa? ");
INSERT INTO baoNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","”Jĩcʉ̃ ʉno peera, pʉarã ʉparãpʉre pade cote majitimi. To biro cʉ̃ ca biijata, jĩcʉ̃re ĩa tuti, apĩ peere mai, ñucã jĩcʉ̃ cʉ̃ ca dotirijere tii boja, apĩ cʉ̃ ca dotirije peera tiiti, biicãcumi. To biri Ʉmʉreco Pacʉ yeere tii pacagʉ, ñucã apeye cʉti niirique pee cãare tii nʉnʉjee majiña mani. ");
INSERT INTO baoNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","”To biri o biro mʉjare yʉ ĩi: “Catirʉgarã, baa, jini, mʉja ca tii niiperena, ñucã juti mʉja ca jãñaperena, tʉgoeñarique paiticãña. ¿Mani ca catirijea baarique ametʉenero wapa cʉti, ñucã mani upʉ cãa, juti ametʉenero wapa cʉti, to biititi? ");
INSERT INTO baoNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Minia, ʉmʉreco quejerore ca wʉʉrãre ĩañaaqué: Oteti, ote dicare jeeti, ote dica queno cũurica wiijeripʉ queno cũu cʉoti, biima. To biro cʉ̃ja ca bii pacaro, mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ pea, cʉ̃ja ca baapere cʉ̃jare tiicojomi. ¡Mʉja pee doca, minia ametʉenero mʉja wapa cʉti! ");
INSERT INTO baoNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿To biicãri, mʉja mena macʉ̃ niipe, bʉaro cʉ̃ ca tʉgoeña pato wãcãrije menara, jĩcã cuu cʉ̃ bʉcʉa mʉa nemo majicãgajati? ");
INSERT INTO baoNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","”¿Ñee tiirã juti mʉja ca jãñaperena to cõro bʉaro mʉja tʉgoeñarique paiti? Ĩañaaqué. Do biro to bʉcʉati oori taa yeparipʉre. Padeti, juti ca jãñapere juati, bii. ");
INSERT INTO baoNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","To ca bii pacaro, wiogʉ Salomón peti cãa niipetirije añurije cʉocã pacagʉ, tee ametʉenero añurijepʉra juti jãñatiquĩupi,” mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Mecʉ̃re nii, ñucã boero ʉnora joe bate ecocã yaiwa, ca biirije taa cãare ĩaricaro añurije juti jãami Ʉmʉreco Pacʉ. Mʉja docare tee ametʉenero añurije mʉjare juti jãarucumi, petoacã peti díámacʉ̃ ca tʉo nʉcʉ̃ bʉorã. ");
INSERT INTO baoNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","”To biri, “¿Ñee mani baarãti? ¿Ñee mani jinirãti? ¿Ñee mani jãñarãti?” ĩi tʉgoeñarique pai, jãiña nucũ yujuticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ʉmʉreco Pacʉre ca majitirã niima, ate niipetirije ca ama nucũ yujurã. Mee, mʉja pea ʉmʉreco tutipʉ ca niigʉre, jĩcʉ̃ mʉja Pacʉ cʉti, mʉja ca boorije niipetirijere ca majigʉre. ");
INSERT INTO baoNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","To biri mʉja, Ʉmʉreco Pacʉ cʉ̃ ca doti niirije peere, Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojorore añurije tii niirique peere, ama jʉoya, ñucã ate niipetirije cãare mʉja tiicojo ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","”To biri boero ca biipere tʉgoeña pato wãcã bʉañaaticãña. Boero cãare niirucu ñucã, apeye mʉja ca boo tʉgoeñarije. To cãnacã rʉmʉra tʉgoeñarique pairique mena wado niicã —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","—Jĩcʉ̃ ʉno peerena, “To biro biimi,” ĩi ĩa bejeticãña, mʉja cãa, mʉja ca ĩa beje ecotipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aperãre mʉja ca ĩa bejericarore birora Ʉmʉreco Pacʉ cãa, mʉjare ĩa bejerucumi. Ñucã aperãre ñañaro mʉja ca tiiricaro cõrora, Ʉmʉreco Pacʉ cãa ñañaro mʉjare tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ñee tiigʉ mʉ yee wedegʉre taa daacã cʉ̃ capegapʉre ca niiri daa peere mʉ ĩa nʉnʉjeeti, mʉ capega peere yucʉ dʉcaro ca jãñari dʉca peera “To biro bii,” ĩiti pacagʉ? ");
INSERT INTO baoNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Mʉ capegare yucʉ dʉcaro ca jãñagʉ nii pacagʉ, ¿ñee tiigʉ mʉ yee wedegʉre, “Taa daa mʉ capegapʉre ca jãñari daare yʉre ami cõa dotiya,” cʉ̃re mʉ ĩibogajati? ");
INSERT INTO baoNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Watoara ca bii dito paigʉ! Mʉ capegare ca jãñari dʉcaro peere ami cõa jʉoya. To biro tiicãri jiropʉ, mʉ yee wedegʉ capegapʉre taa daa ca jãñari daare ami cõarʉgʉ, añuro mʉ ĩa majirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","”Ñucã, Ʉmʉreco Pacʉ yee añurije quetire ca tʉo junarãrena wedeticãña, teere tʉo ajiama ĩirã, mʉjare ñañaro cʉ̃ja ca paa jude batetipere biro ĩirã. Ñucã mʉja yee ʉ̃tã ca wapa pacarije cãare, yejeapʉre cõa cũuticãña, teere cʉ̃ja ca ʉta yaio batetipere biro ĩirã —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","—Jãiña, Ʉmʉreco Pacʉ mʉjare tiicojorucumi. Amaña, amarã mʉja bʉarucu. Jopere eari jʉoya, mʉja pãa jõene ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","To biri ca jãigʉ tiicojo ecomi. Ca amagʉ cãa bʉami. Ñucã jopere eari ca jʉogʉ cãa pãa ecomi. ");
INSERT INTO baoNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿To docare, jĩcʉ̃ mʉja mena macʉ̃ ʉno, cʉ̃ macʉ̃ pan cʉ̃re cʉ̃ ca jãiro, ʉ̃tãgara cʉ̃re cʉ̃ tiicojocãbogajati? ");
INSERT INTO baoNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿Ñucã wai cʉ̃ ca jãiro, añarena cʉ̃re cʉ̃ tiicojocãbogajati? ");
INSERT INTO baoNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Mʉja ñañarã nii pacarã, mʉja punare añurijere mʉja tiicojo maji. ¡Mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ pee doca, ametʉenero añurijere tiicojorucumi, cʉ̃re ca jãirãre! ");
INSERT INTO baoNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","”To biri mʉja, aperã añuro mʉjare cʉ̃ja ca tiiro mʉja ca boorore birora, añuro cʉ̃jare tiiya. Atera niicã, doti cũurique, ñucã Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, cʉ̃ja ca ĩirique. ");
INSERT INTO baoNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","”Ca ejatiri jope peere jãa waarãja. Jope ejari jopero, maa eja añuri maaro, nii, ñañaro bii yairica tabepʉre ca nii waarijea. Teepʉre paʉ jãa waama. ");
INSERT INTO baoNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Jope, maa, to birora caticõa niirica tabepʉre ca nii waarije pea ejati, ñucã do biro bii waa majiña manirijeacã nii, bii. Paʉacã méé niima, tii jopere, tii maare, ca bʉarã. ");
INSERT INTO baoNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","”Ʉmʉreco Pacʉ cʉ̃ ca ĩirijere ca wederãre biro ca ĩi dito yujurã menare tʉo majiña. Ovejare biirã baurã mʉja pʉtore dooma. Bii pacarã cʉ̃ja yeripʉra macãnʉcʉ̃ yaia ca wuarã petire biro ca niirã niima. ");
INSERT INTO baoNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mʉja pea cʉ̃ja ca tii niirijepʉre mʉja ĩa majirucu. Pota yucʉpʉre, ʉjere jeeya mani. Ñucã higo cãare, pota woopʉre jeeya mani. ");
INSERT INTO baoNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Niipetirije yucʉ añurije, añurije dica cʉti. Yucʉ ñañarije cãa, ñañarijera dica cʉti. ");
INSERT INTO baoNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Yucʉ añuri yucʉra, ñañarije dica cʉtiti. Ñucã to birora ñañari yucʉ pee cãa, añurije dica cʉtiti. ");
INSERT INTO baoNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","To biri niipetiri yucʉ añurije ca dica cʉtitiri yucʉra queti, pecamepʉ joe batecãrique nii. ");
INSERT INTO baoNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","To biri mʉja, cʉ̃ja ca tii niirijepʉre mʉja ĩa majirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","” “¡Wiogʉ, Wiogʉ!” yʉre ca ĩirã niipetirãpʉra Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre ea waatirucuma. Yʉ Pacʉ, ʉmʉreco tutipʉ ca niigʉ cʉ̃ ca boorore biro ca tiirã wado ea waarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niirore, paʉ o biro yʉre ĩirucuma: “Wiogʉ, Wiogʉ, jãa cãa, mʉ ca dotiro mena ca biipere wede jʉgue, mʉ wãme mena ĩiri wãtĩa, bojocapʉre ca ñaajãa nʉcãricarãre cõa wiene, ñucã mʉ wãme mena ĩiri, paʉ wãmeri ca ĩa ñaaña manirije tii bau nii, jãa tiiwʉ,” ĩimirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","To cõrora yʉ pea o biro cʉ̃jare yʉ ĩirucu: “Jĩcãti ʉno peera mʉjare yʉ ĩa ñaatiwʉ. Yʉre camotati waarãja mʉja ñañarije ca tiirã,” cʉ̃jare yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","”To biri yʉ ca ĩirijere tʉori, yʉ ca ĩirore biro ca tiigʉa, ca tʉgoeña majigʉ, ʉ̃tãga jotoara ca wii bʉaricʉre biro niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Oco pea, diari pai, tii wiire bʉaro wino paa puu cõa tuu, tiiupe. To biro to ca tiicã pacaro, ʉ̃tãga jotoarena wii botarire cʉ̃ ca nʉcõrique niiri ñaatiupe. ");
INSERT INTO baoNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yʉ ca ĩirijere tʉo pacagʉ, yʉ ca ĩirore biro ca tiitigʉa, ca tʉgoeña bojoca catitigʉ, jita dupari yeparena ca wii bʉaricʉre biro niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Oco pea, diari pai, wino bʉaro to ca paa puurora, cague batecã ñaaduwi waaupe. To biro ca biirije pea do biro tii majiña maniro tʉgoeñarique paiorije biiupe —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Atere Jesús cʉ̃ ca wede yapanoro, niipetirã bojoca cʉ̃ ca bue majiorijere tʉorã, ñee pee ĩiticãwa, ");
INSERT INTO baoNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","doti cũuriquere ca jʉo buerãre biro méé, añuro doti majirique mena cʉ̃ ca bue majioro macã. ");
INSERT INTO baoNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ʉ̃tãgʉ ca nii mʉa waari buuropʉ ca niiricʉ Jesús cʉ̃ ca duwi dooro, paʉ bojoca cʉ̃re nʉnʉupa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tii tabere jĩcʉ̃ ca cami boagʉ, Jesús pʉto ea, cʉ̃ ãjʉro jupea mena cʉ̃ jʉguero ea nuu waari, o biro cʉ̃re ĩiupi: —Wiogʉ, mʉ ca boojata, yʉ ca boa diarique cʉtirijere yʉre ametʉeneña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","To biro cʉ̃ ca ĩiro, Jesús pea cʉ̃ amo mena cʉ̃re padeñari: —Yʉ boo, cami manigʉ tuaya —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩirora, ca cami boamiricʉ jĩcãto cami manigʉpʉ tuacãupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","To biro tii yapano, o biro cʉ̃re ĩi nemoupi Jesús: —Tʉoya, jĩcʉ̃ ʉno peerena wedeticãña. Díámacʉ̃ra pai pʉtopʉ waari, ĩñoña mʉ ca biiriquere. Ñucã Moisés niiquĩricʉ cʉ̃ ca tiicojo dotiriquere jee waagʉja, paiapʉ cʉ̃ja ca majipere biro ĩigʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jesús, Capernaúm macãre cʉ̃ ca piya nʉnʉa waaro, jĩcʉ̃ romano uwamarã ʉpʉ yʉre tii nemoña ĩigʉ, Jesús pʉto dooupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","O biro ĩiwi: —Wiogʉ, wiipʉre yʉ paderi majʉ bʉʉcãri, waa majiri méé, ñañaro peti punirije tamʉo niijãwi —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","To biro cʉ̃ ca ĩiro, Jesús pea: —Jaʉ. Cʉ̃re yʉ catiogʉ waarucu —cʉ̃re ĩi yʉʉwi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","To biro cʉ̃ ca ĩiro, uwamarã ʉpʉ pea o biro cʉ̃re ĩi yʉʉwi: —Wiogʉ, yʉa, yʉ yaa wiire mʉre ca jãa dotipʉ ʉno méé yʉ nii. Yʉre pade bojari majʉ cʉ̃ ca diarique ametʉape wadore doti cojoya. Yʉre pade bojari majʉ caticoarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yʉ cãa, yʉ wiorã cʉ̃ja ca dotirijere ca tiigʉ yʉ nii. Yʉ cãa ñucã, uwamarã yʉ ca dotirije ca tiirãre yʉ cʉo. To biri jĩcʉ̃ cʉ̃ja mena macʉ̃re, “Waagʉja,” yʉ ca ĩiro, waami. Ñucã apĩre, “Dooya” yʉ ca ĩiro, doomi. Yʉre pade bojari majʉ cãare, “Teere tiiya” yʉ ca ĩiro, yʉ ca ĩirore biro tiimi —ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús pea atere tʉogʉ, tʉo ʉcʉacoawi. To biri o biro ĩiwi cʉ̃re ca nʉnʉrãre: —Yee méé mʉjare yʉ ĩi: Ano Israel yepare jĩcʉ̃ ʉno peerena ani to cõro bʉaro “Yʉre tii nemocãrucumi,” cʉ̃ ca ĩi tʉgoeña bayirore biro ca biigʉre yʉ bʉa ea ñaati. ");
INSERT INTO baoNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","To biri paʉ, muipũ cʉ̃ ca mʉa doori nʉña macãrã, cʉ̃ ca ñaajãa waari nʉña macãrã, doori, Abraham, Isaac, Jacob jãa mena, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre baa duwirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre ca niiboricarã pea, ca naitĩari yepa pee cõa wiene ecorucuma, oti, cʉ̃ja upi baca dʉpo, cʉ̃ja ca biipa yepapʉre —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","To biro ĩi, uwamarã ʉpʉ peera o biro ĩiwi: —Tua waagʉja mʉ yaa wiipʉ. “Yʉre catio bojacãrucumi,” mʉ ca ĩi tʉgoeña bayirore birora to biijato —cʉ̃re ĩiwi. Uwamarã ʉpʉre pade coteri majʉ pea to biro cʉ̃ ca ĩiri nimarora caticoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jiro Jesús, Pedro yaa wiipʉ waagʉ, Pedro mañicõ wiorique ca dia yojagore bʉa eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","To biro cõ ca biiro, Jesús pea cõ amore cʉ̃ ca padeñarora, wiorique jĩcãto yerijãacoaupa. To biri wãmʉ nʉcã, “¿Mʉja doocãjãri?” cʉ̃jare ĩi jãi boca jʉo waaupo. ");
INSERT INTO baoNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ca naio doori tabe ca niiro paʉ bojoca ca wãtĩa jãa ecoricarãre jee waaupa Jesús pʉtopʉ. Jesús pea cʉ̃ ca wederije menara yeri ñañarãre cõa wiene, ñucã niipetirã ca diarique cʉtirã cãare cʉ̃jare catio, tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Atea Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías niiquĩricʉ: “Cʉ̃ majuropeera mani ca diarique cʉtirijere jee, puniro mani ca tamʉorijere jee ʉpa, tiiwi,” cʉ̃ ca ĩiquĩrique ca ĩirore biro to biijato ĩiro, bii earo biiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Paʉ peti bojoca cʉ̃re cʉ̃ja ca nucũ amojodero ĩari, “Ʉtabʉcʉra ape nʉñapʉ mani tĩa waaco,” ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","To biro cʉ̃ ca ĩiri tabera, jĩcʉ̃ doti cũuriquere bueri majʉ cʉ̃ pʉto doori, o biro ĩiwi Jesús're: —Buegʉ, yʉ cãa, noo mʉ ca waari taberi cõro mʉ mena yʉ waa yujurʉga —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉwi Jesús: —Buu yairoa cʉ̃ja ca cãniri operi cʉoma. Minia cãa cʉ̃ja die batiri cʉoma. Yʉ, Ca Nii Majuropeegʉ Macʉ̃ pea, yʉ ca cãniri tabe ʉnora yʉ cʉoti —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ñucã apĩ jĩcʉ̃ cʉ̃ buerã mena macʉ̃ o biro cʉ̃re ĩiwi: —Wiogʉ, yʉ pacʉre yʉ yaa jʉogʉ waarʉga ména —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —Yʉ mena pee dooya. “Ca bii yairã majuropeera cʉ̃ja yaarã ca bii yairãre cʉ̃ja yaajato,” ĩicãña —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","To biro ĩi yapano, cũmuapʉ ea jãacoawi. Cʉ̃ buerã cãa cʉ̃re jãa nʉnʉ waawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Too jãa ca tĩa nʉnʉa waaro, ca niiro tʉjarora, ʉtabʉcʉrare bʉaro wino paa puu, bʉaro oco jabe, biima ĩiro, ca duacoaparo cõropʉ cũmuare oco jabe jãawʉ. Jesús pea cãnicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","To biro ca biiro, cʉ̃ buerã pea o biro cʉ̃re jãa ĩi wãcõrã waawʉ: —Buegʉ, jãare ametʉeneña. Dua waarã mani bii —jãa ĩi acaro buiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","To biro jãa ca ĩiro, cʉ̃ pea o biro jãare ĩi yʉʉwi: —¿Ñee tiirã to cõro bʉaro mʉja uwiti? ¿“Manire ametʉenecãrucumi,” ĩi tʉgoeña bayiriquere no cõro petoacã peti mʉja cʉocãti? —jãare ĩiwi. To biro jãare ĩicã, wãmʉ nʉcãri, winore, oco ca jaberijere to cõrora yerijãa dotiwi. To biro cʉ̃ ca ĩirora, jĩcãto añuropʉ yerijãa peticoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","To biro ca biirijere jãa pea ĩa ʉcʉacoari, jãa majurope o biro jãa ameri ĩi jãiñawʉ: —¡Ayó nija! ¿Ñiru ʉno peti cʉ̃ niigajati ania, winopʉra, oco ca jaberijepʉra, cʉ̃ ca dotirore biro añuro ca tʉo nʉnʉjee ecogʉa? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Ʉtabʉcʉra ape nʉñapʉ Gadara yepapʉre Jesús cʉ̃ ca tĩa earo, pʉarã ca wãtĩa jãa ecoricarã, maja operi watoapʉ ca niiricarã ũmaa witi doori, Jesús pʉto eawa. Bʉaro peti uwioro ca tiirã cʉ̃ja ca niiro macã, jĩcʉ̃ ʉno peera tii maare waatirucuupa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Cʉ̃ja pea o biro ĩi acaro buiwa: —Jesús, Ʉmʉreco Pacʉ Macʉ̃, jãare pato wãcõgʉ dooticãña. ¿Tii cuu ca eatirora ñañaro jãare tiigʉ doogʉ anopʉ mʉ doojãri? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","To biro cʉ̃ja ca ĩi niiri tabe jʉguero jañuro peere ecaricarã yejea paʉ baa niiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","To biri wãtĩa pea bʉaro Jesús're o biro ĩi jãiwa: —Jãare mʉ ca cõa wienejata, yejeapʉre jãare jãa dotiya —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","To biro cʉ̃ja ca ĩiro, “Waarãja,” cʉ̃jare ĩiwi Jesús. To biro cʉ̃ ca ĩirora, wãtĩa, ʉmʉapʉre ca niiricarã witi waari, yejeapʉre ñaajãa nʉcã eawa. To cõrora yejea pea, niipetirãpʉra upa tʉdipʉ ũmaa bua waa, ʉtabʉcʉrapʉ ñaañua, dua yai peticoawa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Yejeare ca cote niiricarã pea to biro ca biirijere ĩa ʉcʉa ũmaa duti tua waa, macãpʉ earã, to biro ca biirique niipetirore, ñucã ca wãtĩa jãa ecomiricarã cʉ̃ja ca biirique cãare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","To biro cʉ̃ja ca ĩirijere tʉori, tii macã macãrã niipetirã Jesús cʉ̃ ca niiri tabepʉre ĩarã dooupa. To biri cʉ̃re ĩarã, tii yepare cʉ̃ ca niiro bootirã, “Aperopʉ waacoagʉja,” bʉaro cʉ̃re ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ate jiro Jesús cũmuapʉ ea jãa, ʉtabʉcʉra ape nʉñapʉ tĩa waa, cʉ̃ yaa macãpʉ eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Toopʉ cʉ̃ ca earo, jĩcʉ̃ ca bʉʉricʉre ca diagʉre ami waarica quejero mena cʉ̃re yoo waaupa. Jesús pea, “Jesús cʉ̃re catiocãrucumi,” cʉ̃ja ca ĩi tʉgoeña bayirijere ĩa majiri, o biro ĩiupi ca bʉʉricʉre: —Macʉ̃, tʉgoeña tutuaya. Mee, ñañarije mʉ ca tii bui cʉtirique acoboriquepʉ nii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","To biro cʉ̃ ca ĩiro tʉorã jĩcãrã, doti cũuquĩriquere jʉo bueri maja pea o biro ĩi tʉgoeñaupa: “Ani cʉ̃ ca ĩirijea Ʉmʉreco Pacʉre ñañaro ĩi tutirique niiro bii,” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús pea to biro cʉ̃ja ca ĩi tʉgoeñarijere majiri, o biro cʉ̃jare ĩi jãiñaupi: “¿Ñee tiirã mʉja to cõro peti ñañarije mʉja tʉgoeñarique cʉticãti? ");
INSERT INTO baoNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Ñee pee ĩiricaro popiye méé to niiti, ‘Mee, ñañarije mʉ ca tii bui cʉtirique acoboriquepʉ nii,’ ĩirique, ‘Wãmʉ nʉcãri waagʉja,’ ĩirique pee?” ");
INSERT INTO baoNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Too docare, “Yʉ, Ca Nii Majuropeegʉ Macʉ̃, ati yepa cãare ñañarije tiiriquere yʉ ca acobo majirijere mʉja ca majipere biro ĩigʉ, mʉjare yʉ ĩñorucu,” ĩiupi. To cõrora o biro ĩiupi ca bʉʉricʉre: —Wãmʉ nʉcãña. Mʉ ca pejarica quejerore ami, mʉ yaa wiipʉ tua waagʉja —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","To biro cʉ̃ ca ĩiro cʉ̃ pea wãmʉ nʉcã, cʉ̃ yaa wiipʉ tuacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Bojoca pea atere ĩarã, bʉaro uwi, Ʉmʉreco Pacʉre baja peoupa, to cõro peti doti majiriquere bojocare cʉ̃ ca tiicojorique jʉori. ");
INSERT INTO baoNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Too ca niiricʉ waagʉ, yʉ, Mateo ca wãme cʉtigʉ, Roma maquẽre wapa jee bojagʉ duwirica tabepʉ yʉ ca duwiro yʉre ĩa bʉari: —Jamʉ. Yʉ mena dooya —yʉre ĩiwi Jesús. To cõrora wãmʉ nʉcã, cʉ̃re yʉ nʉnʉcoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesús, yʉ yaa wiipʉ cʉ̃ ca baa niiro, paʉ Roma maquẽ wapa jee bojari maja, aperã bojoca ñañarije ca tiirique cʉtirã, eari cʉ̃ja cãa, Jesús, to biri jãa cʉ̃ buerã mena baa duwiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Atere ĩarã, fariseos pea o biro jãare ĩi jãiñawa: —¿Ñee tiigʉ mʉjare ca buegʉ pea Roma maquẽre wapa jee bojari maja mena, ñañarã mena, cʉ̃ baa bapa cʉti niiti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús pea to biro cʉ̃ja ca ĩirijere tʉori, o biro cʉ̃jare ĩiwi: —Añurã, ca diarique manirã, ʉco tiiri majʉre bootima. Ca diarique cʉtirã ʉco tiiri majʉre booma. ");
INSERT INTO baoNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Waari, ate ca ĩirʉgarijere to biro ĩirʉgaro ĩi, ĩi bue majirãja: “Mʉjare yʉ ca boo jãarijea, ca ĩa mairã mʉja ca niipe pee nii. Waibʉcʉrã jĩari mʉja ca joe jʉti añu mʉenerucurijere yʉ booti,” ca ĩirijere. Yʉa añurãre jʉogʉ doogʉ méé yʉ doowʉ. Ñañarã peere jʉogʉ doogʉ yʉ doowʉ —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Jĩcã rʉmʉ Juan buerã Jesús pʉto eari, o biro cʉ̃re ĩi jãiñawa: —Jãa, to biri fariseos, paʉ tiiri betiri jãa juu buerucu. ¿Ñee tiirã mʉ buerã pea betiri cʉ̃ja juu buetiti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —¿To docare amo jiarica boje rʉmʉre cʉ̃ja ca jʉo cojoricarã, ca amo jiapʉ cʉ̃ja mena cʉ̃ ca nii pacaro, bʉaro tʉgoeñarique pai yapa puarã cʉ̃ja nii cotebogajati? Biiropʉa earucu jĩcã rʉmʉ, ca amo jiapʉre cʉ̃ja ca ami weo waari rʉmʉ. To cõro docare betirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jĩcʉ̃ ʉno peera, jutiro bʉcʉrore wãma quejero mena sere tuu queno majitimi. To biro cʉ̃ja ca tiijata, wãma quejero pee tʉ̃a dʉoma ĩiro, jutiro bʉcʉro peere tʉ̃a yegacãcu; ca yegari ope pea pairi ope waacu yua. ");
INSERT INTO baoNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ñucã ʉje oco wãmare, waibʉcʉ quejero poa bʉcʉ poapʉre pio jãaña mani. To biro tiijata, tii poa yega yaicoacu. To biri ʉje oco cãa jite batecoa, tii poa cãa yegacã yai waa, biicu. To biri ʉje oco wãmare waibʉcʉ quejero poa wãma poapʉ ca pio jãape nii. To biro tiiricaro, pʉa wãmepʉra añuro niicã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ména Jesús to biro cʉ̃jare cʉ̃ ca ĩi niirora, jĩcʉ̃ judíos ʉpʉ ea, cʉ̃ ãjʉro jupeari mena cʉ̃ jʉguero ea nuu waari, o biro ĩiwi Jesús're: —Yʉ macõ mecʉ̃acãra bii yaicã yerijãa waamo. To ca bii pacaro doori, mʉ amo mena cõre ñia peogʉ dooya, caticoarucumo ñucã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","To biro cʉ̃ ca ĩiro Jesús pea wãmʉ nʉcã, cʉ̃ mena waagʉ, jãa, cʉ̃ buerã mena bapa cʉti waawi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Too jãa ca waaro Jesús jiro pee, jĩcõ nomio pʉa amo peti, dʉpore pʉaga penituaro niiri cʉ̃mari peti díi ca waa yerijãatirije ca diarique cʉtigo doori, cʉ̃ jutiro yapapʉ padeñaupo, ");
INSERT INTO baoNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","o biro ĩi tʉgoeñari: “Cʉ̃ jutiro wadorena yʉ ca padeña eyocãjata, tee menara diarique manigo yʉ tuarucu,” ĩiri. ");
INSERT INTO baoNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesús pea amojode nʉcã cõre ĩari, o biro ĩiwi: —Macõ, tʉgoeña tutuaya. “Jesús yʉre catiocãrucumi,” mʉ ca ĩi tʉgoeña bayirije jʉori mʉ diarique ametʉene eco —ĩiwi. Cõ pea to biro cõre cʉ̃ ca ĩiri tabe mena, diarique manigo tuawo. ");
INSERT INTO baoNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jesús pea judíos ʉpʉ yaa wiipʉ eagʉ, cõre cʉ̃ja ca yaaro ca baja coteparã ca queno yuericarãpʉre, to biri bojoca bʉaro ca oti yugui niirãre ĩari, ");
INSERT INTO baoNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","o biro cʉ̃jare ĩiwi: —Anore witicoarãja. Atio wãmo bii yaitimo. Cãnigo tiimo —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro tʉorã, bojoca pea cʉ̃re boca buicãwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Cʉ̃ pea cʉ̃jare wiene peticãri, ca bii yairico cõ ca niiropʉ jãa waa, cõ niiquĩrico amore ñeewi. Cõ pea cati tua wãmʉ nʉcãcoawo. ");
INSERT INTO baoNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","To biro Jesús cʉ̃ ca tiirije, tii yepare queti jeja nʉcã peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús too ca niiricʉ cʉ̃ ca waa nʉnʉa waaro, pʉarã ca ĩatirã o biro cʉ̃re ĩi acaro bui nʉnʉjeewa: —Jesús, David Pãrami, jãare boo paca ĩaña —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wiipʉ Jesús cʉ̃ ca jãa waaro, ca ĩatirã cʉ̃ pʉto pee doowa. Cʉ̃ pea o biro cʉ̃jare ĩi jãiñawi: —“¿Atere jãare ametʉenecãrucumi,” mʉja ĩi tʉgoeña nʉcʉ̃ bʉoti? —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —“Ʉ̃gjá Wiogʉ,” cʉ̃re ĩi yʉʉwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","To cõrora Jesús pea cʉ̃ja capere padeñari, o biro cʉ̃jare ĩiwi: —“Jesús jãare catiocãrucumi,” mʉja ca ĩi tʉgoeña bayirore birora to biijato —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","To biro cʉ̃ ca ĩirora, añuro ĩacoawa. Jesús pea bʉaropʉra: —Atere aperã cʉ̃ja ca majiro tiiticãña —cʉ̃jare ĩi wede majiomiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","To biro cʉ̃ ca ĩi pacaro, cʉ̃ja pea too ca niiricarã witi waarãra, Jesús cʉ̃ ca tiiriquere tii yepa macãrã niipetirãpʉre wede bato peoticãupa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ca ĩatirã ca niiricarã cʉ̃ja ca witi waari tabera, jĩcãrã jĩcʉ̃ ca wedetigʉ, ca wãtĩ jãa ecoricʉre Jesús pʉto ami doowa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesús, wãtĩre cʉ̃ ca cõa wienerora, ca wedetigʉ ca niirucumiricʉ pea wedecoawi. Bojoca pea teere ĩa, ñee pee ĩi majiticã, o biro ĩiwa: —Jĩcãti ʉno peera, ano Israel yepapʉre ate ʉnore ĩaña maniwʉ —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","To biro cʉ̃ja ca ĩicãro, fariseos pea o biro ĩi cotewa: —Ania wãtĩa wiogʉ majuropeera wãtĩare cõa wiene majiriquere cʉ̃ ca tiicojoricʉ niiri to biro tiimi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús to cãnacã macãripʉrena paca macãri, õcã macãriacã cãare, nea poo juu buerica wiijeripʉ bue majio, añurije queti Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre cʉ̃jare wede, ñucã niipetirije diarique, cʉ̃ja upʉri ca punirijere ametʉene, tii yujuwi. ");
INSERT INTO baoNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Paʉ bojocare ĩari, cʉ̃jare boo paca ĩawi, tʉgoeñarique pairã, do biro bii majiti, oveja cʉ̃jare ca cotegʉ manirã cʉ̃ja ca biirore biro cʉ̃ja ca biiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","To biri jãa cʉ̃ buerãre, o biro jãare ĩiwi Jesús. —Añuro petira, ote dica paʉ peti niicã. Paderi maja pee paʉacã méé niima. ");
INSERT INTO baoNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","To biri mʉja, oterique Ʉpʉre jãiña, paderi maja teere ca jeeparãre cʉ̃ tiicojojato ĩirã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús, pʉa amo peti, dʉpore pʉaga penituaro ca niirã cʉ̃ buerãre jʉo cojori, yeri ñañarãre cõa wiene majiriquere, diarique ca niirije cõrorena, upʉri ca punirijere, ametʉeneriquere jãare ʉpowi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ate nii, jãa cʉ̃ buerã, pʉa amo peti, dʉpore pʉaga penituaro ca niirã wãme: ca nii jʉogʉ Simón, ñucã cʉ̃ra Pedro ca wãme cʉtigʉ, cʉ̃ yee wedegʉ Andrés, Zebedeo puna, Santiago, cʉ̃ yee wedegʉ Juan, ");
INSERT INTO baoNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, yʉ Mateo, Roma maquẽre wapa jee bojari majʉ ca niiricʉ, Alfeo macʉ̃ Santiago, Tadeo, ");
INSERT INTO baoNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Zelote yaa puna macʉ̃ Simón, Judas Iscariote, jiro Jesús're ca wedejãa buiyee cõapʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús jãa cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirãre o biro ĩi majiocãri, jãare tiicojo cojowi: —Ʉmʉreco Pacʉre ca majitirã cʉ̃ja ca niiri macãrire, ñucã Samaria yepa macã macãri cãare, waaticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel yaa pooga macãrã, oveja ca maa wijia yairicarãre biro ca niirã peere waarãja. ");
INSERT INTO baoNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Noo mʉja ca waari taberi cõro, “Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri cuu eacã doo,” cʉ̃jare ĩi wedeya. ");
INSERT INTO baoNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ca diarique cʉtirãre cʉ̃jare diarique ametʉene, ca bii yairicarãre cʉ̃ja ca cati tuaro tii, cami boarique ca diarique cʉtirãre catio, wãtĩare cõa wiene, tiiya. Mʉja atere tii maji tutuariquere wapa maniro mʉja ñeewʉ. To biri to biiro mʉja ca tiirijere wapa jãiticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","”Mʉja wẽñarica daare mʉja ca yoori poare oro, plata, cobre ʉnora, jee jãa waa, ");
INSERT INTO baoNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","wajopoa ʉnora, juti mʉja ca wajoa jãñape ʉnora, dʉpo juti mʉja ca wajoape ʉnora, ñucã tuericagʉ ʉnora, jee waaticãña. Paderi majʉa tee wapara baarique eca eco majimi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jĩcã macã, pairi macã ʉnore, peti macãacã ʉnore, earã, bojocʉ ca añugʉ ʉnore amari, cʉ̃ yaa wiira niicãña. Apero mʉja ca waari rʉmʉpʉ tii wiire witiya. ");
INSERT INTO baoNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wiire jãa waarã, tii wii macãrãre añu doti jãa eaya. ");
INSERT INTO baoNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tii wii macãrã teere ca boorã ʉno cʉ̃ja ca niijata, añuro niirique cʉ̃jare mʉja ca boo jãarije mʉja ca boorore birora cʉ̃jare biirucu. Teere ca bootirã cʉ̃ja ca niijata, mʉja peera añuro niirique yai nʉcãtirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Mʉjare booti, mʉja ca wederijere tʉorʉgati, cʉ̃ja ca biijata, to cõrora tii wiire, tii macãre, witi waarã, jita mʉja dʉpore ca niirijere paa bate cũu, waacoarãja. ");
INSERT INTO baoNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Yee méé mʉjare yʉ ĩi: Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niiro, tii macã macãrã Sodoma, Gomorra macãri macãrã ñañaro cʉ̃ja ca tamʉoricaro ametʉenero, ñañaro tamʉorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","”Ĩaña. Ovejare biro ca niirãre, macãnʉcʉ̃ yaia ca uwiorã watoapʉre mʉjare yʉ tiicojo. To biri aña cʉ̃ ca biirore biro ca bii majirã niiña. Bii pacarã, búá cʉ̃ ca biirore biro ñañarije ca tiitirã niiña. ");
INSERT INTO baoNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Bojoca catiri niiña, ʉparã pʉtopʉ mʉjare jee waa, nea poo juu buerica wiijeripʉra mʉjare bape, ");
INSERT INTO baoNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ñucã yʉ yee jʉori, macãri ʉparã pʉtoripʉ, wiorã pʉtoripʉ mʉjare jee waarucuma. To biro cʉ̃ja ca tiiro, yʉ yee maquẽre wiorãre, Ʉmʉreco Pacʉre ca majitirãre, mʉja wederucu. ");
INSERT INTO baoNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mʉjare ñeeri, ʉparãpʉre mʉjare cʉ̃ja ca tiicojoro, mʉja ca ĩipere, “¿Do biro mani ĩirãti?” ĩi tʉgoeñarique paiticãña. Mʉja ca wedepa tabe ca earo, Ʉmʉreco Pacʉ mʉja ca wedepere mʉjare majiorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Mʉja méé mʉja wederucu. Mʉja Pacʉ yʉʉ Añuri Yeri, mʉjapʉre ñaajãa nʉcãri, mʉjare wede bojagʉ ĩirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","”Cʉ̃ yee wedegʉ, cʉ̃ yee wedegʉrena cʉ̃ja ca jĩa cõaro tii, cʉ̃ pacʉ cʉ̃ macʉ̃rena wedejãa buiyee cõacã, ñucã cʉ̃ja puna cãa cʉ̃ja pacʉarena ĩa junari, cʉ̃jare cʉ̃ja ca jĩa cõaro tii, tiirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yʉ yee jʉori, niipetirã mʉjare ĩa tutirucuma. To biro ca biirije watoara ca tʉgoeña bayi yapano nʉcãcãgʉa, ametʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ñucã jĩcã macãre ñañaro mʉjare tiirʉgarã cʉ̃ja ca nʉnʉjata, ape macã pee duticoarãja. Yee méé mʉjare yʉ ĩi. Israel yepa macã macãrire mʉja ca waa yuju petitirora, yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ eacã doorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","”Jĩcʉ̃ bueri majʉ peera, cʉ̃re ca buegʉ ametʉenero majitimi. Ñucã jĩcʉ̃ pade coteri majʉ peera, cʉ̃ ʉpʉ ametʉenero niitimi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ca buegʉa, cʉ̃re ca buegʉ cʉ̃ ca biirore biropʉ cʉ̃ ca bii earo añu. Ca pade coteri majʉ cãa, cʉ̃ ʉpʉre biropʉ cʉ̃ ca bii earo añu. Wii ʉpʉrena, “Beelzebú” cʉ̃ja ca ĩicãjata, cʉ̃ yaa wii macãrã pee docare ametʉenero ĩicuma. ");
INSERT INTO baoNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","”Bojocarena uwiticãña. Jĩcã wãme ʉno peera jĩcãrãra majirique, majiña manirijera biicã yerijãa waa, ca biirije mani. Ñucã yaioropʉ ca niirije cãa, majiña manirijera biicã yerijãa waa, biiti. ");
INSERT INTO baoNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Yaioropʉ mʉjare yʉ ca ĩirijere paʉ cʉ̃ja ca tʉo cojoropʉ wede bateya. Ñucã mʉja wadorena yʉ ca ĩirije cãare, wiijeri jotoapʉ mʉa peari, acaro bui wede bateya. ");
INSERT INTO baoNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Upʉre ca jĩa cõarãrena uwiticãña. Mani yeripʉra jĩa cõa majiticuma. Upʉre, mani yeripʉ cãare, pecame ca ʉ̃ʉ yerijãatiri pecamepʉ ca joe cõagʉ pee docare uwiya. ");
INSERT INTO baoNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","¿Jĩcã tiiacã, wapa tiirica tii wapara pʉarãpʉ miniare to noniña maniti? To ca bii pacaro, mʉja Pacʉ cʉ̃ ca bootijata, jĩcʉ̃ ʉno peera ñaacoa, biitima. ");
INSERT INTO baoNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Cʉ̃a, mʉja cãare, mʉja dʉpʉga maquẽ poare tii daari cõrorena cʉ̃ ca cõo peotiriquepʉ cʉocãmi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","To biri uwiticãña. Mʉja, paʉ minia ametʉenero ca wapa cʉtirã mʉja nii. ");
INSERT INTO baoNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","”No ca boogʉ yʉre ca tʉo nʉnʉjeegʉ yʉ yee maquẽre bojocare cʉ̃ ca wedejata, yʉ cãa, yʉ Pacʉ ʉmʉreco tutipʉ ca niigʉre, cʉ̃re yʉ wede bojarucu. ");
INSERT INTO baoNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Bojoca cʉ̃ja ca tʉo cojoro, “Jesús're yʉ majiti” ca ĩigʉra, yʉ cãa, “Cʉ̃re yʉ majiti” yʉ ĩirucu, yʉ Pacʉ ʉmʉreco tutipʉ ca niigʉre. ");
INSERT INTO baoNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","” “Ati yepare añuro niiriquere jee doogʉ biijacupi,” yʉre ĩi tʉgoeñaticãña. Añuro niirique jee doogʉ méé yʉ biiwʉ. Añuro jĩcãri mena ca nii majiña manirije peere jee doogʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","“Jĩcʉ̃ ʉmʉ, cʉ̃ pacʉrena ĩa juna, cõ macõ cõ pacorena ĩa juna, cõ macʉ̃ nʉmo cõ mañicõrena ĩa juna, cʉ̃ja ca biipere jee doogʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","To biri cʉ̃ja ca niiro cõrorena cʉ̃jare ca ĩa tutirã, cʉ̃ja yaarãra niirucuma.” ");
INSERT INTO baoNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yʉre cʉ̃ ca mairo ametʉenero, cʉ̃ pacʉre, cʉ̃ pacore ca maigʉa, yʉ yeere tii nʉnʉjee majitimi. Ñucã yʉre cʉ̃ ca mairo ametʉenero cʉ̃ macʉ̃re, cʉ̃ macõre, ca maigʉa, yʉ yeere tii nʉnʉjee majitimi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yʉ yee jʉori, ñañaro tamʉo ca bii nʉnʉjeetigʉa, yʉ yeere tii nʉnʉjee majitimi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Cʉ̃ ca cati niirijere ca maigʉa, cʉ̃ ca catipere bʉatirucumi. Yʉ yee jʉori, ñañaro ca tamʉo yaigʉa, cʉ̃ ca caticõa niipere bʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","”Añuro mʉjare ca ñeegʉa, yʉrena ñeegʉ tiimi. Yʉre ca ñeegʉa, yʉre ca tiicojo cojoricʉrena ñeegʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉre, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ cʉ̃ ca niiro macã, añuro ca jãi bocagʉa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ cʉ̃ ca wapa taaro cõrora wapa taarucumi. Ñucã ca añugʉre añugʉ cʉ̃ ca niiro macã, añuro cʉ̃re ca jãi bocagʉa, añugʉ cʉ̃ ca wapa taaro cõrora wapa taarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yee méé mʉjare yʉ ĩi: No ca boogʉ, yʉre ca tʉo nʉnʉjeerã mena macʉ̃re petoacã ca oco tĩagʉa, jĩcʉ̃ yʉre ca tʉo nʉnʉjeerã mena macʉ̃re cʉ̃ ca tiirije ca niiro macã, tee wapa wapa ñeetigʉra tua, biitirucumi —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús, jãa cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirãre wede majio yapano, too ca niiricʉ Galilea yepa macã macãripʉ cʉ̃jare bue majio, añurije quetire wede, tii yujugʉ waacoawi. ");
INSERT INTO baoNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Uwo Coeri majʉ Juan tia cũurica wiipʉ niigʉ, Cristo cʉ̃ ca tii niirijere queti tʉori, cʉ̃ buerã mena macãrã pʉarãre: ");
INSERT INTO baoNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—¿Mʉra mʉ niiti, “Mesías doorucumi” cʉ̃ja ca ĩiricʉ? ¿Ména apĩre jãa yuerãtiqué? —ĩi jãiña dotigʉ tiicojo cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Waari, mʉja ca ĩarijere, mʉja ca tʉorijere, Juan're wede dooya. ");
INSERT INTO baoNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ca ĩatirã ĩama; upa yuriri cãa waa majima; ca cami boamiricarã cʉ̃ja diariquere ametʉene ecoma; ca tʉotirã cãa tʉocoama; ca bii yairicarã cãa cati tuama; ñucã ca boo pacarã cãa, añurije quetire wede ecoma. ");
INSERT INTO baoNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Ʉjea niiña, yʉ yee jʉori ca tʉgoeña maa wijiatigʉa! Cʉ̃re ĩi wede dooya —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Juan buerã cʉ̃ja ca waaro jiro, Juan yee maquẽre bojocare o biro ĩi wede jʉo waawi Jesús: —¿Ñeere ĩarã waarã, ca yucʉ maniri yepapʉ mʉja waari? ¿Jĩcã wãjo wino ca paa puurije mena ca yugui nucũri wãjore ĩarã waarã mʉja biiri? ");
INSERT INTO baoNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tee méére ĩarã mʉja ca biijata, ¿Ñeere ĩarã waarã mʉja biiri? ¿Jĩcʉ̃, añurije ca juti jãñagʉre ĩarã waarã mʉja waari? Mʉja maji. Bojoca añurije ca juti jãñarã, wiorã yaa wiijeripʉ niima. ");
INSERT INTO baoNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To docare ¿ñee peere ĩarã waarã mʉja waari? ¿Jĩcʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉre ĩarã waarã mʉja biiri? Cʉ̃ petire ĩarã waarã mʉja biijacupa. Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ ametʉenero ca niigʉre ĩarã mʉja biijacupa. ");
INSERT INTO baoNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ʉmʉreco Pacʉ wederiquepʉ: “Yʉ yee quetire wederi majʉre mʉ jʉguero cʉ̃re yʉ tiicojo, mʉre cʉ̃ maa queno yuejato ĩigʉ,” cʉ̃ja ca ĩi owaquĩricʉra niimi Juan. ");
INSERT INTO baoNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","”Yee méé mʉjare yʉ ĩi: Jĩcʉ̃ ʉnopeera ati yepapʉ ca baʉaricʉ, Uwo Coeri majʉ Juan ametʉenero ca nii majuropeegʉ maniupi. To ca bii pacaro, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉra watoa macʉ̃ ca niigʉra, Juan ametʉenero ca nii majuropeegʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Uwo Coeri majʉ Juan cʉ̃ ca niirica tabe mena, to biri mecʉ̃pʉ mena Ʉmʉreco Pacʉ cʉ̃ ca doti niirije, ñañaro ca tamʉorije watoara bii nʉnʉa waa. Teere ca tʉorʉgatirã, teere tii yaiorʉgamima. ");
INSERT INTO baoNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja niipetirã, to biri doti cũurique, cʉ̃ja ca wede jʉguerique Juan menara bii yapano eaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Yʉ ca ĩirijere díámacʉ̃ mʉja ca tʉorʉgajata, Juan, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ, “Elías doorucumi” cʉ̃ja ca ĩiricʉra niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ca amoperi cʉtirã tʉoya yʉ ca ĩirijere. ");
INSERT INTO baoNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","”¿Ñee mena ati cuu macãrã bojocare yʉ ĩi cõoñabogajati? Wimarã macã yepapʉ epe duwirã, cʉ̃ja mena macãrãre o biro ca ĩi acaro bui duwirãre biro niima: ");
INSERT INTO baoNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Tõrogare jãa putimijãwʉ, mʉja pea mʉja bajatijãwʉ; boori bajare jãa bajamijãwʉ, mʉja pea mʉja otitijãwʉ,” ca ĩi ameri acaro bui duwi yujurãre biro niima. ");
INSERT INTO baoNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan baati, ʉje ocore jiniti, ca biigʉ dooupi. Teerena cʉ̃ja pea “Ca wãtĩ jãa ecoricʉ niimi,” cʉ̃re ĩima. ");
INSERT INTO baoNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jiro yʉ, Ca Nii Majuropeegʉ Macʉ̃, baa, jini ca tiigʉ yʉ doowʉ. Teerena cʉ̃ja pea, “Ca baa pacagʉ, ca cũmu paigʉ, ñañarã mena macʉ̃, ñucã Roma maquẽre wapa jee bojari maja mena macʉ̃ niimi,” yʉre ĩima. Biiropʉa, Ʉmʉreco Pacʉ cʉ̃ ca majirijea tee ca tii niirije menapʉ bii bau nii ĩño —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","To cõrora Jesús, paʉ peti ca ĩa ñaaña manirije cʉ̃ ca tii bau nii ĩñorica macãri macãrã, teere ĩa pacarã tʉgoeña yeri wajoari, Ʉmʉreco Pacʉre cʉ̃ja ca tʉo nʉnʉjeetirije jʉori, o biro ĩi tuti jʉo waawi: ");
INSERT INTO baoNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Abé nija, Corazín, Betsaida ñañaro peti mʉja biirucu! Mʉja watoare, ca ĩa ñaaña manirije yʉ ca tii bau niiriquere Tiro, Sidón macãri macãrã peere yʉ ca tii bau nii ĩñojata, mee tĩrʉmʉpʉra ñañaro cʉ̃ja ca tiiriquere, ñañaro bii tʉgoeñarique pai, tʉgoeña yeri wajoa, biibojacupa. ");
INSERT INTO baoNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","“Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niiro, Tiro, Sidón macãrã ametʉenero ñañaro mʉja tamʉorucu,” mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Mʉja Capernaúm macãrã, ¿“Ʉmʉreco tutipʉ jãa ami mʉa waa ecorucu,” mʉja ĩi tʉgoeñati? “Ca ʉ̃cʉ̃ari opere ca ʉ̃cʉ̃a majuropeeri tabepʉ mʉja cõa duwio ecorucu. Mʉja watoare ca ĩa ñaaña manirije yʉ ca tii bau niiriquere, Sodoma macãrã peere tii bau nii ĩñorique to ca niijata, ati rʉmʉripʉ cãare niicãbocuma. ");
INSERT INTO baoNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niiro, Sodoma yepa macãrã ametʉenero, ñañaro mʉja tii ecorucu,” mʉjare yʉ ĩi —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Tii rʉmʉrire o biro ĩiwi Jesús: —Añuro mʉre yʉ ĩi nʉcʉ̃ bʉo Cáacʉ, ati ʉmʉreco, ati yepa Ʉpʉre, ca majirãre, ca tʉgoeña puorãre, mʉ ca yaioriquere watoa macãrã peere mʉ ĩño. ");
INSERT INTO baoNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ʉ̃gjá, Cáacʉ, o birora ca biiro mʉ boowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","”Yʉ Pacʉ, niipetirijepʉrena yʉre tiicojowi. Jĩcʉ̃ ʉno peera, cʉ̃ Macʉ̃ yʉ ca niirijere majitima. Yʉ Pacʉ wado majimi. Ñucã jĩcʉ̃ ʉno peera, yʉ Pacʉ cʉ̃ ca niirijere majitimi. Yʉ cʉ̃ Macʉ̃, to biri cʉ̃ Macʉ̃ yʉ ca boorã wadore cʉ̃ja ca majiro yʉ ca tiirã wado, majima. ");
INSERT INTO baoNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","”Yʉ mena pee dooya mʉja niipetirã, mʉja paderiquere juti, tʉgoeñarique pai, ca biirã. Yʉ, mʉja ca yerijãaro mʉjare yʉ tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yʉ ca dotirijere tii nʉnʉjee, yʉ ca biirique cʉtirijere ĩa cõo, tiiya. Yʉa, ca bojoca añugʉ, ca yeri pato wãcãtigʉ, yʉ nii. To biro biirã, mʉja ca cati niirijepʉ yerijãarique mʉja bʉarucu. ");
INSERT INTO baoNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yʉ ca dotirijea, yʉ ca biirore biro mʉjare yʉ ca bii dotirijea, popiye méé nii —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Tii rʉmʉrire Jesús, yerijãarica rʉmʉ ca niiro, oterique watoare waa nʉnʉa waawi. Jãa, cʉ̃ buerã pea queyama ĩirã, trigore tune jeeri jãa baawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Teere ĩari, fariseos pea o biro ĩiwa Jesús're: —Ĩaña. Mʉ buerã yerijãarica rʉmʉre ca tii dotitirijere tiima —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","To biro cʉ̃ja ca ĩiro, cʉ̃ pea o biro cʉ̃jare ĩi yʉʉwi: —¿Mʉja, jĩcãti David, cʉ̃ mena macãrã mena queyama ĩigʉ cʉ̃ ca tiiriquere mʉja bue ñaatiti? ");
INSERT INTO baoNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ʉmʉreco Pacʉ yaa wiipʉ jãa waari, Ʉmʉreco Pacʉ yee cʉ̃ja ca jee dica woorique pan're, cʉ̃, cʉ̃ mena macãrã cãa, cʉ̃ja ca baatipe ʉnorena, paia wado cʉ̃ja ca baarijerena baaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ñucã Moisés cʉ̃ ca doti cũurique, “Paia ñañarije tiirã méé tiima, Ʉmʉreco Pacʉ yaa wiipʉre, yerijãarica rʉmʉrena cʉ̃ja ca yerijãaticãjata cãare,” ¿Ca ĩirijere mʉja bue ñaatiti? ");
INSERT INTO baoNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","“Anora Ʉmʉreco Pacʉ yaa wii ametʉenero ca nii majuropeegʉ yʉ nii,” mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ate: “Mʉjare yʉ ca boo jãarijea, ca ĩa mairã mʉja ca niipe pee nii, waibʉcʉrã jĩari mʉja ca joe mʉenerucurijere yʉ booti,” ca ĩirijere mʉja ca tʉo puocãjata, ñañarije ca tiitirãrena, ñañaro mʉja tiitibocu. ");
INSERT INTO baoNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","To biri yʉ, Ca Nii Majuropeegʉ Macʉ̃a, yerijãarica rʉmʉre ca doti majigʉ yʉ nii —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","To ca niiricʉ waagʉ, tii tabe macã wii, nea poo juu buerica wiipʉ jãa waawi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tii wiipʉre niiupi jĩcʉ̃, ca amo bʉʉricʉ. “¡Do biro cʉ̃ ca tiiro cʉ̃re mani wedejãarãti!” ca ĩi niirã niiri, o biro cʉ̃re ĩi jãiñawa Jesús're: —¿Judíos cʉ̃ja ca yerijãari rʉmʉrena ca diarique cʉtirãre to catio doticãti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —¿Nii mʉja mena macʉ̃, jĩcʉ̃ oveja ca cʉogʉ, cʉ̃ yʉʉ oveja yerijãarica rʉmʉrena opepʉ cʉ̃ ca ñaajãacoaro, jĩcãtora waari, cʉ̃re cʉ̃ ami mʉenetiti? ");
INSERT INTO baoNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bojocʉ pee doca oveja ametʉenero wapa cʉtimi. To biri yerijãarica rʉmʉrire añurijere tii doti —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","To biro ĩi, ca amo bʉʉricʉre o biro cʉ̃re ĩiwi: —Mʉ amore juu pooya —ĩiwi. To biro cʉ̃ ca ĩiro, cʉ̃ pea cʉ̃ amore cʉ̃ ca juu poorora, ape amore biro añuri amo tuawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","To biro cʉ̃ ca tiiro ĩarã, fariseos pea witi waari, Jesús're cʉ̃ja ca jĩapere ameri wede peni jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","To biro cʉ̃ja ca ĩi niirijere majiri, Jesús pea too ca niiricʉ waacoawi. Paʉ bojoca cʉ̃re nʉnʉ waa, cʉ̃ pea ca diarique cʉtirã niipetirãre catiori, ");
INSERT INTO baoNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","cʉ̃ yee maquẽre “Paʉ cʉ̃ja ca tʉoropʉ wedeticãña,” cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ate pea Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías, o biro cʉ̃ ca ĩiquĩrique cʉ̃ ca ĩiricarore biro to biijato ĩiro biiwʉ: ");
INSERT INTO baoNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ani niimi yʉre pade bojari majʉ, yʉ ca beje amiricʉ, yʉ ca maigʉ, cʉ̃ ca tii niirijere yʉ ca ĩa ʉjea niigʉ. Yʉ Yerire cʉ̃re yʉ tiicojorucu. Cʉ̃ pea bojoca poogaari niipetirãpʉre añurije quetire wederucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ameri tuti, acaro bui, ĩitirucumi. Jĩcʉ̃ ʉno peera wiijeri watoa macã maaripʉ cʉ̃ ca wederijere tʉotirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ca tʉgoeña bayitirãre, ñucã wãma ca tʉo maji jʉo doorã cãare, “To birora cʉ̃ja biicãjato,” ĩitirucumi. Añurije pee wado ca bii ametʉa nʉcãropʉ tii nemo yerijãarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Bojoca poogaari cõrora, ‘Cʉ̃ ca ĩirore biro manire tii nemorucumi,’ ĩi yue niirucuma,” cʉ̃ ca ĩirique. ");
INSERT INTO baoNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Jĩcʉ̃ ʉmʉ ĩati, wedeti, ca biigʉ ca wãtĩ jãa ecoricʉre Jesús pʉto cʉ̃re ami dooupa. Jesús pea, cʉ̃ ca ĩaro tii, cʉ̃ ca wedero tii, cʉ̃re tii catiowi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","To biro cʉ̃ ca tiiro, niipetirã bojoca do biro pee ĩi majiticã, o biro ĩiwa: —¿Ania, David Pãramira cʉ̃ niigajati? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","To biro cʉ̃ja ca ĩirijere tʉori, fariseos pea o biro ĩiwa: —Ania Beelzebú, wãtĩa wiogʉ majuropeera cʉ̃ ca yeri tutuarijere cʉ̃ ca tiicojoricʉ niiri, wãtĩare cõa wiene majimi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús pea to biirije cʉ̃ja ca ĩi tʉgoeñarijere ca majicãgʉ niiri, o biro cʉ̃jare ĩiwi: —Jĩcã yepa macãrãra cʉ̃ja majuropeera camotaticãri cʉ̃ja ca ameri ĩa juna niijata, cʉ̃ja majuropeera ameri jĩa peticã yai waacuma. Ñucã jĩcã macã macãrãra, jĩcã wii macãrãra, cʉ̃ja ca ameri ĩa juna niijata, añuro nii majiticuma. ");
INSERT INTO baoNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","To birora Satanás cãa, Satanás'rena cʉ̃ ca cõa wienecãjata, cʉ̃ majuropeera camotatigʉ tiimi. ¿To biro cʉ̃ ca tiijata, do biro pee tiicãri, to birora cʉ̃ doti tutuacõa nii majibogajati? ");
INSERT INTO baoNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Mʉja, Beelzebú cʉ̃ ca yeri tutuarije mena wãtĩare cõa wienemi,” yʉre mʉja ĩi. To biro to ca biijata, mʉja ca buerijere ca tʉo nʉnʉjeerã peera, ¿ñiru cʉ̃ tiicojoti, wãtĩare cʉ̃ja ca cõa wiene tutua majipere? To biri cʉ̃jara bii ĩñocãma, no ca boorora mʉja ca ĩi maa wijiarijere. ");
INSERT INTO baoNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ʉmʉreco Pacʉ yʉʉ Añuri Yeri jʉori, wãtĩare yʉ ca cõa wienejata, “Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe mʉjapʉre ea yerijãa,” ĩirʉgaro bii. ");
INSERT INTO baoNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","¿Jĩcʉ̃ ʉno, jĩcʉ̃ ca tutuagʉre cʉ̃ ca jia dopo jʉotijata, do biro tiicãri cʉ̃ yaa wiire jãa waari, cʉ̃ yeere cʉ̃ jee duti majibogajati? Cʉ̃re jia dopocã jʉoripʉ doca, cʉ̃ yeere jee duti majibocumi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yʉ mena ca niitigʉa, yʉre ca junagʉ niimi. Yʉ mena ca jee neotigʉa, no ca boorora ca dee batecãgʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","To biri mʉjare yʉ ĩi: Ʉmʉreco Pacʉ, bojoca ñañarije cʉ̃ja ca tiirije niipetirore, ñañarije cʉ̃ja ca ĩirije niipetirore, acoborucumi. Añuri Yerire ñañaro ca ĩi tutigʉ docare, acobotirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","No ca boogʉ, yʉ, Ca Nii Majuropeegʉ Macʉ̃re, ñañarije cʉ̃ ca ĩimijata cãare, to biro cʉ̃ ca ĩiriquere acobocãrucumi Ʉmʉreco Pacʉ. Añuri Yerire ñañarije ca ĩi tutigʉ docare, ati cuu cãare, to biri ati yepare cʉ̃ ca wajoaro jiro macã cuupʉ cãare, to biro cʉ̃ ca ĩiriquere acobotirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","”Yucʉgʉ añuricʉ to ca niijata, añurije dica cʉtirucu. Ñañaricʉ to ca niijata, ñañarije dica cʉtirucu. Yucʉre ca dica mena ĩa majirique nii. ");
INSERT INTO baoNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Añaa punaa! Mʉjapʉra ñañarã niicã pacarã, ¿do biro pee biicãri, añurije mʉja ĩibogajati? Yeripʉ ñañarije tʉgoeñariquerena wede, ʉjero. ");
INSERT INTO baoNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Bojocʉ ca añugʉ, añurije wedemi, cʉ̃ yeripʉre añurije ca niiro macã. Ñañagʉ cãa, ñañarije wedemi, cʉ̃ yeripʉre ñañarije ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","To biri o biro mʉjare yʉ ĩi: Ʉmʉreco Pacʉ bojocare cʉ̃ ca ĩa bejeri rʉmʉ ca earo, niipetirãpʉra no ca boorije docuorije cʉ̃ja ca ĩirica wãmeri cõrorena cʉ̃re wederucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Mʉja ca wederije jʉorira, “Ca ñañarije manirã,” ĩi eco, tee jʉorira ñañaro tii eco, mʉja biirucu —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","To biro cʉ̃ ca ĩiro, jĩcãrã fariseos, to biri doti cũuriquere ca jʉo buerã mena macãrã, o biro ĩiwa Jesús're: —Buegʉ, jĩcã wãme, ca bii ĩñori wãme mʉ ca tii bau niirijere jãa ĩarʉga —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","To biro cʉ̃ja ca ĩiro o biro cʉ̃jare ĩi yʉʉwi Jesús: —Anija bojoca ñañarã Ʉmʉreco Pacʉre ca tʉo nʉnʉjeetirã, jĩcã wãme ca ĩa ñaaña manirije tii bau niiriquere jãima. To biro cʉ̃ja ca ĩimijata cãare, jĩcã wãme ʉno peera, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Jonás cʉ̃ ca biirique ametʉeneropʉra, ca ĩa ñaaña manirije tii bau nii ĩño ecotirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás itia rʉmʉ, itia ñami, wai paigʉ paa totipʉ cʉ̃ ca jãñaricarore birora yʉ, ca Nii Majuropeegʉ Macʉ̃ cãa, yʉre cʉ̃ja ca yaa cõaro ca bii yairã cʉ̃ja ca niiri tabepʉre itia rʉmʉ, itia ñami niiri jiro yʉ cati tuacoarucu ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nínive macãrã, ati cuu macãrãre Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niiro cati tuari, ñañaro mʉjare tiirucuma. Nínive macãrã, Jonás cʉ̃ ca wederijere tʉo, ñañaro cʉ̃ja ca tiiriquere tʉgoeña yeri wajoari, Ʉmʉreco Pacʉ peere tʉo nʉnʉjeeupa. Ano ca niigʉ pea, Jonás ametʉenero ca niigʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ñucã jõcʉ̃ jiro macã yepa macõ ʉpo niiquĩrico cãa, ati cuu macãrãre cʉ̃ ca ĩa bejeri rʉmʉ ca niiro cati tuari, ñañaro mʉjare tiirucumo. Cõa, ca yoaropʉ macõra dooupo, Salomón cʉ̃ ca majirijere tʉorʉgo. Ano ca niigʉ pea, Salomón ametʉenero ca majigʉ yʉ ca niimijata cãare, yʉre mʉja tʉo juna. ");
INSERT INTO baoNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","”Jĩcʉ̃ wãtĩ bojocʉpʉre ca niiricʉ witi waari jiro, ca bopori yeparipʉ waa yujucumi, cʉ̃ ca yerijãa niipa tabere ama yujugʉ. Cʉ̃ ca bʉatijata, o biro ĩi tʉgoeñacumi: ");
INSERT INTO baoNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“¡Agó nija! Yʉ yaa wii, yʉ ca witi weorica wiipʉra yʉ tua waarucu ñucã,” ĩicumi. Tua eagʉ, ca bojoca maniri wiire añuro woa batecã, añuro quenocã, tiirica wiire biro cʉ̃re ĩacumi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","To biri waa, aperã wãtĩa, cʉ̃ ametʉenero ñañarã petire jĩcã amo peti, ape amore pʉaga penituaro ca niirã peti cʉ̃jare jʉo neo, cʉ̃ja mena jĩcãri cʉ̃pʉre niirã jãa waacuma. To biri jʉguero cʉ̃ ca biiricaro ametʉeneropʉ ñañaro tamʉocumi. O biri wãmera cʉ̃jare biirucu, anija bojoca ñañarãre —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ména Jesús bojocare to biro cʉ̃ ca ĩi wede niirora, cʉ̃ paco, cʉ̃ bairã, cʉ̃ mena wede penirʉgarã dooupa. Macãpʉra cʉ̃ja ca tua nʉcãro macã, ");
INSERT INTO baoNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","jĩcʉ̃ Jesús're o biro ĩi wedewi: —Mʉ paco, mʉ bairã, mʉ mena wede penirʉgarã, õo macãpʉ yue nucũjãwa —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","To biro cʉ̃ ca ĩiro, Jesús pea cʉ̃re ca wedegʉ eagʉre o biro cʉ̃re ĩi yʉʉwi: —¿Ñiruo cõ niiti yʉ paco? ¿Noa cʉ̃ja niiti yʉ bairã? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","To biro ĩi, jãa, cʉ̃ buerã peere juu pua cojori, o biro ĩiwi: —Yʉ paco, yʉ bairã, anija niima. ");
INSERT INTO baoNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","No ca boorã, yʉ Pacʉ, ʉmʉreco tutipʉ ca niigʉ cʉ̃ ca boorore biro ca tiirã niima, yʉ bai, yʉ baio, yʉ paco, ca niirã —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tii rʉmʉrena Jesús, wiipʉ ca niiricʉ witi waa, ʉtabʉcʉra tʉjaropʉ ea nuu eawi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Paʉ bojoca cʉ̃re cʉ̃ja ca nea pooro macã, Jesús pea cũmuapʉ ea jãa, ea nuu waawi, bojoca pea jita dupari yepapʉra cʉ̃ja ca tua nʉcãro ʉno. ");
INSERT INTO baoNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Toopʉ niicãri, paʉ wãmeri ĩi cõoñarique mena cʉ̃jare wede jʉo waawi. O biro ĩiwi: —Jĩcʉ̃ oteri majʉ otegʉ waaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Cʉ̃ otere cʉ̃ ca dee bate ote nʉnʉa waaro, ote ape jĩcãgaari maapʉ ñaaupe. To biro ca biirijere minia eari, baacãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Apeye ʉ̃tã watoa ca jita mani jañuropʉ ñaaupe. Tee oterique yoari méé wiicoaupe. Ca jita ʉje meniroacã ca niiro macã, ");
INSERT INTO baoNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","muipũ aji mʉa doogʉra, teere aji jĩa batecãupʉ. Nʉcõri manima ĩiro jinicoaupe. ");
INSERT INTO baoNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Apeye oterique pota watoapʉ ñaaupe. Pota yucʉ pee teere bʉcʉa ametʉene, wii bʉato yaiocãupe. ");
INSERT INTO baoNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Apeye oterique pea añuri jitapʉ ñaaupe. Tee pea añurije wii, bʉcʉa, añurije dica cʉtiupe. To biri jĩcã jati cien'gaari dica cʉtiupe. Ape jati setenta, ape jati treinta, dica cʉtiupe. ");
INSERT INTO baoNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ca amoperi cʉtirã tʉoya yʉ ca ĩirijere —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jiro jãa, cʉ̃ buerã pea Jesús pʉto pee waa: —¿Ñee tiigʉ bojocare ĩi cõoñarique mena cʉ̃jare mʉ wedeti? —jãa ĩi jãiñawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","To biro jãa ca ĩiro, o biro jãare ĩi yʉʉwi Jesús: —Mʉjara, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ ca majiña manirije ca niimiriquere, mʉja ca majiro mʉjare tiimi. Cʉ̃ja peera to biro tiitimi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","To biri yʉ yee quetire aperãre ca wede majiogʉra, bʉaro jañuro tʉo majirique cʉ̃re tiicojorique niirucu. To biri majiriquere pairo cʉorucumi. To biro ca tiitigʉra, petoacã cʉ̃ ca tʉo majimirique menapʉra ẽmacãrique niirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","To biri ĩi cõoñarique mena cʉ̃jare yʉ wede. Ca ĩacãrã nii pacarã, ca ĩatirãre biro biima. Ñucã ca tʉocãrã nii pacarã, ca tʉotirãre biro tʉo majiti biicãma. ");
INSERT INTO baoNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","O biro cʉ̃ja ca biirije, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías niiquĩricʉ o biro cʉ̃ ca ĩiquĩricarore biro biiro bii: ” “Bʉaro ca tʉocãrã nii pacarã, tʉo puotirucuma. Bʉaro ca ĩacãrã nii pacarã, ĩa majitirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ati pooga macãrã, cʉ̃ja yeripʉra ca tʉo nʉnʉjeerʉgatirã jeeñacã yai waama. Cʉ̃ja amoperi tiarique cʉocãma. Cʉ̃ja capegaari cãa biarique niicã, to biro cʉ̃ja ca biitijata, cʉ̃ja cape mena ĩa, cʉ̃ja amoperi mena tʉo, cʉ̃ja ca cati niirijepʉ teere tʉo puo, tʉgoeña yeri wajoa, biibocuma, yʉ pea cʉ̃jare yʉ catiobocu. ");
INSERT INTO baoNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","”Mʉja, mʉja ca ĩarije cape cʉti, mʉja ca tʉorije amoperi cʉti, ca biirã pea, ʉjea niiña. ");
INSERT INTO baoNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Yee méé mʉjare yʉ ĩi. Paʉ Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, ca bojoca añurã, mʉja ca ĩarijere ĩarʉga, mʉja ca tʉorijere tʉorʉga, biimiupa. To biro bii pacarã tʉoti, ĩati, biiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","”Tʉoya. Oteri majʉre ĩi cõoñari yʉ ca wedejãrije o biro ĩirʉgaro ĩi: ");
INSERT INTO baoNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ quetire tʉo pacarã, ca tʉo puotirã, oterique maapʉre ca ñaariquere biro niima. Ʉmʉreco Pacʉ wederiquere cʉ̃ja yeripʉ añuro cʉ̃ja ca tʉo ñeemiriqueacãre, Satanás doori, cʉ̃jare ẽmacãmi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Oterique ʉ̃tã watoapʉ ca ñaarique pea, añurije quetire tʉorã, jĩcãtora ʉjea niirique mena ca tʉo ñeerã niima. ");
INSERT INTO baoNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Oterique ca nʉcõri mani jañuricarore birora, cʉ̃ja cãa tʉgoeña tutuatima. Añurije queti jʉori ñañaro cʉ̃jare ca biirora, ñucã aperã ñañaro cʉ̃jare cʉ̃ja ca tiirʉga nʉnʉjeero uwima ĩirãra, to cõrora teere camotaticãma. ");
INSERT INTO baoNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Oterique pota watoapʉ ca ñaarique pea, añurije quetire añuro tʉo nʉnʉjee pacarã, ati yepa maquẽ peere bʉaro boo tʉgoeña, ñucã pairo apeye cʉtirique peere boo ametʉene biima ĩirã, pota watoapʉ ca ñaariquere, ca dica manirora ca wii biato yaio ecoriquere birora biicãma. To biri ate niipetirije cʉ̃ja ca boo tʉgoeñarije pee nii ametʉenema ĩiro, añurije queti peera, cʉ̃ ca otemiriquere ca dica manirora ca wii bʉato yaioricarore biro cʉ̃jare tii yaiocã. ");
INSERT INTO baoNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Oterique añuri jitapʉ ca ñaarique pea, añuro dica cʉti, jĩcã jati cien, sesenta, treinta apegaari ca dica cʉtiricarore birora biima, añurije quetire tʉori, añuro ca tʉo nʉnʉjeerã —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ape wãme ĩi cõoñari wedewi ñucã Jesús: —Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃ cʉ̃ yaa wejepʉre ote añurije ca otericʉre biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","To biro cʉ̃ ca tiimiriquere jĩcʉ̃ cʉ̃re ca ĩa tutigʉ, niipetirã cʉ̃ja ca cãni ditoye eari, trigo watoapʉre taa ñañarijere ote, waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Jiro, trigo cʉ̃ ca oterique wii, bʉcʉa yapano, oo yucʉ nʉcã, ca biiri tabera, taa ñañarije cãa tee watoare wiiupe. ");
INSERT INTO baoNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","To biro ca biiro, paderi maja pea tii weje ʉpʉre o biro cʉ̃re ĩirã waauparã: “¡Wiogʉ! Mʉ yaa wejere añurije mʉ ca oterique nii pacaro, ¿do biro biicãri, taa ñañarije cãa to wiijapari?” cʉ̃re ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","”To biro cʉ̃ja ca ĩiro, tii weje ʉpʉ pea o biro cʉ̃jare ĩiupʉ: “Jĩcʉ̃ yʉre ca ĩa tutigʉ to biro tiijacupi,” ĩiupʉ. ”To biro cʉ̃ ca ĩiro, paderi maja pea o biro cʉ̃re ĩi jãiñauparã: “¿Waari, taa ñañarijere jãa ca wẽe batecãro mʉ booti?” ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","”To biro cʉ̃ja ca ĩiro, cʉ̃ pea o biro cʉ̃jare ĩiupʉ: “Waaticãña. Taa ñañarijere wẽe batema ĩirã, trigo menara mʉja wẽe batecãbocu. ");
INSERT INTO baoNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Tee menara jĩcãri to bʉcʉacãjato. Ca dicare jeerica tabepʉ trigore ca jeerãre: “ ‘Taa ñañarije peere jee jʉori, upa dotori jiaya, teere joe baterʉgarã. To biro tii yapanoripʉ trigore jeeri, yʉ yaa wii baarique queno cũurica wiipʉ queno cũuña,’ cʉ̃jare yʉ ĩirucu,” cʉ̃jare ĩiupʉ tii weje ʉpʉ —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ape wãme ĩi cõoñari wedewi ñucã Jesús. —Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃ cʉ̃ wejepʉre mostaza apegaacãre cʉ̃ ca otericarore biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Niipetirije ote apegaari ametʉenero petigaacã peti nii pacaro, bʉcʉa waaropʉa, ote, wejepʉre ca niiri yucʉ ametʉenero pairicʉ bʉcʉa. To biri minia tiigʉ dʉpʉripʉre cʉ̃ja die batiri queno, cʉ̃ja ca tii niirore birora bii —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ati wãme ĩi cõoñari wedewi ñucã Jesús: —Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcõ nomio trigo wetare itia bapa cõori, niipetiri bʉrʉapʉra to waua peticoajato ĩigo, ca wauaro ca tiirijere cõ ca ayiarore biro bii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ate niipetirore ĩi cõoñarique mena wado ĩiri wedewi Jesús, bojocare. Dije ʉno peerena, ĩi cõoñatigʉra cʉ̃jare wede, tiitiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ate pea Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ: “Ĩi cõoñarique mena wado yʉ wederucu. Ʉmʉreco Pacʉ, ati ʉmʉrecore cʉ̃ ca jeeño jʉori tabepʉra ca majiña manirije ca niiriquere cʉ̃jare yʉ wederucu,” cʉ̃ ca ĩi jʉguericarore biro bii earo biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jiro Jesús bojocare waarique wui yapano, waa, wiipʉ jãa waawi. To biro cʉ̃ ca biiro, jãa, cʉ̃ buerã pea cʉ̃ pʉto waari, o biro cʉ̃re jãa ĩi jãiñawʉ: —Jãare wedeya, do biro ĩirʉgaro to ĩiti, taa ñañarije wejepʉre ca wiiriquere ĩi cõoñari mʉ ca wedejãrije —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","To biro jãa ca ĩiro, o biro jãare ĩi wedewi Jesús: —Ote añurijere ca otegʉa, yʉ Ca Nii Majuropeegʉ Macʉ̃ yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Oterica yepa pea, ati ʉmʉreco nii. Ote añurije pea Ʉmʉreco Pacʉ yaarãre ĩiro ĩi; taa ñañarije pea Satanás yaarãre ĩiro ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ca ĩa tutigʉ taa ñañarijere ca otericʉ pea Satanás niimi. Ote dicare jeerique pea, ati ʉmʉreco ca peti peere ĩiro bii. Ca dicare ca jeerã pea, Ʉmʉreco Pacʉre pade bojari maja niima. ");
INSERT INTO baoNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","”To biri taa ñañarijere jeeri, pecamepʉ joe batericarore birora biirucu, ati ʉmʉreco ca petiro. ");
INSERT INTO baoNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca doti niiri yepare ñañarije tii, aperãre ñañaro cʉ̃ja ca tiiro tii, ca tii niirã niipetirãre, yʉ jee neo doti cojorucu, yʉre ca pade bojari majare. ");
INSERT INTO baoNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Cʉ̃jare jee neo yapano, pecame ca ʉ̃ʉ yatitiri pecamepʉ cõa joerucuma, cʉ̃ja upire baca dʉpo tuu, oti, cʉ̃ja ca biipa tabepʉre. ");
INSERT INTO baoNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","To biro cʉ̃ja ca biiri tabere, ca ñañarije manirã pea, muipũ ʉmʉreco macʉ̃re biro boe bate niirucuma, cʉ̃ja Pacʉ cʉ̃ ca doti niiri tabepʉre. Ca amoperi cʉtirã tʉoya yʉ ca ĩirijere. ");
INSERT INTO baoNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","”Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, ca wapa pacarijere jĩcã yepapʉ yaio cũuricarore biro nii. Jĩcʉ̃ ʉmʉ teere bʉa, ñucã toora teere yaio cũu, bʉaro ʉjea niirique mena waa, cʉ̃ yee apeye niipetirijere noni peticã, tee wapa mena tii yepare wapa tii ami, cʉ̃ ca tiirore birora bii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","”Ñucã Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃, apeye noniri majʉ, perlas añurijere ca ama yujugʉre biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","To biri jĩcãga bʉaro ca wapa pacaricare bʉari, waa, cʉ̃ yee apeye niipetirijere noni peticã, tee wapa mena tiigare wapa tii ami, cʉ̃ ca tiirore birora bii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","”Ñucã Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcãgʉ bapigʉre dia pairi yaapʉre cõañua cojoricaro, wai cʉ̃ja ca niiro cõrora cʉ̃ja ca yoorore biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Bapigʉre wai cʉ̃ja ca jãa dadaro ĩa, wai jĩari maja pea, jita dupari yepa pee wee maa waa, añurãre piwʉpʉ jee jãa, ñañarã peera cõañuacã, cʉ̃ja ca tii duwirore biro bii. ");
INSERT INTO baoNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","O biri wãmera biirucu, ati ʉmʉreco ca petiro. Ʉmʉreco Pacʉ pʉto macãrã, niipetiri taberipʉ waari, añurã watoare bojoca ñañarãre bojoricaro cʉ̃jare jee dica woorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ñañarãra pecame ca ʉ̃ʉ yatitiri pecamepʉ cʉ̃jare cõa joerucuma. Bʉaro oti, cʉ̃ja upire baca dʉpo tuu, cʉ̃ja ca biiparopʉre —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","To biro ĩi yapano, o biro ĩi jãiñawi Jesús: —¿Ano yʉ ca ĩirije niipetirijere mʉja tʉo puoti? —ĩiwi. To biro cʉ̃ ca ĩiro, “Ʉ̃gjá Wiogʉ,” jãa ĩi yʉʉwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","To biro jãa ca ĩiro, o biro jãare ĩiwi Jesús: —Jĩcʉ̃, doti cũuriquere ca jʉo buegʉ, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre cʉ̃ ca buejata, wii ʉpʉre biro biimi. Cʉ̃ yaa wii maquẽ cʉ̃ ca queno cũurije wãmare, to biri bʉcʉre, jee wiene majimi —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesús atere ĩi cõoña wede yapano, too ca niiricʉ waacoawi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Cʉ̃ yaa yepa majuropeepʉre eagʉ, cʉ̃ja yaa wii cʉ̃ja ca nea poo juu bueri wiipʉ waari, bojocare bue jʉo waawi. Too macãrã pea teere tʉo, do biro pee ĩi majitima ĩirã: —¿Ania, ate niipetirije cʉ̃ ca majirijera, noopʉ cʉ̃ buejapari? ¿Do biro biicãri, ca ĩa ñaaña manirije tii bau nii majirique cãare cʉ̃ tii majiti? ");
INSERT INTO baoNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Ania, yucʉ pĩiri paderi majʉ José macʉ̃, ñucã María macʉ̃ méé cʉ̃ niiti? ¿Santiago, José, Simón, Judas jãari jũwʉ méé cʉ̃ niiti? ");
INSERT INTO baoNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Ñucã ano mani watoa ca niirã cãa, cʉ̃ bairã romiri méé cʉ̃ja niiti? ¿Ate niipetirije cʉ̃ ca majirijere noopʉ cʉ̃ bʉajapari? —ameri ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","To biirije cʉ̃re ca ĩirã niiri, cʉ̃ ca wederijere tʉo nʉnʉjeerʉgatiwa. To biro cʉ̃ja ca biiro ĩari, Jesús pea o biro cʉ̃jare ĩiwi: —Jĩcʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉre niipetiri taberipʉre cʉ̃re nʉcʉ̃ bʉoma. Cʉ̃ yaa macã majurope macãrã, cʉ̃ yaa wii macãrã majurope pea, cʉ̃re nʉcʉ̃ bʉotima —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","To biri cʉ̃ ca wederijere díámacʉ̃ cʉ̃re cʉ̃ja ca tʉo nʉnʉjeetiro macã, tii macãre niigʉ ca ĩa ñaaña manirijere paʉ tii bau niitiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Tii rʉmʉrira Galilea yepa wiogʉ Herodes, Jesús cʉ̃ ca tiirijere cʉ̃ja ca wedero tʉori, ");
INSERT INTO baoNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","cʉ̃re ca pade coterãre o biro ĩiupi: —Cʉ̃a, Uwo Coeri majʉ Juan niiquĩricʉ, ca cati tuaricʉ niicumi. To biri ca ĩa ñaaña manirije tii bau nii majiriquere cʉocumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodes pea, cʉ̃ bai Felipe nʉmo Herodías jʉori, Juan're ñee dotiri, come daa mena jiari, tia cũurica wiipʉ cʉ̃re cũu dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Ména, Juan pea to biro cʉ̃ tiijato ĩigʉ: “Cõre nʉmo cʉtigʉ, doti cũurique ca tii dotitirijere mʉ tii,” ĩiupi Herodes're. ");
INSERT INTO baoNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herodes pea Juan're jĩarʉga nii pacagʉ, bojoca peere uwiupi, niipetirã “Juan Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉra niimi,” cʉ̃ja ca ĩi nʉcʉ̃ bʉogʉ cʉ̃ ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","To ca bii pacaro, Herodes cʉ̃ ca baʉarica rʉmʉ ʉno ca earo cʉ̃ ca tiiri boje rʉmʉre, Herodías macõ pea niipetirã Herodes cʉ̃ ca jʉo cojoricarã cʉ̃ja ca ĩa cojoropʉ bajago wia waaupo. Herodes pea cõ ca bajarijere ĩa mecʉ̃ma ĩigʉ, o biro cõre ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","“No ca boorije mʉ ca jãirijere mʉre yʉ tiicojo majuropeecãrucu. ¡Yee méé mʉre yʉ ĩi!” cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Cõ pea cõ paco cõ ca wede majiorico niiri, o biro ĩiupo Herodes're: —Jotʉ bapapʉ Juan dʉpʉgare jãari, yʉre tiicojoya —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","To biro cõ ca ĩiro tʉogʉ, bʉaro tʉgoeña paiupi Herodes. Bʉari, niipetirã cʉ̃ ca jʉo cojoricarã cʉ̃ja tʉo cojoropʉ: “Mʉ ca jãirijere yʉ tiicojo majuropeecãrucu,” cʉ̃ ca ĩirique ca niiro macã, cõ ca ĩirore biro tii dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","To biri cʉ̃ ʉmʉare tia cũurica wiipʉ ca niigʉ, Juan dʉpʉgare paa taa doti cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jiro jotʉ bapapʉ ami jãa ami waari, wãmore cõre tiicojoupa. Cõ pea, cõ pacopʉre tiicojoupo. ");
INSERT INTO baoNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","To biro cʉ̃re cʉ̃ja ca tiiriquere queti tʉo, cʉ̃ buerã ca niiricarã eari, cʉ̃ upʉri niiquĩriquere ami waa, yaa cõa yapanori jiro, Jesús're wederã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús pea teere cʉ̃ja ca queti wedero tʉori, too ca niiricʉ, jãa, cʉ̃ buerã mena cũmuapʉ ea jãa, jʉo waacoawi ca bojoca maniro pee. Toopʉ jãa ca waariquere majiri, tii macãri macãrã pea maapʉ jãare nʉnʉ waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","To biri Jesús ʉtabʉcʉra ape nʉñapʉ tĩa ea maa nʉcãgʉ, paʉ bojoca cʉ̃ja ca niiro ĩawi. Cʉ̃jare ĩa boo pacari, ca diarique cʉtirã cʉ̃ja ca jee waaricarãre cʉ̃jare catio bojawi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jãa, cʉ̃ buerã pea, naiocoaro ca biiro ĩarã Jesús pʉto pee waa, o biro cʉ̃re jãa ĩiwʉ: —Mee ñamica niicoa. Anoa ca bojoca maniropʉ nii. Bojocare, “Waarãja,” cʉ̃jare ĩiña. Macãpʉ waari, cʉ̃ja ca baapere cʉ̃ja wapa tiirã waajato —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","To biro jãa ca ĩiro, Jesús pea o biro jãare ĩi yʉʉwi: —Ñeere ĩirã waaticuma. Mʉjara cʉ̃jare baariquere ecaya —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","To biro cʉ̃ ca ĩiro, jãa pea: —Jãa, anora jĩcã amo cõro pan'gaariacã, wai pʉarãacã to cõrora jãa cʉo —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","To biro cʉ̃re jãa ca ĩiro tʉo: —Ano pee ami dooya —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ĩi yapano, bojocare taa yepapʉ cʉ̃jare duwi dotiwi. Duwi doti yapano, pan jĩcã amo cõro ca niiricarire, wai pʉarã mena jeeri, ʉmʉreco pee ĩa mʉene cojori, Ʉmʉreco Pacʉre: —¡Añu majuropeecã! Añurije jãare ĩa cõa peo bojaya —ĩi juu bue yapano, pan'gaarire pee batori, jãa cʉ̃ buerãre noniwi. Jãa pea bojocare jãa batowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","To biro jãa ca tiirijere, niipetirãpʉra baa yapi peticoawa. Jãa pea ca dʉjarijere jee neo, pʉa amo peti, dʉpore pʉaga penituaro niiri pijeeri peti jãa jee jãa dadowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Teere ca baaricarã pea jĩcã amo cõro mil ʉmʉa niiwa, nomia, wimarã cõoña maniro niirã. ");
INSERT INTO baoNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ate jiro Jesús, jãa, cʉ̃ buerãre cũmuapʉ ea jãa dotiwi, bojocare cʉ̃ ca waarique wui ditoye, cʉ̃ jʉguero ape nʉñapʉ cʉ̃ja tĩa waa yuecãjato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Bojocare waarique wui cojo yapano, ʉ̃tãgʉ jotoapʉ jĩcʉ̃ra juu buegʉ mʉacoaupi Jesús. Ména, ca naioro jiro jĩcʉ̃ra toora niicãupi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mee, jãa pea yoaropʉ jãa tʉjacã tĩa waawʉ. Wino bʉaro jãa ca waaro peera paa puu dooma ĩiro, jãa cũmuare uwioro, oco jabe cõa tuu niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","To biro jãa ca bii paja yujuro, ca boeparo jʉgueroacã jãa pʉto pee doo nʉnʉa doowi Jesús. “¡Níjá! Oco jotoara doocã nʉnʉa doowi.” ");
INSERT INTO baoNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Oco jotoara cʉ̃ ca doo nʉnʉa dooro ĩa ʉcʉacoari, bʉaro uwirique mena: —Wãtĩro doo béé —jãa ĩi acaro buicoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","To biro jãa ca ĩiro, Jesús pea o biro jãare ĩi cojowi: —Yerijãa waarãja. Yʉra yʉ nii. Uwiticãña —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","To biro cʉ̃ ca ĩiro, Pedro pea o biro ĩiwi Jesús're: —Wiogʉ, mʉra mʉ ca niijata, oco jotoara mʉ pʉtopʉ yʉre waa dotiya —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","To biro cʉ̃ ca ĩiro: —Dooya —cʉ̃re ĩiwi. To biro cʉ̃ ca ĩiro, Pedro, cũmuapʉ ca jãñaricʉ wãcã ñaa, oco jotoara Jesús cʉ̃ ca niiro díámacʉ̃ waacã nʉnʉa waawi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Too waa nʉnʉa waagʉ, wino bʉaro ca paa puuro ĩa uwima ĩigʉra, duacã nʉnʉa waawi. “Duacã yai waagʉ yʉ bii,” ĩima ĩigʉra, o biro ĩi acaro buiwi Pedro: —Wiogʉ, yʉre ñeegʉ dooya —ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","To biro cʉ̃ ca ĩirora, Jesús pea cʉ̃ amore juu cojo, cʉ̃re ñeeri, o biro cʉ̃re ĩiwi: —¡Petoacã peti yʉre mʉ tʉo nʉnʉjeecã! ¿Ñee tiigʉ, “Yʉre tii nemocãrucumi,” mʉ ĩi tʉgoeña bayitijãri? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Cũmuapʉ cʉ̃ja ca ea jãarora, wino paa puu yerijãacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","To cõrora, jãa, cũmuapʉ ca niirã pea: —Mʉa díámacʉ̃ra, Ʉmʉreco Pacʉ Macʉ̃ra mʉ nii —jãa ĩi nʉcʉ̃ bʉowʉ Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","To biro bii tĩa waa, Genesaret yepapʉre jãa eawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Toopʉ jãa ca earo, too macãrã pea Jesús're ĩa majiri, too cʉ̃ ca earo, too pʉtori macãrã niipetirãpʉre queti wede bate peoticã cojoupa. Niipetirã ca diarique cʉtirãre jeecãri, Jesús pʉto ");
INSERT INTO baoNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“Jãa cãare petopʉra, mʉ jutiro yapaacã ʉnorena, jãare padeña dotiya,” ĩi eawa. Niipetirã cʉ̃ jutirore ca padeñarã cõrora cati peticoawa. ");
INSERT INTO baoNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Jĩcãrã fariseos, to biri doti cũuriquere ca jʉo bueri maja, Jerusalén'pʉ ca dooricarã Jesús pʉto eari, o biro ĩi jãiñawa: ");
INSERT INTO baoNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ñee tiirã mʉ buerã pea mani ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo dooriquere cʉ̃ja tii nʉnʉjeetiti? ¿Ñee tiirã baarʉgarã jʉguero amo coeriquere cʉ̃ja tii nʉnʉjeetiti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","To biro cʉ̃ja ca ĩiro, Jesús pee cãa o biro cʉ̃jare ĩi jãiñawi: —¿Ñee tiirã mʉja cãa, mʉja ñicʉ̃a cʉ̃ja ca tii jʉo doorique peere tii nʉnʉjeerʉgarãra Ʉmʉreco Pacʉ cʉ̃ ca doti cũuriquere mʉja tii nʉnʉjeetiti? ");
INSERT INTO baoNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","O biro ĩiupi Ʉmʉreco Pacʉ: “Mʉ pacʉre, mʉ pacore nʉcʉ̃ bʉoya. Cʉ̃ pacʉre, cʉ̃ pacore ñañaro ca ĩigʉa, jĩa cõacãricʉ niirucumi,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","To biro cʉ̃ ca ĩi cũurique ca nii pacaro, mʉja pea o biro mʉja ĩirucu: “Jĩcʉ̃, cʉ̃ pacʉre, cʉ̃ pacore, ‘Yʉ yee niipetirije Ʉmʉreco Pacʉre yʉ ca nonijãrije wado nii. To biri mʉjare yʉ tii nemo majiti,’ ĩicã majimi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","To biirije ca ĩigʉa, cʉ̃ pacʉre, cʉ̃ pacore cʉ̃ ca tii nemorucuricarore biro tii nemo majitimi yua,” mʉja ĩi wederucu. O biirije ĩicãri, Ʉmʉreco Pacʉ cʉ̃ ca doti cũurique peere tee jãa ĩiri méé mʉja bii yaiocã, mʉja majuropeera mʉja ca ĩirije pee wadore tii nʉnʉjeema ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Watoara ca bii dito pairã! Díámacʉ̃ra ĩiquĩupi Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías, mʉja yee maquẽre ĩigʉ: ");
INSERT INTO baoNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","—“Anija, ʉjero ĩirique wado yʉre ĩi nʉcʉ̃ bʉoma. Cʉ̃ja yeri pea aperopʉ niicã. ");
INSERT INTO baoNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Yee petira yʉre ĩi nʉcʉ̃ bʉocãma. Cʉ̃ja ca buerijea, cʉ̃ja majuropeera cʉ̃ja ca tii doti niirije nii,” cʉ̃ ca ĩiquĩriquera —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","To biro cʉ̃jare ĩi yapano, bojocare jʉo cojori, o biro cʉ̃jare ĩiwi Jesús: —Atere tʉori añuro tʉo puoya: ");
INSERT INTO baoNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Baarique ʉjero pee ca jãa waarije méé bojocare ñañarã cʉ̃ja ca niiro tii. Cʉ̃ja ʉjero mena pee ñañarije cʉ̃ja ca wede wienerije pee nii, bojocare ñañarã cʉ̃ja ca niiro ca tiirije —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","To biro cʉ̃ ca ĩiro jãa cʉ̃ buerã pea cʉ̃ pʉto pee waari, o biro cʉ̃re jãa ĩi jãiñawʉ: —¿Mʉ ca ĩijãrijere tʉori, fariseos cʉ̃ja ca ajiacoajãrijere mʉ majiti? —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","To biro jãa ca ĩiro: —No ca boorije yʉ Pacʉ, ʉmʉreco tutipʉ ca niigʉ, cʉ̃ ca otetiriquea, niipetirijepʉra ca nʉcõri menapʉra wẽe bate ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","To birora cʉ̃jare ĩacãña. Ca ĩatirãre biro nii pacarã, aperã ca ĩatirãre ca jʉguerãre biro ca niirã niima cʉ̃ja. No jĩcʉ̃ ʉno ca ĩatigʉra, apĩ ca ĩatigʉre cʉ̃ ca jʉgue waajata, cʉ̃ja pʉarãpʉra opepʉ ñaajãacoarucuma —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","To biro cʉ̃ ca ĩiro jiro, Pedro pea: “Mʉ ca ĩi cõoña wedejãrijere jãare wede majioña,” ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","To biro cʉ̃ ca ĩiro, o biro ĩi yʉʉwi Jesús pea: —¿Mʉja cãa ména mʉja tʉo puoticãti? ");
INSERT INTO baoNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Ʉjero pee ca jãa waarije niipetiro ʉta miji daari pee waa, jiro witi baterʉgaro mʉja ĩi majititi? ");
INSERT INTO baoNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ʉjero pee ca witirije doca, bojocare ñañarã cʉ̃ja ca niiro ca tiirije nii, cʉ̃ja yeripʉ ñañarije tʉgoeñacãri cʉ̃ja ca wede wienerije niima ĩiro. ");
INSERT INTO baoNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bojoca cʉ̃ja yeripʉ ñañarijere tʉgoeñama. Jĩariquere, apĩ nʉmopʉre tii eperiquere, tiirica wãme cõro méépʉ ñee epericarã cʉti yai waariquere, jee dutiriquere, ĩi ditorique, aperãre acaro bui tutiriquere, ĩi wienema cʉ̃ja ʉjero mena. ");
INSERT INTO baoNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ate nii, bojocare ñañarã cʉ̃ja ca tuaro ca tiirije. Amo coetigʉra cʉ̃ ca baarijea bojocʉre ñañagʉ cʉ̃ ca niiro tiiti —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jiro, too ca niiricarã, Tiro, Sidón ca wãme cʉtiri yepa pee jãa waacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Toopʉ jãa ca earo, jĩcõ nomio tii yepa macõ cananea, Jesús pʉtore o biro ĩi acaro bui eawo: —Wiogʉ, David Pãrami, yʉre boo paca ĩaña. Yʉ macõ wãtĩ jãa ecocãri ñañaro peti tamʉomo —cʉ̃re ĩi eawo. ");
INSERT INTO baoNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","To biro cõ ca ĩi pacaro, Jesús pea cõre yʉʉtiwi. To biro cʉ̃ ca biiro ĩa, jãa, cʉ̃ buerã pea, cʉ̃ pʉtoacã waari, o biro cʉ̃re jãa ĩiwʉ: —Cõre tii nemocãña nija. Mani jiro acaro bui nʉnʉjee doomo —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","To biro jãa ca ĩiro tʉo, o biro ĩiwi Jesús: —Ʉmʉreco Pacʉa, Israel yaa pooga macãrã, oveja ca yairicarãre biro ca niirã wadore tii nemo dotigʉ yʉre tiicojowi —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","To biro cʉ̃ ca ĩi pacaro, nomio pea cʉ̃ jʉguero cõ ãjʉro jupeari mena ea nuuri: —Wiogʉ, yʉre tii nemoña —cʉ̃re ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús pea o biro cõre ĩi yʉʉwi: —Cʉ̃ puna cʉ̃ja ca baarije pan're ẽmari, yaia peere cʉ̃ ca ecajata, añuti —cõre ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwo cõ pea: —To birora bii biiropʉa, Wiogʉ. To biro to ca bii pacaro, yaia cãa, cʉ̃ja ʉparã cʉ̃ja baa baterijere baama —ĩiwo Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","To biro cõ ca ĩiro, o biro cõre ĩiwi Jesús: —¡Nomio, díámacʉ̃ peti mʉ tʉo nʉnʉjee majuropeecã! Mʉ ca boori wãmere birora to biijato —ĩiwi. To biro cõre cʉ̃ ca ĩirije menara, cõ macõ pea jĩcãto caticoaupo. ");
INSERT INTO baoNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Too ca niiricarã waa, Galilea ʉtabʉcʉra tʉjaropʉ jãa eawʉ. Jiro, buuro jotoapʉ maa waa, ea nuu waawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","To biro cʉ̃ ca biiro, paʉ bojoca cʉ̃re nea poo eawa. Cʉ̃ja yaarã ca diarique cʉtirã, upa yuriri, ca ĩatirã, ca dicari pojaricarã, ca wedetirã, to biri aperã paʉ ca diarique cʉtirãre, Jesús pʉto jee eawa. To biro cʉ̃ja ca tiirãre, Jesús pea cʉ̃jare catio bojawi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bojoca pea ca wedetimiricarã wede, ca dicari pojaricarã cãa añucoa, upa yuriri añuro waa majicoa, ñucã ca ĩatimiricarã cãa ĩacoa, cʉ̃ja ca biiro ĩarã, ñee pee ĩiticãwa. Teere ĩari, Israel Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉowa. ");
INSERT INTO baoNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jiro Jesús, jãa, cʉ̃ buerãre jʉo cojori, o biro jãare ĩiwi: —Anija bojocare bʉaro cʉ̃jare yʉ boo paca ĩa, mee itia rʉmʉ niicoa yʉ mena cʉ̃ja ca niiro. Baarique ʉno cʉotima. Baari méé ca biirãrena cʉ̃ja yaa wiijeripʉ yʉ tuenecojorʉgati. To biro yʉ ca tiijata, waa bayiti, maa decomacãrira dia ñaacoabocuma —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","To biro jãare cʉ̃ ca ĩiro, jãa pea o biro cʉ̃re jãa ĩiwʉ: —To cõro paʉ bojoca ca niirãre mani ca ecapere, ano ʉno ca bojoca maniropʉre ¿do biro pee tiicãri baariquere mani bʉarãti? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","To biro jãa ca ĩiro, o biro jãare ĩi jãiñawi Jesús: —¿Mʉja pea no cõro paʉ pan'gaari mʉja cʉoti? —ĩiwi. To biro cʉ̃ ca ĩiro: —Jĩcã amo peti, ape amore pʉaga penituaro niirije pan'gaari, to biri no cãnacãrã mééacã jãa wai cʉo —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","To biro jãa ca ĩiro, bojocare yepapʉ duwi doti cojowi. ");
INSERT INTO baoNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","To biro ĩi yapano, jĩcã amo peti, ape amore pʉaga penituaro ca niirije pan'gaari, to biri wai menare jeeri, Ʉmʉreco Pacʉre: “Añu majuropeecã,” ĩi yapano, pee bato noni cojowi, jãa cʉ̃ buerãre. Jãa pea bojoca peere jãa noni bato cojowʉ ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","To biro cʉ̃ ca tiirijere niipetirãpʉra baa yapi peticoawa. Ca dʉjariquere jãa ca jee neoro, jĩcã amo peti, ape amore pʉaga penituaro niiri pijeeri peti dadawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Teere ca baaricarã pea bapari mil peti ʉmʉa niiwa, nomia, wimarã, cõoña maniro niirã. ");
INSERT INTO baoNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jiro Jesús, bojocare waarique wui, cũmuapʉ ea jãa, jãa waacoawʉ, Magadán ca wãme cʉtiri yepa pee waarã. ");
INSERT INTO baoNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Fariseos, to biri saduceos, Jesús pʉto doori, cʉ̃re ĩi buiyee ñaarã, Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉra cʉ̃ ca niirijere ca bii ĩñorije jĩcã wãme ca ĩa ñaaña manirije cʉ̃re tii bau nii dotiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Ʉmʉreco ca jũa naio waaro ĩari, “Boerore añuri rʉmʉ niirʉga,” mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ñucã boeri tabere, ʉmʉreco quejero jũa, bueri bʉrʉri nii, ca biiro ĩarã, “Oco rʉmʉ niirʉga,” mʉja ĩi. Ʉmʉreco to biro ca biirijere ĩari, to biirije biirʉga añuro ca ĩi majirã nii pacarã, ¿ñee tiirã ati yʉtearire ca bii niirije peera mʉja ĩa majititi? ");
INSERT INTO baoNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Anija bojoca ñañarã, Ʉmʉreco Pacʉre ca tʉo nʉnʉjeetirã, jĩcã wãme ca ĩa ñaaña manirije tii bau niiriquere ĩarʉgama. To biro cʉ̃ja ca ĩimijata cãare, jĩcã wãme ʉno peera Jonás cʉ̃ ca biiriquere biro apeye ca ĩa ñaaña manirije tii bau nii ĩño ecotirucuma —ĩiwi. To biro ĩi, toora cʉ̃ja ca niiro cʉ̃jare waa weocoawi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jãa, cʉ̃ buerã, Jesús mena ʉtabʉcʉra ape nʉñapʉ waarã, acoboma ĩirã pan jãa jee waatiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesús pea: —Fariseos, saduceos, cʉ̃ja ca tii niirije, pan're ca wauaro ca tiirijere biro ca niirijere ĩa majiri niiña —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","To biro cʉ̃ ca ĩiro, jãa, cʉ̃ buerã pea: —¡Agó nija! Pan mani jee dootijapa —jãa ameri ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús pea to biro jãa ca ameri ĩirijere majiri, o biro jãare ĩiwi: —¿Ñee tiirã, “Pan mani cʉoti,” mʉja ameri ĩiti? No cõro petoacã peti díámacʉ̃ mʉja tʉo nʉcʉ̃ bʉocãti. ");
INSERT INTO baoNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Mʉja tʉo jeeñoticãti ména? ¿Jĩcã amo cõro niiricari pan menara, jĩcã amo cõro mil ca niirãre yʉ ca ecarique cãare mʉja majititi? ¿No cãnacã pijeeri peti mʉja jee neori? ");
INSERT INTO baoNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Ñucã pan'gaari jĩcã amo peti, ape amore pʉaga penituaro ca niiricari menara bapari mil ca niirãre yʉ ca batorique cãare mʉja majititi? ¿No cãnacã pijeeri peti mʉja jee neori? ");
INSERT INTO baoNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿No cõro peti pan méére yʉ ca ĩi pacaro mʉja tʉo majititi? Fariseos, to biri saduceos, cʉ̃ja ca tii niirije baarique ca wauaro ca tiirijere biro ca niirije menare ĩa majiri niiña —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","To biro cʉ̃ ca ĩiropʉ pan're ayiarique méére, fariseos, to biri saduceos, cʉ̃ja ca ĩi dito buerijere tʉo majiri niiña ĩigʉ, Jesús to biro jãare cʉ̃ ca ĩirijere jãa tʉo majiwʉ yua. ");
INSERT INTO baoNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jiro Jesús, Cesarea de Filipo yepapʉ eari, o biro jãare ĩi jãiñawi: —¿Yʉ, Ca Nii Majuropeegʉ Macʉ̃re, “Ñiru niimi,” cʉ̃ja ĩirucuti bojoca? —ĩi jãiñawi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","To biro cʉ̃ ca ĩiro, o biro cʉ̃re jãa ĩi yʉʉwʉ: —Jĩcãrã, “Uwo Coeri majʉ Juan niimi,” ĩima. Aperã, “Elías niimi,” ĩima. Aperã, “Jeremías niimi; ñucã apĩ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ niimi,” ĩirucuma —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","To biro jãa ca ĩiro: —Mʉja pea, ¿“Ñiru niimi,” yʉre mʉja ĩiti? —jãare ĩi jãiñawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","To biro cʉ̃ ca ĩiro, Simón Pedro o biro cʉ̃re ĩi yʉʉwi: —Mʉa Mesías, Ʉmʉreco Pacʉ to birora ca caticõa niigʉ Macʉ̃ mʉ nii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","To biro cʉ̃ ca ĩiro, o biro ĩiwi Jesús: —Ʉjea niiña mʉ, Simón, Jonás macʉ̃. Jĩcʉ̃ bojocʉ ʉno peera atere mʉre wede majiotijacupi. Yʉ Pacʉ ʉmʉreco tutipʉ ca niigʉ, atere mʉre majiomi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","To biri yʉ pea: “Pedro mʉ nii,” mʉre yʉ ĩi. Atiga ʉ̃tãga jʉorira yʉre ca tʉo nʉnʉjeerã cʉ̃ja ca nii nʉnʉa waaro yʉ tiirucu. Bii yairicaro ca tii tutua niirijepʉ cãa, cʉ̃jare ametʉene nʉcãtirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ʉmʉreco Pacʉ cʉ̃ ca doti niiropʉre ca waarãre ca jope pãa jʉguegʉre biro mʉre yʉ cũu. Ati yepare niigʉ tii niiriquere mʉ ca bootijata, ʉmʉreco tutipʉ cãare boo ecotirucu. Ñucã ati yepare niigʉ tii niiriquere mʉ ca boojata, ʉmʉreco tutipʉ cãare boo ecorucu —ĩiwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","To biro ĩi yapano, jãa cʉ̃ buerãre: —Mesías yʉ ca niirijere jĩcʉ̃ ʉno peerena wedeticãña —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Jesús, tii tabe mena, jãa cʉ̃ buerãre, Jerusalén'pʉ cʉ̃ ca waapere to biri bojocare ca jʉo niirã, paia ʉparã, doti cũuriquere ca jʉo bueri maja, ñañaro cʉ̃re cʉ̃ja tiipere, ñucã cʉ̃re cʉ̃ja ca jĩa cõapere, to biro cʉ̃re cʉ̃ja ca tii cõacãmijata cãare ñucã itia rʉmʉ jiro cʉ̃ ca cati tuapere, jãare wede jʉowi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","To biro cʉ̃ ca ĩiro tʉo, Pedro pea apero pee cʉ̃re ami waari, o biro cʉ̃re ĩi tuti jʉo waawi Jesús're: —¡Agó nija Wiogʉ, Ʉmʉreco Pacʉ teere mʉre cʉ̃ camotajato! ¡Atea jĩcãti ʉno peera to biirije peti mʉre biitirucu! —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","To biro cʉ̃ ca ĩiro, Jesús pea Pedrore amojode ĩari, o biro cʉ̃re ĩiwi: —¡To cõrora yʉre camotatiya, Satanás! Mʉa, apeye pee yʉ ca bii maa wijiaro yʉre tiirʉgʉ mʉ ĩi. Mʉa, Ʉmʉreco Pacʉ cʉ̃ ca boorore biro méé mʉ tʉgoeña. Bojoca cʉ̃ja ca tʉgoeñari wãme pee wado mʉ tʉgoeñacã —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","To biro cʉ̃re ĩi yapano, jãa, cʉ̃ buerãre, o biro jãare ĩiwi: —Jĩcʉ̃, yʉ buegʉ ca niirʉgʉ ʉnoa, mʉ majurope mʉ ca tiirʉgarijere to cõrora acobori, to cãnacã rʉmʉra yʉ yee jʉori ñañaro tamʉo pacagʉ, to birora yʉre tʉo nʉnʉjeecõa niiña. ");
INSERT INTO baoNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Cʉ̃ ca catirijere ca maigʉa, cʉ̃ ca catipere bʉatirucumi. Yʉ yee jʉori ñañaro ca tamʉo yaigʉa, cʉ̃ ca catipere bʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Bojocʉre ñee ʉno peere to tii nemoti ati yepa maquẽ niipetirijepʉrena cʉocã pacagʉ, cʉ̃ yerire cʉ̃ ca tii yaio nʉcõcãjata? ¿Ñucã cʉ̃ ca cati niipe wapare, no cõro pairo mena cʉ̃ wapa tii majibogajati? ");
INSERT INTO baoNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ Pacʉ cʉ̃ ca boe baterije mena, ñucã yʉ yaarã yʉre queti wede bojari maja mena, yʉ doorucu. To cõrore to cãnacãrãpʉrena cʉ̃ja ca tii niirica wãmeri ca niirore biro, cʉ̃ja yee ca niirijere cʉ̃jare yʉ noni wapa tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Díámacʉ̃ mʉjare yʉ ĩi: Jĩcãrã ano ca niirã, yʉ, Ca Nii Majuropeegʉ Macʉ̃, Wiogʉ yʉ ca niigʉ dooro ĩatirãra mʉja bii yaitirucu —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jĩcã amo peti, ape amore jĩcãga penituaro ca niiri rʉmʉri jiro Pedro, Santiago, cʉ̃ bai Juan're, bojoricaro cʉ̃jare jʉo cojori, ʉ̃tãgʉ bʉaro ca emʉaricʉ jotoapʉ cʉ̃jare jʉocoawi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Toopʉ, cʉ̃ mena cʉ̃ja ca niiro, Jesús cʉ̃ ca baurije wajoacoaupi. Cʉ̃ diámacʉ̃ muipũ ʉmʉreco macʉ̃re biro boe bateupe. Biicã, cʉ̃ jutiro cãa ca boe baterijere biro botirito biicoaupe. ");
INSERT INTO baoNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","To biro cʉ̃ ca biiri tabera Elías, Moisés, Jesús mena cʉ̃ja ca wede peni niiro ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","To biri Pedro pea o biro ĩiupi Jesús're: —Wiogʉ, anopʉ mani ca niiro añu majuropeecã. Mʉ ca boojata, itia wii mʉjare yʉ queno bojarucu. Jĩcã wii mʉ yaa wii, ape wii Moisés yaa wii, ape wii Elías yaa wii, mʉjare yʉ queno bojarucu —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro, Jesús're to biro cʉ̃ ca ĩi niiri tabera, bueri bʉrʉa bʉaro ca boe bateri bʉrʉa duwi doo, cʉ̃jare paa ũma nʉcãcoaupa. To biro ca biiri tabera wederique bueri bʉrʉa watoapʉre o biro ca ĩi wedeo cojorijere tʉoupa: —Ani yʉ Macʉ̃, yʉ ca maigʉ, yʉ ca beje amiricʉ niimi. Cʉ̃ ca ĩirijere tʉo nʉnʉjeeya —ĩi wedeoupa. ");
INSERT INTO baoNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","To biro ca ĩirijere tʉorã, cʉ̃ buerã pea uwima ĩirã, yepapʉ muu bia ñaacũmucoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","To biro cʉ̃ja ca biiro ĩa, Jesús pea cʉ̃ja pʉto waa, cʉ̃jare padeña: —Wãmʉ nʉcãña. Uwiticãña —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","To biro cʉ̃ ca ĩiro ĩa cojorã, aperã peera ĩatiupa yua. Jesús wadore cʉ̃re ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Jiro ʉ̃tãgʉpʉ ca niiricarã duwi nʉnʉa doorã: —Mecʉ̃ mʉja ca ĩajãrijere jĩcʉ̃ ʉno peerena mʉja wedetirucu ména. Jiro yʉ, Ca Nii Majuropeegʉ Macʉ̃, ca bii yaicoaricʉ nii pacagʉ, yʉ ca cati tuaro jiropʉ docare mʉja wederucu —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","To biro cʉ̃ ca ĩiro, cʉ̃ buerã pea o biro cʉ̃re ĩi jãiñaupa Jesús're: —¿Ñee tiirã doti cũuriquere jʉo bueri maja pea, “Elías doo jʉorucumi ména,” cʉ̃ja ĩiti? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","To biro cʉ̃ja ca ĩi jãiñaro, o biro cʉ̃jare ĩi yʉʉupi Jesús: —Díámacʉ̃ra ĩima. Elías'ra doo jʉgue, cʉ̃ra niipetirijere queno, tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Yʉ pea, “Mee, Elías doo yerijãaupi,” yʉ ĩi. Cʉ̃ja pee cʉ̃re ĩa majitiupa. To biri no cʉ̃ja ca tiirʉgarije cõro cʉ̃re tiiupa. To biri wãmera cʉ̃jare yʉ tii ecorucu yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","To biro cʉ̃ ca ĩiro: “Uwo Coeri majʉ Juan niiquĩricʉre ĩigʉ ĩimi,” ĩi tʉo majicãupa cʉ̃ buerã. ");
INSERT INTO baoNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Bojoca cʉ̃ja ca niiropʉ cʉ̃ja ca earo, jĩcʉ̃ ʉmʉ Jesús pʉto ea, cʉ̃ ãjʉro jupeari mena ea nuu waari, o biro ĩiwi Jesús're: ");
INSERT INTO baoNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wiogʉ, yʉ macʉ̃re boo paca ĩaña. Ñañaro mecʉ̃ yai waami. Paʉ tiiri pecamepʉ ñaajoecoa, ñucã ape tabera diapʉ ñaañuacoa, biimi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʉ buerãre cʉ̃re yʉ ami eamijãwʉ. Cʉ̃re ametʉene majitijãwa —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","To biro cʉ̃ ca ĩiro, o biro ĩi yʉʉwi Jesús: —¡Agó nija, díámacʉ̃ tʉo nʉcʉ̃ bʉoti, ca tiiya manirijepʉ tii nʉnʉjeecã yai waa, ca biirã cʉ̃ja ca niiri cuu macãrã! ¿No cõro yoaro mʉja mena yʉ niigʉti? ¿No cõro yoaro to biro mʉja ca biirijere yʉ nʉcã niigʉti? Jaʉ, wãmʉre ano pee cʉ̃re ami dooya —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","To cõrora wãtĩre tuti, wãmʉpʉre ca niigʉre cʉ̃re cõa wiene, tiiwi Jesús. Cʉ̃ pea to biro cʉ̃ ca tiiri nimaro mena diarique manigʉ tuawi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jiro jãa, cʉ̃ buerã pea, bojoricaro jãa wado Jesús mena niirã, o biro cʉ̃re jãa ĩi jãiñawʉ: —¿Ñee tiirã jãa pea wãtĩre jãa cõa wiene majitijapari? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","To biro jãa ca ĩiro, o biro jãare ĩi yʉʉwi Jesús: —Mʉja petoacã peti díámacʉ̃ mʉja tʉo nʉcʉ̃ bʉocã. Díámacʉ̃ mʉja ca tʉo nʉcʉ̃ bʉorije, mostaza apega cõroacã to ca niicãmijata cãare, atigʉ ʉ̃tãgʉre, “Pĩa waari, aperopʉ ea nʉcãroja,” mʉja ca ĩirora, mʉja ca ĩirore biro biicãbocu. Jĩcã wãme ʉno peera mʉja ca tii majitirije nii, biitibocu —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Galilea yepapʉre cʉ̃ mena jĩcãri jãa ca waa yujuro, o biro jãare ĩiwi Jesús: —Yʉ, Ca Nii Majuropeegʉ Macʉ̃re ñeeri, aperãpʉre yʉre tiicojorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Cʉ̃ja pea yʉre jĩa cõacãrucuma. To biro yʉre cʉ̃ja ca tii pacaro, itia rʉmʉ jiro yʉ cati tuacoarucu ñucã —jãare ĩiwi. To biro cʉ̃ ca ĩiro, jãa pea bʉaro jãa tʉgoeñarique paiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jiro Capernaúm'pʉ Jesús, jãa, cʉ̃ buerã mena jãa ca earo, Ʉmʉreco Pacʉ yaa wii maquẽre wapa jeeri maja Pedrore ĩarã waari, o biro cʉ̃re ĩi jãiñaupa: —¿Mʉjare ca buegʉa, Ʉmʉreco Pacʉ yaa wii maquẽ wapa jãiriquere cʉ̃ wapa tiiti? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiupi Pedro: —¡Ʉ̃gjá! Wapa tiirucumi —ĩiupi. Ĩi yapano, Pedro wiipʉ cʉ̃ ca jãa earije menara Jesús pee o biro cʉ̃re ĩi jãiña jʉguecãwi: —Simón, ¿do biro mʉ tʉgoeñati mʉa? Ati yepa macãrã wiorã ¿noare cʉ̃ja wapa jãirucuti? ¿Cʉ̃ja punarena, ape yepapʉ macãrã peere, cʉ̃ja jãirucuti? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","To biro cʉ̃ ca ĩiro, Pedro pea o biro ĩi yʉʉwi: —Ape yepa macãrãre jãirucuma —cʉ̃re ĩiwi. To biro cʉ̃ ca ĩiro, o biro ĩi nemowi ñucã Jesús: —To birora bii, cʉ̃ja puna peera petoacã ʉnora wapa tiirique mani. ");
INSERT INTO baoNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Biirãpʉa, cʉ̃ja ca wede pairo mani ca bii buiyeetipere biro ĩirã, ʉtabʉcʉrapʉ waari, wai wajagʉja. Mʉ ca jĩa jʉogʉ ʉjerore jĩcã tii, wapa tiirica tii mʉ bʉarucu, yʉ yee wapa cãare, mʉ yee wapa cãare, ca wapa tiicãpa tiipʉre. To biri tii tiire ami waari, cʉ̃jare mʉ noniwa —ĩiwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","To biro cʉ̃re cʉ̃ ca ĩi niiri tabera, Jesús're nea poo eari, o biro cʉ̃re jãa ĩi jãiñawʉ: —¿Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre ca nii majuropeegʉ ca niigʉ niipe cʉ̃ niiti? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","To cõrora Jesús pea, jĩcʉ̃ wimagʉre jʉo cojo, jãa watoa cʉ̃re nʉcõri, ");
INSERT INTO baoNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","o biro ĩiwi: —Díámacʉ̃ mʉjare yʉ ĩi. Tʉgoeña wajoa, wimarãre biro pee mʉja ca biitijata, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre mʉja ea waatirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre ca nii majuropeegʉ ca niigʉa, ani wimagʉ ca nii majuropeegʉ cʉ̃ ca nii tʉgoeñatirore biro ca biigʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Jĩcʉ̃ ʉno, yʉ yee quetire, ani wimagʉre biro ca ñeegʉa, yʉrena ñeegʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ñucã no ca boogʉ, wãmaacã yʉre ca tʉo nʉnʉjee jʉo doorã mena macʉ̃re ñañaro cʉ̃ ca tiiro ca tii buiyeegʉ ʉnora, ʉ̃tãga pairica mena cʉ̃ amʉtuture jia tuuri, dia pairi yaa ca ʉ̃cʉ̃aropʉ cʉ̃re duu cõacãjata, añubocu. ");
INSERT INTO baoNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","”Ñaña majuropeecã ati yepare, to cõro paʉ ñañarije cʉ̃ja ca tiiro ca tii niirije. Ca bii buiyee niirijea do biro tii camotaarique ʉno méé niiro bii biiropʉa. To ca bii pacaro, aperãre ñañarije cʉ̃ja ca tiiro ca tii buiyeegʉ pea ñañaro peti tamʉorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","To biri mʉ amo, mʉ dʉpo, ñañarije mʉ ca tiiro to ca tiijata, patari yoaropʉ cõacãña. Amo manigʉra, ñucã upa yuriara, Ʉmʉreco Pacʉ pʉtopʉ mʉ ca ea waaro añujañu. Pʉa amo, ñucã pʉa dʉpo menapʉra pecame ca ʉ̃ʉ yatitiri pecame pee mʉ ca cõa joe ecojata docare, añuti. ");
INSERT INTO baoNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ñucã mʉ capega ñañarije mʉ ca tiiro to ca tiijata, jade wee amiri, yoaropʉ cõacãña. Jĩcã capega menara Ʉmʉreco Pacʉ pʉtopʉre mʉ ca earo añujañu. Pʉa capega menapʉra, ñañaro tamʉorica pecame pee mʉ ca cõa joe ecojata docare, añuti. ");
INSERT INTO baoNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","”Anija wimarãre jĩcʉ̃ ʉno peerena watoa macãrãre biro cʉ̃jare ĩaticãña. Cʉ̃ja yaarã Ʉmʉreco Pacʉ pʉto macãrã, yʉ Pacʉ ʉmʉreco tutipʉ ca niigʉ diámacʉ̃re, to birora ĩacõa niima. ");
INSERT INTO baoNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yʉ, Ca Nii Majuropeegʉ Macʉ̃a, ca maa wijia yairicarãre ametʉenegʉ doogʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","”¿Do biro mʉja ĩiti mʉja? Jĩcʉ̃ bojocʉ, cien oveja ca cʉogʉ, jĩcʉ̃acã cʉ̃ja mena macʉ̃ cʉ̃ ca maa wijiaro, ¿jĩcãto, noventa y nueve ca niirãre toora cʉ̃jare cũuri, cʉ̃re cʉ̃ amagʉ waatigajati? ");
INSERT INTO baoNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Oveja ca maa wijiaricʉre cʉ̃ ca bʉacãjata, aperã noventa y nueve ca niirãre cʉ̃ ca ĩa ʉjea niiro ametʉenero ʉjea niicumi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","To birora mʉja Pacʉ, ʉmʉreco tutipʉ ca niigʉ cãa, jĩcʉ̃ ʉno peera anija wimarã mena macʉ̃ cʉ̃ ca yairo bootimi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","”Mʉ yee wedegʉ ñañaro mʉre cʉ̃ ca tiijata, cʉ̃ jĩcʉ̃ menara wede peniri, ñañaro cʉ̃ ca tiiriquere “Ñañaro yʉ tiijapa,” cʉ̃ ca ĩi tʉgoeña yeri wajoaro cʉ̃re tiiya. To biro mʉ ca ĩirijere cʉ̃ ca tʉo nʉnʉjeejata, jĩcʉ̃ punare birora mʉja niirucu ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","To biro mʉ ca ĩirijere cʉ̃ ca tʉorʉgaticãjata, jĩcʉ̃ ʉno, pʉarã ʉno, mʉ mena cʉ̃jare jʉo waagʉja, ñañaro mʉre ca tiiricʉ mena mʉ ca wederique quenorije, pʉarã, itiarã cʉ̃ja ca nii nemorije mena mʉ ca quenopere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Cʉ̃ja cãare cʉ̃ ca tʉorʉgaticãjata, yʉre ca tʉo nʉnʉjeerã ca nea poorãpʉre wedeya. Cʉ̃ja cãare cʉ̃ ca tʉorʉgaticãjata, Ʉmʉreco Pacʉre ca majitigʉre biro, ñucã jĩcʉ̃ niirique wapare wapa jee bojari majʉre biro, cʉ̃re ĩacãña yua. ");
INSERT INTO baoNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Díámacʉ̃ yʉ ĩi: Ati yepapʉre tii niiriquere mʉja ca bootirije niipetirijepʉra, ʉmʉreco tutipʉ cãare boo ecotirucu. Ñucã ati yepapʉre tii niiriquere mʉja ca boorije niipetirijepʉra, ʉmʉreco tutipʉ cãare boo ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","”Ñucã ate mʉjare yʉ ĩi: Mʉja mena macãrã ʉno pʉarã ati yepapʉre niirã, “Ʉmʉreco Pacʉre atere mani jãico,” cʉ̃ja ca ĩi jãi juu buejata, yʉ Pacʉ ʉmʉreco tutipʉ ca niigʉ, cʉ̃ja ca jãirijere cʉ̃jare tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Pʉarã ʉno, itiarã ʉno, yʉ wãme mena ĩiri nea poo, cʉ̃ja ca juu bue niiri tabere cʉ̃ja watoara yʉ nii —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","To biro cʉ̃ ca ĩiro, Pedro pea Jesús pʉto waa, o biro cʉ̃re ĩi jãiñawi: —Wiogʉ, yʉ yee wedegʉ ñañaro yʉre cʉ̃ ca tiijata, ¿no cãnacã tii peti ñañaro yʉre cʉ̃ ca tiirijere yʉ acobogajati? ¿Jĩcã amo peti, ape amore pʉaga penituaro niirijera yʉ ĩigajati? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩiwi Pedrore: —“Jĩcã amo peti, ape amore pʉaga penituaro niirijera yʉ ĩiti. Niipetirije ñañarije cʉ̃ ca tiirije cõrorena, cʉ̃ mena wede quenoña,” yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","”To biri Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃ wiogʉ cʉ̃re ca pade coterã, cʉ̃re cʉ̃ja ca wapa moorijere cʉ̃ ca wapa jãirʉgariquere biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","To biri cʉ̃ja mena quenorʉgʉ, cʉ̃jare cʉ̃ ca jʉo neo cojo jʉo waaro pairo, millones ca wapa moogʉ ea jʉoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Cʉ̃ pea cʉ̃ wiogʉre cʉ̃ ca wapa moorijere cʉ̃ ca wapa tiipe ʉno cʉ̃ ca cʉotiro macã, cʉ̃ wiogʉ pea, “Wapa manirora, mʉ nʉmo, mʉ puna, mʉ ca cʉorije niipetiro mena yʉre pade nʉnʉjeeya, yʉre mʉ ca wapa moorije wapa tiiricarore biro to tuajato ĩigʉ,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","”Cʉ̃ pea, cʉ̃ wiogʉ to biro cʉ̃re cʉ̃ ca ĩiro tʉogʉ, cʉ̃ ãjʉro jupea mena ea nuu waari, bʉaro o biro cʉ̃re ĩiupʉ: “¡Wiogʉ! Mʉre yʉ ca wapa moorijere jãi pato wãcãticãña. Yʉ wapa tii peticãrucu,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","”To biro cʉ̃ ca ĩiro tʉo, wiogʉ pea cʉ̃re boo paca ĩari, cʉ̃re cʉ̃ ca wapa moorijere acobo, ca wapa mootiricʉre biropʉ cʉ̃ ca tuaro cʉ̃re tiiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","”To biro cʉ̃re cʉ̃ ca tiiro jiro witi waagʉ, cʉ̃ pea cʉ̃ mena macʉ̃ petoacã cʉ̃re ca wapa moogʉre bʉa eaupʉ. Cʉ̃re bʉa eari, “Yʉre mʉ ca wapa moorijere wapa tiiya,” ĩigʉra, cʉ̃re ñeeri, cʉ̃ amʉtuture cʉ̃re ñee taa jʉo waaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","To biro cʉ̃ ca tiiro, cʉ̃ mena macʉ̃ pea cʉ̃ ãjʉro jupeari mena ea nuu waari: “Mʉre yʉ ca wapa moorijere jãi pato wãcãticãña. Yʉ wapa tii peticãrucu,” cʉ̃re ĩimiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","To biro cʉ̃ ca ĩi pacaro, cʉ̃re yʉʉtiupʉ. Cʉ̃re yʉʉricaro maniro tia cũurica wiipʉ cʉ̃re cũu doticãupʉ, “Yʉre cʉ̃ ca wapa moorijere cʉ̃ wapa tii peotijato,” ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","”To biro cʉ̃ ca tiirije, aperã cʉ̃ mena macãrã paderi maja peera bʉaro tʉgoeñarique paioupe. To biri to biro cʉ̃ ca tiirique niipetirore cʉ̃ja wiogʉre wederã waauparã. ");
INSERT INTO baoNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","To biro cʉ̃ja ca ĩiro tʉo, wiogʉ pea cʉ̃re jʉo cojo dotiri, o biro cʉ̃re ĩiupʉ: “¡Pade coteri majʉ ca añutigʉ! Yʉre mʉ ca wapa moorije niipetirore yʉ acobo peoticãjãwʉ, yʉre mʉ ca jãiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mʉre yʉ ca boo paca ĩajãrore birora, mʉ cãa, mʉ mena macʉ̃re ca boo paca ĩapʉ mʉ niijapa,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wiogʉ pea bʉaropʉra ajia ametʉacoa, cʉ̃re ñee doti, niipetiro cʉ̃re cʉ̃ ca wapa moorijere cʉ̃ wapa tiijato ĩigʉ, ñañaro cʉ̃re tii dotiupʉ —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","O biro ĩi nemowi: —Mʉja ca niiro cõrora, mʉja yeripʉ mena mʉja yaarã ñañaro mʉjare cʉ̃ja ca tiirijere mʉja ca acobotijata, yʉ Pacʉ ʉmʉreco tutipʉ ca niigʉ cãa, to biri wãmera tiirucumi mʉja cãare —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Atere ĩi yapano, Jesús, Galilea ca niiricʉ, Judea yepa dia Jordán're, muipũ cʉ̃ ca mʉa doori nʉña pee ca niiri yepapʉre eawi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Too cʉ̃ ca waaro, paʉ bojoca cʉ̃re nʉnʉ waawa. Toopʉ ca diarique cʉtirãre catiowi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Jĩcãrã fariseos, Jesús pʉto eari, cʉ̃ ca ĩi maa wijiaro cʉ̃re wedejãarʉgarã, o biro cʉ̃re ĩi jãiñawa: —¿Doti cũurique, jĩcʉ̃ ʉmʉre, no ca boorije jʉorira cʉ̃ nʉmore to cõa dotiti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —¿Mʉja, Ʉmʉreco Pacʉ wederique cʉ̃ja ca owarica pũuropʉre, “Jĩcãto bojocʉre tii jʉogʉpʉra mee ʉmʉ, nomio tiiupi Ʉmʉreco Pacʉ,” ca ĩirijere mʉja bue ñaatiti? ");
INSERT INTO baoNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","O biro ĩiupi: “Ate jʉori, jĩcʉ̃ ʉmʉ cʉ̃ nʉmo mena niirʉgʉ, cʉ̃ pacʉre, cʉ̃ pacore witi weorucumi. Cʉ̃ja pʉarã nii pacarã, jĩcã upʉra niirucuma,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","To biri pʉarã méé niima. Jĩcʉ̃ra niima yua. To biro biicãri Ʉmʉreco Pacʉ jĩcã upʉra cʉ̃ ca cũuricarã ca niirãrena, bojocʉra cʉ̃ja ca ameri camotatiro tii majitimi —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi jãiñawa: —¿To docare, ñee tiigʉ Moisés niiquĩricʉ, “Ate jʉori mʉre yʉ cõa,” ca ĩiri pũuro cʉ̃ nʉmore tiicojori, “Waagoja,” ĩicã majimi, cʉ̃ ĩi cũuquĩupari? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Añuro petira, wedericaro ca ametʉene nʉcã pairã mʉja ca niiro macã, mʉja nʉmoare cõa dotiupi Moisés. Ména jĩcãtopʉra to biri wãme biitiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","To biri yʉ pea o biro mʉjare yʉ ĩi: Jĩcʉ̃ cʉ̃ nʉmore, apĩ mena cõ ca tii epeti pacaro cõre cõa, apeo cʉ̃ ca nʉmo cʉtijata, cʉ̃ nʉmo ca niitigopʉre tii epegʉ tiimi. Ñucã ca manʉ cõaricore ca nʉmo cʉtigʉ cãa, cʉ̃ nʉmo ca niitigopʉre tii epegʉ tiimi —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","To biro cʉ̃ ca ĩiro, jãa cʉ̃ buerã pea o biro cʉ̃re jãa ĩiwʉ Jesús're: —To docare ʉmʉ cʉ̃ nʉmore to biirije cʉ̃ ca biijata, ca nʉmo cʉtiticãpe nii —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","To biro jãa ca ĩiro, Jesús pea o biro ĩi yʉʉwi: —Atera niipetirãpʉra: “To biirije biima ĩiro bii,” ĩi majitima. Ʉmʉreco Pacʉ cʉ̃ja ca majiro cʉ̃ ca tiirã wado teere majima. ");
INSERT INTO baoNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bojorica wãmeri ca biirije jʉori, nʉmo cʉti majitima ʉmʉa: Jĩcãrã, mee baʉarãpʉra to biirã ca baʉaricarã niiri nʉmo cʉtitima. Aperãra bojocara to biro cʉ̃ja ca biiro cʉ̃jare tiima. Ñucã aperã Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre padema ĩirã, nʉmo cʉtitima. Atere ca tʉo puo majigʉ ʉno cʉ̃ tʉo puojato —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ñucã jĩcãrã, wimarãre Jesús pʉtopʉ ami doowa, cʉ̃ amori mena cʉ̃jare ñia peori, cʉ̃jare cʉ̃ juu bue bojajato ĩirã. To biro cʉ̃ja ca tiiro, jãa cʉ̃ buerã pea, wimarãre ca jee doorãre cʉ̃jare jãa boca tuti camotaawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","To biro jãa ca ĩiro, Jesús pea o biro jãare ĩiwi: —Wimarãre yʉ pʉto tiicojoya. Cʉ̃jare camotaaticãña, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, cʉ̃jare biro ca niirã cʉ̃ja ca niipa tabe niiro bii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","To biro ĩi, wimarãre cʉ̃ amori mena cʉ̃jare ñia peo yapano, too ca niiricʉ waacoawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jĩcʉ̃ wãmʉ Jesús're ĩagʉ doori, o biro cʉ̃re ĩi jãiñawi: —Buegʉ añugʉ, ¿ñee ʉno añurije yʉ tiigajati, to birora caticõa niiriquere cʉorʉgʉ? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —¿Ñee tiigʉ, “Añugʉ,” yʉre mʉ ĩiti? Ca añugʉa jĩcʉ̃ra niimi, Ʉmʉreco Pacʉ wado. Caticõa niiriquere bʉarʉgʉa, Ʉmʉreco Pacʉ cʉ̃ ca doti cũurique ca ĩirore biro tiiya —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","To biro cʉ̃ ca ĩiro: —¿Dijere? —ĩi jãiñawi wãmʉ pea. Jesús pea o biro cʉ̃re ĩiwi: —Bojocare jĩaticãña. Ca manʉ cʉtigopʉrena eperico cʉtiticãña. Jee dutiticãña. Aperãre watoara ĩi dito buiyeeticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Mʉ pacʉre, mʉ pacore nʉcʉ̃ bʉoya. Ñucã, mʉ pʉto macãrã cãare mʉ upʉre mʉ ca mairore birora cʉ̃jare maiña —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","To biro cʉ̃ ca ĩiro tʉo: —Mee, tee niipetirijepʉra yʉ tii peticãwʉ. ¿Ñee apeye yʉre to dʉjati ména? —cʉ̃re ĩi jãiñawi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","To biro cʉ̃ ca ĩi jãiñaro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —Añugʉ peti mʉ ca niirʉgajata, waari mʉ ca cʉorije niipetirijere noni peticã, tee wapare jeeri, ca boo pacarãre cʉ̃jare noniña. To biro tiigʉ, ʉmʉreco tutipʉre pairo mʉ apeye cʉtirucu. To biro tii yapano, yʉ mena dooya —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wãmʉ pea to biro cʉ̃ ca ĩirijere tʉogʉ, ca apeye paigʉ niiri, bʉaro tʉgoeña pairique mena waacoawi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","To biro cʉ̃ ca biiro ĩa, Jesús pea o biro ĩiwi jãa cʉ̃ buerãre: —Yee méé mʉjare yʉ ĩi: Jĩcʉ̃, ca apeye paigʉ, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre biirique peti ea waarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","O biro mʉjare yʉ ĩi nemo ñucã: Jĩcʉ̃ ca apeye paigʉ pea Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre do biro cʉ̃ ca bii ea waatirije to ca nii pacaro, jĩcʉ̃ camello peera, popiye méé niicã, ãjipõa potaga opeacãre cʉ̃ ca jãa ame witi waaro —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","To biro cʉ̃ ca ĩiro tʉorã, jãa cʉ̃ buerã pea, bʉaro jañuro tʉo ʉcʉacoama ĩirã, o biro jãa ĩiwʉ: —To docare ¿ñiru peti cʉ̃ ametʉa majigʉti? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","To biro jãa ca ĩiro, Jesús pea jãare ĩa, o biro ĩiwi: —Atea, bojocara do biro ca tii majiña manirije niiro bii, Ʉmʉreco Pacʉ peera cʉ̃ ca tii majirije wado niicã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","To biro cʉ̃ ca ĩiro, Pedro pea o biro ĩiwi Jesús're: —Jãa, jãa ca cʉorijere cũu peticã, mʉ mena pee jãa doowʉ. To biri, ¿ñee jãa tiicojo ecorãti? —cʉ̃re ĩi jãiñawi. ");
INSERT INTO baoNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩi yʉʉwi: —Yee méé mʉjare yʉ ĩi: Ati ʉmʉreco niipetiro ca wajoari cuu ca niiro, yʉ, Ca Nii Majuropeegʉ Macʉ̃, ca doti majuropeegʉ cʉ̃ ca duwiri tabepʉ yʉ ca ea nuu eari rʉmʉre, mʉja, yʉre ca nʉnʉricarã cãa, ca doti majuropeera cʉ̃ja ca duwirijepʉ mʉja ea nuu waarucu, Israel yaa poogaari pʉa amo peti, dʉpore pʉaga penituaro ca niiri poogaari cʉ̃ja ca tii niiriquere jãiña bejerʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ñucã niipetirã yʉ yee jʉori, cʉ̃ja wiijerire, cʉ̃ja yaarãre, cʉ̃ja yaarã romirire, cʉ̃ja pacʉare, cʉ̃ja pacoare, cʉ̃ja punare, cʉ̃ja yaa yeparire cʉ̃ja ca waa weojata, cʉ̃ja ca cʉoricaro ametʉenero cien niirije cõro peti cʉo nemorucuma. Ñucã to birora caticõa niirique cãare cʉorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","To biri mecʉ̃rire paʉ ca nii majuropeerã ca niirã, watoa macãrã tuarucuma. Ñucã mecʉ̃rire, paʉ watoa macãrã ca niirã pee, ca nii majuropeera tuarucuma —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","—Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃ ote wejeri ʉpʉ, cʉ̃ ʉje wejepʉ ca pade bojarã waparãre meepʉacã ca amagʉ waaricʉre biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Cʉ̃ pea cʉ̃ja mena bʉa ea, “Jĩcã rʉmʉ paderique maquẽ mʉjare yʉ wapa tiirucu,” cʉ̃jare ĩi yapano, cʉ̃ ʉje wejepʉ cʉ̃jare pade doti cojoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","”Ñucã jiro muipũ cʉ̃ ca aji mʉa tua petiri tabe witi waagʉ, wiijeri watoa macã yepapʉ, ñee tiiri méé ca niirãre ĩaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Cʉ̃jare ĩa: “Mʉja cãa, yʉ ʉje wejepʉ paderãja. Cõoricaro mʉjare yʉ wapa tiirucu,” cʉ̃jare ĩiupʉ. To biro cʉ̃ ca ĩiro tʉo, cʉ̃ja cãa, paderã waacoauparã. ");
INSERT INTO baoNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Jiro jotoa decomacã ca niiro witi waaupʉ ñucã. Jiro ca naio waari tabe yucʉ jotoa muipũ ca niiro waaupʉ ñucã, cʉ̃ ca bʉa earã mena cãare to birora cʉ̃jare ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Jiro ñucã muipũ yucʉ decomacã cʉ̃ ca niiro, wiijeri watoa macã yepapʉ ñee tiiri méé ca duwirãre bʉa eari, o biro ĩi jãiñaupʉ: “¿Ñee tiirã paderi méé anora mʉja duwi naiocoati?” cʉ̃jare ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","”To biro cʉ̃ ca ĩiro tʉo, o biro cʉ̃re ĩi yʉʉuparã: “Jĩcʉ̃ ʉno peera jãare paderique tiicojotimi,” cʉ̃re ĩiuparã. To biro cʉ̃ja ca ĩiro, “Mʉja cãa, yʉ ʉje wejepʉ paderãja,” ĩiupʉ cʉ̃ja cãare. ");
INSERT INTO baoNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","”Ca naio waaro ĩa, tii weje ʉpʉ pea paderi majare ca doti niigʉre, o biro cʉ̃re ĩiupʉ: “Paderi majare jʉo cojori, cʉ̃jare wapa tiiya. Jiropʉ ca paderã eajãrã peere wapa tii jʉo waa, ca pade jʉorã eajãrãre wapa tii yapano cojoya,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yucʉ decomacã muipũ cʉ̃ ca niiro ca paderã earicarã wapa jeerã earã, cʉ̃ja ca niiro cõro, jĩcã rʉmʉ paderique wapa cõropʉ wapa ñeeuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Jiro, ca paderã ea jʉoricarãre cʉ̃ ca wapa tiiri tabe ca earo, “Cʉ̃ja ametʉenero manire wapa tiirucumi,” ĩi tʉgoeñauparã. To biro cʉ̃ja ca ĩi tʉgoeñamijata cãare, cʉ̃ja cõrorena, jĩcã rʉmʉ paderique wapa cõrora wapa tiiupʉ cʉ̃ja cãare. ");
INSERT INTO baoNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Teere wapa jee, tiicãri, tii weje ʉpʉre o biro cʉ̃re ĩi wede paiuparã: ");
INSERT INTO baoNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Anija jiropʉ ca paderã eajãrã, jĩcã nimaroacã ca padejãrãrena, jãa, ʉmʉreco yoari rʉmʉ muipũ cʉ̃ ca ajicãro ca pade naio waajãrãre mʉ ca wapa tiiro cõrora mʉ wapa tiicã, mʉ añuti,” cʉ̃re ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","”To biro cʉ̃ja ca ĩiro tʉo, tii weje ʉpʉ pea jĩcʉ̃ cʉ̃ja mena macʉ̃re o biro cʉ̃re ĩiupʉ: “Yʉ mena macʉ̃, ñañaro mʉre tiigʉ méé yʉ tii. ‘Jĩcã rʉmʉ maquẽ mʉre yʉ wapa tiirucu,’ mʉre yʉ ca ĩijãrore birora mʉre yʉ wapa tii. ");
INSERT INTO baoNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Mʉre yʉ ca wapa tiijãrijere jee, tuacoagʉja. Ani mʉ jiropʉ ca padegʉ eajãgʉ cãare, mʉre yʉ ca wapa tiiro cõrora cʉ̃re yʉ wapa tiirʉga. ");
INSERT INTO baoNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Yʉ ca tiirʉgari wãme yʉ tii maji, yʉ yee wapa tiirica tiiri menare. ¿Ca bojoca añugʉ yʉ ca niirijere ĩa tutirã mʉja ĩiti?” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","”To biri mecʉ̃rire watoa macãrã ca niirã, ca nii majuropeerã niirucuma. Ñucã mecʉ̃rire ca nii majuropeerã ca niirã, watoa macãrã tʉarucuma —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jiro Jesús Jerusalén'pʉ waa nʉnʉa waagʉ, jãa, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirãre bojoricaro jãare jʉo cojori, o biro jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Mee, mʉja ca ĩarora Jerusalén'pʉ waarã mani bii. Yʉ, Ca Nii Majuropeegʉ Macʉ̃re ñeeri, paia ʉparãpʉre, doti cũuriquere jʉo bueri majapʉre noni cõa, yʉre tiirucuma. Cʉ̃ja pea yʉre jĩa cõa dotirã, ");
INSERT INTO baoNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","aperãpʉre noni cõacãrucuma, yʉre bui epe, yʉre bape, yucʉ tenipʉ yʉre paa pua tuu cõa, cʉ̃ja tiijato ĩirã. To biro cʉ̃ja ca tii yaiocãmijata cãare, itia rʉmʉ jiro yʉ cati tuacoarucu ñucã —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Jiro Zebedeo puna paco, cõ puna mena Jesús pʉto eari, cõ ãjʉro jupeari mena ea nuu eawo, jĩcã wãme cʉ̃re jãirʉgo. ");
INSERT INTO baoNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","To biro cõ ca biiro ĩa: —¿Ñee mʉ booti? —cõre ĩi jãiñawi Jesús. Cõ pea o biro cʉ̃re ĩiwo: —Mʉ ca doti niiri tabepʉre, yʉ punare jĩcʉ̃ mʉ díámacʉ̃ nʉña, apĩre mʉ ãcõ nʉña pee, cʉ̃jare mʉ ca duwi dotiro yʉ boo —cʉ̃re ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","To biro cõ ca ĩiro, Jesús pea o biro ĩi yʉʉwi: —Mʉja, mʉja ca jãirijere mʉja majiti. ¿Ñañaro peti yʉ ca tamʉo yaipe ʉnore mʉja ca tamʉojata, mʉja nʉcãcãrãti? —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —Ʉ̃gjá, jãa bii bayicãrucu —cʉ̃re ĩi yʉʉwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús pea o biro cʉ̃jare ĩi yʉʉwi ñucã: —Mʉja ca ĩirore birora ñañaro peti mʉja biirucu, biirãpʉa. Yʉ díámacʉ̃ nʉña, yʉ ãcõ nʉña, mʉja ca duwirʉgarije docare, yʉ, yʉ ca duwi dotipe méé nii. Tea yʉ Pacʉ, “To biro biirucuma,” cʉ̃ ca ĩiricarã cʉ̃ja ca duwipe nii —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jãa, Jesús buerã pʉa amo cõro ca niirã pea Santiago, Juan jãari to biro Jesús're cʉ̃ja ca ĩirijere tʉori, bʉaro cʉ̃ja mena jãa ajiawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jesús pea cʉ̃ pʉto pee jãare jʉo neo cojori, o biro ĩiwi: —Mee, mʉja maji. Ati yepa macãrã wiorã Ʉmʉreco Pacʉre ca majitirã, cʉ̃ja bojocare tutuaro mena cʉ̃ja ca dotirijere cʉ̃ja ca tii nʉnʉjeero booma. Ʉparã ca nii majuropeerã pea, cʉ̃ja ca doti niirije mena cʉ̃jare ĩi epecãma. ");
INSERT INTO baoNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mʉja pea to biro ca biitiparã mʉja nii. To biro biitirãra, mʉja watoare ca nii majuropeegʉ ca niirʉgʉ ʉnoa, aperãre pade nemori majʉre biro pee cʉ̃ niijato. ");
INSERT INTO baoNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ñucã mʉja watoare ca jʉo niigʉ ca niirʉgʉ ʉnoa, mʉjare ca pade coteri majʉre biro pee cʉ̃ niijato. ");
INSERT INTO baoNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","To birora, yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa, yʉre cʉ̃ja pade bojajato ĩigʉ méé yʉ doowʉ. Yʉ pee bojocare pade boja, ñucã paʉ ñañaro ca biirãre bii yai ametʉene boja, biigʉ doogʉ yʉ doowʉ —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jericó macãre ca niiricarã jãa ca witi waaro, paʉ bojoca jãare nʉnʉwa. ");
INSERT INTO baoNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Too jãa ca waaro, ca ĩatirã pʉarã maa pʉto ca duwiricarã, Jesús cʉ̃ ca ametʉa waaro tʉorã: —¡Wiogʉ, David Pãrami jãare boo paca ĩaña! —ĩi acaro buiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","To biro cʉ̃ja ca ĩiro, “Cʉ̃ja yerijãa waajato,” ĩirã, cʉ̃jare tutimiwa bojoca pea. To biro cʉ̃jare cʉ̃ja ca ĩi pacaro, bʉaro jañuro: —¡Wiogʉ, David Pãrami jãare boo paca ĩaña! —ĩi acaro buiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesús pea to biro cʉ̃ja ca ĩiro tʉori tua nʉcã, cʉ̃jare jʉo cojori, o biro cʉ̃jare ĩi jãiñawi: —¿Ñee ʉno mʉjare yʉ ca tiiro mʉja booti? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Cʉ̃ja pea, o biro cʉ̃re ĩi yʉʉwa: —Wiogʉ, jãa ca ĩaro mʉ ca tiiro jãa boo —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús pea cʉ̃jare boo paca ĩari, cʉ̃ja capere padeñawi. Cʉ̃ ca padeñarora ca ĩatimiricarã añuro ĩa, Jesús jiro nʉnʉcã doowa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén macãre ea waarã, Olivos Buuro pʉto ca niiri macã Betfagé tʉja waagʉ, ");
INSERT INTO baoNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Jesús, cʉ̃ buerã pʉarãre: —Ano díámacʉ̃ ca niiri macãpʉ waarãja. Toopʉ earã, burra jia nʉcõrico cõ macʉ̃ mena ca niigore mʉja bʉarucu. Cõre popiori mʉja ami doowa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Jĩcãrã, “¿Ñee tiirã mʉja popioti?” cʉ̃ja ca ĩijata, “Wiogʉ boomi. Yoari mééra mʉjare tuenecãrucumi ñucã,” cʉ̃jare mʉja ĩiwa —cʉ̃jare ĩi cojowi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Atea Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ: ");
INSERT INTO baoNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión macãrãre o biro ĩiña: ‘Ĩaña. Mʉja Wiogʉ mʉja pʉto pee doomi. Watoa macʉ̃re biro burro, waibʉcʉ ca apeye ũmago macʉ̃ jotoapʉ pejari doomi,’ ” cʉ̃ ca ĩi owa cũuquĩrique ca ĩirore biro to biijato ĩiro biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Cʉ̃ buerã pea waa, Jesús cʉ̃jare cʉ̃ ca ĩi cojoricarore biro tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burrare cõ macʉ̃acã menara cʉ̃jare jee doo, cʉ̃ja juti jotoa maquẽre cʉ̃ja jotoa tuu wee peori, Jesús're cʉ̃re peja dotiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Paʉ bojoca niiwa. Jĩcãrã maare cʉ̃ja yee juti jotoa maquẽ mena ejo cũu jʉgue, aperã yucʉ dʉpʉri paa jude jeeri cũu jʉgue, tii nʉnʉa waawa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","To biro tii nʉnʉa waarã, Jesús jʉguero ca waarã, cʉ̃ jiro pee ca doorã cãa, o biro ĩi acaro bui nʉnʉa waawa: —¡Añu majuropeecã, jãare ametʉeneña Wiogʉ David Pãrami! —¡Añuro ca biigʉ niimi, Ʉmʉreco Pacʉ wãme mena ca doogʉ! —¡Añu majuropeecã, jãare ametʉeneña ʉmʉreco tutipʉ ca niigʉ! —cʉ̃re ĩi baja peo nʉnʉa waawa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús, Jerusalén're cʉ̃ ca piyá ea waaro, tii macã macãrã niipetirãpʉra wede mecʉ̃rora waawa. To biri paʉ: —¿Ania, ñiru cʉ̃ niiti? —ameri ĩi jãiña niiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","To biro cʉ̃ja ca ĩi jãiñaro bojoca pea: —Jesús, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ, Galilea yepare ca niiri macã Nazaret macʉ̃ niimi —cʉ̃jare ĩi yʉʉwa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús, Ʉmʉreco Pacʉ yaa wiipʉ jãa waari, toopʉ noni wapa taa, wapa tii, ca tii niirã niipetirãre acu wienewi. Ñucã wapa tiirica tiiri wajoari maja cʉ̃ja ca duwiri pĩirire, bua noniri maja cʉ̃ja ca duwiri pĩirire, tuumicõa cõa cũu peoticãwi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","To biro tiicã, o biro cʉ̃jare ĩiwi: —Ʉmʉreco Pacʉ wederiquepʉ o biro ĩi owarique nii: “Yʉ yaa wii juu buerica wii wado niirucu,” ĩi. Mʉja pea, jee dutiri maja cʉ̃ja ca niiri ope mʉja jeeñocã —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesús, Ʉmʉreco Pacʉ yaa wiipʉ cʉ̃ ca niiro, ca ĩatirã, upa yuriri, cʉ̃ pʉto eawa. Jesús pea cʉ̃jare catiowi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Paia ʉparã, doti cũuriquere ca jʉo buerã pea, Jesús, ca ĩa ñaaña manirije cʉ̃ ca tii jeeñorijere ĩa, ñucã wimarã Ʉmʉreco Pacʉ yaa wiipʉre, “Añu majuropeecã Wiogʉ David Pãrami,” Jesús're cʉ̃ja ca ĩi acaro buirijere tʉo ajiari, ");
INSERT INTO baoNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","o biro ĩiwa Jesús're: —¿Ĩijã cʉ̃ja ca ĩirijere mʉ tʉoti? —cʉ̃re ĩiwa. To biro cʉ̃ja ca ĩiro, Jesús pea: —Ʉ̃jʉ, yʉ tʉo. ¿Mʉja, Ʉmʉreco Pacʉ wederique o biro cʉ̃ja ca ĩipe maquẽ cʉ̃ja ca owariquere mʉja bue ñaatiti? O biro ĩi: “Wimarã, ca ũpũrãacã, cʉ̃ja ca bajarije mena, mʉre cʉ̃ja ca baja peo nʉcʉ̃ bʉoro mʉ tii,” ĩi —cʉ̃jare ĩi yʉʉwi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","To biro cʉ̃jare ĩi yapano witi, waacoawi Jesús, Betania macãpʉ cãnigʉ waagʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ape rʉmʉ boeri tabe meepʉacã Jerusalén'pʉ waa nʉnʉa waagʉ, queya tʉgoeñaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","To biro bii nʉnʉa waagʉ, jĩcãgʉ higueragʉ maa pʉtoacã ca niiricʉre ĩa bʉari, tiigʉ dicare ĩagʉ waamiwi. Dica manirora, ca pũu wado ca niiro ĩa, o biro ĩiwi: —¡Pʉati mʉja dica cʉti nemotirucu! —ĩiwi. To biro cʉ̃ ca ĩirora, jĩcãto jinicã nʉcã waawʉ tiigʉ pea. ");
INSERT INTO baoNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","To biro ca biirijere ĩarã, jãa, cʉ̃ buerã pea ʉcʉacoari, o biro cʉ̃re jãa ĩi jãiñawʉ Jesús're: —¿Tiigʉ pea do biro biicãri, jĩcãto to jinicoajãri? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","To biro jãa ca ĩiro, o biro jãare ĩi yʉʉwi Jesús: —Yee méé mʉjare yʉ ĩi: “Mani ca ĩirore biro tiirucumi” yʉre ĩi tʉgoeña tutuacã, “Yeera mani ĩicãbocu” ĩi tʉgoeñati, mʉja ca biijata, higueragʉre yʉ ca tiijãrije ʉno wado méé mʉja tiirucu. Atigʉ ʉ̃tãgʉpʉ cãare: “Toore pĩa ũmaa waari, dia pairiyapʉ ñaañuaña,” mʉja ca ĩijata, mʉja ca ĩirore birora biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Juu buerã, “Mani ca jãirijere manire tiicojorucumi,” ĩi tʉgoeña bayiri mʉja ca jãijata, mʉja ca jãirije niipetiro mʉja tiicojo ecorucu —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jiro Ʉmʉreco Pacʉ yaa wiipʉ jãa waawi Jesús. Toopʉ bojocare cʉ̃ ca bue niiro, paia ʉparã, to biri judíos're ca jʉo niirã, cʉ̃ pʉto eari, o biro cʉ̃re ĩi jãiñawa: —¿Ñee doti majirique cʉocãri atere mʉ tiiti? ¿Ñiru tee doti majiriquere mʉre cʉ̃ tiicojori? —cʉ̃re ĩi jãiñawa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Jesús: —“Yʉ cãa, jĩcã wãme mʉjare yʉ jãiñarucu: ¿Ñiru Juan're cʉ̃ uwo coe doti cojoupari? ¿Ʉmʉreco Pacʉ? ¿Bojoca pee? Yʉre mʉja ca yʉʉjata, yʉ cãa, tee doti majirique mena atere to biro yʉ tii,” mʉjare yʉ ĩirucu —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —“Ʉmʉreco Pacʉ cʉ̃re doti cojoupi,” mani ca ĩi yʉʉjata, “¿ñee tiirã cʉ̃re mʉja tʉo nʉnʉjeetiri?” manire ĩirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ñucã, “Ati yepa macãrã cʉ̃re uwo coe doti cojoupa,” mani ĩi majiti. Bojocare mani uwi jañu. Mee niipetirãpʉra, “Juan, Ʉmʉreco Pacʉ yeere wederi majʉ niiwi,” ca ĩirã wado niima —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","To biri, “Jãa majiti,” cʉ̃re ĩi yʉʉwa Jesús're. To biro cʉ̃ja ca ĩiro: —Yʉ cãa, tee doti majirique mena, “Atere to biro yʉ tii,” mʉjare yʉ ĩiti —cʉ̃jare ĩi yʉʉwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","To biro ĩi yapano, o biro cʉ̃jare ĩi jãiñawi Jesús: —¿Do biro mʉja ĩiti mʉja atere? Jĩcʉ̃ pʉarã puna cʉtiupʉ. Cʉ̃ macʉ̃ jĩcʉ̃re o biro cʉ̃re ĩiupʉ: “Macʉ̃, mecʉ̃ra yʉ ʉje wejepʉ padegʉja,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","To biro cʉ̃ ca ĩiro, cʉ̃ macʉ̃ pea, “Yʉ waarʉgati,” cʉ̃re ĩiupʉ. To biro ca ĩiricʉ nii pacagʉ, jiro tʉgoeña wajoa, padegʉ waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","To biro cʉ̃ ca ĩiro tʉo, cʉ̃ macʉ̃ apĩ pʉto pee waa, to birora ĩiupʉ cʉ̃ cãare. Cʉ̃ pea, “Jaʉ, mecʉ̃acã yʉ waarucu,” cʉ̃re ĩiupʉ. To biro ca ĩiricʉ nii pacagʉ, padegʉ waatiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Niipe cʉ̃ja pacʉ cʉ̃ ca boorijere cʉ̃ tiijapari? —cʉ̃jare ĩi jãiñawi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —Cʉ̃ ca doti jʉoricʉ pee —cʉ̃re ĩi yʉʉwa. To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiwi Jesús: —Yee méé mʉjare yʉ ĩi: Roma maquẽre wapa jee bojari maja, to biri nomia, ʉmʉa mena ca tii epe wapa taarã romiri pee, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre mʉja jʉguero ea jʉorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Uwo Coeri majʉ Juan añurije tii niirique maquẽre mʉjare buegʉ doomiupi. Mʉja pea cʉ̃ ca ĩirijere mʉja tʉo nʉnʉjeetiupa. To biro mʉja ca biicãro, niirique wapare wapa jee bojari maja, to biri ʉmʉa mena ca tii epe wapa taarã romiri pea, cʉ̃re tʉo nʉnʉjeeupa. Mʉja pea ate niipetirijere ĩacã pacarã, cʉ̃ ca ĩirijere tʉo nʉnʉjeerʉgatirã, mʉja tʉgoeña wajoatiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","”Apeye ĩi cõoñarique tʉoya: Jĩcã yepa ʉpʉ, jĩcã weje ʉje weje oteri, tii wejere jãni jãa, ʉje oco dipericarore queno, tii weje niipetiropʉrena cʉ̃ja ca ĩa cote niipa wii cãare, emʉari wii queno yapano, aperãre tii wejere paderique cũu, aperopʉ waa yujugʉ waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Jiro, ʉje ca bʉcʉari cuu ca earo, cʉ̃re pade bojari maja jĩcãrãre tiicojoupʉ, tii wejere paderi majare cʉ̃ yee ca niirijere jãi doti cojogʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Tii weje paderi maja pea cʉ̃ ca doti cojoricarã cʉ̃ja ca earo, cʉ̃jare ñeeri, jĩcʉ̃re cʉ̃re quẽe, apĩra cʉ̃re jĩa cõacã, apĩ peera ʉ̃tã mena cʉ̃re dee, tiiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Jiro tii weje ʉpʉ, cʉ̃ pade bojari majare cʉ̃ ca tiicojo jʉoricarã ametʉenero tiicojoupʉ ñucã. Tii wejere paderi maja pea cʉ̃ ca tiicojo jʉoricarãre cʉ̃ja ca tiiricarore birora tiicãuparã ñucã cʉ̃ja cãare. ");
INSERT INTO baoNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","”Jiro, “Yʉ macʉ̃ra, yʉ macʉ̃ cʉ̃ ca niiro macã cʉ̃re nʉcʉ̃ bʉorucuma,” ĩi tʉgoeñari, cʉ̃ macʉ̃ majuro peere tiicojoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","”Paderi maja pea cʉ̃ macʉ̃ majurope cʉ̃ ca dooro ĩarã, o biro ameri ĩiuparã: “Anira niimi, cʉ̃ pacʉ cʉ̃ ca bii yairo jiro ati wejere ca cʉo nʉnʉjeepʉ. Cʉ̃re mani jĩa cõacãco. To biro tiirã, manirã ati weje ʉparã mani tuarucu,” ameri ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","To biri tii weje tʉjaropʉ cʉ̃re ñee witi waari, cʉ̃re jĩa cõacãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","”To biri yua, mʉja ca tʉgoeñajata, tii weje ʉpʉ tua eagʉ, ¿“Paderi majare, do biro cʉ̃jare tiirucumi” mʉja ĩi tʉgoeñati? —cʉ̃jare ĩi jãiñawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","To biro cʉ̃ ca ĩi jãiñaro, cʉ̃ja pea: —Ĩa mairicaro maniro, cʉ̃ja, ca bojoca ñañarãre jĩa batecã, aperã, ʉje ca dica cʉtiri cuu ca eari taberi cõro cʉ̃ yee ca niirijere cʉ̃re dica woo, ca tii niirã peere cʉ̃jare tiicojorucumi —ĩi yʉʉwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","To biro cʉ̃ja ĩiro, Jesús pea o biro cʉ̃jare ĩiwi: —¿Mʉja jĩcãti ʉno peera Ʉmʉreco Pacʉ wederiquere mʉja bue ñaatiti? O biro ĩi: “Ʉ̃tãga, wii bʉari maja cʉ̃ja ca beje cõamiricagara, ca nii majuropeerica nii ea. Ʉpʉ atere to biro tiiupi. Teere ĩarã, mani ĩi ĩa ʉcʉacoa,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","To biri o biro mʉjare yʉ ĩi: Ʉmʉreco Pacʉ cʉ̃ ca dotiri tabe macãrã mʉja ca niimirijere mʉjare ẽmari, aperã, ote ca bʉcʉari cuu ca earo, cʉ̃ yeere ca dica woo cojorã peere tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ñucã ʉ̃tãga mena peera, jĩcʉ̃ ʉno tiiga jotoa cʉ̃ ca ñaapeajata, doca jude batecã yai waarucumi. Ñucã tiiga pee, jĩcʉ̃ ʉnore to ca ñaapeajata, doca abo yaiocãrucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","To biro Jesús cʉ̃ ca ĩi cõoña wederijere tʉorã, paia ʉparã, to biri fariseos pea, cʉ̃jarena cʉ̃ ca ĩi cõoña wederijere tʉo majicãwa. ");
INSERT INTO baoNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","To biri Jesús're cʉ̃re ñeerʉgamiupa. To biro cʉ̃re tiirʉga pacarã, bojocare uwi jañuupa, “Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ niimi,” bojoca cʉ̃ja ca ĩigʉ cʉ̃ ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ñucã Jesús ĩi cõoñarique mena o biro ĩi wede jʉo waawi: ");
INSERT INTO baoNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃ wiogʉ, cʉ̃ macʉ̃ cʉ̃ ca amo jiari boje rʉmʉre quenogʉ cʉ̃ ca tiiricarore biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Cʉ̃re ca pade coterã mena, cʉ̃ ca jʉoricarãre jʉo doti cojoupʉ. Cʉ̃ ca jʉomiricarã pea doorʉgatiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jiro, aperã cʉ̃re ca pade coterã mena, cʉ̃ ca jʉoricarãre o biro cʉ̃jare ĩi doti nemo cojomiupʉ ñucã: “Mee, baariquere niipetiro queno yapanoriquepʉ yʉ cʉo. Yʉ wecʉa, aperã waibʉcʉrã, añuro ca díí cʉtirã yʉ jĩa dotijãwʉ. Mee, niipetiro queno yapanoriquepʉ nii. ¡Ñee pee dʉjati! ‘Yoari méé boje rʉmʉ dooya,’ ĩi wede dooya,” cʉ̃jare ĩi doti cojomiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Cʉ̃ ca jʉomiricarã pea cʉ̃re yʉʉtiuparã. Jĩcʉ̃ cʉ̃ja mena macʉ̃ cʉ̃ wejeri pee waacoaupʉ. Apĩ pea cʉ̃ ca padero pee waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Aperã pea wiogʉ ʉmʉare cʉ̃jare ñeeri, ñañaro cʉ̃jare tii, cʉ̃jare jĩa bate, tiicãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","”Wiogʉ pea teere tʉo ajiari, bojoca jĩari majare jĩa batecã, cʉ̃ja yaa macã cãare joe cõacã, tii doti cojoupʉ cʉ̃ uwamarãre. ");
INSERT INTO baoNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jiro, cʉ̃ ʉmʉare o biro ĩiupʉ ñucã: “Boje rʉmʉ maquẽ ñee ʉno pee dʉjati. Yʉ ca jʉomijãrã pea ca dooparã ʉno méé niijapa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","To biri wiijeri watoa macã maaripʉ waari, noo mʉja ca bʉa earã cõrorena jʉorãja,” cʉ̃jare ĩi cojoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","”To biro cʉ̃ ca ĩiricarã, cʉ̃ ʉmʉa pea wiijeri watoa macã maaripʉ waari, noo cʉ̃ja ca bʉa earã niipetirãre, añurã, ñañarãre jʉo neouparã. To biri boje rʉmʉ cʉ̃ ca quenopa jawire bojoca dadacoauparã. ");
INSERT INTO baoNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Jiro wiogʉ, cʉ̃ ca jʉo cojoricarãre ĩagʉ jãa waagʉ, jĩcʉ̃, amo jiarica boje rʉmʉ maquẽ mééra juti jãñari ca niigʉre ĩaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Cʉ̃re ĩari: “Yʉ mena macʉ̃, ¿amo jiarica boje rʉmʉ maquẽ juti jãñati pacagʉ, do biro biicãri anopʉre mʉ jãa doojãri?” cʉ̃re ĩiupʉ. To biro cʉ̃ ca ĩiro, wedetiupʉ cʉ̃ pea. ");
INSERT INTO baoNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","To cõrora wiogʉ pea, bojocare baarique batori majare o biro ĩiupʉ: “¡Anire ñeeri, cʉ̃ amori, cʉ̃ dʉpori jiari, õo macã ca naitĩaropʉ cʉ̃re cõa wienecã cojoya! Too ca naitĩaropʉre oti, cʉ̃ upire baca dʉpo, cʉ̃ ca bii bʉañapa tabepʉ,” ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Biirãpʉa paʉ niima, Ʉmʉreco Pacʉ cʉ̃ ca jʉorã. Cʉ̃ ca beje jeerã pea, paʉacã méé niima —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ate jiro fariseos waari, Jesús're wedejãarʉgarã, jĩcã wãme Jesús cʉ̃ ca ĩi maa wijiaro cʉ̃ja ca tiipere ameri wede peniupa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","To biro ameri ĩicãri, jĩcãrã cʉ̃ja mena macãrãre, Herodes yaarã mena o biro cʉ̃jare ĩi doti cojoupa: —Buegʉ, díámacʉ̃ ca niirije ca ĩirore biro ca tiigʉ nii, Ʉmʉreco Pacʉ cʉ̃ ca boorore biro niiriquere díámacʉ̃ ca niirijere ca ĩirore biro wede, mʉ ca tiirijere jãa maji. Ñucã bojoca cʉ̃ja ca bii ĩño niirijerena ca ĩa nʉnʉjeetigʉ niiri, bojoca cʉ̃ja ca ĩirijerena tʉo nʉnʉjee, mʉ tiiti. ");
INSERT INTO baoNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","To biri mʉ ca tʉgoeñari wãmere jãare wedeya. ¿Wiogʉ romanore niirique wapa jãa ca wapa tiirucurije to añu jañuti? ¿To añutitiqué? —cʉ̃re ĩi jãiñawa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús pea ñañari wãme tʉgoeñacãri cʉ̃ja ca ĩirijere majiri, o biro cʉ̃jare ĩi yʉʉwi: —Watoara ca bii dito pairã, ¿ñee tiirã, “Ñañaro cʉ̃ ĩi bui cʉtijato,” ĩi tʉgoeñarique mena yʉre mʉja jãiñati? ");
INSERT INTO baoNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wiogʉre mʉja ca wapa tiirucuri tiire yʉre ĩñoñaaqué —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro, jĩcã tii cʉ̃re noniwa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Tii tiire amiri: —¿Ati tiire ñiru diámacʉ̃, ñiru wãme, owa tuurique to tujati? —cʉ̃jare ĩi jãiñawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","To biro cʉ̃ ca ĩi jãiñaro, cʉ̃ja pea: —Wiogʉ César yee tuja —cʉ̃re ĩi yʉʉwa. To biro cʉ̃ja ca ĩiro, Jesús pea: —To docare César yee ca niirijere César're tiicojoya. Ʉmʉreco Pacʉ yee ca niirijere Ʉmʉreco Pacʉre tiicojoya —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","To biro cʉ̃ ca ĩiro tʉorã, ñee pee ĩiticãwa. To biri witi, cʉ̃re waa weocoawa yua. ");
INSERT INTO baoNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ñucã tii rʉmʉrena jĩcãrã saduceos Jesús're ĩarã dooupa. Ména cʉ̃ja pea: “Ca bii yaicoaricarãpʉa, pʉati cati tuaticuma,” ca ĩi niirucurã niiri, ati wãme cʉ̃re ĩi eawa Jesús're: ");
INSERT INTO baoNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Buegʉ, Moisés niiquĩricʉ: “Jĩcʉ̃, puna manigʉra cʉ̃ ca bii yaijata, cʉ̃ niiquĩricʉ bai pee, cʉ̃ nʉmo ca niiricore nʉmo cʉtirucumi, cʉ̃ jũwʉre puna cʉti bojarʉgʉ,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To biri, ano jãa watoare jĩcãti niiwa jĩcʉ̃ puna jĩcã amo peti, ape amore pʉaga penituaro niirã. Ca nii jʉogʉ nʉmo cʉti jʉomiupi. Puna manigʉra bii yaicoaupi. Ca puna maniricʉ niiri, cʉ̃ bai peere cũu yaiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Cʉ̃ cãa to birora bii, ñucã cʉ̃ jiro macʉ̃ cãa to birora bii, niipetirãpʉra to biro wado biicãupa. Cʉ̃ja jĩcã amo peti, ape amore pʉaga penituaro ca niimiricarãpʉra, to biro wado bii yai peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Cʉ̃ja niipetirã jiro cʉ̃ja nʉmo ca niimirico cãa bii yaicoaupo. ");
INSERT INTO baoNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","To biri yua, cati tuarica tabe ca niiropʉre, ¿anija jĩcʉ̃ puna jĩcã amo peti, ape amore pʉaga penituaro ca niiricarã niipetirã cʉ̃ja ca nʉmo cʉtimirico pea, nii nʉmo pee cõ niigoti yua? —ĩi jãiñawa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Jesús: —Mʉja, Ʉmʉreco Pacʉ wederiquere, cʉ̃ ca tutuarijere, mʉja majiti. To biri no ca boorora mʉja ĩi maa wijiacã. ");
INSERT INTO baoNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bojoca ca bii yairicarã cati tuarãpʉa ʉmʉa, nomia, manʉ cʉti, nʉmo cʉti, tiitirucuma. Ʉmʉreco tutipʉ ca niirã, Ʉmʉreco Pacʉ pʉto macãrãre biirã niicãrucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Apeyera ñucã ca bii yairicarã cʉ̃ja ca cati tuarije maquẽre, ¿Ʉmʉreco Pacʉ majuropeera, ");
INSERT INTO baoNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yʉa, Abraham, Isaac, Jacob jãari Ʉmʉreco Pacʉ yʉ nii,” cʉ̃ ca ĩiriquere mʉja bue ñaatiti? Cʉ̃a, ca bii yairicarã Ʉmʉreco Pacʉ méé niimi. Ca catirã Ʉmʉreco Pacʉ niigʉ biimi —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","To biro Jesús cʉ̃ ca ĩi wederijere tʉorã, bojoca pea ñee pee ĩiticãwa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jesús, saduceos're do biro cʉ̃ja ca ĩi majitiropʉ cʉ̃jare cʉ̃ ca ĩiriquere majicãri, fariseos neaupa ñucã, ameri wede penirʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Jĩcʉ̃ cʉ̃ja mena macʉ̃, doti cũuriquere ca jʉo buegʉ, “Ñañaro cʉ̃ ĩi bui cʉtijato” ĩigʉ, o biro ĩi jãiñawi Jesús're: ");
INSERT INTO baoNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Buegʉ, ¿dije to niiti doti cũurique ca nii majuropeerije? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉwi Jesús: —“Ʉpʉ mʉ Ʉmʉreco Pacʉre mʉ yeri niipetiro mena, mʉ ca tʉgoeñarije niipetiro mena, mʉ ca cati niirije niipetiro mena, cʉ̃re maiña,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ate nii, ca nii majuropeerije doti cũurique niipetirore ca jʉo niirije. ");
INSERT INTO baoNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ate jiro ca dotiri wãme cãa teere bii jañurora nii. O biro ĩi: “Mʉ upʉre mʉ ca mairore birora maiña mʉ pʉto macʉ̃re,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ate pʉa wãme nii, doti cũuquĩrique niipetirore, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca buerique niipetirore, ca jʉo nii majuropeerije —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","42","Ména, fariseos toora cʉ̃ja ca nea poo niiro, o biro cʉ̃jare ĩi jãiñawi Jesús. —¿Mʉja do biro mʉja ĩi tʉgoeñati Mesías're? ¿Ñiru pãrami niimi mʉja ĩiti? —ĩi jãiñawi. To biro cʉ̃ ca ĩiro: —David pãrami niimi —cʉ̃re ĩi yʉʉwa. ");
INSERT INTO baoNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiwi Jesús: —To docare, ¿ñee tiigʉ David majuropeera, Añuri Yeri cʉ̃re cʉ̃ ca majiorije jʉori “Yʉ Wiogʉ,” cʉ̃re cʉ̃ ĩiquĩupari? O biro ĩiupi David: ");
INSERT INTO baoNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Ʉpʉ o biro ĩiwi yʉ Wiogʉre: ‘Ano, yʉ díámacʉ̃ nʉña pee duwiya ména, mʉ waparãre cʉ̃ja ca doca cũmuro yʉ ca tiiropʉ,’ cʉ̃re ĩiwi.” ");
INSERT INTO baoNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","To docare ¿Mesías, do biro pee biicãri, David pãrami cʉ̃ niibogajati, David majuropeera “Yʉ Wiogʉ,” cʉ̃ ca ĩimijata cãare? —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","To biro cʉ̃ ca ĩiro, jĩcʉ̃ ʉno peera jĩcã wãme ʉnora cʉ̃re yʉʉ cojorucu tiitiwa. To biri tii rʉmʉ mena jĩcʉ̃ ʉno peera apeye cʉ̃re jãiña nemotiwa yua. ");
INSERT INTO baoNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ate jiro Jesús, bojocare, jãa cʉ̃ buerãre, o biro ĩi wedewi: ");
INSERT INTO baoNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Doti cũuriquere ca jʉo buerã, fariseos, Moisés cʉ̃ ca doti cũurique ca ĩirijere ca wede majiorã niima. ");
INSERT INTO baoNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","To biri mʉja, cʉ̃ja ca ĩirijere tʉo nʉnʉjee, cʉ̃ja ca tii dotirije niipetirore tii nʉnʉjee, tiiya. To biro bii pacarã, cʉ̃ja ca tii niirije pee docare cʉ̃jare biro tiiticãña. Cʉ̃ja, “O biro ca bii niiparã mani nii,” ca ĩirã nii pacarã, cʉ̃ja ca ĩirore biro tiitima. ");
INSERT INTO baoNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bʉaro ca nʉcʉ̃rijere, do biro ca tii jee waa majiña manirije ʉnore ca jia peorãre biro tiirique cʉtima, cʉ̃ja ca buerije mena. To biro ĩi pacarã, cʉ̃ja pea jĩcã wãmeacã ʉno peerena tii nʉnʉjeerʉgati majuropeecãma. ");
INSERT INTO baoNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","”Ate niipetirije tiima, “Bojoca jãare cʉ̃ja ĩa nʉcʉ̃ bʉojato,” ĩirã. Cʉ̃ja diámacʉ̃ripʉ, ñucã cʉ̃ja dicaripʉ ejari quejeri bʉcʉ tiicãri, Ʉmʉreco Pacʉ wederique cʉ̃ja ca owa tuurica daarire dʉdʉa tuu, ñucã cʉ̃ja juti yapari cãare paca sitiri ee tuu doo nemocãri jãña yujuma. ");
INSERT INTO baoNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nea poo juu buerica wiijeripʉ cãare wiorã cʉ̃ja ca duwirije ʉnopʉ wado duwirʉga, baarica taberi cãare añuri taberipʉ baa duwirʉga, ");
INSERT INTO baoNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ñucã macã decomacã macã yeparipʉ cʉ̃ja ca amejuajata cãare, bojoca, nʉcʉ̃ bʉorique mena cʉ̃jare jãi nʉcʉ̃ bʉo, “Jãare ca buerã,” cʉ̃jare ĩi, ĩi nʉcʉ̃ bʉoriquere booma. ");
INSERT INTO baoNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mʉja pea, “Jãare ca buerã,” bojoca mʉjare cʉ̃ja ca ĩi nʉcʉ̃ bʉorije ʉnore amaaticãña. Mʉja niipetirãpʉra jĩcʉ̃ punaarã nii, jĩcʉ̃ra mʉjare ca bue majiogʉre cʉo, mʉja bii. ");
INSERT INTO baoNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ñucã ati yepare jĩcʉ̃ ʉno peerena, “Cáacʉ,” ĩiticãña. Jĩcʉ̃ra niimi mʉja Pacʉ, ʉmʉreco tutipʉ ca niigʉ wado. ");
INSERT INTO baoNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Aperã mʉjare, “Jãare ca buegʉ,” cʉ̃ja ca ĩirije ʉno cãare amaaticãña. Jĩcʉ̃ra niimi mʉjare ca buegʉ, Cristo wado. ");
INSERT INTO baoNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Mʉja watoare, ca nii majuropeegʉ ca niigʉa, ca pade cotegʉre biro pee cʉ̃ niijato. ");
INSERT INTO baoNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Cʉ̃ majuropeera, “Ca nii majuropeegʉ yʉ nii” ca ĩigʉa, watoa macʉ̃re biro ĩa ecorucumi, “Watoa macʉ̃ yʉ nii,” ca ĩigʉ pea, ca nii majuropeegʉ niirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","”Ñañaro biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã, aperã Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre ca waarʉgarãre, ca boca jope bia camota niirãre. Mʉja majuropeecã jãa waa majiti, ñucã ca jãa waarʉgarã cãare, cʉ̃jare jõeneti, mʉja bii. ");
INSERT INTO baoNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","¡Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã! Ca wapearã romiri yaa wiijerire ca ẽmarã nii pacarã, tii ditorã, yoaro mʉja juu buecã dia nuu waarucu. Ate jʉori, ametʉenero ñañaro mʉja tii ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","¡Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã! Dia paca yaaripʉ, yeparipʉ, mʉja waa nucũ yuju, jĩcʉ̃acã mʉja ca wederijere ca tʉo nʉnʉjeepʉ bʉarʉgarã, cʉ̃re bʉacãrãpʉa, mʉja ametʉenero ñañagʉ, pʉati cõropʉ pecame ca ʉ̃ʉ yatitiri pecamepʉ ca ʉ̃ʉpʉ cʉ̃ ca niiro mʉja tiicã. ");
INSERT INTO baoNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","”Ñañaro peti mʉja biirucu mʉja, ca ĩatirã nii pacarã, bojocare ca jʉo waarãre biro ca niirã. O biirije mʉja ĩi wederucu: “Jĩcʉ̃ ʉno, ‘Ʉmʉreco Pacʉ yaa wii mena yʉ ĩi,’ cʉ̃ ca ĩijata, cʉ̃ ca ĩirore biro cʉ̃ ca tiiticãjata cãare bʉaro biiti. ‘Ʉmʉreco Pacʉ yaa wii maquẽ oro mena yʉ ĩi,’ cʉ̃ ca ĩijata docare, cʉ̃ ca ĩirore birora tii majimi,” mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ca ĩa bojoca catitirã, ¿dije pee to niiti ca nii majuropeerije, oro pee, Ʉmʉreco Pacʉ yaa wii, orore añurije ca tuaro ca tiiri wii pee? ");
INSERT INTO baoNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ñucã o biirije mʉja ĩi: “Jĩcʉ̃ ʉno, ‘Waibʉcʉrãre joe mʉenerica tutu mena yʉ ĩi,’ cʉ̃ ca ĩijata, bʉaro biiti. ‘Tii tutu jotoa ca pejarije mena yʉ ĩi,’ cʉ̃ ca ĩijata docare, cʉ̃ ca ĩiricarore birora tii majimi,” mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ca ĩa bojoca catitirã, ¿ñee pee to niiti ca nii majuropeerije, tiicojo nʉcʉ̃ bʉorique pee, waibʉcʉrã joe mʉenerica tutu, tiicojo nʉcʉ̃ bʉoriquere, añurije ca tuaro ca tiiri tutu pee? ");
INSERT INTO baoNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","“Waibʉcʉrã joe mʉenerica tutu mena yʉ ĩi” ca ĩigʉa, tii tutu wado méére ĩigʉ tiimi; tii tutu jotoa ca pejarije niipetiro menare ĩigʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","“Ʉmʉreco Pacʉ yaa wii mena yʉ ĩi” ca ĩigʉ cãa, tii wii wado méére ĩigʉ tiimi. Ʉmʉreco Pacʉ tii wiipʉ ca niigʉ menarena ĩicãgʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ñucã “Ʉmʉreco quejero mena yʉ ĩi” ca ĩigʉ cãa, Ʉmʉreco Pacʉ cʉ̃ ca duwiri taberena, ñucã Ʉmʉreco Pacʉ toopʉ ca duwigʉ menarena ĩicãgʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","”¡Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã! Ʉmʉreco Pacʉ yee ca niipere, pũu ca jʉti añurijere, pʉa amo cõro ca niirijere jĩcã tabe ca jee dica woocãrã nii pacarã, doti cũurique ca ĩirije ca nii majuropeerije, añurijere, boo paca ĩariquere, ca niirore biro tii nʉnʉa waarique peera, mʉja tii nʉnʉjeeti. Atere ca tii niiparã mʉja nii, apeye pee cãare tii yerijãatirãra. ");
INSERT INTO baoNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Ca ĩatirã nii pacarã ca jʉo waarã! Becoacã peera weo cõacã pacarã, camello peera upʉra mʉja uu yuucã cojo. ");
INSERT INTO baoNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","”¡Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã! Jinirica bapare, jotʉ bapare, jotoa peera coecã pacarã, jee duti, cʉo pacarã pai jañuro boo jãa waa, mʉja ca biirije peera, “To biro jãa tiicu,” mʉja ĩiti. ");
INSERT INTO baoNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseos, ca ĩatirã! Jinirica bapare, jotʉ bapare, jupea peere coe jʉoya. To biro mʉja ca tiiro, jotoa pee cãare õweri manirije tuarucu. ");
INSERT INTO baoNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","”¡Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã! Maja operire, ca botirije mena wadarique, bau niiro peera añuro wãmoriquere biro nii pacarã, jupea peera ca bii yairicarã owa, ca boarije, ca niirore biro ca niirã. ");
INSERT INTO baoNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Teere birora mʉja cãa, bau niiro peera ca bojoca añurãre biropʉ mʉja baucã. Bii pacarã mʉja yeri peera, ca bojoca añurãre biro mʉja ca bii ditorije, ñañarije mʉja ca tʉgoeñarije, nii ametʉenecã. ");
INSERT INTO baoNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","”¡Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã, fariseos, watoara ca bii dito pairã! Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja niiquĩricarã maja operire queno, ca bojoca añurã ca niiquĩricarãre cʉ̃jare biirã cʉ̃ja ca wee nʉcõricarãre wãmo, ca tii niirãre. ");
INSERT INTO baoNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","To biro tiicãri, o biro mʉja ĩi: “Mani pea, mani ñicʉ̃ jãa cʉ̃ja ca niirica cuupʉre mani ca niijata, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare mani jãara cʉ̃jare mani jĩa nemotibojacupa,” mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","”To biro mʉja ca ĩirije mena, “¡Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare ca jĩa batericarã pãramerã peti mani nii!” ĩirã mʉja tii. ");
INSERT INTO baoNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To biri mʉja ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo dooriquere tii yapanocãña. ");
INSERT INTO baoNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Aña! ¡Añaa punaa! ¿Do biro pee tiicãri, pecame ca ʉ̃ʉ yatitiri pecamepʉ ñañaro mʉja ca biipere mʉja duti majirãti? ");
INSERT INTO baoNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","To biri Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare, ca majirãre, ca jʉo buerãre, mʉjare yʉ tiicojorucu. To biro yʉ ca tiirãre mʉja pea, jĩcãrã cʉ̃ja mena macãrãre jĩa, yucʉ teniripʉ cʉ̃jare paa pua tuu cõa, aperãra nea poo juu buerica wiijeripʉra cʉ̃jare bape, ñucã ñañaro tiirʉgarã macãri ca niiro cõro cʉ̃jare nʉnʉ yuju, mʉja biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","To biro mʉja ca tiirije jʉori, niipetirã bojoca añurãre ati yepare mʉja ca jĩa díi tii baterique, ca ñañarije manigʉ Abel niiquĩricʉ díi menapʉra, ñucã Berequías macʉ̃ Zacarías're, Ʉmʉreco Pacʉ cʉ̃ ca bojoca cʉti niiri wii, to biri waibʉcʉrã joe mʉenerica tutu watoare mʉja ca jĩaricʉ díi wapa menapʉ ñañaro mʉja ca tamʉope niirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Díámacʉ̃ mʉjare yʉ ĩi: Ate niipetirije wapa, bojoca ati cuu macãrãpʉre ñañaro cʉ̃jare bii ñaapea earucu. ");
INSERT INTO baoNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","”¡Jerusalén, Jerusalén, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare jĩa, Ʉmʉreco Pacʉ, queti wederi maja mʉre cʉ̃ ca tii cojorãre ʉ̃tã mena dee jĩa, mʉ tii! ¡Jĩcãti méé mʉ bojocare ãboco cõ punare cõ quedʉpʉri doca cõ ca jee neorore biro, cʉ̃jare yʉ jee neorʉgamiwʉ! ¡Cʉ̃ja pea bootiwa! ");
INSERT INTO baoNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ĩaña. Mʉja ca niimiri tabe bojoca maniri tabe tuarucu. ");
INSERT INTO baoNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Mecʉ̃ menare pʉati yʉre mʉja ĩa nemotirucu, “Añuro ca biigʉ niimi, Ʉmʉreco Pacʉ wãme mena ca doogʉ,” mʉja ca ĩiri rʉmʉ ca earopʉ mʉjare yʉ ĩi —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesús Ʉmʉreco Pacʉ yaa wiipʉ ca niiricʉ witi waa, mee waagʉ doogʉ cʉ̃ ca biiri tabera, jãa, cʉ̃ buerã pea cʉ̃ pʉto waari, Ʉmʉreco Pacʉ yaa wiire cʉ̃ja ca tiirica wiijerire cʉ̃ cãa cʉ̃ ĩajato ĩirã, cʉ̃re ĩñorʉgarã cʉ̃ pʉto jãa waawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Cʉ̃ pea o biro ĩiwi: —¿Ate niipetirijere mʉja ĩati? Díámacʉ̃ra mʉjare yʉ ĩi: Ano ca niirije jĩcãga ʉ̃tãga peera, apega jotoa pejaricaro maniropʉ tii yaio ecocoarucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jiro Olivos buuropʉ jãa waacoawʉ. Toopʉ ea, Jesús cʉ̃ ca ea nuu waaro ĩa, cʉ̃ pʉto waari, jãa wado o biro cʉ̃re jãa ĩi jãiñawʉ: —Jãare mʉ ca ĩijãrijere jãare mʉ ca wedero jãa boo. ¿Tea no cõropʉ to biiroti? ¿Mʉ ca tua doori rʉmʉre, ñucã ati ʉmʉreco ca petipere, do biirije to bii ĩño jʉgueroti? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","To biro jãa ca ĩiro, Jesús pea o biro jãare ĩi wede majiowi: —Bojoca catiri niiña, jĩcʉ̃ ʉno peera mʉjare cʉ̃ja ca ĩi ditotipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Paʉ doorucuma. Yʉ wãme mena ĩicãri, o biro ĩirucuma: “¡Yʉra yʉ nii, Mesías!” ĩiri, paʉ bojocare ĩi ditorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Aperoripʉ cʉ̃ja ca ameri jĩarijere, “Ameri jĩarique niirucu” cʉ̃ja ca ĩirijere, mʉja queti tʉorucu. Biirãpʉa, teere tʉo ʉcʉaticãña. To biirijera ca biipe niiro bii. To bii pacaro ati ʉmʉreco petiro méé biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Jĩcã pooga macãrã, ape pooga macãrã mena ameri jĩa, jĩcã yepa macãrã ape yepa macãrã mena ameri jĩa, tiirucuma. Ñucã paʉ taberipʉre aʉa boarique, ca jita jaberije, biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ate niipetirije, ñañaro tamʉorique bii jʉo nʉnʉa waaro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","”To biri mʉja peera, aperãpʉre mʉjare tiicojorucuma, ñañaro mʉjare tii, mʉjare jĩa bate, cʉ̃ja tiijato ĩirã. Yʉ yee jʉori, niipetirã mʉjare ĩa tutirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","To biro ca biiri cuure yʉre ca nʉnʉrã paʉ yʉre tʉo nʉnʉjee yerijãa, cʉ̃ja majuropeera ameri ĩa tuti, ameri wedejãa buiyee cõa, tiirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Paʉ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare biro bii dito eari, paʉre ĩi ditorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ñañarije tiirique bʉaro jañuro ca bii nʉnʉa waaro macã, paʉ bojoca cʉ̃ja ca ameri maimiriquere ameri mai yerijãacãrucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","To biro ca biirije watoara ca tʉgoeña tutua yapanocãgʉa ametʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ate añurije queti Ʉmʉreco Pacʉ cʉ̃ ca doti niirije maquẽre, ati yepa niipetiropʉre wede bato peoticãrique niirucu, bojoca poogaari cõrora cʉ̃ja ca tʉo peticãpere biro ĩirã. To cõropʉ docare ati ʉmʉreco petirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","”Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Daniel niiquĩricʉ, “Ʉmʉreco Pacʉ yaa wiire, ca Ñañarije Maniri Jawipʉre ĩaricaro docuorijere mʉja ĩarucu,” ĩi owaquĩupi. Atere ca buegʉ tʉo majiña. ");
INSERT INTO baoNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Teere ĩarã, Judea ca niirã ʉ̃tã yucʉpʉ cʉ̃ja duti waajato. ");
INSERT INTO baoNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Wii jotoapʉ ca niigʉ cãa, cʉ̃ yaa wii maquẽ apeyere jeegʉ duwi waatigʉra cʉ̃ waacoajato. ");
INSERT INTO baoNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ñucã wejepʉ ca niigʉ cãa, cʉ̃ juti ʉnorena cʉ̃ jeegʉ tua waaticãjato. ");
INSERT INTO baoNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tii rʉmʉrire ñañaro peti biirucuma nomia, ca puna jãñarã, ñucã ca ũpũrãacã, ca puna cʉtirã romiri. ");
INSERT INTO baoNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","To biri Ʉmʉreco Pacʉre jãiña, mʉja ca dutiri rʉmʉri pue bʉcʉ, yerijãarica rʉmʉ, ca niitipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tii rʉmʉrire bʉaro peti ñañaro biirique niirucu. Bʉaropʉra ñañaro peti tamʉorique ati yepa ca nii jʉori tabepʉra jĩcãti ʉno peera ca biitirique, ñucã jiro ca bii nemotipe biro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","To biirije ca biiri rʉmʉrire Ʉmʉreco Pacʉ cʉ̃ ca dʉotijata, jĩcʉ̃ ʉno peera catitibocuma. Cʉ̃ ca beje jeericarãre maima ĩigʉ, dʉorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","”To biri jĩcʉ̃ ʉno mʉjare, “¡Ĩaña! Ani niimi Mesías.” “¡Ĩaña! Ĩi pee niimi,” cʉ̃ja ca ĩimijata cãare, cʉ̃jare tʉo nʉnʉjeeticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Paʉ mesías're biro ca bii ditorã, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare biro ca bii ditorã, doorucuma. Paca wãmeri tii bau nii, ca ĩa ñaaña manirije tii jeeño, tiirucuma, ĩi ditorʉgarã. Ʉmʉreco Pacʉ cʉ̃ ca beje jeericarã menapʉrena ĩi ditorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Mee mʉjare yʉ wede majio jʉguecã. ");
INSERT INTO baoNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","”To biri: “Ĩaña. ¡Ca yucʉ maniri yepapʉ niimi!” mʉjare cʉ̃ja ca ĩimijata cãare, waaticãña. Ñucã: “¡Ĩaña! Anopʉ duti duwijapi,” mʉjare cʉ̃ja ca ĩimijata cãare, díámacʉ̃ cʉ̃jare tʉoticãña. ");
INSERT INTO baoNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yʉ, Ca Nii Majuropeegʉ Macʉ̃ yʉ ca doori rʉmʉa, muipũ cʉ̃ ca mʉa doori nʉña pee bʉpo cʉ̃ ca yabe cojorije, muipũ cʉ̃ ca ñaajãa waari nʉñapʉ ca boe ãpõtĩocã cojorore biro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ca bii yairicʉ cʉ̃ ca niiri tabere, yucáá wʉʉ nea poorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","”Ñañaro tamʉorica rʉmʉri ca bii yapano waari tabera: “Muipũ ʉmʉreco macʉ̃ naitĩacoa, ñami macʉ̃ cãa boeti, ñocõa ʉmʉreco tutipʉ ca niirã cãa ñaabatecoa, ñucã ʉmʉreco tutipʉre ca niirã ca tutuarã yugui peticoa, biirucuma.” ");
INSERT INTO baoNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","”To biro ca biiri tabera, yʉ, Ca Nii Majuropeegʉ Macʉ̃re ca bii ĩño jʉguerije ʉmʉreco tutipʉre baua earucu. To cõrora ati yepa macãrã bojoca poogaari niipetirã bʉaro uwirique mena oti, yʉ, Ca Nii Majuropeegʉ Macʉ̃, bueri bʉrʉri jotoa yʉ ca tutuarije mena, yʉ ca boe baterije mena, yʉ ca dooro ĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yʉ pea yʉ yaarã Ʉmʉreco Pacʉ pʉto macãrãre, putirica wʉʉ putiricaro ca bʉjʉrije menara cʉ̃jare yʉ tiicojorucu, yʉ ca beje jeericarã ati ʉmʉreco niipetiropʉ ca niirãre cʉ̃ja neojato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","”Higueragʉ ca biirijere ĩa cõoña majiña. Tiigʉ dʉpʉri, abari dʉpʉriacã bii, wãma pũu wajoa, ca biirijere ĩarã, “Mee cʉ̃ma jʉguero niicoaro bii,” mʉja ĩi ĩa maji. ");
INSERT INTO baoNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","To biri wãmera ate niipetirije ca biiro ĩarã, “Mee Ca Nii Majuropeegʉ Macʉ̃ ati yepapʉre doogʉpʉ biimi,” mʉja ĩi majirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Yee méé yʉ ĩi: Ati cuu macãrã cʉ̃ja ca bii yaiparo jʉguero biirucu, niipetirije ano mʉjare yʉ ca ĩirije. ");
INSERT INTO baoNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ati ʉmʉreco, ati yepa, peticoarucu. Yʉ wederique pea, yʉ ca ĩirore birora biicõa niirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","”Biiropʉa tii rʉmʉ ca niiro, too muipũ cʉ̃ ca niiro, “To biro biirucu” ĩiriquepʉra, jĩcʉ̃ ʉno peera majitima. Ʉmʉreco Pacʉ pʉto macãrã peti cãa, ñucã yʉ, cʉ̃ Macʉ̃ cãa, yʉ majiti. Ʉmʉreco Pacʉ wado majimi. ");
INSERT INTO baoNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","”Noé cʉ̃ ca niiri cuupʉre ca biiquĩricarore biro biirucu, yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca tua doori rʉmʉre. ");
INSERT INTO baoNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tii cuupʉre, ati yepa ca duaparo jʉguero, baarã, jinirã, amojiarã, ameri nomi cũurã, tii niiquĩupa. Noé, cũmua pairicapʉ cʉ̃ ca ea jãari rʉmʉpʉ bojoca to biro tii eyoupa. ");
INSERT INTO baoNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","“To biro biibocu” ĩiri méé cʉ̃ja ca bii niiri tabera ca duurije doo, niipetirãpʉrena duu bate yaio peticãquĩupa. To biri wãmera biirucu yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca tua doori rʉmʉ cãa. ");
INSERT INTO baoNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","”To biro ca biiri tabere, pʉarã ʉmʉa wejepʉ ca niirã, jĩcʉ̃ ami waa eco, ãpĩa ami waa ecoti, biirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ñucã pʉarã nomia ca wãñia niirã, jĩcõ ami waa eco, apeo ami waa ecoti, biirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","To biri mʉja, bojoca catiri niiña, mʉja Wiogʉ cʉ̃ ca doopa rʉmʉre mʉja majiti. ");
INSERT INTO baoNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","”Biirãpʉa, atere majiña: Jĩcʉ̃ wii ʉpʉ, “Jee dutiri majʉ ñamire to cõro doorucumi,” cʉ̃ ca ĩi majijata, cãniri méé, ca ĩa cotegʉ niiri, jĩcʉ̃ ʉno peerena cʉ̃ yaa wii maquẽre cʉ̃ja ca jee dutirã jãa dooro tiiticumi. ");
INSERT INTO baoNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","To biri mʉja cãa, añuro queno yue niiña. Tee jãa, mʉja ca ĩitiri tabere yʉ doorucu, yʉ, Ca Nii Majuropeegʉ Macʉ̃. ");
INSERT INTO baoNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","”¿Ñiru cʉ̃ niiti pade coteri majʉ, ĩiricarore biro ca tiigʉ, ca tʉgoeña bojoca catigʉ, cʉ̃ wiogʉ cʉ̃ yaa wii macãrãre ĩa cote, baarica tabe ca earo cʉ̃jare baarique eca, cʉ̃ ca tii doti cũugʉ pea? ");
INSERT INTO baoNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bʉaro ʉjea niimi pade coteri majʉ, cʉ̃ wiogʉ tua eagʉ, cʉ̃ ca tiipe cʉ̃ paderiquerena ca tii niigʉre cʉ̃ ca bʉa eagʉa. ");
INSERT INTO baoNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yee méé mʉjare yʉ ĩi, wiogʉ pea cʉ̃ yee niipetirijere ca ĩa nʉnʉjeegʉ cʉ̃re tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Paderi majʉ ñañagʉ cʉ̃ ca niijata, “Yʉ wiogʉ yeto tua eatirucumi,” ĩi tʉgoeñari, ");
INSERT INTO baoNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","aperã paderi majare ñañaro cʉ̃jare paa epe jʉowa, ñucã ca jini cũmu pairã mena pee waari cʉ̃ja mena baa, jini, cũmu nucũ yuju, ");
INSERT INTO baoNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","“Tii rʉmʉ ca niiro, tii tabe muipũ cʉ̃ ca niiro, earucumi,” cʉ̃ ca ĩi majitiri rʉmʉre cʉ̃ wiogʉ eari, ");
INSERT INTO baoNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ñañaro cʉ̃re tii, cʉ̃re bape, watoara ca bii dito pairã cʉ̃ja ca tii ecorore biropʉ ñañaro ca biipʉ cʉ̃re tiirucumi. To biri toopʉre bʉaro oti, upi baca dʉpo, biirique niirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","”Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea pʉa amo cõro niirã wãmarã romiri amo jiarica boje rʉmʉre, ca nʉmo cʉtipʉre bocarã waarã, cʉ̃ja romiri cõrora jĩa boericagaari ami, cʉ̃ja ca waaricarore biro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Jĩcã amo cõro niirã romiri, “To biro manire biibocu,” ca ĩi tʉgoeñatirã niiuparã. Aperã jĩcã amo cõro ca niirã romiri pea, “To biro manire biibocu” ca ĩi tʉgoeña bojoca catirã niiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ca tʉgoeña bojoca catitirã romiri cãa cʉ̃ja ca jĩa boepagaarire jee waauparã. Jee waa pacarãra, ʉje cʉ̃ja ca pio jãa wajoape peere jee waatiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ca tʉgoeña bojoca catirã romiri pea, ʉje cʉ̃ja ca pio jãa wajoape cãare apega mena pio jãa, jee waauparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ca amo jiapʉ yeto eatiupʉ. Tee jãa ĩiricaro maniro, cʉ̃ja niipetirãpʉrena wʉgoa ca earo macã, cãnicoauparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ñami decomacã ca niiro, “¡Mee, doo yerijãami ca amo jiapʉ! ¡Cʉ̃re bocarã dooya!” cʉ̃ja ca ĩi acaro buirijere tʉouparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","”Teere tʉo, wãmarã romiri niipetirãpʉra wãcãri, cʉ̃ja jĩa boericagaarire quenouparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","To cõrora, “To biro biibocu” ca ĩi tʉgoeña bojoca catitirã romiri pea o biro ĩimiuparã cʉ̃ja mena macãrã ca tʉgoeña bojoca catirã romiri peere: “Jãa jĩa boericagaari yati waaropʉ bii. Jãa cãare mʉja yee ʉje petoacã jãare tiicojoya,” cʉ̃jare ĩimiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","To biro cʉ̃ja ca ĩiro, ca bojoca catirã romiri pea: “Jãa tiicojoti. ¡Mʉjare jãa ca tiicojojata, jãa cãare eati, mʉja cãare eati, biicãbocu! Ʉje ca nonirã pʉtopʉ waari wapa tiirãja, mʉja ca jĩa boepere,” cʉ̃jare ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","”To biro cʉ̃ja ca ĩiro tʉo, cʉ̃ja romiri cʉ̃ja ca ʉje wapa tiirã waa ditoyera, eaupʉ ca amo jiapʉ. Cʉ̃ ca earo, ca tʉgoeña bojoca catirã romiri pea, amo jiarica boje rʉmʉ cʉ̃ja ca tiiri wiipʉ cʉ̃ mena jãacoauparã. Cʉ̃ja ca jãa waaro jiro, tii wii jopere biacãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jiropʉ aperã romiri pea eari: “¡Wiogʉ, wiogʉ, jãa cãare jope pãaña!” cʉ̃re ĩimiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","To biro cʉ̃ja ca ĩiro, “Mʉjare yʉ majiti. Yee méé yʉ ĩi,” cʉ̃jare ĩi yʉʉupʉ —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","To biro ĩicã: “Tii rʉmʉ, tii tabe muipũ cʉ̃ ca niiro, earucumi ca ĩi majitirã niiri, añuro tʉgoeña bojoca ca tiiri niiña,” ĩi nemowi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","O biro ĩi nʉnʉa waawi ñucã: —Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea jĩcʉ̃ ʉmʉ ape yepapʉ waarʉgʉ jʉguero, cʉ̃ paderi majare jʉo cojori, cʉ̃ yee wapa tiirica tiirire, “Mʉja ĩa nʉnʉjeewa,” cʉ̃ ca ĩi cũu waaricarore biro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jĩcʉ̃ cʉ̃ja mena macʉ̃re jĩcã amo cõro niiri poari peti wapa tiirica tiiri, oro tiiri cʉ̃re tiicojoupʉ. Apĩre pʉa poa tiicojoupʉ. Apĩ peera jĩcã poara cʉ̃re tiicojoupʉ. Cʉ̃ja ca niiro cõrorena “Ano cõrorira ĩa nʉnʉjee bayirʉgama,” ĩi majiri cʉ̃jare tiicojoupʉ. To biro tii yapano, waacoaupʉ yua. ");
INSERT INTO baoNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Jĩcã amo cõro niiri poari cʉ̃ ca tiicojoricʉ pea, tee mena apeye wapa tii, noni wapa taa nemoupʉ ñucã cʉ̃ ca tiicojoricaro cõrora. ");
INSERT INTO baoNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","To birora tiiupʉ pʉa poa ca ñeericʉ cãa, cʉ̃re cʉ̃ ca tiicojo waaricaro cõrora wapa taa nemoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Jĩcã poa ca ñeericʉ pea, cʉ̃ wiogʉ yee wapa tiirica tiirire jee waari, yepapʉ ope coa, yaa cũucãupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","”Paderi maja wiogʉ pea ca yoa waaro jiropʉ tua eaupʉ ñucã. Tua ea, cʉ̃ paderi maja mena cʉ̃ja ca paderiquere quenoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Jĩcã amo cõro niiri poari ca ñeericʉ ea jʉoupʉ. Ea, apeye jĩcã amo cõro niirije cʉ̃ ca wapa taa nemoriquere cʉ̃ wiogʉre cʉ̃re noniri, o biro cʉ̃re ĩiupʉ: “Wiogʉ, jĩcã amo cõro niirije peti yʉre mʉ tiicojowʉ. Ate nii apeye jĩcã amo cõro yʉ ca wapa taa nemojãrije,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","To biro cʉ̃ ca ĩiro, cʉ̃ wiogʉ pea o biro cʉ̃re ĩiupʉ: “¡Añuro mʉ tiijapa! Paderi majʉ añugʉ, ĩiricarore biro ca tiigʉ mʉ nii. Mee, petoacãrena ca ĩa nʉnʉjee majiricʉ mʉ ca niiro macã, paʉ ca niirijepʉre ca ĩa nʉnʉjeegʉ mʉre yʉ cũurucu. ¡Jãa doori, yʉ mena ʉjea niigʉ dooya!” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","”Cʉ̃ jiro, cʉ̃ paderi majʉ pʉa poa ca ñeericʉ cãa ea, o biro cʉ̃re ĩiupʉ: “¡Wiogʉ, pʉa poa yʉre mʉ tiicojowʉ! Ate nii apeye pʉa poa yʉ ca wapa taa nemojãrije,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","To biro cʉ̃ ca ĩiro, cʉ̃ wiogʉ pea o biro cʉ̃re ĩiupʉ: “¡Añuro mʉ tiijapa! Paderi majʉ añugʉ, ĩiricarore biro ca tiigʉ mʉ nii. To biri petoacãrena ca ĩa nʉnʉjee majiricʉ mʉ ca niiro macã, paʉ ca niirijepʉre ca ĩa nʉnʉjeegʉ mʉre yʉ cũurucu. ¡Jãa doori, yʉ mena ʉjea niigʉ dooya!” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","”Jiro, jĩcã poa ca ñeericʉ eari, o biro ĩiupʉ cʉ̃ wiogʉre: “¡Wiogʉ, do biro ca tiiya manigʉ mʉ ca niirijere, mʉ ca otetiri taberena ca dica jee, ñucã ote dicare ca cũuña maniri taberena ca jeegʉ, mʉ ca niirijere yʉ majiwʉ! ");
INSERT INTO baoNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","To biri mʉre uwima ĩigʉ, mʉ yee wapa tiirica tiirire, ope coari yʉ yaio cũucãwʉ. Ĩaña. Ate nii mʉ yee ca niirije,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","”To biro cʉ̃ ca ĩiro, cʉ̃ wiogʉ pea o biro cʉ̃re ĩi yʉʉupʉ: “¡Mʉa, paderi majʉ ca añutigʉ, ca junañe paigʉ mʉ nii! Yʉ ca otetirica taberena ca dicare jee, ote dicare ca dee bate cũuña maniri tabe ʉnorena ca dicare jee, ca tiigʉ yʉ ca niirijere maji pacagʉ, ");
INSERT INTO baoNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿Ñee tiigʉ yʉ wapa tiirica tiirire, wapa tiirica tiirire cũurica wiipʉ jee waari mʉ cũutiri? To biro tiigʉ, yʉ ca tua earo pai jañuro ca bʉʉ nemorique mena yʉre mʉ tuenebojacupa,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","To biro ĩi yapano, too ca niirãre o biro ĩiupʉ: “¡Wapa tiirica tiiri cʉ̃ ca cʉorijere ẽmari, pʉa amo cõro niiri poari ca cʉogʉ peere cʉ̃re tiicojoya!” cʉ̃jare ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ca cʉogʉra pai jañuro tiicojo nemorique niirucu. To biri pairo cʉorucumi. Ca cʉotigʉa, petoacã cʉ̃ ca cʉomirije menapʉra ẽma ecorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ani paderi majʉ ca añutigʉ peera macã ca naitĩaropʉ cõa wienecã cojoya. To biri toopʉre bʉaro oti, upi baca dʉpo, biirique niirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","”Yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca boe baterije mena, ñucã yʉ yaarã yʉre queti wede bojari maja niipetirã mena, yʉ ca doori rʉmʉre, wiogʉ cʉ̃ ca duwiri cũmuropʉ yʉ ea nuu earucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","To biro yʉ ca biiro, ati yepa macãrã niipetirã bojoca poogaari cʉ̃ja ca niiro cõro yʉ jʉguerore nea poo earucuma. To biro cʉ̃ja ca biiro yʉ pea, oveja coteri majʉ, cabra watoa ca niirã ovejare cʉ̃ ca jee dica woorore biro cʉ̃jare yʉ tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Yʉ yaarã ovejare biro ca niirã peere, yʉ díámacʉ̃ nʉña pee cʉ̃jare cũu, cabra peera yʉ ãcõ nʉña pee cʉ̃jare cũu, yʉ tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","To biro tii yapano yʉ pea, yʉ díámacʉ̃ nʉña pee ca niirãre o biro cʉ̃jare yʉ ĩirucu: “Dooya mʉja, yʉ Pacʉ añuro cʉ̃ ca tiiricarã, Ʉmʉreco Pacʉ ati ʉmʉrecore jeeño jʉogʉpʉra, mʉjare cʉ̃ ca queno yuerica yepare niirã dooya. ");
INSERT INTO baoNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Yʉ ca queyaro, yʉre mʉja baarique ecawʉ. Oco jinirʉgʉ yʉ ca biiro, yʉre mʉja oco tĩawʉ. Nucũ yujuri majʉ yʉ ca niiro, cãnirica tabe yʉre mʉja tiicojowʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yʉ ca juti cʉotiro, yʉre mʉja juti tiicojowʉ. Yʉ ca diaro cãare, yʉre mʉja ĩarã eawʉ. Tia cũurica wiipʉ yʉ ca niijata cãare, yʉre mʉja ĩarã eawʉ,” cʉ̃jare yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","”To biro yʉ ca ĩiro tʉo, ca añurã pea o biro yʉre ĩi jãiñarucuma: “Wiogʉ, ¿di tabe ʉno pee mʉ ca queyaro ĩari, mʉre jãa baarique ecari? ¿Di tabe ʉno pee mʉ ca jinirʉga nucũ yujuro, mʉre jãa oco tĩari? ");
INSERT INTO baoNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Di tabe ʉno pee nucũ yujuri majʉ mʉ ca niiro, ‘Jãa pʉto niiña,’ mʉre jãa ĩiri? ¿Di tabe ʉno pee mʉ ca juti cʉotiro, mʉre jãa juti jãari? ");
INSERT INTO baoNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ñucã, ¿di tabe ʉno peti mʉ ca diaro, tia cũurica wiipʉ mʉ ca niiro, mʉre jãa ĩarã eari?” ĩi jãiñarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","To biro cʉ̃ja ca ĩi jãiñaro, yʉ, Wiogʉ pea, o biro cʉ̃jare yʉ ĩirucu: “Yee méé mʉjare yʉ ĩi. Anija, yʉ yaarã boo pacoro ca biirãre mʉja ca tii nemorique, yʉrena tii nemorã mʉja tiiwʉ,” cʉ̃jare yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","”To biro ĩi yapano, Wiogʉ pea, yʉ ãcõ nʉña ca niirã peera o biro cʉ̃jare yʉ ĩirucu: “Yʉre camotatiya, mʉja ñañaro ca biiparã, pecame ca ʉ̃ʉ yatitiri pecame, Satanás, cʉ̃ yaarã ca añutirã menare, Ʉmʉreco Pacʉ cʉ̃jare cʉ̃ ca queno yuerica tabepʉ waarãja. ");
INSERT INTO baoNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yʉ ca queyaro, yʉre mʉja baarique ecatiwʉ. Yʉ ca oco jinirʉgaro, yʉre mʉja oco tĩatiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nucũ yujuri majʉ yʉ ca niiro, cãnirica tabe yʉre mʉja tiicojotiwʉ. Yʉ ca juti cʉotiro cãa, yʉre mʉja juti jãatiwʉ. Ñucã yʉ ca diaro, tia cũurica wiipʉ yʉ ca niiro cãare, yʉre mʉja ĩarã eatiwʉ,” yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","”To biro yʉ ca ĩiro tʉo, o biro ĩi jãiñarucuma: “¡Wiogʉ! ¿Di tabe ʉno pee mʉ ca queyaro, mʉ ca jinirʉgaro, nucũ yujuri majʉ mʉ ca niiro, mʉ ca juti cʉotiro, mʉ ca diaro, tia cũurica wiipʉ mʉ ca niiro, mʉre jãa tii nemotiri? ¡To biro mʉ ca biiro jãa ĩatiwʉ!” ĩirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare yʉ ĩi yʉʉrucu: “Yee méé mʉjare yʉ ĩi: Anija, yʉ yaarã mena macãrã boo pacoro ca biirãre tii nemotirã, yʉ cãare tii nemotirã mʉja biiwʉ,” cʉ̃jare yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Cʉ̃ja pea to birora ñañaro cʉ̃ja ca biipa tabepʉ waarucuma. Añurã pea, to birora cʉ̃ja ca caticõa niipa tabepʉ waarucuma —ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Ate niipetirije ĩi yapano, o biro ĩiwi Jesús, jãa, cʉ̃ buerãre: ");
INSERT INTO baoNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mee mʉja maji, pʉa rʉmʉ jiro Pascua boje rʉmʉ ca niirijere. Yʉ, Ca Nii Majuropeegʉ Macʉ̃re noni cõacãrucuma, yucʉ tenipʉ yʉre cʉ̃ja paa pua tuu cõajato ĩirã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tii rʉmʉrirena, paia ʉparã, to biri judíos're ca jʉo niirã, paia wiogʉ Caifás yaa wiipʉ neari, ");
INSERT INTO baoNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","watoara jĩcã wãme ĩi dito buiyeeri Jesús're ñeeri cʉ̃ja ca jĩa cõapere ameri wede peniupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Biirãpʉa, “Boje rʉmʉ petira mani tiiticãjaco, bojoca ajiari uwiorije cʉ̃ja ca tiitipere biro ĩirã,” ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús, Betaniapʉre Simón ca cami boagʉ cʉ̃ja ca ĩigʉ yaa wiipʉ cʉ̃ ca niiro, ");
INSERT INTO baoNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","jĩcõ nomio ʉ̃tãga mena cʉ̃ja ca quenorica rʉacã dadaro ca jʉti añurije ca wapa pacarijere ca ami doorico jãa eawo. Jãa ea, Jesús baarique peorica pĩi pʉto cʉ̃ ca duwiro, ca jʉti añurijere cʉ̃ dʉpʉga jotoare pio peowo. ");
INSERT INTO baoNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Jãa, cʉ̃ buerã pea, to biro cõ ca tiiro ĩari, ajiama ĩirã: —¡Níjá! ¿Ñee tiigo ca wapa pacarijere to biro peti cõ tii batecãti? ");
INSERT INTO baoNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ca boo pacarãre tii nemorʉgo wapa pacaro noni wapa jee bojapo cõa —jãa ameri ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús pea to biro jãa ca ĩirijere majiri, o biro jãare ĩiwi: —¿Ñee tiirã atiore to biro mʉja ĩi pato wãcõti? Yʉ menare añurijere tiigo tiimo. ");
INSERT INTO baoNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ca boo pacarãra mʉja watoare to birora mʉja cʉocõa niirucu. Yʉ pee docare yoaro yʉre mʉja cʉotirucu. ");
INSERT INTO baoNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Atio, ca jʉti añurijere yʉ upʉre pio peogo, yʉre cʉ̃ja ca yaa cõapepʉre queno yuego tiimo. ");
INSERT INTO baoNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Yee méé mʉjare yʉ ĩi: Ati yepare noo ca niiri taberipʉ ate añurije quetire cʉ̃ja ca wederi taberipʉ, atio cõ ca tiirije cãare wederucuma. To biro cʉ̃ja ca ĩiro, cõ cãa majirico niirucumo —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jĩcʉ̃, jãa cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena macʉ̃, Judas Iscariote ca wãme cʉtigʉ, paia ʉparãre ĩagʉ waari, ");
INSERT INTO baoNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","o biro cʉ̃jare ĩiupi: —Jesús're mʉjare yʉ ca tiicojojata, ¿no cõro yʉre mʉja wapa tiirãti? —ĩiupi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea treinta tiiri, plata tiiri cʉ̃re wapa tiiupa Judas're. ");
INSERT INTO baoNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","To biro cʉ̃re cʉ̃ja ca tiiri tabera, Judas pea Jesús're cʉ̃ ca ñee doti majipa tabe ʉnore ama jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Pascua boje rʉmʉ ca nii jʉori rʉmʉre, pan ca wauarije ca ayiaya manirije baarica rʉmʉ ca earo, jãa cʉ̃ buerã pea cʉ̃ pʉto ea, o biro cʉ̃re jãa ĩi jãiñawʉ: —¿Noopʉ Pascua mani ca baapere jãa ca quenoro mʉ booti? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","To biro jãa ca ĩiro, o biro jãare ĩi yʉʉwi: —Jerusalén macãpʉ waari, jĩcʉ̃ yaa wiire eari, o biro cʉ̃re ĩiña: “Buegʉ o biro ĩimi: ‘Mee, yʉ yaa rʉmʉ cõñacã doo, to biri mʉ yaa wiipʉ yʉ buerã mena Pascua boje rʉmʉre yʉ ametʉenegʉ waarucu,’ ĩimi,” cʉ̃re mʉja ĩirucu —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","To biro cʉ̃ ca ĩiro jãa pea, Jesús cʉ̃ ca tii dotirore biro jãa tiiwʉ. To biri tii wiipʉ jãa queno yuewʉ, Pascua boje rʉmʉ jãa ca baapere. ");
INSERT INTO baoNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Naiori tabe ca niiro, Jesús pea tii wiipʉ, jãa, pʉa amo peti, dʉpore pʉaga penituaro ca niirã cʉ̃ buerã mena baarique peorica pĩi pʉto bii duwiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Jãa ca baa niiro ʉnora, o biro jãare ĩiwi Jesús: —Yee méé mʉjare yʉ ĩi: Jĩcʉ̃ mʉja mena macʉ̃ra yʉre wedejãa buiyee cõacãrucumi —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","To biro cʉ̃ ca ĩiro jãa pea, bʉaro tʉgoeñarique pai, jãa ca niiro cõro o biro cʉ̃re jãa ĩi jãiñawʉ: —¿Wiogʉ, yʉra yʉ niicã tiimigʉti? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","To biro jãa ca ĩiro, o biro jãare ĩiwi Jesús: —Jĩcʉ̃, yʉ ca joari baparena cʉ̃ pan're ca weyogʉ niimi, yʉre ca wedejãapʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Biigʉpʉa yʉ, Ca Nii Majuropeegʉ Macʉ̃a, Ʉmʉreco Pacʉ wederiquere cʉ̃ja ca owarique ca ĩirore birora biigʉ doogʉ yʉ tii. Yʉre ca wedejãa buiyee cõagʉ pea, ñañaro peti biigʉ doogʉ tiimi. Cʉ̃ra, cʉ̃ ca baʉatijata, añucãbojapa —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","To biro cʉ̃ ca ĩirora, Judas, Jesús're ca wedejãa buiyee cõapʉ pea, o biro cʉ̃re ĩi jãiñawi: —¡Buegʉ! ¿Yʉra yʉ niicãtimiti? —cʉ̃re ĩiwi. To biro cʉ̃ ca ĩiro: —Mee, mʉra mʉ ĩi —cʉ̃re ĩi yʉʉwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Jãa ca baa niirora Jesús pea pan're ami, Ʉmʉreco Pacʉre: “Añu majuropeecã” ĩi yapano, pee bato, jãa cʉ̃ buerãre o biro jãare ĩi tiicojowi: —Amiri baaya. Atea yʉ upʉ nii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jiro ñucã, ʉje oco bapare ami, Ʉmʉreco Pacʉre, “Añu majuropeecã” ĩi yapano, o biro ĩigʉra jãa peere noni cojowi: —Mʉja niipetirãpʉra ati bapare jiniña. ");
INSERT INTO baoNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Atea yʉ díi nii, Ʉmʉreco Pacʉ “Wãma wãme yʉ tiirucu,” cʉ̃ ca ĩiriquere cʉ̃ ca ĩiricarore biro to biijato ĩiro ca biirije, paʉ bojoca cʉ̃ja ca ñañarije wapare ametʉene bojagʉ yʉ ca bii yaipe. ");
INSERT INTO baoNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","O biro mʉjare yʉ ĩi: Ate ote ʉje ocore pʉati yʉ jini nemotirucu, mʉja mena yʉ Pacʉ cʉ̃ ca doti niiri tabepʉ wãma ʉje ocore yʉ ca jiniparo jʉguero —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jiro, salmos baja yapano, Olivos buuropʉ jãa waacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Toopʉ o biro jãare ĩiwi Jesús: —Ati ñamire mʉja niipetirãpʉra yʉre mʉja waa weocoarucu. O biro ĩi owarique nii: “Oveja ca cotegʉre yʉ jĩa cõacãrucu. Cʉ̃ yaarã oveja pea no ca boorora waa batecoarucuma,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Biigʉpʉa, cati tuari jiro, mʉja jʉguero Galileapʉ yʉ waarucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","To biro cʉ̃ ca ĩiro, Pedro pea o biro cʉ̃re ĩi yʉʉwi: —Niipetirã mʉre cʉ̃ja ca waa weocoamijata cãare, yʉa mʉre yʉ waa weotirucu —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩiwi: —Yee méé mʉre yʉ ĩi: Ati ñamira ãbocʉ cʉ̃ ca wedeparo jʉguero, itiati peti, “¡Cʉ̃re yʉ majiti!” mʉ ĩi ditorucu —ĩiwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Cʉ̃ pea o biro cʉ̃re ĩiwi: —Mʉ menara yʉ ca bii yaipe to ca niijata cãare, “¡Cʉ̃re yʉ majiti!” yʉ ĩi ditotirucu yʉa —ĩiwi Pedro. To biro cʉ̃ ca ĩiro, jãa Jesús buerã niipetirãpʉra to biro wado jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jiro Jesús jãa mena Getsemaní ca wãme cʉtiropʉ waa, toopʉ eagʉ, o biro jãare ĩiwi: —Õo pee waari yʉ ca juu buegʉ waaro ʉno, anora duwiya ména —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","To biro ĩi, Pedrore, Zebedeo puna pʉarãre, jʉo waawi. Too waagʉ, bʉaro tʉgoeñarique pai yaja pua bii jʉo waaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","To biri o biro cʉ̃jare ĩiupi: —Yʉ ca cati niirijepʉra bii yaicoaricarore biropʉ yʉ tʉgoeña yapa pua. Anora tuari, cãnitirãra yʉ menara ĩacã niiña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","To biro ĩi yapano, cʉ̃ja jʉguero jañuro waa, yepapʉ muu bia cũmu waari, o biro ĩi juu bueupi: —¡Cáacʉ! Ametʉenerique ʉnora to ca niijata, ñañaro yʉ ca tamʉoro yʉre tiiticãña. Biigʉpʉa, yʉ ca boorore biro tiiticãña. Mʉ ca boorore biro pee to biijato —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Juu bue yapano, cʉ̃ buerã pʉto pee tua waagʉ, ca cãnirãpʉre cʉ̃jare bʉa eari, o biro ĩiupi Jesús, Pedrore: —¿Jĩcã nimaro ʉno peera, cãnitirãra yʉ mena mʉja ĩa bayitijãri? ");
INSERT INTO baoNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cãnitirãra juu bueya, ñañarije ca bii buiyeerijere jãa tiire ĩirã. Añurijere mʉja tiirʉga tʉgoeña biirãpʉa, bʉari mʉja tʉgoeña bayiti majuropeecã —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Waa, ñucã o biro ĩi juu bueupi Jesús: —¡Cáacʉ! Ano ñañaro yʉ ca biipere do biro tii camota majiña manirije to ca niijata, mʉ ca boori wãme tiiya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Juu bue yapano tua waagʉ, ca cãnirãpʉre bʉa eacãupi ñucã. Bʉaro ca wʉgoa eyoro macã, cʉ̃ja capegaari ĩa pãa bayiri méé bii niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","To biro cʉ̃ja ca biiro ĩa, Jesús pea toora cʉ̃jare cũu, juu buegʉ waacoaupi ñucã. Cʉ̃ ca ĩiricarore birora ĩi juu bueupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","To cõrora cʉ̃ buerã pʉto pee tua waa, o biro cʉ̃jare ĩiupi: —¿Ména to birora cãni, yerijãa, mʉja biicõa niiti? Mee, yʉ, Ca Nii Majuropeegʉ Macʉ̃re, ñañarije ca tiirãpʉre yʉre cʉ̃ja ca noni cõari tabe eacoa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Wãmʉ nʉcãña! ¡Jamʉ! ¡Mee, ĩirã tʉja doomi, yʉre ca wedejãa buiyee cõagʉ! —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesús to biro cʉ̃ ca ĩi niirora, Judas, jãa, Jesús buerã pʉa amo peti, dʉpore pʉaga penituaro mena macʉ̃ra, paʉ bojoca, jaderica pĩiri, yucʉ dʉcari, beju cʉticãri, paia ʉparã, to biri judíos're ca jʉo niirã cʉ̃ja ca tiicojoricarã mena bapa cʉti eawi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ména, wedejãari majʉ Judas pea, o biro cʉ̃jare ĩiupi Jesús're ca ñeeparãre: —Cʉ̃ wajopuare yʉ ca ũpũgʉ niirucumi. Cʉ̃re mʉja ñeerucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","To biri Judas, Jesús pʉto eagʉ: —¡Buegʉ mʉ niimite! —ĩiwi. To biro ĩigʉra, cʉ̃ wajopuare ũpũ, cʉ̃re tii añu doti eawi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","To biro cʉ̃ ca tiiro, Jesús pea o biro cʉ̃re ĩiwi: —Yʉ mena macʉ̃, mʉ ca tiirʉga dooriquere jĩcãto tiiya —ĩiwi. To biro cʉ̃ ca ĩirora aperã pea doo, Jesús're cʉ̃re ñeewa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","To biro cʉ̃ja ca tiirora jĩcʉ̃ jãa mena macʉ̃, cʉ̃ niipĩi tʉ̃a wee amiri, paia wiogʉre pade coteri majʉ amoperore paa taa ñoocã cojowi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","To biro cʉ̃ ca tiiro, Jesús pea o biro cʉ̃re ĩiwi: —Mʉ niipĩire ca niiricaropʉra queno cũuña. Niipĩiri mena ca ameri quẽerã niipetirãpʉra, niipĩi menara jĩa ecorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tii nemorique yʉ ca boojata, yʉ Pacʉre yʉ ca jãiro, “Mee, pʉa amo peti, dʉpore pʉaga penituaro ca niiri poogaari peti cʉ̃ pʉto macãrã uwamarãre tiicojo yerijãabocumi,” ¿mʉ ĩi majititi? ");
INSERT INTO baoNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","To biro to ca biijata, do biro pee biicãri Ʉmʉreco Pacʉ wederique: “To biro biirucu,” ¿cʉ̃ja ca ĩi owa cũuquĩrique cʉ̃ja ca ĩiricarore birora to biibogajati? —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ĩi yapano, o biro ĩi jãiñawi bojocare: —¿Ñee tiirã jee dutiri majʉre ca tiirãre biro niipĩiri, yucʉ dʉcari, jeecãricarã yʉre mʉja ñeerã doojãri? To cãnacã rʉmʉra Ʉmʉreco Pacʉ yaa wiipʉ yʉ bue niirucujãwʉ. Jĩcãti ʉno peera yʉre ñee, mʉja tiitirucujãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Biiropʉa, ate niipetirije Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja “O biro biirucu,” cʉ̃ja ca ĩi owaquĩricarore biro to biijato ĩiro bii —ĩiwi. To cõrora jãa, Jesús buerã pea, jãa niipetirãpʉra cʉ̃re jãa duti weocoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Jesús're ca ñee waaricarã pea, paia wiogʉ Caifás yaa wii, doti cũuriquere ca jʉo buerã, judíos're ca jʉo niirã, cʉ̃ja ca nea poo niiropʉ cʉ̃re ami waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","To biro cʉ̃ja ca tiiro, Pedro pea yoaropʉra cʉ̃jare nʉnʉ waa, paia wiogʉ yaa wii macã yepapʉ eacoaupi. Jãa waa, Ʉmʉreco Pacʉ yaa wii coteri maja uwamarã mena ea nuu waaupi, “¿Do biro peti Jesús're cʉ̃ja tii nʉnʉa waamirãti?” ĩi ĩarʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Paia ʉparã, ʉparã ca nii majuropeera niipetirã, Jesús're jĩa dotirʉgarã, watoara ĩi buiyeerica wãmeri ama niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","To biro ĩi pacarã, watoara paʉ cʉ̃ja ca wedejãa niirije ca nii pacaro, jĩcã wãme ʉno peera bʉaticãupa. Biirique peti pʉarã, ");
INSERT INTO baoNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","o biro ca ĩirã eaupa: —Ania o biro ĩiwi: “Yʉa, Ʉmʉreco Pacʉ yaa wiire wee batecã, ñucã itia rʉmʉ jirora yʉ queno yapanocã maji,” ĩiwi —ĩi wedejãaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","To cõrora paia ʉpʉ pea wãmʉ nʉcã, o biro ĩiupi Jesús're: —¿Ñee tiigʉ mʉ yʉʉtiti? ¿Do biro ĩirʉgaro to ĩiti, ano o biirije mʉre cʉ̃ja ca ĩi wedejãarije? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesús pea wedetiupi. To biro cʉ̃ ca biiro, paia wiogʉ pea o biro cʉ̃re ĩiupi: —“Ʉmʉreco Pacʉ, to birora ca caticõa niigʉ wãme mena díámacʉ̃ jãare wedeya,” mʉre yʉ ĩi. ¿Díámacʉ̃ra mʉa, Ʉmʉreco Pacʉ Macʉ̃ Mesías'ra mʉ niiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Mee, mʉra mʉ ĩi: Yʉ, Ca Nii Majuropeegʉ Macʉ̃re, niipetirijepʉre Ca Doti Tutua Niigʉ cʉ̃ ca duwiro díámacʉ̃ nʉña pee ca duwigʉre, ñucã ʉmʉreco quejero maquẽ bueri bʉrʉripʉ yʉ ca dooro, mʉja niipetirã yʉre mʉja ĩarucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","To biro cʉ̃ ca ĩirora, paia wiogʉ pea ajia ametʉacoama ĩigʉ, cʉ̃ jutirore tʉ̃a yega, o biro ĩiupi: —Ania, Ʉmʉreco Pacʉre ñañarije peti ii tuticãmi. Ñee peere ĩirã cõro ca wede nemoparãre paʉ jañuro mani ama nemotirucu. Mee, mʉjara ñañarije cʉ̃ ca ĩi tutirijere mʉja tʉo, ");
INSERT INTO baoNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","atere ¿do biro mʉja ĩi tʉgoeñati? —ĩiupi. To biro cʉ̃ ca ĩiro: —Ñañarije cʉ̃ ca ĩi tutirije wapa, ca jĩa ecopʉra niimi —ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","To biro ĩirã, cʉ̃ diámacʉ̃re ʉjeco eo tuu, cʉ̃re ñoje, ñucã aperã cʉ̃re paa, tiirãra, ");
INSERT INTO baoNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","o biro cʉ̃re ĩiupa: —Mʉ, Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ Mesías ca niigʉa ĩi bʉaya, ¿ñiru mʉre cʉ̃ paajãri? —ĩi epeupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","To biro cʉ̃ja ca ĩi nii ditoye, Pedro pea macã yepapʉra cʉ̃ ca duwirucuro, jĩcõ pade coteri majo cʉ̃ pʉto eari, o biro cʉ̃re ĩiupo: —Mʉ cãa Galilea macʉ̃ Jesús menara mʉ waa yujurucujãwʉ —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","To biro cõ ca ĩiro, Pedro pea niipetirã cʉ̃ja ca tʉo cojoro, o biro ĩi ditoupi: —Yʉ majiti nija, ¿ñee ʉnore mʉ ĩiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jiro jope pee cʉ̃ ca witi waaro, ñucã apeo pade coteri majo cʉ̃re ĩari, o biro ĩiupo, aperã to ca niirãre: —Ani cãa, Nazaret macʉ̃ Jesús menara niirucuwi —cʉ̃jare ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Cʉ̃ pea ñucã: —Yee méé yʉ ĩi nija. Yʉ majiti majuropeecã cʉ̃ra —ĩi ditoupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ñucã jiro jañuroacã too ca niirã Pedro pʉto doori, o biro cʉ̃re ĩiupa: —Yee méé jãa ĩi. Mʉ cãa, cʉ̃ja mena macʉ̃ra mʉ nii. Mʉ ca wederijepʉra tʉo majiricarora Galilea macãrã cʉ̃ja ca wederijera mʉ wede —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","To biro cʉ̃ja ca ĩiro, cʉ̃ pea ñañarije cʉ̃jare ĩi tuti jañuripʉ: —Yee méé yʉ ĩi “Yʉ majiti,” mʉjare yʉ ĩijãwʉ —cʉ̃jare ĩiupi. To biro cʉ̃ ca ĩi niirora, ãbocʉ wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","To cõrora Pedro pea: “Ãbocʉ cʉ̃ ca wedeparo jʉguero, itiati peti ‘¡Cʉ̃re yʉ majiti!’ mʉ ĩi ditorucu,” Jesús cʉ̃re cʉ̃ ca ĩiriquere tʉgoeña bʉaupi. To cõrora Pedro too ca niiricʉ witi waa, bʉaro tʉgoeñarique pai añuro méé otiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ca boerije mena, paia ʉparã niipetirã, to biri judíos're ca jʉo niirã mena, Jesús're cʉ̃ja ca jĩa cõa dotipere ameri wede peni niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","To biro ĩi, Jesús're jiacãri ami waari, wiogʉ romano Pilatopʉre cʉ̃re noniupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas, cʉ̃re ca wedejãa buiyee cõaricʉ pea, Jesús're jĩa cõacãrʉgarã cʉ̃ja ca tiirijere ĩa, “Ñañaro peti yʉ tiicãjapa,” ĩi tʉgoeñarique pai, treinta niirije plata tiirire, paia ʉparã, judíos're ca jʉo niirãre, ");
INSERT INTO baoNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","o biro ĩi tueneupi: —Ñañarije yʉ tiijapa, ñañarije ca tiitigʉrena wedejãa buiyee cõagʉ —cʉ̃jare ĩimiupi Judas. To biro cʉ̃ ca ĩiro, cʉ̃ja pea o biro cʉ̃re ĩi yʉʉcãupa: —¡Jãa teera “To biro biicu” jãa ĩiti! Mʉ yee wapa nii —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","To cõrora Judas pea, Ʉmʉreco Pacʉ yaa wiipʉra wapa tiirica tiirire dee bate cũu, witi waa, yucʉgʉpʉ mʉa waa, ca dʉpʉpʉ pũugʉ dʉpo jia tuuri, cʉ̃ majuropeera cʉ̃ amʉtuture jia tuu, bupu ñaañumu, biicã yai waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Paia ʉparã pea tee wapa tiirica tiirire jee, o biro ĩiupa: —Ate wapa tiirica tiiri, ca díi tujarije nii. Ʉmʉreco Pacʉre tiicojo nʉcʉ̃ bʉorã jãarica cũmuapʉre mani jãa majiti —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","To biro ĩi, ameri wede peni yapano, tee wapa tiirica tiiri mena jĩcã yepa, “Jotʉri Weeri Majʉ Yaa Yepa ca wãme cʉtiri yepare ca wapa tiipe niicu, ape yepa macãrãpʉ ca bii yairãre yaarʉgarã,” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","To biri tii yepa mecʉ̃ripʉ cãare, “Díi Yepa” wãme cʉti. ");
INSERT INTO baoNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","O biro bii eaupa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Jeremías: “Wapa tiirica tiiri plata, treinta niiri tiirire, israelitas, ‘To cõro wapa cʉtirucu,’ cʉ̃ja ca ĩiricaro cõro ca niirijere jeeri, ");
INSERT INTO baoNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","tee mena, ‘Jotʉri Weeri Majʉ Yaa Yepa ca wãme cʉtiri yepare wapa tiiwa,’ Ʉpʉ yʉre cʉ̃ ca tii dotiricarore birora,” cʉ̃ ca ĩi owaquĩrique. ");
INSERT INTO baoNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesús pea tii yepa macãrã ʉpʉ Pilato pʉtopʉ cʉ̃ ca nucũro, cʉ̃ pea o biro ĩi jãiñaupi Jesús're: —¿Mʉ, mʉ niiti, judíos Wiogʉ? —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩiro: —Mee, mʉra mʉ ĩi —cʉ̃re ĩi yʉʉupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Paia ʉparã, judíos're ca jʉo niirã, cʉ̃re cʉ̃ja ca wedejãamijata cãare, Jesús pea jĩcã wãme ʉnora cʉ̃jare yʉʉrucu, tiitiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","To biri Pilato pea o biro cʉ̃re ĩi jãiñaupi: —¿Ñañaro mʉre cʉ̃ja ca ĩi wedejãarijere mʉ tʉotiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","To biro cʉ̃ ca ĩimijata cãare, Jesús pea jĩcã wãme ʉnoacãra yʉʉrucu, tiitiupi. To biro cʉ̃ ca biiro Pilato pea, “Uwioro ca biigʉ cʉ̃ niiti ania,” cʉ̃re ĩi ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ména, tii yepa macãrã ʉpʉ pea Pascua boje rʉmʉri ca niiro, jĩcʉ̃ tia cũurica wiipʉ ca niigʉ bojoca cʉ̃ja ca boogʉre wienerucuupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Tii tabere niiupi jĩcʉ̃ tia cũurica wiipʉre, Jesús Barrabás ca wãme cʉtigʉ, cʉ̃ja ca jãnoogʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","18","To biri Pilato pea too ca nea poo niirãre o biro ĩi jãiñaupi, Jesús're ĩa tutima ĩirã, cʉ̃ja ca wedejãa cõarijere majiri: —¿Niipere yʉ ca wienero mʉja booti, Jesús Barrabás peere, Jesús, Mesías mʉja ca ĩigʉ peere? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ména, Pilato pea bojocare cʉ̃ ca jãiña bejeri tabepʉra cʉ̃ ca duwiro, cʉ̃ nʉmo pea o biro cʉ̃re ĩi cojoupo: —Mʉ menara ca ñañarije manigʉrena ñañaro cʉ̃re tiiticãña. Meepʉ macã ñamire ñañarije yʉ quẽñajãwʉ, cʉ̃ yee jʉori —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Paia ʉparã, to biri judíos're ca jʉo niirã, Pilato pea Barrabás're wiene, Jesús peera jĩa cõa doti, cʉ̃ ca tiipere biro ĩirã, teere cʉ̃re cʉ̃ja jãijato ĩirã, bojocare wedejãa niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tii yepa macãrã ʉpʉ pea cʉ̃jare jãiña nemoupi ñucã: —¿Anija pʉarãre, niipere yʉ ca wienero mʉja booti? —ĩiupi. To biro cʉ̃ ca ĩiro: —¡Barrabás're mʉ ca wienero jãa boo! —ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","To biro cʉ̃ja ca ĩiro, Pilato pea: —To docare Jesús, Mesías peera, ¿do biro yʉ tiigajati? —cʉ̃jare ĩi jãiñaupi. To biro cʉ̃ ca ĩiro, niipetirãpʉra: —¡Yucʉ tenipʉ cʉ̃re paa pua tuu cõacãña! —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","To biro cʉ̃ja ca ĩiro, Pilato pea ñucã: —¿Ñee ʉno ñañarije cʉ̃ tiijapari? —cʉ̃jare ĩiupi. To biro cʉ̃ ca ĩimijata cãare: —¡Yucʉ tenipʉ cʉ̃re paa pua tuu cõacãña! —ĩi acaro bui nemoupa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","To biri Pilato pea cʉ̃ ca tiirʉgari wãme peere, “¡Do biro yʉ tiiricaro mani!” ĩima ĩigʉ, bʉaro jañuro bojoca cʉ̃ja ca acaro bui nʉnʉa waaro ĩari, oco jee doo dotiri, niipetirã cʉ̃ja ca ĩa cojoro o biro ĩigʉra amo coeupi: —Ani, ñañarije ca tiitiricʉrena mʉja ca jĩarijere, yʉa, yʉ wapa tuaticu. Mʉja yee nii —cʉ̃jare ĩiupi Pilato. ");
INSERT INTO baoNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","To biro cʉ̃ ca ĩiro, niipetirã bojoca o biro ĩi acaro buiupa: —¡Cʉ̃ ca bii yairije wapa, jãare, to biri jãa punare, to bii ñaapeajato! —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","To cõrora Pilato pea Barrabás're wiene, Jesús peera cʉ̃re bape doti yapano, cʉ̃jare nonicãupi, yucʉ tenipʉ cʉ̃re cʉ̃ja paa pua tuu cõajato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Tii yepa macãrã ʉpʉ yaarã uwamarã pea, ʉpʉ cʉ̃ ca niiri wiipʉ Jesús're ami waa, cʉ̃ wejare uwamarã niipetirãre jʉo neoupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","To biro tii, cʉ̃re juti tuu weeri, ca jũari quejero pee cʉ̃re jãa, ");
INSERT INTO baoNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","cʉ̃ dʉpʉga peera pota daari mena juarica betore peo, cʉ̃ amo díámacʉ̃ peere yucʉgʉacã paa jua, tiicãri, cʉ̃ja ãjʉro jupeari mena cʉ̃ pʉto ea nuu waari, o biro cʉ̃re ĩi bui epeupa: —¡Judíos wiogʉ to birora cʉ̃ caticõa niijato! —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ñucã to biro ĩirãra, cʉ̃re ʉjeco eo tuu, yucʉgʉ cʉ̃re cʉ̃ja ca tiicojoricagʉrena amiri cʉ̃ dʉpʉgare paa, tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jesús're to biro ñañaro cʉ̃re tii epe yapano, cʉ̃re cʉ̃ja ca juti jãaricarore tuu wee, cʉ̃ juti majurope peere cʉ̃re jãa, cʉ̃re paa pua tuu cõarʉgarã amicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Too ca niiricarã witi waarãra, jĩcʉ̃, Simón ca wãme cʉtigʉ, Cirene macã macʉ̃re bʉa eari, Jesús're cʉ̃ja ca paa pua tuu cõa paagʉre cʉ̃re ami waa nemo dotiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Gólgota ca wãme cʉtiri tabe ea waarã, (“Dʉpʉga Õaro,” ĩirʉgaro ĩi), ");
INSERT INTO baoNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ʉje oco ca jʉ̃guẽrije mena cʉ̃ja ca ayiariquere cʉ̃re tĩawa. Jesús pea teere jini ñaari jiro, jinirʉgatiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Uwamarã pea Jesús're paa pua tuu nʉcõ yapanori jiro, ĩi bʉarique mena tiiri, cʉ̃ juti ca niiriquere ameri dica woowa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","To biro tii yapano, cʉ̃re ĩa coterʉgarã toora ea nuucoawa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ñucã cʉ̃ dʉpʉga jotoa peere, “Tee jʉori jĩa ecomi,” cʉ̃ja ca ĩi owa tuurica pĩire paa pua tuuwa. Tii pĩipʉre: “ANIA JESÚS NIIMI, JUDÍOS WIOGɄ,” ĩi owa tuurique tujawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ñucã Jesús mena, jee dutiri maja pʉarã, jĩcʉ̃ cʉ̃ díámacʉ̃ nʉña pee, apĩ cʉ̃ ãcõ nʉña pee, paa pua tuu nʉcõ ecowa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Bojoca too ca ametʉa waarucurã pea Jesús're ĩi tutirã, cʉ̃ja dʉpʉgare yureri, o biro cʉ̃re ĩi buiwa: ");
INSERT INTO baoNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—Mʉ, Ʉmʉreco Pacʉ yaa wiire wee bate, itia rʉmʉ jirora wãma wii ca quenogʉa, mʉ majuropeera ametʉaya. ¡Ʉmʉreco Pacʉ Macʉ̃ra mʉ ca niijata, duwicã dooya! —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ñucã paia ʉparã, doti cũuriquere ca jʉo buerã, to biri judíos're ca jʉo niirã mena jĩcãri, to biiri wãmera cʉ̃re ĩi buiwa. O biro ĩiwa: ");
INSERT INTO baoNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Aperãpʉra mʉ ametʉene majicãwʉ biigʉpʉa. Mʉ majuropeera mʉ ca biirije peera mʉ ametʉene majiti. ¡Cʉ̃a, Israel yepa macãrã wiogʉ niimi, cʉ̃ duwicã doojato! To cõro docare díámacʉ̃ cʉ̃re mani tʉo nʉnʉjeerucu. ");
INSERT INTO baoNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Cʉ̃a, Ʉmʉreco Pacʉre ca tʉo nʉnʉjeegʉ niimi. Mecʉ̃ docare Ʉmʉreco Pacʉ cʉ̃re cʉ̃ ametʉenejato, díámacʉ̃ra cʉ̃re cʉ̃ ca mai majuropeecãjata. Ania, “Ʉmʉreco Pacʉ Macʉ̃ yʉ nii,” ¿cʉ̃ ĩitiri? —cʉ̃re ĩi buiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ñucã jee dutiri maja, Jesús mena cʉ̃ja ca paa pua tuuricarã menapʉra, ñañarije cʉ̃re ĩi tutiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Jotoa decomacã ca niiro, ati yepa niipetiropʉ ca naitĩa peticoarique, ñucã muipũ bʉaro cʉ̃ ca aji ñaacũmu duwi waari tabe ʉnopʉ boewʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tii tabera Jesús pea tutuaro mena o biro ĩi acaro buiwi: —Eloí, Eloí, ¿lama sabactani? (Yʉ Ʉmʉreco Pacʉ, yʉ Ʉmʉreco Pacʉ, ¿ñee tiigʉ yʉre mʉ waa weocoati?) —ĩigʉ ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jĩcãrã too ca niirã to biro cʉ̃ ca ĩiro tʉorã, o biro ameri ĩiwa: —Ania, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Elías niiquĩricʉre jʉogʉ tiimi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","To biro cʉ̃ ca ĩirora, jĩcʉ̃ cʉ̃ja mena macʉ̃ ũmaa waa, upa jitia mena ʉje oco ca piyarijere joa amiri, yucʉgʉpʉ tii jitiare jia tuuri, cʉ̃re juu mʉene cojowi, “Cʉ̃ jinijato,” ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","To biro cʉ̃ ca tiiro, aperã pea o biro cʉ̃re ĩiwa: —Tiiticãña ména. Mani ĩaco, no cõro Elías cʉ̃re cʉ̃ ca ametʉenegʉ dooro —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ñucã, Jesús pea tutuaro mena acaro bui tʉja, bii yaicoawi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","To biro cʉ̃ ca biiri tabera Ʉmʉreco Pacʉ yaa wii jupea macã jawire cʉ̃ja ca yoo camotaarica quejero, decomacã emʉaro pee yega taticã duwi waaupa. Ñucã ati yepa cãa bʉaro nana, ʉ̃tãgaari cãa wati batecoa, ");
INSERT INTO baoNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","maja operi pãacoa, paʉ bojoca ca ñañarije manirã ca bii yaiquĩricarã cati tua, biiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Jesús cʉ̃ ca cati tuaro jiro, cʉ̃ja maja operipʉ ca niiricarã witi, ca ñañarije maniri macã Jerusalén'pʉ jãa waa, paʉ bojocare baua ĩño, biiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Uwamarã ʉpʉ, to biri cʉ̃ ʉmʉa, Jesús're ca ĩa cote niiricarã, ati yepa ca nanarijere, ñucã niipetiro ca biirijere ĩarã, bʉaro uwirique mena: —¡Díámacʉ̃ra ania, Ʉmʉreco Pacʉ Macʉ̃ peti niijapi! —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ñucã nomia paʉ romiri Jesús're ca tii nemoricarã Galilea yepapʉra ca nʉnʉ dooricarã romiri cãa, toora yoaropʉra ĩa cojocã niiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Cʉ̃ja menare niiwa, María Magdalena, Santiago, José jãari paco María, apeo Zebedeo puna paco, niiwa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Tii rʉmʉ naiori tabere eaupi jĩcʉ̃ ca apeye paigʉ, Arimatea macʉ̃ José ca wãme cʉtigʉ, cʉ̃ cãa, Jesús're ca tʉo nʉnʉjeegʉ ca niiricʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","To biri Pilato pʉtopʉ waari, Jesús upʉri niiquĩriquere yaa cõarʉgʉ, cʉ̃re jãiupi. To biro cʉ̃ ca ĩiro, Pilato pea Jesús upʉri niiquĩriquere cʉ̃re tiicojo dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","To biri José pea Jesús upʉri niiquĩriquere ami, ũmaarica quejero ca õweri maniri quejero mena cʉ̃re ũmaari, ");
INSERT INTO baoNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","maja ope, wãma ope ʉ̃tã tʉdipʉre cʉ̃ ca coa dotirica opepʉ cʉ̃re cũuupi. Jiro maja ope jãa waarica jopere ʉ̃tãgaaro mena tunuo biato, tuacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","María Magdalena, apeo María jãa pea, maja ope ãpõtĩñaarora ĩacã duwiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ape rʉmʉ, yerijãarica rʉmʉ maquẽre cʉ̃ja ca queno yueri rʉmʉ jiro macã rʉmʉre, paia ʉparã, to biri fariseos mena jĩcãri, Pilato pʉtopʉ waari, ");
INSERT INTO baoNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","o biro cʉ̃re ĩiupa: —Wiogʉ, õo ca niiquĩgʉ ca ĩi ditorique paigʉ niiquĩricʉ, ména catigʉpʉ, “Itia rʉmʉ jiro yʉ cati tuarucu,” cʉ̃ ca ĩiriquere jãa tʉgoeña bʉajãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","To biri mʉ ʉmʉare, cʉ̃ niiquĩricʉ maja opere itia rʉmʉ peti cʉ̃jare cote dotiya, cʉ̃ buerã waari, cʉ̃ upʉri niiquĩriquere ami duticãri, bojocare, “Mee, cati tuacoajãwi,” ĩi ditobocuma. To biro ca biijata docare yua, cʉ̃ ca ĩi dito jʉorique ametʉenero ĩi ditorique niibocu —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","To biro cʉ̃ja ca ĩiro, Pilato pea o biro ĩiupi: —Mee, cʉ̃jara mʉja cʉo coteri maja uwamarãre. Cʉ̃ja mena waari, mʉja ca bayiro cõro maja opere coteya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","To biri waa, maja opere añuro bia queno, ĩa majirʉgarã, cʉ̃ja ca biaricaga ʉ̃tãgare jʉgo ñee nemo, uwamarãre cote dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Yerijãarica rʉmʉ jiro macã rʉmʉ ape semana ca nii jʉori rʉmʉ ca boe doori rʉmʉre, meepʉacã María Magdalena, to biri apeo María, maja opepʉ ĩarã waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ca niiro tʉjarora, bʉaro yepa nanawʉ. Jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃, ʉmʉreco tutipʉ duwi doo, maja ope pʉto ea, tii opere cʉ̃ja ca biaricaga ʉ̃tãgare ami woo, tiiga jotoara ea nuucoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Cʉ̃ pea bʉpo cʉ̃ ca yaberijere biro ajiyaaupi. Cʉ̃ juti cãa oco weta ca botirore biro bʉaro botiupe. ");
INSERT INTO baoNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Uwamarã pea cʉ̃re ĩarã uwima ĩirã, bʉaro nana, ca dia waaricarãre biro biicã cũmu waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ʉmʉreco Pacʉ pʉto macʉ̃ pea o biro ĩiupi nomiare: —¡Uwiticãña! Yʉa, yucʉ tenipʉ cʉ̃ja ca paa pua tuucõajãgʉ Jesús're amarã mʉja ca biirijere yʉ maji. ");
INSERT INTO baoNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Manimi anora. Mʉjare cʉ̃ ca ĩiricarore biro cati tuacoajãwi mee. Cʉ̃re cʉ̃ja ca cũurica tabere ĩarã doo ñaaqué. ");
INSERT INTO baoNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yoari méé waari, cʉ̃ buerãre: “Mee, ca bii yairicarã watoare cati tuacoajapi Jesús. Mʉja jʉguero Galileapʉ waami. Toopʉ cʉ̃re mʉja ĩarucu,” cʉ̃jare ĩi wede dooya. Mee, mʉjare yʉ wede yerijãa —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","To biri nomia pea yoari méé maja opepʉ ca niiricarã bʉaro uwi pacarã, ʉjea niirique mena ũmaa tua dooupa, jãa, Jesús buerãre wederã doorã. ");
INSERT INTO baoNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","To biro cʉ̃ja ca bii tua waari tabera, Jesús pea cʉ̃jare añu doti jãiña baua ea nʉcãupi. Cʉ̃ja romiri pea cʉ̃ pʉto waa, cʉ̃ dʉporire paabario, cʉ̃re ĩi nʉcʉ̃ bʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesús pea o biro cʉ̃jare ĩiupi: —¡Uwiticãña! “Yʉ yee wederãre, Galileapʉ waarãja,” cʉ̃jare ĩi wederãja. Toopʉ yʉre ĩarucuma —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nomia cʉ̃ja ca tua nʉnʉa waaro ʉnora, jĩcãrã uwamarã maja opere ca cotericarã macãpʉ waari, cʉ̃jare ca biirique niipetiro wedeupa paia ʉparãre. ");
INSERT INTO baoNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Paia ʉparã pea ñucã, judíos're ca jʉo niirã mena nea, wede peni yapanori jiro, uwamarãre pairo wapa tiirica tiiri tiicojori, ");
INSERT INTO baoNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","o biro cʉ̃jare ĩi wede majioupa: —Mʉja pea, “Ñami jãa ca cãni ditoye cʉ̃ buerã doori, Jesús upʉri niiquĩriquere ami duticãjapa,” ĩi wedeya. ");
INSERT INTO baoNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ñucã ati yepa macãrã ʉpʉ atere cʉ̃ ca maji bʉacãjata, jãa, mʉjare jãa wede bojarucu. To biro tiiri, teere mʉjare jãa ametʉenerucu —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Uwamarã pea, wapa tiirica tiirire ñee, cʉ̃jare cʉ̃ja ca tii dotiricarore biro tiiupa. O biro cʉ̃ja ca ĩiriquere, judíos watoare mecʉ̃ripʉ cãare to birora ĩicõa niima. ");
INSERT INTO baoNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","To biri jãa, Jesús buerã, pʉa amo peti, dʉpore jĩcãga penituaro ca niirã pea Galileapʉ, “Toopʉ yʉ niirucu,” Jesús jãare cʉ̃ ca ĩi wederica macãnʉcʉ̃ buuropʉ jãa waacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesús're ĩarã, cʉ̃re jãa ĩi nʉcʉ̃ bʉowʉ, ména, jĩcãrã “Cʉ̃ra niimi” cʉ̃ja ca ĩiti pacaro. ");
INSERT INTO baoNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús pea jãa pʉto pee doo, o biro jãare ĩiwi: —Ʉmʉreco Pacʉ, ʉmʉreco tutipʉ cãare, ñucã ati yepa cãare, yʉ ca doti niipere yʉre tiicojojãwi. ");
INSERT INTO baoNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Tee tiirã waari, bojoca poogaari niipetirãpʉrena, yʉre ca tʉo nʉnʉjeerã cʉ̃ja ca niiro tiirãja. Ʉmʉreco Pacʉ wãme, cʉ̃ Macʉ̃ wãme, to biri Añuri Yeri wãme mena cʉ̃jare uwo coe, ");
INSERT INTO baoNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ñucã mʉjare yʉ ca dotirique cõrorena tee ca ĩirore biro cʉ̃ja ca tii nʉnʉjeepere biro ĩirã cʉ̃jare wede majio, tiiya. Yʉ pea, to cãnacã rʉmʉra, ati yepa ca petiropʉ mʉja menara yʉ niicõa niirucu —ĩiwi Jesús. To biro to biijato. Mateo");
INSERT INTO baoNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristo, Ʉmʉreco Pacʉ Macʉ̃ yee añurije queti ca nii jʉorije, ");
INSERT INTO baoNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Isaías, Ʉmʉreco Pacʉ yeere wede jʉgueri majʉ, o biro cʉ̃ ca ĩi owaricarore biro biiupa: “Yʉ yee queti wederi majʉre, mʉ jʉguero yʉ tiicojo, mʉre cʉ̃ maa queno yuejato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jĩcʉ̃, ca yucʉ maniri yepapʉ o biro ĩi acaro bui wederucumi: ‘Añuro tʉgoeñarique mena Wiogʉre yueya. Wiogʉ cʉ̃ ca eaparo jʉguerore, cʉ̃ ca doopa maare díámacʉ̃ maa cʉ̃ja ca queno yuerore birora, mʉja cãa mʉja yerire añuro cʉ̃re queno yueya.’ ” ");
INSERT INTO baoNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ate ca ĩirore biro Juan, ca yucʉ maniri yepapʉ uwo coe, ñañarije tiiriquere acobo ecorʉgarã, tʉgoeña yeri wajoari uwo coe dotirique maquẽre wede, bii eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Judea yepa macãrã niipetirã, Jerusalén macã macãrã, cʉ̃ ca wederijere tʉorã waarucuupa. Ñañarije cʉ̃ja ca tiiriquere wede ametʉene, cʉ̃ja ca tiiro Juan pea dia Jordán'pʉ cʉ̃jare uwo coeupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan juti pea camello poa mena tiirique nii, waibʉcʉ quejero daa wẽña, tiiupi. Cʉ̃ ca baarije pea yejeroa, macãnʉcʉ̃ macãrã dobea oco, niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","O biro ĩi wedeupi Juan: “Yʉ jiro doomi jĩcʉ̃, yʉ ametʉenero do biro ca tiiya manigʉ. Cʉ̃ dʉpo juti jiarica daari ʉno cãare muu biari ca popio cotepʉ ʉno méé yʉ nii yʉa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yʉa, oco mena mʉjare yʉ uwo coe. Cʉ̃ pea Añuri Yeri mʉjapʉre cʉ̃ ca ñaajãa nʉcãro tiiri, mʉja ca tʉgoeña yeri wajoaro tiirucumi,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tii rʉmʉrira Jesús, Galilea yepa macã macã Nazaret ca niiricʉ eaupi. Juan pea dia Jordán'pʉ cʉ̃re uwo coeupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Uwo coe eco yapano, maa nʉcãgʉra, ʉmʉreco tuti pãa nʉcãcoa, Añuri Yeri buare biigʉ bau duwi doo, cʉ̃pʉre cʉ̃ ca ñaapea earo ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ñucã ʉmʉreco tutipʉ wederique o biro ca ĩi wedeorijere tʉoupi: “Mʉa, yʉ Macʉ̃, yʉ ca maigʉ mʉ nii. Mʉ mena bʉaro yʉ ʉjea nii,” ĩiupe. ");
INSERT INTO baoNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ate jiro Añuri Yeri pea ca yucʉ maniri yepapʉ Jesús're amicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Toopʉ cuarenta rʉmʉri peti, waibʉcʉrã ca uwiorã watoa bii niigʉ, Satanás're ñañarije tii doti eco niiupi Jesús. Ʉmʉreco Pacʉ pʉto macãrã pea cʉ̃re tii nemo niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Juan're tia cũurica wiipʉ cʉ̃ja ca tia cũuro jiro, Jesús Galilea yepapʉ Ʉmʉreco Pacʉ yee añurije quetire wedegʉ waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","O biro cʉ̃jare ĩi wedeupi: “Cʉ̃ ca cõorica cuu eacoa. Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti niirije eacoaro bii. Ñañarijere tʉgoeña yeri wajoa, Ʉmʉreco Pacʉ yee añurije quetipere tʉo nʉnʉjeeya,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Galilea ʉtabʉcʉra tʉjaro waa nʉnʉa waagʉ, Simón, cʉ̃ yee wedegʉ Andrés mena wai jĩari maja niiri, cʉ̃ja bapi yucʉ mena ca wai waja niirãre ĩaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Cʉ̃jare ĩa: —Dooya yʉ mena. Yʉ pea waire mʉja ca waja bʉa majirore birora, bojocare ca waja bʉa majirã mʉja ca niiro mʉjare yʉ tiirucu —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","To cõrora cʉ̃ja pea jĩcãto cʉ̃ja bapi yucʉre cũu, cʉ̃ mena waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ñucã too jʉgueroacãra ĩaupi Jesús, Zebedeo puna Santiago, cʉ̃ bai Juan, cũmuapʉ cʉ̃ja bapi yucʉre ca jia jãa queno niirãre. ");
INSERT INTO baoNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ñucã cʉ̃ja cãare jʉoupi Jesús. Cʉ̃ja pea, cʉ̃ja pacʉ Zebedeore, cʉ̃re ca pade nemori maja menara cũmuapʉra cʉ̃re cũu, waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Capernaúm'pʉ earã yerijãarica rʉmʉ ca niiro, nea poo juu buerica wiipʉ jãa waari, cʉ̃jare bue jʉo waaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Doti cũuriquere ca jʉo buerãre biro méé, doti maji majuropeerique mena cʉ̃ ca buerijere tʉorã, bojoca pea do biro pee ĩiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Tii macã macã wii nea poo juu buerica wiipʉre niiupi jĩcʉ̃ ca wãtĩa jãa ecoricʉ. O biro cʉ̃re ĩi acaro buiupi: ");
INSERT INTO baoNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Jesús, Nazaret macʉ̃, ¿ñee tiigʉ jãare mʉ pato wãcõgʉ dooti? ¿Ñañaro jãare tiigʉ doogʉ mʉ biijãri? Mʉre yʉ maji. Mʉa, Ʉmʉreco Pacʉ yʉʉ, ca ñañarije manigʉ mʉ nii —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","To biro cʉ̃ ca ĩiro Jesús pea: —¡Wedeticãña! To cõrora cʉ̃re camotatiya —cʉ̃re ĩi tuti cõa wieneupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","To biro cʉ̃ ca ĩirora, wãtĩ pea cʉ̃ ca yugui mecʉ̃ro cʉ̃re tii, tutuaro acaro bui, witicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Teere niipetirãpʉra ĩa ʉcʉacoari, cʉ̃ja majurope o biro ameri ĩi jãiñaupa: —¿Ñee to niiti atea? Wãma wãme doti majirique mena bue, wãtĩapʉ cãare doticã, cʉ̃ ca dotirijere tʉo nʉnʉjee, biima —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","To biro Jesús cʉ̃ ca tiirique yoari méé Galilea yepa niipetiropʉre queti jeja nʉcãcoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nea poo juu buerica wiipʉ ca niiricarã witi waarã, Santiago, Juan mena waaupi Jesús, Simón, Andrés jãa yaa wiipʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simón mañico pea bʉaro wiorique dia yojaupo. Teere Jesús're wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","To biro cʉ̃ja ca ĩiro, cʉ̃ pea cõ pʉtopʉ waa, cõ amore ñeeri, cõre tʉ̃a wãmʉoupi. To biro cʉ̃ ca tiirora, jĩcãto wiorique yerijãacoaupa. Cõ pea cʉ̃jare jãi, baarique eca, tii waaupo. ");
INSERT INTO baoNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Naiori tabe muipũ cʉ̃ ca ñaajãaro jiro, niipetirã ca diarique cʉtirãre, ca wãtĩa jãa ecoricarãre, Jesús pʉtopʉ jee waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ñucã tii macã macãrã niipetirã Simón yaa wii jope pʉtore nea pooupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús pea paʉ bojoca bojorica wãmeri ca diarique cʉtirãre catio, ñucã paʉ wãtĩare cõa wiene, tiiupi. Wãtĩa peera cʉ̃ja ca wedero bootiupi, cʉ̃re cʉ̃ja ca majiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Boeri tabe ca naitĩa jañuropʉra wãcã, waacoaupi Jesús, macã tʉjaro ca bojoca maniropʉ juu buegʉ waagʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Jiro, Simón, cʉ̃ mena macãrã mena cʉ̃re amarã waa, ");
INSERT INTO baoNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","cʉ̃re bʉa earã, o biro cʉ̃re ĩiupa: —Niipetirã mʉre amarã tiima —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","To biro cʉ̃ja ca ĩiro Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Jamʉ. Ano pʉto jañuro ca niiri macãri pee mani waaco. Tii macãri macãrã cãare añurije queti cʉ̃jare yʉ ca wedepe nii. Teere ĩigʉra yʉ doowʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","To biri Jesús, Galilea yepa niipetiropʉ nea poo juu buerica wiijeripʉ añurije quetire wede, bojocapʉre ca niirã wãtĩare cõa wiene, tii yujuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Jĩcʉ̃ ca cami boa diarique cʉtigʉ Jesús pʉtopʉ ea, cʉ̃ pʉtopʉ cʉ̃ ãjʉro jupea mena ea nuuri: —Mʉ ca boojata, yʉ ca boarijere yʉre ametʉeneña —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","To biro cʉ̃ ca ĩiro cʉ̃re boo paca ĩari, cʉ̃ amo mena cʉ̃re ñia peo: —Mʉ yʉ ametʉenerucu, cami manigʉ tuaya —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","To biro Jesús cʉ̃ ca ĩirora, cami yaticoa, añugʉ, ca cami manigʉ tuaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Cʉ̃re catio yapano, o biro cʉ̃re ĩiupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Tʉoya. Jĩcʉ̃ ʉno peerena wedeticãña. Waari, paire ĩño, añugʉ mʉ ca tuarije jʉori Moisés cʉ̃ ca tii dotirique jee waagʉja, paia cʉ̃ja ca majipere biro ĩigʉ —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Cʉ̃ pea waa, dʉjaricaro maniro ca biiriquere wedecãupi. Tee jʉori Jesús pea, jĩcã macã peerena bau niiro ea majitima ĩigʉ, macã tʉjaro ca bojoca maniropʉra tuacãrucuupi. To cʉ̃ ca bii pacaro, niipetiri taberi macãrã bojoca cʉ̃re ĩarã earucuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ñucã jĩcã rʉmʉri jiro Jesús Capernaúm'pʉ cʉ̃ ca earo, “Tii wii niijagʉ,” cʉ̃ja ca ĩirijere bojoca tʉo peticã cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","To cõrora paʉ, macã yepare noo pee nucũ majiña maniro dada nʉcãcoaupa. Cʉ̃ pea añurije quetire cʉ̃jare wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Too cʉ̃ ca wede niiro bapari niirã, jĩcʉ̃ ca bʉʉricʉre cʉ̃re ami eaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Paʉ bojoca cʉ̃ja ca niiro macã, Jesús pʉtopʉ cʉ̃re ami ea waa majitima ĩirã, wii jotoa pee mʉa waa, Jesús cʉ̃ ca nucũro jotoa jĩcã jope jee woori, ca bʉʉgʉre cʉ̃ ca yojari quejero menara cʉ̃re yoo duwio cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús pea, “Jesús cʉ̃re catiocãrucumi,” cʉ̃ja ca ĩi tʉgoeña bayirijere ĩari, o biro ĩiupi ca bʉʉgʉre: —Macʉ̃, ñañarije mʉ ca tii bui cʉtirique acoboriquepʉ nii mee —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Jĩcãrã doti cũuriquere ca jʉo buerã too ca duwirã pea o biro ĩi tʉgoeñaupa: ");
INSERT INTO baoNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ñee tiigʉ ania to biirije peti cʉ̃ ĩicãti? Ʉmʉreco Pacʉre ñañarije ĩi tutigʉ tiimi. Ʉmʉreco Pacʉ wado ñañarije tii bui cʉtiriquere acobo majimi,” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","To biro cʉ̃ja ca ĩiri nimarora, Jesús pea to biro cʉ̃ja ca ĩi tʉgoeñarijere majiri, o biro cʉ̃jare ĩi jãiñaupi: —¿Ñee tiirã to biirije mʉja ĩi tʉgoeñati? ");
INSERT INTO baoNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Di wãme pee to niiti popiye méé ca bʉʉricʉre ĩirica wãme: “Ñañarije mʉ ca tii bui cʉtirique acoboriquepʉ nii,” ĩirique, “Wãmʉ nʉcã, mʉ ca cũari quejerore ami waagʉja,” ĩirique pee? ");
INSERT INTO baoNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Yʉ, Ca Nii Majuropeegʉ Macʉ̃ ati yepapʉre ñañarijere tii bui cʉtiriquere ca acobo majigʉ yʉ ca niirijere mʉja ca majipere biro ĩigʉ mʉjare yʉ ĩñorucu —ĩiupi Jesús. To biro ĩigʉra, ca bʉʉricʉre o biro cʉ̃ ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Mʉre yʉ ĩi: ¡Wãmʉ nʉcãña! Mʉ ca cũaricarore ami, waagʉja mʉ yaa wiipʉ —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","To cõrora cʉ̃ pea wãmʉ nʉcã, cʉ̃ ca cũarica quejerore ami, niipetirã cʉ̃ja ca ĩa cojoro witi, waacoaupi. To biro cʉ̃ ca biiro ĩarã, niipetirã ĩa ʉcʉacoari, Ʉmʉreco Pacʉre o biro ĩi nʉcʉ̃ bʉoupa: —Jĩcãti ʉno peera ate ʉnore mani ĩatiwʉ —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jiro waaupi ñucã Jesús ʉtabʉcʉra tʉjaropʉ. Paʉ bojoca cʉ̃re nea pooupa. To biro cʉ̃ja ca biiro cʉ̃ pea cʉ̃jare buecõa niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Too ametʉa waagʉ, Alfeo macʉ̃ Leví, Roma maquẽre wapa jee bojagʉ cʉ̃ ca duwiri tabepʉ ca duwigʉre ĩa, o biro cʉ̃re ĩiupi: “Yʉ mena dooya.” To biro cʉ̃re cʉ̃ ca ĩirora, Leví pea wãmʉ nʉcã, cʉ̃re nʉnʉcoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jesús, Leví yaa wiipʉ cʉ̃ ca baa niiro, paʉ Roma maquẽre wapa jee bojari maja, “Ñañarije ca tiirã niima,” bojoca cʉ̃ja ca ĩi ĩarã, Jesús, cʉ̃ buerã menare baa bapa cʉti duwiupa. Cʉ̃re ca nʉnʉrã paʉ bojoca niiupa mee. ");
INSERT INTO baoNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Cʉ̃ja mena cʉ̃ ca baa bapa cʉtiro ĩari, jĩcãrã doti cũuriquere ca jʉo buerã fariseos ca niirã, o biro ĩi jãiñaupa cʉ̃ buerãre: —¿Ñee tiigʉ mʉjare ca buegʉ pea Roma maquẽre wapa jee bojari maja mena, ñañarije ca tiirã mena, cʉ̃ baa bapa cʉti niiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús pea teere tʉo, o biro cʉ̃jare ĩi yʉʉupi: —Ca diarique manirã ʉco tiiri majʉre amaatima. Ca diarique cʉtirã amaama. Yʉa, añurãre jʉogʉ doogʉ méé yʉ doowʉ. Ñañarã peere jʉogʉ doogʉ yʉ doowʉ —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jĩcãti Juan buerã, fariseos buerã, betiri juu buerã tiiupa. To biro cʉ̃ja ca tiiro ĩari, jĩcãrã Jesús pʉto waari, o biro ĩi jãiñaupa: —Juan buerã, fariseos buerã, betiri juu buema. Mʉ buerã pea ¿ñee tiirã cʉ̃ja betititi? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —¿To docare, jĩcʉ̃ ca amo jiagʉ cʉ̃ ca jʉoricarã, cʉ̃ja mena cʉ̃ ca niirora cʉ̃ja beti cotebogajati? Ca amo jiagʉ cʉ̃ja mena cʉ̃ ca niirora beti majitima. ");
INSERT INTO baoNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Biiropʉa niirucu jĩcã rʉmʉ, ca amo jiagʉre cʉ̃ja ca ami weo waari rʉmʉ. Tii rʉmʉ docare betirucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","”Jĩcʉ̃ ʉno peera jutiro bʉcʉrore wãma quejero mena sere tuu quenotimi. To biro tiijata, wãma quejero pee bʉcʉro peere tʉ̃a yega, pairi ope yega nemocoacu. ");
INSERT INTO baoNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ñucã ʉje oco wãma cãare, waibʉcʉ quejero poa, bʉcʉ poapʉ pio jãaña mani. Bʉcʉ poare ʉje oco wãmare pio jãajata, tii poare tii yegacãcu. To biri ʉje oco cãa pio batecoa, tii poa cãa yega yaicoa, biicu. To biro biire ĩirã, ʉje oco wãmare waibʉcʉ quejero poa wãma poapʉ ca pio jãape nii —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jĩcã rʉmʉ, yerijãarica rʉmʉ ca niiro, Jesús ote wejerire cʉ̃ ca ametʉa waaro, cʉ̃ buerã pea to waa nʉnʉa waarã, ca dicare tune jee nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","To biro cʉ̃ja ca tiiro, fariseos pea o biro cʉ̃re ĩi jãiñaupa: —¡Ĩaña! ¿Ñee tiirã mʉ buerã pea, yerijãarica rʉmʉre ca tii dotitirijere cʉ̃ja tiiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩiupi: —¿Jĩcãti ʉno peera mʉja bue ñaatiti, jĩcãti David cʉ̃ mena macãrã mena ñee jãa mani, queya, biima ĩirã cʉ̃ ca tiiriquere? ");
INSERT INTO baoNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abiatar, paia wiogʉ cʉ̃ ca niiri tabere David, Ʉmʉreco Pacʉ yaa wiipʉ jãa waa, Ʉmʉreco Pacʉ yee cʉ̃ja ca jee dica woorique pan, paia wadore cʉ̃ja ca baa dotimiriquerena baa, cʉ̃ mena macãrã cãare eca, tiiupi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","O biro cʉ̃jare ĩi nemoupi ñucã: —Añuro mani ca niipere ĩigʉ, yerijãarica rʉmʉre cũuupi Ʉmʉreco Pacʉ. Yerijãarica rʉmʉ pee manire too dotijato ĩigʉ mee, yerijãarica rʉmʉre cũuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","To biri yʉ, Ca Nii Majuropeegʉ Macʉ̃, yerijãarica rʉmʉ cãare yʉ doti majicã —ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jiro, nea poo juu buerica wiipʉre jãa waaupi ñucã Jesús. Tii wiipʉre niiupi jĩcʉ̃, cʉ̃ amo ca bʉʉricʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jĩcãrã Jesús're ca wedejãarʉgarã, jĩcã wãme cʉ̃ ca tii bui cʉtirijere ca ama niirã, “¿Yerijãarica rʉmʉrena cʉ̃ catiocãgʉti?” ĩirã, cʉ̃re ĩa doe niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","To cõrora Jesús pea o biro ĩiupi, ca amo bʉʉricʉre: —Wãmʉ nʉcã doori, decomacã pee ea nʉcãña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Aperã peera o biro cʉ̃jare ĩi jãiñaupi: —¿Yerijãarica rʉmʉre ñeere to tii dotiti, añurijere, ñañarije peere, bojocare catioriquere, jĩa cõarique peere? —ĩiupi. Cʉ̃ja pea wedetiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesús pea, ajiarique mena cʉ̃ weja ca niirãre ĩa, cʉ̃ja ca tʉo nʉnʉjeerʉgatirijere bʉaro tʉgoeñarique pairi, o biro ĩiupi ca amo bʉʉricʉre: —Mʉ amore juu pooya —ĩiupi. To biro cʉ̃ ca ĩiro, cʉ̃ amo cʉ̃ ca juu poorora añuri amo biicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseos pea witicoarãpʉa, Herodes cʉ̃ ca ĩirijere ca tʉo nʉnʉjeerã mena nea poori, Jesús're cʉ̃ja ca jĩapere ameri wede peni jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús, cʉ̃ buerã mena ʉtabʉcʉra tʉjaro cʉ̃ ca waaro, paʉ bojoca Galilea yepa macãrã cʉ̃jare nʉnʉ waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Niipetirije Jesús cʉ̃ ca tiirijere queti tʉori, paʉ bojoca, Judea macãrã, Jerusalén macãrã, Idumea macãrã, dia Jordán ape nʉña macãrã, Tiro, Sidón yepari macãrã Jesús're ĩarã dooupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","To biirije cʉ̃ja ca biiro macã, Jesús pea, bojoca yʉre waa tuumicõabocuma ĩigʉ, cʉ̃ buerãre: “Petigaacã cũmua mʉja poo yuewa,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Paʉre cʉ̃ ca catioro macã, niipetirã ca diarique cʉtirã cʉ̃re padeñarʉgarã, tuu jua nʉnʉa dooupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ñucã wãtĩa bojocapʉre ca niirã cãa, Jesús're ĩarãra, cʉ̃ jʉguero cʉ̃ja ãjʉro jupeari mena ea nuuri: —¡Mʉa, Ʉmʉreco Pacʉ Macʉ̃ mʉ nii! —cʉ̃re ĩi acaro buirucuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesús pea cʉ̃jare wede dotitiupi, cʉ̃ra cʉ̃ ca niirijere wede majiorema ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jiro Jesús ʉ̃tãgʉpʉ mʉa waa, cʉ̃ ca boorãre jʉoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Cʉ̃ja pea cʉ̃ pʉto pee nea waaupa. Pʉa amo peti, dʉpore pʉaga penituaro ca niirã cʉ̃re bapa cʉti, añurije quetire wede doti cojo, ");
INSERT INTO baoNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","wãtĩare cõa wiene doti majirique cʉ̃jare ʉpo, cʉ̃ ca tiiparãre beje jeeupi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Anija niiupa pʉa amo peti, dʉpore pʉaga penituaro niirã cʉ̃ ca beje jeericarã: Simón, ñucã cʉ̃rena Pedro cʉ̃ ca ĩiricʉ, ");
INSERT INTO baoNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Zebedeo puna “Boanerges” cʉ̃ ca ĩiricarã, Santiago, cʉ̃ bai Juan, “Bʉpo Puna” ĩirʉgaro ĩi, ");
INSERT INTO baoNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Alfeo macʉ̃ Santiago, Tadeo, ñucã apĩ Simón celote bojocʉ, ");
INSERT INTO baoNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","apĩ Judas Iscariote jiro Jesús're ca wedejãa buiyee cõaricʉ, niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jiro Jesús wiipʉ cʉ̃ ca jãa waaro, paʉ bojoca neaupa ñucã, Jesús, cʉ̃ buerã, do biro tii cʉ̃ja ca baa majitiropʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","“Mecʉ̃cã yai waami Jesús,” cʉ̃ja ca ĩirijere tʉori, cʉ̃ yaarã pea cʉ̃re jʉorã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ñucã doti cũuriquere ca jʉo buerã Jerusalén'pʉ ca dooricarã cãa, o biro ĩiupa: “Beelzebú, wãtĩa wiogʉ majuropeera cʉ̃ ca yeri tutuarijere cʉ̃ ca tiicojoricʉ niiri, wãtĩare cõa wiene majimi,” ĩiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","To biro cʉ̃ja ca ĩiro, Jesús pea cʉ̃jare jʉo cojo, ĩi cõoñarique mena cʉ̃jare wedeupi: “¿Do biro tiigʉ Satanás cʉ̃ majuropeera cʉ̃ cõa wienebogajati? ");
INSERT INTO baoNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Jĩcã yepa macãrãra cʉ̃ja majuropeera ameri camotati, cʉ̃ja ca ameri ĩa juna niijata, añuro nii yapano nʉcãticuma. ");
INSERT INTO baoNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Jĩcã wii macãrãra ameri camotati, cʉ̃ja ca ameri ĩa juna niijata, añuro nii yapano nʉcãticuma. ");
INSERT INTO baoNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tii wãmere birora Satanás cãa cʉ̃ yaarãrena cʉ̃ ca ĩa junajata, añuro jʉo nii majiticumi. To cõrora yapano nʉcãgʉ biicumi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jĩcʉ̃ ʉno peera bojocʉ ca tutuagʉ yaa wiire jãa waari, cʉ̃re jia cũu jʉotigʉra cʉ̃ yee apeyere jee duti majiticumi. Cʉ̃re jia cũucã jʉoripʉ docare, cʉ̃ yee apeyere jee duti majibocumi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Díámacʉ̃ mʉjare yʉ ĩi: Niipetirije ñañarije cʉ̃ja ca tiiriquere, ñañarije cʉ̃ja ca ĩirijere, acoborucumi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","To ca bii pacaro, Añuri Yerire ñañarije ca ĩi tutigʉ doca, ñañarije cʉ̃ ca ĩi bui cʉtiriquere, jĩcãti ʉno peera coe ecotirucumi. To birora ñañaro cʉ̃ ca ĩi bui cʉtirique menara bii yai nʉcãcãrucumi,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Ca wãtĩ jãa ecoricʉ niimi” cʉ̃re cʉ̃ja ca ĩirije jʉori, atere to biro cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","To biro cʉ̃ ca ĩi niiri tabera, Jesús paco, cʉ̃ bairã, eaupa. Macãpʉra tua nʉcãri, jĩcʉ̃re cʉ̃re jʉo dotirã tiicojo cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Paʉ bojoca cʉ̃ weja ca duwirã pea o biro cʉ̃re ĩiupa: —Mʉ paco, mʉ bairã mʉre amama. Macãpʉ niima —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi: —¿Noa cʉ̃ja niiti, yʉ paco, yʉ bairã? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","To biro ĩi, cʉ̃ weja ca duwi amojoderãre ĩa, o biro ĩiupi: —Anija niima yʉ paco, yʉ bairã, ca niirã. ");
INSERT INTO baoNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","No ca boorã Ʉmʉreco Pacʉ cʉ̃ ca boorijere ca tiirã niima, yʉ bai, yʉ baio, yʉ paco, ca niirã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ñucã Jesús, ʉtabʉcʉra tʉjaropʉ bojocare bue jʉo waaupi. Bojoca cʉ̃ weja ca nea poorã paʉ cʉ̃ja ca niiro macã, Jesús pea cũmua tiira weja ca pajaricare ea jãa, ea nuu waaupi, bojoca pea ʉtabʉcʉra tʉjaro cʉ̃ja ca niiro ʉno. ");
INSERT INTO baoNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","To cõrora paʉ wãmeri ĩi cõoñarique mena cʉ̃jare wedeupi Jesús. O biro ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Añuro tʉoya. Jĩcʉ̃ oteri majʉ cʉ̃ otere otegʉ waaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Cʉ̃ ca otero, jĩcã apegaari maapʉ ñaaupe. Minia ea, teere baacãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ape gaari ʉ̃tã watoa, ca jita mani jañuri tabere ñaaupe. Tee pea yoari mééra wiicoaupe, ʉje meniroacã jita niima ĩiro, ");
INSERT INTO baoNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","noo pee nʉcõri waa majiti, muipũ cʉ̃ ca aji mʉa doorora jinicã yai waaupe. ");
INSERT INTO baoNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ape gaari pota yucʉ watoapʉ ñaaupe. Ca dica manirora pota yucʉ pee teere wii biato yaiocãupe. ");
INSERT INTO baoNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ape gaari añuri jitapʉ ñaaupe. To biri añurije wii, bʉcʉa, añuro dica cʉtiupe, jĩcã jati treinta apegaari, ape jati sesenta niiricari, ape jati cien'gaari peti dica cʉtiupe —ĩi wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","To biro ĩi, “Mʉja ca tʉo majirʉgajata, añuro yʉre tʉo nʉnʉjeeya,” cʉ̃jare ĩi nemoupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jĩcʉ̃ra Jesús cʉ̃ ca tuaro, cʉ̃ pʉto ca niiricarã, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena, cʉ̃ ca ĩi cõoña wederiquere: “¿Do biro ĩirʉgaro to ĩiti?” cʉ̃re ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","O biro cʉ̃jare ĩiupi cʉ̃ pea: “Mʉjara, Ʉmʉreco Pacʉ, cʉ̃ ca doti niiri tabe maquẽ, ca majiña manirijere mʉja ca majiro tiimi. Aperã peera ĩi cõoñarique mena wado cʉ̃jare wedemi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","”Ĩa pacarã, ĩa jeeñoti, tʉo pacarã, tʉo puoti, ñucã ñañarije cʉ̃ja ca tiirijere tʉgoeña yeri wajoa, cʉ̃ja ca biro Ʉmʉreco Pacʉ pea cʉ̃ja ca ñañarijere acobo, cʉ̃ ca tiitipere biro ĩigʉ,” cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","O biro ĩi nʉnʉa waaupi: —¿Ate yʉ ca ĩi cõoñajãrijere mʉja tʉo puotiti? ¿Do biro pee tiicãri apeye peera mʉja tʉo puo majirãti? ");
INSERT INTO baoNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Oteri majʉa añurije quetire wederi majʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Jĩcãrã, añurije quetire tʉorã maa pʉto oterica tabere biro ca biirã niima. Jiro Satanás doo, añuro cʉ̃ja yeripʉ cʉ̃ja ca tʉo ñeemiriquere cʉ̃jare ẽmacãmi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aperã, ca ʉ̃tã cʉtiri yepare otericarore biro ca biirã niima. Añurije quetire tʉorã, añuro ʉjea niirique mena tʉoma. ");
INSERT INTO baoNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Paʉ nʉcõri manima ĩiro, añuro tutua añurije ca niitirore birora tʉgoeña bayitima. To biri añurije queti jʉori ñañaro cʉ̃jare ca bii earora, ñañaro cʉ̃jare cʉ̃ja ca tiirʉga nʉnʉjeerora, añurije quetire tʉo nʉnʉjee yerijãacãma. ");
INSERT INTO baoNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aperã, pota watoa oteriquere biro biima: Añurije quetire tʉoma, ");
INSERT INTO baoNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","tʉo pacarã, cʉ̃ja ca catiri rʉmʉrire cʉ̃ja ca cʉorʉga tʉgoeñarije, pairo apeye cʉtirʉgarique, niipetirije cʉorʉga tʉgoeñarique pee cʉ̃jare bii ametʉene, añurije queti cʉ̃ja ca tʉomiriquere, ca dica manirora ca wii bʉato yaioricarore biro teere tii yaiocã. ");
INSERT INTO baoNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aperã añuri jitapʉ oteriquere biro niima. Añurije quetire tʉo, nʉcʉ̃ bʉorique mena cʉ̃ja yeripʉ tʉo ñeema. Cʉ̃ja niima, jĩcã jati treinta, sesenta, cien ca dica cʉtiricarore biro ca biirã —cʉ̃jare ĩi wede majioupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Cʉ̃jare ĩiupi ñucã: —¿Jĩa boericagare upa cũmua docapʉ, cãni pejarica tabe doca pee, doporʉgarã ami doorique to niiti? ¡Biiticu! To ʉ̃ʉ boe pejajato ĩirã emʉaro pee peorique nii. ");
INSERT INTO baoNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Teere birora yaioropʉ ca niirije majiña manirijera biicã yerijãa waa, ca biirije mani. Ñucã jĩcãrãra majirique cãa, niipetirãpʉ majiña manirijera niicã nʉnʉa waa, ca biirije mani. Yʉ wederique majiña manirora yai nʉcãcoa biitirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ca amoperi cʉtirã tʉoya yʉ ca ĩirijere —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","O biro cʉ̃jare ĩiupi ñucã: —Mʉja ca tʉorijere añuro tʉoya. Yʉ yee quetire aperãre mʉja ca wede majioro cõrora, mʉjare majiorucumi Ʉmʉreco Pacʉ. Bʉaro jañuro mʉja ca majiro tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Yʉ yee quetire aperãre ca wede majiogʉa, bʉaro jañuro majiriquere tiicojo ecorucumi. To biro ca tiitigʉa, petoacã cʉ̃ ca majirʉga tʉgoeñamirijeacã menapʉra ẽma ecocoarucumi —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","O biro cʉ̃jare ĩi wedeupi ñucã: —Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, jĩcʉ̃ otere yepapʉ cʉ̃ ca oterore biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Cʉ̃ ca cãniro, cʉ̃ ca cãnitijata cãare, ñami, ʉmʉreco, “To biro biicu,” cʉ̃ ca ĩi majiti pacaro, tee majuropeera wii, bʉcʉa mʉa, biicu. ");
INSERT INTO baoNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Jita majuropeera ote ca bʉcʉaro tii, upaño bʉcʉa jʉo, oo yucʉ nʉcã, jiro dica cʉti, ca biiro tii. ");
INSERT INTO baoNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ca dica ca bʉcʉa yapanorãra, teere jeema, ca dica jeerica tabe ca earo macã —ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O biro ĩiupi ñucã Jesús: —¿Ñee mena Ʉmʉreco Pacʉ cʉ̃ ca doti niirijere mani ĩi cõoñarãti? ¿Ñee ĩi cõoñarique mena, “To biirije bii” ĩi majirʉgarã mani ĩi cõoñabogajati? ");
INSERT INTO baoNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Jĩcãga mostaza apega, ote ape niipetirije dʉaricaacã ca niiricare yepapʉ ote, ");
INSERT INTO baoNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","tiiricaro jiro bʉcʉa, niipetirije ote weje maquẽ ametʉenericʉ bii, paca dʉpʉri cʉti, tiigʉ dʉpʉri ca yʉjʉri taberire minia yerijãa peja, cʉ̃ja ca biirore biro bii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Paʉ wãmeri atere biirije ĩi cõoñari añurije quetire wedeupi Jesús, cʉ̃ja ca tʉo majiro cõro. ");
INSERT INTO baoNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ĩi cõoñarique manirora cʉ̃jare wede, tiitiupi. Biigʉpʉa, cʉ̃ buerã peera niipetirije cʉ̃jare wede majio peoticãrucuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Tii rʉmʉ naiori tabere, cʉ̃ buerãre o biro ĩiupi Jesús: —Jamʉ, ʉtabʉcʉra ape nʉñapʉ mani tĩa waaco —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","To biro cʉ̃ ca ĩiro, bojocare waarique wui, Jesús cʉ̃ ca niiricagara ea jãa, tĩacoaupa. Too cʉ̃ja ca tĩa waaro, aperã cãa ape cũmuari mena cʉ̃jare bapa cʉti waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Too cʉ̃ja ca tĩa nʉnʉa waaro, tutuaro wino paa puuma ĩiro cũmuare pairo oco jabe jãaupe. ");
INSERT INTO baoNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesús pea ména to biro ca biiparo jʉguero cũmua waa tuurica tua pee waa, juti poti mena cʉ̃ dʉpʉgare eo tuuri cãnicã jãa waaupi. Too ca cãni jãñagʉre wãcõri, o biro cʉ̃re ĩiupa cʉ̃ buerã pea: —¿Buegʉ, dua waarã mani ca biirijere “To biro biicu,” mʉ ĩiticãti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","To biro cʉ̃ja ca ĩiro Jesús pea wãmʉ nʉcã, winore, oco ca jaberijere, o biro ĩi yerijãa dotiupi: —Yerijãa waaroja. Jabe nemoticãña —ĩiupi. To biro cʉ̃ ca ĩirora, jĩcãto añuropʉ yerijãa peticoaupe. ");
INSERT INTO baoNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jiro o biro ĩiupi Jesús cʉ̃ buerãre: —¿Ñee tiirã to cõro bʉaro mʉja uwiti? ¿“Manire ametʉenecãrucumi,” mʉja ĩi tʉgoeña bayiticãti ména? —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Cʉ̃ja pea to biro cʉ̃ ca tiirijere ĩa ʉcʉa yaicoari, o biro ameri ĩi jãiñaupa: —¡Ayó nija! ¿Ñiru ʉno peti cʉ̃ niiti ania, wino, oco ca jaberijepʉ cãa cʉ̃ ca dotirore biro ca yʉʉ nʉnʉjee ecogʉa? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","To biro bii, ʉtabʉcʉra ape nʉña Gerasa yepapʉre tĩa ea waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús cʉ̃ ca maa nʉcãrije menara, jĩcʉ̃ ʉmʉ ca wãtĩ jãa ecoricʉ, maja operi watoapʉ ca niirucuricʉ eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Jĩcʉ̃ ʉno peera jiaricʉ méé, come daari mena cãare jiaricʉ ʉno méé niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Biirãpʉa paʉ tiiri come daari mena cʉ̃ dʉporire, cʉ̃ amorire cʉ̃ja ca jiamijata cãare, tʉ̃a jude batecãrucuupi, jĩcʉ̃ ʉno peera do biro cʉ̃ja ca tiitiropʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ʉmʉrecori, ñamiri, ʉ̃tãgʉʉripʉ, maja operi watoaripʉ cʉ̃ majuropeera ʉ̃tãgaaripʉ ñaatua, acaro bui, waa nucũ yujurucuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","To biri Jesús're yoaropʉra cʉ̃re ĩari, ũmaa doo, cʉ̃ ãjʉro jupeari mena cʉ̃ jʉguero ea nuuri, ");
INSERT INTO baoNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","o biro cʉ̃re ĩi acaro buiupi: —Jesús, Ʉmʉreco Pacʉ ati ʉmʉreco niipetiropʉre Ca Doti Niigʉ Macʉ̃, yʉre pato wãcõticãña, Ʉmʉreco Pacʉ mena mʉre yʉ ĩi, ñañaro yʉ ca tamʉoro yʉre tiiticãña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","—To cõrora anipʉre witi waagʉja —Jesús cʉ̃ ca ĩiro macã, atere to biro ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","To biro cʉ̃ ca ĩiro: —¿Do biro mʉ wãme cʉtiti? —cʉ̃re ĩi jãiñaupi Jesús. To biro cʉ̃ ca ĩiro cʉ̃ pea: —Paʉ jãa ca niirije niiri, Legión yʉ wãme cʉti —cʉ̃re ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","“Ape yepapʉ jãare tiicojo cõaticãña,” bʉaro ĩi jãiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tii tabe jʉguero, ʉ̃tãgʉ pʉtore paʉ ecaricarã yejea baa niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wãtĩa, bojocʉpʉre ca niirã pea: —Ĩijã, yejeapʉre jãare jãa dotiya —cʉ̃re ĩi jãiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","To biro cʉ̃ja ca ĩiro, cʉ̃japʉre cʉ̃jare jãa dotiupi. To biri cʉ̃pʉre ca niiricarã witi waari, yejeapʉre jãaupa. Yejea dos mil peti ca niiricarã pea, wãtĩa cʉ̃japʉre cʉ̃ja ca jãarora ũmaa mecʉ̃ bua waa, ʉtabʉcʉrapʉ ñaañua, dua peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","To biro cʉ̃ja ca biiro ĩarã, yejeare ca cote niiricarã pea yoari méé ũmaa tua waari, macã macãrãre, ñucã macã tʉjaro macãrãre, to biro ca biiriquere cʉ̃jare wederã waaupa. Bojoca pea teere tʉorã, to biro ca biiriquere ĩarã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesús cʉ̃ ca niiropʉ earã, paʉ wãtĩa ca jãa ecomiricʉre juti jãñacãri, añuro tʉgoeña bojoca catigʉpʉ cʉ̃ ca duwiro ĩari, bʉaro uwiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ca wãtĩa jãa ecomiricʉ cʉ̃ ca biiriquere, yejea cʉ̃ja ca biiriquere ca ĩaricarã pea, “O biro biijãwʉ,” cʉ̃jare ĩi wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Teere tʉori, “Aperopʉ waacoagʉja. Jãa ca niiri tabere niiticãña,” cʉ̃re ĩiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","To biro cʉ̃ja ca ĩiro Jesús waagʉ, cʉ̃ ca bua jãarora, paʉ wãtĩa cʉ̃ja ca jãñagʉre cʉ̃ ca catioricʉ pea, cʉ̃ mena waarʉgʉ cʉ̃re jãimiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","To biro cʉ̃ ca ĩiro Jesús pea: —Mʉ yaarã pʉto pee tua waari, Ʉmʉreco Pacʉ mʉre cʉ̃ ca tiirique niipetirijere, mʉre cʉ̃ ca ĩa boo pacariquere, wede peoticãña mʉ yaarãre —cʉ̃re boca ĩicãupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","To biro Jesús cʉ̃re cʉ̃ ca ĩiro tua waa, Decápolis yepare ca niiri macãri macãrãre niipetirije Jesús cʉ̃re cʉ̃ ca tiiriquere wedeupi. Teere tʉorã, niipetirã bojoca do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesús ʉtabʉcʉra ape nʉñapʉ ca niiricʉ cʉ̃ ca tua tĩa earo jiro, paʉ bojoca cʉ̃re nea pooupa. Cʉ̃ pea tiira tʉjaropʉra tua nʉcãupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tii tabere jĩcʉ̃ nea poo juu buerica wii wiogʉ, Jairo ca wãme cʉtigʉ eaupi. Jesús're ĩari, cʉ̃ pʉto cʉ̃ ãjʉro jupeari mena ea nuu waa: ");
INSERT INTO baoNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—Yʉ macõacã dia waagopʉ tiijãwo. Doori, mʉ amo mena cõre ñia peogʉ dooya, diarique ametʉa, cati, cõ biijato ĩigʉ —bʉaro cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","To biro cʉ̃ ca ĩiro Jesús, Jairo mena cʉ̃ ca waa nʉnʉa waaro, paʉ bojoca cʉ̃re bapa cʉti waarã, ʉta bijaroacã ameri tuutu nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Cʉ̃ja patoacã watoare niiupo jĩcõ nomio, pʉa amo peti, dʉpore pʉaga penituaro niiri cʉ̃mari peti ca díi tatitirije ca diarique cʉti niigo. ");
INSERT INTO baoNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Paʉ ʉco tiiri majare ʉco tii doti, wapa tiima ĩigo, cõ ca cʉomiriquere noni peoticãupo. To biro tii pacago ametʉaricaro maniro, bʉaro jañuro ñañaro bii nʉnʉa waaupo. ");
INSERT INTO baoNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","To biri Jesús yee maquẽre queti tʉori, bojoca watoapʉ cʉ̃ jiro pee waari, cʉ̃ jutirore padeñaupo, ");
INSERT INTO baoNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Cʉ̃ jutirore yʉ ca padeña eyorije mena wadora, yʉ diarique ametʉarucu,” ĩi tʉgoeñari, to biro tiiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Cʉ̃ jutirore cõ ca padeñarije menara, ca díi waarije tatiupe. To cõrora cõ upʉri diarique manigo cõ ca tuarijere tʉgoeña majiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús pee cãa, cʉ̃ ca tʉgoeña tutuarije to ca witi ũmaa waaro tʉgoeña majiri, bojoca peere amojode ĩa: —¿Ñiru yʉ jutirore cʉ̃ padeñajãri? —ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","To biro cʉ̃ ca ĩiro tʉori, cʉ̃ buerã pea o biro ĩiupa: —¿Paʉ bojoca ʉta bijaroacã cʉ̃ja ca tuumicõa nʉnʉa dooro ĩa pacagʉ, “¿Noa yʉre cʉ̃ja padeñati?” mʉ ĩiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","To biro cʉ̃ja ca ĩi pacaro, Jesús pea cʉ̃ weja ca niirãre ĩacã niiupi, “¿Noa peti cʉ̃ja padeñabujapari?” ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","To cõrora cõ pea, bʉaro uwi nanarique mena cõre ca biiriquere majiri, cʉ̃ pʉto waa, ãjʉro jupea mena ea nuu waari, cõre ca biiriquere díámacʉ̃ cʉ̃re wede peoticãupo. ");
INSERT INTO baoNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús pea o biro cõre ĩiupi: —Macõ, “Jesús yʉre catiocãrucumi,” mʉ ca ĩi tʉgoeña bayirijera mʉ diariquere ametʉene. Mee, diarique manigopʉ tʉgoeñarique paitigora tua waagoja —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ména Jesús cʉ̃ ca wede niirora eaupa jĩcãrã nea poo juu buerica wii wiogʉ yaa wii macãrã, wimago pacʉre: —Mee, mʉ macõ bii yaicoajãwo. Ñee tiigʉ cõro ca buegʉre bʉaro mʉ pato wãcõticu —cʉ̃re ĩirã earã. ");
INSERT INTO baoNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesús pea to biro cʉ̃ja ca ĩirijere tʉo nʉnʉjeetigʉra, o biro ĩiupi nea poo juu buerica wii wiogʉre: —Uwieto. Díámacʉ̃ra tʉo nʉnʉjeecãña —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","To biro ĩi, Pedro, Santiago, cʉ̃ bai Juan, cʉ̃ja wadore bapa cʉti waarique booupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nea poo juu buerica wii wiogʉ yaa wiipʉ ea waarã, bojoca cʉ̃ja ca oti acaro bui niiro ");
INSERT INTO baoNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","jãa eari, o biro cʉ̃jare ĩiupi Jesús: —¿Ñee tiirã to biirije peti mʉja acaro bui oti yugui niiti? Wãmo bii yaigo méé biimo. Cãnigo tiimo —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","To biro cʉ̃ ca ĩiro, bojoca pea boca buicãupa. Jesús pea too ca niirã niipetirãre witi waa dotiri, cõ pacʉ, cõ paco, to biri cʉ̃ ca bapa cʉti waaricarã mena wado wãmo cõ ca niiropʉre jãa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jãa ea, cõ amore ñeeri, o biro cõre ĩiupi: —Talita cumi. (“ ‘¡Wimago, wãmʉ nʉcãña!’ mʉre yʉ ĩi,” ca ĩiri wãmere). ");
INSERT INTO baoNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","To biro cʉ̃ ca ĩiro jiroacãra, wãmo, pʉa amo peti, dʉpore pʉaga penituaro ca niiri cʉ̃mari ca cʉogo pea, wãmʉ nʉcã, waaupo. To biro cõ ca biiro, bojoca pea ĩa ʉcʉacoa, do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesús pea, jĩcʉ̃ ʉno peerena teere wede dotitiupi. Jiro wãmore baarique eca dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús, too ca niiricʉ witi, cʉ̃ yaa yepapʉ waacoaupi cʉ̃ buerã mena. ");
INSERT INTO baoNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Yerijãarica rʉmʉ ca earo, nea poo juu buerica wiipʉ cʉ̃jare bue jʉo waaupi. Paʉ bojoca Jesús cʉ̃ ca wederijere ca tʉorã, do biro pee ĩi majiticã, o biro ameri ĩi jãiñaupa: —¿Ania noopʉ to cõro paʉ cʉ̃ buejapari? ¿Ate majirique cʉ̃ ca boca amiriquea ñee ʉno to niiti? ¿Do biro pee tiicãri, ca ĩa ñaaña manirijere to cõro cʉ̃ tii bau nii majiti? ");
INSERT INTO baoNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Ania yucʉ pĩiri paderi majʉ José macʉ̃, ñucã María macʉ̃, Santiago, José, Judas, Simón jãari jũwʉ méé cʉ̃ niiti? ¿Cʉ̃ bairã romirira ano mani watoa cʉ̃ja niititi? —ĩiupa. To biro ca ĩirã niiri, cʉ̃ ca wederijere tʉo nʉnʉjeetiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","To biri Jesús pea o biro cʉ̃jare ĩiupi: —Jĩcʉ̃ ca biipere wede jʉgueri majʉre niipetiri taberipʉre cʉ̃re nʉcʉ̃ bʉoma. Cʉ̃ yaa yepa majurope macãrã, cʉ̃ yaarã ca nii cojorã, cʉ̃ yaa wii macãrã majurope pea, cʉ̃re nʉcʉ̃ bʉotima —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","To biri toore jĩcã wãme ʉno peera ca ĩa ñaaña manirijere tiitiupi, jĩcãrãacã ca diarique cʉtirãre cʉ̃ amori mena ñia peo, cʉ̃ ca tii catiorije ca niitirijepʉra. ");
INSERT INTO baoNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Cʉ̃ pea díámacʉ̃ cʉ̃re cʉ̃ja ca tʉo nʉnʉjeetirijere ĩagʉ, “Uwiorije ca biirã cʉ̃ja niiti,” cʉ̃jare ĩi ĩaupi. To biri too pʉtori ca niiri macãri pee añurije quetire wede yujurucuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jiro Jesús, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirãre jʉo cojo, wãtĩare cʉ̃ja ca cõa wiene majipere cʉ̃jare upori, pʉarãri wado cʉ̃jare tiicojo cojo jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","O biro cʉ̃jare ĩi wede majioupi: —Maa waarã pʉgue cʉti waarique ʉnora, wajopoa ʉnora, baarique ʉnora, wapa tiirica tiiri ʉnora, jee waaticãña. Tuericagʉ wado ami waa waarãja. ");
INSERT INTO baoNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Dʉpo jutira jãña waarãja. Bii pacarã, juti mʉja ca wajoa jãñape docare jee waaticãña. ");
INSERT INTO baoNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","”Ñucã, jĩcã wiire earã, tii wiira niicãña. Apero mʉja ca waari rʉmʉpʉ tii wiire witiya. ");
INSERT INTO baoNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","No ca boori tabe macãrã mʉjare booti, mʉja ca wederijere tʉorʉgati cʉ̃ja ca biijata, tii tabere witi waarãra, mʉja dʉporire jita ca tujarijere paa bateya, “Jãa ca wederijere mʉja ca tʉorʉgatirije jʉori mʉja yee wapa ñañaro mʉja tamʉorucu,” cʉ̃jare ĩi majiorã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","To biro cʉ̃ ca ĩiro jiro cʉ̃ buerã waari, bojocare: “Tʉgoeña yeri wajoa, Ʉmʉreco Pacʉre tʉo nʉnʉjeeya,” cʉ̃jare ĩi wede majio, ");
INSERT INTO baoNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ñucã bojocapʉre ca niirã wãtĩare paʉ cõa wiene, paʉ bojoca ca diarique cʉtirãre ʉje mena wadari cʉ̃jare diarique ametʉene, tii catio yujuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wiogʉ Herodes, Jesús yee maquẽre cʉ̃ja ca wedero queti tʉoupi, cʉ̃ ca tii niirije queti niipetiri taberipʉ ca jeja nʉcã peticoarije ca niiro macã. Jĩcãrã: —Uwo Coeri majʉ Juan cati tuajapi. Tee tiigʉ ate ca ĩa ñaaña manirije tii maji tutuariquere cʉomi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Aperã: —Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Elías niimi —ĩiupa. Aperã: —Tĩrʉmʉpʉ macãrã ca biipere wede jʉgueri maja mena macʉ̃ ʉno niimi —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","To biro cʉ̃ja ca ĩirijere tʉogʉ, Herodes pea o biro ĩiupi: —Juan niicumi. Cʉ̃ dʉpʉgare yʉ ca paa taa dotiricʉ cati tuagʉ biicumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ména Herodes pea, Herodías jʉori Juan're ñee dotiri, tia cũurica wiipʉ come daari mena cʉ̃re jia cũu dotiupi. Herodías pea, wiogʉ Herodes bai Felipe nʉmo niimiupo. Cõrena cʉ̃re ẽmari, nʉmo cʉtiupi Herodes. ");
INSERT INTO baoNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","To biro cʉ̃ ca tiiro Juan pea: Doti cũurique mʉ bai nʉmorena nʉmo cʉti dotiti —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Tee jʉori Herodías, Juan're bʉaro ĩa tuti, cʉ̃re jĩarʉga coterucuupo. Bii pacago, do biro tii majitiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herodes'pʉra Juan're uwi, añuro cʉ̃re ĩa coteupi, ca bojoca añugʉ, ca ñañarije manigʉ cʉ̃ ca niirijere majiri. Herodes, Juan cʉ̃ ca wederijere tʉogʉ, do biro ĩi majiticãrucuupi. To biro bii pacagʉ añuro cʉ̃re tʉorucuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Biirique peti, Herodías peera cõ ca tiirʉga coterucurique cõ ca tiipa rʉmʉ ea bojaupa. Herodes, cʉ̃ ca baʉarica rʉmʉ ca earo, cʉ̃ mena macãrã wiorã, uwamarã ʉparãre, Galilea yepa macãrã ʉparã ca nii majuropeerãre jʉo nea poori, cʉ̃ja mena baa, boje rʉmʉ tii niiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Herodías macõ pea Herodes cʉ̃ mena macãrã ʉparã niipetirã mena cʉ̃ ca baa boje rʉmʉ tii niiri tabepʉ jãa waari, bajaupo. Cõ ca bajarijere Herodes, ñucã cʉ̃ mena ca baa bapa cʉti duwirã cãa, bʉaro peti ĩa ʉjea niiupa. To biri Herodes pea o biro cõre ĩiupi: —No mʉ ca boorije yʉre jãiña. Mʉre yʉ tiicojorucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","To biro cõre ĩicãri, jĩcãti méé, “Yee méé mʉre yʉ ĩi. No ca boori wãme mʉ ca jãirijere mʉre yʉ tiicojo majuropeecãrucu. Yʉ ca doti niiri yepa cãare decomacã mena yʉ tiicojo maji,” cõre ĩiupi Herodes. ");
INSERT INTO baoNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","To biro cõre cʉ̃ ca ĩiro: —¿Ñee ʉno cʉ̃re yʉ jãigoti? —ĩi jãiñago witi waaupo cõ pacore. To biro cõ ca ĩiro, cõ paco pea: —Uwo Coeri majʉ Juan dʉpʉgare jãiña —ĩi yʉʉupo. ");
INSERT INTO baoNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","To biro cõ ca ĩiro, uwaro wiogʉ pʉtopʉ jãa waa, o biro cʉ̃re ĩiupo: —Mecʉ̃acãra mee, Uwo Coeri majʉ Juan dʉpʉgare jotʉ bapapʉ jãari, yʉre mʉ ca tiicojoro yʉ boo —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","To biro cʉ̃re cõ ca ĩirijere tʉogʉ, Herodes pea bʉaro tʉgoeñarique paiupi. To biro bii pacagʉ, paʉ cʉ̃ ca jʉo cojoricarã cʉ̃ja ca tʉo cojoro, “Yʉre mʉ ca jãirijere mʉre yʉ tiicojo majuropeecãrucu” cʉ̃ ca ĩicãrique ca niiro macã, cõ ca jãirijere, “Yʉ tiicojoti” cõre ĩi majitiupi Herodes. ");
INSERT INTO baoNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","To biri to biiro cõ ca ĩiro jiroacãra mee, jĩcʉ̃ uwãmʉre Juan dʉpʉgare paa taa ami doo dotiupi. Uwamʉ pea Juan're cʉ̃ja ca tia cũurica wiipʉ waari, cʉ̃ dʉpʉgare paa taa ami, ");
INSERT INTO baoNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","jotʉ bapapʉ ami jãa, ami waari tiicojoupi Juan dʉpʉgare ca jãiricopʉre. Cõ pea ñucã cõ pacopʉre tiicojo ametʉeneupo. ");
INSERT INTO baoNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Juan're to biro cʉ̃ja ca tii cõariquere queti tʉori, cʉ̃ buerã pea doo, cʉ̃ upʉri niiquĩriquere ami, yaarã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Jiro Jesús buerã tua earã, cʉ̃ mena nea poo, niipetirije cʉ̃ja ca tiiriquere, cʉ̃ja ca bue yujuriquere, cʉ̃re wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Cʉ̃re cʉ̃ja ca wede yapanoro: —Dooya. Jamʉ, ca bojoca maniropʉ mani wado mani yerijãaco petopʉra —cʉ̃jare ĩiupi. Paʉ bojoca waacoarucu, doocã doorucu, biirã, do biro tii baa yeri puna jãña majiña maniro cʉ̃jare biiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","To biri Jesús cʉ̃ buerã mena cũmuapʉ ea jãa waacoaupa, ca bojoca maniropʉ waarã. ");
INSERT INTO baoNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Toopʉ cʉ̃ja ca waaro, paʉ bojoca cʉ̃jare ca ĩaricarã majicãupa. To biri niipetiri macãri macãrã maapʉ cʉ̃ja jʉguero, cʉ̃ja ca tĩa ea waaparopʉre ũmaa eacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús tĩa ea, maa nʉcãgʉ paʉ bojocare ĩa, bʉaro cʉ̃jare ĩa boo pacaupi, oveja cʉ̃jare ca cotegʉ manirãre biro cʉ̃ja ca biiro macã. Jesús pea paʉ wãmeri cʉ̃jare bue jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ca naio doori tabe ca niiro, cʉ̃ buerã pea cʉ̃ pʉto pee doo, o biro cʉ̃re ĩiupa: —Naio waaropʉ bii. Ca bojoca maniropʉ nii anoa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bojocare, “Tua waarãja,” cʉ̃jare ĩiña. Ano pʉtori ca niiri macãripʉ waari, baarique cʉ̃ja wapa tii baarã waajato —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","To biro cʉ̃ja ca ĩiro tʉo: —Mʉjara cʉ̃jare baarique ecaya —cʉ̃jare ĩiupi Jesús. To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupa: —¿To docare doscientos rʉmʉri pade wapa taaricaro cõro mena cʉ̃jare ecarʉgarã jãa ca baarique wapa tiirã waaro mʉ booti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","To biro cʉ̃ja ca ĩiro: —Ĩa ñaarãja. ¿No cõro paʉ pan mʉja cʉoti? —ĩiupi. Ĩaña yapano: —Pan jĩcã amo cõro niiri caari, wai pʉarã, to cõrora jãa cʉo —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","To biro cʉ̃ja ca ĩiro Jesús pea, “Bojocare, upa poogaari taa yepapʉ duwi dotiya,” ĩiupi cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","To biri cʉ̃ja pea cien, ñucã aperãre cincuenta ca niirã duwi dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Cʉ̃ja ca duwi doti yapanoro jiro, Jesús pea jĩcã amo cõro ca niirije pan're, wai pʉarã ca niirãre ami, emʉaropʉ ĩa mʉene, “Añurije to niijato” ĩi juu bue peo yapano, pan're pee bato, cʉ̃ buerãre tiicojoupi, bojocare cʉ̃ja bato cojojato ĩigʉ. Ñucã wai pʉarã ca niiricarã cãare, cʉ̃ja niipetirãpʉrena bato peoticã cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","To biro cʉ̃ ca tiirijere, niipetirãpʉra baa yapicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Cʉ̃ buerã pea ñucã cʉ̃ja ca baa dʉarije pan're, wai menare, pʉa amo peti, dʉpore pʉaga penituaro niiri pijeeri peti jee jãa dadoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Atere ca baaricarã pea jĩcã amo cõro mil peti ʉmʉa niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tee jiro Jesús bojocare cʉ̃ ca waarique wui ditoye, cʉ̃ buerã Betsaida macã ca niiri tabe pee cʉ̃ja waa yuejato ĩigʉ, cũmuapʉ cʉ̃jare ea jãa dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Bojocare waarique wui yapano, ʉ̃tãgʉ pee juu buegʉ waacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ca naio ñaacũmuri tabe ca niiro, cʉ̃ buerã pea mee ʉtabʉcʉra decomacãpʉ tʉjacã tĩa waaupa. Jesús pea ména toopʉra niicãupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ca boe doori tabere cʉ̃ buerã, wino ca paa puu tuenero macã tutuaro ca waa tʉ̃a pua pajarãre ĩaupi. To biro cʉ̃ja ca bii paja yujuro, Jesús pea cʉ̃ja pʉto pee oco jotoara waacã nʉnʉa waaupi. Cʉ̃jare ametʉacoagʉ doogʉ cʉ̃ ca biirora, ");
INSERT INTO baoNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","cʉ̃ buerã pea oco jotoa cʉ̃ ca dooro ĩarã, “Wãtĩ niicumi” ĩirã, acaro buicoaupa, ");
INSERT INTO baoNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","cʉ̃ja ca ĩarijere bʉaro uwima ĩirã. To cõrora Jesús pea, o biro ĩi cojoupi: —Tʉgoeña bayiya. Yʉra yʉ nii. Uwiticãña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","To biro cʉ̃jare ĩi, doo, cʉ̃ja pʉto cũmuapʉ cʉ̃ ca ea jãarora, wino ca paa puurique yerijãacoaupe. Cʉ̃ja pea bʉaropʉra ĩa ʉcʉa yaicoa, do biro pee ĩi majiticãupa, ");
INSERT INTO baoNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","cʉ̃ja ca tʉo maji niirijepʉre ca boe taatiro macã, pan mena cʉ̃ ca tiiriquere ca tʉo puotiricãrã niiri. ");
INSERT INTO baoNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ʉtabʉcʉrare tĩa ea waarã, Genesaret yepare ea, too maaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cʉ̃ja ca maa nʉcãrije menara, bojoca pea Jesús're ĩa majicãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","To biri jĩcãto tii yepa niipetiropʉ waari, “Jesús toopʉ niimi,” cʉ̃ja ca ĩirijere tʉorã, cʉ̃ ca niiri tabepʉra ca diarique cʉtirãre cʉ̃ja ca pejari taberi menara jee waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Jesús, õcã macãriacã, paca macãri, macã manirori cʉ̃ ca waari taberi cõro cʉ̃ja yaarã ca diarique cʉtirãre, wije caari watoa macã maaripʉ cʉ̃jare cʉ̃re cũu yueri, “Petopʉra mʉ jutiro yapaacã cʉ̃jare padeña dotiya,” cʉ̃re ĩiupa Jesús're. Niipetirã cʉ̃ jutirore ca padeñarã cõrora, cati peticoarucuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Jiro fariseos, jĩcãrã doti cũuriquere jʉo bueri maja Jerusalén'pʉ ca dooricarã mena, Jesús pʉto eaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Cʉ̃ja pea, Jesús buerã jĩcãrã, cʉ̃ja ca tii jʉo dooriquere biro tiitirãra, amo coeri méé cʉ̃ja ca baaro ĩari cʉ̃jare wede paiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Fariseos, to biri niipetirã judíos ca nii cojorã, cʉ̃ja ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo dooricarore biro tiirã, amo coetirãra baa, tiitima. ");
INSERT INTO baoNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ñucã apeye ca wapa tiirã waaricarã tua earã cãa, cʉ̃ja amorire coetirãra baa, tiitima. Apeye to biro cʉ̃ja ca tiirique cʉtiri wãmerire, paʉ cʉoupa cʉ̃ja ñicʉ̃ jʉ̃mʉapʉ cʉ̃ja ca tii jʉo dooriquere, jotʉ bapari coerique, pio jãaricarʉʉrire coeriquere, come baparire coeriquere, duwirica quejerire coerique ʉnore tiima. ");
INSERT INTO baoNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","To biri fariseos, doti cũuriquere jʉo bueri maja, o biro ĩi jãiñaupa Jesús're: —¿Ñee tiirã mʉ buerã pea mani ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo dooriquere tiitirãra, amo coeri méé cʉ̃ja baati? —ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Yee mééra ĩiquĩjapi Ʉmʉreco Pacʉ yeere wede jʉgueri majʉ Isaías, mʉja, watoara ca bii dito pairãre ĩigʉ o biro cʉ̃ ca ĩi owaquĩriquera: “Anija, ʉjero ĩirique wado yʉre ĩi nʉcʉ̃ bʉoma; cʉ̃ja yeri pea aperopʉ niicã. ");
INSERT INTO baoNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Watoa petira yʉre ĩi nʉcʉ̃ bʉocãma; cʉ̃ja ca bue majiorijea, bojocara cʉ̃ja ca tii dotirije nii,” cʉ̃ ca ĩiquĩriquera. ");
INSERT INTO baoNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Mʉja, Ʉmʉreco Pacʉ cʉ̃ ca doti cũuriquere tiitirãra, mʉja ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo doorique peere mʉja tii nʉnʉjee,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","O biro ĩi nemoupi ñucã: —Mʉja, jãa ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo doorique yai nʉcãre ĩirã, tee peere tii nʉnʉjeema ĩirã, Ʉmʉreco Pacʉ cʉ̃ ca doti cũurique peera, “To biro biicu” mʉja ĩiti. ");
INSERT INTO baoNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moisés o biro ĩiupi: “Mʉ pacʉre, mʉ pacore nʉcʉ̃ bʉoya. Cʉ̃ pacʉre, cʉ̃ pacore ñañaro ca ĩi tutigʉa, ca jĩa cõa ecopʉ niirucumi,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mʉja pea: Jĩcʉ̃, cʉ̃ pacʉre, cʉ̃ pacore, “ ‘Mʉjare yʉ ca tii nemoboriquere, Ʉmʉreco Pacʉre yʉ ca tiicojoriquepʉ wado nii, to biri mʉjare yʉ noni majiti,’ ĩicã majimi,” mʉja ĩi bue majio. ");
INSERT INTO baoNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ñucã to biirije ca ĩigʉa, “ ‘Mʉ pacʉre, mʉ pacore tii nemoña,’ ca ĩi ecopʉ méé niimi,” mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ate mʉja ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo doorique pee wadore ameri wede majio, tii nʉnʉa waama ĩirã, Ʉmʉreco Pacʉ wederique peera ca wapa manirije ca tuaro mʉja tii. Ñucã apeye tee ʉnore paʉ mʉja tiicã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","To biro cʉ̃jare ĩi, bojocare jʉo cojo, o biro ĩiupi: —Niipetirã yʉre tʉori, atere añuro tʉo puoya. ");
INSERT INTO baoNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Baariquea, jĩcã wãme ʉno peera bojocare ñañoti. Bojoca, yeripʉ ñañarije tʉgoeñari cʉ̃ja ca ĩirije doca bojocare ñaño. ");
INSERT INTO baoNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ca amoperi cʉtigʉa tʉoya yʉ ca ĩirijere —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jiro Jesús bojocare camotati, waa, wiipʉ cʉ̃ ca earo, cʉ̃ buerã pea cʉ̃ ca ĩi cõoña wederique maquẽre cʉ̃re jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Cʉ̃ja ca jãiñaro, Jesús pea o biro ĩiupi: —¿Mʉja cãa mena to birora mʉja tʉo jeeñoticãti? ¿Baarique jĩcã wãme ʉno peera bojocare ca ñañotirijere mʉja majititi? ");
INSERT INTO baoNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Baariquea yeripʉ waati. Ʉtapoa pee waa, jiro witi batecoa —ĩiupi. Atere o biro ĩigʉ: “Niipetirije baarique añurije wado nii,” ĩigʉ ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","O biro ĩi nemoupi ñucã: —Ñañarije tʉgoeñacãri wede wienerique pee doca, bojocare ca ñañorije nii. ");
INSERT INTO baoNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bojoca yeripʉ, ñañarije tʉgoeñarique, tiirica wãme cõro méépʉ ñee epericarã cʉti yai waarique, jee dutirique, jĩarique, ");
INSERT INTO baoNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","manʉ cʉti, nʉmo cʉti bii pacarã epericarã cʉtirique, pairo apeye cʉorʉgarique, ñañarije tiirʉga tʉgoeñarique, watoara ĩirique, bobo tʉgoeñaricaro maniro tii yai waarique, ĩa tutirique, queti pairique, ca nii majuropeegʉre biro tʉgoeñarique, noo ca booro bii nucũ yujurique, nii. ");
INSERT INTO baoNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ate niipetirije ñañarije bojoca cʉ̃ja yeripʉ cʉ̃ja ca tʉgoeñarije witima ĩiro, bojocare ñaño —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","To ca niiricʉ Jesús Tiro, Sidón yepari pee waacoaupi. Toopʉ ea, bojoca cʉ̃ja ca majiro bootigʉ jĩcã wiipʉ jãa waaupi. Bii pacagʉ, do biro pee bii, duti majitiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mee yoari mééra, jĩcõ nomio, ca wãtĩ jãa ecorico paco Jesús cʉ̃ ca earijere queti tʉocãupo. Teere tʉori waa, cʉ̃ pʉto muu bia ea nuu waaupo. ");
INSERT INTO baoNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Cõ pea judío bojoco méé, Sirofenicia macõpʉ niiupo. Ape majopʉ nii pacago, Jesús're, “Yʉ macõpʉre wãtĩ ca jãñagʉre cõa wiene bojaya,” cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","To biro cõ ca ĩiro, Jesús pea o biro cõre ĩi yʉʉupʉ: —Níjá. Ména cʉ̃ puna majurope pee cʉ̃ja baa jʉojato ĩiña. Cʉ̃ puna baariquerena ẽmari yaia peere ecajata, añuti —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","To biro cʉ̃ ca ĩiro: —Ʉ̃gjá Wiogʉ. To birora bii. To ca bii pacaro, cʉ̃ puna cʉ̃ja ca baa baterije yepapʉ ca ñaarijere yaia cãa baama —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","To biro cõ ca ĩiro, Jesús pea o biro cõre ĩiupi: —To biirije yʉre mʉ ca ĩi yʉʉrije jʉori, tʉgoeñarique paitigora tua waagoja. Mee, wãtĩ mʉ macõpʉre ca niimiricʉ witicoami —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Cõ pea, cõ yaa wiipʉ eago, cõ macõ cãni pejarica tabepʉ cõ ca pejaro bʉa eaupo. Cõpʉre ca niiricʉ wãtĩ pea witicoaupi mee. ");
INSERT INTO baoNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús, Tiro yepa ca niiricʉ waagʉ, Sidón yepare ametʉa, waa nʉnʉa waa, Galilea ʉtabʉcʉrare Decápolis ca niiri yepare eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Toopʉ cʉ̃ ca earo, jĩcʉ̃ tʉoti, wedeti, ca biigʉre ami waari, “Mʉ amori mena cʉ̃re ñia peoya,” ĩiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","To biro cʉ̃ja ca ĩiro Jesús pea, apero ca bojoca maniro pee cʉ̃re ami waa, cʉ̃ amo jũari mena cʉ̃ amoperire juu jõene, ʉjeco mena cʉ̃ ñemerore padeña, tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jiro, emʉaro pee ĩa mʉene, yeri jini jãa, o biro cʉ̃re ĩiupi: “¡Efata!” ĩiupi. (“¡Tujuya!” ĩirʉgaro ĩi). ");
INSERT INTO baoNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","To biro Jesús cʉ̃ ca ĩirora, jĩcãto cʉ̃ amoperi tujucoa, cʉ̃ ñemero cãa abacoa, añuro wede majicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús pea, “Jĩcʉ̃ ʉno peerena wedeticãña,” cʉ̃re ĩiupi. Bʉaro jañuro, “Wedeticãña,” cʉ̃ ca ĩirora, bʉaro jañuro wede bato nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bojoca pea ĩa ʉcʉacoa, do biro pee ĩi majiti, o biro ĩiupa: “Niipetirijepʉrena añuro wado tiicãmi. Ca tʉotirãpʉ cãa tʉocoa, ca wedetirãpʉ cãa wedecoa, cʉ̃ja ca biiro tiimi,” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Tii rʉmʉrire ñucã paʉ bojoca nea pooupa. Baarique cʉori méé cʉ̃ja ca biiro ĩari cʉ̃ buerãre jʉo cojo, o biro ĩiupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Anija bojocare yʉ ĩa boo pacacoa. Mee, itia rʉmʉ peti yʉ mena niicoama; baarique ʉnora cʉotima. ");
INSERT INTO baoNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Baari méé ca biirãrena, cʉ̃ja yaa wiijeripʉ yʉ ca tuenecojojata, maa decomacãrira dia ñaacoabocuma. Jĩcãrã yoaroripʉ ca dooricarã niima —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","To biro cʉ̃ ca ĩiro, cʉ̃ buerã pea o biro ĩi yʉʉupa: —¿Ano ʉno ca bojoca maniropʉre noopʉ baarique bʉacãri, ecarique niicu mʉ ĩiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","To biro cʉ̃ja ca ĩiro, Jesús pea: —¿No cãnacãga pan mʉja cʉoti? —cʉ̃jare ĩi jãiñaupi. Cʉ̃ja pea: —Jĩcã amo peti, ape amore pʉaga penituaro niiri caari jãa cʉo —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","To biro cʉ̃ja ca ĩiro, bojocare yepapʉ duwi doti, jĩcã amo peti, ape amore pʉaga penituaro ca niirije pan're ami, Ʉmʉreco Pacʉre, “Añu majuropeecã” ĩi juu bue yapano, teere pee bato, cʉ̃ buerãre noni cojoupi bojocapʉre cʉ̃ja bato cojojato ĩigʉ. Cʉ̃ja pea to birora tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Wai cãare no cãnacãrã meeacãra cʉoupa. Jesús pea cʉ̃jare ami, Ʉmʉreco Pacʉre, “Añu majuropeecã” ĩi, cʉ̃ja cãare cʉ̃ buerãre bato dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","To biro cʉ̃ ca tiirijere, niipetirãpʉra baa yapicoaupa. Cʉ̃ buerã pea ñucã ca dʉjarijere jĩcã amo peti, ape amore pʉaga penituaro niiri pijeeri jee jãa dadoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Teere ca baaricarã pea bapari mil peti niiupa. Jiro Jesús bojocare waarique wui, ");
INSERT INTO baoNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","cʉ̃ buerã mena cũmuapʉ ea jãa, Dalmanuta yepa pee waacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jiro fariseos Jesús pʉto eari, cʉ̃ mena bʉaro wede peni jʉo waaupa. Ñañarije cʉ̃ tii bui cʉtijato ĩirã, jĩcã wãme ʉmʉreco tutipʉ maquẽ ca ĩa ñaaña manirije cʉ̃re tii bau nii dotiupa, “¿Díámacʉ̃ra Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉra cʉ̃ niiti?” ĩi majirʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","To biro cʉ̃ja ca ĩiro, Jesús pea yeri jini jãa, o biro ĩiupi: —¿Ñee tiirã anija bojoca jĩcã wãme ca ĩa ñaaña manirije tii bau niiriquere cʉ̃ja jãiti? Yee méé yʉ ĩi. Jĩcã wãme ʉnoacã peera tii bau nii ĩñoña manirucuma —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","To biro cʉ̃jare ĩi, cũmuapʉ ea jãa, ʉtabʉcʉra ape nʉña pee tĩacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","To waarã, cʉ̃ buerã pea baarique jeeri méé acobo, waacoaupa. Cũmuapʉre jĩcãgaacãra pan'ga cʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús pea o biro cʉ̃jare ĩi majioupi: —Mʉja tʉgoeña majiwa, fariseos, to biri Herodes, cʉ̃ja ca tii niirije menare —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","To biro cʉ̃ ca ĩiro, cʉ̃ buerã pea: “Agó nija, pan mani cʉoti,” ameri ĩi niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús pea to biro cʉ̃ja ca ameri ĩirijere majiri, o biro cʉ̃jare ĩiupi: —¿Ñee tiirã, “Pan mani cʉoti,” mʉja ĩiti? ¿Ména, ĩa jeeñoti, tʉo puoti mʉja biicãti? ¿Mʉja ca tʉgoeñarije to pãati majuropeecãti? ");
INSERT INTO baoNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Cape cʉti pacarã ĩati, amoperi cʉti pacarã tʉoti, mʉja biicãti? ¿Yoari méé mʉja acobocoati? ");
INSERT INTO baoNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Jĩcã amo cõro niirije pan menara jĩcã amo cõro mil ca niirãre yʉ ca baarique batorique ca dʉjarijere ¿no cãnacã pijeeri peti mʉja jee jãa dadori? —cʉ̃jare ĩiupi. To biro cʉ̃ ca ĩiro cʉ̃ja pea: —Pʉa amo peti, dʉpore pʉaga penituaro niiri pijeeri —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ñucã, jĩcã amo peti, ape amore pʉaga penituaro ca niirije pan menara, bapari mil ca niirãre yʉ ca baarique batorica tabera, ¿no cãnacã pijeeri mʉja jee jãa dadori? —ĩiupi. To biro cʉ̃ ca ĩiro: —Jĩcã amo peti, ape amore pʉaga penituaro niiri pijeeri —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—¿To docare ména, mʉja tʉo puoticãti? —ĩiupi Jesús, cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jiro Betsaida cʉ̃ja ca earo, jĩcãrã jĩcʉ̃ ca ĩatigʉre Jesús pʉto ami waari, “Cʉ̃re padeñaña,” ĩiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","To biro cʉ̃ja ca ĩiro Jesús pea, ca ĩatigʉre macã tʉjaropʉ cʉ̃re tʉ̃acã witi waaupi. Toopʉ cʉ̃ ʉjeco mena cʉ̃ capere weyo, cʉ̃ amori mena cʉ̃ capere ñia peo, “¿Mee apeye ʉno mʉ ĩati?” cʉ̃re ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","To biro cʉ̃ ca tiiro, ca ĩatimiricʉ pea ĩa pãari, o biro cʉ̃re ĩiupi: —Bojocare yʉ ĩa biigʉpʉa. Bʉari, yucʉra waa yujurore biro biicã —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","To biro cʉ̃ ca ĩiro, Jesús pea cʉ̃ capere ñia peo nemoupi ñucã. To biro cʉ̃ ca tiiro, ñee jãa maniro añuro ĩa, diarique manigʉpʉ tuacãupi yua. ");
INSERT INTO baoNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","To cõrora Jesús pea cʉ̃ yaa wiipʉ cʉ̃re tuenecojogʉ, o biro cʉ̃re ĩiupi: —Macã pee piya waari, jĩcʉ̃ ʉno peerena wedegʉ waa, tiiticãña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ate jiro Jesús cʉ̃ buerã mena, Cesarea de Filipo yepa macã macãripʉ waaupi. Maapʉ waa nʉnʉa waagʉ, Jesús cʉ̃ buerãre: —¿Bojoca, ‘Ñiru niimi,’ yʉre cʉ̃ja ĩirucuti? —cʉ̃jare ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","To biro cʉ̃ ca ĩi jãiñaro: —Jĩcãrã: “Uwo Coeri majʉ Juan niimi.” Aperã: “Elías niimi.” Aperã: “Jĩcʉ̃ ca biipere wede jʉgueri maja mena macʉ̃ niimi,” mʉre ĩima —cʉ̃re ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","To biro cʉ̃ja ca ĩiro: —Mʉja pea, ¿“Ñiru niimi,” yʉre mʉja ĩiti? —cʉ̃jare ĩi jãiñaupi Jesús. To biro cʉ̃ ca ĩiro, Simón Pedro pea: —Mʉa, Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ Cristo mʉ nii —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","To biro cʉ̃ ca ĩiro: “Teere jĩcʉ̃ ʉno peerena wedeticãña,” ĩiupi Jesús cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jiro Jesús cʉ̃ buerãre o biro cʉ̃jare ĩi wede majio jʉo waaupi: —Yʉ, Ca Nii Majuropeegʉ Macʉ̃, bʉaropʉra ñañaro tamʉo, judíos're ca jʉo niirãre, paia ʉparãre, doti cũuriquere ca jʉo buerãre ĩa juna eco, yʉ ca biipera niiro bii. Ñucã yʉre jĩa cõa, cʉ̃ja ca tii pacaro itia rʉmʉ jiro yʉ cati tuacoarucu —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Atere tʉo majiricarora cʉ̃jare wede majioupi. To cõrora Pedro pea, apero pee cʉ̃re ami waa, to biro cʉ̃ ca ĩirije jʉori cʉ̃re tuti camota jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","To biro cʉ̃ ca ĩiro, Jesús pea amojode nʉcã, cʉ̃ buerãre ĩari, o biro ĩi tutiupi Pedrore: —¡Yʉre camotati waagʉja Satanás! Mʉa Ʉmʉreco Pacʉ cʉ̃ ca tiirʉgari wãmere mʉ majiti. Bojoca cʉ̃ja ca tʉgoeñarore birora mʉ tʉgoeñacã —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","To biro cʉ̃re ĩi, cʉ̃ buerãre bojocare jʉo cojori, o biro ĩiupi Jesús: —Jĩcʉ̃ yʉ buegʉ ca niirʉgʉ ʉnoa mʉ majurope mʉ ca tiirʉgarijere acobori, yʉ yee jʉori ñañaro tamʉo pacagʉ, to birora tʉgoeña bayi, yʉre nʉnʉña. ");
INSERT INTO baoNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Cʉ̃ ca cati niirijere ca maigʉa, cʉ̃ ca catipere bʉatirucumi. To ca bii pacaro yʉ yee jʉori, añurije quetire cʉ̃ ca tʉo nʉnʉjeerije jʉori, ñañaro ca tii eco yaigʉa, ametʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Ñee ʉno peere to tii nemoti ati yepa maquẽ niipetirore pairo cʉo ametʉenecã pacagʉ, Ʉmʉreco Pacʉre tʉo nʉnʉjeetigʉra ca bii yaigʉra? ");
INSERT INTO baoNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ñucã, ¿no cõro pairo mena cʉ̃ wapa tiibogajati, cʉ̃ ca cati niipe wapare? ");
INSERT INTO baoNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ati cuu macãrã ñañarije tii, Ʉmʉreco Pacʉre tʉo nʉnʉjeeti, ca biirã watoare niirã, yʉ yee quetire, yʉ yee maquẽre bobo jãa, ca biirãra, yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa, yʉ Pacʉ cʉ̃ ca boe baterije, cʉ̃ pʉto macãrã ca ñañarije manirã mena yʉ ca doori rʉmʉre, yʉ yee quetire wederʉgarã cʉ̃ja ca bobo jãaricarore birora cʉ̃jare yʉ bobo ĩarucu —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","O biro ĩi nemoupi ñucã: —Yee méé mʉjare yʉ ĩi: Jĩcãrã ano ca niirã mena macãrã, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe, cʉ̃ ca tutuarije mena ca earo ĩatirãra bii yaitirucuma —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jĩcã amo peti, ape amore jĩcãga penituaro niiri rʉmʉri jiro, Jesús, cʉ̃ buerã Pedro, Juan, Santiago jãa wadore, ʉ̃tãgʉ ca emʉaricʉpʉ jʉo waaupi. Toopʉ, cʉ̃ja ca ĩa cojoro cʉ̃ ca baurije wajoacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Cʉ̃ juti cãa bʉaro boti ajiyaarije biicoaupe. Jĩcʉ̃ ʉno peera bʉaro coecã pacagʉ, añuro botiritopʉ cʉ̃ ca tii majitiro ametʉeneropʉ botiupe. ");
INSERT INTO baoNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ñucã Elías, Moisés baua eari, Jesús mena wede peni niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","To biro cʉ̃ja ca biiro ĩagʉ, Pedro pea o biro ĩiupi Jesús're: —Buegʉ, anopʉ mani ca niiro añu majuropeecã. Itia wii, wii pĩiri jãa quenorucu. Mʉ yaa wii, Moisés yaa wii, Elías yaa wii, jãa tiirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Cʉ̃ ca wederijere, “To biirije yʉ ĩicu,” ĩi majiticãupi, niipetirãpʉra ʉcʉa yaicoama ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","To biro cʉ̃ja ca bii niirora, bueri bʉrʉa doo, cʉ̃jare paa ũmaa nʉcõcãupe. To biro ca biirora bueri bʉrʉapʉ wederique o biro ca ĩirije wedeoupe: “Ania, yʉ Macʉ̃, yʉ ca maigʉ niimi. Cʉ̃re tʉo nʉnʉjeeya,” ĩiupe. ");
INSERT INTO baoNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","To biro ca ĩiri nimarora ĩa cojorã, Jesús jĩcʉ̃rena ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ʉ̃tãgʉpʉ ca niiricarã duwi nʉnʉa doorã, Jesús pea: “Mʉja ca ĩajãrijere jĩcʉ̃ ʉno peerena wedeticãña, yʉ, Ca Nii Majuropeegʉ Macʉ̃ ca bii yairicarã watoare yʉ ca cati tuaro jiropʉ mʉja wederucu,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Tee jʉori, cʉ̃ja wadora atere majicõa niirucuupa, biirãpʉa cʉ̃ja majurope, “Do biro ĩirʉgaro to ĩibuti, ca bii yairicarã watoare cati tuarique,” ameri ĩi jãiña nii pacarã. ");
INSERT INTO baoNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","To biri o biro cʉ̃re ĩi jãiñaupa: —¿Ñee tiirã doti cũuriquere ca jʉo buerã pea: “Elías doo jʉorucumi,” cʉ̃ja ĩirucuti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","To biro cʉ̃ja ca ĩi jãiñaro, o biro cʉ̃jare ĩi yʉʉupi Jesús: —Yee méé ĩima, Elías'ra doo jʉgue, cʉ̃ra niipetirijere queno, tiirucumi. To docare, ¿ñee tiiro Ʉmʉreco Pacʉ wederique, “Yʉ, Ca Nii Majuropeegʉ Macʉ̃re, ñañaro tamʉo, ĩa juna eco biirucumi,” ĩi owarique to niiti? ");
INSERT INTO baoNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yʉ pea, “Mee, Elías doo yerijãaupi,” yʉ ĩi. Cʉ̃ja pea niipetiro cʉ̃re cʉ̃ja ca tiirʉgari wãmeri cõro cʉ̃re tiiupa. Cʉ̃re ca biipere to biro tii ecorucumi, cʉ̃ja ca ĩi owa tuuricarore birora —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Aperã cʉ̃ buerã pʉto peere tua earã, paʉ bojoca watoapʉ nii, ñucã jĩcãrã doti cũuriquere ca jʉo buerã cʉ̃ja mena cʉ̃ja ca wede peni niiro bua eaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesús're ĩacãrãpʉa, ʉjea niirique mena cʉ̃re ũmaa boca jãiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","To biro cʉ̃ja ca biiro, cʉ̃ pea o biro cʉ̃jare ĩi jãiñaupi: —¿Ñee ʉnore cʉ̃ja mena mʉja wede peniti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","To biro cʉ̃ ca ĩiro, jĩcʉ̃ too cʉ̃ja watoa ca niigʉ, o biro cʉ̃re ĩi yʉʉupi: —Buegʉ, yʉ macʉ̃re wãtĩ cʉ̃re ñaajãa nʉcã eari, ca wedetigʉ cʉ̃ ca tuaro cʉ̃ ca tiigʉre, mʉ yʉ ami doojãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Noo cʉ̃ ca niiri tabe ñaajãa nʉcãri, cʉ̃ ca ñaacũmu yugui mecʉ̃ro tii, cʉ̃ ʉjeropʉ jopo witi, upi baca dʉpo tuu, tutua pʉyʉacoa, cʉ̃ ca biiro cʉ̃re tiimi. Mʉ buerãre, “Wãtĩre cõa wieneña,” cʉ̃jare yʉ ĩimijãwʉ. Do biro tii majitijãwa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —¡Agó nija, díámacʉ̃ ca tʉo nʉnʉjeetirã! ¿No cõro yoaro mʉja mena yʉ niigʉti? ¿No cõro yoaro to biro mʉja ca biirijere yʉ nʉcã niigʉti? Ano pee cʉ̃re ami dooya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","To biro cʉ̃ ca ĩiro, Jesús pʉto cʉ̃re ami waaupa. Wãtĩ pea Jesús're ĩagʉra, wãmʉ yepapʉ ñaacũmu waa, yugui mecʉ̃, cʉ̃ ʉjeropʉ jopo witi, cʉ̃ ca biiro cʉ̃re tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","To biro cʉ̃ ca biiro, Jesús pea o biro ĩi jãiñaupi cʉ̃ pacʉre: —¿No cõropʉ atere to biro cʉ̃ bii jʉori? —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩiro cʉ̃ pacʉ pea: —Wimagʉ niigʉpʉra to biro bii jʉowi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Paʉ tiiri cʉ̃re jĩarʉgʉ, pecamepʉ tii cõa joe, ñucã diapʉ cʉ̃ ca ñaañuaro cʉ̃re tii, tii mecʉ̃orucumi. No jĩcã wãme ʉno mʉ ca tii majijata, jãare boo paca ĩari, jãare tii nemoña —ĩiupi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","To biro cʉ̃re cʉ̃ ca ĩiro tʉogʉ: —¡Níjá! ¿Ñee tiigʉ mʉ ca tii majijata, mʉ ĩiti? Díámacʉ̃ ca tʉo nʉnʉjeegʉra niipetirije tii majirique wado nii —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","To cõrora cʉ̃ pacʉ pea o biro ĩi acaro buiupi: —¡Bʉaro jañuri yʉ ca tʉo nʉnʉjeero yʉre tii nemoña! —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Bojoca paʉ cʉ̃ja ca nea poo nʉnʉa dooro ĩari, wãtĩ yerire o biro ĩi tuti cõa wieneupi: —“Wãtĩ, wedeti, tʉoti, ca biigʉ yoari méé witi waagʉja. Pʉati cʉ̃re ñaajãa nʉcã nemoticãña,” mʉre yʉ ĩi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","To cõrora wãtĩ pea bʉaro acaro bui, ñañaropʉ cʉ̃re tii wẽe yaye cõa cũu cojo, witicoaupi. Cʉ̃ pea ca dia waaricʉre biropʉ biicã cũmu waaupi. To biri paʉ, “Dia yaicoami,” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesús pea cʉ̃ amopʉ ñee, cʉ̃re tʉ̃a wãmʉoupi. To biro cʉ̃ ca tiirora, cʉ̃ pea wãmʉ nʉcãcoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jiro Jesús wiipʉ cʉ̃ ca jãa waaro, cʉ̃ buerã pea cʉ̃ja wado niirã, o biro cʉ̃re ĩi jãiñaupa: —¿Ñee tiirã jãa pea wãtĩre jãa cõa wiene majitijapari? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","To biro cʉ̃ja ca ĩiro Jesús pea: —Wãtĩa anija ʉnoa, betirique mena juu buecãripʉ wado cõa wienericaro ca witirã niima —ĩiupi cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Too ca niiricarã waarã, Galilea yepa pee ametʉa waaupa. Jesús pea jĩcʉ̃ ʉnora cʉ̃ja ca majiro bootiupi, ");
INSERT INTO baoNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","cʉ̃ buerãre buema ĩigʉ. O biro cʉ̃jare ĩi wedeupi: —Yʉ, Ca Nii Majuropeegʉ Macʉ̃re, aperãpʉre yʉre tiicojorucuma. Cʉ̃ja pea yʉre jĩa cõacãrucuma. To biro cʉ̃ja ca tii cõacãmijata cãare, itia rʉmʉ jiro yʉ cati tuacoarucu ñucã —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Cʉ̃ja pea to biro cʉ̃ ca ĩirijere tʉo majitiupa. Cʉ̃re jãiñarʉgarã cãa uwi jañuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Too ca waaricarã, Capernaúm macãpʉ eaupa. Wiipʉ niigʉ, o biro cʉ̃jare ĩi jãiñaupi Jesús cʉ̃ buerãre: —Maapʉ doorã, ¿ñeere mʉja wede pai nʉnʉa doojãri? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Cʉ̃ja pea maapʉ doorã, “¿Ñiru pee cʉ̃ niiti, ca nii majuropeegʉ?” ca ameri ĩi nʉnʉa dooricarã niiri, wedetiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","To biro cʉ̃ja ca biiro ĩa, Jesús pea ea nuu waa, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirãre jʉo cojo, o biro ĩiupi: —Jĩcʉ̃, ca nii majuropeegʉ ca niirʉga tʉgoeñagʉ ʉnoa, niipetirã jiro macʉ̃pʉ nii, niipetirãre pade coteri majʉ nii, cʉ̃ biijato —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","To biro ĩi, jĩcʉ̃ wimagʉre cʉ̃ja watoa cʉ̃re nʉcõ, cʉ̃re ami apa, o biro cʉ̃jare ĩiupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Yʉre ca tʉo nʉnʉjeegʉ, jĩcʉ̃ ani wimagʉre biro ca biigʉre ca ñeegʉa, yʉrena ñeegʉ tiimi. Ñucã yʉre ca ñeegʉa, yʉre ca tiicojoricʉre ñeegʉ tiimi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan pea o biro ĩiupi Jesús're: —Buegʉ, jĩcʉ̃ mʉ wãme mena ĩicãri, wãtĩare ca cõa wiene niigʉre jãa ĩajãwʉ. Jãa pea mani mena macʉ̃ méé cʉ̃ ca niiro macã, “Teere tiiticãña,” cʉ̃re jãa ĩijãwʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —Camotaaticãña. Jĩcʉ̃ ʉno peera yʉ wãme mena ĩicãri, ca ĩa ñaaña manirije ca tii bau niigʉa, ñañaro yʉre ĩi majitimi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Manire ca junatigʉa, mani mena pee ca niigʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","No ca boorã, mʉja Cristo yaarã ca niirãre, oco bapa ʉnoacãra mʉjare ca tĩarã, to biro cʉ̃ja ca tiirique jʉori, cʉ̃ja yee ca niipere bʉarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","”No ca boogʉ, anija mena macʉ̃ wãmaacã yʉre ca tʉo nʉnʉjee jʉo doogʉre ñañarije cʉ̃ ca tiiro ca tiigʉra, ʉ̃tãga pairica mena cʉ̃ amʉtuture jia tuuri, dia pairi yaapʉ cõañua cõacãjata, añucãbocu. ");
INSERT INTO baoNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Mʉ amo ñañarije mʉ ca tiiro to ca tiijata, tii amore paa taa cõacãña. Amo dʉcara caticõa niirica tabepʉre mʉ ca earo añujañu. ");
INSERT INTO baoNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Pʉa amo menapʉra ñañaro bii yairica tabe pecame jĩcãti ʉno peera yaticoa, becoa cãa diacoa, cʉ̃ja ca biitiri tabepʉre mʉ ca waaborica tabe ʉnorena. ");
INSERT INTO baoNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Mʉ dʉpo ñañarije mʉ ca tiiro to ca tiijata, paa taa cõacãña. Dʉpo manigʉra to birora caticõa niirica tabepʉre mʉ ca earo, añujañu. ");
INSERT INTO baoNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Pʉa dʉpo menapʉra ñañaro bii yairica tabe pecame jĩcãti ʉno peera yaticoa, becoa cãa diacoa, cʉ̃ja ca biitiri tabepʉre mʉ ca waaborica tabe ʉnorena. ");
INSERT INTO baoNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ñucã mʉ capega ñañarije mʉ ca tiiro to ca tiijata, jade wee amiri cõacãña. Jĩcãga capega manigʉra Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre mʉ ca earo, añujañu. Pʉa capega menapʉra ñañaro bii yairica tabe: ");
INSERT INTO baoNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","“Too macãrã becoa diati, pecame cãa yatiti, ca biiri tabepʉre mʉ ca cõa joe ecopa tabe ʉnorena.” ");
INSERT INTO baoNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","”Niipetirã, ñañaro tamʉo ametʉari jiro bʉaro jañuri ca tʉgoeña bayirã nii nʉnʉa waarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Moa añurije nii. To biro bii pacaro to ca oca yerijãacoajata, ¿do biro pee tiicãri ñucã, ca ocarije ca nii earo mʉja tii majibogajati? Mʉja majuropeera moare biro niiña. Niipetirã mena añuro niirique cʉti niiña —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús Capernaúm ca niiricʉ, Judea yepa, dia Jordán ape nʉña, muipũ cʉ̃ ca mʉa doori nʉña peere ca niiri yepa pee waacoaupi. Ñucã toopʉre paʉ bojoca cʉ̃ja ca nearo, cʉ̃ ca tiirucuricarore birora, cʉ̃jare bue jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","To biro cʉ̃ ca ĩi niiro, jĩcãrã fariseos Jesús pʉto ea, cʉ̃re ĩi buiyeerʉgarã, “¿Jĩcʉ̃ cʉ̃ nʉmore cʉ̃ ca cõaro to añucãti?” ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","To biro cʉ̃ja ca ĩiro, cʉ̃ pea: —Moisés ¿ñeere mʉjare cʉ̃ tii dotiupari? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Cʉ̃ja pea: —Moisés: “ ‘Ate jʉori mʉre yʉ cõa,’ ca ĩiri pũuro owari cõre tiicojo, cõacãña,” ĩiupi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","To biro cʉ̃ja ca ĩiro, Jesús pea o biro ĩi yʉʉupi: —Moisés atere to biro mʉjare tii dotiupi, ca wederique ametʉene nʉcã pairã mʉja ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Jĩcãto Ʉmʉreco Pacʉ ati yepare tii jeeño jʉogʉpʉra, ʉmʉ, nomio tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","To biri ʉmʉ, cʉ̃ pacʉre, cʉ̃ pacore, camotatiri, cʉ̃ nʉmo mena pee niirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Pʉarã nii pacarã, jĩcã upʉra nii earucuma. To biri pʉarã méé niima. Jĩcʉ̃ra niima. ");
INSERT INTO baoNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","To biri Ʉmʉreco Pacʉ jĩcã upʉra cʉ̃ja ca niiro cʉ̃ ca tiiricarãrena, bojocʉra cʉ̃ja ca ameri camotatiro tii majitimi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ñucã cʉ̃ buerã pea wiipʉ niirã, tee maquẽrena jãiñaupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","To biro cʉ̃ja ca ĩiro, Jesús pea: —Cʉ̃ nʉmore cõari, apeo ca nʉmo cʉtigʉa, cʉ̃ nʉmo ca nii jʉorico menare ñañarije tiigʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ñucã nomio pee cãa, cõ manʉre cõacãri apĩ cõ ca manʉ cʉtijata, cõ cãa, ñañarije tiigo tiimo —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jĩcãrã, Jesús pʉto wimarãre jee waaupa, cʉ̃jare cʉ̃ padeñajato ĩirã. Cʉ̃ buerã pea wimarãre ca jee waarãre bocá tuti camota niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús pea to biro cʉ̃ja ca ĩiro ĩa ajiari, o biro cʉ̃jare ĩiupi: —Wimarãre camotaatirãra yʉ pʉto pee cʉ̃jare tiicojoya. Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea cʉ̃jare biro ca niirã yaa tabe nii. ");
INSERT INTO baoNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yee méé yʉ ĩi: Jĩcʉ̃ wimagʉ cʉ̃ ca biirore biro Ʉmʉreco Pacʉ cʉ̃ ca dotiri tabe maquẽre ca tʉo nʉnʉjeetigʉa, tii tabepʉre ea waatirucumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","To biro cʉ̃jare ĩi yapano, wimarãre jee apa, cʉ̃ amori mena cʉ̃jare ñia peori, añuro cʉ̃jare ca bii mʉa nʉcãpere cʉ̃jare jãi bojaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesús, waagʉ doogʉ cʉ̃ ca biiri tabera, jĩcʉ̃ ʉmʉ ũmaa ea, cʉ̃ ãjʉro jupeari mena cʉ̃ jʉguero ea nuuri, o biro cʉ̃re ĩi jãiñaupi: —Buegʉ Añugʉ, ¿ñee ʉno yʉ tiigajati, to birora caticõa niiriquere bʉarʉgʉ? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","To biro cʉ̃ ca ĩiro, Jesús pea: —¿Ñee tiigʉ “Añugʉ” yʉre mʉ ĩiti? Jĩcʉ̃ peera ca añugʉ manimi; ca añugʉa jĩcʉ̃ra niimi, Ʉmʉreco Pacʉ wado. ");
INSERT INTO baoNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti cũuriquere mʉ maji: Jĩaticãña. Nʉmo cʉti, manʉ cʉti, bii pacarã tii epericarã cʉtiticãña. Jee dutiticãña. Watoara ĩi dito buiyeeticãña. Ĩi dito jeeticãña. Mʉ pacʉre, mʉ pacore, nʉcʉ̃ bʉoya —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","To biro cʉ̃re cʉ̃ ca ĩiro cʉ̃ pea: —Buegʉ, wimagʉ niigʉpʉra tee niipetirijere yʉ tii peticãwʉ mee —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","To cõrora mairique mena cʉ̃re ĩa: —Jĩcã wãmera mʉre dʉja. Waagʉja. Mʉ ca cʉorije niipetirijere noni peoticã, wapa jeeri, ca boo pacarãre noniña. To biro tiigʉ, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre pairo mʉ apeye cʉtirucu. To biro tii yapano, yʉre bapa cʉtigʉ dooya —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Teere tʉogʉ, cʉ̃ pea bijaatigʉra tʉgoeñarique pai, waacoaupi ca apeye paigʉ niiri. ");
INSERT INTO baoNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","To cõrora Jesús pea cʉ̃ weja ĩa amojode, o biro ĩiupi cʉ̃ buerãre: —¡Ca apeye pairãra Ʉmʉreco Pacʉ peere cʉ̃ja ca tʉo nʉnʉjeerʉgamijata, popiye peti niicãro dooro bii! —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","O biro cʉ̃ ca ĩirijere, cʉ̃ buerã pea do biro pee ĩi majiticãupa. Ñucã Jesús pea o biro cʉ̃jare ĩi nemoupi: —Yʉ puna, cʉ̃ja apeyerena ca wederique paiorãra, Ʉmʉreco Pacʉ peere cʉ̃ja ca tʉo nʉnʉjeepe pea do biro tii majiña manirije peti to niicãti. ");
INSERT INTO baoNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Camello pea, ãjipõa potaga opere popiye méé cʉ̃ ca jãa ame witicoa pacaro, jĩcʉ̃ ca apeye paigʉ peera Ʉmʉreco Pacʉ peere cʉ̃ ca tʉo nʉnʉjeerʉgarije popiye peti niicã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","To biro cʉ̃ ca ĩiro, cʉ̃ buerã pea bʉaro jañuri tʉo ʉcʉacã yai waa, do biro pee ĩi majiticã, o biro ĩiupa: —Too docare ¿ñiru peti cʉ̃ ametʉagʉti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","To cõrora Jesús pea cʉ̃jare ĩa, o biro ĩiupi: —Bojocara do biro ca tii majiña manirije niiro bii. Biiti Ʉmʉreco Pacʉ peera. Niipetirijepʉra cʉ̃ ca tii majirije wado niicã —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","To biro cʉ̃ ca ĩiro, Pedro pea: —Jãa, jãa yeere cũu peticã, mʉre jãa nʉnʉ doowʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","To biro cʉ̃ ca ĩiro, Jesús pea: —Yee méé mʉjare yʉ ĩi. No ca boogʉ yʉ yee jʉori, ñucã añurije queti jʉori, cʉ̃ yaa wiire, cʉ̃ yaarãre, cʉ̃ yaarã romirire, cʉ̃ pacʉre, cʉ̃ pacore, cʉ̃ punare, cʉ̃ yaa yepare, cʉ̃ ca waa weojata, ");
INSERT INTO baoNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ati yepare cati niigʉra, ñañaro cʉ̃re cʉ̃ja ca tiirʉga nʉnʉjeerije watoara, cʉ̃ ca waa weorique ametʉenero wiijeri, cʉ̃ yaarãre, cʉ̃ yaarã romirire, cʉ̃ pacʉre, cʉ̃ pacore, cʉ̃ punare, cʉ̃ yaa yeparire, cien cõro peti tiicojo nemo ecorucumi; ñucã ape tuti macã yepapʉre cʉ̃ ca niipe peera to birora caticõa niiriquere tiicojo ecorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Paʉ, mecʉ̃rire ca nii majuropeerã ca niirã, cʉ̃ja ca ĩiña manirã tuarucuma. Ñucã mecʉ̃rire cʉ̃ja ca ĩiña manirã ca niirã, ca nii majuropeerã niirucuma —cʉ̃jare ĩi yʉʉupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jiro, Jerusalén pee maa nʉnʉa waaupa. Jesús pea cʉ̃ buerã jʉguero waacã nʉnʉa waaupi. To biro cʉ̃ ca biiro, cʉ̃ja pea, “Uwiorije ca biigʉ cʉ̃ niiti” ĩi nʉnʉjeeupa, cʉ̃ja jiro ca doorã pea cʉ̃ja ca boca uwi nʉnʉjeecãro. Ñucã Jesús, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirãre bojoricaro jʉo cojo, o biro cʉ̃jare ĩiupi cʉ̃re ca biipere: ");
INSERT INTO baoNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Mʉja ca ĩarora, Jerusalén'pʉ waarã mani bii, yʉ, Ca Nii Majuropeegʉ Macʉ̃re, paia ʉparãpʉre, doti cũuriquere ca jʉo buerãpʉre, yʉre wedejãarucuma. Cʉ̃ja pea yʉre cʉ̃ja jĩa cõajato ĩirã, ape yepa macãrãpʉre yʉre tiicojorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cʉ̃ja pea ñañaro yʉre ĩi epe, yʉre ʉjeco eo bate tuu, yʉre bape, yʉre jĩa cõa, tiicãrucuma. To biro cʉ̃ja ca tiimijata cãare, itia rʉmʉ jiro yʉ cati tuacoarucu ñucã,” cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeo puna, Santiago, Juan, Jesús pʉto pee waari, o biro cʉ̃re ĩiupa: —Buegʉ, mʉre jãa ca jãirijere jãare mʉ ca tii nemoro jãa boo —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","To biro cʉ̃ja ca ĩiro: —¿Ñee ʉnore mʉjare yʉ ca tii bojaro mʉja booti? —cʉ̃jare ĩi jãiñaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","To biro cʉ̃jare cʉ̃ ca ĩiro, cʉ̃ja pea: —Mʉ ca doti niiri tabe ca añu majuropeeri tabepʉre, jĩcʉ̃, mʉ díámacʉ̃ nʉña, apĩ mʉ ãcõ nʉña pee, jãare mʉ ca duwi dotiro jãa boo —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","To biro cʉ̃ja ca ĩiro: —Mʉja, mʉja ca jãirijere mʉja majiti. To docare mʉja, do biro bii majiña maniro ñañarije yʉ ca tamʉope ʉnore ñañaro peti tamʉocã, ñañari wãmepʉ tii ecori yʉ ca jĩa eco yaipe ʉnore tamʉorã, ¿mʉja bii bayicãrãti? —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","To biro cʉ̃jare cʉ̃ ca ĩiro tʉorã: —Ʉ̃gjá, jãa bii bayicãrucu —cʉ̃re ĩiupa. Jesús pea o biro cʉ̃jare ĩiupi: —Biirãpʉa mʉja, yʉre birora bʉaropʉra ñañaro peti tamʉo, bii yai, mʉja bii ametʉarucu. ");
INSERT INTO baoNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bʉari, yʉ díámacʉ̃ nʉña, yʉ ãcõ nʉña mʉja ca duwirʉgarije docare, yʉ, yʉ ca duwi dotipe méé nii. Mee tea, “To biro biirucuma,” ĩiricarã cʉ̃ja ca duwipe nii —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Aperã pʉa amo cõro ca niirã pea teere tʉorã, Juan, Santiago jãa mena ajia jañuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesús pea cʉ̃jare jʉo cojo, o biro ĩiupi: —Mee mʉja maji, ati yepa macãrã Ʉmʉreco Pacʉre ca majitirã, “Wiorã jãa nii” ca ĩirã, cʉ̃ja bojocare tutuaro mena doti epema; ñucã ʉparã ca nii majuropeera pea, cʉ̃ja ca dotirije mena cʉ̃jare ĩi epecãma. ");
INSERT INTO baoNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Mʉja mena peera to biro méé biirucu. Mʉja watoare ca nii majuropeegʉ ca niirʉgʉ ʉnoa, mʉjare pade coteri majʉre biro pee ca biipʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ñucã mʉja watoare ca jʉo niigʉ ca niirʉgʉ ʉnoa, niipetirãre pade coteri majʉre biro pee ca biipʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa, yʉre cʉ̃ja pade cotejato ĩigʉ méé yʉ doowʉ. Yʉ pee cʉ̃jare pade cote, ñucã paʉ bojoca ñañarije cʉ̃ja ca tiiriquere bii yai boja ametʉenegʉ doogʉ yʉ doowʉ —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jiro Jericó macãre eaupa. Tii macãre Jesús, cʉ̃ buerã, aperã paʉ bojoca mena cʉ̃ ca witi nʉnʉa waaro, jĩcʉ̃ ca ĩatigʉ Bartimeo ca wãme cʉtigʉ Timeo macʉ̃, maa pʉto wapa tiirica tiiri jãi duwiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Jesús, Nazaret macʉ̃ niimi,” cʉ̃ja ca ĩiro tʉori: —¡Jesús, David Pãrami, yʉre boo paca ĩaña! —ĩi acaro buiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","To biro cʉ̃ ca ĩiro, cʉ̃ yerijãa waajato ĩirã, paʉ cʉ̃re tuti camotaamiupa. To biro cʉ̃ja ca ĩi pacaro, cʉ̃ pea bʉaro jañuro acaro buiupi: —¡David Pãrami, yʉre boo paca ĩaña! —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","To cõrora Jesús pea tua nʉcã, “Cʉ̃re jʉo cojoya,” ĩiupi. To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi jʉo cojoupa: —Níjá. Tʉgoeñarique paitigʉra wãmʉ nʉcãri, dooya. Jesús mʉre jʉomi —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","To cõrora ca ĩatigʉ pea cʉ̃ jutiro jotoa macãrore tuu wee cõa cũu, bupu wãmʉ nʉcã, Jesús pʉto pee waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesús pea: —¿Ñeere mʉre yʉ ca tii bojaro mʉ booti? —cʉ̃re ĩi jãiñaupi. To biro cʉ̃ ca ĩiro, ca ĩatigʉ pea o biro ĩi yʉʉupi: —Buegʉ, yʉ cape ca ĩaro yʉ boo —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesús pea: —Tua waagʉja. “Jesús yʉre catiocãrucumi,” mʉ ca ĩi tʉgoeña bayirijera mʉ diariquere ametʉene —cʉ̃re ĩiupi. To biro cʉ̃re cʉ̃ ca ĩiri nimarora, ca ĩatimiricʉ añuro ĩa, Jesús're nʉnʉcoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén macãre ea nʉnʉa waarã, Betfagé, Betania macãri Olivos Buuro pʉto eagʉ, cʉ̃ buerã pʉarãre ");
INSERT INTO baoNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","o biro cʉ̃jare ĩi cojoupi Jesús: —Waarãja ano díámacʉ̃ ca niiri macãpʉ. Tii macãpʉre earã, jĩcʉ̃ burro, ca peja ñaaña manigʉ, cʉ̃ja ca jia tuu nʉcõricʉre mʉja bʉarucu. Cʉ̃re popiori mʉja ami doowa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Jĩcʉ̃, “¿Ñee tiirã cʉ̃re mʉja popioti?” mʉjare cʉ̃ ca ĩijata: “Wiogʉ cʉ̃re boomi. Yoari méé mʉjare tuenecãrucumi ñucã,” cʉ̃re mʉja ĩiwa —ĩi cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","To biro cʉ̃ ca ĩi cojorã waa, burrore jope pʉto, maa pʉtoacã cʉ̃ja ca jia nʉcõricʉ ca nucũgʉre bʉa eari, cʉ̃re popioupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Cʉ̃re cʉ̃ja ca popioro ĩarã, jĩcãrã too ca niiricarã: —¿Ñee tiirã burrore mʉja popioti? —cʉ̃jare ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Cʉ̃ja pea, Jesús, cʉ̃jare cʉ̃ ca ĩi doti cojoricarore biro cʉ̃jare ĩiupa. To biro cʉ̃jare cʉ̃ja ca ĩiro, to birora cʉ̃jare ĩacãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesús pʉto ami ea, cʉ̃ja juti jotoa maquẽ burro jotoare peoupa. Jesús pea cʉ̃ jotoa ea pea waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Cʉ̃ ca waa nʉnʉa waaro, paʉ cʉ̃ja juti, jotoa maquẽre tuu weeri maare cũu jʉgue nʉnʉa waa, ñucã aperã macãnʉcʉ̃pʉ cʉ̃ja ca paa jude jeerica queerire cũu jʉgueupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","To biro tii nʉnʉa waarã, cʉ̃ jʉguero ca waarã, cʉ̃ jiro pee ca doorã cãa o biro ĩi acaro buiupa: —¡Jãare ametʉeneña! Añuro ca biigʉ niimi, Ʉpʉ wãme mena ca doogʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ca añu majuropeerije nii, mani ñicʉ̃ David cʉ̃ ca doti niiquĩricarore biro ca bii mʉa nʉcã doope. Jãare ametʉeneña, mʉ, ʉmʉreco tutipʉ ca niigʉ —cʉ̃re ĩi nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús, Jerusalén're ea, Ʉmʉreco Pacʉ yaa wii pee waaupi. Tii wiipʉ jãa ea, niipetiro ĩa yuju peticã, ñamipʉ ca niiro macã, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena Betania pee waacoaupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ape rʉmʉ Betaniapʉ ca niiricʉ, Jerusalén'pʉ waa nʉnʉa waagʉ, bʉaro queyaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","To biro bii queya nʉnʉa waagʉ, yoaropʉ jĩcãgʉ higueragʉ, ca pũu cʉti nucũro ĩari, “Dica cʉticu” ĩigʉ, ĩagʉ waamiupi. Tiigʉ pʉto eagʉ, ca pũu wado ĩaupi, ca dica cʉtiri cuu méé ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","To cõrora o biro ĩiupi Jesús, higueragʉre: —Jĩcʉ̃ ʉno peera mʉ ca dica cʉtirijere baa nemo tiitirucuma —ĩiupi. To biro cʉ̃ ca ĩirijere tʉoupa cʉ̃ buerã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jesús Jerusalén'pʉ ea, Ʉmʉreco Pacʉ yaa wiipʉ jãa waa, tii wiipʉ noni wapa taa, wapa tii, ca tii niirã niipetirãre cõa wiene jʉo waaupi. Wapa tiirica tiirire wajoa, buare noni wapa jee, cʉ̃ja ca tii duwiri taberire tumicõa cõa cũu bate peoticãupi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ñucã Ʉmʉreco Pacʉ yaa wiipʉre jĩcʉ̃ ʉno peera apeye jeecãri, cʉ̃ja ca tẽo taaro bootiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O biro cʉ̃jare ĩi wede majioupi: —O biro ĩi owarique nii: “ ‘Yʉ yaa wii, bojoca poogaari cõrora cʉ̃ja ca juu bue nea poori wii niirucu,’ ĩirica wii nii,” ĩi. Mʉja pea, jee dutiri maja cʉ̃ja ca niiri ope mʉja jeeñocãjapa —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Atere tʉorã, paia ʉparã, doti cũuriquere jʉo bueri maja, cʉ̃re cʉ̃ja ca jĩapa wãmere ama jʉo waaupa. Bii pacarã uwi jañuupa, mee, bojoca niipetirãpʉra cʉ̃ ca bue majiorijere cʉ̃ja ca tʉo ʉjea nii niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Naiori tabe ca niiro Jesús, cʉ̃ buerã mena, tii macãre witicoaupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ape rʉmʉ boeri tabe, higueragʉ pʉto ametʉa waarã, tiigʉ nʉcõri menapʉra ca jini waaricagʉpʉre ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","To cõrora Pedro pea, Jesús cʉ̃ ca ĩiriquere tʉgoeña bʉa: —Buegʉ, ĩañaaqué. Higueragʉ ñañaro mʉ ca ĩi tutijãricʉ, jini yaicoajapa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","To biro cʉ̃ ca ĩiro, Jesús pea: —Ʉmʉreco Pacʉ cʉ̃ ca tii nemoro mena, “Jãa ca ĩirore birora biirucu,” ĩi tʉgoeña bayicãña. ");
INSERT INTO baoNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Yee méé mʉjare yʉ ĩi: Jĩcʉ̃, “Yeera yʉ ĩicãbocu” ĩi tʉgoeñatigʉra, “Yʉ ca ĩirore birora biirucu,” ĩi tʉgoeña bayicãri atigʉ ʉ̃tãgʉre: “Pĩa waari, dia pairi yaapʉ ñaañuaña” cʉ̃ ca ĩijata, cʉ̃ ca ĩirore birora biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","To biri, “Niipetirije, juu buerã mʉja ca jãirijere, ‘Mee, mani bʉa yerijãa,’ ĩiña, mʉja tiicojo ecorucu,” mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Juu buerã, aperã, ñañaro mʉjare cʉ̃ja ca tiiriquere acoboya, mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ cãa, ñañarije mʉja ca tiiriquere mʉjare cʉ̃ ca acobopere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ñañaro mʉjare cʉ̃ja ca tiiriquere mʉja ca acobotijata, mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ cãa, ñañaro mʉja ca tiiriquere mʉjare acobotirucumi —ĩiupi cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ate jiro Jerusalén'pʉ eaupa ñucã. Ʉmʉreco Pacʉ yaa wiipʉ Jesús cʉ̃ ca waa yujuro, paia ʉparã, doti cũuquĩriquere jʉo bueri maja, aperã judíos're ca jʉo niirã, Jesús pʉto eari: ");
INSERT INTO baoNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—¿Ñee doti majirique cʉocãri, atere to biro mʉ tii niiti? ¿Ñiru to biro mʉ ca tiirije doti majiriquere cʉ̃ tiicojojãri? —cʉ̃re ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Yʉ cãa, jĩcã wãme mʉjare yʉ jãiñarucu. Yʉre yʉʉya. Mʉja ca yʉʉjata, yʉ cãa, “Tee doti majirique mena atere to biro yʉ tii,” mʉjare yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿Ñiru Juan're cʉ̃ uwo coe doti cojoupari? ¿Ʉmʉreco Pacʉ? ¿Bojoca pee? Yʉre wedeya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","To biro cʉ̃jare cʉ̃ ca ĩiro, cʉ̃ja majurope: —“¿Do biro cʉ̃re mani ĩi yʉʉrãti? ‘Ʉmʉreco Pacʉ cʉ̃re doti cojoupi,’ mani ca ĩijata, ‘¿Ñee tiirã cʉ̃ ca wederijere mʉja tʉo nʉnʉjeetiri?’ manire ĩirucumi”. ");
INSERT INTO baoNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“ ‘Bojoca cʉ̃re uwo coe doti cojoupa,’ mani ĩi majiti,” ĩiupa. Bojocare uwi jañuupa, mee niipetirã, “Juan, Ʉmʉreco Pacʉ yee queti wederi majʉ niiwi,” ca ĩirã wado cʉ̃ja ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","To biri Jesús're: —¡Baa! Jãa majiti —cʉ̃re ĩi yʉʉcãupa. To cõrora Jesús pea: —To docare yʉ cãa, “Tee doti majirique mena to biro yʉ tii,” mʉjare yʉ ĩiticu —cʉ̃jare ĩi yʉʉupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","To cõrora Jesús ĩi cõoñarique mena cʉ̃jare wede jʉo waaupi: —Jĩcʉ̃ ʉje weje oteupʉ. Tii wejere jãni jãa amojode, ʉje oco cʉ̃ja ca quenopa tabe cãare queno, ñucã tii weje niipetirore ca ĩa coterã cʉ̃ja ca niipa wii cãare emʉari wii quenocã, tiiupʉ. To biro tii yapano, paderi majare tii wejere cũu, waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ʉje ca dica cʉtiri cuu ca earo, jĩcʉ̃ cʉ̃ pade bojari majʉre cʉ̃ ca pade dotiricarã pʉtopʉ tiicojo cojoupʉ, cʉ̃ yeere cʉ̃ja dica woo cojojato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Paderi maja pea cʉ̃ ca earo, cʉ̃re ñee, cʉ̃re paa, ñee jãa manigʉ cʉ̃re tii ãcũ tuenecã cojouparã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Jiro tii weje ʉpʉ apĩ cʉ̃ ʉmʉre tiicojoupʉ ñucã. Cʉ̃ cãare to birora ñañaro cʉ̃re ĩi tuti, cʉ̃ dʉpʉgare cami tuu, cʉ̃re tii ãcũ tuenecã cojouparã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jiro apĩ tiicojoupʉ ñucã. Cʉ̃ra jĩa cõacãuparã yua. Jiro aperã paʉ tiicojo nemomiupʉ ñucã. To biro cʉ̃ ca tiiricarãre jĩcãrãre cʉ̃jare quẽe, aperãra jĩa bate, tiicãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","”To biro cʉ̃ja ca tiimijata cãare, jĩcʉ̃ dʉjaupʉ ména, cʉ̃ macʉ̃ majurope bʉaro cʉ̃ ca maigʉ. To biri: “Yʉ macʉ̃ra nʉcʉ̃ bʉorucuma,” ĩi tʉgoeñari, cʉ̃ macʉ̃re tiicojomiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","”Paderi maja pea cʉ̃ ca dooro ĩari, “Ani niimi, ati wejere ca cʉo nʉnʉjeepʉ, cʉ̃re mani jĩa cõacãco. To biro mani ca tiiro, mani yaa weje tuarucu,” ameri ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","To biri cʉ̃re ñee, cʉ̃re jĩa, cʉ̃ upʉri niiquĩriquere tii weje tʉjaropʉ cõacãuparã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","”¿Ʉje weje ʉpʉ do biro tiirucumi mʉja ĩi tʉgoeñati? Waa, paderi majare jĩa batecã, ʉje wejere aperãre tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Mʉja o biro cʉ̃ja ca ĩi owa cũuriquere mʉja bue ñaatiti? O biro ĩi: “Ʉ̃tãga, wii bʉari maja cʉ̃ja ca beje cõaricagara, ca nii majuropeerica nii ea. ");
INSERT INTO baoNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Atere Ʉpʉ tiiupi. Teere ĩarã, mani ĩa ʉcʉacoa,” ĩi, —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Teere tʉorã, Jesús're ñeerʉgamiupa, to biro cʉ̃ ca ĩi cõoña wederije mena “Manirena ĩi tutigʉ ĩimi,” ĩi majiri. Cʉ̃re ñeerʉga pacarã, bojocare uwima ĩirã cʉ̃re ñeetirãra waa weocoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jiro jĩcãrã fariseos, Herodes yaa pooga macãrãre Jesús pʉto tiicojoupa, cʉ̃ja ca wedejãapa wãme ʉnore cʉ̃ ca ĩi bui cʉtiro cʉ̃ja tiijato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","To biri Jesús pʉto eari: —Buegʉ, mʉ ca wederije díámacʉ̃ra mʉ ca ĩirijere jãa maji. Bojocarena mʉ tʉo nʉnʉjeeti. Cʉ̃ja ca baurijerena ca ĩa nʉnʉjeetigʉ niiri, Ʉmʉreco Pacʉ yee maquẽre ca niirore birora mʉ bue majio. To biri, ¿to añu jañuti wiogʉ Roma macʉ̃re niirique wapa jãa ca wapa tiirucurije? ¿To añutitiqué? ¿Cʉ̃re jãa wapa tiigajati? ¿Jãa wapa tiitigajatiqué? —cʉ̃re ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesús pea to biro watoara cʉ̃ja ca ĩi ditorijere ĩa majiri, o biro cʉ̃jare ĩiupi: —¿Ñee tiirã, “Ñañarije cʉ̃ ĩi bui cʉtijato,” ĩi tʉgoeñari, to biri wãme yʉre mʉja ĩi jãiñati? Jĩcã tii wapa tiirica tii yʉre ami dooya, yʉ ĩañama —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","To biro cʉ̃ ca ĩiro, wapa tiirica tiire ami waa, cʉ̃re cʉ̃ja ca tiicojoro, o biro ĩi jãiñaupi: —¿Ñiru diámacʉ̃, ñiru wãme, owa tuurique to tujati? —ĩiupi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —Wiogʉ romano César yee —cʉ̃re ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","To biro cʉ̃ja ca ĩiro: —To docare, César yee ca niirijere, César're tiicojoya. Ʉmʉreco Pacʉ yee ca niirijera, Ʉmʉreco Pacʉre tiicojoya —cʉ̃jare ĩiupi Jesús. To biro cʉ̃ ca ĩi yʉʉro, do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ñucã saduceos, “Ca bii yairicarã cati tuaticuma,” ca ĩirã, Jesús're ĩarã waari, o biro cʉ̃re ĩi jãiñaupa: ");
INSERT INTO baoNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Buegʉ, Moisés: “Jĩcʉ̃ nʉmo cʉti, puna manigʉra cʉ̃ ca bii yai weojata, cʉ̃ nʉmo ca niiricore cʉ̃ bai pee cʉ̃ nʉmo cʉtijato, cʉ̃ jũwʉ niiquĩricʉre puna cʉti wajoa bojarʉgʉ,” jãare ĩi owa cũuquĩupi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","To biri jĩcãti jĩcʉ̃ puna jĩcã amo peti, ape amore pʉaga penituaro ca niirã peti niiwa. Ca nii jʉogʉ nʉmo cʉtimiupi. Puna manigʉra bii yaicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Cʉ̃ ca bii yairo jiro, cʉ̃ jiro macʉ̃ cõrena nʉmo cʉtimiupi. Cʉ̃ cãa puna manigʉra bii yaicoaupi. Cʉ̃ja pʉarã jiro macʉ̃ cãa to birora biicãupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","To biro wado cʉ̃ja, jĩcã amo peti, ape amore pʉaga penituaro ca niimiricarã cõ menare puna manirã wado bii yai peticoaupa. Cʉ̃ja jiro cʉ̃ja nʉmo ca niimirico cãa bii yaicoaupo. ");
INSERT INTO baoNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To docare yua, cati tuarica tabe ca niiro cʉ̃ja ca cati tuaro, cʉ̃ja, jĩcã amo peti, ape amore pʉaga penituaro ca niirãpʉra cʉ̃ja ca nʉmo cʉtimirico pea, ¿nii nʉmo pee cõ niigoti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Mʉja no ca boorora mʉja ĩi maa wijiacã, Ʉmʉreco Pacʉ wederiquere, cʉ̃ ca tutuarijere majitima ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ca bii yairicarã cati tuarãpʉa, ʉmʉa, nomia, manʉ cʉti, nʉmo cʉti, tiitirucuma. Ʉmʉreco tutipʉ ca niirã Ʉmʉreco Pacʉ pʉto macãrãre biirã wado niicãrucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ca bii yairicarã cʉ̃ja ca cati tuarije queti, ¿Moisés, yucʉgʉ ʉ̃ʉ pacaro ca ʉ̃ʉ petitirije queti, cʉ̃ ca owariquere mʉja bue ñaatiti? O biro ĩiupi Ʉmʉreco Pacʉ Moisés're: “Yʉa, Abraham, Isaac, Jacob jãari Ʉmʉreco Pacʉ yʉ nii,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ʉmʉreco Pacʉa ca bii yairicarã Ʉmʉreco Pacʉ méé niimi. Ca catirã Ʉmʉreco Pacʉ niigʉ biimi. Mʉja no ca boorora mʉja ĩi maa wijiacã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Añuro cʉ̃jare cʉ̃ ca yʉʉ majiro tʉori, jĩcʉ̃ doti cũuriquere ca jʉo buegʉ Jesús pʉto waari, o biro cʉ̃re ĩi jãiñaupi: —¿Ʉmʉreco Pacʉ cʉ̃ ca doti cũurique niipetirore dije peti to niiti, ca jʉo nii majuropeerije? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Ʉmʉreco Pacʉ cʉ̃ ca doti cũurique ca nii majuropeerije ate nii: “Tʉoya Israel: Ʉpʉ mani Ʉmʉreco Pacʉ, cʉ̃ jĩcʉ̃ra Ʉpʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ʉpʉ mʉ Ʉmʉreco Pacʉre mʉ yeri niipetiro mena, mʉ ca tʉgoeñarije, mʉ ca cati niirije, mʉ ca tutuarije niipetiro mena cʉ̃re maiña.” ");
INSERT INTO baoNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Jiro macã wãme: “Mʉ pʉto macãrã cãare mʉ upʉre mʉ ca mairore birora maiña,” ape wãme doti cũurique ate ametʉenero ca nii majuropeerije mani —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","To biro Jesús cʉ̃re cʉ̃ ca ĩi yʉʉro: —Añu majuropeecã Buegʉ. “Jĩcʉ̃ra niimi Ʉmʉreco Pacʉ; apĩ manimi,” mʉ ca ĩijata, díámacʉ̃ra mʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ʉmʉreco Pacʉre mani yeri niipetiro, mani ca tʉgoeñarije niipetiro, mani ca tutuarije niipetiro mena cʉ̃re mai, mani pʉto macãrãre mani upʉre mani ca mairore birora mairiquea, waibʉcʉrã joe mʉene, waibʉcʉrã jĩari tiicojo nʉcʉ̃ bʉo, tiirique niipetirije ametʉenero ca nii majuropeerije nii —ĩiupi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Añuro majirique mena cʉ̃ ca yʉʉro tʉogʉ, o biro cʉ̃re ĩiupi Jesús: “Petoacã dʉja, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre mʉ ca tʉo majiro,” cʉ̃re ĩiupi. To cõrora jĩcʉ̃ ʉno peera cʉ̃re jãiña nemotiupa yua. ");
INSERT INTO baoNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús, Ʉmʉreco Pacʉ yaa wiipʉ bojocare bue niigʉ, o biro ĩi jãiñaupi: —¿Ñee tiirã doti cũuriquere ca jʉo bueri maja pea, “Mesías, David pãrami niimi,” cʉ̃ja ĩirucuti? ");
INSERT INTO baoNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David majuropeera Añuri Yeri cʉ̃re cʉ̃ ca majiorije jʉori o biro ĩiquĩupi: “Ʉpʉ o biro ĩiwi yʉ Wiogʉre: ‘Yʉ díámacʉ̃ nʉña pee duwiya, Mʉ waparãre cʉ̃ja ca doca cũmuro yʉ ca tiiropʉ,’ ” ĩiupi David. ");
INSERT INTO baoNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿To docare do biro pee biicãri Mesías, David majuropeera “Yʉ Wiogʉ,” cʉ̃ ca ĩiricʉ nii pacagʉ, David pãrami cʉ̃ niibogajati? —cʉ̃jare ĩiupi Jesús. To biro cʉ̃ ca ĩirijere ca tʉo niirã pea, añuro ʉjea niirique mena tʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Bue majio niigʉ, o biro ĩiupi Jesús: —Doti cũuriquere jʉo bueri maja cʉ̃ja ca biirique cʉti niirijere ĩa maji bojoca catiri niiña: Juti yoerije jãñacãri waa yuju, wiijeri watoa macã yeparipʉ cʉ̃ja ca waa yujuro, nʉcʉ̃ bʉorique mena cʉ̃ja ca jãiro boo, ");
INSERT INTO baoNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nea poo juu buerica wiijeripʉ cãare wiorã cʉ̃ja ca duwiri taberipʉ wadore duwirʉga, baarica taberi cãare añuri taberi wado baa duwirʉga, biima. ");
INSERT INTO baoNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ñucã ca manʉ jʉ̃mʉa bii yai weoricarã romiri yaa wiijeri cãare ẽmarucuma. To biro tii pacarã, tii ditorã yoaro juu buema. Cʉ̃ja, ametʉenero ñañaro tii ecorucuma —ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús, Ʉmʉreco Pacʉ yaa wiipʉ, Ʉmʉreco Pacʉre tiicojo nʉcʉ̃ bʉorã cʉ̃ja ca jãari cũmuari díámacʉ̃, bojoca wapa tiirica tiiri cʉ̃ja ca jãaro ĩa duwiupi. Paʉ ca apeye pairã, pairori wapa tiirica tiiri jãaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","To biro cʉ̃ja ca tii niiro watoare, jĩcõ ca manʉ bii yai weo ecorico ca boo pacogo eari, wapa tiirica tiiri pʉa tiiacã ca wapa mani jañuri tiiriacã jãaupo. ");
INSERT INTO baoNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Cõre ĩa, Jesús pea cʉ̃ buerãre jʉo cojori, o biro cʉ̃jare ĩiupi: —Yee méé mʉjare yʉ ĩi: Atio ca manʉ bii yai weorico ca boo pacago pea niipetirã ametʉenero tiicojomo. ");
INSERT INTO baoNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Niipetirãpʉra ca dʉjarije ca bii baterije ʉnopʉre tiicojoma. Cõ pea, ca boo pacago nii pacago, cõ ca wapa tii baa cati niiboriqueacãrena jãa peoticãmo —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús, Ʉmʉreco Pacʉ yaa wiire cʉ̃ ca witi waaro, jĩcʉ̃ cʉ̃ buegʉ o biro cʉ̃re ĩiupi: —Buegʉ, ĩañaaqué, ¿no cõro pairi wii, paca ʉ̃tã mena cʉ̃ja weejapari? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","To biro cʉ̃ ca ĩiro, Jesús pea: —¿Ati wiijeri bʉcʉ niipetirijere mʉ ĩati? Tii wiijeri maquẽ, ʉ̃tãga jĩcãga ʉno peera jotoa pejaricaro maniro tii yaio ecorucu. Niipetirije tii bate ñoo yaio ecocoarucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jiro Ʉmʉreco Pacʉ yaa wii ãpõtĩñaro ca niiri buuro Olivos Buuropʉ waacoaupa. Toopʉ Jesús ea, cʉ̃ ca ea nuu waaro, Pedro, Santiago, Juan, Andrés jãa wado bojoricaro o biro cʉ̃re ĩi jãiñaupa: ");
INSERT INTO baoNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“¿Jãare wedeya, ano mʉ ca ĩirijea no cõropʉ to biiroti? ¿Do biro to biiroti, ano mʉ ca ĩirije niipetiro ca biiparo jʉguero?” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Bojoca catiya, jĩcʉ̃ ʉno peerena mʉja ca ĩi dito ecotipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Paʉ doorucuma, “Yʉra yʉ nii Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojogʉ,” ca ĩi dito yujuparã. To biro ĩicãri, paʉ bojocare ĩi ditorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","”Ñucã, cʉ̃ja ca ameri jĩarije queti, “Ameri jĩarique waarucu,” cʉ̃ja ca ĩirije quetire tʉorã, ʉcʉaticãña. To birora ca biipe niiro biirucu; biiropʉa ati ʉmʉreco petiro méé biirucu ména. ");
INSERT INTO baoNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jĩcã puna macãrã, ape puna macãrã mena ameri jĩarucuma. Jĩcã yepa macãrã, ape yepa macãrã mena ameri jĩarucuma. Yepa ca jaberije cãa paʉ taberipʉre biirucu. Ñucã aʉa niirucu. Atea ñañaro tamʉorique bii jʉo nʉnʉa waaro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","”Mʉja pea bojoca catiri ñiiña. Mʉjare ñeeri, jãiña bejeri majapʉre noni, nea poo juu buerica wiijeripʉra mʉjare bape, tiirucuma. Yʉ yee jʉori, wiorã pʉtoripʉ, bojocare ca jʉo niirã pʉtoripʉ, mʉjare jee waarucuma, cʉ̃ja pʉtoripʉ yʉ yee maquẽre mʉja ca wedepere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ate añurije quetire, ati yepa ca petiparo jʉguero, bojoca poogaari cõrorena wederique niirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Mʉjare ñeeri, ʉparã pʉtoripʉ cʉ̃ja ca jee waaro, cʉ̃jare mʉja ca yʉʉpere, “¿Do biro mani ĩirãti?” ĩi tʉgoeñarique paiticãña. To biro mʉjare cʉ̃ja ca tiiri tabere Ʉmʉreco Pacʉ mʉjare cʉ̃ ca ĩi dotirijere cʉ̃jare ĩiña. Mʉja majuropeera wederã méé mʉja ĩirucu. Añuri Yeri wedegʉ ĩirucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Cʉ̃ja yee wederãra, cʉ̃ja yee wederãre cʉ̃ja ca jĩa cõaro tiirucuma. Cʉ̃ja pacʉara, cʉ̃ja punarena cʉ̃ja ca jĩa cõaro tiirucuma. Cʉ̃ja puna cãa, cʉ̃ja pacʉa menara ameri ĩa juna, cʉ̃jare jĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Yʉ yee jʉori, niipetirã mʉjare ĩa tutirucuma. To biro ca biirije watoara, to birora ca tʉgoeña bayicõa niigʉa, ametʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","”Ñucã Ʉmʉreco Pacʉ yaa wii ca ñañarije maniri jawipʉre ĩaricaro docuorije ca niipa tabe ʉno méérena ca niiro ĩarã, atere ca buegʉ tʉo majiña, Judea yepa ca niirã ʉ̃tã yucʉpʉ cʉ̃ja duticoajato. ");
INSERT INTO baoNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Cʉ̃ wii jotoapʉ ca niigʉ cãa, duwi doo, cʉ̃ yaa wii maquẽ apeyere jeegʉ jãa waa, cʉ̃ tiiticãjato. ");
INSERT INTO baoNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wejepʉ ca niigʉ cãa, cʉ̃ juti ʉnorena cʉ̃ jeegʉ tua waaticãjato. ");
INSERT INTO baoNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tii rʉmʉrire ñañaro peti biirucuma nomia ca puna jãñarã, ca ũpũrãacã ca puna cʉtirã romiri. ");
INSERT INTO baoNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","To biri Ʉmʉreco Pacʉre jãiña, mʉja ca dutiri rʉmʉri pue bʉcʉ rʉmʉri ca niitipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ñañaro biirica rʉmʉri, jĩcãti ʉno peera Ʉmʉreco Pacʉ ati yepare cʉ̃ ca tii jeeñoro jiro ca bii ñaatirique, ñucã jiro ca bii nemotipe, biiro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ʉmʉreco Pacʉ to biro ca biiri rʉmʉrire cʉ̃ ca dʉotijata, jĩcʉ̃ ʉno peera catitibocuma. Cʉ̃ yaarã cʉ̃ ca bejericarãre maima ĩigʉ, dʉorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","”To biri jĩcʉ̃ ʉno mʉjare, “Ĩaña. Ani niimi Mesías. Ĩaña, ĩi pee niimi,” cʉ̃ ca ĩijata cãare díámacʉ̃ cʉ̃re tʉoticãña. ");
INSERT INTO baoNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","“Yʉa, Cristo yʉ nii,” “Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ yʉ nii,” ca ĩi ditorã doorucuma. Paʉ tii bau nii ĩño, ca ĩa ñaaña manirije tii bau nii, tiirucuma ĩi ditorʉgarã. Ñucã Ʉmʉreco Pacʉ cʉ̃ ca bejericarã menapʉrena ĩi ditorucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Bojoca catiri niiña. Mee, ate niipetiro mʉjare yʉ wede majio jʉguecã. ");
INSERT INTO baoNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","”Tii rʉmʉrire ñañaro tamʉorica cuu jiro, “muipũ ʉmʉreco macʉ̃ naitĩacoa, ñami macʉ̃ cãa boeti, ");
INSERT INTO baoNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ñocõa ʉmʉreco tutipʉ ca niirã cãa ñaacoa, ʉmʉreco tutipʉre ca niirã ca tutuarã yuguicoa, biirucuma.” ");
INSERT INTO baoNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","”To cõrora yʉ, Ca Nii Majuropeegʉ Macʉ̃re, bueripʉ, bʉaro yʉ ca tutuarije mena, yʉ ca boe bate duwi dooro ĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yʉ ca beje jeericarã ati ʉmʉreco niipetiropʉ ca niirãre cʉ̃ja jee neojato ĩigʉ, yʉre pade bojari majare yʉ tiicojorucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","”Higueragʉ ca biirijere ĩa majiña. Tiigʉ dʉpʉri, abari dʉpʉriacã bii, wãma pũu wajoa ca biiro ĩarã, “Mee, cʉ̃ma jʉguero niicã doo,” mʉja ĩi ĩa maji. ");
INSERT INTO baoNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To biri wãmera, ate yʉ ca ĩirije ca biiro ĩarã, “Mee, Ca Nii Majuropeegʉ Macʉ̃ ati yepapʉre doogʉpʉ biimi,” mʉja ĩi majirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Yee méé mʉjare yʉ ĩi: Ate niipetirije ati cuu macãrã cʉ̃ja ca bii yaiparo jʉguero biirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ati ʉmʉreco, ati yepa, peticoarucu. Yʉ ca ĩirije pea yʉ ca ĩirore birora bii nʉnʉa waarucu. ");
INSERT INTO baoNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","”Biiropʉa, tii rʉmʉ ca niiro, too muipũ cʉ̃ ca niiro, “To biro biirucu,” ĩiriquepʉra, Ʉmʉreco Pacʉre queti wede bojari maja cãa, ñucã yʉ, cʉ̃ Macʉ̃ cãa, yʉ majiti. Ʉmʉreco Pacʉ wado majimi. ");
INSERT INTO baoNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","”To biri tʉgoeña bojoca catiri, ca cãnirãre biro niitirãra, to birora juu buecõa niiña. Mʉja, to biirije ca biipa rʉmʉre mʉja majiti. ");
INSERT INTO baoNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Atea, jĩcʉ̃ ape yepapʉ waarʉgʉ jʉguero cʉ̃ paderi majare cʉ̃ yaa wiire cote doti, ñucã cʉ̃ja ca niiro cõrorena paderique cũu, jope pãa coteri majʉ peera ĩa cote doti, cʉ̃ ca tiiricarore biro nii. ");
INSERT INTO baoNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","To biri bojoca catiri niiña, “Naiori tabe ca niiro, ñami decomacã ca niiro, ãbocʉ cʉ̃ ca wãcãri tabe ca niiro, boeri tabe ca niiro, earucumi wii ʉpʉ,” mʉja ĩi majiti, ");
INSERT INTO baoNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","“Doocumi,” mʉja ca ĩitiri tabera doori, ca cãnirãrena mʉjare cʉ̃ ca bʉa eatipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Mʉjare yʉ ca ĩirijere, niipetirãpʉre ĩigʉ yʉ tii: Añuro tʉgoeña bojoca catiri niiña —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mee, pʉa rʉmʉ dʉjacã dooupe Pascua boje rʉmʉ, ñucã baariquere ca wauarije ca ayiaya manirijere baarica boje rʉmʉ. Tii rʉmʉrire paia ʉparã, doti cũuriquere ca jʉo buerã, jĩcã wãme ĩi ditorique mena Jesús're ñeeri, cʉ̃ja ca jĩa cõacãpere ama niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","To biri o biro ĩi niiupa: —Boje rʉmʉ petira mani tiiticãjaco, bojoca ajiama ĩirã uwiorije cʉ̃ja ca tiitipere biro ĩirã —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús, Betaniapʉ, Simón ca cami boagʉ ca wãme cʉtigʉ yaa wiipʉ baarique peorica pĩi pʉto cʉ̃ ca duwiro, jĩcõ nomio alabastroga dadaro, ca jʉti añurije nardogʉ maquẽ ca dia peti ca niirije, ca wapa pacarijere cʉocãrico ea, tiiga ñacõre tuu peeri, Jesús dʉpʉgare pio peoupo. ");
INSERT INTO baoNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Jĩcãrã too ca niirã, to biro cõ ca tii batero ĩa ajiari, o biro ameri ĩiupa: —¿Ñee tiigo ca wapa pacarijerena to birora cõ pio batecãti? ");
INSERT INTO baoNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","To biro tiitigora, jĩcã cʉ̃ma pade wapa taaricaro cõro noni wapa jeeri, ca boo pacarãre ca tii nemo poo niimijapo —cõre ĩi wede paiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesús pea o biro ĩiupi: —To birora ĩacãña. ¿Ñee tiirã to biro cõre mʉja ĩi pato wãcõti? Yʉ menare añuro tiigo tiimo. ");
INSERT INTO baoNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ca boo pacarãra to cãnacã rʉmʉra mʉja mena cʉ̃ja ca niiro, mʉja ĩarucu. No mʉja ca boori rʉmʉ cʉ̃jare mʉja tii nemo maji. Yʉ peera to cãnacã rʉmʉra yʉre mʉja cʉotirucu. ");
INSERT INTO baoNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Atioa cõ ca tii bayiro cõro tiimo. Yʉre cʉ̃ja ca yaa cõapepʉre ĩigo, ca jʉti añurije mena yʉ upʉre pio peo jʉguemo. ");
INSERT INTO baoNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yee méé mʉjare yʉ ĩi, ati yepare añurije quetire cʉ̃ja ca wederi taberipʉ, atio o biro yʉre cõ ca tiirijere wederucuma. To biro cʉ̃ja ca ĩiro, cõ cãa majirico niirucumo —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscariote, Jesús buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena macʉ̃ra, paia ʉparã pʉtopʉ wede penigʉ waaupi, Jesús're ñee dotirʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Cʉ̃ja pea teere tʉorã, bʉaro ʉjea nii, “Tee wapa wapa tiirica tiiri mʉre jãa tiicojorucu,” cʉ̃re ĩiupa. To biri cʉ̃ pea cʉ̃re cʉ̃ ca ñee dotipa tabe ʉnore ama jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan're ca wauaro ca tiirije ca ayiaya manirije baarica boje rʉmʉ ca nii jʉori rʉmʉ, Pascua macʉ̃ oveja macʉ̃re jĩarica rʉmʉre, Jesús buerã pea o biro cʉ̃re ĩi jãiñaupa: —¿Noopʉ Pascua boje rʉmʉre mʉ ca baapere jãa ca quenorã waaro mʉ booti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","To biro cʉ̃ja ca ĩiro, cʉ̃ buerã pʉarãre tiicojori, o biro cʉ̃jare ĩi cojoupi Jesús: —Macãpʉ waarãja. Toopʉ earã, jĩcʉ̃ ʉmʉ ocorʉ ca ami waagʉre mʉja bʉarucu. Cʉ̃re mʉja nʉnʉ waawa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Cʉ̃re nʉnʉ waa, cʉ̃ ca jãa waari wii ʉpʉre, “ ‘¿Noopʉ to niiti yʉ buerã mena Pascua boje rʉmʉre yʉ ca baapa jawi?’ ĩi jãiña doti cojojãwi Buegʉ,” mʉja ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","To biro mʉja ca ĩiro, jotoa macã jawi, pairi jawi, mee, añuro queno yuerica jawipʉre mʉjare ĩñorucumi. Toopʉ mani ca baapere mʉja quenowa —cʉ̃jare ĩi cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","To biro cʉ̃ ca ĩiro, cʉ̃ buerã pea waaupa macãpʉ. Toopʉ earã, niipetiro Jesús cʉ̃ ca ĩiricarore birora bʉaupa. Toopʉ Pascua boje rʉmʉ cʉ̃ja ca baapere quenoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Naiori tabe ca niiro, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena eaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Baarique peorica pĩi pʉto baa duwigʉra, o biro cʉ̃jare ĩiupi: —Yee méé mʉjare yʉ ĩi: Jĩcʉ̃ mʉja mena macʉ̃ yʉ mena ca baa duwigʉra yʉre wedejãa cõarucumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","To biro cʉ̃ ca ĩiro, cʉ̃ja pea bʉaro tʉgoeña pairique mena, cʉ̃ja ca niiro cõro: —¿Yʉra yʉ niicã tiimiti? —cʉ̃re ĩi jãiña jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Jĩcʉ̃ mʉja mena macʉ̃, pan'gare yʉ ca weyori baparena ca weyogʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Biigʉpʉa yʉ, Ca Nii Majuropeegʉ Macʉ̃, Ʉmʉreco Pacʉ wederique yʉ ca biipere “To biro biirucumi,” ca ĩirore biro biigʉ doogʉ yʉ tii, yʉre ca wedejãagʉ pea ñañaro peti biigʉ doogʉ tiimi. Cʉ̃ra cʉ̃ ca baʉaticãjata, añucãbojapa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Baa niigʉra pan're ami, teere juu bue peo yapano, pee bato, o biro ĩigʉra cʉ̃ buerãre tiicojoupi: —Ʉ̃jʉ, ate yʉ upʉri nii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Jiro jinirica bapare ami, Ʉmʉreco Pacʉre, “Añu majuropeecã,” ĩi yapano, cʉ̃jare tiicojoupi, niipetirãpʉra teere jiniupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","O biro ĩiupi: —Ate yʉ díi nii. “Ʉmʉreco Pacʉ, bojocare wãma wãme yʉ tii bojarucu,” cʉ̃ ca ĩiricarore biro to biijato ĩigʉ, paʉ cʉ̃ja ca ñañarije wapare yʉ ca bii yai bojarije. ");
INSERT INTO baoNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yee méé mʉjare yʉ ĩi, pʉati mʉja mena ʉje ocore yʉ jini nemotirucu, niipetirã mena ʉje oco wãmare Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉ yʉ ca jinipa rʉmʉ ca eaparo jʉguero —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Salmos baja yapano, Olivos macãnʉcʉ̃ buuropʉ waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","O biro ĩiupi Jesús cʉ̃ buerãre: —Ati ñamire mʉja niipetirãpʉra yʉre mʉja waa weocoarucu. O biro ĩi owarique nii: “Ovejas're ca cotegʉre yʉ jĩa cõacãrucu. Ovejas pea ũmaa batecoarucuma,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Biigʉpʉa, cati tuari jiro, Galileapʉ mʉjare yʉ jʉo neorucu ñucã —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Teere tʉogʉ, Pedro pea o biro ĩiupi Jesús're: —Niipetirã mʉre cʉ̃ja ca weocoamijata cãare, yʉa mʉre yʉ waa weotirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","To biro cʉ̃ ca ĩiro: —Yee méé mʉre yʉ ĩi: Ati ñamira pʉati ãbocʉ cʉ̃ ca wedeparo jʉguero, itiati peti “Cʉ̃re yʉ majiti,” mʉ ĩi ditorucu —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","To biro Jesús cʉ̃re cʉ̃ ca ĩimijata cãare: —Mʉ menara yʉ ca bii yaipe to ca niijata cãare, “Cʉ̃re yʉ majiti,” yʉ ĩi ditoti majuropeecãrucu —ĩiupi Pedro. To biro cʉ̃ ca ĩiro, niipetirãpʉra cʉ̃re biro wado ĩicãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jiro Getsemaní ca wãme cʉtiro pee waacoaupa. Jesús pea cʉ̃ buerãre o biro ĩiupi: —Yʉ ca juu buegʉ waa ditoye anora duwi yueya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","To biro ĩi, Pedro, Santiago, Juan jãa wadore jʉo waa, bʉaro uwi, tʉgoeñarique pai, bii jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","O biro ĩiupi: —Yʉ yeri, bii yaicoarica wãmepʉ bʉaropʉra tʉgoeñarique paicã. Mʉja anora tuari, to birora ĩacã niiña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","To biro cʉ̃jare ĩi, cʉ̃ja jʉguero jañuro pee waa, yepapʉ muu bia ea cũmu waari, “Ape tabera ñañaro yʉ ca biipe ‘ametʉacãbocu,’ ĩima ĩigʉ,” Ʉmʉreco Pacʉre jãiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O biro ĩi juu bueupi: “Abbá Cáacʉ, mʉra niipetirije mʉ ca tii majirije wado nii. Ano ñañaro yʉ ca biipere yʉre ametʉeneña. Biigʉpʉa, yʉ ca boori wãme tiiticãña. Mʉ ca boori wãme pee tiiya,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","To biro ĩi juu bue yapano, cʉ̃ buerã pʉto pee tua waagʉ, ca cãnirãpʉre bʉa eaupi. Cʉ̃jare ĩa, “¿Simón, cãnigʉ mʉ tiiti? ¿Yoa jañuroacã cãnitigʉra mʉ ĩa cote bayiti majuropeecãjãri? ");
INSERT INTO baoNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Cãnitirãra juu bueya, ñañarije ca bii buiyeerijere mʉja ca tiitipere biro ĩirã. Añurije mʉja tiirʉga tʉgoeña biirãpʉa; mʉja tʉgoeña bayiti majuropeecã tee peere,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","To biro ĩi yapano waa, cʉ̃ ca ĩiricarore birora juu bueupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Juu bue yapano, tua doogʉ, ca cãnirãpʉrena bʉa eaupi ñucã. Bʉaro peti cʉ̃jare wʉgoa eyocãupe. To biri do biro cʉ̃re ĩi yʉʉ majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ñucã itiati waa, tua eagʉ, o biro cʉ̃jare ĩiupi: —¿Ména, toora cãni, yerijãa mʉja tiicõa niiti? To cõrora cãniña. Mee, yʉ, Ca Nii Majuropeegʉ Macʉ̃ ñañarije ca tiirãpʉre yʉ ca noni cõa ecori tabe eacoa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wãmʉ nʉcãña. Jamʉ. Yʉre ca wedejãa buiyee cõagʉ, mee ĩirã tʉja doomi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ména, Jesús to biro cʉ̃ ca ĩi niirora, Judas Iscariote, Jesús buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena macʉ̃ra, paʉ bojoca, paia ʉparã, doti cũuriquere ca jʉo buerã, to biri judíos're ca jʉo niirã, cʉ̃ja ca doti cojoricarã mena, yucʉ dʉcari, niipĩiri, beju cʉticãri eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Wedejãari majʉ Judas pea o biro cʉ̃jare ĩi wede majio yerijãaupi: “Cʉ̃ wajopuare yʉ ca ũpũgʉ niirucumi. Cʉ̃re ñee, añuro jiacãri mʉja ami waawa,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","To biri Jesús pʉto waa, o biro cʉ̃re ĩiupi: —Buegʉ —ĩigʉra, cʉ̃ wajopuare ũpũupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","To cõrora Jesús're cʉ̃re ñeecãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","To biro cʉ̃ja ca tiiro, jĩcʉ̃ too ca niigʉ, cʉ̃ niipĩire yoo wee amiri, paia wiogʉre pade bojari majʉ amoperore paa taa ñoocã cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesús pea o biro cʉ̃jare ĩi jãiñaupi: —¿Ñee tiirã jee dutiri majʉre ca tiirãre biro, yucʉ dʉcari, niipĩiri, beju cʉticãri yʉre mʉja ñeerã doojãri? ");
INSERT INTO baoNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","To cãnacã rʉmʉra Ʉmʉreco Pacʉ yaa wiipʉ añurije quetire yʉ bue niirucujãwʉ. Jĩcãti ʉno peera yʉre mʉja ñeetiwʉ. Biiropʉa, Ʉmʉreco Pacʉ wederique ca ĩirore birora ca biipe niiro bii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","To cõrora cʉ̃ buerã niipetirãpʉra duti peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","To ca bii pacaro, jĩcʉ̃ wãmʉ, ũmaarica quejero mena ũmaacãri, cʉ̃jare nʉnʉ waaupi. To biro cʉ̃ ca biiro, cʉ̃re ñeecãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Cʉ̃ pea tii quejerore piti cõa cũu, juti manigʉra duticoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesús're paia wiogʉ pʉtopʉ ami waaupa. Toopʉre paia ʉparã, judíos're ca jʉo niirã niipetirã, doti cũuriquere ca jʉo buerã, nea pooupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ména, Pedro pea cʉ̃ja jiro yoaropʉra nʉnʉa waa, paia wiogʉ yaa wii jupea macã yepapʉ eacoaupi. Toopʉ uwamarã, Ʉmʉreco Pacʉ yaa wiire ca coterã mena peca jumacã duwiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Paia ʉparã, to biri niipetirã ʉparã ca nii majuropeerã pea, Jesús're jĩa cõarʉgarã jĩcã wãme cʉ̃ ca tii bui cʉtirique ʉnore amamiupa. Bii pacarã bʉatiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Paʉ, ca manirijerena cʉ̃re wedejãa niimiupa. To biro ĩi pacarã, cʉ̃ja majuropeera ameri ĩi maa wijiacã niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","To biro ĩi ñami waarã, jĩcãrã, watoara o biro cʉ̃re ĩi wedejãaupa: ");
INSERT INTO baoNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jãa o biro cʉ̃ ca ĩirijere jãa tʉowʉ: “Ati wii Ʉmʉreco Pacʉ yaa wii, bojoca cʉ̃ja ca tiirica wiire cõacã, ñucã itia rʉmʉ jirora ape wii bojoca méé cʉ̃ja ca tiirica wii yʉ tiirucu,” ĩiwi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","To biro ĩicã pacarã, ñucã to biro cʉ̃ja ca ĩirijerena maa wijiacãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","To cõrora paia wiogʉ pea niipetirã watoa wãmʉ nʉcãri, Jesús're jãiñaupi: —¿Ñee tiigʉ mʉ yʉʉtiti? ¿Ñeere ĩirʉgaro to ĩiti, o biro mʉre cʉ̃ja ca ĩi wedejãarije? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","To biro cʉ̃ ca ĩi pacaro, Jesús pea wedeti, cʉ̃re yʉʉti, biicãupi. To biro cʉ̃ ca biiro, paia wiogʉ pea o biro cʉ̃re ĩi jãiña nemoupi ñucã: —¿Mʉa Mesías, Ʉmʉreco Pacʉ ca añu majuropeegʉ Macʉ̃ mʉ niiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","To biro cʉ̃ ca ĩiro, Jesús pea: —Ʉ̃jʉ, cʉ̃ra yʉ nii. Mʉja, yʉ, Ca Nii Majuropeegʉ Macʉ̃re Ʉmʉreco Pacʉ niipetirijepʉre ca doti tutuagʉ díámacʉ̃ nʉña pee duwi, ñucã ʉmʉreco tuti maquẽ bueri bʉrʉripʉ doo, yʉ ca biiro mʉja ĩarucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesús to biro cʉ̃ ca ĩiro tʉogʉ, paia wiogʉ pea cʉ̃ jutirore yegari, o biro ĩiupi: —¿Ñee tiirʉgarã cõro ca wede nemoparãre paʉ mani boo nemobogajati? ");
INSERT INTO baoNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mee, mʉjara Ʉmʉreco Pacʉre ñañarije cʉ̃ ca ĩi tutirijere mʉja tʉo. ¿Mʉja do biro mʉja ĩiti? —ĩiupi. To biro cʉ̃ ca ĩiro niipetirãpʉra: —Mee, ca jĩa ecopʉra niigʉ tiimi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jĩcãrã cʉ̃re ʉjeco eo bate tuu, cʉ̃ capere juti quejero mena jia biatori cʉ̃re paa, tiicãri: —¡Ĩi bʉaya! ¿Ñiru mʉre cʉ̃ paati? —cʉ̃re ĩi epeupa. Ñucã Ʉmʉreco Pacʉ yaa wiire ca coterã cãa cʉ̃re paaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ména, Pedro pea macã yepapʉra cʉ̃ ca niiro, jĩcõ, paia wiogʉre pade coteri majo ametʉa waaupo. ");
INSERT INTO baoNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Too ametʉa waago, Pedro cʉ̃ ca peca juma duwiro ĩa, o biro cʉ̃re ĩiupo: —Mʉ cãa, Jesús, Nazaret macʉ̃ mena ca waa yujurucujãgʉra mʉ nii —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","To biro cõ ca ĩiro, Pedro pea: —Ñee ʉnore yʉre mʉ ĩiti. ¡Cʉ̃re yʉ majiti! —cõre ĩi ditoupi. To biro ĩi, tii wii jãa dooricaro pee witicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Cõra toopʉ cʉ̃ ca niiro cʉ̃re ĩari, o biro ĩicãupo ñucã, too ca niirãre: —Ani cãa cʉ̃ja mena macʉ̃ra niimi —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pedro pea ĩi ditocãupi ñucã. Ñucã jiroacãra too ca niirã o biro cʉ̃re ĩicãupa ñucã: —Mʉ cãa, cʉ̃ja mena macʉ̃ra mʉ nii. Galilea yepa macʉ̃ mʉ nii cã́jí, mʉ wederiquepʉ cãa tʉo majiriquera niicã —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","To biro cʉ̃ja ca ĩiro, Pedro pea cʉ̃jare ĩi tuti jañuri, o biro cʉ̃jare ĩiupi: —Yee méé yʉ ĩi nija. Yʉ majiti majuropeecã to biro yʉre mʉja ca ĩigʉra —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pedro to biro cʉ̃ ca ĩi niiri tabera ãbocʉ pʉati wedecoaupi. To cõrora, “Pʉati ãbocʉ cʉ̃ ca wedeparo jʉguero itiati peti, ‘Cʉ̃re yʉ majiti,’ mʉ ĩi ditorucu,” Jesús cʉ̃ ca ĩiriquere tʉgoeña bʉari, bʉaro otiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ca boerije mena, paia ʉparã, judíos're ca jʉo niirã, to biri doti cũuriquere ca jʉo buerã mena neari, cʉ̃ja ʉparã niipetirãpʉra “To birora ca tiipe niicu,” ĩi ameri wede peniupa. To biri Jesús're jiacãri ami waa, Pilatopʉre noniupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato pea: —¿Mʉa, judíos Wiogʉra mʉ niiti? —cʉ̃re ĩi jãiñaupi. To biro cʉ̃ ca ĩi jãiñaro, Jesús pea: —Mee, mʉra mʉ ĩi —cʉ̃re ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Paia ʉparã paʉ wãmeri cʉ̃re cʉ̃ja ca wedejãa niiro macã, ");
INSERT INTO baoNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato pea o biro cʉ̃re ĩi jãiñaupi ñucã: —Paʉ wãmeri peti ñañarije mʉre ĩi wedejãama. ¿Ñee tiigʉ mʉ yʉʉtiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","To biro cʉ̃ ca ĩimijata cãare, Jesús pea jĩcã wãme ʉnoacãra yʉʉrucu tiitiupi. To biro cʉ̃ ca biiro, Pilato pea: “Uwiorije ca biigʉ cʉ̃ niiti ania,” cʉ̃re ĩi ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ména Pilato pea Pascua boje rʉmʉrire jĩcʉ̃ tia cũurica wiipʉ ca niigʉre bojoca cʉ̃ja ca boogʉre wienerucuupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Tii tabere niiupi jĩcʉ̃ Barrabás ca wãme cʉtigʉ, ʉparãre ametʉene nʉcã, jĩacã, cʉ̃ ca tiirique jʉori, tia cũurica wiipʉ cʉ̃ mena macãrã mena ca niigʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Bojoca pea Pilato pʉto eari, cʉ̃ ca tiirucuricarore biro cʉ̃ tiijato ĩirã, cʉ̃re jãiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","To biro cʉ̃ja ca ĩiro, Pilato pea: —¿Judíos wiogʉre yʉ ca wienero mʉja booti? —cʉ̃jare ĩi jãiñaupi, ");
INSERT INTO baoNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","paia ʉparã Jesús're ĩa tutima ĩirã cʉ̃ja ca wedejãa cõariquere majiri. ");
INSERT INTO baoNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Paia ʉparã pea bojocare wedejãa mecʉ̃oupa, Pilatore “Barrabás peere wieneña,” cʉ̃re cʉ̃ja ĩi jãijato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ñucã Pilato pea o biro cʉ̃jare ĩi jãiñaupi: —¿Judíos wiogʉ mʉja ca ĩigʉ mena peera do biro yʉ ca tiiro mʉja booti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —Yucʉ tenipʉ cʉ̃re paa pua tuu cõacãña —ĩi acaro buiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","To biro cʉ̃ja ca ĩiro, Pilato pea: —¿Ñee ʉno ñañarije cʉ̃ tiijapari? —cʉ̃jare ĩiupi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea bʉaro jañuro, “¡Yucʉgʉ tenipʉ cʉ̃re paa pua tuu cõacãña!” ĩi acaro buiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","To cõrora Pilato pea bojoca mena añuro tuarʉgama ĩigʉ, Barrabás're wiene, Jesús peera cʉ̃re bape doti yapano, yucʉ tenipʉ cʉ̃re cʉ̃ja paa pua tuu cõajato ĩigʉ, cʉ̃jare tiicojocãupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Uwamarã pea wiogʉ cʉ̃ ca niiri tabe pretorio ca wãme cʉtiri wii macã yepapʉ Jesús're ami eari, cʉ̃ja mena macãrã uwamarã niipetirãre jʉo neoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","To biro tii, jutiro, wiorã cʉ̃ja ca jãñarito ʉno, bʉaro ca jũaritore cʉ̃re jãa, pota daa mena upa beto queno, cʉ̃ dʉpʉgare peoupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","To biro tiicãri: —Judíos wiogʉ to birora cʉ̃ caticõa niijato —ĩi acaro buiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","To biro ĩirãra, cʉ̃ dʉpʉgare yucʉgʉ mena paa, cʉ̃re ʉjeco eo tuu, cʉ̃ja ãjʉro jupeari mena ea nuuri, wiogʉre tii nʉcʉ̃ bʉorã cʉ̃ja ca tiirore biro cʉ̃re tii epeupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","To biro cʉ̃re tii epe yapano, ca jũari quejero cʉ̃re cʉ̃ja ca jãaricarore tuu wee, cʉ̃ juti majurope cʉ̃re jãa, cʉ̃re amicoaupa, cʉ̃re paa pua tuu cõarã waarã. ");
INSERT INTO baoNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Jĩcʉ̃ ʉmʉ Cirene macʉ̃, Simón ca wãme cʉtigʉ, Alejandro, Rufo jãari pacʉ, macã tʉjaropʉ ca niiricʉ tua doogʉ, too ca ametʉa waagʉre bʉa eari, Jesús're cʉ̃ja ca paa pua tuu paa tenire cʉ̃re pʉja dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jesús're, Gólgota ca wãme cʉtiri buuropʉ ami waaupa, (“Dʉpʉga Õaro” ĩirʉgaro ĩi). ");
INSERT INTO baoNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Toopʉ ʉje ocore, mirra cʉ̃ja ca ĩirije mena ayiari, Jesús're tĩamiupa. Cʉ̃ pea jinitiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","To biro tii, yucʉ tenipʉ cʉ̃re paa pua tuu nʉcõ yapano, uwamarã pea, cʉ̃ja majurope cʉ̃ jutirore ameri dica woo, ¿dii taberi ʉno peti mani bʉarãti? ĩirã, ĩi bʉarique mena tii niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Muipũ cʉ̃ ca aji mʉa tua petiri tabe ca niiro, cʉ̃re paa pua tuuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ate jʉori jĩa ecomi, cʉ̃ja ca ĩi owa tuurica pĩi: JUDÍOS WIOGɄ NIIMI, ca ĩiri pĩire paa pua tuuupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ñucã cʉ̃ mena pʉarã jee dutiri majare, jĩcʉ̃re cʉ̃ díámacʉ̃ nʉña, apĩra cʉ̃ ãcõ nʉña pee cʉ̃jare paa pua tuu nʉcõupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","O biro bii eaupa, o biro cʉ̃ja ca ĩi owarique: “Ñañarã watoapʉ biicã yai waawi,” cʉ̃ja ca ĩirique. ");
INSERT INTO baoNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","To ca ametʉa waarucurã cʉ̃ja dʉpʉgare yureri, o biro cʉ̃re ĩi tutiupa: —¡Níjá! Mʉ, Ʉmʉreco Pacʉ yaa wiire wee bateri, itia rʉmʉ jirora wãma wii ca quenocãgʉa, ");
INSERT INTO baoNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","mʉ majuropeera ametʉari, mʉre cʉ̃ja ca paa pua tuuricaropʉre duwicã dooya —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Paia ʉparã, doti cũuriquere ca jʉo buerã cãa, to birora cʉ̃re ĩi buiupa. O biro ĩiupa: —Aperãpʉra ametʉenecãwi. Cʉ̃ majurope pea ametʉa majitimi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Yucʉ tenipʉ niigʉra cʉ̃ duwicã doojato, cʉ̃, Mesías, “Israel wiogʉ yʉ nii,” ca ĩigʉa, teere ĩari díámacʉ̃ cʉ̃re mani ca tʉo nʉnʉjeepere biro ĩigʉ —ĩiupa. Ñucã cʉ̃ mena cʉ̃ja ca paa pua tuuricarã menapʉra ñañarije cʉ̃re ĩi tutiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Jotoa decomacã ca niirora ati yepa niipetiropʉ ca naitĩa peticoarique, muipũ yucʉ jotoa cʉ̃ ca niiropʉ boeupa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","To biro ca biiri tabera, tutuaro mena o biro ĩi acaro buiupi Jesús: —“Eloí, Eloí, ¿Lama sabactani?” —ĩiupi. “Yʉ Ʉmʉreco Pacʉ, yʉ Ʉmʉreco Pacʉ, ¿ñee tiigʉ yʉre mʉ waa weocoati?” ĩirʉgaro ĩi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jĩcãrã to ca niirã Jesús to biro cʉ̃ ca ĩirijere tʉorã, o biro ĩiupa: —¡Jãa, tʉoya! Elías're jʉogʉ ĩimi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","To cõrora jĩcʉ̃ cʉ̃ja mena macʉ̃, ũmaa waa, buja bʉrʉa mena ʉje oco ca piyarije weyo, yucʉgʉ yapa jia tuuri, cʉ̃ jinijato ĩigʉ, o biro ĩigʉra juu mʉene cojoupi: —¡Mani ĩa ñaacoqué ména! No cõro Elías cʉ̃re cʉ̃ ca ami duwiogʉ dooro —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","To cõrora Jesús pea tutuaro acaro bui tʉja, bii yaicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ʉmʉreco Pacʉ yaa wiire cʉ̃ja ca yoo camotaarica quejero pea decomacã yega taticã duwi waaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","To biro cʉ̃ ca bii yai waaro ĩagʉ, uwamarã ʉpʉ romano pea: —¡Yee mééra ania, Ʉmʉreco Pacʉ Macʉ̃ peti niimijapi! —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ñucã jĩcãrã nomia yoaropʉra ĩa cojocã niiupa. Cʉ̃ja menare María Magdalena, Santiago ca tʉjagʉ cʉ̃ja ca ĩigʉ, to biri José jãa paco María, Salomé, niiupa, ");
INSERT INTO baoNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús're Galileapʉra cʉ̃re nʉnʉ doo, cʉ̃re tii nemo, ca tiiricarã romiri. Ñucã toore, paʉ cʉ̃ mena Jerusalén'pʉ ca dooricarã romiri cãa niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ti rʉmʉ pea yerijãarica rʉmʉ maquẽre cʉ̃ja ca queno yueri rʉmʉ yerijãarica rʉmʉ ca nii jʉo waari tabe niiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","To biri naiori tabe ca niiro, José, Arimatea macʉ̃, ʉparã ca nii majuropeerã mena macʉ̃, ñucã Ʉmʉreco Pacʉ cʉ̃ ca dotiri cuu ca eapere ca yue niirucuricʉ, “To biro biibocu” ĩi uwiricaro maniro Pilato pʉtopʉ waaupi, Jesús upʉri niiquĩriquere jãirʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilato pea, “¿Mee, cʉ̃ bii yaicoajapari?” ĩi ʉcʉama ĩigʉ, uwamarã ʉpʉre jʉo cojori, “¿No cõropʉ cʉ̃ bii yaicã yerijãa waajãri?” cʉ̃re ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Uwamarã ʉpʉ, “Mee bii yaicoajãwi” cʉ̃ ca ĩiro tʉo, Jesús upʉri niiquĩriquere Josére tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","To biro cʉ̃ ca ĩiro, José pea Jesús upʉri niiquĩriquere ami duwio, juti ca botiri quejeri cʉ̃ ca wapa tiirique mena cʉ̃re ũmaa, ʉ̃tãgapʉ maja ope cʉ̃ ca coarica opepʉ cʉ̃re cũuupi. Jiro maja ope jãa waaricarore ʉ̃tãga mena tunuo biatocãupi. ");
INSERT INTO baoNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena, María, José paco jãari pea, Jesús upʉri niiquĩriquere cʉ̃ja ca cũuri tabere añuro ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Yerijãarica rʉmʉ ca ametʉaro, María Magdalena, Santiago paco María, apeo Salomé, ca jʉti añurije wapa tiiupa, Jesús upʉri niiquĩriquere wadarʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","To biri ape semana ca nii jʉori rʉmʉre, meepʉacã, muipũ cʉ̃ ca mʉa doorije mena maja opepʉ waacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Toopʉ waarã, o biro ameri ĩi nʉnʉa waaupa: —¿Ñiru maja ope biaricaga ʉ̃tãgare manire cʉ̃ ami woo bojagʉti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","To biro ĩi nʉnʉa waa, tii opepʉre ĩa cojorã, ʉ̃tãga pairica cʉ̃ja ca tiaricagara aperopʉ ca niiro ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Maja opepʉ jãa waarã, díámacʉ̃ nʉña peere jĩcʉ̃ wãmʉ, juti botirije jãñacãricʉ ca duwigʉre ĩauparã. Cʉ̃re ĩarãra, ʉcʉa yaicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","To biro cʉ̃ja ca biiro: —Ʉcʉaticãña. Mʉja, Jesús, Nazaret macʉ̃, yucʉ tenipʉ cʉ̃ja ca paa pua tuu cõajãgʉre mʉja ama. Manimi anora. Mee, cati tuacoajãwi. Cʉ̃re cʉ̃ja ca cũujãri tabere ĩañaaqué. ");
INSERT INTO baoNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Tua waari, cʉ̃ buerãre, Pedrore, o biro ĩi wede dooya: Mʉja jʉguero Galileapʉ waami. Toopʉ cʉ̃re mʉja ĩarucu, mʉjare cʉ̃ ca ĩiricarore birora —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","To cõrora cʉ̃ja romiri pea maja opepʉ ca niiricarã, do biro ĩi majiti, nanarãra duticã tua waaupa. To biri bʉaro uwima ĩirã, jĩcʉ̃ ʉno peerena jĩcã wãme ʉno peera wederucu, tiitiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tii semana ca nii jʉori rʉmʉ boeri tabe, Jesús cati tuari jiro María Magdalena, jĩcã amo peti, ape amore pʉaga penituaro ca niirã wãtĩa cʉ̃ ca cõa wiene catioricore baua ea jʉoupi. ");
INSERT INTO baoNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Cõ pea waa, Jesús mena ca waa yujurucuricarã bʉaro tʉgoeñarique pai, oti, ca tii niirãre wedeupo. ");
INSERT INTO baoNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Cʉ̃ja pea, “Jesús caticãjãwi. Cʉ̃re yʉ ĩajãwʉ,” cõ ca ĩirijere díámacʉ̃ tʉotiupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ñucã ate jiro, cʉ̃ buerã pʉarã macã tʉjaropʉ waarã, maapʉ ca waa nʉnʉa waarãre bojoricaro baugʉ, cʉ̃jare bii baua eaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Cʉ̃ja cãa tua waa, cʉ̃ja mena macãrãre wedemiupa. Cʉ̃ja cãare, “To biro ĩicãrã ĩicuma” cʉ̃jare ĩicãupa. ");
INSERT INTO baoNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jiro Jesús, cʉ̃ buerã pʉa amo peti, dʉpore jĩcãga penituaro ca niirãre, cʉ̃ja ca baa niiro cʉ̃jare baua eari, díámacʉ̃ tʉo nʉcʉ̃ bʉoti, ca cati tuaricʉpʉre ca ĩaricarã cʉ̃ja ca wederijere díámacʉ̃ tʉorʉgati, cʉ̃ja ca biirique jʉori cʉ̃jare tuti, ");
INSERT INTO baoNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","o biro cʉ̃jare ĩiupi: “Ati yepa niipetiropʉ waari, niipetirãpʉre añurije quetire wedeya. ");
INSERT INTO baoNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Teere tʉo nʉnʉjee, uwo coe eco, ca tiigʉ ametʉarucumi. Ca tʉo nʉnʉjeetigʉa, ñañaro tii yaio ecorucumi. ");
INSERT INTO baoNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Díámacʉ̃ ca tʉo nʉnʉjeerãre, o biri wãmeri tii majirique bapa cʉtirucu, ‘Jesús cʉ̃ ca dotiro mena atere yʉ ĩi,’ ĩiri wãtĩare cõa wiene, wãma wederique wede, ");
INSERT INTO baoNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","cʉ̃ja amori menara añaare ñee, punirije cʉ̃ja ca jinijata cãare cʉ̃jare ñañoti, ñucã ca diarique cʉtirãre cʉ̃ja amori mena cʉ̃jare cʉ̃ja ca ñia peorora caticoa, biirucuma,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","To biro cʉ̃jare ĩi wede yapano, Wiogʉ Jesús ʉmʉreco tutipʉ ami mʉa waa eco, Ʉmʉreco Pacʉ díámacʉ̃ nʉña pee duwi eaupi. ");
INSERT INTO baoNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Cʉ̃ buerã pea niipetiri taberipʉ añurije quetire wede yujuupa. To biro cʉ̃ja ca tii yujuro, Wiogʉ pea cʉ̃ja paderiquere tii nemo, añurije queti cʉ̃ja ca wederijere, ca ĩa ñaaña manirije tii bau niirique mena, “Díámacʉ̃ra nii,” cʉ̃ja ca ĩi majiro tii niiupi. To biro to biijato. Marcos");
INSERT INTO baoNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Paʉ, Ʉmʉreco Pacʉ mani watoare cʉ̃ ca tii niirique quetire, ca bii nʉnʉa dooricarore birora owa nʉnʉa dooupa, ");
INSERT INTO baoNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","jĩcãto cʉ̃ mena ca nii jʉoricarã cʉ̃ ca tiirijere ca ĩaricarã, jiropʉra yua tee quetire cʉ̃ ca wede dotiricarã, manire cʉ̃ja ca wedericarore birora. ");
INSERT INTO baoNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yʉ cãa, jĩcãtopʉra Jesús cʉ̃ ca bii jʉo doorique niipetirore añuro jãiña bue tʉgoeña maji peticãri, “Añu majuropeecã, to birora biijapa,” ĩi majiri, cʉ̃ ca bii nʉnʉa dooricarore birora mʉre yʉ owa cojo Teófilo, ");
INSERT INTO baoNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","mʉre cʉ̃ja ca bueriquere “To birora biijapa,” mʉ ca ĩi majipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herodes, Judea yepa wiogʉ cʉ̃ ca niiri cuure niiupi jĩcʉ̃ pai, Zacarías ca wãme cʉtigʉ, Abías niiquĩricʉ yaa puna macʉ̃, cʉ̃ nʉmo Elizabet cãa, Aarón niiquĩricʉ yaa puna macõ niiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Cʉ̃ja pʉarãpʉra, Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojoro ca bojoca añurã niiupa; Ʉmʉreco Pacʉ cʉ̃ ca dotirijere, doti cũurique ca ĩirijere, tee ca ĩirore biro ca tii nʉnʉjeerã, to biri noa pee, “Ñañarã niima,” cʉ̃jare ĩi majitiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Tee peere cʉ̃ nʉmo Elizabet, ca puna manigo cõ ca niiro macã, ca puna manirã niiupa. Ñucã, cʉ̃ja pʉarãpʉra mee bʉcʉrã peti niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Jĩcã rʉmʉ Zacarías cʉ̃ mena macãrã paia mena Ʉmʉreco Pacʉ cʉ̃ ca bojoca cʉti niiri jawipʉre cʉ̃jare paderique ca niiro, ");
INSERT INTO baoNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ʉmʉreco Pacʉ cʉ̃ ca bojoca cʉti niiri jawipʉre, yucʉ díi ca jʉti añurije ca joe mʉenegʉ waapʉre cʉ̃ja ca bejerucuricarore biro tiirã, Zacarías're cʉ̃re beje bʉaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ca jʉti añurijere joe jʉti añu mʉenerica tabe ca earo, macã yepa peera bojoca niipetirã boca juu bue cote niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Zacarías, ca jʉti añurijere cʉ̃ ca joe mʉene niiro, ca jʉti añurijere joe mʉenerica tutu díámacʉ̃ nʉña peere jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃ cʉ̃re baua ea nʉcãupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Cʉ̃ ca baua ea nʉcãro ĩagʉ, Zacarías pea ʉcʉa yaicoa, bʉaro uwi, biiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","To biro cʉ̃ ca biiro, Ʉmʉreco Pacʉ pʉto macʉ̃ pea o biro cʉ̃re ĩiupi: —¡Zacarías, uwieto! Mʉ ca jãi juu buerucurijere tʉomi Ʉmʉreco Pacʉ. To biri mʉ nʉmo Elizabet, jĩcʉ̃ mʉre macʉ̃ cʉti bojarucumo, Juan cʉ̃re mʉ ca wãmeo tiipʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Bʉaro mʉ ʉjea niirucu. Ñucã paʉ ʉjea niirucuma, cʉ̃ ca baʉaro ĩarã. ");
INSERT INTO baoNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Mʉ macʉ̃, watoa macʉ̃ méé niirucumi Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojorore. Ʉje ocore, jinirique ca niñaarijere, jinitirucumi. Mee, cʉ̃ ca baʉaparo jʉgueropʉra, Añuri Yeri mena niicãrucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ñucã paʉ israelitas, Ʉpʉ cʉ̃ja Ʉmʉreco Pacʉre cʉ̃ja ca tʉo nʉnʉjeero tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cʉ̃ Juan, Wiogʉ cʉ̃ ca dooparo jʉguerore, Elías niiquĩricʉre biro yeri cʉti, cʉ̃re biro tutua, bii jʉgue waarucumi, ca pacʉa cʉ̃ja puna mena añuro cʉ̃ja ca niiro tii, ca ametʉene nʉcãrãre ca ñañarije manirã cʉ̃ja ca majirije pee cʉ̃jare tii majio, tiirʉgʉ. O biro tiiri, cʉ̃jare wede majio jʉguerucumi, Wiogʉ cʉ̃ ca earo añuro cʉ̃ja ca ĩa majipere biro ĩigʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","To biro cʉ̃ ca ĩiro, Zacarías pea o biro cʉ̃re ĩi jãiñaupi: —¿Do biro pee biicãri, atere “Yee méé ĩimi,” yʉ ĩi majibogajati? Bʉcʉ peti yʉ nii. Yʉ nʉmo cãa, bʉcʉo niimo —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi: —Yʉa Gabriel yʉ nii, Ʉmʉreco Pacʉ yʉre cʉ̃ ca dotirijere tiigʉ yʉ tii. Cʉ̃ra, mʉ mena wede peni, ate añurije quetire mʉre wede, yʉre tii doti cojojãwi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","To biri mecʉ̃ra, mʉre yʉ ca wedejãrijere díámacʉ̃ yʉre mʉ ca tʉotirije wapa, ca wedetigʉ mʉ tuarucu, mʉre yʉ ca wedejãrije yʉ ca ĩijãrore biro mʉre ca bii petiropʉ, mʉ wederucu ñucã —ĩiupi Zacarías're. ");
INSERT INTO baoNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","To biro cʉ̃re cʉ̃ ca ĩi nii ditoye, macã peera Zacarías're yue niirã bojoca pea, “¿Ñee tiigʉ to cõro yoaro tii jawipʉre cʉ̃ biicã niigajati?” ameri ĩi jãiña niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","To biro cʉ̃ja ca ĩi niirucuro witi eagʉ, do biro tii wede majitiupi. To biro cʉ̃ ca biro ĩari, “Ʉmʉreco Pacʉ cʉ̃ ca bojoca cʉti niiri jawipʉre jĩcã wãme cʉ̃re ca bii ĩñorijere ĩajacupi,” ĩi majiupa. Ca wedetigʉ niima ĩigʉ, cʉ̃ amori mena tii cõoñarique mena wado wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ʉmʉreco Pacʉ yaa wiipʉ cʉ̃ ca paderi rʉmʉri ca petiro, cʉ̃ yaa wiipʉ tuacoaupi ñucã Zacarías. ");
INSERT INTO baoNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ate jiro, cʉ̃ nʉmo Elizabet ʉtaaga nii jʉo dooupo. Jĩcã amo cõro niirã muipũa peti wii witiri méé, o biro ĩi tʉgoeñacã niirucuupo: ");
INSERT INTO baoNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Mecʉ̃ra, Ʉmʉreco Pacʉ o biro yʉre tiimi, ‘Ca puna manigo niimo,’ yʉre cʉ̃ja ca ĩi wede paitipere biro ĩigʉ,” ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Jĩcã amo peti, ape amore jĩcãga penituaro ca niirã muipũa jiro, Ʉmʉreco Pacʉ, cʉ̃re queti wede bojari majʉ Gabriel're, Galilea yepa macã macã Nazaret'pʉ tiicojoupi, ");
INSERT INTO baoNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","María, jĩcʉ̃ ʉmʉ mena ca nii ñaatigore wiogʉ David niiquĩricʉ pãrami José ca wãme cʉtigʉ mena ca manʉ cʉtipore wii jãa doti cojogʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","To biri Gabriel, María cõ ca niiri tabepʉ jãa waa, o biro cõre ĩiupi: —Mʉ, Ʉmʉreco Pacʉ añurije cʉ̃ ca tii bojagore yʉ añu doti. Wiogʉ mʉ mena niimi. Niipetirã nomia watoare añuro cʉ̃ ca tiigo mʉ nii —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","María pea o biirije cõre cʉ̃ ca ĩirijere tʉori, do biro pee ĩi majiti, “¿Do biro ĩirʉgaro to ĩibuti, to biri wãme yʉre cʉ̃ ca ĩi añu doti jãa earijea?” ĩi tʉgoeñarique paicoaupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","To biro cõ ca ĩi uwi tʉgoeñaro ĩagʉ, Ʉmʉreco Pacʉre queti wede bojari majʉ pea: —Uwieto María. Mʉa, Ʉmʉreco Pacʉ añuro cʉ̃ ca tii bojarijere ca bii ʉjea niigo mʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","To biri ʉtaaga nii, ʉmʉ macʉ̃ cʉti, “JESÚS” cʉ̃re mʉ wãmeo tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Do biro ca tiiya manigʉ nii, ati ʉmʉreco niipetiropʉre Ca Doti Niigʉ Macʉ̃, cʉ̃ja ca ĩigʉ niirucumi; Ʉpʉ Ʉmʉreco Pacʉ pea, cʉ̃ ñicʉ̃ David niiquĩricʉre wiogʉ ca nii majuropeegʉ cʉ̃ ca niiro cʉ̃ ca tiiquĩricarore birora cʉ̃re tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Jacob yaa pooga macãrãre to birora ca doticõa niigʉ niirucumi; cʉ̃ ca doti niirije peti nʉcãtirucu —ĩiupi Maríare. ");
INSERT INTO baoNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","To biro cõre cʉ̃ ca ĩiro tʉo: —¿Ano yʉre mʉ ca ĩirijea, jĩcʉ̃ ʉmʉ mena yʉ ca niiti pacaro, do biro pee biicãri to biibogajati? —cʉ̃re ĩi jãiñaupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","To biro cʉ̃re cõ ca ĩi jãiñaro: —Añuri Yeri mʉre cotegʉ doorucumi. Ʉmʉreco Pacʉ ati ʉmʉreco niipetiropʉre Ca Doti Niigʉ cʉ̃ ca tutuarije, mʉre paa ũmaa nʉcã earucu. To biri wimagʉ ca ñañarije manigʉ ca baʉapʉre, “Ʉmʉreco Pacʉ Macʉ̃” ĩiricʉ niirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Bʉcʉopʉ nii pacago, mʉ yee wedego Elizabet cãa, “Puna manimo,” cʉ̃ja ca ĩimirico, mee jĩcã amo peti, ape amore jĩcãga penituaro muipũa ʉtaaga niicã tʉja waamo. To biri cõ cãa, macʉ̃ cʉtigo doogo tiimo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ʉmʉreco Pacʉra, jĩcã wãme ʉnoacã cʉ̃ ca tii majitiri wãme mani —ĩiupi Maríare. ");
INSERT INTO baoNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","To biro cʉ̃ ca ĩirijere tʉogo: —Ʉmʉreco Pacʉre pade coteri majo yʉ nii. To biro yʉre mʉ ca ĩi wederi wãmere birora, yʉre cʉ̃ tiijato Ʉmʉreco Pacʉ —ĩiupo María. To biro cõ ca ĩirora, waacoaupi Ʉmʉreco Pacʉre queti wede bojari majʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tii rʉmʉrira pato wãcãro mena, Judea yepare ʉ̃tã buurori watoa ca niiri macãpʉ waacoaupo María. ");
INSERT INTO baoNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tii macãpʉre eago, Zacarías yaa wiipʉ jãa ea, cʉ̃ nʉmo Elizabet're añu doti jãa eaupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","María cõ ca añu doti jãa earijere cõ ca tʉorora, wimagʉ cõ paa totipʉ ca niigʉra yuguiupʉ, Elizabet're. To biro cʉ̃ ca biiri tabera, Añuri Yeri Elizabet're ñaajãa nʉcã eaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","To cõrora tutuaro wederique mena o biro ĩiupo Elizabet, Maríare: —Nomia niipetirã ametʉeneropʉ añuro mʉre tiijapi Ʉmʉreco Pacʉ; ñucã mʉ macʉ̃ cãare añurije cʉ̃re tiijapi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Yʉa ñiruo ʉno yʉ niiti, yʉ Wiogʉ paco yʉre mʉ ca ĩago eajata? ");
INSERT INTO baoNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Yʉre mʉ ca añu doti jãa earijere yʉ ca tʉorije menara, yʉ Macʉ̃, yʉpʉre ca jãñagʉacã, ʉjea niigʉ yuguimi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ʉjea niiña mʉ, cʉ̃ ca ĩirijere ca tʉo nʉnʉjeerico, Wiogʉ mʉre cʉ̃ ca ĩirique cʉ̃ ca ĩiricarore biro biirucu —cõre ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","To cõrora María o biro ĩiupo: —Yʉ ca cati niirije Ʉmʉreco Pacʉ do biro ca tiiya manigʉ cʉ̃ ca niirijere baja peo nʉcʉ̃ bʉo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yʉ yeri, yʉre Ca Ametʉenegʉ yʉ Ʉmʉreco Pacʉpʉre bʉaro ʉjea nii. ");
INSERT INTO baoNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Cʉ̃re pade coteri majo watoa macõ yʉ ca nii pacaro, yʉre ĩajapi Ʉmʉreco Pacʉ. To biri mecʉ̃ mena, bojoca ca nii nʉnʉa waarã cõrora, to birora “Ʉjea niirique ca bʉarico niimo,” yʉre ĩicõa niirucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ʉmʉreco Pacʉ niipetirijepʉre ca doti tutuagʉ, do biro ca tiiya maniri wãmere yʉre tiimi. Cʉ̃a, “Ca Ñañarije Manigʉ,” wãme cʉtimi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Cʉ̃re ca ĩi nʉcʉ̃ bʉorãra, bojoca cʉ̃ja ca nii nʉnʉa waaro cõrora cʉ̃jare ĩa maimi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Cʉ̃ ca tutuarije niipetiro mena añurijere tiiupi. “O biro ca biirã jãa nii,” ca ĩirã cʉ̃ja ca tiirʉgarijere tii acobocãmi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Wiorã cãare, wiorã cʉ̃ja ca niimirijere ẽma, watoa macãrã peere ca nii majuropeerã cʉ̃jare tiimi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ca aʉa boarãra, niipetirije cʉ̃ja ca cʉoro tii, ca apeye pairã peera ñeeja manirã cʉ̃ja ca tuaro cʉ̃jare tiimi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israel, cʉ̃re pade coteri majʉ yaa pooga macãrãre, cʉ̃jare tii nemoupi. Ĩa mairique mena cʉ̃jare tii nemo acobotiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Mani ñicʉ̃ jãa niiquĩricarã, Abraham're, to biri cʉ̃ pãramerã ca nii nʉnʉa waaparãpʉ cãare, “O biri wãmera mʉjare yʉ tiirucu,” ĩiquĩupi Ʉmʉreco Pacʉ —ĩiupo Elizabet're. ");
INSERT INTO baoNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María itiarã muipũa Elizabet mena nii, jiro cõ yaa wiipʉ tuacoaupo ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Cõ ca macʉ̃ cʉtiri rʉmʉ ca earo, jĩcʉ̃ macʉ̃ cʉtiupo Elizabet. ");
INSERT INTO baoNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Cõ yaarã, cõ yaa macã macãrã, Ʉmʉreco Pacʉ añuro cõre cʉ̃ ca tii nemoriquere tʉori, cõre ʉjea nii peorã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Cʉ̃ ca baʉaricaro jiro, jĩcã amo peti, ape amore itiaga penituaro ca niiri rʉmʉri ca nii waaro, wimagʉ jeyua quejero yapare wide taa dotirã waaupa. Cʉ̃ pacʉ wãmera Zacarías cʉ̃re cʉ̃ja ca wãmeo tiirʉgaro macã cʉ̃ paco pea, ");
INSERT INTO baoNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","o biro cʉ̃jare ĩi camotaupo: —Biiticu. Juan, wãme cʉtirucumi —cʉ̃jare ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","To biro cõ ca ĩiro tʉorã: —Mʉ yaarã, jĩcʉ̃ peera mʉ ca ĩiri wãme ca wãme cʉtigʉ manimi doca —cõre ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","To biro ameri ĩi, cʉ̃ pacʉ pea “¿Di wãme cʉ̃ macʉ̃re cʉ̃ wãmeo tiirʉgati?” ĩirã, ca wedetigʉ cʉ̃ ca niiro macã tii cõoñarique mena cʉ̃re jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","To biro cʉ̃re cʉ̃ja ĩiro, cʉ̃ pea jĩcã pĩi yucʉ pĩi jãiri, tii pĩipʉre: “Cʉ̃ wãme nii Juan,” ĩi owa tuuupi. To biro cʉ̃ ca tiiro, to ca niirã niipetirã do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","“Cʉ̃, wãme cʉtirucumi,” ĩi owa tuugʉra, ca wedetigʉ ca niimiricʉ wede, Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo baja peo jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Cʉ̃ yaa macã macãrã niipetirã to biro cʉ̃ ca biirijere queti tʉorã, tʉo ʉcʉacoaupa. Ñucã Judea yepa maquẽ ca ʉ̃tã yucʉ cʉtiri yepa niipetiro macãrãpʉra to biro ca biiriquere ameri queti wede bato peoticã cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Teere ca tʉorã niipetirãpʉra, “¿Ani wimagʉa, do biro ca biipʉ peti cʉ̃ niigajati?” ĩi jãiñarucuupa cʉ̃ja majurope, añuro petira, Ʉmʉreco Pacʉ cʉ̃re cʉ̃ ca tii nemorije ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wimagʉ pacʉ Zacarías pea, Añuri Yeri cʉ̃pʉre cʉ̃ ca ñaajãa nʉcã earo macã, ca biipere o biro ĩi wede jʉgueupi: ");
INSERT INTO baoNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","—Añuro ĩiricʉ cʉ̃ niijato Ʉpʉ, Israel Ʉmʉreco Pacʉ cʉ̃ yaa pooga macãrãre ca ametʉenegʉ dooricʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Cʉ̃re pade coteri majʉ ca niiricʉ David pãramire, manire ca Ametʉenepʉ do biro ca tiiya manigʉre manire tiicojomi. ");
INSERT INTO baoNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Tĩrʉmʉpʉra atere, cʉ̃ yee quetire ca wede jʉguerã ca ñañarije manirã menapʉra “O biro yʉ tiirucu” ĩiquĩupi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Mʉja waparãre, mʉjare ca ĩa junarãre, mʉjare yʉ ametʉenerucu. ");
INSERT INTO baoNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Mani ñicʉ̃ jʉ̃mʉapʉre ĩa mai, “ ‘To biro yʉ tiirucu,’ cʉ̃ ca ĩirique ca ñañarije manirijere acoboti, yʉ biirucu” ĩiquĩupi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ñucã, ate nii, mani ñicʉ̃ Abraham niiquĩricʉpʉre, “Yʉ tii majuropeecãrucu,” cʉ̃ ca ĩirique: ");
INSERT INTO baoNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","75","“Uwi tʉgoeñaricaro maniro, ca ñañarije manirã niirique mena, ca niirore biro tii niirique mena, cʉ̃re tii nʉcʉ̃ bʉo nʉnʉjee, ñucã mani ca catiri rʉmʉri cõrora cʉ̃ ca bojoca cʉti niiri tabere nii, mani ca biipere biro ĩigʉ, waparã manirã cʉ̃ja ca niiro yʉ tiirucu,” ĩiquĩupi Ʉmʉreco Pacʉ, o biro manire cʉ̃ ca tii bojapere —ĩiupi Zacarías. ");
INSERT INTO baoNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","To biro ĩicã, cʉ̃ macʉ̃ peera o biro ĩiupi ñucã: —Mʉ, yʉ macʉ̃acã pea, “Ʉmʉreco Pacʉ ati ʉmʉreco niipetiropʉre Ca Doti Niigʉ yee quetire ca wede jʉguegʉ niimi,” ĩiricʉ mʉ niirucu. Wiogʉ cʉ̃ ca dooparo jʉguero, bojocare mʉ wede majio jʉguerucu, ");
INSERT INTO baoNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ʉmʉreco Pacʉ, “Cʉ̃ yaa pooga macãrãre, ñañarije cʉ̃ja ca tiiriquere acobo, ametʉene, tiimi,” cʉ̃jare ĩi majiorʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mani Ʉmʉreco Pacʉ bʉaro ca ĩa maigʉ niiri, jĩcã rʉmʉ muipũ añuro cʉ̃ ca boe bate mʉa doori rʉmʉre biro manire tii bojami, ");
INSERT INTO baoNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","bʉaro ca naitĩari tabepʉre ca niirãre biro ca niirãre, Ʉmʉreco Pacʉ cʉ̃ ca boorore biro niiriquere wede majio, añuro niiriquere manire ĩño jʉgue, manire tiirʉgʉ —ĩiupi Zacarías. ");
INSERT INTO baoNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wimagʉ bʉcʉa nʉnʉa waagʉra, yeri jãñariquepʉ bʉaro tutua añugʉ bii nʉnʉa waaupi. Ména, israelitas're Ʉmʉreco Pacʉ yee queti cʉ̃ ca wedeparo jʉguero ca bojoca maniro ca yucʉ maniri yepapʉ niicãrucuupi Juan. ");
INSERT INTO baoNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Tii rʉmʉrirena wiogʉ César Augusto bojoca niipetirãre cʉ̃ja wãmere owa peo dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ate, wãme owa peoriquera, Siria yepa wiogʉ Cirenio cʉ̃ ca niiri tabere tii jʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","To biri niipetirãpʉra cʉ̃ja ca niiro cõro cʉ̃ja yaa macãripʉ cʉ̃ja wãmere owa peo dotirã waarique niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tee jʉori José cãa, David niiquĩricʉ yaa puna macʉ̃ niiri, Galilea yepa macã macã Nazaret ca niiricʉ waaupi Judea yepa macã macã Belén ca wãme cʉtiri macã, wiogʉ David niiquĩricʉ cʉ̃ ca baʉarica macãpʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Toopʉ José, cʉ̃ nʉmo María menara cʉ̃ja wãmere owa peorã waaupa. To biro cʉ̃ja ca biiri tabere María pea ʉtaaga niiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Belén'pʉ cʉ̃ja ca bii niiro, María peera cõ ca macʉ̃ cʉtiri rʉmʉ eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Toopʉ baʉaupi cõ macʉ̃ ca nii jʉogʉ. Cʉ̃ ca baʉaro, juti quejeri mena cʉ̃re ũmaari, wecʉare baarique ecarica coropʉ cʉ̃re peoupo, cãnirica wiipʉre cãnirica taberi ca maniro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ovejas coteri majare baua eaupi Ʉmʉreco Pacʉre queti bojari majʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Tee jãa cʉ̃ja ca ĩitiri tabera, jĩcʉ̃ Ʉmʉreco Pacʉre queti wede bojari majʉ cʉ̃jare baua eaupi. Ʉpʉ cʉ̃ ca boe baterije pea cʉ̃ja wejare boe bate ñaacũmu eaupa. To biro ca biiro, cʉ̃ja pea bʉaro uwiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","To biro cʉ̃ja ca biiro, Ʉmʉreco Pacʉre queti wede bojari majʉ pea o biro cʉ̃jare ĩiupi: —Uwiticãña. Añurije queti niipetirã bojoca cʉ̃ja ca ʉjea niipere mʉjare wede doogʉ yʉ biijãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Mecʉ̃re, David niiquĩricʉ yaa macãpʉre baʉami jĩcʉ̃ mʉjare Ca Ametʉenepʉ, Ʉmʉreco Pacʉ cʉ̃ ca tiicojogʉ Mesías, Wiogʉ ca niigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Cʉ̃ra niimi mʉja ca ĩi majipere biro ĩirã, juti quejeri mena cʉ̃ja ca ũmaaricʉre wecʉare ecarica coropʉ ca pejagʉre mʉja bʉarucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","To biro cʉ̃ ca ĩi niiri tabera paʉ aperã Ʉmʉreco Pacʉre queti wede bojari maja cʉ̃ pʉtore baua ea, Ʉmʉreco Pacʉre o biro ĩi baja peoupa: ");
INSERT INTO baoNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Ʉmʉreco Pacʉ cʉ̃ ca añu majuropeerije niipetiropʉ nii. Añuro cʉ̃ ca tiirijere ca bii ʉjea nii niirãre, añuro niirique cʉ̃jare to niijato!” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ʉmʉreco Pacʉ pʉto macãrã ʉmʉreco tutipʉ cʉ̃ja ca tua mʉa waaro jiro, ovejas coteri maja pea o biro ameri ĩiupa: —Jamʉ Belén'pʉ. Ate queti Ʉpʉ manire cʉ̃ ca wederije ca biiriquere mani ĩaco —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","To biro ameri ĩi, jĩcãto waa, Maríare, Josére, wimagʉ peera, wecʉare baarique ecarica coropʉ ca jãñagʉre bʉa eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Cʉ̃re ĩarã, Ʉmʉreco Pacʉ pʉto macʉ̃ wimagʉ cʉ̃ ca biipe maquẽre cʉ̃jare cʉ̃ ca wederiquere bojocare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ovejas coteri maja to biro cʉ̃ja ca ĩirijere ca tʉorã niipetirã do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","María pea to biro cʉ̃ja ca ĩirije niipetirore cõ yeripʉ tʉgoeñacã niirucuupo. ");
INSERT INTO baoNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ovejare coteri maja pea ĩa, tʉo, cʉ̃ja ca tiirique niipetirije jʉori, Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo, cʉ̃re baja peo, tiicã tua waaupa, niipetirijepʉra cʉ̃jare cʉ̃ ca ĩiricarore birora ca biirijere ĩari. ");
INSERT INTO baoNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jĩcã amo peti, ape amore itiaga penituaro ca niiri rʉmʉri jiro, cʉ̃ jeyua quejero yapare wide taa dotirã waaupa. Ñucã María, ʉtaaga cõ ca niiparo jʉgueropʉra, Ʉmʉreco Pacʉ pʉto macʉ̃ cõre cʉ̃ ca ĩirica wãmera JESÚS cʉ̃re wãmeo tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Moisés cʉ̃ ca dotirique ca ĩirore biro, cʉ̃ja ca macʉ̃ cʉtiro jiro ca amori jujurije ca petiri rʉmʉri jirore, wimagʉ Jesús're, Jerusalén'pʉ cʉ̃re ami waaupa cʉ̃ pacʉa, Ʉmʉreco Pacʉre, “Mʉ yʉʉ niimi” cʉ̃re ĩi, ĩñorã waarã. ");
INSERT INTO baoNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Atere to biro tiiupa, Ʉpʉ cʉ̃ ca doti cũuriquepʉre o biro ĩi owa cũurique ca niiro macã: “Niipetirã ʉmʉa mʉja ca macʉ̃ cʉti jʉorã, Ʉmʉreco Pacʉ yaarã niirucuma,” ĩi owaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","To biri ñucã, Ʉpʉ cʉ̃ ca dotirique ca ĩirore biro waibʉcʉ jĩari, tiicojo nʉcʉ̃ bʉorã waaupa: “Jĩcã bapa weje bua, tiirʉgatirã, bua ʉmʉa ʉno mena tiirique niirucu,” cʉ̃ ca ĩiricarore biro. ");
INSERT INTO baoNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","To biro ca bii niiri cuure niiupi Jerusalén're, jĩcʉ̃ ʉmʉ Simeón ca wãme cʉtigʉ, ca añugʉ, Ʉmʉreco Pacʉre ca ĩi nʉcʉ̃ bʉogʉ, Israel yepare ñañaro ca tiirãre ca ametʉenepʉre ca yue niirucugʉ. Cʉ̃ mena niiupi Añuri Yeri. ");
INSERT INTO baoNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","To biri, “Ʉmʉreco Pacʉ cʉ̃ ca tiicojogʉ Mesías're ĩatigʉra mʉ bii yaitirucu,” cʉ̃re ĩi wede majio jʉgueupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Añuri Yeri cʉ̃re cʉ̃ ca ami waaro macã, Ʉmʉreco Pacʉ yaa wiipʉ waaupi Simeón. Wimagʉ Jesús pacʉa, doti cũurique ca ĩirore biro tiirã waarã cʉ̃re cʉ̃ja ca ami waari tabere, ");
INSERT INTO baoNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón pea cʉ̃re ami pʉja, Ʉmʉreco Pacʉre o biro ĩi baja peo nʉcʉ̃ bʉoupi: ");
INSERT INTO baoNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ʉpʉ, mecʉ̃ra “To biro yʉ tiirucu,” yʉre mʉ ca ĩiricarore birora mʉ tii: Mʉre pade coteri majʉre añuro cʉ̃ ca bii yairo mʉ tii maji yua. ");
INSERT INTO baoNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bojocare ca ametʉenepʉ mʉ ca tiicojogʉre mee yʉ ĩa yerijãa, ");
INSERT INTO baoNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Bojoca niipetirã cʉ̃ja ca ĩa cojoro mʉ ca tii ĩño jʉo waarijere, ");
INSERT INTO baoNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bojoca poogaari, Ʉmʉreco Pacʉ yee díámacʉ̃ ca niirijere cʉ̃ja ca majiro tii, Mʉ yaa pooga Israel macãrãre ca nii majuropeera cʉ̃ja ca niiro tii, ca tiipʉre —ĩiupi Simeón. ");
INSERT INTO baoNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Cʉ̃ pacʉa pea to biirije wimagʉre Simeón cʉ̃ ca ĩirijere tʉo ʉcʉacoa, do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","To cõrora Simeón, “Añuro mʉjare to biijato,” cʉ̃jare ĩi, o biro ĩiupi ñucã Jesús paco María peera: —Ani wimagʉ, paʉ Israel macãrã ñañaro tamʉo, ametʉa, cʉ̃ja ca biro tii, ñucã bʉaro cʉ̃re ĩa juna, cʉ̃ja ca biiro tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","O biro cʉ̃ja ca biiro, paʉ, cʉ̃ja yeripʉ cʉ̃ja ca tʉgoeña niirijere ca bii bau niipere biro ĩigʉ. Mʉ peera, ate niipetirije mʉ yerire niipĩi mena jade ame wioricarore biro puniro mʉ ca tʉgoeñape niirucu —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ñucã, Ana ca wãme cʉtigo, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majo, Fanuel macõ, Aser niiquĩricʉ yaa puna macõ cãa, toora niiupo. Mee bʉcʉo peti niiupo. Wãmoacã niigopʉ manʉ cʉti, jĩcã amo peti, ape amore pʉaga penituaro niiri cʉ̃marira cõ manʉ mena cõ ca nii tʉja waarora, cõre cʉ̃ ca bii yai weorico niiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Cõ manʉ cʉ̃ ca bii yai weoricaro jirore, ochenta y cuatro cʉ̃mari peti nii tʉja waaupo. Cõ pea Ʉmʉreco Pacʉ yaa wiipʉre witiri méé, ñamiri, ʉmʉrecori, baarique betirique mena Ʉmʉreco Pacʉre jãi juu bue, tii nʉcʉ̃ bʉocõa niirucuupo. ");
INSERT INTO baoNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana cãa, Simeón to biro cʉ̃ ca ĩi niiri tabera ea, Ʉmʉreco Pacʉre: “Añu majuropeecã,” ĩi ʉjea nii, Jerusalén're ca ametʉenepʉre ca yue niirucurã niipetirãre wedeupo, wimagʉ Jesús yee maquẽre. ");
INSERT INTO baoNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ʉmʉreco Pacʉ dotirique ca dotirore biro tii yapanori jiro, Galilea yepa cʉ̃ja yaa macã majurope Nazaret'pʉ tuacoaupa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Wimagʉ pea añuro tutua añugʉ bʉcʉa, bʉaro ca majigʉ, Ʉmʉreco Pacʉ añuro cʉ̃re cʉ̃ ca tiirije mena bii nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús pacʉa to cãnacã cʉ̃mara Jerusalén macãpʉ Pascua boje rʉmʉ ĩarã waarucuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesús, pʉa amo peti, dʉpore pʉaga penituaro ca niiri cʉ̃mari ca cʉogʉ cʉ̃ ca niiro, cʉ̃ja niipetirã tii boje rʉmʉre cʉ̃ja ca waarucuricarore birora waaupa ñucã Jerusalén'pʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tii boje rʉmʉ ca petiro, cʉ̃ja yaa wiipʉ cʉ̃ja ca tua waaro, Jesús pea cʉ̃ pacʉa cʉ̃ja ca majitirora, Jerusalén'pʉra tuacãupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Cʉ̃ja pea, “Aperã mena doocumi” ĩi tʉgoeñari, jĩcã rʉmʉ waaupa. Jiro cʉ̃ja yee wederã, cʉ̃ja ca majirã watoa cʉ̃re amañami, ");
INSERT INTO baoNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","cʉ̃re bʉati, Jerusalén'pʉra cʉ̃re amarã tuacoaupa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Itia rʉmʉ jiropʉ Ʉmʉreco Pacʉ yaa wiipʉ doti cũuriquere ca jʉo bueri maja watoapʉ cʉ̃ja ca wederijere tʉo, cʉ̃ cãa cʉ̃jare jãiña, ca tii duwigʉre cʉ̃re bʉaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Cʉ̃ ca ĩirijere ca tʉorã niipetirã, cʉ̃ ca majirijere, cʉ̃jare cʉ̃ ca yʉʉ majirijere tʉorã, tʉo ʉcʉacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Toopʉ cʉ̃ja mena cʉ̃ ca ĩi duwiro ĩarã, cʉ̃ pacʉa pea ĩa ʉcʉacoari, cʉ̃ paco pea o biro cʉ̃re ĩiupo: —Macʉ̃, ¿ñee tiigʉ to biirije jãare mʉ bii tua nʉcã weoquĩjãri? Mʉ pacʉ, yʉ, bʉaro tʉgoeña pairique mena mʉre jãa ama yujujãwʉ —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","To biro cõ ca ĩiro o biro ĩi yʉʉupi Jesús: —¿Ñee tiirã yʉre mʉja amajãri? ¿Yʉ Pacʉ yeere ca tiipʉ niiri yʉ ca biirijere mʉja majitijãri? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","To biro cʉ̃jare cʉ̃ ca ĩirijere tʉo majitiupa cʉ̃ja pea. ");
INSERT INTO baoNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","To biri cʉ̃ pacʉa mena Nazaret'pʉ tua waa, niipetirije cʉ̃ja ca ĩirore biro tiicã niirucuupi. Cʉ̃ paco pea ate niipetirijere cõ yeripʉ tʉgoeñacã niirucuupo. ");
INSERT INTO baoNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús cʉ̃ ca bʉcʉa nʉnʉa waaro cõrora, cʉ̃ ca majirije cãa bʉcʉa nʉnʉa waaupa. To biri Ʉmʉreco Pacʉ menare, bojoca mena cãare, añuro bii ʉjea nii, bii bʉcʉa nʉnʉa waaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Tiberio quince cʉ̃mari wiogʉ cʉ̃ ca nii nʉnʉa waari cʉ̃mare, Poncio Pilato Judea yepa wiogʉ niiupi. Herodes pea Galilea yepa wiogʉ niiupi. Cʉ̃ bai Felipe pea, Iturea, to biri Traconite yepari wiogʉ niiupi. Ñucã Lisanias pea Abilinia yepa wiogʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Cʉ̃ja wiorã cʉ̃ja ca niiri tabere Anás, to biri Caifás paia wiorã niiupa. To biro cʉ̃ja ca bii niiri cʉ̃marire, ca yucʉ maniri yepapʉ ca niigʉ, Zacarías macʉ̃ Juan're wedeupi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Cʉ̃re cʉ̃ ca wedero jiro, Juan pea dia Jordán pʉto macã yepa niipetiropʉre waari: —Ñañarije mʉja ca tiirijere tʉgoeña yeri wajoari, uwo coe doti tiiya, Ʉmʉreco Pacʉ ñañarije mʉja ca tiiriquere cʉ̃ acobojato ĩirã —cʉ̃jare ĩi wede yujuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Atea, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías o biro cʉ̃ ca ĩi owaquĩricarore birora biiupa: “Ca yucʉ maniri yepapʉre jĩcʉ̃, o biro ĩi acaro bui wedemi: ‘Añuro tʉgoeñarique mena Wiogʉre yueya,’ Wiogʉ cʉ̃ ca eaparo jʉguerore, cʉ̃ ca doopa maare díámacʉ̃ maa cʉ̃ja ca queno yuerore birora, mʉja cãa, mʉja yerire añuro cʉ̃re queno yueya. ");
INSERT INTO baoNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Upa coraari bʉcʉ ca nii ñaajãa duwi waarije cõrorena, jita mena maa jãa dado queno peoticãrique niirucu. Ʉ̃tã yucʉ, ca emʉari buurori ca niirije cõrorena, coa queno cũu peoticãrique niirucu. Upa beto maari ca niirijera, díámacʉ̃ maari queno cojorique niirucu. Docuori maari ca niirijera, añuri maari quenorique niirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Bojoca ñañarije cʉ̃ja ca tiirijere Ʉmʉreco Pacʉ cʉ̃ ca ametʉenerijere bojoca niipetirã ĩarucuma,” ĩi owaquĩupi Isaías. ");
INSERT INTO baoNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Paʉ bojoca cʉ̃re ca uwo coe dotirã earãre, o biro cʉ̃jare ĩiupi Juan: —Añaa punaa ¿“Ñiru, Ʉmʉreco Pacʉ ñañaro cʉ̃ ca tiipe ca cõña doorijere mʉja duti majicãrucu,” mʉjare cʉ̃ ĩijãri? ");
INSERT INTO baoNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Díámacʉ̃ra ñañarije mʉja ca tiirucurijere tii yerijãa tʉgoeña yeri wajoari, Ʉmʉreco Pacʉ peere mʉja ca tʉo nʉnʉjeerijere ĩñorã, ĩa majiricarora añuro niirique cʉti ĩño niiña. Mʉja majuropeera: “Jãa, Abraham pãramerã jãa nii,” ĩi tʉgoeñaticãña. Ʉmʉreco Pacʉa, ate ʉ̃tãgaarirena Abraham pãramerã cʉ̃ja ca niiro tii jeeñocã majimi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Mee comea, yucʉgʉʉrire ca queti paga, tee nʉcõripʉre paa pua tuuricaga tuja yerijãa. Yucʉ añurije ca dica cʉtitiri yucʉ cõrorena quetiri, pecamepʉ paa jude joerique niirucu —cʉ̃jare ĩi wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","To biro cʉ̃ ca ĩiro tʉorã, o biro cʉ̃re ĩi jãiñaupa: —¿To docare ñee jãa tiigajati? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro: —Pʉaro jutiro ca cʉogʉ, ca cʉotigʉre jĩcãro tiicojoya. Baarique ca cʉorã cãa, ca cʉotirãre ecaya —cʉ̃jare ĩi yʉʉupi Juan. ");
INSERT INTO baoNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Jĩcãrã Roma maquẽre wapa jee bojari maja cãa, uwo coe dotirã earã, o biro ĩi jãiñaupa Juan're: —Buegʉ, jãa pea ¿ñee jãa tiigajati? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro: —Mʉjare cʉ̃ja ca wapa jãi dotiricaro ametʉeneropʉ wapa jãiticãña —cʉ̃jare ĩi yʉʉupi Juan. ");
INSERT INTO baoNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ñucã jĩcãrã uwamarã cãa: —Jãa pea, ¿ñee jãa tiigajati? —cʉ̃re ĩi jãiñaupa. To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro: —Jĩcʉ̃ ʉno peerena ĩi uwiori, cʉ̃ja ca cʉorijere jĩcã wãme ʉno peerena cʉ̃jare ẽma, cʉ̃ja ca tiitiriquerena wedejãa, tiiticãña. Mʉja ca wapa taaro cõrora cʉoya —cʉ̃jare ĩi yʉʉupi Juan. ");
INSERT INTO baoNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bojoca pea, “Do biirije peti to ca biicãro,” ĩi yue niirã, niipetirãpʉra cʉ̃ja majurope: “¿‘Juan, Mesías doorucumi,’ cʉ̃ja ca ĩiquĩricʉra cʉ̃ niicã tiimiti?” ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","To biro cʉ̃ja ca ĩiro, Juan pea niipetirãre o biro ĩiupi: —Yʉa oco mena mʉjare yʉ uwo coe. Ména, doorucumi jĩcʉ̃, yʉ ametʉenero niipetirijepʉre ca doti tutua majuropeegʉ. Yʉa, cʉ̃ dʉpo jutire jiarica daari cãare ca popio cotepʉ méé yʉ nii. Cʉ̃a, Añuri Yeri mʉjapʉre cʉ̃ ca ñaajãa nʉcã earo tiiri, ñañarije manirã mʉja ca tuaro tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Trigo quejerire cʉ̃ ca maa mʉene batepa tabere ami doomi, ca quejerire jee dica woo, ca ape peera teere queno cũurica tabepʉ queno cũu, tiirʉgʉ. Tee quejeri peera pecame ca ʉ̃ʉ yatitiri pecamepʉ joe batecãrucumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ate mena, ñucã apeye paʉ wãmeri mena cʉ̃jare wede majiori, añurije quetire bojocare wedeupi Juan. ");
INSERT INTO baoNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Apeyera ñucã, Herodes're cʉ̃ yee wedegʉ Felipe nʉmo Herodías're cʉ̃ ca nʉmo cʉtirije jʉori, ñucã apeye niipetirije ñañarije cʉ̃ ca tiirique jʉori, cʉ̃re tuti bojoca catiomiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Herodes pea niipetirije ñañarije cʉ̃ ca tii niirije watoara, Juan're cʉ̃re tia cũu nemocãupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jĩcã rʉmʉ bojoca niipetirã Juan're cʉ̃ja ca uwo coe doti niiri tabere Jesús cãa, cʉ̃re uwo coe ecoupi. Uwo coe eco yapano, cʉ̃ ca juu bue niiri tabera ʉmʉreco quejero ca pãa nʉcãro, ");
INSERT INTO baoNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Añuri Yeri pea buare biigʉ bau duwi doo, bii ñaapea eaupi Jesús'pʉre. To biro cʉ̃ ca biiri tabera, ʉmʉreco tutipʉ: —Mʉ mʉ nii yʉ Macʉ̃, yʉ ca maigʉ; mʉ mena bʉaro yʉ ʉjea nii —ĩi wedeoupe. ");
INSERT INTO baoNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús, treinta cʉ̃mari cʉogʉ, cʉ̃ paderiquere tii jʉoupi. Cʉ̃ja ca ĩirucuropʉra niijata, Jesús, José macʉ̃ niiupi. José, Elí macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí pea, Matat macʉ̃ niiupi. Matat pea Leví macʉ̃ niiupi. Leví pea Melqui macʉ̃ niiupi. Melqui pea Jana macʉ̃ niiupi. Jana pea José macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José pea Matatías macʉ̃ niiupi. Matatías pea Amós macʉ̃ niiupi. Amós pea Nahúm macʉ̃ niiupi. Nahúm pea Esli macʉ̃ niiupi. Esli pea Nagai macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai pea Máat macʉ̃ niiupi. Máat pea Matatías macʉ̃ niiupi. Matatías pea Semei macʉ̃ niiupi. Semei pea Josec macʉ̃ niiupi. Josec pea Judá macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá pea Joanán macʉ̃ niiupi. Joanán pea Resa macʉ̃ niiupi. Resa pea Zorobabel macʉ̃ niiupi. Zorobabel pea Salatiel macʉ̃ niiupi. Salatiel pea Neri macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri pea Melqui macʉ̃ niiupi. Melqui pea Adi macʉ̃ niiupi. Adi pea Cosam macʉ̃ niiupi. Cosam pea Elmadam macʉ̃ niiupi. Elmadam pea Er macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er pea Josué macʉ̃ niiupi. Josué pea Eliezer macʉ̃ niiupi. Eliezer pea Jorim macʉ̃ niiupi. Jorim pea Matat macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat pea Leví macʉ̃ niiupi. Leví pea Simeón macʉ̃ niiupi. Simeón pea Judá macʉ̃ niiupi. Judá pea José macʉ̃ niiupi. José pea Jonán macʉ̃ niiupi. Jonán pea Eliaquín macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquín pea Melea macʉ̃ niiupi. Melea pea Mainán macʉ̃ niiupi. Mainán pea Matata macʉ̃ niiupi. Matata pea Natán macʉ̃ niiupi. Natán pea David macʉ̃ niiupi. David pea Isaí macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Isaí pea Obed macʉ̃ niiupi. Obed pea Booz macʉ̃ niiupi. Booz pea Salmón macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Salmón pea Naasón macʉ̃ niiupi. Naasón pea Aminadab macʉ̃ niiupi. Aminadab pea Aram macʉ̃ niiupi. Aram pea Esrom macʉ̃ niiupi. Esrom pea Fares macʉ̃ niiupi. Fares pea Judá macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá pea Jacob macʉ̃ niiupi. Jacob pea Isaac macʉ̃ niiupi. Isaac pea Abraham macʉ̃ niiupi. Abraham pea Taré macʉ̃ niiupi. Taré pea Nacor macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor pea Serug macʉ̃ niiupi. Serug pea Ragau macʉ̃ niiupi. Ragau pea Peleg macʉ̃ niiupi. Peleg pea Heber macʉ̃ niiupi. Heber pea Sala macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala pea Cainán macʉ̃ niiupi. Cainán pea Arfaxad macʉ̃ niiupi. Arfaxad pea Sem macʉ̃ niiupi. Sem pea Noé macʉ̃ niiupi. Noé pea Lamec macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec pea Matusalén macʉ̃ niiupi. Matusalén pea Enoc macʉ̃ niiupi. Enoc pea Jared macʉ̃ niiupi. Jared pea Mahalaleel macʉ̃ niiupi. Mahalaleel pea Cainán macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán pea Enós macʉ̃ niiupi. Enós pea Set macʉ̃ niiupi. Set pea Adán macʉ̃ niiupi. Adán pea, Ʉmʉreco Pacʉ macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús pea Añuri Yeripʉ cʉ̃re cʉ̃ ca doti niirije mena niicãri, dia Jordán'pʉ ca niiricʉ cʉ̃ ca tua maa waaro, Añuri Yeri pea ca yucʉ maniri yepapʉ cʉ̃re amicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Toopʉre cuarenta rʉmʉri peti niiupi. Satanás pea ñañarijere cʉ̃ ca tiiro cʉ̃re tiirʉgamiupi. To biro cʉ̃ ca biiri rʉmʉrire baari méé biima ĩigʉ, bʉaro queya tʉgoeñaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","To biro cʉ̃ ca biiro, Satanás pea o biro cʉ̃re ĩiupi: —Díámacʉ̃ra Ʉmʉreco Pacʉ Macʉ̃ra mʉ ca niijata, “ ‘Atiga ʉ̃tãgare pan jeeñaña,’ ĩiña” —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","To biro cʉ̃re cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —Ʉmʉreco Pacʉ wederique o biro ĩi: “Bojocʉa, baarique mena wado cati niitimi. Niipetiro Ʉmʉreco Pacʉ wederique mena cãare caticã majimi,” ĩi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jiro Satanás macãnʉcʉ̃ ca emʉari buuro jotoapʉ cʉ̃re jʉo waari, jĩcã nimarora ati yepa macã yepari niipetirore cʉ̃re ĩño peticã cojori, ");
INSERT INTO baoNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","o biro ĩiupi Jesús're: —Ati yepari niipetirijere, tii yepari maquẽ ca nii majuropeerijere, mʉ ca doti maji tutua niipere mʉre yʉ tiicojorucu. Ate niipetirije yʉ ñeewʉ. Noo yʉ ca tiicojorʉgagʉre yʉ tiicojorucu. ");
INSERT INTO baoNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ate niipetirijepʉra mʉ yee wado niirucu, mʉ ãjʉro jupeari mena tuetuu ea nuuri yʉre mʉ ca ĩi nʉcʉ̃ bʉojata —cʉ̃re ĩiupi Satanás. ");
INSERT INTO baoNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","To biro cʉ̃ ca ĩiro Jesús pea o biro cʉ̃re ĩi yʉʉupi: —“Ʉmʉreco Pacʉ wederique o biro ĩi: Ʉpʉ mʉ Ʉmʉreco Pacʉ wadore ĩi nʉcʉ̃ bʉoya. Cʉ̃ jĩcʉ̃rena cʉ̃ ca dotirore biro tii nʉnʉjeeya,” ĩi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jiro Satanás, Jesús're Jerusalén macãpʉ ami waa, Ʉmʉreco Pacʉ yaa wii jotoa ca emʉari tabepʉ ami mʉa waari, o biro cʉ̃re ĩiupi: —Díámacʉ̃ra, Ʉmʉreco Pacʉ Macʉ̃ra mʉ ca niijata, anopʉ menara bupu duwi waagʉja. ");
INSERT INTO baoNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ʉmʉreco Pacʉ wederique o biro ĩi: “Ʉmʉreco Pacʉ, cʉ̃re queti wede bojari majare, mʉre cʉ̃ja ĩa nʉnʉjeejato ĩigʉ, mʉ pʉto cʉ̃jare tiicojorucumi, ");
INSERT INTO baoNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","cʉ̃ja, cʉ̃ja amori mena mʉre boca tuu ñeerucuma, jĩcãga ʉ̃tãga ʉno peerena mʉ ca pʉa taatipere biro ĩirã,” ĩi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","To biro cʉ̃ ca ĩiro o biro cʉ̃re ĩi yʉʉupi Jesús: —O biro ĩi ñucã Ʉmʉreco Pacʉ wederique: “Ʉpʉ, mʉ Ʉmʉreco Pacʉre, ‘To biro cʉ̃re mani ĩi ñaaco’ ĩi epeticãña,” ĩi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","To biro cʉ̃ ca ĩiro Satanás pea, ape wãme Jesús're, ñañaro cʉ̃ ca tiiro cʉ̃ ca tii doti ñaape bʉatima ĩigʉ, jĩcã cuu cʉ̃re waa weocoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Tee jiro Jesús, Añuri Yeri cʉ̃ ca doti tutua niirijepʉre yeri jãñacãri, Galilea pee tuacoaupi. Jesús cʉ̃ ca bii niirijere tii yepa niipetiropʉ wede bato peticã cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","To cãnacã taberipʉrena nea poo juu buerica wiijeripʉ cʉ̃jare buerucuupi Jesús. To biro cʉ̃ ca ĩirijere tʉorã, niipetirã añuro cʉ̃re ĩi nʉcʉ̃ bʉorucuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jiro Jesús, cʉ̃ ca bʉcʉarica macã Nazaret'pʉ waaupi. Jĩcã rʉmʉ yerijãarica rʉmʉ ca niiro, cʉ̃ ca biirucuricarore biro cʉ̃ja ca nea poo juu bueri wiipʉ jãa waa, Ʉmʉreco Pacʉ wederiquere buerʉgʉ ea nʉcã waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","To biro cʉ̃ ca biiro, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías cʉ̃ ca owarica pũurore cʉ̃re bue dotiupa. To biro cʉ̃ja ca tiiro Jesús pea tii pũurore pãagʉ, o biro cʉ̃ ca ĩi owa tuurica tabere bʉaupi: ");
INSERT INTO baoNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ʉmʉreco Pacʉ yʉʉ Añuri Yeri yʉpʉre niimi, ca boo pacarãre añurije quetire ca wedepʉ yʉre cʉ̃ ca ami dica wooro macã. Tia cũuricarã ca niirã, ‘Tia cũuricarã cʉ̃ja ca niirijere wiene ecorucuma,’ yʉre ĩi wede doti cojomi. Ca ĩatirãre cʉ̃ja ĩaro yʉre tii dotimi. Aperã ñañaro cʉ̃ja ca doti eperãre, ametʉene dotigʉ yʉre tiicojomi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ʉmʉreco Pacʉ bojocare añuro cʉ̃ ca tii bojapa tabe ea yerijãa, yʉre ĩi wede doti cojomi,” cʉ̃ ca ĩi owariquere bueupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Bue yapano, tii pũurore bʉato, tii wii ca pade nemogʉre tiicojo, ea nuucoaupi ñucã. To biro cʉ̃ ca biiro to ca niirã niipetirã cʉ̃ pee wadore ĩa cojocã niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Cʉ̃ pea o biro cʉ̃jare ĩi wede jʉoupi: —Mecʉ̃ra, Isaías cʉ̃ ca owariquere yʉ ca buero mʉja ca tʉorije ca ĩirore birora bii ea —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Niipetirã Jesús yee maquẽre añuro ameri wede, ñucã añurije peti cʉ̃ ca ĩirijere tʉori, do biro pee ĩi majiticã, o biro ameri ĩi jãiñarucuupa: —¿Ania José macʉ̃ méé cʉ̃ niiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","To biro cʉ̃ja ca ĩiro Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Mʉja, o biri wãme yʉre mʉja ĩicu: “Ʉco tiiri majʉ, mʉ majuropeera mʉ ca diarique cʉtirijere ametʉeneña,” mʉja ĩicu. O biro mʉja ĩicu ñucã: “Ano mʉ yaa yepa cãare, Capernaúm'pʉ niigʉ mʉ ca tiirijere jãa ca tʉoriquere tiiya,” yʉre mʉja ĩicu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","To biro ĩicã, o biro cʉ̃jare ĩi nʉnʉa waaupi ñucã: —Yee méé mʉjare yʉ ĩi, jĩcʉ̃ ʉno peera Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ cʉ̃ yaa yepa macãrã petira ĩi nʉcʉ̃ bʉo ecotimi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yee méé yʉ ĩi. Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Elías cʉ̃ ca niiri cuure, itia cʉ̃ma decomacã peti oco peati, tii yepa niipetiropʉrena aʉa boarique nii, ca biiri tabere, ca manʉ jʉ̃mʉa bii yai weo ecoricarã romiri paʉ niiupa Israel're. ");
INSERT INTO baoNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","To biro cʉ̃ja ca biicã pacaro, Elías peera, israelitas romiri ca manʉ jʉ̃mʉa bii yai weo ecoricarã romirire jĩcõ ʉno peerena tii nemo doti cojotiupi. Sidón macã pʉto macã macã Sarepta macõ pee wadore tii nemo doti cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ñucã Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Eliseo cʉ̃ ca niiri cuu cãare, Israel'pʉre paʉ cami boarique ca diarique cʉtirã niiupa. To biro cʉ̃ja ca biimijata cãare, jĩcʉ̃ ʉno peera cʉ̃ja diariquere ametʉene ecotiupa. Siria macʉ̃pʉ Naamán wado cʉ̃ diariquere ametʉene ecoupi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","To biro cʉ̃ ca ĩirijere tʉorã, nea poorica wiipʉ ca niirã niipetirãpʉra bʉaro ajiaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","To biri niipetirã wãmʉ nʉcã, Jesús're macã tʉjaropʉ cʉ̃re amicã witi waaupa, tii macã weja macã tʉdipʉ cʉ̃re tumicõa cõa jãa cojorʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","To biro cʉ̃re cʉ̃ja ca tii pacaro, Jesús pea cʉ̃ja watoara ametʉa waacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús pea Galilea macã macã Capernaúm'pʉ waacoaupi. Toopʉ bojocare, yerijãarica rʉmʉri ca niiro cʉ̃jare buerucuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Doti maji majuropeerique mena cʉ̃ ca buerijere tʉorã, bojoca pea do biro pee ĩi majiticãrucuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nea poo juu buerica wiipʉre niiupi jĩcʉ̃, ca wãtĩ jãa ecoricʉ. To biri tutuaro mena o biro ĩi acaro buiupi: ");
INSERT INTO baoNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—¡Jesús, Nazaret macʉ̃! To birora jãare ĩacãña. ¿Ñee tiigʉ jãare mʉ pato wãcõgʉ dooti? ¿Jãare tii yaio bategʉ doogʉ mʉ biijãri? Yʉa mʉre yʉ maji. Mʉa, Ʉmʉreco Pacʉ yʉʉ Ca Ñañarije Manigʉ mʉ nii —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","To biro cʉ̃re cʉ̃ ca ĩirora, Jesús pea wãtĩre o biro cʉ̃re ĩi cõa wieneupi: —¡Wedeticãña! To cõrora cʉ̃re camotatiya —ĩiupi. To biro cʉ̃re cʉ̃ ca ĩirije menara, wãtĩ pea niipetirã cʉ̃ja ca ĩa cojoro, cʉ̃re ñañoricaro maniro yepapʉ cʉ̃re tii cõa cũucã ũmaa witi waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","To biro cʉ̃ ca tiirijere, niipetirã ĩa ʉcʉacoa, o biro ameri ĩiupa cʉ̃ja majurope: —¿Ñee ʉno wederique to niiti nija atea? Doti maji tutuarique mena wãtĩare “Witi waarãja,” cʉ̃ ca ĩirora, cʉ̃ja pea to cõrora witicoarucuma —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","To biri Jesús cʉ̃ ca tii niirije pea tii yepa niipetiropʉre jeja nʉcã peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús, nea poo juu buerica wiipʉ ca niiricʉ witi waagʉ, Simón Pedro yaa wiipʉ waaupi. Cʉ̃ mañicõ pea bʉaro wiorique diaupo. To biro cõ ca biiro, Jesús're: “Cõre catioya,” cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","To biro cʉ̃re cʉ̃ja ca ĩiro, Jesús pea cõ jotoa pee muu bia ea nʉcã, wioriquere “¡Yerijãa waaroja!” cʉ̃ ca ĩirora, yerijãacoaupa. To cõrora cõ pea wãmʉ nʉcã, cʉ̃jare baarique eca jʉo waaupo. ");
INSERT INTO baoNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Muipũ cʉ̃ ca ñaajãa waari tabe ca niiro, bojorica wãmeri ca diarique cʉtirãre ca cʉo niiricarã niipetirã Jesús pʉto cʉ̃jare jee waaupa. Cʉ̃ pea, cʉ̃ja ca niiro cõrorena cʉ̃ amori mena cʉ̃jare ñia peori, cʉ̃jare diarique ametʉeneupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ñucã paʉ ca diari majapʉre ca niiricarã wãtĩa cãa: —¡Mʉa, Ʉmʉreco Pacʉ Macʉ̃ mʉ nii! —ĩi acaro bui, witicoarucuupa. To biro cʉ̃ja ca ĩiro Jesús pea wãtĩare tuti, cʉ̃jare wede dotiticãupi, Mesías cʉ̃ ca niirijere cʉ̃ja ca majiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ape rʉmʉ ca boe mʉa doorije mena, macã tʉjaro bojoca cʉ̃ja ca maniropʉ waagʉ witi, waacoaupi Jesús. To biro cʉ̃ ca biiro bojoca pea, cʉ̃re ama, cʉ̃ ca niiri tabepʉ earã, aperopʉ cʉ̃ ca waaro bootirã, cʉ̃re tuenerʉgamiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","To biro cʉ̃ja ca tiirʉgamijata cãare, o biro cʉ̃jare ĩiupi Jesús: —Ape macãri macãrã cãare, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ añurije quetire yʉ ca wedepe niiro bii. Aterena ĩigʉ, cʉ̃ ca tiicojoricʉ yʉ nii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","To biri Jesús, judíos cʉ̃ja ca niiri macãripʉre, cʉ̃ja ca nea poo juu bueri wiijeripʉ añurije quetire cʉ̃jare bue yujurucuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Jĩcã rʉmʉ Jesús, Genesaret ʉtabʉcʉra tʉjaropʉ cʉ̃ ca niiro, Ʉmʉreco Pacʉ yee quetire cʉ̃ ca wedero ca tʉorʉgarã paʉ bojoca do biro tii majiña maniro, ʉta bijaroacã ameri tuutu nea poo nʉnʉa dooupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","To biro cʉ̃ja ca bii nea poo dooro, Jesús pea cũmua pʉaga, wai jĩari maja cʉ̃ja bapi yucʉre coerã waarã jita dupari yepapʉ cʉ̃ja ca maa weoricagaarire ĩa bʉaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Tiigaarire, jĩcãga, Simón yaa cũmuare ea jãa, õo jañuroacã juu wiyo dotiupi. Jiro tii cũmuapʉ ea nuu waari, toopʉ menara bojocare Ʉmʉreco Pacʉ yee quetire cʉ̃jare bueupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Cʉ̃jare bue yapano, o biro ĩiupi Simón're: —Wai ñeerʉgarã, atira ca ʉ̃cʉ̃ari tabe pee cũmua mena wia waari, toopʉ mʉja bapi yucʉre cõañuaña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","To biro cʉ̃ ca ĩirora Simón pea o biro cʉ̃re ĩi yʉʉupi Jesús're: —Buegʉ, meepʉ macã ñamire jãa waja boecoamijãwʉ mee. Jĩcʉ̃ ʉnora jĩarucu, jãa tiitijãwʉ. Mʉ, yʉre mʉ ca dotiro macã mʉ ca dotirore biro yʉ tiirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","To biro tiirã, paʉ cʉ̃ja bapi yucʉ yegaboropʉ wai waja bʉaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","To biro cʉ̃ja ca biiro, cʉ̃ja mena macãrã ape cũmuapʉ ca niirãre, “Jãare wai jee nemorã dooya” ĩirã, cʉ̃jare bʉa jʉo cojoupa. To biro cʉ̃ja ca tiiro ea, waire cʉ̃jare jee nemorã, pʉagapʉrena cũmu duucãboupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","To biro ca biiro ĩagʉ Simón Pedro pea, Jesús pʉto cʉ̃ ãjʉro jupeari mena tuetuu ea nuu waari, o biro cʉ̃re ĩiupi: —Wiogʉ, yʉre camotati waagʉja. Ñañarije ca tiigʉ yʉ nii yʉa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Atere to biro ĩiupi, Simón, to biri cʉ̃ mena macãrã cãa, to cõro pairo cʉ̃ja ca wai jĩarijere cʉ̃ja ca ĩa ʉcʉacoarije ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ñucã Zebedeo puna Santiago, Juan, Simón mena macãrã cãa to birora biiupa. To biro cʉ̃ja ca biiro, Jesús pea o biro ĩiupi Simón're: —Uwiticãña. Mʉa mecʉ̃ mena, waire mʉ ca waja majirore birora mʉ tiirucu bojoca cãare —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","To cõrora cʉ̃ja cũmuarire waa pãa waa, wee moene cũu, cʉ̃ja yee niipetirore cũu peticã, waacoaupa Jesús mena. ");
INSERT INTO baoNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jĩcã rʉmʉ Jesús jĩcã macãpʉ cʉ̃ ca niiro, jĩcʉ̃ ca cami boa diarique cʉtigʉ cʉ̃ pʉto eaupi. Jesús're ĩagʉra, yepapʉ muu bia cũmu waa, o biro cʉ̃re ĩi jãiupi: —Wiogʉ, mʉ ca boojata, yʉ ca diarique cʉtirijere yʉre ametʉeneña —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","To biro cʉ̃ ca ĩiro Jesús pea, cʉ̃ amo mena cʉ̃re ñia peo, o biro cʉ̃re ĩiupi: —Yʉ boo, diarique manigʉ tuaya —ĩiupi. To biro cʉ̃re cʉ̃ ca ĩirora, cʉ̃ ca cami boa diarique cʉtimirique jĩcãto peticoaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Cʉ̃re catio yapano: —Jĩcʉ̃ ʉno peerena wedeticãña. Pai pʉtopʉ wado waari, mʉre ca cami yatiriquere ĩñoña. Ñucã diarique manigʉ mʉ ca tuarije jʉori, Moisés cʉ̃ ca tii dotiriquere, mʉ ca tiicojo nʉcʉ̃ bʉope jee waagʉja, mee mʉ ca diarique manirijere paia cʉ̃ja ca majipere biro ĩigʉ —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","To biro cʉ̃ ca ĩicã pacaro, Jesús cʉ̃ ca tii niirije pea, bʉaro jañuro queti jeja nʉcã waaupe. To biri, cʉ̃ ca wederijere tʉo, cʉ̃ja ca diarique cʉtirijere ametʉene doti, tiirʉgarã paʉ nearucuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","To biro cʉ̃ja ca bii pacaro, Jesús pea ca bojoca maniri taberi pee waari, juu buegʉ waacoarucuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Jĩcã rʉmʉ, Jesús bojocare cʉ̃ ca bue niiro, jĩcãrã fariseos, Moisés cʉ̃ ca doti cũuriquere ca jʉo buerã, niipetirije Galilea yepa, Judea yepa, macã macãri macãrã, to biri Jerusalén macãrã ca dooricarã too duwi cojoupa. Ʉmʉreco Pacʉ cʉ̃ ca tutuarije pea Jesús mena ca diarique cʉtirãre cʉ̃ ca catiorije mena bii ĩño niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Too cʉ̃jare cʉ̃ ca bue niiro, jĩcãrã ca bʉʉricʉre, pũugʉ quejero mena cʉ̃re ca yoo dooricarã cʉ̃re ami eaupa. To earã, wiipʉ ami jãa waa, Jesús jʉguero cʉ̃re cũurʉgamiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Paʉ bojoca cʉ̃ja ca niiro macã, do biro tii, cʉ̃re ami jãa waa majitiupa. To biri wii jotoa pee mʉa waa, jĩcã jope jee woo tiicãri, paʉ bojoca watoara, cʉ̃ ca yojaricaro menara, Jesús cʉ̃ ca niiri tabe díámacʉ̃ cʉ̃re yoo duwio cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesús pea, “Jesús cʉ̃re catiocãrucumi,” cʉ̃ja ca ĩi tʉgoeña bayirijere ĩari, o biro ĩiupi ca bʉʉricʉre: —Yʉ mena macʉ̃, ñañarije mʉ ca tiiriquere yʉ acobocã —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","To biro cʉ̃ ca ĩirora, Moisés cʉ̃ ca doti cũuriquere ca jʉo buerã, to biri fariseos: “¿Ania ñiru ʉno cʉ̃ niiti, Ʉmʉreco Pacʉre ñañarije ca ĩi tutigʉa? Bojocʉ jĩcʉ̃ ʉno peera ñañarije tiiriquere acobo majitimi; Ʉmʉreco Pacʉ wado niimi ñañarije tiiriquere ca acobo majigʉ,” ĩi tʉgoeñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesús pea to biro cʉ̃ja ca ĩi tʉgoeñarijere majiri, o biro cʉ̃jare ĩi jãiñaupi: —¿Ñee tiirã to biirije mʉja tʉgoeñati? ");
INSERT INTO baoNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Di wãme pee to niiti popiye méé ĩirica wãme: “Ñañarije mʉ ca tiirique acoboriquepʉ tua,” ĩirique, ñucã to biro ĩitigʉra: “Wãmʉ nʉcã, waagʉja,” ĩirique pee? ");
INSERT INTO baoNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Yʉ, Ca Nii Majuropeegʉ Macʉ̃, bojoca ati yepapʉre ñañarije cʉ̃ja ca tii niirijere ca acobo majigʉ yʉ ca niirijere mʉja ca majipere biro ĩigʉ mʉjare yʉ ĩñorucu —ĩiupi Jesús. To biro ĩi, ca bʉʉricʉre o biro cʉ̃re ĩiupi: —“Wãmʉ nʉcã, mʉ yojaricarore ami, mʉ yaa wiipʉ tua waagʉja” mʉre yʉ ĩi —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","To biro cʉ̃re cʉ̃ ca ĩirije menara, niipetirã cʉ̃ja ca ĩa cojoro wãmʉ nʉcã, cʉ̃ ca yojarica quejerore ami, cʉ̃ yaa wii pee Ʉmʉreco Pacʉre baja peo nʉcʉ̃ bʉo, ĩicã tua waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Teere niipetirãpʉra do biro pee ĩi majiticã, Ʉmʉreco Pacʉre baja peo nʉcʉ̃ bʉo, bʉaro uwi tʉgoeñarique mena o biro ĩiupa: —Mecʉ̃ra añurije ca ĩa ñaaña manirijere mani ĩajãwʉ —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ate jiro Jesús witi waagʉ, jĩcʉ̃ Roma maquẽre wapa jee bojari maja mena macʉ̃ Leví ca wãme cʉtigʉ, wapa jãirã cʉ̃ja ca duwiri tabepʉ ca duwigʉre ĩa: —Yʉ mena dooya —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Leví pea to biro cʉ̃re cʉ̃ ca ĩirora wãmʉ nʉcã, niipetirije cʉ̃ yee paderiquere toora cũu waacoaupi Jesús mena. ");
INSERT INTO baoNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Jiro jañuro Leví, cʉ̃ yaa wiipʉ pairi boje rʉmʉ Jesús're boje rʉmʉ tii peoupi. To biro cʉ̃ ca tiiri tabere, paʉ Roma maquẽre wapa jee bojari maja, aperã, cʉ̃ja mena baa bapa cʉti niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","To biro cʉ̃ja ca biiro, fariseos, doti cũuriquere ca jʉo buerã, tii wãme wadorena ca tʉo nʉnʉjeerã, Jesús buerãre o biro cʉ̃jare ĩi wede pai jʉo waaupa: —¿Ñee tiirã mʉja, ñañarije ca tiirã, wapa jee bojari maja mena, baa, jini, mʉja tii niiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Añurã ca niirã, ca diarique manirã, ʉco tiiri majʉre bootima. Ca diarique cʉtirã wado booma. ");
INSERT INTO baoNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yʉa, añurã, ca ñañarije manirãre jʉogʉ doogʉ méé yʉ doowʉ. Ñañarã peere jʉogʉ doogʉ yʉ doowʉ, ñañarije cʉ̃ja ca tiirijere cʉ̃ja tʉgoeña yeri wajoajato ĩigʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","To biro cʉ̃ ca ĩiro, jĩcãrã o biro ĩiupa Jesús're: —Juan're ca nʉnʉrã, to biri fariseos're ca nʉnʉrã, paʉ tiiri baarique beti, to birora juu bue, tiicã niima. Mʉ buerã pea, to biro tiitirãra jinirã, baarã, tiicã niirucuma —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —To docare mʉja, ¿amo jiarica boje rʉmʉre cʉ̃ ca jʉo cojoricarãre, ca amo jiagʉ cʉ̃ja mena cʉ̃ ca niirora, cʉ̃ja ca betiro mʉja tiicãbogajati? ");
INSERT INTO baoNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Earucu jĩcã rʉmʉ ca amo jiagʉre cʉ̃ja ca ami weo waari rʉmʉ. Tii rʉmʉri docare betirucuma —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","To biro ĩi, ati wãme cʉ̃jare ĩi cõoña wedeupi ñucã: —Jĩcʉ̃ ʉno peera, jutiro bʉcʉrore sere tuurʉgʉ, jutiro wãmarore taa amitimi. To biro cʉ̃ ca tiijata, wãma quejerore to birora tii yaiocãgʉ tiimi. Wãma quejero, bʉcʉ quejero menare añuro ãpõtĩoti. ");
INSERT INTO baoNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ñucã jĩcʉ̃ ʉno peera ʉje oco wãmare, waibʉcʉ quejero poari, bʉcʉ poaripʉre pio jãatimi. To biro cʉ̃ ca tiijata, ʉje oco wãma, tii poarire tii yega batecãcu. To biri ʉje ocoa jite batecoa, tii poari cãa yega yaicoa, biicãcu. ");
INSERT INTO baoNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","To biri ʉje oco wãmarã, wãma poaripʉ pio jãaricaro añu. ");
INSERT INTO baoNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jĩcʉ̃ ʉno peera ʉje oco ca pãmʉrijepʉre ca jinirã, wãma biperique peera jinitima, “Ca pãmʉrijepʉ wado añu” ca ĩirã niiri —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Jĩcã rʉmʉ Jesús, yerijãarica rʉmʉ ca niiro, ote wejeri watoapʉ cʉ̃ ca waa nʉnʉa waaro, cʉ̃ buerã pea trigo dicare tune jee, cʉ̃ja amori mena ca apere jĩquẽ jeeri, baa nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","To biro cʉ̃ja ca tiiro, jĩcãrã fariseos o biro cʉ̃jare ĩi jãiñaupa: —¿Ñee tiirã, yerijãarica rʉmʉre ca tii dotitirijere mʉja tiiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi Jesús: —¿Mʉja, jĩcãti David, cʉ̃ mena macãrã ména queyama ĩigʉ cʉ̃ ca tiiriquere, jĩcãti ʉno peera mʉja bue ñaatiti? ");
INSERT INTO baoNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Ʉmʉreco Pacʉ yaa wiipʉ jãa waa, pan, Ʉmʉreco Pacʉ yee cʉ̃ja ca jee dica wooriquerena jee, paia wado cʉ̃ja ca baarijerena baa, cʉ̃ mena macãrã cãare eca, tiiupi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","O biro cʉ̃jare ĩi nemoupi ñucã: —Yʉ, Ca Nii Majuropeegʉ Macʉ̃a, yerijãarica rʉmʉ cãare yʉ doti majicã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ape rʉmʉ yerijãarica rʉmʉ ca niiro, nea poo juu buerica wiipʉ jãa waari, bue jʉo waaupi ñucã Jesús. Toopʉre niiupi jĩcʉ̃, díámacʉ̃ nʉña peere ca amo bʉʉricʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","To biri doti cũuriquere ca jʉo buerã, fariseos, cʉ̃re cʉ̃ja ca wedejãapa wãmere amarã, “¿Yerijãarica rʉmʉrena cʉ̃ catiocãgʉti?” ĩirã, cʉ̃ jĩcʉ̃rena boca ĩa cote niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesús pea to biro cʉ̃ja ca ĩi tʉgoeñarijere majiri, o biro ĩiupi ca amo bʉʉricʉre: —Wãmʉ nʉcã doori, ano decomacã pee ea nʉcã waagʉja —cʉ̃re ĩiupi. To biro cʉ̃re cʉ̃ ca ĩiro, wãmʉ nʉcã doo, cʉ̃ ca ea nʉcã waaro ĩa, ");
INSERT INTO baoNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","o biro cʉ̃jare ĩiupi Jesús: —Jĩcã wãme mʉjare yʉ jãiñarucu: ¿Doti cũuriquea, yerijãarica rʉmʉre ñee to tii dotiti, ñañarijere, añurije peere? ¿Bojocare catioriquere, jĩa cõarique peere? —cʉ̃jare ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","To biro ĩi, cʉ̃ weja ca niirã niipetirãre ĩa, o biro ĩiupi ca amo bʉʉricʉre: —Mʉ amore juu pooya —ĩiupi. Cʉ̃ ca ĩirore biro tiiupi cʉ̃ pea. To cõrora ca bʉʉmirica amo añucoaupa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","To biro cʉ̃ ca tiirijere ĩarã, fariseos pea bʉaro ajiari: —¿Do biro peti Jesús're mani tiirãti? —ameri ĩi wede peni jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Tii rʉmʉrirena Jesús, ʉ̃tãga jotoapʉ waaupi, juu buegʉ waagʉ. Tii ñamire Ʉmʉreco Pacʉre juu bue ñami cʉti boeocoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ape rʉmʉ boeri tabe, cʉ̃ buerãre jʉo cojori, cʉ̃ja mena macãrãre pʉa amo peti, dʉpore pʉaga penituaro ca niirã beje jeeupi, cʉ̃ yee quetire ca wedeparãre. ");
INSERT INTO baoNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","To biri anija niiupa: Simón, ñucã cʉ̃rena Pedro cʉ̃ ca wãmeo tiiricʉ, Simón bai Andrés, Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO baoNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Alfeo macʉ̃ Santiago, Simón celote puna macʉ̃, ");
INSERT INTO baoNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Santiago macʉ̃ Judas, Judas Iscariote Jesús're ca wedejãa cõapʉ, to cãnacãrã niiupa Jesús cʉ̃ ca beje jeericarã, cʉ̃ yee quetire ca wede nemoparã. ");
INSERT INTO baoNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","18","Jiro Jesús ʉ̃tãgʉ jotoapʉ ca niiricʉ, cʉ̃ja mena duwi doo, ca buuri maniri yepare tua nʉcã eaupi. Toore, paʉ cʉ̃re ca nʉnʉrã, paʉ Judea yepa niipetiro macãrã, Jerusalén macãrã, dia pairi yaa buuro jotoa macã macãri Tiro, Sidón, ca wãme cʉtiri macãri macãrã, Jesús cʉ̃ ca wederijere ca tʉorã dooricarã, cʉ̃ja diariquere cʉ̃ ametʉenejato ĩirã ca dooricarã, niiupa. Ñucã wãtĩ yeri jʉori ñañaro ca tamʉorã cãa catio ecoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","To biri bojoca niipetirã Jesús're padeñarʉgamiupa, cʉ̃ ca yeri tutuarije cʉ̃pʉre ca witirijera niipetirã ca diarique cʉtirãre ca ametʉenero macã. ");
INSERT INTO baoNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","To cõrora Jesús pea cʉ̃ buerã peere ĩa, o biro cʉ̃jare ĩiupi: “¡Ʉjea niiña mʉja, ca boo pacarã. Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea mʉja yaa tabera nii! ");
INSERT INTO baoNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","¡Ʉjea niiña mʉja mecʉ̃re ca queyarã, añuro yapi ʉjea niirã mʉja niirucu! ¡Ʉjea niiña mʉja, mecʉ̃re ca otirã. Jiropʉre mʉja bui ʉjea niirucu! ");
INSERT INTO baoNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","¡Ʉjea niiña mʉja, yʉ, Ca Nii Majuropeegʉ Macʉ̃ yee jʉori, mʉjare ĩa tuti, mʉjare cõa wiene, mʉjare acaro bui tuti, ñañarãre biro jeeñori, mʉjare cʉ̃ja ca ĩa junaro!” ");
INSERT INTO baoNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","To biro mʉja ca tamʉori rʉmʉre ʉjea niiña. Bʉaropʉra ʉjea niirique mena niiña, ʉmʉreco tutipʉre añurijere mʉja tiicojo ecorucu. Cʉ̃ja ñicʉ̃apʉ cãa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare o biri wãmera ñañaro cʉ̃jare tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“¡Mʉja ca apeye pairã pea ñañaro mʉja tamʉorucu, mee ʉjea niiriquere mʉja bʉa yerijãa! ");
INSERT INTO baoNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","¡Mʉja mecʉ̃re añuro yapi añurã ca niirã, jiropʉre mʉja queya nucũ yuju bʉañarucu! ¡Mʉja mecʉ̃re ca bui ʉjea nii niirã, jiropʉre ñañaro tʉgoeñarique pai mʉja otirucu! ");
INSERT INTO baoNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","¡Mʉja mecʉ̃re niipetirã cʉ̃ja ca ĩi nʉcʉ̃ bʉorã, ñañaro mʉja tamʉorucu! ¡To birora tiiquĩupa cʉ̃ja ñicʉ̃apʉ cãa, Ʉmʉreco Pacʉ yee quetire wederi maja jãa nii, ca ĩi dito nucũ yujurã mena cãare!” cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","—Mʉja yʉre ca tʉorã peera, o biro mʉjare yʉ ĩi: Mʉjare ca ĩa tutirãre maiña; ñañaro mʉjare ca tiirã cãare añuro cʉ̃jare tiiya. ");
INSERT INTO baoNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","“Ñañaro mʉja bii bʉa ñaarucu,” mʉjare ca ĩi tutirãre, “Añuro mʉjare to biijato,” cʉ̃jare ĩiña. Ñañaro mʉjare ca tii eperã cãare, juu bue bojaya. ");
INSERT INTO baoNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Jĩcʉ̃, mʉre, jĩcã nʉña wajopuare cʉ̃ ca paajata, ape nʉña cãare cʉ̃re paa dotiya. Jĩcʉ̃ mʉ jutiro jotoa macãrore cʉ̃ ca ẽmajata, “Doca macãro cãare cʉ̃ amicoajato,” ĩicãña. ");
INSERT INTO baoNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","No ca boogʉ cʉ̃ ca boorijere mʉre cʉ̃ ca jãiro, cʉ̃re tiicojoya. Mʉ yeere ca ẽmagʉ cãare, “Yʉre tueneña,” cʉ̃re ĩiticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Aperã añuro mʉjare cʉ̃ja ca tiiro mʉja ca boorore birora, mʉja cãa añuro cʉ̃jare tiiya. ");
INSERT INTO baoNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","”Mʉjare ca mairã wadore mʉja ca maijata, ¿ñee ʉno pee añurijere tii ametʉene nʉcãrã mʉja tiiti? Ñañarije ca tiirã cãa to birora tiirique cʉtima. ");
INSERT INTO baoNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Añuro mʉjare ca tiirã wadore, añuro cʉ̃jare mʉja ca tiijata, ¿ñee ʉno peere añurije to bii ametʉene nʉcãti? Ñañarije ca tiirã cãa to birora tiirique cʉtima. ");
INSERT INTO baoNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","“Apeye ʉnore jãare tiicojorucuma,” mʉja ca ĩi tʉgoeñarã wadore mʉja ca wajojata, ¿ñee ʉno peere añurije tii ametʉene nʉcãrã mʉja tiiti? Ñañarije ca tiirã cãa, “Apeye ʉno jãa tiicojo ecorucu,” ĩi tʉgoeñari ameri wajoma. ");
INSERT INTO baoNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Mʉja pea to biro tiitirãra, mʉjare ca ĩa tutirãre mai, añurijere tii, apeye ʉnore wajorã cãa, “Tee wapa jãare tiicojorucuma,” ĩi yuericaro maniro tiiya. To biro mʉja ca tiiro, pairo niirucu, mʉja yee ca niipe. Mʉja pea Ʉmʉreco Pacʉ ati ʉmʉreco niipetiropʉre Ca Doti Niigʉ puna mʉja niirucu. Cʉ̃a, añu ca ĩitirã, ca bojoca ñañarã mena cãare, ca bojoca añugʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Mʉja cãa, ca ĩa mairã niiña, mʉja Pacʉ ca ĩa maigʉ cʉ̃ ca niirore birora. ");
INSERT INTO baoNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","”Aperãre, “To biro biima,” ĩi ĩa bejeticãña. Ʉmʉreco Pacʉ cãa, “To biro biima,” mʉjare ĩi ĩa bejetirucumi. Ñucã aperãre “Ñañaro ca tii ecoparãra niima,” cʉ̃jare ĩi wedejãaticãña. Ʉmʉreco Pacʉ cãa, “Ñañaro ca tii ecoparãra niima,” mʉjare ĩitirucumi. Ñañarije mʉjare cʉ̃ja ca tiirijere acoboya. Ʉmʉreco Pacʉ cãa ñañarije mʉja ca tiirijere acoborucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ca cʉotirãre cʉ̃ja ca boo pacarijere cʉ̃jare tiicojoya. Ʉmʉreco Pacʉ cãa mʉjare tiicojorucumi. Mʉjare tiicojorucumi upa poapʉ añuro ʉta bijaro ñia jua dadocãrica poa. Aperãre mʉja ca tiicojoricaro cõrora, Ʉmʉreco Pacʉ cãa mʉjare tuenerucumi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ñucã ati wãme ĩi cõoñari cʉ̃jare wedeupi: —Mʉjara, ¿jĩcʉ̃ ca ĩatigʉra, apĩ ca ĩatigʉre cʉ̃ jʉo jʉgue waa majicãgajati? ¿Cʉ̃ja pʉarãpʉra opepʉ cʉ̃ja ñaajãacoatigajati? ");
INSERT INTO baoNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jĩcʉ̃ bueri majʉ ʉno peera cʉ̃re ca buegʉ ametʉenero maji ametʉenetimi. Biigʉpʉa, cʉ̃ ca buerijere yapanogʉpʉ doca, cʉ̃re ca buegʉre birora bii eacumi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","”¿Ñee tiigʉ mʉ pea mʉ capegapʉre yucʉ dʉcaro mʉ ca cʉorije peera ĩa majiti pacagʉ, mʉ yee wedegʉ capega peere taa daacã ca jãñari daa peere mʉ ĩa nʉnʉjeeti? ");
INSERT INTO baoNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mʉ capegarena yucʉ dʉcaro mʉ ca cʉorijere ĩa majiti pacagʉ, ¿ñee tiigʉ mʉ yee wedegʉre, “Yʉ yee wedegʉ mʉ capegapʉre taa daa jãña, tii daare yʉre ami cõa dotiya,” cʉ̃re mʉ ĩiti? Watoara ca bii dito paigʉ, mʉ capegare ca niiri dʉcaro peere ami cõa jʉoya. To biro tiicãri jiropʉ docare, añuro mʉ ĩa majirucu, mʉ yee wedegʉ capegapʉre taa daacã ca jãñari daare ami cõarʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","”Jĩcãgʉ ʉno peera, yucʉgʉ añuricʉ ñañarije dica cʉtiti; yucʉgʉ ca ñañaricʉ cãa, añurije dica cʉtiti. ");
INSERT INTO baoNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","To cãnacã yucʉpʉrena ca dica mena ĩa majirique nii. Higore pota yucʉpʉre ca niirijere jeeya mani. Ʉje cãare pota daaripʉre ca niirijere jeeya mani. ");
INSERT INTO baoNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Bojocʉ ca añugʉ, añurije wedemi, cʉ̃ yeripʉre añurije ca niiro macã. Ñañagʉ cãa, ñañarije wedemi, cʉ̃ yeripʉre ñañarije wado ca niiro macã. To biri yeripʉre ca nii ametʉene nʉcãrijera ʉjerore witi. ");
INSERT INTO baoNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","”¿Ñee tiirã yʉ ca ĩirijere tiiti pacarã “Wiogʉ, Wiogʉ,” yʉre mʉja ĩiti? ");
INSERT INTO baoNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Yʉ pʉto pee doori, yʉ yee quetire tʉo, yʉ ca ĩirore biro ca tiigʉa, “O biirije ca tiigʉre biro biimi,” mʉjare yʉ ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Jĩcʉ̃ wii bʉagʉ ʉ̃cʉ̃aro ope coa jʉo, ʉ̃tãga jotoara wii botarire wee ñee peo, ca tiiricʉre biro biimi. Dia pai, duama ĩiro, tutuaro tii wiire oco ca ũmaa cõa tuu pacaro, petoacã yuguirucu tiitiupe, añuro tutua añuro cʉ̃ ca quenorica wii niiri. ");
INSERT INTO baoNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Yʉ ca ĩirijere tʉo pacagʉ, yʉ ca ĩirore biro ca tiitigʉa, jĩcʉ̃ wii bʉagʉ, yepara tii pacagʉ, wii botari ca nucũ ñeepa tabe cũu jʉotigʉra ca tiiricʉre biro biimi. Dia pai, duama ĩiro, tutuaro oco ũmaa cõa tuuma ĩirora, jĩcã bota, wii bota dʉjaricaro maniropʉ ũmaa yuu bate yaiocãupe —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Bojocare to biro cʉ̃jare ĩi wede yapano, Capernaúm'pʉ waacoaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tii macãre niiupi jĩcʉ̃ Roma macʉ̃, uwamarã wiogʉ, cʉ̃re ca pade bojari majʉ bʉaro cʉ̃ ca maigʉ, ca bii yaigʉpʉre ca cʉogʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Uwamarã ʉpʉ pea Jesús cʉ̃ ca tii niirijere cʉ̃ja ca wedero tʉori, jĩcãrã judíos're ca jʉo niirã mena cʉ̃ pade coteri majʉre cʉ̃ catiogʉ doojato ĩigʉ, Jesús're cʉ̃jare jʉo doti cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Cʉ̃ja pea to biro cʉ̃ ca ĩi cojoricarã Jesús pʉto earã, o biro cʉ̃re ĩiupa: —Ani uwamarã ʉpʉa mʉ ca tii nemopʉ ʉnora niimi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Cʉ̃a, mani yaa pooga macãrãre bʉaro maimi. Cʉ̃ra jãa ca nea poo juu bueri wiire tii dotiwi —ĩi eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","To biri cʉ̃ja mena waaupi Jesús. Mee, wiire ea waagʉ doogʉ cʉ̃ ca birora, uwamarã wiogʉ pea jĩcãrã cʉ̃ mena macãrãre o biro ĩi doti cojoupi: —Wiogʉ, tee jʉorira pato wãcãrique mena biiticãña. Yʉa, yʉ yaa wiire mʉre ca jãa dotipʉ ʉno méé yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","To birira mee, yʉ majuropeera mʉre yʉ amagʉ waatijãwʉ. Yʉre pade coteri majʉ cʉ̃ ca diarique ametʉape wadore doti cojoya. ");
INSERT INTO baoNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yʉ majurope cãa yʉ wiorã cʉ̃ja ca dotirijere ca tiigʉ yʉ nii. Yʉ cãa uwamarãre yʉ cʉo, yʉ ca dotirijere ca tiirãre. To biri cʉ̃ja mena macʉ̃ jĩcʉ̃re, “Waagʉja” yʉ ca ĩiro, waami. Ñucã apĩre, “Dooya” cʉ̃re yʉ ca ĩiro, doomi; yʉre ca pade cotegʉ cãare, “Teere tiiya” yʉ ca ĩiro, yʉ ca ĩirore biro tiimi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Teere tʉogʉ, Jesús pea do biro pee ĩi majiticã amojode nʉcãri, cʉ̃re ca nʉnʉrãre o biro ĩiupi: —Yee méé mʉjare yʉ ĩi. Ano Israel yepare jĩcʉ̃ ʉno peera ani uwamarã ʉpʉ to cõro bʉaro “Yʉre tii nemocãrucumi,” cʉ̃ ca ĩi tʉgoeña bayirore biro ca biigʉre yʉ bʉa ea ñaati —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Uwamarã wiogʉ cʉ̃ ca doti cojoricarã pea wiipʉ tua earã, uwamarã wiogʉre pade coteri majʉ bii yaigʉpʉ ca biimiricʉre añuro cati añugʉpʉ cʉ̃ ca niiro tua eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ate jiro Jesús, Naín ca wãme cʉtiri macã pee, cʉ̃ buerã, aperã bojoca paʉ mena waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Tii macãre ea waarã, paʉ bojoca tii macã macãrã mena ca manʉ bii yai weorico macʉ̃ jĩcʉ̃ra ca niimiricʉ, ca bii yairicʉre cʉ̃ja ca yaarã waaro ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Cʉ̃jare ĩa, ca bii yairicʉ pacore boo paca ĩari, o biro cõre ĩiupi: —¡Otieto! —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","To cõrora waa, maja potire padeña, cʉ̃ ca tiirora tii potire ca ami waarã pea tua nʉcãupa. Jesús pea, o biro ĩiupi ca bii yairicʉre: —Wãmʉ, wãmʉ nʉcãña mʉre yʉ ĩi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","To biro cʉ̃ ca ĩirije menara, ca bii yairicʉ pea cati tua wãmʉ nuu, wede jʉo waaupi. To biro tii, Jesús pea cʉ̃ pacore cʉ̃re tueneupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Atere ĩarã niipetirãpʉra ĩa uwima ĩirã, Ʉmʉreco Pacʉre o biro ĩi nʉcʉ̃ bʉoupa: —Jĩcʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ do biro ca tiiya manigʉ mani pʉtore baua eami —ĩiupa. Ñucã o biro ĩiupa: —Ʉmʉreco Pacʉ cʉ̃ yaarãre tii nemogʉ doogʉ doojapi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","To biro Jesús cʉ̃ ca tiirijere Judea yepa niipetiro macãrã, ñucã too wejari macãrã cãa queti tʉo peticã cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Cʉ̃ buerã cʉ̃re cʉ̃ja ca wedero macã ate niipetirijere queti tʉoupi Juan. To biri cʉ̃ buerã mena macãrã pʉarãre jʉo cojo, ");
INSERT INTO baoNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jesús're o biro ĩi jãiña doti cojoupi: —¿Mʉra mʉ niiti “ ‘Mesías doorucumi,’ cʉ̃ja ca ĩiricʉ, ména apĩre jãa yuegajatiqué?” cʉ̃re ĩi jãiñarãja —ĩiupi Juan. ");
INSERT INTO baoNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","To biro cʉ̃ ca ĩi cojoricarã Jesús pʉto ea, o biro cʉ̃re ĩiupa: —Juan, bojocare uwo coeri majʉ, “¿Mʉra mʉ niiti, ‘Mesías doorucumi,’ cʉ̃ja ca ĩiricʉ, ména apĩ ca yueparã jãa niitiqué?” cʉ̃re ĩi jãiñarãja jãare ĩi cojojãwi —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","To biro cʉ̃re cʉ̃ja ca ĩiri tabera, Jesús pea paʉ bojoca ca diarique cʉtirãre, ca upʉri punirãre, catioupi. Ñucã cʉ̃ja yeripʉ ca wãtĩa jãñarã cãare cʉ̃jare catio, paʉ ca ĩatirãre cʉ̃ja ca ĩaro tii, cʉ̃jare tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","To biro tii yapano, o biro cʉ̃jare ĩi yʉʉupi Jesús: —Waari, mʉja ca ĩajãrijere, mʉja ca tʉojãrijere wedeya Juan're. Ca ĩatirã ca niimiricarã ĩa, upa yuriri cãa añuro waa maji, ca cami boarã cãa cami yati eco, ca tʉotimiricarã cãa tʉo, ca bii yairicarã cãa cati tua, ñucã ca boo pacarã cãa añurije quetire wede eco, biima. ");
INSERT INTO baoNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","“¡Ʉjea niiña, yʉ yee jʉori ca tʉgoeña maa wijiatigʉa!” ĩi wederãja Juan're —ĩiupi, Juan cʉ̃ ca jãiña doti cojoricarãre. ");
INSERT INTO baoNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Juan, cʉ̃ ca jãiña doti cojoricarã cʉ̃ja ca tua waaro jiro, too ca niirã bojocare o biro cʉ̃jare ĩi wede jʉo waaupi Jesús, Juan yee maquẽre: —¿Ñeere ĩarã waarã, ca yucʉ maniri yepapʉ mʉja waari? ¿Jĩcã wãjo wino ca paa puurije mena ca yugui nucũri wãjore ĩarã waarã mʉja biiri? ");
INSERT INTO baoNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Tee méére ĩarã mʉja ca biijata, ¿ñeere ĩarã waarã mʉja biiri? ¿Jĩcʉ̃ añurije ca juti jãñagʉre ĩarã waarã mʉja biirique? Mʉja, añurije juti jãñacãri ca niirã, cʉ̃ja upʉri ca boorore biro ca tii nucũ yujurã, wiorã yaa wiijeripʉ cʉ̃ja ca niirijere mʉja maji. ");
INSERT INTO baoNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿To docare ñee peere ĩarã waarã mʉja waari? ¿Jĩcʉ̃ Ʉmʉreco Pacʉ yee quetire ca wede jʉgueri majʉre ĩarã waarã mʉja biiriqué? Cʉ̃ petire mʉja ĩarã waajacupa. Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja ca niirã ametʉenero ca niigʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan, Ʉmʉreco Pacʉ wederiquepʉ o biro cʉ̃ja ca ĩi owa tuuricʉra niimi: “Mʉre cʉ̃ maa queno yuejato ĩigʉ, yʉ yʉʉ queti wederi majʉre mʉ jʉguero cʉ̃re yʉ tiicojo.” ");
INSERT INTO baoNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jĩcʉ̃ peera ati yepa macʉ̃, Juan ametʉenero ca nii majuropeegʉ maniupi. To biro cʉ̃ ca biicã pacaro, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉra watoa macʉ̃ ca niigʉ pee, Juan ametʉenero ca niigʉ niimi —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","O biro cʉ̃ ca ĩiro tʉorã, bojoca niipetirã, ñucã Roma maquẽre wapa jee bojari majapʉ cãa, “Ʉmʉreco Pacʉ cʉ̃ ca ĩirije díámacʉ̃ra nii,” ĩi majiri, Juan're uwo coe dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Cʉ̃ja pea o biro cʉ̃ja ca biicãro, fariseos, doti cũuriquere ca jʉo buerã pea, Juan're uwo coe dotitiupa. To biro biirã, Ʉmʉreco Pacʉ cʉ̃jare cʉ̃ ca tii nemorʉgamirijere junaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","O biro ĩi nʉnʉa waaupi Jesús: —¿Ati cuu macãrã bojocare, ñee mena yʉ ĩi cõoñagʉti? ¿Ñiruare biro cʉ̃ja biiti? ");
INSERT INTO baoNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wimarã jĩcã yepapʉ epe duwirã cʉ̃ja mena macãrãre: “Tõrogare jãa putimijãwʉ; mʉja pea mʉja bajatijãwʉ. Boori bajare jãa bajamijãwʉ; mʉja pea mʉja otitijãwʉ,” ca ĩi ameri acaro bui cojo niirãre biro niima. ");
INSERT INTO baoNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bojocare Uwo Coeri majʉ Juan, baariquere baati, ʉje ocore jiniti, ca biigʉ dooupi. To biro cʉ̃ ca biirijerena, “Ca wãtĩ jãñagʉ niimi,” cʉ̃re mʉja ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Cʉ̃ jiro yʉ doowʉ ñucã, yʉ, Ca Nii Majuropeegʉ Macʉ̃, baariquere ca baagʉ, ʉje ocore ca jinigʉ. To biro yʉ ca biirijerena ñucã mʉja pea: “Ca baa pacagʉ, ca jini pacagʉ, ñañarã mena macʉ̃, Roma maquẽre wapa jee bojari maja mena macʉ̃ niimi,” yʉre mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Biiropʉa Ʉmʉreco Pacʉ yee majiriquea, cʉ̃re ca nʉnʉrã menapʉ bii ĩñocã —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Jĩcʉ̃ fariseo Simón ca wãme cʉtigʉ Jesús're: “Yʉ pʉto baagʉ dooya,” cʉ̃re ĩiupi. To biro cʉ̃ ca ĩiricʉ cʉ̃ yaa wiipʉ waari, baarique peorica pĩi pʉto ea nuu eaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Tii macãre niiupo jĩcõ nomio, ñañarije ca tiigo. Cõ pea, “Fariseo yaa wiipʉ baagʉ waajagʉ Jesús,” cʉ̃ja ca ĩirijere tʉori, alabastro cʉ̃ja ca ĩirica dadaro, ca jʉti añurijere cʉocãrico, jãa eaupo Jesús pʉto. ");
INSERT INTO baoNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Otigora, Jesús dʉpori pʉto pee waari, cõ cape oco menara cʉ̃ dʉporire weyoupo. To biro tiicã cõ poa menara tuu bopo, cʉ̃ dʉporire ũpũ, ca jʉti añurije pio peo, tiiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","To biro cõ ca tiiro ĩagʉ, “Yʉ yaa wiipʉ baagʉ dooya” Jesús're ca ĩiricʉ fariseo pea: —Ania díámacʉ̃ra, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉra cʉ̃ ca niijata, to biro ca biigo yʉre padeñacumo, “Ñañarije ca tiigo niimo atio,” ĩi majibocumi doca —ĩi tʉgoeñaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","To cõrora Jesús pea o biro cʉ̃re ĩiupi fariseore: —Simón, jĩcã wãme mʉre yʉ ĩirʉga —ĩiupi. To cʉ̃ ca ĩiro: —Jaʉ, Buegʉ, yʉre wedeya —cʉ̃re ĩiupi Simón. ");
INSERT INTO baoNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesús pea o biro cʉ̃re ĩi wede nʉnʉa waaupi: —Pʉarã ʉmʉa, wapa moouparã wapa tiirica tiiri ca wajogʉre. Jĩcʉ̃ quinientos rʉmʉri pade wapa taaricaro cõro, apĩ pea, cincuenta rʉmʉri pade wapa taaricaro cõro, cʉ̃re wapa moouparã. ");
INSERT INTO baoNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Cʉ̃ja ca wajoricʉ pea cʉ̃re cʉ̃ja ca wapa tiipe ʉno cʉ̃ja ca cʉotiro macã, cʉ̃ja pʉarãpʉrena “ ‘Yʉre mʉja ca wapa moorijea to birora to biicãjato,’ cʉ̃jare ĩiupʉ,” mʉ pea ĩiñaaqué yua. Mʉ ca tʉgoeñajata, ¿niipe bʉaro peti cʉ̃re cʉ̃ maigajati? —cʉ̃re ĩi jãiñaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","To biro cʉ̃ ca ĩi jãiñaro: —Yʉra, pairo cʉ̃re ca wapa moomiricʉ pee cʉ̃re mai ametʉenecumi —ĩiupi. To biro cʉ̃re cʉ̃ ca ĩi yʉʉro tʉogʉ: —Díámacʉ̃ra mʉ ĩi —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","To biro cʉ̃re ĩi, nomio peere ĩari, o biro cʉ̃re ĩiupi Jesús, Simón're: —¿Mʉ ĩati atiore? Mʉ yaa wii yʉ ca jãa dooro, yʉ dʉpori yʉ ca coepe oco yʉre mʉ tiicojotijãwʉ. Cõ pea, cõ cape oco menara yʉ dʉporire weyori, cõ poa ñapõ menara tuu coe bopomo. ");
INSERT INTO baoNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yʉ ca earo, yʉ wajopuare ũpũ boca, mʉ tiitijãwʉ. Cõ pea, yʉ ca jãa earopʉra yʉ dʉporire ca ũpũ jʉojãgo, ũpũ yerijãatimo. ");
INSERT INTO baoNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ñucã yʉ dʉpʉga cãare ca jʉti añurije yʉre pio peo, mʉ tiitijãwʉ. Cõ pea, yʉ dʉporire ca jʉti añurije pio peomo. ");
INSERT INTO baoNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","To biri mʉre yʉ ĩi: Paʉ ñañarije cõ ca tiiriquere acobo ecomo, bʉaro yʉre cõ ca mairo macã. Petoacã ñañarije ca tiiricʉre acobojata, petoacã cʉ̃ ca mairijere ĩñomi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","To biro cʉ̃re ĩi, o biro ĩiupi nomio peere: —Ñañarije mʉ ca tiirique acoboriquepʉ nii —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","To biro cʉ̃ ca ĩiro tʉorã, aperã cʉ̃ ca jʉoricarã pea o biro ameri ĩi jãiñaupa: —¿Ania ñiru ʉno peti cʉ̃ niicãti nija, bojoca ñañarije cʉ̃ja ca tiirijepʉ cãare ca acobocãgʉa? —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesús pea o biro ĩiupi ñucã nomio peere: —“Yʉre ametʉenecãrucumi,” mʉ ca ĩi tʉgoeña bayirije jʉori, mʉ ametʉene eco. Tʉgoeñarique paitigora tua waagoja —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ate jiro Jesús paʉ macãripʉre Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ añurije quetire wede yujuupi. Cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã, ");
INSERT INTO baoNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ñucã nomia jĩcãrã ca wãtĩa jãa ecoricarãre cʉ̃ ca catioricarã romiri, cʉ̃re bapa cʉti yujuupa. Cʉ̃ja watoare waaupo María, ñucã cõra Magdalena ca wãme cʉtigo, jĩcã amo peti, ape amore pʉaga penituaro ca niirã peti wãtĩa cʉ̃ja ca witirico. ");
INSERT INTO baoNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Apeo, wiogʉ Herodes yeere ĩa nʉnʉjee bojari majʉ ca niiricʉ Cuza nʉmo Juana, to biri apeo Susana niiupa. Aperã paʉ romiri cʉ̃ja ca cʉorije mena cʉ̃re ca tii nemorucuricarã niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Paʉ bojoca macãri macãrã cõrora Jesús're ĩarʉgarã waaupa. To biri paʉ cʉ̃ja ca nea pooro ati wãme ĩi cõoñari, cʉ̃jare wedeupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—Jĩcʉ̃ oteri majʉ cʉ̃ otere otegʉ waaupʉ. Cʉ̃ ca dee bate otero jĩcãgaari maapʉ ñaaupe. To biri bojoca teere ʉta yaio batecã, ñucã minia cãa doo, teere baacã, tiicãuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Apeye ñaaupe ʉ̃tã watoapʉ. Wiiñami, jita ʉje meniroacã ca niiro macã, oco manima ĩiro jinicoaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ape gaari pota watoapʉ ñaaupe. Pota mena jĩcãrira bʉcʉañami, pota pee teere bʉcʉa ametʉa biato yaiocãupe. ");
INSERT INTO baoNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Apeye pea añuri jitapʉre ñaacũmuupe. Tee añuro bʉcʉa, jĩcã jati cien apegaari peti dica cʉtiupe —ĩiupi. Atere o biro ĩi yapano, tutuaro wederique mena o biro ĩiupi Jesús: —¡Ca amoperi cʉtirã tʉoya yʉ ca ĩirijere! ");
INSERT INTO baoNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Cʉ̃ buerã pea, “¿Ate ĩi cõoñarique, do biro ĩirʉgaro to ĩiti?” cʉ̃re ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús pea o biro cʉ̃jare ĩiupi: —Mʉjara Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ ca majiña maniriquere mʉja ca majiro mʉjare tiimi. Aperã peera ĩi cõoñarique mena cʉ̃jare yʉ wede, “Yʉ ca tiirijere ca ĩarã nii pacarã ĩa majiti, yʉ ca wederijere tʉo pacarã tʉo majiti, cʉ̃ja biijato ĩigʉ,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","”Ate nii ĩi cõoñari yʉ ca wedejãrijere ca ĩirʉgarije: Ote apegaaria, Ʉmʉreco Pacʉ wederique nii. ");
INSERT INTO baoNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ote ape ca ñaarica maa pea, Ʉmʉreco Pacʉ yee quetire ca tʉorã niima. Jiro Satanás doo, añurije queti cʉ̃ja ca tʉomiriquere ẽmacãcumi, teere díámacʉ̃ tʉo nʉnʉjeeri ametʉarema ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ca ʉ̃tã cʉtiri yepa pea añurije quetire tʉorã, ʉjea niirique mena ca tʉorã niima. Bʉcʉarucu ñami, nʉcõri manima ĩiro ca jiniriquere birora, tee jʉori ñañaro cʉ̃jare to ca bii earora, cʉ̃ja ca tʉo nʉnʉjeemiriquere yerijãacãma. ");
INSERT INTO baoNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ote ape ca ñaarica yepa ca pota yucʉ cʉtiri yepa pea, añurije quetire ca tʉorã niima. Tʉo pacarã tʉgoeñarique pai, pairo apeye cʉorʉga tʉgoeña, ati yepare cati niirã cʉ̃ja upʉri ca boorore biro cʉ̃ja ca tii ʉjea niirije mena teere tii yaio batecãma. To biri dica manirora ca yairicarore birora biicãma. Bʉcʉa yapanotirora ca bii yairijere biro biima. ");
INSERT INTO baoNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ote ape ca ñaarica yepa ca jita añuri yepa pea, bojoca añuro yeri tʉgoeñarique cʉtiri, añurije quetire tʉo, tee ca ĩirore biro tii nʉnʉjee, to birora tʉgoeña bayicõa nii, ca biirã niiri añuro ca dica cʉtiricarore biro biima —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","—Jĩcʉ̃ peera jĩa boericagare jotʉ mena bʉato dopo, ñucã cãni pejarica tabe doca pee dopo, tiirʉgʉ méé jĩa boemi. Emʉaro pee peorʉgʉ, ca jãa doorãre to boejato ĩigʉ pee doca, jĩa boemi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Teere birora yaioropʉ ca niirije, majiña manirijera biicã yerijãa waa, biiti. Ñucã jĩcãrãra majirique cãa niipetirãpʉ majiña manirijera niicã nʉnʉa waa, biiti. ");
INSERT INTO baoNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","To biri añuro tʉoya: Yʉ yee quetire aperãre ca wede majiogʉra, bʉaro jañuro cʉ̃ ca majipere tiicojorucumi Ʉmʉreco Pacʉ. To biro ca tiitigʉa, cʉ̃ ca majirʉga tʉgoeñamirijepʉra ẽma ecocoarucumi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús paco, cʉ̃ bairã cʉ̃re ĩarã waamiupa. Paʉ bojoca cʉ̃ja ca niiro macã, cʉ̃ pʉtopʉ ea waa majitiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","To biri to ca niirã mena macʉ̃ jĩcʉ̃: —Mʉ paco, mʉ bairã mʉre ĩarʉgarã, macãpʉ mʉre yue niima —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Yʉ paco, yʉ bairã, Ʉmʉreco Pacʉ yee quetire tʉori, tee ca ĩirore biro ca tii nʉnʉjeerã niima —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Jĩcã rʉmʉ Jesús cʉ̃ buerã mena cũmua pairicapʉ ea jãa, o biro cʉ̃jare ĩiupi: —Jamʉ. Ʉtabʉcʉra ape nʉñapʉ mani tĩa waaco —ĩiupi. To biri tĩa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Cʉ̃ja ca tĩa nʉnʉa waaro, Jesús pea cãnicoaupi. To biro cʉ̃ ca bii ditoye tiirare, bʉaro ca wino paa puu cõa pooro oco jabe nʉnʉa dooupe. To biro ca biiro, cũmua peera pairo oco ñaajãa duuropʉ tiicãupe. ");
INSERT INTO baoNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","To cõrora cʉ̃ buerã pea Jesús're wãcõrã, o biro ĩiupa: —¡Buegʉ, Buegʉ dua waarã mani bii nija! —cʉ̃re ĩiupa. To biro cʉ̃ja ca ĩiro Jesús pea wãcã, winore, ca jaberijere, yerijãa dotiupi. To cõrora wino, oco ca jaberije añuropʉ yerijãa peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","To biro ca biiro cʉ̃ buerãre o biro ĩiupi Jesús: —¿“Manire ametʉenecãrucumi” mʉja ca ĩi tʉgoeña bayirije do biro to biijãri? —ĩiupi. Cʉ̃ja pea to biro ca biirijere ĩa ʉcʉa, ñee pee ĩi majiticã, o biro ameri ĩi jãiñaupa: —¿Ñiru ʉno peti cʉ̃ niibuti ania, winopʉra, oco ca jaberijepʉra, cʉ̃ ca dotirore biro añuro cʉ̃re ca tʉo nʉnʉjeero ca tiigʉa? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Biirique peti Gerasa yepa, ʉtabʉcʉra ape nʉña peere Galilea yepa ãpõtĩñaro ca niiri yepapʉre tĩa ea waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús cʉ̃ ca maa nʉcãrije menara, jĩcʉ̃ bojocʉ, tii macã macʉ̃, ca wãtĩa jãa ecoricʉ cʉ̃re ũmaa bocaupi. Mee, yoaro juti jãñati, wiipʉre niiti, maja operi watoaripʉ nii, ca biigʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Jesús're ĩacãgʉpʉa, cʉ̃ ãjʉro jupeari mena cʉ̃ jʉguero ñaanuu waari, o biro ĩi acaro buiupi: —“¡Yʉre pato wãcõticãña Jesús, Ʉmʉreco Pacʉ ati ʉmʉreco niipetiropʉre Ca Doti Niigʉ Macʉ̃! ¡Ñañaro yʉre tiiticãña,” mʉre yʉ ĩi! —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Wãtĩ atere to biro ĩiupi, “To cõrora cʉ̃re witi waagʉja,” Jesús cʉ̃re cʉ̃ ca ĩiro macã. Paʉ tiiri wãtĩ cʉ̃pʉre ñaajãa nʉcã earucuupi. To biri no ca booro biiremi ĩirã, cʉ̃ dʉporire, cʉ̃ amorire, come daari mena cʉ̃ja ca jiacãmijata cãare, teere tʉ̃a jude batecã, ca yucʉ maniri yeparipʉ cʉ̃ ca ũmaa duticã yai waarucuro, cʉ̃re tiirucuupi wãtĩ. ");
INSERT INTO baoNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús pea o biro cʉ̃re ĩi jãiñaupi: —¿Do biro mʉ wãme cʉtiti? —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩi jãiñaro, cʉ̃ pea: —Yʉa, Legión yʉ wãme cʉti —cʉ̃re ĩi yʉʉupi. Atere o biro ĩiupi, paʉ wãtĩa cʉ̃pʉre cʉ̃ja ca jãarique ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Cʉ̃ja pea: —Ca ʉ̃cʉ̃ari opepʉ jãare tiicojoticãña —ĩi jãiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Tii tabe macã buuro peere paʉ ecaricarã yejea baa niiupa. To biri wãtĩa pea: —Cʉ̃japʉre jãare jãa dotiya —ĩiupa. Jesús pea cʉ̃japʉre cʉ̃jare jãa dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","To cõrora wãtĩa pea bojocʉpʉre ca niiricarã witi waa, yejea peere ñaajãa nʉcã eaupa. Cʉ̃ja ca jãarora, yejea pea tii buuro macã tʉdipʉ ũmaa mecʉ̃ bua waa, tiirapʉ ñaañua, dua yaicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Yejeare ca cotemiricarã pea to biro ca biirijere ĩari, ũmaa duti tua waa macã macãrãre, macã tʉjaro macãrãpʉ cãare teere cʉ̃jare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Bojoca pea to biro ca biiriquere ĩarã waaupa. Jesús pʉto earã, wãtĩa cʉ̃ja ca witi weoricʉ peera juti jãñacãricʉpʉre, ñucã añuro bojoca cati añugʉpʉ, Jesús pʉto ca duwigʉre cʉ̃re ĩaupa. To biro cʉ̃ ca biiro ĩarã, bʉaro uwiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ca wãtĩa jãa ecoricʉre Jesús cʉ̃re cʉ̃ ca catioro ca ĩaricarã pea: —O biro tii catio ecojãwi —cʉ̃jare ĩi wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Teere tʉorã, Gerasa yepa macãrã niipetirãpʉra uwima ĩirã: —Waacoagʉja. Anore niiticãña —ĩiupa. To biri Jesús cũmuapʉ ea jãa, waacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","To biro cʉ̃ ca biiro, ca wãtĩa jãñagʉre cʉ̃ ca catioricʉ pea: —Yʉ cãa, mʉ mena yʉ waarucu —bʉaro Jesús're ĩi jãimiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","To biro cʉ̃ ca ĩiro tʉogʉ, o biro cʉ̃re ĩiupi Jesús: —Dooticãña. Mʉ yaa wii pee tua waari, Ʉmʉreco Pacʉ añuro mʉre cʉ̃ ca tiirije niipetirore mʉ yaarãre wedeya —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩiro waa, macã macãrã niipetirãre Jesús cʉ̃re cʉ̃ ca catioriquere cʉ̃jare wede peticãupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús, ʉtabʉcʉra ape nʉña peere cʉ̃ ca tua tĩa earo, bojoca pea ʉjea niirique mena cʉ̃re bocaupa, niipetirã cʉ̃re ca yue niiricarã niiri. ");
INSERT INTO baoNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","To biro cʉ̃ ca bii tĩa eari tabera jĩcʉ̃, nea poo juu buerica wii wiogʉ Jairo ca wãme cʉtigʉ, Jesús pʉto eari, cʉ̃ dʉpori pʉto cʉ̃ ãjʉro jupea mena ea nuu waari: —Yʉ yaa wiipʉ dooya —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Cʉ̃ macõ jĩcõra ca niigo, pʉa amo peti, dʉpore pʉaga penituaro ca niiri cʉ̃mari ca cʉogo bii yaigopʉ biiupo. Toopʉ waagʉ cʉ̃ ca bii nʉnʉa waaro Jesús mena paʉ bojoca ʉta bijaroacã tuutu nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Cʉ̃ja watoare niiupo jĩcõ, pʉa amo peti, dʉpore pʉaga penituaro ca niiri cʉ̃mari peti ca díi waa yerijãatirije ca diarique cʉtigo. Cõre ʉco tiiri majare wapa tiima ĩigo, cõ ca cʉomirique niipetirije tiicojo peoticãupo. Jĩcʉ̃ peera cõre ʉco tii catioticãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","To biri Jesús jiro pee doo, cʉ̃ jutiro yapare padeñaupo. Cõ ca padeñarora, cõre ca díi waa niirije jĩcãto díi taticoaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","To cõrora o biro ĩi jãiñaupi Jesús: —¿Ñiru yʉre cʉ̃ padeñajãri? —ĩiupi. Niipetirãpʉra: “Jãa padeñatijãwʉ,” cʉ̃ja ca ĩiro macã, o biro cʉ̃re ĩiupi Pedro pea: —Buegʉ, paʉ bojoca mʉre ca nʉnʉrã, ʉta bijaroacã cʉ̃ja ca tuumicõa nʉnʉa waa pacaro, “¿Ñiru yʉre cʉ̃ padeñajãri mʉ ĩi jãiñati?” —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","To biro cʉ̃re cʉ̃ ca ĩi pacaro Jesús pea: —Yee méé yʉ ĩi nija, jĩcʉ̃ yʉre padeñabujãwi. Yʉ ca tʉgoeña tutua maji niirije to ca waa ũmaa waaro yʉ tʉgoeñajãwʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nomio pea to biro cʉ̃ ca ĩiro, do biro bii duti majitima ĩigo, nanagora cʉ̃ pʉto pee waa, cʉ̃ dʉpori pʉtopʉ cõ ãjʉro jupeari mena tuetuu ea nuu waari, niipetirã cʉ̃ja ca tʉoropʉ: —O biirije diarique cʉtima ĩigo, mʉ jutirore yʉ padeñajãwʉ. Yʉ ca padeñarora, yʉ ca diarique cʉtirije yʉre ametʉacoa —ĩi wedeupo. ");
INSERT INTO baoNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","To biro cõ ca ĩiro, Jesús pea o biro cõre ĩiupi: —Macõ, “Yʉre catiocãrucumi,” mʉ ca ĩi tʉgoeña bayirijera mʉ ca diarique cʉtirijere mʉre ametʉene. Tʉgoeñarique paitigora waagoja —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ména, Jesús to biro cʉ̃ ca ĩi niiri tabera, nea poo juu buerica wii wiogʉ Jairo yaa wii macʉ̃ ea, o biro cʉ̃re ĩiupi: —Mee, mʉ macõ bii yaicoajãwo. Buegʉre pato wãcõ nemoticãña —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús pea teere tʉori, o biro ĩiupi Jairore: —Uwiticãña. Díámacʉ̃ tʉo nʉnʉjeeya, mʉ macõ ametʉacãrucumo —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jairo yaa wiipʉ eagʉ, ca bii yairico pacʉ, cõ paco menare, Pedro, Juan, Santiago jãari wadore jãa waa dotiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Niipetirã bʉaro tʉgoeñarique pairique mena cõre oti niiupa. Jesús pea o biro cʉ̃jare ĩiupi: —Otiticãña. Daquego bii yaigo méé biimo. Cãnigo tiimo —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","To biro cʉ̃ ca ĩiro tʉorã, niipetirã cʉ̃re boca buicãupa Jesús're: —Mee, bii yaicoajãwo —ĩima ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","To biro cʉ̃re cʉ̃ja ca ĩi bui pacaro, cõ amore ñeeri, tutuaro wederique mena o biro ĩiupi Jesús: —Daquego, wãmʉ nʉcãña —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","To biro cʉ̃ ca ĩirora, cõ pea cati tua eaupo; cati tua eagora wãmʉ nʉcã cõ ca biiro Jesús pea: —Cõre baarique ecaya —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ca bii yaicoaricopʉra cõ ca cati tuaro ĩarã, cõ pacʉa pea ĩa ʉcʉa yaicoa, ñee pee ĩiticãupa. Jesús pea, to biro ca biiriquere: “Jĩcʉ̃ peerena wedeticãña,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesús cʉ̃ buerã, pʉa amo peti, dʉpore pʉaga penituaro ca niirãre neori, yeri tutuarique, doti majirique cʉ̃jare tiicojoupi, wãtĩa cʉ̃ja ca niiro cõrorena cõa wiene maji, diariquere ametʉene maji, cʉ̃ja ca tii majipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","To biro tii, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre wede, ca diarãre cʉ̃ja diarique ametʉene, cʉ̃jare tii dotigʉ tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","O biro cʉ̃jare ĩiupi: —Maa waarã mʉja ca cʉo waape ʉnora jee waaticãña: tuericagʉ ʉnora, wajopoa ʉnora, baarique ʉnora, wapa tiirica tiiri ʉnora, to biri juti mʉja ca wajoa jãñape ʉnorena, jee waaticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Noo mʉja ca eari wiira niicãña. Tii wiira nii, apero waarãpʉ ñucã tii wiire mʉja witirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Jĩcã macã macãrã ʉno mʉjare cʉ̃ja ca bootijata, tii macãre witi waarãra, tii macã maquẽ jita mʉja dʉporipʉre ca ea tuarijere paa bate cũu, waacoarãja, “Mʉjare jãa ca wederijere mʉja ca tʉorʉgatirije jʉori, mʉja yee wapa ñañaro mʉja tamʉorucu,” cʉ̃jare ĩi majiorã —cʉ̃jare ĩi cojoupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","To biri cʉ̃ja pea, macãri niipetirijepʉ waa, añurije quetire wede, ca diarique cʉtirãre cʉ̃ja diarique ametʉene, tii yujuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wiogʉ Herodes, Jesús cʉ̃ ca tii niirije niipetirijere queti tʉoupi. Teere tʉogʉ, do biro ĩi majitiupi: “Jĩcãrã Juan niiquĩricʉ cati tuajapi,” ");
INSERT INTO baoNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","aperã pea: “Elías baua eagʉ biijapi,” ñucã aperã: “Tĩrʉmʉpʉ macãrã, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja niiquĩricarã mena macʉ̃ cati tuagʉ biijapi,” cʉ̃ja ca ĩiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","To biro cʉ̃ja ca ĩiro tʉori, o biro ĩiupi Herodes pea: —Yʉra, Juan dʉpʉgare yʉ paa taa dotiwʉ doca. To docare, ¿ñiru peti cʉ̃ niigajati, to cõro paʉ cʉ̃ ca tii niirijere cʉ̃ja ca wederucurijere yʉ ca tʉogʉ pea? —ĩiupi. To biri Jesús're bʉaro cʉ̃re ĩarʉgarucumiupi Herodes. ");
INSERT INTO baoNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Cʉ̃ buerã tua earã, cʉ̃ja ca tiiriquere wedeupa Jesús're. Cʉ̃ pea cʉ̃ja wadore jʉo cojo, Betsaida ca wãme cʉtiri macã pee cʉ̃jare jʉo waacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Bojoca pea toopʉ cʉ̃ ca waariquere majiri, cʉ̃re nʉnʉcoaupa. Toopʉ cʉ̃ja ca ẽmʉ ea waaro, añuro cʉ̃jare boca, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre cʉ̃jare wede, ca diarique cʉtirãre cʉ̃jare catio, cʉ̃jare tiiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ca naio waaro ĩarã, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã pea Jesús pʉto waa, o biro cʉ̃re ĩiupa: —Bojocare “Waarãja,” cʉ̃jare ĩiña. Waa, pʉto jañuri ca niiri macãri pee cʉ̃ja ca cãnipa taberi, cʉ̃ja ca baapere, cʉ̃ja amarã waajato ĩigʉ. Ano mani ca niiri tabera ñee ʉno mani —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","To biro cʉ̃ja ca ĩiro: —Mʉjara cʉ̃jare baarique ecaya —cʉ̃jare boca ĩiupi Jesús. Cʉ̃ja pea o biro cʉ̃re ĩiupa: —Pan jĩcã amo cõro niirije, pʉarã wai, to cõroacãra jãa cʉo, ano ca niirã niipetirã cʉ̃ja ca baapere jãa ca wapa tiirã waatijata —ĩiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ʉmʉa wadora jĩcã amo cõro mil peti niiupa. To cõro paʉ cʉ̃ja ca niiro ĩa pacagʉ: —Cincuenta niirãri wado cʉ̃jare duwi dotiya —ĩiupi Jesús, cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Cʉ̃ja pea cʉ̃ ca tii dotirore birora bojocare cʉ̃jare duwi dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","To biro cʉ̃ja ca tii yapanoro ĩa, jĩcã amo cõro ca niirije pan'gaarire, wai pʉarãre ami, ʉmʉreco tuti pee ĩa mʉeneri, “Ate jãare mʉ ca baarique tiicojorijere añurije jãare ĩa cõa peo bojaya” ĩi jãi yapano, teere pee bato, cʉ̃ buerãre tiicojoupi bojocare cʉ̃ja bato cojojato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Bojoca niipetirã pea teere baa yapi peticoaupa. Ca dʉjarije peera pʉa amo peti, dʉpore pʉaga penituaro niiri pijeeri peti jeeupa ñucã cʉ̃ buerã pea. ");
INSERT INTO baoNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Jĩcã rʉmʉ, Jesús bojoricaro cʉ̃ ca juu bue niiro cʉ̃ buerã cãa cʉ̃ mena niiupa. Cʉ̃ pea o biro cʉ̃jare ĩi jãiñaupi: —¿Bojoca, “Ñiru niimi,” yʉre cʉ̃ja ĩirucuti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","To biro cʉ̃ ca ĩi jãiñaro, o biro cʉ̃re ĩi yʉʉupa cʉ̃ja pea: —Jĩcãrã, bojocare Uwo Coeri majʉ Juan niimi; aperã Elías niimi; ñucã aperã pea, “Tĩrʉmʉpʉ macʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja ca niiquĩricarã mena macʉ̃ ca cati tuaricʉ niimi,” mʉre ĩima —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","To biro cʉ̃ja ca ĩiro: —Mʉja pea ¿“Ñiru niimi,” yʉre mʉja ĩiti? —cʉ̃jare ĩi jãiñaupi. To biro cʉ̃ ca ĩi jãiñaro, Pedro pea: —Mʉa, Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ, Cristo mʉ nii —cʉ̃re ĩiupi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesús pea: —Atere jĩcʉ̃ peerena wedeti majuropeecãña —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","To biro ĩicã ñucã: —Yʉ, Ca Nii Majuropeegʉ Macʉ̃a, paʉ ñañarije tamʉo, judíos're ca jʉo niirãre, paia ʉparãre, doti cũuriquere ca jʉo buerãre, ĩa juna eco, jĩa cõa eco, yʉ ca biipera niicãro bii. To biro cʉ̃ja ca tiimijata cãare, itia rʉmʉ jiro yʉ cati tuacoarucu ñucã —ĩi wedeupi Jesús, cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jiro niipetirãre o biro ĩiupi Jesús: —Jĩcʉ̃, yʉ buegʉ ca niirʉgʉ ʉnoa, mʉ majurope mʉ ca tiirʉgarijere yerijãari, to cãnacã rʉmʉra yʉ yee jʉori ñañaro tamʉo pacagʉ, to birora tʉgoeña bayicõa niiña. ");
INSERT INTO baoNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Cʉ̃ ca cati niirijere ca maigʉa, cʉ̃ ca catipere bʉatirucumi. Yʉ yee jʉori ñañaro ca tamʉo yaigʉa, ametʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Bojocʉre ñee pee añurije to tiiti, ati yepa maquẽ apeye niipetirijepʉrena cʉocã pacagʉ, cʉ̃ majuropeera cʉ̃ ca cati niirijere cʉ̃ ca tii yaio nʉcõcãjata? ");
INSERT INTO baoNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Jĩcʉ̃ yʉre ca tʉo nʉnʉjeegʉ nii pacagʉ, yʉ yee maquẽre, yʉ yee quetire, wederʉgatigʉ ca bobo nucũ yujugʉra, yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa, yʉ ca boe baterije, yʉ Pacʉ cʉ̃ ca boe baterije mena, ñucã Ʉmʉreco Pacʉ pʉto macãrã ca ñañarije manirã cʉ̃ja ca boe baterije mena, yʉ ca doori rʉmʉre yʉre ca tʉo nʉnʉjeegʉ cʉ̃ ca niirijere wederʉgʉ, yʉ bobo jañurucu. ");
INSERT INTO baoNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Díámacʉ̃ mʉjare yʉ ĩi: Jĩcãrã ano ca niirã, Ʉmʉreco Pacʉ cʉ̃ ca doti niirijere ĩatirãra bii yaitirucuma —ĩi wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Atere cʉ̃ ca ĩiricaro jiro, jĩcã amo peti, ape amore itiaga penituaro ca niiri rʉmʉri ca nii waaro, ʉ̃tãgʉpʉ juu buegʉ waagʉ, Pedro, Santiago, Juan jãare bapa cʉti waaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Toopʉ cʉ̃ ca juu bue niirora, cʉ̃ diámacʉ̃ cʉ̃ ca bojoca baurije wajoacoaupe. Cʉ̃ jutiro cãa bʉaro boti ajiyaarito biicoaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","To biro cʉ̃ ca bii niiri tabera, ʉmʉa pʉarã baua ea nʉcã, Jesús mena wede peni niiupa. Cʉ̃ja pea Moisés, Elías niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Bʉaro ca ajiyaa boe baterije watoapʉ niicãri, ñañaro Jerusalén'pʉ Jesús cʉ̃ ca bii yaipere wede peni niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedro, to biri cʉ̃ mena macãrã pea bʉaro cʉ̃jare ca wʉgoa eyo pacaro, to birora ĩacã niima ĩirã, Jesús cʉ̃ ca boe baterijere, ñucã ʉmʉa pʉarã cʉ̃ mena ca niirãre ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Cʉ̃re cʉ̃ja ca camotati waarora, Pedro pea cʉ̃ ca ĩirijere “To biirije yʉ ĩicu” ĩiti pacagʉ, o biro ĩiupi Jesús're: —Buegʉ, anopʉ mani ca niijata, añu majuropeecã. To biri itia wii, wii pĩiri mani tiico. Mʉ yaa wii jĩcã wii, ape wii Moisés yaa wii, Elías yaa wii, mani tiirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","To biro cʉ̃ ca ĩi niirora, bueri bʉrʉa cʉ̃jare duwi ñaapea ea, paa ũmaa nʉcõcãupa. Bueri bʉrʉa watoapʉ niirã, bʉaro uwiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","To biro cʉ̃jare ca biiri tabera, bueri bʉrʉa watoapʉ wederique o biro ĩi cojoupa: —Ani niimi yʉ Macʉ̃, yʉ ca beje amiricʉ. Cʉ̃re tʉoya —ĩi wedeoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Tee wederiquere cʉ̃ja ca tʉoro jiro, Jesús jĩcʉ̃ra tua nʉcãcãupi. Cʉ̃ja pea atere cʉ̃ja wado majicã niiupa. Jĩcã cuu, to biro ca biirijere cʉ̃ja ca ĩariquere, jĩcʉ̃ ʉno peerena jĩcã wãme ʉnora wederucu tiitiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ape rʉmʉ, ʉ̃tãgʉ jotoapʉ ca niiricarã cʉ̃ja ca duwi waaro, paʉ bojoca Jesús're bocarã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Jĩcʉ̃ bojoca watoapʉ, Jesús're o biro ĩi cojoupi: —Buegʉ, yʉ macʉ̃ jĩcʉ̃ra ca niigʉre, cʉ̃re ĩaña petopʉra. ");
INSERT INTO baoNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wãtĩ cʉ̃pʉre ñaajãa nʉcã eari, cʉ̃ ca acaro bui mecʉ̃ro tii, cʉ̃ ca dia ñaaro tii, ñucã cʉ̃ ʉjeropʉ jopo witi, cʉ̃ ca biro cʉ̃re tiimi. Ñañaro peti cʉ̃re tiicãmi. Cʉ̃re pitirʉgati majuropeecãmi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mʉ buerã cãare, “Wãtĩre cõa wiene bojaya,” cʉ̃jare yʉ ĩimijãwʉ. Cʉ̃re cõa wiene majitijãwa —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩi yʉʉupi: —¡Agó nija, díámacʉ̃ tʉoti, ca bojoca ñañarã peti nii, ca biirã! ¿No cõro yoaro mʉja mena nii, to biro mʉja ca bii niirijere nʉcã, yʉ bii niigʉti? Ano pee mʉ macʉ̃re ami dooya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Jesús pʉto cʉ̃ ca ea nʉnʉa waarora, wãtĩ pea ñucã yepapʉ cʉ̃re tii cõa cũu cojori, tutuaro cʉ̃ ca yugui mecʉ̃ro tiiupi. To biro cʉ̃ ca tii pacaro, Jesús pea wãtĩre tuti cõa wiene, cʉ̃re tii catio yapano, cʉ̃ pacʉre cʉ̃re tueneupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","To ca niirã niipetirãpʉra Ʉmʉreco Pacʉ do biro ca tiiya manigʉ cʉ̃ ca niirijere ĩa ʉcʉa, do biro pee ĩiticãupa. Niipetirãpʉra Jesús to biro cʉ̃ ca tiirijere ĩa ʉcʉa, do biro pee ĩi majiti, cʉ̃ja ca bii ditoye, o biro ĩiupi Jesús cʉ̃ buerãre: ");
INSERT INTO baoNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Atere añuro tʉori, acoboticãña. Yʉ, Ca Nii Majuropeegʉ Macʉ̃re jĩa dotirã, aperãpʉre yʉre tiicojorucuma —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Cʉ̃ja pea to biro cʉ̃ ca ĩirijere tʉo majitiupa, cʉ̃ja ca tʉo majitipere biro ĩiro, cʉ̃ja ca tʉo puoborijere tii acoboriquere biro cʉ̃jare ca niicãro macã. Ñucã apeyera “To biro mʉ ca ĩirijere jãare wede majioña,” Jesús're ĩi jãiñarʉgarã cãa, uwi jañuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ñucã Jesús buerã cʉ̃ja majurope: —¿Niipe mani mena macʉ̃ ca nii majuropeegʉ cʉ̃ niigʉti? —ameri ĩi wede pai niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús pea to biro cʉ̃ja ca ĩi tʉgoeña wede pai niirijere majiri, jĩcʉ̃ wimagʉre cʉ̃re ami, cʉ̃ pʉto nʉcõri, o biro cʉ̃jare ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","—No ca boogʉ yʉ wãme mena ani wimagʉre ca ñeegʉa yʉrena ñeegʉ tiimi. Ñucã yʉre ca ñeegʉa, yʉre ca tiicojoricʉ cãare ñeegʉ tiimi. To biri mʉja niipetirã watoare, watoa macʉ̃re biro ca niigʉ pee, ca nii majuropeegʉ niimi —ĩiupi Jesús, cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan pea o biro ĩiupi: —Buegʉ, jĩcʉ̃ mʉ wãme mena ĩicãri, ca wãtĩa cõa wiene niigʉre jãa ĩajãwʉ. Mani mena macʉ̃ méé cʉ̃ ca niiro macã, to biro cʉ̃ ca tiirijere, “To biro tiiticãña” cʉ̃re jãa ĩimijãwʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Cʉ̃re camotaaticãña. Manire ca junatigʉa, mani mena macʉ̃ niimi —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mee, Jesús ʉmʉreco tutipʉ cʉ̃ ca tua mʉa waapa tabe ea waaro ca biiro tʉgoeña tutuarique mena Jerusalén'pʉ waagʉ, waa jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","To waa nʉnʉa waagʉ, cʉ̃ja jʉguero tiicojoupi queti wede jʉgueri majare. Cʉ̃ja pea Samaria yepa macã macãpʉ waaupa, cãnirica tabe ama yuerã waarã. ");
INSERT INTO baoNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","To biro cʉ̃ja ca biiro, samaritanos pea “Jerusalén'pʉ waari maja niima,” ĩi ĩa majiri, cʉ̃jare ñeerʉgatiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","To biro cʉ̃ja ca biirijere ĩari, Jesús buerã Juan, Santiago jãa, o biro ĩiupa Jesús're: —Wiogʉ, ¿Elías cʉ̃ ca tiiquĩricarore biro ʉmʉreco tutipʉ maquẽ ca ʉ̃ʉrijere duwi doo dotiri, cʉ̃jare to ca joe batero jãa ca tiiro mʉ booti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","To biro cʉ̃ja ca ĩiro Jesús pea amojode nʉcãri, o biro cʉ̃jare ĩi tutiupi: —Mʉja, wãtĩ cʉ̃ ca tʉgoeñari wãmerena ĩicãrã mʉja ca ĩirijere mʉja majiti. ");
INSERT INTO baoNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yʉ, Ca Nii Majuropeegʉ Macʉ̃a bojocare jĩagʉ doogʉ méé yʉ doowʉ. Cʉ̃jare ametʉenegʉ doogʉ pee yʉ doowʉ —cʉ̃jare ĩiupi Jesús. To biro cʉ̃jare ĩi, ape macã pee waacoaupa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Maapʉ cʉ̃ja ca waa nʉnʉa waaro, jĩcʉ̃ o biro ĩiupi Jesús're: —Wiogʉ, noo mʉ ca waari taberi cõro mʉ mena yʉ waarucu —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —Buu yairoa, cʉ̃ja cãniri operi cʉoma. Minia cãa, cʉ̃ja die batiri cʉoma. Yʉ, Ca Nii Majuropeegʉ Macʉ̃ pea cãnirica tabe ʉnora yʉ cʉoti —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Apĩ peera: —Yʉ mena pee dooya —cʉ̃re ĩiupi Jesús. To biro cʉ̃ ca ĩiro: —Wiogʉ, yʉ pacʉre yʉ yaa jʉogʉ waarʉga ména —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","To biro cʉ̃re cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —“Ca bii yairã majuropeera, ca bii yairãre cʉ̃ja yaajato” ĩicãña. Mʉ pea waari, Ʉmʉreco Pacʉ cʉ̃ ca dotiri tabe maquẽ quetire wede yujugʉja —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Apĩ o biro ĩiupi ñucã: —Wiogʉ, mʉ mena yʉ waarʉga. Ména, yʉ yaa wii macãrãre yʉ waarique wui jʉogʉ waarʉga —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —Ca jee cũu nʉnʉa waagʉ nii pacagʉ, cʉ̃ jiro pee wado ca ĩa tuenecã niigʉa, Ʉmʉreco Pacʉ cʉ̃ ca dotiri tabe maquẽre ca tiipʉ ʉno méé niimi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ate jiro ñucã Wiogʉ, setenta y dos peti beje jeeri, pʉarãri wado cʉ̃ ca waapa taberi macã macãripʉ cʉ̃jare tiicojo jʉgueupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","O biro cʉ̃jare ĩiupi: —Díámacʉ̃ petira ote ca bʉcʉa yapanorije paʉ peti niicã. To ca bii pacaro, paderi maja pea petoacã niima. To biri oterique Ʉpʉre ca dicare ca jeerã dooparã paderi majare cʉ̃ tiicojojato ĩirã, mʉja cʉ̃re jãiña. ");
INSERT INTO baoNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Waarãja mʉja. Tʉoya. Ecaricarã oveja punare biro ca niirãre, macãnʉcʉ̃ yaia ca wiorã watoapʉre mʉjare yʉ tiicojo. ");
INSERT INTO baoNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wajopoa ʉnora, wapa tiirica tiiri mʉja ca jãari poari ʉnora, dʉpo juti mʉja ca wajoa jãña pee ʉnora, jee waaticãña. Ñucã maapʉ cãare jĩcʉ̃ peerena jãiña tua nʉcã, tiiticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","”Jĩcã wiire jãa waarã, o biro cʉ̃jare ĩi añu doti jʉoya: “Ati wii macãrãre añuro niirique to niijato,” ĩiña. ");
INSERT INTO baoNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tii wiire jĩcãri cõro añuro ca niirã cʉ̃ja ca niijata, añuro cʉ̃ja ca niiro mʉja ca boorije mʉja ca boorore birora cʉ̃jare biirucu. Teere ca bootirã cʉ̃ja ca niijata, añuro niirique mʉja peera yai nʉcãtirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Mʉjare cʉ̃ja ca nii dotiri wiira niicãña. Tii wii macãrã cʉ̃ja ca cʉorijera baa, jini, tiicã niiña. Paderi majʉa, cʉ̃ ca paderije wapare wapa ñee majimi. Wiijeri cõro waa nucũ yuju tiiticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","”Jĩcã macãre mʉja ca earo, añuro mʉjare cʉ̃ja ca bocajata, baarique mʉjare cʉ̃ja ca ecarijera baa, ");
INSERT INTO baoNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","tii macã macãrã ca diarique cʉtirãre catio, ñucã o biro cʉ̃jare ĩi wedeya: “Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti niirije mʉja pʉtora nii yerijãa,” cʉ̃jare ĩiña. ");
INSERT INTO baoNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Jĩcã macãre mʉja ca earo, tii macã macãrã mʉjare cʉ̃ja ca bootijata, macã yepa pee waari, o biro cʉ̃jare ĩiña: ");
INSERT INTO baoNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Mʉjare jãa ca wederijere mʉja ca tʉorʉgatirije jʉori mʉja yee wapa ñañaro mʉja tamʉorucu, mʉjare ĩirã, mʉja yaa macã maquẽ jita, jãa dʉporipʉre ca ea tuarique menapʉrena jãa paa bate. Biirãpʉa atere majiña, Ʉmʉreco Pacʉ cʉ̃ ca doti niirije mee mʉja pʉtora nii yerijãa,” cʉ̃jare mʉja ĩi wederucu. ");
INSERT INTO baoNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yʉ pea o biro mʉjare yʉ ĩi: “Ñañaro tamʉorica rʉmʉ ca niiro, Sodoma macãrã ametʉenero ñañaro tamʉorucuma tii macã macãrã,” yʉ ĩi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—¡Abé nija mʉja Corazín, Betsaida macãrã! Mʉja watoare ca ĩa ñaaña manirije yʉ ca tii bau niiriquere Tiro, Sidón macãrã peere cʉ̃jare yʉ ca tii ĩñojata, tĩrʉmʉpʉra ñañarije cʉ̃ja ca tiiriquere tʉgoeña yeri wajoari, Ʉmʉreco Pacʉ peere tʉo nʉnʉjeebojacupa. Cʉ̃ja ca tʉgoeña wajoarijere ĩñorã, boori juti jãña, õwarena duwi, biibojacupa. ");
INSERT INTO baoNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","To biri Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niirore, Tiro, Sidón macãrã ametʉenero ñañaro mʉja ca tamʉope niirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Mʉja Capernaúm macãrã, “¿Ʉmʉreco tutipʉ jãa ami mʉa waa ecorucu,” mʉja ĩi tʉgoeñati? Mʉja biiticu. Ca ʉ̃cʉ̃ari opere bʉaro ca ʉ̃cʉ̃a majuropeeri tabepʉ mʉja duwi nʉcãcoarucu. ");
INSERT INTO baoNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","”Mʉja ca wederijere ca tʉorã, yʉrena tʉorã tiima. Mʉjare ca junarã, yʉrena junacãrã tiima. Yʉre ca junarã, yʉre ca tiicojoricʉpʉre cʉ̃re junarã tiima —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Jiro, setenta y dos niirã, bʉaro ʉjea niirique mena o biro ĩi tua eaupa: —Wiogʉ, mʉ wãme mena jãa ca ĩijata, wãtĩapʉ cãa, jãa ca dotirore biro biicãma —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiupi Jesús: —Satanás, ʉmʉreco tutipʉ ca niimiricʉ, bʉpo cʉ̃ ca yaberore biro cʉ̃ ca bii ñaaduwi dooro cʉ̃re yʉ ĩajãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Tʉgoeña yeri tutuariquere mʉjare yʉ tiicojowʉ, aña, cotiapa jotoara waa, ñucã mani waparã yʉʉ wãtĩ cʉ̃ ca tutuarijere ñañaro tamʉoricaro maniro, mʉja ca bii ametʉa nʉcãpere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Wãtĩa yeri mʉja ca dotirore biro cʉ̃ja ca biirijerena ĩa ʉjea niiticãña. Mee, mʉja wãme Ʉmʉreco Pacʉ pʉtopʉ owa tuurique ca niirije pee docare ʉjea niiña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Tii nimarora, Añuri Yeri jʉori bʉaro ʉjea niirique mena o biro ĩiupi Jesús: —Mʉre yʉ baja peo nʉcʉ̃ bʉo Cáacʉ, ati ʉmʉreco, ati yepa Ʉpʉre. Ca majirãre, ca tʉo puorãre, mʉ ca yaioriquere watoa macãrã peere mʉ ĩño. Ʉ̃gjá, añu Cáacʉ, o biirijera ca biiro mʉ boowʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","”Yʉ Pacʉ, niipetirijepʉrena yʉre tiicojowi. Jĩcʉ̃ ʉno peera, cʉ̃ Macʉ̃ yʉ ca niirijere majitima. Yʉ Pacʉ wado majimi. Ñucã jĩcʉ̃ ʉno peera, yʉ Pacʉ cʉ̃ ca niirijere majitimi. Yʉ cʉ̃ Macʉ̃, to biri cʉ̃ Macʉ̃ yʉ ca boorã wadore cʉ̃ja ca majiro yʉ ca tiirã wado majima —ĩi ʉjea niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","To biro ĩi yapano, amojode nʉcã, cʉ̃ buerã wadore o biro cʉ̃jare ĩiupi: —Ʉjea niiña mʉja, ano mʉja ca ĩarijere ca ĩarã. ");
INSERT INTO baoNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Paʉ Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, wiorã, ate mʉja ca ĩarijere ĩarʉgamiupa. To biro bii pacarã ĩatiupa. Ñucã ate mʉja ca tʉorijere tʉorʉgamiupa. To biro bii pacarã tʉotiupa —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Jĩcʉ̃ doti cũuriquere ca jʉo bueri majʉ Jesús mena wede penigʉ waaupi. Cʉ̃ pea, “¿Do biirije peti yʉre cʉ̃ yʉʉgʉti?” ĩigʉ, o biro cʉ̃re ĩi jãiñaupi: —Buegʉ, ¿ñee yʉ tiigajati, to birora caticõa niiriquere cʉorʉgʉ? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","To biro cʉ̃ ca ĩiro Jesús pea o biro cʉ̃re ĩi yʉʉupi: —¿Doti cũuriquepʉre do biro ĩi owarique to niiti? ¿Mʉa teere, “Do biirije ĩi,” mʉ ĩi bue tʉo jeeñoti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","To biro cʉ̃re cʉ̃ ca ĩiro, doti cũuriquere jʉo bueri majʉ pea o biro cʉ̃re ĩi yʉʉupi: —“Ʉpʉ, mʉ Ʉmʉreco Pacʉre mʉ yeri niipetiro mena, mʉ ca catirije niipetiro mena, mʉ ca tutuarije niipetiro mena, mʉ ca tʉgoeñarije niipetiro mena, cʉ̃re maiña. Ñucã mʉ pʉto macãrã cãare mʉ upʉre mʉ ca mairore birora cʉ̃jare maiña,” ĩi owarique nii —cʉ̃re ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","To biro cʉ̃ ca ĩiro tʉogʉ, o biro cʉ̃re ĩiupi Jesús: —Díámacʉ̃ra mʉ ĩi. Teere mʉ ca tiijata, to birora caticõa niiriquere mʉ cʉorucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Cʉ̃ pea, “Ca bojoca añugʉ niimi” yʉre cʉ̃ ĩijato ĩigʉ, o biro cʉ̃re ĩi jãiña nemoupi ñucã Jesús're: —¿Ñiru cʉ̃ niiti, yʉ pʉto macʉ̃? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: —Jĩcʉ̃ bojocʉ Jerusalén ca niiricʉ Jericó pee waagʉ bua nʉnʉa waaupʉ. Toopʉ cʉ̃ ca waaro, jĩcãrã jee dutiri maja cʉ̃re ñeeri, cʉ̃ ca cʉomiriquere, to biri cʉ̃ juti menapʉra ẽma peti, cʉ̃re paa, ca bii yaibogʉpʉ cʉ̃re tii cõa cũu, waacoauparã. ");
INSERT INTO baoNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","To biro cʉ̃re cʉ̃ja ca tii cõa cũu waaro jiro, jĩcʉ̃ pai tii maarena waaupʉ. Cʉ̃re ĩagʉra, woa ametʉa waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cʉ̃ ca ametʉa waaro jiro ñucã levita cãa cʉ̃ ca niiri tabere eaupʉ. Cʉ̃ cãa cʉ̃re ĩagʉra, woa ametʉa waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Cʉ̃ja jiro, Samaria macʉ̃ cãa tii maarena ca waagʉ, cʉ̃re ĩagʉra, bʉaro cʉ̃re boo paca ĩaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","To biri cʉ̃ pʉto pee waa, cʉ̃ camire ʉje oco, to biri ʉje mena cʉ̃re ʉco tiiupʉ. Cʉ̃re ʉco tii yapano, jutiro daa mena cʉ̃ camire dʉdʉa, jiro cʉ̃ yʉʉ burro jotoara cʉ̃re ami peo, amicoaupʉ, waa yujuri maja cʉ̃ja ca cãniri wiipʉ. Toopʉ cʉ̃re ami eari, cʉ̃re coteupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ape rʉmʉ Samaria macʉ̃ pea waa yujuri maja cʉ̃ja ca cãniri wii ʉpʉre pʉa rʉmʉ pade wapa taaricaro cõro wapa tiirica tiiri cʉ̃re tiicojo, o biro cʉ̃re ĩiupʉ: “Anire añuro cʉ̃re coteya. Apeye cʉ̃ jʉori mʉ yeere mʉ ca tii batejata, tua doogʉ mʉre yʉ wapa tiirucu,” ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","To biicãri yua, ¿anija itiarã watoare, jee dutiri maja cʉ̃ja ca paa jĩa cõa cũuricʉre, niipe cʉ̃ pʉto macʉ̃re biro cʉ̃ tiijapari? —cʉ̃re ĩi jãiñaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","To biro cʉ̃re cʉ̃ ca ĩi jãiñaro, doti cũuriquere ca jʉo buegʉ pea: —Cʉ̃re ca boo paca ĩaricʉ pee —cʉ̃re ĩi yʉʉupi. To biro cʉ̃ ca ĩiro: —Mʉ cãa, waa, cʉ̃ ca tiiricarore birora tiigʉja —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús cʉ̃ buerã mena waa nʉnʉa waagʉ, jĩcã macãpʉ cʉ̃ ca earo, Marta ca wãme cʉtigo, cõ yaa wiipʉ cʉ̃re cãni dotiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta, jĩcõ baio cʉtiupo, María ca wãme cʉtigo. Cõ pea Jesús pʉto ea nuuri, cʉ̃ ca ĩirijere tʉocã duwiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Marta pea paʉ paderique cõ ca tiirije pee wadore ĩa nʉnʉjee pade niima ĩigo, cõ baio to biro cõ ca bii weoro ĩari, Jesús pʉto pee waa, o biro cʉ̃re ĩiupo: —Wiogʉ, ¿mʉra, yʉ baio ate niipetirije paderiquere yʉre tii nemori méé, yʉ jĩcõrena cõ ca cũujata, to añucãti? “Cõre tii nemogoja,” cõre ĩiña petopʉra —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","To biro cõ ca ĩiro tʉogʉ, o biro cõre ĩi yʉʉupi Jesús: —Marta, mʉa paʉ peti paderique cʉoma ĩigo, bʉaro mʉ tʉgoeñarique pai. ");
INSERT INTO baoNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Jĩcã wãmera tiiricaro añu. Ca nii majuropeerije peere bʉamo María. To biri jĩcʉ̃ ʉno peera cõre ẽmatirucumi —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Jĩcãti, jĩcã tabepʉ juu bue niiupi Jesús. Cʉ̃ ca juu bue yapanoro, jĩcʉ̃ cʉ̃ buegʉ o biro cʉ̃re ĩiupi: —Wiogʉ, Juan cʉ̃ buerãre cʉ̃ ca buericarore biro jãa cãare juu bue bueya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","To biro cʉ̃ ca ĩiro, o biro cʉ̃jare ĩiupi Jesús: —Juu buerã o biro ĩiña: “Cáacʉ, ʉmʉreco tutipʉ ca niigʉ, mʉ wãme ĩi nʉcʉ̃ bʉorica wãme to niijato. Mʉ ca dotirije to doojato. Ʉmʉreco tutipʉre mʉ ca boori wãme mʉ ca tiirore birora tiiya ati yepa cãare. ");
INSERT INTO baoNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jãa ca baapere to cãnacã rʉmʉra jãare tiicojoya. ");
INSERT INTO baoNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ñañarije jãa ca tiiriquere jãare acoboya, jãa cãa, niipetirãpʉrena ñañaro jãare cʉ̃ja ca tiirijere jãa ca acoborucurore birora. Ñañarije ca bii bui yeerijere jãa ca tiiro jãare tiiticãña; tiitigʉra ñañarijere jãare ametʉeneña,” ĩi juu bueya —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","O biro cʉ̃jare ĩiupi ñucã: —Jĩcʉ̃ mʉja mena macʉ̃, cʉ̃ mena macʉ̃ cʉ̃ ca cʉojata, ñami decomacã cʉ̃ pʉto waari, o biro cʉ̃re ĩibocumi: Yʉ mena macʉ̃, itiaga pan'gaari yʉre wajoya. ");
INSERT INTO baoNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yʉ mena macʉ̃ yoaropʉ ca dooricʉ yʉ yaa wiire eami, yʉ pea cʉ̃re yʉ ca ecape ʉno yʉ cʉoticã. ");
INSERT INTO baoNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","To biro cʉ̃ ca ĩiro, wii jupeapʉ ca niigʉ pea: “Yʉre pato wãcõticãña. Mee, jope biaricaropʉ nii. Yʉ puna, yʉ cãa, cãnirã jãa tii. Wãcãñaari mʉre yʉ tiicojogʉ waa majiti,” cʉ̃re ĩi yʉʉbocumi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Cʉ̃ mena macʉ̃ nii pacagʉ, wãcãri cʉ̃ ca tiicojorʉgatirije ca nii pacaro, to birora cʉ̃re cʉ̃ ca ĩi pato wãcõcã niirije ca niiro macã, wãcãri, cʉ̃ ca boorije cõro cʉ̃re tiicojocumi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","”To biri o biro mʉjare yʉ ĩi: Ʉmʉreco Pacʉre jãiña, mʉja ca jãirijere mʉjare tiicojorucumi. Amaña; amarã mʉja bʉarucu. Jopepʉ eari jʉoya, mʉja pãa ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","To biri ca jãigʉ cõrora, cʉ̃ ca jãirijere tiicojo ecomi; ca amagʉ cãa, cʉ̃ ca amarijere bʉami. To biri ñucã jopere eari ca jʉogʉ cãa, jope pãa ecomi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","”¿To docare mʉja, ca puna cʉtirã, mʉja puna, baarique cʉ̃ja ca jãijata, ʉ̃tãgarena mʉja tiicojocãgajati? ¿Wai cʉ̃ja ca jãijata, añarena mʉja tiicojocãgajati? ");
INSERT INTO baoNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿Ñucã ãbocʉ die cʉ̃ja ca jãijata, cotiaparena cʉ̃jare mʉja tiicojocãgajati? ");
INSERT INTO baoNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Mʉja, ca bojoca ñañarã nii pacarã, mʉja punare añurije cʉ̃jare mʉja tiicojo maji. Mʉja Pacʉ ʉmʉreco tutipʉ ca niigʉ doca, ametʉenero Añuri Yerire mʉjare tiicojorucumi, cʉ̃re ca jãirãre —cʉ̃jare ĩiupi Jesús, cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jĩcãti Jesús, jĩcʉ̃ ʉmʉre ca wedetigʉ cʉ̃ ca tuaro ca tiiricʉ wãtĩre cõa wienegʉ tiiupi. Wãtĩ cʉ̃ ca witi waarora, ca wedetimiricʉ wedecoaupi. To biro cʉ̃ ca biiro, bojoca pea ĩa ʉcʉa, ñee pee ĩiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","To cʉ̃ ca biiro, jĩcãrã o biro ĩiupa: —Anira, Beelzebú, wãtĩa wiogʉ majuropeera cʉ̃ ca yeri tutuarijere cʉ̃re tiicojojapi. To biri wãtĩare cõa wiene majimi —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Aperã pea, “¿No cõro majicãri cʉ̃ tiiti?” ĩirã, cʉ̃re ĩi ñaarã, “Ʉmʉreco tutipʉ maquẽ ca bii ĩñorije ca ĩa ñaaña manirije jãare tii bau nii ĩñoña,” ĩiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Cʉ̃ pea to biirije cʉ̃ja ca ĩi tʉgoeñarijere ca majicãgʉ niiri, o biro cʉ̃jare ĩiupi: —Jĩcã yepa macãrãra, cʉ̃ja majuropeera camotaticãri cʉ̃ja ca ameri ĩa tuti niijata, cʉ̃ja majuropeera ameri jĩa peticã yai waacuma. Ñucã jĩcã wii macãrãra cʉ̃ja ca ameri tutijata, jĩcã wiira nii majiticuma. ");
INSERT INTO baoNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","To birora Satanás cãa cʉ̃ majuropeera cʉ̃ yaarã menara cʉ̃ ca ameri quẽejata, ¿to docare do biro pee tiicãri, yoaro cʉ̃ doti tutua maji niibogajati? Atere o biirije mʉjare yʉ ĩi: “Beelzebú cʉ̃ ca yeri tutuarije mena wãtĩare cõa wienemi,” yʉre mʉja ca ĩiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","To docare to biro to ca biijata, “Mʉja ca buerijere ca tʉo nʉnʉjeerã peera, ¿ñiru cʉ̃ tiicojoti wãtĩare cʉ̃ja ca cõa wiene tutua majipere?” To biri cʉ̃jara, ñañaro mʉjare tiicãrucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ʉmʉreco Pacʉ cʉ̃ ca tutuarije mena wãtĩare yʉ ca cõa wienerije to ca niijata, “Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti niirije mʉjapʉre ca ea yerijãarijere ĩiro bii.” ");
INSERT INTO baoNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","”Jĩcʉ̃ ʉmʉ ca tutuagʉ, añuro beju cʉticãri, cʉ̃ yaa wiire cʉ̃ ca cotejata, cʉ̃ yee añuro niicã. ");
INSERT INTO baoNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","To ca bii pacaro, apĩ cʉ̃ ametʉenero ca tutuagʉ ea, cʉ̃re cʉ̃ ca quẽe ametʉene nʉcãcãjata, cʉ̃ beju, “Tee jʉori yʉ ametʉarucu,” cʉ̃ ca ĩi tʉgoeña bayimiriquere ẽma, cʉ̃ yee ca niimirique niipetiro menara tuacãcumi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","”Yʉ mena ca niitigʉa, yʉre ca junagʉ niimi. Yʉ mena ca jee neo niitigʉa, no ca boorora dee batecãmi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","”Jĩcʉ̃ wãtĩ bojocʉpʉre ca niiricʉ witi waagʉ, ca bopori yeparipʉ waa yujucumi, cʉ̃ ca yerijãa niipa tabere ama yujugʉ. Tii tabe bʉatigʉ, o biro ĩi tʉgoeñacumi: “Jaʉ, yʉ yaa wii yʉ ca witi weorica wiipʉra yʉ tua waarucu ñucã,” ĩicumi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tua eagʉ, jĩcã wii añuro owa batecã, añuro quenocã, tiirica wiire biro cʉ̃ ca niiro cʉ̃re ĩacumi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","To biri waa, aperã wãtĩa jĩcã amo peti, ape amore pʉaga penituaro niirã cʉ̃ ametʉenero ñañarã petire cʉ̃jare jʉo neo, cʉ̃ja mena jĩcãri bojocʉpʉre jãacuma, cʉ̃pʉre niirã waarã. To biri jʉguero cʉ̃ ca biiricaro ametʉenero ñañaro peti tamʉocumi yua —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Atere Jesús cʉ̃ ca ĩi niiro, jĩcõ nomio bojoca watoapʉ o biro ĩi acaro buiupo: —Bʉaro ʉjea niicumo, mʉre macʉ̃ cʉtiri, mʉre ca ũpũo majorico —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús pea o biro cõre ĩi yʉʉupi: —Ʉmʉreco Pacʉ wederiquere tʉori, tee ca ĩirore biro ca tii nʉnʉjeerã pee doca ʉjea niima —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Paʉ bojoca Jesús pʉtopʉ cʉ̃ja ca nea poo nʉnʉa dooro ĩa, o biro cʉ̃jare ĩi wede jʉo waaupi: —Ati rʉmʉri macãrã bojoca ñañarã peti niima. Jĩcã wãme ca ĩa ñaaña manirije tii bau nii ĩñorique booma. To biro cʉ̃ja ca ĩimijata cãare, ape wãme tii ĩño nemoña manirucuma, Jonás cʉ̃ ca biirique ʉno wadore ĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jonás, Nínive macãrãre cʉ̃ ca bii ĩñoricarore birora, yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa ati cuu macãrãre yʉ bii ĩñorucu. ");
INSERT INTO baoNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ʉmʉreco Pacʉ ati cuu macãrãre cʉ̃ ca ĩa bejeri rʉmʉ ca niiro, ʉpo Sabá macõ cati tuari, ñañaro mʉjare tiirucumo. Cõ pea, ca yoaropʉ ca niiricora dooupo, Salomón cʉ̃ ca majirijere tʉorʉgo. Mʉja pea, Salomón ametʉenero ca majigʉre mʉja pʉto yʉre mʉja cʉo. ");
INSERT INTO baoNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nínive macãrã cãa, ati cuu macãrãre Ʉmʉreco Pacʉ cʉ̃ ca ĩa bejeri rʉmʉ ca niiro cati tuari, ñañaro mʉjare tiirucuma. Nínive macãrã pea Jonás cʉ̃ ca wederijere tʉo, ñañarije cʉ̃ja ca tiiriquere tʉgoeña yeri wajoari, Ʉmʉreco Pacʉ peere tʉo nʉnʉjeeupa. Mʉja, Jonás ametʉenero ca niigʉre mʉja pʉto yʉre mʉja cʉo —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Jĩcʉ̃ peera jĩa boericagare, yaioropʉ cũu, upa coro docapʉ cũu, tiirʉga méé jĩa tuami. Emʉaro pee peomi, bojoca ca jãa doorãre to ʉ̃ʉ boejato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Mʉja cape mʉja upʉre ca jĩa boerije nii, mʉja cape añurije pee wadore ca ĩa majirije to ca niijata, mʉja upʉ niipetiro añurije wadore tii niirucu. Mʉja cape ñañarije to ca niijata, mʉja upʉ niipetiro ñañarije wado tiirucu. Mʉja yeri Ʉmʉreco Pacʉ mena añuro to ca niitijata, añurijere mʉja tii majitirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bojoca catiri niiña, Ʉmʉreco Pacʉ yee mʉ ca majirije jĩa boeriquere biro mʉpʉre ca niirije ca naitĩarije peere biro biire ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","To biri mʉ upʉ niipetiropʉra, ca naitĩarije ʉnoacã cʉoricaro maniro ca boerijere to ca cʉojata, ca ʉ̃ʉ boerica añuro mʉre ca ʉ̃ʉ boero añuro mʉ ca ĩacãrore birora añurije wadore mʉ tii maji niirucu —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesús to biro cʉ̃ ca ĩi wede yapanoro, jĩcʉ̃ fariseo: “Yʉ yaa wiipʉ baagʉ dooya,” cʉ̃re ĩiupi. To biro cʉ̃ ca ĩiro cʉ̃ mena waa, cʉ̃ yaa wiipʉ jãa waa, baarique peorica pĩi pʉto ea nuu waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","To biro cʉ̃ ca biiro fariseo pea, baarʉgarã jʉguero cʉ̃ja ca amo coerucurore biro cʉ̃ ca tiitiro ĩari, “¿Ñee tiigʉ to biro cʉ̃ biiti?” cʉ̃re ĩi ĩa muiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wiogʉ pea, o biro cʉ̃re ĩiupi: —Mʉja fariseos, bau niiro niirã wado, añuro mʉja tiirique cʉti. Jotʉ baparire jotoare coecã pacarã, jupea peere ca coeya manirijere biro mʉja bii. To biri mʉja yeri peera mʉja ca boo tʉgoeñarije, ñañarije mʉja ca tiirʉgarije pee wado nii ametʉene nʉcãcã. ");
INSERT INTO baoNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Ca tʉgoeña bojoca catitirã! ¿“Jotoare ca tiiricʉra, jupea cãare tiijacupi,” mʉja ĩi majititi? ");
INSERT INTO baoNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ca boo pacarãre tii nemorã, mʉja yeripʉ cʉ̃jare mʉja ca mai ĩarije mena tiiya. To biro tiirã, niipetirijepʉrena añurã mʉja niirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","”Ñañaro mʉja biirucu mʉja fariseos, Ʉmʉreco Pacʉre, pũu ca jʉti añurije menta, ruda, ñucã mʉja ote ca niiro cõrorena pʉa amo cõro ca niirijere jĩcã tabe wado jee dica woori ca tiicojorã nii pacarã, añurije peera tii nʉnʉjeeti, Ʉmʉreco Pacʉ cʉ̃ ca mai dotirique peera tiiti, mʉja ca biirije jʉori. Atere ca tii niiparã mʉja nii, apeye mʉja ca tii niirucurije cãare tii yerijãatirãra. ");
INSERT INTO baoNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","”Ñañaro mʉja biirucu mʉja fariseos, nea poo juu buerica wiijeripʉre añuri taberipʉ wado duwirʉga, ñucã wiije watoa macã yepari waarã cãa, bojoca añuro nʉcʉ̃ bʉorique mena mʉjare añu doti, cʉ̃ja ca tiiro ca boorãre. ");
INSERT INTO baoNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","”Ñañaro mʉja biirucu mʉja, mʉja ca ĩirore biro ca tiitirã, maja ope ca bautiro bojoca tii ope jotoara waa pacarã, “Tii ope niicu,” ĩi majiri méé cʉ̃ja ca ʉta ametʉa waarore biro ca biirãre —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","To biro cʉ̃ ca ĩiro, jĩcʉ̃, doti cũuriquere ca jʉo buegʉ o biro cʉ̃re ĩi yʉʉupi Jesús're: —Buegʉ, atere o biro ĩigʉ jãa menapʉrena ajienerije mʉ ĩi jĩi —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩiupi: —Ñañaro mʉja biirucu mʉja, doti cũuriquere ca jʉo buerã cãa. Aperãre tii dotirã, mʉja ca ĩirore biro ca tii peoti majiña manirijepʉre ca tii dotirã nii pacarã, mʉja pea mʉja ca dotirijere petoacã tiirʉgarucu, mʉja tiiti majuropeecã. ");
INSERT INTO baoNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","”Ñañaro mʉja biirucu, mʉja ñicʉ̃ jãa niiquĩricarã Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare cʉ̃ja ca jĩaricarã maja operi jotoarire wiijeri ca tii peo nʉnʉjeerã. ");
INSERT INTO baoNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","To biro mʉja ca tiirije mena mʉja ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tiiriquere “ ‘Añu majuropeecã,’ ca ĩirã niima,” ĩi ĩa majiricaro mʉja tii. Cʉ̃ja, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare jĩaupa. Mʉja pea cʉ̃ja maja operire mʉja queno nʉnʉjee. ");
INSERT INTO baoNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","To birira Ʉmʉreco Pacʉ cʉ̃ ca majirije mena o biro ĩiupi: “Yʉ yee quetire ca wede jʉgueparã, yʉ yee añurije quetire ca wedeparãre yʉ tiicojorucu. To biro yʉ ca tiirãre jĩcãrãre cʉ̃jare jĩa, aperãra ñañaro tiirʉgarã cʉ̃jare nʉnʉ, tiirucuma,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","To biri Ʉmʉreco Pacʉ, ati yepare cʉ̃ ca tii jʉori tabepʉra ca biipere wede jʉgueri majare cʉ̃ja ca jĩa díi tii bate nʉnʉa dooricarã niipetirã yee wapa, ");
INSERT INTO baoNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Abel niiquĩricʉ díi wapa menapʉ, to biri Zacarías're waibʉcʉrã joe mʉenerica tutu mena, to biri ca ñañarije maniri jawi watoare cʉ̃ja ca jĩaquĩricʉ díi menapʉ, ati cuu macãrã bojocare wapa jãirucumi. To biri cʉ̃ja, cʉ̃ja ca bii yairique wapare ati cuu macãrãpʉre wapa jãirucumi Ʉmʉreco Pacʉ,” mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","”Ñañaro mʉja biirucu mʉja doti cũuriquere ca jʉo buerã majiriquere ca jee uparicarã. Mʉja majuropeecã tʉo majiti, ñucã ca tʉo majirʉgarãre díámacʉ̃ wede majioti, mʉja biicã —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Atere to biirije cʉ̃jare ĩi, to ca niiricʉ cʉ̃ ca witi waaro, doti cũuriquere ca jʉo buerã, to biri fariseos bʉaro ajiari, paʉ wãmeri cʉ̃re jãiña pato wãcõ jʉo waaupa, ");
INSERT INTO baoNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","“Bojoricaro cʉ̃ ca ĩi bui cʉtiro, cʉ̃re mani wedejãajaco,” ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","To biro cʉ̃ ca ĩi niiri tabera, paʉ bojoca cʉ̃ja majuropeera ameri waa doca jañuripʉ Jesús pʉtore bii nea poo nʉnʉa dooupa. To biro cʉ̃ja ca biiro Jesús pea, cʉ̃ buerã peere o biro cʉ̃jare ĩi wede jʉoupi: —Tʉo majiña fariseos yee baarique ca wauaro ca tiirije cʉ̃ja ca cʉorije menare, o biro pee ĩijata, watoara cʉ̃ja ca bii dito niirijere. ");
INSERT INTO baoNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jĩcã wãme ʉno peera, jĩcãrãra majirique majiña manirijera biicã yerijãawa, ca biirije mani. Ñucã yaioropʉ ca niirije cãa, majiña manirijera biicã yerijãa waa, biiti. ");
INSERT INTO baoNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","To biri niipetirije ca naitĩaropʉ mʉja ca ĩiriquere, añuro ʉmʉreco ca boeropʉ tʉorique niirucu. Ñucã mʉja wado jope bia jãa waari yaioroacã mʉja ca ĩirique cãare, wii jotoa pee mʉa peari acaro bui wede baterucuma —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","—Mʉja, yʉ mena macãrã peera o biro mʉjare yʉ ĩi: Ca jĩarãre uwiticãña; upʉ petira jĩacã pacarã, jiropʉra do biro tii majiticuma. ");
INSERT INTO baoNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","“¿Ñiru peere ca uwipe to niiti?” Jĩacãri jiropʉ cãare, catiro jãñariquepʉ cãare pecame ca ʉ̃ʉ yatitiri pecamepʉ ñañaro ca tii yaiogʉ docare cʉ̃re uwiya. Ʉ̃gjá. Yee méé mʉjare yʉ ĩi. Cʉ̃ docare uwiya. ");
INSERT INTO baoNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","”¿Wapa tiirica tiiri pʉa tiiacã wapara jĩcã amo cõropʉ miniare to noniña maniti? To biro tiicãrique to ca nii pacaro, Ʉmʉreco Pacʉ pea jĩcʉ̃ ʉnorena cʉ̃jare acoborucu tiitimi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mʉja cãare, mʉja dʉpʉga maquẽ poare cõo peotiriquepʉ cʉomi. To biri uwiticãña. Mʉja doca paʉ minia ametʉenero ca wapa cʉtirã mʉja nii —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","—No ca boogʉ yʉre ca tʉo nʉnʉjeegʉ yʉ yee maquẽre bojocare cʉ̃ ca wedejata, yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa, Ʉmʉreco Pacʉ pʉto macãrãre cʉ̃ yee maquẽre yʉ wede bojarucu. ");
INSERT INTO baoNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Yʉre ca tʉo nʉnʉjeegʉ nii pacagʉ, bojocare yʉ yee maquẽre ca wede junagʉra, cʉ̃ cãa to birora cʉ̃ yee maquẽre Ʉmʉreco Pacʉ pʉto macãrãre wede boja ecotirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Yʉ, Ca Nii Majuropeegʉ Macʉ̃re, jĩcʉ̃ ñañarije cʉ̃ ca ĩicãmijata cãare, to biro cʉ̃ ca ĩiriquere acobocãrucumi Ʉmʉreco Pacʉ. To ca bii pacaro, Añuri Yerire ñañarije ca ĩi wede paigʉ doca, ñañaro cʉ̃ ca ĩiriquere acobo ecotirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","”Mʉjare, nea poo juu buerica wiijeripʉ, ʉparã pʉtoripʉ cʉ̃ja ca ñee waaro, “¿Do biri wãme mani ĩi ametʉarãti? ¿Do biro cʉ̃jare mani ĩi yʉʉrãti?” ĩi tʉgoeñarique paiticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mʉja ca wedepa tabe ca earo, mʉja ca wedepere mʉjare majiorucumi Añuri Yeri —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","To biro cʉ̃ ca ĩi niiro, jĩcʉ̃, bojoca watoapʉ ca niigʉ, o biro ĩiupi Jesús're: —Buegʉ, jãa pacʉ niiquĩricʉ cʉ̃ ca cũu yairije yʉ jũwʉ cʉ̃ ca cʉorijere “Cʉ̃ yee ca niirijere cʉ̃re noniña,” yʉre ĩi bojaya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Yʉ mena macʉ̃, “¿Ñiru yʉre, mʉja watoare, mʉja ca tii niirijere ĩa beje, mʉja ca cʉorijere dica woo, tii niiña,” yʉre cʉ̃ ĩijapari? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","To biro ĩi, bojocare o biro cʉ̃jare ĩi wedeupi Jesús: “Bojoca catiya, niipetirije boo tʉgoeñarique menare. Mani ca cati niirijea paʉ mani ca apeye jee cũu cʉo niirije jʉori méé nii.” ");
INSERT INTO baoNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","To biro cʉ̃jare ĩi, ati wãme ĩi cõoñari cʉ̃jare wedeupi: —Niiupʉ jĩcʉ̃, ca apeye paigʉ. Cʉ̃ yaa yeparire, cʉ̃ oterique pairo cʉ̃re dica cʉti bojaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","To biro ca biiro, “¿Do biro yʉ tiigʉti? Yʉ otere yʉ ca queno cũupa tabe yʉ cʉoti,” ĩi tʉgoeñaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Jaʉ. Mee yʉ maji yʉ ca tiipere. Yʉ ote dicare yʉ ca queno cũuri wiijerire wee bateri, ape wiijeri, paca wiijeri jañuro yʉ tiigʉda, tii wiijeripʉ yʉ ote dica niipetirore, yʉ ca cʉorije niipetirijere cũurʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","To biro tii yapano, o biro yʉ ĩirucu, yʉ ca cati niirijere: ‘Yʉ mena macʉ̃, paʉ cʉ̃mari mʉ ca cʉo niipere mee pairo queno cũurique mʉ cʉo. To biri yerijãa, baa, jini, mʉ ca catiri rʉmʉrire ʉjea nii, tiicã niiña,’ yʉ ĩirucu,” ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","”To biro cʉ̃ ca ĩiro, Ʉmʉreco Pacʉ pea o biro cʉ̃re ĩiupʉ: “Ca tʉgoeña bojoca catitigʉ, ati ñamira mʉ yerire ẽmacãrã doorã tiima. Mʉ ca queno cũu cʉo niirije pea ¿ñiru yee to niiroti?” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","”O biirije bii, pairo apeye cʉti pacagʉ, pai jañuro cʉ̃ yee ca niipe wadore ca apeye jee cũu niigʉra, Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojoro peera ca boo pacagʉ niimi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","To biro ĩi yapano, cʉ̃ buerãre o biro cʉ̃jare ĩiupi Jesús: —To biri o biro mʉjare yʉ ĩi: Baarique mʉja ca baa cati niipere, juti mʉja ca jãñaperena tʉgoeñarique paiticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Mani ca cati niirijea baarique ametʉenero wapa cʉti, mani upʉ cãa juti ametʉenero wapa cʉti. ");
INSERT INTO baoNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Minia, wai aare ĩaña. Otere oteti, ote dicare jeeti, baarique queno cũurica wii cʉoti, ote dica queno cũurica tabe ʉnora cʉoti, biima. To biro cʉ̃ja ca bii pacaro, Ʉmʉreco Pacʉ pea cʉ̃ja ca baapere cʉ̃jare tiicojomi. ¡Mʉja pee doca minia ametʉenero ca wapa cʉtirã mʉja nii! ");
INSERT INTO baoNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Nii pee mʉja mena macʉ̃, cʉ̃ ca tʉgoeña ama pato wãcãrije menara, jĩcã cuu cʉ̃ bʉcʉa mʉa nemo majicãgajati? ");
INSERT INTO baoNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Õo ca biirije ʉnoacãrena bii majiti pacarã, ¿ñee tiirã apeye peere to cõro bʉaro mʉja tʉgoeña ama pato wãcãti? ");
INSERT INTO baoNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","”Oorire ĩaña. ¿Do biirije to bʉcʉati? Padeti, tee ca jãñape juti juati, bii pacaro ĩaricaro añurije bʉcʉa. Wiogʉ Salomón niiquĩricʉ niipetirije añurije ca cʉocãgʉpʉ cãa, tee ametʉenero añurijepʉra juti jãña, tiitiquĩupi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ʉmʉreco Pacʉ, taa mecʉ̃re nii, ñucã boero ʉnora joe bate ecocã yai waa, ca biirije cãare, ĩaricaro añurije juti jãami. ¡Mʉja docare tee ametʉenero cʉ̃ tiitibogajati, petoacã peti díámacʉ̃ ca tʉo nʉcʉ̃ bʉorã! ");
INSERT INTO baoNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","To biri mʉja ca baapere, mʉja ca jinipere, tʉgoeñarique pai ama nucũ yujuticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ʉmʉreco Pacʉre ca majitirã niima, ate niipetirijere ca ama nucũ yujurã. Mee, mʉja pea jĩcʉ̃ mʉja Pacʉ cʉti, mʉja ca boorijere ca majigʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","To biri mʉja Ʉmʉreco Pacʉ cʉ̃ ca doti niirije peere amaña. To biro biirã, ate cãare mʉja tiicojo ecorucu —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—Yʉ yaarã oveja, uwiticãña. Mʉja, paʉacã méé mʉja nii. To biro mʉja ca bii pacaro, Ʉmʉreco Pacʉ pea ca bojoca añugʉ niiri, cʉ̃ ca doti niiri tabere mʉjare tiicojorʉgami. ");
INSERT INTO baoNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Mʉja apeyere noni wapa jeeri, ca apeye boo pacarãre tiicojoya. Ati yepa maquẽ apeye boacoa, ca biirijerena jee cũuticãña. Ʉmʉreco tutipʉ apeye ca petitipe jee dutiri maja eati, õpẽcõa ʉnora baati, cʉ̃ja ca biiri tabepʉ maquẽ docare apeye queno cũuña. ");
INSERT INTO baoNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","To biri mʉja apeye ca niiri tabera niirucu mʉja yeri cãa —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","—To biri, mee juti jãñaricarãpʉ, jĩa boericagaari cãare jĩa tuariquepʉ, cʉo yue niiña. ");
INSERT INTO baoNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Paderi maja, cʉ̃ja wiogʉ amo jiarica boje rʉmʉre ca waaricʉ tua eagʉ, jopere cʉ̃ ca paarije menara cʉ̃re boca pãa jõene, ca tiiparã cʉ̃ja ca nii yuerore biro biiya. ");
INSERT INTO baoNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bʉaro ʉjea niima, cʉ̃ja wiogʉ cʉ̃ ca eapere ca yue niirãrena cʉ̃ ca bʉa earã. Yee méé mʉjare yʉ ĩi: Wiogʉ majuropeera, baarique peorica pĩi pʉto cʉ̃jare duwi doti yapano, cʉ̃jare baarique peorucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Cʉ̃ja, bʉaro ʉjea niima, ñami decomacã, ca boeparo jʉguero to ca nii pacaro, ca cãnitirãrena cʉ̃ ca bʉa earã. ");
INSERT INTO baoNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Atere majiña: Jĩcʉ̃ wii ʉpʉ, “To cõro earucumi jee dutiri majʉ,” cʉ̃ ca ĩi majijata, cʉ̃ yaa wiire pãa jãa doori, cʉ̃ ca jee dutiro, cʉ̃re tiiticumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mʉja cãa to birora añuro queno yue niiña. “Doocumi,” mʉja ca ĩitiri tabe ʉnore earucumi Ca Nii Majuropeegʉ Macʉ̃ —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","To biro cʉ̃ ca ĩiro tʉogʉ, Jesús're o biro ĩi jãiñaupi Pedro: —Wiogʉ, ¿ate mʉ ca ĩi cõoña wederijere jãa wadore ĩigʉ mʉ ĩiti, niipetirãre ĩigʉ mʉ ĩitiqué? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩiupi: —¿Ñiru cʉ̃ niiti, cʉ̃ wiogʉ yeere ĩa nʉnʉjee bojari majʉ, ĩiricarore biro ca tiigʉ, ca tʉgoeña bojoca catigʉ, cʉ̃ wiogʉ, cʉ̃ yaa wii macãrãre ĩa cote, baarica tabe ca earo cʉ̃jare baarique eca, cʉ̃ ca tii dotigʉ pea? ");
INSERT INTO baoNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Bʉaro ʉjea niimi pade coteri majʉ, cʉ̃ wiogʉ tua eagʉ, cʉ̃ ca tiipe cʉ̃ paderiquere ca tii niigʉrena cʉ̃ ca bʉa eagʉa. ");
INSERT INTO baoNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yee méé mʉjare yʉ ĩi. Cʉ̃ wiogʉ pea cʉ̃ yee niipetirijere ca ĩa cotegʉ cʉ̃re cũurucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Cʉ̃ pade coteri majʉ pea, “Yʉ wiogʉ yoari méé tua eatirucumi,” ĩi tʉgoeñari, paderi maja aperã peere, ʉmʉa, nomiare ñañaro cʉ̃jare tii, baarique wado baa, jini, cũmu nucũ yuju, biicumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Cʉ̃ wiogʉ pea tii rʉmʉ, to cõro ca niiro, earucumi cʉ̃ ca ĩi tʉgoeña yuetiri tabere eari, bʉaropʉra ñañaro cʉ̃re tii, ĩiricarore biro ca tiitirã cʉ̃ja ca tamʉorore biropʉ cʉ̃ ca biiro cʉ̃re tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","”Pade coteri majʉ, cʉ̃ wiogʉ cʉ̃ ca boorijere maji pacagʉ, queno yueti, cʉ̃ ca boorore biro tiiti, cʉ̃ ca biijata, paʉ tiiri bape ecorucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pade coteri majʉ, majitima ĩigʉ ñañaro cʉ̃ ca tii ecope ʉnore cʉ̃ ca tii bui cʉtijata, peeto jañurora bape ecorucumi. To biri paʉ ca tiicojo ecogʉa, bʉaropʉra tii doti ecorucumi. Ñucã, cʉ̃ ca ĩa nʉnʉjeepere paʉpʉra ca tiicojo ecogʉa, ametʉeneropʉ doti ecorucumi —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Yʉa, ati yepapʉre peca jĩa tuagʉ doogʉ yʉ doowʉ. Mee ca ʉ̃ʉcoaropʉ yʉ boocãmi. ");
INSERT INTO baoNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Biigʉpʉa, ñañaro peti yʉ bii ametʉarucu. To biro yʉ ca biipere ñañaro yʉ tʉgoeña. ");
INSERT INTO baoNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿“Ati yepare jĩcãri mena añuro niiriquere jee doogʉ biijacupi,” mʉja ĩiti? Teere jee doogʉ méé yʉ biiwʉ. Ameri camotatirique peere jee doogʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mecʉ̃ mena, jĩcã wii macãrã jĩcã amo cõro ca niirã, ĩtiarã pʉarãre ĩa tuti, ñucã pʉarã, itiarã ca niirã peere ĩa tuti, biirucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ñucã cʉ̃ pacʉ cʉ̃ macʉ̃rena ĩa juna, cʉ̃ macʉ̃ pee cãa cʉ̃ pacʉrena ĩa juna, cõ paco cãa cõ macõrena ĩa juna, cõ macõ pee cãa cõ pacorena ĩa juna, ñucã cõ mañico cãa cõ macʉ̃ nʉmorena ĩa juna, cõ macʉ̃ nʉmo pee cãa cõ mañicõrena ĩa juna, ameri biirucuma —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jiro bojoca peere o biro cʉ̃jare ĩiupi ñucã Jesús: —Muipũ cʉ̃ ca ñaajãa waari nʉña pee, bueri bʉrʉri to ca mʉa dooro ĩarã, “Oco pearʉgaro bii,” mʉja ĩi ĩa maji. Mʉja ca ĩirore birora bii. ");
INSERT INTO baoNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ñucã jõcʉ̃ jiro macã nʉña pee wino to ca paa puu dooro ĩarã, “Ajirʉgaro bii,” mʉja ĩi ĩa maji. Mʉja ca ĩirore birora bii. ");
INSERT INTO baoNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Watoara ca bii dito pairã! Ʉmʉrecori, yepari ca biirijere añuropʉ, “To biirije biirʉgaro bii,” ca ĩi majĩcãrã nii pacarã, ¿ñee tiirã ano mʉja watoa ca biirije peera “To biirije biirʉgaro bii,” mʉja ĩi ĩa majititi? —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—¿Ñee tiirã mʉja majuropeera, añurijere mʉja ĩa cõoña majititi? ");
INSERT INTO baoNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Jĩcʉ̃ mʉre cʉ̃ ca wedejãaro, wiorã pʉtopʉ cʉ̃ mena waa nʉnʉa waagʉpʉra, jĩcãto cʉ̃ mena ameri wederique quenoña. To biro mʉ ca tiitijata, ca jãiña bejegʉ pʉtopʉ mʉre ami waa, cʉ̃ pee cãa uwamarãpʉre mʉre tiicojo, cʉ̃ja pea tia cũurica wiipʉ mʉre tia cũu, cʉ̃ja ca tiitipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tia cũurica wiipʉra yua, mʉ ca wapa tii peotitijata, mʉ wititirucu,” mʉre yʉ ĩi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","O biro cʉ̃ ca ĩi niiri taberirena, jĩcãrã Jesús're ĩarã waari, Pilato, jĩcãrã Galilea macãrã waibʉcʉrã jĩari, Ʉmʉreco Pacʉre ca tiicojo nʉcʉ̃ bʉo niirãre jĩari, cʉ̃ja díire waibʉcʉrã díi mena cʉ̃ ca ayiariquere cʉ̃re wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Teere tʉogʉ, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —¿“Mʉja, aperã cʉ̃ja yaa yepa Galilea macãrã ametʉenero ñañarije ca tiirã niima ĩirã, to biro tamʉojacupa,” mʉja ĩi tʉgoeñati? ");
INSERT INTO baoNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“Biitijacupa,” mʉjare yʉ ĩi. Mʉja cãa, tʉgoeña yeri wajoari ñañarije mʉja ca tii niirijere mʉja ca tii yerijãatijata, cʉ̃jare birora mʉja bii yairucu. ");
INSERT INTO baoNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ñucã, Siloére cʉ̃ja ca wee nʉcõrica tutu pee ñaawaaro, dieciocho niirã ca tãni yairicarã, Jerusalén macãrã ametʉenero ñañarije cʉ̃ja ca tii bui cʉtirique jʉori, tãni yaijacupa, ¿mʉja ĩi tʉgoeñati? ");
INSERT INTO baoNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","“Biitijacupa,” mʉjare yʉ ĩi. Mʉja cãa, tʉgoeña yeri wajoari ñañarije mʉja ca tii niirijere mʉja ca tii yerijãatijata, cʉ̃jare birora mʉja bii yairucu —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","To biro cʉ̃jare ĩi, ati wãme ĩi cõoñari wedeupi ñucã Jesús: —Jĩcʉ̃ cʉ̃ ʉje wejepʉre higueragʉ cʉ̃ ca otericagʉre cʉoupʉ. “Mee dica cʉticoacu,” ĩigʉ, ĩagʉ waamiupʉ. Jĩcãga ʉnora bʉaticãupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","To biri, cʉ̃ ʉje wejere ca ĩa nʉnʉjeegʉre o biro cʉ̃re ĩiupʉ: “Mee, itia cʉ̃ma waa, atigʉ dicare jeerʉgʉ yʉ ca amagʉ doorucu niimirije, jĩcãga ʉnoacãra bʉarucu, yʉ tiiti. Queti cõacãña. Ñee tiiro cõro watoa petira nucũ cotero niiticu,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","”To biro cʉ̃ ca ĩiro cʉ̃ ʉje wejere coteri majʉ pea o biro cʉ̃re ĩiupʉ: “Wiogʉ, ati cʉ̃mara mani quetiticãjaco ména. Jita ca jʉti añurije mena ayiari, tiigʉ pʉtore yʉ jita coa tuu ñaarucu. ");
INSERT INTO baoNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ape tabera tee mena dica cʉticãbocu. To ca dica manicãjata docare mʉ queti cõacãrucu yua,” cʉ̃re ĩiupʉ —ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Jĩcã rʉmʉ yerijãarica rʉmʉ ca niiro, nea poo juu buerica wiipʉ bojocare buegʉ tiiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Toopʉre niiupo jĩcõ nomio, dieciocho cʉ̃mari peti ca diarique cʉti niigo. Wãtĩ cõre cʉ̃ ca tʉ̃a mutĩarico niiri, petoacã wãmʉ poo majiri méé ca biigo niiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesús pea cõre ĩari, cõre jʉo cojo, o biro cõre ĩiupi: —Nomio, mee diarique manigo mʉ tua —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","To biro ĩigʉra cʉ̃ amori mena cõre cʉ̃ ca ñia peorije menara, cõ pea díámacʉ̃ wãmʉ poocoaupo. To biro biigora, Ʉmʉreco Pacʉre baja peo nʉcʉ̃ bʉoupo. ");
INSERT INTO baoNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yerijãarica rʉmʉrena, ca diarique cʉtigore Jesús cʉ̃ ca catiorijere ĩari, nea poo juu buerica wii wiogʉ pea ajiacoaupi. To biri bojocare o biro cʉ̃jare ĩiupi: —Jĩcã amo peti, ape amore jĩcãga penituaro niiri rʉmʉrira nii paderica rʉmʉri. Tii rʉmʉri ʉnore mʉja diariquere ametʉene dotirã dooya. Yerijãarica rʉmʉ petira to biro tiiticãña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Watoara ca bii dito pairã, ¿mʉja jĩcʉ̃ ʉno peera yerijãarica rʉmʉrena, mʉja burrore, mʉja yʉʉ buey're, mʉja ca jia tuu nʉcõricʉre cʉ̃re popiori mʉja oco tĩarã waatirucuti? ");
INSERT INTO baoNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Atio, Abraham pãrameore, Satanás dieciocho cʉ̃mari peti ate diarique mena cʉ̃ ca jia nʉcõ epego peera, ¿yerijãarica rʉmʉrena cõ popio ecotibogajati? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","O biirije Jesús cʉ̃ ca ĩiro, cʉ̃re ca ĩa tutirã pea boboro tamʉoupa. To ca bii pacaro, niipetirã to cõro do biro ca tiiya manirije Jesús cʉ̃ ca tiirijere bʉaro ĩa ʉjea niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","O biro ĩi nʉnʉa waaupi Jesús: —¿Ñeere biro to biiti, Ʉmʉreco Pacʉ cʉ̃ ca dotirije? ¿Ñee mena yʉ ĩi cõoñagʉti? ");
INSERT INTO baoNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Jĩcãga mostaza apegaacãre jĩcʉ̃ cʉ̃ yaa wejepʉ ote, cʉ̃ ca tiiro jiro wii mʉa waaro, jĩcãgʉ yucʉgʉ pairicʉ bʉcʉa, to ca biiro tiigʉ dʉpʉripʉre minia yerijãa peja cʉ̃ja ca biirore biro bii —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ñucã o biro ĩiupi: —¿Ʉmʉreco Pacʉ cʉ̃ ca doti niirijere ñee mena yʉ ĩi cõoñagʉti? ");
INSERT INTO baoNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Jĩcõ nomio harinare itia bapa cõori, niipetiri bʉrʉapʉra to wauacoajato ĩigo, ca wauaro ca tiirijere cõ ca ayiarore biro bii —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús, Jerusalén'pʉ waa nʉnʉa waagʉ, cʉ̃ ca ametʉa waari tabe macã macãri macãrãre bue ametʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","To biro cʉ̃ ca ĩi nʉnʉa waaro, jĩcʉ̃ Jesús're o biro ĩi jãiñaupi: —Wiogʉ, ¿ca ametʉarã petoacã cʉ̃ja niiti? —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—“Ca ejatiri jope peere jãa waarʉga niiña. Paʉ jãa waarʉgamirucuma. To bii pacarã jãa majitirucuma,” mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Tii wii wiogʉ wãcãri, jopere cʉ̃ ca biaro jiro, mʉja macãpʉ ca niirã pea, “Wiogʉ, jãare jope pãaña,” cʉ̃re mʉja ĩi jʉomirucu. To biro mʉja ca ĩiro cʉ̃ pea, “Baa, mʉjare yʉ majiti. Noo macãrã niirã mʉja niicu,” mʉjare ĩi yʉʉrucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","To biro cʉ̃ ca ĩiro, mʉja pea: “Mʉ menara baa, jini, jãa tiiwʉ. Jãa macã yeparira bojocare mʉ bue yujurucuwʉ,” cʉ̃re mʉja ĩimirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","”To biro mʉja ca ĩiro, “ ‘Mee mʉjare yʉ majiti,’ mʉjare yʉ ĩijãwʉ. Yʉre camotatiya mʉja, ñañarije ca tiirã,” mʉjare ĩirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","”To cõrora otirique, bʉaro tʉgoeña pairique, mʉjare niirucu, Abraham, Isaac, Jacob, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja niiquĩricarã niipetirã, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉ cʉ̃ja ca niicãro, mʉja pea macãpʉ cõa wiene ecoma ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Bojoca niipetiropʉ macãrã, muipũ cʉ̃ ca mʉa doori nʉña macãrã, cʉ̃ ca ñaa jãari nʉña macãrã, jõcʉ̃ jiro macã yepa macãrã, ñucã díámacʉ̃ macã yepa macãrã doorucuma, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉ baa duwirã doorã. ");
INSERT INTO baoNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","To biri mecʉ̃rire watoa macãrã ca niirã, ca nii majuropeerã niirucuma. Ñucã mecʉ̃rire ca nii majuropeerã ca niirã, watoa macãrã tuarucuma —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Tii rʉmʉrena jĩcãrã fariseos eari, o biro ĩiupa Jesús're: —Anore waacoagʉja. Herodes mʉre jĩacãrʉgami —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi Jesús: —Waari, o biro ĩirãja, ca bojoca ñañagʉre: “Mecʉ̃, boero ca diarique cʉtirãre catio, wãtĩare cõa wiene, yʉ tiirucu. Boero ape rʉmʉra yʉ paderiquere yʉ yapanorucu. ");
INSERT INTO baoNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Mecʉ̃, boero, boero ape rʉmʉ, yʉ waa nʉnʉa waarucu. Jĩcʉ̃, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ, Jerusalén ca niitiropʉra cʉ̃ ca bii yaijata añuti.” ");
INSERT INTO baoNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","”Jerusalén, Jerusalén, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare jĩa, mʉre Ʉmʉreco Pacʉ, cʉ̃ ca wede doti cojorãre ʉ̃tã mena dee jĩa, ca tiiri macã mʉ nii. Jĩcãti méé, ãboco cõ punare cõ quedʉpʉ doca cõ ca jee neorore biro yʉ tiirʉgamiwʉ mʉ bojocare. Mʉja pea mʉja bootiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","To biri, mʉja ca niiri tabe, bojoca maniri tabe tuarucu. Yʉre mʉja ĩa nemotirucu, “ ‘Añuro ca biigʉ niimi, Ʉmʉreco Pacʉ wãme mena ca doogʉ,’ mʉja ca ĩiri rʉmʉ ca earopʉ,” mʉjare yʉ ĩi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Jĩcã rʉmʉ, yerijãarica rʉmʉ ca niiro, ʉpʉ fariseo yaa wiipʉ baagʉ waaupi Jesús. Aperã fariseos pea Jesús're ĩa duti cote niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ñucã toopʉre niiupi jĩcʉ̃ mipĩrique ca diarique cʉtigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","To biri Jesús pea, doti cũuriquere ca jʉo buerãre, fariseos're, o biro cʉ̃jare ĩi jãiñaupi: —¿Doti cũurique, yerijãarica rʉmʉre ca diarique cʉtirãre to catio dotiti? ¿To dotititiqué? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","To biro cʉ̃ ca ĩiro, cʉ̃ja pea wedetiupa. To cõrora ca diagʉre catio yapano, “Tua waagʉja,” cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","To biro tii yapano, fariseos peera o biro cʉ̃jare ĩiupi: —¿Nii mʉja mena macʉ̃, yerijãarica rʉmʉrena cʉ̃ macʉ̃ ʉno, cʉ̃ buey ʉno opepʉ cʉ̃ ca ñaajãaro, yoari méé cʉ̃re cʉ̃ ami wienetiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Jesús to biro cʉ̃ ca ĩiro, cʉ̃ja pea do biro cʉ̃re ĩi yʉʉ majitiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Cʉ̃ ca jʉo cojoricarã duwiriquere añuri taberipʉ wado cʉ̃ja ca beje ea nuuro ĩagʉ, o biro cʉ̃jare ĩi wede majioupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Noo jĩcʉ̃, amo jiarica boje rʉmʉre mʉjare cʉ̃ja ca jʉo cojoro, duwirique añurijepʉ wado beje ea nuuticãña. Mʉja ametʉenero ca nii majuropeegʉ eabocumi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","To biro cʉ̃ ca biiro, mʉja pʉarãpʉrena ca jʉo cojoricʉ doori: “Mʉ ca duwiri tabere ani peere duwi dotiya,” mʉjare ĩibocumi. To biro cʉ̃ ca ĩiro, aperã cʉ̃ja ca ĩa cojoro, boboro cʉ̃ja jiropʉ mʉja duwirã waabocu yua. ");
INSERT INTO baoNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","To biro biitirãra, mʉjare cʉ̃ja ca jʉoro, jiro macã pĩiropʉ ea nuu eaya, to biro mʉja ca biiro mʉjare ca jʉoricʉ pea, “Yʉ mena macʉ̃, ano añuri tabe pee duwigʉ dooya,” mʉjare cʉ̃ ca ĩipere biro ĩirã. To biro biirã, mʉja mena ca baa duwirã cʉ̃ja ca ĩa cojoro, mʉjare ca jʉo cojoricʉre añuro mʉja ĩi ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Cʉ̃ majuropeera, “Ca nii majuropeegʉ yʉ nii,” ca ĩigʉa, watoa macʉ̃ tuarucumi. “Watoa macʉ̃ yʉ nii,” ca ĩigʉ pea, ca nii majuropeegʉ tuarucumi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ñucã cʉ̃re ca jʉoricʉ cãare o biro cʉ̃re ĩiupi Jesús: —Baarique jʉo baagʉ, mʉ mena macãrãre, mʉ yee wederãre, mʉ yaarã ca nii cojorãre, ñucã mʉ ca niiri tabe pʉto macãrã ca apeye pairãre, jʉoticãña. Cʉ̃jare mʉ ca jʉojata, ñucã cʉ̃ja pee cãa mʉre jʉorucuma, mʉre amerʉgarã. Mee, to biro mʉre cʉ̃ja ca tiirije menara mʉ wapa taacãrucu. ");
INSERT INTO baoNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","To biro tiitigʉra, boje rʉmʉ tiigʉ, ca boo pacarãre, ca waa majitirãre, dʉpo yuririre, ca ĩatirãre, jʉoya. ");
INSERT INTO baoNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","To biro tiigʉ, bʉaro mʉ ʉjea niirucu. Cʉ̃ja pea jĩcã rʉmʉ ʉnora, to biro mʉre tii ametirucuma. To biro mʉre cʉ̃ja ca tiiti pacaro, mʉ pea ca añurã cʉ̃ja ca cati tuari rʉmʉre tee wapa mʉ tiicojo ecorucu —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Atere to biro cʉ̃ ca ĩiro tʉogʉ, jĩcʉ̃ Jesús mena ca duwirã mena macʉ̃, o biro ĩiupi: —Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre ca baapʉ doca ʉjea niiña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩiupi: —Jĩcʉ̃, pairo baarique quenori, paʉ bojocare jʉoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Baarica tabe ca earo, cʉ̃re pade coteri majʉre, “Dooya. Mee, baarique queno yapanoriquepʉ nii,” ĩigʉja yʉ ca jʉoricarãre, cʉ̃re ĩi cojoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","”To biro ĩi cojojãwi, cʉ̃jare cʉ̃ ca ĩiro, niipetirãpʉra ate jʉori jãa waati, cʉ̃re boca ĩiuparã. Ca nii jʉogʉ, o biro ĩiupʉ: “Mecʉ̃acãra jĩcã yepa yʉ wapa tii yerijãawa. To biri tii yepare ĩagʉ waagʉ yʉ tii, teere ĩima ĩigʉ yʉ waati,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Apĩ cãa, “Pʉa amo cõro niirã wecʉa yʉ wapa tii yapano. Cʉ̃jare ĩa ñaagʉ waagʉ yʉ bii ména, ‘teere ĩima ĩigʉ yʉ waati,’ ĩijãwi cʉ̃re ĩiña,” ĩicãupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Apĩ cãa ñucã, “Mecʉ̃acãra yʉ amo jĩa yapano. To biri yʉ waa majiti,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","”Cʉ̃re pade coteri majʉ pea tua ea, ate to biro cʉ̃ja ca ĩiriquere wedeupʉ cʉ̃ wiogʉre. Wii ʉpʉ pea teere tʉo ajia, o biro ĩiupʉ cʉ̃re pade coteri majʉre: “Yoari méé, macã macã yeparipʉ, wiije watoa macã maaripʉ waari, ca boo pacarãre, ca waa majitirãre, ca ĩatirãre, upa yuririre, cʉ̃jare jʉo dooya,” ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","To biro cʉ̃ ca ĩi cojoricʉ waa tua eagʉ: “Wiogʉ, yʉre mʉ ca dotijãrore birora yʉ tii yerijãajãwʉ mee. To ca bii pacaro, wii pee dadati ména,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","To biro cʉ̃ ca ĩiro, cʉ̃ wiogʉ pea o biro cʉ̃re ĩiupʉ: “Maaripʉ, metã macãriacãpʉ waari, noo mʉ ca bʉa earãre ca doorʉgatirãrena cʉ̃jare jʉocã dooya, yʉ yaa wii ca dadacoapere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","‘Jĩcʉ̃ ʉno peera, yʉ ca jʉomiricarã yʉ mena baatirucuma,’ mʉjare yʉ ĩi,” ĩiupʉ —ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Bojoca paʉ Jesús're nʉnʉupa. To biro cʉ̃ja ca biiro, cʉ̃ pea cʉ̃ja peere amojode nʉcãri, o biro cʉ̃jare ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Jĩcʉ̃ yʉre ca tʉo nʉnʉjeegʉ, cʉ̃ pacʉre, cʉ̃ pacore, cʉ̃ nʉmore, cʉ̃ punaare, cʉ̃ yaarãre, cʉ̃ yaarã romirire, ñucã cʉ̃ majuropeera cʉ̃ ca mairo ametʉenero yʉre cʉ̃ ca maitijata, yʉ buegʉ nii majitimi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ñucã yʉ yee jʉori, cʉ̃ majuropeera ñañaro tamʉori, yʉre ca nʉnʉtigʉa, yʉ buegʉ nii majitimi. ");
INSERT INTO baoNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","”¿Jĩcʉ̃ mʉja mena macʉ̃, emʉari wii weerʉgʉ, “¿Wapa tiirica tiiri yʉ ca cʉorije menara yʉ wee yapanocãrʉgamiti?” ĩigʉ, ea nuu waa, tee ca wapa cʉtipere cʉ̃ cõoña jʉotigajati? ");
INSERT INTO baoNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","To biro tiitigʉra, tii wii ca niipa yepa wadore wee cũu pacagʉ, peoti majitigʉ cʉ̃ ca bii niiro niipetirã tii tabere ca ĩarã, o biro cʉ̃re ĩi buicuma: ");
INSERT INTO baoNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ania, wii queno jʉocãmijapi táá biigʉpʉa. Tii yapano majitimi béé,” ĩi buicuma. ");
INSERT INTO baoNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","”Ñucã jĩcʉ̃ wiogʉ, apĩ wiogʉ mena cʉ̃ ca ameri jĩagʉ waape to ca niijata: ¿Yʉ uwamarã diez mil menara, veinte mil uwamarã mena yʉre ca jĩagʉ doogʉre yʉ ãpõtĩocãrʉgamiti? ĩigʉ, ea nuu waa, ¿cʉ̃ cõoña jʉotigajati? ");
INSERT INTO baoNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Yʉ ãpõtĩoricaro mani cʉ̃ ca ĩijata, apĩ wiogʉ pea ména yoaropʉra cʉ̃ ca niiro, “Añurucu. Mani ameri jĩaticãjato,” ĩi cojocumi, queti wederi maja mena. ");
INSERT INTO baoNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","To biri wãmera no ca boogʉ mʉja mena macʉ̃ cʉ̃ ca cʉorije niipetirore cʉ̃ ca waa weo majitijata, yʉ buegʉ nii majitimi —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","—Moa añurijera nii. Bii pacaro ca ocarije to ca peticoajata, ¿do biro pee bii, ñucã ca poarije to nii eabogajati? ");
INSERT INTO baoNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Yepa cãare añuti, otepʉre maa tuujata cãare añuti, biicã yua. To biri díámacʉ̃ra cõa cũu batecãma. Ca amoperi cʉtirã tʉoya yʉ ca ĩirijere —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Paʉ, Roma maquẽre wapa jee bojari maja, ñañarije ca tiirã, Jesús're nea poo eaupa cʉ̃ ca wederijere tʉorʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","O biro cʉ̃re cʉ̃ja ca biirije jʉori, fariseos, doti cũuquĩriquere ca jʉo buerã, o biro ĩi wede paiupa Jesús're: —Ania, ñañarije ca tiirãre añuro tii, cʉ̃ja menara baa, tiimi déé —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","To biro cʉ̃ja ca ĩiro, cʉ̃ pea ati wãme ĩi cõoñari cʉ̃jare wedeupi: ");
INSERT INTO baoNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—¿Nii mʉja mena macʉ̃ pee cien ovejas ca cʉogʉ, jĩcʉ̃ cʉ̃ ca yairo, ca yairicʉre amagʉ waagʉ, noventa y nueve ca niirãre toora cũucã, cʉ̃re bʉacãripʉ cʉ̃ ama yerijãatiti? ");
INSERT INTO baoNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Cʉ̃re bʉagʉ, bʉaro ʉjea niirique mena cʉ̃re ami pʉja, ");
INSERT INTO baoNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","cʉ̃ yaa wii tua eagʉ, cʉ̃ mena macãrãre, cʉ̃ ca niiri tabe macãrãre, jʉo neo, o biro ĩicumi: “Yʉ mena ʉjea niiña. Mee, yʉ oveja ca yairicʉre yʉ bʉajãwʉ,” ĩicumi. ");
INSERT INTO baoNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","To biiri wãmera bii ʉmʉreco tutipʉre: Jĩcʉ̃ ñañarije ca tiigʉ cʉ̃ ca tʉgoeña yeri wajoaro, mee añurã noventa y nueve ca niirã ca tʉgoeña yeri wajoarique bootirã menare ʉjea niiricaro ametʉenero ʉjea niirique nii —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—¿Dico ʉno nomio wapa tiirica tiiri, pʉa amo cõro niiri tiiri ca cʉogo, jĩcã tii ca yairo, jĩa boericaga mena jĩa boeri, to cãnacã tabepʉra añuro owa ama, tii tiire bʉacãripʉ cõ ama yerijãatiti? ");
INSERT INTO baoNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Tii tiire bʉago, cõ mena macãrã romirire, cõ ca niiri tabe pʉto macãrãre, o biro ĩicumo: “Yʉ mena ʉjea niiña. Mee, yʉ wapa tiirica tii, ca yairica tiire yʉ bʉajãwʉ,” cʉ̃jare ĩicumo. ");
INSERT INTO baoNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","To biri wãmera ʉjea niirique nii Ʉmʉreco Pacʉ pʉto macãrãre, jĩcʉ̃ ñañarije ca tiigʉ cʉ̃ ca tʉgoeña yeri wajoaro —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","O biro cʉ̃jare ĩi wedeupi ñucã Jesús: —Jĩcʉ̃, pʉarã puna cʉtiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ca bai pee o biro ĩiupʉ cʉ̃ pacʉre: “Cáacʉ, yʉ yee ca niipe mʉ ca cʉorijere yʉre tiicojoya,” ĩiupʉ. To biro cʉ̃ ca ĩiro, pʉarãpʉrena cʉ̃jare dica woocãupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","”No cãnacã rʉmʉ jiro mééra, ca bai pea, cʉ̃ pacʉ cʉ̃ ca dica wooriquere jee neo, ape yepapʉ, ca yoaropʉ, waacoaupʉ. Toopʉ, noo ca boorora tii niima ĩigʉ, cʉ̃ yee, cʉ̃ pacʉ cʉ̃ ca dica woomiriquere tii bate peoticãupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Cʉ̃ ca jee waamiriquere cʉ̃ ca tii bate peotiro jiro, tii yepapʉre baarique peticoaupe. To biro ca biiro, cʉ̃ pea bʉaro aʉa tamʉo jʉo waaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","To biri tii yepa macʉ̃re paderique jãigʉ waaupʉ. Cʉ̃ pea, cʉ̃ yaa wejeripʉ cʉ̃ yejeare cʉ̃re eca cote doti cojoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Bʉaro queyama ĩigʉ, yejea cʉ̃ja ca baarijerena baarʉgamiupʉ. To biro cʉ̃ ca biicã pacaro, jĩcʉ̃ peera jĩcã wãme ʉnora cʉ̃re baarique eca, tiiticãuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","”Biirique peti tʉgoeña bojoca cati, o biro ĩiupʉ: —¿Yʉ pacʉre pade coteri maja paʉ baarique cʉ̃ja ca cʉocãro, yʉ pea anopʉ yʉ aʉa boa duwi yujuti? ");
INSERT INTO baoNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yʉ pacʉ pʉtopʉra tua waari, o biro cʉ̃re yʉ ĩirucu: “Cáacʉ, Ʉmʉreco Pacʉ menare, mʉ menare ñañarijere yʉ tiijapa. ");
INSERT INTO baoNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","To biri ‘Yʉ macʉ̃,’ yʉre ĩiticãña. Jĩcʉ̃ mʉre ca pade coteri majʉre biro pee yʉre tiiya,” yʉ ĩirucu —ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","”To biro ĩicã cʉ̃ pacʉ pʉtopʉra tuacoaupʉ ñucã. Ména yoaropʉra cʉ̃ ca niiro, cʉ̃ pacʉ pea cʉ̃re ĩa maji, cʉ̃re ĩa boo pacaupʉ. To biri cʉ̃re ũmaa boca, cʉ̃re paabario, cʉ̃ wajopuare ũpũ, cʉ̃re tiiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","To biro cʉ̃ ca tiiro, cʉ̃ macʉ̃ pea o biro cʉ̃re ĩiupʉ: “Cáacʉ, Ʉmʉreco Pacʉ menare, mʉ menare ñañarijere yʉ tiijapa. To biri, ‘Yʉ macʉ̃,’ yʉre ĩiticãña,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","”To biro cʉ̃ ca ĩi pacaro, cʉ̃ pacʉ pea cʉ̃re pade coteri majare: “Yoari méé, jutiro añurito ami doori cʉ̃re jãa, amo jũa jãarica beto cãare jãa, dʉpo juti cãare jãa, cʉ̃re tiiya. ");
INSERT INTO baoNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ñucã wecʉ añuro ca díí cʉtigʉre, ami doori, cʉ̃re jĩaña. Yʉ macʉ̃ cʉ̃ ca tua eari boje rʉmʉ mani tii ʉjea nii baaco. ");
INSERT INTO baoNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ani, yʉ macʉ̃re, ‘Bii yaicoajacupi,’ yʉ ĩi tʉgoeñarucumijãwʉ. Bii yaitijapi. Waa yaicoamiwi, cʉ̃re mani bʉa ñucã,” ĩiupʉ. To cõrora boje rʉmʉ tiicã jʉo waauparã mee yua. ");
INSERT INTO baoNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","”To biro cʉ̃ja ca tii niicãro, cʉ̃ macʉ̃ ca jũwʉ pea wejepʉ niiupʉ. Ca pade niiricʉ tua doogʉ, wii pʉto ea doogʉ, cʉ̃ja ca baja wedeo niirijere tʉoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","To biri jĩcʉ̃ pade coteri majʉre jʉo cojo, “¿Ñee to biijãri yua?” cʉ̃re ĩi jãiñaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","To biro cʉ̃ ca ĩiro, pade coteri majʉ pea o biro cʉ̃re ĩiupʉ: “Mʉ bai tua eajãwi. To biri mʉ pacʉ pea wecʉ añuro ca díí cʉtigʉre jĩa dotijãwi. Cʉ̃ macʉ̃re añuro ca cati añugʉrena, yʉ bʉa, ĩima ĩigʉ boje rʉmʉ tiirʉgʉ,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","”Cʉ̃ jũwʉ pea teere bʉaro tʉo ajiari, jãa waarʉgatiupʉ. To biri cʉ̃ pacʉ pea cʉ̃re jʉogʉ witi waaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Cʉ̃ pea o biro ĩiupʉ cʉ̃ pacʉre: “Cáacʉ, paʉ cʉ̃mari, jĩcãti ʉno peera mʉre ametʉene nʉcãri méé yʉ ca pade niirijere mʉ maji. To biro yʉ ca bii pacaro, ‘Cʉ̃ mena macãrã mena cʉ̃ jĩa baajato’ ĩigʉ, jĩcʉ̃ cabra macʉ̃ ʉnoacãrena jĩcãti ʉno peera yʉre tiicojorucu, mʉ tii ñaati. ");
INSERT INTO baoNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ani mʉ macʉ̃, mʉ yeere ʉmʉa cʉ̃ja ca tii eperã romiri mena tii epe nucũ yuju, tii bate peoticãri ca tua eagʉ peera, wecʉ añuro ca díí cʉtigʉre jĩacãri, cʉ̃re mʉ boje rʉmʉ tii peo,” cʉ̃re ĩiupʉ cʉ̃ pacʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","”To biro cʉ̃ ca ĩiro, cʉ̃ pacʉ pea o biro cʉ̃re ĩiupʉ: “Macʉ̃, mʉa yʉ menara mʉ niicõa nii. Yʉ ca cʉorije niipetirije mʉ yee wado niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ani, mʉ bai, ‘Bii yaicoajacupi,’ yʉ ca ĩi tʉgoeñarucumigʉ, catijapi. Ca waa yairicʉre mani bʉa ñucã. To biri cʉ̃re ca boje rʉmʉ tii peo ʉjea niipera niiro bii,” cʉ̃re ĩiupʉ cʉ̃ pacʉ —ĩi wedeupi Jesús bojocare. ");
INSERT INTO baoNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ñucã cʉ̃ buerãre o biro ĩi cõoñari wedeupi Jesús: —Jĩcʉ̃ ca apeye paigʉ, cʉ̃ yeere ca ĩa nʉnʉjee bojagʉre cʉoupʉ. Aperã pea, “Mʉ yeere tii bategʉ tiimi,” cʉ̃re ĩi wedejãarã waauparã. ");
INSERT INTO baoNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","To biri cʉ̃re jʉo cojori, o biro cʉ̃re ĩiupʉ: “¿Ñee to niiti mʉ ca tiirijere yʉre cʉ̃ja ca wederijea? To biri mʉ ca paderiquere cõoñari, yʉre owa tuu cojoya. To cõrora yʉ yeere ĩa nʉnʉjee bojari majʉ mʉ nii yerijãarucu,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","”To biro cʉ̃ ca ĩiro, cʉ̃ wiogʉ yeere ĩa nʉnʉjee bojari majʉ pea o biro ĩi tʉgoeñaupʉ: “Agó nija, ¿ñeere yʉ tiigʉti yua? Yʉ wiogʉ paderique manigʉ yʉre cũugʉ doogʉ tiimi. Yeparire ca padepʉ ʉno méé yʉ nii. Yʉ tutuati. Wapa tiirica tiiri jãirʉgʉ cãa, yʉ bobo jañu. ");
INSERT INTO baoNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Jaʉ, mee yʉ maji, paderique manigʉ yʉ ca tuaro, aperã yʉre cʉ̃ja ca ñeepere biro ĩigʉ yʉ ca tiipere,” ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","”To biri cʉ̃ wiogʉre ca wapa moorãre jʉo cojoupʉ. Ca nii jʉogʉre o biro ĩi jãiñaupʉ: “¿Mʉa, no cõro yʉ wiogʉre mʉ wapa mooti?” cʉ̃re ĩi jãiñaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Cʉ̃ pea: “Cien daperi peti ʉje daperi yʉ wapa moo,” cʉ̃re ĩiupʉ. To biro cʉ̃ ca ĩiro cʉ̃ wiogʉ yeere ĩa nʉnʉjee bojari majʉ pea o biro cʉ̃re ĩiupʉ: “Jaʉ, ano duwiya. Ate nii mʉ ca wapa moorije. Yʉ wiogʉre cien mʉ ca wapa moorijere, cincuenta niirijera owa tuuya yua,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","”To biro cʉ̃re ĩi yapano, apĩre jʉo cojo, “¿Mʉa, no cõro mʉ wapa mooti?” cʉ̃re ĩi jãiñaupʉ. “Trigo cien poari ca eape cõro yʉ wapa moo,” cʉ̃re ĩi yʉʉupʉ. To biro cʉ̃ ca ĩiro: “Jaʉ, ano duwiya. Ate nii mʉ ca wapa moorije, cien poari mʉ ca wapa moorijere, ochenta poarira owa tuuya yua,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","”Cʉ̃ yeere ĩa nʉnʉjee bojari majʉ ca añutigʉ cʉ̃ ca tiiriquere majiri, cʉ̃ wiogʉ pea, “Ca tii majigʉ peti niijapi,” ĩiupʉ. Ati yepa macãrã, cʉ̃jare biro ca biirã mena cʉ̃ja ca ameri tii niijata, Ʉmʉreco Pacʉ yaarã ca boeropʉ ca niirã ametʉenero tii majima. ");
INSERT INTO baoNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","To biri mʉja pea, ati yepa maquẽ apeye menara, mʉja mena macãrã bʉarʉgarã, cʉ̃jare tii nemoña. Ati yepa maquẽ apeye ca petiro to birora ca niicõa niiri wiijeripʉ mʉjare ca ñeerã ʉno cʉ̃ja ca niipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","”Petoacãrena añuro ca ĩa nʉnʉjee majigʉa, pairopʉ cãare añuro ĩa nʉnʉjee majimi. Petoacã cãare ca ĩa nʉnʉjee majitigʉa, pairo cãare ĩa nʉnʉjee majitimi. ");
INSERT INTO baoNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","To biri ati yepa maquẽ apeye cʉti niirique ca bii ditorije cãare añuro mʉja ca ĩa nʉnʉjee majitijata, ¿apeye cʉti niirique ca nii majuropeerije peera, ñiru peti “Atere ĩa nʉnʉjeeya” mʉjare cʉ̃ ĩibogajati? ");
INSERT INTO baoNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Mʉja yee ca niitirije cãare añuro mʉja ca ĩa nʉnʉjee boja majitijata, ¿ñiru pee mʉja yee ca niirijere mʉjare cʉ̃ tiicojobogajati? ");
INSERT INTO baoNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","”Jĩcʉ̃ pade bojari majʉ ʉno peera pʉarã wiorãpʉre pade cote majitimi. To biro cʉ̃ ca biijata, jĩcʉ̃re ĩa tuti, apĩ peere mai, biicãcumi. Ñucã jĩcʉ̃ cʉ̃ ca dotirijere tii, apĩ cʉ̃ ca dotirije peera tiiti, biicãcumi. To biri mʉja, Ʉmʉreco Pacʉ peere pade nʉnʉjee pacarã ñucã, pairo apeye cʉti niirʉgarã tee pee cãare pade nʉnʉjee, mʉja tii majiti —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseos wapa tiirica tiirire bʉaro ca boorã cãa, ate niipetirijere tʉori, boborije ĩi bui tutiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩiupi: —Mʉja, bojoca cʉ̃ja ca ĩaro ca bojoca añurãre biro mʉja bii dito. Biigʉpʉa, Ʉmʉreco Pacʉ pea mʉja yeripʉ mʉja ca biirijere majimi. Bojoca pea “Añurije nii,” cʉ̃ja ca ĩirijere, Ʉmʉreco Pacʉ peera ñañarije niiro bii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—Doti cũurique, to biri Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, Juan menara bii yapano eaupa. Tii tabe mena wãma wãme añurije queti Ʉmʉreco Pacʉ cʉ̃ ca doti niirije maquẽre wederique nii. Niipetirã toopʉre jãa waarʉgarã bii niima. ");
INSERT INTO baoNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Ati yepa, ati ʉmʉreco, ca petipe pea popiye méé ca nii pacaro, doti cũurique pea jĩcã wãme ʉnoacãra ca ĩirore biro biitirora yaicoa, biitirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—Jĩcʉ̃ cʉ̃ nʉmore cõacãri, apeo peere cʉ̃ ca nʉmo cʉtijata, cʉ̃ nʉmo ca niitigo menapʉ niigʉ tiimi. Ñucã ca manʉ cõaricore ca nʉmo cʉtigʉ cãa, cʉ̃ nʉmo mena méé niigʉ tiimi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—Niiupʉ jĩcʉ̃ ca apeye paigʉ, añurije juti jãña, to cãnacã rʉmʉra ĩaricaro añuro boje rʉmʉri queno, ca tii niirucugʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Niiupʉ ñucã, jĩcʉ̃ boo pacoro ca biigʉ, Lázaro ca wãme cʉtigʉ, cʉ̃ upʉ niipetiropʉra ca cami boagʉ. Ca apeye paigʉ yaa wii jope pʉtore duwirucuupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Cʉ̃ pea, ca apeye paigʉ, cʉ̃ ca baa bate ñoorijere baarʉgarucumiupʉ. Ñucã yaia menapʉra cʉ̃ camire nenirã earucuuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","”To biro biirucu, jĩcã rʉmʉ bii yaicoaupʉ Lázaro. Cʉ̃ ca bii yairo, Ʉmʉreco Pacʉ pʉto macãrã pea Abraham pʉto añuri tabepʉ cʉ̃ niijato ĩirã, cʉ̃re amicoauparã. Ca apeye paigʉ cãa bii yaicoaupʉ. Cʉ̃ ca bii yairo, cʉ̃re yaa cõa, tiicãuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ca apeye paigʉ pea bojoca ñañarã cʉ̃ja ca waari tabepʉre ñañaro bii niigʉ, ĩa mʉene cojoma ĩigʉ, yoaropʉ Abraham're, ñucã Lázaro cãare cʉ̃ mena ca duwigʉre ĩaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","”To biri cʉ̃re ĩacãgʉpʉa, o biro ĩi acaro buiupʉ: “Ñicʉ̃ Abraham, yʉre boo paca ĩaña nija petopʉra. Lázarore yʉ pʉtopʉ cʉ̃re tiicojoya. Cʉ̃ amo jũa yapa mena oco ñia bia doori, yʉ ñemerore cʉ̃ weyogʉ doojato. Ati pecamepʉre bʉaropʉra ñañaro peti yʉ tamʉocã,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","”To biro cʉ̃ ca ĩiro, Abraham pea o biro cʉ̃re boca ĩi yʉʉupʉ: “Yʉ pãrami, atere tʉgoeñaña. Mʉa, mʉ ca cati niiri rʉmʉre añuro peti mʉ niiwʉ, Lázaro pea ñañaro cʉ̃ ca biicãro. To biri cʉ̃ pea mecʉ̃ra anopʉre añuro niigʉ tiimi. Mʉ pea ñañaro mʉ tamʉo. ");
INSERT INTO baoNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ñucã pairi ope nii mani watoare. To biri ano ca niirã toopʉre ca waarʉgarã do biro bii waa majiti, ñucã too macãrã pee cãa anopʉre do biro bii doo majiti, biicãma,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","”To biro cʉ̃ ca ĩiro, cʉ̃ pea o biro cʉ̃re ĩi yʉʉupʉ: “Ñicʉ̃ Abraham, yʉ pacʉ yaa wiipʉ Lázarore cʉ̃re tiicojoya. ");
INSERT INTO baoNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yʉ yaarã jĩcã amo cõro ca niirãre cʉ̃ wede majiogʉ waajato, cʉ̃ja cãa, ati tabe ñañaro tamʉorica tabe pee cʉ̃ja ca dootipere biro ĩigʉ,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","”Ñucã Abraham pea o biro cʉ̃re ĩi yʉʉupʉ: “Mee cʉ̃ja, Moisés cʉ̃ ca owariquere, to biri Ʉmʉreco Pacʉ yee quetire wede jʉgueri majare, cʉ̃jare cʉoma. Cʉ̃jare cʉ̃ja tʉo nʉnʉjeejato,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","”To biro cʉ̃ ca ĩiro, ca apeye paigʉ pea o biro cʉ̃re ĩi yʉʉupʉ: “Tʉo nʉnʉjeeticuma, ñicʉ̃ Abraham. Jĩcʉ̃ ca bii yairicʉpʉ cati tuari cʉ̃jare cʉ̃ ca wedejata docare, tʉo nʉnʉjeeri ñañarije cʉ̃ja ca tiirucurijere tii yerijãabocuma,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","”To biro cʉ̃ ca ĩiro, Abraham pea o biro cʉ̃re ĩiupʉ ñucã: “Moisés cʉ̃ ca ĩirijere tʉo nʉnʉjeeti, ñucã Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca ĩirije cãare tʉorʉgati, cʉ̃ja ca biijata, ca bii yairicʉ cati tuari cʉ̃ ca wedejata cãare, tʉo nʉnʉjeeticuma,” cʉ̃re ĩiupʉ —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Cʉ̃ buerãre o biro ĩiupi Jesús: —Bojoca ñañaro cʉ̃ja ca tiiro ca bii buiyeerijea, do biro pee ca bii ametʉa nʉcã majiña manirije niiro bii. Aperãre ñañarije cʉ̃ja ca tiiro ca tii buiyeegʉa, ñañaro peti tamʉorucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","To biro ca tiigʉra, cʉ̃ amʉtuture ʉ̃tãga jia yoori, dia pairi yaapʉ cʉ̃re cõañua cõacãjata añubocu, yʉre ca tʉo nʉnʉjee jʉo doorãre ñañarijere cʉ̃ja ca tiiro cʉ̃ ca tii buiyeerije jʉori. ");
INSERT INTO baoNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡To biri, bojoca catiya! Mʉja yee wedegʉ ñañarijere cʉ̃ ca tiijata, cʉ̃re tuti bojoca catioya, cʉ̃ ca tʉgoeña wajoajata, ñañarije cʉ̃ ca tiiriquere acoboya. ");
INSERT INTO baoNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Jĩcã rʉmʉre jĩcã amo peti, ape amore pʉaga penituaro niirije peti ñañaro mʉre tiicãri, ñucã ñañaro mʉre cʉ̃ ca tiirije cõrora mʉ pʉto doori, “Ñañaro mʉre yʉ ca tiijãrijere acoboya, yʉ tii nemotirucu,” mʉre cʉ̃ ca ĩigʉ eajata, ñañaro mʉre cʉ̃ ca tiiriquere acoboya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Cʉ̃ buerã pea o biro ĩiupa Jesús're: —¡Díámacʉ̃ tʉo nʉcʉ̃ bʉo bayiriquere pai jañuro jãare tiicojoya! —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","To biro cʉ̃re cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiupi Jesús: —Díámacʉ̃ mʉja ca tʉo nʉcʉ̃ bʉorije mostaza apega cõroacã to ca nii pacaro, atigʉ sicómorogʉre, “Wẽe waari, dia pairi yaapʉ ea nʉcãña,” mʉja ca ĩijata, mʉja ca ĩirore birora biicãbocu —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—Jĩcʉ̃ mʉja mena macʉ̃, cʉ̃re ca pade cotegʉre ca cʉogʉ, wejepʉ ca jee cũu niiricʉ, ape tabera wecʉare ca cote niiricʉ, cʉ̃ ca tua earo, ¿“Baagʉ dooya ména,” cʉ̃re mʉja ĩi bocati? ");
INSERT INTO baoNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mʉja ĩiticu. O biro pee mʉja ĩicu: “Yʉ ca baapere quenoña ména, baa, jini, tii niigʉ yʉ ca boorijere jee cojo coterʉgʉ, juti wajoagʉ waari, toora nucũ coteya. Jiro, ‘Baa, jini, mʉ tiirucu mʉa,’ ” cʉ̃re mʉja ĩicu. ");
INSERT INTO baoNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ñucã mʉja ca dotiriquere cʉ̃ ca tiiricaro jiro to ca niimijata cãare, “Añu majuropeecã,” cʉ̃re mʉja ĩiticu. ");
INSERT INTO baoNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mʉja cãa to biri wãmera, mʉjare tii dotiriquere tii yapanorã, o biro ca ĩiparã mʉja nii: “Pade coteri maja ca añutirã mani nii. Apeyepʉra tiiricaro maniro, manire cʉ̃ja ca tii dotirijeacã wadore mani tii,” ca ĩiparã mʉja nii —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesús, Jerusalén'pʉ waa nʉnʉa waagʉ, Galilea yepa, to biri Samaria yepare ametʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Jĩcã macãre cʉ̃ ca ea waarora, pʉa amo cõro niirã peti ca cami boa diarique cʉtirã cʉ̃re bocarã doori, yoaropʉra tua nʉcã, o biro ĩi acaro bui cojoupa: ");
INSERT INTO baoNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—Jesús, Buegʉ, jãare boo paca ĩaña —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesús pea cʉ̃jare ĩa, o biro cʉ̃jare ĩi cojoupi: —Paia pʉtopʉ waari cʉ̃jare ĩñorãja —cʉ̃jare ĩiupi. To biro cʉ̃ ca ĩiro, cʉ̃ja ca waa nʉnʉa waarora, cʉ̃ja ca cami boa diarique cʉtimirique yati peticoaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Jĩcʉ̃ cʉ̃ja mena macʉ̃, cami manigʉpʉ cʉ̃ ca niirijere ĩari, õopʉra tʉoricʉ Ʉmʉreco Pacʉre baja nʉcʉ̃ bʉo tua doo, ");
INSERT INTO baoNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesús pʉto yepapʉ muu bia cũmu waaupi: —Añu majuropeecã —Jesús're ĩigʉ. Cʉ̃ pea Samaria macʉ̃ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesús pea, o biro ĩiupi: —¿Mʉja ca cami boa diarique cʉtirijere ca ametʉene ecojãrã, pʉa amo cõro méé mʉja niijãri? ¿Jĩcã amo peti, ape amore baparica penituaro ca niirã pea, noo cʉ̃ja niiti? ");
INSERT INTO baoNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Ani judío ca niitigʉ wado Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉorʉgʉ cʉ̃ tua doojapari? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","To biro ĩicã, cʉ̃ peera o biro cʉ̃re ĩiupi: —Wãmʉ nʉcãri, waagʉja. “Jesús yʉre catiocãrucumi,” díámacʉ̃ mʉ ca ĩi tʉgoeña bayirique jʉori, mʉ diarique ametʉene eco —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Fariseos “¿Ʉmʉreco Pacʉ cʉ̃ ca doti niirije no cõropʉ to earoti?” Jesús're ĩi jãiñaupa. To biro cʉ̃ja ca ĩiro cʉ̃ pea o biro cʉ̃jare ĩi yʉʉupi: —Ʉmʉreco Pacʉ cʉ̃ ca dotirijea bau niiro ca eape ʉno méé niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","“Ano nii.” “Õo pee nii,” ĩiña manirucu. Mee, Ʉmʉreco Pacʉ cʉ̃ ca dotirijea, mʉja watoara nii yerijãa —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","To biro ĩicã, cʉ̃ buerã peere o biro ĩiupi Jesús: —Earucu jĩcã cuu, yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca doori rʉmʉre mʉja ca ĩarʉgamirije. Bii pacarã, mʉja ĩatirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Jĩcãrã o biro mʉjare ĩirucuma: “Ani niimi,” “Ĩi pee niimi,” ĩirucuma. To biro cʉ̃ja ca ĩi pacaro, waa, cʉ̃jare tʉo nʉnʉjee, tiiticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ʉmʉreco quejeropʉre, jĩcã nʉña bʉpo cʉ̃ ca yabe cojorijera ape nʉñapʉ cãare ca boe ãpõtĩocã cojorore birora biirucu yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca tua doori rʉmʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ména to biro yʉ ca biiparo jʉguero, bʉaropʉra ñañaro tamʉo, ati cuu macãrãre ĩa juna eco, yʉ biirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","”Noé cʉ̃ ca niiri cuupʉre ca biiquĩricarore birora biirucu, yʉ, Ca Nii Majuropeegʉ Macʉ̃ yʉ ca tua doori rʉmʉ cãare. ");
INSERT INTO baoNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Baa, jini, amo jia, cʉ̃ja puna romiare nomi cũu, tii niiupa. Cũmuapʉ Noé cʉ̃ ca ea jãa waari rʉmʉpʉ to biro tii yerijãaupa. To biro ca tii niirãre ca duurije doo, cʉ̃jare duu yaio bate peoticãquĩupa. ");
INSERT INTO baoNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","”To birora biiupa Lot cʉ̃ ca niiri cuu cãare. Baa, jini, apeye wapa tii, cʉ̃ja ca cʉorijere noni wapa taa, otere ote, wiijeri bʉa, tii niiquĩupa. ");
INSERT INTO baoNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sodoma ca niiricʉ, Lot cʉ̃ ca witiri rʉmʉra, ʉmʉreco tutipʉ maquẽ ca ʉ̃ʉrije, azufre cʉ̃ja ca ĩirije, oco pearore biro cʉ̃jare ñaapea, tii jĩa bate peoticãquĩupa niipetirãpʉrena. ");
INSERT INTO baoNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","”To birora biirucu, yʉ, Ca Nii Majuropeegʉ Macʉ̃ yʉ ca doori rʉmʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Tii rʉmʉre wii jotoapʉ ca niigʉa, cʉ̃ yee apeye wii jupeapʉ cʉ̃ ca cʉorijere cʉ̃ jeegʉ duwi waaticãjato. Ñucã wejepʉ ca niigʉ cãa, cʉ̃ yaa wii pee cʉ̃ tua waaticãjato. ");
INSERT INTO baoNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lot nʉmo ñañaro cõ ca biiriquere tʉgoeñaña. ");
INSERT INTO baoNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Cʉ̃ ca catirijere ñañaro yʉ tii yaiore ca ĩigʉa, cʉ̃ ca cati niirijere díámacʉ̃ra tii yaio nʉcõcãrucumi. Cʉ̃ ca catirijere ca maitigʉa, cʉ̃ ca caticõa niipere bʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Tii ñamire, pũugʉ jĩcãgʉrena pʉarã ca cãni yojarã, jĩcʉ̃ ami waa eco, apĩra toora cũu, tii ecorucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Pʉarã nomia ca wãñia niirã, jĩcõ ami waa eco, apeora toora cũu, tii ecorucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ʉmʉa pʉarã wejepʉre ca niirã, jĩcʉ̃ ami waa eco, apĩ toora cũu, tii ecorucuma —cʉ̃jare ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","To biro cʉ̃ ca ĩiro, cʉ̃ja pea o biro cʉ̃re ĩi jãiñaupa: —¿Wiogʉ, tea noopʉ to biiroti? —ĩiupa. Cʉ̃ pea o biro cʉ̃jare ĩi yʉʉupi: —Ca bii yairicʉ cʉ̃ ca niiri tabere wʉʉ nea poorucuma yucáá —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jĩcã wãme ĩi cõoñari wedeupi Jesús, jʉtiricaro maniro, to birora cʉ̃ja ca juu buecõa niipere wede majiorʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","O biro ĩiupi: —Jĩcã macãpʉre niiupʉ jĩcʉ̃, bojoca cʉ̃ja ca tii niirijere ca jãiña bejegʉ, Ʉmʉreco Pacʉra nʉcʉ̃ bʉoti, bojoca cãare ĩa nʉcʉ̃ bʉoti ca biigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ñucã tii macãrena niiupo jĩcõ, ca manʉ bii yai weo ecorico, bojoca cʉ̃ja ca tii niirijere ca jãiña bejegʉ pʉtopʉ waari, “Yʉre ca ĩa tutigʉre, ñañaro cõre tiiticãña,” cʉ̃re ĩiña, cʉ̃re ca ĩi niigo. ");
INSERT INTO baoNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jĩcã cuu, yoaro cõre tii nemorʉgatiupʉ. To biro biiñami, o biro ĩi tʉgoeñaupʉ: “Ʉmʉreco Pacʉra nʉcʉ̃ bʉoti, bojoca cãare ĩa nʉcʉ̃ bʉoti, ");
INSERT INTO baoNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ca biigʉ yʉ ca nii pacaro, atio, ca manʉ bii yai weo ecorico pea, yʉre pato wãcõ yerijãatimo. Cõre yʉ tii nemocãgʉda. To cãnacã tiira doori, añuro yʉ ca niicãboro yʉre pato wãcõ niibocumo,” ĩiupʉ —ĩi wedeupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","To biro ĩicã, o biro ĩi nemoupi ñucã Jesús: —O biirije ĩiupi jãiña bejeri majʉ, ca añutigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","“¿To docare Ʉmʉreco Pacʉ pea cʉ̃ yaarã, cʉ̃ ca beje jeericarã, ñamiri, ʉmʉrecori cʉ̃re cʉ̃ja ca jãijata, cʉ̃jare cʉ̃ tii nemotigajati? ¿Yoaro cʉ̃ja ca yue mani waaro cʉ̃ tiigajati? ");
INSERT INTO baoNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Yoari mééra cʉ̃jare tii nemorucumi,” mʉjare yʉ ĩi. ¿To docare yʉ, Ca Nii Majuropeegʉ Macʉ̃ yʉ ca tua doori rʉmʉre, ména ati yepapʉre díámacʉ̃ tʉo nʉcʉ̃ bʉorique to niicãroti? —ĩiupi cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jĩcãrã cʉ̃ja majuropeera, “Añurã jãa nii” ĩi tʉgoeñari, aperãre ca ĩa junarãre ĩima ĩigʉ, ati wãme ĩi cõoñari cʉ̃jare wedeupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Pʉarã ʉmʉa, Ʉmʉreco Pacʉ yaa wiipʉre juu buerã waauparã. Jĩcʉ̃ fariseo, apĩ pea Roma maquẽre wapa jee bojari maja mena macʉ̃ niiuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fariseo pea o biro ĩi juu bue nucũupʉ: “ ‘Ʉmʉreco Pacʉ, añu majuropeecã,’ mʉre yʉ ĩi. Yʉa, aperã, ca jee duti pairã, ca tii dito pairã, ca tii epericarã cʉti pairã, ñucã ani wapa jee bojari majʉre biro, yʉ biiti. ");
INSERT INTO baoNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yʉa, jĩcã semanare pʉati wado betiri yʉ juu bue, yʉ ca wapa taarije cõrora pʉa amo coro ca niirijere jĩcã tabe mʉre yʉ tiicojorucu,” ĩi juu bueupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Roma maquẽre wapa jee bojari majʉ pea, yoaropʉra tua nʉcã, ʉmʉreco peere ĩa mʉeneri méé, cʉ̃ cotiare paagʉra, o biro ĩi juu bueupʉ: “Ʉmʉreco Pacʉ, yʉre boo paca ĩaña. Yʉa, ñañarije ca tiigʉ yʉ nii,” ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","”To biri wapa jee bojari majʉ pea, ñañarije manigʉpʉ cʉ̃ yaa wiire tua waaupʉ. Fariseo pea biitiupʉ. To biri cʉ̃ majuropeera, “Ca nii majuropeegʉ yʉ nii,” ca ĩigʉa, watoa macʉ̃ tuarucumi. “Watoa macʉ̃ yʉ nii,” ca ĩigʉ peera, ca nii majuropeegʉ cʉ̃ ca niiro cʉ̃re tiirucumi Ʉmʉreco Pacʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ñucã wimarãre Jesús pʉto jee waaupa, cʉ̃jare cʉ̃ padeñajato ĩirã. To biro cʉ̃ja ca tiiro ĩarã, cʉ̃ buerã pea wimarãre ca jee doorãre boca tuti camotaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","To biro cʉ̃ja ca ĩiro, Jesús pea wimarãre jʉo cojo, o biro ĩiupi: —Wimarãre yʉ pʉto pee cʉ̃jare tiicojoya. Cʉ̃jare camotaaticãña. Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabea, cʉ̃jare biro ca niirã cʉ̃ja ca niipa tabe nii. ");
INSERT INTO baoNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yee méé mʉjare yʉ ĩi. Wimagʉre biro Ʉmʉreco Pacʉ cʉ̃ ca dotirijere ca tʉo nʉnʉjeetigʉa, toopʉre ea waatirucumi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jĩcʉ̃ judíos're ca jʉo niirã mena macʉ̃, o biro ĩi jãiñaupi Jesús're: —Buegʉ añugʉ, ¿ñee yʉ tiigajati, caticõa niiriquere bʉarʉgʉ? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —¿Ñee tiigʉ “Añugʉ,” yʉre mʉ ĩiti? Jĩcʉ̃ ʉno peera ca añugʉ manimi; ca añugʉa jĩcʉ̃ra niimi, Ʉmʉreco Pacʉ wado. ");
INSERT INTO baoNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Mee, Ʉmʉreco Pacʉ cʉ̃ ca doti cũuriquere mʉ maji: Nʉmo cʉti, manʉ cʉti, bii pacarã tii epericarã cʉtiticãña. Jĩaticãña. Jee dutiticãña. Jĩcʉ̃ peerena watoara ĩi dito buiyeeticãña. Mʉ pacʉre, mʉ pacore nʉcʉ̃ bʉoya —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","To biro cʉ̃ ca ĩiro, cʉ̃ pea o biro cʉ̃re ĩiupi: —Mee, wãmʉ niigʉpʉra tee niipetirijepʉrena tee ca ĩirore biro yʉ tii peticãwʉ —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","To biro cʉ̃ ca ĩiro tʉo, o biro cʉ̃re ĩi yʉʉupi Jesús: —Jĩcã wãme mʉre dʉjacã ména. Mʉ ca cʉorijere noni peoticã, tee wapa mʉ ca jeerijere ca boo pacarãre cʉ̃jare tiicojoya. To biro tiigʉ, ʉmʉreco tutipʉre pairo mʉ apeye cʉtirucu. To biro tii yapano, yʉ mena dooya —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Cʉ̃ pea ca apeye paigʉ niiri to biro Jesús cʉ̃ ca ĩirijere tʉogʉ, bʉaro tʉgoeñarique paiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","To biro cʉ̃ ca biiro ĩa, o biro ĩiupi Jesús: —¡No cõro peti ca bii majiña manirije to niicãti, ca apeye pairã Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre cʉ̃ja ca ea waape! ");
INSERT INTO baoNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Popiye méé niicã, jĩcʉ̃ camello ãjipõa potaga opeacãre cʉ̃ ca ame witi waaro, jĩcʉ̃ ca apeye paigʉ pea Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre, do biro cʉ̃ ca bii ea waatirije to ca nii pacaro —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","To biro cʉ̃ ca ĩirijere ca tʉorã pea, o biro cʉ̃re ĩi jãiñaupa: —¿To docare ñiru pee cʉ̃ ametʉagʉti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Bojocara do biro ca bii majiña manirije cãa, Ʉmʉreco Pacʉ peera popiye méé niicã —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","To biro cʉ̃ ca ĩiro, Pedro pea o biro ĩiupi Jesús're: —Wiogʉ, jãa, jãa yee niipetirije cũu peticã, mʉre jãa nʉnʉ doowʉ —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Yee méé mʉjare yʉ ĩi. No ca boogʉ, Ʉmʉreco Pacʉ cʉ̃ ca doti niirije peere tii nʉnʉjeerʉgʉ, cʉ̃ yaa wii, cʉ̃ nʉmo, cʉ̃ yaarã, cʉ̃ pacʉa, cʉ̃ punaare, cʉ̃ ca waa weojata, ati yepare cati niigʉra, cʉ̃ ca waa weorique ametʉenero tiicojo ecorucumi. Ñucã cʉ̃ ca bii yairo jiropʉra, to birora caticõa niiriquere tiicojo ecorucumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús, cʉ̃ buerã pʉa amo peti, dʉpore pʉaga penituaro ca niirã wadore jʉo cojori, o biro cʉ̃jare ĩiupi: —Mecʉ̃ra Jerusalén'pʉ mani waa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, yʉ, Ca Nii Majuropeegʉ Macʉ̃ yʉ ca biipere cʉ̃ja ca owarique ca ĩirore biro ca biipa tabepʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Toopʉ apero macãrãpʉre yʉre noni cõarucuma. Cʉ̃ja pea yʉre bui epe, yʉre acaro bui tuti, yʉre ʉjeco eo tuu, tiirucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","To biro tiicã, yʉre bape yapanori jiro, yʉre jĩa cõa, tiicãrucuma. To biro cʉ̃ja ca tiicãmijata cãare, itia rʉmʉ jiro yʉ cati tuacoarucu ñucã —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Cʉ̃ja pea ate to biro cʉ̃ ca ĩirijere tʉo majitiupa. Ñucã, “To biro ĩirʉgʉ ĩigajami,” ĩi majiticãupa, do biro tii ca tʉo majiña manirije ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jesús, Jericó macãre ea nʉnʉa waagʉ cʉ̃ ca biiro, jĩcʉ̃, ca ĩatigʉ, maa pʉtore wapa tiirica tiiri ca jãi duwigʉ, ");
INSERT INTO baoNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","paʉ bojoca cʉ̃ja ca ametʉa waarijere tʉori: —¿Do biro to biiti? —ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","To biro cʉ̃ ca ĩiro: —¡Jesús, Nazaret macʉ̃ ametʉa waagʉ biimi! —cʉ̃re ĩi wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Teere tʉocãgʉpʉa, o biro ĩi acaro buiupi: —¡Jesús, David Pãrami, yʉre boo paca ĩaña! —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Cʉ̃ jʉguero ca waa nʉnʉa waarã pea, cʉ̃ yerijãa waajato ĩirã, cʉ̃re tutimiupa. To biro cʉ̃ja ca ĩi pacaro, cʉ̃ pea bʉaro jañuro: —¡Jesús, David Pãrami, yʉre boo paca ĩaña! —ĩi acaro buiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús pea, to biro cʉ̃ ca ĩiro tʉo, tua nʉcãri, “Cʉ̃re ami dooya,” ĩiupi. Ca ĩatigʉ cʉ̃ pʉto cʉ̃ ca earo, o biro cʉ̃re ĩi jãiñaupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ñee ʉno mʉre yʉ ca tiiro mʉ booti? —ĩiupi. To biro cʉ̃ ca ĩiro, ca ĩatigʉ pea o biro cʉ̃re ĩi yʉʉupi: —Wiogʉ, yʉ cape ca ĩaro yʉ boo —cʉ̃re ĩiupi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩiupi: —¡Ĩaña! “Jesús yʉre catiocãrucumi,” díámacʉ̃ mʉ ca ĩi tʉgoeña bayirije jʉori mʉ ametʉene eco —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","To biro cʉ̃ ca ĩirije menara, ca ĩatimiricʉ añuro ĩacoari, Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo baja peo nʉnʉa waaupi Jesús mena waagʉ. Bojoca niipetirã atere ca ĩarã cãa, Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesús Jericóre ea, tii macãre tẽo taa nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tii macãre niiupi jĩcʉ̃ ca apeye paigʉ Zaqueo ca wãme cʉtigʉ, Roma maquẽre wapa jee bojari maja wiogʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Cʉ̃, Jesús're ĩarʉgamiupi. Ca emʉatigʉacã niima ĩigʉ, bojoca paʉ cʉ̃ja ca niiro macã, do biro tii ĩa eyotiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","To biri cʉ̃ja jʉguero ũmaa waa, Jesús're ĩarʉgʉ, cʉ̃ ca ametʉa waapa tabe pʉto ca niiricʉ yucʉgʉpʉ mʉacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesús tii tabere ametʉa waagʉ, emʉaro pee ĩa mʉene, Zaqueore ĩari, o biro cʉ̃re ĩiupi: —Zaqueo, yoari méé duwi dooya. Mecʉ̃ra mʉ yaa wiira yʉ earucu —cʉ̃re ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","To biro cʉ̃ ca ĩiro Zaqueo pea yoari méé duwi doo, ʉjea niirique mena cʉ̃ yaa wiipʉ jʉocoaupi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Teere ĩarã, niipetirã: —Ñañarije ca tiigʉ yaa wiipʉ cãnigʉ waami —ĩi wede paiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jiro Zaqueo cʉ̃ yaa wiipʉ niigʉ, wãmʉ nʉcã, o biro ĩiupi Jesús're: —Wiogʉ, yʉ ca cʉorije niipetirore, ca boo pacarãre decomacã yʉ tiicojorucu. Jĩcãrãre yʉ ca jee dutijata, bapari niirije cʉ̃jare yʉ tuene nemorucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesús pea o biro cʉ̃re ĩiupi: —Mecʉ̃ ati wii macãrãre cʉ̃ja ca ametʉarije ea. Ani cãa, Abraham pãramira niimi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yʉ, Ca Nii Majuropeegʉ Macʉ̃a, ca yairicarãre ama, cʉ̃jare ametʉene, tiigʉ doogʉ yʉ doowʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Bojoca to biro cʉ̃ ca ĩirijere cʉ̃ja ca tʉo niiro macã, Jesús pea jĩcã wãme ĩi cõoñari, cʉ̃jare wedeupi. Mee, Jerusalén pʉtoacã niiupa. To biri bojoca pea, “Mee Ʉmʉreco Pacʉ cʉ̃ ca dotipa cuu ea waaro biicu,” ĩi tʉgoeñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","To biri o biro cʉ̃jare ĩiupi Jesús: —Niiupʉ jĩcʉ̃, ca nii majuropeegʉ ca niigʉ, ca yoaropʉ ape yepapʉ ca waaricʉ, toopʉ wiogʉ jõene eco yapanori jiro ca tua doopʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cʉ̃ ca waaparo jʉguero, cʉ̃re ca pade coterãre, pʉa amo cõro niirã jʉo cojo, cʉ̃ja cõrorena wapa tiirica tiirire pairo cʉ̃jare tiicojo, o biro cʉ̃jare ĩiupʉ: “Ate, wapa tiirica tiiri mena apeye wapa tiiri, noni wapa taa niiña, yʉ ca tua earopʉ,” cʉ̃jare ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Cʉ̃ yaa yepa macãrã pea cʉ̃re ĩa tuti jañuuparã. To biri cʉ̃ jiro, cʉ̃ja mena macãrã jĩcãrãre tiicojouparã: “Ani, jãa wiogʉ cʉ̃ ca niiro jãa booti,” ca ĩiparãre. ");
INSERT INTO baoNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","”To biro cʉ̃ja ca ĩirije ca nii pacaro, wiogʉ jõene eco yapano, cʉ̃ yaa yepapʉ tuacoaupʉ ñucã. Tua ea, cʉ̃re ca pade coterãre wapa tiirica tiiri cʉ̃ ca tiicojoricarãre jʉo doti cojoupʉ, cʉ̃ja ca niiro cõro cʉ̃ja ca wapa taa nemoriquere majirʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ca ea jʉogʉ, o biro cʉ̃re ĩiupʉ: “Wiogʉ, mʉ yee wapa tiirica tiirire pʉa amo cõro niirije yʉ wapa taa nemojãwʉ,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","To biro cʉ̃ ca ĩiro: “Añu majuropeecã. Paderi majʉ añugʉ mʉ nii. Mee, petoacã cãare añuro ca ĩa nʉnʉjee majiricʉ mʉ ca niiro macã, pʉa amo cõro niiri macãrire ca dotipʉ mʉre yʉ cũu,” cʉ̃re ĩiupʉ cʉ̃ wiogʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","”Cʉ̃ jiro apĩ eaupʉ ñucã. “Wiogʉ, mʉ yee wapa tiirica tiirire, jĩcã amo cõro niirije yʉ wapa taa nemojãwʉ,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","To biro cʉ̃ ca ĩiro, cʉ̃ cãare o biro cʉ̃re ĩiupʉ: “Jĩcã amo cõro niiri macãrire ca dotipʉ mʉre yʉ cũu,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","”Cʉ̃ jiro apĩ o biro ĩi eaupʉ: “Wiogʉ, ate nii, mʉ wapa tiirica tiiri. Jutiro quejero mena ũmaari, yʉ queno cũu cʉo niirucujãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʉre yʉ uwi jañuwʉ. Mʉa do biro ca tiiya manigʉ, mʉ ca cũutirica taberena ca jeegʉ, mʉ ca otetirica taberena ote dicare jee, ca tiigʉ mʉ nii,” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","To biro cʉ̃ ca ĩiro, wiogʉ pea o biro cʉ̃re ĩi yʉʉupʉ: “Paderi majʉ ca añutigʉ, mʉ majuropeera mʉ ca ĩirije menara, ñañarije mʉ ca tiirique cʉtirijere yʉ ĩa bejerucu. Do biro ca tiiya manigʉ, yʉ ca cũutirica taberena ca jeegʉ, yʉ ca otetirica taberena ote dicare ca jeegʉ, yʉ ca niirijere maji pacagʉ, ");
INSERT INTO baoNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿ñee tiigʉ yʉ yee wapa tiirica tiirire, wapa tiirica tiiri queno cũurica wiipʉ mʉ cũutiri, yʉ ca tua earo, tee ca wapa taa nemorique mena yʉre tuenerʉgʉ?” cʉ̃re ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","To biro cʉ̃re ĩi, too ca niirãre o biro cʉ̃jare ĩiupʉ: “Anire, wapa tiirica tiirire ẽmari, pʉa amo cõro niirije ca wapa taa nemoricʉ peere cʉ̃re tiicojoya,” cʉ̃jare ĩiupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","”To biro cʉ̃ ca ĩiro, cʉ̃ja pea o biro cʉ̃re ĩiuparã: “Wiogʉ, mee cʉ̃a pʉa amo cõro niirijepʉ cʉomi doca,” ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","To biro cʉ̃ja ca ĩiro, wiogʉ pea o biro ĩi yʉʉupʉ: “Ca cʉogʉa, pai jañuro tiicojo nemo ecorucumi. Ca cʉotigʉ pea, petoacã cʉ̃ ca cʉorije menapʉra, ẽma ecocoarucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Yʉre ca ĩa junarã, cʉ̃ja wiogʉ yʉ ca niiro ca bootiricarã peera, ano pee cʉ̃jare jee doori, yʉ ca ĩa cojoro cʉ̃jare jĩa batecãña,” ĩiupʉ —ĩi wedeupi Jesús bojocare. ");
INSERT INTO baoNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Atere ĩi yapano, Jerusalén'pʉ waagʉ, waacã nʉnʉa waaupi ñucã Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Macãnʉcʉ̃ Olivos ca wãme cʉtiri buuro pʉto ca niiri macãri Betfagé, Betania, macãri pʉto ea waagʉ, cʉ̃ buerã pʉarãre tiicojori, ");
INSERT INTO baoNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","o biro cʉ̃jare ĩi cojoupi: —Ano díámacʉ̃ ca niiri macãpʉ waarãja. Tii macãre earã, jĩcʉ̃ burro jĩcʉ̃ peera cʉ̃ja ca peja ñaatigʉ cʉ̃ja ca jia tuu nʉcõricʉre mʉja bʉarucu. Cʉ̃re popiori, ano pee mʉja ami doowa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Jĩcãrã, “¿Ñee tiirã cʉ̃re mʉja popioti?” mʉjare cʉ̃ja ca ĩi jãiñajata, “Wiogʉ cʉ̃re boomi,” cʉ̃jare mʉja ĩiwa —cʉ̃jare ĩi cojoupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Cʉ̃ buerã pea waa, cʉ̃jare cʉ̃ ca ĩiricarore birora bʉa eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burrore cʉ̃ja ca popio niiro, cʉ̃ ʉparã pea: —¿Ñee tiirã cʉ̃re mʉja popioti? —cʉ̃jare ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","To biro cʉ̃ja ca ĩiro: —Wiogʉ cʉ̃re boomi —cʉ̃jare ĩiupa cʉ̃ja pea. ");
INSERT INTO baoNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jesús pʉto cʉ̃re ami ea, jotoa cʉ̃ja ca jãñarije jutire burro jotoa peori, cʉ̃re ami peoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús cʉ̃ ca waa nʉnʉa waaro cõrora, bojoca pea cʉ̃ja juti, jotoa cʉ̃ja ca jãñarijere maare cũu jʉgue nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Macãnʉcʉ̃ Olivos Buuro ca nii bua waari tabere cʉ̃ ca ea waarora, niipetirã cʉ̃re ca nʉnʉrã bʉaro ʉjea nii acaro bui, Ʉmʉreco Pacʉre baja peo jʉo waaupa, niipetirije ca ĩa ñaaña manirije cʉ̃ ca tii bau nii ĩñoriquere ca ĩaricarã niiri. ");
INSERT INTO baoNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","O biro ĩiupa: —Añuro ca biigʉ niimi, Wiogʉ, Ʉmʉreco Pacʉ wãme mena ca doogʉ. Ʉmʉreco tutipʉre jĩcãri cõro niirique to niijato. Cʉ̃ ca añu majuropeerije niipetiropʉ to niijato —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","To biro cʉ̃ja ca ĩiro, jĩcãrã fariseos, bojoca watoare ca niirã, o biro ĩiupa Jesús're: —Buegʉ, mʉre ca nʉnʉrãre, to cõrora cʉ̃jare yerijãa dotiya —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Anija cʉ̃ja ca yerijãajata, ʉ̃tãgaarira acaro buirucu —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalén macãre ea waagʉra, tii macãre ĩari, o biro ĩi otiupi Jesús: ");
INSERT INTO baoNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","—¡Mʉ cãare, ati rʉmʉ, añuro mʉ ca niipere ca jee doori rʉmʉ petira ca ĩa majicãpe niimi! Mecʉ̃ra, teere mʉ ca ĩa majiborique yaioropʉ mʉre niicã. ");
INSERT INTO baoNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Doorucu ñañaro mʉ ca biipa rʉmʉri, mʉ waparã, mʉ wejare camota nʉcã eari, niipetiri taberipʉ noo pee duti waa majiña maniro cʉ̃ja ca jĩa jãa doopa rʉmʉri. ");
INSERT INTO baoNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Díámacʉ̃ra mʉre tii yaiocã, mʉ bojocara jĩa peoticã, ñucã ʉ̃tãga apega jotoa pejaricaro maniropʉ tii yaiocã, tiirucuma. Mʉa, Ʉmʉreco Pacʉ mʉre cʉ̃ ca ametʉenegʉ doori tabere mʉ ĩa majiti —ĩi otiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jiro Jesús Ʉmʉreco Pacʉ yaa wiipʉ jãa waari, toopʉ ca noni wapa taa niirãre cʉ̃jare cõa wiene jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","O biro ĩiupi: —O biro ĩi owarique nii: “Yʉ yaa wii, juu buerica wii niirucu,” ĩi, mʉja pea tii wiire, jee dutiri maja cʉ̃ja ca niiri ope mʉja jeeñocãjapa —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","To cãnacã rʉmʉra Jesús Ʉmʉreco Pacʉ yaa wiipʉ bojocare buerucuupi. Paia ʉparã, doti cũuriquere ca jʉo buerã, to biri bojocare ca jʉo niirã pea, “¿Do biro pee tiiri cʉ̃re ca jĩa cõape to niimiti?” ĩi ama niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Biirãpʉa, cʉ̃re cʉ̃ja ca jĩapa wãmere bʉa majitiupa, bojoca niipetirã cʉ̃ ca wederijere cʉ̃ja ca tʉo niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Jĩcã rʉmʉ Jesús, Ʉmʉreco Pacʉ yaa wiipʉ bojocare bue, añurije quetire wede, cʉ̃ ca tii niiro, paia ʉparã, doti cũuriquere ca jʉo buerã, bojocare ca jʉo niirã mena eari, o biro cʉ̃re ĩi jãiñaupa: ");
INSERT INTO baoNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—Jãare wedeya: ¿Ñee doti majirique cʉocãri, to biro mʉ tii niiti? ¿Tee doti majiriquere ñiru mʉre cʉ̃ tiicojojãri? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","To biro cʉ̃re cʉ̃ja ca ĩiro, Jesús pee cãa o biro cʉ̃jare ĩi yʉʉupi: —Yʉ cãa, jĩcã wãme mʉjare yʉ jãiñarucu. Mʉja cãa yʉre yʉʉya. ");
INSERT INTO baoNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Ñiru Juan're, cʉ̃ uwo coe doti cojoupari? ¿Ʉmʉreco Pacʉ, bojoca pee cʉ̃re cʉ̃ja doti cojoupari? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","To biro cʉ̃ ca ĩiro cʉ̃ja pea, cʉ̃ja majurope o biro ameri ĩiupa: —“Ʉmʉreco Pacʉ cʉ̃re doti cojoupi,” mani ca ĩi yʉʉjata, “¿Ñee tiirã cʉ̃ ca wederijere díámacʉ̃ mʉja tʉo nʉnʉjeetiri?” manire ĩirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ñucã, “Bojoca cʉ̃re doti cojoupa,” mani ca ĩijata, bojoca ʉ̃tã mena manire dee jĩa cõacãrucuma. Mee niipetirã, “Ʉmʉreco Pacʉ cʉ̃ ca doti cojoricʉ niiwi Juan,” ca ĩirã wado niima —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","To biri o biro cʉ̃re ĩi yʉʉupa Jesús're: —Baa. Jãa majiti. Ñiru cʉ̃re doti cojojacupi doca —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","To biro cʉ̃ja ca ĩiro, Jesús pea: —To docare yʉ cãa, “Tee doti majirique mena to biro yʉ tii,” mʉjare yʉ ĩiticu —cʉ̃jare ĩi yʉʉupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jiro bojocare ati wãme ĩi cõoñari cʉ̃jare wedeupi Jesús: —Jĩcʉ̃, jĩcã weje, ʉje weje ote, paderi majare pade doti cũu, yoaro bii yujugʉ waagʉ, waacoaupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ʉje ca dica cʉtiri cuu ca earo, jĩcʉ̃ cʉ̃re pade coteri majʉre, paderi maja pʉtopʉ cʉ̃re tiicojoupʉ cʉ̃ yee ca niirijere cʉ̃ja dica woo cojojato ĩigʉ. Cʉ̃ ca earo, paderi maja pea cʉ̃re paa, ñee jãa manigʉ cʉ̃re tii ãcũ tuenecã cojouparã. ");
INSERT INTO baoNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Jiro tii weje ʉpʉ apĩre tiicojomiupʉ ñucã. Cʉ̃ cãare cʉ̃re paa, ñañaro cʉ̃re ĩi tuti, ñee jãa manigʉ cʉ̃re tii ãcũ tuenecã cojouparã. ");
INSERT INTO baoNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Apĩre tiicojo nemomiupʉ ñucã. Cʉ̃ cãare to birora, cʉ̃re cami tuu, tii weje tʉjaropʉ cʉ̃re tii ãcũ wooenecã cojouparã. ");
INSERT INTO baoNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","”To biro tii ñami waagʉ, ʉje weje ʉpʉ o biro ĩi tʉgoeñaupʉ: “¿Do biro yʉ tiigʉti? Jaʉ. Yʉ macʉ̃, yʉ ca maigʉre, yʉ tiicojorucu. Ape tabera cʉ̃re nʉcʉ̃ bʉocãbocuma,” ĩi tʉgoeñaupʉ. To biro ĩi, cʉ̃re tiicojoupʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","”Paderi maja pea cʉ̃re ĩacãrãpʉa, o biro ameri ĩiuparã: “Ani niimi, ati wejere ca cʉo nʉnʉjeepʉ, cʉ̃re mani jĩa cõacãco, ati weje mani yaa weje ca tuapere biro ĩirã,” ĩiuparã. ");
INSERT INTO baoNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","To biri ʉje weje tʉjaropʉ cʉ̃re ami witi waa, cʉ̃re jĩa cõacãuparã. ”¿“Mʉja, ʉje weje ʉpʉ do biro cʉ̃jare tiirucumi,” mʉja ĩi tʉgoeñati? ");
INSERT INTO baoNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Cʉ̃ majuropeera waa, paderi majare jĩa bate, aperã peere tii wejere cʉ̃jare tiicojorucumi —ĩiupi. To biro cʉ̃ ca ĩirijere tʉorã, bojoca pea o biro ĩiupa: —Biiticu tea —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","To biro cʉ̃ja ca ĩiro, Jesús pea cʉ̃jare ĩari, o biro ĩiupi: —To docare ¿do biro ĩirʉgaro to ĩiti, Ʉmʉreco Pacʉ wederique: “Wii bʉari maja ʉ̃tãga cʉ̃ja ca beje cõamiricagara ca nii majuropeerica tua,” ca ĩirijea? ");
INSERT INTO baoNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tiiga ʉ̃tãga jotoare ca ñaapearã cõrora, doca jude batecã yai waarucuma. Ñucã tiiga pee no ca boogʉre to ca ñaapeajata, doca abo yaiocãrucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Paia ʉparã, doti cũuriquere ca jʉo buerã pea, ĩi cõoñari cʉ̃ ca wederijere, “Manirena ĩigʉ ĩimi,” ĩi tʉo majiri, jĩcãtora cʉ̃re ñeerʉgamiupa. Bii pacarã, bojocare uwi jañuupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","To biri jĩcãrã ca bojoca añurãre biro bii ditori, Jesús jĩcã wãme cʉ̃ ca ĩi maa wijiaro cʉ̃ja tiijato ĩirã, ca ĩa duti coterãre tiicojoupa: “No ca booro cʉ̃ ca ĩijata, wiogʉpʉre mani wedejãajaco,” ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","To biri cʉ̃ja pea o biro cʉ̃re ĩi jãiñaupa: —Buegʉ, mʉ ca ĩirijere, mʉ ca buerijere, ca niirore biro díámacʉ̃ra mʉ ca ĩirijere jãa maji. Bojocare mʉ ĩa dica wooti. Ʉmʉreco Pacʉ cʉ̃ ca boorore biro niiriquere díámacʉ̃ mʉ wede. ");
INSERT INTO baoNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","To biri: ¿Roma macʉ̃ wiogʉre niirique wapa, jãa ca wapa tiirije to añucãti? ¿To añutitiqué? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús pea, ñañari wãme tʉgoeñacãri cʉ̃ja ca ĩirijere majiri, o biro cʉ̃jare ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Jĩcã tii, wapa tiirica tii yʉre ĩñoña. ¿Ati tiipʉre owa tuurique ñiru wãme, ñiru diámacʉ̃ to niiti? —ĩi jãiñaupi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea: —Wiogʉ César yee nii —ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","To biri Jesús pea: —To docare wiogʉ yee ca niirijere, wiogʉre tiicojoya. Ʉmʉreco Pacʉ yee ca niirijere Ʉmʉreco Pacʉre tiicojoya —cʉ̃jare ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Jĩcã wãme peerena bojoca cʉ̃ja ca tʉo cojoro cʉ̃ ca ĩirijere, cʉ̃re cʉ̃ja ca wedejãapa wãmere bʉatiupa. To biri cʉ̃ ca yʉʉ majirijere tʉo ʉcʉacoa, do biro pee ĩi majiti, wedeticã nʉcã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jiro, jĩcãrã saduceos, Jesús're ĩarã waaupa. Saduceos, “Ca bii yairicarãpʉa pʉati cati tuatima,” ca ĩirã niima. To biri o biro cʉ̃re ĩi eaupa: ");
INSERT INTO baoNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Buegʉ, Moisés o biro manire ĩi owa cũuquĩupi: “Jĩcʉ̃ nʉmo cʉti, puna manigʉra cʉ̃ ca bii yaijata, cʉ̃ yee wedegʉ nʉmo ca niiricore nʉmo cʉtiri, cʉ̃ yee wedegʉ ca bii yairicʉre, cʉ̃ puna cʉti wajoa bojajato,” ĩi owaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","To biri yua, jĩcãti niiupa jĩcã amo peti, ape amore pʉaga penituaro niirã jĩcʉ̃ puna. Ca nii jʉogʉ nʉmo cʉti, puna manigʉra bii yaicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jiro macʉ̃, ");
INSERT INTO baoNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ñucã jiro macʉ̃ cãa, cõrena nʉmo cʉti, puna manirãra bii yaicoaupa. Cʉ̃ja jĩcã amo peti, ape amore pʉaga penituaro ca niirãpʉra, cõ wadorena nʉmo cʉtiñami, puna manirã wado bii yai peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Cʉ̃ja jiro cõ cãa bii yaicoaupo. ");
INSERT INTO baoNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To docare yua, cati tuarica tabepʉra, cʉ̃ja, jĩcã amo peti, ape amore pʉaga penituaro ca niirã nʉmo ca niirico, ¿nii nʉmo pee cõ niigoti yua? —ĩi jãiñaupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","To biro cʉ̃ja ca ĩi jãiñaro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —Bojoca, ati yepare cʉ̃ja ca cati niiri rʉmʉrire ʉmʉa nʉmo cʉti, nomia manʉ cʉti, tii niima. ");
INSERT INTO baoNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","To biri cati tuari, ape yepapʉre ca ea waaparã ʉnora ca niirã, ʉmʉa nʉmo cʉti, nomia manʉ cʉti, tiitirucuma, ");
INSERT INTO baoNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ca bii yaitiparã niiri. Ʉmʉreco Pacʉ pʉto macãrãre birã nii, ñucã Ʉmʉreco Pacʉ puna nii, biirucuma, ca cati tuaricarãpʉ niiri. ");
INSERT INTO baoNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés majuropeera yucʉgʉ ca ʉ̃ʉ nucũricʉ quetire cʉ̃ ca owarique mena, ca bii yairicarã cʉ̃ja ca cati tuarijere mani ca majiro tiimi. Tii tabere Ʉmʉreco Pacʉ: “Yʉa, Abraham, Isaac, Jacob, Ʉmʉreco Pacʉ yʉ nii,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Cʉ̃a, ca bii yairicarã Ʉmʉreco Pacʉ méé niimi. Ca catirã Ʉmʉreco Pacʉ niimi. Ʉmʉreco Pacʉra niipetirã ca catirã wado niicãma —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","To biro cʉ̃ ca ĩiro, jĩcãrã doti cũuriquere ca jʉo buerã o biro cʉ̃re ĩiupa: —Buegʉ, díámacʉ̃ peti mʉ ĩi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","To biri cʉ̃re jãiña nemorʉgarucu, tiitiupa yua. ");
INSERT INTO baoNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús o biro cʉ̃jare ĩi jãiñaupi: —¿Ñee tiirã Mesías're, “David pãrami niimi,” cʉ̃ja ĩirucuti? ");
INSERT INTO baoNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","David majuropeera Salmos pũuropʉre o biro ĩi owaupi: “Ʉmʉreco Pacʉ, yʉ Wiogʉre o biro ĩiwi: ‘Ano yʉ díámacʉ̃ nʉña pee duwiya, ");
INSERT INTO baoNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","mʉ waparãre cʉ̃ja ca doca cũmuro yʉ ca tiiropʉ,’ ĩiwi,” ĩiupi David. ");
INSERT INTO baoNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿To docare do biro biicãri, David majuropeera “Yʉ Wiogʉ,” cʉ̃ ca ĩigʉ nii pacagʉ, cʉ̃ pãrami cʉ̃ niibogajati Mesías? —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Bojoca niipetirã cʉ̃ja ca tʉo cojoro, o biro ĩiupi Jesús, cʉ̃ buerãre: ");
INSERT INTO baoNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Doti cũuriquere ca jʉo buerã cʉ̃ja ca biirique cʉtirijere ĩa maji, bojoca catiri niiña. Cʉ̃ja, juti yoerije jãñacãri waa yuju, apeye nonirica taberipʉ cʉ̃ja ca waa yujujata cãare, nʉcʉ̃ bʉorique mena jãi, tiirique booma. Nea poo juu buerica wiijeripʉre wiorã cʉ̃ja ca duwirijepʉ wado duwirʉga, baarica taberi cãare añuri taberi wado ama, biima. ");
INSERT INTO baoNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ñucã ca manʉ jʉ̃mʉa bii yai weo ecoricarã romiri yaa wiijerire ẽmama. To biro ca tiirã nii pacarã, teere tii ditorã, “¡Ca bojoca añurã peti niima!” jãare cʉ̃ja ĩijato ĩirã, yoaro juu buema. Cʉ̃ja, ametʉenero ñañaro tii ecorucuma —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús, Ʉmʉreco Pacʉ yaa wiipʉre, Ʉmʉreco Pacʉre tiicojo nʉcʉ̃ bʉorã jãarica cũmuaripʉre, ca apeye pairã wapa tiirica tiiri cʉ̃ja ca jãaro ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ñucã ca manʉ bii yai weo ecorico ca apeye boo pacago cãa, pʉa tiiacã wapa tiirica tiiri cõ ca jãaro ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","To cõrora o biro ĩiupi Jesús: —Yee méé mʉjare yʉ ĩi. Atio, ca manʉ bii yai weo ecorico boo pacoro ca biigo pea, niipetirã ametʉenero tiicojomo. ");
INSERT INTO baoNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Niipetirãpʉra, pairo ca cʉorã niiri, cʉ̃jare ca dʉjarijepʉre tiicojoma. Cõ pea, cõ ca boo pacarije menara cõ ca wapa tii baa catibopeacãrena tiicojo peoticãmo —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jĩcãrã cʉ̃ buerã mena macãrã, Ʉmʉreco Pacʉ yaa wiire añurije ʉ̃tã mena, ñucã Ʉmʉreco Pacʉre cʉ̃ja ca tiicojo nʉcʉ̃ bʉorique mena cʉ̃ja ca wãmoriquere ĩari, ameri wede peni niiupa. Jesús pea o biro ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Ano mʉja ca ĩarije niipetiro, jĩcãga ʉ̃tãga jotoare apega ca pejatiropʉ cʉ̃ja ca tiipa rʉmʉri earucu. Niipetirije tii yaio ecocoarucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi jãiñaupa: —Buegʉ, ¿tea no cõropʉ to biiroti? ¿Tee ca biiparo jʉguero, do biirije to bii ĩño jʉgueroti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","To biro cʉ̃ja ca ĩiro, cʉ̃ pea o biro cʉ̃jare ĩiupi: —Bojoca catiri niiña, jãa ĩi dito ecore ĩirã. Paʉ doorucuma yʉ wãme mena ĩicãri: “Yʉra yʉ nii Cristo. Mee, tii cuu eacoaro bii,” ca ĩiparã. To biro ca ĩirãre nʉnʉticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Ñucã ameri jĩa, cʉ̃ja ca doti niirijere ameri bii ametʉene nʉcʉ̃, cʉ̃ja ca biirijere queti tʉorã uwiticãña. Ate bii jʉorucu. Biiropʉa ména ati ʉmʉreco ca petirije jĩcãto bii eatirucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","O biro ĩi nʉnʉa waaupi: —Jĩcã yepa macãrã, ape yepa macãrã mena ameri jĩa, ñucã jĩcã pooga macãrã, ape pooga macãrã mena ameri jĩa, tiirucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Bʉaro jita jabe, niipetiri taberipʉrena aʉa boarique, diarique ca punirije, waarucu. Ʉmʉreco tutipʉre uwiorije, ca ĩa ñaaña manirije ca bii ĩño jʉguerije baurucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","”Ména ate ca biiparo jʉguero, mʉjare ñee, ñañaro mʉjare tiirʉga nʉnʉjee, biirucuma. Jãiña bejerʉgarã nea poo juu buerica wiijeripʉ mʉjare jee waa, tia cũurica wiijeripʉ mʉjare tia cũu, ñucã yʉ yee jʉori, ʉparã pʉtoripʉ, bojocare ca jʉo niirã pʉtoripʉ, mʉjare jee waarucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","To biro mʉjare cʉ̃ja ca tiiro, yʉ yee maquẽre cʉ̃jare mʉja ca wedepe niirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","“Ñee ʉno peere ñañarije jãa tiitijãwʉ,” cʉ̃jare mʉja ca ĩi ametʉapere, “O biirije cʉ̃jare mani ĩi yʉʉjaco,” ĩi tʉgoeña queno yueticãña. ");
INSERT INTO baoNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Yʉ majuropeera, bʉaro majirique mena mʉja ca wedepere mʉjare yʉ tiicojorucu, jĩcʉ̃ peera mʉjare ca ĩa tutirã, do biro pee ĩi majiti, mʉjare boca yʉʉ majiti, cʉ̃ja ca biipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Biirãpʉa, mʉja pacʉara, mʉja yaarãra, mʉja yee wederãra, mʉja mena macãrãra mʉjare wedejãa buiyeecãrucuma. Mʉja mena macãrã jĩcãrãre jĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Yʉ yee jʉori, bojoca niipetirã mʉjare ĩa tutirucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Biiropʉa, mʉja dʉpʉga maquẽ poa jĩcã daa ʉnora yaicoa biitirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","To birora mʉja ca tʉgoeña bayicõa niijata, caticõa niiriquere mʉja bʉarucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","”Jerusalén macãre uwamarã cʉ̃ja ca nii amojodero ĩarã, “Mee, yoari mééra ati macã cõa ecoro dooro tii,” ĩi majiña. ");
INSERT INTO baoNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","To cõrora Judea yepare ca niirã, ʉ̃tã yucʉpʉ cʉ̃ja duticoajato. Jerusalén macãre ca niirã, tii macãre cʉ̃ja witicoajato. Ñucã macã tʉjaro ca niirã cãa, macã peere cʉ̃ja tua dooticãjato. ");
INSERT INTO baoNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ñañaro biirica rʉmʉri, Ʉmʉreco Pacʉ yee queti owarique ca ĩirore biro ca bii eari rʉmʉri niiro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ñañaro peti tamʉorucuma, to biro ca biiri rʉmʉrire, ʉtaaga pacoa ca niirã, ñucã ũpũrãacã ca puna cʉtirã romiri. Ati yepare ñañaro tamʉorique niirucu. Ñucã Israel yaa pooga menare ñañaro peti cʉ̃ ca tiirije niiro biirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Jĩcãrã niipĩiri mena jĩa eco yairucuma. Aperãra, niipetiri yeparipʉ cʉ̃jare ñee waarucuma. Judíos ca niitirã Jerusalén're ñañaro tii yaiorã tiirucuma. “To cõro biirucu,” cʉ̃ ca ĩirica cuu ca earopʉ, tii yerijãarucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","”Muipũ, ʉmʉreco macʉ̃re, ñami macʉ̃re, to biri ñocõare ca ĩa ñaaña manirije bii jʉorucu. Ati yepa peera bojoca poogaari niipetirãpʉra bʉaro tʉgoeñarique pai, dia pairiya ca jabero uwiorije ca bʉjʉrije jʉorira, do biro pee bii majiti, biicãrucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Bojoca, ati yepare ca biipere tʉgoeña uwima ĩirãra, dia ñaacãrucuma. Ʉmʉreco tutipʉre ca niirã menapʉra yugui peticoarucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","To cõrora yʉ, Ca Nii Majuropeegʉ Macʉ̃re, yʉ ca tutuarije do biro ca tiiya manirije mena, bueri bʉrʉapʉ yʉ ca boe bate duwi dooro yʉre ĩarucuma. ");
INSERT INTO baoNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ate to ca bii jʉo dooro, tʉgoeña tutua, emʉaro pee ĩa mʉene, tiiya. Mee, yoari mééra mʉja ametʉene ecorucu —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ate mena ĩi cõoñari, cʉ̃jare wedeupi ñucã: —Higueragʉre to biri no ca booricʉ yucʉgʉre ĩañaaqué. ");
INSERT INTO baoNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","To ca pũu wajoaro ĩarã, “Mee, cʉ̃ma jʉguero niicã doo,” mʉja ĩi ĩa maji. ");
INSERT INTO baoNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","To biro mʉja ca ĩi ĩa majirore birora ano mʉjare yʉ ca ĩirije ca biiro ĩarã, “Mee, Ʉmʉreco Pacʉ cʉ̃ ca dotipa cuu ea dooro bii,” ĩi ĩa majiña. ");
INSERT INTO baoNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Díámacʉ̃ra mʉjare yʉ ĩi, ano mʉjare yʉ ca ĩirije niipetirije, ati cuu macãrã cʉ̃ja ca bii yaiparo jʉguero biirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ati ʉmʉreco, ati yepa, peticoarucu. Yʉ wederique pea yai nʉcãtirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","”Bojoca catiya, ati yepare niirã tii niirique, cũmurique, ati yepare cati niirã bʉaro boo tʉgoeñarique jʉori, ca tʉo nʉnʉjeetirã mʉja ca niiro mʉjare ca tiitipere biro ĩirã. Mʉja ca bojoca catitijata, to biro ca biiri rʉmʉ, “To biro biibocu,” mʉja ca ĩitiri tabera mʉjare bii eacãrucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ati yepa macãrã niipetirãpʉre, yoo yuerica tabe ca tiirore biro bii earo biirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","To biri añuro nii yueya. To birora juu buecõa niiña. Ate niipetirije ñañaro ca biipere ametʉa, ñucã yʉ, Ca Nii Majuropeegʉ Macʉ̃re boboricaro maniro boca, mʉja ca biipere biro ĩirã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jesús, ʉmʉrecora Ʉmʉreco Pacʉ yaa wiipʉ bojocare bue, ñami peera Olivos ca wãme cʉtiri macãnʉcʉ̃ buuropʉ cãnigʉ waarucuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Bojoca niipetirã, ca boerije mena, Ʉmʉreco Pacʉ yaa wiipʉ waarucuupa, Jesús cʉ̃ ca wederijere tʉorã waarucurã. ");
INSERT INTO baoNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Mee, pan're ca wauarije ca ayiaya manirijere cʉ̃ja ca baari boje rʉmʉ, Pascua ea waaro biiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Paia ʉparã, doti cũuriquere ca jʉo buerã, bojocare uwima ĩirã, Jesús're cʉ̃ja ca jĩapa wãmere ama niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","To biro cʉ̃ja ca ĩi niiri tabere, Judas Iscariote, Jesús buerã, pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena macʉ̃rena, cʉ̃ yeripʉ ñaajãa nʉcãupi Satanás. ");
INSERT INTO baoNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Cʉ̃ pea, paia ʉparãre, to biri Ʉmʉreco Pacʉ yaa wiire ca coterãre ĩagʉ waari, “Jesús're o biro tiiri cʉ̃re mʉja ca ñeero yʉ tiirucu,” ĩi wede peniupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Cʉ̃ja pea teere tʉo ʉjea nii: —Wapa tiirica tiiri mʉre jãa tiicojorucu —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","To biri cʉ̃ pea, teere ñeecãri, bojoca cʉ̃ja ca maniri tabe ʉnore ama jʉo waaupi, Jesús're ñee dotirʉgʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Pan're ca wauarije ca ayiaya manirije baarica boje rʉmʉre, Pascua macʉ̃ oveja macʉ̃re cʉ̃ja ca jĩari rʉmʉ ca earo, ");
INSERT INTO baoNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús pea Pedrore, Juan're, o biro cʉ̃jare ĩi cojoupi: —Pascua boje rʉmʉ mani ca baapere queno yuerãja —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","To biro cʉ̃jare cʉ̃ ca ĩiro: —¿Noopʉ jãa ca queno yuero mʉ booti? —cʉ̃re ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi Jesús: —Macãre piya waarãra mʉja bʉarucu jĩcʉ̃, ocorʉ ca ami waagʉre. Cʉ̃re nʉnʉ waa, cʉ̃ ca jãa waari wiipʉ eari, ");
INSERT INTO baoNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","tii wii ʉpʉre o biro cʉ̃re mʉja ĩirucu: “Buegʉ o biro ĩi jãiñami: ‘¿Dii jawi to niiti, yʉ buerã mena Pascua boje rʉmʉre yʉ ca baapa jawi?’ ĩimi,” cʉ̃re mʉja ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","To biro mʉja ca ĩiro, jotoa macã jawi, pairi jawi, mee queno yuerica jawipʉre, mʉjare ĩñorucumi. Toopʉ mani ca baapere mʉja quenowa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","To biro cʉ̃ ca ĩi yapanoro waarã, Jesús cʉ̃jare cʉ̃ ca ĩiricarore birora bʉa eaupa. Toopʉ Pascua cʉ̃ja ca baapere quenoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Baarica tabe ca earo, Jesús, cʉ̃ buerã, baarique peorica pĩi pʉto ea nuu waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesús pea o biro cʉ̃jare ĩiupi: —“¡Yʉ ca bii yaiparo jʉguero bʉaro peti mʉja mena ati Pascua boje rʉmʉre yʉ baarʉgarucuwʉ! ");
INSERT INTO baoNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ʉmʉreco Pacʉ cʉ̃ ca dotiri cuu ca eaparo jʉguero pʉati yʉ baa nemotirucu,” mʉjare yʉ ĩi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","To biro ĩi, jinirica bapare ami, Ʉmʉreco Pacʉre, “Añu majuropeecã,” ĩi yapano, o biro cʉ̃jare ĩiupi cʉ̃ buerãre: —“Atere amiri, mʉja majurope ameri bato cojoya. ");
INSERT INTO baoNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ʉje ocore, Ʉmʉreco Pacʉ cʉ̃ ca dotiri cuu ca eaparo jʉguero yʉ jini nemotirucu,” mʉjare yʉ ĩi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","To biro ĩicã ñucã, pan'gare ami, Ʉmʉreco Pacʉre, “Añu majuropeecã” ĩi yapano pee bato noni cojogʉra, o biro cʉ̃jare ĩiupi: —Atea yʉ upʉri nii, mʉja yee ca niipere ĩima ĩigʉ, yʉ ca bii yai bojarije. Yʉre tʉgoeñarã atere tiiya —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ñucã baa yapano, cʉ̃ ca tiiricarore birora jinirica bapa cãare amiri, o biro ĩiupi: —Ati bapa, yʉ díi mena, “Ʉmʉreco Pacʉ wãma wãme yʉ tiirucu,” cʉ̃ ca ĩiricarore biro to biijato ĩigʉ, mʉja yee ca niipere yʉ ca bii yai bojape nii. ");
INSERT INTO baoNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yʉre ca wedejãa buiyee cõapʉ cãa, ano yʉ menara baa duwimi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Biigʉpʉa, yʉ, Ca Nii Majuropeegʉ Macʉ̃a, “To biro biirucumi,” cʉ̃ ca ĩiricarore birora biigʉ doogʉ yʉ tii. Yʉre ca wedejãa buiyee cõagʉ pea, ñañaro peti biigʉ doogʉ tiimi —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","To biro cʉ̃ ca ĩirora, cʉ̃ja majurope: —¿Ñiru peti cʉ̃ niigʉti, cʉ̃re ca wedejãa buiyee cõapʉ? —ameri ĩi jãiña jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Cʉ̃ buerã pea ñucã: —¿Niipe mani mena macʉ̃ ca nii majuropeegʉ cʉ̃ niigʉti? —ameri ĩi wede pai niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩiupi: —Ʉmʉreco Pacʉre ca majitirã watoare, ati yepa macãrã ʉparã, cʉ̃ja bojocare tutuaro mena doti epema, cʉ̃jare ca doti niirã peera, “Añurijere ca tiirã niima,” cʉ̃jare ĩi wãmeo tiima. ");
INSERT INTO baoNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mʉja pea, to biro ca biitiparã mʉja nii. To biro biitirãra, mʉja watoare ca nii majuropeegʉ ca niigʉa, ca wãma maja doogʉre biro cʉ̃ biijato. Ñucã ca dotigʉ cãa, pade bojari majʉre biro pee cʉ̃ niijato. ");
INSERT INTO baoNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","To docare: ¿Ñiru pee cʉ̃ niiti, ca nii majuropeegʉ, ca baa ea nuu waagʉ pee, baariquere ca peo cotegʉ pee? ¿Baariquere peorica pĩi pʉto ca baa duwigʉ pee méé cʉ̃ niiti? Yʉ pea mʉja watoare baarique ca peo cotegʉre biro yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Mʉja, ñañaro yʉre ca biiri taberi cãare yʉ menara mʉja niicõa niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","To biri yʉ Pacʉ, wiogʉ yʉre cʉ̃ ca tiiricarore birora, yʉ cãa, wiorã mʉja ca niiro mʉjare yʉ tiirucu, ");
INSERT INTO baoNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","yʉ ca doti niiri tabepʉ, yʉ mena baa, jini, ñucã Israel yaa pooga macãrã pʉa amo peti, dʉpore pʉaga penituaro ca niiri punaarire jãiña bejerʉgarã, wiorã cʉ̃ja ca duwiri cũmuroripʉ ea nuu waa, mʉja ca biipere biro ĩigʉ —cʉ̃jare ĩiupi Jesús cʉ̃ buerãre. ");
INSERT INTO baoNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ñucã o biro ĩiupi Jesús: —Simón, Simón, tʉoya. Yʉre mʉja ca tʉo nʉnʉjeerijere mʉja ca yerijãaro tiiri, ñañaro tiirʉgʉ jãijãwi Satanás. ");
INSERT INTO baoNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","To biro cʉ̃ ca ĩi pacaro, yʉ pea mʉre yʉ juu bue bojajãwʉ, mʉ ca tʉo nʉnʉjee yerijãatipere biro ĩigʉ. Mʉ pea ñucã tʉgoeña yeri wajoa, yʉre tʉo nʉnʉjee, biigʉ, mʉ yaarãre cʉ̃ja ca tʉgoeña bayiro cʉ̃jare mʉ tiiwa —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","To biro cʉ̃ ca ĩiro, Simón pea o biro cʉ̃re ĩiupi: —Wiogʉ, yʉa mʉ menara tia cũurica wiipʉ waa, mʉ menara bii yai, ca biipʉra niicãgʉ yʉ bii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Pedro, mecʉ̃ra, ãbocʉ cʉ̃ ca wãcãparo jʉguero itiati peti, “ ‘Jesús're yʉ majiti,’ mʉ ĩi ditorucu,” mʉre yʉ ĩi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jiro Jesús o biro cʉ̃jare ĩi jãiñaupi: —Wajopoari, wapa tiirica tiiri, dʉpo juti, jeericaro maniro mʉjare yʉ ca tiicojo cojoriquere, ¿jĩcã wãme mʉjare to dʉjacãri? —ĩiupi. To biro cʉ̃ ca ĩiro cʉ̃ja pea: —Dʉjatiwʉ —cʉ̃re ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiupi: —Mecʉ̃ docare yua, wajopoa ca cʉogʉa, cʉ̃ ami waajato. Wapa tiirica tiiri ca cʉogʉ cãa cʉ̃ jee waajato. Niipĩi ca cʉotigʉa, mʉ jutiro jotoa macãrore noni wapa jeeri, niipĩi wapa tiiya. ");
INSERT INTO baoNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","O biro cʉ̃ja ca ĩi owarique, cʉ̃ja ca ĩiricarore birora yʉrena biirucu: Ñañarã watoapʉ biicã yai waawi. Niipetirije yʉ yee maquẽre cʉ̃ja ca owarique tee ca ĩirore biro ca biipe niiro bii —ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","To biro cʉ̃ ca ĩiro, cʉ̃ja pea o biro ĩiupa: —Wiogʉ, ano pʉa pĩi niipĩiri nii —ĩiupa. To biro cʉ̃ja ca ĩiro: —To cõrora ĩiña —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Witi, cʉ̃ ca biirucuricarore biro, Olivos ca wãme cʉtiri buuropʉ waacoaupi Jesús. Cʉ̃ buerã cãa cʉ̃re nʉnʉ waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Toopʉ eagʉ, o biro cʉ̃jare ĩiupi: —Ñañarije ca bii buiyeerijere jãa tiire ĩirã, juu bueya —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Cʉ̃ pea, ʉ̃tãga dee cojoricaro ca ñaacũmuro cõro yoaro cʉ̃ja jʉguero waa, juu buegʉ doogʉ, cʉ̃ ãjʉro jupea ména tuetuu ea nuu waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","O biro ĩi juu bueupi: —Cáacʉ, mʉ ca boojata, ano ñañaro yʉ ca tamʉopere yʉre ametʉeneña. Biigʉpʉa mʉ ca boori wãme tiiya. Yʉ ca boorore biro méé tiiya —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","To biro cʉ̃ ca ĩi juu bue niiri tabera, cʉ̃ ca tʉgoeña tutuaro cʉ̃re tiigʉ eagʉ, jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃ cʉ̃re baua eaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesús pea ñañaro cʉ̃ ca bii tʉgoeñarique pairije watoara, bʉaro jañuri juu bueupi. Cʉ̃ ca aji puarije oco pea díire biirije bʉcʉ ñaaupe yepapʉre. ");
INSERT INTO baoNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Juu bue yapano, wãmʉ nʉcã, cʉ̃ buerã pʉto pee waagʉ, bʉaro tʉgoeñarique paima ĩirã ca cãni cũmu waaricarãpʉre eaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","To biro bii, o biro cʉ̃jare ĩiupi: —¿Ñee tiirã mʉja cãniti? Wãcãri juu bueya, ñañarije ca bii buiyeerijere jãa tiire ĩirã —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ména Jesús to biro cʉ̃ ca ĩi niirora, paʉ bojoca eaupa. Judas ca wãme cʉtigʉ, cʉ̃ buerã, pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena macʉ̃ra cʉ̃jare maa jʉgueupi. Cʉ̃ pea, cʉ̃ wajopuare ũpũrʉgʉ Jesús pʉto waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","To biro cʉ̃ ca biiro, Jesús pea o biro cʉ̃re ĩi jãiñaupi: —¿Judas, wajopuare ũpũrique mena, Ca Nii Majuropeegʉ Macʉ̃re mʉ wedejãa cõati? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesús mena ca niirã pea to biro ca biirije ĩari, o biro ĩiupa: —¿Wiogʉ, niipĩiri mena cʉ̃jare jãa quẽeti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","To cõrora jĩcʉ̃ cʉ̃ja mena macʉ̃, paia wiogʉre pade bojari majʉ amopero díámacʉ̃ nʉña peere paa taa ñoocã cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","To biro cʉ̃ ca tiiro, o biro ĩiupi Jesús: —Tiiticãña. To cõrora tiiya —ĩiupi. To biro ĩi cʉ̃ amoperore padeña, cʉ̃re yʉjʉo, tiicãupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","To biro tiicã, cʉ̃re ca ñeerã dooricarã paia ʉparã, Ʉmʉreco Pacʉ yaa wii coteri majare, aperã judíos're ca jʉo niirãre, o biro cʉ̃jare ĩiupi Jesús: —¿Ñee tiirã, jĩcʉ̃ jee dutiri majʉre ca ñeerã waarãre biro niipĩiri, yucʉ dʉcari, jeecãri mʉja doojãri? ");
INSERT INTO baoNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ʉmʉrecori cõro, Ʉmʉreco Pacʉ yaa wiipʉ mʉja mena yʉ niirucujãwʉ. Yʉre ñeerʉgarucu mʉja tiitirucujãwʉ. Biiropʉa, mecʉ̃ to biro mʉja ca tiipa tabe ñañarije wiogʉ cʉ̃ ca dotirijere mʉja ca tiiri tabe mʉjare ea —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","To cõrora Jesús're cʉ̃re ñee, paia wiogʉ yaa wiipʉ cʉ̃re amicoaupa. Pedro pea yoaropʉ cʉ̃jare nʉnʉupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Jiro cʉ̃ja pea toopʉre, macã yepa decomacãre pecame cʉ̃ja ca dioro tii pecame pʉto juma ea nuu waaupa. Pedro cãa cʉ̃ja watoa juma ea nuu waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Too cʉ̃ ca juma duwirucuro, jĩcõ pade coteri majo añuro cʉ̃re ĩa, o biro ĩiupo: —Ani cãa, cʉ̃ menara niirucuwi —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","To biro cõ ca ĩiro, Pedro pea o biro ĩi ditoupi: —Nomio, yʉa cʉ̃re yʉ majiti —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ca yoa waatirora ñucã apĩ Pedrore ĩari, o biro ĩiupi: —Mʉ cãa, cʉ̃ja mena macʉ̃ra mʉ nii cã́jí —ĩiupi. Pedro pea o biro cʉ̃re ĩi yʉʉupi: —Cʉ̃ méé yʉ nii nija —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Peeto ca yoa waaro jiro apĩ ñucã o biro cʉ̃re ĩicãupi: —Yee méé yʉ ĩi jĩi, “Ani cãa cʉ̃ menara niijãwi. Ĩañaaqué. Galilea macʉ̃ra niimi” —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","To biro cʉ̃ ca ĩiro, Pedro pea o biro ĩiupi: —¡Ñee ʉnore ĩigʉ mʉ ĩiti nija! Yʉ majiti —ĩiupi. Pedro, to biro cʉ̃ ca ĩi niirora, ãbocʉ wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","To cõrora Jesús pea cʉ̃re amojode ĩaupi Pedrore. Cʉ̃re cʉ̃ ca ĩarora, Pedro pea: “Ati ñami, ãbocʉ cʉ̃ ca wedeparo jʉguero, itia tii, ‘Cʉ̃re yʉ majiti,’ mʉ ĩi ditorucu,” cʉ̃re cʉ̃ ca ĩiriquere tʉgoeña bʉaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","To cõrora too ca niiricʉ witi waa, bʉaro otiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jesús're ca cote niirã pea, ñañaro cʉ̃re ĩi epe, cʉ̃re paa, tii niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Cʉ̃ capere jutiro quejero mena jia biatori, o biro cʉ̃re ĩi jãiñaupa: —Ĩi bʉaya. ¿Nii mʉre cʉ̃ paajãri? —cʉ̃re ĩi epeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ape wãmeri paʉ ñañarije ĩi tutiupa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Boeri tabe ca niiro, judíos're ca jʉo niirã, paia ʉparã, to biri doti cũuriquere ca jʉo buerã, nea poori, ʉparã pʉtopʉ Jesús're ami waaupa. Cʉ̃ja pea o biro cʉ̃re ĩi jãiñaupa: ");
INSERT INTO baoNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Jãare wedeya. ¿Mʉa, Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ Mesías mʉ niiti? —cʉ̃re ĩiupa. To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉupi: —“Cʉ̃ra yʉ nii” yʉ ca ĩimijata cãare, díámacʉ̃ mʉja tʉoticu. ");
INSERT INTO baoNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Mʉjare yʉ ca jãiñamijata cãare, yʉre yʉʉti, yʉre pititi, mʉja biicãcu. ");
INSERT INTO baoNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Biigʉpʉa, mecʉ̃ mena, yʉ, Ca Nii Majuropeegʉ Macʉ̃, Ʉmʉreco Pacʉ niipetirijepʉre ca doti tutua niigʉ díámacʉ̃ nʉña pee yʉ duwirucu —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","To biro cʉ̃ ca ĩiro niipetirãpʉra: —¿To docare mʉa, Ʉmʉreco Pacʉ Macʉ̃ mʉ niiti? —cʉ̃re ĩi jãiñaupa. Jesús pea: —Mee, mʉjara “Cʉ̃ mʉ nii,” mʉja ĩi —cʉ̃jare ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","To biro cʉ̃ ca ĩiro tʉorã: —Ñee peere ĩirã cõro paʉ cʉ̃ja ca wede nemorije mani booticu. Mee mani majuropeera, cʉ̃ ca ĩirijere mani tʉo —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","To cõrora cʉ̃ja niipetirã wãmʉ nʉcã, Pilato pʉtopʉ Jesús're amicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Toopʉ cʉ̃re ami eari, cʉ̃ ca tʉo cojoro o biro cʉ̃re ĩi wedejãa jʉo waaupa: —Ani, jãa yaarãre ca ĩi mecʉ̃o niigʉre jãa bʉajãwʉ. “Wiogʉ romanore niirique wapare ca wapa tiiticãpe nii,” ĩimi. Ñucã apeyera: “Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ Cristo, ‘Wiogʉ yʉ nii,’ ” ĩimi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","To biro cʉ̃ja ca ĩiro, Pilato pea o biro ĩi jãiñaupi Jesús're: —¿Mʉ, mʉ niiti, judíos wiogʉ? —ĩiupi. To biro cʉ̃ ca ĩiro: —Mee, mʉra mʉ ĩi —cʉ̃re ĩi yʉʉupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","To biro cʉ̃ ca ĩiro, Pilato pea paia ʉparãre, to biri to ca niirã bojocare o biro cʉ̃jare ĩiupi: —Anire jĩcã wãme peera cʉ̃ ca jĩa ecope ʉnopʉ ñañarije cʉ̃ ca tii bui cʉtiriquepʉra yʉ bʉati —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","To biro cʉ̃ ca ĩi pacaro, cʉ̃ja pea bʉaro jañuro o biro ĩi wedejãaupa: —Cʉ̃ ca buerije mena bojoca niipetirãpʉre ĩi mecʉ̃ogʉ tiimi. Galileapʉ tii jʉoupi. Mecʉ̃ra ano Judea yepapʉ tiicã ea doomi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Atere tʉogʉ, Pilato pea: —¿Galilea macʉ̃ cʉ̃ niiti? —ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jesús, Herodes cʉ̃ ca doti niiri yepa macʉ̃ cʉ̃ ca niirijere majiri, Herodes pʉtopʉ cʉ̃re tiicojoupi. Cʉ̃ cãa tii rʉmʉrire Jerusalén'pʉra niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes pea Jesús're ĩagʉ, bʉaro ʉjea niiupi. Cʉ̃ yee maquẽre cʉ̃ja ca wedero macã cʉ̃re cʉ̃ ca ĩarʉgarije, ñucã jĩcã wãme ca ĩa ñaaña manirije Jesús cʉ̃ ca tii bau niirijere cʉ̃ ca ĩarʉga niirije, yoacoaupe. ");
INSERT INTO baoNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herodes pea Jesús're paʉ cʉ̃re jãiñamiupi. Jesús pea cʉ̃re yʉʉrucu tiitiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Paia ʉparã, doti cũuriquere jʉo bueri maja cãa, toora, yerijãaricaro maniro cʉ̃re wedejãa niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","To cõrora Herodes, cʉ̃ uwamarã mena, Jesús're ñañari wãme tii, cʉ̃re buigʉ, wiogʉre biro juti añurije cʉ̃re jãa, Pilato pʉto peera cʉ̃re tuenecã cojoupi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ména jʉguero peera ca ameri ĩarʉgati niimirucuricarã, tii rʉmʉre Herodes, Pilato ameri bapa bʉaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato pea, paia ʉparã, bojocare ca jʉo niirãre, bojoca cãare neori, ");
INSERT INTO baoNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","o biro cʉ̃jare ĩiupi: —Mʉja anire, “ ‘Wiogʉ cʉ̃ ca dotirijere tii nʉnʉjeeticãña,’ bojocare ĩi mecʉ̃omi,” ĩicãri yʉ pʉto mʉja ami doojapa. Mʉja ca tʉorora, cʉ̃re yʉ jãiñami. Cʉ̃re mʉja ca wedejãarijere jĩcã wãme peera ñañaro cʉ̃ ca tii bui cʉtiriquere yʉ bʉati. ");
INSERT INTO baoNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes cãa bʉatijapi. Ñucã mani pʉto peera cʉ̃re tuenecã cojojapi. Mee, mʉja ĩa, jĩcã wãme peera cʉ̃ ca jĩa ecope ʉnora tii bui cʉtitijapi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","To biri bape doti yapano, cʉ̃re yʉ pitirucu —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pilato pea, Pascua boje rʉmʉri cõrora jĩcʉ̃ tia cũurica wiipʉ ca niigʉre wienerucuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","To biro cʉ̃ ca ĩirora, niipetirãpʉra jĩcãri o biro ĩi acaro buiupa: —¡Jĩa cõacãña cʉ̃ra! ¡Barrabás peere jãare wiene bojaya! —ĩi acaro buiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ména ani Barrabás peera, wiorã cʉ̃ja ca dotirijere junagʉ ametʉene nʉcã, ñucã bojocʉre jĩacã, cʉ̃ ca tiirique jʉori cʉ̃ja ca tia cũuricʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato pea Jesús're ca wienerʉga niigʉ niiri, ĩi nemomiupi ñucã bojocare. ");
INSERT INTO baoNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Cʉ̃ja pea bʉaro jañuri, o biro ĩi acaro buiupa: —¡Paa pua tuu cõacãña! ¡Paa pua tuu cõacãña! —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ñucã itiati peti o biro cʉ̃jare ĩimiupi Pilato: —¿Ñee ʉno ñañarije cʉ̃ tiijãri? Yʉa, jĩcã wãme peera ca jĩa ecopʉ cʉ̃ ca niipe cʉ̃ ca tii bui cʉtiriquere yʉ bʉati. Cʉ̃re bape doti yapano, cʉ̃re yʉ wienerucu —cʉ̃jare ĩimiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Cʉ̃ja pea, “Cʉ̃re paa pua tuu cõacãña,” ĩirã, yerijãaricaro maniro bʉaro acaro bui niiupa. To biro ĩi acaro bui bayicãri bʉaupa cʉ̃ja ca tiirʉgarijere. ");
INSERT INTO baoNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","To biri Pilato pea, “Cʉ̃ja ca jãiri wãme ca tiipe niicu,” ĩicãupi yua. ");
INSERT INTO baoNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","To biri cʉ̃ja ca boogʉ, wiorã cʉ̃ja ca dotirijere junagʉ ametʉene nʉcã, ñucã bojocʉre jĩa, cʉ̃ ca tiirique jʉori, tia cũurica wiipʉ ca niigʉ peere wiene, Jesús peera cʉ̃ja ca boorore biro cʉ̃ja tiijato ĩigʉ, cʉ̃re cʉ̃jare nonicãupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Jesús're paa pua tuu cõarʉgarã cʉ̃re ami nʉnʉa waarã, jĩcʉ̃ Cirene macʉ̃ Simón ca wãme cʉtigʉ, macã tʉjaropʉ ca niiricʉ ca doogʉre ñeeri, Jesús're cʉ̃ja ca paa pua tuupagʉ yucʉgʉ cʉ̃re ami peori, Jesús jiro pʉja nʉnʉjee dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Paʉ bojoca, ñucã paʉ nomia to biro cʉ̃re cʉ̃ja ca tiiro ĩarã, cʉ̃ jiro oti, tʉgoeñarique pai, acaro bui nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","To biro cʉ̃ja ca biiro, Jesús pea amojode nʉcã, o biro cʉ̃jare ĩiupi: —Jerusalén macãrã romiri, yʉ yee jʉorira otiticãña. Mʉja majurope, mʉja puna yee ca niipe peere tʉgoeñari otiya. ");
INSERT INTO baoNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Doorucu: “Ca puna manirã romiri, jĩcãti ʉno peera ca puna cʉti ñaatiricarã romiri, cʉ̃ja ca ũpũo bʉcʉoparã ca puna cʉtitiricarã romiri, ʉjea niima,” cʉ̃ja ca ĩipa rʉmʉri. ");
INSERT INTO baoNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","To cõrora bojoca ʉ̃tã yucʉrena: “ ‘¡Jãare ñaapeaya!’ ñucã, ca emʉari buurorirena ‘¡Jãare yaioya!’ ĩirucuma.” ");
INSERT INTO baoNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ñañarije ca tiitigʉrena o biirije yʉre cʉ̃ja ca tiicãjata, ¿ñañarije ca tiirã docare do biro pee biicãri ñañarije cʉ̃jare to biitibogajati? —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ñucã Jesús menare, pʉarã ñañarije ca tiiricarãre jee waaupa, cʉ̃ mena jĩcãri cʉ̃jare jĩarʉgarã. ");
INSERT INTO baoNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Dʉpʉga Õaro ca wãme cʉtiri buuro earã, Jesús're, ñañarije ca tii bui cʉtiricarã mena jĩcãri, jĩcʉ̃re cʉ̃ díámacʉ̃ nʉña pee, apĩ peera cʉ̃ ãcõ nʉña pee, cʉ̃jare paa pua tuu nʉcõupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús pea o biro ĩiupi: —Cáacʉ, cʉ̃jare acoboya. Cʉ̃ja ca tiirijere majitima —ĩiupi. Uwamarã cãa cʉ̃ja majurope cʉ̃ jutirore ameri dica woorʉgarã, ĩi bʉarique mena tii niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Bojoca pea toora ĩacã niiupa. Ñucã ʉparã menapʉra o biro cʉ̃re ĩi buiupa: —Aperã cãare ametʉenewi. Mecʉ̃ docare, díámacʉ̃ra Ʉmʉreco Pacʉ cʉ̃ ca beje amiricʉ Mesías'ra cʉ̃ ca niijata, cʉ̃ majuropeera cʉ̃ ametʉajato —ĩi buiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Uwamarã cãa, cʉ̃re buiupa. Cʉ̃ pʉto waari, ʉje oco ca piyarijere cʉ̃re tĩari, ");
INSERT INTO baoNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","o biro cʉ̃re ĩi epeupa: —Mʉa, judíos wiogʉ mʉ ca niijata, mʉ majuropeera ametʉaya —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ñucã cʉ̃ dʉpʉga jotoare, “ANI NIIMI JUDÍOS WIOGɄ,” cʉ̃ja ca ĩi owa tuurica pĩi tujaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Jĩcʉ̃, ñañarije ca tii bui cʉtiricʉ, too cʉ̃ja ca paa pua tuu nʉcõricʉ cãa, o biro cʉ̃re ĩi tutiupi: —Mesías'ra mʉ ca niijata, mʉ majuropeera ametʉa, jãa cãare ametʉene, tiiya —ĩi tutiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","To biro cʉ̃ ca ĩiro, apĩ ñañarije ca tii bui cʉtiricʉ pea, o biro cʉ̃re ĩi tutiupi: —¿Mʉ cãa, to birora ñañaro ca tamʉogʉ nii pacagʉ, Ʉmʉreco Pacʉre mʉ uwititi? ");
INSERT INTO baoNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Mani doca ñañarije mani ca tiirique jʉori, díámacʉ̃ra ñañaro tamʉorã mani tii. Ani pea, jĩcã wãme ʉno peera ñañarije tiitijapi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","To biro cʉ̃re ĩi, o biro ĩiupi Jesús're: —Jesús, mʉ ca doti jʉo waari tabe, yʉ cãare mʉ tʉgoeñawa —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Yee méé mʉre yʉ ĩi: Mecʉ̃ra yʉ mena ca añu majuropeeri tabepʉ mʉ niirucu —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Muipũ jotoa decomacã cʉ̃ ca niiro, to biri bʉaro cʉ̃ ca aji cõa cũu duwi waari tabe menapʉ, ati yepa niipetiropʉra naitĩa peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Muipũ cãa, ajiticoaupi. Ñucã Ʉmʉreco Pacʉ yaa wiipʉre, ca ñañarije maniri jawire cʉ̃ja ca yoo camotaarica quejero cãa decomacã yegacã duwi waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","To cõrora Jesús pea tutuaro o biro ĩi acaro buiupi: —Cáacʉ, yʉ ca cati niirijere mʉpʉre yʉ ĩa nʉnʉjee doti —ĩiupi. To biro ĩigʉra, bii yaicoaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Uwamarã wiogʉ romano pea to biro ca biirijere ĩagʉ, Ʉmʉreco Pacʉre baja peo nʉcʉ̃ bʉo: —Díámacʉ̃ra ania ñañarije ca tiitigʉ niijapi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Bojoca niipetirã to biro ca biirijere ĩarʉgarã ca nea pooricarã pea, to biro ca biirijere ĩari, cʉ̃ja cotiarire paa, tiicã tua waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Niipetirã Jesús cʉ̃ ca majirã pea, ñucã nomia Galileapʉra cʉ̃re ca nʉnʉ waaricarã romiri cãa, teere yoaropʉra ĩa cojocã niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Niiupi jĩcʉ̃, ca bojoca añugʉ, ñañarije ca tiitigʉ, José ca wãme cʉtigʉ, wiorã ca nii majuropeerã mena macʉ̃, Judea yepa macã macã Arimatea macʉ̃. ");
INSERT INTO baoNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José, Ʉmʉreco Pacʉ cʉ̃ ca dotipa cuu ca eapere ca yue niirucuricʉ, cʉ̃ mena macãrã ʉparã cʉ̃ja ca tiirʉgarijere, ñucã cʉ̃ja ca biirique cʉti niirije mena cãare ca bootiricʉ pea, ");
INSERT INTO baoNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Pilatore ĩagʉ waari, Jesús upʉri niiquĩriquere jãiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Cʉ̃ja ca paa pua tuuricʉre ami duwio yapano, juti quejero lino quejero mena cʉ̃re ũmaa, ʉ̃tãgapʉ maja ope cʉ̃ja ca quenorica toti, ména jĩcʉ̃ ʉno peerena ca yaaya maniri totipʉ cʉ̃re cũuupi. ");
INSERT INTO baoNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Yerijãarica rʉmʉ maquẽre cʉ̃ja ca queno yue niiri rʉmʉ niiupa. Yerijãarica rʉmʉ pea mee, ea waaropʉ biiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Galileapʉra Jesús're ca bapa cʉti waaricarã romiri pea, maja opere ĩa, ñucã cʉ̃ upʉri niiquĩriquere, “To biro pee cũuma,” ĩi ĩa, tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jiro wiipʉ tua waa, cʉ̃ upʉri niiquĩriquere cʉ̃ja ca wadape ca jʉti añurijere queno, tiiupa. To biri nomia pea doti cũurique ca ĩirore biro, yerijãarica rʉmʉre yerijãaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Nomia pea ape semana ca nii jʉori rʉmʉre ca boerije mena, ca jʉti añurije cʉ̃ja ca quenoriquere jee, waacoaupa maja opepʉ ĩarã waarã. ");
INSERT INTO baoNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Toopʉ earã, maja opere cʉ̃ja ca biaricaga ʉ̃tãga aperopʉ ca niiro bʉa eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Tii opepʉre jãa waarã, Wiogʉ Jesús niiquĩricʉ upʉri peera bʉatiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","To biri do biro to biibujapari, cʉ̃ja ca ĩi ameri jãiña niiri tabera, ʉmʉa pʉarã, bʉaro ca ajiyaa boe baterije ca juti jãñarã, cʉ̃ja pʉto baua ea nʉcãcãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Cʉ̃ja pea ʉcʉa yaicoama ĩirã, yepapʉ muu bia ñaacũmucoaupa. To biro cʉ̃ja ca biiro, cʉ̃ja pea o biro cʉ̃jare ĩiupa: —¿Ñee tiirã mʉja, ca catigʉrena ca bii yairicarã watoapʉ mʉja amaati? ");
INSERT INTO baoNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Manimi anora. Mee, cati tuacoajãwi. Ména, Galileapʉ mʉja mena niigʉ, o biro mʉjare cʉ̃ ca ĩiriquere ");
INSERT INTO baoNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","tʉgoeñaña: “Ca Nii Majuropeegʉ Macʉ̃, ñañarije ca tiirãpʉre tiicojo eco, yucʉ tenipʉ paa pua tuu cõa eco, itia rʉmʉ jiro cati tua, biirucumi,” mʉjare cʉ̃ ca ĩiriquere —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","To biro cʉ̃ja ca ĩiropʉ, Jesús cʉ̃ja mena niigʉ cʉ̃jare cʉ̃ ca ĩiriquere tʉgoeña bʉaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Toopʉ ca niiricarã tua earã, niipetiro cʉ̃ja ca ĩariquere Jesús buerã, pʉa amo peti, dʉpore jĩcãga penituaro ca niirãre, ñucã aperã cãare, cʉ̃jare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Teere ca queti wedericarã romiri pea: María Magdalena, Juana, Santiago paco María, to biri aperã cʉ̃jare ca bapa cʉti waaricarã romiri niiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","To biro cʉ̃ja ca ĩirije cʉ̃ buerã peera, ĩi mecʉ̃riquere biro cʉ̃jare biicãupa. To biri díámacʉ̃ cʉ̃jare tʉorʉgatiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","To biro cʉ̃jare to ca bii pacaro, Pedro pea, maja opepʉ waagʉ ũmaacoaupi. Toopʉ ea, jagueña jõene cojogʉ, cʉ̃re cʉ̃ja ca ũmaarica quejeri wadore ĩaupi. Jiro wii pee tua waagʉ, to biro ca biiriquere “¿Do biro peti to biibujapari yéé?” ĩi tʉgoeñarique paicã tua waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Tii rʉmʉrena, pʉarã cʉ̃ja mena macãrã, Emaús macã Jerusalén menare, once kilómetros'pʉ ca niiri macãpʉ waarã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Too waarã, niipetirije ca biiriquere wede peni nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Teere wede peni, ameri wede majio cʉ̃ja ca ĩi nʉnʉa waarucuro, Jesús'ra cʉ̃jare ẽmʉri, cʉ̃ja mena waacã nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Cʉ̃ja peera cʉ̃re cʉ̃ja ca ĩacã pacaro, jĩcã wãmeacã cʉ̃jare ca bii camotaro macã, “Cʉ̃ niicumi,” ĩi ĩa majitiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús pea o biro cʉ̃jare ĩi jãiñaupi: —¿Ñee ʉnore mʉja ameri wede peni nʉnʉa waati? —ĩiupi. Cʉ̃ja pea tʉgoeñarique pairãra tua nʉcãupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","To biro cʉ̃ ca ĩiro jĩcʉ̃ cʉ̃ja mena macʉ̃ Cleofas ca wãme cʉtigʉ, o biro ĩi yʉʉupi: —¿Mʉ jĩcʉ̃ra mʉ niiti, Jerusalén'ra nii pacagʉ, tii macãre ati rʉmʉrire ca biijãrijere ca majitigʉ? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","To biro cʉ̃ ca ĩiro: —¿Do biro to biijãri? —ĩi jãiñaupi Jesús. Cʉ̃ja pea o biro cʉ̃re ĩi yʉʉupa: —Jesús, Nazaret macʉ̃re ca biijãrijere jãa ĩi. Cʉ̃a, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ, Ʉmʉreco Pacʉ, ñucã bojoca cʉ̃ja ca ĩa cojorore cʉ̃ ca tiirije, cʉ̃ ca wederije ména cãare, do biro ca tiiya manigʉ niimiwi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Paia ʉparã, to biri manire ca jʉo niirã, cʉ̃re cʉ̃ja jĩa cõacãjato ĩirã aperãpʉre cʉ̃re noni cõacãjãwa; cʉ̃ja pea yucʉ tenipʉ cʉ̃re paa pua tuu, tii jĩa cõacãjãwa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jãa pea, “Israelitas're ca doti epe niirãre ametʉenerucumi,” jãa ĩi yuemiwʉ. Ate niipetirije ca biijãro jiro, mee itia rʉmʉ ametʉacoa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","To ca bii pacaro, jĩcãrã jãa mena macãrã romiri ʉcʉeneri wãme jãare wedejãwa tee peere. Meepʉ boeri tabere, meepʉacã maja opepʉ ĩarã waamijapa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Cʉ̃ upʉri niiquĩrique peera bʉatijapa. Tua earã, jĩcãrã Ʉmʉreco Pacʉ pʉto macãrã baua eari, “ ‘Jesús catimi,’ jãare ĩijãwa,” jãare ĩi wede tua eajãwa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jiro jĩcãrã jãa mena macãrã maja opepʉ ĩarã waamijapa ñucã. Nomia cʉ̃ja ca wedejãrore birora ĩajapa cʉ̃ja cãa, Jesús upʉ peera ĩatijãna —cʉ̃re ĩi wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","To biro cʉ̃ja ca ĩiro tʉo, Jesús pea o biro cʉ̃jare ĩiupi: —¿No cõro peti tʉo puoti, ñucã Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca ĩirique niipetirorena tʉo nʉnʉjee jeeñoti, ca biirã peti mʉja niicãti? ");
INSERT INTO baoNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Too docare Ʉmʉreco Pacʉ cʉ̃ ca tiicojogʉ Mesías, Wiogʉ cʉ̃ ca niiparo jʉguero, ñañaro cʉ̃ tamʉoricaro maniupari? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","To biro cʉ̃jare ĩi, Ʉmʉreco Pacʉ wederique cʉ̃ ca biipe maquẽre cʉ̃ja ca owarique niipetirije, Moisés cʉ̃ ca owaquĩrique mena cʉ̃jare wede jʉo waa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca owariquepʉ mena cʉ̃jare wede majio nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Cʉ̃ja ca waarica macãre cʉ̃ja ca ea waarora, Jesús pea ca ametʉacoapʉre biro boca biiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","To biro cʉ̃ ca biiro cʉ̃ja pea: —Waaticãña. Anora jãa mena tuaya. Mee, ñamipʉ nii. Naitĩacoaropʉ bii —cʉ̃re ĩiupa. To biro cʉ̃ja ca ĩiro cʉ̃ja mena tuarʉgʉ jãa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Jiro, cʉ̃ja mena baarique peorica pĩi pʉtopʉ duwigʉ, pan're ami, Ʉmʉreco Pacʉre, “Añu majuropeecã” ĩi juu bue, pan're pee batori cʉ̃jare tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","To biro cʉ̃ ca tiirije menara, cʉ̃re ĩa majiupa. Cʉ̃ pea yaicã ũmaa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","To cõrora cʉ̃ja pea o biro ameri ĩiupa: —¿To birira maapʉ mani mena wede peni, Ʉmʉreco Pacʉ yee cʉ̃ja ca owa cũuriquere manire wede majio, cʉ̃ ca ĩi nʉnʉa dooro, mani yeripʉre to cõro ʉcʉeneri wãme manire to boca bii niitijapari? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","To biro ĩi, jĩcãtora tuacoaupa ñucã Jerusalén peera. Toopʉ earã, Jesús buerã pʉa amo peti, dʉpore jĩcãga penituaro ca niirã, aperã cʉ̃ja mena macãrã, ca nea pooricarãre bʉa eaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Cʉ̃ja pea o biro cʉ̃jare ĩi bocaupa: —Díámacʉ̃ra Wiogʉ cati tuagʉra biijapi. Simón Pedrore baua eajapi —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Cʉ̃ja pee cãa ñucã maapʉ cʉ̃ja ca waaro cʉ̃jare ca biiriquere, ñucã Jesús pan'gare cʉ̃ ca pee batoro cʉ̃re cʉ̃ja ca ĩa majiriquere, cʉ̃jare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cʉ̃ja pea ména atere cʉ̃ja ca wede niirora, Jesús pea cʉ̃ja watoa baua ea nʉcãri, o biro cʉ̃jare ĩi añu dotiupi: “Añuro niirique mʉjare to niijato,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Cʉ̃ja pea, “Ca bii yairicʉ wãtĩ niicumi” ĩi tʉgoeñari, ʉcʉacã yai waaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","To biro cʉ̃ja ca biiro Jesús pea o biro cʉ̃jare ĩiupi: —¿Ñee tiirã mʉja ʉcʉacoati? ¿Ñee tiirã “Cʉ̃ra niimi,” yʉre mʉja ĩititi? ");
INSERT INTO baoNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yʉ amorire, yʉ dʉporire ĩaña. Yʉra yʉ nii. Yʉre padeña, ĩa, tii ñaaqué. Jĩcʉ̃ ca bii yairicʉ wãtĩa, yʉ ca biiro yʉre mʉja ca ĩarore biro díí cʉti, õa cʉti, biitimi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","To biro ĩigʉra, cʉ̃ amorire, cʉ̃ dʉporire cʉ̃jare ĩñoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Cʉ̃ja pea bʉaro ʉjea nii, ʉcʉa, biima ĩirã, “Cʉ̃ra niimi,” cʉ̃ja ca ĩitiro macã, o biro cʉ̃jare ĩi jãiñaupi Jesús: —¿Anore baarique ʉno mʉja cʉoti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","To biro cʉ̃ ca ĩiro, wai pʉ̃oricʉ dʉcare cʉ̃re tiicojoupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Cʉ̃ pea tii dʉcare amiri, cʉ̃ja ca ĩa cojorora baaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Baa yapano, o biro cʉ̃jare ĩiupi: —“Yʉre ca biijãrijea, mʉja mena niigʉ, Moisés niiquĩricʉ cʉ̃ ca owarique, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja, to biri Ʉmʉreco Pacʉre baja nʉcʉ̃ bʉorica pũuripʉ yʉ yee maquẽre cʉ̃ja ca owarique ca ĩirore biro biirucu,” mʉjare yʉ ca ĩi wederique biro biijãwʉ —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","To biro ĩi, cʉ̃ja ca tʉgoeña niirijepʉre pãaupi, Ʉmʉreco Pacʉ wederiquere cʉ̃ja ca tʉo majipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","O biro cʉ̃jare ĩiupi: —O biro ĩi owarique nii: “Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ Mesías bii yai, ñucã itia rʉmʉ jiro cati tua, biirucumi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Cʉ̃ ca dotirije mena, bojoca poogaari cõrorena, ‘Ñañarije mʉja ca tiirijere tii yerijãa tʉgoeña wajoaya, ñañarije mʉja ca tiirijere Ʉmʉreco Pacʉ mʉjare cʉ̃ acobojato ĩirã,’ ĩi wede jʉorique niirucu Jerusalén ména,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Mʉjara mʉja nii, atere “To birora biiwʉ,” ca ĩi wedeparã. ");
INSERT INTO baoNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yʉ pea, yʉ Pacʉ, “Yʉ tiicojorucu” cʉ̃ ca ĩiricʉ Añuri Yerire mʉjare yʉ tiicojorucu. Mʉja pea ména, Jerusalén macãrã niicãña, ʉmʉreco tutipʉ maquẽ yeri tutuarique ca doorijere mʉja ca boca amiparo jʉguero —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jiro Jesús, Betaniapʉ cʉ̃jare jʉo waa, toopʉ cʉ̃ amorire juu mʉene, añuro cʉ̃jare ca bii mʉa nʉcãpere cʉ̃jare jãi bojaupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Añuro cʉ̃jare ca bii mʉa nʉcãpere cʉ̃jare jãi boja niigʉra, cʉ̃jare camotati, ʉmʉreco tutipʉ amicã mʉa waa ecoupi. ");
INSERT INTO baoNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Cʉ̃ja pea cʉ̃re ĩi nʉcʉ̃ bʉo yapano, bʉaro ʉjea niirique mena Jerusalén'pʉ tuacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ʉmʉreco Pacʉ yaa wiipʉ to birora Ʉmʉreco Pacʉre baja peo nʉcʉ̃ bʉo, tiicõa niirucuupa. To biro to biijato. Lucas");
INSERT INTO baoNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mee, jĩcãtopʉra, Ʉmʉreco Pacʉ Wederiquera niicã jʉoupi Cristo. Ʉmʉreco Pacʉ menara niicãupi; ñucã Ʉmʉreco Pacʉra niicãgʉ biiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cristoa, mee jĩcãtopʉra Ʉmʉreco Pacʉ mena nii yerijãaupi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cristo menara niipetirije tiiupi Ʉmʉreco Pacʉ. Jĩcã wãme ʉno peera cʉ̃ ca manirora cʉ̃ ca tiirique mani. ");
INSERT INTO baoNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cʉ̃ menara catirique bii jʉoupa. Tee catiriquera ati yepa macãrã bojocare Ʉmʉreco Pacʉre cʉ̃ja ca majiro ca tiipe niiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Cristo, ca boerije ca biirore birora, Ʉmʉreco Pacʉre ca majitirã, ca naitĩaropʉ ca niirãre biro ca niirãre, Ʉmʉreco Pacʉre cʉ̃ja ca majiro ca tiigʉ niiupi. To biri ca naitĩaropʉ ca niirãre biro ca niirã pea, ca boerijere ametʉa nʉcã majitima. ");
INSERT INTO baoNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Niiwi jĩcʉ̃ ʉmʉ Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ, Juan ca wãme cʉtigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Cʉ̃a, ca boegʉ Cristore cʉ̃ ca ĩariquere ca wedegʉ dooricʉ niiwi, cʉ̃ ca wederijere tʉori, niipetirã díámacʉ̃ cʉ̃ja ca tʉo nʉnʉjeepere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Biigʉpʉa, bojocare Uwo Coeri majʉ Juan, ati yepa macãrãre ca boegʉ dooricʉ méé niiwi. Juan, ca boegʉ Cristore cʉ̃ ca ĩariquere cʉ̃ ca wede doti cojoricʉ niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo ca boerije ca nii majuropeegʉ, bojoca niipetirãre ca boegʉra dooupi, ati yepapʉre. ");
INSERT INTO baoNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo, wederique ca niiricʉra, ati yepapʉre niiwi. Cristo menara Ʉmʉreco Pacʉ ati yepare cʉ̃ ca jeeñorique to ca niicã pacaro, ati yepa macãrã pea cʉ̃re ĩa majitiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Cʉ̃ yaarã pʉtore doomiupi. Cʉ̃ja pea cʉ̃re bootiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","To biro cʉ̃ja ca bii pacaro, añuro cʉ̃re ñee, cʉ̃re tʉo nʉnʉjee, ca tiirã peera, Ʉmʉreco Pacʉ puna peti cʉ̃ja ca niiro cʉ̃jare tiiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ʉmʉreco Pacʉ puna niiriquea, bojoca cʉ̃ja ca boorije jʉori méé, mani pacʉa manire cʉ̃ja ca puna cʉtirije ʉno méé, nii. Ʉmʉreco Pacʉ, cʉ̃ majuropeera cʉ̃ puna cʉ̃ja ca niiro cʉ̃jare tiimi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ʉmʉreco Pacʉ Wederique ca niiricʉra manire biigʉ bojocʉ jeeñari, mani watoare niiwi. Cʉ̃ ca doti tutua niirijere, cʉ̃ macʉ̃ jĩcʉ̃ra ca niigʉ niiri doti tutuarique cʉ̃ Pacʉ cʉ̃re cʉ̃ ca tiicojorijere cʉ̃ ca ñeeriquere, jãa ĩawʉ. Bʉaropʉra mairiquere cʉocã, díámacʉ̃ ca niirijere cʉocã, ca biigʉ niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","To biri cʉ̃re cʉ̃ ca ĩariquerena wedegʉ, o biro ĩi acaro bui wedewi Juan: “Anira niimi: ‘Yʉ jiro ca doogʉ pea, yʉ ametʉenero ca nii majuropeegʉ niimi, yʉ jʉgueropʉra ca nii jʉo dooricʉ niiri,’ yʉ ca ĩi wedericʉa,” ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Cristo niipetirije cʉ̃ ca añu majuropeerijere, mani niipetirãpʉrena bʉaro jañuro añurijere manire tii boja nʉnʉa waami. ");
INSERT INTO baoNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Doti cũuriquea Moisés'pʉre tiicojo ecoupa. Ʉmʉreco Pacʉ añuro manire cʉ̃ ca tii bojarique, to biri díámacʉ̃ ca niirije, Jesucristo mena pee manire bii bau nii eawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ʉmʉreco Pacʉra jĩcʉ̃ ʉno peera jĩcãti ʉnora cʉ̃re ĩa ñaatiupa. Cʉ̃ Macʉ̃ jĩcʉ̃ra ca niigʉ, Ʉmʉreco Pacʉra ca niigʉ, cʉ̃ Pacʉ menara ca niicõa niigʉ wado, cʉ̃re mani ca majiro manire tiiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ate nii, Jerusalén macãrã judíos ʉparã, paia, to biri levitare, “¿Ñiru mʉ niiti?” Juan're ĩi jãiña dotirã cʉ̃ja ca tiicojoricarã cʉ̃ja ca jãiña earo, cʉ̃ ca niirijere Juan cʉ̃jare cʉ̃ ca wederique. ");
INSERT INTO baoNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Cʉ̃re cʉ̃ja ca jãiñaro, ĩi ditoricaro maniro o biro cʉ̃jare ĩi wedewi Juan: —Yʉa, Mesías méé yʉ nii —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Cʉ̃re jãiña nemowa ñucã: —¿To docare ñiru peti mʉ niiti? ¿Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Elías mʉ niiti? —cʉ̃re ĩi jãiñawa. Cʉ̃ pea: —Cʉ̃ méé yʉ nii —cʉ̃jare ĩiwi Juan. Cʉ̃ja pea o biro cʉ̃re ĩi jãiñawa ñucã: —Too docare, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ doorucumi cʉ̃ja ca ĩiricʉ mʉ niitiqué —cʉ̃re ĩiwa. To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro, Juan pea: —Yʉ niiti —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi jãiña nemowa ñucã: —¿Too docare, ñiru peti mʉ niiti? Jãare ca jãiña doti cojojãrãre jãa ca wedepere jãa majirʉga, ¿mʉ majurope pea “Ñiru yʉ nii,” mʉ ĩiti? —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","To biro cʉ̃re cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Juan: —Yʉa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías niiquĩricʉ: “Ca yucʉ maniri yeparipʉ, ‘Wiogʉ cʉ̃ ca doopa maare díámacʉ̃ maa queno yueya,’ ĩi acaro bui wedeorucumi,” cʉ̃ ca ĩiricʉ yʉ nii —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Fariseos cʉ̃ja ca jãiña doti cojoricarã pea ñucã Juan're, ");
INSERT INTO baoNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","o biro cʉ̃re ĩi jãiña nemowa: —Too docare Mesías méé nii, Elías méé nii, Ʉmʉreco Pacʉ yee quetire ca wede jʉgueri majʉ méé nii, bii pacagʉ, ¿ñee tiigʉ bojocare mʉ uwo coeti? —cʉ̃re ĩi jãiñawa. ");
INSERT INTO baoNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Juan pea o biro cʉ̃jare ĩi yʉʉwi: —Yʉa, bojocare oco mena yʉ uwo coe. Ména apĩ niimi mʉja watoare, mʉja ca majitigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Cʉ̃ niimi, yʉ jiro ca doopʉ. Cʉ̃a, yʉ ametʉenero ca nii majuropeegʉ niigʉ biimi, cʉ̃ dʉpo juti jiarica daa cãare ca popiopʉ méé yʉ nii yʉa —cʉ̃jare ĩiwi Juan. ");
INSERT INTO baoNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ate niipetirije biiwʉ Betaniapʉre, dia Jordán ape nʉña muipũ cʉ̃ ca mʉa doori nʉña peere bojocare Juan cʉ̃ ca uwo coe niiri tabere. ");
INSERT INTO baoNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ape rʉmʉ peere Juan, cʉ̃ pʉto pee Jesús cʉ̃ ca doo nʉnʉa dooro ĩari, o biro ĩiwi: “Ĩaña. Ĩira niimi Ʉmʉreco Pacʉ yʉʉ Oveja Macʉ̃re biro bojoca cʉ̃ja ca ñañarije wapare ametʉenegʉ ca bii yai bojapʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Anirena ĩigʉ: ‘Yʉ jiro doorucumi jĩcʉ̃, yʉ jʉgueropʉra ca nii jʉo dooricʉ niiri, yʉ ametʉenero ca nii majuropeegʉ,’ mʉjare yʉ ĩi wedewʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yʉ majurope cãa, ‘Cʉ̃ niicumi Mesías,’ yʉ ĩi majitiwʉ. To biro bii pacagʉ, Israel yaa pooga macãrã cʉ̃re cʉ̃ja majijato ĩigʉ, oco mena bojocare yʉ uwo coewʉ,” ĩiwi Juan. ");
INSERT INTO baoNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Cʉ̃ ca ĩariquere o biro ĩi wede majio nemowi ñucã Juan: “Yʉ majuropeera yʉ ĩawʉ. Añuri Yeri, ʉmʉreco tutipʉ buare biigʉ bau duwi doori, Jesús jotoare cʉ̃ ca ñaapea earo. ");
INSERT INTO baoNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yʉ cãa ména, Mesías'ra cʉ̃ ca niirijere yʉ majitiwʉ. Oco mena yʉre ca uwo coe doti cojoricʉ pee o biro yʉre ĩiwi: ‘Añuri Yeri, buare biigʉ bau duwi doori, cʉ̃ jotoapʉre cʉ̃ ca ñaapea earo mʉ ca ĩagʉ niirucumi, bojoca yeripʉre, Añuri Yeri cʉ̃ ca ñaajãa nʉcã earo ca tiipʉ,’ yʉre ĩi wedewi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","To biri yʉ majuropeera ca ĩaricʉ niiri, díámacʉ̃ra: ‘Anira niimi Ʉmʉreco Pacʉ Macʉ̃,’ mʉjare yʉ ĩi wedewʉ,” ĩi wedewi Juan. ");
INSERT INTO baoNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ape rʉmʉre, cʉ̃ buerã pʉarã mena tii tabera niiwi ñucã Juan. ");
INSERT INTO baoNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús, too cʉ̃ ca ametʉa waaro ĩari, o biro ĩiwi: —Ĩaña, ĩira niimi Ʉmʉreco Pacʉ yʉʉ Oveja Macʉ̃ —ĩiwi Juan. ");
INSERT INTO baoNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","To biro Juan cʉ̃ ca ĩiro tʉorã, pʉarãpʉra cʉ̃ buerã ca niimiricarã Jesús're jãa nʉnʉcoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Cʉ̃ jiro jãa ca nʉnʉ waaro, jãare amojode nʉcã ĩari, Jesús pea o biro jãare ĩi jãiñawi: —¿Ñeere mʉja amaati? —jãare ĩiwi. To biro jãare cʉ̃ ca ĩi jãiñaro, o biro cʉ̃re jãa ĩi yʉʉwʉ: —Buegʉ, ¿noopʉ mʉ ca cãniri tabe to niiti? —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","To biro cʉ̃re jãa ca ĩiro: —Doori, ĩarã dooya —jãare ĩiwi Jesús. To biro cʉ̃ ca ĩiro cʉ̃ mena waa, cʉ̃ ca niirica tabepʉre earã, toopʉra cʉ̃ mena jãa niicã naio waawʉ yua, mee naiori tabeacãpʉ ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Jĩcʉ̃, Juan cʉ̃ ca wedero tʉori, pʉarã Jesús're ca nʉnʉ waaricarã mena macʉ̃ pea Simón Pedro yee wedegʉ Andrés niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","To biri Andrés pea cʉ̃ yee wedegʉ Simón'rena bʉa ea jʉori, o biro cʉ̃re ĩiupi: —Mesías're jãa bʉajãwʉ —ĩiupi. (Mesías ĩiro, “Ʉmʉreco Pacʉ cʉ̃ Ca Beje Amiricʉ,” ĩirʉgaro ĩi.) ");
INSERT INTO baoNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jiro Andrés pea, cʉ̃ yee wedegʉ Simón're Jesús pʉtopʉ jʉo dooupi. Jesús pea Simón're ĩari, o biro cʉ̃re ĩiwi: —Mʉa, Juan macʉ̃ Simón mʉ nii; mecʉ̃ra Cefas mʉ wãme cʉtirucu yua. (Cefas ĩiro, Pedro, ĩirʉgaro ĩi.) ");
INSERT INTO baoNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ape rʉmʉ peere ñucã, Jesús pea, “Galilea yepa pee ca waape niicu,” ĩiwi. To biri toopʉ cʉ̃ ca waaparo jʉguero, Felipere bʉa eari, o biro cʉ̃re ĩiwi Jesús: —Dooya yʉ mena —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Felipe cãa, Pedro, Andrés jãari cʉ̃ja ca niirica macã Betsaida macʉ̃ra niiwi cʉ̃ cãa. ");
INSERT INTO baoNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","To biri Felipe pea, Natanael're amagʉ waa, cʉ̃re bʉa eari, o biro cʉ̃re ĩiupi: —Moisés niiquĩricʉ, cʉ̃ yee maquẽre doti cũuriquepʉ owa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cãa cʉ̃ yee maquẽre owa, cʉ̃ja ca tiiricʉ Jesús, Nazaret macʉ̃, José macʉ̃re jãa bʉajãwʉ —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","To biro cʉ̃re cʉ̃ ca ĩiro Natanael pea, o biro cʉ̃re ĩiupi Felipere: —¿Mʉ ca tʉgoeñajata, Nazaret macãre jĩcʉ̃ añugʉ ʉno cʉ̃ nii baʉabogajati? —cʉ̃re ĩiupi. Felipe pea Natanael to biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupi: —Dooya. Mʉ majurope doori ĩagʉ doo ñaaqué —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesús pea, Natanael cʉ̃ ca doo nʉnʉa dooro ĩari, o biro ĩiwi: —Ani doomi, israelita bojocʉ peti, jĩcã wãme ʉnora ĩi ditorique ʉnore ca cʉotigʉ —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","To biro Jesús cʉ̃ ca ĩiro: —¿Do biro biicãri to cõro añuro yʉre mʉ majiti? —cʉ̃re ĩi jãiñawi Natanael. To biro cʉ̃ ca ĩiro: —Felipe mʉre cʉ̃ ca jʉoparo jʉguero, higueragʉ doca mʉ ca niiro mʉre yʉ ĩajãwʉ —cʉ̃re ĩiwi Jesús pea. ");
INSERT INTO baoNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","To biro cʉ̃ ca ĩiro, Natanael pea o biro cʉ̃re ĩiwi Jesús're: —Buegʉ, Mʉa, Ʉmʉreco Pacʉ Macʉ̃ mʉ nii; Israel yaa yepare ca dotipʉ Wiogʉ peti mʉ nii —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩi nemowi Natanael're: —¿“Higueragʉ doca mʉ ca niiro mʉre yʉ ĩajãwʉ,” yʉ ca ĩirijere tʉorira, “Ʉmʉreco Pacʉ Macʉ̃ mʉ nii,” yʉre mʉ ĩi nʉcʉ̃ bʉoti? Jiropʉ docare o biro yʉ ca ĩirije ametʉenero añurijere mʉ ĩarucu —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","To biro cʉ̃re ĩi, o biro ĩi nemowi ñucã Jesús: —Yee méé mʉjare yʉ ĩi: Ʉmʉreco quejero pãa nʉcãcoa, ñucã Ʉmʉreco Pacʉ pʉto macãrã, yʉ, Ca Nii Majuropeegʉ Macʉ̃ jotoare duwicã doorucu, mʉacoarucu, cʉ̃ja ca biirijere mʉja ĩarucu —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Itia rʉmʉ ca nii waaro, Galilea yepa macã macã Canáre amo jiarica boje rʉmʉ niiwʉ. Jesús paco cãa toopʉ niiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesús, to biri jãa cʉ̃ buerã, tii boje rʉmʉre cʉ̃ja ca jʉo cojoricarã niiri, toopʉ jãa niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","To biri yua, tii boje rʉmʉre ʉje oco ca petiro, cʉ̃ paco pea o biro cʉ̃re ĩiwo Jesús're: —Ʉje oco peticoajãwʉ. Cʉotima yua —cʉ̃re ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","To biro cõ ca ĩiro Jesús pea, o biro cõre ĩiwi cʉ̃ pacore: —¿Nomio, ñee tiigo teere yʉre mʉ wedeti? Yʉ ca niirije cʉtirijere yʉ ca tii bau niipa tabe eati ména —cõre ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","To biro cʉ̃ ca ĩimijata cãare, cõ pea, ʉje oco tĩa coteri majare o biro cʉ̃jare ĩiwo: —Niipetiro mʉjare cʉ̃ ca tii dotirore biro tiiya —cʉ̃jare ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Toore niiwʉ, jĩcã amo peti, ape amore jĩcãga penituaro ca niirije jotʉ bʉcʉrʉʉri, pacarʉʉri, ʉ̃tã mena cʉ̃ja ca tiirique. Tee pea to cãnacãrʉʉpʉra 75 to biri 115 litros cõro ca oco jeerirʉʉri niiwʉ; judíos're ca dotirore biro tiirã, cʉ̃ja ca uwa coerirʉʉri niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesús pea o biro ĩiwi, ʉje oco ca tĩa coterãre: —Atirʉʉrire oco waa jãa dadocãña —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro, cʉ̃ja pea tiirʉʉrire añuropʉ pio jãa dadocãwa. ");
INSERT INTO baoNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","To biro cʉ̃ja ca tii yapanoro, o biro cʉ̃jare ĩiwi ñucã Jesús: —Peeto tii rʉʉ maquẽre jeeri ami waarãja yua, boje rʉmʉ ca jʉo tii niigʉ pʉtopʉ —cʉ̃jare ĩiwi Jesús. Cʉ̃ja pea cʉ̃ ca ĩirore biro tiiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Boje rʉmʉ ca jʉo tiigʉ pea, ocora, ʉje oco ca jeeñariquere jini ñaawi, “To biro ca biirique niicu,” ĩi majiri méé. Ca tĩa coterã wado majiwa, ca oco waaricarã niiri. To biri teere jini ñaacãri, boje rʉmʉ ca jʉo tiigʉ pea, ca amo jiaricʉre cʉ̃re jʉo cojori, ");
INSERT INTO baoNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","o biro cʉ̃re ĩiupi: —Niipetirãpʉra ʉje oco añurije peere tĩa jʉoma. Mee, jʉo cojoricarã cʉ̃ja ca jini yapicoaro jiropʉ docare ca pãmʉti jañurije peere tĩa yapano cojoma. Mʉ pea, ʉje oco añurije peere mʉ dʉajapa —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ate, Galilea yepa macã macã Caná ca wãme cʉtiri macãre Jesús cʉ̃ ca tiirique pea, ca ĩa ñaaña manirije cʉ̃ ca tii bau nii jʉorije niiro biiwʉ. Tee mena ĩñowi Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ ca tutua majuropeegʉ cʉ̃ ca niirijere. To biri jãa, cʉ̃ buerã pea, díámacʉ̃ cʉ̃re jãa tʉo nʉnʉjee jʉowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ate jiro waacoawi ñucã Jesús Capernaúm ca wãme cʉtiri macã pee. Cʉ̃ paco, cʉ̃ bairã, jãa cʉ̃ buerã cãa, cʉ̃ mena jãa waawʉ. Tii macãpʉre no cãnacã rʉmʉ mééra jãa niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judíos boje rʉmʉ Pascua ea waaro ca biiro, Jerusalén macãpʉ maa waawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Toopʉ ea, Ʉmʉreco Pacʉ yaa wiipʉre jãa waagʉ, wecʉa, ovejas, búáá, noni wapa taari maja to biri wapa tiirica tiirire ca wajoarã cʉ̃ja ca duwiri taberi ca duwirãre, cʉ̃jare bʉa eawi. ");
INSERT INTO baoNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","To biro ca tii niirãre ĩari, Jesús pea upa daari jeeri, baperica daa quenori, Ʉmʉreco Pacʉ yaa wiipʉre ca niirã niipetirãre cʉ̃ja wecʉa, cʉ̃ja oveja niipetiro menara cʉ̃jare bape ãcũ wiene peoticã cojowi. Wapa tiirica tiiri ca wajoarã yee wapa tiirica tiiri cãare maa dee batecã, ñucã cʉ̃ja ca peori pĩiri cãare tuu puu cũu bate peoticãwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","To biro tiicã, buare ca noni wapa taarãra: —¡Atere to cõrora jee witi waarãja! Yʉ Pacʉ yaa wiire apeye noni wapa taarica wii jeeñoticãña —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","To biro cʉ̃ ca tiiro ĩarã, jãa, cʉ̃ buerã pea, Ʉmʉreco Pacʉ yee wederiquere cʉ̃ja ca owarica pũuropʉre: “Mʉ yaa wiire yʉ ca mai uwa jeorijera yʉre yaiocãrucu,” cʉ̃ja ca ĩi owa cũuriquepʉre jãa tʉgoeña bʉawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","To biro Jesús cʉ̃ ca tiiro ĩarã, judíos pea o biro cʉ̃re ĩi jãiñawa: —O biro mʉ ca tiirijera ca doti majigʉ mʉ ca niirijere jãa ca majipere biro ĩigʉ, ¿ñee ʉno jãare mʉ tii bau nii ĩñogʉti? —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","To biro cʉ̃re cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Ati wii Ʉmʉreco Pacʉ yaa wiire wee batecãña, yʉ pea itia rʉmʉ jirora yʉ queno yapanocãrucu ñucã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","To biro cʉ̃jare cʉ̃ ca ĩiro judíos pea o biro cʉ̃re ĩiwa ñucã: —Cuarenta y seis cʉ̃mari peti waawʉ ati wiire quenoricaro. ¿Mʉ pea do biro tiicãri itia rʉmʉ jirora mʉ queno yapanocãgʉti? —cʉ̃re ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesús pea Ʉmʉreco Pacʉ yaa wiire cʉ̃ ca ĩijata, cʉ̃ upʉri majuro ca biiperena ĩigʉ cʉ̃jare ĩimiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","To biri jãa cʉ̃ buerã pea, cʉ̃ ca cati tuari tabepʉ o biro cʉ̃ ca ĩiriquere tʉgoeña bʉa, Ʉmʉreco Pacʉ wederiquere, to biri ñucã Jesús cʉ̃ ca ĩiriquere, díámacʉ̃ jãa tʉo nʉnʉjeewʉ yua. ");
INSERT INTO baoNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ména Jesús, Jerusalén'pʉ Pascua boje rʉmʉ niigʉ, ca ĩa ñaaña manirije cʉ̃ ca tiirijere ĩari, paʉ bojoca cʉ̃re tʉo nʉnʉjeewa. ");
INSERT INTO baoNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","To biro cʉ̃re cʉ̃ja ca biimijata cãare, Jesús pea “Díámacʉ̃ra yʉre tʉo nʉnʉjeerã tiima,” cʉ̃jare ĩitiwi, niipetirãpʉrena cʉ̃ja yeripʉ cʉ̃ja ca tʉgoeña niirijepʉre ca majigʉ niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","To biri jĩcʉ̃ ʉno peera, bojoca cʉ̃ja ca bii niirijere, aperã cʉ̃re cʉ̃ja ca wedero bootiwi, mee cʉ̃ majuropeera cʉ̃ja yeripʉ cʉ̃ja ca tʉgoeña niirijepʉre ca ĩa maji peoticãgʉ niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Niiupi jĩcʉ̃ fariseo, judíos're ca jʉo niigʉ ca nii majuropeegʉ ca niigʉ, Nicodemo ca wãme cʉtigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Cʉ̃ pea jĩcã ñami Jesús pʉto ĩagʉ doori, o biro cʉ̃re ĩi jãiñawi: —Buegʉ, jãare ca bue majiopʉ, Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ mʉ ca niirijere jãa maji. Jĩcʉ̃ ʉno peera Ʉmʉreco Pacʉ cʉ̃ mena cʉ̃ ca niitijata, ca ĩa ñaaña manirije mʉ ca tii bau niirije ʉnore tii majiticumi —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","To biro cʉ̃ ca ĩiro Jesús pea o biro cʉ̃re ĩiwi: —Díámacʉ̃ mʉre yʉ ĩi: Nemo ca wãma baʉatigʉa, Ʉmʉreco Pacʉ cʉ̃ ca doti niirijere do biro ĩa majitimi —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","To biro cʉ̃ ca ĩiro, Nicodemo pea o biro cʉ̃re ĩi jãiñawi ñucã: —¿Do biro pee biicãri ñucã mania, bʉcʉ niigʉpʉra nemo baʉacãrique to niigajati? ¿To docare mani paco paa totipʉre pʉatiri cõro jãacoarique to niigajati, nemo wãma baʉarʉgʉ? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —Díámacʉ̃ mʉre yʉ ĩi: Oco mena, ñucã Añuri Yeri cʉ̃ ca tii niirije jʉori mena nemo baʉa, ca biitigʉa, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabepʉre eatirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Bojoca cʉ̃ja ca puna cʉtirã, bojoca puna niima. Añuri Yeri cʉ̃ ca ñaajãa nʉcãrã pea, Ʉmʉreco Pacʉ puna niima. ");
INSERT INTO baoNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","To biri, “Bojoca wãma baʉa jʉorã cʉ̃ja ca baʉaricarore birora, ca baʉa nemoparã niima,” mʉre yʉ ca ĩirijere tʉo ʉcʉaticãña. ");
INSERT INTO baoNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Atere tʉgoeñañaqué: Wino no ca booro paa puucã. To biri tee ca bʉjʉrijere tʉocã pacarã, too maquẽ paa puu doo, ñucã too pee waaro bii, ĩi majiña mani. Tee ca biirore birora biima, niipetirã Añuri Yeri cʉ̃ ca tii niirije jʉori nemo ca baʉarã cãa —ĩiwi Nicodemore. ");
INSERT INTO baoNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","To biro cʉ̃ ca ĩiro, Nicodemo pea ñucã: —¿Atea do biro biicãri to biro to biigajati? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉwi Jesús: —¿Mʉa, Israel yepa macãrãre Ʉmʉreco Pacʉ yee quetire ca buegʉ nii pacagʉ, atere mʉ majititi? ");
INSERT INTO baoNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Yee méé mʉre yʉ ĩi: Jãa, jãa ca majirijere, jãa ca ĩariquere, mʉjare jãa wederucu. To biro jãa ca ĩimijata cãare, mʉja pea teere díámacʉ̃ mʉja tʉo nʉnʉjeeti. ");
INSERT INTO baoNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ati yepa maquẽrena mʉjare yʉ ca wederijere díámacʉ̃ mʉja ca tʉotijata, ¿do biro pee biicãri ʉmʉreco tutipʉ maquẽ yʉ ca wederije peera díámacʉ̃ mʉja tʉobogajati? ");
INSERT INTO baoNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","”Jĩcʉ̃ ʉno peera ʉmʉreco tutipʉre mʉa waatiupi. Yʉ, ʉmʉreco tutipʉ ca duwi dooricʉ, Ca Nii Majuropeegʉ Macʉ̃ wado yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","To biri Moisés niiquĩricʉ, ca yucʉ maniri yepapʉ cʉ̃ yee wederãre añaa cʉ̃ja ca bacaro “Cʉ̃re ca ĩarã catirucuma,” ĩigʉ, añare biigʉ cʉ̃ ca quenoricʉre, yucʉgʉ mena cʉ̃re mʉene nʉcõupi. To biri wãmera, yʉ, Ca Nii Majuropeegʉ Macʉ̃ cãa, bojoca ñañaro cʉ̃ja ca bii yaiboriquere ametʉenerʉgʉ yucʉ tenipʉ yʉ ami mʉene nʉcõ ecorucu, ");
INSERT INTO baoNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","niipetirã bojoca yʉre ca tʉo nʉnʉjeerã to birora caticõa niiriquere cʉ̃ja ca cʉopere biro ĩigʉ —cʉ̃re ĩiwi Jesús, Nicodemore. ");
INSERT INTO baoNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ʉmʉreco Pacʉ, bojocare bʉaropʉra maima ĩigʉ, cʉ̃ Macʉ̃ jĩcʉ̃ra ca niigʉre, díámacʉ̃ cʉ̃re ca tʉo nʉnʉjeerã niipetirã cʉ̃ja bii yaiticãjato, caticõa niirique peere cʉ̃ja cʉojato ĩigʉ cʉ̃re tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ʉmʉreco Pacʉa, bojocare ñañaro tiirʉgʉ méé, cʉ̃ Macʉ̃re tiicojoupi. Cʉ̃ jʉori bojocare ametʉenerʉgʉ pee cʉ̃re tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ʉmʉreco Pacʉ Macʉ̃re díámacʉ̃ ca tʉo nʉnʉjeegʉa, ñañaro tii yaio ecotirucumi. Díámacʉ̃ cʉ̃re ca tʉo nʉnʉjeetigʉ doca, mee ñañaro ca tii ecoricʉpʉ nii yerijãami, Ʉmʉreco Pacʉ Macʉ̃ jĩcʉ̃ra ca niigʉre díámacʉ̃ cʉ̃ ca tʉo nʉnʉjeetirije wapa. ");
INSERT INTO baoNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Díámacʉ̃ cʉ̃re ca tʉo nʉnʉjeetirã pea mee ñañaro tiiricarãpʉ nii yerijãama. Ñañarije wado ca tii niirucurã niiri, Jesucristo añurije wado ca tiigʉ ati yepapʉre cʉ̃ ca doori tabere, Jesucristo peere boorica tabe ʉnora ca naitĩarije peere boo ametʉenecãupa. ");
INSERT INTO baoNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Niipetirã ñañarije ca tii niirã, ca boerijere ĩa juna jañuma, yaioropʉ ñañarije cʉ̃ja ca tii niirucurije bau niiropʉ bii bau niire ĩirã, teere juna jañuma. ");
INSERT INTO baoNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ʉmʉreco Pacʉ yee díámacʉ̃ ca niirije queti ca ĩirore biro ca tii nʉnʉjeerã pea, ca boerije pʉto pee dooma, cʉ̃ja ca tii niirije niipetiro Ʉmʉreco Pacʉ cʉ̃ ca boorore biro cʉ̃ja ca tii niirije añuropʉ ca bii bau nii ĩñocãpere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ate jiro Jesús, jãa cʉ̃ buerã mena Judea yepapʉ waawi ñucã. Toopʉre jãa mena yoa jañuropʉra nii, bojocare uwo coe, tii niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ñucã Juan cãa, Enón'pʉ bojocare uwo coe niiupi, Salim ca wãme cʉtiri macã pʉtore, tii tabere pairo oco ca niiro macã. To biri bojoca toopʉ waari, cʉ̃re uwo coe ecorucuupa. ");
INSERT INTO baoNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Ména ate pea, Juan're cʉ̃ja ca tia cũuparo jʉguero biiwʉ.) ");
INSERT INTO baoNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","To biri jĩcã rʉmʉ jĩcãrã Juan buerã pea, jĩcʉ̃ judío mena wede peniupa, ñañarije cʉ̃ja ca tiiricaro jiro, teere coerã cʉ̃ja ca uwa coerucurije maquẽre. ");
INSERT INTO baoNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","To biro ĩi yapano, o biro ĩirã waaupa Juan're: —Buegʉ, tii rʉmʉ mʉ mena dia Jordán ape nʉña ca niiricʉ jãare mʉ ca wedericʉ pea, mecʉ̃ra bojocare uwo coegʉ tiijãwi. Niipetirã cʉ̃ peere tʉo nʉnʉjeema —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","To biro cʉ̃re cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiupi Juan: —Jĩcʉ̃ ʉno peera to biro tii majiriquere cʉo majitimi, Ʉmʉreco Pacʉ cʉ̃ ca tiicojotijata. ");
INSERT INTO baoNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mee mʉja majuropeera: “Yʉa, Mesías méé yʉ nii. Jĩcʉ̃ cʉ̃ jʉguero cʉ̃ ca tiicojo jʉguericʉ pee yʉ nii,” yʉ ca ĩirijere mʉja tʉowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Amo jiarica rʉmʉre cʉ̃ nʉmo ca niipore ca cʉogʉa, cõ manʉ ca niipʉ cõre cʉomi. Co manʉ ca niipʉ mena macʉ̃ too ca niigʉ, cʉ̃ ca wederijere tʉogʉ bʉaro ʉjea niimi. To biri yʉ cãa Jesús mena macʉ̃ niiri, bʉaro yʉ ʉjea nii. ");
INSERT INTO baoNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","To biri cʉ̃ pea, bʉaro jañuri ca nii majuropeegʉ nii nʉnʉa waarucumi. Yʉ pea, watoa macʉ̃re biro bii nʉnʉa waagʉ yʉ tii. ");
INSERT INTO baoNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","”Emʉaropʉ ca dooricʉa, niipetirã ametʉenero ca nii majuropeegʉ niimi. Ati yepare ca niigʉa, ati yepa macʉ̃ niigʉ biimi. To biri ati yepa maquẽ wadore wedemi. Ʉmʉreco tutipʉ ca dooricʉ pea, niipetirã ametʉenero ca nii majuropeegʉ niiri, ");
INSERT INTO baoNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","cʉ̃ ca ĩariquere, cʉ̃ ca tʉoriquere, wedemi. To biro cʉ̃ ca ĩimijata cãare, jĩcʉ̃ ʉno peera cʉ̃ ca wederijere díámacʉ̃ tʉo nʉnʉjeetima. ");
INSERT INTO baoNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","To biro cʉ̃ja ca bii pacaro, jĩcʉ̃, cʉ̃ yee quetire díámacʉ̃ ca tʉo nʉnʉjeegʉ pea, “Díámacʉ̃ra nii Ʉmʉreco Pacʉ cʉ̃ ca wederije,” ĩigʉ ĩimi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ, Ʉmʉreco Pacʉ yee wadore wedemi, Ʉmʉreco Pacʉ cʉ̃ Añuri Yerire dʉjaricaro maniro cʉ̃ ca tiicojoricʉ niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Cʉ̃ Pacʉ, cʉ̃ Macʉ̃re maimi. To biri niipetirijepʉrena cʉ̃ ca doti maji niirijere cʉ̃re tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","To biri cʉ̃ Macʉ̃re díámacʉ̃ ca tʉo nʉnʉjeegʉa, to birora caticõa niiriquere cʉomi. Ʉmʉreco Pacʉ Macʉ̃re díámacʉ̃ ca tʉo nʉnʉjeerʉgatigʉ pea, tee caticõa niiriquere cʉotirucumi. Ʉmʉreco Pacʉ ñañaro cʉ̃ ca tiirije peere ñañaro peti tamʉorucumi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Jiro, paʉ peti bojoca Jesús're cʉ̃ja ca tʉo nʉnʉjeerijere, ñucã Juan ametʉenero cʉ̃ ca uwo coerijere queti tʉoupa fariseos. ");
INSERT INTO baoNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Biigʉpʉa añuro petira Jesús méé cʉ̃jare uwo coewi; jãa, cʉ̃ buerã pee bojocare jãa uwo coewʉ.) ");
INSERT INTO baoNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","To biri Jesús teere majiri, Judea yepa ca niiricʉ, Galilea yepa pee jãare jʉo tuacoawi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","To biro bii tua waagʉ, Samaria yepare cʉ̃ ca waa nʉnʉa waape niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","To biri tii yepare eagʉ, Sicar ca wãme cʉtiri macã, Jacob cʉ̃ macʉ̃ Josére cʉ̃ ca cũu yaiquĩrica yepa pʉto ca niiri macãre jãare jʉo eawi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tii yepare niiwʉ Jacob niiquĩricʉ oco ope. Jesús pea, maa doogʉ ca boga yaicoaricʉ niiri, tii ope pʉtora ea nuucoawi. Muipũ jotoa decomacã ea doogʉ cʉ̃ ca biiri tabe niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jãa, cʉ̃ buerã pea, macãpʉ baarique jãa wapa tiirã waacoawʉ. To biro jãa ca bii waa ditoyere, jĩcõ nomio, Samaria macõ, tii opere oco waago doogo cõ ca earo, o biro cõre ĩiupi Jesús: —Petoacã yʉ cãare oco tiicojoya —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Jãa judíos pea, Samaria yepa macãrã mena añuro jãa ca ameri tiitirije ca maniro macã, o biro cʉ̃re ĩiupo Jesús're: —¿Ñee tiigʉ mʉa judío nii pacagʉ, yʉ Samaria macõre mʉ oco jãiti? —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","To biro cʉ̃re cõ ca ĩiro, o biro cõre ĩi yʉʉupi Jesús: —Ʉmʉreco Pacʉ cʉ̃ ca tiicojorijere mʉ ca majijata, ñucã “Yʉre oco tĩaña,” mʉre ca ĩigʉre, “Cʉ̃ niicumi,” mʉ ca ĩi ĩa majijata, cʉ̃ peere mʉ jãibojacupa. To biri cʉ̃ pea oco catirique ca tiicojorijere mʉre tiicojobojacupi —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","To biro cõre cʉ̃ ca ĩiro, cõ pea o biro cʉ̃re ĩiupo: —Wiogʉ, ati opea ʉ̃cʉ̃a jañu doca, oco waarique ʉno cʉoti pacagʉ, ¿noo maquẽpʉ bʉacãri oco ca catirijere yʉre mʉ tiicojogʉti? ");
INSERT INTO baoNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mani ñicʉ̃ Jacob niiquĩricʉ ati ope maquẽre oco jini, cʉ̃ puna cãa jini, ñucã cʉ̃ ecaricarã cãare oco tĩa, cʉ̃ ca tiirucurica operena jãare cũuquĩupi. ¿To docare mʉa, cʉ̃ ametʉenero ca nii majuropeegʉ mʉ niiti? —cʉ̃re ĩi jãiñaupo Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","To biro cõ ca ĩi jãiñaro, o biro cõre ĩi yʉʉupi Jesús: —Niipetirã ati ope maquẽre ca oco jinirã, to birora oco jinirʉgacõa niirucuma ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Oco yʉ ca tiicojorijere ca jinigʉ pea, pʉati oco jinirʉga, biitirucumi. Oco yʉ ca tiicojorije pea, to birora caticõa niirique cʉ̃ yeripʉre, oco ca witi yerijãatirore birora cʉ̃re biicõa niirucu —cõre ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","To biri cõ pea o biro cʉ̃re ĩiupo: —Wiogʉ, to docare tee pee yʉre oco tiicojoya, pʉati oco jinirʉga, ati opepʉre oco waago doorucu, yʉ ca bii nemotipere biro ĩigʉ —cʉ̃re ĩiupo Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","To biro cʉ̃re cõ ca ĩiro, o biro cõre ĩiupi Jesús: —To docare tua waa, mʉ manʉre jʉo, anopʉra mʉ doowa ñucã —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","To biro cõre cʉ̃ ca ĩiro: —Ca manʉ manigo yʉ nii yʉa —cʉ̃re ĩi yʉʉupo cõ pea. Jesús pea o biro cõre ĩiupi: —“Yʉa ca manʉ manigo yʉ nii,” mʉ ca ĩijata, díámacʉ̃ra mʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Mʉa, jĩcã amo cõro peti ca manʉ jʉ̃mʉa cʉtirico mʉ nii. To biri mecʉ̃ mʉ mena ca niigʉ cãa, mʉ manʉ majurope méé niimi, díámacʉ̃ra mʉ ĩi, to biro mʉ ca ĩijata —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","To biro cõre cʉ̃ ca ĩiro, cõ pea o biro cʉ̃re ĩiupo: —Wiogʉ, yʉa mʉre yʉ ĩa maji. Mʉa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ mʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Jãa ñicʉ̃ jʉ̃mʉa Samaria yepa macãrã ca niiquĩricarã ati buuropʉ Ʉmʉreco Pacʉre juu bue nʉcʉ̃ bʉorucuupa. Mʉja judíos pea, “Jerusalén'pʉ wado nii Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉorica tabe,” mʉja ĩirucu —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","To biro cõ ca ĩiro, o biro cõre ĩiupi Jesús: —Nomio, yʉ ca ĩirijere yʉre tʉo nʉnʉjeeya: Ati buuropʉ doo, ñucã Jerusalén macãpʉ waa, biitirãra Ʉmʉreco Pacʉre mʉja ca jãi juu bue nʉcʉ̃ bʉopa tabe ea. ");
INSERT INTO baoNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Mʉja Samaria macãrã, mʉja ca majitirijerena mʉja ĩi nʉcʉ̃ bʉocã. Jãa judíos pea jãa ca tii nʉcʉ̃ bʉogʉre jãa maji. To biri, jãa judíos jʉori bojocare ametʉenerucumi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Mee ea, mecʉ̃ra nii mee, díámacʉ̃ra Ʉmʉreco Pacʉre ca tii nʉcʉ̃ bʉorã, ca niirore biro, Ʉmʉreco Pacʉ yʉʉ Añuri Yeri cʉ̃ ca boorore biro cʉ̃ja ca tii nʉcʉ̃ bʉopa tabe, to biirije cʉ̃ja ca tiiro boomi Ʉmʉreco Pacʉ, cʉ̃re ca ĩi nʉcʉ̃ bʉorãra. ");
INSERT INTO baoNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ʉmʉreco Pacʉa, yeri ca bautigʉ niimi. To biri cʉ̃re ca tii nʉcʉ̃ bʉorã, cʉ̃ja yeripʉ, ĩi ditoricaro maniro Ʉmʉreco Pacʉ yʉʉ Añuri Yeri cʉ̃ ca boori wãmere biro ca tiiparã niima —cõre ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","To biro cõre cʉ̃ ca ĩiro, nomio pea o biro cʉ̃re ĩiupo Jesús're: —Yʉ maji, Mesías, Cristo ca wãme cʉtigʉ cʉ̃ ca eapere. Cʉ̃ eagʉpʉ niipetirije manire wede majiorucumi —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","To biro cʉ̃re cõ ca ĩiro, o biro cõre ĩiupi Jesús pea: —Mʉ mena ca wede penigʉa, cʉ̃ra yʉ nii yʉa —cõre ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","To biro cõre cʉ̃ ca ĩi niiri tabera jãa, cʉ̃ buerã, macãpʉ baarique ca wapa tiirã waaricarã jãa eawʉ. Cʉ̃ pʉto earã, Jesús pea nomio mena cʉ̃ ca wede peni niirijere ĩarã, do biro pee jãa ĩi majiticãwʉ. Bii pacarã jĩcʉ̃ peera, ¿ñee ʉnore cõ booti? ¿Ñee ʉnore cõ mena mʉ wede peniti? jãa ĩi jãiña majiticãwʉ ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Jãa ca eari tabera, nomio pea cõ jotʉre toora piti dopo, macã pee tuacoawo. Toopʉ eari, o biro bojocare cʉ̃jare ĩi wedeupo: ");
INSERT INTO baoNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ĩarã dooña mʉja cãa. Õo, jĩcʉ̃ bojocʉ niijãwi, yʉ ca tiiriquere ca maji peoticãgʉ. ¿Ʉmʉreco Pacʉ cʉ̃ ca tiicojopʉ Mesías cʉ̃ja ca ĩigʉ méé cʉ̃ niicã tiimijapari? —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","To cõrora tii macã macãrã pea, Jesús cʉ̃ ca niiri tabepʉ ĩarã dooupa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","To biro cõ ca bii ditoyeacã: “Buegʉ, baaya petopʉra,” cʉ̃re jãa ĩimiwʉ Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","To biro cʉ̃re jãa ca ĩiro: —Yʉa, mʉja ca majitirije baarique yʉ cʉo —jãare boca ĩiwi Jesús pea. ");
INSERT INTO baoNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","To biro jãare cʉ̃ ca ĩiro, o biro jãa ameri ĩi jãiñawʉ: —¿Mee jĩcãrã cʉ̃re cʉ̃ja baarique jee doobujapari? —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","To biro jãa ca ameri ĩiro, Jesús pea o biro jãare ĩiwi: —Yʉ baariquea, yʉre ca tiicojo cojoricʉ cʉ̃ ca boorore biro tiirique, to biri cʉ̃ ca dotiriquere yʉ ca tii yapanope, nii. ");
INSERT INTO baoNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Mʉja pea: “Bapari muipũa dʉja ména ote ca bʉcʉa yapanopa tabe,” mʉja ĩi. Yʉ pea o biro yʉ ĩi: “Ote wejerire ĩañaaqué, mee bʉcʉa yapanocoa, jeeriquepʉ nii,” yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ote dicare ca jeegʉa, cʉ̃ ca paderije wapare wapa taami. Cʉ̃ ca jeerije pea, Ʉmʉreco Pacʉ cʉ̃ ca tiicojorije to birora cʉ̃ ca caticõa niipe nii. To biri ote ca otegʉ, ñucã ca dicare ca jeegʉ cãa, cʉ̃ja pʉarãpʉra jĩcãri cõro ʉjea niima. ");
INSERT INTO baoNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","O biro ĩirica wãme díámacʉ̃ra nii: “Jĩcʉ̃ niimi ca otegʉ. Apĩpʉ niimi ñucã ca dicare ca jeegʉ,” ĩiriquea. ");
INSERT INTO baoNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mʉja yʉ buerã ca niirã, to biro cʉ̃ja ca ĩirucuri wãmere birora mʉja bii. Mee aperã cʉ̃ja ca wede majio jʉoricarã pʉtopʉre, yʉ yee añurije quetire mʉjare yʉ wede doti cojowʉ, añuro cʉ̃ja ca tʉo ame wio peoti majiro cʉ̃ja tiijato ĩigʉ. Aperã popiye bii jʉoupa añurije quetire wederã, cʉ̃ja ca pade jʉoriquepʉre ca pade boja yapanorãre biro mʉjare yʉ tii doti cojo. To biri mʉjara popiye méé jañuro nii, yʉ ca wede doti cojorije —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Sicar macã macãrã samaritanos, “Yʉ ca tiiriquere, niipetiro yʉre ĩijãwi,” nomio cõ ca ĩirijere ca tʉoricarã, paʉ Jesús're tʉo nʉnʉjeewa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","To biri Samaria macãrã Jesús pʉto earã, “Waaticãña, jãa mena tuaya ména,” cʉ̃re ĩiwa Jesús're. To biro cʉ̃re cʉ̃ja ca ĩiro macã, tii macãre pʉa rʉmʉ niiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","To biri ñucã Jesús cʉ̃jare cʉ̃ ca wederijere tʉorã, paʉ jañuro cʉ̃re tʉo nʉnʉjee nʉnʉa waawa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","To biro biirã, o biro cõre ĩiwa: —Mecʉ̃ra yua, jãare mʉ ca ĩijãrije jʉori wado méé jãa tʉo nʉnʉjee, cʉ̃ majuropeera cʉ̃ ca ĩijãrijere jãa majuropeera tʉori, díámacʉ̃ra bojocare Ca Ametʉenegʉ cʉ̃ ca niirijere jãa maji —cõre ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Pʉa rʉmʉ jiro Jesús, Samaria yepa ca niiricʉ, Galilea yepa pee waa nʉnʉa waawi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ména, Jesús majuropeera: “Jĩcʉ̃, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉre cʉ̃ yaa yepa macãrã cʉ̃re nʉcʉ̃ bʉotima,” ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea yepapʉre Jesús cʉ̃ ca earo, too macãrã bojoca pea añuro cʉ̃re jãi bocawa, Jerusalén'pʉ Pascua boje rʉmʉ ĩarã earã, niipetirije tii boje rʉmʉre cʉ̃ ca tiiriquere ca ĩaricarã niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesús, Galilea yepare waa yuju jañucã, ocorena ʉje oco cʉ̃ ca jeeñorica macã Canápʉra tuacoawi ñucã. Tii macãre niiupi jĩcʉ̃, wiogʉ yeere pade nemori majʉ ʉpʉ ca niigʉ Capernaúm'pʉ cʉ̃ macʉ̃ bʉaro ca diagʉre ca cʉogʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","To biri, “Jesús Judea yepapʉ ca niiricʉ, Galilea yepare eajagʉ,” cʉ̃ja ca ĩirijere queti tʉori, Jesús're ĩagʉ eari, “Yʉ macʉ̃ bii yaigʉpʉ ca biigʉre, yʉ yaa wiipʉ waari cʉ̃re catiogʉja,” bʉaro cʉ̃re ĩiwi cʉ̃ pacʉ pea. ");
INSERT INTO baoNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","To biro cʉ̃re cʉ̃ ca ĩiro: —Ca bii ĩñorijere, ca ĩa ñaaña manirije tii jeeñoriquere, mʉja ca ĩatijata, mʉja tʉo nʉnʉjeeti mʉja —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","To biro cʉ̃ ca ĩi pacaro, wiogʉre pade nemori majʉ ʉpʉ pea: —Wiogʉ, yʉ macʉ̃ cʉ̃ ca bii yaitirora yoari méé dooya —cʉ̃re ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","To biro cʉ̃re cʉ̃ ca ĩiro Jesús pea o biro cʉ̃re ĩiwi: —Mʉ yaa wiipʉ tua waagʉja. Mee mʉ macʉ̃ caticoami —cʉ̃re ĩiwi. To biro cʉ̃re cʉ̃ ca ĩirijere díámacʉ̃ tʉori, cʉ̃ yaa wiipʉ tuacoawi. ");
INSERT INTO baoNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","To biro cʉ̃ ca bii tua waaro, cʉ̃re pade coteri maja pea cʉ̃re bocarã doori: —¡Mʉ macʉ̃ caticoajãwi mee! —cʉ̃re ĩi bocaupa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","To biro cʉ̃re cʉ̃ja ca ĩi bocaro tʉogʉ, “¿Di tabe muipũ cʉ̃ ca niiro peti cʉ̃ cati jʉojãri yʉ macʉ̃?” cʉ̃jare ĩi jãiñaupi. To biro cʉ̃ ca ĩi jãiñaro: —Ñamica, jotoa decomacã jiroacã muipũ cʉ̃ ca niirije mena cʉ̃re wiorique tatijãwʉ —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","To biro cʉ̃re cʉ̃ja ca ĩiro, cʉ̃ pacʉ pea: “ ‘Mee mʉ macʉ̃ caticoami,’ Jesús yʉre cʉ̃ ca ĩijãri tabe peti biijapa,” ĩi majicãupi. To biri teere cʉ̃jare cʉ̃ ca wedero tʉorã, cʉ̃ yaa wii macãrã niipetirã Jesús're cʉ̃re tʉo nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ate, Judea yepa ca niiricʉ, Galilea yepare tua eagʉ cʉ̃ ca tiirije pea, pʉati ca ĩa ñaaña manirije Jesús cʉ̃ ca tii bau nii ĩño tʉja waarije niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ate jiro, judíos boje rʉmʉ cʉ̃ja ca quenoro ĩagʉ waawi ñucã Jesús, Jerusalén macãpʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén macãre “Ovejas” ca wãme cʉtiri jope pʉtore nii, arameo wederique menara Betzatá ca wãme cʉtiri raa, jĩcã amo cõro niiri wiijeriacã ca nii amojoderi raa. ");
INSERT INTO baoNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Teepʉre, paʉ bojoca ca diarique cʉtirã, ca ĩatirã, ca waa majitirã, ca bʉʉricarã, cũa cojowa, oco ca jaberijere yuerã. ");
INSERT INTO baoNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ména Ʉmʉreco Pacʉ pʉto macʉ̃ pea majiña maniro no ca boori tabe eari, tiira maquẽ ocore tii jaberucuupi. Cʉ̃ ca tii jabero jiroacã ca ñaañua jʉogʉ ʉno, no ca boorije cʉ̃ ca diarique cʉtirijere ametʉene ecorucuupi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Cʉ̃ja watoare niiupi jĩcʉ̃, treinta y ocho cʉ̃mari peti ca diarique cʉti niigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","To biri Jesús pea, too ca cũagʉre ĩa, mee yoaro peti cʉ̃ ca diarique cʉti cũa yujurijere majiri, o biro cʉ̃re ĩi jãiñawi: —¿Mʉ diarique ca ametʉaro mʉ booti? —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ca diagʉ pea o biro cʉ̃re ĩi yʉʉwi Jesús're: —Wiogʉ, oco ca jaberi tabere ocorapʉ yʉre ca ami cõañuagʉ ʉno manimi. To cãnacã tiira oco ca jabero jiro tiirapʉ yʉ ca ñaañuarʉgaro, aperã pee wado yʉ jʉguero ñaañua weocãrucuma —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwi Jesús: —Wãmʉ nʉcã, mʉ ca cũari quejerore ami, waagʉja —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","To biro cʉ̃re cʉ̃ ca ĩirije menara, diarique manigʉpʉ yua, cʉ̃ ca cũarucurica quejerore ami pʉja, waacã nʉnʉa waawi. Yerijãarica rʉmʉ ca niiro macã, ");
INSERT INTO baoNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","judíos ʉparã pea Jesús cʉ̃ ca catioricʉ cʉ̃ ca cũarica quejerore cʉ̃ ca ami waaro ĩari, o biro cʉ̃re ĩiupa: —Mecʉ̃a yerijãarica rʉmʉ nii; paderica rʉmʉ méé nii. Tii quejerore ami waagʉa padegʉ mʉ tii —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","To biro cʉ̃re cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiupi cʉ̃ pea: —Yʉre ca diarique ametʉenejãgʉ, “Mʉ ca cũari quejerore ami, waagʉja,” yʉre ĩijãwi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","To biro cʉ̃ ca ĩiro cʉ̃ja pea o biro cʉ̃re ĩi jãiñaupa: —¿Ñiru cʉ̃ niijãri, “Mʉ ca cũari quejerore amiri waagʉja,” mʉre ca ĩiricʉa? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Cʉ̃ pea cʉ̃re ca diarique ametʉenericʉre majitiupi, Jesús pea to ca niirã paʉ bojoca watoapʉ waa, cʉ̃ ca yaicoaro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jiro ñucã Ʉmʉreco Pacʉ yaa wiipʉ cʉ̃re bʉa eari, o biro cʉ̃re ĩiwi Jesús: —Tʉoya. Mecʉ̃ra diarique manigʉ mʉ nii yua. To biri ñañarijere tii nemoticãña, tee ametʉene jañuro ñañaro mʉ ca tamʉotipere biro ĩigʉ —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","To biro cʉ̃ ca ĩiro jiro cʉ̃ pea judíos pʉtopʉ waari, “Yʉre ca diarique ametʉenericʉa, ‘Jesús’ niijapi,” cʉ̃jare ĩi wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ate jʉori judíos, yerijãarica rʉmʉrena to biirije peti cʉ̃ ca tiicãrije jʉori, Jesús're ĩi pato wãcõ nʉnʉjee, cʉ̃re jĩarʉga cote, biirucuwa. ");
INSERT INTO baoNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","To biro cʉ̃ja ca biiro ĩari, Jesús pea o biro ĩiwi: —Yʉ Pacʉ cãa to birora padecõa niimi. To biri yʉ cãa, to birora yʉ padecõa nii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ate jʉori judíos pea, yerijãarica rʉmʉre ca dotirijere cʉ̃ ca ametʉene nʉcãrije jʉori wado méé, ñucã Ʉmʉreco Pacʉre, “Yʉ Pacʉ niimi,” cʉ̃ ca ĩirije mena, Ʉmʉreco Pacʉ jĩcãripʉ cʉ̃ ca biicãrije jʉori, nemo jañuro cʉ̃re jĩarʉga cotewa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","To biri Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Díámacʉ̃ mʉjare yʉ ĩi: Yʉ, Ʉmʉreco Pacʉ Macʉ̃ nii pacagʉ, yʉ ca boori wãme yʉ tii majiti. Yʉ Pacʉ cʉ̃ ca tiirijere ĩari wado yʉ tii. Yʉ, cʉ̃ Macʉ̃ cãa, yʉ Pacʉ cʉ̃ ca tiirije niipetirije yʉ tii. ");
INSERT INTO baoNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Yʉ Pacʉ yʉre ca maigʉ niiri, niipetirije cʉ̃ ca tiirijere yʉre ĩñomi. Ména, ate ametʉene jañuro do biro ca tiiya manirijepʉ tii bau nii majiriquere yʉre ĩñorucumi, ametʉene jañuro do biro pee mʉja ca ĩiticãpere. ");
INSERT INTO baoNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ñucã yʉ Pacʉ, ca bii yaicoaricarãre cʉ̃jare catiori, catiriquere cʉ̃jare tiicojo, cʉ̃ ca tiirore birora yʉ, cʉ̃ Macʉ̃ cãa, yʉ ca tiicojorʉgarãre catiriquere yʉ tiicojo. ");
INSERT INTO baoNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yʉ Pacʉa, jĩcʉ̃ ʉno peerena ĩa bejetimi. Cʉ̃ Macʉ̃ pee docare niipetirije yʉ ca ĩa beje majipere yʉre tiicojowi, ");
INSERT INTO baoNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","niipetirã yʉ Pacʉre cʉ̃ja ca ĩi nʉcʉ̃ bʉorore birora, yʉ, cʉ̃ Macʉ̃ cãare cʉ̃ja ĩi nʉcʉ̃ bʉojato ĩigʉ. Yʉre ca ĩi nʉcʉ̃ bʉotigʉa, yʉ Pacʉ yʉre ca tiicojo cojoricʉ cãare ĩi nʉcʉ̃ bʉotimi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","”Díámacʉ̃ mʉjare yʉ ĩi: Yʉ ca wederijere tʉo, yʉre ca tiicojo cojoricʉre tʉo nʉnʉjee, ca tiigʉa, to birora caticõa niiriquere cʉomi. Ñañaro tii yaio ecotirucumi, mee cʉ̃ ca bii yaiboriquere ametʉari caticõa niirique peere ca bʉaricʉ niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Yee méé mʉjare yʉ ĩi: Tee ca biipa tabe ea dooro bii, mee mecʉ̃ra nii yerijãa, ca bii yairãre biro ca niirã, yʉ, Ʉmʉreco Pacʉ Macʉ̃ wederiquere cʉ̃ja ca tʉopa tabe, yʉ ca wederijere ca tʉo nʉnʉjeerã catirucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yʉ Pacʉ, cʉ̃ majuropeera catirique cʉ̃ ca cʉorore birora, yʉ, cʉ̃ Macʉ̃ cãare, yʉ majuropeera catirique yʉ ca cʉoro yʉre tiiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","To biri ñucã, yʉ, Ca Nii Majuropeegʉ Macʉ̃ yʉ ca niirije jʉori, bojoca niipetirãre yʉ ca ĩa beje majipe cãare yʉre tiicojowi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Atere tʉo ʉcʉaticãña. Earucu niipetirã ca bii yaiquĩricarã yʉ wederiquere tʉori, ");
INSERT INTO baoNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","maja operipʉ ca niiricarãra cʉ̃ja ca witipa tabe. Añurijere ca tii niiricarã to birora caticõa niirʉgarã cati tuarucuma. Ñañarijere ca tiirucuricarã pea ñañaro tii ecorʉgarã cati tuarucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","”Yʉa, yʉ majurope yʉ ca boorora yʉ tiiti. Yʉ Pacʉ cʉ̃ ca dotiro mena yʉ ĩa beje. Yʉ ca ĩa bejerije díámacʉ̃ra nii. Yʉ majurope yʉ ca booro, yʉ ca tiirʉgarijere yʉ tiiti. Yʉ Pacʉ, yʉre ca tiicojo cojoricʉ cʉ̃ ca boorore biro wado yʉ tii. ");
INSERT INTO baoNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","”Yʉ majuropeera yʉ yee maquẽre yʉ ca wedejata, yʉ yee maquẽre yʉ ca wederijere díámacʉ̃ méére biro yʉre mʉja tʉocãbocu. ");
INSERT INTO baoNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","To biri apĩpʉ niimi, yʉ yee maquẽre ca wede bojagʉ. To biri “Yʉ yee maquẽre cʉ̃ ca ĩi bojarije pee doca díámacʉ̃ra nii,” yʉ ĩi maji. ");
INSERT INTO baoNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mʉja, “Juan're jãiñarãja,” mʉja ĩi cojoupa. Cʉ̃ ca wederique pea díámacʉ̃ra cʉ̃ ca ĩirique nii. ");
INSERT INTO baoNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yʉa, bojocʉra yʉ yee maquẽre cʉ̃ ca wede bojarijerena “Añu majuropeecã” yʉ ĩi, ĩigʉ méé yʉ ĩi; ñañaro cʉ̃ja ca biiboriquere cʉ̃ja ametʉajato ĩima ĩigʉ mʉjare yʉ ĩi atera. ");
INSERT INTO baoNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan, jĩcãga jĩa boericaga ca boe baterore biro ca biigʉ niiupi, añurije quetire ca wedegʉ niiri. Mʉja pea tee cʉ̃ ca wederijere tʉorã, no cõro meeacãra teere mʉja tʉo ʉjea nii niirʉgamiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yʉ pea Juan cʉ̃ ca wederique ametʉenero, yʉ yee maquẽre ca wede bojarijere yʉ cʉo. Yʉ ca tiirije, yʉ Pacʉ cʉ̃ ca doti cojoriquere yʉ ca tiirijera, cʉ̃ ca tiicojoricʉra yʉ ca niirijere ĩa majiricaro tii. ");
INSERT INTO baoNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yʉ Pacʉ, yʉre ca tiicojo cojoricʉ cãa, yʉ yee maquẽre wede bojami, jĩcãti ʉno peera cʉ̃ ca wederijere tʉo, cʉ̃re ĩa, mʉja ca tiitirije ca nii pacaro. ");
INSERT INTO baoNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Cʉ̃ wederique cãa mʉjapʉre niiticã, yʉ, Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉre díámacʉ̃ mʉja ca tʉo nʉnʉjeetirije jʉori. ");
INSERT INTO baoNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","”Mʉja, Ʉmʉreco Pacʉ wederiquere cʉ̃ja ca owariquepʉre añuropʉ mʉja buecãrucu, “Teepʉre caticõa niiriquere jãa bʉarucu” ĩi tʉgoeñari. Tee pea yʉ yee maquẽrena to ca wedecãmijata cãare, ");
INSERT INTO baoNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","mʉja pea yʉre mʉja tʉo nʉnʉjeerʉgati, caticõa niiriquere cʉorʉga pacarã. ");
INSERT INTO baoNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","”Yʉa bojocara, “Añuro peti ca tiigʉ niimi,” yʉre cʉ̃ja ca ĩi nʉcʉ̃ bʉorijere yʉ amaati. ");
INSERT INTO baoNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Apeyera ñucã, yʉa mʉjara yʉ ĩa majicã, Ʉmʉreco Pacʉre mʉja ca maitirijere yʉ maji. ");
INSERT INTO baoNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yʉa, yʉ Pacʉ cʉ̃ ca tiicojoro yʉ doowʉ. Mʉja pea yʉre mʉja booti. Apĩ cʉ̃ majuropeera ca doogʉ ʉno peera añuro mʉja tʉo nʉnʉjeebocu. ");
INSERT INTO baoNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ʉmʉreco Pacʉ jĩcʉ̃ra ca niigʉ, “Añurã mʉja nii,” mʉjare cʉ̃ ca ĩi nʉcʉ̃ bʉope peera amari méé, mʉja majuropeera “Añurã mʉja nii,” mʉja ca ameri ĩi nʉcʉ̃ bʉorije wado ca amarã, ¿do biro pee tiicãri díámacʉ̃ mʉja tʉo nʉnʉjeebogajati? ");
INSERT INTO baoNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","” “Cʉ̃ Pacʉpʉre ñañaro manire wedejãa buiyeerucumi,” yʉre ĩi tʉgoeñaticãña, “Moisés cʉ̃ ca doti cũurique niipetiro tii nʉnʉjeerãra catiriquere mani bʉarucu,” mʉja ca ĩi yue niigʉra niimi mʉjare ca wedejãagʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisés niiquĩricʉ cʉ̃ ca ĩiriquere díámacʉ̃ mʉja ca tʉo nʉnʉjeejata, yʉ cãare díámacʉ̃ mʉja tʉo nʉnʉjeebocu. Moisés niiquĩricʉa yʉ yee maquẽrena owa cũu jʉguequĩupi. ");
INSERT INTO baoNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Cʉ̃ ca owa cũuriquere díámacʉ̃ ca tʉo nʉnʉjeetirã nii pacarã, ¿do biro pee biicãri yʉ ca ĩirije peera, díámacʉ̃ mʉja tʉo nʉnʉjeebogajati? —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ate jiro, Galilea ʉtabʉcʉra, ñucã tiirarena Tiberias cʉ̃ja ca ĩiri raa ape nʉña pee Jesús mena jãa tĩacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Bojoca ca diarique cʉtirãre catiogʉ ca ĩa ñaaña manirije cʉ̃ ca tiirijere ca ĩaricarã niiri, paʉ bojoca cʉ̃re nʉnʉwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","To biri Jesús pea upa buuropʉ maa waa, jãa, cʉ̃ buerã mena ea nuu eawi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Mee judíos boje rʉmʉ Pascua ea waaro biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","To biri Jesús pea ĩa cojogʉ, paʉ bojoca cʉ̃re ca nʉnʉ doorãre ĩari, o biro ĩiwi Felipere: —¿Noopʉ baarique mani wapa tiirãti, anija patoacã cʉ̃ja ca baapere? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Mee Jesús pea cʉ̃ ca tiipere añuro majicã pacagʉ, “¿Felipe, do biro yʉre cʉ̃ ĩi yʉʉgʉti?” ĩima ĩigʉ, to biro cʉ̃re ĩi jãiñawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","To biro cʉ̃ ca ĩiro, Felipe pea o biro ĩi yʉʉwi Jesús're: —¡Agó nija! Doscientos rʉmʉri padegʉ wapa taaricaro cõro mena baarique wapa tiiri petoriacã eca batomijata cãare earicaro mani —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","To biro cʉ̃ ca ĩiro, jãa mena macʉ̃ Andrés, Simón Pedro yee wedegʉ pea, o biro cʉ̃re ĩiwi Jesús're: ");
INSERT INTO baoNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Anore niijãwi jĩcʉ̃ wimagʉ, jĩcã amo cõro niirije pan cebada mena cʉ̃ja ca tiirique, ñucã wai pʉarã ca cʉogʉ. Ate baarique paʉ bojocapʉre earicaro mani —cʉ̃re ĩiwi Andrés. ");
INSERT INTO baoNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩiwi: —Niipetirãre duwi dotiya —ĩiwi. Tii tabe pea añuro ca taa cʉtiri yepa niiwʉ, to biri ʉmʉa wado niirã jĩcã amo cõro mil niirã cõro peti niiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","To biro cʉ̃ja ca biro, Jesús pea baariquere ami, Ʉmʉreco Pacʉre, “Añu majuropeecã,” cʉ̃re ĩi nʉcʉ̃ bʉo yapano, cʉ̃ buerãre tiicojowi. Jãa pea too ca duwirã bojocare jãa bato cojowʉ. Wai cãare to birora tiiwi ñucã. To biro cʉ̃ ca tiirijere baarã, no cʉ̃ja ca baarʉgaro cõro baawa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Teere niipetirãpʉra cʉ̃ja ca baa yapi peticoaro, o biro jãare ĩiwi Jesús: —Ca dʉjarijere jee neoña, no ca booro ca bii batetipere biro ĩirã —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","To biri jãa pea jĩcã amo cõro niiricari pan ca niirique ca dʉjarijere pʉa amo peti, dʉpore pʉaga penituaro niiri pijeeri peti jãa jee jãa dadowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Bojoca pea, ca ĩa ñaaña manirije Jesús cʉ̃ ca tiirijere ĩacãri, o biro ĩiwa: —Díámacʉ̃ra ania, “Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ ati yepapʉre doorucumi,” cʉ̃ja ca ĩiricʉra niimi —ameri ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesús pea tutuaro mena ami waari, cʉ̃re cʉ̃ja ca wiogʉ jõenerʉgarijere ĩa majiri, jĩcʉ̃ra niirʉgʉ ʉ̃tãgʉ bʉaro ca emʉaricʉ jotoapʉ mʉacoawi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ca naio ñaacũmuri tabe ca niiro, jãa, Jesús buerã pea, ʉtabʉcʉrapʉ bua waari, ");
INSERT INTO baoNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","cũmuapʉ ea jãa, ʉtabʉcʉrare jãa tĩa nʉnʉa waawʉ, Capernaúm macãpʉ waarã. Mee naitĩa peticoawʉ. Jesús pea tua eatiwi ména. ");
INSERT INTO baoNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","To biro jãa ca bii tĩa waaro, bʉaro ca wino paa puuro macã, oco ca jaberije paca bii nʉnʉa doowʉ. To biro ca biiro paca jabewʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mee cinco, seis kilómetros cõro jãa ca tʉja tĩa waaro, Jesús pea jãa pʉto pee doogʉ, oco jotoara cʉ̃ ca doo nʉnʉa dooro ĩari, bʉaro jãa uwiwʉ jãa pea. ");
INSERT INTO baoNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","To biri Jesús pea o biro ĩi cojowi: —Yʉra yʉ nii. Uwiticãña —jãare ĩi cojowi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","To biro jãare cʉ̃ ca ĩiro, ʉjea niirique mena cũmuapʉ cʉ̃re jãa ea jãa dotiwʉ. Cũmuapʉ cʉ̃ ca ea jãaro jiroacãra, jãa ca waari tabepʉ jãa eacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ape rʉmʉ peere, ʉtabʉcʉra ape nʉñapʉra ca tuaricarã bojoca pea, cũmua jĩcãga ca niiricarena jãa ca tĩa waaro jãa mena Jesús cʉ̃ ca waatiriquere majicãupa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","To biro cʉ̃ja ca ĩi niiri tabere ape cũmuari, Tiberias macã pee ca doorique, Jesús cʉ̃ Pacʉre, “Jãa mena mʉ añujañu,” ĩi yapanori, baarique cʉ̃ ca jʉo baarica tabe pʉtore eaupa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","To biri Jesús, jãa cʉ̃ buerã cãa, too jãa ca maniro ĩa, tii cũmuari menara ea jãa, Capernaúm'pʉ cʉ̃re amarã doocã dooupa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Cʉ̃ja pea ʉtabʉcʉra ape nʉña tĩa ea, Jesús're bʉa eari, o biro cʉ̃re ĩi jãiñawa: —Buegʉ, ¿no cõropʉ anopʉre mʉ doojãri? —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","To biro cʉ̃ja ca ĩi jãiñaro, o biro cʉ̃jare ĩiwi Jesús: —Díámacʉ̃ mʉjare yʉ ĩi: Mʉja, yʉ ca tii bau niijãrijere mʉja ca tʉo jeeñorije jʉori méé yʉre mʉja ama, baarique mʉja ca baa yapicoajãrijere ĩima ĩirã yʉre mʉja ama. ");
INSERT INTO baoNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Baarique ca petirijerena bʉarʉgarã, popiye pade bʉañaaticãña. Baarique to birora ca niicõa niirije, caticõa niirique ca tiicojorije peere, bʉarʉgarã pee doca padeya. Tee pee nii, yʉ, Ca Nii Majuropeegʉ Macʉ̃ baarique mʉjare yʉ ca tiicojope. Ʉmʉreco Pacʉ, yʉ Pacʉ, yeri caticõa niiriquere, bojocare yʉ ca tiicojopere yʉre tiicojowi —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","To biro cʉ̃jare cʉ̃ ca ĩiro, o biro cʉ̃re ĩi jãiñawa Jesús're: —¿Ñee ʉno jãa tiigajati, Ʉmʉreco Pacʉ cʉ̃ ca dotirore biro tiirʉgarã? —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro, o biro cʉ̃jare ĩi yʉʉwi Jesús: —Ate wado nii Ʉmʉreco Pacʉ, mʉja ca tiiro cʉ̃ ca boorije. Cʉ̃ ca tiicojo cojoricʉre díámacʉ̃ mʉja ca tʉo nʉnʉjeerije wadore boomi —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","To biro cʉ̃jare cʉ̃ ca ĩiro, o biro cʉ̃re ĩi jãiñawa ñucã: —¿Teere ĩari, díámacʉ̃ mʉre jãa ca tʉo nʉnʉjeepere biro ĩigʉ, ñee ca ĩa ñaaña manirije jãare mʉ tii ĩñogʉti? ¿Dije to niiti mʉ ca tii niirije? ");
INSERT INTO baoNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Mani ñicʉ̃ jãari niiquĩricarã ca yucʉ maniri yepapʉ niirã, ʉmʉreco tutipʉ maquẽ baarique maná cʉ̃ja ca ĩirijere baaupa, Ʉmʉreco Pacʉ wederique: “Ʉmʉreco tutipʉ maquẽ baarique cʉ̃jare ecaupi,” ca ĩirore birora —cʉ̃re ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Jesús: —Díámacʉ̃ mʉjare yʉ ĩi. Moisés niiquĩricʉ méé ʉmʉreco tutipʉ maquẽ baariquere mʉjare ecaupi. Yʉ Pacʉ pee niimi baarique ca nii majuropeerije emʉaropʉ maquẽre ca tiicojogʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ʉmʉreco Pacʉ, ʉmʉreco tutipʉ maquẽ baarique cʉ̃ ca tiicojoriquere biro ca niigʉ ʉmʉreco tutipʉ ca duwi dooricʉ ati yepa macãrãre to birora caticõa niiriquere ca tiicojogʉ niimi —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","To biro cʉ̃jare cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwa: —Wiogʉ, tee wadore jãare baarique tiicojocõa niiña —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesús pea o biro cʉ̃jare ĩiwi: —Yʉra yʉ nii, baarique baa catiricarore birora catiriquere ca tiicojogʉ. To biri yʉ pʉto ca doogʉa, jĩcãti ʉno peera aʉa boa, biitirucumi. Ñucã díámacʉ̃ yʉre ca tʉo nʉnʉjeegʉa, jĩcãti ʉno peera oco jinirʉga, biitirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mee mʉjare yʉ wedejãwʉ: mʉja, yʉ ca tii niirijere ĩa pacarã, díámacʉ̃ yʉre mʉja tʉoti. ");
INSERT INTO baoNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yʉ Pacʉ yʉre cʉ̃ ca tiicojorã niipetirã yʉ pʉtore dooma; yʉ pʉto ca doorãre jĩcãti ʉno peera cʉ̃jare cõa wiene, yʉ tiitirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yʉa, ʉmʉreco tutipʉ ca niiricʉ ati yepapʉre duwi doogʉa, yʉ ca boorore biro tiigʉ doogʉ méé yʉ doowʉ. Yʉre ca tiicojo cojoricʉ yʉ Pacʉ cʉ̃ ca tii dotirije wadore tiigʉ doogʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yʉre ca tiicojo cojoricʉ yʉ Pacʉ cʉ̃ ca boorijea, yʉre cʉ̃ ca tiicojoricarãre jĩcʉ̃ ʉno peerena tii yaioricaro maniro, ca tʉjari rʉmʉ ca niiro, cʉ̃ja ca cati tuaro yʉ ca tiipe nii. ");
INSERT INTO baoNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Yʉ Pacʉ cʉ̃ ca boorijea, yʉ, cʉ̃ Macʉ̃re ca ĩa majirã niipetirã yʉ ca wederijere díámacʉ̃ tʉo nʉnʉjeeri, caticõa niirique cʉ̃ja ca bʉape nii. Yʉ pea ca tʉjari rʉmʉ ca niiro, cʉ̃ja ca cati tuaro yʉ tiirucu —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","To biro cʉ̃ ca ĩiro judíos pea, yaioroacã Jesús're wede pai niiwa “Yʉ, yʉ nii, ʉmʉreco tutipʉ maquẽ baariquere biro ca duwi dooricʉ,” cʉ̃ ca ĩirijere tʉori. ");
INSERT INTO baoNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","To biri o biro ĩiwa: —¿Ania, José macʉ̃ Jesús méé cʉ̃ niiti? Mania cʉ̃ pacʉre, cʉ̃ pacore mani maji. ¿Ñee tiigʉ “Ʉmʉreco tutipʉ ca niiricʉ yʉ duwi doowʉ,” cʉ̃ ĩiti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","To biro cʉ̃ja ca ameri ĩiro, o biro ĩiwi Jesús: —To cõrora wede pai yerijãaña. ");
INSERT INTO baoNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Yʉre ca tiicojo cojoricʉ yʉ Pacʉ, cʉ̃ yeripʉ cʉ̃ ca tʉgoeña wajoaro cʉ̃ ca tiitijata, jĩcʉ̃ ʉno peera yʉre tʉo nʉnʉjee majitimi. Cʉ̃ ca tʉgoeña wajoaro cʉ̃ ca tiirã wado yʉre tʉo nʉnʉjeema. Yʉ pea ca tʉjari rʉmʉ ca niiro, cʉ̃ja ca cati tuaro yʉ tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca owarica pũuroripʉ o biro ĩi: “Niipetirãre wede majiorucumi Ʉmʉreco Pacʉ,” ĩi. To biri yʉ Pacʉ wederiquere tʉo, cʉ̃ yee maquẽre maji, ca tiirã niipetirã, yʉ pʉto dooma. ");
INSERT INTO baoNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Biigʉpʉa yʉ Pacʉre ca ĩaricarã jĩcãrã niima ĩigʉ méé yʉ ĩi. Yʉ, cʉ̃ mena ca nii jʉo dooricʉ wado cʉ̃re ca ĩaricʉ yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yee méé mʉjare yʉ ĩi: Díámacʉ̃ yʉre ca tʉo nʉnʉjeerã, to birora caticõa niiriquere cʉo yerijãama. ");
INSERT INTO baoNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yʉ yʉ nii, baariquere baa catiricarore birora catiriquere ca tiicojogʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mʉja ñicʉ̃ jãa niiquĩricarã, ca yucʉ maniri yepapʉ niirã, baarique maná cʉ̃ja ca ĩirijere baaquĩupa. Teere ca baaricarã nii pacarã, bii yaicoaquĩupa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Yʉ pea, baarique ʉmʉreco tutipʉ ca duwi doorijere yʉ wede. Teere ca baarã, to birora caticõa niirucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yʉ yʉ nii, baarique ca catirije ʉmʉreco tutipʉ ca duwi doorique ca niigʉ. Tee baariquere ca baagʉa, to birora caticõa niirucumi. Baarique yʉ ca tiicojope pea yʉ upʉrira nii. Ati yepa macãrã cʉ̃ja ca caticõa niipere biro ĩigʉ, cʉ̃jare yʉ bii yai bojarucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","To biro cʉ̃ ca ĩiro tʉorã, judíos pea cʉ̃ja majurope o biro ameri ĩi tutiwa: —¿Ania, do biro tiicãri, cʉ̃ upʉrirena manire cʉ̃ baa dotigʉti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","To biro cʉ̃ja ca ameri ĩiro, cʉ̃ ca bii yaipepʉre tʉgoeñari, o biro cʉ̃jare ĩiwi Jesús: —Díámacʉ̃ mʉjare yʉ ĩi: Yʉ, Ca Nii Majuropeegʉ Macʉ̃ dííre baa, ñucã yʉ díire jini, mʉja ca tiitijata, caticõa niiriquere mʉja cʉoti. ");
INSERT INTO baoNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yʉ dííre baa, ñucã yʉ díi cãare jini, ca tiigʉa, to birora caticõa niiriquere cʉo yerijãami. Yʉ pea, ca tʉjari rʉmʉ ca niiro cʉ̃ ca cati tuaro yʉ tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Yʉ díía, baarique ca nii majuropeerije nii. Ñucã yʉ díi cãa, jinirique ca nii majuropeerije nii. ");
INSERT INTO baoNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","To biri yʉ dííre baa, yʉ díi cãare jini, ca tiigʉa, yʉ mena cati niimi. Yʉ pee cãa, cʉ̃ mena yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Yʉ Pacʉ, to birora ca caticõa niigʉ yʉre cʉ̃ ca tiicojo cojoricarore birora, yʉ cãa cʉ̃ jʉori yʉ ca caticõa niirore birora, yʉ dííre ca baagʉ cãa, yʉ jʉorira caticõa niirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ate baarique ʉmʉreco tutipʉ ca duwi dooriquere yʉ wede. Ate baarique pea mʉja ñicʉ̃ jãari niiquĩricarã cʉ̃ja ca baarique manáre biro biiti. Teere ca baaricarã nii pacarã, bii yaicoaquĩupa. Baarique ʉmʉreco tutipʉ ca duwi dooriquere ca baarã pee doca, to birora caticõa niirucuma —cʉ̃jare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ate niipetirijere nea poo juu buerica wii, Capernaúm macã macã wiipʉre cʉ̃jare wede majiowi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","O biro cʉ̃ ca ĩi wederijere tʉorã, paʉ Jesús're ca tʉo nʉnʉjeemiricarã o biro ameri ĩiwa: —Ate cʉ̃ ca buerijea do biro ca tii majiña manirije peti niicã. Ñiru pee teere tii nʉnʉjee majiricaro manimi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","To biro cʉ̃ja ca ĩi wede pairijere majiri, Jesús pea o biro cʉ̃jare ĩi jãiñawi: —¿Atera mʉjare to ajienecãti? ");
INSERT INTO baoNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Do biro to biibogajati, to docare yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ ca nii jʉorica tabepʉra yʉ ca tua mʉa waaro mʉja ca ĩajata? ");
INSERT INTO baoNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Yeri jãñarique pee nii, cati niiriquere ca tiicojorije. Mani upʉria, yeri jãñarique to ca manijata, wapa mani. Mʉjare yʉ ca ĩijãrijea, yeri jãñarique, catirique, niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","To ca bii pacaro, jĩcãrã mʉja mena macãrã díámacʉ̃ ca tʉo nʉnʉjeetirã niicãma ména —ĩiwi. Mee Jesús pea, jĩcãtopʉra, díámacʉ̃ cʉ̃re ca tʉo nʉnʉjeetirãre, ñucã cʉ̃re ca wedejãa buiyee cõapʉ cãare, maji yerijãaupi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","To biri o biro cʉ̃jare ĩi nemowi ñucã: —Aterena ĩigʉ, “Yʉ Pacʉ cʉ̃ ca tiicojotigʉa jĩcʉ̃ ʉno peera yʉ pʉto doo majitimi,” mʉjare yʉ ĩi wedejãwʉ —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Tii tabe mena paʉ bojoca Jesús're ca nʉnʉmiricarã, cʉ̃re waa weo, cʉ̃re bapa cʉti waa yujuticãwa yua. ");
INSERT INTO baoNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","To biro cʉ̃ja ca biiro ĩa, Jesús pea, jãa cʉ̃ buerãre o biro ĩi jãiñawi: —¿Mʉja cãa yʉre mʉja waa weocoarʉgati? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","To biro cʉ̃ ca ĩiro, Simón Pedro pea o biro cʉ̃re ĩi yʉʉwi: —Wiogʉ, ¿noa mena pee jãa waabogajati? Mʉ jĩcʉ̃ra mʉ nii, to birora caticõa niirique maquẽre ca wedegʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Jãa, mee mʉ ca wederijere díámacʉ̃ jãa tʉo nʉnʉjeewʉ. Mʉa, Ʉmʉreco Pacʉ yʉʉ Ca Ñañarije Manigʉ mʉ ca niirijere jãa maji —ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","To biro cʉ̃ ca ĩiro, Jesús pea o biro jãare ĩi yʉʉwi: —¿Yʉa, pʉa amo peti, dʉpore pʉaga penituaro niirã mʉjare yʉ beje jeetiri? To biro yʉ ca tiiricarã mʉja ca nii pacaro, jĩcʉ̃ mʉja mena macʉ̃ Satanás'ra niicãmi —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Atere o biro cʉ̃ ca ĩijata, Simón Iscariote macʉ̃ Judas're ĩigʉ ĩiwi Jesús. Judas pea jãa mena macʉ̃ nii pacagʉ, Jesús're ca wedejãa buiyee cõapʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ate jiro Galilea yepa pee waa yujuwi Jesús. Judea yepapera niirʉgatiwi, too macãrã judíos ʉparã cʉ̃re jĩarʉgarã cʉ̃ja ca ama niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judíos yaa boje rʉmʉ, yucʉ dʉpʉri mena wiijeriacã cʉ̃ja quenori boje rʉmʉ ea nʉnʉa dooro ca biiro, ");
INSERT INTO baoNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","cʉ̃ bairã pea o biro cʉ̃re ĩiwa Jesús're: —Anore tuaticãña. Waagʉja Judea yepapʉ, too macãrã mʉre ca tʉo nʉnʉjeerã cãa, mʉ ca tii niirijere cʉ̃ja ca ĩapere biiro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Manire cʉ̃ja ca majiro boogʉa, apeye ʉnore yaioropʉ tiiya mani. Anore atere mʉ ca tiirore birora toopʉ cãare niipetirã cʉ̃ja ca ĩa cojoro, ca ĩa ñaaña manirije mʉ ca tii bau niirijere cʉ̃jare tii ĩñogʉja —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Cʉ̃ bairã peti cãa, cʉ̃re tʉo nʉnʉjeeticãwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","To biri Jesús pea o biro cʉ̃jare ĩiwi: —Yʉra toopʉ yʉ ca waapa rʉmʉ eati ména. Mʉjara no ca boori rʉmʉ mʉja ca waajata cãare añujañu. ");
INSERT INTO baoNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Mʉjara, ati yepa macãrã Ʉmʉreco Pacʉre ca tʉo nʉnʉjeetirã mʉjare ĩa tutitima. Yʉra ĩa tuti jañuma, cʉ̃ja ca tii niirije ñañarije ca niirijere, “Ñañarije nii” cʉ̃jare yʉ ca ĩi bau niirije jʉori. ");
INSERT INTO baoNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mʉja tii boje rʉmʉre waarãja. Yʉa, yʉ waati, yʉ Pacʉ yʉ ca biipere cʉ̃ ca cũurica tabe eati ména —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","To biro cʉ̃jare ĩi, Galileapʉra tuacãwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","To biro ĩi pacagʉ, cʉ̃ bairã cʉ̃ja ca waaricaro jiro, cʉ̃ cãa tii boje rʉmʉre waawi. Toopʉre bau niiro biitigʉra, yaioro biicã yujuwi. ");
INSERT INTO baoNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tii boje rʉmʉre judíos ʉparã pea cʉ̃re amarã: —¿Õo ca niigʉa noopʉ cʉ̃ niigajati? —ameri ĩi yujuupa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ména too peera bojoca pea, Jesús cʉ̃ ca tiirijere ca ĩaricarã, bʉaro ameri wede peni niiupa. Jĩcãrã, o biro ĩiupa: “Ca bojoca añugʉ niiwi,” ĩiupa. Aperã pea: “Añutimi. Cʉ̃ ca buerije mena bojocare ĩi ditomi,” ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Biirãpʉa, to biro ĩi pacarã, judíos ʉparãre uwima ĩirã cʉ̃ yee maquẽre bau niiro ameri wedetiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","To biri Jesús pea cʉ̃ja ca boje rʉmʉ tii decomacã cʉti waari tabepʉ, Ʉmʉreco Pacʉ yaa wiipʉ jãa waari, bojocare wede majio jʉo waawi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","To biro cʉ̃ ca ĩirijere tʉorã, judíos ʉparã pea do biro pee ĩi majiticã, o biro ameri ĩiwa: —¿Ania ca buetiricʉ nii pacagʉ, do biro pee biicãri to cõro paʉ cʉ̃ majiti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Mʉjare yʉ ca buerijea yʉ yee méé nii. Yʉre ca tiicojo cojoricʉ yee niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Jĩcʉ̃, Ʉmʉreco Pacʉ cʉ̃ ca boorore biro ca tiirʉgʉ ca niigʉ ʉnoa, yʉ ca buerijere: “Ʉmʉreco Pacʉ yeera nii,” ĩi maji, ñucã, “Biiti, cʉ̃ majurope cʉ̃ ca booro cʉ̃ ca wederije nii,” ĩi tʉo majirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Cʉ̃ ca boori wãme ca wedegʉa, bojoca cʉ̃re cʉ̃ja ca ĩi nʉcʉ̃ bʉorijere amagʉ ĩimi. Cʉ̃re ca tiicojo cojoricʉpʉre cʉ̃ja ca ĩi nʉcʉ̃ bʉorijere ca boojãgʉa, díámacʉ̃ wedemi, dije ʉno peera cʉ̃ ca wederije watoara cʉ̃ ca ĩirije mani. ");
INSERT INTO baoNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Doti cũuriquere Moisés niiquĩricʉ méé mʉjare cʉ̃ cũuquĩupari? Mʉjarena cʉ̃ ca cũu pacaro, jĩcʉ̃ ʉno peera doti cũurique ca ĩirore biro mʉja tii nʉnʉjeeti. To biro ca biirã nii pacarã, ¿ñee tiirã yʉre mʉja jĩarʉgati? —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","To biro cʉ̃ ca ĩiro tʉorã: —¿Noa mʉre cʉ̃ja jĩarʉgati yee? ¡To docare ca wãtĩ jãa ecoricʉ mʉ niicu! —cʉ̃re boca ĩi yʉʉwa bojoca pea. ");
INSERT INTO baoNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩiwi: —Mʉja niipetirãpʉra, jĩcãatiacã yerijãarica rʉmʉ ca niirore, ca diarique cʉtigʉre yʉ ca catioriquerena mʉja ĩa ʉcʉa wede paicã maniwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moisés niiquĩricʉ, jeyua quejero yapa wide taariquere mʉjare tii dotiupi. Biiropʉa, tee pea Moisés niiquĩricʉ cʉ̃ ca tii doti cũuparo jʉgueropʉra mʉja ñicʉ̃a niiquĩricarãpʉra teere tii jʉo dooquĩupa. Mʉja pea, “Teere tii nʉnʉjeerã jãa tii,” ĩirã, yerijãarica rʉmʉrena wimagʉre cʉ̃ jeyua quejero yapare mʉja wide taarucu. ");
INSERT INTO baoNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","To biri, Moisés niiquĩricʉ cʉ̃ ca doti cũuquĩriquere “Jãa bii ametʉene nʉcãre” ĩirã, yerijãarica rʉmʉrena mʉja puna jeyua quejeri yaparire ca wide taarã nii pacarã ¿ñee tiirã mʉja pea ca diarique cʉtigʉre yerijãarica rʉmʉ ca niiro yʉ ca catioriquerena, yʉ mena mʉja ajiacãti? ");
INSERT INTO baoNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mʉja, añuro tʉgoeñatirãra, bau niiro ca biirijerena ĩari, “To biirije mʉja biirique cʉti,” ĩi ĩa bejeticãña. Mʉja ca ĩa bejerʉgajata, añuro díámacʉ̃ tʉgoeñari ca niirore biro ĩa bejeya —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","To biro cʉ̃ ca ĩi niiro, jĩcãrã Jerusalén macãrã o biro ameri ĩiwa Jesús're ĩacãri: —¿Ania, jĩa cõarʉgarã cʉ̃ja ca amarucujãgʉ méé cʉ̃ niiti? ");
INSERT INTO baoNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ĩira, niipetirã cʉ̃ja ca tʉo cojoro wede niimi doca. To biro cʉ̃ ca bii pacaro, jĩcʉ̃ ʉno peera jĩcã wãme ʉnora cʉ̃re ĩirucu tiitima. ¿Bojocare ca jʉo niirãpʉra, “Ania díámacʉ̃ra Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ Mesías niimi,” cʉ̃re cʉ̃ja ĩi tʉgoeña nʉcʉ̃ bʉocãbutiqué? ");
INSERT INTO baoNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mee, mania anira, too macʉ̃ cʉ̃ ca niirijere mani maji. Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojogʉ Mesías peti cʉ̃ ca doojata docare, jĩcʉ̃ ʉno peera: “Too macʉ̃ niimi” cʉ̃re ĩi majitirucuma —ameri ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Teere tʉori, Jesús pea Ʉmʉreco Pacʉ yaa wiipʉra ca bue niigʉ niiri, tutuaro o biro ĩi wedewi: —¿To docare mʉja yʉre maji, tii macã macʉ̃ yʉ ca niirijere maji, mʉja biiti cã́jí? Yʉa yʉ ca boorora doogʉ méé yʉ biiwʉ. Jĩcʉ̃ mʉja ca majitigʉ “Yee méé ĩimi,” ĩi tʉo nʉnʉjeericʉ ʉnora ca niigʉ cʉ̃ ca doti cojoro yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yʉ doca, cʉ̃ mena ca nii jʉo dooricʉ niiri cʉ̃re yʉ maji, cʉ̃ra anopʉre yʉre tiicojo cojowi —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","To biro cʉ̃ ca ĩirijere tʉo ajiari, jĩcãto cʉ̃re ñeerʉgamiwa. To biro tiirʉga pacarã, ména cʉ̃ ca bii yaipa tabe ca eatiro macã cʉ̃re ñee majitiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Biirãpʉa, paʉ bojoca cʉ̃re tʉo nʉnʉjee, o biro ameri ĩiwa: —Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojogʉ Mesías, ati yepapʉre doogʉ, ¿ani Jesús, ca ĩa ñaaña manirije cʉ̃ ca tii bau nii ĩñorije ametʉenero cʉ̃ tiigʉti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","To biri fariseos pea, to biirije Jesús're bojoca cʉ̃ja ca ĩi nʉcʉ̃ bʉorijere tʉori, paia ʉparã mena Ʉmʉreco Pacʉ yaa wiire ca coterã uwamarãre tiicojoupa, Jesús're ñee doti cojorã. ");
INSERT INTO baoNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesús pea o biro cʉ̃jare ĩiwi: —Mʉja menare yoaro yʉ niitirucu. Jiro, yʉre ca tiicojo cojoricʉ pʉtopʉra yʉ tuacoarucu ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yʉre mʉja amamirucu. Yʉre ama pacarã, yʉre mʉja bʉatirucu, yʉ ca niiri tabepʉre ca ea waa majitirã niiri —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","To biro cʉ̃ ca ĩiro, judíos pea o biro ameri ĩi jãiñawa: —¿Ania, cʉ̃re mani ca bʉatipa tabepʉra, noopʉ cʉ̃ waarʉgabuti? ¿Mani yaarã judíos ape yepari ca waa batericarã pʉtopʉre, ñucã Ʉmʉreco Pacʉre ca majitirãpʉre, wede yujugʉ waagʉ cʉ̃ biigajati? ");
INSERT INTO baoNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Do biro ĩirʉgʉ, “Yʉre mʉja amamirucu. Yʉre ama pacarã, yʉre mʉja bʉatirucu, yʉ ca niiri tabepʉre ca ea waa majitirã niiri,” manire cʉ̃ ĩijapari? —ameri ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Boje rʉmʉ ca nii tʉjari rʉmʉ, ca nii majuropeeri rʉmʉ niiwʉ. Tii rʉmʉre Jesús pea wãmʉ nʉcãri, tutuaro o biro ĩi wedewi: —Jĩcʉ̃ ʉno cʉ̃ ca oco jinirʉgajata, yʉ pʉto doori cʉ̃ oco jinijato. ");
INSERT INTO baoNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ʉmʉreco Pacʉ wederique ca ĩirore birora, díámacʉ̃ yʉre ca tʉo nʉnʉjeegʉra, oco, catirique ca tiicojorije diari to birora oco ca ũmaa yuucõa niirore birora cʉ̃re biirucu cʉ̃ yeripʉre —cʉ̃jare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Atere Jesús to biro cʉ̃ ca ĩijata: Díámacʉ̃ cʉ̃re ca tʉo nʉnʉjeerã, Añuri Yerire cʉ̃ja ca ñeepere ĩigʉ ĩiupi. Añuri Yeri pea bojoca yeripʉre ñaajãa eatiwi ména, Jesús, cʉ̃ Pacʉ pʉtopʉ cʉ̃ ca tua mʉa waatirije ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","To biro Jesús cʉ̃ ca ĩirijere tʉorã, niiwa jĩcãrã bojoca watoare o biro ca ĩirã: —Díámacʉ̃ra ania Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ peti niimi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","To biro cʉ̃ja ca ĩiri tabere, aperã pea o biro ĩiwa: —Ania Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ Mesías peti niimi —ĩiwa. Ñucã aperã pea o biro ĩiwa: —Cʉ̃ méé niimi. Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojogʉ Mesías cʉ̃ ca niijata, Galilea yepa macʉ̃ niitibocumi. ");
INSERT INTO baoNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ʉmʉreco Pacʉ wederiquea, “Mesías, wiogʉ David niiquĩricʉ pãrami, ñucã David niiquĩricʉ yaa macã Belén macʉ̃, niirucumi,” ĩi doca —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","To biro ĩirãra, bojoca pea Jesús yee jʉori ameri dica waticoawa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","To biro biima ĩirã, cʉ̃re ami waari cʉ̃re tia cũurʉgamiwa. To biro cʉ̃re tiirʉga pacarã jĩcʉ̃ ʉno peera cʉ̃re ami waatiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ʉmʉreco Pacʉ yaa wiire coteri maja uwamarã pea, fariseos, to biri paia ʉparã, cʉ̃ja ca niiropʉ tuacoaupa. Cʉ̃ja pea o biro cʉ̃jare ĩi jãiñaupa: —¿Ñee tiirã cʉ̃re mʉja ami dootijãri? —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","To biro cʉ̃ja ca ĩiro, uwamarã pea o biro cʉ̃jare ĩi yʉʉupa: —Jĩcʉ̃ ʉno peera cʉ̃re biro wede ñaatimi —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","To biro cʉ̃ja ca ĩiro, fariseos pea o biro cʉ̃jare ĩiupa ñucã: —¿Mʉja cãa ñucã, mʉja menara cʉ̃re mʉja ĩi dito ecocoajãri? ");
INSERT INTO baoNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿To docare mʉjara, manire ca jʉo niirã, ñucã fariseos cãa, díámacʉ̃ cʉ̃re ca tʉo nʉnʉjeerã cʉ̃ja niiti? ");
INSERT INTO baoNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Anija bojoca doti cũuquĩriquere ca majitirã, bʉena, Ʉmʉreco Pacʉ ñañaro cʉ̃ ca tiiparã peti niirã biima —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","To biro cʉ̃ja ca ĩiro, fariseos mena macʉ̃ Nicodemo, jĩcãti Jesús're ca wede penigʉ earicʉ pea, o biro cʉ̃jare ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—¿To docare manire ca dotirijea, jĩcʉ̃ bojocʉre, cʉ̃ ca ĩirijere tʉo jʉoti, ñañarije cʉ̃ ca tiiriquere añuro majiti, bii pacarã, ñañaro to tii doticãti? —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Cʉ̃ja pea to biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupa: —¿Mʉ cãa Galilea macʉ̃ra mʉ niicãtimiti? Ʉmʉreco Pacʉ wederiquere cʉ̃ja ca owarica pũuropʉre bueñaaqué jĩcãti ʉno peera Galilea macʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ nii ñaatiupi —cʉ̃re ĩi tutiupa Nicodemore. ");
INSERT INTO baoNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","To biro ĩi, cʉ̃ja ca niiro cõro cʉ̃ja yaa wiijeripʉ tuacoaupa yua. ");
INSERT INTO baoNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesús pea ʉ̃tãgʉ, Olivos yucʉ ca niiri buuro pee waacoawi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ape rʉmʉ boeri tabe, Ʉmʉreco Pacʉ yaa wiipʉ waawi ñucã Jesús. Tii wiipʉre paʉ bojoca cʉ̃ pʉto cʉ̃ja ca nea pooro ĩari, jĩcã tabepʉ ea nuu waa, cʉ̃jare bue jʉo waawi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Cʉ̃jare cʉ̃ ca bue niiri tabera, Moisés cʉ̃ ca doti cũuriquere ca jʉo buerã, to biri fariseos, jĩcõ nomio apĩ mena ca tii niigore cʉ̃ja ca bʉa earicore ami doori, too ca niirã niipetirã watoapʉ cõre nʉcõri, Jesús're o biro cʉ̃re ĩiwa: ");
INSERT INTO baoNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—Buegʉ, atiore, cõ manʉ mena mééra cõ ca tii niiri tabera cõre jãa bʉa eajãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Doti cũuriquepʉ, Moisés, atiore biro ca tiirãra, “Ʉ̃tã mena dee jĩa cõacãña,” manire ĩi cũuupi. ¿Mʉa do biro mʉ ĩiti teere? —cʉ̃re ĩi jãiñawa. ");
INSERT INTO baoNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","“No ca boori wãme manire cʉ̃ ca yʉʉro, mani ʉparãpʉre cʉ̃re mani wedejãajaco,” ĩi tʉgoeñarique mena atere to biro cʉ̃re ĩi jãiñawa Jesús're. To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro, Jesús pea muu bia ea nuu waa, cʉ̃ amo jũa mena yepapʉ owa jʉo waawi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Bʉaro jañuro cʉ̃re cʉ̃ja ca jãiña nʉnʉa waaro macã, muu biari ca owa duwiricʉ wãmʉ nʉcã: —Mʉja mena macʉ̃ ñañarije ca tiitigʉ, ʉ̃tãga amiri, cõre cʉ̃ dee jʉojato —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","To biro cʉ̃jare ĩi, muu bia nuu waari yepapʉra owacã nʉnʉa waawi ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","To biro cʉ̃jare cʉ̃ ca ĩiro, ñañarije ca tiirã cʉ̃ja ca niirijere tʉgoeña majiri, jĩcʉ̃ri, jĩcʉ̃ri waa batecã jʉo waawa. Bʉcʉrã waa bate jʉo waa, waa peticoawa. To biro cʉ̃ja ca bii weogʉ Jesús pea, fariseos cʉ̃ja ca ami doorico nomio mena jĩcʉ̃ra tuacãwi yua. ");
INSERT INTO baoNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Wãmʉ nʉcã, nomio jĩcõra cõ ca nucũro ĩa, o biro cõre ĩi jãiñawi Jesús: —¿Nomio, mʉre ca wedejãajãrã pea noo cʉ̃ja waati? ¿Jĩcʉ̃ ʉno peera ʉ̃tã mena mʉre cʉ̃ dee jĩatijãri? —cõre ĩi jãiñawi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","To biro cõre cʉ̃ ca ĩiro: —Jĩcʉ̃ peera yʉre dee jĩatima —cʉ̃re ĩi yʉʉwo cõ pea. To biro cõ ca ĩiro Jesús pea o biro cõre ĩiwi: —Yʉ cãa ñañaro mʉre yʉ tiiticu. Tua waagoja. Jiro ñañarije tii nemoticãña yua —cõre ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jiro ñucã Jesús, bojocare o biro cʉ̃jare ĩi wedewi: —Yʉ yʉ nii, ati yepa macãrãre ca jĩa boegʉ. Yʉre ca tʉo nʉnʉjeegʉ, catirique ca tiicojorije ca boerijere cʉorucumi. To biro biigʉ, jĩcãti ʉno peera ca naitĩari tabepʉre niigʉre biro biitirucumi —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwa fariseos pea: —Mʉa, mʉ majuropeera mʉ yee maquẽre wedegʉ mʉ tii. To biro mʉ ca ĩirije wapa mani —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","To biro cʉ̃re cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Yʉ majuropeera yʉ yee maquẽre yʉ ca wedemijata cãare, yʉ yee maquẽre yʉ ca wederijea díámacʉ̃ nii. Yʉa, “Toopʉ yʉ doowʉ, ñucã ‘Toopʉ waagʉ yʉ bii,’ ” yʉ ĩi maji. Mʉja pea atere mʉja majiti. ");
INSERT INTO baoNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mʉja, bojoca cʉ̃ja ca tiiri wãme mʉja ĩa bejerique cʉti. Yʉa jĩcʉ̃ ʉno peerena yʉ ĩa bejeti. ");
INSERT INTO baoNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Yʉ ca ĩa bejejata, yʉ ca ĩa bejerijea díámacʉ̃ nii, yʉ jĩcʉ̃ra yʉ ca ĩa bejetirije ca niiro macã. Yʉ Pacʉ yʉre ca tiicojo cojoricʉ cãa yʉ mena ĩa bejemi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mʉjare ca dotirije, o biro ĩi owa tuurique nii: “Pʉarã ca ĩaricarã, ca ĩi jʉoricʉ cʉ̃ ca wedericarore birora cʉ̃ jiro macʉ̃ cãa cʉ̃ ca wedejata, cʉ̃ja ca ĩirije wapa cʉti,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yʉa, yʉ majuropeera yʉ yee maquẽre ca wedegʉ yʉ nii. Apĩ yʉ yee maquẽre ca wedegʉa, yʉ Pacʉ yʉre ca tiicojo cojoricʉ niimi —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","To biro cʉ̃jare cʉ̃ ca ĩiro: —¿Too docare mʉ pacʉ noopʉ cʉ̃ niiti? —cʉ̃re ĩi jãiñawa. To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Mʉja, yʉre mʉja majiti, to biri yʉ Pacʉ docare ametʉenero cʉ̃re mʉja majiticu. Yʉre mʉja ca majijata, yʉ Pacʉ cãare mʉja majibocu —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ʉmʉreco Pacʉ yaa wiipʉ, wapa tiirica tiiri jãarica cũmuari pʉto bojocare bue niigʉ atere to biro ĩiwi Jesús. Biirãpʉa, jĩcʉ̃ ʉno peera Jesús're ñee, tiitiwa, ména cʉ̃ ca bii yaipa tabe ca eatiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","To biro cʉ̃jare ĩi yapano, o biro ĩi nemowi ñucã Jesús: —Yʉa waagʉ yʉ bii. Yʉre mʉja amamirucu. Yʉre ama pacarã, mʉja ca ñañarijere acobo ecoya manirãra mʉja bii yaicãrucu. Yʉ ca waari tabepʉre mʉja waa majiti mʉja —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","To biro cʉ̃jare cʉ̃ ca ĩiro, judíos ʉparã pea o biro ameri ĩiwa: —“Yʉ ca waari tabepʉre mʉja waa majiti,” cʉ̃ ca ĩijata, ¿cʉ̃ majuropeera jĩa yairʉgʉ cʉ̃ ĩibuti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","To biro cʉ̃ja ca ĩiro Jesús pea o biro cʉ̃jare ĩiwi: —Mʉja, ano, doca macãrã mʉja nii. Yʉa emʉaropʉ macʉ̃ yʉ nii. Mʉja ati yepa macãrã mʉja nii. Yʉa ati yepa macʉ̃ méé yʉ nii. ");
INSERT INTO baoNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","To biri, “Mʉja ca ñañarijere acobo ecoya manirãra, mʉja bii yaicãrucu,” mʉjare yʉ ĩijãwʉ. To birora ca niicõa niigʉ, “Yʉ, yʉ nii,” ca ĩigʉre yʉre díámacʉ̃ mʉja ca tʉo nʉnʉjeetijata, mʉja ca ñañarije menara mʉja bii yaicãrucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","To cõrora o biro cʉ̃re ĩi jãiñawa: —¿Mʉa ñiru ʉno peti mʉ niiti? —ĩiwa Jesús're. To biro cʉ̃re cʉ̃ja ca ĩi jãiñaro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Mʉjare bue jʉogʉpʉra, “Cʉ̃, yʉ nii,” mʉjare yʉ ĩimiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mʉja yee maquẽre wede, ĩa beje, yʉ ca tiipe paʉ niicã biiropʉa. To ca bii pacaro yʉre ca tiicojoricʉ pea, díámacʉ̃ ca ĩigʉ niimi. Ati yepa macãrãre yʉ ca wederijera, cʉ̃ ca ĩiro yʉ ca tʉoriquerena cʉ̃jare yʉ wede —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Cʉ̃ Pacʉ yeere cʉ̃jare wedegʉ cʉ̃ ca ĩirijerena tʉo majiticãwa cʉ̃ja pea. ");
INSERT INTO baoNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","To biri o biro cʉ̃jare ĩiwi Jesús: —Yʉ, Ca Nii Majuropeegʉ Macʉ̃re, yucʉ tenipʉ paa pua tuu ami mʉene nʉcõrãpʉ, to birora ca niicõa niigʉ, yʉ, yʉ ca niirijere, ñucã yʉ, yʉ ca boorore biro tiitigʉra, yʉ Pacʉ, yʉre cʉ̃ ca wede majiorique wadore yʉ ca wederijere, mʉja ĩa majirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Yʉ Pacʉ yʉre ca tiicojoricʉ yʉ menara niicõa niimi. Yʉ Pacʉa, jĩcʉ̃ra yʉre cũutimi, cʉ̃ ca ĩa ʉjea niirije wado yʉ ca tiiro macã —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Atere Jesús cʉ̃ ca ĩiro, paʉ bojoca cʉ̃re tʉo nʉnʉjeewa. ");
INSERT INTO baoNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jiro o biro ĩiwi Jesús, cʉ̃re ca tʉo nʉnʉjeericarã judíos're: —Yʉ ca wederijere to birora mʉja ca tʉo nʉnʉjeecõa niijata, díámacʉ̃ra yʉ buerã peti mʉja niirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Díámacʉ̃ maquẽre mʉja majirucu. Díámacʉ̃ maquẽra, aperãre ca pade coterãre biro mʉja ca niimiriquere, mʉja ca witiro tiirucu —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","To biro cʉ̃ ca ĩiro, cʉ̃ja pea o biro cʉ̃re ĩi yʉʉwa: —Jãa, Abraham pãramerã jãa nii. Jĩcãti ʉnora, jĩcʉ̃ ʉno peerena ca pade coterã jãa nii ñaati. ¿Ñee tiigʉ mʉ pea, “Ca pade coterã méé mʉja niirucu yua,” jãare mʉ ĩiti? —ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩiwi Jesús: —Díámacʉ̃ mʉjare yʉ ĩi: Niipetirã bojoca ñañarije ca tiirã, ñañarije tiiriquere ca pade cote yai waarã niirã biima. ");
INSERT INTO baoNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pade coteri majʉa, cʉ̃ ca pade cotegʉ menara niicõa niitimi. Cʉ̃ja macʉ̃ díámacʉ̃ wado, cʉ̃ pacʉa mena to birora cʉ̃ja mena niicõa niimi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","To biri yʉ, Ʉmʉreco Pacʉ Macʉ̃, pade coteri majare biro mʉja ca niirijere yʉ ca ametʉene bojajata, díámacʉ̃ra pade coteri maja mʉja niiticãrucu. ");
INSERT INTO baoNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yʉa, Abraham pãramerã mʉja ca niirijera yʉ maji mee. Cʉ̃ pãramerã nii pacarã, yʉ ca wederijere bootima ĩirã, yʉre mʉja jĩarʉga cote. ");
INSERT INTO baoNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yʉa yʉ Pacʉ yʉre cʉ̃ ca ĩñoriquere mʉjare yʉ wede. Mʉja cãa, mʉja pacʉ cʉ̃ ca ĩirijere mʉja ca tʉoriquere mʉja tii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Cʉ̃ja pea o biro cʉ̃re ĩi yʉʉwa: —Jãa pacʉa Abraham niimi —ĩiwa. To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Jesús pea: —Abraham punaa peti mʉja ca niijata, cʉ̃ ca tii niiquĩricarore birora mʉja tii niibocu doca. ");
INSERT INTO baoNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ʉmʉreco Pacʉ yʉre cʉ̃ ca wederiquere, díámacʉ̃ ca niirijere mʉjare yʉ ca wede pacaro, mʉja pea yʉre mʉja jĩacãrʉga. ¡Abraham, jĩcãti ʉno peera o biirije tiitiquĩupi! ");
INSERT INTO baoNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mʉja ca tii niirijea mʉja pacʉ cʉ̃ ca tiirore biro mʉja ca tiirije nii —cʉ̃jare ĩiwi Jesús. To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwa ñucã: —Jãa, cʉ̃ja ca puna jãa batericarã méé jãa nii. Jĩcʉ̃ra ca Pacʉ cʉtirã jãa nii, Ʉmʉreco Pacʉ wadore —ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Díámacʉ̃ra, Ʉmʉreco Pacʉra mʉja pacʉ cʉ̃ ca niijata, yʉ cãare mʉja maibocu doca. Yʉa, Ʉmʉreco Pacʉ pʉto ca dooricʉra yʉ nii anora. Yʉ majuropeera doogʉ méé yʉ biiwʉ. Ʉmʉreco Pacʉ yʉre cʉ̃ ca tiicojoro macã yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ñee tiirã, yʉ ca wederijere mʉja tʉo jeeño majititi? Mʉjare yʉ ca wederijere tʉo junama ĩirã, to biro mʉja bii. ");
INSERT INTO baoNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mʉja pacʉa Satanás niimi. Cʉ̃ yaarã mʉja nii mʉja. To biri mʉjare cʉ̃ ca tii dotirijere mʉja tiirʉgarucu. Cʉ̃a, jĩcãtopʉra ca añutigʉ, bojocare ca jĩagʉ, nii jʉo dooupi. Díámacʉ̃ ca niirije ca ĩirore biro tii nʉnʉjeecõa nii, jĩcãti ʉno peera díámacʉ̃ ĩi, ca ĩigʉ méé niimi cʉ̃a. Cʉ̃ ca ĩi ditojata, cʉ̃ ca niirique cʉtirijerena ĩigʉ tiimi, ca ĩi ditorique paigʉ, ĩi ditorique pacʉ, niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Yʉ pea, díámacʉ̃ yʉ ca ĩirije to ca niiro macã, yʉ ca ĩirije peera díámacʉ̃ mʉja tʉorʉgati. ");
INSERT INTO baoNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿To biri mʉja mena macʉ̃ niipe, “Ati wãme ñañarije mʉ tiiwʉ,” yʉre cʉ̃ ĩi majiti? Díámacʉ̃ yʉ ca wedemijata cãare, ¿ñee tiirã díámacʉ̃ yʉre mʉja tʉotiti? ");
INSERT INTO baoNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ʉmʉreco Pacʉ yʉʉ ca niigʉa, Ʉmʉreco Pacʉ cʉ̃ ca wederijere tʉomi. Mʉja, Ʉmʉreco Pacʉ yaarã méé niiri, Ʉmʉreco Pacʉ yeere mʉja tʉorʉgati —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","To biro cʉ̃ ca ĩiro, judíos ʉparã pea o biro cʉ̃re ĩiwa: —“Mʉa Samaria macʉ̃ mʉ nii; ñucã ca wãtĩ jãa ecoricʉ mʉ nii,” mʉre jãa ca ĩijata, díámacʉ̃ra ĩirã jãa tii —cʉ̃re ĩi tutiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","To biro cʉ̃re cʉ̃ja ca ĩiro Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Yʉa ca wãtĩ jãa ecoricʉ méé yʉ nii. Yʉa, yʉ Pacʉre tii nʉcʉ̃ bʉorique wado yʉ tii. Mʉja pea yʉre mʉja nʉcʉ̃ bʉoti. ");
INSERT INTO baoNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yʉa, yʉ majuropeera nʉcʉ̃ bʉorique ʉnore yʉ amaati. Biigʉpʉa niimi jĩcʉ̃, yʉre cʉ̃ja ca ĩi nʉcʉ̃ bʉorijere ca boogʉ. Cʉ̃ niimi, ca ĩa bejegʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Díámacʉ̃ mʉjare yʉ ĩi: Yʉ ca wederijere tee ca ĩirore biro ca tii nʉnʉjeerã, bii yaitirucuma —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","To biro cʉ̃ ca ĩiro, judíos ʉparã pea o biro cʉ̃re ĩiwa ñucã: —Mecʉ̃ docare díámacʉ̃ra ca wãtĩ jãa ecoricʉ peti mʉ ca niirijere jãa maji. Abraham, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cãa, bii yai peticoaupa. Mʉ pea, ¿ñee tiigʉ, “Yʉ ca wederijere tee ca ĩirore biro ca tii nʉnʉjeerã bii yaitirucuma,” mʉ ĩicãti? ");
INSERT INTO baoNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿To docare mʉa, jãa ñicʉ̃ Abraham niiquĩricʉ ametʉenero ca nii majuropeegʉ mʉ niiti? Cʉ̃a bii yaicoa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cãa bii yai peticoa, biicãupa. Mʉ pea, ¿ñiru ʉno peti niicãri, to biirije mʉ ĩi docuoti? —ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Jesús: —Yʉ majuropeera, “Ca nii majuropeegʉ niigʉ yʉ bii,” yʉ ca ĩi nʉcʉ̃ bʉo nucũ yujujata, yʉ ca ĩirije wapa mani. Yʉre ca ĩi nʉcʉ̃ bʉogʉa, yʉ Pacʉ niimi, “Jãa Ʉmʉreco Pacʉ niimi,” mʉja ca ĩigʉra. ");
INSERT INTO baoNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Mʉja cʉ̃re mʉja ĩa ñaati. Yʉ doca cʉ̃re yʉ maji. Cʉ̃re maji pacagʉ, “Cʉ̃re yʉ majiti,” yʉ ca ĩijata docare, mʉjare birora yʉ cãa, ca ĩi ditorique paigʉ yʉ niibocu. Yʉa, díámacʉ̃ra cʉ̃re yʉ maji. To biri cʉ̃ ca dotirijere cʉ̃ ca ĩirore biro yʉ tii. ");
INSERT INTO baoNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mʉja ñicʉ̃ Abraham niiquĩricʉa, yʉ yaa rʉmʉre cʉ̃ ca ĩapere tʉgoeñari ʉjea niiwi. To biri tii rʉmʉ ca earo ĩari, bʉaro ʉjea niiwi —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","To biro cʉ̃ ca ĩiro, judíos pea o biro ĩiwa Jesús're: —¿Ména cincuenta cʉ̃mari cʉoti pacagʉ, “Abraham're yʉ ĩawʉ,” mʉ ĩicãti? —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉwi Jesús: —Díámacʉ̃ mʉjare yʉ ĩi: Yʉa, Abraham niiquĩricʉ cʉ̃ ca baʉaparo jʉgueropʉra ca nii jʉo dooricʉ yʉ nii —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","To biro cʉ̃ ca ĩirora, cʉ̃re deerʉgarã ʉ̃tãgaari jeewa. Jesús pea Ʉmʉreco Pacʉ yaa wiipʉ ca niiricʉ, “To biro biicumi” ĩiña manigʉra cʉ̃ja watoara duti witi, waacoawi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesús pea waa nʉnʉa waagʉ, jĩcʉ̃ ʉmʉ ca ĩatigʉ ca baʉaricʉre ĩa bʉawi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Cʉ̃re ĩari, jãa, cʉ̃ buerã pea o biro cʉ̃re jãa ĩi jãiñawʉ: —Buegʉ, ¿ñee tiigʉ ania ca ĩatigʉ cʉ̃ baʉajapari? ¿Cʉ̃ pacʉa ñañarije cʉ̃ja ca tiirique wapa cʉ̃ biijapari? ¿Cʉ̃ majurope cʉ̃ ca ñañarije wapa pee cʉ̃ biijapariqué? —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","To biro jãa ca ĩiro, o biro jãare ĩi yʉʉwi Jesús: —Cʉ̃ majurope cʉ̃ ca ñañarije jʉori méé, ñucã cʉ̃ pacʉa cʉ̃ja ca ñañarije jʉori méé, ca ĩatigʉ baʉajacupi. Añuro petira, Ʉmʉreco Pacʉ cʉ̃ ca tii majirije, cʉ̃pʉre to bii bau niijato ĩiro to biro cʉ̃re biijapa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ména mʉja mena yʉ ca niirora yʉre ca doti cojoricʉ yeere ca padeparã mani nii. Yʉ ca waacoaro jiropʉ docare, jĩcʉ̃ ʉno peera ape wãme tii nemo majitirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ména ati yepapʉre niigʉ, ati yepa macãrãre ca boe bate niigʉ yʉ nii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","To biro ĩi yapano, yepapʉ ʉjeco eo cũu, jita mena paa ayia, ca ĩatigʉ capere wadawi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","To biro tiicã, o biro cʉ̃re ĩiwi Jesús: —Waa, ocora Siloé macãarapʉ mʉ capere waa coegʉja —cʉ̃re ĩi cojowi. (Siloé ĩiro: “Tiicojo cojoricʉ,” ĩirʉgaro ĩi.) To biro cʉ̃ ca ĩiro, ca ĩatigʉ pea waa, tiirapʉ cʉ̃ capere waa coe yapano, tua doogʉ, añuro ca ĩagʉpʉ tua dooupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","To biro cʉ̃ ca biiro ĩarã, cʉ̃ ca niiri tabe pʉto macãrã, wapa tiirica tiiri cʉ̃ ca jãi duwiro ca ĩarucuricarã pea o biro ameri ĩiupa: —¿Ania wapa tiirica tiiri ca jãi duwirucujãgʉ méé cʉ̃ niiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","To biro cʉ̃ja ca ĩiro, jĩcãrã o biro ĩiupa: —Cʉ̃ra niimi. Aperã pea: —Cʉ̃ méé niimi. Cʉ̃re biigʉra baumi biigʉpʉa —ĩiupa. To biro cʉ̃ja ca ĩimijata cãare, cʉ̃ pea: —Cʉ̃ra yʉ nii —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","To biro cʉ̃ ca ĩiro: —Too docare mecʉ̃ra, ¿do biro biicãri añuro mʉ ĩacãti? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Cʉ̃ pea o biro cʉ̃jare ĩi yʉʉupi: —Jĩcʉ̃ ʉmʉ, Jesús ca wãme cʉtigʉ, cʉ̃ ʉjecore yepapʉ eo cũu, jita mena paa ayiari, yʉ capere wadari: “Ocora Siloé macãrapʉ mʉ capere waa coegʉja,” yʉre ĩijãwi. To biro cʉ̃ ca ĩigʉ, toopʉ waa, yʉ capere waa coegʉra, añuro yʉ ĩacoajãwʉ yua —cʉ̃jare ĩi wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Cʉ̃ja pea to biro cʉ̃ ca ĩiro: —To biro mʉre ca tiiricʉ pea, ¿noopʉ cʉ̃ niiti? —cʉ̃re ĩi jãiñaupa. Cʉ̃ pea: —¡Baa! yʉ majiti —cʉ̃jare ĩicãupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Jesús, jitare cʉ̃ ʉjeco mena ayiari ca ĩatigʉ capere wadari cʉ̃ ca ĩaro cʉ̃ ca tiirica rʉmʉ pea, yerijãarica rʉmʉ niiwʉ. To biri cʉ̃ pʉto macãrã pea ca ĩatigʉ ca niimiricʉre, fariseos pʉtopʉ cʉ̃re ami waaupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Fariseos pea o biro cʉ̃re ĩi jãiñaupa: “¿Do biro biicãri añuro mʉ ĩacoajãri?” cʉ̃re ĩiupa. To biro cʉ̃ja ca ĩiro, cʉ̃ pea o biro cʉ̃jare ĩi yʉʉupi: —Jita ca weyarique mena yʉ capere cʉ̃ ca wadaro jiro, yʉ capere oco mena waa coe, yʉ ca tiijãro jirora añuro yʉ ĩacã yua —cʉ̃jare ĩi wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","To biro cʉ̃ ca ĩiro, jĩcãrã fariseos pea o biro ĩiupa: —Anire o biirije ca tiiricʉa, Ʉmʉreco Pacʉ yʉʉ méé niicumi, yerijãarica rʉmʉre ca nʉcʉ̃ bʉotigʉa —ĩiupa. To biro cʉ̃ja ca ĩiri tabere aperã pea o biro ĩiupa: —¿Ñañarije ca tiigʉ nii pacagʉ, do biro pee tiicãri, ate ca ĩa ñaaña manirije cʉ̃ tii bau nii majibogajati? —ĩiupa. To biro ĩima ĩirãra, cʉ̃ja majuropeera ameri dica waticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","To biro mani ameri biicã ĩima ĩirã, ca ĩatigʉ ca niimiricʉre cʉ̃re jãiña nemoupa ñucã: —Mʉa, mʉ ca ĩaro ca tiiricʉre, ¿“Ñiru peti niicumi,” cʉ̃re mʉ ĩi tʉgoeñati? —cʉ̃re ĩiupa. To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi cʉ̃ pea: —Yʉa, “Jĩcʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ niimi,” yʉ ĩi —cʉ̃jare ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Judíos ʉparã pea, jʉguero peera ca ĩatigʉ cʉ̃ ca niiriquere, ñucã añuro cʉ̃ ca ĩaro cʉ̃ ca tii ecoriquere, díámacʉ̃ tʉorʉgatiupa. To biri cʉ̃ pacʉapʉre cʉ̃jare jʉo cojori, ");
INSERT INTO baoNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","o biro cʉ̃jare ĩi jãiñaupa: —¿Ania mʉja macʉ̃, “Ca ĩatigʉ baʉawi,” mʉja ca ĩigʉra cʉ̃ niiti? ¿Do biro biicãri mecʉ̃ra yua añuro cʉ̃ ĩacãti? —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","To biro cʉ̃ja ca ĩiro, cʉ̃ pacʉa pea o biro cʉ̃jare ĩi yʉʉupa: —Jãa, anira, jãa macʉ̃ra nii, ca ĩatigʉra baʉa, cʉ̃ ca biiriquere jãa maji. ");
INSERT INTO baoNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","“Tee docare to biro biicãri añuro ĩacãmi. Ñucã cʉ̃, añuro cʉ̃ ca ĩaro cʉ̃re tiijapi,” ĩirique docare jãa majiti. Mʉja majurope cʉ̃re jãiñañaqué, mee, ca maja tua waaricʉpʉ niimi. Cʉ̃ majurope, cʉ̃ ca biiriquere díámacʉ̃ mʉjare wede majimi —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Cʉ̃ pacʉa pea judíos're uwima ĩirã, o biirijera cʉ̃jare ĩicãupa. Mee cʉ̃ja pea, ameri wede peni, “ ‘Jesús're, Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ Mesías niimi,’ ca ĩigʉra, nea poo juu buerica wiipʉra cʉ̃re mani cõa wienecãjaco,” ameri ĩi yerijãaupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","To biri cʉ̃ pacʉa pea: “Mʉja majurope cʉ̃re jãiñaña. Mee, ca maja tua peti waaricʉpʉ niimi,” cʉ̃jare ĩicãupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","To biro ĩicãri, judíos ʉparã pea ca ĩatigʉ ca niimiricʉre jʉo cojori, o biro cʉ̃re ĩiupa ñucã: —Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojorore díámacʉ̃ jãare wedeya. Jãa, cʉ̃ra, ñañarije ca tiigʉ cʉ̃ ca niirijere jãa maji —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","To biro cʉ̃ja ca ĩiro, cʉ̃ pea o biro ĩi yʉʉupi: —Yʉa, “Ñañarije ca tiigʉ niicumi,” cʉ̃re yʉ ĩi majiti. Jʉgueropʉra ména ca ĩatigʉ yʉ niiwʉ. Mecʉ̃ra añuro yʉ ĩacã yua. Tee wadore yʉ maji —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","To biro cʉ̃ ca ĩiro tʉo pacarã, o biro cʉ̃re ĩi jãiña nemocãupa ñucã: —¿Ñee mʉre cʉ̃ tiijãri? ¿Do biro peti tiicãri, mʉ ca ĩaro cʉ̃ tiijãri? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi cʉ̃ pea: —Mee, mʉjare yʉ wede yerijãajãwʉ doca. Yʉ ca wedemijata cãare, yʉ ca ĩirijere díámacʉ̃ mʉja tʉorʉgati. ¿Ñee tiirã pʉatiri cõro yʉ ca wedero mʉja booti? ¿Mʉja cãa, cʉ̃re tʉo nʉnʉjeerʉgarã mʉja ĩitiqué? —cʉ̃jare ĩicãupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","To biro cʉ̃ ca ĩiro ñañarije cʉ̃re ĩi tuti, o biro cʉ̃re ĩiupa: —Mʉ mʉ nii cʉ̃re ca tʉo nʉnʉjeegʉa. Jãa, Moisés're ca tʉo nʉnʉjeerã jãa nii. ");
INSERT INTO baoNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jãa, Moisés niiquĩricʉre Ʉmʉreco Pacʉ cʉ̃ ca wederiquere jãa maji. Cʉ̃ peera jãa majiti, “Noopʉ macʉ̃ doogʉ doojacupi” —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","To biro cʉ̃re cʉ̃ja ca ĩiro tʉo, o biro cʉ̃jare ĩi yʉʉupi cʉ̃ pea: —¡Agó nija! Teera nii, do biro pee ca ĩi majiña manirije, mʉja, “Too macʉ̃ doojacupi,” mʉja ca ĩi majiticãrije, yʉ peera ca ĩatimiricʉrena yʉ ca ĩaro tiijãwi doca. ");
INSERT INTO baoNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ñañarije ca tiirãra, Ʉmʉreco Pacʉ cʉ̃ ca tii nemotirijere añuro mani maji. Cʉ̃re ĩi nʉcʉ̃ bʉo, cʉ̃ ca boorore biro tii, ca tiirã wadore tii nemomi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Jĩcãti ʉno peera, jĩcʉ̃ ʉno peerena, “Ca ĩatigʉ ca baʉaricʉre cʉ̃ ca ĩaro cʉ̃re tiijagʉ,” ĩiriquere tʉo ñaaña mani. ");
INSERT INTO baoNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ania, Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ méé cʉ̃ ca niijata, jĩcã wãme ʉno peera tiiticãbocumi —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","To cõrora o biro cʉ̃re ĩi tutiupa: —Mʉ, bʉaropʉra ñañarije ca tiigʉ ca baʉaricʉra, ¿jãa peere mʉ wede majiorʉgati? —ĩiupa. To biro cʉ̃re ĩi tuti, nea poo juu buerica wiipʉ ca niigʉre ãcũ wienecã cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesús pea, ca ĩatigʉ ca niimiricʉre cʉ̃ja ca tuti ãcũ wieneriquere queti tʉowi. To biri cʉ̃re bʉa eagʉ, o biro cʉ̃re ĩi jãiñawi: —¿Ʉmʉreco Pacʉ Macʉ̃re mʉ tʉo nʉnʉjeeti? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Cʉ̃ pea o biro ĩi yʉʉwi: —¿Wiogʉ, nii cʉ̃ niiti? Yʉre wedeya, cʉ̃re yʉ ca tʉo nʉnʉjeepere biro ĩigʉ —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesús pea o biro cʉ̃re ĩiwi: —Mee cʉ̃re mʉ ĩa, yʉ, mʉ mena ca wedegʉa, cʉ̃ra yʉ nii —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","To biro cʉ̃ ca ĩirora, cʉ̃ pea Jesús jʉguerore cʉ̃ ãjʉro jupeari mena ea nuu waa, o biro cʉ̃re ĩi nʉcʉ̃ bʉowi: —Wiogʉ, díámacʉ̃ mʉre yʉ tʉo nʉnʉjee —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","To biro cʉ̃ ca ĩirora, Jesús pea o biro cʉ̃re ĩiwi: —Yʉa ati yepapʉre bojoca cʉ̃ja ca biirijere ĩa bejegʉ doogʉ yʉ doowʉ. Ati yepa macãrã ca ĩatirãre biro ca niirã, añurije quetire tʉo nʉnʉjeeri añuro ca ĩarã cʉ̃ja ca niiro tii, “Ʉmʉreco Pacʉ yeere ca majirã jãa nii,” ca ĩi ditorucurã pea, ca majiti majuropeerã tua, cʉ̃ja biijato ĩigʉ anopʉre yʉ doowʉ —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","To biro Jesús cʉ̃ ca ĩiro tʉorã, jĩcãrã fariseos cʉ̃ mena ca niiricarã o biro cʉ̃re ĩi jãiñawa: —¿Too docare jãa cãa, ca ĩatirã jãa niicãti? —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Ca ĩatirã mʉja ca niijata, ñañarije mʉja ca tiirijere wapa tuatirã mʉja niibocu. “Jãa, ca ĩa majirã jãa nii,” mʉja ca ĩirije ca niiro macã, ñañarije ca tii wapa tuarã mʉja niicã —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","To biro cʉ̃jare ĩi yapano, o biro cʉ̃jare ĩiwi ñucã Jesús: —Díámacʉ̃ mʉjare yʉ ĩi: Jĩcʉ̃, ecaricarã ovejas cʉ̃ja ca niiri janirore, jopera jãa waatigʉra aperopʉ ca mʉa ametʉa jãa waagʉa, jĩari majʉ, jee dutiri majʉ, niigʉ biimi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jopera ca jãa waagʉa, ecaricarã ovejas're ca cotegʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Jope pãa coteri majʉ cʉ̃re cʉ̃ ca jope pãaro, ovejas're ca cotegʉ pea, cʉ̃ ecaricarã ovejas're cʉ̃ja wãmeri mena wado cʉ̃jare cʉ̃ ca jʉoro, ovejas pea cʉ̃ wederiquepʉrena tʉo majicãma. To biri tii janiropʉ ca niirãre jʉo wiene cojo, ");
INSERT INTO baoNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","niipetirã cʉ̃ja ca witi ea petiro ĩa, cʉ̃jare cʉ̃ ca jʉgue waaro cʉ̃ jiro nʉnʉcoama, cʉ̃ wederiquepʉrena ca tʉo majĩcãrã niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cʉ̃ja ca majitigʉ peera cʉ̃re nʉnʉtima. Cʉ̃re nʉnʉricaro ʉnora ũmaa duticãma, ca ĩa ñaaña manigʉ cʉ̃ ca wederijere ca tʉo ñaatirã niiri —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ate cʉ̃jare ĩi cõoña wedewi Jesús. Cʉ̃ja pea, to biro cʉ̃ ca ĩirije ca ĩirʉgarijere tʉo majiticãwa. ");
INSERT INTO baoNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","To biri o biro cʉ̃jare ĩi nemowi ñucã Jesús: —Díámacʉ̃ mʉjare yʉ ĩi: Yʉ yʉ nii ovejas cʉ̃ja ca jãa waari jopere biro ca niigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Niipetirã yʉ jʉguero ca dooricarã, jee dutiri maja, jĩari maja, niiupa. To biri yʉ yaarã, ecaricarã ovejas're biro ca niirã pea, cʉ̃ja ca ĩirijere tʉo nʉnʉjeetiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yʉ yʉ nii jope. Yʉ, jopere biro ca niigʉre díámacʉ̃ ca tʉo nʉnʉjeegʉa, yʉ jʉori ametʉarucumi. Jĩcʉ̃ oveja, jãa waa, ñucã macã pee witi waa, añuro taa bʉa baa, cʉ̃ ca biirore biro biirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Jee dutiri majʉa, jee duti, jĩa, tii yaio bate, tiigʉ doogʉ wado doomi. Yʉ pea catirique pee cʉ̃ja cʉojato, pairopʉra catirique peere cʉ̃ja cʉo ametʉenecãjato ĩigʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","”Yʉ yʉ nii, ecaricarã ovejas're añuro ca ĩa nʉnʉjeegʉ. Cʉ̃ ovejare añuro ca ĩa nʉnʉjeegʉa, cʉ̃jare ametʉenerʉgʉ bii yai boja majimi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Wapa taarique wadore boo tʉgoeñari ca padegʉ pea, yai cʉ̃ ca dooro ĩa, ovejare toora cʉ̃jare cũu, duti weocoami, ovejas're ca ĩa nʉnʉjeegʉ méé nii, ovejas cʉ̃ yaarã méé nii, cʉ̃ja ca biiro macã. To biro cʉ̃jare cʉ̃ ca bii weoro, yai pea cʉ̃jare ñee, cʉ̃jare tii ãcũ batecã cojomi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Cʉ̃a, ovejas're ĩa nʉnʉjeerʉgʉ méé, wapa taarique wadore boogʉ ca padegʉ niiri, to biro cʉ̃jare bii weocãmi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","”Yʉ yʉ nii, ecaricarã ovejas're añuro ca ĩa nʉnʉjeegʉ; yʉ Pacʉ yʉre ĩa maji, yʉ pee cãa yʉ Pacʉre ĩa maji, yʉ ca biirore birora, yʉa yʉ yaarã ecaricarã ovejas're ĩa maji, ñucã cʉ̃ja pee cãa yʉre ĩa maji, biima. To biri yʉa yʉ yaarã ovejas're biro ca niirãre cʉ̃jare ametʉenegʉ, cʉ̃jare yʉ bii yai boja maji. ");
INSERT INTO baoNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ati janiro macãrã ca niitirã cãare aperã ovejas yʉ cʉo. Cʉ̃ja cãare yʉ jee cojorucu. Cʉ̃ja pea yʉre tʉo nʉnʉjee, jĩcã puna macãrãra nii ea, jĩcʉ̃ra cʉ̃jare ca ĩa cotegʉ cʉo, biirucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","”Yʉ majuropeera bojoca cʉ̃ja ca ñañarije wapa bii yai bojari, ñucã ca cati tuapʉ yʉ ca niiro macã, yʉ Pacʉ yʉre mai jañumi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Jĩcʉ̃ ʉno peera yʉre jĩa cõa majitimi. Yʉ majuro yʉ ca booro mena bojoca cʉ̃ja ca ñañarije wapare yʉ bii yai boja maji. To biri yʉ majuropeera bii yai boja, ñucã yʉ majuropeera cati tua, yʉ biicã maji. Ate nii, yʉ Pacʉ yʉre cʉ̃ ca tii doti cojorique —cʉ̃jare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","To biro Jesús cʉ̃ ca ĩirijere tʉori, judíos pea, no ca boorora ameri ĩi maa wijiacoawa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","To biro biima ĩirã, cʉ̃ja mena macãrã paʉ o biro ĩiwa: —¿Ñee tiirã, wãtĩ jãa ecocãri ca ĩi mecʉ̃gʉre cʉ̃re mʉja tʉo nʉnʉjeeti? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Aperã pea to biro cʉ̃ja ca ĩicãro o biro ĩiwa: —Ca wãtĩ jãa ecoricʉa jĩcʉ̃ ʉno peera, o biirije ĩiticumi. Mʉjara, ¿wãtĩra, ca ĩatirãre cʉ̃ja ca ĩaro cʉ̃ tii majicãgajati? —ameri ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Jerusalén macã peera Ʉmʉreco Pacʉ yaa wiire queno yapanorã cʉ̃ja ca boje rʉmʉ tii peo jʉorica rʉmʉ ʉno ca earo, tii wiire cʉ̃ja ca boje rʉmʉ tii peori rʉmʉri niiwʉ. Pue bʉcʉ rʉmʉri niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesús pea Ʉmʉreco Pacʉ yaa wiipʉre, Pórtico de Salomón cʉ̃ja ca ĩiri tabe pee waa yujuwi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tii tabepʉ cʉ̃ ca waa yujuro, judíos ʉparã pea cʉ̃re waa amojode nʉcãri, o biro cʉ̃re ĩi jãiñawa: —¿No cõro yoaro, “Cʉ̃ niicumi,” ĩi majiri méé jãa ca bii niiro mʉ tiigʉti? Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ Mesías'ra mʉ ca niijata, jĩcãtora “Cʉ̃ra yʉ nii,” jãare ĩicãña —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","To biro cʉ̃re cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩiwi: —Mee, mʉjare yʉ wede yerijãajãwʉ. Mʉja pee díámacʉ̃ mʉja tʉoti. Yʉ Pacʉ cʉ̃ ca dotiro ména yʉ ca tii niirijera, Mesías yʉ ca niirijere ĩa majiricarora bii ĩñocã doca. ");
INSERT INTO baoNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Mʉja pea díámacʉ̃ mʉja tʉoti, yʉ yaarã ovejas mena macãrã méé niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yʉ yaarã ecaricarã ovejas're biro ca niirã pea, yʉ wederiquere tʉo majima. Yʉ pee cãa, cʉ̃jare yʉ maji. Cʉ̃ja pea añuro yʉre tʉo nʉnʉjeema. ");
INSERT INTO baoNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","To biri yʉa, to birora caticõa niiriquere cʉ̃jare yʉ tiicojo, jĩcãti ʉno peera bii yaicoa, jĩcʉ̃ ʉno peera cʉ̃jare yʉre ẽma, tiitirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yʉ Pacʉ, cʉ̃jare yʉre ca tiicojoricʉa, niipetirã ametʉenero do biro ca tiiya manigʉ niimi. To biri yʉ Pacʉ cʉ̃ ca ĩa nʉnʉjeerãpʉra, jĩcʉ̃ ʉno peera cʉ̃re ẽma majiticãmi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yʉ, yʉ Pacʉ, jĩcʉ̃ra niirã jãa bii —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","To biro cʉ̃ ca ĩirora ñucã, judíos ʉparã pea cʉ̃re deerʉgarã ʉ̃tã jeewa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","To biro cʉ̃ja ca tiiro, Jesús pea o biro cʉ̃jare ĩiwi: —Yʉ Pacʉ yee ca doorijere, mʉja ca ĩaro paʉ añurije mʉjare yʉ tii ĩñorucujãwʉ. ¿Di wãme jʉori pee ʉ̃tã mena yʉre mʉja deerãti? —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","To biro cʉ̃jare cʉ̃ ca ĩiro, judíos ʉparã pea o biro cʉ̃re ĩi yʉʉwa: —Añurije mʉ ca tii niirije jʉori méé ʉ̃tã mena mʉre jãa deerucu. Ʉmʉreco Pacʉre ñañari wãme mʉ ca ĩi tutirije jʉori pee mʉre jãa deerucu. Mʉa, bojocʉ nii pacagʉ, mʉ majuropeera “Ʉmʉreco Pacʉ yʉ nii,” mʉ ĩicã —cʉ̃re ĩiwa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","To biro cʉ̃ja ca ĩiro, Jesús pea o biro ĩiwi ñucã: —Mʉjare ca dotirijepʉre o biro ĩi owarique nii: “ ‘Mʉja, jʉ̃guẽa mʉja nii,’ mʉjare yʉ ĩijãwʉ,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ʉmʉreco Pacʉ wederiquepʉ ca ĩirijepʉra, “To biro ĩicãro ĩi,” mani ĩi majiti. Ʉmʉreco Pacʉa, cʉ̃ yee quetire cʉ̃ ca wedericarãre, “Jʉ̃guẽa mʉja nii,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ʉmʉreco Pacʉra yʉre beje amiri, ati yepapʉre cʉ̃ ca tiicojo cojoricʉrena, “Ʉmʉreco Pacʉ Macʉ̃ yʉ nii” yʉ ca ĩirijerena, ¿ñee tiirã Ʉmʉreco Pacʉre ñañarije mʉ ĩi tuti, yʉre mʉja ĩicãti? ");
INSERT INTO baoNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yʉ Pacʉ cʉ̃ ca tiirijere yʉ ca tiitijata, díámacʉ̃ yʉre tʉoticãña. ");
INSERT INTO baoNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yʉ Pacʉ cʉ̃ ca tiirijere yʉ ca tiijata, díámacʉ̃ yʉre tʉoti pacarã, yʉ ca tii niirije peere “Díámacʉ̃ra nii,” ĩi ĩa nʉcʉ̃ bʉoya petopʉra, mee jĩcãtora “Yʉ Pacʉ yʉpʉre nii, yʉ pee cãa yʉ Pacʉpʉre nii,” yʉ ca biirijere mʉja ca maji peoticãpere biro ĩirã —cʉ̃jare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","To biro Jesús cʉ̃jare cʉ̃ ca ĩi wedero, judíos ʉparã pea Jesús're cʉ̃re ñeerʉgamiwa ñucã. Jesús pea cʉ̃jare duticoawi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jesús pea ñucã, dia Jordán ape nʉña muipũ cʉ̃ ca mʉa doori nʉña peere, jʉgueropʉ, Juan bojocare cʉ̃ ca uwo coe niirica tabepʉ waa, too jãare jʉo tua nʉcãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Toopʉ paʉ bojoca cʉ̃re ĩarã eari, o biro ĩiwa: —Díámacʉ̃ra Juan, jĩcã wãme ʉno peera ca ĩa ñaaña manirije tii bau nii ĩñoti pacagʉ, niipetirije ani cʉ̃ ca biipe maquẽre cʉ̃ ca ĩijata, díámacʉ̃ra ĩijapi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","To biri tii tabepʉre paʉ Jesús're tʉo nʉnʉjeewa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Niiupi jĩcʉ̃, diarique wai Lázaro ca wãme cʉtigʉ, María cõ yee wedego Marta jãari yaa macã Betania macʉ̃. ");
INSERT INTO baoNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Atio María, Lázaro yee wedego pea ména jʉguero peere, Jesús're ca jʉti añurije mena cʉ̃ dʉporire pio peori, cõ poa ñapõ menara ca ñia boporicora niiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","To biri cʉ̃ yaarã romiri pea, Jesús're o biro ĩi cojoupa: —Wiogʉ, mʉ mena macʉ̃, mʉ ca maigʉ, bʉaro diami —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesús pea to biro cʉ̃ja ca ĩirijere tʉori, o biro ĩiwi: —Ate cʉ̃ ca diarique cʉti niirijea, to birora cʉ̃ ca bii yaicã yerijãa waape méé niirucu. Ʉmʉreco Pacʉ cʉ̃ ca tutua majuropeerijere, ñucã yʉ Ʉmʉreco Pacʉ Macʉ̃ yʉ ca tutua majuropeerijere, yʉ ca ĩñope niiro biirucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesús pea María, Marta, Lázarore bʉaro cʉ̃jare mai pacagʉ, ");
INSERT INTO baoNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","“Lázaro bʉaro diajãwi,” cʉ̃ja ca ĩirijere tʉo pacagʉ, toora pʉa rʉmʉ jãare jʉo nii nemocãwi ména. ");
INSERT INTO baoNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jiro jañuro o biro jãare ĩiwi Jesús: —Jamʉ. Judea yepapʉ mani waaco ñucã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","To biro cʉ̃ ca ĩiro, jãa, cʉ̃ buerã pea o biro cʉ̃re jãa ĩiwʉ: —Buegʉ, tii rʉmʉ jañuriacãra tii yepa macãrã judíos, ʉ̃tã mena mʉre dee jĩa cõarʉgawa doca. To biro cʉ̃ja ca tiirʉgaricʉ nii pacagʉ, ¿toopʉre mʉ waarʉgati ñucã? —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","To biro jãa ca ĩiro, Jesús pea: —Tʉgoeñarique paiticãña. ¿Jĩcã rʉmʉ doce horas to cʉotiti? Ʉmʉrecora jĩcʉ̃ ʉno peera pʉa taatima, ati yepare ca boerijere ĩari ca waarã niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ñami ca waagʉ doca pʉa taacoami, ca boetiro macã —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","O biro ĩi nemowi ñucã: —Mani mena macʉ̃ Lázaro cãnicoajapi. Cʉ̃ ca cãnicoamijata cãare, cʉ̃re yʉ wãcõgʉ waarucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","To biro cʉ̃ ca ĩiro, jãa cʉ̃ buerã pea o biro cʉ̃re jãa ĩiwʉ: —Wiogʉ, cʉ̃ ca cãnijata, cʉ̃ ca catipe biicu —cʉ̃re jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesús pea, Lázaro cʉ̃ ca bii yaicoariquere ĩigʉ ĩimiupi. Jãa, cʉ̃ buerã pea, “Ca catirã mani ca cãnirucurore biro cãnigʉ biicumi,” jãa ĩi tʉgoeñacãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","To biri Jesús pea, jãa ca tʉo majitiro macã o biro jãare ĩi wede majiowi: —Lázaro bii yaicoajapi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","To biri yʉ pea cʉ̃ pʉtopʉre yʉ ca niitirique ca niiro macã, bʉaro yʉ ʉjea nii. To biro peera añu biiropʉa, mʉjare yʉ ca tii ĩñorijepʉre ĩari díámacʉ̃ mʉja ca tʉo nʉnʉjeepere biro ĩiro. Jamʉ, cʉ̃re mani ĩaco —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","To biro jãare cʉ̃ ca ĩiro, Tomás, apeyera ca Sʉ̃rʉaricʉ cʉ̃ja ca ĩigʉ pea, o biro jãare ĩiwi: —Jamʉ, mani cãa cʉ̃ mena jĩcãri bii yairʉgarã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesús pea, Lázarore cʉ̃ja ca yaa cõaricaro jiro bapari rʉmʉ ca nii waaropʉ jãare jʉo eacãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania macã pea, Jerusalén pʉtoacãra itia kilómetros waaricarora niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Paʉ judíos, Marta, María jãarire ĩarã waaupa, cʉ̃ja yee wedegʉ Lázaro cʉ̃ ca bii yairo cʉ̃ja ca tʉgoeñarique pairijere cʉ̃ja ca tʉgoeña bayiro tiirã waarã. ");
INSERT INTO baoNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta pea, “Mee, Jesús doomi,” cʉ̃ja ca ĩiro tʉori, cʉ̃re bocago dooupo. María pea wiipʉra tuacãupo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","To biri toopʉ jãare bocari, Marta pea o biro ĩiwo Jesús're: —Wiogʉ, anora mʉ ca niijata, yʉ yee wedegʉ bii yaitibojacupi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Biigopʉa yʉ maji. Mecʉ̃pʉ cãare cʉ̃ mʉ ca jãirije niipetirijere, mʉre tiicojocãrucumi Ʉmʉreco Pacʉ —ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","To biro cõ ca ĩiro, Jesús pea o biro cõre ĩiwi: —Mʉ yee wedegʉ cati tuacoarucumi —cõre ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwo Marta pea: —Mee yʉ maji. Ca bii yairicarã cʉ̃ja ca cati tuari rʉmʉ, ca tʉjari rʉmʉ ca niiropʉ cati tuarucumi —cʉ̃re ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","To biro cõ ca ĩiro, Jesús pea o biro cõre ĩiwi: —Yʉ yʉ nii, cati tuarique, to birora caticõa niirique, ca niigʉ. Yʉre ca tʉo nʉnʉjeegʉa, ca bii yaicoaricʉ nii pacagʉ, caticãrucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ca cati niirã, yʉre ca tʉo nʉnʉjeerã cõrora, jĩcãti ʉno peera bii yaicoa, biitirucuma. ¿Atere díámacʉ̃ mʉ tʉoti? —cõre ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","To biro cʉ̃ ca ĩiro, cõ pea o biro cʉ̃re ĩi yʉʉwo: —Ʉ̃gjá Wiogʉ, yʉa díámacʉ̃ra, “Cristo, Ʉmʉreco Pacʉ Macʉ̃ ati yepapʉre ca dooricʉ niimi,” mʉre yʉ ĩi nʉcʉ̃ bʉo —ĩiwo Marta. ");
INSERT INTO baoNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Marta pea, to biro cʉ̃re ĩi yapano, wiipʉ tua waa, cõ yee wedego Maríare jʉo cojori, yaioroacã o biro cõre ĩiupo: —María, manire Ca Buegʉ ea yerijãami. Mʉre jʉomi —ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","To biro cõ ca ĩiro tʉogo, María pea jĩcãtora wãmʉ nʉcã, Jesús're cʉ̃re ĩago doocã dooupo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ména Jesús pea tii macãpʉre piya waatigʉra, tii macã tʉjaropʉra, Marta cʉ̃re cõ ca bocarica tabepʉra niicãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Judíos, cõ yee wedegʉ cʉ̃ ca bii yairo cõ ca tʉgoeñarique pairijere cõ tʉgueña bayijato ĩirã cõ yaa wiipʉ Maríare ca bapa cʉti niiricarã pea, yoari méé wãmʉ nʉcã cõ ca witi waaro ĩari, “Cõ yee wedegʉ niiquĩricʉ maja ope pʉtopʉ otigo waago biicumo” ĩi tʉgoeñari, cõre nʉnʉcã dooupa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","María pea, Jesús pʉto eago, Jesús ñicãri pʉtoacã cõ ãjʉro jupeari mena ea nuu eari, o biro cʉ̃re ĩiwo: —Wiogʉ, anora mʉ ca niijata, yʉ yee wedegʉ bii yaitibojacupi —cʉ̃re ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesús pea yua, María, to biri judíos cõ mena ca dooricarã cʉ̃ja ca otiro ĩari, cʉ̃ yeripʉ bʉaropʉra tʉgoeñarique pai, biima ĩigʉ ");
INSERT INTO baoNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","o biro cʉ̃jare ĩi jãiñawi: —¿Noopʉ cʉ̃re mʉja yaajãri? —cʉ̃jare ĩiwi. Cʉ̃ja pea o biro ĩiwa: —Wiogʉ, doori ĩagʉ dooya —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesús pea otiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","To biro cʉ̃ ca biro ĩarã, judíos pea o biro ameri ĩiwa: —¡Ĩañaaqué, no cõro bʉaro peti cʉ̃re cʉ̃ maicãmijapari! —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","To biro cʉ̃ja ca ĩiro, jĩcãrã cʉ̃ja mena macãrã pea o biro ĩiwa: —Ani, ca ĩatigʉre cʉ̃ ca ĩaro ca tiiricʉa, ¿jĩcã wãme ʉnora cʉ̃ tiitibojapari, Lázaro cʉ̃ bii yaiticãjato ĩigʉ? —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesús pea ñucã cʉ̃ yeripʉ bʉaro tʉgoeñarique paigʉra, cʉ̃ niiquĩricʉ maja ope pʉto pee waawi. Tii ope pea ʉ̃tã ope niiwʉ. Ñucã tii ope jope pee cãa ʉ̃tãga mena biaricaro niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tii jope pʉto eagʉra, o biro ĩiwi Jesús: —Ʉ̃tãgare ami wooya —ĩiwi. To biro cʉ̃ ca ĩiro, ca bii yairicʉ yee wedego Marta pea, o biro ĩiwo Jesús're: —Wiogʉ, docuoro ʉ̃nicumi, mee bapari rʉmʉ peti ametʉa cʉ̃ ca bii yaijãro jiro —cʉ̃re ĩiwo. ");
INSERT INTO baoNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","To biro cõ ca ĩiro Jesús pea o biro cõre ĩi yʉʉwi: —Mee, “Díámacʉ̃ yʉre mʉ ca tʉo nʉnʉjeejata, Ʉmʉreco Pacʉ cʉ̃ ca doti tutua majuropeerijere mʉ ĩarucu,” ¿mʉre yʉ ĩitijãri? —cõre ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Maja ope tiaricaga ʉ̃tãgare cʉ̃ja ca ami wooro ĩa, Jesús pea ʉmʉreco pee ĩa mʉene cojori, o biro ĩiwi: —Cáacʉ, yʉ ca jãirijere mʉ ca tʉoro macã, “Añu majuropeecã,” mʉre yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","To cãnacã tiira yʉre mʉ ca tʉorucurijere yʉ maji biigʉpʉa. Atera, anija bojoca ano ca niirãre añurije boojãma ĩigʉ to biro mʉre yʉ ĩi, mʉ, mʉ ca tiicojo cojoricʉ yʉ ca niirijere: “Díámacʉ̃ra Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ niimi,” cʉ̃ja ca ĩi ĩa majipere biro ĩigʉ —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","To biro ĩi yapanogʉra, bʉaro acaro buirique mena o biro ĩiwi: —¡Lázaro, ano pee witi dooya! —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","To biro cʉ̃ ca ĩirora, ca bii yaicoamiricʉ pea, cʉ̃ amori, cʉ̃ dʉporire juti quejeri mena dʉdʉaricʉ, ñucã cʉ̃ dʉpʉga peera lienzo quejero mena dʉdʉaricʉ, witicã doowi. To biro cʉ̃ ca biiro, Jesús pea o biro cʉ̃jare ĩiwi: —Teere cʉ̃re popioya. Cʉ̃ waajato —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","To biro cʉ̃ ca tiirijere ĩarã, paʉ judíos Maríare ca bapa cʉtirã waaricarã, Jesús're tʉo nʉnʉjeewa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","To biri, jĩcãrã cʉ̃ja mena macãrã pea fariseos pʉtopʉ waari, niipetirije Jesús cʉ̃ ca tiiriquere cʉ̃jare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","To biro cʉ̃ja ca ĩirijere tʉori, fariseos, paia ʉparã pea, tii macãre ca jʉo nii majuropeerãre neori, o biro ĩiupa. —¿Do biro cʉ̃re mani tiirãti? Cʉ̃a, paʉ wãmeri peti ca ĩa ñaaña manirije tii bau niicãgʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","To birora cʉ̃re mani ca ĩacãjata, niipetirã cʉ̃re tʉo nʉnʉjeerucuma. To biro cʉ̃ja ca biijata, Roma macãrã ʉparã doori, mani Ʉmʉreco Pacʉ wiire, ñucã mani yaa yepa menapʉrena díámacʉ̃ra tii yaiocãrucuma —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","To biro cʉ̃ja ca ĩiro, jĩcʉ̃ cʉ̃ja mena macʉ̃ Caifás ca wãme cʉtigʉ, tii cʉ̃mare paia wiogʉ ca niigʉ pea, o biro cʉ̃jare ĩiupi: —Mʉja, mʉja majiti majuropeecã. ");
INSERT INTO baoNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","“Bojoca niipetirãre jĩcʉ̃ra cʉ̃ ca bii yai bojaro añu, jĩcã yepa macãrã niipetirãpʉra ñañaro mani ca tii yaio ecotipere biro ĩirã,” mʉja ĩi tʉgoeña majiti majuropeecã tee cãare —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Caifás pea, atera cʉ̃ majurope cʉ̃ ca tʉgoeñarije mena méé to biro ĩiupi. Tii cʉ̃mare paia wiogʉ ca niigʉ niiri, Ʉmʉreco Pacʉ, “To biro ĩiña,” cʉ̃re cʉ̃ ca ĩi cõa jãaro macã, judíos're ametʉenerʉgʉ Jesús cʉ̃ ca bii yai bojapere ĩigʉ to biro ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ñucã judíos wadore ametʉenetigʉra, niipetirã Ʉmʉreco Pacʉ puna, ape yeparipʉ ca nii bate cojorãre jĩcã punaarã cʉ̃ja ca nii earo cʉ̃ ca tiipere wede jʉguegʉ ĩiupi Caifás. ");
INSERT INTO baoNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","To biro cʉ̃ja ca ĩirica rʉmʉra, “Jesús're mani jĩacãjaco,” ĩi yerijãaupa judíos ʉparã. ");
INSERT INTO baoNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","To biri Jesús pea judíos watoare bau niiro waa yujutigʉra, Judea yepare ca niiricʉ, jĩcã tabe ca yucʉ maniri yepa pʉtoacã pee, Efraín ca wãme cʉtiri macãpʉ jãare jʉo waacoawi. Toopʉra jãare jʉo niicãwi yua. ");
INSERT INTO baoNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Peeto dʉjawʉ yua, judíos yaa boje rʉmʉ Pascua ca earo. To biri tii boje rʉmʉ ca eaparo jʉguerore, paʉ bojoca, macãri macãrã cõrora Jerusalén macãpʉ maa waawa, Ʉmʉreco Pacʉre añuro cʉ̃ja ca tii nʉcʉ̃ bʉo majipere biro ĩirã, Pascua boje rʉmʉ jʉguero cʉ̃ja ñicʉ̃ jʉ̃mʉa cʉ̃ja ca tii jʉo dooricarore biro tiirã, ñañarije cʉ̃ja ca tiiriquere coe jʉguerã waarã. ");
INSERT INTO baoNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","To biro biirã, Jesús're ama yujurã, Ʉmʉreco Pacʉ yaa wiipʉ niirã cʉ̃ja majurope o biro ameri ĩi jãiña niiupa: —¿Do biro mʉja ĩi tʉgoeñati mʉja? ¿Boje rʉmʉre cʉ̃ doogajati? ¿Cʉ̃ dootigajatiqué? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mee fariseos, to biri paia ʉparã pea: —Jĩcʉ̃ ʉno Jesús're cʉ̃ ca ĩajata, jĩcãto “Too niijãwi,” cʉ̃ ĩi wedejato, cʉ̃re mani ca ñeepere biro ĩirã —ĩi wede majio yerijãaupa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Pascua boje rʉmʉ ca eaparo jʉguero, seis niiri rʉmʉri ca dʉjaro, ca bii yairicʉpʉre cʉ̃ ca catioricʉ Lázaro cʉ̃ ca niiri macã Betaniapʉ jãare jʉo waawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Toopʉ, Jesús're tii nʉcʉ̃ bʉorã, baarique jãare jʉo baawa. Marta niiwo baarique ca batogo. Jesús mena ca baa duwirã watoare ca baa duwigʉ, Lázaro niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Too jãa ca baa duwirucuro, María pea, ca jʉti añurije, nardogʉ maquẽ ca dia peti ca niirije ca wapa pacarijere, pʉa waaga oco waa amiricaro cõro Jesús dʉporire pio peori, cõ poa ñapõ menara tuu bopowo. To biro cõ ca tiiro, tii wiire jʉti añu dadacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","To biro Jesús're cõ ca tiirijere ĩagʉ, Judas Iscariote, jãa mena macʉ̃, Jesús're ca wedejãa buiyee cõapʉ pea, o biro ĩiwi: ");
INSERT INTO baoNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Ñee tiigo ate ca jʉti añurijere jĩcã cʉ̃ma pade wapa taaricaro cõro mʉ noni wapa jeetijãri, ca boo pacarãre tii nemorʉgo? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas pea ca boo pacarãrare tii nemorʉgʉ méé to biro ĩiwi. Ca jee duti paigʉ niiri ĩiwi atera. Cʉ̃ pea, wapa tiirica tiiri ca jãñari poare ca ĩa nʉnʉjeegʉ niiri, tii poare jãa ca jãarucurijere jee duticãrucuupi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩiwi: —To birora cõre ĩacãña. Yʉre cʉ̃ja ca yaari rʉmʉ maquẽpʉre tii yuego tiimo. ");
INSERT INTO baoNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ca boo pacarã to birora mʉja mena niicõa niirucuma. Yʉ pea to cãnacã rʉmʉra mʉja menare yʉ niicõa niitirucu —ĩiwi Judas're. ");
INSERT INTO baoNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Betaniapʉ Jesús cʉ̃ ca niirijere majiri, paʉ judíos, Jesús wadore ĩarʉgarã méé, Lázaro ca bii yaicoaricʉpʉrena Jesús cʉ̃ ca catioricʉ cãare ĩarʉgarã dooupa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","To biri paia ʉparã pea, Lázaro cãare jĩarʉgarã ");
INSERT INTO baoNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ameri wede peni yerijãaupa, cʉ̃ jʉorira paʉ judíos cʉ̃jare camotatiri, Jesús peere cʉ̃ja ca tʉo nʉnʉjeero macã. ");
INSERT INTO baoNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ape rʉmʉ peere, paʉ bojoca Jerusalén'pʉ Pascua boje rʉmʉ ca waaricarã, Jesús tii macãpʉre cʉ̃ ca eapere majiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","To biri ĩiquĩ queeri paa jude jeeri, cʉ̃re bocarã doorã o biro ĩi acaro bui nʉnʉa doowa: —¡Añu majuropeecã, jãare ametʉeneña Wiogʉ David pãrami! ¡Añuro ca biigʉ niimi Ʉmʉreco Pacʉ wãme mena ca doogʉ! ¡Añuro ca biigʉ niimi Israel Wiogʉ! —ĩi ʉjea nii bocawa Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesús pea, jĩcʉ̃ burro bʉari, cʉ̃re mʉa peawi, Ʉmʉreco Pacʉ wederiquepʉ o biro ca ĩirore birora: ");
INSERT INTO baoNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Uwiticãña Sión macã macãrã. Ĩaña. Mʉja Wiogʉ burro jotoapʉ pejari doomi,” ca ĩirore birora. ");
INSERT INTO baoNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ména jĩcãtoacãra, jãa cʉ̃ buerã pea, atere jãa tʉo majitiwʉ. Ca bii yaicoaricʉ nii pacagʉ Jesús cʉ̃ ca cati tuaro jiropʉ docare, ate niipetirije cʉ̃re cʉ̃ja ca tiiriquere, Ʉmʉreco Pacʉ wederiquepʉ cʉ̃ ca biiperena cʉ̃ja ca owarique ca niirijere jãa tʉo majiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bojoca, Lázarore maja opepʉ ca niigʉre jʉo wiene cojo, ca bii yairicarã watoare cʉ̃ ca cati tuaro cʉ̃re tii, Jesús cʉ̃ ca tiiri tabere cʉ̃ mena ca niiricarã pea cʉ̃ja ca ĩariquere aperãre wederucuwa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","To biri paʉ bojoca Jesús're bocarã doowa, ca ĩa ñaaña maniri wãme cʉ̃jare cʉ̃ ca tii ĩñoriquere cʉ̃jare cʉ̃ja ca wederiquere ca tʉoricarã niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","To biro cʉ̃ja ca biirijere ĩarã, fariseos pea o biro ameri ĩiupa: —Mee, mʉja ĩati: O biro cʉ̃ja ca biirijere mani ca camotaaticãjata, do biro mani tiiricaro mani. Ĩañaaqué, bojoca niipetirã cʉ̃ jĩcʉ̃rena tʉo nʉnʉjeecãma —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tii boje rʉmʉre Ʉmʉreco Pacʉre ca ĩi nʉcʉ̃ bʉorã Jerusalén'pʉ ca maa waaricarã watoare niiupa jĩcãrã griegos. ");
INSERT INTO baoNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Cʉ̃ja pea Galilea yepare ca niiri macã Betsaida macʉ̃ Felipe pʉto eari, o biro cʉ̃re ĩi jãiupa: —Jãa Jesús're jãa ĩacãrʉgamijapa —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","To biro cʉ̃ja ca ĩiro tʉori, Felipe pea, Andrés peere wedegʉ waaupi. To biri cʉ̃ja pʉarãpʉ Jesús're wederã eawa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩi yʉʉwi: —Mee, yʉ, Ca Nii Majuropeegʉ Macʉ̃ bii yairi jiro yʉ ca cati tuapa tabe eacoa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Yee méé yʉ ĩi: Trigo apega, oteya maniricara to ca boacoajata, tiiga wado biicã yerijãa waa. Tiigare otejata docare, wii, bʉcʉa, pairo dica cʉti. ");
INSERT INTO baoNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Cʉ̃ ca catirijere ca maigʉa, cʉ̃ ca cati niirijere tii yaiocãrucumi. Ati yepare cʉ̃ ca cati niirijere bʉaro ca maitigʉ pea, cʉ̃ ca caticõa niipere bʉarucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Jĩcʉ̃ yʉ yeere ca tii nʉnʉjeerʉgʉ ʉno, yʉ mena cʉ̃ doojato. Yʉ yeere ca tii nʉnʉjeegʉa, yʉ ca niiri tabera niirucumi cʉ̃ cãa. Yʉ yeere ca tii nʉnʉjeegʉre, yʉ Pacʉ añuro cʉ̃re tii nʉcʉ̃ bʉorucumi —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","To biro ĩicã, o biro ĩiwi: —“Mecʉ̃acãre bʉaro peti yʉ tʉgoeñarique paicã,” ¿Do biro yʉ ĩigʉti? ¿“Cáacʉ, ate yʉ ca tʉgoeña pairijere yʉre ametʉeneña,” yʉ ĩigʉti? ¡Yʉ ĩiticu! Aterena ĩigʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Cáacʉ, do biro ca tiiya manigʉ mʉ ca niirijere bojocare ĩñoña —ĩiwi Jesús. To biro cʉ̃ ca ĩirora, ʉmʉreco tutipʉ o biro ĩi wedeo cojowʉ: —Mee, do biro ca tiiya manigʉ yʉ ca niirijere yʉ ĩño yerijãawʉ. Yʉ ĩño nemorucu ñucã —ĩi wedeowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bojoca too ca tʉo niirã pea: —Bʉpo niibujãwi —ĩiwa. Aperã pea: —Ʉmʉreco Pacʉ pʉto macʉ̃ Jesús mena wedegʉ ĩibujãwi —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","To biro cʉ̃ja ca ĩiro, Jesús pea o biro cʉ̃jare ĩiwi: —Ano ca wederijere mʉja ca tʉorijea yʉre ĩiro méé ĩi. Mʉjare ĩima ĩiro ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Mee mecʉ̃ra nii, ati yepa macãrã Ʉmʉreco Pacʉre cʉ̃ja ca ĩa beje ecopa tabe. Ñucã mecʉ̃ra ati yepare ca doti niigʉ Satanás cãa, Ʉmʉreco Pacʉre cõa wiene ecorucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","To biri yucʉ tenipʉ yʉre paa pua tuuri, cʉ̃ja ca ami mʉene nʉcõrije mena, ati yepa macãrã paʉ cʉ̃ja ca ñañarije wapare tʉgoeña wajoari, yʉ peere cʉ̃ja ca tʉo nʉnʉjeero yʉ tiirucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Atere ĩigʉa, “O biri wãme yʉ bii yairucu,” ĩigʉ ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","To biro Jesús cʉ̃ ca ĩirijere tʉorã, bojoca pea o biro cʉ̃re ĩiwa: —Jãa, doti cũurique: “Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojogʉ Mesías, to birora caticõa niirucumi,” ca ĩirijere jãa maji. ¿Ñee tiigʉ mʉ pea, “Ca Nii Majuropeegʉ Macʉ̃, yucʉ tenipʉ paa pua tuuri ami mʉene nʉcõ ecorucumi,” mʉ ĩiti? ¿Nii cʉ̃ niiti Ca Nii Majuropeegʉ Macʉ̃? —cʉ̃re ĩi jãiñawa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","To biro cʉ̃ja ca ĩiro, o biro ĩiwi Jesús: —Ména yʉ, Ʉmʉreco Pacʉ cʉ̃ ca boorore biro niiriquere ca wede majiogʉ, no cõro mééacãra mʉja watoare yʉ ca niiro ʉno, yʉ ca wederijere añuro yʉre tʉo nʉnʉjeeya, “To biro biibocu,” mʉja ca ĩitiri tabere ca naitĩarije mʉjare ca bii ñaapea eatipere biro ĩirã. Ca naitĩaro jĩa boeri méé ca waagʉa, “Too pee yʉ waacu,” ĩi majitimi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yʉ, Ʉmʉreco Pacʉ cʉ̃ ca boorore biro niiriquere ca wede majiogʉ yʉ ca niirora, díámacʉ̃ yʉre tʉo nʉnʉjeeya, yʉ yaarã mʉja ca niipere biro ĩirã —ĩiwi. To biro atere ĩi yapano, waa, cʉ̃jare duticoawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Cʉ̃ja ca ĩarora to cõro paʉ ca ĩa ñaaña manirije cʉ̃ ca tii bau niirije ca nii pacaro, Jesús're tʉo nʉnʉjeeticãwa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Biiropʉa, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías niiquĩricʉ: “Ʉpʉ, ¿noa pee jãa ca wederijere cʉ̃ja tʉo nʉnʉjeeti? ¿Ʉpʉa, noa peere cʉ̃ ca tutuarijere cʉ̃ tii bau nii ĩñomijapari?” cʉ̃ ca ĩiquĩricarore biro bii earo biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","To biri Jesús cʉ̃ ca wederijere tʉo nʉnʉjee majitiwa. Ñucã teerena ĩigʉ: ");
INSERT INTO baoNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ca ĩatirãre biro cʉ̃jare tii, ca tʉo jeeño majitirã cʉ̃jare tii, cʉ̃jare tiijapi Ʉmʉreco Pacʉ. Ĩa maji, tʉo puo, tʉgoeña yeri wajoa, biicãri yʉ peere cʉ̃ja ca tʉo nʉnʉjeero, yʉ pee cãa cʉ̃jare ametʉene, yʉ ca tiitipere biro ĩigʉ,” ĩi owaquĩupi Isaías. ");
INSERT INTO baoNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaías, atere to biro ĩiupi, Jesús yee ca añu majuropeerijere ca ĩaricʉ niiri. To biri Jesús cʉ̃ ca biipere wedeupi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","To biirije to ca ĩicã pacaro, paʉ judíos, to biri jĩcãrã bojocare ca jʉo niirã menapʉra, díámacʉ̃ Jesús're tʉo nʉnʉjeewa. Cʉ̃ja pea Jesús're ca tʉo nʉnʉjeerã niicã pacarã, fariseos're uwima ĩirã bau niiro, “Jesús're ca tʉo nʉnʉjeerã jãa nii,” ĩitiwa, nea poo juu buerica wiijeripʉra cʉ̃jare cʉ̃ja ca cõa wienetipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ʉmʉreco Pacʉ cʉ̃jare cʉ̃ ca nʉcʉ̃ bʉorije ametʉenero, bojoca cʉ̃ja ca nʉcʉ̃ bʉorije peere ca boorã niiri, to biro biiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesús pea tutuaro wederique mena o biro ĩiwi: —Díámacʉ̃ yʉre ca tʉo nʉnʉjeegʉa, yʉ jĩcʉ̃rena tʉo nʉnʉjeegʉ méé tiimi. Yʉ Pacʉ yʉre ca tiicojo cojoricʉ cãare tʉo nʉnʉjeegʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yʉre ca ĩagʉ cãa, yʉre ca tiicojo cojoricʉ cãare ĩami. ");
INSERT INTO baoNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yʉ, ca boerije ca niigʉra ati yepapʉre yʉ doowʉ, díámacʉ̃ yʉre ca tʉo nʉnʉjeerã, ca naitĩaropʉ cʉ̃ja tuaticãjato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","To ca bii pacaro yʉ ca wederijere tʉocã pacagʉ, tee ca ĩirore biro ca tii nʉnʉjeetigʉra, yʉ méé yʉ nii, ñañaro cʉ̃re ca tiipʉ. Yʉa bojocare ñañaro tiigʉ doogʉ méé yʉ doowʉ. Cʉ̃jare ametʉenegʉ doogʉ yʉ doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Yʉre booti, yʉ ca wederijere tʉorʉgati, ca biigʉa mee, ñañaro cʉ̃re ca tiipʉre cʉo yerijãami. Yʉ ca wedejãrijera ca tʉjari rʉmʉ ca niiropʉre ñañaro cʉ̃re tiicãrucu. ");
INSERT INTO baoNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Yʉa, yʉ majurope yʉ ca boori wãmera wedegʉ méé yʉ ĩi. Yʉ Pacʉ yʉre ca tiicojo cojoricʉpʉra, “Ate mʉ wederucu; atere mʉ bue majiorucu,” yʉre ĩi cojowi. ");
INSERT INTO baoNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yʉa, yʉ Pacʉ cʉ̃ ca tii dotirijera, to birora caticõa niirique maquẽ ca niirijere añuro yʉ maji. To biri, yʉ ca ĩirije cõrorena yʉ Pacʉ yʉre cʉ̃ ca wede doti cojoricarore birora yʉ wede —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Mee Pascua boje rʉmʉ ea waaro biiwʉ. Jesús pea, cʉ̃ Pacʉ mena niigʉ waarʉgʉ, ati yepare cʉ̃ ca waa weopa tabe ca ea waarijere majiupi. Cʉ̃a, ati yepa macãrã cʉ̃ yaarã cʉ̃re ca tʉo nʉnʉjeerãre to birora ca maicã jʉo dooricʉ niiri, bʉaropʉra cʉ̃ ca mairijere ĩñowi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Baarica tabe eacoawʉ yua. Mee Satanás pea, Simón macʉ̃ Judas Iscariote peera, Jesús're cʉ̃ ca wedejãapere cʉ̃ ca tʉgoeñarijepʉre cʉ̃re tʉgoeña cõa jãacãupi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesús pea, Ʉmʉreco Pacʉ pʉtopʉ cʉ̃ ca dooriquere, ñucã Ʉmʉreco Pacʉ pʉtopʉra cʉ̃ ca tua waapere, to biri cʉ̃ Pacʉ, niipetirijepʉrena ca doti niigʉ cʉ̃re cʉ̃ ca tiiriquere, majiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","To biri ca baa duwiricʉra wãmʉ nʉcã, cʉ̃ jutiro jotoa macãrore tuu wee cũu, jutiro quejero amiri cʉ̃ wẽñarica daa cʉtiri tabe jia tuuwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","To biro tiicã, jotʉ bapapʉ oco waa piori, tee mena jãa, cʉ̃ buerã dʉporire coeri, jutiro quejero cʉ̃ wẽñarica daa cʉtiri tabe cʉ̃ ca jia tuuricaro mena tuu bopo nʉnʉa waawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedro dʉporire coegʉ doogʉ cʉ̃ ca tiirora, cʉ̃ pea o biro ĩicãwi Jesús're: —Wiogʉ, ¿mʉ, yʉ dʉporire coegʉ doogʉ mʉ tiiti? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","To biro cʉ̃ ca ĩiro, Jesús pea: —Mecʉ̃acãra ména o biro yʉ ca tiirijere mʉ tʉo puoti; jiro jañuri mʉ tʉo puorucu ména —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pedro pea o biro cʉ̃re ĩiwi ñucã: —Mʉra, jĩcãti ʉno peera yʉ dʉporire mʉre yʉ coe dotiti majuropeecãrucu —ĩiwi. To biro cʉ̃ ca ĩiro, Jesús pea o biro ĩi yʉʉwi Pedrore: —Mʉ dʉporire yʉ ca coetijata, yʉ yaarã mena macʉ̃ mʉ niiticãrucu —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","To biro cʉ̃ ca ĩiro, Pedro pea ñucã o biro cʉ̃re ĩiwi: —Wiogʉ, to docare yʉ dʉpori wadorena yʉre coeeto. Yʉ amori, yʉ dʉpʉga cãare coeya —ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","To biro cʉ̃ ca ĩiro, Jesús pea: —Mee, ca uwa coe yapanoricʉpʉra, õweri manigʉ cʉ̃ ca niiro macã, cʉ̃ dʉpori wadore coerique boo. Mʉja, ca õweri manirãre biropʉ mʉja nii mee. Biirãpʉa, niipetirãpʉra to biro mʉja biiti. Niimi jĩcʉ̃ ñañarije ca tʉgoeñarique cʉtigʉ; cʉ̃ niimi mʉja watoare ca õweri cʉtigʉre biro ca niigʉ —cʉ̃re ĩi yʉʉwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Niipetirãpʉra, “Õweri manirã wado mʉja niiti” cʉ̃ ca ĩijata, cʉ̃re ca wedejãa buiyeecõapʉre cʉ̃re majiri to biro jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jãa, cʉ̃ buerã dʉporire coe yapano, cʉ̃ jutiro jotoa macãro cʉ̃ ca tuu wee cũuricarore ami jãña, cʉ̃ ca duwirica tabepʉra ea nuu waa, o biro jãare ĩiwi Jesús: —¿Mʉjare yʉ ca tiijãrijere mʉja tʉo puoti? ");
INSERT INTO baoNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mʉja, yʉre “Jãare Ca Buegʉ,” “Jãa Wiogʉ,” yʉre mʉja ĩi. Díámacʉ̃ra mʉja ĩi: “Cʉ̃ra yʉ nii”. ");
INSERT INTO baoNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","To biri yʉ, mʉjare ca Buegʉra, mʉja Wiogʉra, jĩcʉ̃ pade coteri majʉre biro mʉja dʉporire yʉ ca coejãrore birora mʉja cãa, mʉja majurope mʉja dʉporire ca ameri coeparã mʉja nii. ");
INSERT INTO baoNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Jĩcã wãme mʉjare yʉ tii ĩñojãwʉ, mʉjare yʉ ca tiijãrore birora mʉja ca tiipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Díámacʉ̃ mʉjare yʉ ĩi: Pade coteri majʉ jĩcʉ̃ ʉno peera cʉ̃ wiogʉ ametʉenero niitimi. Ñucã jĩcʉ̃ ca doti cojo ecoricʉ cãa, cʉ̃re ca doti cojogʉ ametʉenero niitimi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","To biri atere tʉo jeeñori teere mʉja ca tii niijata, añuro ʉjea niirã mʉja niirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","” “Mʉja niipetirãpʉre ĩigʉ méé” yʉ ĩi, biigʉpʉa. Yʉa, yʉ ca beje jeericarãre yʉ maji. Ʉmʉreco Pacʉ wederiquere owarica pũuropʉ: “Yʉ mena ca baa duwigʉra yʉre ca ĩa tutigʉ nii eacãmi,” cʉ̃ja ca ĩi owarique ca ĩirore birora ca biipe niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mee, tee ca biiparo jʉguero atere mʉjare yʉ wede majio jʉguecã, yʉ ca ĩiricarore biro ca biiro ĩarã, to birora ca niicõa niigʉ yʉ, yʉ ca niirijere mʉja ca tʉo nʉnʉjeepere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Díámacʉ̃ mʉjare yʉ ĩi: Yʉ yee quetire yʉ ca wede doti cojogʉre añuro ca tʉo nʉnʉjeegʉa, yʉrena tʉo nʉnʉjeegʉ tiimi. Ñucã yʉ ca wederijere ca tʉo nʉnʉjeegʉ cãa, yʉre ca tiicojoricʉrena tʉo nʉnʉjeegʉ tiimi —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Teere to biro jãare ĩi wede yapanogʉra, Jesús pea cʉ̃ ca cati niirijepʉ bʉaro tʉgoeña yapa pua, díámacʉ̃ o biro jãare ĩi wede majiowi: —Atere díámacʉ̃ mʉjare yʉ ĩi: Jĩcʉ̃ mʉja mena macʉ̃ra yʉre wedejãa buiyee cõacãgʉ doogʉ tiimi —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","To biro cʉ̃ ca ĩiro, jãa, cʉ̃ buerã pea: “Cʉ̃re ĩigʉ ĩicumi” ĩi majitima ĩirã, jãa majuropeera jãa ameri ĩacã duwi yujuwʉ yua. ");
INSERT INTO baoNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ména yʉ, bʉaro Jesús cʉ̃ ca maigʉ pea, baarica tabere cʉ̃ pʉtoacã yʉ duwiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simón Pedro pea yʉre ĩa cojori, “ ‘¿Ñirure mʉ ĩiti?’ cʉ̃re ĩi jãiñaña” ĩigʉ, cʉ̃ amori mena tii cõoñari, yaioroacã yʉre jãiña doti cojowi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","To biro yʉre cʉ̃ ca ĩi jãiña dotiro ĩari, yʉ pea Jesús pʉto jañuriacã waari: —Wiogʉ, ¿nii peti cʉ̃ niiti? —cʉ̃re yʉ ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","To biro yʉ ca ĩiro, Jesús pea o biro yʉre ĩi yʉʉwi: —Pan tabere weyori yʉ ca tiicojogʉ niimi —ĩiwi. To biro ĩigʉra, pan quire weyori, Simón macʉ̃ Judas Iscariote petire cʉ̃re tiicojocãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","To biro cʉ̃re cʉ̃ ca tiiro, pan quire cʉ̃ ca ñeerije menara, Judas Iscariote yeripʉre Satanás ñaajãa nʉcãcoaupi mee. To biri Jesús pea o biro cʉ̃re ĩiwi: —Mʉ ca tiipere yoari méé tiiya —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","To biro Jesús cʉ̃ ca ĩirijere, jãa, cʉ̃ buerã to ca duwirã pea, jĩcʉ̃ peera jãa tʉo majiticãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas pea jãa yee wapa tiirica tiiri ca jãñari poare ca ĩa nʉnʉjeegʉ cʉ̃ ca niiro macã, jĩcãrã jãa mena macãrã pea: “ ‘Boje rʉmʉ maquẽ apeye ʉno wapa tiigʉja,’ ĩigʉ ĩicumi,” ĩiupa. “Ape tabera, ‘Ca boo pacarãre apeye ʉno cʉ̃jare tiicojogʉja,’ ĩigʉ ĩicumi Jesús,” ĩi tʉgoeñacãupa. ");
INSERT INTO baoNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","To biri Judas pea, pan quire cʉ̃re cʉ̃ ca joa noniro, ami baa, witicoawi. To biro cʉ̃ ca bii witi waari tabere mee ñamipʉ niiwʉ yua. ");
INSERT INTO baoNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas cʉ̃ ca witi waaro jiro, Jesús pea o biro jãare ĩiwi: —Mecʉ̃ra yʉ, Ca Nii Majuropeegʉ Macʉ̃, yʉ yee ca añu majuropeerijere mʉjare yʉ ĩñorucu. Ñucã yʉ menara mʉjare bii ĩñorucu, Ʉmʉreco Pacʉ yee ca añu majuropeerije cãa. ");
INSERT INTO baoNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yʉ, Ca Nii Majuropeegʉ Macʉ̃, Ʉmʉreco Pacʉ cʉ̃ ca tutua majuropeerijere yʉ ca ĩñorore birora, Ʉmʉreco Pacʉ pee cãa, yʉ ca nii majuropeerijere ĩñorucumi. Yoari mééra teere tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yʉ puna yʉ ca mairã, mʉja menare yoaro yʉ niitirucu. Mʉja pea yʉre mʉja amamirucu, judíos're yʉ ca ĩirore birora mʉjare yʉ ĩi mecʉ̃ra: Yʉ ca waari tabepʉre mʉja waatirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","To biri ati wãme wãma wãmere mʉjare yʉ tii doti: “Mʉja ca niiro cõrora ameri maiña.” Mʉjare yʉ ca mairore birora mʉja cãa, mʉja ca niiro cõrora ameri mai niiña. ");
INSERT INTO baoNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mʉja ca niiro cõrora mʉja ca ameri mairo ĩarã, yʉ buerã mʉja ca niirijere niipetirã ĩa majirucuma —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","To biro cʉ̃ ca ĩiro, Simón Pedro pea o biro ĩi jãiñawi Jesús're: —Wiogʉ, ¿noopʉ waagʉ mʉ tiiti? —cʉ̃re ĩiwi. To biro cʉ̃re cʉ̃ ca ĩiro, Jesús pea: —Mecʉ̃ra, yʉ ca waari tabepʉre yʉre mʉ nʉnʉ waa majiti ména. Jiropʉ docare, yʉ ca waari tabepʉre yʉre mʉ nʉnʉ waarucu —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","To biro cʉ̃ ca ĩiro, Pedro pea o biro cʉ̃re ĩiwi: —Wiogʉ, ¿ñee tiigʉ mecʉ̃ra mʉre yʉ nʉnʉ waa majitigajati? Mʉ ca bii yaipa tabe ʉnorena, mʉre ca bii yai bojapʉra niicãgʉ yʉ bii yʉa —ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","To biro cʉ̃ ca ĩiro, Jesús pea: —Mʉa, ¿díámacʉ̃ra yʉre mʉ bii yai bojagʉti? Díámacʉ̃ mʉre yʉ ĩi: Ãbocʉ cʉ̃ ca wedeparo jʉguero, itiati peti, “Jesús're yʉ majiti,” mʉ ĩi ditorucu —ĩiwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Ñucã o biro jãare ĩi nʉnʉa waawi Jesús: —Tʉgoeñarique paiticãña mʉja. Tʉgoeñarique paitirãra, Ʉmʉreco Pacʉ peere díámacʉ̃ tʉo nʉnʉjee, ñucã yʉ cãare díámacʉ̃ tʉo nʉnʉjee, tiicã niiña. ");
INSERT INTO baoNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yʉ Pacʉ cʉ̃ ca niiri tabepʉre niirica taberi paʉ nii. To biro to ca biitijata, mee mʉjare yʉ wede yerijãabojacupa. To biri mʉja ca niipa taberire mʉjare queno yuegʉ waagʉ yʉ bii. ");
INSERT INTO baoNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Toopʉ waa, mʉja ca niipa tabere queno yapano, yʉ doorucu ñucã, yʉ mena mʉjare jee waarʉgʉ. O biro yʉ ca tiiro, yʉ ca niiri tabera mʉja niirucu mʉja cãa. ");
INSERT INTO baoNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Mee, mʉja maji yʉ ca waari tabepʉre ca nii eari maare —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","To biro Jesús cʉ̃ ca ĩiro, Tomás pea: —Wiogʉ, “Toopʉ waacumi,” mʉre jãa ĩi majiti. ¿Do biro pee tiicãri, tii maare jãa majibogajati? —ĩiwi Jesús're. ");
INSERT INTO baoNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","To biro cʉ̃re cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —Yʉ yʉ nii, tii maa, díámacʉ̃ wado ca ĩigʉ, caticõa niiriquere ca tiicojogʉ, yʉ jʉori wado yʉ Pacʉ pʉtopʉre ea waa majirique nii. ");
INSERT INTO baoNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Díámacʉ̃ra yʉre mʉja ca majijata, yʉ Pacʉ cãare mʉja majirucu. Mee mecʉ̃ menapʉra cʉ̃re mʉja maji yerijãa, cʉ̃re ca ĩa niirucujãrã niiri —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","To biro cʉ̃ ca ĩiro, Felipe pea o biro ĩiwi ñucã Jesús're: —Wiogʉ, mʉ Pacʉre jãare ĩñoña. Tee menara jãare añucãrucu —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","To biro cʉ̃re cʉ̃ ca ĩiro: —Felipe, yoaro mʉja mena yʉ ca nii pacaro, ¿ména yʉre mʉ majiticãti? Mee yʉre ca ĩagʉa, yʉ Pacʉ cãare ĩami. ¿Ñee tiigʉ mʉ pea, “Mʉ Pacʉre jãare ĩñoña,” yʉre mʉ ĩiti? ");
INSERT INTO baoNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Yʉ Pacʉ yʉpʉre nii, ñucã yʉ cãa yʉ Pacʉpʉre nii, jãa ca biirijere díámacʉ̃ mʉ tʉo nʉnʉjeeticãti? Mʉjare yʉ ca ĩirijere, yʉ ca tʉgoeñarora mʉjare ĩigʉ méé yʉ tii. Yʉ Pacʉ yʉpʉre ca niigʉra, cʉ̃ paderiquere tiimi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yʉa, yʉ Pacʉpʉre nii, yʉ Pacʉ pee cãa yʉpʉre nii, jãa bii, mʉjare yʉ ca ĩi wederijere díámacʉ̃ tʉo nʉnʉjeeya. Atere díámacʉ̃ mʉja ca tʉotijata, yʉ ca tii niirije jʉori pee yʉre tʉo nʉnʉjeeya petopʉra. ");
INSERT INTO baoNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","”Yee méé mʉjare yʉ ĩi: Díámacʉ̃ yʉre ca tʉo nʉnʉjeegʉa, yʉ ca tiirije cãare tiirucumi. Ñucã yʉ ca tiirije ametʉene jañuro tiirucumi. Mee, yʉ pea yʉ Pacʉ pʉto waacoagʉ yʉ bii. ");
INSERT INTO baoNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Mʉja ca jãirije cõrorena jãirã, “Jesús cʉ̃ ca dotiro mena teere yʉ ĩi” ĩicãri, Ʉmʉreco Pacʉre mʉja ca jãirijere, mʉja ca jãirore biro yʉ tiirucu, yʉ, cʉ̃ Macʉ̃ menapʉ, yʉ Pacʉ yee ca añu majuropeerijere to bii ĩñojato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","“Jesús cʉ̃ ca dotiro mena teere yʉ ĩi,” ĩiri mʉja ca jãirije cõrorena, mʉja ca jãirore biro yʉ tiirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","”Yʉre mʉja ca maijata, mʉjare yʉ ca tii doti cũurijere, yʉ ca dotirore biro mʉja tii nʉnʉjeerucu. ");
INSERT INTO baoNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yʉ pea, yʉ Pacʉpʉre apĩ yʉ jãirucu, mʉja ca tʉgoeña bayiro ca tiipʉ, mʉja mena to birora ca niicõa niipʉ, Añuri Yeri díámacʉ̃ ca ĩigʉre mʉjare cʉ̃ tiicojojato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ʉmʉreco Pacʉre ca majitirã, cʉ̃re ĩati, cʉ̃re majiti, ca biicãrã niiri cʉ̃re ñee majitima. Mʉja pea cʉ̃re mʉja maji, cʉ̃a, mʉja mena to birora niicõa niimi. Ñucã to birora mʉjapʉre niicõa niirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Biigʉpʉa, ca pacʉ dia weo ecoricarãre biro mʉjare yʉ cũutirucu. Yʉ doorucu ñucã, mʉja mena niigʉ doogʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ca yoa waatirora, Ʉmʉreco Pacʉre ca majitirã yʉre ĩa nemotirucuma. Mʉja pea yʉre mʉja ĩarucu, mʉja mena yʉ ca niirijere. Ca catigʉ niigʉ yʉ bii yʉa. To biri mʉja cãa, yʉre birora ca catirã mʉja niirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Tii rʉmʉ ca earo, yʉ, yʉ Pacʉpʉre yʉ ca niirijere, mʉja cãa yʉpʉre mʉja ca niirijere, ñucã yʉ pee cãa mʉjapʉre yʉ ca niirijere, mʉja ĩa majirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yʉ ca dotirijere tʉori, tee ca ĩirore biro ca tii nʉnʉjeegʉ niimi, díámacʉ̃ra yʉre ca maigʉ. Yʉre ca maigʉre, yʉ Pacʉ cãa cʉ̃re mairucumi. Yʉ cãa cʉ̃re mai, cʉ̃re yʉ ca mairijere cʉ̃re ĩño, yʉ tiirucu —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","To biro jãare cʉ̃ ca ĩiro, Judas (Iscariote méé pea) Jesús're o biro cʉ̃re ĩi jãiñawi: —Wiogʉ, mʉa ¿ñee tiigʉ Ʉmʉreco Pacʉre ca majitirãre, mʉ ca niirique cʉtirijere ĩñotigʉra jãa wadore mʉ ĩñogʉti? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —Yʉre ca maigʉa, yʉ wederique ca ĩirore biro tii nʉnʉjeemi. To biro ca biigʉre, yʉ Pacʉ cʉ̃re mairucumi. To biri jãa pʉarãpʉra yʉ Pacʉ mena cʉ̃ pʉtopʉ doo, cʉ̃ mena jãa niirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yʉre ca maitigʉa, yʉ wederique ca ĩirore biro tii nʉnʉjeetimi. Ano mʉjare yʉ ca ĩirijere mʉja ca tʉorijea, yʉ majurope tʉgoeñari yʉ ca wederije méé nii. Yʉ Pacʉ, yʉre ca tiicojo cojoricʉ yʉre cʉ̃ ca wede dotirije niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ména mʉja mena niigʉra, ate niipetirije mʉjare yʉ wede. ");
INSERT INTO baoNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Jiropʉra, tʉgoeña bayiricaro ca tiigʉ Añuri Yeri yʉre ca wajoagʉ, yʉ Pacʉ cʉ̃ ca tiicojogʉ niipetirije mʉjare wede majio, ñucã mʉjare yʉ ca ĩirique niipetirijere mʉja ca majiro mʉjare tii, tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","”Añuro niiriquere mʉjare yʉ cũu. Yʉ yee añuro niiriquere mʉjare yʉ tiicojo, yʉa, ati yepa macãrã cʉ̃ja ca tiicojorore biro méé mʉjare yʉ tiicojo. To biri tʉgoeñarique pai, uwi, biiticãña. ");
INSERT INTO baoNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Mee, waagʉ yʉ bii, mʉja mena niigʉ doogʉ yʉ doorucu ñucã,” yʉ ca ĩirijere mʉja tʉojãwʉ. Díámacʉ̃ra yʉre mʉja ca maijata, “Yʉ Pacʉ pʉtopʉ waagʉ yʉ tii,” yʉ ca ĩirijere tʉorã, bʉaro mʉja ʉjea niibojacupa. Cʉ̃a, yʉ ametʉenero do biro ca tiiya manigʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mee atere, tee ca biiparo jʉguero mʉjare yʉ wede majio jʉguecã, yʉ ca ĩiricarore biro to ca biiro ĩarã, “Díámacʉ̃ra manire ĩijapi,” mʉja ĩirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","”To cõrora mʉja mena yʉ wederucu. Mee, doo yerijãami ati yepa macãrãre ca doti niigʉ Satanás. Cʉ̃a, yʉre ca doti ametʉa nʉcãgʉ méé niimi biigʉpʉa. ");
INSERT INTO baoNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Biiropʉa o birora ca biipe niiro bii, ati yepa macãrã bojoca niipetirã, yʉ Pacʉre mai, yʉre cʉ̃ ca tii doti cojoricarore birora tii, yʉ ca tiirijere cʉ̃ja ca majipere biro ĩiro —jãare ĩiwi Jesús. To biro jãare ĩi yapano: —Wãmʉ nʉcãña. Jamʉ, mani waaco —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","O biro ĩi cõoña wedewi ñucã Jesús: —Yʉa, ʉje daa ca nii majuropeeri daare biro ca niigʉ yʉ nii. Yʉ Pacʉ niimi ca otegʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","To biri jĩcã dʉpʉ ca dica maniri dʉpʉ to ca niijata, tii dʉpʉre paa taa cõacãmi. To ca dica cʉtijata, tii dʉpʉri ca añutirijere paa jude bate, jee woo, tiimi, paʉ jañuro to dica cʉtijato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mee mʉja pea yʉ ca wederijere ca tʉo nʉnʉjeerã niiri, ca ñañarije manirãpʉ mʉja nii. ");
INSERT INTO baoNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Yʉ mena to birora niicõa niiña. Yʉ cãa, mʉja menara to birora yʉ niicõa niirucu. Ca dʉpʉ, ʉje daapʉre pʉto cʉtitirora, tii dʉpʉ wadora dica cʉti majiti. Tii dʉpʉ ca biirore birora, mʉja cãa yʉ mena to birora mʉja ca niicõa niitijata, añurijere mʉja tii majiticu. ");
INSERT INTO baoNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","”Yʉ yʉ nii ʉje daa ca nii majuropeeri daa. Mʉja pea ca dʉpʉrire biro ca biirã mʉja nii. Yʉ menara ca niicõa niigʉa, ñucã yʉ pee cãa cʉ̃ menara nii, yʉ ca biigʉa, paʉ añurijere tii niirucumi. Yʉ mena niitirã, do biro mʉja tiiticu. ");
INSERT INTO baoNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Yʉ mena ca niitigʉa, paa taa cõa ecori, pecamepʉ cʉ̃ja ca joepa dʉpʉ ca jini cũa yujuri dʉpʉre biiro niimi. ");
INSERT INTO baoNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Mʉja, yʉ mena to birora niicõa nii, yʉ ca wederijere yʉ ca ĩirore biiro tii nʉnʉjeecõa nii, mʉja ca biijata, mʉja ca boorijere jãiña. Mʉja tiicojo ecorucu. ");
INSERT INTO baoNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Paʉ añurije mʉja ca tii niirije mena, yʉ Pacʉ cʉ̃ ca nii majuropeerijere tii nʉcʉ̃ bʉo ecomi. O biro tiirã, yʉ buerã peti mʉja ca niirijere mʉja ĩño. ");
INSERT INTO baoNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","”Yʉ Pacʉ yʉre cʉ̃ ca mairore birora mʉjare yʉ mai. To biri mʉjare yʉ ca mairijere camotatiiticãña. ");
INSERT INTO baoNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yʉ ca doti cũurijere yʉ ca dotirore biro mʉja ca tiicõa niijata, yʉ ca mairã mʉja niirucu, yʉ cãa, yʉ Pacʉ cʉ̃ ca dotirijere tii nʉnʉjeeri, cʉ̃ ca maigʉ yʉ ca niirore birora. ");
INSERT INTO baoNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","”Atere o biro mʉjare yʉ ĩi, yʉ ca ʉjea niirore birora cʉ̃ja ʉjea niijato ĩigʉ. To biri bʉaro mʉja ʉjea niirucu. ");
INSERT INTO baoNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ate nii yʉ ca dotirije: Mʉjare yʉ ca mairore birora, mʉja cãa ameri maiña. ");
INSERT INTO baoNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Bʉaropʉra ca maigʉ niiriquea, mani mena macãrãre bii yai bojarique niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yʉ ca dotirijere mʉja ca tiijata, yʉ mena macãrã niirã mʉja bii. ");
INSERT INTO baoNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Pade coteri maja mʉjare yʉ ĩiti yua. Pade coteri majʉa, cʉ̃ wiogʉ cʉ̃ ca tiirijere majitimi. Yʉ mena macãrã mʉjare yʉ ĩi, yʉ Pacʉ yʉre cʉ̃ ca ĩirique niipetirore mʉjare yʉ ca wede peoticãrique ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Mʉja méé yʉre mʉja beje amiwʉ. Yʉ pee mʉjare beje jeeri, añurijere cʉ̃ja tiirã waajato ĩigʉ, mʉjare yʉ tiicojo cojowʉ, añurije mʉja ca tii niirije to birora to niicõa niijato ĩigʉ. O biro mʉja ca tiiro, “Jesús cʉ̃ ca dotiro mena atere yʉ ĩi,” ĩicãri cʉ̃re mʉja ca jãiro, mʉja ca jãirije niipetiro mʉjare tiicojorucumi yʉ Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Atere mʉjare yʉ tii doti: “Mʉja ca niiro cõrora ameri maiña”. ");
INSERT INTO baoNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","”Ati yepa macãrã mʉjare cʉ̃ja ca ĩa tutiro, yʉpʉrena cʉ̃ja ca ĩa tuti jʉoriquere majiña. ");
INSERT INTO baoNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ati yepa macãrã mʉja ca niijata, ati yepa macãrã mʉjare maibocuma, cʉ̃ja yaarãre cʉ̃ja ca mairore birora. Yʉ pea ati yepa macãrã watoa ca niirãre, mʉjare yʉ beje jeewʉ. To biri ati yepa macãrã mʉjare ĩa tuti jañuma, ati yepa macãrã méé mʉja ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","“Pade coteri majʉ jĩcʉ̃ ʉno peera cʉ̃ wiogʉ ametʉenero niitimi,” mʉjare yʉ ca ĩijãrijere tʉgoeñaña. Ñañaro tiirʉgarã yʉre cʉ̃ja ca nʉnʉricarore birora mʉja cãare ñañaro tiirʉgarã mʉjare nʉnʉrucuma. Yʉ ca wederijere cʉ̃ja ca tʉo nʉnʉjeericarore birora mʉja ca ĩirije cãare tʉo nʉnʉjeerucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Yʉre ca tiicojo cojoricʉre ca majitirã niiri, ate niipetirije mʉjare tiirucuma, yʉ yee quetire cʉ̃jare mʉja ca wederije jʉori. ");
INSERT INTO baoNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ati yepapʉ dooti, cʉ̃jare wede majioti, yʉ ca biijata, ñañarije ca tii wapa tuatirã niicãbojacupa. Mecʉ̃ra, cʉ̃jare yʉ ca wede majiorije ca niiro macã, “Ñañarije ca tiirã méé jãa nii,” ĩi majitima yua. ");
INSERT INTO baoNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Yʉre ca ĩa tutirã, yʉ Pacʉ cãare cʉ̃re ĩa tutirã tiima. ");
INSERT INTO baoNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Cʉ̃ja watoare, jĩcʉ̃ ʉno peera cʉ̃ ca tiitirique ʉnore cʉ̃jare yʉ ca tii ĩñotijata, jĩcã wãme ʉno peera ñañarije cʉ̃ja ca tiirijere wapa tuatibojacupa. Mecʉ̃ra yʉ ca tii niirijere ĩa yerijãama, teere ĩacã pacarã yʉre ĩa tuti, yʉ Pacʉ cãare ĩa tuti, tiima. ");
INSERT INTO baoNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Atea biiropʉa cʉ̃ja yee doti cũurique: “Ñee ʉno ñañarije ca tiitigʉrena yʉre ĩa tutiwa,” cʉ̃ja ca ĩi owarique ca ĩirore biro ca biipe niiro bii. ");
INSERT INTO baoNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","”Mʉjare ca wede majiopʉ díámacʉ̃ wado ca ĩigʉ, Añuri Yeri yʉ Pacʉ cʉ̃ ca tiicojogʉre yʉ ca tiicojo cojogʉ, yʉ Pacʉ mena ca nii jʉo dooricʉ eagʉpʉ, yʉ yee maquẽre wede majiorucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Mʉja cãa, jĩcãtopʉra yʉ mena ca nii jʉoricarã niiri, yʉ yee maquẽre mʉja wederucu. ");
INSERT INTO baoNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","”Díámacʉ̃ yʉre mʉja ca tʉo nʉcʉ̃ bʉorijere to birora mʉja ca tʉgoeña bayicõa niipere biro ĩigʉ, atere to biro mʉjare yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Juu buerica wiijeripʉra mʉjare ãcũ wienerucuma. Niirucu ñucã, no ca boorã mʉjare jĩacõari, “Ʉmʉreco Pacʉ cʉ̃ ca boorore biro tiirã mani tii,” cʉ̃ja ca ĩi tʉgoeñapa cuu. ");
INSERT INTO baoNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Atere to biro tiirucuma, yʉre majiti, yʉ Pacʉ cãare majiti, ca biirã niiri. ");
INSERT INTO baoNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Atere mʉjare yʉ wede majio, bojoca ñañaro mʉjare cʉ̃ja ca tiiri tabe ca earo, mʉjare yʉ ca wede majio yerijãariquere mʉja ca tʉgoeñapere biro ĩigʉ. ”Ate o biro mʉjare yʉ ca ĩi wederijere jĩcãtopʉre mʉjare yʉ wedetiwʉ, mʉja menara niima ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Mecʉ̃ra yʉre ca tiicojo cojoricʉ mena niigʉ waagʉ yʉ bii, mʉja pea jĩcʉ̃ ʉno peera, “¿Noopʉ mʉ waati?” yʉre mʉja ĩi jãiñati. ");
INSERT INTO baoNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yʉre jãiñaricaro ʉnora, o biro mʉjare yʉ ca ĩi wederijerena mʉja tʉgoeñarique paicoa. ");
INSERT INTO baoNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Díámacʉ̃ mʉjare yʉ ĩi: Mʉja peera mʉjare yʉ ca waa weocoaro peera añu. Yʉ ca waatijata, tʉgoeña bayiricaro ca tiigʉ mʉja mena niigʉ dootibocumi. Yʉ ca waacoajata docare, yʉ majuropeera cʉ̃re mʉjare yʉ tiicojo cojorucu. ");
INSERT INTO baoNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Cʉ̃ eagʉpʉ, ati yepa macãrãre ĩa majiricarora, cʉ̃ niimi ñañarije ca tiigʉ, cʉ̃ niimi ñañarije ca tiitigʉ, ñucã cʉ̃ niimi Ʉmʉreco Pacʉre ñañaro ca tii ecogʉ, ĩi wede majiorucumi: ");
INSERT INTO baoNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ñiru cʉ̃ niiti ñañarije ca tiigʉ: Yʉre ca tʉo nʉnʉjeetigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ñiru cʉ̃ niiti ñañarije ca tiitigʉ: Yʉ, yʉ Pacʉ pʉto ca waagʉ, mʉja pea yʉre mʉja ĩa nemotirucu yua. ");
INSERT INTO baoNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ñiru cʉ̃ niiti Ʉmʉreco Pacʉ ñañaro cʉ̃ ca tiigʉ: Ati yepare ca doti niigʉ Satanás, mee ñañaro cʉ̃ ca tiiricʉpʉ ca niigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","”Paʉ mʉjare yʉ ca ĩirʉgarije nii biiropʉa. Bʉari, mecʉ̃acãra mʉja peera paʉ peti niirore biro mʉjare biibocu. ");
INSERT INTO baoNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Añuri Yeri díámacʉ̃ ca ĩigʉ eagʉpʉ, niipetirijere díámacʉ̃ mʉjare wede majiorucumi. Cʉ̃a, cʉ̃ ca tʉgoeñari wãme wedetirucumi. Niipetirije Ʉmʉreco Pacʉre cʉ̃ ca tʉorije wadore wederucumi. To biri ñucã, jiro ca biipe cãare mʉjare wede majiorucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Yʉ yee ca niirijere jee upari mʉjare wede majio niigʉ, yʉre ĩi nʉcʉ̃ bʉo niigʉ tiirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Niipetirije yʉ Pacʉ cʉ̃ ca cʉorije yʉ yee nii. To biri, “Añuri Yeri yʉ yeere jee upari mʉjare wede majiorucumi,” mʉjare yʉ ĩijãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","”Ca yoa waatirora yʉre mʉja ĩa nemotirucu. Biirãpʉa ñucã jiro jañuroacã yʉre mʉja ĩarucu ñucã —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","To biirije Jesús cʉ̃ ca ĩi wederijere tʉorã, jĩcãrã jãa mena macãrã o biro ameri ĩi jãiñawa: —¿Do biro ĩirʉgʉ atere: “Ca yoa waatirora yʉre mʉja ĩa nemotirucu yua, manire ca ĩigʉ nii pacagʉ ñucã, jiro jañuropʉ yʉre mʉja ĩarucu ñucã, yʉ Pacʉ pʉtopʉ waagʉ yʉ ca biiro macã,” manire cʉ̃ ĩiti? ");
INSERT INTO baoNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Do biro ĩirʉgʉ, “Ca yoa waatirora,” cʉ̃ ĩiti? To biro cʉ̃ ca ĩirijere mani tʉo majiti majuropeecã —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesús pea teere cʉ̃re cʉ̃ja ca jãiñarʉga niirijere majiri, o biro ĩiwi: —Yʉa, o biro mʉjare yʉ ĩi wedejãwʉ: “Ca yoa waatirora yʉre mʉja ĩa nemotirucu. Biirãpʉa, jiro jañuroacã yʉre mʉja ĩarucu ñucã,” mʉjare yʉ ĩijãwʉ. ¿Atere mʉja ameri jãiña niiti? ");
INSERT INTO baoNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Díámacʉ̃ mʉjare yʉ ĩi: Bʉaro tʉgoeñarique pai, oti, mʉja biirucu, ati yepa macãrã pea cʉ̃ja ca ʉjea niicãro. Biiropʉa mʉja ca tʉgoeñarique paimijata cãare, mʉja ca tʉgoeñarique pairijera ʉjea niirique pee mʉjare wajoarucu. ");
INSERT INTO baoNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Jĩcõ nomio macʉ̃ cʉtirʉgo, bʉaro peti wijiomo, cõ ca macʉ̃ cʉtiri tabe ca earo. To biro bii pacago, cõ macʉ̃ cʉ̃ ca baʉaro jiropʉra, ca punirijere tʉgoeñatimo yua, jĩcʉ̃ bojocʉ ati yepapʉre cʉ̃ ca baʉarijere ĩa ʉjea niima ĩigo. ");
INSERT INTO baoNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Cõre birora mʉja cãa mecʉ̃acãre, ñañaro mʉja bii tʉgoeñarique pai. To biro mʉja ca biimijata cãare, yʉ pea jiro mʉjare yʉ ĩa nemorucu ñucã. To biro yʉ ca biiro ĩarã, mʉja yeripʉ bʉaro mʉja tʉgoeña ʉjea niirucu. Mʉja ca ʉjea niirijere jĩcʉ̃ ʉno peera mʉja ca ʉjea nii yerijãaro mʉjare tii majitirucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Tii rʉmʉ ca earopʉra, bʉaro ʉjea niima ĩirã, jĩcã wãme ʉno peera yʉre jãiñarucu, mʉja tiiticãrucu. Díámacʉ̃ mʉjare yʉ ĩi: “Jesús cʉ̃ ca dotiro mena atere yʉ ĩi,” mʉja ca ĩi jãirije cõrorena, yʉ Pacʉ mʉjare tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ména jĩcã wãme ʉno peera, “Jesús cʉ̃ ca dotiro mena atere yʉ ĩi,” mʉja ĩi jãiti. Jãiña. Jãirã mʉja bʉarucu, bʉaro ʉjea niirã mʉja ca niipere biro ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","”Atere ĩi cõoñarique mena wado mʉjare yʉ wederucujãwʉ. Biiropʉa mee ea dooro bii, ĩi cõoñarique mena mʉjare wedericaro maniro, tʉo majiricarora yʉ Pacʉ yee maquẽre mʉjare yʉ ca wede majiopa tabe. ");
INSERT INTO baoNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Tii rʉmʉre, “Jesús cʉ̃ ca dotiro mena atere yʉ ĩi,” ĩicãri, yʉ Pacʉre mʉja jãirucu yua. “Yʉ, yʉ Pacʉpʉre mʉjare yʉ jãi bojarucu,” ĩigʉ méé yʉ ĩi, ");
INSERT INTO baoNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","mee yʉ Pacʉ majuropeera mʉjare maimi. Yʉre mai, ñucã díámacʉ̃ra “Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉra niimi,” yʉre ca ĩi nʉcʉ̃ bʉorã mʉja ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yʉa, yʉ Pacʉ pʉto ca niiricʉ yʉ doowʉ, ati yepapʉre. To biri mecʉ̃ra ñucã yʉ Pacʉ pʉtopʉra tua waagʉ, ati yepa macãrãre waa weo waagʉ yʉ tii —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","To biro cʉ̃ ca ĩiro, jãa, cʉ̃ buerã pea o biro cʉ̃re jãa ĩiwʉ: —Mecʉ̃ docare yua, ĩi cõoñaricaro maniro díámacʉ̃ jãare mʉ wede. ");
INSERT INTO baoNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Mecʉ̃ra, niipetirijepʉrena mʉ ca majirijere jãa ĩa maji. To biri jĩcʉ̃ ʉno peera mʉre jãa ca jãiña bʉa ñaaro mʉ booti. Ate jʉori, “Ʉmʉreco Pacʉ pʉto ca dooricʉra niimi,” díámacʉ̃ra mʉre jãa ĩi tʉo nʉnʉjee —jãa ĩiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","To biro jãa ca ĩiro, Jesús pea o biro jãare ĩi yʉʉwi: —To docare, ¿mecʉ̃pʉ díámacʉ̃ yʉre mʉja tʉoti? ");
INSERT INTO baoNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mee earopʉ bii, mecʉ̃ra nii, mʉja niipetirãpʉra no ca boorora yʉre mʉja ca ũmaa weocoapa tabe. To biro yʉre mʉja ca bii weocãmijata cãare, yʉ jĩcʉ̃ra yʉ tuatirucu, yʉ Pacʉ yʉ menara cʉ̃ ca niicãro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ate niipetirijere to biro mʉjare yʉ ĩi wede, yʉ mena niima ĩirã, añuro niiriquere mʉja ca bʉa eapere biro ĩigʉ. Ati yepapʉre niirã, ñañaro mʉja tamʉorucu. To biro bii pacarã, tʉgoeña bayicãña. Mee, yʉa ati yepa maquẽ ñañarijere yʉ bii ametʉa nʉcãcãwʉ —jãare ĩi wedewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","To biro ĩi yapano, emʉaro pee ĩa mʉene, o biro ĩi juu buewi Jesús: —Cáacʉ, mee yʉre mʉ ca cõorica tabe eacoa. Yʉ, mʉ Macʉ̃re ĩi nʉcʉ̃ bʉoya. Yʉ, mʉ Macʉ̃ pee cãa, mʉre yʉ ĩi nʉcʉ̃ bʉorucu. ");
INSERT INTO baoNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Yʉ, mʉ Macʉ̃re, bojoca niipetirã ametʉenero doti majiriquere yʉre mʉ tiicojowʉ, yʉre mʉ ca tiicojoricarãre to birora caticõa niiriquere cʉ̃ tiicojojato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","To birora caticõa niiriquere bʉariquea ate nii: Mʉ, díámacʉ̃ra Ʉmʉreco Pacʉ jĩcʉ̃ra ca niigʉre, ñucã yʉ, Jesucristo, mʉ ca tiicojo cojoricʉ cãare ca majirã, caticõa niiriquere bʉarucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mee ati yepapʉre niigʉ, mʉre yʉ tii nʉcʉ̃ bʉo niiwʉ. Yʉre mʉ ca tii doti cojoriquere, mʉ ca tii dotirore birora yʉ tii yapano. ");
INSERT INTO baoNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Cáacʉ, mecʉ̃ra ñucã ati yepa ca niiparo jʉgueropʉra mʉ mena niigʉ ca nii majuropeegʉ yʉ ca niiricarore birora, mʉ pʉtopʉ ca nii majuropeegʉ yʉ ca niiro yʉre tiiya ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","”Ati yepa macãrãre beje jeeri, yʉre mʉ ca tiicojoricarãre mʉre cʉ̃ja ca majiro yʉ tiiwʉ. Mʉ yaarã niiwa, mʉ, cʉ̃jare yʉre mʉ tiicojowʉ, cʉ̃ja pea mʉ wederiquere tʉo nʉnʉjeewa. ");
INSERT INTO baoNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Mecʉ̃ra, niipetirije yʉre mʉ ca tiicojoriquere, mʉpʉ mʉ ca tiicojorije ca niirijere majima. ");
INSERT INTO baoNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Yʉre mʉ ca wede dotiriquere cʉ̃jare yʉ wedewʉ. Cʉ̃ja pee cãa teere yʉre tʉo nʉnʉjeewa. Mʉ pʉtopʉ ca niiricʉra yʉ ca dooriquere añuro majima. Ñucã mʉ ca tiicojo cojoricʉ yʉ ca niirije cãare díámacʉ̃ tʉo nʉnʉjeema. ");
INSERT INTO baoNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","”Cʉ̃ja yee maquẽre jãi bojagʉ yʉ ĩi. Yʉre ca tʉo nʉnʉjeetirãre jãi bojagʉ méé yʉ ĩi. Yʉre mʉ ca tiicojoricarãre yʉ jãi boja, mʉ yaarã cʉ̃ja ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Niipetirã yʉre ca tʉo nʉnʉjeerã, mʉ yaarã niima. Ñucã niipetirã mʉ ca cʉorã, yʉ yaarã niima. Ca nii majuropeegʉ yʉ ca niirijere cʉ̃ja menapʉ bojocare bii ĩño nii. ");
INSERT INTO baoNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yʉa, ati yepara yʉ niicõa niitirucu. Cʉ̃ja pee doca ati yepara tuarucuma. Yʉa, mʉ pʉtopʉ waagʉ yʉ tii. Cáacʉ ca ñañarije manigʉ, mʉ ca doti tutua niirije mena, doti tutua niirique yʉre mʉ ca tiicojorique mena, cʉ̃jare ĩa nʉnʉjeeya, jĩcʉ̃re biro mani ca niirore birora, cʉ̃ja cãa jĩcʉ̃re biro cʉ̃ja ca niipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ména ati yepare cʉ̃ja mena niigʉ, doti tutuarique yʉre mʉ ca tiicojorique mena cʉ̃jare ĩa nʉnʉjee, ñañarije cʉ̃jare ca biirʉgarijere cʉ̃jare camota boja, yʉ tii niiwʉ yʉre mʉ ca tiicojoricarãre. Cʉ̃ja mena macʉ̃ jĩcʉ̃ ʉno peera yaitiwi. Biigʉpʉa, mʉ yee quetire cʉ̃ja ca owarique ca ĩirore biro to biijato ĩigʉ, ca yaipʉ ca baʉaricʉ wado yairucumi. ");
INSERT INTO baoNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","”Mecʉ̃ra mʉ pʉtopʉra tua waagʉ yʉ tii. Biigʉpʉa atera, ati yepapʉ cʉ̃ja mena niigʉra atere to biro yʉ ĩi, cʉ̃ja cãa, yʉ ca ʉjea niirore birora cʉ̃ja ʉjea niijato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yʉre mʉ ca wede doti cojorijere cʉ̃jare yʉ wedewʉ. Yʉ cãa ati yepa macʉ̃ méé yʉ ca niirore birora, cʉ̃ja cãa ati yepa macãrã méé cʉ̃ja ca niiro macã, ati yepa macãrã mʉre ca majitirã pea cʉ̃jare ĩa tuti jañuma. ");
INSERT INTO baoNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","“Ati yepare ca niirãre mʉ pʉtopʉ yoari méé cʉ̃jare jee cojocãña,” ĩigʉ méé yʉ ĩi biigʉpʉa. “Ñañarije cʉ̃jare ca biirʉgarijere cʉ̃jare camota bojaya,” ĩigʉ pee doca, to biro mʉre yʉ ĩi. ");
INSERT INTO baoNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ati yepa macʉ̃ méé yʉ ca niirore birora, cʉ̃ja cãa ati yepa macãrã méé niima. ");
INSERT INTO baoNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Mʉ majuropeera mʉ yaarãre jee dica wooya, mʉ yee díámacʉ̃ ca niirijere ca padeparãre. Mʉ wederiquea, díámacʉ̃ ca niirije nii. ");
INSERT INTO baoNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ati yepapʉre yʉre mʉ ca tiicojo cojoricarore birora, yʉ cãa anijare cʉ̃jare yʉ tiicojo cojo, ati yepa macãrãre mʉ yeere cʉ̃ja wede majiorã waajato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Cʉ̃jare ĩima ĩigʉ yʉ majuropeera, mʉ ca tii dotiricarore biro tiirʉgʉ, ca ñañarije manigʉ ami dica wooricʉ yʉ nii ea, cʉ̃ja cãa díámacʉ̃ ca niirije queti jʉori, ca ñañarije manirã nii ea, Ʉmʉreco Pacʉ cʉ̃ ca boorije peere ca tiirã nii, cʉ̃ja ca biipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","”Anija wadore jãi bojagʉ méé, to biro mʉre yʉ ĩi. Niipetirã bojoca, yʉ yee quetire cʉ̃jare cʉ̃ja ca wedero tʉori, yʉre ca tʉo nʉnʉjeeparãpʉ cãare cʉ̃jare yʉ jãi boja. ");
INSERT INTO baoNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Cʉ̃ja niipetirãpʉre, “Añuro jĩcãri cõro cʉ̃ja niijato” ĩigʉ, atere to biro mʉre yʉ ĩi. “Cáacʉ, yʉ, mʉ mena nii, mʉ pee cãa yʉ mena nii, mani ca bii niirore birora, cʉ̃ja cãa jĩcãri cõro añuro mani mena cʉ̃ja ca niiro tiiya,” yʉ ĩi, ati yepa macãrã mʉre ca tʉo nʉnʉjeetirã, mʉ ca tiicojo cojoricʉ yʉ ca niirijere díámacʉ̃ cʉ̃ja ca tʉo nʉnʉjeepere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","”Ca nii majuropeegʉ yʉ ca niiro yʉre mʉ ca tiiricarore birora, yʉ cãa ca nii majuropeera cʉ̃ja ca niiro cʉ̃jare yʉ tiiwʉ, jĩcʉ̃re birora mani ca niirore birora, cʉ̃ja cãa jĩcʉ̃re birora cʉ̃ja niijato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yʉ pea, cʉ̃japʉre nii, mʉ pea, yʉpʉre nii, mani bii. Añuropʉra jĩcãri cõro cʉ̃ja ca nii earo cʉ̃jare tiiya. To biro mʉ ca tiiro ati yepa macãrã, mʉ ca tiicojo cojoricʉ yʉ ca niirijere, ñucã yʉre mʉ ca mairore birora cʉ̃jare mʉ ca mairijere, ĩa majirucuma. ");
INSERT INTO baoNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Cáacʉ, mʉ, yʉre mʉ ca tiicojoricarã cãa, yʉ ca niipa tabepʉra yʉ mena cʉ̃ja ca niiro yʉ boo, ca nii majuropeegʉ yʉ ca niirijere yʉre mʉ ca tiicojoriquere cʉ̃ja ĩajato ĩigʉ; mee, mʉa ati yepare mʉ ca tiiparo jʉgueropʉra yʉre mʉ mai jʉo doowʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Cáacʉ añugʉ, ména ati yepa macãrã mʉre cʉ̃ja ca majiti pacaro, yʉ pea mʉre yʉ maji. Anija yʉ mena ca niirã cãa, mʉ ca tiicojo cojoricʉ yʉ ca niirijere majima. ");
INSERT INTO baoNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʉ ca niirique cʉtirijere cʉ̃jare yʉ ĩñowʉ. Ñucã to birora yʉ ĩñocã nʉnʉa waarucu, yʉre mʉ ca mairije cʉ̃japʉre nii, ñucã yʉ majuropeecã cʉ̃japʉrena niicã, yʉ ca biipere biro ĩigʉ —ĩi juu buewi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Atere ĩi yapano, Jesús, jãa, cʉ̃ buerãre, dia maa Cedrón ape nʉñapʉ jãare jʉo waacoawi. Toopʉre niiwʉ jĩcã yepa ote yucʉ ca niiri yepa. Tii tabepʉ jãare jʉo owa waawi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, Jesús're ca wedejãa buiyee cõagʉ cãa, tii tabere majiwi, paʉ tiiri Jesús jãare cʉ̃ ca jʉo waarucurique ca niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","To biri Judas, jĩcã puna uwamarã, paia ʉparã, fariseos, cʉ̃ja ca doti cojoricarã, jĩcãrã Ʉmʉreco Pacʉ yaa wiire coteri maja mena, beju cʉticãri, jĩcãrã, ʉje pio jãari jĩa boerica coori mena jĩa boe, aperã yucʉgʉ yapa upa bʉrʉa jia tuuri jĩa boerique mena jĩa boe, ca tii dooricarã mena toopʉ eawi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Mee Jesús pea niipetirije cʉ̃re cʉ̃ja ca tiipere ca maji peoticãgʉ niiri, cʉ̃jare boca nʉcãri, o biro cʉ̃jare ĩi jãiñawi: —¿Ñirure mʉja amaati? —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","To biro cʉ̃ ca ĩi jãiñaro: —Jesús, Nazaret macʉ̃re jãa ama —ĩiwa. To biro cʉ̃ja ca ĩiro Jesús pea: —Yʉ yʉ nii —cʉ̃jare ĩiwi. Judas, Jesús're ca wedejãa buiyee cõagʉ cãa toora cʉ̃ja mena niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“Yʉ yʉ nii,” Jesús cʉ̃jare cʉ̃ ca ĩirora duwi tua tua waa, yepapʉ ñaacũmucoawa. ");
INSERT INTO baoNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesús pea ñucã: —¿Ñirure mʉja amaati? —cʉ̃jare ĩi jãiña nemowi. Cʉ̃ja pea: —Jesús, Nazaret macʉ̃re jãa ama —cʉ̃re ĩiwa ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesús pea o biro cʉ̃jare ĩiwi ñucã: —Mee, “Yʉ yʉ nii” mʉjare yʉ ĩijãwʉ. Yʉre mʉja ca amajata, anija yʉ mena macãrã peera ñeeticãña —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ate pea cʉ̃ majuropeera: “Cáacʉ, yʉre mʉ ca tiicojoricarã jĩcʉ̃ ʉno peera yaitiwa,” cʉ̃ ca ĩiricarore biro to biijato ĩiro biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","To cõrora Simón Pedro pea niipĩi ca cʉoricʉ niiri yoo wee amiri, paia wiogʉre ca pade cotegʉ Malco ca wãme cʉtigʉ amopero díámacʉ̃ nʉña peere paa taa ñoocã cojowi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","To biro cʉ̃ ca tiiro ĩari, Jesús pea: —Ca niirica tabepʉra niipĩire queno cũuña. Yʉ Pacʉra, ñañaro yʉ ca tamʉoro cʉ̃ ca boojata, cʉ̃ ca dotirore birora ñañaro yʉ ca biipera niicãro bii —ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Uwamarã cʉ̃jare dotiri majʉ mena, to biri judíos yaarã uwamarã Ʉmʉreco Pacʉ yaa wiire coteri maja mena, Jesús're ñeeri cʉ̃re jia, ");
INSERT INTO baoNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anás yaa wii pee cʉ̃re ami waa jʉowa. Cʉ̃ pea tii cʉ̃mare paia wiogʉ ca niigʉ Caifás mañicʉ niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ani Caifás pea, judíos're: “Bojoca niipetirãpʉre jĩcʉ̃ra cʉ̃ ca bii yai bojaro añu,” ca ĩi wede majioricʉra niiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jesús're cʉ̃ja ca ami waaro, Simón Pedro mena cʉ̃re jãa nʉnʉ waawʉ. Yʉ pea paia ʉpʉ cʉ̃ ca majigʉ niiri, Jesús menara paia ʉpʉ yaa wii macã yepapʉ yʉ jãacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Simón Pedro pea, macã yepapʉra tii wiire camotaarica janiro macã jopepʉra tua nʉcãcãwi. To biri yʉ pea, paia ʉpʉ cʉ̃ ca majigʉ niiri, jopere ca cotegore cõre yʉ wedegʉ waawʉ. To biro cõre yʉ ca ĩiro, Simón Pedro cãare cʉ̃re jõene cojowo. ");
INSERT INTO baoNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Jopere ca cotego pea cʉ̃ ca jãa dooro o biro cʉ̃re ĩi jãiñawo Simón Pedrore: —¿Mʉa, Jesús buerã mena macʉ̃ méé mʉ niiti? —cʉ̃re ĩiwo. To biro cõ ca ĩiro, Simón Pedro pea: —Cʉ̃ méé yʉ nii yʉa —cõre ĩicãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tii ñamire bʉaro ca yʉjʉaro macã, paia wiogʉre pade bojari maja, to biri Ʉmʉreco Pacʉ yaa wiire coteri maja mena pecame diori, to juma nucũ cojowa. To biro cʉ̃ja ca biiro, Pedro cãa cʉ̃ja mena peca juma niiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Paia wiogʉ pea Jesús're o biro cʉ̃re ĩi jãiña jʉoupi: —¿Noa ʉno peti cʉ̃ja niiti, mʉ buerã? ¿Ñee ʉnore cʉ̃jare mʉ buerucuti? —cʉ̃re ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","To biro cʉ̃re cʉ̃ ca ĩi jãiñaro, Jesús pea o biro cʉ̃re ĩiupi: —Niipetirã bojoca cʉ̃ja ca tʉo cojoropʉ yʉ wederucujãwʉ. To cãnacã tiira, nea poo juu buerica wiijeripʉ, Ʉmʉreco Pacʉ yaa wiipʉ, judíos niipetirã cʉ̃ja ca nea pooropʉ yʉ wederucujãwʉ. Jĩcãti ʉno peera yairopʉ wede, yʉ tiitirucujãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Ñee tiigʉ yʉre mʉ jãiñati? Yʉ ca wederijere ca tʉorucujãrã peere cʉ̃jare jãiñaña. Cʉ̃ja, “To biirije ĩirucujãwi,” mʉre cʉ̃ja ĩijato, cʉ̃ja majima cʉ̃jare yʉ ca wederucujãrijere —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","O biro Jesús cʉ̃ ca ĩirije menara, jĩcʉ̃ uwamʉ Ʉmʉreco Pacʉ yaa wiire ca coterã mena macʉ̃ cʉ̃ pʉto ca nucũricʉ cʉ̃ diámacʉ̃re paari, o biro ĩiupi: —¿Paia wiogʉrena o biirijera cʉ̃re mʉ ĩi yʉʉcãti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","To biro cʉ̃re cʉ̃ ca tiiro, Jesús pea o biro cʉ̃re ĩiupi: —¿Ñañarije yʉ ca ĩijata, ñee ʉno pee ñañarije yʉ ĩijãri? Yʉre wedeya. Díámacʉ̃ yʉ ca ĩirije to ca nii pacaro, ¿ñee tiigʉ yʉre mʉ paati? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","To cõrora Anás pea Jesús're cʉ̃re jiari, paia wiogʉ Caifás pʉtopʉ ami waa dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ména Pedro pea, toora peca jumacã nucũwi. Too cʉ̃ ca juma nucũrucuro: —¿Mʉ cãa, ĩi buerã mena macʉ̃ méé mʉ niicãtimiti? —cʉ̃re ĩi jãiñawa. Pedro pea: —Cʉ̃ méé yʉ nii —cʉ̃jare ĩi ditocãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","To biro cʉ̃ ca ĩiri tabera, jĩcʉ̃ paia ʉpʉre pade coteri maja mena macʉ̃ Pedro cʉ̃ ca amopero pataricʉ yee wedegʉ peti: —¿Jesús mena ote wejepʉ mʉ ca niiro, yʉ ca ĩajãgʉ méé mʉ niicãtimiti? —cʉ̃re jãiñawi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","To biro cʉ̃ ca ĩiro, Pedro pea cʉ̃re ĩi ditocãwi ñucã. To biro cʉ̃ ca ĩi niiri tabera, ãbocʉ wedecoawi yua. ");
INSERT INTO baoNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jiro, Caifás yaa wii ca niiricʉre tii yepa macãrã ʉpʉ romano cʉ̃ ca niiri wiipʉ ami waawa ñucã Jesús're. Mee ca boe mʉa doori tabepʉ ca niiro macã, judíos pea tii wiipʉ mani ca jãacoajata, mani ñicʉ̃ jãa cʉ̃ja ca biitiriquere mani biibocu, to biro biicãri Pascua boje rʉmʉ mani ca tii niirucurijere cʉ̃ja ca tiiro ñañarã nii cote, baarique cãare baati, mani biibocu ĩima ĩirã, jãa waatiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","To biro cʉ̃ja ca biiro macã, Pilato pea cʉ̃ja mena wede penigʉ doogʉ witi doori, o biro cʉ̃jare ĩi jãiñawi: —¿Anire, ñee ʉno ñañarije cʉ̃ ca tiirique jʉori cʉ̃re mʉja wedejãarã doojãri? —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","To biro cʉ̃jare cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉwa: —Ñañarije ca tiitigʉ cʉ̃ ca niijata, mʉ pʉtopʉ cʉ̃re jãa ami dootibojacupa —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","To biro cʉ̃ja ca ĩiro, Pilato pea o biro cʉ̃jare ĩiwi: —Mʉjara cʉ̃re ami waari, mʉjare ca dotirije ca ĩirore biro cʉ̃re jãiña bejeya —ĩiwi. To biro cʉ̃jare cʉ̃ ca ĩiro, judíos ʉparã pea o biro cʉ̃re ĩi yʉʉwa: —Jãa, judíos'ra, jĩcʉ̃ ʉno peerena jãa ca jĩa cõa dotirije mani —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","O biro bii eawʉ, “O biri wãme yʉ tii yaio ecorucu,” Jesús cʉ̃ ca ĩirique. ");
INSERT INTO baoNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","To biro cʉ̃ja ca ĩiro, ñucã Pilato pea cʉ̃ yaa wiipʉ jãa waa, Jesús're jʉo cojo, o biro cʉ̃re ĩi jãiñaupi: —¿Mʉa judíos wiogʉra mʉ niiti? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩiupi: —¿Teere mʉ majurope jãiñagʉ mʉ ĩiti, aperã yʉ yee maquẽre mʉre cʉ̃ja ca wederije jʉori, to biro yʉre mʉ ĩi jãiñatiqué? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","To biro Jesús cʉ̃re cʉ̃ ca ĩiro, Pilato pea o biro cʉ̃re ĩiupi: —¿To docare yʉa judío yʉ niiti? Cʉ̃ méé yʉ nii nija yʉa. Mʉ yaarãra, paia ʉparãra, yʉpʉre mʉre nonirã dooma. ¿Ñee ʉno mʉ tii bui cʉtijãri? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Ati yepa macʉ̃ wiogʉ méé yʉ nii yʉa. Ati yepa macʉ̃ wiogʉ yʉ ca niijata, yʉre ca jĩarãre cʉ̃jare ca jĩa camotaparãre yʉ cʉobocu, judíos'pʉre yʉre cʉ̃ja ca tiicojo cõatipere biro ĩigʉ. Yʉ ca doti niiri tabea ano méé nii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","To biro Jesús cʉ̃ ca ĩiro, Pilato pea o biro cʉ̃re ĩi jãiñaupi ñucã: —¿To docare mʉa wiogʉ mʉ niiti? —cʉ̃re ĩiupi. To biro cʉ̃re cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Mʉra, “Wiogʉ mʉ nii,” yʉre mʉ ĩi doca. Yʉa, aterena biirʉgʉ yʉ baʉawʉ. Ñucã aterena biirʉgʉ ati yepapʉre yʉ doowʉ, díámacʉ̃ maquẽre wede majiogʉ doogʉ. To biri díámacʉ̃ maquẽre ca amarã niipetirã, yʉ ca wederijere tʉo nʉnʉjeema —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","To biro cʉ̃ ca ĩiro Pilato pea: —¿Ñee to niiti, díámacʉ̃ maquẽ mʉ ca ĩirije? —cʉ̃re ĩi jãiñaupi Jesús're. Jesús're o biro cʉ̃re ĩi jãiña yapano, judíos mena wedegʉ witi eawi ñucã Pilato. O biro ĩiwi: —Anire jĩcã wãme ʉno peera ñañarije cʉ̃ ca tiiriquere yʉ bʉati. ");
INSERT INTO baoNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Biirãpʉa mʉja pea Pascua boje rʉmʉ ca niiro, tia cũurica wiipʉ ca niigʉre jĩcʉ̃ yʉ ca wienero mʉja ca boorucurije nii, ¿to biri ani “Ani Judíos Wiogʉre” yʉ ca wienero mʉja booti? —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","To biro cʉ̃ ca ĩi jãiñarora niipetirãpʉra o biro ĩi acaro buiwa ñucã: —¡Wieneticãña cʉ̃ra! ¡Barrabás peere wieneña! —ĩi acaro buiwa. (Barrabás pea jee dutiri majʉ niiwi.) ");
INSERT INTO baoNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","To cõrora Pilato pea Jesús're ami waari, cʉ̃re bape dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Uwamarã pea cʉ̃re bape yapano, pota mena upa beto cʉ̃ja ca quenorica betore Jesús dʉpʉgare peo, jutiro bʉaro ca jũarito, wiogʉ cʉ̃ ca jãñarito ʉno cʉ̃re jãa, tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","To biro tiicãri cʉ̃ díámacʉ̃re paarãra: —¡Judíos Wiogʉ to birora cʉ̃ caticõa niijato! —cʉ̃re ĩi bui epeupa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato pea ñucã witi doo, o biro ĩiwi judíos're: —Maa, ĩaña. Ani cʉ̃re yʉ ami witi doo, jĩcã wãme ʉno peera ñañarije cʉ̃ ca tiiriquere bʉatijapi, mʉja ca ĩi ĩa majipere biro ĩigʉ —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesús pea pota beto cʉ̃ dʉpʉgare cʉ̃ja ca peoricʉ, ñucã jutiro ca jũarito cʉ̃ja ca jãaricʉ witi eawi. To biro cʉ̃ ca biiro, Pilato pea: —Ani niimi —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Paia ʉparã, to biri uwamarã Ʉmʉreco Pacʉ yaa wiire coteri maja cʉ̃re ĩarãra, o biro ĩi acaro bui jʉo waawa: —¡Yucʉ tenipʉ cʉ̃re paa pua tuu cõacãña! ¡Yucʉ tenipʉ cʉ̃re paa pua tuu cõacãña! —ĩiwa. To biro cʉ̃ja ca ĩiro Pilato pea: —Mʉja majurope cʉ̃re ami waari, yucʉ tenipʉ cʉ̃re paa pua tuurãja. Yʉa, anira, jĩcã wãme ʉno peera ñañarije cʉ̃ ca tii bui cʉtirica wãmere yʉ bʉati —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","To biro cʉ̃ ca ĩiro, judíos ʉparã pea o biro cʉ̃re ĩi yʉʉwa: —Jãa, jĩcã wãme jãare ca dotirije jãa cʉo. To biri ca dotirije ca ĩirore biro ca boapʉ niimi, cʉ̃ majuropeera, “Ʉmʉreco Pacʉ Macʉ̃ yʉ nii,” jãare cʉ̃ ca ĩi ditorije jʉori —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","To biro cʉ̃ja ca ĩirijere tʉori, Pilato pea bʉaro jañuro uwi tʉgoeñaupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","To biri Pilato pea ñucã cʉ̃ ca niiri tabepʉ jãa waari, o biro ĩi jãiñaupi Jesús're: —¿Mʉa, noo macʉ̃ peti mʉ niiti? —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩi jãiñamijata cãare, Jesús pea cʉ̃re yʉʉtiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","To biro cʉ̃ ca biiro, Pilato pea: —¿Ñee tiigʉ yʉre mʉ yʉʉtiti? ¿Mʉa, yucʉ tenipʉ paa pua tuu cõa doticã, ñucã ñañaro cʉ̃ja ca tiirʉgarijere camota bojacã, ca tii doti majigʉ yʉ ca niirijere mʉ majititi? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","To biro cʉ̃ ca ĩiro, Jesús pea o biro cʉ̃re ĩi yʉʉupi: —Jĩcã wãme ʉno peera yʉre mʉ ca doti majirijere mʉ cʉotibojacupa, Ʉmʉreco Pacʉ mʉre cʉ̃ ca tiicojoticãjata. To biri mʉpʉre yʉre ca wedejãa buiyee cõaricʉ pee doca, mʉ ametʉenero ñañarije ca tii bui cʉtiricʉ niimi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","To biro cʉ̃ ca ĩiri tabepʉra, Pilato pea Jesús're wienerʉgʉ bʉaro tʉgoeña ama peoticãmiupi. Judíos pea yerijãari méé, o biro cʉ̃re ĩi acaro buiwa: —Cʉ̃re mʉ ca wienecãjata, César mena macʉ̃ méé mʉ nii. No ca boogʉ, cʉ̃ ca boorora wiogʉ ca jãagʉa, wiogʉ romano César waparã yʉʉ peti niigʉ biimi —cʉ̃re ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato pea o biirije cʉ̃re cʉ̃ja ca ĩiro tʉori, Jesús're ami witi waari ʉparã cʉ̃ja ca duwiri tabepʉ ea nuucoawi, ʉ̃tã mena cʉ̃ja ca tiirica tabe, arameo wederique menara Gabatá cʉ̃ja ca ĩiri tabepʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Tii rʉmʉ pea Pascua boje rʉmʉ jʉguero macã rʉmʉre jotoa decomacã cõro niiwʉ. Pilato pea o biro cʉ̃jare ĩiwi judíos're: —Ani niimi mʉja wiogʉ —cʉ̃jare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","To biro Pilato cʉ̃ ca ĩirora, cʉ̃ja pea o biro ĩi acaro buiwa: —¡Cʉ̃ boajato! ¡Cʉ̃ boajato! ¡Yucʉ tenipʉ cʉ̃re paa pua tuu cõacãña! —ĩiwa. To biro cʉ̃re cʉ̃ja ca ĩiro tʉogʉ, Pilato pea o biro cʉ̃jare ĩiwi: —¿Ñee tiigʉ mʉja wiogʉrena yucʉ tenipʉ cʉ̃re yʉ paa pua tuu cõa dotibogajati? —cʉ̃jare ĩiwi. To biro cʉ̃ ca ĩiro, paia ʉparã pea o biro cʉ̃re ĩi yʉʉwa: —Jãa, jĩcʉ̃ra jãare ca dotigʉ wiogʉ César wadore jãa cʉo —ĩiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","To biro cʉ̃ja ca ĩiro, Pilato pea Jesús're cʉ̃ja paa pua tuu cõarã waajato ĩigʉ cʉ̃jare tiicojocãwi. To biri cʉ̃ja pea Jesús're amicoawa yua. ");
INSERT INTO baoNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesús pea cʉ̃re cʉ̃ja ca paa pua tuupa teni yucʉ tenire pʉjaricʉ witi waawi, “Dʉpʉga Õaro” (hebreo wederique menara “Gólgota”) ca wãme cʉtiri tabepʉ waagʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Toopʉ cʉ̃re ami eari, pʉarã watoa cʉ̃re paa pua tuu nʉcõwa. Jĩcʉ̃ cʉ̃ díámacʉ̃ nʉña pee, apĩre cʉ̃ ãcõ nʉña pee, cʉ̃jare paa pua tuu nʉcõwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ñucã Pilato pea: JESÚS NAZARET MACɄ̃ NIIMI, JUDÍOS WIOGɄ —ĩi owa tuurique ca tujari pĩire cʉ̃ jotoare paa pua tuu doti cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","To biro ĩi owa tuurique ca tujari pĩire paʉ judíos buewa, Jesús're cʉ̃ja ca paa pua tuu nʉcõrica buuro macã pʉtoacã ca niiro macã. Tii pĩire owarique pea hebreo wederique mena, griego wederique mena, romano wederique mena, owarique niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","To biri paia ʉparã judíos pea o biro ĩiupa Pilatore: —“Judíos Wiogʉ niimi,” ĩi owa tuuticãña. “Ani niimi, cʉ̃ majuropeera, ‘Yʉ yʉ nii Judíos Wiogʉ,’ ca ĩirucugʉ,” ĩi owa tuuya —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","To biro cʉ̃ja ca ĩiro, Pilato pea: —Mee, yʉ ca owariquepʉa to birora tuaro bii —cʉ̃jare ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Uwamarã pea Jesús're paa pua tuu yapanori, cʉ̃ jutirore amiri, bapari quejeri yega batori, cʉ̃ja ca niiro cõro ameri dica woowa. Ñucã cʉ̃ jutiro doca macãro cãare ami, tiiro pea ee ãpõtĩoña maniro jĩcã daara cʉ̃ja ca juaricaro ca niiro macã, ");
INSERT INTO baoNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","uwamarã pea cʉ̃ja majurope o biro ameri ĩiwa: —Atirora mani yega bateticãjaco, “Ĩi bʉarique mena pee mani ĩijaco, ñiru peti tiirore cʉ̃ ca ĩi bʉaro,” ĩirã —ĩiwa. O biro bii eawʉ, Ʉmʉreco Pacʉ yaa pũuropʉre: “Yʉ jutiro jotoa macãrore cʉ̃ja majurope ameri dica woo, ñucã doca macãro cãare ĩi bʉarique mena ĩi bʉa, tiiwa,” cʉ̃ja ca ĩi owarique. Uwamarã o biri wãme peti tiicãwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesús're cʉ̃ja ca paa pua tuu nʉcõricaro pʉtore, cʉ̃ paco, cʉ̃ paco yee wedego Cleofas nʉmo María, to biri apeo María Magdalena, niiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesús pea cʉ̃ pacore ĩa, to biri yʉ, cʉ̃ buegʉ, bʉaro cʉ̃ ca maigʉ cõ pʉto yʉ ca niiro ĩari, o biro cõre ĩiwi cʉ̃ pacore: —Nomio, mee toora niimi mʉ macʉ̃ —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","To biro cõre ĩi yapano, yʉ, cʉ̃ buegʉ peere: —Mee toora niimo mʉ paco —yʉre ĩiwi. O biro yʉre cʉ̃ ca ĩiricaro jiro, yʉ pea, yʉ yaa wiipʉ cõre yʉ amicoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ate jiro Jesús pea, mee niipetirije Ʉmʉreco Pacʉ cʉ̃ ca dotiriquere cʉ̃ ca tii yapanocãrijere majiri, ñucã Ʉmʉreco Pacʉ wederiquere cʉ̃ja ca owa tuurica pũuropʉ ca ĩirore biro to bii yapano eajato ĩigʉ, o biro ĩiwi: —Yʉ oco jinirʉga —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Toore niiwʉ jotʉ urua ʉje oco ca piyarije ca niiri rʉ. To biri cʉ̃ja pea to biro cʉ̃ ca ĩiro tʉori, ʉje oco ca piyarijere upa jitia mena weyo, yucʉgʉ hisopogʉ dʉpʉpʉ jia tuu, Jesús ʉjerore juu tuu waa, cʉ̃ jinijato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","To biro cʉ̃ja ca tiiro, Jesús pea tee ʉje oco ca piyarijere neniña yapano, o biro ĩiwi: —Mee niipetirijepʉrena yʉ tii yapano peoticã —ĩiwi. To biro ĩi yapano cʉ̃ dʉpʉgare muu cõa yoo, bii yaicã yerijãa waawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","To biro Jesús're cʉ̃ja ca tii cõari rʉmʉ pea, Pascua boje rʉmʉ jʉguero macã rʉmʉ niiwʉ. Judíos pea cʉ̃ja ca yerijãari rʉmʉre cʉ̃ja upʉri niiquĩrique yucʉ teniripʉra ca tujaro bootiupa, cʉ̃ja ca yerijãari rʉmʉ ca nii majuropeeri rʉmʉ peti ca niiro macã. To biri, “ ‘Mʉ uwamarãre, cʉ̃ja ñicãrire paa pee, ñucã cʉ̃ja upʉri niiquĩrique cãare yoari méé jee duwio, tiirãja’ cʉ̃jare ĩi cojoya,” cʉ̃re ĩirã waaupa Pilatore. ");
INSERT INTO baoNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","To biri uwamarã cʉ̃ja pʉtopʉ doori, Jesús mena cʉ̃ja ca paa pua tuuricarã ñicãrire, ca nii jʉogʉ ñicãrire paa pee, jiro ñucã apĩ cãare paa pee, tiiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Jesús pʉto earã pea, ca bii yaicoaricʉpʉre cʉ̃re ĩawa. To biri cʉ̃ ñicãrire paa peetiwa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","To biro bii pacarã, jĩcʉ̃ cʉ̃ja mena macʉ̃ cʉ̃ jadericaro mena Jesús warure jadeocãwi. To biro cʉ̃ ca tiiro díi, oco, witiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ate yʉ ca wederijere yʉ majuropeera yʉ ĩawʉ. To biri mʉjare yʉ ca wederijea díámacʉ̃ niiro bii. Ñucã yʉ ca ĩirijea, díámacʉ̃ra ca niirijere yʉ maji, mʉja cãa, teere mʉja ca tʉo nʉnʉjeepere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Atea, Ʉmʉreco Pacʉ yee wederiquere cʉ̃ja ca owa tuurica pũuropʉre: “Jĩcã õaro ʉno peerena cʉ̃re paa peetirucuma,” cʉ̃ja ca ĩi owa jʉguequĩrique ca ĩirore biro to bii eajato ĩiro to biro biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","To biri ñucã ape tabe peera Ʉmʉreco Pacʉ wederique o biro ĩi: “Jĩcʉ̃, cʉ̃ja ca jadeoricʉre ĩarucuma,” ĩi. Tee bii earo biiupa. ");
INSERT INTO baoNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ate niipetirije ca biiro jiro José Arimatea macã macʉ̃, Jesús upʉri niiquĩriquere ami waarʉgʉ, Pilatore jãiupi. José cãa Jesucristore ca tʉo nʉnʉjeegʉ niiupi. Bii pacagʉ, bau niiro bii ĩñotiupi, ʉparã judíos're uwima ĩigʉ. Pilato, Jesús upʉrire cʉ̃ ca ami waa dotiro, José pea waa, Jesús upʉrire amicoaupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ñucã Nicodemo, jĩcãti Jesús mena ñamipʉ ca wede penigʉ earicʉ cãa, treinta y cuatro kilos cõro ca jʉti añurijere, mirrare áloe mena ayiariquere jeecãri eaupi. ");
INSERT INTO baoNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","To biri José, Nicodemo mena, juti quejerire ca jʉti añurije cʉ̃ja ca wadarique mena Jesús upʉri niiquĩriquere ũmaaupa, judíos, ca bii yairicʉre yaa cõarã cʉ̃ja ca tiirucurore biro tiirã. ");
INSERT INTO baoNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Jesús're cʉ̃ja ca paa pua tuu nʉcõrica tabere jĩcã weje ote weje niiwʉ. Tii wejepʉre niiwʉ maja ope wãma ope, ména jĩcʉ̃ ʉno peerena ca yaaya maniri ope. ");
INSERT INTO baoNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Judíos cʉ̃ja ca yerijãari rʉmʉ ea waaropʉ ca biiro macã, ñucã maja ope pee cãa pʉtoacãra ca niiro macã, tii opera Jesús're cʉ̃re yaawa. ");
INSERT INTO baoNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ape semana ca nii jʉori rʉmʉ boeri tabere, meepʉ ca naitĩa jañuropʉra María Magdalena pea Jesús're cʉ̃ja ca yaaricaro maja opepʉ ĩago waacoaupo. Toopʉ eago, maja ope jãa waarica tabere cʉ̃ja ca biaricaga ʉ̃tãga ami wooricaropʉ ca niiro ĩaupo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","To cõrora ũmaa tua doo, Simón Pedro, yʉ, Jesús bʉaro cʉ̃ ca mairicʉ mena jãa ca niiropʉ ũmaa eari, o biro jãare ĩiwo: —Mani Wiogʉ niiquĩricʉ upʉrire amicoajapa. “Too pee cʉ̃re cũujacupa,” ĩi majiña mani —jãare ĩi wedewo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","To biro cõ ca ĩiro tʉori, jãa pʉarãpʉra Simón Pedro mena, Jesús're cʉ̃ja ca yaarica opepʉre jãa ĩarã waacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Pʉarãpʉra ũmaarique mena jãa waawʉ. Yʉ pea Simón Pedro ametʉene jañuro yʉ ũmaa bayiwʉ. To biri cʉ̃ jʉguero, Jesús're cʉ̃ja ca yaarica opepʉ yʉ ũmaa eacoawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tii opepʉre eagʉ, jãa waatigʉra muu bia ĩa jõene cojogʉ, juti quejeri Jesús're cʉ̃ja ca dʉdʉarica quejeri wado ca pejaro yʉ ĩawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Yʉ jiro Simón Pedro ũmaa eawi. Ũmaa ea, cʉ̃ pea díámacʉ̃ jãacoawi maja opepʉre. Cʉ̃ cãa, Jesús're cʉ̃ja ca dʉdʉarique juti quejeri wadore ĩawi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Jesús dʉpʉgare cʉ̃ja ca ũmaarica quejero cãa, cʉ̃ upʉre cʉ̃ja ca ũmaarica quejero menara pejatiwʉ. Bojoricaropʉ tunuo peoricaro pejacãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Jiro yʉ, Simón Pedro jʉguero ca earicʉ cãa, tii ope jupeapʉre yʉ jãa waawʉ. To biro biigʉ, to biro ca biirique niipetirijere ĩa, “To birora bii,” yʉ ĩi ĩawʉ yʉ cãa. ");
INSERT INTO baoNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Teere ĩa pacarã, Ʉmʉreco Pacʉ wederiquere owa cũurica pũuropʉre, “Mesías, cʉ̃ja ca jĩa cõaricʉpʉra ca bii yairicarã watoare cati tuarucumi,” cʉ̃ja ca ĩi owaquĩriquere jãa tʉo puotiwʉ ména. ");
INSERT INTO baoNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Teere ĩa yapano, jãa yaa wiipʉ jãa tuacoawʉ ñucã. ");
INSERT INTO baoNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ména, María Magdalena pea, Jesús're cʉ̃ja ca yaarica ope pʉtopʉra oti tua nʉcãcãupo. Otigora, maja ope peere muu bia ĩa jõene cojoupo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ĩa jõene cojogo, pʉarã Ʉmʉreco Pacʉ pʉto macãrã, juti ca botirije jãñacãricarã, Jesús upʉri niiquĩriquere cʉ̃ja ca cũurica tabepʉ jĩcʉ̃ cʉ̃ dʉpʉga ca niirica tua pee, apĩ cʉ̃ dʉpori ca niirica tua pee, ca duwirãre ĩaupo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Cʉ̃ja pea toopʉ duwirãra: —Nomio, ¿ñee tiigo mʉ otiti? —cõre ĩi jãiñaupa. To biro cʉ̃ja ca ĩiro: —Yʉ Wiogʉ upʉri niiquĩriquere amicoajapa. “Toopʉ ami waajacupa,” yʉ ĩi majiti. To biri yʉ oti —cʉ̃jare ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","To biro cʉ̃jare ĩi yapano, amojode ĩagora, cõ pʉtora Jesús cʉ̃ ca nucũro ĩaupo. Cʉ̃re ĩa pacago, “Cʉ̃ra niicumi,” ĩi ĩa majiticãupo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Cõre ĩa, Jesús pea o biro cõre ĩi jãiñaupi: —Nomio, ¿ñee tiigo mʉ otiti? ¿Ñirure mʉ amaati? —cõre ĩiupi. Cõ pea, “Ote wejere ca cotegʉ niicumi” ĩi tʉgoeñari, o biro cʉ̃re ĩiupo: —Mʉra, Jesús upʉrire mʉ ca ami waajata, yʉre wedeya. Noopʉ mʉ cũujãri, yʉ cʉ̃re yʉ amigo waarucu —cʉ̃re ĩiupo. ");
INSERT INTO baoNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","To biro cõ ca ĩiro Jesús pea: —¡María! —cõre ĩiupi. To biro cʉ̃ ca ĩirora, María Magdalena pea cʉ̃ peere amojode ĩa, o biro cʉ̃re ĩiupo judíos wederique mena: —¡Raboni! —ĩiupo. (“Buegʉ,” ĩigo ĩiupo.) ");
INSERT INTO baoNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","To biro cʉ̃re cõ ca ĩirora, Jesús pea o biro cõre ĩiupi María Magdalenare: —Yʉre ñee tueneticãña. Yʉ Pacʉ pʉtopʉ yʉ tua mʉa waati ména. To biro tiitigora tua waari: “ ‘Yʉ Pacʉ, mʉja Pacʉ ca niigʉ, yʉ Ʉmʉreco Pacʉ, mʉja Ʉmʉreco Pacʉ ca niigʉ pʉtopʉ tua mʉa waagʉ yʉ bii,’ ĩijãwi,” ĩi wedegoja yʉ buerãre —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","To biro cʉ̃ ca ĩirico niiri, jãa cʉ̃ buerã ca niiricarã pʉtopʉ teere jãare queti wedego dooupo. Bʉaro ʉjea niirique mena, “¡Wiogʉre yʉ ĩajãwʉ!” jãare ĩi wede, cõre cʉ̃ ca ĩiriquere jãare wedewo María Magdalena. ");
INSERT INTO baoNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Tii rʉmʉrena, tii semanare ca nii jʉori rʉmʉ, ca naio waari tabere jãa, Jesús buerã ca niiricarã pea, judíos're uwima ĩirã, joperi biacãri jãa niiwʉ. To biro jãa ca bii niiri tabere jãa watoapʉ: —¡Añuro niirique mʉjare to niijato! —jãare ĩi añu doti, jãa nʉcã eawi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","To biro ĩigʉra cʉ̃ amorire, cʉ̃ warure cʉ̃ ca jadeorica opere, jãare ĩñowi Jesús. Jãa pea, Wiogʉre cʉ̃re ĩarã, bʉaro jãa ʉjea niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","To biro ĩicã, o biro jãare ĩiwi ñucã Jesús: —¡Añuro niirique mʉjare to niijato! Yʉ Pacʉ yʉre cʉ̃ ca tiicojo cojoricarore birora, yʉ cãa mʉjare yʉ tiicojo cojo —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","To biro ĩi, jãa jotoare puticõa peo cojogʉra: —Maa, Añuri Yerire ñeeña. ");
INSERT INTO baoNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ñañaro mʉjare ca tiirãre, to biro cʉ̃ja ca tiirijere mʉja ca acobojata, ñañarije cʉ̃ja ca tiirijere acoborucumi Ʉmʉreco Pacʉ. Ñañarije cʉ̃ja ca tiirijere mʉja ca acobotijata, Ʉmʉreco Pacʉ cãa to biro cʉ̃ja ca tiirijere acobotirucumi —jãare ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Jãa, Jesús buerã, pʉa amo peti, dʉpore pʉaga penituaro ca niirã mena macʉ̃ Tomás ca wãme cʉtigʉ, Ca Sʉ̃rʉaricʉ cʉ̃ja ca ĩigʉ pea, Jesús jãare cʉ̃ ca baua eari tabere maniwi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jiro, Tomás jãa mena cʉ̃ ca niiro, aperã Jesús buerã pea o biro cʉ̃re ĩimiwa: —Wiogʉre jãa ĩajãwʉ —cʉ̃re ĩiwa. To biro cʉ̃re cʉ̃ja ca ĩi wedero, Tomás pea o biro ĩi yʉʉwi: —Jesús amorire cʉ̃ja ca paa puarica operire ĩa, yʉ amo jũa mena tii operire juu jõene ñaati, ñucã cʉ̃ warure cʉ̃ja ca jadeorica opere yʉ amo mena juu jõene ñaati, yʉ ca biijata, “Yee méé ĩima,” mʉjare yʉ ĩi tʉo nʉcʉ̃ bʉoti majuropeecãrucu —cʉ̃jare boca ĩicãwi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jĩcã amo peti, ape amore itiaga penituaro ca niiri rʉmʉri jiro jãa, cʉ̃ buerã ca niiricarã pea, jĩcã wiipʉ jãa neawʉ ñucã. Tii tabere Tomás cãa jãa mena niiwi yua. Jesús pea joperi biarique ca nii pacaro jãa doori, jãa decomacãpʉ baua ea nʉcãri: “Añuro niirique mʉjare to niijato,” jãare ĩi añu doti jãa nʉcã eawi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","To biro ĩi yapano, Tomás're o biro ĩiwi Jesús: —Ano mʉ amo jũa mena juu jõeneri, yʉ amorire ĩaña. Ñucã mʉ amo mena yʉ warure cʉ̃ja ca jadeorica tabere juu jõenegʉ dooya. “Yee mʉja ĩi” ca ĩigʉ niiticãña. Díámacʉ̃ ca tʉogʉ niiña —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","To biro Jesús cʉ̃ ca ĩiro, Tomás pea: —¡Yʉ Wiogʉ, yʉ Ʉmʉreco Pacʉ! —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiwi Jesús pea: —¿Yʉre ĩacãripʉ “Yee méé ĩijapa” mʉ ĩiti? Ʉjea niima, ĩati pacarã díámacʉ̃ ca tʉorã —ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Biigʉpʉa Jesús, jãa cʉ̃ buerã jãa ca ĩaro, paʉ apeye ca ĩa ñaaña manirije tii bau niiwi. Tee niipetirije ati pũurore owa tuu peotiya mani. ");
INSERT INTO baoNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Atera, Jesús're, “Ʉmʉreco Pacʉ cʉ̃ ca tiicojo cojoricʉ Mesías, Ʉmʉreco Pacʉ Macʉ̃ra niimi,” ĩi tʉo nʉnʉjee, ñucã cʉ̃re tʉo nʉnʉjeeri, cʉ̃ jʉori to birora caticõa niiriquere cʉo, cʉ̃ja biijato ĩigʉ owarique nii. ");
INSERT INTO baoNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jiro ñucã, jãa, cʉ̃ buerãre, Tiberias ca wãme cʉtiri ʉtabʉcʉra tʉjaropʉ jãare baua eawi Jesús. O biri wãme biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedro mena ano cãnacãrã jãa niiwʉ: Tomás, apeyera Ca Sʉ̃rʉaricʉ cʉ̃ja ca ĩi jʉorucugʉ, Galilea yepa macã macã Caná ca wãme cʉtiri macã macʉ̃ Natanael, Zebedeo puna, to biri aperã jãa mena macãrã pʉarã, jãa niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tii tabere, Simón Pedro pea o biro jãare ĩiwi: —Wai ñeegʉ waagʉ yʉ bii yʉa —ĩiwi. To biro jãare cʉ̃ ca ĩiro: —Jãa cãa mʉ mena jãa waarucu —cʉ̃re jãa ĩiwʉ. To biro ĩi, cʉ̃ mena waa, cũmuapʉ ea jãa, jãa waacoawʉ wai ñeerã waarã. Tii ñamire wai jĩari méé jãa biicãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ca boe mʉa doori tabe, Jesús pea, tiira, ʉtabʉcʉra tʉjaro baua eawi. Jãa, cʉ̃ buerã pea, “Jesús niicumi” jãa ĩi ĩa majitiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesús pea o biro jãare ĩi jãiñawi: —Yʉ yaarã, ¿mʉja wai cʉoti téé? —jãare ĩiwi. To biro cʉ̃ ca ĩi jãiñaro: —Jãa cʉotiéé —cʉ̃re jãa ĩi yʉʉwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","To biro jãa ca ĩiro, Jesús pea: —Cũmua díámacʉ̃ nʉña pee bapigʉre cõañua cojoya. To biro tiirã mʉja wai jĩarucu —jãare ĩiwi. To biro cʉ̃ ca ĩiro, cʉ̃ ca tii dotirore biro jãa tiiwʉ jãa pea. To biro tiirã, bapigʉre paʉ wai cʉ̃ja ca yoorique ca niiro macã, do biro pee jãa tii wee pãmʉo cojo bayiticãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","To biro cʉ̃ja ca biiro ĩagʉ yʉ, cʉ̃ buegʉ, bʉaro Jesús cʉ̃ ca maigʉ pea: —¡Mani Wiogʉra niimi yʉra! —yʉ ĩiwʉ Pedrore. “Mani Wiogʉra niimi yʉra,” cʉ̃re yʉ ca ĩiro tʉogʉra, Pedro pea, cʉ̃ jutiro cʉ̃ ca tuu wee jãaricarore ami jãña, diapʉ bupu ñaañuacoawi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aperã Jesús buerã pea, jita dupari yepapʉre bapigʉ paʉ wai cʉ̃ja ca niiricʉre cũmua mena jãa wee pãa waawʉ. Tiira tʉjaro pʉto jañurora noventa metros yoarora jãa niiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","To biro bii pãa ea, maa nʉcãrã, pecame diorica pecame jotoare wai cʉ̃ja ca jʉ̃jo peoricarã, to biri pan, ca pejaro jãa ĩawʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesús pea o biro jãare ĩiwi: —Mecʉ̃acã wai mʉja ca jĩa yapanorãre jĩcãrã jee dooya —jãare ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","To biro Jesús cʉ̃ ca ĩiro, Simón Pedro pea cũmuapʉ ea jãa waa, bapigʉpʉ paʉ wai pacarã, ciento cincuenta y tres peti cʉ̃ja ca niiricʉre jita dupari yepapʉ weecã maa waawi. To cõro paʉ wai pacarã cʉ̃ja ca jãamijata cãare, bapigʉ pea yegatiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","To biro cʉ̃ ca tiiro, Jesús pea o biro jãare ĩiwi: —Baa wãcãrã dooya mʉja cãa ména —ĩiwi. Jãa, cʉ̃ buerã pea, “Wiogʉ Jesús'ra niimi,” ca ĩi majicãra niiri, jĩcʉ̃ jãa mena macʉ̃ ʉno peera, “¿Ñiru peti mʉ niiti?” cʉ̃re ĩi jãiñaticãwa. ");
INSERT INTO baoNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jiro Jesús pea doo, pan're amiri, jãare tiicojowi. Ñucã wai cãare to birora tiiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ate pea cʉ̃ ca cati tuaricaro jirore, itiati jãare cʉ̃ ca baua ea ĩñorije niiro biiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Baa wãcã yapanori jiro, Jesús pea Simón Pedrore o biro cʉ̃re ĩi jãiñawi: —Juan macʉ̃ Simón, ¿anija ametʉenero yʉre mʉ maiti? —ĩiwi. To biro cʉ̃ ca ĩiro, Simón Pedro pea o biro cʉ̃re ĩi yʉʉwi: —Wiogʉ, ʉ̃gjá. Mee mʉ maji mʉre yʉ ca mairijere —ĩiwi. To biro cʉ̃ ca ĩiro Jesús pea o biro cʉ̃re ĩiwi: —To docare, yʉre ca tʉo nʉnʉjeerãre añuro cʉ̃jare ĩa nʉnʉjeeya —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jiro ñucã: —Juan macʉ̃ Simón, ¿yʉre mʉ maiti? —cʉ̃re ĩi jãiñawi. Cʉ̃ pea: —Wiogʉ, ʉ̃gjá, mee mʉ maji mʉre yʉ ca mairijere —cʉ̃re ĩiwi. To biro cʉ̃re cʉ̃ ca ĩiro Jesús pea ñucã: —To docare yʉre ca tʉo nʉnʉjeerãre añuro cʉ̃jare ĩa nʉnʉjeeya —ĩiwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Pʉati jiro o biro cʉ̃re ĩi jãiñawi ñucã Jesús: —Juan macʉ̃ Simón, ¿yʉre mʉ maiti? —ĩiwi. Itiati peti, “¿Yʉre mʉ maiti?” Jesús cʉ̃re cʉ̃ ca ĩi jãiñarije ca niiro macã, Pedro pea tʉgoeñarique paicoawi. To biri o biro cʉ̃re ĩi yʉʉwi: —Wiogʉ, mʉa niipetirije mʉ maji. Mʉre yʉ ca mairijere mʉ maji mee —cʉ̃re ĩiwi. To biro cʉ̃re cʉ̃ ca ĩiro Jesús pea o biro cʉ̃re ĩiwi ñucã: —To docare yʉre ca tʉo nʉnʉjeerãre añuro cʉ̃jare ĩa nʉnʉjeeya. ");
INSERT INTO baoNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Díámacʉ̃ mʉre yʉ ĩi. Wãmʉ jañuri niigʉ, mʉ majuropeera juti jãñari noo mʉ ca waarʉgari tabe mʉ waarucuwʉ. Bʉcʉ nii waagʉpʉa yua, mʉ dicarire mʉ ca juu mʉenero, aperãpʉ mʉre juti jãari, mʉ ca waarʉgatiri taberena mʉre amicoarucuma —ĩiwi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesús atere ĩigʉ, “O biri wãme bii yairi, mʉ ca bii yairije mena Ʉmʉreco Pacʉre mʉ tii nʉcʉ̃ bʉorucu” ĩigʉ, to biro cʉ̃re ĩiwi Pedrore. To biro ĩi yapano: —Yʉre nʉnʉña —cʉ̃re ĩiwi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","To biro cʉ̃ ca ĩiro, Pedro pea amojode nʉcã ĩa tuenecojogʉ, yʉ, Jesús bʉaro cʉ̃ ca maigʉ, Jesús mena jĩcãri jãa ca baa duwi tʉjari tabere Jesús pʉtoacã ca duwigʉ niiri: “Wiogʉ, ¿nii peti mʉre cʉ̃ wedejãagʉti?” Jesús're ca ĩi jãiñaricʉra cʉ̃ja jiro yʉ ca nʉnʉ waaro yʉre ĩawi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Yʉre ĩa, Jesús're o biro cʉ̃re ĩi jãiñawi Pedro: —Wiogʉ, ani peera ¿do biro to biiroti? —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","To biro cʉ̃ ca ĩi jãiñaro, Jesús pea o biro cʉ̃re ĩi yʉʉwi: —Nemo yʉ ca tua doori tabepʉ to birora cʉ̃ ca caticõa niiro yʉ ca boojata, mʉ yee maquẽ méé nii. Mʉa teere tʉgoeñatigʉra yʉre nʉnʉña —cʉ̃re ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ate jʉori, Jesús're ca tʉo nʉnʉjeerã niipetirã watoapʉre, “Cʉ̃a, bii yairicaro manijagʉ,” cʉ̃ja ca ĩi niirije bate cũmucoawʉ. Jesús pea, “Cʉ̃a bii yaitirucumi” ĩigʉ méé, to biro yʉre ĩiwi. O biirije pee ĩigʉ ĩiwi: “Nemo yʉ ca tua doori tabepʉ to birora cʉ̃ ca caticõa niiro yʉ ca boojata, mʉ yee maquẽ méé nii,” ĩigʉ ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Atere, “To birora biiwʉ” ĩi wede, teere owa, ca tiigʉa, cʉ̃ra yʉ nii yʉa. To biri yʉ ca ĩariquere yʉ ca wederije díámacʉ̃ra ca niirijere mani maji. ");
INSERT INTO baoNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Biigʉpʉa Jesús, apeye paʉ tiicãwi. Cʉ̃ ca tiirique cõrorena owa nʉnʉa waajata, yʉ ca tʉgoeñajata teere owarica pũurori ati ʉmʉreco niipetiropʉrena dada ametʉacoabocu. To birora to biijato. Juan");
INSERT INTO baoNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Yʉ ca maigʉ Teófilo, yʉ ca owa jʉorica pũurore niipetirije Jesús cʉ̃ ca tii jʉoriquere, cʉ̃ ca bue majio jʉoriquere, ");
INSERT INTO baoNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","cʉ̃ yee quetire cʉ̃ ca wede doti cojoparã cʉ̃ ca bejericarãre, Añuri Yeri jʉori cʉ̃jare wede majiori jiro, ʉmʉreco tutipʉ cʉ̃ ca ami mʉa waa ecoriquepʉ yʉ owa yapano eawʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Cʉ̃ ca bii yairicaro jiro ca nii pacaro, cʉ̃ ca catirijere ĩñogʉ cʉ̃ majuropeera ĩa majiricarora bau niigʉra paʉ tiiri, cuarenta rʉmʉri peti cʉ̃jare baua ĩño nii, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽre cʉ̃jare wede, tii niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ména, cʉ̃ja mena niigʉ, Jerusalén macãrã cʉ̃jare niicã dotiupi. O biro cʉ̃jare ĩiupi: —Yʉ Pacʉ “Yʉ tiicojorucu” cʉ̃ ca ĩiriquere, mʉjare yʉ ca wederiquere yueya ména. ");
INSERT INTO baoNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yee mééra Juan, oco mena uwo coeupi. Mʉja pea, no cãnacã rʉmʉ jiro mééra, Añuri Yeri mena uwo coe ecorã doorã mʉja tii —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jesús mena ca nea pooricarã pea, o biro cʉ̃re ĩi jãiñaupa: —Wiogʉ, ¿mecʉ̃ to niiti yua, Israel yepare, ñucã cʉ̃ja majuro cʉ̃ja ca doti niiro mʉ ca tiipa rʉmʉ? —cʉ̃re ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","To biro cʉ̃ja ca ĩiro tʉogʉ, o biro cʉ̃jare ĩi yʉʉupi Jesús: —Mʉjara, tii tabe ca niiro, tii rʉmʉ ca niiro, Ʉmʉreco Pacʉ cʉ̃ majuro ca doti majigʉ niiri cʉ̃ ca tiipere, mʉja ca majipe méé nii. ");
INSERT INTO baoNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Biirãpʉa, Añuri Yeri mʉjapʉre cʉ̃ ca ñaajãa nʉcã earo, mʉja ca yeri tutuapere ñee yapanori, yʉ yee maquẽre mʉja wede yujurã waarucu. Jerusalén'ra mʉja wede jʉorucu, jiro Judea yepa, to biri Samaria yepa, jiro ati yepa niipetiropʉ yʉ yee quetire mʉja wede yuju peticã cojorucu —cʉ̃jare ĩiupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Atere ĩi yapanogʉra, cʉ̃re cʉ̃ja ca ĩarucurora, ʉmʉreco tutipʉ ami mʉa waa eco, bueri bʉrʉa cʉ̃re ca paa ũmaarora, bauticã yerijãa waaupi Jesús. ");
INSERT INTO baoNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Jesús cʉ̃ ca mʉa waaro, emʉaro pee wado cʉ̃ja ca ĩa mʉene nucũrucuro, pʉarã juti botirije jãñaricarã cʉ̃ja pʉto baua ea nʉcã eari, o biro cʉ̃jare ĩiupa: ");
INSERT INTO baoNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—Galilea macãrã, ¿ñee tiirã ʉmʉreco tuti pee mʉja ĩa mʉenecã nucũti? Ano mʉja mena ca niijãgʉ Jesús, ʉmʉreco tutipʉ ca ami mʉa waa ecojãgʉra, cʉ̃ ca mʉa waaro mʉja ca ĩajãri wãmera doorucumi ñucã —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","To cõrora Jesús cʉ̃ ca tua mʉa waaro jiro, Olivos Buuropʉ ca niiricarã, ca yoati jañuri maa pee tuacoaupa Jerusalén pee, doti cũurique yerijãarica rʉmʉre ca dotirore biro. ");
INSERT INTO baoNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Macãpʉ tua ea, wiipʉre earã, jotoa macã jawi cʉ̃ja ca niirica jawipʉ mʉa waaupa. Pedro, Santiago, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Alfeo macʉ̃ Santiago, Zelote yaa puna macʉ̃ Símon, to biri Santiago yee wedegʉ Judas, niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Cʉ̃ja niipetirã, Jesús bairã, cʉ̃ paco María, to biri aperã romiri mena to cãnacã tiira nea poori, jĩcã wãmera tʉgoeña yeri cʉtiri, to birora juu buecõa niirucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Tii rʉmʉrire Pedro, ciento veinte cõro ca niirã bojoca Jesús yee quetire ca tʉo nʉnʉjeerã watoapʉ ca niiricʉ wãmʉ nʉcã, o biro cʉ̃jare ĩi wedeupi: ");
INSERT INTO baoNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Yʉ yaarã, David niiquĩricʉ, Añuri Yeri cʉ̃ ca majiorije mena Judas, Jesús're ca ñeeparãre maa jʉgue waa, cʉ̃ ca tiipere, “O biro biirucu,” cʉ̃ ca ĩi owaricarore birora ca biipe niiupa mee. ");
INSERT INTO baoNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas cãa mani mena macʉ̃ra nii, mani ca pade niirijerena tii nemo, tii niimiwi biigʉpʉa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","To biro bii pacagʉ, Jesús're cʉ̃ ca wedejãarije wapa, wapa tiirica tiiri cʉ̃re cʉ̃ja ca tiicojorique mena waa, jĩcã yepa wapa tiiupi. Jiro cʉ̃ dʉpʉga pee ñaaduwi waa, cʉ̃ paaga yiga, cʉ̃ ʉta miji witi bate, biicã yai waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalén macãrã to biro cʉ̃ ca bii yai waariquere queti tʉori, tii yepare Acéldama wãmeo tiiupa. Cʉ̃ja wederique menara, “Díi Yepa,” ĩirʉgaro ĩi. ");
INSERT INTO baoNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Mee, to biro cʉ̃ ca biipere Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo baja peorica pũuropʉre o biro ĩi owa tuurique niiupa: “Cʉ̃ yaa wii, yucʉ mani, ca bopori yepa jeeña, to biicã yai waajato. Jĩcʉ̃ ʉno peera tii yepare cʉ̃ niiticãjato.” Ñucã, “Cʉ̃ ca pademiriquera apĩpʉ cʉ̃ pade wajoajato,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","To biri, Jesús mani mena cʉ̃ ca niiri cuu cõrora mani mena bapa cʉti nii, ");
INSERT INTO baoNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Jesús're, Juan cʉ̃ ca uwo coeri tabepʉra nii, ʉmʉreco tutipʉ cʉ̃ ca mʉa waari tabepʉ, mani mena ca niiricarã ano niima. To biri jĩcʉ̃ cʉ̃ja mena macʉ̃ mani mena Jesús cʉ̃ ca cati tuaro cʉ̃ ca ĩariquere manire ca wede nemopʉre bejerique booro bii —cʉ̃jare ĩiupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","To biro cʉ̃ ca ĩiro, pʉarãre, José cʉ̃rena ñucã Barsabás (cʉ̃ buirica wãme peera Ca Añugʉ) cʉ̃ja ca ĩigʉ, apĩ Matías're jeeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","To biro tiicã, o biro ĩi juu bueupa: —Ʉpʉ, mʉ, niipetirãre cʉ̃ja yeripʉ cʉ̃ja ca tʉgoeñarijere ca majigʉ, mʉ majuropeera anija pʉarãre, mʉ ca beje amiricʉre jãare ĩñoña, ");
INSERT INTO baoNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","cʉ̃ ca ñañarije wapa, cʉ̃ ca waapa tabepʉra waa, cʉ̃ ca bii yai weorique Judas paderique ca niimiriquere ca ĩa nʉnʉjee wajoapʉre —ĩi juu bueupa. ");
INSERT INTO baoNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","To biro ĩi yapano, “¿Niipe cʉ̃ niiti Ʉmʉreco Pacʉ cʉ̃ ca amiricʉ?” ĩi majirʉgarã, cõa peo bʉarique mena tiirã, Matías're to ca ñaapea bʉaro tiiupa. To biri Jesús buerã pʉa amo peti, dʉpore jĩcãga penituaro ca niirã mena macʉ̃ nii eaupi Matías. ");
INSERT INTO baoNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés boje rʉmʉ ca earo, niipetirã Jesucristore ca tʉo nʉnʉjeerã jĩcã tabera nea poori niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Ca niiro tʉjarora, ʉmʉrecopʉ bʉaro wino paa puu duwi doorore biro bʉjʉ duwi doo, cʉ̃ja ca niiri wiire paa puu ame jãa dadacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","To biro biirora, cʉ̃ja ca niiro cõrorena cʉ̃ja jotoarire pecame ca ʉ̃ʉrore biro ʉ̃ʉ ñaapea eaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","To biro ca biiri tabera, cʉ̃ja niipetirãpʉrena Añuri Yeri cʉ̃ja yeripʉre ñaajãa nʉcã eaupi. To biro cʉ̃ ca biirora, Añuri Yeri cʉ̃ ca boorore biro cʉ̃ja ca niiro cõrora apeye wederiquere wede jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tii rʉmʉrire Jerusalén macãre, judíos, boje rʉmʉri cõrorena ca juu buerã earucurã, niipetiri yeparipʉ macãrã ca dooricarã niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Bojoca pea ca bʉjʉrijere tʉori, nea pooma ĩirã, Jesús're ca tʉo nʉnʉjeerã cõrora, cʉ̃ja wederiquerena cʉ̃ja ca wederijere tʉori, do biro pee ĩi majitiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Do biro pee ĩi majiti, tʉo ʉcʉa biima ĩirã, o biro ameri ĩiupa: —¿Anija ano ca wede niirã niipetirã, Galilea macãrã méé cʉ̃ja niiti? ");
INSERT INTO baoNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Do biro pee biicãri, mani yee wederiquere añuro cʉ̃ja ca wedero mani tʉoti? ");
INSERT INTO baoNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anora Partia, Media, Elam, Mesopotamia, Judea, Capadocia, Ponto, Asia yepare ca niiri macãri macãrã, ");
INSERT INTO baoNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","to biri Frigia, Panfilia, Egipto, Africa macã yepari macãrã, Cirene õo peepʉ macãrã, ñucã Roma macãrã ati macãre ca niirã, jĩcãrã judíos, aperã judíos yee pee ca bii wajoaricarã, ");
INSERT INTO baoNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Creta macãrã, to biri Arabia macãrãpʉ, mani nii anora. ¡Niipetirãpʉra mani ca wederije mena Ʉmʉreco Pacʉ añurije cʉ̃ ca tiirique quetire cʉ̃ja ca wedero mani tʉo! —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Niipetirãpʉra to biro ca biirijere ĩa ʉcʉari, do biro ĩi majitima ĩirã, o biro ameri ĩi jãiñaupa: —¿O biro cʉ̃ja ca biirijea do biirije peti biro to biiti? —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Aperã pea: —Cũmurã biima —cʉ̃jare ĩi buicãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","To cõrora Pedro pea, cʉ̃ mena macãrã pʉa amo peti, dʉpore jĩcãga penituaro ca niirã mena wãmʉ nʉcã, tutuaro wederique mena o biro cʉ̃jare ĩiupi: —Mʉja judíos, to biri mʉja Jerusalén macãre ca niirã niipetirã, ano ca biirije mʉja ca ĩarijere mʉjare yʉ wede majiorʉga. To biri añuro tʉoya, ano mʉjare yʉ ca ĩipere. ");
INSERT INTO baoNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","”Anija, “Cũmurã tiima” mʉja ca ĩirã, “Cũmurã méé tiima,” cũmurica tabe ʉno méé nii, boeri tabe jiroacãra niicã ména. ");
INSERT INTO baoNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ano mʉja ca ĩarijea, ca biipere wede jʉgueri majʉ Joel, “O biro biirucu,” cʉ̃ ca ĩi owaquĩrique bii earo bii: ");
INSERT INTO baoNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“ ‘Ca tʉjari rʉmʉrire o biro biirucu,’ ĩimi Ʉmʉreco Pacʉ. Yʉ Añuri Yerire bojoca niipetirãpʉrena yʉ tiicojorucu. Mʉja puna: ʉmʉa, nomia ca biipere wede jʉguerucuma. Wãmarã, ca bii ĩñorijere ĩarucuma. Bʉcʉrã pea cʉ̃ja ca biirʉga tʉgoeñarijere quẽñarucuma. ");
INSERT INTO baoNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ñucã tii rʉmʉrire yʉre ca pade bojarã, ʉmʉa, nomia cãare yʉ Añuri Yerire yʉ tiicojorucu. To biro yʉ ca tiiro ca biipere wede jʉguerucuma. ");
INSERT INTO baoNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ʉmʉreco tutipʉre, ati yepare, uwiorije, díi, ca ʉ̃ʉrije, ca bue mʉenerije, yʉ ĩñorucu. ");
INSERT INTO baoNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Muipũ ʉmʉreco macʉ̃ naitĩacoarucumi. Ñami macʉ̃ pea, díire biro jeeñacoarucumi, Wiogʉ yaa rʉmʉ, ca nii majuropeeri rʉmʉ, ca añuri rʉmʉ ca eaparo jʉguerore. ");
INSERT INTO baoNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","To ca bii pacaro, ‘Wiogʉ wãme mena ĩicãri tii nemorique ca jãirã niipetirã ametʉarucuma,’ ĩimi Ʉmʉreco Pacʉ,” ĩiupi Joel. ");
INSERT INTO baoNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israelitas, atere añuro tʉoya: Mʉja ca ĩarora, Jesús, Nazaret macʉ̃ cʉ̃ ca doti majirijere, cʉ̃ menapʉ do biro ca tiiya manirijepʉ ĩaricaro añurije tii, ca ĩa ñaaña manirije tii bau nii, mʉja watoare cʉ̃ ca tiirije mena mʉjare ĩñowi Ʉmʉreco Pacʉ, teere añuro mʉja ca majirore birora. ");
INSERT INTO baoNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Cʉ̃re, Ʉmʉreco Pacʉ “To biro biirucumi,” cʉ̃ ca ĩiricarore birora wedejãa eco, ca biigʉre mʉja pea bojoca ñañarã jʉoripʉ cʉ̃re mʉja jĩawʉ, yucʉ tenipʉ cʉ̃re paa pua tuuri. ");
INSERT INTO baoNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","To biro mʉja ca tiicã pacaro Ʉmʉreco Pacʉ pee cʉ̃ ca cati tuaro cʉ̃re tiiri, ñañaro peti puniro bii yairiquere cʉ̃re ametʉeneupi. Bii yairique cãa, do biro pee cʉ̃re bii ametʉa nʉcã majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Wiogʉ David cãa, Jesús'rena ĩigʉ, o biro ĩiquĩupi: “Ʉpʉ to birora yʉ mena cʉ̃ ca niicõa niiro yʉ ĩawʉ. Cʉ̃, yʉre cʉ̃ ca tii nemoro jĩcã wãme ʉno peera ñañaro yʉ ca biiro yʉre tiitirucu. ");
INSERT INTO baoNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","To biri yʉ yeri ʉjea nii. Bʉaro ʉjea niirique mena yʉ baja ʉjea nii. Yʉ upʉripʉ cãa, uwiricaro maniro cʉ̃pʉre yuecõa niirucu. ");
INSERT INTO baoNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yʉ ca cati niirijere, ca bii yairicarã cʉ̃ja ca niiri tabepʉra cũu cõacã, tiitirucumi; ñucã cʉ̃re pade bojari majʉ ca ñañarije manigʉ upʉri niiquĩrique cãare ca boa yairo tiitirucumi. ");
INSERT INTO baoNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Mʉ ca boorore biro nii nʉnʉa waariquere yʉre mʉ ĩñowʉ; yʉ pʉtora mʉ ca bojoca cʉti niirije mena, bʉaro yʉ ca ʉjea niiro mʉ tiirucu,” ĩiquĩupi David, Jesús cʉ̃ ca biipere. ");
INSERT INTO baoNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Yʉ yaarã, díámacʉ̃ mʉjare yʉ wede majiorʉga, mani ñicʉ̃ David niiquĩricʉ, bii yaicoa, yaa cõa eco, cʉ̃ ca biiriquere. Mecʉ̃ripʉ cãare cʉ̃ maja ope mani watoara niicã ména. ");
INSERT INTO baoNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David niiquĩricʉa, ca biipere wede jʉgueri majʉ niiquĩupi. To biri Ʉmʉreco Pacʉ: “Yee méé mʉre yʉ ĩi,” ĩirique mena, “Mʉ pãramerã ca nii cojorãpʉre jĩcʉ̃ wiogʉ cʉ̃ ca niiro yʉ tiirucu,” cʉ̃re cʉ̃ ca ĩirijere majicãquĩupi mee. ");
INSERT INTO baoNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","To biri, Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ Mesías, ca bii yaicoaricʉpʉra cʉ̃ ca cati tuarijere ĩa jʉgueri, o biro cʉ̃ ca biiperena ĩigʉ: “Mesías, cʉ̃re cʉ̃ja ca yaa cõarica opepʉra biicã yerijãa waa, cʉ̃ upʉri niiquĩriquea tii opepʉra boa yaicoa, biitirucu,” ĩi wedequĩupi David. ");
INSERT INTO baoNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","To biri, ani Jesús'rena cʉ̃ ca cati tuaro cʉ̃re tiiwi Ʉmʉreco Pacʉ. Teere mani niipetirãpʉra “To birora biiwʉ,” ca ĩirã wado mani nii. ");
INSERT INTO baoNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Ʉmʉreco Pacʉ cʉ̃ ca tutuarije jʉori, ca nii majuropeegʉ tii eco, cʉ̃ díámacʉ̃ nʉña pee cũu eco, biiri jiro, ñucã, “Añuri Yerire mʉjare yʉ tiicojorucu,” jãare cʉ̃ ca ĩiricʉre cʉ̃ Pacʉ cʉ̃re cʉ̃ ca tiicojogʉre ñeeri jiro, cʉ̃ pea jãa niipetirãpʉre tiicojomi. Atere mecʉ̃re ĩa, tʉo, mʉja tii. ");
INSERT INTO baoNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","David'ra ʉmʉreco tutipʉ mʉa waatiupi. Biiti pacagʉ o biro ĩiupi: “O biro ĩiwi Ʉpʉ yʉ Wiogʉre, ‘Yʉ díámacʉ̃ nʉña pee duwiya, ");
INSERT INTO baoNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","mʉ waparãre cʉ̃ja ca doca cũmuro yʉ ca tiiropʉ,’ ĩiupi.” ");
INSERT INTO baoNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Mʉja Israel yaa pooga niipetirã, atere añuro majiña, yucʉ tenipʉ mʉja ca paa pua tuu jĩa cõajãgʉ Jesús'rena, Wiogʉ, Mesías, cʉ̃ ca niiro tiimi Ʉmʉreco Pacʉ —cʉ̃jare ĩiupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","To biirije Pedro cʉ̃ ca ĩiro tʉorã, too ca nea pooricarã pea, niipetirãpʉra bʉaro tʉgoeñarique pai ametʉacoari, Pedrore, ñucã cʉ̃ mena macãrãre o biro ĩiupa: —Jãa yaarã, ¿ñee ca tiiparã jãa niiti? —cʉ̃jare ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","To biro cʉ̃ja ca ĩiro, o biro cʉ̃jare ĩi yʉʉupi Pedro: —Ñañarije mʉja ca tiirucurijere tʉgoeña yeri wajoari Ʉmʉreco Pacʉ peere tʉo nʉnʉjee, mʉja ca niiro cõrora Jesucristo wãme mena uwo coe dotiya, mʉja ca ñañarijere Ʉmʉreco Pacʉ cʉ̃ ca acobopere biro ĩirã. To biro mʉja ca tiiro, cʉ̃ pea Añuri Yerire mʉjare tiicojorucumi. ");
INSERT INTO baoNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ate, “O biro yʉ tiirucu,” cʉ̃ ca ĩiriquea, mʉja yee, mʉja puna yee, ñucã yoaroripʉ ca niirã niipetirã Ʉpʉ mani Ʉmʉreco Pacʉ cʉ̃ ca jʉorʉgarã yee, niiro bii atea —cʉ̃jare ĩiupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ate, ñucã apeye paʉ wãmeri mena cʉ̃jare wede majio, o biro cʉ̃jare ĩi wedeupi Pedro: —¡Anija bojoca ñañarãre camotatiya! —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","To biri, Pedro cʉ̃ ca wederijere ca tʉo nʉnʉjeericarã, uwo coe ecoupa. Tii rʉmʉre Jesucristore ca tʉo nʉnʉjeerã, itia mil peti nii nemo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Cʉ̃ja niipetirã, Jesús, cʉ̃ yee quetire cʉ̃ ca wede doti cojoricarã cʉ̃jare cʉ̃ja ca bue majiorijere añuro tʉo nʉnʉjee, cʉ̃ja ca cʉorijere ameri dica woo, ñucã jĩcãri mena juu bue, pan dica woo baa, tiirʉgarã nea poo, biicã niirucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesús, cʉ̃ yee quetire cʉ̃ ca wede doti cojoricarã, paʉ wãmeri ca ĩa ñaaña manirije cʉ̃ja ca tii bau niirijere ĩarã, niipetirãpʉra do biro pee ĩi majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Jesús're ca tʉo nʉnʉjeerã niipetirãpʉra jĩcãri mena nii, cʉ̃ja ca cʉorije mena cʉ̃ja majurope ameri dica woo, tii niirucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Cʉ̃ja yee ca niirijere, cʉ̃ja ca apeye cʉti niirijere, noni wapa jeeri, cʉ̃ja ca boorije ea tuaro, wapa tiirica tiirire ameri dica woorucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","To cãnacã rʉmʉra Ʉmʉreco Pacʉ yaa wiipʉ neacõa niirucuupa. Ñucã cʉ̃ja yaa wiijeri cõro añuro yeri ʉjea niirique mena pan're baa, baarique cʉ̃ja ca cʉorijere jĩcãri mena ameri dica woo baa, ");
INSERT INTO baoNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo baja peo, ñucã niipetirã bojoca cʉ̃jare añuro cʉ̃ ca ĩa mairijere bii ʉjea nii, bii niirucuupa. To cãnacã rʉmʉra aperã, Jesucristore ca tʉo nʉnʉjeerã, cʉ̃ja ca nii nemo nʉnʉa waaro cʉ̃jare tiiupi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Jĩcã rʉmʉ, Pedro, Juan, yucʉ jotoa muipũ cʉ̃ ca tʉja duwi waaro juu buerica tabe ca niiro, Ʉmʉreco Pacʉ yaa wiipʉ juu buerã waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ʉmʉreco Pacʉ yaa wii jope, Añuri Jope ca wãme cʉtiri jope pʉtore, baʉagʉpʉra ca bʉʉricʉ ca niiricʉre to cãnacã rʉmʉra cʉ̃re ami waari, tii wii ca jãa waarãre wapa tiirica tiiri cʉ̃ jãijato ĩirã, cʉ̃ja ca cũuricʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Cʉ̃ pea Pedro, Juan, Ʉmʉreco Pacʉ yaa wiipʉre jãa waarã doorã cʉ̃ja ca biiro ĩari, wapa tiirica tiire cʉ̃jare jãiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","To biro cʉ̃jare cʉ̃ ca ĩiro, cʉ̃ja pea añuro cʉ̃re ĩa ãpõtĩo, o biro cʉ̃re ĩiupi Pedro: —Jãare ĩaña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","To biro cʉ̃re cʉ̃ ca ĩiro, ca bʉʉricʉ pea: “Apeye ʉno yʉre tiicojorã doorã tiicuma,” ĩigʉ, cʉ̃jare ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","To cõrora Pedro pea o biro cʉ̃re ĩiupi: —Wapa tiirica tiiri ʉnora, oro ʉnora, yʉ cʉoti. Biigʉpʉa, yʉ ca cʉorijera mʉre yʉ tiicojorucu: “Jesucristo, Nazaret macʉ̃ cʉ̃ ca dotiro mena, ‘Wãmʉ nʉcã waagʉja,’ mʉre yʉ ĩi” —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","To biro cʉ̃re ĩigʉra, cʉ̃ amo díámacʉ̃ nʉñare ñeeri, cʉ̃re tʉ̃a wãmʉo nʉcõcãupi. To biro cʉ̃re cʉ̃ ca tiirije menara, cʉ̃ ñicãri, cʉ̃ aña tĩigaari cãa, tutuacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","To cõrora ca bʉʉricʉ pea bupu wãmʉ nʉcã waari, waa jʉo waaupi. Jiro, Ʉmʉreco Pacʉ yaa wiipʉ cʉ̃ja mena jãa waagʉ cʉ̃ majurope bupurique mena jãa nʉnʉa waa, Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo, ĩi jãa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Niipetirã, ca waatimiricʉra waa, Ʉmʉreco Pacʉre ĩi nʉcʉ̃ bʉo baja peo, cʉ̃ ca tiiro ĩarã: ");
INSERT INTO baoNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","—Ʉmʉreco Pacʉ yaa wii jope, “Añuri Jope” ca wãme cʉtiri jope pʉto wapa tiirica tiiri ca jãi duwirucujãgʉra niimi —ĩi ĩa majiri, bʉaro ĩa ʉcʉa do biro pee ĩi majiticãupa, to biro cʉ̃re ca biirique jʉori. ");
INSERT INTO baoNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Ca bʉʉricʉre cʉ̃ja ca catioricʉ pea, Pedro, Juan're camotatiitiupi. Niipetirã bojoca to biro ca biirijere ĩa ʉcʉa niirãra, Ʉmʉreco Pacʉ yaa wii, Salomón yaa tabe Pórtico de Salomón Pedro, Juan, cʉ̃ja ca niiri tabe cʉ̃ja pʉto pee ũmaa nea poo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","To biro cʉ̃ja ca biiro ĩari, o biro cʉ̃jare ĩiupi Pedro: —Mʉja israelitas, ¿ñee tiirã mʉja ĩa ʉcʉati? ¿Ñee tiirã jãa majuropeera jãa ca yeri tutuarije mena, ñucã cʉ̃re mai ĩama ĩirã ani ca bʉʉricʉre cʉ̃ ca waa majiro jãa ca tiirore biro, jãare mʉja ĩati? ");
INSERT INTO baoNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Isaac, Jacob jãa, Ʉmʉreco Pacʉ, mani ñicʉ̃ jãa Ʉmʉreco Pacʉ, cʉ̃ paderi majʉ Jesús, ʉparãpʉre mʉja ca tiicojo cõagʉre, ñucã Pilato pee cʉ̃ ca wienerʉga pacaro mʉja ca bootigʉre ca nii majuropeegʉ cʉ̃ ca niiro cʉ̃re tiijapi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ca añugʉ, ca ñañarije manigʉ, ca niigʉ peere junacãri, bojoca ca jĩagʉ peere mʉja wiene dotiwʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","To biro tiiri mʉja jĩa cõawʉ, catirique manire ca tiicojogʉre. To biro mʉja ca tiimijata cãare, Ʉmʉreco Pacʉ pea cʉ̃re catiocãwi, to biro cʉ̃ ca tiirijere ca ĩaricarã, “Jãara jãa nii.” ");
INSERT INTO baoNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ano mʉja ca ĩagʉ, mʉja ca majigʉre, cʉ̃ upʉri ca tutuaro ca tiirijea, Jesucristore díámacʉ̃ tʉo nʉcʉ̃ bʉoriquera to biro tii. Ate Jesucristore díámacʉ̃ tʉo nʉcʉ̃ bʉorique ca doorijera, añuro diarique manigʉpʉ cʉ̃ ca niiro tii, ano mʉja niipetirã mʉja ca ĩarore birora. ");
INSERT INTO baoNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","”Yʉ yaarã, mee yʉ maji. Mʉja, mʉja wiorã, Jesús're jĩarã, to biro mʉja ca tiirijere majiti pacarã to biro cʉ̃re mʉja tiicãwʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Biiropʉa, ate mena, mee tĩrʉmʉpʉra cʉ̃ yee quetire wede jʉgueri maja niipetirã mena, “Yʉ ca tiicojo cojogʉ Mesías bii yaicoarucumi,” Ʉmʉreco Pacʉ cʉ̃ ca ĩi jʉguericarore birora bii earo biiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","To biri ñañarije mʉja ca tiirijere to cõrora tii yerijãa tʉgoeña wajoa, Ʉmʉreco Pacʉre tʉo nʉnʉjeeya, mʉja ca ñañarijere cʉ̃ acobojato ĩirã. To cõro docare Ʉpʉ, añuro niirica yʉteari tiicojorucumi, ");
INSERT INTO baoNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","mʉjare ĩima ĩigʉ mee jĩcãtopʉra cʉ̃ ca ami dica wooricʉ Mesías're cʉ̃ra Jesús ca niigʉre mʉjare tiicojori. ");
INSERT INTO baoNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ména mecʉ̃ra Jesucristo, ʉmʉreco tutipʉra cʉ̃ ca niipera niicãro bii, tĩrʉmʉ macã yʉtearipʉre ca dooquĩricarã, Ʉmʉreco Pacʉ, cʉ̃ yeere wederi maja ca ñañarije manirã mena, “To biro yʉ tiirucu” cʉ̃ ca ĩiricarore birora, niipetirijepʉrena añuro ca nii earo cʉ̃ ca tiiri tabepʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Mani ñicʉ̃ jʉ̃mʉare o biro ĩi wedequĩupi Moisés: “Ʉpʉ mʉja Ʉmʉreco Pacʉ, jĩcʉ̃ Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ, yʉre biro ca biigʉre mʉja watoare cʉ̃ ca nii earo tiirucumi. Mʉjare cʉ̃ ca wederije niipetirije cʉ̃re tʉo nʉnʉjeeya. ");
INSERT INTO baoNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Cʉ̃, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ cʉ̃ ca ĩirijere ca tʉo nʉnʉjeetigʉra, jĩa cõacãrique niirucu” ĩiquĩupi Moisés. ");
INSERT INTO baoNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","”Ñucã niipetirã Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja niiquĩricarã, Samuel jiro macãrã niipetirãpʉra ati rʉmʉri o biro ca biiperena wedequĩupa cʉ̃ja cãa. ");
INSERT INTO baoNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Mʉjara mʉja nii, Ʉmʉreco Pacʉ, cʉ̃ yee quetire wede jʉgueri maja mena: “To biro yʉ tiirucu” cʉ̃ ca ĩiriquere cʉo nʉnʉjee, ñucã Ʉmʉreco Pacʉ mʉja ñicʉ̃ jʉ̃mʉa niiquĩricarãpʉre: “O biro mani tii niijaco” cʉ̃ ca ĩiriquere cʉo nʉnʉjee, ca tiirã. Ʉmʉreco Pacʉ o biro ĩiupi Abraham're: “Mʉ pãrami jʉori niipetirã ati yepa macãrã bojoca poogaari añuro tii ecorucuma,” ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","To biro ca ĩiricʉ niiri, Ʉmʉreco Pacʉ, cʉ̃ Macʉ̃re cʉ̃ ca cati tuaro tiiri, mʉjare tiicojo jʉoupi, añuro mʉjare tii, mʉja cõrorena ñañaro mʉja ca tiirucuriquere to cõrora tii yerijãa, tʉgoeña wajoa mʉja ca biipere biro ĩigʉ —cʉ̃jare ĩi wedeupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ména, Juan, Pedro, bojocare o biro cʉ̃ja ca wede niirora, paia, Ʉmʉreco Pacʉ yaa wiire ca coterã uwamarã wiogʉ mena, to biri Saduceos mena eaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro, Juan, “Ca bii yairicarã cʉ̃ja ca cati tuarije Jesucristo menara bii bau niicãupa,” bojocare cʉ̃ja ca ĩi wederije jʉori bʉaro ajiaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","To biri cʉ̃jare ñee, ñamipʉ ca niiro macã, ape rʉmʉpʉ cʉ̃jare jãiñarʉgarã tia cũurica wiipʉ cʉ̃jare tia cũucãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","To ca bii pacaro, Pedro cʉ̃ ca wederijere ca tʉoricarã paʉ tʉo nʉnʉjeeupa. To biri Jesús're ca tʉo nʉnʉjeerã ʉmʉa wadora, jĩcã amo cõro mil cõro peti eacoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ape rʉmʉ peere Jerusalén're judíos wiorã, bʉcʉrã ca jʉo niirã, doti cũuriquere ca jʉo buerã, neaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Paia wiorã Anás, Caifás, Juan, Alejandro, to biri paia ʉparã yaarã ca niirã niipetirã, toore niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nea poo yapano, tia cũurica wiipʉ ca niirã, Pedro, Juan're ami doo doti, cʉ̃ja jʉguero cʉ̃jare nʉcõri, o biro ĩi jãiña jʉo waaupa: —¿Ñee doti majirique mena, ñiru wãme mena, atere to biro mʉja tiijãri? —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","To biro cʉ̃ja ca ĩi jãiñaro Pedro pea, Añuri Yeri cʉ̃re cʉ̃ ca majiorije mena, o biro cʉ̃jare ĩi yʉʉupi: —Bojocare ca doti niirã, to biri Israel macãrãre ca jʉo niirã: ");
INSERT INTO baoNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Mʉja, mecʉ̃re, ca diarique cʉtigʉre añuro jãa ca tiirique jʉorira jãare jãiña, “¿Do biro cʉ̃ tii catio ecojãri?” jãare ĩi jãiña, mʉja ĩi. ");
INSERT INTO baoNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","To biri mʉja niipetirã mʉja ca tʉo cojoro, ñucã Israel yepa macãrã niipetirã cʉ̃ja ca majipere biro ĩirã, ani ca bʉʉricʉ ca niimiricʉ, mʉja niipetirã mʉja ca ĩa cojoro ca niigʉa, Jesucristo Nazaret macʉ̃, yucʉ tenipʉ mʉja ca paa pua tuu cõaricʉrena, Ʉmʉreco Pacʉ cʉ̃ ca cati tuaro cʉ̃ ca tiiricʉ cʉ̃ ca doti tutuarije mena catio ecojãwi. ");
INSERT INTO baoNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesucristoa, “Mʉja, wiijeri tiiri maja, ʉ̃tãga ca añutiricare mʉja ca beje cõamiricagara, mecʉ̃ra yua ʉ̃tãga ca nii majuropeerica ca nii earicʉ, niimi.” ");
INSERT INTO baoNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","To biri apĩ jĩcʉ̃ ʉno peera ñañaro mani ca biipere manire ca ametʉenegʉ manimi. “Ñañaro cʉ̃ja ca bii yaiboriquere cʉ̃ jʉori ametʉarucuma,” ĩigʉ Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉ, ati yepa niipetiropʉrena apĩ manicãmi —cʉ̃jare ĩi yʉʉupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ʉparã pea, Pedro, Juan, uwi tʉgoeñaricaro maniro cʉ̃ja ca wedero ĩarã, ca buetiricarã nii, watoa macãrãra niicã, cʉ̃ja ca biirijere ĩa maji, ñee pee ĩi majiticã, biima ĩirã, “Jesús buerãra niima,” ĩi majiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ñucã ca bʉʉricʉre cʉ̃ja ca catioricʉ pee cãa cʉ̃ja menara cʉ̃ ca niiro macã do biro pee cʉ̃jare ĩi boca yʉʉ majiticãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Do biro pee cʉ̃jare ĩi majitima ĩirã, cʉ̃jare witi waa doti, too ca nearicarã wado o biro ameri ĩi wede peni niiupa: ");
INSERT INTO baoNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—¿Anijare do biro mani tiirãti? Jerusalén macãrã niipetirãpʉra ca bʉʉricʉre cʉ̃ja ca catioriquere maji peticãma. “To biro biicãro bii, yee ĩima,” mani ĩi majiti. ");
INSERT INTO baoNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ate bojoca watoare õo jañuro bii jeja nʉcã waare ĩirã, Jesús yeere jĩcʉ̃ peerena cʉ̃ja ca wedetipere biro ĩirã, “Ñañaro mʉjare jãa tiirucu,” cʉ̃jare mani ĩi uwiojaco —ameri ĩi wede peniupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","To biro ĩicãri, cʉ̃jare jʉo cojo: —Jesús yee maquẽre jĩcã wãme ʉno peera bue, wede majio, tii nemoticãña yua —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","To biro cʉ̃ja ca ĩiro, Pedro jãa pea o biro cʉ̃jare ĩi yʉʉupa: —¿Mʉjara, Ʉmʉreco Pacʉ cʉ̃ ca ĩa cojorore Ʉmʉreco Pacʉ cʉ̃ ca dotirije peere tʉo nʉnʉjeetirãra, mʉja ca dotirije peere jãa ca tʉo nʉnʉjeero, to añucãgajati? Mʉja majuropeera tʉgoeña bejeya. ");
INSERT INTO baoNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Jãa, jãa ca ĩariquere, jãa ca tʉoriquere, jãa wede yerijãa majiti —cʉ̃jare ĩi yʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","To biro cʉ̃jare cʉ̃ ca ĩi yʉʉrijere tʉorã, ʉparã pea ñucã: —Teere mʉja ca wedejata, ñañaro mʉja tii ecorucu —cʉ̃jare ĩi nemo, cʉ̃jare piticãupa. Ñañaro cʉ̃jare cʉ̃ja ca tiipa wãmere do biro pee tii bʉaticãupa, niipetirã bojoca ca biirique cʉ̃ja ca ĩariquere Ʉmʉreco Pacʉre cʉ̃ja ca ĩi nʉcʉ̃ bʉo niiro macã. ");
INSERT INTO baoNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ca bʉʉricʉre cʉ̃ja ca catioricʉ pea, cuarenta cʉ̃mari ametʉenero ca cʉogʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro, Juan jãa cʉ̃jare cʉ̃ja ca wienero jiro, ñucã cʉ̃ja mena macãrã pʉtopʉ tua waari, niipetirije paia wiorã, to biri bʉcʉrã bojocare ca jʉo niirã cʉ̃jare cʉ̃ja ca ĩirique niipetirije cʉ̃jare wedeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Teere cʉ̃ja ca wedero tʉori jiro, jĩcãri mena o biro Ʉmʉreco Pacʉre ĩi juu bueupa: —Niipetirije Ʉpʉ, ati ʉmʉrecore, ati yepare, dia pairi yaare, to biri teepʉre ca niirije niipetirije ca tiiricʉ, ");
INSERT INTO baoNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Añuri Yeri menapʉ, mʉre pade bojari majʉ jãa ñicʉ̃ David menapʉ, o biro mʉ ĩiupa: “¿Ñee tiirã bojoca poogaari to cõro peti cʉ̃ja wede mecʉ̃ti? ¿Ñee tiirã bojoca, watoa petira “O biro mani tiijaco,” cʉ̃ja ĩiti? ");
INSERT INTO baoNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wiorã, ati yepare ca doti niirã, jĩcãri mena Ʉmʉreco Pacʉ menare to biri mʉ ca beje amiricʉ Mesías menare, ĩa junama.” ");
INSERT INTO baoNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","To birira Herodes, Poncio Pilato, judíos, judíos ca niitirã mena, ati macãre nea pooupa, mʉ ca beje amiricʉ Jesús, ca ñañarije manigʉ, mʉre pade bojari majʉre ĩa junari, ");
INSERT INTO baoNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","tĩrʉmʉpʉra “To biro biirucu,” mʉ ca ĩiricarore birora, to biijato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ʉpʉ, mecʉ̃ra ñañaro jãare cʉ̃ja ca tiirʉgarijere ĩaña. Mʉ paderi majare uwiricaro maniro mʉ yeere jãa ca wede yujuro jãare tiiya. ");
INSERT INTO baoNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","To biri mʉ ca yeri tutuarije mena ca diarique cʉtirãre catio, ñucã mʉre pade bojari majʉ ca ñañarije manigʉ Jesús wãme mena, ca ĩa ñaaña manirije jãa ca tii maji niiro tiiya —ĩi juu bueupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Cʉ̃ja ca juu bue yapanorora, cʉ̃ja ca niiri tabe bʉaro nanaupe. To biro ca biiro, niipetirãpʉra Añuri Yeri cʉ̃ja yeripʉre cʉ̃ ca ñaajãa nʉcã earo, uwiricaro maniro Ʉmʉreco Pacʉ wederiquere wede yujuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jesucristore ca tʉo nʉnʉjeerã niipetirã jĩcʉ̃ peere birora bii, jĩcãri cõro tʉgoeña biiupa. Jĩcʉ̃ peera cʉ̃ja ca cʉorijere, “Yʉ yee wado nii,” ĩiricaro maniro, “Mani niipetirã yee niiro bii,” ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesús yee quetire wederi maja pea, Wiogʉ Jesús cʉ̃ ca cati tuarique quetire do biro tiiya maniro to birora wedecã nʉnʉa waaupa. Ʉmʉreco Pacʉ pea cʉ̃ja niipetirãpʉrena bʉaro jañuro, añuro cʉ̃jare tii nemo nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Cʉ̃ja watoare jĩcʉ̃ ʉnora ca boo pacagʉ maniupi. Yepari ca cʉorã, ñucã wiijeri ca cʉorã, aperãre noni wapa jeeri, ");
INSERT INTO baoNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","wapa tiirica tiirire Jesús buerãre tiicojori, bate dotirucuupa cʉ̃ja ca niiro cõrorena, cʉ̃ja ca cʉotirijere cʉ̃ja jeejato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","To birora tiiupi, Leví yaa puna macʉ̃ José ca wãme cʉtigʉ, Chipre yucʉ pooga macʉ̃, Jesucristo yee quetire wederi maja, Bernabé cʉ̃ja ca wãmeo tiiricʉ cãa, (Bernabé ĩiro, “Tʉgoeña bayiricaro ca tiigʉ,” ĩirʉgaro ĩi), ");
INSERT INTO baoNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","cʉ̃ yaa yepare aperãre noni wapa jeeri, wapa tiirica tiirire Jesús buerãpʉre tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ananías, cʉ̃ nʉmo Safira mena, cʉ̃ja cãa, cʉ̃ja yaa yepare noniupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Cʉ̃ nʉmo Safira mena, “To biro mani tiijaco,” ameri ĩi wede peniri, wapa tiirica tiirire jee dʉori, ca dʉjarijere Jesús buerãre noniupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pedro pea o biro ĩi jãiñaupi Ananías're: —Ananías, ¿ñee tiigʉ Satanás mʉ yeripʉ ñaajãa nʉcãri mʉre doti ametʉene nʉcã, Añuri Yerire ĩi dito, mʉ yaa yepare mʉ ca noni wapa taarique wapa tiirica tiirire jee dʉo, tee mena tua, mʉ ca tiiro cʉ̃ tiijãri? ");
INSERT INTO baoNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Mʉ ca noniparo jʉguero, mʉ yaa yepa méé to niijãri? ¿Mʉ ca noniro jiro, wapa tiirica tiiri mʉ yee méé to niijãri? ¿Ñee tiigʉ to biirije peti mʉ tiicãjãri? Bojocare ĩi ditogʉ méé mʉ tii. Ʉmʉreco Pacʉre ĩi ditogʉ mʉ tii —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","O biirije Pedro cʉ̃re cʉ̃ ca ĩirijere tʉogʉra, dia ñaacũmucoaupi Ananías. Niipetirã to biro ca biiriquere ca tʉorã, bʉaro uwiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","To biro cʉ̃ ca biiro ĩa, wãmarã doo, cʉ̃ upʉri niiquĩriquere jutiro quejero mena paa ũmaa, cʉ̃re yaarã waarã amicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","No cõro mee itia horas jiro, ca biiriquere majiricaro maniro jãa dooupo Ananías niiquĩricʉ nʉmo. ");
INSERT INTO baoNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Cõ cãare o biro cõre ĩi jãiñaupi Pedro: —Safira, yʉre wedeya: ¿Jãare wapa tiirica tiiri mʉja ca noni jãaro cõrora mʉja yaa yepare mʉja noni wapa jeejãri? —cõre ĩi jãiñaupi. —Ʉ̃gjá. To cõrora jãa noni wapa jeejãwʉ —cʉ̃re ĩi yʉʉupo. ");
INSERT INTO baoNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","To biro cʉ̃re cõ ca ĩi yʉʉrora: —¿Ñee tiirã mʉja pʉarãpʉra, Ʉmʉreco Pacʉ yʉʉ Añuri Yerire “O biro cʉ̃re mani ĩi ñaajaco” mʉja ameri ĩi wede penijãri? ¡Ĩaña! Ĩijã tua dooma, mʉ manʉ niiquĩricʉre ca yaarã waaricarã. Mʉ cãare ñucã ami waarã doorã tiima —cõre ĩiupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","To biro cõre cʉ̃ ca ĩirije menara, Safira cãa Pedro pʉtora dia ñaacũmucoaupo. Cõ manʉ niiquĩricʉre ca yaarã waaricarã wãmarã jãa earã, cõ cãare ca bii yairicopʉre bʉa ea, cõre ami waa, cõ manʉ niiquĩricʉ pʉtora cõre yaaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","To biri niipetirã Jesucristore ca tʉo nʉnʉjeerã, ñucã niipetirã teere ca tʉoricarã, bʉaro uwiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Jesús buerã menapʉ, paʉ wãmeri bojoca watoare ca ĩa ñaaña manirije tii bau niirique niiupa. Ñucã niipetirã Jesucristore ca tʉo nʉnʉjeerã, jĩcʉ̃ peere biro tʉgoeñarique cʉtiri, Pórtico de Salomón cʉ̃ja ca ĩiri tabere nea poorucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Aperã pea bʉaropʉra cʉ̃jare nʉcʉ̃ bʉocã pacarã, jĩcʉ̃ ʉno peera cʉ̃ja mena niirucu biitiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Wiogʉre ca tʉo nʉnʉjeerã pea, paʉ jañuro nomia, ʉmʉa, nii nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","To biri, ca diarique cʉtirãre wiijeri watoa waarica maaripʉ jee wieneri, cãni pejaricaro jotoarira, diari majare ami waaricaro jotoarira, cũu cojoupa, Pedro cʉ̃ ca ametʉa waaro petopʉra, cʉ̃ja mena macãrã jĩcãrãre cʉ̃ wãtĩ cʉti ñaapeajato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ñucã Jerusalén pʉto macã macãri macãrã cãa, ca diarique cʉtirãre, wãtĩa jʉori ñañaro ca biirãre, cʉ̃jare jee doorã paʉ tii macãre earucuupa. Niipetirãpʉra catio ecoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Paia ʉpʉ, cʉ̃ mena ca niirã saduceos're ca tʉo nʉnʉjeerã, bʉaro ajiaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","To biri Jesús buerãre ñeeri, tia cũurica wii, macã macã wiipʉ cʉ̃jare tia cũucãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","To biro cʉ̃ja ca tiimijata cãare, jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃ ñamira cʉ̃jare pãa wiene, o biro ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Waa, Ʉmʉreco Pacʉ yaa wiipʉ ea nʉcãri, niipetirije ate catirique quetire bojocare wederãja —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Cʉ̃ja pea to biro cʉ̃ ca ĩirijere cʉ̃ja ca tʉoricarore birora, ape rʉmʉ meepʉ, ca boerije mena Ʉmʉreco Pacʉ yaa wiipʉ jãa waari, wede jʉo waaupa. To biro cʉ̃ja ca ĩi nii ditoye, paia ʉpʉ, to biri cʉ̃ mena ca niirã mena doo, israelitas're ca jʉo niirã niipetirãre jʉo neo, Jesús buerã tia cũurica wiipʉ ca niirãre jʉo doti cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Cʉ̃ja ca jʉo doti cojoricarã uwamarã pea, tia cũurica wiipʉ earã cʉ̃jare bʉatiupa. To biri o biro ĩi wede tua eaupa: ");
INSERT INTO baoNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Tia cũurica wii niipetiri joperipʉra añuro biarica joperi wado nii, ñucã tii wiire coteri maja uwamarã cãa tii joperi cõrorena cote, bii niijapa. To biro cʉ̃ja ca bii pacaro, jãa pea tii wiire jope pãarã, tii wii jupeapʉra jĩcʉ̃ ʉnora jãa bʉaticãjãwʉ —cʉ̃jare ĩi tua eaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Teere tʉorã, Ʉmʉreco Pacʉ yaa wiire ca coterã uwamarã wiogʉ, ñucã paia ca nii majuropeerã, do biro pee ĩi majiti: —¿Tee niipetirije ñeepʉ to bii yapanorʉgabuti? —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","To biro cʉ̃ja ca ĩi niiri tabera, jĩcʉ̃ o biro cʉ̃jare ĩi eaupi: —Tia cũurica wiipʉ mʉja ca tia cũuquĩjãrã, Ʉmʉreco Pacʉ yaa wiipʉ bojocare buerã tiima ñucã —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","To biro cʉ̃ ca ĩiro tʉo, uwamarã wiogʉ cʉ̃ uwamarã mena waa, bojocare ʉ̃tã mena dee jĩa ecorʉgatigʉ uwima ĩigʉ, Jesús buerãre ñañaro cʉ̃jare tiitigʉra cʉ̃jare jeecoaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ea, wiorã pʉtopʉ cʉ̃jare jee waaupa. Paia ʉpʉ pea o biro cʉ̃jare ĩiupi: ");
INSERT INTO baoNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—“Jĩcãti ʉno peera cʉ̃ yee maquẽre wede nemoeto,” mʉjare jãa ĩijãwʉ doca. Mʉja pea, to biro mʉjare jãa ca ĩicã pacaro mʉja ca bue majiorije mena Jerusalén macãre ca jeja nʉcã peticoaro mʉja tii, ñucã to biro mʉja ca ĩi niirije watoara, cʉ̃ ca bii yairiquere, jãarena, “Cʉ̃re mʉja jĩawʉ,” mʉja ĩi nii —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","To biro cʉ̃ ca ĩiro, Pedro, to biri cʉ̃ mena macãrã: —Jãara, bojoca cʉ̃ja ca ĩirije peere tii nʉnʉjee jʉorica tabe ʉnora, Ʉmʉreco Pacʉ cʉ̃ ca tii dotirije peere jãa ca tii nʉnʉjee jʉopera niicãro bii. ");
INSERT INTO baoNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Mani ñicʉ̃ jãa niiquĩricarã Ʉmʉreco Pacʉra, Jesús're, yucʉ tenipʉ mʉja ca paa pua tuu cõagʉre cʉ̃ ca cati tuaro tiiwi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Cʉ̃rena, Ʉmʉreco Pacʉ, ca nii majuropeegʉ cʉ̃re tii, cʉ̃ díámacʉ̃ nʉña pee cʉ̃re cũuri, Wiogʉ, manire Ca Ametʉenegʉ, cʉ̃ ca niiro tiijapi, Israel bojoca ñañarije cʉ̃ja ca tii niirijere to cõrora tii yerijãa, Ʉmʉreco Pacʉ mena pee nii ea, ñañarije cʉ̃ja ca tiirijere acobo eco, cʉ̃ja ca biipere biro ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jãara jãa nii, atere ca ĩaricarã, ñucã Ʉmʉreco Pacʉ, cʉ̃re ca tʉo nʉnʉjeerãre cʉ̃ ca tiicojoricʉ Añuri Yeri cãa, ate to biro ca biiriquere, “To birora biiwʉ” ca ĩigʉ niimi —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Cʉ̃ja pea atere tʉorã, bʉaropʉra ajia ametʉacoari, cʉ̃jare jĩacãrʉgaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","To biro cʉ̃ja ca biiro, jĩcʉ̃ fariseo, Gamaliel ca wãme cʉtigʉ, doti cũuriquere jʉo bueri majʉ bojoca niipetirã cʉ̃ja ca nʉcʉ̃ bʉogʉ, ʉparã cʉ̃ja ca nea poori tabepʉre wãmʉ nʉcãri, Jesús buerãre jĩcã nimaro cʉ̃jare wiene cojo doticãupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Cʉ̃ja ca witi waaro jiro o biro ĩiupi: —Israelitas, anijare mʉja ca tiirʉgarijere tʉgoeña bojoca catiya. ");
INSERT INTO baoNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tʉgoeñaña tĩrʉmʉpʉre Teudas ca wãme cʉtigʉ, “Yʉ yʉ nii ca nii majuropeegʉ,” cʉ̃ ca ĩiro, cuatrocientos peti cʉ̃ ca ĩirijere tʉo nʉnʉjeeupa. To ca bii pacaro cʉ̃re jĩacãupa. Cʉ̃re cʉ̃ja ca jĩarora, cʉ̃re ca nʉnʉmiricarã waa bate peti, to cõrora niipetiro peti nʉcãcoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jiro jañuro ñucã, cʉ̃ja wãme cʉ̃ja ca owa peori rʉmʉrire, Galilea macʉ̃ Judas cãa, to birora ĩiri, bojoca cʉ̃re cʉ̃ja ca tʉo nʉnʉjeero tiimiupi. Ñucã cʉ̃ cãare jĩa cõacãupa. To biro cʉ̃ja ca tiirora, cʉ̃re ca nʉnʉmiricarã cãa waa bate peticoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","“Mecʉ̃ peera, anijare to birora cʉ̃jare ĩacãña,” mʉjare yʉ ĩi wede majio. ¡Cʉ̃jare piticãña! Ano ca biirije bojoca cʉ̃ja ca dotirije to ca niijata, peticoarucu. ");
INSERT INTO baoNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ʉmʉreco Pacʉ cʉ̃ ca dotirije to ca niijata docare, do biiro pee mʉja tii ametʉa nʉcã majitirucu. Bojoca catiya, Ʉmʉreco Pacʉ menara mʉja ameri quẽecã niire —cʉ̃jare ĩiupi Gamaliel, cʉ̃ mena macãrã wiorãre. To biro cʉ̃ ca ĩirije mena, cʉ̃ mena macãrãre cʉ̃ja ca tʉgoeña wajoaro tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","To biri Jesús buerãre jʉo cojo, cʉ̃jare bape yapano, “Jesús yee maquẽre wede nemoticãña,” cʉ̃jare ĩiupa. Jiro cʉ̃jare piticãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesús buerã pea, ʉparã pʉto ca niiricarã witi waarã: “Jesús yee quetire mani ca wederije jʉori, manire cʉ̃ja ca bapero manire tiimi Ʉmʉreco Pacʉ,” ĩi ʉjea niicã witi waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","To cãnacã rʉmʉra, Ʉmʉreco Pacʉ yaa wiipʉ, wiijeripʉ, bojocare bue, Jesús'ra Mesías ca niigʉ yee maquẽ añurije quetire wede, tiicã niirucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Tii cʉ̃marire Jesús yee quetire ca tʉo nʉnʉjeerã paʉ nii nʉnʉa waama ĩirã, griego bojoca pee, hebreo bojocare: —Jãa yee wederã romiri ca manʉ jʉ̃mʉa bii yai ecoricarã griega romirire, manire cʉ̃ja ca tii nemorijere baarique dica woorã, “Añuro cʉ̃jare tiitima” —ĩi wede pai jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","To biri Jesús buerã pʉa amo peti, dʉpore pʉaga penituaro ca niiricarã pea, niipetirã Jesucristore ca tʉo nʉnʉjeerãre neori, o biro cʉ̃jare ĩiupa: —Jãa Jesús buerã ca niiricarã, baarique bato coterʉgarãra, Ʉmʉreco Pacʉ yeere jãa ca wede yerijãaro añuti. ");
INSERT INTO baoNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Jãa yaarã, mʉja majuropeera mʉja mena ca niirãre, “Anijarã añuma” mʉja ca ĩirã, ca majirãre, Añuri Yeri ca cʉorãre, jĩcã amo peti, ape amore pʉaga penituaro ca niirã ʉmʉa tee paderiquere ca tii niiparãre cʉ̃jare amaña. ");
INSERT INTO baoNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jãa pea, juu bue, Ʉmʉreco Pacʉ cʉ̃ ca ĩirijere bojocare wede, jãa tiicã nʉnʉa waarucu —cʉ̃jare ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","To biro cʉ̃ja ca ĩiro, niipetirãpʉra “To birora mani tiijaco” ĩi, bʉaropʉra díámacʉ̃ tʉgoeña tutua, Añuri Yeri cʉo, ca biigʉ Esteban're, Felipere, Prócoro, Nicanor, Timón, Parmenas, to biri Antioquía macʉ̃ Nicolás, jʉguero peera judíos yee peere ca tii nʉcʉ̃ bʉorucuricʉre, jʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Cʉ̃jare beje yapano, Jesús buerã pʉtopʉ cʉ̃jare jee waaupa. Cʉ̃ja pea Ʉmʉreco Pacʉre cʉ̃jare jãi boja, cʉ̃ja amori mena cʉ̃jare ñia peo, cʉ̃jare tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ʉmʉreco Pacʉ yee queti pea bʉaro jañuri jeja nʉcã waaupa. To biri Jesús yee quetire ca tʉo nʉnʉjee waarã paʉ jañuro nii nʉnʉa waaupa Jerusalén're. Ñucã paiapʉ cãa, paʉ Jesús yee añurije quetire tʉo nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban, Ʉmʉreco Pacʉ añuro cʉ̃ ca tiirije, cʉ̃ ca yeri tutuarije cʉocãri, bojoca watoare ca ĩa ñaaña maniri wãmeri tii bau nii niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Jĩcãrã nea poo juu buerica wii, Pade Coteri Maja Ca Ametʉaricarã, ca wãme cʉtiri wii macãrã, jĩcãrã Cirene, Alejandría, Cilicia, to biri Asia yepa macã macãri macãrã mena, Esteban mena ameri tuti jʉo waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","To biro ĩi pacarã, Esteban're do biro pee cʉ̃re ĩi ametʉa nʉcã majitiupa, Añuri Yeri cʉ̃ ca majiorije mena cʉ̃ ca wedero macã. ");
INSERT INTO baoNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Do biro ĩi majitima ĩirã, jĩcãrãre wapa tiiupa, watoara, “Moisés cʉ̃ ca doti cũuriquere, Ʉmʉreco Pacʉre, Esteban ñañarije cʉ̃ ca ĩi tutiro jãa tʉojãwʉ,” cʉ̃ja ĩijato ĩirã. ");
INSERT INTO baoNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","To biro cʉ̃ja ca tiiricarã niiri, bojocare, bojocare ca jʉo niirãre, doti cũuriquere ca jʉo buerãre, cʉ̃jare wede mecʉ̃o peticã cojoupa. To biri Esteban're ũmaa nea poo, cʉ̃re ñee, ʉparã cʉ̃ja ca nea pooropʉ cʉ̃re amicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ñucã yeera, “ ‘Ania Moisés cʉ̃ ca doti cũuriquere, to biri ati wii Ʉmʉreco Pacʉ yaa wii ca ñañarije maniri wiire ñañaro ĩi yerijãati majuropeecãmi.’ ");
INSERT INTO baoNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","‘Ñucã Jesús, Nazaret macʉ̃, ati wii Ʉmʉreco Pacʉ yaa wiire cõacã, mani ca tii niirije Moisés manire cʉ̃ ca cũuriquere wajoacã, tiirucumi’ cʉ̃ ca ĩirijere jãa tʉojãwʉ,” ca ĩi dito wedejãa nemoparãre amaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","To cõrora ʉparã, to ca duwirã niipetirãpʉra, Esteban're ĩarã, Ʉmʉreco Pacʉ pʉto macʉ̃re biro cʉ̃ ca diámacʉ̃ cʉtiro ĩaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","To cõrora paia wiogʉ pea o biro cʉ̃re ĩi jãiñaupi: —¿Ano mʉre cʉ̃ja ca wedejãarije díámacʉ̃ra to niiti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Cʉ̃ pea o biro ĩi yʉʉupi: —Yʉ yaarã, yʉ pacʉa, yʉre tʉoya. Mani Ʉmʉreco Pacʉ do biro ca tiiya manigʉ, mani ñicʉ̃ Abraham're, Harán pee cʉ̃ ca niigʉ waaparo jʉguero, ména Mesopotamiapʉra cʉ̃ ca niiro cʉ̃re baua eari, ");
INSERT INTO baoNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“Mʉ yaa yepare, mʉ yaarãre witi weori, mʉre yʉ ca ĩñopa yepapʉ waagʉja,” cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","To biri caldeos yaa yepare witiri, Harán yepa pee niigʉ waaupi. Toopʉ cʉ̃ ca niiro, cʉ̃ pacʉ cʉ̃ ca bii yairo jiro, Ʉmʉreco Pacʉ ati yepa, mecʉ̃re mʉja ca niiri yepare, cʉ̃re ami dooupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","To biro cʉ̃re tii pacagʉ, ati yepare cʉ̃ yee ca niipe cʉ̃re tiicojo, ñucã jĩcã tabe ʉnoacã cʉ̃ ca niipa tabe ʉnora cʉ̃re tiicojorucu, tiitiupi. Biigʉpʉa, “Mʉre yʉ tiicojorucu mʉ ca bii yairo jiro mʉ pãramerã yaa yepa ca niipere biro ĩigʉ,” cʉ̃re ĩiupi, ména Abraham tii tabepʉra cʉ̃ ca puna mani pacaro. ");
INSERT INTO baoNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ñucã Ʉmʉreco Pacʉ o biro cʉ̃re ĩiupi: “Mʉ pãramerã ca nii nʉnʉa waarã, cʉ̃ja yaa yepa ca niitiropʉ ape yepa macãrãre biro niirucuma, cuatrocientos cʉ̃mari peti pade coteri maja nii, ñañaro tii eco, cʉ̃ja ca bii niiparopʉre. ");
INSERT INTO baoNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Yʉ pea cʉ̃jare ca pade doti eperãre ñañaro cʉ̃jare yʉ tiirucu. Jiro mʉ pãramerã tii yepare witi weori, ati yepapʉ yʉre tii nʉcʉ̃ bʉorucuma,” ĩiupi Ʉmʉreco Pacʉ Abraham're. ");
INSERT INTO baoNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ʉmʉreco Pacʉ, Abraham're, “O biro mani tii niirucu,” cʉ̃re cʉ̃ ca ĩirijere ca bii ĩñorije to niijato ĩigʉ, jeyua quejero yapare wide taatiriquere cʉ̃re tii dotiupi. To biri cʉ̃ macʉ̃ Isaac cʉ̃ ca baʉaro jiro jĩcã amo peti, ape amore itiaga penituaro ca niiri rʉmʉri ca nii waaro, cʉ̃ jeyua quejero yapare wide taaupi. Ñucã Isaac cãa cʉ̃ macʉ̃ Jacob're to birora tiiupi. Jacob cãa to birora tiiupi, cʉ̃ puna Israel macãrã pʉa amo peti, dʉpore pʉaga penituaro niiri poogaari ca niiparã pacʉa cãare. ");
INSERT INTO baoNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","”Anija Jacob puna mani ñicʉ̃ jãa ca niiricarã cʉ̃ja bai Josére ĩa tutiri, pade coteri majʉre biro cʉ̃ja ca noni cõagʉre, Egiptopʉ cʉ̃re ami waaupa. To biro cʉ̃re cʉ̃ja ca tii pacaro, Ʉmʉreco Pacʉ pea cʉ̃ menara niiri, ");
INSERT INTO baoNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","niipetirije cʉ̃ ca tʉgoeñarique pairijere cʉ̃re tii nemo ametʉeneupi. To biro tii, bʉaro ca majigʉ cʉ̃ ca niiro cʉ̃re tiiri, Faraón, Egipto macʉ̃ ʉpʉ, Josére Egipto macãrã wiogʉ cʉ̃ ca niiro, ñucã ʉpʉ cʉ̃ ca niiri wiire ca dotigʉ cʉ̃ ca niiro cʉ̃re tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","”Tii tabere, Egiptore, to biri Canaán yepare aʉa nii, ñañaro tamʉorique nii, biiupa. To biri mani ñicʉ̃ jãa niiquĩricarã pea cʉ̃ja ca baape ʉno cʉoticãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob, “Egiptore baarique niijato,” cʉ̃ja ca ĩirijere tʉori, cʉ̃ puna, mani ñicʉ̃ jãa niiquĩricarãre toopʉ cʉ̃jare tiicojo jʉoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jiro cʉ̃ja ca waa nemoro, José pea cʉ̃ jũwʉ jãarire cʉ̃re cʉ̃ja ca majiro tiiupi. To biri Faraón pea Josére “Tii pooga macʉ̃ niijapi,” ĩi majiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Tee jiro José, cʉ̃ pacʉ Jacob, cʉ̃ puna niipetirã, setenta y cinco bojoca ca niirãre, Egipto pee cʉ̃jare jee doo dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","To biro biima ĩigʉ, Egipto yepapʉ niigʉ waaupi Jacob. Toopʉ bii yaiupi. Ñucã cʉ̃ puna, mani ñicʉ̃ jãa niiquĩricarã cãa, tii yepapʉra bii yaiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jacob niiquĩricʉ cʉ̃ ca bii yairo cʉ̃ upʉri niiquĩriquere Siquem'pʉ ami waa, Abraham, Hamor punare cʉ̃ ca wapa tiirica maja opepʉ cʉ̃re yaacõaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","”Ʉmʉreco Pacʉ Abraham're, “To biro yʉ tiirucu,” cʉ̃ ca ĩirica cuu ca ea nʉnʉa waaro, Israel yaa pooga macãrã Egipto yepapʉ niirã paʉ bojoca bʉʉupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","To biro cʉ̃ja ca biiri cʉ̃marire, Josére ca majitigʉ, Egipto yepare wiogʉ jãaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","To biri cʉ̃ pea, mani yaa pooga macãrãre ĩi dito, mani ñicʉ̃ jãare ñañaro cʉ̃jare tii epe, cʉ̃ja puna wãma ca baʉarã cãare ĩa nʉnʉjee dotiti, cʉ̃ja ca bii yairo tiiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","To biro cʉ̃jare cʉ̃ ca tiiri cuurena baʉaupi Moisés. Ʉmʉreco Pacʉ cʉ̃ ca ĩa biijejagʉ añugʉ niiupi. Cʉ̃ pacʉa pea itiarã muipũa peti cʉ̃ja yaa wiira cʉ̃re majo niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jiro cʉ̃re jĩarema ĩima ĩirã, diapʉ cʉ̃ja ca poo yuu cojogʉre, faraón macõ cʉ̃re amiri cõ macʉ̃ majuro peere biro cʉ̃re majoupo. ");
INSERT INTO baoNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","To biro cõ ca tiiricʉ niiri, Egipto macãrã yee majiriquere bue majio ecori, cʉ̃ ca wederije, cʉ̃ ca tiirije cãare bʉaro ĩi bayi, niipetirije ca tii maji petigʉ bii maja nʉcãupi Moisés. ");
INSERT INTO baoNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","”Cuarenta cʉ̃mari cʉogʉ, cʉ̃ yaarã israelitas're: “Ca ĩagʉ waape niicu,” ĩiupi Moisés. ");
INSERT INTO baoNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Cʉ̃jare ĩagʉ waagʉ, jĩcʉ̃ Egipto macʉ̃, jĩcʉ̃ cʉ̃ja mena macʉ̃re ñañaro cʉ̃ ca tiiro ĩari, cʉ̃re camotagʉ waama ĩigʉra, Egipto macʉ̃re quẽe jĩacãquĩupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","“Cʉ̃ jʉori, ‘Ʉmʉreco Pacʉ manire ametʉenerucumi,’ ĩi tʉgoeñarucuma yʉ yaarã,” ĩi tʉgoeñamiupi Moisés. Cʉ̃ja pea to biri wãme tʉgoeñatiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ñucã ape rʉmʉ cʉ̃ yaarã pʉarã israelitas wado cʉ̃ja ca ameri quẽe niiro ĩari, añuro cʉ̃ja ca niiro tiirʉgama ĩigʉ, “Mʉja jĩcã majara mʉja nii, ¿ñee tiirã ñañaro mʉja ameri tiiti?” cʉ̃jare ĩimiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","To biro cʉ̃ ca ĩirora, cʉ̃ mena macʉ̃re ca quẽe niijãgʉ pea, Moisés're tumicõa cojo, o biro cʉ̃re ĩiupi: “¿Ñiru jãare ca dotipʉ, jãare ca ĩa bejepʉ, mʉre cʉ̃ tiijãri? ");
INSERT INTO baoNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ñamica, egipcio bojocʉre mʉ ca jĩajãrore birora, yʉ cãare jĩarʉgʉ mʉ tiiti?” cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","To biro cʉ̃re cʉ̃ ca ĩirijere tʉo uwima ĩigʉ, Madián yepapʉ duticoaupi Moisés. Tii yepapʉre ape yepa macʉ̃re biro niirucuupi. Toopʉ niigʉ, pʉarã puna cʉtiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","”Cuarenta cʉ̃mari jiro, ca yucʉ maniri yepa Sinaí ʉ̃tãgʉ pʉto, jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃, yucʉgʉ ca pota cʉtiricʉ ca ʉ̃ʉrije watoapʉ cʉ̃re baua eaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés pea to biro ca biirijere ĩagʉ, ĩa ʉcʉacoa, añuro ĩa quenorʉgʉ pʉto jañuro waa nʉnʉa waagʉ, Ʉmʉreco Pacʉ o biro cʉ̃re cʉ̃ ca ĩiro tʉoupi: ");
INSERT INTO baoNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yʉa, mʉ ñicʉ̃ jãa Ʉmʉreco Pacʉ yʉ nii. Abraham, Isaac, Jacob jãari Ʉmʉreco Pacʉ yʉ nii,” cʉ̃re ĩiupi. To biro cʉ̃re cʉ̃ ca ĩiro tʉogʉ, cʉ̃ pea uwi nana yai waama ĩigʉ, ĩa cojori méé biicãupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","To biro cʉ̃ ca biiro, Moisés're o biro cʉ̃re ĩiupi Ʉmʉreco Pacʉ: “Mʉ dʉpo jutire tuu weeya. Mʉ ca nucũri yepa ca ñañarije maniri yepa nii. ");
INSERT INTO baoNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yʉ yaarã Israel yaa pooga macãrã Egiptopʉ ca niirã, ñañaro cʉ̃ja ca biirijere ĩa, ‘Ñañaro peti mani tamʉocã anore niirã,’ cʉ̃ja ca ĩirijere yʉ tʉo, to biri cʉ̃jare ametʉenerʉgʉ yʉ duwi doojãwʉ. ‘Dooya. Ñucã Egiptopʉra mʉre tiicojogʉ doogʉ yʉ tii,’ ” cʉ̃re ĩiupi Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","”Ani Moisés, “¿Ñiru jãare ca dotipʉ, jãare ca ĩa bejepʉ, mʉre cʉ̃ tiijãri?” cʉ̃ja ca ĩi ĩa junaricʉrena ñucã, Ʉmʉreco Pacʉ pea cʉ̃jare ca ametʉenepʉ, cʉ̃jare ca jʉo niipʉ, cʉ̃re tiicojoupi Ʉmʉreco Pacʉ pʉto macʉ̃, potagʉ ca ʉ̃ʉricʉ watoapʉ ca baua earicʉ cʉ̃ ca doti tutuarije jʉori. ");
INSERT INTO baoNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","To biri Moisés'ra tii yepare ca ĩa ñaaña manirije tii bau nii, Dia Pairiya Ca Jũari yaare jʉo tĩa, ñucã ca bopori yepapʉ cãare cuarenta cʉ̃mari peti ca ĩa ñaanã manirije tii bau nii, ca tiiricʉra, mani ñicʉ̃ jãa niiquĩricarãre cʉ̃jare jʉo witi nʉcãupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ñucã cʉ̃ra, israelitas're: “Mʉja watoare jĩcʉ̃ cʉ̃ yee quetire wede jʉgueri majʉ yʉre biro ca biigʉ cʉ̃ ca nii earo tiirucumi Ʉmʉreco Pacʉ, cʉ̃re mʉja tʉo nʉnʉjeerucu,” cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ñucã ani, Moisés'ra, ca yucʉ maniri yepapʉ Israel bojocare jʉo niigʉ, Ʉmʉreco Pacʉ pʉto macʉ̃, Sinaí buuropʉ niigʉ cʉ̃re cʉ̃ ca ĩirijere, mani ñicʉ̃ jãa peere wedecojo niiupi. Ñucã cʉ̃ra, catirique maquẽ wederiquere Ʉmʉreco Pacʉ cʉ̃ ca tiicojorije cãare ñeeupi, manipʉre cʉ̃ ca wede ametʉenepere. ");
INSERT INTO baoNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","”Mani ñicʉ̃ jãa niiquĩricarã pea, cʉ̃jare cʉ̃ ca wederijere tʉo nʉnʉjeerʉgati, teere tʉo juna, ñucã Egipto peera tuacoarʉgaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","To biri: “Jʉ̃guẽa, manire ca jʉo waparãre quenoña. Ani Moisés, Egiptopʉ mani ca niiro manire ca jʉo witimiricʉ cãare mani majiti. Do biro peti biicãbumi doca,” ĩiupa Aarón're. ");
INSERT INTO baoNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","To biro ĩicãri jĩcʉ̃ wecʉ macʉ̃re biigʉ weeri, waibʉcʉrã jĩa, cʉ̃re tiicojo nʉcʉ̃ bʉo, boje rʉmʉ queno peo, tii ʉjea nii niiupa, cʉ̃ja majuropeera cʉ̃ja ca quenoricʉrena. ");
INSERT INTO baoNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ate jʉori Ʉmʉreco Pacʉ, cʉ̃jare camotati, ʉmʉreco tuti macãrã ñocõarena cʉ̃ja ca tii nʉcʉ̃ bʉoro cʉ̃jare tiiupi. O biirijera ĩi owarique nii Ʉmʉreco Pacʉ yee quetire wede jʉgueri maja cʉ̃ja ca owarica pũuropʉre: “Israelitas, ¿mʉja, ca yucʉ maniri yepapʉre cuarenta cʉ̃mari peti niirã, oveja jĩari joe jʉti añu mʉene, mʉja ca cʉorijere tiicojo, yʉre mʉja tii nʉcʉ̃ bʉo niiri? ");
INSERT INTO baoNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","”Mʉja tiitiwʉ. To biro tii nʉcʉ̃ bʉoricaro ʉno, jʉ̃guẽ Moloc peere cʉ̃ yaa wii menara cʉ̃re pʉja waarucu, ñucã jʉ̃guẽ Refán yʉʉ ñocõ cãare to birora tii, ĩi nʉcʉ̃ bʉorʉgarã mʉja majuropeera mʉja ca weericarãrena tii nʉcʉ̃ bʉo, mʉja tiicõa niiwʉ. To biri Babilonia õo peepʉ mʉjare yʉ tiicojo batecãrucu,” ĩi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","”Mani ñicʉ̃ jãa ca bopori yepare niirã, Ʉmʉreco Pacʉ, bojoca watoare cʉ̃ ca niirijere ca bii ĩñori wiire, Moisés're, “Mʉ ca ĩarica wiire biiri wii tiiya,” Ʉmʉreco Pacʉ cʉ̃re cʉ̃ ca ĩirica wiire biiri wii cʉ̃ ca tiirica wiire cʉoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Mani ñicʉ̃ jãa pea tii wiire ñeeri jiro, ape poogaari macãrã yaa yepare Ʉmʉreco Pacʉ cʉ̃jare tiicojorʉgʉ, cʉ̃ja ca ĩa cojorora cʉ̃jare cõa wiene, cʉ̃ ca tiiri yepare Josué cʉ̃jare cʉ̃ ca doti niiro mena ẽmarã, cʉ̃ja menara tii wiire ami nʉnʉa waaupa. David cʉ̃ ca niiri cuupʉ, tii wii toora niicãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David pea, Ʉmʉreco Pacʉ añuro cʉ̃ ca tiirijere bʉa eaupi. To biri, Jacob cʉ̃ ca tʉo nʉnʉjeericʉ Ʉmʉreco Pacʉ yaa wiire quenorʉgʉ cʉ̃re jãiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Biigʉpʉa, Salomón'pʉ quenoquĩupi Ʉmʉreco Pacʉ yaa wiire. ");
INSERT INTO baoNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ʉmʉreco Pacʉ ati ʉmʉreco niipetiropʉre Ca Doti Niigʉa, bojoca cʉ̃ja ca quenorica wiijeri ʉnorena niitimi, ca biipere wede jʉgueri majʉ cʉ̃ ca ĩiricarore birora: ");
INSERT INTO baoNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ʉmʉreco quejeroa, yʉ ca doti duwiri cũmuro nii. Ati yepa pea yʉ dʉpori yʉ ca ʉta cũuri tabe nii. ¿To docare do biri wii ʉno pee yʉre mʉja queno bojarãti? ¿Noo pee yʉ ca yerijãa niipa tabe to niiroti? ");
INSERT INTO baoNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Ate niipetirije yʉ, yʉ ca tiirique méé to niiti?” ĩimi Ʉpʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","”¡Mʉja pea ca ametʉene nʉcã pairã, Ʉmʉreco Pacʉre ca majitirãre biro amoperi cʉti, yeri cʉti, mʉja bii! To cãnacã tiira, Añuri Yerire mʉja junacã. Mʉja ñicʉ̃ jʉ̃mʉa niiquĩricarãre birora mʉja biicã. ");
INSERT INTO baoNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Mʉja ñicʉ̃ jʉ̃mʉa niiquĩricarã, niipere Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉre, ¿ñañaro cʉ̃ja tiitiupari? Ca ñañarije manigʉ cʉ̃ ca doopere ca wede jʉguerã dooricarãre, cʉ̃jara jĩa bateupa. Mecʉ̃ra yua, ca ñañarije manigʉra ca dooricʉrena, mʉja pea cʉ̃re wedejãa, jĩa cõa, mʉja tii yerijãawa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mʉja, Ʉmʉreco Pacʉ pʉto macãrã menapʉ doti cũuriquere ca ñeericarã, teere mʉja tii nʉnʉjeeti tee cãare” —cʉ̃jare ĩiupi Esteban. ");
INSERT INTO baoNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Atere tʉorã, cʉ̃ja upire baca dʉpo tuuri nʉcʉ̃ripʉ ajiaupa Esteban menare. ");
INSERT INTO baoNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Esteban pea, Añuri Yerire cʉo ametʉene nʉcãcoa, ʉmʉreco pee ĩa mʉene cojogʉ, Ʉmʉreco Pacʉ cʉ̃ ca boe baterijere, ñucã Jesús, Ʉmʉreco Pacʉ díámacʉ̃ nʉña pee ca nucũgʉre, ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","To cõrora o biro ĩiupi Esteban: —¡Ĩaña. Ʉmʉreco tuti pãa nʉcãcoa! ¡Ca Nii Majuropeegʉ Macʉ̃ Ʉmʉreco Pacʉ díámacʉ̃ nʉña pee ca niigʉre yʉ ĩa! —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Cʉ̃ja pea bʉaro acaro bui, cʉ̃ja amoperire paa biato, tiicãri, to ca niirã niipetirãpʉra ũmaa nea poori cʉ̃re ñeeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Cʉ̃re ñee, macã tʉjaropʉ ami witi waari, ʉ̃tã mena cʉ̃re dee jʉo waaupa. Cʉ̃re ca wedejãarã pea, jĩcʉ̃ wãmʉ Saulo ca wãme cʉtigʉre, cʉ̃ja juti jotoa cʉ̃ja ca jãñarijere cote dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Cʉ̃re cʉ̃ja ca deero watoara, o biro ĩi juu bueupi Esteban: —Wiogʉ Jesús, yʉ yerire ñeeña —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","To biro ĩi ñaanuu waa, o biro ĩi acaro buiupi: “Wiogʉ, o biro ñañaro yʉre cʉ̃ja ca tiirijere cʉ̃jare acoboya.” Atere ĩi yapanogʉra, bii yaicoaupi Esteban. ");
INSERT INTO baoNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo cãa, toora Esteban're cʉ̃ja ca jĩaro, “Mee añuro tiima,” ĩi cote niiupi. Tii rʉmʉra Jerusalén macãrã Jesucristore ca tʉo nʉnʉjeerã menare ñañaro tiirʉgarã, cʉ̃ja ca nʉnʉrije bii jʉoupa. To biri niipetirã Judea, Samaria yeparipʉ waa batecoaupa. Jesús buerã ca niiricarã wado ametʉaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Jĩcãrã ʉmʉa ca bojoca añurã, Esteban niiquĩgʉre bʉaro oti, cʉ̃re yaa cõa, tiicã yerijãa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Saulo pea wiijeri cõro waari Jesucristore ca tʉo nʉnʉjeerãre cʉ̃ja yaa wiijeripʉra, nomia, ʉmʉare ñee, wee nʉnʉa waari, cʉ̃jare tia cũu doti niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalén ca niimiricarã ca waa batericarã pea, noo cʉ̃ja ca waari taberi cõro añurije quetire wedecã nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe pea, Samaria yepa pee waari, ca nii majuropeeri macãre Jesús yee quetire cʉ̃jare wede jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Felipe cʉ̃ ca ĩirijere tʉo, ca ĩa ñaaña manirije cʉ̃ ca tii bau niirijere ĩari, paʉ bojoca cʉ̃ ca wederijere añuro tʉo nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Paʉ bojoca ca wãtĩa jãa ecoricarã ametʉene eco, wãtĩa cʉ̃japʉre ca niirã, cʉ̃jare witi waarucurã bʉaro acaro bui, ñucã paʉ ca bʉʉricarã, ñicã yuriri cãa catio eco, biiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ate jʉori, tii macãre bʉaro ʉjea niirique niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Tii macãre niiupi jĩcʉ̃, mee, jʉgueropʉra cũmu niiri ca nii majuropeegʉre biro biicãri, Samaria macãrãre ca ĩi dito epe niirucuricʉ Simón ca wãme cʉtigʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","To biri niipetirã, ca nii majuropeerã, ñucã ca nii coterã cãa, cʉ̃ ca ĩirijere añuro cʉ̃re tʉo nʉnʉjeeri, “Ania Ʉmʉreco Pacʉ cʉ̃ ca yeri tutuarije niimi,” cʉ̃re ĩi nʉcʉ̃ bʉorucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Cũmu cʉ̃ ca niirije mena paʉ cʉ̃mari cʉ̃jare cʉ̃ ca ĩi dito niiro macã, cʉ̃ ca ĩirore biro cʉ̃re tii nʉnʉjeerucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Felipe, Ʉmʉreco Pacʉ cʉ̃ ca doti niiri tabe maquẽ, to biri Jesucristo yee añurije quetire cʉ̃ ca wederije peere tʉo nʉnʉjeema ĩirã, ʉmʉa, nomia, uwo coe dotiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ñucã Simón cũmupʉra, Felipe cʉ̃ ca wederijere tʉo nʉnʉjee, uwo coe dotiri jiro, ca ĩa ñaaña manirije Felipe cʉ̃ ca tii bau niirijere ĩa ʉjea niiri, cʉ̃re camotatiri méé cʉ̃re bapa cʉti yujuupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jesús buerã Jerusalén ca niirã, Samaria macãrã Ʉmʉreco Pacʉ yee quetire cʉ̃ja ca tʉo nʉnʉjeerijere queti tʉori, Pedrore, Juan're cʉ̃ja pʉtopʉ cʉ̃jare tiicojoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Cʉ̃ja pea toopʉ earã, Samaria macãrã Cristo yee quetire ca tʉo nʉnʉjeericarã Añuri Yerire cʉ̃ja ñeejato ĩirã, cʉ̃jare juu bue bojaupa, ");
INSERT INTO baoNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ména, jĩcʉ̃ ʉno peerena Añuri Yeri cʉ̃japʉre cʉ̃ ca ñaajãa nʉcã eatirique ca niiro macã. Wiogʉ Jesús wãme mena wado uwo coe ecoupa ména. ");
INSERT INTO baoNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","To biri Pedro, Juan, cʉ̃ja amori mena cʉ̃jare ñia peo, Añuri Yeri cʉ̃japʉre cʉ̃ ca ñaajãa nʉcã earo cʉ̃jare tiiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ñucã Simón pea Jesús buerã cʉ̃ja amorire bojocare cʉ̃ja ca ñia peorora, Añuri Yeri cʉ̃ ca dooro cʉ̃ja ca tiirijere ĩari, wapa tiirica tiiri cʉ̃jare tiicojo, ");
INSERT INTO baoNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","o biro cʉ̃jare ĩiupi: —To biro tii majiriquere yʉ cãare tiicojoya, niipetirã yʉ amori mena yʉ ca ñia peorã Añuri Yerire cʉ̃ja ca ñeepere biro ĩirã —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","To biro cʉ̃ ca ĩiro tʉogʉ, Pedro pea o biro cʉ̃re ĩi yʉʉupi: —Ʉmʉreco Pacʉ wapa maniro cʉ̃ ca tiicojorijere mʉ ca wapa tii amirʉgarije wapa, mʉ yee wapa tiirica tiiri mʉ menara ñañaro to tii yaio ecocãjato. ");
INSERT INTO baoNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jãa ca majirije ʉnore ca cʉopʉ méé mʉ nii mʉa. Ʉmʉreco Pacʉ ca ĩaro, mʉ yeri añuti majuropeecã. ");
INSERT INTO baoNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ate ñañarije mʉ ca cʉorijere to cõrora tii yerijãari, Ʉmʉreco Pacʉre jãiña. Ape tabera o biirije mʉ ca tʉgoeñarijere mʉre acobocãbocumi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Yʉ ca ĩajata, ñañarije wado tʉgoeña, ñañarije pee wadore tii nʉnʉjeecã yai waa, biirique wado mʉre niicã —cʉ̃re ĩiupi Simón cũmure. ");
INSERT INTO baoNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","To biro cʉ̃ ca ĩiro tʉogʉ, o biro cʉ̃re ĩi yʉʉupi Simón: —Mʉjara Ʉmʉreco Pacʉre yʉre jãi bojaya, ano yʉre mʉja ca ĩirije jĩcã wãme ʉno peera yʉre ca biiticãpere biro ĩirã —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro, Juan, Jesús cʉ̃ ca tiirijere cʉ̃ja ca ĩariquere wede, Ʉmʉreco Pacʉ wederiquere cʉ̃jare bue, tii yapanorã, Jerusalén pee tuacoaupa. To biro bii, tua nʉnʉa waarã Samaria yepare ca niiri macãri paʉ macãripʉre añurije quetire cʉ̃jare wede, ĩi nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ate jiro jĩcʉ̃ Ʉmʉreco Pacʉ pʉto macʉ̃ o biro ĩiupi Felipere: “Jõcʉ̃ jiro macã nʉña peere, Jerusalén mena Gaza pee ca nii bua waari maa, ca yucʉ maniri yepare ca nii waari maare waagʉja,” cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","To biro cʉ̃ ca ĩiro tʉo, waacoaupi Felipe. Too waa nʉnʉa waagʉ bʉa eaupi jĩcʉ̃ Etiopía macʉ̃, tii yepa macãrã wiogo Candace ca wãme cʉtigo yee wapa tiirica tiirire ĩa nʉnʉjeeri majʉ ca niigʉre. Cʉ̃ pea Jerusalén'pʉ, Ʉmʉreco Pacʉre ca ĩi nʉcʉ̃ bʉogʉ earicʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","To biro bii tua waagʉ, cʉ̃ tunurica caballoa cʉ̃ja ca tʉ̃ari coropʉ duwiri, Ʉmʉreco Pacʉ yee quetire wede jʉgueri majʉ Isaías cʉ̃ ca owariquere bue nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Añuri Yeri pea o biro ĩiupi Felipere: —Ii coro, ca tunuri coro pʉto jañuro waagʉja —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","To biro cʉ̃ ca ĩiro Felipe tii coro pʉtoacã eagʉ, Etiopía macʉ̃ pea Isaías cʉ̃ ca owaquĩrica pũurore cʉ̃ ca bue nʉnʉa waarijere tʉori, o biro cʉ̃re ĩi jãiñaupi: —¿Too mʉ ca buerijere mʉ tʉo puoti? —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","To biro Felipe cʉ̃ ca ĩi jãiñaro: —¿Jĩcʉ̃ ʉno peera yʉre cʉ̃ja ca wede majioro cõro, do biro tiicãri yʉ tʉo puobogajati? —cʉ̃re ĩi yʉʉupi. To biro ĩi, Etiopía macʉ̃ pea cʉ̃ pʉto Felipere ea jãa dotiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Etiopía macʉ̃ cʉ̃ ca bue nʉnʉa waarije pea o biro ĩi owarique niiupa: “Jĩcʉ̃ ovejare biro, cʉ̃ja ca jĩapa tabepʉ ami waa ecowi. Jĩcʉ̃ oveja macʉ̃re cʉ̃ja ca poa juaro, cʉ̃ ca acaro buitirore birora wederucu, tiitiwi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ñañaro tii epe ecowi. Ñañaro cʉ̃re ca tiirãre ñañaro cʉ̃jare tiitiwi. ¿Ñiru pee cʉ̃ ca bii jʉo dooriquere cʉ̃ wede peotibogajati? Ati yepare cʉ̃ ca cati niimirije ẽma ecocoawʉ,” ca ĩirijere bue jãñaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Etiopía macʉ̃ pea Felipere o biro ĩi jãiñaupi: —Yʉre wedeya petopʉra. ¿Atera, ñiru pee cʉ̃ ca biipere cʉ̃ ĩiupari Isaías? ¿Cʉ̃ majuropeera cʉ̃ ca biipere ĩigʉ cʉ̃ ĩijapari? ¿Apĩpʉ cʉ̃ ca biipere ĩigʉ pee cʉ̃ ĩijapari? —cʉ̃re ĩi jãiñaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","To biro cʉ̃re cʉ̃ ca ĩi jãiñaro, Felipe pea cʉ̃ ca bue nʉnʉa dooriquere cʉ̃re wede jʉo waa, añurije queti Jesús yeepʉ cʉ̃re wede yapano eaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","To waa nʉnʉa waarã, jĩcã tabe oco ca niiri tabe eagʉra, o biro ĩiupi Etiopía macʉ̃, Felipere: —Ĩaña, anore oco nii. ¿Ca bii camotarije ʉno to niibogajati yʉre mʉ ca uwo coejata? —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","To biro cʉ̃ ca ĩiro: —Mʉ yeri niipetiro menapʉra mʉ ca tʉo nʉnʉjeejata, mʉre yʉ uwo coe maji —cʉ̃re ĩiupi Felipe. To biro cʉ̃ ca ĩiro: —Jesucristoa, Ʉmʉreco Pacʉ Macʉ̃ra niimi; cʉ̃re yʉ tʉo nʉnʉjee —cʉ̃re ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","To biro ĩi, cʉ̃ja tunuricare tua nʉcã doti, cʉ̃ja pʉarãpʉra duwi ñaanʉcã, diapʉ wau wia waa, Etiopía macʉ̃re uwo coeupi Felipe. ");
INSERT INTO baoNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Cʉ̃re uwo coe yapano, cʉ̃ja ca maa nʉcãri tabera, Ʉmʉreco Pacʉ yʉʉ Añuri Yeri pea Felipere amicoaupi ñucã. Etiopía macʉ̃ pea pʉati cʉ̃re ĩa nemotiupi yua. To biro bii pacagʉ, bʉaro ʉjea niirique mena waacã nʉnʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe pea, Azoto cʉ̃ja ca ĩiri macãpʉ nii yerijãaupi ñucã. To ca niiri macãri cõro añurije quetire wede nʉnʉa waagʉ, Cesarea macãpʉ wede eacoaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ména Saulo pea, Jesucristore ca tʉo nʉnʉjeerãre yerijãari méé jĩarʉga nʉnʉjee niigʉra, paia wiogʉ pʉtopʉ eari, ");
INSERT INTO baoNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","cʉ̃re cʉ̃ ca doti cojori pũurorire “Yʉre owa bojaya” cʉ̃re ĩi jãigʉ eaupi, Damascopʉ nea poo juu buerica wiijeripʉ, Wãma Maa maquẽre ca tʉo nʉnʉjeerã, nomia, ʉmʉare, cʉ̃jare ama bʉari, Jerusalén'pʉ cʉ̃jare ami waagʉda ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Teere tii yapano, waagʉ, mee Damasco macãre ea waagʉ doogʉ cʉ̃ ca biiro, ca niiro tʉjarora ʉmʉrecopʉ ca doorije bʉaro ca boe ajiyaarije cʉ̃ wejare boe ñaacũmu eaupe. ");
INSERT INTO baoNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","To biro ca biiro Saulo, yepapʉ ñaacũmu waagʉ: —Saulo, Saulo, ¿ñee tiigʉ yʉre mʉ nʉnʉti? —cʉ̃re ca ĩirijere tʉoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","To biro ca ĩirijere tʉori: —¿Wiogʉ, ñiru mʉ niiti? —ĩi jãiñaupi. To biro cʉ̃ ca ĩiro, too ca wederije pea: —Yʉa Jesús, ñañaro mʉ ca tiirʉga nʉnʉjeegʉra yʉ nii. Mʉ majuropeera potagare natẽ puagʉre biro tiigʉ mʉ tii —ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Cʉ̃ pea nanagʉra bʉaro uwirique mena o biro ĩiupi: “¿Wiogʉ, ñee yʉ ca tiiro mʉ booti?” cʉ̃re ĩiupi. To cʉ̃ ca ĩiro Jesús'pea: “Wãmʉ nʉcãri, macã pee piya waagʉja. Toopʉ mʉ ca earo, mʉ ca tiipere mʉre wederucuma,” ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Saulo mena ca waaricarã pea, bojoca bauti pacaro ca wederijere tʉori, bʉaro ʉcʉa uwirãra tua nʉcãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jiro, Saulo wãmʉ nʉcã, cʉ̃ capere ĩa pãagʉ, ĩaticãupi. To biri cʉ̃ amoripʉ ñee, Damascopʉ cʉ̃re amicoaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tii macãre itia rʉmʉ peti ĩati, baati, jiniti, bii niiupi Saulo. ");
INSERT INTO baoNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damascore niiupi jĩcʉ̃ Jesucristore ca tʉo nʉnʉjeegʉ, Ananías ca wãme cʉtigʉ. Quẽñagʉre biro cʉ̃ ca bii oto wetiropʉ, Wiogʉ cʉ̃re baua eari, o biro cʉ̃re ĩiupi: —¡Ananías! —ĩiupi. To biro cʉ̃ ca ĩiro: —Anora yʉ nii Wiogʉ —cʉ̃re ĩi yʉʉupi cʉ̃ pea. ");
INSERT INTO baoNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","To biro cʉ̃ ca ĩi yʉʉro, o biro cʉ̃re ĩiupi Wiogʉ: —Wiijeri caa, Díámacʉ̃ Maa ca wãme cʉtiri maapʉ, Judas yaa wiipʉ waari, “¿Tarso macʉ̃ Saulo ca wãme cʉtigʉ cʉ̃ niiti?” ĩi jãiñaña. Juu buegʉ tiimi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Quẽñaricarore biro bii oto weti waagʉ, jĩcʉ̃ Ananías ca wãme cʉtigʉ, cʉ̃ pʉtopʉ jãa eari, ñucã cʉ̃ ĩajato ĩigʉ cʉ̃ amori mena cʉ̃re ca ñia peo ea nʉcãgʉre ĩami —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Teere tʉogʉ, o biro ĩiupi Ananías: —Wiogʉ, paʉ cʉ̃ yee maquẽre, ñucã mʉ yaarã ca ñañarije manirã Jerusalén ca niirãre, niipetirije ñañaro cʉ̃ja ca biiro cʉ̃ ca tiirijere yʉre wederucuma. ");
INSERT INTO baoNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Mecʉ̃ra ano pee doojapi, mʉ wãmere ca ĩi nʉcʉ̃ bʉorã niipetirãre, paia wiorã cʉ̃ja ca doti cojoro mena tia cũurica wiipʉ cʉ̃jare jee waarʉgʉ —ĩi yʉʉupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","To biro cʉ̃ ca ĩiro, Wiogʉ pea o biro cʉ̃re ĩiupi ñucã: —Waagʉja. Bojoca, ape yepari macãrãpʉre, ñucã cʉ̃ja wiorãre, to biri israelitas bojocare, yʉ yee quetire ca wede yujupʉ yʉ ca ami dica woojãgʉ niimi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yʉ yee jʉori, bʉaropʉra ñañaro tamʉoriquere cʉ̃re yʉ ĩñorucu —ĩiupi Ananías're. ");
INSERT INTO baoNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","To biro cʉ̃ ca ĩiro tʉo, Saulo cʉ̃ ca niiri wiipʉ waacoaupi Ananías. Cʉ̃ pʉtopʉ jãa ea, cʉ̃ amori mena cʉ̃re ñia peo, o biro cʉ̃re ĩiupi: —Yʉ yee wedegʉ Saulo, Wiogʉ Jesús, maa mʉ ca dooro mʉre ca baua earicʉ, ano mʉ pʉtopʉ yʉre tiicojojãwi, ñucã ĩa, Añuri Yerire boca ami, mʉ ca biipere biro ĩigʉ —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","To biro cʉ̃re cʉ̃ ca ĩirora wai nʉtʉ̃re biirije cʉ̃ capepʉre ca niirique ca ñaarora, añuro ĩacoaupi ñucã Saulo. To cõrora wãmʉ nʉcã, uwo coe ecoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jiro, baa, upʉ tutua, biicoaupi ñucã Saulo. To biro bii cati, Damasco macãrã Jesús yee quetire ca tʉo nʉnʉjeerã mena jĩcã rʉmʉri niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Jiro Saulo cʉ̃ja ca nea poo juu bueri wiijeripʉ, “Jesús Ʉmʉreco Pacʉ Macʉ̃ra niimi” ĩi wede jʉo waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","To biro cʉ̃ ca ĩi wedero ca tʉorã niipetirã do biro pee ĩi majiticã, o biro ĩi jãiñarucuupa: —¿Ania Jerusalén'pʉ Jesús're ca tʉo nʉnʉjeerãre ca jĩarʉga nʉnʉjeerucujãgʉ méé cʉ̃ niiti? ¿Ano macãrã cãare ñee waari, paia wiorãpʉre tiicojorʉgʉ ca dooricʉ méé cʉ̃ niiti? —ameri ĩiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Saulo pea cʉ̃jare cʉ̃ ca wederije cõrora õo pee jañuro uwiricaro maniro cʉ̃jare wede nʉnʉa waa, “Jesús Ʉmʉreco Pacʉ cʉ̃ ca tiicojoricʉra niimi” cʉ̃ ca ĩirije mena Damasco macãrã judíos're, do biro pee cʉ̃ja ca ĩi majitiropʉ cʉ̃jare tiicãupi Saulo. ");
INSERT INTO baoNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Paʉ rʉmʉri jiro judíos, Saulore jĩarʉgarã ameri wede peniupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Cʉ̃ pea teere queti tʉoupi. Cʉ̃re jĩarʉgarã, ñamiri, ʉmʉrecori tii macãre witi waarica joperi cõrorena cʉ̃re cũmurucuupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","To biro cʉ̃re cʉ̃ja ca tiirʉgarijere majiri, Saulo cʉ̃ ca wederijere ca tʉo nʉnʉjeerã pea, piiwʉpʉ cʉ̃re jãari, ñamira tii macãre cʉ̃ja ca wee camota amojoderica tʉdipʉra cʉ̃re yoo duwiocã cojoupa. To biro bii, duticoaupi Saulo. ");
INSERT INTO baoNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulo, Jerusalén'pʉ eagʉ, Jesús're ca tʉo nʉnʉjeerã mena niirʉgamiupi. Cʉ̃ja pea niipetirãpʉra cʉ̃re uwi jañuupa. “Bii ditogʉ biimi. Jesús're ca tʉo nʉnʉjeegʉ méé niicumi,” cʉ̃re ĩi uwi tʉgoeñari. ");
INSERT INTO baoNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","To biro cʉ̃ja ca ĩi pacaro, Bernabé pea, Jesús buerã pʉtopʉ cʉ̃re ami waaupi. Toopʉ cʉ̃re ami ea, “Maapʉ, Wiogʉ Jesús cʉ̃re cʉ̃ ca baua earo cʉ̃ ca ĩariquere cʉ̃re cʉ̃ ca wederiquere, Damascopʉ Jesús yee quetire uwiricaro maniro cʉ̃ ca wederiquere, yʉre wedejãwi ani Saulo,” cʉ̃jare ĩi wedeupi Bernabé. ");
INSERT INTO baoNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","O biro bii, cʉ̃ja mena Jerusalén macãre tuari, ape tabe pee waacoarucu, uwiricaro maniro, Wiogʉ Jesús yee quetire wede, ");
INSERT INTO baoNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","judíos, griego ca wederã mena wede peni, tutuaro mena cʉ̃jare wede majio, tii niiupi; cʉ̃ja pea cʉ̃re jĩacãrʉgaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Jesucristore ca tʉo nʉnʉjeerã pea to biro cʉ̃re cʉ̃ja ca tiirʉgarijere majiri, Cesareapʉ cʉ̃re ami bʉa waa, Tarso pee cʉ̃re tiicojocã cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","To cõrore Jesucristore ca tʉo nʉnʉjeerã, Judea, Galilea, to biri Samaria yepari macãrã niipetirãpʉ añuro jĩcãri cõro nii, Ʉmʉreco Pacʉ yee quetire bʉaro jañuro tʉgoeña bayi, bii mʉa nʉcã nʉnʉa waa, Wiogʉre añuro tii nʉcʉ̃ bʉorique mena, Añuri Yeri cʉ̃ ca tii nemoro mena, paʉ Jesucristore ca tʉo nʉnʉjeerã nii nʉnʉa waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pedro, Jesucristore ca tʉo nʉnʉjeerãre ca ĩa yuju waarucugʉ niiri, Lidapʉ ca niirã Jesucristore ca tʉo nʉnʉjeerã cãare ĩagʉ waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Toopʉre bʉa eaupi jĩcʉ̃, Eneas ca wãme cʉtigʉ, bʉʉcãri waari méé, jĩcã amo peti, ape amore itiaga penituaro ca niiri cʉ̃mari peti, cãni pejarica tabepʉ ca peja yai waagʉre. ");
INSERT INTO baoNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Cʉ̃re o biro ĩiupi Pedro: —Eneas, mʉ ca diarique cʉtirijere Jesucristo mʉre ametʉenemi. Wãmʉ nʉcãri, mʉ ca pejaritore quenoña —cʉ̃re ĩiupi. To biro cʉ̃ ca ĩirije menara, wãmʉ nʉcãcoaupi Eneas. ");
INSERT INTO baoNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Niipetirã Lida, Sarón macãrã Eneas cʉ̃ ca catirijere ĩari, Jesucristo peere tʉo nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Ñucã tii cʉ̃marirena Jope macãpʉre niiupo jĩcõ, Jesucristore ca tʉo nʉnʉjeego Tabita, ca wãme cʉtigo. Griego wederique menara Dorcas wãme cʉtiupo. Cõ pea añurijere tii, ca boo pacarãre tii nemo, tii niirucuupo. ");
INSERT INTO baoNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Tii rʉmʉrira diarique tamʉo bii yaicoaupo Dorcas. Cõ ca bii yairo ĩa, cõ upʉri niiquĩriquere coe yapano, jotoa macã jawi pee peocãupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Pedro cʉ̃ ca earica macã Lida pea, Jope macã pʉtoacãra niiupa. To biri Jope macãrã Jesucristore ca tʉo nʉnʉjeerã, “Lida macãrã niijagʉ Pedro,” cʉ̃ja ca ĩirijere tʉori, “ ‘Yoari méé Jopepʉ dooya,’ cʉ̃re ĩirãja ĩirã,” pʉarã ʉmʉare tiicojo cojoupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","To biri Pedro pea yue mani waaricaro maniro cʉ̃ja mena waacoaupi. Tii macãpʉ cʉ̃ ca earo, cõ upʉri niiquĩriquere cʉ̃ja ca peorica jawipʉ cʉ̃re jʉo waaupa. Toopʉ cʉ̃ ca earo, niipetirã ca manʉ jʉ̃mʉa dia weo ecoricarã romiri, Dorcas catigo juti, jotoa jãñarique cʉ̃jare cõ ca tii bojariquere Pedrore ĩñori, oti amojodeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pedro pea too ca niirã niipetirãre cʉ̃jare witi waa doti, cʉ̃ ãjʉro jupeari mena ea nuu waa, juu bueupi. Juu bue yapano, ca bii yairico peere amojode ĩa cojo, o biro ĩiupi: —¡Tabita, wãmʉ nʉcãña! —cõre ĩiupi. To biro cõre cʉ̃ ca ĩirora, cõ capere ĩa pãa, Pedrore ĩagora wãmʉ nuucoaupo. ");
INSERT INTO baoNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","To cõrora Pedro pea cõ amorire ñee, cõre tʉ̃a wãmʉo nʉcõcãupi. To biro cõre tii, Jesucristore ca tʉo nʉnʉjeerãre, ca manʉ jʉ̃mʉa dia weo ecoricarã romirire jʉo cojo, ca catigopʉre cʉ̃jare ĩñoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Teere Jope macãrã niipetirã queti tʉo, paʉ bojoca Jesús're tʉo nʉnʉjeeupa. ");
INSERT INTO baoNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pedro pea paʉ rʉmʉri Jope macãre, Simón, ca wãme cʉtigʉ, waibʉcʉrã quejeri paderi majʉ yaa wiipʉ niicãupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Cesarea macãre niiupi jĩcʉ̃, cien niirã uwamarã ʉpʉ, uwamarã cʉ̃ja ca niiri tabe Italiano ca wãme cʉtiri tabe mena ca padegʉ Cornelio ca wãme cʉtigʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cʉ̃a, cʉ̃ yaa wii macãrã niipetirã menara, ca bojoca añugʉ, Ʉmʉreco Pacʉre ca ĩi nʉcʉ̃ bʉogʉ, judíos cʉ̃ja ca boo pacarijere tii nemogʉ pairo wapa tiirica tiiri tiicojo, Ʉmʉreco Pacʉre to birora juu buecõa nii, ca tiigʉ niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Jĩcã rʉmʉ, muipũ bʉaro cʉ̃ ca aji cõa cũu duwi waari tabe ca niiro, quẽñaricarore biro bii oto weti waagʉ, jĩcʉ̃ Ʉmʉreco Pacʉ yʉʉ cʉ̃re queti wede bojari majʉ, bau niiro cʉ̃ ca niiri tabepʉ jãa eari: —Cornelio —cʉ̃re ca ĩi jãiñagʉre ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","To biro cʉ̃re cʉ̃ ca ĩi jãiñaro, Cornelio pea Ʉmʉreco Pacʉ pʉto macʉ̃re ĩa, bʉaro uwirique menara: —¿Wiogʉ, ñeere mʉ booti? —cʉ̃re ĩi jãiñupi. To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩiupi: —Mʉ ca juu buerucurijere, ca boo pacarãre mʉ ca tii nemorijere, cʉ̃re mʉ ca tiicojo nʉcʉ̃ bʉorijere biro ĩami Ʉmʉreco Pacʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","To biri Jope macãpʉ jĩcãrãre tiicojoya, Simón ape wãme Pedro ca wãme cʉtigʉre cʉ̃ja jʉorã waajato ĩigʉ. ");
INSERT INTO baoNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Waibʉcʉrã quejeri ca padegʉ dia tʉjaro ca niigʉ, cʉ̃re birora Simón ca wãme cʉtigʉ yaa wiire niimi —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ʉmʉreco Pacʉ pʉto macʉ̃ cʉ̃ mena ca wede niiricʉ cʉ̃ ca waaro jiro, Cornelio pea cʉ̃ paderi maja pʉarãre, to biri jĩcʉ̃ uwamʉ to birora cʉ̃ mena ca niicõa niigʉ Ʉmʉreco Pacʉre ca nʉcʉ̃ bʉogʉre, jʉo cojori, ");
INSERT INTO baoNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ca biirique niipetirije cʉ̃jare wede yapano, Jope macãpʉ cʉ̃jare tiicojocã cojoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ape rʉmʉ cʉ̃ja pea maapʉ waa nʉnʉa waarã, Jope macãre cʉ̃ja ca ea nʉnʉa waaro, Pedro pea, muipũ jotoa decomacã eagʉ doogʉ cʉ̃ ca biiro, juu buegʉ waagʉ, wii jotoa macã yepa pee mʉa waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Bʉaro queyari, baarʉgaupi. Cʉ̃re cʉ̃ja ca baarique queno boja ditoye, jĩcã wãme quẽñaricarore biro bii oto weori cʉ̃re ca bii ĩñorijere ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ʉmʉreco quejero ca pãa nʉcãro juti quejerore biiri quejero pairi quejero, tii quejero yaparire bapari taberi jiarica quejero yepa pee ca ñaañumu duwi dooro ĩaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Tii quejeropʉre, bapari dʉpori ca cʉorã waibʉcʉrã cʉ̃ja ca niiro cõro, yepa cũari ca waarã, ca wʉʉrã, niiupa. ");
INSERT INTO baoNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","To biro cʉ̃re ca biiri tabera o biro ca ĩirijere tʉoupi Pedro: —Wãmʉ nʉcãña Pedro. Waibʉcʉrãre jĩari baaya —ĩiupe. ");
INSERT INTO baoNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","To biro ca ĩiro, Pedro pea o biro ĩi yʉʉupi: —Biiticu níja, Ʉpʉ. Yʉa jĩcãti ʉnora ñañarãre, docuorãre, yʉ baa ñaati —ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","To biro cʉ̃ ca ĩiro, wederique pea o biro cʉ̃re ĩi nemoupe ñucã: —Ʉmʉreco Pacʉ añurã cʉ̃ ca tiiricarãre, “Ñañarã niima,” ĩiticãña mʉa —ĩiupe. ");
INSERT INTO baoNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Itiati peti to biro biiupe. Jiro tii quejero ʉmʉrecopʉ mʉacoaupe ñucã. ");
INSERT INTO baoNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pedro pea to biro cʉ̃re ca bii ĩñorijere, “¿Ñee ʉno petire ĩirʉgaro to biibuti yéé?” cʉ̃ ca ĩi tʉgoeñarique pai niirucurora, Cornelio cʉ̃ ca jʉo doti cojoricarã pea Simón yaa wiire ca jãiña ama nʉnʉa waaricarã, cʉ̃ yaa wii jope petire ea yerijãaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","To earãra, tutuaro mena: —¡Cã́jí! ¿Ati wiira to niiti Simón Pedro cʉ̃ ca cãniri wii? —ĩi jãiñaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ména Pedro pea, cʉ̃re ca bii ĩñorijere cʉ̃ ca tʉgoeña niirora, Añuri Yeri pea o biro cʉ̃re ĩiupʉ: “Ĩaña. Ʉmʉa itiarã mʉre amarã eama. ");
INSERT INTO baoNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wãmʉ nʉcã duwi waa, ‘Yʉ waati,’ ĩitigʉra, cʉ̃ja mena waagʉja. Yʉra yʉ ca tiicojojãrã niima,” cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","To biro cʉ̃ ca ĩiro Pedro pea duwi waa: —Anora yʉ nii. Yʉra yʉ nii, mʉja ca amagʉ. ¿Ñeere mʉja ĩi doojãri? —cʉ̃jare ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","To biro cʉ̃ ca ĩiro, o biro cʉ̃re ĩi yʉʉupa: —Uwamarã wiogʉ Cornelio, ca bojoca añugʉ, Ʉmʉreco Pacʉre ca nʉcʉ̃ bʉogʉ, judíos niipetirã cʉ̃ja ca nʉcʉ̃ bʉogʉ cʉ̃ ca doti cojoro jãa doojãwʉ. Jĩcʉ̃ Ʉmʉreco Pacʉ yʉʉ, cʉ̃re queti wede bojari majʉ cʉ̃re baua eari, cʉ̃re jʉo doti cojoya ĩijapi mʉre, cʉ̃ yaa wiipʉ waari, mʉ ca ĩirijere cʉ̃ ca tʉopere biro ĩigʉ —cʉ̃re ĩiupa Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","To biro cʉ̃re cʉ̃ja ca ĩirijere tʉo, “Jãa dooya” cʉ̃jare ĩi, tii ñamire toora cãni, ape rʉmʉ cʉ̃ja mena waacoaupi Pedro. Jĩcãrã Jope macã macãrã Jesucristore ca tʉo nʉnʉjeerã cʉ̃re bapa cʉti waaupa. ");
INSERT INTO baoNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Jĩcã rʉmʉ jiro Cesareare ea waaupa, Cornelio pea cʉ̃ yaarã, cʉ̃ mena macãrã majurope cʉ̃ ca jʉo neoricarã mena yue niiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pedro, wiipʉ cʉ̃ ca earo, Cornelio cʉ̃re jãi bocagʉ witi waagʉ, cʉ̃re ĩi nʉcʉ̃ bʉorʉgʉ, cʉ̃ ãjʉro jupeari mena ea nuu waaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","To biro cʉ̃ ca biiro ĩa, Pedro pea cʉ̃re wãmʉ nʉcã dotiri, o biro ĩiupi: —Wãmʉ nʉcãña. Yʉ cãa mʉre birora bojocʉ yʉ nii —cʉ̃re ĩiupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","To biro ĩi, cʉ̃ mena wede peni jãa waagʉ, paʉ bojoca ca nea pooricarãre bʉa eaupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Jãa ea, o biro ĩiupi Pedro: —Mʉja añuro mʉja maji, jãare ca dotirije, judíos ca niitirã mena nii dotiti, cʉ̃jare ĩa yuju dotiti, jãare ca biirijere. Ʉmʉreco Pacʉ pea jĩcʉ̃ ʉno peerena, “ ‘Ñañagʉ, docuogʉ niimi,’ ĩiticãña,” yʉre ĩi majiojãwi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","To biri yʉre ca jʉorã waaricarãre, “To biro mʉre ĩi cojojãwi,” yʉre cʉ̃ja ca ĩirijere tʉogʉ, “Yʉ waati” ĩitigʉra, yʉ doocã doojãwʉ. To biri yʉ majirʉga ¿ñeere ĩirã yʉre mʉja jʉojãri? —cʉ̃jare ĩiupi Pedro. ");
INSERT INTO baoNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","To biro Pedro cʉ̃ ca ĩi jãiñaro, o biro cʉ̃re ĩi yʉʉupi Cornelio: —Mee bapari rʉmʉ ametʉa, ano cõrora muipũ bʉaro cʉ̃ ca aji cõa cũu duwi waari tabe ca niiro, ano yʉ yaa wiira juu buegʉ yʉ tiiwʉ. Tee jãa ca ĩiña maniri tabera jĩcʉ̃ ʉmʉ yʉ jʉguerore juti ca ajiyaa boe baterije jãñacãricʉ baua ea, ");
INSERT INTO baoNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","o biro yʉre ĩiwi: “Cornelio, Ʉmʉreco Pacʉ mʉ ca juu buerijere tʉo, ca boo pacarãre mʉ ca tii nemorijere majimi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","To biri Jope macãpʉ jĩcãrãre tiicojoya Simón, cʉ̃ buirica wãme peera Pedro cʉ̃ja ca ĩigʉ, apĩ Simón, waibʉcʉrã quejeri ca padegʉ dia tʉjaro ca niigʉ yaa wiipʉ ca niigʉre cʉ̃ja jʉorã waajato ĩigʉ,” yʉre ĩiwi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","To biri yue mani waaricaro maniro mʉre yʉ jʉo doti cojojãwʉ. Mʉ pea añuro mʉ doojapa. Mecʉ̃ra anore, niipetirã Ʉmʉreco Pacʉ jʉguerore mani nii, to biri Ʉpʉ mʉre cʉ̃ ca ĩi doti cojorique niipetirije jãare mʉ ca wedero jãa tʉorʉga —cʉ̃re ĩi yʉʉupi Pedrore. ");
INSERT INTO baoNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","To cõrora Pedro o biro ĩi wede jʉoupi: —Mecʉ̃ra díámacʉ̃ra Ʉmʉreco Pacʉ bojocare cʉ̃ ca ĩa dica wootirijere yʉ maji. ");
INSERT INTO baoNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Niipetiri poogaari macãrã cʉ̃re ĩi nʉcʉ̃ bʉo, ca niirore biro añurijere tii, ca tiirãre añuro cʉ̃jare ĩami. ");
INSERT INTO baoNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ʉmʉreco Pacʉ, niipetirã Wiogʉ ca niigʉ Jesucristo mena, Israel yaa pooga macãrãre jĩcãri cõro añuro niirique añurije quetire tiicojoupi. ");
INSERT INTO baoNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mʉja maji ate añurije queti, uwo coerique maquẽre Juan cʉ̃ ca wedero jiro Galilea mena bii jʉo waaro, Judea yepa niipetiropʉ ca bii jeja nʉcã waariquere. ");
INSERT INTO baoNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ʉmʉreco Pacʉ, Jesús Nazaret macʉ̃re Añuri Yeri jʉori, niipetirije cʉ̃ ca tii majipere cʉ̃ ca tiicojoricʉ niiri, ñucã cʉ̃ menara Ʉmʉreco Pacʉ cʉ̃ ca niiro macã añurije maquẽre bojocare tii boja, niipetirã Satanás ñañaro cʉ̃ ca tiirã cãare ametʉene, cʉ̃ ca tii yujurique cãare mʉja maji. ");
INSERT INTO baoNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","3