﻿USE sofia;
DROP TABLE IF EXISTS sofia.azzNT_vpl;
CREATE TABLE azzNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES azzNT_vpl WRITE;
INSERT INTO azzNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Nican pehua in tajcuilolamat ten cuica tocayme de neque huejcautetatme de Jesucristo; nochin yejuan panocque ya. Huan Jesucristo catca teconeu de rey David, huan no teconeu den Abraham. ");
INSERT INTO azzNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Huan in tetat Abraham quiscaltij in Isaac; huan niman Isaac catca no tetat de Jacob; huan niman in Jacob catca no tetat de Judá huan iicnihuan. ");
INSERT INTO azzNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Huan in tetat Judá ihuan in tenan Tamar quiniscaltijque in Fares huan Zara; huan niman in Fares catca no tetat de Esrom; huan niman in Esrom catca no tetat de Aram. ");
INSERT INTO azzNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Huan in tetat Aram quiscaltij in Aminadab; huan niman in Aminadab catca no tetat de Naasón; huan niman Naasón catca no tetat de Salmón. ");
INSERT INTO azzNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Huan in tetat Salmón ihuan in tenan Rahab quiscaltijque in Booz; huan niman in tetat Booz ihuan in tenan Rut quiscaltijque in Obed; huan niman in Obed catca no tetat de Isaí. ");
INSERT INTO azzNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Huan in tetat Isaí quiscaltij in tetat rey David; huan in rey David ihuan isihuau de Urías quiscaltijque in Salomón. ");
INSERT INTO azzNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Huan in tetat Salomón quiscaltij Roboam; huan niman in Roboam catca no tetat de Abías; huan niman in Abías catca no tetat de Asa. ");
INSERT INTO azzNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Huan in tetat Asa quiscaltij in Josafat; huan niman in Josafat catca no tetat de Joram; huan niman in Joram catca no tetat de Uzías. ");
INSERT INTO azzNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Huan in tetat Uzías quiscaltij in Jotam; huan niman in Jotam catca no tetat de Acaz; huan niman in Acaz catca no tetat de Ezequías. ");
INSERT INTO azzNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Huan in tetat Ezequías quiscaltij in Manasés; huan niman in Manasés catca no tetat de Amón; huan niman in Amón catca no tetat de Josías. ");
INSERT INTO azzNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Huan in tetat Josías quiscaltij in Jeconías huan iicnihuan tech in tonalme cuac quinuiyacque queme presos nochi in pueblojuani de Israel hasta in país de Babilonia. ");
INSERT INTO azzNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nimampa de que quinuiyacque in pueblojuani de Israel hasta Babilonia, ijcuacón in tetat Jeconías quiscaltij in Salatiel; huan niman in Salatiel catca no tetat de Zorobabel. ");
INSERT INTO azzNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Huan in tetat Zorobabel quiscaltij in Abiud; huan niman in Abiud no catca tetat de Eliaquim; huan niman in Eliaquim catca no tetat de Azor. ");
INSERT INTO azzNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Huan in tetat Azor quiscaltij in Sadoc; huan niman in Sadoc no catca tetat de Aquim, huan niman in Aquim no catca tetat de Eliud. ");
INSERT INTO azzNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Huan in tetat Eliud quiscaltij in Eleazar; huan niman in Eleazar no catca tetat de Matán, huan niman in Matán catca no tetat de Jacob. ");
INSERT INTO azzNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Huan in tetat Jacob quiscaltij in José naquen iyoquich María. Huan María catca inantzin de Jesús, huan yejuan quitocaytijque in ioquichpilconetzin Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Huan desde ne tonalme cuac nemico in Abraham ijcuacón peuque motetecpantihualajque ne majtactionnahui tetatme hasta ejcoc in tonalme cuac nemico in rey David. Huan no desde ne tonalme cuac nemico in rey David, ijcuacón peuque motetecpantihualajque ocsé majtactionnahui tetatme hasta ejcoc in tonalme cuac quinuiyacque in pueblojuani de Israel queme presos hasta in país de Babilonia. Huan no desde ne tonalme cuac quinuiyacque in pueblojuani de Israel queme presos ijcuacón peuque motetecpantihualajque ocsé majtactionnahui tetatme hasta ejcoc in tonalme queman yolico in oquichpilconetzin Cristo Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ijcón yolico in oquichpil Jesucristo: María catca inantzin de Jesucristo. Yetoya ya tajtol ya de que mosennamictisque in María ihuan in José. Huan ijcuacón ayamo sen yetoyaj. Huan mochihuac que in María cocoxcayetoya ya ica pili porín ica ne chicahualis de Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Huan in José catca iyoquich in María huan catca yolmelaucatagat huan amo quinequía quipinautisquía in María senteixteno. Huan in José quinemiliaya mosecocahuas de María huan amo quinequía ma quimatican nión ocsé pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Huan ijcón yejua quinemiliaya quisecocahuas in María. Huan cuac tacochitztoya in José, ijcuacón monextilijtzinoco se ángel taquehual de Dios huan quilij ijcuín: ―José titeconeu de rey David, amo ximomouti de ticselis in María queme mosihuatzin, porín in Yecticatzin Espíritu quiscaltij ya in pili ten María quipixtoc ya. ");
INSERT INTO azzNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Huan niman in María quiyolitis se iconetzin huan quitocaytis Jesús Temaquixtijque, porín Yejuatzin ne quinmaquixtis nochi in pueblojuani den senmanahuac de nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Huan nochi nijín mochihuac para ma ijcón motamichihua in tajtol ten Totecotzin quijtojca ica por ne tanahuatijque Isaías cuac quijcuiloj ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Xiquitacan, se suapil ten ayamo quipía se tagat, yejua ne mopilcuis huan quiyolitis se oquichpil huan quitocaytis Emanuel, ten quijtosnequi “Totajtzin Dios tohuan yetica”. ");
INSERT INTO azzNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Huan cuac in José ixpetanic den nicochilis, ijcuacón quichihuac ijcón queme quinajnahuatico in ángel taquehual de Dios. Huan José quiselij in María queme nisihuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero ayamo sen yetoyaj queme namicuani hasta in tonal cuac in María quiyolitij in tayecancaoquichpil. Huan yejuan quitocaytijque in oquichpil Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Huan Jesús yolico tech in pueblo den monotza Belén ten de itatilanal in Judea tech in tonalme cuac Herodes catca tayecanque rey itech nojón país. Ijcuacón ejcotihualayaj tech ne pueblo de Jerusalén sequi taca semi tamatinime den hualayaj iquisayampa in tonal; huan nijinques tamatinime catcaj in magos. ");
INSERT INTO azzNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Huan in magos matajtantihualajque ijcuín: ―¿Can yetoc in tayecanque den judíos ten yequin yolico? Tejuan tiquitacque nepa iquisayampa in tonaltzin se hueyi sitalin de Yejuatzin ten techualnextiliaya campa yetoc in oquichpil Jesús. Huan tejuan tihualajque nican para ticmohuistilisque Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Huan cuac in rey Herodes quicayic nijín tajtolme, ijcuacón pehuac moyolcuejmoloa. Huan hasta nochi in tagayot den Jerusalén no moyolcuejmolojque. ");
INSERT INTO azzNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ijcuacón in tayecanque Herodes tanahuatij ma mosentilican nochi in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés. Huan de ompa in Herodes quintajtanilij ijcuín: ―¿Xe ipa nanquimatocque ya can yolis in oquichpil ten monotza Cristo Temaquixtijque? ");
INSERT INTO azzNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Huan yejuan quinanquilijque ijcuín: ―Tech ne pueblo de Belén ten itatilanal Judea, ompa yolis. Porín in tanahuatijque de Dios quijcuilojca ya ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Huan tejua pueblo de Belén, tipohui campa in Judá, tejua amo titziquitzin. Ta, tihueyichiuque ya itech in tayecanani de ne pueblo de Judá. Porín motzalan ehuas se tayecanque naquen quinyecanas nochi nopueblojcahuan de Israel. ");
INSERT INTO azzNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ijcuacón Herodes quinichtacanotzac in tamatinime in magos huan quinyectajtoltiaya catijyejua tonal monextij ne hueyi sitalin. ");
INSERT INTO azzNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Huan de ompa in rey Herodes quintitanic in magos hasta ne pueblo de Belén. Huan quinilij ijcuín: ―Xiyacan ompa xicyectemocan xicyecmatican toni chicahualis cualcui ne oquichpil ten yequin yolico. Huan cuac nancajsisque ya ne oquichpil, ijcuacón nechnejmachtican para ma nejua no niyás huan para nicmohuistilitiu. ");
INSERT INTO azzNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Huan cuac ijcón quicaquilijque in rey, ijcuacón yajque in tamatinime in magos. Huan in sitalin ten quitacque de ne iquisayampa tonal ijcón quinyecanaya in magos huan quinajxitij huan quinnextilij campa huetztoya in oquichpil Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Huan cuac in tamatinime in magos ejcotihualayaj ya, huan cuac quitacque ya in sitalin, ijcuacón semi moyolpacticque. ");
INSERT INTO azzNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Huan cuac calactiayaj ya calijticpa, ijcuacón quitacque in oquichpil ihuan inantzin María. Huan motancuaquetzatoj huan motentocatoj iixpantzinco para quimohuistiliayaj in oquichpilconet. Huan de ompa niman quitapojque in cajones tenica cualcuíaj ninricojyo. Huan quitayocolijque yejua nijín taman; in oro ten cajcahuanía, huan in copal, huan sequi ajuiyacachoquilot ten monotza mirra. ");
INSERT INTO azzNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Huan niman Totajtzin Dios quinnejmachtij huan quinmatiltij in tamatinime in magos itech nincochilis ma amo monequía ma panocan campa yetoya in rey Herodes. Ijcuacón in magos quitachicopahuijque in pueblo de Jerusalén huan ijcón yajque itech ninpueblo. ");
INSERT INTO azzNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Huan satepan cuac yajque ya in tamatinime magos, ijcuacón se ángel taquehual de Dios quionmonextilij cuac tacochitztoya in José huan quilij ijcuín: ―Ximoquetza, José, huan xicui mooquichpilconeu ihuan ninantzin huan xiyacan xicholocan huan xiyetotiu tech ne país de Egipto. Huan ompa xiyetotiu hasta cuac nejua ocsepa namechnejmachtis que ximocuepacan, porín in rey Herodes quiyolnemilijtoc que quitemos in moconeu para quimictis. ");
INSERT INTO azzNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Huan in José ixpetanic huan moquetzac huan quincuic iconetzin ihuan ninantzin huan yajque cayohual huan ajsicque tech ne pueblo Egipto. ");
INSERT INTO azzNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Huan ompa yetoyaj hasta in tonal cuac miyic in rey Herodes. Huan ijcón mochihuac ten quijtojca ya Totajtzin Dios itencopa itanahuatijcau cuac ne queman ya quijcuilojca ya ijcuín: “Tech ne país Egipto nicnotzac noconetzin”. ");
INSERT INTO azzNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Huan cuac in rey Herodes momacac cuenta que in tamatinime magos quicajcayauque ya, ijcuacón yejua mohueyicualantij huan quintitanic soldados ma quinmictican nochi in telpocame de ome xihuit para tani ten calyetoyaj tech ne pueblo Belén huan no tech ne pueblos ten quiyehualojtoyaj Belén. Porín in rey Herodes quimatic que ayamo panoaya ome xihuit desde cuac quilijcaj in tamatinime in magos que yolic ya in Jesucristo. ");
INSERT INTO azzNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ijcuacón mochihuac ten quijtojca Dios itencopa itanahuatijcau Jeremiás cuac quijcuilojca ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Mocayic se tajtolis tech ne pueblo Ramá, ten mocaquía huan chocayaj huan yolnejsihuíaj huan moyolcocotinemíaj. Yejua ne in tenan Raquel ten chocaya porín momiquilijque ya niconehuan. Huan amo quinequía que acsá quiyoltalisquía porín poliuque ya niconehuan. ");
INSERT INTO azzNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Huan niman miyic ya in rey Herodes; huan de ompa se ángel taquehual de Dios quimonextilij ocsepa tech icochilis José, cuac in José ompa yetoya tech pueblo de Egipto, huan quilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","―Ximoquetza, xiquincui moconetzin ihuan ninantzin huan ximoquepacan tech ne pueblo Israel porín micque ya nochi ten quinequíaj quimictisque moconeu Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ijcuacón moquetzac José huan cuiyac iconeu Jesús ihuan inantzin huan yajque ajsicque tech in pueblo Israel. ");
INSERT INTO azzNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Huan in José quimatic que in tayecanque Arquelao yetoya rey tech ne tal ten pohuía Judea huan yejua tayecantoya iixpatca nitat Herodes. Huan ica ya nojón José momoutiaya huan amo quinequía calyetos ompa tech in pueblo de Judea campa yetoya ne tayecanque Arquelao. Huan Dios quinejmachtij in José ocsepa itech nicochilis ma yohui ma ompa calyetoti tech ne tal ten pohuía Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Huan cuac José ajsito ya tech ne tal de Galilea, ijcuacón ompa calyetoto ya ne pueblo monotza Nazaret. Huan ijcón mochihuac ten quijtojcaj ya itanahuatijcau de Dios cuac quijcuilojque de Jesús in Temaquixtijque ijcuín: “Yejua ne yesqui se pueblojcat de Nazaret”. ");
INSERT INTO azzNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Huan tech ne tonalme in Juan Taahuijque ajsic tech in Judea tech se tamanisyo campa tayiucan huan quitetapohuijtihualaya in yancuic Tajtoltzin de Dios ten cualcui ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Huan Juan quiniliaya in tacaquini ijcuín: ―Ximoyolnemilican de namotajtacoluan porín motoquijtoc ya Dios den eluiyactzinco huan quimonequiltis quinyolyecanas huan momasoutos ica ihueyichicahualis nochi itaneltocacahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaías yejua itanahuatijcau de Dios quijcuilojca de nijín Juan Taahuijque cuac quijtojca ya ijcuín: Mocaquiti se tagat ten tanajnahuatía campa tayiucan huan quijtoj ijcuín: “Xitayectalijtiyacan ninemilispan den Totecotzin. Huan xicmejmelautiyacan niojuan campa hual panotihualas”. ");
INSERT INTO azzNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Huan ne Juan motaquentiaya ica camellojtojmit den taijquitil, huan tajcuilpitoya ica se cuetax huan quicuaya chapolinme huan cuoutajnecti. ");
INSERT INTO azzNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Huan hualayaj miacque pueblojuani quicaquiquij in Tajtoltzin de Dios den Juan quintetapohuiaya. Huan no hualajque nochi pueblojuani ten pohuíaj ne Jerusalén huan ten pohuíaj ne Judea, huan nochi ten calyetoyaj campa panoaya in hueyíat Jordán. ");
INSERT INTO azzNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Huan ijcón in Juan quinahuía in tacaquini ica at tech in hueyíat den monotza Jordán como yejuan moyolnemiliayaj den nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Huan ijcón in Juan quitac que hualajque miacque fariseos ihuan in saduceos huan yejuan quinequíaj ma quinahui yejua. Ijcuacón in Juan quinilij ijcuín: ―¡Namejuan nantacajcayahuani san queme in cohuame! ¿Aconi namechnejmachtij ya que monequi nanmochololtisque de ne hueyi tatzacuiltilis ten hualajtoc ya? ");
INSERT INTO azzNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Xichipaucanemican para ijcón ixnesis senteixteno que nanmoyolnemilijque ya de namotajtacol huan nanyolchipauque ya iixpantzinco Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Huan ma amo ximoyolueyichihuacan san namejuan cuac nanquinemilíaj que namejuan nanteixuihuan den ne hueyi tanahuatijque de Dios Abraham. Porín xicmatican que amo teyica namechpalehuis ica nojón tajtólme. Porín namechyequilía que Dios cuali hueli quinchihuas ica nijín teme ocsequin teixuihuan de Abraham ten tacuautamatinemij ihuantzinco Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Huan no in Juan quinilij in tacaquini ijcuín: ―Huan axcan ya como amo nanmoyolnemilíaj de namotajtacoluan, ijcuacón namejuan nanyesque queme cuoume ten amo teyi taquij. Huan nochi cuoume ten amo cuicaj taquilot ten cuali, ijcón in tequitini quinnaluayojtequisque ica hacha, huan quitamotasque tech tit ma chichinahui. ");
INSERT INTO azzNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Huan nejuatzin de yec melau, namechahui ica at queme se nexcuitil que nanmoyolnemilijque ya den namotajtacol huan nanyolchipauque ya. Huan naquen nechualtojtoca, Yejuatzin ne namechquemilos huan namechyolpepexocaltis ica in Yecticatzin Espíritu huan namechyolchipahuas de namotajtacoluan ijcón queme in tit quichipahua tensá. Huan Yejuatzin cachi quipía hueyi chicahualis, huan nejua niamoteyi nichiuque, huan amo nechnamiquis ma nicuica nitegac. ");
INSERT INTO azzNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Huan ne Temaquixtijque quichihuati ijcón queme tejuan ticchihuaj cuac ticchipahuaj in trigojtet ica ne tapipitzaloni. Huan ticololoaj in trigojtet huan tiquehuaj campa trigojcal huan in tajsol ticchichinoaj. Huan tejuan como titacuautamatij ihuan ne Temaquixtijque, ijcuacón Yejuatzin techsepantalía ihuantzin seco san. Huan neques ten amo tacuautamatij ihuantzin, yejuan nojonques quintamotasque campa tatzacuiltilis de tit de amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ijcuacón Jesús hualehuac de ne Galileajcopaca huan ejcoco campa Juan in Taahuijque tech ne atenteno den hueyíat Jordán. Huan Jesús quinequía ma in Juan ma quiahuini in Jesús mismo. ");
INSERT INTO azzNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Huan cuac pehuac quilía, ijcuacón Juan amo quinequía quiahuis in Jesús. Ica ya nojón in Juan quilij ijcuín: ―¿Queyé Tejuatzin tihuala para ma nimitzonahuis? Ta, monequía ma Tejuatzin xinechahui. ");
INSERT INTO azzNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ijcuacón in Jesús tananquilij ijcuín: ―Xicsecocahua ten tejua ticnemilía porín semi quinamiqui ma ticchihuacan Dios itahuelitalis nochi queme Dios quimonequiltía. Huan de ompa in Juan motemactij de que quiahuis in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Huan cuac quiahuij ya Jesús, ijcuacón nimantzin Yejuatzin ajcopanquisac den hueyíat. Huan ijcón tatapohuic tech eluiyac huan Jesús quitac in Yecticatzin Espíritu de Totajtzin Dios ten hual temoaya queme se tototzin paloma huan calayic itech Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Huan no ijcón no mocaquic se tajtolis den eluiyactzinco ten Yejuatzin quijtoaya ijcuín: ―Yejuatzin nijín Notasojconetzin tenica semi nimoyolpaquiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Huan de ompa in Yecticatzin Espíritu quiyecanac Jesús ne campa tayiucan huan ompa in amocuali Satanás quielehuisuij ica tajtacol in Jesús para ma motajtacolmacani. ");
INSERT INTO azzNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Huan in Jesús mosahuaya nochi ne omepoal tonal huan omepoal yohual huan niman Yejuatzin quimachilij que mayanaya. ");
INSERT INTO azzNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Huan in amocuali Satanás motoquij campa Yejuatzin para quielehuisuij Jesús ica tajtacol ma motajtacolmacani; huan in Satanás quilij ijcuín: ―Como melau Tejuatzin tion Teconetzin de Dios, xicnahuati nijín teme ma mocuepacan panes. ");
INSERT INTO azzNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ijcuacón in Jesús tanaquilij ijcuín: ―Quijtoa in Tajcuilolamatzin de Dios ijcuín: “In taca ma nemican amo sayó ica in tacualis san. Ta, no ma yolpepexocatinemican ica nochi in tajtolme ten Dios techmactilijtinemi”. ");
INSERT INTO azzNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ijcuacón in amocuali Satanás cuiyac Jesús tech ne mohuistic pueblo de Jerusalén. Huan quitejcoltij itech se tepeyo den tepepan. ");
INSERT INTO azzNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Huan in amocuali Satanás quilij Jesús ijcuín: ―Como melau Tejuatzin tion Teconetzin de Dios, ximosencahua xihuetziti de nican hasta talixco. Porín no quijtoa in Tajcuilolamatzin de Dios ijcuín: Dios quinualtitanis in ángeles taquehualme de Dios ma mitzyecpalehuican. Huan no quijtoa in Tajcuilolamatzin ijcuín: Ma mitzmatzacuilican in ángeles ica ninmahuan para ma amo ximometzcojcoco ica in teme. ");
INSERT INTO azzNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Huan Jesús tanaquilij ijcuín: ―No quijtoa in Tajcuilolamatzin de Dios ijcuín: “Amo xictelpanoltis in tapalehuilis in Totecotzin Dios moyectencahuac de techmactilis”. ");
INSERT INTO azzNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Huan ocsepa in amocuali Satanás cuiyac Jesús tech se hueyi tepepan, huan ompa ocsepa in amocuali quinextilij Jesús nochi in pueblojme campa tayecanaj hueyi chihuanime de nican talticpac. Huan no quinextilij nochi ninueyipanchihualisme huan ninricojyo. ");
INSERT INTO azzNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Huan in amocuali Satanás quilij Jesús ijcuín: ―Tacán timotancuaquetzas huan timotentocas noixpan huan tacán tinechmohuistilis, ijcuacón nochi nijín ten tiquitztoc nimitzmactilis tejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ijcuacón in Jesús tananquilij ijcuín: ―Niman xiyó ya, tejua tiamocuali Satanás, porín quijtoa in Tajcuiloloamatzin de Dios ijcuín: “Ma xicmohuistiliti in Totecotzin to Dios huan sayó Yejuatzin xicmohuiscatequitilijtinemi”. ");
INSERT INTO azzNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ijcuacón in amocuali Satanás majchihuac; huan de ompa hualajque in ángeles taquehualme de Dios huan quipalehuicoj in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Huan cuac in Jesús quicayic ya que in Juan Taahuijque tzactoya ya tech in carcel, ijcuacón yajqui Jesús Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Pero Jesús amo mocahuac tech ipueblo Nazaret. Ta, yajqui mocaltalito tech in pueblo Capernaum campa in mar de Galilea nochi itatilanal de Zabulón huan Neftalí. ");
INSERT INTO azzNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Huan ijcón mochihuac ten quijtojca ya itanahuatijcau de Dios Isaías cuac quijcuilojca in Tajcuilolamatzin de Dios ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Oncas tanex para in pueblojuani ten pohuij ihuan Zabulón huan Neftalí. Huan oncas tanexilot para in pueblojuani campa yohui ojme marcopa huan campa sentapalpa de ne iquisayampa in tonal den hueyíat Jordán. Huan no oncas tanex para in calyetoni de Galileajcopaca ten amo pohuíaj judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Huan nochi in pueblojuani ten calyetoyaj tech in tayohuayanilot den tajtacol, yejuan quitacque ya se hueyi tanex. Huan se cualtzin tanexilot quintahuilij ya nochi pueblojuani ten calyetoyaj campa quinmajpachojtoya in yecahuil de miquilis. ");
INSERT INTO azzNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Huan de ompa pehuac Jesús quinnextiliaya huan quiniliaya in tacaquini ijcuín: ―Ximoyolnemilican de namotajtacoluan porín motoquijtoc Dios den eluiyactzinco para ma quinyolyecanas itaneltocacahuan ica nihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nejnentiaya ya Jesús martenojcopaca de Galilea huan quinitac ome icnime, in Simón ica cojpatocaytijque in Pedro, huan in ocsé icniu Andrés. Huan yejuan catcaj pescadojquitzquiani huan quitamotayaj ninmatau tech in mar de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Huan Jesús quinilij ijcuín: ―Xihuiqui nohuan, xinechtoctilican. Huan ijcón queme nantaquitzquiani ica pescados, no ijcón Nejuatzin namechchihuas que nanquintemosque tagayot para ma nechtoctilican nejua. ");
INSERT INTO azzNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ijcuacón nimantzin in Simón huan in Andrés quicauque ninmatau huan quitoctilijque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Huan queman panoc ya de ompa huel nepacatzin, ijcuacón Jesús no quinitac in Jacobo huan iicniu Juan, teconehuan de Zebedeo. Huan ne icnime yetoyaj ihuan nintat tech se barco, huan ompa quitajtasaluijtoyaj ninmatau. Huan in Jesús quinnotzac ne teconehuan ma quitoctilican para quitacamatiyasque. ");
INSERT INTO azzNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Huan nimantzin Jacobo huan in Juan quicauque nintetat tech in barco huan quitoctilijque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Huan Jesús nentiaya nochi Galileajcopaca huan quinnextiliayaj in tacaquini ica in Tajtoltzin de Dios tech ne tiopanme de judíos. Huan campa hueli ajsía Jesús quinmachtiaya den yancuic Tajtoltzin de que Dios motoquijtoc para ma quinyolyecanas itaneltocacahuan ica nihueyichicahualis. Huan Jesús quinpajtijtiaya ya nochi cocoyani de míac tataman den quincocoaya in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Huan ijcón momoyahuac ne chicahualis de Jesús nohuiyampa tech in pueblojme ten itatilanal Siria. Huan quihualcuiliayaj campa Yejuatzin nochi cocoyani ten mococoayaj ica míac tataman cocolisme, nochi cocoyani ten tajyohuiyaj ya ica míac tataman hueyi tetzaucacocolis huan yoltequipacholis. Huan no quihualcuiliayaj campa Yejuatzin nochi cocoyani den quipíaj ya ninyolijtic amocuali ejecame huan den yojyolpolihuíaj huan den motojtocotzoayaj. Huan Jesús quinpajtij nochi nijín cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Huan ijcón quitoctiliayaj Jesús míac tagayot den pohuíaj Galilea huan den pohuíaj Decápolis, inuan no ten pohuíaj de Jerusalén huan ten pohuíaj sentapalpa den hueyíat Jordán. ");
INSERT INTO azzNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Huan cuac Jesús quinitac que yetoyaj miacque tagayot, ijcuacón tejcoto tech ne talcuatipan huan ompa motalij. Huan imomachtijcahuan motoquijque ihuantzin huan quiyehualojtoyaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Huan ijcón in Jesús pehuac quinnextiliaya imomachtijcahuan ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","―Tatiochihualme de Dios ne taneltocani ten cajsicamatij que ninyolojuan iuque, ten amo quipíaj ne yolchipahualis ten Dios quimonequiltía. Porín como ijcón quichihuaj, ijcuacón yejuan pohuitihue campa Dios quinyolyecanas ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tatiochihualme de Dios ne taneltocani ten moyolcocoaj porín cajsicamatij que tajtacolejque. Porín como ijcón quichihuaj, ijcuacón yejuan Dios quinyoltalis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tatiochihualme de Dios ne taneltocani ten icnome tech ninyolojuan. Porín como ijcón quichihuaj, ijcuacón Dios quintayocolis se yancuic talticpac nemilis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tatiochihualme de Dios ne taneltocani ten quimachilíaj que yolmayanaj huan yolamiquij porín quiyolnejnequij chipaucanemisque. Porín como ijcón quichihuaj, ijcuacón yejuan Dios quinyecyolpexontis ica ne chipaucanemilis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tatiochihualme de Dios ne taneltocani ten teyolicnelíaj. Porín como ijcón quichihuaj, ijcuacón yejuan Dios no quinyolicnelis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tatiochihualme de Dios ne taneltocani ten yolchipauque. Porín como ijcón quichihuaj, ijcuacón yejuan yec melan quixitatihue in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tatiochihualme de Dios ne taneltocani ten quinyolyecmelahuaj ne motehuiani. Porín como ijcón quichihuaj, ijcuacón yejuan Dios quinpohuas iconehuan. ");
INSERT INTO azzNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tatiochihualme de Dios ne taneltocani ten tajyohuíaj porín acsame quinquejqueloaj de ninchipaucanemilis. Porín como ijcón quichihuaj, ijcuacón Dios quinyolyecana ipan yejuan ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nantatiochihualme namejuan cuac namechuijuicaltisque huan cuac namechtajyohuiltisque huan cuac namechijtohuilisque míac xolopijyot porín nantacuautamatij itech Nejuatzin notocay. ");
INSERT INTO azzNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ijcuacón ximoyolpactican huan ximohuelitacan porín se tonal nanquiselisque se hueyi ne tetayocolil nepa eluiyactzinco. Huan ijcón queme namechtahuelitaj axcan, no ijcón quintahuelitatihualajque nitanahuatijcahuan de Dios ten nemicoj ne achtopa ya que namejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Huan ocsepa Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanyesque queme istat nican talticpac; nantapoyeliani den talticpacuani ica namochipaucanemilis para ma amo ongac sayó in chichicayot de tajtacol. Huan tacán in istat quipoloa nichicahualis, ¿ijcuacón quenín huelis ocsepa poyeyas, como amo quipía nipoyecayot? Huan ijcón amo teyi cualtía oc. Ta, sayó cualtía para quitamotasque calan huan quitzojtzonicsasque san. ");
INSERT INTO azzNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Huan ocsepa Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanyesque queme in tanexilome para in talticpacuani, porín namejuan nanquinyoltahuilisque ica ne namochipaucanemilis. Namejuan nanyesque queme se pueblo ten yetoc talcuatipan ten amo hueli motatía. ");
INSERT INTO azzNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Huan cuac se quixotaltía se tanex, ijcuacón amo se quipantalilía se cajon. Ta, cachi cuali se quitalía campa tasempayan, huan ijcón nochi quintahuilis ne ten yetocque calijtic. ");
INSERT INTO azzNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Huan ijcón no namejuan xiquintanextilican nijín talticpacuani ica namochipaucanemilis. Huan cuac yejuan quitasque ya den namocualitachihualisuan, ijcuacón yejuan no quimohuistilisque Namohueyitajtzin ten yetica ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Huan ocsepa Jesús quinmachtij imomachtijcahuan ijcuín: ―Amo xicnemilican que nejua nihuala para namechxejxeloco ten Moisés namechmachtijca ya, nión no namechxejxelos den namechnextilijque ya in tanahuatiani de Dios. Nejua amo nihuala para nicuejuelos ne tanahuatil de namohuejcatatuan. Ta, sayó nicnequi namechyecajsicamatiltis de nochi ne tanahuatilme. ");
INSERT INTO azzNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Porín de yec melau ten namechilía que mientras yetoc oc in eluiyac huan in talticpac amo mosecocahuas nión se letra de nochi den tanahuatilme. Ta, ma motamichihua nochi in tamachilis ten cuica in tanahuatilme, ijcón queme Dios quimonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ica ya nojón xicmatican, tacán acsá quisecotalía senme de nijín tanajnahuatilis, masqui tzictzin san in tanahuatil, huan tacán quinnextilía in tagayot ma amo quitacamatican, ijcuacón yejua ne quipohuasque amo teyi chiuque intzalan neques ten Dios quinyolyecanas ica ihueyichicahualis. Huan tacán acsá quitacamati ne tanahuatil huan no quinmachtía in tagayot ma no quitacamatican, ijcuacón yejua ne quipohuasque se hueyi chiuque intzalan neques ten Dios quinyolyecanas ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ica ya nojón no namechilía que tacán amo nanquipíaj se nemilis ten cachi chipactzin huan que ne ten cuicaj nojón fariseos huan nojón tanextiliani den tanahuatil de Moisés, ijcuacón xicmatican que amo queman huelis nanpohuitihue intzalan neques ten Dios quinyolyecanas ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanquicacque ya que ne namohuejcautatuan namechnajnahuatijque ijcuín: “Amo xitemicti. Huan ijcón naquen temictis, yejua ne quitajyohuiltisque ica ne hueyi tatzacuiltilis”. ");
INSERT INTO azzNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Pero Nejuatzin namechnajnahuatía ijcuín: Nochi naquen mocualantis ihuan se icnitzin, masqui amo temictía, pero no ijcón ne tahuel quitajyohuiltisque ica ne hueyi tatzacuiltilis. Huan naquen quijitos se icnitzin huan quilis ijcuín: “Semi tixoxo”, ijcuacón yejua ne ten quijtoj ne eijitolis in hueyi tayecanani quitajyohuiltisque ica por ne iteijitolis. Huan naquen quiquejquelos se icnitzin huan quilis ijcuín: “Semi timijmiquilot”, yejua ne ten quijtoj ne teijitolis in tayecanani quitelchihuasque ma tajyohui tech ne tit den mictan. ");
INSERT INTO azzNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ica ya nojón cuac ticuicas ne motetayocolil tenica ticnemilía ticmohuistilitiu Totajtzin Dios huan santajma tiquelnamiquis que mocniu mitzyolcualantía, ");
INSERT INTO azzNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ijcuacón xicahua ompa ten ticuiyac tenica ticmohuistilisquía Totajtzin Dios. Ta, xiyó achto xiquitati ne mocniu huan xiquiliti ma mitztapojpolui para ijcón nanmoyecahuasque. Huan de ompa cuali timocuepas huan ticmohuistilitiu Totajtzin Dios ica ne motetayocolil. ");
INSERT INTO azzNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Huan tacán acsá mitzteluilía huan quinequi mitzuicas iixpan in juez, ijcuacón nimantzin xiyó huan xitajtaniliti tech ne ojti ma mitztapojpolui para ijcón nanmoyecahuasque, huan para ma amo mitztemacti imaco ne juez. Huan tacán amo nanmoyecahuaj tech in ojti, ijcuacón in juez mitztemactis imaco in policía huan mitzcalaquitiu tech ne cárcel. ");
INSERT INTO azzNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Huan de yec melau ten namechilía que amo huelis tiquisas den ne cárcel, como amo tictemaca nochi ten mitztajtaníaj. ");
INSERT INTO azzNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanquicacque ya que ne namohuejcautatuan namechnajnahuatijque ijcuín: “Amo xitasihuapapata”. ");
INSERT INTO azzNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Pero Nejuatzin namechnajnahuatíaj ijcuín: Tacán se tagat quinixuelitztinemi sihuame san, ijcuacón ne tagat moteltajtacolmacac ya itech italnamiquilis ihuan ne sihuame. ");
INSERT INTO azzNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Huan tacán moixtololo den moyecmacopaca mitztepotamisquía tech in tajtacol, ijcuacón ximoquixtili ne moyequixtololo huan xictamota huejca. Porín cachi cuali sayó xicpolo se moixtololo, huan ma amo xicpolo nochi motacayo tech ne tit de mictan. ");
INSERT INTO azzNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Huan no tacán se moyecmay mitztepotamisquía tech in tajtacol, ijcuacón xicotona huan xictamota huejca. Porín cachi cuali sayó ma polihui se moyecmay san, huan ma amo xicpolo nochi motacayo tech ne tit de mictan. ");
INSERT INTO azzNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanquicacque ya que ne namohuejcautatuan namechnajnahuatijque ijcuín: “Nochi naquen quinequi quisecocahuas se isihuau, ma quimacti se amat campa ixnesi que mosesecocauque ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Pero Nejuatzin namechnajnahuatía ijcuín: Tacán se tagat mocacahuaj ihuan nisihuatzin huan nisihuau amo ahuilnenque, ijcuacón ne tagat quichihua que nisihuau yesquía se sihuaahuilnenque. Huan naquen ihuan monamictis ne sihuat ten namique catca, ijcuacón ne ocsé tagat motajtacolmacas ya porín ne sihuat pohui oc ihuan ne achtopa yoquich. ");
INSERT INTO azzNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanquicacque ya que ne namohuejcautatuan namechnajnahuatijque ijcuín: “Ma amo queman xiquijto: Quitztica Dios, huan de ompa amo ticchihuas ten timoyectencahuac ya. Ta, cuac timoyectencahuas ya de que ticchihuas tensá, huan tictematiltis ica nijín tajtolme, Quitztica Dios, ijcuacón yec melau xicchihuati ten timoyectencahuac ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Pero Nejuatzin namechnajnahuatía ijcuín: Amo queman xiquijto: “Quitztica Dios”, cuac ticnequi timoyectencahuas ihuan acsame. Amo queman xiquijto: “Quitztica Dios”, nión ica teyi taman tanemililis. Huan amo no xiquijto: “Quitztica ne eluiyactzinco”, porín ompa yetica Dios imohuiscachicahualispan. ");
INSERT INTO azzNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Huan amo no xiquijto: “Quitztica in talticpac”, porín nican talticpac Dios mometzmejmelautoc. Huan amo no xiquijto: “Quitztica ne chipactzin pueblo Jerusalén”, porín ne pueblo pohui ihuan ne hueyi tayecanque Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Huan amo no xiquijto: “Quitztica notzontecon”, den quijtosnequi: “Quitztica nejuatzin”, porín amo hueli ticchihuas ma mocuepa istac nión se motzontzin ten tiltic ica motajtolis san. ");
INSERT INTO azzNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Pero cuac ticnequis tiquijtos “quema”, sayó xiquijto “quema”. Huan cuac ticnequis tiquijtos “amo”, sayó xiquijto “amo”. Porín cuac ticnequis ticmajmaxitis motajtolis ica ne tajtol: “Quitztica Dios”, ijcuacón nenca san tictenehuas itocaytzin de Totajtzin Dios. Xicmati que nojón motajtolis huitza den amocuali Satanás. ");
INSERT INTO azzNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanquicacque ya que ne namohuejcautatuan namechnajnahuatijque ya ijcuín: “Tacán acsá mitzchihuilis mal queme yesquía mitzquixtilía se moixtololo, ijcuacón tejua no timomacuepas huan tiquixtilis se iixtololo. Huan tacán acsá mitzquixtilía se motan, ijcuacón tejua no timomacuepas huan no tiquixtilis se itan”. ");
INSERT INTO azzNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Pero Nejuatzin namechnajnahuatíaj ijcuín: Amo ximomacuepacan cuac se tagat namechchihuilía tensá ten amo cuali. Huan tacán acsá mitzcamatatzinía moyecmacopaca, ijcuacón amo ximomacuepa. Ta, xicuepa moixco ma mitzcamatatzini ocseco. ");
INSERT INTO azzNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Huan tacán acsá quinequi mitzteluilis iixpan in juez huan no quinequi mitzcuilis mocamisa, ijcuacón xicahuili ma cuica no motaquen. ");
INSERT INTO azzNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Huan tacán acsá mitzfuerzajuía de que xicuica se tamamal se huan tajco kilómetro, queme yesquía tajco hora de ojti, ijcuacón xicuica ne tamamal ocsé tanto, yesqui se hora tech in ojti. ");
INSERT INTO azzNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Huan tacán acsá quinequi mitztajtanilis tensá, ijcuacón xicmacti. Huan tacán acsá quinequi mitztanehuilis tensá, ijcuacón amo no xiquixtopehua. Ta, xictaneuti. ");
INSERT INTO azzNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan namejuan nanquicacque ya que ne namohuejcautatuan namechnajnahuatijque ijcuín: “Xictasojta mocniu huan xictahuelita naquen mitztahuelita”. ");
INSERT INTO azzNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Pero Nejuatzin namechnajnahuatía ijcuín: Xictasojtacan naquen namechtahuelitasque, huan xiquintapojpoluican ne naquen namechuijuicaltisque. Huan xiquinpalehuican naquen namechcualancaitasque. Huan ximotatatautilican ica por yejuan ne naquen namechquejquelosque huan ten namechtajyohuiltisque. ");
INSERT INTO azzNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Huan ijcón ixnesis que namejuan nanteconehuan de Namohueyitajtzin ten yetica ne eluiyactzinco. Porín Yejuatzin quichihua ma panquisa in tonaltzin para quinpalehuis nochi naquen yolcualime huan naquen amo yolcualime. Huan Yejuatzin no cualtitani in quioutzin para quinpalehuis naquen yolchipauque huan naquen amo yolchipauque. ");
INSERT INTO azzNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Huan como sayó nanquintasojtaj ne naquen namechtasojtaj, ¿ijcuacón toni tetayocolil nanquiselisque? Pues hasta in tatopaluiani yejuan ijcón quichihuaj. ");
INSERT INTO azzNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Huan tacán sayó nanquitajpaloaj namocnihuan, ¿ijcuacón toni cuali chihualis nanquichihuaj ten amo quichihuaj in ocsequin? Porín hasta ne taca ten amo pohuij ihuan Dios, yejuan nojonques no ijcón quichihuaj. ");
INSERT INTO azzNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Huan namejuan xiyecyolmajsitocan ica ne tetasojtalis ijcón queme Namohueyitajtzin ten yetica ne eluiyactzinco ten no yec yolmajsitoc ya ica ne tetasojtalis. ");
INSERT INTO azzNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Huan Jesús ocsepa quinmachtij imomachtijcahuan ijcuín: ―Huan amo xicchihuacan namocualitachihualis de namotaneltocalis senteixteno para ma sayó namechitacan in tagayot. Porín como ijcón nanquichihuaj, xicmatican que Namohueyitajtzin den yetica eluiyactzinco amo teyi namechmactis de ne tetayocolil. ");
INSERT INTO azzNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Pero cuac tiquinpalehuis in pobres, ijcuacón amo xictematilti nohuiyan de ne motaehuil. Porín ijcón quichihuaj ne naquen ixcuecuepme de nintamachilis campa in tiopanme de judíos huan campa ojme sayó para ma quinhueyichihuacan in tagayot. De yec melau ten namechilía que yejuan quipíaj ya ne nintetayocolil. ");
INSERT INTO azzNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Pero cuac tejua tiquinpalehuis in pobres ica ne ten ticpía, ijcuacón ma amo aquen quimati toni ticchihuas. Amo xictematilti nohuiyan huan nión no ma quimati moopochmay ten quichiutoc moyecmay. ");
INSERT INTO azzNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Ta, tejua cuac tiquinpalehuis in pobres ica ne ten ticpía, ijcuacón cachi cuali xiquichtacachihua. Huan ijcón Mohueyitajtzin quitztoc ya ten tiquichtacachiutoc, huan ijcón Yejuatzin mitzmactilis ne hueyi tetayocolil senteixteno. ");
INSERT INTO azzNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Huan Jesús ocsepa quinmachtij imomachtijcahuan ijcuín: ―Huan cuac namejuan nanmotatatautilisque, ijcuacón amo xicchihuacan queme ne naquen ixquequepme de nintamachilis. Porín yejuan cuelitaj moquetzasque huan motatatautilisque itech in tiopanme de judíos huan tech ojme den calnacastan, para ma ijcón quinitacan in tagayot. Huan yec melau ten namechilía que yejuan quiselijque ya ne tetayocolil de hueyipanchihualis ten quinmactilijque ya in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Pero cuac tejua timotatatautilis ihuan Dios, ijcuacón xicalaqui tech mochantzin huan xictzacua in puerta huan ximotatatautili ihuan Mohueyitajtzin Dios ten mohuan ichtaca yetica. Porín Mohueyitajtzin Dios quitztoc ya ten tiquichtacachiutoc huan ijcón Yejuatzin satepan mitzmactis ne tetayocolil senteixteno. ");
INSERT INTO azzNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Huan cuac namejuan nanmotatatautilisque ihuan Dios, ijcuacón amo yejua san xicquejqueptocan san namotajtoluan porín ijcón nenca san namonetatatautilis. Porín ne naquen amo pohuij ihuan Dios, yejuan quiquejqueptocque san nintajtoluan tech ninnetatatautilis. Huan ijcón yejuan quiyolnemilíaj que Dios cachi quincaquis porín miacpa quichihuaj ninnetatatautilis. ");
INSERT INTO azzNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Huan namejuan amo xiquinnejnehuilican queme yejuan motatatautilíaj porín xicmatican que Namohueyitajtzin Dios ipa cuali quimatoc ya toni namechpoloa achtopa ya que namejuan nanquitajtanisquíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Pero namejuan ximotatatautilican ijcuín: Tohueyitajtzin ten tiyetica eluiyactzinco, ma timitzonmohuistilican ica in chicahualis de motocaytzin. ");
INSERT INTO azzNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Huan ma xionuiqui huan ma xiquinyolyecana ica mohueyichicahualis motaneltocacahuan. Huan ma mochihua nochi ten Tejuatzin ticonmonequiltía nican talticpac ijcón queme mochiutoc ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Xitechonmaca axcan totaxcaltzin ten techpoloa. ");
INSERT INTO azzNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Huan xitechontapojpolui den totajtacoluan ijcón queme tejuan no tiquintapojpoluijque ya naquen techmohuispoloayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Huan amo xitechonuica tech in ohuijcayot. Ta, xitechonajchihuili den chicahualis den amocuali. Huan timitzonhueyimohuistilíaj porín Tejuatzin san ticonpía in hueyitayecanalis, in hueyichicahualis huan Tejuatzin san Tionueyichiuque porín nesi mocualtzinyo para nachipa ijcón. Amén. ");
INSERT INTO azzNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Porín como namejuan nanquintapojpoluíaj naquen namechmohuispoloaj, ijcón no Tohueyitajtzin Dios ten yetica eluiyactzinco namechtapojpoluis. ");
INSERT INTO azzNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Huan como amo nanquintapojpoluíaj ne naquen namechmohuispoloaj, no ijcón Namohueyitajtzin amo no namechtapojpoluis de namotajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan cuac nanmosahuasque, ijcuacón ma amo xiyetocan xiixcocoyani ijcón queme quichihuaj in taca ten ixcuecuepme de nintamachilis. Porín yejuan ixcocoxcatijtinemij para ijcón quinnextilisque in tagayot que yec melau mosahuaj. De yec melau ten namechilía, yejuan quiselijque ya ne tetayocolil de hueyipanchihualis ten quinmactilijque ya in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Pero tejua, cuac timosahuas, ijcuacón cuali ximocuatzicahuasui huan cachi ximoixami, ");
INSERT INTO azzNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","para ma amo quimatican tagayot que timosautoc. Ta, sayó para ma quimati Mohueyitajtzin ten ichtaca yetica. Huan Mohueyitajtzin cuali quimatoc ya de que toni tiquichtacachiutoc huan ticselitiu senteixteno ne tetayocolil ten Totajtzin Dios mitzmactilis. ");
INSERT INTO azzNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Huan Jesús no quinmachtij imomachtijcahuan ijcuín: ―Amo xicsentilican namoricojyo nican talticpac campa namotilma quitetectocque in ocuilinme huan namotomin poxcautoc huan campa in tachtequini tecalijtic calaquij huan cuicaj ten nesi. ");
INSERT INTO azzNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ta, cachi cuali xicsentilican namoricojyo tech ne eluiyactzinco campa in ocuilinme amo hueli quitejtequisque, nión no poxcahuis den namoaxca, huan nión no tachtequini huelis mitzcalijticcalaquisque huan cuicasque ten moaxca. ");
INSERT INTO azzNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Porín campa yesqui yetos nochi in namoricojyo, ne eluiyactzinco oso nican talticpac, sayó ompa itech ne moricojyo nanyoltanemilijtosque. ");
INSERT INTO azzNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Huan Jesús cachi oc quinmachtij imomachtijcahuan ijcuín: ―Namoixtololohuan nicnejnehuililtía queme se tanex ten techtahuilía tech tonacayo. Huan tacán namoixtololohuan yec tequitij queme se cuali tanex, no ijcón cuali namechtahuilía tech nochi namonacayo. ");
INSERT INTO azzNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Huan tacán namoixtololohuan amo yec tequitij porín tensá quitzajtzacuilía namoixcoconeu, no ijcón amo huelis calaquis in tanex huan ijcón nochi namonacayo mocahuas tech in tayohuayanilot. Huan como ne tanex ten nanquipiasquíaj ijcón mocuepas tayohuayanilot, ijcuacón yec melau nanmocahuasque tech se tayohuayanilot ten semi tiltic. ");
INSERT INTO azzNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Huan Jesús quinmachtij imomachtijcahuan ijcuín: ―Amo aquen huelis quintequitilis ome patrones, porín como ijcón quichihua, ijcuacón yejua quitahuelitas se patrón huan quitasojtas in ocsé, oso quimohuistilis se patrón huan amo quihueyichihuas in ocsé. Amo aquen huelis quintequitilis nijín ome patrones sepa san, ijcón queme Totajtzin Dios huan in ricojyot de nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Huan Jesús no quinmachtij imomachtijcahuan ijcuín: ―Ica nijín tanejmachtilis namechilía que amo ximoyolcuejmolojtinemican de namonemilis, de namotacualis, de namoatilis. Huan amo no ximoyolcuejmolocan de namotaquen. ¿Xe cachi amo tayecantoc namonemilis huan que nijín namotacualis? Pues quema. ¿Xe cachi amo tayecantoc namotacayo huan que nijín namotilma? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Xiquitacan san in tototzitzin ten patantinemij ejecaixco. Yejuan amo no tatocaj, nión no cajocuij taquilot, nión no quiehua in taquilot tech sincal. Huan Namohueyitajtzin ten yetica ne eluiyactzinco, Yejuatzin quintamacatoc. ¿Xe cachi amo nantayecantocque namejuan ihuan Dios huan que nijín tototzitzin? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","¿Aconi de namejuan huelis momajxitis se molic oc para cachi huejcapantíyas, masqui cachi moyolcuejmolos? Pero amo aquen huelis. ");
INSERT INTO azzNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Huan, ¿queyé nanmoyolcuejmolojtinemij por namotilma? Xiquitacan quenín moscaltíaj ne milajxochime. Yejuan amo motequitilíaj nión no tajquitij. ");
INSERT INTO azzNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Huan namechyequilía que nijín xochit semi cualtzin xochiyohua. Huan ne hueyi rey Salomón ica nochi nicualtzinyo motaquentiaya pero amo queman huelic quinejnehuilis cualtzin queme nijín xochit. ");
INSERT INTO azzNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Huan Dios quicualnextía nijín milajxochime ten axcan moscaltijtoc huan mosta quitatis campa tachinoa. Huan namejuan, ¿xe cachi amo namechpalehuis Dios huan que ne milajxochime? Pues, quema. Huan namejuan, ¿queyé amo majsitoc namotacuautamatilis? ");
INSERT INTO azzNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Huan no Jesús quinmachtij imomachtijcahuan ijcuín: ―Amo xicnemilijtinemican toni nanquicuasque mosta, huan toni titayisque, huan tonica timotaquentisque. ");
INSERT INTO azzNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Porín in tagayot ten amo pohuij ihuan Dios, yejuan nojonques quitemoaj sayó de nijín taman. Huan namejuan nanquipíaj se Namohueyitajtzin ten yetica ne eluiyactzinco huan Yejuatzin nochi quimatoc ya ten namejuan namechpoloaj. ");
INSERT INTO azzNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Pero namejuan ximofuerzajuican huan xictemocan achto para ma Dios namechyolyecana ica ihueyichicahualis huan no xictemocan ne yecchipaucanemilis ten Dios cuelita. Huan ijcón Yejuatzin namechyolmajxitis huan nanquiselisque nochi ten monequis ijcón queme in tacualis huan in atilis huan namotaquen. ");
INSERT INTO azzNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ica ya nojón amo ximoyolcuejmolocan den toni mochihuas mosta, porín ne tonal den mosta cualcuis ocsé ne cuejmololis. Cada se tonal quipía ne ohuijcayot. Huan ijcón queme hualajtoc ne cuejmololis de mosta huan mosta, no ijcón ximotatatautilican mosta ihuan Totajtzin Dios ma namechpalehuijtiu. ");
INSERT INTO azzNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan amo xiquinixcomactinemican huan amo no xiquintelchiutinemican acsame, queme nanyesquíaj jueces, para ma Dios amo no namechixcomas huan amo namechtelchihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Porín Dios namechixcomacas huan namechtelchihuas ica ne tamachiu tenica namejuan nanquicuij para nanquixcomacaj huan nanquintelchihuaj acsame. Huan ne taixcomacalis tenica namejuan nanquintelchihuaj acsame, no ijcón Dios quicuis para namechixcomacas huan namechtelchihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Huan como tejua amo timomaca cuenta de que mitzixtzajtzacuilijtoc se hueyi cuoutzontet, queme yesquía se hueyi tajtacol, ijcuacón amo huelis ticyequitilis se teuti actoc ixtololoco ne mocnitzin, huan ne teuti queme yesquía se tajtacol ten amo semi mota. ");
INSERT INTO azzNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Huan no, ¿quenín huelis tiquilis ne mocniu: “Ma nimitzquixtili ne teuti ten ticpía moixtololoco”, cuac no ticpía se hueyi cuoutzontet ten no mitzixtzajtzacuilijtoc? Pues amo huelis. ");
INSERT INTO azzNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Porín como amo ticmachilía ne ten mitzixtzajtzacuilijtoc, ijcuacón tejua tiixcuecueptoc san de motamachilis. Ta, cachi cuali achto ximoquixtili ne cuoutzontet ten mitzixtzacuilijtoc huan ijcón huelis ticyequitas ya ne teuti ten quipía mocniu ne ixtololoco huan ijcón huelis ya tiquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Huan Jesús quinnextiliaya in tagayot ica se nexcuitil de se itzcuinti huan se pitzot huan quiniliaya ijcuín: ―Amo xiquinmactilican itzcuinme ne chipactzin Tajtoltzitzin de Dios, huan amo no xiquintamacacan pitzome den tanextililis de Dios queme yesquía perlas ten semi telpatio. Porín nijín ocuilinme queme yesquíaj in taca ten yolchichicque ten quixtopehuasque in Tajtoltzin de Dios. Huan huelis yejuan quitzojtzonicsasque in Tajtoltzin de Dios huan no mocuepasque para namechquejquetzomasque. ");
INSERT INTO azzNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Huan Jesús quinnextiliaya imomachtijcahuan ica se nexcuitil huan quiniliaya ijcuín: ―Xitajtanilican Dios huan namechmactis ne ten monequi. Ijcón queme tensá se quiyectemoa de se quipoloa, no ijcón xictatatautilican Dios huan Yejuatzin namechseliltis. Huan no ijcón cuac se tacacalatza ma tatapoucan, no ijcón xicsentocacan xiquilican Dios ten monequi huan Dios namechmacas. ");
INSERT INTO azzNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Porín nochi tocnihuan ten tajtanilisque, yejuan nojonques Dios quinseliltis. Huan nochi tocnihuan ten quitemosque tensá tatiochihualis, yejuan nojonques Dios quinpalehuis para ma cajsican. Huan nochi tocnihuan ten tanotzasque, yejuan nojonques Dios quintatapohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","¿Xe acsá de namejuan huelis nanquimactilisque namoconeu se tet cuac namechtajtanilis xicmacacan taxcal? Pues amo. ");
INSERT INTO azzNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Huan, ¿xe no acsá de namejuan huelis nanquimactilisque namoconeu se cohuat, cuac namechtajtanis xicmacacan tzictzin pescadojnacat? Pues amo. ");
INSERT INTO azzNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Porín masqui namejuan amo nanyolchipauque, pero no cuali nanquimatocque toni nanquimactisque namoconehuan ten cuali huan den huelic. Pues cachi oc Namohueyitajtzin ten yetica ne eluiyactzinco namechmactis ne mactil ten cuali para nochi naquen quiyectajtanisque. ");
INSERT INTO azzNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Huan ijcón ipa xiquinchihuilican tocnihuan ijcón queme nanquinequij que in tocnihuan ma namechchihuilican. Porín yejua nijín in tamachilis ten technajnahuatíaj in tanahuatil de Moisés huan in Tajcuilolamatzin ten quijcuilojque in tanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Huan Jesús quinmachtij imomachtijcahuan ijcuín: ―Xicalaquican itech ne ojtzin de Dios campa ne calteno amo patahuac. Porín ne calten huan ne hueyi ojti semi patauque campa yajtocque in tagayot para ajsitihue tech ne ixpolihuilis, huan miacque tagayot yohue tech ne patahuac ojti campa amo ongac ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Huan amo patahuac ne calteno huan semi pitzahuac ne ojti campa yajtocque in taneltocani para ajsitihue tech ne yec nemilis. Huan amo miacque moajsitihue tech nijín ojti de ne maquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Huan Jesús quinmachtij imomachtijcahuan ijcuín: ―Ximoyecpiacan den ne tanahuatiani tacajcayahuani ten teilijtinemij que yejuan tajtoaj itencopa Dios. Porín yejuan hualasque sayó para namechcajcayahuasque san. Huan yejuan motasque yolcualime queme se cuali ichcat ten amo tetehuía. Pero ne iyolijtic ne tanahuatiani cualcuij yoltacajcayahualis queme in piotecuani ten ichtacayohui para tachtequisque. ");
INSERT INTO azzNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Huan ijcón namejuan cuali nanquinyequixmatisque nijín tanahuatiani ica ne tachihualis ten yejuan quichiutinemij. Porín amo huelis se quitocas huitzti huan ma taqui uvas xocot ten tzopec. Pues amo no huelis se quitocas tzitzicascuohuit huan ma taqui higos xocot. ");
INSERT INTO azzNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Huan ijcón nochi in cuohuit ten cuali, yejua ne quitemaca cuali taquilome. Huan nochi in cuohuit ten amo cuali, yejua ne quitemaca taquilome ten amo cualtía. ");
INSERT INTO azzNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Huan in cuohuit ten cuali, yejua ne amo huelis quitemacas itaquilohuan ten amo cualtía. Huan no in cuohuit ten amo cuali, yejua ne no amo huelis quitemacas itaquilohuan ten cualtía. ");
INSERT INTO azzNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Huan nochi in cuoume ten amo quitemaca taquilot ten cualtía, in tequitini quimayohuisque huan quitamotasque tech in tit. ");
INSERT INTO azzNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ijcuacón namejuan cuali nanquinyequixmatisque ya nojón tacajcayahuani ica ne tachihualis ten yejuan quichiutinemij, ijcón queme cada se cuohuit moixmati ica itaquilohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Huan Jesús quinajsicamatiltij imomachtijcahuan ijcuín: ―Totajtzin Dios de eluiyactzinco amo quinyolyecanas ica ihueyichicahualis nochi ne ten nechnotzasque sayó ica nintenxipal san que Nejuatzin ni Nintecotzin. Ta, sayó Dios quinyolyecana ica ihueyichicahualis neques ten quichihuaj queme Notajtzin Dios ipaquilis ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Huan cuac ne tonal de tatzacuiltilis ejcos ya, ijcuacón miacque nechilisque ijcuín: “Notecotzin, Notecotzin, tejuan tictanextiliayaj ica in chicahualis de motocaytzin. Huan no ica motocaytzin tiquincalanquixtiayaj in amocuali ejecame. Huan ica motocay ticchihuayaj miacque huejueyi mohuiscatequit”. ");
INSERT INTO azzNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Pero ijcuacón Nejuatzin niquinyecquilis ijcuín: “Amo queman namechixmatic; niman ximajchihuacan, namejuan nantachihuani ica ten amo cuali”. ");
INSERT INTO azzNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Huan in Jesús quinnextiliaya imomachtijcahuan ica se nexcuitil ijcuín: ―Naquen nechcaquilía huan quichihua nochi ten nicnajnahuatía, yejua ne nicnejnehuililtía queme se tagat ten yec yolmajsitoc ya. Huan ne tagat ten yolmajsitoc quichijchihuac ichan huan quichijchihuac in tatzinehualoni itech se hueyi tesohuil. ");
INSERT INTO azzNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Huan huala se hueyi tetzaucaquiohuit huan hueyiacque in hueyiame huan elihuis taejecaya hasta quihuijuixohuaya in cali. Pero in cali amo huejuelihuic porín yec tzinijcatoya itech se hueyi tesohuil. ");
INSERT INTO azzNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Huan no ijcón naquen amo nechcaquilía huan amo no quichihua den Nejuatzin nicnajnahuatía, yejua ne nicnejnehuililtía queme se tagat den ayamo yec yolmajsitoc. Huan yejua ne quichijchihuac nichan huan quitzinpehualtij campa yoca xal san. ");
INSERT INTO azzNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Huan huala se hueyi tetzaucaquiohuit huan hueyiacque in hueyiame huan elihuis taejecaya hasta quihuijuixohuaya in cali, ijcuacón ne cali cacapaxhuetzito. ");
INSERT INTO azzNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Huan cuac Jesús quintaminojnotzac ya, ijcuacón in tagayot quimoucamatíaj de ne tanextililisme. ");
INSERT INTO azzNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Porín Jesús quinnextiliaya in tacaquini ica chicaucatanahuatil huan amo queme ne tanextiliani den tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Huan cuac temoc ya Jesús tech ne tepelomo, ijcuacón quitoctiliayaj Yejuatzin huel míac tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Huan motoquij campa Jesús se cocoxque den inacayo cocotocatoya. Huan yejua motancuaquetzaco iixpampa Jesús huan quilij ijcuín: ―Totecotzin, ta como ticonmonequiltía, cuali tionuelis tinechonchipahuas de nijín pitzotic cocolis. ");
INSERT INTO azzNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Huan Jesús momatilanac huan quimatocac in cocoxque huan quilij ijcuín: ―Nicnequi ma tejua xichipahuac de mococolis. Huan cuac Jesús ijcón quilij, ijcuacón nimantzin quisac ne cocolis den inacayo cocotocatoya huan mocahuac chipactzin ne tagat. ");
INSERT INTO azzNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Huan Jesús quilij ijcuín: ―Xiquita, amo aquen teyi xictapohui. Ta, sayó xiyó ximotenextiliti ihuan ne tiopixcame den judíos de que tichipahuac ya. Huan no xiquinmactiti ne tetayocolil in tiopixcame den judíos, ijcón queme Moisés tanahuatiaya para ne cocoyani ten tapajtilme ya de ne cocotoca ninacayo. Huan ijcón ixnesis ninuan mopueblojcahuan de que tichipahuac ya. ");
INSERT INTO azzNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Huan cuac Jesús calayic tech ne pueblo Capernaum, ijcuacón se tayecanque soldado romano motoquij campa Jesús huan quitatautilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","―Totecotzin, notaquehual semi mococoa huan huetztoc ichan mocahuac melaxtic, huan tajyohuía ica ne tonehuilis telsenca ya. ");
INSERT INTO azzNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Huan Jesús quilij ijcuín: ―Nejua niyás nicpajtitiu. ");
INSERT INTO azzNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ijcuacón in tayecanque soldado romano tananquilij ijcuín: ―Totecotzin, nejua amo nechnamiqui ma ticalaqui tech nochantzin. Ta, sayó xihualtanahuati campa tionyetoc, huan ijcón notaquehual pajtis. ");
INSERT INTO azzNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Huan nejua no nitatacamati ten nechnajnahuatía. Huan nejua niquinnajnahuatía nosoldados ma nechtacamatican. Huan nicnahuatía se soldado ma xiyó, huan yejua yohui. Huan nicnahuatía ocsé ma xihuiqui, huan yejua huitza. Huan nicnahuatía notaquehual ma xicchihuati tensá, huan yejua quichihuati. ");
INSERT INTO azzNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Huan cuac Jesús quicayic nijín tajtolis, ijcuacón Yejuatzin quimoucacayic huan quinilij in tagayot ten cualtoctiliayaj: ―De melau ten namechilía que intzalan nochi ne pueblojuani de Israel amo aquen nicajsic ten quipía in yec tacuautamatilis queme nijín tayecanque soldado romano. ");
INSERT INTO azzNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Huan no namechyequilía que hualasque de nohuiyan míac taneltocani ten amo judíos. Huan yejuan hualasque de campa iquisayampa in tonal huan de ipolihuiyampa tonal huan calaquisque huan tacuasque ihuan in huejcautetatme judíos, in Abraham huan in Isaac huan in Jacob. Huan ompa yejuan calaquisque campa Dios momasoutoc ipan itaneltocacahuan ica ihueyichicahualis huan namejuan amo nancalaquisque. ");
INSERT INTO azzNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Huan namejuan in tagayot judíos ten nanpohuisquíaj campa Dios momasoutoc ica ihueyichicahualis, namejuan Dios namechcalantamotas tech ne tayohuayanilot campa nanchocatosque huan nantannanatzocatosque tech ne tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Huan Jesús quilij ne tayecanque de soldados ijcuín: ―Xiyó ya mochan huan ijcón mochihuas queme tejua titacuautamatic que pajtis motaquehual. Huan ijcón nitaquehual pajtic ya tech ne momento. ");
INSERT INTO azzNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Huan huala Jesús huan calayic ichan in Pedro huan ompa quitac imonan in Pedro que huetztoya ica hueyi totonic. ");
INSERT INTO azzNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ijcuacón in Jesús quimaquitzquij in cocoxque huan ijcón niman quisac in totonic. Huan niman imonan in Pedro moquetzac huan quintamacac icalpanocahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Huan cuac ne tapoyahuito ya, ijcuacón Jesús yetoya oc ichan nimonan in Pedro huan ompa cualcuiliayaj míac tagayot ten quipiayaj inyolijtic amocuali ejecame. Huan Jesús quincalanquixtilij in amocuali ejecame sayó ica se tajtol, huan ijcón no quinpajtij nochi in cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Huan melau ijcón mochihuac ten quijcuilojca ya ne tanahuatijque Isaías cuac quijtojca ijcuín: “Yejuatzin tajyohuico para techpajtis den tococolisuan huan tajyohuico para techajchihuilis de nochi totoneucayohuan”. ");
INSERT INTO azzNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Huan cuac Jesús quitac que míac tagayot quiyehualojtoyaj, ijcuacón Yejuatzin quintitanic imomachtijcahuan ma panocan sentapalpa den hueyíat in mar de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Huan se tanextilijque den tanahuatil de Moisés motoquico campa Jesús huan quilij Yejuatzin ijcuín: ―Tamachtijque, nicnequi nimitztoctilis huan nimitztacamatiyás campa yesqui tiyás. ");
INSERT INTO azzNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ijcuacón in Jesús tananquilij ijcuín: ―In cuectzitzin quipíaj in téchanti campa cochij huan in tototzitzin den patantinemij ejecaixco quipíaj in tepajsoluan, pero Nejuatzin ni Yectagatzin amo nicpía can nimocuatecas. ");
INSERT INTO azzNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Huan senme den imomachtijcahuan de Jesús quilij ijcuín: ―Totecotzin, pero achtopa de que nimitztoctilis huan nimitztacamatiyás, pues nechcahua ma niyó nictalpachoti nopapá ten momiquilij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Huan Jesús quinanquilij ijcuín: ―Xihuiqui nohuan xinechtoctili huan xinechtacamatiyás. Huan xicahuacan ma quitalpachocan in ánimajme: ne naquen mictocque tech ninyolo ten amo quinequij nechtoctilisque. ");
INSERT INTO azzNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Huan de ompa Jesús calayic tech in barco huan imomachtijcahuan quisehuicayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Huan pehuaco se hueyi tetzaucaejecat huan chicahuac taejecaya huan in at mocuentecaya huan calaquía tech in barco. Huan Jesús Yejuatzin cochtoya. ");
INSERT INTO azzNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Huan imomachtijcahuan yajque quijxititoj huan quilijque ijcuín: ―Totecotzin, xitechonmaquixti porín tejuan tipolihuitij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ijcuacón nimantzin in Jesús ixpetanic huan quinilij ijcuín: ―¿Queyé semi nanmomoutíaj? Namejuan amo yec majsitoc de namotacuautamatilis. Huan ijcón in Jesús moquetzac huan quitacahualtij ne tetzaucaejecat huan in hueyíat. Huan in hueyíat mocahuac ijcón amanis. ");
INSERT INTO azzNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ijcuacón in imomachtijcahuan semi quimoucaitacque huan moyolnojnotzayaj se huan ocsé ijcuín: ―¿Toni taman nijín tagat? Porín in ejecat huan in hueyíat no quitacamatij. ");
INSERT INTO azzNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Huan ajsic Jesús sentapalpa den hueyíat in mar de Galilea, campa calyetocque in pueblojuani de Gadara. Huan de ompa quinamiquitoj Jesús ome taca ten quipiayaj ninyolijtic in amocuali ejecame. Huan ne taca hualquisque itech ne ánimajtecochme, huan catcaj semi yoltahuelme. Huan amo aquen huelía panohuaya itech ne ojti. ");
INSERT INTO azzNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Huan in omen peuque tzajtzij ijcuín: ―¿Toni ticpía tohuan, Jesús, Teconetzin de Dios? ¿Xe tihuala nican para titechtajyohuiltis tejuan achtopa que hualasquía ne tonalme de tatzacuiltilis? ");
INSERT INTO azzNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Huan amo huejca yetoyaj semi míac pitzome ten tacuajtoyaj huan ixtahuanentoyaj. ");
INSERT INTO azzNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Huan in amocuali ejecame quitatautijque Jesús ijcuín: ―Como titechcalanquixti de nijín tagat, xitechcahua ma ticalaquican tech ne pitzome. ");
INSERT INTO azzNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ijcuacón in Jesús quinnahuatij ijcuín: ―Xiyacan pos. Huan ijcón in amocuali ejecame quisque itech ne taca huan calacque tech ne pitzome. Ijcuacón in pitzome peuque motalojtinemij huan motaquesuijque tech ne hueyíat huan ijcón nochi in pitzome moaelsimijque tech in marijtic. ");
INSERT INTO azzNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Huan ne naquen tapiayaj ica ne pitzome, yejuan moucacholojque huan yajque tech ninpueblo huan ompa peuque quitetapohuiyaj nochi ten mochihuac ica por ne ome taca ten quipiayaj in amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ijcuacón in pueblojuani yajque quinamiquitoj Jesús. Huan cuac quitacque ya, ijcuacón quitatautijque Jesús de que ma quisa de ne inpueblojcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Huan ijcón in Jesús calayic itech in barco huan panoc sentapalpa de hueyíat den mar de ne Galilea, huan ajsito tech ne ipueblo. ");
INSERT INTO azzNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Huan ijcón mochihuac ne tonal que sequi taca cualcuilijque campa yetoya Jesús se cocoxque den nochi ninacayo tamisensepoutoc, huan amo huelía nejnemía, huan ne cocoxque huetztihualaya tech se petatzin. Huan cuac Jesús quitac nintacuautamatilis de nojón nahui taca, ijcuacón in Jesús quilij in cocoxque ijcuín: ―Ximoyolchicahua, noconetzin, porín motajtacoluan nimitzintapojpoluía ya. ");
INSERT INTO azzNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Huan ijcón sequi tanextiliani den tanahuatil de Moisés ten ipa yetoyaj ya calijtic, yejuan quiyolnemiliayaj ijcuín: “Nijín tagat quimohuispoloa Dios ica itajtoluan”. ");
INSERT INTO azzNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ijcuacón in Jesús nimantzin quinixmatilij nintalnamiquilis de ne tanextiliani huan quinilij ijcuín: ―¿Queyé nanquiyolnemilíaj ten amo cuali? ");
INSERT INTO azzNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Catiyejua tajtol cachi amo ohui cuac niquilis ne cocoxque? Ma niquijto: “Nimitztapojpoluij ya motajtacoluan”, oso ma niquijto ijcuín: “Ximoquetza huan xiyó mochan”. ");
INSERT INTO azzNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Huan nejua namechyecmatiltía que Nejuatzin ya ni Yectagatzin de Dios. Huan nicpía tanahuatil nican talticpac para niquintapojpoluis naquen motajtacolmacac ya. Huan de ompa Jesús quilij in cocoxque ijcuín: ―Ximehua huan xicui motapech huan xiyó mochan. ");
INSERT INTO azzNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Huan ijcón in cocoxque ten amo huelía nenemía, yejua ne moquetzac huan yajqui ichan. ");
INSERT INTO azzNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Huan cuac in tagayot quitacque ya toni mochihuac, ijcuacón semi quimoucaitacque huan quimohuistilijque Dios porín Dios quimactilij ya senme den talticpacuani de ne chicahualis de tapajtía ica chicaucahuelilis. ");
INSERT INTO azzNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Huan queman Jesús panotiaya ompa, ijcuacón Yejuatzin quitac se tagat ten monotzaya Mateo tocotziutoc caltenteno campa quintopaluiaya in pueblojuani. Ijcuacón in Jesús quilij ijcuín: ―Xinechtoctili huan xinechtacamatiyás. Ijcuacón in Mateo moquetztiquisac huan yajqui quitoctilito Jesús ma momachtiti de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Huan ijcón cachi satepan yajqui Jesús tacuato ichan Mateo. Huan no hualajque miacque tatopaluiani ihuan in taca ten amo quitacamatque in tanahuatil de Moisés. Huan ijcón sen tacuajtoyaj ihuan Jesús huan imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Huan cuac in fariseos quitacque que in Jesús sen tacuajtoya ihuan in tatopaluiani, ijcuacón yejuan quintajtoltijque ne imomachtijcahuan de Jesús ijcuín: ―¿Queyé namotamachtijcau tacuajtoc ihuan ne tatopaluiani huan in taca ten amo tatacamatinemij den tanahuatil de Moisés? ");
INSERT INTO azzNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Huan queman in Jesús quicayic ijcón nijín matájtanti, ijcuacón Yejuatzin tananquilij ijcuín: ―In tagayot ten mopohuaj yolpactocque, yejuan nojonques amo monequij tepajtijque. Ta, namechilía que sayó in cocoyani monequij tepajtijque. Ica ya nojón ninuan nisentacuajtoc nijín tatopaluiani. ");
INSERT INTO azzNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Xiyacan huan xicyecajsicamatican toni quijtosnequi nijín tajtol de Tajtoltzin de Dios: “Nicnequi xiteyolicnelican huan amo nicnequi sayó xinechtayocolican tapialme para ica nannechmohuistilisque”. Nejuatzin amo nihuala niquintemoco naquen mopohuaj yolchipauque. Ta, sayó niquintemoco tajtacolejque para ma yejuan ma moyolnemilican den nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Huan ijcón hualajque imomachtijcahuan den Juan Taahuijque huan quitajtanilicoj Jesús ijcuín: ―Tejuan huan in fariseos timosahuaj miacpa. Huan momomachtijcahuan, ¿queyé amo no mosahuaj? ");
INSERT INTO azzNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Huan Jesús tananquilij ijcuín: ―Amo huelis moyolcocosque nochi in taijitalme ten hualajque para moyolpactisque tech in iluit de ne namictilis, como yetoc oc in teyoquich. Pero queman hualas ne tonal cuac in teyoquich cajchihuasque, ijcuacón tech ne tonalme huelis mosahuasque nochi in taijitalme. ");
INSERT INTO azzNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Huan ijcón in Jesús quinnextilij in tacaquini ica nijín nexcuitil huan quinejnehuililtij in yancuic nemilis ihuan in yancuic tasal huan yancuic vino: ―Huan no ijcón amo aquen quijtzoma se yancuic tasal tech se tasalsol. Porín cuac se quipacas, ijcuacón yejua ne mismo in yancuic tasal motocotzos huan ijcón cachi quixcocototzas in tasalsol huan cachi hueyi tzayanis. ");
INSERT INTO azzNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Huan amo no aquen quipanteca in yancuic vino tech in cuetaxsolme. Porín in yancuic vino, yejua ne mochicahualtía huan atzitzicasquisa. Huan ijcón quitzayanas in cuetaxsol huan mimilahuis nochi in vino. Huan ijcón ijtacahuis in cuetaxsol. Pero in yancuic vino se quitequilía tech in yancuic cuetaxme huan ijcón in vino huan in cuetaxme yejuan nojonques amo ijtacahuisque. ");
INSERT INTO azzNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Huan cuac Jesús quinnextiliaya oc in tagayot de nijín tajtolme, ijcuacón huala se tayecanque den judíos huan motacuaquetzaco huan motentocaco iixpantzinco Jesús huan quilij ijcuín: ―Nosihuapiltzin yequin momiquilij, huan como Tejuatzin tiyás huan ticsohuas momatzin ipan nosihuapiltzin, ijcuacón yejua ocsepa quipías nemilis. ");
INSERT INTO azzNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Huan ijcón moquetzac Jesús huan yajqui ihuan in tayecanque den judíos huan quitoctilijque Jesús imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Huan no yetoya se sihuat naquen mococoaya esmeyaya majtactiomome xihuit huan motoquij icampa Jesús huan quinalmatoquilij itilmajtzin in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Porín sihuat moyolnemiliaya ijcuín: “Ta sayó nicnalmatocas itilmajtzin, ijcuacón nejua nipajtis”. ");
INSERT INTO azzNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Huan Jesús mocuitapancuepac huan quisenitac in sihuat huan quilij ijcuín: ―Ximoyolchicahua, tejua sihuatzin, ica por nojón motacuautamatilis ten ticpía, tejua tipajtic ya. Huan ijcón tech ne momento pajtic ya in sihuat. ");
INSERT INTO azzNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Huan cuac calayic Jesús tech ichan den Jairo, yejua in tayecanque tagat den judíos, ijcuacón in Jesús quinitac in tatzotzonani ten tapitzayaj huan míac tagayot mocuejmolojtoyaj. ");
INSERT INTO azzNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ijcuacón in Jesús quinilij in tagayot ijcuín: ―Xiquisacan de nican, porín in sihuapil amo miyic. Ta, sayó cochtoc. Huan in tagayot quiquejqueloayaj san de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Huan cuac quisque ya in tagayot, ijcuacón in Jesús calayic huan quimaquitzquij in sihuapiltzin huan yejua moquetzac. ");
INSERT INTO azzNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ijcuacón tech ne pueblojcopaca nimantzin motetapohuij itech in pueblojuani de nijín chicahualis de Jesús por lo que ten quichihuac Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Huan cuac quisac Jesús de ne ichan in Jairo, ijcuacón quitoctilijque ome taca ixpojpoyome huan quitzajtzilijtiyayaj huan quiliayaj Jesús ijcuín: ―Xitechonyolicneli, Tejuatzin Temaquixtijque tion Teconetzin de rey David. ");
INSERT INTO azzNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Huan queman Jesús calayic ya itech ichan, ijcuacón motoquijque in taca ixpojpoyome, huan Jesús quinilij ijcuín: ―¿Xe namejuan nanquineltocaj que nihuelis namechpajtis? Ijcuacón yejuan tananquilijque ijcuín: ―Quema, Totecotzin. ");
INSERT INTO azzNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ijcuacón in Jesús quinixmatocac huan quinilij ijcuín: ―Ma ijcón mochihua porín namejuan nanquipíaj ya in yec tacuautamatilis. ");
INSERT INTO azzNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Huan niman ixpajtijque. Huan Jesús quinnajnahuatíj ijcuín: ―Xiquitacan, amo aquen xictapohuican aconi namechpajtij. ");
INSERT INTO azzNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Huan quisque in taca huan peuque quitetapohuiayaj nohuiyan tech in pueblojuani de nochi in pueblos nochi ten quichihuac Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Huan cuac yequin quisque nojón taca ten catcaj ixpojpoyome, ijcuacón cualcuilijque campa Yejuatzin se tagat ten amo huelía tajtoaya huan no quipiaya iyolijtic se amocuali ejecat. ");
INSERT INTO azzNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Huan cuac Jesús quicalanquixtilij ya in amocuali ejecat, ijcuacón ne tagat ten amo huelía tajtoaya, yejua ne pehuac yec tajtoa ya. Ica ya nojón in tagayot semi quimoucaitacque huan quijtoayaj ijcuín: ―Amo queman ijcón tiquitayaj se hueyi mohuiscatequit queme nijín itzalan in pueblojuani de Israel. ");
INSERT INTO azzNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Huan in fariseos no quijtoayaj ijcuín: ―Nijín tagat Jesús quincalanquixtía in amocuali ejecame ica ichicahualis den tayecanque den amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Huan Jesús nentiaya tech nochi ne pueblojme campa ne milajyetoni huan quinnextilijtiaya itech in tiopanme de judíos, huan quinnojnotzaya ica in yancuic Tajtoltzin de que Dios momasoutoc ica ichicahualis para quinyolyecantiyás itaneltocacahuan. Huan no Jesús tapajtiaya ica nochi de míac tataman cocolisme huan nochi de míac tataman tonehuilisme ten quipiayaj in pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Huan cuac Jesús quinitac in huel míac tagayot, ijcuacón Yejuatzin semi quinyolicnelij porín in tagayot tajyohuijtoyaj huan tayocoyayaj queme ichcame ten cuamoyautocque huan queme ne ichcame ten amo quipíaj in tapixque. ");
INSERT INTO azzNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ica ya nojón in Jesús quinilij imomachtijcahuan ijcuín: ―Yec melau míac ongac milajtapixcalis huan amo miacque naquen tequitisque. ");
INSERT INTO azzNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ica ya nojón xictajtanilican Namohueyitajtzin Dios ten niaxca in tapixcalis, ma Yejuatzin quinualtitani míac tequitini para ma quisentilican nochi nijín taquilome. ");
INSERT INTO azzNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Huan Jesús quinnotzac in majtactiomome imomachtijcahuan huan quinxejxelohuilij cada se in tanahuatil para ma yejuan ijcón huelis quincalanquixtisque in amocuali ejecame, huan para ma ijcón huelis tapajtisque ica nochi den tataman cocolisme huan toneucayome den quipíaj in pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yejuan nijín tocayme den majtactiomome itatitaniluan de Jesús. Achto Simón ten no cojpatocaytijque Pedro, ihuan niicniu Andrés, huan Jacobo ihuan niicniu Juan, nijín omen iteconehuan de Zebedeo. ");
INSERT INTO azzNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Huan no catcaj itatitaniluan de Jesús in Felipe, huan Bartolomé, huan Tomás, huan Mateo in tatopaluijque, huan Jacobo yejua iteconeu Alfeo, huan in Lebeo ten no quitocajtijque Tadeo. ");
INSERT INTO azzNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Huan no catcaj itatitaniluan de Jesús in Simón ten pohuía ihuan in taca políticos ten yolchicauque; huan no in Judas Iscariote naquen quitemactij Jesús ma quimictican. ");
INSERT INTO azzNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Huan ijcón in Jesús quintitanic nijín majtactiomomen huan quinyecmatiltij ijcuín: ―Amo xiyacan campa calyetocque in pueblojuani ten amo judíos, nión no xicalaquican tech in pueblos campa Samariajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Ta, xiyacan achto tech ne campa pueblojuani de Israel campa in tagayot nemij queme ichcame ixcuamoyautocque. ");
INSERT INTO azzNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Huan xiyacan xiquinmatiltican que Totajtzin Dios motoquijtoc ya huan quimonequiltía quinyolyecanas itaneltocacahuan ica in chicahualis den eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Xiquinpajtican cocoyani, huan xiquinchipahuacan naquen inacayo cocotocatoc, huan xiquinyolitican miqueme, huan no xiquincalanquixtican in amocuali ejecame. Huan ijcón queme Dios namechtayocolij ya nijín chicahualis, no ijcón xictequitiltican huan amo teyi xiquintopaluican. ");
INSERT INTO azzNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Huan amo no xicuiyacan tomin de istac nión tomin de plata nión de cobre, nión ocsé taman oc. Huan amo no xicuiyacan ne tominehualoni ten mitzpalehuisquía tech in ojti. ");
INSERT INTO azzNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ta, xicuiyacan se panti san namotilma; huan amo no xicuiyacan ocsequin tegacme huan nión namotopil. Porín tacaquini quinamiquij ma quintamacacan nijín tequitini ica ne tacualis porín tanojnotztinemíj ica in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Huan no Jesús quinilij nijín majtactiomomen ijcuín: ―Huan cuac nancalaquisque tech se pueblo oso milajpa, ijcuacón xictemocan se tagat ten nanquitasque que namechtasojta, huan ompa ichan ximocahuacan hasta cuac in tonal cuac namoquepasque. ");
INSERT INTO azzNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Huan cuac nancalaquisque tech se cali, ijcuacón xiquintajpalocan huan xiquinilican ijcuín: “Xiyolpactocan tohuanme”. ");
INSERT INTO azzNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Huan tacán ne calyetoni namechselíaj, ijcuacón ma yetoti ninpan ne paquilis de Dios. Huan tacán ne calyetoni amo namechselíaj ica paquilis, ijcuacón xiquincautehuacan huan xiquinchicaucanajnahuatican que Dios amo quinmacas ne yolpaquilis. ");
INSERT INTO azzNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Huan tacán cansica acsame amo namechselíaj huan amo no namechcaquilíaj namotanojnotzalis, ijcuacón xiquisacan de ne cali oso de ne pueblo huan ximometztzejtzelocan ma huetzi nochi ne talnex ten mopiloj namometztampa para ma ijcón ixnesis que Dios quintatzacuiltis nijín pueblojuani porín yejuan quixtopeuque ya in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","De yec melau ten namechilía que tech ne tonal cuac huetzis in hueyi tatzacuiltilis de Dios, ijcuacón cachi oncas tajyohuilis tech nijín pueblojme ten quixtopeuque in Tajtoltzin de Dios. Huan amo quipías hueyi tatzacuiltilis in ome pueblojme de Sodoma huan Gomorra, masqui Dios quintajtamij ica tit nojón ome pueblos ne queman ya ica porín pitzotic nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Huan no Jesús quinnextiliayaj in majtactiomomen ijcuín: ―Xiquitacan, Nejuatzin namechtitani xiyacan queme ichcame yolcualime huan xitequititij intzalan ne tagayot majyá tecuanime. Huan xitequititij ica cuali tanemililis queme cohuat ten quimati quenín mopalehuis. Huan xitequititij ica ne yolcualtagayot ijcón queme in paloma ten sayó quinchihuilía ten cuali. ");
INSERT INTO azzNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Huan no ximoyecpiacan den ne tagayot ten amo taneltocani. Porín yejuan namechtemactisque para ma namechtelchihuacan ihuan ne tequihuanime huan namechuijuitequisque itech in tiopanme den judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Huan no namechuicasque ninixpan huejueyin chihuanime, gobernadores huan in rey sayó porín namejuan nantacuautamatij ica notocay. Huan masqui nanmoquetzatihue inixpan ne tequihuani, pero namejuan nanquinnextilisque de notajtoluan. Huan ijcón nochi huelis nantajtosque de notajtoluan ninixpan in huejueyin chihuanime huan ninixpan in tagayot ten amo pohuíaj ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Huan ne cuac namechtemactisque inmaco in tequihuani, ijcuacón amo ximoyolcuejmolocan de quenín nantananquilisque oso toni nanquijtosque. Porín cuac ejcos ne momento, ijcuacón Dios Yejuatzin namechmacas toni ica nantajtosque. ");
INSERT INTO azzNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ijcuacón amo namejuan nantajtosque. Ta, tajtos Yejuatzin in Yecticatzin Espíritu namotech ten Totajtzin Dios cualtitanis. ");
INSERT INTO azzNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Huan no Jesús quinilij in majtactiomomen ijcuín: ―Huan ijcuac in icniu quitemactis iicniu ma quimictican; huan in tetat quintemactis niconehuan ma quinmictican. Huan no in teuan moajocuisque huan quitehuisque nintat; huan no ijcón quinmictisque. ");
INSERT INTO azzNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Huan ijcón nochin in talticpacuani namechtahuelitasque porín nantacuautamatij ica notocay. Huan naquen yec tacuautamati hasta cuac in miquilistempan, yejua ne maquisas. ");
INSERT INTO azzNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Huan cuac namechtajyohuiltisque tech se pueblo, ijcuacón xicholocan huan xiyetotij ocseco tech ocsé pueblo. Yec melau ten namechilía que Nejuatzin ni Yectagatzin amo nihualas achtopa de ijcuac nantaminemisque ya huan nantamitanojnotzasque ya inpan in pueblojuani de Israel. ");
INSERT INTO azzNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Huan se momachtijque amo huelis mochihuas cachi hueyi chiuque huan que nitamachtijcau. Huan no ijcón se taquehual amo huelis mochihuas cachi hueyi chiuque huan que nipatrón. ");
INSERT INTO azzNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Porín monequía de que se momachtijque ma no tajyohuis queme itamachtijcau tajyohuía. Huan no ijcón monequi de que se taquehual ma no quijyohuis ijcón queme ipatrón tajyohuía. Huan Nejuatzin nechtocaytijque ni amocuali Beelzebú, huan Nejuatzin ya nitetat den nochi in taneltocani. Huan no ijcón namejuan no cachi oc namechtocaytisque nanamocualime porín nanpohuij nohuan huan nannechtoctilíaj para nechtacamatisque. ");
INSERT INTO azzNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Huan ijcón in Jesús quinnextiliaya in majtactiomomen ijcuín: ―Huan cuac nanquinnojnotzasque in tacaquini ica notajtoluan, ijcuacón xiquinyequilican huan amo xiquinpinahuilican. Porín nochi tanemililis ten motatijtoc, yejua ne quipía de que monextis. Huan nochi in tachihualis ten mopachojtoc, yejua ne quipía que momatis. ");
INSERT INTO azzNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Huan nochi ten namechiliaya cuac tisenolochyetoyaj campa ne yecahuila, yejua ne namejuan xiyacan xictentelican senteixteno campa ne tonala ya. Huan nochi ten namechichtacailijca ya namonacastenteno, yejua ne xitanojnotzatij senteixteno desde ne mercado. ");
INSERT INTO azzNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Huan amo no xiquinmohuilican ne naquen ten temictía den se inacayo, porín yejua ne amo huelis quimictisque se italnamiquilis. Ta, cachi cuali ma xicmoucatocacan Totajtzin Dios, porín Yejuatzin melau huelis quitajtamis namonacayo huan no namotalnamiquilis tech in mictan campa tajyohuilis den tit. ");
INSERT INTO azzNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Huan ome tototzitzin, ¿canachica huelis tiquinnamacasque? Pues sayó ica se quinto. Huan Totajtzin Dios quinyecpixtoc nijín tototzitzin huan amo quincahuas ma huetzican como amo quimonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Porín Dios Yejuatzin cachi namechueyichihuas huan que namotzonuan, huan Totajtzin Dios quinpohua namotzonuan huan Yejuatzin cuali quimati canachi ongac. ");
INSERT INTO azzNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ica ya nojón amo ximomoutican cuac in tagayot namechchihuilíaj tensá ten amo cuali. Porín Dios cachi namechueyichihuas namejuan huan que ne tototzitzin. ");
INSERT INTO azzNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Huan no Jesús quinilij ijcuín: ―Huan nochi ne naquen quiyequilíaj senteixteno que yejuan yec tacuautamatij nohuantzin porín Nejuatzin ni Cristo, Nejuatzin ya nicyequiliti Notajtzin Dios ten yetica nepa eluiyactzinco de que yejuan melau poutocque nohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Huan nochi naquen teilisque senteixteno que amo nohuan tacuautamatij, Nejuatzin nicyequiliti Notajtzin Dios ten yetica nepa eluiyactzinco de que yejuan amo nohuan pohuij. ");
INSERT INTO azzNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Huan no Jesús quinilij in majtactiomomen ijcuín: ―Huan amo xicnemilican que Nejuatzin nihuala para namechualcuilis sayó in yec yetolis nican talticpac. Porín melau amo nihuala para namechualcuilis sayó ne yec yetolis. Ta, namechualcuilis ne tehuilis huan ne xejxelolis. ");
INSERT INTO azzNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Huan no nihuala para ma in teconeu de se calyetoni quixnamiqui itat, huan para ma in teichpoch moxejxelos de inan, huan para ma in tesihuamon ma amo quiyequitas imonan. ");
INSERT INTO azzNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Huan cuac se tagat tacuautamatis nohuan, ijcuacón yejua quitahuelitasque ichancahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Huan amo quinamiquis de que ma pohuisque nohuan ne teconehuan taneltocani como cachi quintasojtaj itat huan inan huan como amo nechtasojtaj Nejuatzin. Huan amo no quinamiquis de que ma pohuis nohuan ne tetat taneltocacque como cachi quintasojta ne itelpochuan huan como amo nechtasojta Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Huan Jesús quinnextiliaya in majtactiomomen nijín nexcuitil ijcuín: ―Nicnejnehuililtía ne cruz queme se tajyohuilis. Huan como in taneltocani amo taxicojtiyasque ica nijín tajyohuilis cuac nechtoctilisque, ijcuacón yejuan amo quinamiquis pohuisque nohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Huan nochi ne naquen quinejnequisque quiyecpiasque ninemilis nican talticpac, yejuan nojón quipolosque san. Pero nochi naquen quisecocahuasque huan quipolosque inemilis nican talticpac porín nohuan yec tacuautamati, yejuan nojonques quiselisque ne yec nemilis ten amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Huan Jesús quinnextiliaya ijcuín: ―Nochi naquen namechselisque, no nechselisque Nejuatzin. Huan nochi ne naquen nechselisque, no quiselisque Notajtzin Dios naquen nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Huan nochi taneltocani ten quiselisque se itanahuatijcau de Dios porín yejua huitza itencopa de Totajtzin Dios, yejuan nojón no quiselisque ne tetayocolil de Dios ijcón queme in tanahuatijque. Huan nochi taneltocani ten quiselisque se yolchipaucatagat porín yejua no yolcualtagat, yejuan quiselisque ne cuali tetayocolil de Dios, ijcón queme ne tagat ne yolcualtagat. ");
INSERT INTO azzNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Huan nochi taneltocani ten quimacasque tzictzin sesecat ma quiyolsehui senme de nijín nomomachtijcatzitzin sayó porín yejuan notanahuatijcatzitzin, de yec melau namechilía que yejuan nojonques quiselisque ne tetayocolil de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Huan Jesús quintamitequimactij ya ne majtactiomome imomachtijcahuan. Huan de ompa Jesús quincauteu imomachtijcahuan huan yajqui tanojnotzato huan quitenextilito in Tajtoltzin de Dios itech ne pueblojuani campa ninpueblojuan imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Huan in Juan Taahuijque tzactoya cárcelijtic huan quimatiltijque Juan den tachihualisme de Jesus in Cristo Temaquixtijque. Ijcuacón Juan quintitanic ome imomachtijcahuan huan yejuan yajque, ");
INSERT INTO azzNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","huan quitajtoltitoj Jesús ijcuín: ―¿Cox melau Tejuatzin ya ti Cristo tanahuatijque de Dios ten hualasquía? Oso, ¿cox ticchiasque oc ma huiqui ocsé tanahuatijque de Dios? ");
INSERT INTO azzNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ijcuacón in Jesús tananquilij ijcuín: ―Xiyacan huan xicmatiltitij ne Juan de nochi notachihualisuan ten nanquicactocque ya huan ten nanquitztocque ya. ");
INSERT INTO azzNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Xictapohuican ne Juan de que in ixpojpoyome Nejuatzin niquintachialij ya. Huan in coxojme, axcan niquinnejnemiltij ya. Huan nochi cocoyani ten cocotocatoyaj ninacayo, axcan Nejuatzin niquinchipahuac ya huan niquinpajtij ya. Huan nochi naquen amo tacaquíaj, axcan niquintacaquiltij ya. Huan in taca ten momiquilijcaj ya, yejuan nojonques niquinpanquixtij yoltocque. Huan no xictapohuican ne Juan que neques ten ixnestinemij que pobres huan amo teyi chihuanime, yejuan nojonques niquinnextilijtoc in yancuic Tajtoltzin de Dios ten cualcui ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Huan tatiochihual ya nochi naquen amo quitahuelcaquij huan amo no moyolxocolíaj oc cuac quicaquij notajtoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Huan cuac imomachtijcahuan den Juan Taahuijque yajque ya, ijcuacón Jesús pehuac quinnojnotzac in tacaquini de toni chiuque ne Juan Taahuijque. Huan Jesús quiniliaya ijcuín: ―¿Huan toni nanquitatoj campa ne Juan tanojnotztoya nepa campa tayiucan? ¿Xe nanquisque para nanquitatoj se tagat ten yolmoucat ten quinejnehuilía queme acaselot ten nepa huan nepa cuihuica in ejecat? ");
INSERT INTO azzNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Huan como amo ijcón nancajsicque, ¿toni nanquitatoj? ¿Xe nanquisque para nanquitatoj se tagat de que taquentoc ica tilma ten semi cualtzin? Xiquitacan san, nanquimatij ya namejuan que ne naquen motaquentía huan mocualnextíaj ica tilma cualtzin, yejuan nojonques yetocque sayó ichanuan den huejueyinme tayecanani reyes. ");
INSERT INTO azzNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Huan como amo ijcón nancajsicque, ¿toni nanquisque nanquitatoj? ¿Xe nanquisque para nanquitatoj se itanahuatijcau de Dios? Quema, ijcón melau nanquitatoj. Huan no namechilía que ne Juan Taahuijque, yejua ne in cachi hueyi chiuque huan que nochi in osequin tanahuatiani de Dios ten nemicoj ya. ");
INSERT INTO azzNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Huan tajtoa de Juan tech in Tajcuilolamatzin de Dios campa quijtojca ijcuín: Xiquitacan, Nejuatzin nictitanic se notanahuatijcau huan yejua mitzyecanas, huan mitzachtohuijtiyás para mitzyejyectalilijtiyás moojpan. ");
INSERT INTO azzNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Huan de yec melau no namechilía ijcuín: ―Amo aquen ongac ocsé cachi hueyi chiuque de nican talticpacuani. Ta, sayó ne Juan Taahuijque. Pero axcan se tagat ten amo hueyi chiuque huan motemactis imaco Cristojesús ma Yejuatzin quiyolyecana inemilis, yejua ne cachi hueyi tatiochihualis quiselijtiyás huan que ne Juan Taahuijque quiselij. Huan axcan ne Juan Taahuijque amo hueyi chiuque oc. ");
INSERT INTO azzNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Huan ijcón Jesús quinnextiliaya imomachtijcahuan ijcuín: ―Itech ne tonalme cuac Juan Taahuijque achtopa nemico tohuan hasta axcan, Totajtzin Dios naquen tayecana ne eluiyactzinco, Yejuatzin quimonequiltij de que ma in tagat taneltocacque ma moyojyolchicahua huan ma mofuerzajuía para ma Dios quiyolyecana ica ichicahualis. Huan nochi naquen moyojyolchicahuas itech Cristo, yejua ne huelis calaquis campa Dios quinyolyecanas imomachtijcahuan ica ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Huan nochi nijín tanahuatiani de Dios huan tanahuatilme de Moisés, nochi yejuan tatetapohuijtihualayaj ica ne chicaucatajtolis de que Dios quimonequiltis quinyolyecanas itaneltocacahuan ica ichicahualis. Huan in Juan Taahuijque no tajtojtihuala ica nijín tajtolis. ");
INSERT INTO azzNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ijcuacón no Jesús quinilij ijcuín: ―Como nanuelij nancajsicamatij nijín tajtol, namechyequilisque que in Juan Taahuijque, yejua ne tanahuatijque de Dios monotza Elías den achtopa quijtojcaj ya in tanahuatiani que hualasquía. ");
INSERT INTO azzNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Huan ijcón nochi naquen quipías inacasuan para tacaquis, ma yec tacaqui huan cajsicamatis. ");
INSERT INTO azzNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Huan Jesús quinmachtij in tacaquini ica nijín nexcuitil: ―Huan, ¿tonica niquinnejnehuililtis in tagayot ten nijín tonalme nemij? Niquinnejnehuililtía queme coneme ten motalijtinemij tech in plaza huan tzajtzitinemij ihuan ocsequin coneme ten ninuan mahuiltijtinemíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Huan sequin de ne coneme quilisque ocsequin ijcuín: “Tejuan ticnequíaj namohuan timahuiltisque huan tejuan tamechtatzotzoniliayaj huan tejuan no tamechtapichiliayaj, pero namejuan amo nanquinecque nanmijtotisque. Huan no tamechcantarohuiliayaj ica ocsequin canciones ten tetayocoltíaj, pero namejuan amo no nanchocacque”. Huan no in Jesús quinilij in tagayot ijcuín: Huan ijcón queme nijín coneme sayó teijitojtinemíaj, namejuan sayó nantatejtenehuani san. ");
INSERT INTO azzNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Pero cuac huala Juan Taahuijque, ijcuacón yejua ne amo teltacuaya huan amo no tayaya ne vino queme namejuan. Huan ijcón namejuan nanquijtojque que Juan quipiaya iyolijtic se amocuali ejecat. ");
INSERT INTO azzNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Huan cuac Nejuatzin nihuala, Nejuatzin ni Yectagatzin, ijcuacón nitacuaya huan nitayaya ne vino, huan no ijcón namejuan nannechijtohuiliayaj ijcuín: “Xiquita san nijín tagat Jesús de Nazaret, yejua ne teltacua huan tayitinemi ne vino huan no motasojtatinemi ihuan ne tatopaluiani huan no motasojtatinemi ihuan neques ten amo quitacamatque itanahuatil in Moisés”. Huan in Tajtoltzin de Dios technextiliaya ijcuín: “Huan Dios itanemililis monextijtiyás tech in chipaucanemilis den naquen melau yec tacuautamati ihuan Dios”. ");
INSERT INTO azzNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Huan ijcón in Jesús pehuac quinchicaucanajnahuatía ne pueblojuani campa Yejuatzin quichihuac ne cachi huejueyin mohuiscatequime. Porín ne pueblojuani melau amo moyecyolnemiliayaj den nitajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Huan Jesús quinilij ijcuín: ―Nantelteicneltiani namejuan, pueblojuani de nanpohuij de ne pueblo monotza Corazín. Huan no ijcón nantelteicneltiani namejuan, nanpueblojuani de Betsaida, porín amo nanmoyecyolnemiliayaj de namotajtacoluan. Huan in pueblojuani de Tiro huan Sidón cachi moyecyolnemilisquíaj ya de nintajtacoluan como ijcón quitasquíaj queme namejuan nanquitacque ya nijín mohuiscatequime ten nicchihuac ya. Quema, in pueblojuani de Tiro huan Sidón, yejuan cachi moyecyolnemilisquíaj ya huan motaquentisquíaj ya ica ne tilma den tzastic huan moixcuounexuisquíaj ya para ixnesisquía que yejuan quiyecajsicamatisquíaj ya que yejuan tajtacolejque. ");
INSERT INTO azzNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Huan ijcón no Jesús quinilij: ―Huan ne tonal cuac namopan huetzis ne hueyi tatzacuiltilis, ijcuacón yec melau cachi hueyi tatzacuiltilis nanquiselisque namejuan. Huan ne tagayot campa pueblos de Tiro huan Sidón amo cachi hueyi tatzacuiltilis quiselisque. ");
INSERT INTO azzNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Huan namejuan, pueblojuani de Capernaum, nanmoyolcajcayahuaj san porín nanmoyolueyinectinemij huan nanquinequij nanajsisque hasta ne eluiyactzinco. Pero xicmatican que Dios namechtajyohuiltis huan namechtalpantalis hasta ne tani campa in ánimajme tajyohuijtocque. Huan in pueblojuani de Sodoma cachi moyecyolnemilisquíaj ya den nintajtacoluan como quitasquiaj ya ijcón queme namejuan nanquitacque ya nijín mohuiscatequime ten Nejuatzin nicchihuac namohuan, huan ijcón yejuan ne pueblojuani yetosquía tohuan oc hasta axcan. ");
INSERT INTO azzNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ica ya nojón namechilía que ne tonal cuac namopan huetzis ne hueyi tatzacuiltilis, ijcuacón melau cachi hueyi tatzacuiltilis nanquiselisque namejuan huan que ne pueblojuani ten quiyehualojtoyaj Sodoma. ");
INSERT INTO azzNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Huan tech nojón tonalme Jesús quilij Itajtzin Dios ijcuín: ―Nimitzonueyimohuistilía, Notajtzin Dios, tion Tecotzin den eluiyactzinco huan den nican talticpac. Porín Tejuatzin tiquintatilij ya nijín taixmatilis para ma amo quimatican in taixmatini huan in tamachilejque. Huan Tejuatzin tiquinnextilij ya in yec taixmatilis de nijín moyancuicataneltocacahuan ten yoltanemilijtinemij queme coneme ten ayamo yec yolmajsij. ");
INSERT INTO azzNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Huan ma ijcón ticonchiutica, Notajtzin Dios, porín Tejuatzin ijcón ticonmonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Huan Tejuatzin Notajtzin tinechonmactilij ya nochi nijín chicahualisme huan tanemililisme. Huan amo aca nechixmatis nejua nimoconetzin. Ta, sayó Tejuatzin ti Notajtzin tinechonixmati. Huan amo no aquen mitzonyequixmatis Tejuatzin Notajtzin. Ta, sayó Nejuatzin nimoconetzin nimitzyequixmati ya. Huan no Nejuatzin nimoconetzin niquinyecnextilis de que aconi Tejuatzin Notajtzin para nochi naquen niconmonequiltía niquinnextilis. ");
INSERT INTO azzNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Huan no Jesús quinilij in tacaquini ijcuín: ―Xihualacan nohuan, nochi namejuan naquen nanmotequitiltijtocque huan nantamamatocque ica ne tajyohuilis de namotajtacoluan. Xihualacan namejuan nohuan, huan Nejuatzin namechmacas ne yolsehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Huan nicnequi xicselican notamachilis itech namonemilispan, queme se yugo ten huelis namechyecantinemis tech moojpan. Huan ica cuali ximomachtican de nejua, porín Nejuatzin niyolyemancatagat; huan niyolcualtagat huan ijcón nancajsisque ne yolsehuilis tech namoyolojuan. ");
INSERT INTO azzNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Porín in yugo de namechtalilis, yejua ne semi amo etic. Huan in tamamal ten Nejuatzin namechmacas, yejua ne semi amo no tesiouti. ");
INSERT INTO azzNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Huan tech nojón tonalme Jesús panotiaya campa tatocala ica trigo tech se tonal de nesehuilis. Ijcuacón imomachtijcahuan peuque mayanaj. Huan de ompa yejuan peuque cuijuitiyáj huan quiyolcopinayaj nijín trigo huan quicuayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Huan cuac in fariseos quinitacque ton quichiutiyayaj imomachtijcahuan, ijcuacón quilijque Jesús ijcuín: ―Xiquita, momomachtijcahuan quichiutocque ten amo monequía quichihuasquía tech nijín tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Huan Jesús quinilij ijcuín: ―¿Xe namejuan amo queman nanquileerojque ten quichihuac in rey David huan itapalehuijcahuan cuac mayanque? ");
INSERT INTO azzNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Pos in rey David calayic ichantzin Dios huan quincuaj ne panes ten quitalijcaj ya iixpantzinco Dios para ica quimohuistilisque Dios. Huan nojón panes Dios amo quimonequiltiaya ma acsá quicuanij nión in rey David nión nitapalehuijcahuan. Ta, sayó ma quicuanij in tiopixcame judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Huan, ¿xe amo no nanquileerojque tech in tanahuatil de Moisés que ne tiopixcame judíos tequitij tech in tiopan de Dios masqui tech in tonal de nesehuilis? Pero yejuan amo motajtacolmacaj cuac tequitij tech in tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Huan Nejuatzin namechyequilía que nican niyetoc huan cachi nihueyichiuque que ne tiopan de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Huan, ¿xe namejuan amo nanquimatij toni quijtosnequi nijín tajtol?, ten Dios quijtoj ijcuín: “Nicnequi xicpiacan ne teyolicnelilis, huan amo nicnequi sayó xinechtenilican tapialme san para ica nannechmohuistilisque”. Huan tacán namejuan nanquimatisque ya toni quijtosnequi nijín tajtol, ijcuacón amo nanquintelchihuasque oc nomomachtijcahuan ten amo teyi quichiuque ten Dios amo quimonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Huan ijcón in Jesús quinyecajsicamatiltij ijcuín: ―Xicmatican ca cuali que Nejuatzin ni Yectagatzin huan ni Tayecancatzin de ne tonal de nesehuilis. Huan Nejuatzin nicpixtinemi tanahuatil para niteilis toni cualtías se quichihuas tech ne tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Huan ijcón in Jesús panotiaya huan yajqui calayic tech in tiopan de judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Huan ompa tocotzyetoya se cocoxque den imay mamijmiquilotic. Huan in tagayot judíos sayó quipijpixtinemíaj Jesús para quenín huelis quiteluilisque. Huan ijcón yejuan quitajtoltijque Jesús ijcuín: ―¿Xe Dios quimonequiltía ma onga tapajtilis de cocoyani tech nijín tonal de nesehuilis? ");
INSERT INTO azzNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ijcuacón in Jesús tananquilij ijcuín: ―Nican yetoc se nexcuitil: Tacán namejuan nanquipiasquíaj se ichcatzin huan huetzisquía tech se amel tech in tonal de nesehuilis, ¿xe amo nanyasque nanquiquixtitihue in tapialtzin? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Huan cuali nanquimatij que cachi valeroa se tagat huan que se ichcatzin. Ica ya nojón Dios melau quimonequiltía ma ticchihuacan ten cuali tech in tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Huan ijcón in Jesús quilij in cocoxque ijcuín: ―Ximomamelahua. Huan cuac in cocoxque momamelahuac ya, ijcuacón ne imay pajtic ya ijcón queme ne ocsé imay. ");
INSERT INTO azzNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Huan de ompa quisque in fariseos den tiopan huan peuque quiyolnemiliayaj quenín huelis para quimictisque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Huan cuac in Jesús quimatic que in fariseos quinequíaj quimictisque, ijcuacón Yejuatzin yajqui huan quitoctiliayaj míac tagayot. Huan ijcón Jesús quinpajtiaya míac cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Pero Jesús quinyecnajnahuatiaya ma amo teyi quijtoanij aconi catca Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Huan Jesús quinilij ijcón para ma mochihua ten quijcuilojca ne huejcautanahuatijque de Dios monotza Isaías cuac yejua tanojnotzaco ijcúin: ");
INSERT INTO azzNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Dios quijtoj que nican yetoc Notaquehual ten Nejuatzin nicnotzac ya. Yejuatzin ne Notasojconetzin huan nechyolpactía. Huan Yejuatzin ya ne nicyolpepexocaltij ya ica Noyecticatzin Espíritu. Huan Yejuatzin quinajsicamatiltis in tagayot ten amo pohuij ihuan Dios de quenín para yec chipaucanemisque. ");
INSERT INTO azzNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Huan Notaquehual amo elihuistiquiu huan amo motehuijtinemis nión no tzajtzitinemis campa ojmaxalme. Huan amo aquen quicaquisque nitajtolis tech in hueyi ojme. ");
INSERT INTO azzNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","In tajtacolejque ten yolcueptocque niquinejnehuililtía queme in acat ten quimatetziloa in ejecat. Huan Notaquehual huala para quinyolmelahuaco huan para quinyolchipahuaco neques den tajtacolejque huan amo para quintzojcuilojtiquiu. Huan ijcón quichihuati Notaquehual hasta ne tonal cuac nochi tamis ya in tajtacolnemilis. Ijcuacón motamichihuas in yec chipaucanemilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Huan in talticpacuani ten amo pohuij ihuan Dios quichixtosque Notaquehual ma quinmaquixtiqui. ");
INSERT INTO azzNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Huan cualcuilijque campa Jesús se tagat ten quipiaya iyolijtic se amocuali ejecat, se tagat nontzin ten amo tachiaya nión tajtoaya. Pero Jesús quipajtij huan ne tagat huelic tachíac ya huan huelic tajtoj ya. ");
INSERT INTO azzNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ijcuacón nochi in tagayot quimoucaitayaj huan quijtoayaj ijcuín: ―¿Xe yejua nijín ne Temaquixtijcatzin iconetzin de ne rey David? ");
INSERT INTO azzNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Huan cuac in fariseos quicacque nijín matájtanti, ijcuacón quijtoayaj ijcuín: ―Nijín tagat Jesús amo quincalanquixtía in amocuali ejecame ica ichicahualistzin de Dios. Ta, yejua quincalanquixtía in amocuali ejecame ica ichicahualis den amocuali Beelzebú naquen quinyecantoc in amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ijcuacón Jesús quintanemililixmatic huan quinilij ijcuín: ―Huan tacán in pueblojuani de se país moxejxelojtocque se huan ocsé huan motehuisque san, ijcuacón ne país nochi mohuejuelosque san. Huan no ijcón como in tagayot de pueblo oso se calyetoni moxejxelojtosque se huan ocsé ica xolojpijyot, ijcuacón ne calyetoni amo queman huelis sen yetosque ica paquilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Huan tacán in amocuali Satanás quicalanquixtis se amocualicniu ica yejua mismo ichicahualis, ijcuacón yejua ne motehuía yejua mismo san. Huan ijcón amo huelis huejcahuas nichicahualis. Ta, niman huejuelihuis ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Huan no Jesús quinilij in fariseos ijcuín: ―Namejuan nanquijtoaj que Nejuatzin niquincalanquixtía in amocuali ejecame ica in chicahualis de ne in amocuali tayecanque Beelzebú. Pero tacán ijcón nicchihuas, ¿ijcuacón aconi oc quinmacas chicahualis ne namoconehuan de ne namopueblojcahuan para ma yejuan quincalanquixtican in amocuali ejecame? ¿Xe in Satanás quinmacas namoconehuan ne ichicahualis? Pues amo melau. Ta, Totajtzin Dios quinmaca ne ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ica ya nojón namejuan namoconehuan namechtenextíaj que nanmocajcayautocque san. Porín Nejuatzin ya niquincalanquixtía in amocuali ejecame ica in chicahualis den Yecticatzin Espíritu. Huan nochi nijín ten nicchihuac quijtosnequi que ejcoc ya in tonal queman Dios momasoutoc namotzalan huan quinyolyecana itaneltocacahuan ica ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Huan Jesús no quinilij in tacaquini ijcuín: ―Se tagat ten semi chicahuac monequi ma achtopa quitzijtzicocan para que ijcón huelis quihuejuelohuilisque icalten huan para huelis cuilisque ten niaxca. Porín sayó ijcón huelis quichtequilisque ten niaxca. Huan xicmatican que no ijcón Nejuatzin nicuejuelos in chicahualis den amocuali Satanás. ");
INSERT INTO azzNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Huan nochi naquen amo nohuan pohui, yejua ne nechixnamiquis. Huan nochi ne tequitini ten amo nechpalehuisque cajocuisque in taquilome, yejuan nojonques sayó taijitacojtinemisque san. ");
INSERT INTO azzNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ica ya nojón namechilía ijcuín: Nochi tajtacolme den taca oso in ne mohuispololis ten yesqui, Dios nochi huelis quintapojpoluis. Pero naquen quimohuispolos in Yecticatzin Espíritu, yejua ne amo ica quipías oc ne tapojpoluilis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Huan nochi naquen nechmohuispoloa Nejuatzin ni Yectagatzin, yejua ne Dios huelis quitapojpoluis. Pero naquen quimohuispoloa in Yecticatzin Espíritu, yejua ne Dios amo queman quitapojpoluis, nión axcan tech nijín tonalme huan nión no huelis mopalehuis oc campa ne tatzacuiltiloyan de mictan. ");
INSERT INTO azzNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Huan ijcón in Jesús quinejnehuililtij se cuohuit queme se inemilis, huan quinilij in tacaquini ijcuín: ―Huan como cuali selistoc in cuohuit, no cuali tzojtzopec yesqui itaquilohuan; huan como amo cuali selistoc in cuohuit, amo no cualtías itaquilohuan. Ta, no xojxococ yesqui. Porín in cuohuit moixmati ica itaquilohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Huan namejuan nantacajcayahuani queme in cohuame. ¿Quenín huelis nantanojnotzasque ica ten cuali, como namejuan amo nanyolcualime? Huan namejuan nanyolpexontoque ica míac tenesi tanemililisme de namejuan san. Huan ica nijín nantajtoaj ten amocuali. ");
INSERT INTO azzNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Huan in tagat den yolchipahuac, yejua ne tajtoa ica ten cuali porín nitajtolis hualehuac tech ne iyolchipahualis. Huan in tagat den amo yolchipahuac, yejua ne tajtoa den pitzotic porín yoltzojcuiltic ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Huan no namechilía que tech ne tonal cuac namotech huetzis ne hueyi tatzacuiltilis, nochi namejuan nanquitemactijtihue iixpantzinco Totajtzion Dios nochi ten nantajtojtinenque huan nochi ten nanquichiutinenque nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Porín ica namotajtoluan ten cuali, Dios namechilis que namejuan nanyolchipauque ya. Huan ica namotajtolis ten pitzotic, Dios namechtelchihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Huan in fariseos huan in tanextiliani de tanahuatil de Moisés quilijque Jesús ijcuín: ―Tamachtijque, ticnequij xitechonnextili se tequit tenica ticmatisque cox melau tihuala de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Huan ijcón Jesús tananquilij ijcuín: ―Namejuan nanyolchichicque huan nanyolcuecuepme de namotamachilis porín nanquinequij ma nicchihua se tequit tenica huelis nanquitasque cox melau nihuitza de Dios. Huan amo huelis oc ma namechnextili se nexcuitil porín Dios techmacac ya ne nexcuitil de huejcautanahuatijque in Jonás. ");
INSERT INTO azzNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Huan in nexcuitil de Jonás yej nijín: Ijcón queme nijín Jonás yetoya ipoxijtic den ne hueyi pescado huan quichihuac eyi tonal huan eyi yohual, no ijcón xicmatican que Nejuatzin no ni Yectagatzin niyetotiu ne taltampa eyi tonal huan eyi yohual satepan de ne cuac nechmictisque ya. ");
INSERT INTO azzNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Huan in tagayot ten calyetoyaj tech ne pueblo Nínive moajocuisque cuac ejcos ne tonal de hueyi tatzacuiltilis huan namechtelchihuasque porín ne pueblojuani de Nínive moyolnemilijque huan moyolpatacque cuac yajqui in tanahuatijque Jonás quinnojnotzato ica in Tajtoltzin de Dios. Huan namejuan amo nanmoyolnemilijque de namotajtacoluan huan amo no nanmoyolpatacque, huan nican niyetoc Nitaquehual de Dios huan cachi nihueyi nichiuque huan que ne Jonás. ");
INSERT INTO azzNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Huan in sihuat yejua tayecanque den talme de sur ten monotza Seba, yejua ne moajocuis cuac ejcos ne tonal de hueyi tatzacuiltilis huan namechtelchihuas. Porín ne sihuat tayecanque huala tech ne talme den sur semi huejca, huan caquico ne tamachilis cualtzin de rey Salomón. Huan namejuan amo nannechcaquilijque notamachtilis huan Nejuatzin nican niyetoc huan cachi hueyi notamachtilis huan que ne rey Salomón. ");
INSERT INTO azzNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Huan no Jesús quinilij in tacaquini ijcuín: ―Huan cuac se amocuali ejecat quisac ya tech iyolijtic de se tagat, ijcuacón ne ejecat nemi nohuiyan campa tayiucan huan quitemojtinemi can huelis mosehuis itech iyolijtic de ocsé tagat huan yejua amo cajsis. ");
INSERT INTO azzNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Huan monemilía in amocuali ejecat huan quijtoa ijcuín: “Cachi cuali nimocuepas ocsepa campa nihualehuac”. Huan cuac mocuepa ya campa hualquisac, ijcuacón quinamiqui in tagat yoliuqui huan tachipahuiyan huan tachijchiutoc, pero amo yolpexontoc ica in Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Huan ijcón in amocuali ejecat yohui huan quinuica ocsé chicome amocuali ejecame ten cachi pitzoticque, huan nochi calaquitij huan mocaltalitij itech ne tagat iyolijtic. Ijcuacón ne tagat mocahuas cachi yolpitzotic huan que ne achtopa catca. Huan no ijcón quipanosque in talticpacuani ten axcan nemij, ten amo yec yolcualime. ");
INSERT INTO azzNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Huan cuac in Jesús quinnojnotztoya oc in tagayot ne calijticpa, ijcuacón ne momento ejcocque ne calampa inantzin huan iicnihuan de Jesús huan yejuan quinequíaj quinojnotzasque. ");
INSERT INTO azzNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Huan senme den ne calan yetoya quinejmachtij Jesús huan quilij ijcuín: ―Xicaqui Tejuatzin, nepa caltenojpa yetocque monantzin huan mocnihuan; yejuan quinequij mitznojnotzasque. ");
INSERT INTO azzNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ijcuacón in Jesús quinanquilij ne tagat naquen cualcuilij in tajtol, huan Yejuatzin quijtoj ijcuín: ―¿Aconi nonantzin, huan aconi nocnihuan? ");
INSERT INTO azzNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ijcuacón in Jesús quinonnextilij imomachtijcahuan huan quinilij in tacaquini ijcuín: ―Xiquinitacan nepa yetocque nomomachtijcahuan, yejuan ya ne nonantzin huan nocnihuan. ");
INSERT INTO azzNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Porín namechilía que nochi naquen quitacamatij ijcón queme quimonequiltía Notajtzin Dios ten yetica eluiyactzinco, yejuan ya ne niquinpohuas queme nocniusihuat huan no yejuan ya ne nocniutagat huan no yejuan ya nonantzin. ");
INSERT INTO azzNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Huan cuac ne tonal Jesús quisac tech ne cali huan yajqui motalito tech se atenteno. ");
INSERT INTO azzNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huan ompa mosentilijque míac tagayot campa Jesús yetoya, huan Jesús calayic tech se barco de ne apanoloni huan ompa motalij tech in barco. Huan nochi in tagayot mocauque tech ne atenteno. ");
INSERT INTO azzNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Huan Jesús quinnextiliaya ica miác tataman nexcuitilme huan quiniliaya ijcuín: ―Xiquitacan, se tonal quisac se tagat para quitepehuas in tatoc de trigojtet. ");
INSERT INTO azzNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Huan cuac quitepehuac ya, ijcuacón mochihuac que cansaica huetzic in tatoc ojtenteno. Huan hualajque in tototzitzin den patantinemij ejecaixco huan quicuajcoj. ");
INSERT INTO azzNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Huan ocsecan cansaica huetzic in tatoc de trigo itech tepetatal campa amo oncaya míac tal. Huan in xinach nimantzin ijsiucaixuac porín amo tilahuac in tal quipiaya. ");
INSERT INTO azzNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Huan cuac panquisac ya in tonaltzin, ijcuacón machichinahuic. Huan queme amo quipiaya míac inaluayo, niman huayic. ");
INSERT INTO azzNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Huan ocsecan cansaica huetzic in tatoc de trigo huitztzalan; huan in huitzti ixuac itzalan in tatoc huan quipachoj in tatoc. ");
INSERT INTO azzNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Huan ocsecan cansaica huetzic in tatoc de trigo itech cualital huan ompa quitemacac míac taquilome. Huan sequin de nijín tatoc de trigo motaquiltij ocsé macuilpoal taquilome. Huan sequin tatoc motaquiltij ocsé eyipoal taquilome; huan sequin tatoc motaquiltij sempoal huan májtacti taquilome. ");
INSERT INTO azzNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Huan de ompa Jesús quinilij ijcuín: ―Naquen quipía ninacas para tacaquis, ma yec tacaqui huan cajsicamati nijín tanextililis. ");
INSERT INTO azzNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Huan ijcón imomachtijcahuan motoquijque campa Jesús yetoya huan quitajtoltijque ijcuín: ―¿Queyé tiquinnojnotza in tagayot ica in nexcuitilme san? ");
INSERT INTO azzNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ijcuacón in Jesús quinnanquilij ijcuín: ―Dios namechmatiltijtoc ya namejuan nannomomachtijcahuan de ne ichtacatamachilisme de queniu Dios quinyolyecana itaneltocacahuan ica ichicahualis. Pero in ocsequin tagayot ten amo pohuij ihuan Dios, yejuan nojonques Dios amo quinajsicamatiltis. ");
INSERT INTO azzNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Huan nochi ne naquen quipíaj tamachilisme de Dios huan quitequitiltijtoc, yejua ne cachi oc Dios quinmajxitilis. Pero nochi ne naquen quipías tzictzin san tamachilisme de Dios, yejua ne majyá amo teyi quipiasquía porín amo quitequiltíaj in tepitzin san ten quipíaj, huan Dios quintamicuilis ne ten tepitzin san. ");
INSERT INTO azzNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ica ya nojón niquinnojnotza ica nextilme para ma in tagayot ma quitacan notanextililis. Pero como amo yec taneltocaj, ijcuacón yejuan mocahuasque majyá amo queman quitacque. Huan no namechnojnotztoc ica nexcuitilme para ma in tagayot ma quicaquican notajtoluan. Pero como amo no yec taneltocaj, ijcuacón yejuan nojonques mocahuasque majyá amo queman quitacque nión cajsicamatque. ");
INSERT INTO azzNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Huan ijcón mochihuac ten quijcuilojca ya in tanahuatijque Isaías cuac quijtojca ijcuín: Huan namejuan cuali nanquicactocque ya, pero amo no nanmomacasque cuenta. ");
INSERT INTO azzNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Porín namejuan nanpueblojuani semi nanyolpipicticque de namotamachilis porín nanquitahuelicaquij. Huan nanmoixtzactocque, para ma amo xiquitacan namotajtacoluan, Huan para ma amo xiyectacaquican ica namonacasuan, Huan para ma amo xicyecajsicamatican itech namoyolojuan. Huan amo no nanquiyolnemilisque que ximocuepacan de namotajtacoluan, para ma Dios namechyolpajti den namotajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Huan Jesús no quinilij imomachtijcahuan ijcuín: ―Tatiochihualme namoixtololohuan porín nanquitztocque ya namotajtacoluan; huan tatiochihualme namonacasuan porín nanquiyeccaquij in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Huan de yec melau ten namechilía que miacque tanahuatiani de Dios huan miacque tagayot yolcualime quinequíaj quitasque ten namejuan nanquitztocque axcan, pero yejuan amo quitacque. Huan míac tanahuatiani de Dios huan tagayot ten yolcualime quinequíaj quicaquisque ten namejuan nanquicaquij axcan huan yejuan amo quicacque. ");
INSERT INTO azzNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Huan in Jesús quinajsicamatiltij imomachtijcahuan ijcuín: ―Xicaquican nijín nexcuitil de se tagat tatepeuque ica trigojtet. Huan ne trigojtet quinejnehuilía in Tajtoltzin de Dios de que Yejuatzin quimonequiltía quinyolyecanas itaneltocacahuan ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Huan cuac se in tacaquini quicaquij ne Tajtoltzin de Dios huan amo cajsicamatij, ijcuacón huitza in amocuali Satanás huan quincuilía in Tajtoltzin de Dios ten toctoc ya tech ninyolijtic. In trigojtet tamoyautoc ya huan huetzi ojtennacastan. ");
INSERT INTO azzNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Huan in trigo tatoc ten huetzi itech tejteixco, yejua ne quinejnehuilía ne tacaquini naquen quicaquij in Tajtoltzin de Dios huan quiselíaj ica míac paquilis. ");
INSERT INTO azzNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero nijín tacaquini amo quipíaj se yec tacuautamatilis tech ninyoltijtic, queme se naluat para quichicahualtis in tatoc. Ica ya nojón amo huejcahuas nintacuautamatilis. Huan no ijcón nijín tacaquini, cuac nintech huitza in tajyohuilis huan tahuijuicaltilis porín quineltocaj notajtoltzin, yejuan nojónques niman moyolxocolíaj huan moyolcuejcuepaj nintaneltocalis. ");
INSERT INTO azzNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Huan in trigo tatoc ten huetzic huitztzalan, yejua ne quinejnehuilía ne tacaquini ten quicaquij in Tajtoltzin de Dios, pero moyolcuejmoloaj ica tenesi san ten nican talticpac. Huan no quinyoltilana oc in ricojyot. Huan nochi nijín quitajtamía in Tajtoltzin de Dios. Huan ijcón in ricojyot amo quicahua ma moscalti in Tajtoltzin de Dios para ma cuica taquilot. ");
INSERT INTO azzNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Huan in trigo tatoc ten huetzic tech cualital, yejua ne quinejnehuilía in tacaquini ten quicaquij in Tajtoltzin de Dios huan cajsicamatij. Huan ne tacaquini mochihuaj ijcón queme in tatoc ten quitemaca míac taquilot. Sequin tatoc motaquiltis ocsé macuilpoal taquilome; huan sequin motaquiltis ocsé eyipoal taquilome; huan sequin motaquiltis ocsé sempoal huan májtacti taquilome. Huan nochi nijín quinejnehuilía queme in taneltocani ten quitemacasque cuali taquilome. ");
INSERT INTO azzNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Huan ijcón Jesús quinnextilía imomachtijcahuan ica ocsé nexcuitil ijcuín: ―Nicnejnehuililtía se tagat ten quitocac in trigo xinach tech nimila queme ichicahualis de Dios cuac Yejuatzin quiyolyecana se iyolijtic ica ne chicahualis de ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Huan ne tagat patrón quitocato tech nimila. Huan cuac cochtocque ya in tequitini, ijcuacón huala huan calayic tech nimila se naquen quitahuelita ne patrón. Huan yejua quitocaco se xinach ten tacojcocoa campa ne trigo xinach ten no monejnehuilía queme in trigo. Huan quitocteu huan yajqui ocseco. ");
INSERT INTO azzNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Huan cuac in trigo moscaltij ya huan pehuac chicahuaya ya, ijcuacón monextij ya ne amocuali xihuit ten quinejnehuiliaya in trigo. ");
INSERT INTO azzNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ica ya nojón in tequitini yajque quilitoj in patrón ijcuín: “Xicaqui tejuatzin, ¿xe amo cualtiaya ne trigo xinach ten tejuatzin tictocac tech ne momila? ¿Huan can hualehuac ne xihuit ten quinejnehuilíaya in trigo?” ");
INSERT INTO azzNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ijcuacón in patrón tananquilij ijcuín: “Achá acsá naquen techtahuelita quichihuac ijcón”. Huan in tequitini ocsepa quitajtoltijque: “¿Xe ticnequis ma tiyacan ticuijuitatij ne xihuit ten quinejnehuilía in trigo?” ");
INSERT INTO azzNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Huan in patrón quinnanquilij ijcuín: “Amo xicuijuitacan ne xihuit ten tacojcocoa. Porín como nancuijuitasque ne xihuit ten amo cualtía, achá no nancuijuitasque in trigo. ");
INSERT INTO azzNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Cachi cuali ma xicahuacan ma moseniscaltican se huan ocsé hasta chicahuayas in trigo. Huan tech ne tonal cuac tachicahuayas ya ica in trigo, ijcuacón nejuatzin niquintitanis notequiticahuan para ma achto quihuijuitacan in amocuali xihuit ten quinejnehuilijtoc nijín trigo huan ma quinmanojtzitzicocan huan ma quichichinocan. Huan nimampan cajocuisque in trigo huan quiyequehuasque itech ne trigojcal”. ");
INSERT INTO azzNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Huan ijcón in Jesús ocsepa quinmachtiaya in momachtijcahuan ica ocsé nexcuitil huan pehuac quinejnehuililtía se cuouxinach ten monotza mostazajtet ihuan in chicahualis de Dios cuac Dios quiyolyecana se iyolijtic ica ne chicahualis de ne eluiyactzinco. Huan Jesús quinilij in tacaquini ijcuín: ―Huan se tagat quicuic in mostazajtet huan quitocac tech ne imila. ");
INSERT INTO azzNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Huan ne cuoumostazajtet yec melau yejua in cachi tzictzin de nochi nijín xinachme. Pero cuac moscaltis, ijcuacón mochihuas cachi hueyi huan que ocsequin xochitactzonme. Huan ne mostazajtet moscaltis huan mochihuas queme se hueyi cuohuit. Huan huitze in tototzitzin ten patantinemij ejecaixco huan ompa motapajsoltisque tech imatzacaluan. ");
INSERT INTO azzNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Huan ijcón in Jesús ocsepa quinnextilij in tacaquini ica ocsé nexcuitil: ―Nicnejnehuililtía in tamajmahualis ten quiposonaltía in pantixti queme cuac Dios quiyolyecana se iyolijtic ica ne chicahualis de ne eluiyactzinco. Huan se sihuat quicuic tamajmahualis huan quimaneloj ne tamajmahualis ihuan eyi tamachiu de harina. Huan ica nojón ne tamajmahualis quiposonaltía nochi in tixti de harina. ");
INSERT INTO azzNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Huan ijcón in Jesús quinnextiliaya in tagayot ica nexcuitilme. Porín como amo quicuía nexcuitilme, ijcón amo quinmachtiaya in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Huan melau ijcón mochihuac ten quijcuilojca ya in huejcautanahuatijque de Dios cuac quijtojca ijcuín: Niquinnextiliaya in tagayot ica nexcuitilme. Huan niquinajsicamatiltía tamachilisme ten ichtacapachiutoyaj desde cuac ne tzinpehuac in talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Huan ijcón in Jesús quinilij in tagayot ma yacan, huan Yejuatzin calayic calijtic. Ijcuacón imomachtijcahuan motoquijque campa Jesús yetoya huan quiluijque ijcuín: ―Xitechonajsicamatilti in nexcuitil de ne xihuit ten quinejnehuilía in trigo. ");
INSERT INTO azzNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Huan Jesús quinilij ijcuín: ―Nejuatzin ni Yectagatzin nitatoca ica nochi ten cuali xinach. ");
INSERT INTO azzNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Huan in milajtal tamati queme in talticpac. Huan ne ten cuali xinach quinejnehuilía in taneltocani neques ten tech ninyolijtic Dios quinyolyecana ica ichicahualis. Huan ne amocuali xinach quinejnehuilía in tagayot ten tepiluan den amocuali Satanás. ");
INSERT INTO azzNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Huan in amocuali Satanás, yejua ne nechtahuelita huan yejua mismo quitocac in amocuali xihuit. Huan cuac mochihuas ne tahuijuitalis de trigo, ijcuacón quinextía que ejcotoc ya in tamilis den talticpac. Huan in ángeles taquehualme de Dios quinuijuitatinemisque huan quinsesecotalijtinemisque in taca ten taneltocani huan in taca ten amo taneltocani, ijcón queme in trigo huan in xihuit ten amo cualtía. ");
INSERT INTO azzNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Huan ijcón in taquehualme de Dios quihuijuitasque in amocuali xihuit huan quicuisque huan quichichinosque ya, huan no ijcón quintatzacuiltisque ne naquen amo taneltocacque. Nochi nijín mochihuas cuac ejcos ya in tamilis den talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ijcuacón Nejuatzin ni Yectagatzin niquinualtitanis notaquehualuan in ángeles para quinololosque itech notequitilispan nochi de naquen sayó quintopeuque noconehuan ma motajtacolmacacan huan para no quinololosque nochi neques ten sayó quichiutinemij ten amo cuali. ");
INSERT INTO azzNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ijcuacón notaquehualuan quincuisque in tagayot ten amo taneltocacque huan quintamotasque tech ne ticonijtic campa chocatosque huan tannanatzocatosque huan tajyohuijtosque para sen nachipa. ");
INSERT INTO azzNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Huan naquen yolchipauque ten pohuij ihuan Dios, yejuan nojonques mopaquiltisque porín tech ninyolijtic Dios quinyolyecantoc ica ihueyichicahualis. Huan yejuan calaquisque campa ne cualtzin tacacahuacatoc ijcón queme in tonaltzin cuac tanextía. Huan nochi naquen quipíaj inacasuan para tacaquis, ma yec tacaquij huan cajsicamatij. ");
INSERT INTO azzNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Huan ijcón in Jesús quinnextiliaya imomachtijcahuan ica nijín nexcuitil ijcuín: ―Nicnejnehuililtía in tomin ten talpachiutoc ne mila queme ichicahualis de Dios cuac Yejuatzin quiyolyecana se iyolijtic ica ne chicahualis de ne eluiyactzinco. Huan se tagat moajxilía ne tomin ocseco huan quiquixtía huan ocsepa seco yejua quitalpachoti. Huan ijcón yejua moyolpaquita porín cajsic ya in tomin. Ijcuacón yohui quinamacati nochi ten niaxca huan quicohuati ne tal campa in tomin talpachiutoc. ");
INSERT INTO azzNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Huan Jesús ocsepa quinilij imomachtijcahuan ijcuín: ―Nicnejnehuililtía se tagat ten taojpacanamacacque queme ichicahualis de Dios cuac Yejuatzin quiyolyecantoc se iyolijtic ica ne chicahualis de ne eluiyactzinco. Huan yejua ne quitemojtinemi in perlas, in tetzitzin ten alaxtic huan den petanij de semi patío. ");
INSERT INTO azzNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Huan cuac cajsis se perla den cachi patío, yejua ne yohui huan quinamacati nochi ten niaxca. Huan de ompa quicohuati ne perla den cachi cualtzin. ");
INSERT INTO azzNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Huan Jesús quinilij imomachtijcahuan ocsepa se nexcuitil ijcuín: ―Nicnejnehuililtía ocsepa se tagat queme ichicahualis de Dios cuac Yejuatzin quiyolyecantoc se iyolijtic ica ne in chicahualis de ne eluiyactzinco. Ijcón yejua ne tagat catamota para quinquitzquis de míac tataman pescados. ");
INSERT INTO azzNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Huan cuac míac pescados moolochoa tech in matat, ijcuacón in tamaajsini quiquixtíaj in matat huan cuicaj ne atenteno. Huan ompa yohue motalitij huan quinpejpenaj in pescados huan quinyectalíaj ten cualtía tech in pescado chiquiehualoni. Huan quinatamotaj in pescados ten amo cualtíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Huan no ijcón mochihuas queman tamis ya in talticpac. Huan in taquehualme de Dios in ángeles quisasque para tequitisque huan quinsesecotalisque in tagayot den yolcualime huan ten amo yolcualime. ");
INSERT INTO azzNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Huan no in tagayot ten amo yolcualime quinticotamotasque campa chocatosque huan campa tannanatzocatosque campa ne tajyohuilis sen nachipa. ");
INSERT INTO azzNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Huan ijcón in Jesús quinnextilij huan quinmatajtoltij imomachtijcahuan ijcuín: ―¿Xe nancajsicamatij ya nochi nijín tanextililisme? Huan yejuan tananquilijque: ―Quema, Totecotzin, ticmatij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ijcuacón Jesús ocsepa quinyecajsicamatiltij ica nijín nexcuitil ijcuín: ―Sequin tanextiliani den tanahuatil de Moisés cajsicamatque ya nochi in tamachilisme de que Dios quimonequiltía quiyolyecana se iyolijtic ica ne chicahualis den ne eluiyactzinco. Huan Nejuatzin nicnejnehuililtía se de nojonques tanextiliani queme se tetat de se calyetoni. Huan nijín tetat quipía tech nichan se taehualoni campa quiehua niricojyo queme yesquía yejua in Tajtoltzin de Dios. Huan in tetat yohui quinquixtiti míac tamachilisme tech ne itaehualoni ten cualtzitzin yancuicque huan no den tamachilisme ten ipa achtopa ya yetoyaj. ");
INSERT INTO azzNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Huan mochihuac que cuac Jesús quintamiajsicamatiltij ya in tacaquini de nijín nexcuitilme, ijcuacón Yejuatzin yajqui ya para ipueblo de Nazaret. ");
INSERT INTO azzNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Huan cuac ajsic ichancopa, ijcuacón pehuac quinnextiliaya in tagayot tech in tiopan de judíos in Tajtoltzin de Dios. Huan in tagayot semi quimoucaitayaj huan quijtoayaj ijcuín: ―¿Can cajsic nijín tagat nochi nijín tamachlis? Porín melau semi quipía tamachilis. ¿Huan quenín hueli quichihua nijín mohuiscatequit de Dios? ");
INSERT INTO azzNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Huan no quijtojque ijcuín: ―¿Xe amo yejua nijín Jesús iconeu den cuouxixinque José? Huan in nantzin de Jesús, ¿xe amo yejua in María? Huan nicnihuan, ¿xe amo yejuan in Jacobo huan José huan Simón huan in Judas? ");
INSERT INTO azzNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Huan cox amo niicnihuan suame ten calyetocque tohuanme? Pues quema. Huan no quijtojque in tagayot ijcuín: ―¿Can momachtij nijín tagat nochi nijín tamachilisme ten hueli ya? ");
INSERT INTO azzNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Huan yejuan quimachiliayaj que moyolxocoliayaj ica por ne itamachtilis de Yejuatzin. Huan Jesús quinilij ijcuín: ―Huan nochi in tagayot quitasojtaj se tanahuatijque de Dios. Pero nipueblojcahuan huan nichancahuan de ne tanahuatijque de Dios, yejuan nojonques amo quitasojtaj ne tanahuatijque porín ompacayot. ");
INSERT INTO azzNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Huan Jesús amo quichihuac míac ne mohuiscatequit de Dios ompa pueblo de Nazaret porín in tagayot amo quineltocacque de nichicahualis de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Huan tech ne tonalme Herodes in tayecanque de Galilea quimatiltijque nichihualis de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Huan in Herodes quinilij itequiticahuan ijcuín: ―Yejua nijín Jesús yesqui Juan Taahuijque huan Dios quiajocuic yoltoc intzalan in ánimajme. Ica ya nojón ne Juan quipía nijín chicahualis ten Dios quimactij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Huan in rey Herodes quitanahuatilijca ma quitzacuacan in Juan huan ma quimaicantzicocan ca cadenas huan ma quicárceltalican. Huan melau in Herodes quichihuac ijcón porín yejua in Herodes cuilijca ya icuñada ten monotza Herodías, yejua isihuau in Felipe, huan in Felipe yejua iicniu in Herodes. ");
INSERT INTO azzNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Huan Juan Taahuijque quilijca ya in Herodes ijcuín: ―Dios amo quimonequiltía que xicpohua queme mosihuau den ne isihuatzin mocniu. ");
INSERT INTO azzNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ica ya nojón in Herodes quinequía quimictis in Juan. Pero amo quichihuac, porín quinyolmohuiliaya in pueblojuani judíos. Huan yejuan ihuan motasojtayaj in Juan porín yejua tajtoaya itencopa Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Huan se tonal cuac xiumajsic in rey Herodes, ijcuacón ne isuatacpaconeu pehuac mijtotía ninixpan in Herodes huan in ocsequi hueyi chihuanime. Huan itacpaconeu yejua isihuapil de Herodías, huan semi quiyolpactij nijín Herodes de ne imijtotilis. ");
INSERT INTO azzNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ica ya nojón in rey Herodes moyectencahuac ihuan isuatacpaconeu huan quitenehuac ijcuín: ―Yec melau quitztoc Dios, que nimitzmacas nochi ten tinechtajtanilis. ");
INSERT INTO azzNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Huan in isuatacpaconeu ipa achtopa ya moichtacanojnotzac ya ihuan inan. Ica ya nojón isuatacpaconeu quilij in rey Herodes ijcuín: ―Nechmaca itech se plato itzontecon ne Juan Taahuijque. ");
INSERT INTO azzNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Huan queman quicayic ya nijín, ijcuacón in rey Herodes pehuac moyolcocoa porín quijtojca ya ijcuín: ―Yec melau quitztoc Dios, nochi ten ticnequis nimitzmacas. Huan no moyolcocoj in Herodes porín yetoya ompa quicactoyaj nochi in tayecanani de Galilea den tacuajtoyaj ihuan. Ica ya nojón in Herodes tatitanic ma quitequilican itzontecon ne Juan Taahuijque huan ma quimacacan isuatacpaconeu. ");
INSERT INTO azzNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ijcuacón quinchicaucanahuatij ma quiquechtequican in Juan tech ne cárcel. ");
INSERT INTO azzNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Huan niman cualcuilijque itzontecon de Juan ipan se caxajpas huan quimactijque in isuatacpaconeu. Huan in tacpaconeu quimactilij inanajtzin Herodías. ");
INSERT INTO azzNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Huan ijcón imomachtijcahuan de Juan hualajque huan cuiyacque inacayo de Juan huan quitalpachotoj. Huan cachi satepan yajque quimatiltitoj in Jesús quenín in Juan quimictijque ya. ");
INSERT INTO azzNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Huan cuac Jesús quimatic ya que quimictijque ya in Juan Taahuijque, ijcuacón quistehuac Yejuatzin iselti huan calayic itech se barco huan yajqui ocsecan campa tayiucan. Huan cuac in tagayot quimatque ya can yetoya Jesús, ijcuacón yejuan quisque de ninpueblojuan huan yajque metznejnenque atentenojcopaca quitoctilijque in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Huan cuac quisac Jesús de ne barco, ijcuacón Yejuatzin quinitac huel míac tagayot huan quinyolicnelij huan quinpajtij in cocoyani ten cualcuiliayaj Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huan queman tapoyautiaya ya, ijcuacón imomachtijcahuan motoquijque campa Yejuatzin huan quilijque ijcuín: ―Amo aquen calyetoc nican huan semi tayohuati ya. Xiquinili nijín tagayot ma yacan ya ne caltempan huan ma quicohuatij ten quicuasque. ");
INSERT INTO azzNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ijcuacón Jesús quinnanquilij imomachtijcahuan ijcuín: ―Amo monequía ma xiyacan. Ta, namejuan san huelis xiquinmacacan ten quicuasque in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Pero imomachtijcahuan tananquilijque ijcuín: ―Amo teyi ticpíaj nican in tacualis. Ta, sayó ticpíaj macuil panes huan no ome pescadojtzitzin. ");
INSERT INTO azzNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ijcuacón in Jesús ocsepa quinilij ijcuín: ―Xinechinualcuilican ne tacualis nican. ");
INSERT INTO azzNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Huan de ompa Jesús quinnahuatij in tagayot ma motecacan ixtahuat panían. Huan niman in Jesús quicuic in macuil pantzitzin huan in ome pescadojtzitzin. Huan mochihuac que cuac Jesús maactoya ya in tacualis, ijcuacón ajcotachíac huan quitatautij Dios ma quitiochihua in tacualis. Huan de ompa Jesús quixejxeloj in panes huan quinmacac imomachtijcahuan huan ijcón yejuan quinmajmacatoj in panes in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Huan tacuajque nochi in tagayot huan ixuicque. Huan imomachtijcahuan quinsentilijque nochi pan ten tatetejtec ten mocahuac huan quipexontijque majtactiomome chiquihuit oc. ");
INSERT INTO azzNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Huan ne naquen tacuajque catca queme macuil mil tagayot huan amo tapoucayome in sihuame nión in coneme. ");
INSERT INTO azzNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Huan de ompa Jesús quinnahuatij imomachtijcahuan ma calaquican tech in barco ma yajtocan ne sentapalpa de ne ocseco atenteno, huan ma quiachtohuican Jesús mientras Yejuatzin quinnajnahuatiaya in tagayot para ma yacan ninchan. ");
INSERT INTO azzNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Huan cachi satepan cuac quinnajnahuatij ya in tagayot ma yacan, ijcuacón Jesús tejcoc campa se tal lomojtzin huan ompa iselti motatatautilito ihuan Dios. Huan ne cuac tapoyahuic ya, ijcuacón Jesús ompa yetoya ya iselti oc. ");
INSERT INTO azzNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Huan queman yaya ya in barco ne tatajco ya den mar den quihuicaya imomachtijcahuan, ijcuacón pehuac mocuecuenteca in mar huan quimajmagaya in barco porín ne ejecat quitzatzacuiliaya. ");
INSERT INTO azzNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Huan cuac tanestihualaya ya, ijcuacón motoquijtihualaya Jesús campa imomachtijcahuan huan ijcón in Jesús nejnentihualaya aixco. ");
INSERT INTO azzNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Huan cuac imomachtijcahuan quitacque Jesús nejnentihualaya aixco, ijcuacón peuque moyolmoutiayaj huan moucatzajtzíaj huan quijtojque ijcuín: ―¿Toni nojón? ¡Yesqui se ánima! ");
INSERT INTO azzNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ijcuacón niman in Jesús quinnotzac huan quintzajtzilij huan quinilij ijcuín: ―Ximoyolchicahuacan porín Nejuatzin ya ni Jesús, amo ximomoutican. ");
INSERT INTO azzNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Huan ijcón in Pedro quilij ijcuín: ―Totecotzin, como melau Tejuatzin, xicchihua que ma no nihueli ninejnemi aixco para nimitzajsitiu campa tionualajtoc. ");
INSERT INTO azzNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Huan Jesús quilij: ―Xihuiqui pos. Huan ijcón in Pedro pantemoc den barco huan pehuac nejnemi aixco para cajsitiu campa Jesús hualaya. ");
INSERT INTO azzNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Huan cuac moyolnemilij in Pedro quenín chicaucaejecaya, ijcuacón pehuac momoutía huan pehuac pancalactiu ya tech in at. Huan de ompa quitzajtzilij Jesús ijcuín: ―Notecotzin, xinechpalehui huan xinechmaquixti. ");
INSERT INTO azzNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ijcuacón nimantzin momatilanac Jesús huan quimaquitzquij in Pedro huan quilij ijcuín: ―Tejua tagatzin, semi tepitzin san ticpía motacuautamatilis. ¿Queyé amo tiyectacuautamatij nohuan? ");
INSERT INTO azzNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Huan queman nochi in omen tejcocque ya huan calacque ya tech in in barco, ijcuacón motatamatilij ica in ejecat. ");
INSERT INTO azzNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Huan ijcón nochi ten yayaj tech in barco motancuaquetzacoj iixpan Jesús huan quimohuistilijque ijcuín: ―Yec melau Tejuatzin tion Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Huan cuac quipanahuijque ya in mar, ijcuacón Jesús huan imomachtijcahuan ajsitoj tech in tal ten pohuía Genesaret. ");
INSERT INTO azzNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Huan cuac quixmatque ya in tagayot que Jesús yetoya ompa ya, ijcuacón quitematiltijque nohuiyampa nochi in tagayot ten quiyehualojtoyaj Genesaret. Huan cualcuiliayaj míac cocoyani campa Yejuatzin ten mococoayaj ica míac tataman cocolis. ");
INSERT INTO azzNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Huan quitatautiayaj Jesús ma quincahua ma quimatocacan itilmajteno san. Huan nochin naquen quimatocacque Jesús, nochi pajtijque ya. ");
INSERT INTO azzNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Huan hualajque de Jerusalén huan motoquijque campa yetoya Jesús sequin fariseos huan sequi tanextiliani den tanahuatil de Moisés huan quitajtoltijque Jesús ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","―¿Queyé momomachtijcahuan amo quitacamatij in tanahuatilme ten quitenextilíaj in huehuentzitzin den pueblojuani judíos? Porín momomachtijcahuan amo quitacamatij in tanahuatilis de que ma achtopa momajtequican huan tacuasque. ");
INSERT INTO azzNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Huan Jesús quintajtoltij ne tayecanani ijcuín: ―¿Queyé namejuan amo no nanquitacamatij in tanahuatilme de Dios? Ta, sayó nanquitacamatij in tanahuatil den huehuentzitzin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Huan in Tajtoltzin de Dios technahuatilía ijcuín: “Xicmohuistili motajtzin huan monantzin; porín naquen quitelchihuas itajtzin oso inantzin, yejua nojón monequi ma quimictican”. ");
INSERT INTO azzNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Pero namejuan nantanahuatíaj que huelis se tagat ma quilij nitajtzin oso ninantzin ijcuín: “Amo nihuelis namechpalehuis porín nochi ten nicpía nicaxcatilij ya Dios”. ");
INSERT INTO azzNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Huan nochi naquen nesi tagat ten ijcón quichihuas, yejua nojón amo monequi oc quinpalehuis nitajtzin huan ninantzin. Huan ijcón namejuan nanquisecocautocque ya in tanahuatilme de Dios huan nanquitacamatinemij sayó ten namechnextilíaj in huehuentzizin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Namejuan nanixquequeptocque san de namotamachilis, ijcón queme Isaías ne huejcautanahuatijque de Dios quijcuiloj de namejuan cuac quijtojca itencopa Totajtzin Dios ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nochi nijín tagayot judíos nechmohuistilíaj sayó ica nintenxipal san; huan ninyolojuan huejca yetoc de Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Huan nenca san nechmohuistilíaj, porín yejuan tenextilíaj in tamachtilis den taca san huan quipohuaj nijín tamachtilis queme yesquía in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Huan ijcón in Jesús quinnotzac in tagayot huan quinilij ijcuín: ―Xicaquican huan xicajsicamatican ten namechilía: ");
INSERT INTO azzNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Huan nochi ten quicuas in tagat ica iten, yejua nojón amo huelis quimajmahuas niyolo ica tajtacol. Ta, yejua itanemililis ten quisa iyolijtic in tagat, yejua ne quimajmahua ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ijcuacón imomachtijcahuan motoquijque campa yetoya Jesús huan quilijque ijcuín: ―¿Xe amo ticmati que ne fariseos quicualancacacque ten ticonijtoj? ");
INSERT INTO azzNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Huan Jesús quinilij ijcuín: ―Nochi tatocme ten amo itatoc Notajtzin den ne eluiyactzinco, yejua ne Notajtzin cuijuitas nochi ica inaluayo. ");
INSERT INTO azzNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Huan ijcón in Jesús ocsepa quinilij ijcuín: ―Xiquincahuacan nojón fariseos, porín yejuan ixpojpoyome. Huan no quinequij quiyecanasque in ocsequin ixpojpoyome. Huan como se ixpojpoyot quinequi quiyecanas ocsé ixpojpoyot, ijcuacón in omen sen huetzitihue tech in talcomit. ");
INSERT INTO azzNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ijcuacón in Pedro quilij Jesús ijcuín: ―Xitechyecajsicamatilti nijín nexcuitil. ");
INSERT INTO azzNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Huan Jesús tananquilij ijcuín: ―¿Xe namejuan amo no nancajsicamatij nijín nexcuitil? ");
INSERT INTO azzNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Xe namejuan amo no nancajsicamatque que nochi in tacualis ten se quicua, yejua ne pantemoa san tech se ipox san huan de ompa quisa de tonacayo? ");
INSERT INTO azzNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Pero nochi in tajtolis ten quisa tech se iten, yejua ne hualehua tech se iyolo. Huan yejua nojón quimajmahua in tagat ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Porín itech iyolo in tagat hualeutoc ne pitzotic tanemililis, ne temictilis, ne tesuacuililis, oso ne tagacuililis, ne tasuapapatalis oso ne tagapapatalis, ne tachtequilis, oso ne tacajcayahualis huan ne tahuijuicaltilis. ");
INSERT INTO azzNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Huan nochi nijín tanemililis quimajmahuaj ica tajtacol in tagat. Huan in tagat amo momajmahuas ica tajtacol cuac quicuas tensá tacualis, masqui amo momajtequía. ");
INSERT INTO azzNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Huan de ompa quisac Jesús huan yajqui tech ne lugar campa pueblojme den monotza Tiro huan Sidón. ");
INSERT INTO azzNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Huan ompa se sihuatzin calyetoya ne Cananea sentapal cayot de Tiro huan Sidón. Huan ne sihuatzin tzajtzitihualaya campa Jesús huan quiliaya ijcuín: ―Totecotzin, Tejuatzin tion Teconetzin de ne huejcau rey David. Nimitzilía, xinechonyolicneli porín nochpoch quipía iyolijtic se amocuali ejecat huan tel senca ya tajyohuijtoc axcan. ");
INSERT INTO azzNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Pero Jesús amo teyica quinanquilij. Ijcuacón imomachtijcahuan motoquijque huan quitatatautilijque Jesús ijcuín: ―Xicnahuati ma yohui ya nijín sihuat porín ijcón tzajtzitihuitz huan techualtoctilía. ");
INSERT INTO azzNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Huan Jesús quinnanquilij ijcuín: ―Notajtzin Dios nechualtitanic sayó para ma niquinpalehui huan ma niquinmaquixti in pueblojuan queme ichcame ten poliutocque, yejuan ten pohuij ihuan in pueblojuani de Israel. ");
INSERT INTO azzNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Huan motoquij in sihuat huan quilij ijcuín: ―Totecotzin, xinechonpalehui. ");
INSERT INTO azzNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Huan Jesús quinanquilij ijcuín: ―Amo cualtía ma niquincuili in tacualis den coneme judíos huan ma niquinmaca in itzcuintzitzin porín xicmati que namejuan amo nanjudíos. ");
INSERT INTO azzNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Huan tananquilij in sihuat ijcuín: ―Quema catzin, masqui tejuan queme yesquía itzcuintzitzin, pero timotaololohuilíaj mesajtampa huan ticuaj nochi den tepehui, yejua ne in Tajtoltzin de Dios den quitencajcahuaj in patrones judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Huan ijcón in Jesús tananquilij ijcuín: ―Tejua sihuat, semi hueyi motacuautamatilis; huan axcan ma mochihua ijcón queme tejua ticnequi. Huan ijcón ne isihuapil nimantzin pajtic. ");
INSERT INTO azzNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Huan ijcón in Jesús quisac de ne lugar de Tiro huan Sidón huan yajqui atenteno san den hueyíat de Galilea. Huan niman tejco itech se hueyi tal lomojtzin huan ompa motocotzoj. ");
INSERT INTO azzNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Huan hualajque huel míac tagayot campa Jesús yetoya huan cualcuiliayaj míac tataman cocoayani ten amo huel moquetzaj ya, huan ten ixpojpoyome, huan ten amo huel tajtoayaj, huan ten macotoltijque, huan míac ocsequin ten mococoayaj. Huan quintalicoj iixpan Jesús huan Yejuatzin quinpajtij. ");
INSERT INTO azzNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ijcuacón in tagayot semi quitelmoucaitacque porín yejuan quitacque que in nontzitzin tajtoayaj ya, huan in macotoltijque motayaj que pajtijque ya, huan in coxojme huelíaj nejnemij, huan in ixpojpoyome huelíaj tachíaj ya. Ijcuacón nochi in tagayot peuque quimohuistilíaj Totajtzin Dios in Tayecanque de Israel. ");
INSERT INTO azzNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Huan Jesús quinnotzac imomachtijcahuan huan quinilij ijcuín: ―Niquinyolicnelía de nijín tagayot porín quichihuac ya eyi tonal nohuan yetocque, huan amo quipíaj toni cuasque. Huan amo nicnequi niquintitanis ninchan ma mayantiyacan. Porín como ijcón niquintitani, ijcuacón mayancacuetahuitihue tech in ojti. ");
INSERT INTO azzNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ijcuacón imomachtijcahuan quiluijque Jesús ijcuín: ―¿Quenín huelis ticajsisque tel míac tacualis para tiquintamacasque tel míac tagayot? Porín nican semi tayiucan huan amo aca calyetoc. ");
INSERT INTO azzNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Pero Jesús quintajtoltij ijcuín: ―¿Canachi panes nanquipíaj? Huan yejuan quinanquilijque: ―Ticpíaj chicome panes san, huan no sequin pescadojnacatzitzin. ");
INSERT INTO azzNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Huan de ompa Jesús quinnajnahuatij in tagayot ma motalican talpan. ");
INSERT INTO azzNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Huan ijcón in Jesús quicuic nojón panes ihuan in pescadojnacat huan de ompa quitasojcamachilij Totajtzin Dios. Huan quincojcotonac in panes huan quinmajmacac imomachtijcahuan. Huan yejuan quinxejxelohuilijque in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Huan ijcón nochi in tagayot tacuajque huan ixuicque. Huan niman imomachtijcahuan de Jesús quiololojque nochi in pan cojcotol ten mocahuac huan quinpexontijque chicome chiquihuime oc. ");
INSERT INTO azzNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Huan naquen tacuajque catca queme nahui mil tagayot huan amo quinpouque in sihuame nión in coneme. ");
INSERT INTO azzNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Huan de ompa Jesús quinilij in tagayot ma yacan ninchan huan no niman Yejuatzin calaquic tech in barco huan ajsito campa pueblojcopaca de Magdala. ");
INSERT INTO azzNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Huan ijcón in fariseos huan in saduceos hualajque campa Jesús yetoya huan peuque ihuan motajtoltehuíaj porín yejuan quinequíaj quitepotamisque Jesús tech tajtacol. Huan quitajtaniliayaj Jesús ma quinnextiliani se mohuiscanexcuitil den ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Huan Jesús quinnanquilij ijcuín: ―Huan cuac ne tayohuatía, ijcuacón namejuan nanquijtoaj que cualtzin tonas mosta porín nanquitaj cualtzin tachichileutoc nohuiyan desde ne ipolihuiyampa in tonal. ");
INSERT INTO azzNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Huan cuac ne cualcampan, ijcuacón namejuan no nanquijtoaj que axcan amo tonas porín tamixtentoc. Huan nanixquequepme san de namotamachilis porín cuali nanquiajsicamatiltíaj quenín in tonal yesqui mosta, cox tonas oso amo, pero amo hueli nanquiajsicamatiltíaj in nexcuitilme de toni mochihuas axcan. ");
INSERT INTO azzNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nijín tagayot amo yolcualime huan nión no tacuautamatij ihuan Dios, huan tajtanij se nexcuitil de que cox melau Nejuatzin ni Teconetzin de Dios. Pero amo huelis se quinnextilis cachi oc ocséquin mohuiscanexcuitilme. Ta, sayó ne nexcuitil ten namechnextilijca ya ne huejcautanahuatijque Jonás. In nexcuitil de Jonás yejua nijín: Ijcón queme Jonás mocahuato ipoxijtic ne hueyi pescado huan ipan eyi tonal panquisac yoltoc, no ijcón Nejuatzin nimocahuatiu ne taltampa huan ipan eyi tonal nipanquisas niyoltoc. Huan de ompa Jesús quincauteu in fariseos huan yajqui ocseco. ");
INSERT INTO azzNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Huan imomachtijcahuan ajsicque sentapalpa den hueyíat mar. Pero mochihuac que yejuan quelcauque de cuicasque in tacualis de yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ica ya nojón Jesús quinilij imomachtijcahuan ijcuín: ―Xiquitacan huan ximoyecpiacan de ne tamajmahualis de tamachilis ten quipíaj ne fariseos huan ne saduceos. ");
INSERT INTO azzNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ijcuacón imomachtijcahuan monojnotzayaj se huan ocsé ijcuín: ―¿Queyé ijcón techilía Jesús? Achá porín amo ticualicque ten ticuasque. ");
INSERT INTO azzNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Pero Jesús niman quinyolojixmatic ne imomachtijcahuan huan quinilij ijcuín: ―¿Queyé nanquijtoaj que amo nanquipíaj ten nancuasque? Mota que namejuan amo nanyectacuautamatij nohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Huan namejuan amo nancajsicamatque huan nión no nanquelnamiquij de ne macuil panes ten nicxejxeloj ihuan ne macuil mil tagayot. Huan amo no nanquelnamiquij canachi chiquihuime de pan den mocahuac de que nanquiololojque. ");
INSERT INTO azzNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Huan amo no nanquelnamiquij de ne chicome pantzitzin ten niquinxejxelohuij de ne nahui mil tagayot. Huan amo no nanquelnamiquij canachi chiquihuime de pan ten mocahuac de que nanquiololojque itech ne tonal. ");
INSERT INTO azzNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Queyé amo nancajsicamatque de nijín tamachilis tenica namechnojnotztoc de ne tamajmahualis ten quipía in pan den tacualis? Ta, nicnequi que namejuan xicyecajsicamatican ne tamajmahualis de tajtacol ten quipía in tanextililis ne fariseos huan ne saduceos. ");
INSERT INTO azzNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Huan ijcón imomachtijcahuan cajsicamatque ya que Jesús amo quinilíaj ya que ma moyecpiani den ne tacualis den tamajmahualis de pan san. Ta, Jesús quinilíaj ya que ma moyecpiacan de ne nintamachtilis den fariseos huan in saduceos. Porín nintamachtilis teyolmajmahua ica tajtacol ijcón queme in tamajmahualis den quiposonaltía in pan. ");
INSERT INTO azzNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Huan ijcón in Jesús quisque ihuan imomachtijcahuan huan ajsicque tech in pueblojme ten pohuíaj Cesarea de Filipo. Huan Jesús quintajtoltij imomachtijcahuan ijcuín: ―¿Quenín quijtoaj in tagayot? ¿Aconi yesqui Nejuatzin ni Yectagatzin? ");
INSERT INTO azzNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Huan yejuan tananquilijque ijcuín: ―Sequin tagayot quijtoayaj que Tejuatzin ti Juan Taahuijque. Huan ocsequin quijtoayaj que Tejuatzin ti Elías ne huejcautanahuatijque de Dios. Pero cachi ocsequin quinemiliayaj que achá Tejuatzin ti Jeremías, oso achá Tejuatzin se den ocsequin tanahuatiani de Dios den nemicoj ya. ");
INSERT INTO azzNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Huan ijcón in Jesús ocsepa quintajtoltij ijcuín: ―Huan namejuan, ¿toni nanquixejecoaj que aconi Nejuatzin? ");
INSERT INTO azzNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ijcuacón Simón Pedro tananquilij ijcuín: ―Tejuatzin tion Cristo Temaquixtijcatzin, ti Yecteconetzin de Dios den yoltica. ");
INSERT INTO azzNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Huan Jesús quinanquilij: ―Titatiochihual, tejua Simón teconeu de Jonás. Porín amo se tagat huelic mitzajsicamatiltisquía de nijín ten melau. Ta, sayó Notajtzin ten yetica nepa eluiyactzinco, Yejuatzin mitzajsicamatiltij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Huan nimitzyequilía que tejua ti Pedro huan motocay quijtosnequi hueyi tet, huan mohueyitacuautamatilis tamati queme in hueyi teolol. Huan ipan nijín tacuautamatilis den tamati queme se teolol, itech nijín nictzinpehualtis notequiu. Huan niquinmaquixtis huan niquinmiactiltis notaneltocacahuan. Huan ijcón amo no huelis ne chicahualis den miquilis quinxijxicos notaneltocacahuan porín quipíasque ne yec tacuautamatilis nohuantzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Huan, tejua Simón, no nimitzmacas in chicahualis queme yesquía llaves para tiquintatapohuilis in tagayot ma calaquican campa Dios momasoutoc ica ihueyichicahualis. Huan ijcón nochi ten tejua titatacahualtis nican talticpac, no ijcón motatacahualtis ne eluiyactzinco. Huan nochi ten tejua ticahuas ma mochihua nican talticpac, no ijcón ma mochihua ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Huan ijcón in Jesús quinnajnahuatij imomachtijcahuan ma amo aquen quilican que cox yejua ya in Cristo in Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Huan desde ne tonal ya pehuac Jesús quinyectapohuía ya imomachtijcahuan ijcuín: ―Semi monequía niyás tech ne pueblo de Jerusalén. Huan ompa nechtajyohuiltisque in huehuentzitzin den pueblojuani judíos huan in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés. Huan no Jesús quinilij ijcuín: ―Ompa nechmictisque, pero ipan eyi tonal nipanquisas niyoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ijcuacón in Pedro cuiyac Jesús seco huan ompa pehuac quixajua huan quiliaya ijcuín: ―Ma amo Dios quimonequilti ma pano mopan nijín ten tiquijtoa. ");
INSERT INTO azzNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ijcuacón Jesús mocuepac campa yetoyaj imomachtijcahuan huan quilij in Pedro ijcuín: ―Ximijcuani de nican noixpan, Pedro, porín majyá titanemilijtoc queme Satanás in amocuali, huan tinechtzajtzacuilía san. Porín tejua amo titanemilía queme Dios quimonequiltía. Ta, sayó titanemilía queme in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Huan ijcón in Jesús quinilij imomachtijcahuan ijcuín: ―Tacán acsá quinequi nechtoctilijtiyás, ijcuacón ma quicautehua ne tanejnequilis de yejua san, huan ma quixicos in cruztzin ten cualcui tajyohuilis huan ijcón ma nechtacamatiu huan nechtoctilijtiu. ");
INSERT INTO azzNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Huan nochi neques ten quinequij moyecpialtisque huan quimaquixtisque yejuan san mismo ninnemilis, yejuan nojónques nochi quipolosque ninnemilis. Huan nochi neques ten quipolosque ninnemilis por nejua huan por in cuali Tajtoltzin de ne temaquixtilis, yejuan nojonques cajsisque ninnemilis huan no ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Pero toni quihueyipías in tagat como moaxcatilis nochi in senmanahuac huan niman quipolos inemilis? ¿Pero canachi taxtahuil huelis quitemacas oc in tagat ica por niyolo cuac yejua cajsicamatis que quipoloj ya ninemilis? ");
INSERT INTO azzNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Huan Nejuatzin ni Yectagatzin nihualas ica in huelilis de Notajtzin ihuan in ángeles ne tequitini de Notajtzin. Ijcuacón Notajtzin Dios quintaxtahuis cada se tagat ijcón queme cada se tagat motequitiltij. ");
INSERT INTO azzNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Huan no de yec melau ten namechilía que senme de namejuan de nican nanyetocque, amo nanmiquisque como amo achtopa nanquitasque que Nejuatzin nihualas ya ni Yectagatzin, huan niquinyecanas notaneltocacahuan ica nochi ichicahualis huan ihuelilis de Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Huan satepan de chicuasen tonal Jesús quinuiyac Pedro huan in Jacobo huan iicniu Juan huan yajque tejcotoj ninseltij seco tech se tepet campa huejcapan. ");
INSERT INTO azzNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Huan ompa ninixpan pehuac Jesús mopapataya quenín tamatic. Huan iixco nesía cualtzin petani ijcón queme in tonaltzin. Huan ne nitilmajtzin pehuac pepetacaya porín yec istac queme in tanex. ");
INSERT INTO azzNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Huan monextijque Elías ihuan in Moisés, yejuan nojonques huejcautanahuatiani de Dios, huan yejuan peuque monojnotzayaj ihuan in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ijcuacón in Pedro quilij in Jesús ijcuín: ―Totecotzin, semi cualtzin para tejuan que nican tiyetocque. Tajcón ticonmonequiltisquía ma ticchijchihuacan eyi xajcaltzitzin, se para Tejuatzin, in ocsé para in Moisés huan in ocsé para Elías. ");
INSERT INTO azzNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pero cuac in Pedro quinojnotztoya oc, ijcuacón quinquemiloco se mixti de semi cualtzin pepetaca. Huan mixtzalan mocaquic se tajtolis huan quijtoaya ijcuín: ―Yejuatzin nijín Notasojtzin Conetzin. Ica por Yejuatzin semi niyolpactoc; xicaquilican ca cuali Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Huan cuac quicacque ya nijín imomachtijcahuan, ijcuacón motapachojque hasta moixtalitoj tech in tal porín semi moyolmoutiayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Huan ijcón in Jesús motoquij campa imomachtijcahuan huan quinolinij huan quinilij ijcuín: ―Ximoquetzacan huan amo ximoyolmoutican. ");
INSERT INTO azzNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Huan cuac yejuan moixajacque huan ixnenenque, ijcuacón yejuan amo aquen quitacque oc. Ta, sayó in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Huan cuac temotiyayaj ya tech ne tepet, ijcuacón Jesús quinnajnahuatij ijcuín: ―Axcan amo aquen xictapohuican de nanquitacque. Ta, xicchiacan hasta ne tonal cuac Nejuatzin ni Yectagatzin nipanquisas ya niyoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Huan ijcón in Jesús imomachtijcahuan quitajtoltijque ijcuín: ―Nojón tanextiliani den tanahuatil de Moisés, ¿queyé yejuan quijtoaj que Elías quipía que hualas achtopa ya que hualas in Cristo Temaquixtijque? ");
INSERT INTO azzNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Pero Jesús quinnanquilij ijcuín: ―Yec melau, achtopa ya que Nejuatzin nihualasquía, hualajca ya ne Elías huan tayejyectalij ya nochi para Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Huan Nejuatzin namechyequilía que hualajca ya ne Elías, huan in tanextiliani amo quixmatque. Ta, quichihuilijque queme yejuan in tayecanani tanextiliani quinecque huan cuelitacque. Huan ijcón no nicpanos Nejuatzin ni Yectagatzin; nechchihuilisque queme yejuan cuelitasque. ");
INSERT INTO azzNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Huan ijcón in imomachtijcahuan den Jesús quiyecajsicamatiltiayaj ya que Jesús quinnojnotzaya de ne nemilis de Juan Taahuijque. Huan ne Juan yejua ya in Elías ten quipía de que hualasquía. ");
INSERT INTO azzNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Huan cuac Jesús huan imomachtijcahuan ajsicque campa yetoyaj míac tagayot, ijcuacón motoquij campa Jesús yetoya se tagat huan motancuaquetzac iixpan Jesús huan quilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","―Totecotzin, xiconyolicneli nooquichpil porín quimaca se cocolis de nijín yolpolihuilis huan semi tel hueyi tajyohuía. Porín miacpa ya huetzi huan moticotalía huan no miacpa ya moapisahuía ya. ");
INSERT INTO azzNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Huan niquinualcuilijca ya momomachtijcahuan huan amo huelic quipajtijque. ");
INSERT INTO azzNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ijcuacón in Jesús quinanquilij ijcuín: ―Namejuan sayó nantacaquini, semi amo nanyectaneltocaj huan amo nanyolcualime. ¿Canachi tonalme quipía de que niyetos oc namohuan? ¿Canachi tonalme oc huelis nitaxicos como amo nanyectacuautamatij nohuan? Xinechonualcuilican nican in oquichpil ten mococoa. ");
INSERT INTO azzNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Huan ijcón in Jesús quichicaucanahuatij in amocuali ejecat. Ijcuacón niman calanquisac in amocuali ejecat itech ne oquichpil den yetoya iyolijtic. Huan ijcón niman moyoltalij ne oquichpil. ");
INSERT INTO azzNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Huan ijcón niman motoquijque imomachtijcahuan campa Jesús huan quinojnotzque ocsecan huan quitajtoltijque ijcuín: ―¿Queyé amo tihuelque ticalanquixtilijque ne telpoch in amocuali ejecat? ");
INSERT INTO azzNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Huan Jesús quinilij ijcuín: ―Amo nanhuelque porín nanquipíaj semi tepitzin san namotacuautamatilis. Huan de yec melau ten namechilía que como nanquipiasquíaj namotacuautamatilis ma quinehuiliani tzictzin queme se mostazajtet, ijcón cuali huelis nanquilisque nijín tepelomo de que ma ximijcuani de nican huan xiyó ocsecan. Huan ijcón in tepelomo mijcuanisquía. Huan para namejuan amo teyi ongac ohui como melau nanyectacuautamatij nohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Huan nijín taman den amocuali ejecat ohui para se quicalanquixtis. Pero huelis se quicalanquixtis sayó ica ne tatatautilis ihuan Dios huan ica ne sahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Huan cuac Jesús sen nemía ihuan imomachtijcahuan tech ne pueblojcopaca de Galilea, ijcuacón Jesús quinilij ijcuín: ―Nejuatzin ya ni Yectagatzin huan nechtemactisque imaco in tagayot, ");
INSERT INTO azzNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","huan nechmictisque, huan ipan eyi tonal ocsepa nipanquisas niyoltoc itzalan in ánimajme. Huan cuac imomachtijcahuan quicacque nochi nijín, ijcuacón semi motayocoltijque. ");
INSERT INTO azzNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Huan Jesús ihuan imomachtijcahuan ajsicque tech ne pueblo Capernaum, huan in tanechicoani para in tiopan de judíos motoquijque campa in Pedro huan quilijque ijcuín: ―¿Xe amo taxtahuas namotamachtijcau de ne taxtahuil para in tiopan de judíos? ");
INSERT INTO azzNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ijcuacón in Pedro tananquilij ijcuín: ―Quema. Huan cuac in Pedro calaquito calijtic, ijcuacón in Jesús achto quinojnotzac huan quilij ijcuín: ―¿Toni tiquixejecoa, Simón? In huejueyi chihuanime de nican talticpac, ¿cox tatopaluijtinenque den nichancahuan oso den ninpueblojcahuan san? ");
INSERT INTO azzNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Ijcuacón in Pedro tananquilij ijcuín: ―Ne ten in pueblojcahuan quintopaluitinemij. Huan Jesús quilij ijcuín: ―Inchancahuan amo monequi ma motaxtahuilican. ");
INSERT INTO azzNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Pero para ma amo tiquinyolcuejmolocan in tayecanani, xiyó tech ne hueyíat den mar huan xicatamota ne teposmaxal tenica quinquitzquíaj in pescados. Huan ne ten achtopa pescado tiquitzquis, ompa ticaxilis iteno ne pescado se tomin ten cualtías ica titaxtahuasque in taxtahuil ten monequi para Nejuatzin huan para tejua. Huan cuac ticajsis ya, ijcuacón niman xiquinuiquili in tomin huan xiquintaxtahuiliti. ");
INSERT INTO azzNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Huan tech ne tonalme imomachtijcahuan motoquijque campa Jesús yetoya huan quitajtoltijque ijcuín: ―¿Aconi in cachi hueyi chiuque como Dios techyolyecana toyolijtic ica ihueyichicahualis? ");
INSERT INTO azzNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ijcuacón Jesús quinotzac se conetzin huan quitalij inixpan imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Huan Jesús quinilij ijcuín: ―De yec melau ten namechilía de que namejuan como amo nanmocuepaj queme senme de nijín coneme, ijcuacón amo huelis nancalaquisque campa Dios quinyolyecana itaneltocacahuan ica ihueyichicahualis. Ta, monequi ximochihuacan nanyectacuautamatcataca queme nijín conet ten tacuautamati sayó ihuan nitajtzin. ");
INSERT INTO azzNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Huan nochi naquen moicnotalis huan mosejsentalis san ijcón queme nijín conet ten nonahuactzinco tacuautamati, ijcuacón yejua ne yesqui in cachi hueyi campa Dios momasoutoc ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Huan como namejuan nancajsicamatij huan nanquiselisque ica in huelilis de notocaytzin se de yancuic notaneltocacau, no ijcón Nejuatzin nannechselíaj, porín nancajsicamatque ya nohuelilis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Huan Jesús quinmachtij imomachtijcahuan ijcuín ―Huan tacán acsame quitepotamíaj tech in tajtacol se de nijín conetzin ten notech tacuautamati, ijcuacón cachi cuali para yejuan ne naquen tetepotamíaj ma se quinquechpilohuili se hueyi tet huan ma se quinatamota tech in hueyíat de mar campa cachi huejcatan, de nojón tet ten in tapial quitilantinemi campa molino cuac quicuechojtoc in trigo. ");
INSERT INTO azzNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Semi teicneltijque ne talticpacuani cuac yejuan quintepotamíaj notaneltocacahuan ica in tajtacol. Huan nachipa oncas tataman ohuijcayome tenica se motepotamis tech in tajtacol. Pero semi teicneltijque nijinques talticpacuani cuac yejuan quintepotamijtinemij notaneltocacahuan tech in tajtacol nemilis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Huan tacán momay oso mometz mitztepotamía tech in tajtacol, ijcuacón xicotona huan xictamota huejca. Porín cachi cuali ticalaquis timacotoltic oso timetzcotoltic tech in yec nemilis campa Dios quinyolyecana itaneltocacahuan ica ihueyichicahualis. Porín como amo ticotonas momay oso mometz ten mitztepotamía tech in tajtacol, ijcuacón mitztamotasque tech in mictan campa ne hueyi tatzacuiltiloyan, campa in tit amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Huan tacán no in moixtololo mitztepotamía tech in tajtacol, ijcuacón xiquixti huan xictamota huejca. Porín cachi cuali para tejua ticalaquis tech in yec nemilis ica se moixtololo san huan que ticpías omen moixtololuan huan ica por nojón mitztamotasque tech in mictan campa ne tatzacuiltilis huan campa ne tit amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Huan Jesús quinmachtij imomachtijcahuan ijcuín: ―Huan amo no xiquinixtopehuacan nión senme de nijín noconetzitzin ten nohuan pohuij. Huan no namechilía que nepa eluiyactzinco in ángeles taquehualme de Totajtzin Dios yetocque nepa ixpantzinco Yejuatzin huan quinyecpixtocque nijín conetzitzin ne ten nohuan taneltocatocque. ");
INSERT INTO azzNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Huan Nejuatzin ni Yectagatzin nihuala para niquinmaquixtis naquen ixpoluitocque tech in tajtacol nemilis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Huan no Jesús quinmachtij imomachtijcahuan ica nijín nexcuitil ijcuín: ―¿Toni nanquixejecoa de nijín nexcuitil? Se tagat quipiaya macuilpoal ichcame huan senme de ne poliu. ¿Cox amo in tapixque quincahua ne cuouta in ocsequin nahuipoal huan caxtolo nahui ichcame huan yohui quitemoti in ichcatzin ten polihuic ya? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Huan tacán hueli cajsis in ichcat ten polihuic, ijcuacón de yec melau ten namechilía que ne tapixque cachi moyolpactía porín cajsic in ichcatzin ten poliuca ya huan que ne nahuipoal huan caxtolonnahui ten amo poliucaj. ");
INSERT INTO azzNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Huan ijcón queme ne tapixque quinequi ma ajsitinemican niichcahuan, no ijcón in Tohueyitajtzin Dios ten yetica ne eluiyactzinco amo no quimonequiltía de que ma xiixpolihuican senme de namejuan ten nanpohuij ihuantzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Huan tacán se mocniu mitzchihuilía tensá ten amo cuali, ijcuacón nimantzin xiyó xicnojnotzati huan xicajsicamatiltiti moselti. Huan como mitzcaquilía ten tiquiluiti ne mocniu, ijcón yejua quiselía ne maquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Huan como amo mitzcaquilía ten tiquiluiti, ijcuacón tejua xiquinnotza se ome eyi taca taneltocani ma yacan namohuan para que ijcón ixnesican que melau tictapojpoluij ya ne mocnitzin. ");
INSERT INTO azzNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Huan tacán nión no mocniu mitzcaquilía ten tiquiluiti ihuan ne testigos, ijcuacón xiquinilui nochi ne tocnihuan den mosentilíaj tech in tiopan. Huan tacán nión no ijcón in mocniu quincaquilía in tocnihuan, ijcuacón xicpohuacan ne mocniu queme se analtecacoyot naquen amo pohui ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","De yec melau ten namechilía que nochi ten namejuan nantatacahualtiani de que ma amo quichihuacan in taneltocani nican talticpac, no ijcón motatacahualtis ya nepa eluiyactzinco. Huan nochi ten namejuan nanquicahuaj ma quichihuacan in taneltocani nican talticpac, no ijcón mochihuas ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Huan no ijcón namechilía que como omen de namejuan nanmoyecyolmaxitíaj huan nanmoyectencahuaj de que nanquitajtanilisque ica ne tatatautilis ihuan Dios, ijcuacón in Totajtzin Dios ten yetica nepa eluiyactzinco namechnanquilis huan quichihuas ne ten nancontajtanilijque. ");
INSERT INTO azzNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Huan no namechilía de que campa mosentilisque se ome eyi den notaneltocacahuan ica in chicahualis de notocaytzin, ompa Nejuatzin niyetos tatajcoyan de yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ijcuacón in Pedro yajqui huan quitajtoltij Jesús ijcuín: ―Notecotzin, ¿canachpa huelis nictapojpoluis nocnitzin cuac tensá nechchihuilis ten amo cuali? ¿Xe monequi nictapojpoluis chicojpa? ");
INSERT INTO azzNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ijcuacón in Jesús quinanquilij ijcuín: ―Nimitzilía amo sayó chicojpa xictapojpolui. Ta, xictapojpolui miacpa, huan amo xicpohua canachpa tictapojpoluis mocniu. ");
INSERT INTO azzNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Huan ijcón in Jesús quinnojnotzac imomachtijcahuan ica se nexcuitil ijcuín: ―Nicnejnehuililtía se hueyichiuque rey queme ichicahualis de Dios cuac Yejuatzin momasoutoc ica ihueyi chicahualis se iyolijtic. Huan ne rey quinequi quimatis canachi quitahuiquilíaj cada senme de nitaquehualuan. ");
INSERT INTO azzNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Huan cuac ne hueyi chiuque pehuac quichihuac ya cuenta, ijcuacón cualcuilijque se taquehual ne ten quitahuiquiliaya míac millones de tomin. ");
INSERT INTO azzNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Huan nijín taquehual amo huelía motaxtahuilis. Ica ya nojón in hueyi chiuque tanahuatij ya que ma quinamacacan in taquehual ihuan nisihuau huan nipiluan huan nochi ten niaxca, para ma ijcón motaxtahuiliani nochi ten quitahuiquiliaya. ");
INSERT INTO azzNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pero ne taquehual motoquij huan motancuaquetzac iixpan ne hueyi chiuque huan quitatautij ijcuín: “Notecotzin xinechonyolicneli huan xinechonchía oc huan ijcón huelis nimitzontaxtahuilis nochi ten nimitzontahuiquilía”. ");
INSERT INTO azzNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Huan ijcón in patrón de ne taquehual quiyolicnelij huan quitapojpoluij de nitahuicalis huan de ompa quicahuac ma yohui. ");
INSERT INTO azzNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Huan cuac yequin calanquistiaya ya de nichan ipatrón, ijcuacón ne taquehual moitac ihuan se itaquehualicniu ten no quitahuiquiliaya sequi tomin san, amó míac. Pero yejua nimantzin quiquechquitzquij ne itaquehualicniu huan pehuac quiquechpajpatzca huan quiliaya ijcuín: “Nechtaxtahuilía axcan ten tinechtahuiquilía”. ");
INSERT INTO azzNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ijcuacón ne itaquehualicniu motancuaquetzac iixpan huan quitatautiayaj ijcuín: “Xinechonchía oc se ome eyi tonal oc huan ijcón nimitzonixtahuilis nochi ten nimitzontahuiquilía”. ");
INSERT INTO azzNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Huan ijcón ne taquehual amo quinequic quichías. Ta, cuiyac quitzacuato tech in cárcel para ma quitaxtahuiliani nochi ten quitahuiquiliaya. ");
INSERT INTO azzNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Huan in ocsequi taquehualme cuac quicacque que ijcón mochihuac, ijcuacón yejuan semi quintelyolcocoj huan yajque quitapohuitoj in ne hueyi chiuque nochi ten mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ijcuacón in ne hueyi chiuque tanahuatij ma quicuitij in taquehual huan quilij ijcuín: “Tejua taquehual, semi amo tiyolcuali. Nejua nimitztapojpoluij de motahuicalis porín tejua tinechontajtanilij de que ma nimitztapojpolui. ");
INSERT INTO azzNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Huan tejua no ijcón monequía xicchihuani de que xicyolicneliani ne motaquehualicniu ijcón queme nejuatzin nimitzyolicnelij”. ");
INSERT INTO azzNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Huan ijcón in patrón semi yolcualanic huan tanahuatij ma quitzacuatij tech ne cárcel huan ma amo quisasquía hasta cuac nochi quitamitaxtahuilisquía ya ten quitahuiquilía ya. ");
INSERT INTO azzNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Huan Jesús quinilij ijcuín: ―No ijcón in Tohueyitajtzin Dios ten yetica nepa eluiyactzinco namechchihuilis cada senme de namejuan, como amo nanquintapojpoluisque namocnihuan ica nochi namoyolojuan nochi ne ten namechtahuiquilíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Huan mochihuac que cuac Jesús quintaminextilij ya nijín tajtolme, ijcuacón quisac de Galilea huan yajqui ne analcopaca de Judea huan ajsito ne iquisayampa in tonal campa in hueyíat de Jordán. ");
INSERT INTO azzNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Huan míac tagayot quitoctiliayaj Jesús huan Yejuatzin quinpajtiaya míac ten cocoxcayetoyaj ica ten míac tataman cocolis. ");
INSERT INTO azzNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Huan ijcón sequin fariseos motoquijque para quiejecosque nitanemilil de Jesús huan quitajtanilijque ijcuín: ―¿Cox quitecahuilía in tanahuatil de Moisés de que se tagat ma mosihuacahua tenica tenesi ohuijcayot? ");
INSERT INTO azzNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Huan Jesús tananquilij ijcuín: ―¿Xe amo queman nanquileerojtinemij tech in Tajcuilolamatzin de Dios de que Totajtzin Dios quichihuac in ome taman cuac ne tatzinpehuac nochi? Ijcuac Yejuatzin quichihuac in tagat huan in sihuat. ");
INSERT INTO azzNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Huan Jesús no quinilij ijcuín: ―Ica ya nojón in tagat ma quincahua itatajtzin huan inanajtzin huan ma mosentali ihuan isihuau. Huan in ome mocahuas sansé san. ");
INSERT INTO azzNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Huan ijcón amo omen oc yesque. Ta, sayó se. Ica ya nojón in tagat huan in sihuat ten Dios quinsentalis namicuani ya, yejuan nojonques ma amo se tagat quinxexelos oc. ");
INSERT INTO azzNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ijcuacón in fariseos quitajtoltijque Jesús ijcuín: ―¿Queyé in Moisés quitecahuilij ma se quimacas se isihuau se tajcuilolamat campa ixnesis de que mocacauque ya? ");
INSERT INTO azzNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Pero in Jesús quinnanquilij ijcuín: ―Moisés namechmacac ne tanahuatil de ne sihuacacahualis porín namejuan nanyolpipicticque de namotamachilis huan amo quinecque quitacamatisque Dios. Pero melau cuac Yejuatzin quichijchihuac in talticpac huan in eluiyac, ijcuacón amo ijcón catca. ");
INSERT INTO azzNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ne tagat motajtacolmacas cuac yejua quinemilis de que quicahuas isihuau masqui yejua ne isihuau amo motajtacolmaca ihuan ocsé tagat. Huan ne tagat ten quicahuas nisihuau huan monamictis ihuan ocsé sihuat, yejua ne motajtacolmacas. Huan no ijcón como huitza ocsé tagat huan monamictis ihuan ne tesihuau, no ijcón yejua motajtacolmacas ya porín ne tesihuau poutoc oc ihuan ne itayecancayoquich. ");
INSERT INTO azzNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Huan Jesús imomachtijcahuan quilijque ijcuín: ―Huan tacán ijcón mochihua de que in tagat amo huelis quicahuas isihuau, ijcuacón cachi cuali ma amo monamictiani. ");
INSERT INTO azzNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Huan ijcón in Jesús ocsepa quinilij ijcuín: ―Amo nochin huelis quitacamatisque nijín tanextililis. Ta, sayó yejuan ne naquen Dios quinajsicamatiltis ya. ");
INSERT INTO azzNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ongac tataman tamachilisme para ma amo se monamictis. Sequin taca amo hueli monamictíaj porín mococoaj desde cuac yolic huan ijcón amo huelis tascaltisque. Huan ocsequin taca amo hueli monamictíaj, porín acsame quintahuelitaj ya huan quincococojque; ica ya nojón amo huelis tascaltisque. Huan ocsequi taca amo hueli monamictíaj porín quinequij motequitilisque itech in tanahuatil de que Dios momasoutoc ica ihueyichicahualis iyolijtic itaneltocacahuan. Huan nochi naquen huelis quitacamatis nijín tanextililis, ma quiseli huan ma quitacamatiyás. ");
INSERT INTO azzNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Huan ijcón cualcuilijque sequin coneme para ma Jesús quintiochihua huan para ma quincuamajpacho huan para ma motatatautili ica por yejuan. Huan imomachtijcahuan de Jesús peuque quintacahualtiayaj ne naquen quinualcuiliayaj ninconehuan. ");
INSERT INTO azzNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Huan Jesús quinilij ocsepa ijcuín: ―Xiquincahuacan in coneme ma hualacan nohuan huan amo xiquintacahualtican. Porín in coneme queme nijín, yejuan tacuautamatij notechcacopaca. Huan no namechilía que nochi naquen motemacas nohuan ma niquinyolyecana, ijcón queme ne coneme, yejuan nojonques Dios quinyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Huan cuac quincuamajpachoj ya nijín coneme, ijcuacón in Jesús yajqui huan quisac tech ne lugar. ");
INSERT INTO azzNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Huan ijcón huala se tagat campa Jesús yetoya huan quitajtoltij ijcuín: ―Tejuatzin, tioncuali tiontamachtijque, ¿toni cuali chihualis monequi nicchihuas para nicpías ne yec nemilis nachipa? ");
INSERT INTO azzNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ijcuacón in Jesús quinanquilij ijcuín: ―¿Queyé tinechnojnotza de nicuali? Porín amo aca ocsé oc yolcuali. Ta, sayó se aquen yolcuali huan Yejuatzin ya ne in Totajtzin Dios. Huan tacán ticnequi ticalaquis tech in yec nemilis, ijcuacón monequi xictacamati in tanahuatilme de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ijcuacón in tagat quitajtoltij ijcuín: ―¿Catiyejua in tanahuatilme monequi ma niquintacamati? Huan Jesús quinanquilij ijcuín: ―Amo xitemicti, amo xisihuapapatatinemi, amo xitachtequi, amo xixolopijti ihuan ocsequin. ");
INSERT INTO azzNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Huan xicmohuiscapohua motajtzin huan monantzin; huan xictasojta mocniu ijcón queme tejua timotasojta. ");
INSERT INTO azzNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Huan in telpocat tananquilij ijcuín: ―Nochi nijín nicchiutihuitz ya desde cuac nipili oc nicatca. ¿Huan toni oc nechpoloa oc? ");
INSERT INTO azzNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Huan Jesús quilij: ―Como ticnequi tiyecchipaucanemis, ijcuacón xiyó xicnamacati nochi ten moaxca huan xiquinxejxeluili in taca ten amo teyi quipíaj ten cuasque. Huan ijcón ticpías in hueyi paquilis huan yec yetolis nepa eluiyactzinco. Huan xihuiqui nohuan huan xinechtoctiliqui huan xinechtacamatiyás. ");
INSERT INTO azzNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Huan cuac ijcón quicayic in telpocat de nijín tajtolme, ijcuacón mocuepteu huan yajqui moyolcocojtiyáj porín quipiaya míac ten niaxca. ");
INSERT INTO azzNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ijcuacón Jesús quinilij imomachtijcahuan ijcuín: ―De yec melau de namechilía de que semi ohui para se rico ma motemactiyás inahuactzinco Dios para que Yejuatzin quiyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Huan ocsepa namechilía de que amo huelis nalpanos se hueyi tapial ten monotza camello campa coyoctic in acoxaj. Pues amo no huelis motemactiyás in tagat rico inahuactzinco Dios para que Yejuatzin quiyolyecantiyás ica ihueyichicahualis, como yejua tacuautamatinemi itech niricoyo. ");
INSERT INTO azzNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Huan cuac imomachtijcahuan quicacque ijcón, ijcuacón yejuan semi quimoucacacque huan motajtoltiayaj yejuan san se huan ocsé ijcuín: ―¿Aconi, pues, huelis maquisas de nitajtacoluan ijcón? ");
INSERT INTO azzNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ijcuacón in Jesús quinsenitac huan quinilij ijcuín: ―In taca amo huelis momaquixtisque de nitajtacoluan, como amo yec tacuautamatij ihuan Dios; porín xicmatican de que sayó Dios huelis nochi quichihuas nijín. ");
INSERT INTO azzNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Huan ijcón in Pedro tananquilij ijcuín: ―Xiconita, tejuatzin, tejuan ticauque ya nochi ten ticpiayaj huan timitztoctilíaj axcan para timitztacayasque. ¿Huan toni tejuan ticselisque? ");
INSERT INTO azzNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Huan Jesús quinnanquilij ijcuín: ―De yec melau ten namechilía que tech ne tonalme ten huitze oc Dios quichihuas nochi yancuic ya. Huan Nejuatzin ni Yectagatzin nimotalis queme se rey huan ompa nitayecanas ipan nochi ten ongac ica nohueyichicahualis. Huan namejuan ten nannechtoctilijtocque huan nechtacamatinenque, namejuan no ompa nanmotalitihue nonacastan campa ne taixejecoloyan campa yetocque in majtactiomome sillas. Huan ompa tiquinixejecoltisque huan tiquinixcomacasque in pueblojuani de Israel ten pohuij de ne majtactiomome tetatme. ");
INSERT INTO azzNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Huan cuali quichihuas se tagat taneltocque como yejua nechyoltasojtas huan quincautiyás ya ninchan, huan icnihuan taca, huan icnihuan sihuame, huan itajtzin huan inantzin, huan nisihuau, huan nipiluan huan nitaluan ten niaxca. Huan in taneltocani como quicauque ya nochi nijín porín quitasojtaj notocay, yejuan nojonques quiselisque se macuilpoalpa tatiochihualisme, huan no quiselisque in yec nemilis ten amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Huan miacque taneltocani ten axcan tayecanani, yejuan nojónques yesqui tacuitapanme. Huan miacque taneltocani ten axcan tacuitapanme, yejuan nojónques tech ne tonalme yesque tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Huan in Jesús quinnextili in tacaquini nijín nexcuitil ijcuín: ―Nicnejnehuililtía se tagat rico queme ichicahualis de Dios cuac Yejuatzin den ne eluiyactzinco momasoutoc ica ichicahualis se iyolijtic. Huan ne tagat rico patrón quipiaya miác taquehualme ten quitequitilíaj ya tech ne milajuvas cuouta. Huan se tonal quisac in patrón semi cualcan huan quintemoto sequi tequitini para ma cajocuican ne uvas taquilot ten yocsic ya. ");
INSERT INTO azzNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Huan ne patrón moyectencahuac ya ihuan in tequitini de que quintaxtahuis ajsitoc se tonal tatanisque ica ne tomin denario. Huan ijcón quintitanic in tequitini tech ne italpan para ma quitequitilitij yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Huan ica ojpa quisac in patrón nepa queme chicnahui hora de tajca, huan ocsepa quinitac ocsequi taca tocotzyetoyaj san tech ne plazajteno. ");
INSERT INTO azzNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Huan in patrón quinilij ijcuín: “Namejuan xiyacan no xinechtequitilitij tech ne nomila huan namechtaxtahuis ijcón queme monequi”. Ijcuacón in taca yajque quitequitilitoj. ");
INSERT INTO azzNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Huan ica expa huan ica naupa quisac in patrón nepa queme nepanta huan ocsepa quisac nepa queme eyi hora de tiotac, huan quichihuac ocsepa ijcón queme quichihuac ne cualcampa. ");
INSERT INTO azzNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Huan ipa queme macuil hora de tiotac yajqui in patrón tech ne plaza huan ocsepa quinajsic sequin taca tocotzyetoyaj san huan yejua quinilij ijcuín: “¿Queyé namejuan nanyetocque nican san nochi in tonal huan amo nantequitij?” ");
INSERT INTO azzNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ijcuacón yejuan tananquilijque ijcuín: “Nican tiyetocque porín amo aquen techmaca tequit”. Huan ijcón in patrón quinilij: “Namejuan no xiyacan xinechtequitilitij tech ne nomila huan namechmacas in taxtahuil ajsitoc ijcón queme monequi”. ");
INSERT INTO azzNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Huan ne cuac pancalayic ya in tonal, ijcuacón in patrón ten niaxca den milajuvas cuouta, ne patrón quilij ne tagat ten quinyecanaya in tequitini ijcuín: “Xiquinnotza nochi in tequitini huan xiquintaxtahui ajsitoc ijcón queme monequi. Pero achto xiquintaxtahui de ne satepan peuque tequitij, huan nimampa no xiquintaxtahui sejsé ijcón queme toni hora peutiyajque tequitij in taca”. ");
INSERT INTO azzNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Huan ijcón mochihuac. Achtopa motenextilijque para quintaxtahuisque nochi ne naquen tequitijque nepa queme macuil hora de tiotac. Huan ijcón cada se quiselij nitaxtahuil ajsitoc ijcón queme se tonal tatanilis de se tomin denario, ijcón queme quinilijca ya in patrón ne achtopa. ");
INSERT INTO azzNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Huan cuac motenextilijque ya ne naquen achto peuque tequitij, ijcuacón yejuan quiyolnemiliayaj de que quiselisque cachi míac taxtahuil. Pero amo ijcón mochihuac queme yejuan quinemiliayaj quiselisque. Ta, no quiselijque ijcón cada se de se tonal taxtahuil, de se tomin denario, ijcón queme ocsequin quiselijque. ");
INSERT INTO azzNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Huan cuac quiselijque ya ne taxtahuil, ijcuacón yejuan peuque moyolcuejmoloaj ihuan in patrón se huan ocsé. ");
INSERT INTO azzNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Huan quilijque in patrón ijcuín: “¿Queyé nijín tequitini ten tequitijque sayó se hora san huan no tiquintaxtahui ajsitoc ijcón queme tejuan titechtaxtahuij? Huan tejuan titaxicojque titequitijque nochi in tonal masqui melau ica tatotoncayot”. ");
INSERT INTO azzNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ijcuacón in patrón quinnanquilij senme de yejuan tequitini ijcuín: “Nocniu, amo teyi nimitzchihuilijtoc ten amo cuali. ¿Xe amo tejua nohuan timoyectencahuac de que canachi tomin denario nimitzmacasquía para se tonal tequit?” ");
INSERT INTO azzNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Huan no quilij in patrón: “Xicui nijín motaxtahuil huan xiyó. Porín nejua nicnequi niquintaxtahuis de ne tequitini masqui melau satepan ya peuque tequitij ijcón queme tejua nimitztaxtahuij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Xe nejua amo nihuelis nicchihuas queme nicnequis ica notomin? ¿Xe tejua tiquinyolnexicolía ocsequi in tequitini naquen nejua niquinyolicnelía?” ");
INSERT INTO azzNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Huan ijcón miacque taneltocani ten axcan tayecanaj, yejuan nojonques yesque tacuitapanme. Huan miacque taneltocani ten axcan tacuitapanme, yejuan nojonques yesque tayecanani. Huan axcan miacque tanotzalme ya de Dios, pero amo miacque taijitalme yesque tech ne tonal. ");
INSERT INTO azzNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Huan cuac Jesús tejcotiaya ojtipan para Jerusaléncopaca, ijcuacón quinnotzac in majtactiomome imomachtijcahuan seco de ne ojti huan quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","―Xiquitacan, tejuan titejcotiyohue para Jerusaléncopaca huan ompa Nejuatzin ni Yectagatzin nechtemactisque inmaco in tayecanani tiopixcame huan inmaco in tanextiliani den tanahuatil de Moisés, huan yejuan nechtelchihuasque para ma nechmictican. ");
INSERT INTO azzNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Huan nechtemactisque imaco in tagayot ten amo judíos para ma nechquejquelocan, huan ma nechuijuitequican, huan ma nechcuoupampilocan. Huan niman ipan eyi tonalica Nejuatzin nipanquisas niyoltoc intzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Huan ijcón motoquij campa Jesús se tenan ten isihuau den Zebedeo ihuan iconehuan Jacobo huan Juan. Huan in sihuat motancuaquetzac iixpan Jesús para quitajtanilis tensá den cualtagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Huan Jesús quitajtoltij ijcuín: ―¿Toni ticnequi? Huan in sihuat tananquilij ijcuín: ―Xitanahuati que ompa campa Tejuatzin titayecana ica mohueyichicahualis ma no noconehuan ma no quipiacan tanahuatil para ma motalican se moyecmacopaca huan in ocsé moopochcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Huan in Jesús quinanquilij ne sihuat ijcuín: ―Namejuan amo nancajsicamatij ten nannechtajtanilíaj. ¿Xe huelis nantaxicosque ten Nejuatzin nitaxicos porín nicseli sayó tajyohuilis? Huan yejuan tanaquilijque: ―Quema catzin, tihuelisque. ");
INSERT INTO azzNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Huan Jesús quinilij ijcuín: ―De yec melau ten namechilía que namejuan nanquiselisque ne vaso den cualcui tajyohuilis ijcón queme Nejuatzin nicselis. Huan nanquiselisque de taahuilis ten cualcui tajyohuilis ijcón queme Nejuatzin nicselis. Pero Nejuatzin amo nicpía in tanahuatil para namechnahuatis que tejua Jacobo timotalis ca chicahualis noyecmacopaca huan tejua Juan timotalis ca chicahualis noopochcopaca. Ta, sayó Totajtzin Dios quinmactis ne tetayocolil para naquen Dios quinijtac ya. ");
INSERT INTO azzNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Huan cuac in ocsequi majtactiomomen imomachtijcahuan quicacque nijín tajtolme, ijcuacón moyolcualantijque ihuan in icnime Jacobo huan in Juan. ");
INSERT INTO azzNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Huan Jesús quinnotzac nochin huan quinilij ijcuín: ―Como nanquimatij, in tayecanani de tataman pueblojme mohueyimatij huan mopohuaj hueyi chihuanime tech ne in pueblojme huan quinmachililtíaj inchicahualis den ne inpueblojcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Pero ma amo ijcón namohuan. Ta, naquen quinequis mochihuas tayecanque namohuan, yejua ne ma mochihua queme se tetaquehual san den nochin. ");
INSERT INTO azzNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Huan tacán acsá de namejuan quinequis tayecanas, ijcuacón ma mochihua queme se tetequitilijque san den nochi. ");
INSERT INTO azzNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Porín Nejuatzin ni Yectagatzin amo nihuala para ma acsame nechtequitilican. Ta, nihuala sayó para ma nitetequitilis, huan para ma nictemacas nonemilis para niquixtahuas in tajtacol, huan para niquinmaquixtis nijín talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Huan yaya Jesús ihuan imomachtijcahuan huan queman quistiayaj ya tech ne pueblo Jericó, ijcuacón huel míac tagayot quitoctiliayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Huan tocotzyetoyaj ome ixpojpoyome ojtenteno. Huan cuac yejuan quicacque de que Jesús panotiaya ompaca, ijcuacón peuque quichicaucatzajtziliayaj huan quiliayaj ijcuín: ―Totecotzin Temaquixtijque, tion Teconetzin de rey David, xitechonyolicneli. ");
INSERT INTO azzNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Huan in tagayot quintacahualtiayaj para ma amo cachi quitzajtzilianij oc, pero ne ixpojpoyome cachi quitzajtziliayaj chicahuac ijcuín: ―Totecotzin Temaquixtijcatzin, tion Teconetzin de ne huejcau rey David, xitechonyolicneli. ");
INSERT INTO azzNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ijcuacón in Jesús moquetzac huan quinnotzac ne ixpojpoyome huan quintajtoltij ijcuín: ―¿Toni nanquinequij ma namechihuili? ");
INSERT INTO azzNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ijcuacón yejuan quinanquilijque ijcuín: ―Totecotzin, ticnequij xitechontachialti. ");
INSERT INTO azzNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Huan ijcón in Jesús quinyolicnelij huan quinixacualoj. Huan ijcón nimantzin ya tachiacque ne ten catcaj ixpojpoyome; huan de ompa quitoctilijque Yejuatzin para quitacamatiyasque. ");
INSERT INTO azzNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Huan Jesús huan imomachtijcahuan ajsitiyayaj ya ne Jerusaléncopaca, huan yajque huan calacque ya tech in pueblo de Betfagé cerca ya de se tepet den monotza Olivos. Ijcuacón in Jesús quintitanic ome imomachtijcahuan, huan quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","―Xiyacan tech ne pueblo ten ne yetoc cachi taixpampa. Huan niman cuac nancalaquitihue, ijcuacón ompa nancajsisque se tenan burrita ilpitoc ihuan se burritojtzin. Huan yej ne xictojtomacan huan xinechualcuilican. ");
INSERT INTO azzNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Huan tacán acsá tensá namechilisquía, ijcuacón namejuan xitananquilican ijcuín: “In Totecotzin quimonequiltía quitatequiutis in tapialtzin”. Huan ijcón nimantzin namechcahuilisque in burrito. ");
INSERT INTO azzNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Huan nochi nijín mochihuac para ma ijcón motamijchihua ten quijcuilojteu in tanahuatijque Zacarías cuac yejua quijtojteu ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Xiquilican ne pueblojuani de Sión de Jerusalén ijcuín: “Xiquitacan, namohueyitayecancatzin hualajtoc ya para namechyecanas. Yejuatzin yolyemanic huan cualtagat. Huan tocotzyetihuitz ipan se burrita, tepili de se tapial”. ");
INSERT INTO azzNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Huan ijcón imomachtijcahuan yajque huan quichiuque ijcón queme Jesús quinnajnahuatijca ya. ");
INSERT INTO azzNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Huan cualcuilijque Jesús in burrita ihuan nipili huan quipanpejpechtijque ica ninayahuan, huan ijcón in Jesús mopantalij ipan in burrita. ");
INSERT INTO azzNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Huan tel míac tagayot quisohuayaj talixco inayahuan huan ocsequi quimatectiayaj cuoume nimayo huan quimoyautiayaj ne xihuit taixpampa de Jesús tech ne ojti. ");
INSERT INTO azzNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Huan míac tagayot yayaj tayecanayaj huan ocsequin cualtoctiliayaj Jesús. Huan ijcón nochi yayaj yolpactiayaj huan quijtoayaj ijcuín: ―¡Hosana timitzonueyichihuaj Tejuatzin Temaquixtijcatzin, tion Teconetzin de ne huejca rey David! ¡Tiontatiochihual den tihualajtoc itencopa Totajtzin Dios! ¡Ticueyichihuaj Totajtzin Dios ten yetica nepa eluiyactzinco! ");
INSERT INTO azzNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Huan cuac calayic ya Jesús tech in pueblo de Jerusalén, ijcuacón nochi in pueblojuani moyolcuejmoloayaj huan miacque motajtoltiayaj ijcuín: ―¿Aconi yejuatzin ne? ");
INSERT INTO azzNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Huan miacque tagayot tananquilijque ijcuín: ―Yejuatzin ya in tanahuatijque ten monotza Jesús huan yejua ne cayot de Nazaret de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Huan cuac Jesús calayic tech in tiopan de judíos den cachi hueyi, ijcuacón Yejuatzin pehuac quincalanquixtía nochi ne tanamacani huan ne tacohuani ten tequititoyaj tech in tiopanijtic. Huan quicuic in mesajme den tomin papatani huan ica calan tacuamotac. Huan no ne icpalme den ne sehuilonime den ne naquen quinnamacatoyaj in totome ten monotza palomas, no ijcón ica calan tacuamotac. ");
INSERT INTO azzNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Huan Jesús quinilij in tagayot ijcuín: ―Achá amo nanquimatij de que tajcuiliutoc ya tech in Tajcuilolamatzin ijcuín: “Nijín nochan quitocaytisque se cali de ne tatatautilis ihuan Dios”. Huan namejuan nanquichiutocque nochantzin queme yesquía se tecal campa yetocque in tachtequini. ");
INSERT INTO azzNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Huan nimampa tech ne tiopanijtic motoquij campa Jesús sequin cocoyani ixpojpoyome, huan sequi ten amo huelíaj moquetzayaj huan Jesús quinpajtij. ");
INSERT INTO azzNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Huan in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés quitacque ne mohuiscatequit ten Jesús quichihuac, huan no quicacque nochi in telpocame cuac quimohuistiliayaj Jesús tech ne tiopanijtic ijcuín: “Timitzonueyichihuaj Temaquixtijque, tion Teconetzin de rey David”. Huan ijcón cuac in tayecanani quicacque nijín tajtolme, ijcuacón yejuan peuque yolcualanque, ");
INSERT INTO azzNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","huan quilijque Jesús ijcuín: ―Xicaqui san ten mitzilijtocque nijín telpocame. Pero Jesús quinnanquilij ijcuín: ―Quema, niquincaquilijtoc. Pero achá namejuan amo queman nanquileerojque in Tajcuilolamatzin campa quijtoa ijcuín: Totajtzin Dios, Tejuatzin ticonchiutzino de que in pilime huan in coneme ten chichij oc ma mitzoncantarohuilíaj huan mitzonmohuistilisque. ");
INSERT INTO azzNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Huan de ompa Jesús quincauteu in tagayot huan yajqui campa pueblojuani de Betania huan ompa mocahuac se yohual. ");
INSERT INTO azzNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Huan imostica cualcampa Jesús mocuepac ocsepa se viaje tech ne pueblojcopaca de Jerusalén. Huan mochihuac que cuac nejnentiaya ya, ijcuacón pehuac mayana. ");
INSERT INTO azzNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Huan Jesús quitac se higoscuohuit ijcatoc ojteno, huan yajqui quitemolito itaquilo; pero amo teyi caxilij. Ta, se cuohuit ten sayó maxoxohuixtoc san. Ijcuacón in Jesús quilij ne higoscuohuit ijcuín: ―Amo queman tictemacas oc motaquilohuan. Huan niman ne higoscuohuit pehuac niman huaqui. ");
INSERT INTO azzNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Huan cuac imomachtijcahuan quitacque de que huayic ya ne higoscuohuit, ijcuacón semi quihueyimoucaitacque huan quitajtoltijque Yejuatzin ijcuín: ―¿Quenín nijín higoscuohuit tel niman huayic? ");
INSERT INTO azzNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ijcuacón in Jesús quinnanquilij ijcuín: ―De yec melau ten namechilía de que xicpiacan ne ajsicatacuautamatilis huan xicneltocacan de que melau mochihuas ya nochi ten nanquitajtanilisque Dios. Huan ijcón amo sayó huelis nanquichihuasque nijín ten nicchihuilij nijín higoscuohuit. Ta, no huelis nanquinahuatisque se hueyi tepelomo ijcuín: “Ximijcuini de nican huan xiyó ximocalaquiti tech in hueyíat mar”, huan nochi nijín huelis mochihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Huan como nanyecajsicatacuautamatij de nanquitajtanilisque Dios ica ne tatatautilis, ijcuacón yec melau nanquiselisque ten nanquitajtanilisque, masqui ohuijcayot tzictzin queme in higoscuohuit oso se ohuijcayot ten semi hueyi queme se tepet. ");
INSERT INTO azzNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Huan niman Jesús calayic tech in tiopan de judíos. Huan cuac quinnextilijtoya ica in Tajtoltzin de Dios in tagayot, ijcuacón nimantzin motoquijque in tayecanani den tiopixcame huan in huehuentzitzin den pueblojuani de judíos, huan yejuan quitajtoltijque Jesús ijcuín: ―¿Catiyejua tanahuatil ticualcui tejua para ticchihuas nijín tanextililisme? ¿Huan aconi mitzonmacac ne tanahuatil? ");
INSERT INTO azzNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Pero Jesús quinnanquilij ijcuín: ―Nejua no namechtajtoltiti se matájtanti. Huan tacán nannechnanquilíaj, ijcuacón nejua no namechilis ica aconi itanahuatil nicpía para nicchihuas nochi nijín tequit. ");
INSERT INTO azzNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿Aconi quinahuatij Juan ma taahuijtinemi? ¿Xe Dios quinahuatij ma taahuijtinemi in Juan oso yejuan in tagayot quinahuatijque in Juan? Huan yejuan moixejecoltiayaj se huan ocsé huan quijtoayaj ijcuín: ―Tacán tiquilíaj de que in Dios quinahuatij in Juan ma taahuijtinemi, ijcuacón yejua technanquilis ijcuín: “Huan, ¿queyé amo nanquineltoquilijque ten namechiliaya in Juan?” ");
INSERT INTO azzNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Huan tacán tiquilíaj de que in tagayot san quinahuatijque in Juan de que ma taahuijtinemij, amo no cualtías. Porín tiquinmoucatocaj in pueblojuani de judíos que topan yasque. Porín yejuan in pueblojuani quipohuayaj ne Juan Taahuique de que se hueyi tanahuatijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Huan ijcón in tayecanani quinanquilijque Jesús ijcuín: ―Amo ticmatij aconi quinahuatij in Juan ma taahuijtinemi. Huan Jesús quinilij: ―No ijcón nejua amo no namechilis de que aconi nechmacac in tanahuatil de nicchihua nochi nijín tanextililisme. ");
INSERT INTO azzNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Huan ijcón in Jesús quinilij imomachtijcahuan ocsé nexcuitil ijcuín: ―¿Toni nanconixejecoaj de nijín nexcuitil? Se tagat yajqui quitato in itayecancatelpoch huan quilito ijcuín: “Noconeu, axcan nicnequi xiyó xinechtequitiliti itech ne nomilaj uvas cuouta”. ");
INSERT INTO azzNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Huan tananquilij ne iconeu ijcuín: “Amo nicnequi niyás nimitztequitilitiu”. Pero cachi satepan moyolnemilij huan yajqui quitequitilito nitat. ");
INSERT INTO azzNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Huan in tetat yajqui quitato ica ome itelpoch huan quilij ijcón queme ne ocsé quilijca ya. Huan ne ica ome itelpoch tananquilij ijcuín: “Quema, notajtzin, niyás nimitztequitilitiu”. Pero satepan amo yajqui. ");
INSERT INTO azzNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Huan in Jesús quintajtoltij in tayecanani ijcuín: ―¿Catiyejua de ne ome telpochme quichiuque queme quinequía in tetat? Ijcuacón in tagayot tananquilijque ijcuín: ―Yej in tayecanque. Huan ijcón in Jesús ocsepa quinilij ijcuín: ―De yec melau ten namechilía que in tatopaluiani huan in sihuaahuiltiani san namechyecantiyohue huan yejuan calaquisque campa Dios momasoutoc ica ihueyichicahualis ninyolijtic de nitaneltocacahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Namechilía ijcón porín hualajca ya in Juan Taahuijque para namechnextilis de queniu nanchipaucanemisque huan amo nanquineltoquilijque. Huan in tatopaluiani huan in sihuaahuiltiani, quema, yejuan quineltoquilijque huan moyolnemilijque de nintajtacoluan. Huan namejuan masqui nanquitacque ya nijínques ten quineltoquilijque Juan, pero namejuan amo no nanmoyolnemilijque de namotajtacoluan para nanquineltoquilisque in Juan. ");
INSERT INTO azzNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Huan ijcón in Jesús quinnextiliaya imomachtijcahuan ica nijín nexcuitil huan quinilij ijcuín: ―Xicaquican ocsepa ocsé nexcuitil. Se tagat patrón quipiaya míac ten niaxca huan quitocac sequi uvas tactzon tech ne imila, huan quichihuac se corral, huan tachcuac se tayohual campa huelis quipatzcas in uvas taquilot. Huan no quichihuac se hueyi tepamit para huelis quipanitas ne uvas cuouta para tajpías. Huan cachi satepan in patrón quitepialtijteu ica renta ihuan senme de nijín tequitini. Huan in patrón yajqui paxaloto huejca itech ocsé país. ");
INSERT INTO azzNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Huan queman ajsic ya ne tonal cuac yocsic ya in uvas, ijcuacón in patrón quintitanic itaquehualuan para ma quiselitij in uvas taquilot de ne tequitini quimactilisque den pohui ihuan in patrón. ");
INSERT INTO azzNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Pero in tequitini quinquitzquijque itaquehualuan den patrón huan quinuitecque. Huan sequi quinmictijque huan ocsequi quintepoxonijque ica tet. ");
INSERT INTO azzNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ica ya nojón in patrón ocsepa quintitanic cachi míac itaquehualuan huan que ne achtopa quintitanca. Huan ne tequitini ten amo yolcualime quichiuque ocsepa ijcón queme ne achtopa quichiuque. ");
INSERT INTO azzNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Huan cachi satepan in patrón quintitanilij se iyojtzin conetzin porín in patrón quiyolnemiliaya de que xa cachi quitasojtasquíaj niconetzin nojón tequitini. ");
INSERT INTO azzNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Huan queman in tequitini quitacque ya ne iconeu in patrón, ijcuacón moyoliluijque se huan ocsé: “Yejua ya ne quiselis nochi ten pohui itatcopaca. Cachi cuali ximoyejyectalican ma ticmictican huan ijcón tejuan ica timocahuasque nijín uvascuoutacayot ten niaxca nitat”. ");
INSERT INTO azzNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Huan ijcón quichiuque, huan quiquitzquijque ne iconetzin ne patrón huan quiquixtijque calampa de ne uvas cuouta huan ompa quimictijque. ");
INSERT INTO azzNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ijcuacón in Jesús quintajtoltij in imomachtijcahuan ijcuín: ―Huan cuac hualas ne patrón den niaxca ne uvas cuouta, ijcuacón ¿toni quinchihuilis ne tequitini ten amo yolcualime? ");
INSERT INTO azzNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ijcuacón imomachtijcahuan quinanquilijque ijcuín: ―In patrón hualas huan yejua amo quinyolicnelis oc. Ta, quintamimictis ya ne tequitini ten amo yolcualime. Huan quincahuilis ica renta ocsequin tequitini ne uvas cuouta para ma yejuan quimactilican ne uvas taquilot cuac ne yocsis ya nochi ten pohui ihuan in patrón. ");
INSERT INTO azzNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Huan Jesús quinnojnotzac ne tacaquini huan monejnehuililtij yejua san mismo queme se tet huan quinilij ijcuín: ―Achá amo queman nanquileerojtinemij in Tajcuilolamatzin ten quijtoa ijcuín: In tet ten quimajpeuque in tepanchihuani, yejua ne mochihuaco tepanchicahualoni de tepamit. Huan namejuan nannechixtopeuque ijcón queme in tepanchihuani quicauque ne tetzin ten mochihuacaco tepanchicahualoni. Huan in Totajtzin Dios quichihuac nijín tequit huan para tejuan semi cualtzin queme amo queman tiquitayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan ijcón namechilía que namejuan Dios namechajchihuilij in tanahuatil para amo nantayecanasque ihuan Dios campa Yejuatzin momasoutoc ica ihueyichicahualis. Huan Dios quinmactis ocsequin tagayot ne tanahuatil porín yejuan quichihuasque ten Dios itahuelital. Huan ijcón yejuan quimactisque Dios in taquilot ten niaxca, ijcón queme amo quichihuasquíaj in amocuali tequitini. ");
INSERT INTO azzNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Huan ne tet den namechilijtoc ijcuín: “Aquen nesi tagat ipan huetzis ne tet, yejua ne tagat papayacas ninacayo. Huan tacán ne tet panuetzis itech se tagat, ijcuacón ne tagat mocahuas tacuechol”. ");
INSERT INTO azzNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Huan ijcón in tiopixcame tayecanani huan in fariseos cuac quicacque ne nexcuitilme tenica quinnojnotzaya Jesús, ijcuacón yejuan cajsicamatque de que in Jesús tajtojtoya de yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Huan in tayecanani quinequíaj quiquitzquisque Jesús queme preso. Huan amo huelía quiquitzquisque porín quimohuiliayaj in pueblojuani judíos. Huan in pueblojuani judíos quipohuayaj Jesús queme se hueyi tanahuatijque de Dios, porín sayó tajtoaya itencopaca Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Huan ijcón ocsepa in Jesús pehuac quinnextilía in tacaquini ica nexcuitilme huan quinnojnotzac ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","―Nicnejnehuililtía se rey queme ichicahualis de Dios cuac Yejuatzin momasoutoc ica ihueyichicahualis se iyolijtic. Huan nijín rey quichihuac se hueyi iluit de ne namictilis por nitelpoch. ");
INSERT INTO azzNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Huan in rey quintitanic nitaquehualuan ma quinnotzatij ocsequin ten ipa tanejmachtilme ya, ma tatacuaquij ya tech ne namictilis. Huan yejuan amo quinecque yasque tatacuatihue. ");
INSERT INTO azzNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Huan ijcón in rey ocsepa quintitanic ocsequin nitaquehualuan para ma quinnahuatiti ijcuín: “Xiquinilican que nochi yetoc ya in tatacualis, porín nitanahuatij ya ma quinmictican nocuacuejuan huan ocsequin notapialuan ten cachi tomauque. Huan nochi yetoc ya nintacualis para titatacuasque. Xiquinilican ma hualacan ma moyolpactiquij tech nijín ne namictilis”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Huan nijín taca ten tanejmachtilme ya catcaj, yejuan amo quinecque yasque. Ta, quixtopeuque in tacualis. Sequin taca yajque momilajtequitilitoj, huan ocsequin yajque tanamacatoj tech in plaza. ");
INSERT INTO azzNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Huan ocsequin taca ten tanejmachtilme ya catcaj, yejuan quinquitzquijque nitaquehualuan de ne rey huan quinuijtecque huan quinmictijque. ");
INSERT INTO azzNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Huan cuac in rey quicayic de que toni mochihuac, ijcuacón yejua semi yolcualanic huan quintitanic nitaquehualuan soldados para ma quinmictican ne temictiani, huan para ma no quintamichichinocan in pueblojuani de ne temictiani. ");
INSERT INTO azzNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Huan ijcón in rey quinilij in taquehualme ijcuín: “Nochi yetoc ya para titatacuasque den ne namictilis. Huan ijcón ne tagayot ten tanejmachtilme ya catcaj, ipa amo quinnamiquía de que hualasquíaj porín ipa amo yolcualime catcaj. ");
INSERT INTO azzNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Huan axcan xiyacan tech ojmaxalme de ojme den pueblo huan xiquinualcuican aquía huelic nancajsisque huan xiquintatautican ma tatacuaquij tohuan tech nijín ne namictilis”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Huan ijcón intaquehualuan yajque tech in ojme huan quinsentilijque nochi ne ten quinajsicque den yolcualime huan masqui ten amo yolcualime, pero quintatautijque de que ma tatacuaquij de ne nenamictilis. Huan ijcón mosentilijque míac tagayot tech ne ichan in rey, huan ijcón moyolpactijque de ne nenamictilis. ");
INSERT INTO azzNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Huan niman calayic in rey de naquen ichan para quinitas nochi ne tanotzalme ten hualajque. Pero no quitac se tagat ompa yetoya huan amo taquentoya ica ne tilma de ne nenamictilis. ");
INSERT INTO azzNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ijcuacón in rey quilij in tagat ijcuín: “Tejua, ¿quenin huelic ticalayic nican? Ta, amo titaquentoc ica ne tilma de ne namictilis”. Ijcuacón in tagat sayó motentamatilij huan amo teyi quijtoj. ");
INSERT INTO azzNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Huan ijcón in rey quinnahuatij itaquehualuan naquen quixejxelojtoyaj ne tacualis tech ne mesa ijcuín: “Xicmetztzijtzicocan ne tagat ten amo yec taquentoc huan xicmatzicocan huan xicalantamotacan tech in tayohuayanilot campa nachipa chocatos huan campa tannanatzocatos sen nachipa tech in tajyohuilis”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Huan ijcón in rey quinejnehuilía in Cristo cuac Yejuatzin hualas nican talticpac, cuac quinijitaquiu ne naquen tanotzalme de Totajtzin Dios huan no ne naquen amo tanotzalme. Porín miacque tanotzalme ya, pero amo miacque taijitalme de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Huan ijcón in fariseos yajque moixejecoltijque huan moyectencauque para quicaquilisque Jesús xa tensá quijtosquía ten amo cuali, para ica huelis quiteluilisque de tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Huan ijcón in fariseos quintitanque sequin tamatinime ten inuan pohuíaj huan no quintitanque sequin tamatinime ten pohuíaj ihuan in rey Herodes. Huan yejuan ajsicque huan motoquijque campa Jesús huan quilijque ijcuín: ―Tamachtijque, ticmatij que tejuatzin titajtoa ica nochi ten melau, huan titeyecnextilía in ojtzin de Dios, huan amo tiquinyolmohuilía in tagayot ten quijtoaj. Huan amo no tiquinchichicotasojta san taca. ");
INSERT INTO azzNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Axcan xitechonilui toni tiquixejecoa, ¿xe Dios quimonequiltía ma titaxtahuacan impuestos den rey César, oso amo? ");
INSERT INTO azzNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ijcuacón in Jesús niman quinyolojixmatic que amo yec tanemiliayaj ne tayecanani huan quinnanquilij ijcuín: ―Namejuan nantacajcayahuaj san, porín nannechichtacahuisnequij san ica nijín tanemililis. ");
INSERT INTO azzNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Xinechnextilican in tomin tenica taxtahuas impuestos. Huan ijcón in tayecanani cualcuilijque se tomin denario. ");
INSERT INTO azzNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Huan cuac Jesús quitac ya in tomin, ijcuacón quintajtoltij ijcuín: ―¿Aconi nijín ixayac ten ixnesi nican? Huan, ¿aconi nijín itocay ten ijcuiliutoc nican? ");
INSERT INTO azzNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ijcuacón in tayecanani tananquilijque ijcuín: ―Yejua ya in rey César. Ijcuacón Jesús quinilij: ―Xicmactilican in rey César ten quinamiqui xicmactican César, huan xicmactilican Dios ten quinamiqui xicmactican Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Huan cuac quicacque ya nijín tajtolme, ijcuacón ne tayecanani semi quimoucaitacque den nitananquililis; huan de ompa quicauteuque Jesús huan yajque. ");
INSERT INTO azzNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Huan tech ne mismo tonal in taca tamachilejque saduceos motoquijque campa Jesús. Pero yejuan quineltocacque de que amo huelis se panquisas yoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Huan yejuan quitajtoltijque Jesús ijcuín: ―Tamachtijque, in tanahuatijque Moisés techijcuilohuilij ijcuín: “Tacán se tagat yesqui namicque huan miquisquía huan quicahuasquía nisihuau huan amo quinpiasquíaj coneme, ijcuacón ma monamicti iicniutagat de ne miquet ihuan cahual sihuat ten icuñada. Huan ma quiniscaltican coneme ihuan in cahual sihuat ten icuñada. Huan ma quinpiacan coneme den iicniutagat ten miyic ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Pues oncaya chicome icnime nican topueblo. Ne icnitzin ten tayecana, yejua ne monamictij ihuan se sihuat pero niman miyic in tagat, huan amo quinpiaque coneme. Huan quicauteu ne isihuau para ocsé icniu. Huan de ompa monamictij ica ome teicniu ihuan icuñada ten miquic ya iyoquich. ");
INSERT INTO azzNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Huan ijcón mochihuac queme ne achtopa, huan ne tenica ome teicniu miyic; huan satepan ica eyi teicniu monamictij ihuan in icuñada. Huan ijcón mochihuac hasta ajsic de chicome icnime; nochi sejsé monamictiyajque huan nochin mictiyajque huan amo aquen quinpiacque coneme. ");
INSERT INTO azzNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Huan queme nochi tamimicque ya in chicome icnime, ijcuacón in sihuat no momiquilij ya. ");
INSERT INTO azzNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Huan in saduceos quilijque Jesús ijcuín: ―Axcan xitechonili, tech ne tonalme cuac panquisasque yoltocque ne taca den chicome icnime huan ne sihuacahual itzalan in ánimajme, ¿aconi isihuau yesqui senme de ne chicome icnime? Porín nochi in icnime quipouque queme nisihuau. ");
INSERT INTO azzNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Huan ijcón Jesús quinnanquilij ijcuín: ―Nanmocajcayautocque san ica ne nexcuitil, porín amo nanquiyequixmatij in Tajcuilolamatzin de Dios, nión no ichicahualis den Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Porín cuac panquisasque yoltocque itzalan in ánimajme nojón chicome icnime, ijcuacón amo aquen huelis monamictis oc, huan nión no yoltanemilijtosque oc que ocsepa monamictis. Porín ompa nochi in tagayot poutosque queme in ángeles ne taquehualme de Dios, huan yejuan amo monamictíaj huan amo no quinnamictisque. ");
INSERT INTO azzNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Huan cachi oc namechnextilía de ne tonal cuac panquisasque yoltocque in ánimajme: Achá namejuan amo queman nanquileerojtinemij tech in Tajcuilolamatzin de Dios ten technojnotza ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Nejuatzin ni Dios de Abraham huan ni Dios de Isaac huan ni Dios de Jacob”. Huan nijín quijtosnequi que Totajtzin Dios amo in Dios den ánimajme. Ta, Yejuatzin in Dios ten naconime yoltocque. ");
INSERT INTO azzNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Huan cuac in tagayot quicacque nijín nexcuitil, ijcuacón yejuan semi quimoucaitacque den itanextililis de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Huan cuac in fariseos quicacque huan quimatque de que Jesús quintentamatilij in saduceos, ijcuacón mosentilijque in fariseos huan moixejecoltijque. ");
INSERT INTO azzNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Huan se fariseo no catca taixejecojque ica in tanahuatil de Moisés no quinequía quichtacahuis Jesús huan quitajtoltij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","―Tamachtijque, ¿catiyejua in tanahuatiltzin in cachi hueyi de nochi? ");
INSERT INTO azzNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Huan in Jesús quilij ijcuín: ―“Xictasojta mohueyitecotzin Totajtzin Dios ica nochi moyolo, huan ica nochi motanejnequilis, huan ica nochi motanemililis”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Yejua ya nijín in cachi hueyi tanahuatil huan de cachi cuica hueyi chicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Huan ica ome tanahuatil monehuilía queme ne achtopa tanahuatil huan no quijtoa ijcuín: “Xictasojta mocnitzin ijcón queme tejuatzin timotasojta”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ica nijín ome tanahuatilme tejuan ticajsicamatij toni quijtosnequi nochi ne tanahuatil ten quijcuiloj in Moisés huan nochi ten tenextiliayaj ne tanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Huan nijín fariseos sen yetoyaj oc ihuan in Jesús huan in Jesús quintajtoltij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","―¿Toni nanquiyolnemilíaj de naquen monotza Cristo Temaquixtijque? ¿Ne Cristo aconi itatuan? Huan yejuan tananquilijque ijcuín: ―Ne Cristo Yejuatzin ne teconeu de ne huejcau rey David. ");
INSERT INTO azzNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Huan Jesús quinilij ijcuín: ―¿Quenín huelisquía in rey David quipiasquía in Cristo Temaquixtijcatzin queme iconeu, huan ma no quinotzasquía in Cristo queme itayecancatzin? Porín in rey David quijcuiloj tech in Tajcuilolamatzin ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Huan in Totajtzin Dios quinojnotzaya Totayecancatzin in Totecotzin huan quiliaya ijcuín: “Ximosehuijtzino nican noyecmacopaca huan niquintaliti mometztampa nochi ne naquen mitzonyoltahuelitaj”. ");
INSERT INTO azzNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Huan no Jesús quinilij ijcuín: ―Xicmatican que ne rey David quipohuac in Cristo queme iconeu den David, huan no in rey David quimohuiscanotzaya in Cristo queme itayecancateco. ");
INSERT INTO azzNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Huan ijcuac ne tonal amo aquen huelic oc quinanquilij ten Jesús quintajtoltiaya, huan nión se moixehuij oc de que ma quitajtoltij oc Jesús ocsequi matájtanti. ");
INSERT INTO azzNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Huan ijcón in Jesús quinnojtzac in tagayot huan no ne imomachtijcahuan huan quiniliaya ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","―In tanextiliani huan in fariseos mopohuaj ya de que yejuan san quipíaj in chicahualis huan in tamachilis para quinajsicamatiltisque in tagayot in tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Huan ica nojón xiquintacamatican huan xicchihuacan nochi ten namechilíaj in tanextiliani. Pero amo xicchihuacan in tachihualisme ten ne tanextiliani quichihuaj, porín yejuan tanextilíaj ica se taman ten cuali pero amo quichihuaj ten cuali. ");
INSERT INTO azzNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Huan in tanextiani huan in fariseos quintalilíaj in tagayot in tanextililisme queme se ohuijcayot ten semi etic ten amo huel quixicosque. Huan no ne quinchihualtíaj in tagayot ma no quinmamaltican nijín taman tanextililis de semi etic. Huan yejuan in tanextiliani huan in fariseos amo no quinequíaj momaolinisnequij para quinpalehuisque in tagayot den ne eticayot ten semi ohui. ");
INSERT INTO azzNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Huan nochi nijín quichihuaj in tanextiliani huan in fariseos sayó para ma mohueyinectinemican inixpan in tagayot. Huan yejuan sayó cuelitaj cuicasque sequin cuetaxme patauque campa ixnesi in Tajtoltzin de Dios huan moixcuatalilíaj huan momolictalilíaj. Huan no cuelitaj motaquentisque ica nintilma sentanequistoc ten cualtzin ten xojxochiyo ica icpat, huan sayó para que ma quinitacan in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Huan yejuan no quinequij de que ma yetocan campa cachi cualtzin cuac tatacuatij. Huan no semi quinequij motalisque tech in tiopan de judíos campa ne mosehuíaj in hueyi chihuanime de ne taixpampa. ");
INSERT INTO azzNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Huan no semi quinequij que in tagayot ma quinmohuiscatajpalocan tech in ojme, huan ma quinpohuacan de que melau tanextiliani. ");
INSERT INTO azzNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Huan cachi oc Jesús quinilij nijín tacaquini ijcuín: ―Namejuan ten nechtoctilíaj, amo no ijcón xicchihuacan nión no ximotecahuilican de que ma namechpohuacan in tagayot queme tamachtiani. Porín namejuan nochi nanicnime san, huan nanquipíaj sayó se Namotamachtijcau, huan Yejuatzin ne in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Huan amo no xicpohuacan nican talticpac nión aquen queme se Namohueyitajtzin, porín namejuan nanquipíaj ya ne se Namohueyitajtzin ne ten yetica nepa eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Huan amo no ximotecahuilican ma namechpohuacan queme nantayecanani, porín sayó in Cristo Temaquixtijque Yejuatzin in Namotayecancau. ");
INSERT INTO azzNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Huan naquen quintequitilía ocsequin tocnihuan, yejua ne cachi hueyi chiuque namohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Huan naquen mohuejueyichihuas, yejua ne Dios quitziquitzintiltis; huan naquen motziquitzintiltis, yejua ne Dios quihueyichihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Huan Jesús ocsepa quinnejmachtij ijcuín: ―Semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, porín nannochin nanixcuecueptocque san de namotamachilis. Porín namejuan nanquintzajtzacuilíaj in yec ojti para ma in tagayot ma amo calaquican campa Dios momasoutoc ica ihueyichicahualis. Huan namejuan nión no nanquinequij nancalaquisque. Ta, sayó nanquintzajtzacuilijtocque san ne naquen quinequij calaquisque. ");
INSERT INTO azzNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, nannochin nanixcuecueptocque san de namotamachilis; porín namejuan nanquincuilíaj nichan ne sihuacahualme. Huan no nanmotatatautilíaj ihuan Dios ica míac tajtolme para ma amo ixnesi que namejuan nantecalcuiliani. Ica ya nojón ya namejuan nanquiselisque ten cachi hueyi tatzacuiltilis. ");
INSERT INTO azzNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, nannochin nanixcuecueptocque san de namotamachilis. Porín namejuan nantayohualojtinemij nohuiyampa campa hueyíat, hasta nochi campa tzintami in talticpac para nanquinchihuasque ma ocsequin in tagayot ma taneltocacan ijcón queme namejuan nanmohuicaj. Huan namejuan cuac ijcón nanquichihuaj, ijcuacón ne tagat ten yequin taneltoca queme namejuan, yejua ne quinamiqui ma ipan huetzi se chicahuac tatelchihualis ya cachi hueyi huan que namejuan nanquiselisque. ");
INSERT INTO azzNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Huan no Jesús quinilij ne tacaquini ijcuín: ―Huan semi nanteicneltijque namejuan, porín namejuan sayó nanixpojpoyome huan nanquiyecanasnequij in ocsequin. Huan namejuan nanquinilíaj ijcuín: “Tacán acsá de namejuan moyectencahua de que quichihuas tensá huan quitenehua que: Quitztica in tiopan de Dios, yejua ne amo monequi quichihuas ten moyectencahuac ya. Pero tacán se tagat quitenehua que: Quitztica in tomin de oro ten ne yec yetoc tech ne tiopan de Dios, ijcuacón yejua nojón monequi quichihuas”. ");
INSERT INTO azzNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Namejuan nanmijmiquilome san huan nanixpojpoyome san. ¿Catiyejua cachi monequi, yej nijín tomin de oro, oso yej nijín in tiopan de Dios ten quimohuisyotilía ne tomin de oro? ");
INSERT INTO azzNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Huan no nanquijtoaj ijcuín: “Tacán acsá de namejuan moyectencahua de que quichihuas tensá huan quitenehua que: Quitztica in altar de ne taixpan tech in tiopan de Dios, ijcuacón yejua ne amo monequi quichihuas. Pero tacán se tagat moyectencahuas de que quitenehuas que: Quitztica in tomin ten monechicoa ipan in altar, ijcuacón yej nojón semi monequi ma quichihuas porín moyectencahuac ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Huan namejuan nanmijmiquilome huan nanixpojpoyome san. ¿Catiyejua cachi monequi, cox yej in tomin ten monechicohuaj, oso yej nijín altar ten quimohuisyotilía ne tomin? ");
INSERT INTO azzNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Huan ne naquen quitenehua ma “Quitztica in altar”, no quitenehua ma quitztica nochi ten quipía in altar. ");
INSERT INTO azzNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Huan naquen quitenehua ma “Quitztica ne tiopan de Dios”, amo yejua san ne tiopan de Dios. Ta, no quitenehua Totajtzin Dios ten calyetica ompa. ");
INSERT INTO azzNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Huan ne naquen quitenehua ma “Quitztica ne eluiyatzinco”, yejua ne no quitenehua de que ma quitztica ne campa tanahuatijtoc in Totajtzin Dios; huan no quitenehua de que ma quitztica Totajtzin Dios ten ompa yetica. ");
INSERT INTO azzNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Huan no Jesús quinilij in tacaquini ijcuín: ―Huan semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, nannochin nanixcuecueptocque san de namotamachilis. Namejuan nanquimactilíaj Dios ne namodiesmo den xiutzitzin san ten cualtíaj para tacualis huan pajti, queme menta huan anis huan cominos. Pero nanquisecocahuaj in tanextililisme ten cachi hueyi tech in tanahuatil de Moisés. Nanquisecocahuaj in chipaucanemilis, huan ne teyolicnelilis huan ne tacuautamatilis. Huan yejua nijín monequi ma xiccihuacan huan amo xicchihuacan de que amo nanquitemactisque namodiesmo. ");
INSERT INTO azzNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Namejuan nanixpojpoyome pero nanquinequij nantayecanasnequij. Huan namejuan nanquinnejnehuilíaj queme se tagat ten cuac tayi at, ijcuacón achto quiquixtilía moyotzitzin nijín at huan amo momaca cuenta de que cox yetoc se caballo aijtic. ");
INSERT INTO azzNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Huan semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, nanochin nanixcuecueptocque san de namotamachilis. Namejuan nanquinejnehuilíaj queme in vasos huan caxme ten quichipahuaj panían san huan taijtic temitoc míac pitzotic. Huan no ijcón namejuan nanmochijchipautocque san panían san, pero tech namoyolijtic nanpexontocque ica míac tenesi tanemililis den tachtequilis huan pitzotachihualis. ");
INSERT INTO azzNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Namejuan nanfariseos nanixpojpoyome, cachi cuali achtopa xicchijchipahuacan taijtic in vasos huan in caxme ten quipía míac pitzotic, huan ijcón mocahua nochi chipahuac ten panían huan ijticpa no. ");
INSERT INTO azzNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Huan no Jesús quinilij in tacaquini ijcuín: ―Huan semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, nannochin nanixcuecueptocque san de namotamachilis. Nanquinehuilíaj queme ne cualtzin pochicticque tepancalme ten campa ne toctocque in ánimajme. Porín yec melau ne tepancalme campa yetocque in ánimajme motaj nochi cualtzin istacque, pero taijtic pexontoc nochi omicojcotol den ne ánimajme huan temitoc míac pitzotic. ");
INSERT INTO azzNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Huan no ijcón namejuan yec melau ten nanmotaj semi nanyolcualtaca ihuan in tagayot, huan namoijticpa pexontoc de tacajcayahualis huan míac tenesi pitzotic. ");
INSERT INTO azzNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Huan semi nanteicneltijque, namejuan nantanextiliani huan namejuan nanfariseos, nannochin nanixcuecueptocque san de namotamachilis. Huan namejuan nanquinchijchihuilíaj ne tepanme campa talpachiutocque in ánimajme ten tanahuatiani de Dios. Huan no nanquicualnextíaj nanquixojxochiyotíaj in tepanme campa talpachiutocque in ánimajme den taca ten catcaj yolcualime den taneltocani. ");
INSERT INTO azzNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Huan namejuan nanquijtoaj ijcuín: “Tacán tejuan tinemisquíaj tech ne tonalme cuac nemicoj totayecancatatuan, ijcuacón amo titapalehuisquíaj para ma quinmictianij ne tanahuatiani de Dios”. ");
INSERT INTO azzNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Huan ica nijín tajtolme nancajsicamatque ya namejuan mismo huan nanmoyectenextíaj ica namotajtoluan de que namohuejcautatuan quinmictijque ne tanahuatiani. Huan namejuan no nanteconehuan de namohuejcautatuan huan nanquichihuasque ijcón queme quichiuque namotatuan. ");
INSERT INTO azzNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ica ya nojón xictamichihuacan ya axcan ten ne achtopa quichiuque namotayecancatatuan. ");
INSERT INTO azzNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Namejuan nantajcajcayahuani san huan nannemij queme cohuame huan queme tepiluan de cohuame. ¿Quenín ijcón huelis nanmopalehuisque huan nanmomaquixtisque de ne hueyi tatelchihualis ten namechuicas mictan? ");
INSERT INTO azzNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Huan ijcón ocsepa Jesús quinilij ijcuín: ―Ica ya nojón namechinualtitanilis sequin tanahuatiani de Dios, huan sequin tamachilejque de Dios, huan tanextiliani den yancuic tanahuatil de Dios. Pero namejuan nanquinmictisque huan nanquincuoupampilosque, huan ocsequin nanquinuitequisque tech in tiopan de judíos. Huan no nanquintahuelitasque huan nanquincalanquixtisque cada se pueblo campa ajsisque. ");
INSERT INTO azzNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ica ya nojón namotech huetzis ne tatzacuiltilis de Dios, porín nanquinmictijtinenque ya nohuiyan nijín taca naquen chipaucanemíaj. Huan nanquinmictijtinenque in yolcualime desde ne achtopa tonal cuac quimictijque ne Abel ten yolchipahuac catca, huan hasta campa nemico in Zacarías teconeu de Berequías, naquen quimictijque ne tiopanijtic campa ne altar tamohuisyojcan. ");
INSERT INTO azzNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","De yec melau ten namechilía que in tatzacuiltilis de Dios ninpan huetzis in tagayot den axcan nemij. Huan huetzis ne hueyi tatzacuiltilis de Dios porín ne tajtacol de namejuan huan porín ne tajtacol de namotayecancatatuan temictiani. ");
INSERT INTO azzNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Huan Jesús quinilij ijcuín: ―Namejuan nanpueblojuani de Jerusalén, namejuan nanquinmictíaj in tanahuatiani de Dios, huan nanquintepoxoníaj ne itanojnotzcahuan de Dios, naquen Dios namechualtitanilij. ¿Canachpa nicnequía namechsentilis para namechyecanas namejuan, nanpueblojuani de Jerusalén? Huan no nicnequía namechpalehuisquía ijcón queme in piotapachojque quinsentilía nipiluan yej tapaltampa, huan amo nanquinecque ma namechpalehuis. ");
INSERT INTO azzNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Xiquitacan, namejuan, Dios namechsencahuac ya axcan, namejuan namochancahuan huan namopueblojcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Huan no namechilía que amo queman nannechitasque oc. Ta, sayó ijcuac ne tonal cuac namejuan nanmoyolnemilisque huan nannechilisque de Nejuatzin ijcuín: “Tejuatzin Tiontatiochihual de Dios, huan tihualajtoc itencopa Tohueyitayecancatajtzin Dios”. ");
INSERT INTO azzNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Huan ijcón cuac Jesús quisteu den tiopan de judíos huan yaya ocseco, ijcuacón motoquijque imomachtijcahuan huan quinequíaj quinextilisque in hueyi mohuistic tiopan huan ne tepan calicxime ten cualtzitzin. ");
INSERT INTO azzNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Huan Jesús quinnanquilij ijcuín: ―Namejuan nanquitztocque nochi nijín, pero de yec melau ten namechilía que nican campa tiopan amo teyi mocahuas oc, nión se tet ten nanquitaj axcan sajsaliutocque huan nejnepaniutocque huan que amo huejuelihuisque oc. ");
INSERT INTO azzNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Huan ijcón in Jesús yajqui motalito tech ne tal lomojtzin ten monotza Olivos, huan imomachtijcahuan quichtacanojnotzacoj huan quilijque ijcuín: ―Xitechonili, ¿queman huejuelihuis nijín tiopan calicxime? ¿Huan toni nescayome oncas cuac Tejuatzin timohualuicas nican talticpac, cuac tamis ya in talticpac? ");
INSERT INTO azzNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ijcuacón in Jesús quinnanquilij ijcuín: ―Ximoyecpiacan huan ma amo aquen namechyolcajcayahua tech namotaneltocalis. ");
INSERT INTO azzNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Porín hualasque míac tacajcayahuani huan ijcón míac quincajcayahuasque, porín yejuan quijtojtinemisque ijcuín: “Nejua ya ni Cristo Temaquixtijque”, huan ijcón miacque quincajcayahuasque. ");
INSERT INTO azzNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Huan namejuan cuac nanquicaquisque den ne tehuilis huan cuac ongas míac moucayot de ne tehuilis, ijcuacón amo ximoyolmoutican, porín ipa ijcón monequi ma mochihua; pero no xicmatican que ayamo yej ne in tamilis den talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Huan tech ne tonalme pehuas moajocuisque pueblojuani huan motehuisque se huan ocsé pueblojuani, huan in tagayot den se país moajocuisque huan motehuisque se huan ocsé tagayot. Huan oncas míac cocolis huan míac máyanti huan talolinilis; huan nochi nijín mochihuas nohuiyampa tech in senmanahuac. ");
INSERT INTO azzNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Huan cuac nochi nijín mochihuas ya, yej ne quijtosnequi que yequin peutiu mochiutiu hueyi tajyohuilis para nochi in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Huan ijcuac ne tonal namechtemactisque para ma namechcojcocan huan para ma namechmictican. Huan nochi in tagayot ten amo taneltocaj, yejuan ne namechtahuelitasque porín namejuan nanyectacuautamatij nohuan itech notocaytzin. ");
INSERT INTO azzNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ijcuacón ne tonalme miacque taneltocani quipolosque nintacuautamatilis de Nejuatzin nohuan. Huan se huan ocsé motahuelitztinemisque, huan se huan ocsé motemactisque ihuan in tequihuani tech ne ninpueblojuan. ");
INSERT INTO azzNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Huan miacque monextisque naquen xolopijtijtinemisque huan quijtojtinemisque que yejuan ya tanahuatiani de Dios huan ijcón quincajcayahuasque miacque taneltocani. ");
INSERT INTO azzNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Huan ijcón momiactilis míac ten amo cuali tachihualisme, huan ica nojón miacque taneltocani quicahuasque ne tasojtalis se huan ocsé. ");
INSERT INTO azzNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Pero naquen quisentocas yec tacuautamatis itech Cristo, hasta ne tonal cuac tamis in talticpac, yejua ne quipías ne maquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Huan cuac motamitetapohuis ya tech nochi senmanahuac nijín yancuic Tajtoltzin de que Dios momasoutoc ica ihueyichicahualis, huan no cuac quintaminejmachtisque ya nochi in talticpacuani, ijcuacón xicmatican que ejcotihuitz ya in tamilis den talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Huan naquen quileeroa nijín Tajcuilolamatzin de Dios den tanahuatijque Daniel, monequi ma cajsicamatican. Porín in tanahuatijque Daniel, yejua ne queman ya quijtojca de que nanquitasque que mochihuas ya ne tetzaucapolihuilis campa amo monequía yetosquía, ten quitzojcuilotía ompa tech in tiopan de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Huan no ijcón Jesús quinilij imomachtijcahuan ijcuín: ―Huan nochi ne naquen calyetosque tech ne Judeajcopaca, yejuan nojón monequi ma cholocan, huan ma yacan huan ma motatican campa ne tepepan. ");
INSERT INTO azzNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huan ijcón ne naquen yetosque calcuaco den nichan, ma amo temo oc para calaquis ichan huan quixtis tensá ten niaxca. ");
INSERT INTO azzNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Huan ijcón ne naquen yetosque itequitiyan, ma amo no quinemilican de que mocuepacan inchan de que ma quicuiti nintilma. ");
INSERT INTO azzNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Huan cachi teicneltijque in sihuatzitzin ne ten cocoxcayetosque ica pili; huan teicneltijque sihuatzitzin ne naquen tachijchitijtosque ica coneme itech ne tonalme. ");
INSERT INTO azzNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ica ya nojón ximotatatautilican ihuan Dios que ne tonal cuac monequis nancholosque, ma amo namechajsi cuac taseseyas, oso cuac ne tonal de nesehuilis cuac amo quitecahuiliaya ma nejnentosque. ");
INSERT INTO azzNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Porín ne tonalme oncas cachi hueyi tajyohuilis ten amo queman nanquitacque desde cuac tzinpehuac in talticpac. Huan amo queman oncas oc satepan ocsé tajyohuilis queme nijín ten nanquipanosque. ");
INSERT INTO azzNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Huan queme in Totajtzin Dios amo quitocotzos oc in tajyohuilis de ne tonalme, ijcuacón amo aquen huelis maquisas. Pero Totajtzin Dios quitocotzos in tajyohuilis de ne tonalme porín Dios quintasojta naquen Yejuatzin quinijitac ya ma pohuican ihuantzin. ");
INSERT INTO azzNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Huan tacán acsame namechilisquía ijcuín: “Xiquitacan, nepa yetoc in Cristo Temaquixtijque”, oso namechilisque: “Xiquitacan, tiyohue tiquitatij campa yetoc in Cristo Temaquixtijque”, pero amo xiquinneltoquilican ne tacajcayahuani. ");
INSERT INTO azzNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Porín miacque tacajcayahuani moajocuisque huan hualasque huan quijtojtinemisque que yejuan in Cristo Temaquixtijque huan yejuan tanahuatiani de Dios. Huan yejuan quichihuasque miacque mohuiscatequit huan no quichihuasque tatiochihualisme ica mohuisyot, para que ijcón cachi huelis quincajcayahuasque in taneltocani. Huan achá no quincajcayahuasque hasta itaijitaluan de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Huan nochi nijín namechilía ya achtopa que mochihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Huan no Jesús quinnextiliaya imomachtijcahuan ijcuín: ―Ica ya nojón como namechilisque in tacajcayahuani ijcuín: “Tiyohue tiquitatij in Cristo, nepa yetoc campa tayiucan”, amo xiyacan. Oso no namechilisque: “Tiyohue tiquitatij ne calijtic porín ompa yetoc in Cristo”, pero amo no xiquinneltoquilican nojón tacajcayahuani. ");
INSERT INTO azzNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Huan ijcón queme nanquitaj de que tapetani ica ne ticohuat nepa iquisayampa tonal huan tamiti hasta ipolihuiyampa in tonal, no ijcón Nejuatzin nannechitasque tech ne tonal cuac Nejuatzin ni Yectagatzin nimohualuicas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","No ijcón campa yesqui huetztos se miquet, no ompa mosentilíaj míac tzojpilome. Porín tzojpilome cuali quimatij can huetztoc in miquet huan ompa moijsiucasentilíaj. Xicmatican de que no ijcón mosentilijtihuetzisque notaneltocacahuan cuac Nejuatzin ni Cristo nimohualuicas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Huan no Jesús quinnextiliaya imomachtijcahuan ijcuín: ―Huan ijcón tech nojón tonalme nimanpa den ne hueyi tajyohuilis, ijcuacón in tonaltzin tayohuayantis huan amo tanextis oc, huan in metzti amo no tahuis oc, huan in sitalinme tepehuisque den eluiyac. Huan in chicaucatayecanani de nemij ne ejecaixco, yejuan nojonques Dios quintzetzelos. ");
INSERT INTO azzNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Huan ijcón nanquitasque ne ejecaixco se nescayot den ica monextilis de que nihualajtoc ya Nejuatzin ni Yectagatzin. Ijcuacón nochi in talticpacuani mochoctisque huan nechitasque nejua ni Yectagatzin cuac Nejuatzin nihualajtos ya mixtzalan tech ne ejecaixco, huan cualtzin nipetantihualas ica in hueyi chicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Huan in Dios quinualtitanis in ángeles taquehualme de Dios ica se hueyi tzajtzilis den tapitz, huan ijcón quinsentilisque nochi ne notaijitaluan nochi tech in se manahuac desde campa tzinehua in talticpac huan in eluiyac huan hasta ne campa tzintami. ");
INSERT INTO azzNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Namechilía de que ximoyecajsicamatiltican de nijín nexcuitil den higoscuohuit. Huan cuac nanquitasque que cualtzin maxoxohuixtoc ya in higoscuohuit, ijcuacón nanquimatisque ya de que ejcotoc ya in tonalme den tatotoncayot. ");
INSERT INTO azzNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Huan ijcón cuac no nanquitasque de que mochiutoc ya nochi nijín nescayome ten namechiluijca ya ne achtopa, ijcuacón xicmatican que niyetoc ya caltenteno ya para nihualas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","De yec melau ten namechilía de que nochi nijín nescayome mochihuas achtopa ya de que miquisque in tagayot ten axcan nemij. ");
INSERT INTO azzNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Huan masqui in talticpac huan in eluiyac tajtamis, pero notajtoltzitzin amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan ijcuac ne tonal de nohualalis amo aquen quimatis. Hasta itaquehualuan de Dios in ángeles ten yetocque ne tech eluiyac amo no quimatij de ne tonal cuac Nejuatzin nimohualuicas. Ta, sayó quimatos Tohueyitajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Huan ijcón queme ne tonal cuac nemico in tanahuatijque Noé, no ijcón mochihuas cuac Nejuatzin nimohualuicas ni Yectagatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Huan tech ne tonalme cuac nemico Noé achtopa que hualasquía ne hueyi tetzaucaquiohuit, ijcuacón nochi in tagayot tatacuajtoyaj san, huan ocsequin motahuantijtoyaj san. Huan in ocsequin tetatme huan tenanme quinijtantoyaj san ne teichpochuan para ma monamictican. Huan ijcón mochiutihualaya hasta cuac Noé calayic tech in hueyi barco ten monotza arca. ");
INSERT INTO azzNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Huan in tagayot amo quineltocacque de que hualasquía ne tetzaucaquiohuat. Pero satepan cuac huala ya, ijcuacón nochi quinuiyac huan moaelsimijque. Huan ijcón no tech ne tonalme ijcón yesqui, cuac nimohualuicas Nejuatzin ni Yectagatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Huan tech ne tonalme tequititosque ome taca tech in mila, huan se tequitique Dios cajocuis huan ocsé mocahuas. ");
INSERT INTO azzNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Huan no ijcón ome sihuame yetosque campa molino tixcuechojtosque, huan se sihuat Dios cajocuis huan in ocsé mocahuas. ");
INSERT INTO azzNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ica ya nojón ya xiyecyectocan huan xitachixtocan, porín amo nanquimatij toni horas hualas Namotayecancateco Jesucristo. ");
INSERT INTO azzNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Huan xicmatican nijín: Tacán quimatisquía in tetat de que toni hora hualasquía in tachteque, ijcuacón ne tetat achá moyejyectalijtosquía, huan ijsatosquía, huan amo mocahuasquía ma quicaltapocan para quitachtequisque. ");
INSERT INTO azzNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ica ya nojón ya namejuan no ximoyejyectalijtocan, porín Nejuatzin ni Yectagatzin nimohualuicas ya cuac namejuan amo nanyoltanemilijtosque nión no nannechchixtosque. ");
INSERT INTO azzNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Huan ijcón in Jesús quinmachtiaya imomachtijcahuan ica nexcuitil ijcuín: ―Huan axcan namechtapohuiti de se taquehual ten yolcuali huan ten cuatamatque. Huan nipatrón de ne taquehual den tatequitiltijque den ocsequin taquehualme, huan ma yejua tanahuati ma quintamacacan cuac ne hora de tacualis. ");
INSERT INTO azzNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Huan ijcón ne tayecancataquehual tatiochihual yesqui porín cuac ejcos nipatrón, ijcuacón cajsiquiu quichiutoc ten quinajnahuatijteu. ");
INSERT INTO azzNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","De yec melau ten namechilía, ne patrón quicahuilis ne itayecancataquehual ma yejua quinyecana in ocsequin taquehualme huan nochi ne ten niaxca. ");
INSERT INTO azzNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Pero no namechtapohuiti de se tayecancataquehual ten amo yolcuali. Huan moyolíaya yejua san ijcuín: “Nopatrón huejcahuati huan amo niman ejcos”. ");
INSERT INTO azzNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ijcuacón ne tayecancataquehual pehuac quintajyohuiltía in ocsequin taquehualme, huan no pehuac tatacuati san, huan no pehuac tahuana ihuan in tahuanani. ");
INSERT INTO azzNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Huan ijcón in patrón ejcoc tech ne tonal cuac ne itayecancataquehual amo quichixtoc, porín yejua amo quimatía toni hora ejcosquía nipatrón. ");
INSERT INTO azzNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Huan ijcón in patrón quichicaucatatzacuiltis ne taquehual ten amo yolcuali. Huan quitelchihuas, huan quititanis ma tajyohuiti ihuan ne taca ten ne yolcuecuepme san. Huan ompa chocatosque huan tannanatzocatosque tech ne tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Huan ijcón in Jesús quinilij imomachtijcahuan ocsepa se nexcuitil ijcuín: ―Nicnejnehuililtía májtacti ichpochme queme ichicahualis de Dios cuac Yejuatzin momasoutoc ica ihueyichicahualis se iyolijtic. Huan nijín májtacti ichpochme quicuicque ne nintahuiluan huan quisque para quinamiquito ne teyoquich ten monamictiti ya. ");
INSERT INTO azzNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Huan macuilime ichpochme catcaj yec tanemiliayaj, huan in ocsequin macuil ichpochme amo yec tanemiliayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Huan in macuilime ichpochme ten amo yec tanemiliayaj, yejuan quicuicque nintahuiluan huan yajque huan amo cuiyacque míac gas para ocsepa quinpexontisquíaj nintahuiluan cuac tamisquía in gas. ");
INSERT INTO azzNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Huan in macuil ichpochme naquen yec tanemiliayaj, yejuan nojonques quicuicque nintahuiluan huan no cuiyacque míac gas para ocsepa quinpexontisquíaj nintahuiluan. ");
INSERT INTO azzNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Huan in teyoquich semi huejcahuac para ejcos; huan ne ichpochme yejuan mocuahuihuicayaj ica cochilis huan niman ixcojcochíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Huan ijcón ne tajcoyohuan ya cuac mocayic se tzajtzilis, ijcuacón quijtoayaj ijcuín: “Pon huitza ya in teyoquich; niman xiquisacan xiyacan huan xicnamiquitij porín Yejuatzin hualajtoc ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Huan ijcón nochi ne ichpochme meuque huan moquetzque huan peuque quixotaltía nintahuiluan. ");
INSERT INTO azzNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Huan in macuil ichpochme ten amo yec tanemiliayaj, yejuan quinilijque in ocsequin ichpochme ijcuín: “Xitechonmacacan sequin namogas porín tejuan totahuiluan sehuisnequij porín tamic ya in gas”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ijcuacón in macuil ichpochme ten yec tanemiliayaj, yejuan tananquilijque ijcuín: “Amo huelis tamechmacasque porín tacán tamechmacaj, ijcuacón amo no ajsis para tejuan. Cachi cuali xiyacan campa quinamaca huan ompa xicohuacan para namejuan”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Pero cuac yajque ya quicohuatoj ya ne in gas ne macuil ichpochme ten amo yec tanemiliayaj, ijcuacón ejcoc ne teyoquich. Huan in macuil ichpochme ten yec tanemiliayaj huan ten moyejyectalijque ya, yejuan calacque ihuan ne teyoquich campa nenamictilis. Huan niman quitzacuacque in puerta. ");
INSERT INTO azzNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Huan cachi satepan ejcocque ne ocsequin macuilime ichpochme ne ten amo moyejyectalijtoyaj huan quijtoayaj ijcuín: “Totecotzin, Totecotzin, xitechontatapohuili”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Huan ne teyoquich quinnanquilij ijcuín: “Yec melau ten namechilía que amo namechixmati aconi namejuan”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Huan ijcón in Jesús quintaminojnotzac ya in tagayot huan quinilij ijcuín: ―Amo xicchihuacan queme ne ichpochme ne ten amo yec tanemiliayaj. Ta, xiijsatocan huan xitatachixtocan porín amo nanquimatisque catiyejua tonal nión catiyejua hora nimohualuicas Nejuatzin ni Yectagatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Nicnejnehuililtía se patrón queme ichicahualis de Dios cuac Yejuatzin momasoutoc ica ihueyichicahualis se iyolijtic. Huan ne patrón quinemilijtoc de que paxolotiu tech ocsé pueblo. Huan cuac ejcoc ya in tonal de que quisas ya, ijcuacón quinnotzac itaquehualuan huan quinmajmactilijtehuac nitomin cada se taquehual. ");
INSERT INTO azzNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Huan senme de ne taquehualme quimactilij macuil mil monedas de istac tomin; huan ocsé quimactilij ome mil; huan in ocsé quimactilij se mil. Huan yejua ijcón quinmactilij in tomin ijcón queme quinitac de cada se den quipíayaj huelilis para tequitisque. Huan de ompa in patrón yajqui paxaloto huejca tech ocsé país. ");
INSERT INTO azzNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Huan in taquehual ten quiselij in macuil mil monedas de tomin, yejua ne quicuic in tomin huan yajqui quitequitiltito ne tomin huan quitanic ocsé macuil mil monedas de tomin. ");
INSERT INTO azzNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Huan no ijcón ne taquehual ten quiselij ome mil monedas de tomin, no ijcón quichihuac huan quitequitiltito ne tomin huan quitanic ocsé ome mil monedas de tomin. ");
INSERT INTO azzNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Huan ne taquehual ten quiselij se mil san, yejua nojón yajqui tachcuato huan ompa quipantalito in tomin den quimactilijca ya nipatrón. ");
INSERT INTO azzNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Huan panoc míac tonalme huan ijcón mocuepac ne inpatrón de ne taquehualme, huan quinemilij in patrón quitepotztocati nijín tahuicalis de ne eyi taquehualme. ");
INSERT INTO azzNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Huan ijcón mochihuac que achtopa ejcoc in taquehual ne den quiselijca macuil mil monedas huan quimactij nipatrón ocsé macuil mil ten quitanic ya huan quilij ijcuín: “Notecotzin, tejuatzin tinechonmactilijca macuil mil monedas de tomin, pero nican yetoc ocsé macuil mil ten nictanic ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ijcuacón in patrón quinanquilij ijcuín: “Cuali yetoc, tejuatzin, titaquehual den semi tiyolcuali huan cuali titequitique, porín cuali tictequitiltij ya in tepitzin in tomin ten nimitzmactilijteuca ya. Ica ya nojón tejua nimitztalis tinotayecancataquehual, huan yequintzin xipano tech nochantzin huan cuali ma tisentequitican huan ma timosenpanyolpactican”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Huan de ompa ejcoc in taquehual ten quiselijca ome mil monedas huan quilij ne ipatrón ijcuín: “Notecotzin, tejuatzin tinechonmactilijca ya ome mil monedas, pero axcan nican nimitzualcuilía ocsé ome mil ten nictanic ya”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ijcuacón in patrón quinanquilij ijcuín: “Cuali yetoc, tejuatzin, titaquehual ten semi tiyolcuali huan cuali titequitique porín cuali tictequitiltij ya in tomin masqui tepitzin san ten nimitzmactilijteuca. Ica ya nojón nimitztaliti tejua tinotayecancataquehual. Huan yequintzin xipano tech nijín nochantzin huan cuali ma tisentequitican huan ma timosepanyolpactican”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Huan de ompa ejcoc ne taquehual ten quiselijca se mil san monedas de tomin huan quilij ne ipatrón ijcuín: “Notecotzin, nejua nicmatía que tejuatzin chicahuac tiquintequitiltía motaquehualuan, huan tejuatzin nicmatía de que ticajocui taquilome campa amo tictocac huan ticololoa xinach campa amo teyi tictepehuac. ");
INSERT INTO azzNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Huan nicmohuilij ne chicaucatequit. Ica ya nojón nicuic in tomin huan nicuiyac nictalpachoto tech se talcomit. Huan axcan nican yetoc nijín motomin ten tinechmactilijteuca ya; xiconcui ten moaxca”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ijcuacón in patrón quinanquilij in taquehual ne ten amo yolcuali huan quilij ijcuín: “Tejua semi titatziu porín ticmatoya ya de que nicajocui taquilome campa amo nictocac, huan nicololoa campa amo teyi nictepehuac. ");
INSERT INTO azzNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ica ya nojón cachi cuali xictemacani oso xicalaquiani tech se banco campa notomin huelisquía quitequitiltisquíaj ne taca naquen tiquinmactilisquía. Huan ijcón cuac nimocuepasquía, ijcuacón nicselisquía notomin ihuan ten motanilij ya notomin”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Huan ijcón in patrón quinilij in ocsequin taquehualme ijcuín: “Xicuilican de ne tatziu ne se mil monedas de tomin huan xiquinmactilican ne naquen quipía májtacti mil monedas. ");
INSERT INTO azzNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Huan nochi ne naquen quipíaj in tamachilisme de Dios huan quitequitiltíaj, yejuan nojonques cachi oc Dios quinmactilis. Huan nochi ne naquen quipíaj sayó tepitzin san tamachilisme de Dios huan amo quitequitiltisque in tepitzin san ten quipíaj, yejuan nojonques Dios quitamicuilis ne den tepitzin san ten quipíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Huan ne taquehual ten tatzihuic nimantzin xicuiyacan huan xicalantamotacan ne campa tayohuayanijtic huan ma ompa chocato huan ma ompa tannanatzocato tech ne tajyohuilis”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan ijcón Nejuatzin ni Yectagatzin nimohualuicas ica chicahualis queme hueyi chiuque de rey, nechyehualojtihualasque nochi niángeles itaquehualuan in Totajtzin Dios. Huan Nejuatzin nimotalis tech ne nomohuiscasehuilojcan campa ne notaixejecocan huan campa ne no tacualtzincan. ");
INSERT INTO azzNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Huan ijcón in ángeles quinsentilisque nochi in pueblojuani de nochi pueblojme den talticpac noixpantzinco Nejuatzin. Huan Nejuatzin ni Cristo niquinsejsecotalis se huan ocsé, ijcón queme ne tapixque quinsejsecotalía in ichcame huan in chivos. ");
INSERT INTO azzNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Huan Nejuatzin ni Cristo niquinyectalis noyecmacopaca in ichcame; huan in chivos niquintalis noopochcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Huan ijcón Nejuatzin nitayecanque niquinilis naquen yetosque noyecmacopaca ijcuín: “Xihualacan nohuan namejuan, porín nantatiochihualme den Notajtzin Dios. Huan xicselican nijín yec yetolis nepa eluiyactzinco ten Totajtzin Dios ne campa nanyetosque namejuan. Ipa namechchijchihuilij ya desde ne tonal cuac tzinpehuac in talticpac”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Huan Nejuatzin ni Yectagatzin no niquinilis ne naquen yetosque noyecmacopaca ijcuín: “Nejuatzin cuac nimayanaya, ijcuacón namejuan nannechtamacacque. Huan cuac nimocaltajtaniaya, ijcuacón namejuan nannechmacacque can nimocuasehuis. ");
INSERT INTO azzNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Huan no cuac amo nicpiaya notilmajtzin, ijcuacón namejuan nannechtaquentijque. Huan cuac nimococoaya ya, ijcuacón namejuan nannechcalpanotoj. Huan cuac niyetoya cárcelijtic, ijcuacón namejuan nanualajque nannechitacoj”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Huan ne naquen yolchipauque quinanquilisque ijcuín: “Totecotzin, ¿catiyejua tonal timitzitacque cuac timayancanemía huan timitztamacacque? ¿Huan catiyejua tonal timitzitacque cuac tiamiquía huan timitzatiltijque? ");
INSERT INTO azzNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Huan catiyejua tonal timitzitacque cuac timocaltajtaniaya huan tejuan timitzmacacque can timosehuis? ¿Huan catiyejua tonal timitzitacque cuac amo ticpiaya motilma huan tejuan timitztaquentijque? ");
INSERT INTO azzNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Huan catiyejua tonal timitzitacque cuac timococoaya ya oso cuac tiyetoya tech in cárcelijtic huan tejuan timitzitatoj?” ");
INSERT INTO azzNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Huan in Jesús in tayecanque quinnaquilis ijcuín: “De yec melau ten namechilía que nochi ten yesqui tapalehuilis ten nanquichiuque para nijinques nocnihuan masqui nocnihuan amo quipiayaj tenica ixpanosque, pero nochi nijín nanquichiuque para Nejuatzin”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan de ompa in tayecanque quinilis naquen yetosque iopochcopaca ijcuín: “Xicnechtapatahuilican, namejuan den nantatelchihualme ya, huan xiyacan tech ne tit ten amo queman sehuis campa Dios quichijchihuac ya para in amocuali huan para nitaquehualuan. ");
INSERT INTO azzNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Huan ompa xiyacan porín cuac nimayanac, namejuan amo nannechtamacacque. Huan cuac niamiquía, namejuan amo nannechatiltijque. ");
INSERT INTO azzNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Huan cuac nimocacaltajtaniaya, namejuan amo nannechmacacque can nimosehuis. Huan cuac nechpoloaya notilmajtzin, namejuan amo nannechtaquentijque. Huan cuac nejua nimococoaya huan niyetoya cárcelijtic, ijcuacón namejuan amo no nannechcalpanotoj”. ");
INSERT INTO azzNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ijcuacón in taca den tatelchihualme quinanquilisque ijcuín: “Totecotzin, ¿quemanían timitzitacque ay timayancanemi oso tiamictinemi oso mitzpoloaya motilma, oso timococoaya, oso tiyetoya tech in cárcel huan amo timitzpalehuijque?” ");
INSERT INTO azzNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Huan ijcuacón Jesús in tayecanque quinnanquilis ijcuín: “De yec melau ten namechilía, nochi ten yesqui tapalehuilis ten amo nanquichiuque ihuan nijín nocnihuan ten amo quipiayaj tenica ixpanosque, no ijcón amo para nejua nanquichiuque. ");
INSERT INTO azzNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Huan nochi namejuan den tatelchihualme nantamelahuasque campa ne tatzacuiltilis ten amo queman tamis. Huan nochi namejuan den nanyolcualime nantamelahuasque campa ne nemilis nachipa”. ");
INSERT INTO azzNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Huan cuac Jesús quintaminextilij ya nochi nijín nexcuitil, ijcuacón quinilij imomachtijcahuan ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","―Huan cuali nanquimatocque ya que nican ome tonalica mochihuas iluit den tajyohuilis huan Nejuatzin ni Yectagatzin nechtemactisque para ma nechcuoupampilocan. ");
INSERT INTO azzNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Huan ijcón in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés huan in huehuentzitzin den pueblojuani judíos, nochi nijinques mosentilijque icalteno ne tayecanque tiopixcat ten monotza Caifás. ");
INSERT INTO azzNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Huan ompa moixejecoltijque se huan ocsé quenín para quiquitzquisque queme preso in Jesús ica tacajcayahualis para quimictisque. ");
INSERT INTO azzNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Huan no quinemilijque ijcuín: ―Cachi cuali ma amo ticchihuacan axcan, porín mochiutoc ne hueyi iluit den tajyohuilis huan para ma amo moyolcuecuejmolocan in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Huan Jesús yetoya tech ne pueblo Betania campa calyetoya ne Simón naquen Jesús quipajtijca ya den ninacayo pajpalanía. ");
INSERT INTO azzNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Huan motoquij se sihuat campa Jesús tacuajtoya huan quicuaojxilij aceite ica se istaccomit ten pexontoya ica aceite ten cualtzin ajuiyac huan ten semi patío. ");
INSERT INTO azzNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Huan cuac imomachtijcahuan quitacque ten quichihuac ne sihuat, ijcuacón yejuan yolcualanque huan peuque quilíayaj ijcuín: ―¿Queyé, tejua sihuat, ijcón ticchihua? Ticahuiloj nijín ajuiyacayot. ");
INSERT INTO azzNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ta, cachi cuali ma ticnamacanij ica míac tomin huan ica nijín tomin tiquinpalehuisquíaj in taca ten amo teyi quipíaj ten cuasque. ");
INSERT INTO azzNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Huan cuac ijcón quijtoayaj, ijcuacón in Jesús quicayic huan quinilij ijcuín: ―¿Queyé nanquicuejmoloaj nijín sihuatzin? Porín nochi nijín ten nechchihuilía, se cuali tequit. ");
INSERT INTO azzNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Porín xicmatican de que nachipa namohuan yetosque ne naquen amo teyi quipía ten cuasque. Pero nejua amo nachipa namohuan ninemis nican. ");
INSERT INTO azzNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Huan nijín sihuat nechcuaojxilijtoc ica nijín aceite den ajuiyacat, huan nijín quichihuac para ne tonal cuac nechtalpachotihue tech ne ánimajcal. ");
INSERT INTO azzNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","De yec melau ten namechilía que campa yesqui motetapohuis nijín yancuic tanahuatil de Dios tech nochi se manahuac, no ijcón motetapohuis de nijín sihuatzin ten quichihuac axcan, huan ica nijín quelnamiquisque ne sihuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Huan senme den majtactiomomen imomachtijcahuan ten monotza Judas Iscariote, yejua ne yajqui quinnojnotzato in tayecanani tiopixcame. ");
INSERT INTO azzNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Huan Judas quinilij ijcuín: ―¿Canachi tomin nannechmacasque para que ma nejua namechmacti Jesús Temaquixtijque? Huan in tayecanani quinanquilijque ijcuín: ―Timitzixtahuilisque sempoal huan májtacti ica ne istac tomin denario ―yesqui queme valeroa eyi ciento pesos. ");
INSERT INTO azzNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Huan cuac in Judas quiselij ya in tomin, ijcuacón yejua pehuac tech ne tonal de que quitemojtinemía para quenín huelis quitemactis in Jesús inmaco in tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Huan ijcón queman ajsic ya ne achto tonal den iluit den tajyohuilis cuac quicuayaj pan ten amo quipía tamajmahuilis de levadura, ijcuacón motoquijque imomachtijcahuan huan quitajtoltijque Jesús ijcuín: ―¿Can timonequiltía ma timitzchijchihuilitij in tacualis para titacuasque tech ne iluit den tajyohuilis? ");
INSERT INTO azzNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ijcuacón in Jesús quinnanquilij ijcuín: ―Xiyacan tech ne pueblo huan xiajsican ichan se tagat huan xiquilican ijcuín: “In Tamachtijque quijtoa que ejcotoc ya ne hora de notajyohuilis huan tech mochantzin nejua nicnequi ma ticchihuacan ne iluitzin den tajyohuilis ihuan nomomachtijcahuan”. ");
INSERT INTO azzNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Huan imomachtijcahuan yajque quichihuatoj ijcón queme Jesús quinnajnahuatij ya, huan ompa quichijchiuque in tacualis para se iluit den tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Huan cuac ne tapoyauteno ya, Jesús motocotzojtzino huan tacuaj ihuan ne majtactiomome imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Huan cuac ne tacuajtoyaj ya, ijcuacón Jesús quinilij ijcuín: ―Yec melau ten namechilía de que senme de namejuan nechtemactis inmaco in tayecanani para nechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ijcuacón semi moyolcocoayaj ne imomachtijcahuan huan peuque quimatajtoltíaj se huan ocsé huan quilijque ijcuín: ―Notecotzin, ¿xon amo nejua? ");
INSERT INTO azzNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Huan Yejuatzin quinnanquilij ijcuín: ―Ne naquen pantajaquis tech noplato, yejua ne naquen nechtemactis. ");
INSERT INTO azzNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Yec melau Nejuatzin ya ni Yectagatzin niyás nimomiquilitiu ijcón queme quijtoa in Tajcuilolamatzin. Pero cachi teicneltijque ne tagat naquen nechtemactis Nejuatzin ni Yectagatzin; cachi cuali nojón tagat ma amo yolini nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ijcuacón tananquilij in Judas ten quitemactij Jesús huan quilij ijcuín: ―Notamachtijcau, ¿xe nejua yesqui nimitztemactis? Huan Jesús quinanquilij: ―Quema, como tejua ijcón tiquijtoa. ");
INSERT INTO azzNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Huan cuac tacuajtoyaj ya, ijcuacón Jesús quicuic in pan huan quitasojcamachilij Ihueyitajtzin, huan satepan quicojcotonac in pan huan quinmajmacac imomachtijcahuan. Huan de ompa quinilij ijcuín: ―Xicuacan nijín pantzin; yejua ne nonacayo. ");
INSERT INTO azzNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Huan de ompa quicuic ocsepa se vaso de vino huan quitasojcamachilij Ihueyitajtzin. Huan quinmajmacac imomachtijcahuan huan quinilij ijcuín: ―Xitayican nijín vino nochi namejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Porín nijín vino yejua ne noesyotzin. Huan ica nijín vino quitenextía que nimoyectencauca ya ihuan Notajtzin Dios de que mimilahuis noesyotzin, para que ijcón ixnesis que Dios quintapojpoluía miacque den tajtacolejque. ");
INSERT INTO azzNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Pero namechyecquilía que amo ocsepa nitayis oc nijín vino, hasta queman ne tonal cuac tisentayisque cuac Notajtzin Dios momasoutoc namoyoljtic ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Huan queman tami cantarojque ya se himno, ijcuacón nochin quisque de ne cali huan yajque campa se tepepan de monotza Olivos. ");
INSERT INTO azzNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Huan ompa Jesús quinilij ijcuín: ―Nochi namejuan nanmomoutisque huan nanmoyolxocolisque porín Nejuatzin tech nijín yohual. Porín ijcón ijcuiliutoc tech in Tajcuilolamatzin de Dios ten quijtoj ijcuín: “Nicojcocos in tapixque huan niichcahuan sejseyacan yasque”. ");
INSERT INTO azzNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Huan satepan cuac nipanquisas ya niyoltoc intzalan in ánimajme, ijcuacón Nejuatzin niyás namechyecantíyas hasta ne Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Huan Pedro quinanquilij ijcuín: ―Masqui nochi in tagayot momoutisque huan yolcualanisque por tejuatzin, pero nejua amo. ");
INSERT INTO azzNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Huan ijcón in Jesús quilij ijcuín: ―Yec melau ten nimitzilía que tejua axcan tech nijín tayohuac achtopa que tzajtzis in piotzin, tejua titeilis expa que amo tinechixmati. ");
INSERT INTO azzNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pero in Pedro quilij: ―Melau masqui mohuan ma nimiquiti, pero amo niquijtos de que amo nimitzixmati. Huan nochi ijcón quijtojque imomachtijcahuan se huan ocsé. ");
INSERT INTO azzNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Huan ijcón ajsicque Jesús ihuan imomachtijcahuan campa itech se xocomila ten monotza Getsemaní. Huan ompa Jesús quinilij ijcuín: ―Ximosehuican nican huan Nejuatzin niyó cachi taixpan nimotatatautiliti ihuan Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ijcuacón in Jesús quinuiyac in Pedro huan in ome iconehuan Zebedeo. Huan pehuac Jesús quimachiliaya que tajyohuiyaya tech niyolo huan motayocoltiaya ya. ");
INSERT INTO azzNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Huan ijcón in Jesús quinilij ijcuín: ―Nicmachilía tech noyolo de que nitayocolmiqui. Ica ya nojón namejuan ximocahuacan nican pero xiijsatocan nohuan. ");
INSERT INTO azzNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Huan ijcón in Jesús yajqui cachi taixpan huan ompa motancuaquetzato huan motentocato talixco huan ompa motatatautilito ihuan Itajtzin huan quiliaya ijcuín: ―Nohueyitajtzin, como ijcón mopaquilis, xinechonajchihuili nijín tajyohuilis. Pero ma amo mochihua queme nejua nicnequi. Ta, ma mochihua ijcón queme Tejuatzin ticonmonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Huan de ompa mocuepac Jesús quinitato campa yetoyaj ne imomachtijcahuan, huan quinajsito cocochtocque huan Jesús quilij in Pedro ijcuín: ―¿Queyé amo nanuelque nanixpetantosquíaj nohuan siquiera se hora? ");
INSERT INTO azzNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Huan ocsepa Jesús quinilij ijcuín: ―Nican xiyetocan xiixpetantocan huan ximotatatautilijtocan ihuan Dios para que ma amo nanuetzisque tech in ohuijcayot de que in Satanás mitzichtacahuis. De yec melau ten namechilía de que namoyolojuan quipíaj tanejnequilis de cuali, pero cuetautoc namochicahualis porín amo nanquipíaj in yec tacuautamatilis. Ica ya nojón amo hueli nanquichihuaj ten cuali. ");
INSERT INTO azzNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Huan ijcón ica ojpa yajqui Jesús motatatautilito ihuan Dios ocsepa ijcuín: ―Notajtzin, como semi monequis de que nejua niquijyohuis nijín ohuijcayot, pues sayó xiconchihua queme Tejuatzin ticonmonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Huan ijcón niman ocsepa mocuepac Jesús campa yetoyaj imomachtijcahuan huan ocsepa quinajsito cocochtocque ne imomachtijcahuan porín ninixtololohuan ixtzatzacuíaj ica in cochilis. ");
INSERT INTO azzNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Huan ocsepa ompa quincauteu huan yajqui ica expa huan motatatautilito ihuan Dios ica mismo tajtolme de ne achtopa quijtojca ya. ");
INSERT INTO azzNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Huan ijcón ocsepa mocuepac Jesús campa yetoyaj imomachtijcahuan huan quinilij ijcuín: ―Axcan huelis para nancochisque ya, huan ximosehuican ya. Porín ejcoc ya in hora de Nejuatzin ni Yectagatzin nechtemactisque inmaco ne tagayot den tajtacolejque para nechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Huan niman ximoquetzacan huan tiyohue; porín huitza ya ne naquen nechtemactis inmaco in tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Huan queman Jesús tajtojtoya oc ihuan imomachtijcahuan, ijcuacón ejcoc in Judas senme de ne majtactiomome imomachtijcahuan. Huan ne Judas quinualcuía míac tagayot ten cualcuíaj machete huan cuoume. Hualajque intencopaca ne tayecanani tiopixcame huan in huehuentzitzin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Huan in Judas ne naquen quitemactij Jesús quinilijca ya in tayecanani ijcuín: ―Cuac nanquitasque que nictennamiquis, ijcuacón xicmatican que yejua ya ne Jesús; xiquitzquican huan xictzicocan. ");
INSERT INTO azzNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Huan ijcón in Judas motoquij campa Jesús yetoya huan quilij ijcuín: ―¿Quenín tiontayohuac, Notamachtijcau? Huan niman Judas quiquechnahuaj huan quitennamic in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ijcuacón in Jesús quinanquilij ijcuín: ―Nocnitzin, ¿tonica tejua tihuitza? Ijcuacón nimantzin in tagayot motoquijque huan quimatzijtzicojque Jesús huan cuiyacque queme preso. ");
INSERT INTO azzNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Pero mochihuac de que senme den ihuan yetoya in Jesús quiquixtij nimachete, huan quinacascotonac in taquehual de ne cachi hueyi tiopixcat. ");
INSERT INTO azzNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Huan ijcón in Jesús quiluij ijcuín: ―Xicyectali momachete campa tiquiehua. Porín nochi naquen motehuis ica machete, yejua ne no ica machete miquis. ");
INSERT INTO azzNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Huan Jesús quinilij in tagayot ijcuín: ―¿Xe amo ticmati de que Nejuatzin nihuelis nictajtanis Nohueyitajtzin huan Yejuatzin nechinualtitanilis majtactiomome pantime de ángeles? Huan se panti quipía majtactiomome mil ángeles. ");
INSERT INTO azzNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Pero tacán ijcón nicchihuasquía, ijcuacón amo mochihuasquía ne ten in Tajcuilolamatzin de Dios quijtoa que monequi motamichihuas. ");
INSERT INTO azzNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Huan Jesús ocsepa quinilij in tagayot ijcuín: ―Namejuan nanualajque ica machete huan ica cuohuit para nannechquitzquisque, queme yesquía nejua nitachtecque san. Mosta mosta nimotaliaya namohuan tiopanijtic huan namechmachtiaya; huan amo queman nannechquitzquijque para ma xinechtzitzicocan. ");
INSERT INTO azzNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Huan nochi nijín mochihuac para ma motamichihuas ijcón queme tacuilojcaj in tanahuatiani de Dios. Huan ijcón nochi ne imomachtijcahuan quichocholohuilijque Jesús huan Yejuatzin mocahuac iselti. ");
INSERT INTO azzNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Huan ne taca quiquitzquijque Jesús huan cuiyacque inixpan ne hueyi tayecanque tiopixcat ten monotza Caifás, huan ompa no mosentilijque ne tanextiliani den tanahuatil de Moisés huan ne huehuentzitzin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Huan in Pedro quitoctiliaya huejca san hasta ajsicque icaltenixpan nichan ne hueyi tiopixcat. Huan in Pedro calayic caltampa huan motalij campa in mayolme para quitasquía toni quichihuilisque in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Huan in tayecanani tiopixcame huan in huehuentzitzin den judíos huan nochi ocsequi tamachilejque ten pohuíaj ihuan in hueyi tequihuani, nochi nijinques mosentilijque huan quiyoltemoayaj tensá tajtacol para quipajpantisquíaj Jesús, para ijcón huelisquía quitelchihuasque huan quimictisque Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Huan masqui ijcón quichiuque, pero amo teyi cajxiliayaj, masqui miacque quipajpantiayaj Jesús ten amo melau. Huan cachi satepan hualajque ome taca para quitechtisque Jesús ica tajtolme ten amo melau. ");
INSERT INTO azzNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Huan yejuan quilijque ijcuín: ―Nijín tagat Jesús quijtoaya ijcuín: “Nejua nihuelis nicuejuelos in tiopan de Dios huan ipan eyi tonal nicchijchihuas ocsepa”. ");
INSERT INTO azzNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Huan ijcón in tayecanque tiopixcat moquetzac huan quilij Jesús ijcuín: ―¿Queyé amo teyi ica titananquilía? ¿Toni mitzijtohuilijtocque nijín ome testigos? ");
INSERT INTO azzNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Huan in Jesús motentamatilij san. Huan cachi oc in tayecanque tiopixcat quilij ijcuín: ―Nimitzchicaucanajnahuatía ica itocaytzin den Tohueyitajtzin Dios ten yoltica que “Quitztica Dios”, xitechyequili cox tejuatzin ya in Cristo Temaquixtijque, in Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Huan in Jesús tananquilij ijcuín: ―Quema, Nejuatzin ya in Cristo ijcón queme tejuatzin tiquijtoa. Huan no namechilía que nannechitasque Nejuatzin ni Yectagatzin cuac nimotalitiu iyecmacopaca ica in chicahualis den Totajtzin Dios. Huan no nannechitasque cuac nimohualuicas mixtzalan nepa ejecaixco. ");
INSERT INTO azzNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Huan ijcón ne tayecanque tiopixcat cualanic huan pehuac momojmotzoaya ica ne itilma; ijcón quichihuac porín quixejecoj que Jesús quihuijuicaltij Totajtzin Dios. Huan de ompa quinilij ijcuín: ―Nijín tagat quihuijuicaltij Dios ica itajtoluan. ¿Para toni ticnequij ocsé tagat ma quipajpantiqui oc? Porín namejuan cuali nanquicactocque ya de nijín tajtolme tenica quihuijuicaltij Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Huan, ¿toni nanquixejecoaj namejuan? Huan tananquilijque in tayecanani ijcuín: ―Tejuan timoixejecoltíaj de que cachi cuali ma miqui nijín tagat. ");
INSERT INTO azzNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Huan ijcón peuque quixchichijchaj Jesús huan quixtajtatziniayaj huan cuitequíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Huan quiliayaj Jesús ijcuín: ―Como tejua in Cristo, xiquixejeco aconi mitzmagatoc. ");
INSERT INTO azzNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Huan ijcón in Pedro tocotzyetoya nepa caltampa huan mochihuac que hualcalanquisac se sihuat den tetixilijque huan quilij Pedro ijcuín: ―Tej no tinemía ihuan ne Jesús den Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Huan in Pedro quitatij ten melau huan senteixpan quilij ijcuín: ―Amo nicajsicamati tonica tinechnojnotztoc. ");
INSERT INTO azzNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Huan cuac in Pedro calan quistiaya ya, ijcuacón ne calampa ya ocsé tetixilijque quitac Pedro huan quinilij ne naquen tocotzyetoyaj caltampa: ―Ne tagat no ihuan nemía ne Jesús de Nazaret. ");
INSERT INTO azzNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Huan ijcón ocsepa in Pedro quitatij ten melau huan quinilij ijcuín: ―“Quitztica Dios” que amo niquixmati ne tagat. ");
INSERT INTO azzNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Huan cachi nimampa sequi taca ten ompa yetoyaj ya huan motoquijque campa in Pedro huan quilijque ijcuín: ―Tejua, yec melau ixnesi que no ticayot de ne Galilea, ompa tipohui porín mocaqui motajtolis sansé ijcón queme Yejuatzin tajtoa. ");
INSERT INTO azzNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ijcuacón in Pedro pehuac cachi oc tahuijuicaltía huan quinilij ocsepa ijcuín: ―Melau “Quitztica Dios” que ne tagat amo niquixmati. Huan de ompa nimantzin pehuac tzajtzi ya in piotzin. ");
INSERT INTO azzNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Huan ijcón in Pedro quelnamic ten Jesús quiluijca ya ne achtopa: “Yec melau que achtopa ya que tzajtzisquía in piotzin, tejua tiquijtos expa de que amo tinexchixmati”. Huan ijcón in Pedro calan quisac huan pehuac semi mochojchoctía ilihuis. ");
INSERT INTO azzNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Huan cuac tanesic ya, ijcuacón nochi in tayecanani tiopixcame huan in huehuentzitzin den pueblojuani judíos, yejuan nojonques mosentilijque huan moyectencauque de que quimictisque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Huan ijcón cuiyacque Jesús tzicautiaya huan quitemactijque imaco in hueyi chiuque ne tayecanque Poncio Pilato. ");
INSERT INTO azzNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Huan ijcón in Judas cuac quitac de que quitelchiuque ya Jesús ma quimictican, ijcuacón yejua moyolcocoj ya huan moyolnemiliaya porín quitemactij ya Jesús. Huan yajqui nimantzin quintemactito in sempoal huan májtacti istac tomin de ne tayecanani tiopixcame huan in huehuentzitzin den pueblojuani den judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ijcuacón in Judas quinilij ne tayecanani ijcuín: ―Nimotajtacolmacac ya porín nictemactij ne yectica tagat para ma quimictican. Huan yejuan quinanquilijque ijcuín: ―Huan tejuan, ¿toni totequiu oc? Pues amo totequiu oc tejuan. Ta, tejua san a ver toni ticchihua ica nojón tomin. ");
INSERT INTO azzNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ijcuacón in Judas ica calijtic tacuamotac ne istac tomin den tiopixcame, huan quisteu huan yajqui huan moquechilpito ica se laso, huan ompa miyic. ");
INSERT INTO azzNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Huan ne tayecanani tiopixcame quiajocuicque ne tomin huan quijtojque ijcuín: ―Amo huelis ma ticsentilican nijín tomin campa monechicoa in tomin ten in tagayot quitemacaj para Dios. Porín nijín tomin yejua ne in taxtahuil para quimictisque se tagat. ");
INSERT INTO azzNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Huan ijcón niman in tayecanani moixejecoltijque huan moyectencauque que cachi cuali ica ne tomin ma quicohuasque se tal den se tagat soquiconchiuque para ma quipiacan campa quintalpachosque in ánimajme den amo nican cayome. ");
INSERT INTO azzNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ica ya nojón hasta axcan ne tal monotza ijcúin: in tal quicouque ica taxtahuil tenica quimictijque se tagat. ");
INSERT INTO azzNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Huan ijcón mochihuac ten quijcuilojca ya ne tanahuatijque Jeremías cuac quijtojca ijcuín: “Huan teconehuan den pueblojuani Israel quitalijque que se tagat ipatiu sempoal huan májtacti tomin, huan quicuicque ne tomin, ");
INSERT INTO azzNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","huan ijcón quicouque ne tal campa tequitía ne soquiconchiuque. Huan ijcón mochihuac porín quimonequiltij in Totecotzin”. ");
INSERT INTO azzNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Huan ipa cuiyacque ya Jesús iixpan in hueyi tequihua Pilato huan yejua pehuac quimajtajtoltij Jesús ijcuín: ―¿Xe tejua ya in tayecanque de nochi in judíos? Ijcuacón in Jesús tananquilij ijcuín: ―Quema, ijcón queme tejuatzin tiquijtoa. ");
INSERT INTO azzNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Huan cuac in tayecanani tiopixcame huan in huehuentzitzin den judíos quicacque in tananquililis de Jesús, ijcuacón yejuan cachi oc quiteteluiliayaj huan quipajpantiayaj de míac tataman; pero Jesús sayó motentamatilij huan amo teyi ica tananquilij. ");
INSERT INTO azzNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Huan in Pilato ocsepa quilij ijcuín: ―¿Xe amo ticaqui nochi nijín ne teluililis tenica mitzpajpantíaj? ");
INSERT INTO azzNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero Jesús sayó motentamatilij huan nión teyi ica tananquilij. Ijcuacón in tayecanque Pilato quimoucaitac huan amo quimatía oc toni quichihuas oc. ");
INSERT INTO azzNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Huan tech ne tonalme den iluit ipa mochiutihuitz que in tequihua Pilato quincahuilía in pueblojuani judíos se tagat preso naquen yejuan quijitasquíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Huan ne tonal tzactoya se tagat se preso monotza ya Barrabás den nochi quixmatíaj. ");
INSERT INTO azzNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Huan ijcón cuac mosentilijque ya in tayecanani, ijcuacón in tequihua Pilato quintajtoltij in tagayot ocsepa ijcuín: ―Namejuan tagayot, ¿catiyejua preso nanquinequij ma nicajcahua? ¿Cox yejua ne preso Barrabás, oso yejua Jesús den monotza Cristo? ");
INSERT INTO azzNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Porín Pilato ipa cajsicamatic ya de que ica ne xijcolot in tayecanani quitemactijque Jesús para ma quimictican. ");
INSERT INTO azzNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Huan cuac in Pilato tocotzyetoya campa ne quinixejecoa in moteteluiliani, ijcuacón isihuau in Pilato quinahuatiliqui ijcuín: “Amo teyica ximocalaqui ica ne tagat ten yolcuali, porín yaloa tayohuac nejua nechmomoutiaya huan nechtajyohuiltiaya porín nicojcochitztoya de ne Jesús”. ");
INSERT INTO azzNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Huan in tayecanani tiopixcame huan in huehuentzintzin den judíos quintaneltoctijque nochi in tagayot de que ma quitajtanilican in Pilato de que ma quitojtomacan ne Barrabás huan ma quimictican Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Huan ijcón in Pilato ocsepa quinnojnotzac huan quintajtoltij in pueblojuani ijcuín: ―¿Catiyejua de nijín omen presos nanquinequij namejuan ma nictojtoma ma yohui? Ijcuacón in pueblojuani quijtojque ijcuín: ―Yejua ne Barrabás. ");
INSERT INTO azzNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Huan Pilato ocsepa quintajtoltij in pueblojuani ijcuín: ―Huan como nictojtoma Barrabás ma yohui, ¿toni nicchihuilis Jesús den monotza Cristo? Ijcuacón nochi in pueblojuani tananquilijque ijcuín: ―¡Xicuoupampilocan in Jesús! ");
INSERT INTO azzNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Huan in Pilato ocsepa quinilij in pueblojuani ijcuín: ―¿Toni tajtacol quichihuac nijín Jesús? Ijcuacón in pueblojuani cachi oc tzajtzíaj huan quijtoayaj ijcuín: ―¡Xicuoupampilocan in Jesús! ");
INSERT INTO azzNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Huan quitac in Pilato de que amo teyi cualtiaya oc nitajtol. Ta, cachi oc moyolcuemoloayaj san yejuan in pueblojuani judíos. Ijcuacón in Pilato tanahuatij ma cualcuilican at para ma momajtequi senteixpan nochi in tagayot huan quinilij ijcuín: ―Pues nejua amo xinechtechtican que nejua nitanahuatij que xicmictican nijín tagat den yolcuali. Ta, namejuan namotanemililis cuica in tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Huan nochi in tagayot tananquilijque ijcuín: ―Tejuan huan toconehuan titananquilíaj por ne miquilis den ne yolcuali Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Huan ijcón quitojtonque de que ma yohui in preso Barrabás. Huan niman tatitanic ma cuitequican Jesús huan quitemacti ma quicuoupampilocan Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Huan cachi satepan in taquehualme soldados den hueyi tequihua Pilato cuiyacque Jesús ichan Pilato campa hueyi caltampa. Huan de ompa quinsentilijque ocsepa in soldados huan nochin quiyehualojque in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Huan de ompa quitaquenquixtijque Jesús huan quiquentijque se tilma chichiltic. ");
INSERT INTO azzNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Huan ompa quiquejquelojque Jesús huan quicuatalilijque se taijquitil de huitzti ten yohualtic queme se corona. Huan quimaquitzquiltijque Jesús se topil iyecmacopaca huan motancuaquetzque iixpan huan quiquejqueloayaj huan quiluiayaj ijcuín: ―Ma amo queman timiquis, tejua titayecanque den judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Huan no quixchijchayaj Jesús huan no quicuijque se acat huan quicuahuijuitequíaj Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Huan niman cuac quitamiquejquelojque ya, ijcuacón quiquixtilijque ne chichiltilma huan quitalilijque ocsepa itilma. Huan de ompa cuiyacque huan quicuoupampilotoj. ");
INSERT INTO azzNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Huan cuac sen quistiayaj caltempan in soldados ihuan Jesús, ijcuacón quinamicque se tagat monotza Simón, ipueblo Cirene, huan quifuerzahuijque de que ma no quimama ne colotzin ten cuiyac ya in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Huan ijcón ajsicque tech ne tal lomojtzin ten monotza Gólgota, den quijtosnequi miquetzontecomatan. ");
INSERT INTO azzNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Huan de ompa quitayiltijque Jesús vinagre tamanelol ica cuouchoquilot. Huan Jesús cuac quitenyecoj ya, ijcuacón amo quineyic tayis. ");
INSERT INTO azzNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Huan cuac ne Jesús quisojsoque ya ica clavos tech ne colotzin, ijcuacón in soldados quichiuque ne tatanilis para quitasquía de catiyejua tasal de Jesús cuicasquía cada soldado. Huan ijcón mochihuac ten quijcuiloj ne tanahuatijque de Dios cuac quijtoj ijcuín: “Moxejxelohuilijque se huan ocsé notilmajuan huan quichiuque ne tatanilis para quitasquía aconi cuicasquía nochi notilma”. ");
INSERT INTO azzNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Huan niman motalijque ompa in soldados para quipiasque Yejuatzin campa yetoya. ");
INSERT INTO azzNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Huan tech ne ixcuaco in colotzin quitalijque sequi tajtolme tenica quitelchiuque Jesús, huan ne tajtol quijtoaya ijcuín: “Yejua nijín Jesús, Tayecanque den judíos”. ");
INSERT INTO azzNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Huan no quincuoupampilojque inajnacastampa Jesús ome tachtequini, se iyecmacopaca huan in ocsé iopochcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Huan in pueblojuani ten panoayaj taixpampa Jesús mocuahuihuicatoyaj huan yejuan quiquejqueloayaj san Jesús huan quiliayaj ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","―Tejua tiquijtoaya que ticuejuelos in tiopan de Dios huan ipa eyi tonal ocsepa ticchihuas. Pero axcan ximomaquixti tejua moselti san. ");
INSERT INTO azzNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Huan no ijcón quiquejqueloayaj Jesús nochi in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés, huan in fariseos huan in huehuentzitzin den pueblojuani de judíos. ");
INSERT INTO azzNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Huan ijcón yejuan moyoliliayaj de Jesús ijcuín: ―Achá yejua quinmaquixtij ocsequin tagayot, pero yejua iselti amo huelis momaquixtis. Pero melau como yejua ne in Tayecanque de Israel, pues ma temo tech ne colotzin; huan ijcón ticneltocasque de que melau yejua in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yejua ne Jesús quijtoj que tacuautamatij tech ne Ihueyitajtzin Dios, pues achá Itajtzin Dios quimaquixtis axcan mismo como melau quitasojta, porín techilía que yejua Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Huan no ijcón quiquejqueloayaj Jesús ne ome tachtequini den ihuan quincuoupampilojque Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Huan mochihuac que tayohuayantijtoya nochi in talticpac desde ne cuac nepanta hasta ne eyi hora de tiotac. ");
INSERT INTO azzNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Huan cuac ne eyi hora de tiotac, ijcuacón Jesús tzajtzic chicahuac huan quijtoaya ijcuín: ―Elí, Elí, ¿lama sabactani? ―quijtosnequi: No Dios no Dios, ¿queyé tinechsencahuac? ");
INSERT INTO azzNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Huan in ocsequin ten yetoyaj ompa quicacque itzajtzilis huan quijtoaya ijcuín: ―Nijín tagat quinotztoc ne tanahuatijque de Dios ten monotza Elías. ");
INSERT INTO azzNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Huan nimantzin senme den yetoya ompa, yejua cuitihuetzito se tilma ten posoctic huan cajaqui tech vino den chichic huan quiyecapantalilij ica se acat; huan de ompa quitenajxiltij Jesús para ma yejua quichichinani. ");
INSERT INTO azzNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Huan in ocsequin ten ompa yetoyaj quijtojque ijcuín: ―Xicahuacan ma tiquitacan cox hualas oc ne Elías tanahuatijque para quipalehuiquiu. ");
INSERT INTO azzNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Huan ocsepa in Jesús tzajtzic chicahuac huan ijcón momiquilij. ");
INSERT INTO azzNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Huan ne tasal ten pilcatoya ne tiopanijtic campa in altar, yejua ne ixtzayanic huan ome quisac de ajco huan hasta tani. Huan talolinic huan ijcón in teme tajtapanque nochi. ");
INSERT INTO azzNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huan motapouque ne tepanme campa talpachiutoyaj in ánimajme huan sequin taneltocani panquisque yoltocque ne ten achtopa momiquilijque. Huan ijcón quisque in ánimajme itech ne tepancalme. ");
INSERT INTO azzNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Huan nimampa de que cuac panquisac ya Jesús yoltoc intzalan in ánimajme, ijcuacón ne taneltocani den quisque tech ne ánimaj tepancalme, yejuan yajque tech ne mohuiscapueblo de Jerusalén campa miacque tagayot quinnextilijque. ");
INSERT INTO azzNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Huan se tayecanque soldado huan ocsequin in soldados quipixtoyaj Jesús. Huan cuac quimachilijque de que talolinic ya huan quitacque nochi míac tenesi den mochihuac, ijcuacón yejuan semi moyolmoutijque huan quijtojque ijcuín: ―Yec melau nijín tagatzin Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Huan ompa yetoyaj míac sihuame huejca san ontachixtoyaj. Huan yejuan ipa quitoctiliayaj Yejuatzin in Jesús porín quisenuicatinemíaj desde ne Galilea huan quitequitiliayaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Huan ompa yetoyaj in María Magdalena, huan in María inan den Jacobo huan de José, huan no yetoya itenan den teconehuan de Zebedeo. ");
INSERT INTO azzNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Huan cuac tapoyahuic ya, ijcuacón huala se tagat ten quipiaya míac tenesi ten niaxca, huan yejua monotzaya José ipueblo Arimatea. ");
INSERT INTO azzNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Yejua ipa quitoctiliaya Jesús queme imomachtijcau. Huan in José yajqui quitato in hueyi chiuque Pilato huan quitajtanilito inacayo in Jesús. Huan ijcón in Pilato tanahuatij ma quimacacan. ");
INSERT INTO azzNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Huan ijcón in José quicuic inacayo Jesús huan quitetziloj ica se hueyi istac tilma den chipahuac. ");
INSERT INTO azzNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Huan yejua cuiyac quicalaquito inacayo in Jesús campa tecoyoc campa iaxca catca. ");
INSERT INTO azzNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Porín ipa quicoyonijcaj ya in tepet. Huan quixoloncuepac se hueyi tet para ica quitzacuas ne tecoyoc huan de ompa yajqui. Huan no ompa yetoyaj María Magdalena huan in ocsé María, huan yejuan tocotzyetoyaj ixpampa ne campa tecoyoc. ");
INSERT INTO azzNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Huan imostica cuac tanesic ya, satepan cuac in judíos moyejyectaliayaj para ne iluit de nesehuilistonal, ijcuacón in tayecanani tiopixcame huan in fariseos mosentilijque huan de ompa quitatoj in tayecanque Pilato. ");
INSERT INTO azzNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Huan quilijque ijcuín: ―Totecotzin, tiquelnamicque que ne tacajcayauque Jesús quijtoaya cuac nemía nican talticpac de que ipan eyi tonal panquisas yoltoc intzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ica ya nojón xitanahuati de que ma quiyecpiatij nepa campa toctoc Jesús hasta ma ajsi in eyi tonal, huan para ma amo hualacan imomachtijcahuan huan quichtequiquihue inacayo Jesús. Porín como quichihuasquíaj, ijcuacón yejuan quinilisque in pueblojuani de que panquisac ya yoltoc in Jesús intzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Huan como ijcón mochihuasquía nijín xolopijyot, cachi hueyi yesqui huan que ne achtopa catca, cuac yejuan quitetapohuijtinemíaj de que yejua in Cristo Temaquixtijque. Huan ijcón in Pilato quinilij ijcuín: ―Namechinmactilía nijín soldados para ma tajpiacan. Huan namejuan xiquinuiyacan nijín soldados huan ompa ma quiyecpiatij huan ma quiyectzacuatij in tecoyoc ijcón queme namejuan nanquinequij ma mochihua. ");
INSERT INTO azzNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Huan ijcón in soldados yajque huan quiyectentzacuatoj in tecoyoc campa toctoc ya Jesús. Huan de ompa quisellarojque in tet huan ompa quincauque in soldados de que ma tajpiacan. ");
INSERT INTO azzNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Huan panoc ya ne sehuilistonal den sábado huan imostica san tanesic, yej ne tayecana tonal den semana, yej ne axcan domingo. Ijcuacón ne tonal yajque in María Magdalena huan ocsé María quitatoj ne hueyi tecoyoc campa tooctoya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Huan niman semi chicaucatalolinic porín temoc den ne eluiyactzinco se taquehual ángel de Dios huan ajsic campa tecoyoc huan quixoloncuepac in hueyi tet tenica tentzactoya in tecoyoc; huan de ompa motalij panían. ");
INSERT INTO azzNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Huan ne ángel ixmilinía queme cuac se quita tapejpetani huan tatanextía nohuiyan. Huan ne itaquen in ángel catca cachi istac huan que secti. ");
INSERT INTO azzNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Huan cuac in soldados quitacque nochi nijín ten mochihuac, ijcuacón yejuan semi motelyolmoutíaj huan hasta peuque cuecuetacayaj; huan de ompa mocauque queme yesquíaj amo talnamiquíaj oc. ");
INSERT INTO azzNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Huan ijcón ne ángel quinilij ne sihuame ijcuín: ―Amo ximomoutican; porín nejua nicmati que namejuan nanquitemouaj Jesús de ne quicuoupampilojcaj. ");
INSERT INTO azzNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Huan axcan amo yetoc oc nican. Ta, axcan Yejuatzin panquisac ya yoltoc intzalan in ánimajme, ijcón queme quijtojca ya ne achtopa ya. Xihualacan nican huan xiquitaquij campa quinalcalaquijcaj in Totecotzin tech in tecoyoc. ");
INSERT INTO azzNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Huan axcan niman xiyacan huan xiquintapohuitij ne imomachtijcahuan de que in Jesús panquisac ya yoltoc intzalan in ánimajme. Huan yequintzin Yejuatzin namechyecanati hasta ne Galileajcopaca huan ompa nanquitasque. Huan yejua san nijín monequía namechilis. ");
INSERT INTO azzNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Huan ijcón in sihuame moucaquisteuque campa ne tecoyoc pero no moyolpactijtiayaj. Huan niman yajque motalojque huan quintapohuitoj imomachtijcahuan Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Huan cuac yayaj ya para quintapohuitij ne imomachtijcahuan, ijcuacón in Jesús quinmonextilij inixpan in sihuame huan quilij ijcuín: ―Axcan nihuala namechtajpaloco san. Huan in sihuame motoquijque huan motancuaquetzque huan quimetzquitzquijque para quimohuistilisque. ");
INSERT INTO azzNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Huan Jesús quinilij ijcuín: ―Amo ximomoutican. Ta, xiyacan xiquinnejmachtitij nocnihuan de que monequi ma xiyacan tech ne pueblo Galileajcopaca huan ompa nannechitasque. ");
INSERT INTO azzNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Huan cuac in sihuame yajque ya, ijcuacón ne soldados no yajque Jerusalén quintapohuitoj in tayecanani tiopixcame nochi ten mochihuac huan nochi ten quitacque yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Huan ijcón in tayecanani yajque mosentilitoj ihuan in huehuentzitzin huan ompa moixejecoltijque toni quichihuasquíaj. Huan ijcón niman motajtolmacacque de que quintaxtahuisque ica míac tomin in soldados huan melau ijcón quichiuque huan quinnahuatijque ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","―Namejuan sayó xiquijtocan ijcuín: “Cuac ne tayohuac ya, cuac tejuan ticochtoyaj ya, ijcuacón hualajque imomachtijcahuan in Jesús huan quichtequicoj inacayo”. ");
INSERT INTO azzNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Huan ijcón in tayecanani ocsepa quinilijque in soldados: ―Tacán in tayecanque Pilato ejcos in momento de que quimatis, ijcuacón tejuan ticmatij queniu para tictaneltoctisque den nochi den nijín mochihuac huan ijcón huelis tamechpalehuisque. ");
INSERT INTO azzNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Huan ijcón in soldados quiselijque ne tomin huan yajque quichihuatoj ijcón queme quinilijque in tayecanani. Huan nochi ijcón quintetapohuiayaj in judíos desde ne tonal huan hasta axcan que ijcón mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Huan ijcón in majtactionsé imomachtijcahuan in Jesús yajque ne Galileajcopaca tech ne tepelomo campa Jesús quinilijca ya de que ma yanij. ");
INSERT INTO azzNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Huan ijcón cuac quitacque Jesús, ijcuacón peuque quimohuistiliayaj, masqui ayamo yec tacuautamatiayaj. ");
INSERT INTO azzNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Huan ijcón in Jesús motoquij campa yetoyaj imomachtijcahuan huan quinilij ijcuín: ―Notajtzin Dios nechmactilij ya nochi in tanahuatil tech in eluiyactzinco huan nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Huan axcan xiyacan nochi tech in senmanahuac huan xiquinnextilican nochi in talticpacuani ma yejuan no ma mochihuacan nomomachtijcahuan. Huan xiquinahuijtinemican ica itocaytzin de Tohueyitajtzin Dios huan de Iconetzin Dios huan de in Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Huan xiquinmachtican de que ma tatacamatican nochi ica in tanextililisme ten namechnajnahuatíaj ma no xicchihuacan. Huan xicmatican que Nejuatzin niyetos nachipa namohuan desde axcan huan hasta cuac tamis in talticpac. Amén.");
INSERT INTO azzNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Nican pehua in yancuic Tajtoltzin ten temachtía de Jesucristo Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Ijcón queme ijcuiliutoc in Tajcuilolamatzin tech Isaías, yejua se tanahuatijque de Dios ijcuín: Xiquitacan, Nejuatzin nictitani notanahuatijcau huan yejua mitzonachtohuitiu. Huan no mitzonojchihuitiu, huan mitzonyecantiyás. ");
INSERT INTO azzNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mocaquiti se tagat ten tanajnahuatía campa tayiucan huan quijtoj ijcuín: “Xitayejyectalijtiyacan ninemilispan den Totecotzin. Huan xicmejmelautiyacan niojuan campa hual panotihualas”. ");
INSERT INTO azzNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Huan ijcón in Juan quinahuijtihualaya in tagayot campa ne tayiucan huan quinnajnahuatiaya ijcuín: ―Monequi ximoyolnemilican de namotajtacoluan para ijcón Totajtzin Dios namechtapojpoluis de namotajtacoluan. Huan no monequi ma namechahuijcan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Quisayaj nochi ne pueblojuani de Judea huan nochi den pueblojuani de Jerusalén, huan yejuan yayaj tacaquitoj campa yetoya ne Juan. Huan Juan quinahuía ica at tech in hueyíat ten monotza Jordán, como moyolnemiliayaj in tagayot de nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Huan ne Juan motaquentiaya ica camellojtojmit ten taijquitil, huan tajcuilpitoya ica se cuetax huan quincuaya chapolinme huan cuoutajnecti. ");
INSERT INTO azzNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Huan in Juan tanajnahuatiaya huan quijtoaya ijcuín: ―Huitza se naquen nechualtojtoca huan Yejuatzin cachi quipía chicahualis, huan nejua niamoteyi nichiuque. Amo nechnamiqui para nimotentocas huan nictojtomilis ne nimetzuijconca de nitegacuan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nejua de yec melau namechahui ica atzin san, huan Yejuatzin ne ten huitza, Yejuatzin namechquemilos huan namechyolpepexocaltis ica in Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mochihuac tech ne tonalme que Jesús hualehuac de ne pueblo de Nazaret ten pohuía Galilea, huan moteahuiltij inahuac in Juan tech in hueyíat de monotza Jordán. ");
INSERT INTO azzNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Huan niman cuac ajcopanquisac ya Jesús den hueyíat, ijcuacón motac que tatapohuic tech eluiyac huan Jesús quitac in Yecticatzin Espíritu hual temoaya queme se tototzin paloma huan Yejuatzin calayic itech Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Huan no mocaquic que hualaya se tajtolis de eluiyactzinco huan Yejuatzin quilij Jesús ijcuín: ―Tejua tinotasojconetzin, ica por tejuatzin semi nimoyolpaquiltía axcan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Huan niman in Yecticatzin Espíritu quiyoltanemililtij Jesús de que ma yohui campa ne tayiucan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Huan yetoya Jesús campa ne tayiucan omepoal tonal, huan de ompa ne amocuali Satanás quiejecoltiaya itacuautamatilis de Jesús para ma motajtacolmacani Jesús. Huan no yetoya Jesús campa ne tecuanime, huan in ángeles taquehualme de Dios quipalehuiayaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Niman de quitzacuacque in Juan Taahuijque tech in cárcel, ijcuacón Jesús yajqui Galileajcopaca huan tanajnahuatinemic ica in yancuic Tajtoltzin huan tamachtiaya de que motoquijtoc ya Dios para momasoutos ya ica nihueyichicahualis ipan iconehuan para quinyolyecantiyás. ");
INSERT INTO azzNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Huan Jesús quinnajnahuatij in tacaquini ijcuín: ―Ejcotoc ya in tonalme huan no motoquijtoc ya Dios para ma momasouto ya ica nihueyichicahualis para namechyolyecantiyás. Ica ya nojón ximoyolnemilican den namotajtacoluan huan xicneltocacan in yancuic Tajtoltzin de ne maquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús nejnentinemía martenojcopaca de Galilea huan quinitac ne Simón huan icniu Andrés, naquen quitamotayaj ninmatau tech in mar porín yejuan catcaj pescadojquitzquiani. ");
INSERT INTO azzNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Huan quinilij Jesús ijcuín: ―Xihuiqui nohuan, xinechtoctilican. Huan ijcón queme nantamajasini de pescados, no ijcón Nejuatzin namechchihuas de que nanquintemosque tagayot para ma nechtoctilican. ");
INSERT INTO azzNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Huan nimantzin ne Simón huan ne Andrés quicauque ninmatahuan huan quitoctilijque Jesús para quitacamatiyasque. ");
INSERT INTO azzNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Huan queman panoc ya de ompa nepacatzin, ijcuacón Jesús quinitac Jacobo huan iicniu Juan, teconehuan de Zebedeo. Huan yejuan yetoyaj tech se barco quitajtasaluijtoyaj ninmatahuan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Huan Jesús quinnotzac ne teconehuan ma quitoctilican. Huan yejuan quicauque nintetat huan in taquehualme tech in barco huan quitoctilijque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Huan Jesús ihuan nimomachtijcahuan calacque tech pueblo Capernaum. Huan tech in tonalme de nesehuilis calayic Jesús tech in tiopan de judíos huan pehuac quinnextiliaya in tacaquini ica in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ijcuacón nochi in tagayot quimoucacaquíaj nitamachtilis de Jesús, porín Yejuatzin quinmachtiaya ica hueyi chicaucahuelilis huan amo quinnextiliaya queme in escribas, yejuan in tanextiliani den tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Huan yetoya tech in tiopan de judíos se tagat ten quipiaya iyolijtic se amocuali ejecat ten tzatzajtzitoya. ");
INSERT INTO azzNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Huan ne amocuali ejecat quilij Jesús ijcuín: ―Xitechtapatahuili huan amo xitechcuejmoloqui. ¿Toni ticpía tohuan, Jesús de Nazaret? ¿Cox tihuala para titechpolos? Nicmati cuali nimitzixmati aconi tejua, Tionyecticatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Huan Jesús quitacahualtij ne amocuali ejecat huan quilij ijcuín: ―Ximotentamatili huan xiquisa tech yejua. ");
INSERT INTO azzNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Huan ne amocuali ejecat quichihuac in tagat de que ma yojyolpolihui para ma tzajtzi elihuis. Huan de ompa in amocuali ejecat quisac de ne yolijtic den tagat. ");
INSERT INTO azzNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Huan nochin ten yetoyaj calijtic de ne tiopan de judíos no quimoucaitacque semi huan monojnotzayaj se huan ocsé huan quijtoayaj ijcuín: ―¿Toni nijín tajtolis? ¿Xe nijín ocsepa ocsé yancuic tanextililis? Porín tiquitaj que nijín Jesús quipía huelilis para quinnahuatis in amocuali ejecame ma calanquisacan. Huan yejuan quitacamatij huan calanquisaj. ");
INSERT INTO azzNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Huan ijcón semi moijsiucatetapohuijque den hueyi chicahualis de Jesús tech nochi pueblojme ten quiyehualojtoyaj Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Huan queman quisque tech in tiopan de judíos, ijcuacón yajqui Jesús ihuan ne Jacobo huan in Juan huan calacque tech nichan ne Simón huan in Andrés. ");
INSERT INTO azzNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Huan nimonan ne Simón huetztoya ica se hueyi totonic. Huan quitapohuijque Jesús de que mococoaya nimonan Pedro. ");
INSERT INTO azzNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ijcuacón Yejuatzin motoquij campa in cocoxque huan quimaquitzquij huan quicuaehuac; huan nimantzin quisac in totonic. Huan ijcón imonan ne Pedro mehuac huan quintamacac icalpanocahuan. ");
INSERT INTO azzNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Huan queman tapoyahuito ya, cuac in tonal pancalayic ya, ijcuacón cualcuilijque campa Jesús nochi in cocoyani huan neques ten quipiayaj inyolijtic amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Huan nochi in pueblojuani mosentilijque huan motilintijque icalteno de nichan Simón. ");
INSERT INTO azzNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Huan Jesús quinpajtij miacque de mococoayaj ica de míac tataman cocolisme. Huan no Jesús quincalanquixtij míac amocuali ejecame, huan amo quincahuilij ma tajtojcan, porín yejuan quixmatque Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Huan Jesús mehuac semi cualcan, queman tayohuayan oc catca, huan quisac de pueblo huan yajqui itech campa se lugar tayiucan, huan ompa motatatautiliaya ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Huan Simón huan naquen ihuan yetoyaj quitemojque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Huan queman quiajsicque Jesús, ijcuacón quilijque ijcuín: ―Nochi pueblojuani mitzontemojtocque. ");
INSERT INTO azzNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Huan Yejuatzin quinilij: ―Tiyohue tejuan nepacahuín tech ne pueblitos amo huejca para no niquinnajnahuatis ica in yancuic Tajtoltzin, porín yejua notequiu, huan yejica Nejuatzin nihuala. ");
INSERT INTO azzNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Huan nentinemía Jesús quitenextilijtinemía in Tajtoltzin de Dios tech in tiopanme de judíos tech nochi in pueblojme ten pohuía Galilea, huan no quincalanquixtiaya amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Huan niman huala campa Jesús se tagat ten quipiaya se cocolis inacayo cocotocaya. Huan yejua motancuaquetzac huan nocta quitatautiaya Jesús huan quilij ijcuín: ―Ta como ticonequisquía, tionuelis tinechonchipahuas de nijín pitzotic cocolis. ");
INSERT INTO azzNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Huan Jesús quitelicnelij huan momatilanac huan quimatocac huan quilij ijcuín: ―Nicnequi ma tejua xichipahua de mococolis. ");
INSERT INTO azzNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Huan cuac Jesús ijcón quilij, ijcuacón nimantzin quisac ne cocolis den inacayo cocotocatoya huan mocahuac chipactzin ne tagat. ");
INSERT INTO azzNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Huan Jesús quilij in tagat ma yohui. Pero achto quichicaucanajnahuatij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","―Xiquita, amo aquen teyi xictapohui. Ta, xiyó ximotenextiliti ihuan ne tiopixcame de judíos de que tichipahuac ya. Huan no xiquinmactiti ne tetayocolil in tiopixcame de judíos, ijcón queme Moisés tanahuatiaya para ne cocoyani ten tapajtilme ya de ne cocotoca ninacayo. Huan ijcón ixnesis ninuan mopueblojcahuan de que tichipahuac ya. ");
INSERT INTO azzNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Huan queman yajqui ya Yejuatzin, ijcuacón ne tagat den chipahuayac ya, yejua ne pehuac tetapohuía nocta huan quiniliaya nochi tagayot toni quichihuac Jesús por yejua. Huan ica ya nojón Jesús amo huelía oc calaquis senteixteno tech ne pueblojme porín yetosquía míac tagayot. Ica ya nojón mocahuac Jesús nehuincopa campa tayiucan. Huan motoquijque campa Yejuatzin yetoya nochi in pueblojuani de nonohuiyampa. ");
INSERT INTO azzNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Satepan sequin tonalme ocsepa calayic Jesús tech ne pueblo de Capernaum; huan motetapohuij de que yetoya Jesús calijtic. ");
INSERT INTO azzNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Huan nimantzin mosentilijque míac tagayot hasta amo aquíaj oc calijtic nión ne calteno. Huan ijcón in Jesús quinmachtiaya in tacaquini ica in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ijcuacón nahuin taca hualajque campa Yejuatzin huan cualcuilijque se tagat cocoxque ten nochi ninacayo tami sensepautoc ya huan amo huelía nejnemía. ");
INSERT INTO azzNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Pero queme yejuan amo huelíaj ejcosque campa Yejuatzin, porín nocta míac tagayot mosentilijque, yejuan tejcojque calcuaco quicuatapouque in cali ajco campa Yejuatzin yetoya. Huan queman quitapojque ya in cali, ijcuacón quipantemoltijque in cocoxque ica nicochpet. ");
INSERT INTO azzNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Cuac Jesús quitac nintacuautamatilis de nojón nahuin taca, ijcuacón Jesús quilij in cocoxque ijcuín: ―Noconetzin, motajtacoluan nimitzintapojpoluilía ya. ");
INSERT INTO azzNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Huan ompa tocotziutoyaj sequin tanextiliani den tanahuatil de Moisés huan yejuan yoltanemilijtoyaj ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Queyé ijcón tajtoa nijín tagat? Yejua quimohuispoloa Dios. ¿Aconi huelis tetapojpoluía tajtacol? Ta, sayó Dios hueli tetapojpoluía”. ");
INSERT INTO azzNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Huan niman Jesús quinyolojixmatía de que ijcón yoltanemiliayaj ne tanextiliani, huan quinilij ijcuín: ―¿Queyé ijcón nanyoltanemilíaj? ");
INSERT INTO azzNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Catiyejua tajtolis cachi amo ohui ma niquili ne cocoxque? Ma niquili: “Motajtacoluan nimitzintapojpoluij ya”. Oso ma niquili: “Ximehua, xicui motapech huan xinejnemi”. ");
INSERT INTO azzNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Huan nejua namechyecmatiltía que Nejuatzin ya ni Yectagatzin de Dios huan nicpía tanahuatil nican talticpac para niquintapojpoluis naquen motajtacolmacacque ya. ");
INSERT INTO azzNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Huan de ompa Jesús quilij in cocoxque ijcuín: ―Tejua, nimitzilía ximehua, xicui motapech huan xiyó mochan. ");
INSERT INTO azzNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ijcuacón nimantzin in cocoxque moquetzac huan quicuic nitapech huan quisac senteixteno. Huan ica ya nojón nochi in tagayot quimoucaitacque toni mochihuac huan no quihueyichiuque Dios huan quijtoayaj ijcuín: ―Amo queman ijcón tiquitztoyaj tensá chihualis queme nijín ten tiquitacque. ");
INSERT INTO azzNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Satepan ocsepa quisac Jesús huan yajqui ne martenojcopa huan nochin tagayot mosentiliayaj campa Yejuatzin yetoya, huan Jesús quinmachtiaya in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Huan Yejuatzin ocsepa panotiaya ne martenojcopa huan ompa quitac se tagat de monotzaya Leví iconetzin de Alfeo, ten tocotziutoya calteno campa quintopaluiaya in pueblojuani. Ijcuacón Jesús quilij ijcuín: ―Xinechtoctili huan ximomachtijtiyás de notnextililis. Huan nimantzin moquetztiquisac in Leví huan yajqui quitoctilito Jesús ma momachtitiu de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Huan satepan Jesús yajqui tacuato ichan in Leví ihuan miacque tatopaluiani. Huan no in taca ten amo tatacamatini de itanahuatil Moisés, yejuan nojonques no tacuajtoyaj ihuan Jesús huan imomachtijcahuan, porín oncayaj miacque ten quitoctiliayaj Jesús para momachtisque de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Huan in tanextiliani den tanahuatil de Moisés huan in fariseos quitacque que in Jesús sen tacuajtoya ihuan in tatopaluiani huan no ihuan in taca ten amo quitacamatinemij in tanahuatil de Moisés. Ica ya nojón yejuan quitajtoltijque imomachtijcahuan de Jesús ijcuín: ―¿Toni nijín ten quichiutoc Yejuatzin? ¿Queyé in Jesús tacuajtoc huan ati ihuan ne tatopaluiani huan in taca ten amo tatacamatinemij den tanahuatil de Moisés? ");
INSERT INTO azzNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Huan queman cayic Jesús nijín matájtanti, ijcuacón Yejuatzin tananquilij ijcuín: ―Nojón tagayot ten mopohuaj yolpactocque, yejuan nojonques amo monequij tepajtijque. Ta, sayó in cocoyani monequij in tepajtijque. Nejua amo nihuala niquintemoco naquen mopohuaj yolchipauque. Ta, nihuala niquintemoco tajtacolejque para ma moyolnemilican de nitajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Huan imomachtijcahuan de Juan Taahuijque ihuan imomachtijcahuan de fariseos mosahuayaj. Huan in pueblojuani hualajque huan quilijque Jesús ijcuín: ―Ticmatij que imomachtijcahuan de Juan Taahuijque huan imomachtijcahuan de fariseos mosahuaj. Huan momomachtijcahuan, ¿queyé yejuan amo mosahuaj? ");
INSERT INTO azzNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Huan Jesús tananquilij ijcuín: ―¿Mangán mosahuasque nochin in taijitalme ten hualajque para moyolpactisque tech in iluit de ne namictilis, como yetoc oc in teyoquich? Pues, amo huelis mosahuasque como yetoc oc ihuan in teyoquich. ");
INSERT INTO azzNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Pero queman hualas ne tonal cuac teyoquich cajchihuasque, ijcuacón tech ne tonalme huelis mosahuasque nochi in taijitalme. ");
INSERT INTO azzNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Huan ijcón in Jesús quinnextilij ica nijín nexcuitil huan quinejnehuililtij in yancuic nemilis ihuan in yancuic tasal huan in yancuic vino. Huan Jesús quinilij ijcuín: ―Amo aquen quijtzoma se yancuic tasal tech se tasalsol ten cojcotolquisac ya. Porín de amo cuac se quipacas, yejua mismo in yancuic tasal motocotzoa huan quixcocototzas in tasalsol huan ijcón cachi hueyi tzayanis. ");
INSERT INTO azzNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Huan amo no aquen quipanteca yancuic vino tech in cuetaxsolme, porín de amo in yancuic vino mochicahualtía huan atzitzicasquisas. Huan ijcón quitzayanas in cuetaxsol huan mimilahuis nochi in vino huan senpolihui nochi. Pero in yancuic vino se quitequilía tech in yancuic cuetaxme. ");
INSERT INTO azzNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Huan mochihuac que Yejuatzin panotiaya campa tatocala ica trigo tech ne tonal de nesehuilis. Huan no ihuan yayaj imomachtijcahuan nejnentiayaj, pero yejuan peuque tayolcopinayaj ica trigo. ");
INSERT INTO azzNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ijcuacón in fariseos quilijque Jesús ijcuín: ―Xiquita san, ¿queyé tequititinemij momomachtijcahuan tech nijín tonal de nesehuilis? Porín ne itanahuatil de Moisés tetacahualtía ya. ");
INSERT INTO azzNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Huan Yejuatzin tananquilij ijcuín: ―¿Xe amo queman nanquileerojque ten quichihuac in rey David queman yejua mayanac huan nochin soldados ten ihuan yetoyaj no mayanque? Huan nochi yejuan amo teyi quipiayaj ten cuasquíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Huan yejua in David calayic tech ichantzin Dios, cuac Abiatar catca in hueyi tiopixcat de judiós. Huan ne rey David quicuaj in panes ten quitalijca ya iixpantzinco Dios para ica quimohuistilisque Dios. Huan nojón panes Dios amo quimonequiltij ma acsá quicuani. Ta, sayó in tiopixcame. Pero in rey David quicuaj huan no quinmacac naquen ihuan yayaj. ");
INSERT INTO azzNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Huan no Jesús quinilij ijcuín: ―Huan Totajtzin Dios achto quinchihuac in taca, huan de ompa Yejuatzin quichihuac in tonal de nesehuilis para quinpalehuis in taca. Pero Dios amo quichihuac ne tonal de nesehuilis para ma quinyecanasquía in taca. ");
INSERT INTO azzNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Huan no Jesús quinyecajsicamatiltij ijcuín: ―Xicmatican que nejua ni Yectagatzin de Dios huan Nitayecancatzin de tonal de nesehuilis. Huan Nejuatzin nicpixtinemi tanahuatil para niteilis toni cualtías se quichihuas tech ne tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Huan ocsepa calayic Jesús tech in tiopan de judíos, huan ompa quitac se tagat ten quipiaya se imay mamijmiquilotic. ");
INSERT INTO azzNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Huan in tamatinime judíos quipijpixtinemíaj Jesús cox quipajtisquía ne cocoxque tech ne tonal de nesehuilis. Huan tacán Jesús quipajtisquía ne cocoxque, ijcuacón ne tamatinime cachi oc quipiasquía tensá tamachilis tenica quiteluilisque Jesús de que yejua amo quitacamatinemi in tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Huan ijcón Jesús quilij in tagat ten quipiaya se imay huayic ijcuín: ―Xihuiqui huan xiyeto senteixteno. ");
INSERT INTO azzNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Huan de ompa Jesús quintajtoltij in tamatinime judíos ijcuín: ―¿Cox Dios quimonequiltía ma se quichihua ten cuali tech in tonal de nesehuilis? ¿Oso ma se quichihua de amo cuali? ¿Oso ma se quimaquixti se inemilis? ¿Oso cachi cuali se temictis tech ne tonal de nesehuilis? Huan yejuan sayó motentamatilijque. ");
INSERT INTO azzNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ijcuacón Jesús quincualancaitac neques den quiyehualojtoyaj huan moyolcocoj Jesús porín yejuan yoltacuauque de nintamachilis. De ompa Jesús quilij in tagat cocoxque ijcuín: ―Xicmamelahua momay. Huan yejua momamelahuac ya, ijcuacón ne nimay niman pajtic. ");
INSERT INTO azzNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Huan quisque den tiopan in fariseos huan motajtolcuijque ihuan in taca ten pohuíaj ihuan in rey Herodes para ma quimictisquíaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Huan Jesús mosecoquixtij huan yajqui marteno ihuan imomachtijcahuan. Huan quitoctilijque Jesús huel miacque tagayot de Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Huan cuac quicacque in hueyi chihualisme ten quinchihuaya Jesús, ijcuacón motoquijque campa Yejuatzin huel miacque tagayot de pueblojuani de Jerusalén huan de Judea, huan no hualajque de Idumeajcopaca huan analpa den hueyíat Jordán, huan no de pueblojme de quiyehualojtoya in pueblos de Tiro huan Sidón. ");
INSERT INTO azzNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Huan Jesús quinnahuatij imomachtijcahuan ijcuín: ―Xicsecotalijtocan ya se barco para ompa nicalaquis como quinequij in tagayot nechpejpechisquíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Huan ompa Jesús quinpajtijca ya míac cocoyani, huan cachi oc huel míac cocoyani motoquiayaj para quimatocasquíaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Huan in amocuali ejecame quemansá quitacque Jesús, ijcuacón motentocayaj iixpantzinco, huan tzatzajtzíaj huan quiniliayaj ijcuín: ―Tejuatzin tion Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Huan Jesús quinyectacahualtiaya ne amocuali ejecame para ma amo quitecaquistilianij aconi ne Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Satepan tejcoc Jesús campa se tepeyo huan ompa quinnotzac in taca ten Yejuatzin quinneyic; huan yejuan motoquijque ihuantzin. ");
INSERT INTO azzNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Huan Jesús quinijitac de ne majtactiomome itatitaniluan para ma yetocan ihuantzin. Huan Jesús quintatanic nijín majtactiomome ma tamachtican ica Itajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Huan Jesús quinxejxelohuilij cada se in chicahualis para no tapajtisque ica de míac tataman cocolisme, huan no para quincalanquixtisque in amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Huan Jesús quinijitac nijín majtactiomome ma yesque itatitaniluan de Jesús: Simón ten cojpatocaytij Pedro, ");
INSERT INTO azzNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","huan Jacobo, iconeu de Zebedeo, huan Juan icniu de Jacobo. Nijín omen quinojpatocaytij Boanerges, quitosnejqui taca den yolchicauque queme in taticuinilot, ");
INSERT INTO azzNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Huan no Jesús quinijitac Andrés, huan Felipe, huan Bartolomé, huan Mateo, huan Tomás, huan Jacobo iconeu de Alfeo, huan Tadeo, huan Simón ten pohuía ihuan in taca de yolchicauque, ");
INSERT INTO azzNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Huan no Jesús quijitac in Judas Iscariote, naquen quitemactij Jesús ma quimictican. Huan de ompa Jesús ihuan itatitaniluan yajque ninchancopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Huan ocsepa mosentilijque huel miacque tagayot huan motilintijque hasta amo huelía tacuasquía Jesús ihuan imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Huan queman quicacque nijín, ijcuacón ichancahuan de Jesús hualajque para quimaquixtisque porín quijtoyaj que amo yec talnamiquía oc in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Huan in tanextiliani den tanahuatil de Moisés hualajque de Jerusalén huan quijtoayaj que Jesús quipiaya se amocuali ejecat de monotza Beelzebú. Huan no quijtoayaj que Jesús quincalanquixtij ne amocuali ejecame ica ichicahualis den Beelzebú naquen quinyecantoc nochi in amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Huan Jesús quinnojnotzac in pueblojuani huan quinnextiliaya ica nexcuitilme ijcuín: ―Amo huelis in amocuali Satanás mocalanquixtis yejua mismo in amocuali Satanás. ");
INSERT INTO azzNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Huan tacán in tayecanani de se país motehuijtocque huan moxejxelojtocque se huan ocsé, ijcuacón ne país nochi mohuejuelosque san. ");
INSERT INTO azzNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Huan tacán se calyetoni mocuecuejmolojtocque, ijcuacón ne calyetoni amo no queman huelis sen yectosque ica paquilis. ");
INSERT INTO azzNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Huan tacán in amocuali Satanás motehuía yejua mismo san, ijcuacón nichicahualis momoyautoc san huan moxejxelojtoc san. Huan yejua amo huelis yec yectos huan niman ejcos nitamilis. ");
INSERT INTO azzNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Se tagat ten semi chicahuac monequi ma achto quitzijtzicocan para que ijcón huelis cuejuelohuilisque icalten huan para huelis cuilisque ten niaxca. Porín sayó ijcón huelis moaxcatilisque ten niaxca. Huan xicmatican no ijcón Nejuatzin nicuejuelos in chicahualis den amocuali Satanás. ");
INSERT INTO azzNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Huan no Jesús quinilij in tacaquini ijcuín: ―Huan yec melau den namechilía que nochi in tajtacolme den taca oso in ne mohuispololis ten yesqui, Dios nochi huelis quintapojpoluis. ");
INSERT INTO azzNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Pero naquen quimohuispoloa in Yecticatzin Espíritu, yejua ne amo ica quipías ne tapojpoluilis. Ta, cuicas ne tajtacol nachipa campa tatzacuiltiloyan. ");
INSERT INTO azzNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Huan ijcón quijtoj Jesús porín in tanextiliani den tanahuatil de Moisés quijtojcaj que Yejuatzin quipiaya iyolijtic se amocuali ejecat. ");
INSERT INTO azzNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Huan satepan ajsicque campa yetoya Jesús niicnihuan huan ninantzin de Jesús huan mocauque calampa huan quitatitanijque. ");
INSERT INTO azzNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Huan in tagayot ten tocotziutoyaj quiyehualojtoyaj Jesús, yejuan nojonques quilijque ijcuín: ―Monantzin huan mocihuan yetocque ne calampa huan mitztemoaj. ");
INSERT INTO azzNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Huan Jesús quinnanquilij ijcuín: ―¿Aconi nicpohua queme nonantzin oso nocnihuan? ");
INSERT INTO azzNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ijcuacón Jesús quinsenitac naquen tocotziutoyaj quiyehualojtoyaj huan quinilij ijcuín: ―Xiquitacan, yejuan nijinques ten nican yetocque niquinpohua queme nonantzin huan nocnihuan. ");
INSERT INTO azzNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Huan nochi naquen quitacamatisque ten Dios quimonequiltía, yejuan nijinques niquinpohuas queme noicniutagat huan noicniusihuat huan nonantzin. ");
INSERT INTO azzNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Huan ocsepa pehuac Jesús tamachtía tech se atenteno, huan míac tagayot mosentilijque huan quiyehualojtoyaj campa Jesús yetoya hasta monequía calaquis Jesús tech se barco aixco huan itech motalij. Huan nochi in tagayot yetoyaj tech ne atenteno. ");
INSERT INTO azzNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Huan Jesús quinmachtiaya míac tensá ica míac nexcuitilme huan quinmachtiaya ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","―Xiquitacan huan xicaquican ten namechiliti: Se tonal quisac se tagat para quitepehuas in tatoc de trigojtet. ");
INSERT INTO azzNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Huan cuac quitepehuac ya, ijcuacón mochihuac que casaica huetzic in tatoc ojtenteno, huan hualajque in tototzitzin den patantinemij ejecaixco huan quicuajcoj. ");
INSERT INTO azzNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Huan ocseco cansaica huetzic in tatoc de trigo itech tepetatal campa amo oncaya míac tal. Huan in tatoc niman ijsiucaixuac porín amo tilahuac in tal quipiaya. ");
INSERT INTO azzNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ica ya nojón cuac panquisac ya in tonaltzin, ijcuacón machichinahuic. Huan queme amo quipiaya míac inaluayo, ica ya nojón niman huayic. ");
INSERT INTO azzNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Huan ocseco cansaica huetzic in tatoc de trigojtet huitztzalan. Huan in huitzti ixuac itzalan in tatoc huan quipachoj in tatoc huan amo teyi taquic. ");
INSERT INTO azzNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Huan ocseco huetzic cansaica in tatoc de trigojtet itech cualital huan ompa motaquiltij cualtzin. Pues ixuac in tatoc huan quitemacac míac taquilome. Huan sequi in tatoc moscaltij huan momiactilij huan quitemacac ocsé sempoal huan májtacti taquilome. Huan ocsequin quitemacac ocsé eyipoal taquilome. Huan ocsequin quitemacac ocsé macuilpoal taquilome. ");
INSERT INTO azzNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ijcuacón quinilij Jesús ijcuín: ―Naquen quipía ninacas para tacaquis, ma yectacaqui huan cajsicamatis nijín tanextililis. ");
INSERT INTO azzNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Huan cuac yetoya iselti Jesús, ijcuacón hualajque in majtactiomome imomachtijcahuan huan ocsequi ten ninuan yetoyaj, huan yejuan quitajtoltijque Jesús de toni quijtosnequi no ne nexcuitilme tenica Jesús quinmachtijtinemic. ");
INSERT INTO azzNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Huan Jesús quinilij ijcuín: ―Dios namechmatiltijtoc ya namejuan de neichtacatamachilis de queniu Dios namechyolyecantinemi itaneltocacahuan ica ihueyichicahualis. Huan in ocsequin tagayot ten amo poutinemij ihuan Dios, yejuan nojonques monequi ma tiquinmachtican ica nexcuitilme san den nochi totamachtilis. ");
INSERT INTO azzNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Huan ijcón yejuan quitasque in nexcuitil. Huan masqui quitasque ya, pero amo cajsicamatisque. Huan yejuan cuac quicaquisquej in nexcuitil, masqui ipa yec tacaquij, pero amo no cajsicamatisque. Huan ijcón mochihuasque para ma amo moyolnemilican huan para ma amo Dios quintapojpolui den nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Huan no quinilij Jesús ijcuín: ―¿Xe amo nanquiyecajsicamatij nijín nexcuitil? Huan como amo nancajsicamatque, ¿quenín huelis nancajsicamatisque nochi in ocsequi nexcuitilme? ");
INSERT INTO azzNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ne tagat ten tatepeuque, yejua ne tamachtijtinemi ica in Tajtoltzin de Dios, ijcón queme se tatepeuque tamoyautinemi ica trigojtet. ");
INSERT INTO azzNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Huan in tacaquini ten yetocque ojtenteno, yejuan nojonques ninyolijtic quitocque in Tajoltzin de Dios. Huan cuac quicaquij, ijcuacón amo huejcahuas nintaneltocalis. Ta, huitza in amocuali Satanás huan quinajchihuilía in Tatoltzin de Dios ten tatoc itech ninyolijtic. ");
INSERT INTO azzNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Huan no ijcón ne trigo tatoc ten huetzic tejteixco, yejua ne quinejnehuilía in tacaquini ten ninyolitic quitocque in Tajtoltzin de Dios. Huan cuac yejuan quicaquij, ijcuacón nimantzin quiselíaj in Tajtoltzin ica míac paquilis. ");
INSERT INTO azzNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero amo quipíaj se yec tacuautamatilis tech ninyolitic queme se naluat para quinchicahualtis in tatoc. Huan ica ya nojón amo huejcahuas nintacuautamatilis. Huan cuac nintech huitza in tajyohuilis oso ne tahuelitalis ica in Tajtoltzin de Dios, ijcuacón moyojyolquepaj de nintaneltocalis. ");
INSERT INTO azzNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Huan nojón tacaquini yetoyaj huitztzalan, naquen quicaquij in Tajtoltzin de Dios. Huan yejuan quinejnehuilíaj in tatoc ten huetzi huitztzalan. ");
INSERT INTO azzNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Huan quicaquij in Tajtoltzin de Dios pero moyolpolojtinemij ica de míac tataman den nijín talticpac nemilis, huan mocajcayahuaj ica ne hueyi ricojyot huan quinejnequij de míac den tenesi san. Nochi nijín tanemililis calaqui tech ninyolojuan huan quitajtamía in Tajtoltzin de Dios huan amo teyi taquilot mochihuas. ");
INSERT INTO azzNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Huan nojón tatoc ten huetzic itech cualital, yejua ne quinejnehuilía in tagat ten quicaquij in Tajtoltzin de Dios huan quiselía. Huan in Tajtoltzin de Dios momiactilía tech niyolitic, ijcón queme se tatoc quitemaca ocsé sempoal huan májtacti taquilome. Huan ocsé tatoc quitemaca eyipoal taquilome. Huan ocsé tatoc quitemaca macuilpoal taquilome. ");
INSERT INTO azzNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Huan Jesús no quinilij in tacaquini ijcuín: ―¿Mangán acsá cualcuis se tanex huan quitalis tatampa de se cajón oso tatampa de cama? Pues, amo ijcón se quichihuas. ¿Cox amo cachi cuali se quitalis ne tahuil campa tasempayan para ma tahuis nohuiyampa? Pues, quema. ");
INSERT INTO azzNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Porín amo ongac teyi tensá chihualis oso tanemililis ichtacayot de que ma amo quipía de que ixnesis. Huan amo no ongac tensá chihualis oso tanemililis ten motatijtihualaya de que ma amo quipía de que monextis huan quimatisque nohuiyampa. ");
INSERT INTO azzNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Tacán acsá quipía inacas para tacaquis, pues ma yec tacaqui. ");
INSERT INTO azzNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Huan Jesús no quinilij in tacaquini ijcuín: ―Xicyecchihuacan cuenta namejuan ten nanquicactocque porín in tamachiu de teicnelilis tenica nanquitamachihuaj para ocsequin tagayot, no ijcón Dios namechtamachihuilis para namejuan. Huan cachi oc in tagayot namechtamajxitilisque ica ne teicnelilis como nanteicnelíaj, namejuan ten nannechcaquilijtocque. ");
INSERT INTO azzNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Huan nochi naquen quipíaj tamachilisme de Dios huan quitequitiltíaj, yejuan nojonques cachi oc Dios quinmajxitilis. Pero nochi naquen quipíaj tzictzin san tamachilisme de Dios huan quipohuaj que amo teyi quipíaj, yejuan nojonques Dios quintamicuilis ne tepitzin ten quipíaj, porín amo quitequitiltíaj ne tepitzin ten quipíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Huan no Jesús quinmachtij in tacaquini nijín nexcuitil: ―Nicnejnehuililtía ne chicahualis de Dios cuac Yejuatzin momasoutoc ica ihueyichicahualis itech se iyolijtic queme se tagat ten quitalía se tatoc tech in tal. ");
INSERT INTO azzNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Huan in tagat cochis tayohuac huan nimampa mehuas tonayan huan ijcón panoa in tonalme. Huan in xinach ixua, moscaltía huan xochiohua, pero in tagat amo quemati quiniu mochiutoc. ");
INSERT INTO azzNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Porín ica ichicahualis den tal mochihua ne taquilot, achto in xihuit, niman ichicahualoni, huan satepan in xinach mochicahualtía tech ne ichicahualoni. ");
INSERT INTO azzNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Huan queman in taquilot chicahuayas ya, ijcuacón nimantzin se quitequi porín ejcoc ya in tonal de tatequilis. ");
INSERT INTO azzNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Huan Jesús no quinilij in tacaquini ijcuín: ―¿Tonica huelis ticnejnehuililtisque ne chicahualis de Dios cuac Yejuatzin momasoutoc itech se iyolijtic? Huan, ¿ica toni nexcuitil ticnejnehuililtisque nijín chicahualis de Dios? ");
INSERT INTO azzNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","In chicahualis de Dios itech se iyolijtic queme yesquía in xinach de se cuohuit de mostazajtet, ten acsá quitoca tech in tal. Yejua ne mostazajtet de cachi tziquitzin de nochi xinachme ten ongac nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Pero satepan de acsá quitocas, ijcuacón ne mostazajtet moscaltís huan mochihuas in cachi hueyi que nochi in cuoume ten quitemaca taquilot. Huan ne mostazajcuohuit huejueyis huan momajmaxaloas. Huan huelis ompa no in tototzitzin ten nemij ejecaixco motapajsoltisque tech niyecahuil. ");
INSERT INTO azzNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ca míac nexcuitilme queme nijinque Jesús quinnojnotzaya in tacaquini, ijcón queme huelisquíaj cajsicamatisquíaj in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Huan como amo ica nexcuitilme, ijcuacón amo teyi quiniliaya Jesús. Huan cuac ninseltij yetoyaj imomachtijcahuan ihuan Jesús, ijcuacón Yejuatzin quinyequiliaya toni quijtosnequi in nexcuitilme. ");
INSERT INTO azzNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Huan tech ne tonal queman tapoyahuic, Jesús quinilij imomachtijcahuan ijcuín: ―Ma tipanocan ne sentapalpa de nijín hueyíat. ");
INSERT INTO azzNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Huan quincauque in tagayot huan imomachtijcahuan cuiyacque Jesús ninuan tech barco. Yejuatzin ipa yetoya ya tech in barco. Huan ocsequin barcos ninuan quisehuicayaj. ");
INSERT INTO azzNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Huan pehuaco se hueyi tetzaucaejecat huan quitatamotaya in at tech in barco, huan ijcón motac que pancalaquisquía in barco. ");
INSERT INTO azzNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Huan Jesús yetoya ijtic den barco tacuitapampa cochtoya tech se tapech. Huan quimoucaijxitijque imomachtijcahuan huan quilijque ijcuín: ―Totamachtijcau, ¿xe amo titechonpía cuidado que tipolihuitij ya? ");
INSERT INTO azzNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Huan cuac Jesús mehuac, ijcuacón Yejuatzin quitacahualtij in tetzaucaejecat huan quilij ne hueyíat ijcuín: ―Ximotamatili huan amo ximoolini oc. Huan ijcuacón motamatilij in ejecat huan in hueyíat mocahuac ijcón amanis. ");
INSERT INTO azzNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Huan Jesús quinilij imomachtijcahuan ijcuín: ―¿Queyé nanmoucamiquij? Huan, ¿queyé amo nanquipíaj tacuautamatilis ten yec majsitoc? ");
INSERT INTO azzNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ijcuacón cachi motelmoutijque huan moixpantiliayaj imomachtijcahuan se huan ocsé ijcuín: ―¿Aconi nijín tagat? Hasta nochi in ejecat huan in mar quitacamatij. ");
INSERT INTO azzNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ijcuacón Jesús huan imomachtijcahuan ajsicque sentapalpa den hueyíat de mar de Galilea, ompa ninchanpan den pueblojuani de Gadara. ");
INSERT INTO azzNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Huan cuac Yejuatzin quisac den ne barco, ijcuacón nimantzin huala quixnamiquico den ne tech in ánimajtecochme se tagat ten quipíac iyolijtic se amocuali ejecat. ");
INSERT INTO azzNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nijín tagat quipiaya icochyan tech in ánimajtecochme, huan amo aquen hueliaya quilpis, nión ica teposmecat de cadenas. ");
INSERT INTO azzNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Porín miacpa ya quijilpiayaj ca teposmecat tech imetzuan huan tech imahuan. Huan in cadenas nochi quincocototzac huan in teposmecat quicojcotonac, huan amo aquen se tagat huelía quitamatilis. ");
INSERT INTO azzNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Huan nachipa de tonayan huan ca yohual ne tagat tahuel tzajtzitinemía ne cuouta huan ne ánimajtecochpan. Huan yejua mismo ica tet mocojcocojtinemía. ");
INSERT INTO azzNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Pero cuac ne tagat tahuel quitac Jesús de huejca, niman motaloj huan motancuaquetzato iixpantzinco Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Huan motatautij ica hueyi tzajtzilis ijcuín: ―¿Toni ticonpía nohuan, Jesús? Titeconetzin de Dios in cachi hueyi chiuque. Nimitzteltatautía yec melau que amo xinechtajyohuilti. ");
INSERT INTO azzNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Porín Jesús achto quilijca ya ne tahuel ijcuín: ―Tejua tiamocuali ejecat, xihualquisa itech niyolijtic de nijín tagat. ");
INSERT INTO azzNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Huan Jesús quitajtoltij in amocuali ejecat ijcuín: ―¿Toni motocay? Huan yejua tananquilij: ―Timiacque, ijcón nimonotza, porín yec melan titelmiacque. ");
INSERT INTO azzNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Huan niman nocta motatautiaya ne amocuali ejecame ihuan Jesús ma amo quincalanquixtisquía de ne pueblo. ");
INSERT INTO azzNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Huan no yetoyaj amo huejca de ne cuouta míac pitzome tacuajtoyaj huan ixtahuanentoyaj. ");
INSERT INTO azzNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ica ya nojón in amocuali ejecame quitatautijque Jesús ijcuín: ―Xitechtotoca campa ne pitzome ma nintech ticalaquican tejuan. ");
INSERT INTO azzNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Huan niman Jesús quintacahuilij ma yacan. Huan quisque ne amocualime ejecame itech ne tagat, huan calacque tech in pitzome. Huan in pitzome catcaj telmiacque queme ome mil. Huan ne pitzome nochi motalojtinenque huan motaquesuijque huan huetzitoj aijtic huan moaelsimijque tech in marijtic. ");
INSERT INTO azzNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Huan naconime pitzotajpiani moucacholojque huan yajque calaquitoj tech ninpuebloj huan tech in milajpa huan quitetapohuitoj de toni mochihuac. Huan niman in pueblojuani quisque huan hualajque quitacoj toni mochihuac itech ne tagat ten tahuel catca. ");
INSERT INTO azzNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Huan cuac hualajque nochi in pueblojuani campa yetoya Jesús, ijcuacón quitacque in tagat ten quipiaya iyolijtic miacque amocuali ejecame. Huan cajsic ya ne tagat huan yejua tocotziutoc ya huan taquentoc ya huan yec talnamictoc ya, huan ijcón nochi in pueblojuani quimoucaitacque. ");
INSERT INTO azzNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Huan ijcuacón in pitzotajpiani quintapohuijque in pueblojuani ten yejuan quitayaj huan queniu quipanoltiaya ne tagat ten quinpiaya in amocuali ejecame. Huan no quintapohuijque ten mochihuac ica ne pitzome. ");
INSERT INTO azzNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Huan de ompa in pueblojuani peuque quitatautiayaj Jesús ma cachi cuali ma quisa Jesús de nican ninpueblojcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Huan cuac Yejuatzin calayic tech in barco, ijcuacón ne tagat ten quinpiaya in amocuali ejecame, yejua nojón quitatautiaya Jesús ma quitacahuili oc ma ihuan Jesús nentinemi oc. ");
INSERT INTO azzNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Pero Jesús amo quitacahuilij. Ta, quilij ijcuín: ―Xiyó mochan campa mochancahuan huan xiquintapohuiti nochi ten Dios quichihuac para tejua. Huan no xiquiniliti de queniu Dios mitzpialij míac teicnelilis. ");
INSERT INTO azzNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Huan ijcuacón in tagat yajqui huan pehuac quitetapohuía campa ne májtacti pueblome, toni huejueyi tatiochihualisme quichihuac Jesús por yejua. Huan nochi tagayot quimoucacacque ten quinilij ne tagat ten tahuel catca. ");
INSERT INTO azzNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Huan cuac Jesús yajqui tech in barco huan ajsic sentapalpa den hueyíat de mar de Galilea, ijcuacón mosentilijque quiyehualojque Jesús tel míac tagayot. Huan Yejuatzin yetoya marteno. ");
INSERT INTO azzNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ijcuacón huala se tayecanque tagat den tiopan de judíos, ten monotzaya Jairo. Huan niman cuac quitac Jesús, ijcuacón motancuaquetzac iicxitan. ");
INSERT INTO azzNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Huan quiteltatautiaya Jesús huan quiliaya ijcuín: ―Nosuapil xicautoc ya de cocolis. Xionuiqui tejuatzin, huan xicsohua momatzitzin inpan nosuapil para ma maquisa de ne cocolis huan ma nemi oc. ");
INSERT INTO azzNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ijcuacón Jesús yajqui ihuan Jairo. Huan no quitojtocayaj huel míac tagayot hasta quitojtopehuayaj. ");
INSERT INTO azzNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Huan no yetoya se sihuat ten mococoaya esmeyaya, pues cuicaya ya majtactiomome xihuit. ");
INSERT INTO azzNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Huan semi tajyohuiaya ne sihuatzin, huan míac tepajtiani mopapatacque ya, huan nochi nitomin quitamilijcaj ya. Huan in sihuat amo teyi quimachiliaya de que cox nenquentisquía. Ta, cachi mohueyichihuaya ne cocolis. ");
INSERT INTO azzNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Huan nijín sihuat cuac quicayic ten motapohuiaya de Jesús, ijcuacón huala icampa de Jesús, tatzalan de ne tagayot, huan quinalmatoquilij itilmajtzin de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Porín sihuat quinemiliaya ijcuín: “Ta sayó nicnalmatocas ya nitilmajtzin, ijcuacón nejua nipajtis”. ");
INSERT INTO azzNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Huan niman cuac quimatocac ya itilmajtzin, ijcuacón iesyo ten meyaya tzicahuic ya, huan quimachilij ninacayo nequentic ya de ne tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Huan niman Jesús quixmatic de Yejuatzin mismo que quisac ya nichicahulis. Huan Jesús mocuepac huan quisenitac campa yetoyaj in tagayot, huan quintajtoltij ijcuín: ―¿Aconi nechmatoquilij notilma? ");
INSERT INTO azzNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ijcuacón imomachtijcahuan quilijque Jesús ijcuín: ―Xiconita, míac tagayot mitztojtopehuayaj huan tejuatzin ticonijtoj ijcuín: “¿Aconi necholinij?” ");
INSERT INTO azzNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero Yejuatzin ixnenemía taicampa para quitasquía aconi quimatocac itilma. ");
INSERT INTO azzNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Huan in sihuat motelajsicamoutiaya hasta huihuiyocaya porín quimatoya toni mochiuca ya itech yejua. Ijcuacón huala in sihuat motancuaquetzaco iixtenojtzinco huan quiyequijto Jesús ten yec melau toni mochiuca ya itech yejua. ");
INSERT INTO azzNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Huan niman Jesús quilij in sihuat: ―Sihuat, ica por nojón motacuautamatilis ten ticpía, tejua tipajtic ya. Huan axcan xiyó ya xiyolseutiu, huan ximocahua pajtic ya de ne tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mientras Yejuatzin tajtojtoya oc, ijcuacón hualajque ichancahuan de Jairo in tayecanque tagat de ne tiopan de judíos, huan quilijque Jairo ijcuín: ―Mosuapil miquic ya. ¿Para toni oc ticuejsojtoc in Tamachtijque? ");
INSERT INTO azzNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Pero Jesús amo quichihuac cuenta den quijtoayaj yejuan huan quilij in tayecanque tagat de ne tiopan de judíos ijcuín: ―Amo ximomouti. Ta, sayó xitacuautamati nohuan. ");
INSERT INTO azzNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Huan Yejuatzin amo quintacahuilij ma aquen quitoctilianij. Ta, sayó Pedro, Jacobo, huan in Juan iicniu de Jacobo. ");
INSERT INTO azzNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Huan queman Jesús ajsic ichan de ne hueyi chiuque de tiopan de judíos, ijcuacón quitac hueyi ne cuejmololis huan nochi chocatoyaj huan motequipachoayaj huan tzajtzíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Huan Jesús calayic calijtic huan quinilij ijcuín: ―¿Queyé nanmotelcuejsoaj huan nanchocatocque? In sihuapiltzin amo miyic. Ta, sayó cochtoc. ");
INSERT INTO azzNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Huan quitelquejqueloayaj Jesús. Huan Yejuatzin quincalanquixtij nochi in tagayot, huan quinuiyac sayó in tetat huan in tenan den suapil ihuan imomachtijcahuan ten yayaj ihuan. Huan nochi yejuan calacque campa huetztoya in suapil. ");
INSERT INTO azzNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Huan ijcón Jesús quimatilanac in sihuapil huan quilij ijcuín: ―Talita, cumi―, quijtosnequi: Suapiltzin, tejua nimitzilía ximehua. ");
INSERT INTO azzNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Huan niman in suapiltzin moquetzac huan nenemic, porín yejua quipiaya majtactiomome xihuit. Huan ijcón motelajsicamoutijque ichancahuan den suapil. ");
INSERT INTO azzNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Pero Yejuatzin quintelnajnahuatij ma amo aquen quimatiltican toni mochihuac, huan no quinnahuatij ma quitamacacan in suapil. ");
INSERT INTO azzNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Huan Jesús majchihuac de ne marteno huan yajqui ipueblocopaca de ne Nazaret huan ihuan yajque imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Huan ajsic tech se tonal de nesehuilis huan calayic tech in tiopan de judíos, huan pehuac tamachtiaya ica in Tajtoltzin de Dios. Huan miacque quicaquiliayaj huan quimoucaitayaj huan quijtoayaj ijcuín: ―Pues, ¿can cajsic ne tagat nijín tamachtilis? Huan, ¿toni quijtosnequi nijín tanemililis ten yejua quipía? ¡Huan semi huejueyin chihualis ten quichihuac Yejuatzin ica nimahuan! ");
INSERT INTO azzNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Huan no quijtoayaj ijcuín: ―¿Xe amo nijín in cuouxinque, iconeu María huan iicnihuan Jacobo, José, Judas huan Simón? Pues quema. ¿Xe amo no nican yetocque tohuan iicnihuan suame? Pues quema. Huan yejuan quimachiliayaj que quixnamiquisquíaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Huan Jesús quiniliaya ijcuín: ―Nochin tagayot quitasojtaj se itanahuatijcau de Dios. Pero campa ipueblo de ne tanahuatijque, campa niparientes huan nichancahuan yetoyaj, ompa amo quitasojtaj porín ompacayot. ");
INSERT INTO azzNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ica nijín amo teyi hueli Jesús quichihuac den hueyi chihualisme tech ipueblo Nazaret. Ta, sayó quinpajtij Jesús se ome eyi cocoyani san ten momatalij ninpan. ");
INSERT INTO azzNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Huan Jesús quinmoucaitaya in pueblojuani de Nazaret porín yejuan amo yec tacuautamatiayaj tech Yejuatzin. Huan Jesús nejnetinemía tech nochi ocsequi pueblos huan tamachtijtinemía nohuiyampa ica in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Huan ijcuacón Jesús quinnotzac in majtactiomome imomachtijcahuan, huan pehuac quinnajnahuatía ma yacan ojomen san. Huan Jesús quinmactilij in tanahuatil para ijcón huelis quincalanquixtisque in amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Huan no Jesús quinnahuatij ma amo cuiyacan nión teyi para tenica mopalehuisque tech in ojti. Ta, sayó ma cuiyacan nintopil. Huan nión no ma amo cuiyacan nintominpialoni, huan nión tacualis, nión tomin tech nintajcuilpica. ");
INSERT INTO azzNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Huan Jesús quinnahuatij ma motegactican, huan ma cuiyacan se camisa san huan amo ome ixnepan de tasal. ");
INSERT INTO azzNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Huan no Jesús quinilij ijcuín: ―Campa yesqui nancalaquitihue tech se cali, ompa ximocahuacan hasta cuac nanquisasque tech ne pueblo. ");
INSERT INTO azzNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Huan tacán cansica amo namechselíaj tech se cali, huan amo namechcaquilíaj, ijcuacón xiquisacan niman de ompa huan ximometztzejtzelocan para ma huetzi in talnex nochi ten mopiloj namometztampa para que ijcón ixnesis que Dios quintatzacuiltis ne pueblojuani porín yejuan quixtopeuque in Tajtoltzin de Dios. De yec melau den namechilía que tech ne tonal cuac huetzis in hueyi tatzacuiltilis de Dios, ijcuacón cachi ongas tajyohuilis tech ne pueblome campa amo taneltocacque huan que quipiasque in ome pueblome de Sodoma huan Gomorra campa nintech huetzic in tatzacuiltilis ica tit de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Huan ijcón imomachtijcahuan quisque huan peuque quinchicaucanahuatiayaj in pueblojuani de que ma moyolnemilican de nintajtacoluan nochi in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Huan no ijcón imomachtijcahuan quincalanquixtiayaj in amocuali ejecame, huan no quincuaojxiliayaj aceite míac cocoyani huan no yejuan pajtique. ");
INSERT INTO azzNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Huan in rey Herodes quicayic in hueyi chihualis de Jesús, porín nonohuiyan mopohuaya in chicahualis de Jesús. Huan ijcuacón in rey Herodes quixejecoj que in Juan Taahuijque panquisac ya yoltoc itzalan ne ánimajme, huan ica ya nojón mochiutoc nochi nijín huejueyin chihualisme. ");
INSERT INTO azzNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Porín sequin quijtoayaj de Jesús ijcuín: ―Achá yejua in Elías ne huejcautanahuatijque de Dios ten quichiutoc nijín chihualisme. Huan ocsequin quitoayaj ijcuín: ―Achá yesqui ocsé itanahuatijcau de Dios, oso senme den huejcautanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Huan queman quicayic nijín tajtolme, ijcuacón in rey Herodes quijtoj ijcuín: ―Yejua nijín Juan ten nejuatzin nitatitanic ma quiquechcotonacan, huan yejua ne panquisac yoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Porín rey Herodes quintanahuatilijca in soldados de que ma quiquitzquican preso in Juan, huan ma quitzijtzicocan ca cadenas tech in cárcel. Achto ya in rey Herodes quiixuelitac icuñada huan quinequía quipactis in suapil, monotzaya Herodías, yejua isihuau in Felipe, huan in Felipe yejua icniutagat den rey Herodes. Huan in rey Herodes ipa quicuilij ya icuñada para yesqui isihuau. ");
INSERT INTO azzNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Pero in Juan Taahuijque ipa quilijca ya in rey Herodes ijcuín: ―Dios amo quimonequiltía ticpías queme mosihuau nijín isihuau de mocniu. ");
INSERT INTO azzNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Huan ne sihuat Herodías ipa quicualancaitaya in Juan, huan semi quinequía majcán quimicti in Juan, pero amo huelía. ");
INSERT INTO azzNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Porín rey Herodes quimoucatocaya in Juan, huan quimatoya que in Juan se tagat ten yolcuali huan yolchipahuac. Huan in rey Herodes ipa amo quitecahuiliaya de que ma quicojcococan in Juan. Huan cuac in rey Herodes quicaquilij nitanojnotzalis de Juan, ijcuacón ipa mocahuac semi yoltanemilijque, pero quicaquiliaya ca míac paquilis. ");
INSERT INTO azzNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Huan in sihuat Herodías cajsic huelilis tech ne tonal cuac in rey xiumajsic. Huan in rey Herodes quintatamacac nochi in hueyi chihuanime huan no in tayecanani de soldados huan in huejueyi ricojme de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Huan tech nojón hora calaquito isihuapil de ne sihuat Herodías huan pehuac mijtotía, huan ijcón semi quiyolpactij in rey Herodes huan no quinyolpactij naquen ihuan yetoyaj in rey Herodes tacuajtoyaj. Huan ijcuacón rey Herodes quilij in suapil ijcuín: ―Tejua tihuelis tinechtajtanilis nochi ten ticnequis, huan nejuatzin nimitzmactis. ");
INSERT INTO azzNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Huan ijcón rey Herodes moyectencahuac ihuan in suapil huan no quilij ijcuín: ―Dios quitztoc, nochi ten tinechtajtanilis, nimitzmactis, masqui yec tajco den país ten nejuatzin noaxca. ");
INSERT INTO azzNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Huan sihuapil yajqui huan quilito quiixpantilito inan Herodías ijcuín: ―¿Toni nictajtanilis? Huan inan den suapil, yejua Herodías quinanquilij ijcuín: ―Xictajtanili nitzontecon de Juan Taahuijque. ");
INSERT INTO azzNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Huan in sihuapil ijsiucacalayic campa in rey Herodes huan quitajtanilij ijcuín: ―Nicnequi xinechonmacti axcan ipan se plato nitzontecon den Juan Taahuijque. ");
INSERT INTO azzNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Huan in rey Herodes nocta yoltayocoyac. Huan amo quineyic motajtolcuepas oc porín yejua moyectencauca ya ihuan in suapil ne achtopa, huan no porín nochi tayecanani den tacuajtoyaj no cactoyaj. ");
INSERT INTO azzNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Huan niman in rey Herodes quititanic senme den tajpiani huan tanahuatij ma quiquechcotonacan ne Juan Taahuijque huan ma cualcuilican nitzontecon. ");
INSERT INTO azzNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Huan ijcón in tajpiaque yajqui campa in cárcel huan ompa quiquechcotonque in Juan ne cárcelijtic huan cualic itzontecon tech se plato huan quimactijque in suapil. Huan in suapil quimactito inan Herodías. ");
INSERT INTO azzNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Huan queman ijcón quicacque, ijcuacón imomachtijcahuan de Juan hualajque huan quicuicque inacayo in Juan huan quitalitoj tech in miquetecoch. ");
INSERT INTO azzNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ijcuacón in apóstoles in tatitanilme de Jesús Temaquixtijque mosentilijque ihuan Jesús huan quitapohuijque nochi ten quichiuque huan ten yejuan tamachtijcaj ya. ");
INSERT INTO azzNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Huan Yejuatzin quinilij ijcuín: ―Xihualacan nohuan namejuan namoseltij tech ne lugar campa amo aca yetoc huan ximosehuican tepitzin. Huan Jesús quinilij ne tajtol porín nocta míac tagayot yayaj huan hualayaj, huan hasta amo quemantíaj oc para tacuasquíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Huan ijcón yajque Jesús ihuan imomachtijcahuan ninseltij tech se barco hasta campa se lugar campa tayiucan. ");
INSERT INTO azzNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero míac tagayot quinitacque cuac yajque Jesús ihuan imomachtijcahuan huan quinixmatque. Huan miacque den pueblojuani yajque no ompa metznejnenque huan ajsicque achto que Yejuatzin, huan mosentilijque quichixtoyaj campa Yejuatzin yaya. ");
INSERT INTO azzNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Huan cuac Jesús quisac tech ne barco, ijcuacón Yejuatzin quitac tel míac tagayot huan quimachilij se hueyi teicnelilis de yejuan porín catcaj queme ichcatzitzin ten amo quipiayaj tapixque. Huan niman Jesús pehuac quinmachtía ica míac tataman tamachtilisme. ");
INSERT INTO azzNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Huan cuac ne semi tiotactiaya ya, ijcuacón imomachtijcahuan motoquijque ihuan Jesús huan quilijque ijcuín: ―Nican semi tayiucan huan tiotac ya. ");
INSERT INTO azzNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Xiquinnahuati in tagayot ma yacan huan ma tacohuatij tech in pueblos huan tech in milajpa ten amo huejca, porín in tagayot amo quipíaj toni cuasque. ");
INSERT INTO azzNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Huan Jesús quinnanquilij ijcuín: ―Xiquintamacacan namejuan san. Huan yejuan tananquilijque ijcuín: ―¿Xe tejuan tiyasque titacohuasque májtactipoal denario de pan ―yesqui ome mil pesos de pan―, huan ma tejuan tiquintamacasque? ");
INSERT INTO azzNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Huan Yejuatzin quinilij ijcuín: ―¿Canachi panes nanquinpíaj? Xiyacan xiquinitacan. Huan cuac quimatque, ijcuacón quilijque Jesús ijcuín: ―Ticpíaj macuil panes huan ome pescadojtzitzin. ");
INSERT INTO azzNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Huan Jesús quinnahuatij in tagayot ma moojolochtalican inpan in taselot. ");
INSERT INTO azzNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Huan ijcón nochi moojolochtalijque, huan motecpanque, sequin majmacuilpoal, huan ocsequin ojomepoal huan májtacti. ");
INSERT INTO azzNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ijcuacón in Jesús quicuic in macuil panes huan in ome pescados, huan moixajocuic eluiyactzinco huan quitatautij Dios ma quitiochihuac in tacualis. Huan de ompa quincojcotonac in panes huan quinmactilij imomachtijcahuan para ma yejuan quinxejxelohuilisque in tagayot. Huan no ijcón quinxejxelohuilijque in ome pescadojnacat. ");
INSERT INTO azzNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Huan ijcón nochi in tagayot tacuajque huan ixuicque. ");
INSERT INTO azzNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Huan niman imomachtijcahuan cololojque pan tatetejtec huan no cololojque ten mocahuac den pescadojnacat ica majtactiomome chiquihuime pexontoyaj. ");
INSERT INTO azzNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Huan nijín tagayot ten tacuajque catca macuil mil taca. ");
INSERT INTO azzNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Huan niman Jesús quinnahuatij imomachtijcahuan ma calaquican tech in barco, huan ma yacan ma quiachtohuican Jesús ne pueblo de Betsaida tech ne ocsé atenteno, mientras Yejuatzin quinilij in tagayot ma yacan ninchan. ");
INSERT INTO azzNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Huan satepan de quinnajnahuatij in tagayot ma yacan, ijcuacón Jesús yajqui ne tepeyo huan motatatautilito ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Huan queman tapoyahuic ya, ijcuacón tanejnemiltijtoyaj imomachtijcahuan ica nijín barco hasta ne tatajco den mar, huan Jesús iselti mocahuac talixco. ");
INSERT INTO azzNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Huan Jesús quinitac imomachtijcahuan de que quinejnemiltiayaj in barco ica míac ohuijcayot porín in ejecat quintzatzacuiliaya. Huan cuac ipa tanextihuitz ya, ijcuacón huala Jesús quinajsico imomachtijcahuan nejnentihuala aixco, huan quinequía quinpanahuijtiquisac. ");
INSERT INTO azzNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Huan queman imomachtijcahuan quitacque Jesús nejnentihualaya aixco, ijcuacón quinemilijque que catca se ánima huan moucatzajtzicque. ");
INSERT INTO azzNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Porín nochi imomachtijcahuan cuac quitacque Jesús, ijcuacón yejuan quihueyimoucaitacque. Huan nimantzin Jesús quinnotzac huan quinilij ijcuín: ―Ximoyolchicahuacan, Nejuatzin ya ni Jesús, amo ximomoutican. ");
INSERT INTO azzNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Huan cuac tejoc Jesús tech in barco campa yetoyaj imomachtijcahuan, ijcuacón motamatilij in ejecat. Huan yejuan quimoucaitacque telsenca huan quitetzaucaitacque. ");
INSERT INTO azzNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Huan imomachtijcahuan ayamo cajsicamatíaj in hueyi chicahualis de Jesús cuac Yejuatzin quinxejxelohuilij in tagayot in panes. Huan imomachtijcahuan amo cajsicamatque porín yejuan yolpipicticque oc catcaj de nintamachilis porín ayamo yec tacuautamatinemíaj ihuan Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Huan cuac quinpanahuijque ya in mar, ijcuacón Jesús ihuan imomachtijcahuan ajsitoj tech tal ten pohuía Genesaret, huan quiquetzatoj huan quitzijcojque in barco martenteno. ");
INSERT INTO azzNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Huan cuac quisque den barco, nimantzin in tagayot quixmatque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Huan niman motalojtinemíaj calpan para quitetapohuisque de Jesús, huan pehuac quinualcuilíaj in cocoyani de nohuiyan tech nincochpet campa ne motapohuijque que yetosquía Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Huan campa yesqui calaquisquía Jesús tech ne pueblojtzitzin, oso huejueyin pueblo, oso mijmilapa, ompa quintalijque cocoyani ojtipan huan quitatautiayaj Jesús ma quincahua ma quimatocacan sayó itilmajteno. Huan nochi ten quimatocacque Jesús, nochi pajtijque ya. ");
INSERT INTO azzNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Huan mosentilijque in fariseos campa yetoya Jesús huan no yetoyaj sequin tanextiliani den tanahuatil de Moisés; nochin hualajque de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Huan nojón tanextiliani quinitacque que sequin imomachtijcahuan de Jesús quicuajque nintacualis huan amo momachipauque, quijtosnequi amo tatacamatque ica ne tanahuatil de ne majtequilis. Huan ica ya nojón in tayecanani quinijitojque huan quintelchiuque imomachtijcahuan de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Huan ne fariseos huan nochi in tagayot judíos quintatacamatij in tanahuatilme den huehuentzitzin, den pueblojuani judíos ten quijtoa que como amo miacpa moyecmajtequisque, pues ijcón amo hueli tacuasque. ");
INSERT INTO azzNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Huan cuac hualajque in tagayot judíos den plaza, ijcuacón amo teyi tacuasque, como amo achto moyecchipahuasque. Huan ongac ocsequin miacque tanahuatilme den huehuentzitzin ten quitacamatij, queme nijín, tapajpacalis den tasas tenica se tayi tensá, huan tapajpacalis de conme huan ocsequin míac tataman teposme, huan no tapajpacalis de nincochpetuan. ");
INSERT INTO azzNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Huan in fariseos huan in tanextiliani den tanahuatil de Moisés quitajtoltijque Jesús ijcuín: ―¿Queyé momomachtijcahuan amo nemij queme technahuatíaj in huehuetzitzin? Yejuan quicuaj nintacualis ica ninmahuan ten amo chipauque. ");
INSERT INTO azzNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Huan Jesús quinnanquilij: ―Namejuan nanixquequepme de namotamachilis. Isaías ne huejcautanahuatijque de Dios quiyequijtoj de namejuan, huan tajcuiloj itencopa Totajtzin Dios ijcuín: Nijín pueblojuani nechmohuistilíaj ica itenxipil san. Huan niyolojuan huejca yetoc de Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Pues nenca san nechmohuistilíaj. Porín yejuan tenextilíaj in tanahuatilme de taca san queme yesquía in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Huan namejuan nanquisecocahuaj in tanahuatil de Dios huan nanquitacamatij in tanahuatilme den taca san queme nijín: in tapajpacalis den conme huan xalojme tenica se tayi tensá. Huan nanquichihuaj míac ocsequin tataman nijín tanahuatilme. ");
INSERT INTO azzNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Huan no Jesús quiniliayaj ijcuín: ―Nancahuilchiuque queme amo cualtiasquía in tanahuatil de Dios para iixpatca nanquitacamatisque in tanahuatilme de huehuetzitzin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Porín in Moisés ne huejcautanahuatijque quijtoj ijcuín: “Xicmohuistilican namotatajtzin huan namonanajtzin”. Huan no in Moisés quijtoj: “Naquen quitelchihuas itatjtzin oso inantzin, yejua nojón ma quimictican”. ");
INSERT INTO azzNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Pero namejuan nantanahuatíaj que huelis se tagat ma quilij nitajtzin oso ninantzin ijcuín: “Nochi tenica namechpalehuisquía, axcan yejua corban, ten quijtosnequi nicaxcatilij ya Dios”. ");
INSERT INTO azzNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Huan como ijcón se quinilía itatajtzin, ijcuacón namejuan nantayecanani amo nanquincahuaj in teconeu ma quichihua tensá para quinpalehuisquía nitatajtzin nión ninanajtzin. ");
INSERT INTO azzNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Huan ijcón nanquinsecochiuque in Tajtoltzin de Dios huan nanquitacamatinemij in tanahuatilme ten namejuan ten nanpohuij ihuan in judíos nantamachtíaj. Huan no nanquichiuque míac ocsequin tataman tanahuatilme queme nojonque. ");
INSERT INTO azzNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Huan ocsepa Jesús quinnotzac nochi in tagayot campa yetoya Yejuatzin huan quinilij ijcuín: ―Xinechcaquilican nannochin, huan xicajsicamatican. ");
INSERT INTO azzNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Amo teyi ongac tacualis ten calaqui itech iten in tagat den calampa ten hueli quimajmahuas ica tajtacol ne tagat. Ta, ne ten quiyolnemilía tech iyolijtic de se tagat, yejua nojón quimajmahua ica tajtacol in tagat. ");
INSERT INTO azzNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Tacán acsá quipía inacas para tacaquis, ma yec tacaqui. ");
INSERT INTO azzNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huan cuac Jesús quincahuac in tagayot huan yajqui calayic ichan, ijcuacón imomachtijcahuan quitajtoltijque toni quijtosnequi nijín nexcuitil. ");
INSERT INTO azzNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Huan Jesús quinilij: ―¿Xe namejuan amo no nancajsicamatij nijín nexcuitil? ¿Cox amo nanquimatilíaj que nochi in tacualis ten calaqui itech se iten de se tagat de calampa, yejua nojón amo hueli quimajmahuas ne tagat ca tajtacol? ");
INSERT INTO azzNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Porín amo calaqui in tacualis itech se iyolo. Ta, calaquis itech se ipox huan de ompa panoa san calan. Huan ica ya nojón Jesús quinyecquilij que nochi ten ticuasque yejua nojón chipahuac ya, porín in tacualis amo huelis techmajmahua ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Huan no Jesús quinilij ijcuín: ―Pero ne tamachilis ten quisa itech iyolijtic den tagat, yejua nojón quimajmahua in tagat ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Porín itech in tagat, iyolijtic den tagat, ompa quisaj pitzotic tanemililisme, ne tagacuililis oso tesuacuililis, ne tasuapapatalis oso tagapapatalis, in temictilis, ");
INSERT INTO azzNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","In tachtequilis, in xijxicuinyot, in pitzotic tachihualisme, ne tacajcayahualis, ne ahuilnemilis, ne xicolot, ne tahuijuicaltilis, ne mohueyinequilis huan ne yolmijmiquiloyot. ");
INSERT INTO azzNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nochi nijín tajtacolme quisaj itech se iyolitic huan yejua nijín quimajmahuaj ca tajtacol in tagat. ");
INSERT INTO azzNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ijcuacón moojquetzac Jesús huan yajqui ne lugar campa pueblojme de monotza Tiro huan Sidón. Huan yajqui calayic tech se cali huan amo quinequía ma acsá quimatisquía, pero amo huelic ichtacayetos. ");
INSERT INTO azzNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Huan yetoya se sihuatzin ten quipiaya se isuapil ten mococoaya, porín quipiaya iyolijtic se amocuali ejecat. Huan nojón sihuat quicacca que huala Jesús. Huan in sihuatzin yajqui motancuaquetzato iicxitantzinco Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Huan ne sihuat tajtoaya griego masqui yolic itech se pueblo de monotza sirofenicia. Huan in sihuatzin moteltatautiaya inahuac Jesús de que ma quicalanquixtili in amocuali ejecat de ne isuapil. ");
INSERT INTO azzNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Pero Jesús quilij ijcuín: ―Xicahua achto ma ixuican in coneme judíos ica ne Tajtoltzin de Dios. Porín amo cualiquisa ma se quincuilis in tacualis den coneme huan ma se quintamaca itzcuintzitzin. ");
INSERT INTO azzNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Huan in sihuat quinanquilij ijcuín: ―Quema catzin, masqui tejuan queme yesquíaj itzcuintzitzin, pero timotaololohuilíaj mesajtampa huan ticuaj nochi in Tajtoltzin de Dios ten panxinij den coneme judíos. ");
INSERT INTO azzNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ijcuacón Jesús quilij in sihuat ijcuín: ―Cuali yetoc ten tejua tiquijtoa. Ica ya nojón nimitzilía que xiyó mochan huan xicmati que ne amocuali ejecat quisac ya de mosuapil. ");
INSERT INTO azzNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Huan cuac in sihuat ajsic ne ichan, ijcuacón ipa quisac ya itech isuapil in amocuali ejecat, huan ijcón in suapil tamatcahuetztoya ya. ");
INSERT INTO azzNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Huan queman Jesús mocuepac ya de ne tal de monotza Tiro, ijcuacón Yejuatzin panotiquisac campa pueblo de Sidon huan yajqui marteno de Galilea, huan panotiaya tech nintalteno de pohuía Decápolis, de ne májtacti pueblos. ");
INSERT INTO azzNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Huan cualcuilijque campa Jesús yetoya se tagat ten amo tacaquía huan no amo yec tempanhuetzía. Huan quitatatautilijque Jesús ma momacpaltalisquía tech yejua para ijcón ma pajtisquía. ");
INSERT INTO azzNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Huan Jesús cuiyac ne tagat quixexeloj iselti de tagayot. Huan Jesús momajpilcalaquic itech inacas ne cocoxque. Huan momachijchihuic huan niman quimatocac inenepil. ");
INSERT INTO azzNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Huan Jesús moixajocuic, huan ajco tachíac eluiyac, huan ajco yolnejsihuic, huan quijtoj ijcuín: ―Efata ―quijtosnequi: Ma tatapohuican. ");
INSERT INTO azzNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Huan nimantzin motapouque inacasuan huan tojtomic inenepil huan ijcón cuali tatajtoaya. ");
INSERT INTO azzNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Huan Jesús quinnajnahuatij in tagayot ma amo aquen quitapohuican de toni mochihuac. Huan ijcón queme Yejuatzin quinnajnahuati, pero yejuan cachi oc quitetapohuiayaj. ");
INSERT INTO azzNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Huan ica nojón telsenca mohuelitayaj in tagayot huan quijtoayaj ijcuín: ―Nochi ten Jesús quichihuac semi cuali, huan naquen amo tacaqui, Jesús quintacaquiltía; huan naquen amo yectajtoa, Jesús quinchihua ma tajtocan. ");
INSERT INTO azzNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Huan tech nojón tonalme míac tagayot mosentilijque huan amo quipiayaj toni cuasque. Huan Jesús quinnotzac imomachtijcahuan huan quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","―Niquinyolicnelía de nijín tagayot porín quipíaj eyi tonal ya nohuan yetocque, huan amo quipíaj ten cuasque. ");
INSERT INTO azzNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Huan tacán ijcón niquintitanis in tagayot ninchan huan amo niquintamacas, ijcuacón mayancahuetzitihue cuac yasque tech in ojti. Porín sequin hualajque de semi huejca. ");
INSERT INTO azzNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Huan in imomachtijcahuan quinanquilijque Jesús ijcuín: ―¿Pero queniu huelis se quintamiixhuitis ica míac tacualis nochi nijín tagayot campa nijín tayiucan? Pues amo huelis. ");
INSERT INTO azzNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Huan Yejuatzin quintajtanij ijcuín: ―¿Canachi panes nanquinpíaj? Huan yejuan tananquilijque ijcuín: ―Chicome. ");
INSERT INTO azzNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Huan ijcón in Jesús quinnajnahuatij in tagayot ma motalican ne talixco. Huan Yejuatzin quincuic in chicome panes huan quitasojcamachilij Dios, huan quincojcotonac in pan, huan quinmactij imomachtijcahuan ma yejuan quinxejxelohuilican ne tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Huan no quipiaya sequi pescados, huan no ijcón Jesús quintiochihuac huan quinnajnahuatij imomachtijcahuan ma quinxejxelohuilican in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Huan nochi in tagayot tacuajque huan ixuicque. Huan de ompa imomachtijcahuan quiololojque chicome chiquihuit pexonic de ne pan cojcotol ten mocahuac. ");
INSERT INTO azzNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Huan naquen tacuajque catca queme nahui mil taca. Huan de ompa Jesús quinnahuatijtehuac in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nimantzin Yejuatzin calayic tech in barco ihuan nochi imomachtijcahuan huan ajsicque campa pueblojcopaca de Dalmanuta. ");
INSERT INTO azzNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ijcuacón hualajque in fariseos huan peuque motajtoltehuijque ihuan Jesús porín quinequíaj quitepotamisque Jesús tech tajtacol. Yejuan quitajtaniliayaj ma Jesús ma quinmacasquía se nexcuitil de ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Huan Yejuatzin ajco yolnejsihuic huan quijtoj ijcuín: ―¿Queyé nannechtajtanilíaj tensá nexcuitil para namejuan ten axcan nanyoltocque? De yec melau ten namechilía, Dios amo namechmactilis se nexcuitil para namejuan ten nanyoltocque axcan. ");
INSERT INTO azzNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Huan de ompa Jesús quincahuac in tagayot, huan yajqui calaquito tech se barco huan quipanahuijque in mar huan ajsito ne sentapalpa den mar. ");
INSERT INTO azzNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Huan imomachtijcahuan de Jesús quelcauque ya de cuicasque tacualis ten monequía, huan quipiayaj sayó se pantzin tech in barco. ");
INSERT INTO azzNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Huan Jesús quinnajnahuatilij ijcuín: ―Xiquitacan huan xicpiacan cuidado de ne tamachtilis ten quipíaj in fariseos huan ten quipíaj in rey Herodes, porín ne tamachtilis temajmahua ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Huan ica nijín tajtol pehuac motajtoltehuiayaj imomachtijcahuan huan quijtojque ijcuín: ―Achá ijcón techilía porín amo ticualicque tacualis. ");
INSERT INTO azzNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Huan Jesús quinyolojixmatic huan quinilij ijcuín: ―¿Queyé nanmotajtoltehuijtocque que amo nanquipíaj tacualis? Mota que ayamo nanquimatilíaj nión nancajsicamatilíaj notanextililis. ¿Xe semi namejuan semi nanyolpipicticque oc de namotamachilis de amo nanquiselisque in Tajtoltzin de Dios? ");
INSERT INTO azzNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Huan nanquipíaj namoixtololohuan, ¿xe amo nantachíaj? Huan nanquipíaj namonacasuan, ¿xe amo nantacaquij? Huan, ¿xe amo nanquelnamiquij? ");
INSERT INTO azzNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cuac Nejuatzin nicxejxeloj in macuil panes para in macuil mil tagayot, ijcuacón, ¿canachi chiquihuit pexonic de ne pan cojcotol ten namejuan nanquiololojque? Huan yejuan tananquilijque ijcuín: ―Majtactiomomen. ");
INSERT INTO azzNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Huan no Jesús quintajtoltij ijcuín: ―Cuac nicxejxeloj nahui panes para in nahui mil tagayot, ijcuacón, ¿canachi chiquihuit pexonic de pan cojcotol nanquiolojque? Huan yejuan tananquilijque ijcuín: ―Chicome. ");
INSERT INTO azzNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Huan Jesús quinilij ijcuín: ―¿Queyé ayamo nancajsicamatij in huejueyin chihualisme ten nicchiutinemi? ");
INSERT INTO azzNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Huan Jesús ajsic niman tech in pueblo de Betsaida. Ijcuacón cualcuilijque se tagat ijcoptoya, huan quitatautijque Jesús ma quimatocasquía para quipajtisquía. ");
INSERT INTO azzNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Huan Jesús quimaquitzquij in tagat ijcoptoya, huan cuiyac calampa den pueblo. Huan quixacualoj ica ichijchi huan quixmapachoj, huan niman quitajtanij xa tensá quitaya. ");
INSERT INTO azzNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Huan in tagat ten ijcoptoya niman tachíac, huan quijtoj ijcuín: ―Niquinita tagayot majyá cuoume, pero no niquinita nenemij. ");
INSERT INTO azzNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Huan niman ocsepa Jesús quixmapachoj huan quichihualtij ma yec tachía. Huan niman quiselij tachialis in cocoxque huan tachíac de huejca huan yec tachíac nochi. ");
INSERT INTO azzNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Huan Jesús quititanic nichan huan quinahuatij ijcuín: ―Amo xiyó tech ne pueblito, huan nión naquen xictapohui tech ne pueblo. ");
INSERT INTO azzNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ijcuacón quisque Jesús ihuan imomachtijcahuan huan yajque tech in pueblos ten pohuía Cesarea de Filipo. Huan cuac ojtocatoc ya, ijcuacón Jesús quintajtanij imomachtijcahuan ijcuín: ―¿Toni quijtoaj in tagayot que niaconi Nejuatzin? ");
INSERT INTO azzNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Huan yejuan tananquilijque ijcuín: ―Sequin quijtoaj que Tejuatzin tion Juan Taahuijque. Huan ocsequin quijtoaj que Tejuatzin tion Elías. Huan ocsequin quijtoaj que Tejuatzin tionacsá den huejcautanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ijcuacón Jesús quintajtoltij ijcuín: ―Huan namejuan, ¿toni nanquixejecoaj niaconi Nejuatzin? Huan tananquilij Pedro ijcuín: ―Tejuatzin tion Cristo in Temaquixtijcatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Huan Jesús quinnahuatij ma amo aquen quilisquíaj que Yejuatzin Temaquixtijcatzin in Cristo. ");
INSERT INTO azzNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Huan Jesús pehuac quinmachtíaj imomachtijcahuan ijcuín: ―Semi monequi que nejua ni Yectagatzin ma semi nitajyohuis. Huan in huehuentzitzin huan in tayecancatiopixcame huan in tanextiliani de tanahuatil de Moisés, nochi nijín tayecanani, yejuan nechixnamiquisque huan nechtelchihuasque ma nimiqui. Ta, ocsepa nipanquisas intzalan in ánimajme niyoltoc ipan eyi tonalica. ");
INSERT INTO azzNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Huan Jesús quinyequixilij nijín tanemilis. Ijcuacón Pedro quixeloj Jesús seco, huan ompa pehuac quixajua ica por nitajtolis. ");
INSERT INTO azzNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Huan Yejuatzin moixcuepac campa yetoyaj imomachtijcahuan huan quixajuac Pedro huan quilij ijcuín: ―Ximijcuani noixpan Pedro, majyá titanemilijtoc queme Satanás in amocuali. Huan amo ticmatilía in tanemililis de Dios. Ta, sayó ne tamachilis den tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ijcuacón Jesús quinnotzac nochi in tagayot pero quinilij imomachtijcahuan ijcuín: ―Tacán acsá quinequi nechtoctilijtiyás, ijcuacón ma quicautehua ne tanejnequilis de yejua san; huan ma quixijco in cruztzin ten cualcuis in tajyohuilis huan ma nechtacamatiu huan ma nechtoctilijtiu. ");
INSERT INTO azzNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Huan nochi neques ten quinequij moyecpialtisque huan quimaquixtisque ninnemilis, yejuan nochi quipolosque in ninnemilis. Pero nochi neques ten quipolosque ninnemilis ica por Nejuatzin huan porín in cuali Tajtoltzin den nemaquixtilis, yejuan nojonque cajsisque ninnemilis huan no ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Huan, ¿toni quihueyipías in tagat como moaxcatisquía nochi nijín senmanahuac huan niman quipolos nitalnamiquilis? ");
INSERT INTO azzNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Oso, ¿toni taxtahuil huelis quitemacas in tagat ica por niyolo cuac yejua cajsicamatis que quipoloj ya ninemilis? ");
INSERT INTO azzNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma tiquijtocan que acsá mopinaucamati de Nejuatzin huan de notajtoltzin cuac yejua monojnotztos ihuan in talticpacuani, neques ten tajtacolejque ten axcan nemij huan amo quitacamatij Dios. Como yejua mopinaucamatij de Nejuatzin, ijcuacón no nimopinaucamatis de yejua cuac Nejuatzin in Yectagatzin nihualas ica ichicaucahuelilis de Notajtzin Dios ihuan in ángeles chipauque. ");
INSERT INTO azzNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Huan no Jesús quinilij in tacaquini ijcuín: ―De yec melau ten namechilía que senme de namejuan ten nican nanyetocque, amo nanmiquisque hasta queman nanquitasque que nihualas ya huan nimomasoutoc ya huan niquinyecanas notaneltocahuan ica nihueyichicahualis de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Huan chicuasen tonal satepan Jesús quinuiyac Pedro, huan in Jacobo, huan in Juan, huan yajque tejcotoj seco itech se tepet huejcapan. Huan ompa Jesús mopapataya quen tamatic ninixpan. ");
INSERT INTO azzNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Huan nitilma pehuac cualtzin pepetaca semi istac queme yesquía secti, huan amo ongac aquen tapacque nican talticpac huelisquía ijcón quichihuasquía ma tel istac queme nijín. ");
INSERT INTO azzNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Huan monextijque Elías ihuan Moisés, yejuan huejcautanahuatiani de Dios, huan peuque monojnotzayaj ihuan Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Huan in Pedro quitajtolcotonac Jesús huan quilij ijcuín: ―Notamachtijcau, semi cualtzin para tejuan que tiyetocque nican. Ma ticchijchihuacan eyi xajcaltzitzin, se para tejuatzin huan se para Moisés, huan ocsé para Elías. ");
INSERT INTO azzNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pues imomachtijcahuan semi moucacuicque ya, huan ica nojón Pedro amo quimatía oc toni quijtos. ");
INSERT INTO azzNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ijcuacón hualtemoc se mixtepet huan quinquemiloco, huan mixtzalan mocayic se tajtolis ten quijtoaya ijcuín: ―Yejuatzin ya nijín Notasojconetzin. Xicaquilican ca cuali Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Huan niman cuac huelis tatachiasque, ijcuacón amo aquen quitacque oc. Ta, sayó Jesús iselti. ");
INSERT INTO azzNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Huan cuac nochi imomachtijcahuan temocque de tepet, ijcuacón Jesús quinnajnahuatij ijcuín: ―Amo aquen xiquilican teyi den nanquitacque ya. Ta, ma xicchiacan hasta satepan den Nejuatzin ni Yectagatzin nipanquisas niyoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Huan ijcón imomachtijcahuan quichtacamatoyaj san, pero motajtoltiayaj yejuan san, huan quijtojque ijcuín: ―¿Toni quijtosnequi nijín tajtol de que Yejuatzin panquisas yoltoc itzalan in ánimajme? ");
INSERT INTO azzNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ijcuacón imomachtijcahuan quitajtanilijque Jesús: ―Huan ne tanextiliani den tanahuatil de Moisés, ¿queyé yejuan quijtoaj que achto monequi ma huiqui in tanojnotzque Elías achtopa que hualas in Cristo Temaquixtijque? ");
INSERT INTO azzNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Huan Jesús quinnanquilij ijcuín: ―Yec melau Elías huala achtopa que Nejuatzin nihuala huan yejua tayejyectalij nochi para Nejuatzin. Huan, ¿toni quijtoa in Tajcuilolamatzin de Dios de Nejuatzin ni Yectagatzin? Quijtoa que Nejuatzin Yectagatzin nihueyitajyohuis huan niyesqui tamohuispolol ninixpan in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Huan Nejuatzin namechilía que Elías huala ya, huan in tayecanani quichihuilijque nochi ten quinecque, porín ijcón tajcuiliutoc ya de yejua tech in Tajcuilolamatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Huan cuac ajsicque Jesús ihuan Pedro huan Jacobo huan Juan campa yetoyaj ocsequin imomachtijcahuan, ijcuacón quinitac Jesús huel míac tagayot huan quiyehualotoyaj. Huan no yetoyaj ne tanextiliani den tanahuatil de Moisés. Huan yejuan motajtoltehuijtoyaj ihuan imomachtijcahuan de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Huan nimantzin cuac in tagayot quitacque Jesús, ijcuacón quimoucaitacque, huan hual motalojque campa Yejuatzin huan quitajpalocoj. ");
INSERT INTO azzNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Huan Jesús quintajtoltij imomachtijcahuan ijcuín: ―¿Tonica nanmotajtoltehuijtocque? ");
INSERT INTO azzNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Huan tananquilij senme den ompa yetoyaj ijcuín: ―Notamachtijcau, nimitzualcuilía nooquichpil ten quipía iyolijtic se amocuali ejecat den amo quicahua ma tajto. ");
INSERT INTO azzNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Huan campa yesqui cajsi nijín amocuali ejecat, ompa quiquitzquía in telpoch huan quitatamota talpan. Huan in telpoch tenposoni huan tennanatzoca huan melaxtía. Huan niquintajtanilijca momomachtijcahuan ma quicalanquixtican in amocuali ejecat pero yejuan amo huelque. ");
INSERT INTO azzNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ijcuacón Jesús quinnanquilij ijcuín: ―¡Ay de namejuan ten amo nantaneltocaj! ¿Canachi tonalme quipía de que niyetos namohuan? ¿Canachi tonalme quipía de que nitaxicos como amo nanyectacuautamati nohuan? Xicualican nican in telpoch. ");
INSERT INTO azzNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Huan ijcón yejuan cualicque. Huan cuac in amocuali ejecat quitac Jesús, ijcuacón quiteltzetzeloj in telpoch. Huan in telpoch huetzic talpan motetecuinojtinemía huan tenposonía. ");
INSERT INTO azzNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ijcuacón Jesús quitajtanilij in tetajtzin ijcuín: ―¿Quemanían ya ijcón pehuac mochihuac? Huan itajtzin quinanquilij ijcuín: ―Desde queman yejua tzictzin catca. ");
INSERT INTO azzNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Huan miacpa ya nijín amocuali ejecat quitatamotac notelpoch itech in tit huan itech in at para quimictisquía. Pero como tejuatzin tionuelis ticonchihuas tensá, xitechonicneli huan xitechonpalehui. ");
INSERT INTO azzNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Huan Jesús quinanquilij ijcuín: ―Como tejua tihuelis titacuautamatis notech, cualtzin ya, porín nochi naquen yec tacuautamati notech, yejua ne nochi hueli quichihuas. ");
INSERT INTO azzNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Huan ijcón in tetajtzin tzajtzic huan quilij ijcuín: ―Nitacuautamatic ya, huan xinechonpalehui cuac amo mohuan niyectacuautamatis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Huan queman Jesús quinitac in tagayot mohualtojtopehuayaj, ijcuacón Yejuatzin quichicaucanahuatij in amocuali ejecat ijcuín: ―Tejua in amocuali ejecat ten quichihua ma amo tajtoa huan ma amo tacaqui in telpoch, Nejuatzin nimitzilía, xiquisa itech nijín telpoch huan amo ocsepa xicalaquiti itech oc. ");
INSERT INTO azzNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ijcuacón in amocuali ejecat tzajtzic huan quiteltzetzeloj in telpoch huan quisac. Huan in telpoch mocahuac queme miquet huan miacque quijtoayaj ijcuín: ―Miyic ya in telpoch. ");
INSERT INTO azzNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero Jesús quimaquitzquij huan quipalehuic huan moquetzac in telpoch. ");
INSERT INTO azzNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Huan de ompa Jesús calayic nichan huan imomachtijcahuan ichtaca quitajtoltijque ijcuín: ―¿Queyé tejuan amo tihuelque ticalanquixtijque ne amocuali ejecat? ");
INSERT INTO azzNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Huan Jesús quinnanquiilij ijcuín: ―Nijín taman amocuali ejecat sayó se quicalanquixtía ica ne tatautilis ihuan Dios huan ica ne sahualis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Huan cuac quisque de ne talme, ijcuacón Jesús ihuan imomachtijcahuan yajque nejnentinemiayaj Galileajcopaca. Huan Jesús amo quinequía ma aca quimatisquía can Yejuatzin yetosquía. ");
INSERT INTO azzNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Huan Jesús quinequía quinmachtis imomachtijcahuan ninseltij. Huan Jesús quinilij imomachtijcahuan ijcuín: ―Nejuatzin ni Yectagatzin huan nechtemactisque inmaco in tagayot huan nechmictisque. Huan ipan eyi tonal satepan de nimictosquía, nipanquisas niyoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Huan yejuan imomachtijcahuan amo cajsicamatiayaj nijín tanojnotzalis huan quimohuiliayaj para quitajtoltisque. ");
INSERT INTO azzNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Huan ejcocque itech pueblo de Capernaum huan cuac yetoyaj calijtic, ijcuacón Jesús quintajtoltij imomachtijcahuan ijcuín: ―¿Tonica nanmotajtoltehuiayaj tech in ojti? ");
INSERT INTO azzNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Huan ijcón imomachtijcahuan motentamatilijque san, porín tech ojti motajtoltehuijtoyaj ica nijín tamachilis: ―¿Catiyejua den imomachtijcahuan de Jesús yesqui in cachi hueyi tayecanque? ");
INSERT INTO azzNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ijcuacón in Jesús motalij, huan quinnotzac imomachtijcahuan huan quinilij ijcuín: ―Tacán acsá quinequi mochihuas tayecanque, ijcuacón yejua ne quipía de mochihuas tacuitapanenque de nochin, huan tetaquehual de nochin. ");
INSERT INTO azzNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Huan Jesús quimaquitzquij se oquichpilconet, huan quitalij intzalan imomachtijcahuan, huan quinapaloj in conet huan quinilij imomachtijcahuan ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","―Huan como acsá quiselisquía se conet queme nijín, ten quipía ne yec tacuautamatilis tech notocay, ijcuacón yejua ne no nechselis nejua. Huan como acsá nechselía Nejuatzin, amo nejua san quiselía. Ta, no quiselía Totajtzin Dios naquen nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Huan Juan quilij Jesús ijcuín: ―Tamachtijque, tiquitacque se tagat quincalanquixtij in amocuali ejecame ica in chicahualis de motocay, pero amo pohuía tohuan. Huan tictacahualtijque ma amo ijcón quichihuas, porín amo pohuía tohuan. ");
INSERT INTO azzNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Huan Jesús quinanquilij ijcuín: ―Amo xictacahualtican, porín amo ongac acsá ten hueli quichihuas se mohuiscachihualis ica in chicahualis de notocay, huan de ompa huelis nechtelijitos. ");
INSERT INTO azzNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Porín naquen amo techtahuelita, yejua ne techpalehuía. ");
INSERT INTO azzNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Huan como acsá namechmactisquía tzictzin at porín quitasojta notocay, oso como acsá namechpalehuisquía sayó porín namejuan nanpohuij ihuan Cristo Temaquixtijque, ijcuacón de melau ten namechilía que ne tagat quiyecselis ne tetayocolil de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Huan como acsame quitepotamíaj tech in tajtacol se de nijín conetzitzin ten nohuan tacuautamatij, ijcuacón cachi cuali para yejuan ma se quinquechpilohuili se hueyi tet de ica tacuechoa, huan ma se quintamota aijtic in taca ihuan in tet. ");
INSERT INTO azzNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Huan tacán momay mitztepotamía tech in tajtacol, ijcuacón xicotona. Porín cachi cuali ticalaquis tech in yec nemilis timacotoltic, huan que ticpiasquía ome momahuan, huan tiyás mictan campa tatzacuiltilis, huan campa ne tit ten amo queman hueli sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Porín ompa in miqueocuilime tacuajtocque huan amo miquij huan in tit amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Huan tacán mometz mitztepotamía tech in tajtacol, ijcuacón xicotona. Cachi cuali ticalaquis tech in yec nemilis timetzcotoltic, huan que ticpiasquía ome mometzuan, huan tiyás mictan campa tatzacuiltilis, huan campa in tit amo hueli sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Porín ompa in miqueocuilime tacuajtocque huan amo miquij, huan ne tit amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Huan tacán moixtololo mitztepotamía tech in tajtacol, ijcuacón xiquixti. Porín cachi cuali ticalaquis ca se moixtololo campa Dios momasoutos ica ichicahualis huan que ticpiasquía ome moixtololohuan huan tiyás mictan campa tatzacuiltilis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Porín ompa in miqueocuilime tacuajtocque huan amo miquij, huan in tit amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Huan tinochin Dios techyolchipahuas ica tit. Huan nochi nemactil ten ticuicaj iixpantzinco Dios, yejua ne Yejuatzin quichipahuas ica istat. ");
INSERT INTO azzNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Semi cuali in istat; pero tacán in istat quipoloa nipoyeca, ijcuacón, ¿quenín huelis se quitatequiutis ocsepa? Xicpiacan ne yolchipahualis itech namejuan, queme istat tachipahuac; huan xicpiacan ne yolsehuilis se huan ocsé. ");
INSERT INTO azzNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Moquetzteu de ompa huan yajqui Jesús Judeajcopaca huan analpa den hueyíat de monotza Jordán. Huan nochi in pueblojuani mosentilijque campa Yejuatzin, huan ocsepa pehuac Jesús quinnextilía queme ipa. ");
INSERT INTO azzNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ijcuacón motoquijque in fariseos campa Yejuatzin huan quitajtoltijque para ijcón huelis quiejecosque nitanemililis de Jesús. Huan yejuan quitajtanilijque Jesús ijcuín: ―¿Cox quitecahuilía itanahuatil de Moisés de que se tagat ma mosihuacahua? ");
INSERT INTO azzNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Huan Jesús quinnanquilij ijcuín: ―¿Toni namechnajnahuatij ya in Moisés? ");
INSERT INTO azzNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ijcuacón yejuan quinanquilijque ijcuín: ―Moisés quitecahuilij ma se quimacas se isihuau se tajcuilolamat de ne sihuacacahualis para ijcón mosihuacahuasque. ");
INSERT INTO azzNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Huan Jesús quinilij ijcuín: ―Moisés namechmacac ne tanahuatil porín namejuan semi nanyolpipicticque de namotamachilis huan amo nanquitacamatinemij Dios Itajtoltzin. ");
INSERT INTO azzNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Pero cuac Dios quichijchihuac in talticpac huan in eluiyac, ijcuacón Yejuatzin quinchijchihuac ome taman, tagat huan in sihuat. ");
INSERT INTO azzNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ica ya nojón se tagat quincahuas nitajtzin huan inanajtzin huan mosentilis ihuan isihuau. ");
INSERT INTO azzNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Huan in ome mocahuaj sansé san; huan ijcón amo omen oc yesque. Ta, sayó se. ");
INSERT INTO azzNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ica nojón in tagat huan sihuat ten Dios quinsentilij namicuani ya, yejuan nojonques ma amo se tagat quinxelos oc. ");
INSERT INTO azzNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Huan cuac ocsepa yetoyaj calijtic, ijcuacón imomachtijcahuan quitajtoltijque Jesús de ne tanojnotzalis de namicuani. ");
INSERT INTO azzNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Huan Jesús quinilij ijcuín: ―Tacán se tagat mosihuacahuas huan quimactis se amat tenica ixnesis que mosesecocauque ya, huan de ompa monamictiti ocsepa, ne tagat motajtacolmacas de suapapatalis ica ne achto sihuat. ");
INSERT INTO azzNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Huan tacán se tesihuau quicahuas niyoquich huan quimactis se amat de ne cajcahualis, huan de ompa monamictiti ocsepa, ijcuacón ne tesihuat motajtacolmacas de tagapapatalis ica ne achto iyoquich porín poutoc oc ihuan ne itayecancayoquich. ");
INSERT INTO azzNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Huan cualcuiliayaj campa Jesús sequin coneme para ma Jesús quintiochihuas huan para ma quincuamapacho. Huan imomachtijcahuan peuque quintacahualtiayaj neques ten quintenextiliayaj ninconehuan iixpan in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Huan queman quitac Jesús que quintzajtzacuiliayaj in coneme, ijcuacón cualanic Yejuatzin huan quinilij imomachtijcahuan ijcuín: ―Xiquincahuacan coneme ma hualacan nohuan huan amo xiquintacahualtican. Huan no namechilía que nochi naquen motemacas nohuan ma niquinyolyecana, ijcón queme ne coneme, yejuan nojonques Dios quinyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Huan de yec melau ten namechilía: Semi monequi ximochihuacan queme nijín coneme ten motemactijque nomaco. Huan tacán acsá amo motemactía imaco Yejuatzin queme se conetzin, ijcuacón Dios amo quiyolyecantiyás ne tagat ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huan Jesús quinmaquitzquij in coneme huan quinnapaloj huan quincuamajpachoj huan ijcón quintiochihuac. ");
INSERT INTO azzNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Huan moojquetzac Jesús huan yaya tech se ojti huan niman hual motaloj se tagat huan motancuaquetzaco iixpantzinco Jesús huan quitajtoltij ijcuín: ―Tejuatzin, tioncualitamachtijque, ¿toni monequi nicchihuas para nicpías ne yec nemilis ten amo queman tamis? ");
INSERT INTO azzNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Huan Jesús quinilij ijcuín: ―¿Queyé tinechnotzac que niyolcuali? Porín xicmatique amo ongac aca ocsé oc yolcuali. Ta, sayó se, huan Yejuatzin ya nijín Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Huan tejua ticmati in tanahuatilme de Dios: “Amo xisihuapapatacan; amo xitemictican; amo xitachtequican; amo xitecajcayahuacan; amo xiteili ten xolopijyot. Xiquinmohuiscapohuacan motatajtzin huan monanajtzin”. ");
INSERT INTO azzNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Huan ijcón in telpocat rico tananquilij ijcuín: ―Tamachtijque, nochi nijín nictacamatihuitz desde cuac nipili oc nicatca huan hasta axcan. ");
INSERT INTO azzNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Huan Jesús quisenitac in telpocat huan quiyolicnelij porín quitasojtac huan quilij ijcuín: ―Pero se taman mitzpoloa, huan yejua nijín monequi xicchihua: Monequi xiyó xicnamacati nochi ten ticpía huan xiquinxejxelohuili aquen amo teyi quipía. Huan ijcón ticpías se hueyi paquilis huan yec yetolis queme se tetayocolil ihuan Dios nepa eluiyactzinco. Huan de ompa xihuiqui nohuan huan xinechtoctili huan xinechtacamatinemi. ");
INSERT INTO azzNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Huan queman in telpocat rico quicayic nijín tajtolme, ijcuacón niman moyolcocoj huan yajqui motequipachojti ya porín quipiaya semi míac ricojyot nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Huan Jesús tatachíac nohuiyan huan quinilij imomachtijcahuan ijcuín: ―Semi ohui para se tagat ten quipía ne hueyi ricojyot ma motemactis inahuactzinco Dios para que Yejuatzin quiyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ijcuacón imomachtijcahuan quimoucacacque itajtoluan. Huan Jesús ocsepa pehuac quinilía ijcuín: ―Notelpocahuan, semi ohui para in tagayot ma motemactican inahuactzinco Dios para que Yejuatzin ma quinyolyecantiyás, cuac tacuautamatij oc itech ninricojyo. ");
INSERT INTO azzNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Amo huelis nalpanos se hueyi tapial ten monotza camello campa coyoctic se acoxa. Huan amo no huelis motemactiyás se rico inahuactzinco Dios para que ma Yejuatzin quiyolyecantiyás ica ihueyichicahualis, como yejua tacuautamatinemi oc itech niricojyo. ");
INSERT INTO azzNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Huan imomachtijcahuan cachi quimoucacacque huan motajtoltiayaj yejuan se huan ocsé ijcuín: ―¿Aconi, pues, huelis maquisas de nitajtacoluan? ");
INSERT INTO azzNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Huan Jesús quinsenitac huan quinilij ijcuín: ―In taca amo huelis momaquixtisque de nitajtacoluan. Ta, Dios cuali hueli quinmaquixtis in tagayot, porín Totajtzin Dios nochi huelis quichihuas. ");
INSERT INTO azzNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Huan Pedro pehuac quinojnotzac Jesús ijcuín: ―Xiconita, Tejuatzin, tejuan ticauque ya nochi ten ticpiayaj huan timitztoctilíaj para timitztacamatinemisque. ");
INSERT INTO azzNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Huan Jesús tananquilij ijcuín: ―Yec melau ten mitzilía, cuali nanquichiutocque de nanquicahuaj namocaluan huan namoicnihuan, huan namosuaicnihuan, huan namonanajuan, huan namotatajuan, huan namoconehuan, huan namotaluan. Pero nanquicahuaj nochi nijín porín nanquiyolnejnequi que Dios namechyolyecantiyás ica ihueyichicahualis huan porín nannechyoltasojtaj Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Huan ne naquen Dios quiyolyecantiyás, yejua ne quiselis axcan nican talticpac ocsé macuilpoal de calme, huan icnime huan suaicnime, huan tetatme, huan tepiluan, huan talme, masqui ica tajyohuilis. Huan tech ne tonal ten huitza oc, no quiselis in nemilis ten amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Huan miacque taneltocani ten axcan tayecanani, yejuan nojonques yesque tacuitapanme. Huan miacque taneltocani ten axcan tacuitapanme, yejuan nojonques yesque tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Huan yaya Jesús tech in ojti tejcotiaya Jerusaléncopaca. Huan Jesús tayecanaya huan imomachtijcahuan quimoucaitacque de nitanextililis huan nochi in tacaquini quimoucatoctiliayaj. Pero ocsepa Jesús quinnotzac ocseco de nojón májtactiomome imomachtijcahuan huan pehuac quintapohuía toni inpan ejcosquía. ");
INSERT INTO azzNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Huan Jesús no quinilij ijcuín: ―Xiquitacan san, titejcotocque Jerusaléncopaca huan ompa Nejuatzin ni Yectagatzin nechtemactisque inmaco in tayecanani den tiopixcame judíos huan inmaco in tanextiliani den tanahuatil de Moisés. Huan nechtelchihuasque ma nechmictican huan nechtemactisque imaco in tagayot de amo judíos. ");
INSERT INTO azzNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Huan moquejquelosque de Nejuatzin huan nechcuetaxuisque huan tachijchasque nopan huan nechmictisque. Huan niman itech eyi tonal nipanquisas niyoltoc itzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Huan ijcón Jacobo huan in Juan, yejuan teconehuan de Zebedeo, motoquijque campa Jesús huan quilijque ijcuín: ―Tamachtijque, ticnequij xitechchihuili nochi ten timitztajtanilíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Pero Jesús quintajtoltij ijcuín: ―¿Toni nanquinequij ma nicchihuas para namejuan? ");
INSERT INTO azzNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Huan yejuan tananquilijque ijcuín: ―Xitechontayocoli in tanahuatil para ma timotalican ne eluiyac campa yectic tachipahuiyan, se de tejuan moyecmacopaca huan in ocsé moopochcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Huan ijcón Jesús quinilij ocsepa ica nexcuitil ijcuín: ―Namejuan amo nancajsicamatque toni nanquitajtanij. ¿Xe huelis namejuan no nanquiselisque ne vaso den cualcuis ne tajyohuilis queme Nejuatzin nicselis? Huan, ¿xe huelis no namejuan nanquiselisque in taahuilis de tajyohuilis ten Nejuatzin niquijyohuis? ");
INSERT INTO azzNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Huan yejuan tanaquilijque ijcuín: ―Quema, tihuelisque. Huan ocsepa Jesús quinilij ijcuín: ―De yec melau ten namechilía, ijcón queme mochihuas ne tajyohuilis ten Nejuatzin nitajyohuis, namejuan no nantajyohuisque. Huan in taahuilis de tajyohuilis ten Nejuatzin nicselis, namejuan no nanquiselisque. ");
INSERT INTO azzNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Pero amo nicpía in tanahuatil para namechtayocolis que tejua Jacobo timotalis noyecmacopaca huan tejua Juan timotalis noopochcopaca. Ta, sayó Notajtzin Dios quinmactis ne tanahuatil para naquen Dios quinijitac ya. ");
INSERT INTO azzNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Huan cuac quicacque in ocsequin májtacti imomachtijcahuan nijín tajtolme, ijcuacón peuque mocualantijque ihuan Jacobo huan Juan. ");
INSERT INTO azzNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Huan Jesús ocsepa quinnotzac huan quinilij ijcuín: ―Queme nanquimatij, que in tayecanani de tataman pueblojme mohueyimatij huan mopohuaj hueyi chihuanime tech ne pueblojme, huan quinmachililtíaj ninchicahualis itech ninpueblojuan. ");
INSERT INTO azzNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Pero ma amo ijcón yesqui namohuan. Ta, naquen quinequis mochihuas tayecanque namohuan, yejua ne ma mochihua queme se tetaquehual de nochin. ");
INSERT INTO azzNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Huan tacán acsá de namejuan quinequis tayecana, ijcuacón yejua ne ma mochihua queme se tetequitilijque de nochin. ");
INSERT INTO azzNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Porín Nejuatzin ni Yectagatzin amo nihuala para ma acsame nechtequitilican. Ta, nihuala sayó para ma nitetequitilis, huan para ma nictemacas nonemilis para quixtahuas in tajtacol huan para ijcón niquinmaquixtis míac tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Huan ajsicque tech in pueblo Jericó huan quisque de Jericó Jesús huan imomachtijcahuan huan ocsequin míac tagayot. Huan se tagat ixpojpoyot monotzaya Bartimeo, iconeu Timeo, tocotziutoya ojteno motaehuiaya. ");
INSERT INTO azzNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Huan cuac Bartimeo quicayic que ejcotihualaya Jesús de Nazaret, ijcuacón pehuac tzajtzi huan quijtoj ijcuín: ―Jesús, tion Temaquixticatzin, tion Teconetzin de rey David, xinechonyolicneli. ");
INSERT INTO azzNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Pero miacque quitacahualtijque Bartimeo para ma tamatisquía; pero in Bartimeo cachi oc tzajtzía ijcuín: ―Tejuatzin, tion Totemaquixtijcatzin, tion Teconetzin de rey David, xinechonyolicneli. ");
INSERT INTO azzNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Huan ijcón Jesús moquetzac huan quijtoj ijquín: ―Xicnotza ne naquen nechtzajtzilía. Huan quinotzque ne tagat ten amo tachiaya huan quilijque ijcuín: ―Ximoyolchicahua, ximoquetza porín mitznotza Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Huan Bartimeo quitamotac nitaquen, huan mehuac, huan motaloj huan cajsito in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Huan Jesús quitajtoltij ijcuín: ―¿Toni ticnequi ma nimitzchihuili? Huan in Bartimeo quinanquilij ijcuín: ―Tamachtijque, nicnequi ma nitachía. ");
INSERT INTO azzNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Huan Jesús quilij ijcuín: ―Huelis tiyás ya, huan tejua tipajtis porín titacuautamatic nohuan. Huan nimantzin Bartimeo tachíac huan quitoctilij Jesús itech ne ojti para quitacamatiyás. ");
INSERT INTO azzNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Huan Jesús ihuan imomachtijcahuan ajsitiyayaj Jerusaléncopaca, amo huejca den pueblojme Betfagé huan Betania, huan ixpampa in tepetzin den monotza Olivos. Huan Jesús quinnotzac ome imomachtijcahuan huan quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","―Xiyacan tech ne pueblojme ten yetoc nepa sentapalpa huan niman cuac nancalaquitihue, ijcuacón ompa nancajsisque se burrito ilpitoc. Huan ayamo queman aquen mopantalijtoya ipan. Huan yejua ne xictojtomacan huan xinechualcuilican. ");
INSERT INTO azzNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Huan tacán acsá tensá namechilisquía, “¿Queye ijcón nanquichihuaj?”, ijcuacón xicnanquilican ijcuín: “In Totecotzin quimonequiltía quitatequiutis”, huan ijcón niman namechcahuilisque in burrito. ");
INSERT INTO azzNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Huan ijcón in omen imomachtijcahuan yajque huan cajsicque in burrito ilpitoya caltenteno campa ojti patahuac huan quitojtonque. ");
INSERT INTO azzNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Huan senme den ompa yetoyaj quinilij ijcuín: ―¿Toni nanquichiutocque? ¿Queyé nanquitojtomaj ne burrito? ");
INSERT INTO azzNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Huan ijcón imomachtijcahuan quijtojque ijcón queme Jesús quinnahuatijca ya. Huan ijcón quincahuilijque ma cuiyacan in burrito. ");
INSERT INTO azzNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Huan cualcuilijque Jesús in burrito huan quipanpejpechtijque ca ninayahuan huan Jesús mopantalij tech in burrito. ");
INSERT INTO azzNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Huan miacque tagayot quisohuayaj tech in ojti nintilmajuan huan ocsequin quitequiayaj cuoume nimayo huan quinsohuayaj talixco campa yaya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Huan in tagayot yaya quiyecanayaj Jesús huan ocsequin quitojtocatiayaj Jesús huan nochin moyoluelitayaj huan tzajtzitiayaj huan quijtoayaj ijcuín: ―¡Hosana, timitzonueyichihuaj Tejuatzin tion Tatiochihual, huan tihualajtoc itencopa Totajtzin Dios! ");
INSERT INTO azzNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tion Tatiochihual Tejuatzin ten tionejcotihuitz ya porín ticonualcui ne chicahualis de Totajtzin rey David. Ticueyichihuaj Totajtzin Dios ten yetica ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Huan ijcón calayic Jesús tech ne pueblo Jerusalén huan niman calayic tech in tiopan de judíos. Huan ompa Jesús tatachíac nochi ten ongaya tiopanijtic. Huan queme niman tayohuatiaya ya, ijcuacón yajqui pueblo de Betania ihuan in majtactiomomen imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Huan imostica queman quisque Jesús de ne Betania ihuan imomachtijcahuan, ijcuacón Jesús mayanac. ");
INSERT INTO azzNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Huan quitac huejca se higoscuohuit cualtzin maxihuiyojtoya. Huan quitato quiyolnemiliaya cox quipiasquía ihigos itaquilot. Pero queman ajsic, ijcuacón amo teyi ongaya. Ta, sayó xihuit san, porín amo catca tiempo queman mochihua in higoscuohuit. ");
INSERT INTO azzNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Huan ijcón Jesús quilij in higoscuohuit: ―Ma amo queman aquen quicuas de motaquilo. Huan quicacque imomachtijcahuan den nitajtolis. ");
INSERT INTO azzNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ejcocque campa pueblo Jerusalén huan calayic Jesús ihuan imomachtijcahuan ne tiopanijtic huan pehuac quincalaquixtía nochi in tanamacani huan in tacohuani ten ompa yetoyaj tiopanijtic. Huan quinixcuepac mesajme den tominpapatani huan quinixcuepac sillajme ten naquen quinnamacaj ya in totome palomas. ");
INSERT INTO azzNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Huan Jesús quintacahualtiaya ma amo acsame panoanij ne tiopanijtic como cuicayaj conme. ");
INSERT INTO azzNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Huan Jesús quinmachtiaya huan quiniliaya ijcuín: ―¿Xe amo nanquimatij que tajcuiliutoc ya tech in Tajcuilolamatzin de Dios: “Nochan quitocaytisque se cali de ne tatautilis ihuan Dios para nochi in talticpacuani de nochi semanahuac”? Huan namejuan nanquichiuque nochan majyá se cali campa calyetocque in tachtequini. ");
INSERT INTO azzNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Huan quicacque Jesús in tanextiliani den tanahuatil de Moisés huan no in tayecanani den tiopixcame judíos. Huan yejuan moixejecoltiayaj huan quitemohuayaj quenín huelis para quimictisquíaj Jesús. Pero ne tayecanani quiyolmohuiliayaj de ne ichicahualis de Jesus porín quimatque ya que in pueblojuani quimoucaitayaj Jesús de itanahuatil. ");
INSERT INTO azzNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Huan queman tapoyahuic ya, ijcuacón Jesús quisac de ne Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Huan queman ne cualcampa, ijcuacón panocque ocsepa huan imomachtijcahuan quitacque ne higoscuohuit de que nochi tami huayic ya hasta inaluayo. ");
INSERT INTO azzNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Huan ijcón in Pedro ocsepa quelnamic toni mochihuac huan quilij Jesús ijcuín: ―Tamachtijque, xiconita ne higoscuohuit ten yaloa ticontelchihuac, huan axcan tami huayic ya. ");
INSERT INTO azzNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Huan Jesús tananquilij ijcuín: ―Xicpiacan hueyi tacuautamatilis ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Porín de yec melau ten namechilía, tacán acsá quijtosquía que ne tepet ma mijcuani huan ma motamota aijtic, huan como amo sayó quiquejquelcaquis tech iyolijtic, ta, quiyecneltocas que mochihuas nochi ten quijtos, ijcuacón quipía de que mochihuas nochi ten quijtosquía. ");
INSERT INTO azzNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ica ya nojón no namechilía: Nochi ten nanquitajtanisque ica netatautil, xicyecneltocacan que melau nanquiselijque ya, huan ijcón Dios namechmactis. ");
INSERT INTO azzNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Huan queman namejuan nanmotatatautilisque ihuan Dios, ijcuacón ximotapojpoluican achtopa como namejuan namechnexicolíaj ihuan acsame para ma Totajtzin Dios ten yetica nepa eluiyactzinco ma namechtapojpolui namotajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Porín tacán namejuan amo nanmotapojpoluisque ihuan acsame, ijcuacón Namotajtzin ten yetica ne eluiyactzinco amo no namechtapojpoluis namotajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Huan ijcón Jesús ihuan imomachtijcahuan yajque ocsepa Jerusalén huan nenentoya Jesús tiopan caltenojcopa. Huan motoquijque campa Jesús in tayecanani tiopixcame judíos ihuan in tanextiliani den tanahuatil de Moisés huan in huehuentzitzin den pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Huan yejuan quitajtanilijque Jesús ijcuín: ―¿Toni tanahuatil ticualcui para ticchihuas nochi nijín chihualisme? Huan, ¿aconi mitzmactij ya ne tanahuatil para ticchihuas nijín ten ticchiutinemi? ");
INSERT INTO azzNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Huan Jesús quinanquilij ijcuín: ―Nejua no namechtajtoltis se matájtanti. Huan tacán nannechnanquilíaj, ijcuacón nejua no namechilis ica aconi itanahuatil nicchihua nijín ten nicchiutoc. ");
INSERT INTO azzNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Huan Jesús quinilij ijcuín: ―Ne taahuilis ten Juan quichihuaya, ¿aconi quinahuatij in Juan ma taahuijtinemi? ¿Xe Dios quinahuatij Juan? Oso ¿xe taca san quititanque Juan? Xinechnanquilican. ");
INSERT INTO azzNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Huan ijcón yejuan moixejecoltiayaj se huan ocsé huan quijtoayaj ijcuín: ―Tacán tiquilíaj que Dios quinahuatij Juan ma taahuijtinemi, ijcuacón yejua quitos: “¿Queye amo nanquineltoquilijque?” ");
INSERT INTO azzNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Huan tacán tiquijtoaj que in tagayot san quinahuatijque Juan ma taahuijtinemi, ijcuacón amo no cualtías. Huan amo quinecque ijcón quijtosque porín quinmohuiliayaj in pueblojuani judíos huan nochi pueblojuani quipouque Juan que se yec tanahuatijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Huan ijcón quinanquilijque Jesús ijcuín: ―Yec melau amo ticmatij. Huan Jesús no quinnanquilij ijcuín: ―Huan nejua amo no namechiliti de aconi itanahuatil tenica nicchihua nijín tanextililisme. ");
INSERT INTO azzNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Huan ijcón pehuac Jesús quinmachtiaya in tacaquini ica nexcuitilme huan quiniliaya ijcuín: ―Se tagat quitocac sequi uvas tactzon tech ne imila huan quichihuac se colal. Huan tachcuac se tayohual campa quipatzcas in uvas taquilot. Huan no quichihuac se hueyi tepamit para huelis quipanitas ne uvas huan tajpías. Huan cachi satepan in patrón quitepialtijteu ica renta senme de nijín tequitini. Huan yejua in patrón yajqui huejca paxaloto itech ocsé país. ");
INSERT INTO azzNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Huan cuac yocsic ya in uvastaquilot, ijcuacón in patrón cualtitanic se taquehual campa tequitini yetoyaj para ma yejua quiselisquía uvastaquilot ten mochihuac ya. ");
INSERT INTO azzNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Pero in tequitini quiquitzquijque in taquehual huan quimajmagacque huan quiehualtijque yojqui. ");
INSERT INTO azzNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Huan ijcón in patrón ocsepa quinualtitanilij ocsé taquehual. Huan in tequitini ocsé viaje quimagacque in taquehual ica tet huan quicuacojcocojque huan no quiyocolijque. ");
INSERT INTO azzNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Huan in patrón ocsepa cualtitanic ocsé taquehual huan nijín hasta quimictijque. Huan cuac in patrón quinualtitanilij ocsequin taquehualme, ijcuacón nijín tequitini quintaluitecque ne taquehualme huan sequin no quinmictijque. ");
INSERT INTO azzNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Huan in patrón quipiaya se iyojtzin iconeu tasojtzin huan satepan quihualtitanilij no. Porín in patrón quinemilij que achá nijín iconetzin, cachi quitasojtasquíaj. ");
INSERT INTO azzNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Huan ijcón ne tequitini moixejecoltijque yejuan san ijcuín: “Yejua nijín quiselis nochi in tatoc ten pohui itatcopaca. Cachi cuali ximoyejyectalican ma ticmictican para tejuan timocahuasque nijín uvascuouta ten niaxca nitat”. ");
INSERT INTO azzNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Huan ijcón quiquitzquijque ne iconetzin huan quimictijque huan quicalantamotque calampa de ne uvascuouta. ");
INSERT INTO azzNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Huan ijcón Jesús quintajtanilij in tacaquini ijcuín: ―¿Toni quinchihuilis ne patrón in tequitini de ne uvascuouta? Ijcuacón yejuan quinanquilijque ijcuín: ―Pues in patrón hualas huan quintamiquiu nochi in tequitini huan quincahuilis ocsequin tequitini ne iuvascuouta. ");
INSERT INTO azzNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Huan Jesús no quintajtoltij ijcuín: ―¿Xe amo queman nanquileerojque ten tajcuiliutoc tech in Tajcuilolamatzin de Dios? Campa quijtoa ijcuín: In tet ten quimajpeuque in tepanchihuani, yejua nijín mochihuaco tepanchicahualoni den tepamit. ");
INSERT INTO azzNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Huan Totajtzin Dios quichihuac nijín tequit; huan para tejuan melau se taman semi cualtzin ticmoucaitacque. ");
INSERT INTO azzNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Huan ijcón in tayecanani judíos mocualantijque huan quinecque quiquitzquisque Jesús porín cajsicamatque que Jesús quinijtohuiliaya ica ne nexcuitil, que yejuan in tequitini huan Jesús in yojtzin conetzin. Huan ijcón tayecanani quicauque Jesús huan yajque porín quiyolmohuiliayaj in tagayot judíos, porín in tagayot judíos quipouque Jesús queme tanahuatijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Huan quinualtitanilijque sequin tayecanani campa yetoya Jesús huan sequin ten pohuíaj ihuan rey Herodes para quicaquilisquía tensá quijtos Jesús ten amo cuali para ica quiteluilisque de tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Huan in tayecanani motoquijque campa Jesús huan quilijque ijcuín: ―Tamachtijque, ticmatij que Tejuatzin titajtoa ica nochi ten melau huan amo tiquinyolmohuilía ten quinemilíaj in tayecanani nión ten ninchihualis. Ta, sayó titeyecnextilía ica de melau ne ojtzin de Dios. Xitechonili: ¿Xe Dios quimonequiltía ma titaxtahuacan impuestos in rey César, oso amo? ¿Xe monequi tictemacasque impuestos, oso ma amo? ");
INSERT INTO azzNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Huan ijcón in Jesús quixmatic que tacajcayahuaj san ne tayecanani huan quinilij ijcuín: ―¿Queyé nanquinequij nechichtacahuisque ica nijín tanemililis? Xinechualcuilican se tomin para ma niquita. ");
INSERT INTO azzNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Huan yejuan cualcuilijque se tomin huan Jesús quinilij ijcuín: ―¿Aconi nijín ixayac ten ixnesi nican? Huan, ¿aconi nijín tocay ten ijcuiliutoc? Huan yejuan tananquilijque ijcuín: ―Yejua ya in rey César. ");
INSERT INTO azzNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Huan Jesús quinnanquilij ijcuín: ―Xicmactilican César ten quinamiqui xicmactican César, huan xicmactican Dios ten quinamiqui xicmactican Dios. Huan ijcón in tayecanani quimoucacque de nitananquililis de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Huan ijcón motoquijque campa Jesús in taca saduceos, yejuan tamachilejque ten quineltocaj que amo aca panquisas yoltoc itzalan in ánimajme. Huan yejuan quitajtoltijque Jesús ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","―Tamachtijque, Moisés techijcuilohuilij ijcuín: “Tacán se tagat miquisquía huan quicahuasquía nisihuau huan amo quinpiasquíaj coneme, ijcuacón ma monamicti icniu tagat den miquet ihuan ne cahual sihuat. Huan ma quiniscaltican coneme ihuan ne sihuacahual para quinpiasque coneme para ne icniutagat ten miquet ya”. ");
INSERT INTO azzNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oncaya chicome icnime. In tayecanque monamictij huan niman miyic huan amo quinpialtij coneme. ");
INSERT INTO azzNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Huan ica ome teicniu monamictij ihuan ne cahual sihuat. Huan ne tagat no miyic huan amo no quinpiacque coneme. Huan ica eyi teicniu no ijcón mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Huan ica nochin chicome icnime no ijcón quichiuque. Nochin sejsé monamictijque ihuan ne sihuacahual huan nión senme den yejuan quinpiacque coneme. Huan satepan de nochin no miyic in sihuat. ");
INSERT INTO azzNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Huan axcan xitechonili, cuac panquisasque yoltocque ne icnime huan ne sihuacahual intzalan in ánimajme, ijcuacón, ¿aconi yesqui isihuau senme de nojón chicome? Porín nochi icnime quipouque queme ninsihuau. ");
INSERT INTO azzNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Huan ijcón Jesús tananquilij ijcuín: ―Namejuan nanmocajcayautocque ica ne nexcuitil porín amo nanquiyequixmatij in Tajcuilolamatzin de Dios nión in chicahualis de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Cuac panquisasque in taneltocani yoltocque itzalan in ánimajme, ijcuacón amo aquen monamictis oc, nión no tanemilijtosque oc de ne namictilis, porín ijcuacón nochi in tagayot yesque queme in ángeles, in taquehualme de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Huan cachi oc nejua namechnextilía de que nanpanquisasque yoltocque itzalan den ánimajme. ¿Achá amo queman nanquileerojque tech in Tajcuilolamatzin de Moisés queman Totajtzin Dios quinojnotza Moisés itzalan ne morasta? Huan quilij ijcuín: “Nejua ni Dios de mohuejcautetatuan, ni Dios de Abraham, ni Dios de Isaac, huan ni Dios de Jacob”. ");
INSERT INTO azzNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Huan Totajtzin Dios, Yejuatzin amo in Dios den miqueme. Ta, Yejuatzin in Dios ten naconime yoltocque. Huan ijcón namejuan nanmoyoltapololtíaj porín amo nancajsicamatij nijín. ");
INSERT INTO azzNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Huan motoquij campa Jesús senme den tanextiliani den tanahuatil de Moisés; yejua quincaquilijca in tayecanani quenín motajtoltentehuiayaj ihuan Jesús. Huan nijín tanextilijque quiyecmatoya que Jesús quinnanquilijca in tayecanani semi cuali. Huan ica nojón yejua quitajtanij Jesús ijcuín: ―Tamachtijque, ¿catiyejua in tanahuatil cachi hueyi de nochi? ");
INSERT INTO azzNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Huan Jesús tananquilij ijcuín: ―In cachi hueyi tanahuatil, yejua nijín: “Xicaquican namejuan pueblojuani de Israel, in Totecotzin Yejuatzin Totajtzin Dios, huan Totecotzin Yejuatzin setzin san. ");
INSERT INTO azzNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Huan xictasojtacan in Tohueyitecotzin to Dios ica nochi namoyolo huan ica nochi namotanejnequilis, huan ica nochi namotanemililis huan ica nochi namochicahualis”. Huan yejua ne in cachi hueyi tanahuatil de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Huan in ica ome tanahuatil quinehuilía ne achtópa tanahuatil huan no quijtoa ijcuín: “Xictasojta mocniu ijcón queme tejua timotasojta”. Amo ongac ocsé tanahuatil cachi hueyi queme nijinque. ");
INSERT INTO azzNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Huan ijcón in tanextilijque tananquilij ijcuín: ―Semi cuali ten tiquijtoa Tamachtijque. Yec melau ten tiquijtoa que ongac sayó setzin san Dios, huan amo ongac ocsé queme Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Huan no cuali ten tiquijtoa que ma tictasojtacan Totajtzin Dios ica nochi tochicahualis huan no ma tictasojtacan tocniu queme timotasojtaj tejuan san. Yejua nijín tanahuatil cachi hueyi huan que nochi ne nemactilme ten titetayocolíaj ma quichijchinocan para quimohuistilisque Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Huan ijcón Jesús quitac que ne tanextilijque tananquilijca ca cuali tanemilil huan quilij ijcuín: ―Amo huejca tiyetoc den chicahualispan de Dios de que Yejuatzin ma mitzyolyecana. Huan ijcón amo aquen moixehuijque oc quitajtoltijque Jesús ica ocsequin matájtanti. ");
INSERT INTO azzNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Huan Jesús tamachtiaya tech in tiopan de judíos huan quiniliaya in tacaquini ijcuín: ―¿Toni quijtosnequi ne tanextiliani den tanahuatil de Moisés cuac yejuan quijtoaj que in Cristo Temaquixtijque Yejuatzin teconeu de rey David? ");
INSERT INTO azzNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Porín in mismo rey David tajtoj ica in Yecticatzin Espíritu ijcuín: Totajtzin Dios quinojnotzaya in Totayecancatzin Totecotzin huan quiliaya ijcuín: “Ximotali nican noyecmacopaca huan Nejuatzin nictaliti mometztampa nochi ne naquen mitzonyoltahuelitaj”. ");
INSERT INTO azzNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Xicmatican que ne rey David quipohuac ne Cristo Temaquixtijcatzin queme iconeu de David; huan no in rey David quimohuiscanotzaya in Cristo queme itayecancatecotzin. Huan in tagayot den pueblojuani quiyecaquíaj Jesús ica míac paquilis. ");
INSERT INTO azzNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Huan Jesús quinnextiliaya ica itamachtilis ijcuín: ―Ximoyecpiacan cuidado den tanextiliani den tanahuatil de Moisés porín yejuan cuelitaj nemisque ica tilma ten cuilantinemij. Huan no cuelitaj cuac nochi in tagayot quintajpaloaj ica míac mohuisyot tech in plaza. ");
INSERT INTO azzNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Huan no cuelitaj motalisque tech in cachi cualtzin sillas tech in tiopan de judíos. Huan cuelitaj motalisque campa in cachi hueyi chihuanime campa ne tayecanani motatamacaj. ");
INSERT INTO azzNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Pero ne tanextiliani quincuilíaj inchanuan den sihuacahualme, huan sayó quixtoctíaj ay tatatautíaj senteixtano. Huan ica nojón yejuan quiselisque imaco Dios cachi hueyi tatzacuiltilis. ");
INSERT INTO azzNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Huan Jesús tocotziutoya inacastan campa quipantaliayaj in tomin para Dios, huan quiyequitztoya cuac nochi in tagayot quipantaliayaj nitomin tech in tominpialoni. Huan míac taca ricos quipantaliayaj míac tomin. ");
INSERT INTO azzNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Pero se sihuacahual ten amo teyi quipiaya, yejua ne quipantalij ome istac tomin ten valeroaya se centavo. ");
INSERT INTO azzNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Huan Jesús quinnotzac imomachtijcahuan huan quinilij ijcuín: ―De yec melau ten namechilía, que nijín sihuacahual pobre quipantalij cachi míac tomin huan que nochi in tagayot quipantalijque tech in tomin ehualoni. ");
INSERT INTO azzNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Porín in tagayot quipantalijque ten quinsobraroayaj huan nijín sihuacahual masqui amo teyi quipiaya, pero yejua quipantalij nochi nitomin ten niaxca tenica mopalehuisquía. ");
INSERT INTO azzNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Huan cuac quisac Jesús den tiopan de judíos, ijcuacón quitajtanij Yejuatzin senme den imomachtijcahuan: ―Tamachtijque, xiquita nijín cualtzitzin tepame huan ne cualtzitzin calme ten ihuan se majsitoc. ");
INSERT INTO azzNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Huan Jesús quinanquilij ijcuín: ―Nochi ten tiquita ne huejueyin calme, nimitzyequilía que amo teyi mocahuas nión se tet ten ne quinejnepanojque den ma amo huejuelihuisque. ");
INSERT INTO azzNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Huan ijcón Jesús motalito tech ne tepetzin de ne monotza Olivos den taixpan den cachi hueyi tiopan de judíos sentapalpa. Huan Pedro huan Jacobo huan Juan huan Andrés ichtacatzin quitajtanilijque Jesús ninseltij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","―Xitechonili, ¿quemanían mochihuas nijín tamilis den tiopan? Huan, ¿toni nescayome oncas cuac ajsis ne tonal queman mochihuas nochi nijín chihualisme? ");
INSERT INTO azzNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Huan Jesús quinanquilij ijcuín: ―Ximoyecpiacan, ma amo aquen namechyolcajcayahuas tech namotaneltocalis. ");
INSERT INTO azzNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Porín miacque tacajcayahuani hualasque nechtenchiutinemisque ica notocay huan quijtosque ijcuín: “Nejua ya, ni Cristo Temaquixtijque”, huan ijcón quincajcayahuasque miacque. ");
INSERT INTO azzNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Huan cuac nanquicaquisque de ne tehuilis huan míac ne moutil de ne tehuilis, ijcuacón amo ximoyoltapololtican porín ipa monequi ma ijcón mochihuas. Pero ayamo ejcos in tamilis. ");
INSERT INTO azzNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Porín pehuas moajocuisque pueblojuani huan motehuisque se huan ocsé pueblojuani, huan in tagayot de se país moajocuisque huan motehuisque se huan ocsé tagayot. Huan oncas talolinilis nonohuiyan; huan oncas máyanti huan ne tehuilis. Huan ica nijín pehuati ya ne tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Huan ximoyecpiacan namejuan san, porín namechtemactisque ihuan tequihuani, huan tech in tiopan de judíos namechuijuitequisque. Huan namechuicasque iixpan in huejueyin tanahuatiani huan in reyes porín nantacuautamatij nohuan. Huan ijcón namejuan nanmotajtohuisque de notechcacopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Huan ipa monequi ma mojmoyahua in cuali Tajtoltzin de Dios nonohuiyan nochi tech senmanahuac, huan de ompa ejcos ya in tamilis. ");
INSERT INTO azzNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Huan queman namejuan namechuicasque para namechtemactisque ninixpan de ne tequihuani, ijcuacón amo ximohuilican nión xiyoltanemilican quenín nantananquilisque, porín ne nimantzin Dios namechmactis tajtolme tenica nanquijtosque. Huan amo namejuan nantajtosque. Ta, yejua in Yecticatzin Espíritu Yejuatzin tajtos. ");
INSERT INTO azzNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Huan ijcón se tagat quitemactis ma miqui senme de niicniu; huan se tetat quintemactis niconehuan. Huan no moajocuisque tepiluan para quinmictisque nintatajuan. ");
INSERT INTO azzNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Huan nochi in tagayot namechpetztahuelitasque porín nantacuautamatij de Nejuatzin notocay. Huan naquen sen tacuautamatis hasta in miquilistempan, yejua ne maquisas. ");
INSERT INTO azzNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan xicajsicamatican den tajtoj Daniel, ne huejcautanahuatijque de Dios, que tech ne tonalme nanquitasque que mochihuas ne tetzaucapolihuilis ten quitzojcuilotía itiopan in Dios, campa amo monequi yetosquía. (Huan naquen quileeroa, ma cajsicamati.) Huan ijcón naquen yetosque Judeajcopaca, ma niman cholocan ma yacan tepeta. ");
INSERT INTO azzNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Huan naquen yetoc calcuaco, ma amo temo calijtic nión ma calaqui para quicuis tensá ne calijtic. ");
INSERT INTO azzNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Huan naquen yetos itequitiyan, ma amo mocuepa oc ma quicuiu nitaquen. ");
INSERT INTO azzNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Huan cachi teicneltiani in sihuame ten cocoxcayetosque ica pilime. Huan no cachi teicneltiani sihuame ten tachijchitijtosque ica coneme tech ne tonalme. ");
INSERT INTO azzNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ximotatatautilican ihuan Dios para ma amo namechajsis ne tonal de tajyohuilis cuac taseseyas. ");
INSERT INTO azzNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Porín tech ne tonal mochihuas hueyi tajyohuilis ten amo queman mochihuaya desde cuac tzinpehuac in talticpac ten Dios quichihuac. Huan amo queman mochihuas oc tajyohuilis queme nijín ten nanquipanosque. ");
INSERT INTO azzNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Huan como Totajtzin Dios amo quitocotzosquía nojón tonalme den tajyohuilis, ijcuacón amo aquen maquisasquía. Pero Totajtzin Dios quitocotzos in tajyohuilis de ne tonalme porín Dios quintasojta ya itaneltocacahuan naquen Yejuatzin quinijitacac ya ma pohuican ihuantzin. ");
INSERT INTO azzNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Huan tacán acsá namechilisquía ijcuín: “Xiquitacan, nican yetoc in Cristo Temaquixtijcatzin”, oso namechilisque: “Xiquitacan nepahuin yetoc in Cristo”, pero amo xicneltoquilican ne tacajcayahuani. ");
INSERT INTO azzNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Porín moajocuisque miacque tacajcayahuani ten amo yec melau Cristo Temaquixtijcatzin, huan no moajocuisque tacajcayahuani ten amo melau tanahuatiani de Dios. Huan yejuan quichihuasque míac mohuiscanexcuitilme huan huejueyin chihualisme para que ijcón huelis tecajcayahuasque. Huan achá no quincajcayahuasque hasta in taijitalme de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Huan namejuan xiquitacan, ximoyecpiacan porín nochi nijín namechilij ya achtopa que mochihuas. ");
INSERT INTO azzNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan ijcón tech nojón tonalme, nimanpa den tajyohuilis, ijcuacón in tonaltzin tayohuayantis huan amo tanextis oc, huan in metzti amo tahuis oc. ");
INSERT INTO azzNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Huan sitalinme tepehuisque den eluiyac huan in hueyi tayecanani den nemij ne ejecaixco, yejuan nojonques Dios quintzetzelos. ");
INSERT INTO azzNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Huan ijcón in tagayot quitasque que Nejuatzin ni Yectagatzin nihualajtos mixtzalan huan nicpías hueyi chicahualis huan hueyi tanahuatil. ");
INSERT INTO azzNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Huan ijcón Dios quinualtitanis iángeles itaquehualuan huan Yejuatzin quinsentilis nochi itaijitaluan de nochi senmanahuac, desde tzinehua in talticpac huan in eluiyac hasta ne campa tzintami. ");
INSERT INTO azzNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Huan no Jesús quinilij ijcuín: ―Ximomacacan cuenta ica ne nexcuitil den higoscuohuit: Cuac nanquitasque que selic ya in cuohuit huan huelaman maxihuiyojtoc, ijcuacón xicmatican que ejcotoc ya in tonalme de tatotoncayot. ");
INSERT INTO azzNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Huan ijcón no namejuan, queman nanquitasque que mochiutoc ya nijín nexcuitilme, ijcuacón xicmatican que amo huejca oc yetoc in ni Namotecotzin. Ta, niyetoc ya caltenteno ya para nihualas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Huan yec melau ten namechilía que nochi in tagayot ten axcan yoltocque ayamo miquisque como amo achto mochihuas nijín nescayome. ");
INSERT INTO azzNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Huan masqui in eluiyac huan in talticpac tamisque, pero notajtoluan amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Huan no Jesús quinilij ijcuín: ―Amo aquen quimatis in tonal de nohualalis nión in momento queman mohualuicas in Totecotzin Jesucristo. Hasta in ángeles tech in eluiyac, huan Dios Iconetzin amo no quimati. Ta, sayó Totajtzin Dios quimatoc. ");
INSERT INTO azzNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ica ya nojón ximoyecpiacan huan xiixpetantocan. Huan ximotatatautilijtocan porín amo nanquimatij ton tonal queman mohualuicas in Tecotzin Jesucristo. ");
INSERT INTO azzNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Huan ijcón Jesús quinilij ica nexcuitil ijcuín: ―Ne tonal cuac mohualuicas in Tecotzin Jesucristo queme yesquía se tagat yajtosquía huejca. Huan achto quitepialtijtehuac nichan, huan quintanajnahuatijtehuac nitaquehualuan. Huan quitequimactijtehuac nochi sejsé. Huan quinahuatijtehuac naquen tatapoa ma tajpía tech in cali ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Xiixpetantocan porín amo nanquimatij queman nejuatzin nipatrón de nijín cali niejcos, tacán tapoyauteno, oso tacán tajcoyohuan, oso queman tzajtzis in piotzin, oso cuac ne tanestihuitz ya, ");
INSERT INTO azzNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","para ma amo santajma niejcos huan namechajsiquiu nancochtocque”. ");
INSERT INTO azzNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Huan ten namechilía namejuan, no niquinilía nochi ten nohuan yectacuautamatij: Xiixpetantocan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Pero polihuía ome tonal den iluit den tajyohuilis cuac nochi in tagayot judíos quicuasque pan ten amo tamajmahual ica levadura. Huan in tayecanani tiopixcame huan in tanextiliani den tanahuatil den Moisés quitemoayaj ica tacajcayahualis para quenín quiquitzquisque Jesús queme preso para quimictisque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Huan yejuan quijtojque ijcuín: ―Ma amo tiquitzquican itech nijín iluit para ma amo onca ne cuejmololis itech in pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Huan Jesús yetoya itech pueblo Betania, campa calyetoya in Simón naquen Jesús quipajtijca ya de ninacayo pajpalanía, huan Jesús tacuajtoya ihuan Simón. Huan huala se sihuat cualcuij se tecomit temitoya ica atzin ten ajuiyac monotza nardo huan semi patiyo. Huan in sihuat quitapanac in tecomit huan quicuaojxilij Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Huan sequin ten ompa yetoyaj yolcualanque huan quilijque ijcuín: ―¿Queyé sihuat ticahuiloj nijín atzin ten ajuiyac? ");
INSERT INTO azzNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Porín cuali ticnamacasquíaj nijín atzin ica eyi ciento denarios, yesqui queme eyi mil peso, huan tiquinxejxelohuilisquíaj in pobres. Huan ijcón yejuan cajuacque in sihuat. ");
INSERT INTO azzNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Huan Jesús quinilij: ―Xicahuacan, ¿queyé nancuejmoloaj in sihuat? Nijín ten yejua nechchihuilijtoc se cuali tachihualis. ");
INSERT INTO azzNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nachipa namohuan yetosque naquen amo teyi quipía ten cuasque. Huan quémansa cuac nanquinequij, ijcuacón cuali huelis nanquipalehuisque naquen amo teyi quipía. Pero nejua amo nachipa namohuan niyetos. ");
INSERT INTO azzNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Huan nijín sihuat quichihua ten hueli, achtopa que nechtalpachosque, yejua nechojxilij ica nijín atzin. ");
INSERT INTO azzNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Huan de melau de namechilía que campa yesquí tech in senmanahuac momoyahuas in yancuic tanahuatil de Dios ten cualcui temaquixtilis, no motetapohuis ten nijín sihuatzin quichihuac para ma ijcón quielnamiquisque de yejua. ");
INSERT INTO azzNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Huan ijcón in Judas Iscariote, senme den majtactiomome imomachtijcahuan de Jesús, yejua ne yajqui quinojnotzato in tayecanani den tiopixcame para quitemactisquía Jesús inmaco in tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Huan in tayecanani cuac quicacque, ijcuacón mohuelitacque huan quitenilijque de quimacasque Judas in tomin. Huan ijcón in Judas quitemoaya queniu huelis quitemactisquía Jesús inmaco in tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Huan ajsic ya in achto tonal den iluit cuac quicuaj pan ten amo quipía tamajmahual de levadura, huan no quinemactiliaya huan quimictiayaj se ichcatzin tech ne iluit de tajyohuilis. Huan imomachtijcahuan quilijque Jesús: ―¿Can ticonmonequiltía ma tiyacan ma ticmitzchijchihuilitij in tacualis den tajyohuilis iluit? ");
INSERT INTO azzNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Huan ijcón in Jesús quintitanic omen de imomachtijcahuan huan quinilij ijcuín: ―Xiyacan tech ne pueblo huan ompa namechnamiquis se tagat quimamajtiu se tzotzocol de at huan yejua ne xictoctilican. ");
INSERT INTO azzNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Huan campa yejua calaquis, ompa xiquilican in patrón den ne cali ijcuín: “In Tamachtijque quijtoj ijcuín: ¿Can yetoc in nepancal campa nicuas in tacualis den tajyohuilis iluit ninuan nomomachtijcahuan?” ");
INSERT INTO azzNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Huan ne patrón namechnextilis se hueyi nepancal ica ome cali den ipa xeliutoc ya. Huan ompa xicyectatalican ompa para tejuan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Huan ijcón yajque imomachtijcahuan huan calacque tech ne pueblo huan niman quiajsito in tagat queme Yejuatzin quinilijca ya. Huan ijcón quiyectatalijque in tacualis den tajyohuilis iluit. ");
INSERT INTO azzNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Huan queman tapoyahuic ya, Jesús huala inuan in majtactiomome imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Huan cuac nochi motalijque campa in mesa para tacuasque ya, ijcuacón Jesús quinilij ijcuín: ―De yec melau den namechilía que senme de namejuan ten nican nohuan nantacuajtocque, yejua ne nechtemactis inmaco in tayecanani para nechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Huan ijcón nochi yejuan peuque motayocoltiayaj huan moixpantiliayaj se huan ocsé: ―¿Xon amo nejua? Huan ocsé quijtoya ijcuín: ―¿Xe nejua? ");
INSERT INTO azzNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Huan Jesús tananquilij ijcuín: ―Yesquí senme den namejuan majtactiomomen, aquen pantajaquía tech noplato. ");
INSERT INTO azzNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Huan de yec melau de namechilía: Nejuatzin ni Yectagatzin huan niyó nimiquiti ijcón queme tajcuiliutoc de nejua tech in Tajtoltzin de Dios. Huan cachi teicneltijque ne tagat naquen nechtemactis Nejuatzin ni Yectagatzin. Cachi cuali nojón tagat ma amo yolini nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Huan cuac tacuajtoya oc, ijcuacón in Jesús quicuic se pantzin huan quitiochihuac huan quicojcotonac huan quinmactij imomachtijcahuan huan quinilij ijcuín: ―Xicuacan nijín pantzin; yejua ya nijín nonacayo. ");
INSERT INTO azzNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Huan de ompa Jesús quicuic in vino huan quitasojcamachilij Dios huan quinmactij imomachtijcahuan. Huan ijcón nochi tayicque de ne tayil. ");
INSERT INTO azzNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Huan Jesús ocsepa quinili ijcuín: ―Nijín vino, yejua ya noesyo, huan de ne yejica quitenextilía que timoyectencauque ya de que noesyo mimilahuis huan nimiquis para ijcón maquisasque miacque tagayot de nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Huan yec melau ten namechilía que amo ocsepa nitayis nijín vino hasta queman ne tonal cuac tisentayisque cuac Totajtzin Dios momasoutoc namoyolijtic ica ihueyichicahualis para namechyolyecantiyás. ");
INSERT INTO azzNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Huan queman tamic cantarojque ya de se himno, ijcuacón nochin quisque huan yajque campa tepetzin den monotza Olivos. ");
INSERT INTO azzNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Huan quinilij Jesús ijcuín: ―Nochi namejuan nanmomoutisque huan nanmoyolxocolisque de Nejuatzin tech nijín tayohuac. Porín ijcón ijcuiliutoc tech in Tajcuilolamatzin de Dios: “Nicojcocos in tapixque huan niichcahuan sejseyajcan yasque”. ");
INSERT INTO azzNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Huan satepan queman nipanquisas ya niyoltoc intzalan in ánimajme, ijcuacón niyás namechyecantiyás hasta ne Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ijcuacón in Pedro quilij ijcuín: ―Masqui nochi in tagayot moyolxocolisquíaj, pero nejua amo. ");
INSERT INTO azzNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Huan quinanquilij Jesús ijcuín: ―Pero de yec melau nimitzilía, que tejua axcan tech nijín tayohuac achtopa que tzajtzis in piotzin ojpa, tejua titeilis expa que amo tinechixmati. ");
INSERT INTO azzNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ijcuacón in Pedro cachi moyolchicahuaya huan quijtoaya ijcuín: ―Ta, como ijcón monequi, masqui no nimiquisquía mohuan, pero nejua amo queman niteilis que amo nimitzixmati. Huan nochi imomachtijcahuan quijtoayaj ijcón. ");
INSERT INTO azzNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Huan ejcocque tech ne xocomilajpa campa monotzaya Getsemaní, huan ompa Jesús quinilij imomachtijcahuan ijcuín: ―Ximosehuican nican huan Nejuatzin niyó nimotatatautiliti ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Huan ijcón Jesús quinseuiyac in Pedro, huan Jacobo, huan Juan. Huan de ompa Jesús pehuac motayocoltía huan moyolcocoa ya. ");
INSERT INTO azzNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Nicmachilía tech noyolo de que nitayocolmiqui porín ejcotoc ya nomiquilis. Namejuan ximocahuacan nican huan xiixpetantocan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Huan ijcón in Jesús yajqui cachi nepaca huan motancuaquetzac huan motentocato talixco huan motatatautilij inahuac Itajtzin huan quiliaya ijcuín: ―Como ijcón mopaquilis ma pano ma amo nechajsiqui nijín momento de tajyohuilis. ");
INSERT INTO azzNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Huan no quijtoj Jesús ijcuín: ―Abba, Notajtzin, nochi huelis Tejuatzin ticonnchihuas. Xiconxelo de Nejuatzin nijín tajyohuilis. Pero amo xiconchihua ten Nejuatzin nicnequi. Ta, ma mochihua ijcón queme Tejuatzin ticomonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Huan no ijcón Jesús huala huan quinajsico imomachtijcahuan cochtocque huan Jesús quilij Pedro ijcuín: ―Simón, ¿cox ticochtoc? ¿Xe amo tihueli tiixpetantoc nión se hora? ");
INSERT INTO azzNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Xiixpetantocan huan ximotatautilican ihuan Dios para ma amo nanuetzisque itech in ohuijcayot de que in Satanás namechichtacahuis. De yec melau que namoyolo quinequi quichihuas ten cuali, pero namonacayo cuetautoc porín amo nanquipiáj ne yec tacuautamatilis ihuan Dios huan amo huelis nanquichihuasque ten cuali. ");
INSERT INTO azzNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Huan ocsepa Jesús yajqui motatatautilito ihuan Dios ica mismo tajtolme queme ipa quijtojca ya. ");
INSERT INTO azzNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Huan cuac moquepac Jesús campa imomachtijcahuan ocsepa, ijcuacón quinajsico cojcochtocque imomachtijcahuan porín ninixtololohuan ixtzatzacuíaj ica ne cochilis. Huan amo quimatíaj oc imomachtijcahuan quenín quinanquilisque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Huan ica expatica huala Jesús huan quinilij ijcuín: ―Xicochican ya; ximosehuican ya. Porín axcan quema, ejcoc ya in hora den notajyohuilis. Xiquitacan que Nejuatzin ni Yectagatzin nechtemactisque ya inmacopa in taca tajtacolejque para nechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ximoquetzacan huan tiyohue, xiquitacan ejcotoc ya, huan motoquijtoc ya naquen nechtemactis inmaco in tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Huan cuac Jesús tajtojtoya oc, ijcuacón huala Judas, senme de ne majtactiomomen imomachtijcahuan huan yejua quinsenualcuía míac tagayot ten cualcuijque machete huan cuohuit. Nochi nijinque hualajque intencopaca in tayecanani tiopixcame huan tanextiliani den tanahuatil de Moisés huan in huehuentzitzin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Huan Judas naquen quitemactij Jesús, yejua ne ipa teilijca ya quenín quitemactisquía Jesús huan quijtojca ya ijcuín: ―Naquen nejua nictennamiquis, yejua ne yesqui in Jesús; xiquitzquican huan xicuiyacan xicyectzicocan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Huan ijcón quichihuac in Judas huan motoquij campa Jesús huan quilij ijcuín: ―Tamachtijque, Tamachtijque. Huan ijcón nimantzin Judas quitennamic in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Huan ijcón in tagayot quimasoluijque Jesús huan quiquitzquijque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Huan senme den imomachtijcahuan de Jesús ten yetoya ya ihuan, yejua ne quiquixtij imachete huan quicocoj in taquehual den hueyi tiopixcat huan quicotonac inacas. ");
INSERT INTO azzNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Huan ijcón Jesús quinilij ijcuín: ―¿Queyé nanualajque para nannechquitzquisque queme yesquía se nitachtecque san? ");
INSERT INTO azzNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Huan mosta mosta Nejuatzin niyetoya namohuan namechmachtiaya tech namotiopan huan amo nannechquitzquijque ompa. Huan nochi nijín ijcón mochihuac para ma motamichihuas ten tajcuiliutoc ya tech in Tajcuilolamatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Huan ijcón nochi imomachtijcahuan quicauteuque Jesús huan cholojque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huan se telpoch oc quitoctiliaya Jesús huan quemiliutiaya ica se hueyi tilma; huan yejua no quiquitzquijque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero yejua quincahuilijteu nitilma huan choloj xicaltic. ");
INSERT INTO azzNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Huan ijcón cualicque Jesús inixpan in tayecanque den tiopixcame. Huan no mosentilijque nochi in tayecanani tiopixcame huan in huehuentzitzin huan in tanextiliani den tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Huan ijcón in Pedro quihuejcatoctiliaya Jesús huan ajsic ne calijticpa den ichan in tayecanque den tiopixcame, huan ompa tocotziutoya ihuan in mayolme, huan mototonijtoya ticoteno. ");
INSERT INTO azzNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Huan in tayecanani tiopixcame huan nochi in hueyi chihuanime quiyoltemoayaj ica tensá tajtol para quipajpantisquíaj Jesús huan para quitemactisque huan para quimictisque. Huan amo teyi cajxiliayaj. ");
INSERT INTO azzNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Huan miacque quipajpantiayaj Jesús ten amo melau. Pero yejuan motajtolxixicoayaj san huan mopajpantiayaj yejuan san. ");
INSERT INTO azzNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Huan ocsequin taca moquetzque huan tensá tacajcayahualis quipajpantijque Jesús huan quijtojque ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","―Tejuan ticaquiliayaj que yejua quijtoj ya ijcuín: “Nejua nicuejuelos nijín tiopan den quimachijchiuque huan tech eyi tonalica nicyecchihuas ocsé tiopan de amo tachijchihual ica imay de se tagat”. ");
INSERT INTO azzNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Huan nión ijcón amo monehuiliaya in tapajpantilis. ");
INSERT INTO azzNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Huan ijcón in hueyi tiopixcat moquetzac tatajcoyan den tayecanani huan quitajtanilij Jesús ijcuín: ―¿Queyé amo teyi titananquilía? ¿Toni nijín ten mitzpajpantijtocque? ");
INSERT INTO azzNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Huan Jesús motentamatiliaya san huan amo teyica tananquiliaya. Huan in hueyi tiopixcat ocsepa quiyancuicatajtanilij ijcuín: ―¿Xe tejua ya in Cristo Temaquixtijque, Iconetzin in Totajtzin Dios naquen itatiochihualtzin de Dios? ");
INSERT INTO azzNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ijcuacón Jesús quinilij ijcuín: ―Quema, Nejuatzin ya. Huan no nannechitasque cuac Nejuatzin ni Yectagatzin nimotalis iyecmacopaca campa in chicahualis de Dios huan nihualajtos mixtzalan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ijcuacón in hueyi tiopixcat pehuac momojmotzoaya ica ne itilma porín quixejecoj que Jesús quihuijuicaltij Totajtzin Dios. Huan in hueyi tiopixcat quinilij ocsepa ijcuín: ―¿Para toni oc monequi cachi tictemosque testigos para ma quipajpantiquij oc? ");
INSERT INTO azzNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Namejuan nancacque de nijín tajtolme tenica quihuijuicaltij Dios. Huan, ¿toni nanquixejecoaj namejuan ma ticchihuacan? Huan nochin in tayecanani moixejecoltijque de que cachi cuali ma miqui in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Huan sequin peuque quiixchijchacque Jesús. Huan de ompa quiixtzacuacque Jesús huan quimagacque ica nimahuan huan quilijque ijcuín: ―Xiquixejeco aconi mitzmagac. Huan ijcón in mayolme quiixhuihuitecque. ");
INSERT INTO azzNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Huan queman in Pedro yetoya tani tech in patío, ijcuacón huala se suapil ten tetixilijque para in hueyi tiopixcat. ");
INSERT INTO azzNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Huan queman in suapil quitac in Pedro ne calan mototoniaya, ijcuacón yejua quixitac huan quilij Pedro ijcuín: ―Tejua no tiyetoya ihuan in Jesús de Nazaret. ");
INSERT INTO azzNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Huan ijcón Pedro quitatij ten melau huan quijtoj ijcuín: ―Amo niquixmati, nión nicmati ten tinechilijtoc. Huan ijcón calanquisac Pedro huan nimatzin tzajtzic in pío. ");
INSERT INTO azzNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Huan in tetixilijque ocsepa quitac Pedro huan pehuac quinilij ne naquen ompa yetoyaj ijcuín: ―Nijín tagat no pohuía ihuan Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Huan in Pedro ocsepa quitatij ten melau. Huan amo huejcahuac oc huan in tagayot ten ompa yetoyaj peuque quilíaj Pedro ijcuín: ―Tejua Pedro, yec melau tejua ninuan tipohuía. Porín tejua no tiixtamati queme ne taca de Galilea huan motajtolis sansé ijcón queme yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ijcuacón in Pedro pehuac tahuijuicaltía elihuis huan quinilij ijcuín: ―Quitztica Dios, que amo niquixmatic ne tagat ten namejuan nanquijtoaj. ");
INSERT INTO azzNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Huan ijcón in piotzin ica ojpa tzajtzic. Ijcuacón quelnamiyic Pedro den tajtolme ten Jesús quilijca ya achtopa: “Yec melau que achtopa ya que tzajtzisquía ojpa in piotzin, tejua tiquijtos expa de que amo tinechixmati”. Huan ijcón quelnamiyic Pedro huan pehuac mochojchoctía elihuis. ");
INSERT INTO azzNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Huan imostica cuac santanesic ya, ijcuacón in tayecanani tiopixcame mosentilijque ihuan in huehuentzitzin huan in tanextiliani den tanahuatil de Moisés; huan no yetoyaj nochi in huejueyin tamachilejque judíos. Huan cuiyacque Jesús tzicautiyáj huan quitemactijque ihuan in hueyi tequihua Pilato. ");
INSERT INTO azzNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Huan Pilato quitajtanilij Jesús ijcuín: ―¿Cox tejua titayecanque de judíos? Huan tananquilij Jesús ijcuín: ―Quema, ijcón queme tejuatzin tiquijtoa. ");
INSERT INTO azzNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Huan ijcón in tayacanani tiopixcame quiteluiliayaj Jesús ica míac tataman. ");
INSERT INTO azzNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Huan ocsepa Pilato quitajtanilij Jesús ijcuín: ―¿Amo teyica titananquilía? Xiquita ica míac tataman mitzteluilíaj in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Huan nión ica por nojón matájtanti tananquilij Jesús. Huan ica ya nojón in Pilato amo quimatía oc toni quichihuas oc. ");
INSERT INTO azzNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Huan tech ne tonalme de nijín tajyohuilis iluit, Pilato mohuicaya de que quincahuilis se naquen tzactosque preso, aquen yesqui ten quitajtanisquíaj in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Huan oncaya se preso monotzaya Barrabás tzactoya ihuan ocsequin temictiani. Yejuan motehuijcaj ihuan in soldados den tayecanani huan quinmictijcaj miacque ya. ");
INSERT INTO azzNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Huan motoquijque miacque tagayot campa Pilato huan peuque quitajtanilíaj ma quinchihuili queme ipa huan ma quincahuilis se preso. ");
INSERT INTO azzNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Huan in Pilato quinnanquilij ijcuín: ―¿Cox nanquinequij ma nicajcahua in tayecanque de judíos? ");
INSERT INTO azzNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Huan ipa in Pilato quimatoyaya que in tayecanani tiopixcame quitemactijque Jesús ica ne xicolot porín quitahuelitacque. ");
INSERT INTO azzNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Huan ijcón in tayecanani tiopixcame quincuejmolojque in tagayot huan quintajtolmagacque ma quitajtanilican Pilato ma cachi cuali ma quincahuili in preso Barrabás. ");
INSERT INTO azzNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Huan tananquilij in Pilato ijcuín: ―¿Toni nanquinequij ma nicchihuas ihuan nijín tagat naquen nanquinotzaj tayecanque de judíos? ");
INSERT INTO azzNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Huan ijcón nochi in tagayot tzajtzicque ijcuín: ―Xicuoupampilo. ");
INSERT INTO azzNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Huan in Pilato quintajtanilij ijcuín: ―¿Toni quichihuac nijín tagat ten amo cuali? Pero in tagayot cachi chicahuac tzajtzíaj ijcuín: ―Xicuoupampilo. ");
INSERT INTO azzNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pero queme in Pilato amo quinequía ma quicualancaitacan nijín pueblojuani, ica ya nojón quincahuilij in preso Barrabás. Huan de ompa quitemactij Jesús ma quicuetaxuican huan ma quicuoupampilocan. ");
INSERT INTO azzNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Huan ijcón in soldados cuiyacque in Jesús icalteno in rey de ne cali monotza pretorio, huan quinsentilijque nochi in ocsequin soldados. ");
INSERT INTO azzNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Huan quitaquentijque Jesús ica se tilma morado, huan quicuatalilijque se corona yohualtic den tajquitil de huitzti. ");
INSERT INTO azzNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Huan peuque quiquejqueltajpaloayaj Jesús huan quiliayaj ijcuín: ―Timitzontajpaloaj, tejuatzin titayecanque den judíos. ");
INSERT INTO azzNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Huan quicuahuijuitequíaj Jesús ica se acat huan quiixchijchayaj. Huan motancuaquetzayaj para majyá quimohuistiliayaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Huan cuac quitamiquejquelojque ya Jesús, ijcuacón quiquixtilijque nitilma morado huan quitaquentijque ica yejua itasal huan cuiyacque para quicuoupampilosque. ");
INSERT INTO azzNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Huan yetoya ojteno se tagat monotzaya Simón de Cirene, yejua tetat den Alejandro huan Rufo, huan huala den mila. Huan in soldados quinajnahuatijque ma cuica in cruz de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Huan cuiyacque Jesús tech se lugar monotzaya Gólgota, quijtosnequi miquetzontecomaco. ");
INSERT INTO azzNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Huan quimacacque Jesús ma tayi vino tamanelol ihuan se panti de se cuouchoquilo monotza mirra; pero Jesús amo tayic. ");
INSERT INTO azzNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Huan cuac quicuoupampilojque ya, in soldados quichiuque ne tatanilis para quitasquía catín tasal de Jesús cuicasquía cada soldado. Huan ijcón quixejxelojque nochi itasal de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Huan queman catca chicnahui hora de cualcan, ijcuacón quicuoupampilojque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Huan quitenextilijque in tajtolme tenica quimictisque: “Yejua nijín in tayecanque de judíos”. ");
INSERT INTO azzNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Huan no quincuoupampilojque ihuan nijín Jesús ome tachtequini, se iyecmacopaca huan ocsé iopochcopaca. ");
INSERT INTO azzNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Huan nochi nijín motamichihuac ijcón queme quijtoa tech in Tajcuilolamatzin de Dios: “Quipouque in Taquehual de Dios ihuan in taca ten amo yolcualime”. ");
INSERT INTO azzNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Huan naquen panoayaj quiquejquelojtoyaj huan cuahuihuicayaj huan quiliayaj Jesús ijcuín: ―Semi tixoxo, tejua ten ticuejuelosquía in tiopan de Dios huan eyi tonalica ocsepa ticchijchihuasquía. ");
INSERT INTO azzNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ximomaquixti tejua moselti, huan xitemo tech ne cruz. ");
INSERT INTO azzNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Huan ijcón in tayecanani tiopixcame huan in tanextiliani de tanahuatil de Moisés no quiquejqueloayaj Jesús huan moyolnojnotzayaj se huan ocsé ijcuín: ―Jesús quinequía quinmaquixtis ocsequin taca, pero yejua san amo huelis momaquixtis. ");
INSERT INTO azzNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Huan ocsequin quilijque Jesús ijcuín: ―Como tejua ya in Cristo Temaquixtijque, titayecanque de Israel, axcan xitemo tech in cruz, para ma tiquitacan motanahuatil huan ijcón timitzneltoquilisque de que tejua in Cristo. Huan in tachtequini ten quincuoupampilojque inajnacastan Jesús, yejuan nojonques no quitejtelchihuayaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Huan cuac ajsic nepanta ya, ijcuacón pehuac tayohuayantis nochi in senmanahuac, huan huejcahuac hasta eyi hora de tiotac. ");
INSERT INTO azzNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Huan tech eyi hora de tiotac, Jesús tzajtzic chicahuac huan quijtoj ijcuín: ―Eloi, Eloi, ¿lama sabactani? ―quijtosnequi: no Dios, no Dios, ¿queyé tinechsencahuac? ");
INSERT INTO azzNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Huan queman ijcón quicacque nijín tajtolme, ijcuacón sequin den ompa yetoyaj quijtojque ijcuín: ―Xiquitacan, majyá quinotza Elías ne tanahuatijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Huan yajtihuetzic se tagat, quicuito se taman tasal ten posoni huan quiajaquij itech vinagre huan ica se acat quiyecapantalilij. Huan de ompa quintentalilij Jesús ma quichichina. Pero ocsequin tagayot quilijque ijcuín: ―Xicahua, ma tiquitacan cox hualas ne Elías huan cox quipalehuis temos. ");
INSERT INTO azzNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Huan ijcón in Jesús tzajtzic chicahuac huan momiquilij. ");
INSERT INTO azzNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Huan in tasal ica tatzacuaya calteno de tiopanijtic, yejua ne tzayanic sentatajco huan ome quisac desde ajco huan hasta tani. ");
INSERT INTO azzNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Huan in capitán de soldados de romanos ijcatoya iixpampa Jesús. Huan queman quitac queniu tzajtzic Jesús huan miyic, ijcuacón yejua quijtoj ijcuín: ―Yec melau nijín tagat catca Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Huan no ompa yetoyaj sequin suatzitzin quitztoyaj huejca san. Ompa ihuan yetoyaj María Magdalena huan María tenan de Jacobo in taxocoyot, huan tenan de José, huan no yetoya Salomé. ");
INSERT INTO azzNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nojonque sihuame quitoctiliayaj Jesús huan quitequitiliayaj Yejuatzin cuac yetoya tech in pueblo de Galilea. Huan no yetoyaj ocsequin miacque sihuame ten hualajque ihuan Jesús tech ne Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Huan cuac tapoyahuic ya, ijcuacón pehuac in hora cuac in tagayot judíos moyeyectaliayaj para imostica queman iluitonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Huan huala campa rey Pilato se tagat monotzaya José de Arimatea. Yejua ne se tagat yolcuali ten pohuic ihuan in tamachilejque judíos huan no quichiaya ma ejco in tiempo queman Dios momasoutoc ica ihueyichicahualis ipan itaneltocacahuan. Huan ne tagat calayic ica míac ne yolchicahualis campa yetoya rey Pilato huan quitajtanilij inacayo in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Huan in Pilato quimoucacayic que miyic ya Jesús huan quinotzac in capitán den soldados romanos huan quitajtanilij xe melau que miyic ya in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Huan queman in capitán romano quilij que melau, ijcuacón quimactilijque José inacayo in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Huan in José quicohuato se tilma huan quitemohuij Jesús itech in cruztzin, huan quiquemiloj huan quitalito itech se miquetecoch, ten ipa tachijchiu ya tech se tequespan. Huan quitetecuinojque se hueyi tet para ica quitentzacuasque in miquetecoch. ");
INSERT INTO azzNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Pero in María Magdalena huan María tenan de José quitztoyaj campa quitalijque inacayo Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Huan queman panoc ya in tonal de nesehuilis, ijcuacón María Magdalena, huan in María tenan de Jacobo, huan ocsé sihuat Salomé, yejuan nojonques quicouque sequin xiutzitzin den ajuiyac para quiojxilisque inacayo in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Huan tech in domingo, yejua in tayecanque tonal den semana, de ne cualcampan queman quisac ya in tonaltzin, ijcuacón in sihuame yajque campa miquecoyoc. ");
INSERT INTO azzNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Huan monojnotzayaj tech in ojti ijcuín: ―¿Aconi techajchihuilisque in tet tenica tentzactoc in miquecoyoc? ");
INSERT INTO azzNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Huan cuac ajsicque ya, ijcuacón quitacque que cajchiuque ya ne tet ten semi hueyi. ");
INSERT INTO azzNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Huan queman calacque tech in miquetecoch, ijcuacón quitacque se telpoch tocotziutoya iyecmacopaca in miquetecoch huan quemiliutoc in telpoch ica se hueyi tilma ten semi istac, huan in sihuame momoutijque. ");
INSERT INTO azzNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Huan in ángel quinilij ijcuín: ―Amo ximomoutican, nanquitemoaj Jesús nazareno, naquen quicuoupampilojcaj ya. Yejuatzin panquisac ya yoltoc itzalan in ánimajme huan amo nican yetoc. Xiquitaquij in lugar campa quitalijcaj ya. ");
INSERT INTO azzNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Huan axcan xiyacan xiquinilitij Pedro huan in ocsequi imomachtijcahuan que Yejuatzin namechyecanati campa Galilea; huan ompa nanquitasque queme namechilijca ya. ");
INSERT INTO azzNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Huan in sihuame quisque den miquetecoch huan cholojque porín moucahuihuiyocayaj. Huan amo aquen teyi quiliayaj porín momoutiayaj. ");
INSERT INTO azzNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Huan Jesús panquisac ya yoltoc intzalan in ánimajme tech ne domingo cualcan, yejua ne tayecanque tonal. Huan quimonextilijca achto in María Magdalena, naquen Jesús quinquixtilijca ya in chicome amocualime ejecame. ");
INSERT INTO azzNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Huan ijcón yajqui in María Magdalena huan quinmatiltito nochi ten ihuan Jesús yetoyaj porín yejuan moyolcocoayaj huan chocatoyaj san. ");
INSERT INTO azzNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Huan queman imomachtijcahuan de Jesús quicacque que panquisac ya yoltoc ya Jesús, huan quicacque que in María quitac ya in Jesús, ijcuacón yejuan amo quineltocacque. ");
INSERT INTO azzNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Huan satepan Jesús quinmonextilij ica ocsé taman inixpan omen imomachtijcahuan ten yayaj tequititij mila. ");
INSERT INTO azzNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Huan ijcón yejuan yajque huan quinmatilijque ocsequin imomachtijcahuan de Jesús. Pero nión ica nojón tajtol amo no quineltocacque yejuan. ");
INSERT INTO azzNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Huan satepan quinmonextilij Jesús in majtactionseme imomachtijcahuan queman sen yetoyaj tacuajtoyaj. Huan Jesús quinajuac porín amo quipiayaj in yec tacuautamatilis huan porín amo yec tacuautamatoyaj ihuan Jesús tech ninyolojuan. Porín amo quinneltoquiliayaj neques ten quiniliayaj que quitacque ya Jesús panquisac ya yoltoc in tzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Xiyacan nochi senmanahuac huan xitanojnotzacan ica in cuali Tajtoltzin de Dios nochi ten nemij nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Huan naquen yec tacuautamati itech in Cristo Temaquixtijque, yejua nojón maquisas de nitajtacoluan. Pero naquen amo yec tacuautamati itech in Cristo Temaquixtijque, yejua ne yesqui tatelchihual. ");
INSERT INTO azzNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Huan ica nijín mohuistic nescayome mopalehuisque naquen yec tacuautamati itech in Cristo: Notencopaca quincalanquixtisque in amocuali ejecame. Huan tajtosque ica in yancuic tajtolme. ");
INSERT INTO azzNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Huan quinquitzquisque ica inmahuan cohuame. Huan tacán tayisque tensá tepahuisquía, ijcuacón amo teyi quinchihuilis. Huan ipan in cocoyani quintalilisque ninmahuan huan pajtisque. ");
INSERT INTO azzNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Huan in Totecotzin Jesucristo cuac quintaminojnotzac ya imomachtijcahuan, ijcuacón yajqui ajco eluiyac huan motalito iyecmacopaca in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Huan ijcón yejuan imomachtijcahuan quisque huan yajque tanojnotzatoj nohuiyampa. Huan in Totecotzin quinpalehuiaya huan tenextiliaya ica mohuistic nexcuitilme que yec melau nijín yancuic Tajtoltzin tenica tanojnotzayaj. Amén.");
INSERT INTO azzNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Huan yejua ya nijín hueyi melau que miacque taca tamatinime quiejecoayaj ya para quijcuilosque de catiyejua tequime mototoctilijtihualajque totechcacopaca tejuan tiitaneltocacahuan de Cristo Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Huan ne tetajtohuiltiani techmajmactijtihualajque nochi itequihuan de Cristo Jesús, ijcón queme yejuan quitilijtihualajque Cristo Jesús, porín yejuan motequitiltijtihualayaj ica in tanojnotzalis den Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ica ya nojón niquixejecoa que semi quinamiqui nimitzonijcuilohuilis, tejuatzin de tiontequihua Teófilo, de queniu mototoctijtihualaya nochi nijín chihualis de Cristo ten mochihuaco ne achtopa. Huan yejua ya nijín nicchihuati porín nejua nicyectatemolijtihuitz ya ica nejmach nochi nijín chihualis de Cristo. ");
INSERT INTO azzNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Huan ijcón, tejuatzin Teófilo, cachi oc ticyecajsicamatiquiu ya que nochi melau nochi ten mitzonnextilijtihualayaj ne ocsequin tamachtiani. ");
INSERT INTO azzNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Huan cuac in rey Herodes tayecantinemía campa Judeajcopaca, ijcuacón nojón tonalme nentinemía se tiopixcat judío ten monotzaya Zacarías, ten pohuía ihuan ne panti tiopantequitini de quinyecantihualaya ne huejcau tetat Abías. Huan isihuau Zacarías monotzaya Elisabet. Huan ne Elisabet no poutinemía ihuan ichancahuan de ne huejcau tiopixcat judío ten monotzac Aarón. ");
INSERT INTO azzNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Huan ne Zacarías huan Elisabet yejuan yolchipaucanentinemíaj iixpantzinco Totajtzin Dios. Huan yejuan no quintacamatinemíaj nochi in tanahuatilme huan in tanextililisme de Totecotzin. Huan ijcón amo aquen huelía quinteluilis ica tensá tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Huan Zacarías huan Elisabet amo quinpiayaj inconehuan porín Elisabet amo huelía tascaltis. Huan no porín yejuan catcaj semi xihuejque ya. ");
INSERT INTO azzNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Huan ejcoc in tonal cuac in Zacarías huan itiopixcaicnihuan monequía tequitisque queme tiopixcame nepa tiopanijtic iixpantzinco Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Huan quichiuque netátanti ijcón queme mohuicayaj in tiopixcame, para ijcón quitasquía aconi tayecanasquía tech nijín tequit. Ica ya nojón ejcoc in tonal que Zacarías monequía ma calaquis tiopanijtic para tapopochuis ica copal iixpantzinco Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Huan cuac in Zacarías tapopochuijtinemía tiopanijtic, ijcuacón nochi in tagayot ne calampa motatatautilijtoyaj iixpantzinco Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ijcuacón monextico iixpan Zacarías se ángel taquehual de Dios. Huan in ángel moquetztihuetzico iyecmacopaca den altar ne mesa campa tapopochuijtinemía in Zacarías. ");
INSERT INTO azzNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Huan cuac in Zacarías conitac in ángel, ijcuacón yejua hasta amo quimatía oc toni quichihuas porín mohueyiyolmoutiaya. ");
INSERT INTO azzNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Pero in ángel quilij Zacarías ijcuín: ―Tejua Zacarías, amo ximoyolmouti porín Totajtzin Dios mitzcaquilij ya monetatatautilis. Ica ya nojón axcan mosihuatzin Elisabet quipías se oquichpil huan nojón oquichpil monequi nanquitocaytisque Juan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Huan tejua Zacarías tiyolpactinemis huan timohuelitztinemis. Huan miacque tagayot moyolpactisque porín yoliquiu ya ne namoconetzin. ");
INSERT INTO azzNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Huan no tiyolpactinemis porín ne namoconetzin Dios quipohuas hueyi chiuque. Huan ne namoconetzin amo queman tayis in vino huan nión in cococat. Huan no Totajtzin Dios quiyolpepexocaltijtinemis namoconetzin ica in Yecticatzin Espíritu desde achtopa que yolicquiu nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Huan no in ángel quilij Zacarías ijcuín: ―Huan no namoconetzin quinchihualtis que míac pueblojuani judíos ma quicahuacan nintajtacoluan huan ma quitoctilican Totecotzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Huan ne Juan tayecanaquiu para tanojnotztinemis itencopaca den Totecotzin Cristo. Huan ne Juan quipixtinemis in chicahualis den Yecticatzin Espíritu ijcón queme ne huejcautanahuatijque Elías quipixtinemico. Huan ne Juan quinyoltaliquiu neques tetatme para ma amo mocualantijtinemican ihuan inconehuan. Huan no Juan quinyolmajxitis neques ten amo tatacamatinemij para ma ijcón yejuan no ma momachtican queniu chipaucanemisque ijcón queme chipaucanemij neques ten yolchipauque ya. Huan ijcón in Juan quinyolmajxitijtinemis in tagayot para ijcón cachi huelis quiselisque itanahuatil den Totecotzin Cristo. ");
INSERT INTO azzNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ijcuacón in Zacarías quitajtoltij in ángel ijcuín: ―¿Queniu huelis nicmatis que melau nochi nijín mochihuaquiu? Porín nejuatzin nihuehuentzin ya huan no ijcón nosihuau. ");
INSERT INTO azzNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Huan ijcón in ángel quinanquilij ijcuín: ―Nejua ya ni Gabriel, ten nictequitilijtinemi sayó Dios nepa iixpantzinco Yejuatzin. Porín Totajtzin Dios nechualtitanic para ma nimitznojnotzaqui huan para ma nimitznejmachtiqui ica nijín cualtzin tanejmachtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Huan axcan queme amo ticyecneltocac ten nimitzilía, ica ya nojón xicmati, tejua Zacarías, tinoncuis huan amo huelis titajtos hasta in tonal cuac yolis namoconeu. Huan nochi nijín ten nimitzilijtoc motamichihuas tech ne tonal cuac monequis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Huan nochi nijín ijcón mochiutoya cuac in tagayot quichixtoyaj Zacarías ne calampa. Huan quimoucamatíaj que in Zacarías semi huejcahuato ya ne campa cachi tiopanijtic. ");
INSERT INTO azzNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Huan cuac Zacarías hual calanquisac den tiopan, ijcuacón amo huelía quinnojnotzas. Ica ya nojón in tagayot cajsicamatque que Zacarías tajtachíac ne tiopanijtic queme cuac se tacochitztosquía. Huan ijcón in Zacarías sayó tanejnextiaya ica imahuan cuac hual quisac ya ne tiopanijtic porín yejua nontzincuic ya. ");
INSERT INTO azzNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Huan cuac in Zacarías quitamichihuac nitequiu ne tiopanijtic, ijcuacón yajqui ichan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Satepan de nochi nijín mochihuac ya, ijcuacón in Zacarías isihuau mopilcuic ya huac ijcón in Elisabet mocahuac sayó calijtic san ipan macuil metztica. Huan ipan nojón macuil metztica quinemilijtinemía in Elisabet ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“In Totecotzin nechmactij nijín tatiochihualis tech nijín tonalme huan nechyolicnelij para ma ijcón in tagayot nechmohuiscapohuacan”. ");
INSERT INTO azzNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Huan ipan chicuasen metztica cuac in Elisabet mopilcuic ya, ijcuacón Totajtzin Dios cualtitanic itaquehual ángel Gabriel tech se pueblo ten monotza Nazaret ten itatitalanal de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Huan Dios cualtitanic Gabriel ma quicalpanoqui huan ma quinojnotzaqui se suapil ten monotza María ten ayamo ihuan se tagat sen yetoya. Huan nijín María ipa yetoya tajtol ya para ihuan monamictis se tagat ten monotza José. Huan ne José pohuía ihuan ichancahuan den ne huejcaurey David. ");
INSERT INTO azzNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Huan ijcón in ángel yajqui huan calaquito campa yetoya María huan quilij ijcuín: ―Nimitztajpaloqui, tejua ten Totajtzin Dios semi mitzyolicnelij ya. Huan Totecotzin mohuantzin yetica. Huan Totajtzin Dios cachi oc mitztiochiutinemis huan que in ocsequi sihuame. ");
INSERT INTO azzNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Huan cuac in María quitac in ángel, ijcuacón yejua semi moyolmoutij huan moyoltajtoltiaya de toni quijtosnequi nijín netajpalolis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ijcuacón in ángel quiluij ijcuín: ―Tejua María, amo ximoyolmouti porín Totajtzin Dios semi mitzyolicnelijtihuitz ya. ");
INSERT INTO azzNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Axcan timopilcuis huan ticyolitis se oquichpil huan tictocaytis moconeu Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Huan moconeu yesqui hueyi chiuque huan in tagayot quipohuasque huan quitocaytisque nijín conetzin que Yejuatzin iconeu de Totajtzin Dios in cachi hueyi chiuque. Huan no Totajtzin Dios ten Totecotzin, Yejuatzin quichihualtis que in Jesús Temaquixtijque ma quipía huelilis de rey, ijcón queme in tayecancatat David tequitía cuac catca rey. ");
INSERT INTO azzNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Huan ne Jesús Temaquixtijque, Yejuatzin ya ne quinyecantinemis in pueblojuani de Israel sen nachipa. Huan in chicaucahuelilis de Jesús Temaquixtijque amo queman cuetahuis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ijcuacón in María quitajtoltij in ángel ijcuín: ―Huan nijín, ¿queniu huelis nicpías se conetzin? Ta, nejua ayamo nicpía noyoquich. ");
INSERT INTO azzNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ijcuacón in ángel quinanquilij ijcuín: ―Huan nijín, Yejuatzin in Yecticatzin Espíritu hualas tequitiquiu moyolijtic. Huan ijcón Totajtzin Dios ten cachi hueyi chiuque, Yejuatzin hualas mitzyehualoltiquiu ica nichicahualis. Ica ya nojón moconetzin ten yoliquiu, yejua ne quipohuasque Yolchipactzin huan no quitocaytisque que Yejuatzin Iconetzin de Dios porín ipa ya melau Yolchipahuactzin. ");
INSERT INTO azzNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Huan no nimitzilía que ne moprima Elisabet no mopilcuic ya, masqui yejua semi nanajtzin ya. Huan axcan yejua quipía chicuasen metztica ya de mopilcuic, masqui quijtoayaj que amo queman huelisquía quipiasque se conetzin. ");
INSERT INTO azzNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Huan nochi nijín mochiutiu porín Totajtzin Dios nochi hueli quichihua, huan amo teyi ongac ten ma amo huelis quichihuas Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ijcuacón in María quilij in ángel ijcuín: ―Cuali yetoc, nejua niitequiticau de Totecotzin. Huan ma Dios quichiutica notechcacopaca nochi ten Tejuatzin tinechonilijtoc. Huan de ompa in ángel quistehuac. ");
INSERT INTO azzNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Huan tech nojón tonalme in María niman yajqui tech se pueblo campa tepeyo tech se pueblo de itatilanal Judea. ");
INSERT INTO azzNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Huan ijcón cuac ajsic ichan Zacarías, ijcuacón María calaquito calijtic huan quitajpaloj ne iprima Elisabet. ");
INSERT INTO azzNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Huan cuac in Elisabet quicayic que in María quinaltajpaloto ya, ijcuacón in conetzin de Elisabet sepa san moolinij ne ijticpa. Huan ijcón Dios quiyolpepexocaltij Elisabet ica in chicahualis den Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Huan ijcón in Elisabet moyoluelitac huan chicaucatajtoaya ijcuín: ―Totajtzin Dios cachi oc mitztiochihuac ya huan que nochi ocsequin sihuatzitzin. Huan ne Totajtzin Dios quitiochihuac moconetzin ten ticpixtoc ya. ");
INSERT INTO azzNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Huan nicmoucaita que tejuatzin tionuala tinechoncalpanoco porín nicmati que tejua tiinan de Notecotzin Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Huan niman cuac nicayic tinechtajpaloco ya, ijcuacón noconetzin moolinij noijticpa porín moyoluelitac. ");
INSERT INTO azzNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Huan, tejua María, tiyolpactoc porín ticajsicaneltocac ne tajtolis ten mitziluij ne ángel. Huan nochi nijín quipía que motamichihuas, ijcón queme quijtoj ya Totecotzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ijcuacón in María tananquilij ijcuín: Ica nochi notalnamiquilis nicueyichihua Notecotzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Huan noyolo mohuelita porín Totajtzin Dios, Yejuatzin Notemaquixtijcatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Huan Totajtzin Dios nechyolicnelij masqui nejua nitetequitilijque san. Huan desde axcan para taixpan nochi in talticpacuani de nochi tonalme, nochi yejuan nechpoutinemisque que nitatiochihual de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Huan nechilijtinemisque que nitatiochihual de Dios porín Yejuatzin ya quipixtinemi huelilis. Ica ya nojón Yejuatzin quichiutinemi huejueyi chihualis noyolijtic. Huan Yejuatzin in Yolchipahuactzin. ");
INSERT INTO azzNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Huan Totajtzin Dios nachipa quinyolicnelijtihuitz nochi neques ten quimohuistilijtinemij Dios huan Yejuatzin cachi oc quinyolicnelijtiu. ");
INSERT INTO azzNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Huan Yejuatzin quichihuaco huejueyi chihualisme ica por ihueyichicahualis. Huan no Yejuatzin quinmomoyahuac ne taixnamiquini neques ten moyolueyimatinemíaj ica nintamachilis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Huan Totajtzin quinajchihuac in huejueyi chihuanime de ninuelilispan. Huan no quinueyipantalij neques ten amo semi mohueyimatinemij tech nintamachilis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Huan Yejuatzin quintayocolij míac tenesi para ica huelis moixpanoltisque nochi neques ten mayantinemij. Huan nochin in taca rijcome Yejuatzin quincau ma yacan iuque. ");
INSERT INTO azzNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Huan Totajtzin Dios quinpalehuij in pueblojuani Israel, yejuan itequiticahuan de Dios. Huan Dios amo queman quinelcahuaya de quinyolicnelis ne itequiticahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Huan Dios amo no queman quelcahuas de ne netenilil tenica moyectencahuac para sen nachipa ihuan ne tohuejcautat in Abraham huan nichancahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Huan ijcón in María mocahuac ichan Elisabet ipan queme eyi metztica. Huan de ompa in María mocuepac huan yajqui ichan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Huan cuac ajsic ya in tonalme cuac monequis monextis ica pili, ijcuacón Elisabet quiyolitij se oquichpilconet. ");
INSERT INTO azzNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Huan ne Elisabet ichancahuan huan iparientes, cuac yejuan quitecaquilijque de queniu Dios quiyolicnelij Elisabet, ijcuacón yejuan yajque quicalpanotoj para ihuan moyolpactisque. ");
INSERT INTO azzNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Huan mochihuac que ipan chicueyi tonal cuiyacque in oquichpilconet para ma quinescayotican tech ninacayo. Huan quinequíaj quitocaytisque in oquichpil ica in tocay Zacarías, ijcón queme ipapá. ");
INSERT INTO azzNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Pero in Elisabet quinilij ijcuín: ―Amo ijcón ticnotzasque. Ta, ticnequij nijín tictocaytisque Juan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ijcuacón ichancahuan quitajtoltijque ijcuín: ―¿Queniu ijcón ma motocayti in oquichpil? Ta, amo aquen mochancahuan ma ijcón monotza. ");
INSERT INTO azzNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Huan ijcón quitajtoltijque Zacarías ica nescayot san de ninmahuan para huelis quimatisquíaj toni tocay quinequi quitalilis ne ioquichpil. ");
INSERT INTO azzNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ijcuacón in Zacarías tajtanic ica nescayot se cuoutzin campa huelis tajcuilos huan quijcuiloj ijcuín: “Nitocay nijín nooquichpil yesqui Juan”. Ijcuacón nochi ninchancahuan quimoucaitacque nochi ten mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Huan tech nojón momento Totajtzin Dios quitentapoj Zacarías huan quitojtomilij ninenepil. Huan ijcón Zacarías pehuac tajtoa huan quimohuistilía in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Huan cuac quitacque ya nochi nijín, ijcuacón nochi ninchancahuan cachi oc mohueyiyolmoutiayaj. Huan nochi in pueblojuani campa tejtepeyo de itatilanalcopaca de Judea motetapohuiayaj nochi nijín ten mochihuaco inchan in Zacarías. ");
INSERT INTO azzNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Huan nochi nojón calyetoni ten quitecaquiliayaj de toni mochihuac, yejuan nojón peuque quiyolnemilijtinemíaj huan motajtoltijtinemíaj se huan ocsé ijcuín: ―¿Toni chiuque mochihuaquiu nijín oquichpil? Porín hueyi melau in Totecotzin Dios quihueyitiochihuac ya ica ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Huan Totajtzin Dios quiyolpepexocaltij in Zacarías ica in Yecticatzin Espíritu. Huan ijcón in Zacarías tajtoaya ica nijín tajtolme ten Totajtzin Dios quimactilij huan quijtoaya ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Ma ticueyichihuacan Totecotzin, Yejuatzin in Dios den pueblojuani de Israel, porín Yejuatzin huala ya techpalehuico huan techmaquixtico tejuan tiipueblojcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Huan Totajtzin Dios quichihuac ma moscaltiqui se Temaquixtijque ten quipía nochi huelilis. Huan nijín Temaquixtijque hualehuac intzalan de neichancahuan de ne huejcaurey David. ");
INSERT INTO azzNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Huan ijcón Totajtzin Dios moyectencauca ya de techmaquixtis cuac technojnotzaya intencopaca de ne huejcau mohuiscatanahuatiani. ");
INSERT INTO azzNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Huan ne huejcau tanahuatiani techiliayaj que Totajtzin Dios techmaquixtis inmaco neques ten techixnamictinemij huan Yejuatzin no techsecotalis de neques ten techtahuelitztinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Huan no Totajtzin Dios techyolicnelijtiu porín Yejuatzin quelnamiquis ne netenilil tenica moyectencauca ya ihuan tohuejcatatuan de quichihuas. ");
INSERT INTO azzNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Huan tech nojón tonalme Totajtzin Dios moyectencahuac ihuan tohuejcautat Abraham de que techualtitanilis se Totemaquixtijcatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Huan no Totajtzin Dios moyectencahuac de que techajchihuas inmaco neques ten techtahuelitztinemij para ijcón huelis tejuan tictequitilijtinemisque Dios huan amo timomoutijtinemisque. ");
INSERT INTO azzNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Huan ijcón tictequitilijtinemisque Totajtzin Dios huan tichipaucanentinemisque iixpantzinco Dios ica neyolchipahualis tech nochi tonemilispan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Huan tejua Juan, tinoconetzin, mitztocaytijtinemisque titanahuatijque de Totajtzin Dios ten cachi hueyi chiuque. Huan nijín ijcón mitzilisque porín tejua titanojnotztinemi ya achtopa que Cristo hualas para ijcón tiquinyolyemaniti in topueblojcahuan para huelis taneltocasque de Cristo. ");
INSERT INTO azzNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Huan tejua Juan, tiquinyecajsicamatiltis mopueblojcahuan de queniu Totajtzin Dios quinmaquixtis huan quintapojpoluis den nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Huan Totajtzin Dios techyoltasojta huan techyolicnelía. Ica ya nojón hualehuac desde ne eluiyactzinco se Temaquixtijque huan tahuiquiu ijcón queme tiquitaj cuac panquisa in tonaltzin ica chicahuac imeyoyo. ");
INSERT INTO azzNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Huan ne Temaquixtijque techualcuilía in tanextzin den Totajtzin Dios para quinyoltahuilis neques ten yolmictinemij tech ne tayohuayanilot ten cualcui tajtacol. Huan no quinmaquixtiquiu neques ten in miquilis quinyecahuiltijtoc ica moucayot. Huan no hualas para techmetzyecantiyás tech ne ojti campa ongac yolsehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Huan ijcón ne oquichpilconet Juan moijsiucaiscaltijtiaya huan moyolchicahualtijtiaya. Huan in Juan yajqui yetoto campa taiucan san hasta in tonalme cuac ocsepa mocuepac huan yetoto intzalan in pueblojuani de Israel para pehuas nitanojnotzalis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Huan tech nojón tonalme mochihuac que in cachi hueyi chiuque de Roma ten quilíaj emperador Augusto César, yejua quintanahuatilij in ocsequin tequihuani ma quinpohuacan nochi in talticpacuani para ijcón huelis quintopaluisque. ");
INSERT INTO azzNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Huan ijcón quintayecancapouque in tagayot de Siria den itatilanal den Roma, cuac ne tonal yetoya in tequihua Cirenio quinyecantinemía Siriajcopacahuani. ");
INSERT INTO azzNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Huan ijcón monequía que nochi in talticpacuani mocuepasque huan yasque tech ninpueblojuan campa yolque ninuejcautatuan para ompa no yesque tapoucayome. ");
INSERT INTO azzNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Ica ya nojón in José quisac den pueblo Nazaret de itatilanal Galilea huan yajqui campa pueblo de Belén, huan de itatilanal Judeajcopaca campa yolicoj ne ihuejcautatuan de quilíaj rey David. Huan ijcón quichihuac José porín yejua pohuía ihuan ichancahuan de ne huejcau rey David. ");
INSERT INTO azzNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Huan ijcón José yajqui Belén para ompa yesqui tapoucayot. Huan no quisehuicaya isihuatzin María ten ipa yetoc tajtol ya que ihuan monamictis. Huan ne María cocoxcayetoya ya ica pili. ");
INSERT INTO azzNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Huan mochihuac cuac yetoyaj ya tech ne pueblo de Belén, ijcuacón ejcoc in tonal cuac in María monequía tayolitis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Huan ijcón in María quiyolitij itayecancaoquichpil huan quitetziloj ica sequi pilcueyit huan quicuategac tech in pesebre campa ne tacuaj tapialme. Huan nijín ijcón quichiuque porín amo cana tacautoya tech mesón para ompa mosehuisque. ");
INSERT INTO azzNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Huan amo huejca de Belén ompa yetoyaj sequin tapiani ten tatacualtijtinemíaj ica ninichcahuan huan quipanoayaj in yohual tech nojón ixtahuat. ");
INSERT INTO azzNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Huan santajma monextijtihuetzico se ángel taquehual de Totecotzin huan icualtziyo de Totecotzin quinmeyotico huan quinyehualoco ne tapiani. Ica ya nojón in tapiani mohueyiyolmoutijque. ");
INSERT INTO azzNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero in ángel quinilij ijcuín: ―Amo ximoyolmoutican porín nejua namechualcuilía se cualtzin tanejmachtilis ten quinueyiyolpactis nochi in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Huan in tanejmachtilis yejua nijín que axcan tech nijín yohual yolico ya se pili. Huan yejua ne mochihuas namotemaquixtijcau huan yejua itocay Totecotzin Cristo. Huan Yejuatzin yolic ya tech in pueblo de Belén campa pohuij ichancahuan de ne huejcau rey David. ");
INSERT INTO azzNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Huan nanquitasque que nochi nijín ten namechilijtoc hueyi melau porín cuac nanyasque nancalpanotihue ya, ijcuacón melau nanquitasque in conetzin tetziliutoc ica sequi pilcueyit huan huetztica tech se pesebre campa tacuaj tapialme. ");
INSERT INTO azzNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Huan santajma monextijtihuetzicoj tel miacque ne ocsequin ángeles de Dios den hualeuque ne eluiyactzinco. Huan nochi nojón ángeleme peuque quihueyimohuistilíaj Totajtzin Dios huan quijtoayaj ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Ticueyimohuistilíaj Totajtzin Dios ten yetica nepa eluiyatzinco. Huan nican in talticpacuani quipixtinemisque neyolsehuilis ihuan Dios huan ihuan ninchancahuan porín yejuan quiyolpactijtinemisque Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Huan cuac in ángeles mocuepque ya huan yajque ya eluiyactzinco, ijcuacón in tapiani peuque moiliayaj se huan ocsé ijcuín: ―Tiyohue Beléncopaca huan ompa tiquitasque toni mochihuac. Porín Totecotzin Dios techualtitanilij ya nijín ángeles para yejuan techmatilticoj de toni mochiutoc. ");
INSERT INTO azzNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Huan ijcón quichiuque in tapiani ijsiucayajque tech ne pueblo de Belén huan ajsicque campa yetoya in María huan José. Huan ompa quitacque in oquichpilconet Jesús huetztoc tech in pesebre campa tacuaj in tapialme. ");
INSERT INTO azzNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Huan cuac in tapiani quitacque ya in conetzin, ijcuacón yejuan quintapohuíaj María huan José den nochi tanejmachtilis ten in ángeles quiniliayaj de ne oquichpilconet Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Huan nochi in tagayot ten quitecaquilíaj nijín tanejmachtilis, yejuan quihueyimoucaitayaj den quijtoayaj in tapiani. ");
INSERT INTO azzNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Huan ijcón in María quiyolelnamiquía nochi in tajtolme den tapiani huan yoltanemiliaya ica nojón tajtolme. ");
INSERT INTO azzNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Huan de ompa in tapiani quisteuque huan yajque campa yetoyaj. Huan yejuan quihueyimohuistilijtiyayaj huan quihueyipanchiutiyayaj Totajtzin Dios ica por nochi ne ten quicacque huan quitacque. Huan no quitasojcamachiliayaj Dios porín nochi mochihuaco ijcón queme quiniluicaj ya. ");
INSERT INTO azzNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Huan ipan chicueyica cuiyacque in oquichpilconet Jesús para quinescayotisque tech ninacayo, huan ompa quitocaytijque in conetzin Jesús. Huan quitocaytijque ijcón queme in ángel quinahuatijca María ne achtopaca ya que mopilcuis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Huan ajsicque ya in tonalme cuac in María mochipahuac ya den tayolitij. Huan yejua quichihuato ijcón queme tenahuatilía in tanahuatil de Moisés. Huan ijcón yejuan yajque Jerusalén cuiyacque in oquichpil Jesús campa hueyi tiopan para quitenextilisque huan quitemactisque in oquichpil inahuactzinco Totecotzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Huan nochi nijín quichiuque porín ijcón ijcuiliutoc tech in Tajcuilolamatzin de Totecotzin Dios ijcuín: “Nochi tayecancaoquichpilme ten yolisque, yejuan nojonques ma quitemactican imaco Totecotzin”. ");
INSERT INTO azzNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Huan no yajqui campa ne hueyi tiopan de judíos para ompa quimactilisque Dios sequin nemactil ijcón queme in tanahuatil den Totecotzin Dios quitenahuatilía in taca pobres ijcuín: “Ma quimactilican Dios ome tototzitzin, yesque tórtolas oso palomas”. ");
INSERT INTO azzNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Huan tech nijín tonalme nemía se tagat ten monotzaya Simeón tech in pueblo de Jerusalén. Huan nojón tagat catca semi yolchipaucatagat huan ipa quimohuistilijtinemía Dios. Huan yejua quiyecajsicachiayaj ipa ca tacuautamatilis que hualas in Cristo Temaquixtijque para quinyolsehuiquiu ica ne nemaquixtilis ipueblojcahuan de Israel. Huan in Yecticatzin Espíritu yetoya iyolijtic in Simeón. ");
INSERT INTO azzNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Huan ne Yecticatzin Espíritu quimatiltij ne Simeón que yejua ayamo miquis como amo achto quitas Cristo Temaquixtijque, ten Totajtzin Dios cualtitanis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Huan in Simeón yajqui ne tiopanijtic porín in Yecticatzin Espíritu quiyecanaya. Huan in María huan José cuiyacque in oquichpil Jesús campa hueyi tiopan de Judíos para ompa quitamichihuasque nochi ten in tanahuatil de Moisés quitenahuatilía. ");
INSERT INTO azzNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Huan cuac in Simeón quitac ya in oquichpil Jesús, ijcuacón yejua monapaloltij huan pehuac quimohuistilía Dios huan quijtoaya ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Notecotzin, axcan huelis xinechcahua ya ma nimiqui ica hueyi yolsehuilis porín axcan Tejuatzin ticontamichihuac ya nochi ne ten tionmoyectencauca ya nohuan de monequía niquitas. ");
INSERT INTO azzNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Axcan melau nicyequitac ya ica noixtololohuan in Jesús Temaquixtijque ten Tejuatzin titechonualtitanilij para titechmaquixtis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Huan Tejuatzin tiquijitac nijín Jesús Temaquixtijque para quinmaquixtis nochi in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Huan nijín Jesús Temaquixtijque, Yejuatzin se tanextzin para quinyoltahuilis ica in Tajtoltzin de Dios neques ten amo poutinemij queme judíos. Huan no Jesús Temaquixtijque techueyipanchihuas tejuan den timopueblojcahuan de Israel. ");
INSERT INTO azzNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ijcuacón in José huan in María inan Jesús, yejuan nojonques quimoucacaquíaj in tajtolme ten quijtoaya Simeón cuac yejua tajtoaya de nojón conetzin Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Huan ijcón in Simeón motatatautilij que ma Dios quintiochihua. Huan de ompa Simeón quilij María yejua inan de Jesús ijcuín: ―Xiquitacan que ica por nijín oquichpil Jesús, Dios quitalij que miacque pueblojuani de Israel ixpolihuisque porín amo tacuautamatisque ihuan Yejuatzin. Huan no miacque pueblojuani de Israel maquisasque porín tacuautamatisque ihuan nijín Jesús. Huan nijín Jesús quinmachtijtinemis in pueblojuani Israel pero miacque quimohuispolosque itamachtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Huan nijín Jesús tamachtijtinemis para ijcón ixnesiquiu itamachilisuan de cada se tacaquini. Huan tejua María, nimitzilía que nochi nijín ipan huetziquiu Jesús, huan tejua queme yesquía se machete panosquía moyolijtic para ijcón mitztajyohuiltis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Huan no ompa tiopanijtic yetoya se sihuatzin ten monotzaya Ana, yejua tajtoaya ica tanahuatil ten Dios quimactiliaya. Huan nojón Ana yejua catca ishuapiltzin den tetat Fanuel huan pohuía ihuan ichancahuan de ne huejcautetatme ten monotzaya Aser. Huan in Ana catca semi nanajtzin ya huan monamictijca ya cuac semi sihuapil oc huan yejua ihuan yetoya iyoquich sayó chicome xiutica. ");
INSERT INTO azzNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Huan axcan in Ana yejua se sihuacahual ya huan quipiaya nahuipoal huan nahui xihuit. Huan in Ana amo queman quisaya tech ne hueyi tiopan de judíos. Ta, quitequitilía Totajtzin Dios yohual itonal ica ne nesahualis huan ica inetatatautilis ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Huan cuac Simeón quinnojnotzac oc, ijcuacón in Ana motoquito inixpan. Huan yejua quitasojcamachilij ya Dios porín quinualtitanilij ya nijín oquichpil Jesús queme Temaquixtijque. Huan de ompa Ana quinnojnotzato den oquichpil Jesús nochi in pueblojuani de Jerusalén neques ten quichixtoyaj ma mohualuicas Cristo para quinmaquixtis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Huan satepan cuac quitamichiuque ya nochi ten quitenahuatilía in tanahuatil de Moisés, ijcuacón José huan María mocuepque huan yajque Galileajcopaca huan ajsique tech ninpueblo de Nazaret. ");
INSERT INTO azzNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Huan ompa Nazaret in oquichpil Jesús moscaltiaya huan cachi oc mochicahualtiaya huan no cachi oc cuatamatiaya. Huan ijcón Totajtzin Dios quihueyitiochihuaya mosta. ");
INSERT INTO azzNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Huan ipapajuan de Jesús ipa yayaj cada se xihuit tech ne pueblo de Jerusalén para iluititihue tech nojón tajyohuilis iluit. ");
INSERT INTO azzNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Huan cuac in oquichpil Jesús quipiaya ya majtactiomome xihuit, yejua ihuan nochi ichancahuan yajque campa pueblo Jerusalén. Ompa yajque iluititoj para ijcón motenextilisque inahuactzinco Totajtzin Dios, ijcón queme mohuicatinemíaj ne pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Huan cuac taluitamic ya, ijcuacón nochi ichancahuan de Jesús mocuepque huan yajque inchancopaca. Pero mochihuac que ne oquichpil Jesús mocahuato tech in pueblo Jerusalén. Huan in José huan inan Jesús amo momacacque cuenta que cox mocahuac oc in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Huan in José huan María quinyolnemiliayaj que xa in oquichpil Jesús quinualtoctiliaya intzalan in tagayot ten inuan hualayaj. Huan ijcón yejuan nejnenque se tonal ya huan yejuan amo quimatía que cox amo yetoya in oquichpil Jesús. Huan de ompa peuque quitemoayaj Jesús intzalan nochi inchancahuan huan naquen inuan moixmatque. ");
INSERT INTO azzNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Huan queme amo cajsique in oquichpil Jesús, ijcuacón José huan María ocsepa mocuepteuque para quitemosque nepa Jerusaléncopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Huan ipan eyi tonal de quitemojtinemíaj ya in Jesús, ijcuacón cajsique in oquichpil tocotzyetoc ne campa hueyi tiopanijtic intzalan ne tanextiliani den tanahuatil de Moisés. Huan in oquichpil Jesús quincaquiliaya nintajtol de ne tanextiliani huan no quintatajtoltiaya de toni quijtosnequi nintamachtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Huan nochi in tanextiliani ten quicaquiliayaj in Jesús, yejuan nojónques quimoucacaquíaj de queniu in oquichpil Jesús niman quinajsicamatiliaya ne tanextiliani. Huan no quimoucaitayaj de queniu Jesús quinnanquiliayaj cuac quitajtoltiayaj tensá matájtanti. ");
INSERT INTO azzNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Huan cuac itatuan de ne oquichpil Jesús quitacque ya de toni quichiutoya, ijcuacón yejuan quihueyimoucaitayaj. Ijcuacón inan de Jesús quilij ijcuín: ―Noconetzin, ¿queyé ijcón titechchihuac de amo titechilij can timocahuas? Porín motat huan nejua semi timoyolcuejmolojtinemij de timitztemojtihuitze. ");
INSERT INTO azzNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ijcuacón in oquichpil Jesús quinnanquilij ijcuín: ―¿Queyé ay nannechtemojtinemij? ¿Xe amo nanquelnamiquij que nejua nicpía de nimotequitilis tech in tanextililis de Notajtzin Dios? ");
INSERT INTO azzNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Pero itatuan de Jesús amo cajsicamatque queyé ijcón quinanquilij. ");
INSERT INTO azzNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Huan ijcón in oquichpil Jesús mocuepac ocsepa huan yajqui Nazaret inuan itatuan. Huan ijcón in oquichpil Jesús quisentocaya quintacamatiaya itatuan. Huan ijcón inan den oquichpil quiyolelnamiquía nochi nijín tajtolme huan no yoltanemiliaya de toni quijtosnequía. ");
INSERT INTO azzNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Huan in oquichpil moscaltiaya ca míac chicahualis huan no cachi oc moyolmajxitiyá. Huan Totajtzin Dios moyolpactiaya ica por Jesús huan nochi in tagayot quicualtagaitayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Huan tech nojón xihuit cuac quichihuac ya caxtol xihuit de tayecantinemi in cachi hueyi chiuque de Roma den quilíaj emperador Tiberio César, ijcuacón in tequihua ten tayecantinemía campa Judeajcopaca, yejua in Poncio Pilato. Huan in Herodes tayecantinemic ne Galileajcopaca. Huan Felipe, yejua icniu de Herodes, tayecantinemía campa Iturea huan Traconite. Huan in Lisanias tayecantinemía ne Abiliniajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Huan tech nojón xihuit in Anás huan Caifás, yejuan nojonques catcaj in cachi huejueyi tiopixcame tech in hueyi tiopan de Jerusalén. Huan Juan, yejua catca teconeu de Zacarías, huan yejua yetoya oc campa ne tayiucan. Huan tech nojón tonalme Totajtzin Dios quimactilij in Juan Taahuijque se tanahuatil tenica tanojnotztinemis. ");
INSERT INTO azzNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Huan ijcón in Juan panotiaya nochi in pueblojme ten atencopaca calyetoya den hueyíat Jordán huan quinmachtiaya in pueblojuani ijcuín: ―Monequi ximoyolnemilican de namotajtacoluan para ijcón Totajtzin Dios namechtapojpoluis de namotajtacoluan. Huan no monequi ma namechahuijcan. ");
INSERT INTO azzNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Isaías yejua itanahuatijcau de Dios ten quijcuilojca de nijín Juan Taahuijque cuac quijtojca nijín tajtolme ijcuín: Mocaquiti se tagat ten tanajnahuatía campa tayiucan huan quijtoj ijcuín: “Xitayectalijtiyacan ninemilispan de Totecotzin huan xicmejmelautiyacan niojuan campa hualpanotihualas. ");
INSERT INTO azzNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Huan xicautiyacan namotajtacoluan para ijcón nanyesque nanyolmelauque ijcón queme yesquía se melaucaojti. Huan campa tajtahuitomil, ma ixtemiqui. Huan no campa nochi tepeyo huan tal lomojme, ma no tamelaucatalican. Huan campa ojquelpachme, ma momejmelahuacan. Huan campa ojme de talcuejcuencan, ma momejmelahuacan, para ijcón huelis hual panotihualas Totecotzin. ");
INSERT INTO azzNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Huan como ijcón nanquichihuaj, ijcuacón nochi in talticpacuani quitasque in Temaquixtijque ten Totajtzin Dios cualtitanic”. ");
INSERT INTO azzNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Huan in Juan Taahuijque quinahuía huel míac tagayot neques ten yajque concaquiliayaj itanojnotzalis. Huan in Juan quiniliaya ijcuín: ―Namejuan nantacajcayahuani san queme in cohuame. ¿Aconi namejuan namechnejmachtij que huelis nanmocholotisque de ne hueyi tatzacuiltilis ten motoquijtoc ya? ");
INSERT INTO azzNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Huan namechilía que xicyecchipaucanemican para ijcón ma mota senteixteno que melau nanmoyolnemilijque de namotajtacoluan. Huan amo xicyolnemilijtiyacan que Dios amo namechtatzacuiltis como nanquijtoaj nijín tajtolme: “Tejuan titeixuihuan de ne huejcau tetat Abraham”. Porín xicmatican que amo teyica namechpalehuis ica nojón tajtolme. Porín namechyequilía que ica nijín teme no cuali huelis in Totajtzin Dios quinchijchihuas teixuihuan de Abraham ten tacuautamatinemij ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Huan como amo nanmoyolnemilíaj de namotajtacoluan, ijcuacón namejuan nanyesque queme cuoume, ten amo teyi taquij ten quimayohuisque ica hacha hasta ca nochi ninnaluayohuan. Huan nochi cuoume ten amo quitemaca taquilot ten cuali, in tequitini quinnaluayojtequisque huan quitamotasque tech in tit ma chichinahui. ");
INSERT INTO azzNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ijcuacón in tacaquini quitajtoltiayaj Juan ijcuín: ―Pos, ¿toni monequi ma ticchihuacan para timomaquixtisque? ");
INSERT INTO azzNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ijcuacón in Juan quinanquilij ijcuín: ―Ne ten quipía ome camisa, ma quitayocoli se camisa ne ten amo semi teyi quipía. Huan ne naquen quipía ten cuasque, yejuan ne monequi ma quitayocolican tacualis ne ten amo teyi quipía. ");
INSERT INTO azzNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Huan no mochihuac que motoquijque campa yetoya Juan sequin tatopaluiani para ma in Juan quinahui. Pero nojón tatopaluiani quitajtoltiayaj Juan ijcuín: ―Tejuatzin tamachtijque, ¿toni monequi ticchihuasque no tejuan ten titatopaluiani? ");
INSERT INTO azzNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ijcuacón in Juan quinnanquilij ijcuín: ―Monequi que namejuan amo semi xiquinueyitopaluican in tagayot cachi oc huan que ne ten quitenahuatilíaj in tequihuani. ");
INSERT INTO azzNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Huan no motoquijque campa Juan yetoya sequin soldados huan quitajtoltijque Juan ijcuín: ―Huan tejuan tisoldados, ¿toni monequi ticchiutinemisque para timomaquixtisque? Ijcuacón in Juan quinnanquilij ijcuín: ―Amo teyi ica xiquinxijxicocan huan xiquincuilican tensá ne acsame. Huan amo no xiquinteluilican acsame ica tacajcayahualis para ijcón quinquixtilisque tomin. Ta, namechilía ximoyolpactican ica ne taxtahuil ten namechmactilíaj. ");
INSERT INTO azzNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Huan queme in pueblojuani ipa quichixtihuitze que hualas in Cristo Temaquixtijque, ica ya nojón yejuan moyoliliayaj se huan ocsé que ne Juan Taahuijque xa yejua ya in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Pero in Juan quinajsicamatilij nochi in tagayot ijcuín: ―Huan nejua de yec melau namechahuij ica at san. Pero hualajtoc se naquen cachi quipía huelilis huan nejua niamoteyi nichiuque. Huan amo nechnamiqui nictojtomilis ne imetzuijconca de nitegacuan. Huan ne Yejuatzin namechquemilos huan namechyolpepexocaltis ica in Yecticatzin Espíritu huan no namechyolchipahuas de namotajtacoluan ijcón queme in tit quichipahua tensá. ");
INSERT INTO azzNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Huan ne Temaquixtijque quichihuati ijcón queme tejuan ticchihuaj cuac ticchipahuaj in trigojtet ica ne tapipitzaloni. Huan ticololoaj in trigojtet huan tiquehuaj campa trigojcal huan in tajsol ticchichinoaj. Huan tejuan como titacuautamatij ihuan ne Temaquixtijque, ijcuacón Yejuatzin techsepantalía ihuantzin seco san. Huan neques ten amo tacuautamatij ihuatzin, yejuan nojonques quintamotasque campa tatzacuiltilis de tit de amo queman sehuis. ");
INSERT INTO azzNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Huan ica nijín tanojnotzalis in Juan quinyolmajxitiaya in tagayot huan no quinmatiltiaya den cuali Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Huan in Juan Taahuijque quimejmelahuilijca ya de toni quichiutoya in tequihua Herodes porín yejua quipoutoya queme isihuau icuñada Herodías ne ten isihuau Felipe. Ica ya nojón Juan quimejmelahuilijca Herodes, porín Felipe huan Herodes icnime san. Huan no Juan cachi oc quimachililtij Herodes que semi hueyi tajtacol porín itajtacoluan ten quichiutihuala. ");
INSERT INTO azzNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pero ne tequihua Herodes amo quicaquiliaya de toni quiliaya in Juan. Ta, ne Herodes cachi oc motajtacolmacaya huan quichihuaya que ma quicárceltalican in Juan. ");
INSERT INTO azzNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Huan mochihuac que cuac nochi in pueblojuani moteahuiltijtoyaj ya imaco in Juan, ijcuacón no in Jesús Temaquixtijque yajqui moteahuiltito imaco Juan. Huan cuac Jesús Temaquixtijque motatatautiliaya ihuan Dios, ijcuacón niman tatapohuic tech ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Huan ijcón in Yecticatzin Espíritu hual temoaya den eluiyactzinco ijcón queme yesquía se tototzin paloma huan calayic itech Jesús. Huan no mocaquic se tajtolis den eluiyactzinco ten Yejuatzin quijtoaya ijcuín: ―Tejua tinotasojconetzin, ica por Tejuatzin semi nimoyolpaquiltía axcan. ");
INSERT INTO azzNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Huan in Jesús Temaquixtijque quipiaya queme sempoal huan májtacti xihuit cuac quitzinpehualtij nitequiu. Huan in pueblojuani de Nazaret quinyolnemiliayaj que Jesús catca iconeu in José. Huan ijcón in José catca iconeu de Elí. ");
INSERT INTO azzNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Huan Elí catca iconeu de Matat. Huan in Matat catca iconeu de Leví. Huan in Leví catca iconeu de Melqui. Huan in Melqui catca iconeu de Jana. Huan in Jana catca iconeu de José. ");
INSERT INTO azzNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Huan in José catca iconeu de Matatías. Huan in Matatías catca iconeu de Amós. Huan Amós catca iconeu de Nahum. Huan in Nahum catca iconeu de Esli. Huan in Esli catca iconeu de Nagai. ");
INSERT INTO azzNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Huan in Nagai catca iconeu de Maat. Huan in Maat catca iconeu de Matatías. Huan in Matatías catca iconeu de Semei. Huan in Semei catca iconeu de José. Huan in José catca iconeu de Judá. ");
INSERT INTO azzNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Huan in Judá catca iconeu de Joana. Huan in Joana catca iconeu de Resa. Huan in Resa catca iconeu de Zorobabel. Huan in Zorobabel catca iconeu Salatiel. Huan in Salatiel catca iconeu de Neri. Huan in Neri catca iconeu de Melqui. ");
INSERT INTO azzNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Huan in Melqui catca iconeu de Adi. Huan in Adi catca ijcóneu de Cosam. Huan in Cosam catca iconeu de Elmodam. Huan in Elmodam catca iconeu de Er. ");
INSERT INTO azzNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Huan in Er catca iconeu de Josué. Huan in Josué catca iconeu de Eliezar. Huan in Eliezar catca iconeu de Jorim. Huan in Jorim catca iconeu de Matat. ");
INSERT INTO azzNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Huan in Matat catca iconeu de Leví. Huan in Leví catca iconeu de Simeón. Huan in Simeón catca iconeu de Judá. Huan in Judá catca iconeu José. Huan in José catca iconeu de Jonán. Huan in Jonán catca iconeu de Eliaquim. ");
INSERT INTO azzNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Huan in Eliaquim catca iconeu de Melea. Huan in Melea catca iconeu de Mainán. Huan in Mainán catca iconeu de Matata. Huan in Matata catca iconeu Natán. ");
INSERT INTO azzNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Huan in Natán catca iconeu de David. Huan in David catca iconeu de Isaí. Huan in Isaí catca iconeu de Obed. Huan in Obed catca iconeu de Booz. Huan in Booz catca iconeu de Salmón. Huan in Salmón catca iconeu de Naasón. ");
INSERT INTO azzNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Huan in Naasón catca iconeu de Aminadab. Huan in Aminadab catca iconeu de Aram. Huan in Aram catca iconeu de Esrom. Huan in Esrom catca iconeu de Fares. Huan in Fares catca iconeu de Judá. ");
INSERT INTO azzNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Huan in Judá catca iconeu de Jacob. Huan in Jacob catca iconeu de Isaac. Huan in Isaac catca iconeu de Abraham. Huan in Abraham catca iconeu in de Taré. Huan in Taré catca iconeu de Nacor. ");
INSERT INTO azzNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Huan in Nacor catca iconeu de Serug. Huan in Serug catca iconeu de Ragau. Huan in Ragau catca iconeu de Peleg. Huan in Peleg catca iconeu de Heber. Huan in Heber catca iconeu de Sala. ");
INSERT INTO azzNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Huan in Sala catca iconeu de Cainán. Huan in Cainán catca iconeu de Arfaxad. Huan in Arfaxad catca iconeu de Sem. Huan in Sem catca iconeu de Noé. Huan in Noé catca iconeu de Lamec. ");
INSERT INTO azzNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Huan in Lamec catca iconeu de Matusalén. Huan in Matusalén catca iconeu de Enoc. Huan in Enoc catca iconeu de Jared. Huan in Jared catca iconeu de Mahalaleel. Huan in Mahalaleel catca iconeu de Cainán. ");
INSERT INTO azzNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Huan in Cainán catca iconeu de Enós. Huan in Enós catca iconeu de Set. Huan in Set catca iconeu de Adán. Huan in Adán catca iconeu de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Huan Totajtzin Dios quiyolpepexocaltijtinemic Jesús Temaquixtijque ica in Yecticatzin Espíritu. Huan ijcón in Jesús quisteu huan quicautehuac ne ateno den monotza Jordán huan yajqui ocsecan. Huan ijcón in Yecticatzin Espíritu quiyecanac Jesús hasta ajsic ne campa tayiucan. ");
INSERT INTO azzNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Huan ompa yetoto omepoal tonal huan omepoal yohual. Huan ompa in amocuali Satanás quiejecoltij itacuautamatilis de Jesús para ma motajtacolmacani. Huan tech nojón omepoal tonal amo teyi quicuaya Jesús. Huan cuac panoc ya nojón omepoal tonal, ijcuacón mayanac Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ijcuacón in amocuali Satanás quilij Jesús ijcuín: ―Como melau Tejuatzin tion Teconetzin de Dios, ijcuacón xicnahuati nijín tet que ma mocuepa se pantzin huan xicua. ");
INSERT INTO azzNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ijcuacón Jesús quinanquilij ijcuín: ―Quijtoa in Tajcuilolamatzin de Dios ijcuín: “In taca ma nemican amo sayó ica in tacualis san. Ta, no ma yolpepexocaltinemican ica nochi in Tajtoltzin ten Dios techmactilijtinemi”. ");
INSERT INTO azzNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Huan de ompa in amocuali Satanás cuiyac Jesús tech se hueyi tepeyo den tepepan. Huan ompa in amocuali quinextilijtihuetzic Jesús nochi in pueblojme campa tayecanaj in hueyi chihuanime de nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Huan in amocuali Satanás quilij Jesús ijcuín: ―Nejua huelis nimitzmactilis nochi in chicahualisme de nojón pueblojme ihuan ninueyipanchiucayot huan ninricojyot ten yejuan quipixtinemij. Porín nochi nojón chicahualis nomaco yetoc. Huan huelis nicmacas ne chicahualis aquen yesqui nicnequis nicmactilis. ");
INSERT INTO azzNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Huan tacán timotancuaquetzas huan timotentocas noixpan huan no tacán tinechmohuistilis, ijcuacón nochi nijín ten tiquitztoc nimitzmactilis Tejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ijcuacón in Jesús quinanquilij ijcuín: ―Niman xiyó ya, tejua tiamocuali Satanás. Porín quijtoa tech in Tajcuilolamatzin de Dios ijcuín: “Ma xicmohuistiliti Totecotzin Dios, huan sayó Yejuatzin xicmohuiscatequitilijtinemi”. ");
INSERT INTO azzNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ijcuacón in amocuali Satanás ocsepa cuiyac Jesús tech ne pueblo de Jerusalén. Huan ompa quitejcoltij ipan ne tepamit ten cachi huejcapan ten pohui de ne hueyi tiopan de judíos. Huan Satanás quilij Jesús ijcuín: ―Como melau Tejuatzin tion Teconetzin de Dios, ximosencahua xihuetziti de nican hasta talixco. ");
INSERT INTO azzNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Huan no Satanás quilij Jesús ijcuín: ―Ijcón nimitzilía porín quijtoa in Tajcuilolamatzin de Dios ijcuín: “Dios quinualtitanis in ángeles taquehualme de Dios ma mitzyecpalehuican. ");
INSERT INTO azzNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Huan ne ángeles ma mitzmatzacuilican ica ninmahuan para ma amo ximometzcojcoco ica in teme”. ");
INSERT INTO azzNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Huan Jesús quinanquilij Satanás ocsepa ijcuín: ―Pero no quijtoa in Tajcuilolamatzin de Dios ijcuín: “Amo xictelpanoltis in tapalehuilis ten Totecotzin Dios moyectencahuac de techmactilis”. ");
INSERT INTO azzNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Huan cuac in Satanás quitamitanemililtij Jesús ica míac tataman tajtacol, ijcuacón mosecocahuac de Jesús por se rato. ");
INSERT INTO azzNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Huan ijcón in Jesús Temaquixtijque quicautehuac ne campa taiucan huan yajqui ajsito campa Galileajcopaca. Huan Totajtzin Dios quiyolpepexocaltijtiyá Jesús ica in Yecticatzin Espíritu. Huan ijcón motetapohuiayaj den chicahualis de Jesús Temaquixtijque campa nochi pueblojme den itatilanaluan de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Huan ijcón Jesús Temaquixtijque quinmachtijtinemic ica in Tajtoltzin de Dios tech nochi nintiopanuan den judíos. Huan ijcón nochi in pueblojuani de nojón pueblojme quihueyimohuiscapohuayaj Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ijcuacón in Jesús Temaquixtijque yajqui ajsito campa ipueblojcopaca Nazaret itech ne pueblo campa ixpetanic. Huan mochihuac que tech ne tonal de nesehuilis in Jesús Temaquixtijque calaquic tech in tiopan de judíos, ijcón queme Jesús mohuicaya. Ica ya nojón Yejuatzin moquetzac huan pehuac quinleerohuilía in tacaquini in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Huan quimactilijcaj ya Jesús ne Tajcuilolamatzin de ne huejcau tanahuatijque Isaías. Huan ijcón Jesús quitapoj ne libro huan ompa quixajsic campa ijcuiliutoc ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","In Totecotzin Dios nechyolpepexocaltijtinemi ica in Yecticatzin Espíritu. Porín Yejuatzin nechonijitac ya para niquinnojnotztinemis ica in yancuic Tajtoltzin de Dios para nojónques tagayot ten quiyolmachilíaj que yejua pobres huan amo teyi chihuanime. Huan Totajtzin Dios nechualtitanic nican talticpac para niquinyolsehuis neques ten yoltaxocolilme ica tajtacol. Huan no Totajtzin Dios nechualtitanic para niquintapohuis neques ten poutocque queme yesquía presos tech nintajtacolojpan. Huan no Totajtzin Dios nechualtitanic para niquintachialtis neques ten ixpojpoyome porín nintajtacoluan quinixpojpoyocuiltitoc. Huan no Totajtzin Dios nechualtitanic para niquintacajcahualtis neques ten tzijtzicautocque ica in cadenas de tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Huan no Totajtzin Dios nechualtitanic para niquintapohuis in talticpacuani que ejcoc ya in xihuit cuac Totajtzin Dios ipaquilis de quinmaquixtis in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ijcuacón in Jesús Temaquixtijque quitetecuinoj ne Tajcuilolamatzin huan quimactilij ne tiopan tapalehuijque, huan de ompa mosehuij Jesús. Huan nochi in tiopan tacaquini quisentocayaj quisenitztoyaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ica ya nojón Jesús pehuac quinnojnotzac ijcuín: ―Huan axcan hueyi melau que nijín tanahuatil de Dios motamichihuac ya namoixpan, que nejua nican niyetoc nejuatzin ne tanahuatijque de Dios ten namejuan nanquichixtoyaj que ma hualani. ");
INSERT INTO azzNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Huan nochi nojón tacaquini quimohuiscapohuayaj Jesús huan no quimoucacaquíaj de ne itajtoluan ten cualcuía neteicnelilis de Dios. Huan nojón tacaquini motatajtoltiayaj ijcuín: ―¿Xe amo yejua nijín iconeu ne José? ");
INSERT INTO azzNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Huan ijcón Jesús quilij ijcuín: ―Achá acsá yetos ten quinequis nechilis ica nijín tapohuil ten quijtoa ijcuín: “Tejua titepajtijque monequi ximopajti tejua san”. Huan no nechilisquía ijcuín: “Tictecaquilijque que ticchihuac míac mohuiscatequime de Dios nepa campa pueblo Capernaum. Huan axcan ticnequij xicchihua nican tech mopueblojcopaca”. ");
INSERT INTO azzNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Huan no Jesús quinilij ijcuín: ―Yec melau namechilía que amo aquen quimohuiscapohuaj se tanahuatijque de Dios tech ipueblojcojpaca campa ixpetanic. ");
INSERT INTO azzNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Huan namechyequilía tech nojón tonalme cuac nemico in tanahuatijque Elías, ijcuacón oncayaj miacque sihuacahualme campa pueblojuani de Israel. Huan tech nojón tonalme amo quiohuía eyi xiutica huan chicuasen metzti. Ica ya nojón oncaya hueyi máyanti tech nojón pueblojme. ");
INSERT INTO azzNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Pero Totajtzin Dios amo cualtitanic Elías para quinpalehuis nión senme de nojón sihuacahualme ten calyetoyaj campa pueblojme de Israel. Pero, quema, Totajtzin Dios cualtitanic Elías para quipalehuis se sihuacahual ten calyetoya campa Sarepta ten pohuía tech in pueblo de Sidón, masqui ne sihuat amo catca pueblojcat de Israel. ");
INSERT INTO azzNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Huan tech nojón tonalme cuac nemico in tanahuatijque Eliseo, ijcuacón oncayaj míac cocoyani campa pueblojme de Israel ten cocotocatoyaj innacayo. Huan ne Eliseo amo aquen quinpajtij tech nojón ipueblojcahuan den cocoyani. Ta, sayó quipajtij in cocoxque ten monotzaya Naamán. Huan yejua pohuía de Siriajcopaca huan amo catca pueblojcat de Israel. ");
INSERT INTO azzNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Huan cuac quicacque nochi nijín tanojnotzalis, ijcuacón nochi in tacaquini ten yetoya tiopanijtic mohueyiyolcualantijque. ");
INSERT INTO azzNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Huan ijcón yejuan moyolchicauque huan mosenpanixejecoltijque, huan de ompa quiquixtijque Jesús tech nojón pueblo de Nazaret. Huan ijcón cuiyacque Jesús hasta ne tepeyecapan ya porín in pueblo de Nazaret quichichiucaj ipan ne tepetzintan. Huan ompa quinequíaj quipantamotatihue Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Pero in Jesús Temaquixtijque panotiquisac intzalan den ne tagayot huan mochololtij. ");
INSERT INTO azzNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Huan ijcón in Jesús yajqui huan ajsito campa pueblo de Capernaum ten itatilanal Galilea. Huan ompa pehuato quinmachtiaya ica in Tajtoltzin de Dios ne pueblojuani tech in tonalme de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Huan ijcón ne pueblojuani de Capernaum quihueyimoucacaquíaj de Yejuatzin nitamachtilis porín Jesús quinmachtiaya ica hueyi chicaucahuelilis. ");
INSERT INTO azzNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Huan tech nojón tiopan de judíos ompa yetoya se tagat ten quipiaya iyolijtic se amocuali ejecat ten pitzotic. Huan ne amocuali ejecat sepan san quiontzajtzilij Jesús ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","―Xitechtapatahuili huan amo xitechcuejmoloqui. ¿Toni ticpía tohuan, Jesús de Nazaret? ¿Xe tejua tihuala para titechpolos? Nejua cuali nimitzixmati aconi tejua, tionyecticatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ijcuacón Jesús quitacahualtij ne amocuali ejecat huan quilij ijcuín: ―Ximotentamatili huan xiquisa tech yejua. Ijcuacón ne amocuali ejecat quitalpantamotac ne tagat inixpan ne tiopantacaquini. Huan de ompa ne amocuali ejecat quistehuac de ne tagat, pero amo teyi ica quicojcocojteu. ");
INSERT INTO azzNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ijcuacón nochi ne tiopantacaquini mohueyiyolmoutijque huan monojnotzayaj se huan ocsé ijcuín: ―¿Toni chicahualis cualcui itajtoluan de Jesús para huelis quicalanquixtilis ne amocuali ejecat? Porín tiquitaj que nijín Jesús quipía huelilis para quinnahuatis in amocuali ejecame ma calan quisacan. Huan yejuan quitacamatij huan calan quisaj. ");
INSERT INTO azzNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Huan ijcón cachi oc motejtapohuiayaj den ihuelilis de Jesús Temaquixtijque tech nochi nojón pueblojme ten quiyehualojtoya Capernaum. ");
INSERT INTO azzNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ijcuacón in Jesús Temaquixtijque quisac de nojón tiopanijtic huan yajqui calaquito ichan in Simón. Huan ompa Jesús quitac que imonan Simón que huetztoya ica hueyi totonic. Ica ya nojón ichancahuan de Simón quitatautijque Jesús que ma quipajti. ");
INSERT INTO azzNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Huan ijcón in Jesús motoquij campa in cocoxque huan quipanixitac. Huan de ompa Jesús quitacahualtij huan quixtopehuac nojón totonic. Ijcuacón nimantzin ne totonic quitacahuilij ne cocoxque. Huan niman cuac quitacahuilij ya in totonic, ijcuacón nimantzin meutiquisac ne imonan de Pedro huan pehuac quintamacac icalpanocahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Huan nochi in pueblojuani de ne Capernaum quinpixtoyaj cocoyani tech ninchan de míac tataman cocolisme. Huan cuac pancalatoya ya in tonaltzin, ijcuacón quinualcuicque campa Jesús yetoya nojón cocoyani. Huan ijcón Yejuatzin momasohuaya inpan nojón cocoyani huan ijcón nochi yejuan quinpajtiaya. ");
INSERT INTO azzNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Huan ijcón no quisayaj miacque amocuali ejecame tech ninyolojtic de ne cocoyani. Huan nojón amocuali ejecame chicaucatzajtzíaj huan quiliayaj Jesús ijcuín: ―Tejuatzin, tion Teconetzin de Dios ten Motajtzin. Pero in Jesús Temaquixtijque quintacahualtij nojón amocuali ejecame ma amo tajtojcan oc porín yejuan cuali quimatque que Jesús Yejuatzin ya in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Huan imostica cuac tanesic ya, ijcuacón in Jesús Temaquixtijque quisac tech nojón pueblo huan yajqui campa se lugar tayiucan. Pero in pueblojuani quitemojtinemíaj Jesús hasta yejuan cajsique campa Yejuatzin yetoya. Porín yejuan quinequíaj quilochtisque oc que ma mocahuani inuan oc. ");
INSERT INTO azzNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Pero in Jesús quinilij ijcuín: ―Semi monequi ma niquintetapohuiti ocsequin pueblojuani huan niquinnextilitiu de queniu quimonequiltía Dios ma momasouto ica ihueyichicahualis tech se iyolijtic. Porín nijín tequit yejica ya Dios nechualtitanic ma nicchihua. ");
INSERT INTO azzNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Huan ijcón quichiutinemic Jesús tanojnotztinemía ica in Tajtoltzin de Dios tech in tiopan de judíos ten poutocque Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Huan mochihuac que se tonal in Jesús Temaquixtijque nentinemía ne atentenojcopaca de Genesaret. Huan huel míac tagayot cajsitoj Jesús hasta quipejpechiayaj porín yejuan quinequíaj quicaquisque in tanojnotzalis den Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Huan mochihuac que Jesús quinitac ome barcos de apanolonime ne atenteno ten amo aquen yetoyaj tech nojón barcos. Porín ne tamaajsini temocaj ya de ne barcos quinixpacayaj ne ninatarrayas. ");
INSERT INTO azzNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ica ya nojón in Jesús calaquito tech senme de nojón ome barcos, ne barco pohuía ihuan in Simón. Huan ijcón Jesús quitatautij Simón ma quitzinquixti ibarco campa apanían. Huan de ompa niman Jesús motalij tech in barco huan pehuac quinmachtía in tagayot ica in Tajtoltzin de Dios desde ne apanían. ");
INSERT INTO azzNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Huan cuac in Jesús quintaminojnotzac ya in ica in Tajtoltzin de Dios, ijcuacón Jesús quilij Simón ijcuín: ―Xicuican nijín mobarco nepa campa cachi ahuejcatan. Huan ompa xiquintamotacan namoatarrayas para ijcón nanquinquitzquisque in pescados. ");
INSERT INTO azzNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ijcuacón in Simón quinanquilij ijcuín: ―Pero tamachtijque, tejuan titequititocque nochi yohual ya, huan ayamo timinajxilíaj pescados. Pero tejua motanahuatil, cuali huelis tictamotasque toatarrayas. ");
INSERT INTO azzNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Huan cuac quitamotque ya niatarraya, ijcuacón quinquitzquijque tel miacque pescados hasta in atarraya pehuac ixcocotoca. ");
INSERT INTO azzNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ijcuacón in tequitini tech nojón barco de Simón, yejuan peuque quinixnotzaj nintequiticaicnihuan tech in ocsé barco para ma huiqui quinpalehuiquij. Huan ijcón ne nintequiticaicnihuan hualajque quinpalehuicoj. Huan quinololojque in pescados huan quincalaquijque tech in ome barcos hasta nesi que quinequíaj pancalaquisque in barcos. ");
INSERT INTO azzNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Huan cuac in Simón quitac ya nochi nijín ten mochihua, ijcuacón motancuaquetzac iixpan Jesús huan quilij ijcuín: ―Notecotzin, ximosecocahua de nejua, porín nejua nitajtacole. ");
INSERT INTO azzNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Huan Simón quichihuac ijcón porín mohueyiyolmoutij ca nojón ten quitac. Huan no moyolmoutijque nochi in tequitini ten ihuan Simón tequititinemíaj sayó porín quinquitzquijque huel míac pescados. ");
INSERT INTO azzNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Huan no moyolmoutijque Jacobo huan Juan, yejuan teconehuan de Zebedeo huan yejuan catcaj ipa tequiticaicnime de Simón. Pero in Jesús quinojnotzac ijcuín: ―Tejua Simón, amo ximoyolmoutij porín nican para taixpan nimitznextiliti de queniu tiquintemojtinemis tagayot para ma nechtacamatican, ijcón queme ay tiquintemojtinemi pescados. ");
INSERT INTO azzNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Huan cuac quinuiyac ya ninbarcos ne atenteno, ijcuacón in Jacobo huan Juan huan Simón quicauteuque ninbarcos huan yajque quitoctilijque Jesús para momachtisque itanextililis de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Huan mochihuac se tonal que yetoya Jesús Temaquixtijque tech se pueblo ten itatilanal de Galilea. Huan ejcoc tech ne pueblo se cocoxque ten cocotocatoya ninacayo. Huan cuac in cocoxque quitac Jesús, ijcuacón yejua motoquij huan motancuaquetzac huan moixacatentocato hasta talixco huan quitatautij Jesús ijcuín: ―Totecotzin, como ticonmonequiltía, cuali tionhuelis tinechonchipahuas de nijín pitzotic nococolis. ");
INSERT INTO azzNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ijcuacón in Jesús momatilanac huan quimatocac in cocoxque huan quilij ijcuín: ―Nicnequi ma tejua xionchipahuac ya de mococolis. Huan cuac Jesús ijcón quilij, ijcuacón nimantzin quisac ne cocolis den inacayo cocotocatoya huan mocahuac chipactzin ne tagat. ");
INSERT INTO azzNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Huan ijcón Jesús quichicaucanahuatij ijcuín: ―Xiquita, amo aquen teyi xictapohui. Ta, sayó xiyó ximotenextiliti ihuan ne tiopixcame judíos de que tichipahuac ya. Huan de ompa xiquinmactiliti Dios ne tetayocolil ijcón queme Moisés tanahuatiaya para ne cocoyani ten tapajtilme ya de ne cocotoca ninacayo. Huan ijcón ixnesis innahuac mopueblojcahuan de que tichipahuac ya de mococolis. ");
INSERT INTO azzNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Huan ijcón cachi oc motetapohuiayaj nohuiyampa den ichicaucahuelilis de Jesús. Huan mosentiliayaj huel míac tagayot para quicaquilisque tenica quinnojnotzaya. Huan no motoquíaj huel míac tagayot campa Jesús yetoya para ma Yejuatzin quinpajtij de nincocolisuan. ");
INSERT INTO azzNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Pero icsá in Jesús Temaquixtijque mosecocahuac den tagayot huan yaya campa taiucan para ompa motatatautilis ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Huan mochihuac se tonal que Jesús tamachtiaya ica in Tajtoltzin de Dios. Huan campa nojón tamachtijtoya ompa tocotzyetoya sequin tamatinime fariseos huan ya sequin tanextiliani ica in tanahuatil de Moisés. Huan nojón tamatinime huan tanextiliani hualajque de míac pueblojtzitzin de itatilanal de Galilea huan no de Judea huan de Jerusalén de itatilanaluan. Huan in chicaucahuelilis de Totecotzin Dios monextiaya itech Jesús Temaquixtijque cuac Yejuatzin quinpajtiaya in cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Huan mochihuac que sequin taca cualcuiliaya Jesús se cocoxque ten nochi ninacayo tami sensepoutoc ya huan amo huelía nejnemía. Huan cualcuiayaj ne cocoxque tech se petatzin. Huan ne taca quinequíaj quicalaquitihue in cocoxque ne calijtic para ompa quitalijtihue in cocoxque iixpan Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Pero yejuan amo huelíaj quicalaquisque in cocoxque para ejcosque campa yetoya Jesús, porín nocta míac tagayot mosentilijcaj ya. Ica ya nojón yejuan tejcocque calcuaco huan quicuatapouque in cali. Huan ompa quipantemoltijque in cocoxque ihuan nipet huan quitalijque intzalan in tagayot ne campa iixpampa Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Huan cuac Jesús quitac nintacuautamatilis de nojón nahui taca, ijcuacón Yejuatzin quilij in cocoxque ijcuín: ―Tejua tagatzin, motajtacoluan nimitzintapojpoluilía ya. ");
INSERT INTO azzNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Huan ne fariseos huan in tanextiliani de tanahuatil de Moisés, cuac yejuan quicacquilijque Jesús nijín tajtolme, ijcuacón yejuan peuque yoltanemilíaj huan motatajtoltiayaj ijcuín: “¿Aconi nijín tagat ten quimohuiscapoloa Totajtzin Dios ica nijín tajtolme? ¿Aconi huelis tetapojpoluis tajtacol? Ta, sayó Dios hueli tetapojpoluía”. ");
INSERT INTO azzNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Huan ijcón in Jesús niman quinyolojixmatía de que ijcón yoltanemiliayaj ne tanextiliani. Ica ya nojón Jesús quinilij ijcuín: ―¿Queyé ijcón nanyoltanemilíaj? ");
INSERT INTO azzNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Huan namechilía que amo ohui ma niquilis nijín cocoxque ijcuín: “Motajtacoluan nimitzintapojpoluía ya”. Pero no namechilía que cachi ohui ma niquili nijín cocoxque ijcuín: “Ximehua de mocochpet huan xinenemi”. Huan yejua ya nijín cachi ohui porín ixnestinemi senteixteno cox melau pajtic ya oso amo. ");
INSERT INTO azzNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Huan como cuali hueli nicpajtis nijín cocoxque, ica ya nojón Nejuatzin nicnequi namechyecmatiltía que Nejuatzin ya ni Yectagatzin de Dios. Huan no nicpía tanahuatil de Dios nican talticpac para niquintapojpoluis naquen motajtacolmagacque ya. Huan de ompa Jesús quilij in cocoxque ten ninacayo tamisensepoutoc ijcuín: ―Tejua cocoxque, nimitzilía ximehua, xicui motapech huan xiyó mochan. ");
INSERT INTO azzNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ijcuacón nimantzin in cocoxque moquetzac senteixteno huan quicuic nitapech campa huetztoya huan yajqui ichan huan ijcón quimohuistilijtiyá Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Huan ijcón nochi in tacaquini quihueyimoucaitacque ten mochihuac huan quimohuistiliayaj Totajtzin Dios. Huan ica hueyi yolmohuisyot quijtoayaj ijcuín: ―Axcan hueyi melau tiquitacque ya se hueyi mohuiscatequit de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Huan satepan cuac quitamichihuac nijín mohuiscatequime, ijcuacón Jesús calan quisac huan ompa quitac se tatopaluijque ten monotza Leví. Huan in Leví tocotzyetoya caltenteno campa quintopaluiaya in pueblojuani. Huan ijcón Jesús quilij in Leví ijcuín: ―Xinechtoctiliti huan ximomachtiqui nohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ijcuacón in Leví moquetztiquisac huan quicahuac nitequiu campa ne tocotziutoya huan yajqui quitoctilito Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Huan cachi satepan in Leví quiluichihuilij Jesús ompa ichan. Huan ijcón ompa mosentilijque míac itatopaluijcaicnihuan huan ocsequin taca para ompa sepan tacuasque. ");
INSERT INTO azzNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Huan tech ne iluit in fariseos huan in tanextiliani ica in tanahuatil de Moisés, yejuan nojonques peuque quintejtenehuayaj ne imomachtijcahuan de Jesús. Huan quintajtoltijque imomachtijcahuan de Jesús ijcuín: ―¿Queyé namejuan nantacuaj huan nantayij ihuan ne tatopaluiani huan ne ocsequin tajtacolejque ten amo quitacamatij in tanahuatil de Moisés? ");
INSERT INTO azzNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ijcuacón Jesús quinnanquilij ijcuín: ―In tagayot ten mopohuaj yolpactocque, yejuan nojónques amo monequi tepajtijque. Ta, namechilía que sayó in cocoyani monequi tepajtijque. Ica ya nojón axcan Nejuatzin ninuan nisentacuajtoc nijín tatopaluiani, porín yejuan queme yesquía cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nejuatzin amo nihuala niquintemoco naquen mopohuaj yolchipauque. Ta, Nejuatzin nihuala nican talticpac para niquintemos tajtacolejque para ma yejuan ma moyolnemilican de nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ijcuacón ne tamatinime quilijque Jesús Temaquixtijque ijcuín: ―Ne imomachtijcahuan de Juan Taahuijque, yejuan semi mosautinemij huan semi motatatautilijtinemij. Huan ijcón no quichiutinemij imomachtijcahuan den fariseos. Pero tejua momomachtijcahuan, ¿queyé yejuan quisentocaj tacuajtinemij huan tayitinemij vino ihuan nojón tajtacolejque? ");
INSERT INTO azzNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Huan ijcón in Jesús ocsepa quinanquilij ijcuín: ―Como yetoc oc in teyoquich ¿queniu huelis se quinilis ma mosahuacan neques taijitalme ten hualajque monechicojque para se nenamictilis? Huan no ijcón amo nihuelis niquinilis in nomomachtijcahuan ma mosahuacan como Nejuatzin ihuan niyetinemi oc. ");
INSERT INTO azzNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Pero queman hualas ne tonal cuac in teyoquich cajchihuasque ya, ijcuacón tech nojón tonalme huelis mosahuasque. Huan no tech nojón tonalme cuac nechajchihuasque huan nechmictisque, ijcuacón cuali nanmosahuasque ya. ");
INSERT INTO azzNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Huan ijcón ocsepa Jesús quinmachtiaya ica ocsé nexcuitil ijcuín: ―Xiquitacan que amo aquen quicotonas se cachol de se yancuic tasal para ica quitasaluis se soltic tasal. Ipa amo semi yec cualtía ihuan ne tasal den yancuic huan ne soltic tasal para quitasaluisque. Porín como ijcón quichihuasque, ijcuacón ne yancuic tasal ijtacahuis ya. Huan no ne tzictzin yancuic tasal amo semi yec cualnesi ihuan ne soltic tasal. ");
INSERT INTO azzNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Huan amo no aquen quipantecas in yancuic vino tech in cuetaxsolme. Porín in yancuic vino, yejua ne mochicahualtis huan atzitzicasquisas. Huan ijcón cuali huelis quitzayanas in cuetaxsol huan mimilahuis nochi in vino. Huan ijcón cachi ijtacahuis in cuetaxsol. ");
INSERT INTO azzNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Pero in yancuic vino se quitequilía yejua ne den yancuic cuetaxme. Huan ijcón nión in vino huan nión in cuetaxme ijtacahuisque. ");
INSERT INTO azzNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Huan nochi ten cuelitaj tayisque ne vino ten cuali mochicahualtij ya, yejuan nojónques amo cuelitaj tayisque nojón yancuic vino. Porín quijtoaj que ne vino ten mochicahualtij ya que yejua ya cachi cuali. Huan no ijcón mochihua que nochi neques ten cuelitztinemij in taneltocalis de huejcaucayome queme yesquía vino den mochicahualtij ya, yejuan nojonques amo nechcaquilisque cuac nejua niquinmachtis se yancuic taneltocalis. ");
INSERT INTO azzNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Huan se tonal Jesús Temaquixtijque panotiaya campa tatocala ica trigojtet tech se tonal de nesehuilis. Huan mochihuac que imomachtijcahuan quiyolcopintiayaj nijín trigo huan icacauyo quixtiayaj ica imahuan huan de ompa quicuayaj ne niteyo. ");
INSERT INTO azzNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ijcuacón sequin tamatinime fariseos quintajtoltijque imomachtijcahuan de Jesús ijcuín: ―¿Queniu namejuan nantequititinemij ica nojón tequit tech ne tonal de nesehuilis? Porín ne itanahuatil de Moisés tetacahualtía. ");
INSERT INTO azzNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Huan in Jesús quinilij ijcuín: ―¿Xe namejuan amo queman nanquileerojque ten quichihuac in rey David huan itapalehuijcahuan cuac mayanque? ");
INSERT INTO azzNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Huan in rey David calayic tech ichantzin Dios huan quincuic huan quincuaj ne panes ten quitalijcaj ya iixpantzinco Dios para ica quimohuistilisque Yejuatzin. Huan Dios amo quimonequiltij ma acsá quicuani nojón panes nión in rey David huan nión nitapalehuijcahuan. Ta, sayó ma quicuani ne panes in tiopixcame judíos. ");
INSERT INTO azzNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Huan no Jesús quinilij ijcuín: ―Xicmatican ca cuali que Nejuatzin ni Yectagatzin de Dios huan Nitayecancatzin de ne tonal den nesehuilis. Huan Nejuatzin nicpixtinemi tanahuatil para niteilis toni cualtías se quichihuas tech ne tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Huan mochihuac que ocsepa se tonal de nesehuilis Jesús Temaquixtijque calayic campa se tiopan de judíos huan ompa tamachtiaya ica in Tajtoltzin de Dios. Huan ompa tiopanijtic tocotzyetoya se tagat cocoxque ten iyecmay mamijmiquilotic catca. ");
INSERT INTO azzNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Huan no ompa tiopanijtic tocotztoyaj sequin tamatinime fariseos huan tanextiliani den tanahuatil de Moisés. Huan yejuan nojonques sayó quipijpixtinemíaj Jesús para quitasquíaj cox melau Jesús quipajtisquía nojón cocoxque tech ne tonal de nesehuilis. Huan tacán Jesús quipajtisquía ne cocoxque, ijcuacón in tamatinime cachi oc quipiasquíaj tensá tamachilis tenica quiteluilisque Jesús de amo quitacamati in tanahuatil de ne tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Pero Jesús quintamachilisixmatía nojón tamatinime. Ica ya nojón Yejuatzin quilij ne cocoxque ten mamelaxuaquía ijcuín: ―Ximehua huan ximoquetzaqui tatajco den tacaquini. Huan melau ne cocoxque quichihuac ijcón; yejua mehuac huan moquetzac den tatajco den tacaquini. ");
INSERT INTO azzNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ijcuacón Jesús quinilij in tacaquini ijcuín: ―Nicnequi namechtajtoltis ijcuín: ¿Cox Dios quimonequiltía ma ticchihuacan ten cuali tech in tonal de nesehuilis? oso, ¿ma ticchihuacan ten amocuali chihualis? oso, ¿ma ticmaquixtican se inemilis? oso, ¿ma tiquixpolocan se inemilis? ");
INSERT INTO azzNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Huan ijcón Jesús quinsenixitaya nochi neques ten quiyehualojtoya. De ompa Jesús quilij in tagayot cocoxque ijcuín: ―Ximomamelahua. Huan ijcón in cocoxque momamelahuac imay huan de ompa ne imay pajtic. ");
INSERT INTO azzNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ica ya nojón ne tamatinime mohueyiyolcualantijque. Huan peuque moyoliliayaj se huan se ijcuín: “¿Toni huelis ticchihuilisque ne Jesús? para ma amo ay tamachtijtinemis oc?” ");
INSERT INTO azzNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Huan tech nojón tonal Jesús Temaquixtijque yajqui campa se tepelomojtzin para motatatautilis ihuan Dios. Huan ompa yetoya nochi se yohual motatatautilitoya ihuan Itajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Huan cuac tanesic ya, ijcuacón Jesús quinnotzac imomachtijcahuan ma motoquican campa Yejuatzin yetoya. Ijcuacón Jesús quinijtac majtactionmome de nimomachtijcahuan huan quintequimactij ma yesque itatitaniluan de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Huan Jesús quinijitac yejuan nijinques: in Simón ten cojpatocaytiayaj Pedro. Huan no quijitac Andrés, yejua iicniu de Simón. Huan no Jesús quinijitac Jacobo huan Juan huan Felipe huan Bartolomé. ");
INSERT INTO azzNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Huan no Jesús quinijitac Mateo huan Tomás huan Jacobo, yejua teconeu de Alfeo. Huan no Jesús quinijitac Simón ten pohuía ihuan in taca políticos ten yolchicauque. ");
INSERT INTO azzNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Huan no Jesús quijitac Judas, yejua ten iicniu Jacobo. Huan no Jesús quijitac in Judas Iscariote ne ten quitemactij Jesús ma quimictican. ");
INSERT INTO azzNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Huan ijcón in Jesús temoc de ne tepelomo ihuan imomachtijcahuan huan mochihuac que Yejuatzin milochtij oc ihuan imomachtijcahuan tech se hueyi tamanis. Huan ompa yetoya huel míac tagayot ten hualayaj de míac tataman pueblojme de itatilanal Judea huan Jerusalén. Huan no hualayaj huel míac tagayot ten calyetocque campa pueblojme de Tiro huan Sidón ten atentenojcopaca. Huan ne tagayot hualayaj para quicaquilisque Jesús nitanojnotzalis. Huan no hualayaj ya para ma quinpajti Jesús de nochi nincocolisuan. ");
INSERT INTO azzNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Huan nochi neques ten tajyohuijtinemíaj ica in pitzotic amocuali ejecame, yejuan nojonques Jesús quinpajti. ");
INSERT INTO azzNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Huan nochi in cocoyani quinequíaj quimatocasque Jesús porín Yejuatzin quinpajtiaya sayó ica ihueyichicahualis ten pepexocatinemi itech Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ijcuacón Jesús quinsenixitac imomachtijcahuan huan quinmachtiaya ijcuín: ―Nantatiochihualme de Dios namejuan ten pobres ten amo teyi nanchihuanime, porín namejuan Dios cuali namechyolyecanas ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Huan no nantatiochihualme de Dios namejuan ten nanmayantinemij axcan, porín namejuan Dios cuali namechyecyolpexontijtíyas ica ne ten monequi. Huan no nantatiochihualme de Dios namejuan ten axcan nanmoyolcocoaj, porín Dios quichihuas que nanmoyoluelitasque ica yolpaquilis. ");
INSERT INTO azzNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Huan no nantatiochihualme de Dios namejuan cuac in tagayot namechtahuelitztinemisque huan mosecocahuasque de namejuan. Huan no nantatiochihualme de Dios cuac in tagayot namechquejqueloaj huan cuac namechtejtenehuasque que amo nancualime. Huan ijcón nanquinchihuilijtocque porín nantacuautamatij itech notocay Nejuatzin ni Yectagatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Huan tech ne tonal cuac namechtajyohuiltisque, ijcuacón namejuan ximohueyiyolpactican huan ximohuelitacan porín xicmatican que nanquipiatihue se hueyi tetayocolil de Dios nepa eluiyactzinco. Huan no xicmatican que ijcón queme axcan namechmohuispoloaj in tagayot, no ijcón namohuejcautatuan quinmohuispolojtihualajque ne itanahuatijcahuan de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Huan semi nanteicneltijque namejuan ten nanricojme porín namechnamiqui xicselican in tatzacuiltilis de Dios. Huan xicmatican que axcan tamitiyás ya nochi namoricojyo tenica nanmoyolpactijtihualajque. ");
INSERT INTO azzNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Huan semi nanteicneltijque namejuan ten nanixuitocque huan amo nanquimachilijtinemij máyanti. Porín se tonal xicmatican que nanquimachilisque ne hueyi máyanti, huan ijcón amo huelis oc nanixuisque oc. Huan no semi nanteicneltijque namejuan ten axcan nanyoluetzcatinemij porín nanquipixtinemij nochi ten monequi. Pero se tonal nanmoyolcocosque huan nanchocasque. ");
INSERT INTO azzNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Huan semi nanteicneltijque namejuan cuac namechmohuiscapohuasque nochi in tagayot, porín no ijcón ne namohuejcautatuan quinmohuiscapouque ne tacajcayahuani tanahuatiani. ");
INSERT INTO azzNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Huan namejuan ten nannechcaquilijtocque nijín tamachtilis, namechilía que Xiquintasojtacan neques ten namechtahuelitztinemij. Huan no xiquinpalehuican neques ten namechtajyohuiltijtinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Huan xictajtanilican Dios ma Yejuatzin quintapojpolui neques ten namechuijuicaltijtinemij. Huan no ximotatatautilican ica por neques ten namechmohuispolojtinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Huan tacán mitzcamatatzinis acsá, ijcuacón xicuepa moixco ma mitzcamatatzini ocseco. Huan tacán acsá no mitzcuilisnequi motaquen, ijcuacón xicahuili ma cuica motaquen hasta no mocamisa. ");
INSERT INTO azzNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Huan tacán acsá quinequi mitztajtanilis tensá, ijcuacón xicmacati. Huan tacán acsá mitzcuilis ten tejua moaxca, ijcuacón amo xiquiliti oc que ma mitzcuepili ne ten moaxca catca. ");
INSERT INTO azzNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Huan xiquinchihuilican mopueblojcahuan ijcón queme no namejuan nanquinequisque que yejuan ma namechchihuilican. ");
INSERT INTO azzNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Huan como nanquitasojtatinemij sayó neques ten namechtasojtaj, ijcuacón amoteyi cualtagayot nanquichihua. Porín xicmatican hasta neques ten amo yolchipauque no ijcón quichiutinemij; yejuan quintasojtatinemij sayó neques ten quintasojtaj. ");
INSERT INTO azzNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Huan como nanquinpalehuijtinemi sayó neques ten namechpalehuíaj, ijcuacón amo teyi cualtagayot nanquichihua. Porín xicmatican hasta neques ten amo yolchipauque no ijcón quichiutinemij; yejuan quinpalehuijtinemij sayó neques ten achtopa quinpalehuijque. ");
INSERT INTO azzNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Huan como nanquintaneutíaj tensá sayó neques ten namejuan no nanquinyolnemilíaj que ocsepa namechcuepilis, ijcuacón amo teyi cualtagayot nanquichihua. Porín no xicmatican que ne taca ten amo yolchipauque, yejuan nojonques no quintaneutíaj tensá ocsequin taca ten yolcualime para ijcón quiselisque ocsé achi oc. ");
INSERT INTO azzNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Pero namejuan monequi xiquintasojtacan neques ten namechtahuelitztinemij; huan yejuan no xiquinpalehuijtinemican. Huan no xiquintaneutican tensá, pero amo xicchihuacan que ocsepa namechcuepilisque. Huan como ijcón nanquichiutinemij, ijcuacón Dios namechmactilis se hueyi tetayocolil. Huan ijcón ixnestinemis ya que namejuan nanpoutinemij ihuan Dios in cachi hueyi chiuque. Porín nantapalehuijtinemij ijcón queme Yejuatzin quichiutica. Porín Totajtzin Dios Yejuatzin no semi quinyolicnelía neques ten amo yolchipauque huan ten amo motasojcamatij ihuantzin. ");
INSERT INTO azzNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ica ya nojón namejuan namechilía que xiquinyolicnelijtinemican ijcón queme Namotajtzin Dios techyolicnelijtinemij tinochin. ");
INSERT INTO azzNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan amo xiquinixcomacatinemican acsame para ma Totajtzin Dios ma amo no ijcón namechixcomacas. Huan amo no xiquintelchiutinemican in acsame para ma Totajtzin Dios ma amo no ijcón namechtelchihuas. Ta, namechilía cachi cuali xiquintapojpoluican acsame para ma Totajtzin Dios no ma ijcón namechtapojpolui. ");
INSERT INTO azzNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Xitetayocolijtinemican aquen yesqui ihuan para ma Totajtzin Dios no namechtayocolis ten namejuan nanquimonequiltisque. Huan como ijcón nanquichihuaj, ica ya nojón Totajtzin Dios namechtayocoliti huel míac ijcón queme cuac se quiyecpexonti in chiquihuit ica tensá huan se quinpanteltalía huan se quitzejtzeloa hasta pipixahuiqui. Huan no ijcón Totajtzin Dios namechtayocolis ten monequis. Ne tamachiu de teicnelilis ten namejuan nanquicuitinemij ya para nanquintayocolisque ocsequin, yejua ne Totajtzin Dios quicuis para namechtayocolijtiyás ten namejuan nanmonequij. ");
INSERT INTO azzNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Huan in Jesús quinmachtiaya imomachtijcahuan ica nexcuitil huan quiniliayaj ijcuín: ―¿Mangán se ixpojpoyot huelis quiyecanas se ixpojpoyoicniu? Pues, amo. Porín como ijcón quichihuaj, yejuan nojonques sen huetzitihue tech ne talcoyoc. ");
INSERT INTO azzNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Huan no namechilía que se momachtijque, yejua ne amo cachi hueyi chiuque huan que nitamachtijcau. Ta, nochi neques ten moajsicamachtijtiyohue, yejuan nojonques, quema, quinejnehuililtijtiohue nintamachtilis de nintamachtijcau. ");
INSERT INTO azzNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ica ya nojón amo huelis ticyequitilis se teuti actoc iixtololoco ne mocnitzin como tejua amo timomaca cuenta de que no mitzixtzacuilijtoc se hueyi cuoutzontet. Huan no ne teuti queme se tajtacol ten amo mota huan ne cuoutzontet queme yesquía se hueyi tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Huan no amo huelis tiquilis ne mocniu ijcuín: “Nocniu, ma nimitzquixtili nojón teuti ten ticpía moixtololoco”, como tejua amo achto ticmachilía ne hueyi cuoutzontet ten no mitzixtzajtzacuilijtoc. Porín como amo ticmachilía ne ten mitzixtzajcuilijtoc, ijcuacón tejua tiixcuecueptoc san ica motamachilis. Ta, cachi cuali ximoquixtili achtopa ne cuoutzontet ten mitzixtzajtzacuilijtoc huan ijcón huelis tiyequitas ya ne teuti ten quipía mocniu ne ixtololoco. Huan ijcón huelis ya tiquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Huan no Jesús quinmachtiaya imomachtijcahuan ijcuín: ―Amo teyi se cuali cuoutactzon ten quitemaca taquilot ten chichic. Huan amo no ongac se chichic cuoutactzon ten huelis quitecamacas cuali taquilot. ");
INSERT INTO azzNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Porín cada se cuouhuit moixmati ica itaquilohuan. Huan no cuali nanquinyequixmatisque ya nojón tacajcayahuani ica ne tachihualis ten yejuan quichiutinemij. Huan amo huelis cajocuisque higosxocot como quitocaj huitzme. Huan amo no huelis cajocuisque uvasxocot campa quitocaj huatzap. ");
INSERT INTO azzNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Huan in tagat ten yolchipahuac, yejua ne itech iyolijtic momoyautoc yolchipahualis, huan yejua quiquixtia sayó ne tamachilisme ten cuali. Huan in tagat ten amo yolchipahuac, yejua ne itech iyolijtic momoyautoc ica tajtacol huan yejua quiquixtía sayó itamachilisuan ten motzojcuilotijtoc ica tajtacol. Huan namejuan nanyolpexontinemij ica míac tataman tamachilisme. Huan hualeutoc itech ne namotamachilisuan nochi tajtolme ten namejuan nanquijtoaj. ");
INSERT INTO azzNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Huan ¿queyé namejuan nannechnotzaj que Ninamotecotzin, como amo nanquitacamatij ten nejua namechilijtoc? Pues amo melau que Ninamotecotzin ya. ");
INSERT INTO azzNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Huan ne naquen nechtoctiliqui huan nechcaquilía huan nechtacamatis nochi ten nicnajnahuatis ma xicchiutinemi, yejua ne melau tacuautamatinemi nohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Huan ne ten tacuautamatinemi nohuan, yejua ne quinejnehuilía se tagat ten quichijchihua ichan. Achto tachcua huejcatan ne tagat huan quitalij in tatzinehualonime tech se hueyi tesohuil. Huan cuac huejueyacque ya in hueyiame, ijcuacón in at quimamagaya ne cali. Pero in at amo huelic quiolinij ne cali porín quipiaya se itatzinehualoni tech se hueyi tesohuil. ");
INSERT INTO azzNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Pero ne taca ten amo nechcaquilía oc huan amo quitacamatij ten niquinnahuatía, yejuan nojonques quinejnehuilíaj queme se tagat ten quichijchihua ichan campa yoca tal san huan amo teyi quitalía tatzinehualoni. Ica ya nojón cuac huejueyiyacque in hueyiame, ijcuacón in at quimamagaya ne cali. Huan niman ne caltzin sen tami cacapaxhuetzic. ");
INSERT INTO azzNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Huan cuac Jesús quintamimachtij ya nijín tagayot ten quicaquiliayaj, ijcuacón Yejuatzin yajqui ajsito campa pueblo Capernaum. ");
INSERT INTO azzNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Huan tech nojón pueblo Capernaum yetoya se tayecanque soldado romano. Huan ne tayecanque soldado romano quipiaya se itaquehual ten semi quitasojtaya. Huan ne taquehual semi mococoaya huan yetoya para miquis. ");
INSERT INTO azzNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Huan ne tayecanque soldado romano quitecaquilijque de ichicahualisuan Jesús. Ica ya nojón yejua quintitanic sequin huehuentzitzin den pueblojuani de Israel para ma yejuan quitatautitij Jesús ma yohui quipajtiti ne itasotequiticau den soldado romano. ");
INSERT INTO azzNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Huan ijcón in huehuentzitzin yajque huan motoquitoj campa yetoya Jesús. Huan ompa pehuatoj quitatautiayaj Jesús huan quiliayaj ijcuín: ―Semi quinamiqui que tejuatzin xicpalehuiti ne tayecanque soldado. ");
INSERT INTO azzNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Porín yejua semi techyoltasojtatinemij tejuan tipueblojuani de Israel. Huan ijcón tiquijtoaj porín yejua tanahuatij ma techchijchihuilican se tiopan ica yejua itomintzin. ");
INSERT INTO azzNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ijcuacón Jesús yajqui ihuan ne huehuentzitzin. Huan cuac ajsitiayáj ya ichan ne tayecanque soldado, ijcuacón ne tayecanque soldado quintitanic sequi itasojicnihuan ma quilican Jesús ijcuín: ―Totecotzin, amo semi ximoyolcuejmolojtihuitz oc porín amo nechnamiqui que xicalaquiti campa toyecahuiltzin porín Tejuatzin tihueyichiuque. ");
INSERT INTO azzNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Huan no ne tasojicnime quilijque Jesús ijcuín: ―Toteco quijtoa ijcuín: “Amo nechnamiqui nimoixehuis que ma nejua niquisa huan nimitznamiquiti san porín Tejuatzin cachi tihueyichiuque. Ta, Tejuatzin sayó xihualtanahuati ma pajti notaquehual campa tionyetoc, huan ijcón notaquehual nenquentis”. ");
INSERT INTO azzNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Huan no quijtoa toteco ijcuín: “Nejua no nitatacamati ten nechnajnahuatíaj. Huan nejua no niquinnajnahuatía nosoldados ma nechtacamatican. Huan nicnahuatía se soldado que ma xiyó, huan yejua yohui. Huan nicnahuatía ocsé soldado que ma xihuiqui, huan yejua huitza. Huan no cuac nicnahuatía notaquehual que ma quichihuati tensá tequit, ijcuacón yejua quichihuas”. ");
INSERT INTO azzNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Huan cuac Jesús quicayic nijín tajtolis, ijcuacón Yejuatzin quimoucacaquic huan moicancuepac huan quiniliaya in tagayot ten cualtoctiliayaj ijcuín: ―De yec melau ten namechilía que intzalan nochi ne pueblojuani de Israel amo aquen nicajsic ten quipía in yec tacuautamatilis queme quipía nijín tayecanque soldado romano. ");
INSERT INTO azzNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Huan cuac ne tenotzani yajque mocuepque ya ninchan, ijcuacón yejuan cajsito ne taquehual pajtic ya. ");
INSERT INTO azzNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Huan mochihuac que satepan Jesús yajqui ajsito campa se pueblo ten monotzaya Naín. Huan quisehuicayaj huan quiyehualojtiayaj imomachtijcahuan de Jesús huan no huel míac tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Huan cuac Jesús ajsitiaya ya tech ne pueblo Naín, ijcuacón quitac que sequi tagayot cuicayaj se ánimajtzin quitalpachotij. Huan ne ánima catca iyotzin conetzin de ne sihuacahual. Huan no míac pueblojuani de Naín quisehuicayaj ne ánima. ");
INSERT INTO azzNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Huan cuac Jesús quitac ne sihuacahual, ijcuacón Yejuatzin semi quiyolicnelij huan quilij ijcuín: ―Amo ximochocti oc. ");
INSERT INTO azzNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ijcuacón Jesús motoquito campa ne ánima huan de ompa quimatocac ne ánimajcajon. Huan ijcón moquetzque ne naquen quimamajtiayaj in ánimajcajon. Ijcuacón Jesús quilij ne ánima ijcuín: ―Tejua telpoch, nimitzilía, ximehua. ");
INSERT INTO azzNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ijcuacón ne telpoch ten micca ya, yejua ne mehuiticatalij huan pehuac tajtoa. Huan ijcón Jesús ocsepa quimactilij ne inan. ");
INSERT INTO azzNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Huan cuac in tagayot quitacque nochi nijín, ijcuacón yejuan mohueyimoucaitacque. Huan de ompa peuque quimohuistiliayaj Totajtzin Dios huan no quijtoayaj ijcuín: ―Se hueyi tanahuatijque de Dios hual quisac ya totzalan. Huan no Totajtzin Dios hual temoc ya para techpalehuis tejuan tiipueblojcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Huan motetapohuij de ichicaucahuelilis de Jesús tech nochi pueblojme ten itatilanal Judea huan tech nochi pueblojme ten quiyehualojtoyaj Judea. ");
INSERT INTO azzNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Huan in imomachtijcahuan de Juan Taahuijque, yejuan nojonques quimatiltijque in Juantzin de nochi ten Jesús quichiutinemic. Ica ya nojón in Juan Taahuijque quinnotzac ome imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Huan Juan quintitanic ne imomachtijcahuan campa yetoya Jesús. Huan yejuan quitajtoltijque Jesús ijcuín: ―¿Cox melau Tejuatzin Ti Cristo tanahuatijque de Dios ten hualasquía? ¿Oso cox ticchiasque oc ma huiqui ocsé tanahuatijque oc de Dios? ");
INSERT INTO azzNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ijcuacón imomachtijcahuan de Juan motoquijque campa yetoya Jesús huan quilijque ijcuín: ―¿In Juan Taahuijque techualtitanic para ma timitztajtoltican cox Tejuatzin ya ti Cristo Temaquixtijque ten hualasquía? ¿Oso cox monequi ticchiasque ocsé oc tanahuatijque ma huiqui? ");
INSERT INTO azzNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Huan tech nojón hora cuac ejcocque imomachtijcahuan de Juan, ijcuacón Jesús pehuac quinpajtiaya míac cocoyani de nincocolisuan huan de ninchiahuisuan. Huan no Jesús quincalanquixtiliaya in amocuali ejecame. Huan no quintachialtiaya miacque ixpojpoyome. ");
INSERT INTO azzNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ica ya nojón Jesús quinanquilij neimomachtijcahuan de Juan ijcuín: ―Huan axcan xiyacan ya huan xicmatiltitij in Juan de nochi notachilisuan ten namejuan nanquitacque ya huan nochi ten nanquicacque ya. Huan no xictapohuican de queniu nanquitacque que in ixpojpoyome Nejuatzin niquintachialtij ya. Huan in coxojme axcan niquinnejnemiltij ya. Huan in necocoyani ten cocotocatoya ninacayo, axcan Nejuatzin niquinchipahuac ya huan niquinpajtij ya. Huan naquen amo tacaquía, yejuan axcan niquintacaquiltij ya. Huan in taca ten momiquilijcaj ya, axcan niquinpanquixtij ya yoltocque. Huan neques ten ixnestinemij que pobres huan amo teyi chihuanime, yejuan nojón niquinnextilijtoc in yancuic Tajtoltzin de Dios ten cualcui ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ica ya nojón tatiochihualme de Dios nochi neques de amo quitahuelcaquij huan amo moyolxocolíaj cuac quicacquij notajnojnotzalis. ");
INSERT INTO azzNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Huan cuac yajque ya imomachtijcahuan de Juan Taahuijque, ijcuacón Jesús pehuac quinnojnotza in tagayot de toni chiuque ne Juan Taahuijque. Huan Jesús quiniliaya ijcuín: ―¿Toni nanquitatoj campa ne Juan tanojnotzayaj nepa campa tayiucan? ¿Xe nanquisque para nanquitatoj se tagat ten yolmoucat ten quinejnehuilía queme acaselot ten nepa huan nepa cuihuica in ejecat? ");
INSERT INTO azzNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Huan como amo ijcón nancajsique, ¿toni nanquitatoj? ¿Xe nanquisque para nanquitatoj ne tagat ten taquentoc ica tilma ten semi cualtzin? Xiquitacan san, namejuan nanquimatij ya que neques ten motaquentíaj huan mocualnextíaj ica cuajcuali taquenme, yejuan nojonques yetocque sayó campa in inchanuan de huejueyime tayecanani reyes huan ompa mopaquiltijtinemij ica míac tataman tanejnequilis. ");
INSERT INTO azzNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Huan como amo ijcón nancajsisque, ¿cachi oc toni nanquisque para nanquitatoj? ¿Xe nanquisque para nanquitatoj se tanahuatijque de Dios? Quema, ijcón melau nanquitatoj. Huan no namechilía que ne Juan Taahuijque, yejua ya in cachi hueyi chiuque huan que nochi in ocsequin tanahuatiani de Dios ten nemicoj ya. ");
INSERT INTO azzNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Porín tajtoa tech in Tajcuilolamatzin de Dios que Yejuatzin quinojnotztoc Cristo Temaquixtijque de ne Juan Taahuijque huan quijtoj ijcuín: “Xiquitacan san, Nejuatzin nictitani se notanahuatijcau huan yejua mitzachtohuijtiyás para mitzyejyectalilijtiyás moojpan”. ");
INSERT INTO azzNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Huan de yec melau no namechilía que amo aquen ongac ocsé cachi hueyi chiuque de nican talticpac. Ta, sayó ne Juan Taahuijque. Pero axcan se tagat ten amo hueyi chiuque ten motemactij imaco Jesús ma Yejuatzin quiyecana inemilis, yejua ne cachi hueyi tatiochihualis quiselijtiyás huan que ne Juan Taahuijque quiselij. Huan axcan ne Juan Taahuijque amo hueyi chiuque oc. ");
INSERT INTO azzNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ijcuacón nochi in tagayot tacaquini huan nochi in tatopaluiani ten quicacquilijtoyaj Jesús, nochi yejuan moteahuiltijque ihuan Juan porín cajsicamatque que yejuan tajtacolejque iixpantzinco Totajtzin Dios. Huan ijcón yejuan quichiuque porín quiyolnemilijque que Totajtzin Yolmelahuactzin huan quinamiqui ma quichihuacan nochi ten Yejuatzin tanajnahuatía. ");
INSERT INTO azzNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Pero neques tamatinime fariseos huan in tanextiliani den tanahuatil de Moisés, nochi yejuan amo moteahuiltijque ihuan Juan huan no amo cajsicamatque que cox yejuan tajtacolejque. Ica ya nojón yejuan quixtopeuque nochi in tapalehuilis tenica Totajtzin Dios quinequía quinmaquixtis. ");
INSERT INTO azzNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Huan Jesús quinmachtij in tagayot ica nijín nexcuitil ijcuín: ―Huan, ¿toni niquinnejnehuililtía in tagayot ten nijín tonalme nemij? ¿Queniu tamati ninnemilispan? ");
INSERT INTO azzNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","In tagayot ten axcan nemij niquinnejnehuililtía queme coneme ten motalijtinemij tech in plaza huan tzajtzitinemij ihuan ocsequin coneme ten ninuan mahuiltijtinemij. Huan senme de ne coneme quilisque ocsequin ijcuín: “Tejuan ticnequíaj namohuan timahuiltisque, huan ticnequíaj tejuan tamechtatzotzoniliayaj huan no tamechtapichiliayaj, pero namejuan amo nanquinecque tohuan nanmijtotisque. Huan no tamechcantarohuiliayaj ica ocsequin canciones ten tetayocoltía. Pero namejuan amo nanchocacque”. Huan no Jesús quinilij in tagayot ijcuín: ―Ijcón queme ne coneme sayó teijitojtinemíaj, namejuan sayó nantatejtehuanime san. ");
INSERT INTO azzNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Porín cuac huala Juan Taahuijque, ijcuacón yejua ne amo tel tacuaya nión tayaya ne vino queme namejuan. Ica ya nojón namejuan nanquijtojque que ne Juan quipíaya iyolijtic se amocuali ejecat. ");
INSERT INTO azzNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Huan cuac Nejuatzin nihuala ya, Nejuatzin ni Yectagatzin de Dios, ijcuacón nitacuaya huan nitayaya vino. Huan no ijcón namejuan nannechijtohuiliayaj ijcuín: “Xiquitacan san ne tagat Jesús, yejua ne tel tacua huan tel tayitinemi vino huan no ihuan motasojtatinemi neques ten tatopaluiani huan no motasojtatinemi ihuan neques ten amo quitacamatij in tanahuatilme de Moisés”. ");
INSERT INTO azzNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Huan in Tajtoltzin de Dios technextiliaya ijcuín: “Dios itanemililis monextijtiyás tech in chipaucanemilis de nochi neques ten tacuautamatij ihuan Dios”. ");
INSERT INTO azzNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Huan senme den tamatinime fariseos quiyolehuac Jesús que ma tacuati ichan. Huan melau in Jesús yajqui ichan ne fariseo huan motalito campa yetoya mesa. ");
INSERT INTO azzNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Huan mochihuac que se sihuat ahuilnenque calyetoya tech ne mismo pueblo campa yetoya Jesús. Huan cuac in sihuat quitecaquilij que Jesús yajqui tacuato ichan ne fariseo ten monotza Simón, ijcuacón ne sihuat yajqui huan cuiyac se contzin ten temitoya ica sequi aceite ten cualtzin ajuiyac. ");
INSERT INTO azzNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Huan ijcón in sihuat motoquij campa Jesús imetznacastan huan ompa pehuac choca huan hasta ica iixayo quimetzapachoaya Jesús. Huan de ompa pehuac quimetzuajuatza ica itzon. Huan ijcón quitenamiquía imetzuan Jesús huan quimetzojxiliaya ica aceite ne ten cualtzin ajuiyac. ");
INSERT INTO azzNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Huan ne fariseo ten quiyolehuac Jesús ma tacuati ihuan, cuac yejua ne quitac toni quichihuac ne sihuat, ijcuacón yejua pehuac quiyolnemiliaya ijcuín: “Tacán nijín tagat Jesús yec melau yesquía se tanahuatijque de Dios, ijcuacón yejua momacasquía cuenta aconi ne sihuat ten quimetzmajmatocatoc, huan no quimatisquía toni nemilis cuicatinemi ne sihuat, que yejua se sihuaahuilnenque”. ");
INSERT INTO azzNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ijcuacón in Jesús quilij ne fariseo ijcuín: ―Tejua Simón, nicnequi nimitzilis se taman tajtol. Huan in fariseo quinanquilij ijcuín: ―Xinechonili motamachilis. ");
INSERT INTO azzNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Huan ijcón Jesús quinextili ica nexcuitil ijcuín: ―Ome taca quitahuiquiliayaj se tataneutijque ica tomin. Huan senme de nojón taca quitahuiquiliaya macuil ciento denario de tomin, yejua in taxtahuil para macuil ciento tonal tequit quixtahuasquía. Huan in ocsé tagat quitahuijuiliaya sayó tajco ciento denario, yejua in taxtahuil para omepoal huan májtacti tonal tequit. ");
INSERT INTO azzNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Huan queme nojón taca amo huelíaj quitaxtahuilisque ne tomin tataneutijque, ica ya nojón yejua in tataneutijque quintapojpoluij, huan ijcón quincahuilij nintahuicalis. Huan axcan semi nicnequi xinechili, de ne ome taca quiyoltasojtasque ne tomin tataneutijque, ¿catiyejua cachi quiyoltasojtas? ");
INSERT INTO azzNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Huan ne Simón quinanquilij Jesús ijcuín: ―Pues, nejua niquixejecoa que yejua ne tagat ten cachi quitahuiquiliaya ne iteco, yejua ne cachi quitasojtac ne tomin tataneutijque. Ica ya nojón Jesús tananquilij ijcuín: ―Yec melau ten tiquixejcoa. ");
INSERT INTO azzNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ijcuacón in Jesús connacascaitac in sihuat huan quilij in Simón ijcuín: ―¿Xe amo tiquita nijín sihuat? Cuac nejua nicalaquico nican mochan, ijcuacón tejua amo tinechmactilij at tenica nimometzpajpacasquía. Pero nijín sihuat nechmetzapachoj ica iixayo huan nechmetzuajuatzac ica nitzon. ");
INSERT INTO azzNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Huan no cuac nicalayic nican mochan, ijcuacón tejua amo tinechtennamiquic para nechtajpalos. Pero nijín sihuat amo mocahua de amo quitennamiquis nometzuan. ");
INSERT INTO azzNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Huan no cuac nicalayic, ijcuacón tejua amo tinechcuaojxilij aceite, pero nijín sihuat, quema, nechmetzojxilijtoc aceite ten ajuiyacayot. ");
INSERT INTO azzNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ica ya nojón nimitzilía que nijín sihuat yejua tapojpoluil ya de Dios de nitajtacoluan, masqui yejua quichiutinemic míac tajtacoluan. Ica ya nojón yejua cachi nechtasojta. Pero se tagat ten amo quiyolmachilía que cox tajtacole, yejua nojón tepitzin san monequi ma nictapojpoluía. Huan como tepitzin nictapojpoluis, ica ya nojón ne tagat tepitzin nechtasojta. ");
INSERT INTO azzNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ijcuacón Jesús quilij in sihuat ijcuín: ―Motajtacoluan nimitzintapojpoluilij ya. ");
INSERT INTO azzNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Huan neques ten tocotziutoyaj ihuan Jesús campa tacuajtoyaj, yejuan nojonques peuque moiliayaj se huan ocsé ijcuín: ―¿Toni chiuque nijín tagat ten quinemilía que huelis quintapojpoluis in tajtacol den tagayot? ");
INSERT INTO azzNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero Jesús ocsepa quilij in sihuat ijcuín: ―Huan queme titacuautamatic ya nohuan, ica ya nojón Dios mitzmaquixtij ya. Huan axcan xiyó ya xinemiti ya ica ne hueyi yolsehuilis de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Huan mochihuac que satepan cuac Jesús quisac ichan Simón, ijcuacón Yejuatzin panotiaya campa miacque pueblojme huan hasta no miacque pueblojtzitzin. Huan ompa Jesús tanojnotztinemía huan quintapohuiaya in tagayot ten Tajtoltzin de Dios ten techmachtía de queniu Dios techyolyecantinemi ica ihueyichicahualis. Huan in majtactiomome imomachtijcahuan quisehuicayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Huan no quisehuicayaj Jesús sequin sihuame ten Jesús quincalanquixtilij ya in amocuali ejecame huan ten Jesús quinpajtijca ya de nincocolisuan. Huan ompa tatzalan yaya in María ten monotzaya Magdalena, ten Jesús quicalanquixtilijca chicome amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Huan no tatzalan yaya in Juana, yejua isihuau de Chusa ten itayecancataquehual den rey Herodes. Huan no quisenhuicayaj Jesús in Susana huan ocsequin miacque sihuame. Huan yejuan ica nintomin quinpalehuijtinemíaj Jesús huan imomachtijcahuan ica ten mopialiayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Huan míac pueblojuani quisque huan quitatoj Jesús. Huan cuac mosentilijque míac tacaquini, ijcuacón Jesús pehuac quinnojnotzac ica se nexcuitil huan quiniliaya ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","―Se tonal se tagat quisac para quitepehuas in tatoc de trigojtet. Huan cuac quitepehuac ya, ijcuacón mochihuac que cansaica huetzic in tatoc ojtenteno. Huan ijcón quitzojtzonicsacque huan hualajque in tototzitzin ten patantinemij ejecaixco huan quicuacoj. ");
INSERT INTO azzNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Huan ocsecan cansaica huetzic in tatoc de trigo campa ongac míac tet. Ica ya nojón cuac panquisac ya ne tatoc, ijcuacón huayic in tatoc porín amo quipiayaj cuechahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Huan ocsecan cansica huetzic in tatoc de trigojtet huitzalan. Ica ya nojón in huitzti ixuac itzalan in tatoc huan quipachoj. ");
INSERT INTO azzNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Huan ocsecan cansaica huetzic in tatoc de trigojtet campa cualital. Huan ompa ixuac huan quitemacac míac taquilome hasta motaquiltij se ciento taquilome de se tatoc san. Huan cuac Jesús quintamiilij nijín nexcuitil, ijcuacón Yejuatzin ocsepa quinchicaucailij ijcuín: ―Naquen quipía inacasuan para tacaquis, ma yec tacaqui huan ma cajsicamati nijín tanextililis. ");
INSERT INTO azzNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ijcuacón imomachtijcahuan de Jesús quitajtoltijque Yejuatzin ijcuín: ―¿Toni quijtosnequi nijín nexcuitil ten titechonnextilij ya? ");
INSERT INTO azzNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Huan ijcón Jesús quinnanquilij ijcuín: ―Dios namechmatiltijtoc ya namejuan nannomomachtijcahuan de ne tamachilisme ichtacapachiutoya de queniu Dios namechyolyecantinemi ica ihueyichicahualis. Pero in ocsequin tagayot ten amo poutinemij ihuan Dios, yejuan nojonques Dios amo quinajsicamatiltis. Huan yejuan nojonques niquinmachtía ica nexcuitilme para ma yejuan ma amo quitacan huan ma amo cajsicamatican notanextililis. Huan como yejuan amo yec taneltocaj, ica ya nojón yejuan masqui quitasque nochicahualisuan, pero amo quimatilisque. Huan no masqui yejuan caquisque notanextililisuan, pero amo cajsicamatisque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Huan nijín nexcuitil den tatepeuque quijtosnequi ijcuín: ―Ne trigojtet, yejua ne in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Huan sequin tacaquini yetocque ojtenteno. Huan ne yejuan quicaquij in Tajtoltzin de Dios. Pero huitza in amocuali Satanás huan quinajchihuilía in Tajtoltzin de Dios tech ninyolijtic para ma amo quiyecneltocacan in Tajtoltzin de Dios, huan para ma amo maquisacan den nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Huan ocsequin trigojtet huetzic campa tejteixco trigojtet. Huan ne, yejua ne no quinejnehuilía sequin tacaquini den Tajtoltzin de Dios. Huan yejuan niman quiselíaj in Tajtoltzin de Dios ica míac paquilis. Pero queme yejuan ayamo quipíaj cuali tacuautamatilis queme yesquía se naluat ten huejcatan totoc, ica ya nojón yejuan tacuautamatinemij sequin tonalme san. Huan cuac nintech ejcoc ya in tajyohuilis, ijcuacón yejuan niman moyolxocolíaj huan quisecocahuaj in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Huan ocsequi trigojtet huetzic huitzalan. Huan ne tatoc ten huetzic huitzalan, yejua ne quinejnehuilía ocsequin tacaquini ten Tajtoltzin de Dios. Huan yejuan quisentocaj tech mismo ninnemilispan queme ipa. Huan moyolcuejmolojtinemij oc ica míac tenesi. Huan quinyoltilantoc oc in ricojyot. Huan no mopaquiltijtinemij oc tech nintanejnequilis. Ica ya nojón amo quitacahuilíaj in Tajtoltzin de Dios ma moscalti huan ma cuica taquilome. ");
INSERT INTO azzNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Huan ocsequi trigojtet huetzic tech cualital. Huan ne tatoc ten huetzic campa cualital, yejua ne quinejnehuilía ocsequin tacaquini den Tajtoltzin de Dios. Huan yejuan quicaquij in Tajtoltzin de Dios porín yolyemanque huan porín quimachilíaj se yoltanejnequilis de quiselitiyasque in Tajtoltzin de Dios. Ica ya nojón yejuan mopixtolijtinemij in Tajtoltzin de Dios huan quisentocaj tacuautamatiyohue. Huan ijcón yejuan quitemacatiyohue huel míac taquilome. ");
INSERT INTO azzNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Huan no Jesús quinmachtiaya imomachtijcahuan ijcuín: ―Amo aquen quixotaltía se tahuil para niman quipantzacuas ica se contzin. Huan amo no se quitalis in tahuil tatampa in cama. Ta, se quixotaltía ne tahuil huan se quitalía campa tasempayan para ijcón naquen calaquisque calijtic, yejuan nojonques cuali tachiasque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Porín amo ongac teyi tejsá nexcuitil de Dios ten mocahuas ichtacayot san. Ta, yejua ne quipía de que ixnesis. Huan amo no ongac tejsá nexcuitil de Dios ten motatijtihualaya de que ma amo quipía de que monextis huan quimatisque nohuiyampa. ");
INSERT INTO azzNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Xictalican cuidado huan ximoyecaquiltican nijín tajtol. Porín nochi neques ten quipíaj in tamachilis de Dios huan quitequitiltíaj, yejuan nojonques cachi oc Dios quinmactilis. Pero ocsequin tacaquini quipíaj tzictzin san tamachilis de Dios huan amo quitequitiltíaj in tepitzin san ten quipíaj. Ica ya nojón yejuan nojonques Dios quintamicuilis ne tepitzin ten yejuan quinemilía que quipixtinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ijcuacón inantzin de Jesús huan iicnihuan ajsicque campa yetoya Jesús. Pero yejuan amo huelíaj cajsitihue Jesús porín huel míac tagayot quintzajtzacuiliayaj Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Pero se acsá quinejmachtij Jesús ijcuín: ―Monantzin huan mocnihuan yetocque ne calan huan yejuan quinequij mitzitasque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ijcuacón Jesús tananquilij ijcuín: ―Xiquitacan ca cuali huan xicmatican que Nejuatzin niquinpohua queme nonantzin huan queme nocnihuan nochi neques ten quicaquij huan quitacamatinemij in Tajtoltzin de Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Huan mochihuac que se tonal calayic Jesús tech se barco ihuan imomachtijcahuan huan quinilij ijcuín: ―Ma ticpanocan ne sentapalpa de nijín hueyíat. Huan melau ijcón quichiuque huan yajque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Huan cuac nejnentoyaj ya in barco apanotoya ya, ijcuacón mochihuac que Jesús pehuac cochi. Huan de ompa pehuaco se tetzaucaejecat huan chicahuac taejecaya tech in hueyíat. Ica ya nojón pehuac in at calaqui tech in barco huan pexontihualaya ya. Ica ya nojón tamahuilil ya para pancalaquis in barco. ");
INSERT INTO azzNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ica ya nojón imomachtijcahuan yajque quijxititoj Jesús huan quilijque ijcuín: ―Totamachtijcau, totamachtijcau, xiquita que tipolihuitij ya. Ijcuacón Jesús ixpetanic huan quitacahualtij ne tetzaucaejecat huan in hueyíat ten mocuentecaya. Huan ijcón niman nochi motatamatilij huan in hueyíat mocahuac ijcón amanis. ");
INSERT INTO azzNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ijcuacón Jesús quinilij imomachtijcahuan ijcuín: ―¿Can yetinemi namotacuautamatilis? Huan ijcón ne imomachtijcahuan mohueyiyolmoutiayaj huan quimoucaitacque ten quichihuac Jesús. Ica ya nojón yejuan motajtoltiayaj se huan ocsé ijcuín: ―¿Toni chiuque nijín tagat? Porín yejua quinahuatij ne ejecat huan ne hueyíat huan yejuan quitacamatque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Huan ijcón Jesús huan imomachtijcahuan ajsitoj ne sentapalpa de hueyíat campa calyetoya in pueblojuani de Gadara atenteno den hueyíat Galilea. ");
INSERT INTO azzNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Huan cuac Jesús temoc talixco ya den barco, ijcuacón quinamiquico Jesús se tagat den pueblojcat de Gadara. Huan yejua desde míac tonalme ya quipiaya iyolijtic miacque amocuali ejecame. Huan ne tagat amo taquentinemía huan nión no calyetinemic calijtic. Ta, yejua nentinemía campa ánimajtecochme. ");
INSERT INTO azzNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Huan ne tagat ten quipiaya in amocuali ejecame, cuac quitac Jesús, ijcuacón chicahuac tzajtzic huan motancuaquetzac iixpan Jesús huan quichicaucailiaya ijcuín: ―Tejua Jesús, ¿toni ticpía nohuan Jesús? Porín Tejuatzin cuali nimitzixmati, Tejuatzin Titeconetzin de Dios in cachi hueyi chiuque. Nimitzteltatautía de que amo xinechtajyohuilti. ");
INSERT INTO azzNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Huan ne amocuali ejecat quijtoayaj ijcón porín Jesús ipa quinahuatijtoya ya que ma quisani tech iyolijtic de ne tagat. Huan desde míac tonalme neamocuali ejecat quiquitzquiaya huan quiyojyolpolihuiltij ne tagat. Ica ya nojón in pueblojuani quitzacuacaj huan quimatzijtzicojcaj huan quimetztzijtzicojcaj ica tepos cadena para ijcón amo huelis cholos. Pero ipa ne tagat quicojcotonaya ne tepos cadenas huan in amocuali ejecat quinejnemiltij in tagat huan quichololtij hasta campa taseltijcan. ");
INSERT INTO azzNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ijcuacón Jesús quitajtoltij ne amocuali ejecat ijcuín: ―¿Toni motocay? Huan in amocuali ejecat quinanquilij ijcuín: ―Notocay yej nijín, Telmiacque. Huan ijcón tananquilij porín míac amocuali ejecame calacaj iyolijtic ne tagat. ");
INSERT INTO azzNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Huan ijcón ne amocuali ejecame nocta motatautiayaj ihuan Jesús que ma amo quintitani tech ne campa hueyi tecoch den tatzacuiltilispan. ");
INSERT INTO azzNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Huan queme ompa tacuajtinemíaj tech nojón ixtahuat huel míac pitzome, ica ya nojón ne amocuali ejecame quitatautilijque Jesús que ma quincahuani ma calaquican intech nojón pitzome. Huan ijcón Jesús quintacahuilij. ");
INSERT INTO azzNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ica ya nojón ne amocuali ejecame quisque itech iyolijtic ne tagat huan calaquitoj intech ne pitzonme. Huan ijcón ne huel míac pitzonme motalojtinenque huan motaquesuijque huan huetzitoj tech in hueyíat huan ompa nochi moaelsimijque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Huan neques ten tapiayaj ica ne pitzonme cuac quitacque toni mochihuac ya, ijcuacón yejuan moucacholojque huan yajque quintapohuitoj inpueblojcahuan tech in pueblo huan tech nintequipan de toni mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ijcuacón in pueblojuani quisque huan yajque quitatoj de toni mochihuac. Huan cuac yejuan ajsique campa yetoya Jesús, ijcuacón no ompa cajsitoj ne tagat ten Jesús quincalanquixtilij ya ne amocuali ejecame. Huan ne tagat cajsitoj tocotzyetoc iixpan Jesús huan taquentoc ya huan cuatamatoc ya. Ijcuacón ne pueblojuani mohueyiyolmoutijque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Huan ijcón ne tapiani ten quitacque toni mochihuac ya, yejuan nojonques quitapohuijque in ocsequin pueblojuani de queniu Jesús quipajtij ne tagat ten quinpiaya iyolijtic ne amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ica ya nojón nochi in pueblojuani de Gadarajcopaca peuque quitatautíaj Jesús ijcuín: ―Xiquisa ca cuali de nican topueblojcopaca. Huan ijcón quijtocque Jesús porín yejuan mohueyiyolmoutiayaj. Ica ya nojón in Jesús calayic tech se barco huan yajqui ocsepa mocuepac campa hualehuac. ");
INSERT INTO azzNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Pero achtopa que Jesús yajqui tech in barco, ne tagat ten Jesús quincalanquixtilijca ya in amocuali ejecame, yejua ne quitatautij Jesús que ma quitacahuili oc ma ihuan Jesús nentinemi oc. Pero Jesús quinahuatij que ma yohui ma mocuepati campa pohui huan no quilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","―Xiyó xiyetoti ocsepa ihuan mochancahuan huan ompa xictetapohuiti nochi ten Dios quichihuac ya para tejua. Huan ijcón yejua yajqui ichancopaca huan ompa pehuato quintapohuía nochi in pueblojuani de nochi in chihualisme den Jesús quichihuac ipan. ");
INSERT INTO azzNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Huan cuac Jesús Temaquixtijque ejcoc ya sentapalpa den hueyíat campa quisteuca ya, ijcuacón in tagayot quitajpalojque huan quiselijque ica míac paquilis. Huan nijín ijcón quichiuque porín ipa yejuan quichixtoyaj Jesús ma hualani. ");
INSERT INTO azzNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ijcuacón ejcotihuetzico campa Jesús yetoya se tagatzin ten monotza Jairo ten yejua catca tayecanque tech in tiopan de judíos. Huan nijín tagat Jairo motancuaquetzaco iixpan Jesús. Huan quitatautij Jesús ma yohui ichan. ");
INSERT INTO azzNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Huan nijín ijcón quitatautij porín quipiaya se iyojtzin sihuapil ten quipiaya majtactiomome xihuit. Huan yejua imiquilistempa yetoya. Huan cuac yaya ya Jesús, ijcuacón huel míac tagayot quitoctiliayaj hasta quipejpechiayaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Huan ompa cualtoctiliaya Jesús se sihuat ten mococoaya esmeyaya, pues cuicaya majtactiomome xihuit. Huan semi tajyohuiaya huan míac tepajtiani ya mopapatacque ya. Huan nochi nitomin quitamilijcaj ya. Huan amo se tepajtijque huelic quipajtij. ");
INSERT INTO azzNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ica ya nojón ne sihuat motoquito icampa Jesús huan quinalmatoquilij itilmajtzin de Jesús. Huan huel se tepitzin tzicahuic nojón esmeyalis. ");
INSERT INTO azzNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ijcuacón Jesús matajtanic ijcuín: ―¿Aconi nechicanmatocac? Huan queme nochi quiliayaj que amo aquen quimatocayaj Jesús, ica ya nojón Pedro huan itequiticaicnihuan quilijque Jesús ijcuín: ―Totamachtijcau, xiconita san míac tagayot mitzpejpechíaj huan mitztojtopehuaj. Huan quenín huelis Tejuatzin tiquijtoa ijcuín: “¿Aconi nechicanmatocac?” ");
INSERT INTO azzNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Huan Jesús quinnanquilij ijcuín: ―Acsá nechmatocac porín nicmachilij que quisac nochicahualis huan pajtic ya acsá ica ne chicahualis cuac nechmatocac. ");
INSERT INTO azzNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Huan cuac in sihuat quimatic que amo huelis oc quitatis ten quichihuac, ijcuacón yejua moajsicamoutiaya hasta huihuiyocaya huan motoquico campa Jesús yetoya. Huan motancuaquetzac iixpan Jesús huan quiyectetapohuiaya senteixteno in tagayot de queyé quimatocac Jesús huan de queniu ichicahualis de Jesús nimantzin sepa san quipajtij. ");
INSERT INTO azzNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ijcuacón Jesús quilij in sihuat ijcuín: ―Tejua sihuatzin, ica por nojón motacuautamatilis ten ticpía, tipajtic ya. Axcan xiyó ya xiyolseutiu. ");
INSERT INTO azzNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Huan mientras Jesús quinojnotztoya oc in sihuat, ijcuacón ejcoc senme de ichancahuan de ne Jairo ten tayecanque den tiopan de judíos. Huan ne ichancahuan quilijque in Jairo ijcuín: ―Mosuapil miyic ya. Amo xicuejmolojto oc in Tamachtijque. ");
INSERT INTO azzNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Huan cuac Jesús quicaquic ne tajtolme, ijcuacón Yejuatzin quilij Jairo ijcuín: ―Amo ximoyolmouti. Ta, sayó xitacuautamati nohuan huan ijcón mosihuapiltzin pajtis. ");
INSERT INTO azzNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Huan cuac Jesús ajsic ya ichan Jairo, ijcuacón Yejuatzin amo aquen quitacahuilij ma calaquiti ihuan. Ta, sayó quintacahuilij ma calaquitij in Pedro huan in Jacobo huan in Juan huan in tetat huan inantzin den sihuapiltzin. ");
INSERT INTO azzNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Pero nochi in ichancahuan chocatoyaj huan moyolcocojtoyaj ica por ne sihuapil ten miyic ya. Pero Jesús quinilij ijcuín: ―Amo semi ximochoctican. Porín nijín sihuapiltzin amo miyic. Ta, sayó cochtoc. ");
INSERT INTO azzNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Pero ne ichancahuan de Jairo quiquejqueloayaj Jesús porín yejuan quimatque que ipa miyic ya in sihuapil. ");
INSERT INTO azzNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Huan ijcón Jesús quimatilanac in sihuapil huan quilij ica chicaucatajtol ijcuín: ―Sihuapil, nimitzilía que ximehua. ");
INSERT INTO azzNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ijcuacón ne sihuapil ocsepa quiselij nitalnamiquilis huan ijcón nimantzin moquetzac. Huan Jesús tanahuatij ma quitamacacan. ");
INSERT INTO azzNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Huan itatuan den sihuapil quihueyimoucaitacque ten mochihuac. Pero Jesús quinnahuatij que ma amo aquen quilican de toni mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Huan Jesús Temaquixtijque quinsentilij secosan nochi in majtactiomome imomachtijcahuan huan no quinmajmactilij in tanahuatil huan in chicahualis para huelis quincalanquixtijtinemisque nochi tataman den amocuali ejecame. Huan no quinmactilij tanahuatil para huelis quinpajtisque nochi tataman cocolisme. ");
INSERT INTO azzNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Huan no Jesús quintitanic imomachtijcahuan ma tanojnotzatij ica in Tajtoltzin de queniu Dios quinyolyecantinemi itaneltocacahuan ica ihueyichicahualis. Huan no Jesús quintitanic ma quinpajtitij in cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Huan no Jesús quinilij ijcuín: ―Amo teyi ximohuiquilican cuac nanyasque ya tech in ojti ica nanmopalehuisque. Amo ximohuiquilican nión namotopil, huan nión namomorral, huan nión namotaxcal huan nión namotomin. Huan amo no ximohuiquilican ojome namocamisa. Ta, sayó ximohuiquilican se san. ");
INSERT INTO azzNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Huan campa yesqui nanajsisque tech se cali, ijcuacón ompa ximocahuacan hasta in tonal cuac nanquisasque de ne pueblo. ");
INSERT INTO azzNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Huan campa amo namechselíaj ca paquilis, ijcuacón xiquisacan de nojón pueblo. Huan ximometztzejtzelocan ma huetzi nochi ne talnex ten mopiloj namometztampa para ma ijcón ixnesis que Dios quintatzacuiltis nijín pueblojuani porín yejuan quixtopeuque in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ijcuacón imomachtijcahuan de Jesús quisque huan yajque panotiyajque tech nochi in pueblojtzitzin huan quintapohuiayaj in pueblojuani den Tajtoltzin de Dios ten cualcui ne nemaquixtilis. Huan no quinpajtiayaj cocoyani nohuiyampa. ");
INSERT INTO azzNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Huan ijcón in rey Herodes quimatiltijque de nochi ten quichiutinemía in Jesús Temaquixtijque. Huan ne Herodes hasta amo quimatía oc toni quinemilis ica por ne Jesús. Porín sequin tagayot quijtoayaj que in Juan Taahuijque panquisac yoltoc ya intzalan in ánimajme huan yejua quichiutinemía nijín mohuiscatequeme. ");
INSERT INTO azzNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Huan ocsequin tagayot quijtoayaj que in Elías, ne huejcau tanahuatijque, yejua ne ocsepa monextico huan yejua axcan quichiutinemía nijín mohuiscatequime. Huan cachi ocsequin tagayot quijtoayaj que achá se huejcautanahuatijque de Dios panquisac ya yoltoc intzalan in ánimajme huan achá yejua ne quichiutinemía nijín mohuiscatequime. ");
INSERT INTO azzNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Pero in rey Herodes quijtoj ijcuín: ―Amo melau nochi nojón ten quijtoaj. Ta, nicmati que nejua san nitatitanic ma quiquechcotonati ne Juan Taahuijque. Pero ne Jesús, ¿toni chiuque yejua ten nechcaquiltíaj huan nechtapohuíaj de nochi míac tataman de nitequihuan? Ica ya nojón in rey Herodes quinequía quitas huan quinojnotzas Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Huan cuac itanahuatijcahuan de Jesús mocuepque campa hualeuque, ijcuacón quitapohuijque Jesús nochi ten yejuan quichiuque. Huan cachi satepan Jesús quincuiteu imomachtijcahuan huan yajqui campa chicopayan huan nepa campa ajsique amo huejca quitztoya in pueblo Betsaida. ");
INSERT INTO azzNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Pero cuac in pueblojuani quitecaquilijque que ompa yetoya Jesús, ijcuacón yejuan yajque quitoctilitoj Jesús. Huan ijcón Jesús quinselij ca paquilis in tagayot huan de ompa pehuac quinnojnotzaya ica in Tajtoltzin de queniu Dios quiyolyecantinemi itaneltocacahuan ica ihueyichicahualis. Huan no Jesús quinpajtiaya in cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Huan cuac tepeten ya in tonaltzin, ijcuacón in majtactiomome imomachtijcahuan motoquijque campa Jesús huan quilijque ijcuín: ―Xiquinnahuati ya in tagayot ma yacan ma mosehuitij ya, huan ma quitemotij nintacualis tech in pueblojtzitzin huan tech in milajpa porín nican campa tiyetocque amo teyi ongac tacualis. ");
INSERT INTO azzNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Pero Jesús quinnanquilij ijcuín: ―Xiquintamacacan, namejuan san. Pero yejuan quilijque Jesús ijcuín: ―Huan tejuan ticpíaj sayó macuil pantzitzin san huan ome pescadojnacat san, como amo tiyásque titacohuatihue ica tacualis para tiquintamacacan nochi nijín tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Huan nijín tagayot ten mosentilijca ya catca queme macuil mil. Huan ijcón Jesús quinilij imomachtijcahuan ijcuín: ―Xiquinnahuatican in tagayot ma mosentilican ojomepoal huan májtacti huan ma motalican seseco. ");
INSERT INTO azzNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Huan melau imomachtijcahuan ijcón quichiuque huan in tagayot motalijque seseco. ");
INSERT INTO azzNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ijcuacón in Jesús quicuic huan momaaquic in macuil pantzitzin huan in ome pescados. Huan de ompa Yejuatzin moixajocuic eluiyactzinco huan quitatautij Totajtzin Dios ma quitiochihua in tacualis. Huan cuac Jesús quincojcotonac ya in pantzitzin, ijcuacón Yejuatzin quinmactilij imomachtijcahuan para ma yejuan quinxejxelohuilican in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Huan ijcón nochi in tagayot tacuajque huan ixuique. Huan de ompa imomachtijcahuan quiololojque ocsepa in pantatetejtec ten mocahuac huan quitemitijque majtactiomome chiquihuime ica ne pantatajco. ");
INSERT INTO azzNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Huan se tonal Jesús motatatautilijtoya secan, huan imomachtijcahuan ihuan yetoyaj. Huan mochihuac que Jesús quintajtoltij imomachtijcahuan ijcuín: ―¿Toni quijtoaj in tagayot que niaconi Nejuatzin? ");
INSERT INTO azzNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Huan ne imomachtijcahuan quinanquilijque ijcuín: ―Sequin quijtoa que Tejuatzin ti Juan Taahuijque. Huan ocsequin quijtoaj que Tejuatzin ti Elías. Huan cachi oc ocsequin quijtoaj que Tejuatzin tiacsá den huejcautanahuatijque ten panquisac yoltocque intzalan den ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ijcuacón Jesús ocsepa quintajtoltij ijcuín: ―Huan namejuan, ¿toni nanquixejecoaj que niaconi Nejuatzin? Ijcuacón in Pedro quinanquilij ijcuín: ―Tejuatzin ya tion Cristo Temaquixtijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero Jesús quinchicaucanahuatij imomachtijcahuan que ma amo aquen quiluican que cox Yejuatzin ya in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Huan no Jesús quinilij ijcuín: ―Semi monequi que nejua ni Yectagatzin de Dios ma semi nitajyohuis. Huan in huehuentzitzin huan in tayecanque tiopixcame huan in tanextiliani den tanahuatil de Moisés, nochi nijín tayecanani nechixnamiquisque huan nechtelchihuasque ma nimiqui. Pero ocsepa Nejuatzin nipanquisas niyoltoc intzalan in ánimajme ipan eyi tonalica. ");
INSERT INTO azzNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Huan cachi satepan Jesús quinilij imomachtijcahuan ijcuín: ―Tacán acsá quinequi nechtoctilijtiyás huan nechtacamatiyás, ijcuacón yejua ne monequi ma quicautehua ne tanejnequilis de yejua san, huan ma quixicojtiu in cruztzin ten cualcuis tajyohuilis, huan ma nechtoctilijtiu huan nechtacamatiu. ");
INSERT INTO azzNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Huan nochi neques ten quinequisque moyecpialtisque huan quimaquixtisque ninnemilis, yejuan nojonques quipolosque ninnemilis. Pero nochi neques ten quipolosque ninnemilis tech notequiu, yejuan nojónques cajsisque ninnemilis huan no ne nemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Huan yec melau amo teyi quihueyipías se tagat como moaxcatilis nochi ten ongac nican talticpac huan niman moijtacos huan quipolos nitalnamiquilis. ");
INSERT INTO azzNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Huan tacán acsá mopinaucamati de Nejuatzin huan de Notajtoltzin, ijcuacón Nejuatzin ni Yectagatzin de Dios no nimopinaucamatis de yejua. Huan ijcón mochihuas cuac nimohualuicas ihuan nochi in ángeles ten yolchipauque nican talticpac ica ne ichicaucahuelilis de Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Huan no de yec melau ten namechilía que senme de namejuan de nican nanyetocque noixpan, amo nanmiquisque como amo achtopa nanquitaj que nihualas ya ica ne ihuelilis de Notajtzin Dios de niquinyolyecana notaneltocacahuan ica ihueyichicahualis de Totojtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Huan ipan chicueyi tonalica de nimampa de nijín tanextililis, ijcuacón Jesús quinuiyac in Pedro huan in Juan huan in Jacobo huan yajque tejcotoj tech se tal lomojtzin campa huejcapan para ompa motatatautilisque ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Huan cuac Jesús motatatautiliaya, ijcuacón pehuac mopapata de quenín tamati niixco. Huan itilma pepetacaya huan semi istac mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ijcuacón monexticoj ome taca ten peuque monojnotzayaj ihuan Jesús. Huan nijín ome taca, yejuan in Moisés huan Elías, de ne huejcautanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Huan quinyehualojtoya in cualtziyot de Dios ijcón queme cuac in tonaltzin momeyotiqui. Huan yejuan monojnotzayaj ihuan Jesús de ne tonal cuac monequis tajyohuis Yejuatzin huan miquis tech ne pueblo de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Huan masqui in Pedro huan imomachtijcaicnihuan semi cochisnequía, pero quincau cochilis porín quitacque Jesús icualtziyo huan no quinitilijque incualtziyo de nojón omen taca ten ihuan yetoyaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Huan cuac ne ome taca quicauteutiayaj ya Jesús, ijcuacón in Pedro quilij Jesús ijcuín: ―Totecotzin, semi cualtzin para tejuan que nican tiyetocque. Tajcón ticonmonequiltisquía ma ticchijchihuacan eyi xajcaltzitzin, se para Tejuatzin huan se para Moisés huan ocsé para Elías. Huan Pedro ijcón quijtoa porín amo quimatía oc toni quinilis. ");
INSERT INTO azzNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Huan cuac Pedro quinojnotztoc oc Jesús, ijcuacón quinquemiloco se mixti nochi yejuan. Ica ya nojón in Pedro huan Jacobo moyolmoutijque porín quitayaj que yetoyaj mixtzalan. ");
INSERT INTO azzNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Huan tech in mixti mocayic se tajtolis ten quijtoaya ijcuín: ―Yejuatzin ya nijín Notasojconetzin; xicaquilican ca cuali Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Huan cuac imomachtijcahuan quitamicacque ya ne tajtolis, ijcuacón quitacque que Jesús iselti ya yetoc. Huan ijcón yejuan motamatcatalijque. Huan tech nojón tonalme ne imomachtijcahuan de Jesús amo aquen quintapohuijque nochi ten quitacaj ya. ");
INSERT INTO azzNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Huan imostica cuac Jesús imomachtijcahuan temocque ya de ne tal lomotzin, ijcuacón huel míac tagayot motoquicoj huan cajsitoj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ijcuacón se tagat ten intzalan in tagayot quichicaucatzajtzilij Jesús huan quiliaya ijcuín: ―Tamachtijque, nimitzontatautía que xiyó xiquitati nooquichpil porín sayó yejua noyojtzin conetzin. ");
INSERT INTO azzNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Huan se amocuali ejecat quiquitzquijtoc nooquichpil huan yejua quichihualtía ma tzajtzi huan ma yojyolpolihui huan no ma tenposocquisa. Huan no ne amocuali ejecat quixojxocolía no oquichpil huan amo queman quinequi quitacahuilis. Ta, ocsepa nimampa quitzetzeloa. ");
INSERT INTO azzNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Huan nejua niquinontatautilijca momomachtijcahuan ma quicalanquixtiliani ne amocuali ejecat, pero yejuan amo huelque quichiuque. ");
INSERT INTO azzNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Huan ijcón Jesús quinilij in tagayot ijcuín: ―Namejuan nantacaquini, semi amo nanyectacuautamatij huan amo nanyolcualime. ¿Canachi tonalme quipía de que niyetos oc namohuan? Huan, ¿canachi tonalme oc huelis nitaxicos como amo nanyectacuautamatij nohuan? Huan de ompa Jesús quilij ne tagat ijcuín: ―Nimitzilía, xinechonualcuili nican ne mooquichpil. ");
INSERT INTO azzNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huan cuac in telpoch motoquijtiaya ya iixpan Jesús, ijcuacón ne amocuali ejecat ocsepa quitalpantamotac in telpoch huan quitzejtzeloj huan quiyojyolpolihuiltij. Ijcuacón in Jesús quichiucaucatacahualtij ne amocuali ejecat huan ijcón quipajtij in telpoch. Huan de ompa Jesús quitemactij ne oquichpil imaco iteiscalticau. ");
INSERT INTO azzNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Huan nochi in tagayot quimoucaitayaj de Dios ichicaucahuelilis. Huan cuac in tagayot quimoucaitztoyaj oc nochi ne ten quichiutihuitz Jesús, ijcuacón Yejuatzin quinilij imomachtijcahuan ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","―Xinechcaquilican ca cuali nochi nijín ten namechiliti. Huan nicnequi amo xiquielcahuacan nijín que Nejuatzin ni Yectagatzin de Dios huan nechtemactisque imaco in tagayot ma nechmictican. ");
INSERT INTO azzNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Pero imomachtijcahuan amo cajsicamatque tenica quinnojnotzaya porín Totajtzin Dios ayamo quimonequiltiaya ma cajsicamatican. Huan imomachtijcahuan quiyolmohuiliaya de que quitajtoltisque Jesús de toni quijtosnequi nijín tajtolme. ");
INSERT INTO azzNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Huan mochihuac que se tonal imomachtijcahuan de Jesús peuque motajtoltehuiayaj de aconi yesqui in cachi hueyi chiuque. ");
INSERT INTO azzNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Pero Jesús quintamachilisixmatic de toni quiyolnemilijtoyaj yejuan. Ica ya nojón Jesús quicuic se pili huan quitalij inixpan. ");
INSERT INTO azzNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Huan de ompa Jesús quinilij imomachtijcahuan ijcuín: ―Huan nochi naquen yesqui ten quiselisque nijín pili para quipalehuisque sayó porín nechtasojta, yejuan nojonques niquinpohua que nechselijque ya Nejuatzin. Huan nochi naquen yesque ten nechselisque Nejuatzin, yejuan nojonques niquinpohua que quiselijtiyasque Notajtzin Dios ten nechualtitanic nican talticpac. Pero namechilía que ne tagat ten amo mohueyinectinemi inixpan in tagayot, yejua ne Dios quipohuas se hueyi chiuque. ");
INSERT INTO azzNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ijcuacón Juan quilij Jesús ijcuín: ―Tamachtijque, tejuan tiquitacque ya se tagat que yejua quincalanquixtía in amocuali ejecame ica in chicahualis de motocay. Pero tejuan tictacahualtijque que ma amo ijcón quichiutinemi porín yejua amo poutinemi tohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Pero Jesús quinanquilij ijcuín: ―Amo xictacahualtiani porín ne tagat ten amo techmohuispolojtinemi, yejua nojón techpalehuijtinemij tech totequiu. ");
INSERT INTO azzNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Huan ejcotoya ya in tonalme cuac Jesús quisati ya para yas eluiyactzinco, huan Jesús moyolchicahuac de que yas ne Jerusaléncopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Huan Jesús quintitanic sequin itapalehuijcahuan ma tayecanatij. Huan yejuan yajque huan calaquitoj tech se pueblojtzin campa itatilanal Samaria huan ompa yejuan quicaltajtanitoj Jesús para ompa mocahuas. ");
INSERT INTO azzNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ne pueblojuani de Samaria amo quintacahuilijque ma mocahuacan ompa porín yejuan cajsicamatque que Jesús ihuan imomachtijcahuan yohue ya para Jerusaléncopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Huan nijín ome imomachtijcahuan de Jesús, in Jacobo huan Juan, cuac yejuan quicacque nijín tajtol ten quijtoayaj in pueblojuani de Samaría, ijcuacón yejuan quilijque Jesús ijcuín: ―Totecotzin, ¿xe amo ticomonequiltía que ma tejuan ticnahuatican Dios que ma quinualpantamotili tit de ne eluiyactzinco para ma tajtamican ne pueblojuani de Samaria, ijcón queme quichihuac ne tanahuatijque Elías? ");
INSERT INTO azzNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ijcuacón Jesús quinsenixitac ne omen imomachtijcahuan huan quintacahualtij huan quinilij ijcuín: ―Namejuan amo nancajsicamatij de toni talnamiquilis hualeutoc nijín namotajtoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Huan xicmatican Nejuatzin ni Yectagatzin de Dios huan amo nihuala nican talticpac para niquintajtamis intalnamiquilis den tagayot. Ta, Nejuatzin nihuala para niquinmaquixtis in tagayot. Huan ijcón yajque ocsepa ocseco tech ocsé pueblojtzin. ");
INSERT INTO azzNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Huan cuac nejnentoya imomachtijcahuan ihuan Jesús, ijcuacón senme de yejuan quilij Jesús ijcuín: ―Totecotzin, semi nicnequi nimitztoctilis huan nimitztacamatiyás campa yesqui tionyás. ");
INSERT INTO azzNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Pero Jesús quinanquilij imomachtijcahuan ijcuín: ―In cuectzitzin quipíaj nintéchanti campa cochij. Huan in tototzitzin ten patantinemij ejecaixco no quipía in tapajsoluan. Pero Nejuatzin ni Yectagatzin de Dios amo nicpía can nimocuatecas. ");
INSERT INTO azzNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Huan de ompa ocsepa Jesús quilij ocsé tagat ijcuín: ―Xinechtoctiliti huan xinechtacamatiyás. Pero yejua quinanquilij ijcuín: ―Notecotzin, nechcahua oc ma niyó achto nitalpachoti noteiscaltijcau ten ayamo momiquilij ya. ");
INSERT INTO azzNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Pero Jesús quilij ijcuín: ―Xicahuacan ma neques ten no yolmictocque tech in tajtacol ma quitalpachocan in ánimajme. Pero tejua xiyó huan xitanojnotztinemi ica in Tajtoltzin de queniu Dios quiyolyecantoc itaneltocacahuan ica ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ijcuacón ocsepa in tagat quilij Jesús ijcuín: ―Notecotzin, nejua nimitztoctiliti huan nimitztacamatiyás. Pero nicnequi achto niquinnahuatiti nochancahuan que nejua niyó nimitztoctiliti. ");
INSERT INTO azzNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ijcuacón Jesús quinanquilij ijcuín: ―Xicmati que se tagat ten pehua nechtoctilía huan pehua yolnemi ica ne ten quicauca ya tacuitapan, yejua ne amo teyica cualtiyás para tanojnotztinemis de queniu Dios quinyolyecantinemi itaneltocacahuan ica ichicahualis. Huan yejua ne nicnejnehuililtía queme se tayuntajuijque ten tequiti huan moican cueptiu oc. ");
INSERT INTO azzNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Huan satepan cuac Jesús quintaminojnotzac ya imomachtijcahuan, ijcuacón Yejuatzin no quinijitac ocsequin eyipoal huan májtacti tequitini. Huan Jesús quintitanic yejuan ma yacan ojome huan ma yajtocan achtopa huan ma quiachtohuijtiyasque Jesús huan ma calactinemican nohuiyampa tech in pueblojme campa Jesús ipa monequía panos. ");
INSERT INTO azzNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Huan Jesús quinilij ne itequiticahuan ijcuín: ―Nicnejnehuililtía namotequiu queme yesquía se hueyi tapixcalis ten nicnequi nicololos ya. Huan yec melau que ongac míac tequit de tapixcalis pero in tequitini amo semi míac ongacque. Ica ya nojón namechilía ximotatautilican inahuac Namoteco ten niaxca nijín tapixcalis para ma Yejuatzin cachi oc ma quinualtitani itequiticahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Xiyacan xitequititij, huan Nejuatzin namechtitani xitanojnotztinemitij intzalan in tagayot ten quinejnehuilíaj ne tecuanime huan namejuan nanyesquía queme ichcame. Huan ijcón queme in tecuanime quinequij quimictisque ichcame, no ijcón ne tagayot quinequisque namechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Huan cuac nanyasque ya, ijcuacón amo xicuiyacan namotominehualoni huan nión no namomorral huan nión no namotegacuan. Huan amo aquen xiquinmatajpalotiyacan tech ojti, porín namejuan nanmoijsihuilijtiyohue. ");
INSERT INTO azzNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Huan cuac nancalaquitihue tech ten yesqui cali, ijcuacón achtopa xiquintajpalocan ijcuín: “Ma onga sayó yolsehuilis de Dios tech nijín calijtic”. ");
INSERT INTO azzNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Huan tacán nanajsij tech se calyetoni ten quinequi ma onca yolsehuilis tech ninchan, ijcuacón namoneyolsehuilis ompa no ma mocahuan. Huan tacán ne calyetoni amo quinequij ma quipiacan ne yolsehuilis, ijcuacón namejuan xiquintzinquixtilican namoyolsehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Huan campa namechselisque, ompa ximocahuacan tech ne calijtic. Huan xicuacan huan xitayican nochi tenica yejuan namechtamacasque. Porín namechilía que quimonequiltía Totajtzin Dios que ne tanojnotzque ten tequititinemi, yejua ne monequi quiselis ajsitoc itaxtahuil. Huan no namechilía que amo xicalpapatatinemican san. ");
INSERT INTO azzNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Huan cuac nanajsisque ya tech se pueblo campa namechselíaj ica paquilis, ijcuacón ompa xicuacan nochi tacualis ten namechmacasque. ");
INSERT INTO azzNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Huan tech ne pueblo xiquinpajtican nochi cocoyani ten namechinualcuilisque. Huan xiquinilican ne pueblojuani ijcuín: “Motoquijtoc ya in tonalme cuac Dios namechyolyecanas ica ihueyichicahualis”. ");
INSERT INTO azzNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Pero cuac nanajsisque tech se pueblo campa amo quinequisque namechselisque ica paquilis, ijcuacón ximoquetzacan tech in ojme huan xiquinilican in pueblojuani ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Tejuan timometztzetzeloaj para ma huetzi nochi nijín talnex de namopueblo ten mopilojca ya tech totegactampa para ijcón tamechnextilíaj que namejuan nanquixtopeuque ya in Tajtoltzin de Dios. Huan no xicmatican que motoquijtihuitz ya in tonalme cuac Dios quimonequiltis namechyolyecanas ica ihueyichicahualis”. ");
INSERT INTO azzNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Huan queme yejuan quixtopeuque ya in Tajtoltzin de Dios, ica ya nojón namechilía que ne tonal cuac ninpan huetzis ne hueyi tatzacuiltilis de Dios, ijcuacón melau cachi hueyi tatzacuiltilis yejuan quiselisque huan que quiselijque ya ne pueblojuani de Sodoma. ");
INSERT INTO azzNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Huan no Jesús quinilij ijcuín: ―Nantelteicneltiani namejuan nanpueblojuani de Corazín, huan no nantelteicneltiani namejuan nanpueblojuani de Betsaida, porín namejuan melau namechnamiqui xicselican in tatzacuiltilis de Dios. Huan ijcón namechilía porín amo nanmoyolnemilijque de namotajtacoluan. Huan in pueblojuani de Tiro huan Sidón cachi moyolnemilisquíaj ya de nintajtacoluan como ijcón quitasquíaj queme namejuan nanquitacque ya nijín mohuiscatequime ten nicchiutinemi namoixpan. Huan no ne pueblojuani de Tiro huan Sidón motanquentisquíaj ya ica ne tzastic tasal huan mocuounexuisquíaj ya para ijcón ixnesisquía ya melau moyolnemilijque ya de nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ica ya nojón ne tonal cuac namopan huetzis ne hueyi tatzacuiltilis de Dios, ijcuacón yec melau cachi hueyi tatzacuiltilis nanquiselisque namejuan. Huan ne pueblojuani de Tiro huan Sidón yejuan nojonques amo cachi hueyi tatzacuiltilis quiselisque. ");
INSERT INTO azzNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Huan namejuan nanpueblojuani de Capernaum, nanmoyolcajcayahuaj san porín nanmoyolueyinectinemij huan nanquinequij nanajsisque hasta ne eluiyactzinco. Pero xicmatican que Dios namechtajyohuiltis huan namechtaliti hasta ne tani campa in ánimajme tajyohuijtocque. ");
INSERT INTO azzNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Huan no Jesús quinilij imomachtijcahuan ocsepa ijcuín: ―Nochi neques ten namechcaquilisque namotanojnotzalis, yejuan nojonques no nechcaquilisque Notajtoltzin. Huan nochi neques ten namechixtopehuasque, yejuan nojonques no nechixtopehuasque Nejuatzin. Huan nochi neques ten nechixtopeutiyasque, yejua nojnoques no quiixtopehuaj Notajtzin Dios ten nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Huan ne eyipoal huan májtacti itequiticahuan de Jesús hual mocuepque ya de nintanojnotzalis ica hueyi paquilis. Huan quilijque Jesús ijcuín: ―Totecotzin, tejuan tiquitacque que hasta ne amocuali ejecame techtacamatíaj ica in chicahualis de motocaytzin cuac tiquincalanquixtiayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Huan in Jesús quinilij ijcuín: ―Quema, hueyi melau Nejuatzin niquitac que in amocuali Satanás hualpan huetzic den eluiyac queme huetzis se ticohuat. Huan cuac huetzico ya, ijcuacón Satanás quipoloj nochi nichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pero no namechmactilijca ya huelilis para huelis nanquintzojtzonicsasque in cohuame huan in colome. Huan no namechmactilijca ya huelilis para huelis nanquinxijxicojtinemisque in nochi chicahualisme de amocuali Satanás huan amo teyi tajyohuilis namopan huetzisquía. ");
INSERT INTO azzNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero no namechilía que amo ximoyolpactican sayó porín in amocuali ejecame namechtacamatij san. Ta, cachi oc monequi ximoyolpactican porín Totajtzin Dios quijcuiloj ya namotocay ya tech ilista nepa eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Huan tech ne tonal Jesús moyolpactij ica in huelilis den Yecticatzin Espíritu huan quilij ijcuín: ―Nimitzonueyimohuistilía, Notajtzin Dios, tion Tecotzin den eluiyactzinco huan nican talticpac. Porín Tejuatzin tiquintatilij ya nijín taixmatilis para ma amo quimatican in taixmatini huan in tamachilejque. Huan Tejuatzin tiquinnextilij ya nijín taixmatilis de nijín moyancuicataneltocacahuan ten yoltanemilijtinemij queme coneme ten ayamo yolmajsij. Huan nijín ijcón mochihuac porín Tejuatzin ijcón motanejnequilis. ");
INSERT INTO azzNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Huan Tejuatzin Notajtzin, tinechonmactilij ya nochi nijín chihualisme huan tanemililisme. Huan amo aca nechajsicaixmatis Nejuatzin Nimoconetzin. Ta, sayó Tejuatzin Tinotajtzin tinechonajsicaixmati. Huan amo no aca mitzonajsicaixmati de Tejuatzin Tinotajtzin. Ta, sayó Nejuatzin Nimoconetzin nimitzonajsicaixmati. Pero Nejuatzin Nimoconetzin niquinyecnextilis de aconi Tejuatzin Notajtzin para nochi neques ten niconmonequiltía niquinnextilis. ");
INSERT INTO azzNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ijcuacón Jesús moicancuepac huan quinsenitac imomachtijcahuan huan quinilij ninseltij san ijcuín: ―Tatiochihualme de Dios yesque nochi neques ten quitaj nochi chihualisme ten namejuan axcan nanquitztocque. ");
INSERT INTO azzNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Pero no namechilía que miacque ne huejcau tanahuatiani huan miacque huejueyi chihuanime de Dios quiyolnejnequíaj quitasque in chihualisme ten namejuan axcan nanquitztocque pero yejuan amo queman quitacque. Huan ne huejcau tanahuatiani huan hueyi chihuanime de Dios quiyolnejnequíaj quicaquisque in Tajtoltzin ten namejuan axcan nanquicactinemij. Pero yejuan amo queman quicacque. ");
INSERT INTO azzNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ijcuacón senme de tanextiliani den tanahuatil de Moisés moquetztiquisac huan yajqui quinojnotzato Jesús porín quinequía quitasquía de queniu itamachilisuan de Jesús huan quitajtoltij Jesús ijcuín: ―Tamachtijque, ¿toni monequi nicchihuas para que Totajtzin Dios nechaxcatilis ne yec nemilis nachipa ten amo queman tamis? ");
INSERT INTO azzNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Huan Jesús quitajtoltij ijcuín: ―¿Toni ompa ijcuiliutoc tech in tanahuatil de Moisés? ¿Queniu tejua ticajsicamati cuac ticleeroa ne tanahuatil? ");
INSERT INTO azzNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Huan ijcón ne tanextilijque den tanahuatil de Moisés quinanquilij Jesús ijcuín: ―Xictasojta Mohueyitecotzin Dios ica nochi moyolo, huan no ica nochi motalnamiquilis, huan no ica nochi mochicahualis, huan no ica nochi motanemilil. Huan no xictasojta mochancahuan ijcón queme tejua timotasojtatinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ijcuacón Jesús ocsepa quilij ijcuín: ―Cuali ya queme tinechnanquilij ya. Como melau ticchihua nochi nijín, ijcuacón ticpía ne yec nemilis ten amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero ne tanextilijque den tanahuatil de Moisés quinequía motequixtiltis de ne matájtanti ten quichihuiliaya Jesús. Ica ya nojón cachi oc quitajtoltij Jesús ijcuín: ―¿Aconi yesqui ne nochancau ten monequi nictasojtas? ");
INSERT INTO azzNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ijcuacón Jesús pehuac quimachtía ica se nexcuitil ijcuín: ―Se tonal se tagat yaya tech in ojti de Jerusalén para ajsis campa pueblo de Jericó. Huan tech in ojti sequi tachtequini quiquitzquijque ne tagat, huan quicuilijque ten niaxca hasta no nitilma. Huan no quitelmagacque ya. Huan yejuan yajque huan quicauteuque imiquilistempa ya. ");
INSERT INTO azzNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Huan mochihuac que se tiopixcat de judíos no yaya tech nojón ojti. Pero cuac quitac ne cocoxque, ijcuacón yejua huejca quitacoluij san. ");
INSERT INTO azzNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Huan no mochihuac que se tagat tiopan tapalehuijque, ten quilía Levita, yejua no panotiaya tech nojón ojti. Pero cuac quitac in cocoxque campa huetztoc, ijcuacón yejua no quitacoluij san. ");
INSERT INTO azzNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Pero mochihuac que cachi satepan no ompa panotiaya se pueblojcat de Samariajcopaca ten namejuan nanquipohuaj queme amo teyi cualtía. Huan ne pueblojcat de Samaria cuac quitac ne cocoxque huetztoc, ijcuacón yejua quihueyiyolicnelij. ");
INSERT INTO azzNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ijcuacón ne tagat de Samaria motoquico campa in cocoxque huetztoc, huan pehuac quipajtía ica aceite huan ca vino campa quicojcocojque. Huan no quitetzilohuilij ica tilma campa ne tacojcol. Huan de ompa quipantalij in cocoxque ipan niburro, huan cuiyac campa huelis mosehuis tech se mesón huan ompa quitasojcapialtito. ");
INSERT INTO azzNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Huan imostica cuac yohui ya ne tagat de Samaria, ijcuacón yejua quiquixtij ome tomin, quijtosnequi que valeroa ome tonal de taxtahuil, huan quimactilij tomin ne teco den mesón huan quilij ne teco ijcuín: “Xictasojpía huan xicpalehui nijín cocoxque, huan como ticpojpoloa oc cachi motomin ten amo ajsi nijín ten nimitzmacautehua, cuac nimocuepas ya nicahuincopaca, ijcuacón nimitztaxtahuilijtiquisas”. ");
INSERT INTO azzNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Huan de ompa Jesús quitajtoltij ne tanextilijque den tanahuatil de Moisés ijcuín: ―¿Catiyejua de nijín eyi taca tiquixejecoa mochihuac ichancau de ne cocoxque ten quicojcocojque ne tachtequini? ");
INSERT INTO azzNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Huan ne tanextilijque den tanahuatil de Moisés quinanquilij Jesús ijcuín: ―Ne tagat den quiyolicnelij in cocoxque, yejua ne ten mochihuac ichancau den cocoxque. Ijcuacón Jesús ocsepa quilij ijcuín: ―Huan axcan nimitzilía xiyó huan no ijcón xicchihuati ijcón queme ne tagat de Samariajcopaca quichihuaco. ");
INSERT INTO azzNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Huan mochihuac que cuac Jesús quisentocac nejnemito tech nioj, ijcuacón ajsito tech se pueblojtzin. Huan tech ne pueblo yetoya se sihuat ten monotza Marta. Huan yejua quitatautij Jesús ma calaqui huan ma mocahua ompa ichan. ");
INSERT INTO azzNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Huan ne Marta quipiaya se icniu ten monotzaya María. Huan ne María motalito taixpampa de Jesús campa Yejuatzin tanojnotztoya. Huan ijcón in María quiyecaquiliaya nochi ten Jesús quijtoaya. ");
INSERT INTO azzNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Pero ne Marta ilihuis yolpoliutinemía ica tequit san. Ica ya nojón Marta motoquij campa Jesús yetoya huan quilij ijcuín: ―Totecotzin, ¿xe amo ticyolmachilía que nocniu María nechcahuac noseltij ica nochi nijín tequit? Xiquili nocniu María ma nechpalehuiqui. ");
INSERT INTO azzNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ijcuacón Jesús quinanquilij Marta ijcuín: ―Tejua Marta, semi timoyolpolojtoc huan timoyoltajyohuiltijtoc ica míac tataman tequit. ");
INSERT INTO azzNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sayó ongac se taman tequit ten monequi xicchihua. Huan mocniu nijín María yejua quijitac ya ne tequit ten cachi cuali de que ma nechcaquilijto notajtoluan. Huan nijín María amo aquen huelis quiquixtilis ne tamachtilis ten yejua quijitac ya de quiselis. ");
INSERT INTO azzNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Huan mochihuac que se tonal Jesús motatatautilijtoya tech se lugar. Pero cuac Jesús motamitatatautilij ya, ijcuacón senme den imomachtijcahuan quilij ijcuín: ―Totecotzin, ticnequi xitechonmachti de queniu timotatatautilisque ihuan Dios, ijcón queme ne Juan Taahuijque quinnextiliaya imomachtijcahuan de queniu motatatautilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ijcuacón Jesús quinilij ijcuín: ―Cuac namejuan nanquinequij nanmotatatautilisque ihuan Dios, ijcuacón xiquijtojcan ijcuín: Tohueyitajtzin ten tionyetica eluiyactzinco, ma timitzonmohuistilican ica in chipaucahuelilis de motocaytzin. Huan xionuiqui huan ma xitechyolyecanaqui ica mohueyichicahualis. Huan ma mochihua nican talticpac queme Tejuatzin ticonmonequiltía, ijcón queme mochiutoc ya ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Huan no xitechonmaca axcan totaxcaltzin ten monequis. ");
INSERT INTO azzNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Huan no xitechontapojpolui de totajtacoluan porín tejuan tiquintapojpoluijque ya nochi neques ten techmohuispoloayaj. Huan amo xitechonuica tech in ohuijcayot. Ta, xitechajchihua den chicahualis den amocuali Satanás. ");
INSERT INTO azzNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Huan de ompa Jesús quinmachtij imomachtijcahuan ca se nexcuitil ijcuín: ―Ma tiquijtocan que senme de namejuan ticpía se motasojicniu. Huan ne motasojicniu yohui mochan queme tajcoyohuan huan mitziliti ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“Notasojicniu, xinechtaneuti eyi pantzitzin. Porín yequin no ne ejcoc nochan se notasojicniu ten hualajtoc de huejca huan amo teyi nicpía para nicuantis”. ");
INSERT INTO azzNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Huan no ma tiquijtocan que tejua ten tiyetoc calijtic ticnalnanquilía ijcuín: “Amo xinechcuejmolojto oc porín nicyectzacuac ya topuerta huan nopiluan cochtocque ya nohuan ya nican camajco. Ica ya nojón amo huelis nimoquetzas huan nimitzmacatilitiu tensá”. ");
INSERT INTO azzNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Huan namechilía que tejua amo timehuas huan ticpalehuis ne tagat masqui yejua motasojicniu. Ta, tejua melau timehuas huan ticmacas ten yejua quipoloa para ma amo cachi oc mitzcuejmolojto oc. ");
INSERT INTO azzNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ica ya nojón namechilía ijcuín: Xictajtanilican Dios huan Yejuatzin namechmactilis. Xictemocan de Dios nochi ten nanconmonequiltisque huan ijcón nanmoajxilisque ica ichicahualis de Dios. Huan no ijcón queme tinaltacacalatza hasta que mitztatapohuilican, no ijcón xicsentogacan xiquilican Dios nochi ten nanconmonequiltíaj huan ijcón Dios namechmacas. ");
INSERT INTO azzNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Porín nochi tocnihuan ten tajtanisque de Dios, yejuan nojonques Dios quinseliltis den motajtanilisque. Huan nochi tocnihuan ten quitemosque tensá de Dios, yejuan nojonques Dios quinpalehuis para ma moajxilican. Huan nochi tocnihuan ten tanotzasque, yejuan nojonques Dios quintatapohuilis para ma quiselican ya. ");
INSERT INTO azzNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Huan no Jesús quinilij imomachtijcahuan ijcuín: ―Amo aquen de namejuan nantetatme huelis nanquimactilisque namoconeu se tet cuac yejua namechtajtanilis que xicmacagan taxcal. Huan amo aquen de namejuan huelis nanquimactilisque namoconeu se cohuat cuac yejua namechtajtanilis que xicmacacan tzictzin pescadojnacat. ");
INSERT INTO azzNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Huan amo aquen de namejuan huelis nanquimactilisque namoconeu se colot cuac yejua namechtajtanilis se piotetzin. ");
INSERT INTO azzNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Porín masqui namejuan amo nanyolchipauque, pero no cuali nanquimatij toni nanquimactilisque namopiluan tensá ten cuali huan ten huelic. Pues cachi oc Namohueyitajtzin ten yetica eluiyactzinco, Yejuatzin namechmajmactilis huan namechyolpepexocaltis ica in Yecticatzin Espíritu ten nochi namejuan ten nanquitajtanilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Huan mochihuac se tonal que Jesús quicalanquixtilij se amocuali ejecat de se tagat ten nontzin. Huan mochihuac que cuac quisac ya ne amocuali ejecat, ijcuacón ne nontzin huelic ya tajtoj. Ica ya nojón in tagayot quimoucaitayaj nijín itequiu ten quichihuac Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero sequin tagayot quijtoayaj ijcuín: ―Nijín tagat Jesús quincalanquixtía in amocuali ejecame ica in chicahualis den amocuali Beelzebú naquen quinyecantoc in amocuali ejecame. ");
INSERT INTO azzNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Huan ocsequin tagayot quinequíaj quitasque in chicahualis de Jesús. Ica ya nojón yejuan quitajtanilijque Jesús ma quinnextili se mohuiscatequit ica in chicahualis den eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero Jesús ipa quintanemililixmatic in tagayot huan quinilij ijcuín: ―Tacán in pueblojuani de se país moxejxelojtocque se huan ocsé huan motehuisque san, ijcuacón ne país nochi mohuejuelosque san. Huan no ijcón tacán in tagayot de se calyetoni moxejxelojtocque se huan ocsé huan motehuíaj san, ijcuacón ne calyetoni amo queman huelis sen yetosque. Ta, sayó mohuejuelojtinemisque san. ");
INSERT INTO azzNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Huan tacán in amocuali Satanás quintehuía iamocuali icnihuan, ijcuacón yejua ne motehuíaj iselti san huan mocojcocoa san. Huan como ijcón quichiutoc in Satanás, ijcuacón amo huelis huejcahuas ne ichicahualis de yejua. Huan nijín ijcón namechilía porín namejuan nanquijtoaj que Nejuatzin niquincalaquixtía in amocuali ejecame ica ne chicahualis den amocuali Beelzebú. ");
INSERT INTO azzNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Huan como nejua niquincalanquixtisquía in amocuali ejecame ica in chicahualis de amocuali Beelzebú, ijcuacón ne namoconehuan ten quincalanquixtitinemij in amocuali ejecame, ¿aconi oc quinmacas yejuan in chicahualis para ma yejuan no quincalanquixtican in amocuali ejecame? Ica ya nojón namejuan namoconehuan mochiuque namotaixejecojcahuan huan namechtenextíaj que nanmoyolcajcayautocque san. ");
INSERT INTO azzNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Huan Nejuatzin niquincalanquixtíaj in amocuali ejecame ica in chicahualis den Totajtzin Dios. Huan nochi ten nijín notequiu nicchiutinemi quijtosnequi que ejcoc ya namotzalan in tonal cuac Dios quimonequiltía namechyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Huan Jesús quinmachtij in tacaquini ica nijín nexcuitil ijcuín: ―Cuac se cuali chicaucatagat quiyecpixtoc nichan ica cuajcuali teposme de manamicme, ijcuacón nochi ten quipixtoc calijtic amo aquen huelis quichtequilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Pero cuac huitza ocsé tagat ten cachi quipía chicahualis huan que ne tagat tajpixque, ijcuacón ne cachi hueyi tagat quixixicos ne tajpixque huan quicuilijtehua nochi niteposuan tenica moyolchicautoya. Huan no ne cachi hueyi tagat quinxejxelohuilía sequin tagayot nochi ten niaxca catca in tajpixque. Huan in Beelzebú yejua in tajpixque; huan Nejuatzin cachi nicpixtinemi chicahualis. Huan ne Beelzebú amo teyi quipía chicahualis porín Nejuatzin huelis nicuilis nochi ten mopixtolijtoc. ");
INSERT INTO azzNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Huan nochi neques ten amo techpalehuijtinemij, yejuan nojonques techtahuelitztinemij. Huan nochi neques ten amo tohuan yajtocque ca nijín totequiu, yejuan nojonques quixcueptinemij san notequiu. ");
INSERT INTO azzNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Huan Jesús quinmachtij in tacaquini ijcuín: ―Huan cuac se amocuali ejecat quisac ya itech se tagat, ijcuacón ne amocuali ejecat nemi nohuiyan campa taluacan huan quitemojtinemi can huelis mosehuis itech iyolijtic de ocsé tagat, huan yejua amo cajsis. Huan ijcón monemilía ne amocuali ejecat ijcuín: “Cachi cuali nimocuepas ocsepa campa nihualehuac”. ");
INSERT INTO azzNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Huan cuac mocuepac ya campa hualehuac, ijcuacón quinamiqui ne tagat yoliuqui huan tachipahuiyan huan tachijchiutoc ya, pero amo yolpepexocatoc ica in Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ijcuacón in amocuali ejecat yohui huan quinuica ocsé chicome amocuali ejecame ten cachi pitzoticque huan que yejua. Huan nochi yejuan calaquitij huan mocaltalitij itech ne tagat iyolijtic. Ijcuacón ne tagat mocahuas cachi yolpitzotic huan que ne achtopa catca. ");
INSERT INTO azzNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Huan mochihuac que cuac Jesús quinilijtoya in tagayot nochi nijín tamachtilis, ijcuacón se sihuatzin quichicaucailij Jesús ijcuín: ―Tatiochihual de Dios ne sihuat ten mitzyolitij huan mitzchichitij. ");
INSERT INTO azzNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Pero Jesús quinanquilij ijcuín: ―Amo ijcón ma se quijto. Ta, cachi cuali ma tiquijtocan que tatiochihualme de Dios nochi neques ten quiyecaquij in Tajtoltzin de Dios huan quitacamatij. ");
INSERT INTO azzNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Huan in tagayot cachi oc quiyehualoayaj Jesús. Huan Yejuatzin pehuac quinnojnotza ijcuín: ―In tagayot ten axcan nentinemij, yejuan nojonques semi amo yolcualime porín sayó nechtajtanilíaj ma niquinnextili se mohuiscatequit. Pero amo niquinnextilis se mohuiscatequit porín Totajtzin Dios quinonnextilij ya ne nexcuitil de ne huejcau tanahuatijque Jonás. ");
INSERT INTO azzNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Huan ne Jonás mochihuaco se nexcuitil iixpan in pueblojuani ten nentinemícoj tech in pueblo de Nínive para ma quimatican ne pueblojuani que Dios quinualtitanilij ne Jonás. Xicmatican que no ijcón Nejuatzin ni Yectagatzin de Dios huan nimochihuas se nexcuitil para in pueblojuani ten nentinemij axcan para ma yejuan quimactican que Dios nechualtitanic Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Huan tech ne tonal cuac Dios namechixcomacas namejuan in tagayot ten axcan nannentinemij, ijcuacón ne sihuat tayecanque de talme ten mocahua ne sur monotza Sebá, yejua ne moquetzas huan namechteluilis porín namejuan nanquixtopeuque ya in Tajtoltzin de Dios. Porín yejua yajca quicaquito in tamachtilis de Dios ica itencopaca ne rey Salomón. Huan Nejuatzin nican niyetoc namoixpan huan cachi nihueyi nichiuque huan que ne rey Salomón. Pero namejuan amo nanquinequij nannechcaquilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Huan tech ne tonal cuac Dios namechixcomacas, ijcuacón in pueblojuani de ne Nínive moquetzasque. Huan yejuan namechteluilitij iixpantzinco Dios porín namejuan nanquixtopeuque ya in Tajtoltzin de Dios. Porín ne Jonás yajca quinnojnotzato huan quintaneltoctij ne pueblojuani de Nínive. Huan yejuan moyolnemilijque de nintajtacoluan. Huan Nejuatzin nican niyetoc namoixpan huan cachi nihueyi nichiuque huan que ne Jonás. Pero namejuan amo nanquinequij nannechcaquilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Huan Jesús quinilij in tagayot ijcuín: ―Amo aquen quixotaltía se tahuil huan quitatía oso quitaliti tatampa de se cajón. Ta, quitalía ne tahuil campa tasempayan para ijcón naquen calaquisque huelis tachiasque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Namoixtololohuan nicnejnehuililtía queme se tanex ten namechtahuilía hasta tech namoyolijtic. Huan tacán namoixtololohuan yec tequitij queme se cuali tanex, no ijcón cuali namechtahuilijtinemi hasta tech namotalnamiquilis. Huan tacán namoixtololohuan amo yec tequitij porín tensá quitzajtzacuilía namoixcoconeu, ica ya nojón amo huelis calaquis in tanex. Huan ijcón nochi namoyolijtic mocahuas tech in tayohuanilot. ");
INSERT INTO azzNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Huan no namechilía ximoyecpiacan san ca ne Tajtoltzin de Dios tenica namechyoltahuilijtoc, ma amo xiquixmictican. Porín como ijcón nanquichihuaj, ijcuacón sehuis ne tanex huan tayohuayantis itech namoyolijtic. ");
INSERT INTO azzNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Huan queme in Tajtoltzin de Dios namechyoltahuilía huan amo teyi quiyecahuiltía nepa namoyolijtic, ijcuacón nochi nanyectachiasque ca cuali, ijcón queme cuac namejuan nanquixotaltía se tahuil. ");
INSERT INTO azzNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Huan cuac Jesús quintaminojnotzac ya in tagayot, ijcuacón se tamachile fariseo quitatautij Jesús ma yohui ichan tacuati. Huan melau ijcón Jesús quichihuac huan calayic ichan in fariseo huan motalito ne mesajnacastan. ");
INSERT INTO azzNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Ijcuacón in fariseo quimoucaitac cuac quitac que Jesús amo momajtequi achtopa que tacuas para ica quitenextis que momachipahua de nitajtacoluan. Huan Yejuatzin amo quichihuac ijcón queme mohuicatinemij in pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Pero Totecotzin Jesús quilij ijcuín: ―Axcan namejuan nanfariseos, nanquichipahuaj panían san in vasos huan caxme ten taijtic pexontoc oc ica míac tenesij ten pitzotic. Huan no ijcón mochiutoc namoyolijtic, namejuan nanmochipahuaj panían san. Pero tech namoyolijtic nanpexontocque ica míac tataman de tachtequilis huan de amocuali chihualisme. ");
INSERT INTO azzNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Namejuan semi nanyolmijmiquilome porín nanquiyolnemilíaj sayó de namonacayo. Cuali nanquimatij que Dios quichijchihuac namonacayo ten mocahua panían san. Huan no xicmatican que Dios quichijchihuac namotalnamiquilis ten mocahua namoijticpa. ");
INSERT INTO azzNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ica ya nojón namechilía que monequi xitetayocolican ne tacualis ten yetoc tech in platos huan vasos para neques ten amo quipía tenica moixpanoltisque. Huan como nanquitayocolíaj ne namoyolchipahualis, ica ya nojón cachi oc nanmocahuasque nanyolchipauque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Huan semi nanteicneltiani, namejuan nanfariseos, porín melau namejuan namechnamiqui xicselican ne tatzacuiltilis de Dios. Porín namejuan nanquimactilíaj Dios namodiesmo de xiutzitzin san, queme in menta huan in ruda huan míac tataman quiltzitzin ten amo teyi valeroa. Pero nanquisecocahuaj in tanextililisme ten cachi hueyi tech in tanahuatil de Moisés queme nijín tanahuatilme ten namechtapohuiti. Nanquisecocahuaj in chipaucanemilis huan in tetasojtalis de Dios. Huan yejua nijín ten semi monequi xichiutinemican huan amo no xicahuacan de amo nanquitemactisque namodiesmo. ");
INSERT INTO azzNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Huan semi nanteicneltiani, namejuan nanfariseos, porín melau namejuan namechnamiqui ne tatzacuiltilis de Dios. Porín namejuan semi nanquiyolnejnequij nanmosehuisque tech in cuali sillas ten yetocque cachi taixpan tech in tiopan de judíos. Huan no semi nanquiyolnejnequij que semi ma namechmohuiscatajpalocan tech in ojme den plaza. ");
INSERT INTO azzNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Huan semi nanteicneltiani, namejuan nanfariseos, huan nantanextiliani den tanahuatil de Moisés. Porín melau namejuan namechnamiqui xicselican ne tatzacuiltilis de Dios. Porín namejuan semi nanixcuecuepme san de namotamachilis. Namejuan nanquinejnehuilíaj ne ánimajtecochme ten amo motaj. Huan in tagayot panotinemij panían huan amo quimatij toni quitelicsatiquisaj. Namejuan nanquimajmahuaj ica tajtacol nochi namotaneltocacahuan ijcón queme in tanahuatil de Moisés technextilía que timotajtacolmacaj ya cuac tipanotiquisaj panían de ne animajtecoch. ");
INSERT INTO azzNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ijcuacón se tanextilijque de tanahuatil de Moisés quinanquilij Jesús huan quilij ijcuín: ―Tamachtijque, cuac titechilía nijín tajtolme, ijcuacón semi titechmohuispoloa ya. ");
INSERT INTO azzNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Pero Jesús quilij ijcuín: ―Semi nanteicneltiani, namejuan nantanextiliani den tanahuatil de Moisés. Porín melau namejuan namechnamiqui xicselican in tatzacuiltilis de Dios. Porín namejuan nanquinmiactililíaj in tanahuatilme para ma ijcón in tagayot ma quintacamatican. Huan nijín queme yesquía se hueyi tamamal ten namejuan nanquintalilíaj, huan in tagayot amo huel cuicasque. Huan namejuan hasta amo no nanquinpalehuíaj in tagayot para momamaltisque ne tamamal. ");
INSERT INTO azzNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Huan semi nanteicneltiani, namejuan ten nanquinchijchihuilíaj ninánimajcaluan ne tanahuatiani de Dios neques ten namohuejcautatuan quinmictijque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Huan ixnesi que no namejuan nanquinequij nanquichihuasque ijcón queme namohuejcautatuan quichiuque. Porín hueyi melau que namohuejcautatuan quinmictijtihualyaj ne tanahuatiani de Dios huan namejuan nanquinchijchihuilíaj ne tanahuatiani de ninánimajcaluan. ");
INSERT INTO azzNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Huan no Jesús quinilij in tacaquini ijcuín: ―Ica ya nojón Totajtzin Dios ica ihueyitamachilis techilij ijcuín: “Niquinualtitanilis nopueblojcahuan sequin tanahuatiani huan tatitanilme pero nopueblojcahuan quinmictijque sequin huan ocsequin quinicantocayaj para ijcón quintajyohuiltisque”. ");
INSERT INTO azzNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ica ya nojón Totajtzin Dios namechixcomacas namejuan nantagayot ten axcan nannentinemij porín nanquinmictijtihualajque ya itanahuatijcahuan de Dios ten nentinemíaj desde cuac Dios quichijchihuac in talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Huan nanquinmictijtihualajque nojón tanahuatiani desde cuac in Abel nemico huan hasta in tonal cuac nemico Zacarías ne ten quimictijque ne tiopanijtic campa altar. Huan namechyecquilía que Totajtzin Dios namechixcomacas namejuan ten axcan nanentinemij ica por nochi nojón temictilis. ");
INSERT INTO azzNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Semi nanteicneltiani, namejuan nantanextiliani den tanahuatil de Moisés, porín melau namejuan namechnamiqui xicselican in tatzacuiltilis de Dios. Porín amo nanmoaxcatilíaj namejuan de ne tamachilisme tenica huelis nancalaquisque ne eluiyactzinco. Huan ne tamachilisme queme yesquía se llave. Pero namejuan amo nanquitatequiutíaj ne llave para ica nancalaquisque ne eluiyactzinco. Huan amo no nanquitacahuilíaj ma calaquican nochi neques ten quiyolnejnequij calaquisque. ");
INSERT INTO azzNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Huan cuac Jesús quinilijtoya ya nochi nijín tajtolme in fariseos huan in tanextiliani den tanahuatil de Moisés, ijcuacón yejuan mohueyiyolcualantijque ihuan Jesús huan peuque quicuejmoloaj Jesús ica míac tataman matájtanti. ");
INSERT INTO azzNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Huan ica nojón matájtanti ten quichihuiliayaj, yejuan quinequíaj que Jesús ma quijtoani tensá de elihuis tajtol tenica huelisquíaj quipajpantisque Jesús ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Huan mochihuac que mosentiliayaj campa yetoya Jesús huel míac tagayot hasta ca miles de tagayot. Huan queme semi huel miacque ya hasta mopejpechiayaj yejuan san. Ijcuacón Jesús pehuac quinnejmachtía imomachtijcahuan ijcuín: ―Ximoyecpiacan de ne tacajcayauca tanextililis ten cuicatinemij ne fariseos ne ten temajmahua ica tajtacol ijcón queme yesquía levadura ten quimajmahua ne pan tixti. ");
INSERT INTO azzNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Porín amo ongac teyi chihualis oso tanemililis ichtacayot san ten ma amo quipía de que ixnesis. Huan amo no ongac tejsá tanextililis ten motatijtoc de que ma amo quipía de que monextis huan quimatisque nohuiyampa. ");
INSERT INTO azzNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ica ya nojón nochi tajtolme ten namejuan nanquichtacaijtojcaj queme yesquía tech in tayohuayanilot, nochi namotajtoluan ipa mocaquis senteixteno queme yesquía tonayan. Huan nochi namoichtacatajtoluan ten nanquijtojcaj ya nanmocalijtic, nochi nojón motajtoluan chicaucacaquisti desde ne namocalcuaco. ");
INSERT INTO azzNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Huan namejuan nannotasojicnihuan, namechilía que amo xiquinyolmohuilican neques ten huelis quinmictisque namonacayo san. Porín cuac miquis ya namonacayo, ijcuacón amo teyi huelis oc namechchihuilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Pero no namechnejmachtiti de aconi monequi xicmohuilijtiyacan. Namechyequilía que xicmohuilican Totajtzin Dios ten huelis namechquixtilis namonemilis. Porín Yejuatzin no quipixtoc huelilis para no namechtamotas campa mictan. Ica ya nojón namechyequilía xicmohuilican sayó Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Huan xicmatican que hasta in tototzitzin quipíaj inpatiu porín quinnamacaj macuil tototzitzin tech in plaza ica sayó ome centavos. Huan masqui tepitzin san ipatiu, pero Totajtzin Dios amo queman quinelcahuas de nojón tototzitzin. ");
INSERT INTO azzNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Huan cachi oc Totajtzin Dios namechelnamiquis de namejuan. Huan Yejuatzin namechtasojtatinemis porín hasta namotzontzin de namotzontecon no nochi tapohual yetoc ya. Ica ya nojón amo ximoyolcuejmolocan porín Dios namechtasojta. Huan namejuan nanvaleroaj cachi oc huan que miacque tototzitzin. ");
INSERT INTO azzNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Huan Jesús quimachtij itaneltocahuan ijcuín: ―Huan como acsame moyectenextía senteixteno que yejuan yec tacuautamatij nohuantzin de Nejuatzin ni Yectagatzin de Dios, ica ya nojón nicyecquiliti Notajtzin Dios inixteno nochi in inángeles que melau yejuan poutocque nohuan ya. ");
INSERT INTO azzNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Huan como acsame nechtatisque huan telisque que amo nohuan tacuautamatij, ijcuacón Nejuatzin ni Yectagatzin de Dios niyecquiliti Notajtzin Dios ne inixpan inángeles de que yejuan amo nohuan poutinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Huan como acsame nechmohuispoloaj Nejuatzin ni Yectagatzin de Dios, ijcuacón Dios huelis quintapojpoluis. Pero nochi neques ten quimohuispoloaj in Yecticatzin Espíritu, yejuan nojonques amo huelis Dios quintapojpoluis oc. ");
INSERT INTO azzNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Huan cuac quinequisque namechuicasque tech in tiopan de judíos para ompa namechixcomacasque. Oso cuac namechuicasque inixpan tequihuani oso inixpan in taixejecoani, ijcuacón amo teyica ximonemilican de queniu nanquinnanquilisque oso toni nanquinnanquilisque nojón tequihuani. ");
INSERT INTO azzNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Porín xicmatican que cuac ejcos in tonal de namechixcomacasque, ijcuacón in Yecticatzin Espíritu, Yejuatzin ne namechnextiliti tonica monequi nantananquilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Huan senme de tacaquini intzalan in tagayot quilij Jesús ijcuín: ―Tamachtijque, nicnequi xicnahuati nocniu de que ma nechxelohuili ten pohui notechcacopaca den nojón toherencia. ");
INSERT INTO azzNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Pero Jesús quinanquilij ijcuín: ―Tejua tacat, ¿aconi nechtalij nejua queme taixejecojque namohuan oso taxejxelojque ica nijín namoherencia? ");
INSERT INTO azzNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Huan no Jesús quinilij ijcuín: ―Xictalican cuidado huan ximoyecpiacan de nochi tataman yolnejxicolot. Porín Totajtzin Dios amo quipohua que quipía semi ipatiu se tagat ica por nochi iricojyo ten quipixtinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Huan ijcón Jesús quinmachtij ica nijín nexcuitil ijcuín: ―Oncaya se tagat ten semi rico huan tech nochi italuan semi motachihuaya ica cuajcuali taquilome. ");
INSERT INTO azzNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ijcuacón ne tagat rico pehuac quiyolnemilía ijcuín: “¿Toni nicchihuas axcan? Porín amo nicpía calme campa niquehuas nochi notatoc”. ");
INSERT INTO azzNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ijcuacón in rico quinemilij ijcuín: “Axcan nicnemilij ya de toni nicchihuati. Achto niquinuejueloti nijín calme campa niquehua notatoc para ijcón niquinchijchihuatij ocsequin calme ten cachi huejueyin. Huan ijcón ompa niquehuas nochi ten noaxca. ");
INSERT INTO azzNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Huan de ompa huelis niquiliti notalnamiquilis ijcuín: Notalnamilis, nimitzilía axcan ticpía míac tataman ten tiqueutoc ten moaxca ya huan nijín huejcahuas míac xiume. Ica ya nojón xitacua huan ximosehui huan xitayi vino huan ximoyolpactijtiu”. ");
INSERT INTO azzNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Pero Dios quiliti ne rico ijcuín: “Tejua rico timijmiquilot san. Porín nimitzilía tech nijín yohual timomiquilis. Huan nijín ten moaxcacopaca nochi ne ten tiqueutoc, ¿para aconi ica mocahuas?” ");
INSERT INTO azzNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Huan no ijcón mochihuas ipan ne tagat como moaxcatilía niricojyo para yejua san. Yejua nojón tagat amo teyi chiuque iixpantzinco Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Huan cachi satepan Jesús quinilij imomachtijcahuan ijcuín: ―Namechilía que amo ximoyolcuejmolocan de toni nancuisque tech namonemilis, huan nión no de toni nanquicuasque. Huan amo no ximoyolcuejmolocan de tonica namotanquentisque. ");
INSERT INTO azzNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Huan namechilía que namonemilis cachi tayecantoc huan que namotacualis. Huan namonacayo cachi tayecantoc huan que namotaquenuan. ");
INSERT INTO azzNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Cuali xiquitacan san in tototzitzin ten quinilíaj cuervos, yejuan amo motatoquíaj huan nión no cajocuij taquilot huan amo no quipíaj sincalme campa taeutinemij. Pero Namohueyitajtzin nachipa quintamacatoc ne tototzitzin. ¿Xe amo namejuan cachi nantayecantocque ihuan Dios huan que ne tototzitzin? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Pues amo aquen de namejuan huelis momajxitis se molic oc para cachi huejcampantiyás masqui semi moyolcuejmolos para quichihuas. Pero ipa amo huelis momajxitis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Huan como namejuan amo hueli nanmomajxitíaj ica nojón tepitzin para cachi huejcampantiyás, ijcuacón amo ximoyolcuejmolojtinemican de amo nanquichihuasque in ocsequin tequit ten cachi ohuijque. ");
INSERT INTO azzNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Cuali xiquitacan queniu moscaltíaj ne milajxochime. Yejuan amo motequitiltía huan nión tajquitij. Pero namechyecquilía que nijín xochit semi cachi cualtzin xochiyohua. Huan masqui ne hueyi rey Salomón ica nochi icualtziyo motanquentiaya, pero amo queman huelía quinejnehuilij cualtzin queme nijín xochime. ");
INSERT INTO azzNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Huan Dios quicualnextijtoc nijín milajxochime ten axcan moscaltijtoc huan mosta quitalisque campa ne tachinoa. Pero namejuan cachi oc namechpalehuis huan namechtaquentis Dios huan que ne milajxochime. Huan, ¿queyé namejuan amo majsitoc namotacuautamatilis para ijcón cachi oc huelis namechpalehuijtiyás Totajtzin Dios? ");
INSERT INTO azzNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Huan namejuan amo xicnemilijtinemican huan ximoyolcuejmolocan de toni nanquicuasque huan de toni nantayisque mosta mosta. ");
INSERT INTO azzNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Porín in tagayot de nican talticpac, yejuan nojonques quitemoaj sayó de nijín taman. Pero namejuan nanquipíaj se Namohueyitajtzin ten cuali quimati queniu namechixpanoltis ica nochi ten namechpoloaj. ");
INSERT INTO azzNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ta, cachi cuali namejuan xictemocan achto para ma Dios namechyolyecana ica ihueyichicahualis. Huan ijcón Yejuatzin namechmajxitijtiyás huan ijcón nanquiselisque nochi ten monequi ijcón queme in tacualis huan in atilis huan namotaquen. ");
INSERT INTO azzNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Huan Jesús Temaquixtijque quinilij in tagayot ijcuín: ―Amo ximoyolmoutican namejuan nannotaneltocacahuan. Masqui namejuan amo semi nanueyichihuanime, pero Totajtzin Dios quiyolpactía de namechyolyecantinemis ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Huan no namechilía xicnamacacan nochi ten nanquipíaj huan xiquintayocolican neques ten amo teyi quipía. Huan como ijcón nanquichiutinemij, ijcuacón nanquipiatihue ricojyot nepa eluiyactzinco ten amo queman tamis, queme yesquía se tomin bolsa ten amo queman tzayanis. Huan nepa eluiyactzinco in tachtecque amo huelis calaquis para namechtachtequisque. Huan ompa amo no ocuilmimalotos namoricojyo. ");
INSERT INTO azzNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Porín campa yesqui yetos nochi namoricojyo, ne eluiyactzinco oso nican talticpac, sayó ompa itech ne namoricojyo nanyoltanemilijtinemisque. ");
INSERT INTO azzNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Huan Jesús Temaquixtijque quinmachtij de ne tonal cuac Yejuatzin mohualuicas den eluiyac. Huan Jesús quiniliaya in tacaquini ijcuín: ―Ximoyectalijtocan ya ijcón queme cuac nanquiyecxotaltisque namotahuiluan huan nanyohue campa se nenamictilis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Porín namejuan nanquinejnehuilíaj queme ne taquehualme ten quichixtocque ninteco ma mocuepa ya de se nenamictilis. Huan yejuan quichixtocque para cuac ninteco ejcos ya huan quinnotzas, ijcuacón yejuan nimantzin quitatapohuilijtihuetzisque. ");
INSERT INTO azzNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Huan tatiochihualme de Dios ne taquehualme ten quinajsiquiu ninteco quichixcayetocque huan ixpetantocque. Huan ne yec melau namechilía que ne ninteco cuac ejcos ya, ijcuacón yejua moyecyectalis huan quintacualchihuilis huan quinilis ma motalican huan ijcón yejua quintamacas. ");
INSERT INTO azzNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Huan tatiochihualme de Dios ne taquehualme ten quinajsiquiu ninteco ixpetantocque huan yec yolyetocque masqui ejcos tajcoyohuan oso masqui ejcos nepa queme eyi hora de cualcan. ");
INSERT INTO azzNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Huan no xicmatican que tacán se tetat de se calyetoni quimatisquía toni hora hualasquía in tachtecque, ijcuacón amo cochisquía. Ta, ixpetantosquía huan amo quicahuasquía ne tachtecque ma quicaltapo huan quichtequilis ten niaxca. ");
INSERT INTO azzNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Huan namejuan no namechilía que ximoyejyectalijtocan huan xicuatamatocan porín namejuan cuac amo nanquinemilijtosque cox nimohualuicas, ijcuacón Nejuatzin ni Yectagatzin de Dios nimohualuicas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ijcuacón in Pedro quitajtoltij Jesús ijcuín: ―Totecotzin, ¿xe nijín nexcuitil ten titechmachtijtoc para tejuan yesqui oso para nochi in tagayot? ");
INSERT INTO azzNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ijcuacón Totecotzin quinanquilij ijcuín: ―Axcan namechtapohuiti de se taquehual ten yolcuali huan ten cuatamatque. Huan in patrón quicautehuac ne yolcuali taquehual ten tayecancataquehual ma yejua quintequitiltijto in ocsequin taquehualme huan para ma yejua tanahuati ma quintamaca cuac ne monequis hora de tacualis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Huan ijcón ne tayecanque taquehual tatiochihual de Dios yesqui, porín cuac ejcos nipatron, ijcuacón cajsiquiu quichiutoc ten quinajnahuatiteu. ");
INSERT INTO azzNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","De yec melau ten namechilía ne patrón quicahuilis ne itayecancataquehual ma yejua quinyecana nochi in ocsequin taquehualme huan nochi ten niaxca. ");
INSERT INTO azzNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Pero no namechtapohuiti de se tayecanque taquehual ten amo yolcuali. Huan yejua moyoliliaya san ijcuín: “Nopatrón huejcahuati huan amo niman ejcos”. Ijcuacón ne tayecanque taquehual pehua quinuitequi in ocsequin taquehualme huan sihuatequitini. Huan ne amocuali taquehual no pehua tatacuati san huan no pehua tahuana huan mohuintía. ");
INSERT INTO azzNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Huan ijcón in patrón ejcos tech ne tonal cuac ne amocuali tayecanque taquehual amo quichixtoc nipatrón, porín yejua amo quimatía toni hora ejcos nipatrón. Ijcuacón ne patrón quichicaucatatzacuiltis ne taquehual ten amo yolcuali huan quitelchihuas huan quititanis ma tajyohuiti ihuan ne taca ten amo quichiuque queme quinnajnahuatijtehuac. ");
INSERT INTO azzNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Huan ne patrón cuitequis miacpa ne taquehual ten quimatic toni quinequía nipatrón ma quichihuani pero amo moyejyectalij para quichihuas huan amo no quitacamatic. ");
INSERT INTO azzNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Pero ocsé taquehual amo cajsicamatía toni quinequía nipatrón ma quichihuani. Huan ne taquehual quichihuac sequi amocuali tequit tenica quinamiqui cuitequisque. Pero in patrón amo semi quiteluitec nitaquehual. Huan nochi neques ten in patrón quintanahuatilij ma quichihuacan míac tequit, yejuan nojonques in patrón quintatajtanis cachi oc de nintequihuan. Huan nochi neques ten in patrón quincahuilijtehuac ma quitamichihuacan míac tequit, yejuan nojonques in patrón cachi oc quintatajtanis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Huan Jesús quinmachtij imomachtijcahuan ijcuín: ―In tagayot motajtoltehuique hasta motehuique se huan ocsé ica nijín notamachtilis ten nicualcuic ya. Porín nojón netehuilis queme yesquía tit ten nicxotaltico. Huan nicnequisquía que majcán motamichiutoya nijín notequiu, ijcón queme se tit ten cuali xotatoc ya. ");
INSERT INTO azzNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Huan Nejuatzin semi monequi niquijyohuis se tajyohuilis ten nopan monequi mochihuas. Huan nejua nihueyi nitajyohuijtíyas hasta in tonal cuac nictamichihuas ya notequiu. ");
INSERT INTO azzNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Huan amo xicnemilican que Nejuatzin nihuala namechualcuilij sayó yecyectolis nican talticpac. Porín melau amo nihuala para namechualcuilis sayó yecyectolis. Ta, namechualcuilij ne tehuilis huan ne xexelolis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Huan axcan para taixpan macuil calyetoni moxexelosque ica por notamachtilis. Huan eyi de ne calyetoni quintahuelitasque in ocsé ome. Oso ome de calyetoni quintahuelitasque in ocsé eyi. ");
INSERT INTO azzNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Huan tech se calyetoni in tetat quicualancaitztinemis niconeu; huan ne iconeu quicualancahuis nitat. Huan no ijcón mochihuas in tenan quicualancahuis nisihuapil; huan ne isihuapil no quicualancaitztinemis inan. Huan no ijcón mochihuas in temonan quitahuelitztinemis nisihuamon; huan ne tesihuamon no quitahuelitztinemis ne imonan. Huan nochi nijín mochihuas ijcón porín quinselisque nijín notamachtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Huan Jesús no quinilij in tagayot ijcuín: ―Huan namejuan nantagayot, cuac namejuan nanquitaj que in mixti motetepequetza nepa ipoliuyampa in tonal, ijcuacón nanquijtoaj que niman quiohuis ya. Huan melau ijcón mochihuas. ");
INSERT INTO azzNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Huan cuac nanquitaj que hualtaejeca de ne ajcopa, ijcuacón nanquijtoaj que tacahuanis. Huan melau ijcón mochihuas. ");
INSERT INTO azzNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Namejuan nantacajcayahuani san. Cuali nancajsicamatij toni mochihuas cuac motetepequetza in mixti nepa ejecaixco oso cuac taejeca nican talticpac. Huan queme taejeca, cuali nancajsicamatij nochi nojón. Pero namejuan amo nancajsicamatij notamachtilis ten niquinnextilijtoc in tagayot ten axcan nentinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Huan namechilía que monequi namejuan san ximoixcomacacan se huan ocsé ica tamelautoc. ");
INSERT INTO azzNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Huan tacán acsá mitzteluilía huan quinequi mitzuicas iixpan in juez, ijcuacón nimantzin tejua xiyó ximofuerzajui huan xictajtaniliti tech ne ojti ma mitztapojpolui para ijcón nanmoyecahuasque ya. Huan ijcón amo mitzuicas oc iixpan in juez. Porín tacán mitzuicas iixpan in juez, ijcuacón ne juez mitztemactis inmaco in policía huan yejuan mitzcalaquitihue nepa cárcelijtic. ");
INSERT INTO azzNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Huan yec melau ten namechilía que como mitztzacuasque, ijcuacón amo huelis tiquisas oc de ne cárcel, como amo achto tictemaca nochi ten mitztajtanisque. ");
INSERT INTO azzNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Huan tech nojón tonalme sequin taca yajque quitapohuitoj Jesús de queníu in tayecanque Poncio Pilato quinmictij sequin taca de pueblo Galilea. Huan ne Pilato quimaneloj inesti de ne taca ihuan sequin esti den tapialme ten ne taca quinmictijcaj ya para ijcón quimohuistilijque Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Huan Jesús quinilij ijcuín: ―Namejuan amo xinemilican que ijcón inpan mochihuac porín yejuan cachi tajtacolejque huan que ocsequin ninpueblojcahuan de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pero namechilía que amo melau yejuan cachi tajtacolejque. Ta, namechilía que como amo nanmoyolnemilíaj de namotajtacoluan, ijcuacón nochi namejuan nanixpolihuisque ijcón queme yejuan ixpoliuque ya. ");
INSERT INTO azzNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Huan no xiquelnamiquican de ne caxtolomeyi taca ten momiquilijque cuac inpan huetzic ne tepan queme campanario ten monotza Siloé. Huan amo xicnemilican que ne taca ten momiquilijque cachi tajtacolejque catca huan que in ocsequin tagayot ten calyetocque tech in Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pero namejuan namechilía que yejuan amo cachi tajtacolejque. Ta, namechilía como namejuan amo nanmoyolnemilíaj de namotajtacoluan, ijcuacón nanixpolihuisque ijcón queme yejuan ixpoliuque ya. ");
INSERT INTO azzNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Huan no Jesús quinmachtij in tagayot ica se nexcuitil ijcuín: ―Se patrón quipiaya se higos cuohuit ten ijcatoya italpan. Huan ne patrón yajqui quitemolito cox quipíaya higos cuouxocot. Pero amo teyi xocot cajxilij. ");
INSERT INTO azzNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ijcuacón ne patrón quilij in taquehual ten tajpixtinemía nepa italpan ijcuín: “Xiquita, que nihualajca expa ya de nijín eyi xihuit, huan amo teyi higos xocot nicajxilía nijín cuohuit. Nimitzilía yequintzin xicmayohui nijín cuohuit para ma amo nencajtito san nijín tal”. ");
INSERT INTO azzNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Pero ne tajpixque de ne tal quinanquilij ipatrón ijcuín: “Notecotzin, ma ticahuacan oc in cuohuit nijín xihuit. Huan nejua nitalyemaniti itzintan in cuohuit huan nictalilis tapalan. ");
INSERT INTO azzNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Huan ca nijín notequiu ten nichihuas, a ver xa quitemecas taquilot ten ocsé xihuit. Pero tacán amo quitemacas xocot, ijcuacón ocsepa xinechnahuati huan nejua nicmayohuis”. ");
INSERT INTO azzNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Huan se tonal de ne sehuilis Jesús quinmachtíaya in tagayot tech in tiopan de judíos. ");
INSERT INTO azzNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Huan mochihuac que no ompa yetoya se sihuat ten mococoaya caxtolomeyi xiutica ya. Huan se amocuali ejecat quichihualtij in sihuat ma tomotzquisa. Huan ijcón in sihuat amo queman huelía momelaxquetzas. ");
INSERT INTO azzNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Huan cuac Jesús quitac ne sihuat, ijcuacón Yejuatzin quinotzac huan quilij ijcuín: ―Tejua sihuatzin, axcan nimitztacajcahualtij ya de ne cocolis ten ticpíaya. ");
INSERT INTO azzNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Huan ijcón Jesús momasohuac ipan ne sihuat cocoxque huan de ompa tech ne momento momelaxquetzac ne sihuat. Huan yejua pehuac quimohuistilía Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Pero in tayecanque de ne tiopan de judíos mohueyiyolcualantij porín quitac que Jesús quipajtij se cocoxque tech in tonal de ne sehuilis. Ica ya nojón ne tayecanque quinilij in tagayot ijcuín: ―Ongac chicuasen tonal para se tequitis. Huan como nanquinequij nanmopajtisque, ijcuacón xihualacan senmanajpan huan amo xihualacan tech in tonal de ne sehuilis para nanmopajtisque. ");
INSERT INTO azzNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ijcuacón Totecotzin quinanquilij ijcuín: ―Namejuan semi hueyi nantacajcayahuani. Nicmati que senme de namejuan nanquitomaj namocuacuohue oso namoburro para nancuicasque huan nantamacatihue tech in tonal de ne sehuilis. Huan nojón xicmatican que no tequit cuac ijcón nanquichihuaj. ");
INSERT INTO azzNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Pero nijín sihuatzin cocoxque, yejua teconeu de ne tohuejcautat de Abraham. Huan in Satanás quitajyohuiltijtihuitz ya ica nijín cocolis para nijín caxtolomeyi xiutica ya. ¿Xe amo Dios quimonequiltía ma nictacajcahualtis nicocolis de nijín sihuat, masqui tech nijín tonal de ne sehuilis? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Huan cuac Jesús quitamiijtoj ya nijín tajtolme, ijcuacón nochi neques ten quixnamicque nitajtolis de Jesús, yejuan nojonques mopinautijque. Pero nochi in pueblojuani moyolpactiayaj cuac quitacque nochi in mohuiscatequime ten quichiutinemía Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Huan in Jesús quinmachtiaya in tagayot ica se nexcuitil huan quiniliaya ijcuín: ―Nicui nijín nexcuitil para nicnejnehuililtía se cuouxinach ten monotza mostazajtet ihuan nijín ihueyichicahualis de Dios tenica Yejuatzin techyolyecantinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nicnejnehuililtía ne ichicahualis de Dios queme se cuouxinach ten quilía mostazajtet. Huan mochihuac que se tagat quicuic in mostazajtet huan quitocac tech ne imila. Huan ne mostazajtet ten quitocac ixuac huan moscaltij huan mochihuaco se hueyi cuohuit. Huan hualaya in tototzitzin ten pantantinemij ejecaixco huan ompa motapajsoltíaj tech imatzacaluan. ");
INSERT INTO azzNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Huan ijcón Jesús ocsepa quinmachtiaya in tagayot ca se nexcuitil ijcuín: ―Nicui nijín nexcuitil para nicnejnehuilittía in levadura ihuan nijín ichicahualis de Dios tenica Yejuatzin techyolyecantinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Huan ne levadura yejua ne ten tamajmahualis ten quiposonaltía in pantixti. Huan se sihuat quicuic tamajmahualis huan quimaneloa ihuan eyi tamachiu de harina. Ica ya nojón ne tamajmahualis quiposonaltía nochi in tixti de harina. ");
INSERT INTO azzNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Huan ijcón cuac in Jesús yaya para ajsis Jerusaléncopaca, ijcuacón panotiaya tech in huejueyi pueblojme huan tech in pueblojtzitzin huan ompa quinmachtijtiquisac in tagayot ica in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Huan senme den taca quitajtoltij Jesús ijcuín: ―Totecotzin, ¿xe amo semi miacque maquisasque de nintajtacoluan? ");
INSERT INTO azzNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Pero Jesús quinilij ijcuín: ―Namechilia monequi ximofuerzajuican de xicalaquican tech ne calten ten amo patahuac ne ten namechajxitis ne eluiyactzinco. Porín melau namechilía que miacque quiyolnejnequisque calaquisque tech ne calten ten amo patahuac pero amo huelisque. ");
INSERT INTO azzNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ma tiquijtocan que se tagat de se calyetoni mehuac ya huan quiyectzacuac ne calten. Pero namejuan nanyetinemisque ne calampa, huan nanquinalcacalatzasque in calten huan nanquilisque ijcuín: “Totecotzin, techontatapohuili ma ticalaquican”. Pero ne tetat namechinnanquilis ijcuín: “Amo namechtatapohuilis porín amo namechixmati de can nanhuitze”. ");
INSERT INTO azzNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ijcuacón namejuan nanpehuasque nanquilisque ne tetat ijcuín: “Tejuan titacuayaj huan titayayaj vino mohuan. Huan tejua titechmachtiaya tech in plazajteno”. ");
INSERT INTO azzNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Pero ne tetat namechnanquilis ijcuín: “Namechilij ya que amo namechixmati de can nanhuitze. Xinechtapatahuilican nochi namejuan ten nanquichiutinemíaj tajtacol san”. ");
INSERT INTO azzNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Huan cuac mochihuas ne tatzacuiltilis de Dios, ijcuacón namejuan nanchocasque huan nantananatzocatosque ica tajyohuilis. Porín nanquitasque ne huejcautetame Abraham huan Isaac huan Jacob. Huan no nanquitasque nochi in tanahuatiani de Dios que nochi yejuan yetinemisque imaco Dios campa Yejuatzin quinyolyecantinemi ica ihueyichicahualis. Pero namejuan namechcalantamotasque de ne ihuelilispan de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Porín nanquitasque que hualasque in taca taneltocani desde ne iquisayampa tonaltzin huan no hualasque desde ne ipoliuyampa tonaltzin huan no hualasque desde ne ajcopa huan hualasque desde ne tanipa. Huan nochi yejuan nojón taneltocani hualasque huan calaquisque huan motalitihue para sentacuasque ne campa ihuelilispan de Dios campa Yejuatzin quinyolyecantinemi itaneltocacahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ijcuacón sequin de namejuan ten axcan namechpohuaj que nantacuitapanme ya, namejuan nanmochihuatihue tayecanani iixpantzinco Dios porín nanquiselijque ca cuali in Tajtoltzin de Dios. Huan no sequin de namejuan ten axcan nanmopohuaj nantayecanani, namejuan namochihuatihue nantacuitapanme iixpantzinco Dios porín amo nanquiselijque in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Huan tech ne tonal motoquijque campa Jesús yetoyaj sequin tamatinime fariseos huan quilijque Jesús ijcuín: ―Xiquisa de nican porín in rey Herodes quinequi mitzmictis. ");
INSERT INTO azzNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Huan Jesús quinnanquilij ijcuín: ―Ta, xiyacan xiquilican ne tacajcayauque rey Herodes ijcuín: “Xiquita, tech nijín tonalme mosta huan huipta niquincalanquixtiti oc in amocuali ejecame. Huan no niquinpajtiti oc in cocoyani. Huan de ompa niman motamichihuas notequiu”. ");
INSERT INTO azzNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Porín semi monequi nicsentocas nitequititiyás tech noojpan axcan huan mosta huan huipta huan tech in tonalme ten niman hualajtoc. Pero semi monequi ma niajsiti Jerusaléncopaca porín amo nechnamiqui que Nejuatzin nitanahuatijcau de Dios ma nimomiquili calampa den pueblo Jerusalén. Ica ya nojón ne rey Herodes amo huelis nechmictiquiu nican. ");
INSERT INTO azzNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Huan no Jesús quinilij ijcuín: ―Namejuan nanpueblojuani de Jerusalén, namejuan nanquinmictijtihuitze tanahuatiani de Dios. Huan namejuan nanquintepoxonijtihuitze itanojnotzcahuan de Dios ten Yejuatzin namechinualtitanilij. Namechilía que miacpa nicnequía namechsentilis para namechtampahuis ica nochicahualis huan namechyecanas nochi namejuan nanpueblojuani de Jerusalén. Huan nicnequía namechpalehuis ijcón queme in piotapachojque quinsentilía nipiluan iejtapaltampa. Pero namejuan amo nanmotecahuilijque ma namechpalehuis. ");
INSERT INTO azzNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Xiquitacan namejuan, axcan Dios namechsencahuac ya, namejuan namochancahuan huan namopueblojcahuan. Huan no namechilía que amo queman nannechitasque oc. Ta, sayó ijcuac ne tonal cuac namejuan nanmoyolnemilisque de namotajtacoluan. Huan no nannechilisque de Nejuatzin ijcuín: “Tejuatzin tiontatiochihual de Dios, huan tionualajtoc itencopaca tohueyi Totayecancajtzin Dios”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Huan mochihuac tech se tonal de nesehuilis que Jesús yajqui tacuato ichan se tayecanque fariseo. Huan ompa ocsequin tamatinime fariseos quipijpixtoyaj Jesús para huelis quipajpantisquía ica tensá tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Huan ompa iixpan Jesús yetoya se tagat cocoxque ten pojposahuaya ya ninacayo. ");
INSERT INTO azzNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ijcuacón Jesús quintajtoltij neques fariseos huan tanextiliani den tanahuatil de Moisés ijcuín: ―¿Cox Dios quimonequiltía ma se quipajti se cocoxque tech in tonal de nesehuilis? Oso, ¿cox Dios amo quimonequiltía? ");
INSERT INTO azzNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Huan ne fariseos huan tanextiliani sayó motentamatilijque san. Ica ya nojón ne Jesús quicuic in cocoxque huan quipajtij huan de ompa quilij ma yohui. ");
INSERT INTO azzNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Huan ijcón Jesús pehuac quinilía ne fariseos ijcuín: ―Huan como namoburro oso namocuacuohue huetztosquía huan mopantamotasquía tech se talcomit, ¿xe namejuan amo nanquiquixtitihue nimantzin masqui tech in tonal de nesehuilis? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ica ya nojón ne fariseos amo teyi huelic ica quinanquilijque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Huan Jesús quitac de queniu ne tanotzalme quijitacque can motalisque campa cachi mohuistic in sillas tech se iluit. Ica ya nojón Jesús quinmachtij ica se nexcuitil ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","―Cuac acsá mitznotza huan mitzuicas tech se iluit de nenamictilis, ijcuacón cuac tiajsis amo ximotaliti tech in silla den cachi mohuistic. Pues como ijcón ticchihuas, ijcuacón huelis ejcotihuetzis ocsé tagat tanotzal ten cachi hueyi chiuque huan que tejua. ");
INSERT INTO azzNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Huan como ejcos ne cachi hueyi chiuque, ijcuacón huelis hualas in patrón ten namechnotzac xiiluitiqui huan huelis mitzilis ijcuín: “Tejua ximajchihua huan xicahuili ne mohuistic silla para nijín tanotzal ten cachi hueyi chiuque”. Ijcuacón tejua ipa quipía de timajchihuas huan ijcón timopinaucatalijtiyás huan timotaliti ne campa ne silla ten cachi tacuitapampa. ");
INSERT INTO azzNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ta, namechilía cachi cuali cuac acsame mitznotzasque xiiluititi, ijcuacón ximotaliti tech ne silla ten cachi tacuitapampa. Huan cuac hualas ne patrón ten mitznotzac xiiluititi, ijcuacón yejua mitzilis ijcuín: “Notasojicniu, ximopanolti cachi taixpan campa cachi tamohuisyojcan”. Huan ijcón cachi oc mitzueyichihuasque nochi neques ten ompa tocotzyetocque. ");
INSERT INTO azzNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Huan namechyequilía que nochi neques ten mohuejueyichihuasque, yejuan nojonques Dios quintalpantalis. Huan nochi neques ten mopohuaj que amo hueyi chihuanime, yejuan nojonques Dios quinueyitalis. ");
INSERT INTO azzNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Huan no Jesús quilij in tayecanque fariseo ten quinotzac Jesús ma iluititi ijcuín: ―Huan cuac tejua ticnequi tiquintatamacas acsame, ijcuacón amo xiquinnotza motasojicnihuan huan nión no mocnihuan. Huan amo no xiquinotza moparientes huan nión movecinos ten ricojme. Huan amo xiquinnotza nochi yejuan ma mohuan tatacuaquij porín yejuan cuali huelis momacuepasque huan mitznotzasque xitatacuati ninuan. ");
INSERT INTO azzNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ta, namechilía que cachi cuali cuac ticnequis tiquintatamacas acsame, ijcuacón xiquinnotza neques ten amo teyi quipíaj huan neques ten macotoltijque. Huan no xiquinnotza neques ten coxojme huan ixpojpoyome. ");
INSERT INTO azzNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Huan como tiquinnotza ma iluitiquij nojonques, ijcuacón Dios mitzmactilis yolpaquilis porín yejuan amo huelisque mitznotzasque no xitatacuaqui tech ninchan. Huan ijcón tejua ticpías se hueyi tetayocolil imaco Dios tech ne tonal cuac Yejuatzin quinpanquixtis yoltocque nochi in taneltocani ten yolchipauque. ");
INSERT INTO azzNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Huan cuac quicayic senme de neques ten tatacuatoya ihuan Jesús, ijcuacón yejua quilij Jesús ijcuín: ―Tatiochihual de Dios huan semi yolpaqui ne tagat ten tatacuaqui ihuan neques ten Dios quinyecantinemi ica ne ichuahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ijcuacón Jesús quinmachtij in tagayot ica se nexcuitil ijcuín: ―Se tonal mochihuac que se patrón quinecquic quintatamacas miacque huan tatitanic ma quinnotzacan míac tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Huan cuac ejcoc ya in hora para tatacuasque, ijcuacón ne patrón quintitanic itaquehual que ma yejua quinnejmachtiti ya neques ten ninpatrón ipa quinnotzaca ya huan ma quinili ijcuín: “Niman xihualacan ya, xitatacuaquij ya porín nochi yetoc ya”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ijcuacón nochi neques tanotzalme peuque moyayajcanecquij seco. Huan se tanotzal quilij in taquehual ijcuín: “Yequimpan nicohuac se tal huan quipía de niyás niquinitatiu. Ica ya nojón xiquilij mopatrón ma nechontapojpolui que amo huelis niyás nitatacuatiu”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Huan ocsé tanotzal no quilij in taquehual ijcuín: “Yequintzin niquincohuac macuil yuntas de cuacuejme huan nicnequi niquinejecotiu cox huelis tequitisque. Ica ya nojón nimitzontatautía que xiquili mopatrón ma nechontapojpolui que amo huelis niyás nitatacuatiu”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Huan ocsé tanotzal no quijtoj ijcuín: “Yequimpan nimonamictij. Ica ya nojón amo huelis niyás nitatacuatiu”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Huan cuac in taquehual mocuepa ichan ipatrón, ijcuacón yejua nochi quitapohuij ipatrón ten quiluijque ne ten tanotzalme. Ica ya nojón ne patrón mocualantij huan quilij itaquehual ijcuín: “Nimantzin xiyati xihualnemiti tech huejueyi ojme huan tech ojtzitzin den pueblo huan xiquinualcui nican para tatacuasque neques ten amo teyi quipíaj. Huan no xiquinualcui ne cocotoltijque huan ne coxome huan ne ixpojpoyome”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Huan satepan cuac in taquehual tami nemico ya, ijcuacón yejua quilij ipatrón ijcuín: “Notecotzin, axcan nictamichihuac ya ijcón queme tinechnahuatilij ya. Huan tacautoc oc ne calijtic para ocsequin tatacuasque”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ijcuacón in patrón quilij itaquehual ocsepa ijcuín: “Xiyó xihualnemiti tech in huejueyi ojme huan tech in ojtzitzin de pueblo huan xiquinfuerzajui ocsequin taca ma hualacan huan ma calaquican tech nochan ma pexoni nochan de tatacuani. ");
INSERT INTO azzNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Porín namechyecquilía que neques ten achtopa niquinotzac ya ma tatacuaqui ten amo quinequij hualasque, yejuan nojónques amo queman tatacuasque nohuan”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Huan se tonal huel míac tagayot quitoctiliayaj Jesús huan Yejuatzin moicancuepac huan quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","―Huan namejuan nanquintasojtaj namotatuan huan namonanuan huan namosihuahuan huan namoconehuan huan namoicnihuan taca huan namoicnihuan sihuame. Huan no nanquintasojta hasta namotalnamiquilisuan. Pero monequi cachi xinechtasojtacan Nejuatzin huan que nochi nijinques. Huan como amo nannechyectasojtaj, ijcuacón amo huelis nannechtoctilisque huan nión no huelis nanmochihuasque nannomomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Huan Jesús quinnextiliaya in tacaquini ica nijín nexcuitil ijcuín: ―Nicnejnehuililtía in cruz queme se tajyohuilis. Huan como notaneltocacahuan amo taxicojtiyasque ica nijín tajyohuilis cuac nechtoctilisque, ijcuacón yejuan amo huelis mochihuaquihue nomomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Huan Jesús quinnextiliaya in tacaquini ica se nexcuitil ijcuín: ―Huan namejuan cuac nanquinequij nanquichihuasque se huejcapan tepan, ijcuacón achto nanmosentilíaj para nanquixejecoaj de canachi tomin monequis para nanquitamichihuasque ne tepan. Huan cuac nochi nanquixejecojque ya que ajsis ya in tomin, ijcuacón nanquimatij ya que melau nanquitamichihuasque ya ne tequit. ");
INSERT INTO azzNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Huan tacán amo achto cuali nanquixejecoaj, ijcuacón amo huelis nanquitamichihuasque in tequit. Porín como nanquintalisque ya in tatzinehualoni huan tamis namotomin, ijcuacón amo huelis nanquitamichihuasque in tequit. Huan ijcón in tagayot pehuaj namoca paquij san. ");
INSERT INTO azzNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Huan quijtosque sequi ijcuín: “Ne taca peuque quijchihuaj se tepan, pero amo huelic quitamichiuque”. ");
INSERT INTO azzNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Huan ocsepa Jesús quinmachtiaya in tacaquini ica se nexcuitil ijcuín: ―Huan ma tiquijtocan que se rey quinequi motehuis ihuan ocsé rey. Ica ya nojón ne achto rey ten quiyolnemilía motehuis, yejua ne mosentilía ihuan iteyolmajxiticahuan. Huan ijcón mosenixejecoltíaj cox huelis motehuitihue ica májtacti mil soldados para quintanilisque ne ocsé rey ten cualcui sempoal mil soldados. ");
INSERT INTO azzNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Huan tacán ne achto rey quixejecoa que amo huelis quitanilis ne ocsé rey ten cachi míac soldados quincualcui, ijcuacón yejua quititani se itetajtohuijcau para yejua quinojnotzatij ne ocsé rey cuac huejca oc motztocque. Huan ijcón ne itetajtohuijcau quitajtaniliti ne ocsé rey que ma amo onca oc ne netehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Huan no Jesús quilij in tagayot ijcuín: ―Como namejuan nanquinequij nanmochihuasque nannomomachtijcahuan, ijcuacón monequi xiquixejecojtiyacan queniu nannechtacamatiyasque huan ijcón xicsecocautiyacan nochi ten namoaxca. ");
INSERT INTO azzNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Huan no Jesús quinilij in tacaquini ijcuín: ―Semi huelic in istat. Pero tacán in istat quipoloa ne ichicahualis, ijcuacón ¿queniu huelis ocsepa poyeyas, como amo quipía oc nipoyecayo? Pues amo huelis. ");
INSERT INTO azzNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ica ya nojón ne istat amo teyi cualtía huan amo no quipalehuis in tal huan amo no cualtía queme tapalan. Ta, sayó se quitamotas. Huan no ijcón mochiutos inpan neques ten quinequi nechtacamatisque. Monequi ma mofuerzajuican ica nochi nintalnamiquilis de nechtoctilisque huan nechtacamatisque. Huan nochi neques ten quipíaj ninnacasuan para tacaquisque, ma yec tacaquican. ");
INSERT INTO azzNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Huan motoquijque campa Jesús yetoya míac tatopaluiani huan neques ten amo tatacamatinemij ica in tanahuatil de Moisés. Huan yejuan motoquicoj para quicaquilisque Jesús itanojnotzalis. ");
INSERT INTO azzNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ica ya nojón in tamatinime fariseos huan in tanextiliani den tanahuatil de Moisés, yejuan nojonques quitejtenehuayaj Jesús huan quijtoayaj ijcuín: ―Nijín tagat Jesús quinselía huan ninuan tacuaquij nochi neques ten amo quitacamatinemij in tanahuatilme de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ijcuacón Jesús quinmachtij in tacaquini ica nijín nexcuitil ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","―Ma tiquijtocan que senme de namejuan quipiaya macuilpoal ichcame huan senme de ne ichcame polihuic. ¿Cox amo in tapixque quincahuac ne cuouta in ocsequin nahuipoal huan caxtolonahuin ichcame huan yohui quitemoa hasta cajsis ne ichcatzin ten polihuic? Pues quema. ");
INSERT INTO azzNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Huan ne tapixque cuac cajsis ya ne ichcatzin ten poliuca ya, ijcuacón yejua quicuis huan moquechcochtalilis huan yohui moyolpactijtiu. ");
INSERT INTO azzNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Huan cuac ne tapixque ajsis ya ichan, ijcuacón yejua quinsentilis ne itasojicnihuan huan ichancahuan huan quinilis ijcuín: “Ximoyolpactican ijcón queme nejua. Porín nicajsic ya ne ichcatzin ten ixpoliutoya ya”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Huan Totajtzin Dios quitztinemi ne nahuipoal huan caxtolonahuin taca ten mopohuaj yolchipauque ya, ten quinemilíaj que amo monequi moyolnemilisque oc que de nintajtacoluan. Pero no namechilía que Dios ihuan in ángeles nepa eluiyactzinco no cachi oc moyolpactíaj ica por se tagat tajtacole ten yequin moyolnemilij ya huan quicahuac ya nitajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Huan Jesús quinmachtij in tagayot ica nijín nexcuitil huan quiniliaya ijcuín: ―Huan se sihuat quipiaya májtacti tomin de plata, quijtosnequi májtacti tonal taxtahuil. Huan yejua quipoloj se tomin. Huan ne sihuat quixotaltía se tanex huan de ompa pehua tachpana ica nejmach ne icalijtic huan quitemoa ne tomin hasta queman cajsi. ");
INSERT INTO azzNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Huan cuac ne sihuat cajsi ya itomin, ijcuacón yejua quinsentilía itasojcaicnihuan huan ichancahuan huan quinilía ijcuín: “Ximoyolpactican ijcón queme nejua, porín nicajsic ya notomin ten nicpolojca ya”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Huan Nejuatzin namechilía que Dios ihuan in ángeles nepa eluiyactzinco melau no cachi oc moyolpactía cuac se tagat tajtacole moyolnemilía huan quicahua nitajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Huan ocsepa Jesús quinmachtij in tagayot ica se nexcuitil ijcuín: ―Se tagat quipiaya ome iconehuan. ");
INSERT INTO azzNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Huan iconeu taxocoyot quilij itat ijcuín: “Notajtzin, xinechonxelohuili de nejua nechnamiqui nicselis de moricoyo”. Ijcuacón in tetat quinxejxelohuilij de ninricojyo ne ome iconehuan. ");
INSERT INTO azzNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Huan nimampa de sequin tonalme ne teconeu taxocoyot quisentilij nochi ten niaxca. Huan de ompa quistehuac huan yajqui huejca tech ocsé país. Huan ompa quitamipojpoloto nochi nitomin tech in ahuilnemilis. ");
INSERT INTO azzNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Huan cuac quitamipojpoloj ya nochi nitomin, ijcuacón amo huejcahuac huan huala se hueyi máyanti tech ne país. Huan ne teconeu taxocoyot pehuac mayancanentinemi ya. ");
INSERT INTO azzNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ijcuacón yejua yajqui quitemoto tequit ihuan se patrón tech ne país. Huan ne patrón yejua quititanic ma quinpiati sequin pitzome campa italpan ne patrón. ");
INSERT INTO azzNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Huan ne tapixque quinequía quicuas huan ixhuis ica in cuoutaquilot ten tamati queme in huaxin tenica quintamacayaj in pitzome. Huan ijcón quinequía quichihuas ne telpocat porín amo aquen quitamacaya yejua. ");
INSERT INTO azzNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","De ompa ne telpocat tapixque ocsepa quiyolelnamic huan quinemiliaya ijcuín: “Miacque tequitini quinpía notajtzin ompa ichan huan nochi yejuan cuali ixpanotocque hasta mocautiu oc tacualis oc. Huan nejua nimayanmictinemi nican. ");
INSERT INTO azzNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ica ya nojón nejua nimoquetztehuas huan niyás nicajsitiu notajtzin huan niquilis ijcuín: Notajtzin, nimohueyitajtacolmacac iixpantzinco Totajtzin Dios ten ne eluiyactzinco huan no nimotajtacolmacac moixpantzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Huan axcan nimitzilis notajtzin que amo nechnamiqui oc ma xinechpohua queme nimoconeu. Ta, xinechpohua queme sayó se motaquehual”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ijcuacón ne telpocat moquetztehuac huan yajqui huan ajsito campa yetoya ichan itajtzin. Huan cuac ne telpocat ajsitiaya ichan itajtzin, ijcuacón itajtzin conitac huan quihueyiyolicnelij. Huan ne tetat motaloj quinamiquito iconeu huan quiquequechnahuato huan quitennamic. ");
INSERT INTO azzNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ijcuacón in telpocat quilij itajtzin ijcuín: “Notajtzin, nimohueyitajtacolmacac iixpantzinco Dios huan no nimotajtacolmacac moixpantzinco. Ica ya nojón axcan amo nechnamiqui xinechpohua queme nimoconeu”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Pero in tetat quinnahuati sequin itaquehualuan ijcuín: “Xiquixtitij nimantzin ten cachi cuali taquemit huan xictaquentican nijín noconetzin huan xicmajpiltalilican se anillo huan no xictegactican”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Huan de ompa ocsepa quinilij itaquehualuan ijcuín: “Xicualcuican se cuacuejtzin ten tictomauque ya huan xicmictican huan ma titatacuacan huan ma tiiluichihuaca. ");
INSERT INTO azzNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Huan ma tiiluichihuacan porín nijín noconetzin nicpolojca ya queme yesquía momiquilisquía. Pero axcan ocsepa yoltinemi. Huan nijín noconetzin ixpoliuca ya, pero axcan ocsepa ixnesico”. Ijcuacón nochi ichancahuan peuque moyolpactíaj tech ne iluit. ");
INSERT INTO azzNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Huan cuac iluichiutoque ya, ijcuacón in itayecancaconeu yetoya itequipan. Huan cuac hual mocuepac ya de nitequipan huan motoquijtihualaya ya campa ichan, ijcuacón yejua quicayic sequin tatzotzonani huan no quicayic que mijtotijtoyaj. ");
INSERT INTO azzNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Huan ne tayecancaconet quinotzac se taquehual huan quitajtoltij de toni mochiutoc. ");
INSERT INTO azzNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ijcuacón ne taquehual quinanquilij in tayecancateconeu ijcuín: “Huan nochi nijín iluit mochiutoc porín ejcoc ya mocniu. Huan motat tatitanic ma ticmictican in cuacuejtzin ten tictomauque ya. Huan motat quichihuac nochi nijín, porín mocniu ocsepa ixnesico huan cuali ejcoc huan amo mococoa”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Pero ne tayecancateconeu yolcualanic huan amo quinequía calaquiti tech ne iluit. Ica ya nojón ne itat calanquisac huan quitatautito itayecancaconeu ma calaquito. ");
INSERT INTO azzNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Pero itayecancaconeu quinanquilij itat ijcuín: “Xiquita, cuali ticmati canachi xiutica ya nimitztequitilijtoc huan nachipa nimitztacamatihuitz. Huan amo queman tinechmacac nión se chivito para ma niiluichihua ihuan notasojicnihuan. ");
INSERT INTO azzNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Pero axcan ejcoc ya ne moconeu que nochi quiahuiloto ya motomin ihuan sihuame ahuilnemini. Huan tejua ticmictilij in cuacuejtzin ten tictomaucayaj ya para tiquiluichihuilis”. ");
INSERT INTO azzNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ijcuacón itat quinanquilij iconeu ijcuín: “Noconetzin, tejua melau nachipa nohuan titequititoc huan axcan nochi noaxca yetoc momaco. ");
INSERT INTO azzNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Pero axcan semi quinamiqui ma tiiluichihuacan huan ma timopactican. Porín mocnitzin poliuca ya queme yesquía momiquilisquía pero axcan ocsepa yoltinemi. Huan nijín noconeu ixpoliuca ya, pero axcan ocsepa ixnesico tohuan”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Huan Jesús quinmachtiaya imomachtijcahuan ica nijín nexcuitil: ―Se tonal oncaya se patrón ten semi rico ten quipiaya se itayecancataquehual. Huan mochihuac que acsame quiteluilitoj ne itayecancataquehual inahuac in patrón de que yejua quiahuilojtoc ten iixca in patrón. ");
INSERT INTO azzNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ijcuacón in patrón quinotzac ne itayecancataquehual huan quilij ijcuín: “¿Toni quijtosnequi nijín tajtolme ten nejua nictecaquilij de tejua? Axcan nicnequi ma tictepotztocacan tocuenta de motequiu porín axcan amo ticsentocas titequitis queme tinotayecancataquehual”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ijcuacón ne tayecanque taquehual pehuac moyolnemiliaya ijcuín: “Axcan, ¿toni nicchihuas porín nopatrón amo nechmacas oc tequit? Huan nejua amo semi nichicahuac para nisalontequitis. Huan no nipinahua para nimotaehuijtinemis. ");
INSERT INTO azzNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Pero axcan nicmati de toni nicchihuas para cuac amo nicpías oc tequit, ijcuacón sequin notasojicnihuan nechselisque huan nechixpanoltisque campa ninchan”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ijcuacón ne tayecanque taquehual pehuac quinnotzac sejsé nochi neques ten quitahuiquiliayaj ipatrón. Huan in tayecanque taquehual quitajtoltij ne ten motoquico achto ijcuín: “¿Canachi tictahuiquilía nopatrón?” ");
INSERT INTO azzNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Huan ne tagat quinanquilij ijcuín: “Nictahuiquilía mopatrón se ciento barriles de aceite”. Ijcuacón in tayecanque taquehual ocsepa quilij ijcuín: “Nican yetoc mocuenta; ximotalijtihuetzi huan xicchihua ocsé cuenta para ma ixnesi que tictahuiquilía sayó omepoal huan májtacti barriles. Huan de ompa xicfirmaro”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Huan satepan in tayecanque taquehual quinotza ica ome tagat ten quitahuiquiliaya ipatrón huan quitajtoltij ijcuín: “Huan tejua, ¿canachi titahuica?” Huan yejua quilij ijcuín: “Nejua nictahuiquilía mopatrón cien medida de trigo, quijtosnequi macuil ciento almon de trigo”. Ijcuacón in tayecanque taquehual quilij ijcuín: “Nican yetoc mocuenta. Ximotalijtihuetzi huan xicchihua ocsé cuenta para ma ixnesi que tictahuiquilía sayó nahuipoal medidas de trigo, quijtosnequi queme nahui ciento almon de trigo”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Huan de ompa Jesús quinilij in tacaquini que in patrón cuac quimatic toni quichihuac itayecancataquehual ten amo yolcuali, ijcuacón in patrón quicuatamatcaitac itayecancataquehual porín cuali yolmajsitoc ya tech nitequiu. Huan no ijcón mochiutoc axcan porín in talticpacuani ten axcan nentinemi, yejuan nojonques cachi cuatamatocque tech nintequiu huan quiyolicnelíaj in tagayot. Huan in taneltocani ten tacuautamatinemij ica tanextzin de Dios, yejuan nojonques monequi ma mofuerzajuican de mochihuasque míac amigos ijcón queme quichiutocque in talticpacuani ten amo taneltocani. ");
INSERT INTO azzNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Huan Jesús ocsepa quinilij imomachtijcahuan ijcuín: ―Huan namechilía que xicyectequitiltican ica cuali namoricojyo ten poutoc nican talticpac para ijcón nanquipiasque míac namotasojicnihuan ten tacuautamatisque ihuan Dios. Huan cuac namoricojyo tajtamis ya, ijcuacón Totajtzin Dios ihuan itaneltocacahuan namechselisque nepa eluiyactzinco campa nansenyetosque sen nachipa. ");
INSERT INTO azzNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Huan Jesús ocsepa quilij ijcuín: ―Huan ne tagat ten tequititinemi ica nejmach masqui tepitzin san nitequiu, yejua ne no tequititinemis ica nejmach masqui míac tequit quichiutinemis. Huan ne tagat ten tequititinemi ica tatzihuilis masqui tepitzin san, yejua ne no tequititinemis ica tatzihuilis masqui míac tequit quipías. ");
INSERT INTO azzNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Huan tacán namejuan nanquitequitiltíaj ica tatzihuilis namoricojyo ten poutoc nican talticpac san, ijcuacón Dios amo no namechmactilis xictequitilitican ne yec ricojyot de hualeutoc ne eluiyactzinco ten amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Huan tacán namejuan nanquitatequiutíaj ica tatzihuilis ne ricojyot ten poutinemi ihuan in talticpacuani ten Dios namechtaneutij san, ijcuacón Dios amo no namechaxcatilis se ricojyot de eluiyactzinco ten amo queman tamis para xictatequiutijtinemi tejua san. ");
INSERT INTO azzNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Huan Jesús ocsepa quinilij imomachtijcahuan ijcuín: ―Amo aquen se taquehual huelis quintequitilis ome patrónes sepan san. Porín como ijcón quichihuas ne taquehual, ijcuacón pehuas quitahuelitas se patrón huan quitasojtas in ocsé. Oso no pehuas quitacamatis se patrón huan quimohuispolos in ocsé. Ica ya nojón namechilía que namejuan amo huelis nanquitequitilijtinemisque Totajtzin Dios huan in ricojyot sepan san. ");
INSERT INTO azzNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Huan ompa yetoyaj sequi tamatinime fariseos ten quicactoyaj nochi tajtolme de Jesús huan nochi yejuan sayó quitasojtayaj tomin. Ica ya nojón yejuan quiquejqueloayaj Jesús ica ne por itajtolis. ");
INSERT INTO azzNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ijcuacón Jesús quinilij ne fariseos ijcuín: ―Namejuan nanfariseos nanmopohuaj que nanyolchipauque ya ninixpan in tagayot, pero in Totajtzin Dios cuali namechyolojixmati. Huan Totajtzin Dios quitahuelitztinemi ne nohueyinequilis de ne taca ten mohuejueyinectinemij huan mopohuaj hueyi chihuanime. ");
INSERT INTO azzNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Huan ocsepa Jesús quinmachtiaya in tagayot ijcuín: ―In tanahuatil de Moisés huan ne tanextililisme den tanahuatiani, nochi yejuan namechualyecantihualayaj hasta in tonal cuac nemico in Juan Taahuijque. Pero cuac ixnesico Juan, ijcuacón yejua pehuac namechnextilía in cuali Tajtoltzin de que Dios namechyolyecantiu ica ichicahualis. Ica ya nojón nochi namejuan monequi ximofuerzahuijtiyacan para ma Dios ma namechyolyecantiyás ica ichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Huan no namechilía que huelis tajtamis nochi ten tiquitaj ne ejecaixco huan nican talticpac. Pero namechyequilía que nochi in itanahuatiltzitzin de Dios, yejuan nojonques amo tajtamitihue san. Ta, yec motamichihuatij. ");
INSERT INTO azzNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Huan Jesús ocsepa quinilij in tagayot ijcuín: ―Tacán se tagat quicahua isihuau huan monamictis ihuan ocsé sihuat, ijcuacón ne tagat motajtacolmacas ya queme se ahuilnenque. Huan no tacán ocsé tagat monamictis ihuan ne tesihuau quicautocque, ijcuacón ne tagat motajtacolmacas ya queme se ahuilnenque. ");
INSERT INTO azzNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Huan Jesús ocsepa quinilij in tagayot ijcuín: ―Se tonal oncaya se tagat rico ten motaquentiaya ica cuajcuali tilma ten semi cualtzitzin alaxtic. Huan in rico mosta mosta taluichihuaya huan tatacuaya ca míac cualnescayot. ");
INSERT INTO azzNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Pero nojón tonalme no nemía se pobre ten monotzaya Lázaro huan yejua nochi ninacayo sahuayojtoya huan motaliaya icaltenteno de ne rico. ");
INSERT INTO azzNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Huan no ne Lázaro quinequía ixhuis ica ne tacualis ten quitencajcahuaya in rico ne ten huetzía mesajtampa. Huan ompa campa motaliaya in Lázaro hualayaj in itzcuinme huan quipajpalohuiliayaj nicocohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Huan mochihuac que se tonal momiquilij ne motaehuijque Lázaro huan yejua cuiyacque in ángeles de Dios nepa iixpan Abraham campa quilíaj paraíso. Huan amo huejcahuac huan no momiquilij in rico huan yejua quitalpachojque. ");
INSERT INTO azzNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Huan ne rico tajyohuijtoya ya ne mictan campa tajyohuíaj nochi neques ten amo tacuautamatij ihuan Dios. Huan ne rico moixajocuic huan conita in Abraham huan no conita ne motaehuijque Lázaro iixpan in Abraham. ");
INSERT INTO azzNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ijcuacón ne rico contzajtzilij ijcuín: “Notajtzin Abraham, nechonyolicneli. Huan xicnahuati ne Lázaro ma huiqui huan ma nechnejnepiltaliliqui tzictzin atzin masqui ica imajpil san para ma niyolsehui porín nican semi nitajyohuijtoc tech in tit”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Pero in Abraham quinanquilij ijcuín: “Noconeu, xiquelnamiqui san que tejua nochi ticpixtinemía ten ticnequía tech monemilis. Huan no xiquelnamiqui que nijín Lázaro sayó tajyohuiaya tech inemilis. Ica ya nojón axcan in Lázaro cualtzin yolseucayetoc nican; huan tejua titajyohuijtoc. ");
INSERT INTO azzNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Huan no xicmati que techxelojtoc se hueyi tecoch. Ica ya nojón tejuan amo huelis tipanosque para tamechajsitihue huan nión no namejuan amo huelis nanualpanosque para nantechajsiquihue”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ijcuacón ne rico quilij Abraham ijcuín: “Nimitzontatautía, tejuatzin Notajtzin Abraham, xicontitani Lázaro ma yohui ichan notajtzin. ");
INSERT INTO azzNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Porín ompa yetocque macuil nocnihuan oc. Huan nicnequi que ma Lázaro ma yohui ma quinnojnotzati, para que yejuan ma amo no hualacan nican campa nejua nitajyohuijtoc”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Pero Abraham ocsepa quilij in rico ijcuín: “Amo nicchihuas porín yejuan quipixtocque inmaco in tanahuatil de Moisés huan in tanextililisme den tanahuatiani de Dios. Monequi que mocnihuan ma yejuan ma quicaquican huan ma quitacamatiyacan nochi nojón tanextililisme de Dios”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Huan de ompa in rico tananquilij ijcuín: “Notajtzin Abraham, quema, nocnihuan quipixtocque in Tajtoltzin de Dios, pero achá cachi quineltocasque como yohui se ánima quinnojnotzati para que ma yejuan ma moyolnemilican de nintajtacoluan”. ");
INSERT INTO azzNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Pero in Abraham quilij in rico ijcuín: “Tacán mocnihuan amo quinequij quitacamatisque in Moisés huan nión no quinequi quincaquilisque ne tanahuatiani, ijcuacón yejuan amo no quineltocasque nijín Tajtoltzin de Dios, masqui se tagat panquisas yoltoc intzalan in ánimajme huan quinnojnotzati”. ");
INSERT INTO azzNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Huan Jesús quinilij imomachtijcahuan ijcuín: ―Nachipa oncatiyás in ohuijcayot ten quintajyohuiltía huan quintepotamíaj notaneltocacahuan ma huetzican tech in tajtacol. Pero semi teicneltiani ne talticpacuani ten quintepotamíaj notaneltocacahuan tech in tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Porín cachi cuali para yejuan ma se quinquechpilohuili se hueyi tet queme se metat huan ma se quinatamota tech in hueyíat den mar. Cachi cuali para yejuan que ma momiquiliani huan ma amo quintepotamican nijín notaneltocacahuan tech in tajtacolnemilis. ");
INSERT INTO azzNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Huan namechilía que cuali ximoyecpixtiyacan tech namejuan namonemilis san. Tacán se mocniu motajtacolmaca mopampa, ijcuacón tejua xictacahualti ma amo ijcón quichihua oc. Huan tacán ne mocniu moyolnemilía de nitajtacoluan, ijcuacón tejua xictapojpolui ya. ");
INSERT INTO azzNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Huan ma tiquijtocan que ne moicniu motajtacolmaca mopampa chicojpa tech se tonal huan yejua hualas chicojpa tech se tonal huan mitziliquiu ijcuín: “Axcan nimoyolnemilij ya de notajtacoluan”. Ica ya nojón Nejuatzin nimitzilia tejua, xictapojpolui. ");
INSERT INTO azzNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Huan itanojnotzcahuan de Jesús quitatautijque ijcuín: ―Totecotzin, xitechonmajxitili totacuautamatilis cachi oc. ");
INSERT INTO azzNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ijcuacón in Totecotzin quinanquilij ijcuín: ―Tacán namejuan nanquipiasquíaj tzictzin san tacuautamatilis de Dios queme ne mostazajtet, ijcuacón nanuelisquíaj nanquinojnotzasquíaj ne hueyi cuohuit ten quilía sicómoro porín ne cuohuit queme yesquía se ohuijcayot ten namechtzatzacuilisquía. Huan tiquilis ijcuín: “Tejua, ximohuijuita de nican huan xihuetziti ne tatajco den mar”. Huan como ijcón nanquilisquíaj, ijcuacón ne cuohuit namechtacamatisquía. ");
INSERT INTO azzNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Huan Jesús ocsepa quinilij in tagayot ijcuín: ―Achá senme de namejuan nanquipíaj se namotaquehual ten tayuntajuijtinemi oso tatacualtijtinemi ica in tapialme. Huan cuac yejua mohualcuepa ya de nitequiu, ijcuacón namejuan amo nanquilíaj ijcuín: “Tejua totaquehual, ximosehuiqui huan xitacuaqui nican campa tomesa”. ");
INSERT INTO azzNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ta, namejuan nanquilía ijcuín: “Tejua, totaquehual, xinechtacualchihuili huan ximoyectataliti para tinechtamacas ica tacualis huan ica vino. Huan cuac nejua nitamitacuas ya, ijcuacón tejua no huelis titacuas ya huan titayis movino”. ");
INSERT INTO azzNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Huan namejuan amo nanquitasojcamachilíaj ne taquehual cuac quitamichihuac ya ne tequit ten namejuan nanquinahuatijque; melau amo ijcón nanquichihuaj. ");
INSERT INTO azzNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Huan no namejuan nantaneltocani, cuac nanquitamichihuasque ya namotequiu, ijcuacón monequi nanquijtosque ijcuín: “Tejuan titaquehualme ten amo teyica ticualtíaj, porín ticchiuque sayó ten ticnemiliayaj que monequía ticchihuasque. Cachi cuali ma ticnemilijtiyacan que nachipa ma timotequitilijtiyacan Yejuatzin cachi oc huan que Yejuatzin technajnahuatía”. ");
INSERT INTO azzNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Huan Jesús quisentocaya niojpan para ajsis Jerusalén. Huan panotiaya campa talnamic de Galilea huan de Samaria. ");
INSERT INTO azzNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Huan cuac Yejuatzin ajsic se pueblojtzin, ijcuacón quinamiquicoj Jesús májtacti cocoyani ten ninnacayo cocotocatoc. Pero yejuan sayó mohualquetzque ne huejca san de Jesús, porín nincocolis huelis quimamahuas ocsequin tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Huan yejuan contzajtziliayaj Jesús huan quilijque ijcuín: ―Tejuatzin Jesús, tiontamachtijque, xitechonyolicneli huan xitechonpajti. ");
INSERT INTO azzNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Pero cuac Jesús quinitac ya, ijcuacón Yejuatzin quinilij ijcuín: ―Xiyacan ximotenextilitij inixpan in tiopixcame judíos que namejuan nanchipauque ya. Huan mochihuac que cuac yayaj ya ne cocoyani, ijcuacón yejuan pajtijque huan mocauque chipauque. ");
INSERT INTO azzNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Huan senme de yejuan cuac moitac que pajtic ya, ijcuacón mohualcuepato huan quimohuistilijtihualaya Totajtzin Dios ica hueyi itzajtzilis. ");
INSERT INTO azzNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Huan yejua motancuaquetzac iixpan Jesús huan motentocac huan moixacaquetzac talpan. Huan de ompa quitasojcamachilij Jesús. Huan nijín tagat ten pajtic ya yejua cayot de Samariajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ijcuacón Jesús quitajtoltij ijcuín: ―Huan Nejuatzin namechpajtij nanmajtacme. Huan in ocsequin chicnahuin, ¿can yetoc ne taca judíos ten nopueblojcahuan? ¿Can yetocque? ");
INSERT INTO azzNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Huan tejua tianaltecocayot huan sayó tejua tihualmocuepato para ticmohuistilis Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ica ya nojón nimitzilía ijcuín: ―Ximoquetza huan xiyó ya, nimitzpajtij ya porín tejua titacuautamactic ya nohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Huan in tamatinime fariseos quitajtoltijque Jesús ijcuín: ―¿Quemanían monextiquiu ne ichicaucacualtziyo de Dios de que Yejuatzin techyolyecantiyás nican talticpac? Huan Jesús quinnanquilij ijcuín: ―Amo aquen huelis quitasque cuac monextiquiu ne ichicaucacualtziyo de Dios nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ica ya nojón amo huelis se quinilis ijcuín: “Nican yetoc ne ichicaucahuelis de Dios”, oso “Ne yetoc ya”. Huan amo huelis ijcón se quilis porín ne ichicaucacualtziyo de Dios ipa ejcoc ya huan mochiutoc ya totzalan. ");
INSERT INTO azzNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Huan Jesús ocsepa quinilij imomachtijcahuan ijcuín: ―Ejcosque in tonalme cuac namejuan nanquiyolnejnequij nanquitasque oc ne tonal cuac Nejuatzin ni Yectagatzin de Dios nitayecanaquiu nican talticpac pero namejuan amo nanquitasque. ");
INSERT INTO azzNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Huan ijcón in talticpacuani namechilisque ijcuín: “Cristo nican tayecantoc”. Oso namechilisque ijcuín: “Cristo nepa tayecantoc”. Ijcuacón amo xiyacan huan amo xiquinneltoquilican. ");
INSERT INTO azzNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Huan ijcón queme nanquitaj cuac tapetani sepa san ejecaixco, no ijcón yesqui tech ne tonal cuac Nejuatzin ni Yectagatzin de Dios nimohualuicas nican talticpac. Porín ijcuac nannechitasque nihualajtos ica nochi nochicaucacualtziyo. ");
INSERT INTO azzNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero achtopa que ocsepa nimohualuicas nican talticpac monequi que achto nitajyohuis. Huan ne talticpacuani ten axcan nentinemij, yejuan nojonques monequi que nechmajpehuasque huan nechtajyohuiltisque. ");
INSERT INTO azzNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Huan ijcón queme mochihuac se ixpolihuilis ne tonalme cuac Noé nemico, no ijcón mochihuas ne ixpolihuilis tech in tonal cuac Nejuatzin ni Yectagatzin de Dios nimohualuicas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Huan tech ne tonalme cuac nemico Noé, ijcuacón in talticpacuani sayó tatacuayaj huan mohuintiayaj huan monamictiayaj huan mosihuamonijtantinemíaj. Huan nijín ijcón quichiutoyaj hasta ne tonal cuac in Noé calayic tech ne hueyi barco ten quilía arca. Huan ijcón Dios quinualtitanilij ne hueyi tetzaucaquiohuit huan nochi in tagayot momiquilijque. ");
INSERT INTO azzNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Huan no mochihuac in ixpolihuilis tech ne tonalme cuac Lot nemico. Porín in talticpacuani sayó tatacuayaj huan tahuanayaj huan tacohuayaj huan tanamacayaj huan tatocayaj huan calchihuayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Pero tech ne tonal cuac in Lot quisac de ne pueblo de Sodoma, ijcuacón Dios quinualpixohuilij tit huan azufre impan in talticpacuani huan ijcón quintamimictij nochi. ");
INSERT INTO azzNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Huan no ijcón mochihuas se ixpolihuilis tech in tonal cuac nimonextiquiu Nejuatzin ni Yectagatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Huan tech ne tonal cuac nimonextiquiu ya, tacán acsá moajsi necalcuaco, ijcuacón yejua ma amo temo para quiquixtitiu ten niaxca nepa calijtic. Huan no ijcón tacán acsame moajsi ne itequipan, ijcuacón ma amo mohualcuepacan nichan para quiquixtiquiu ten niaxca. ");
INSERT INTO azzNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ica ya nojón namechilía cuali xiquelnamictiyacan de queniu momiquilij ne isihuau de Lot. ");
INSERT INTO azzNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Huan neques ten quiyolnejnequij quimaquixtisque ninnemilis, yejuan nojonques quixpolosque ninnemilis. Huan nochi neques ten quipía tanejnequilis de motemactisque nohuan hasta tajyohuisque huan quipolosque ninnemilis, yejuan nojónques nentinemisque sen nachipa. ");
INSERT INTO azzNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Huan no namechilía que cuac Nejuatzin nimohualuicas, ijcuacón tech ne tayohuac yetosque ome tech se cochpetat san. Huan Dios quiajocuis se huan quicahuas in ocsé. ");
INSERT INTO azzNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Huan no tech ne tonal cuac nimohualuicas, ijcuacón ome sihuame sen tixcuechojtosque. Huan Dios cajocuis se huan quicahuas in ocsé. ");
INSERT INTO azzNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Huan no tech ne tonal cuac Nejuatzin nimohualuicas, ijcuacón ome taca tequititosque milajpa. Huan Dios cajocuis se huan ocsé quicahuas. ");
INSERT INTO azzNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ijcuacón imomachtijcahuan quitajtoltijque Jesús ijcuín: ―Totecotzin, ¿can mochihuaquiu nochi nijín? Huan Jesús quinanquilij ijcuín: ―Campa yesqui huetztoc se miquet, no ompa mosentilíaj míac tzopilome. Porín cuali quimatij ne tzopilome can huetztoc se miquet huan ompa mosentilijtihuetzij. Huan no ijcón mosentilijtihuetzisque notaneltocacahuan cuac Nejuatzin nimohualuicas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Huan ijcón Jesús quinmachtij in tagayot ica se nexcuitil de monequi ma motatatautilisque ihuan Dios huan ma amo yolcuetahuican de motatatautilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Huan Jesús quinilij ijcuín: ―Huan oncaya tech se pueblo se tequihua juez ten amo quimohuistilíaya Dios huan nión no quitacachihuaya in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Huan tech nojón mismo pueblo no oncaya se sihuacahual. Huan nojón sihuacahual mosta mosta conitaya juez huan quitatautiliaya in juez ijcuín: “Xinechonmaquixtis imaco ne ten nechchihuilij ten amocuali”. ");
INSERT INTO azzNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Huan míac tonalme panocque ya huan ne juez amo quinequía quipalehuis ne sihuacahual. Pero satepan ne juez pehuac moyolnemiliaya ijcuín: “Nejua amo nicmohuistilía Dios huan nión no niquintacachihua in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Pero queme nijín sihuacahual quisentoca nechcuejmoloqui, ica ya nojón nicpalehuis ne sihuacahual para ma amo quisentoca oc huiqui. Porín amo cachi nitaxicos oc de que ma quisentoca nechcuejsoqui”. ");
INSERT INTO azzNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ijcuacón Jesús quinilij in tagayot ijcuín: ―Cuali xicaquican ten quijtojca ne juez ten amo yolcuali. ");
INSERT INTO azzNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Porín Totajtzin Dios no ijcón quichihuas huan Yejuatzin techpalehuis huan techmaquixtis porín tejuan tiitaijitaluan huan tejuan timotatatautilíaj yohual itonal que Yejuatzin ma techpalehui. Huan no namechilía que Totajtzin Dios amo huejcahuas de techpalehuis. ");
INSERT INTO azzNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Huan no namechilía que Totajtzin Dios niman namechpalehuijtiyás. Pero cuac Nejuatzin ni Yectagatzin de Dios nimohualuicas ya nican talticpac, ijcuacón tech nojón tonal, ¿xe niquinajsis oc neques ten melau nohuan tacuautamatinemij nican talticpac? ");
INSERT INTO azzNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Huan Jesús ocsepa quinmachtía in tagayot ica se nexcuitil de ne taca ten mopohua yolchipauque huan de ne taca ten quinmohuispoloaj ocsequin tagayot. Huan Jesús quiniliayaj ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","―Se tonal mochihuac que ome taca yajque campa tiopan de judíos para ompa motatatautilisque ihuan Dios. Se tagat catca tamatque fariseo huan in ocsé tagat catca tatopaluijque ica tomin. ");
INSERT INTO azzNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Huan mochihuac que ne fariseo moquetzac huan majyá monojnotzaya iselti san pero quijtoj ijcuín: “Notajtzin Dios, nimitztasojcamachilía porín nejua amo niquinnejnehuilía queme ne ocsequin taca ten tachtequini huan queme neques ten semi amo yolchipauque huan queme neques ten ahuilnentinemij. Huan nión no amo nicnejnehuilía queme ne tatopaluijque. ");
INSERT INTO azzNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nejuatzin cachi oc nicchiutinemi cuali chihualisme huan que ocsequin taca. Porín nejua nimosahua ojpa se semana huan no nictemactía nodiezmo de nochi ten nimotatanilía”. ");
INSERT INTO azzNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Pero ne tatopaluijque moquetzac ne huejca san huan yejua hasta amo quinequía ajcotachías ne eluiyactzinco. Ta, yejua cachi oc moelmajmagaya porín yejua cajsicamatic que hueyi tajtacolejque iixpantzinco Dios. Ica ya nojón yejua motatatautiliaya ihuan Dios huan quiliaya ijcuín: “Notajtzin Dios, nechonyolicneli porín nejua semi nitajtacole”. ");
INSERT INTO azzNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Huan de ompa Jesús quilij ijcuín: ―Namechonyequilía que ne tatopaluijque Dios quipohuac yolchipahuac. Huan de ompa yajqui ichan yolpactiya. Pero ne tagat fariseo Dios amo quipohuac yolchipahuac. Ica ya nojón nochi neques ten mohueyimatisque, yejuan nojonques Dios quinpohuati que amo teyi chihuanime. Pero nochi neques ten mopohuasque amo teyi chihuanime, yejuan nojonques Dios quinueyicualnextijtiyás. ");
INSERT INTO azzNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Huan sequin tetatme quinualcuij coneme campa yetoya Jesús para ma Yejuatzin quincuamapacho huan quintiochihuas. Pero cuac imomachtijcahuan quitacque ya nochi ten mochiutoc, ijcuacón yejuan peuque quintacahualtiayaj ne tetatme ten quinualcuíaj ninconehuan. ");
INSERT INTO azzNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Pero Jesús quinnotzac imomachtijcahuan huan quinilij ijcuín: ―Xiquincahuacan ne coneme ma hualacan nohuan huan amo xiquintacahualtican. Porín ne coneme tacuautamatinemij notechcacopaca. Huan no namechilía nochi naquen motemacas nohuan ma niquinyolyecana ijcón queme ne coneme, yejuan nojonques Dios quinyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Huan Jesús ocsepa quinilij ijcuín: ―De yec melau ten namechilía que semi monequi ximochihuacan queme nijín coneme ten motemactijque nomaco. Huan tacán acsá amo motemactía imaco Yejuatzin queme se conetzin, ijcuacón Dios amo quiyolyecantiyás ne tagat ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Huan se tonal se tiopan tayecanque quitajtoltij Jesús ijcuín: ―Tamachtijque Tejuatzin, tionyolcuali. ¿Toni monequi nicchihuas para nicpías ne yecnemilis sen nachipa? ");
INSERT INTO azzNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Huan Jesús quinanquilij ijcuín: ―¿Queyé tinechnotza que niyolcuali? Porín xicmati que amo aca ocsé oc yolcuali. Ta, sayó se aquen yolcuali huan Yejuatzin ya in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Tejua cuali ticmati in tanahuatil de Dios ten quijtoa ijcuín: “amo xisihuapapatatinemi; amo no xictemicti; amo no xitachtequi; amo no xitajtolerojtijtinemi; xicmohuistiliti motajtzin huan monantzin”. ");
INSERT INTO azzNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ijcuacón ne tiopan tayecananque quilij Jesús ijcuín: ―Nochi nijín nictacamatihuitz ya desde cuac nipili oc nicatca. ");
INSERT INTO azzNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Huan cuac Jesús quicayic nijín nitananquililis de netequihua tiopan tayecanque, ijcuacón Yejuatzin quilij ijcuín: ―Xicaqui tejua, mitzpoloa se taman oc. Monequi xiyó xicnamacati nochi ten moaxca huan xiquinxejxelohuiliti in taca ten amo teyi quipíaj. Huan como ijcón ticchihuas, ijcuacón ticpías in hueyi paquilis huan yec yectolis queme se tetayocolil de ne eluiyactzinco. Huan no nimitzilía tejuatzin ijcuín: ―Xihuiqui nohuan huan xinechtoctiliqui huan xinechtacamatinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Pero cuac in tiopan tayecanque ten rico quicayic ya nochi nijín tajtolme de Jesús, ijcuacón yejua semi moyolcocojtiyá porín quipiaya míac ricojyot. ");
INSERT INTO azzNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Huan Jesús quitac ne tiopan tayecanque ten tequihua que semi quiyolcocoj ica por ne tajtolme ten Yejuatzin quilij. Ica ya nojón Jesús quinilij imomachtijcahuan ijcuín: ―Semi ohui para in ricojme que motemactisque inahuactzinco Dios para que Yejuatzin quinyolyecanas ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Huan ocsepa namechilía que amo huelis nalpanos se hueyi tapial ten monotza camello campa coyoctic in acoxa. Huan amo no huelis motemactijtiyás se rico inahuactzinco Dios para que Yejuatzin quiyolyecantiyás ica ihueyichicahualis, como yejua tacuautamatinemi itech niricojyo. ");
INSERT INTO azzNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Huan cuac in tacaquini quicacque ya nochi nijín, ijcuacón yejuan quimoucacque huan quitajtoltijque Jesús ijcuín: ―Como ijcón mochihuas, amo aquen huelis maquisas de nitajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Huan Jesús quinnanquilij ijcuín: ―In taca amo huelisque momaquixtisque yejuan san, como amo yec tacuautamatij inahuatzinco Dios. Pero Totajtzin Dios, quema, Yejuatzin cuali huelis quinmaquixtis in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ijcuacón in Pedro quilij Jesús ijcuín: ―Xiconita tejuatzin, tejuan ticauque ya nochi ten ticpíayaj huan nochi tejuan timitztoctilijtinemij para timitztacamatisque. ");
INSERT INTO azzNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ijcuacón Jesús quinanquilij nochi imomachtijcahuan ijcuín: ―De yec melau ten namechilía, cuali nanquichiutocque de nanquicahuaj namocaluan huan namoicnihuan huan namosihuahuan huan namoteiscaltijcahuan huan namoconehuan. Huan nochi nijín nanquincahuaj porín namejuan nanquiyolnejnequij que Dios namechyolyecantiyás ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Huan como namejuan nanquicauque ya nochi nijín taman, ijcuacón Dios namechmactilijtiyás tech nijín tonalme cachi míac oc huan que ne ten nanquicauque ya. Huan no Dios namechseliltis ne nemilis nachipa ne eluiyactzinco tech in tonalme ten huitze oc. ");
INSERT INTO azzNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Huan Jesús quinnotzac in majtactiomome imomachtijcahuan seco de se ojti huan quinilij ijcuín: ―Xiquitacan tejuan, titejcotiyohue para Jerusaléncopaca huan ompa motamichihuas nochi tajtolme ten quijcuilojca ne huejcau tanahuatiani de Dios cuac yejuan tajtoayaj de Nejuatzin ni Yectagatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Huan ompa Jerusaléncopaca nechtemactisque inmaco in tagayot ten amo judíos huan nechquejquelosque huan nechuijuicaltisque huan nechchichijchasque. ");
INSERT INTO azzNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Huan de ompa nechuitequisque huan nechmictisque. Pero ipan eyi tonalica nipanquisas niyoltoc intzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero ne imomachtijcahuan amo cajsicamatque toni quiniliaya. Huan Dios quintatilij oc nijín tamachilis; ica ya nojón yejuan amo cajsicamatque. ");
INSERT INTO azzNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Huan cuac Jesús ajsitiaya ya campa pueblo Jericó, ijcuacón Yejuatzin quitac se ixpojpoyot tocotzyetoya ojten nacastan huan yejua ompa motaehuiaya. ");
INSERT INTO azzNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Huan cuac ne ixpojpoyot quicayic que panotocque huel míac tagayot, ijcuacón yejua matajtanic de toni mochiutoc. ");
INSERT INTO azzNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Huan mochihuac que quiluijque que Yejuatzin in Jesús de Nazaret ten panotoc ompa. ");
INSERT INTO azzNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Huan ijcón ne ixpojpoyot pehuac quichicaucatzajtzilía Jesús ijcuín: ―Tejuatzin Jesús ten tion Teconetzin de rey David ten quipía de tihualas, xinechonyolicneli. ");
INSERT INTO azzNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Huan in taca ten quiyecanayaj Jesús, yejuan nojonques peuque quitacahualtiayaj ne ixpojpoyot que ma amo cachi oc quitzajtziliani. Pero ne ixpopoyot cachi oc quichicaucatzajtziliaya ijcuín: ―Tejuatzin tion Teconetzin de ne rey David, ten quipía de tihualas, xinechonyolicneli. ");
INSERT INTO azzNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ijcuacón Jesús moilochtij oc huan de ompa tatitanic que ma cualcuilican ne ixpojpoyot ompa iixpampa. Huan cuac cualicque ya, ijcuacón Jesús quitajtoltij ne ixpojpoyot ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","―¿Toni ticnequi ma Nejuatzin nimitzchihuili? Huan ne ixpojpoyot quinanquilij Jesús ijcuín: ―Notecotzin, nicnequi xinechontachialti. ");
INSERT INTO azzNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Huan de ompa Jesús quilij ijcuín: ―Axcan ya nimitztachialtiti huan tejua tipajtis porín titacuautamatic ya nohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Huan tech ne momento ne ixpojpoyot huelic ya tachíac. Huan de ompa yejua quitoctilijteu Jesús huan quimohuistilijtiyá Totajtzin Dios. Ica ya nojón cuac in pueblojuani quitacque toni quichihuac Jesús, ijcuacón yejuan no peuque quimohuistiliayaj Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Huan cuac Jesús quitamijpajtij ne ixpojpoyot, ijcuacón Yejuatzin calayic tech in pueblo Jerico huan panotiyá tatajco den pueblo. ");
INSERT INTO azzNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Huan mochihuac que ompa yetoya se tagat ten monotzaya Zaqueo huan yejua catca tayecanque den tatopaluiani. Huan Zaqueo catca hueyi rico. ");
INSERT INTO azzNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Huan ne Zaqueo semi quinejnequía quitas toni chiuque ne Jesús. Pero amo huelía quitas porín míac tagayot quiyehualojtiayaj Jesús huan in Zaqueo amo semi huejcapantic tagat. ");
INSERT INTO azzNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ica ya nojón cuac Zaqueo quimatic que nimampa hualajtoc Jesús, ijcuacón yejua niman quiachtohuij Jesús huan tejcotihuetzito tech se cuohuit ten quilía sicómoro para huelis quipanitas Jesús, porín ipa Jesús panosquía ompaca. ");
INSERT INTO azzNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Huan cuac Jesús ajsito ya ne cuoutampa, ijcuacón Yejuatzin cajcoitac Zaqueo huan quilij ijcuín: ―Tejua Zaqueo, niman xiijsiucatemo porín axcan semi monequi ma nimocautiquisa mochan. ");
INSERT INTO azzNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ijcuacón in Zaqueo temotihuetzic huan ijcón ica míac paquilis quisehuiyac Jesús ichan. ");
INSERT INTO azzNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Huan cuac in tagayot quitacque toni quichihuac Jesús, ijcuacón yejuan peuque quitejtenehuaj Jesús huan quijtoayaj que Jesús yajqui mocahuato ichan se tagat ten amo quitacamatinemi in tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Huan cuac ajsique ya ichan, ijcuacón Zaqueo moquetzac huan quilij Totecotzin ijcuín: ―Xiconita Notecotzin, axcan para taixpan tajco de noricojyo niquinmacajtiyás naquen amo teyi quipía. Huan tacán acsá niquichtequilis, ijcuacón nicuepilis nahui achichi oc ten nicuilij. ");
INSERT INTO azzNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Huan ijcón Jesús quilij Zaqueo ijcuín: ―Axcan tech nijín tonal Dios mitzmaquixtij ya ihuan mochancahuan. Huan axcan tejua timochihuaco ya tiiconetzin de Abraham porín titacuautamatic ihuan Dios ijcón queme Abraham tacuautamatic ihuan Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Huan nijín ijcón mochihuac porín Nejuatzin ni Yectagatzin de Dios huan nihuala nican talticpac para niquintemoco huan niquinmaquixtis neques ten ixpoliutocque tech in tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Huan cuac in tagayot quicactoyaj nijín tajtolme de Jesús, ijcuacón Yejuatzin pehuac quinmachtía ica se nexcuitil. Huan Jesús ihuan in tagayot ajsitiayaj Jerusalén. Huan in Jesús pehuac quinmachtía ica nexcuitil porín in tagayot quiyolnemiliayaj que xa niman ejcotihuitziquiu in tonal cuac Dios quinyolyecanas ipueblojcahuan ica ihueyichicahualis tech ne país de Judea. ");
INSERT INTO azzNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Huan Jesús quinmachtía ijcuín: ―Se tonal yetoya se tagat ten hueyi tequihua. Huan ne hueyi tequihua tagat yajqui huejca tech ocsé país para ompa quiselitiu in chicahualis huan tanahuatil para mocahuas rey. Huan de ompa mohualcuepac campa quistehuac para tayecanaquiu. ");
INSERT INTO azzNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Pero achtopa que yas tech ocsé país, ijcuacón ne hueyi tequihua quinnotzac májtacti itaquehualuan. Huan yejua quinmajmactilij sejsé moneda ten quijtosnequi se ciento tonal taxtahuil. Huan quinilijtehuac ijcuín: “Xictequitiltican nijín tomin cada senme de namejuan hasta in tonal cuac nimohualcuepas”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Pero in pueblojuani de ne país quihueyiyoltahuelitacque ne hueyi tequihua. Ica ya nojón yejuan quititanque sequin tanojnotzani para ma yejuan quilican ne tayecanani den ocsé país ijcuín: “Tejuan amo ticnequij que nijín tagat ma mochihuati totayecancau rey”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Pero mochihuac que ne hueyi tequihua tagat quiselij ne chicahualis huan tanahuatil para tayecantinemis queme rey. Huan de ompa mohualcuepa tech ipaís. Huan cuac ejcoc ya in hueyi tequihua ten mochihuac ya rey, ijcuacón yejua quintatitanic ma hualacan ne itaquehualuan ten quinmactilijteuca ya in tomin de sejsé tonal taxtahuil. Huan in rey ijcón quineyic quichihuac porín quinequía quimatis canachi tomin motanilijque ya cada se taquehual. ");
INSERT INTO azzNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Huan ne taquehual ten achto ejcoc, yejua ne quilij in rey ijcuín: “Notecotzin, ica nijín motomin nimotatanilij ocsé májtacti tomin”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ijcuacón in rey quilij ijcuín: “Cuali yetoc, tejua ticualitequitijque. Huan queme titacuautamatcatequitique ica sayó tepitzin tequit san, ica ya nojón axcan nimitztalis xiquinyecantinemi májtacti pueblojme”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Huan ica ome taquehual ejcoc huan quilij in rey ijcuín: “Totecotzin, ica nijín motomin nimotatanilij ocsé macuil tomin”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ijcuacón in rey quilij ijcuín: “Huan ica nijín mocualitequiu no nimitztaliti xiquinyecantinemi macuil pueblojme”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Huan ica eyi taquehual ejcoc huan quilij in rey ijcuín: “Notecotzin, nican yetoc motomin ten niquieutoya ya tech nomapayo. ");
INSERT INTO azzNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Pues nejua amo nictequitiltij motomin porín nimitzyolmohuiliaya porín tejua se titeco ten semi ticnequi ma se quiyecajsicachihuas. Huan no nicmatic que tejua ticololoa taquilot campa amo tictalpachoj motatoc; huan no ticajocui taquilot campa amo tictocac”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ijcuacón in rey quilij: “Tejua, semi amo cuali titaquehual. Nimitzixcomacati ica tejua motajtoluan ten tinechiluijtoc. Huan tejua ticmatoya ya que nejua niteco que semi nicnequi que ma se quiyecajsicachihuas. Huan no ticmatoya ya que nejua nicololoa taquilot campa amo nictalpachoj notatoc, huan no nicajocui tatoc campa amo nictocac. ");
INSERT INTO azzNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Huan como nochi nijín ticmatoya ya, ¿queyé nijín notomin amo ticalaquic tech se banco campa huelisquía quitequitiltisquía notomin ne taca ten tiquinmactilisquía? Huan ijcón cuac nimocuepasquía, ijcuacón nicselisquía notomin ihuan ten timotanilij ya”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ijcuacón in rey quinilij itaquehualuan ten ompa yetoyaj ijcuín: “Xicuilican notomin de nijín tatziu huan xicmactilican ne ten quipixtoc májtacti tomin”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ijcuacón ne ocsequin taquehualme quinanquilijque ijcuín: “Totecotzin, ¿queyé ticmacasque? Ta, yejua quipixtoc ya májtacti tomin”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Huan in rey quinanquilij ijcuín: “Huan nochi neques ten quipía tanahuatil de Dios huan quitequitiltíaj, yejuan nojonques cachi oc Dios quinmactilis. Pero in ocsequin taca ten quipía sayó tepitzin san tanahuatil de Dios huan amo quitequitiltisque in tepitzin san ten quipíaj, yejuan nojonques Dios quintamicuilis ne tepitzin san ten quipíaj”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Huan no in rey quinilij ijcuín: “Huan nochi neques ten nechtahuelitayaj huan amo quinequíaj que ma nimocahuani ninrey, yejuan nojonques xiquinualcuican nican huan xiquinmictican nican noixpan”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Huan de ompa cuac Jesús quintamiilij ya nijín nexcuitil, ijcuacón Yejuatzin quisentocac yajqui para Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Huan ajsitiaya ya Jesús campa pueblojme de Betfagé huan Betania campa amo huejca quitztoya se tal lomotzin ten monotzaya Olivos. Huan ijcón Yejuatzin quintitanic ome imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Huan Jesús quinilij neimomachtijcahuan ijcuín: ―Xiyacan tech ne pueblo ten yetoc cachi taixpampa. Huan niman cuac nancalaquitihue ya, ijcuacón ompa nancajsitihue se burritojtzin ten ilpitoc ten ayamo aquen ipan motalía. Huan nojón burritojtzin xictojtomacan huan xinechualcuilican. ");
INSERT INTO azzNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Huan tacán acsá namechtajtoltis de queyé nanquitojtomaj ne burritojtzin, ijcuacón namejuan xicnanquilican ijcuín: “In Totecotzin quimonequiltía quitatequiutis nijín tapialtzin”. ");
INSERT INTO azzNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ijcuacón ne ome imomachtijcahuan yajque huan cajsitoj in burritojtzin ijcón queme Jesús quilijca ya. ");
INSERT INTO azzNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Huan cuac yejuan quitojtontoyaj ya in burritojtzin, ijcuacón itecohuan quintajtoltijque ijcuín: ―¿Queyé nanquitojtontocque in toburritotzin? ");
INSERT INTO azzNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Huan imomachtijcahuan de Jesús quinnanquilijque ijcuín: ―Tictojtontocque porín Totecotzin quinequi quitatequiutis. ");
INSERT INTO azzNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Huan ijcón cualcuilijque Jesús ne burritojtzin huan quipanpejpechtijque ica nintaquehuan ne burritojtzin huan ijcón quipantalijque Jesús ipan ne burritojtzin. ");
INSERT INTO azzNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Huan ijcón queme nejnentiaya Jesús, no ijcón in tagayot quisoutiayaj nintaquen talixco tech in ojti. ");
INSERT INTO azzNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Huan cuac ajsitiayaj ya campa ne temolis den ne tal lomotzin de Olivos, ijcuacón nochi imomachtijcahuan ten quitoctiliayaj, yejuan nojonques peuque yolpaccatzajtzíaj huan quimohuistiliayaj Jesús ica por ne mohuiscatequime ten quitacque. ");
INSERT INTO azzNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Huan no quitzajtzilíayaj ijcuín: ―Tiontatiochihual de Dios ten Tejuatzin tiontayecanque ten tionualajtoc itencopaca Totajtzin Dios para techyolyecanas. Porín Yejuatzin den eluiyactzinco techmactilij ya ne yolsehuilis. Huan ticueyichihuaj Totajtzin Dios ten yetica ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ijcuacón senme de ne tamatinime fariseos ten yayaj intzalan in tagayot, yejuan nojonques quiliayaj Jesús ijcuín: ―Tamachtijque, xiquintacahualtij momomachtijcahuan ma amo ijcón quijtojcan. ");
INSERT INTO azzNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Pero Jesús quinnanquilij ijcuín: ―Namechyequilía que tacán nijín nomomachtijcahuan motentamatilisque, ijcuacón nochi nijín teme tzajtzisque para nechmohuistilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Huan Jesús amo huejca yetoya oc de ne pueblo Jerusalén. Huan cuac quitac Jerusalén, ijcuacón Yejuatzin mochojchoctij ica por nojón pueblojuani ten yetoyaj Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Huan Jesús quijtoaya ijcuín: ―Huan Nejuatzin nicnequisquía que namejuan xicajsicamatican nochi in tatiochihualis ten Totajtzin Dios quinequi namechmactilis para ica xiyolseucanentinemican. Pero nijín amo nancajsicamatisque porín Totajtzin Dios namechtatilij ya. ");
INSERT INTO azzNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Pero ejcos in tonalme ten cualcuis ne moutil. Huan neques ten namechtahuelitztinemij, yejuan nojonques namechyehualoquihue ica se hueyi tepan yehualol huan yejuan namechtatzacuiltisque nohuiyampa de namopueblo. ");
INSERT INTO azzNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Huan ijcón namechtaluitequisque huan namechmictisque nochi namejuan nanpueblojuani de Jerusalén. Huan tech nijín pueblo Jerusalén amo mocahuas ma nejnepaniuto oc se tet ipan ocsé tet. Huan nochi nijín mochihuas ijcón porín amo nanquiyecneltocasque que Totajtzin Dios nechualtitanic para namechmaquixtis. ");
INSERT INTO azzNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Huan de ompa Jesús calayic tech in calten den hueyi tiopan de judíos huan pehuac quincalanquixtía nochi ne tanamacani huan ne tacohuani ten tequititoyaj ne calten den tiopan. ");
INSERT INTO azzNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Huan Jesús quinilij in tagayot ijcuín: ―Tajcuiliutoc ya tech in Tajcuilolamatzin de Dios ijcuín: “Nochan quitocaytisque se cali de ne tatatautilis ihuan Dios”. Pero namejuan nanquichiutocque queme yesquía se tecal campa yetocque in tachtequini. ");
INSERT INTO azzNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Huan mosta mosta Jesús tamachtiaya ica in Tajtoltzin de Dios tech ne hueyi tiopan de judíos. Pero ne tayecanani tiopixcame huan ne tanextiliani ten tanahuatil de Moisés huan ne huehuentzitzin den pueblojuani, nochi nojón tayecanani mosenixejecoltiayaj de queniu huelis quimictisque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero nojón tayecanani amo cajsique de queniu quimictisque Jesús porín nochi in tagayot tamatcayetoyaj para quicaquilisque itanojnotzalis de Jesús ica paquilis. ");
INSERT INTO azzNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Huan se tonal Jesús yetoya tech ne hueyi tiopanijtic de judíos huan ompa quinmachtiaya in tagayot. Huan Jesús quinnojnotzaya ica ne yancuic Tajtoltzin de Dios ten cualcui ne nemaquixtilis. Huan mochihuac tech nijín momento que ejcotihuetzque in tayecanani tiopixcame huan ne tanextiliani den tanahuatil de Moisés huan no ne huehuetzitzin den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Huan nochi tayecanani ejcotihuetzque huan quitajtoltijque Jesús ijcuín: ―Xitechonili toni tanahuatil ticualcui tejua para ticchihuas nochi nijín tanextililisme huan para tiquinquixtij ne tanamacani. Huan no xitechonili aconi mitzonnahuatijtoc xitamachtijtinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ijcuacón Jesús quinanquilij ijcuín: ―Nejuatzin no namechtajtoltiti se matájtanti huan nicnequi no xinechilican. ");
INSERT INTO azzNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Aconi quinahuatij Juan ma taahuijtinemi? ¿Xe Dios quinanhuatij ma taahuijtinemi in Juan? Oso, ¿yejuan in tagayot quinahuatijque in Juan? ");
INSERT INTO azzNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ijcuacón yejuan moixejecoltiayaj se huan ocsé huan quijtoayaj ijcuín: ―Tacán tiquilíaj de que Dios quinahuatij Juan ma taahuijtinemi, ijcuacón yejua technanquilis ijcuín: “¿Queyé namejuan amo nanquineltoquilijque ten namechiliaya in Juan?” ");
INSERT INTO azzNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Huan tacán tiquilíaj de que tagayot san quinahuatijque in Juan de que ma taahuijtinemi, ijcuacón yejuan techtepoxonisque. Porín nochi in tagayot quiyecneltocaj que in Juan Taahuijque yejua se hueyi tanahuatijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ica ya nojón ne tayecanani quinanquilijque Jesús que yejuan amo quimatíaj aconi quinahuatij Juan ma taahuijtinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ijcuacón Jesús no quinilij ijcuín: ―No ijcón nejua amo no namechilis aconi nechmacac tanahuatil para nicchiutinemi nochi nijín tanextililisme. ");
INSERT INTO azzNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Huan cachi satepan Jesús pehuac quinnojnotzac in tagayot huan quinmachtij ica nijín nexcuitil ijcuín: ―Oncaya se tagat patrón ten quitocac sequi uvas tactzon tech ne imila. Huan cachi satepan in patrón quitetaneutijteu ca renta ne imila ihuan senme de nijín tequitini. Huan satepan ne patrón quistehuac huan yajqui ocseco hasta ocsé país huan ompa yetoya míac tonalme campa ipueblo. ");
INSERT INTO azzNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Huan ajsic ya in tonal cuac yocsic ya in uvas taquilot, ijcuacón in patrón quititanic se itaquehual para ma yejua quintajtaniti ne tequitini que yejuan ma quimactilican ne taquilot ten pohui ihuan in patrón. Pero ne tequitini quiquitzquijque ne taquehual huan cuitecque. Huan de ompa ijcón yojqui quitogacque. ");
INSERT INTO azzNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ijcuacón ne patrón ocsepa quititanic ocsé itaquehual. Pero ne tequitini ocsepa quihuijuicaltijque huan cuitecque. Huan de ompa no ijcón yojqui quitogacque ne ica ome taquehual. ");
INSERT INTO azzNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Huan in patrón quititanic ocsepa ica eyi itaquehual. Pero ne tequitini quicojcocojque huan quicalantamotque de ne uvastal ne ica eyi itaquehual. ");
INSERT INTO azzNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ijcuacón in patrón de ne uvasta, yejua ne moyolilij ijcuín: “¿Axcan toni oc nicchihuas? Pero axcan nicmactic ya toni monequi nicchihuas. Cachi cuali nictitaniti notasojconetzin campa ne tequitini. Xa santajma cuac yejuan quitasque notasojconetzin, ijcuacón quimohuiscaselisque”. ");
INSERT INTO azzNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Pero cuac ne tequitini quitacque ya que ejcotihuitz ne itasojconetzin de patrón, ijcuacón yejuan moliliayaj se huan ocsé huan motajtolmacayaj ijcuín: “Yejua ya ne quiselis nochi ten pohui itatcopaca ya. Cachi cuali ma timoyejyectalican para ticmictisque para ijcón toaxcatis nijín uvastal ten quiselisquía queme herencia ne teconeu”. ");
INSERT INTO azzNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Huan de ompa ne tequitini quicalantamotque ne tasojconetzin de ne uvastal huan quimictijque. Ijcuacón in Jesús quintajtoltij in tagayot ijcuín: ―Huan cuac hualas ne patrón ten niaxca ne uvastal, ijcuacón ¿toni quinchihuilis ne tequitini ten amo yolcualime? ");
INSERT INTO azzNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nejua namechyequilía que ne patrón cuac hualas ya, ijcuacón yejua quintamimictis ne tequitini ten amo yolcualime huan quincahuilis ne uvastal ica renta ocsequin tequitini. Huan in tagayot cuac quicacque nochi nijín tajtolme, ijcuacón yejuan quilijque Jesús ijcuín: ―Ma amo ijcón quimonequiltij Dios ma mochihua. ");
INSERT INTO azzNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero Jesús sayó quinsenixitac huan pehuac quinmachtía ica se nexcuitil huan Yejuatzin monejnehuililtij queme se tet, huan quinilij in tagayot ijcuín: ―¿Toni quijtosnequi nijín ten ijcuiliutoc tech in Tajtoltzin de Dios? ten quijtoa ijcuín: “In tet ten quimajpeuque in tepanchihuani, yejua ne mochihuaco tepanchicahualoni de tepamit”. ");
INSERT INTO azzNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Huan nochi neques ten amo nohuan tacuautamatij, yejuan nojónques queme yesquía se tagat ten motepotamía huan huetzi ipan se tet huan ne tagat quipojpostequi ninacayo. Huan nochi neques ten amo taneltocani de Nejuatzin, yejuan nojonques mocahuasque tacuecholme ijcón queme se tet huetziqui ipan se tagat. ");
INSERT INTO azzNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ijcuacón in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés, nochi nijín tayecanani quinequíaj quiquitzquisque Jesús tech nojón momento. Huan ijcón quinequíaj quichihuasque porín yejuan cajsicamatque ya que Jesús tajtoaya de yejuan nintechcacopaca ica ne nexcuitil den amo yolcualime tequitini. Pero amo quiquitzquijque Jesús porín yejuan quinyolmohuiliayaj in pueblojuani que ninpan yasque. ");
INSERT INTO azzNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Huan ijcón yejuan quipijpixtinemíaj Jesús que tensá tajtacol quijtosquía para ica huelis quiteluilisque huan quitemactisque imaco in hueyi tequihua. Ica ya nojón ne tayecanani quintitanque sequin intequiticaicnihuan huan yejuan mochiutinemij que yejuan yolcuali taca. ");
INSERT INTO azzNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ica ya nojón ne taixcajcayahuani quitajtoltijque Jesús ijcuín: ―Ticmatíaj ya que Tejuatzin titajtoa huan titamachtía sayó ica ten melau. Huan no ticmatij que tejua amo tiquinyolmohuilía in tagayot ten yejuan quijtoaj. Huan amo no tiquinchichicotasojta in tagayot. Ta, Tejuatzin yec melau titeyecnextilía in ojtzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Huan axcan xitechonilij toni tiquixejecoa. ¿Xe Dios quimonequiltía ma titaxtahuacan impuestos den ne rey César oso amo? ");
INSERT INTO azzNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ijcuacón in Jesús quinyolojixmatic que ica tacajcayahualis quitajtoltiayaj. Ica ya nojón Jesús quinilij ijcuín: ―¿Queyé namejuan nanquinequij nannechichtacahuisque san ica nijín tacajcayahualis? ");
INSERT INTO azzNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Xinechnextilican in tomin tenica nantaxtahuaj impuestos. ¿Aconi nijín ixayac ten ixnesi nican? Huan, ¿aconi nijín itocay ten ijcuiliutoc nican? Huan yejuan quinanquilijque ijcuín: ―Yejua nijín in rey César. ");
INSERT INTO azzNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ijcuacón Jesús quinilij ijcuín: ―Xicmactilican in rey César ten quinamiqui xictemactican César. Huan cachi oc xicmactilican Dios nochi ten Yejuatzin quimonequiltía xictemactican huan xicyecajsicamactican. ");
INSERT INTO azzNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Huan ica nochi in tajtolme tenica Jesús quinojnotztoya in tagayot, ne taixcajcayahuani amo huelque quichtacahuisque Jesús ica nintacajcayahualis. Ta, yejuan cachi oc quimoucacacque de queniu Jesús tananquilij. Ica ya nojón yejuan sayó motentamatilijque san. ");
INSERT INTO azzNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Huan cachi satepan sequin taca tamachilejque saduceos motoquijque campa Jesús yetoya. Huan yejuan amo quineltocayaj de que huelis se panquisas yoltoc intzalan in ánimajme. Ica ya nojón yejuan quitajtoltijque Jesús ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","―Tamachtijque, in tanahuatijque Moisés techijcuilohuilijtehuac ijcuín: “Tacán se tagat yesqui namique huan miquisquía huan quicahuasquía nisihuau huan amo quinpiasquía coneme, ijcuacón ma monamicti icniutagat de ne miquet ihuan ne cahual sihuat ten icuñada catca. Huan ma quiniscaltican coneme ihuan in cahual sihuat ten icuñada catca. Huan ijcón ma quinpiacan coneme ten icniutagat ten miyic ya para ma ne teconehuan ma quiselican itocay huan iherencia de nintat ten ipa miyic ya”. ");
INSERT INTO azzNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Pues ma tiquijtocan que oncaya chicome icnime. Huan ne ten tayecana, yejua ne monamictij ihuan se sihuat. Pero niman miyic in tagat huan amo quinpiacque coneme. ");
INSERT INTO azzNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Huan de ompa ne ica ome teicniu monamictij ihuan icuñada ten miyic iyoquich. Huan ijcón mochihuac queme ne achto. Huan ne tenica ome teicniu miyic huan amo quinpiacque coneme. ");
INSERT INTO azzNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Huan satepan ne ica eyi teicniu monamictij ihuan icuñada. Huan ijcón mochiutiyá hasta ajsic de chicome icnime. Nochi sejsé monamictiyajque ihuan incuñada huan nochi yejuan sejsé mictiyajque. Huan nochi yejuan amo senme quinpiacque inpiluan. ");
INSERT INTO azzNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Huan queme nochi tami micque ya in chicome icnime, ijcuacón in sihuat no momiquilij ya. ");
INSERT INTO azzNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Huan de ompa in saduceos quitajtoltijque Jesús ijcuín: ―Axcan xitechonili que tech ne tonalme cuac panquisasque yoltocque intzalan in ánimajme ne taca ten chicome icnime huan in sihuacahual, ijcuacón, ¿aconi isihuau yesqui senme de ne chicome icnime? Porín nochi in icnime quipouque queme nisihuau. ");
INSERT INTO azzNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ijcuacón Jesús quinnanquilij ijcuín: ―In tagayot ten axcan nentinemij, yejuan nojonques monamictíaj huan mosihuamonijtantinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Pero Totajtzin Dios quinpohua yolcualime sayó sequin tagayot. Huan sayó yejuan quinamiqui ajsisque ne eluiyactzinco. Huan sayó yejuan Dios quinpanquixtis yoltocque intzalan in ánimajme. Huan nepa eluiyactzinco neques ten yolcualime amo monamictijtinemisque huan amo no mosihuamonijtantinemisque oc. ");
INSERT INTO azzNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Huan ijcón mochihuas porín yejuan amo huelis momiquilisque oc. Ta, yejuan no nentinemisque ya queme in ángeles. Huan yejuan nojón Dios quinpoutos que niconehuan porín Yejuatzin quinpanquixtis ya yoltocque intzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Huan ne Moisés ipa namechmachtijca ya de que Dios quinpanquixtis yoltocque itaneltocacahuan intzalan in ánimajme. Huan nochi nijín tamachilis Moisés ipa namechnextilijca ya tech in Tajtoltzin de Dios campa tajtoa de ne huitzcuoutactzon ten momejmelahuaya ica tit. Huan ompa quijtoa que Totecotzin Yejuatzin in Dios de Abraham huan Yejuatzin in Dios de Isaac huan Yejuatzin in Dios de Jacob. Porín Yejuatzin quinnojnotztoc de neques ten yoltinemisque sen nachipa. ");
INSERT INTO azzNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ica ya nojón xicmatican que Totajtzin Dios Yejuatzin amo in Dios de neques ten yetoc tech in ixpolihuilis. Ta, Yejuatzin in Dios ten neques ten yoltinemij sen nachipa. Porín nochi neques ten tacuautamatinemij ihuan Dios, yejuan nojonques yoltinemij sayó para quimohuistilijtinemisque Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ijcuacón sequin tanextiliani de tanahuatil de Moisés quinanquilijque Jesús ijcuín: ―Tamachtijque, cuali queme tiquijtoa. ");
INSERT INTO azzNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Huan ijcón amo aquen moixehuijque oc ma quitajtoltican oc Jesús tensá matájtanti. ");
INSERT INTO azzNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ijcuacón Jesús quintajtoltij in tagayot ijcuín: ―¿Toni nanquiyolnemilíaj de ne ten monotza Cristo Temaquixtijque? ¿Queyé quijtoa que ne Cristo, Yejuatzin iconeu de ne huejcau rey David? ");
INSERT INTO azzNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Porín tech in Tajcuilolamatzin de Dios ten quilíaj Salmos, ne rey David quijtoa ijcuín: Huan in Totajtzin Dios quinojnotztoya Notayecancatzin in Notecotzin huan quiliayaj ijcuín: “Ximosehuitzino nican noyecmacopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Huan xitayecantinemi hasta ne tonal cuac niquintanilis nochi neques ten mitzixnamictinemi”. ");
INSERT INTO azzNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Huan como David quitenehuac Cristo queme i Tecotzin, ¿queniu huelis que Cristo no mochihuac teconeu de David? Ica ya nojón David quipohuac Cristo Temaquixtijque, que Yejuatzin i Tecotzin de David huan no iteconeu de David. ");
INSERT INTO azzNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Huan nochi in pueblojuani judíos quicaquiliayaj itanojnotzalis de Jesús cuac Yejuatzin quinnojnotzaya imomachtijcahuan ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","―Ximotachialican ca cuali de ne tanextiliani den tanahuatil de Moisés porín yejuan semi cuelitaj nentinemisque huan mocualnextijtinemij ica ne itilma ten sen taniquistoc. Huan yejuan no cuelitaj que ma quinmohuiscatajpalocan tech in plazajteno. Huan yejuan no cuelitaj motalitihue ne taixpampa den tiopan de judíos campa yetocque ne mohuiscasillajme. Huan no semi quinequij motalitihue tech ne sillajme campa cachi cuali tatacuasque. ");
INSERT INTO azzNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Pero hasta yejuan no quincalcuilíaj ne sihuacahualme. Huan para amo monextis ten quichihuaj, yejuan semi huejcahuaj cuac motatatautilíaj ihuan Dios. Huan nochi nijinques quiselisque imaco Dios cachi hueyi tatzacuiltilis. ");
INSERT INTO azzNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Huan tech ne hueyi tiopan de judíos Jesús quinsenitztoya ne ricojme cuac quipantalijtoyaj ne nintomin campa quinechicoa ninofrenda. ");
INSERT INTO azzNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Huan no Jesús quitac se sihuacahual ten semi pobre. Huan yejua quipantalij sayó ome tomintzin queme yesquía ome centavos. ");
INSERT INTO azzNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Huan Jesús quijtoaj ijcuín: ―Yec melau ten namechilía que ne sihuacahual, yejua ne quipantalij cachi míac tomin huan que neques ricojme. ");
INSERT INTO azzNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Porín nochi ne tagayot quipantalijque nintomin ten quinsobraroayaj para ninofrenda. Pero ne sihuacahual yejua semi pobre. Huan yejua quipantalij nochi nitomin tenica monequía moixpanoltisquía. ");
INSERT INTO azzNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Huan sequin imomachtijcahuan de Jesús monojnotzayaj de ne hueyi tiopan de judíos. Huan yejuan quinextiliayaj Jesús de queniu cualtzin tachijchiutoc ica ne cualtzitzin teme. Huan no quinextiliayaj nochi ne tetayocolilme tenica quicualnextiayaj in tiopan. Huan no Jesús quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","―Huan hualajtoc in tonal cuac nochi nijín ten nanquitztocque, nochi yejua quihuejuelosque hasta amo teyi mocahuas se tet ten nejnepaniutos. ");
INSERT INTO azzNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ijcuacón imomachtijcahuan quitajtoltijque Jesús ijcuín: ―Tamachtijque, xitechonili queman huejuelihuis nijín tiopan calicxime. Huan, ¿toni nescayome tiquitasque cuac motamichihuaqui ya nochi nijín ten titechonilijtoc? ");
INSERT INTO azzNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ijcuacón Jesús quinnanquilij ijcuín: ―Ximoyecpiacan ma amo aquen namechyolcajcayahua tech namotaneltocalis. Porín hualasque miacque tacajcayahuani ten no nechtenchiutinemisque ica notocay huan quijtojtinemisque ijcuín: “Nejua ya ni Cristo Temaquixtijque”. Huan no yejuan quijtosque ijcuín: “Axcan ejcoc ya in tonal cuac mohualuicas Cristo”. Masqui ijcón namechilisque in tacajcayahuani pero amo xiyacan xiquintoctilican. ");
INSERT INTO azzNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Huan cuac nanquicaquisque que mochiutoc ne hueyi netehuilis, ijcuacón amo ximoyolcuejmolocan. Huan cuac motetapohuis ya que mocualancatehuisque in tagayot, ijcuacón amo ximoyolmoutican. Porín ipa ijcón monequi mochihuas achtopa que nimohualuicas Nejuatzin. Pero xicmatican que amo yejua in tamilis den talticpac cuac nochi nijín mochiutos. ");
INSERT INTO azzNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ijcuacón Jesús quisentocac quinnojnotzaya imomachtijcahuan ijcuín: ―Huan tech nojón tonalme de tajyohuilis pehuas moajocuisque pueblojuani huan motehuisque se huan ocsé pueblojuani. Huan in tagayot de se país moajocuisque huan motehuisque se huan ocsé tagayot. ");
INSERT INTO azzNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Huan mochihuas que miaccan talolinis. Huan tech miaccan pueblojme mochihuati máyanti huan tetzaucacocolisti. Huan no ejecaixco nanquitasque tetzaucanescayome huan no huejueyi nemoutil mochihuaquiu. ");
INSERT INTO azzNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Pero achtopa que nanquitasque nochi nijín nescayot, ijcuacón namejuan namechquitzquisque huan namechtajyohuiltisque. Huan namechtemactisque inmaco in tiopan tayecanani huan ompa namechixcomacasque. Huan namechcalaquitihue cárcelijtic. Huan de ompa namechuicasque inixpan in tequihuani queme reyes huan ocsequin tayecanani. Huan nochi nijín namopan mochihuas porín namejuan nantacuautamatij tech in chicahualis de notocaytzin. ");
INSERT INTO azzNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Huan cuac namechuicasque ya inixpan in tayecanani, ijcuacón namejuan huelis nanmotajtohuisque notechcacopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Huan no namechilía que amo semi monequi xiyoltanemilijtinemican de queniu nantananquilisque cuac nanmotajtohuisque notechcacopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Porín tech ne tonal namechinmactiliti tajtolme huan tamachilis. Huan ijcón neques ten namechtahuelitztinemij, yejuan nojonques amo huelis namechtajtolxijxicosque huan amo nohuelis namechtajtolixnamiquisque. ");
INSERT INTO azzNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Huan mochihuas que namechtemactisque inmaco in tayecanani hasta namoteiscaltijcahuan huan namocnihuan huan namoparientes huan namotasojicnihuan. Huan ijcón yejuan namechmictisque senme de namejuan. ");
INSERT INTO azzNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Huan nochi in talticpacuani namechsenpetztahuelitztinemisque porín namejuan nantacuautamatinemij nohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Pero no xicmatican que Dios namechyecpixtinemis huan Yejuatzin amo quicahuas nión se namotzontzin ma polihui. ");
INSERT INTO azzNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Huan como namejuan nanquixicojtiyohue nochi nijín tajyohuilis, ijcuacón Dios namechmactilis ne tamajsicayot de ne nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Huan cuac nanquitasque que in pueblo Jerusalén quiyehualojtocque ya míac soldados, ijcuacón cuali xicmatican ya que quitamihuejuelotij ya in pueblo de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ijcuacón namechilía que neques ten calyetocque Judeajcopaca, ma niman cholocan huan ma yacan ne tepepan. Huan neques ten calyetocque Jerusaléncopaca, yejuan nojonques monequi ma quisacan de ompa. Huan neques ten tequititocque milajpa, ma amo mohualcuepacan oc tech in pueblo de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Porín tech nojón tonalme huetziquiu ya in hueyi tatzacuiltilis de Dios huan motamichihuaquiu ya nochi ten ijcuiliutoc tech in Tajcuilolamatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Huan tech nojón tonalme semi teicneltiliani neques sihuame ten cocoxcayetocque ica pili. Huan no semi teicneltiani neques sihuame ten tachichitijtinemisque ica coneme. Porín tech nojón tonalme mochihuaquiu se tetzaucatajyohuilis nican talticpac. Huan Totajtzin Dios quinueyitatzacuiltis in pueblojuani de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Huan sequin pueblojuani miquisque tech in netehuilis den soldados huan ocsequin pueblojuani quinuicasque queme presos huan quinajxitisque tech ocsequin país. Huan ijcón in analtecocayome quitamipojpolosque in pueblo de Jerusalén huan no quintajyohuiltijtihue in pueblojuani de Jerusalén. Huan ijcón mochiutiyás hasta cuac tamis in tonalme que Dios quintecahuilij ne analtecocayome ma nentinemican ne Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Huan no Jesús quinnextiliaya imomachtijcahuan ijcuín: ―Huan tech nojón tonalme nimampa den hueyi tajyohuilis, ijcuacón namejuan nanquimoucaitasque ne huejueyi tetzaucatequime ten mochihuaquiu ipan in tonaltzin huan ipan in metzti huan inpan in sitalime. Huan nanquitasque que in talticpacuani moyolpolojtinemisque ya huan mohueyiyolmoutisque. Porín in hueyíat den mar tetzaucaijcoyocas cuac mocuecuentecas. ");
INSERT INTO azzNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ijcuacón in talticpacuani talcautiyasque ya ica ne moutil cuac quinemilijtosque de toni tatzacuiltilis ninpan ejcotoc nican talticpac. Huan hasta Dios no quintzetzelos ne tayecanani ten nentinemij ejecaixco. ");
INSERT INTO azzNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Huan cuac motamichihuas nijín, ijcuacón namejuan nannechitasque Nejuatzin ni Yectagatzin de Dios nihualajtos ya ne mixtzalan ejecaixco huan ica hueyi chicaucacualtziyo no nimohualuicas. ");
INSERT INTO azzNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Huan cuac nanquitasque mochiutoc ya nochi nijín, ijcuacón namejuan cachi oc ximoyolchicahuacan huan xiajcotachiacan porín ejcotos ya ne tonal cuac Dios namechtamajxitilis den namonemaquixtilis. ");
INSERT INTO azzNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Huan Jesús quinmachtij imomachtijcahuan ocsepa ica se nexcuitil ten higoscuohuit ijcuín: ―Xiquitacan ne higoscuohuit oso ten yesqui cuoume. ");
INSERT INTO azzNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Huan cuac nanquitasque que cualtzin maxoxohuixtoc ya in cuoume, ijcuacón nanquimatij ya que ejcotoc ya in tonalme de tatotoncayot. ");
INSERT INTO azzNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Huan no ijcón cuac nanquitasque que mochiutoc nochi nijín tajyohuilis ten namechiluijca ya, ijcuacón xicmatican ya que ejcotoc ya in tonal cuac Dios namechyolyecanaquiu ica ichicahualis nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","De yec melau ten namechilía que nochi nijín ten namechilijtoc, nochi nijín motamichihuaquiu achtopa que momiquilisque in tagayot ten axcan nentinemij. ");
INSERT INTO azzNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Huan ejcos in tonal cuac in ejecaixco huan in talticpac tatajtamis ya. Pero xicmatican que notajtoltzitzin amo queman polihuis. ");
INSERT INTO azzNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Huan no namechilía que ximoyecpiacan namejuan san para ma amo quejquepto namotacuautamatilis. Huan amo xicneltatacuajtinemican huan amo xitahuantinemican. Huan amo xiyoltanemilijtinemican den namonemilis de nican talticpac. Porín como ijcón nanquichiutocque, ijcuacón namechmoucaichtacahuiquiu ne tonal cuac Nejuatzin nimohualuicas. ");
INSERT INTO azzNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Porín ne tonal cuac nimohualuicas, ijcuacón Nejuatzin niquinmoucaichtacahuiquiu in talticpacuani de nochi senmanahuac, ijcón queme se trampa quimoucaichtacahuía se ocuilin cuac huetziti tech in trampa. ");
INSERT INTO azzNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ica ya nojón namechyequilía xiyeccuatamatinemican tech namotacuautamatilis. Huan nachipa ximotatatautilican ihuan Dios para que Dios namechpalehuis xiccholohuilican nochi nijín tajyohuilis ten mochihuaquiu. Huan no ximotatatautilican ihuan Dios para que Yejuatzin ma namechpalehuis nanmotenextilisque noixpan de Nejuatzin ni Yectagatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Huan Jesús tamachtiaya tonayan tech in hueyi tiopan de judíos, huan tech yohual mooncahuaya campa ne tal lomotzin ten monotza Olivos. ");
INSERT INTO azzNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Huan nochi in pueblojuani de Jerusalén yayaj cada cualcan huan calaquiayaj tech in hueyi tiopan para quicaquilisque itanojnotzalis de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Huan amo huejcahuaya oc para mochihuas ne tajyohuilis iluit ten quilía pascua cuac in pueblojuani quicuaj pan ten amo tamanelol ica levadura. ");
INSERT INTO azzNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Huan in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés, nochi yejuan nijín tayecanani quitemoliayaj de queniu quimictisque Jesús. Pero quichiutoya nijín ica ichtacayot porín quinyolmohuiliayaj in pueblojuani que ninpan yasque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Huan ijcón in amocuali Satanás calayic iyolijtic in Judas ten cojpatocaytía Iscariote ten yejua no poutinemía ihuan ne majtactiomomen imomachtijcahuan de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Huan ne Judas yajqui quinitato ne tayecanani tiopixcame huan ne tiopan tayecanque den policia. Huan ompa Judas quinixpantilito de queniu yejua huelis quitemactis Jesús inmaco ne tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ijcuacón ne tayecanani mohueyiyolpactijque huan yejuan moyectencauque ihuan Judas de quitaxtahuisque ca tomin. ");
INSERT INTO azzNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ijcón in Judas motemactij ihuan in tayecanani. Huan de ompa yejua pehuac quitemoa de queniu quitemactisquía Jesús inmaco in tayecanani, pero ichtaca para ma amo quimatican in pueblojuani de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Huan cuac ajsic in iluitonal cuac in pueblojuani quicuaj pan ten amo tamenelol ica levadura, ijcuacón monequía quimictisque se ichcatzin para ijcón quielnamiquisque de ne tonal cuac Dios quinualquixtij ipueblojcahuan ne Egipto. ");
INSERT INTO azzNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ijcuacón Jesús quintitanic Pedro huan Juan huan quinilij ijcuín: ―Xiyacan xichijchihuati in ichcatzin para ticsenpancuasque ne mohuiscatacualis ten monotza pascua. ");
INSERT INTO azzNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Huan quitajtoltijque Jesús ne ome imomachtijcahuan ijcuín: ―¿Can ticnequi ma ticchihuatij ne mohuiscatacualis? ");
INSERT INTO azzNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ijcuacón Jesús ocsepa quinanquilij ne ome imomachtijcahuan ijcuín: ―Cuac nancalaquitihue ya tech ne pueblo de Jerusalén, ijcuacón hual quisas se tagat ten cuica se atzotzocol. Namejuan xictoctilican ne tagat hasta campa ne cali campa yejua calaquitiu. ");
INSERT INTO azzNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Huan namejuan xiquilican in teco de ne cali ijcuín: “In tamachtijque mitzilía ijcuín: Xiquinnextili ne nomomachtijcahuan can yetoc ne nepancal campa huelis tisentacuasque ica ne mohuiscatacualis Nejuatzin ihuan nomomachtijcahuan”. ");
INSERT INTO azzNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ijcuacón in teco de ne cali namechnextilitiu ya se hueyi cuarto tech ne nepancal campa tachpanala ya huan ijcatoc ya mesa. Huan ompa namejuan xicchijchihuacan in mohuiscatacualis. ");
INSERT INTO azzNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Huan ijcón ne ome imomachtijcahuan yajque huan ajsito campa ne nepancal tayejyectalij ya, ijcón queme Jesús quinilijca ya. Huan ijcón ne imomachtijcahuan peuque quichijchihuaj in mohuiscatacualis ten quilíaj pascua. ");
INSERT INTO azzNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Huan cuac ejcoc ya in hora cuac monequi quicuasque ne mohuiscatacualis, ijcuacón Jesús ihuan itanojnotzcahuan motalitoj para tacuasque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ijcuacón Jesús quinilij ijcuín: ―Desde ne tonal ya semi nicyolnejnectihuitz niiluichihuas namohuan ica nijín mohuiscatacualis de pascua achtopa que nechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Porín namechilía que amo nicchihuas oc namohuan nijín mohuiscatacualis den tajyohuilisiluit como amo achtopa Dios quitamichihuas que ma namechyolyecanas ica ichicaucahuelilis. ");
INSERT INTO azzNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Huan de ompa Jesús momaaquía se vaso de vino huan quitasojcamachilij Dios. Huan de ompa quinilij imomachtijcahuan ijcuín: ―Xitayican nijín vino huan ximopanoltilijtiyacan huan ximotayiltican cada senme de namejuan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Porín namechilía que amo ocsepa nitayis nijín uvasat como amo achto Dios quitamichihuas de namechyolyecanas ica ihueyichicahualis huan tisenyetinemisque sen nachipa nepa eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Huan cuac tami tayicque ya, ijcuacón Jesús momaaquij se pantzin. Huan de ompa quitasojcamachilij Dios huan quicojcotonac in pan huan quinxejxelohuilij imomachtijcahuan. Huan Jesús quiniliayaj ijcuín: ―Nijín pan yejua ne nonacayo tenica ixnesis que nictemactiti nonacayo inmaco in tayecanani para nechmictisque huan ijcón niquixtahuati namotajtacoluan. Huan namejuan cuac nijín pan nanquicuasque, ijcuacón namejuan nannechelnamictiyasque de nejua nomiquilis. ");
INSERT INTO azzNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Huan no ijcón quichihuac Jesús ica in vino. Huan cuac quitamicuajque ya ne mohuiscatacualis, ijcuacón Jesús momaaquij ne vaso de vino huan quinilij imomachtijcahuan ijcuín: ―Ica nijín vaso de vino quitenextijtoc ya que nimoyectencauca ya ihuan Notajtzin Dios de que mimilahuis no esyotzin huan nimiquis para ijcón Dios namechtapojpoluis de namotajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Huan yetoc nican noixpan se tagat naquen nechtemactis inmaco in tayecanani para nechmictisque. Huan ne tagat tohuan tacuajtoc huan tayitoc campa nijín mesa. ");
INSERT INTO azzNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Huan namechyequilía que Nejuatzin ni Yectagatzin de Dios huan niyajtoc tech ne ojtzin ten Notajtzin Dios nechnahuatilij ya. Huan no namechilía que semi teicnelti ne tagat naquen nechtemactis inmaco in tayecanani para nechmictisque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ijcuacón ne imomachtijcahuan peuque motajtajtoltiayaj se huan ocsé ijcuín: ―¿Aconi senme ne tiimomachtijcahuan tictemactisque Jesús Temaquixtijque inmaco in tayecanani? ");
INSERT INTO azzNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Huan imomachtijcahuan de Jesús peuque motajtoltehuiayaj de aconi de yejuan mochihuaquiu cachi hueyi chiuque inpan yejuan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Pero Jesús quinilij ijcuín: ―In chihuanime reyes den tataman paísme, yejuan nojonques quinyecantinemij ninpueblojcahuan, porín yetocque queme tayecanani. Huan ne tayecanani quinequij quinmachililtijtinemisque ninpueblojcahuan den ninchicahualis. Huan no netayecanani quinequij que ninpueblojcahuan ma quijtocan ne nintayecancahuan que yejuan cuali tequihuani. ");
INSERT INTO azzNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Pero namejuan amo ijcón xicchihuacan. Ta, ne tagat ten cachi hueyi chiuque namotzalan, yejua nojón ma mopohua huan ma motequitilti queme se telpocat san. Huan ne tagat ten tayecantinemi namohuan, yejua nojón ma mochihuaqui que se tetequitilijque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Huan namechtajtoltía ijcuín: ¿Aconi in cachi hueyi chiuque ne ten motaliti tacuati campa mesa? ¿Xe cachi hueyi chiuque ne ten motalía para tacuati? ¿Oso cachi hueyi chiuque neques de tetamaca? Namechilía que ne ten motaliti tacuati campa mesa, yejua ne in cachi hueyi chiuque. Pero xiquitacan que Nejuatzin nimochihuaco ya se tetequitilijque san namotzalan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Huan namejuan nanquisentocatihualayaj nannechtoctilitihualajque Nejuatzin tech nochi notajyohuilisuan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Huan ijcón queme Notajtzin Dios nechtennahuatilij ya ma nitayecantinemi, no ijcón Nejuatzin namechnahuatilía que xitayecantinemican namejuan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Huan ijcón huelis namejuan nantacuasque huan nantayisque huan nohuan nantequitisque cuac Nejuatzin nitayecantinemiquiu ica nochicaucahuelilis. Huan no namejuan nantocotzyetocque campa nochicaucahuelilispan huan nohuan nantayecantinemisque para ijcón nanquinixcomacasque ne majtactiomome tetatme de Israel ihuan nochi in pueblojuani de Israel. ");
INSERT INTO azzNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Huan ijcón Totecotzin quilij Simón ijcuín: ―Tejua Simón, xicaqui que in amocuali Satanás tajtantoc permiso imaco Dios para huelis quiejecos motacuautamatilis para ixnesis cox melau titacuautamati nohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Pero xicmatican que nimotatatautilij ya ihuan Dios de que ma amo xicpoloti motacuautamatilis. Huan tejua, cuac timoyolnemilij ya de motajtacoluan, ijcuacón xiquinyolmajxiti motequiticaicnihuan. ");
INSERT INTO azzNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Huan Simón quilij Jesús ijcuín: ―Notecotzin, niyecyetoc ya para niyás mohuan, masqui techtzacuasque tech in cárcelijtic oso masqui techmictisque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ijcuacón Jesús quinanquilij Simón ijcuín: ―Tejua Pedro, nimitzilía que axcan tayohuac achtopa que tzajtzis in piotzin, tejua titeilis expa que amo tinechixmatis. ");
INSERT INTO azzNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ijcuacón Jesús quinilij imomachtijcahuan ijcuín: ―Xiquelnamiquican ne tonal cuac namechtitanic xitequitican. Huan amo nancuiyacque morral nión tominehualoni huan nión no namotegac. ¿Xe namechpoloto tensá? Huan yejuan quinanquilijque ijcuín: ―Amo teyi techpoloj. ");
INSERT INTO azzNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ijcuacón Jesús ocsepa quinilij ijcuín: ―Pero axcan namechilía que ne naquen quipía imorral, huelis ma cuica, huan no ma cuica itominehualoni. Huan ne naquen amo quipía imachete, ijcuacón yejua ma quinamaca se itaquen huan ma quicohua imachete. ");
INSERT INTO azzNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Huan nochi ijcón namechilía porín motamichiutiyás nochi ten ijcuiliutoc de Nejuatzin tech in Tajtoltzin de Dios campa Isaías quijtoco ijcuín: “Quipohuasque que Yejuatzin se amocuali tagat”. Ica ya nojón nechtajyohuiltisque. Pues nochi ten ijcuiliutoc de Nejuatzin tech in Tajtoltzin de Dios, nochi quipía que motamichihuas. ");
INSERT INTO azzNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ijcuacón imomachtijcahuan quilijque Jesús ijcuín: ―Totecotzin, nican yetoc ome machetejme. Huan Yejuatzin quinanquilij ijcuín: ―Ajsij ya nojón ome machetes. ");
INSERT INTO azzNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ijcuacón Jesús quisac de ne nepancal huan yajqui ajsito campa ne tal lomotzin ten monotza de ne Olivos campa ipa motatatautiliaya. Huan ne imomachtijcahuan quitoctilijque Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Huan cuac ajsique ya tech ne xocomila, ijcuacón Jesús quinilij imomachtijcahuan ijcuín: ―Ximotatatautilican ihuan Dios para ma in amocuali Satanás ma amo namechyoltanemililti ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Huan Yejuatzin amo huejca mosecocahuac de yejuan nican huejcatzin ijcón queme cuac se tacuamota ica se tet. Huan ompa Jesús motancuaquetzato huan pehuato motatatautilía inahuactzinco Itajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Huan Jesús quilij ijcuín: ―Notajtzin, tacán ticonmonequiltía, xinechajchihuilis nijín tajyohuilis ten niquijyohuiti ya. Pero ma amo mochihua queme nejua nicnequi. Ta, ma mochihua queme Tejuatzin ticonmonequiltía. ");
INSERT INTO azzNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Huan tech nojón momento monextico se ángel den eluiyactzinco para ijcón yejua quichicahualismacaya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Huan Yejuatzin semi tajyohuijtoya. Huan cachi oc motatatautiliaya ihuan Dios huan hasta mijtoniaya. Huan ica por neitajyohuilis ne ineton queme yesquí huejueyi esolol ten huetzía talixco. ");
INSERT INTO azzNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Huan cuac Jesús motamitatatautilij ya, ijcuacón moquetzac huan yajqui quinitato imomachtijcahuan. Huan mochihuac que quinajsito nochi cojcochtocque porín semi motayocoltiayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Huan Jesús quinilij imomachtijcahuan ijcuín: ―¿Queyé namejuan nancojcochtocque? Xiixpetantocan huan ximoquetzacan. Huan ximotatatautilican ihuan Dios para ma amo in amocuali Satanás namechyoltanemililtis ica tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Huan queman Jesús tajtojtoya oc ihuan imomachtijcahuan, ijcuacón ejcotihuetzque huel míac tagayot. Huan ne ten monotza ya Judas, yejua ne quinualyecantihualaya ne tagayot. Ne Judas yejua senme den majtactiomome imomachtijcahuan de Jesús. Huan yejua motoquijtiquisac huan de ompa quitennamic Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ijcuacón Jesús quilij Judas ijcuín: ―Tejua Judas, tinechtennamic ya para ijcón tinechtemactiaya inmaco in tayecanani de Nejuatzin ni Yectagatzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Huan neques ten ihuan Jesús quiyehualojtoyaj, cuac yejuan quitacque de toni mochihuati ya, ijcuacón yejuan quitajtoltijque Jesús ijcuín: ―Totecotzin, ¿xe ticonnequi ma tiquinmagacan ica tomachetejuan? ");
INSERT INTO azzNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Huan ijcón senme den imomachtijcahuan de Jesús, yejua ne quinacascocoj itaquehual de ne tayecancatiopixcat huan quicotonilij inacas ten yecmacopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero Jesús quinilij imomachtijcahuan ijcuín: ―Xicahuacan ne netehuilis huan amo teyi xicchihuacan. Huan de ompa Jesús quimatoquili inacas de ne taquehual huan quipajtij. ");
INSERT INTO azzNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Huan ompa oloch yetoyaj in tayecanani tiopixcame huan in tiopan tayecanani den policía huan in huehuentzitzin den pueblojuani de Israel. Nochi yejuan hualajque para cuicasque Jesús queme preso. Huan Jesús quintajtoltij ijcuín: ―¿Queyé namejuan nanualajque ica machete huan ica cuohuit para nannechquitzquisque, queme yesquí nejua se nitachtecque san? ");
INSERT INTO azzNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Huan cuac nejua mosta mosta niyetinemía namotzalan nepa tiopanijtic, ijcuacón namejuan amo queman nannechquitzquijque. Pero axcan ejcoc in hora de nanquichihuaj de ne amocuali chihualis. Huan yequintzin namotech quemiliutoc ya ne chicahualis den amocuali Satanás queme yesquía se tilahuac tayohuayanilot. ");
INSERT INTO azzNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ijcuacón ne tayecanani quiquitzquijque Jesús queme preso huan cuiyacque ichan in hueyi tiopixcat. Huan ne Pedro quihuejcatoctiliaya san ne Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Huan icalteno de ne hueyi tiopixcat quihueyitalijque tit, huan ompa quiyehualojque huan motalitoj. Huan ne Pedro no motalij intzalan de ne mayolme. ");
INSERT INTO azzNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Huan mochihuac que se tacualchiuque quitac que no ompa tocotzyetoc Pedro mototonijtoc ticonteno. Huan ne sihuat quisenitac in Pedro huan quijtoj ijcuín: ―Nijín tagat Pedro ihuan nentinemía Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ijcuacón in Pedro quitatij ten melau huan quinanquilij ijcuín: ―Tejua sihuat, amo melau ten tinechilijtoc. Nejua amo niquixmati aconi nojón Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Huan cachi satepan ocsé tagat quitac in Pedro huan no quilij ijcuín: ―Tejua no tipoutinemi ihuan ne imomachtijcahuan de Jesús. Pero in Pedro quinanquilij ijcuín: ―Tejua tagat, amo melau ten tinechilijtoc. Nejua amo nipoutinemi ninuan neimomachtijcahuan de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Huan cuac panoc se hora, ijcuacón ocsepa se tagat quiyecmatiltij itequiticaicnihuan ijcuín: ―Yec melau nijín tagat Pedro ihuan Jesús nentinemía porín yejua no se pueblojcat de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ijcuacón in Pedro ocsepa quinanquilij ijcuín: ―Tejua tagat, amo melau ten tinechilijtoc, hasta amo nicajsicamati de toni tinechilijtoc. Huan tech ne hora cuac tajtojtoya oc Pedro, ijcuacón tzajtzic in piotzin. ");
INSERT INTO azzNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ijcuacón in Totecotzin moicancuepac huan quisenixitac Pedro. Ijcuacón in Pedro quelnamic que quiluijca ya Jesús ijcuín: “Axcan achtopa que tzajtzis in piotzin, tejua Pedro, titelis ica expa que amo tinechixmati”. ");
INSERT INTO azzNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ijcuacón in Pedro ne calan quistehuac huan mocualancachojchoctito. ");
INSERT INTO azzNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Huan ne taca ten quipixtoyaj Jesús, yejuan nojonques quiquejqueloayaj huan cuitequíaj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Huan ne taca quixtzajtzacque Jesús ica tilma, huan quitajtoltiayaj ijcuín: ―¿Xiquixejeco aconi mitzixtajtatzinitoc? ");
INSERT INTO azzNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Huan ne taca cachi oc quihuijuicaltiayaj Jesús ica míac tataman tajtolme. ");
INSERT INTO azzNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Huan cuac tanesic ya, ijcuacón mosentilijque huan mosenixejecoltijque in huehuentzitzin den pueblojuani judíos ihuan in tayecanani tiopixcame huan in tanextiliani den tanahuatil de Moisés. Huan de ompa cuiyacque Jesús inixpan nochi nijín tayecanani. ");
INSERT INTO azzNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Huan yejuan quitajtoltiayaj Jesús ijcuín: ―Xitechili, ¿que cox melau tejua ya ti Cristo Temaquixtijque? Huan Jesús quinanquilij ijcuín: ―Tacán namechilía que ni Cristo Nitemaquixtijque, ijcuacón namejuan amo nannechneltoquilisque. ");
INSERT INTO azzNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Huan no como nejua namechtajtoltisquía tensá, ijcuacón ipa amo nannechnanquilisquíaj huan nión no nannechcajcahuasquíaj. ");
INSERT INTO azzNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero xicmatican que desde axcan para taixpan Nejuatzin ni Yectagatzin de Dios huan nimotalitiu ne iyecmacopaca Totajtzin Dios campa no mochiutoc ichicaucahuelilis. ");
INSERT INTO azzNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ijcuacón nochi in tayecanani quisentajtoltijque Jesús ijcuín: ―Ica nijín motajtoluan, quijtosnequi que tejua tiiconetzin de Totajtzin Dios. Huan Jesús ocsepa quinanquilij ijcuín: ―Quema, Niiconetzin de Dios, ijcón queme namejuan nanquijtoaj. ");
INSERT INTO azzNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ijcuacón nochi yejuan quijtoayaj ijcuín: ―¿Toni oc monequi ma timatajtanican? Ta, tejuan ya ticactocque que quijtoa que Yejuatzin iconetzin de Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ijcuacón nochi ne tayecanani moquetzque huan cuiyacque Jesús iixpan in hueyi tayecanque romano Poncio Pilato. ");
INSERT INTO azzNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Huan ompa iixpan Pilato in tayecanani peuque quitejteluilíaj Jesús ica míac tataman huan quiliayaj Pilato ijcuín: ―Tejuan ticajsicque nijín tagat Jesús cuac yejua quincuejmoloaya in topueblojcahuan. Huan nijín tagat no tetacahualtía que ma amo monequi tiquixtahuasque impuestos imaco in hueyi emperador romano. Huan no yejua quijtoa que yejua Cristo Temaquixtijque huan no yejua mopoutinemi queme rey. ");
INSERT INTO azzNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ijcuacón in Pilato quitajtoltij Jesús ijcuín: ―¿Xe melau tejua ya tirey den pueblojuani judíos? Pero Jesús quinanquilij ijcuín: ―Melau nirey, ijcón queme tiquijtoa. ");
INSERT INTO azzNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ijcuacón in Pilato quinilij in tayecanani tiopixcame huan in tagayot ijcuín: ―Nejuatzin ayamo teyi nicajxilía tajtacol ipan nijín tagat. ");
INSERT INTO azzNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero ne tayecanani cachi oc quiyequiliayaj Pilato ijcuín: ―Nijín tagat quincuejmolojtinemi ica nitamachtilis topueblojcahuan nican Judeajcopaca. Huan itequiu hualehuac ne Galileacojpaca huan hasta ejcoco nicahuín Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Cuac Pilato quicayic que Jesús pehuac itequiti campa Galileajcopaca, ijcuacón matajtanic cox Jesús yejua catca pueblojcat de Galilea. ");
INSERT INTO azzNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Huan cuac Pilato cajsicamatic que Jesús catca pueblojcat de Galilea campa Herodes taquitzquijtoc queme tayecanque, ica ya nojón Pilato quititanic Jesús imaco Herodes ten no moajsía ompa Jerusalén tech nojón tonalme. ");
INSERT INTO azzNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Huan cuac in Herodes quitac ya in Jesús, ijcuacón yejua moyolpactij porín ipan míac tonalme semi quinequía quitas Jesús. Huan Herodes ipa quinequía quinojnotzas Jesús porín Herodes quitecaquiliayaj den itequiu Jesús. Huan no Herodes quinequía quitas que Jesús ma quichihua se mohuiscatequit iixpan. ");
INSERT INTO azzNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Huan in Herodes quitatajtoltiaya Jesús ica míac matájtanti. Pero Jesús amo teyi ica quinanquiliaya. ");
INSERT INTO azzNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Huan ompa iixpan in Herodes yetoyaj ne tayecanani tiopixcame huan ne tanextiliani den tanahuatil de Moisés. Huan nochi yejuan quiteteluiliayaj Jesús ica míac yolchicahualis. ");
INSERT INTO azzNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ijcuacón in Herodes ihuan isoldados, yejuan peuque quimohuispoloayaj Jesús huan quiquejqueloayaj. Huan no quitaquentijque Jesús ica se cuajcualtzin tilma den rey. Huan de ompa in Herodes ocsepa quititanic Jesús imaco in Pilato. ");
INSERT INTO azzNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Huan nojón tonal in Pilato huan Herodes moyoltalijque se huan ocsé, porín achtopa mocualantijtinemíaj se huan ocsé. ");
INSERT INTO azzNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ijcuacón in Pilato ocsepa quinsentilij in tayecanani tiopixcame huan in tiopan tequihuani huan in pueblojuani de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Huan in Pilato quinilij ijcuín: ―Huan namejuan nannechualcuilijque nijín tagat Jesús. Huan no nannechilicoj que yejua ay quincuejmolojtinemi topueblojcahuan. Pero Nejuatzin nictatajtoltij ya nijín Jesús namoixpan ica míac matájtanti, huan ayamo teyi nicajxilij tajtacol nijín tagat tenica namejuan nanquitejteluilíaj. ");
INSERT INTO azzNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Huan xicmatican que in Herodes amo no teyi cajxilij tajtacol nijín tagat. Ica ya nojón ocsepa techualtitanilij. Huan axcan xicmatican que nijín Jesús amo quichihuac tajtacol ten cuica miquilis. ");
INSERT INTO azzNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ica ya nojón nejua sayó nicuitequis huan de ompa nicajcahuas ma yohui. ");
INSERT INTO azzNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Porín tech nojón iluitonal ipa ijcón mohuica in Pilato de que quicajcahuas se tagat preso ijcón queme in pueblojuani quinequíaj. ");
INSERT INTO azzNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Huan tech nojón momento nochin pueblojuani chicauca tzajtzíaj huan quijtoayaj ijcuín: ―Xicalanquixtican nijín tagat ma quimictiti. Huan ticnequij xicajcahua yejua in Barrabás ma yohui. ");
INSERT INTO azzNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Huan ne Barrabás quitzacuacque cárcelijtic porín yejua temictijque huan porín yejua no ay moixnamictinemía ihuan nisoldados in tayecanani de Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pero in Pilato quinequía quicajcahuas Jesús ma yohui huan ijcón quinnojnotzac tagayot ocsepa. ");
INSERT INTO azzNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Pero in pueblojuani cachi oc quichicaucaijtoayaj ijcuín: ―Xicuoupampilocan, xicuoupampilocan nojón Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Huan de ompa ica expa in Pilato quinilij in pueblojuani ijcuín: ―¿Toni tajtacol quichihuac nijín Jesús? Porín nejuatzin ayamo teyi nicajxilía tajtacol ten cuica miquilis. Ica ya nojón nejua sayó nicuitequis huan de ompa nicajcahuas, ma yohui. ");
INSERT INTO azzNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pero ne pueblojuani cachi oc quiyequiliayaj huan quitzajtziliayaj que ma quicuoupampilocan ne Jesús. Huan ne pueblojuani huan tayecanani tiopixcame, yejuan nojonques cachi oc quitzajtziliayaj Pilato hasta que quitaneltoctijque que ma quimictilican Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ijcuacón in Pilato quitelchihuac Jesús ma quimictican ijcón queme quinectoyaj in pueblojuani huan in tayecanani judíos. ");
INSERT INTO azzNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ica ya nojón Pilato quicajcahuac ne Barrabás ne ten temictijque huan ten ay moixnamictinemía ihuan isoldados in tayecanani de Jerusalén. Huan ijcón quichihuac Pilato porín ijcón in pueblojuani intanejnequilis ma mochihua. Huan no Pilato quitemactij Jesús inmaco in pueblojuani para ma yejuan quichihuilican Jesús ijcón queme yejuan quinequíaj. ");
INSERT INTO azzNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Huan cuac Jesús cuicatoyaj ya para quicuoupampilotij, ijcuacón quinamicque se tagat ten monotza Simón ten pohuía campa pueblo Cirene. Huan ne Simón hualaya motoquijtihuaya para ajsis Jerusaléncopaca. Huan in soldados quimamaltijque Simón ma cuica ne colotzin. Huan ijcón yejua quimamaltiyá ne colotzin huan quitoctiliaya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Huan no huel míac pueblojuani quitoctiliayaj Jesús. Huan no míac sihuame yayaj huan chocatiayaj ica por ne Jesús huan tzajtzitiayaj ica hueyi yolcocolis ica por ne Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ijcuacón Jesús moicancuepac campa hualayaj ne sihuame huan quinsenixitac huan quinilij ijcuín: ―Namejuan nansihuame de pueblojuani Jerusalén. Amo xinechchoquilican. Ta, ximochoctican por namejuan san huan no ximochoctican por ica ne namoconehuan. ");
INSERT INTO azzNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Huan ijcón namechilía porín namopan ejcos ne tonalme ten cualcui tajyohuilis. Ijcuacón sequin quijtosque ijcuín: “Yolpactocque sihuame ten amo quinpíaj coneme huan yolpactocque neques ten amo queman mopilcuicque. Huan no yolpactocque neques ten amo queman tachichitijtinemij”. ");
INSERT INTO azzNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Tech nojón tonalme in pueblojuani quinilisque in tepeme ijcuín: “Namejuan nantepeme xihuetziquij topan. Huan no namejuan nantallomotzitzin, xitechpechiquij”. ");
INSERT INTO azzNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Huan Jesús quiniliaj ica se nexcuitil ijcuín: ―Nejuatzin amo teyi nicpía tajtacol. Huan nicnequi nimonejnehuililtis queme se cuohuit ten cualtzin motaquiltía ica itaquilot ten quinequi quimayohuisque. Huan como Nejuatzin nechmictisque huan amo nitajtacole, ijcuacón ¿toni mochihuas namopan namejuan ten semi nantajtacolejque? ");
INSERT INTO azzNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Huan no quinuiyacque ome tachtequini ten ipa quintelchiuque ya para ma no quinmictican ihuan Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Huan cuac ajsitoj ya ne campa motanotza miquetzontecomatan, ijcuacón quicuoupampilojque Jesús ihuan ome taca ten no quintelchiuque. Huan se tachtecque quicuoupampilojque iyecmacopaca huan in ocsé iopochcopaca de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Huan cuac quicuoupampilojtoyaj Jesús, ijcuacón quijtoj Yejuatzin ijcuín: ―Notajtzin Dios, xiquintapojpolui nijín taca porín amo cajsicamatij toni quichiutocque. Huan ne itilma Jesús quicuicque ne soldados huan quichiuque ne tatanilis para quitasquía de catiyejua tasal de Jesús cuicasquía cada soldado. ");
INSERT INTO azzNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Huan ompa nochi quitztoyaj in pueblojuani. Huan nochi yejuan den tayecanani judíos quiquejqueloayaj Jesús huan quijtoayaj ijcuín: ―Ne Jesús quinmaquixtij ocsequin tagayot. Huan como melau yejua in Cristo Temaquixtijque in taijitaltzin de Dios, ijcuacón ma momaquixti yejua san. ");
INSERT INTO azzNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Huan no ijcón quichiuque in soldados de quihuijuicaltiayaj Jesús. Huan ne soldados motoquijque para quitayiltisque Jesús in vinagre. ");
INSERT INTO azzNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Huan ne soldados quiliayaj Jesús ijcuín: ―Tejua ya, como melau ti rey den pueblojuani judíos, ijcuacón ximomaquixti tejua san. ");
INSERT INTO azzNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Huan quitalilijque colotzin icuaco se cuohuit campa ijcuiliutoc ica tajtolme de griego huan de latin huan de hebreo. Huan nojón tajcuilol quijtoaya ijcuín: “Nijín tagat, yejua tayecanque den judíos”. ");
INSERT INTO azzNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Huan senme den tachtequini ten quitelchiuque ma quicuoupampilojca inacastan de Jesús, yejua cachi oc ne quimohuispoloaya Jesús huan quiliaya ijcuín: ―Como melau tejua ya ti Cristo Temaquixtijque, ximomaquixti tejua san moselti. Huan tejuan no xitechmaquixti. ");
INSERT INTO azzNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Pero in ocsé tagat ten no quicuoupampilcatoc ya, yejua ne quitacahualtij in ocsé huan quilij ijcuín: ―¿Queyé tejua amo ticyolmohuilía Totajtzin Dios? ¿Huan amo no timoyolnemilía de motajtacoluan? Porín tejua no titatelchihual ya huan mitzmictisque porín mitznamiqui. ");
INSERT INTO azzNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Huan tejuan hueyi melau quinamiqui ma tiquijyohuican nijín tajyohuilis ten topan yetoc ya porín ticchiuque ten amo cualtía. Ica ya nojón monequi timiquisque. Pero nijín tagat Jesús amo teyi tajtacol quichihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ijcuacón yejua quilij Jesús ijcuín: ―Tejua Jesús, xinechonelnamiqui ne tonal cuac tejua ticonselitiu ya in tanahuatil de mohueyichicahualis imaco Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ijcuacón Jesús quinanquilij ijcuín: ―Yec melau ten nimitzilía que axcan nohuan tiyetotiu ne eluiyactzinco campa Dios tayecantica. ");
INSERT INTO azzNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Huan nepa queme nepanta ya, ijcuacón sepan san tayohuayantic tech nochi in semanahuac huan tayohuayantitoya hasta eyi hora de tiotac. ");
INSERT INTO azzNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Huan in tonaltzin nochi pojpolihuic imeyoyo huan mocahuac tayohuayanijtic. Huan ne tasal ten pilcatoya ne hueyi tiopanijtic campa in altar, yejua ne ixtzayanic sen tatajco. ");
INSERT INTO azzNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ijcuacón Jesús chicaucatzajtzic huan quijtoj ijcuín: ―Notajtzin Dios, nimotemactía momacotzinco, xiconseli notalnamiquilis. Huan cuac quitamiijtoj ya nijín tajtol, ijcuacón Yejuatzin momiquilij. ");
INSERT INTO azzNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Huan cuac ne tayecanque soldado quitac ya toni mochihuac, ijcuacón yejua quimohuistilij Totajtzin Dios huan quijtoj ijcuín: ―Yec melau nijín tagat Jesús yejua yolchipaucatagat catca. ");
INSERT INTO azzNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Huan míac pueblojuani ompa taixpan yetoyaj huan quitztoyaj ya de que toni mochiutoc. Huan cuac yejuan mocuepteuque huan yayaj para Jerusalén, ijcuacón moelmajmagayaj porín quiyolmachiliayaj de toni mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Pero ompa yetoya míac tagayot ten Jesús ihuan moixmatíaj huan no miacque sihuame ten quipalehuijtinemíaj Jesús desde cuac hualehuac Jesús campa Galileajcopaca. Huan nochi nojonques mocauque campa Jesús huan tachixtoyaj de huejca san. ");
INSERT INTO azzNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Huan tech ne tonal yetoya se tagat ten monotzaya José; yejua se pueblojcat de Arimatea de itatilanal Judea. Huan yejua se yolmelaucatagat huan se yolcuali tagat. Yejua no catca se tayecanque den pueblojuani de Israel. ");
INSERT INTO azzNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Huan nijín José ipa quichixtoya ne tonal cuac Dios momasoutos ica ihueyichicahualis para quinyolyecanas in pueblojuani de Israel. Huan ne José amo semi tehuan moyectencahuac ihuan ne tayecancaicnihuan ten yejuan quichiutoyaj. ");
INSERT INTO azzNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ica ya nojón ne José quitato in tayecanque Pilato huan quitajtanilito ma quimactili inacayo Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Huan de ompa José quitemohuito inacayo Jesús itech in cruz, huan quitetziloj ica se hueyi tilma. Huan ne José cuiyac inacayo Jesús huan quicalaquito campa se hueyi tecoyoc ten tamachijchiu campa ayamo aquen quinalcalaquiayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Huan ne tonal tiotac ya nochi in pueblojuani monequía moyectatalisque para imostica ne tonal de nesehuilis cuac quichihuaj ne tajyohuilis iluit. Huan ne iluitonal ejcotoya ya in momento de pehuas. ");
INSERT INTO azzNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Huan ne sihuame ten quipalehuijtinemíaj Jesús desde ne cuac hualeuque Galileajcopaca, yejuan nojonques yajque quihuejcatoctilijque in José para quitasque can yetoc in tecoyoc huan para quitasque queniu quinalcalaquijque in inacayo Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Huan cuac ne sihuame hual mocuepatoj ya huan calaquicoj ninchan, ijcuacón yejuan quinsentilijque sequi polmada para quiojxilisque in inacayo Jesús para ma amo semi tzojya inacayo de Jesús. Huan de ompa yejuan mosehuijque tech nojón tonal de nesehuilis, ijcón queme tenahuatía in tanahuatil de Moisés. ");
INSERT INTO azzNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Huan tech ne tayecanque tonal de semana, yejua ne ten axcan domingo, cuac semi cualcan oc, ijcuacón ne sihuame yajque campa netecoyoc cuicayaj ne ajuiyacayot ten quichijchiuque ya. Huan no ocsequin sihuame quinsehuicayaj. ");
INSERT INTO azzNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Huan cuac ajsicque ya, ijcuacón quitacque ne tet tenica quitentzacuacque in tecoyoc ipa quinacastanxolauque ya. ");
INSERT INTO azzNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ica ya nojón yejuan calacque tech in teyococ, pero amo cajsique inacayo de Totecotzin Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Huan ne sihuame quimoucaitayaj ten mochihuac huan amo quimatíaj toni quichihuasque oc. Ijcuacón moquetztihuetzicoj ome taca inixpan de ne sihuame ten nintilma semi istac huan pepetacaya. ");
INSERT INTO azzNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Huan ne sihuame semi moyolmoutijtoyaj huan moixacatentocaya talixco. Ijcuacón ne ángeles quinilijque in sihuame ijcuín: ―¿Queyé namejuan ay nanquitemojtinemij intzalan in ánimajme in Jesús? Ta, Yejuatzin yoltinemi axcan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Xicmatican que axcan Jesús amo nican yetoc oc. Ta, Dios quipanquixtij ya yoltoc intzalan in ánimajme. Huan xiquelnamiquican san ten namechilijca ya Jesús ne achtopa cuac namohuan yetinemía oc ne Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Huan ne Jesús namechilijca ijcuín: “Semi monequi que Nejuatzin ni Yectagatzin de Dios ma nechtemactican inmaco ne taca ten amo yolcualime. Huan ma nechcuoupampilocan huan ipan eyi tonalica nipanquisas niyoltoc intzalan in ánimajme”. ");
INSERT INTO azzNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ijcuacón ne sihuame quielnamicque ya de ne nitajtoluan ten quinilijca ya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Huan cuac quisteuque den ne tecoyoc huan yajque Jerusaléncopaca ya, ijcuacón ne sihuame nochi quintapohuitoj ne majtactionse imomachtijcahuan de Jesús. Huan no cachi oc quintapohuitoj in ocsequin taneltocani. ");
INSERT INTO azzNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Huan nijín sihuame ten quintapohuitoj itanojnotzcahuan de Jesús, yejuan nojónques in María Magdalena, huan in Juana huan in María ten inan Jacobo, huan ocsequin sihuame. ");
INSERT INTO azzNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Huan imomachtijcahuan de Jesús quixejecoayaj que mijmiquiloyot san ne ten quitapohuiayaj in sihuame. Huan ijcón yejuan amo ipa quineltogaque. ");
INSERT INTO azzNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pero in Pedro calan quistehuac huan motalojteu hasta ajsito campa ne tecoyoc. Huan cuac yejuan naltachíac, ijcuacón quitac ne tilma seseco huetztoc ya. Huan de ompa nimampa yajque ichan huan quimoucanemilijtiaya de toni mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Huan tech ne tayecana tonal, ne ten axcan domingo, ome imomachtijcahuan de Jesús yayaj campa ojti ten yajtoc para Emaús. Nican huejca quipiaya majtactionsé kilómetro de Jerusalén hasta Emaús. ");
INSERT INTO azzNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Huan nojón omen monojnotztiayaj ica nochi ne ten mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Huan mochihuac que cuac yejuan san monojnotztiayaj huan motajtoltentehuijtiyáj yejuan san, ijcuacón motoquico huan quinajsico Jesús huan ijcón Yejuatzin ihuan nejnentiaya. ");
INSERT INTO azzNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Huan ne ome masqui quitayaj Jesús, pero amo quimatíaj aconi yejua. Porín Totajtzin Dios ayamo quinajsicamatiltij que nijín in Jesús Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ijcuacón Jesús quintajtoltij ne omen ijcuín: ―¿Toni nojón tenica nanmotajtoltenuijtiyohue tech nijín ojti? ¿Huan queyé namejuan nanyoltayocoyaj? ");
INSERT INTO azzNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Huan ijcuacón senme de yejuan ten monotza Cleofas, yejua ne quinanquilij ijcuín: ―Huan nochi in pueblojuani cuali quimatque ya toni mochihuac ne Jerusalén tech nijín tonalme. Huan tejua que tipueblojnemito ya ne Jerusalén, ¿huan amo ticmati nijín ten mochihuac? ");
INSERT INTO azzNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Ijcuacón Jesús quintajtoltij ocsepa ijcuín: ―¿Toni mochihuac de ne Jerusalén? Huan ne taca quinanquilijque ijcuín: ―Xicmati de toni ipan mochihuac ne Jesús de Nazaret. Yejuatzin catca se tanahuatijque de Dios huan yejua quinextijtinemía hueyi chicahualis tech nochi nichihualisuan huan tech nochi nitajtoluan ijcón queme iixpantzinco Dios huan inixpan pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Pero ne tayecanani tiopixcame huan totequihuajcahuan, yejuan nojonques quitemactijque Jesús ma quitelchihuacan huan ma quicuoupampilocan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Huan tejuan ticchiayaj que ne Jesús, Yejuatzin yesquía in Temaquixtijque ten hualasquía para techajchihuasquía inmaco in tayecanani romanos nochi tejuan tipueblojuani de Israel. Huan amo yequin mochihuac de que momiquilij ya. Ta, quipía eyi tonal ya ten quimictijque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Huan sequin sihuame ten taneltocaj queme tejuan, yejuan nojonques techmoucacalaquijque porín yejuan yajcaj campa ne tecoyoc achtopa que tanesic. ");
INSERT INTO azzNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Huan ompa yejuan amo cajsicque inacayo Jesús. Ica ya nojón yejuan techilicoj de toni mochihuac huan no techilicoj que yejuan quinitacque sequin ángeles. Huan ne ángeles quinilijque in sihuame que Jesús ocsepa yoltinemi. ");
INSERT INTO azzNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Huan cachi satepan sequin totequiticaicnihuan no yajque campa ne tecoyoc huan melau amo teyi cajsicque. Huan no quitacque ijcón queme in sihuame techilijcaj ya. ");
INSERT INTO azzNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ijcuacón Jesús quinilij ne omen ijcuín: ―Semi nanyolpipicticque huan semi nantanejnematini san para nanquineltocasque nochi ten in tanahuatiani de Dios namechiluijque ya. ");
INSERT INTO azzNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Xe amo melau que in Cristo Temaquixtijque semi monequi ma tajyohui nochi tajyohuilis ten namechiluijque in tanahuatiani de Dios? Huan satepan cuac Cristo quitamijyohuis ya, ijcuacón quipías de calaquitiu nepa tacualtzincan para tayecantinemis ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ijcuacón Jesús pehuac quinajsicamatiltij ne imomachtijcahuan nochi in Tajtoltzin de Dios campa tajtoa de Cristo Temaquixtijque. Huan pehuac quinnextilía ica in Tajcuilolamatzin ten quichihuac Moisés hasta ne tajcuilolamame ten quijcuilojque ne ocsequin tanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Huan cuac ajsicque ya tech in pueblo Emaús campa ipa monequía ajsisque, ijcuacón Jesús quinilij que yejua quisentocati oc tech in ojti. ");
INSERT INTO azzNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero ne ome quitatautijque que ma mocahua oc ninuan, huan quiniliayaj Jesús ijcuín: ―Ximocahua nican tohuan porín semi tiotac ya huan niman tayohuayantiti. Ijcuacón Jesús calaquic tech in pueblo de Emaús para inuan mocahuas ne omen imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Huan mochihuac que cuac sentacuajtocque oc, ijcuacón Jesús momaaquij se pantzin. Huan de ompa quitiochihuac huan quicojcotonac in pan huan quinmajmactij ne imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Huan tech nojón momento Dios quinajsicamatiltij ne ome de toni mochiutoc huan ijcón yejuan quixmatque ya que Yejuatzin in Jesús Temaquixtijque. Pero Jesús nimantzin majchihuac huan amo quitacque oc ninixpan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ijcuacón yejuan moliayaj se huan ocsé ijcuín: ―Huan melau que semi tiyolpactihualayaj tech in ojti huan ticyolmachiliayaj que Dios techyolnojnotztoyaj cuac in Jesús technojnotztihualaya huan techajsicamatiltijtihualaya den Tajtoltzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Huan tech nojón hora ne ome moijsiucaquetzteuque huan yajque ocsepa Jerusalénjcopaca. Huan ompa quinajsito senyetocque ne majtactionsé itanojnotzcahuan ihuan nochi nitaneltocaicnihuan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Huan ijcón miacque quinilijque ne ome ijcuín: ―Yec melau que Totecotzin panquisac ya yoltoc intzalan in ánimajme. Porín Yejuatzin monextij iixpan in Simón. ");
INSERT INTO azzNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ijcuacón ne ome peuque quintapohuiyayaj nochi ten mochihuac tech ne ninojpan huan no quintapohuijque de queniu quixmatque Jesús cuac Yejuatzin quincojcotonilij in pantzin. ");
INSERT INTO azzNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Huan cuac monojnotzayaj oc ne miacque imomachtijcahuan, ijcuacón in Jesús monextijtihuetzico inixpan huan quilij ijcuín: ―Xicpiacan yolsehuilis. ");
INSERT INTO azzNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Pero yejuan mohueyiyolmoutijque huan quitetzaucaitayaj porín yejuan quiyolnemiliayaj que xa quitztoyaj se ánima. ");
INSERT INTO azzNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ijcuacón Jesús quinilij ijcuín: ―¿Queyé namejuan nanmomoucacuatapololtijque? Huan, ¿queyé no semi nantanemilíaj elihuis? ");
INSERT INTO azzNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Xiquitacan nomahuan huan nometzuan. Nejuatzin ya ni Jesús. Xinechmajmachilican huan xinechitacan. Porín xicmatican se ánima amo quipía nacat nión iomiyohuan. Pero Nejuatzin nannechitilijtocque nonacayo huan noomiyohuan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Huan cuac Jesús quintamiilij nijín tajtol, ijcuacón Yejuatzin quinextilij ya imomachtijcahuan nimahuan huan nimetzuan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Huan masqui moyolpactiayaj huan quitetzaucaitayaj ten mochihuac pero ayamo quiyecneltocayaj que cox yejuatzin ya in Jesús. Ica ya nojón Jesús quinilij ijcuín: ―¿Xe nancompíaj tensá para ticuasque? ");
INSERT INTO azzNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ijcuacón yejuan quimactilijque Jesús tzictzin pescado nacat ten tatehuatz huan no quimactilijque tzictzin necti. ");
INSERT INTO azzNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Huan ijcón Jesús quicuic huan quitamicuaj inixpan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Huan de ompa Jesús quinilij ocsepa ijcuín: ―Huan cuac namohuan niyetinemía oc, ijcuacón namechnojnotztoya ica nijín tajtolme que semi monequi ma motamichihua nochi in tajtolme ten Nejuatzin notechcacopaca ijcuiliutoc tech in Tajtoltzin de Moisés. Huan no monequi ma motamichihua ten quijcuilojque in huejcautanahuatiani de Dios huan no ten ijcuiliutoc tech in Salmos. ");
INSERT INTO azzNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ijcuacón Jesús quintamachilistapoj imomachtijcahuan. Huan de ompa yejuan cajsicamatque ya nochi ne nintajcuiloluan den ne tanahuatiani. ");
INSERT INTO azzNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Huan no Jesús quinilij ijcuín: ―Nocnihuan, ijcón queme ijcuiliutoc tech in Tajtoltzin de Dios que Nejuatzin ni Cristo Temaquixtijque, semi monequi nitajyohuis huan nimiquis. Huan no monequi que nipanquisas niyoltoc intzalan in ánimajme ipan eyi tonalica. ");
INSERT INTO azzNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Huan no monequi que namejuan xitanojnotztinemican ica in chicahualis de notocaytzin ipan nochi semanahuac. Huan xicpehualtican namotequiu desde nican Jerusalén. Huan xiquilican nochi in talticpacuani que monequi moyolnemilisque de nintajtacoluan para ijcón Dios quintapojpoluis. ");
INSERT INTO azzNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Porín namejuan nochi nanquitacque ya nijín ten nopan mochihuac. ");
INSERT INTO azzNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Huan xicmatican que namechualtitanilis ne Yecticatzin Espíritu ten Notajtzin Dios namechtenilijca que namechualtitanilis. Pero namechilía que ximocahuacan nican pueblo de Jerusalén huan xicchiati hasta ne tonal cuac mohualuicas in Yecticatzin Espíritu den eluiyactzinco huan ijcón namechquemilos ica yolchicahualis de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ijcuacón Jesús quinuiyac imomachtijcahuan huan yejuan quisque huan yajque hasta caltempan den pueblo Betania. ");
INSERT INTO azzNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Huan ijcón Yejuatzin momaajocuic huan quitatautij Dios ma quintiochihua imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Huan mochihuac que cuac quintiochihuac ya, ijcuacón Jesús pehuac moajcuic de yejuan. Huan Totajtzin Dios quiajocuic huan cuiyac eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Huan cuac imomachtijcahuan quitamimohuistilijque ya Dios, ijcuacón yejuan mocuepque huan yajque ica míac yolpaquilis huan ajsitoj tech pueblo Jerusalén. Huan ompa quisentocayaj yayaj tech ne hueyi tiopan de judíos campa quimohuistiliayaj huan quihueyichihuayaj Totajtzin Dios. Ma ijcón mochiutiu. Amén.");
INSERT INTO azzNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Huan cuac ayamo tzinpehuaya in talticpac, ijcuacón ipa yoltinemi in Tajtoltzin de Dios. Huan ne Tajtoltzin ipa yetinemi iixpantzinco Totajtzin Dios. Huan ne Tajtoltzin Yejuatzin ne no catca Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Huan ne Tajtoltzin nentinemi iixpantzinco in Totajtzin Dios achtopa que tzinehuasquía nijín talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Huan in Totajtzin Dios nochi quichijchihuac nican talticpac ica ne ichicahualis den Cristo Itajtoltzin de Dios. Huan amo teyi ongac nican talticpac como amo Yejuatzin in Tajtoltzin quichijchihuac. ");
INSERT INTO azzNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","In Tajtoltzin Yejuatzin ne quipixtoc imaco nochi chicahualis para quitemacas nemilis. Huan Yejuatzin quitemaca nemilis huan ne nemilis yejua ne se tanex ten quinyoltahuilía in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Huan ne tanextzin teyoltahuilía campa ne tayohuayanilot den tajtacol, huan ne tayohuayanilot amo huelis quisejsehuis ne tanextzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Huan se tonal Totajtzin Dios quijitac se tagat monotza Juan huan tatitanic ma yolico nican talticpac, huan Dios quihualtitanilij ma quichiutinemi nitequiu. ");
INSERT INTO azzNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Huan in Totajtzin Dios quinahuatilij que Juan ma tetapohuijtinemi huan ma tanojnotztinemi ica por ne tanextzin para ma xiyecajsicaneltocacan in talticpacyetoni de ne tanextzin ten teyoltahuilía. ");
INSERT INTO azzNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Huan in Juan amo catca ne tanextzin. Ta, Juan sayó queme se tanojnotzque quinnextilijtinemía in talticpacuani de aconi ne tanextzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Huan ne yec melau tanextzin, yejua ne ica quinyoltahuilijtihualaya nochi in talticpacuani ten ejcotihualayaj nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Huan ne tanextzin Yejuatzin in Jesús Temaquixtijque ten huala nemico nican talticpac. Pero miacque in talticpacuani amo quixmatque, masqui Totajtzin Dios quichijchihuac nijín talticpac ica por yejua ichicahualis ne Yejuatzin in Tajtoltzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Huan masqui huala Jesús Temaquixtijque nican talticpac campa itaaxcayan huan campa ipueblojcahuan, pero in talticpacuani amo quiselijque nitanojnotzalis ten quinualcuilij Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Pero ocsequin, quema, quiselijque nitajtoltzin de Jesús huan no ihuantzin tacuautamatque tech in chicahualis den nitocaytzin. Huan nochi neques ten ihuantzin tacuautamatijque, yejuan nojonques in Jesús Temaquixtijque quinmactilij tanahuatil para ma yejuan pohuican ihuan Totajtzin Dios queme teconehuan. ");
INSERT INTO azzNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Huan nojonques ten ihuantzin Jesús tacuautamatque, yejuan nojonques yec melau mochihuacoj teconehuan den Totajtzin Dios, pero amo porín ijcón yolicoj nican talticpac. Huan amo no mochihuacoj iconehuan Totajtzin Dios ijcón queme cuac se tetat quiniscaltía iconehuan. Huan amo no mochihuacoj iconehuan Totajtzin Dios porín se tagat huan se sihuat de nitanejnequilis san. Ta, yejuan mochihuacoj teconehuan de Dios sayó porín Yejuatzin quimonequiltij quinyancuicayolitía. ");
INSERT INTO azzNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Huan ne Jesús Temaquixtijque ten quitocaytíaj Tajtoltzin, Yejuatzin mochihuaco tagat nican talticpac; huan ne Tajtoltzin nentinemía tohuan sequi tonalme. Huan itech Jesús yejua ne Tajtoltzin tiquitilijque que Yejuatzin tanextilijtinemía ica ne teicnelilis, huan itech Yejuatzin no ticajxilijque tajtolme den yec melau. Huan cuac Yejuatzin nemic tohuan, ijcuacón tiquitilijque ne ichicahualilis; huan ne chicaucahuelilis Totajtzin Dios quimactilij iyojtzin Conetzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Huan ijcón ne Juan Taahuijque quitetatohuiltíaya Jesús huan quiniliaya in tagayot ijcuín: ―Nijín Jesús Yejuatzin achtopa ya namechtapohuiaya cuac nejua namechiliaya ijcuín: Ne ten hualajtoc nimampa de nejua, Yejuatzin ya ne cachi hueyi chiuque huan que nejua, porín Yejuatzin ipa yoltinemi ne achtopa ya que nejua niyolisquía. ");
INSERT INTO azzNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Huan tinochi ticselijtinenque ya nochi tataman tapalehuilis ten hualehua itech italnamiquilis de Cristo. Huan Totajtzin Dios technenepantalilía ojcachi oc iteicnelilis ica por ne Jesús Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Huan ica por ne huejcautanahuatijque Moisés, ticmaticoj in tanahuatil de Dios. Huan no ticmatij que techajsico ya ne teicnelilis de Dios huan ne yec melau Tajtoltzin de Dios sayó ica por ne Jesucristo. ");
INSERT INTO azzNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Huan amo aquen queman acsá quitac Totajtzin Dios. Ta, sayó ne Iyojtzin Iconetzin ten semi moyoltasojtaj ihuan Itajtzin Dios. Huan yejua ne iyojtzin Conetzin hualehuac iixpantzinco Totajtzin Dios huan huala nican talticpac para technextilico quenín tamati Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Huan in Juan Taahuijque techtapohuía de que in tayecanani judíos de pueblo Jerusalén quinualtitanque sequi tiopixcame huan sequin tapalehuiani den tiopixcame, yejuan ten monotzaj Levitas. Huan ijcón yejuan quitajtoltijque in Juan ijcuín: ―¿Aconi tejua? Huan, ¿toni tanahuatil ticualcuitihuitz tejua, Juan? ");
INSERT INTO azzNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Huan ijcón in Juan quinyequiliaya, huan amo teyi quintaatiliaya. Ta, quinyecajsicamatiltij ijcuín: ―Pues, nejua amo ni Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ijcuacón ocsepa ne tiopixcame quitajtoltijque in Juan ijcuín: ―Pues, ¿aconi tejua? ¿Xe tejua ya ti Elías, ne tanahuatijque de Dios? Ijcuacón in Juan quinnanquilij ijcuín: ―Nión no nejua ni Elías. Huan de ompa ocsepa yejuan quiyectajtoltijque in Juan ijcuín: ―¿Xe tejua ya tihueyitanahuatijque de Dios ten quipía que hualas, Yejuatzin ne Cristo Temaquixtijque? Huan in Juan ocsepa quinnanquilij ijcuín: ―Amo no nejua ninetanahuatijque ten quipías que hualas. ");
INSERT INTO azzNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ijcuacón in tiopixcame quilijque Juan ijcuín: ―Pues, ¿aconi tejua ya pos? Xitechili porín tejuan monequi ticuicasque tensá tajtol para tiquinmaquilisque huan tiquinmatiltisque ne naquen techualtitanque. Pues, ¿xe semi amo tihuelis xitechili aconi tejuatzin? ");
INSERT INTO azzNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ijcuacón in Juan quinnanquilij ocsepa in tiopixcame ijcuín: ―Nejuatzin ya den namejuan nannechcactocque ya ica nijín notajtolis huan nitanajnahuatía campa ne taiucan. Huan niquinilijtoc in tagayot ijcuín: “Xicmejmelahuacan se ojtzin campa huelis panos in Totecotzin”. Huan ijcón namechilía porín ipa ijcón quijtojteu ne huejcautanahuatijque Isaías. ");
INSERT INTO azzNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Huan no in tamachilejque fariseos yejuan nojonques ipa quinualtitancaj ya nijín tiopixcame para ma quiyectajtoltican in Juan Taahuijque. ");
INSERT INTO azzNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ica ya nojón yejuan ocsepa quitajtoltijque in Juan huan quilijque ijcuín: ―Pues, ¿queyé tejua titaahuijtinemi? Como tejua amo tion Cristo, huan como nión ti Elías huan como nión no titanahuatijque de Dios ten quipías de hualas. ");
INSERT INTO azzNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ijcuacón in Juan quinnanquilij ijcuín: ―Pues melau nejua nitaahuijtinemi ica at san, pero nican yetoc se tamachtijque namotzalan ten amo nanquitaj huan nión no nanquixmatij. ");
INSERT INTO azzNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Yejua ya ne tamachtijque hualajtoc de nechualtoctilijtoc nimampa de nejua, huan Yejuatzin ipa nentihuitz ya achtopa que nejua niyolis. Huan nejua amo nechnamiqui que ma nictojtomilis ne nimetzuijconca de nitegac, ne naquen nechualtojtocatoc. ");
INSERT INTO azzNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Huan nochi nijín mochihuac tech ne lugar campa monotza Betábara ten yetoya ne iquisayampa in tonal den sentapalpa de hueyíat den monotza Jordán, nepa campa Juan taahuijtoya. ");
INSERT INTO azzNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Huan imostica in Juan Taahuijque quitac Jesús que motoquijtihuala ya campa yejua. Ijcuacón in Juan quinilij in tagayot ijcuín: ―Xiquitacan san, ne huitza ya in tagatzin ten Dios cualtitanic ten tamati queme ichcatzin. Huan ne ichcatzin yejua ya ne quinajchihuilis nintajtacoluan de nochi talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Huan namechtapohui ya de ne tagatzin ijcuín: “Nimampa de nejua hualajtoc se tagat huan Yejuatzin ne den semi cachi hueyi chiuque huan nejua amo teyi nichiuque, porín Yejuatzin ipa nentihuitz ya achtopa que nejuatzin ninemisquía”. ");
INSERT INTO azzNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Huan melau nejua amo no niquixmatía de aconi Yejuatzin; pero axcan niquixmati ya. Ica ya nojón nejua nihuala niquinahuijtihuala ica at para ma ijcón niquinajsicamatilti in pueblojuani de Israel de aconi Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Huan ijcón in Juan ocsepa quintapohuij in tagayot ten yejua quitac huan quinilij ijcuín: ―Huan nejuatzin niquitac in Yecticatzin Espíritu cuac Yejuatzin hual pantemoaya de ne eluiyactzinco ijcón queme hual temoa se tototzin paloma. Huan no niquitac que calaquito itech ne Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Huan masqui nejua amo niquixmatic aconi ne Jesús, pero ipa Totajtzin Dios nechualtitanic ma nitaahuijtinemi ica at. Huan Totajtzin Dios ipa nechilijca ya ijcuín: “Cuac tiquitas ne Yecticatzin Espíritu que hual temos huan calaquitiu itech se tagat, xicmati que yejua ya ne teojxilijtiyás huan teyolpexontijtiyás ica in chicahualis den Yecticatzin Espíritu”. ");
INSERT INTO azzNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Huan nejua niquitac ya que ijcón mochihuac ipan ne Jesús. Ica ya nojón namechtapohuij de que Jesús yejua ya nijín Teconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Huan ijcón ocsepa imostica in Juan Taahuijque ijcatoya monojnotztoya ihuan omen imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Huan cuac in Juan quitac que ompa panoaya Jesús Temaquixtijque, ijcuacón Juan quinilij ne imomachtijcahuan ijcuín: ―Xiquitacan san, ne huitza ya in tagatzin ten Dios cualtitanic ten tamati queme ichcatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Huan ijcón cuac in omen imomachtijcahuan de Juan caquilijque ya de nitajtolis de Juan, ijcuacón nojón omen yajque huan quitoctilijque in Jesús para ijcón ma momachtijtiyasque de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ijcuacón in Jesús niman mocueptiquisac para tacuitapampa huan quinitac que quitoctiliayaj ne omen imomachtijcahuan de Juan huan Jesús quinilij ijcuín: ―¿Aconi nanquitemojtiyohue? Huan yejuan quinanquilijque ijcuín: ―Totamachtijcau, ticnequij ticmatisque, ¿can tioncalyetica? ");
INSERT INTO azzNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ijcuacón in Jesús quinnanquilij ne omen ijcuín: ―Xihualacan huan xiquitaquij. Huan ijcón ne omen imomachtijcahuan de Juan melau yajque huan quitacque can calyetoya in Jesús. Huan ijcón ihuan tiotacque Yejuatzin porín catca ipa queme nahui hora de tiotac ya. ");
INSERT INTO azzNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Huan in Andrés ihuan ocsé tagaicniu, yejuan nojonques catcaj imomachtijcahuan de Juan huan yejuan quicaquilijque ne itajtolis de Juan. Ica ya nojón yejuan quitoctilijque in Jesús Temaquixtijque para ijcón momachtisque de Yejuatzin. Huan ne Andrés, yejua ne catca iicniu de Simón Pedro. ");
INSERT INTO azzNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ijcuacón in Andrés amo teyi ica quinejnematic. Ta, yejua niman yajqui quitemoto ne iicniu Simón Pedro huan quilito ijcuín: ―Tejuan ticajsicque ya ne Mesías ―ten quijtosnequi Cristo ne Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Huan ijcón in Andrés niman cuiyac iicniu Simón Pedro campa yetoya Jesús. Huan cuac Jesús quitac ya Pedro, ijcuacón Jesús quilij ijcuín: ―Tejua ya ti Simón, de titeconeu de Jonás, pero nejua nimitztocaytía Cefas ―ten quijtosnequi Pedro (huan no quijtosnequi tet). ");
INSERT INTO azzNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Huan ijcón ocsepa imostica Jesús quinequic yas nepa Galileajcopaca. Huan cuac yaya ya Galileajcopaca, ijcuacón cajsito in Felipe huan in Jesús quilij ijcuín: ―Tiyohue xinechtoctilijtiu huan ximomachtijtiu de Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Huan nijín Felipe pohuía campa ne pueblo de Betsaida campa no calyetoyaj in Andrés huan in Pedro. ");
INSERT INTO azzNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Huan ijcón in Felipe yajqui quitemoto ne Natanael. Huan cuac cajsic ya, ijcuacón quilij ijcuín: ―Tejuan ticajsicque ya ne tagat ten monotza Jesús. Huan nijín yejua ya in Jesús den teconeu de José den ipueblo Nazaret. Huan yejua ya nijín Jesús ten ipa Moisés techijcuilohuilijca ya tech nitajcuilolamatzin. Huan no ijcón ne huejcautanahuatiani de Dios, yejuan nojonques techijcuilohuilijteucaj ya de nijín Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Huan ijcón in Natanael quilij Felipe ijcuín: ―¿Xe timoyolilía que huelis ma acsá quisa yolcuali tech ne pueblo de Nazaret? Ijcuacón in Felipe quinanquilij ijcuín: ―Xihuiqui san huan xiquitaqui. ");
INSERT INTO azzNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Huan cuac in Jesús quitac ya que motoquijtihuitz ya in Natanael, ijcuacón Jesús quilij ijcuín: ―Nican hualajtoc se tagat ten yec melau yolcuali den pohui ihuan israelitas ne ten melau tacuautamatinemij ihuan Dios. Huan yejua ne amo cuicatinemi tech niyolo nión teyi ne tacajcayahualis. ");
INSERT INTO azzNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ijcuacón in Natanael quitajtoltij Jesús ijcuín: ―¿De can tinechonixmatic? Ijcuacón Jesús quinanquilij ijcuín: ―Nejua nimitzitac achtopa que in Felipe mitzonnotzasquía, cuac tejua tiyetoya oc tatampa de se higoscuohuit. ");
INSERT INTO azzNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ijcuacón in Natanael quilij Jesús ijcuín: ―Tamachtijque, melau tejuatzin ya ti Teconetzin de Dios, huan tejuatzin titayecanque rey den quinyolyecantinemis in pueblojuani de Israel. ");
INSERT INTO azzNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Huan Jesús quilij Natanael ijcuín: ―¿Xe tinechneltoca sayó porín nimitzilij que nimitzitac ne higoscuoutampa? Como ijcón ticneltocac de nijín ticaquico, ica ya nojón xicmati que cachi huejueyi oc mohuiscatequit de míac tataman tiquitatiu huan que nijín de ticayic ya. ");
INSERT INTO azzNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Huan no ijcón in Jesús ocsepa quilij ne Natanael ijcuín: ―Yec melau ten nimitzilía que tejua tiquitas tapoutoc in eluiyac huan tiquitas ne ángeles taquehualme de Dios tejcotosque huan hual temotosque de ne eluiyactzinco para ma nechpalehuiquihue porín Nejuatzin ni Yectagatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Huan cuac panoc ya de eyi tonal, ijcuacón mochihuac se iluitonal de ne nenamictilis campa pueblo de Caná de itatilanal ne Galileajcopaca. Huan ne inantzin Jesús no ompa yetoya. ");
INSERT INTO azzNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Huan no quinnejmachtijcaj Jesús ihuan imomachtijcahuan de que ma yacan ne campa nenamictilis. ");
INSERT INTO azzNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Huan mochihuac que cuac tacuajtoyaj ya, ijcuacón tamic ne vino. Huan inantzin Jesús quilij Jesús ijcuín: ―Amo quipíaj oc ne vino. ");
INSERT INTO azzNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ijcuacón Jesús quinanquilij inantzin ijcuín: ―Tejua nonantzin, ¿queyé ijcón tinechilía? Porín cuali ticmati que ayamo ejcoc in tonal de notequiu. ");
INSERT INTO azzNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ijcuacón inantzin quinilij in tequitini ne naquen quinxejxelojtoyaj ne vino ijcuín: ―Xicchihuacan ijcón queme Yejuatzin namechnajnahuatis. ");
INSERT INTO azzNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Huan no mochihuac que ompa yetoyaj chicuasen huejueyi soquiconme, ijcón queme ne pueblojuani judíos quicuíaj cuac quitacamatíaj ne tanahuatil de ne matequilis. Huan cada se de ne soquiconme aquía queme nahuipoal oso macuilpoal litros de at. ");
INSERT INTO azzNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ijcuacón in Jesús quinilij ne tequitini ijcuín: ―Xiquinpexontican ica at nijín soquiconme. Huan yejuan melau ijcón quichiuque quinyecpexontijque. ");
INSERT INTO azzNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Huan de ompa Jesús ocsepa quinilij ne tequitini ijcuín: ―Axcan xiquixtican tzictzin huan xicuiquilican ne naquen tayecancataxelojque de nijín iluit. Huan in tequitini ijcón quichiuque. ");
INSERT INTO azzNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Huan ijcón ne tayecancataxelojque de nenamictilis, yejua ne quitenyecoj ne at ten mocuepac ya vino, pero melau yejua amo quimatía de can hualehuac ne vino. Ta, sayó in tequitini quimatque de can cualcuicque ne vino. Huan yejuan quitacque san de can quiquixtijque ne at. Huan ijcón ne tayecancataxelojque de nenamictilis quinotzac ne teyoquich ten monamictía ya huan quilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","―Axcan nochi in tagayot achto ma motequili ya ne vino de cachi cuali. Huan de ompa cuac nochi ne naquen tanotzalme ixuitiyasque ya ica ne vino ten cuali, ijcuacón ocsepa pehuasque motequilisque ne vino ten de amo semi yec cuali. Pero tejua, titeyoquich, tiqueutoya ya den cachi cuali vino huan hasta axcan titechxelohuilijtoc. ");
INSERT INTO azzNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Huan Jesús quichihuac nijín mohuiscatequit tech ne pueblo de Caná campa itatilanal Galileajcopaca. Huan yejua ya nijín ne achtopa mohuiscatequit ten quichihuac Jesús. Huan ica nijín mohuiscatequit Jesús quinonnextilij in pueblojuani den hueyi chicahualis de nicualtziyo. Huan ijcón imomachtijcahuan taneltocacque ihuan Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Huan niman cuac motamichihuac ya ne iluit de nenamictilis, ijcuacón yajqui Jesús campa pueblo Capernaum huan no quisehuiyac inantzin huan iicnihuan huan ocsequin imomachtijcahuan. Huan ijcón ompa nochi senyetoyaj se ome eyi tonalme. ");
INSERT INTO azzNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Huan ijcón in Jesús yajqui tejcoto huan ajsito tech ne pueblo ne Jerusalén, porín ipa ejcotoya ya ne tonal de tajyohuilis iluit den pueblojuani judíos quichihuayaj. ");
INSERT INTO azzNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Huan ompa Jesús quinajsito calijtic de ne hueyi tiopan den judíos miacque naquen tanamacatoyaj ica cuacuejme huan ica ichcame huan ica palomas. Huan no quinajsito ocsequin taca tocotzyetocque, huan yejuan quinpatiliayaj in tomin den tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Huan cuac Jesús quitac que ijcón mochiutoc, ijcuacón Yejuatzin quichijchihuac se cuetaxtamalin. Ijcuacón Jesús ica quincalanquixtij de ne hueyi tiopan nochi ne tanamacani huan no ihuan nincuacuejuan huan inichcahuan. Huan nochi ica ne taca ten tominpapatani no ica calancuatamotac; huan nochi nintomin quinmoyahuilij huan quinixcuepilij ninmesajuan de nojón tanamacani. ");
INSERT INTO azzNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Huan nochi ne tanamacani de palomas Jesús quinilij ijcuín: ―Niman xiquinajchihuacan nijinques palomas tech nijín tiopan huan amo xicchiutocan ichantzin de Notajtzin Dios queme yesquía se cali campa sayó tanamacaj huan tacohuaj. ");
INSERT INTO azzNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Huan ijcón imomachtijcahuan cuac quitacque ya nochi nijín ten quichihuac Jesús, ijcuacón yejuan quelnamicque de ne Tajcuilolamatzin de Dios campa tajtoa de Jesús ijcuín: “Semi nicyolmachilía se chicaucatanejnequilis para quenín nicpalehuis niyectatalis ichantzin de Notajtzin Dios”. ");
INSERT INTO azzNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ijcuacón in tayecanani judíos quitajtoltijque Jesús ijcuín: ―¿Toni mohuiscatequit huelis titechnextilis? Porín tejuan ticnequij que xicchihuati se mohuiscatequit para ijcón ticmatisque cox melau ticpía tanahuatil de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ijcuacón in Jesús quinnanquilij ijcuín: ―Xicuejuelocan nijín tiopan huan ipan eyi tonal nejuatzin nicchijchihuati ocsepa se tiopan yancuic. ");
INSERT INTO azzNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ijcuacón in tayecanani judíos quilijque Jesús ijcuín: ―¿Queyé ijcón tiquijtoa? Ta, nijín hueyi tiopan semi huejcahuac para quitamichijchiuque nijín tepamit, achá queme omepoal huan chicuasen xihuit. Huan, ¿xe tejuatzin timoyolilía que tejua tihuelis ticchijchihuas ipan eyi tonal? ");
INSERT INTO azzNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero in Jesús Temaquixtique tajtoaya de nitacayopan huan monejnehuililtij queme se tiopan. ");
INSERT INTO azzNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ica ya nojón cuac Jesús quitalpachojcaj ya huan ipan eyi tonal ocsepa panquisac yoltoc intzalan in ánimajme, ijcuacón imomachtijcahuan ocsepa quelnamicque nojón tajtolme ten quinilijca ya Jesús. Ijcuacón yejuan imomachtijcahuan cachi oc quineltocacque in Tajcuilolamatzin huan no quineltocacque in tajtolme ten Jesús quinilijca ya ne achtopa. ");
INSERT INTO azzNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Huan cuac in Jesús yetoya ne campa pueblo de Jerusalén huan mochiutoya ne tajyohuilis iluit, ijcuacón miacque pueblojuani quineltoquilijque in chicahualis den nitocaytzin de Jesús, porín yejuan quitacque míac tataman mohuiscatequit ten quichihuac in Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Pero Jesús amo yec tacuautamatic ninuan in pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Porín Yejuatzin cuali quinyolojixmatic ya in tagayot huan melau Yejuatzin amo monequía oc ma acsá quiliani oc de quenin mohuicayaj in pueblojuani. Porín Yejuatzin ipa cuali quinyolojixmatía ya nochi in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Huan yetoya se tagat tamachile ten no catca fariseo ten monotza Nicodemo, yejua ne no catca se tayecanque den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Huan Nicodemo yajqui quinojnotzato Jesús cuac ne tapoyahuic ya, huan quilito ijcuín: ―Tamachtijque, cuali ticmatij que Dios mitzualtitanic para titechonmachtis. Huan no cuali ticmatij que amo aquen se tagat huelis quitenextis ichicahualis para quichihuas se mohuiscatequit queme tejuatzin ticchihua, tajcón amo ihuan yetica in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ijcuacón in Jesús quilij in Nicodemo ijcuín: ―Yec melau ten nimitzilía que monequi ma se yancuicayolis para ijcón huelis se cajsicamatis que Dios quimonequiltis momasoutos ica ne ihueyichicahualis tech se iyolijtic. ");
INSERT INTO azzNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ijcuacón in Nicodemo quitajtoltij Jesús ijcuín: ―Pero, ¿quenín huelis se hueyi tagat ma ocsepa yoli? ¿Xe huelis oc acsá ocsepa calaquis ijticpac den inantzin para ocsepa ijcón yolis? ");
INSERT INTO azzNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Pero in Jesús quinanquilij ijcuín: ―Yec melau ten nimitzilía ocsepa que nochi ne naquen amo yancuicayolis de italnamiquilis ica at huan ica in chicahualis den Yecticatzin Espíritu, yejua ne ijcón amo huelis calaquitiu campa Dios quinyolyecanas itaneltocacahuan ica ihueyichicahualis. ");
INSERT INTO azzNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Huan ijcón queme in talticpactetatme quiniscaltíaj ninconehuan sayó de nacat san, ma tamatican queme yejuan tamatij, no ijcón in Yecticatzin Espíritu quiniscaltía niconehuan ma tamatican queme Yejuatzin tamati, huan ma cuicacan tech niyolojuan in Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pero amo semi xictetzaucacaqui nijín ten nimitzilía que tejua semi monequi xiyancuicayoli. ");
INSERT INTO azzNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Porín in ejecat mopipitztinemi nican huan nepa campa yejua quinequi. Huan tejua ticaqui ijcoyocatinemi nican huan nepa, pero tejua amo ticmati can hualehuac in ejecat huan nión no ticmati can yohui. Huan no ijcón mochihua ica nojonques ten yancuicayolque ya ica in Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ijcuacón in Nicodemo ocsepa quitajtoltij Jesús ijcuín: ―¿Quenín huelis mochihuas nochi nijín ten ticonijtoa? ");
INSERT INTO azzNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Pero Jesús ocsepa quinanquilij ijcuín: ―¿Xe tejua amo ticajsicamati nijín ten nimitzilijtoc, porín tejua no titamachtijque ihuan in pueblojuani de Israel? ");
INSERT INTO azzNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Huan yec melau ten nimitzilía que tejuan tictenextilíaj ne ten ticyecajsicamatij. Huan tejuan no tictetapohuíaj nochi ten melau tiquitacque ya. Pero namejuan amo nanquiyecneltocaj ten tamechilíaj. ");
INSERT INTO azzNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Huan namejuan, como amo nannechneltoquilíaj in tamachtilis de nican talticpac san tenica namechnojnotztoc, ¿quenín huelis nanquineltocasque como Nejuatzin namechnojnotzasquía ica ne tanextililisme den ne eluiyactzinco? ");
INSERT INTO azzNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Huan amo aquen tejcoc nepa eluiyactzinco. Ta, sayó Nejuatzin ni Yectagatzin. Huan nejua no nihualpantemoc desde ne eluiyactzinco porín ompa Nejuatzin nipoutoc. ");
INSERT INTO azzNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Huan Moisés ne huejcautanahuatijque cajocuic ne teposcohuat tech se cuohuit campa ne taiucan. Huan ijcón queme Moisés cajocuic ne teposcohuat campa ne taseltijcan, no ijcón Nejuatzin ni Yectagatzin nechajocuisque huan nechsojsosque campa in colotzin. ");
INSERT INTO azzNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Ica ya nojón nochi naquen tacuautamatisque nohuan, yejuan nojonques amo queman ixpolihuisque oc. Ta, quipiasque ne yec nemilis sen nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Huan in Totajtzin Dios semi quintasojtac in talticpacuani. Ica ya nojón Yejuatzin cualtitanic Iyojtzin Iconetzin de Dios para ma nochi ne ten ihuantzin tacuautamatisque, yejuan nojonques ma amo ixpolihuican. Ta, ma quipiacan ne yec nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Porín Totajtzin Dios cualtitanic Yejuatzin Iconetzin de Dios nican talticpac amo para quintelchihuas in talticpacuani. Ta, para quinmaquixtis in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Huan Totajtzin Dios amo quintelchihuas nochi neques ten yec tacuautamatisque tech Yejuatzin de Iteconetzin den Totajtzin Dios. Pero nochi neques ten amo yec tacuautamatisque ihuantzin Yejuatzin, yejuan nojonques yesque tatelchihualme ya porín amo yec tacuautamatque ya tech in chicahualis de tocay de Yejuatzin Iyojtzin Iconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ica ya nojón inpan in tagayot huetziquiu hueyi tatzacuiltilis de Dios. Porín cuac Yejuatzin huala nican talticpac queme se tanextzin, ijcuacón yejuan in tagayot sayó cuelitacque in tayohuayanilot den tajtacol. Huan in tagayot quisecocauque Yejuatzin in yec tanextzin porín yejuan sayó cuelitayaj quichihuasque tachihualisme ten amo cualtía. ");
INSERT INTO azzNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Porín nochi neques ten quichiutinemij ten amo cuali, yejuan nojonques quitahuelitaj in yec tanextzin, huan amo motoquijque campa ne yec tanextzin para ma amo monextiquij in amocuali tachihualisme ten yejuan quichiutinemij. ");
INSERT INTO azzNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Pero nochi neques ten yec tachiutinemij ica ten yec melau, yejuan nojonques motoquiquij campa ne yec tanextzin para ma monextiqui senteixteno que Totajtzin Dios melau quinmacatinemij imohuiscachicahualis para ijcón quichiutinemisque ne ten cuali. ");
INSERT INTO azzNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Huan satepan in Jesús huan imomachtijcahuan yajque ne Judeajcopaca huan ompa yetotoj ihuan ne calyetoni de Judeajcopaca se ome eyi tonal. Huan ijcón ne imomachtijcahuan de Jesús quinahuijtinemíaj in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Huan no ijcón in Juan Taahuijque, yejua ne taahuijtinemía campa pueblo Enon campa amo huejca quitztoya ne pueblo Salim, porín campa ne pueblojcopaca ongaya míac ame. Ica ya nojón míac pueblojuani hualayaj campa in Juan huan yejua quinahuía. ");
INSERT INTO azzNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Huan nochi nijín quichihuac Juan achtopa ya que quitzacuasquíaj tech in cárcel. ");
INSERT INTO azzNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ijcuacón sequin imomachtijcahuan de Juan Taahuijque peuque motajtoltehuíaj ihuan sequin taca judíos ica por ne tanahuatil den huehuentzitzin de judíos de que monequi ma se momatequi achtopa que se tacuas. ");
INSERT INTO azzNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Huan ijcón imomachtijcahuan de Juan Taahuijque yajque nochi quitapohuitoj in Juan Taahuijque ijcuín: ―Tamachtijque, xiquita san ne Jesús ten mohuan yetoya ne campa sentapalpa den hueyíat de Jordán campa iquisayampa tonal. Tejuatzin, titechtapohuiaya de Yejuatzin huan axcan Yejuatzin ya taahuijtinemi nican huan míac tagayot quitoctilijtoque para ijcón momachtijtiyohue de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ijcuacón in Juan Taahuijque quinnanquilij imomachtijcahuan ijcuín: ―Amo aquen huelis quipías nión teyi tanahuatil como amo achto Dios quitayocolía ihuelilis. ");
INSERT INTO azzNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Namejuan ipa cuali nannechcaquilijque ya que nejua amo ni Cristo Temaquixtijque. Ta, sayó namechyequilij que nejua Dios nechualtitanic para ma nitayejyectaliqui achtopa que hualas Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Huan ijcón in Juan quinnextiliaya in tagayot ica nijín nexcuitil de se nenamictilis: ―Cuac ongac nenamictilis ne naquen cuica in sihuapil, yejua ne iyoquich de ne sihuapil. Huan yetoc se no tasojicniu den teyoquich ten ihuan moixmati huan yetoc inacastan huan quicactoc nochi tenica tajtojtoc ne teyoquich. Ica ya nojón ne itasojicniu semi moyolpactía cuac quicaqui que ne teyoquich tanojnotza. Huan no ijcón nejua queme yesquía ne nitetasojicniu, huan Jesús Yejuatzin ne in teyoquich ten tanojnotza. Huan nejua semi nimohueyiyolpactía porín nicaqui que ne Jesús tanojnotza. ");
INSERT INTO azzNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Porín ne Jesús Temaquixtijque semi monequi ma cachi oc mohueyichiutiu ica imohuiscatequiu. Huan nejua no semi monequi ma nimotziquitzintiltijtiu ica notequiu. ");
INSERT INTO azzNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Huan in Juan Taahuijque quintapohuía in tagayot ijcuín: ―Huan ne Jesús hual pantemoc de ne eluiyactzinco, huan Yejuatzin quinyecantinemi nochi talticpacuani. Huan nochi neques ten yolque tech nijín talticpac san, yejuan nojonques poutocque nican talticpac huan sayó tajtoaj ica tamachilisme de nican talticpac san. Pero ne Jesús hualpantemoc de ne eluiyactzinco, huan Yejuatzin ya melau quipixtinemi chicahualis inpan nochi in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Huan Yejuatzin techtapohuía nochi ten Yejuatzin quitac ya huan ten quicayic ya nepa eluiyactzinco. Pero amo aquen quineltocatoc ten Yejuatzin quitenextilía. ");
INSERT INTO azzNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Huan como acsame quineltoquilisque ten Jesús quintenextilía, yejuan nojonques ijcón motenextíaj senteixteno que Totajtzin Dios quinyequilía ten yec melau. ");
INSERT INTO azzNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Huan Totajtzin Dios cualtitanic ne Jesús huan Yejuatzin ne tajtoa sayó ica in tajtoltzitzin ten Dios quimactilij. Porín mismo Totajtzin Dios quimactilij ya Jesús nochi in chicahualis den Yecticatzin Espíritu. ");
INSERT INTO azzNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Huan Totajtzin Dios semi quiyoltasojta Iyotzin Conetzin. Ica ya nojón Totajtzin Dios quimactilij ya Jesús nochi ichicahualis huan nochi tanahuatil. ");
INSERT INTO azzNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Huan nochi neques ten tacuautamatisque ihuan ne Iconetzin Dios, yejuan nojonques quipiasque ne yec nemilis nachipa. Pero nochi ne naquen amo quinequisque yec tatacamatisque ihuan Iconetzin Dios, yejuan nojonques amo quipiasque ne yec nemilis. Ta, yejuan sayó quiselisque ne hueyi tatzacuiltilis ten Totajtzin Dios quinualtitanilis. ");
INSERT INTO azzNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Huan Jesús ipa quinyolojixmatic ne fariseos. Huan in taca tamachilejque fariseos quimatilijque que in Jesús quinpía cachi itaneltocacahuan huan que in Juan Taahuijque. Huan no quimatilijque que in Jesús quinahuía cachi míac in tagayot huan que ne Juan, ");
INSERT INTO azzNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Pero amo yec melau que in Jesús quinahuía in tagayot. Ta, taahuijtinemíaj yejuan ne imomachtijcahuan de Jesús. Huan in fariseos cajsicamatque ya que Jesús catca cachi hueyi chiuque huan que ne Juan Taahuijque. ");
INSERT INTO azzNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Huan cuac Jesús quimatic nijín, ijcuacón quistehuac de ne Judeajcopaca huan ocsepa yajqui tequitito ompa Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Huan cuac Jesús pehuac nejnemi para Galileajcopaca, ijcuacón ipa monequía panos ne campa talme ten pohuía ne Samaria. ");
INSERT INTO azzNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Huan ijcón mochihuac que Jesús ajsic ne Samariajcopaca campa se pueblo monotza Sicar, amo huejca quitztoya ne tal ten pohuía ihuan Jacob, yejua ne se huejcautat den judíos. Huan ne Jacob quimactilijca niconeu José nochi ne tal. ");
INSERT INTO azzNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Huan amo no huejca quitztoya ne amel ten pohuía ihuan in Jacob. Huan queme Jesús hualaya semi sioutihualaya tech ne ojti, ica ya nojón Yejuatzin mosehuito ne campa amelnacastan. Huan catca ipa queme nepanta ya. ");
INSERT INTO azzNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ijcuacón niman huala se sihuat ten pohuía Samariajcopaca, huan ijcón ejcoc amelteno para quiquixtis in at. Huan Jesús quilij ijcuín: ―Xinechuanti tzictzin atzin ma nitayi. ");
INSERT INTO azzNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Huan Jesús ijcón quilij porín ne imomachtijcahuan nochi yajcaj ya campa ne pueblo Samaria quicohuatoj ten quicuasque. ");
INSERT INTO azzNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ijcuacón ne sihuat ten pohuía Samariajcopaca quilij Jesús ijcuín: ―¿Queyé tejua tinechtajtanía at? Ta, tejua tipohui ihuan judíos huan nejua nipohui nican Samariajcopaca. Ijcón quijtoj in sihuat porín in judíos amo moyequitayaj ihuan pueblojuani de Samaria. ");
INSERT INTO azzNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ijcuacón Jesús quinanquilij ne sihuat ijcuín: ―Tajcón ticajsicamatisquía ne tetayocolil ten Dios mitztayocolía, huan tajcón no ticajsicamatisquía aconi Nejuatzin ten nimitztajtanilía tzictzin atzin, ijcuacón tejua yec melau tinechtajtanilisquía huan nimitztayocolisquía ne atzin ten yoltica. ");
INSERT INTO azzNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ijcuacón in sihuat quilij Jesús ijcuín: ―Notecotzin, ¿quenín ticchihuas para tiquixtis in atzin? Ta, amo ticpía tonica tiquixtis. Porín nijín amel semi huejcatan. Huan, ¿can ticuis ne atzin ten yoltica para tinechmacas? ");
INSERT INTO azzNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Porín tohuejcautat Jacob techcahuilijteu nijín amel campa yejua no tayaya in at huan campa ne atiyayaj niconehuan, huan no nitapialuan quinatiltiyayaj nican. ¿Xe cachi tejua ya tihueyichiuque huan que ne Jacob? ");
INSERT INTO azzNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Huan ijcón in Jesús ocsepa quinanquilij in sihuat ijcuín: ―Nochi neques ten tayisque nijín at, yejuan nojonques ocsepa amiquisque. ");
INSERT INTO azzNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Pero nochi neques ten tayisque ne atzin ten nejua niquinmacas, yejuan nojonques amo queman quipiasque amiquilis oc. Huan ne atzin ten nejua niquinmacas, yejua ne cocoxocatos queme yesquía se amel itech ninyolijtic. Huan ne atzin quichihualtijtos ninyolijtic in yec nemilis ten amo queman tamis. ");
INSERT INTO azzNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ijcuacón in sihuat quilij Jesús ijcuín: ―Notecotzin, nechonmaca, pues, nojón atzin para ma amo ocsepa niamiquis, huan para ma amo ocsepa nihualas oc nican niquixtiquiu in at campa nijín amel. ");
INSERT INTO azzNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Huan Jesús quilij in sihuat ijcuín: ―Xiyó xicnotzati moyoquich, huan de ompa xihualacan nican. ");
INSERT INTO azzNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ijcuacón in sihuat tananquilij ijcuín: ―Amo nicpía noyoquich. Pero ocsepa Jesús quilij ijcuín: ―Cuali queme tiquijtoa que amo ticpía moyoquich. ");
INSERT INTO azzNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Porín hasta axcan inuan tiyetoya macuil taca ten tiquinpapatac ya queme moyoquichuan. Huan yec melau ne tagat ten axcan tiyetoc ihuan, yejua ne amo moyoquich. Huan nochi nijín ten tinechiluijtoc, nochi yec melau huan amo xolopijyot san. ");
INSERT INTO azzNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Huan cuac in sihuat quicayic ya nijín tajtolme, ijcuacón yejua quilij ijcuín: ―Notecotzin, nejua nimitzita que tejua ya tipohui ihuan ne tanahuatiani de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Huan ne nohuejcautatuan de Samariajcopaca, yejuan nojonques quimohuistilijque Totajtzin Dios nican tech nijín tepet. Pero namejuan nanjudíos nanquijtoaj que sayó ompa Jerusalén campa monequi se quimohuistilis Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ijcuacón in Jesús quinanquilij ijcuín: ―Tejua, sihuat, xinechneltoquili ten nimitzilijtoc que ejcotoc ya in tonal queman namejuan nanquimohuistilisque Totajtzin Dios campa yesqui. Huan ijcón amo monequi oc nanualasque campa nijín tepet, huan amo no monequi nanyasque oc Jerusaléncopaca para nanquimohuistilisque Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Namejuan nanpueblojuani de Samaria amo nanquimatij aconi nanquimohuistilíaj. Pero tejuan tijudíos, quema, ticajsicamatij aconi ticmohuistilíaj porín ne temaquixtilis de Dios hualehuac den pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Huan melau ejcotoc ya in tonal huan melau axcan ya mochiutoc ya nijín ten nimitzilijtoc. Nochi neques ten quinequij quiyolmohuistilisque Totajtzin Dios, yejuan nojonques quimohuistilisque ica por nintalnamiquilis huan ica nochi in tamachilis ten melau. Porín Totajtzin Dios quimonequiltía ma ijcón quimohuistilican nochi in tamohuistiliani. ");
INSERT INTO azzNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Porín Totajtzin Dios Yejuatzin queme yesquía ejecat san. Huan nochi neques ten quinequisque quimohuistilisque Dios, yejuan nojonques ma quimohuistilijtiyacan Dios ica nochi ninyolojuan huan ica nintamachilis ten yec melau. ");
INSERT INTO azzNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Huan in sihuat quilij Jesús ijcuín: ―Nejua ipa nicyolmatoc que hualas ne ten monotza Mesías ―ten quijtosnequi Cristo Temaquixtijque―. Huan nicaquía que cuac Yejuatzin hualas, ijcuacón Yejuatzin ne techyecajsicamatiltis nochi tamachilisme ten techpoloa oc. ");
INSERT INTO azzNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Huan Jesús quilij ijcuín: ―Nejua ya ni Cristo Temaquixtijque ten nimitznojnotztoc axcan. ");
INSERT INTO azzNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Huan de ompa nimampa ejcocque imomachtijcahuan de Jesús, huan yejuan semi quimoucaitacque porín quitacque que Jesús monojnotztoya ihuan se sihuat de Samaria. Pero amo aquen moixehuij para quitajtoltisque Jesús ijcuín: ―¿Toni tictemohua, tejuatzin? oso, ¿queyé timonojnotztoc ihuan ne sihuat? ");
INSERT INTO azzNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ijcuacón in sihuat nimantzin quicautehuac nitzotzocol huan yajqui calaquito campa nipueblojcopaca. Huan ompa in sihuat quintapohuij in taca den tajtoanime ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","―Xihualacan xiquitaquij se tagat ten nejua nechnojnotza ya huan nechilij ya nochi ten nejua nicchiutinemic ya. ¿Xon amo Yejuatzin ya yesqui in Cristo Temaquixtijque? ");
INSERT INTO azzNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ijcuacón miacque pueblojuani quisque de ninpueblo huan yajque campa yetoya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Huan cuac yajqui ya in sihuat, ijcuacón imomachtijcahuan quitatautiayaj Jesús ijcuín: ―Tamachtijque, xicmasehua tepitzin nijín tacualis. ");
INSERT INTO azzNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Pero Jesús quinnanquilij ijcuín: ―Nejua nicpía tensá ten nicmasehuas ten namejuan amo nancajsicamatij. ");
INSERT INTO azzNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ijcuacón imomachtijcahuan peuque motatajtoltíaj se huan ocsé ijcuín: ―¿Queyé ijcón quijtoa? ¿Xe acsá cualcuilisquía tensá tacualis? ");
INSERT INTO azzNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Pero in Jesús quinilij ijcuín: ―Notacualis yejua nijín, ma nicchihua in tequit ijcón queme quimonequiltía Notajtzin Dios ten nechualtitanic. Huan ma nictamichihua in tequit ten Yejuatzin nechmactilij ya. ");
INSERT INTO azzNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Huan namejuan nanquijtoaj ijcuín: “Techpoloaj oc nahui metztica oc para ticajocuisque in tatocme”. Pero nejua namechilía que xiquitacan san, namejuan, xiyecquitacan nojón pueblojuani ten hualajtocque, yejuan nojonques niquinnejnehuililtía queme yesquía taquilome ten pehuac ya cosahui ya. Huan nojón quijtosnequi que ma amo huejcahuas oc para cajocuisque in tatocme. ");
INSERT INTO azzNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Huan nochi neques ten tequitij ca in tatocme, yejuan nojonques quiselisque taxtahuil. Huan nochi neques ten taajocuij, yejuan nojonques no quiololoaj taquilome. Huan ne taquilot quijtosnequi taca ten quipíaj ne yec nemilis ten amo queman tamis. Ica ya nojón nochi neques ten tatocasque huan nochi neques ten taajocuisque ica in tatocme, yejuan nojonques quiselitihue tataman taxtahuil huan mosepanyolpactisque. ");
INSERT INTO azzNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Porín yec melau nijín tajtol ten moijtoa ijcuín: “Naquen tatoca se taman taquehual, huan naquen taajocui ocsé taman tequitique”. ");
INSERT INTO azzNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nejuatzin namechualtitanic xictaajocuican campa namejuan amo nantatocque. Porín melau ocsequin tequitini motequitiltijque ica ne tatocalis huan axcan namejuan ya nantaajocuisque de yejuan nintequiu. ");
INSERT INTO azzNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Huan miacque pueblojyetoni de ne Samariajcopaca tacuautamatque ihuan Jesús porín ica ne tajtolme ten quinilijca ne sihuat cuac yejua quinilijca ijcuín: “Yejuatzin Jesús, yejua ne nechilij ya nochi ten nicchiutinemic ya”. ");
INSERT INTO azzNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Huan ijcón mochihuac que cuac motoquijque ne pueblojuani de Samaria campa Jesús, ijcuacón yejuan quitatautijque Jesús que ma mocahuani oc inuan. Ica ya nojón Jesús mocahuac ompa ome tonal. ");
INSERT INTO azzNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Huan ijcón cachi oc in tagayot yec tacuautamatque itech Jesús porín quicaquilijque nochi ten Yejuatzin quinmachtiaya. ");
INSERT INTO azzNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ijcuacón in pueblojuani quilijque ne sihuat ijcuín: ―Huan axcan ya tejuan ticyecneltocaj ya in tamachtilis de Jesús huan amo sayó porín tejua titechiluijca ya. Ta, no tejuan tiyecneltocaj porín ticaquilijque ya itanojnotzalis de Yejuatzin. Ica ya nojón ticyecmatij que yec melau Yejuatzin in Cristo Temaquixtijque huan Yejuatzin huala para quinmaquixtis in talticpacuani den nintajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Huan queman panoc ya ome tonal ya, ijcuacón Jesús quisac de ne Samariajcopaca huan yajqui ajsito campa Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Huan Jesús amo tequitito nepa Judeajcopaca porín ne tonal ten ne achtopa moijtoaya ijcuín: “Amo quitasojtasque se tanahuatijque de Dios tech mismo ipueblojcopaca”. ");
INSERT INTO azzNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Huan ijcón in Jesús cuac ejcoc ya campa pueblo Galilea, ijcuacón nochi in pueblojuani quiselijque Yejuatzin ica míac paquilis. Porín nochi in pueblojuani quitacque ya nochi ten quichiuca Jesús tech ne iluit de tajyohuilis, cuac yejuan yajcaj iluititoj tech ne pueblo Jerusalén. ");
INSERT INTO azzNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Huan de ompa Jesús yajqui campa pueblo Caná den itatilanal de Galilea, campa ipa ne achtopa yetoya ya, campa Jesús quichihuac ma in at ma mocuepa vino. Huan mochihuac que ompa Caná yetoya se hueyi tayecanque den rey. Huan yejua quipíaya ya se ioquichpil semi mococoaya tech in pueblo de Capernaum. ");
INSERT INTO azzNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Huan in tayecanque quimatic ya que Jesús quisac ya de Judeajcopaca huan ajsito tech in Galileajcopaca. Ijcuacón in tayecanque yajqui quitato Jesús, huan ompa quitatautito Jesús para ma yani ompa ichan itech ne pueblo den Capernaum ma quipajtiti nioquichpil ten semi tanautoya ya. ");
INSERT INTO azzNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Huan ijcón Jesús quilij in tayecanque ijcuín: ―Como amo nanquitasque tensá nescayome de Dios huan mohuiscatequit de Dios, ica ya nojón namejuan amo nantacuautamatisque de Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Pero in tayecanque quilij Jesús ijcuín: ―Notecotzin, niman xionyohui nochan achtopa que noconeu momiquilis. ");
INSERT INTO azzNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Ijcuacón Jesús quilij ijcuín: ―Niman xiyó ximocuepa mochan porín moconetzin nenquentis huan amo miquis. Huan melau ijcón in tayecanque quiyecneltoquilij ten quilij Jesús. Huan ijcón nimantzin yajqui ichan. ");
INSERT INTO azzNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Huan cuac ne tayecanque ajsitoyaya ya ichan, ijcuacón hual quisque sequin itaquehualuan huan quinamiquicoj huan quilijque ijcuín: ―Mooquichpil nenquentic ya. ");
INSERT INTO azzNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ijcuacón in tayecanque quintajtoltij itaquehualuan ijcuín: ―¿Toni hora pehuac nenquenti noconeu? Huan yejuan quilijque ijcuín: ―Yaloa queme se hora de tiotac quicahuac in totonic. ");
INSERT INTO azzNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ijcuacón in tetat tayecanque cajsicamatic que tech ne hora de yaloatica que Jesús quilijca ya ijcuín: “Moconeu nenquentiti ya”. Huan ijcón yejua tacuautamatic itech Jesús ihuan nochi ichancahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yejua ya nijín ica ome mohuiscatequit ten quichihuac Jesús campa Galileajcopaca satepan cuac quisac ya de ne Judeajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Satepan de nochi nijín ten quichihuac Jesús, mochihuac que in pueblojuani judíos iluichiuque. Ica ya nojón in Jesús ocsepa yajqui tejcoto huan ajsic campa Jerusaléncopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Huan tech ne pueblo de Jerusalén, ompa oncaya hueyi calten ten monotzaya Ichcacalten. Huan ompa no yetoya se hueyi tepan aichcual ten monotza Betesda, ten quipiaya macuilcan campa mosehuiayaj in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Huan ompa moajsíaj miacque cocoyani ompa najnacascahuetztoyaj anacastan. Huan sequin cocoyani amo huel tachiayaj, huan ocsequin coxojme, huan ocsequin ten niomiyohuan melaxtic. Huan yejuan quichixtoyaj que ma se ángel de Dios ma quioliniani in at. ");
INSERT INTO azzNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Porín queman san hualtemoaya se ángel taquehual de Dios huan yejua quijticmaneloaya in at. Huan ijcón ne naquen achtopa mopancalaquiaya tech ne at, yejua ne mocahuaya tapajtil ya, masqui catiyejua yesqui cocolis quipiasquía ne cocoxque. ");
INSERT INTO azzNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Huan ompa yetoya se tagat cuicaya sempoal huan caxtolomeyi xihuit ya de mococoaya. ");
INSERT INTO azzNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Huan cuac Jesús conitac ne cocoxque que ompa nacascahuetztoc, ijcuacón Yejuatzin niman cajsicamatic que cuicaya ya míac xihuit ya de mococoa ne cocoxque. Huan Yejuatzin quilij ijcuín: ―¿Xe tejua ticnequi tipajtis? ");
INSERT INTO azzNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Huan in cocoxque quinanquilij ijcuín: ―Amo nicpía aquen ihuan nimotasojta para yejua huelis nechpancalaquis tech nijín hueyi tepan aichcual cuac moolinía in at. Porín nachipa cuac nejua nicnequi nimopancalaquis, ijcuacón huitze ocsequin cocoyani huan niman yejuan mopancalaquíaj achtopa que nejua. ");
INSERT INTO azzNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Huan ijcón in Jesús quilij ne cocoxque ijcuín: ―Ximoquetza, huan xicuiqui mocochpet huan xinenemi. ");
INSERT INTO azzNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ijcuacón nimantzin ne tagatzin mocahuac tapajtil ya. Ica ya nojón quicuic ne icochpet huan pehuac nejnemi. Huan catca ne tonal de nesehuilis cuac pajtic ne cocoxque. ");
INSERT INTO azzNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Huan ijcón in tayecanani judíos quilijque ne tagat ten tapajtil ya ijcuín: ―Axcan tech nijín tonal de nesehuilis, ne tanahuatil de Moisés amo techcahuilía ma xicmama mocochpet. ");
INSERT INTO azzNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Huan in tagat quinnanquilij ijcuín: ―Pero yejua nechilij Yejuatzin ne naquen nechpajtij ijcuín: “Xicajocui mocochpet huan xinejnemi”. ");
INSERT INTO azzNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ijcuacón in tayecanani quitajtoltijque ijcuín: ―¿Aconi nojón mitzilij ya ijcón que xicui mocochpet huan xinejnemi? ");
INSERT INTO azzNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Pero ne cocoxque ten tapajtil ya amo quimatía aconi quipajtij, porín Jesús ipa motzinquixtij ya huan amo no quimatic porín yetoyaj míac tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Pero mochihuac que satepan Jesús ocsepa moajsic ihuan ne tagat ten mococoaya catca tech ne hueyi tiopan de judíos, huan Jesús ocsepa quilij ijcuín: ―Xiquita san, axcan cuali tipajtic ya. Pero axcan para taixpan amo ximotajtacolmaca oc, para ijcón ma amo motechuiqui oc se cocolis den cachi chicahuac. ");
INSERT INTO azzNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Huan ijcón in tagat ten tapajtil ya yajqui huan quinyequilijteu ne tayecanani judíos que yejua in Jesús ten quipajti. ");
INSERT INTO azzNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ica ya nojón ne tayecanani judíos quitepostocayaj Yejuatzin para quimictisque porín Yejuatzin quichihuaya mohuiscatequit tech in tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ijcuacón in Jesús quinilij in tayecanani judíos ijcuín: ―Notajtzin tequititihuitz hasta axcan huan Nejuatzin nitequititoc axcan masqui tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ica ya nojón in tayecanani judíos cachi oc quinequíaj quimictisque Jesús, porín Yejuatzin quichihuaya mohuiscatequit tech in tonal de nesehuilis. Huan no porín Yejuatzin monejnehuiltiaya sansé queme Totajtzin Dios, cuac quijtoaya que melau Totajtzin Dios yejua ne Itajtzin de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ijcuacón in Jesús quinilij in tayecanani ijcuín: ―Yec melau ten namechilía que Nejuatzin ni Teconetzin de Dios, huan amo huelis tensá nicchihuas de nejua notanejnequilis san. Ta, sayó nicchiutinemis ten niquitilía Notajtzin Dios quichiutinemi. Porín nochi ten quichiutinemi Notajtzin Dios, no Nejuatzin ni Iconetzin no ijcón nicchiutinemi. ");
INSERT INTO azzNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Notajtzin Dios nechtasojta Nejuatzin ni Iconetzin. Huan Notajtzin Dios nechnextilijtiu nochi in tequit ten Yejuatzin quichiutoc. Huan no nechnextilijtiyás oc ocsequin tequit den cachi huejueyi para ma ijcón namejuan cachi oc nanquimoucaitasque de notequihuan. ");
INSERT INTO azzNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Huan ijcón queme Notajtzin Dios quinpanquixtis yoltocque in ánimajme huan ocsepa quinmacas nemilis, no ijcón Nejuatzin ni Iconetzin de Dios nictemaca ne nemilis nachipa nochi neques ten Nejuatzin nicnequi niquinpalehuis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Huan Notajtzin Dios amo aquen quinixcomacas huan quintelchihuas den talticpacuani. Ta, sayó Nejuatzin ni Iconetzin de Dios nechmactilij ya nochi in chicahualis para ma nejua niquinixcomacas huan niquintelchihuas in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Huan ijcón quichihuac Notajtzin Dios para ma nochi in talticpacuani ma nechmohuistilican Nejuatzin ni Iconetzin de Dios, ijcón queme yejuan quimohuistilijtihualayaj Notajtzin Dios. Huan nochi neques ten amo quinequi nechyecmohuistilisque Nejuatzin ni Iconetzin de Dios, yejuan nojónques amo no quimohuistilijtocque Notajtzin Dios naquen nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Huan yec melau ten namechilía nochi neques ten nechyecaquilisque de notajtoltzitzin, huan no quiyecneltocasque Notajtzin Dios naquen nechualtitanic, yejuan nojonques quipiasque ne nemilis nachipa. Huan yejuan amo yesque oc tatelchihualme oc porín mopanoluilijque ya den miquilis huan ejcocque ya itech in yec nemilis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Huan yec melau ten namechilía que ejcotoc ya in hora de notequiu, huan melau axcan mochiutoc ya nican. Huan nochi naquen yolmictocque ya porín nintajtacoluan, yejuan nojonques nechcaquilisque notajtoltzin de Nejuatzin ni Iconetzin de Dios. Huan nochi neques ten nechtacamatisque, yejuan nojonques nachipa yoltinemisque. ");
INSERT INTO azzNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Huan ijcón queme Notajtzin Dios quipía imaco nochi in chicahualis para quitemacas nemilis, no ijcón Notajtzin Dios nechmactilij Nejuatzin ni Iconetzin de Dios nochi in chicahualis para que Nejuatzin no nictemacas nemilis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Huan no Notajtzin Dios nechmactilij ya in tanahuatil para ma Nejuatzin niquinixcomacas huan niquintelchihuas in talticpacuani. Huan nijín ijcón quichihuac Notajtzin Dios porín sayó Nejuatzin ni Yectagatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Huan amo xicmoucaitacan de nijín notajtolis, porín ejcos oc in tonal queman nochi in ánimajme nechcaquilisque notajtolis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Ica ya nojón cuac Nejuatzin niquinnotzas, ijcuacón noch in ánimajme hual quisasque campa ne ánimajtecochme. Huan nochi ne neques ten quichiutinenque ten cuali, yejuan nojonques hual quisasque huan quiselisque ne yec nemilis nachipa. Pero nochi ne naquen tachiutinenque ica ten amo cuali, yejuan nojonques hual quisasque huan quiselisque ne hueyi tatelchihualis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Huan ijcón in Jesús quinilij in tagayot ijcuín: ―Nejuatzin amo huelis tensá nicchihuas ica nejua notanahuatil san. Ta, ijcón queme nicaquilía que nechilijtoc Notajtzin Dios, no ijcón niquinixcomacas huan niquintelchihuas in talticpacuani. Huan notaixcomacalis sayó cuica tamachilis ten melau, porín Nejuatzin amo nictemoa que nicchiutinemi de nejua nicnectinemi san. Ta, nictemoa nicchiutinemis sayó ten quimonequiltía Notajtzin Dios naquen nechualtitanic ya. ");
INSERT INTO azzNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Huan tacán nejua san nimotajtohuisquía, ijcuacón amo teyica cualtiasquía nonetajtohuilis de nejua san. ");
INSERT INTO azzNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Pero nohuan yetica Notajtzin Dios huan Yejuatzin nechtetajtohuiltía ica por nejua namoixpan. Ica ya nojón Nejuatzin nicyecmati que ne tetajtohuilis de Yejuatzin melau cualtía. ");
INSERT INTO azzNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Huan namejuan nanquintitanque sequin taca ma quitajtoltitij in Juan Taahuijque de Nejuatzin. Huan ne Juan notetajtohuijcau, yejua quinnanquilij sayó ica ten melau. ");
INSERT INTO azzNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero Nejuatzin amo monequi nicselis ne tetajtohuilis den tagat san. Ta, sayó namechnojnotza de ne tetajtohuique de Juan para ma huelis namejuan nanquiselisque in nemaquixtilis ica por ne Juan itajtolis. ");
INSERT INTO azzNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Huan ne Juan Taahuijque catca queme yesquía se hueyi tanex ten xotaya huan tahuiaya huan namechyoltahuiliaya ica ten melau, pero namejuan sayó nanquinecque nanmoyolpactisque tech ne tanex ipan se ome eyi tonal san. ");
INSERT INTO azzNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Pero Nejuatzin nicpixtoc ocsé tetajtohuilis tenica nechtajtohuía, yejua nijín in tachihualisme ten nicchiutinemi. Huan notachihualisuan, yejuan nojonques semi cachi huejueyi tetajtohuilis huan que ne tetajtohuilis de ne Juan Taahuijque quichiutinemía por nejua. Huan in tachihualisme ten nicchiutinemi, yejuan nijinques in tachihualisme ten Notajtzin Dios nechnahuatilij ya ma nicchihua. Huan nochi nijín tachihualisme quitenextijtoc que melau Notajtzin Dios nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Huan Notajtzin Dios nechualtitanic nican talticpac huan Yejuatzin no nechtetajtohuiltía por nejua, masqui namejuan amo nanquicacque nitajtolis de Notajtzin Dios, huan nión no nanquitacque de quenín tamati Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pero itanahuatiluan de Notajtzin Dios hasta yequintzin amo huel calaquij tech namoyolojuan. Yejica amo nannechyecneltocaj de Nejuatzin huan amo no nanquineltocaj que Notajtzin Dios nechualtitanic nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Huan namejuan nanquiyectemolíaj tech in Tajcuilolamatzin de Dios ica nejmach. Huan ijcón nanquichiutinemij porín namejuan nanquichíaj que nanquiajsisque itech ne in Tajcuilolamatzin de Dios ne yec nemilis nachipa. Huan namechyequilía que ne Tajcuilolamatzin de Dios, yejua ne nechtetajtohuiltía de Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Huan namejuan amo no nanquinequij nanmotoquisque huan nanmotemactisque nohuan para huelis nanquipiasque ne yec nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Huan Nejuatzin amo nicselía ne xochitajtolis san ten tagayot quinequij nechmacasque. ");
INSERT INTO azzNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Pero Nejuatzin cuali namechyolojixmati huan Nejuatzin cuali nicyecmatoc que namejuan amo melau nanquiyoltasojtaj Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Huan Nejuatzin nihuala nican talticpac itencopaca Notajtzin Dios huan namejuan amo nannechneltoquilía que melau notajtolis. Pero tacán acsá hualasquía ten tajtojtinemi itencopaca san de yejua san, ijcuacón yejua ne namejuan nanquineltocasquíaj. ");
INSERT INTO azzNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Huan namejuan nanquitemoj san huan nanquiselíaj san de ne sayó xochitajtolis san de se huan ocsé namejuan san. Pero amo nanquitemoj huan nión no nanquiselíaj ne hueyi panchihualis ten sayó Dios huelis quitemacas. Huan queme ijcón nanquichiutinemij, pues amo huelis nanquineltocaj ne tetajtoluilis ten Yejuatzin quitemaca. ");
INSERT INTO azzNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","¡Amo xicnemilican que se tonal Nejuatzin namechteluiliti nepa iixpantzin de Notajtzin Dios! Ta, yetoc ya ne naquen namechteluiliti, huan nijín yejua in tanahuatijque Moisés, masqui namejuan nanquichíaj que nanquipiasque ne nemaquixtilis ica por ne Moisés. ");
INSERT INTO azzNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Huan tacán namejuan nanquiyecneltocasquía ne tanahuatil ten namechmactilij ne tanahuatijque Moisés, ijcuacón namejuan no nannechneltoquilisquíaj de Nejuatzin, porín ne tanahuatijque Moisés tajcuiloco de Nejuatzin nonemilispan. ");
INSERT INTO azzNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Pero como namejuan amo nanquiyecneltocaj ten Moisés quijcuiloco, ¿quenín huelis nanquineltocasque de notajtoluan ten axcan namechilijtoc? Pues, amo huelis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Huan satepan de nochi nijín ten quichihuac Jesús, ijcuacón Yejuatzin yajqui sentapalpa den hueyíat ten monotza Galilea, ten no quitocaytiayaj Tiberias. ");
INSERT INTO azzNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Huan mochihuac que míac tagayot quitoctiliayaj Jesús, porín nochi yejuan quitiliayaj ne mohuiscatequime ten Jesús quichiutinemía cuac quinpajtiaya in cocoyani. ");
INSERT INTO azzNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Huan de ompa Jesús tejcoto campa ne tepeyo huan ompa mosehuito ihuan imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Huan ne tonal motoquijtoya ya cuac ne judíos iluichihuayaj ten monotza tajyohuilis iluit. ");
INSERT INTO azzNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Huan Jesús pehuac ixnemía huan quinitac tel míac tagayot ten cualtoctiliayaj Yejuatzin. Huan in Jesús quitajtoltij Felipe ijcuín: ―¿Can huelis ticohuasque tel míac tacualis para huelis tacuasque nochi nijín tagayot? ");
INSERT INTO azzNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Huan in Jesús quijtoj ijcón para quiejecoltis in tamachilis de Felipe huan para quitas toni quijtosquía yejua. Pero Jesús ipa cuali quimatoya ya toni quichihuati nojón momento. ");
INSERT INTO azzNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ijcuacón in Felipe quinanquilij ijcuín: ―Para nochi nijín tagayot huelis quicuasque pan, amo ajsis nión ome mil pesos. Huan hasta amo quinajsisquía nión tejtepitzitzin san. ");
INSERT INTO azzNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Huan ompa yetoya Andrés, senme den imomachtijcahuan Jesús, yejua iicniu den Simón Pedro. Huan in Andrés quilij Jesús ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","―Nican yetoc se oquichpilconet ten quipía macuil pantzitzin de cebada huan ome pescadojnacat. Pero, ¿quenín ajsis nijín tacualis para nochi in tagayot? Ta, tel miacque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ijcuacón in Jesús quinilij imomachtijcahuan ijcuín: ―Namejuan xiquiniluican nochi in tagayot ma motalican. Huan oncaya míac talixco sacat campa ne yetoyaj. Huan ompa motalijque nochi in tagayot queme macuil mil taca. ");
INSERT INTO azzNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Huan ijcón in Jesús momaaquij ne pantzitzin. Huan cuac Jesús quitasojcamachilij ya Totajtzin Dios, ijcuacón quinmajmactilij ne imomachtijcahuan ne pantzitzin. Huan de ompa yejuan quinxejxelohuilijque in pantzitzin in tagayot nochi ne naquen tocotzyetoyaj ixtahua panían. Huan de ompa no ijcón quichihuac Jesús ica ne pescadojnacat. Huan ijcón quinmactilijque in tagayot nochi ten yejuan quinequíaj ica ixuisque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Huan cuac nochi in tagayot cuali ixuicque ya, ijcuacón Jesús quinilij imomachtijcahuan ijcuín: ―Xicajocuican ten mocahuac ya, para ma amo teyi ahuilihui. ");
INSERT INTO azzNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Huan ijcón imomachtijcahuan cajocuicque huan quinpexontijque ne majtactiomome chiquihuime de pancocotol ne ten mocahuac ya den ne macuil pantzitzin den cebada, ne ten mocahuac cuac ixuicque ne tagayot ten tacuajque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Huan cuac nochi in tagayot quitacque ya nijín mohuiscatequit ten quichihuac Jesús, ijcuacón yejuan quijtojque ijcuín: ―Melau Yejuatzin ya ne Jesús in Tanahuatijque de Dios ten ipa monequía hualas nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Huan Jesús cajsicamatic que in tagayot semi moijsiuhuilijtoyaj ya para quiquitzquisque Jesús huan quitayecancaquetzasque queme ninrey, masqui Yejuatzin amo quinequía. Ica ya nojón ya Jesús majchihuac de nintzalan huan yajqui campa ne tepeyo. ");
INSERT INTO azzNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Huan nepa cuac tapoyahuic ya, ijcuacón imomachtijcahuan de Jesús temocque de ne tepeyo huan ajsicque atenteno. ");
INSERT INTO azzNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Huan de ompa yejuan calacque tech ninbarco huan peuque quinejnemiltíaj ya in barco para quipanahuisque in hueyíat huan para ajsisque campa pueblo Capernaum. Huan tapoyahuic ya huan ne Jesús ayamo quinualajsía. ");
INSERT INTO azzNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ijcuacón pehuac chicaucataejecaya, huan nochi in at pehuac mocuecuentecaya huejcapan. ");
INSERT INTO azzNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Huan cuac imomachtijcahuan quinejnemiltijtoyaj ya ninbarco queme macuil oso chicuasen kilómetro aixco ya, ijcuacón yejuan quitacque Jesús que nejnentihualaya aixco huan motoquitihualaya campa ninbarco. Huan ijcón ne imomachtijcahuan de Jesús mohueyiyolmoutiayaj. ");
INSERT INTO azzNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Pero in Jesús quinilij ijcuín: ―Nejua ya ni Jesús, amo ximomoutican. ");
INSERT INTO azzNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ijcuacón ne imomachtijcahuan quihueyiyolmachilijque paquilis para quiselisque Jesús, huan quicalaquijque Yejuatzin tech in barco. Huan ijcón niman ijsiucaajsitihuetzque ica ninbarco ne atenteno campa ipa quiyolnemilijtoyaj ya ajsisque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Huan mochihuac que imostica in tagayot mocaucaj oc ne sentapalpa den hueyíat campa mochihuac ne hueyi tacualis. Huan yejuan cajsicamatque que imomachtijcahuan de Jesús ipa quisque ya ica ne barco, ne ten mocahuaya ya, porín ipa sayó yetoya ya se barco. Huan yejuan no cajsicamatque que Jesús amo inuan yajqui imomachtijcahuan. Ta, imomachtijcahuan ninselti yajque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Pero mochihuac que ejcocque ocsequin barcos ten hualayaj campa ne pueblo de Tiberias. Huan in barcos ejcocque ne atenteno amo huejca campa in tagayot quicuajque ne hueyi tacualis, cuac in Totecotzin Jesús quitasojcamachilijca in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Huan queme in tagayot quitacque ya que amo yetoya oc Jesús ompa, nión no yetoyaj oc imomachtijcahuan, ijcuacón nochi in tagayot calacque tech nojón barcos huan quisque huan yajque quipanahuijque in hueyíat huan ajsicque campa pueblo Capernaum, huan ompa quitemotoj Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Huan ijcón cuac in tagayot ajsicque ya ne sentapalpa den atenteno, ijcuacón ompa cajsicque ya in Jesús huan quitajtoltijque ijcuín: ―Tamachtijque, ¿quemanían tihuala nicahuín? ");
INSERT INTO azzNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ijcuacón in Jesús quinanquilij ijcuín: ―Yecmelau ten namechilía, que namejuan nannechtemoaj porín nantacuajque huan porín cuali nanixuicque. Huan namejuan amo nannechtemoaj porín nancajsicamatij nijín mohuiscatequit ten nicchihuac. ");
INSERT INTO azzNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Huan namechyequilía que amo ximotequitiltican san sayó ica in tacualis ten panoa san. Ta, ximotequitiltican de ica ne tacualis ten namechuejcahuas, ne tacualis ten namechmacas ne yec nemilis nachipa. Yejua nijín tacualis namechmacas Nejuatzin ni Yectagatzin, porín Notajtzin Dios tacuautamatic nohuan huan nechmacac ya nitanahuatiltzin para ica ma namechtayocoli ne nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ijcuacón in tagayot ocsepa quitajtoltijque Jesús ijcuín: ―¿Toni monequi ma ticchiutiyacan para tictacamatiyasque nochi tensá ten Totajtzin Dios quimonequiltía ma ticchihuacan? ");
INSERT INTO azzNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ijcuacón in Jesús quinnanquilij in tagayot ijcuín: ―Totajtzin Dios quimonequiltía xicchiutiyacan yejua nijín: Xitacuautamatiyacan nohuan porín sayó Totajtzin Dios Yejuatzin nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ijcuacón yejuan ocsepa quitajtoltijque Jesús ijcuín: ―¿Huan toni mohuiscatequit huelis ticchihuas tejua para titechnextilis huan para ijcón tiquitasque huan timitzneltoquilisque? ¿Toni mohuiscatequit ticchihuati? ");
INSERT INTO azzNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Huan ne tohuejcautatuan yejuan quicuajque ne tacualis ten monotza maná cuac nejnentoyaj campa ne tayiucan, ijcón queme quijtoa in Tajcuilolamatzin ijcuín: “Yejuatzin quintamacac ica tacualis ten huala de ne eluiyactzinco”. ");
INSERT INTO azzNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Huan ijcón ocsepa Jesús quinnanquilij ijcuín: ―Yec melau ten namechilía axcan que amo yejua in Moisés ne tanahuatijque ten namechtamacac ica ne tacualis ten huala de ne eluiyactzinco. Ta, Totajtzin Dios, Yejuatzin namechinmacatoc axcan ne yec melau tacualis ten hualpantemoc de ne eluiyactzinco. ");
INSERT INTO azzNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Porín Nejuatzin ya ninetacualis ten Totajtzin Dios namechmacatoc, huan Nejuatzin ya nihualtemoc de ne eluiyactzinco. Huan nimonejnehuililtía queme ne tacualis ten Dios namechmacatoc huan ne tacualis, yejua ne quitemaca yec nemilis nochi in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ijcuacón in tagayot quilijque Jesús ijcuín: ―Totecotzin, nachipa xitechonmaca pos nojón tacualis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Huan ijcón in Jesús quinnextilij ica se nexcuitil ijcuín: ―Nejuatzin ya nimonejnehuililtía queme ne tacualis ya ten quitemaca nemilis. Huan nochi naquen hualasque huan motemactisque nohuan, yejuan nojonques amo queman quimachilisque oc máyanti tech ninyolojuan. Huan no nochi naquen tacuautamatisque nohuantzinco, yejuan nojonques amo queman oc quipiasque amiquilis den nintalnamiquilis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Pero yec melau queme namechilijtinemía que namejuan amo nohuan nantacuautamatij, masqui namejuan nannechitztocque ya. ");
INSERT INTO azzNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Huan nochi notaneltocacahuan ten Totajtzin Dios nechinmactilía, yejuan nojonques hualasque huan motemactisque nohuantzin. Huan nochi naquen hualasque huan motemactisque nohuantzin, yejuan nojonques amo queman niquinmajpehuas. ");
INSERT INTO azzNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Porín Nejuatzin nihualpantemoc de ne eluiyactzinco amo para nicchihuaquiu tensá de nejua notanejnequilis san. Ta, nihuala para nicchiutinemis ten Notajtzin Dios quimonequiltía, porín Yejuatzin nechualtitanic nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Huan Notajtzin Dios nechualtitanic nican talticpac, huan Notajtzin Dios quimonequiltía ma amo senme de nijín notaneltocacahuan ma ixpolihuican, nijinques ten Yejuatzin nechinmactilij ya. Ta, Yejuatzin quimonequiltía que ma Nejuatzin niquinyolitis nochi notaneltocacahuan ma yoltinemican tech ne tacuitapan tonalme ya cuac mochihuas ya ne hueyi taixcomacalis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Huan Notajtzin Dios nechualtitanic nican talticpac huan Yejuatzin itanejnequilis que nochi naquen nechitasque Nejuatzin huan tacuautamatisque nohuantzin que ni Teconetzin de Totajtzin Dios, yejuan nojonques quiselisque ne nemilis nachipa. Huan ijcón Nejuatzin niquinpanquixtis yoltocque huan niquinmacas nemilis ne tech tacuitapan tonalme. ");
INSERT INTO azzNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ica ya nojón in tagayot judíos peuque quitejtenehuaj Jesús porín Yejuatzin quijtoaya ijcuín: “Nejuatzin ya nimonejnehuiltía queme ne tacualis ten hualtemoc de ne eluiyactzinco”. ");
INSERT INTO azzNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Huan ijcón in tagayot quijtoayaj ijcuín: ―¿Xe amo yejua nijín Jesús de niconeu José? Pues, tejuan cuali tiquinixmatij nitat huan ninantzin. ¿Quenín huelisquía techilijtoc que yejua mismo hual pantemoc ne eluiyactzinco? ");
INSERT INTO azzNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Pero in Jesús quinilij oc ocsepa ijcuín: ―Ximotacahualtican ya huan amo ximotajtoltehuijtocan oc. ");
INSERT INTO azzNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Porín amo aquen huelis ejcos huan motemactis nohuantzin como amo achto Notajtzin Dios quinualcuis, porín Yejuatzin nechualtitanic nican talticpac. Huan Nejuatzin niquinyolitis ne notaneltocacahuan huan niquinmacas ne nachipa nemilis tech ne tacuitapan tonalme cuac mochihuas ya ne hueyi taixcomacalis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Huan tech in Tajcuilolamatzin den ne huejcautanahuatijque ten quijtoco ijcuín: “Notajtzin Dios, Yejuatzin ya quinmachtijtinemis nochi in talticpacuani ica Itajtoltzin”. Ica ya nojón nochi neques ten quicaquilijque ya Notajtzin Dios huan momachtijtiyajque ya itamachilisuan, yejuan nojonques axcan hualajtocque huan motemactijtocque nohuantzin. ");
INSERT INTO azzNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Huan no namechilía que amo yec melau que acsame quitacque ya Notajtzin Dios. Ta, sayó Nejuatzin ten nihuala de Notajtzin Dios, yec melau Nejuatzin ya niquitac ya Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Yec melau ten namechilía que nochi neques ten tacuautamatiyasque nohuantzin, yejuan nojonques quipixtiyasque ne yec nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nejuatzin ya nimonejnehuililtía queme tacualis huan nictemaca nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Huan namohuejcautatuan quicuajque ne tacualis ten monotza maná cuac nejnentoyaj campa ne taiucan. Huan masqui ijcón tacuajtinenque, pero yejuan nochi momiquilijque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Pero axcan namechilijtoc que Nejuatzin nimonejnehuililtía queme ne tacualis huan nihualpantemoc de ne eluiyactzinco. Huan nochi naquen quicuasque de nijín tacualis, yejuan nojonques amo queman miquisque oc. ");
INSERT INTO azzNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Huan Nejuatzin nimonejnehuililtía queme tacualis ten yoltoc huan nihualpantemoc de ne eluiyactzinco. Huan nochi naquen quicuasque nijín tacualis, yejuan nojonques yoltinemisque sen nachipa. Huan Nejuatzin niquinmactilis in tagayot nonacayo queme yesquía tacualis. Huan ica nejua nonacayo ten nictemacas, yejica niquinmaquixtilis nintalnamiquilisuan den talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ijcuacón yejuan in tagayot judíos peuque cualanij huan motajtoltehuiayaj se huan ocsé huan quijtoayaj ijcuín: ―¿Quenín huelis nijín tagat ma techmaca ninacayo de yejua san para ma ticuasque? ");
INSERT INTO azzNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Pero Jesús quinnextilij ica nexcuitil ijcuín: ―Yec melau ten namechilía que Notajtoltzin queme yesquía nonacayo huan noesyojtzin. Huan amo huelis nanquipiasque ne nemilis nachipa como amo namejuan nanquicuasque de nijín nonacayo de Nejuatzin ni Yectagatzin, huan como amo no nantayisque de nijín noesyojtzin. ");
INSERT INTO azzNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Huan nochi neques ten momachtisque de Nejuatzin Notajtoltzin queme yesquía quicuasque nonacayotzin huan tayisque noesyotzin, yejuan nojonques quipiasque nemilis nachipa. Huan ijcón Nejuatzin niquinyolitis huan niquinmacas nemilis ocsepa tech ne tacuitapan tonalme cuac mochihuas ya ne hueyi taixcomacalis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Huan Notajtoltzin queme yesquía nonacayotzin huan yejua ne melau yec tacualis. Huan Notajtoltzin queme yesquía noesyotzin huan yejua ne melau yec tayilis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Huan Notajtoltzin queme yesquía nonacayo huan noesyotzin. Ica ya nojón nochi naquen quicuasque nonacayotzin huan nochi naquen tayisque noesyotzin, yejuan nojonques nohuantzin poutinemisque huan majsitinemisque, huan Nejuatzin inuan nimajsitinemis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Huan Notajtzin Dios, Yejuatzin nechualtitanic nican talticpac huan Yejuatzin nachipa yoltinemi huan quipixtoc imacotzinco nochi in nemilis. Huan Nejuatzin niyoltinemi porín Notajtzin Dios nechmacac nemilis. Huan no ijcón nochi neques ten motemacas ica Nejuatzin Notajtoltzin queme yesquía tacualis, yejuan nojonques no yoltinemisque ica por Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Huan namechilijtoc que Nejuatzin queme yesquía nitacualis huan nihualpantemoc de ne eluiyactzinco. Huan nijín tacualis de namechnojnotza, yejua ne amo quinehuilía ne tacualis ten monotza maná ten quicuajtinenque ne namohuejcautatuan. Porín nochi yejuan masqui quicuajque ne maná, pero momiquilijque. Pero nochi naquen quicuasque ne pantzin ten Nejuatzin nictemaca, yejuan nojonques nachipa yoltinemisque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Huan in Jesús quinmachtiaya nochi nijín tamachilisme ompa Capernaum cuac mosentiliayaj in tagayot judíos tech nintiopan. ");
INSERT INTO azzNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Huan cuac nochi quicacque ya nijín tanextililisme de Jesús, ijcuacón miacque in tagayot naquen quitoctiliayaj Jesús quijtojque ijcuín: ―Nochi nijín ten quijtoa Jesús techyolcuejmololtía. ¿Aconi huelis Yejuatzin ijcón quitacamatisque? ");
INSERT INTO azzNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Huan ijcón in Jesús niman quimatic de que yejuan imomachtijcahuan motajtoltehuijtoyaj se huan ocsé ica por Yejuatzin itajtolis. Ica ya nojón Jesús quintajtoltij ijcuín: ―¿Xe namechyolcuejmoloa nijín tanextililisme? ");
INSERT INTO azzNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Como namechyolcuejmoloa nijín notanextililis, ijcuacón, ¿toni nanquichihuasque cuac nannechitasque Nejuatzin ni Yectagatzin cuac nitejcotiyás campa ne achtopa niyetoya? ");
INSERT INTO azzNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","In Yecticatzin Espíritu, Yejuatzin no quitemaca nemilis. Pero itacayo de tagat, yejua ne amo teyi hueli quichihualtía ten cuali. Huan nochi in tajtolme tenica Nejuatzin namechnojnotztoc, yejua ne hualehuac imaco den Yecticatzin Espíritu. Huan nijín notanextililisuan, yejua ne quichihualtía ma onca ne nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero yetocque senme oc de namejuan de amo nanquiyecneltocaj nijín notanextililisuan. Huan ijcón quijtoj Jesús porín ipa quimatiaya desde ne achtopa ya de aconime amo quiyecneltocasquíaj. Huan no Jesús quimatoya ya de aconi tagat quitemactis inmaco in tayecanani para ma quimictisque. ");
INSERT INTO azzNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ica ya nojón in Jesús quijtojco ya ijcuín: ―Amo aquen huelis ejcos nohuantzin para motemactis nohuan como amo achtopa Notajtzin Dios quimonequiltía quinualcuis. ");
INSERT INTO azzNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Desde ijcuac miacque imomachtijcahuan de Jesús quicauque ya itamachtilis de Jesús huan amo ihuantzin nemíaj oc. ");
INSERT INTO azzNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ijcuacón in Jesús quintajtoltij de ne majtactionomen imomachtijcahuan ijcuín: ―¿Xe namejuan no nanquinequij nannechcahuasque de notanextililisuan? ");
INSERT INTO azzNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Pero in Pedro Simón quinanquilij ijcuín: ―Notecotzin, ¿aconi oc huelis ihuan timotoquisque para huelis techpalehuijtiyás? Ta, sayó Tejuatzin ticonpía ne tanextililisme ten cualcui ne nemilis nachipa. ");
INSERT INTO azzNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Porín tejuan timitzneltocacque ya huan ticajsicamatque ya que Tejuatzin tion Cristo Temaquixtijque, huan Tejuatzin tion Yolchipactzin, huan tion Teconetzin de Totajtzin Dios ten yoltica. ");
INSERT INTO azzNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ijcuacón in Jesús quinanquilij ijcuín: ―Cuali nanquimatij namejuan in majtactionomen que Nejuatzin namechijitac ya para ximomachtijtiyacan de Nejuatzin, masqui senme de namejuan quisaquiu queme se amocuali tagat. ");
INSERT INTO azzNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Huan ijcón Jesús tajtoaya de ne Judas den teconeu de Simón Iscariote. Porín Judas yejua ne quitemactis Jesús inmaco in tayecanani para quimictisque, masqui in Judas ipa poutinemía ihuan ne majtactionomen imomachtijcahuan de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Huan satepan de nochi nijín ten quichihuac ya Jesús, Yejuatzin nentinemía ne Galileajcopaca. Pero Yejuatzin amo quinequía nentinemis Judeajcopaca porín ompa in tayecanani judíos quinequíaj quimictisque. ");
INSERT INTO azzNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Huan ejcotihualaya ya ne iluit den tagayot judíos queman quichijchihuayaj ne xajcaltzitzin. ");
INSERT INTO azzNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ica ya nojón ne iicnihuan de Jesús quilijque ijcuín: ―Xiquisa de nican Galileajcopaca huan xiyó ne Judeajcopaca para ma ompa no ma quitacan momomachtijcahuan nochi in mohuiscatequime ten ticchuitinemi. ");
INSERT INTO azzNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Porín como se quinequi ma teixmatican ica ne ten se quichiutinemi, ijcuacón ma amo se quichtacachiutinemi san, ya que melau ticchiutinemi nijín mohuiscatequit. Pos monequis ximotenextiliti senteixteno ihuan in talticpacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Huan nión no senme de niicnihuan quineltoquilijque de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ijcuacón in Jesús quinilij iicnihuan ijcuín: ―Ayamo ejcoc ne hora cuac monequis nimotenextilis ica notequihuan. Pero namejuan cuali nanuelisque nanmotenextilisque de namotamachilis ten yesqui hora. ");
INSERT INTO azzNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Huan namejuan in talticpacuani amo huelis namechtahuelitasque. Pero Nejuatzin melau nechtahuelitaj porín niquinteluilía in talticpacuani de que amo cuali nintachihualisuan ten quichiutinemij. ");
INSERT INTO azzNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Xiyacan namejuan, nocnihuan, xiiluititij. Nejua amo niyás niiluititiu porín ayamo ejcoc ne hora cuac monequi nimotenextilis senteixteno ihuan in pueblojuani. ");
INSERT INTO azzNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Huan ijcón mochihuac que cuac Jesús nochi quintamiilij ya, ijcuacón Yejuatzin mocahuac oc ompa ne Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Huan satepan mochihuac que cuac niicnihuan de Jesús yajque ya iluititoj ne Jerusaléncopaca, ijcuacón Jesús no yajqui iluitito, masqui Yejuatzin moichtacahuiyac huan amo yajqui senteixteno. ");
INSERT INTO azzNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Huan tech ne iluit in tayecanani judíos quitemoayaj Jesús huan motajtoltiayaj ijcuín: ―¿Can nentinemi nojón tagat ten monotza Jesús? ");
INSERT INTO azzNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Huan ijcón in tagayot judíos motajtoltehuiayaj se huan ocsé ipampa de Jesús. Huan sequin quijtoayaj ijcuín: “Yejua ne se cuali tagat”. Huan ocsequin quijtoayaj ijcuín: “Yejua ne se tagat ten amo yolcuali porín sayó quincajcayautinemi in tagayot”. ");
INSERT INTO azzNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero nochi ne ten quijtoayaj in tagayot judíos, amo quichicaucaijtoayaj porín nochi yejuan quinyolmohuiliayaj ne tayecanani judíos. ");
INSERT INTO azzNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Huan ipa tajcotitiaya ya ne iluit cuac Jesús calayic tech ne tiopan den judíos huan pehuac quinmachtiaya in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Huan in tagayot judíos semi quihueyimoucaitayaj itamachtilis de Jesús huan quijtoayaj ijcuín: ―¿Quenín huelis quimatis nijín tagat de míac tataman tanextililisme? Ta, como amo cana momachtito. ");
INSERT INTO azzNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ijcuacón Yejuatzin quinnanquilij ijcuín: ―Nochi nijín notanextililisuan amo hualehuac de nejua notanemililis san. Ta, hualeutoc de Notajtzin Dios ten nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Huan nochi neques ten quinequisque quichihuasque ten Notajtzin Dios quimonequiltía, yejuan nojonques melau Dios quinajsicamatiltis de notanextililisuan. Huan ijcón yejuan quiyequitasque de que cox hualeutoc de Totajtzin Dios nijín notanextililisuan oso cox eutoc de nejua san notanemililis san. ");
INSERT INTO azzNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Porín nochi ne naquen tajtoa ica yejua itanemililis san, yejua ne ijcón quichiutinemi sayó para ma quihueyichihuacan in tagayot. Pero Nejuatzin nicchiutinemi notequiu para ma in tagayot ma quicualnextican Notajtzin Dios ten nechualtitanic. Ica ya nojón namechilía ten yec melau. Huan tech noyolo amo teyi ne tacajcayahualis. ");
INSERT INTO azzNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","¿Xe amo melau que ne tanahuatijque Moisés namechmactilij ya ne tanahuatilme de Dios? Pues quema, Moisés namechmactilij ya; pero namejuan amo nanquintacamatij nijín tanahuatilme. Huan, ¿queyé namejuan nanquinequij nannechmictisque? ");
INSERT INTO azzNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ijcuacón in tagayot quinanquilijque Jesús ijcuín: ―Tejua ticpía moyolitic se amocuali ejecat. ¿Aconi quinequi mitzmictis? ");
INSERT INTO azzNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Huan in Jesús ocsepa quinnanquilij in tagayot ijcuín: ―Huan nochi namejuan nannechueyimoucaitacque porín nicchihuac sesan mohuiscatequit tech ne tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Pero Moisés namechmactilij ya ne tanahuatil de que xiquinnescayotican tech ninacayo den oquichpilme ten quipíaj chicueyi tonal para ijcón moixnextis que yejuan pohuij ihuan Dios. Pero Moisés yejua amo quipehualtij nijín tanahuatil. Ta, yejuan nojonques nanmohuejcautatuan ijcón quichiutihuitze. Ica ya nojón namejuan nanquinnescayotijtinemij in oquichpilme masqui tech in tonal de nesehuilis. ");
INSERT INTO azzNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Huan namejuan nanquinnescayotij in oquichpilme, masqui tech in tonal de ne nesehuilis, para ijcón nanquitacamatisque ne tanahuatilme de Moisés. Huan como ijcón no namejuan nanquichiutinemij, ¿queyé namejuan nanyolcualanij nohuan porín Nejuatzin nicyecajsicapajtij ne tagat tech ne tonal de nesehuilis? ");
INSERT INTO azzNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Amo xiquinixcomacacan acsame que yejuan tajtacolejque sayó tenica nanquinitilijtinemij que yejuan quichihuaj. Ta, monequi achto namejuan xicyecajsicamatican cox cuali oso amo cuali nintachihualisuan, para ijcón huelis nanquinixcomacasque ica ten melau. ");
INSERT INTO azzNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Ijcuacón ocsequin pueblojuani ten calyetoyaj Jerusaléncopaca peuque motajtoltiayaj ijcuín: ―¿Xe amo yejua ne Jesús in tagat ten quitemojtinemij in tayecanani judíos para quimictisque? ");
INSERT INTO azzNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Xiquitacan san nepa tajtojtoc senteixteno huan amo aca teyi quilía. ¿Xe melau que in tayecanani no cajsicamatque ya que nijín tagat Jesús que yejua ya ne in Cristo Temaquixtijque? ");
INSERT INTO azzNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Pero tejuan cuali ticmatocque de can huitza nijín tagat Jesús. Ta, cuac hualas in Cristo Temaquixtijque, ijcuacón amo aquen quimatis de can hualehuas. ");
INSERT INTO azzNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Huan queman Jesús tamachtijtoya tech in tiopan de judíos, ijcuacón Yejuatzin quincaquilij ne matájtanti den calyetoni de Jerusaléncopaca. Ica ya nojón Yejuatzin quinnanquilij ijcuín: ―¿Cox melau que namejuan cuali nannechixmatij? Huan, ¿xe cuali nanquimatij de can nihuitza? Pero Nejuatzin amo nihuala nican talticpac porín Nejuatzin notanejnequilis san. Ta, nihuala porín nechualtitanic Notajtzin Dios, huan Yejuatzin Yolmelahuactzin, huan ne Notajtzin Dios namejuan amo nanquixmatij. ");
INSERT INTO azzNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Huan Nejuatzin yec melau niquixmati Notajtzin Dios porín nihuitza imaco Yejuatzin, huan Yejuatzin nechualtitanic. ");
INSERT INTO azzNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Huan ica por nijín tajtolme de Jesús ne tayecanani judíos quinequíaj quiquitzquisque Jesús queme se preso. Pero amo aquen quiajcolquitzquijtoj porín tech ne tonal ayamo ejcoc in hora cuac monequis quiquitzquisque Jesús queme preso. ");
INSERT INTO azzNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Huan cuac mochiutoc nochi nijín, ijcuacón miacque tagayot taneltocacque de Jesús huan quijtoayaj ijcuín: ―Axcan ticneltocacque ya que nijín Jesús yejua in Cristo Temaquixtijque ten hualasquía. Porín amo aquen huelis oc quichihuas cachi hueyi mohuiscatequime huan que ne chihualisme ten quichiutinemi nijín Jesús, como amo yejua in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Huan in tayecanani fariseos quincaquilijque in tagayot que motajtoltehuiayaj se huan ocsé ica por itajtolis de Jesús. Ica ya nojón in fariseos huan in tayecanani tiopixcame quinualtitanque sequin tiopan mayolme para ijcón quiquitzquisque Jesús queme preso. ");
INSERT INTO azzNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ijcuacón in Jesús quinilij in tagayot ijcuín: ―Amo huejcahuas oc namohuan niyetoti. Huan axcan ocsepa nicajsiti Notajtzin Dios ten nechualtitanic nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ijcuacón namejuan nannechtemosque huan amo nannechajsisque oc, porín namejuan amo huelis nanyasque ne campa Nejuatzin niyajtoc. ");
INSERT INTO azzNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ijcuacón in tagayot judíos peuque motatajtoltíaj se huan ocsé yejuan san ijcuín: ―¿Can quinemilía yati nijín Jesús porín quijtoa que amo huelis tiajsisque oc tejuan? ¿Xe quinemilía yati yetoti ompa intzalan in tagayot judíos ten no calyetocque ihuan in pueblojuani griegos para ompa quinmachtis ne griegos in tanahuatil de Moisés? ");
INSERT INTO azzNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Huan no motatajtoltiayaj in judíos ijcuín: ―¿Toni quijtosnequi nijín den Jesús techilij ya que nannechtemosque pero amo nannechajsisque oc, porín namejuan amo huelis nanyasque ne campa Nejuatzin niyetos? ");
INSERT INTO azzNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Huan tech ne tonal tantoya ya in iluit, yejua ne in cachi hueyi iluitonal. Huan tech ne tonal moquetzac Jesús intzalan in tagayot huan quinchicaucailij ijcuín: ―Como acsame de namejuan nanyolamiquij, ijcuacón ma xihualacan nohuan huan ma xitayican nijín atzin ten Nejuatzin namechtayocolis. ");
INSERT INTO azzNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Huan in Tajcuilolamatzin de Dios quijtoa ijcuín: “Nochi naquen yec tacuautamatisque nohuan, yejuan nojonques ninyolijtic pepexocatos huan toyautos atzin ten yoltica”. ");
INSERT INTO azzNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yejica nijín tajtolme Jesús quinequía quinajsicamatiltis que nochi neques ten quineltocasque Jesús, yejuan nojonques quiselisque tech ninyolitic in Yecticatzin Espíritu. Pero ayamo ejcoc ya in Yecticatzin Espíritu ma yetinemi intzalan in talticpacuani porín Totajtzin Dios ayamo quihueyipanchihuaya Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Huan sequin den tagayot cuac quicaquilijque ne tajtolis de Jesús, ijcuacón yejuan quijtojque ijcuín: ―Yec melau ya nijín tagat Jesús yejua ne in hueyi tanahuatijque de Dios ten no monequía hualas. ");
INSERT INTO azzNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Huan ocsequin quijtoayaj ijcuín: ―Ne Jesús melau yejua Cristo Temaquixtijque. Pero cachi oc ocsequin quijtoayaj ijcuín: ―¿Quenín huelisquía ehuasquía Cristo Temaquixtijque campa ne pueblo Galileajcopaca? ");
INSERT INTO azzNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Porín quijtoa in Tajcuilolamatzin de Dios que in Cristo Temaquixtijque monequi de que Yejuatzin yesqui teconeu den ne huejcautayecanque in rey David. Huan no monequi yolis campa ne pueblo de Belén porín ompa no yolico in rey David. ");
INSERT INTO azzNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ica ya nojón in tagayot mocualancaxejxelojque ica por nijín tajtolme de Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huan sequin mayolme quinequíaj quiquitzquisque Jesús queme preso, pero amo aquen huelic quiajcolquitzquis. ");
INSERT INTO azzNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Huan ijcón nochi in tiopan mayolme mocuepque campa ne sen oloch yetoyaj in fariseos huan in tayecanani den tiopixcame. Huan de ompa ne tayecanani quintajtoltijque in mayolme ijcuín: ―¿Queyé amo nancualicque ne Jesús? ");
INSERT INTO azzNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ijcuacón in tiopan mayolme tananquilijque ijcuín: ―Amo ticualicque porín amo queman aca ijcón ticaquilíaj se tagat queme yejua technojnotzaya. ");
INSERT INTO azzNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ijcuacón in fariseos ocsepa quintajtoltijque ijcuín: ―¿Xe namejuan no nanmoyolcajcayahuaj ica ne Jesús? ");
INSERT INTO azzNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Cuali nanquimatij que amo senme den totayecancahuan quineltoquilijque Jesús. Huan amo no senme de tejuan tifariseos no ticneltocaj ne Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Pero nochi nijín tagayot quineltocaj de Jesús porín amo quiyecajsicamatij in tanahuatil de Moisés. Ica ya nojón ne tagayot tatelchihualme san. ");
INSERT INTO azzNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Huan se tagat monotza Nicodemo no catca senme den fariseos. Yejua ne yajca quinojnotzato Jesús tech se tayohuac. Huan axcan yejua quiniluij in ocsequin fariseos huan quinilij ijcuín: ");
INSERT INTO azzNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","―Tejuan cuali ticmatij que in tanahuatil de Moisés amo techcahuilía que ma tejuan ma tictelchihuacan acsá como amo achtopa tiyasque huan tictajtoltencaquisque de toni quichihua ne tagat. Huan ijcón ticyecmatisque toni quichiutinemic. ");
INSERT INTO azzNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ijcuacón yejuan in tayecanani fariseos quinanquilijque ne Nicodemo ijcuín: ―¿Xe tejua no tipohui ne Galileajcopaca? Huan axcan para ticyecmatisque, cachi cuali xictemoliti tech in Tajcuilolamatzin de Dios huan ompa tiquitas que nión se tanahuatijque de Dios hualehuas ya de ne Galileajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Huan de ompa yajqui sejsé de nichan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Pero in Jesús yajqui tejcoto tech ne tepet ten monotza Olivos. ");
INSERT INTO azzNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Huan imostica cuac san tanesic ya, ijcuacón in Jesús ocsepa mocuepac huan yajqui calaquito campa ne hueyi tiopan den judíos. Huan de ompa nochi in tagayot motoquicoj campa Jesús. Huan Yejuatzin ompa tiopanijtic motalito huan pehuac quinmachtiaya in tagayot ica in Tajtoltzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Huan de ompa ne tanextiliani den tanahuatil de Moisés huan in fariseos, yejuan cualcuicque se sihuat campa Jesús, porín ne tayecanani cajsicaj ya ne sihuat cuac motajtacolmacatoya tech in ahuilnemilis. Huan de ompa ne tayecanani quitalitoj ne sihuat tatajcoyan de nochi ne tagayot den tiopanijtic yetoyaj. ");
INSERT INTO azzNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ijcuacón in tayecanani quilijque Jesús ijcuín: ―Tamachtijque, nijín sihuat tejuan ticajsicque ne cuac motajtacolmacatoya tech in ahuilnemilis. ");
INSERT INTO azzNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Huan in tanahuatil de Moisés technahuatilía ma tictepoxonican de nojón taman de sihuat. Pero tejua, ¿toni tiquixejecoa? ");
INSERT INTO azzNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Huan yejuan in tayecanani ijcón quijtojque porín quinequíaj quixejecoltisque itamachilisuan de Jesús, para ijcón huelisquía ica quiteluilisquíaj in Jesús ica tensá tajtacol. Ijcuacón in Jesús motomotzoj, huan pehuac tajcuiloa ica imajpil talixco. ");
INSERT INTO azzNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Pero queme in tayecanani quisentocayaj quitajtoltiayaj Jesús, ica ya nojón Jesús momelaxquetzac huan quinilij in tayecanani ijcuín: ―Aquen yesqui de namejuan ten amo quipía tajtacol, yejua ne ma achtopa ma quitepoxoni ne sihuat. ");
INSERT INTO azzNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Huan ijcón in Jesús ocsepa motomotzoj huan pehuac ocsepa tajcuiloa talixco. ");
INSERT INTO azzNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Huan in tayecanani cuac quicaquilijque nijín tajtolme de Jesús, ijcuacón yejuan no quiyolnemilijque que yejuan no tajtacolejque. Huan de ompa peuque cacalanquisaj sejsé. Achto peuque quiquisaj de ne cachi huehuentzitzin. Huan cuac nochi in tagayot tamic quisque ya, ijcuacón mocahuac sayó in Jesús iselti ihuan ne sihuat ten yetoya tatajco de yejuan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Huan in Jesús ocsepa momelaxquetzac. Pero amo aquen oc quinitac. Ta, sayó ne sihuat ten ompa yetoya. Ica ya nojón Yejuatzin quilij ijcuín: ―Tejua sihuat, ¿can yetocque ne naquen mitzteluiliayaj ya? ¿Xe amo senme de yejuan mitztelchihuac? ");
INSERT INTO azzNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ijcuacón in sihuat quilij Jesús ijcuín: ―Amo, Notecotzin, amo aquen nechtelchihuac. Ijcuacón in Jesús quilij ijcuín: ―Pues nión no nejua nimitztelchihuas. Ta, axcan xiyó mochan huan amo ocsepa ximotajtacolmacati. ");
INSERT INTO azzNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Huan cachi satepan Jesús ocsepa quinnojnotzac in tagayot huan quinmachtiaya ica nexcuitil ijcuín: ―Nejuatzin ya queme yesquía nitanextzin huan niquinyoltahuilía in talticpacuani. Huan nochi neques ten nechtoctilisque huan momachtisque de notanahuatiluan, yejuan nojonques quipiasque ne neyoltahuililis ten cualcui ne nemilis nachipa. Huan ijcón amo queman nemisque tayohuayanijtic. ");
INSERT INTO azzNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ijcuacón in tayecanani fariseos quilijque Jesús ijcuín: ―Tejua timotetajtohuiltía de tejua san. Ica ya nojón motajtoluan amo cualtías. ");
INSERT INTO azzNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Pero ocsepa Jesús quinnanquilij ijcuín: ―Nochi niquijtoa nochi cualtía, masqui nejua nimotetajtohuiltía de nejua san. Porín nejua cuali nicmati de can nihualehuac huan de can niyajtoc. Pero namejuan amo nancajsicamatij den can nihualehuac huan nión no nanquimatij can niyajtoc. ");
INSERT INTO azzNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Huan namejuan nanteixcomacatinemij sayó ica in tanemililis den tagayot san. Pero Nejuatzin amo aquen niquinixcomacas ica in tanemililis den tagayot san. ");
INSERT INTO azzNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Pero como Nejuatzin niquinixcomasquía in tagayot ica tensá, ijcuacón notaixejecolis yesqui cuali. Porín Nejuatzin amo niteixcomaca noselti san. Ta, Yejuatzin Notajtzin Dios ten nechualtitanic nican talticpac, Yejuatzin huan Nejuatzin tiquinsepanixcomacaj in tagayot. ");
INSERT INTO azzNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Huan tech ne tanahuatil de Moisés ten namejuan nanquipíaj, ompa ijcuiliutoc que cuac ome taca tetajtohuíaj sansé san, ijcuacón monequis xiquinyecneltoquilican ten quisenijtoaj. ");
INSERT INTO azzNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Huan axcan ijcón mochiutoc nican, porín Nejuatzin nimotetajtohuiltía de Nejuatzin san, huan no Notajtzin Dios nechtetajtohuiltía de Nejuatzin. Huan Notajtzin Dios nechualtitanic nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ijcuacón in fariseos ocsepa quitajtoltijque Jesús ijcuín: ―¿Can yetoc, pos, motajtzin? Ijcuacón in Jesús quinnanquilij ocsepa ijcuín: ―Namejuan amo nannechixmatij huan amo no nanquixmatij Notajtzin Dios. Porín tajcón nannechixmatisquíaj Nejuatzin, no ijcón cuali huelisquía nanquixmatisquíaj Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Huan nochi nijín tajtolme Jesús quijtoaya cuac tamachtijtoya ne tiopanijtic campa ne yetoyaj ne tomin ehualonime campa in tagayot quitemacayaj para Dios de nintetayocolil. Pero amo aquen quiquitzquijque Jesús queme preso porín ayamo ejcoc in tonal cuac monequía quiquitzquisque. ");
INSERT INTO azzNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Huan ijcón Jesús ocsepa quinilij in tagayot ijcuín: ―Nejua niyó ya huan namejuan nannechtemosque, pero amo nannechajsisque. Huan ijcón namejuan nanmiquisque huan nancuicasque oc namotajtacoluan, huan amo huelis nanajsisque campa Nejuatzin niyajtoc. ");
INSERT INTO azzNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ijcuacón in tagayot judíos motajtoltiayaj se huan ocsé ijcuín: ―¿Xe ne Jesús momictiti yejua san? Porín quijtoa ijcuín: “Que campa nejua niyás, namejuan amo huelis nanajsisque”. ");
INSERT INTO azzNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ijcuacón in Jesús quinajsicamatiltij ijcuín: ―Nochi namejuan nanpohuij nican talticpac, pero Nejuatzin nipoutoc nepa eluiyactzinco. Huan namejuan melau nantalticpacuani san, pero Nejuatzin amo nipoutoc de nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ica ya nojón namechilía que namejuan nanmiquisque huan nancuicasque oc namotajtacoluan, como amo nannechyecneltocaj que Nejuatzin ni Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ijcuacón ocsepa in tagayot judíos quitajtoltijque Jesús ijcuín: ―¿Huan tejua toni tichiuque? Pero Jesús quinnanquilij ijcuín: ―Nejua ipa namechtapohuijtihuitz ya desde ne tonal cuac nictzinpehualtij notequiu. ");
INSERT INTO azzNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nejuatzin nicpía míac taman tamachilis para ica namechilis, huan no míac taman tanahuatil nicpixtoc para ica namechixcomacas. Pero amo nicchihuati de nejua notanejnequilis san. Ta, namejuan de nantalticpacuani namechmachtijtoc de ne tamachtilis ten nicaquilij de Notajtzin Dios ten nechualtitanic nican talticpac. Huan nochi ten Yejuatzin quijtoa, nochi melau. ");
INSERT INTO azzNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pero in tagayot judíos amo cajsicamatque que Jesús quinnojnotzaya den Itajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ica ya nojón Jesús ocsepa quinilij ijcuín: ―Cuac namejuan nannechajcocuisque huan nannechcuoupampilosque Nejuatzin ni Yectagatzin, ijcuacón nancajsicamatisque que Nejuatzin ni Cristo Temaquixtijque. Huan no nancajsicamatisque que nochi ten Nejuatzin nicchiutinemi amo de nejua no tanejnequilis san. Ta, sayó niquijtojtinemi ten Notajtzin Dios nechnextilij ya. ");
INSERT INTO azzNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Huan Notajtzin Dios Yejuatzin ne nechualtitanic nican talticpac, huan Yejuatzin yetinemi nohuan. Huan Notajtzin Dios amo queman nechsencahuas noselti porín Nejuatzin nachipa nicchiutinemi sayó ne ten Yejuatzin quipactía. ");
INSERT INTO azzNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Huan cuac Jesús quitamiijtoj ya nochi nijín tajtolis, ijcuacón huel miacque tagayot quineltoquilijque de Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Huan ijcón Jesús ocsepa quinnojnotzaya in tagayot judíos ten quineltoquilijque Yejuatzin, huan Jesús quinilij ijcuín: ―Como namejuan nanquisentocaj nanquiyectacamatiyohue nochi ten namechilijtoc, ijcuacón melau nanmochihuasque nannomomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Huan ijcón nancajsicamatiyasque de ne Tajtoltzin ten yec melau. Huan ne yec melau Tajtoltzin, yejua ne namechtojtomatiu de namotajtacoluan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ijcuacón yejuan quinanquilijque Jesús ijcuín: ―Tejuan titeconehuan de ne huejcautanahuatijque Abraham huan amo queman aca techtzajtzacuiliayaj queme ne taquehualme ten tacohualme. ¿Quenín huelis tiquijtoa que tejuan techtojtontiyás de totajtacoluan ica por ne Tajtoltzin de Dios? ");
INSERT INTO azzNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Huan ijcón in Jesús quinilij ijcuín: ―Yec melau ten namechilía que nochi neques ten motajtacolmacatinemij, yejuan nojonques in tajtacol quinmajpachojtoc tech ninyolojuan huan yejuan mocahuaj queme taquehualme de ne tajtacol. ");
INSERT INTO azzNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Huan no cuali nanquimatij que se taquehual amo nachipa poutinemis ihuan ichancahuan den teco. Ta, yejua ne in teconeu den patrón, yejua ya ne melau nachipa poutos tech ne ichan huan se tonal quinyecanas ichancahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Huan queme Nejuatzin ni Conetzin de Dios namechtojtontiyás de namotajtacoluan, ijcuacón melau ixnestiu que Nejuatzin namechajchihuilitiu de ne tajtacol ten namechmajpachojtoc ya. ");
INSERT INTO azzNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Huan Jesús ocsepa quinilij ijcuín: ―Quema, cuali nicmati que namejuan nanteconehuan de ne huejcautanahuatijque Abraham, pero namejuan nanquinequij nannechmictisque, porín namejuan amo nanquinequij nanquiselisque in tajtolme ten namechilijtoc ya. ");
INSERT INTO azzNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nochi ten niquitac ya huan nochi ten nicaquic ya nepa iixpantzinco Notajtzin Dios, yejua ne ica namechnojnotztoc. Pero namejuan sayó nanquichiutinemij ten nanquicaquilijque de namotatuan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Huan in tagayot quinanquilijque Jesús ijcuín: ―Tejuan totat yejua in Abraham. Pero no Jesús quinilij ijcuín: ―Ta ijcón melau yesquía que nanteconehuan den ne Abraham, no ijcón nanquichihuasquíaj ijcón queme yejua quichihuaco. ");
INSERT INTO azzNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Huan masqui Nejuatzin namechyecnojnotztoc ya ica ten melau Tajtoltzin ten Notajtzin Dios nechnextilij ya, pero namejuan ipa nanquinequij nannechmictisque. Pero ne Abraham amo queman ijcón quichihuani. ");
INSERT INTO azzNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ta, namejuan axcan nanquichiutinemij ijcón queme namotat quichiutinemic. Ijcuacón in tagayot quilijque Jesús ijcuín: ―Tac tejuan amo sayó titeahuilcateconehuan. Ta, ticpíaj sayó se totat huan Yejuatzin ne in Totajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Pero in Jesús ocsepa quinilij ijcuín: ―Como melau yesquía namejuan namotat yejua ne Totajtzin Dios, ijcón namejuan nannechtasojtasquíaj, porín Nejuatzin nihualehuac iixpantzinco Totajtzin Dios. Huan axcan nihuala nican niyetoc namohuan, huan Nejuatzin nihuala amo sayó de notanejnequilis de nejua san. Ta, Totajtzin Dios nechualtitanic nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Queyé namejuan amo hueli nancajsicamatij ten namechilijtoc yequintzin? Pues namechilía que amo nancajsicamatij porín amo nantaxicoaj de nanquicactiyasque notajtoltzin. ");
INSERT INTO azzNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Huan namejuan namotat yejua ne in amocuali Satanás. Huan nochi namejuan nanpoutocque de yejua. Huan namejuan sayó nanquinequij nanquichiutinemisque ijcón queme yejua quinequi. Huan ne amocuali Satanás ipa temictijque desde ne tonal cuac tatzinpehuac nochi. Huan yejua amo queman quitequitiltía ten melau, huan amo queman tajtoa ica ten melau. Huan cuac yejua ne Satanás quijtoa tensá xolopijyot, ne itajtol melau hualeutoc iyolijtic ne Satanás, porín yejua sayó xolopijtijtinemi san, huan yejua ya in tetat den nochi neques ten xolopijtijtinemij. ");
INSERT INTO azzNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ica ya nojón namejuan amo nannechneltocaj huan Nejuatzin namechilijtoc ten melau. ");
INSERT INTO azzNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Huan, ¿catiyejua de namejuan huelis nannechnextilisque que nejua nimotajtacolmacac? Huan como Nejuatzin namechilijtoc ten melau, ijcuacón, ¿queyé amo nannechneltoquilíaj? ");
INSERT INTO azzNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Huan nochi neques ten yec melau poutocque ihuan Notajtzin Dios, yejuan nojonques quicaquilisque in Tajtoltzin de Notajtzin Dios. Pero queme namejuan amo nanpohuij de Dios, ica ya nojón amo nanquinequij nannechcaquilisque de Notajtoltzin. ");
INSERT INTO azzNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ijcuacón in tagayot judíos ocsepa quilijque Jesús ijcuín: ―Yec melau queme tiquijtoaj que tejua tipohui ihuan ne pueblojuani den calyetocque ne Samariajcopaca. Huan tejua no ticpía moyolijtic se amocuali ejecat. ");
INSERT INTO azzNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ijcuacón in Jesús quinnanquilij ijcuín: ―Amo nicpía noyolijtic nión se amocuali ejecat. Ta, nejua nicchiutinemi ne ten sayó para nicueyipanchihuas Notajtzin Dios. Pero namejuan sayó nannechmohuispolojtinemij. ");
INSERT INTO azzNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Huan Nejuatzin amo sayó nictemojtinemi tagayot para nechueyipanchihuasque. Ta, Notajtzin Dios Yejuatzin ne quitemojtinemi tagayot para nechueyipanchihuasque. Huan Yejuatzin ipa cuali quinixcomacas ne tagayot de amo nechueyipanchihuaj axcan. ");
INSERT INTO azzNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Huan yec melau ten namechilía Nejuatzin que nochi neques ten quiyecaquisque ten niquinilía huan quitacamatinemisque no Tajtoltzin, yejuan nojonques quipiasque ne nachipa nemilis huan amo queman miquisque. ");
INSERT INTO azzNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ijcuacón ocsepa in tagayot judíos quinanquilijque Jesús ijcuín: ―Axcan melau ticyecajsicamatij que tejua ticpía moyolijtic se amocuali ejecat. Porín ne Abrahám huan nochi ocsequin tanahuatiani de Dios momiquilijque ya. Pero tejua tiquijtoa ijcuín: “Nochi naquen quiyecaquisque huan quitacamatisque ten niquinilía, yejuan nojonques quipiasque nemilis nachipa huan amo queman miquisque oc”. ");
INSERT INTO azzNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xe tejua cachi tihueyichiuque huan que ne tohuejcautat Abrahám? Ta, yejua no momiquilij huan nochi in ocsequin tanahuatiani de Dios momiquilijque. ¿Huan toni ticnemilía que tiaconi tejua? ");
INSERT INTO azzNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Huan de ompa ocsepa in Jesús quinnanquilij ijcuín: ―Tacán nejua san nimohueyipanchihuasquía san, ijcuacón nohueyipanchihualis amo teyi cualtiasquía. Pero Notajtzin Dios Yejuatzin ne nechueyipanchiutoc axcan. Huan namejuan no nanquijtoaj que ne Notajtzin Dios que Yejuatzin no namotat. ");
INSERT INTO azzNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Huan melau que namejuan amo nanquixmatij Notajtzin Dios, pero Nejuatzin melau niquixmati Notajtzin Dios. Huan tacán nejua niquijtosquía que amo niquixmatisquía Notajtzin Dios, ijcuacón no niyesquía nixolopi san queme namejuan nanxolopijme san. Huan Nejuatzin melau nicyecajsicaixmati Notajtzin Dios huan nictacamatinemi ten Yejuatzin nechiluía ma nicchihua. ");
INSERT INTO azzNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Huan no Jesús quinilij ijcuín: ―Huan namohuejcautat Abraham, yejua ne moyolpactiaya porín quimatiaya que quitas ne tonal cuac Nejuatzin nihualas nican talticpac. Huan melau in Abrahám quitac in tonal cuac nihuala; ica ya nojón yejua semi mohueyiyolpactij. ");
INSERT INTO azzNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ijcuacón in tagayot judíos ocsepa quiluijque Jesús ijcuín: ―Tejua ayamo ticajxitía nión ya tajco ciento xihuit. ¿Quenín huelis tejua tiquijtoa que tiquitac ya ne Abraham? ");
INSERT INTO azzNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Huan in Jesús quinnanquilij ijcuín: ―Yec melau ten namechilía que achtopa que yolisquía ne Abraham, Nejuatzin ipa niyoltinemi. Porín ni Dios ten nachipa niyoltinemi. ");
INSERT INTO azzNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Huan ica por nojón tajtolme ten quijtoj Yejuatzin, ijcuacón in tagayot judíos cajocque sequi tet para quitepoxonisque Jesús. Pero Yejuatzin motaatito de yejuan huan niman quisac de ne tiopanijtic, huan de ompa panoc tatajco de nochi in tagayot huan yajqui ocseco. ");
INSERT INTO azzNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Huan se tonal cuac Jesús yajtoya ya tech se ojti, ijcuacón Yejuatzin quitac se tagat ten ipa yolic ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Huan imomachtijcahuan de Jesús quitajtoltijque Yejuatzin ijcuín: ―Totamachtijcau, ¿queyé yolic ixpojpoyot ne tagat? ¿Xe yolic ixpojpoyot porín de nintajtacol den nitatuan oso de yejua itajtacol san? ");
INSERT INTO azzNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Huan ijcón in Jesús quinilij ijcuín: ―Ne tagat amo yolic ixpojpoyot porín den itajtacol, huan nión no porín nintajtacoluan den nitatuan. Ta, cachi cuali ma tiquijtocan que ne tagat yolic ixpojpoyot para ma ijcón monexti tech ninacayo in chicaucahuelilis ten Dios huelis quichihuas. ");
INSERT INTO azzNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Porín mientras cuali tanestoc monequi ticchiutinemisque nijín tequit ten technahuatilij ya Notajtzin Dios ne naquen nechualtitanic. Pero axcan tapoyautihuitz ya huan ijcón satepan amo aquen huelis tequitis oc. ");
INSERT INTO azzNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Mientras Nejuatzin niyoltinemi nican talticpac, nejua ya queme niyesquía se tanextzin ten niquinyoltahuilía in taltipacuani. ");
INSERT INTO azzNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Huan cuac nochi nijín quintamiilij ya in tagayot, ijcuacón in Jesús talpan tachijchac, huan quichijchihuac tzictzin soquit ica ne ichijchi. Huan de ompa quiixojxilij niixtololohuan ica ne soquit ne tagat ten ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ijcuacón in Jesús quilij ne tagat ixpojpoyot ijcuín: ―Axcan nimantzin xiyó ximixamiti ne campa ne amel ten monotza Siloé. Nijín tocayit quijtosnequi Tahualtitanil. Huan ijcón ne tagat ixpojpoyot yajqui moixamito. Huan satepan cuac mocuepac ya, ijcuacón hueliaya tachíac. ");
INSERT INTO azzNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ijcuacón ne ichancahuan huan ne ten ipa neachtopa quitztinemíaj que ixpojpoyot, yejuan nojonques quijtoayaj ijcuín: ―¿Xe amo yejua nijín tagat ten motalijtinemía ojteno huan motaehuijtinemía? ");
INSERT INTO azzNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Huan sequin in tagayot quijtoayaj ijcuín: ―Quema, yejua nijín tagat ten catca ixpojpoyot. Huan cachi ocsequin quijtoayaj ijcuín: ―Amo yejua ne ten ixpojpoyot catca, pero nesi tamatisnequi que melau yejua. Huan ne tagat ten catca ixpojpoyot, yejua ne quijtoaya ijcuín: ―Quema, nejua ya niixpojpoyot nicatca. ");
INSERT INTO azzNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ijcuacón ocsepa quitajtoltijque ijcuín: ―Huan, ¿quenín mochihuac para huelic titachía? ");
INSERT INTO azzNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Huan yejua quinnanquilij ijcuín: ―Ne tagat ten monotza Jesús, yejua ne quichijchihuac tzictzin soquit huan nechixojxilij. Huan de ompa nechilij ijcuín: “Xiyó ne campa amel ten monotza Siloé huan ximixamiti”. Huan melau nejua niyajqui nimixamito huan ijcón huelic nitachíac ya. ");
INSERT INTO azzNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Huan de ompa in tagayot ocsepa quitajtoltijque in tagat ten catca ixpojpoyot ijcuín: ―¿Can yetoc nojón tagat ten mitzpajtij? Huan yejua quinanquilij ijcuín: ―Amo nicmati. ");
INSERT INTO azzNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Huan ijcón mochihuac que quihuiquilijque inixpan in tayecanani fariseos ne tagat ten catca ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Porín catca ne tonal de ne nesehuilis queman Jesús quichijchihuac in soquit huan quitachialtij ne tagat ten catca ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ica ya nojón in fariseos ocsepa quitajtoltijque in tagat den quenín huelic tachíac axcan. Huan yejua quinnanquilij ijcuín: ―Yejuatzin nechixtalilij tzictzin soquit huan nejua nimixamito huan axcan huelía nitachía ya. ");
INSERT INTO azzNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ica ya nojón senme de nojón tayecanani fariseos quijtoayaj ijcuín: ―In tagat ten quichihuac nijín tequit, yejua ne amo melau pohui ihuan Dios, porín yejua amo quitacamati in tanahuatil de ne tonal de nesehuilis. Huan ocsequin tayecanani no quijtoayaj ijcuín: ―¿Quenín huelis quichihuas se hueyi mohuiscatequit, como yejua se tajtacole huan amo quitacamatic in tanahuatil de Moisés? Huan ica por nijín tajtolme in fariseos mocualancaxejxelojque se huan ocsé. ");
INSERT INTO azzNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Huan ijcón in fariseos ocsepa quitajtoltijque ne tagat ten catca ixpojpoyot huan quilijque ijcuín: ―Huan tejua, ¿toni tiquixejecoa? ¿Aconi yesqui ne tagat ten mitztachialtij? Huan yejua quinnanquilij ijcuín: ―Nejua niquixejecoa que yejua yesqui se tanahuatijque de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero ne tayecanani judíos amo quinequíaj quineltocasque que cox melau yejua ya ne catca ixpojpoyot ten axcan huelía tachía. Ica ya nojón hasta no quinnotzque nitatuan de ne tagat ten catca ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Huan in tayecanani quintajtoltijque itatuan ijcuín: ―¿Xe nijín tagat yejua yesqui namoconeu, nijín ten namejuan nanquijtoaj que yolic ixpojpoyot? ¿Quenín axcan huelía tachía? ");
INSERT INTO azzNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ijcuacón nitatuan tananquilijque ijcuín: ―Quema, ticyecmatij que yejua nijín toconeu huan melau yolic ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Pero melau axcan amo ticmatij de quenín mochihuac de melau axcan tachía ya. Huan hasta amo no ticmatij aconi quitachialtij nijín toconeu. Pero para cachi nanquiyecmatisque, namejuan xictajtoltican yejua toconeu, porín hueyi ya huan xihue ya. Huan ijcón yejua huelis cachi namechyequilis ya ten namejuan nanquitemoaj. ");
INSERT INTO azzNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Huan ijcón ne itatuan quijtojque porín quinyolmohuiliayaj ne tayecanani judíos. Porín ipa yejuan in tayecanani motencauque ya de que quicalanquixtisque tech ne hueyi tiopan de judíos ma amo queman ocsepa calaquican nochi neques ten quineltocayaj que Jesús yejua in Cristo Temaquixtijque. ");
INSERT INTO azzNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ica ya nojón itatuan ocsepa quijtojque ijcuín: ―Xicontajtoltican yejua toconeu, porín melau xihue ya. ");
INSERT INTO azzNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ijcuacón in tayecanani judíos ocsepa quinotzque ne tagat ten ne achtopa ixpojpoyot catca huan quilijque ijcuín: ―Xitechonili sayó ten melau iixpantzinco Totajtzin Dios. Porín tejuan ticmatij que ne tagat Jesús yejua ne tajtacole san. ");
INSERT INTO azzNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ijcuacón yejua ocsepa quinanquilij ijcuín: ―Pero nejua amo nicmati cox ne Jesús tajtacole oso amo. Ta, sayó nicmati que nejua niixpojpoyot nicatca huan axcan nihueli ya nitachía. ");
INSERT INTO azzNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Huan ijcón ocsepa quiyectajtoltijque ijcuín: ―¿Quenín mitzchihuac cuac mitzpajtij? Huan, ¿quenín quichihuac yejua para mitztachíaltij? ");
INSERT INTO azzNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Huan yejua quinnanquilij ijcuín: ―¿Xe amo nanquicacque ya ten namechilij ya? Namejuan amo nanquinequij nannechcaquilisque. ¿Quenín namejuan nanquinequij ocsepa ma namechilij? ¿Xe namejuan no nanquinequij nanmochihuasque nanimomachtijcahuan de Jesús? ");
INSERT INTO azzNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ijcuacón in tayecanani peuque quihuijuicaltiayaj in tagat huan quilijque ijcuín: ―Tejua no tiimomachtijcau de ne tagat Jesús. Pero tejuan tiimomachtijcahuan de ne cachi hueyi tanahuatijque Moisés. ");
INSERT INTO azzNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Huan tejuan ticyecmatij que Totajtzin Dios technojnotzac ya ica por itencopa ne Moisés. Pero ne tagat Jesús nión no ticmatij de can cayot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ijcuacón in tagat ten catca ixpojpoyot ocsepa quinanquilij ijcuín: ―Semi nicmoucaita namotajtoluan porín namejuan amo nanquimatij de can cayot nijín tagat, pero yejua ne nechtachialtij. ");
INSERT INTO azzNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tejuan cuali ticmatij que in tajtacolejque in Totajtzin Dios amo quincaquilía. Ta, in Totajtzin Dios sayó quincaquilía ne naquen quimohuistilijtinemij huan quichiutinemij ten Dios itanejnequilis. ");
INSERT INTO azzNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Desde ne cuac hualtzinpehuac nochi, amo queman ticaquiliayaj que ma quijto acsá que quitachialtijque se tagat ten yolic ipa ixpojpoyot. ");
INSERT INTO azzNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Huan tajcón nijín tagat Jesús amo hualehuasquía imaco den Totajtzin Dios, ijcuacón yejua ne amo huelisquía teyi quichihuasquía ten cuali. ");
INSERT INTO azzNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ijcuacón in tayecanani quiluijque ijcuín: ―Tejua ya timotajtacolmacatihuitz ya desde ne tonal cuac tiyolico. ¿Cox huelis tejua titechmachtis in tanahuatil de Moisés? Huan de ompa in tayecanani quicalanquixtijque ne tagat ten catca ixpojpoyot tech ne tiopan de judíos ma amo queman calaquican ocsepa. ");
INSERT INTO azzNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Huan ijcón in Jesús quimatiltijque que quicalanquixtijque ya den tiopan den judíos ne tagat ten ixpojpoyot catca. Pero cuac Jesús ocsepa ihuan moajsic ne tagat, ijcuacón in Jesús quilij in tagat ijcuín: ―¿Xe melau tiyectacuautamatic ihuan in Yectagatzin de Dios? ");
INSERT INTO azzNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ijcuacón ne tagat quilij Jesús ijcuín: ―Notecotzin, xinechonyequilij aconi ne Yectagatzin de Dios para ma ijcón nejua ya ma niyectacuautamati ihuantzin. ");
INSERT INTO azzNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Huan ijcón in Jesús quinanquilij in tagat ijcuín: ―Tejua ipa tiquitztinemi ne Yectagatzin de Dios porín Nejuatzin ya ni Yectagatzin de Dios naquen ihuan tejua axcan timonojnotztoc ya. ");
INSERT INTO azzNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ijcuacón in tagatzin nimantzin motancuaquetzac iixpantzinco Jesús huan quimohuistilij huan quilij ijcuín: ―Quema, Notecotzin, nitacuautamati mohuantzin. ");
INSERT INTO azzNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Huan cachi satepan Jesús quinilij in tagayot ijcuín: ―Nejuatzin nihuala nican talticpac para niquinixcomacas in talticpacuani, para ijcón niquintachialtis ne naquen ixpojpoyome, huan no para ijcón ma ixpojpoyojcuican ne naquen mopohuaj que melau yejuan ya tachixtinemij. ");
INSERT INTO azzNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Pero sequin tayecanani fariseos yetoyaj ihuan Jesús. Huan cuac quicacque ya nijín tajtolme, ijcuacón yejuan quitajtoltijque Jesús ijcuín: ―¿Xe tiquijtosnequi que tejuan no tiixpojpoyome? ");
INSERT INTO azzNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Huan ijcón in Jesús quinanquilij ijcuín: ―Tajcón namejuan melau nanixpojpoyome yesquíaj, ijcuacón nejua amo huelis namechtechtisquíaj ne namotajtacoluan. Pero queme nanquijtoaj namejuan que nantachixtinemij, ica ya nojón melau namotajtacoluan yetinemi oc namohuan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Huan ijcón in Jesús quinilij in tagayot ijcuín: ―Yec melau ten namechilía que sequin amo calaquij campa ne calten de ichcat colal. Ta, tejcoj colalquetzpan san huan calaquij ocsecan. Huan yejuan nojonques tachtequini san huan tecuilíaj san ten teaxca san. ");
INSERT INTO azzNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Pero ne tagat ten calaquis campa ne calteno den ichcat colal, yejua ne in tapixque ne ten tapixtinemi ica in iichcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Huan in calten tapiaque, yejua ne quitapohua in calten para ma calaqui ne tapixque. Huan in ichcame cuali quitenixmatij itajtolis de intapixcau. Huan no in tapixque quinnotza iichcahuan sejsé ijcón queme nintocay de cada se ichcat. Huan ijcón in tapixque quinualquixtía nochi in iichcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Huan cuac ne tapixque nochi quintamihualquixtij ya nochi niichcahuan, ijcuacón yejua yohui quinyecantiu. Huan ijcón in ichcame quitoctilijtiyohue in tapixque porín cuali quitenixmatocque ya de nitajtolis. ");
INSERT INTO azzNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Huan ne ichcame amo quitoctilijtiyohue ne ocsé tagat ten amo quixmatij. Ta, yejuan quichojcholohuilíaj ne ten amo quixmatij porín amo quitenixmatij ne ten amo yec melau cuali tapixque. ");
INSERT INTO azzNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Huan ijcón in Jesús quinmachtij in tagayot ica nijín nexcuitil pero yejuan amo cajsicamatque in tamachilisme tenica in Jesús quinequía quinajsicamatiltis. ");
INSERT INTO azzNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ijcuacón in Jesús ocsepa quineyic quinajsicamatiltis in tagayot huan quinilij ijcuín: ―Yec melau ten namechilía, Nejuatzin ya queme niyesquía se calten campa calaquij in ichcame tech nincolal. ");
INSERT INTO azzNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Huan nochi ne tamachtiani ten hualajcaj tamachtijtinemicoj achtopa que nejua nihualasquía, nochi nojonques tachtequini san. Huan yejuan sayó quinequiayaj quintecuilisque ocsequin san. Pero in ichcame amo quintacamatque. ");
INSERT INTO azzNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Huan Nejuatzin queme niyesquía nicalten para in ichcat colal. Huan nochi ne taneltocani ten calaquisque campa nejua nipoutoc, yejuan nojonques quipiasque temaquixtilis. Ica ya nojón ne notaneltocacahuan nentinemisque moyecyolpactijnemisque ijcón queme se ichcat ten calaqui huan quisa de nicolal huan ijcón nachipa cajsitinemi toni quicuas. ");
INSERT INTO azzNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pero ne tachtecque sayó huitza para tachtequis huan para temictis huan no sayó para tahuejuelos san. Pero Nejuatzin nihuala nican talticpac para ma in talticpacuani ma quipiacan ne yec nemilis sen nachipa huan para ijcón ma quihueyipiacan ne yec nemilis ica yec yolpaquilis. ");
INSERT INTO azzNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nejuatzin nicualitapixque. Huan ne cuali tapixque yejua quitemacas ninemilis huan miquis para ijcón quinmaquixtis iichcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Pero ne taquehual tapixque sayó tequiti para motatanilis san, huan amo melau cuali tapixque. Porín cuac yejua quita que huitza ya in tecuani, ijcuacón ne amocuali tapixque quincautehua ne ichcame huan choloa, porín yejua amocuali tapixque. Huan no choloa porín ne ichcame amo inaxca. Ica ya nojón in tecuani quinquitzquía sequin ichcame huan in ocsequin moixcuacuamoyahua sejsecan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Huan ne amocuali tapixque choloa porín sayó tequititinemi para motatanilis san, huan porín yejua amo itequiu de quinyecpías ne ichcame. ");
INSERT INTO azzNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Nejuatzin nicualitapixque. Huan ijcón queme nejua niquinyequixmati noichcahuan, no ijcón noichcahuan nechixmatij Nejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Huan ijcón queme Nejuatzin niquixmati Notajtzin Dios, no ijcón Notajtzin Dios nechixmati. Huan nitemacas nonemilis huan nimiquis para niquinmaquixtis noichcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Huan no niquinpía ocsequin noichcahuan ten ayamo poutocque tech nijín ichcat colal. Yejuan nojonques no monequi niquinualcuis huan yejuan no quitacamatisque notajtoluan. Huan ijcón oncas sayó se sen oloch yetolis de noichcahuan huan no oncas sayó se tapixque san. ");
INSERT INTO azzNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Huan Notajtzin Dios nechtasojta porín nitemacas nonemilis huan nimiquiti para niquinmaquixtis noichcahuan. Huan satepan niyoltinemis ocsepa. ");
INSERT INTO azzNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Huan melau amo aquen huelis nechmictis como amo achtopa nictemaca nonemilis para ijcón niquinmaquixtis noichcahuan. Huan nictemaca nonemilis porín ijcón notanejnequilis de nejua san. Huan sayó Nejuatzin nicpía huelilis para nictemacas nonemilis; huan sayó Nejuatzin nicpía huelilis para ocsepa niyoltinemis. Yejua ya nijín tanahuatil nechmactilij Notajtzin Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Huan cuac in tagayot judíos quicacque nochi nijín tajtolme ten quijtoaya Jesús, ijcuacón ocsepa niman yejuan mocualancaxejxelojque. ");
INSERT INTO azzNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Huan miacque de yejuan quijtoayaj ijcuín: ―¿Queyé namejuan nanquicaquilijtocque itajtoluan de nijín Jesús? Ta, yejua nijín quipía se amocuali ejecat huan amo yec talnamiqui. ");
INSERT INTO azzNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Huan ocsequin in tagayot quijtoayaj ijcuín: ―Amo aquen se tagat ma quipía se amocuali ejecat huan ma tajto ijcón. ¿Xe no huelisquía se amocuali ejecat quitachialtisquía se tagat ten ixpojpoyot? Pues, amo huelis. ");
INSERT INTO azzNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Huan tech ne pueblo de Jerusalén in tagayot taluichiutoyaj porín quelnamiquíaj ne tonal cuac quitamichijchiuque in hueyi tiopan de judíos. ");
INSERT INTO azzNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Huan tech ne tonalme quiohuía huan taseseyaya. Huan ijcón in Jesús nejnentinemic ne tiopan caltampa, campa quitocaytíaj in caltampa de rey Salomón. ");
INSERT INTO azzNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ijcuacón in tayecanani judíos quiyehualojque Jesús huan quitajtoltijque ijcuín: ―¿Quenín ticyolnemilía de titechajsicailis ten melau? Ta, como melau tejua ya ti Cristo Temaquixtijque, semi xitechyequili ya axcan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Huan ijcón in Jesús quinnanquilij ijcuín: ―Ipa namechyequilijtihuitz ya, pero namejuan amo nanquiyecneltocaj. Nochi nomohuiscatequihuan yejuan nojonques nicchiutinemi ica in chicahualis den Notajtzin Dios. Huan ica por ne mohuiscatequime, yejuan nojonques nechtenextía que Nejuatzin ni Cristo. ");
INSERT INTO azzNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Huan namejuan melau amo nanquiyecneltocaj porín amo nanpohuij nohuan queme nannoichcahuan, ijcón queme ipa namechilijtihuitz ya. ");
INSERT INTO azzNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Huan notaneltocacahuan queme yesquía noichcahuan huan yejuan cuali nechtenixmatij ya; huan nejua no niquinixmati. Ica ya nojón yejuan nechtoctilíaj. ");
INSERT INTO azzNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Huan ijcón nejua niquinmacatinemi notaneltocacahuan ne nemilis nachipa, huan yejuan amo queman ixpolihuisque huan nión no aca huelis nechinmacuilis. ");
INSERT INTO azzNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Huan nochi notaneltocacahuan ten Notajtzin Dios nechinmactilij ya, yejuan nojonques amo aca huelis quinmacuilis Notajtzin Dios porín amo ongac ocsé cachi hueyi chiuque huan que Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Huan Nejuatzin huan Notajtzin Dios tipohuij san sesan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ijcuacón in tayecanani judíos ocsepa peuque cajocuique tet para quitepoxonisque Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Huan ijcón in Jesús quinilij ijcuín: ―Nejuatzin nicchiutihuala huan namechnextilijtihuala ya míac tataman mohuiscatequime de nanquitacque ya. Huan nochi nijín nicchiutihuala ica ichicahualis de Notajtzin Dios. Huan, ¿catiyejua senme de nijín mohuiscatequime tenica nanquinequij nannechtepoxonisque? ");
INSERT INTO azzNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ijcuacón in tayecanani judíos quinanquilijque ijcuín: ―Amo timitztepoxonisque ica por mocualitachihualisuan den ticchihuac ya. Ta, timitztepoxonisnequij porín ticuijuicaltía Totajtzin Dios ica por motajtoluan. Huan tejua no titagat san, pero no timopoutinemi tejua que no ti Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Huan ijcón in Jesús quinnanquilij ocsepa ijcuín: ―Huan tech namotanahuatil ijcuiliutoc que Totajtzin Dios quijtoaj ijcuín: “Namejuan san queme nanyesquíaj nandiosme”. ");
INSERT INTO azzNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Huan cuali nanquimatij que amo hueli se quinencajtalis in Tajtoltzin de Dios. Huan no cuali nanquimatij que in Totajtzin Dios quintocaytía queme diosme nochi neques ten quiselisque huan quitacamatisque notajtoltzin. ");
INSERT INTO azzNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Huan in Totajtzin Dios nechijitac huan nechualtitanic nican talticpac. Huan, ¿queyé namejuan nanquijtoaj que nejua nicuijuicaltía Totajtzin Dios cuac nejua niquijtoa que Nejuatzin Niteconetzin de Dios? ");
INSERT INTO azzNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Huan como amo nicchiutinemi nijín mohuiscatequime ijcón queme Notajtzin Dios quimonequiltía, ijcuacón namejuan amo xinechneltoquilican de notajtoluan. ");
INSERT INTO azzNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Pero como nicchiutinemi ten quimonequiltía Notajtzin Dios, ijcuacón namejuan cachi cuali xicneltocacan de nijín mohuiscatequit ten nanquitztocque ya, masqui namejuan amo nannechneltocaj. Pero xicneltocacan de nochi nijín ten nicchihuac para ijcón xicajsicaixmatican huan no xicyecneltocacan que Notajtzin Dios poutinemi nohuantzin huan no Nejuatzin nipoutinemi ihuantzin. ");
INSERT INTO azzNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Huan ijcón in tayecanani ocsepa quinequíaj quiquitzquisque in Jesús queme preso, pero Yejuatzin mochololtij ocsepa ninmaco. ");
INSERT INTO azzNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Huan ijcón ocsepa yajqui in Jesús ne iquisayampa in tonal den sentapalpa den hueyíat Jordán, Huan ompa ajsito campa ne Juan Taahuijque achtopa taahuijtinemía. Huan ijcón ompa Jesús mocahuac. ");
INSERT INTO azzNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Huan huel míac tagayot yayaj conitaya Jesús huan quijtoayaj ijcuín: ―Yec melau ne Juan Taahuijque amo teyi quinextico de que ma quichihua mohuiscatequime. Pero nochi ne ten Juan techiluijca de nijín tagat Jesús, nochi catca ten melau. ");
INSERT INTO azzNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Huan ijcón mochihuac que míac tagayot tacuautamatque ihuan Jesús ompa campa ne conajsíaj. ");
INSERT INTO azzNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Huan ne tonalme oncaya se tagat ten mococoaya, huan ne tagat cocoxque monotzaya Lázaro. Huan yejua pohuía tech ne pueblo de Betania campa no ipuebloj in María ten no iicniu Marta. ");
INSERT INTO azzNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Huan ne María no catca iicniu in Lázaro in cocoxque. Yejua ya ne María ten quimetzojxilij ica aceite den ne ajuiyacayot in Totecotzin Jesucristo huan quimetzuajuatzac ica itzon. ");
INSERT INTO azzNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Huan nijín ome sihuame icnime, yejuan quitanahuatilijque in Jesús ijcuín: ―Totecotzin, motasojicniu Lázaro yejua semi mohueyicocoa axcan. Huan Tejuatzin semi ticyoltasojta ne Lázaro. ");
INSERT INTO azzNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Pero queman in Totecotzin Jesús quicayic ya nijín tajtolme, ijcuacón Yejuatzin quijtoj ijcuín: ―Xicmatican que nijín cocolis amo para miquilis. Ta, sayó para ma moyectenexti in hueyi chicahualis den Totajtzin Dios. Huan no ica por nijín cocolis, ma moyectenexti de Nejuatzin nohuelilis huan ijcón ma nochi tagayot ma quitacan que melau Niteconetzin de Dios. ");
INSERT INTO azzNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Huan melau in Jesús semi ihuan motasojtaya in Marta huan iicniu María huan iicniu Lázaro. ");
INSERT INTO azzNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Huan cuac in Jesús ijcón quilijque ya de que ne itasojicniu Lázaro semi mohueyicocoaya, ijcuacón Yejuatzin mocahuac oc ocsé ome tonalme oc para ne tamachtijtoya campa yetoya. ");
INSERT INTO azzNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Huan mochihuac que cachi satepan in Jesús quinilij ne imomachtijcahuan ijcuín: ―Tiyohue ocsepa tech ne Judeajcopaca. ");
INSERT INTO azzNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Pero imomachtijcahuan quiluijque ijcuín: ―Xicaqui, Tejuatzin Totecotzin, ¿queyé ocsepa ticnequi tiyás ompa? Porín yec melau ayamo huejcahuac in tayecanani judíos ompa quinequíaj mitzmictisque ica tet. ");
INSERT INTO azzNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ijcuacón in Jesús quinnanquilij imomachtijcahuan ijcuín: ―¿Xe amo melau que in tonal quipía majtactiomome hora san? Namechilía ijcón para xicmatican que cuac se nemi tonayan, ijcuacón amo huelis se motepotamis porín ne nentinemi tonayan nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Pero como se nemi tech in tayohuayanilot, ijcuacón huelis se motepotamis porín amo ongac tenica se moyecantinemis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Pero mochihuac que cachi satepan Jesús quinilij imomachtijcahuan ijcuín: ―Huan axcan ne totasojicniu Lázaro, yejua axcan cochtoc san. Pero axcan Nejuatzin niyó niquijxititi ma ixpetani ocsepa. ");
INSERT INTO azzNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Pero queman ijcón quicacque ya nijín imomachtijcahuan, ijcuacón quilijque ijcuín: ―Totecotzin, tacán melau cochtoc san motasojicniu Lázaro, ijcuacón ocsepa ixpetanis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Huan in Jesús quinequía quinyecajsicamatiltis que ne Lázaro miquic ya. Pero imomachtijcahuan yejuan quinemiliayaj que in Jesús tajtojtoc de que Lázaro mosehuijtoc san tech in cochilis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ijcuacón in Jesús ocsepa quinyecajsicamatiltij imomachtijcahuan ijcuín: ―Yec melau, Lázaro miyic ya. ");
INSERT INTO azzNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Huan no xicmatican que semi niyolpaqui ica por namejuan porín amo niyetoya ompa ichan Lázaro cuac yejua momiquilij. Huan axcan nicchihuati tensá tenica namechtaneltoctis. Ica ya nojón yequintzin tiyohue tiquitatij ne Lázaro campa yetoc. ");
INSERT INTO azzNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Huan no yetoya ompa in Tomás den senme den imomachtijcahuan ten no monotza Dídimo, ten quijtosnequi nenetz. Huan ijcón in Tomás quinilij in ocsequin imomachtijcaicnihuan ijcuín: ―Tiyohue tejuan no para ma no timiquican no ihuan Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Huan melau ijcón ne imomachtijcahuan yajque ihuan Jesús. Huan cuac ajsicque ya tech ne pueblo de Betania, ijcuacón cajsicamatque ya que ipa quichihuac ya nahui tonal de quicalaquijque Lázaro ne campa animajtecal. ");
INSERT INTO azzNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Huan in Betania semi amo huejca motztoya ihuan ne pueblo Jerusalén, sayó queme eyi kilómetros san. ");
INSERT INTO azzNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ica ya nojón no yajque miacque tagayot judíos quicalpanotoj Marta huan ya in María para quinyojyoltalisque yejuan para ma amo cachi moyolcocojtocan ica por inicniu ten momiquilij ya. ");
INSERT INTO azzNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Huan mochihuac que cuac ne Marta quicayic ya que in Jesús ompa ejcotihuitz ya tech ninpueblo de yejuan, ijcuacón in Marta nimantzin quisac huan yajqui quinamiquito campa hualaya Yejuatzin. Pero ne iicniu María mocahuac calijtic. ");
INSERT INTO azzNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Huan cuac in Marta quinamic ya Jesús, ijcuacón yejua quilij ijcuín: ―Notecotzin, tajcón Tejuatzin tiyetosquía nican tochan, ijcuacón ne nocnitzin Lázaro amo momiquilisquía. ");
INSERT INTO azzNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Pero nejua cuali nicmati que Totajtzin Dios nochi mitzmacas ten tictajtanilis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ijcuacón in Jesús quilij in Marta ijcuín: ―Xicmati que mocnitzin ocsepa panquisas yoltoc intzalan in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ijcuacón in Marta quinanquili ijcuín: ―Quema, nejua nicmati que nocnitzin ocsepa yoltinemis tech ne tacuitapan tonalme cuac panquisasque yoltocque nochi in ánimajme. ");
INSERT INTO azzNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Pero in Jesús ocsepa cajsicamatiltij Marta ijcuín: ―Xicmatican ya que Nejuatzin niquinyolitía in ánimajme huan niquinmaca nemilis ocsepa. Huan nochi ten nohuan yec tacuautamati, yejua ne masqui momiquilis ya, pero ocsepa yoltinemis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Huan nochi neques ten yoltinemij oc axcan, huan nohuan yec tacuautamatij, yejuan nojonques amo queman momiquilisque oc. Huan, ¿xe ticyecneltoca nochi nijín ten nimitziluitoc? ");
INSERT INTO azzNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ijcuacón in Marta quinanquilij ijcuín: ―Quema, Totecotzin, nejua niyectacuautamati que Tejuatzin ya ti Cristo Temaquixtijque den Titeconetzin den Totajtzin Dios. Huan Tejuatzin ya ne titanahuatijque ten ipa monequía hualasquía nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Huan mochihuac que cachi satepan cuac quitamiilij ya ijcón, ijcuacón in Marta nimantzin yajqui quinotzato ne iicniu María. Huan yejua quichtacanotzato ijcuín: ―Tejua María, in Tamachtijque nampón yetoc ya, huan Yejuatzin mitzualtanahuatilía que xiyó. ");
INSERT INTO azzNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Huan ijcón cuac in María quicayic ya nijín tajtol, ijcuacón nimantzin moquetztiquisac huan yajqui quitato Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Huan in Jesús ayamo yec ajsía tech ne pueblo Betania. Ta, Yejuatzin yetoya oc hasta ne campa monamiquito ihuan ne Marta. ");
INSERT INTO azzNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Huan míac tagayot judíos yetoyaj ne calijtic ichan María ten ipa hualajcaj para quiyojyoltalisque in María. Pero cuac in tagayot quitacque que in María nimantzin moquetztiquisac huan calan quistiquisac ica ne ijsiucayot, ijcuacón yejuan no nimantzin calanquisque huan yajqui quitoctilijque María. Porín yejuan quiyolnemiliayaj que xa yohui ya María nepa campa animajtecal para ompa mochoctis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Huan ijcón mochihuac queman in María ajsito ya campa ne Jesús yetoya, ijcuacón yejua nimantzin motancuaquetzac iixpantzinco Yejuatzin huan quiliaya ijcuín: ―Notecotzin, tajcón Tejuatzin tionyetosquía nican tochanpa, ijcuacón ne nocnitzin Lázaro amo momiquilisquía. ");
INSERT INTO azzNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Huan cuac in Jesús quitac que in María semi mochoctía huan no quitac que in tagayot ten cualtoctiliayaj que no yejuan mochojchoctijtihuitze, ijcuacón Yejuatzin no yoltajyohuiaya huan moyoltayocoltiaya. ");
INSERT INTO azzNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Huan in Jesús quintajtoltij in tagayot ijcuín: ―¿Can nanquinalcalaquitoj in Lázaro? Huan yejuan quinanquilijque ijcuín: ―Totecotzin, xionuiqui huan xiquitaqui campa yetoc. ");
INSERT INTO azzNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Huan ijcón in Jesús no ompa pehuac mochojchoctía. ");
INSERT INTO azzNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ica ya nojón in tagayot judíos quijtoayaj ijcuín: ―Xiquitacan san, que melau Jesús semi quitasojtaya me Lázaro. ");
INSERT INTO azzNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Huan ocsequin tagayot no quijtoayaj ijcuín: ―Yejua ya ne Jesús quitachialtij ne ixpojpoyot. Huan, ¿queyé amo no huelic quichihuac que ma amo momiquiliani ne Lázaro? ");
INSERT INTO azzNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Huan ijcón in Jesús cachi oc moyoltayocoltiaya cuac motoquij ne campa quinalcalaquijque in Lázaro. Pero ne campa quinalcalaquijcaj in Lázaro catca tech se hueyi tecal ten quitentzacque ica se hueyi patahuactet. ");
INSERT INTO azzNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Huan in Jesús quinilij ijcuín: ―Xicajchihuacan ne tet, in hueyi patahuactet. Ijcuacón in Marta yejua iicniu ten difuntito quilij ijcuín: ―Xiquita, Notecotzin, achá semi tzojyac ya porín quipiaya nahui tonal ya de momiquilij. ");
INSERT INTO azzNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Pero ocsepa in Jesús quilij in Marta ijcuín: ―¿Xe amo nimitzilij ya que como tiyectacuautamati nohuan, ijcón tiquitas imohuiscahuelilis den Notajtzin Dios? ");
INSERT INTO azzNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ijcuacón quiajchiuque ne hueyi patahuactet huan de ompa Jesús nimantzin ajcotachía ne eluiyac huan quijtoj ijcuín: ―Nohueyijtatzin Dios, nimitzontasojcamachilía porín Tejuatzin nachipa tinechoncaquilía nonetatatautilis. ");
INSERT INTO azzNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nejuatzin cuali nicmatic que Tejuatzin ipa cuali tinechoncaquic, pero nimotatautía sayó para ma quicaquican nijín tagayot ten nican yetocque. Huan ijcón huelis quineltocasque que Tejuatzin tinechualtitanic nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Huan ijcón mochihuac que cuac quitamiijtoj ya nijín tajtolme, ijcuacón Jesús quichicaucatzajtzilij in Lázaro ijcuín: ―Tejua Lázaro, xihualcalanquisa de nampón. ");
INSERT INTO azzNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ijcuacón nimantzin in Lázaro ten micca ya hual calanquisac, nochi matzijtzicautoc huan metztzijtzicautoc ica tilma, huan no ixtzactoya ya ica se tilma. Huan de ompa Jesús quinilij in tagayot ijcuín: ―Axcan xictojtomilican nochi ne tilma huan xicahuacan ma nenemi. ");
INSERT INTO azzNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Huan ijcón mochihuac que míac tagayot judíos neques ten quisehualcuiyaj in María, yejuan nojonques no yec tacuautamatque ihuan in Jesús, porín quitacque nochi ne mohuiscatequime ten quichihuac Yejuatzin. ");
INSERT INTO azzNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Pero cachi ocsequin tagayot judíos yajque quinitatoj in tayecanani fariseos huan yejuan nochi quintapohuijque nochi ne ten Jesús quichihuac ya. ");
INSERT INTO azzNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ijcuacón in tayecanani fariseos huan ne tayecanani tiopixcame, nochi yejuan mosentilijque ihuan ne tayecanani huehuentzitzin den pueblojuani judíos. Huan yejuan moyoliliayaj ijcuín: ―Huan axcan, ¿toni ticchihuasque? Porín nijín tagat Jesús quichiutinemi míac mohuiscatequime. ");
INSERT INTO azzNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Porín tajcón ticahuaj nijín tagat Jesús ma tachiutinemi ica míac taman, ijcuacón nochi in tagayot tacuautamatisque ihuan. Ica ya nojón ne tequihuani romanos yejuan hualasque huan quixijxitinisque nijín tomohuiscatiopan huan ijcón techcuilisque totanahuatil huan no techcuilisque nochi totaluan ten pohui ihuan in pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Pero senme de yejuan no ompa yetoya ten monotzaya Caifás, yejua ne catca tayecanque de tiopixcame tech ne xihuit. Huan Caifás quinilij in ocsequin tayecanani ijcuín: ―Xicmatican que namejuan amo teyi nanquimatij. ");
INSERT INTO azzNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Huan namejuan amo no nancajsicamatij que semi monequi para tejuan ma miqui se tagat para ijcón techpalehuis tejuan tipueblojuani de Israel. Porín como amo ijcón mochihuas, ijcuacón hualasque ne tequihuani romanos huan techtamiijtacohuilisque nijín topueblo. ");
INSERT INTO azzNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Huan ne tayecanque Caifás ten tajtoj, amo yejua itanemililis san ten quijtoj. Ta, yejua ijcón quijtoj porín catca tayecanque tiopixcat tech ne xihuit, huan porín Dios quitanemililtij ijcón. Ica ya nojón in Caifás quijtoj que Jesús yejua miquis para quinmaquixtis in pueblojuani judíos. ");
INSERT INTO azzNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Huan Jesús quinmaquixtis amo sayó nijín pueblojuani judíos. Ta, no miquis Jesús para quinsentilis nochi iconehuan den Totajtzin Dios ten ixcuamoyautocque nican talticpac. ");
INSERT INTO azzNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Huan ijcón mochihuac que desde ne tonal in tequitini judíos peuque moixejecoltiayaj para quenín quimictisque in Jesús. ");
INSERT INTO azzNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ica ya nojón in Jesús amo nentinemía senteixteno intzalan in tayecanani judíos. Ta, quisac tech ne pueblojcopaca de Judea huan yajqui ajsito campa taiucan, amo huejca quitztoya se pueblo ten monotzaya Efraín. Huan ijcón Yejuatzin ompa mocautinemía inuan imomachtijcahuan. ");
INSERT INTO azzNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Huan amo huejcahuaya oc para pehuasquía ne tajyohuilis iluit ten quichihuayaj in tagayot judíos. Ijcuacón míac tagayot tejcotiyajque tech ne pueblo Jeruselén nochi in puebloyetoni ten quiyehualojtoyaj ne Jerusaléncopaca. Huan ijcón nochi ne taca ten hualajque, yejuan nojonques mochipahuacoj den nintajtacoluan achtopa que pehuas ne tajyohuilis iluit. ");
INSERT INTO azzNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Huan no miacque tagayot quitemojtinemíaj Jesús. Huan cuac yejuan yetoyaj ya ne tiopanijtic, ijcuacón motajtoltíayaj se huan ocsé ijcuín: ―¿Toni nanquinemilíaj? ¿Xe nanquinemilíaj que hualas ne Jesús tech nijín toiluitonal oso amo hualas? ");
INSERT INTO azzNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Huan ne tayecanani fariseos huan in tayecanani tiopixcame, yejuan ipa tanahuatijcaj ya ijcuín: “Como acsá quimatisquía can yetoc Jesús, que ma quiniliani in tayecanani para yejuan huelis quiquitzquisque Jes