﻿USE sofia;
DROP TABLE IF EXISTS sofia.azgNT_vpl;
CREATE TABLE azgNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES azgNT_vpl WRITE;
INSERT INTO azgNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ndö lista nguee nnꞌan tsjan na tui Jesucristo. Condui jon tsjan David na jndyocahanꞌ ndoꞌ mantyi ntyja ꞌnaanꞌ Abraham. ");
INSERT INTO azgNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham jnda jon Isaac, Isaac jnda jon Jacob, ndoꞌ Jacob jnda jon Judá yo ntyje tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juu Judá scuuꞌ jon jndyu Tamar. Ndahin jndyu Fares yo Zara. Ndoꞌ juu Fares jnda jon Esrom, ndoꞌ Esrom jnda jon Aram. ");
INSERT INTO azgNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ndoꞌ Aram jnda jon Aminadab, ndoꞌ Aminadab jnda jon Naasón, ndoꞌ Naasón jnda jon Salmón. ");
INSERT INTO azgNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ndoꞌ Salmón scuuꞌ jon jndyu Rahab. Ndahin jndyu Booz, ndoꞌ Booz scuuꞌ jon jndyu Rut. Ndahin Obed, ndoꞌ Obed jnda jon Isaí. ");
INSERT INTO azgNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ndoꞌ Isaí jnda jon David, tsan na taquintyja tocoꞌxen. Ndoꞌ David tyꞌoon jon scuuꞌ tsoUrías, ndahin Salomón. ");
INSERT INTO azgNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ndoꞌ Salomón jnda jon Roboam, ndoꞌ Roboam jnda jon Abías, ndoꞌ Abías jnda jon Asa. ");
INSERT INTO azgNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ndoꞌ Asa jnda jon Josafat, ndoꞌ Josafat jnda jon Joram, ndoꞌ Joram jnda jon Uzías. ");
INSERT INTO azgNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ndoꞌ Uzías jnda jon Jotam, ndoꞌ Jotam jnda jon Acaz, ndoꞌ Acaz jnda jon Ezequías. ");
INSERT INTO azgNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ndoꞌ Ezequías jnda jon Manasés, ndoꞌ Manasés jnda jon Amón, ndoꞌ Amón jnda jon Josías. ");
INSERT INTO azgNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Ndoꞌ Josías jnda jon Jeconías yo ntyje tsanꞌñeen. Tomꞌan joohin xjen na nque nnꞌan tsjoon Babilonia tyechohan nnꞌan Israel ndyuaahan chaꞌvijon preso ngꞌe tsu nnꞌan Israel ya tontꞌa nnꞌan Babilonia tyiaꞌ yohin. ");
INSERT INTO azgNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jndë na tyecho nnꞌan Babilonia nnꞌan Israel ndyuaahin, Jeconías jnda jon Salatiel, ndoꞌ Salatiel jnda jon Zorobabel. ");
INSERT INTO azgNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel jnda jon Abiud, ndoꞌ Abiud jnda jon Eliaquim, ndoꞌ Eliaquim jnda jon Azor. ");
INSERT INTO azgNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ndoꞌ Azor jnda jon Sadoc, ndoꞌ Sadoc jnda jon Aquim, ndoꞌ Aquim jnda jon Eliud. ");
INSERT INTO azgNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ndoꞌ Eliud jnda jon Eleazar, ndoꞌ Eleazar jnda jon Matán, ndoꞌ Matán jnda jon Jacob. ");
INSERT INTO azgNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Juu Jacobꞌñeen jnda jon José, tsan na toco yo María. Ndoꞌ juu Maríaꞌñeen singui jon Jesús na nquii jon conduihin Mesías. ");
INSERT INTO azgNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Yajoꞌ ntyja ꞌnaanꞌ tsjan nnꞌan na tui Jesucristo, quindë nqui nchoꞌnenque jnda tsjan nnꞌan na jndyocahanꞌ na jnanhanꞌ Abraham na tueeꞌhanꞌ ata xjen David. Ndoꞌ cüiichen nqui nchoꞌnenque jnda tsjan nnꞌan na jndyocahanꞌ na jnanhanꞌ David na tueeꞌ tiempo ya na tyecho nnꞌan Babilonia nnꞌan Israel ndyuaahin chaꞌvijon preso. Ndoꞌ cüiichen nqui nchoꞌnenque jnda tsjan nnꞌan na jndyocahanꞌ na jnanhanꞌ na tyecho nnꞌan Babilonia nnꞌan Israel ndyuaahin na tueeꞌhanꞌ na tui nquii jon na conduihin Mesías. ");
INSERT INTO azgNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Ndö vaa ntyja na tui Jesucristo. Ndyee jon María, tomin jñꞌoon na ngoco jon yo José. Majoꞌ vitjachen na ntoncohin, taaꞌ tsꞌon María na ñjon jnda juu ntyja ꞌnaanꞌ najndei nquii Espíritu Santo. ");
INSERT INTO azgNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Majoꞌ José jeꞌ, tsan na ndisaaꞌ María, tonduihin tsꞌan na itsiquindë jon juu jñꞌoonꞌ Tyoꞌtsꞌon na icoꞌxenhanꞌ. Tyíꞌquintꞌue tsꞌon jon na ngüejnaanꞌ tsanꞌñeen. Ngꞌe na nndaꞌ, sitiu jon na veꞌ ninmaꞌchen ndyuiiꞌ juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ndoꞌ viochen xjen na toquindyiiꞌ tsꞌon jon jñꞌoonꞌñeen, tityincyooꞌ cüii ángel nnon jon xjen na tsooꞌ jon ndaa. Ndoꞌ tso ángelꞌñeen nnon jon: “ꞌUꞌ José na condui ꞌuꞌ tsjan David na jndyocahanꞌ, tyiꞌntyꞌueꞌ na ngyonꞌ cüenta juu María na ndiscuꞌhin ngꞌe ntyja ꞌnaanꞌ nquii Espíritu Santo, joꞌ na ñjon jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nndui jnda jon yusꞌa. Ndoꞌ ꞌuꞌ ntsiquijndyuꞌhin Jesús ngꞌe nque nnꞌan cüentaaꞌ jon, ntsinꞌman jon ñuaanhan yo jnan na nanꞌxuanhin.” Ndöꞌ jñꞌoon siquindyii ángelꞌñeen José. ");
INSERT INTO azgNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Tui na nndaꞌ chaꞌ quitsiquindëhanꞌ jñꞌoon na siquindyi Tyoꞌtsꞌon yo ꞌndyo Isaías na toninncyaa juu jñꞌoonꞌ jon ntyja nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Itso tsanꞌñeen: Quitquenhoꞌ cüenta, ngaquiñjon jnda juu yuscundyua na ntsingui juu cüii yusꞌa, ndoꞌ nnanꞌquijndyu nnꞌan jon Emanuel. Juu jñꞌoon Emanuel itsiquindyihanꞌ: “Nquii Tyoꞌtsꞌon mꞌaan jon yo jaa.” ");
INSERT INTO azgNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ndoꞌ juu José, xjen na ticjeeꞌ jon na tsooꞌ jon ndaa, siquindë jon jñꞌoon na tso ángelꞌñeen nnon jon. Ndoꞌ tyꞌoon jon cüenta María na ndiscuuꞌ jonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Majoꞌ tyíꞌquitjonꞌhan yo ntyjehin na ninñoonꞌ ata vi na jndë singui tsanꞌñeen yujntꞌaꞌñeen. Ndoꞌ siquijndyu Joséhin Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Tui Jesús tsjoon Belén ndyuaa Judea. Xjenꞌñeen juu Herodes coꞌxen jon ndyuaaꞌñeen. Juu xjenꞌñeen nnꞌan na jndaꞌ nquen, squenonhin Jerusalén na jnanhin ndyuaa tontyja na quinduiꞌ ndoꞌcüjioonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Totaꞌxeeꞌhin ndëë nnꞌan: —¿Yuu jon mꞌaan nquii yujntꞌa na tui na conduihin na coꞌxen jon ꞌoꞌ nnꞌan judíos? Ngꞌe xjen na ninvaa mꞌán ndyuaa nján yuu jon na jnán tontyja na quinduiꞌ ndoꞌcüjioonꞌ, xjenꞌñeen jntyꞌiá na tityincyooꞌ quixjuu na itsiꞌmanhanꞌ na jndë tuihin. Joꞌ na tincyö́ na nnanꞌtꞌmánꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Ndoꞌ nquii Herodes, vi na jndë jndyii jon juu jñꞌoonvaꞌ, tiꞌndaaꞌ tycya ntyjii jon ndoꞌ mantyi tsoñꞌen nnꞌan tsjoon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ndoꞌ tꞌua jon tsꞌian na cancüi tsoñꞌen ntyee na conintque ntyja ꞌnaan nnꞌan judíos yo nnꞌan na conanꞌman ntji na coꞌxenhanꞌ na tquen Moisés. Joꞌ taxeeꞌ Herodesꞌñeen ndëë nanꞌñeen yuu jon itsiquindyi jñꞌoonꞌ Tyoꞌtsꞌon na ndui nquii jon na conduihin Mesías. ");
INSERT INTO azgNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ndoꞌ tꞌa nanꞌñeen, jnduehin nnon jon: —Ntji na tquen Tyoꞌtsꞌon itsiquindyihanꞌ na juu Mesías nduihin tsjoon Belén ndyuaa Judea. Ee jñꞌoon na tji Miqueas na toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen, ndö vaa na itsiquindyihanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ꞌOꞌ nnꞌan tsjoon Belén ndyuaa Judá, ꞌoꞌ tꞌmanntyi conduihoꞌ quiiꞌ ntꞌan njoon ninvaa ndyuaa Judá, ngꞌe quityquiiꞌ ntꞌan ꞌoꞌ nduiꞌ cüii tsꞌan na nnintquehin tondëë nnꞌan. Juu jon ngüantyjeeꞌ jon nnꞌan njan nnꞌan Israel. Ndöꞌ vaa jñꞌoon tso juu tsanꞌñeen na toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ndoꞌ juu Herodes, veꞌ ntyꞌiu, tqueenꞌ jon joo nanꞌñeen na jndaꞌ nquen na jnanhin tontyja na quinduiꞌ ndoꞌcüjioonꞌ. Taxeeꞌ jon ndëëhin nin nquii xjen na tityincyooꞌ juu quixjuuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ndë joꞌ jñon jon joohin na cꞌohin Belén. Tso jon ndëëhin: —Cꞌohoꞌ Belén, ndoꞌ vi na jndë squehoꞌ joꞌ, quijntꞌue jndaꞌ ꞌoꞌ yuu vijon mꞌaan juu luꞌñeen. Ndoꞌ vi na jndë jndiohoꞌhin, ncyo ntcüeꞌhoꞌ na quinanꞌquindyiihoꞌ ja, chaꞌ mantyi nndëë ncjö na ntsitꞌmaanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ndoꞌ joo nanꞌñeen, vi na jndë jndyehan jñꞌoon na tso juu tsanꞌñeen na icoꞌxen, jnduiꞌhin, tyꞌehin. Ndoꞌ mantyi juu quixjuu na jntyꞌiahin xjen na ninvaa mꞌanhin ndyuaahin tontyja na quinduiꞌ ndoꞌcüjioonꞌ, tejndyeehanꞌ tondëëhin, taquintyjahanꞌ nquii naijon mꞌaan lu chjoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ndoꞌ ya na jntyꞌia nndaꞌhan juu quixjuuꞌñeen, tyincyaahanꞌ na nein jndyihan. ");
INSERT INTO azgNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jndë na squehin na mꞌaan José yo María, tyequeꞌhin. Jntyꞌiahin juu luꞌñeen yo ndyee juu María. Satoquityehin nnon luꞌñeen, jnanꞌtꞌmaanꞌhin jon. Ndoꞌ jnanꞌquinaanhin quichu ꞌnaanhin, jntꞌahin nayahin, sꞌon ijan yo su yo ꞌnan quichi jndyi na jndyuhanꞌ mirra. ");
INSERT INTO azgNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jndë joꞌ tyꞌe ntcüeꞌhin ndyuaa na jnanhin. Majoꞌ mañoon nato tyꞌehin ngꞌe quityquiiꞌ tsantsjon, siquindyii Tyoꞌtsꞌonhan na tavincꞌo ntcüeꞌhin na mꞌaan Herodes. ");
INSERT INTO azgNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Xjen na jndë jnduiꞌ nanꞌñeen, cüii ángel cüentaaꞌ ta Tyoꞌtsꞌon tityincyooꞌhin nnon José xjen na tsooꞌ jon ndaa. Tso ángelꞌñeen nnon jon: —Quinaquintyjaꞌ, cayonꞌ luchjöhöꞌ yo ndyee jon, quinanꞌcjehoꞌ, cꞌohoꞌ ndyuaa Egipto. Joꞌ quintjohoꞌ ata xjen na ntsiquindyi ꞌuꞌ. Quitsaꞌ na nndaꞌ ngꞌe ntꞌuevichen tsꞌon Herodes luchjova chaꞌ na ntscueeꞌ jonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ndoꞌ jnanquintyja José na itso jon. Majuuntyi tsjonꞌñeen tëyꞌoon jon luchjoꞌñeen yo ndyee jon, jnduiꞌhin, tyꞌehin Egipto. ");
INSERT INTO azgNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Joꞌ tomꞌanhin ata xjen na tueꞌ juu Herodes. Ndoꞌ na tui na nndaꞌ, siquindëhanꞌ juu jñꞌoon na siꞌman Tyoꞌtsꞌon ndyu na toxenꞌchen nnon Oseas, tsan na toninncyaa jñꞌoonꞌ jon ntyja nchu vaa ꞌnan na nguaa. Ndö vaa na itsohanꞌ: “Tquënꞌ yusꞌa jnda na quinduiꞌ ntcüeꞌ jon ndyuaa Egipto.” ");
INSERT INTO azgNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Majoꞌ juu Herodesꞌñeen, vi na jndë tquen jon cüenta na joo nanꞌñeen na jnan tontyja na quinduiꞌ ndoꞌcüjioonꞌ, veꞌ jnanꞌviꞌnnꞌanhan jon na jnduehan na ntsque ntcüeꞌhan na mꞌaan jon, sevꞌii jndyi jon. Joꞌ tꞌua jon tsꞌian ndëë sondaro ꞌnaanꞌ jon na quinanꞌcüjehin tsoñꞌen yotsca yonon na mꞌan tsjoon Belén, yo na jndë ve chu na tocje ndoꞌ mantyi yo yotsca na cüajon ndyu na mꞌan njoon quijndë na mꞌan xiꞌjndio juu tsjoonꞌñeen. Ngꞌe nndaꞌ vaa na tjiꞌ jon cüenta ntyja ꞌnaanꞌ juu xuee na jndue nanꞌñeen na tityincyooꞌ juu quixjuuꞌñeen na jntyꞌiahin. ");
INSERT INTO azgNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndoꞌ na sꞌaa jon na nndaꞌ, siquindëhanꞌ jñꞌoonꞌ Tyoꞌtsꞌon na tyincyaa nquii Jeremías na tonduihin tsꞌan na toninncyaa jñꞌoon nchu vaa ꞌnan na nguaa. Sinin jon jñꞌoon ntyja ꞌnaan nanntcu judías tsjoon Belén na ntsichjooꞌ jndyihanꞌ nꞌonhin na nnanꞌcüje nnꞌan ndahin. Tyíꞌquitsinin nquiiꞌ jon jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tso jon: Quityquiiꞌ tsjoon Ramá ticꞌuaa na cotyuee ndyee yotsca. Jndei conanꞌxuaahin, cotyueehin ntyja ꞌnaan ndahin min tyiꞌninncyahin na ntsinjoonꞌ tsꞌanhin ngꞌe jndë jnanꞌcüje nnꞌan ndahin. Nndaꞌ vaa jñꞌoon na tji Jeremías. ");
INSERT INTO azgNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ndoꞌ vi na jndë tueꞌ juu Herodesꞌñeen, juu ángel cüentaaꞌ Tyoꞌtsꞌon, tityincyooꞌ nndaꞌhin nnon José xjen na tsooꞌ jon ndaa. Xjenꞌñeen ninvaa mꞌaan jon ndyuaa Egipto. ");
INSERT INTO azgNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tso ángelꞌñeen nnon jon: “Quinaquintyjaꞌ, cayonꞌ ntcüeꞌ yuchjova yo ndyee jon ndoꞌ cꞌo ntcüeꞌ ꞌoꞌ ndyuaa Israel, ngꞌe nnꞌan na tojntꞌuehin yuchjova na nnanꞌcueeꞌhanhin, jndë tjëhan.” Ndöꞌ vaa na siquindyi ángelꞌñeen jon. ");
INSERT INTO azgNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ndoꞌ juu José jeꞌ, jnanquintyja jon, tayꞌoon jon yuchjoꞌñeen yo ndyee juu, tyꞌe ntcüeꞌhin ndyuaa Israel. ");
INSERT INTO azgNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Majoꞌ vi na jndë jndyii José na jndë tueꞌ Herodes, ndoꞌ juu jnda jon Arquelao coꞌxen tsanꞌñeen ndyuaa Judea, joꞌ na sityꞌuehanꞌ José na ncja ntcüeꞌ jon Judea. Ndoꞌ xjenꞌñeen sꞌaa nndaꞌ Tyoꞌtsꞌon na tsooꞌ juu ndaa na siꞌman jon nnon juu na tyiꞌncja juu joꞌ. Mangꞌe joꞌ tja jon tontyja ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jndë na squehin joꞌ, ntjohin tsjoon Nazaret. Ndoꞌ na tui na nndaꞌ, sequindëhanꞌ jñꞌoonꞌ Tyoꞌtsꞌon na toninncya nnꞌan ndyu na toxenꞌchen na juu Jesús nnanꞌquijndyu nnꞌanhin tsꞌan Nazaret. ");
INSERT INTO azgNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Juu xjenꞌñeen na taꞌ Juan na toninncyaa jon jñꞌoon ndëë nnꞌan vi ntyjaaꞌ jndëë naijon tyiꞌjndye nnꞌan mꞌan. Totsiquindëëꞌ jon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Totso jon ndëëhin: “Quintcüeꞌ nꞌonhoꞌ yo jnan na nanꞌxuanhoꞌ ngꞌe nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue, jndë tindyo na ngityeꞌ na ntcoꞌxen jon ꞌoꞌ na cotsamꞌanhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Juu Isaías, tsan na ndyu na toxenꞌchen na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nguaa, sinin jon ntyja ꞌnaanꞌ Juanꞌñeen quiiꞌ jñꞌoon na tji jon, tso jon: Mꞌaan cüii tsꞌan tojndëë naijon tyiꞌjndye nnꞌan mꞌan. Incyaa jon jñꞌoon ndëë nnꞌan, itso jon: “Juu na conanꞌjonhoꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon, itsijonhanꞌ juuhanꞌ chaꞌvijon nato. Quitaꞌyahoꞌ na tonnon jon. Quinanꞌyuhoꞌ ntyja na cotsamꞌanhoꞌ chaꞌvijon na conanꞌyuhoꞌ nato na nndyo jon.” Manndaꞌ jñꞌoon tso Isaíasꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juu Juanꞌñeen tocüe jon ndiaa na jndëhanꞌ yo sooꞌ camello. Ndoꞌ tsiaaꞌ jon toquityen tjan. Ndoꞌ veꞌ quintcaa ndyueꞌ tocüaꞌ jon, ndoꞌ toꞌu jon tsionꞌ quintyꞌi jndëë. ");
INSERT INTO azgNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jndye nnꞌan tsjoon Jerusalén tyꞌehin naijon mꞌaan jon na ninꞌquindyehin jñꞌoon na toninncyaa jon, mantyi yo nnꞌan ndyuaa Judea yo ninꞌnnꞌan na mꞌan ndyo jndaa Jordán. ");
INSERT INTO azgNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ndoꞌ vi jndë na tjiꞌ jndyoyuhin nchu vaa na tonanꞌtjahin nnon Tyoꞌtsꞌon, siquindëëꞌ Juan joohin quityquiiꞌ ndaa jndaa Jordán. ");
INSERT INTO azgNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ndoꞌ jndyiaaꞌ Juan na jndye nnꞌan tmaanꞌ fariseos yo tmaanꞌ saduceos, squehan na mꞌaan jon na ntꞌue nꞌonhan na quitsiquindëëꞌ jon joohan. Majoꞌ ya na tquen jon cüenta na nndaꞌ, joꞌ jaaꞌ jñꞌoon tso jon ndëëhan: “Joo quindu xjen na ndyo chon, ncyaa jndyi oꞌ, conanꞌnon oꞌhanꞌ. ꞌOꞌ ntyja na contꞌahoꞌ, itsijonhanꞌ juuhanꞌ chaꞌna contꞌa joo choꞌñeen. ꞌOꞌ concyohoꞌ na mꞌan ja ngꞌe na conanꞌtjahoꞌ nnon Tyoꞌtsꞌon. ¿Nin tsꞌan siꞌman ndëëhoꞌ na vaa na nndëë ntꞌahoꞌ na tyiꞌntsivꞌii jon ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Cüa, quintꞌahoꞌ ncüii ncüii nnon na ntsiꞌman jndyoyuhanꞌ na jndë contcüeꞌ nꞌonhoꞌ yo jnan na nanꞌxuanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Min tyiꞌnanꞌtiuhoꞌ na vanaan na nnanꞌsaaꞌ nque nꞌonhoꞌ na nnduehoꞌ: Jaa tyiꞌxeꞌquitꞌuii Tyoꞌtsꞌon jaa ngꞌe condui jaa tsjan Abraham na jndyocahanꞌ. Quindyehoꞌ jñꞌoon na ntsjö, min veꞌ ntjöꞌmin nndëë ntscüequen Tyoꞌtsꞌonhanꞌ na nnduihanꞌ nnꞌan tsjan ꞌnaanꞌ Abraham ndoꞌ na nndaꞌ nꞌndyihanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Chaꞌxjen ndyiiꞌ cje hacha ntꞌö tsꞌan na ncꞌua juu ngꞌee nꞌoon na tyiꞌya të contꞌa, ndoꞌ vi na jndë tinquehanꞌ, ndyion juuhanꞌ nnon chon, manndaꞌ itsijonhanꞌ na ntsꞌaa Tyoꞌtsꞌon ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Jñꞌoon na mayuuꞌ na matsiquintꞌë ꞌoꞌ yo ndaa, ngꞌe na contcüeꞌ nꞌonhoꞌ jnan na nanꞌxuanhoꞌ. Majoꞌ vi na jndë na jntyꞌiihanꞌ ja na matsixuan tsꞌianmin, yajoꞌ ncꞌoon nquii jon na ntsiquindëëꞌ jon ꞌoꞌ na nninncyaa jon Espíritu Santo. Majoꞌ ñꞌen ꞌoꞌ na ntsiquindëëꞌ jon ꞌoꞌ yo chon ngꞌe na nntꞌuiityenhanꞌ ꞌoꞌ ntyja ꞌnaanꞌ jnan ꞌoꞌ. Juu jon tꞌmanchen conduihin, chintyi ja, min tyiꞌquijntꞌue ja na veꞌ na ncjöcyꞌön ntcoonꞌ jon na nñjon jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cje ntscüeꞌndyii jon juu trigo. Ndë joꞌ ntsue jon juu trigoꞌñeen quityquiiꞌ vaaꞌ jon, majoꞌ tsjaaꞌhanꞌ ntsco jonhanꞌ yo chon na tajon quinduuꞌ.” Ndöꞌ jñꞌoon na sinin Juan ndëë nanꞌñeen. Jñꞌoonꞌñeen tyíꞌquitsinin nquiiꞌ jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jndë joꞌ jnduiꞌ Jesús ndyuaa Galilea, tja jon jndaa Jordán na ntsiquindëëꞌ Juanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Majoꞌ quii ꞌndyo Juan na tyiꞌntsꞌaa Jesús na nndaꞌ. Itso jon: —Ja chuhanꞌ na ꞌuꞌ ntsiquindëꞌ ja. Tyiꞌquichuhanꞌ na ja na ntsiquintꞌë ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Majoꞌ sentcüeꞌ Jesús jñꞌoon nnon tsanꞌñeen, tso jon: —Jndyoyu icüjiꞌhanꞌ na quindui ꞌnan na matsjö, ngꞌe icanhanꞌ na quitaꞌncꞌuë jaa tsoñꞌen na itsijndaꞌ Tyoꞌtsꞌon. Yajoꞌ tangueeꞌ Juan. ");
INSERT INTO azgNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ndoꞌ vi na jndë siquindëëꞌ Juanhin, yajoꞌ jnduiꞌ Jesús quityquiiꞌ ndaa. Majuu xjenꞌñeen jnaan quiñoonꞌndue, ndoꞌ jndyiaaꞌ jon na jndyocue Espíritu cüentaaꞌ Tyoꞌtsꞌon cjooꞌ jon na chaꞌvijon quituꞌ. Jndyoquintyjo Espíritu Santo cjooꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ndoꞌ nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue, ticꞌuaa na sinin jon, tso jon: “Ndöhin tsansꞌa jnda na viꞌnchjii jndyihin, na nën jndyihin.” ");
INSERT INTO azgNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Vi na jndë tui na nndaꞌ, tayꞌoon Espíritu Santo Jesús ndyuaa naijon tyiꞌjndye nnꞌan mꞌan. Joꞌ totsichon yutyia na quityiiꞌhanꞌ ngꞌeehanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jndë na tejndoꞌ jon vennꞌan xuee ndoꞌ vennꞌan tsjon, tyioo na ninjndoꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ndoꞌ tyjeeꞌnon yutyia na mꞌaan Jesús na ninꞌquityiiꞌ juu ngꞌee juuhin. Tso juu nnon jon: —Xe na aa mayuuꞌ condui ꞌuꞌ jnda Tyoꞌtsꞌon, quitsuꞌ ndëë ntjöꞌmin na cüequen tyooꞌhanꞌ na ntcüaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Majoꞌ sintcüeꞌ Jesús jñꞌoon, itso jon: —Jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsiquindyihanꞌ na chito veꞌ xiaꞌntyi yo tyooꞌ ngüandoꞌ tsꞌan. Majoꞌ ntyja na vangueeꞌ tsꞌan ncüii ncüii ꞌndyo jñꞌoon na incyaa Tyoꞌtsꞌon, joꞌ ngüandoꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jndë joꞌ tayꞌoon yutyia Jesús Jerusalén, tsjoon jiꞌua cüentaaꞌ Tyoꞌtsꞌon. Sꞌaa juu na cüentyjeeꞌ Jesús xquenviꞌ vatsꞌon tꞌman na mꞌaan juu tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tso juu nnon jon: —Xe na aa mayuuꞌ condui ꞌuꞌ jnda Tyoꞌtsꞌon, cüa, cjuꞌ ꞌuꞌ tyuaa, ngꞌe jñꞌoonꞌ jon itsohanꞌ: Ncꞌua jon tsꞌian ndëë ángeles cüentaaꞌ jon ntyja ꞌnanꞌ. Joohin ntyiꞌhin ndueehin ꞌuꞌ chaꞌ tyiꞌncjaquiñjon ntjöꞌ ngꞌeꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Majoꞌ tꞌa Jesús, itso jon nnon yutyia: —Min tyiꞌquichuhanꞌ na quitsꞌa chaꞌxjen na matsuꞌ ndöꞌ ngꞌe mantyi vaa jñꞌoonꞌ jon na itsiquindyihanꞌ: “Tyiꞌntquenꞌ xjen ꞌnanꞌ nquii ta Tyoꞌtsꞌon na conduihin na ityeꞌntjon jon tsoñꞌen.” ");
INSERT INTO azgNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ndoꞌ na matsꞌia tayꞌoon yutyia Jesús cüii tyoꞌ ndye. Siꞌman juu nnon jon ncüii ncüii nnon nanmꞌannꞌian na ninvaa tsonnangue ndoꞌ yo ntyja na tꞌman najndëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tso juu nnon jon: —Tsoñꞌen nanꞌminꞌ nninncya na nnanꞌxuanhanꞌ cüentaꞌ xe na aa ntcoꞌxtyeꞌ na ntsitꞌmanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tꞌa Jesús, tso jon: —Quenanꞌ ꞌuꞌ nnön Satanás. Ee quityquiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon chuuꞌ jñꞌoon na coxenhanꞌ na xiaꞌntyi nquii jon na quitsitꞌmaanꞌ tsꞌan, ninnquii jon ntyeꞌntjonꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ndë joꞌ jntyꞌii yutyia Jesús, ndoꞌ sque ángeles, totixeeꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ndoꞌ vi na jndë jndyii Jesús na jndë tyiꞌ nnꞌan Juan vancjo, tja ntcüeꞌ jon Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Majoꞌ tyíꞌquintjohin Nazaret, jnduiꞌ jon joꞌ, ntjohin tsjoon Capernaum na mꞌaanhanꞌ ꞌndyo ndaandue. Ndyuaaꞌñeen tsixuanhanꞌ cüenta tmaanꞌ nnꞌan judíos tsjan Zabulón yo Neftalí. ");
INSERT INTO azgNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Na tomꞌaan jon juu ndyuaaꞌñeen, siquindëhanꞌ jñꞌoon na tji Isaías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen nchu vaa ꞌnan na nguaa. Juu jñꞌoonꞌñeen, ndö vaa na itsiquindyihanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Ntyja ꞌnaan nnꞌan na mꞌan ndyuaa cüentaaꞌ Zabulón yo nnꞌan ndyuaa cüentaaꞌ Neftalí, joohan na mꞌan ndyuaa nato na vjahanꞌ tondaandue, ndoꞌ mantyi nnꞌan na mꞌan ixndya jndaa Jordán, yo nnꞌan ndyuaa Galilea na chito conduihin nnꞌan judíos, ");
INSERT INTO azgNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","joo nanꞌñeen mꞌanhin na cje ꞌnaanꞌ najaan, majoꞌ naneinhin jndë tityincyooꞌ ncüii nnon na quixuee jndyi ndëëhin. Itsijonhanꞌ juuhanꞌ chaꞌvijon na ndyova ndoꞌcüjioonꞌ na itsixueehanꞌ nnon tsonnangue, manndaꞌ ro jndë sixueehanꞌ quiiꞌ nꞌon nnꞌan na mꞌanhin nacje ꞌnaanꞌ ncüaanꞌ ꞌnan tyia na itsꞌaahanꞌ cotsu ñuaanhan. Nndaꞌ jñꞌoon na tso Isaíasꞌñeen na toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ndoꞌ nquii Jesús, xjenꞌñeen taꞌ jon na toninncyaa jon jñꞌoon. Totso jon: —Quintcüeꞌ nꞌonhoꞌ jnanhoꞌ, ngꞌe jndë tentyja xjen na nninncyahoꞌ na nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue ntyeꞌntjon jon ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Xjen na mandyiꞌ Jesús ꞌndyo ndaandue Galileaꞌñeen, jndyiaaꞌ jon ve tsansꞌa na ninncüii tsꞌan ntsindahin, Simón, tsan na jndyu Pedro, yo tyje jon na jndyu Andrés. Cotjueꞌhin ntquiꞌ ꞌnaanhin quityquiiꞌ ndaandue na cotjiꞌhin quintcaa. ");
INSERT INTO azgNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Joꞌ tꞌman Jesús joohin, itso jon: —Quindyonanꞌjonhoꞌ yo jñꞌoon na mancya ndoꞌ ntsꞌa na nnanꞌtjonhoꞌ nnꞌan na ncꞌonhan cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ninñoonꞌ jntyꞌehin ntquiꞌ ꞌnaanhin, tyꞌehan yo juu jon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Jndë na tjantyichen jon, joꞌ ntji jon mañoon vechen tsꞌan. Nanꞌñeen ntsinda Zebedeo, jndyu ncüii tsanꞌñeen Santiago yo tyje jon Juan. Mꞌanhin quityquiiꞌ vꞌaandaa yo nquii tyehin. Cotaꞌyahin ntquiꞌ ꞌnaanhin. Tqueenꞌ Jesús joohin. ");
INSERT INTO azgNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ndoꞌ joꞌ ninñoonꞌ jnduiꞌhin quiiꞌ vꞌaandaaꞌñeen, jntyꞌehinhanꞌ yo tyehin, tyenanꞌjonhin yo jon. ");
INSERT INTO azgNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ndoꞌ nquii Jesús, tomandyiꞌ jon ninvaa ndyuaa Galilea. Totsiꞌman jon ndëë nnꞌan quityquiiꞌ ntꞌaanꞌon ꞌnaanhin. Toninncyaa jon jñꞌoon naya na nanein ngitaꞌ Tyoꞌtsꞌon na ntyeꞌntjon jon nnꞌan, ncüii nnon na ñoncya vaa yo na totsꞌaa jon ndyu na toxenꞌchen. ");
INSERT INTO azgNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ninvaa ndyuaa Siria tocya jñꞌoon ntyja ꞌnaanꞌ Jesús. Ndoꞌ joo nnꞌan ndyuaaꞌñeen, tondyochohan tsoñꞌen nnꞌan vꞌi na mꞌaan jon na jndye nnon ntycu cotjonhin yo na toquiihanꞌhin. Ndoꞌ mantyi yo nnꞌan na mꞌan jndyetyia quiiꞌ nꞌon, ndoꞌ yo nnꞌan na cho tycu na iveꞌquiso yo tycutquen. Ndoꞌ sinꞌman Jesús nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jndye ntmaanꞌ nnꞌan tentyjahin naxenꞌ jon. Jnanhin ndyuaa Galilea yo joo nqui njoon na conduehin Decápolis, yo tsjoon Jerusalén yo ndyuaa Judea ndoꞌ mantyi ninꞌndyuaa ixndyaaꞌ jndaa Jordán. ");
INSERT INTO azgNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ndoꞌ ya na jndyiaaꞌ Jesús na vancüi tmaanꞌ nnꞌan na jndye jndyiꞌhin, teva jon ncüii tyoꞌ. Jndë na tëcjo jon joꞌ, nque nnꞌan na tqueenꞌ jon na quinanꞌjonhin yo jon yo jñꞌoon na toninncyaa jon, tentyjaaꞌhin nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Joꞌ taꞌ jon, totsiꞌman jon ndëëhin, tso jon: ");
INSERT INTO azgNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—Joo nnꞌan na covaaꞌ nꞌonhin na conduihin nnꞌan ntyꞌiahin na tonnon Tyoꞌtsꞌon, incyaahanꞌ na neiinꞌ nꞌonhan. Conduihin nnꞌan na ityentjon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Joo nnꞌan na chjooꞌ nꞌonhan na conanꞌtjahan nnon Tyoꞌtsꞌon, incyaahanꞌ na neiinꞌ nꞌonhan ngꞌe ntsinjoonꞌ jonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Joo nnꞌan na cotjueꞌcjehin na tonnon nquii Tyoꞌtsꞌon, incyaahanꞌ na neiinꞌ nꞌonhan ngꞌe nndahin juu tsonnangue xco. ");
INSERT INTO azgNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Joo nnꞌan na ntꞌue jndyi nꞌonhin na ntꞌahin ꞌnan na ntꞌue tsꞌon Tyoꞌtsꞌon, incyaahanꞌ na neiinꞌ nꞌonhan ngꞌe quindë ya nninncyaa jon nchu vaa na contyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Joo nnꞌan na mꞌanhan na ntyꞌia ro ntyjehan ngiohan, incyaahanꞌ na neiinꞌ nꞌonhan ngꞌe ncꞌoon Tyoꞌtsꞌon na ntyꞌia rohan nchjii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Joo nnꞌan na ntjuꞌ mꞌanhin na conanꞌtiuhin yo na contꞌahin, incyaahanꞌ na neiinꞌ nꞌonhan ngꞌe njntyꞌia ndëëhin nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Joo nnꞌan na cotaꞌyahin ntyjehin na cho nanꞌñeen tyiaꞌ, incyaahanꞌ na neiinꞌ nꞌonhan. Joo nanꞌñeen na ya contꞌahin, ngitso Tyoꞌtsꞌon na conduihan ntsinda nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Joo nnꞌan na contyꞌe nnꞌanhin ngꞌe na cotsantyjahin ntyja ꞌnaanꞌ Tyoꞌtsꞌon, incyaahanꞌ na neiinꞌ nꞌonhan. Joo nanꞌñeen conduihan nnꞌan na mꞌan nacje ꞌnaanꞌ na icoꞌxen nquii Tyoꞌtsꞌon na mꞌaan jon quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Incyaahanꞌ na neiinꞌ nꞌonhoꞌ xjen na conanꞌcüejnaanꞌ nnꞌan ꞌoꞌ, ndoꞌ na contꞌaviꞌhin ꞌoꞌ, ndoꞌ cotjiꞌhin tsoñꞌen nnon jñꞌoonviꞌ cjohoꞌ na veꞌ quintuhanꞌ ngꞌe na conduihoꞌ nnꞌan na mꞌan ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cꞌonhoꞌ na nein jndyihoꞌ ngꞌe na coquenonhoꞌ nanꞌminꞌ ngꞌe tꞌman naya ꞌnaanhoꞌ vave quiñoonꞌndue. Ee machaꞌxjen contꞌaviꞌhin ꞌoꞌ, manndaꞌ ro tontꞌaviꞌhan nque nnꞌan na tomꞌan ndyu na toxenꞌchen na toninncyahan jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“ꞌOꞌ conduihoꞌ chaꞌvijon tsjaanꞌchjenꞌ quiiꞌ ntꞌan nnꞌan tsonnangue. Majoꞌ juu tsjaanꞌ jeꞌ, xe na aa jndë jnduiꞌ na chjenꞌhanꞌ, ¿Nchu ya ntsꞌaa tsꞌan na ndichjenꞌ nndaꞌhanꞌ? Tayuu jntꞌuehanꞌ. Veꞌ ntyqueꞌto tsꞌanhanꞌ na ntqueꞌntjo nnꞌan cjohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ndoꞌ mantyi conduihoꞌ chaꞌvijon chon na condixuee ndëë nnꞌan tsonnangueva. Mangiohoꞌ cüii tsjoon na vequityenhanꞌ xquen cüii tyoꞌ, tyiꞌxeꞌquindëë ngitëꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Min tanin juu na ntscüꞌa ncüii lámpara chaꞌ ndëcya ntscüangiooꞌ tsanꞌñeen istjö cjooꞌhanꞌ. Juu tsanꞌñeen ntsintyja jon lámparaꞌñeen chaꞌ ya ntsixueehanꞌ ndëë tsoñꞌen nnꞌan na mꞌan vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Manndaꞌ quintꞌahoꞌ ꞌnan na chuhanꞌ yo nnꞌan ngꞌe naya na ntꞌahoꞌhin ntsijonhanꞌ juuhanꞌ chaꞌvijon chon na covixuee ndëëhin. Ee na nntꞌahoꞌ na nndaꞌ, yajoꞌ ntquenhin cüenta joo ꞌnan ya contꞌahoꞌ ndoꞌ nnanꞌtꞌmaanꞌhin nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Joo jñꞌoon na tquen Moisés yo jñꞌoon na toninncya nque nnꞌan na tomꞌan ndyu na toxenꞌchen nchu vaa ꞌnan na nguaa, tyiꞌnanꞌtiuhoꞌ na jndyö na ntsityꞌui joohanꞌ, ja jndyö na joo jñꞌoonꞌñeen ntsiquindëhanꞌ juuhanꞌ ntyja njan ndoꞌ chaꞌ ntsiꞌman nchu vaa itsiquindyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, viochen xjen na vacachen na mꞌaan tsjöꞌndue yo tyuaa, ncüii cüii ntji na quindëchen na mꞌaanhanꞌ tyquiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon na coꞌxenhanꞌ, tsoñꞌenhanꞌ ntsiquindëhanꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Mangꞌe joꞌ, minꞌcya ro tsꞌan na ntsꞌaa na tyiꞌquinjon ncüii nnon jñꞌoon na tquen Moisés, min na tyiꞌjaaꞌchen tsixuanhanꞌ quiiꞌ ntꞌan jñꞌoonꞌñeen, ndoꞌ xe na aa ntsiꞌman juu ndëë ntyje juu na tyiꞌnanꞌvehan jñꞌoonꞌñeen, naijon na icoꞌxen Tyoꞌtsꞌon, ngitsohanꞌ ntyja ꞌnaanꞌ tsanꞌñeen na tyiꞌtꞌman conduihin. Majoꞌ juu tsꞌan na itsue jñꞌoonꞌñeen, ndoꞌ ntsiꞌman jon ndëë nnꞌan na quitaꞌngueeꞌhinhanꞌ, tꞌmanchen condui tsanꞌñeen naijon na icoꞌxen nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Chaꞌ na nndëë ntsijon tsꞌan ntyja ꞌnaanꞌ juu na icoꞌxen Tyoꞌtsꞌon na mꞌaan jon quiñoonꞌndue, chuhanꞌ na quitsiquindëntyichen juu chaꞌxjen ꞌnan na ntꞌue tsꞌon jon, chito chaꞌxjen na contꞌa nnꞌan tmaanꞌ fariseos yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés. Xe tyiꞌquintꞌahoꞌ chaꞌxjen na matsjö ndöꞌ, tyiꞌjon quindëë nanꞌjonhoꞌ ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“ꞌOꞌ jndë mangiohoꞌ jñꞌoon na tso Tyoꞌtsꞌon ndëë ndochihoꞌ: ꞌUꞌ tyiꞌntscueꞌ tsꞌan, ndoꞌ minꞌcya ro tsꞌan na ntscueeꞌ juu tyje juu, majndaꞌ ntꞌuiityenhanꞌhin tonnon jüe. ");
INSERT INTO azgNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Majoꞌ ja matsjö ndëëhoꞌ, minꞌcya ro tsꞌan na ntsivꞌii juu ncüii ntyje juu, chi ntꞌuiityenhanꞌ tsanꞌñeen, ndoꞌ minꞌcya ro tsꞌan na ngitso juu na tayuujntꞌue tyje juu ndoꞌ xe na aa ngitso juu nnon tsanꞌñeen: Tsanꞌ ꞌuꞌ, vaa na toncuuꞌ na ncjuꞌhanꞌhin quityquiiꞌ chon vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Mangꞌe na nndaꞌ, juu xjen na matyioꞌ ꞌnan nnontyiu na ntsitꞌmanꞌ Tyoꞌtsꞌon, cañjoonꞌ tsonꞌ xe na aa mꞌaan ncüii tsꞌan na tyiꞌya nchjii juu yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Ndoꞌ xe na aa nndaꞌ, yajoꞌ quiꞌndyiꞌ juu nanꞌñeen na tyioꞌ nnontyiuꞌñeen, cacoꞌya jndyee ꞌuꞌ yo juu, ndë joꞌ quindyoꞌ ntcüeꞌ na ntsitꞌmanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Juu tsꞌan na ninꞌquen juu ꞌuꞌ nnon tsꞌian, cje ro quitsaꞌ na ntjo ya ntyjii juu yo ꞌuꞌ viochen na incyaahanꞌ xjen na nninjndaꞌ jñꞌoon ꞌnanꞌ yohin, tyiꞌntsꞌaahanꞌ ngꞌe na tyiꞌcotsijndaꞌ jñꞌoon na vaa yo ꞌuꞌ, ntquen juu ꞌuꞌ nnon jüe, ndoꞌ juu jüe ncꞌua juu tsꞌian na quityiꞌ cominsión ꞌuꞌ vancjo. ");
INSERT INTO azgNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jñꞌoon na mayuuꞌ matsjö nnonꞌ, tyiꞌxeꞌquinduiꞌ joꞌ ata jndë tyionꞌñꞌenꞌ na chuꞌjnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“ꞌO jndë jndyehoꞌ na tso Tyoꞌtsꞌon ndëë ndochihoꞌ: ꞌUꞌ tyiꞌncꞌonꞌ yo tsꞌan na veꞌ ndöꞌ ro. ");
INSERT INTO azgNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Majoꞌ ncö, jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minꞌcya ro ncüiihoꞌ na ndyiaaꞌ juu ncüii tsanscu, na ninꞌcꞌoon jndyi juu yo tsanꞌñeen, ndoꞌ na nndaꞌ, jndë tsixuan juu jnan yo tsanscuꞌñeen, ngꞌe quiiꞌ tsꞌon juu jndë sitiu juu na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Ndoꞌ ngꞌe na nndaꞌ, xe na aa tënnonꞌ ntyjaya ntsꞌaahanꞌ na matsitja ꞌuꞌ, yantyi cüjiꞌhanꞌ, quityqueꞌhanꞌ na tycya na mꞌanꞌ, ngꞌe yantyichen na tyiꞌquindë ꞌuꞌ na ngaqueꞌ na mꞌaan Tyoꞌtsꞌon, chito na quindë ꞌuꞌ ncjaꞌ vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndoꞌ mantyi juu ntꞌöꞌ ntyjaya, xe na aa itsꞌaahanꞌ na matsitja ꞌuꞌ, yantyi quityjeꞌhanꞌ ndoꞌ ndë quityqueꞌhanꞌ, ngꞌe yantyi na tyiꞌquindë ꞌuꞌ na ncjaꞌ quiñoonꞌndue, chito na quindë ꞌuꞌ na ncjaꞌ vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Mantyi ꞌoꞌ jndë jndyehoꞌ jñꞌoon na tquen Moisés na itsohanꞌ: Minꞌcya ro ncüii ꞌoꞌ na nꞌndyii juu scuuꞌ, nndë ncüii tson na ngitsohanꞌ na jndë jntyꞌehan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Majoꞌ jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, xiaꞌntyi xe na aa mꞌaan scuuꞌ tsꞌan yo ncüiichen tsꞌan, joꞌ vanaan na nꞌndyii jonhin. Xe na aa chito nndaꞌ vaa, ndoꞌ ꞌndyiꞌhin, matsaꞌ na veꞌ mꞌaan ya juu yo ncüiichen tsꞌan, ndoꞌ mantyi juu tsansꞌaꞌñeen vaa jnaanꞌ jon na veꞌ mꞌaan ya jon yo juu tsanscuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ndoꞌ mantyi jndë jndyehoꞌ jñꞌoon na tondye ndochihoꞌ: Tyiꞌntcoꞌ ꞌndyoꞌ na nchjii Tyoꞌtsꞌon na mayuuꞌ jñꞌoon na matsininꞌ ndoꞌ nchjiꞌ yaꞌ na jeꞌquitsiquindëꞌhanꞌ. Majoꞌ ꞌuꞌ quitsiquindëꞌ jñꞌoon na jndë tcoꞌ ꞌndyoꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Majoꞌ ja matsjö ndëëhoꞌ, minꞌncüii nnon tyiꞌngitaꞌhoꞌ jndyuehoꞌ jñꞌoon na conduehoꞌ na nchjii Tyoꞌtsꞌon na mayuuꞌhanꞌ, min tyiꞌngitaꞌhoꞌ jndyuehoꞌ na ntjiꞌhoꞌ xueeꞌ quiñoonꞌndue ngꞌe juuhanꞌ conduihanꞌ silla na maninꞌtsꞌiaanꞌ na vequityen jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ndoꞌ min tyiꞌngitaꞌhoꞌ jndyuehoꞌ na ntjiꞌhoꞌ xueeꞌ tsonnangue ngꞌe juuhanꞌ mꞌaanhanꞌ tocje ꞌnaanꞌ jon, ndoꞌ na nnduehoꞌ na nndaꞌ itsijonhanꞌ na conduehoꞌ na nchjii jon na mayuuꞌ jñꞌoon na conduehoꞌ. Ndoꞌ min tyiꞌntjiꞌhoꞌ xueeꞌ tsjoon Jerusalén na cotaꞌhoꞌ jndyuehoꞌ, ngꞌe conduihanꞌ tsjoon naijon na icoꞌxen Tyoꞌtsꞌon na nquii jon taquintyja na tꞌman conduihin. ");
INSERT INTO azgNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Min tyiꞌntjiꞌhoꞌ xueeꞌ nquen nquehoꞌ na cotaꞌhoꞌ jndyuehoꞌ ngꞌe minꞌncüii sonquenhoꞌ jeꞌquindëë ntꞌahoꞌ na nninquichiꞌhanꞌ ndoꞌ min na aa ndintonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Majoꞌ ya na cotaꞌhoꞌ jndyuehoꞌ na mayuuꞌ cüii jñꞌoon, quitsiꞌmanhanꞌ na mayuuꞌhanꞌ, ndoꞌ juu xjen na cotaꞌhoꞌ jndyuehoꞌ na min tyiꞌyuuꞌ ncüii jñꞌoon, quitsiꞌmanhanꞌ na tyiꞌyuuꞌhanꞌ. Ngꞌe minꞌcya ro jñꞌoon na ntscüantjoꞌntyi tsꞌan na ntcoꞌ juu ꞌndyo juu na nchjii Tyoꞌtsꞌon na jñꞌoon mayuuꞌ itsinin juu, juu jñꞌoonꞌñeen conanhanꞌ na mꞌaan yutyia. ");
INSERT INTO azgNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ꞌOꞌ jndë jndyehoꞌ jñꞌoon na tquen Moisés na itsohanꞌ: Minninchen nnon naviꞌ na ntsꞌaa tsꞌan yo cüiichen tyje juu, manincüajon quitjon juu. Xe na aa tënnon tyje juu isqueeꞌ juu, mantyi nndaꞌ quitjon juu. Ndoꞌ xe na aa tsiꞌnꞌon cüii tyje juu tcon juu, mantyi quiton tsiꞌnꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Majoꞌ ja, ndö vaa matsjö ndëëhoꞌ ntyja ꞌnaanꞌ juu jñꞌoonvaꞌ: Tyiꞌntꞌueꞌ ꞌuꞌ na nnjon tsꞌan na itsꞌaa viꞌ ꞌuꞌ. Minninchen tsꞌan na iminꞌ ndaꞌchcya quinchoꞌ tontyjaya, ncyaꞌ na quiminꞌ juu cüiichenhanꞌ tontyjandyuaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ndoꞌ nin juu na iquen ꞌuꞌ nnon tsꞌian na ninꞌcüjiꞌ juu cotonꞌ, mantyi ncyaꞌ na ngayꞌoon juu ndiaasoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ndoꞌ nin juu na itsꞌaa na ijndeiꞌhanꞌ na cjaꞌ yohin na ngichuꞌ xu ꞌnaanꞌ juu cüii kilómetro, cjaꞌ yohin min na ve kilómetros. ");
INSERT INTO azgNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tsꞌan na ican ꞌnan nnonꞌ, ncyaꞌhanꞌ nnon juu, ndoꞌ min tyiꞌntsintycüiꞌ ꞌnan nnon tsꞌan na ninꞌcüjiꞌ jnan ꞌnan nnonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Mantyi ꞌoꞌ jndë jndyehoꞌ jñꞌoon na tquen Moisés na coꞌxenhanꞌ: Cüiveꞌnchjiꞌ tsꞌan na ya jñꞌoon ꞌuꞌ, ndoꞌ tsꞌan na jndooꞌ ꞌuꞌ, cüejon quitsaꞌ yohin. ");
INSERT INTO azgNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Majoꞌ ndö vaa matsjö ndëëhoꞌ ntyja ꞌnaanꞌ juu jñꞌoonvaꞌ: Cüivengiohoꞌ joo nnꞌan na jndohin ꞌoꞌ, ndoꞌ quitanhoꞌ na quityio Tyoꞌtsꞌon jnꞌaan nque nnꞌan na contyꞌehinhoꞌ tsojnaanꞌ na conanꞌjonhoꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ee na ntꞌahoꞌ chaꞌxjen na matsjö, nnduihoꞌ ntsinda nquii tyehoꞌ na mꞌaan jon quiñoonꞌndue. Nquii jon itsꞌaa jon na juu ndoꞌcüjioonꞌ ꞌnaanꞌ jon ndyiaaꞌhanꞌ ndëë nnꞌan na ya nnꞌan ndoꞌ mantyi yo ndëë nnꞌan na tyia nnꞌan. Ndoꞌ mantyi itsquioo jon ndaatsuaꞌ ꞌnaanꞌ jon cjo nnꞌan na contꞌa chaꞌxjen na chuhanꞌ ndoꞌ mantyi cjo nnꞌan na conanꞌtja nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ngꞌe xe na aa veꞌ xiaꞌntyi nque nnꞌan na viꞌngiohinhoꞌ na conanꞌvengiohoꞌhin, ¿Aa conanꞌtiuhoꞌ ngꞌe joꞌ vaa naya ꞌnaanhoꞌ tonnon Tyoꞌtsꞌon? Quitquenhoꞌ cüenta, joo nnꞌan na cotyehin sꞌonndyuaa cüentaaꞌ gobiernon tsjoon Roma, manndaꞌ vaa contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ndoꞌ xe na aa veꞌ xiaꞌntyi joo nnꞌan na ya jñꞌoonhin yo ꞌoꞌ na concyahoꞌ tsꞌonhin, ¿Aa conanꞌtiuhoꞌ na tꞌman vaa na conanꞌquindëhoꞌ? Joo nnꞌan na tyiꞌquinanꞌtꞌmaanꞌ Tyoꞌtsꞌon, mantyi nndaꞌ vaa contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chaꞌxjen nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue, tsoñꞌen ntyja ꞌnaanꞌ jon conduihin na jndyoyuhin, mantyi manndaꞌ cꞌonhoꞌ quiiꞌ ntꞌan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ya na contꞌahoꞌ cüii nnon na chuhanꞌ ngꞌe na cotsantyjahoꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon, quitquenhoꞌ cüenta na chito contꞌahoꞌhanꞌ chaꞌ na quitquen nnꞌan cüenta ntyja ꞌnaanꞌhanꞌ. Ngꞌe xe na aa veꞌ tondëë nnꞌan contꞌahoꞌhanꞌ, tanaya ꞌnaanhoꞌ tonnon nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Mangꞌe joꞌ ya na matsaꞌ naya cüii tsꞌan, quitsaꞌ na ninncuꞌ cüintyjiꞌhanꞌ, tyiꞌntsixuaꞌ ndëë nnꞌan juu naya na matsaꞌ chaꞌxjen na contꞌa nnꞌan na veꞌ contꞌa nquehin na ya jndyi nnꞌanhin. Joo nnꞌan na covancüi ntꞌaanꞌon ndoꞌ natahinꞌ, contꞌa nanꞌñeen na quindye nnꞌan juu naya na contꞌahin chaꞌ quindue nanꞌñeen na ya jndyi nnꞌanhin. Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, xiaꞌntyi joꞌ naya ꞌnaanhin na joo ntyjehin conanꞌtꞌmaanꞌ nanꞌñeenhan. ");
INSERT INTO azgNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Majoꞌ ꞌuꞌ jeꞌ, ya na matejndeiꞌ cüii tsꞌan ꞌnan na itsitjahanꞌhin, minꞌncüii nnon tsꞌan tyiꞌntsuꞌ ntyja ꞌnaanꞌ ꞌnan na matsaꞌ, min tsꞌan na ya jndyi jñꞌoon yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yajoꞌ ntsꞌaahanꞌ na ninncuꞌ ntyjiꞌ juu naya na matsaꞌ. Majoꞌ nquii Tyeꞌ na indyiaaꞌ jon naya na matsaꞌ yo cüiichen tsꞌan na ninncuꞌ ntyjiꞌhanꞌ, ntsinon jon ꞌnan na icanhanꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Juu xjen na conanꞌneinhoꞌ nnon Tyoꞌtsꞌon, tantꞌahoꞌ chaꞌxjen contꞌa nnꞌan na veꞌ contꞌa nquehin na njon jndyihin tonnon Tyoꞌtsꞌon. Ngꞌe joohin ya jndyi ngiohin na quijntyꞌia nnꞌanhin xjen na minntyjeeꞌhin quityquiiꞌ ntꞌaanꞌon ndoꞌ nata na conanꞌneinhin nnon Tyoꞌtsꞌon. Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, xiaꞌntyi joꞌ naya ꞌnaanhin na vaa. ");
INSERT INTO azgNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Majoꞌ ꞌuꞌ, xjen na ntsininꞌ nnon Tyoꞌtsꞌon, caqueꞌ quityquiiꞌ vaꞌ, quitscuꞌ ꞌndyohanꞌ, joꞌ quitsininꞌ nnon Tyeꞌ na tatyiꞌncyooꞌhin, majoꞌ mꞌaan jon yo ꞌuꞌ joꞌ. Ndoꞌ nquii jon na conduihin Tyeꞌ na nchjii jon tsoñꞌen na tacovityincyo ndëë nnꞌan, ntsiquindaaꞌ jon tsoñꞌen na icanhanꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ya na conanꞌneinhoꞌ nnon Tyoꞌtsꞌon, tanduehoꞌ jñꞌoon na veꞌ ninjuuntyi ninjuuntyihanꞌ, chaꞌna contꞌa joo nnꞌan na tyiꞌquitajnꞌaanhin jon. Ee conanꞌtiuhin na ndyii jon ngꞌe ninjuu ninjuu jñꞌoon na conduehin. ");
INSERT INTO azgNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Majoꞌ ꞌoꞌ tyiꞌntꞌahoꞌ chaꞌxjen na contꞌahan, ngꞌe vitjachen na ngitanhoꞌ nnon jon, majndë nchjii jndaꞌ jon nin ꞌnan na icanhanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ndö vaa jñꞌoon na quinduehoꞌ nnon jon: Tyë́ na mꞌanꞌ quiñoonꞌndue, quitsꞌaahanꞌ na ninnquiiꞌchen cüitꞌmaanꞌ xueꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Juu na matyeꞌntjonꞌ, quindyo coꞌxenhanꞌ na vja na mꞌan. Quindui ꞌnan na ntꞌue tsonꞌ nnon tsonnangueva chaꞌxjen na conduihanꞌ quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ncyaꞌ ꞌnan na icanhanꞌ na ntcüꞌá xeevahin. ");
INSERT INTO azgNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Quitsitꞌman tsonꞌ já yo ꞌnan tyia na jndë jntꞌá chaꞌxjen conanꞌtꞌman nꞌö́n nnꞌan na conanꞌtjahin ndë́. ");
INSERT INTO azgNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Quitejndeiꞌ já na tyiꞌntyiiꞌhanꞌ ngꞌeehanꞌ já na ntꞌá ꞌnan na tyiꞌquichuhanꞌ, majoꞌ quitsiquindyaꞌ já tsoñꞌen nnon ꞌnantyia na ninꞌquitsiꞌndaaꞌhanꞌ já. Ngꞌe ntyjantyi xjen na tquenꞌ tsoñꞌen, ꞌuꞌ condui na macoꞌxenꞌ, ndoꞌ condui ꞌuꞌ najnduꞌ, ndoꞌ tsixuanꞌ na tsoñꞌen na tquenꞌ na cüitꞌmaanꞌ ꞌuꞌ ntyja ꞌnaanhanꞌ. Quindui na macꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ndoꞌ tsontyichen Jesús: “Xe na ꞌoꞌ conanꞌtꞌman nꞌonhoꞌ nnꞌan na conanꞌtjahin ndëëhoꞌ, yajoꞌ mantyi nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue, ntsitꞌman tsꞌon jon ꞌoꞌ na conanꞌtjahoꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Majoꞌ xe na aa tyiꞌconanꞌtꞌman nꞌonhoꞌ nque ntyjehoꞌ na conanꞌtjahin ndëëhoꞌ, mantyi nquii Tyeꞌhoꞌ tyiꞌxequitsitꞌman tsꞌon jon ꞌoꞌ ꞌnan na conanꞌtjahoꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Xjen na conanꞌquindëhoꞌ jñꞌoon na cotyjehoꞌ ꞌnan jndyuehoꞌ, tyiꞌntꞌa yahoꞌ na ntsiꞌmanhanꞌ na chjooꞌ nꞌonhoꞌ chaꞌ quitquen nnꞌan cüenta na juuhanꞌ contꞌahoꞌ. Mꞌan nnꞌan na veꞌ contꞌa yahin na cotyjehin ꞌnan jndyuehan chaꞌ quijntyꞌia nnꞌan na conanꞌquindëhin. Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, veꞌ ntyja ꞌnaanꞌ na cojntyꞌia nnꞌan na nndaꞌ contꞌahin, xiaꞌntyi joꞌ vaa naya ꞌnaanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Majoꞌ ꞌuꞌ, xjen na matyjeꞌ ꞌnan ꞌndyoꞌ, quimanꞌ nnonꞌ, quitscjoꞌyaꞌ xquenꞌ, ");
INSERT INTO azgNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Chaꞌ tyiꞌntsiꞌmanhanꞌ ndëë nnꞌan na matyjeꞌ ꞌnan ꞌndyoꞌ, majoꞌ nquii Tyeꞌ na mꞌaan jon quiñoonꞌndue, ntsiꞌmanhanꞌ nnon jon na juuhanꞌ matsaꞌ. Ndoꞌ nquii jon na ndyiaaꞌ jon ꞌnan na tatyiꞌncyo ndëë nnꞌan, nninncyaa jon tsoñꞌen na icanhanꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Min ꞌnan na conanꞌncüi nnꞌan na njon jndyihanꞌ na conanꞌqui nꞌonhinhanꞌ. Majoꞌ quintyꞌua conanꞌndaaꞌ oꞌhanꞌ ndoꞌ coꞌon tscüahanꞌ ndoꞌ mantyi coꞌoqueꞌ nanntyꞌuee ntꞌaa nanꞌñeen na ntjiꞌhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Majoꞌ ꞌnaanhoꞌ na njon jndyihanꞌ na conanꞌqui nꞌonhoꞌhanꞌ, quinanꞌncüihoꞌhanꞌ quiñoonꞌndue naijon na jeꞌcüaꞌ quintyꞌuahanꞌ, min na jeꞌcꞌon tscüahanꞌ ndoꞌ min na jeꞌcoqueꞌ nanntyꞌuee na ntjiꞌhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ngꞌe naijon na covave ꞌnan na njon jndyi na conanꞌncüihoꞌ, majoꞌ vijon mꞌaan na ndyiiꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ya na mandyiꞌ jñꞌoon na mayuuꞌ yo na xoncüeeꞌ tsonꞌ, itsijonhanꞌ ꞌuꞌ chaꞌna tsꞌan na tyincyo ya naxuee ndyiaaꞌ. Ngꞌe xjen mavaaꞌ tsonꞌ jñꞌoonꞌñeen, yajoꞌ itejndeihanꞌ ꞌuꞌ tsoñꞌen xuee na vamꞌanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Majoꞌ xe na aa tyiꞌninꞌquindyiꞌ jñꞌoon na mayuuꞌ, itsijonhanꞌ ntyja ꞌnanꞌ chaꞌvijon tsꞌan na tyiꞌya tënnon na mꞌaan juu na nchjaanꞌ juu. Ngꞌe min na mandyiꞌ jñꞌoonꞌñeen, majoꞌ tyiꞌjeꞌcüaaꞌ tsonꞌ na mayuuꞌhanꞌ, ngꞌe tyquiiꞌ tsonꞌ matsixuanꞌ chaꞌvijon najaan jndyi. ");
INSERT INTO azgNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Taminꞌncüii tsꞌan nndëë ntyeꞌntjontyen ndëë ve patrón na ninvi xjen. Ngꞌe ncꞌoon juu na tyiꞌcueeꞌ tsꞌon juu ncüii patrónꞌñeen ndoꞌ ncüiichenhin ncꞌoon juu na viꞌntyjii juuhin. Ee ntsꞌaahanꞌ na njon jndyi nchjii juu yo ncüiihan, majoꞌ cüiichenhin tyiꞌquinjonhin ntyjii juu. Xe na jen cojooꞌ nꞌonhoꞌ na nnanꞌtjonhoꞌ ꞌnan na nnintyahoꞌ, ntscuꞌhanꞌ na nnanꞌtꞌmaanꞌhoꞌ Tyoꞌtsꞌon, ngꞌe tyiꞌjeꞌquindëë ntyeꞌntjonhoꞌ ndëë ve nnonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Mangꞌe na nndaꞌ vaa, matsjö ndëëhoꞌ na tancꞌonhoꞌ na mꞌaanꞌ jndyi nꞌonhoꞌ nchu vaa na vja na mꞌanhoꞌ tsonnangueva, na nin ꞌnan ntcüaꞌhoꞌ, ndoꞌ na ncüehoꞌ, min ntyja ꞌnaan ndiaa na ntcüehoꞌ. Ngꞌe ntyjii Tyoꞌtsꞌon nchu vaa na cotandoꞌhoꞌ, majndeichen yo ꞌnan na ntcüaꞌhoꞌ. Ntyjii jon tsoñꞌen ntyja ꞌnaanhoꞌ, majndeichen yo ndiaa na ntcüehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Quitquen yahoꞌ cüenta ntyja ꞌnaan quintsa na maꞌntyja nandye. Joo oꞌ taconon oꞌ chaꞌ ngueꞌhanꞌ na ntyje oꞌ ndoꞌ na nnanꞌve oꞌhanꞌ na nninjntꞌue oꞌ ꞌiocha. Majoꞌ min na nndaꞌ, nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue, incyaa jon ꞌnan na cocüaꞌ oꞌ. Ndoꞌ ꞌoꞌ jeꞌ, ¿Aa chito njonchen nchjii jon yohoꞌ, chichen quintsahinꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Min tanin ncüii ꞌoꞌ nndëë ngüandoꞌntyihoꞌ ngꞌe na jndye jndyi mꞌaanꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Yajoꞌ ¿Ndu na mꞌaanꞌ jndyi nꞌonhoꞌ ntyja ꞌnaanꞌ ndiaa na ntcüehoꞌ? Quitquenhoꞌ cüenta ntyja ꞌnaan ntjaaꞌ jndëë ya na covindyehanꞌ. Nancooꞌ covaaꞌhanꞌ. Joohanꞌ min tacontꞌahanꞌ tsꞌian, min tacotoꞌñoonhanꞌ tsuan na nndë ndiaahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Majoꞌ quindyehoꞌ ntsjö: Juu rey Salomón, min na tya jndyihin, ndoꞌ tëquintyja na ya ꞌnan na tonanꞌchu jon, majoꞌ tyiꞌquitsijonhanꞌ na nancooꞌ ndiaa na tocüe jon chaꞌxjen nancooꞌ ncüii ntjaaꞌmin. ");
INSERT INTO azgNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ndoꞌ ngꞌe na nndaꞌ vaa na incyaa Tyoꞌtsꞌon na nancooꞌ ntjaaꞌ jndëë na veꞌ xeevaa ro minhanꞌ, ndoꞌ ꞌiocha coninjntꞌue nnꞌanhanꞌ na conanꞌquineinhan ꞌnan na cocüaꞌhan, majndeichen ntyjii jon yuu jon nnan ndiaa na ntcüehoꞌ, ꞌoꞌ na chjo jndyi vantyja nꞌonhoꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Joꞌ tajen ncꞌonhoꞌ jñuaanꞌ tsꞌon na nnduehoꞌ: ¿Nin ꞌnan ntꞌaha na nninjndaꞌ ꞌnan ntcüꞌa ndoꞌ na ncüë? ¿Nin ꞌnan ntꞌaha na nninjndaꞌ ndiaa ntcüë? ");
INSERT INTO azgNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ee joo nnꞌan na tyiꞌcꞌonhan ntyja ꞌnaanꞌ Tyoꞌtsꞌon, ninnquiiꞌchen mꞌaanꞌ nꞌonhin nanꞌminꞌ, majoꞌ nquii jon na conduihin Tyehoꞌ na mꞌaan jon quiñoonꞌndue, nchjii jndaꞌ jon na tsoñꞌen nanꞌminꞌ itsitjahanꞌhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Navejndyee quijntꞌuehoꞌ na nquii Tyoꞌtsꞌon ityeꞌntjon jon ꞌoꞌ. Ndoꞌ quintꞌahoꞌ ꞌnan na caveeꞌ tsꞌon jon ee xe na nndaꞌ tsamꞌanhoꞌ, ntsꞌaa jon na ndahoꞌ tsoñꞌen ꞌnan na icanhanꞌhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mangꞌe joꞌ tyiꞌncꞌonhoꞌ na mꞌaanꞌ jndyi nꞌonhoꞌ ꞌnan na nninjntꞌuehoꞌ ꞌiocha na tonnon. Xuee ꞌio ntsijndaꞌ nquiihanꞌ nin jñꞌoontiu na ncꞌonhoꞌ ntyja ꞌnaanꞌ ꞌnan na icanhanꞌ ꞌoꞌ. Juu naviꞌ na iquenon tsꞌan na ncüii ncüii xuee, maxjen condinon ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Tyiꞌntjiꞌhoꞌ cüenta na aa conanꞌtja nnꞌan, ngꞌe xe na aa ntꞌahoꞌhanꞌ, mantyi ncüjiꞌ Tyoꞌtsꞌon cüenta na conanꞌtjahoꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ngꞌe chaꞌxjen na cotjiꞌhoꞌ cüenta na aa conanꞌtja nnꞌan ndëëhoꞌ, manndaꞌ ncüjiꞌ jon cüenta na conanꞌtjahoꞌ nnon nquii jon. Machaꞌxjen na contꞌahoꞌ yo nnꞌan, manndaꞌ ntsꞌaa jon na quitꞌuii ntcüeꞌhanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Ndu na maquenꞌ cüenta ncüii nnon na tyiꞌtꞌman itsitja cüiichen tsꞌan ndoꞌ min ncuꞌ tyiꞌmaquenꞌ cüenta na tꞌman matsitja ꞌuꞌ? Na nndaꞌ matsaꞌ, itsijonhanꞌ ntyja ꞌnanꞌ chaꞌvijon na mandyiaꞌ jndëëꞌnꞌoon na tuahanꞌ tënnon cüii tsꞌan, majoꞌ minꞌchjo tyiꞌquenꞌtoꞌ cüenta na ñjon tsꞌoon tseiiꞌ vꞌaa tënnonꞌ ncuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ndoꞌ na nndaꞌ, tyiꞌquitsohanꞌ na ntsuꞌ nnon tsanꞌñeen: Cüa ntyjë, ncyaꞌ na ncüjiꞌ jndëëꞌnꞌoon na tua tënnonꞌ. Ndoꞌ majuuto xjenꞌñeen ninvaa ñjon tsꞌoon tseiiꞌ vꞌaa tënnonꞌ ncuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ꞌUꞌ na ve vaa na matsitiuꞌ, juu tsꞌoon tseiiꞌ vꞌaa na ñjon tënnonꞌ, cüjiꞌ jndyeeꞌhanꞌ, yajoꞌ xuee ndyiaꞌ na ncüjiꞌ jndëëꞌnꞌoon na ñjon tënnon tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ꞌNan na jiꞌua nanꞌxuanhanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon, tyiꞌninncyahoꞌhanꞌ ndëë nnꞌan na tyiꞌquinjonhanꞌ ngiohin. Ee xe na aa ntꞌahoꞌ na nndaꞌ, ntsijonhanꞌ ntyja ꞌnanꞌ chaꞌvijon ndëë quindueꞌ coninncyahoꞌ ꞌnan na nanꞌxuanhanꞌ cüentaaꞌ Tyoꞌtsꞌon. Ndoꞌ quindëꞌñeen ngüeꞌquen oꞌ ndoꞌ ntquii oꞌ ꞌoꞌ. Min tyiꞌninncyahoꞌ ꞌnan na njon jndyi nanꞌxuanhanꞌ ndëë nnꞌan na tyiꞌquinjonhanꞌ ngiohin. Ngꞌe xe na aa ntꞌahoꞌ na nndaꞌ, itsijonhanꞌ chaꞌvijon cotjueꞌhoꞌ tsꞌuaa tëꞌ perlas ndëë quintcu. Ndoꞌ choꞌñeen nndyue oꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Ninnquiiꞌchen quitanhoꞌ nnon Tyoꞌtsꞌon, yajoꞌ ncyꞌonhoꞌ cüenta ꞌnan na cotanhoꞌ. Ninnquiiꞌchen quijntꞌuehoꞌ nchu ya na quintꞌahoꞌ tonnon jon, ndoꞌ nninjndaꞌhanꞌ. Ninnquiiꞌchen quinanꞌmanhoꞌ nnon jon ꞌnan na coquenonhoꞌ, yajoꞌ ntsiquinaan jon tondëëhoꞌ chaꞌvijon na nnaan ꞌndyo vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ngꞌe ncüii ncüii tsꞌan na ninnquiiꞌchen ican juu nnon Tyoꞌtsꞌon, ncyꞌoon juu cüenta ꞌnan na ican juu. Ndoꞌ ncüii cüii tsꞌan na ninnquiiꞌchen ntꞌue juu nchu vaa na ntꞌue tsꞌon jon, mancüiixjen ncüaaꞌ tsꞌon juuhanꞌ. Ndoꞌ juu tsꞌan na ninnquiiꞌchen itsiꞌman nnon jon ꞌnan na iquenon, ntsiquinaan Tyoꞌtsꞌon tonnon tsanꞌñeen chaꞌvijon conaan ꞌndyo vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Juu jndaꞌ, xe na aa ntcan juu cüii tanꞌ tyooꞌ nnonꞌ, tyiꞌjeꞌncyaꞌ na veꞌ cüii tsjöꞌ nnon juu na ntcüaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ndoꞌ min xe na aa ntcan juu cüii quitscaa nnonꞌ na ntquii juu, tyiꞌjeꞌncyaꞌ veꞌ quitsu ntquii juu. ");
INSERT INTO azgNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ngꞌe na nndaꞌ, ꞌoꞌ na conduihoꞌ nnꞌan na tyia nnꞌanhoꞌ, xe ꞌoꞌ ngiohoꞌ nninncyahoꞌ ꞌnan ya ndëë ndahoꞌ, majndeichen nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue, nninncyaa jon ꞌnan na yantyichen ndëë nnꞌan na cotanhanꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Joꞌ tsoñꞌen ꞌnan na ntꞌue nꞌonhoꞌ na quintꞌa nnꞌan yo ꞌoꞌ, majoꞌntyi quintꞌahoꞌ yohin. Ee na ntsꞌaa tsꞌan na nndaꞌ, itsiquindëhanꞌ juu jñꞌoon na tquen Moisés na icoꞌxenhanꞌ, ndoꞌ mantyi jñꞌoon na jndui na tondue nnꞌan na itsiquindyihanꞌ ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Quitsaqueꞌhoꞌ ꞌndyo teon na quintuhanꞌ chaꞌ nndëë ncꞌonhoꞌ natooꞌ Tyoꞌtsꞌon. Ngꞌe vaa ꞌndyo teon tuen na ngaqueeꞌ tsꞌan nato tuen. Majoꞌ juu natoꞌñeen ngayꞌoonhanꞌ tsꞌan na ngitsuhin, ndoꞌ jndye jndyi nnꞌan cotsaqueꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Majoꞌ ꞌndyo teon na ngaqueeꞌ tsꞌan nato na ngayꞌoonhanꞌhin na tyiꞌquintycüii na ngüandoꞌ ñuaanꞌ juu, quintuviꞌhanꞌ ndoꞌ tyiꞌjndye nnꞌan condiohinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Quitquenhoꞌ cüenta yo nque nnꞌan na coninncyahin jñꞌoon na itsiviꞌnnꞌanhanꞌhoꞌ. Cotsquehin quiiꞌ ntꞌanhoꞌ ndoꞌ ngiohoꞌ na ndyiaꞌ nꞌonhin chaꞌxjen joo quinman ndyiaꞌ nꞌon oꞌ, majoꞌ quityquiiꞌ nꞌon nanꞌñeen nanꞌxuanhin nanviꞌ nnꞌanhin chaꞌvijon lobo. ");
INSERT INTO azgNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nndëë ncüaaꞌ nꞌonhoꞌ nchu vaa nanꞌxuanhin na cotquenhoꞌ cüenta ꞌnan na contꞌahin. Mangiohoꞌ na joo tëndöndyooꞌ tsjan, tyiꞌxeꞌquityjee tsꞌanhanꞌ nꞌoonneon, min tyiꞌxequityjee tsꞌan tëhigos tsonneonndye. ");
INSERT INTO azgNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nanꞌñeen itsijonhanꞌhin chaꞌvijon cüii tsꞌoon. Tsꞌoon ya, coveꞌ të ya, majoꞌ minꞌcya ro tsꞌoon na tyiꞌya, itsꞌaahanꞌ të tyiꞌya. ");
INSERT INTO azgNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Juu tsꞌoon ya xecueꞌ të tyiꞌyahanꞌ, majoꞌ juu tsꞌoon tyiꞌya, min tyiꞌxecueꞌ të yahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ncüii cüii tsꞌoon na tyiꞌquintꞌahanꞌ të ya, cotꞌuahanꞌ, ndë chi nguaahanꞌ nnon chon. ");
INSERT INTO azgNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Nndaꞌ vaa na ntajnꞌaanhoꞌ nin ꞌnan nanꞌxuan nanꞌñeen, ngꞌe ya na ntquenhoꞌ cüenta ꞌnan na contꞌahin, ntsiꞌman jndyoyuhanꞌ ndëëhoꞌ na chito jñꞌoon mayuuꞌ coninncyahin. ");
INSERT INTO azgNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Jndye nnꞌan conduehin nnön ta, majoꞌ chito tsoñꞌenhan ntsaqueꞌhan tyquiiꞌ juu na ityentjon Tyoꞌtsꞌon nnꞌan. Majoꞌ minninchen tsꞌan na ntsiquindë juu chaꞌxjen na ntꞌue tsꞌon Tyëhöꞌ na mꞌaan jon quiñoonꞌndue, juu tsanꞌñeen ngaqueeꞌ juu ntyja ꞌnaanꞌ na ityeꞌntjon jon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ya na ngüentyja xjen ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na jndë jnanꞌtjahin nnon jon, nnduehan nnön: Manchjiꞌ riiꞌ ta na jndë tyincyá já jñꞌoon naya ꞌnanꞌ yo juu najndei na matsixuanꞌ, ndoꞌ jndyetyia yo nanjndyi, jndë tjíꞌ jáhanꞌ quityquiiꞌ nꞌon nnꞌan, ndoꞌ yo najndei na condui ꞌuꞌ, jndë jntꞌá jndye nnon tsꞌian na tyiꞌxeꞌquinduihanꞌ yo na jndë nquë́. ");
INSERT INTO azgNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yajoꞌ ntsintcüꞌë jñꞌoon ndëë nanꞌñeen: Min tyiꞌcüajnꞌan ꞌoꞌ. Quenaanhoꞌ na tonnön, ꞌoꞌ na ninnquiiꞌchen tontꞌahoꞌ ꞌnan tyia. ");
INSERT INTO azgNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ncüii ncüii tsꞌan na indyii juu jñꞌoonmin na matsjö ndoꞌ vangueeꞌ juuhanꞌ, itsijonhanꞌ tsanꞌñeen chaꞌvijon tsꞌan na jndaꞌ xquen na sia vaaꞌ cjooꞌ tsjöꞌ na tyen minntyjeeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ndoꞌ tyioo ndaatsuaꞌ, jnduiꞌ ndaatsꞌo t'man, tyoo jndye tꞌman, taquiñjonhanꞌ vꞌaaꞌñeen, majoꞌ tatyioohanꞌ ngꞌe tyen minntyjeeꞌhanꞌ nacjooꞌ juu tsjöꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Majoꞌ ncüii cüii tsꞌan na indyii jñꞌoon na matsjö, majoꞌ tyiꞌquitsiquindë juuhanꞌ, itsijonhanꞌ tsanꞌñeen chaꞌvijon cüii tsꞌan na tyiꞌjndaꞌ xquen na veꞌ siato juu vaaꞌ juu cjooꞌ teiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ndoꞌ tyioo ndaatsuaꞌ, jnduiꞌ ndaatsꞌo tꞌman ndoꞌ jndei tyioo jndye. Tovaquiñjonhanꞌ juu vꞌaaꞌñeen, mana tyioohanꞌ. Tꞌman tsuhin ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Vi na jndë sinin Jesús tsoñꞌen jñꞌoonminꞌ, nnꞌan na jndye jndyiꞌhin na tondyehan jñꞌoon na toninncyaa jon, jndye tomꞌaanꞌ nꞌonhin ntyja ꞌnaanꞌ jñꞌoonꞌñeen, ");
INSERT INTO azgNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ngꞌe totsiꞌman jon ndëëhin chaꞌxjen tsꞌan na conintquehin na ityentjon, chito chaꞌxjen nnꞌan na tonanꞌman nchu vaa itsiquindyi juu ntji na tquen Moisés. ");
INSERT INTO azgNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Xjen na tjantcüeꞌ Jesús na jnan jon juu tyoꞌñeen, nnꞌan na jndye jndyiꞌhin tyentyjahan toxenꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ndoꞌ tyjeeꞌnon cüii tsansꞌa na chu ndöꞌ cotöꞌ, tconxtye juu tonnon jon, itso juu: —Nndaꞌ ta, nchji na vaa najndei na condui ꞌuꞌ na nndëë ntsinꞌmanꞌ ja xe na aa ntꞌue tsonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ndoꞌ tyio Jesús ntꞌö jon nacjooꞌ tsanviiꞌñeen, itso jon nnon juu: —Ntꞌue tsꞌön, cꞌonꞌ na jndë ntjo ya ntcüeꞌ ꞌuꞌ. Ndoꞌ ninñoonꞌ jnꞌman juu, mana tsu ndöꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ndoꞌ tso Jesús nnon juu: —Ndyeeꞌheꞌ, minꞌncüii nnon tsꞌan tyiꞌntsuꞌ nchu vaa sꞌa. Naneinhin cjaꞌ, quitsiꞌmanꞌ nnon tyee njan jaa nnꞌan judíos na jndë jnꞌmanꞌ, ndoꞌ juu quiooꞌ na itsiquindyi jñꞌoon na tquen Moisés na nninncyahoꞌ nnon Tyoꞌtsꞌon, juu oꞌ ncyaꞌ nnon tyeeꞌñeen. Ee na ntsiquindëꞌ na nndaꞌ, ntsiꞌman jndyoyuhanꞌ ndëë nnꞌan na jndë jnꞌmanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jndë na tëqueeꞌ Jesús tsjoon Capernaum, tëntyjaaꞌ ncüii capitán na mꞌaan jon. Juu tsanꞌñeen coꞌxen jon ncüii ciento sondaro cüentaaꞌ tsjoon Roma. Tcan jon na quitsꞌaa Jesús vi nayaꞌñeenꞌhin yohin. ");
INSERT INTO azgNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Itso jon: —Nndaꞌ ta, mioon jndyi iquenon moso njan na vaa juu vꞌa, iyꞌoon tycu coquenhin ndoꞌ iquii jndyihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tꞌa Jesús, itso jon: —Ncjö ntsinꞌmanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Majoꞌ sintcüeꞌ capitánꞌñeen jñꞌoon, itso jon: —Nndaꞌ Ta, tyiꞌquitsixuan na ngaqueꞌ quityquiiꞌ vꞌa. Majoꞌ veꞌ quitsuꞌ na quinꞌman moso njan, ndoꞌ nꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ngꞌe mantyi ja mꞌan nacje ꞌnaan nnꞌan na cotoꞌxenhin ja. Ndoꞌ mantyi mꞌan sondaro na macoꞌxën. Ya na maꞌua tsꞌian nnon ncüiihin, matsjö nnon juu: “Cjaꞌ ndöhin, ndoꞌ ncja juu.” Ndoꞌ ya na maꞌua tsꞌian nnon cüiichenhin: “Quindyoꞌ ntjoohin”, ndoꞌ nndyo juu. Ndoꞌ na ntsjö nnon moso njan: “Quitsaꞌ tsꞌianvaꞌ, ndoꞌ ntsꞌaa juuhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ndoꞌ vi na jndë jndyii Jesús jñꞌoon na tso tsanꞌñeen, tëveeꞌ jndyi tsꞌon jon. Tso jon ndëë nnꞌan na cotsantyja naxenꞌ jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, quiiꞌ ntꞌan ntyjëëhë nnꞌan Israel, minꞌjon tacontji ncüii tsꞌan na tꞌman vaa na vantyja tsꞌon juu Tyoꞌtsꞌon chaꞌna juu tsanvahin. ");
INSERT INTO azgNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Quitquenhoꞌ cüenta jñꞌoon na ntsjö, juu xjen ya na nnintyincyooꞌ ntyja na ityeꞌntjon Tyoꞌtsꞌon nnꞌan tsonnangue, nnan nnꞌan xiꞌjndiohanꞌ na ngüendyuaahan yo ndochihi Abraham, Isaac yo ninꞌJacob na ntcüaꞌ nanꞌñeen yohan. ");
INSERT INTO azgNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Majoꞌ nque nnꞌan judíos, joohin chuhanꞌ na nanꞌxuanhin juu na ityeꞌntjon Tyoꞌtsꞌon, ncüjiꞌhanꞌhin joꞌ. Ndoꞌ ncjuꞌhanꞌhin naijon na tëquintyja najaan, ndoꞌ joꞌ ncꞌonhan na nnanꞌxuaahan na ntsiꞌndaaꞌhanꞌ ngiohan. Ndoꞌ maninꞌnanꞌquiꞌioonꞌhin ndiꞌnꞌonhan na ntquiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jndë joꞌ tso Jesús nnon juu capitánꞌñeen: —Cjaꞌ ntcüeꞌ vaꞌ, ndoꞌ quindui chaꞌxjen na mavantyja tsonꞌ. Ndoꞌ majuuntyi xjenꞌñeen jnꞌman mosooꞌ juu capitánꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ndoꞌ tja Jesús vaaꞌ Pedro. Jndë na tëqueeꞌ jon joꞌ, jndyii jon jñꞌoon na juu tsanscu xeenꞌ Pedro, vaa tsanꞌñeen cjooꞌ jndu. Iyꞌoon tjuenꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Joꞌ tꞌui Jesús ntꞌö tsanscuꞌñeen. Ndoꞌ ninñoonꞌ jndya tjuenꞌhin. Jnanquintyja juu, taꞌ juu na sijñꞌoonꞌ juu na tcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ndoꞌ vi na jndë tua ndoꞌcüjioonꞌ, nnꞌan na nanꞌxuan jndyetyia, tyecho nnꞌan joohin na mꞌaan Jesús. Tcoꞌxen jon jndyetyiaꞌñeen na quinduiꞌhin quiiꞌ nꞌon nanꞌñeen. Mantyi sinꞌman jon tsoñꞌen nnꞌan vꞌi. ");
INSERT INTO azgNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Tui na nndaꞌ chaꞌ quitsiquindëhanꞌ jñꞌoon na jndui na toninncyaa Isaías ndyu na toxenꞌchen. Itso jon: “Manquii Tyoꞌtsꞌon tejndei jon jaa na tyiꞌjndeiꞌ nnꞌön. Ndoꞌ sinꞌman jon jaa tsoñꞌen nnon ntycu na coquenön.” ");
INSERT INTO azgNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ya na jndyiaaꞌ Jesús na jndye jndyi nnꞌan mꞌan xejndio ngiaaꞌ jon, tso jon ndëë nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon na quinanꞌjndaꞌhin vꞌaandaa na ngüeꞌjndyahan ndaandue. ");
INSERT INTO azgNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tantyjaaꞌ ncüii tsꞌan na tsiꞌman nchu vaa itsiquindyi ntji na tquen Moisés. Itso juu nnon Jesús: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndë́, minyuuchen na ncjaꞌ ntsijon ja yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Joꞌ sintcüeꞌ Jesús jñꞌoon nnon juu, itso jon: —Joo ndyondyehinꞌ min ndueꞌ oꞌ, ndoꞌ quintsahinꞌ min ntycya oꞌ, majoꞌ ja na condui tsansꞌa na tꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, min naijon na ngüajndyëë, taꞌnan yu ro. ");
INSERT INTO azgNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cüiichen tsꞌan na ivayꞌoon juu yo jñꞌoon na toninncyaa Jesús, itso juu nnon jon: —Ta, ncyaꞌ chjo jñꞌoon na ntixꞌë tyëhöꞌ ndoꞌ vi na jndë tyꞌiuhin, yajoꞌ yu jeꞌ, ngöyꞌön ja yo jñꞌoon na mancyaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tꞌa Jesús, itso jon: —Jndye nnꞌan mꞌanhin chaꞌvijon ntꞌoohin. Quiꞌndyiꞌ na quityꞌiu nque nanꞌñeen ntyjehin. Majoꞌ ꞌuꞌ quindyotsijon ꞌuꞌ yo jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Tua Jesús quityquiiꞌ vꞌaandaa ndoꞌ nnꞌan na tqueenꞌ jon na quitsayꞌonhan yo jñꞌoon na toninncyaa jon, tyꞌehin yo jon. ");
INSERT INTO azgNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ndö vaa ꞌnan tui, tyíꞌcovijndye na tyꞌehan, ndoꞌ tyioo ncüii jndye tꞌman nnon juu ndaandueꞌñeen, mavaaxjen na nchjehanꞌ vꞌaandaaꞌñeen ngꞌe juu ndaandueꞌñeen, jndei ijuhanꞌ. Ndoꞌ Jesús jeꞌ, itso jon. ");
INSERT INTO azgNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Yajoꞌ joo nnꞌan na tonanꞌjon jñꞌoon na toninncyaa jon, jnanꞌndyooꞌhin nnon jon, jnanꞌntcüihan jon, jnduehan: —Nndaꞌ ta, quitsinꞌmanꞌ jaa, ee juu vꞌaandaa na ñjön, mangua ndaahanꞌ na nchjehanꞌ juuhanꞌ na ntscüjehanꞌ jaa. ");
INSERT INTO azgNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tꞌa Jesús, itso jon: —ꞌOꞌ tyiꞌcovantyja ya nꞌonhoꞌ. ¿Ndu na coquityuehoꞌ? Ndoꞌ jnanquintyja jon, sityiaꞌ jon jndyeꞌñeen yo ndaandue, ndoꞌ tichen ntcüeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ndoꞌ sꞌaahanꞌ na jndye jndyi tꞌoon nꞌonhan na nndaꞌ tui, taxeeꞌhan ndëë ntyjehan: —Juu tsanvahin, ¿nin conduihin? Ata juu jndye yo ndaandue cotaꞌngueeꞌhanꞌ jñꞌoon na icoꞌxen jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jndë na tejndyahan juu ndaandueꞌñeen, squehan ndyuaa na jndyu Gadara. Joꞌ jnduiꞌhan vꞌaandaa. Ndoꞌ tyequitjon ve nnꞌan ndyuaaꞌñeen jon na ninnquiiꞌchen tomꞌanhan ndiꞌntꞌua ntꞌoo. Nanꞌxuan nanꞌñeen jndyetyia quiiꞌ nꞌonhan. Vjee jndyihan ata ndiquindëë ngüeꞌnon nnꞌan naijon na mꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tyeꞌ jnanꞌxuaahan, jnduehan: —ꞌUꞌ Jesús na condui ꞌuꞌ Jnda Tyoꞌtsꞌon, ¿Nin ꞌnan ntꞌue tsonꞌ yo já? ¿Aa jndyoꞌ na ntsaꞌviꞌ já, min na tyiꞌcoventyja xjen na ntꞌuiꞌviꞌ já? ");
INSERT INTO azgNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ndyo naijon mꞌan nanꞌñeen mꞌan cüii tmaanꞌ quintcu na cotqui oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ndoꞌ tan jndyetyiaꞌñeen cüii nayaꞌñeen nnon Jesús, jnduehan: —Xe na ncüjiꞌ já quityquiiꞌ nꞌon nanmin, ncyaꞌ jñꞌoon na ntsacꞌë́ quiiꞌ nꞌon quintcu na mꞌan ndöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tꞌa Jesús jndyuehan, tso jon: —Cüa, quinduiꞌhoꞌ. Yajoꞌ jnduiꞌ jndyetyiaꞌñeen, tyequeꞌhan quiiꞌ nꞌon joo choꞌñeen, ndoꞌ na nndaꞌ ninvaa tmaanꞌ oꞌ jnanꞌnon oꞌ, tyecue oꞌ naijon tyꞌa vaa na njoon jndyihanꞌ, joꞌ tequityeeꞌ oꞌ tyquiiꞌ ndaandue, tjë oꞌ na sava ndaa nquen oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ndoꞌ joo nnꞌan na totaꞌntyjeeꞌ choꞌñeen, jnanꞌnonhan, tyentcüeꞌhan tsjoonhan. Chen jndyi tonanꞌquindyiihan nchu vaa ꞌnan na tui na tjë oꞌ, ndoꞌ mantyi ntyja ꞌnaanꞌ na jnꞌman joo nanꞌñeen na tonanꞌxuanhan jndyetyia. ");
INSERT INTO azgNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ngꞌe na nndaꞌ, tsoñꞌen nnꞌan tsjoonꞌñeen jnduiꞌhan, tyequijntyꞌiahan Jesús. Ndoꞌ xjen na squehan naijon na mꞌaan jon, tanhin nnon jon na quitsꞌaa jon vi nayaꞌñeen na quinduiꞌ ntcüeꞌ jon ndyuaa tsjoonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jndë tui na nndaꞌ, tua nndaꞌ Jesús vꞌaandaa yo nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon. Teꞌjndya ntcüeꞌhin ndaandue. Squehan tsjoon naijon mꞌaan ya jon. ");
INSERT INTO azgNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Joꞌ squenon nnꞌan na mꞌaan jon, yꞌonhin cüii tsanviiꞌ, vaa juu cjooꞌ tsue. Tycu coquen tyꞌoonhin, ntjo ntjein ngꞌee juu. Ya na tquen Jesús cüenta vantyja nꞌon nanꞌñeen, tso jon nnon juu tsanviiꞌhin: —ꞌUꞌ jnda, cyonꞌ na tꞌman tsonꞌ. Ja jndë sitꞌman tsꞌön ꞌuꞌ jnan na tsixuanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ndoꞌ vendye nnꞌan na conanꞌman nchu vaa tsiꞌman jñꞌoon na tquen Moisés, vi na jndë jndyehan na nndaꞌ tso Jesús, jnanꞌtiuhan, jnduehan: “Tsanvaꞌ, jñꞌoon tsanꞌ itsinin juu, ee itsꞌaa juu na cüajon conduihin yo nquii Tyoꞌtsꞌon.” Nndaꞌ vaa na jndue nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Majoꞌ ntyjii Jesús nchu vaa conanꞌtiuhan, ngꞌe joꞌ taxeeꞌ jon ndëëhan: —¿Ndu na conanꞌtiuhoꞌ jñꞌoon viꞌ ntyja njan? ");
INSERT INTO azgNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Nin jñꞌoon na cotjiꞌhoꞌ cüenta na tyiꞌjndyaaꞌchen ntsjö nnon tsanvahin? “¿Aa na ntsjö nnon juu na matsitꞌman tsꞌönhin yo jnan na tsixuan juu?” Ndoꞌ “¿Aa ntsjö na quinanquintyja juu, cjaca juu?” ");
INSERT INTO azgNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Majoꞌ quitquenhoꞌ cüenta, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ntsjö jñꞌoon na jndyaaꞌntyichenhanꞌ ngiohoꞌ. Yajoꞌ vi na jndë jnꞌman tsanvaꞌ, ncüaaꞌ nꞌonhoꞌ na vaa najndö na matsixuan nnon tsonnangue na nndëë ntsitꞌman tsꞌön nnꞌan jnan na nanꞌxuanhan. Joꞌ tso jon nnon tsꞌan na ntjein ngꞌeeꞌhin: —Cüa, quinaquintyjaꞌ, quitsintcüiꞌ tsueꞌ ndoꞌ cjaꞌ vaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndoꞌ jnanquintyja juu, tja juu vaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndoꞌ nnꞌan na jndye jndyiꞌhin, vi na jndë jntyꞌiahin na nndaꞌ tui, tyuehin ndoꞌ tyincyaahanꞌ na nein jndyihin ndoꞌ tonanꞌtꞌmaanꞌhin Tyoꞌtsꞌon na nndaꞌ vaa tyincyaa jon najndei na tsixuan jon nnon Jesús na itejndei jon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jnduiꞌ Jesús joꞌ, tja jon na tonnonchen. Joꞌ jndyiaaꞌ jon ja Mateo. Tomꞌan vꞌaa naijon na mꞌan nnꞌan na cotye sꞌon cüentaaꞌ gobiernon tsjoon Roma. Tso jon nnön: —Quindyotsijon ꞌuꞌ yo jñꞌoon na mancya. Ndoꞌ jntyꞌi tsꞌianꞌñeen, ndoꞌ tyjë yo nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ndoꞌ ndö vaa ꞌnan na tui, vequityen Jesús mesa quiiꞌ vꞌa na cocüꞌá. Ñꞌen ntyjë na mantyi cotye sꞌon na cotyion nnꞌan ntyja ꞌnaanꞌ tsanmꞌaantsꞌian tsjoon Roma, ndoꞌ mantyi ñꞌen nnꞌan na cotjiꞌ nnꞌan cüenta ntyja ꞌnaanhan na conduihan nnꞌan na conanꞌtjahin nnon Tyoꞌtsꞌon. Ninvi tojnaanꞌ tovendyuaa nanꞌñeen yo nnꞌan na conanꞌjon jñꞌoon na toninncyaa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ndoꞌ joo nnꞌan tmaanꞌ fariseos, vi na jndë jntyꞌiahan na nndaꞌ sꞌaa jon, taxeeꞌhan ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, jnduehan ndëë nanꞌñeen: —¿Ndu na juu tsan na itsiꞌman ndëëhoꞌ icüaꞌ jon yo nnꞌan na cotye sꞌon ndoꞌ yo nnꞌan na cotjíꞌ cüenta na nanꞌxuanhan jnan tonnon Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Ndoꞌ vi na jndë jndyii Jesús na nndaꞌ conduehin, sinin jon jñꞌoon na itsijonhanꞌ juuhanꞌ ntyja ꞌnaan nanꞌñeen, itso jon: —Nnꞌan na tyiꞌvꞌi, tyiꞌicanhanꞌhin tsꞌan na ntsꞌaa nasihin. Majoꞌ nnꞌan vꞌi, joohan icanhanꞌhin tsꞌan na ntsꞌaa nasihin. ");
INSERT INTO azgNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Nquii Tyoꞌtsꞌon ntꞌue tsꞌon jon na cüaaꞌ nꞌonhoꞌ jñꞌoonva na itsohanꞌ: “Ja njon jndyi ntyji na ncꞌonhoꞌ na cüivengiohoꞌ nnꞌan, chichen na nnanꞌcueeꞌhoꞌ quiooꞌ na conanꞌtꞌmaanꞌhoꞌ ja yohanꞌ.” Ndoꞌ tsontyichen Jesús: —Quintꞌahoꞌ chaꞌxjen itsinin jñꞌoonꞌ Tyoꞌtsꞌon na jndui: “Ja chito jndyö na macꞌën nnꞌan na contꞌa ntyja na ntꞌue tsꞌon Tyoꞌtsꞌon. Joo nnꞌan na nanꞌxuan jnan, jndyö na macꞌënhin na quintcüeꞌ nꞌonhan.” ");
INSERT INTO azgNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nnꞌan na conanꞌjon jñꞌoon na toninncyaa Juan squehan na mꞌaan Jesús, taxeeꞌhan nnon jon: —Já yo nnꞌan tmaanꞌ fariseos cotyjë́ ꞌnan jndyuë́, majoꞌ joo nnꞌan na matsiꞌmanꞌ ndëë, tyiꞌcontꞌahan na nndaꞌ. ¿Ndu? ");
INSERT INTO azgNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tꞌa Jesús, sinin jon ncüii jñꞌoon ndëë nanꞌñeen na itꞌuiihanꞌ ntyja ꞌnaanꞌ nquii jon, tso jon: —Nnꞌan na conanꞌjon yo nquii tsansꞌa na ngoco, ¿Aa ncꞌonhan na chjooꞌ nꞌonhan viochen xjen na conditꞌmaanꞌ na ninvaa mꞌaan tsanꞌñeen tyquiiꞌ ntꞌanhin? Tyiꞌxeꞌquintꞌahan na nndaꞌ. Majoꞌ ngüentyja xuee na ntjiꞌ nnꞌan juu tsanꞌñeen quityquiiꞌ ntꞌanhan. Juu xjenꞌñeen nnanꞌchjooꞌ nꞌonhan ndoꞌ ntyjehan ꞌnan jndyuehan. ");
INSERT INTO azgNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ndoꞌ sininntyichen Jesús jñꞌoon na tyiꞌquitso nquiiꞌ jonhanꞌ ntyja ꞌnaanꞌ jñꞌoon xco na toninncyaa jon. Tso jon: “Vi tanꞌ ndiaa xco na tyiꞌcotmanhanꞌ, tyiꞌquichuhanꞌ na ncüjaaꞌ tsꞌanhanꞌ ndiaa ntsa. Ngꞌe xe na aa ntsꞌaa tsꞌan na nndaꞌ, juu ndiaa xcoꞌñeen ngateihanꞌ ndoꞌ ncꞌiooꞌhanꞌ juu ndiaa ntsaꞌñeen. Ndoꞌ na nndaꞌ, juu naijon na tꞌio ndiaaꞌñeen, tꞌmanntyichen ntꞌiohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Min ntjan quiooꞌ na cotyion nnꞌan ndaa vinon, majoꞌ tyiꞌjeꞌquityion nndaꞌ tsꞌan juu ndaaꞌñeen ntjan na jndë tijntꞌue tsꞌanhanꞌ toxenꞌ. Ngꞌe xe na aa nndaꞌ ntsꞌaa tsꞌan, joo ntjanꞌñeen ndiꞌndaaꞌhanꞌ ndoꞌ mantyi juu ndaa vinon na ñjonhanꞌ, nntcüeꞌhanꞌ. Ngꞌe na nndaꞌ, ndyion tsꞌan ndaa vinon xco tjan xco ndoꞌ na nndaꞌ, min juu tjanꞌñeen tyiꞌjeꞌcüiꞌndaaꞌhanꞌ min ndaa vinonꞌñeen tyiꞌjeꞌquitsuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ninvaa na itsinin Jesús jñꞌoonꞌñeen ndoꞌ ncüii tsꞌan juu tsjoonꞌñeen na conintquehin ntyja ꞌnaanꞌ vatsꞌon cüenta nnꞌan judíos, tyjeeꞌnon juu na mꞌaan Jesús. Tconxtye tsanꞌñeen nnon Jesús. Tso jon: —Quichenviꞌ tueꞌ yuscu chjo jnda, majoꞌ xe na aa ntsaꞌ vi nayaꞌñeen na ncjaꞌ quityioꞌ ntꞌöꞌ cjooꞌ juu, yajoꞌ ngüandoꞌ nndaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Maninñoonꞌ sicje Jesús, tantyja jon toxenꞌ tsanꞌñeen, mantyi já na totsayꞌö́n yo jñꞌoon na toninncyaa jon, sáñꞌë́n yohin. ");
INSERT INTO azgNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ndoꞌ majuuto xjenꞌñeen jndyontyja ncüii tsanscu toxenꞌ Jesús, mioon viiꞌ juu. Jndë nchoꞌve chu na cocꞌa neoonꞌ juu. Jndyotsindyooꞌhin toxenꞌ jon, tꞌuii juu ꞌndyo ndiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ngꞌe sitiu juu: “Xe veꞌ aa nndëë ntꞌui ndiaaꞌ jon, nnꞌman.” ");
INSERT INTO azgNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ndoꞌ nquii Jesús, tequen jon, jndyiaaꞌ jon nnon tsanscuꞌñeen. Tso jon nnon juu: —ꞌUꞌ jnda, cyonꞌ na tꞌman tsonꞌ. Ngꞌe na vantyja tsonꞌ ja, joꞌ na jndë jnꞌmanꞌ. Ndoꞌ majuuto xjenꞌñeen ntjo ya ntcüeꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ndoꞌ xjen na tueeꞌ Jesús vaaꞌ juu Jairoꞌñeen, tëqueeꞌ jon quiiꞌhanꞌ. Joꞌ jndyiaaꞌ jon mꞌan nnꞌan na cotjaꞌ nmaan na coninjndaꞌ na ngantyꞌiu juu tsꞌoo chjoꞌñeen. Conanꞌxuaa nnꞌan ndoꞌ cotyuee jndyihin. ");
INSERT INTO azgNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tso jon ndëëhin: —Cüa, quinduiꞌhoꞌ ntjoohin, yuscu chjovahin, chito aa tueꞌ juu, veꞌ itso juu. Majoꞌ jnanꞌcüejnaanꞌhin jon, veꞌ toncohin ngꞌe nndaꞌ tso jon. ");
INSERT INTO azgNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Majoꞌ vi na jndë tjiꞌ jon nanꞌñeen chꞌen, tëqueeꞌ jon naijon vequityen tsꞌoo chjoꞌñeen, joꞌ tꞌuii jon ntꞌö juu, ndoꞌ jnanquintyja juu. ");
INSERT INTO azgNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ndoꞌ na sꞌaa Jesús na nndaꞌ, tycya jñꞌoon ntyja ꞌnaanꞌhanꞌ ninvaa ntꞌö juu ndyuaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Xjen na jnduiꞌ Jesús vꞌaaꞌñeen, tentyja ve nnꞌan nchjan toxenꞌ jon. Tonanꞌxuaahan, jnduehan: —ꞌUꞌ ta na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cꞌonꞌ na ntyꞌia rö́ ntyjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Ndoꞌ vi na jndë tëqueeꞌ jon quityquiiꞌ vꞌaa, jnanꞌndyooꞌhin na mꞌaan jon. Taxeeꞌ jon ndëëhin: —¿Aa vantyja nꞌonhoꞌ na nndëë nninncya na njntyꞌia nndaꞌhoꞌ? Tꞌahan, jnduehan: —Ta, vantyja nꞌö́n. ");
INSERT INTO azgNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ngue ro jñoon ntꞌö jon tëndëëhin, ndoꞌ tso jon ndëëhin: —Quindui chaꞌxjen na vantyja nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ndoꞌ tyincyaahanꞌ na ya cojntyꞌiahan. Majoꞌ jaaꞌ jñꞌoon na tso jon ndëëhan na tyiꞌnanꞌquindyiihan nnꞌan na nndaꞌ sꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Majoꞌ taꞌnan jnanꞌquindëhinhanꞌ. Ee vi na jndë jnduiꞌhan juu vꞌaaꞌñeen, chen chen tonanꞌneinhan ndëë nnꞌan na mꞌan juu ndyuaaꞌñeen ꞌnan na sꞌaa Jesús yohan. ");
INSERT INTO azgNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Xjen na jnduiꞌ nanꞌñeen vꞌaaꞌñeen, sque mañoon nnꞌan na mꞌaan Jesús. Yꞌonhin cüii tsꞌan na tsixuan juu jndyetyia quiiꞌ tsꞌon juu na ndincyaahanꞌ na ntsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ndoꞌ vi na jndë tjiꞌ Jesús jndyetyiaꞌñeen quiiꞌ tsꞌon tsanꞌñeen, tyeꞌ tsinin juu. Ndoꞌ nnꞌan na jntyꞌia na tui na nndaꞌ, tyuehin ndoꞌ tomꞌanhan na neinhin. Jnduehan: —Jaa nnꞌan Israel, minꞌjon tacojntyꞌia na ntsꞌaa tsꞌan cüii tsꞌian tꞌman chaꞌ juu ꞌnan na sꞌaa Jesús ndöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Majoꞌ jnanꞌcüejnaanꞌ nnꞌan fariseos jon. Jnduehan: —Veꞌ ntyja ꞌnaanꞌ juu najndei na itsixuan nquii juu na conditque ndëë tsoñꞌen yotyia, joꞌ na condëë icüjiꞌ tsanvaꞌ yotyia quityquiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tomandyiꞌ Jesús tsochen njoon tꞌman yo njoon quijndë ndyuaa Galilea. Totsiꞌman jon ndëë nnꞌan na covancüi ntꞌaanꞌon. Toninncyaa jon jñꞌoon ntyja ꞌnaanꞌ na ityentjon Tyoꞌtsꞌon nnꞌan juu na cotsamꞌanhan. Ndoꞌ mantyi totsinꞌman jonhin ncüii cüii nnon ntycu na coquenonhan yo ncüii cüii nnon na tajndeiꞌ nꞌonhan na iquiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ya na jndyiaaꞌ jon ntmaanꞌ nnꞌan na jndye jndyiꞌhin, tꞌoon jon na ntyꞌia rohan ntyjii jon, ngꞌe mꞌanhan na ntycüii najndëhan na jndye vaa na mꞌaanꞌ nꞌonhan. Chaꞌvijon na cocyaatohan tyuaa na ndiquindëë na ncꞌontyihan. Itsijonhanꞌ ntyja ꞌnaanhin chaꞌxjen coquenon quinman na tatsꞌan ivantyjeeꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ndoꞌ taꞌ jon na itsiꞌman jon na jndye nnꞌan mꞌan na ndyehan jñꞌoonꞌ Tyoꞌtsꞌon, majoꞌ nnꞌan na nnanꞌneinhinhanꞌ ndëëhan, tyiꞌjndyehan. Ndëë joo nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon, sinin jon jñꞌoon na sijonhanꞌ juuhanꞌ yo juu nanꞌñeen. Tso jon: —Jñꞌoon na mayuuꞌ jndye jndyi ntjon na tueꞌ, majoꞌ tyiꞌjndye nanntjon mꞌan na ntyjehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Mangꞌe joꞌ quitanhoꞌ nnon nquii jon na ꞌnaanꞌ joo ntjonꞌñeen na quijñon jon nnꞌan na quitsaquityjehin ntjon ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tqueenꞌ Jesús já nnꞌan na nchoꞌve. Tyincyaa jon na mantyi nanꞌxuán juu najndei na condui nquii jon chaꞌ ntjíꞌ jndyetyia quiiꞌ nꞌon nnꞌan, ndoꞌ na quinanꞌnꞌmán nnꞌan tsoñꞌen nnon ntycu vjee yo tsoñꞌen nnon na tajndeiꞌ nꞌonhan na iquiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Ndö nguë́ já nnꞌan na nchoꞌve na tꞌua jon tsꞌian ꞌnaanꞌ jon ndë́. Naminjndyee Simón, na mantyi xueeꞌ jon Pedro, jndë ve, tyje jon Andrés, ndë joꞌ Santiago yo tyje jon Juan, joohan ntsinda Zebedeo, ");
INSERT INTO azgNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe yo Bartolomé, Tomás yo ja Mateo na toquë sꞌon ꞌnaanꞌ gobiernon tsjoon Roma, ndoꞌ Santiago jnda Alfeo yo Tadeo, ");
INSERT INTO azgNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yo Simón, tsan na totsijonhin yo tuaanꞌ nnꞌan na tonanꞌvehan nacjooꞌ gobiernon tsjoon Roma, ndoꞌ yo ninꞌJudas Iscariote, tsan na jndëcya tyincyaa juu cüenta Jesús nduee nnꞌan na jnanꞌcueeꞌhanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ndoꞌ ndö vaa tsꞌian na tꞌua Jesús ndë́ na nchoꞌve já na tji jon, tso jon: —Tyiꞌntsaqueꞌhoꞌ quiiꞌ ntꞌan nnꞌan na chito conduihan ntyjë nnꞌan judíos, ndoꞌ min tyiꞌntsaqueꞌhoꞌ njoon na mꞌan nnꞌan ndyuaa Samaria. ");
INSERT INTO azgNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xiaꞌntyi cꞌohoꞌ na mꞌan ntyjeehoꞌ nnꞌan Israel, na conduihan chaꞌvijon quinman na jndë tsu. ");
INSERT INTO azgNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Viochen na cotsacondyiꞌhoꞌ, ndö jñꞌoon quinduehoꞌ ndëë nnꞌan: Quitquenhoꞌ cüenta na nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue, jndë tentyja xjen na ninncyahoꞌ na ntyeꞌntjon jon ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ndoꞌ tsontyichen Jesús ndë́: Quinanꞌnꞌmanhoꞌ nnꞌan vꞌi yo nnꞌan na cho ndöꞌ cotöꞌ. Quintꞌahoꞌ na ntaꞌndoꞌ xco nnꞌan na jndë tjë. Quitjiꞌhoꞌ jndyetyia quiiꞌ nꞌon nnꞌan. Juu nayavahin, veꞌ yu tyincyaa Tyoꞌtsꞌon na nanꞌxuanhoꞌhanꞌ. Mantyi ꞌoꞌ tyiꞌntaꞌntjonhoꞌ xoquituꞌ ndëë nnꞌan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Tyiꞌntsachohoꞌ sꞌon ijan, min sꞌon xuee min sꞌon ve na ñjon chetsjaꞌ na ntyjahanꞌ ndiꞌntscuꞌhoꞌ na ntsaquintꞌahoꞌ tsꞌian njan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Min tyiꞌntsachohoꞌ nchetsjaꞌ na ncꞌohoꞌ nato na ñjon ꞌnan na ndijntꞌuehoꞌ, min ncüiichen ntjo ndiaa, min ntcon, min tsꞌoon na ntyjahoꞌ. Ngꞌe chaꞌxjen ivantjon tsꞌan yo tsꞌian na itsꞌaa juu, manndaꞌ chuhanꞌ na nndahoꞌ ꞌnan na icanhanꞌhoꞌ na cotyeꞌntjonhoꞌ nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ndoꞌ minninchen tsjoon na ntsquehoꞌ, min na aa tꞌmanhanꞌ, ndoꞌ min na aa chjohanꞌ, chen quijntꞌuehoꞌ nin tsꞌan na itsꞌaa na njon jñꞌoonꞌ Tyoꞌtsꞌon na ncyꞌoon juu cüentahoꞌ vaaꞌ juu na ntixeeꞌ juu ꞌoꞌ. Joꞌ quintjohoꞌ vaaꞌ tsanꞌñeen ata xjen na nnduiꞌ ntcüehoꞌ juu tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Juu xjen na ncꞌoqueꞌhoꞌ vꞌaaꞌñeen, quitanhoꞌ na quityio Tyoꞌtsꞌon jnꞌaan nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ndoꞌ joohan, xe na aa ya nnꞌanhin, yajoꞌ ndyio jon jnꞌaanhin. Majoꞌ xe na aa tyiꞌquinanꞌxuan nanꞌñeen na ncyꞌonhan cüenta juu nayaꞌñeen, yajoꞌ tyiꞌxeꞌquitsꞌaa Tyoꞌtsꞌon chaꞌxjen na cotanhoꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ndoꞌ nnꞌan tsjoonꞌñeen, xe na aa taꞌnan ncüiihan na ninꞌcyꞌoon juu cüentahoꞌ na ntixeeꞌ juuhoꞌ, min tyiꞌninquiꞌndyii juu jñꞌoon na coninncyahoꞌ, juu xjen na nduiꞌhoꞌ vaaꞌ juu oo tsjoonꞌñeen, quinanꞌcyaahoꞌ tsꞌojndë na chuuꞌ ngꞌehoꞌ. Na ntꞌahoꞌ na nndaꞌ, ncüjiꞌ jndyoyuhanꞌ na joo nanꞌñeen tyiꞌninꞌcyꞌonhan cüenta juu jñꞌoonꞌ Tyoꞌtsꞌon na coninncyahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, nnꞌan tsjoonꞌñeen juu xuee ya na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na tonanꞌtjahan nnon jon, tꞌmanntyichen ntꞌuiiviꞌhanꞌhin, chichen juu naviꞌ na isquioo jon cjo nnꞌan tsjoon Sodoma yo Gomorra. ");
INSERT INTO azgNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Quitquenhoꞌ cüenta, ꞌoꞌ na conduihoꞌ chaꞌvijon quinman, majñönhoꞌ quiiꞌ ntꞌan nnꞌan na conduihan chaꞌvijon lobo. Ngꞌe joꞌ, chaꞌxjen quindu mꞌan na jndaꞌ nquen oꞌ, mantyi ꞌoꞌ cꞌonhoꞌ na jndaꞌ nquenhoꞌ na tyiꞌntsiviꞌnnꞌanhanꞌ ꞌoꞌ. Ndoꞌ chaꞌxjen tyiꞌmanyaanꞌ quituꞌ, manndaꞌ vaa cꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tyiꞌncꞌonhoꞌ na conanꞌqui nꞌonhoꞌ nnꞌan ee nninncyahan cüentahoꞌ nduee nanmꞌannꞌian, ndoꞌ nanꞌñeen ntjiꞌhan tsꞌian na ngichꞌohoꞌ quityquiiꞌ ntꞌaanꞌon ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ndoꞌ ngꞌe na conduihoꞌ nnꞌan na mꞌan ntyja njan, nntꞌahan na ngüentyjeeꞌhoꞌ tondëë nnꞌan na conduihan gobiernon ndoꞌ mantyi ndëë nnꞌan na tëquintyja tꞌman condui. Ndoꞌ na nndaꞌ, nninncyaahanꞌ na ntjiꞌ jndyoyuhoꞌ ndëëhin ntyja njan ndoꞌ mantyi ndëë nnꞌan na tyiꞌquinanꞌtꞌmaanꞌhan nquii Tyoꞌtsꞌon na vandoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ya na nninncyahan cüentahoꞌ, tyiꞌncꞌonhoꞌ jñmaanꞌ tsꞌon na nin jñꞌoon nnanꞌntcüeꞌhoꞌ ndëëhan. Ngꞌe majuuntyi xjenꞌñeen nninncyaa Tyoꞌtsꞌon nin jñꞌoon na nnanꞌntcüeꞌhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ee nquii Espíritu na condui nquii tyehoꞌ Tyoꞌtsꞌon, ntsiꞌman jon nin jñꞌoon na nnanꞌntcüeꞌhoꞌ, tyiꞌxeꞌcanhanꞌ na nnanꞌntcüeꞌhoꞌ jñꞌoon ndëë nanꞌñeen veꞌ yo na jndaꞌ nquen nquehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Mꞌan nnꞌan na ninncüii tsꞌan ntsindahin na nninncyahan ntyjehin nduee nanmꞌannꞌian chaꞌ nnanꞌcüje nanꞌñeen joo. Ndoꞌ mantyi mꞌan nnꞌan na nninncyahin ndahin nduee nanmꞌannꞌian chaꞌ nnanꞌcüje nanꞌñeen joo. Ndoꞌ majoꞌntyi nntꞌa nda nnꞌan chaꞌ cüje tye ndyee joo. ");
INSERT INTO azgNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndoꞌ tsoñꞌen nnꞌan ncꞌonhan na tyiꞌquijndooꞌhan ꞌoꞌ ngꞌe na conduihoꞌ ntyja njan. Majoꞌ juu tsꞌan na ntjotyen ntyja njan ata juu xjen na ntycüii tsoñꞌen, ntsinꞌman Tyoꞌtsꞌon ñuan ꞌnaanꞌ tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nnꞌan ncüii tsjoon, xjen na contyꞌehan ꞌoꞌ, quinanonhoꞌ, cꞌohoꞌ cüiichen joo. Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, nndyo ntcüꞌë nntꞌa. Majoꞌ ninjoꞌ mꞌanchen njoon ndyuaa na mꞌan nnꞌan Israel na tyiꞌcotsquehoꞌ na nninncyahoꞌ jñꞌoon naya ntyja njan ndëëhin juu xjen na nncüjë ntcüꞌë. ");
INSERT INTO azgNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Já nnꞌan na tꞌman Jesús na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, sininntyichen jon jñꞌoon ndë́ ntyja ꞌnaanꞌ juu tsꞌian na tsixuan nquii jon. Tso jon: “Juu tsꞌan na itsijnaanꞌ, tyiꞌtꞌman conduihin chaꞌxjen nquii mastro ꞌnaanꞌ juu. Min juu tsꞌan na tyeꞌntjon nnon patrón, tyiꞌtꞌman conduihin chaꞌxjen nquii patrónꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Juu tsꞌan na itsijnaanꞌ, quintjo ya ntyjii juu na cüejon iquenon juu chaꞌxjen na iquenon nquii tsꞌan na itsiꞌman nnon juu. Ndoꞌ mantyi juu tsꞌan na ityeꞌntjon nnon patrón, quintjo ya ntyjii juu na cüejon iquenon juu chaꞌxjen na iquenon nquii tsanꞌñeen na ityeꞌntjon juu nnon. Ncö na condui ja tsꞌan na conditque ndëë nnꞌan vꞌaa, condue nnꞌan na tsixuan Beelzebú, ꞌoꞌ na cotyeꞌntjonhoꞌ nnön, mantyi nndaꞌ nnduehan cjohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Majoꞌ ꞌoꞌ tyiꞌndyuehoꞌ na nin ꞌnan nntꞌa nnꞌanhoꞌ. Ngꞌe tsoñꞌen na vantyꞌiu mꞌanhanꞌ, ngüentyja xjen na nnintyincyooꞌ jndyoyuhanꞌ. Ndoꞌ juu jñꞌoon na tyiꞌcondye nnꞌan, ncüaaꞌ nꞌonhan nchu vaa itsiquindyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Mangꞌe joꞌ, jñꞌoon na matsinën ndëëhoꞌ na tyiꞌmatsjö ncꞌihanꞌ, quinanꞌnein jndyoyuhoꞌhanꞌ ndëë nnꞌan. Ndoꞌ jñꞌoon na matsinën ndëëhoꞌ na ninnquehoꞌ, quinduehoꞌhanꞌ ndëë tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Joo nnꞌan na conanꞌcüje ntyje, majoꞌ tyiꞌjeꞌquindëë ntꞌahin na ngitsu ñuaanhoꞌ, tyiꞌndyuehoꞌhin. ꞌOꞌ cꞌonhoꞌ na ncyaahoꞌ Tyoꞌtsꞌon na nquii jon vaa najndei na conduihin na ncjuꞌ jon siꞌtsꞌo ꞌnaanꞌ tsꞌan yo ñuaanꞌ tsꞌan quiiꞌ vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“ꞌOꞌ mangiohoꞌ na tyiꞌjnda coninjntꞌua ve quintsa quijndë. Majoꞌ nquii Tyehoꞌ Tyoꞌtsꞌon iquen jon cüenta joo oꞌ. Nchjii jndaꞌ jon ya na ngovje ncüii cüii joo oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ndoꞌ ata ntyjii jndaꞌ jon tsaꞌnndaꞌ sonquenhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mangꞌe joꞌ, tyiꞌndyuehoꞌ, ngꞌe ꞌoꞌ njonntyichen ntyjii jon, nchichen na jndye quintsa quijndë. ");
INSERT INTO azgNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Minninchen tsꞌan na icüjiꞌ jndyoyu juu ntyja njan tondëë nnꞌan, mantyi nnon Tyëhöꞌ na mꞌaan quiñoonꞌndue, ja ncüjiꞌ jndyoyu nnon jon na condui tsanꞌñeen ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Majoꞌ minninchen tsꞌan na icüjihin ntyja njan, mantsjö nnon Tyëhöꞌ na min tyiꞌquitsixuan tsanꞌñeen ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Tyiꞌnanꞌtiuhoꞌ na jndyö tsonnangue chaꞌ ya ncꞌon nnꞌan yo ntyjehan. Chito juu tsꞌian jndyö. Ja jndyö na ncꞌon nnꞌan cjo ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ee ntyja njan ja, ncꞌoon tsansꞌa na tyiꞌcüejon jñꞌoonhin yo tye juu, mantyi tsanscu yo ndyee juu, ndoꞌ mantyi tsanntsa yo nquii tsanscu xeenꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ata ntsꞌaahanꞌ na nque nnꞌan vaaꞌ tsꞌan na vantyja tsꞌon juu ja, joohin ata xjen nnanꞌvjehanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Minninchen tsꞌan na njonntyichen ntyjii juu tye juu ndoꞌ ndyee juu, chichen ja, tyiꞌquitsixuan tsanꞌñeen na ncꞌoon juu ntyja njan. Mantyi minninchen tsꞌan na itsiviꞌntyjiichen juu jnda juu yusꞌa, yuscu, chintyichen ja, tyiꞌquitsixuan tsanꞌñeen na ncꞌoon juu ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Chaꞌ na ndëë ntsijon tsꞌan ntyja njan, chuhanꞌ na quintjo ya ntyjii jon ꞌnan viꞌ na iquenon juu. Xe na aa tyiꞌntsꞌaa juu na nndaꞌ, xeꞌquindëë ntsixuan juu ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ntyja ꞌnaanꞌ na vamꞌaan tsꞌan, xe na aa ntsichon juu na ndui chaꞌxjen na ntꞌue tsꞌon nquii juu chaꞌ ncyꞌoon Tyoꞌtsꞌon cüentahin, ngitsuhin ntyja ꞌnaanꞌhanꞌ. Ngꞌe minꞌcya ro tsꞌan na incyaa na quitjon nin ꞌnan na ngenon ngꞌe na mꞌaan juu ntyja njan, ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu. Majoꞌ minꞌcya ro tsꞌan na ntꞌue nquii nchu ya chaꞌ ntyja ꞌnaanꞌ joꞌ ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu, majndaꞌ ntyja ꞌnaan ꞌnan na itsꞌaa tsanꞌñeen, ngitsu ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Minꞌcya ro tsꞌan na ntsintjooꞌ juu ꞌoꞌ, mantyi ja itsintjooꞌ tsanꞌñeen. Ndoꞌ juu tsꞌan na ntsintjooꞌ ja, mantyi itsintjooꞌ tsanꞌñeen nquii Tyëhöꞌ na jñon jon ja quiiꞌ ntꞌan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ndoꞌ minninchen tsꞌan na ntsintjooꞌ juu ncüii tsꞌan na incyaa jñꞌoon ngꞌe na jñꞌoonꞌ Tyoꞌtsꞌonhanꞌ, ncyꞌoon tsanꞌñeen maninjuu naya chaꞌxjen juu naya na ncyꞌoon tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon. Ndoꞌ minninchen tsꞌan na ntsintjooꞌ juu ncüii tsꞌan na itsijonhin chaꞌxjen na chuhanꞌ na cꞌoon tsꞌan na tonnon Tyoꞌtsꞌon, ngꞌe ntꞌue tsanꞌñeen na ntsꞌaa juu na nndaꞌ, tsanꞌñeen ncyꞌoon juu cüenta maninjuu naya chaꞌxjen juu naya na ncyꞌoon nquii tsꞌan na itsꞌaahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ndoꞌ jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minninchen tsꞌan na ninncyaa min veꞌ chjoviꞌ ndaatioo tein na ncꞌu ncüii tsꞌan na itsijonhin yo ja, tanin min na aa tyiꞌtꞌman conduihin, majndaꞌ vaa naya na ncyꞌoon juu cüenta.” ");
INSERT INTO azgNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Ndoꞌ ya na jndë siꞌman Jesús jñꞌoonminꞌ ndë́ na nchoꞌve já na tꞌman jon na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, yajoꞌ jnduiꞌ jon joꞌ. Tja jon na ntsiꞌman jon ndoꞌ na nninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan na mꞌan njoon ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ndoꞌ juu Juan, tsan na totsiquindëëꞌ nnꞌan, xjenꞌñeen ndyiiꞌ jon vancjo. Joꞌ jndyii jon jñꞌoon ntyja ꞌnaanꞌ juu tsꞌian na itsꞌaa Cristo. Joꞌ tꞌua Juan tsꞌian ndëë ve ndye nnꞌan na tꞌman jon na quitsayꞌonhan yo jñꞌoon na incyaa jon na cꞌotaꞌxeeꞌhan cüii jñꞌoon nnon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jndue nanꞌñeen nnon jon: —¿Aa condui ꞌuꞌ nquii jon na tso jñꞌoonꞌ Tyoꞌtsꞌon na nndyo jon nnon tsonnangue, oo aa ngüentꞌö́ na ncüjeeꞌ cüiichen tsꞌan? ");
INSERT INTO azgNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ndoꞌ joꞌ tꞌa Jesús jndyuehan, tso jon: “Quitsantcüeꞌhoꞌ na mꞌaan Juan, quinduehoꞌ nnon jon nchu vaa jñꞌoon na condyehoꞌ na mancya, yo na cojntyꞌia ndëëhoꞌ na jndye nnꞌan conꞌmanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Quinduehoꞌ nnon jon na joo nnꞌan na nintomꞌanhin na nchjanhin, naneinhin xuee cojntyꞌiahin. Joo nnꞌan na tomꞌan na ntjein ngꞌe, nein ya cotsacaꞌhin. Joo nnꞌan na nintoquichohin tycu ndöꞌ cotöꞌ, jndë jnꞌmanhin. Joo nnꞌan na nintomꞌanhin na quitahin, nein ya condyehin. Joo nnꞌan na jndë tjë, cotandoꞌ xcohin. Ndoꞌ joo nnꞌan na ntyꞌia jndyihan, jndë macondyehan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ndoꞌ juu tsꞌan na tyiꞌvacüaaꞌhin ntyja njan, condui tsanꞌñeen tsꞌan na neiinꞌ juu na tonnon Tyoꞌtsꞌon.” Jñꞌoonminꞌ sinin Jesús ndëë nanꞌñeen na jñon Juan. ");
INSERT INTO azgNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ndoꞌ vi na jndë na tyentcüeꞌ nanꞌñeen, taꞌ Jesús na sinin jon ntyja ꞌnaanꞌ Juan ndëë tmaanꞌ nnꞌan na mꞌan xiꞌjndio ngiaaꞌ jon. Tso jon: “Juu xjen na tyꞌehoꞌ jndëë naijon tomꞌaan Juan, ¿Nchu vaa na tjiꞌhoꞌ cüenta na tsixuan jon? ¿Aa jntyꞌiahoꞌhin chaꞌna tsꞌan na ve vaa itsinin na sijonhanꞌhin chaꞌvijon cüii tsmaan tsꞌon na nayꞌoon jndyehanꞌ? Chito nndaꞌ totsixuan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ndoꞌ na nndaꞌ, yajoꞌ ¿Nin ncüii nnon jnanꞌtiuhoꞌ na tsixuan jon na tyequijntyꞌiahoꞌhin? ¿Aa jntyꞌiahoꞌhin na conduihin ncüii tsꞌan na cüe ndiaa na njon jndyi? Min chitojoꞌ. ꞌOꞌ ngiohoꞌ xiaꞌntyi nnꞌan na tꞌmanntyi conduihin, joohan cocüehan ndiaa na njon jndyi. ");
INSERT INTO azgNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Yajoꞌ ¿Nin ꞌnan tꞌoonꞌ nꞌonhoꞌ na tyequijntyꞌiahoꞌhin? Ja nchji na tyequijntyꞌiahoꞌ cüii tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. Ndoꞌ juu jon tꞌmanntyichen conduihin quityquiiꞌ tsꞌianꞌñeen, chito tsoñꞌen nnꞌan na coninncya jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juu jñꞌoonꞌ jon na jndui, itsininhanꞌ ntyja ꞌnaanꞌ juu Juanꞌñeen. Ndö vaa na itsohanꞌ: Majñön moso njan na vja jndyee jon na tonnonꞌ. Jñꞌoon na nninncyaa jon ntejndeihanꞌ nnꞌan na nnanꞌcjehan na nndyehan jñꞌoon na nninncyaꞌ vi na jndë tueꞌ quiiꞌ ntꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tsontyichen Jesús: “Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, juu Juan, tsan na totsiquindëëꞌ nnꞌan, minꞌjon tatꞌoon cüii tsꞌan na tondui tꞌmanhin tonnon Tyoꞌtsꞌon chaꞌna nquii jon. Majoꞌ min na nndaꞌ totsixuan jon, minninchen tsꞌan na nninncyaahin na ityentjon Tyoꞌtsꞌon juu na vamꞌaan juu, tꞌmanntyichen condui tsanꞌñeen, chichen nquii Juan.” ");
INSERT INTO azgNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ndoꞌ sininntyichen Jesús ndëë nnꞌan, itso jon: “Nquii Juan, tsan na totsiquindëëꞌ nnꞌan, xjen na taꞌ jon na toninncyaa jon jñꞌoon, jndye nnꞌan condyehan na iꞌman Tyoꞌtsꞌonhan na quinanꞌjonhan na ntyeꞌntjon jonhan, ndoꞌ ñꞌenhan na conanꞌchonhan na nnanꞌjonhan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Tsoñꞌen jñꞌoonꞌ Tyoꞌtsꞌon na toninncya nnꞌan ndyu na toxenꞌchen yo jñꞌoon na tquen Moisés, ninnquiiꞌ conanꞌmanhanꞌ nchu vaa na ityentjon Tyoꞌtsꞌon nnꞌan juu na cotsamꞌanhan. Ndoꞌ ya na tyeꞌ na toninncyaa Juan jñꞌoonꞌ jon, siꞌman juu na jndë tentyja xjen na ntyentjon Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ndoꞌ xe na aa mꞌan cjehoꞌ na ngantyja nꞌonhoꞌ jñꞌoonvahin, nquii Juan conduihin juu Elías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon cominndooꞌhoꞌ na nndyo nndaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Minninchen tsꞌan na min ndöꞌnqui na ndyii jñꞌoon na matsjö, cüaaꞌ tsꞌon juuhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ndoꞌ tsontyichen Jesús: “Nque nnꞌan na mꞌan nanein, ¿Nin jñꞌoon na ntsijönꞌ ja ntyja ꞌnaanhin? Itsijonhanꞌhin chaꞌvijon yotsca na concyꞌo nata quiiꞌ tsjoon. ");
INSERT INTO azgNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Conanꞌxuaa yoꞌñeen ndëë ntyje joo, condue joo: Jndë tjáꞌ tsuaan juu son na cotjaꞌ na cotonco nnꞌan, majoꞌ ꞌoꞌ tajnanꞌjnonhoꞌ. Jndë joꞌ tjáꞌ son na vaquityen tsꞌoo chjo, majoꞌ ꞌoꞌ tatyueehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Manndaꞌ itsijonhanꞌ na contꞌa nnꞌan na mꞌan nein. Jndyo Juan quiiꞌ ntꞌanhoꞌ, ntyꞌia jndyi tomꞌaan jon. Veꞌ ninntyi ꞌnan tocüaꞌ jon, min tyiꞌcꞌu jon vinon, majoꞌ jnduehoꞌ na tsixuan jon yutyia. ");
INSERT INTO azgNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ndoꞌ vi jndëcya, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, tyjë na mꞌanhoꞌ. Matsijon ja yo nnꞌan na cocüaꞌ ndoꞌ maꞌua vinon yohan, majoꞌ conduehoꞌ ntyja njan: Tsanvahin, jen icüaꞌ quitscu juu ndoꞌ jen iꞌu juu. Ndoꞌ mantyi ya jñꞌoonhin yo nnꞌan na conanꞌtjahin nnon Tyoꞌtsꞌon yo nnꞌan na cotye sꞌon cüentaaꞌ nquii gobiernon tsjoon Roma. Nndaꞌ vaa jñꞌoon na conanꞌneinhoꞌ ndëë ntyjeehoꞌ ntyja njan. Majoꞌ tanin, ngꞌe covityincyo jndyoyu na jndaꞌ xquen Tyoꞌtsꞌon ngꞌe tsoñꞌen na itsijndaꞌ jon tsiꞌmanhanꞌ na nndaꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jndë joꞌ taꞌ Jesús na itsityiaꞌ jon nnꞌan ncüii cüii tsjoon naijon na totsꞌaa jon jndyentyi tsꞌian na tyiꞌjeꞌquindëë nduihanꞌ yo najndei nquii tsꞌan. Majoꞌ min na nndaꞌ, taꞌnan ntcüeꞌ nꞌon nanꞌñeen jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Itso jon: “ꞌOꞌ nnꞌan tsjoon Corazín, viꞌ jndyi ntqueꞌnonhoꞌ. Ndoꞌ mantyi ꞌoꞌ nnꞌan tsjoon Betsaida, viꞌ jndyi ntqueꞌnonhoꞌ, min na jndye nnon tsꞌian njon jndyi na totsꞌa quiiꞌ ntꞌanhoꞌ, majoꞌ taꞌnan ntcüeꞌ nꞌonhoꞌ jnanhoꞌ. Majoꞌ xe na aa sꞌa joo tsꞌianꞌñeen quiiꞌ ntꞌan nnꞌan tsjoon Tiro yo Sidón, cjechen jndë tcüehan ndiaatsjaꞌ ndoꞌ jndë tyiohan tsjaaꞌ nquenhan na nnanꞌmanhanꞌ na contcüeꞌ nꞌonhan jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Matsjö ndëëhoꞌ, juu xuee xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na jndë tonanꞌtjahan nnon jon, tyiꞌjaaꞌchen ntꞌuiiviꞌhanꞌ joo nnꞌan tsjoon Tiro yo Sidón, majoꞌ ꞌoꞌ jaaꞌntyichen ntꞌuiiviꞌhanꞌ, chichen nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ndoꞌ mantyi ꞌoꞌ nnꞌan tsjoon Capernaum, jndye tsꞌian totsꞌa quiiꞌ ntꞌanhoꞌ. ¿Aa ngꞌe joꞌ cotjiꞌhoꞌ cüenta na taquintyja ꞌoꞌ na tꞌman condui? Jñꞌoon na mayuuꞌ ncjuꞌcjeñꞌen Tyoꞌtsꞌon ꞌoꞌ. Joo nnꞌan tsjoon Sodoma, xe na aa juuhanꞌ jntyꞌia ndëëhan tsꞌian tꞌman na totsꞌa quiiꞌ ntꞌanhoꞌ, tyiꞌnan ro na ninvaa mꞌaan juu tsjoonꞌñeen ata xjen nein. ");
INSERT INTO azgNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Matsjö ndëëhoꞌ juu xuee xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ jnanhan, jaaꞌntyichen ntꞌuiiviꞌhanꞌhoꞌ, chichen joo nnꞌan na tomꞌan ndyuaa tsjoon Sodomaꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Majuu xjenꞌñeen sinin Jesús nnon Tyoꞌtsꞌon, tso jon: “ꞌUꞌ Tyeꞌ na condui ꞌUꞌ na macoꞌxenꞌ quiñoonꞌndue yo nnon tsonnangue, matsitꞌmanꞌ ja ꞌUꞌ ngꞌe jndë iscuꞌ jñꞌoonminꞌ ndëë nnꞌan na cotjiꞌ nquehin cüenta na jndaꞌ jndyi nquenhan yo na jen covaaꞌ nꞌonhan nchu vaa itsiꞌmanhanꞌ. Majoꞌ ndëë nnꞌan na ntyꞌiachen nanꞌxuan, jndë tyincyaꞌ na covaaꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mayuuꞌ Tyeꞌ ngꞌe nndaꞌ vaa na tëveeꞌ tsonꞌ.” Manndaꞌ ro jñꞌoon na sinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nque nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa Jesús, tso jon ndëëhan: “Nquii Tyëhöꞌ jndë tyincyaa jon najndö na matsiꞌman jñꞌoonminꞌ ntyja ꞌnaanꞌ na conduihin na ityentjon jon nnꞌan nchu vaa na cotsamꞌanhan. Ndoꞌ min tanin tsꞌan na ivaaꞌ tsꞌon juu nchu vaa matsixuan na condui ja jnda jon, xiaꞌntyi ninnquii jon ntyjii. Ndoꞌ min taꞌnan tsꞌan ivaaꞌ tsꞌon nchu vaa tsixuan Tyëhöꞌ, ninncö na condui jnda jon mavaaꞌ tsꞌön ntyja ꞌnaanꞌ jon. Ndoꞌ mantyi minꞌcya ro tsꞌan na ntꞌue tsꞌön na cüaaꞌ tsꞌon nchu vaa tsixuan Tyëhöꞌ, mancya ja na cüaaꞌ tsꞌon tsanꞌñeenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Tsoñꞌenhoꞌ na tejndyaahoꞌ ngiohoꞌ ngꞌe na ja jndyi xu chohoꞌ na ndiquinanhoꞌhanꞌ, ncyohoꞌ na mꞌan ndoꞌ nninncya na ntaꞌjndyeehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Juu tsꞌoon na cotyio nnꞌan quityaꞌ ndoro, itsꞌaahanꞌ na cüa jon contꞌa oꞌ tsꞌian. Mantyi quitaꞌngueeꞌhoꞌ na nnanꞌjonhoꞌ yo ja. Ncyahoꞌ na ntsijnꞌan ꞌoꞌ ntyja njan, ngꞌe ja tyiꞌncꞌuaaꞌ tsꞌön yo mꞌan na ndyiaaꞌ tsꞌön. Ndoꞌ na nnanꞌjonhoꞌ yo ja, ntsꞌa na ngüajndyee ñuaan ꞌnaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ngꞌe juu na nnanꞌjonhoꞌ yo ja, tyiꞌjndyaaꞌhanꞌ, ndoꞌ juu xu na matyiö nacjohoꞌ, tyiꞌjahanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ndö vaa na tui cüii xee saroꞌ xuee na cotaꞌjndyee nnꞌan judíos. Venon Jesús naijon vaa ntjon ntquen trigo. Ndoꞌ já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, tꞌá na totyjë́ xjuꞌ ntquen trigoꞌñeen ngꞌe na ninjntꞌö́, totyꞌuë́ joo xjuꞌñeen, totquë́hanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Majoꞌ joo nnꞌan tmaanꞌ fariseos, xjen na jntyꞌiahan na jntꞌá na nndaꞌ, jnduehan nnon Jesús: —ꞌUꞌ tsꞌan, quenꞌ cüenta, joo nnꞌan na tquenꞌ na quinanꞌjonhan yo tsꞌian ꞌnanꞌ, contꞌahin ꞌnan na tyiꞌquichuhanꞌ na ntsꞌaa tsꞌan juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ndoꞌ tꞌa jon jndyuehan, itso jon: —ꞌOꞌ jeꞌquitsꞌaahanꞌ na tyiꞌconanꞌjnꞌaanhoꞌ jñꞌoon nchu vaa ꞌnan sꞌaa David yo nnꞌan na tomꞌan yohin juu xjen na tꞌonhan na ninjndoꞌhan. Majoꞌ ꞌoꞌ tyiꞌconanꞌngꞌehoꞌ ntyja ꞌnaanꞌ na sꞌaa jon na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Juu jon tëqueeꞌ jon quiiꞌ vatsꞌon cüentaaꞌ Tyoꞌtsꞌon, ndoꞌ tcan jon tyooꞌ nnon nquii tyee tque. Tcüaꞌ jonhanꞌ ndoꞌ mantyi tyincyaa jonhanꞌ ndëë nnꞌan na tomꞌan yohin. Ndoꞌ joo tyooꞌñeen, tyooꞌ na jndë tquen nnꞌanhanꞌ tonnon Tyoꞌtsꞌon, min tyiꞌcüanaan na ntcüaꞌ minꞌcya ro tsꞌanhanꞌ. Xiaꞌntyi nque ntyeeꞌñeen vanaan na ntcüaꞌhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ndoꞌ mantyi min jeꞌquitsꞌaahanꞌ na tyiꞌconanꞌjnꞌaanhoꞌ jñꞌoon na tquen nquii Moisés naijon na itsiquindyihanꞌ na nque ntyeeꞌñeen, juu xjen na cotyeꞌntjonhan quityquiiꞌ vatsꞌon tꞌman, jndye tsꞌian contꞌahin juu xuee na cotaꞌjndyëë. Majoꞌ taconanꞌtjahan na contꞌahan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Quindyehoꞌ jñꞌoon ntsjö ndëëhoꞌ, ja na jndë tyjë quiiꞌ ntꞌanhoꞌ, njonntyichen condui ja, chichen vatsꞌon tꞌman na contꞌa jndyihoꞌ na njonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ꞌOꞌ vitjachen na ncüaaꞌ ya nꞌonhoꞌ nchu vaa itsiꞌman jñꞌoonva na tso Tyoꞌtsꞌonhanꞌ: “Njonntyichen ntyji ja na cꞌonhoꞌ na ntyꞌia ro nnꞌan ngiohoꞌ, chintyi na coninncyahoꞌ quiooꞌ na conanꞌcüjehoꞌ na conanꞌtꞌmaanꞌhoꞌ ja.” Nndaꞌ itsiquindyi jñꞌoon na toninncyaa Oseas. Ndoꞌ tsontyichen Jesús: Xe na aa taaꞌ ya nꞌonhoꞌ juu jñꞌoonvaꞌ, yajoꞌ taxeꞌquinanꞌchonhoꞌ na quitꞌuiihanꞌ nnꞌan na tyiꞌconanꞌtjahin. ");
INSERT INTO azgNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ngꞌe na nndaꞌ, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, tsixuan na quitsjö nin ꞌnan vanaan na nntꞌa nnꞌan min juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ndoꞌ vi na jndë jnduiꞌ Jesús joꞌ, tja jon na tonnonchen, tueeꞌ jon na vaa vatsꞌon tsjoonꞌñeen, tëqueeꞌ jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ndoꞌ joꞌ mꞌaan cüii tsansꞌa na tëtei ntꞌö. Ndoꞌ nnꞌan fariseos na mꞌanhin juu vatsꞌonꞌñeen, tojntꞌuehin nchu vaa nntꞌahan chaꞌ na nndëë ntjiꞌhan jñꞌoon cjooꞌ Jesús. Taꞌxeeꞌhan nnon jon: —Juu xuee na cotaꞌjndyëëhë, ¿Aa vanaan na ntsinꞌman tsꞌan tsanviiꞌ, ndoꞌ aa tyiꞌcüanaan? ");
INSERT INTO azgNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ndoꞌ joꞌ sentcüeꞌ Jesús jñꞌoon ndëëhan, itso jon: —Ndoꞌ ncüii nquehoꞌ, xe na aa mꞌaan quitsman tsjuenꞌ, ndoꞌ ngioo oꞌ quityquiiꞌ cüii tsueꞌ, mancüiixjen cje ngacüjiꞌ juu choꞌñeen min na aa juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Joꞌ quitjiꞌhoꞌ cüenta, nquii Tyoꞌtsꞌon, njonntyichen ntyjii jon yo ncüii tsꞌan, chito veꞌ quitsman. Mangꞌe joꞌ chuhanꞌ na quitejndei tsꞌan cüiichen tyje juu na iquenon tsanꞌñeen naviꞌ, min na aa juu xuee na cotaꞌjndyee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ndoꞌ itso jon nnon juu tsanviiꞌñeen: —Quitsindiuꞌ ntꞌöꞌ. Ndoꞌ sindiuu juu ntꞌö. Joꞌ maninñoonꞌ ntjo yahanꞌ chaꞌxjen cüiichen ntyja. ");
INSERT INTO azgNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Majoꞌ joo fariseosꞌñeen, vi na jndë jnduiꞌhan, taꞌhan na tonanꞌjndaꞌhan nchu vaa ntꞌahan na nnanꞌcueeꞌhan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ndoꞌ vi na jndë taaꞌ tsꞌon Jesús na nndaꞌ vaa na conanꞌjndaꞌ nanꞌñeen, jnduiꞌ jon joꞌ. Ndoꞌ jndye jndyi nnꞌan tyentyjahan toxenꞌ jon, joꞌ sinꞌman jon nnꞌan vꞌi na sachohan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ndoꞌ jaaꞌ jndyi jñꞌoon na siquiꞌmaanꞌ jon nanꞌñeen na tyiꞌnanꞌquindyihan nnꞌan nin tsꞌan conduihin. ");
INSERT INTO azgNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ndoꞌ na sꞌaa jon na nndaꞌ, siquindëhanꞌ jñꞌoon na tji Isaías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa. Tso jon: ");
INSERT INTO azgNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ndö juu tsꞌan na jndë tji ja ntyja njan. Conduihin moso njan na ityentjon jon nnön. Veꞌnchjihin ndoꞌ nën jndyi ntyja ꞌnaanꞌ jon. Ninncya na tꞌman ntsixuan jon Espíritu Santo. Juu jon ninncyaa jñꞌoon njan ndëë nnꞌan na chito judíos conduihin chaꞌ ndëë ntjo ya ntcüeꞌhan tonnön. ");
INSERT INTO azgNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Juu jon tyiꞌjeꞌquitsintjaꞌhin yo nnꞌan, min tyiꞌxeꞌquitsijndeiꞌ ꞌndyo jon, min tyiꞌxeꞌquintjii tsꞌanhin nata quiiꞌ tsjoon na ityiiꞌ jon tyiaꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Tyiꞌxeꞌquitsꞌaa viꞌ jon tsꞌan na chjo jndyi vantyja tsꞌon na itsijonhanꞌ tsanꞌñeen chaꞌvijon tsmaan na jndë ton na jndei jndyo jndye. Ntejndeintyichen jon tsꞌan na nndaꞌ vaa na itsijonhanꞌ na iquenon juu. Ndoꞌ ntejndei jon tsꞌan na jaaꞌ ꞌnan na iquenon, na ndiquindëë ncja juu na tonnonchen na itsijonhanꞌhin chaꞌvijon chon candi na ngüe ngüe ro covꞌahanꞌ. Nanꞌminꞌ ntsꞌaa jon ata ngüentyja xjen na juu na chuhanꞌ na condui nquii Tyoꞌtsꞌon na ngüantjonhanꞌ ntyja ꞌnaan tsoñꞌen. ");
INSERT INTO azgNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ndoꞌ nnꞌan na mañoon tsjan conduihan, ncꞌonhan na ntyja nꞌonhan jon. Ndöꞌ jñꞌoon na tji Isaías. ");
INSERT INTO azgNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tomꞌaan cüii tsannchjaanꞌ na ndiquitsinin juu. Tyeyꞌon nnꞌanhin na mꞌaan Jesús. Tomꞌaan yutyia quiiꞌ tsꞌon juu. Sinꞌman jonhin, tyincyaahanꞌ na xuee jndyiaaꞌ juu ndoꞌ ya itsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ndoꞌ tsoñꞌen nnꞌan na jntyꞌia na tui na nndaꞌ, tëveeꞌ jndyi ngiohan, taxeeꞌhan: —¿Aa ntsꞌaahanꞌ na juu tsanvaꞌ conduihin nquii jon na cominntꞌö na ncüjeeꞌ na nnduihin tsjan David na jndyocahanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Majoꞌ nnꞌan fariseos jeꞌ, xjen na jndyehan na nndaꞌ vaa jñꞌoon conanꞌnein nanꞌñeen, jnduehan: —Tsanvaꞌ itsixuan juu naijndei ntyja ꞌnaanꞌ Beelzebú, nquii yutyia tque. Veꞌ joꞌ condëë icüjiꞌ juu yutyia yo nanjndyi quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ndoꞌ taaꞌ tsꞌon Jesús na nndaꞌ vaa conanꞌtiuhan. Tso jon ndëëhan: —Ncüii cüii gobiernon na cotꞌiooꞌ nnꞌan na conanꞌjon tsꞌian na itsꞌaa jon, nndyuiiꞌ ntyja ꞌnaanꞌ jon. Ndoꞌ mantyi nnꞌan ninncüii tsjoon oo nque nnꞌan na ninncüii vꞌaa, xe na aa conanꞌntjaꞌhan yo ntyjehan, majndaꞌ na icꞌonhanꞌhin. Ndoꞌ na nndaꞌ, conanꞌtyuiiꞌ nquehin. ");
INSERT INTO azgNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ndoꞌ xe na aa mayuuꞌ chaꞌ na conduehoꞌ na nquii yutyia tque icüjiꞌ nquiihin quiiꞌ nꞌon nnꞌan, yajoꞌ tsiꞌmanhanꞌ na itsityuiiꞌ nquiihin. Ndoꞌ xe na aa nndaꞌ vaa, ¿Nin ꞌnan ntsꞌaa juu chaꞌ ntjotyenhin na icoꞌxen juu joo nnꞌan na conduihan cüentaaꞌ juu? ");
INSERT INTO azgNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ꞌOꞌ conduehoꞌ na veꞌ yo najndei na tsixuan Beelzebú, joꞌ na macüjiꞌ yotyia quiiꞌ nꞌon nnꞌan. Xe na aa jñꞌoon mayuuꞌhanꞌ, yajoꞌ mantyi nque ntyjeehoꞌ cotjiꞌhan yotyia quiiꞌ nꞌon nnꞌan yo maninjuu naijndei na itsixuan juu. Majoꞌ ngꞌe na tyiꞌyuuꞌ na nndaꞌ, joꞌ ꞌnan na contꞌa nquehan, icüjiꞌ jndyoyuhanꞌ na cochue nꞌonhoꞌ ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Majoꞌ ngꞌe na macüjiꞌ yotyia quiiꞌ nꞌon nnꞌan yo naijndei na tsixuan nquii Espíritu na condui nquii Tyoꞌtsꞌon, joꞌ tsiꞌmanhanꞌ na juu na ityentjon jon nnꞌan quityquiiꞌ na cotsamꞌanhan, jndë tyjeeꞌhanꞌ quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Cüii tsanchꞌuee jeꞌ, tyiꞌjeꞌquindëë ngaqueeꞌ juu quiiꞌ vaaꞌ tsꞌan na tsixuan ñuaanꞌ na ncüjiꞌ juu ꞌnaanꞌ jon. Icanhanꞌ na quitsityen jndyee juu tsanꞌñeen, chaꞌ nndëë ncüjiꞌ juu ꞌnaanꞌ jon. Manndaꞌ vaa itsijonhanꞌ ntyja njan ja na macüjiꞌ yotyia yo jndyetyia quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Juu tsꞌan na tyiꞌcꞌoon ntyja njan, mꞌaan juu na jndooꞌ juu ja. Ndoꞌ juu tsꞌan na tyiꞌquitsitjon nnꞌan ntyja ꞌnaanꞌ Tyoꞌtsꞌon yo ja, icꞌon juu nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Ntsitꞌman tsꞌon Tyoꞌtsꞌon nnꞌan tsoñꞌen jnan na nanꞌxuanhan yo jñꞌoon tsanꞌ na conanꞌneinhan. Majoꞌ minninchen tsꞌan na itsinin jñꞌoonviꞌ nacjooꞌ nquii Espíritu Santo, tyiꞌjeꞌquitsitꞌman tsꞌon Tyoꞌtsꞌon juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Minninchen tsꞌan na itsinin jñꞌoonviꞌ nacjö na condui ja tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, nndëë ntsitꞌman tsꞌon Tyoꞌtsꞌon juu tsanꞌñeen. Majoꞌ minꞌcya ro tsꞌan na itso na veꞌ ntyja najndei na tsixuan juu yutyia, joꞌ condëë matsꞌa tsꞌian njan, itsinin tsanꞌñeen jñꞌoonviꞌ cjooꞌ nquii Espíritu Santo. Ndoꞌ na nndaꞌ, tyiꞌjeꞌquitsitꞌman tsꞌon Tyoꞌtsꞌonhin, min xjen nein, ndoꞌ min juu xjen na ntycüii tsonnangue.” ");
INSERT INTO azgNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Yajoꞌ sinin Jesús cüii jñꞌoon na icanhanꞌ na quitjiꞌ nnꞌan cüenta ntyja ꞌnaanꞌ nquii jon. Sijoonꞌ nquiihin na conduihin ncüii tsꞌoon na ya tëëꞌhanꞌ. Tso jon: “Ncüii tsꞌoon, xjen na cojntyꞌiahoꞌ na ya tëëꞌhanꞌ, conduehoꞌ na ya tsꞌoon. Ndoꞌ mantyi ya na cotquenhoꞌ cüenta ncüiichen tsꞌoon na incyaahanꞌ të töꞌ, conduehoꞌ na juu tsꞌoonꞌñeen tyiꞌcüijntꞌuehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Chaꞌxjen quinduntja, vjee jndyi ndaa jndyue oꞌ, manndaꞌ itsijonhanꞌhoꞌ. Tyiꞌjeꞌquindëë nnanꞌneinhoꞌ jñꞌoon ya ndoꞌ mantyi tooꞌchen natyia quityquiiꞌ nꞌonhoꞌ. Ngꞌe ntyjantyi jñꞌoon na ndyiiꞌ tsꞌon tsꞌan, mantyjantyi juuhanꞌ na itsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Juu tsꞌan na ya tsꞌanhin, itsꞌaa juu ꞌnan ya ngꞌe ꞌnan na mꞌaanꞌ tsꞌon juu, yahanꞌ. Majoꞌ juu tsꞌan natyia tsꞌanhin, itsꞌaa juu ꞌnan natyia ngꞌe juu ꞌnan tyia ndyiiꞌ tsꞌon juu, xiaꞌntyi juuhanꞌ mꞌaanꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Matsjö ndëëhoꞌ, juu xuee ya na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ natyia na jndë tontꞌahan, yajoꞌ nninncyahan cüenta nnon jon ntyja ꞌnaanꞌ ncüii ncüii jñꞌoon na veꞌ jnanꞌneintohin. ");
INSERT INTO azgNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ngꞌe yo ntyja ꞌnaanꞌ jñꞌoon na conanꞌneinhoꞌ, mayo juuhanꞌ ntcoꞌxen Tyoꞌtsꞌon ꞌoꞌ. Joo jñꞌoon ya na conanꞌneinhoꞌ, ngüañoonꞌhanꞌhoꞌ. Ndoꞌ mantyi jñꞌoon tyia na conanꞌneinhoꞌ, ntꞌuiityenhanꞌhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Juu xjenꞌñeen vendye nnꞌan fariseos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés jnduehan nnon Jesús: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ ndëë nnꞌan ntyja ꞌnaanꞌ Tyoꞌtsꞌon, ntꞌue nnꞌö́n na quitsaꞌ chjo cüii nnon tsꞌian na njntyꞌiá na tyiꞌjeꞌquindëë nduihanꞌ yo najndei nquii tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Majoꞌ tꞌa Jesús, itso jon ndëëhan: —Nnꞌan na mꞌan nein, tyia jndyi nnꞌanhan, jndë jntyꞌehan Tyoꞌtsꞌon, itsijonhanꞌ ntyja ꞌnaanhin chaꞌna tsꞌan na jndë jntyꞌii juu scuuꞌ oo saaꞌ. Veꞌ ngꞌe na nndaꞌ nanꞌxuanhan, cotanhan na njntyꞌiahan cüii jnꞌaan tꞌman chaꞌ ncüaaꞌ nꞌonhan nin tsꞌan condui ja. Majoꞌ tajeꞌncya juu ꞌnan na cotanhan. Xiaꞌntyi njntyꞌiahan cüii na itsijonhanꞌ chaꞌna juu ꞌnan na tenon Jonás. ");
INSERT INTO azgNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Juu Jonás ndye xuee ndoꞌ ndye tsjon toquiñjon jon quiiꞌ tsiaaꞌ quitscaa tꞌman. Manndaꞌ vaa na ntsijonhanꞌ na ngenön na condui ja tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ndye xuee ndoꞌ ndye tsjon ncꞌön quityquiiꞌ tsiꞌtsꞌua. ");
INSERT INTO azgNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Joo nnꞌan na jndë tjë, juu xuee xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ꞌnan na tonanꞌtjahan, xjenꞌñeen nque nnꞌan tsjoon Nínive, nntcüi nndaꞌhan. Ndoꞌ mantyi nnꞌan na mꞌan na neinhin na ya ngüentyja xjen na ngovjehan, nntcüi nndaꞌhan juu xjenꞌñeen. Ndoꞌ joo nnꞌan Níniveꞌñeen, nnduehan na nque nnꞌan na mꞌan naneinhin, tꞌmanntyi jnan nanꞌxuanhan, chito nquehan, ngꞌe juu xjen ya na jndyehan jñꞌoonꞌ Tyoꞌtsꞌon na toninncyaa Jonásꞌñeen, ntcüeꞌ nꞌonhan jnanhan. Ndoꞌ quitquenhoꞌ cüenta, ja na mꞌan quiiꞌ ntꞌanhoꞌ, tꞌmanntyichen condui ja, chito Jonás, ndoꞌ min tyiꞌninꞌquintcüeꞌ nꞌonhoꞌ jnanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ndoꞌ juu xuee ya na ntcoꞌxen Tyoꞌtsꞌon nnꞌan na jndë tjë xengꞌe na tonanꞌtjahan, ya joꞌ mantyi nquii tsanscu na tocoꞌxen nnꞌan ndyuaa tontyja na conduiꞌ ncjuu tsonjnꞌaan, ntcüi nndaꞌ jon. Mantyi nnꞌan na mꞌan nanein ya na ngüentyja xjen na ngovjehan, nntcüi nndaꞌhan juu xjenꞌñeen. Ndoꞌ juu tsanscuꞌñeen ngitso jon na nque nnꞌan na mꞌan nanein tꞌmanntyi jnan nanꞌxuanhan, chito nquii jon, ngꞌe tycya ndyuaa ꞌnaanꞌ jon na jndyo jon na ninꞌquindyi jon jñꞌoon ꞌndyo Salomón, tsan na jndaꞌ jndyi xquen. Ndoꞌ quitquenhoꞌ cüenta, ja na mꞌan quiiꞌ ntꞌanhoꞌ tꞌmanntyichen condui ja, chichen Salomón. Majoꞌ tyiꞌninꞌquindyehoꞌ jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Xjen na jndë jnduiꞌ cüii jndyetyia quiiꞌ tsꞌon tsꞌan, veꞌ mandyiꞌto juu ndyuaa na tandaa cꞌoon yu ro na ntꞌue juu naijon ya ncꞌoon juu. Majoꞌ ngꞌe tantjii juu ncüiichen joo, joꞌ sitiu juu quiiꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Itso juu: “Nanein ncjö ntcüꞌë nntꞌa na ncꞌön quiiꞌ tsꞌon tsꞌan naijon na jntꞌui.” Majoꞌ xjen na ngueeꞌ ntcüeꞌ juu, ntjii juu quiiꞌ tsꞌon tsanꞌñeen chaꞌvijon quityquiiꞌ vꞌaa na tatsꞌan quindyiiꞌ. Ntjuꞌhanꞌ chaꞌvijon na tca ya tsꞌan ndoꞌ jndë tijndaꞌ ya. ");
INSERT INTO azgNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ndoꞌ na nndaꞌ, vja yutyiaꞌñeen, vaquichu juu ntyqueꞌ yotyia na viꞌntyichen nanꞌxuanhanꞌ, chichen chaꞌxjen nquii juu. Ndoꞌ ngoqueꞌhan quityquiiꞌ tsꞌon juu tsanꞌñeen na ntjotyenhan joꞌ. Ndoꞌ na nndaꞌ ndui, mamioonntyichen ntquenon tsanꞌñeen, chichen chaꞌxjen na toquenon jndyee juu. Manndaꞌ itsijonhanꞌ na ntquenon nnꞌan manyan na mꞌan naneinhin. ");
INSERT INTO azgNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ninvaa na itsinin Jesús ndëë nnꞌan na jndye jndyiꞌhin, ndoꞌ tyjeeꞌnon ndyee jon yo ntyje nquii jon. Ninꞌquinanꞌneinhin yo juu jon, majoꞌ ntjohin tochꞌen vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ndoꞌ siquindyii cüii tsꞌan Jesús, itso juu nnon jon: —Nndaꞌ ta, juu ꞌndyoꞌhoꞌ yo maninꞌntyꞌiuꞌhinꞌ, mꞌanhan chꞌen na ninꞌquinanꞌneinhan yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Majoꞌ sintcüeꞌ jon jñꞌoon nnon tsanꞌñeen, tso jon: —Quindyiꞌ ntsjö nnonꞌ, ¿Nin tsꞌan na condui ndyö ndoꞌ ninꞌntyjö ncö? ");
INSERT INTO azgNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Yajoꞌ siꞌman jon ntꞌö jon ndëë nnꞌan na tqueenꞌ jon na quitsayꞌonhan jñꞌoon yo jon, itso jon: —Nanmin conduihan ndyö ndoꞌ yo ntyjö. ");
INSERT INTO azgNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ngꞌe minninchen tsꞌan na itsꞌaa chaꞌxjen na ntꞌue tsꞌon nquii Tyëhöꞌ na mꞌaan quiñoonꞌndue, condui tsanꞌñeen tyjö ncö na tsansꞌa, tyjö ncö na tsanscu ndoꞌ conduihin ndyö. ");
INSERT INTO azgNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tjantyi chjochen xjen juu xueeꞌñeen na jnduiꞌ Jesús quiiꞌ vꞌaa, tëcjo jon ꞌndyo ndaandue. ");
INSERT INTO azgNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ndoꞌ jndye jndyi nnꞌan tëtjon na mꞌaan jon. Mangꞌe joꞌ tua jon quityquiiꞌ vꞌaandaa, tëcjo jon joꞌ ndoꞌ nanꞌñeen tentyjeeꞌhan tyuaatcüii ꞌndyo ndaandueꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ndoꞌ taꞌ jon na jndye jñꞌoon totsiꞌman jon ndëëhan yo jñꞌoon na tyiꞌquitso nquiiꞌ jon nchu vaa na itsiquindyihanꞌ. Tso jon: —Tomꞌaan cüii tsꞌan na totsꞌaa juu tsꞌian jndëë. Tja tsanꞌñeen, tëquitscyaa juu ntquen trigo. ");
INSERT INTO azgNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ndoꞌ viochen xjen na itscyaa juu ntquenꞌñeen, ñꞌenhanꞌ na tycyaahanꞌ ꞌndyo nato. Maninñoonꞌ squenon quintsa, tquii oꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ndoꞌ ñꞌen ntquenꞌñeen tycyaahanꞌ naijon na jen ntjöꞌ, yuu na tyiꞌta mꞌaan tsꞌo. Juuhanꞌ cje tꞌonhanꞌ ngꞌe tyiꞌta mꞌaan tsꞌo. ");
INSERT INTO azgNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Majoꞌ ya na tijminꞌ na jndyiaaꞌ ndoꞌcüjioonꞌ, tꞌuaahanꞌ, tëcanhanꞌ ngꞌe na tyiꞌnjoon tyꞌe nchꞌiooꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ndoꞌ ñꞌen ntquenꞌñeen tycyaahanꞌ naijon na mꞌan ndaꞌ ntꞌööneon. Cje tëvindye ntꞌööneonꞌñeen, scüjehanꞌ ntjon ntquenꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Majoꞌ vendye ntquenꞌñeen tycyaahanꞌ naijon na ya tsꞌo, vaa ya jndyi sꞌaahanꞌ. Ncüii tanꞌ juu ntjonꞌñeen tjiꞌhanꞌ ninnque xu ntquen trigo na cüii istjöhanꞌ na iscyaa tsanꞌñeen. Ndoꞌ cüii tanꞌhanꞌ tjiꞌhanꞌ ve xu xoꞌncüe na cüii istjöhanꞌ na iscyaa tsanꞌñeen. Ndoꞌ ncüiichen ncüii tanꞌhanꞌ tjiꞌhanꞌ cüii xu vantjoꞌ yon istjö na cüii istjöhanꞌ na iscyaa tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Minninchen tsꞌan na min ndöꞌnqui na ndyii, cüaaꞌ tsꞌon juu jñꞌoonvaꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nnꞌan na tqueenꞌ Jesús na quitsayꞌonhan yo jñꞌoon na toninncyaa jon, jnanꞌndyooꞌhan mꞌaan jon. Taꞌxeeꞌhan nnon jon: —Joo jñꞌoon na matsininꞌ ndëë nnꞌan, veꞌ jñꞌoon na tyiꞌquitsuꞌ nquiꞌhanꞌ. ¿Ndu na nndaꞌ vaa na matsininꞌ ndëëhan? ");
INSERT INTO azgNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tꞌa jon jndyuehan: —Ndëë ꞌoꞌ incyaa Tyoꞌtsꞌon na cüaaꞌ nꞌonhoꞌ juu jñꞌoon na tyíꞌcotsiꞌman jonhanꞌ na toxenꞌchen nchu vaa na ityeꞌntjon jon nnꞌan ntyja na cotsamꞌanhan. Majoꞌ ndëë minꞌndyechenhan tatyincyaa jon na ncüaaꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Minninchen tsꞌan na iyꞌoon cüenta jñꞌoon na matsiꞌman, nninncyaa Tyoꞌtsꞌon na ncüaaꞌ yachen tsꞌon juuhanꞌ. Majoꞌ minninchen tsꞌan na tyiꞌninꞌcyꞌoon juu cüenta jñꞌoon na matsiꞌman, ntsꞌaahanꞌ na veꞌ jnꞌaan na ivaaꞌ tsꞌon juu chjoviꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ngꞌe joꞌ matsinën ndëë nnꞌan yo jñꞌoon na tyiꞌquitsjö ncꞌi. Ngꞌe min na ninnquiiꞌchen cojntyꞌiahan, majoꞌ tyiꞌxequitquenhan cüenta. Ndoꞌ min condyehan, majoꞌ mꞌanhan chaꞌvijon na tyiꞌcondyehan, min tyiꞌcovaaꞌ nꞌonhan jñꞌoon na condyehan. ");
INSERT INTO azgNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ntyja ꞌnaan joohin itsiquindëhanꞌ jñꞌoon na tji Isaías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen nchu vaa ꞌnan na nguaa. Itso jon: Ninnquiiꞌchen nndyehoꞌ, majoꞌ tyiꞌxeꞌcüaaꞌ nꞌonhoꞌhanꞌ. Ninnquiiꞌchen njntyꞌia ndëëhoꞌ, majoꞌ tyiꞌxequitquenhoꞌ cüenta nchu vaa itsiꞌmanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ngꞌe nanminꞌ jndë jnanꞌqueꞌ nꞌonhan chaꞌ tyiꞌquinanꞌtiuhan yo na jndaꞌ nquenhan. Tavininꞌquindyehan jñꞌoon na matsjö chaꞌ nndëë ncüaaꞌ nꞌonhinhanꞌ. Contꞌa nquehin chaꞌvijon tacojntyꞌiahin chaꞌ tyiꞌicanhanꞌ na ntquenhan cüenta. Ndöꞌ vaa na contꞌa yahan chaꞌ tyiꞌntcüeꞌ nꞌonhan jnanhan na tonnön ndoꞌ na ntsinꞌman ñuaanhan. Ndöꞌ vaa na itsiquindyi juu jñꞌoonvaꞌ na tji Isaías. ");
INSERT INTO azgNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Sininntyichen Jesús ndëë nnꞌan na conanꞌjon jñꞌoon na toninncyaa jon. Tso jon: Tꞌman ityio Tyoꞌtsꞌon jnꞌaanhoꞌ na cojntyꞌia ndëëhoꞌ tsꞌian na matsꞌa ndoꞌ mantyi covaaꞌ nꞌonhoꞌ jñꞌoon na condyehoꞌ na mancya. ");
INSERT INTO azgNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, jndye nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ndoꞌ jndye nnꞌan tontꞌahin chaꞌxjen na chuhanꞌ na tonnon jon, tojntꞌue jndyihan na njntyꞌia ndëëhan ꞌnan na cojntyꞌiahoꞌ, ndoꞌ na nndyehan jñꞌoon na condyehoꞌ, majoꞌ tyíꞌquijntyꞌiahinhanꞌ min tyíꞌquindyehinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Juu jñꞌoonꞌñeen na tyiꞌquitsjö ncꞌihanꞌ ntyja ꞌnaanꞌ tsꞌan na taquitscyaa tsjan ntquen trigo, quindyehoꞌ nin ꞌnan ninꞌquitsiquindyihanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Minꞌndye ntquenꞌñeen na tycyaa ꞌndyo nato na tquii quintsa, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon. Majoꞌ minꞌcya ro tsꞌan na ndyii juu jñꞌoon ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan, majoꞌ tyiꞌcantyja tsꞌon juuhanꞌ, joꞌ icüjeeꞌ juu yutyia ndoꞌ icüjiꞌ juu jñꞌoon nayaꞌñeen quiiꞌ tsꞌon tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndoꞌ minndye ntquenꞌñeen na tycyaa naijon na ntjöꞌ jndyi, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon, ndoꞌ yo na nein jndyihan coyꞌonhan cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Majoꞌ itsijonhanꞌ nanꞌñeen chaꞌvijon ntjon na tyiꞌnjoon tyꞌe nchꞌiooꞌ, ndoꞌ macje ro tëcanhanꞌ. Ee xjen na coquenonhan naviꞌ oo contyꞌe nnꞌanhin ntyja ꞌnaanꞌ juu jñꞌoon naya, maquintyjachen coꞌndyehan na conanꞌjonhan yo juu jñꞌoon nayaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndoꞌ ntquen na tycyaa naijon na mꞌaan ntꞌööneon, joꞌ nnꞌan na condye jñꞌoon naya. Majoꞌ ngꞌe na jndye jndyi jñuaanꞌ tsꞌon na mꞌanhan ntyja ꞌnaanꞌ na cotsamꞌanhan, yo nchu vaa nntꞌahan chaꞌ nninjndye ꞌnaanhin, mangꞌe nanꞌminꞌ mꞌaanꞌ nꞌonhan, joꞌ itscuꞌhanꞌ na nntꞌahan chaꞌxjen na chuhanꞌ. Joo jñꞌoontiuꞌñeen itscuꞌhanꞌ na nnanꞌquiꞌndëhan tonnon Tyoꞌtsꞌon, chaꞌxjen jntꞌa joo ntꞌööneonꞌñeen na iscüjehanꞌ ntjon ntquenꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Majoꞌ ntquen na tycyaa naijon na ya jndyi tsꞌo, joꞌ nnꞌan na condye jñꞌoon naya. Covaaꞌ nꞌonhinhanꞌ ndoꞌ yo ꞌnan na contꞌahan, covityincyo na conanꞌvehan nchu vaa na itso juu jñꞌoonꞌñeen. Minꞌndye nanꞌñeen tëquintyja ya contꞌahin. Itsijonhanꞌhin chaꞌna cüii istjö ntquenꞌñeen na tjiꞌhanꞌ ninnque xu. Ndoꞌ minndye nanꞌñeen, chjochen contꞌahan. Itsijonhanꞌhin chaꞌvijon cüii istjö ntquenꞌñeen na tjiꞌhanꞌ ve xu xoꞌncüe. Ndoꞌ minꞌndyehan tyiꞌcjooꞌ nꞌonhan na cotsantyjahan nchu vaa na chuhanꞌ, joꞌ itsijonhanꞌhin chaꞌvijon cüii istjö ntquenꞌñeen na tjiꞌhanꞌ ninncüii xu vantjoꞌ yon istjöhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ndoꞌ sinin Jesús cüiichen jñꞌoon na tyiꞌquitso nquiiꞌ jonhanꞌ. Tso jon ndëëhan: —Ntyja na ityentjon Tyoꞌtsꞌon nnꞌan, itsijonhanꞌ juuhanꞌ chaꞌna cüii tsꞌan na tja juu na vaa tyuaaꞌ ꞌnaanꞌ juu, tjaquitscyaa juu ntquen tsjan ꞌnan ya. ");
INSERT INTO azgNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Majoꞌ ncüii tijaan xjen na itso jon yo nnꞌan vaaꞌ jon, tja cüii tsꞌan na vꞌiihin, taquitscyaa tsanꞌñeen ntqueenꞌ jndë mañoon quiiꞌ ntꞌan trigoꞌñeen. Jndë joꞌ tja tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Juu ntquenꞌñeen tëvindyehanꞌ ndoꞌ tyeꞌ conduiꞌ xjuꞌhanꞌ, ndoꞌ mantyi tityincyo na ñꞌen jndë mañoon quiiꞌ ntꞌanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ndoꞌ joo nanntjon ꞌnaanꞌ tsanꞌñeen tquenhan cüenta na nndaꞌ vaa, joꞌ tyequinduehan nnon jon: Nndaꞌ ta, ¿Aa tyiꞌyuuꞌ na tëquitscyaꞌ tsjan ntquen ya tyuaa ꞌnanꞌ? Yajoꞌ ¿Ndu na covityincyooꞌ na ñꞌen jndë mañoon quityquiiꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tꞌa jon jndyuehan, itso jon: Tsꞌan na vꞌii ja, juu sꞌaa na nndaꞌ. Ndoꞌ taꞌxeeꞌ nanntjonꞌñeen nnon jon: ¿Aa ntꞌue tsonꞌ na ntsaquitjíꞌhanꞌ quityquiiꞌ ntjon ꞌnanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Majoꞌ tꞌa jon, itso jon ndëëhan: Min chitojoꞌ, ngꞌe xe na aa ntyehoꞌ joo jndë mañoonꞌñeen, ntsꞌaahanꞌ na mantyi ntyehoꞌ juu ntjon ya. ");
INSERT INTO azgNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Quiꞌndyehoꞌ na ninvixjen ndindye na manchaꞌve nnonhanꞌ ata xjen jndë tmanhanꞌ. Yajoꞌ ntsjö ndëë nnꞌan na ntyjehan ntjonꞌñeen: Quityje jndyeehoꞌ juu jndë ntquen mañoon, quintꞌahoꞌ xjen sëëꞌhanꞌ chaꞌ ntcohanꞌ. Ndëcya quityjehoꞌ jndë ntquen ꞌnan ya na ntjueꞌhoꞌhanꞌ quityquiiꞌ tsëꞌ njanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Mantyi sininntyichen Jesús jñꞌoon na tyiꞌquitso nquiiꞌ jon nin ꞌnan itsiquindyihanꞌ. Jñꞌoonꞌñeen itsiꞌmanhanꞌ na ndijndyentyi nnꞌan na ityentjon Tyoꞌtsꞌonhin juu na cotsamꞌanhan. Tso jon: —Juu na ityentjon Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan, itsijonhanꞌ juuhanꞌ chaꞌna ncüii ntqueenꞌ mostaza na tëquinonꞌ tsꞌanhanꞌ quityquiiꞌ teon ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Juu nanꞌñeen quijndëntyichenhanꞌ na tsoñꞌen ntquen na nnonꞌ tsꞌan, majoꞌ ya na jndë tꞌonhanꞌ, jndë tindyehanꞌ, yajoꞌ ngüenoonꞌhanꞌ tsoñꞌen nꞌoon na ninncüii nguesuaꞌ na coventyjeeꞌ, tꞌman ndueehanꞌ ata joo quintsa nnanꞌya ꞌo ntycya oꞌ xquenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ndoꞌ mantyi sinin Jesús ncüiichen jñꞌoon na tyiꞌquitsiꞌman nquiiꞌ jon nin tsiquindyihanꞌ. Itso jon: —Juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan, itsijonhanꞌ juuhanꞌ chaꞌvijon tsquentë na sitjonꞌ cüii tsanscu quityquiiꞌ ndye kilo jndë tyooꞌ. Ndoꞌ juu tsquentëꞌñeen tsiquindëhanꞌ ninvaa tsquen tyooꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ninnquiiꞌchen tijntꞌue Jesús jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ya na toninncyaa jon jñꞌoon ndëë nnꞌan. Tasinin jon ndëëhan na veꞌ ndöꞌ ro. ");
INSERT INTO azgNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ndoꞌ na nndaꞌ sꞌaa jon, siquindëhanꞌ jñꞌoon na sinin nquii tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen. Tso jon: Ntsinën ndëë nnꞌan yo jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ nchu vaa ꞌnan na nguaa. Ndoꞌ jñꞌoon na vantyꞌiuuꞌ mꞌaanhanꞌ ntyjantyi xjen na tquen Tyoꞌtsꞌon tsonnangue, joo jñꞌoonꞌñeen ntsiquinanhanꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Joo nnꞌan na jndye jndyiꞌhin, vi na jndë jñon Jesús joohan na cꞌo ntcüeꞌhan, yajoꞌ tëqueeꞌ jon quiiꞌ vꞌaa. Ndoꞌ já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, jnanꞌndyooꞌ já nnon jon, jnduë́: —Juu jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ntyja ꞌnaanꞌ ntqueenꞌ jndë mañoon na tꞌonhanꞌ quiiꞌ ntjon ya, quitsuꞌ ndë́, ¿Nin ꞌnan itsiquindyihanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tꞌa jon jndyuë́, itso jon: —Nquii tsꞌan na tëquitscyaa ntquen tsjan ya, ja condui juu tsanꞌñeen, ncö tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tyuaa ꞌnaanꞌ tsanꞌñeen, joꞌ tsonnangue. Ntquen tsjan ya, joꞌ nque nnꞌan na cotaꞌngueeꞌhin na quityeꞌntjon Tyoꞌtsꞌonhan. Ndoꞌ ntqueenꞌ jndë mañoon, joꞌ nnꞌan na mꞌan ntyja ꞌnaanꞌ yutyia. ");
INSERT INTO azgNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Juu tsanꞌñeen na tyia tsꞌanhin na tëquitscyaa juu tsjan ntqueenꞌ jndë mañoon, joꞌ nquii yutyia tque. Ndoꞌ xjen na jndë tman ntjon na saquityje nanntjonhanꞌ, joꞌ xuee ya na nntycüii tsonnangue. Joo nanntjon na tyequityje juu ntquenꞌñeen, conduihan ángeles cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ndoꞌ chaꞌxjen jntꞌa nanntjon xjen sëëꞌ jndë mañoon na ntcohanꞌ, manndaꞌ itsijonhanꞌ na ndui xuee na nntycüii tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Juu xjenꞌñeen ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, njñön ángeles njan na ntjiꞌ ndyaꞌhan nnꞌan natyia nanꞌxuan yo nnꞌan na conanꞌjndaꞌ nquen ntyje na quintꞌa nanꞌñeen ꞌnan tyia. ");
INSERT INTO azgNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ndoꞌ ntjueꞌ ángeles joo nanꞌñeen quityquiiꞌ chon vꞌio. Joꞌ ndyueehan ndoꞌ maninꞌ ntcüaꞌhan ndiꞌnꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Yajoꞌ ngueꞌntyja na ityentjon Tyoꞌtsꞌon tsoñꞌen. Juu xjenꞌñeen nque nnꞌan na tajnan nanꞌxuan, ncꞌonhan naijon na mꞌaan jon. Ntyja ꞌnaanꞌ na ngaquinjonhin, itsijonhanꞌ chaꞌvijon na maninꞌ conduinduiꞌ ndoꞌcüjioonꞌ. Nin juu na ninꞌcüaaꞌ tsꞌon jñꞌoonvaꞌ, quindyii juu. ");
INSERT INTO azgNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ntyja ꞌnaanꞌ juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan na cotsamꞌanhan, itsijonhanꞌ juuhanꞌ chaꞌvijon cüii iston na ñjon sꞌon na tyꞌiu tsꞌan quiiꞌ tyuaa. Ntjii ncüiichen tsꞌanhanꞌ, majoꞌ maninñoonꞌ tyꞌiu ntcüeꞌ jonhanꞌ. Tja jon na neiinꞌ jon, tëquijndëë jon tsoñꞌen ꞌnaanꞌ jon na min. Jndë joꞌ sijnda jon juu tyuaaꞌñeen naijon na ndyiiꞌ istonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Mantyi ntyja ꞌnaanꞌ na ityentjon Tyoꞌtsꞌon nnꞌan na cotsamꞌanhan, itsijonhanꞌ juuhanꞌ chaꞌna ncüii tsꞌan na ninnquiiꞌchen ntꞌue jon tëꞌ perlas na yantyichen na itsijnda jon ndoꞌ na ijndëë nndaꞌ jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ndoꞌ vi na jndë ntjii jon ncüii tëꞌ perla na tëquintyja na yahanꞌ, tja jon, tëquijndëë jon tsoñꞌen ꞌnaanꞌ jon na min, jndë joꞌ sijnda jon juu tëꞌ perlaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ntyja ꞌnaanꞌ juu na ityentjon Tyoꞌtsꞌon nnꞌan na cotsamꞌanhan, itsijonhanꞌ juuhanꞌ chaꞌna ncüii tsquiꞌ tꞌman na cotjueꞌ nnꞌan quityquiiꞌ ndaandue. Jndye nnon quintcaa covahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Ndoꞌ vi jndë tooꞌhanꞌ na ñjon quintcaa, contyja nnꞌanhanꞌ tyuaatcüi. Jndë joꞌ cotsacüendyuaahan, cotjihan quintcaa na yantyichen. Cotyionhan joo oꞌ quityquiiꞌ ntque, majoꞌ quintcaa na tyiꞌquijntꞌue, conanꞌcyaahan joo choꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Manndaꞌ itsijonhanꞌ na nguaa xuee ya na nntycüii tsonnangue. Nndyocue ángeles na ntjiꞌhan nnꞌan na tyia nanꞌxuan na mꞌanhan quiiꞌ ntꞌan nnꞌan na cotsamꞌan chaꞌxjen na chuhanꞌ tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ndoꞌ ntjueꞌhan joo nanꞌñeen quiiꞌ chon vꞌio. Joꞌ ndyuee nanꞌñeen ndoꞌ maninꞌ ntcüaꞌhan ndiꞌnꞌonhan tsojnaanꞌ na viꞌ na ntqueꞌnonhan joꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jndë joꞌ taxeeꞌ Jesús ndë́ já nnꞌan na tqueenꞌ jon na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, tso jon: —¿Aa covaaꞌ nꞌonhoꞌ tsoñꞌen jñꞌoonminꞌ? Tꞌá, jnduë́ nnon jon: —Covaaꞌ nꞌö́nhanꞌ, ta. ");
INSERT INTO azgNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ngꞌe joꞌ itso jon ndë́: —Covaaꞌ nꞌonhoꞌ nin ꞌnan conanꞌquindyi joo jñꞌoon na tyiꞌquitsjö ncꞌihanꞌ. Matsjö ndëëhoꞌ, tyincüii ncüii tsꞌan na jndë taaꞌ tsꞌon nchu vaa itsiꞌman juu jñꞌoon na tquen Moisés ndoꞌ yo ntyja ꞌnaanꞌ juu na coꞌxen Tyoꞌtsꞌon nnꞌan, itsijonhanꞌ juu tsanꞌñeen chaꞌvijon tsꞌan na conintque cüii vꞌaa. Covijntꞌuehin ꞌnan ndyo na nachu jon, ndoꞌ mantyi tsixoncüi jon ꞌnan xco na nninjntꞌuehin. Ndoꞌ na nndaꞌ, minꞌcya ro xjen na icanhanꞌ na nninjntꞌuehin cüiihanꞌ, vaa cjehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jndë na sinin Jesús jñꞌoonminꞌ na tyiꞌquitso nquiiꞌhanꞌ, yajoꞌ jnduiꞌ jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tantcüeꞌ jon ndyuaa tsjoon yuu jon na taquehin. Taꞌ jon totsiꞌman jon quiiꞌ vatsꞌon tsjoonꞌñeen. Ndoꞌ tsochen nanꞌñeen vacue tomꞌaanꞌ nꞌonhan ntyja ꞌnaan jñꞌoon na toninncyaa jon. Jnduehan: —Tsanvaꞌ, ¿Nin ꞌnan sꞌaa juu na jndaꞌ jndyi xquen juu? Juu najndei na condëë itsꞌaa juu tsꞌian tꞌmanminꞌ na cojntyꞌia, ¿Yuu tyꞌoon juu najndeiꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Juu veꞌ jnda tsꞌan na icyu nꞌoonhin, ndoꞌ ntjoo mꞌaan ndyee juu María, ndoꞌ mantyi ntjoo mꞌan ntyje juu Santiago, José, Simón yo ninꞌJudas, mantyje nquii juuhin. ");
INSERT INTO azgNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ndoꞌ mantyi quiiꞌ ntꞌan mꞌan nanntcu ntyje juu. Ngꞌe na nndaꞌ, ¿Nchu vaa na condëë itsꞌaa juu tsꞌianminꞌ, ndoꞌ veꞌ tsꞌan tsjöönhin? ");
INSERT INTO azgNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Mangꞌe joꞌ ndincyaahanꞌ na ngantyja nꞌonhan Jesús. Majoꞌ tso jon ndëëhan: —Minyuuchen na vja tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon, mancüiixjen contꞌa nnꞌan na njonhin. Majoꞌ nque nnꞌan ndyuaaꞌ tsjoonꞌ juu yo nnꞌan chuuꞌhin, joo nanꞌñeen tyiꞌquintꞌahan na njonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndoꞌ nque nnꞌan tsjoonꞌ jon, ngꞌe tyíꞌcantyja nꞌonhan jon, joꞌ veꞌ cüantyi ro tsꞌian tꞌman sꞌaa jon quiiꞌ ntꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Majoo ngueeꞌñeen tomꞌaan Herodes na icoꞌxen jon ndyuaa Galilea. Joꞌ jndyii jon jñꞌoon na tonanꞌnein nnꞌan ntyja ꞌnaanꞌ tsꞌian tꞌman na totsꞌaa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tso Herodes ndëë nnꞌan na cotsantyja yo tsꞌian na conduihin: —Tsanvaꞌ majuu Juanhin, tsan na totsiquindëëꞌ nnꞌan. Jndë vandoꞌ xco jon na tomꞌaan jon na tsꞌoohin. Mangꞌe na nndaꞌ, covityiꞌncyooꞌ tsꞌian tꞌmanminꞌ na itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Nndaꞌ tso Herodes ngꞌe veꞌ tomꞌaan ya jon yo Herodías, scuuꞌ tyje jon Felipe. Ndoꞌ juu Juanꞌñeen, tsojnaanꞌ na tso jon nnon Herodesꞌñeen na tyiꞌquichuhanꞌ na mꞌaan jon yo scuuꞌ tyje jon, ngꞌe joꞌ na tꞌua jon tsꞌian ndëë sondaro ꞌnaanꞌ jon na quinanꞌtyenhan tsanꞌñeen, quitjueꞌhanhin vancjo. ");
INSERT INTO azgNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ndoꞌ min na ninꞌquitscueeꞌ jon Juan, majoꞌ ncyaaꞌ jon nnꞌan, ngꞌe jndye nnꞌan tjiꞌhin cüenta na juu Juanꞌñeen tonduihin tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Majoꞌ ya na jnanꞌtꞌmaanꞌ nnꞌan na tueeꞌ xeechuuꞌ nquii Herodes, yajoꞌ yuscundyua jnda Herodíasꞌñeen, sijnon juu tondëëhan. Ndoꞌ taveeꞌ jndyi tsꞌon Herodes na nndaꞌ sꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Joꞌ tcoꞌ jon ꞌndyo jon nnon juu yo jñꞌoon na tyiꞌjon quitscüejndyo jonhanꞌ. Ata tso jon na minꞌcya ro ꞌnan na ntcan juu nnon jon, nninncyaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ndoꞌ ngꞌe na nndaꞌ, juu yuscundyuaꞌñeen, tyiiꞌ ndyee juu jñꞌoon nnon juu na can juu xquen Juan. Ndoꞌ tso juu nnon Herodes: —Ndö vaa ꞌnan na ntꞌue tsꞌön. Ncyaꞌ ndöhin cüii xio na ñjon xquen Juan, nquii tsan na itsiquindëëꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tiꞌndaaꞌ ntyjii Herodes ngꞌe nndaꞌ vaa ꞌnan na tcan juu, majoꞌ ngꞌe jndë tso jon na tyiꞌjeꞌquitscüejndyo jon jñꞌoon na tso jon nnon juu ndoꞌ ngꞌe na jndye nnꞌan mꞌan na conanꞌjon na tueeꞌ xeechuuꞌ jon, joꞌ tꞌua jon tsꞌian na quindui chaꞌxjen na tcan juu yuscundyuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Joꞌ juu Herodesꞌñeen, jñon jon sondaro na cꞌohan vancjo na mꞌaan Juan na quityjehan xquen jon. ");
INSERT INTO azgNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ndoꞌ vi jndë na jntꞌahan na nndaꞌ, tyeyꞌonhan xquen Juanꞌñeen na ñjonhanꞌ quiiꞌ xio. Tyincyahinhanꞌ nnon yuscundyuaꞌñeen, ndoꞌ tëyꞌoon juuhanꞌ na mꞌaan ndyee juu. ");
INSERT INTO azgNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jndë na tui na nndaꞌ, joo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Juan, tyecyꞌonhan siꞌtsꞌo ꞌnaanꞌ jon. Tyequityꞌiuhanhin. Jndë joꞌ tyenanꞌquindyiihan Jesús ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Xjen na jndyii Jesús na jndë jnanꞌcueeꞌ nanꞌñeen Juan, tua jon quityquiiꞌ vꞌaandaa, jnduiꞌ jon joꞌ yo já nnꞌan na tꞌman jon na quinanꞌjö́n yo jñꞌoon na toninncyaa jon. Sá ncüii joo naijon na ninnquë́. Majoꞌ joo nnꞌan, vi na jndë jndyehan na jndë vetꞌio jon ndaandue, yajoꞌ jnduiꞌhan njoonhan, tyꞌe ngꞌehan, tyencyahan ntyeeꞌ ꞌndyo juu ndaandueꞌñeen na tyentyjahan toncꞌë́n. ");
INSERT INTO azgNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ndoꞌ juu xjen na jnduiꞌ Jesús vꞌaandaaꞌñeen, jndyiaaꞌ jon cüii tmaanꞌ nnꞌan na jndye jndyi na jndë squehan joꞌ, ndoꞌ tyioo na viꞌnchjii jndyi jonhin. Sinꞌman jon nnꞌan vꞌi na sachohan. ");
INSERT INTO azgNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ndoꞌ xjen na vi vaninnton chjo, já nnꞌan na totsayꞌö́n yo jñꞌoon na toninncyaa jon, santyjáꞌ nnon jon. Jnduë́: —Nanein jndë tman ndoꞌ ntjoohin quiiꞌ jndëëhanꞌ. Mangꞌe joꞌ quijñonꞌ nanminꞌ, na cꞌohan njoon quijndë na nnanꞌjndahan ꞌnan ntcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Majoꞌ sintcüeꞌ Jesús jñꞌoon ndë́: —Min tyiꞌicanhanꞌ na ncꞌohan, ꞌoꞌ ncyahoꞌ na ntcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Joꞌ jnduë́ nnon jon: —Ninxiaꞌntyi ꞌon tanꞌ tyooꞌ yꞌö́n yo ve quitscaa. ");
INSERT INTO azgNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tso jon ndë́: —Quindyoyꞌonhoꞌhanꞌ ntjoohin. ");
INSERT INTO azgNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yajoꞌ tꞌua jon tsꞌian na cüeꞌndyuaa nnꞌan cjooꞌ jndë quijndë. Ndë joꞌ tyꞌoon jon joo ꞌon tyooꞌñeen yo ve quitscaaꞌñeen, jndondë jon quiñoonꞌndue, ndoꞌ tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ. Jndë joꞌ tyjee jon xjen ntanꞌhanꞌ ndoꞌ tyincyaa jonhanꞌ ndë́. Ndoꞌ já tyincyáhanꞌ ndëë nnꞌan na jndye jndyiꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ndoꞌ tsoñꞌen nanꞌñeen tcüaꞌ tëcjohan. Jndë joꞌ joo tyooꞌ ntanꞌ yo ninꞌquintcaa ntanꞌ na jntyꞌiihanꞌ, jnanꞌtjö́nhanꞌ, ndoꞌ jnanꞌquitꞌö́ nchoꞌve tsque yo joo ntanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ndoꞌ nnꞌan na tcüaꞌ tueeꞌ chaꞌna ꞌon min nannon, majoꞌ nanntcu yo yotsca, tajntꞌá cüentahan. ");
INSERT INTO azgNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jndë na tui na nndaꞌ, já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa Jesús, tꞌua jon tsꞌian ndë́ na quitsacüetꞌiö́ nntꞌá ndaandue na ntsquë́ cüiichen ixndya. Majoꞌ nquii jon ntjohin na njñon jndyee jon nnꞌan na jndye jndyiꞌhin, ndë joꞌ ndyontyja jon toncꞌë́n. ");
INSERT INTO azgNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ndoꞌ vi na jndë jñon jonhan na contcüeꞌhan ntꞌaahan, yajoꞌ tëva jon ncüii tyoꞌ na ninnquii jon na ntsinin jon nnon Tyoꞌtsꞌon. Ndoꞌ xjen na tëvinton, ninvaa mꞌaan jon joꞌ na ninnquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndoꞌ juu vꞌaandaa na ñjö́n, jndë tueeꞌhanꞌ xoꞌncüe ndaandue na covetꞌió, majoꞌ ndicjahanꞌ ngꞌe toju ndaandue na vaquiñjonhanꞌ juuhanꞌ, ndoꞌ mantyi ityqueꞌ ndyaꞌ jndyehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ndoꞌ chaꞌna ninnque na vitsjoon jndyoca Jesús nnon ndaandue na mꞌán yo vꞌaandaa. ");
INSERT INTO azgNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ya na jntyꞌiá na ndyoca jon nnon ndaandue, tyuë́ jndyí, jnanꞌxuá quityuë́, jnduë́: —ꞌOꞌ ntyjë, ncüaanꞌ tsꞌoo ndöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Majoꞌ ninꞌñoonꞌ tꞌman Jesús já. Itso jon ndë́: —Quinanꞌxuanhoꞌ ñuaanhoꞌ, tyiꞌndyuehoꞌ ngꞌe maja ndö. ");
INSERT INTO azgNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ndoꞌ Pedro jeꞌ, tꞌa jon ꞌndyo Jesús: —Ta, xe na aa mayuuꞌ na ncuꞌ, quitsuꞌ na ncjöca nnon ndaatioo na ncjöquitjon ja ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tso Jesús: —Quindyoꞌ. Ndoꞌ jnduiꞌ Pedro quityquiiꞌ juu vꞌaandaaꞌñeen. Taꞌ jon na taca jon nnon ndaatioo na taquitjonhin Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Majoꞌ xjen na jndyiaaꞌ jon na jndei jndyi mꞌaan jndye, jndyo ncüii na sityꞌuehanꞌhin, tyeꞌ nchjehanꞌhin quityquiiꞌ ndaaꞌñeen. Joꞌ sixuaa jon, tso jon: —Ta, cüjiꞌ ja quityquiiꞌ na toncuuꞌvahin. ");
INSERT INTO azgNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ndoꞌ ninꞌñoonꞌ tꞌuii Jesús ntꞌö juu, ndoꞌ tso jon nnon juu: —Icanhanꞌ na cantyjantyichen tsonꞌ. ¿Ndu na ve vaa sitiuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ndoꞌ juu xjen na tua ntcüeꞌhan tyquiiꞌ vꞌaandaaꞌñeen, tichen ntcüeꞌ na mꞌaan jndye. ");
INSERT INTO azgNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ngꞌe na nndaꞌ, já na mancüiixjen ñjö́n quityquiiꞌ vꞌaandaaꞌhin, tonquityë́ na tonnon Jesús. Tonanꞌtꞌmánꞌhin. Jnduë́ nnon jon: —ꞌUꞌ mayuuꞌ condui ꞌuꞌ Jnda nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ndoꞌ vi na jndë tyejndyá ndaandue, jntꞌuí ndyuaa Genesaret. ");
INSERT INTO azgNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ndoꞌ nnꞌan ndyuaaꞌñeen, xjen na taꞌjnꞌaanhin Jesús, jntꞌahan na tycya jñꞌoon ninvaa xiꞌjndio juu ndyuaaꞌñeen. Ndoꞌ joꞌ joo nnꞌan vꞌi na tomꞌan ndyuaa na mꞌanhin, tondyochohan tsoñꞌen nanꞌñeen na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tanhan jñꞌoon nnon jon na nncyaa jon na nntꞌuehan min veꞌ ꞌndyo ndiaaꞌ jon. Ndoꞌ ncüii ncüii nnꞌan na tꞌue ndiaaꞌ jon, jnꞌmanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Yajoꞌ vendye nnꞌan fariseos na jnanhan Jerusalén yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, squenonhan na mꞌaan Jesús. Taxeeꞌhan nnon jon: ");
INSERT INTO azgNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Ndu na joo nnꞌan na conanꞌjon jñꞌoon na mancyaꞌ, tyiꞌquitangueeꞌhan joo jñꞌoon na tquen ndochiihi? Ngꞌe nnꞌan ꞌnanꞌ tyiꞌquinanꞌquindëhan juu jñꞌoon na iquenhanꞌ xjen jaa na quituan nduë vitjachen na ntcüꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ndoꞌ sentcüeꞌ Jesús jñꞌoon ndëëhan, tso jon: —Ndoꞌ mantyi ꞌoꞌ, ¿Ndu na tyiꞌquitaꞌngueeꞌhoꞌ jñꞌoon na tso Tyoꞌtsꞌon na icoꞌxenhanꞌ veꞌ na ninꞌquitsantyjahoꞌ jñꞌoon na tquen ndochiihi? ");
INSERT INTO azgNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ee ndö vaa na itso jñꞌoonꞌ jon: “Quitsaꞌ na njon tyeꞌ yo ꞌndyoꞌ.” Ndoꞌ itsontyichenhanꞌ: “Minninchen tsꞌan na itso jñꞌoonviꞌ nnon tye, ndyee juu, ijndeiꞌhanꞌ na quinanꞌcueeꞌ nnꞌanhin.” ");
INSERT INTO azgNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Majoꞌ ꞌoꞌ conduehoꞌ na vanaan na ngitso tsꞌan nnon tye juu, ndyee juu: “Quitsitꞌman tsonꞌ ja, tajeꞌquindëë ntejndei ꞌuꞌ yo ꞌnan na itsitjahanꞌ ꞌuꞌ, ngꞌe tsoñꞌen ꞌnan njan jndë tyincyahanꞌ cüentaaꞌ Tyoꞌtsꞌon.” ");
INSERT INTO azgNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ndoꞌ contꞌahoꞌ na minꞌcya ro tsꞌan na ngitso na nndaꞌ, min tyiꞌicanhanꞌ na quitsꞌaa juu na njon tye juu, ndyee juu na ntixeeꞌ juuhan. Ndoꞌ na nndaꞌ conduehoꞌ, contꞌahoꞌ na juu jñꞌoonꞌ Tyoꞌtsꞌon taꞌnan najndeihanꞌ ngꞌe contꞌahoꞌ na njonntyichen joo jñꞌoon na tquen ndochihoꞌ, chintyi jñꞌoon na tso nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ꞌOꞌ na ve vaa na contꞌahoꞌ, juu jñꞌoon na toninncyaa Isaías, ya tacüjiꞌhanꞌ ntyja ꞌnaanhoꞌ. Ndö vaa na itso juu jñꞌoonꞌñeen: ");
INSERT INTO azgNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nanminꞌ veꞌ yo jñꞌoon jndyuehin conanꞌtꞌmaanꞌhan ja. Majoꞌ tꞌman vaa na tyiꞌxoncüeeꞌ nꞌonhan yo ja. ");
INSERT INTO azgNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Veꞌ jnꞌaan na conanꞌtꞌmaanꞌhin ja ngꞌe veꞌ jñꞌoon na conanꞌjndaꞌ nnꞌan conanꞌmanhan, chito aa jñꞌoon njan. Nndaꞌ vaa itsiquindyi juu jñꞌoon na toninncyaa Isaíasꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jndë joꞌ tꞌman Jesús nnꞌan na jndye jndyiꞌhin na quinanꞌndyooꞌhan na mꞌaan jon. Tso jon ndëëhan: —Quindyehoꞌ jñꞌoon na ntsjö ndoꞌ cüaaꞌ nꞌonhoꞌhanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Joo ꞌnan na icüaꞌ tsꞌan, tyiꞌxeꞌquitsꞌaahanꞌ na tyiꞌjiꞌua tsixuan juu na tonnon Tyoꞌtsꞌon. Majoꞌ jñꞌoon tsanꞌ na itsinin tsꞌan, joohanꞌ iquenhanꞌ tsanꞌñeen na tyiꞌjiꞌua tsixuan juu na tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ndoꞌ já nnꞌan na tqueenꞌ Jesús na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, santyjáꞌ nnon jon, jnduë́ nnon jon: —¿Aa nchjiꞌ na juu jñꞌoon sininꞌ ndöꞌ, siꞌndaaꞌhanꞌ ngio nnꞌan fariseosꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Joꞌ sintcüeꞌ jon jñꞌoon ndë́ na tyiꞌquitso nquiiꞌ jonhanꞌ, itso jon: —Nquii Tyëhöꞌ na mꞌaan quiñoonꞌndue, ncüii cüii nnon ntjon na chito jon jnonꞌhanꞌ, nque jonhanꞌ xen nchꞌiooꞌchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mangꞌe joꞌ tancꞌoon jñꞌoontiuhoꞌ ntyja ꞌnaan nanminꞌ. Itsijonhanꞌ ntyja ꞌnaanhin chaꞌvijon nannchjan na conanꞌmanhan nato ndëë ntyje nchjanhan. Ndoꞌ mangiohoꞌ xjen na vayꞌoon tsannchjaanꞌ tyjenchjaanꞌ juu, ninvaa vehan ntycyaahan tsëꞌtsjoon. ");
INSERT INTO azgNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ndoꞌ joꞌ tso Pedro nnon Jesús, tso juu: —Quitsiꞌmanꞌ chjo ndë́ nin ninꞌquitsiquindyi juu jñꞌoonvaꞌ na tyiꞌquitso nquiiꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sintcüeꞌ Jesús jñꞌoon, itso jon: —¿Aa min ꞌoꞌ ndicüaaꞌ nꞌonhoꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aa tyiꞌquindiohoꞌ na tsoñꞌen ꞌnan na icüaꞌ tsꞌan, xiaꞌntyi quityquiiꞌ tsiaaꞌ juu coꞌohanꞌ, chito quiiꞌ ñuaanꞌ juu. Ndoꞌ ndë joꞌ chi ncja juu ꞌndyo jndëë. ");
INSERT INTO azgNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Majoꞌ joo jñꞌoon na itsinin tsꞌan, quityquiiꞌ tsꞌon juu conanhanꞌ, ndoꞌ joohanꞌ cotquenhanꞌhin na tyiꞌjiꞌua tsixuan juu tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ee quityquiiꞌ tsꞌon tsꞌan conan jñꞌoon tyia na itsitiu juu na ntscueeꞌ juu tsꞌan, ndoꞌ mantyi na veꞌ ndö ro ncꞌoon juu yo cüiichen tsꞌan na chito saaꞌ juu min chito scuuꞌ juu, oo na ncꞌoon juu yo tyje sꞌa juu, tyje scu juu, oo na nchꞌuee juu, oo na ntsinin juu quintu cjooꞌ cüiichen tsꞌan, oo jñꞌoon tsanꞌ, jñꞌoon ntjein. ");
INSERT INTO azgNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Joo nanꞌminꞌ cotquenhanꞌhin na tyiꞌjiꞌua tsixuan juu na tonnon Tyoꞌtsꞌon, majoꞌ na ntcüaꞌ tsꞌan na veꞌ tyiꞌquiman juu ntꞌö chaꞌxjen jñꞌoon na cotquen nnꞌan fariseos, juuhanꞌ tyiꞌxeꞌquenhan tsꞌan na tyiꞌjiꞌua conduihin na tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yajoꞌ jnduiꞌ Jesús joꞌ, sá yohin na tja jon ndyuaa tsjoon Tiro yo Sidón. ");
INSERT INTO azgNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ndoꞌ cüii tsanscu tsjan nnꞌan cananita na mꞌaan ya juu ndyuaaꞌñeen, tëtsindyooꞌhin na mꞌaan Jesús, jndei sixuaa juu nnon jon, itso juu: —Nndaꞌ ta na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cyonꞌ na ntyꞌia rö nchjiꞌ. Juu yuscu chjo jnda, ji vaa jndyi iquenon juu na mꞌaan jndyetyia quiiꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Majoꞌ tajñꞌoon tꞌa Jesús. Joꞌ jnanꞌndyooꞌ já nnon jon, jnduë́: —Cüa, quijñonꞌ tsanscuvaꞌ, ngꞌe itscüëtëꞌ jon já na ndyotsixuaa jon toncꞌën. ");
INSERT INTO azgNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tꞌa Jesús, tso jon: —Xiaꞌntyi iꞌua Tyoꞌtsꞌon tsꞌian nnön na quindyoyꞌön jñꞌoon naya ꞌnaanꞌ jon tondëë nnꞌan ndyuaa Israel. Ngꞌe joohin itsijonhanꞌhin chaꞌvijon quinman na jndë tsu. ");
INSERT INTO azgNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Majoꞌ tsanscuꞌñeen sindyooꞌhin, tëcoꞌxtye jon nnon Jesús, tso jon: —Nndaꞌ ta, quitejndeiꞌ ja, riiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tꞌa Jesús, sinin jon jñꞌoon na tyiꞌquitso nquiiꞌ jonhanꞌ, itso jon: —Joo yotsca na cocüaꞌ, tyiꞌquichuhanꞌ na ncüjiꞌ tsꞌan ꞌnan jndyue joo ndoꞌ na ncjuꞌ juuhanꞌ ndëë quindëꞌ quijndë. ");
INSERT INTO azgNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ndoꞌ tꞌa tsanscuꞌñeen ꞌndyo jon: —Mayuuꞌ ta, majoꞌ min na nndaꞌ, quindëꞌ quijndë cocüaꞌ oꞌ ꞌnan quijndë na cocyaa nacjeeꞌ mesa ꞌnaanꞌ tyꞌo oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ndoꞌ tꞌa Jesús ꞌndyo tsanscuꞌñeen, itso jon: —ꞌUꞌ tsanscu, tꞌman vantyja tsonꞌ. Quindui chaꞌxjen na macanꞌ. Ndoꞌ majuuto xjenꞌñeen jnꞌman yuscu chjo jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jndë na jnduiꞌ Jesús joꞌ, sá yohin na tja ntcüeꞌ jon ꞌndyo ndaandue Galilea. Tëva jon cüii tyoꞌ, tëcüetyen jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Jndye jndyi nnꞌan squehan na mꞌaan jon. Ndoꞌ jndyochohan vendye nnꞌan ntjein ngꞌe, yo nnꞌan na nchjan yo nnꞌan na tyiꞌquindë nduee, yo nnꞌan na ndiquinanꞌnein, yo nnꞌan na mañoon ntycu totjon. Tquenhan nnꞌan vꞌiꞌñeen tonnon Jesús, ndoꞌ sinꞌman jonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ndoꞌ joo nnꞌan na jndye jndyiꞌhin, tyincyaahanꞌ na tëveeꞌ jndyi ngiohan na jntyꞌiahan na joo nnꞌan na ndiquinanꞌnein, ya conanꞌneinhan, joo nnꞌan na tyiꞌquindë nduee, yo ngꞌe, jndë tcoꞌ yahanꞌhin, ndoꞌ nnꞌan nchjan, xuee cojntyꞌiahan. Ndoꞌ tonanꞌtꞌmaanꞌ nanꞌñeen nquii Tyoꞌtsꞌon cüenta nnꞌan Israel. ");
INSERT INTO azgNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Tꞌman Jesús já nnꞌan na cotsayꞌö́n yo jñꞌoon toninncyaa jon. Tso jon: —Ntyꞌia ro nanminꞌ nchji ngꞌe nein jndë jndë ndye xuee na mꞌanhan yo ja ndoꞌ jndë ntycüii ꞌnan na yꞌonhan na ntcüaꞌhan. Ndoꞌ tyiꞌninꞌquijñön ntcüꞌëhan ntꞌaahan na ninvaa ninꞌjndoꞌhan, ngꞌe nndëë ntsꞌaahanꞌ na ngüejaanhan nato. ");
INSERT INTO azgNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Joꞌ jnduë́ nnon jon: —Ntjoohin veꞌ jndëë mꞌan jaa. ¿Yuu jon ya nnanꞌjntꞌá ꞌnan na nninnonhanꞌ na ntcüaꞌ nanminꞌ na jndye jndyihin? ");
INSERT INTO azgNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ndoꞌ taxeeꞌ Jesús ndë́, tso jon: —¿Tsaꞌnndaꞌ tyooꞌ yꞌonhoꞌ? Joꞌ jnduë́ nnon jon: —Ninntyqueꞌhanꞌ yo vendye quintcaa quijndë. ");
INSERT INTO azgNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ndoꞌ tꞌua jon tsꞌian ndëë nnꞌan na jndye jndyiꞌhin na cüendyuaahan tyuaa. ");
INSERT INTO azgNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ndoꞌ tyꞌoon jon cüenta tyooꞌñeen yo quintcaaꞌñeen, ndoꞌ vi jndë na tyincyaa jon na ncya ya Tyoꞌtsꞌon, yajoꞌ tyjee jon xjen ntanꞌhanꞌ ndoꞌ tyincyaa jonhanꞌ ndë́, ndoꞌ já tꞌö́nhanꞌ ndëë tsoñꞌen nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ndoꞌ tsoñꞌenhan tcüaꞌ tëcjohan. Ndoꞌ ntanꞌ quijndë na jntyꞌiihanꞌ, tueeꞌ ntyqueꞌ ntque na jnanꞌquitꞌö́ yohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ndoꞌ joo nnꞌan na tcüaꞌ, chaꞌna ninnque min nannon min tajntꞌahan cüenta tsaꞌnndaꞌ nanntcu yo yotsca. ");
INSERT INTO azgNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ndoꞌ vi na jndë tyincyaa Jesús tsꞌon nanꞌñeen, yajoꞌ tua nndaꞌ jon vꞌaandaa, sá yohin, squë́ ndyuaa Magadán. ");
INSERT INTO azgNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nque nnꞌan tmaanꞌ fariseos yo nnꞌan tmaanꞌ saduceos squehan na mꞌaan Jesús. Tanhan nnon jon na quitsꞌaa jon jnꞌaan na njntyꞌiahan na ntsiꞌmanhanꞌ na mayuuꞌ na jnan jon quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Majoꞌ sintcüeꞌ Jesús jñꞌoon ndëëhan, tso jon: “Ya na jndë tman ndoꞌ cojntyꞌiahoꞌ na mꞌaan chincyu vequindyaꞌ tsjöꞌndue, conduehoꞌ na ya jndyi nnonco cüiichen xuee.” ");
INSERT INTO azgNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Majoꞌ vi na jndë tonco juu xueeꞌñeen, ndoꞌ cojntyꞌiahoꞌ na ntyja chincyu jntꞌa na colo ve, conduehoꞌ na nguaꞌ. ꞌOꞌ nnꞌan na tyiꞌninncüii cotjiꞌhoꞌ cüenta, ꞌoꞌ jndaꞌ nquenhoꞌ na cotjiꞌhoꞌ cüenta ntyja ꞌnaanꞌ chincyu na ntyja tsjöꞌndue, majoꞌ ndicüaaꞌ nꞌonhoꞌ nin ninꞌquitsiquindyi joo tsꞌian tꞌman na cojntyꞌiahoꞌ na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Tsontyichen Jesús: “Nnꞌan na mꞌan nanein, tyia nnꞌanhan, jndë jntyꞌehan Tyoꞌtsꞌon, majoꞌ min na nndaꞌ, cotanhan na njntyꞌia ndëëhan cüii jnꞌaan tꞌman. Majoꞌ tyiꞌjeꞌquitsꞌa ꞌnan na cotanhan, xiaꞌntyi cüaaꞌ nꞌonhan nchu vaa itsiꞌmanhanꞌ ꞌnan na tquenon juu Jonás.” Jndë joꞌ tja jon, jntyꞌii jon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ndoꞌ sá nntꞌá cüiichen ixndyaaꞌ ndaandue. Ndoꞌ vi na jndë squë́ joꞌ yo Jesús, tëñjoonꞌ nꞌö́n na tsuuꞌ tcya nꞌö́n na ntsayꞌö́n ꞌnan na ntcüꞌá. ");
INSERT INTO azgNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tso jon ndë́: —Quitquen jndyohoꞌ cüenta ntyja ꞌnaanꞌ juu tsquentë na nanꞌxuan nnꞌan tmaanꞌ fariseos yo nnꞌan tmaanꞌ saduceos. ");
INSERT INTO azgNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ndoꞌ já na tꞌman jon na quinanꞌjö́n yo jñꞌoon toninncyaa jon, tꞌá na conanꞌnë́n nquë́ ndëë ntyjë́, jnduë́: —Nndaꞌ jñꞌoon tsinin jon ndëë ngꞌe taꞌnan cyꞌön ꞌnan ntcüꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Majoꞌ taaꞌ tsꞌon Jesús na nndaꞌ mꞌaanꞌ nꞌö́n, joꞌ tso jon ndë́: —ꞌOꞌ na chjo vantyja nꞌonhoꞌ. ¿Ndu na conanꞌneinhoꞌ ndëë ntyjeehoꞌ ngꞌe na tajndyoyꞌonhoꞌ ꞌnan na ntcüꞌa? ");
INSERT INTO azgNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Aa tyiꞌcovaaꞌ nꞌonhoꞌ jñꞌoonvaꞌ na tsjö? ¿Aa tyiꞌcañjoonꞌ nꞌonhoꞌ joo ꞌon tanꞌ tyooꞌñeen na tyjë xjen ntanꞌhanꞌ na tcüaꞌ ꞌon min nnꞌan ndoꞌ tiꞌndyo tsque na tua tyooꞌ ntanꞌ na jntyꞌiihanꞌ na jnanꞌvehoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ndoꞌ ¿Aa min tyiꞌcañjoonꞌ nꞌonhoꞌ cüiichen ntyqueꞌ tanꞌ tyooꞌ na tcüaꞌ ninnque min nanꞌñeen, ndoꞌ mantyi tiꞌndyo tsque na tua tyooꞌ ntanꞌ na jntyꞌiihanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ndoꞌ na sꞌa nanꞌminꞌ, ¿Ndu na tataaꞌ nꞌonhoꞌ na min chito matsinën ntyja ꞌnaanꞌ ꞌnan na ntcüꞌa? Matsjö na quitquenhoꞌ cüenta juu tsquentë na nanꞌxuan nnꞌan tmaanꞌ fariseos yo nnꞌan saduceos. ");
INSERT INTO azgNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yajoꞌ taaꞌ nꞌö́n na chito tso jon na quitquë́n cüenta juu tsquentë na coninjntꞌue na condë tyooꞌ, majoꞌ tsiꞌman jon ndë́ na quintꞌá cüenta ntyja ꞌnaanꞌ joo jñꞌoon na conanꞌman nnꞌan fariseos yo nnꞌan saduceos. ");
INSERT INTO azgNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ndoꞌ vi na jndë squë́ ndyuaa cüentaaꞌ tsjoon Cesarea Filipo yo Jesús, já na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, taxeeꞌ jon ndë́, tso jon: —Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ¿Nin tsꞌan condue nnꞌan na condui ja? ");
INSERT INTO azgNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tꞌá ꞌndyo jon, jnduë́: —Mꞌan nnꞌan conduehan na ꞌuꞌ Juan, nquii tsan na totsiquindëëꞌ nnꞌan. Ndoꞌ ñꞌen nnꞌan conduehan na ꞌuꞌ Elías, ndoꞌ vandyaꞌ mꞌan nnꞌan na conduehan na ꞌuꞌ Jeremías oo cüiichen tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yajoꞌ taxeeꞌ jon ndë́: —Ndoꞌ ꞌoꞌ jeꞌ, ¿Nin tsꞌan conduehoꞌ na condui ja? ");
INSERT INTO azgNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tꞌa Simón Pedro ꞌndyo jon, itso juu: —ꞌUꞌ condui nquii Mesías, Jnda Tyoꞌtsꞌon na vandoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tso Jesús nnon Pedro: —ꞌUꞌ Simón, jnda Jonás, ngꞌe na mavaaꞌ tsonꞌ na nndaꞌ, tꞌman jndyi ityio Tyoꞌtsꞌon jnꞌaan ꞌuꞌ ngꞌe chito aa veꞌ tsꞌan siꞌmanhanꞌ nnonꞌ, nquii Tyëhöꞌ na mꞌaan quiñoonꞌndue, juu jon incyaa na mavaaꞌ tsonꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ꞌUꞌ jndyuꞌ Pedro, jñꞌoon na tsiquindyihanꞌ tsjöꞌ, ndoꞌ nacjooꞌ jñꞌoon jndyoyu na tsuꞌ ntyja njan, joꞌ ntquën tmaanꞌ nnꞌan na macüji ntyja njan. Ndoꞌ min yotyia na mꞌan quityquiiꞌ vꞌio na nanꞌxuan najndë tyiꞌjeꞌquindëë ntjueꞌ cjehin joo nnꞌan na conduihan tmaanꞌ cüenta ja. ");
INSERT INTO azgNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja nninncya na ntsixuanꞌ najnduꞌ na ntsiꞌman jndyoyuꞌ ndëë nnꞌan nin jñꞌoon na nninncyahan chaꞌ cüaaꞌ nꞌonhan nin ꞌnan quintꞌahan, chaꞌ ndëë ntyeꞌntjon Tyoꞌtsꞌonhan. Jñꞌoon na ntsuꞌ na tyiꞌitsohanꞌ na nntꞌa nnꞌan na conduihan cüentaaꞌ Tyoꞌtsꞌon, ntsijonhanꞌ juu jñꞌoonꞌñeen yo jñꞌoon na ntyjii nquii jon. Ndoꞌ jñꞌoon na ntsuꞌ na vanaan na ntꞌa nnꞌan, mantyi ntsijonhanꞌ juuhanꞌ chaꞌxjen jñꞌoon na ntyjii nquii jon na vanaan na nque nnꞌan na conduihin cüentaaꞌ jon quintꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ndoꞌ jaaꞌ jñꞌoon na tso Jesús ndë́ na minꞌncüii nnon tsꞌan tyiꞌnanꞌmán na nquii jon conduihin Mesías. ");
INSERT INTO azgNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Xjenꞌñeen já na cotsayꞌö́n yo jñꞌoon na toninncyaa Jesús, taꞌ jon na itsiꞌman jon ndë́ na mancüii xjen icanhanꞌ na chi ncja jon Jerusalén. Ndoꞌ joo nnꞌan na conintque ndëë nnꞌan na mꞌan juu tsjoonꞌñeen, yo ntyee na conintque ndëë nanꞌñeen, yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, nnanꞌjndaꞌ nanꞌñeen na ntquenon jon naviꞌ tꞌman ndoꞌ nntꞌahan na cueꞌ jon, majoꞌ xee na jndë ndye ngüandoꞌ xco jon. ");
INSERT INTO azgNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ndoꞌ vi na jndë jndyii Pedro na nndaꞌ, tëyꞌoon jon Jesús vi ntyja, taꞌ jon na jaaꞌ jñꞌoon tso jon nnon Jesús, tso juu: —Tyiꞌntsitiuꞌ na nndaꞌ, ta, tyiꞌjon ncyaa Tyoꞌtsꞌon na ngenoonꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tequen Jesús, itso jon nnon Pedro: —Quenanꞌ ꞌuꞌ na tonön, ꞌuꞌ yo Satanás mavayonꞌ jñꞌoon. ꞌUꞌ ninꞌquitsaꞌ na ntsitja ja, ngꞌe chito mꞌaanꞌ tsonꞌ chaꞌxjen itsitiu nquii Tyoꞌtsꞌon, ꞌuꞌ mꞌaanꞌ tsonꞌ chaꞌxjen na mꞌaanꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jndë joꞌ tso Jesús ndë́ na cotsayꞌö́n yo jñꞌoon na toninncyaa jon: —Minninchen tsꞌan na ninꞌcayꞌoon juu yo jñꞌoon na mancya, icanhanꞌ na cüjihin yo ꞌnan na itsitiu nquii juu. Quintjo ya nchjii juu yo naviꞌ na iquenon juu, min xe na aa ntyja ꞌnaanꞌ joꞌ ntscueeꞌhanꞌhin, ndoꞌ mantyi quindyontsijonhin yo ꞌnan na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ngꞌe minninchen tsꞌan na incyaa juu na cuaanquii na nin ꞌnan na ngenon juu, ngꞌe na mꞌaan juu ntyja njan, tsanꞌñeen ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu. Majoꞌ minninchen tsꞌan na itsijndaꞌ nquii juu nchu ya chaꞌ ntyja ꞌnaanꞌhanꞌ ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu, ntyja ꞌnaanꞌ joꞌ ngitsu ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Tanin, min xe na aa ninvaa tsonnangue ngüantjon tsꞌan, majoꞌ xe na aa ngitsu ñuaanꞌ juu, ¿Yuu vaa na itejndei nanꞌñeenhin? Mangiohoꞌ na taꞌnan ncüii nnon na nninncyaa tsꞌan na ngüañoonꞌhanꞌ juu chaꞌ ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja na condui tsansꞌa na tꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, nndyö nntꞌa tsonnangue yo ángeles cüentaaꞌ Tyëhöꞌ. Yajoꞌ chaꞌxjen conditꞌmaanꞌ jon, majoꞌntyi ntsixuan ja. Juu xjenꞌñeen ntsꞌa na ncüii cüii tsꞌan ncyꞌoon juu cüenta ntyjantyi ꞌnan na totsꞌaa juu, aa ꞌnan na ya, ndoꞌ aa ꞌnan natyia. ");
INSERT INTO azgNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, quiiꞌ ntꞌanhoꞌ mꞌan ntyjeehoꞌ na tyiꞌxeꞌcüjehan ata xjen na jndë jntyꞌia ndëëhan ja na condui tsꞌan na jnan quiñoonꞌndue na ncüjë na ntyentjön. ");
INSERT INTO azgNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jndë na tenon yon xuee na tso Jesús na nndaꞌ, ndoꞌ tëyꞌoon jon Pedro yo Santiago yo ninꞌJuan tyje Santiago. Tëchu jonhin xquen cüii tyoꞌ ndye naijon na ninnquehan. ");
INSERT INTO azgNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Xjen na cojntyꞌiahan ndoꞌ siñoonhanꞌ jon tondëëhan, sꞌaahanꞌ na maninꞌ conduiꞌnduiꞌ nnon jon chaꞌvijon na xuee ndoꞌcüjioonꞌ. Ndoꞌ iscüaquenhanꞌ ndiaaꞌ jon na quichiꞌhanꞌ chaꞌxjen quichiꞌ na xuee chon. ");
INSERT INTO azgNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ndoꞌ juu xjenꞌñeen tityincyooꞌ ve nnꞌan na tomꞌan tivio, Moisés yo ninꞌElías, jnanꞌneinhan yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ndoꞌ veꞌ tsoto Pedro nnon jon: —Nndaꞌ Ta, vaa ya jndyi na mꞌán ntjoohin. Xe na aa caveeꞌ nchjiꞌ, nnanꞌyá ndye xqueꞌ ntjoohin, cüiihanꞌ cüentaꞌ ncuꞌ, cüiihanꞌ cüentaaꞌ Moisés, ndoꞌ ninꞌcüiichenhanꞌ cüentaaꞌ Elías. ");
INSERT INTO azgNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ninvaa na itsinin Pedro, ndoꞌ jndyoquioo ncüii chincyu quichiꞌ na quixuee jndyihanꞌ nacjohan. Iscuꞌhanꞌhin. Jndyehin jndyeeꞌ nquii Tyoꞌtsꞌon quityquiiꞌ juu chincyuꞌñeen, tso jon: —Juu tsansꞌavahin conduihin Jnda na venchji jndyihin. Ninnquiiꞌchen incyaahanꞌ na nën ntyja ꞌnaanꞌ jon. Quitangueeꞌhoꞌ jñꞌoon na incyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ndoꞌ joo ndye nanꞌñeen na totsayꞌonhan jñꞌoon yo Jesús, xjen na jndyehan juu jñꞌoonvaꞌ, tyetaꞌngiohan xenꞌ tyuaachen, mioon jndyi tyuehan. ");
INSERT INTO azgNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Majoꞌ sindyooꞌ Jesús na mꞌanhan. Tꞌuii jonhan, tso jon ndëëhan: —Quinanꞌquintyjahoꞌ. Tyiꞌntyuehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ndoꞌ xjen na jndondëhan, minꞌncüii tsꞌan tavijntyꞌiahan, xiaꞌntyi nquii Jesús vi mꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ndoꞌ viochen xjen na tyecuehan juu tyoꞌñeen, jaaꞌ jñꞌoon sinin Jesús ndëëhan, tso jon: —Viochen xjen na ninvaa vantꞌö, minꞌncüii nnon tsꞌan tyiꞌnduehoꞌ ꞌnan na jntyꞌiahoꞌ quichen. Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ncüꞌiö, ndë joꞌ ngüantꞌö xcö. Juu xjenꞌñeen vanaan na nnanꞌneinhoꞌ ndëë nnꞌan juu ꞌnan na jndë jntyꞌia ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yajoꞌ já na totsayꞌö́n yo jñꞌoon na toninncyaa jon, taꞌxꞌë nnon jon: —Ndoꞌ nnꞌan na conanꞌman nchu vaa tsiꞌman jñꞌoon na tquen Moisés ¿Ndu conduehan na itsohanꞌ na juu Elías ncüjeeꞌ jndyee, ndë joꞌ ncüjeeꞌ Cristo? ");
INSERT INTO azgNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Joꞌ tꞌa Jesús jndyuë́: —Mayuuꞌ na conanꞌmanhan na Elías ncüjeeꞌ jndyee, ndoꞌ ntsijndaꞌ jon tsoñꞌen. ");
INSERT INTO azgNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Majoꞌ ja matsjö ndëëhoꞌ na jndë tyjeeꞌ jon, min tataaꞌ nꞌon nnꞌan ntyja ꞌnaanꞌ jon. Ndoꞌ jntꞌahan yo jon chaꞌxjen na ntꞌue nꞌonhan. Ndoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, majoꞌntyi nntꞌahan yo ja. ");
INSERT INTO azgNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Joꞌ taaꞌ nꞌö́n na itsinin Jesús ndë́ ntyja ꞌnaanꞌ nquii Juan, tsan na totsiquindëëꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ndoꞌ vi na jndë squë́ ntꞌá naijon na mꞌan nnꞌan na jndye jndyiꞌhin, jndyo sindyooꞌ cüii tsansꞌa na mꞌaan Jesús. Tacoꞌxtye juu na tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Itso juu: —Nndaꞌ ta, cꞌonꞌ na ndyiaꞌ ro ntyjiꞌ yusꞌachjo jnda. Ee nayꞌoon jndyetyiahin ndoꞌ ji vaa jndyi iquenon juu. Jndye jnda itsquioohanꞌhin quityquiiꞌ chon, ndoꞌ mantyi quiiꞌ ndaa. ");
INSERT INTO azgNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndoꞌ jndyoyꞌönhin na mꞌan nnꞌan na cotsayꞌon yo jñꞌoon na mancyaꞌ, majoꞌ tyíꞌquindëë nnanꞌnꞌmanhan juu. ");
INSERT INTO azgNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nquë́ na totsayꞌö́n jñꞌoon yo Jesús, tꞌa jon, tso jon ndë́: —ꞌOꞌ nnꞌan na tyiꞌninꞌcantyja nꞌonhoꞌ ja na conanꞌqueꞌto nꞌonhoꞌ. ¿Tsaꞌnndaꞌ xjen vio na icanhanꞌ na nntjo ja yohoꞌ na ntsiꞌmanntyëchën ndëëhoꞌ? ¿Tsaꞌnndaꞌ xuee na icanhanꞌ na ntsꞌa tsꞌian quiiꞌ ntꞌanhoꞌ ata na ncüaaꞌ ya nꞌonhoꞌ nchu vaa najndei na tsixuan Tyoꞌtsꞌon? Quindyoyꞌonhoꞌ yusꞌachjöhöꞌ ntjoohin. ");
INSERT INTO azgNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yajoꞌ sityiaꞌ Jesús juu jndyetyiaꞌñeen ndoꞌ yo najndeiꞌhanꞌ sꞌaa jon na quinduiꞌhanꞌ quiiꞌ tsꞌon yuꞌñeen. Maninñoonꞌ jnꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jndë na tui na nndaꞌ, yajoꞌ já na conanꞌjö́n yo jñꞌoon na toninncyaa jon, jntꞌuí vi ntyja naijon na ninnquë́ yohin. Taꞌxꞌë́ nnon jon: —¿Ndu na tyíꞌquindëë ntjíꞌ jndyetyiaꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Sentcüeꞌ Jesús jñꞌoon ndë́, itso jon: —Jnaanꞌ na tyiꞌvantyja ya nꞌonhoꞌ Tyoꞌtsꞌon, joꞌ na tajndëë jntꞌahoꞌ. Majoꞌ tanin, min xe na aa chjo vantyja nꞌonhoꞌ chaꞌxjen quijndë cüii ntqueenꞌ mostaza, majoꞌ tꞌman tsꞌian nndëë ntꞌahoꞌ. Min na covenonhoꞌ ncüii na jndyaaꞌ jndyi na ntꞌahoꞌhanꞌ, na itsijonhanꞌ juuhanꞌ ngiohoꞌ chaꞌvijon tyoꞌ tꞌman, majoꞌ nndëë ntꞌahoꞌ. Quinduehoꞌ nnonhanꞌ: “Quenanꞌ tonnön, cjaꞌ ndöꞌñeenchen,” Ndoꞌ ngenaanꞌhanꞌ. Ee taꞌnan cüii nnon na tyiꞌjeꞌquindëë ntꞌahoꞌ xe na aa covantyja nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Majoꞌ jndyetyiaminꞌ icanhanꞌ na quityje tsꞌan ꞌnan ꞌndyo tsꞌan ndoꞌ na ntsinin juu nnon Tyoꞌtsꞌon chaꞌ nndëë ncüjiꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ndoꞌ viochen xjen na tomantyꞌí ndyuaa Galilea, tso Jesús ndë́ na juu jon na conduihin tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na coxen jon tsoñꞌen nnꞌan, mꞌaan nin juu na nninncyaa cüentahin nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ndoꞌ nnanꞌcueeꞌ nnꞌanhin, majoꞌ xee na jndë ndye nninncyaa Tyoꞌtsꞌon na ngüandoꞌ xco jon. Vi na jndë jndyë́ na nndaꞌ, sichjooꞌ jndyihanꞌ nꞌö́n. ");
INSERT INTO azgNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jndë na tueeꞌ Jesús tsjoon Capernaum yo já nnꞌan na cotsayꞌö́n yo jñꞌoon toninncyaa jon, joo nnꞌan na cotye sꞌon cüentaaꞌ vatsꞌon tꞌman, squehan na mꞌaan Pedro. Jnduehan nnon jon: —Juu tsan na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndëëhoꞌ, ¿Aa tyiꞌityion jon sꞌon cüentaaꞌ vatsꞌon tꞌman? ");
INSERT INTO azgNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tꞌa Pedro, itso jon: —Ityion jonhanꞌ. Jndë tiquiuuꞌ chjo na tui na nndaꞌ, ndoꞌ tueeꞌ Pedro na vaa vꞌaa, tëqueeꞌ jon joꞌ. Ndoꞌ Jesús jeꞌ, tityuaaꞌntyi jon, taꞌ jon na sinin jon jñꞌoon tyiꞌquitsiꞌman nquiiꞌhanꞌ nnon Pedro. Tso jon: —ꞌUꞌ Simón, ¿Nchu vaa macüjiꞌ cüenta? Joo nnꞌan na mꞌan nꞌian tꞌman, ¿Nin nnꞌan matsitiuꞌ na cotꞌua nanꞌñeen tsꞌian ndëëhin na quityionhan sꞌonndyuaa? ¿Aa nnꞌan ndyuaahan na ntquenhan jñꞌoon na quityion nanꞌñeen sꞌonꞌñeen, ndoꞌ aa nnꞌan na veꞌ cotsque ya? ");
INSERT INTO azgNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tꞌa Pedro ꞌndyo jon, tso juu: —Nnꞌan na veꞌ cotsque ya, joohan contꞌa nanmꞌannꞌian tꞌman na quityionhan sꞌonꞌñeen, chito nnꞌan na mꞌan ndyuaahan. Tsochen Jesús: —Yajoꞌ joo nnꞌan ndyuaahan, tyiꞌicanhanꞌ na ndyionhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Majoꞌ min na nndaꞌ, chaꞌ tyiꞌnanꞌvjee nnꞌan na conanꞌncüi sꞌon cüentaaꞌ juu vatsꞌon tꞌman, ndyiön chaꞌxjen na ntꞌue nꞌonhan. Mangꞌe joꞌ cjaꞌ ꞌndyo ndaandue, cjuꞌ tsiꞌquintycüe. Quitscaa na ncüjiꞌ jndyeeꞌ, quitsinueinꞌ ꞌndyo oꞌ, joꞌ ntjiꞌ cüii xoquituꞌ na juuhanꞌ ndinonhanꞌ na ndyionꞌ ntyja njan ndoꞌ yo ntyja ꞌnanꞌ. Cayonꞌhanꞌ, na nninncyaꞌhanꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Majuuntyi xjenꞌñeen já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa Jesús, santyjáꞌcyá na mꞌaan jon. Taꞌxꞌë nnon jon, jnduë́: —¿Nin juu ncꞌoon na njonntyichen conduihin naijon na ityentjon Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yajoꞌ tꞌman Jesús ncüii yuchjo, tquen jonhin xoncüe quiiꞌ ntꞌán. ");
INSERT INTO azgNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Itso jon ndë́: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, icanhanꞌ na quintcüeꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ ꞌnan na conanꞌtiuhoꞌ, ndoꞌ cꞌonhoꞌ chaꞌna yoquijndë na tyiꞌquinanchon joo na ndinjonhin, yajoꞌ nndëë nnanꞌjonhoꞌ ntyja ꞌnaanꞌ na ityentjon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yajoꞌ minꞌcya ro tsꞌan na ijuꞌcjehin min tyiꞌquintꞌue juu na ndiquinjonhin, itsijonhanꞌhin chaꞌna yuchjova. Juu tsanꞌñeen njonntyichen conduihin naijon na ityeꞌntjon nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ndoꞌ minninchen tsꞌan na yo xuë iyꞌoon juu cüenta ncüii yuchjo chaꞌna yuvahin, ncö iyꞌoon tsanꞌñeen cüenta. ");
INSERT INTO azgNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Majoꞌ minꞌninchen tsꞌan na itsꞌaa juu ncüii ꞌnan na ntyja ꞌnaanꞌhanꞌ na ngacüaaꞌ ncüiichen tsꞌan na tyiꞌtꞌman na vantyja tsꞌon juu ja, yantyichen na nnanꞌtyen nnꞌan tosu tꞌman xtyoꞌ tsanꞌñeen ndoꞌ quitjueꞌhanhin quiiꞌ ndaandue, cueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Viꞌ jndyi na coquenon nnꞌan tsonnangue na jndye nnon ꞌnan tyia na contꞌahan na ntyja ꞌnaanꞌhanꞌ na vacüaaꞌ nnꞌan na tonnon Tyoꞌtsꞌon. Majoꞌ tanchu ya, ngꞌe mancüiixjen minhanꞌ. Majoꞌ juu tsꞌan na itsꞌaa juu ꞌnan na ntyja ꞌnaanꞌhanꞌ na ngacüaaꞌ cüiichen tsꞌan na quitsꞌaa juu ꞌnan tyia, viꞌ jndyi ngenon tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Cüii ntꞌöꞌ, cüii ngꞌeꞌ, xe na aa ntyja ꞌnaanꞌhanꞌ ngacüaaꞌ ꞌuꞌ na tonnon Tyoꞌtsꞌon na matsitja ꞌuꞌ, quenꞌ xjen joohanꞌ chaꞌvijon jndë tyjeꞌhanꞌ na ntyqueꞌhanꞌ, chaꞌ tantsitjantyi ꞌuꞌ. Ngꞌe yantyichen min xe na aa tyiꞌquindë ꞌuꞌ chaꞌ na nndëë ntsixuanꞌ na tyiꞌquintycüii na ngüandoꞌ ñuan ꞌnanꞌ, chito na quindë ꞌuꞌ ndoꞌ na ntjueꞌ ángeles ꞌuꞌ quiiꞌ chon na tyiꞌjon quinduuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ndoꞌ mantyi xe na aa veꞌ tsojnaanꞌ ꞌnan na mandyiaꞌ itsꞌaahanꞌ na vacüaaꞌ ꞌuꞌ na matsitja ꞌuꞌ nnon Tyoꞌtsꞌon, quenꞌ xjenhanꞌ chaꞌvijon na macüjiꞌ tënnonꞌ ndoꞌ na ntyqueꞌhanꞌ chaꞌ tyiꞌntsitjantyichen ꞌuꞌ. Ee yantyichen ntsixuanꞌ na tyiꞌquintycüii na ngüandoꞌ ñuan ꞌnanꞌ min na ninncüii tënnonꞌ, chito na quindë vehanꞌ ndoꞌ na ntjueꞌ ángeles ꞌuꞌ quiiꞌ chon vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Quitquenhoꞌ cüenta na tyiꞌcueeꞌ nꞌonhoꞌ ncüii joo nanmin na tyiꞌtꞌman vantyja nꞌonhin. Matsjö ndëëhoꞌ joo ángeles cüenta nanꞌñeen, ninnquiiꞌchen cotsquehan na mꞌaan nquii tyëhöꞌ na mꞌaan jon quiñoonꞌndue, cotquenhan cüenta nin ꞌnan contꞌa nnꞌan nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, jndyö na ntsinꞌman ja ñuaan nnꞌan na tsuhan. ");
INSERT INTO azgNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Nchu vaa cotjiꞌhoꞌ cüenta? Xe na aa mꞌaan ncüii tsꞌan na mꞌan ncüii ciento quinman ntsjuenꞌ, ndoꞌ tsu ncüii joo choꞌñeen, ¿Aa chi nꞌndyii juu joo nenquennꞌan nchoꞌnqui vantjoꞌ ñjen choꞌñeen cjooꞌ tyueꞌ ndoꞌ ngaquintꞌue juu choꞌñeen na tsu? ");
INSERT INTO azgNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndoꞌ vi na jndë ntjii jon juu oꞌ, jñꞌoon na mayuuꞌ neiinꞌntyichen jon yo juu quitsmanꞌñeen, chintyi yo tsoñꞌen quinmanꞌñeen na tyíꞌcatsu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Manndaꞌ vaa itsijonhanꞌ ntyja ꞌnaanꞌ Tyehoꞌ na mꞌaan jon quiñoonꞌndue. Joo nnꞌan na tyiꞌnjon conduihan, minꞌncüiihan tyiꞌquintꞌue tsꞌon jon na ngitsu ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Xe na aa mꞌaan cüii tyꞌiuꞌ na vantyja tsꞌon na itsitjahin nnonꞌ, cüa, cjaꞌ cüanꞌ yaꞌhin xjen na ninnquii juu. Quitsiꞌmanꞌ nnon juu na sitjahin. Ndoꞌ xe na aa ndyii juu jñꞌoon na tsuꞌ, yajoꞌ jndë jnanꞌntycüiihoꞌ jñꞌoon ndoꞌ jndë tejndeiꞌhin na ntjo ya ntcüeꞌhin tonnon nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Majoꞌ xe na aa tyiꞌninꞌquindyii juu jñꞌoon na matsuꞌ, yajoꞌ cayonꞌ ncüii oo ve tsꞌan, cꞌohan yo ꞌuꞌ chaꞌ nndyehan jñꞌoon na conanꞌneinhoꞌ chaꞌ cüaaꞌ jndaꞌ nꞌonhan nchu vaa jñꞌoon jnanꞌneinhoꞌ yo juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ndoꞌ xe na aa min tyiꞌninꞌquindyii juu jñꞌoon na condue nanꞌñeen, yajoꞌ juu tmaanꞌ nnꞌan na vantyja nꞌon Tyoꞌtsꞌon, quitsiquindyiꞌhin ntyja ꞌnaanꞌ juu jñꞌoonꞌñeen. Ndoꞌ xe na aa majoꞌntyi tyiꞌninꞌquindyii juu jñꞌoon na condue nanꞌñeen nnon juu, yajoꞌ taꞌnan ncüiichen nnon na ndëë ntsaꞌ. Cüjiꞌ cüenta na tsixuan juu yo ntyja ꞌnanꞌ chaꞌvijon tsꞌan na tyiꞌtsitꞌmaanꞌ juu Tyoꞌtsꞌon, tsijonhanꞌhin chaꞌvijon tsꞌan ique sꞌon cüentaaꞌ gobiernon tsjoon Roma. ");
INSERT INTO azgNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, joo nnꞌan tsonnangue na jndë vantyja nꞌon, minꞌcya ro jñꞌoon na conduehoꞌ na tyiꞌquichuhanꞌ na nntꞌahan, ntsijonhanꞌ juu jñꞌoonꞌñeen chaꞌxjen na ntyjii Tyoꞌtsꞌon. Ndoꞌ minꞌcya ro jñꞌoon na conduehoꞌ na ndëë ntꞌa nnꞌan na vantyja nꞌon, mantyi ntsijonhanꞌ juu jñꞌoonꞌñeen chaꞌxjen na ntyjii nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Mantyi matsjö ndëëhoꞌ: Xe na aa ve ꞌoꞌ, nincüajon mꞌaanꞌ nꞌonhoꞌ jñꞌoon na cotanhoꞌ nnon Tyëhöꞌ na mꞌaan jon quiñoonꞌndue, yajoꞌ nndyii jon ndoꞌ nninncyaa jon jñꞌoon na cotanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ee minꞌyuuchen na covancüi ve nnꞌan oo ndyehan na conanꞌjonhan ntyja njan, xoncüe quiiꞌ ntꞌanhan, joꞌ mꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ndoꞌ tëtsindyooꞌ Pedro na mꞌaan Jesús. Taxeeꞌ juu nnon jon: —Nndaꞌ ta, ¿Tsaꞌnndaꞌ jnda na chuhanꞌ na quitsitꞌman tsꞌön cüii ntyjë na itsitjahin nnön? ¿Aa cüii ntyqueꞌ jnda? ");
INSERT INTO azgNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tso Jesús nnon juu: —Chito aa matsjö nnonꞌ na ninntyqueꞌ jnda. Matsjö na quitsitꞌman tsonꞌhin ntyqueꞌ veeꞌ jnda na ndyennꞌan nchoꞌnqui. Ninnquiiꞌchen quitsitꞌman tsonꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Mangꞌe na nndaꞌ vaa, juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan, cüaaꞌ nꞌonhoꞌ nchu vaa na itsiquindyihanꞌ. Itsijonhanꞌ juuhanꞌ chaꞌvijon ncüii rey na sitiu jon na ntsijndaꞌ jon tsaꞌnndaꞌ tueeꞌ na chujnan ncüii cüii tsꞌan cotsantyja naxenꞌ jon yo tsꞌian na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Xjen na taꞌ jon na icüjiꞌ jon cüenta na tsaꞌnndaꞌ na chojnan nanꞌñeen nnon jon, ndoꞌ jndyoyꞌon nnꞌan ncüii tsꞌan na minyonchen sꞌon na chujnan juu nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ndoꞌ juu reyꞌñeen, vi na jndë tquen jon cüenta na minꞌchjo ndiquindëë ndyion tsanꞌñeenhanꞌ, yajoꞌ tꞌua jon tsꞌian na cüijntꞌua tsanꞌñeen na ngaqueeꞌ juu na quityeꞌntjontyen juu, ndoꞌ majoꞌntyi scuuꞌ juu yo ndahan, yo ninꞌtsoñꞌen ꞌnaanꞌ juu chaꞌ ntꞌio na chujnan juu nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ndoꞌ juu tsanꞌñeen na vantyja xenꞌ reyꞌñeen, tconxtye juu nnon jon, tocan juu vi nayaꞌñeen nnon jon. Tso juu: “Nndaꞌ Ta, cyonꞌ chjo na tꞌman tsonꞌ ja, cüendoꞌ yaꞌ chjo ndoꞌ nndyiönñꞌën na chöjnan nnonꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ndoꞌ juu reyꞌñeen tyꞌoon jon na ndyiaꞌ ro juu nchjii jon. Sitꞌman tsꞌon jonhin yo na ninvaañꞌen na chujnan juu, ndoꞌ siquindyaa ntcüeꞌ jonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Majoꞌ xjen na jnduiꞌ juu quiiꞌ vaaꞌ jon, tjonhin ncüiichen ntyje juu na ninncüii tsꞌian mꞌanhan. Chujnan tsanꞌñeen nnon juu ninꞌncüii ciento sꞌon. Tꞌuii juuhin, tonchje juu xtyoꞌ tsanꞌñeen. Sixuaa juu nnon tsanꞌñeen: “Quityionꞌ na chujnanꞌ nnön.” ");
INSERT INTO azgNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Yajoꞌ tconxtye tsanꞌñeen tonnon juu. Sꞌaa juu tyꞌoohin: “Macꞌan na quitsitꞌman chjo tsonꞌ ja, cüendoꞌ yaꞌ chjo ndoꞌ nndyiönñꞌën na chöjnan nnonꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Majoꞌ tatendooꞌ tsanꞌñeen, matëquen juu jñꞌoon nnon tsꞌian. Tjuꞌ juu tsanꞌñeen vancjo, ata xjen na ndyion juu na chujnan juu nnon tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Majoꞌ vendyechen ntyjehan na mantyi conduihan nnꞌan cotsantyja naxenꞌ reyꞌñeen, xjen na tquenhan cüenta na sꞌaa tsanꞌñeen na nndaꞌ, sichjooꞌ jndyihanꞌ nꞌonhan. Tyenanꞌquindyiihan nquii reyꞌñeen tsoñꞌen ꞌnan na jndë sꞌaa tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ngꞌe na nndaꞌ, tqueenꞌ nndaꞌ jonhin, tso jon nnon juu: “ꞌUꞌ na viꞌ jndyi ñuan tsixuanꞌ. Ja sitꞌman tsꞌön ꞌuꞌ tsoñꞌen na chujnanꞌ nnön ngꞌe na sindyiaꞌ ꞌuꞌ nnön. ");
INSERT INTO azgNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Mangꞌe joꞌ ¿Aa chi mantyi chuhanꞌ na cyonꞌ na viꞌntyjiꞌ juu tyꞌiuꞌ mosoꞌ chaꞌxjen tyꞌön na viꞌntyji ꞌuꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ndoꞌ sijmiinꞌ jndyihanꞌ reyꞌñeen. Tꞌua jon tsꞌian na quitjueꞌhan tsanꞌñeen vancjo, ndoꞌ quintꞌaviꞌhan juu ata xjen na ndyionñꞌen juu ninvaañꞌen na chujnan juu nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yo jñꞌoonva siquindë Jesús jñꞌoonꞌñeen na tyiꞌquitso nquiiꞌ jonhanꞌ, itso jon: —Nquii Tyëhöꞌ na mꞌaan quiñoonꞌndue, manndaꞌ vaa ntsꞌaa jon yo ꞌoꞌ xe na aa chito yo na xoncüeeꞌ nꞌonhoꞌ na nnanꞌtꞌman nꞌonhoꞌ ntyjehoꞌ ya na conanꞌtjahan ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jndë na sinin Jesús jñꞌoonminꞌ, yajoꞌ jnduiꞌ jon ndyuaa Galilea, tja jon ntꞌö Judea, ixndya jndaa Jordán. ");
INSERT INTO azgNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndoꞌ jndye jndyi nnꞌan tyentyjahin toxenꞌ jon. Tsoñꞌen nnꞌan vꞌi na mꞌan joꞌ, totsinꞌman jon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Yajoꞌ vendye nnꞌan tmaanꞌ fariseos, jnanꞌndyooꞌhan na mꞌaan jon na ntꞌue nꞌonhan na quitsꞌaa jon ncüii nnon chaꞌ ntyja ꞌnaanꞌhanꞌ ngacüaaꞌhin. Taꞌxeeꞌhan nnon jon: —Ntyja ꞌnaanꞌ jñꞌoon na tquen Tyoꞌtsꞌon na iquenhanꞌ xjen, ¿Aa ncyaahanꞌ na ntsityuiiꞌ tsꞌan tson na toco juu yo scuuꞌ juu ngꞌe minꞌcya ro ncüii nnon na itsitja tsanꞌñeen nnon juu? ");
INSERT INTO azgNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Joꞌ tꞌa Jesús jndyuehan: —¿Aa minꞌjon tyiꞌconanꞌjnꞌaanhoꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na itsininhanꞌ ntyja ꞌnaanꞌ na taꞌ jndyee jon na tquen jon tsoñꞌen? Itsohanꞌ na sia jon tsansꞌa yo tsanscu. ");
INSERT INTO azgNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Itsontyichen Jesús: “Mangꞌe na nndaꞌ, nꞌndyii tsansꞌa tye juu, ndyee juu na ntjonꞌ matyenhin yo scuuꞌ juu, ndoꞌ vehan ninꞌncüii tsꞌan nduihan.” ");
INSERT INTO azgNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Mangꞌe juu jñꞌoonꞌñeen tsohanꞌ na nndaꞌ, tyiꞌnanꞌxuanhan na ve tsꞌan, nanein ninncüii tsꞌan conduihan. Ndoꞌ ngꞌe na nndaꞌ vaa sijndaꞌ nquii Tyoꞌtsꞌon, tyiꞌquichuhanꞌ na veꞌ tsꞌan ntsityuiiꞌ ntyja na mꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ndoꞌ nque fariseosꞌñeen taxeeꞌntyichenhan nnon jon, jnduehan: —Yajoꞌ ¿Nin ngꞌeꞌñeen na tꞌua Moisés tsꞌian na cüji tsꞌan jñꞌoon na nndyuiiꞌ tson ꞌnaanꞌ juu yo scuuꞌ juu, ndë joꞌ ncyaahanꞌ na nꞌndyii juu tsanꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tꞌa Jesús jndyuehan: —Veꞌ ngꞌe na queꞌ jndyi nꞌonhoꞌ na itscuꞌhanꞌ na cüaaꞌ nꞌonhoꞌ nchu vaa na sijndaꞌ Tyoꞌtsꞌon, joꞌ na tyincyaa Moisés na ndëë nnanꞌtyuiiꞌhoꞌ tson ꞌnaanhoꞌ yo ntcuhoꞌ. Majoꞌ chito nndaꞌ vaa na sijndaꞌ Tyoꞌtsꞌon na minjndyee. ");
INSERT INTO azgNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ncö matsjö ndëëhoꞌ, ncüii tsansꞌa jeꞌ, xe na aa ntsityuiiꞌ juu tson na toco juu yo scuuꞌ juu ndoꞌ ngoco juu yo cüiichen tsanscu, itsiquindyihanꞌ na veꞌ mꞌaan ya juu yo tsanscuꞌñeen. Ninnquiiꞌchen xe na aa mꞌaan scuuꞌ juu yo cüiichen tsansꞌa na veꞌ ndöꞌ ro, joꞌ vanaan na quityuiiꞌ tson na toco jon yo juu. ");
INSERT INTO azgNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa Jesús, jnduë́ nnon jon: —Xe na aa nndaꞌ vaa ntyja ꞌnaanꞌ tsꞌan yo scuuꞌ jon, yantyichen na tyiꞌngoco jon. ");
INSERT INTO azgNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tꞌa Jesús jndyuë́: —ꞌOꞌ conduehoꞌ na yantyichen tyiꞌngoco tsꞌan, majoꞌ tyiꞌtsoñꞌen nnꞌan nndëë nntꞌahan yo jñꞌoonvaꞌ. Veꞌ jndaꞌ nnꞌan na nndëë ntaꞌngueeꞌhan na nndaꞌ ngꞌe na jndë tyincyaa Tyoꞌtsꞌon na condëë contꞌahinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ee mꞌan nnꞌan na tyiꞌquitoncohan ngꞌe tuihan na tyiꞌicanhanꞌhin tsanscu, ndoꞌ ñꞌenhan na tyiꞌquitoncohan ngꞌe na tui nasihin chaꞌ tyiꞌntcanhanꞌhin tsanscu. Ndoꞌ ñꞌen nnꞌan na conanꞌjndaꞌ nquehin na tyiꞌninꞌquitoncohan ngꞌe ninꞌquityentjonhan nnon nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue. Minꞌcya ro tsꞌan na ivaaꞌ tsꞌon juu jñꞌoonvaꞌ ndoꞌ nndëë ntsiquindë juuhanꞌ, quitsiquindë juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Vendye nnꞌan na tyechohan yotsca na mꞌaan Jesús na quityio jon ntꞌö jon cjo joo na ndyio jon jnꞌaanhin ndoꞌ na can jon na quityio Tyoꞌtsꞌon jnꞌaan joo. Majoꞌ já nnꞌan na conanꞌjö́n yo jñꞌoon na toninncyaa jon, jnanꞌtyꞌiá nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ndoꞌ tso Jesús ndë́: —Quiꞌndyehoꞌ na quindyo ntyjaaꞌ yotscahinꞌ na mꞌan. Tyiꞌnanꞌntcüeꞌhoꞌhin ngꞌe nque nnꞌan na ninꞌquinanꞌxuanhan yo juu na ityentjon Tyoꞌtsꞌon nnꞌan, chuhanꞌ na quinanꞌxuanhan chaꞌna yotsca. ");
INSERT INTO azgNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ndoꞌ vi jndë na tyio jon ntꞌö jon cjo yotscaꞌñeen, jnduiꞌ jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cüii jon tyjeeꞌ cüii tsꞌan na tyiꞌtquechen na mꞌaan Jesús. Taxeeꞌ juu nnon jon: —ꞌUꞌ ta na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, ¿Nin ꞌnan na njonntyi na chuhanꞌ na quitsꞌa ja chaꞌ ntsixuan na tyiꞌquintycüii na vandoꞌ ñuan njan? ");
INSERT INTO azgNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sintcüeꞌ Jesús jñꞌoon nnon juu, itso jon: —¿Ndu na mavaxeꞌ nnön ntyja ꞌnaanꞌ ꞌnan na njonchen na quitsaꞌ? Xiaꞌntyi nquii Tyoꞌtsꞌon conduihin na njonchen. Majoꞌ xe na aa ninꞌquitsixuanꞌ na tyiꞌquintycüii na vandoꞌ ñuan ꞌnanꞌ, juu jñꞌoonꞌ Tyoꞌtsꞌon na icoꞌxenhanꞌ, cüangueꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Joꞌ taxeeꞌ juu nnon jon: —¿Nin jñꞌoonhanꞌ? Tꞌa Jesús ꞌndyo juu: —Tyiꞌntscueꞌ tsꞌan. Tyiꞌncꞌonꞌ yo cüiichen tsꞌan na veꞌ ndöꞌ ro. Tyiꞌnchꞌueꞌ ꞌnaanꞌ tsꞌan. Tyiꞌntsininꞌ quintu nacjooꞌ tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Juu tyeꞌ yo ꞌndyoꞌ, quitsaꞌ na njonhan, ndoꞌ cꞌonꞌ na veꞌntyjiꞌ cüiichen tsꞌan chaꞌxjen na veꞌntyjii nquii ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Joꞌ tꞌa juu ꞌndyo Jesús: —Tsoñꞌen jñꞌoonminꞌ matsiquindëëhanꞌ xiꞌ na tichjo ja. ¿Aa vaa ncüiichen nnon ꞌnan na icanchenhanꞌ na quitsꞌa? ");
INSERT INTO azgNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tꞌa Jesús ꞌndyo juu, tso jon: —Xe na aa ntꞌue tsonꞌ na quindë ya ntsixuanꞌ na tyiꞌquintycüii na vandoꞌ ñuan ꞌnanꞌ, cjaꞌ, quijndëꞌ tsoñꞌen ꞌnanꞌ na min. Sꞌon na ncyonꞌ cüenta na njndëꞌhanꞌ, ncyaꞌhanꞌ ndëë nanninñenꞌ. Xe na aa ntsaꞌ na nndaꞌ, ntsixuanꞌ na tya ꞌuꞌ tonnon Tyoꞌtsꞌon. Ndë joꞌ quindyotsijon ꞌuꞌ yo juu tsꞌian na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Majoꞌ xjen na jndyii tsanꞌñeen jñꞌoon na tso Jesús, tja ntcüeꞌ juu na chjooꞌ jndyi tsꞌon juu ngꞌe tya jndyihin. ");
INSERT INTO azgNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Joꞌ tso Jesús ndë́ já na cotsayꞌö́n yo jñꞌoon na toninncyaa jon: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, ncüii tsantya, jndyaaꞌ jndyi na ntsijonhin nchu vaa na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mantyi matsjö nntꞌa ndëëhoꞌ, jndyaaꞌchen na ncjuꞌcje cüii tsantya na ntsijonhin yo juu na icoꞌxen Tyoꞌtsꞌon nnꞌan, chichen na ngüequindyiꞌ camello tsueꞌ xꞌee tsiꞌncya. ");
INSERT INTO azgNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Majoꞌ xjen na jndyë́ juu jñꞌoonvaꞌ, jndye jndyi nnon tondyiiꞌ nꞌö́n. Joꞌ taꞌxꞌë́ ndëë ntyjë́, jnduë́: —Ngꞌe na nndaꞌ vaa, ¿Nin tsꞌan nndëë ntsixuan juu na ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Joꞌ jndyiaaꞌ Jesús ndë́, tso jon: —Minꞌncüii nnon ꞌnan jeꞌquindëë ntsꞌaa tsꞌan na ntyja ꞌnaanꞌhanꞌ ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu. Majoꞌ nquii jon tsoñꞌen nnon condëë itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ndoꞌ itso Pedro nnon Jesús: —Manchjiꞌ na jndë jntyꞌë́ tsoñꞌen chaꞌ condëë conanꞌjö́n yo tsꞌian na matsaꞌ. ¿Nin naya na ncyꞌö́n cüenta? ");
INSERT INTO azgNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tꞌa Jesús jndyuë́, itso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, juu xjen na nguaa tsonnangue xco, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ncjöquijman nnon silla na maninꞌ tsꞌiaanꞌ njan na taquintyja na njon tsixuanhanꞌ naijon na ntcoxën nnꞌan yo ꞌnan na jndë tontꞌahan. Ndoꞌ ꞌoꞌ na jndë jnanꞌjonhoꞌ yo ja, mantyi nguaa nchoꞌve silla na maninꞌ tsꞌiaanꞌ ꞌnaanhoꞌ na ntsacüendyuaahoꞌ na ngotoxenhoꞌ joo nchoꞌve tmaanꞌ ntyjeehoꞌ nnꞌan Israel ntyja ꞌnaanꞌ na jndë tontꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ndoꞌ ncüii cüii tsꞌan na jndë jntyꞌii juu vaaꞌ juu, ndyee juu oo scuuꞌ juu oo ntsinda juu, oo ndyuaa ꞌnaanꞌ juu, ntyje juu nannon yo ntyje juu nanntcu ngꞌe na jndë vayꞌoon juu jñꞌoon ntyja njan, xjen neinhin ncyꞌoon juu cüii ciento veeꞌ jnda tsoñꞌen nnon na jndë jntyꞌii juu, ndoꞌ nninncyaa Tyoꞌtsꞌon na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Jndye nnꞌan mꞌan nanein na conanꞌtiu nquehin na njon conduihin, majoꞌ ngüentyja xjen na ncjuꞌcjehanꞌhin. Ndoꞌ mantyi jndye nnꞌan na mꞌan nanein na tyiꞌnjon conduihan, majoꞌ ndëcya ntsiquinjonhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sininntyichen Jesús jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ, tso jon: “Nquii Tyoꞌtsꞌon na ityentjon jon quiñoonꞌndue, itsijonhanꞌhin chaꞌvijon cüii patrón na vaa ntjon ꞌnaanꞌ. Vitsjoonya tëquintꞌue patrónꞌñeen nanntjon na ngoqueꞌhan tsꞌian ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ntjo ngiohan na tso jon ndëëhan na ndyion jonhan ncüii denario na cüii xuee chaꞌxjen cotaꞌntjon nnꞌan. Jndë joꞌ jñon jonhan na quitsaquintꞌahan tsꞌian naijon vaa ntjon ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ndoꞌ chaꞌna ñjen na vitsjoon, tja nndaꞌ jon quiiꞌ tsjoon, joꞌ ntjii jon mañoon vendye nnꞌan na tatsꞌian contꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tso jon ndëëhan: “Cüa, cꞌohoꞌ na vaa ntjon njan na quintꞌahoꞌ tsꞌian. Ja ndyiönhoꞌ chaꞌxjen na chuhanꞌ.” Nanꞌñeen ninñoonꞌ tyꞌehan. ");
INSERT INTO azgNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ndoꞌ mantyi chaꞌna yajminꞌ tja nndaꞌ jon quiiꞌ tsjoon. Ntjii nndaꞌ jon mañoon nanntjon. Ndoꞌ ya tueeꞌ chaꞌna ndye na matman, majoꞌntyi sꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xjen vi mangueeꞌviꞌ na ꞌon na matman, tja nndaꞌ jon quiiꞌ tsjoon. Ntjiichen jon mañoon nnꞌan na veꞌ mꞌanchenhan. Tso jon ndëëhan: “¿Ndu na cüaꞌ xuee na mꞌanhoꞌ ntjoohin na tatsꞌian contꞌahoꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Ndoꞌ joꞌ jnduehan nnon jon: “Mayuuꞌ ngꞌe tanin tsꞌan tꞌua tsꞌian ndë́.” Yajoꞌ tso jon ndëëhan: “Ya xe na aa mantyi ncꞌohoꞌ na vaa ntjon njan, joꞌ quintꞌahoꞌ tsꞌian, ja ndyiönhoꞌ chaꞌxjen na chuhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ndoꞌ ya na tueeꞌ na yon na matman, tso patrón nnon nquii moso tque ꞌnaanꞌ jon: “Cüanꞌ nanntjon ndoꞌ quityionꞌhan na jntꞌahin tsꞌian. Quityionꞌ jndyeeꞌ joo nnꞌan na tyequeꞌ na matsꞌia. Chen chen ncyaaꞌhanꞌ ata ngueeꞌhanꞌ nnꞌan na tyequeꞌ jndyee.” ");
INSERT INTO azgNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Yajoꞌ santyjaaꞌ nnꞌan na tyequeꞌ na ꞌon na matman. Ncüii ro ncüiihan tyꞌonhan cüenta na ncüii cüii denario chaꞌxjen na ngüantjon tsꞌan na ncüii xuee. ");
INSERT INTO azgNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ndoꞌ ya na tueeꞌhanꞌ nnꞌan na tyequeꞌ jndyee, jnanꞌtiuhan na jndantyichen ntaꞌntjonhan. Majoꞌ ncüii ro ncüiihan, mantyi tyꞌonhan cüenta ncüii ncüii denario. ");
INSERT INTO azgNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Ndoꞌ vi na jndë tyꞌonhan cüenta joo sꞌonꞌñeen, taꞌhan na tyiꞌcaveeꞌ ngiohan yo nquii patrónꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jnduehan nnon jon: “Joo nanminꞌ na tyequeꞌ vi matsꞌiañꞌen, ninncüii hora jntꞌahan tsꞌian, majoꞌ nincüajon tyionꞌhan chaꞌxjen na tyionꞌ já. Ndoꞌ já cüaꞌ xuee tonanꞌchö́n ndoꞌ tonanꞌquii nꞌö́n min na jminꞌ tondyiaaꞌ ndoꞌcüjioonꞌ já.” ");
INSERT INTO azgNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Majoꞌ tꞌa patrón ꞌndyo cüii joo nanꞌñeen, tso jon: “ꞌUꞌ, ¿Yuu vaa na matsitja ja nnonꞌ?” “¿Aa chi jndë ntjo nchjiꞌ na ngüantjonꞌ cüii denario chaꞌxjen cotaꞌntjon nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cyonꞌ sꞌon ꞌnanꞌ, cjaꞌ vaꞌ. Ncö ntyji xe na aa cüajon ninꞌquityiön tsanvaꞌ chaꞌxjen na matyiön ꞌuꞌ min na tinioonꞌ tëqueeꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Aa matsitiuꞌ na jeꞌquindëë ntsꞌa chaꞌxjen na ntꞌue tsꞌön yo xoquituꞌ njan? ¿Aa matsitëëꞌ tsonꞌ ngꞌe ja tyiꞌntycüꞌi?” ");
INSERT INTO azgNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ndoꞌ tsontyichen Jesús: —Juu jñꞌoonvaꞌ na tyiꞌquitsjö ncꞌihanꞌ, ndö vaa na ninꞌquitsiꞌmanhanꞌ. Nnꞌan na tyiꞌquinanꞌtiu na njon conduihan na tonnon Tyoꞌtsꞌon, nincüajon ntsitꞌmaanꞌ jonhan chaꞌxjen ntsitꞌmaanꞌ jon mañoon ntyjehan. Ndoꞌ nnꞌan na conanꞌtiu nque na njon conduihan, ngüentyja xjen na nnintyiꞌncyo na nincüajon nnanꞌxuanhan tonnon Tyoꞌtsꞌon chaꞌxjen minꞌcya ro tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Viochen xjen na ñjon Jesús nato na tja jon Jerusalén, já na nchoꞌve já na tqueenꞌ jon, tëchu jon já vi ntyja na ninnquë́. Tso jon ndë́: ");
INSERT INTO azgNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Quitquenhoꞌ cüenta, nanein coꞌö Jerusalén. Ndoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, joꞌ nninncyaa tsꞌan cüenta ja nduee ntyee na conintque ndëë ntyjëëhë nnꞌan judíos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés. Ndoꞌ joo nanꞌñeen nntꞌahan na quitꞌuiityenhanꞌ ja na cüꞌiö. ");
INSERT INTO azgNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nninncyahan cüenta ja nduee nnꞌan na mañoon tsjan conduihan na joo nanꞌñeen nnanꞌcüejnaanꞌhin ja. Ntjaꞌhin ja ndoꞌ ntꞌionhan ja tsonjnꞌaan na cüꞌiö, majoꞌ xee na jndë ndye ngüantꞌö xcö. ");
INSERT INTO azgNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Scuuꞌ juu Zebedeo yo ntsinda jon Santiago yo ninꞌJuan, jnanꞌndyooꞌhan na mꞌaan Jesús. Tconxtye juu tonnon jon na ican juu vi nayaꞌñeen nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Taxeeꞌ Jesús nnon jon: —¿Nin ꞌnan ntꞌue tsonꞌ? Tꞌa tsanscuꞌñeen, itso juu: —Ya na ngüentyja xjen na ntyeꞌntjonꞌ nnꞌan, ncyaꞌ jñꞌoon na ve ntsinda nanmin, nnanꞌjonhan ntyja na nditꞌmaanꞌ ꞌuꞌ. Cüiihan ncꞌoon ngiaꞌ tontyjaya ndoꞌ cüiichenhin ncꞌoon juu ngiaꞌ ntyjatymaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Majoꞌ tꞌa Jesús jndyue ve nanꞌñeen, tso jon: —Tyiꞌcovaaꞌ nꞌonhoꞌ nchu vaa icüjiꞌhanꞌ jñꞌoon na ican ndyeehoꞌ. Juu naviꞌ na ngenön, ¿Aa nndëë nnanhoꞌhanꞌ? Ndoꞌ ¿Aa nndëë nntjo ngiohoꞌ na ncüjehoꞌ chaꞌxjen ntjo nchji na ncüꞌiö? Tꞌahan ꞌndyo jon, jnduehan: —Nndëë. ");
INSERT INTO azgNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sentcüeꞌ Jesús jñꞌoon ndëëhan, tso jon: —Majndaꞌ ngenonhoꞌ maninjuuntyi naviꞌ na ngenön. Ndoꞌ icanhanꞌ na quintjo ngiohoꞌ na nnanꞌcüje nnꞌan ꞌoꞌ chaꞌxjen contjo ya nchji na ncüꞌiö. Majoꞌ chito ncö tsixuan na ntsijntꞌa nin tsꞌan na ngüaquityen ncꞌia tontyjaya oo tontyjatymaanꞌ. Nquii Tyëhöꞌ nninncyaa jon nayaꞌñeen ndëë joo nnꞌan na jndë sijndaꞌ jon na ncyꞌonhan cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ndoꞌ joꞌ ncüiichen nqui já na totsayꞌö́n yo juu jñꞌoon na toninncyaa Jesús, xjen na jndyë́ jñꞌoon na tcan tsanscuꞌñeen, jnanꞌvjë yantyë́ joo ve ntyjë́ nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ngꞌe joꞌ tqueenꞌ Jesús tsoñꞌen já na mꞌaan jon. Tso jon ndë́: —ꞌOꞌ mangiohoꞌ na joo nnꞌan na conintquehan ncüii cüii tsonnangue conanꞌntsahan ndëë nnꞌan na cotoꞌxenhan. Ndoꞌ nnꞌan na conditꞌman, cotoxenhan nnꞌan na mꞌan nacje ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Majoꞌ tyiꞌquichuhanꞌ na ꞌoꞌ ncꞌonhoꞌ na nndaꞌ yo ntyjehoꞌ. Ee minninchen cüii ꞌoꞌ na ntyja tsꞌon juu na tꞌman nduihin quiiꞌ ntꞌanhoꞌ, chuhanꞌ na quityentjon juu ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ndoꞌ minꞌcya ro cüii ꞌoꞌ na ntyja tsꞌon juu na ncjuꞌhanꞌhin na tonnon, cꞌoon juu na xoncüeeꞌ tsꞌon juu na ntejndei juu ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Quitsꞌaa juu chaꞌxjen matsꞌa na condui ja nquii tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan. Jndyö na ntyeꞌntjön ndëë nnꞌan, chito na ntyentjonhan nnön. Ndoꞌ mantyi na nninncya na cüꞌiö na ndyiön jnan nnꞌan jndye jndyi chaꞌ nndyaahan yo ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Xjen na santꞌuí tsjoon Jericó, tyentyja ncüii tmaanꞌ nnꞌan naxenꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ꞌNdyo natoꞌñeen, joꞌ vendyuaa ve nannchjan. Ya na jndyehan jñꞌoon na juu Jesús venon joꞌ, taꞌhan jnanꞌxuaahan, jnduehan: —ꞌUꞌ ta na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cyonꞌ na ntyꞌiá rö́ nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Majoꞌ joo nnꞌan na mꞌan joꞌ, jnanꞌtyiaꞌhan joo nannchjanꞌñeen na cüichen jndyuehan. Majoꞌ joohan jndeintyichen jnanꞌxuaahan, jnduehan: —Nndaꞌ ta, ꞌuꞌ na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cyonꞌ na ntyꞌiá rö́ nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tëcüentyjeeꞌ Jesús, tꞌman jon nanꞌñeen. Tso jon ndëëhan: —¿Nin ꞌnan ntꞌue nꞌonhoꞌ na quitsꞌa ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tꞌa nanꞌñeen, jnduehan nnon jon: —Nndaꞌ ta, já ntꞌue nꞌö́n na nndëë njntyꞌiá. ");
INSERT INTO azgNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ndoꞌ tyꞌoon Jesús na ntyꞌia rohin nchjii jon. Tyio jon ntꞌö jon ndöꞌndëëhan, ndoꞌ ninñoonꞌ xuee jntyꞌiahin. Tyentyjahin toxenꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ndoꞌ vi na jndë tindyo na ntsquë́ Jerusalén, na ndyooꞌ tyoꞌ na mꞌan nꞌoon olivos, squë́ tsjoon Betfagé. Joꞌ joo ve ntyjë na cotsayꞌonhan yo jñꞌoon toninncyaa Jesús, jñon jonhan ncüii ntꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tso jon ndëëhan: —Quitsaqueꞌhoꞌ tsjoon chjo na mꞌaanhanꞌ tondëëhoꞌ. Joꞌ maquintyjachen nndiohoꞌ ncüii snonxque na tyen oꞌ yo jnda oꞌ. Quinanꞌquinanꞌhoꞌ joo oꞌ, ndoꞌ quindyoyꞌonhoꞌ choꞌñeen ntjoohin na mꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ndoꞌ xe na aa ngüaxeeꞌ tsꞌan ndëëhoꞌ ndu na cotsayꞌonhoꞌ choꞌ ntsjuenꞌ juu, joꞌ quinanꞌntcüeꞌhoꞌ jñꞌoon nnon juu: “Nquii jon na tꞌman conditꞌmanhin ndë́, icanhanꞌ na nninjntꞌue jon joo oꞌ, ndoꞌ ya na nndë, ntscüenon ntcüeꞌ jon joo oꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nndaꞌ tui chaꞌ quitsiquindëhanꞌ juu jñꞌoon na sinin Zacarías, tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa. Ndö vaa jñꞌoon na tji jon: ");
INSERT INTO azgNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Ndö jñꞌoon na quinduehoꞌ ndëë nnꞌan tsjoon Sión: “Quitquenhoꞌ cüenta, nquii jon na taquintyja na tꞌman conduihin ndëëhoꞌ, mancüjeeꞌ jon quiiꞌ ntꞌanhoꞌ, ndyiaꞌ tsꞌon jon, ntjo jon cüii snon, jnda quiooꞌ na ichu xu.” Ndöꞌ vaa na siquindyi jñꞌoon na tso tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ndoꞌ joꞌ ve nanꞌñeen na totsayꞌonhan yo jñꞌoon toninncyaa Jesús, tyꞌehan, jntꞌahan chaꞌxjen tsꞌian na tꞌua jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Squehan, yꞌonhan snonxqueꞌñeen yo jnda oꞌ. Ndoꞌ tyiohan ndiaahan nquenꞌ joo oꞌ ndoꞌ tantjo Jesús juu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ndoꞌ jndye jndyi nnꞌan tyenanꞌjonhan yo Jesús. Ñꞌen vendyehan jnanꞌnueenꞌhan ndiaahan xoncüe nato yuu jon na vja jon. Ndoꞌ vendyehan totyjehan nduee nꞌoon, totquenhinhanꞌ natoꞌñeen na jntꞌahan na njon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ndoꞌ nque nnꞌan na veꞌjndyee yo nnꞌan na santyja toxenꞌ jon, taꞌhin tonanꞌxuaahan, tonduehan: —Cüitꞌmaanꞌ nquii jon na tuihin tsjan tsochiihi David na jndyocahanꞌ. Tꞌman ityio Tyoꞌtsꞌon jnꞌaan nquii jon na ndyo jon yo najndei na tsixuan nquii Tyoꞌtsꞌon na coꞌxen jon jaa. Quinditꞌmaanꞌhin quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Xjen na tëqueeꞌ Jesús quityquiiꞌ Jerusalén, tondicꞌuaa jndyue nnꞌan na mꞌan juu tsjoonꞌñeen, taꞌxꞌehan: —Tsanvahin, ¿Nin tsꞌanhin? ");
INSERT INTO azgNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ndoꞌ nnꞌan na tyꞌe yo jon, tꞌahan, jnduehan: —Ndö Jesús, nquii jon na incyaa jon jñꞌoonꞌ Tyoꞌtsꞌon. Jnan jon Nazaret ntꞌö Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ndoꞌ vi na jndë tëqueeꞌ Jesús vatsꞌon tꞌman, tsoñꞌen nnꞌan na condëëhan ndoꞌ conanꞌjndahan ꞌnan joꞌ, tjiꞌ jonhan. Ndoꞌ siquityeeꞌ jon mesa ꞌnaan nnꞌan na conanꞌjndyo sꞌon joꞌ. Majoꞌntyi sꞌaa jon yo silla ꞌnaan nnꞌan na condëë quintuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ndoꞌ tso jon ndëë nanꞌñeen: —Jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsohan: “Vꞌaa njan tsixuanhanꞌ vꞌaa yuu jon na covatjon nnꞌan na conanꞌnein nnon Tyoꞌtsꞌon.” Majoꞌ ꞌoꞌ contꞌahoꞌ na tsixuanhanꞌ chaꞌvijon tsëꞌtsjöꞌ naijon cotooꞌ nanntyꞌuee. ");
INSERT INTO azgNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ndoꞌ juu xjen na mꞌaan Jesús vatsꞌon tꞌmanꞌñeen, sque nannchjan na mꞌaan jon yo nnꞌan na ndicꞌocaꞌ. Ndoꞌ sinꞌman jonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ndoꞌ nque ntyee na conintque vatsꞌonꞌñeen yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, jntyꞌiahan tsꞌian tꞌman na sꞌaa Jesús na itsinꞌman jon nnꞌan. Mantyi tondyehan na tonanꞌxuaa yotsca na tondue joo: “Cüitꞌmaanꞌ nquii jon na tuihin tsjan tsochiihi David na jndyocahanꞌ.” Ndoꞌ na nndaꞌ jndue yotscaꞌñeen, majndeichen jnanꞌjmiinꞌ ntyeeꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Joꞌ jnduehan nnon Jesús: —¿Aa mandyiꞌ nchu vaa condue yotscamin? Tꞌa Jesús jndyuehan, tso jon: —Mandyi. Ndoꞌ ꞌoꞌ jeꞌ, ¿Aa minꞌjon taconanꞌjnꞌaanhoꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na itsohanꞌ?: ꞌUꞌ jndë sijndaꞌ na yoquijndë yo yoꞌndaa na ninvaa coteiꞌ, nnanꞌtꞌmaanꞌ yoꞌñeen ja yo na xoncüeeꞌ nꞌon joo. ");
INSERT INTO azgNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jndë na tso Jesús na nndaꞌ, jntyꞌii jon nanꞌñeen, jnduiꞌ ntcüeꞌ jon Jerusalén, tja jon tsjoon chjo Betania. Joꞌ ntjohin natsjon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Tonco cüiichen xuee, xjen na vja ntcüeꞌ jon Jerusalén, tyjeeꞌ na ninjndoꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ndoꞌ jndyiaaꞌ jon cüii tsꞌoon higuera na minntyjeeꞌhanꞌ ꞌndyo natoꞌñeen, tëtsindyooꞌhin nnonhanꞌ, majoꞌ minꞌncüii të higo tana ntjii jon, xiaꞌntyi veꞌ tsco tꞌuiiꞌhanꞌ. Tso jon nnon tsꞌoonꞌñeen: —Tajon xuee vi ngaquichuꞌ nndaꞌ të ꞌuꞌ. Ndoꞌ juu tsꞌoonꞌñeen jeꞌ, ninñoonꞌ tcanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Já nnꞌan na cotsayꞌö́n yo jñꞌoon toninncyaa Jesús, ya na tquë́n cüenta na tui na nndaꞌ, sꞌaahanꞌ na ndicüaaꞌ nꞌö́n, jnduë́ nnon jon: —¿Nchu tui na ninñoonꞌ tcan tsꞌoonvaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Joꞌ tꞌa Jesús jndyuë́, itso jon: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, xe na aa covantyja ya nꞌonhoꞌ, ndoꞌ min tyiꞌcꞌonhoꞌ na ve vaa na conanꞌtiuhoꞌ, nndëë ntꞌahoꞌ chaꞌna sꞌa juu tsꞌoon higueravaꞌ. Ndoꞌ chito veꞌ xiaꞌntyi joꞌ, mantyi nndëë ntꞌahoꞌ minꞌcya ro nnon ꞌnan na ngiohoꞌ na jndyaaꞌhanꞌ. Ntsijonhanꞌ juuhanꞌ chaꞌvijon na nnduehoꞌ nnon tyoꞌvaꞌ: “Quenanꞌ ntjoohin. Cüa, cjuꞌhanꞌ ꞌuꞌ quityquiiꞌ ndaandue”, ndoꞌ nndui na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ee ncüii cüii nnon jñꞌoon na cotanhoꞌ na conanꞌneinhoꞌ nnon Tyoꞌtsꞌon, xe na aa vantyja nꞌonhoꞌ na ncyꞌonhoꞌhanꞌ, mancüiixjen ncyꞌonhoꞌ cüentahanꞌ chaꞌxjen na cotanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jndë na tui na nndaꞌ, tëqueeꞌ nndaꞌ Jesús vatsꞌon tꞌman. Viochen xjen na itsiꞌman jon ndëë nnꞌan na sque joꞌ, nque ntyee na conintque yo ninꞌjoo nnꞌan na conintque ndëë ntyjehan nnꞌan judíos, tentyjaaꞌhan nnon jon. Taxꞌehan nnon jon, jnduehan: —¿Nin najndei na matsixuanꞌ na tjiꞌ nanminꞌ quiiꞌ vatsꞌon? Ndoꞌ ¿Nin nquii tsꞌan na tyincyaa na matsixuanꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Joꞌ tꞌa jon jndyuehan, itso jon: —Mantyi ja ngüaxꞌë cüii jñꞌoon ndëëhoꞌ. Xe na aa ntꞌahoꞌhanꞌ, yajoꞌ mantyi ntsjö ndëëhoꞌ nin nquii tyincyaa najndei na matsixuan na sꞌa na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ntyja ꞌnaanꞌ na totsiquindëëꞌ Juan nnꞌan, ¿Nin juu tꞌua tsꞌianꞌñeen nnon jon? ¿Aa nquii Tyoꞌtsꞌon jñonhin na quitsꞌaa juu na nndaꞌ, ndoꞌ aa veꞌ nnꞌan jndue na quitsꞌaa juu tsꞌianꞌñeen? Ndoꞌ nanꞌñeen jeꞌ, taꞌhan, tonanꞌnein nquehan yo ntyjehan. Jnduehan: —¿Nin jñꞌoon ntꞌa na nndaꞌ vaa na ivaxꞌee jon ndëë? Ee xe na aa nnduë na nquii Tyoꞌtsꞌon tꞌua jon tsꞌianꞌñeen nnon Juan, yajoꞌ ngitso jon ndëë: ¿Ndu na tatëntyja nꞌonhoꞌ jñꞌoon na totso juu Juanꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Majoꞌ xe na aa nnduë na juu najndei na totsixuan jon jnanhanꞌ veꞌ ntyja ꞌnaan nnꞌan, joo nnꞌan na jndye jndyiꞌhin nndëë ntꞌueviꞌhan jaa ngꞌe tsoñꞌenhan cotjiꞌhan cüenta na juu Juan tonduihin tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ndoꞌ tꞌahan ꞌndyo Jesús, jnduehan: —Juu Juanꞌñeen, ntyja ꞌnaanꞌ tsꞌian na totsixuan jon, min tyiꞌquindiö́ nin juu tꞌua tsꞌianꞌñeen nnon jon. Yajoꞌ tꞌa Jesús jndyuehan, tso jon: —Tanin, min ja xequitsjö ndëëhoꞌ nin juu na tyincyaa najndei na matsixuan na matsꞌa nanꞌminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yajoꞌ sininntyichen Jesús ndëë nanꞌñeen: —Ntsinën jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ. Cꞌoonꞌ nꞌonhoꞌ ntyja ꞌnaanꞌhanꞌ. Tomꞌaan ncüii tsꞌan. Tomꞌan ve ntsinda jon nannon. Tso jon nnon jnda jon, tsan na tui jndyee: “ꞌUꞌ jnda, xevahin cjaꞌ quitsaꞌ tsꞌian na vaa ntjon njan.” ");
INSERT INTO azgNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tꞌa tsanꞌñeen, itso juu: “Ja tyeꞌ, tyiꞌcjötö.” Majoꞌ vi jndëcya scüejndyohanꞌ ꞌnan na sitiu juu, tja juu, tëquitsꞌaa juu tsꞌian. ");
INSERT INTO azgNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ndoꞌ vi jndëcya, sindyooꞌ tyehan nnon ncüiichenhin. Majuuntyi jñꞌoon tso jon nnon juu. Tꞌa juu ꞌndyo jon: “Ya tyeꞌ, ncjö,” majoꞌ tatja juu. ");
INSERT INTO azgNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ndoꞌ taxeeꞌ Jesús ndëë nanꞌñeen, tso jon: —Cüa jeꞌ, quinduehoꞌ, ¿Nin cüii na ve joohan jntꞌahan chaꞌxjen na ntꞌue tsꞌon tyehan? Tꞌa nanꞌñeen, jnduehan: —Jnda jon tsan na vejndyee. Ndoꞌ tso Jesús ndëëhan: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, nque nnꞌan na cotye sꞌon na cotyion nnꞌan ntyja ꞌnaanꞌ tsanmꞌaantsꞌian tsjoon Roma ndoꞌ mantyi joo nanntcuntjaaꞌ, tyuaaꞌntyi nninncyahan na ntyeꞌntjon Tyoꞌtsꞌonhin ntyja na cotsamꞌanhan, chito ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ee tyjeeꞌ Juan quiiꞌ ntꞌanhoꞌ na toninncyaa jon jñꞌoon na siꞌmanhanꞌ nchu vaa na chuhanꞌ na cꞌonhoꞌ tonnon nquii Tyoꞌtsꞌon, majoꞌ ꞌoꞌ taꞌnan tëntyja nꞌonhoꞌ jñꞌoon na toninncyaa jon. Majoꞌ nque nnꞌan na cotye sꞌon na cotyion nnꞌan ntyja ꞌnaanꞌ gobiernon ndoꞌ mantyi yo joo nanntcuntjaaꞌ, joohan tëntyja nꞌonhan jñꞌoon na toninncyaa juu Juanꞌñeen. Ndoꞌ ꞌoꞌ min na jntyꞌiahoꞌ na tui na nndaꞌ, majoꞌ taꞌnan ntcüeꞌ nꞌonhoꞌ min tyíꞌcantyja nꞌonhoꞌ jñꞌoon na toninncyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Nanein ntsinën cüiichen jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ na cüaaꞌ nꞌonhoꞌhanꞌ. Tomꞌaan ncüii tsꞌan na vaa tyuaa ꞌnaanꞌ jon. Jnonꞌ jon ntꞌööntjon tëndöndyooꞌ tsjan. Ndoꞌ tyiiꞌ jon teonntjöꞌ xiꞌjndiohanꞌ. Jndë joꞌ jñꞌen jon pila yuu jon na ngocue ndaaꞌ joo tëndöndyooꞌ tsjan na jndë jntyꞌii nanntjonꞌñeen. Jndë joꞌ sia jon cüii vꞌaandye naijon na ncꞌoon tsꞌan na ntquen cüenta juu ntjonꞌñeen. Jndë joꞌ sijndaꞌ jon nin nnꞌan na nntꞌa tsꞌianhanꞌ, jndë joꞌ jnduiꞌ jon, tja jon cüiichen ndyuaa na tycya. ");
INSERT INTO azgNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ndoꞌ ya na jndë tentyja xjen na jndë tque tëhanꞌ, jñon jon mosooꞌ jon na mꞌan nanꞌñeen na coquichohan të na tantjon juu tyuaa ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Majoꞌ joo nnꞌan na contꞌa tsꞌian tyuaa ꞌnaanꞌ jon, tyꞌonhan joo mosoꞌñeen. Cüii tsanꞌñeen tjaꞌhanhin. Cüiichen tsanꞌñeen jnanꞌcueeꞌhanhin. Ndoꞌ tsan na jndë ndye, totuenꞌhan ntjöꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ndoꞌ juu patrónꞌñeen, xjen na jndyii jon na nndaꞌ, jñon nndaꞌ jon majndyentyichen mosooꞌ jon na mꞌan nanꞌñeen. Majoꞌ ninꞌcüajon jntꞌahan yo joo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Na matsꞌiañꞌen nquii tsansꞌa jnda jon, jñon jonhin na mꞌan nanꞌñeen. Ee sitiu jon: “Mancüiixjen ntꞌahan na njonhin.” ");
INSERT INTO azgNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Majoꞌ joo nanꞌñeen na contꞌa tsꞌian, ya na jntyꞌiahan juu jnda nquii patrónꞌñeen, jnduehan ndëë ntyjehan: “Ndö jnda nquii patrón. Tsanvaꞌ, vi na jndë tueꞌ tye juu, ntjo tyuaava ntꞌö juu. Cüa, quinanꞌcꞌuëhin chaꞌ ꞌnaanꞌ juu ntjohanꞌ nduë.” ");
INSERT INTO azgNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ndoꞌ tyꞌonhanhin, tjueꞌhanhin toxenꞌ juu ntjonꞌñeen, ndoꞌ jnanꞌcueeꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Taxeeꞌ Jesús ndëë nanꞌñeen, tso jon: —Juu tsꞌan na ꞌnaanꞌ ntjonꞌñeen, xjen na ncüjeeꞌ nndaꞌ jon, cꞌoonꞌ nꞌonhoꞌ nin ꞌnan ntsꞌaa jon yo joo nanꞌñeen na contꞌahin tsꞌian tyuaa ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tꞌa nanꞌñeen, jnduehan nnon jon: —Majndaꞌ na ntscüje jonhan ngꞌe tyia jndyi nanꞌxuanhan, ndoꞌ nninncyaa jon juu tsꞌianꞌñeen ndëë mañoon nnꞌan na nninncyahan ꞌnan na ngüantjon tyuaa ꞌnaanꞌ jon xjen na ngueꞌ ntjonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ndoꞌ sininntyichen Jesús ndëë nanꞌñeen na sijoonꞌ nquiihin na conduihin tsjöꞌ ya. Tso jon: —Joo albañil na conanꞌyahin tsjaanꞌ vꞌaa, majuuto tsjöꞌ na conduehin na tyiꞌjeꞌcüijntꞌuehanꞌ, majndë vaquityentyenhanꞌ nquii naijon na tjihanꞌ nquii tsjaanꞌ vꞌaa. Nquii ta Tyoꞌtsꞌon sijndaꞌ jon na nndaꞌ. Ndoꞌ ndicueeꞌ na ncüaaꞌ ya nnꞌön na cojntyꞌia na tuihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ngꞌe na nndaꞌ vaa na tsiꞌman juu jñꞌoonꞌvaꞌ, ndö jñꞌoon na matsjö ndëëhoꞌ. Juu na tyincyaa Tyoꞌtsꞌon na conanꞌjonhoꞌ ntyja ꞌnaanꞌ na ityeꞌntjon jon nnꞌan ntyja na cotsamꞌanhan, ncüjiꞌ ntcüeꞌ jon na nanꞌxuanhoꞌhanꞌ, ndoꞌ nninncyaa jon na mañoon nnꞌan nnanꞌxuanhan juu tsꞌianꞌñeen. Ndoꞌ nditꞌmaanꞌ jon ntyja ꞌnaanꞌ juu tsꞌian na ntꞌa nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndoꞌ ntyja ꞌnaanꞌ tsjöꞌvaꞌ na sinën ndëëhoꞌ, minninchen tsꞌan na tyiꞌcüaaꞌ tsꞌon juu ntyja njan, viꞌ ntjon tsanꞌñeen chaꞌvijon tsꞌan na tonhin na tyioohin nacjooꞌ tsjöꞌ. Majoꞌ tsꞌan na tyiꞌcantyja tsꞌon ja, majndaꞌ ntꞌuiiviꞌhanꞌhin ya na ngüentyja xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na conanꞌtjahan nnon jon. Ntyja ꞌnaanꞌ ꞌnan na ngenon tsanꞌñeen, itsijonhanꞌ juuhanꞌ chaꞌvijon na tyioo ncüii tsjöꞌ tꞌman nacjooꞌ juu na sitiuu jndëhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ndoꞌ joo jñꞌoonminꞌ na tyiꞌquitso nquiiꞌ Jesús joohanꞌ, nque ntyee na conintque yo nnꞌan fariseos, vi na jndë jndyehan jñꞌoonꞌñeen, taaꞌ nꞌonhan na tjiꞌ jonhanꞌ ntyja ꞌnaanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ngꞌe joꞌ ninꞌquitꞌuehan jon, majoꞌ ncyaahan nnꞌan na jndye jndyiꞌhin, ee nanꞌñeen tjiꞌhin cüenta na conduihin tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Cüiichen jon sinin nndaꞌ Jesús ndëë ntyee na conintque yo nnꞌan fariseos. Sinin jon jñꞌoon na tyiꞌquitso quiiꞌhanꞌ ndëëhan: ");
INSERT INTO azgNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Juu na ityentjon Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na cotsamꞌanhan, itsijonhanꞌ juuhanꞌ chaꞌvijon ncüii rey na sꞌaa jon nguee tꞌman na ngoco tsansꞌa jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tꞌua jon tsꞌian ndëë mosooꞌ jon na quitsaquitqueenꞌhan tsoñꞌen nnꞌan na jndë siquindyii jon na ncyohan nguee na itsꞌaa jon. Majoꞌ joo nanꞌñeen tajntꞌue nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ngꞌe joꞌ jñonchen jon moso, tso jon ndëëhan: Quinduehoꞌ ndëë nnꞌan na jndë siquindyi ja na ncyohan ngꞌe jndë min cje ꞌnan na nninjntꞌue na ngoco juu tsansꞌa jnda. Jndë iscüjë ndoro yo minndyechen quiooꞌ na jndë siquiꞌmën, jndë tijñꞌoonꞌ tsoñꞌen, mangꞌe joꞌ ncyohan nguee na ngoco juu tsansꞌa jnda. ");
INSERT INTO azgNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Majoꞌ joo nanꞌñeen jeꞌ, tyiꞌquinanꞌjñꞌoonꞌhan juu jñꞌoon na tyeyꞌon mosooꞌ jon. Ncüii joohan tëquitsꞌaa juu tsꞌian tyuaa ꞌnaanꞌ juu. Ncüiichenhin tëquijndëë juu ꞌnan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ndoꞌ minndye nanꞌñeen tꞌuehin mosooꞌ jon, ji vaa jndyi tjaꞌ nanꞌñeen joohan ata jnanꞌcüjehanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ndoꞌ vi jndë taaꞌ tsꞌon juu reyꞌñeen na nndaꞌ tontꞌa nnꞌan mosooꞌ jon, sivꞌii jndyi jon. Joꞌ jñon jon sondaro ꞌnaanꞌ jon na quitsananꞌcüjehan nanꞌñeen. Ndoꞌ jñonhan chon tsjoon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jndë joꞌ tso jon ndëë minndye mosooꞌ jon: Tsoñꞌen jndë tijndaꞌ ya na nditꞌmaanꞌ na ngoco tsansꞌa jnda, majoꞌ nnꞌan na tquënꞌ jndyëë na ncyohin ngueeva, taviquinanꞌxuanhin na ntsꞌa na njonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Nanein cꞌohoꞌ nquii nata tꞌman, joꞌ quiꞌmanhoꞌ ncüii cüii tsꞌan na ntjonhoꞌ joꞌ. Quinduehoꞌ ndëëhan na quindyontyjaaꞌhan na icoco juu jnda. ");
INSERT INTO azgNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ndoꞌ joo mosoꞌñeen, jnduiꞌhan, jndyiꞌhan nata quiiꞌ tsjoon. Jnanꞌncüihan tsoñꞌen nnꞌan na tjonhan. Ñꞌen nnꞌan na tyia nnꞌanhan ndoꞌ ñꞌen nnꞌan na ya nnꞌan. Veꞌ ndaꞌ ro sꞌaahanꞌ na tooꞌ vꞌaa yo nnꞌan na jnanꞌncüihan na toco jnda nquii reyꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Majoꞌ nquii jon, xjen na tëqueeꞌ jon na nninncyaa jon tsꞌon nnꞌanꞌñeen, jndyiaaꞌ jon ncüii tsꞌan na tyiꞌcüe juu ndiaa chaꞌxjen juu ndiaa cocüe nnꞌan na conanꞌjonhan ya na ngoco tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Itso jon nnon juu: “ꞌUꞌ ntyjë, ¿Ndu na jndyoqueꞌ ntjoohin ndoꞌ min tyiꞌcüeꞌ ndiaa chaꞌxjen na cocüe nnꞌan ya na icoco tsꞌan?” Majoꞌ tsanꞌñeen, minꞌncüii jñꞌoon taꞌnan tꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Joꞌ juu reyꞌñeen tso jon ndëë nnꞌan na cotyeꞌntjon nnon jon: “Quinanꞌtyenhoꞌ ngꞌee tsanvaꞌ yo ntꞌö juu. Ndoꞌ quitjueꞌhoꞌhin chꞌen naijon najaan jndyi. Joꞌ yuu na cotyuee nnꞌan ndoꞌ cocüaꞌhin ndiꞌnꞌonhin na iquii jndyihanꞌhin.” ");
INSERT INTO azgNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Ndoꞌ sintycüii Jesús jñꞌoonvaꞌ, itsontyichen jon: —Jndye jndyi nnꞌan na iꞌman Tyoꞌtsꞌon na quintcüeꞌ nꞌonhin yo jnanhin, majoꞌ tyiꞌjndyehin icüji jon na nnanꞌxuanhan cüentaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Yajoꞌ jnduiꞌ nnꞌan fariseosꞌñeen, jnanꞌnein nquehan yo ntyjehan nchu vaa nquii nntꞌahan na quitꞌuiiviꞌhanꞌ Jesús tsojnaanꞌ joo jñꞌoon na itsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Jndë joꞌ jñonhan vendye ntyjehan yo nnꞌan tmaanꞌ cüentaaꞌ Herodes na quitsataxeeꞌ nanꞌñeen nnon Jesús. Tyꞌehan, jnduehan nnon jon: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, mangiö́ na condui ꞌuꞌ tsꞌan na tyiꞌjeꞌquitsiviꞌnnꞌanꞌ. Jñꞌoon na mayuuꞌ na matsiꞌmanꞌ ndë́ nchu vaa na ntꞌue tsꞌon Tyoꞌtsꞌon yo nnꞌan. Min tamatyiꞌ cüenta nchu vaa na conanꞌtiu nnꞌan oo nchu vaa nanꞌxuanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Quitsuꞌ nndyë́ nchu vaa matsitiuꞌ: ¿Aa chuhanꞌ na quityiön sꞌon nnon tsanmꞌaantsꞌian tꞌman tsjoon Roma, oo aa tyiꞌquichuhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Majoꞌ taaꞌ tsꞌon Jesús manyan na nanꞌxuanhan. Tso jon ndëëhan: —ꞌOꞌ na ve vaa na conanꞌtiuhoꞌ, ¿Ndu na jen cojntꞌuehoꞌ nchu vaa nquii ntꞌahoꞌ chaꞌ quitꞌuiiviꞌhanꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Cüa, quinanꞌmanhoꞌ nnön cüii xoquituꞌ na cotyionhoꞌ sꞌon na ican gobiernon. Yajoꞌ tjiꞌhan ncüii sꞌon denario, jnanꞌmanhinhanꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ndoꞌ taxeeꞌ jon ndëëhan: —Juu xoquituꞌvahin, ¿Nin tsꞌan ꞌndyo nnon na chuuꞌhanꞌ? Ndoꞌ ntjimin, ¿Nin tsꞌan xueeꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tꞌa nanꞌñeen, jnduehan: —Ndö ꞌndyo nnon nquii tsanmꞌaantsꞌian tꞌman yo xueeꞌ nquii jon. Joꞌ sintcüeꞌ Jesús jñꞌoon ndëëhan: —Joꞌ nquii tsanmꞌaantsꞌian tꞌman, quityionhoꞌ sꞌon nnon jon na tsixuan jon na ncyꞌoon jon cüentahanꞌ. Ndoꞌ mantyi tsoñꞌen na vacüjaꞌhanꞌ Tyoꞌtsꞌon, ncyahoꞌhanꞌ cüentaaꞌ nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ndoꞌ vi na jndë jndyehan na nndaꞌ, vacue mꞌaanꞌ nꞌonhan na nndaꞌ vaa na tso jon. Jntyꞌehin jon, tyꞌehin. ");
INSERT INTO azgNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Maninjuuntyi xeeꞌñeen sque nnꞌan tmaanꞌ saduceos na mꞌaan Jesús. Quii jndyue nanꞌñeen na joo nnꞌan na jndë tjë, tyiꞌjeꞌquitaꞌndoꞌ xcohan. Ndö vaa jñꞌoon jnduehan nnon jon: ");
INSERT INTO azgNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, juu jñꞌoon na tyꞌön cüenta na tquen Moisés icoxenhanꞌ na ncüii tsansꞌa, xe na aa tueꞌ juu ndoꞌ min taꞌnan ntsinda jon yo scuuꞌ jon, yajoꞌ ijndeiꞌhanꞌ na juu tyje tsꞌooꞌñeen ngoco juu yo scuuꞌ tsoxio juu. Ncꞌoon ntsinda juu yo juu tsanscuꞌñeen chaꞌ ntsinonhanꞌ na tantsinda xio juu na tui. ");
INSERT INTO azgNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ndö vaa ꞌnan na tui, cüii jon quiiꞌ ntꞌán tomꞌan ntyqueꞌ nannon na nincüii tsꞌan ntsindahan. Juu tsantque toco juu, majoꞌ tueꞌ juu. Tantsinda juu yo scuuꞌ juu. Joꞌ tyje juu tsꞌooꞌñeen, toco juu yo scuuꞌ tsoxio juu. ");
INSERT INTO azgNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ndoꞌ majoꞌntyi tsansꞌa na jndë ve, taꞌnan ntsinda juu yo tsanscuꞌñeen xjen na tueꞌ juu. Majoꞌntyi tjon tsan na jndë ndye, ndoꞌ manincüajon ata tsan na jndë ntyqueꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndoꞌ matsꞌiañꞌen mantyi nquii tsanscuꞌñeen, tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ta, juu jñꞌoonva na ninꞌquitaꞌxꞌë́ nnonꞌ. Juu xjen na ntaꞌndoꞌ xco nnꞌan na jndë tjë, ¿Nin ncüii joo na ntyqueꞌhin na ndiscuhin juu tsanscuꞌñeen? Ngꞌe ninvaa na ntyqueꞌ nanꞌñeen tondiscuhin jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tꞌa Jesús jndyuehan, tso jon: —ꞌOꞌ cochueꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ juu jñꞌoonvaꞌ, ngꞌe min na conanꞌjnꞌaanhoꞌ jñꞌoon na tquen Tyoꞌtsꞌon na vaa, majoꞌ tyiꞌcovaaꞌ nꞌonhoꞌ nin ꞌnan ninꞌquitsiquindyihanꞌ. Min ndicüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ juu najndei na condui jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ee juu xjen na ntaꞌndoꞌ xco nnꞌan na jndë tjë, taxeꞌquitonco nndaꞌhan, min nannon, min nanntcu. Ee juu xjenꞌñeen nnanꞌxuanhan chaꞌna ángeles na mꞌan quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ndoꞌ mantyi juu jñꞌoon na ntaꞌndoꞌ xco nnꞌan na jndë tjë, ¿Aa minꞌjon tyíꞌconanꞌjnꞌaanhoꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na jndë jndui na itso jon: ");
INSERT INTO azgNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ja condui Tyoꞌtsꞌon na totsitꞌmaanꞌ Abraham, yo Isaac ndoꞌ yo ninꞌJacob.” Mangꞌe na tso jon na nndaꞌ, itsiquindyihanꞌ na conduihin Tyoꞌtsꞌon ntyja ꞌnaan nnꞌan na cotaꞌndoꞌ, chito ntyja ꞌnaan ntꞌoo. ");
INSERT INTO azgNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ndoꞌ nnꞌan na jndye jndyiꞌhin, xjen na jndyehan na sinin jon jñꞌoonminꞌ, vacue tomꞌaanꞌ nꞌonhan jñꞌoon na totsiꞌman jon. ");
INSERT INTO azgNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Joo nnꞌan tmaanꞌ fariseos jndyehan na juu jñꞌoon na sinin Jesús, sichenhanꞌ jndyue ntyjehan nnꞌan saduceosꞌñeen, ngꞌe joꞌ jnanꞌncüihan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ndoꞌ ncüii joohin, tsꞌan na tsiꞌman nchu vaa itsiquindyi jñꞌoon na icoꞌxenhanꞌ na tquen Moisés, taxeeꞌ jon ncüii jñꞌoon nnon Jesús na ntꞌue juu na juu jñꞌoon na ntsintcüeꞌ jon, ndëë nninjntꞌuehin juuhanꞌ na quitꞌuiihanꞌ jon. Tso juu: ");
INSERT INTO azgNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—ꞌUꞌ ta na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon, quityquiiꞌ jñꞌoonꞌ jon na tquen Moisés, ¿Nin jñꞌoon na tꞌmanntyi na icoꞌxenhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tꞌa Jesús ꞌndyo tsanꞌñeen, tso jon: —“Juu jñꞌoon na njonntyichen tsixuanhanꞌ, ndoꞌ na tꞌmanntyichen icoꞌxenhanꞌ, ndö vaa na itsohanꞌ: Nquii Tyoꞌtsꞌon na conduihin na coꞌxen jon ꞌuꞌ, cüivintyjiꞌhin yo na manchaꞌchen tsonꞌ yo ninvaa ñuanꞌ, yo tsoñꞌen ꞌnan na matsitiuꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Juu jñꞌoonvaꞌ na icoꞌxenhanꞌ, juuhanꞌ njonntyichenhanꞌ ndoꞌ juuhanꞌ navejndyee ngue quityquiiꞌ tsoñꞌen jñꞌoon na icoꞌxenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndoꞌ jñꞌoon na jndë ve itsijonhanꞌ juuhanꞌ chaꞌna juu jñꞌoonꞌñeen. Ndö vaa na itsohanꞌ: “Cüiveꞌnchjiꞌ minninchen tsꞌan chaꞌxjen veꞌnchjii nquii ꞌuꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Joo ve jñꞌoonminꞌ conduihanꞌ xꞌee tsoñꞌen jñꞌoonꞌ Tyoꞌtsꞌon na tquen Moisés yo jñꞌoonꞌ Tyoꞌtsꞌon na toninncya nnꞌan ndyu na toxenꞌchen na tonduehan nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Viochen xjen na ninvaa mꞌan nnꞌan tmaanꞌ fariseos, taxeeꞌ Jesús cüii jñꞌoon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Tso jon: —¿Nchu vaa na cotjiꞌhoꞌ cüenta ntyja ꞌnaanꞌ nquii juu na conduihin Cristo? ¿Nin tsꞌan tsjan ꞌnaanꞌhin? Tꞌahan, jnduehan nnon jon: —Conduihin tsjan David na jndyocahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ndoꞌ tso jon ndëëhan: —Mayuuꞌ na nndaꞌ. Ndoꞌ nquii David yo na tyincyaa Espíritu Santo na jndaꞌ xquen jon, tji jon ncüii jñꞌoon ntyja ꞌnaanꞌ Cristo, tsjan ꞌnaanꞌ nquii jon na jndyocahanꞌ, na itso jon na ityentjon Cristo jon. Ndö juu jñꞌoon na tji David, ndö vaa na itsiquindyihanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nquii ta Tyoꞌtsꞌon icoꞌxen jon tsoñꞌen, tso jon nnon nquii jon na conduihin na ityentjon jon ja: “Quijmanꞌ ncꞌia ntyjaya naijon na itsitꞌmaanꞌhanꞌ ꞌuꞌ ata xjen nque nnꞌan na jndohan ꞌuꞌ jndë tjuꞌcjëhan nacje ꞌnanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ndoꞌ tsontyichen Jesús: —Ndö vaa jñꞌoon mavaxꞌë ndëëhoꞌ: Juu David itso jon na nquii Cristo conduihin tsjan ꞌnaanꞌ nquii jon na jndyocahanꞌ, yajoꞌ ¿Nchu vaa na itso jon na nquii Cristo conduihin nquii ta na ityentjon jonhin?” ");
INSERT INTO azgNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Majoꞌ minꞌncüii joo nanꞌñeen tyiꞌquindëë ntꞌahin yo jñꞌoon na taxeeꞌ jon. Ndoꞌ mantyi xuee na tacachenhanꞌ, tavi ꞌnan tsꞌan tyꞌoon na tꞌman tsꞌon na ngüaxeeꞌntyichen jñꞌoon nnon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jndë joꞌ sinin Jesús ndëë nnꞌan na jndye jndyiꞌhin yo ndë́ já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, tso jon: ");
INSERT INTO azgNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Nque nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés yo joo nnꞌan tmaanꞌ fariseos, tyꞌonhan cüenta juu tsꞌian na totsixuan Moisés na quinanꞌquindyiihinhoꞌ nchu vaa tsiꞌman juu jñꞌoon na tquen tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Mangꞌe joꞌ quitquenhoꞌ cüenta jñꞌoon na conanꞌmanhan. Ndoꞌ quinanꞌquindëhoꞌ tsoñꞌen chaꞌxjen na cotoꞌxenhan na quintꞌahoꞌ. Majoꞌ tyiꞌntsantyjahoꞌ chaꞌna contꞌa nquehan, ee joohan ya jñꞌoon na coninncyahan, majoꞌ ñoon ñoon ꞌnan na contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ee nquehan cotquenhan jñꞌoon na ijndeiꞌhanꞌ na quinanꞌquindë nnꞌanhanꞌ na itsijonhanꞌ juuhanꞌ chaꞌvijon conanꞌtyenhan ncüii xu na ja na cotyiohinhanꞌ quityaꞌ nnꞌan. Majoꞌ min nquehan tyiꞌjeꞌquityiꞌhan min veꞌ ninꞌncüii ndëë ndueehan na ntejndeihan nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Tsoñꞌen ꞌnan na contꞌahan, contꞌahinhanꞌ chaꞌ quitquen nnꞌan cüenta na jen conanꞌquindëhan. Min ntjan na ntuein chjo na chuuꞌ jñꞌoonꞌ Tyoꞌtsꞌon, conanꞌtyenhinhanꞌ quitahan yo ndueehan. Joo jñꞌoonꞌñeen tji nquehinhanꞌ nnon ntjanꞌñeen. Contꞌahin na nndaꞌ chaꞌ quitquen ntyjehin cüenta na njon jndyi ngiohan juu jñꞌoonꞌ jon. Ndoꞌ mantyi ndiaatonco na cüehin, toncontyichen nman ꞌndyohanꞌ contꞌahan, chichen ndiaaꞌ minꞌcya ro tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ndoꞌ mantyi ya na coveeꞌ nguee, cojooꞌ nꞌonhan na nquehan ngüendyuaa naijon na itsiquinjonntyichenhanꞌhin. Ndoꞌ ya na covancüi nnꞌan vatsꞌon, cojntꞌuehan silla na tonnonntyichen naijon na nditꞌmaanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mantyi caveeꞌ jndyi ngiohan na nninncyaa tsꞌan tsꞌon joohan xoncüe tsꞌua, ndoꞌ na quindue nnꞌan ndëëhan na mastrohin na conanꞌmanhin jñꞌoon na tquen Moisés. ");
INSERT INTO azgNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Majoꞌ ꞌoꞌ tyiꞌjntꞌuehoꞌ na quindue nnꞌan mastro ꞌoꞌ, ngꞌe tsoñꞌenhoꞌ conduihoꞌ ntyje nquehoꞌ, ndoꞌ xiaꞌntyi nquii Cristo conduihin mastro ꞌnaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Min tyiꞌnanꞌtꞌmaanꞌ ꞌoꞌ ncüii tsꞌan tsonnangue na nnduehoꞌ na conduihin tyehoꞌ. Ngꞌe ninncüiihin na conduihin Tyehoꞌ, nquii jon na mꞌaan jon quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Min tyiꞌninncyahoꞌ na ndue nnꞌan na ꞌoꞌ conduihoꞌ nnꞌan na coꞌo jndyeehoꞌ, ngꞌe xiaꞌntyi nquii Cristo conduihin na vja jndyee jon tondëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ndoꞌ minninchen tsꞌan na tꞌmanntyi conduihin quiiꞌ ntꞌanhoꞌ, chuhanꞌ na quityeꞌntjon juu ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Minꞌcya ro tsꞌan na itsiquinjon nquiihin, ncjuꞌcje Tyoꞌtsꞌonhin. Ndoꞌ minninchen tsꞌan na ijuꞌcje nquiihin, ntsiquinjon Tyoꞌtsꞌonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ꞌOꞌ nnꞌan fariseos yo ꞌoꞌ nnꞌan na conanꞌmanhoꞌ jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. ꞌOꞌ veꞌ contꞌa nquehoꞌ na jen ya nnꞌanhoꞌ, majoꞌ cotꞌiooꞌhoꞌ ndëë nnꞌan chaꞌ tyiꞌndëë nnanꞌjonhan yo na ityeꞌntjon Tyoꞌtsꞌon nnꞌan. ꞌOꞌ tyiꞌquitaꞌngueeꞌhoꞌ na ntyeꞌntjon jonhoꞌ, ndoꞌ joo nnꞌan na ninꞌquinanꞌjonhan ntyja ꞌnaanꞌhanꞌ, conanꞌntcüeꞌhoꞌhin. Nquehoꞌ tyiꞌninꞌquityiiꞌhoꞌ juu na ityentjon jon, min tyiꞌninꞌncyahoꞌ na ngoqueꞌ nnꞌan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“ꞌOꞌ nnꞌan tmaanꞌ fariseos yo ꞌoꞌ nnꞌan na conanꞌmanhoꞌ jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. ꞌOꞌ veꞌ contꞌa nquehoꞌ na njon jndyi Tyoꞌtsꞌon ngiohoꞌ. Majoꞌ joo nanntcu ninnque, cotyjehoꞌ ntꞌaahan, ndoꞌ chaꞌ nnanꞌtiu nnꞌan na njon jndyi Tyoꞌtsꞌon ngiohan, jndye jñꞌoon conanꞌneinhoꞌ nnon jon chaꞌ tyiꞌntsiꞌman nquiiꞌhanꞌ na viꞌ nnꞌan ꞌoꞌ. Mangꞌe joꞌ juu xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na conanꞌtjahin nnon jon, tꞌmanntyichen ntꞌuiiviꞌhanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“ꞌOꞌ nnꞌan tmaanꞌ fariseos yo ꞌoꞌ nnꞌan na conanꞌmanhoꞌ nchu vaa itsiquindyi jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. Ee ꞌoꞌ veꞌ contꞌa nquehoꞌ na ya jndyi nnꞌanhoꞌ. ꞌOꞌ tycya comaꞌndyiꞌhoꞌ ata covetꞌiohoꞌ ndaandue na cojntꞌuehoꞌ min ninncüii tsꞌan na ntsijonhin yo jñꞌoon na coninncyahoꞌ. Ndoꞌ ya na jndë jndë jntꞌahoꞌ na vantyja juu chaꞌxjen contꞌahoꞌ, yajoꞌ vjayꞌoonhanꞌhin na ji vaachen ntsꞌaa juu. Ndoꞌ na nndaꞌ, jaaꞌntyichen ntꞌuiiviꞌhanꞌhin quiiꞌ vꞌio, chichen ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Viꞌ jndyi ntquenonhoꞌ, ꞌoꞌ na conanꞌmanhoꞌ ndëë ntyjeehoꞌ, majoꞌ itsijonhanꞌ ꞌoꞌ chaꞌvijon nannchjan. Ee ya na icüjiꞌ tsꞌan xueeꞌ vatsꞌon tꞌman, chaꞌ quitsiꞌmanhanꞌ na ntyjii Tyoꞌtsꞌon na jñꞌoon mayuuꞌ itsinin juu, conduehoꞌ na tyiꞌjaaꞌ jñꞌoonꞌñeen na iquentyen juu nacjooꞌ juu. Majoꞌ conduehoꞌ na juu jñꞌoon na ncüjiꞌ tsꞌan xueeꞌ sꞌon ijan na tcüeꞌ vatsꞌon tꞌman chaꞌ quitsiꞌmanhanꞌ na ntyjii Tyoꞌtsꞌon na jñꞌoon mayuuꞌ itso juu, juu jñꞌoonꞌñeen cotjiꞌhoꞌ cüenta jaꞌntyichenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ꞌOꞌ nanꞌ jndyi nquenhoꞌ. Nanꞌxuanhoꞌ na nchjan yantyihoꞌ. Ee ¿Nin cüii na ve nanꞌminꞌ njonntyichen tsixuanhanꞌ? Juu sꞌon ijan tyiꞌnjonchen tsixuanhanꞌ ngꞌe joo ꞌnan na jndë yo sꞌonꞌñeen, iquenhanꞌ joohanꞌ cüentaaꞌ Tyoꞌtsꞌon ngꞌe itsixuanhanꞌ ntyja ꞌnaanꞌ nquii vatsꞌon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ndoꞌ mantyi conduehoꞌ xjen na icüjiꞌ tsꞌan xueeꞌ nnontyiu quiiꞌ vatsꞌon tꞌman chaꞌ quitsiꞌmanhanꞌ na ntyjii Tyoꞌtsꞌon na mayuuꞌ jñꞌoon na itso juu, tyiꞌjaaꞌ jñꞌoon icüjiꞌ juu. Majoꞌ conduehoꞌ na juu jñꞌoon tjiꞌ tsꞌan xjen na icüjiꞌ juu xueeꞌ sꞌi quiooꞌ na cotyio nnꞌan nnontyiuꞌñeen chaꞌ quitsiꞌmanhanꞌ na ntyjii Tyoꞌtsꞌon jñꞌoon na mayuuꞌ conduehoꞌ, juu jñꞌoonꞌñeen jaaꞌchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ꞌOꞌ nanꞌ jndyi nquenhoꞌ. Quindëñꞌen nanꞌxuanhoꞌ nannchjanhoꞌ. Ee ¿Nin cüii na ve nanꞌminꞌ njonntyichen tsixuanhanꞌ? Juu sꞌi quiooꞌ na cotyio nnꞌan nnontyiuꞌñeen tyiꞌcüentyja na njonchen conduihanꞌ. Ee juu nnontyiu naijon contyjo siꞌñeen, juuhanꞌ njonchen tsixuanhanꞌ ngꞌe ntyja ꞌnaanꞌhanꞌ iquenhanꞌ siꞌñeen cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Joꞌ, juu tsꞌan na iquentyen ncüii jñꞌoon nacjooꞌ nquii xjen na icüjiꞌ juu xueeꞌ nnontyiu quiiꞌ vatsꞌon tꞌman chaꞌ quitsiꞌmanhanꞌ na mayuuꞌ jñꞌoon tso juu, chito xiaꞌntyi ntyja ꞌnaanꞌ nnontyiuꞌñeen iquentyen juu jñꞌoon, mantyi iyꞌoonhanꞌ tsoñꞌen ꞌnan na contyjo nacjooꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ndoꞌ juu tsꞌan na iquentyen ncüii jñꞌoon nacjooꞌ nquii na icüjiꞌ juu xueeꞌ vatsꞌon tꞌman, chito ixiaꞌntyi ntyja ꞌnaanꞌhanꞌ iquentyen juu jñꞌoon, ndoꞌ mantyi iyꞌoonhanꞌ nquii Tyoꞌtsꞌon na mꞌaan jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ndoꞌ juu tsꞌan na iquentyen ncüii jñꞌoon nacjooꞌ nquii na icüjiꞌ juu xueeꞌ quiñoonꞌndue, chito xiaꞌntyi ntyja ꞌnaanꞌhanꞌ iquentyen juu jñꞌoon, mantyi iyꞌoonhanꞌ juu silla na maninꞌtsꞌiaanꞌ ꞌnaanꞌ Tyoꞌtsꞌon ndoꞌ mantyi yo nquii jon na vequityen jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ꞌOꞌ nnꞌan fariseos yo ꞌoꞌ na conanꞌmanhoꞌ nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. Ee ꞌoꞌ veꞌ contꞌa nquehoꞌ na conduihoꞌ nnꞌan na conanꞌquindë. Ee coninncyahoꞌ diezmo cüentaaꞌ Tyoꞌtsꞌon ntyja ꞌnaanꞌ na coveꞌ ntjon ꞌnaanhoꞌ, ata min veꞌ tsco quichi menta yo tsco anís yo ntqueenꞌ cominon na coninncyahoꞌ, majoꞌ juu jñꞌoon na jaaꞌntyi tyquiiꞌ jñꞌoon na tquen Moisés, tyiꞌninꞌquitaꞌngueeꞌhoꞌhanꞌ. Joo jñꞌoonꞌñeen conanꞌmanhanꞌ nchu vaa na ncꞌonhoꞌ chaꞌxjen na chuhanꞌ tonnon Tyoꞌtsꞌon, yo na quinanꞌvengiohoꞌ nnꞌan ndoꞌ mantyi quinanꞌquindëhoꞌ jñꞌoon na conduehoꞌ. Ee chaꞌxjen na itsohanꞌ na coninncyahoꞌ diezmo, mantyi quinanꞌquindëhoꞌ jñꞌoonminꞌ na njonntyichen conduihanꞌ na tquen Moisés. ");
INSERT INTO azgNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Itsijonhanꞌ ꞌoꞌ chaꞌna nnꞌan na conanꞌcüꞌaanhan ndaatioo na covehan chaꞌ ncüjiꞌhanꞌ quiooꞌ quijndë, majoꞌ tyiꞌquitquenhan cüenta na tondye tsjoꞌñeen, joꞌ ñjon ncüii camello tueꞌ. Ee cojooꞌ nꞌonhoꞌ na ninꞌquinanꞌquindëhoꞌ jñꞌoon na tyiꞌtꞌmanchen nanꞌxuanhanꞌ, majoꞌ jñꞌoon na njonntyichen tyiꞌninꞌquinanꞌquindëhoꞌhanꞌ. Mangꞌe na nndaꞌ, ꞌoꞌ nanꞌxuanhoꞌ nnꞌan na conanꞌmanhoꞌ nato ndëë nnꞌan, majoꞌ nquehoꞌ conduihoꞌ chaꞌvijon nannchjanhoꞌ na coveꞌjndyeehoꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ꞌOꞌ nnꞌan fariseos yo ꞌoꞌ nnꞌan na conanꞌmanhoꞌ nchu vaa itsiquindyi jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. Ee ꞌoꞌ veꞌ contꞌa nquehoꞌ na ya jndyi nnꞌanhoꞌ majoꞌ juu na cotsamꞌanhoꞌ, itsijonhanꞌ juuhanꞌ chaꞌvijon tsꞌan na ya ya itsintjuꞌ juu naxenꞌ vaso yo xio, majoꞌ quityquiiꞌhanꞌ tyꞌa jndyihanꞌ. Ee ꞌnan na cocüaꞌhoꞌ na ñjonhanꞌ joꞌ, nanꞌxuanhanꞌ ꞌnaan nnꞌan na contyꞌueehoꞌ yo na tyiꞌninꞌquitquen nquehoꞌ xjen yo ꞌnan na ntꞌue jndyi nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ꞌOꞌ nnꞌan fariseos, ꞌoꞌ conduihoꞌ chaꞌvijon nannchjan. Nquehoꞌ quitquen jndyoyuhoꞌ na tonnon Tyoꞌtsꞌon, yajoꞌ ntyja ꞌnaanhoꞌ ntsijonhanꞌ chaꞌvijon na jndë jnanꞌntjuꞌ ꞌoꞌ quityquiiꞌ vaso yo xio. Ndoꞌ na nndaꞌ, ntsꞌaahanꞌ na cüejon ntjuꞌ quityquiiꞌhanꞌ yo naxenꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ꞌOꞌ nnꞌan fariseos yo ꞌoꞌ na conanꞌmanhoꞌ nchu vaa itsiquindyi jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. Ee ꞌoꞌ veꞌ contꞌa nquehoꞌ na ya jndyi nnꞌanhoꞌ. Majoꞌ itsijonhanꞌ ꞌoꞌ chaꞌna ndiꞌntꞌua na veꞌ cjohanꞌ quichiꞌ jndyi ndyiaaꞌ tsꞌan, majoꞌ quityquiiꞌhanꞌ tooꞌ ndiꞌ ntꞌoo yo tsochen nnon ꞌnan tyꞌa nanꞌxuanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Manndaꞌ vaa na itsijonhanꞌ ntyja ꞌnaanhoꞌ ee tondëë nnꞌan contꞌahoꞌ na jen ya nnꞌanhoꞌ, majoꞌ tyquiiꞌ nꞌonhoꞌ ninnquiiꞌchen ve vaa na conanꞌtiuhoꞌ, yo na tooꞌchenhanꞌ mꞌaan ꞌnan tyia. ");
INSERT INTO azgNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ꞌOꞌ nnꞌan fariseos yo ꞌoꞌ na conanꞌmanhoꞌ nchu vaa siquindyi jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. Ee veꞌ contꞌa nquehoꞌ na jen ya nnꞌanhoꞌ. Ee conanꞌyahoꞌ ndiꞌntꞌua ꞌnaan nque nnꞌan na toninncyahin jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa, ndoꞌ mantyi conanꞌtycüiꞌhoꞌ ndiꞌntꞌua ꞌnaan ntꞌoo na totsamꞌanhan yo na chuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ndoꞌ conduehoꞌ xe na juuhanꞌ aa mꞌanhoꞌ juu xjen na tomꞌan ndochihoꞌ ndyuꞌñeen, tyiꞌxequinanꞌjonhoꞌ xjen na tonanꞌcüje nanꞌñeen nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ndoꞌ na conduehoꞌ na nndaꞌ, nquehoꞌ cotjiꞌ jndyoyuhoꞌ jñꞌoon nacjohoꞌ na conduihoꞌ tsjan ꞌnaan nanꞌñeen na jndyocahanꞌ, nque nanꞌñeen na tonanꞌcüjehan nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Mangꞌe joꞌ chaꞌxjen na tontꞌa ndochihoꞌ, quinanꞌquindëñꞌenhoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“ꞌOꞌ ntyja ꞌnan tyia na contꞌahoꞌ, conduihoꞌ chaꞌvijon nda quinduntja. Minꞌncüii ꞌnan jeꞌquindëë ntꞌahoꞌ chaꞌ ntyja ꞌnaanꞌhanꞌ ndyaahoꞌ juu naviꞌ na ntꞌuiihanꞌ nnꞌan na ncꞌohan vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Mangꞌe joꞌ matsjö ndëëhoꞌ, quiiꞌ ntꞌanhoꞌ njñön ja nnꞌan na nninncyahan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon ndëëhoꞌ na nnanꞌneinhin ndëëhoꞌ yo ntyja ꞌnaanꞌ na jndaꞌ xquen jon ndoꞌ na nnanꞌmanhan ndëëhoꞌ nchu vaa na icoꞌxen jon. Majoꞌ minndye nanꞌñeen, nnanꞌcüjehoꞌhan. Ndoꞌ ñꞌen ntyjehan njñonhoꞌhin nonjnꞌaan. Ndoꞌ ñꞌen nanꞌñeen na ntjaꞌhoꞌhin quiiꞌ ntꞌaanꞌon. Ndoꞌ ñꞌenhan na ntyꞌehoꞌhin ncüii ndoꞌ ncüii tsjoon. ");
INSERT INTO azgNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndoꞌ tsojnaanꞌ na ntꞌahoꞌ na nndaꞌ, ndyionhoꞌ jnan nnꞌan na jnanꞌcüjehan tsoñꞌen nnꞌan na tonduihan nnꞌan na jntꞌahan ꞌnan na chuhanꞌ na tonnon Tyoꞌtsꞌon xjen na tyeꞌ na mꞌaan tsonnangue ata xjen nein. Ngityeꞌ na ntꞌuiiviꞌhanꞌ ꞌoꞌ xjen na iscueeꞌ Caín tyje juu Abel, tsan na tova mꞌaan juu chaꞌxjen na chuhanꞌ, jndyocahanꞌ ata xjen jnanꞌcueeꞌ ndochihoꞌ nquii Zacarías jnda Berequías xoncüe quiiꞌ ntanꞌ nnontyiu tꞌman yo ta vatsꞌon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tsoñꞌenhoꞌ na mꞌanhoꞌ nanein, majndë majndaꞌ na ntꞌuiiviꞌhanꞌ ꞌoꞌ ntyja ꞌnaanꞌ tsoñꞌen naviꞌminꞌ na tquenon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“ꞌOꞌ nnꞌan Jerusalén na conanꞌcüjehoꞌ nnꞌan na coninncya jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa ndoꞌ cotuenꞌhoꞌ ntjöꞌ joo nnꞌan na ijñon jon na mꞌanhoꞌ, majndye jnda tontyja tsꞌön na ntsincüi ja ꞌoꞌ na ncꞌonhoꞌ ntyja njan chaꞌxjen ncüii quitsjon xque itsincüi oꞌ ntsinda oꞌ quityquiiꞌ tsëëꞌ oꞌ. Majoꞌ ꞌoꞌ taꞌnan jntꞌue nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Joꞌ quitquenhoꞌ cüenta, jndë jntyꞌii Tyoꞌtsꞌon ꞌoꞌ, tajeꞌcüantyjeeꞌntyichen jon tsjoonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, nanein na tonnonchen taxeꞌquijntyꞌiantyichenhoꞌ ja ata juu xjen ya na ngüentyja xuee na nnduehoꞌ: “Ityio Tyoꞌtsꞌon jnꞌaan nquii jon na icüjeeꞌnon jon na mꞌan jaa yo juu najndei na condui nquii jon.” ");
INSERT INTO azgNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jnduiꞌ Jesús vatsꞌon tꞌman, ndoꞌ viochen xjen na vja jon, já nnꞌan na cotsayꞌö́n yo jñꞌoon toninncyaa jon, jnanꞌndyooꞌ já nnon jon. Tꞌá na conanꞌmán nnon jon nchu xjen na nancooꞌ jndyi ntꞌaa cüentaaꞌ juu vatsꞌon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Majoꞌ tꞌa jon jndyuë́: —Mayuuꞌ, itso jon, nanein cojntyꞌiahoꞌ ntꞌaaminꞌ. Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tyiꞌxeꞌquiꞌndyihanꞌ minꞌncüii tsjöꞌ nacjooꞌ ntyjehanꞌ. Tsoñꞌen ntꞌaaminꞌ ndyuiiꞌñꞌenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ndoꞌ sá tyoꞌ na mꞌan nꞌoon olivos. Ndoꞌ vi na jndë tëcjo Jesús joꞌ, já nnꞌan na cotsayꞌö́n yo jñꞌoon toninncyaa jon, santyjáꞌ nnon jon chaꞌ nndëë nnanꞌnë́n yohin na ninnquëchë́n. Jnduë́: —Quitsuꞌ ndë́ yuu xjen na ndui nanꞌminꞌ na tsuꞌ. Ndoꞌ ¿Cüan na ndityincyooꞌ na ntsiꞌmanhanꞌ na jndë tindyo nndyoꞌ nndaꞌ ndoꞌ na mantycüii tsonnangue? ");
INSERT INTO azgNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tꞌa Jesús jndyuë́, itso jon: —Quitquenhoꞌ cüenta na minncüii tsꞌan tyiꞌntsiviꞌnnꞌan ꞌoꞌ ntyja ꞌnaan jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ngꞌe jndye nnꞌan nninncyohan yo xuë na nnduehan joohan conduihin Mesías, ndoꞌ na nndaꞌ ntsiviꞌnnꞌanhanꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nndyo nndyooꞌ nndyehoꞌ na mꞌaan ndyiaꞌ ndoꞌ nnincꞌuaa jñꞌoon na ncꞌoon ndyiaꞌ mañoon tsonnangue. Majoꞌ tyiꞌntyuehoꞌ ee mancüiixjen ijndeiꞌhanꞌ na ngüenon jndyee nanꞌminꞌ. Majoꞌ min na nndaꞌ ninvaa vitjachen na ntycüii tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nnꞌan ncüii tsonnangue nnanꞌvehan nacjo nnꞌan ncüiichen tsonnangue. Ndoꞌ ncüii tsanmꞌaantsꞌian tꞌman ntsuehin nacjooꞌ cüiichen tsanmꞌaantsꞌian. Jndye joo ncꞌoon jndoꞌ tꞌman ndoꞌ jndei ngontsꞌii tyuaa. ");
INSERT INTO azgNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Tsoñꞌen naviꞌminꞌ, joohanꞌ ndui na vejndyee. Itsijonhanꞌ joohanꞌ chaꞌvijon ya na ngityeꞌ na iquiihanꞌ tsanscu na ntsingui jon. ");
INSERT INTO azgNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Xjenꞌñeen ntꞌueviꞌ nnꞌan ꞌoꞌ ngꞌe na mꞌanhoꞌ ntyja njan ndoꞌ nninncyahan cüenta ꞌoꞌ nduee nnꞌan na nntꞌaviꞌhan ꞌoꞌ ndoꞌ nnanꞌcüjehan ꞌoꞌ. Ndoꞌ nnꞌan xejndio tsonnangue ncꞌonhan na jndo jndyihan ꞌoꞌ ngꞌe na mꞌanhoꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Juu xjenꞌñeen jndye nnꞌan ntji ntcüeꞌhan ntyja ꞌnaanꞌ na vantyja nꞌonhan Tyoꞌtsꞌon. Ncꞌonhan na jndohan ntyjehan ata njntꞌuehan jñꞌoon na quitꞌuiiviꞌhanꞌ nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ndoꞌ nnintyiꞌncyooꞌ nnꞌan na nnduehan na coninncyahan jñꞌoonꞌ Tyoꞌtsꞌon, majoꞌ veꞌ quintuhanꞌ na ntyja ꞌnaanꞌhanꞌ jndye nnꞌan nnanꞌviꞌnnꞌan nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndoꞌ ngꞌe vandijndye nnon ꞌnan tyia, juuhanꞌ ntsꞌaahanꞌ na taviꞌjeꞌcüiviꞌngio nnꞌan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Majoꞌ ncüii cüii tsꞌan na ntjotyenhin ntyja njan ata xjen ntycüii tsoñꞌen, ntsinꞌman ja ñuaanꞌ tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ninvaa tsonnangue ncꞌo nnꞌan na nninncyahan juu jñꞌoon nayavahin ntyja ꞌnaanꞌ juu na ityentjon Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. Juuhanꞌ ntsiꞌman jndyoyuhanꞌ ndëë nnꞌan ncüii ncüii tsonnangue nchu vaa na cꞌonhan na tonnon Tyoꞌtsꞌon, yajoꞌñeen ngüentyja xjen na ntycüii tsoñꞌen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Minꞌcya ro tsꞌan na itsijnaanꞌ jñꞌoonminꞌ, cüaaꞌ tsꞌon juu nchu vaa na ninꞌquitsiquindyihanꞌ. Juu Daniel, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa, tji jon jñꞌoon ntyja ꞌnaanꞌ juu tsan na ji vaa tyia ꞌnan itsꞌaa na ntsiꞌndaaꞌ juu tsoñꞌen. Juu xjen na njntyꞌiahoꞌ na jndë mꞌaan tsanꞌñeen quityquiiꞌ vatsꞌon tꞌman naijon na taquintyja na jiꞌua conduihanꞌ cüentaaꞌ Tyoꞌtsꞌon, ");
INSERT INTO azgNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Yajoꞌ tsoñꞌenhoꞌ na mꞌanhoꞌ ndyuaa Judea, quinanꞌnonhoꞌ na quitsataꞌntyꞌiuhoꞌ quiiꞌ ntyoꞌ jndëë. ");
INSERT INTO azgNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Juu xjenꞌñeen tsꞌan na ntyjo juu xquen vaaꞌ juu na su, ya na nndyocue juu, tyiꞌngaqueeꞌ juu quiiꞌhanꞌ na ncüjiꞌ juu ꞌnan. Quitsityuaaꞌntyichen juu, quinanon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ndoꞌ minninchen tsꞌan na mꞌaan tojndëë na itsꞌaa juu tsꞌian, tyiꞌngantcüeꞌ juu vaaꞌ juu na ngaquichu juu ndiaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Juu xjenꞌñeen, joo nanntcu na ñjon nda na mꞌanhin ndyuaaꞌñeen, viꞌ jndyi ntquenonhan, yo joo ntyjehan na ꞌndaa nda. ");
INSERT INTO azgNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ntyja ꞌnaanꞌ juu naviꞌñeen, quitanhoꞌ nnon Tyoꞌtsꞌon na tyiꞌntsijonhanꞌ na nnanꞌnonhoꞌ tyquiiꞌ nguee tein, min chito juu xuee na cotaꞌjndyee nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ngꞌe juu xjenꞌñeen ngioo cüii naviꞌ na tꞌmanntyichen na minꞌjon tyíꞌcotjon nnꞌan ntyjantyi xjen na tyeꞌ tsonnangue ata xjen nein. Ndoꞌ na tonnonchen tajeꞌquindui nndaꞌ cüiichen naviꞌ na ntsijonhanꞌ juuhanꞌ chaꞌna juu naviꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Majoꞌ nquii Tyoꞌtsꞌon, jndë sijndaꞌ jon na tyiꞌviochen na nguaa juu naviꞌ tꞌmanꞌñeen. Ee xe na aa tyiꞌquitsꞌaa jon na nndaꞌ, minꞌncüii tsꞌan jeꞌquinꞌman yo juuhanꞌ. Majoꞌ ngꞌe na veꞌnchjii jon nnꞌan na jndë tji jon na conduihan cüentaaꞌ jon, joꞌ chi ntsꞌaa jon na tyiꞌjndye xuee na ncꞌoon naviꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Juu xjenꞌñeen xe na aa ngitso cüii tsꞌan ndëëhoꞌ: “Ndö mꞌaan nquii Mesías”, Oo ngitso juu “Ndöꞌñeen mꞌaan jon”, tyiꞌngantyja nꞌonhoꞌ jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ee nnintyincyooꞌ nnꞌan na nnduehan na joohan condui Mesías. Nnduehan na jñꞌoonꞌ Tyoꞌtsꞌon coninncyahan min na minꞌchjo tyiꞌyuuꞌhanꞌ. Ndoꞌ nntꞌahan jndye nnon jnꞌaan tꞌman yo jndye nnon tsꞌian na tyiꞌjeꞌquinduihanꞌ yo najndei nquii tsꞌan. Tsꞌianꞌñeen ngaveeꞌ ngio nnꞌanhanꞌ, majoꞌ nnanꞌviꞌnnꞌanhanꞌhin. Nntꞌa nanꞌñeen juu tsꞌianꞌñeen chaꞌ nnanꞌviꞌnnꞌanhan nnꞌan na icüji Tyoꞌtsꞌon cüentaaꞌ jon xe na aa nndëë nntꞌahan. Majoꞌ tyiꞌxeꞌncyaa jon na nndëë nntꞌahan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Matyuaaꞌntyichen matsiquindyi ja ꞌoꞌ vitjachen na nnduihanꞌ chaꞌ quintꞌahoꞌ cüenta. ");
INSERT INTO azgNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Mangꞌe joꞌ xe na aa ngitso tsꞌan ndëëhoꞌ: “Ndöꞌñeen mꞌaan juu Mesías totyquiiꞌ jndëë”, tyiꞌncꞌohoꞌ joꞌ. Ndoꞌ xe na aa nnduehan: “Ntyjava mꞌaan jon quityquiiꞌ vꞌaa”, tyiꞌngantyjato nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ngꞌe ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, juu xjen ya na nndyö nntꞌa, juu na ndityincyooꞌ ja ndëë nnꞌan na ninvaa tsonnangue, ntsijonhanꞌ juuhanꞌ chaꞌxjen na covixue chontsuee tontyja na quinduiꞌ ndoꞌcüjioonꞌ ata tontyja na vahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Juu naviꞌñeen na jndë tsjö na ntquenonhoꞌ, mancüiixjen ngüentyjahanꞌ ngꞌe minyuuchen na vaquityen quiooꞌ tueꞌ, majoꞌ ngancüii ntꞌën. ");
INSERT INTO azgNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ndë ngue na ngüenon naviꞌ tꞌman ngueeꞌñeen, ndijaan ndoꞌcüjioonꞌ, ndoꞌ mantyi chiꞌ taxeꞌcüixueehanꞌ, ndoꞌ ntycyaa ncjuu tsjöꞌndue. Ndoꞌ mantyi joo natyia na cotoꞌxen na mꞌan tsjöꞌndue, nndyuiiꞌ tsoñꞌenhan. ");
INSERT INTO azgNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ndoꞌ juu xjenꞌñeen tsjöꞌndue nnintyincyooꞌ jnꞌaan ntyja njan na condui ja tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan. Xjen na njntyꞌia nnꞌan tsonnangue juu jnꞌaanꞌñeen, ntsitꞌioohanꞌhin. Ndoꞌ nntꞌui na nndyocuë quityquiiꞌ chincyu yo najndei na condui ja ndoꞌ yo juu na nanncooꞌ na quixuee na condui tꞌman ja. ");
INSERT INTO azgNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Yajoꞌ jndei nninꞌcꞌuaa ndu ꞌnaanꞌ Tyoꞌtsꞌon, ndoꞌ njñön ángeles njan na ncꞌohan ninvaa tsonnangue na quinanꞌncüihan nnꞌan na jndë tji ja cüenta na mꞌanhan ncüii ncüii ndyuaa na ninvaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Juu jnꞌaan ntyja ꞌnaanꞌ tsꞌoon higuera, cüaaꞌ nꞌonhoꞌ nchu vaa itsiquindyihanꞌ. Juu xjen na cojntyꞌiahoꞌ na condeiꞌ ntꞌöhanꞌ, ndoꞌ conduiꞌ tscoꞌndaahanꞌ, yajoꞌ covaaꞌ nꞌonhoꞌ na jndë tindyo ngueesuaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Machaꞌxjen covaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ na nndaꞌ, mantyi xjen na cojntyꞌiahoꞌ na condui tsoñꞌen nanꞌminꞌ na jndë siquindyi ꞌoꞌ, joꞌ cüaaꞌ nꞌonhoꞌ na jndë tichjo xuee. Mavaa mavaa xjen na nndyö nntꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Quindyehoꞌ ntsjö, jñꞌoon na mayuuꞌ, nnꞌan na mꞌan nein tyiꞌxecüjeñꞌenhan ata xjen na jndë siquindëñꞌenhanꞌ tsoñꞌen jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tsjöꞌndue yo tsonnangue ntycüiiñꞌenhanꞌ, majoꞌ juu jñꞌoon na mancya, tsoñꞌenhanꞌ ntsiquindëñꞌenhanꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Majoꞌ minꞌncüii tsꞌan tyiꞌquintjii nin xuee ndoꞌ yuu xjen na nndui tsoñꞌen nanꞌminꞌ. Min nque ángeles na mꞌan quiñoonꞌndue tyiꞌquindiohan, min ja na condui Jnda Tyoꞌtsꞌon tyiꞌquintyji yuu xjenhanꞌ, xiaꞌntyi nquii Tyëhöꞌ ntyjii jon. ");
INSERT INTO azgNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, xjen na nndyö nntꞌa, nnꞌan na mꞌan juu xjenꞌñeen, ntsijonhanꞌ ntyja ꞌnaanhan chaꞌxjen na tonanꞌxuan nnꞌan xjen na tomꞌaan Noé. ");
INSERT INTO azgNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ee joo ndyuꞌñeen vitjachen na siquitsu ndaatsuaꞌtyꞌa tsonnangue, joo nanꞌñeen tocüaꞌhan, tovehan, totoncohan, toninncyahan ndahan na nnonco joo ata juuntyi xuee ya na tëqueeꞌ nquii Noé vꞌaandaa tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Majoꞌ joo nanꞌñeen minꞌchjo tyíꞌquitquentohan cüenta na vaa na toncuuꞌ ata juu xjen na jndyo ndaatsuaꞌtyꞌa na tachuhanꞌ tsoñꞌenhan. Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, manndaꞌ vaa na itsijonhanꞌ na ntquenon nnꞌan juu xjen ya na ncüjë nntꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Majuu xjenꞌñeen ntsijonhanꞌ mꞌan ve nnꞌan na contꞌahan tsꞌian jndëë. Cüii tsanꞌñeen ncjöyꞌönhin na ncꞌoon juu na mꞌan ja ndoꞌ ncüiichen tyje juu nꞌndyihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Manndaꞌ ntsijonhanꞌ ntyja ꞌnaan ve nanntcu na cotua. Cüiihan ncjöyꞌönhin na ncꞌoon juu na mꞌan, ndoꞌ ncüiichen tsanꞌñeen nꞌndyihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Mangꞌe joꞌ ninnquiiꞌchen cꞌoncjehoꞌ ee tyiꞌquindiohoꞌ yuu xjen na nndyö ntcüꞌë ja na condui na matyeꞌntjön ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Juu jñꞌoonvahin na tyiꞌquitso nquiiꞌhanꞌ, cüaaꞌ nꞌonhoꞌhanꞌ. Xe na aa ntyjii tsꞌan yuu xjen ntsque nanntyꞌuee vaaꞌ jon, tyiꞌxequitso jon, min xeꞌncyaa jon na ngoqueꞌhan na ntjiꞌhan ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Mangꞌe joꞌ mantyi ꞌoꞌ cꞌoncjehoꞌ ee majuu xjen na tyiꞌquinanꞌtiuhoꞌ, majuuto xjenꞌñeen, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, nndyö ntcüꞌë. ");
INSERT INTO azgNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Juu moso na jndaꞌ xquen ndoꞌ itsiquindë juu, majuu juu ntquen jndyee patrón ꞌnaanꞌ juu na quityentjon juu tsoñꞌen ntyje moso juu na mꞌanhin vꞌaaꞌñeen. Ndoꞌ ntixeeꞌ juuhan xjen na icanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Xjen na ncüjeeꞌ ntcüeꞌ patrón ꞌnaanꞌ juu na tja jon cüii joo, ndoꞌ xe na aa ntjii jon na juu mosoꞌñeen ya itsiquindë juu tsꞌian na chu juu, neiinꞌ jndyi jon. ");
INSERT INTO azgNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, tsoñꞌen ꞌnaanꞌ juu patrónꞌñeen, nnincyaa jon cüentahanꞌ ntꞌö juu mosoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Majoꞌ juu mosoꞌñeen, xe na aa conduihin na tyia tsꞌanhin, ndoꞌ ndyiiꞌ tsꞌon juu na tyiꞌxecüjeeꞌ tyuaaꞌ patrón ꞌnaanꞌ juu, ");
INSERT INTO azgNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ndoꞌ ngꞌe joꞌ ngitaꞌ juu na ncüjaꞌ juu minndyechen nanꞌñeen na mꞌan nacje ꞌnaanꞌ juu, ndoꞌ ntsijonhin yo nanquindye na ncꞌu juu ndoꞌ na ntcüaꞌ juu yohan, ");
INSERT INTO azgNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ndoꞌ na nndaꞌ, nquii patrón ꞌnaanꞌ juu ncüjeeꞌ ntcüeꞌ jon maninꞌjuu xuee na tyiꞌcꞌooncje juu, majuuto xjen na tyiꞌquitsitiu juu na ncüjeeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ndoꞌ nquii patrón, ji vaa jndyi ncüjaꞌ jonhin, ndë joꞌ ncjuꞌ jon tsanꞌñeen naijon na mꞌan nnꞌan na veꞌ contꞌa nquehan na ya nnꞌanhan. Joꞌ naijon na ntꞌioo juu ndoꞌ ntcüaꞌ juu ndiꞌnꞌon juu na itsiꞌndaaꞌhanꞌ ntyjii juu. ");
INSERT INTO azgNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sininntyichen Jesús ncüiichen jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ntyja ꞌnaanꞌ na toco tsꞌan. Juu jñꞌoonꞌñeen itꞌuiiꞌhanꞌ ntyja ꞌnaanꞌ na ityeꞌntjon Tyoꞌtsꞌon nnꞌan. Itso Jesús: —Tomꞌan nqui yontcundyua, tyecho joo candi ꞌnaan joo na covꞌahanꞌ yo aceite. Jnduiꞌ joo, tyequitjon joo juu tsansꞌa na ngoco. ");
INSERT INTO azgNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ꞌOnhin tyiꞌjndaꞌ nquen, ndoꞌ cüiichen ꞌon ntyje joo, jndaꞌ nquen yoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Joo yontcu na tyiꞌjndaꞌ nquen, tyecho yoꞌñeen candi ꞌnaan joo, majoꞌ tasayꞌonchen joo aceite na ncꞌua. ");
INSERT INTO azgNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Majoꞌ joo yontcu na jndaꞌ nquen, tyecho yoꞌñeen candi ꞌnaan joo na covꞌa ndoꞌ mantyi yo ninꞌndioo na ñjon aceite. ");
INSERT INTO azgNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Viochen xjen na minndooꞌ yoꞌñeen nquii tsansꞌa na ngoco, sijaaꞌhanꞌ tsantsjon ndëë joo, ndoꞌ jnda joo. ");
INSERT INTO azgNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ndoꞌ xoncüe tsjon, ticꞌuaa na itsixuaa tsꞌan. Itso juu: “Cꞌoncjehoꞌ, jndë mandyo nquii tsꞌan na icoco. Ncyohoꞌ na nnanꞌjonhoꞌ yohin.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Joꞌ jnanꞌquintyja yontcuꞌñeen. Taꞌya joo ndiaa nnon candi ꞌnaan joo. ");
INSERT INTO azgNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ndoꞌ joo yontcuꞌñeen, yo na tyiꞌjndaꞌ nquen, jndue ndëë ntyje joo, yo na jndaꞌ nquen: “ꞌOꞌ sꞌei, quitejndeihoꞌ chjo aceite na conanꞌyꞌonhoꞌ já ngꞌe jndë vanduuꞌ candi na yꞌö́n.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Majoꞌ joo yontcu ntyje joo yo na jndaꞌ nquen, tꞌa yoꞌñeen, jndue joo: “Xeꞌquindëë ngꞌe ntsꞌaahanꞌ na tyiꞌjeꞌcüijndeiꞌhanꞌ na nninjntꞌue nquë́ ndoꞌ mantyi ꞌoꞌ. Yantyichen quitsananꞌjnda nquehoꞌ ꞌnan na nninjntꞌueeꞌhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ndoꞌ viochen xjen na tyenanꞌjnda yontcuꞌñeen aceite, tyjeeꞌnon nquii tsansꞌa na icoco. Yajoꞌ joo yontcu na mꞌancje, tyequeꞌ joo quiiꞌ vꞌaa yo jon na nditꞌmaanꞌ na ngoco jon. Jndë joꞌ tëꞌ ꞌndyo vꞌaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jndë joꞌ vendye yo na tyequijntꞌue aceite, squenon ntcüeꞌ joo. Jnanꞌcꞌuaa joo ꞌndyo vꞌaa. Jndue joo: “Nndaꞌ ta, quitsiquinanꞌ chjo ꞌndyo vꞌaa.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Majoꞌ tꞌa jon jndyue joo: “Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, tyiꞌcüajnꞌan ja ꞌoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ndoꞌ tsontyichen Jesús ndë́: —Mangꞌe na nndaꞌ, cüaaꞌ nꞌonhoꞌ nchu vaa itsiquindyi jñꞌoonvaꞌ na cꞌoncjehoꞌ ngꞌe tyiꞌquindiohoꞌ nin xuee ndoꞌ yuu xjen na ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, nndyö nntꞌa na mꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue, ntsinënntyëchën cüiichen jñꞌoon ndëëhoꞌ na tyiꞌquitso nquiiꞌhanꞌ na tsiꞌmanhanꞌ na ityeꞌntjon jon nnꞌan. Tomꞌaan ncüii tsꞌan na sijndaꞌ jon na ncja jon cüiichen tsonnangue na tycya. Tqueenꞌ jon mosooꞌ jon ndoꞌ tyincyaa jon xoquituꞌ ꞌnaanꞌ jon ndueehan na quintꞌahan tsꞌian yohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nnon cüii joo nanꞌñeen tyincyaa jon ꞌon min sꞌon. Nnon cüiichenhin tyincyaa jon ve min ndoꞌ nnon cüiichenhin ninncüii min tyincyaa jon. Ndëë ncüii cüii nanꞌñeen tyincyaa jon chaꞌxjen na taaꞌ tsꞌon jon na nndëë ntꞌahin tsꞌian. Jndë joꞌ jnduiꞌ jon, tja jon cüiichen tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ndoꞌ juu tsꞌan na tyꞌoon cüenta ꞌon min sꞌonꞌñeen, maquintyjachen totsꞌaa jon tsꞌian yohanꞌ, ndoꞌ tantjonntyichen jon cüiichen ꞌon min. ");
INSERT INTO azgNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ndoꞌ mantyi juu tsꞌan na tyꞌoon cüenta ve min, totsꞌaa juu tsꞌian yohanꞌ ndoꞌ mantyi tantjonntyichen juu cüiichen ve min. ");
INSERT INTO azgNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Majoꞌ juu tsanꞌñeen na tyꞌoon cüenta na ninncüii min sꞌonꞌñeen, tja tsanꞌñeen, taquiꞌñen juu tyuaa, joꞌ tyꞌiu juu sꞌon ꞌnaanꞌ patrónꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Majndye xuee tëcahanꞌ ndoꞌ tyjeeꞌ ntcüeꞌ patrón ꞌnaanhan. Sijndaꞌ jon na ncüjiꞌ jon cüenta yohan nchu xjen tueeꞌ na tantjonhan yo sꞌon ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Joꞌ tyjeeꞌ juu tsanꞌñeen na tyꞌoon ꞌon min sꞌon. Yꞌoon juu sꞌonꞌñeen, mantyi yo cüiichen ꞌon min na tantjon juu yohanꞌ. Tyincyaa juuhanꞌ nnon patrón ꞌnaanꞌ juu. Itso juu: “Nndaꞌ ta, ꞌuꞌ tyincyaꞌ ꞌon min sꞌon nnön. Quindyiaꞌ, ndö cüiichen ꞌon min na jndë tantjön yohanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Sentcüeꞌ patrónꞌñeen jñꞌoon nnon juu: “ꞌUꞌ moso njan, ya saꞌ. Tsiꞌmanhanꞌ na tojooꞌ tsonꞌ ndoꞌ na siquindëꞌ, min veꞌ ncüii tsꞌian chjohanꞌ, majoꞌ ꞌuꞌ siquindëꞌhanꞌ. Nein ncꞌua ja tsꞌian na tꞌmanntyi ndui ꞌuꞌ. Quindyotsijon ꞌuꞌ yo ja juu na mꞌan na nën rö.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jndë joꞌ tyjeeꞌ juu tsanꞌñeen na tyꞌoon cüenta ve min sꞌon. Itso juu: “Nndaꞌ ta, ꞌuꞌ tyincyaꞌ ve min sꞌon nnön. Quindyiaꞌ jeꞌ, ndö cüiichen ve min na jndë tantjön yohanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ndoꞌ sintcüeꞌ patrónꞌñeen jñꞌoon nnon juu: “ꞌUꞌ moso njan, ya saꞌ. Tsiꞌmanhanꞌ na tojooꞌ tsonꞌ ndoꞌ na siquindëꞌ, min veꞌ cüii tsꞌian chjohanꞌ, majoꞌ ꞌuꞌ siquindëꞌhanꞌ. Nein ncꞌua ja tsꞌian na tꞌmanntyi na ndui ꞌuꞌ. Quindyotsijon ꞌuꞌ yo ja juu na mꞌan na nën rö.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Yajoꞌ na matsꞌiañꞌen tyjeeꞌ juu mosoꞌñeen na tyꞌoon ninncüii min. Tso juu nnon patrón ꞌnaanꞌ juu: “Nndaꞌ ta, mantyji na ꞌuꞌ ji quii ꞌndyoꞌ ndëë moso ꞌnanꞌ. Ee ꞌuꞌ veꞌ ꞌnan na coveꞌ ntjon ꞌnaanꞌ ncüiichen tsꞌan, juuhanꞌ matsiveꞌ. Ja nchji ꞌnan na ngüantjön, ꞌuꞌ ncüjiꞌhanꞌ ntꞌö. ");
INSERT INTO azgNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mangꞌe na nndaꞌ, sincyaaꞌhanꞌ ja, joꞌ tyjë, tëquityꞌiu sꞌon ꞌnanꞌ quiiꞌ tyuaa. Ndoꞌ ndö juuhanꞌ, cyonꞌ ntcüeꞌ cüentahanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Tꞌa patrón ꞌnaanꞌ juu: “ꞌUꞌ moso na tyia tsꞌan ꞌuꞌ ndoꞌ na nchquenꞌ. Manchjiꞌ na ja tsꞌan quii ꞌndyo yo ꞌuꞌ ndoꞌ ꞌnan na ngüantjonꞌ, ncüjiꞌhanꞌ ntꞌöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ngꞌe na nndaꞌ tjiꞌ cüenta, ¿Ndu na tatjaꞌ quityiꞌ sꞌon njan banco yuu jon na condive sꞌon ꞌnaan nnꞌan, yajoꞌ ncyꞌön ntcüꞌë sꞌon njan yo maninꞌ jndahanꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ndoꞌ joꞌ tsontyichen patrónꞌñeen ndëë vendye moso ꞌnaanꞌ jon: “Quitjiꞌ ꞌoꞌ ncüii minvaꞌ ntꞌö juu ndoꞌ ncyahoꞌhanꞌ nnon juu tsan na nayꞌoon nqui min. ");
INSERT INTO azgNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ee ntyjantyi na itsixuan ncüii cüii tsꞌan, xe na aa ya tsꞌian itsꞌaa juu yohanꞌ, yajoꞌ ncyꞌoonntyichen juu cüenta na nninjntꞌueeꞌhin. Majoꞌ juu tsꞌan na tyiꞌya tsꞌian itsꞌaa, nnduiꞌñꞌen chjoviꞌ ꞌnan na nayꞌoon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ndoꞌ ntyja ꞌnaanꞌ mosovahin na tayuu jntꞌuehin, quitjueꞌhoꞌhin chꞌen naijon na jaantsueꞌ. Joꞌ ntꞌioo juu ndoꞌ ntcüaꞌ juu ndiꞌnꞌon juu na itsiꞌndaaꞌhanꞌ ntyjii juu.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, nndyo ntcüꞌë nntꞌa yo tsoñꞌen ángeles njan na ntcoꞌxën. Juu xjenꞌñeen nditꞌmaanꞌ ja na ncjöquijman silla na maninꞌ tsꞌiaanꞌ njan na nanncooꞌ quixueehanꞌ naijon na ntyentjön. ");
INSERT INTO azgNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Joꞌ na tonnön ngancüii nnꞌan na nnan ninvaa tsonnangue. Yajoꞌ ncꞌön joohin chaꞌxjen itsꞌaa cüii tsꞌan na mꞌan quinman yo quinchꞌio ntsjuenꞌ na icꞌon juu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ndoꞌ ntsꞌaa jon tmaanꞌ joo quinman ngiaaꞌ jon tontyjaya, ndoꞌ quinchꞌio ntsꞌaa jon tmaanꞌ oꞌ ngiaaꞌ jon tontyjatymaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yajoꞌ ja na condui na matyentjön nnꞌan, ntsjö ndëë nnꞌan na mꞌan ncꞌia ntyjaya: “Ncyohoꞌ ꞌoꞌ nnꞌan na jndë jndahoꞌ na ityio Tyëhöꞌ jnꞌaanhoꞌ. Ncyohoꞌ na ncyꞌonhoꞌ cüenta juu naya na incyaa jon na mantyi ꞌoꞌ nnanꞌjonhoꞌ ntyja ꞌnaanꞌ juu na ityeꞌntjon jon ngꞌe xjen na tquen jon tsonnangue, nndaꞌ vaa na sijndaꞌ jon ntyja ꞌnaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ngꞌe xjen na tomꞌan ja na ninꞌjntꞌö, ꞌoꞌ toninncyahoꞌ ꞌnan na tocüꞌa. Juu xjen tomꞌan na ninꞌcꞌua ndaa ndoꞌ tonincyahoꞌ ndaa na toꞌua. Tomantyꞌi ncüii cüii tsjoonhoꞌ yuu na tataꞌjnꞌaan nnꞌan ja ndoꞌ toyꞌonhoꞌ cüenta ja quiiꞌ ntꞌaahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tomꞌan na totsitjahanꞌ ndiaa na ntcüë ndoꞌ ꞌoꞌ toninncyahoꞌ ndiaa na tocüë, ndoꞌ tomꞌan na vꞌi ndoꞌ ꞌoꞌ totaꞌntyjeeꞌhoꞌ ja. Tomꞌan vancjo ndoꞌ ꞌoꞌ totsaquijntyꞌiahoꞌ ja.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Yajoꞌ nque nanꞌñeen na mꞌan ncꞌia tontyjaya na jndyoyu conduihan na tonnon Tyoꞌtsꞌon, ntꞌahan ꞌndyö, nnduehan: “Nndaꞌ ta, ¿Ndoꞌ cüan tojntyꞌiá ꞌuꞌ na ninꞌjndoꞌ ndoꞌ toninncyá ꞌnan na tocüaꞌ, oo tojntyꞌiá ꞌuꞌ na ninꞌcꞌuaꞌ ndaa ndoꞌ toninncyá ndaa na toꞌuaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Ndoꞌ cüan tojntyꞌiá ꞌuꞌ na tomandyiꞌ quiiꞌ ntꞌan nnꞌan na tyiꞌquitaꞌjnꞌaanhan ꞌuꞌ ndoꞌ toyꞌö́n cüenta ꞌuꞌ quiiꞌ ntꞌá, oo na tojntyꞌiá ꞌuꞌ na itsitjahanꞌ ndiaꞌ ndoꞌ toninncyá ndiaa na tocüeꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Ndoꞌ ncüan tojntyꞌiá ꞌuꞌ na viꞌ oo na tomꞌanꞌ vancjo ndoꞌ totsaquijntyꞌiá ꞌuꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Yajoꞌ ja na condui na matyentjön ntsjö nndëë nanꞌñeen: “Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minninchen nnon ꞌnan tontꞌahoꞌ na totejndeihoꞌ cüii ncüii ntyjëëhë, nanminꞌ na ntyꞌia jndyihin, ntyja njan ja tontꞌahoꞌhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ndë joꞌ ja na taquintyja na tꞌman condui ja na matyentjön nnꞌan, ntsjö nndëë nnꞌan na mꞌan ncꞌia ntyjatymaanꞌ: “Quenaanhoꞌ na tonnön, ꞌoꞌ nnꞌan na jndë tjuꞌviꞌ Tyoꞌtsꞌon ꞌoꞌ. Nanein ngoqueꞌhoꞌ quiiꞌ chon na tyiꞌjon quinduuꞌ, juuhanꞌ sijndaꞌ jon cüentaaꞌ juu yutyia na ntsꞌaaviꞌhanꞌhin yo ángeles ꞌnaanꞌ juu.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ngꞌe tomꞌan na ninꞌjntꞌö, majoꞌ tatyincyahoꞌ ꞌnan ncüꞌa. Tomꞌan na ninꞌcꞌua ndaa, majoꞌ tatyincyahoꞌ ndaa ncꞌua. ");
INSERT INTO azgNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tomantyꞌi ndyuaahoꞌ naijon na tataꞌjnꞌaan nnꞌan ja, majoꞌ ꞌoꞌ tatyꞌonhoꞌ cüenta ja. Tomꞌan na totsitjahanꞌ ndia, majoꞌ tatyincyahoꞌ ndiaa ntcüë. Tomꞌan na vꞌi, majoꞌ tatyequijntyꞌiahoꞌ ja. Toquintyꞌi vancjo, majoꞌ tatyequijntyꞌiahoꞌ ja.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Yajoꞌ joo nanꞌñeen nnanꞌntcüeꞌhan jñꞌoon nnön, nnduehan: “Nndaꞌ ta, ¿Ndoꞌ ncüan tojntyꞌiá ꞌuꞌ na ninꞌjndoꞌ, oo na nincꞌuaꞌ ndaaꞌ, na nintondyiꞌ naijon na tatajnꞌaan nnꞌan ꞌuꞌ, oo na nintꞌonꞌ na totsitjahanꞌ ndiaꞌ, oo na nintiviꞌ, oo na toquindyiꞌ vancjo ndoꞌ tatotejndeí ꞌuꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Yajoꞌ ntsintcüꞌë jñꞌoon ndëë nanꞌñeen: “Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, jnaanꞌ na tatotejndeihoꞌ ntyjë nanminꞌ na ntyꞌia jndyihin, mantyi ntyja njan ja tatontꞌahoꞌhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ndoꞌ ncꞌo nanꞌñeen naijon na tyiꞌjon quintycüii na ntꞌuiiviꞌhanꞌhin. Majoꞌ nque nnꞌan na jndë jnduuꞌ jnanhan na tonnon Tyoꞌtsꞌon, ncyꞌonhan cüenta na tyiꞌjon quintycüii na cotaꞌndoꞌ ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Vi na jndë sinin Jesús tsoñꞌen jñꞌoonminꞌ, tso jon ndë́ na cotsayꞌö́n yo jñꞌoon toninncyaa jon: ");
INSERT INTO azgNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Mangiohoꞌ na ninve xuee vitja ndoꞌ ngueeꞌ nguee pascua. Ndoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, majuu xjenꞌñeen nninncya nnꞌan cüenta ja nduee nnꞌan na njñonhan ja tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Majuu xjenꞌñeen nque ntyee na conditque yo nnꞌan na conditque ndëë nnꞌan judíos, tëncüihan vꞌaa tꞌman vaaꞌ tyee na conintque na jndyu Caifás. ");
INSERT INTO azgNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Jnanꞌjndaꞌhan jñꞌoon yo ntyjehan nchu vaa nntꞌahan na nnanꞌviꞌnnꞌanhan Jesús chaꞌ nntꞌuehan jon, ndoꞌ na nnanꞌcueeꞌhanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Majoꞌ jnduehan ndëë ntyjehan: —Chito ntꞌuëhin xoncüe na mꞌaan nguee, tyiꞌntsꞌaahanꞌ na nnanꞌve nnꞌan cjö. ");
INSERT INTO azgNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tomꞌaan Jesús tsjoon Betania vaaꞌ Simón, tsan na toquichu tycu ndöꞌ cotöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xjenꞌñeen sindyooꞌ ncüii tsanscu na mꞌaan Jesús, yꞌoon juu ncüii tsioo na sia ya tsꞌanhanꞌ yo tsjöꞌ quichiꞌ na jndyu alabastro. Tsiooꞌñeen ñjon nchenꞌ quichi na njon jndyi. Iscongio juu nchenꞌñeen xquen Jesús xjen na vequityen jon mesa. ");
INSERT INTO azgNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndoꞌ já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, ya na jntyꞌiá na nndaꞌ, jnanꞌvjë́. Jnduë́: —Veꞌ jnꞌaan tꞌman tsu nchenꞌvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yantyichen xe na aa jndëë juuhanꞌ. Jndye sꞌon ncüjiꞌhanꞌ na nndui naya nanninñenꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ngꞌe na taaꞌ tsꞌon Jesús na nndaaꞌ conduë́, tso jon ndë́: —¿Ndu na conanꞌntjaanꞌ ꞌoꞌ ntyja ꞌnaanꞌ juu nanꞌvaꞌ na sꞌaa tsanscuva yo ja? Tëquinjonꞌ naya na sꞌaa jon yo ja. ");
INSERT INTO azgNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ngꞌe ja chito ninnquiiꞌchen ncꞌön quiiꞌ ntꞌanhoꞌ, majoꞌ joo nanninñenꞌ, ninnquiiꞌchen mꞌanhan quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Tsanscuva iscongio juu nchenꞌ cjö na itsijndaꞌ juu ntyja ꞌnaanꞌ na ngantyꞌiu ja. ");
INSERT INTO azgNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minyuuchen na ninvaa tsonnangue na nninncya nnꞌan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon, ninnquiiꞌchen nnanꞌneinhan ntyja ꞌnaanꞌ juu naya na sꞌaa tsanscuva, chaꞌ tyiꞌngitsu jñꞌoon ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndoꞌ ncüii nquë́ nnꞌan na nchoꞌve já, juu tsan na jndyu Judas Iscariote, tja jon na mꞌan ntyee na conditque. ");
INSERT INTO azgNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tso jon ndëëhan: —¿Nchu ndyionhoꞌ ja na ninncya cüenta Jesús ndëëhoꞌ? Joꞌ jnanꞌjndaꞌhan, tyincyahan ntcyu nchoꞌnqui sꞌon xuee nnon juu. ");
INSERT INTO azgNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ndoꞌ xjenꞌñeen taꞌ juu, tontꞌue juu nchu ya ntsꞌaa juu na nninncyaa juu cüenta Jesús ndueehan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tueeꞌ xuee na cotyeꞌ nguee na cocüaꞌ nnꞌan judíos tyooꞌ na tatsquentë tëqueeꞌ. Já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa Jesús, jnanꞌndyooꞌ já na mꞌaan jon. Jnduë́ nnon jon: —¿Yuu jon ntꞌue tsonꞌ na ntsananꞌjndáꞌ já ntyja ꞌnaanꞌ nguee pascua, na nninjndaꞌ na ntquiꞌ quitsman? ");
INSERT INTO azgNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tꞌa jon, tso jon ndë́: —Quitsaqueꞌhoꞌ quiiꞌ tsjoon, ndoꞌ quinduehoꞌ nnon ncüii tsꞌan na nndiohoꞌ joꞌ: “Nndaꞌ ta, nquii jon na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndë́, itso jon na jndë vavindyooꞌ na ngenon jon juu naviꞌ tꞌman. Ntꞌue tsꞌon jon na quitejndeiꞌ vaꞌ na ndijndaꞌ na ntcüaꞌ jon, ntquii jon quitsman na ntsitꞌmaanꞌ jon Tyoꞌtsꞌon na ngueeꞌ nguee pascua yo já nnꞌan na cotsayꞌö́n jñꞌoon yohin.” ");
INSERT INTO azgNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ndoꞌ joꞌ jntꞌá chaꞌxjen na tso jon. Jnanꞌjntꞌá na ntcüꞌá cüenta matman ntyja ꞌnaanꞌ juu ngueeꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Xjen na tueeꞌ na tinton chjo, tueeꞌ Jesús vꞌaaꞌñeen. Tacüetyen jon mesa yo ninvaa nchoꞌve já. ");
INSERT INTO azgNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ndoꞌ viochen xjen na tcüꞌá, taꞌ jon, sinin jon ndë́. Tso jon: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, ndyiiꞌ ncüiihoꞌ na nninncyaa juu cüenta ja nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Juu jñꞌoonvaꞌ sichjooꞌ jndyihanꞌ nꞌö́n. Ncüii ro ncüii já tꞌá, taꞌxꞌë́ nnon jon, jnduë́: —Ta, ¿Aa ntsꞌaahanꞌ na ja? ");
INSERT INTO azgNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tꞌa jon jndyuë́, tso jon: —Manquii tsꞌan na ninvixjen ijoon quiiꞌ xio yo ja, majuu juu nninncyaa cüenta ja. ");
INSERT INTO azgNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, mancüixjen ntꞌuiiviꞌhanꞌ ja chaꞌxjen na itsiquindyi juu jñꞌoonꞌ jon na jndui. Majoꞌ juu tsꞌan na nninncyaa cüenta ja nduee nnꞌan, viꞌ jndyi ngenon juu. Yantyichen xe na aa tatuihin. ");
INSERT INTO azgNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yajoꞌ juu Judas, tsan na tyincyaa cüentahin, taxeeꞌ juu, tso juu: —Nndaꞌ ta, ¿Aa ntsꞌaahanꞌ na ja? Tꞌa Jesús ꞌndyo juu: —Aa majoꞌ ro chaꞌxjen na jndë tsuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Viochen xjen na tcüaꞌhan, tyꞌoon Jesús cüenta tyooꞌ, sitꞌmaanꞌ jon Tyoꞌtsꞌon na tyincyaa jon na ncya yahin ntyja ꞌnaanꞌhanꞌ. Jndë joꞌ tyjee jon tanꞌhanꞌ ndoꞌ tyincyaa jonhanꞌ ndë́. Tso jon: —Cyꞌonhoꞌ cüentahanꞌ, cüaꞌhoꞌhanꞌ, juuhanꞌ conduihanꞌ sꞌi. ");
INSERT INTO azgNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jndë joꞌ mantyi tyꞌoon jon cüenta ncüii vaso na ñjon ndaa vinon. Sitꞌmaanꞌ jon Tyoꞌtsꞌon na tyincyaa jon na ncya yahin ntyja ꞌnaanꞌhanꞌ. Tso jon: —Nanꞌva cüehoꞌhanꞌ. Quinanꞌcüenonhoꞌhanꞌ ndëë ntyjeehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Juu ndaa vinonva conduihanꞌ nꞌeön na ntcüeꞌhanꞌ cüenta jndye jndyi nnꞌan chaꞌ nndëë ntsitꞌman tsꞌon Tyoꞌtsꞌonhan jnanhan. Yo juu nꞌeön maquëntyën jñꞌoonxco. ");
INSERT INTO azgNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Matsjö ndëëhoꞌ, xuee na tonnonchen tajeꞌcꞌua nntꞌa ndaa vinon ata vi na jndë tentyja xjen na ityentjon Tyëhöꞌ tsoñꞌen. Yajoꞌ ncꞌua xcöhanꞌ yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Jndë na tá vendye salmos, yajoꞌ jntꞌuí já joꞌ. Sá juu tyoꞌ Olivos. ");
INSERT INTO azgNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Juu xjenꞌñeen itso Jesús ndë́: —Tsjonvahin tsoñꞌenhoꞌ ntjihoꞌ ntyja njan. Ee juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsohanꞌ: “Mancya ja na vanaan na nnanꞌcueeꞌ nnꞌan nquii tsꞌan na vantyjeeꞌ quinman. Ndoꞌ quinman ntsjuenꞌ jon ntycya oꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ndoꞌ tsontyichen jon ndë́: —Majoꞌ xjen na jndë vantꞌö xcö na tꞌiö, ja ncjö jndyëë ndyuaa Galilea. Joꞌ quitsantyjahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ndoꞌ joꞌ tꞌa Pedro ꞌndyo jon, tso juu: —Min xe na aa tsoñꞌen nanminꞌ ntjihin ntyja ꞌnanꞌ, majoꞌ ja tyiꞌjon cüji ja. ");
INSERT INTO azgNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Itso Jesús nnon juu: —Jñꞌoon na mayuuꞌ na matsjö nnonꞌ, tsjonvahin, vitjachen na ntsixuaa quilꞌö, majoꞌ ꞌuꞌ jndë ndye jnda na jndë tji ꞌuꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Majoꞌ sentcüeꞌ Pedro jñꞌoon nnon Jesús: —Min xe na aa ngacjuꞌhanꞌ na cüꞌiö yo ꞌuꞌ, majoꞌ tyiꞌjon cüji ja ntyja ꞌnanꞌ. Ndoꞌ maninjuuntyi jñꞌoon tꞌá tsoñꞌen já na cotsayꞌö́n yo jñꞌoon na toninncyaa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yajoꞌ sá yo Jesús, squë́ naijon min ntjon na jndyu Getsemaní. Tso jon ndë́: —Cꞌuhoꞌ ndöhin viochen xjen na jö ndöꞌ na ntsinën nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yajoꞌ tjantyichen jon, tëyꞌoon jon Pedro yo ve ntsinda Zebedeo. Tyeꞌ na siꞌndaaꞌ jndyihanꞌ ntyjii jon, ndoꞌ na sichjooꞌhanꞌ tsꞌon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tso jon ndëë nanꞌñeen: —Juu ꞌnan na ngenön, itsichjooꞌ jndyihanꞌ tsꞌön, juuhanꞌ vayꞌoonhanꞌ ja na ntscueeꞌhanꞌ ja. Quintjohoꞌ ntjoohin. Cꞌoncjehoꞌ, quinanꞌjonhoꞌ yo ja, chito veꞌ ndahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yajoꞌ tjantyichen jon chjochen. Tëcüangio jon na itsindyiaꞌhin tonnon Tyoꞌtsꞌon. Sꞌaa jon tyꞌoo, tso jon: —ꞌUꞌ Tyeꞌ, xe aa vaa na nndëë ndui, ncyaꞌ na tyiꞌngenön juu naviꞌ tꞌmanva. Majoꞌ min na nndaꞌ macꞌan, quindui chaꞌxjen na ntꞌue tsonꞌ ncuꞌ, chito chaꞌxjen na ntꞌue tsꞌön ja.” ");
INSERT INTO azgNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jndë joꞌ jndyo ntcüeꞌ jon na mꞌan joo ndye nanꞌñeen na conanꞌjonhan yo jñꞌoon na toninncyaa jon. Ntjii jonhan na condahan. Tso jon nnon Pedro: —¿Cüa ndicüiqui nꞌonhoꞌ na veꞌ ninncüii hora na tyiꞌndahoꞌ, na nnanꞌjonhoꞌ yo ja nanꞌneinhoꞌ nnon Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Tsoñꞌenhoꞌ cꞌoncjehoꞌ na quinanꞌneinhoꞌ nnon Tyoꞌtsꞌon chaꞌ ya na va ꞌnan na ityiiꞌhanꞌ ngꞌeehanꞌ ꞌoꞌ, tyiꞌngachuhanꞌ ꞌoꞌ xjen ꞌnaanꞌhanꞌ. Mayuuꞌ ꞌoꞌ mꞌancjehoꞌ na ntꞌahoꞌ chaꞌxjen na icanhanꞌ, majoꞌ ngꞌe na nnꞌanhoꞌ, joꞌ ndiquinanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ndoꞌ tja nndaꞌ jon na jndë ve na ntsininntyichen jon nnon Tyoꞌtsꞌon. Tso jon: —ꞌUꞌ Tyeꞌ, xe na aa tyiꞌjeꞌquindëë na ngüenoonꞌ juu naviꞌ tꞌman na ngenön, tanin, quindui chaꞌxjen na ntꞌue tsonꞌ ncuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jndë joꞌ tueeꞌ nndaꞌ jon na mꞌanhan, ntjii jonhan na conda jndyihan, ee ta jndyi jndë tyꞌoon tsantsjonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yajoꞌ jntyꞌii jonhan, tja nndaꞌ jon na jndë ndye na sinin jon nnon Tyoꞌtsꞌon. Ndoꞌ maninjuuntyi jñꞌoon tcan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tyjeeꞌ nndaꞌ jon na mꞌan nanꞌñeen na totsayꞌonhan jñꞌoon yo jon. Tso jon ndëëhan: —¿Aa ninvaa condahoꞌ ndoꞌ cotaꞌjndyeehoꞌ? Cüa jeꞌ, cꞌoncjehoꞌ, ngꞌe ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, jndë tentyja xjen na quitꞌuiiviꞌhanꞌ ja na ninncyaa tsꞌan cüenta ja nduee nnꞌan na nanꞌxuan jnan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Quinaquintyjahoꞌ, cja, ndö jndë ndyo juu tsꞌan na tancyaa cüenta ja nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ninvaa na itsinin Jesús ndoꞌ nquii Judas, ncüii já nnꞌan na nchoꞌve, tyjeeꞌ juu. Jndyochu juu jndye nnꞌan na conduihan nnꞌan na mꞌan ntyja ꞌnaan ntyee na conintque ndëë nnꞌan judíos, ndoꞌ mantyi yo nnꞌan na mꞌan ntyja ꞌnaan nnꞌan na conintque quiiꞌ tsjoon Jerusalén. Cho nanꞌñeen ncjo espadas yo nonnchꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ndoꞌ Judas, tsan na tyincyaa cüenta Jesús, jndë siꞌman juu ndëëhin nchu vaa na nntsꞌaa juu. Tso juu ndëë nanꞌñeen: “Juu tsꞌan na ncꞌua quinchooꞌ na nninncya tsꞌonhin, majuu tsanꞌñeen na cojntꞌuehoꞌ. Ninñoonꞌ quitꞌuehoꞌhin.” ");
INSERT INTO azgNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ndoꞌ tja jndyoyu juu na mꞌaan Jesús. Tso juu: —¿Aa tijaan ya ꞌuꞌ, ta? Ndoꞌ tꞌu juu quinchooꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tso Jesús nnon juu: —ꞌUꞌ ntyjë, quitsiquindëꞌ tsꞌian na jndyoꞌ. Yajoꞌ jnanꞌndyooꞌ nanꞌñeen nnon Jesús. Tyꞌonhan jon, tꞌuetyenhanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ndoꞌ ncüii já na mꞌán yo Jesús, tjiꞌ juu xjo. Tyjee juu tsöꞌnqui mosooꞌ tyee na conintque. ");
INSERT INTO azgNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ndoꞌ joꞌ tso Jesús nnon juu: —Quityionꞌ ntcüeꞌ xjoꞌhöꞌ tyquiiꞌ tjanvaaꞌhanꞌ. Ngꞌe juu tsꞌan na itsꞌaa natëꞌ yo xjo, mayo juuhanꞌ ngueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Aa tyiꞌcovaaꞌ tsonꞌ na nndëë ntcꞌan nnon Tyëhöꞌ ndoꞌ ninñoonꞌ ncꞌua jon tsꞌian ndëë minchen ntmaanꞌ ángeles na ntejndeihan ja? ");
INSERT INTO azgNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Majoꞌ xe na aa ntsꞌa na nndaꞌ, tyiꞌjeꞌquitsiquindëhanꞌ juu jñꞌoonꞌ jon na jndui na itsiquindyihanꞌ na tsixuan na quenön nanꞌmin. ");
INSERT INTO azgNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Yajoꞌ tso Jesús ndëë tsoñꞌen nanꞌñeen: —¿Ndu na tyincyohoꞌ na ncyꞌonhoꞌ ja yo ncjo espadas ndoꞌ yo nonnchꞌio? Chaꞌvijon na jndyoquijntꞌuehoꞌ tsanchꞌuee. Ja ꞌio ꞌio tovaquityën quityquiiꞌ vatsꞌon tꞌman na totsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndëëhoꞌ, min tatyꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Majoꞌ maquenön tsoñꞌen nanꞌmin chaꞌ joo jñꞌoonꞌ Tyoꞌtsꞌon na toninncya nnꞌan ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa, ntsiquindëñꞌenhanꞌ joohanꞌ. Ndoꞌ juu xjenꞌñeen tsoñꞌen já na conanꞌjö́n yo jñꞌoon na toninncyaa Jesús, jnannö́n, jntyꞌë́hin na ninnquiintyi jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ndoꞌ nque nnꞌan na tyꞌonhan Jesús, tyeyꞌonhan jon vaaꞌ Caifás, nquii tyee na conintque. Joꞌ jndë tëncüi nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, maninꞌ yo nnꞌan na conintque quiiꞌ tsjoon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ndoꞌ nquii Pedro, tycya tycya tëntyja jon toxenꞌ Jesús. Ya na tueeꞌ jon vaaꞌ juu tyee na conintqueꞌñeen, tëqueeꞌ jon tochꞌeenꞌ juu vꞌaaꞌñeen. Joꞌ tëcjo jon quiiꞌ ntꞌan nanntꞌi na cotaꞌntyjeeꞌ vatsꞌon tꞌman, na nndyiaaꞌ jon nchu vaa nquii na nninjndaꞌ ntyja ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ndoꞌ nque ntyee na conintque yo nnꞌan na conintque quiiꞌ tsjoon Jerusalén yo tsoñꞌen minndye nnꞌan na mꞌan nꞌian, tojntꞌuehan nnꞌan na quityjiꞌhan jñꞌoon quintu nacjooꞌ Jesús chaꞌ nndëë nninjndaꞌ jnaanꞌ jon na cueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Majoꞌ min na jndye nnꞌan jnduehan jñꞌoon quintu nacjooꞌ jon na vaa jnaanꞌ jon, majoꞌ jñꞌoonꞌñeen tyíꞌcüiyuuꞌhanꞌ. Jndë joꞌ jnanꞌtjonꞌ ve nanꞌñeen jñꞌoon quintu, jnduehan: ");
INSERT INTO azgNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Juu tsanvaꞌ itso juu na ntsityuiiꞌ juu vatsꞌon tꞌman cüentaaꞌ Tyoꞌtsꞌon. Ndoꞌ ninndye xuee ntsia xco juu ncüiichenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ndoꞌ nquii tyee na conintque, tëcüentyjeeꞌ jon, taxeeꞌ nnon Jesús: —Juu jnanvaꞌ na cotjiꞌ jndyoyu nanminꞌ cjoꞌ, ¿Aa minꞌncüii ꞌndyo jñꞌoon tyiꞌcüꞌaꞌ ntyja ꞌnaanꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Majoꞌ Jesús, minꞌncüii ꞌndyo jñꞌoon tatꞌa jon. Yajoꞌ nquii tyeeꞌñeen tso jon nnon Jesús: —Ngꞌe nquii Tyoꞌtsꞌon na vandoꞌ indyiaaꞌchen jon, joꞌ na macoꞌxën ꞌuꞌ na coꞌtyenꞌ ꞌndyoꞌ na quitsuꞌ jñꞌoon na mayuuꞌ na ndyë́. ꞌUꞌ, ¿Aa condui ꞌuꞌ Mesías jnda Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tꞌa Jesús ꞌndyo jon: —Majoꞌ ro chaꞌxjen jñꞌoon na matsuꞌ. Ndoꞌ mantyi matsiquindyi ꞌoꞌ na ꞌio cha, xuee na vjantyihanꞌ, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, njntyꞌiahoꞌ na mꞌan ntcüꞌë naijon na conditꞌmaanꞌ ja ngiaaꞌ Tyoꞌtsꞌon tontyjaya, nquii jon na tsixuan tsoñꞌen najndei. Ndoꞌ njntyꞌiahoꞌ ja na nnan quiñoonꞌndue na nndyocuë nntꞌa quiiꞌ chincyu. ");
INSERT INTO azgNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ndoꞌ juu tyee na conintqueꞌñeen, jndyiiꞌ jon ndiaaꞌ jon veꞌ ngꞌe quindyaꞌ jndyi nchjii jon. Tso jon: —Tsanva jndë sinin juu jñꞌoon tsanꞌ cjooꞌ nquii Tyoꞌtsꞌon. Min tyiꞌicanntyichenhanꞌ tsꞌan na ncüjiꞌ jndyoyu jñꞌoon nacjooꞌ juu. Nquehoꞌ jndë macondyehoꞌ jñꞌoon tsanꞌ na itsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Nin ꞌnan conanꞌtiuhoꞌ na chuhanꞌ na quitjon juu? Tꞌa nanꞌñeen, jnduehan nnon jon: —Majndaꞌ na chuhanꞌ na cueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ndoꞌ totjueꞌhan ndaajndyuehan nnon jon. Totyiohan ndaꞌhin, ndoꞌ vendyehan totminꞌhan ndaꞌchcya quinchooꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ndoꞌ jnduehan nnon jon: —ꞌUꞌ na matsaꞌ ncuꞌ na condui ꞌuꞌ Mesías na jñon Tyoꞌtsꞌon, cüa, quitsuꞌ nin tsꞌan tminꞌ ndaꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ndoꞌ viochen xjen na condui nanꞌminꞌ, vaquityen Pedro tochꞌen. Ndoꞌ ncüii tsanscu na ityentjon joꞌ, sindyooꞌhin nnon Pedro. Tso juu nnon jon: —ꞌUꞌ mantyi toquiñꞌen ꞌuꞌ yo Jesús, tsan na jnan Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Majoꞌ tjihin tondëë tsoñꞌen nnꞌan na mꞌan joꞌ. Tso jon: —Minꞌchjo tyiꞌquintji ja jñꞌoon na matsuꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jndë joꞌ tja jon naijon na vaa ꞌndyoteon juu vꞌaaꞌñeen ndoꞌ cüiichen tsanscu na mantyi ityentjon joꞌ ntjii juuhin. Tso tsanꞌñeen ndëë nnꞌan na mꞌan ndyo: —Tsanvahin mancüiixjen toquiñꞌenhin yo Jesús tsan na jnan Nazaret. ");
INSERT INTO azgNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Joꞌ cüiichen jon tji Pedro, tcoꞌ jon ꞌndyo jon. Tso jon: —Ntyjii jndaꞌ Tyoꞌtsꞌon na tyiꞌcüajnꞌan ja tsanvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ndoꞌ tyiꞌcovivio xjen ndoꞌ vendye nnꞌan na minntyjeeꞌ joꞌ, tentyjaaꞌhan nnon jon. Jnduehan: —Mayuuꞌ na ꞌuꞌ ncüii nque nnꞌan na conanꞌjon yo tsanvaꞌ, ngꞌe jñꞌoon na matsininꞌ itsiꞌmanhanꞌ na jnanꞌ Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Yajoꞌ taꞌ jon na tjuꞌ nquii jon jñꞌoonviꞌ nacjooꞌ jon. Tso jon na nquii Tyoꞌtsꞌon ntyjii jndaꞌ jon na mayuuꞌ jñꞌoon itsinin juu. Tso juu: —Minꞌchjo tyiꞌcüajnꞌan tsanvaꞌ. Ndoꞌ majuuto xjenꞌñeen sixuaa ro quilꞌö. ");
INSERT INTO azgNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ndoꞌ na nndaꞌ tui, ninñoonꞌ tëñjoonꞌ tsꞌon Pedro juu jñꞌoon na jndë tso Jesús nnon jon: “Vitjachen na ntsixuaa quilꞌö, ndoꞌ ꞌuꞌ jndë ndye jnda tji ꞌuꞌ ntyja njan.” Ndoꞌ jnduiꞌ jon joꞌ. Tꞌioo jndyi jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Vi na jndë tixuee, tsoñꞌen ntyeeꞌñeen yo nnꞌan na conintque quiiꞌ tsjoon Jerusalén, nincüajon tjooꞌ jñꞌoonhan nchu vaa nguaa chaꞌ cueꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jnanꞌtyenhan jon, tyeyꞌonhanhin. Tyencyahan cüentahin ntꞌö Pilato, tsan na condui gobernado juu ndyuaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ndoꞌ juu Judas, tsan na jndëë Jesús ndëë nanꞌñeen, vi na jndë tquen ya juu cüenta na jndë tijndaꞌtyen na cueꞌ Jesús, tyioo na siꞌndaaꞌ jndyihanꞌ ntyjii juu ntyja ꞌnaanꞌ ꞌnan na sꞌaa juu. Joꞌ tëtsintcüeꞌ juu ntcyu nchoꞌnqui sꞌon xueeꞌñeen ndëë ntyee na conintqueꞌñeen yo ndëë nnꞌan na conintque quiiꞌ tsjoon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tso juu ndëëhan: —Minꞌchjo tatëquinjonꞌ sꞌa. Tꞌman jndyi jnan chö na juu tsꞌan na tajnan tsixuan, jndë isquiöhin ndueehoꞌ. Majoꞌ tꞌa nanꞌñeen, jnduehan nnon juu: —Minꞌchjo taꞌnan itsꞌaahanꞌ já. ꞌUꞌ ntyjiꞌ nin ꞌnan saꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Joꞌ tyqueꞌto Judas joo sꞌon xueeꞌñeen quiiꞌ vatsꞌon tꞌman. Mana jnduiꞌ juu joꞌ, tja juu, tëtsintyjahin na iscueeꞌ nquiihin. ");
INSERT INTO azgNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ndoꞌ joo ntyeeꞌñeen jñenꞌ ntcüeꞌhan joo sꞌonꞌñeen. Jnduehan: —Sꞌonmin jndë tyionhanꞌ na cueꞌ tsꞌan. Mangꞌe na nndaꞌ, tyiꞌchuhanꞌ na nnanꞌtjönꞌ ntcüꞌëhanꞌ yo sꞌon na coninncya nnꞌan cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mangꞌe joꞌ tjooꞌ jñꞌoonhan yo ntyjeehan. Jnanꞌquitsuhinhanꞌ na tyionhan cüii tanꞌ tyuaa naijon na min tsꞌoquichu na condëë nguaa. Juu tyuaaꞌñeen, maninꞌtsꞌiaanꞌ na tijntꞌuehinhanꞌ na ngatyꞌiu ntꞌoo, nnꞌan na chito nnꞌan tsjoonhan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mangꞌe na nndaꞌ, ata xee nein juu tyuaaꞌñeen jndyuhanꞌ Tyuaa Neonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ndoꞌ na tyꞌon ntcüeꞌhan juu xoquituꞌñeen, siquindëhanꞌ jñꞌoon ꞌndyo Jeremías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa. Tso tsanꞌñeen: “Nnꞌan Israel jnanꞌjndaꞌhan na ndyionhan ntcyu nchoꞌnqui sꞌon xuee ntyja ꞌnaanꞌ tsꞌan. Jndë joꞌ tyꞌon ntcüeꞌhan cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ndoꞌ yo juuhanꞌ jnanꞌjndahan ncüii tanꞌ tyuaa nnon tsꞌan na itsia juu nguaa chaꞌxjen na tꞌua Tyoꞌtsꞌon tsꞌian nnön na mancüiixjen quindui.” Manndaꞌ jñꞌoon tji Jeremías. ");
INSERT INTO azgNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tyeyꞌonhan Jesús na mꞌaan gobernado Pilato. Taxeeꞌ tsanꞌñeen nnon jon: —¿Aa ꞌuꞌ condui nquii tsꞌan na taquintyja na tꞌman conduihin na coꞌxenꞌ ntyꞌiuꞌ nnꞌan judíos? Tꞌa Jesús, itso jon: —Majoꞌ ro chaꞌxjen na matsuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ndoꞌ nque ntyee na conintque yo nnꞌan na conintque quiiꞌ tsjoon, tyincyahan jnaanꞌ Jesús nnon Pilato. Totquenhan jñꞌoon cjooꞌ jon, majoꞌ minꞌncüii jñꞌoon tatꞌa jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Mangꞌe joꞌ itso Pilato nnon jon: —¿Aa tyiꞌmandyiꞌ jñꞌoon na conanꞌtjaꞌhan nacjoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Majoꞌ minꞌncüii jñꞌoon tatꞌa Jesús ntyja ꞌnaanꞌ jñꞌoon na jnanꞌtjaꞌhan cjooꞌ jon. Ndoꞌ na nndaꞌ, sꞌaahanꞌ na ndicüaaꞌ tsꞌon Pilato ndu na sꞌaa Jesús na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Tyincüii cüii chu, juu xjen na coveeꞌ nguee pascua, tovaa costumbre na nquii gobernado itsiquindyaa jon minꞌcya ro preso na ngitan nnꞌan judíos nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ndoꞌ majuu xjenꞌñeen tomꞌaan ncüii preso na jndyu juu Barrabás, na tꞌman jnaanꞌ juu vaa. ");
INSERT INTO azgNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ndoꞌ juu xjen ya na jndë tencüii nnꞌan tonnon Pilato, taxeeꞌ jon ndëëhan: —Quinduehoꞌ nndyi, ¿Nin juu na ntꞌue nꞌonhoꞌ na quitsiquindya? ¿Aa juu Jesús Barabás, oo aa juu Jesús na condue nnꞌan na conduihin Mesías? ");
INSERT INTO azgNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Nndaꞌ tso Pilato ndëëhan ngꞌe taaꞌ tsꞌon jon na joo ntyeeꞌñeen veꞌ jndohan Jesús, joꞌ na jnanꞌquioohanhin ntꞌö jon, chito aa ngꞌe mayuuꞌ sitjahin. ");
INSERT INTO azgNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ndoꞌ viochen xjen na vequityen Pilato naijon na icoꞌxen jon jñꞌoon, nquii scuuꞌ jon scüenon juu cüii jñꞌoon na mꞌaan jon. Tso juu: “Tyiꞌntyiꞌ ꞌuꞌ xquenꞌ jñꞌoonvaꞌ ee condui tsanvaꞌ tsꞌan na tajnan tsixuan tonnon Tyoꞌtsꞌon. Ee tsjon toncoquiuuꞌ jen vaa jndyi sichju tsantsjon ja ntyja ꞌnaanꞌ jon.” ");
INSERT INTO azgNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Majoꞌ nque ntyee na conintque yo nnꞌan na conintque quiiꞌ tsjoon, tyiꞌhan jndyuehan nnꞌan na quitanhan na quindyaa juu Barrabás, ndoꞌ Jesús jeꞌ, cueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Yajoꞌ nquii Pilato taxeeꞌ nndaꞌ jon ndëë nnꞌan na jndye jndyiꞌhin, tso jon: —Cüa, quinduehoꞌ nnön, ¿Nin ncüii na ve nanminꞌ ntꞌue nꞌonhoꞌ na quitsiquindya? Ndoꞌ joꞌ tꞌahan, jnduehan: —Juu Barrabás, quitsiquindyaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Yajoꞌ ncüiichen jon taxeeꞌ Pilato ndëëhan, tso jon: —Xe na aa nndyaa Barrabás, yajoꞌ ¿Nin ꞌnan quitsꞌa yo Jesús na conduehoꞌ na conduihin Mesías? Tsoñꞌenhan tꞌahan, jnduehan nnon Pilato: —Quijñonꞌhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Yajoꞌ taxeeꞌ nndaꞌ Pilato ndëëhan, tso jon: —¿Nin jnaanꞌ juu vaa na ngiohoꞌ? Majoꞌ jndeintyichen jnanꞌxuaahan, jnduehan: —Quijñonꞌhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ndoꞌ Pilato, vi jndë jndyiaaꞌ jon na ndiquinan jon jndyue nanꞌñeen, ata manndyo na nnanꞌvehan nacjooꞌ jon, joꞌ tcan jon ndaatioo, tman jon ntꞌö jon tondëëhan, tso jon: —Maman ntꞌö chaꞌ cüjiꞌ jndyoyuhanꞌ ndëëhoꞌ na tajnan quichö xe na aa nnanꞌcueeꞌhoꞌ tsanvaꞌ. Ntyja ꞌnaan nquehoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ndoꞌ tsoñꞌen nanꞌñeen tꞌahan, jnduehan: —¿Nin itsꞌaahanꞌ já? Nquë́ chö́ jnan ndoꞌ mantyi ndá ntyja ꞌnaanꞌ na ngueꞌ tsanvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ndoꞌ sꞌaa Pilato chaꞌxjen na tan nanꞌñeen, siquindyaa ntcüeꞌ jon Barrabás. Ndoꞌ tꞌua jon tsꞌian ndëë sondaro ꞌnaanꞌ jon na quitjaꞌhan Jesús. Jndë joꞌ tyincyaa jonhin ndueehan na quijñonhanhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ndoꞌ nque sondaroꞌñeen, tyeyꞌonhan Jesús quityquiiꞌ vatsꞌian. Joꞌ jnanꞌncüihan tsoñꞌen ntyje sondarohin na xiꞌjndio ngiaaꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tjiꞌhan ndiaaꞌ jon ndoꞌ jnanꞌcüehan ncüiichen ndiaahin, ndiaatco colo ve. ");
INSERT INTO azgNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Jndë joꞌ jnanꞌcüetyjohan neon, jntꞌahan tseihanꞌ, tyionhinhanꞌ xquen jon chaꞌvijon corona. Ndoꞌ tyiꞌhan ncüii tsman ntꞌö jon ntyjaya chaꞌvijon tsonjntꞌei ꞌnaanꞌ tsanmꞌaantsꞌian tꞌman. Jndë joꞌ totongityehan tonnon jon na veꞌ toncohin jon. Tonduehan: —ꞌUꞌ tsan na matyentjonꞌ joo nnꞌan judíos, vaa tꞌman condui ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mantyi totjueꞌhan ndaa jndyuehan cjooꞌ jon. Ndoꞌ tjiꞌ ntcüeꞌhan tsman na ndyiiꞌ ntꞌö jon, totueinꞌhinhanꞌ xquen jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Vi na jndë tëcjooꞌchen nꞌonhan na concohan jon, yajoꞌ tjiꞌ ntcüeꞌhan juu ndiaatcoꞌñeen, jnanꞌcüe nndaꞌhan ndiaaꞌ jon, jndë joꞌ tyeyꞌonhan jon na njñonhin jon tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Xjen na tyenduiꞌhan quiiꞌ tsjoon, tjonhin ncüii tsꞌan tsjoon Cirene na jndyu Simón. Yo naijndeiꞌhanꞌ, jntꞌahan na cayꞌoon juu tsonjnꞌaan ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Joꞌ squehan ncüii joo na jndyu Gólgota. Jñꞌoonvaꞌ tsiꞌmanhanꞌ Tyoꞌ Tsiꞌxquen Tsꞌoo. ");
INSERT INTO azgNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Joꞌ tyincyahan vinon na ncꞌu jon na tjonꞌhanꞌ yo ncüii nasi ja. Majoꞌ vi na jndë ntjiiꞌ ꞌndyo jon na tjonꞌ nasiꞌñeenhanꞌ, tatꞌu jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ndoꞌ sondaroꞌñeen jeꞌ, vi na jndë jñonhan jon tsonjnꞌaan, tyꞌehan xꞌiaaꞌ na njntyꞌiahan nin ncüii joohan ndijnoonꞌ ncüii cüii ndiaaꞌ jon. Ndoꞌ na tui na nndaꞌ, siquindëhanꞌ juu jñꞌoon na tji tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa. Itsohanꞌ: “Tyꞌehan xꞌiaaꞌ na njntyꞌiahan nin joohan ndijnoonꞌ ncüii cüii ndia.” Nndaꞌ vaa na tso juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jndë joꞌ tyecüendyuaa sondaroꞌñeen na ntquenhan cüenta Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ndoꞌ tondye xquen Jesús, tꞌionhan tscaaꞌ na chuuꞌ ntji na siꞌmanhanꞌ nin jnaanꞌ jon. Tsohanꞌ: “Ndöhin juu Jesús, tsan na taquintyja na tꞌman conduihin na icoꞌxen jon nnꞌan judíos.” ");
INSERT INTO azgNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mantyi joꞌ jñonhan ve nanntyꞌuee ndëë nonjnꞌaan. Ncüii tsanꞌñeen ñoon juu tsonjnꞌaan na minntyjeeꞌ ngiaaꞌ Jesús tontyjaya. Ndoꞌ ncüiichenhin ñoon juu tsonjnꞌaan na minntyjeeꞌ tontyjatymaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ndoꞌ nnꞌan na tovenon joꞌ, totjueꞌhan jñꞌoonviꞌ cjooꞌ Jesús. Tonanꞌcahan nquenhan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tonduehan: —ꞌUꞌ tsꞌan na matsuꞌ na ntsityuiꞌ vatsꞌon tꞌman ndoꞌ ninndye xuee ntsiaꞌ xcoꞌhanꞌ, cüa jeꞌ, quitsinꞌman nquii ꞌuꞌ. Xe na aa mayuuꞌ condui ꞌuꞌ jnda Tyoꞌtsꞌon, cüa, quindyocueeꞌ tsonjnꞌaanvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ndoꞌ nque ntyee na conintque yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, yo ninꞌnnꞌan na conintque quiiꞌ tsjoon Jerusalén, mantyi manndaꞌ vaa tonanꞌcüejnaanꞌhan Jesús. Tonduehan ndëë ntyjehan: ");
INSERT INTO azgNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Vaa jñꞌoon na totsinꞌman tsanvaꞌ nnꞌan ntyja ꞌnaanꞌ naviꞌ na coquenonhan. Majoꞌ min ndiquindëë ntsinꞌman nquiihin naviꞌ na iquenon juu. Condue nnꞌan na conduihin nquii tsꞌan na taquintyja na tꞌman conduihin na icoꞌxen juu jaa nnꞌan Israel. Xe na aa mayuuꞌ na nndaꞌ, yajoꞌ quindyocue juu na ñoon juu tsonjnꞌaanvaꞌ. Xe na aa ntsꞌaa juu na nndaꞌ, yajoꞌ chi ngantyja nnꞌönhin. ");
INSERT INTO azgNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Tꞌman quii tsꞌon juu Tyoꞌtsꞌon ee tso juu ndëë na nquii juu conduihin Jnda Tyoꞌtsꞌon. Xe na aa mayuuꞌ njonhin ntyjii Tyoꞌtsꞌon, cüa, cüjiꞌ jonhin quiiꞌ naviꞌvahin. ");
INSERT INTO azgNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndoꞌ mantyi nque nanntyꞌueeꞌñeen na ñoon nonjnꞌaan tongiaaꞌ Jesús, manincüajon jnanꞌcüejnaanꞌhin jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Xjen na tueeꞌ yajminꞌ, ninvaa tsonnangue tijaanhanꞌ ata na ndye na matman. ");
INSERT INTO azgNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ndoꞌ chaꞌna ndye na matman jndei sixuaa Jesús, tso jon: “Elí, Elí, ¿Lama sabactani?” Juu jñꞌoonvaꞌ itsiquindyihanꞌ: “ꞌUꞌ Tyoꞌtsꞌon na matsitmanꞌ, ¿Ndu na jndë jntyꞌiꞌ ja?” ");
INSERT INTO azgNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Ndoꞌ vendye nnꞌan na mꞌan ndyo, xjen na jndyehan jñꞌoonminꞌ, jnduehan: —Tsanvaꞌ itsixuaa juu Elías, tsan na tomꞌaan ndyu na toxenꞌchen na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ndoꞌ ncüii tsanꞌñeen jeꞌ, ninñoonꞌ jnannon juu, tëcyꞌoon juu ncüii ꞌnan na nchjaꞌ na ya ncüꞌaahanꞌ ndaa. Nchje juuhanꞌ quiiꞌ vinon të, tyio juuhanꞌ nnon tsman chaꞌ ya ngueeꞌhanꞌ ꞌndyo Jesús na ngitei jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Majoꞌ vendyechen nanꞌñeen jndyuehan: —Quiꞌndyiꞌ. Cüa, njntyꞌiá na aa ncüjeeꞌ Elías na ncüjiꞌ jonhin. ");
INSERT INTO azgNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ndoꞌ jndei sixuaa nndaꞌ Jesús, juu na ndyiiꞌ na vandoꞌ jon, tyincyaa jon cüentahanꞌ, ndoꞌ tueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ndoꞌ majuuto xjenꞌñeen, juu ndiaatco na ntyjatꞌio quityquiiꞌchen vatsꞌon tꞌman, tꞌio ninvaa tcohanꞌ ata xjen nnontyuaachen. Mantyi jndei sꞌii tsonnangue, ndoꞌ tiuu ntjöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mantyi jnaan ndiꞌntꞌua ndoꞌ jndye nnꞌan na jndë tjë na tovantyja nꞌon Tyoꞌtsꞌon, tandoꞌ xcohan. ");
INSERT INTO azgNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ndoꞌ vi na jndë na vandoꞌ xco Jesús, mantyi joo nanꞌñeen jnduiꞌhan quityquiiꞌ ndiꞌntꞌuahan, ndoꞌ tyequeꞌhan quiiꞌ tsjoon Jerusalén. Ndoꞌ jndye nnꞌan jntyꞌiahin nanꞌñeen joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nquii capitán yo sondaro ꞌnaanꞌ jon na cotaꞌntyjeeꞌhan Jesús, xjen na ticjehan na sꞌii ndoꞌ yo tsoñꞌen ꞌnan na tui, tyue jndyihan. Jnduehan ndëë ntyjehan: —Jñꞌoon mayuuꞌ, juu tsanvaꞌ conduihin Jnda Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ndoꞌ jndye nanntcu mꞌan naijon jñon sondaroꞌñeen Jesús tsonjnꞌaan. Joohan veꞌ jntyꞌia tycyahan ꞌnan na tui. Jnanhan ndyuaa Galilea, santyjahan toxenꞌ Jesús na totixeeꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Quiiꞌ ntꞌan nanntcuꞌñeen mꞌaan María, tsan tsjoon Magadán, yo María ndyee Santiago yo José, ndoꞌ mantyi yo juu tsꞌan na condui ndyee ntsinda Zebedeo. ");
INSERT INTO azgNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ndoꞌ tomꞌaan ncüii tsantya na jndyu José, tsꞌan tsjoon Arimateahin. Itsijonhin yo jñꞌoon na toninncyaa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xjen na tueeꞌ na tman juu xueeꞌñeen, tja tsanꞌñeen na mꞌaan Pilato, tëcan jon siꞌtsꞌo ꞌnaanꞌ Jesús. Ndoꞌ Pilato, tꞌua jon tsꞌian ndëë sondaroꞌñeen na nncyahan cüenta juu siꞌtsꞌo ꞌnaanꞌ Jesús ntꞌö juu Joséꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Joꞌ tyꞌoon José cüenta nquii tsꞌoo Jesús. Ndoꞌ ndiaa sábana na ntjuꞌ na jndë yo tsan lino, scüetyjo jonhanꞌ tsoJesús. ");
INSERT INTO azgNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jndë joꞌ tyiiꞌ jon tsꞌooꞌñeen quityquiiꞌ tsiꞌtsꞌua ꞌnaanꞌ nquii jon. Juuhanꞌ tsëꞌtsjöꞌ xcohanꞌ na jndë jnanꞌya nnꞌan. Jndë joꞌ iscuꞌ jon ꞌndyo juu tsiꞌtsꞌuaꞌñeen yo ncüii tsjöꞌ tꞌman. Jndë joꞌ tja jon. ");
INSERT INTO azgNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ndoꞌ juu María, tsan tsjoon Magadán, yo ncüiichen Maríaꞌñeen, jntyꞌiahan na sꞌaa jon na nndaꞌ. Tyecüendyuaahan tonnon juu tsiꞌtsꞌuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xuee na tantyꞌiu Jesús, majuu xuee na conanꞌjndaꞌ nnꞌan judíos ꞌnan na icanhanꞌhin, ngꞌe xuee saroꞌ xuee na cotaꞌjndyeehan. Ndoꞌ juu xuee saroꞌñeen, nque ntyee na conintque yo nnꞌan fariseos, ninncüii tmaanꞌ tyꞌehan na mꞌaan Pilato. ");
INSERT INTO azgNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jnduehan nnon jon: —Nndaꞌ ta, vañjoonꞌ nꞌö́n jñꞌoon na totso tsanquintuꞌñeen xjen na ninvandoꞌ juu. Tso juu xuee jndë ndye ngüandoꞌ xco juu na tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Mangꞌe joꞌ ntꞌue nꞌö́n na cꞌuaꞌ tsꞌian na cꞌo sondaro ꞌnanꞌ, na ngoquitquenhan cüenta tsiꞌtsꞌua ꞌnaanꞌ tsanꞌñeen ata xjen na jndë tenon ndye xuee. Tja ndoꞌ ntsꞌaahanꞌ na joo nnꞌan na cotsayꞌon yo jñꞌoon na toninncyaa juu, ntsquehan ndoꞌ ntyꞌueehan siꞌtsꞌo ꞌnaanꞌ juu, ndoꞌ nnduehan ndëë nnꞌan na jndë vandoꞌ xco juu. Ndoꞌ quintuvaꞌ tꞌmanntyichen ntsiviꞌnnꞌanhanꞌ nnꞌan, chito jñꞌoon na toninncyaa juu xjen na tovandoꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tꞌa Pilato, tso jon ndëëhan: —Sondaromin mancya na nninjntꞌuehoꞌ. Cüa, cꞌohoꞌ yohan. Ya ya quitaꞌntyjeeꞌhoꞌ juu tsiꞌtsꞌuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ndoꞌ joꞌ jnduiꞌhan. Tyequitëꞌtyenhinhanꞌ. Tꞌionhan sello xoncüe na ntjon ꞌndyo tsëꞌtsjöꞌ yo tsjöꞌ tꞌman chaꞌ ntsiꞌmanhanꞌ xe na aa ntsiquinaan tsꞌanhanꞌ. Jndë joꞌ jntyꞌehan sondaroꞌñeen na quitquenhan cüenta juu tsiꞌtsꞌuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jndë tenon xuee saroꞌñeen na cotaꞌjndyee nnꞌan judíos ndoꞌ jndë tavixuee xuee nuincoꞌ, xee na vejndyee soana. Juu xjenꞌñeen, tja María tsan tsjoon Magadán yo ncüiichen Maríaꞌñeen, tyequijntyꞌiahan juu tsiꞌtsꞌua. ");
INSERT INTO azgNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Ndoꞌ jndei jndë sꞌii ngꞌe ncüii ángel cüentaaꞌ Tyoꞌtsꞌon jnan jon quiñoonꞌndue, jndyocue jon naijon vaa juu tsiꞌtsꞌuaꞌñeen. Tendyaaꞌ jon tsjöꞌ na tëꞌ ꞌndyohanꞌ, tëcjo jon cjooꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ninvaañꞌenhin quixuee chaꞌvijon chontsuee. Ndoꞌ quichiꞌ ndiaaꞌ jon chaꞌvijon tein quichiꞌ jndyi. ");
INSERT INTO azgNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ndoꞌ joo sondaroꞌñeen na totquenhin cüenta tsiꞌtsꞌuaꞌñeen, ya na jntyꞌiahan juu ángelꞌñeen, toviquijntyꞌehan na ncyaahan, tycyaahan tyuaa chaꞌvijon ntꞌoo. ");
INSERT INTO azgNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ndoꞌ juu ángelꞌñeen, sinin jon ndëë nanntcuꞌñeen, tso jon: —Tyiꞌntyuehoꞌ. Ja mantyji na juu Jesús cojntꞌuehoꞌ, manquii jon na jñon nnꞌanhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Tacꞌoonhin ntjoohin ngꞌe jndë vandoꞌ xco jon na tueꞌ jon, chaꞌxjen jñꞌoon na totso jon. Quindyoquijntyꞌiahoꞌ naijon na tquen nnꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ndë joꞌ quinanꞌcjehoꞌ na quitsananꞌquindyiihoꞌ nnꞌan na cotsayꞌon yo jñꞌoon na toninncyaa jon, na jndë vandoꞌ xco jon na tueꞌ jon. Ndoꞌ quinduehoꞌ ndëëhan na juu jon vjajndyee ndyuaa Galilea, ndë joꞌ jntyꞌiahoꞌhin. Ndö vaa jñꞌoon na jndyoquitsjö ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yajoꞌ quintyja quintyja jnduiꞌ ntcüeꞌ nanntcuꞌñeen naijon na vaa juu tsiꞌtsꞌuaꞌñeen. Tyue jndyihan ndoꞌ neinhan. Jnanꞌnonhan na tyenanꞌquindyiihan nque nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús na nndaꞌ vaa ꞌnan na tso juu ángelꞌñeen ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ndoꞌ ninjonto nquii Jesús tjon jon joohan. Tso jon ndëëhan: —¿Aa tonco ya ꞌoꞌ? Toquityehan nnon jon, tꞌuehan quityoꞌ ngꞌee jon na jnanꞌtꞌmaanꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ndoꞌ tso jon ndëëhan: —Tyiꞌndyuehoꞌ. Cüa, cꞌohoꞌ, quitsananꞌquindyiihoꞌ joo ntyjë na cotsayꞌonhan yo jñꞌoon na toninncya, na cꞌohan ndyuaa Galilea, joꞌ njntyꞌiahan ja. ");
INSERT INTO azgNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Viochen xjen na tyꞌe joo nanntcuꞌñeen, ve ndye sondaroꞌñeen na totquen cüenta juu tsiꞌtsꞌuaꞌñeen, tyequeꞌ ntcüeꞌhan Jerusalén, tyenanꞌquindyiihan ntyee na conintque tsoñꞌen ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ndoꞌ joo ntyeeꞌñeen tetjonhan yo joo nnꞌan na conintque quiiꞌ tsjoonꞌñeen. Ndoꞌ jnanꞌtjonꞌhan jñꞌoon yo nanꞌñeen, maya xoquituꞌ tyincyahan ndëë sondaroꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ndoꞌ jnduehan ndëë nanꞌñeen: —Quinduehoꞌ ndëë nnꞌan na nque nnꞌan na cotsayꞌon jñꞌoon yo Jesús, natsjon squehan. Ndoꞌ xjen na jndahoꞌ, tequitjiꞌhan siꞌtsꞌo ꞌnaanꞌ juu quiiꞌ tsiꞌtsꞌuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Minꞌchjo jñꞌoontiu tyiꞌncꞌonhoꞌ, taꞌnan ntquenonhoꞌ. Ee xe na aa ncüaaꞌ tsꞌon gobernado juu jñꞌoonvaꞌ, nquë́ ngiö́ nchu vaa ntꞌa chaꞌ na tyiꞌntꞌuiihanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ndoꞌ tyꞌon sondaroꞌñeen cüenta xoquituꞌñeen. Taꞌhan tonanꞌcyahan jñꞌoon chaꞌxjen na jndue ntyeeꞌñeen na quinduehan. Veꞌ ngꞌe joꞌ, ata xjen nein conanꞌnein nnꞌan judíos na nque nnꞌan na totsayꞌonhan jñꞌoon yo Jesús, tyequintyꞌueehan juu siꞌtsꞌo ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ndoꞌ nquë́ na nqui nchoꞌncüii já sá Galilea, naijon na mꞌaan juu tyoꞌ na siquindyi Jesús na ngitsá. ");
INSERT INTO azgNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ndoꞌ xjen na jntyꞌiáhin, tonanꞌtꞌmánꞌhin. Majoꞌ ñꞌen vendye ntyjë́ na ve vaa na tomꞌaanꞌ nꞌonhan na aa mayuuꞌ na juu jon. ");
INSERT INTO azgNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yajoꞌ sindyooꞌ Jesús na tondë́. Tso jon: —Nquii Tyoꞌtsꞌon jndë tyincyaa jon na vaa najndö na condui ja na coꞌxën tsoñꞌen na mꞌaan quiñoonꞌndue yo nnon tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Mangꞌe na nndaꞌ, cꞌohoꞌ na mꞌan nnꞌan ncüii cüii tyuaa na ninvaa tsonnangue. Nninncyahoꞌ juu jñꞌoon naya ndëëhan chaꞌ ngantyja nꞌonhan ja. Quinanꞌquindëëꞌhoꞌhan yo xueeꞌ Tyëhöꞌ yo xuë na condui ja Jnda nquii jon, ndoꞌ yo xueeꞌ nquii Espíritu Santo. ");
INSERT INTO azgNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Quinanꞌmanhoꞌ ndëë nanꞌñeen na quitaꞌngueeꞌhan tsoñꞌen jñꞌoon na jndë tquën ndëëhoꞌ. Ndoꞌ cañjoonꞌ nꞌonhoꞌ ninvito na mꞌan ja yohoꞌ ata xjen na ntycüii tsonnangue, tyiꞌxeꞌquiꞌndyi ja ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ndö cotyeꞌ juu jñꞌoon naya ntyja ꞌnaanꞌ Jesucristo na conduihin jnda Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Chaꞌxjen juu jñꞌoon na chuuꞌ nnon juu tson na tji Isaías, tsan na totsinin jñꞌoon ntyja ꞌnaanꞌ nchu vaa ꞌnan na nguaa. Chaꞌvijon nquii Tyoꞌtsꞌon itsinin jon nnon jnda jon Jesucristo. Itso jon: Quenꞌ cüenta, na tonnonꞌ majñön nquii tsꞌan na nninncyaa jñꞌoon ntyja njan. Juu jon ntsijndaꞌ nato na ncjaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Juu tsanꞌñeen nninncyaa jñꞌoon ndëë nnꞌan na ngancüihan ndyuaa naijon tyiꞌjndye nnꞌan mꞌan. Ngitso jon: “Quinanꞌjndaꞌhoꞌ juu nato na nndyo nquii tsꞌan na conduihin na coꞌxen jon nnꞌan. Quinanꞌquinaanhoꞌ nato jndyoyu na ncja jon.” Manndaꞌ itsiquindyi juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Chaꞌxjen na itso Tyoꞌtsꞌon na ncüjeeꞌ tsꞌan na ninncyaa jñꞌoonꞌ jon, juu Juan tyjeeꞌ jon ndyuaa naijon tyiꞌjndye nnꞌan mꞌan. Toninncyaa jon jñꞌoon na quintꞌë nnꞌan, chaꞌ quitsiꞌmanhanꞌ na contcüeꞌ nꞌonhan jnan nanꞌxuanhan na ntsitꞌman tsꞌon Tyoꞌtsꞌon jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nnꞌan na mꞌan ninvaa ndyuaa Judea jnduiꞌhan na toꞌohan naijon tomꞌaan juu Juanꞌñeen. Mantyi ñꞌen nnꞌan tsjoon Jerusalén, jnduiꞌhan, tyꞌehan naijon na tomꞌaan jon. Ndoꞌ vi na jndë tjiꞌ jndyoyuhan jnanhan, yajoꞌ ncüii ro cüiihan siquindëëꞌ Juanꞌñeen joohan quiiꞌ ndaa jndaa Jordán. ");
INSERT INTO azgNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ndoꞌ ndiaa na tocüe tsanꞌñeen jndëhanꞌ yo sooꞌ camello, ndoꞌ tsiaaꞌ jon toquityen tjan, ndoꞌ tocüaꞌ jon quintcandyueꞌ, ndoꞌ toꞌu jon tsionꞌ quintyꞌi jndëë. ");
INSERT INTO azgNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndoꞌ toninncyaa jon jñꞌoon ndëë nanꞌñeen, totso jon: —Na toxꞌën ndyontyja ncüii tsꞌan na tꞌmanntyichen conduihin, chichen ja. Min tyiꞌquinjon ja na veꞌ na ngüangiö na ntsiquinꞌan tjan na tyen ntcoonꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ja matsiquintꞌëhoꞌ yo ndaatioo, majoꞌ juu jon ntsiquindëëꞌ jon ꞌoꞌ yo nquii Espíritu Santo.” Nndaꞌ jñꞌoon tyincyaa juu Juanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ndoꞌ juu xjenꞌñeen jnan Jesús tsjoon Nazaret ndyuaa Galilea. Tueeꞌ jon naijon mꞌaan juu Juanꞌñeen jndaa Jordán, ndoꞌ joꞌ siquindëëꞌ jon juu Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ndoꞌ juu xjen na jnduiꞌ Jesús quityquiiꞌ juu jndaaꞌñeen, jndyiaaꞌ jon na jnaan tsjöꞌndue naijon na mꞌaan nquii Tyoꞌtsꞌon. Juu xjenꞌñeen tityincyooꞌ Espíritu Santo, chaꞌvijon ncüii quituꞌ, jndyocue jon nacjooꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ndoꞌ ticꞌuaa ncüii jndye na tondye tsjöꞌndue na sinin nquii Tyoꞌtsꞌon, itso jon: —ꞌUꞌ condui ꞌuꞌ jnda. Tꞌman vaa na viꞌntyji ꞌuꞌ ndoꞌ nën jndyi ꞌUꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ndoꞌ majuuntyi xjenꞌñeen sꞌaa Espíritu Santo na cja Jesús ndyuaa na tyiꞌjndye nnꞌan mꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ndoꞌ joꞌ tomꞌaan jon vennꞌan xuee. Ndoꞌ juu yutyia totsichon yantyi juu na quityiiꞌhanꞌ ngꞌeehanꞌ Jesús na quitsitjahin nnon nquii Tyoꞌtsꞌon. Ndoꞌ tomꞌaan Jesús quiiꞌ ntꞌan quiooꞌ ncyaa. Ndoꞌ majuuto xjenꞌñeen, nque ángeles na cotyentjon nnon Tyoꞌtsꞌon squehan na tixeeꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ndoꞌ vi na jndë tyꞌon nanmꞌannꞌian juu Juanꞌñeen na tyiꞌhan jon vancjo, yajoꞌ jnduiꞌ Jesús juu ndyuaaꞌñeen, tja ntcüeꞌ jon ndyuaa Galilea. Ndoꞌ joꞌ toninncyaa jon jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Totso jon: —Juu xjen na ninncya nnꞌan na nquii Tyoꞌtsꞌon ntyeꞌntjon jonhan ntyja ꞌnaanꞌ na cotsamꞌanhan, jndë tueeꞌ xjenhanꞌ. Ngꞌe joꞌ quintcüeꞌ nꞌonhoꞌ jnanhoꞌ, ndoꞌ cantyja nꞌonhoꞌ juu jñꞌoon naya ꞌnaanꞌ jon.” ");
INSERT INTO azgNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ndoꞌ viochen xjen na venon Jesús ꞌndyo ndaandue Galilea, jndyiaaꞌ jon tsan na jndyu Simón. Ijuꞌ tsanꞌñeen tsquiꞌtsan quityquiiꞌ ndaandueꞌñeen yo tyje jon na jndyu Andrés, ngꞌe ninnquiiꞌ juu tsꞌian na contꞌahan na cotjiꞌhan quintcaa. ");
INSERT INTO azgNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Tꞌman Jesús joohan, tso jon ndëëhan: —Quindyonanꞌjonhoꞌ yo ja ndoꞌ ja ntsꞌa na nnanꞌtjonhoꞌ nnꞌan ntyja ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ndoꞌ joohan ninñoonꞌ jntyꞌehan ntquiꞌtsan ꞌnaanhan, tyenanꞌjonhan yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ndoꞌ tjantyi jon chjochen. Joꞌ jndyiaaꞌ jon Jacobo yo tyje juu Juan, tyehan jndyu Zebedeo. Mꞌanhan quityquiiꞌ vꞌaandaa ꞌnaanhan na cotaꞌyahan ntquiꞌtsan ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ndoꞌ majoꞌntyi ninñoonꞌ tꞌman Jesús joohan. Ndoꞌ juu tyehan jntyꞌehan jon quityquiiꞌ juu vꞌaandaaꞌñeen yo ninꞌmoso ꞌnaanhan, joꞌ tyenanꞌjonhan yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ndoꞌ joꞌ squehan tsjoon Capernaum. Juu xjen na tueeꞌ xuee na cotaꞌjndyee nnꞌan judíos, taqueeꞌ Jesús vatsꞌon ꞌnaan nanꞌñeen. Taꞌ jon na siꞌman jon ndëë nnꞌan na tëncüi joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Majoꞌ jñꞌoon na tyincyaa jon, ndicueeꞌ na ncüaaꞌ nꞌonhan juuhanꞌ ngꞌe siꞌman jon chaꞌxjen ncüii tsꞌan na tsixuan na iquen xjen, ngꞌe joo jñꞌoon na siꞌman jon njonntyichenhanꞌ, tachi chaꞌxjen joo jñꞌoon na concya nque nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen nquii Moisés. ");
INSERT INTO azgNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ndoꞌ quiiꞌ ntꞌan nnꞌan na tëncüi juu vatsꞌonꞌñeen, joꞌ mꞌaan ncüii tsꞌan na tsixuan juu jndyetyia. Juu jndyetyiaꞌñeen, sꞌaahanꞌ na jndei sixuaa tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Itso juu: —ꞌUꞌ Jesús na jnanꞌ tsjoon Nazaret, ¿Nin tsꞌian na matyiiꞌ ꞌuꞌ yo ntyja nján? ¿Aa jndyoꞌ na ntsiquitsuꞌ já? Ja mavaaꞌ ya tsꞌön nin condui ꞌuꞌ. Ja ntyji na condui ꞌuꞌ ñuan nquiiꞌ na jnanꞌ na mꞌaan nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Majoꞌ juu Jesús, sityiaꞌ jon juu jndyetyiaꞌñeen. Itso jon nnon juu: —Machen ꞌndyoꞌ, quinduiꞌ tyquiiꞌ tsꞌon tsanvahin. ");
INSERT INTO azgNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ndoꞌ juu xjen na jnduiꞌ juu jndyetyiaꞌñeen, sꞌaahanꞌ na tueꞌquiso tsanꞌñeen ndoꞌ jndei sixuaa juu. ");
INSERT INTO azgNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ndoꞌ joo nanꞌñeen na jntyꞌiahan na tui na nndaꞌ, vacue mꞌaanꞌ nꞌonhan. Ndoꞌ joꞌ totaꞌxeeꞌhan ndëë ntyjehan, jnduehan: —Joo jñꞌoon na incyaa tsanvaꞌ, ¿Nin tsiquindyihanꞌ? Ee joo jñꞌoonꞌñeen tyiꞌcüajonhanꞌ yo jñꞌoon na condyëë na conanꞌman nnꞌan ndëë. Ee juu jon ata iquen jon xjen joo yotyiahinꞌ ndoꞌ cotaꞌngueeꞌhanꞌ jñꞌoon na icoꞌxen jon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ngꞌe na ndöꞌ vaa na sꞌaa Jesús, joꞌ tsoñꞌen nnꞌan na mꞌan ndyuaa Galilea, quintyja quintyja tonanꞌneinhan ndëë ntyjehan ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ndoꞌ xjen na jnan Jesús juu vatsꞌonꞌñeen, juu Jacobo yo ninꞌJuan, jnanꞌjonhan yohin, tyꞌehan vaaꞌ Simón yo tyje juu na jndyu Andrés. ");
INSERT INTO azgNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ndoꞌ juu tsanscu xeenꞌ Simón, vaa juu cjooꞌ jndu na iyꞌoon tjuenꞌhin. Joꞌ jnduehan nnon Jesús na viiꞌ juu tsanscuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ndoꞌ nquii Jesús, sindyooꞌhin nnon tsanꞌñeen, tꞌuii jon vi ntyjaaꞌ ntꞌö juu, sue jonhin na vaa juu cjooꞌ jnduꞌñeen. Ndoꞌ majuuntyi xjenꞌñeen jndya tjuenꞌhin. Joꞌ jnanꞌquintyja juu, taꞌ juu, sijndaꞌ juu ꞌnan na tcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ndoꞌ vi na jndë tua ndoꞌcüjioonꞌ, nque nnꞌan na mꞌan juu tsjoonꞌñeen jndyochohan tsoñꞌen ntyjehan nnꞌan na vꞌi. Mantyi yo nnꞌan na mꞌaan jndyetyia quityquiiꞌ nꞌon na quitsinꞌman Jesús joohan. ");
INSERT INTO azgNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ndoꞌ nnꞌan juu tsjoonꞌñeen, tsoñꞌenhan tëncüihan ꞌndyo juu vꞌaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ndoꞌ jndye nnꞌan na jndye nnon ntycu na cotjonhan, sinꞌman Jesús joohan. Ndoꞌ mantyi nnꞌan na nanꞌxuan jndyetyia na ñꞌenhan joꞌ, tjiꞌ jon jndyetyiaꞌñeen quiiꞌ nꞌonhan, min tyíꞌncyaa jon na nanꞌnein jndyetyiaꞌñeen ngꞌe mangio jndaꞌhan nin condui jon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Vitjachen na nonnco ncüiichen xuee, ninvaa jaanchen jnanquintyja Jesús, jnduiꞌ jon juu vꞌaaꞌñeen. Tja jon ncüii joo naijon na tannꞌan cꞌoon na ntsinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Majoꞌ juu Simón yo ntyje juu, tentyjahan naxenꞌ Jesús na cojntꞌuehan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ndoꞌ xjen na jndiohanhin, jnduehan nnon jon: —Tsoñꞌen nnꞌan cojntꞌuehan ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Majoꞌ tꞌa Jesús jndyuehan, itso jon: —Cja ncꞌö mañoon njoon na ndyo ndyo chaꞌ mantyi nndëë nninncya jñꞌoonꞌ Tyoꞌtsꞌon ndëë nanꞌñeen, ngꞌe majuu tsꞌian na jndyö. ");
INSERT INTO azgNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Joꞌ tomandyiꞌ Jesús njoon ndyuaa Galilea. Toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon quiiꞌ ntꞌaanꞌon ꞌnaan nnꞌan judíos joo njoonꞌñeen. Ndoꞌ quiiꞌ ntꞌan nque nnꞌan njoonꞌñeen, ñꞌen nnꞌan na nanꞌxuanhan jndyetyia. Joꞌ tjiꞌ jonhanꞌ quiiꞌ nꞌon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ndoꞌ ncüii tsꞌan na chu ndöꞌ cotöꞌ, tyjeeꞌnon juu na mꞌaan Jesús. Tcoꞌxtye tsanꞌñeen tonnon jon. Tcan juu vi nayaꞌñeen, tso juu: —Nndaꞌ ta, xe na aa ntꞌue tsonꞌ, ndëë ntsinꞌmanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Tyꞌoon Jesús na ndyiaꞌ ro tsanꞌñeen nchjii jon, tyio jon ntꞌö jon cjooꞌ juu. Tso jon: —Manndaꞌ ntꞌue tsꞌön, cꞌonꞌ na jndë jnꞌmanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ndoꞌ xjen na tso jon na nndaꞌ, majuuntyi xjenꞌñeen jnꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Ndoꞌ siquiꞌmaanꞌ Jesús tsanꞌñeen, tso jon: —Minꞌncüii nnon tsꞌan tyiꞌntsuꞌ yo ꞌnan na sꞌa ꞌuꞌ. Majoꞌ nanein cjaꞌ na mꞌaan juu tyee cüenta jaa nnꞌan judíos. Ndoꞌ juu quiooꞌ na itso nquii Moisés na ninncya nnꞌan na jndë jnꞌman, ncyaꞌ oꞌ nnon juu tyeeꞌñeen chaꞌ quitsiꞌmanhanꞌ ndëë nnꞌan na jndë ntjo ya ntcüeꞌ ꞌuꞌ ꞌnan na toquenoonꞌ. Nndaꞌ jñꞌoon siquiꞌmaanꞌ Jesús tsanꞌñeen. Jndë joꞌ jñon jonhin na cja juu. ");
INSERT INTO azgNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Majoꞌ juu tsanꞌñeen, jnduiꞌ juu. Ndoꞌ nato na tja juu, ndoꞌvanjan totsiquindyi juu nnꞌan nchu vaa ꞌnan na tjon juu. Ndoꞌ ngꞌe na nndaꞌ sꞌaa juu, iscuꞌhanꞌ na ngaqueeꞌ Jesús quityquiiꞌ njoonꞌñeen. Tsojnaanꞌ joꞌ, tomꞌaan jon quiiꞌ jndëë, ndoꞌ nnꞌan na tonan ncüii cüii tsjoon, majndyehan totsquehan na mꞌaan jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jndëcya vendye xuee, ndoꞌ tyjeeꞌ ntcüeꞌ Jesús tsjoon Capernaumꞌñeen. Ndoꞌ ticꞌuaa jñꞌoon na jndë mꞌaan nndaꞌ jon vꞌaa na mancüiixjen tocüjeeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ndoꞌ jndye jndyi nnꞌan na tëncüi joꞌ. Ndoꞌ juu vꞌaaꞌñeen tooꞌchenhanꞌ mꞌan nnꞌan, min tandicüinon mañoon ntyjehan quityquiiꞌhanꞌ. Ndoꞌ tyincyaa Jesús jñꞌoonꞌ Tyoꞌtsꞌon ndëë nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndoꞌ juu xjenꞌñeen squenon ninnque caꞌ nnꞌan, yꞌonhan ncüii tsanviiꞌ na ntjein ngꞌee. ");
INSERT INTO azgNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ndoꞌ tsojnaanꞌ na jndye jndyi nnꞌan na mꞌanhanꞌ, joꞌ na ndiquindëë na ntsquehan yo juu tsanꞌñeen naijon mꞌaan Jesús. Ngꞌe na nndaꞌ, tyevahan cjooꞌ vꞌaaꞌñeen, jnanꞌcjohan tsueꞌ xquenhanꞌ, ndoꞌ joꞌ jnanꞌcüenonhan juu tsanviiꞌñeen naijon na mꞌaan Jesús na ninvaa vaa juu cjooꞌ tsueꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ndoꞌ nquii Jesús, vi na jndë jndyiaaꞌ jon na vantyja nꞌon nanꞌñeen jon, itso jon nnon juu tsanviiꞌñeen: —ꞌUꞌ jnda, ja matsitꞌman tsꞌön ꞌuꞌ tsoñꞌen jnan tsixuanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ndoꞌ joꞌ mꞌan vendye nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen nquii Moisés. Xjen na jndye nanꞌñeen juu jñꞌoonꞌñeen na tso Jesús, jnanꞌtiuhan quiiꞌ nꞌonhan: ");
INSERT INTO azgNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Ndu na ndöꞌ vaa jñꞌoon na itsinin tsanvahin? Jñꞌoon na itsinin juu, itscüejnaanꞌhanꞌ Tyoꞌtsꞌon na ijuꞌcjehanꞌhin. Ee taꞌnan tsꞌan nndëë ntsitꞌman tsꞌon jnan na nanꞌxuan nnꞌan, xiaꞌntyi nquii Tyoꞌtsꞌon condëë itsꞌaa jonhanꞌ.” Ndöꞌ vaa jñꞌoon na jndue nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ndoꞌ nquii Jesús, taaꞌ tsꞌon jon na nndaꞌ vaa na conanꞌtiuhan nacjooꞌ jon. Joꞌ taxeeꞌ jon ndëëhan: —¿Ndu na ndöꞌ vaa na cotjiꞌhoꞌ cüenta? ");
INSERT INTO azgNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Nin tsꞌan nchjito na aa ngꞌe ntyja ꞌnaanꞌ jñꞌoon na matsjö, joꞌ condui ja na ntsitꞌman tsꞌön tsꞌan na tsixuan jnan? Majoꞌ xe na aa ntsjö nnon tsanvahin na quinanquintyja juu, ndoꞌ quitsintcüii juu tsueeꞌ juu, cja juu vaaꞌ juu, yajoꞌ ntsiꞌmanhanꞌ ndëëhoꞌ na majoꞌ condui ja. ");
INSERT INTO azgNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Majoꞌ chaꞌ quitsiꞌman nquiihanꞌ ndëëhoꞌ na condui ja tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, na mayuuꞌ tsixuan na ntsitꞌman tsꞌön nnꞌan jnan na nanꞌxuanhan, yajoꞌ tso jon nnon tsanviiꞌñeen: ");
INSERT INTO azgNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—ꞌUꞌ ntyjë matsjö nnonꞌ, quinanquintyjaꞌ, quitsintcüiꞌ tsueꞌ, ndë cjaꞌ vaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ndoꞌ jnanquintyja tsanꞌñeen, sue juu tsueeꞌ juu, jnduiꞌ juu quiiꞌ ntꞌan nanꞌñeen. Ndoꞌ joohan, vacue tomꞌaanꞌ nꞌonhan na tui na nndaꞌ, ndoꞌ mantyi tyincyaahanꞌ na neinhan. Taꞌhan tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. Jnduehan: —Nquii Tyoꞌtsꞌon, vaa tꞌman conduihin. Minꞌjon tacojntyꞌia na ndui ncüii nnon ꞌnan chaꞌxjen juu ꞌnan na tui naneinhin. ");
INSERT INTO azgNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ndë joꞌ tja ntcüeꞌ Jesús ꞌndyo ndaandue Galilea. Joꞌ squenon ncüii tmaanꞌ nnꞌan na mꞌaan jon. Ndoꞌ joꞌ tyeꞌ tyincyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndëë nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Jndë joꞌ tja nndaꞌ jon juu tsjoon Capernaum. Ndoꞌ viochen xjen na venon jon joꞌ, jndyiaaꞌ jon tsan na jndyu Leví, jnda Alfeo. Vaquityen juu mesa na ique juu sꞌon cüentaaꞌ tsanmꞌaantsꞌian tꞌman tsjoon Roma. Itso Jesús nnon Levíꞌñeen: —Quindyotsijon ꞌuꞌ yo jñꞌoon na mancya. Ndoꞌ joꞌ jnanquintyja juu, tëtsijonhin yo jon. ");
INSERT INTO azgNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ndoꞌ juu Levíꞌñeen, tꞌman juu Jesús na chi ncja jon vaaꞌ juu yo nnꞌan na cotsayꞌon yo jñꞌoon na toninncyaa jon na ntcüaꞌhan. Ndoꞌ joꞌ ñꞌen vendye nnꞌan na majoꞌntyi cotyehan sꞌon cüentaaꞌ tsanmꞌaantsꞌian tꞌman tsjoon Roma, ndoꞌ mantyi yo nnꞌan na tyiꞌquinanꞌjñꞌoonꞌ nchu vaa itsiquindyi jñꞌoon na tquen nquii Moisés. Ee jndye jndyi nnꞌan cotsantyja naxenꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ndoꞌ majoꞌntyi mꞌan nnꞌan na tonanꞌman nchu vaa itsiquindyi juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui ndyu na toxenꞌchen. Joo nanꞌñeen totsayꞌonhan yo jñꞌoon na toninncya nnꞌan tmaanꞌ na jndyu fariseos. Totquenchen nanꞌñeen cüenta na tcüaꞌ Jesús yo joo nanꞌñeen na totye sꞌon ndoꞌ mantyi yo nnꞌan na tyiꞌquinanꞌjñꞌoonꞌhin nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés. Ndoꞌ ngꞌe na nndaꞌ, taꞌxeeꞌhan ndëë nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa Jesús, jnduehan ndëë nanꞌñeen: —Cüa juu tsꞌan na itsiꞌman ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndëëhoꞌ, icüaꞌ jon ndoꞌ iꞌu jon yo nanminꞌ. Tyiꞌquichuhanꞌ na itsꞌaa jon na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Ndoꞌ juu Jesús, jndyii jon na jndue nanꞌñeen na nndaꞌ. Joꞌ itso jon ndëëhan: —Itsijonhanꞌ ja chaꞌna ncüii ndoto. Juu tsanꞌñeen, tachi nnꞌan yꞌa na vancyaa jon nasi. Juu jon nnꞌan vꞌi vaquindyiaaꞌ jon. Ja chito jndyö na ntcꞌën nnꞌan na conduehan na nquehan na ya nnꞌanhan na quitsayꞌonhan yo juu jñꞌoon na mancya. Ja jndyö na macꞌën nnꞌan na covaaꞌ nꞌonhan na nanꞌxuanhan jnan tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Juan, juu tsan na totsiquindëëꞌ nnꞌan, sque nanꞌñeen na mꞌaan Jesús, mantyi yo ninꞌnnꞌan fariseos. Joo nanꞌñeen cotyjehan ꞌnan jndyuehan chaꞌ quitjiꞌ nnꞌan cüenta na jen conanꞌquindëhan na tonnon Tyoꞌtsꞌon. Ndoꞌ joꞌ jnduehan nnon Jesús na joohin na conanꞌjonhan yo juu jñꞌoon na toninncyaa Juanꞌñeen, cotyjehin ꞌnan jndyuehin, ndoꞌ maninꞌ cüajon contꞌa nnꞌan na nanꞌxuan tmaanꞌ fariseos. Ndoꞌ taxeeꞌ nanꞌñeen nnon Jesús ndu na nque nnꞌan cotsayꞌon yo jñꞌoon na incyaa jon, tyiꞌquityjehan ꞌnan jndyuehan. ");
INSERT INTO azgNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Joꞌ tꞌa Jesús, sinin jon jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ndëëhan: —Joo nnꞌan na conanꞌjonhan juu xjen na ngoco tsansꞌandyua, ¿Aa chuhanꞌ na ntyjehan ꞌnan jndyuehan? Minꞌchjo tyiꞌquichuhanꞌ na ntꞌahan na nnda. Aa chi majndeichen jndyechen ntcüaꞌhan ngꞌe nein jndyihan na coco ntyjehan tsanꞌñeen yo juu yu na ndiscuuꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Majoꞌ mangüentyja xjen na ntjiꞌ nnꞌan nquii ntyjehan tsansꞌaꞌñeen na coco, joꞌ juu xjenꞌñeen joo nnꞌan na conanꞌjon yo juu, ntyjehan ꞌnan jndyuehan. Manndaꞌ itsijonhanꞌ ntyja njan, ngüentyja xjen na ntjiꞌ nnꞌan ja, ndoꞌ juu xjenꞌñeen nque nnꞌan na cotsayꞌonhan jñꞌoon yo ja ntyjehan ꞌnan jndyuehan ");
INSERT INTO azgNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Ndoꞌ mantyi juu ndiaa xco na tyiꞌcotman, min tyiꞌquichuhanꞌ na ncüjaaꞌ tsꞌanhanꞌ ndiaa ntsa ee xe na aa ntsꞌaa tsꞌan na nndaꞌ, yajoꞌ ngatihanꞌ, ndoꞌ na nndaꞌ, ncꞌiooꞌhanꞌ juu ndiaa ntsaꞌñeen, ndoꞌ juu naijon na tꞌiooꞌ ndiaaꞌñeen matꞌmanntyichen na ntꞌiooꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Min tyiꞌquityion tsꞌan ndaa vinon xco tyquiiꞌ ntjan na jndë tindyo, ngꞌe xe na aa ntsꞌaa tsꞌan na nndaꞌ, ndoꞌ juu vinon xcoꞌñeen, ya na ntsiquindeihanꞌ, yajoꞌ joo ntjanꞌñeen ntꞌiooꞌhanꞌ. Ndoꞌ na ndui na nndaꞌ, veꞌ jnꞌaan na tsu juu vinon yo juu ntjanꞌñeen. Ndoꞌ ngꞌe joꞌ, chuhanꞌ na quityion tsꞌan vinon xco ntjan xco. ");
INSERT INTO azgNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ncüii xuee na cotajndyee nnꞌan judíos, nquii Jesús yo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, tenonhan ncꞌuii nato naijon min ntjon ꞌnaan nnꞌan. Ndoꞌ nque nanꞌñeen na conanꞌjonhan juu jñꞌoon na incyaa jon, taꞌhan cotyjehan xjuꞌ ntquen trigo. ");
INSERT INTO azgNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ndoꞌ joo nnꞌan tmaanꞌ fariseos, vi na tquenhan cüenta na contꞌa nanꞌñeen na nndaꞌ, yajoꞌ jnanꞌjndyehan jndyuehan nnon Jesús. Jnduehan nnon jon: —Juu jñꞌoon ns tquen Moisés iquenhanꞌ xjen na tyiꞌntꞌa jaa tsꞌian juu xee na cotaꞌjndyëëhë. Majoꞌ quenꞌ yaꞌ cüenta na joo nnꞌan na cotsayꞌonhan yo juu jñꞌoon na mancya, tyiꞌquintꞌahan na njon juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ndoꞌ tꞌa Jesús jndyuehan, tso jon: —ꞌOꞌ, ¿Aa minꞌjon tyíꞌconanꞌjnꞌaanhoꞌ juu jñꞌoon na itsiquindyihanꞌ ntyja ꞌnaanꞌ ꞌnan na sꞌaa nquii David juu xjen na sitjahanꞌ ꞌnan na ntcüaꞌ jon? Juu xjenꞌñeen tꞌoon jon na ninꞌjndoꞌ jon yo ninꞌnnꞌan na totsayꞌonhan jñꞌoon yo jon. ");
INSERT INTO azgNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Juu xjenꞌñeen taqueeꞌ jon vatsꞌon ꞌnaanꞌ Tyoꞌtsꞌon. Juu ndyuꞌñeen nquii tsan na jndyu Abiatar, juu jon conduihin tyee tque ntyja njanhan nnꞌan judíos. Ndoꞌ juu David jeꞌ, tcan jon ꞌnan na ntcüaꞌhan nnon juu Abiatarꞌñeen. Ndoꞌ mantyi tyincyaa tsanꞌñeen tyooꞌ na jndë tquen nnꞌanhanꞌ cüentaaꞌ nquii Tyoꞌtson. Ndoꞌ tcüaꞌ David juu tyooꞌñeen ndoꞌ majoꞌntyi nque nnꞌan na totsayꞌon jñꞌoon yohin. Ndoꞌ juu tyooꞌñeen. chito veꞌ minꞌcya ro tsꞌan na ndëë na ntcüaꞌhanꞌ. Xiaꞌntyi nque ntyeeꞌñeen vanaan na ntcüaꞌhinhanꞌ. Majoꞌ min na nndaꞌ sꞌaa David, taꞌnan tso Tyoꞌtsꞌon na sitjahin. ");
INSERT INTO azgNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ndoꞌ itsontyichen Jesús ndëë joo fariseosꞌñeen: —Nquii Tyoꞌtsꞌon tquen jon xuee na cotaꞌjndyee nnꞌan chaꞌ quitejndeihanꞌ joohan, chito tquen jon nnꞌan na veꞌ quintꞌahan na njonchen juu xueeꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ngꞌe joꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën nnꞌan, condui ja na quën xjen nchu vaa ꞌnan na quintꞌa nnꞌan juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ndoꞌ taqueeꞌ nndaꞌ Jesús ncüii vatsꞌon cüenta nnꞌan judíos. Joꞌ tomꞌaan ncüii tsansꞌa na tatei vi ntyjaaꞌ ntꞌö juu. ");
INSERT INTO azgNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ndoꞌ nnꞌan tmaanꞌ fariseos yo ntyjehan nnꞌan judíos na mꞌan joꞌ, cotquenchenhan cüenta xe na aa ntsinꞌman jon juu tsanꞌñeen xee na cotaꞌjndyeehin. Ndoꞌ xe na aa ntsꞌaa jon na nndaꞌ, yajoꞌ ntꞌahan jnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ndoꞌ tso Jesús nnon tsanꞌñeen, tsan na tatei ntꞌöꞌhin: —Quinanquintyjaꞌ, quindyoꞌ ntjoohin tondëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ndoꞌ taxeeꞌ Jesús ndëë nanꞌñeen, tso jon: —Juu jñꞌoonꞌ Tyoꞌtsꞌon na icoꞌxenhanꞌ, ¿Aa incyaahanꞌ na vanaan na ntejndei tsꞌan cüiichen ntyje juu juu xuee na cotaꞌjndyëëhë, oo aa quiꞌndyii juu na quitjon tsanꞌñeen naviꞌ? Oo ¿Aa chuhanꞌ na quitsinꞌman tsꞌanhin min na aa juu xuee na cotaꞌjndyëëhë chaꞌ tyiꞌngueꞌ juu? Ndoꞌ ¿Aa quiꞌndyiito tsꞌan na cueꞌ nquii juu veꞌ ngꞌe na tsijonhanꞌ juu xeeꞌñeen? Ndoꞌ joꞌ, chen tui jndyue nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ndoꞌ na nndaꞌ, jndyiaaꞌ Jesús xiꞌjndio ndëë nanꞌñeen, quindyaꞌ ntyjii jon ntyja ꞌnaanhin ndoꞌ mantyi chjooꞌ jndyi tsꞌon jon ngꞌe tyiꞌninꞌquindyehan. Yajoꞌ tso jon nnon juu tsanviiꞌñeen: —Juu ntꞌöꞌ tontyja viꞌ, quitsindiuꞌhanꞌ. Ndoꞌ sindiuu juu ntꞌö juu, ndoꞌ majuuntyi xjenꞌñeen ntjo ya ntcüeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Majoꞌ nque nnꞌan fariseosꞌñeen, taꞌhan na jnanꞌtjonꞌhan yo joo nnꞌan tmaanꞌ cüentaaꞌ Herodes. Jnanꞌjndaꞌhan yo nanꞌñeen nchu vaa nquii ntꞌahan chaꞌ cueꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ndoꞌ joꞌ jnduiꞌ Jesús yo nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, tyꞌehan ndaandue. Ndoꞌ joꞌ nnꞌan na jndye jndyiꞌhin tentyjahan naxenꞌ jon. Joo nanꞌñeen jnanhan ndyuaa Galilea, ");
INSERT INTO azgNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judea, tsjoon Jerusalén ndoꞌ mantyi ndyuaa Idumea, ndoꞌ ñꞌen nnꞌan na jnan ncüiichen ixndya jndaa Jordán, ndoꞌ ñꞌen mañoon nnꞌan na jnan ndyo juu tsjoon Tiro yo Sidón. Jndë tondye nanꞌñeen tsoñꞌen ꞌnan na totsꞌaa jon, joꞌ squenonhan na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ndoꞌ tso Jesús ndëë nnꞌan na totsayꞌon yo juu jñꞌoon na toninncyaa jon na quinanꞌjndaꞌhan ncüii vꞌaandaa na ngua jon, chaꞌ tyiꞌngaquintoꞌ nnꞌan na jndye jndyiꞌhin na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ndöꞌ tso jon ngꞌe jndye jndyi nnꞌan na sinꞌman jon, ndoꞌ tsoñꞌen nnꞌan vꞌi, tonanꞌchonhan na ninꞌquitsaquiñoonhan jon chaꞌ nndëë nꞌmanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ndoꞌ joo nnꞌan na nanꞌxuan jndyetyia, minꞌcya ro xjen na jntyꞌiahan Jesús, joo jndyetyiaꞌñeen tontꞌahanꞌ na totoꞌquitye nanꞌñeen nnon jon, ndoꞌ jntꞌahanꞌ na jndei tonanꞌxuaa nanꞌñeen. Jnduehan: —ꞌUꞌ condui ꞌuꞌ jnda Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ndoꞌ yo na jndeiꞌhanꞌ tso jon ndëë joo jndyetyiaꞌñeen na tavinduehan nin condui jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Yajoꞌ tava Jesús ncüii tyoꞌ. Joꞌ tqueenꞌ jon nnꞌan na jndë sitiu jon na ya ntejndeihan jon. Ndoꞌ squenon nanꞌñeen na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ndoꞌ quiiꞌ ntꞌan joo nanꞌñeen, tji jon nchoꞌve tsꞌan, tꞌua jon tsꞌian ndëëhan na quinanꞌjonhan yo jon na njñon jonhan na ntsancyahan juu jñꞌoon naya ꞌnaanꞌ jon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ndoꞌ maninjuu najndei na condui nquii jon, tyincyaa jon na quinanꞌxuanhinhanꞌ chaꞌ ndëë nnanꞌnꞌmanhan nnꞌan vꞌi ndoꞌ chaꞌ mantyi ndëë ntjiꞌhan jndyetyia quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nque nnꞌan na tji jon na tꞌua jon tsꞌianꞌñeen ndëëhan na quitejndeihan jon, ndö ngueehan: Simón, xueeꞌ juu na vja ve siquijndyu Jesús juu Pedro, ");
INSERT INTO azgNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo yo Juan, joohan ntsinda Zebedeo, ngueehan na jndë ve siquijndyu Jesús joohan Boanerges. Jñꞌoonvahin tsiꞌmanhanꞌ jaaꞌ jñꞌoon jndyuehan ya na conanꞌneinhan jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo jnda Alfeo, Tadeo, Simón tsan na totsijonhin yo juu tmaanꞌ nnꞌan na jndyuhanꞌ cananista, ");
INSERT INTO azgNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Yo ninꞌJudas Iscariote, tsan na jndëcya tyincyaa juu cüenta Jesús nduee nnꞌan na jndohan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ndoꞌ vi jndë joꞌ, tjaqueeꞌ Jesús ncüii vꞌaa yo nanꞌñeen na jndë tji jon. Ndoꞌ cüiichen jnda tëncüi nndaꞌ ncüii tmaanꞌ nnꞌan na mꞌaan jon, ndoꞌ ngꞌe joꞌ min na ndincyaahanꞌ xjen na ntcüaꞌ jon yo nanꞌñeen na totsayꞌonhan jñꞌoon yo jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Ndoꞌ joo nnꞌan na ntyje nquii Jesús, vi na jndë jndyehan na nndaꞌ vaa, yajoꞌ saquitjiꞌhan jon quiiꞌ ntꞌan nanꞌñeen, ngꞌe jnduehan tꞌman vaa tsiꞌndaaꞌhanꞌ xquen jon. ");
INSERT INTO azgNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Tsjoon Jerusalén jnan nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen nquii Moisés. Tonanꞌcüejnaanꞌhan Jesús tondëë nnꞌan. Tonduehan: —Juu Beelzebú, nquii yutyia na conintque tondëë yotyia, ntyja ꞌnaanꞌ juu jon, joꞌ vaa najndei na tsixuan tsanvahin. Joꞌ na condëë icüjiꞌ juu yotyia quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tsojnaanꞌ na jndue nanꞌñeen na nndaꞌ, joꞌ tꞌman Jesús joohan na quinanꞌndyooꞌchenhan na mꞌaan jon. Yajoꞌ sinin jon jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ndëëhan chaꞌ quitsiꞌmanhanꞌ na veꞌ cochue nꞌon nanꞌñeen. Tso jon: —Nquii yutyia Satanás, tyiꞌjeꞌcüjiꞌ nquii juu ntyje juu na mꞌanhan quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nque nnꞌan na conintque ncüii ndyuaa, xe na aa cotꞌon nquehan ntyjehan yo ꞌnan na contꞌahan, tajeꞌquintjontyichenhan na cotoxenhan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ndoꞌ majoꞌntyi nnꞌan na mꞌan cüii vꞌaa, xe na aa cotꞌon nquehan ntyjehan yo ꞌnan na contꞌahan, matajeꞌquintjo yahan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ndoꞌ majuuntyi xjen ntyja ꞌnaanꞌ Satanás, xe na aa itsue nquiihin nacjo ntyje yotyia juu, ntycüii na icoꞌxen juu quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Ndoꞌ mantyi cüii tsꞌan na vaa najndei na nachu juu ntꞌö tsꞌian tyiaꞌ, ya iquen juu cüenta vaaꞌ juu, ndoꞌ ꞌnaanꞌ juu na min, tanin ꞌnan ntjonhanꞌ. Majoꞌ xe na aa ngaqueeꞌ ncüiichen tsꞌan na vantyichen najndei, chichen nquii juu, yajoꞌ juu tsanꞌñeen ntsityen jonhin ndoꞌ ncüjiꞌ jon ꞌnaanꞌ juu, ndoꞌ nninncyaa jonhanꞌ ndëë nnꞌan na cotsayꞌon jñꞌoon yohin. ");
INSERT INTO azgNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tsoñꞌen nnon na conanꞌtja nnꞌan nnon Tyoꞌtsꞌon yo joo jñꞌoon viꞌ na conanꞌneinhan nacjooꞌ jon, nndëë ntsitꞌman tsꞌon jonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Majoꞌ minꞌninchen tsꞌan na itso na matsꞌa tsꞌian yo ntyja ꞌnaanꞌ juu najndei na tsixuan juu yutyia Satanás, nacjooꞌ nquii Espíritu Santo itsinin tsanꞌñeen jñꞌoon viꞌ, joꞌ tajeꞌquindyaahin yo juu jnanꞌñeen, tajeꞌquitsitꞌman tsꞌon Tyoꞌtsꞌonhin.” ");
INSERT INTO azgNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ndöꞌ jñꞌoon na itso Jesús ngꞌe jndue nanꞌñeen na ntyja ꞌnaanꞌ nquii yutyia, joꞌ itsꞌaa jon joo tsꞌianꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Juu xjenꞌñeen tyjeeꞌ ndyee Jesús yo ntyje jon na mꞌaan jon, veꞌ chꞌen ntjohin. Joꞌ jnduehan ndëë nnꞌan na mꞌan joꞌ, quinanꞌquindyii nanꞌñeen jon na jndë squehan. ");
INSERT INTO azgNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ndoꞌ joo nanꞌñeen jnduehan nnon jon: —Nndaꞌ ta, chꞌen mꞌaan ꞌndyoꞌhöꞌ yo ntyꞌiuꞌhinꞌ, cojntꞌuehan ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ndoꞌ joꞌ tꞌa jon jndyue nanꞌñeen, tso jon: —¿Nin nnꞌan na conduihin ndyö yo ntyjö ncö? ");
INSERT INTO azgNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Yajoꞌ jndyiaaꞌ jon xiꞌjndio ndëë nnꞌan na vendyuaa ngiaaꞌ jon. Itso jon: —Joo nanmin conduihin ndyö yo ntyjö ncö. ");
INSERT INTO azgNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ngꞌe minꞌcya ro tsꞌan na itsꞌaa juu ꞌnan na ntꞌue tsꞌon nquii Tyoꞌtsꞌon, juu tsanꞌñeen condui tyjö tsansꞌa yo tyjö tsanscu yo ndyö. ");
INSERT INTO azgNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ndoꞌ ncüiichen jnda, xjen na tꞌoon Jesús ꞌndyo ndaandue Galileaꞌñeen, taꞌ jon na tyincyaa jon jñꞌoon ndëë nnꞌan. Jndye jndyi nnꞌan tëncüi naijon na mꞌaan jon joꞌ. Ndoꞌ joꞌ tua jon quityquiiꞌ ncüii vꞌaandaa na ntyjachenhanꞌ nnon ndaa. Tëcüetyen jon tyquiiꞌhanꞌ ndoꞌ joo nanꞌñeen mꞌanhan ꞌndyo tsꞌoteiꞌ ndaandue. ");
INSERT INTO azgNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jndye jndyi nnon jñꞌoon na tyiꞌquitsiquindyi nquiiꞌhanꞌ na siꞌman jonhanꞌ ndëëhan. Ndö jñꞌoon na tso jon xjen na siꞌman jon ndëëhan: ");
INSERT INTO azgNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Quindyehoꞌ jñꞌoon na ntsinën. Mꞌaan ncüii tsꞌan na taquitscyaa juu tsjan ntquen trigo. ");
INSERT INTO azgNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ndoꞌ viochen xjen na iscyaa jon juu ntquenꞌñeen, ñꞌenhanꞌ na tycyaa xoncüe nato. Ndoꞌ joꞌ sque quintsa, tquii oꞌ joo ntquenꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ndoꞌ minndyehanꞌ tycyaahanꞌ cjooꞌ chjo tsꞌo na ntyjo cjooꞌ ntjöꞌ. Ndoꞌ cje ro tꞌonhanꞌ ngꞌe ñjen mꞌaan tsꞌo joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Majoꞌ xjen na jnduiꞌ ndoꞌcüjioonꞌ, yajoꞌ tyeꞌ coꞌuaahanꞌ, tsojnaanꞌ na ñjen mꞌaan tsꞌoꞌñeen, joꞌ ndicꞌo nchꞌiooꞌhanꞌ, joꞌ na tcanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ndoꞌ minndyechenhanꞌ tycyaahanꞌ tyuaa naijon na minntyjeeꞌ nꞌoon neon. Ndoꞌ joo neonꞌñeen tëvindyehanꞌ, sincüanꞌhanꞌ cjo joo ntjonꞌñeen, joꞌ na tatueꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ñdoꞌ mantyi minndyechenhanꞌ tycyaahanꞌ naijon na mꞌaan tsꞌo ya. Tꞌon joo ntquenꞌñeen, tëquehanꞌ, juu ntjonꞌñeen ya tueꞌhanꞌ. Ñꞌenhanꞌ na tyincyaahanꞌ ncüii xu vantjoꞌ yon stjö na cüii stjöhanꞌ na iscyaa tsanꞌñeen, ndoꞌ minndyechenhanꞌ tyincyaahanꞌ ata ve xu xoncüe na ncüii istjöhanꞌ na iscyaa juu tsanꞌñeen, ndoꞌ mantyi minndyechenhanꞌ tyincyaahanꞌ ata ninque xu na ncüii istjöhanꞌ na iscyaa juu.” ");
INSERT INTO azgNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ndoꞌ tsontyichen Jesús: —Juu tsꞌan na ninꞌcüaaꞌ tsꞌon jñꞌoon na matsjö, quen ya juu cüentahanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Joo nanꞌñeen na jndye jndyiꞌhin, vi na jndë jnduiꞌhan, yajoꞌ nnꞌan na nchoꞌveꞌhin, taxeeꞌhan nnon Jesús, jnduehan: —Juu jñꞌoon na sininꞌ quichen na tyiꞌquitso nquiiꞌhanꞌ, ¿Nin ꞌnan ninꞌquitsiquindyihanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ndoꞌ tꞌa jon jndyuehan, tso jon: —Ndyu na toxenꞌchen taꞌnan siꞌman Tyoꞌtsꞌon ndëë nnꞌan jñꞌoon na vantyꞌiu na mꞌaanhanꞌ nchu vaa na icoꞌxen jon nnꞌan. Majoꞌ ndëë ꞌoꞌ itsiꞌman jndyoyu jon ntyja ꞌnaanꞌhanꞌ. Ndoꞌ nque nnꞌan na tyiꞌcꞌonhan ntyja njan, joo jñꞌoon na mancya ndëëhan ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan juu na cotsamꞌanhan, ninnquiiꞌchen matsinën jñꞌoon ndëëhan na tyiꞌquitsjö ncꞌihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Nndaꞌ vaa chaꞌ min jndye jnda quindyehan, majoꞌ xeꞌcüaaꞌ nꞌonhan nin ꞌnan itsiquindyihanꞌ. Ndoꞌ min na jndye jnda cojntyꞌiahan ꞌnan na matsꞌa, majoꞌ jeꞌquitquenhan cüenta. Ndoꞌ na ndöꞌ vaa na nanꞌxuanhan, ndicachuhanꞌhin na ntcüeꞌ nꞌonhan yo jnanhan ndoꞌ na ntsitꞌman tsꞌon Tyoꞌtsꞌonhan.” ");
INSERT INTO azgNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ndoꞌ taxeeꞌ Jesús ndëë nnꞌan nchoꞌveꞌhin, tso jon: —Ndoꞌ na tataaꞌ nꞌonhoꞌ juu jñꞌoonvaꞌ na tyiꞌquitsjö ncꞌihanꞌ, yajoꞌ ¿Nchu ya ntꞌahoꞌ na ncüaaꞌ ya nꞌonhoꞌ xe na aa ntsinën mañoon jñꞌoon chaꞌna juuhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Juu tsꞌan na itscyaa ntquen trigoꞌñeen, conduihin nquii tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ndoꞌ joo ntquen na tycyaa nato na tquii quintsahanꞌ, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon. Ndoꞌ vi na jndë jndyehinhanꞌ, juu xjenꞌñeen icüjeeꞌ yutyia na mꞌanhan, ndoꞌ itsꞌaa juu na quitsuuꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ndoꞌ ntquen na tycyaa naijon na jen ntjöꞌ na ñjen mꞌaan tsꞌo, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon, joohan coyꞌonhan cüentahanꞌ yo na nein jndyihan. ");
INSERT INTO azgNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Majoꞌ tyiꞌxoncüeeꞌ nꞌonhan na covantyja nꞌonhan juu jñꞌoonꞌñeen, ndoꞌ veꞌ ngꞌe viꞌ coquenonhan na conanꞌvje nnꞌanhan, ndoꞌ conanꞌcüejnaanꞌ nnꞌanhan na ninꞌquitjihan quityquiiꞌ na tsixuan juu tsonnangue, yajoꞌ coꞌndyehan juu jñꞌoonꞌ Tyoꞌtsꞌon, cotsacüentyjeeꞌhan na covantyja nꞌonhan juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ndoꞌ joo ntquen na tycyaa naijon na minntyjeeꞌ nꞌoon neon, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Majoꞌ jnaanꞌ na jndye jndyi mꞌaanꞌ nꞌonhan yo ꞌnan na icanhanꞌhin nanein, yo na itsiviꞌnnꞌanhanꞌhin na ninꞌcüityahan, yo jndyechen nnon ꞌnan na ninꞌcuen ndueehan, ndoꞌ ngꞌe na nndaꞌ vaa mꞌaanꞌ nꞌonhan, taꞌnan cüii nnon na itsiꞌmanhanꞌ na conanꞌjonhan yo juu jñꞌoon nayaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Majoꞌ mꞌan nnꞌan na itsijonhanꞌhin chaꞌna juu ntquen trigo na iscyaa tsanꞌñeen naijon na mꞌaan tsꞌo ya. Condye nanꞌñeen juu jñꞌoonꞌ Tyoꞌtsꞌon, ndoꞌ conaꞌquii nꞌonhan juuhanꞌ. Ndoꞌ joꞌ itsijonhanꞌhin chaꞌna joo ntjon na ya coveꞌ. Chaꞌxjen vendye ntjonꞌñeen ya tueꞌhanꞌ, tyincyaahanꞌ ncüii xu vantjoꞌ yon istjö, ve xu xoncüe ndoꞌ ata ninque xu. Mantyi mꞌan nnꞌan na nndaꞌ vaa na conanꞌjonhan yo jñꞌoonꞌ Tyoꞌtsꞌon, ndyiiꞌhan jndye tsꞌian contꞌahan ntyja ꞌnaanꞌ nquii jon, ndoꞌ ñꞌenhan na chjo ro contꞌahin ntyja ꞌnaanꞌ jon, ndoꞌ ñꞌenhan na majndyentyichen na contꞌahan.” ");
INSERT INTO azgNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mantyi sininntyichen Jesús ncüiichen jñꞌoon ndëëhan, na tyiꞌquitso nquiiꞌhanꞌ. Tso jon: —Taꞌnan tsꞌan na ntscüꞌa lámpara na veꞌ na ntcoꞌto juuhanꞌ na tocjeeꞌ jndu, oo min na ntscuꞌ juuhanꞌ yo stjö. Chito nndaꞌ ntsꞌaa tsꞌan. Juu lámparaꞌñeen ntsintyja tsꞌanhanꞌ chaꞌ quitsixueehanꞌ chon ndëë tsoñꞌen nnꞌan na mꞌan vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Minꞌcya ro jñꞌoon na matsinën na ndicüaaꞌ nꞌon nnꞌan na tyiꞌquitsjö ncꞌihanꞌ, majoꞌ ngüentyja xjen na ncüaaꞌ ya nꞌonhinhanꞌ. Tsoñꞌen jñꞌoon na matsinën naneinhin na ndicüaaꞌ tsꞌon tsꞌanhanꞌ, majoꞌ ngüentyja xjen na ñꞌen nnꞌan xiꞌjndio tsonnangue na ncüaaꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Juu tsꞌan na ninꞌcüaaꞌ tsꞌon joo jñꞌoon na matsinën, quen ya juu cüentahanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mantyi tso Jesús ndëëhan: —Quitquen yahoꞌ cüenta jñꞌoon na condyehoꞌ na matsinën, ngꞌe xe na aa veꞌ chjo rohanꞌ na cotquenhoꞌ cüenta, mantyi tyiꞌjndyehanꞌ na ncüaaꞌ nꞌonhoꞌ. Ndoꞌ xe na aa ntquen yahoꞌ cüentahanꞌ, yajoꞌ majndyentyichenhanꞌ ncüaaꞌ nꞌonhoꞌ. Ndoꞌ nninncyaa Tyoꞌtsꞌon na matꞌmanntyichen na ncüaaꞌ nꞌonhoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ngꞌe juu tsꞌan na ivaaꞌ tsꞌon juu jñꞌoon na mancya, matꞌmanntyichen nndaaꞌ tsanꞌñeen na ncüaaꞌ tsꞌon juuhanꞌ. Ndoꞌ xe na aa mꞌaan tsꞌan na tavi ninꞌquindyii juu jñꞌoon na matsjö, ngitsuuꞌ tsꞌon juu chjo jñꞌoon na jndë nchjii juu ntyja njan.” ");
INSERT INTO azgNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sininntyichen Jesús, tso jon: —Juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan, ndö vaahanꞌ. Itsijonhanꞌ juuhanꞌ chaꞌvijon tsꞌan na jnonꞌ ncüii nnon ntjon. ");
INSERT INTO azgNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ndoꞌ juu tsanꞌñeen tyiꞌncüii tman vacuaa juu, itso juu, ndoꞌ nnanquintyja juu tyiꞌncüii nonnco. Ndoꞌ joo ꞌnan tsjanꞌñeen coꞌonhanꞌ, coquehanꞌ, covindyehanꞌ min na tyiꞌquintjii tsanꞌñeen nchu vaa na itsꞌaahanꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Coꞌon ntjon itsꞌaa tyuaa. Navejndyee conduiꞌ ntsquiihanꞌ, ndoꞌ vi na jndë tindyehanꞌ, conduiꞌ xjuꞌhanꞌ, ndë joꞌ cotsaqueꞌ nꞌonhanꞌ, ndë joꞌ comanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ndoꞌ ya na jndë tcanhanꞌ, yajoꞌ ntyjee tsꞌanhanꞌ. Ndöꞌ vaa na itsijonhanꞌ ntyja na icoꞌxen Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mantyi tso Jesús: —Ntsinën cüii jñꞌoon ndëëhoꞌ na tyiꞌquitsjö ncꞌihanꞌ chaꞌ quitejndeihanꞌ ꞌoꞌ na ncüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. ¿Nin jñꞌoon na ntsinën chaꞌ na ncüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌhanꞌ? Ndoꞌ ¿Nin ncüii nnon jñꞌoon na ntsijönꞌ ntyja na icoꞌxen jon? ");
INSERT INTO azgNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Itsijonhanꞌ juuhanꞌ chaꞌna ncüii ntquen mostaza na jnonꞌ tsꞌanhanꞌ. Ndoꞌ majuuhanꞌ na quijndëntyichenhanꞌ na tsoñꞌen ntquen ꞌnan na conon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Majoꞌ vi na jndë tꞌonhanꞌ, majuuhanꞌ na coninndyentyichenhanꞌ na tsoñꞌen nꞌoon na ninncüii ngueesuaꞌ na coventyjeeꞌ, ata conanꞌya quintsahinꞌ ntycya oꞌ xquenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jndye jndyi jñꞌoon totsinin Jesús ndëë nnꞌan na tyiꞌquitso nquiiꞌ jonhanꞌ chaꞌna joo jñꞌoonminꞌ. Tonincyaa jon jñꞌoonꞌñeen xiꞌncüii chaꞌxjen na taaꞌ tsꞌon jon na nndëë ncüaaꞌ nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ndoꞌ ninnquiiꞌchen totsinin jon ndëë nnꞌan yo jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ. Majoꞌ xjen na ntjo nquiihin yo nque nanꞌñeen na tqueenꞌ jon na quinanꞌjonhan yo jñꞌoon na toninncyaa jon, yajoꞌ totsiꞌman jon ndëëhan nchu vaa itsiquindyi ncüii cüii jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Majuuntyi xeeꞌñeen na jndë macontsjë chjo min, itso jon ndëë nnꞌan na tqueenꞌ jon na quitsayꞌonhan jñꞌoon yohin: —Cja, ncꞌö, ngüeꞌjndya ndaandue. ");
INSERT INTO azgNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Yajoꞌ jntyꞌehan nnꞌan, jnduiꞌhan. Ndoꞌ tyeyꞌonhan Jesús yo majuuntyi vꞌaandaa na tijntꞌue jon xjen na tyincyaa jon jñꞌoon ndëë nanꞌñeen. Ndoꞌ mantyi vendyechen nnꞌan na tomꞌan na tondyehan jñꞌoon na toninncyaa jon, tentyjahan naxenꞌ jon yo mañoon ntꞌaandaa. ");
INSERT INTO azgNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ndoꞌ tyioo vi jndye jndyo tque nnon juu ndaandueꞌñeen, ata totyionhanꞌ ndaa quityquiiꞌ juu vꞌaandaaꞌñeen, mavaa xjen na ngitooꞌhanꞌ yo ndaa. ");
INSERT INTO azgNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ndoꞌ Jesús xiꞌ tëntycüii tsꞌaan juu vꞌaandaaꞌñeen, joꞌ itso jon, ndyiiꞌ ndiaa quityaꞌ jon. Ndoꞌ joꞌ jnanꞌntcüihanhin, jnduehan: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ ndë́, ¿Aa minꞌchjo taꞌnan itsꞌaahanꞌ ꞌuꞌ na mavaa xjen na ncüjë́ na ngava ndaa nquén? ");
INSERT INTO azgNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ndoꞌ jnanquintyja Jesús, sityiaꞌ jon juu jndyeꞌñeen, tso jon nnonhanꞌ: —Cüichen na jndei mꞌanꞌ nnon ndaandue. Ndoꞌ nnon nquii ndaandueꞌñeen tso jon: —Cacüentyjeꞌ. Yajoꞌ tëvichen jndye nnonhanꞌ. Ndoꞌ mantjo taquiñjonchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Joꞌ tso Jesús ndëë nanꞌñeen: —¿Ndu na coquityuehoꞌ? ¿Aa tyiꞌcantyja nꞌonhoꞌ na ntejndei Tyoꞌtsꞌonhoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ndoꞌ tyue jndyihan sꞌaahanꞌ. Ndoꞌ jnduehan ndëë ntyjehan: —¿Nin condui tsanvahin? Cüa tanin tquen jon xjen juu jndye ndoꞌ yo juu ndaandue, ndoꞌ taꞌngueeꞌhanꞌ jñꞌoon na tso jon. ");
INSERT INTO azgNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús yo nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon tetꞌiohan ndaandueꞌñeen, squehan ndyuaa Gerasa. ");
INSERT INTO azgNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ndoꞌ juu xjen na jnduiꞌhan vꞌaandaaꞌñeen, jndyotsindyooꞌ ncüii tsꞌan ndëëhan, jnan juu ndiꞌntꞌua ntꞌoo. Ndoꞌ tsanꞌñeen, mꞌan jndyetyia quiiꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ninnquiiꞌchen ndiꞌntꞌua ntꞌoo tomꞌaan juu, ndoꞌ minꞌncüii tsꞌan taꞌnan jndëë ntsixjen yo ꞌnan na totsꞌaa juu, min na yo carena. ");
INSERT INTO azgNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ee jndye jnda jndë tonanꞌtyen nnꞌan ntꞌö juu, ngꞌee juu yo carena, majoꞌ ninñoonꞌ tocꞌiooꞌ juu ncjoꞌñeen na tyenhanꞌ ntꞌö juu, ndoꞌ totsitiuu jndë juu carena na jnanꞌtyen nnꞌan ngꞌee juu. Ndoꞌ min taꞌnan tsꞌan na ndëë ntscuꞌ nnon juu ꞌnan na tsixuan juu. ");
INSERT INTO azgNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Cüaꞌxuee ndoꞌ cüaꞌtsjon totsixuaa juu na tonannon juu quiiꞌ ntꞌan ntyoꞌ yo ndiꞌntꞌua ntꞌooꞌñeen. Ndoꞌ totsqueeꞌ nquiihin yo ntjöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ndoꞌ Jesús jeꞌ, ninvaa tycyachen ndyo jon, ndoꞌ jndyiaaꞌ tsanꞌñeenhin, jnannon juu na ngueeꞌ juu na mꞌaan jon. Tëconxtye juu na tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ndoꞌ juu jndyetyiaꞌñeen, sꞌaa juu na jndei sixuaa tsanꞌñeen, itso juu: —ꞌUꞌ Jesús na condui ꞌuꞌ jnda Tyoꞌtsꞌon na mꞌaan nandye quiñoonꞌndue, ¿Nin tsꞌian na jndyoꞌ ntjoohin? Ndyii jon na matsixua ja xueeꞌ jon na tyiꞌntsaꞌviꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ndöꞌ vaa na tso tsanꞌñeen ngꞌe jndë tso Jesús nnon juu: —ꞌUꞌ jndyetyia, quinduiꞌ quiiꞌ tsꞌon tsanvahin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ndoꞌ tsontyichen Jesús nnon juu jndyetyiaꞌñeen: —¿Nchu jndyuꞌ? Tꞌa juu, tso juu: —Já jndyú Legión, ngꞌe minchen já. ");
INSERT INTO azgNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ndoꞌ juu jndyetyiaꞌñeen, tocan juu vi nayaꞌñeen nnon Jesús na tyiꞌjñon jon joohan na quinduiꞌhan juu ndyuaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ndoꞌ ndyo joꞌ mꞌan ncüii tmaanꞌ quintcu na cotqui oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Joꞌ tan jndyetyiaꞌñeen nnon Jesús na ncyaa jon jñꞌoon na ncꞌoqueꞌhan quityquiiꞌ nꞌon joo quintcuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ndoꞌ joꞌ tyincyaa Jesús jñꞌoon. Ndoꞌ joo jndyetyiaꞌñeen jnduiꞌhan quiiꞌ tsꞌon juu tsanꞌñeen, saqueꞌhan quiiꞌ nꞌon joo quintcuꞌñeen, joo choꞌñeen chaꞌna ve min oꞌ. Ndoꞌ joo oꞌ jnanꞌnon oꞌ, tyꞌe oꞌ tontyja na ji vaa jndyi na congio juu tyoꞌñeen, tycyaa oꞌ quityquiiꞌ juu ndaandueꞌñeen, ndoꞌ tava ndaa nquen oꞌ, mana tjë oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ndoꞌ joo nnꞌan na totaꞌntyjeeꞌ quintcuꞌñeen, jntyꞌiahan na nndaꞌ vaa ꞌnan na tui. Joꞌ tyiiꞌ yantyihan na jnanꞌnonhan na sananꞌquindyiihan joo nnꞌan na mꞌan juu tsjoon na icoꞌxenhanꞌ juu tyuaaꞌñeen, yo ninꞌnnꞌan na comꞌan jndëë na nndaꞌ vaa ꞌnan na tui. Yajoꞌ nnꞌan na ninꞌquijntyꞌia nchu vaa ꞌnan na tui, tyꞌehan naijon na mꞌaan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ndoꞌ xjen na squehan naijon na mꞌaan jon, jntyꞌiahan juu tsanꞌñeen na totsixuan juu jndyetyia, vequityen juu na cüe juu ndiaa, ndoꞌ jndë tcoꞌ ya ntcüeꞌhanꞌhin, tavitsitsanꞌhanꞌ xquen juu. Ndoꞌ joꞌ sityꞌue jndyihanꞌ joo nanꞌñeen na nndaꞌ vaa ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ndoꞌ nque nnꞌan na totaꞌntyjeeꞌ joo quintcuꞌñeen na jntyꞌiahan na nndaꞌ, jnanꞌneinhan ndëë nnꞌan na tancüi joꞌ nchu vaa na tcoꞌ yahanꞌ juu tsanꞌñeen yo nchu vaa na tjë joo quintcuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ndoꞌ joo nanꞌñeen, vi na jndë jndyehan jñꞌoonꞌñeen, taꞌhan na tanhan nnon Jesús na quinduiꞌ ntcüeꞌ jon ndyuaa ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ndoꞌ xjen na vacua nndaꞌ Jesús vꞌaandaaꞌñeen, juu tsanꞌñeen na jndë tcoꞌ yahanꞌhin, tcan juu jñꞌoon nnon jon na ncyaa jon na chi ncja juu yohin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Majoꞌ tyíꞌncyaa jon jñꞌoon na tcan tsanꞌñeen. Tso jon nnon juu: —Cjaꞌ ntcüeꞌ vaꞌ na mꞌan nnꞌan ꞌnanꞌ. Joꞌ quitsuꞌ ndëëhan nchu vaa ꞌnan tꞌman jndyi na sꞌaa Tyoꞌtsꞌon yo ꞌuꞌ na tyꞌoon jon na ndyiaꞌ roꞌ nchjii jon. ");
INSERT INTO azgNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ndoꞌ juu tsanꞌñeen, siquindë juu, tja juu. Ndoꞌ tyeꞌ totsinin juu ndëë nnꞌan na mꞌanhan njoon ndyuaa Decápolis ntyja nchu vaa ꞌnan na sꞌaa Jesús yohin. Ndoꞌ joo nanꞌñeen, vi na jndë jndyehan na nndaꞌ sꞌaa Jesús yohin, tëveeꞌ jndyi ngiohan. ");
INSERT INTO azgNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Juu Jesús tetꞌio nndaꞌ jon ndaandue yo vꞌaandaa. Tueeꞌ jon ncüiichen ixndya yo nnꞌan na totsayꞌon yo jñꞌoon yohin. Ndoꞌ jndye jndyi nnꞌan squenon na mꞌaan jon ꞌndyo ndaandueꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ndoꞌ joꞌ, ncüii tsꞌan na jndyu Jairo, tyjeeꞌ juu na mꞌaan jon. Juu tsanꞌñeen conduihin tsꞌan Israel na conintquehin vatsꞌon cüenta nnꞌan judíos tsjoonꞌ juu. Xjen na jndyiaaꞌ juu Jesús, tëconxtye juu na sꞌaa juu na njonhin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Tcan juu na quitejndei jonhin, tso juu: —Mioon jndyi viiꞌ juu yuscu chjo jnda, jndë maninꞌcueꞌ juu. Quitsaꞌ chjo vi nayaꞌñeen na chi ngaquityioꞌ ntꞌöꞌ nacjooꞌ juu chaꞌ nꞌman juu na tyiꞌngueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ndoꞌ tja Jesús yo tsanꞌñeen. Mantyi jndye nnꞌan tentyja na nquenꞌhan, maninꞌ conchjehan jon na coꞌohan. ");
INSERT INTO azgNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ndoꞌ quiiꞌ ntꞌan tmaanꞌ nanꞌñeen, joꞌ ñꞌen ncüii tsanscu, jndë nchoꞌve chu na viiꞌ juu na cocꞌa neoonꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ji vaa jndyi totjon juu na tontꞌa ndoto nasihin, ndoꞌ min joꞌ taquitsꞌaahanꞌ, majndeichen vavimioonꞌ juu. Ndoꞌ jndë ntycüii xoquituꞌ ꞌnaanꞌ juu na totsiquitsu juu na tondui nasihin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ndoꞌ ngꞌe na jndyii juu jñꞌoon na tonanꞌnein nnꞌan ntyja ꞌnaanꞌ Jesús, joꞌ na sindyooꞌhin quiiꞌ ntꞌan nanꞌñeen na tentyjahan toxenꞌ jon, ndoꞌ tꞌuii juu ndiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Nndaꞌ vaa na sꞌaa juu ngꞌe jndë sitiu juu: “Xe na aa veꞌ nndëë ntꞌui ndiaaꞌ jon, yajoꞌ chi nꞌman.” ");
INSERT INTO azgNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ndoꞌ xjen na sꞌaa juu na nndaꞌ, maninñoonꞌ taquitscuꞌhanꞌ ꞌnan na iquenon juu, ntyjiichen juu na tëcoꞌ yahanꞌ quiiꞌ siꞌtsꞌo ꞌnaanꞌ juu na jnduiꞌ juu tycuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ndoꞌ taaꞌ tsꞌon Jesús na jndë jnꞌman tsꞌan yo ntyja ꞌnaanꞌ juu najndei na condui jon. Joꞌ tëquen jon, taxeeꞌ jon ndëë nnꞌan na tentyja toxenꞌ jon, tso jon ndëëhan: —¿Nin juu tꞌuii ndia? ");
INSERT INTO azgNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ndoꞌ joo nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, tꞌahan, jnduehan nnon jon: —Mandyiaꞌ na tyen ro mꞌan nnꞌan ata conchjehan ꞌuꞌ, ndoꞌ aa mavaxeꞌ ¿Nin tsꞌan tꞌuii ndiaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ndoꞌ Jesús, jndyiaaꞌ jon xiꞌjndio, na ndyiaaꞌ jon nin nquii tsꞌan tꞌuii ndiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ndoꞌ juu tsanscuꞌñeen, tyioo na ncyaaꞌ juu, sindyooꞌcyahin nnon jon na coviquijntyꞌehin. Tëconxtye juu na tonnon jon ngꞌe nchjii juu nchu vaa na sꞌaahanꞌhin. Ndoꞌ tso jndyoyu juu nnon jon yo ꞌnan na sꞌaahanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ndoꞌ tso Jesús nnon juu: —ꞌUꞌ jnda, ngꞌe na vantyja tsonꞌ ja, joꞌ na jndë jnꞌmanꞌ. Naneinhin cjaꞌ ntcüeꞌ vaꞌ, minꞌncüii jñꞌoontiu tavi ncꞌonꞌ. Jndë jnꞌmanꞌ yo juu tycu na maquenoonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ndoꞌ viochen xjen na sinin Jesús nnon tsanscuꞌñeen, joꞌ sque ro nnꞌan na jnan vaaꞌ nquii tsanꞌñeen na conintquehin ntyja ꞌnaanꞌ juu vatsꞌonꞌñeen, juu tye yuscu chjo yuviiꞌ. Ndoꞌ jnduehan nnon jon: —Jndë tueꞌ juu yuscu chjo jndaꞌ. Joꞌ juu tsan na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, tavintsinchjuꞌntyiꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ndoꞌ nquii Jesús, jndyii jon na jndue nanꞌñeen na nndaꞌ, majoꞌ itso jon nnon juu tsanꞌñeen na conintquehin vatsꞌon: —Tyiꞌntyꞌueꞌ, ꞌuꞌ xiaꞌntyi cantyja tsonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ndoꞌ juu Pedro, Jacobo yo ninꞌJuan tyje juu Jacoboꞌñeen, tyꞌehan yo Jesús vaaꞌ nquii Jairoꞌñeen. Min tyíꞌncyaa Jesús na ncja ncüiichen tsꞌan yohin. ");
INSERT INTO azgNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ndoꞌ xjen na squehan vaaꞌ Jairoꞌñeen, jndyii jon na cꞌuaa jndyi jndyue nnꞌan na cotyueehan, ndoꞌ conanꞌxuaahan na tueꞌ yuscu chjoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Majoꞌ vi jndë na taqueeꞌ jon quityquiiꞌ vꞌaa, min na ntyjii jon na jndë tueꞌ juu yuscu chjoꞌñeen, tso jon ndëë nnꞌan na mꞌan joꞌ: —¿Ndu na cꞌuaa jndyi jndyuehoꞌ na cotyueehoꞌ? Ee juu nian chjöhöꞌ, chito aa tueꞌ juu, veꞌ itso juu. ");
INSERT INTO azgNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Majoꞌ nnꞌan na sque ya juu vꞌaaꞌñeen, veꞌ toncohan Jesús ngꞌe ngio yahan na jndë tueꞌ juu. Joꞌ tjiꞌ jon nanꞌñeen chꞌen, ndoꞌ ndë joꞌ tëyꞌoon jon nquii tye juu tsꞌoo chjoꞌñeen yo ndyee juu. Tequeꞌhan juu cüarto naijon na vaquityen juu. ");
INSERT INTO azgNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ndoꞌ tꞌuii jon vi ntyjaaꞌ ntꞌö tsꞌoo chjoꞌñeen, tso jon yo jñonꞌndaa ꞌnaanꞌ jon: —Talita, cumi. Juu jñꞌoonvaꞌhin itsiquindyihanꞌ: “Yuscu chjo, matsjö nnonꞌ, quinanquintyjaꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ndoꞌ juu xjen na tso Jesús jñꞌoonvaꞌ, jnanquintyja yuscu chjoꞌñeen, ndoꞌ tyeꞌ na vaca nndaꞌ juu, ngꞌe jndë jndë nchoꞌve chuuꞌ juu. Ndoꞌ na tui na nndaꞌ, joo nnꞌan na mꞌan joꞌ, tëveeꞌ jndyi ngiohan. ");
INSERT INTO azgNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Majoꞌ jaaꞌ jñꞌoon siquiꞌmaanꞌ Jesús joohan na minꞌncüii nnon tsꞌan tyiꞌnduehan na nndaꞌ vaa ꞌnan na sꞌaa jon. Ndoꞌ mantyi tꞌua jon tsꞌian ndëëhan na ncyahan ꞌnan na ntcüaꞌ juu yuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jndëcya jnduiꞌ Jesús tsjoon Capernaum, tja nndaꞌ jon tsjoon naijon tëquehin. Ndoꞌ nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, mantyi tyꞌehan yohin. ");
INSERT INTO azgNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ndoꞌ ya tueeꞌ juu xuee na cotaꞌjndyee nnꞌan judíos, yajoꞌ taqueeꞌ jon vatsꞌon juu tsjoonꞌñeen, tyincyaa jon jñꞌoon. Ndoꞌ jndye nnꞌan na mꞌan joꞌ, tëveeꞌ ngiohan juu jñꞌoonꞌñeen. Jnduehan ndëë ntyjehan: —¿Yuu va chu tsanvahin joo jñꞌoonminꞌ na itsinin juu ndëëhë? ¿Nin tsꞌan siꞌman nnon juu? ¿Nin conduihin na condëë itsꞌaa juu tsꞌianminꞌ, na joohanꞌ veꞌ minꞌcyato tsꞌan jeꞌquindëë ntsꞌaahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Juu jon veꞌ tsꞌan tocyu ntcaaꞌhin, ndoꞌ veꞌ jnda Maríahin, ndoꞌ mantyi ntjoo mꞌan ntyje juu Jacobo, José, Judas yo ninꞌSimón, ndoꞌ mantyi nanntcu ntyje juu mantjoo ro comꞌan joo. Nndaꞌ vaa na tyíꞌquintꞌa nanꞌñeen na njon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ndoꞌ ngꞌe na nndaꞌ jndue nanꞌñeen, yajoꞌ tso jon ndëëhan: —Nnꞌan na mañoonchen, tsoñꞌenhan contꞌahan na njon juu tsꞌan na ncyaa jñꞌoonꞌ Tyoꞌtsꞌon. Majoꞌ nque nnꞌan tsjoonꞌ tsanꞌñeen, tyiꞌquinjonhin ngiohan, min nnꞌan chuuꞌhin min nnꞌan vaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Veꞌ ngꞌe na nndaꞌ vaa na tonanꞌtiu nanꞌñeen yo ntyja ꞌnaanꞌ Jesús, tsojnaanꞌ na tyiꞌcantyjaꞌ nꞌonhan, joꞌ na iscuꞌhanꞌ na ntsinꞌman jon nnꞌan tsjoonꞌ jon. Xiaꞌntyi ninvendye tsꞌan na tyio jon ntꞌö jon cjohin jnꞌmanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Majoꞌ siꞌndaaꞌhanꞌ nchjii jon na tyíꞌninꞌcantyja nꞌonhan jon. Ndë joꞌ jnduiꞌ jon, toca jon njoon quijndë, joꞌ toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ndëcya tqueenꞌ jon joo nchoꞌve nnꞌan na iꞌua jon tsꞌian ndëëhan na ve vehan na cꞌohan tsꞌian ꞌnaanꞌ jon, ndoꞌ tyincyaa jon na nanꞌxuanhan juu najndei na conduihin chaꞌ ndëë ntjiꞌhan jndyetyia quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ndoꞌ tquen jon jñꞌoon ndëëhan na xiaꞌntyi tsonjntꞌei quitsayꞌonhan, majoꞌ tyíꞌntsayꞌonhan chetsjaꞌ, min ꞌnan na ntcüaꞌhan, min xoquituꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ndoꞌ quityionhan ntconhan ngꞌehan, ndoꞌ min tyíꞌntsayꞌonhan ncüiichen ntjo ndiaahin. ");
INSERT INTO azgNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Ndoꞌ tso jon ndëëhan: —Tsjoon naijon na ntsquehoꞌ, ndoꞌ xe ngitso tsꞌan ndëëhoꞌ na ngüenonhoꞌ quiiꞌ vaaꞌ jon na ntixeeꞌ jon ꞌoꞌ, joꞌ quintjohoꞌ vaaꞌ jon ata xjen na nnduiꞌ ntcüeꞌhoꞌ juu tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ndoꞌ xjen na ntsquehoꞌ ncüii tsjoon, majoꞌ nque nnꞌan juu tsjoonꞌñeen, xe na aa tyiꞌninꞌcyꞌonhan cüentahoꞌ, ndoꞌ min tyiꞌninꞌquindyehan jñꞌoon na concyahoꞌ, ndö vaa quintꞌahoꞌ. Xjen na nnduiꞌ ntcüeꞌhoꞌ ꞌndyo juu tsjoonꞌñeen, quinanꞌcyaahoꞌ tsꞌo na chuuꞌ ngꞌehoꞌ, yajoꞌ ntsiꞌmanhanꞌ ndëë nanꞌñeen na tyiꞌya jntꞌahan. Joo nnꞌan tsjoon Sodoma yo Gomorra, tyia jndyi ꞌnan na tontꞌahan. Juu xuee na ntꞌuii Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na tonanꞌtjahan nnon jon, viꞌ jndyi ngenon joo nnꞌan njoonꞌñeen. Majoꞌ nque nnꞌan mꞌan njoon na tyiꞌninꞌcyꞌonhan cüentahoꞌ, viꞌntyichen ngenonhan, chichen nnꞌan joo njoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Vi jndë sinin Jesús ndëëhan, yajoꞌ jnduiꞌhan, tyencyahan jñꞌoon na quintcüeꞌ nꞌon nnꞌan yo jnan na nanꞌxuanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mantyi jndye jndyi jndyetyia tjiꞌhan quiiꞌ nꞌon nnꞌan, ndoꞌ jndye nnꞌan vꞌi na tyeehan aceite, jnanꞌnꞌman nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jndye nnꞌan tonanꞌneinhan ntyja ꞌnaanꞌ juu tsꞌian tꞌman na totsꞌaa Jesús, ndoꞌ jndyii Herodes joo jñꞌoonꞌñeen. Juu jon conduihin na icoꞌxen jon nnꞌan juu ndyuaaꞌñeen. Tso jon: —Ja tquën jñꞌoon na jnanꞌcueeꞌ sondaro njan juu Juan, tsan na totsiquindëëꞌ nnꞌan. Ntsꞌaahanꞌ jndë vandoꞌ xco jon, mangꞌe joꞌ covityincyooꞌ tsꞌianminꞌ na itsꞌaa tsanvahin na jeꞌquinduihanꞌ na veꞌ yo najndei nquii tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ndoꞌ ñꞌen nnꞌan jnduehan ntyja ꞌnaanꞌ Jesús na conduihin Elías, nquii tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen nchu vaa ꞌnan na nguaa. Majoꞌ vendyechenhan jnduehan: —Juu Jesús conduihin ncüiichen tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon tiviontyichen nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ngꞌe na tonanꞌnein nnꞌan joo jñꞌoonminꞌ, ndoꞌ Herodes, vi na jndë jndyii jon ntyja ꞌnaanꞌ ꞌnan na itsꞌaa Jesús, tso jon: —Tsanvahin majuu Juanhin, tsan na tquën jñꞌoon ndëë sondaro njan na quityjehan xquen juu, majuu jon jndë vandoꞌ xco. ");
INSERT INTO azgNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Nquii Herodesꞌñeen jndë toco jon yo juu Herodías, scuuꞌ tyje jon Felipe. Majoꞌ juu Juanꞌñeen jndë tso jon nnon juu Herodes: “Tyiꞌquichuhanꞌ na manayonꞌ scuuꞌ tyꞌiuꞌ na ndiscuꞌhin.” Ngꞌe na nndaꞌ vaa na tso Juan, joꞌ siꞌvꞌii matyen Herodíasꞌñeen jon. Ntꞌue jndyi tsꞌon juu na cueꞌ tsanꞌñeen, majoꞌ taꞌnan jndëë sꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Majoꞌ juu Herodes, totsꞌaa jon na njon juu Juanꞌñeen. Ee taaꞌ tsꞌon jon na ya tsꞌanhin, ndoꞌ na tsixuan juu ñuan nquiiꞌ ntyja ꞌnaanꞌ nquii Tyoꞌtsꞌon. Mangꞌe joꞌ tyíꞌncyaa jon na ngenon juu natëꞌ. Ndoꞌ min na ndicüaaꞌ ya tsꞌon jon jñꞌoon na toninncyaa Juanꞌñeen, majoꞌ tëveeꞌ nchjii jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Majoꞌ juu Herodías, tueeꞌ xjen na jndëë sꞌaa juu yo ꞌnan na ntꞌue tsꞌon juu na cueꞌ Juanꞌñeen. Ee juu xjen ya na tueeꞌ xeechuuꞌ nquii Herodes, sꞌaa jon ncüii nguee na ntcüaꞌ jon yo nque nnꞌan na condui nanmꞌannꞌian na cotsantyja naxenꞌ jon juu ndyuaa Galilea, yo nnꞌan na conintque ndëë sondaro ꞌnaanꞌ jon ndoꞌ yo ninꞌnantya. ");
INSERT INTO azgNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ndoꞌ joꞌ, juu yuscundyua jnda Herodíasꞌñeen, tëqueeꞌ juu naijon na mꞌan nanꞌñeen, sijnon juu. Ndoꞌ Herodes taxjen vaa tëveeꞌ jndyi tsꞌon jon na nndaꞌ vaa sꞌaa juu, nquii jon ndoꞌ mantyi joo nanꞌñeen na conanꞌjonhan yohin juu ngueeꞌñeen. Ndoꞌ itso jon nnon juu yuscundyuaꞌñeen: —¿Nin ꞌnan ntꞌue tsonꞌ na ntsꞌa naya ꞌuꞌ? Quitsuꞌ nnön ndoꞌ ja nninncyahanꞌ nnonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nquii Tyoꞌtsꞌon, ndyiichen jon jñꞌoon na mayuuꞌ matsjö nnonꞌ, ata xoncüe ndyuaa na macoxën nninncyahanꞌ nnonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ndoꞌ juu yuscundyuaꞌñeen, vi na jndë jndyii juu na nndaꞌ, jnduiꞌ juu, taquitso juu nnon ndyee juu: —ꞌNdyoꞌ, ¿Nin ꞌnan ntcꞌan? Ndoꞌ tꞌa ndyee juu, itso jon: —Canꞌ nnon jon na quitscüenon jon xquen Juan ntꞌöꞌ, juu tsan na totsiquindëëꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ndoꞌ juu yuscundyuaꞌñeen, maquintyjachen tja ntcüeꞌ juu na mꞌaan Herodesꞌñeen, tso juu nnon jon: —Ntꞌue tsꞌön na ninꞌñoonꞌ nein quitscüenonꞌ xio na ñjon xquen juu Juan ntꞌö, juu tsan na totsiquindëëꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ndoꞌ nquii Herodes, xjen na jndyii jon na nndaꞌ, tyioo na tyia jndyi nchjii jon. Majoꞌ ngꞌe jndë tso jon na ntyjii Tyoꞌtsꞌon na ntsiquindë jon juu jñꞌoon na tso jon nnon juu, ndoꞌ mantyi joo nanꞌñeen na sananꞌjon na cocüaꞌhan yohin jndë jndyehan juu jñꞌoonꞌñeen, joꞌ xe na aa ngitso jon jeꞌquindëë na ntsiquindë jon juu jñꞌoonꞌñeen, yajoꞌ ngüejnaanꞌ jon tondëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ngꞌe na nndaꞌ, ninñoonꞌ jñon jon ncüii sondaro na caquityjee juu xquen Juan na ndyiiꞌ jon vancjo. ");
INSERT INTO azgNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ndoꞌ juu tsanꞌñeen, tja juu, taquityjee juu xquen juu Juanꞌñeen yo xjo, ndoꞌ jndë joꞌ jndyoyꞌoon juuhanꞌ na ñjonhanꞌ quityquiiꞌ xio. Tyincyaa juuhanꞌ nnon yuscundyuaꞌñeen, ndoꞌ juu juu tyincyaa juuhanꞌ nnon ndyee juu. ");
INSERT INTO azgNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ndoꞌ joo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Juan, vi na jndë jndyehan na nndaꞌ vaa na tjon jon, tyecyꞌonhan siꞌtsꞌo ꞌnaanꞌ jon, saquityꞌiuhan juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Vi jndë tui na nndaꞌ, joo nnꞌan nchoꞌve na jñon Jesús tsꞌian ꞌnaanꞌ jon, tëncüi nndaꞌhan na mꞌaan jon. Chen jndyi jnduehan nnon jon ntyja ꞌnaanꞌ juu tsꞌian na jndë tontꞌahan yo ntyja ꞌnaanꞌ jñꞌoon na tonanꞌmanhan ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Joꞌ itso jon ndëëhan: —Cja ncꞌö ncüii joo naijon na ninnquë, chaꞌ ya ntaꞌjndyëë chjo. Nndaꞌ vaa na tso jon ngꞌe jndye jndyi nnꞌan cotsque naijon na mꞌaan jon, min ndincyaahanꞌ xjen na ntcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Yajoꞌ jnduiꞌhin yo vꞌaandaa, teꞌtꞌiohan ndaandue na ninnquehan. Ndoꞌ squehan ncüii joo naijon tavi ꞌnan nnꞌan cꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Majoꞌ jndye nnꞌan tquenchenhan cüenta naijon tyꞌehan. Ndoꞌ jnduiꞌ nanꞌñeen chaꞌtso njoon na mꞌaan xiꞌjndio juu ndyuaaꞌñeen, jnanꞌnonhan, ndoꞌ macjentyichen squehan naijon vja Jesús yo nnꞌan na totsayꞌonhan jñꞌoon yohin. ");
INSERT INTO azgNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ndoꞌ juu xjen na jnduiꞌ Jesús vꞌaandaaꞌñeen, jndyiaaꞌ jon na jndye jndyi nnꞌan jndë sque. Ndoꞌ tyioo na ntyꞌia rohan nchjii jon, ngꞌe itsijonhanꞌhin chaꞌvijon quinman na tatsꞌan vantyjeeꞌ. Yajoꞌ jndye jñꞌoon tyeꞌ na totsiꞌman jon ndëëhin. ");
INSERT INTO azgNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ndoꞌ vi na jndë vaman, yajoꞌ nque nnꞌan na totsayꞌon yo juu jñꞌoon na toninncyaa jon, jnanꞌndyooꞌhan, jnduehan nnon jon: —Jndë vaman ndoꞌ ntjoohin taꞌnan ncüii joo na nninjndaꞌ ꞌnan na ntcüaꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mangꞌe joꞌ quitsuꞌ ndëë nanmin na chi ncꞌohan jndëë yo njoon quijndë na mꞌan xiꞌjndio na chi nnanꞌjndahan ꞌnan na ntcüaꞌhan, ngꞌe taꞌnan quichohan na ntcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Majoꞌ tꞌa Jesús, tso jon: —Nquehoꞌ ninncyahoꞌ ꞌnan na ntcüaꞌhan. Ndoꞌ joo nanꞌñeen, tꞌahan, jnduehan nnon jon: —Min xe na aa nnanꞌquitsu ve ciento sꞌon denarios na ntsananꞌjndá tyooꞌ, majoꞌ tyiꞌjeꞌcüinonhanꞌ na nninncyá na ntcüaꞌ joo nanmin. ");
INSERT INTO azgNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ndoꞌ tꞌa Jesús, taxeeꞌ jon: —¿Tsaꞌnndaꞌ tyooꞌ na yꞌonhoꞌ? Cüa, quitsaquijntyꞌiahoꞌ. Ndoꞌ vi na jndë jntyꞌiahan na tsaꞌnndaꞌhanꞌ, yajoꞌ jnduehan nnon jon: —Nin ꞌon tanꞌ tyooꞌ na yꞌö́n yo ve quitscaa na jndë jnein. ");
INSERT INTO azgNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ndoꞌ tꞌua Jesús tsꞌian na xenꞌ ntmaanꞌ na quitsacüendyuaa nnꞌan cjooꞌ jndë quijndë. ");
INSERT INTO azgNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Yajoꞌ sacüendyuaa nanꞌñeen na xenꞌ ntmaanꞌhan. Ñꞌen ntmaanꞌ na jntꞌahan na vennꞌan vennꞌan nchoꞌnqui tsꞌan, ndoꞌ ñꞌen ntmaanꞌ na ncüii ciento tsꞌan na jntꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jndë joꞌ tyꞌoon Jesús joo ꞌon tanꞌ tyooꞌñeen yo ve quitscaaꞌñeen, ndoꞌ jndondë jon toquiñoonꞌndue, tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ. Ndë joꞌ tjiꞌ jon xenꞌ ntanꞌhanꞌ. Ndoꞌ vi jndë joꞌ tyincyaa jonhanꞌ ndëë nque nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon na quitꞌonhinhanꞌ ndëë nnꞌan joo ntmaanꞌñeen. Ndoꞌ majoꞌntyi sꞌaa jon yo ve quintcaaꞌñeen, tjiꞌ jon xenꞌ ntanꞌhanꞌ na ntquii tsoñꞌen nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ndoꞌ tsoñꞌen nanꞌñeen tcüaꞌ tacjohan, ");
INSERT INTO azgNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ndoꞌ ndë joꞌ, nque nnꞌan na totsayꞌon jñꞌoon yo Jesús, jnanꞌquitooꞌhan nchoꞌve tsque yo tyooꞌ ntanꞌ na jntyꞌiihanꞌ na tcüaꞌ nanꞌñeen yo ninꞌquintcaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ndoꞌ joo nnꞌan na tcüaꞌ juu xjenꞌñeen, tueeꞌ chaꞌ na ꞌon min na xiaꞌntyi nannon. ");
INSERT INTO azgNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ndë joꞌ tso Jesús ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon na cua nndaꞌhan vꞌaandaa na chi ngüetꞌio nndaꞌhan juu ndaandueꞌñeen na ntsquehan tsjoon Betsaida, viochen xjen na njñon jon nanꞌñeen na cꞌo ntcüeꞌhan ntꞌaahan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ndoꞌ vi na jndë jñon jon joo nanꞌñeen, tava jon ncüii tyoꞌ na ntsinin jon nnon nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ndoꞌ vi na jndë tijaan, joo nanꞌñeen na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, jndë mꞌanhan xoncüe ndaandue yo juu vꞌaandaaꞌñeen, majoꞌ juu jon ninmꞌaan jon tyuaa tcan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ndoꞌ jndyiaaꞌ jon na viꞌ jndyi coquenonhan, na tandiquindëë ntꞌahan ndaa veꞌ ngꞌe na totsintcüeꞌ jndye juu vꞌaandaa na ñjonhan. Ndoꞌ xjen na vanco, yajoꞌ tëca Jesús nnon ndaandue. Sindyooꞌhin nnon vꞌaandaaꞌñeen naijon na ñjonhan, ndoꞌ sꞌaa jon na chaꞌvijon ngüenoonꞌ jon joohan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ndoꞌ xjen na jntyꞌiahan na vaca jon nnon ndaandueꞌñeen, jnanꞌtiuhan veꞌ ncüaanꞌ tsꞌoo na cojntyꞌiahan. Ngꞌe na nndaꞌ taꞌhan na jnanꞌxuaahan na coquityuehan. ");
INSERT INTO azgNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ndoꞌ tsoñꞌenhan jntyꞌiahan jon, ndoꞌ mioon jndyi tyuehan. Majoꞌ tꞌman jon joohan, tso jon: —Quinanꞌxuanhoꞌ ñuaanhoꞌ, mancöntyë na mamanhoꞌ, cꞌonhoꞌ na tavi ncyaahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ndoꞌ tua jon vꞌaandaa na ñjonhan joꞌ, yajoꞌ tichen na mꞌaan juu jndyeꞌñeen. Majoꞌ min ndicüaaꞌ nꞌonhan nchu vaa na nnanꞌtiuhan na nndaꞌ vaa ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ngꞌe tyiꞌcovaaꞌ ya nꞌonhan na tsoñꞌen nndëë ntsꞌaa Jesús min na jntyꞌiahan na sꞌaa jon na tinon juu tyooꞌñeen na tcüaꞌ tsoñꞌen nanꞌñeen. Joohan tsojnaanꞌ na tsan ñuan ꞌnaanhan, joꞌ iscuꞌhanꞌ na ncüaaꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Xjen na jndë tetꞌio nndaꞌhan juu ndaandueꞌñeen, squehan ndyuaa Genesaret naijon jnanꞌtyenhan juu vꞌaandaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ndoꞌ xjen na jnduiꞌhinhanꞌ, joo nnꞌan ndyuaaꞌñeen taꞌjnꞌaanhan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ndoꞌ cje ro jnanꞌquindyiihan ntyjehan na mꞌan xiꞌjndio. Joꞌ taꞌhan na totsachohan nnꞌan vꞌi na ntyjohan cjo ndue minꞌcya ro naijon ticꞌuaa jñꞌoon na ngüenon nquii Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ndoꞌ minꞌcya ro naijon na tueeꞌ jon, aa njoon tꞌman ndoꞌ aa yuu na mꞌaan ninve ndye ntꞌaa, totquen nnꞌan ntyjehan nnꞌan na vꞌi jndyue nata, na ngitanhan na ntꞌuehan ndiaaꞌ Jesús chaꞌ nꞌmanhan. Ndoꞌ tsoñꞌen nnꞌan na tꞌue ndiaaꞌ jon jnꞌmanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nque nnꞌan fariseos, jnanꞌndyooꞌhan na mꞌaan Jesús yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen nquii Moisés. Joo nanꞌñeen jnanhan Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Totquenhan cüenta na nque nnꞌan na conanꞌjon yo Jesús, tocüaꞌhan min na tyiꞌquitmanhan ndueehan chaꞌxjen juu costumbre na contꞌa ntyjehan nnꞌan judíos. Jndue fariseosꞌñeen na joo nnꞌan na totsayꞌonhan jñꞌoon yo Jesús, tyiꞌya na nndaꞌ contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ee joo fariseosꞌñeen yo tsoñꞌen ntyjehan nnꞌan judíos, xeꞌcüaꞌhan xe na aa tyiꞌnanꞌquindë jndyeehan juu jñꞌoon na jnanꞌjndaꞌ ndochihan na tomꞌan ndyu na toxenꞌchen ntyja ꞌnaanꞌ na cotmanhan ndueehan. ");
INSERT INTO azgNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ee nque nnꞌan fariseosꞌñeen yo tsoñꞌen ntyjehan nnꞌan judíos, vi na jndë jnanhan tsꞌua, tyiꞌjeꞌcüaꞌhan xe na aa tyiꞌquitquen ntjuꞌ jndyeehan na cotman ndueehan chaꞌxjen coꞌxen costumbre. Ndoꞌ jndyechen ꞌnan min na contꞌahan chaꞌxjen na jnanꞌjndaꞌ nque ndochihan na tomꞌan ndyu na toxenꞌchen, chaꞌ na majndaꞌ na cotmanhan vaso na ncꞌu tsꞌan ndaa, yo nguaa jaro, yo nguaa ncjo yo ninꞌjndu ꞌnaanhin. ");
INSERT INTO azgNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Yajoꞌ joo fariseosꞌñeen yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen nquii Moisés, taxeeꞌhan nnon Jesús, jnduehan: —Joo nnꞌan na cotsayꞌon yo jñꞌoon na mancyaꞌ, ¿Ndu na tyiꞌquitaꞌngueeꞌhin jñꞌoon na jntyꞌe ndochiihi na tomꞌan ndyu na toxenꞌchen? Majoꞌ joo nnꞌan ꞌnanꞌ, cocüaꞌhan min na tyiꞌquintꞌa jndyeehan juu ꞌnan na ntsijiꞌuahanꞌ ndueehan chaꞌxjen na coꞌxen juu costumbre. ");
INSERT INTO azgNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ndoꞌ tꞌa Jesús jndyuehan, tso jon: —Juu jñꞌoon na tji Isaías, jndyoyu na tsiꞌmanhanꞌ na conduihoꞌ nnꞌan na ve vaa na contꞌa. Ee itso jñꞌoonꞌñeen: Nanminꞌ veꞌ yo nnon jndyuehan na conanꞌtꞌmaanꞌhan ja, majoꞌ ꞌnan na covitincyooꞌ na vja na mꞌanhin, tsiꞌmanhanꞌ na tycya mꞌanhan yo ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Veꞌ jnꞌaan na conanꞌtꞌmaanꞌhan ja, ee jñꞌoon na jnanꞌjndaꞌ nnꞌan na icoꞌxenhanꞌ, joohanꞌ conanꞌmanhin ndëë nnꞌan, ee contꞌahan na njon joo jñꞌoonꞌñeen chaꞌvijon conduihanꞌ jñꞌoon na sinin nquii Tyoꞌtsꞌon. Ndöꞌ jñꞌoon na sinin Isaías. ");
INSERT INTO azgNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ndoꞌ itsontyichen Jesús ndëë nanꞌñeen: —Tquen Tyoꞌtsꞌon jñꞌoon na coxenhanꞌ ꞌoꞌ, majoꞌ ꞌoꞌ coꞌndyehoꞌ joohanꞌ chaꞌ ninncyaahanꞌ na nnanꞌquindëhoꞌ costumbre na tquen nnꞌan, chaꞌ ntyja ꞌnaanꞌ na cotmanhoꞌ vaso yo nguaa jaro yo nguaa ncjo yo vendyechen nnon ꞌnan na itsijonhanꞌ joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mantyi tsontyichen jon ndëëhan: —Conanꞌtiuhoꞌ na njon jndyi contꞌahoꞌ na conanꞌquindëhoꞌ joo jñꞌoon na tquen ndochihoꞌ na tomꞌan ndyu na toxenꞌchen. Majoꞌ tanin min na tyiꞌquitaꞌngueeꞌhoꞌ juu jñꞌoon na iquen nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Chaꞌna juu jñꞌoon na sinin Moisés, na itsohanꞌ: “Quitsaꞌ na njon tyeꞌ yo ꞌndyoꞌ.” Ndoꞌ mantyi tso jon: “Minꞌcya ro tsꞌan na itsinin jñꞌoon tsanꞌ nnon tye, ndyee juu, quinanꞌcueeꞌ nnꞌanhin.” ");
INSERT INTO azgNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Majoꞌ ꞌoꞌ conduehoꞌ tanin min xe na aa ngitso tsꞌan nnon tye juu yo ndyee juu: “Ndiquindëë na ntejndei ꞌuꞌ yo ꞌnan na icanhanꞌ ꞌuꞌ, ngꞌe ꞌnan na manachö tsixuanhanꞌ Corbán.” Juu jñꞌoon Corbán itsiquindyihanꞌ ꞌnan na jndë tyincyaa tsꞌan cüentaaꞌ juu tsꞌian ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Majoꞌ ꞌoꞌ na conduihoꞌ tmaanꞌ fariseos, min xe na aa itsitjahanꞌ ꞌnan nquii tye tsꞌan oo ndyee juu, ꞌoꞌ taninꞌncyahoꞌ na ntejndei tsanꞌñeen tye juu oo ndyee juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ndoꞌ na contꞌahoꞌ na nndaꞌ, itsꞌaahanꞌ na juu jñꞌoon na tquen nquii Tyoꞌtsꞌon, veꞌ jnꞌaanhanꞌ ngꞌe vandyaꞌ tsiquindyi joo costumbre na conanꞌvehoꞌ. Ndoꞌ jndyechen nnon ꞌnan min na contꞌahoꞌ na itsijonhanꞌ joohanꞌ chaꞌna jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ndoꞌ tꞌman nndaꞌ Jesús nnꞌan, tso jon ndëëhan: —Tsoñꞌenhoꞌ quindyehoꞌ jñꞌoon na matsjö, ndoꞌ cüaaꞌ nꞌonhoꞌ joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ꞌNan na icüaꞌ tsꞌan, tyiꞌxeꞌquitsijiꞌuahanꞌhin na tonnon Tyoꞌtsꞌon. Majoꞌ joo jñꞌoon na itsitiu juu quiiꞌ tsꞌon juu, joohanꞌ contꞌa na tyiꞌjiꞌuahin na tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Juu tsꞌan na ninꞌcüaaꞌ tsꞌon jñꞌoon na matsjö, quen ya juu cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jndë na jntyꞌii Jesús joo nanꞌñeen, tja ntcüeꞌ jon vꞌaa. Ndoꞌ xjen na mꞌaan jon quiiꞌ vꞌaa, yajoꞌ nque nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon, taxeeꞌhan nnon jon nin ꞌnan itsiquindyi juu jñꞌoonꞌñeen na tyíꞌquitso nquiiꞌ jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ndoꞌ tꞌa jon, tso jon ndëëhan: —¿Aa mantyi itsijonhanꞌ ꞌoꞌ chaꞌna joo nanꞌñeen? ¿Aa tyíꞌcüaaꞌ nꞌonhoꞌ juu jñꞌoonꞌñeen? Tachi ꞌnan na icüaꞌ tsꞌan na iquenhanꞌhin na tyiꞌjiꞌuahin na tonnon Tyoꞌtsꞌon, ");
INSERT INTO azgNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ngꞌe chito quityquiiꞌ ñuaanꞌ juu coꞌohanꞌ, quityquiiꞌ tsiaaꞌ juu covahanꞌ, ndoꞌ ndë joꞌ vja juu ꞌndyo jndëë. Ndoꞌ yo juu jñꞌoonvahin tsiꞌman Jesús na tajnan tsixuan tsꞌan na veꞌ ncüii nnon ꞌnan icüaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ndoꞌ tsontyichen jon: —Joo jñꞌoon na itsitiu tsꞌan quiiꞌ tsꞌon juu, joohanꞌ contꞌa na tyiꞌjiꞌuahin na tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ee quiiꞌ tsꞌon tsꞌan conan natyia na itsitiu juu, chaꞌna veꞌ ninꞌcꞌoon ya juu yo ncüiichen tsanscu, oo na ninꞌcꞌoon juu yo tsanscuntjaaꞌ, ndoꞌ aa na ntscueeꞌ juu tsꞌan, ");
INSERT INTO azgNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Ndoꞌ aa na ichꞌuee juu ꞌnaanꞌ tsꞌan, ndoꞌ aa ninꞌcyꞌoon juu ꞌnaanꞌ ncüiichen tsꞌan na nndiꞌnaanꞌ juuhanꞌ, ndoꞌ na itsꞌaa viꞌ juu nnꞌan, ndoꞌ na itsiviꞌnnꞌan juu ntyje juu, ndoꞌ joo jñꞌoon na icoꞌxenhanꞌ, min tyiꞌquitsꞌaa juu na njonhanꞌ, ndoꞌ na itsitëëꞌ tsꞌon juu ntyje juu, ndoꞌ tyia jñꞌoon itsinin juu nacjooꞌ ncüiichen tsꞌan, ndoꞌ na itsitiu nquii juu na tꞌmanchen conduihin, ndoꞌ na veꞌ tsitsanꞌto juu xquen juu yo ꞌnan na itsꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tsoñꞌen natyiaminꞌ, quiiꞌ tsꞌon tsꞌan conanhanꞌ, ndoꞌ ntyja ꞌnaanꞌ joohanꞌ na coninjndaꞌ na vaa jnaanꞌ juu na tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jnduiꞌ ntcüeꞌ Jesús juu tsjoonꞌñeen naijon na toninncyaa jon jñꞌoon. Tja jon, tueeꞌ jon ndyuaa Tiro yo Sidón. Ndoꞌ tueeꞌ jon vaaꞌ ncüii tsꞌan juu tsjoonꞌñeen, min tyíꞌquintꞌue tsꞌon jon na ncüaaꞌ nꞌon nnꞌan na tyjeeꞌ jon joꞌ. Majoꞌ min na nndaꞌ, ticꞌuaa jñꞌoon na joꞌ jndë mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Juu tsjoonꞌñeen tomꞌaan ncüii tsanscu na mꞌaan jnda juu, yuꞌñeen yuscuhin na nayꞌoon jndyetyiahin. Ndoꞌ juu ndyee yuscu chjoꞌñeen, vi na jndë jndyii juu ntyja ꞌnaanꞌ Jesús, sityuaaꞌ juu na tja juu naijon na tueeꞌ jon. Ndoꞌ xjen na tueeꞌ juu na mꞌaan jon, tëcoꞌxtye juu tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Majoꞌ tachi tsꞌan judíohin, jñonꞌndaa griego itsinin tsanscuꞌñeen, tuihin tsjan nnꞌan ndyuaa Sirofenicia. Ndoꞌ vi na jndë tyjeeꞌ juu na mꞌaan Jesús, tcan juu na cüjiꞌ jon juu jndyetyiaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Majoꞌ tꞌa Jesús, juu jñꞌoon na sinin jon nnon tsanscuꞌñeen, tyiꞌquitso nquiiꞌhanꞌ. Itso jon: —Chuhanꞌ na quitejndei jndyëë nnꞌan na ninncüii tsjan conduihan yo ja, chito nnꞌan na mañoon ndyuaa. Ngꞌe tyiꞌquichuhanꞌ na ntyjee tsꞌan ꞌnan na cocüaꞌ ntsinda juu ndoꞌ na ncjuꞌ juuhanꞌ ndëë quindueꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ndoꞌ juu tsanscuꞌñeen, mantyi sintcüeꞌ juu jñꞌoon nnon Jesús na tyiꞌquitso nquiiꞌhanꞌ, tso juu: —Mayuuꞌ ta yo juu jñꞌoon na tsuꞌ, majoꞌ joo quindëꞌhinꞌ veꞌ ꞌnan quijndë na cocyaa tyuaa na cocüaꞌ yotsca, juuhanꞌ cojñenꞌ oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ndoꞌ joꞌ tꞌa Jesús, itso jon: —Ya jndyi jñꞌoon na sintcüeꞌ. Nanein, cjaꞌ ntcüeꞌ vaꞌ. Juu yuscu chjo jndaꞌ, jndë jnduiꞌ jndyetyia quiiꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ndoꞌ xjen na tueeꞌ ntcüeꞌ juu tsanscuꞌñeen vaaꞌ juu, ntjii juu yuscu chjoꞌñeen na vaa juu cjooꞌ jndu, jndë jnꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jnduiꞌ ntcüeꞌ Jesús ndyuaa Tiro, tenon jon ndyuaa Sidón, tancyaa jon ntyeeꞌ juu ndyuaa njoon Decápolis. Tueeꞌ nndaꞌ jon juu ndaandue Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ndoꞌ joꞌ jndyoyꞌon nnꞌan ncüii tsꞌan quitaaꞌ ndoꞌ ncheeꞌhin na mꞌaan Jesús. Nnꞌan na mꞌan joꞌ, tanhan na quityio jon ntꞌö jon cjooꞌ tsanꞌñeen chaꞌ nꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ndoꞌ tëyꞌoon Jesús juu tsanꞌñeen vi ntyja naijon na ninnquii jon yohin. Tuii jon ndëë ntꞌö jon ndëꞌnqui juu, vi jndë joꞌ tjiꞌ jon ndaa ꞌndyo jon, ndoꞌ tyu jonhanꞌ nnon tsa juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ndë joꞌ jndondë jon toquiñoonꞌndue, tcan jon vi naya nnon nquii Tyoꞌtsꞌon. Sinin jon yo jñonꞌndaa ꞌnaanꞌ jon, tso jon: —“Efata.” Juu jñꞌoonvahin itsiquindyihanꞌ na ncyaa nndaꞌhanꞌ na ya ndyii juu yo na ya ntsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ndoꞌ majuuntyi xjenꞌñeen jnaan ndëꞌnqui tsanꞌñeen, mantyi ntjo ya ntcüeꞌ na itsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Xjen na tja nndaꞌ Jesús yo tsanꞌñeen naijon na mꞌan nnꞌan, yajoꞌ siquiꞌmaanꞌ jon joohan na minꞌncüii nnon tsꞌan tyiꞌnanꞌmanhan ntyja ꞌnan na sꞌaa jon. Majoꞌ tajntꞌahan na njon juu jñꞌoonꞌñeen na tso jon, ee ndoꞌvanjan tonanꞌneinhan ntyja ꞌnaanꞌ juu tsꞌian tꞌmanꞌñeen na sꞌaa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tꞌman jndyi vaa na tëveeꞌ ngiohan, jnduehan ndëë ntyjehan: —Va ya jndyi itsꞌaa jon. Nque nnꞌan quita, itsinꞌman jonhan na ya condye nndaꞌhan, ndoꞌ joo nnꞌan ncheeꞌ, mantyi itsinꞌman jonhin na ya conanꞌnein nndaꞌhan.” ");
INSERT INTO azgNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Xjenꞌñeen jndye jndyi nnꞌan jndë tëncüi naijon na mꞌaan Jesús. Ndoꞌ juu xjenꞌñeen, sitjahanꞌ ꞌnan na ntcüaꞌhan. Mangꞌe joꞌ tꞌman jon joo nnꞌan na totsayꞌon yo juu jñꞌoon na toninncyaa jon, tso jon ndëëhan: ");
INSERT INTO azgNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Ntyꞌia ro nanminꞌ nchji ngꞌe naneinhin jndë ndye xuee na conanꞌjonhan na condyehan juu jñꞌoon na mancya, ndoꞌ ꞌnan na jndyochohan na ntcüaꞌhan, jndë jndyuehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ndoꞌ xe na aa njñönhan na cꞌo ntcüeꞌhan ntꞌaahan na ninvaa ninꞌjndoꞌhan, nndëë ntsꞌaahanꞌ na ntsiꞌndaaꞌhanꞌ nquenhan ndoꞌ ntycyaahan nato ngꞌe ñꞌenhan na tycya chjo na jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ndoꞌ joo nnꞌan na totsayꞌon jñꞌoon yo jon, tꞌahan, jnduehan: —¿Nchu ntꞌá na nninncyá ꞌnan ntcüaꞌ nanminꞌ ntjoohin? Ee ntjoo taꞌnan nnꞌan cꞌoon na nndëëhan ꞌnan. ");
INSERT INTO azgNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Taxeeꞌ Jesús ndëëhan: —¿Tsaꞌnndaꞌ tyooꞌ yꞌonhoꞌ? Tꞌahan, jnduehan: —Ninntyqueꞌ tanꞌ tyooꞌ yꞌö́n. ");
INSERT INTO azgNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ndoꞌ tso jon ndëë nnꞌan na jndye jndyiꞌhin: —Cꞌuhoꞌ tyuaa. Ndë joꞌ tyꞌoon jon joo ntyqueꞌ tanꞌ tyooꞌñeen, ndoꞌ vi jndë joꞌ, tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ, ndë joꞌ tjiꞌ jon xjen ntanꞌhanꞌ. Ndë tyincyaa jonhanꞌ ndëë nque nnꞌan na totsayꞌon jñꞌoon yohin, ndoꞌ joohan tꞌonhinhanꞌ ndëë joo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ndoꞌ mantyi yꞌonhan vendye quintcaa quijndë. Mantyi tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanhanꞌ. Ndë joꞌ mantyi tyincyaa jon quintcaaꞌñeen ndëë nanꞌñeen na quitꞌonhan joohanꞌ ndëë nnꞌan na jndye jndyiꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ndoꞌ tsoñꞌen nanꞌñeen tcüaꞌ tëcjohan, ndoꞌ ndë joꞌ nque nanꞌñeen na totsayꞌonhan jñꞌoon yo Jesús, jnanꞌquitooꞌhan chaꞌ vi ntyqueꞌ tsque yo tyooꞌ ntanꞌ na jntyꞌiihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ndoꞌ joo nnꞌan na tcüaꞌ joꞌ, tueeꞌ chaꞌna ninque minhan. ");
INSERT INTO azgNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ndoꞌ vi jndë joꞌ tso jon ndëë nanꞌñeen, ya xe na ncꞌo ntcüeꞌhan ngꞌe jndë mavja jon. Ndoꞌ tua nndaꞌ jon vꞌaandaa yo nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon. Tyꞌehan, squehan ndyuaa na jndyu Dalmanuta. ");
INSERT INTO azgNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ndoꞌ vendye nnꞌan tmaanꞌ fariseos squehan na mꞌaan Jesús. Taꞌhan tonanꞌjndyehan jndyuehan yo jon na quitsꞌaa jon ncüii nnon tsꞌian na ntsiꞌmanhanꞌ na nquii Tyoꞌtsꞌon tꞌua tsꞌian nnon jon. Ee cojntꞌuehan na quityiiꞌhanꞌ ngꞌeehanꞌhin ntyja ꞌnaanꞌ jñꞌoon na itsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yajoꞌ jndyo ncüii na ton tsꞌon jon na sichjooꞌhanꞌ tsꞌon jon ntyja ꞌnaanhan. Itso jon: —Nque nnꞌan na mꞌan naneinhin, ¿Ndu na ntꞌue nꞌonhan na quitsꞌa ncüii nnon tsꞌian na njntyꞌiahan na ntsiꞌman jndyoyuhanꞌ na nquii Tyoꞌtsꞌon iꞌua jon tsꞌian nnön na jndyö? Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tyiꞌjeꞌquitsꞌa ncüii na ntsiꞌmanhanꞌ na nquii jon ncyaa na tꞌman condui ja. ");
INSERT INTO azgNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Yajoꞌ jntyꞌii jon joo nanꞌñeen. Ndoꞌ tua nndaꞌ jon vꞌaandaa, tetꞌio nndaꞌ jon ndaandueꞌñeen. Tueeꞌcya jon ncüiichen ixndyaaꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ndoꞌ nque nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa Jesús, juu xjen na tuahan vꞌaandaa, tsuuꞌ tycya nꞌonhan na ntsayꞌonhan tyooꞌ na ntcüaꞌhan, chaꞌ veꞌ ninncüiito tyooꞌ na sayꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yajoꞌ siquiꞌmaanꞌ jon joohan na tyiꞌnanꞌjonhan yo ꞌnantyia na nanꞌxuan nnꞌan tmaanꞌ fariseos. Tso jon: —Nnꞌan fariseos yo nnꞌan tmaanꞌ cüentaaꞌ Herodes, vaa ncüii nnon ntyja ꞌnaanhan na itsijonhanꞌ juuhanꞌ chaꞌvijon tsquentë. Quitquenhoꞌ cüenta na juu ꞌnatyia nanꞌxuanhan tyiꞌncüꞌaahanꞌ ꞌoꞌ na ntsiꞌndaaꞌhanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ndoꞌ na tso jon na nndaꞌ, joo nanꞌñeen na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, tyeꞌ na jnduehan ndëë ntyjehan: —Ndöꞌ vaa na itso jon ndëë tsojnaanꞌ na tsuuꞌ tycya nnꞌön na ndyoyꞌön tyooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Majoꞌ taaꞌ tsꞌon Jesús na nndaꞌ vaa na conanꞌtiuhan na itsinin jon ntyja ꞌnaanꞌ tyooꞌ. Majoꞌ chito joꞌ, itsiquindyi jonhan ntyja ꞌnaanꞌ ꞌnantyia na nanꞌxuan nnꞌan tmaanꞌ fariseos yo nnꞌan tmaanꞌ cüentaaꞌ Herodes. Yajoꞌ tsontyichen jon ndëëhan: —¿Ndu na conanꞌneinhoꞌ na tatyooꞌ jndyoyꞌonhoꞌ? ¿Aa tyiꞌcovaaꞌ nꞌonhoꞌ, ndoꞌ aa min tyiꞌquitquenhoꞌ cüenta? ꞌOꞌ, ¿Aa ninvaa mꞌanhoꞌ na conanꞌtsanhoꞌ ñuan ꞌnaanhoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ꞌOꞌ na min tëndëëhoꞌ, ¿Aa tyiꞌcojntyꞌiahoꞌ? ꞌOꞌ na min ndëꞌnquihoꞌ, ¿Aa tyiꞌcondyehoꞌ? ¿Ndoꞌ aa tyiꞌcañjoonꞌ nꞌonhoꞌ nin ꞌnan sꞌa xjen na sitjahanꞌ ꞌnan na ntcüaꞌ nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Juu xjen na sꞌa xjen ntanꞌ joo ꞌon tanꞌ tyooꞌ na tꞌonhoꞌhanꞌ ndëë ꞌon min nnꞌan, ¿Tsaꞌnndaꞌ tsque na jnanꞌquitooꞌhoꞌ yo ntanꞌ quijndë na jntyꞌiihanꞌ? Tꞌahan, jnduehan nnon jon: —Jnanꞌquitꞌö́ nchoꞌve tsquehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ndoꞌ juu xjenꞌñeen na sꞌa xjen ntanꞌ joo ntyqueꞌ tyooꞌ na tꞌonhoꞌ na tcüaꞌ ninque min nnꞌan, ¿Tsaꞌnndaꞌ tsque na jnanꞌquitooꞌhoꞌ yo ntanꞌ quijndë na jntyꞌiihanꞌ? Tꞌa nanꞌñeen, jnduehan: —Jnanꞌquitꞌö́ ntyqueꞌ tsquehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ndoꞌ tso jon ndëëhan: —Ndoꞌ na nndaꞌ vaa, joo tsꞌian tꞌman na matsꞌa, ¿Ndu na ndicüaaꞌ nꞌonhoꞌ nin tsꞌan condui ja? ");
INSERT INTO azgNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Ndë joꞌ nquii Jesús yo nnꞌan na totsayꞌonhan yo jñꞌoon toninncyaa jon, squehan tsjoon Betsaida. Ndoꞌ joo nnꞌan tsjoonꞌñeen tyeyꞌonhan ncüii tsannchjaanꞌ na mꞌaan jon. Tanhan na quityio jon chjo ntꞌö jon cjooꞌ tsanꞌñeen chaꞌ nꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ndoꞌ tꞌuii Jesús ntꞌö tsanꞌñeen, tëyꞌoon jonhin ꞌndyo tsjoon naijon na ninnquii jon yohin. Tyu jon ndaaꞌndyo jon ndöꞌnnon juu. Ndë joꞌ tyio jon ntꞌö jon ndöꞌnnon juu, ndoꞌ taxeeꞌ jon nnon juu: —¿Aa jndë ya chjo mandyiaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ndoꞌ ya na jndondë tsannchjaanꞌñeen, itso juu: —Mantyꞌia nnꞌan, veꞌ itsijonhanꞌ na mantyꞌia joohan chaꞌvijon na contsjë nꞌoon. ");
INSERT INTO azgNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yajoꞌ tyio nndaꞌ Jesús ntꞌö jon ndöꞌnnon juu tsanꞌñeen. Ndoꞌ jndë na sꞌaa jon na nndaꞌ, tyincyaahanꞌ na xuee jndyi jndyiaaꞌ juu, tcoꞌ ya ntcüeꞌhanꞌhin. Min ꞌnan na tycya, majoꞌ ya jndyiaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jndë joꞌ jñon ntcüeꞌ Jesús juu na cja juu. Itso jon nnon juu: —Cjaꞌ vi tovaꞌ, min tyiꞌngaqueꞌ quiiꞌ tsjoon, min tyiꞌntsininꞌ ndëë nnꞌan ntyja ꞌnaanꞌ juu naya na sꞌa ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jndë joꞌ juu Jesús yo nnꞌan na totsayꞌon jñꞌoon yohin, tyꞌehan, squehan ndyuaa Cesarea Filipo. Ndoꞌ xoncüe na ñjonhan nato, taxeeꞌ jon ndëëhan, itso jon: —Ntyja njan ja, ¿Nin tsꞌan na condue nnꞌan na condui ja? ");
INSERT INTO azgNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Tꞌa nanꞌñeen, jnduehan: —Ñꞌen nnꞌan na conduehan na ꞌuꞌ condui Juan, tsan na totsiquindëëꞌ nnꞌan, na vandoꞌ xco juu. Ndoꞌ vendyechen nnꞌan conduehan na ꞌuꞌ condui nquii Elías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen. Ndoꞌ mantyi mꞌan nnꞌan na conduehan na condui ꞌuꞌ ncüii nque nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Joꞌ taxeeꞌ jon ndëëhan, itso jon: —Ndoꞌ ꞌoꞌ jeꞌ, ¿Nin conduehoꞌ na condui ja? Tꞌa Pedro, itso jon: —ꞌUꞌ condui nquii Cristo na iꞌua Tyoꞌtsꞌon tsꞌian nnonꞌ na ntsinꞌmanꞌ ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ndoꞌ jaaꞌ jñꞌoon na tso jon ndëëhan na minꞌncüii nnon tsꞌan tyiꞌnanꞌneinhan na nndaꞌ vaa na conduihin. ");
INSERT INTO azgNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jndë joꞌ taꞌ Jesús na itsiꞌman jon ndëë nque nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon, na juu jon na conduihin tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na coꞌxen jon tsoñꞌen nnꞌan, chuhanꞌ na jndye naviꞌ ngenon jon. Nque nnꞌan na conintque ndëë nnꞌan judíos ntꞌahan na tyiꞌcueeꞌ nꞌonhan jon, ndoꞌ majoꞌntyi ntꞌa joo nnꞌan na conintque ndëë ntyee ꞌnaanhan, ndoꞌ maninꞌ yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés. Itso Jesús na nnanꞌcueeꞌ nanꞌñeenhin, majoꞌ xee na jndë ndye na jnanꞌcueeꞌhan jon, ngüandoꞌ xco jon. ");
INSERT INTO azgNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sinin jndyoyu jon jñꞌoonꞌñeen ndëë nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon. Majoꞌ vi na jndë jndyii Pedro na nndaꞌ, sꞌaa juu vi ntyja yohin. Siquiꞌmaanꞌ jon Jesús. Itso juu nnon jon: —Tyiꞌquichuhanꞌ na ngenoonꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Majoꞌ nquii Jesús, vi na jndë jndyii jon na tso Pedro na nndaꞌ, joꞌ tequen jon, jndyiaaꞌ jon tontyja na ntjo joo nnꞌan na totsayꞌon yo juu jñꞌoon na toninncyaa jon, jaaꞌ jñꞌoon na sinin jon nnon Pedro na siquiꞌmaanꞌ jonhin, itso jon: —ꞌUꞌ Satanás, quenanꞌ ꞌuꞌ nnön. ꞌUꞌ Pedro, tachi chaꞌxjen ndyiiꞌ tsꞌon nquii Tyoꞌtsꞌon na ndyiiꞌ tsonꞌ, ꞌuꞌ chaꞌxjen na conanꞌtiu nnꞌan, joꞌ matsijon ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Yajoꞌ tꞌman Jesús nnꞌan na totsayꞌon jñꞌoon yohin yo tsoñꞌen nnꞌan na mꞌan joꞌ. Itso jon ndëëhan: —Minninchen tsꞌan na ninꞌquitsijonhin ntyja na matsixuan, icanhanꞌ na cüji nquiihin nchu vaa na ntꞌue tsꞌon juu, ndoꞌ cꞌoon juu na quintjo ya nchjii juu yo naviꞌ na ngenon juu ngꞌe na mꞌaan juu ntyja njan, min xe na aa ntyja ꞌnaanꞌ joꞌ nnanꞌcueeꞌ nnꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ndoꞌ minninchen tsꞌan na itsichon nquii juu na ngüandoꞌ ñuaanꞌ juu ntyja ꞌnaanꞌ juu, conduihin tsꞌan na jndë tsuhin. Majoꞌ minninchen tsꞌan na cotjiꞌ nnꞌan cüenta na cotsu naya ꞌnaanꞌ juu ngꞌe na incyaa juu jñꞌoon naya njan ndëë nnꞌan, juu tsanꞌñeen vaa naya ꞌnaanꞌ juu na tyiꞌxeꞌquintycüii na ngüandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tanin min xe na aa ninvaa tsonnangue cuaahanꞌ na ꞌnaanꞌ tsꞌan, majoꞌ min na nndaꞌ ¿Yuu vaa naya ꞌnaanꞌ juu xe na aa ngitsu ñuan ꞌnaanꞌ juu? ");
INSERT INTO azgNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ee taꞌnan cüii nnon ꞌnan na nndëë nninncyaa tsꞌan nnon Tyoꞌtsꞌon na juuhanꞌ ngüañoonꞌhanꞌhin na tyiꞌngitsu ñuan ꞌnaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mꞌan nnꞌan na tyiꞌnjon Tyoꞌtsꞌon ngiohan ndoꞌ na nanꞌxuanhan jnan. Minninchen tsꞌan na jnaanꞌ juu tondëë nanꞌñeen ngꞌe na mꞌaan juu ntyja njan yo ntyja ꞌnaanꞌ juu jñꞌoon naya njan, mantyi ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, ncꞌön na jnꞌan yo tsanꞌñeen xjen na nndyö nntꞌa yo juu najndei na condui nquii Tyëhöꞌ ndoꞌ yo nque ángeles na cotyentjon nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ndoꞌ tsontyichen Jesús ndëëhan: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, quiiꞌ ntꞌanhoꞌ mꞌan ntyjehoꞌ na tyiꞌjeꞌcüjehan ata vi na jndë jntyꞌia ndëëhan na jndë tyjeeꞌ Tyoꞌtsꞌon na ntyeꞌntjon jon nnꞌan ꞌnaanꞌ jon yo juu najndei na conduihin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Taca yon xuee na jndë tso Jesús na nndaꞌ, ndoꞌ tëyꞌoon jon Pedro, Jacobo yo ninꞌJuan. Tyevahan ncüii tyoꞌ ndye naijon na ninnquehan. Xjenꞌñeen jntyꞌiahan na siñoonhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ndoꞌ juu ndiaaꞌ jon, maninꞌ condui nduiꞌhanꞌ, ndoꞌ quichiꞌtyenhanꞌ chaꞌvijon tein. Minꞌncüii tsꞌan tsonnangue jeꞌquindëë ntsiquichiꞌ ndiaa chaꞌxjen quichiꞌ ndiaaꞌ jon juu xjenꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ndoꞌ joꞌ joo ndye nanꞌñeen jntyꞌiahan na tyjeeꞌ nquii Elías yo ninꞌMoisés, na jnanhan quiñoonꞌndue, na jnanꞌnein nanꞌñeen yo nquii Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ndoꞌ joꞌ tso Pedro nnon Jesús: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndë́, vaa ya jndyi vaa na mꞌán ntjoohin. Nnanꞌyá ndye xqueꞌ ncüanꞌ, ncüiihanꞌ cüentaꞌ, cüiichenhanꞌ cüentaaꞌ nquii Moisés, ndoꞌ ncüiichenhanꞌ ninꞌcüentaaꞌ juu Elías. ");
INSERT INTO azgNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ndöꞌ vaa jñꞌoon na tso jon ngꞌe ndicüaaꞌ tsꞌon jon nin jñꞌoon ngitso jon ee mioon jndyi tyuehan. ");
INSERT INTO azgNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ndoꞌ juu xjenꞌñeen tyioo ncüii chincyu nacjohan, ndoꞌ quityquiiꞌhanꞌ, joꞌ ticꞌuaa jndyeeꞌ nquii Tyoꞌtsꞌon, tso jon: —Juu tsanvahin conduihin jnda na viꞌnchji jndyihin. Quitquenhoꞌ cüenta jñꞌoon na ngitso jon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ndoꞌ xjen na jntyꞌia nanꞌñeen xiꞌjndio, minꞌncüii tsꞌan tavi cꞌoon, ninnquiintyi Jesús na vi mꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ndoꞌ viochen xjen na tyecuehan juu tyoꞌñeen, tso jon ndëëhan: —Minꞌncüii nnon tsꞌan tyiꞌnanꞌneinhoꞌ ꞌnan na jntyꞌia ndëëhoꞌ quichen. Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, vi na jndë jnanꞌcueeꞌ nnꞌan ja, ndoꞌ ya na jndë vantꞌö xcö, juu xjenꞌñeen vanaan na nnanꞌneinhoꞌ ntyja ꞌnaanꞌ juu ꞌnan na jntyꞌia ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ndoꞌ nanꞌñeen, jnanꞌvehan juu jñꞌoonꞌñeen. Ndoꞌ majuuntyi xjenꞌñeen, taꞌxeeꞌhan ndëë ntyjehan nin ꞌnan ninꞌquitsiquindyihanꞌ na tso jon na ngüandoꞌ xco jon vi na jndë jnanꞌcueeꞌ nnꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ya joꞌ taxeeꞌhan nnon jon, jnduehan: —Nque nnꞌan na conanꞌman nchu vaa na itsiquindyi juu jñꞌoon na tquen Moisés, conduehan na juu Elías ncüjeeꞌ jndyee, ndoꞌ ndë joꞌ ncüjeeꞌ nquii Cristo. ¿Nchu vaa na conduehan na nquii Elíasꞌñeen ncüjeeꞌ jndyee jon? ");
INSERT INTO azgNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Joꞌ tꞌa Jesús jndyuehan, tso jon: —Juu jñꞌoonꞌ Tyoꞌtsꞌon mayuuꞌ itsiquindyihanꞌ na ncüjeeꞌ ncüii tsꞌan na ntsixuan juu chaꞌxjen totsixuan nquii Elíasꞌñeen, ndoꞌ ntsꞌaa tsanꞌñeen na ntꞌa xco nnꞌan na njon Tyoꞌtsꞌon. Ndoꞌ mantyi juu jñꞌoon ꞌnaanꞌ jon itsiquindyihanꞌ na ja na condui tsansꞌa na iꞌua jon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, jndye naviꞌ ngenön. Ndoꞌ mantyi nntꞌahan na tyiꞌcueeꞌ nꞌonhan ja. ");
INSERT INTO azgNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Majoꞌ matsjö ndëëhoꞌ na mayuuꞌ jndë jndyo ncüii tsꞌan na totsixuan jon chaꞌxjen juu Elíasꞌñeen, ndoꞌ nque nnꞌan jndë jntꞌa viꞌhan jon ntyjantyi na ntꞌue nꞌonhan chaꞌxjen tsiquindyi juu jñꞌoonꞌ Tyoꞌtsꞌon na mancüiixjen ntꞌahan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ndoꞌ tja ntcüeꞌ Jesús yo ndye nanꞌñeen naijon mꞌan ntyjehan, nque nnꞌan na totsayꞌonhan jñꞌoon yo jon. Ndoꞌ vi na jndë squehan joꞌ, jntyꞌiahan na jndye jndyi nnꞌan na jndë tëncüi naijon na mꞌan nanꞌñeen. Quiiꞌ ntꞌanhan ñꞌen cüanntyi nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, conanꞌjndyehan jndyuehan yo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ndoꞌ nque nnꞌan na jndye jndyiꞌhin, xjen na jntyꞌiahan na ndyo Jesús, tëveeꞌ jndyi ngiohan, jnanꞌnonhan na tyequitjonhan jon na tyencyahan tsꞌonhin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yajoꞌ taxeeꞌ Jesús ndëëhan, tso jon: —¿Nin jñꞌoon na conanꞌjndyehoꞌ jndyuehoꞌ yo joo ntyjë na cotsayꞌonhan jñꞌoon yo ja? ");
INSERT INTO azgNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ncüii tsꞌan na mꞌaan quiiꞌ ntꞌan nnꞌan juu tmaanꞌñeen, tꞌa juu, tso juu: —Nndaꞌ ta, ndö mꞌaan yusꞌa jnda na jndyoyꞌönhin na nayꞌoon jndyetyiahin na itscuꞌhanꞌ na ntsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndoꞌ minyuuchen na mꞌaan juu xjen na coveeꞌ xjen na itsijaaꞌhanꞌ, itsquioohanꞌhin, ndoꞌ conduiꞌ chonꞌ ꞌndyo juu, maninꞌ tsiquiꞌioonꞌ juu ndiꞌnꞌon juu, ndoꞌ ꞌndyiihanꞌhin vi na jndë sitsꞌoonhanꞌhin. Ndoꞌ jndë tcꞌan vi nayaꞌñeen ndëë nque nnꞌan na cotsayꞌonhan yo jñꞌoon na mancyaꞌ na quitjiꞌhan juu jndyetyiaꞌñeen, majoꞌ tana jndëë jntꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Joꞌ tꞌa Jesús jndyue nque nanꞌñeen na totsayꞌon jñꞌoon yo jon, tso jon: —ꞌOꞌ nnꞌan na tyiꞌcantyja nꞌonhoꞌ ja. Majndye xuee na mꞌan quiiꞌ ntꞌanhoꞌ na matsiꞌman ndëëhoꞌ. Jndye vaa na mꞌan na tꞌman tsꞌön ꞌoꞌ, majoꞌ min na nndaꞌ, ninjoꞌ tyiꞌcantyja nꞌonhoꞌ ja. ¿Tsaꞌnndaꞌ chu na icanhanꞌ na ncꞌön yo ꞌoꞌ chaꞌ ngantyja nꞌonhoꞌ ja? Quindyoyꞌonhoꞌ yusꞌahaꞌ ndöhin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ndoꞌ xjen na sayꞌonhanhin na mꞌaan Jesús, ndoꞌ vi na jndë jndyiaaꞌ juu jndyetyiaꞌñeen jon, yajoꞌ sꞌaa juu na siꞌndaaꞌhanꞌ xquen juu luꞌñeen, tyioohin tyuaa, totsiquityeeꞌñꞌenhin, ndoꞌ tonduiꞌ chonꞌ ꞌndyo juu. ");
INSERT INTO azgNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ndoꞌ joꞌ taxeeꞌ Jesús nnon tye juu: —Juu jndyetyiavahin, ¿Tsaꞌnndaꞌ xuee na jndë vja na nayꞌoonhanꞌhin? Ndoꞌ juu tye yusꞌachjoꞌñeen, tꞌa jon, tso jon: —Tyeꞌhanꞌ xjen na chjohin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ndoꞌ tijndye jnda na itsquioohanꞌhin quiiꞌ chon ndoꞌ quiiꞌ ndaa chaꞌ na ntscueeꞌhanꞌhin, majoꞌ xe na aa vaa na nndëë ntsaꞌ na ntejndeiꞌ já, cꞌonꞌ na ntyꞌiá rö́ nchjiꞌ na quitsinꞌmanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Joꞌ tꞌa Jesús ꞌndyo tye juu yuchjoꞌñeen, tso jon: —Tyiꞌya tsuꞌ xe na aa vaa na nndëë ntsꞌa, ee minꞌcya ro tsꞌan na vantyja tsꞌon nquii Tyoꞌtsꞌon, tsoñꞌen ꞌnan na ican juu nnon jon, nndëë ntsꞌaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yajoꞌ juu tye yuchjoꞌñeen, jndei ticꞌuaa ꞌndyo jon, tso juu: —Vantyja tsꞌön Tyoꞌtsꞌon, majoꞌ quitejndeiꞌ ja ntyja na ndicantyja tsꞌön chaꞌxjen na icanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ndoꞌ Jesús, xjen na tquen jon cüenta na jndye nnꞌan vancüi joꞌ, ninñoonꞌ sityiaꞌ jon juu jndyetyiaꞌñeen. Tso jon nnon juu: —ꞌUꞌ yutyia na tyiꞌninꞌncyaꞌ na ndyii yuvahin, min na ntsinin juu, quinduiꞌ quiiꞌ tsꞌon juu, matavi xuee na ngaqueꞌ nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Yajoꞌ sꞌaa jndyetyiaꞌñeen na jndei sixuaa juu, ji vaa jndyi na siꞌndaaꞌhanꞌ xquen juu yusꞌaꞌñeen, ndë joꞌ jnduiꞌhanꞌ. Majoꞌ jntyꞌiihanꞌhin chaꞌvijon tsꞌoohin, ata jndye nnꞌan na mꞌan joꞌ jnduehan: —Jndë tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Majoꞌ nquii Jesús tꞌuii jon vi ntyjaaꞌ ntꞌö juu lu chjoꞌñeen, tejndei jonhin na tacüentyjeeꞌ juu, ndoꞌ jnanquintyja juu. ");
INSERT INTO azgNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ndoꞌ vi na jndë tëqueeꞌ Jesús cüii vꞌaa yo nnꞌan na totsayꞌonhan yo jñꞌoon yo jon, taꞌxeeꞌhan nnon jon, jnduehan: —¿Ndu na tyíꞌquindëë ntjíꞌ juu jndyetyiaꞌñeen quiiꞌ tsꞌon yusꞌaꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ndoꞌ tꞌa Jesús jndyuehan, tso jon: —Chaꞌ nndëë ntjiꞌhoꞌ jndyetyiaminꞌ, icanhanꞌ na quinanꞌneinhoꞌ nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ndoꞌ jnduiꞌ Jesús joꞌ yo nque nanꞌñeen na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon. Sacüenonhan juu ndyuaa Galilea. Ndoꞌ tyiꞌquintꞌue tsꞌon Jesús na ncüaaꞌ nꞌon nnꞌan yu vaato ntyja vja jon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ngꞌe itsiꞌman jon ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon. Tso jon: —Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, nninncyaa tsꞌan cüenta ja nduee nnꞌan, ndoꞌ joo nanꞌñeen nnanꞌcueeꞌhan ja, majoꞌ xee na jndë ndye na tꞌiö, ngüantꞌö xcö. ");
INSERT INTO azgNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Majoꞌ joo nanꞌñeen na totsayꞌonhan yo jñꞌoon na toninncyaa jon, taꞌnan taaꞌ nꞌonhan juu jñꞌoonꞌñeen, ndoꞌ ncyaahan na ntaꞌxeeꞌhan nnon jon nin tsiquindyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesús yo nnꞌan na totsayꞌonhan jñꞌoon yo jon sque nndaꞌhan Capernaum. Ndoꞌ vi na jndë na tequeꞌhan ncüii vꞌaa, taxeeꞌ jon ndëëhan: —Nato na tincyö, ¿Nin jñꞌoon jnanꞌjndyehoꞌ jndyuehoꞌ yo ntyjehoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ndoꞌ joꞌ chen tui jndyuehan, ee nato na ñjonhan, jnanꞌjndyehan jndyuehan yo ntyjehan nin ncüii nquehan na nnduiꞌ juu na njonchen conduihin quiiꞌ ntꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yajoꞌ tëcjo Jesús. Tꞌman jonhan na quinanꞌndyooꞌhan na ndyehan jñꞌoon. Tso jon: —Minꞌcya ro tsꞌan na ntꞌue tsꞌon na njonchen na nnduihin, quitsindyiaꞌ tsꞌon juu ndoꞌ quitejndei juu tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ndë joꞌ tyꞌoon jon ncüii yuchjo, tcoꞌ jonhin xoncüe quiiꞌ ntꞌanhan, chu jonhin. Tso jon ndëëhan: ");
INSERT INTO azgNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Minninchen tsꞌan na yo na ya ntyjii juu na ncyꞌoon juu cüenta ncüii yuchjo, mantyi iyꞌoon juu cüenta ja yo na ya ntyjii juu. Ndoꞌ minꞌcya ro tsꞌan na iyꞌoon juu cüenta ja, mantyi iyꞌoon juu cüenta nquii jon na jñon jon ja quiiꞌ ntꞌan nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ndoꞌ tso Juan nnon Jesús: —Nndaꞌ ta, jntyꞌiá ncüii tsꞌan na icüjiꞌ juu xueꞌ chaꞌ quinduiꞌ jndyetyia quiiꞌ nꞌon nnꞌan. Ndoꞌ jnduë́ nnon juu na tavi ntsꞌaa juu na nndaꞌ ngꞌe tyiꞌcayꞌoon juu jñꞌoon yo jaa. ");
INSERT INTO azgNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Majoꞌ tꞌa Jesús jndyuehan, tso jon: —Tyiꞌnduehoꞌ na tantsꞌaa juuhanꞌ, ngꞌe tsꞌan na jndë sꞌaa ncüii tsꞌian tꞌman yo xuë, tyiꞌjeꞌquitsꞌaahanꞌ na quintyjachen ntsinin juu jñꞌoon tyia nacjö. ");
INSERT INTO azgNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ngꞌe juu tsꞌan na tyiꞌitsuehin nacjö, juu tsanꞌñeen mꞌaan jon ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ndoꞌ minꞌcya ro tsꞌan na nninncyaa juu ncüii vaso ndaa na ncüehoꞌ ngꞌe na conduihoꞌ cüenta ja, nquii Tyoꞌtsꞌon ndyion juu tsanꞌñeen naya na sꞌaa juu ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Minꞌcya ro tsꞌan na ntsiꞌman juu nnon ncüiichen tsꞌan na chjo na vantyja tsꞌon juu ja na ntsitjahin nnon Tyoꞌtsꞌon, yantyi xe na quinanꞌtyen nnꞌan ncüii tosu xtyoꞌ tsanꞌñeen, ndoꞌ ntjueꞌhanhin quityquiiꞌ ndaandue. ");
INSERT INTO azgNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ndoꞌ xe na aa matsitja ꞌuꞌ nnon Tyoꞌtsꞌon veꞌ ngꞌe yo ꞌnan na matsaꞌ yo ntꞌöꞌ, tyiꞌntsaꞌhanꞌ, cꞌonꞌ chaꞌvijon na quitycüanꞌ ntꞌöꞌ. Ngꞌe yantyichen na tyiꞌquindë ꞌuꞌ na ncjaꞌ naijon na tyiꞌquintycüii na cotaꞌndoꞌ nnꞌan, chito na quindë ꞌuꞌ ndoꞌ na ncjaꞌ vꞌio, naijon na tavi xuee nduuꞌ chon, ");
INSERT INTO azgNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Naijon tyiꞌcüje quintyi min tajon quinduuꞌ chon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ndoꞌ mantyi xe na aa matsitja ꞌuꞌ nnon Tyoꞌtsꞌon veꞌ tsojnaanꞌ ngꞌeꞌ, yantyi tavi ncjaꞌ joꞌ, cꞌonꞌ na chaꞌvijon na quitycüanꞌ ngꞌeꞌ, ee yantyi ngaqueꞌ naijon na cotandoꞌ nnꞌan na quitycüanꞌ ngꞌeꞌ, chito na quindë ngꞌeꞌ na ncjaꞌ vꞌio naijon na tavixuee nduuꞌ chon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ee quiiꞌ vꞌio, tajon ncüje quintyi min tajon quinduuꞌ chon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ndoꞌ mantyi xe na veꞌ ninꞌquindyiaaꞌ ꞌnan na ntyja ꞌnaanꞌ joꞌ ntsꞌaahanꞌ na ntsitja ꞌuꞌ nnon Tyoꞌtsꞌon, yantyi cꞌonꞌ chaꞌvijon na jndë tjiꞌ tënnonꞌ, ngꞌe yantyi ngaqueꞌ naijon na icoꞌxen jon na ninncüii tënnonꞌ, chito yo ve joohanꞌ ncjaꞌ vꞌio. ");
INSERT INTO azgNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Naijon na tyiꞌjon cüje quintyi min tyiꞌjon quinduuꞌ chon. ");
INSERT INTO azgNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Joo quiooꞌ na tonanꞌcüje nnꞌan na tijntꞌuehan na tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon, totyiohan tsjaanꞌ nacjo oꞌ xjen na tonanꞌcohan oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Juu tsjaanꞌ ya jndyihanꞌ. Coninjntꞌuehanꞌ chaꞌ tyiꞌninꞌndaaꞌ ꞌnan, majoꞌ xe na aa jndë jnduiꞌ na chjenꞌhanꞌ, ¿Nchu ya ntsꞌaa tsꞌan na nninchjenꞌ nndaꞌhanꞌ? Matavi nchu ya na ntjo yahanꞌ. Ngꞌe na nndaꞌ, quinduihoꞌ na chaꞌvijon tsjaanꞌ na ya chjenꞌhanꞌ, ndoꞌ cꞌonhoꞌ na ya ntyjiiꞌ ñuan ꞌnaanhoꞌ yo ntyjeehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jnduiꞌ Jesús Capernaum. Tja jon ndyuaa Judea tontyja na quinduiꞌ ndoꞌcüjioonꞌ na toxndyaaꞌ jndaa Jordán, ndoꞌ joꞌ tovancüi nndaꞌ nnꞌan naijon na tyjeeꞌ jon. Ndoꞌ joꞌ taꞌ jon na itsiꞌman jon ndëëhan chaꞌ mancüii xjen itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ndoꞌ vendye nnꞌan fariseos squenonhan naijon na mꞌaan jon. Cojntꞌuehan nchu vaa ntꞌahan chaꞌ ntyja ꞌnaanꞌ jñꞌoon na ntsintcüeꞌ jon ndëëhan, quitꞌuiiviꞌhanꞌ jon. Taxeeꞌhan nnon jon: —¿Aa vanaan na ntsityuiiꞌ tsꞌan tson toco juu yo scuuꞌ juu? ");
INSERT INTO azgNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ndoꞌ joꞌ tꞌa Jesús jndyuehan, tso jon: —Jñꞌoon na tquen juu Moisés na iquenhanꞌ xjen ꞌoꞌ, ¿Nchu vaa itsiquindyihanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tꞌa nanꞌñeen, jnduehan: —Nquii Moisés, tyincyaa jon na vanaan ngave ncüii tson na ngitsohanꞌ na jndë jntyꞌehan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yajoꞌ tꞌa Jesús jndyuehan, tso jon: —Ngꞌe na queꞌ nꞌonhoꞌ, joꞌ na tquen Moisés juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Majoꞌ xjen na tyeꞌ na tquen Tyoꞌtsꞌon tsoñꞌen ꞌnan na min, vaa jñꞌoon na itsiquindyihanꞌ na sia jon tsansꞌa yo tsanscu. ");
INSERT INTO azgNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Mangꞌe na itsohanꞌ na nndaꞌ, xuee na ngoco tsansꞌa, nꞌndyii juu tye juu yo ndyee juu chaꞌ ntjotyenhin yo scuuꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ngꞌe na nndaꞌ, ve joo nanꞌñeen itsꞌaahanꞌ na ninncüii tsꞌan conduihin. Ndoꞌ na nndaꞌ, tachito ve tsꞌan conanꞌxuanhan, ninncüii tsꞌan conduihan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndoꞌ ngꞌe joꞌ, ya na jndë toco cüii tsansꞌa yo tsanscu, itsiꞌmanhanꞌ na nquii Tyoꞌtsꞌon sijndaꞌ jon na nndaꞌ vaa, mangꞌe joꞌ tyiꞌndyehan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ndoꞌ vi na jndë tyjeeꞌ ntcüeꞌ Jesús vꞌaa yo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, taxeeꞌ nanꞌñeen nin ninꞌquitsiquindyi juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ndoꞌ tꞌa Jesús, itso jon ndëëhan: —Juu tsꞌan na nꞌndyii scuuꞌ ndoꞌ ngoco nndaꞌ juu yo ncüiichen tsanscu, jndë vaa jnaanꞌ juu nnon scuuꞌ nquii juu, ee conduihin tsꞌan na veꞌ ndöꞌ ro mꞌaan juu yo ncüiichen tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ndoꞌ mantyi xe na aa nꞌndyii tsanscu saaꞌ juu ndoꞌ ngoco nndaꞌ juu yo ncüiichen tsansꞌa, jndë vaa jnaanꞌ juu nnon saaꞌ nquii juu, ee conduihin tsꞌan na veꞌ ndöꞌ ro mꞌaan juu yo ncüiichen tsansꞌaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ndoꞌ tyeyꞌon nnꞌan yotsca na mꞌaan Jesús, na ntꞌue nꞌonhan na quityio jon ntꞌö jon cjo yotscaꞌñeen chaꞌ ndyio jon jnꞌaan joo. Majoꞌ nque nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, taꞌhan na jnanꞌtyiaꞌhan joo nanꞌñeen na jndyochohan yotscaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Majoꞌ nquii Jesús, xjen na jndyiaaꞌ jon na nndaꞌ vaa na contꞌa nanꞌñeen, sivꞌii jon. Tso jon ndëëhan: —Ncyahoꞌ na vanaan na ntsque yotsca na mꞌan ja. Tyiꞌnanꞌntcüeꞌhoꞌ joo ngꞌe ntyjantyi nnꞌan na covantyja nꞌon ja chaꞌxjen na covantyja nꞌon yotsca ja, joo nanꞌñeen conduihan nnꞌan na ityeꞌntjon Tyoꞌtsꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Xe na aa mꞌaan tsꞌan na ninꞌquitsijonhin yo juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan, icanhanꞌ na nninncyaa tsanꞌñeen na ntcoꞌxen jonhin chaꞌxjen ncüii yuchjo vangueeꞌ juu ꞌnan na tso tye juu ndyee juu. Majoꞌ juu tsꞌan na tyiꞌninꞌncyaa juu na nquii Tyoꞌtsꞌon ntyeꞌntjon jonhin, tyiꞌjeꞌquindëë na nduihin tsꞌan na mꞌaan ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yajoꞌ nquii Jesús, ncüii ro cüii yotscaꞌñeen, chu jonhin, ndoꞌ tyio jon ntꞌö jon nquen joo. Tso jon ndëë joo: —Nquii ta Tyoꞌtsꞌon quityio jon jnꞌaan ncüii ro ncüiihoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Xjen na vanduiꞌ Jesús na chi ncja jon, jnannon ncüii tsꞌan, tja juu na mꞌaan jon, tëcoꞌxtye tsanꞌñeen nnon jon. Tso juu: —Nndaꞌ ta, ꞌuꞌ na ya tsꞌan ꞌuꞌ, ¿Nin ncüii nnon na chuhanꞌ na quitsꞌa chaꞌ ntsixuan na tyiꞌquintycüii na vandoꞌ ñuan njan na tonnon nquii Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ndoꞌ tꞌa Jesús, tso jon nnon juu: —¿Ndu na tsuꞌ na ya tsꞌan ja? Minꞌncüii tsꞌan tacꞌoon na ya tsꞌanhin, xiaꞌntyi nquii Tyoꞌtsꞌon conduihin na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ꞌUꞌ nchjiꞌ jñꞌoon na icoꞌxenhanꞌ na tquen Moisés, chaꞌna “Tyiꞌncꞌonꞌ yo tsanscu na veꞌ ndöꞌ ro, tyiꞌntscueꞌ tsꞌan, tyiꞌnchꞌueꞌ, tyiꞌntsininꞌ quintu nacjooꞌ ncüiichen tsꞌan, tyiꞌntsiviꞌnnꞌanꞌ tsꞌan, ndoꞌ mantyi quitsaꞌ na njon tyeꞌ yo ꞌndyoꞌ”. ");
INSERT INTO azgNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ndoꞌ juu tsanꞌñeen jeꞌ, sintcüeꞌ juu jñꞌoon, tso juu: —Nndaꞌ ta, xjen chjo ja tyeꞌ na mavancꞌuë tsoñꞌen jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jndyiaaꞌ Jesús nnon juu, tyioo na viꞌnchjii jonhin. Itso jon nnon juu: —Vaa ncüii nnon na icanchenhanꞌ na quitsaꞌ. Cjaꞌ, quijndëꞌ tsoñꞌen ꞌnanꞌ na min. Ndoꞌ xoquituꞌ na ngyonꞌ cüenta, quitsaꞌ nayahanꞌ nanninñenꞌ, yajoꞌ ntsixuanꞌ na tya ꞌuꞌ na tonnon nquii Tyoꞌtsꞌon. Ndoꞌ ndë joꞌ quindyotsijon ꞌuꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Majoꞌ juu tsanꞌñeen, vi na jndë jndyii juu na nndaꞌ, siꞌndaaꞌhanꞌ nchjii juu, tja ntcüeꞌ juu. Ee juu jñꞌoonꞌñeen sichjooꞌ jndyihanꞌ tsꞌon juu ngꞌe jndye jndyi ꞌnaanꞌ juu min, ndoꞌ min tyiꞌninꞌquijndëë juu joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ndoꞌ na tui na nndaꞌ, jndyiaaꞌ Jesús xiꞌjndio ndëë nnꞌan. Ndoꞌ tso jon ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon: —Ncüii tsantya jeꞌ, vaa jndyaaꞌ jndyi na ntsijonhin yo jñꞌoon na icoꞌxen Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ndoꞌ nanꞌñeen, siꞌndaaꞌhanꞌ ngiohan na nndaꞌ vaa na tso Jesús. Majoꞌ tsontyichen jon ndëëhan: —Nndaꞌ ꞌoꞌ ntsinda, joo nnꞌan na tꞌman quii nꞌon yo ꞌnan na tyahin, jndyaaꞌ jndyi na ntaꞌngueeꞌhin na nquii Tyoꞌtsꞌon ntcoꞌxen jonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ncüii tsantya, jndyaaꞌntyichen na ntsijonhin juu na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan, chintyichen na ngüequindyiꞌ camello tsueꞌ xꞌee tsiꞌncya. ");
INSERT INTO azgNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ndoꞌ nque nanꞌñeen na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, tꞌman vaa na ndincyaahanꞌ na ncüaaꞌ nꞌonhan na nndaꞌ vaa itso jon, joꞌ taxeeꞌhan ndëë ntyjehan: —Ngꞌe na nndaꞌ vaa, ¿Aa chi tsiꞌmanhanꞌ na tanin juu na nndëë nꞌman ñuaanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jndyiaaꞌ Jesús ndëëhan, tso jon: —Juu na cotjiꞌ nnꞌan cüenta yo ntyja ꞌnaanꞌ jñꞌoonvaꞌ, tanchu ya, majoꞌ ntyja ꞌnaanꞌ nquii Tyoꞌtsꞌon, tsoñꞌen condëë itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Na jndyii Pedro na nndaꞌ, tso jon nnon Jesús: —Já tsoñꞌen ꞌnan na nanꞌxuán, jndë jntyꞌë́ꞌhanꞌ chaꞌ condëë na conanꞌjö́n ntyja ꞌnaanꞌ juu tsꞌian na matsaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Joꞌ tꞌa Jesús jndyuehan, itso jon: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minninchen tsꞌan na ꞌndyii juu vaaꞌ juu na ngancyaa juu jñꞌoon naya ntyja njan, ꞌndyii juu ntyje juu nannon, yo nanntcu, tye juu, ndyee juu, scuuꞌ juu, ntsinda juu, tyuaa ꞌnaanꞌ juu, ngꞌe na conduihin tsꞌan na mꞌaan juu ntyja njan, chaꞌ ndëë ngancyaa juu jñꞌoon naya, ");
INSERT INTO azgNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Ndyuminhin jndyechen nnꞌan na ndixeeꞌhan juu chaꞌvijon na vaaꞌ juuhanꞌ, ndoꞌ nnꞌan na ngichu juu cüenta, ndui nanꞌñeen ntyje juu nannon, yo nanntcu, nnꞌan na ndui chaꞌvijon tye juu, ndyee juu, nnꞌan ndui chaꞌvijon ntsinda juu, yo ninꞌndyuaa ꞌnaanꞌ juu. Ndoꞌ mantyi nnon tsonnanguevahin ngenon juu naviꞌ, majoꞌ ya na ngueeꞌ juu quiñoonꞌndue, ntsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu tonnon nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Jndye nnꞌan na mꞌan neinhin conanꞌtiuhan na joohan njon conduihan, joo nanꞌñeen ncjuꞌcje Tyoꞌtsꞌonhan. Majoꞌ juu tsꞌan na condue nnꞌan na tyiꞌquinjonhin, ncjuꞌ jon tsanꞌñeen na tonnon. ");
INSERT INTO azgNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Tava Jesús nato na vjahanꞌ Jerusalén yo nque nanꞌñeen na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon. Majoꞌ joo nanꞌñeen tiꞌndaaꞌ tycya ngiohan na vja jon juu tsjoonꞌñeen, ndoꞌ mañoon nnꞌan na santyja na nquenꞌ nanꞌñeen, mantyi veꞌ ncyaa ncyaahan. Yajoꞌ tꞌman nndaꞌ jon joo nchoꞌve nanꞌñeen na totsayꞌonhan yo jñꞌoon toninncyaa jon, jnduiꞌhan ꞌndyo natoꞌñeen. Taꞌ jon sinin jon ndëëhan nchu vaa na mavaa xjen na ngenon jon naviꞌ tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tso jon ndëëhan: —Quitquenhoꞌ cüenta na cotsava na ntsquë Jerusalén. Ndoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën nnꞌan, joꞌ nninncyaa tsꞌan cüenta ja nduee ntyee na conintque ndëë jaa nnꞌan judíos, ndoꞌ mantyi yo nduee nnꞌan na conanꞌman nchu itsiquindyi juu jñꞌoon na tquen nquii Moisés. Ndoꞌ joo nanꞌñeen nnanꞌjndaꞌhan na cüꞌiö, ndoꞌ mantyi nninncyahan cüenta ja nduee joo nnꞌan na tachi nnꞌan judíos conduihan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ndoꞌ joo nanꞌñeen nnanꞌcüejnaanꞌhan ja, ndyiohan ꞌnan ja, ndoꞌ ntjueꞌhan ndaa jndyuehan cjö, ndë joꞌ nnanꞌcueeꞌhan ja. Majoꞌ xuee na jndë ndye na tui na nndaꞌ, ngüantꞌö xcö.” ");
INSERT INTO azgNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Juu Santiago yo ninꞌJuan, ntsinda Zebedeo, squenonhan na mꞌaan Jesús. Jnduehan nnon jon: —Ta, ntꞌue nnꞌö́n na ntsaꞌ vi nayaꞌñeen na cotán nnonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Yajoꞌ taxeeꞌ jon ndëëhan: —¿Nin naya ntꞌue nꞌonhoꞌ na quitsꞌa yo ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Joꞌ tꞌahan, jnduehan: —Ya na ngacüetyenꞌ naijon na nditꞌmaanꞌ ꞌuꞌ na ntcoxenꞌ tsonnangue, nninncyaꞌ na ngüendyuá ncüii cüii ntyja ngiaꞌ na nnanꞌjö́n yo ꞌuꞌ ntyja ꞌnaanꞌ na macoꞌxenꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Majoꞌ sintcüeꞌ Jesús jñꞌoon ndëëhan, tso jon: —ꞌOꞌ min tyiꞌcovaaꞌ nꞌonhoꞌ nin ꞌnan na cotanhoꞌ nnön. Ja contjo ya nchji yo naviꞌ na ngenön na nntꞌa nnꞌan ja, ndoꞌ na nnanꞌcueeꞌhan ja. Ndoꞌ ꞌoꞌ jeꞌ, ¿Aa ntjo ya ngiohoꞌ naviꞌ na nntꞌa nnꞌanhoꞌ min xe na aa na nnanꞌcüjehan ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Tꞌahan, jnduehan: —Nndëë nntꞌá. Ndoꞌ itsochen Jesús ndëëhan: —Ngꞌe na cotsayꞌonhoꞌ jñꞌoon yo ja, joꞌ juu naviꞌ na ngenön, mantyi ngenonhoꞌhanꞌ, ndoꞌ ngꞌe na nanꞌxuanhoꞌ ntyja njan, joꞌ na nnanꞌcüje nnꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Majoꞌ chito ja tsixuan na nninncya na ngüendyuaahoꞌ ncüii cüii ntyja ncꞌia, nquii Tyoꞌtsꞌon nninncyaa jon juu nayaꞌñeen ndëë nque nnꞌan na nanꞌxuanhan na ncyꞌonhan cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ndoꞌ joo nqui nanꞌñeen na mantyi totsayꞌonhan yo juu jñꞌoon na toninncyaa Jesús, taꞌhan, jnanꞌvjehan Santiago yo ninꞌJuanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ngꞌe joꞌ tꞌman Jesús na ninvaa nchoꞌvehan, tso jon ndëëhan: —Nque nnꞌan na conintque ndëë nnꞌan ncüii cüii tsonnangue, mangiohoꞌ na conanꞌsꞌahan ndëë joo nnꞌan na cotoxenhan. Ndoꞌ nque nnꞌan na condui nanmꞌannꞌian tꞌman, cotquenhan xjen nnꞌan na mꞌan nacje ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Majoꞌ ꞌoꞌ minchjo tyiꞌquichuhanꞌ na nndaꞌ ncꞌonhoꞌ ndëë ntyjehoꞌ. Minꞌcya ro na cüiihoꞌ na ntyja tsꞌon juu na nnintquehin quiiꞌ ntꞌan ntyjehoꞌ, tsixuan juu na quityentjon juu ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ndoꞌ minꞌcya ro cüiihoꞌ na ntyja tsꞌon juu na ncꞌoon juu na tonnon quiiꞌ ntꞌanhoꞌ, quinduihin tsꞌan na ityentjon juu ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, chito jndyö na mantꞌuë nnꞌan na quityeꞌntjonhan nnön. Ja jndyö na ntyeꞌntjön ndëë nnꞌan, ndoꞌ nꞌndyii nquii ja na cüꞌiö na ndyiön jnan nnꞌan, chaꞌ ndyaahan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Squehan tsjoon Jericó, ndoꞌ xjen na vanduiꞌ Jesús juu tsjoonꞌñeen yo ninꞌnnꞌan na totsayꞌonhan jñꞌoon yohin, yo cüii tmaanꞌ nnꞌan jndye jndyi, joꞌ ꞌndyo natoꞌñeen vaquityen ncüii tsannchjaanꞌ, ican juu xoquituꞌ ndëë nnꞌan. Jndyu juu Bartimeo, jnda tsan na jndyu Timeo. ");
INSERT INTO azgNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Xjen na jndyii juu na nquii Jesús, tsan na jnan Nazaret, ivenon jon joꞌ, taꞌ juu na sixuaa juu. Tso juu: —Nndaꞌ Jesús na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cyonꞌ na ntyꞌia rö nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ndoꞌ jndye nanꞌñeen jnanꞌtyiaꞌhanhin na cüichen ꞌndyo juu, majoꞌ juu juu majndeintyichen ticꞌuaa ꞌndyo juu. Tso nndaꞌ juu: —ꞌUꞌ na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cyonꞌ na ntyꞌia rö nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ndoꞌ joꞌ tëcüentyjeeꞌ Jesús. Tso jon ndëë nnꞌan na totsayꞌon jñꞌoon yohin: —Quiꞌmanhoꞌhin. Ndoꞌ tꞌmanhan juu tsannchjaanꞌñeen, jnduehan nnon juu: —Cꞌonꞌ na ya ntyjiꞌ, quinanquintyjaꞌ, nquii jon iꞌman jon ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Yajoꞌ tjuꞌto juu ndiaa na vanjoonꞌhin, ninñoonꞌ jnanquintyja juu, tja juu na mꞌaan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ndoꞌ taxeeꞌ Jesús nnon juu, tso jon: —¿Nin ꞌnan ntꞌue tsonꞌ na quitsꞌa ja ꞌuꞌ? Ndoꞌ joꞌ tꞌa juu tsannchjaanꞌñeen, tso juu: —Ta, ntꞌue jndyi tsꞌön na nntyꞌia nntꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ndoꞌ sintcüeꞌ Jesús jñꞌoon nnon juu: —Jndë ya ncjaꞌ, ngꞌe na vantyja tsonꞌ ja, joꞌ na jndë jnꞌmanꞌ. Ndoꞌ majuuntyi xjenꞌñeen ntjo naxuee jndyiaaꞌ tsanꞌñeen. Tja juu yo Jesús nato na vja jon. ");
INSERT INTO azgNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Vi na jndë tindyo na ntsquehan Jerusalén, na ndyo mꞌaan juu tsjoon Betfagé yo Betania na tonnon tyoꞌ na minntyjeeꞌ nꞌoon Olivos, tꞌua Jesús tsꞌian ndëë ve joo nnꞌan na totsayꞌon yo juu jñꞌoon na toninncyaa jon na cꞌohan ncüii ntꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Majoꞌ vitjachen na jnduiꞌhan, tso jon ndëëhan: —Quitsaqueꞌhoꞌ tsjoon chjo na mꞌaan tondëëhoꞌ. Ndoꞌ vi na jndë squehoꞌ joꞌ, yajoꞌ njntyꞌiahoꞌ ncüii snonndyua na minꞌjon tacontjo tsꞌan. Quinanꞌquinanꞌhoꞌ juu oꞌ, ndoꞌ quindyoyꞌonhoꞌ juu choꞌñeen ntjoohin. ");
INSERT INTO azgNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ndoꞌ xe na aa ngüaxeeꞌ tsꞌan ndëëhoꞌ ndu na contꞌahoꞌ na nndaꞌ, quinanꞌntcüeꞌhoꞌ jñꞌoon nnon tsanꞌñeen xe ngꞌe nquii jon na conintque nninjntꞌue chjohin oꞌ, ndoꞌ ya ndë joꞌ, ngaquintjo ntcüeꞌ oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ndoꞌ jnduiꞌ nanꞌñeen, tyꞌehan ndoꞌ mayuuꞌ jndiohan juu snonꞌñeen na tyen oꞌ ꞌndyo vꞌaa na mꞌaan ꞌndyo nato, joꞌ jnanꞌquinanꞌhan juu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ndoꞌ nque nnꞌan na mꞌan ndyo joꞌ, taxeeꞌ nanꞌñeen ndëëhan, jnduehan: —¿Ndu na conanꞌquinanꞌhoꞌ juu snonvaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yajoꞌ tꞌahan chaꞌxjen juu jñꞌoon na jndë tso Jesús na quinduehan. Ndoꞌ nnꞌan njnuenꞌ juu choꞌñeen, tyincyahan na tyeyꞌon nanꞌñeen juu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ndoꞌ xjen na sque ntcüeꞌhan naijon mꞌaan jon na yꞌonhan juu snonꞌñeen, tyiohan ndiaahan naxenꞌ oꞌ, joꞌ tantjo jon juu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ndoꞌ jndye nnꞌan na mꞌan joꞌ, totquenhan ndiaa tonco ꞌnaanhan nato, ndoꞌ vendyehan tyjeehan nduee nꞌoon, tquenhan joohanꞌ natoꞌñeen na jnanꞌtꞌmaanꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndoꞌ nnꞌan na veꞌjndyee na tonnon jon yo ninꞌnnꞌan na ntyja toxenꞌ jon, ninnquiiꞌchen tonanꞌxuaahan: —Nën jndyi jaa ngiö nquii tsan na icüjeeꞌ. Quityio Tyoꞌtsꞌon jnꞌaan nquii juu na icüjeeꞌnon ndëë yo xueeꞌ nquii jon na conduihin na ityeꞌntjon jon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Conanꞌtꞌmaanꞌ jaa nquii jon na mavaa xjen na ntcoꞌxen jon, chaꞌxjen nquii David ndyu na toxenꞌchen tocoꞌxen jon nnꞌan tsjan jaa na jndyocahanꞌ. Quinditꞌmaanꞌ nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ndoꞌ xjen na taqueeꞌ Jesús Jerusalén, tja jon vatsꞌon tꞌman. Ndoꞌ nnꞌan na mꞌan joꞌ, vi na jndë tquen jon cüenta nchu vaa ꞌnan na contꞌahan, ndoꞌ ngꞌe na vaman, joꞌ jnduiꞌ ntcüeꞌ jon. Tja jon Betania yo nque nnꞌan nchoꞌveꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ndoꞌ tonco cüiichen xuee, jndë na jnduiꞌ nndaꞌhan Betania, tyjeeꞌ na ninꞌjndoꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Joꞌ jndyiaaꞌ tycya jon ncüii tsꞌoon higuera na min tscooꞌhanꞌ. Ndoꞌ joꞌ sindyooꞌhin nnon juu tsꞌoonꞌñeen, na tëquindyiaaꞌ jon aa chuuꞌ tëhanꞌ na ntquii jon. Majoꞌ xjen na tueeꞌcya jon nnonhanꞌ, veꞌ xiaꞌntyi tsco minhanꞌ, ngꞌe tyiꞌcoveeꞌ xjen na nguen tëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ndoꞌ tso jon nnonhanꞌ: —Tavi xuee na ntsaꞌ të na ntquii tsꞌan. Ndoꞌ nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, mantyi jndyehan juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Ndë joꞌ sque nndaꞌhan Jerusalén. Ndoꞌ Jesús, tëqueeꞌ nndaꞌ jon vatsꞌon tꞌman. Joꞌ ijon jndye ꞌnan min na condëë nnꞌan, yo quiooꞌ na conanꞌcüje nnꞌan na conanꞌtꞌmaanꞌhan nquii Tyoꞌtsꞌon. Ndoꞌ ngꞌe na itsiꞌndaaꞌhanꞌ nchjii jon na coninjntꞌua ꞌnan joꞌ, taꞌ jon, tjiꞌ jon nanꞌñeen chꞌen. Mantyi nnꞌan na conanꞌjndyo sꞌon ꞌnaan nnꞌan na cotsque ya, scüequityeeꞌ jon joo mesa ꞌnaanhin. Ndoꞌ maninꞌ cüajon sꞌaa jon yo joo silla ꞌnaan nnꞌan na condëë quintuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Min tatyincyaa jon jñꞌoon na vanaan na ngüenon tsꞌan chꞌeenꞌ juu vatsꞌonꞌñeen na chu juu xu. ");
INSERT INTO azgNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tyeꞌ na itsiꞌman jon ndëë nanꞌñeen, tso jon: —Quityquiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsohanꞌ: Juu vꞌa tsixuanhanꞌ vꞌaa naijon nque nnꞌan na ninvaa tsonnangue na conanꞌneinhan nnön. Ndoꞌ tsontyichen jon: Majoꞌ ꞌoꞌ contꞌahoꞌ na itsijonhanꞌ juuhanꞌ ncüii tsëꞌtsjöꞌ na cotooꞌ nanꞌntyꞌuee, ee ꞌoꞌ contyꞌueehoꞌ xoquituꞌ ꞌnaan nnꞌan na cotsque ntjoohin na nnanꞌneinhan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ndoꞌ nque nnꞌan na conintque ndëë ntyee ꞌnaan nque nnꞌan judíos yo ninꞌnnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen nquii Moisés, jndyehan na nndaꞌ vaa na sꞌaa Jesús. Tsojnaanꞌ joꞌ tojntꞌuehan nchu vaa ntꞌahan na nnanꞌcueeꞌhan jon. Majoꞌ veꞌ ncyaahan na ntꞌahan na nndaꞌ ngꞌe tsoñꞌen nnꞌan, tꞌman vaa na tëveeꞌ ngiohan jñꞌoon na totsiꞌman jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ndoꞌ xjen na taman, yajoꞌ jnduiꞌ nndaꞌ Jesús Jerusalén yo nnꞌan ꞌnaanꞌ jon. Tyꞌehan. ");
INSERT INTO azgNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tonco ncüiichen xuee, tenon nndaꞌhan naijon minntyjeeꞌ juu tsꞌoon higueraꞌñeen. Joꞌ cojntyꞌiahan na jndë tcanhanꞌ xjen nchꞌiooꞌchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ndoꞌ tañjoonꞌ tsꞌon Pedro ꞌnan na tui. Tso jon nnon Jesús: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, quindyiaꞌ, juu tsꞌoon higuera na tjuꞌ jñꞌoonviꞌ cjooꞌ, jndë tcanchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ndoꞌ joꞌ tꞌa Jesús jndyuehan, tso jon: —Cantyja nꞌonhoꞌ nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, xe na aa ican tsꞌan nnon jon na quenaanꞌ jon tyoꞌvahin ndoꞌ cjuꞌ jonhanꞌ quityquiiꞌ ndaandue, xe na aa tyiꞌntsꞌaa juu na ve vaa na ndyiiꞌ tsꞌon juu, ndui chaꞌxjen jndë vantyja tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Mangꞌe joꞌ matsjö ndëëhoꞌ, tsoñꞌen na cotanhoꞌ nnon Tyoꞌtsꞌon, cantyja nꞌonhoꞌ na jndë tyincyaa jonhanꞌ ndëëhoꞌ, ndoꞌ nndui chaꞌxjen na cotanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ndoꞌ juu xjen na matsininꞌ nnon Tyoꞌtsꞌon, xe na aa mꞌanꞌ na vꞌiꞌ ncüii tyꞌiuꞌ, quitsitꞌman tsonꞌ juu chaꞌ min tyiꞌntscuꞌhanꞌ na nquii Tyëëhë na mꞌaan quiñoonꞌndue ndëë ntsitꞌman tsꞌon jon ꞌuꞌ na matsitja ꞌuꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Majoꞌ xe na aa tyiꞌninꞌquitsitꞌman tsonꞌ juu tyꞌiuꞌ na sitjahin nnonꞌ, min nquii Tyëëhë na mꞌaan quiñoonꞌndue, xeꞌquitsitꞌman tsꞌon jon ꞌuꞌ na matsitja ꞌuꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ndoꞌ ncüiichen jon sque nndaꞌhan Jerusalén. Ndoꞌ viochen xjen tyincyaa jon ntyeeꞌ chꞌeenꞌ juu vatsꞌon tꞌman, vendye ntyee na conintque ntyja ꞌnaan nnꞌan judíos squenonhan na mꞌaan jon, yo ntyjehin nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, ndoꞌ yo nnꞌan na conintque ndëë tsoñꞌenhan na conduihan nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Joo nanꞌñeen taxeeꞌhan nnon jon, jnduehan: —¿Nin najndei condui ꞌuꞌ na tjiꞌ nnꞌan quityquiiꞌ vatsꞌon tꞌman? Ndoꞌ ¿Nin juu tyincya najnduꞌ na saꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Joꞌ tꞌa jon jndyuehan, tso jon: —Mantyi ja vaa jñꞌoon na ngüaxꞌë ndëëhoꞌ, xe na aa nnanꞌntcüeꞌhoꞌ juuhanꞌ, yajoꞌ mantyi ntsjö ndëëhoꞌ nin nquii na tꞌua tsꞌian nnön na tjiꞌ nanꞌñeen quityquiiꞌ vatsꞌon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nquii Juan, tsan na totsiquindëëꞌ nnꞌan, ¿Nin nquii juu tꞌua tsꞌian nnon jon na quitsꞌaa jon juu tsꞌianꞌñeen? ¿Aa nquii Tyoꞌtsꞌon, ndoꞌ aa veꞌ nnꞌan jndue na quitsꞌaa jonhanꞌ? Cüa, quitꞌahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yajoꞌ tyeꞌ na jnanꞌnein nquehin yo ntyjehan, jnduehan: —Xe na aa nnduë na nquii Tyoꞌtsꞌon tꞌua jon tsꞌian nnon juu tsanꞌñeen na quitsiquindëëꞌ juu nnꞌan, yajoꞌ juu tsanvahin ngitso juu ndëë: “¿Ndu na tatentyja nnꞌön juu jñꞌoon na toninncyaa Juanꞌñeen?” ");
INSERT INTO azgNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ndoꞌ mantyi xe na aa nnduë na veꞌ nnꞌan tꞌua juu tsꞌianꞌñeen nnon juu. Manndaꞌ jñꞌoon na tomꞌaanꞌ nꞌonhan. Majoꞌ tyiꞌjeꞌquinduehan na nndaꞌ ngꞌe ncyaa jndyihan na nnanꞌvje nnꞌanhin, ee tsoñꞌen nnꞌan tovantyjatyen nꞌonhan na nquii Tyoꞌtsꞌon tꞌua jon juu tsꞌianꞌñeen nnon Juan. ");
INSERT INTO azgNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Mangꞌe na nndaꞌ, jnduehan nnon Jesús: —Aa já mancüiixjen tyiꞌquindiö́. Ndoꞌ joꞌ tꞌa jon, itso jon ndëëhan: —Min ja xeꞌquitsjö ndëëhoꞌ nin nquii jon na tꞌua tsꞌianminꞌ nnön na sꞌahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ndoꞌ taꞌ Jesús na sinin jon jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ndëë nnꞌan. Ndö vaa na itso ncüii jñꞌoonꞌñeen: —Tomꞌaan ncüii tsꞌan. Jnonꞌ jon ntꞌöö tëndöndyooꞌ tsjan. Ndë joꞌ tyiiꞌ jon teon xiꞌjndio juu ntjonꞌñeen. Ndoꞌ mantyi tquen tsanꞌñeen ncüii tsjöꞌ na su nnon na ndëë nchje jon tëndöndyooꞌ tsjanꞌñeen chaꞌ ncüjiꞌ jon ndaaꞌhanꞌ. Ndë joꞌ sia jon ncüii jndu ndye chaꞌ ndëë ntquen tsꞌan cüenta juu ntjonꞌñeen, jndë joꞌ jntꞌue jon nnꞌan na quintꞌahan tsꞌianhanꞌ. Jndë joꞌ jnduiꞌ jon, tja jon ncüiichen tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ndoꞌ xjen na nchjii jon na jndë tueꞌ të joo ntꞌööꞌñeen, joꞌ jñon jon ncüii tsꞌan na tyeꞌntjon jon na mꞌan nanꞌñeen na nnon juu tsanꞌñeen nninncyahan të na tsixuanhanꞌ cüentaaꞌ nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Majoꞌ joo nanꞌñeen, tyꞌonhan juu, totjaꞌhanhin, ndë jñon ntcüeꞌhan juu na tatë tyincyahan na ngachu juu. ");
INSERT INTO azgNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ndoꞌ na nndaꞌ, juu tsꞌan na ꞌnaanꞌ juu ntjonꞌñeen, jñon nndaꞌ jon ncüiichen tsꞌan na ityeꞌntjon jon naijon na mꞌaan nanꞌñeen. Juu tsanꞌñeen totuenꞌhan ntjöꞌhin, jnanꞌqueeꞌhan xquen juu. Ji vaa jndyi jntꞌahanhin. ");
INSERT INTO azgNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Jndë joꞌ juu tsꞌan na ꞌnaanꞌ ntjonꞌñeen, jñon nndaꞌ jon ncüiichen tsꞌan na ityentjon jon. Juu tsanꞌñeen, jnanꞌcueeꞌhanhin. Ndoꞌ joo nanꞌñeen, ninnquiiꞌ nndaꞌ vaa tontꞌahan tsoñꞌen nnꞌan na tojñon nquii tsꞌan na ꞌnaanꞌ juu ntjonꞌñeen, ñꞌen nnꞌan na totjaꞌhan, ndoꞌ vendye nanꞌñeen jnanꞌcüjehan. ");
INSERT INTO azgNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Majoꞌ taquintjo ninncüii tsꞌan na vi mꞌaan na itsitiu jon na ijñon jon na mꞌan nanꞌñeen. Joꞌ jnda nquii jon, ninncüii tsꞌonhin na tuihin ndoꞌ tꞌman vaa na viꞌnchjii jonhin. Na matsꞌiañꞌen jñon jonhin ndëë joo nanꞌñeen. Ee sitiu jon: Nque nanminꞌ na totyentjonhan nnön, tajntꞌa nanꞌñeen na njonhan, majoꞌ jnda ja ntꞌahan na njonhin”. Nndaꞌ va na toquindyiiꞌ tsꞌon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Majoꞌ juu xjen na tyjeeꞌ jnda nquii jon na mꞌan nanꞌñeen, jnduehan ndëë ntyjehan: Tsꞌian ya yuuꞌ, vi na jndë tueꞌ tye tsanvahin, juu ntjonvahin ntjohanꞌ cüentaaꞌ juu. Cüa, quinanꞌcuëëꞌhin chaꞌ ntjotyenhanꞌ nduëë. ");
INSERT INTO azgNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ndoꞌ na nndaꞌ, tyꞌon nanꞌñeen jon, jnanꞌcueeꞌhan jon, ndë joꞌ tyqueꞌhan siꞌtsꞌo ꞌnaanꞌ jon na toxenꞌ juu teonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ndoꞌ taxeeꞌ Jesús: —Nquii tsꞌan na ꞌnaanꞌ juu ntjonꞌñeen, ¿Nin ꞌnan ntsꞌaa jon? Nquii jon nndyo ntcüeꞌ jon ndoꞌ ntscüje jon joo nnꞌan na jntyꞌii jon juu teonꞌñeen ndueehan, ndoꞌ ntsijndaꞌ jon mañoon nnꞌan na ntꞌahan tsꞌian juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“Tyiꞌxeꞌquitsꞌaahanꞌ na taconanꞌjnꞌaanhoꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na minhanꞌ ndueehoꞌ na itsohanꞌ: Nque nnꞌan na conanꞌya vꞌaa, jnanꞌneinhan, jnduehan: Juu tsjöꞌ na jndue nnꞌan na conanꞌya vꞌaa na tayuu jntꞌuehanꞌ, tquenhanꞌ juuhanꞌ na conduihanꞌ tsjöꞌ na ngüentyjeeꞌtyen nqui vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nquii jon na ityeꞌntjon jon jaa, nndaꞌ vaa na sijndaꞌ jon. Caveeꞌ jndyi ngiö na cotquën cüenta na nndaꞌ vaa na itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ndoꞌ joo nanꞌñeen na jndohin Jesús, vi na jndë jndyehan jñꞌoonvaꞌ na sinin jon, ntꞌue jndyi nꞌonhan na cyꞌon cominsión jon, na chi ncja jon naviꞌ, ngꞌe joohan sijoonꞌ jon yo nque nanꞌñeen na tontꞌahan ꞌnan natyia. Ee taaꞌ nꞌonhan nacjo nquehin sinin jon juu jñꞌoonꞌñeen. Majoꞌ jntyꞌehan na ninꞌquitꞌuehan jon ngꞌe ncyaahan na joo nnꞌan na jndye jndyiꞌhin ntꞌa viꞌ nanꞌñeenhan. Tyꞌehan. ");
INSERT INTO azgNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ndëcya nque nnꞌan tmaanꞌ fariseos jñonhan vendye ntyjehan yo nnꞌan ꞌnaanꞌ Herodes na mꞌaan Jesús. Tꞌuahan tsꞌian ndëë nanꞌñeen na quitquenhan cüenta jñꞌoon na itsinin Jesús chaꞌ ntyja ꞌnaanꞌhanꞌ quitꞌuiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Xjen na squehan na mꞌaan jon, jnduehan: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, mangiö́ na matsininꞌ jñꞌoon na mayuuꞌ, min tacüenta matyiꞌ joo jñꞌoon na conanꞌnein nnꞌan nacjoꞌ. ꞌUꞌ ninncüii xjen ntyjiꞌ yo tsoñꞌen nnꞌan. ꞌUꞌ jñꞌoon na mayuuꞌ matsiꞌmanꞌ nchu vaa ntꞌue tsꞌon Tyoꞌtsꞌon na quintꞌa nnꞌan. Majoꞌ ninꞌquindyë́ jñꞌoon ꞌndyoꞌ, juu sꞌon na ique tsanmꞌaantsꞌian, ¿Aa chuhanꞌ na cotyiö́nhanꞌ, ndoꞌ aa tyiꞌquichuhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Majoꞌ taaꞌ tsꞌon Jesús na veꞌ condue nquehan jñꞌoonꞌñeen. Joꞌ tso jon ndëëhan: —ꞌOꞌ ntꞌue nꞌonhoꞌ na quitꞌuiiviꞌhanꞌ ja, joꞌ na nndaꞌ vaa na conduehoꞌ nnön. Quindyoyꞌonhoꞌ ncüii xoquituꞌ denario na ntyꞌia. ");
INSERT INTO azgNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tyeyꞌonhan cüiihanꞌ. Ndoꞌ taxeeꞌ jon ndëëhan: —¿Nin tsꞌan tsöꞌxquen chuuꞌhanꞌ, ndoꞌ nin nquii tsꞌan xueeꞌ na chuuꞌhanꞌ? Tꞌahan, jnduehan nnon jon: —Nquii tsanmꞌaantsꞌian tꞌman César. ");
INSERT INTO azgNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ndoꞌ tso Jesús ndëëhan: —Mayuuꞌ jñꞌoon na tꞌahoꞌ. Joꞌ quinanꞌquindëhoꞌ jñꞌoon na iquen jon ndëëhoꞌ, ndoꞌ juu jñꞌoon na iquen Tyoꞌtsꞌon ndëëhoꞌ, mantyi quitaꞌngueeꞌhoꞌhanꞌ. Ndoꞌ na nndaꞌ tꞌa jon jndyuehan, ntjohin na vacue mꞌaanꞌ nꞌonhan ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ndë joꞌ vendye nnꞌan juu tmaanꞌ saduceos squenonhan na mꞌaan Jesús. Nanꞌñeen conduehan ncüii tsꞌan na jndë tueꞌ, tyiꞌjeꞌcüandoꞌ nndaꞌ juu. Ndö juu jñꞌoon na jnanꞌneinhan nnon Jesús, jnduehan: ");
INSERT INTO azgNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Nndaꞌ ta na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, nquii Moisés, vaa jñꞌoon na jntyꞌii jon ndëë jaa na coꞌxenhanꞌ, xe na aa ngueꞌ tsꞌan ndoꞌ ntjo scuuꞌ juu na min taꞌnan ndahan tui, icoꞌxenhanꞌ na ngoco tyje nquii tsꞌooꞌñeen yo scuuꞌ jon na ntjo, na ncꞌon ndahan na ntsive juu xueeꞌ nquii tsꞌooꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Jñꞌoon na ngiö́, tomꞌan ntyqueꞌ nannon na ninncüii tsꞌan ntsindahan. Nquii tsan na vejndyee, toco jon, majoꞌ ya na tueꞌ jon taꞌnan jnda jon yo scuuꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ndoꞌ tyje jon, tsan vja ve, toco juu yo tsanscuꞌñeen, ndoꞌ majoꞌntyi xjen na tueꞌ juu, min taꞌnan jnda juu tꞌoon yo juu tsanscuꞌñeen. Ndoꞌ majoꞌntyi tjon tyje jon tsan vja ndye. ");
INSERT INTO azgNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ndoꞌ tsoñꞌen na ninvaa na ntyqueꞌ joo nanꞌñeen, toncohan yo juu tsanscuꞌñeen, ndoꞌ minꞌncüii ndahan tatꞌoon yohin, ndoꞌ vi na matsꞌiañꞌen, mantyi nquii tsanꞌñeen tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Jñꞌoon na ninꞌquitaꞌxꞌë́ nnonꞌ, nnꞌan na jndë tjë, xe na aa ntaꞌndoꞌ nndaꞌhan, chaꞌxjen juu jñꞌoon na matsiꞌmanꞌ, ¿Nin ncüii joo na ntyqueꞌ nanꞌñeen na ndisaaꞌ juu tsanscuꞌñeen, ngꞌe ninvaa na ntyqueꞌhan tondisaaꞌ juu? ");
INSERT INTO azgNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ndoꞌ tꞌa Jesús jndyuehan, tso jon: —Juu jñꞌoonvaꞌ na conduehoꞌ ndöꞌ, tsiꞌmanhanꞌ na cochue nꞌonhoꞌ, min ndicüaaꞌ nꞌonhoꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na conanꞌjnꞌaanhoꞌ, ntyja ꞌnaanꞌ juu najndei na condui nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ee joo nnꞌan na jndë tjë, juu xjen na ntandoꞌ nndaꞌhan, tajeꞌquitonco nndaꞌhan, min tajeꞌncyahan ndahan na nnonco joo. Ee nndui nanꞌñeen chaꞌna nque ángeles na mꞌan quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Majoꞌ ntyja ꞌnaanꞌ juu jñꞌoon na cotaꞌndoꞌ nndaꞌ nnꞌan na jndë tjë, ꞌoꞌ jndë jnanꞌjnꞌaanhoꞌ nacjooꞌ tson na tji Moisés, juu jñꞌoon na sinin Tyoꞌtsꞌon nnon jon xjen na tëquindyiaaꞌ jon tsꞌoon chjo na covꞌa. Itso jon nnon Moisésꞌñeen: “Ja condui Tyoꞌtsꞌon cüentaaꞌ Abraham yo Isaac yo ninꞌJacob na vantyja nꞌonhan ja. Nndaꞌ vaa jñꞌoon na tso jon min na tivio jndë tjë nanꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Joꞌ min na jndë tjë nnꞌan na tui tsjan nquii Moisés, sinin Tyoꞌtsꞌon ntyja ꞌnaanhan na ninvaa vandoꞌhan. Ndoꞌ ngꞌe na nndaꞌ, condui jon Tyoꞌtsꞌon cüenta nque nnꞌan na cotandoꞌ, chito cüenta ntꞌoo. Joꞌ tsiꞌmanhanꞌ na ꞌoꞌ cochue nꞌonhoꞌ yo ꞌnan na conanꞌtiuhoꞌ na tyiꞌjeꞌquitandoꞌ nndaꞌ nnꞌan na jndë tjë. ");
INSERT INTO azgNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Xjen na sinin Jesús ndëë nnꞌan saduceosꞌñeen, tyjeeꞌ cüii tsꞌan na itsiꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés. Joꞌ jndyii juu jñꞌoonꞌñeen na sintcüeꞌ Jesús ndëë nanꞌñeen. Ndoꞌ taaꞌ tsꞌon tsanꞌñeen na juu jñꞌoon na sintcüeꞌ Jesús, jndyoyuhanꞌ. Joꞌ taxeeꞌ juu nnon jon: —Quiiꞌ ntꞌan tsoñꞌen jñꞌoon na tquen Tyoꞌtsꞌon na icoꞌxenhanꞌ, ¿Nin nquii jñꞌoon na njonntyichen tsixuanhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tꞌa Jesús, itso jon nnon tsanꞌñeen: —Nquii jñꞌoon na njonntyichen tsixuanhanꞌ, ndö vaa na icoꞌxenhanꞌ: “ꞌOꞌ nnꞌan Israel, quindyehoꞌ, xiaꞌntyi nquii ta Tyoꞌtsꞌon na conanꞌtꞌmaanꞌ jaa, taquintyja nquii jon na conduihin Tyoꞌtsꞌon, taꞌnan ncüiichen. ");
INSERT INTO azgNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Joꞌ cüiveꞌnchjiꞌ jon yo na xoncüeeꞌ tsonꞌ. Tsoñꞌen na ndëë ntsaꞌ, quitsaꞌhanꞌ ngꞌe na veꞌnchjiꞌ jon, mantyi tsoñꞌen ꞌnan na matsitiuꞌ, quitsitiuꞌ yaꞌhanꞌ ngꞌe na venchjiꞌ jon. Quityentjonꞌ nnon jon yo na ninvaañꞌen najnduꞌ ngꞌe na venchjiꞌ jon. Jñꞌoonvahin tsixuanhanꞌ na njonntyichen na icoꞌxenhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndoꞌ juu jñꞌoon na vja ve na icoꞌxenhanꞌ, itsijonhanꞌ juuhanꞌ chaꞌna juu jñꞌoon na vejndyee: “Cüivenchjiꞌ tsoñꞌen nnꞌan chaꞌxjen na venchjii nquii ꞌuꞌ.” Taꞌnan ncüiichen jñꞌoon na njonntyichen conduihanꞌ yo jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Yajoꞌ juu tsanꞌñeen na tsiꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen nquii Moisés, sintcüeꞌ juu jñꞌoon nnon Jesús, tso juu: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndë́, juu jñꞌoonvaꞌ na tsuꞌ, jndyoyuhanꞌ. Mayuuꞌ jñꞌoon na matsuꞌ na nquii jon ninncüiihin. Ninnquii jon coꞌxen, taꞌnan ncüiichen. ");
INSERT INTO azgNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ndoꞌ na ncꞌoon tsꞌan na cüivechjii juu jon yo na xoncüeeꞌ tsꞌon juu, ndoꞌ yo tsoñꞌen na ndëë ntsꞌaa juu na quitsꞌaa juuhanꞌ ngꞌe na venchjii juu jon, ndoꞌ tsoñꞌen na itsitiu juu na ntsiquindë juuhanꞌ ngꞌe na venchjii juu jon, ndoꞌ na ntyentjon jon juu na ninvaa najndei juu, ndoꞌ mantyi na cüivenchjii juu nnꞌan chaꞌxjen na venchjii nquiihin, joo nanꞌminꞌ njonntyichen conduihanꞌ, chichen quiooꞌ na ntscueeꞌ tsꞌan na ntsco juu oꞌ na itsitꞌmaanꞌ juu Tyoꞌtsꞌon, yo mañoonchen nnon na ninncyaa tsꞌan na nditꞌmaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Ndoꞌ tquen Jesús cüenta na ya jñꞌoon sintcüeꞌ tsanꞌñeen. Joꞌ tso jon nnon juu: —ꞌUꞌ tavi jndye vitja na ntsijon ꞌuꞌ yo na ityeꞌntjon Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. Ndë joꞌ matavi ꞌnan ncüiichen tsꞌan na sisaaꞌ tsꞌon na ngüaxeeꞌchen jñꞌoon nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Viochen xjen na itsiꞌman Jesús ndëë nnꞌan quityquiiꞌ juu vatsꞌon tꞌman, tso jon: —Joo nnꞌan na conanꞌmanhin ndëë ntyjehin nnꞌan judíos, conduehin na nquii Cristo na jñon Tyoꞌtsꞌon jon quiiꞌ ntꞌan nnꞌan, conduihin jnda nquii David. ¿Ndu na conduehan na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ee juu David ntyja ꞌnaanꞌ nquii Espíritu Santo tso jon: Nquii ta Tyoꞌtsꞌon itso jon nnon nquii jon na ityeꞌntjon jon ja: Quijmanꞌ ncꞌia na tontyjaya, viochen xjen na joo nnꞌan na jndohan ꞌuꞌ ntsꞌa ntmaanꞌhan nacje ꞌnanꞌ na ntcoꞌxenꞌhan. Tsontyichen Jesús ndëëhan: ");
INSERT INTO azgNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ja matsjö ndëëhoꞌ, juu David tso jon na nquii Cristo conduihin nquii jon na ityeꞌntjon jonhin. Ndoꞌ na nndaꞌ, ¿Nchu vaa na tso juu na conduihin jnda juu? Ndoꞌ na sinin Jesús jñꞌoonminꞌ, joo nnꞌan jndye jndyiꞌhin, taveeꞌ jndyi ngiohan na tondyehan joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Viochen xjen na itsiꞌman Jesús, tso jon: —Quintꞌahoꞌ cüenta na tyiꞌntꞌahoꞌ chaꞌ na contꞌa nque nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen nquii Moisés. Ee caveeꞌ ngiohan na cocüehan ndiaa tonco chaꞌ quindue nnꞌan na tꞌman conduihan. Ndoꞌ mantyi caveeꞌ jndyi ngiohan na ninncyaa tsꞌan tsꞌonhan nata. ");
INSERT INTO azgNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ndoꞌ xjen na covatjon nnꞌan vatsꞌon, joohan na ninꞌcüendyuaahan naijon itsiquinjonhanꞌhin. Ndoꞌ xjen na coveeꞌ nguee, joohan ntꞌue nꞌonhan na ntcüaꞌ jndyeehan. ");
INSERT INTO azgNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Majoꞌ joo ꞌnan ꞌnaan nanntcu ninnque, cotjiꞌ nanꞌñeenhanꞌ na ninꞌcüiꞌnaanhinhanꞌ, ndoꞌ ndë joꞌ jndye jñꞌoon na conanꞌneinhan nnon Tyoꞌtsꞌon chaꞌ quinanꞌtiu nnꞌan na vaa njon jndyi jon ngiohan. Matsjö jaaꞌntyichen ntꞌuiiviꞌ Tyoꞌtsꞌon joohan ngꞌe na nndaꞌ vaa contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ncüii jon mꞌaan Jesús vatsꞌon tꞌman. Joꞌ vequityen jon na tonnon naijon min quiton na cotyion nnꞌan sꞌon cüentaaꞌ juu vatsꞌonꞌñeen. Ndoꞌ jndyiaaꞌ jon jndye nnꞌan tjueꞌhan sꞌon joꞌ. Ndoꞌ jndye nantya, tꞌman sꞌon tyionhan tyquiiꞌ joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Majuu xjenꞌñeen, cüii tsanscu na jndë ntjohin ndoꞌ jñenꞌ jndyihin, tyjeeꞌnon juu, tacjuꞌ juu ve xoquituꞌ sꞌon ve ncüii joo istonꞌñeen. Joo xoquituꞌñeen njonhanꞌ chaꞌna ninncüii xoquituꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ndoꞌ na tui na nndaꞌ, tso Jesús ndëë joo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tsanscuvahin na jndë tueꞌ saaꞌ juu, njonntyichen ꞌnan na tjuꞌ juu quityquiiꞌ istonꞌñeen, tachito joo sꞌon jnda na tjueꞌ nantya. ");
INSERT INTO azgNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ee tsoñꞌen nanꞌñeen veꞌ sꞌon na vantjoꞌchen na tjueꞌhan quityquiiꞌ quitonꞌñeen, majoꞌ juu tsanscuvahin na jndë ntjohin na jñenꞌ jndyihin, tjuꞌñꞌen jon xjoquituꞌ yꞌoon jon, min tajntyꞌiihanꞌ na ninjnda ꞌnan na ntcüaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Xjen na vanduiꞌ Jesús na mꞌaan jon vatsꞌon tꞌman yo nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, ncüii joohan tso juu nnon jon: —Nndaꞌ ta na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndë́, quindyiaꞌ nancooꞌ jndyi ntjöꞌmin na tijntꞌue na jndë juu vatsꞌonvahin yo ntꞌaa cüentaaꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ndoꞌ joꞌ tꞌa Jesús, tso jon: —Mayuuꞌ nancooꞌ jndyi ntꞌaamin na mandyiaꞌ na jndëhanꞌ yo ntjöꞌ tꞌman. Majoꞌ minꞌncüii tsjöꞌ jeꞌquintjohanꞌ nacjooꞌ ntyjehanꞌ. Tsoñꞌenhanꞌ nnanꞌtyuiiꞌ nnꞌanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Yajoꞌ tyꞌehan tyoꞌ na mꞌan nꞌoon olivos na tonnon vatsꞌon tꞌman. Joꞌ tacjo Jesús, ndë joꞌ nquii Pedro, Jacobo, Juan yo ninꞌAndrés, tyeꞌ taxeeꞌhan nnon jon, jnduehan: ");
INSERT INTO azgNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Quitsuꞌ ndë́ ¿Yuu xjen na ngüentyja yo ꞌnan na tsuꞌ quichen? Ndoꞌ ¿Nin ꞌnan nndui jndyee na ntsiꞌmanhanꞌ na mandyo ngüentyja na nndui nanꞌminꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Joꞌ tꞌa Jesús jndyuehan, tso jon: —Quitquen ya yahoꞌ cüenta na tyiꞌntsiviꞌnnꞌan tsꞌanhoꞌ ntyja ꞌnaan joo jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ee jndye joo nndityincyooꞌ nnꞌan yo xuë na nnanꞌviꞌnnꞌanhan nnꞌan, na nnduehan: Ja condui Cristo, Tyoꞌtsꞌon jñon jon ja na jndyö. ");
INSERT INTO azgNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Ndoꞌ juu xjen na nndyehoꞌ na jndye joo jndë tyeꞌ ndyiaꞌ, tyiꞌndyuehoꞌ ngꞌe mancüiixjen nndaꞌ vaa na nguaa. Ndoꞌ min na nndaꞌ vaa, majoꞌ tyiꞌcoventyja xjen na ntycüii tsonnangue, jndyentyichen ꞌnan na nndui. ");
INSERT INTO azgNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ee nnꞌan ncüii tsonnangue ntꞌahan tyiaꞌ yo nnꞌan ncüiichen tsonnangue, ndoꞌ ncüii tsanmꞌaantsꞌian tꞌman ntsiquinan jon tyiaꞌ yo ncüiichen tsanmꞌaantsꞌian tꞌman. Ndoꞌ jndye joo ngotsꞌii. Ndoꞌ mantyi ncꞌoon jndoꞌ tꞌman, ndoꞌ nnꞌan ncüii tsjoon nnanꞌntjaꞌ nquehin yo ntyjehin. Joo naviꞌminꞌ ꞌnan na nndui na vejndyee. Ndoꞌ mañoon naviꞌ na majantyichen ngüentyja na ngenon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Cꞌon cjehoꞌ, ee ngoyꞌon nnꞌan judíos ꞌoꞌ tondëë nnꞌan na conintque ntꞌaanꞌon ꞌnaanhan, ndoꞌ majoꞌ ijon na conanꞌtꞌmaanꞌhan Tyoꞌtsꞌon, joꞌ ntjaꞌhanhoꞌ. Yo naviꞌ ngüentyjeeꞌ ꞌoꞌ na tondëë nanmꞌannꞌian tꞌman na ntjiꞌ jndyoyuhoꞌ ndëëhan ntyja ꞌnaanꞌ na covantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Majoꞌ vitjachen na ngitsu tsonnangue, chuhanꞌ na juu jñꞌoon naya ntyja nchu vaa na itsinꞌman Tyoꞌtsꞌon ñuaan nnꞌan, nninncya nnꞌanhanꞌ ndëë ntyjehan na ninvaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Majoꞌ juu xjen na nninncya nnꞌan cüenta ꞌoꞌ nduee nanmꞌannꞌian, min tyiꞌncꞌonhoꞌ jñꞌoontiu na nin jñꞌoon na nnanꞌntcüeꞌhoꞌ ndëëhan. Juu xjenꞌñeen, joo jñꞌoon na nninncyaa Tyoꞌtsꞌon quiiꞌ nꞌonhoꞌ, joohanꞌ quinanꞌntcüeꞌhoꞌ ndëë nanꞌñeen, ee nquii Espíritu Santo ntsijndaꞌ jon nquenhoꞌ nin jñꞌoon na nnanꞌntcüeꞌhoꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Juu xjenꞌñeen xio tsꞌan, nninncyaa jon cüenta juu na nnanꞌcueeꞌ nnꞌanhin. Majoꞌntyi nquii tye tsꞌan nninncyaa jon cüenta joo ntsinda jon na nnanꞌcüje nnꞌan joo. Ndoꞌ mantyi ntsinda tsꞌan nninncya joo cüenta tye joo yo ndyee joo chaꞌ nnanꞌcüje nnꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndoꞌ tsoñꞌen nnꞌan ncꞌonhan na jndohanhoꞌ ngꞌe na conduihoꞌ nnꞌan na mꞌan ntyja njan, majoꞌ juu tsꞌan na vantyja tsꞌon ja, xe na aa tyiꞌncüjihin ntyja njan ata xjen na nnanꞌcueeꞌ nnꞌan juu, ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ndyu na toxenꞌchen, tomꞌaan ncüii tsꞌan na toquijndyu Daniel. Vaa jñꞌoonꞌ Tyoꞌtsꞌon na sinin jon ndëë nnꞌan, quitquen yahoꞌ cüenta juu jñꞌoonꞌñeen chaꞌ ncüaaꞌ ya nꞌonhoꞌhanꞌ. Itsiquindyihanꞌ na ngitaꞌ nnꞌan ncüii ꞌnan na ji vaa quityquiiꞌ juu vatsꞌon tꞌman na quinanꞌtꞌmaanꞌ nnꞌan juuhanꞌ chaꞌxjen nquii Tyoꞌtsꞌon. Juu xjen na njntyꞌiahoꞌ na nndaꞌ vaa, ꞌoꞌ na mꞌanhoꞌ ndyuaa Judea, quinanꞌnonhoꞌ na ncꞌohoꞌ na mꞌan ntyoꞌ na ntantyꞌiuhoꞌ ngꞌe tꞌman jndyi na toncuuꞌ mꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ndoꞌ juu xjenꞌñeen, minninchen tsꞌan na vajndyee juu chꞌeenꞌ juu, tyiꞌntsitiu juu na ngaqueeꞌ nndaꞌ juu quityquiiꞌ vaaꞌ juu na ncüjiꞌ juu ꞌnaanꞌ juu na ngachu juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ndoꞌ mantyi juu xjenꞌñeen, tsꞌan na mꞌaan jndëë na itsꞌaa juu tsꞌian, min tyiꞌndyo ntcüeꞌ juu na ncüjiꞌ juu ndiaasooꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ndoꞌ joo nanntcu na ñjon ndahin juu xjenꞌñeen, viꞌ jndyi ngotjonhin, ndoꞌ mantyi ntyjentcuhin na mꞌan ndahin yoꞌndaa. ");
INSERT INTO azgNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Quitanhoꞌ nnon Tyoꞌtsꞌon na min chito ngueetein na ngenonhoꞌ juu naviꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ngꞌe joo ngueeꞌñeen, ngenon nnꞌan ncüii nnon naviꞌ na minꞌjon tacoquenonhan xjen navejndyee na tquen Tyoꞌtsꞌon juu tsonnangue ata xjen neinhin, min tajon jnda ngenon nndaꞌhan cüii naviꞌ chaꞌna juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ndoꞌ juu naviꞌñeen, xe na aa jndye xuee na ngenon nnꞌanhanꞌ, yajoꞌ matavi jndyehan na nꞌndyihanꞌ. Majoꞌ ngꞌe na viꞌnchjii Tyoꞌtsꞌon joo nnꞌan na icüji jon na nincüentaaꞌ nquii jon, ntsꞌaa jon na cje ro ntycüiihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ngꞌe na nndaꞌ, juu xjenꞌñeen xe na aa ngitso ncüii tsꞌan ndëëhoꞌ: Quijntyꞌiahoꞌ, ntjoo mꞌaan nquii Cristo, oo xe na aa ngitso tsanꞌñeen: Quijntyꞌiahoꞌ, ndö mꞌaan jon, min tyiꞌngantyja nꞌonhoꞌ juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ee ntsquenon nnꞌan quiiꞌ ntꞌanhoꞌ na nnduehin nquehin conduihan Cristo. Nnduehan juu jñꞌoonꞌ Tyoꞌtsꞌon coninncyahan, min na veꞌ jñꞌoon quintu juu jñꞌoon na conanꞌmanhan. Ata nntꞌahan na nndityincyooꞌ jndye nnon jnꞌaan tꞌman yo tsꞌian na tyiꞌjeꞌquinduihanꞌ na veꞌ ntyja najndei nquii tsꞌan. Ndoꞌ joo tsꞌianꞌñeen mandyo na nndëë nnanꞌviꞌnnꞌanhanꞌ nque nnꞌan na icüji Tyoꞌtsꞌon cüentaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Tyuaaꞌchen matsiquindyi ja ꞌoꞌ na nanꞌminꞌ nguaa, ngꞌe joꞌ quitquen ya yahoꞌ cüenta. ");
INSERT INTO azgNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Joo ngueeꞌñeen vi na jndë tenon juu naviꞌ tꞌmanꞌñeen, juu ndoꞌcüjioonꞌ nndijaanhanꞌ, min chiꞌ taxeꞌcüixueehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ndoꞌ ncjuu ntycyaa oꞌ ndoꞌ juu ntjöꞌndue tꞌman ngotsꞌiihanꞌ, yajoꞌ nque na cotoxen na mꞌanhanꞌ ntjöꞌndue, ndyuiiꞌ joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ndoꞌ juu xjenꞌñeen ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, njntyꞌia nnꞌan na nndyö nntꞌa quityquiiꞌ chincyu. Juu xjenꞌñeen nndyö yo na tꞌman vaa na condui ja na matyëꞌntjön yo maninꞌ conduinduiꞌ na conditꞌmaanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Yajoꞌ tsoñꞌen nnꞌan na ninvaa tsonnangue na macüji ja na conduihan cüenta, joo ángeles na cotyentjon nnön, ncꞌua tsꞌian ndëëhan na quinanꞌncüihan joo nanꞌñeen naijon na mꞌan ja. ");
INSERT INTO azgNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Tsꞌoon higuera vaa jñꞌoon na itsiꞌmanhanꞌ ntyja ꞌnaanꞌ joꞌ. Cüaaꞌ ya nꞌonhoꞌ ntyja ꞌnaanꞌ juu jñꞌoonꞌñeen. Juu xjen na cojntyꞌiahoꞌ na condeiꞌ ntꞌöhanꞌ ndoꞌ na conduiꞌ tsco ꞌndaahanꞌ, covaaꞌ nꞌonhoꞌ na jndë tindyo ngueesuaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mantyi xjen na cojntyꞌiahoꞌ na jndë condui nanꞌminꞌ na jndë tsjö ndëëhoꞌ, yajoꞌ cüaaꞌ ya nꞌonhoꞌ na mavaa mavaa xjen na nnan quiñoonꞌndue na nndyö nntꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, nnꞌan na mꞌan naneinhin, tyiꞌxeꞌcüjeñꞌenhan ata na jndë siquindë ñꞌenhanꞌ tsoñꞌen jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Juu tsjöꞌndue yo tsonnangue ntycüiiñꞌenhanꞌ, majoꞌ juu jñꞌoon na mancya tyiꞌjeꞌquintycüii juu najndei na itsixuanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Majoꞌ taꞌnan tsꞌan quintjii nin xuee min yuu xjen na nndyö nntꞌa, min nque ángeles tyiꞌquindiohan yuu xjenhanꞌ, min ja na condui jnda nquii Tyoꞌtsꞌon, xiaꞌntyi nquii Tyëhöꞌ nchjii. ");
INSERT INTO azgNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Mangꞌe na nndaꞌ vaa, joꞌ quitquen ya yahoꞌ cüenta, ndoꞌ quinanꞌneinhoꞌ nnon Tyoꞌtsꞌon ngꞌe tyiꞌndiohoꞌ nin xuee ndoꞌ yuu xjen na nndyö nntꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Majoꞌ ntyja na nndui na nndaꞌ, vaa jñꞌoon na itsiꞌmanhanꞌ ntyja ꞌnaanꞌhanꞌ. Tomꞌaan ncüii tsꞌan, jnduiꞌ jon na chi ncja jon ncüiichen tsonnangue na tycya. Xjen na jnduiꞌ jon, tꞌua jon tsꞌian ndëë nnꞌan na ityeꞌntjon jon. Ndoꞌ nnon juu tsꞌan na iquen cüenta ꞌndyo vaaꞌ jon, tso jon: Cüantyjeꞌ yaꞌ vꞌa viochen xjen na ja tacꞌön. ");
INSERT INTO azgNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ndoꞌ tsontyichen Jesús: Manchaꞌ juu jñꞌoonꞌñeen na tso tsanꞌñeen, manndaꞌ vaa matsjö ndëëhoꞌ: Quitquen ya yahoꞌ cüenta ngꞌe itsijonhanꞌ ntyja njan chaꞌna juu tsanꞌñeen na jnduiꞌ juu vaaꞌ juu. Ndoꞌ ꞌoꞌ, itsijonhanꞌ ꞌoꞌ chaꞌna joo nanꞌñeen na totyentjonhan nnon jon. Ee min tyiꞌquindiohoꞌ yuu xjen na nndyö nntꞌa, aa ntsꞌaahanꞌ na vaman, ndoꞌ aa tsantsjon navejndyee xjen na ntsixuaa quilꞌö, ndoꞌ aa xoncüe tsjon, ndoꞌ aa vi vanco. Tyiꞌquindiohoꞌ yuu xjen na nndyö ntcüꞌë. ");
INSERT INTO azgNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ee xe na aa ninjonto na nndyö ntcüꞌë ndoꞌ ꞌoꞌ tyiꞌcꞌon cjehoꞌ, yajoꞌ ntsijonhanꞌ ntyja ꞌnaanhoꞌ chaꞌvijon tsꞌan itso. ");
INSERT INTO azgNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Juu jñꞌoonvaꞌ na matsjö ndëëhoꞌ, mantyi matsjöhanꞌ ndëë tsoñꞌen nnꞌan na cꞌon cjehan.” ");
INSERT INTO azgNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nnꞌan judíos mꞌaan nguee xjen na vañjoonꞌ nꞌonhan na siquindyaa Tyoꞌtsꞌon ndochihan naviꞌ na toquenon nanꞌñeen ndyuaa Egipto. Juu ngueeꞌñeen jndyuhanꞌ pascua, xjen na cocüaꞌhan tyooꞌ na taꞌnan tsquentë taqueeꞌ. Vechen xuee na vitja na ngueeꞌ juu ngueeꞌñeen, yajoꞌ joo nnꞌan na conintque ndëë ntyee yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, taꞌhan na veꞌ ntyꞌiu tojntꞌuehan nchu vaa nquii ntꞌahan chaꞌ cueꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jnduehan ndëë ntyjehan: —Tyiꞌntꞌa na ntꞌuë vꞌi jon juu xjen na xoncüe na mꞌaan ngueeva, chaꞌ tyiꞌnanꞌvjee nnꞌan jaa. ");
INSERT INTO azgNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tsjoon Betania tomꞌaan Jesús vaaꞌ tsꞌan na jndyu Simón. Juu tsanꞌñeen tondiviiꞌ juu yo tycu ndöꞌ cotöꞌ. Viochen xjen na minndyuaahan mesa, tyjeeꞌnon ncüii tsanscu. Yꞌoon juu ncüii ꞌnan na jndëhanꞌ yo tsjöꞌ quichiꞌ na jndyu alabastro. Tyquiiꞌhanꞌ joꞌ ñjon nchenꞌ quichi na jndyu nardo, jnda jndyi njon juu nchenꞌñeen. Maninꞌ tsꞌiaanꞌhanꞌ na covijntꞌue nnꞌanhanꞌ na cotyehinhanꞌ ntꞌoo. Tanꞌ tsanscuꞌñeen ꞌndyo juu tsiooꞌñeen chaꞌ ya nnduiꞌ nchenꞌñeen, ndë joꞌ scongio juuhanꞌ xquen Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Majoꞌ vendye nnꞌan na mꞌan joꞌ, jnanꞌvjenhan juu tsanscuꞌñeen, jnanꞌnein nquehin yo ntyjehin, jnduehan: —¿Ndu na veꞌ jnꞌaan scongio juu nchenꞌvaꞌ xquen jon? ");
INSERT INTO azgNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yantyichen xe na aa jndëë juuhanꞌ, ngüenon ndye ciento sꞌon denario na ncyꞌoon juu, ndoꞌ na nndaꞌ, ndëë nninjntꞌuehinhanꞌ na ntejndei juu nanninñenꞌ ꞌnan na icanhanꞌhin. Nndaꞌ vaa na jnanꞌmanhan na tyiꞌcaveeꞌ ngiohan ꞌnan na sꞌaa juu tsanscuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Majoꞌ tso Jesús ndëëhan: —Quiꞌndyehoꞌhin na nndaꞌ itsꞌaa juu. ¿Ndu na conanꞌcüejnaanꞌhoꞌhin? Ya jndyi ꞌnan na jndë sꞌaa juu ja. ");
INSERT INTO azgNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ee joo nanninñenꞌ ninnquiiꞌchen mꞌanhan quiiꞌ ntꞌanhoꞌ, ndoꞌ minꞌcya ro xjen na ntꞌue nꞌonhoꞌ ndëë ntejndeihoꞌ joohan. Majoꞌ ja jeꞌ, chito manchaꞌxjen na ncꞌön yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Tsanscuvahin jndë sꞌaa juu yuu vantyi na jndëë sꞌaa juu. Ee vitjachen na ncüꞌiö ndoꞌ jndë tyio juu nchenꞌ quichi cjö chaꞌxjen contꞌa nnꞌan xjen na conanꞌjndaꞌhan na ntyꞌiuhan tsꞌoo. ");
INSERT INTO azgNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, minꞌcya ro joo na ninvaa tsonnangue na nninncya nnꞌan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon, quinanꞌneinhan ntyja ꞌnaanꞌ juu nayavaꞌ na sꞌaa juu ja, chaꞌ quiñjon nꞌon nnꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jndë na tui na nndaꞌ, ndoꞌ cüii nque nnꞌan na nchoꞌve na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, tsan na jndyu Judas Iscariote, tja juu na mꞌan nque ntyee na conintque ndëë nnꞌan judíos. Tatsijndaꞌ juu jñꞌoon yo joohan na ninncyaa juu cüenta Jesús ndueehan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ndoꞌ joo nanꞌñeen, tyioo na nein jndyihan na jndyehan na nndaꞌ sitiu juu. Jnduehan na nnincyahan sꞌon na ngüantjon juu. Joꞌ taꞌ juu na tontꞌue juu nchu ya ntsꞌaa juu na nnincyaa juu cüenta Jesús ndueehan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xee na vejndyee na mꞌaan nguee pascua, xjen na nque nnꞌan judíos cocüaꞌhan tyooꞌ na tatsquentë taqueeꞌ, maninjuu xuee na conanꞌcüjehan quinman quijndë, nque nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa Jesús, taxeeꞌhan nnon jon, jnduehan: —¿Yuu jon ntꞌue tsonꞌ na nnanꞌjntꞌá na ntcüaꞌ quitsman chjo ntyja ꞌnaanꞌ juu nguee pascua? ");
INSERT INTO azgNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Yajoꞌ tꞌua jon tsꞌian ndëë ve nanꞌñeen na cꞌohan cüii ntꞌaa. Tso jon ndëëhan: —Quitsaqueꞌhoꞌ quiiꞌ tsjoon, joꞌ ntjonhoꞌ ncüii tsansꞌa na yꞌoon juu tsjö ndaa. Quitsantyjahoꞌ naxenꞌ tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ndoꞌ vꞌaa na ngaqueeꞌ juu, quinduehoꞌ nnon tsꞌan na vaaꞌ juu vꞌaaꞌñeen: “Nquii ta na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, tso jon ndë́ na quinduë́ nnonꞌ: ¿Yuu jon vaa cuarto na ninjntꞌuehin na ntcüꞌa quitsman chjo yohin tman nein?” ");
INSERT INTO azgNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ndoꞌ juu tsanꞌñeen ntsiꞌman jon ndëëhoꞌ ncüii cuarto tꞌman vꞌaa vja vequitoꞌ na tsoñꞌen ꞌnan jndë min na ninjntꞌue na ntꞌa ngueeva. Joꞌ quinanꞌjndaꞌhoꞌ na ntcüꞌa. ");
INSERT INTO azgNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ndoꞌ ve nanꞌñeen jeꞌ, jnduiꞌhan, tyequeꞌhan quiiꞌ tsjoon. Ndoꞌ tui tsoñꞌen chaꞌxjen na jndë tso Jesús ndëëhan. Joꞌ jnanꞌjndaꞌhan na ntcüaꞌhan quitsman chjo ntyja ꞌnaanꞌ juu nguee pascuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ndoꞌ vi na jndë contsjë chjo min, tueeꞌ Jesús yo nque nnꞌan nchoꞌveꞌhin joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ndoꞌ viochen xjen na vendyuaahan na cocüaꞌhan, tso jon ndëëhan: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, cüii nquehoꞌ na icüaꞌ juu yo ja, nein nninncyaa juu cüenta ja. ");
INSERT INTO azgNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Juu jñꞌoonꞌñeen sichjooꞌ jndyihanꞌ nꞌonhan, tyeꞌ totaxeeꞌhan nnon jon, jnduehan: —¿Aa nndëë ntsꞌaahanꞌ na ja ntsꞌaa na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ndoꞌ joꞌ tꞌa Jesús jndyuehan, tso jon: —Mancüii nquehoꞌ na nchoꞌvehoꞌ na vendyuaahoꞌ mesavahin na ninvixjen ijoon juu quiiꞌ xio yo ja, juu nninncyaa cüenta ja nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ncüꞌiö chaꞌxjen juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui jndë itsiquindyihanꞌ na ngenön, majoꞌ vaa viꞌ jndyi ngenon juu tsꞌan na nninncyaa cüenta ja. Yantyi xe na tatuihin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ndoꞌ viochen xjen na cocüaꞌhan, tyꞌoon Jesús tyooꞌ, tyincyaa jon na ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ, ndoꞌ ndë joꞌ tyje jon ntanꞌhanꞌ, ndë tꞌon jonhanꞌ ndëëhan. Tso jon: —Cyꞌonhoꞌ tyooꞌmin na conduihanꞌ siꞌtsꞌo njan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ndë joꞌ majoꞌntyi tyꞌoon jon cüii vaso na ñjon vinon. Ndoꞌ vi na jndë tyincyaa jon na ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ, ndë joꞌ tyincyaa jonhanꞌ ndëëhan, ndoꞌ tsoñꞌenhan tëhan juu nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ndoꞌ tso jon ndëëhan: —Nanꞌvahin tsixuanhanꞌ nꞌeön. Mancya na ntcüeꞌhanꞌ ntyja ꞌnaan jndye nnꞌan. Na yo juuhanꞌ contjotyen juu jñꞌoon xco na itsijndaꞌ Tyoꞌtsꞌon yo nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, taxeꞌcꞌua nntꞌa vinon ata ngueeꞌ xjen na ityeꞌntjon Tyoꞌtsꞌon tsoñꞌen, juu xjenꞌñeen ncꞌua vinon xco. ");
INSERT INTO azgNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ndoꞌ vi na jndë tahan joo Salmos na mancüiixjen cota nnꞌan judíos jndë na tcüaꞌhan juu ngueeꞌñeen, joꞌ jnduiꞌhan juu vꞌaaꞌñeen, tyꞌehan tyoꞌ naijon mintyjeeꞌ nꞌoon olivos. ");
INSERT INTO azgNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ndoꞌ tso Jesús ndëëhan: —Quiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon itsiquindyihanꞌ ntscueeꞌ jon nquii tsꞌan na vantyjeeꞌ quinman, ndoꞌ joo choꞌñeen ntycya oꞌ. Nndaꞌ vaa na ngenonhoꞌ, nnanꞌcueeꞌ nnꞌan ja ndoꞌ ꞌoꞌ nꞌndyehoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ndoꞌ tsontyichen Jesús: —Majoꞌ xjen na jndë vantꞌö xcö, ncjö jndyëë Galilea, joꞌ cꞌohoꞌ na mꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ndoꞌ joꞌ tso Pedro nnon Jesús: —Tsoñꞌen nanmin, min xe na aa quitjihan ntyja ꞌnanꞌ, majoꞌ ja tyiꞌjeꞌcüji ja. ");
INSERT INTO azgNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ndoꞌ sintcüeꞌ Jesús jñꞌoon nnon juu, tso jon: —Matsjö nnonꞌ, majuuntyi tsjonvahin, vitjachen na ntsixuaa quilꞌö na ve jnda, majoꞌ ꞌuꞌ jndë ndye jnda macüji ꞌuꞌ na mꞌanꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Majoꞌ ninvito na tso Pedro: —Min na quitscüeeꞌhanꞌ ja ntyja ꞌnanꞌ, majoꞌ tyiꞌxeꞌcüji ja. Ndoꞌ tsoñꞌenhan maninnquiiꞌ nndaꞌ na jnduehan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Vi jndë joꞌ squehan cüii joo na conanꞌquijndyu nnꞌanhanꞌ Getsemaní. Joꞌ tso Jesús ndëëhan: —Cꞌuhoꞌ ndöhin, jö ndöꞌ na ntsinën nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ndoꞌ joꞌ tjantyichen jon, tayꞌoon jon Pedro, Jacobo yo ninꞌJuan. Ndoꞌ tyeꞌ tyioo na itsiꞌndaaꞌhanꞌ nchjii jon yo na itsichjooꞌhanꞌ tsꞌon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tso jon ndëë ndye nanꞌñeen: —Itsichjooꞌ jndyihanꞌ tsꞌön ꞌnan na ngenön, ata ntscueeꞌhanꞌ ja. Joꞌ quintjohoꞌ chjo ndöhin, quitquen yahoꞌ cüenta, chito ndahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ndoꞌ joꞌ tjantyichen jon, tëcüangio jon nnon tyuaa. Tcan jon nnon Tyoꞌtsꞌon xe na aa ndëë ninncyaa jon na tyiꞌngenon juu naviꞌ na ndyontyja nacjooꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tso Jesús: —Nndaꞌ Tyeꞌ, tsoñꞌen na condëë matsaꞌ. Macꞌan na quitsiquindyaꞌ ja yo juu naviꞌvahin, majoꞌ tanin, quindui ntyja na ntꞌue tsonꞌ, tachi chaꞌxjen na ntꞌue tsꞌön.” ");
INSERT INTO azgNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ndë joꞌ jndyo ntcüeꞌ jon naijon jntyꞌii jon ndye nanꞌñeen. Ndoꞌ ntjii jonhan na condahan. Joꞌ sintcüi jonhan. Ndoꞌ tso jon nnon Pedro: —ꞌUꞌ Simón, ¿Aa vatsuꞌ? ¿Aa ndiquinanꞌ tsantsjon min na veꞌ ninncüii hora? ");
INSERT INTO azgNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ninnquiiꞌchen cꞌoncjehoꞌ, ndoꞌ quinanꞌneinhoꞌ nnon Tyoꞌtsꞌon chaꞌ juu xjen na itsichon yutyia na quityiiꞌhanꞌ ngꞌeehanꞌ ꞌoꞌ, jeꞌquindëë ngüantjon juu yohoꞌ. Ntyji na ninꞌquintꞌahoꞌ na nndaꞌ, majoꞌ ngꞌe juu siꞌtsꞌo ꞌnaanhoꞌ cjehanꞌ, joꞌ na ndiquindëë nnanꞌquindëhoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jndë joꞌ tja nndaꞌ jon naijon sinin jndyee jon nnon Tyoꞌtsꞌon, maninjuuntyi jñꞌoonꞌñeen sinin nndaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ndë joꞌ tyjeeꞌ ntcüeꞌ jon na mꞌan nanꞌñeen, cüiichen jon ntjii jonhan na condahan ngꞌe ta jndyi na jndë tyꞌoon tsantsjonhan. Min tyíꞌquindiohan nin jñꞌoon na ntꞌahan ꞌndyo jon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ndoꞌ mantyi tja nndaꞌ jon na vja ndye, ndë joꞌ tja ntcüeꞌ jon na mꞌanhan. Tso jon ndëëhan: —¿Aa jndë tacjohoꞌ na condahoꞌ na cotajndyeehoꞌ? Cuaanquii ndöꞌ ro, ngꞌe jndë tueeꞌ xjen na nninncyaa tsꞌan cüenta ja nduee nnꞌan na nanꞌxuan jnan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Cüa, quinanquintyjahoꞌ, ncꞌö. Ndöviꞌ jndë ndyo juu tsꞌan na nninncyaa cüenta ja nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ninvaa na itsinin Jesús jñꞌoonvaꞌ ndoꞌ tyjeeꞌnon juu Judas, juu ncüii nque na nchoꞌve nnꞌan na totsayꞌonhan jñꞌoon yo jon. Jndye nnꞌan sque yohin, chohan ncjo espadas yo nonnchꞌio. Joo nanꞌñeen nnꞌan cüenta ntyee na conintque ntyja ꞌnaan nnꞌan judíos yo ninꞌnnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés yo nnꞌan na conintque nnon tsjoon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ndoꞌ juu Judasꞌñeen, tsan na tyincyaa cüenta Jesús nduee nanꞌñeen, jndë siꞌman juu ndëëhan nchu vaa ꞌnan ntsꞌaa juu. Itso juu: “Nquii juu tsan na cojntyꞌiahoꞌ na maꞌua ja ntsmaanꞌ na mancya tsꞌonhin, majon joꞌ, quitꞌuetyenhoꞌhin ndoꞌ quintꞌahoꞌ cüenta xjen na ntsayꞌonhoꞌ jon.” ");
INSERT INTO azgNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ndoꞌ ya na tyjeeꞌnon juu na mꞌaan Jesús, jndyoyu nnon jon na tueeꞌ juu. Tso juu nnon jon: —¿Aa mꞌanꞌ ta? Ndë joꞌ tyincyaa juu tsꞌon Jesús na tꞌu juu ntsmaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Yajoꞌ joo nanꞌñeen na tëchu juu, tꞌuehan Jesús, tyeyꞌonhan jon na quitꞌuiiviꞌhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Majoꞌ ncüii tsꞌan na tovayꞌoon juu jñꞌoon yo Jesús na minntyjeeꞌ juu joꞌ, tjiꞌ juu xjooꞌ juu, ndoꞌ tyjee juu tsöꞌnqui juu tsan na ityeꞌntjon nnon nquii tyee na conintque ndëë ntyee. ");
INSERT INTO azgNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ndoꞌ taxeeꞌ Jesús ndëë nanꞌñeen na squehan naijon mꞌaan jon: —¿Aa yo ncjo espadas ndoꞌ yo nonnchꞌio jndyoquitꞌuehoꞌ ja chaꞌvijon contꞌa nnꞌan na ntꞌuehan tsanchꞌuee? ");
INSERT INTO azgNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ja ꞌio ꞌio na totsiꞌman ndëëhoꞌ quiiꞌ vatsꞌon tꞌman, ndoꞌ tatyꞌonhoꞌ ja. Majoꞌ tanin min na nndaꞌ contꞌahoꞌ ja chaꞌ quitsiquindëhanꞌ joo jñꞌoon na jndui ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ndoꞌ nque nnꞌan na totsayꞌonhan jñꞌoon yo Jesús, jnanꞌnonhan, jntyꞌehan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Majoꞌ tantyja cüii tsansꞌandyua na tonquenꞌ nanꞌñeen na veꞌ xiaꞌntyi sábana vetyjohin, ndoꞌ tꞌue nanꞌñeen juu sábana na vetyjohin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Joꞌ jntyꞌii juu ndiaaꞌñeen, tja juu na ninquisihin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ndoꞌ joo nanꞌñeen, tyeyꞌonhan Jesús vaaꞌ nquii tyee na conintque ndëë ntyee. Ndoꞌ tsoñꞌen nnꞌan na conintque ndëë joo ntyeeꞌñeen, tetjonhan joꞌ, yo nque nnꞌan na conintque nnon tsjoon ndoꞌ yo ninꞌnnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen nquii Moisés. ");
INSERT INTO azgNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Majoꞌ Pedro jeꞌ, tycya tycya tantyja juu. Tueeꞌ juu vaaꞌ juu tyee na conintqueꞌñeen, joꞌ ntjohin chꞌen, tëcüetyen juu quiiꞌ ntꞌan nanntꞌei cüentaaꞌ vatsꞌon, itoonꞌ juu chon yohin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ndoꞌ nque nnꞌan na conintque ndëë ntyeeꞌñeen, yo tsoñꞌen nanmꞌannꞌian ꞌnaan nnꞌan judíos, tojntꞌuehan nnꞌan na ninncya jnaanꞌ Jesús. Ee chaꞌ ndëë na quitꞌuiityenhanꞌhin na vaa jnaanꞌ jon, icanhanꞌ ve tsꞌan na nincüajon juu jñꞌoon na nninncyahan ntyja ꞌnaanꞌ jon chaꞌ quitsijndaꞌhanꞌ na quinanꞌcueeꞌ nanmꞌannꞌian tsjoon Roma jon. Majoꞌ tatijndaꞌ ve tsꞌan na nincüajon jñꞌoon tyincya. ");
INSERT INTO azgNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Majoꞌ jndye nnꞌan jnanꞌnein jñꞌoon quintu nacjooꞌ jon, majoꞌ joo jñꞌoonꞌñeen min tyiꞌcüajonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Yajoꞌ jnanꞌquintyja vendyechen nnꞌan na tyincya jnaanꞌ jon. Majoꞌ veꞌ quintu jnanꞌneinhan, jnduehan: ");
INSERT INTO azgNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Já jndyë́ na tso tsanvaꞌ na ntsityuiiꞌ jon vatsꞌon tꞌman njanhan na jnanꞌya nnꞌan, ndoꞌ ninndye xuee na ntsia jon ncüiichenhanꞌ na tachito nnꞌan na nnanꞌyahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Majoꞌ min na nndaꞌ jndue nanꞌñeen, tatijon juu jñꞌoon na jnanꞌneinhan. ");
INSERT INTO azgNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Yajoꞌ nquii tsꞌan na conintque ndëë ntyee, tacüentyjeeꞌ jon quiiꞌ ntꞌan joo nanꞌñeen, taxeeꞌ jon nnon Jesús: —¿Ndu na tyiꞌcüꞌaꞌ joo jñꞌoon na condue nanminꞌ nacjoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Majoꞌ Jesús, tajñꞌoon sintcüeꞌ jon, minꞌncüii jñꞌoon tatꞌa jon. Ndoꞌ na nndaꞌ, juu tyee na conintqueꞌñeen, taxeeꞌ nndaꞌ juu nnon jon: —ꞌUꞌ jeꞌ, ¿Aa condui ꞌuꞌ Cristo, jnda nquii Tyoꞌtsꞌon na conanꞌtꞌmánꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ndoꞌ joꞌ tꞌa Jesús, tso jon: —Mayuuꞌ joꞌ condui ja, ndoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, njntyꞌiahoꞌ na mavaquityën ngiaaꞌ jon tontyjaya. Ndoꞌ mantyi njntyꞌiahoꞌ na nndyö nntꞌa quityquiiꞌ chincyu na nnan ja quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ndoꞌ juu tyee na conintqueꞌñeen, vi na jndë jndyii jon na nndaꞌ, tye jon ndiaaꞌ jon na quindyaꞌ jndyi ntyjii jon, ee ntyja na tjiꞌ jon cüenta na tꞌman jnan tsixuan Jesús ngꞌe na nndaꞌ jñꞌoon sintcüeꞌ jon. Ndoꞌ juu tyeeꞌñeen tso jon ndëë nnꞌan na totsayꞌonhan jñꞌoon yo jon: —¿Aa icanntyichenhanꞌ ncüiichen tsꞌan na ninncyaa jnaanꞌ juu? ");
INSERT INTO azgNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nquehoꞌ jndë macondyehoꞌ juu jñꞌoon tsanꞌ na itsinin juu nacjooꞌ nquii Tyoꞌtsꞌon. Itso juu na conduihin jnda nquii jon. ¿Nin conduehoꞌ na tsixuan juu na quitjon juu? Ndoꞌ tsoñꞌen nanꞌñeen tꞌahan, jnduehan: —Tsixuan juu jnan. Chuhanꞌ na cueeꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ndoꞌ vendye nanꞌñeen taꞌhan totjueꞌhan ndaa jndyuehan jon, tëꞌhan nnon jon, ndoꞌ totueinꞌhan ndaꞌhin. Conduehan: —Cüa, quitsuꞌ nin tsꞌan icüjaꞌ ꞌuꞌ. Ndoꞌ mantyi joo nanntꞌeiꞌñeen totuinꞌhin ndaꞌ chcyaaꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ndoꞌ viochen xjen na mꞌaan Pedro tochꞌen juu vꞌaaꞌñeen na tocje, tyjeeꞌ cüii tsanscu na ityeꞌntjon juu nnon nquii tyee na conintqueꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Na jndyiaaꞌ juu na itoonꞌ Pedro chon, mavio chjo xjen jndyiaaꞌ juu nnon jon. Tso juu: —Mantyi ꞌuꞌ toquiñꞌen ꞌuꞌ yo juu Jesús, tsan na jnan Nazaret. ");
INSERT INTO azgNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Majoꞌ Pedro tjihin, tso jon: —Minꞌchjo tyiꞌcüajnꞌan tsanꞌñeen, min tyiꞌquintji ntyja ꞌnaanꞌ juu jñꞌoon na tsuꞌ ndöꞌ. Yajoꞌ sꞌaa jon vi ntyja, tja jon naijon mꞌaan ꞌndyo teon. Ndoꞌ juu xjenꞌñeen sixuaa quilꞌö. ");
INSERT INTO azgNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ndoꞌ majuuntyi tsanscuꞌñeen jndyiaaꞌ nndaꞌ juuhin. Taꞌ juu itso juu ndëë nnꞌan na mꞌan joꞌ: —Tsanvahin, juu ncüii nque nnꞌan na itsijonhin yo juu Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Majoꞌ tji nndaꞌ Pedro. Ndoꞌ min tyiꞌcovivioto xjen, nque nnꞌan na mꞌan joꞌ, jnduehan nnon jon: —Mayuuꞌ jñꞌoon na condui ꞌuꞌ ncüii joohan, ngꞌe juu jñꞌoon na matsininꞌ, cüajonhanꞌ yo juu jñꞌoon na conanꞌnein nnꞌan ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ndoꞌ taꞌ Pedro, itsinin jon jñꞌoon tsan cjooꞌ Tyoꞌtsꞌon, itso jon: —Ja minꞌchjo tyiꞌcüajnꞌan juu tsꞌan na conduehoꞌ ndöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ndoꞌ maninñoonꞌ sixuaa nndaꞌ quilꞌö na vja ve. Joꞌ tañjoonꞌ tsꞌon Pedro juu jñꞌoon na jndë tso Jesús nnon jon: “Vitjachen na ntsixuaa quilꞌö na vja ve, majoꞌ ꞌuꞌ jndë ndye jnda na macüji ꞌuꞌ ntyja njan.” Ndoꞌ ya na tëñjoonꞌ tsꞌon jon juu jñꞌoonvaꞌ, tꞌioo vichen tsꞌon jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ya na tonco ncüiichen xuee, yajoꞌ joo ntyee na conintqueꞌñeen, jnanꞌtjonhan nnꞌan na conintque nnon tsjoon, yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés yo ninꞌtsoñꞌen nanmꞌannꞌian ꞌnaan ntyjehan nnꞌan judíos. Ndoꞌ jnanꞌtyenhan Jesús, tyencyahan cüenta jon ntꞌö nquii Pilato. ");
INSERT INTO azgNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ndoꞌ juu Pilato, taxeeꞌ jon nnon Jesús, tso jon: —Joo ntyꞌiuꞌ nnꞌan judíos, ¿Aa condui ꞌuꞌ nquii tsꞌan na coꞌxen joohan? Ndoꞌ joꞌ tꞌa Jesús, tso jon: —Mayuuꞌ joꞌ chaꞌxjen na matsuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ndoꞌ nque ntyee na conintqueꞌñeen, jndye jnaanꞌ jon tyincyahan nnon Pilato. ");
INSERT INTO azgNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ndoꞌ taxeeꞌ nndaꞌ jon nnon Jesús, tso jon: —¿Ndu na tyiꞌcüꞌaꞌ? Quenꞌ cüenta jndye jnanꞌ na concya nanminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Majoꞌ tajñꞌoon sintcüeꞌ Jesús, taxjen ndicüaaꞌ tsꞌon Pilato ndu na nndaꞌ vaa na sꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ndoꞌ chu ro chu ro, xjen na coveeꞌ juu nguee pascua, ncüii tsꞌan judío na mꞌaan juu naviꞌ ntꞌö Pilato na ngitan nnꞌan ntyje judíos juu na quitsiquindyaa jonhin ndueehan, totsꞌaa jon na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ndoꞌ juu xjenꞌñeen, jndye nnꞌan mꞌan vancjo jnaanꞌ na jnanꞌvehan nacjo nanmꞌannꞌian ndoꞌ na jnanꞌcüjehan nnꞌan. Ncüii joohan na mꞌaan naviꞌ, tsan na jndyu Barrabás. ");
INSERT INTO azgNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ncüii tmaanꞌ nnꞌan judíosꞌñeen, jnanꞌndyooꞌhan na mꞌaan Pilato. Taꞌhan na tanhan na quitsiquindyaa jon ncüii tsꞌan na mꞌaan naviꞌ ndueehan chaꞌxjen na mancüiixjen itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ndoꞌ joꞌ taxeeꞌ jon ndëë nanꞌñeen: —ꞌOꞌ nnꞌan judíos, juu tsꞌan na conduihin na coꞌxen jon ꞌoꞌ, ¿Aa ntꞌue nꞌonhoꞌ na ndueehoꞌ nninncyahin? ");
INSERT INTO azgNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Ndöꞌ jñꞌoon itso Pilato ngꞌe jndë ivaaꞌ tsꞌon jon na nque ntyee na conintque, tyincyahan Jesús ntꞌö jon ngꞌe na jndohanhin. ");
INSERT INTO azgNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Majoꞌ nque ntyee na conintqueꞌñeen, jnanꞌjmiinꞌhan joo nanꞌñeen na quitanhan nnon Pilato na quitsiquindyaa jon juu Barrabásꞌñeen, chito nquii Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ngꞌe joꞌ taxeeꞌ nndaꞌ Pilato ndëë nnꞌan judíosꞌñeen: —Ndoꞌ na nndaꞌ, ꞌoꞌ nnꞌan judíos, ¿Nin ꞌnan ntꞌue nꞌonhoꞌ na quitsꞌa yo juu tsꞌan na conduehoꞌ na conduihin na coꞌxen jon ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Jnanꞌxuaahan, jnduehan: —Cüa, quitꞌionꞌhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Tꞌa Pilato jndyuehan, tso jon: —¿Ndu? ¿Nin jnaanꞌ juu vaa na ngiohoꞌ? Majoꞌ jnanꞌxuaa nndaꞌhan, jnduehan: —Cüa, maninjon ro quitꞌionꞌhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ndoꞌ ngꞌe juu Pilato ntꞌue tsꞌon jon na quitjiꞌ nanꞌñeen cüenta na ya tsꞌanhin yohan, yajoꞌ tꞌua jon tsꞌian na quindyaa juu Barrabásꞌñeen chaꞌxjen na ntꞌue nꞌonhan. Ndë joꞌ tꞌua jon tsꞌian na quitjaꞌ sondaro ꞌnaanꞌ jon nquii Jesús. Ndoꞌ jndë joꞌ tyincyaa jon juu nduee joo sondaroꞌñeen na quitꞌionhanhin nnon tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ndoꞌ sondaroꞌñeen, tyeyꞌonhan Jesús quityquiiꞌ vatsꞌian ꞌnaanꞌ nquii gobernado. Ndë tqueenꞌhan tsoñꞌen ntyje sondarohan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ndë joꞌ jnanꞌcüehan ncüii ndiaa colo venton Jesús chaꞌna ndiaa cocüe nque nnꞌan na cotoxen, ndoꞌ jnanꞌyahin ncüii tsei yo ntꞌööneon, tyionhan juuhanꞌ xquen jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ndë joꞌ taꞌhan concyahan tsꞌonhin chaꞌvijon na mayuuꞌ na contꞌahan na njonhin. Jnduehan: —Vaa tꞌman jndyi condui ꞌuꞌ, ninncuꞌ na condui na matyeꞌntjonꞌ ntyꞌiuꞌ nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ndoꞌ totueinꞌhan tsonjnein xquen jon, mantyi totjueꞌhan ndaa jndyuehan jon, ndoꞌ totonquityehan na veꞌ contꞌa nquehan na conanꞌtꞌmaanꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nndaꞌ vaa na tonanꞌcüejnaanꞌhan jon. Ndë joꞌ tjiꞌ ntcüeꞌhan juu ndiaa colo ventonꞌñeen, jnanꞌcüe ntcüeꞌhan juu ndiaaꞌ jon. Jndë joꞌ tyeyꞌonhanhin na ntꞌionhan jon tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Xjen na sanduiꞌhan quiiꞌ tsjoon, joꞌ tjonhan ncüii tsꞌan na jnan jndëë. Simón jndyu tsanꞌñeen, tuihin ndyuaa Cirene. Ntsinda juu jndyu Alejandro yo Rufo. Yo naijndeiꞌhanꞌ jntꞌa sondaroꞌñeen na cayꞌoon juu tsonjnꞌaan na ntꞌionhan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yajoꞌ tyeyꞌonhan Jesús ncüii joo na jndyu Gólgota. Juu jñꞌoonvahin itsohanꞌ: “Tyoꞌ Tsiꞌxquen Tsꞌoo.” ");
INSERT INTO azgNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Joꞌ tyincyahan vinon na jndë tjonꞌhanꞌ yo cüii nasi na jndyu mirra na ncꞌu jon chaꞌ tyiꞌntquiihanꞌhin. Majoꞌ tyíꞌcꞌu jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ndoꞌ tꞌion sondaroꞌñeen jon tsonjnꞌaan. Ndoꞌ tyꞌehan xꞌiaaꞌ chaꞌ njntyꞌiahan nin ncüii joohan na ngacüjaꞌhanꞌ ncüii cüii ndiaaꞌ jon. Nndaꞌ vaa na tꞌonhan ndiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Chaꞌ vi na ñjen navitsjoon xjen na tꞌionhan jon tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ndoꞌ mantyi joꞌ tꞌionhan ncüii tscaaꞌ nnonhanꞌ, joꞌ jndui juu jnan na tsixuan jon na tijndaꞌ na cueꞌ jon chaꞌ na nnanꞌjnꞌaan nnꞌan juuhanꞌ. Jñꞌoonꞌñeen itsohanꞌ: “Tsanvahin conduihin tsan na taquintyja coꞌxen juu nnꞌan judíos.” ");
INSERT INTO azgNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ndoꞌ mandyo joꞌ, mantyi taꞌhan mañoon ve nonjnꞌaan na tꞌionhan nanntyꞌuee. Ncüii tsanꞌñeen ngiaaꞌ jon tontyjaya ndoꞌ ncüiichenhin ngiaaꞌ jon tontyjantymaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ndoꞌ na tui na nndaꞌ, joꞌ siquindëhanꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui tivio na itsohanꞌ: Quiiꞌ ntꞌan nnꞌan na tꞌman jnanꞌtjahan, joꞌ jnanꞌñꞌenhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ndoꞌ nnꞌan na tovenon joꞌ tonanꞌcüejnaanꞌhan jon, tonanꞌcahan nquenhan na tyiꞌcueeꞌ nꞌonhan jon. Tonduehan: —¿Aa veꞌ ꞌuꞌ na ntsityuiꞌ juu vatsꞌon tꞌman nján ndoꞌ na ninndye xuee ntsiaꞌ xcoꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Cüa, quitsinꞌman nquii ꞌuꞌ. Quindyocueeꞌ na ñonꞌ juu tsonjnꞌaanvahin. ");
INSERT INTO azgNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ndoꞌ mantyi nque ntyee na conintqueꞌñeen, yo ninꞌnnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, tonanꞌcüejnaanꞌhan jon. Jnduehan: —Tsanvahin, va ya jndyi totsinꞌman juu nnꞌan, majoꞌ ndiquindëë ntsinꞌman nquiihin. ");
INSERT INTO azgNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Xe na aa njntyꞌia na ndyocue juu tsonjnꞌaanvahin, yajoꞌ ngantyja nnꞌön na conduihin Cristo, nquii jon na tsixuan na coꞌxen jaa nnꞌan Israel. Ndoꞌ mantyi joo nanꞌñeen na ñoon nonjnꞌaan na ventyjeeꞌ ngiaaꞌ jon, majuuntyi jñꞌoon jnduehan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ndoꞌ vi na jndë tueeꞌ yajminꞌ, sꞌaahanꞌ na tijaan tsonnangue ata xjen na ndye na matman. ");
INSERT INTO azgNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ndoꞌ majuu xjenꞌñeen, jndei sixuaa Jesús yo jñonꞌndaa ꞌnaanꞌ jon, tso jon: —Eloí, Eloí, ¿Lama sabactani? Juu jñꞌoonꞌñeen itsiquindyihanꞌ: Tyeꞌ Tyoꞌtsꞌon, ¿Ndu na maꞌndyiꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ndoꞌ vendye nnꞌan na mꞌan joꞌ, jndyehan na nndaꞌ vaa na tso jon. Jnduehan: —¿Aa jndyehoꞌ na itsixuaa jon Elías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen? ");
INSERT INTO azgNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ndoꞌ ncüii tsꞌan na mꞌan joꞌ, jnannon juu, tacyꞌoon juu ncüii ꞌnan na nchjaꞌ, nchje juuhanꞌ quiiꞌ vinon të, jndë joꞌ tyio juuhanꞌ nnon ncüii tsꞌoon chaꞌ ya ngueeꞌhanꞌ ꞌndyo Jesús na ngitei jonhanꞌ. Tso tsanꞌñeen: —Quindyehoꞌ, njntyꞌia aa nndyo nquii Elías na ndyoquitsquioo jon juu na ñoon juu tsonjnꞌaanvahin. ");
INSERT INTO azgNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Vi jndë joꞌ, jndei sixuaa Jesús, tueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ndoꞌ juu ndiaa na ntyjatꞌio quiiꞌ vatsꞌon tꞌmanꞌñeen na itscuꞌhanꞌ naijon na jiꞌuantyichen tsixuanhanꞌ, jndyiiꞌ tcohanꞌ ata xjen nnontyuaachen. ");
INSERT INTO azgNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ndoꞌ juu capitán na minntyjeeꞌ na tonnon Jesús, ya na jndyii juu na sixuaa jon, ndoꞌ na tueꞌ jon, yajoꞌ tso juu: —Tsanvahin mayuuꞌ conduihin jnda Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ndoꞌ mantyi vendye nanntcu na tycya chjo ventyjeeꞌ, jntyꞌiahan na nndaꞌ vaa ꞌnan na tui. Quiiꞌ ntꞌan joo nanntcuꞌñeen mꞌaan María, tsan tsjoon Magadán, yo Salomé yo ninꞌcüiichen María, ndyee José yo Jacobo, tyje José. ");
INSERT INTO azgNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Joo nanntcuminꞌ tonanꞌjonhan yo Jesús xjen na tomandyiꞌ jon Galilea na totejndeihan jon ꞌnan na tocanhanꞌhin. Ndoꞌ mantyi joꞌ mꞌan vendyechen nanntcu na jnanꞌjonhan yo jon na jnan jon Galilea na tja jon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Juu xjenꞌñeen majndë contsjë chjo min, ndoꞌ juu xueeꞌñeen, joꞌ xuee na nque nnꞌan judíos conanꞌjndaꞌhan ꞌnan na ninjntꞌuehan juu xuee na cotaꞌjndyeehan. ");
INSERT INTO azgNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mantyi joꞌ vijon mꞌaan ncüii tsꞌan tsjoon Arimatea, juu tsanꞌñeen jndyu jon José. Tꞌman conduihin quiiꞌ ntꞌan nanmꞌannꞌian cüenta nnꞌan judíos. Mantyi juu jon minndooꞌ jon na ngueeꞌ xjen na ndityincyooꞌ juu na ityeꞌntjon Tyoꞌtsꞌon. Yajoꞌ sisaaꞌ tsꞌon tsanꞌñeen, taqueeꞌ jon na mꞌaan Pilato. Tëcan juu siꞌtsꞌo ꞌnaanꞌ Jesús nnon tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ndoꞌ nquii Pilato, sitsanꞌ chjohanꞌhin xjen na jndyii jon na nndaꞌ. Tomꞌaanꞌ jndyi tsꞌon jon ¿Aa yuuꞌ joꞌ na jndë tueꞌ Jesús? Ndoꞌ na nndaꞌ, tqueenꞌ jon nquii capitánꞌñeen na ngüaxeeꞌ jon nnon juu, ¿Aa mayuuꞌ na jndë tueꞌ Jesús? ");
INSERT INTO azgNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ndoꞌ vi na jndë tso juu capitánꞌñeen na mayuuꞌhanꞌ, yajoꞌ tyincyaa Pilato jñꞌoon na juu Joséꞌñeen, ya ngayꞌoon jon juu siꞌtsꞌo ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ndoꞌ tja José, tëtsijnda juu ncüii sábana ya na jndëhanꞌ yo tsan lino, ndë isquioo juu siꞌtsꞌo ꞌnaanꞌ Jesús tsonjnꞌaan, iscüetyjo juu sábanaꞌñeen jon. Ndë joꞌ tyꞌiu juuhin ncüii tsëꞌtsjöꞌ na jnanꞌya nnꞌan ncüii ngiaaꞌ tyoꞌ chaꞌxjen cotyꞌiu nnꞌan judíos ntꞌoo. Ndë joꞌ iscuꞌ juu ꞌndyo tsëꞌtsjöꞌñeen yo ncüii tsjöꞌ tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ndoꞌ juu María, tsan na jnan tsjoon Magadán yo María ndyee José, jntyꞌiahan naijon na tantyꞌiu Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ndoꞌ vi na jndë tua ndoꞌcüjioonꞌ, juu xuee na cotaꞌjndyee nnꞌan judíos, juu Maríaꞌñeen na jnan tsjoon Magadán yo Salomé, yo ninꞌMaría ndyee Jacobo, sananꞌjndahan nchenꞌ quichi na ntyeehinhanꞌ juu siꞌtsꞌo ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ndoꞌ ya tonco vitsjoon nuincoꞌ, tyꞌehan juu tsiꞌtsꞌuaꞌñeen, vi na jndë jnduiꞌ ndoꞌcüjioonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ndoꞌ nato na ñjonhan, jnanꞌnein nquehan ndëë ntyjehan, jnduehan: —¿Nin tsꞌan na ntejndei jaa na ngenaanꞌ juu tsjöꞌ na tëꞌ ꞌndyo tsiꞌtsꞌua? ");
INSERT INTO azgNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Majoꞌ xjen na squehan joꞌ, jntyꞌiahan juu tsjöꞌ tꞌmanꞌñeen na jndë tquenaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ndoꞌ vi na jndë tyequeꞌhan quityquiiꞌ juu tsiꞌtsꞌuaꞌñeen, jntyꞌiahan tontyja ya vaquityen cüii tsansꞌandyua. Cüe juu ncüii ndiaa quichiꞌ, ndiaa tco, ndoꞌ joꞌ tyue jndyihan na jntyꞌiahan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Majoꞌ itso tsanꞌñeen ndëëhan: —Tyiꞌndyuehoꞌ, nchji na cojntꞌuehoꞌ nquii Jesús na jnan Nazaret, nquii jon na tꞌion nnꞌanhin tsonjnꞌaan. Majoꞌ jndë vandoꞌ xco jon, mangꞌe joꞌ tacꞌoonhin ntjoo. Quijntyꞌiahoꞌ ndöꞌ naijon na tquen nnꞌan siꞌtsꞌo ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ndoꞌ naneinhin cꞌohoꞌ na mꞌaan juu Pedro yo nque nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, ndoꞌ quinduehoꞌ ndëëhan na vja jndyee jon Galilea, ndoꞌ joꞌ njntyꞌiahan jon chaꞌxjen juu jñꞌoon na jndë siquindyi jonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ndoꞌ nanꞌntcuꞌñeen, ninñoonꞌ jnduiꞌ ntcüeꞌhan, maninꞌ conanꞌnonhan, tyꞌe ntcüeꞌhan, ndoꞌ toviquijntyꞌehan na tyuehan. Min tana jnduehan ꞌnan na tenonhan tsojnaanꞌ na tyue jndyihan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ndoꞌ vi na jndë vandoꞌ xco Jesús na vitsjoon nuincoꞌ, tityincyooꞌ jndyeehin nnon juu Maríaꞌñeen, tsan tsjoon Magadán, tsan na tjiꞌ jon ntyqueꞌ jndyetyia quiiꞌ tsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ndë joꞌ tja Maríaꞌñeen, tatsiquindyi juu nque nanꞌñeen na tomꞌanhan yo Jesús. Juu xjenꞌñeen tꞌonhan na chjooꞌ jndyi nꞌonhan ndoꞌ totyuehan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Majoꞌ xjen na siquindyi juu joohan na jndë vandoꞌ xco jon, ndoꞌ jndë jndyiaaꞌ nnon juu jon, min tatëntyja nꞌonhan juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ndoꞌ vi jndëcya, tityincyooꞌ Jesús ndëë ve nnꞌan na conanꞌjonhan yohin, xjen na tyꞌehan jndëë. Chaꞌvijon mañoon tsꞌan na jnanꞌjoonꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ndoꞌ vi na jndë taaꞌ nꞌonhan na manquii jon na jntyꞌiahan, tyꞌe ntcüeꞌhan Jerusalén, tyenanꞌquindyiihan ntyjehan na jndë tityincyooꞌ jon ndëëhan. Majoꞌ nanꞌñeen, min taꞌnan tëntyja nꞌonhan jñꞌoon na jnduehan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Vi jndë joꞌ, nque nnꞌan na nqui nchoꞌncüii na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, tityincyooꞌ jon ndëëhan juu xjen na cocüaꞌhan. Ndoꞌ sityiaꞌ jonhan jnaanꞌ na tatëntyja nꞌonhan juu jñꞌoon na jndue nnꞌan na jndë jntyꞌiahan na vandoꞌ xco jon ndoꞌ mantyi ntyja na queꞌ nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ndoꞌ tso jon ndëëhan: —Cꞌohoꞌ ninvaa tsonnangue, ncyahoꞌ juu jñꞌoon naya ntyja njan ndëë tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Juu tsꞌan na vantyja tsꞌon juuhanꞌ ndoꞌ na ndëëꞌ juu, ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ tsanꞌñeen. Majoꞌ juu tsꞌan na tyiꞌcantyja tsꞌon juu jñꞌoonꞌñeen, juu xjen na ntcoꞌxen Tyoꞌtsꞌon jnan nnꞌan, mantjotyen jnaanꞌ tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ndoꞌ joo nnꞌan na covantyja nꞌonhan Tyoꞌtsꞌon, jndye nnon tsꞌian na ntꞌahin chaꞌ ntsiꞌmanhanꞌ na mayuuꞌ jñꞌoon na concyahan, ndoꞌ na ntjiꞌhan jndyetyia quiiꞌ nꞌon nnꞌan yo ntyja ꞌnaanꞌ juu najndei na tsixuan xuë, ndoꞌ nnanꞌneinhan jñꞌoon na chito mancüii xjen na conanꞌneinhan. ");
INSERT INTO azgNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Xe na aa ntꞌuehan quinduntja ndoꞌ xe na aa ncüehan ncüii nasi na ntscueeꞌhanꞌ tsꞌan, majoꞌ taꞌnan na ngenonhan ntsꞌaahanꞌ. Ndoꞌ na ndyiohan ndueehan nacjo nanvꞌi, nꞌman nanꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Vi na jndë ntycüii na sinin Jesús joo jñꞌoonminꞌ ndëë nnꞌan na totsayꞌonhan yo juu jñꞌoon na toninncyaa jon, tava ntcüeꞌ jon quiñoonꞌndue, tëcüetyen jon ngiaaꞌ Tyoꞌtsꞌon tontyjaya. ");
INSERT INTO azgNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ndoꞌ jnduiꞌ nanꞌñeen, ndoꞌvanjan toninncyahan juu jñꞌoon nayaꞌñeen. Ndoꞌ mantyi nquii ta Jesús totejndei jon joohan quiiꞌ tsꞌian ꞌnaanꞌ jon na tontꞌahan. Tyincyaa jon na nanꞌxuanhan juu najndei na condui nquii jon chaꞌ ndëë ntꞌahan tsꞌian tꞌman na tyiꞌjeꞌquinduihanꞌ yo najndei na tsixuan nquii tsꞌan, mangꞌe joꞌ jndyechen nnꞌan taaꞌ nꞌonhan na juu jñꞌoon na toninncya nanꞌñeen, mayuuꞌhanꞌ. Mantyjantyi ndöꞌ ro. ");
INSERT INTO azgNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ꞌUꞌ ta Teófilo na njon jndyi condui ꞌuꞌ, mancya tsꞌon njan nnonꞌ. Majndye nnꞌan jndë tjihan jñꞌoon ntyja ꞌnaanꞌ Jesús. Joo jñꞌoonꞌñeen chuhanꞌ ꞌnan na jndë tui quiiꞌ ntꞌán na majndaꞌ na mayuuꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Nque nnꞌan na tojntyꞌia ndëëhan tsoñꞌen ꞌnan na tui ntyja ꞌnaanꞌ Jesús na cotyeꞌntjon nanꞌñeen nnon Tyoꞌtsꞌon ntyja ꞌnaanꞌ jñꞌoon naya ꞌnaanꞌ jon, joohan jndë tjihan jñꞌoonꞌñeen na jndë tyꞌö́n cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ndoꞌ mantyi ncö, sꞌaahanꞌ tsꞌön na ntsinchꞌu ja jñꞌoonvahin na ntsijnanꞌhanꞌ, xengꞌe mantyi ja chen chen jndë jntꞌuë tsoñꞌen na jndë tui ntyja ꞌnaanꞌ Jesús xjen na tyeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Nndaꞌ matsꞌa chaꞌ ncüaaꞌ tsonꞌ na joo jñꞌoon na jndë tonanꞌman nnꞌan nnonꞌ, conduihanꞌ jñꞌoon na mayuuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Joo ndyu xjen na tomꞌaan Herodes tsanmꞌaantsꞌian tꞌman ndyuaa Judea, tomꞌaan ncüii tyee cüenta nnꞌan judíos na jndyu Zacarías. Totsixuan jon tsꞌian yo tmaanꞌ ntyee na jndyuhanꞌ Abías. Scuuꞌ jon jndyu Isabel. Juu juu tonduihin tsjan ꞌnaanꞌ Aarón na jndyocahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ndoꞌ nquii Zacarías yo scuuꞌ jon, nchaꞌ vehan tonduihan nnꞌan jndyoyuhan na tonnon Tyoꞌtsꞌon, totaꞌngueeꞌhan tsoñꞌen jñꞌoon na tquen Tyoꞌtsꞌon na icoꞌxenhanꞌ, tajnanꞌtjahan ndëëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Majoꞌ nanꞌñeen, tandahan ngꞌe Isabel tsꞌan ntueꞌhin, ndoꞌ nchaꞌ vehan jndë tquehan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ncüii jon, nque ntyee tmaanꞌ juu Abíasꞌñeen, tentyja xjen na ntyentjonhan nnon Tyoꞌtsꞌon quiiꞌ vatsꞌon tꞌman Jerusalén. Ndoꞌ juu Zacarías, majoꞌ ñꞌenhin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Chaꞌxjen na vaa jñꞌoon ndëë ntyee ntyja ꞌnaan nnꞌan judíos, toꞌohan xꞌiaaꞌ na njntyꞌiahan nin ncüii joohan ngacüjaꞌhanꞌ na ngaqueeꞌ quityquiiꞌ juu vatsꞌon tꞌman cüentaaꞌ Tyoꞌtsꞌon. Ndoꞌ juu Zacaríasꞌñeen, tijnoonꞌ jon na ngaqueeꞌ jon na ntsco jon su. Ndoꞌ taqueeꞌ jon vatsꞌonꞌñeen ndoꞌ taꞌ jon na itsco jon su. ");
INSERT INTO azgNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Majuu xjen na isco jon su, ndoꞌ nnꞌan na jndye jndyiꞌhin, tancüihan tochꞌeenꞌ juu vatsꞌon tꞌmanꞌñeen na conanꞌneinhan nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ndoꞌ juu xjenꞌñeen, ncüii ángel cüentaaꞌ Tyoꞌtsꞌon tityincyooꞌhin nnon tsanꞌñeen. Juu ángelꞌñeen, minntyjeeꞌ jon ngiaaꞌ nnontyiu na tontyjaya naijon na coco su. ");
INSERT INTO azgNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Ndoꞌ juu Zacaríasꞌñeen, xjen na jndyiaaꞌ jonhin, siquijñꞌeenhanꞌhin. Ndoꞌ mioon sityꞌuehanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ndoꞌ ángelꞌñeen itso juu nnon jon: —ꞌUꞌ Zacarías, tyiꞌntyꞌueꞌ. Majndë indyii Tyoꞌtsꞌon jñꞌoon na macanꞌ nnon jon. Ndoꞌ nquii scuꞌ Isabel, ntsingui jon ncüii yujntꞌa yusꞌa ndahoꞌ, ndoꞌ ꞌuꞌ ntsiquijndyuꞌhin Juan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Nninncyaahanꞌ na neiinꞌ tsonꞌ na nduihin, ndoꞌ tꞌman ngaveeꞌ nchjiꞌ ntyja ꞌnaanꞌ juu. Ndoꞌ majndye nnꞌan nninncyaahanꞌ na neinhan ntyja na nduihin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ee tꞌman nnduihin na tonnon Tyoꞌtsꞌon. Tyiꞌxeꞌcꞌu juu vinon min nta ya. Ndoꞌ vitjachen na ntsingui ndyee juuhin, quindëya ntsixuan juu Espíritu Santo. ");
INSERT INTO azgNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ntyja ꞌnaanꞌ juu, jndye jndyi nnꞌan Israel ntcüeꞌ nꞌonhan jnanhan tonnon nquii ta Tyoꞌtsꞌon cüentahan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Majuu juu ncja jndyee na tonnon nquii jon na taquintyja na tꞌman conduihin. Ntyeꞌntjon juu nnon jon yo maninjuu najndei na totyeꞌntjon nquii Elías. Ntyja ꞌnaanꞌ juu jndaꞌ, ntjo ya ngio nnꞌan yo ndahan. Ndoꞌ nnꞌan na conanꞌqueꞌ nꞌon, ntyja ꞌnaanꞌ nquii juu ngovaaꞌ nꞌon nanꞌñeen na quitaꞌngueeꞌhin chaꞌxjen na chuhanꞌ. Tsꞌianminꞌ ntsꞌaa juu chaꞌ quitsijndaꞌ yahanꞌ quiiꞌ nꞌon nnꞌan na ncꞌonhan cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ndoꞌ joꞌ taxeeꞌ Zacarías nnon juu ángelꞌñeen: —¿Nin ꞌnan nndui chaꞌ ncüaaꞌ tsꞌön na nguaa na nndaꞌ? Ngꞌe ja ndö, jndë tque ja ndoꞌ majoꞌntyi scu. ");
INSERT INTO azgNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ndoꞌ tꞌa ángelꞌñeen, itso jon nnon juu: —Ja jndyu Gabriel. Condui ja na matyeꞌntjön nnon nquii Tyoꞌtsꞌon. Nquii jon iꞌua jon tsꞌian nnön na jndyotsiquindyi ꞌuꞌ jñꞌoon nayamin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Majoꞌ nein, jnaanꞌ na tyiꞌcantyja tsonꞌ jñꞌoon na matsjö nnonꞌ, joꞌ ngitëꞌ na matsininꞌ ata juu xuee ya na jndë siquindëhanꞌ tsoñꞌen na jndë tsjö nnonꞌ. Juu xjenꞌñeen nnaan na ntsininꞌ nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndoꞌ viochen xjen na tui na nndaꞌ, joo nanꞌñeen na tonanꞌneinhan nnon Tyoꞌtsꞌon, tominndooꞌhan na nduiꞌ Zacarías quiiꞌ vatsꞌonꞌñeen. Vacue tomꞌaanꞌ nꞌonhan ndu na vio jndyi ndyiiꞌ jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ndoꞌ juu xjen na jnduiꞌ jon, tavijndëë sinin jon, joꞌ taaꞌ nꞌonhan na vaa ncüii nnon na tityincyooꞌ na jndyiaaꞌ jon quiiꞌ juu vatsꞌonꞌñeen. Veꞌ ntꞌö jon totsꞌaa jon na sinin jon ndëëhan ngꞌe jndë ntjotyen na tandiquitsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ndoꞌ vi na jndë siquindë jon xuee na tyeꞌntjon jon quiiꞌ vatsꞌon tꞌmanꞌñeen, tantcüeꞌ jon tsjoonꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ndoꞌ nquii scuuꞌ jon Isabel taquiñjon jnda juu, ndoꞌ chaꞌ vi ꞌon chiꞌ taꞌnan tonduiꞌ jon na ncja jon mañoon tsjoon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Ya joꞌ tso juu: —Ndö vaa naya na itsꞌaa ta Tyoꞌtsꞌon yo ja. Nndaꞌ itsꞌaa jon na icüjiꞌhanꞌ na totscüejnaanꞌhanꞌ ja tondëë nnꞌan na tajnda. ");
INSERT INTO azgNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nquii ángel Gabrielꞌñeen, jndë vja vi yon chiꞌ na tityincyooꞌhin nnon Zacarías, ndoꞌ tꞌua nndaꞌ Tyoꞌtsꞌon tsꞌian nnon ángelꞌñeen na cja jon tsjoon Nazaret ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Jñon jonhin na mꞌaan ncüii yuscundyua na jndyu María. Juu juu min jñꞌoon na ngoco juu yo ncüii tsansꞌa na jndyu José. Juu Joséꞌñeen conduihin tsjan David na jndyocahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ndoꞌ tueeꞌ ángelꞌñeen na mꞌaan María, itso jon nnon juu: —Mancya tsꞌon ꞌuꞌ, na vaa tꞌman jndyi naya na itsꞌaa Tyoꞌtsꞌon yo ꞌuꞌ. Nquii jon mꞌaan yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ndoꞌ juu María, xjen na jndyii jon jñꞌoonminꞌ, siquijñꞌeenhanꞌhin, ndoꞌ tomꞌaanꞌ jndyi tsꞌon juu nin ꞌnan ninꞌquitsiquindyi juu jñꞌoonꞌñeen na sinin ángelꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ndoꞌ tsontyichen ángel nnon juu: —María, tyiꞌntyꞌueꞌ, ngꞌe ꞌuꞌ tꞌman naya na jndë tijnonꞌ tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ndö vaa na nndui, ngaquiñjon jndaꞌ, ndoꞌ ntsinguiꞌ ncüii yujntꞌa yusꞌa na ntsiquijndyuꞌhin Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Juu jon tꞌman nndui. Ndoꞌ ntsiquijndyuhanꞌhin Jnda nquii Tyoꞌtsꞌon na mꞌaan nandyentyichen. Ndoꞌ juu silla na maninꞌ tsꞌiaanꞌ ꞌnaanꞌ tachiiꞌ juu David, nquii ta Tyoꞌtsꞌon nninncyaa jon na ncyꞌoon Jesús cüentahanꞌ na ntcoꞌxen jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Chaꞌ ntjotyen na ntcoꞌxen jon nnꞌan Israel, juu na conduihin na ntcoꞌxen jon, tyiꞌjeꞌquintycüiihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ndoꞌ juu xjen na jndyii María na nndaꞌ tso ángelꞌñeen, tso juu: —Mayuscundyua ja. ¿Nchu vaa nndui na ntsꞌaahanꞌ na nndaꞌ? Ja chito mꞌan yo tsansꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Joꞌ tꞌa ángelꞌñeen ꞌndyo jon: —Nquii Espíritu Santo ntsꞌaa jon ncüii tsꞌian tꞌman yo ꞌuꞌ. Ee juu najndei na condui nquii Tyoꞌtsꞌon na mꞌaan nandyentyichen, ndyoquioo ncüaanꞌhanꞌ nacjoꞌ. Mangꞌe na nndaꞌ, nndui yujntꞌa ndoꞌ ntsiquijndyuhanꞌhin ñuan nquiiꞌ ndoꞌ Jnda nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndoꞌ mantyi nquii xjoꞌ Isabel, ntsingui jon min na jndë tquehin. Ee naneinhin jndë yon chiꞌ na taquiñjon jnda jon. Ndoꞌ juu jon tsꞌan na condue nnꞌan tsꞌan ntueꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ee nquii Tyoꞌtsꞌon, tsoñꞌen condëë itsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Joꞌ tꞌa María ꞌndyo juu ángelꞌñeen: —Condui ja tsꞌan na matyeꞌntjöntyën nnon ta Tyoꞌtsꞌon. Quindui yo ja chaꞌxjen na jndë tsuꞌ. Ndoꞌ juu xjenꞌñeen jnduiꞌ ángelꞌñeen na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Tyiꞌcovijndye xuee na tui na nndaꞌ, sijndaꞌ María, sityuaaꞌ jon, tja jon ncüii tsjoon cüentaaꞌ ndyuaa Judá na juu tsjoonꞌñeen mꞌaanhanꞌ quiiꞌ ntꞌan ntyoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ndoꞌ tueeꞌ jon vaaꞌ Zacaríasꞌñeen. Taqueeꞌ jon ndoꞌ tyincyaa jon tsꞌon Isabel. ");
INSERT INTO azgNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ndoꞌ vi na jndë jndyii Isabel na tyincyaa María tsꞌonhin, ya joꞌ juu yujntꞌa na ñjon tsiaaꞌ jon, sijndei juu, ndoꞌ xjenꞌñeen taqueeꞌ Espíritu Santo ninvaa quityquiiꞌ ñuaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Joꞌ jndei sinin jon, tso jon: —Quiiꞌ ntꞌan ntyjë ntcuhu, ꞌuꞌ tꞌmanntyichen na ityio Tyoꞌtsꞌon jnꞌaan ꞌuꞌ. Ndoꞌ mantyi ityio jon jnꞌaan yujntꞌa na ñjon tsiaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Majoꞌ ja jeꞌ, ¿Nin condui ja na tijnön na jndyoquindyiaꞌ ja? Ee condui ꞌuꞌ ndyee nquii jon na taquintyja na tꞌman conduihin na ityeꞌntjon jon ja. ");
INSERT INTO azgNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ee xjen na tyincyaꞌ tsꞌon ja, juu yujntꞌa na ñjon tsia, ninñoonꞌ sijndei juu na neiinꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ityio Tyoꞌtsꞌon jnꞌaan ꞌuꞌ ngꞌe mavantyja tsonꞌ na mayuuꞌ ntsiquindëhanꞌ juu jñꞌoon na siquindyii jon ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ndoꞌ tꞌa María, tso jon: Matsitꞌmanꞌ ja ta Tyoꞌtsꞌon yo na manchaꞌchen ñuan njan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ndoꞌ yo ninvaa na ndyiiꞌ vantꞌö, mꞌan na neiinꞌ tsꞌön yo nquii jon. Ee conduihin na itsinꞌman jon ñuan njan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Iyꞌoon jon na veꞌnchjii jon ja, min tsꞌan na veꞌ cüantyi ro ja na matyeꞌntjön nnon jon. Ndoꞌ nanein, xee na tonnonchen, tsoñꞌen nnꞌan na vjaca tsjan ꞌnaanhan, nnanꞌneinhan ntyja na jndë tyio jon jnꞌaan ja. ");
INSERT INTO azgNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ngꞌe nquii jon na tsoñꞌen najndei na conduihin, tꞌman naya itsꞌaa jon yo ja. Ndoꞌ xueeꞌ jon jiꞌua conduihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nque nnꞌan na vacantyichen tsjan ꞌnaanhin na conanꞌtꞌmaanꞌhan nquii Tyoꞌtsꞌon, tsoñꞌenhan mꞌaan jon na ntyꞌia rohan nchjii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tsꞌian na totsꞌaa jon, totsiꞌman nquiiꞌhanꞌ naijndei na conduihin. Majoꞌ joo nnꞌan na conanꞌquinjon nquehin ntyja na conanꞌtiuhan, sꞌaa jon na mincya jndyiꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Totsue jon nnꞌan na ntyꞌiachen, majoꞌ nnꞌan na vaa najndë na chohan tsꞌian na cotoxenhan, tjiꞌ jon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ndoꞌ joo nnꞌan na ngiohan na itsitjahanꞌhin na tonnon jon, itsꞌaa jon yohan chaꞌvijon tsꞌan na jndë tacjooꞌ na tcüaꞌ. Majoꞌ nnꞌan na conanꞌtiu na minꞌchjo tyiꞌconanꞌtjahan na tonnon jon, tana tejndei jon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ndochiihi nnꞌan Israel na totyentjonhan nnon jon, totejndei jonhan. Tyiꞌcotsuuꞌ tsꞌon jon na cꞌoon jon na ntyꞌia rohan ntyjii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ee nndaꞌ vaa tcoꞌ jon ꞌndyo jon na tyiꞌjon ntycüii na viꞌnchjii jon ndochiihi, majuu Abraham yo ninꞌnnꞌan tsjan ꞌnaanꞌ jon na jndyocahanꞌ. Jñꞌoonminꞌ sinin María na sitꞌmaanꞌ jon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ndoꞌ ntjohin yo Isabel chaꞌna ndye chiꞌ. Jndë joꞌ tjantcüeꞌ jon tsjoonꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tentyja xjen na ntsingui Isabelꞌñeen, ndoꞌ singui jon ncüii yujntꞌa yusꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ndoꞌ nnꞌan ꞌnaanꞌ jon yo nnꞌan na mꞌan ndyo vꞌaahan, jndyehan na tyꞌoon Tyoꞌtsꞌon na ndyiaꞌ ro Isabel nchjii jon. Tsoñꞌenhan tꞌonhan na neinhan yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Jndë nen xuee na tui yujntꞌaꞌñeen, tancüihan na nnanꞌquindëhan costumbre na contꞌa nnꞌan Israel yo yoꞌndaa ndahan yonon. Nanꞌñeen jnduehan na ntsue juu xueeꞌ tye juu Zacarías. ");
INSERT INTO azgNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Majoꞌ tso ndyee juu: —Chito aa joꞌ. Juan ndiquijndyu juu. ");
INSERT INTO azgNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Majoꞌ tꞌa nanꞌñeen ꞌndyo Isabel, jnduehan: —¿Ndu na nndaꞌ matsaꞌ? Ndoꞌ taꞌnan nin juu nnꞌan chuuꞌhoꞌ na jndyu na nndaꞌ tsu. ");
INSERT INTO azgNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ngꞌe na nndaꞌ, joꞌ jntꞌahan ndueehan nnon tye yujntꞌaꞌñeen na cotaxeeꞌhan nchu vaa na ntꞌue tsꞌon nquii jon na nninjndaꞌ xueeꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ndoꞌ tcan jon tscaaꞌ na ncüji jon, ndoꞌ nacjooꞌhanꞌ tji jon na Juan xueeꞌ juu. Ndoꞌ tsoñꞌen nanꞌñeen sꞌaahanꞌ na vacue mꞌaanꞌ nꞌonhan ndoꞌ neinhan na nndaꞌ vaa na tui. ");
INSERT INTO azgNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ndoꞌ na sꞌaa jon na nndaꞌ, ninjonto jnaan ntcüeꞌ na itsinin jon, sitꞌmaanꞌ jon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ndoꞌ tsoñꞌen nnꞌan na ndyo ntꞌaahan yo Zacarías yo Isabel, sꞌaahanꞌ na vacue tomꞌaanꞌ nꞌonhan ndoꞌ mantyi neinhan. Ndoꞌ ninvaa xiꞌjndio quiiꞌ ntyoꞌ ndyuaa Judea, tycya jñꞌoon ntyja ꞌnaanꞌ na tui nanꞌminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndoꞌ tsoñꞌen nnꞌan na tondyehan ntyja ꞌnaanꞌ na tui na nndaꞌ, vacue tomꞌaanꞌ nꞌonhan, totaꞌxeeꞌhan: “¿Nin tsꞌan nchjiito nin ꞌnan na ngueꞌntyja ntyja ꞌnaanꞌ juu yujntꞌavaꞌ?” Ee tityincyooꞌ jndyoyu na nquii Tyoꞌtsꞌon mꞌaan jon yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ndoꞌ nquii Zacarías, tye juu yujntꞌaꞌñeen, quindë ya tsixuan jon Espíritu Santo. Sinin jon jñꞌoon nchu vaa ꞌnan na nnguaa. Tso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Cüitꞌmaanꞌ nquii ta Tyoꞌtsꞌon cüenta jaa nnꞌan Israel ee jaa nnꞌan na condui cüentaaꞌ jon, jndë jndyo jon na ntsinꞌman jon ñuan njanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Yo tsjan mosooꞌ jon David na jndyocahanꞌ, jndë tquen jon nquii na condui tꞌmanhin na itsinꞌman jon ñuan njanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ndyu na toxenꞌchen toninncyaa Tyoꞌtsꞌon jñꞌoon yo jndyue nnꞌan na nanꞌxuanhan ñuan nquiiꞌ. Joo nanꞌñeen toninncyahan jñꞌoonꞌ jon ntyja nchu vaa ꞌnan na nnguaa. ");
INSERT INTO azgNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Jñꞌoon na jndue nanꞌñeen na yo nquii jon na conduihin tsjan ꞌnaanꞌ David, ncüjiꞌ Tyoꞌtsꞌon jaa nduee nnꞌan na jndohan jaa, ndoꞌ mantyi yo nduee nnꞌan na tyiꞌcueeꞌ nꞌonhan jaa. ");
INSERT INTO azgNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ntyja ꞌnaanꞌ nquii jon na conduihin tsjan David na jndyocahanꞌ, sijndaꞌ Tyoꞌtsꞌon na joo ndochiihi na tomꞌan ndyu na toxenꞌchen na ncꞌoon jon na ntyꞌia rohan nchjii jon. Ndoꞌ na ngañjoonꞌ tsꞌon jon joo jñꞌoon na sijndaꞌ jon yohan na tyiꞌjeꞌquitscüejndyo jonhanꞌ na jiꞌua tsixuanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Majuu jñꞌoonꞌñeen na tquentyen jon nnon tsochiihi Abraham, tsan na tomꞌaan ndyu na toxenꞌchen. ");
INSERT INTO azgNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Majuu jñꞌoon na tso jon nnon juu na ntsiquindyaa jon jaa nduee nnꞌan na jndohan jaa chaꞌ nndëë ntyeꞌntjön nnon jon na minꞌncüii jñuaanꞌ tsꞌon tyiꞌncꞌön. ");
INSERT INTO azgNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ndoꞌ tsoñꞌen xuee na mꞌanntyëchën, ngomꞌan ntyja na tquen jon na ñuan nquiiꞌ jaa. Ndoꞌ na ntyeꞌntjön na tonnon jon chaꞌxjen na chuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndoꞌ ꞌuꞌ jnda, nndue nnꞌan na condui ꞌuꞌ tsꞌan na incyaa jñꞌoon ntyja ꞌnaanꞌ nchu vaa ꞌnan na nnguaa. ꞌUꞌ ntyeꞌntjonꞌ nnon nquii Tyoꞌtsꞌon na mꞌaan nandyentyichen. Ngꞌe ꞌuꞌ ncjaꞌ jndyeeꞌ tonnon nquii jon na conduihin na coꞌxen jon nnꞌan, ndoꞌ na ncüjiꞌ jndyoyuꞌ ntyja ꞌnaanꞌ jon chaꞌvijon tsꞌan na icoꞌya nato, chaꞌ cꞌon cje nnꞌan xjen na ncüjeeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Nque nnꞌan na conduihan cüentaaꞌ jon, ꞌuꞌ ntsaꞌ na cüaaꞌ nꞌonhan na itsitꞌman tsꞌon jonhan na conanꞌtjahan nnon jon, ndoꞌ na itsinꞌman jon ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ngꞌe nquii Tyoꞌtsꞌon na conanꞌtꞌmaanꞌ jaa, taquintyja na ntyꞌia rö nchjii jon, joꞌ na ncꞌua jon tsꞌian nnon nquii juu na nnaan juu nandyentyichen na ntsijonhanꞌhin chaꞌvijon ndoꞌcüjioonꞌ na ntsixuee juu tondëëhë. ");
INSERT INTO azgNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Juu jon ntsixuee jon ndëë nnꞌan na mꞌan nacje ꞌnaanꞌ najaan na vayꞌoonhanꞌhin na ngitsu ñuaanhan. Ndoꞌ ndëëhë nninncyaa jon na tajñuaanꞌ tsꞌon nanꞌxuan na tonnon jon. Jñꞌoonminꞌ sinin Zacarías xjen na tui jnda jon Juan. ");
INSERT INTO azgNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ndoꞌ juu yusꞌa chjo Juan, tëquehin. Mantyi tayꞌoon juu najndei juu ntyja ꞌnaanꞌ nquii Tyoꞌtsꞌon. Ndoꞌ ya na sꞌaahanꞌ tsansꞌandyuahin, tomꞌaan juu ndyuaa naijon na tyiꞌjndye nnꞌan mꞌan, ata xjen na tyeꞌ na toninncyaa jon jñꞌoon ndëë nnꞌan Israel. ");
INSERT INTO azgNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Juu xjenꞌñeen nquii tsanmꞌaantsꞌian tꞌman, Augusto César, tꞌua jon tsꞌian na quindui nguee tsoñꞌen nnꞌan na mꞌan ncüii cüii tyuaa naijon icoꞌxen jon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Juuhanꞌ na minjndyee na tyeꞌ na tji nanmꞌannꞌian nguee nnꞌan. Juu xjenꞌñeen tomꞌaan Cirenio gobernador ndyuaa Siria. ");
INSERT INTO azgNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Jndue nanmꞌannꞌianꞌñeen na ncüii cüii tsꞌan ngantcüeꞌ juu naijon vaa tsjoon nque nnꞌan tsjan na tuihin, na nndui xueeꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mangꞌe na nndaꞌ, jnan José tsjoon Nazaret, ndyuaa Galilea. Tja jon ndyuaa Judea, tsjoonꞌ tsoDavid na jndyu Belén ngꞌe condui José tsjan David na jndyocahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tja jon tsjoonꞌñeen yo María, tsan na ndiscuuꞌ jon, na ndui ngueehan. Ndoꞌ juu juu jndë mandyoviꞌ na ntsingui juu. ");
INSERT INTO azgNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ndö vaa ꞌnan tui: viochen xjen na mꞌanhan joꞌ, tueeꞌ xjen na ntsingui María. ");
INSERT INTO azgNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ndoꞌ singui jon jnda jon na vejndyee, yusꞌahin. Scüetyjo jon ndiaahin, ndë joꞌ tyio jonhin naijon na cocüaꞌ quiooꞌ ngꞌe ntꞌaa naijon na veꞌ cotsque ya nnꞌan, tooꞌchenhanꞌ na mꞌan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ndyo tsjoon Belén, tomꞌan nnꞌan tojndëë na totaꞌntyjeeꞌhan quinman njnuenꞌ natsjon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ndoꞌ ninjonto tityincyooꞌ ncüii ángel cüentaaꞌ ta Tyoꞌtsꞌon ndëëhan, ndoꞌ juu naquixuee na conduihin, sixueehanꞌ xiꞌjndio nanꞌñeen, ndoꞌ na tui na nndaꞌ, sꞌaahanꞌ na ncyaa jndyihan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Majoꞌ juu ángelꞌñeen tso jon ndëëhan: —Tyiꞌndyuehoꞌ, quitquenhoꞌ cüenta, ndyoyꞌön jñꞌoon na ya jndyihanꞌ ndëëhoꞌ na nninncyaahanꞌ na neiinꞌ jndyi nꞌon nnꞌan na ninvaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ee tsjonvahin quiiꞌ tsjoonꞌ tsoDavid jndë tui nquii jon na ntsinꞌman jon ñuan nnꞌan. Juu jon conduihin nquii Mesías. Ndoꞌ conduihin na coꞌxen jon ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ndoꞌ ndö vaa jnꞌaan na ntsiꞌmanhanꞌ ndëëhoꞌ na majuu jon. Juu yujntꞌaꞌñeen nndiohoꞌhin na vetyjo ndiaa na covetyjo yoꞌndaahin na ñjon juu naijon na cocüaꞌ quiooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ndoꞌ majuuto xjenꞌñeen tityincyooꞌ ángeles cüenta jndye yo juu ángelꞌñeen, tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. Jnduehan: ");
INSERT INTO azgNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Cüitꞌmaanꞌ nquii Tyoꞌtsꞌon na mꞌaan nandyentyichen. Ndoꞌ nnon tsonnangue, joo nnꞌan na covineiinꞌ nꞌonhan na contꞌahan ꞌnan caveeꞌ nchjii jon, quinanꞌxuanhan na tajñuaanꞌ tsꞌonhan na tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ndoꞌ joo ángeles, vi na jndë tyꞌe ntcüeꞌhan quiñoonꞌndue, ya joꞌ joo nanꞌñeen na totaꞌntyjeeꞌhan quinman njnuenꞌhan, jnduehan ndëë ntyjehan: —Cja Belén. Ntsaquijntyꞌia juu ꞌnan na jndë tui na itsiquindyi Tyoꞌtsꞌon jaa. ");
INSERT INTO azgNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndoꞌ joꞌ jnanꞌtyuaaꞌhan, tyꞌehan, ndoꞌ vi na jndë squehan joꞌ, jndiohan juu María yo José, yo yujntꞌa na ñjon juu naijon na cocüaꞌ quiooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Ndoꞌ vi na jndë jntyꞌiahan ꞌnan na tui, tonanꞌcyahan jñꞌoon nchu vaa ꞌnan na jndë siquindyi ángelꞌñeen joohan ntyja ꞌnaanꞌ juu yujntꞌaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ndoꞌ tsoñꞌen nnꞌan na jndyehan jñꞌoon na jndue nanꞌñeen, sꞌaahanꞌ na jndye tꞌoonꞌ nꞌonhan ndoꞌ tyincyaahanꞌ na taveeꞌ ngiohan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ndoꞌ nquii María, sꞌaahanꞌ na njon jndyi jñꞌoonminꞌ na ntyjii jon, vacue tomꞌaanꞌ tsꞌon jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ndoꞌ joo nanꞌñeen na cotaꞌntyjeeꞌhan quinman njnuenꞌhan, tyentcüeꞌhan, tonanꞌtꞌmaanꞌhan nquii Tyoꞌtsꞌon. Tontcüiiꞌhan jon ntyja ꞌnaan tsoñꞌen na jndë jndyehan ndoꞌ na jndë jntyꞌia ndëëhan, chaꞌxjen na tso juu ángelꞌñeen ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Vi jndë na nen xuee na tui yujntꞌaꞌñeen, ndoꞌ jntꞌahan yohin chaꞌxjen juu costumbre na contꞌa nnꞌan judíos yo yoꞌndaa yonon ndahin. Juu xjenꞌñeen jnanꞌquijndyuhanhin Jesús, ee nndaꞌ vaa xueeꞌ juu na tquen ángelꞌñeen vitjachen na ñjon juu tsiaaꞌ ndyee juu. ");
INSERT INTO azgNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jndë na tenon vennꞌan xuee na singui María, joꞌ tentyja xjen na juu José yo María ntquen ntjuꞌhan na tonnon Tyoꞌtsꞌon chaꞌxjen na icoꞌxen juu jñꞌoon na tquen Moisés. Joꞌ tyꞌehan Jerusalén, tyeyꞌonhan Jesús na tyincyahan cüentahin ntꞌö ta Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Jntꞌahan na nndaꞌ ngꞌe vaa jñꞌoon na icoꞌxenhanꞌ nacjooꞌ jñꞌoonꞌñeen na coꞌxenhanꞌ: “Ncüii cüii yujntꞌa na yusꞌa na nndui jndyee, nnꞌan na ndahin ncyahan cüentahin ntꞌö ta Tyoꞌtsꞌon.” ");
INSERT INTO azgNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ngꞌe na nndaꞌ, juu José yo María tyꞌehan vatsꞌon tꞌman na nninncyahan quiooꞌ cüentaaꞌ Tyoꞌtsꞌon na ngueꞌ oꞌ chaꞌxjen na icoꞌxen juu jñꞌoon na tquen Moisés na itsohanꞌ: Nninncyahan ncüii ntjo quinchco oo ve quituꞌ quijndë. ");
INSERT INTO azgNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ndoꞌ juu xjenꞌñeen, ncüii tsansꞌa na jndyu Simeón, tomꞌaan jon tsjoon Jerusalén. Tsanꞌñeen totsiquindë jon chaꞌxjen na chuhanꞌ na tonnon Tyoꞌtsꞌon, ndoꞌ mantyi xoncüeeꞌ tsꞌon jon na itsitꞌmaanꞌ jon Tyoꞌtsꞌon. Yo na ntyja jndyi tsꞌon jon, tominndooꞌ jon na ndyiaaꞌ nnon jon nquii jon na conduihin na ntsinꞌman ñuaan nnꞌan Israel. Ndoꞌ Simeón quindëya totsixuan jon Espíritu Santo. ");
INSERT INTO azgNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Ndoꞌ nquii Espíritu Santo, jndë siꞌman jon nnon tsanꞌñeen na ndyiaaꞌ jndyee juu nquii jon na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na ntsinꞌman jon ñuaan nnꞌan. Ndë joꞌ ngueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ndoꞌ juu xjenꞌñeen, nquii Espíritu siꞌman jon nnon tsaꞌñeen na cja jon vatsꞌon tꞌman. Ndoꞌ majuuto xjenꞌñeen José yo María tyeyꞌonhan yujntꞌa Jesús vatsꞌonꞌñeen. Jntꞌahan na nndaꞌ chaꞌ quindui ntyja ꞌnaanꞌ juu chaꞌxjen na tsiꞌman jñꞌoon na tquen Moisés na quintꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Vi jndë joꞌ, tyꞌoon Simeón juu yujntꞌa Jesús yo ntꞌö jon. Sitꞌmaanꞌ jon Tyoꞌtsꞌon. Tso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Jeꞌ yuuꞌ jeꞌ ta, ja na condui moso ꞌnanꞌ, jndë siquindëꞌ juu jñꞌoon na tcoꞌ ꞌndyoꞌ nnön. Nanein quitsiquindyaꞌ ja na ncüꞌiö min tajñuaanꞌ tsꞌon ja. ");
INSERT INTO azgNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ee na jndë mantyꞌia nnön nquii jon na ntsinꞌman jon ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Manquiintyi jon na tꞌuaꞌ tsꞌianꞌñeen nnon jon tondëë tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Conduihin naxuee na ntsiꞌman jon jñꞌoon na mayuuꞌ ꞌnanꞌ ndëë nnꞌan na mañoon tsjan conduihan. Ndoꞌ ntyja ꞌnaanꞌ jon ntsitꞌmaanꞌhanꞌ nque nnꞌan ꞌnanꞌ, nnꞌan Israel. Ndöꞌ jñꞌoon na sinin Simeónꞌ nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ndoꞌ juu José yo ndyee Jesús, tomꞌaanꞌ jndyi nꞌonhan tsoñꞌen jñꞌoon na sinin Simeón ntyja ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Jndë joꞌ tcan tsanꞌñeen na quityio Tyoꞌtsꞌon jnꞌaan nanꞌñeen, ndoꞌ nnon nquii María tso jon: —Quenꞌ cüenta, juu yujntꞌava, iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na ntyja ꞌnaanꞌ jon ñꞌen nnꞌan Israel ngitsu ñuaanhan ngꞌe tyiꞌcovantyja nꞌonhan jon. Ndoꞌ ñꞌenhan na ntsinꞌman Tyoꞌtsꞌon ñuaanhan ngꞌe na ngantyja nꞌonhanhin. Ntsixuan jon jnꞌaan na itscüenon Tyoꞌtsꞌon ndëë nnꞌan, majoꞌ jndye nnꞌan ncꞌohan nacjooꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ntyja ꞌnaanꞌ nquii jon nnintyincyooꞌ tsoñꞌen na ndyiiꞌ nꞌon nnꞌan. Ndoꞌ mantyi ꞌuꞌ María, vaa ncüii nnon na ngenoonꞌ ntyja ꞌnaanꞌ jon na ntsiꞌndaaꞌhanꞌ nchjiꞌ, chaꞌvijon na iquiihanꞌ ya na ngüequindyiꞌ xjotë. ");
INSERT INTO azgNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ndoꞌ mantyi joꞌ ijon tomꞌaan ncüii tsanscu na jndyu Ana na toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon. Tsanꞌñeen jnda Fanuel, juu Fanuelꞌñeen conduihin ntyja ꞌnaanꞌ tmaanꞌ tsjan Aser na jndyocahanꞌ. Xjen na toco Anaꞌñeen, tomꞌaan jon yo saaꞌ jon vi ntyqueꞌ chu. ");
INSERT INTO azgNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Jndë joꞌ ntjohin na tueꞌ saaꞌ jon. Nanein jndë tque jndyihin, jndë ninquennꞌan vantjoꞌ ninque chuuꞌ jon. Ndoꞌ min tyiꞌquinduiꞌ jon quiiꞌ vatsꞌon tꞌman. Joꞌ ijon totyentjon jon nnon Tyoꞌtsꞌon naxuee ndoꞌ natsjon. Totyjee jon ꞌnan ꞌndyo jon ndoꞌ totsinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Majuuto xjenꞌñeen na itsinin Simeón, ndoꞌ sindyooꞌ juu Anaꞌñeen na mꞌan joohan. Tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanꞌ juu yujntꞌa Jesús. Jndë joꞌ totsinin jon ntyja ꞌnaanꞌ yujntꞌaꞌñeen ndëë tsochen nnꞌan Jerusalén yo ndëë nnꞌan mañoon njoon na mantyi cominndooꞌhan na ntsinꞌman Tyoꞌtsꞌon ñuaanhan ntyja ꞌnaanꞌ jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ndoꞌ José yo María, vi na jndë jnanꞌquindëhan tsoñꞌen na tcanhanꞌ na quen jiꞌuahan chaꞌxjen na icoꞌxen jñꞌoonꞌ Tyoꞌtsꞌon, ndoꞌ tyentcüeꞌhan tsjoon Nazaret, ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tandimaya lu Jesús, taquehin, ndoꞌ mantyi tavijndaꞌ xquen juu. Ndoꞌ juu naya na itsixuan Tyoꞌtsꞌon, tꞌmanhanꞌ na totsixuan juu. ");
INSERT INTO azgNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Juu José yo María, chu ro chu ro toꞌohan Jerusalén xjen na coveeꞌ nguee pascua. ");
INSERT INTO azgNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ndoꞌ vi na jndë jndë nchoꞌve chuuꞌ Jesús, tja jon Jerusalén yohan chaꞌxjen na toꞌohan juu nguee pascuaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ndoꞌ vi jndë na tenon juu ngueeꞌñeen, jnanꞌjndaꞌhan na ncꞌontcüeꞌhan tsjoonhan, majoꞌ juu yusꞌa chjo Jesús ntjohin Jerusalén, min tyíꞌquindiohan na sꞌaa juu na nndaꞌ, ");
INSERT INTO azgNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ee jnanꞌtiuhan na ñꞌenhin quiiꞌ ntꞌan nnꞌan na coꞌo ntcüeꞌ na tyꞌe nguee. Cüaꞌxuee toquiñjonhan nato, majoꞌ tatityincyooꞌhin. Joꞌ taꞌhan, tojntꞌuehan jon quiiꞌ ntꞌan nnꞌan chuuꞌhan yo nnꞌan na tajnꞌaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Majoꞌ tajndiohanhin, mangꞌe joꞌ tyentcüeꞌhan Jerusalén na njntꞌuehan jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Juu xuee na jndë ndye, tyquiiꞌ vatsꞌon tꞌman, joꞌ jndiohan jon. Quiiꞌ ntꞌan nnꞌan na conanꞌman chu vaa itsiquindyi jñꞌoon na tquen Moisés, joꞌ vaquityen jon. Iquen jon cüenta jñꞌoon na jnanꞌnein nanꞌñeen ndoꞌ mantyi ivaxeeꞌ jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ndoꞌ tsoñꞌen nanꞌñeen na jndyehan jñꞌoon na sinin jon, tëveeꞌ jndyi nꞌonhan jñꞌoon na tovaaꞌ tsꞌon jon ndoꞌ yo jñꞌoon na totsintcüeꞌ jon ndëëhan na taxeeꞌhan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Majoꞌ José yo María, ya na jntyꞌiahan jon, siquijñꞌeenhanꞌhin. Tso ndyee jon nnon jon: —ꞌUꞌ jnda, ¿Ndu na nndaꞌ saꞌ já? ¿Aa tyiꞌquintjiꞌ juu tyeꞌ yo ja, itsiꞌndaaꞌhanꞌ ngiö́ na cojntꞌuë́ ꞌuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ndoꞌ sintcüeꞌ jon jñꞌoon ndëëhan, tso jon: —¿Ndu na cojntꞌuehoꞌ ja? ¿Aa tyiꞌcovaaꞌ nꞌonhoꞌ na chuhanꞌ na cꞌön vaaꞌ Tyëhöꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Majoꞌ tataaꞌ nꞌonhan juu jñꞌoonꞌñeen na tso jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Joꞌ tja ntcüeꞌ jon yohan Nazaret. Ndoꞌ tomꞌaan jon nacje ꞌnaanhan. Ndoꞌ juu ndyee jon, vacue tomꞌaanꞌ tsꞌon jon ntyja tsoñꞌen ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ndoꞌ nquii Jesús, tëvijndaꞌ xquen jon ndoꞌ taquehin. Tëveeꞌ tsꞌon Tyoꞌtsꞌon yohin ndoꞌ mantyi nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chu na jndë nginꞌon na mꞌaan Tiberio César tsanmꞌaantsꞌian tꞌman tsjoon Roma, majuu xjenꞌñeen juu Poncio Pilato tonduihin gobernador ndyuaa Judea. Ndoꞌ juu Herodes tocoꞌxen jon ndyuaa Galilea. Tyje jon Felipe, juu tsanꞌñeen tocoꞌxen jon ndyuaa Iturea yo Traconite. Ndoꞌ Lisanias, juu jon tocoꞌxen jon ndyuaa Abilinia. ");
INSERT INTO azgNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Juu xjenꞌñeen nquii Anás yo Caifás conduihan ntyee tque tondëë nnꞌan judíos. Majuu xjenꞌñeen juu Juan jnda Zacaríasꞌñeen, tomꞌaan jon ndyuaa naijon tyiꞌjndye nnꞌan mꞌan, ndoꞌ tꞌua Tyoꞌtsꞌon tsꞌian nnon juu na ncyaa juu jñꞌoonꞌ jon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Juu Juanꞌñeen ninvaa ndyuaa xiꞌjndio jndaa Jordán, joꞌ tomandyiꞌ jon. Toninncyaa jon jñꞌoon na quintcüeꞌ nꞌon nnꞌan jnanhan chaꞌ ntsitꞌman tsꞌon Tyoꞌtsꞌonhan, ndë joꞌ ntsiquindëëꞌ jon joohan. ");
INSERT INTO azgNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tui na nndaꞌ chaꞌxjen na tso jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. Ndö vaa na itso juu jñꞌoonꞌñeen: Mꞌaan tsꞌan na itsixuaa juu ndëë nnꞌan ndyuaa naijon na tyiꞌjndye nnꞌan mꞌan. Itso tsanꞌñeen: “Quinanꞌjndaꞌhoꞌ quiiꞌ nꞌonhoꞌ chaꞌvijon ncüii nato na nndyocüjeeꞌnon nquii jon na ntcoꞌxen jon ꞌoꞌ. Quitaꞌ xoncüehoꞌ ntyja na cotsamꞌanhoꞌ, chaꞌvijon na conanꞌyuhoꞌ nato na nndyo jon. ");
INSERT INTO azgNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ncüii ro cüii ro quindymaꞌ quinanꞌquitooꞌ nnꞌanhanꞌ. Ndoꞌ quinanꞌsuhan ncüii ro ncüii ro ntyoꞌ tꞌman yo ntyoꞌ quijndë. Tsoñꞌen nato ntyeeꞌ, quinanꞌyuhinhanꞌ. Ndoꞌ yuu na veꞌ congiooꞌ nato, quinanꞌsuhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ya joꞌ tsoñꞌen nnꞌan njntyꞌiahan nquii jon na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na ntsinꞌman jon ñuaan nnꞌan.” Nquii Isaías tji jon juu jñꞌoonvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jndye jndyi nnꞌan tentyjaaꞌhan na mꞌaan juu Juanꞌñeen na ntꞌue nꞌonhan na ntsiquindëëꞌ jonhan. Ndoꞌ tso jon ndëëhan: —¿Nin tsꞌan siꞌman ndëëhoꞌ na vaa na ndëë nꞌmanhoꞌ naviꞌ na ndyontyja? ꞌOꞌ contꞌahoꞌ chaꞌna contꞌa quindu na conanꞌnon oꞌ xjen na nndyo chon cjooꞌ tyueꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Quiꞌndyehoꞌ ꞌnan natyia na contꞌahoꞌ ndoꞌ quintꞌahoꞌ ncüii cüii nnon ꞌnan ya, ya joꞌ ntsiꞌman jndyoyuhanꞌ na mayuuꞌ na contcüeꞌ nꞌonhoꞌ. Min tyiꞌnanꞌsaaꞌ nquehoꞌ nꞌonhoꞌ na nnduehoꞌ: Aa jaa taconanꞌxuan nnꞌan na conanꞌtja ngꞌe nquii Abraham conduihin tsochiihi. Quindyehoꞌ na matsjö ndëëhoꞌ, min veꞌ ntjöꞌmin nndëë ntscüaquen Tyoꞌtsꞌonhanꞌ na nnduihanꞌ nnꞌan tsjan ꞌnaanꞌ Abraham na jndyocahanꞌ, ndoꞌ na nndaꞌ, nꞌndyiihanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ꞌOꞌ itsijonhanꞌ ꞌoꞌ chaꞌvijon nꞌoon na tyiꞌya të contꞌa. Ndoꞌ mangiohoꞌ joo nꞌoon na tyiꞌquintꞌahanꞌ të ya, ndijon xjen nchꞌiochenhanꞌ. Ndoꞌ vi na jndë tcan nꞌoonꞌñeen, ndyion nnꞌanhanꞌ quiiꞌ chon. Manndaꞌ ro itsijonhanꞌ na ntsꞌaa Tyoꞌtsꞌon ꞌoꞌ xe na aa tyiꞌntꞌahoꞌ chaꞌxjen na chuhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ndoꞌ nanꞌñeen jeꞌ, taꞌxeeꞌhan nnon Juan, jnduehan: —¿Nin ꞌnan icanhanꞌ na quintꞌá xe na aa yuꞌ nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tꞌa jon jndyuehan, tso jon: —Juu tsꞌan na nayꞌoon ve camisa, ncya juu ncüiihanꞌ nnon tsꞌan na tacyꞌoonhanꞌ. Ndoꞌ juu tsꞌan na yꞌoon ꞌnan na ntcüaꞌ, quitsꞌaa juu naya tsꞌan na tacyꞌoonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Nque nnꞌan na cotye sꞌon cüentaaꞌ gobiernon, mantyi squehan na mꞌaan Juan na quitsiquindëëꞌ jonhan. Jnduehan nnon jon: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, já jeꞌ, ¿Nin ꞌnan chuhanꞌ na quintꞌá? ");
INSERT INTO azgNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tꞌa jon jndyuehan, tso jon: —Xiaꞌntyi juu sꞌon na ican gobiernon na quityion nnꞌan, juu rohanꞌ quitanhoꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mantyi vendye sondaro taxeeꞌhan nnon jon: —Ndoꞌ já jeꞌ, ¿Nin ꞌnan chuhanꞌ na quintꞌá? Tꞌa jon jndyuehan: —Tantjiꞌhoꞌ xoquituꞌ nduee nnꞌan na veꞌ yo naijndeiꞌhanꞌ oo na veꞌ quintu na conduehoꞌ nacjohan. Ndoꞌ mantyi quintjo ya ngiohoꞌ nchuntyi xjen na cotantjonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Juu xjenꞌñeen tsoñꞌen nnꞌan tontyja jndyi nꞌonhan na ncüjeeꞌ nquii Mesías. Mangꞌe na nndaꞌ, tꞌman tomꞌaanꞌ jndyi nꞌonhan ntyja ꞌnaanꞌ juu Juan. Totaxeeꞌhan ndëë ntyjehan na aa ntsꞌaahanꞌ na juu jon conduihin Mesías. ");
INSERT INTO azgNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joꞌ tꞌa jon jndyue tsoñꞌen nanꞌñeen, tso jon: —Ja matsiquintꞌëhoꞌ yo ndaatioo, majoꞌ mandyontyja nquii jon na ntsiquindëëꞌ jon ꞌoꞌ yo juu Espíritu Santo quiiꞌ nꞌonhoꞌ. Majoꞌ ñꞌen vendyehoꞌ na ntꞌuiityenhanꞌ ꞌoꞌ ntyja ꞌnaanꞌ na conanꞌtjahoꞌ nnon Tyoꞌtsꞌon. Na ntsꞌaa jon na nndaꞌ, itsijonhanꞌ na ntsiquindëëꞌ jon ꞌoꞌ yo chon. Nquii jon tꞌmanntyichen conduihin, chichen ja. Ja yo ntyja ꞌnaanꞌ nquii jon, min veꞌ na ndiꞌntjön nnon jon na ntsiquinꞌan tjan na ntyjo tscoonꞌ jon, min joꞌ tyiꞌcüijntꞌue ja. ");
INSERT INTO azgNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jndë mavaaviꞌ xjen na ntcoꞌxenhanꞌhoꞌ ntyja ꞌnaanꞌ jnanhoꞌ. Ndoꞌ itsijonhanꞌhoꞌ chaꞌvijon ntquen na ninvaa ñꞌen toꞌhanꞌ yo nchuaaꞌhanꞌ. Icanhanꞌ na quitscüeꞌndyii tsꞌan ntquenꞌñeen, chaꞌ ntjuꞌhanꞌ. Ndoꞌ vi na jndë na ntjuꞌhanꞌ, ntsue tsꞌanhanꞌ quiiꞌ vꞌaa. Majoꞌ ntquen ndueꞌ yo toꞌ, njñoon tsꞌan chonhanꞌ. Manndaꞌ ro itsijonhanꞌ na itsꞌaa Tyoꞌtsꞌon. Nnꞌan na ya contꞌa, ncyꞌoon jon cüentahan, majoꞌ joo nnꞌan na contꞌa ꞌnan na tyiꞌquichuhanꞌ, ntsco jonhan yo chon na tyiꞌjon quinduuꞌ. Ndöꞌ vaa jñꞌoon na sintcüeꞌ Juan ndëë nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ndoꞌ juu Juan, jndye nnon jñꞌoon na sinin jon ndëë nnꞌan chaꞌna jñꞌoonminꞌ na totsiquindyi jonhan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Juu Herodes, tsan na tomꞌaan gobernado ndyuaa Galilea, veꞌ ndöꞌ ro mꞌaan jon yo Herodías, scuuꞌ tyje nquii jon Felipe. Joꞌ na siquiꞌmaanꞌ Juan Herodes na tyiꞌquichuhanꞌ na itsꞌaa jon na nndaꞌ. Ndoꞌ mantyi yo tsoñꞌen nnon natyia na jndë totsꞌaa tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Majoꞌ juu Herodes jeꞌ, ntyja ꞌnaanꞌ tsoñꞌen natyia na jndë totsꞌaa jon, ndö ꞌnan na vantyjoꞌchen na sꞌaa jon, tyiiꞌ jon juu Juanꞌñeen vancjo. ");
INSERT INTO azgNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ndoꞌ vi na jndë na siquindëëꞌ Juan jndye nnꞌan, mantyi jndëëꞌ Jesús sꞌaa jon, ndoꞌ juu xjen na itsinin Jesús nnon Tyoꞌtsꞌon, juu xjenꞌñeen jnaan quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Ndoꞌ jndyocue Espíritu Santo nacjooꞌ jon chaꞌvijon quituꞌ, jndyoquintyjo jon nacjooꞌ Jesús. Ndoꞌ ticꞌuaa na sinin nquii Tyoꞌtsꞌon quiñoonꞌndue, itso jon: —ꞌUꞌ condui tsansꞌa jnda na viꞌnchji jndyi ja ꞌuꞌ. Itsineiinꞌhanꞌ tsꞌön ntyja ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nquii Jesús jeꞌ, mꞌaan jon chaꞌna ntcyu nchoꞌnqui chuuꞌ jon xjen na taꞌ jon tsꞌian na tꞌua Tyoꞌtsꞌon nnon jon. Ntyja ꞌnaanꞌ na cotjiꞌ nnꞌan cüenta, jnda Joséhin. Ndoꞌ José jnda Elí juu. ");
INSERT INTO azgNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ndoꞌ Elí jnda Matat, ndoꞌ Matat jnda Leví, ndoꞌ Leví jnda Melqui, ndoꞌ Melqui jnda Jana, ndoꞌ Jana jnda José, ");
INSERT INTO azgNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Ndoꞌ José jnda Matatías, ndoꞌ Matatías jnda Amós, ndoꞌ Amós jnda Nahúm, ndoꞌ Nahúm jnda Esli, ndoꞌ Esli jnda Nagai, ");
INSERT INTO azgNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Ndoꞌ Nagai jnda Maat, ndoꞌ Maat jnda Matatías, ndoꞌ Matatías jnda Semi, ndoꞌ Semi jnda Josec, ndoꞌ Josec jnda Judá, ");
INSERT INTO azgNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Ndoꞌ Judá jnda Joanán, ndoꞌ Joanán jnda Resa, ndoꞌ Resa jnda Zorobabel, ndoꞌ Zorobabel jnda Salatiel, ndoꞌ Salatiel jnda Neri, ");
INSERT INTO azgNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Ndoꞌ Neri jnda Melqui, ndoꞌ Melqui jnda Adi, ndoꞌ Adi jnda Cosam, ndoꞌ Cosam jnda Elmadam, ndoꞌ Elmadam jnda Er, ");
INSERT INTO azgNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ndoꞌ Er jnda Jesús, ndoꞌ Jesús jnda Eliezer, ndoꞌ Eliezer jnda Jorim, ndoꞌ Jorim jnda Matat, ");
INSERT INTO azgNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Ndoꞌ Matat jnda Leví, ndoꞌ Leví jnda Simeón, ndoꞌ Simeón jnda Judá, ndoꞌ Judá jnda José, ndoꞌ José jnda Jonam, ndoꞌ Jonam jnda Eliaquim, ");
INSERT INTO azgNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Ndoꞌ Eliaquim jnda Melea, ndoꞌ Melea jnda Mena, ndoꞌ Mena jnda Matata, ndoꞌ Matata jnda Natán, ");
INSERT INTO azgNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Ndoꞌ Natán jnda David, ndoꞌ David jnda Isaí, ndoꞌ Isaí jnda Obed, ndoꞌ Obed jnda Booz, ndoꞌ Booz, jnda Sala, ndoꞌ Sala jnda Naasón, ");
INSERT INTO azgNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Ndoꞌ Naasón jnda Aminadab, ndoꞌ Aminadab jnda Admin, ndoꞌ Admin jnda Arni, ndoꞌ Arni jnda Esrom, ndoꞌ Esrom jnda Fares, ndoꞌ Fares jnda Judá, ");
INSERT INTO azgNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Ndoꞌ Judá jnda Jacob, ndoꞌ Jacob jnda Isaac, ndoꞌ Isaac jnda Abraham, ndoꞌ Abraham jnda Taré, ndoꞌ Taré jnda Nacor, ");
INSERT INTO azgNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Ndoꞌ Nacor jnda Serug, ndoꞌ Serug jnda Ragau, ndoꞌ Ragau jnda Peleg, ndoꞌ Peleg jnda Heber, ndoꞌ Heber jnda Sala, ");
INSERT INTO azgNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Ndoꞌ Sala jnda Cainán, ndoꞌ Cainán jnda Arfaxad, ndoꞌ Arfaxad jnda Sem, ndoꞌ Sem jnda Noé, ndoꞌ Noé jnda Lamec, ");
INSERT INTO azgNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Ndoꞌ Lamec jnda Matusalén, ndoꞌ Matusalén jnda Enoc, ndoꞌ Enoc jnda Jared, ndoꞌ Jared jnda Mahalaleel, ndoꞌ Mahalaleel jnda Cainán, ");
INSERT INTO azgNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Ndoꞌ Cainán jnda Enós, ndoꞌ Enós jnda Set, ndoꞌ Set jnda Adán, ndoꞌ Adán jnda Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Xjen na tantcüeꞌ Jesús na jnan jon jndaa Jordán, quindë ya tsixuan jon Espíritu Santo. Ndoꞌ nquii Espíritu Santo teyꞌoon jonhin ndyuaa naijon na tyiꞌjndye nnꞌan mꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Joꞌ joo vennꞌan xueeꞌñeen na tomꞌaan Jesús juu ndyuaaꞌñeen, tojooꞌ tsꞌon yutyia na quityiiꞌhanꞌ ngꞌeehanꞌhin. Ndoꞌ juu xjenꞌñeen min tatcüaꞌ jon. Jndë joꞌ tyjeeꞌ na ninꞌjndoꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Joꞌ tso yutyia nnon jon: —Xe na aa condui ꞌuꞌ jnda nquii Tyoꞌtsꞌon, cüa, quitsuꞌ nnon tsjöꞌvaꞌ na quitscüaquenhanꞌ ꞌnan na ntcüaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tꞌa Jesús, tso jon: —Tyiꞌjeꞌquitsꞌa na nndaꞌ ee mantyi vaa jñꞌoonꞌ Tyoꞌtsꞌon na jndui na itsiquindyihanꞌ: “Chito veꞌ xiaꞌntyi ntyja ꞌnaanꞌ ꞌnan na ntcüaꞌ tsꞌan, joꞌ na ivandoꞌ juu.” ");
INSERT INTO azgNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Vi jndë joꞌ tayꞌoon yutyia jon ncüii tyoꞌ ndye. Ndoꞌ maquintyjachen siꞌman juu nnon jon ncüii cüii ndyuaa na cotoxen nnꞌan na ninvaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ndoꞌ tso juu nnon jon: —Ntꞌöꞌ ꞌuꞌ nninncya cüenta tsoñꞌen najndë na conanꞌxuan nanmꞌannꞌian tꞌman yo tsoñꞌen na condui tꞌmanhan ndyuaamin. Ee ntꞌö jndë ntjohanꞌ ndoꞌ minꞌcya ro tsꞌan na ntꞌue tsꞌön, nninncya jahanꞌ nnon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Xe na aa ntcoꞌxtyeꞌ na ntsitꞌmanꞌ ja, ya joꞌ tsoñꞌenhanꞌ nnanꞌxuanhanꞌ na ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Majoꞌ tꞌa Jesús, tso jon nnon juu: —Jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsiquindyihanꞌ: “Quitsitꞌmanꞌ nquii ta Tyoꞌtsꞌon cüentaꞌ ndoꞌ xiaꞌntyi nnon nquii jon quityeꞌntjonꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jndëcya tayꞌoon yutyia Jesús tsjoon Jerusalén. Ndoꞌ xquenviꞌ vatsꞌon tꞌman naijon nandyentyichen, joꞌ tquen juuhin. Itso juu nnon jon: —Xe na aa mayuuꞌ condui ꞌuꞌ jnda Tyoꞌtsꞌon, cüa, cjuꞌ ꞌuꞌ tyuaa, ");
INSERT INTO azgNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ee mantyi vaa jñꞌoonꞌ jon na jndui na itsiquindyihanꞌ: Ncꞌua Tyoꞌtsꞌon tsꞌian ndëë ángeles cüentaaꞌ jon na ya ya quitantyjeeꞌhan ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ndoꞌ ntyiꞌhan ndueehan ꞌuꞌ chaꞌ tyiꞌngaquiñjon ntjöꞌ ngꞌeꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Majoꞌ tꞌa Jesús, tso jon nnon juu: —Mantyi juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsiquindyihanꞌ: “Min tyiꞌntquenꞌ xjen nquii ta Tyoꞌtsꞌon cüentaꞌ.” Manndaꞌ itsiquindyi jñꞌoonꞌñeen na sinin Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Vi na jndë jndë na totsichon yutyia ncüii cüii nnon na quityiiꞌhanꞌ ngꞌeehanꞌ Jesús, jntyꞌii juuhin ata ndëcya nndyiaaꞌ juu aa xeꞌquindëë ntsꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jndë joꞌ tantcüeꞌ Jesús ndyuaa Galilea. Ndoꞌ quindë ya tsixuan jon Espíritu Santo. Ndoꞌ jñꞌoon ntyja ꞌnaanꞌ jon, tycyahanꞌ ninvaa juu ndyuaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Totsiꞌman jon ndëë nnꞌan quiiꞌ ntꞌaanꞌon ꞌnaan nnꞌan judíos. Ndoꞌ ya jñꞌoon jndue nnꞌan ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ndoꞌ joꞌ tueeꞌ nndaꞌ Jesús Nazaret naijon na tëquehin. Juu xuee na cotajndyee nnꞌan judíos, tja jon vatsꞌon chaꞌxjen mancüiixjen totsꞌaa jon. Ndoꞌ tacüentyjeeꞌ jon na ntsijnaanꞌ jon jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ya joꞌ joo nnꞌan na mꞌanhan juu vatsꞌonꞌñeen, tyincyahan tson na tji Isaías ntꞌö jon. Juu Isaíasꞌñeen ndyu na toxenꞌchen toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ntyja ꞌnaanꞌ nchu vaa ꞌnan na nguaa. Siquinaan Jesús juu tsonꞌñeen ndoꞌ tueeꞌhanꞌ yuu jon na itsohanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nquii Espíritu na condui nquii ta Tyoꞌtsꞌon mꞌaan jon yo ja. Mangꞌe joꞌ jndë tꞌua jon tsꞌian nnön na nninncya jñꞌoon naya ndëë nanninñenꞌ. Ndoꞌ jndë tꞌua jon tsꞌian nnön na quitsiquindyi ja nnꞌan na matsiquindyahan ntyja ꞌnaanꞌ jnan na nanꞌxuanhan. Ndoꞌ joo nnꞌan nchjan, ntsꞌa na njntyꞌia nndaꞌhan. Ndoꞌ mantyi nque nnꞌan na contꞌa viꞌ nnꞌanhan, tꞌua jon tsꞌian nnön na quitsiquindyahan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ndoꞌ na quitsiquindyi jahan na ndyumin mꞌaan Tyoꞌtsꞌon na viꞌnchjii jon joohan. Ndöꞌ vaa jñꞌoon na tji Isaías. ");
INSERT INTO azgNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Vi na jndë sintcüi Jesús tsonꞌñeen na chuuꞌ ntji, sintcüeꞌ ntcüeꞌ jonhanꞌ nnon tsꞌan na itejndei quiiꞌ juu vatsꞌonꞌñeen. Ndë tacjo jon. Ndoꞌ tsoñꞌen nnꞌan na mꞌan joꞌ, tojntyꞌia jndyihan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ndoꞌ joꞌ taꞌ jon na ntsinin jon ndëëhan, tso jon: —Juu jñꞌoonvaꞌ na jndyehoꞌ na sijnꞌan, maxeevahin jndë itsiquindëhanꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ndoꞌ tsoñꞌen nanꞌñeen jnduehan na ya sinchuꞌ jon jñꞌoon. Ndoꞌ taveeꞌ ngiohan na taquinjonꞌ jñꞌoon na tyincyaa jon, majoꞌ tataaꞌ nꞌonhinhanꞌ, jnduehan: —¿Nchu vaa na nndaꞌ tsixuan juu, ndoꞌ veꞌ jnda Joséhin? ");
INSERT INTO azgNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Joꞌ tꞌa Jesús jndyuehan, tso jon: —Ntsꞌaahanꞌ na nnduehoꞌ nnön juu jñꞌoon na itsohanꞌ: “ꞌUꞌ tsꞌan na matsaꞌ nasi nnꞌan, quitsinꞌman nquii ꞌuꞌ. Quitsaꞌ tsꞌian ntjoohin tsjonꞌ chaꞌxjen juu ꞌnan na condyë́ na matsaꞌ tsjoon Capernaum.” ");
INSERT INTO azgNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ndoꞌ tsontyichen Jesús ndëëhan: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, nnꞌan na maninncüii tsjoon yo nquii tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon, tyiꞌcyꞌonhan cüenta juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Majoꞌ quindyehoꞌ na matsjö, xjen na tomꞌaan Elías, jndye nanntcu na jndë tjë non tomꞌanhan ndyuaa Israel. Juu xjenꞌñeen chaꞌ ncüii ndye chu xoncüe tatuaꞌ, joꞌ ninvaa ndyuaaꞌñeen jndyo ncüii jndoꞌ tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Majoꞌ min na nndaꞌ, minꞌncüii nanntcu ndyuaa Israel, tatꞌua Tyoꞌtsꞌon tsꞌian nnon juu Elíasꞌñeen na quitejndei jon nanꞌñeen. Majoꞌ tsjoon Sarepta, ndyuaa Sidón tomꞌaan ncüii tsanscu ninnquii, joꞌ juu tsjoonꞌñeen tꞌua Tyoꞌtsꞌon tsꞌian nnon Elías na cjaquitejndei jonhin ntyja ꞌnaanꞌ na tomꞌaan juu jndoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ndoꞌ mantyi juu xjen na tomꞌaan Eliseo, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa, jndye nnꞌan tomꞌan ndyuaa Israel na toquicho ntycu ndöꞌ cotöꞌ. Majoꞌ xiaꞌntyi tsꞌan ndyuaa Siria, tsꞌan na jndyu Naamán, sinꞌman Eliseo juu yo tycuꞌñeen. Ndöꞌ vaa jñꞌoon na sinin Jesús ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ndoꞌ tsoñꞌen nnꞌan na tooꞌhan juu vatsꞌon Nazaret, ya na jndyehan na nndaꞌ vaa tso Jesús, tyion jndyihanꞌ na quindyaꞌ ngiohan ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ngꞌe joꞌ jnanꞌquintyjahan, ndoꞌ yo naijndeiꞌhanꞌ tyeyꞌonhan jon ꞌndyo tsjoonhan na mꞌaanhanꞌ ꞌndyo ncüii tyoꞌtyꞌa chaꞌ ntjueꞌhan jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Majoꞌ jnduiꞌ jon xoncüe quiiꞌ ntꞌanhan, tja jon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jndë joꞌ tja Jesús tsjoon Capernaum ndyuaa Galilea. Ndoꞌ na tueeꞌ xuee na cotaꞌjndyee nnꞌan judíos, totsiꞌman jon ndëë nnꞌan tsjoonꞌñeen ntyja ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ndoꞌ taveeꞌ jndyi ngio nanꞌñeen jñꞌoon na toninncyaa jon, ee joo jñꞌoonꞌñeen totsiꞌmanhanꞌ na va najndei na condui jon. ");
INSERT INTO azgNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ndoꞌ tyquiiꞌ juu vatsꞌonꞌñeen mꞌaan ncüii tsansꞌa na jndë tua jndyetyia quiiꞌ tsꞌon juu. Juu jndyetyiaꞌñeen sꞌaahanꞌ na jndei sixuaa tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Itso juu: —ꞌUꞌ Jesús, tsꞌan Nazaret, quiꞌndyiꞌ já. ¿Nin ꞌnan ninꞌquitsaꞌ já? ¿Aa jndyoꞌ ntjoo na ntsiquitsuꞌ já quiiꞌ vꞌio? Mavajnꞌan nin condui ꞌuꞌ. ꞌUꞌ condui jnda nquii Tyoꞌtsꞌon na conduihin ñuan nquiiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Majoꞌ sityiaꞌ Jesús jndyetyiaꞌñeen, itso jon: —Machenꞌ ꞌndyoꞌ. Quinduiꞌ quiiꞌ tsꞌon tsanvahin. Ndoꞌ vi na jndë isquioo jndyetyiaꞌñeenhin quiiꞌ ntꞌan nnꞌan na mꞌan joꞌ, mana jnduiꞌ juu quiiꞌ tsꞌon tsanꞌñeen. Majoꞌ minꞌchjo natëꞌ tasꞌaa juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ndoꞌ na nndaꞌ sꞌaa Jesús, tsoñꞌen nnꞌan na mꞌan joꞌ, totsiquijñꞌeenhanꞌhin. Jnduehan ndëë ntyjehan: —Joo jñꞌoonminꞌ na sinin jon, ¿Nin nanꞌxuanhanꞌ? Itsijonhanꞌ jon chaꞌvijon tsꞌan na icoꞌxen nnꞌan. Ee vaa najndei na condui jon na icoꞌxen jon min jndyetyia, ndoꞌ conduiꞌhanꞌ quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ndoꞌ ninvaa xiꞌjndio ndyuaaꞌñeen, tycya jñꞌoon ntyja ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ya joꞌ jnduiꞌ Jesús juu vꞌaaꞌñeen, tueeꞌ jon vaaꞌ Simón, taqueeꞌ jon joꞌ. Ndoꞌ juu tsanscu xeenꞌ Simón, viiꞌ jon, mioon jndyi iyꞌoon tjuenꞌhin. Ndoꞌ nnꞌan vꞌaaꞌñeen tanhan nnon Jesús na quitsinꞌman jon juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Joꞌ sindyooꞌcya jon nnon juu tsanviꞌñeen, sityiaꞌ jon tycuꞌñeen na quinduiꞌhanꞌ. Ndoꞌ ninñoonꞌ ntjo ya ntcüeꞌhin. Jnanquintyja juu, sijñꞌoonꞌ juu na tcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Juu xjen na mandyo na ngua ndoꞌcüjioonꞌ, tsoñꞌen nnꞌan jndyochohan ntyjehan na mꞌaan Jesús, na jndye nnon ntycu na coquenon nanꞌñeen. Ndoꞌ tyio jon ntꞌö jon cjo ncüii cüiihan, jnꞌmanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ndoꞌ mantyi quiiꞌ ntꞌan nanꞌñeen, jndye nnꞌan ñꞌenhan na tcoꞌxen jon na quinduiꞌ jndyetyia quiiꞌ nꞌonhan. Ndoꞌ jndyetyiaꞌñeen jnanꞌxuaahan, jnduehan: —ꞌUꞌ condui ꞌuꞌ jnda nquii Tyoꞌtsꞌon. Majoꞌ sityiaꞌ jonhan min tyíꞌncyaa jon na nnanꞌneinhan. Ee mangio yahan na nquii jon conduihin Mesías. ");
INSERT INTO azgNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Vi na jndë vandixuee, jnduiꞌ jon quiiꞌ tsjoon. Tja jon na ninnquii tsꞌon xquen jon ncüii joo quiiꞌ jndëë. Majoꞌ tentyja nnꞌan toxenꞌ jon, tyequijntꞌuehanhin, ndoꞌ jndiohan jon. Ee ninꞌquintꞌahan na ntscuꞌhanꞌ na vja jon na tonnonchen, chaꞌ tyiꞌndyii jonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Majoꞌ itso jon ndëëhan: —Mantyi ijndeiꞌhanꞌ na cjö njoon xiꞌjndio na nninncya jñꞌoon naya ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan. Ee ngꞌe majuu tsꞌianꞌñeen na iꞌua jon nnön. ");
INSERT INTO azgNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ndoꞌ tovancyaa jon jñꞌoon quiiꞌ ntꞌaanꞌon ꞌnaan nnꞌan ndyuaa Judea. ");
INSERT INTO azgNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ncüii jon tomꞌaan Jesús ꞌndyo ndaandue na jndyu Genesaret. Joꞌ jndye jndyi nnꞌan tëncüihan. Tyen ñjonhan ndyo na mꞌaan jon, ata tonchjehan jon na ninꞌquindyehan jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ndoꞌ jndyiaaꞌ jon ve vꞌaandaa ꞌndyo ndaandueꞌñeen, majoꞌ nnꞌan na contꞌa tsꞌian na cotjiꞌhan quintcaa yohanꞌ, jndë jnduiꞌhinhanꞌ. Cotmanhan ntquiꞌ ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ndoꞌ tua jon tyquiiꞌ ncüii vꞌaandaaꞌñeen. Maꞌnaanꞌ Simónhanꞌ. Ndoꞌ tcan Jesús nnon tsanꞌñeen na canon chjochenhanꞌ toquityquiiꞌ ndaa. Jndë joꞌ tacjo jon quiiꞌhanꞌ. Joꞌ tyincyaa jon jñꞌoon ndëë nanꞌñeen xjen na vaquityen jon quiiꞌ juu vꞌaandaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ndoꞌ vi jndë tyincyaa jon jñꞌoon ndëë nanꞌñeen, ya joꞌ tso jon nnon Simónꞌñeen: —Quitsayꞌonhoꞌ vꞌaandaava, ncꞌöntyë naijon na njoonchen. Joꞌ quitjueꞌhoꞌ ntquiꞌ ꞌnaanhoꞌ na ntjiꞌhoꞌ quintcaa. ");
INSERT INTO azgNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Majoꞌ tꞌa Simón ꞌndyo jon: —Ta, cüaꞌtsjon jntꞌá tsꞌian, ndoꞌ minꞌncüii quitscaa tatjíꞌ. Majoꞌ tanin, ngꞌe jñꞌoon ꞌndyoꞌ, joꞌ ntjuë́ꞌ nntꞌáhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ndoꞌ vi na jndë jntꞌahan na nndaꞌ, vaa jndye jndyi quintcaa tua quityquiiꞌ ntquiꞌ ꞌnaanhan ata vatꞌiooꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ndoꞌ na nndaꞌ, jntꞌahan ndueehan ndëë ntyjehan na mꞌan nanꞌñeen ncüiichen vꞌaandaa na quindyotejndei nanꞌñeenhan. Squenon nanꞌñeen ndoꞌ jnanꞌquitooꞌhan ve joo vꞌaandaaꞌñeen yo quintca, ata mavaa xjen na nchjehanꞌ ntꞌaandaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ndoꞌ juu Simón Pedro, vi na jndë tquen jon cüenta na nndaꞌ, tcoꞌxtye jon tonnon Jesús, tso jon: —Nndaꞌ ta, quiꞌndyiꞌ ja ee condui ja tsꞌan jnan tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nndaꞌ vaa tso jon ngꞌe mioon sityꞌuehanꞌhin yo ntyjehin ntyja ꞌnaan joo quintcaaꞌñeen na tjiꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ndoꞌ mantyi ntsinda Zebedeo, juu Santiago yo ninꞌJuan, mantyi tyue jndyihin. Ee nanꞌñeen ninncüii tꞌman contꞌahan tsꞌian yo juu Simón. Ya joꞌ tsochen Jesús nnon Simón: —Tyiꞌntyꞌueꞌ, nanein na tonnonchen, nnꞌan ntsitjonꞌ cüentaaꞌ Tyoꞌtsꞌon, chito veꞌ quintca. ");
INSERT INTO azgNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ndoꞌ vi na jndë sque ntcüeꞌhan tyuaatcüii yo ntꞌaandaaꞌñeen, jntyꞌehan tsꞌianꞌñeen, tyenanꞌjonhan yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ncüii jon tomꞌaan Jesús ncüii tsjoon. Xjenꞌñeen tyjeeꞌ ncüii tsansꞌa na mꞌaan jon na ninvaañꞌenhin chu juu ndöꞌ cotöꞌ. Ya na jndyiaaꞌ juu Jesús, tcoꞌxtye juu na tonnon jon. Tcan juu na quitejndei jonhin. Tso juu: —Ta, xe na aa ntꞌue tsonꞌ, ntyji na vaa najndei na condui ꞌuꞌ na ndëë ntsinꞌmanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Joꞌ tyio Jesús ntꞌö jon cjooꞌ tsanꞌñeen, itso jon: —Chuhanꞌ na quitsꞌa chaꞌxjen na matsuꞌ. Cꞌonꞌ na jndë jnꞌmanꞌ. Ndoꞌ ninñoonꞌ ntjo ya ntcüeꞌ tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ndoꞌ jaaꞌ jñꞌoon na tso Jesús nnon juu, tso jon: —Minꞌncüii nnon tsꞌan tyiꞌntsininꞌ nchu vaa ꞌnan sꞌa. Majoꞌ cjaꞌ na mꞌaan tyee, quitsiꞌmanꞌ nnon jon na jndë tcoꞌyahanꞌ ꞌuꞌ, ndoꞌ juu quiooꞌ na icanhanꞌ na ninncyaꞌ, ncyaꞌ oꞌ nnon jon chaꞌ ntsiꞌmanhanꞌ na jndë jnꞌmanꞌ, chaꞌxjen icoꞌxen juu jñꞌoon na tquen Moisés. Ee na ntsaꞌ na nndaꞌ, ntsiꞌman jndyoyuhanꞌ na jndë jnꞌmanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Majoꞌ tocya tocya jñꞌoon ntyja ꞌnaanꞌ Jesús. Ndoꞌ jndye jndyi nnꞌan totsantyjaaꞌhan na mꞌaan jon na ninꞌquindyehan jñꞌoon na toninncyaa jon yo na ninꞌquinꞌmanhan ntycu na coquenonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Majoꞌ vaa xjen na toꞌndyii jon nnꞌan, na ica jon naijon na ninnquii tsꞌon xquen jon chaꞌ ya ntsinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ncüii xueeꞌñeen itsiꞌman Jesús jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan. Ndoꞌ ñꞌen vendye nnꞌan tmaanꞌ fariseos na minndyuaahan joꞌ, mantyi yo nnꞌan na conanꞌman ndëë nnꞌan nchu vaa itsiquindyi jñꞌoon na tquen Moisés. Jnan nanꞌñeen tsochen njoon quijndë ndyuaa Galilea ndoꞌ Judea yo mantyi juu tsjoon Jerusalén. Ndoꞌ tyincyaa Tyoꞌtsꞌon na tsixuan Jesús najndei na condui nquii jon chaꞌ ntsinꞌman jon nnꞌan yo ntycu na coquenonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Juu xjenꞌñeen sque vendye nannon na chohan tsanviiꞌ na ntyjo juu cjooꞌ tsue. Juu tsanꞌñeen na jndë tintjein ngꞌee na tyꞌoon tycutquenhin. Tojntꞌuehan nchu ya ntꞌahan na ngoyꞌonhan tsanꞌñeen quiiꞌ vꞌaa na ntquenhan juu na tonnon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Majoꞌ tajndiohan nchu vaa na ntꞌahan ee jndye jndyi nnꞌan mꞌan. Mangꞌe joꞌ tyevahan nacjooꞌ juu vꞌaaꞌñeen, jnanꞌcjohan xquenhanꞌ, ndoꞌ jnanꞌcüenonhanhin na ninvaa ñjon juu tsue. Tquenhanhin quiiꞌ ntꞌan nnꞌan na tonnon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Ndoꞌ xjen na jndyiaaꞌ Jesús na nndaꞌ vaa na jntꞌa nanꞌñeen na tsiꞌmanhanꞌ na vantyja nꞌonhan jon, tso jon nnon juu tsanviiꞌhinꞌ: —ꞌUꞌ ntyjë, matsitꞌman tsꞌön ꞌuꞌ jnan na tsixuanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Majoꞌ nque nnꞌan na conanꞌman jñꞌoon na tquen Moisés ndoꞌ yo nnꞌan fariseosꞌñeen, taꞌhan na tyiꞌya ngiohan yo Jesús. Ee toquindyiiꞌ nꞌonhan: —¿Nin condui tsanvaꞌ na itsinin juu jñꞌoon tsanꞌ? Ee xiaꞌntyi nquii Tyoꞌtsꞌon nndëë ntsitꞌman tsꞌon jon jnaanꞌ tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Majoꞌ taaꞌ tsꞌon Jesús na nndaꞌ vaa jñꞌoontiu ꞌnaan nanꞌñeen. Joꞌ taxeeꞌ jon ndëëhan: —¿Ndu na tyiꞌcaveeꞌ ngiohoꞌ jñꞌoon na tsjö? ");
INSERT INTO azgNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Nin jñꞌoon na ntsinën ngiohoꞌ na tyiꞌjndyaaꞌchenhanꞌ? ¿Aa na ntsjö: “Matsitꞌman tsꞌön ꞌuꞌ jnan na tsixuanꞌ,” Oo aa na ntsjö: “Quinanquintyjaꞌ, cjaꞌcaꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Majoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, mantsiꞌman ndëëhoꞌ na vaa najndei na condui ja nnon tsonnanguevahin na ntsitꞌman tsꞌön nnꞌan jnan na nanꞌxuanhan. Ya joꞌ tso jon nnon juu tsanviiꞌñeen: —ꞌUꞌ ntyjë, matsjö nnonꞌ, quinanquintyjaꞌ. Quitsintcüiꞌ tsueꞌ ndoꞌ cjaꞌ vaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ndoꞌ ninñoonꞌ jnanquintyja tsanꞌñeen tondëë tsoñꞌen nanꞌñeen. Sintcüii juu tsue na tovaa juu. Tja juu vꞌaa, ninvito totsitꞌmaanꞌ juu Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndoꞌ tsoñꞌen nnꞌan na mꞌan joꞌ, tiꞌndaaꞌ tycya ngiohan. Tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. Ndoꞌ ntyja na tyuehan ndoꞌ na neinhan, jnduehan: —Minꞌjon tacojntyꞌia ncüii nnon na tꞌman conduihanꞌ chaꞌxjen juu ꞌnan na jndë jntyꞌia ndëë xeevahin. ");
INSERT INTO azgNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jndë na tui na nndaꞌ, jnduiꞌ Jesús joꞌ. Ndoꞌ jndyiaaꞌ jon ncüii tsꞌan na ique sꞌon cüentaaꞌ gobiernon tsjoon Roma, Leví jndyu tsanꞌñeen. Vaquityen juu vꞌaa naijon na coꞌtsaquityion nnꞌan sꞌonꞌñeen. Tso Jesús nnon juu: —Quindyotsijon ꞌuꞌ yo jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ndoꞌ juu Levíꞌñeen, maquintyjachen jnanꞌquintyja jon, tji ntcüeꞌhin ntyja ꞌnaanꞌ tsꞌianꞌñeen, taꞌ jon na totsijonhin yo jñꞌoon na toninncya Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ndoꞌ vaaꞌ tsanꞌñeen, sijñꞌoonꞌ jon na tꞌoon vi nguee na tcüaꞌ Jesús. Mantyi jndye ntyje Levíꞌñeen na tetjonhan na mantyi cotyehan sꞌon cüentaaꞌ gobiernon. Tecüendyuaahan mesa yohin yo Jesús yo minndyechen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Majoꞌ nnꞌan fariseos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, tatëveeꞌ ngiohan yo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús. Jnduehan ndëë nanꞌñeen: —Tyiꞌquichuhanꞌ na cocüaꞌhoꞌ ndoꞌ na covehoꞌ yo nnꞌan na cotye sꞌon ꞌnaanꞌ gobiernon Roma, ndoꞌ yo mañoon nnꞌan, ndoꞌ condui nanminꞌ nnꞌan na conanꞌtjahan nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tꞌa Jesús jndyuehan, tso jon: —Nnꞌan na tyiꞌvꞌi, tyiꞌicanhanꞌ tsꞌan na ntsꞌaa nasihan, majoꞌ nnꞌan vꞌi, joohin icanhanꞌ na ntsꞌaa tsanꞌñeen nasihan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ja chito jndyö na ncüan nnꞌan na jndyoyu conduihan na tonnon Tyoꞌtsꞌon. Nque nnꞌan na conanꞌtjahan nnon jon, jndë jndyö na ncüanhan na quintcüeꞌ nꞌonhan yo jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ndoꞌ jndue nanꞌñeen nnon Jesús: —Nnꞌan na cotsayꞌon jñꞌoon ntyja ꞌnaanꞌ Juan, jndye jnda cotyjehan ꞌnan jndyuehan ndoꞌ na conanꞌneinhan nnon Tyoꞌtsꞌon. Ndoꞌ majoꞌntyi contꞌa nnꞌan tmaanꞌ fariseos. Majoꞌ joo nnꞌan na cotsayꞌonhan yo jñꞌoon na mancyaꞌ, ꞌio ꞌio cocüaꞌhan ndoꞌ covehan min tyiꞌcotyjehan ꞌnan jndyuehan. Tyiꞌya na contꞌahan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Joꞌ tꞌa Jesús, sinin jon ncüii jñꞌoon na tyiꞌquitso nquiiꞌ jonhanꞌ ndëëhan. Itso jon: —Nquii tsansꞌa na icoco, viochen xjen na ninvaa mꞌaan jon quiiꞌ ntꞌan nnꞌan na ya jñꞌoon yohin, joo ntyje jon, nnꞌan na jndyonanꞌjon na icoco jon, ¿Aa chuhan na nnanꞌcüejndoꞌhan? ");
INSERT INTO azgNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Majoꞌ ngüentyja xjen na ntjiꞌ nnꞌan nquii tsansꞌaꞌñeen quiiꞌ ntꞌan nanꞌñeen. Juu xjenꞌñeen nnanꞌcüejndoꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mantyi sinin jon ndëëhan ncüii jñꞌoon na tyiꞌquitsinin nquiiꞌ jonhanꞌ ntyja ꞌnaanꞌ juu jñꞌoon xco na itsiꞌman jon ndëëhan. Tso jon: —Tanin tsꞌan na ntyjee juu ncüii tanꞌ ndiaa, ndiaa xco na quindëhanꞌ, na ncüjaaꞌ juuhanꞌ ncüii ndiaa ntsa. Ee xe na aa ntsꞌaa tsꞌan na nndaꞌ, ntsiꞌndaaꞌhanꞌ juu ndiaa xcoꞌñeen, ndoꞌ chito xiaꞌntyi joꞌ, mantyi tyiꞌxeꞌquitsijonhanꞌ juuhanꞌ yo ndiaa na jndë tijndyo. ");
INSERT INTO azgNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ndoꞌ tjaanꞌ quiooꞌ na conninjntꞌue nnꞌan na ndyionhan ndaa vinon, min jeꞌcüijntꞌuehinhanꞌ xe aa jndë tijndyohanꞌ. Ee xe na aa ntsꞌaa juu na nndaꞌ, ntꞌiooꞌhanꞌ juu tjanꞌñeen. Mana nninꞌndaaꞌñꞌenhanꞌ, ndoꞌ mantyi juu vinonꞌñeen ntcüeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mangꞌe na nndaꞌ, chuhanꞌ na tjan xco na ncꞌocue vinon xco, chaꞌ min juu tjan min juu vinonꞌñeen tyiꞌjeꞌquitsuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ee tsꞌan na jndë tuiiꞌ na iꞌu vinon tque, minꞌchjo tyiꞌquiꞌnan vinon xco nchjii juu, ngꞌe itso juu na juu vinon tque quiꞌnanchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ncüii xuee na cotaꞌjndyee nnꞌan judíos, ndö vaa ꞌnan tui. Venon Jesús naijon min ntjon ntquen trigo. Ndoꞌ nnꞌan na totsayꞌonhan jñꞌoon yohin, taꞌhan totꞌiooꞌhan xuꞌ ntquen trigo. Totyꞌuehinhanꞌ nchcyaaꞌ ndueehan, jndë joꞌ totquiihinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ndoꞌ na nndaꞌ, vendye nnꞌan na conduihan tmaanꞌ fariseos jnduehan: —Juu xuee na cotaꞌjndyëëhë, tyiꞌquichuhanꞌ na contꞌahoꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ndoꞌ joꞌ tꞌa Jesús, tso jon: —ꞌOꞌ jndë jnanꞌjnꞌaanhoꞌ jñꞌoon nchu vaa na sꞌaa David xjen na tomꞌaan jon na ninjndoꞌ jon, juu jon ndoꞌ mantyi joo nnꞌan na tentyja xenꞌ jon. Majoꞌ tyiꞌquinanꞌngꞌehoꞌ ntyja na nndaꞌ vaa na sꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Taqueeꞌ jon vatsꞌon cüentaaꞌ Tyoꞌtsꞌon, tcan jon tyooꞌ nnon nquii tyee tque na tomꞌaan joꞌ, ndoꞌ juu Davidꞌñeen jndaaꞌ jonhanꞌ. Tcüaꞌ jonhanꞌ, ndoꞌ mantyi tyincyaa jonhanꞌ ndëë nanꞌñeen na mꞌan yohin. Ndoꞌ juu tyooꞌñeen, tyooꞌ na jndë tquen nnꞌanhanꞌ tonnon Tyoꞌtsꞌon, tyiꞌcüanaan na veꞌ minꞌcya ro tsꞌan ntcüaꞌhanꞌ, xiaꞌntyi nque ntyee. ");
INSERT INTO azgNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Tsontyichen Jesús ndëëhan: —Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, vaa najndei na tsixuan na ntsjö nin ꞌnan quintꞌa nnꞌan juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Ncüiichen xuee, xuee na cotaꞌjndyee nnꞌan judíos, taqueeꞌ Jesús quiiꞌ vatsꞌon. Totsiꞌman jon jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan. Ndoꞌ joꞌ mꞌaan ncüii tsansꞌa na jndë tatei ntꞌö juu ntyjaya. ");
INSERT INTO azgNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ndoꞌ nque nnꞌan na conanꞌman chu vaa itsiquindyi jñꞌoon na tquen Moisés, ndoꞌ mantyi yo ninꞌnnꞌan na conduihan tmaanꞌ fariseos, totquenchenhan cüenta Jesús xe na aa ntsinꞌman jon tsanviiꞌñeen juu xuee na cotaꞌjndyeehan. Ee xe na aa ntsꞌaa jon na nndaꞌ, nninncyahan jnaanꞌ jon na quitꞌuiiviꞌhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Majoꞌ ntyjii ya jon nin ꞌnan ndyiiꞌ nꞌonhan. Joꞌ tso jon nnon juu tsanꞌñeen na tatei ntꞌö: —Quinanquintyjaꞌ, cüentyjeꞌ quiiꞌ ntꞌan nnꞌan. Ndoꞌ jnanquintyja tsanꞌñeen, tacüentyjeeꞌ juu xoncüe. ");
INSERT INTO azgNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ndoꞌ tso Jesús ndëëhan: —Mavaxꞌë ndëëhoꞌ, juu xuee na cotaꞌjndyëëhë, ¿Aa icüjiꞌ yahanꞌ na ntejndei tsꞌan tyje juu naviꞌ na iquenon juu, oo aa tyiꞌcüjiꞌ yahanꞌ na ntsꞌaa juuhanꞌ? ¿Aa chuhanꞌ na quitsinꞌman jon tyje jon chaꞌ tyiꞌngueꞌ juu, oo aa quiꞌndyiito jon na cueꞌ tsanꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ndoꞌ vi na jndë jndyiaaꞌ Jesús xiꞌjndio ndëë tsoñꞌen nanꞌñeen, tso jon nnon tsanviiꞌñeen: —Quitsindiuꞌ ntꞌöꞌ. Sꞌaa juu na nndaꞌ, ndoꞌ joꞌ ntjo ya ntcüeꞌ ntꞌö juu. ");
INSERT INTO azgNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Majoꞌ joo nanꞌñeen, tyion jndyihanꞌ quindyaꞌ ngiohan yo Jesús. Ndoꞌ tonanꞌjndaꞌhan yo ntyjehan nin ꞌnan ndëë ntꞌahan chaꞌ quitꞌuiiviꞌhanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Majoo xeeꞌñeen tava Jesús ncüii tyoꞌ na ntsinin jon nnon Tyoꞌtsꞌon. Minnchaꞌ tsjon totsinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Xjen na jndë tixuee, tqueenꞌ jon nnꞌan na tonanꞌjon jñꞌoon na toninncyaa jon. Ndoꞌ tji jon nchoꞌvehan, ndoꞌ tꞌua jon tsꞌian ndëëhan na ncꞌoncyahan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ndö nguee nanꞌñeen: Simón, siquijndyu Jesús jon Pedro, yo tyje jon Andrés, yo Santiago yo Juan, yo Felipe yo Bartolomé, ");
INSERT INTO azgNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Yo Mateo, yo Tomás, yo Santiago jnda Alfeo, yo Simón tsan na totyiiꞌhin yo tmaanꞌ nnꞌan na tonanꞌvehan nacjooꞌ gobiernon tsjoon Roma, ");
INSERT INTO azgNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yo Judas tyje Santiago, yo ninꞌJudas Iscariote, tsan na jndëcya tyincyaa juu cüenta Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ndoꞌ vi na jndë joꞌ, jndyocue Jesús juu tyoꞌñeen yo tsoñꞌen nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon. Sacüentyjeeꞌhan ncüii su. Ndoꞌ jndye nnꞌan na conanꞌjon yo jñꞌoon na toninncyaa jon, jndë squenonhan joꞌ. Mantyi jndye jndyi nnꞌan na jnan ninvaa Judea yo Jerusalén yo ꞌndyo ndaandue na ndyo tsjoon Tiro yo Sidón. Tyincyo nanꞌñeen na ninꞌquindyehan jñꞌoon na toninncyaa jon ndoꞌ na ntsinꞌman jonhan ntycu na coquenonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ndoꞌ mantyi sinꞌman jon nnꞌan na ji vaa jndyi tonanꞌchu jndyetyiahin. ");
INSERT INTO azgNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tsoñꞌen nnꞌan tojntꞌuehan nchu vaa nquii ntꞌahan chaꞌ ndëë ntꞌuehan jon. Ee vaa najndei na condui jon na nnꞌman minninchen tsꞌan na ntꞌuii juuhin. ");
INSERT INTO azgNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ndoꞌ jndyiaaꞌ Jesús ndëë nnꞌan na conanꞌjon yo jñꞌoon na toninncyaa jon. Itso jon: —ꞌOꞌ nnꞌan na ntyꞌia ro nanꞌxuanhoꞌ, incyaahanꞌ na neinhoꞌ ngꞌe na coninncyahoꞌ na ityeꞌntjon Tyoꞌtsꞌon ꞌoꞌ ntyja na cotsamꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“ꞌOꞌ na ninꞌjndoꞌhoꞌ nanein, incyaahanꞌ na neinhoꞌ ee nninncyaa Tyoꞌtsꞌon na ngacjohoꞌ. “ꞌOꞌ na cotyueehoꞌ nanein, incyaahanꞌ na neinhoꞌ, ngꞌe ngüentyja xjen na nnonncohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Incyaahanꞌ na neinhoꞌ na conanꞌjndo nnꞌanhoꞌ na cotjiꞌhin ꞌoꞌ quiiꞌ ntꞌanhan ngꞌe na conanꞌjonhoꞌ yo ntyja njan, ndoꞌ ya na conanꞌcüejnaanꞌhan ꞌoꞌ na conduehan na nanꞌxuanhoꞌ nnꞌan viꞌ nnꞌanhoꞌ ngꞌe conanꞌjonhoꞌ yo ja. ");
INSERT INTO azgNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Juu xjen na nndaꞌ min na coquenonhoꞌ, cꞌonhoꞌ na nein jndyihoꞌ ngꞌe ndochi nanꞌñeen mandöꞌ ro tontꞌaviꞌhan nque nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nnguaa. Cüaaꞌ nꞌonhoꞌ na juu quiñoonꞌndue, joꞌ tꞌman naya condive ntyja ꞌnaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Majoꞌ ꞌoꞌ nnꞌan na tꞌman qui nꞌonhoꞌ ꞌnan na tyahoꞌ, viꞌ jndyi ntquenonhoꞌ ngꞌe veꞌ xiaꞌntyi juuhanꞌ incyaahanꞌ na neinhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Mantyi ꞌoꞌ nnꞌan na tatsitjahanꞌ ꞌnan na ninjntꞌuehoꞌ nanein, viꞌ jndyi ntquenonhoꞌ, ngꞌe ngüentyja xjen na ntsitjahanꞌ ꞌnan ꞌoꞌ. “Mantyi ꞌoꞌ nnꞌan na nein jndyihoꞌ nanein, viꞌ jndyi ntquenonhoꞌ, ngꞌe ngüentyja xjen na nndyueehoꞌ ndoꞌ nnanꞌxuaahoꞌ na chjooꞌ jndyi nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Tsoñꞌen nnꞌan jeꞌ, xjen na conanꞌneinhan jñꞌoon ya ntyja ꞌnaanhoꞌ, viꞌ jndyi ntquenonhoꞌ ngꞌe nque ndochi nanꞌñeen, manndaꞌ tonanꞌneinhan ntyja ꞌnaan joo nnꞌan na tyiꞌyuuꞌ jñꞌoon toninncyahan ntyja nchu vaa ꞌnan na nnguaa. ");
INSERT INTO azgNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ꞌOꞌ nnꞌan na condyehoꞌ jñꞌoon na mancya, ndö vaa na matsjö ndëëhoꞌ, quinanꞌveꞌngiohoꞌ nnꞌan na jndohan ꞌoꞌ. Ndoꞌ mantyi nque nnꞌan na tyiꞌcueeꞌ nꞌonhan ꞌoꞌ, quintꞌahoꞌ na ya nnꞌanhoꞌ yohan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Mantyi nque nnꞌan na condue jñꞌoon tsanꞌ nacjohoꞌ, quitanhoꞌ na quityio Tyoꞌtsꞌon jnꞌaan nanꞌñeen. Ndoꞌ mantyi quinanꞌneinhoꞌ nnon jon ntyja ꞌnaan nnꞌan na cojntꞌue na quitꞌuiiviꞌhanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Xe na aa mminꞌ tsꞌan ndaꞌ nchcya quinchoꞌ, mantyi ncyaꞌ na quiminꞌ juu ncüiichen ntyja. Ndoꞌ xe na aa ncüjiꞌ tsꞌan juu ndiaasoꞌ, quintjo ya nchjiꞌ min na mantyi ngayꞌoon juu cotonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ndoꞌ minninchen tsꞌan na ican ncüii ꞌnan nnonꞌ, ncyaꞌhanꞌ nnon juu, ndoꞌ ya na vjayꞌoon tsꞌan ncüii ꞌnanꞌ, tyiꞌntsingꞌeꞌ na quitsintcüeꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chaꞌxjen na ntꞌue nꞌonhoꞌ na quintꞌa nnꞌan yo ꞌoꞌ, majoꞌntyi quintꞌahoꞌ yohan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Xe veꞌ xiaꞌntyi na conanꞌvengiohoꞌ nnꞌan na mantyi vengiohan ꞌoꞌ, ¿Yuu vaa na ya jndyi contꞌahoꞌ? Ee mantyi joo nnꞌan na tyiꞌquinanꞌjñꞌoonꞌhan juu jñꞌoonꞌ Tyoꞌtsꞌon, macüejon contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ndoꞌ xe veꞌ contꞌahoꞌ na ya nnꞌanhoꞌ yo joo nnꞌan na mantyi ya nnꞌanhan yo ꞌoꞌ, ¿Yuu vaa na ya jndyi contꞌahoꞌ? Ee mantyi joo nnꞌan na tyiꞌquinanꞌjñꞌoonꞌhan jñꞌoonꞌ Tyoꞌtsꞌon, majoꞌntyi contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ndoꞌ mantyi ꞌoꞌ xe veꞌ cotejndeihoꞌ ꞌnan joo nnꞌan na mantyi ntyja nꞌonhoꞌ na quitejndei nanꞌñeen ꞌoꞌ, ¿Yuu vaa na ya jndyi contꞌahoꞌ? Ee joo nnꞌan na tyiꞌquinanꞌjñꞌoonꞌhan juu jñꞌoonꞌ Tyoꞌtsꞌon, mantyi cotejndeihan ꞌnan ntyjehan ee ngiohan na ntcüeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Majoꞌ ꞌoꞌ, quinanꞌvengiohoꞌ nnꞌan na vjehan ꞌoꞌ. Quintꞌahoꞌ na ya nnꞌanhoꞌ yohan. ꞌNaan na min, quitejndeihoꞌhanꞌ nnꞌan, min tandyiiꞌ nꞌonhoꞌ na aa nnanꞌntcüeꞌhinhanꞌ. Ee xe na aa nntꞌahoꞌ na nndaꞌ, yajoꞌ tꞌman naya nnanꞌxuanhoꞌ quiñoonꞌndue. Ee na nntꞌahoꞌ na nndaꞌ, ntsiꞌmanhanꞌ na conduihoꞌ ntsinda nquii Tyoꞌtsꞌon na mꞌaan nandyentyichen. Ngꞌe mantyi nquii jon mꞌaan jon na viꞌntyjii jon joo nnꞌan na min tyiꞌconduehan na ncya ya jon. Ndoꞌ joo nnꞌan na tyia nnꞌanhan, mantyi ventyjii jonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cꞌonhoꞌ na ntyꞌia ro tsoñꞌen ntyjehoꞌ ngiohoꞌ chaꞌxjen nquii tyehoꞌ mꞌaan jon na ntyꞌia ro tsoñꞌen nnꞌan ntyjii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Tavijntꞌuehoꞌ jnan nnꞌan na veꞌ xjen ꞌnaan nquehoꞌ, chaꞌ tyiꞌntsꞌaahanꞌ na ntcoꞌxen Tyoꞌtsꞌonhoꞌ. Min tavijntꞌuehoꞌ na quitꞌuiityenhanꞌ nnꞌan na veꞌ xjen ꞌnaan nquehoꞌ chaꞌ min tyiꞌntꞌuii Tyoꞌtsꞌon ꞌoꞌ. Ndoꞌ quinanꞌtꞌman nꞌonhoꞌ nnꞌan chaꞌ mantyi nquii jon ntsitꞌman tsꞌon jon ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ꞌNan na icanhanꞌ nnꞌan, ncyahoꞌhanꞌ ndëëhan, ya joꞌ mantyi ncyꞌonhoꞌ cüenta ꞌnan na ntejndeihanꞌ ꞌoꞌ. Ee Tyoꞌtsꞌon nninncyaa jon na ncyꞌonhoꞌ cüenta ncüii na quindë ya toxenhanꞌ. Juuhanꞌ itsijonhanꞌ chaꞌvijon ncüii na titoncüiiꞌ yahanꞌ, tyen tyecuehanꞌ ata vantjoꞌchen na tooꞌhanꞌ. Ee chaꞌxjen juu na conincyahoꞌ ndëë nnꞌan, majuuntyihanꞌ na ntsintcüeꞌ Tyoꞌtsꞌon na conjonhanꞌ ndëëhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ndö jñꞌoon tyiꞌquitso nquiiꞌhanꞌ na sinin Jesús ndëë nanꞌneen, tso jon: —Ncüii tsannchjaanꞌ, ¿Aa ndëë ngayꞌoon juu tyje nchjaanꞌ juu? Majoꞌ xe na aa ndui na nndaꞌ, ninncüii tojnaanꞌ ntycyaahan tsëꞌtsjoon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ncüii tsꞌan na itsijnaanꞌ juu, tyiꞌconduihin chaꞌxjen nquii tsꞌan na itsiꞌman nnon juu, majoꞌ vi na jndë jndë na itsijnaanꞌ juu ntyjantyi na siꞌman tsanꞌñeen nnon juu, yajoꞌ ntsijonhanꞌhin chaꞌna nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Jen maquenꞌ cüenta ꞌnan chjo na sitja ncüiichen tsꞌan, ndoꞌ min ncuꞌ tyiꞌquenꞌ cüenta na tꞌman matsitja ꞌuꞌ. Itsijonhanꞌ ntyja ꞌnanꞌ chaꞌvijon na mandyiaꞌ jndëëꞌ nꞌoon na tua tënnon ncüiichen tsꞌan, majoꞌ min ncuꞌ minꞌchjo tyiꞌquenꞌ cüenta na ñjon tsontscaaꞌ tënnonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ndoꞌ na nndaꞌ, jeꞌquindëë na ntsuꞌ nnon tsanꞌñeen: ꞌUꞌ ntyjë, ncyaꞌ na ncüjiꞌ ja jndëëꞌ nꞌoon na tua tënnonꞌ, majoꞌ min ncuꞌ tyiꞌquenꞌ cüenta na tsontscaaꞌ ñjon tënnonꞌ. ꞌUꞌ na ve vaa matsaꞌ, ncuꞌ cüjiꞌ jndyeeꞌ tsontscaaꞌ na ñjon tënnonꞌ. Ya joꞌ nninncyaahanꞌ na xuee nndyiaꞌ na ncüjiꞌ jndëëꞌ nꞌoon tënnon ncüiichen tyꞌiuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Taꞌnan ncüii tsꞌoon ya na ninnquiiꞌchen na ninncyaahanꞌ të na tyiꞌya. Ndoꞌ juu tsꞌoon na tyiꞌya, min tyiꞌjeꞌquitsꞌaahanꞌ të ya. ");
INSERT INTO azgNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Cotaꞌjnꞌaan nnꞌan ncüii cüii nnon tsꞌoon ntyjantyi të na itsꞌaahanꞌ. Ee tyiꞌjeꞌquityjee tsꞌan tëndöndyooꞌ tsjan ncüii ntꞌoo neon. ");
INSERT INTO azgNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Manndaꞌ vaa itsijonhanꞌ ntyja ꞌnaan nnꞌan chaꞌna nꞌoon ntjon. Juu tsꞌan na ya tsꞌanhin, itsꞌaa juu chaꞌxjen na chuhanꞌ, ee quiiꞌ tsꞌon juu conan ꞌnan na ya na itsitiu juu. Majoꞌ tsꞌan na tyia tsixuan, ꞌnan na itsꞌaa juu mꞌaanhanꞌ ntyja ꞌnaanꞌ ꞌnan natyia, ee quiiꞌ tsꞌon juu conan natyia na itsitiu juu. Ntyjantyi na itsitiu ncüii cüii tsꞌan quiiꞌ tsꞌon juu, joꞌ conan ꞌnan tyia na itsinin juu. ");
INSERT INTO azgNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Ndu na conduehoꞌ ta nnön xjen na coꞌmanhoꞌ ja? Majoꞌ min tyiꞌninꞌquintꞌahoꞌ ꞌnan na matsjö ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ntsiꞌman ndëëhoꞌ nchu vaa na itsijonhanꞌ ncüii cüii tsꞌan na icüjeeꞌ na mꞌan ja na indyii juu jñꞌoon na mancya, ndoꞌ na ivangueeꞌ juu joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Itsijonhanꞌ juu chaꞌvijon ncüii tsꞌan na jndaꞌ xquen na sia juu vaaꞌ. Njoon jñꞌen juu, tyen tquen juu ntjöꞌ tsjaanꞌ vꞌaaꞌñeen chaꞌ tyen cüentyjeeꞌhanꞌ. Ndoꞌ juu xjen na tuaꞌ, sijndyehanꞌ ndaa jndaa, jndei tovaquiñjonhanꞌ juu vꞌaaꞌñeen, majoꞌ taꞌnan tyioohanꞌ ngꞌe tui ya tsꞌianhanꞌ sꞌaa tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Majoꞌ juu tsꞌan na veꞌ indyii ngue juu jñꞌoon na mancya, majoꞌ min tyiꞌvangueeꞌ juu joohanꞌ, itsijonhanꞌ tsanꞌñeen chaꞌvijon ncüii tsꞌan na tsanꞌ xquen na sia juu vaaꞌ na veꞌ jnantohanꞌ nnon tyuaa. Taꞌnan jndë tsjaanꞌhanꞌ yo ntjöꞌ. Jndë na tuaꞌ, sijndyehanꞌ ndaa jndaa ndoꞌ jndei taquiñjonhanꞌ juu vꞌaaꞌñeen, maquintyjachen sinquehanꞌ. Ndoꞌ tꞌman tsu ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Vi na jndë sinin Jesús tsoñꞌen jñꞌoonminꞌ na tondye nnꞌan, yajoꞌ tantcüeꞌ jon Capernaum. ");
INSERT INTO azgNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Juu tsjoonꞌñeen mꞌaan ncüii capitán na icoꞌxen jon ncüii ciento sondaro. Ndoꞌ mꞌaan ncüii mosooꞌ jon na mioon viiꞌ tsanꞌñeen, maninꞌcueꞌ juu. Njon jndyi juu nchjii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Juu capitánꞌñeen, vi na jndë jndyii jon jñꞌoon ntyja ꞌnaanꞌ Jesús, tꞌua jon tsꞌian ndëë vendye nnꞌan judíos na conintque na cꞌohan na mꞌaan Jesús, na quitanhan nnon jon na quindyotsinꞌman jon mosooꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Nanꞌñeen tyꞌehan na mꞌaan Jesús. Ndoꞌ vi na jndë squehan joꞌ, jnduehan nnon jon: —Nquii tsꞌan na tꞌua tsꞌian ndë́, ya tsꞌanhin. Mangꞌe joꞌ, chuhanꞌ na quitsijñꞌonꞌ jñꞌoon na ican jon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ee njon jndyi nchjii jon nque ntyjëëhë nnꞌan Israel. Ndoꞌ mantyi siquitsu jon na jndë vatsꞌon tsjö́n. ");
INSERT INTO azgNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Yajoꞌ tja Jesús yo nanꞌñeen. Majoꞌ ya na mavaa xjen na ntsquehan vaaꞌ juu capitánꞌñeen, tꞌua tsanꞌñeen tsꞌian ndëë vendye nnꞌan na ya jñꞌoonhan yo jon na quinduehan nnon Jesús: —Nndaꞌ ta, juu tsꞌan na viiꞌ mosooꞌ, incyaa jon tsꞌon ꞌnaanꞌ jon nnonꞌ. Itso jon na tantsichjuꞌntyiꞌ ntyja ꞌnaanꞌ jon, ngꞌe itso jon tyiꞌtsixuan jon na ngaqueꞌ quiiꞌ vaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Mangꞌe na nndaꞌ vaa na icüjiꞌ jon cüenta ntyja ꞌnaanꞌ jon, joꞌ na tyiꞌtsitiu jon na ndyo nquii jon na mꞌanꞌ. Joꞌ itso jon veꞌ quitsuꞌ na quinꞌman moso ꞌnaanꞌ jon, ndoꞌ nꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nndaꞌ vaa nchjii jon ngꞌe mantyi nquii jon mꞌaan jon nacje ꞌnaan nnꞌan na cotoxenhan jon, ndoꞌ mantyi mꞌan sondaro nacje ꞌnaanꞌ jon. Iꞌua jon tsꞌian nnon ncüiihin na cja juu ntꞌaa, ndoꞌ ncja juu. Ndoꞌ ngitso jon nnon ncüiichenhin na quindyo juu, ndoꞌ indyo juu. Ndoꞌ nnon moso ꞌnaanꞌ jon iꞌua jon tsꞌian na quitsꞌaa tsanꞌñeen, ndoꞌ itsꞌaa juuhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ndoꞌ vi na jndë jndyii Jesús jñꞌoon na tso capitánꞌñeen, tyincyaahanꞌ na taveeꞌ jndyi nchjii jon ntyja ꞌnaanꞌ tsanꞌñeen. Tequen jon ndëë nnꞌan na jndye jndyiꞌhin na tyentyjahan toxenꞌ jon, tso jon: —Quindyehoꞌ na matsjö, quiiꞌ ntꞌan ntyjëëhë nnꞌan Israel, minꞌjon tacontyꞌia ncüii tsꞌan na tꞌman vantyja tsꞌon juu chaꞌna juu tsanvahin. Nndaꞌ vaa jñꞌoon na tso Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ndoꞌ joo nnꞌan na jñon capitánꞌñeen, ya na tyentcüeꞌhan vaaꞌ jon, xjen na squehan joꞌ, jndiohan mosoꞌñeen na jndë jnꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tyiꞌcovivio xjen na tui na nndaꞌ, ndoꞌ tja Jesús tsjoon chjo Naín. Ndoꞌ nque nnꞌan na conanꞌjon yo jñꞌoon na toninncyaa jon, tyꞌehan yo jon yo ncüii tmaanꞌ nnꞌan na jndye jndyi. ");
INSERT INTO azgNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Ya na jndë tindyo na ntsquehan ꞌndyo tateon ntjöꞌ na ndyiiꞌ juu tsjoonꞌñeen, jntyꞌiahan na conduiꞌ nnꞌan na coquityꞌiuhan tsꞌoo. Juu ndyee tsꞌooꞌñeen, tsanscu ninnquiihin, ndoꞌ nquii tsꞌooꞌñeen, majuuñꞌen juu na singui jon. Jndye jndyi nnꞌan tsjoonꞌñeen tyenanꞌjonhan na vjantyꞌiu juu tsꞌooꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Xjen na jndyiaaꞌ ta Jesús juu tsanscuꞌñeen, tyioo na ndyiaꞌ ro juu nchjii jon. Tso jon nnon juu: —Nndaꞌ nan, tantꞌioꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ndoꞌ tantyjaaꞌ ta Jesús, tꞌuii jon jndu na ntyjo juu tsꞌooꞌhin. Ndoꞌ na nndaꞌ, joo nnꞌan na chohinhanꞌ, tyecüentyjeeꞌhan. Ndoꞌ tso jon nnon tsꞌooꞌñeen: —ꞌUꞌ yusꞌandyua, matsjö nnonꞌ: Quinanquintyjaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ndoꞌ joꞌ tacüetyen juu, tyeꞌ na itsinin juu. Yajoꞌ tyincyaa Jesús juu ntꞌö ndyee juu. ");
INSERT INTO azgNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ndoꞌ na tui na nndaꞌ, siquityꞌue jndyihanꞌ tsochen nanꞌñeen. Ndoꞌ taꞌhan tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. Jnduehan: —Quiiꞌ ntꞌan jaa jndë tyjeeꞌ ncüii tsꞌan na tꞌman jndyi conduihin na incyaa jon jñꞌoonꞌ Tyoꞌtsꞌon. Mantyi jnduehan: —Nquii Tyoꞌtsꞌon, jndë tyjeeꞌ jon na ntejndei jon jaa na condui jaa nnꞌan cüentaaꞌ nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ndoꞌ na nndaꞌ vaa na sꞌaa Jesús, tycya jñꞌoon ninvaa ndyuaa Judea yo njoon na mꞌaan xiꞌjndio ntꞌöhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa Juan, jnanꞌquindyiihanhin tsoñꞌen jñꞌoon ntyja ꞌnaanꞌ Jesús. Ndoꞌ joꞌ tꞌman jon ve nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Tꞌua jon tsꞌian ndëëhan na cꞌohan na mꞌaan Jesús na quitsataꞌxeeꞌhan nnon jon na aa conduihin nquii Mesías na cominndooꞌ nnꞌan judíos na ncüjeeꞌ, oo aa icanhanꞌ na ngüendooꞌhin ncüiichen tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ndoꞌ nanꞌñeen jeꞌ, vi na jndë squehan na mꞌaan Jesús, jnduehan nnon jon: —Nndaꞌ ta, nquii Juan, tsan na totsiquindëëꞌ nnꞌan, jñon jon já na mꞌanꞌ na quindyotaꞌxꞌë́ nnonꞌ: “¿Aa condui ꞌuꞌ nquii Mesías na cominndooꞌ nnꞌan na ncüjeeꞌ, oo aa icanhanꞌ na ngüendooꞌhan ncüiichen?” ");
INSERT INTO azgNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ndoꞌ maninꞌjuu xjenꞌñeen, sinꞌman Jesús nnꞌan vꞌi na jndye nnon ntycu na coquenonhan. Mantyi sinꞌman jon nnꞌan na mꞌaan jndyetyia quiiꞌ nꞌonhan, ndoꞌ sꞌaa jon na joo nannchjan, xuee jntyꞌia nndaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ndoꞌ tꞌa jon jndyue nanꞌñeen na jñon Juan: —Quitsantcüeꞌhoꞌ na mꞌaan Juan. Quinanꞌquindyiihoꞌhin ntyja ꞌnaanꞌ ꞌnan na jndë macondyehoꞌ yo na cojntyꞌia ndëëhoꞌ. Quinduehoꞌ nnon jon na joo nannchjaan, xuee cojntyꞌia nndaꞌhan, ndoꞌ joo nnꞌan na ntjein ngꞌe, ya cotsacaꞌhan. Nnꞌan na cho ndöꞌ cotöꞌ, nein jndë jnꞌmanhan. Joo nnꞌan na quita, neinhin ya condyehan. Nnꞌan na jndë tjë, cotaꞌndoꞌ xcohan, ndoꞌ joo nnꞌan na ntyꞌiahan, jndë macondyehan jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ndoꞌ juu tsꞌan na tyiꞌcꞌoonꞌ tsꞌon na ve vaa yo ntyja njan, neiinꞌ jndyi juu. ");
INSERT INTO azgNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ndoꞌ vi jndë na tyentcüeꞌ nanꞌñeen, taꞌ Jesús na sinin jon ndëë nnꞌan na jndye jndyiꞌhin ntyja ꞌnaanꞌ juu Juanꞌñeen. Tso jon: —¿Nchu vaa na saquijntyꞌiahoꞌ na tyꞌehoꞌ ndyuaa na tyiꞌjndye nnꞌan mꞌan naijon na tomꞌaan jon? ¿Aa tjiꞌhoꞌ cüenta na itsijonhanꞌhin chaꞌvijon ncüii tsman tsꞌoon na nayꞌoon jndyehanꞌ? Ja nchji chito aa joꞌ tsixuan jon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ya joꞌ ¿Nchu vaa na saquijntyꞌiahoꞌ? ¿Aa jntyꞌiahoꞌhin na cüe jon ndiaa na njon jndyi? ꞌOꞌ mangiohoꞌ nque nnꞌan na cocüe ndiaa na njon jndyi, tacotsitjahanꞌ ꞌnan na ntcüaꞌhan ndoꞌ ninnquiiꞌchen mꞌanhan ntꞌaa na mꞌan rey. ");
INSERT INTO azgNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ngꞌe na nndaꞌ, ¿Nchu vaa na saquijntyꞌiahoꞌ? ¿Aa jntyꞌiahoꞌ na conduihin tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon? Ncö mavꞌa ja jñꞌoonvaꞌ, mayuuꞌ majoꞌ conduihin. Ata tꞌmanntyichen tsꞌian itsixuan jon, chichen minꞌcya ro nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juu jon conduihin nquii tsꞌan na tsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon na jndui. Itsohanꞌ: Ja majñönntyë ncüii moso njan na vejndyee jon tonnonꞌ na ngayꞌoon jon juu jñꞌoon njan. Ncüjiꞌ jndyoyu jon ntyja ꞌnanꞌ chaꞌ ncꞌoncje nnꞌan xjen na ngueꞌ na mꞌanhan.” Tsontyichen Jesús: ");
INSERT INTO azgNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, quiiꞌ ntꞌan nnꞌan na mꞌan tsonnangue naneinhin, taꞌnan tsꞌan na incyaa juu jñꞌoonꞌ Tyoꞌtsꞌon na tꞌmanntyi conduihin chaꞌna nquii Juan, tsan na totsiquindëëꞌ nnꞌan. Majoꞌ vaa jñꞌoon xco na itsijndaꞌ Tyoꞌtsꞌon na icoꞌxen jon nnꞌan ntyja ꞌnaanꞌ na cotsamꞌanhan. Ndoꞌ minninchen tsꞌan, min tyiꞌtꞌman ivaaꞌ tsꞌon juu ntyja ꞌnaanꞌ juu jñꞌoon xcoꞌñeen, tꞌmanntyichen condui tsanꞌñeen, chichen nquii Juan. ");
INSERT INTO azgNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","“Ndoꞌ nnꞌan na cotye sꞌon cüentaaꞌ gobiernon Roma, yo ninꞌtsoñꞌen nnꞌan, xjen na jndyehan jñꞌoonꞌñeen na tso Jesús, tjiꞌ jndyoyuhan na itsꞌaa Tyoꞌtsꞌon chaꞌxjen na chuhanꞌ. Nndaꞌ vaa tjiꞌhan cüenta ee mantyi na jndë siquindëëꞌ Juan joohan. ");
INSERT INTO azgNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Majoꞌ joo nnꞌan na conduihan tmaanꞌ fariseos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoonꞌ Tyoꞌtsꞌon na tquen Moisés, jntꞌahan na tyiꞌquijntꞌue jñꞌoon na sijndaꞌ Tyoꞌtsꞌon na ntsinꞌman jon ñuaan nnꞌan, min tajnanꞌjonhan ntyja na totsiquindëëꞌ Juanꞌñeen nnꞌan.” ");
INSERT INTO azgNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ndoꞌ tso Jesús ndëë nanꞌñeen: —Nnꞌan na mꞌan nanein, ¿Nin ꞌnan ntsijönꞌ jahan? ¿Nin ncüii nnon itsijonhanꞌhin? ");
INSERT INTO azgNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","“Itsijonhanꞌ nanminꞌ chaꞌna yotsca na tyiꞌninꞌquinanꞌtjonꞌ yoꞌñeen jñꞌoon yo ntyje joo na concyꞌo joo nata. Conanꞌxuaa yoꞌñeen ntyje joo, condue joo: Cotjáꞌ tsman son na coco tsꞌan, majoꞌ tyiꞌninꞌquinanꞌjnonhoꞌ. Ndoꞌ mantyi cotjáꞌ son ntyja na tueꞌ tsꞌan, majoꞌ min tyiꞌninꞌquityueehoꞌ.” Nndaꞌ vaa jñꞌoon conanꞌxuaa yotscaꞌñeen ndëë ntyje joo. ");
INSERT INTO azgNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Tsontyichen Jesús: “Ndoꞌ juu xjen na tyjeeꞌ nquii Juan, tsan na totsiquindëëꞌ nnꞌan, na veꞌ ninntyi ꞌnan na tocüaꞌ jon, min tatꞌu jon vinon, ndoꞌ tonduehoꞌ na totsixuan jon yutyia. ");
INSERT INTO azgNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Majoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, jndë tyjë quiiꞌ ntꞌanhoꞌ, matsijon ja yo nnꞌan, macüꞌa yohan ndo maꞌva vinon. Majoꞌ conduehoꞌ na condui ja tsꞌan na icüaꞌ quitscu ndoꞌ tenon ntyja xjen na iꞌu. Conduehoꞌ na matsijon ja yo nnꞌan na cotye sꞌon cüentaaꞌ gobiernon Roma ndoꞌ yo nnꞌan na conanꞌtjahan tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Majoꞌ tanin, ee juu na jndaꞌ xquen Tyoꞌtsꞌon, covitincyooꞌ jndyoyuhanꞌ na tsoñꞌen na itsijndaꞌ jon itsiꞌmanhanꞌ na nndaꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Ncüii tsꞌan tmaanꞌ fariseo, tqueenꞌ juu Jesús vaaꞌ juu na ntcüaꞌhan. Ndoꞌ joꞌ tja Jesús, tueeꞌ jon joꞌ. Taqueeꞌ jon vaaꞌ tsanꞌñeen ndoꞌ tacjo jon mesa na ntcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ndoꞌ juu tsjoonꞌñeen, joꞌ tomꞌaan ncüii tsanscu na veꞌ ndöꞌ ro mꞌaan juu yo nnꞌan. Vi na jndë jndyii juu na joꞌ mꞌaan Jesús na icüaꞌ jon yo nnꞌan vꞌaaꞌñeen, tja juu joꞌ. Tayꞌoon juu ncüii tsioo na jndëhanꞌ yo tsjöꞌ quichiꞌ na jndyuhanꞌ alabastro na ñjon nchenꞌ quichihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Tecüentyjeeꞌ juu ngiaaꞌ Jesús tongꞌee jon. Ndoꞌ taꞌ juu na itꞌioo juu ndoꞌ ndaa nnon juu toncyaahanꞌ cjooꞌ ngꞌee Jesús. Mantyi toveꞌ juu ngꞌee jon yo soxquen juu. Toꞌu juu ngꞌee jon ndoꞌ tocyu juu nchenꞌ quichiꞌñeen ngꞌee jon. ");
INSERT INTO azgNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Majoꞌ juu fariseoꞌñeen na tqueenꞌ juu Jesús na cüaꞌ jon yohin, xjen na jndyiaaꞌ juu na nndaꞌ vaa, joꞌ sitiu nquii juu: “Juu tsanvahin, xe na aa mayuuꞌ conduihin tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja ꞌnan na nguaa, ya joꞌ jndë taaꞌ tsꞌon jon nin tsꞌan tsanscuvahin ndoꞌ nin manyan tsixuan juu na veꞌ ndöꞌ ro mꞌaan juu yo nnꞌan.” Nndaꞌ vaa na tondyiiꞌ tsꞌon tsanfariseoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ndoꞌ juu Jesús, tso jon nnon fariseoꞌñeen: —Nndaꞌ Simón, vaa jñꞌoon na ninꞌquitsjö nnonꞌ. Tꞌa tsanꞌñeen, tso juu: —¿Nin ꞌnan, ta? Quitsuꞌ ndyi. ");
INSERT INTO azgNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tso Jesús: —Tomꞌaan ncüii tsꞌan na totejndei jon xoquituꞌ nnꞌan. Ndoꞌ tomꞌaan ve tsꞌan na toquichojnanhan nnon jon. Ncüii tsanꞌñeen chujnan juu ꞌon ciento sꞌon denarios, ndoꞌ ncüiichen tsanꞌñeen, chujnan juu ninvennꞌan nchoꞌnqui denarios. ");
INSERT INTO azgNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ndoꞌ ngꞌe taꞌnan cuaa sꞌon na ndyionhan na chojnanhan nnon jon, majoꞌ min na nndaꞌ, sitꞌman tsꞌon jonhan. Nndaꞌ vaa jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ na sinin Jesús. Tsontyichen jon: —Nanein ntꞌue tsꞌön na quitsuꞌ nnön ¿Nin ncüii na vehan ncꞌoon juu na venchjiintyichen juu jon? ");
INSERT INTO azgNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tꞌa Simónꞌñeen, tso juu: —Mꞌaanꞌ tsꞌön na juu tsꞌan na tꞌmanchen na chujnan, njonntyichen tsanꞌñeen nchjii juu. Sintcüeꞌ Jesús jñꞌoon, tso jon: —Majoꞌ ro macüjiꞌ cüenta. ");
INSERT INTO azgNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ndoꞌ joꞌ tequen Jesús, jndyiaaꞌ jon nnon tsanscuꞌñeen, tso jon nnon Simón: —Maquenꞌ cüenta ntyja ꞌnaanꞌ juu tsanscu na mꞌaan ndö, ¿Aa tyiꞌyuuꞌ? Tyjë ja vaꞌ, majoꞌ min tandaa tyincyaꞌ na mman ngꞌë, majoꞌ juu tsanvaꞌ, jndë tman juu ngꞌë yo ndaa nnon juu, ndoꞌ tueꞌ juu ngꞌë yo soxquen juu. ");
INSERT INTO azgNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Tasiquindëꞌ costumbre na ncꞌuaꞌ quinchꞌö na ninncyaꞌ tsꞌon ja, majoꞌ tsanvaꞌ jeꞌ, ntyjantyi xjen na tyjë vaꞌ, tacovacüentyjeeꞌ juu na iꞌu juu ngꞌë. ");
INSERT INTO azgNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","“ꞌUꞌ min tascongioꞌ nchenꞌ xquën, majoꞌ tsanvaꞌ jndë scongio juu nchen quichi ngꞌë. ");
INSERT INTO azgNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Mangꞌe na nndaꞌ, joꞌ matsjö nnonꞌ na jndë sitꞌman tsꞌon Tyoꞌtsꞌon jnaanꞌ juu na jndye jndyihanꞌ ngꞌe tꞌman vaa na venchjii juu ja. Majoꞌ juu tsꞌan na tyiꞌjndyechen na tsitꞌman tsꞌon Tyoꞌtsꞌon, mantyi tyiꞌvenchjii ya tsanꞌñeen ja. ");
INSERT INTO azgNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jndë joꞌ tso Jesús nnon tsanscuꞌñeen: —Jndë sitꞌman tsꞌön tsoñꞌen na matsitja ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ndoꞌ joo nnꞌan na vendyuaa mesa joꞌ yo jon, taꞌhan na cotaꞌxeeꞌhan ndëë ntyjehan: —Juu tsanvaꞌ, ¿Nin tsꞌan conduihin na ata itsitꞌman tsꞌon jon jnan nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yajoꞌ itso jon nnon tsanscuꞌñeen: —Ngꞌe na vantyja tsonꞌ ja, joꞌ na jndë sinꞌman Tyoꞌtsꞌon ñuan ꞌnanꞌ. Nanein cjaꞌ, na minꞌchjo jñuaanꞌ tsꞌon tyiꞌncꞌonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jndë na tui na nndaꞌ, tja Jesús tsochen njoon tꞌman yo njoon quijndë na toninncyaa jon jñꞌoon naya ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na cotsamꞌanhan. Ndoꞌ nque nnꞌan na nchoꞌve tyꞌehan yo jon. ");
INSERT INTO azgNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ndoꞌ mantyi ñꞌen nanntcu na jndë sinꞌman jon na tomꞌaan jndyetyia quiiꞌ nꞌonhan. Ndoꞌ ñꞌen minndye nanntcu na jndë sinꞌman jonhan ncüii cüii nnon ntycu na toquenonhan. Ncüiihan jndyu María, tsan tsjoon Magadán, juu na jndë tjiꞌ Jesús ntyqueꞌ yotyia quityquiiꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ndoꞌ mantyi ñꞌen Juana yohan. Juu jon scuuꞌ tsan na jndyu Chuza. Juu Chuzaꞌñeen totejndei juu Herodes tsꞌian na totsixuan jon. Ndoꞌ mantyi yo Susana ndoꞌ yo minndyechen ntyjentcuhan. Ndoꞌ xjen na vaa ꞌnan na tocanhanꞌ Jesús yo nnꞌan nchoꞌveꞌñeen, totejndei nanntcuꞌñeen jon yo ꞌnan na tonanꞌyꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tonduiꞌ nnꞌan ncüii cüii tsjoon, totsquehan na mꞌaan Jesús. Xjen na tovancüihan, ndö vaa jñꞌoon na sinin jon ndëëhan na tyiꞌquitso nquiiꞌ jonhanꞌ: ");
INSERT INTO azgNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Tso jon: “Tomꞌaan ncüii tsꞌan na totsꞌaa jon tsꞌian jndëë. Taquitscyaa jon tsjan ntquen trigo. Ndoꞌ viochen xjen na itscyaa jonhanꞌ, minndyehanꞌ tycyaahanꞌ ꞌndyo nato. Jndyue nnꞌanhanꞌ, ndoꞌ mantyi ñꞌenhanꞌ na tquii quintsahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndoꞌ minndye ntquenꞌñeen tycyaahanꞌ naijon na jen ntjöꞌ. Jndë na tꞌonhanꞌ, maquintyjachen tëcanhanꞌ, jnaanꞌ na tyiꞌteiinꞌ tyuaa. ");
INSERT INTO azgNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndoꞌ minndyechenhanꞌ tycyaahanꞌ naijon na minntyjeeꞌ ndaaꞌ ntꞌööneon. Ninvixjen tavindyehanꞌ, majoꞌ joo ntꞌööneonꞌñeen tcahanꞌ joo ntjonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ndoꞌ mantyi minndye ntquenꞌñeen tycyaahanꞌ yuu jon na ya tsꞌo. Tꞌonhanꞌ ndoꞌ ya tueꞌhanꞌ. Ñꞌenhanꞌ na jntꞌahanꞌ ncüii cüii ciento ntquen na ncüiihanꞌ na iscyaa tsanꞌñeen.” Jndë na sinin Jesús jñꞌoonminꞌ, jndei sinin jon, tso jon: —ꞌOꞌ na min ndöꞌnquihoꞌ, cüaaꞌ nꞌonhoꞌ jñꞌoonvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ndoꞌ juu jñꞌoonꞌñeen na sinin Jesús na tyiꞌquitso nquiiꞌ jonhanꞌ, nque nnꞌan na tonanꞌjon yohin, taꞌxeeꞌhan nnon jon nchu vaa tsiquindyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tꞌa jon jndyuehan: —Ndëë ꞌoꞌ incyaa Tyoꞌtsꞌon na cüaaꞌ nꞌonhoꞌ jñꞌoon na vantyꞌiuuꞌ mꞌaanhanꞌ ntyja ꞌnaanꞌ na icoꞌxen jon nnꞌan nchu vaa na cotsamꞌanhan. Majoꞌ ndëë tsochen nnꞌan matsinën yo jñꞌoon na tyiꞌquitsjö ncꞌi chaꞌ min na cojntyꞌiahan ꞌnan na matsꞌa, majoꞌ tyiꞌxeꞌquitquenhan cüenta, ndoꞌ min na condyehan jñꞌoon na mancya, tyiꞌxeꞌcüaaꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Juu jñꞌoon na sinën na tyiꞌquitsjö ncꞌihanꞌ, ndö vaa na itsiquindyihanꞌ. Tsjan ntquen trigo na taquitscyaa tsanꞌñeen, jñꞌoonꞌ Tyoꞌtsꞌonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Joo tsjan ntquen na tycyaa ꞌndyo nato, joꞌ nnꞌan na condye jñꞌoonꞌ jon. Majoꞌ juu yutyia, macje ro ndyocüjiꞌ juu jñꞌoonꞌñeen quiiꞌ nꞌonhan chaꞌ tyiꞌcantyja nꞌonhan Tyoꞌtsꞌon ndoꞌ ngꞌe joꞌ, jeꞌquindëë ntsinꞌman jon ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ndoꞌ joo tsjan ntquen na tycyaa naijon na jen ntjöꞌ, joꞌ nnꞌan na condyehan jñꞌoonꞌ Tyoꞌtsꞌon. Yo na neinhan coyꞌonhan cüentahanꞌ. Majoꞌ tsijonhanꞌhin chaꞌvijon ntjon na taꞌnan nchꞌiohanꞌ. Veꞌ cüantyi ro xuee covantyja nꞌonhan, majoꞌ ya na nndyo ncüii nnon na ityiiꞌhanꞌ ngꞌeehanꞌhin, yajoꞌ coꞌndyehan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndoꞌ joo tsjan ntquen na tycyaa naijon na minntyjeeꞌ ndaꞌ ntꞌööneon, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon. Majoꞌ jen ndyiiꞌ nꞌonhan ntyja na cotsamꞌanhan. Ninꞌcuen ꞌnaanhan, ninꞌcꞌonhan ntyja na nanncooꞌ na tsixuan tsonnangue. Joꞌ na itsꞌaahanꞌ ntyja ꞌnaanhan chaꞌvijon ntjon na tatueꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Majoꞌ joo tsjan na tycyaa naijon na ya tsꞌo, joꞌ nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon. Yo na xoncüeeꞌ nꞌonhan na conanꞌvehinhanꞌ, ndoꞌ min na jndye nnon min na coquenonhan, majoꞌ tyiꞌquiꞌndyehinhanꞌ. Ntyja na cotsamꞌanhan covityincyooꞌ na contjotyenhan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ndoꞌ mantyi sinin Jesús ncüiichen jñꞌoon na tyiꞌquitsiꞌman nquiiꞌhanꞌ. Tso jon ndëëhan: “Taꞌnan tsꞌan na itscüꞌa chon candi ndoꞌ ntscuꞌ juuhanꞌ yo xuaa oo ntyiiꞌ juuhanꞌ tocjeeꞌ jndu. Chi ntsintyja tsꞌanhanꞌ chaꞌ xuee njntyꞌia nnꞌan na ngoqueeꞌ joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tsoñꞌen ꞌnan na matsꞌa nein na tyiꞌcondye nnꞌanhanꞌ, manquehoꞌ nnanꞌmanhoꞌhanꞌ ndëëhan. Ndoꞌ ncüii cüii jñꞌoon na tyiꞌquitsjö ncꞌi nanein, ngüentyja xjen na nque nnꞌan ninvaa tsonnangue ncüaaꞌ nꞌonhinhanꞌ. Ncꞌoon tyincyohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Yajoꞌ quitquenhoꞌ cüenta jñꞌoonminꞌ na matsinën ndëëhoꞌ. Ee xe na conanꞌvehoꞌhanꞌ, yajoꞌ ntsiꞌmanntyë jñꞌoon ndëëhoꞌ. Majoꞌ xe na aa tyiꞌquinanꞌvehoꞌhanꞌ, ntsꞌaahanꞌ na joo jñꞌoon na cotjiꞌhoꞌ cüenta na covaaꞌ nꞌonhoꞌ, veꞌ jnꞌaanhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ndoꞌ tacjuꞌhanꞌ tyjeeꞌ ndyee Jesús yo ntyje jon na mꞌaan jon, majoꞌ tajndëë squehan na njntyꞌiahan jon jnaanꞌ na jndye jndyi nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ndoꞌ nnꞌan na mꞌan joꞌ jnanꞌquindyiihan jon, jnduehan: —Nndaꞌ ta, ndyoꞌhöꞌ yo ntyꞌiuꞌhinꞌ mꞌanhan chꞌen. Ninꞌquinanꞌneinhan yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ndoꞌ tꞌa jon jndyuehan: —Nque nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon ndoꞌ cotaꞌngueeꞌhinhanꞌ, joohan conduihan ndyö yo ntyjö. ");
INSERT INTO azgNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ndoꞌ tacjuꞌhanꞌ ncüii xueeꞌñeen tua Jesús quiiꞌ vꞌaandaa yo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon. Tso jon ndëëhan: —Cja ngüejndya ndaandue. Ndoꞌ jnduiꞌhan, tyꞌonhan, totyꞌehan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ndoꞌ viochen xjen na covetꞌiohan joꞌ, tyꞌoon tsantsjon Jesús, tso jon. Ndoꞌ tyioo ncüii jndye tꞌman, jndei tomꞌaanhanꞌ nnon juu ndaandueꞌñeen. Sꞌaahanꞌ na vatooꞌ vꞌaandaa na ityionhanꞌ ndaa. Ninnqueeꞌ jnꞌaanꞌ tꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ndoꞌ tentyjaaꞌhan nnon jon, jnanꞌntcüihan jon. Jnduehan: —Nndaꞌ ta, manchjehanꞌ jaa tyquiꞌiꞌ ndaa, na ntscüeeꞌhanꞌ jaa. Yajoꞌ jnanquintyja jon, sityiaꞌ jon jndye yo na iju jndyi ndaandueꞌñeen ndoꞌ tacüentyjeeꞌhanꞌ. Taquiñjonchenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ndoꞌ tso jon ndëëhan: —¿Ndu na tyiꞌcantyja ya nꞌonhoꞌ ja? Majoꞌ joohan tyuehan ndoꞌ tëveeꞌ ngiohan. Ncüii ro ncüiihan taxeeꞌhan ndëë ntyjehan: —Juu tsanvaꞌ, ¿nin conduihin na min jndye ndoꞌ ndaa iquen jon xjenhanꞌ, ndoꞌ cotaꞌngueeꞌhanꞌ jñꞌoon ꞌndyo jon? ");
INSERT INTO azgNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jndë na tejndyahan juu ndaandueꞌñeen na jnanhan Galilea, squehan ndyuaa Gerasa. ");
INSERT INTO azgNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Xjen na jnduiꞌ Jesús vꞌaandaa, ncüii tsꞌan tsjoonꞌñeen jndyoquitjon juuhin. Tijndye xuee na itsixuan juu yotyia quiiꞌ tsꞌon juu. Tacocüe juu ndiaa ndoꞌ min tyiꞌcꞌoon juu vaaꞌ juu. Veꞌ tomandyiꞌto juu ndiꞌntꞌua ntꞌoo. ");
INSERT INTO azgNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Xjen na jndyiaaꞌ tsanꞌñeen Jesús, jndei sixuaa juu jntꞌa yotyiaꞌñeen. Tconxtye juu nnon jon, jndei sinin juu, tso juu: —¿Nin ꞌnan ntsaꞌ ja, ꞌuꞌ Jesús na condui ꞌuꞌ jnda nquii Tyoꞌtsꞌon na mꞌaan nandyentyichen? Matsꞌa tyꞌoo ꞌuꞌ na tyiꞌntsaꞌ na quitꞌuiiviꞌhanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nndaꞌ jñꞌoon tso juu ee na jndë tcoꞌxen Jesús na quinduiꞌ joo yotyiaꞌñeen quiiꞌ tsꞌon juu. Ee joo yotyiaꞌñeen, jndye jnda na jndë tquenhanꞌ xjen ꞌnaanhanꞌhin. Ee min na tonanꞌtyen nnꞌan tsanꞌñeen yo carena yo ncjo na totꞌuehanꞌ ntꞌö juu ndoꞌ ngꞌee juu, majoꞌ tocꞌiooꞌ juu joo carenaꞌñeen. Ndë joꞌ tojñon jndyetyiaꞌñeenhin na cja juu ndyuaa naijon na taꞌnan nnꞌan cꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Vi na jndë tso tsanꞌñeen na nndaꞌ, taxeeꞌ Jesús nnon juu: —¿Nchu jndyuꞌ? Tꞌa juu, tso juu: —Jndyu ja Legión. Nndaꞌ tso juu ee taxjen vaa jndye jndyi yotyia na jndë tua quiiꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndoꞌ joo yotyiaꞌñeen, tontꞌahan tyꞌoo Jesús na tyiꞌncꞌua jon tsꞌian ndëëhan na cꞌohan naijon na ntcoꞌviꞌhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ndyoviꞌ juu tyoꞌñeen mꞌan ncüii tmaanꞌ quintcu na cotquii oꞌ. Joꞌ tan yotyiaꞌñeen nnon jon na ncyaa jon jñꞌoon na ngoqueꞌhan quiiꞌ nꞌon joo quintcuꞌñeen. Ndoꞌ tyincyaa jon na vanaan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ndoꞌ vi jndë na jnduiꞌ yotyiaꞌñeen quiiꞌ tsꞌon juu tsanꞌñeen, tyequeꞌhan quiiꞌ nꞌon quintcuꞌñeen. Joꞌ na sꞌaahanꞌ na taꞌ choꞌñeen jnannon oꞌ, tycyaa oꞌ naijon na tyꞌa jndyi ꞌndyo ndaandue, mana nchjehanꞌ oꞌ tyquii ndaa, tjë oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ndoꞌ joo nnꞌan na totaꞌntyjeeꞌ quintcuꞌñeen, vi na jndë jntyꞌiahan juu ꞌnanꞌñeen na tui, jnanꞌnonhan, tyꞌehan tsjoon. Tonanꞌquindyiihan nnꞌan na mꞌaan jndëë ndoꞌ tsjoon na nndaꞌ vaa ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ndoꞌ joo nnꞌan na mꞌan joꞌ jnduiꞌhan, tyequijntyꞌiahan nin ꞌnan tui. Ndoꞌ xjen na squehan naijon na mꞌaan Jesús, jntyꞌiahan juu tsanꞌñeen na jndë jnduiꞌ yotyia quiiꞌ tsꞌon, vaquityen juu ngiaaꞌ Jesús, ndoꞌ na nndaꞌ, tyue jndyi nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ndoꞌ nque nnꞌan na jndë jntyꞌia ndëëhan ꞌnan na tui, jnanꞌneinhan ndëë nnꞌan ꞌnan na jndë tui. Chen chen jnduehan nchu tui na jnꞌman tsanꞌñeen na totsixuan juu yotyiaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ndoꞌ tsoñꞌen nnꞌan ndyuaa Gerasa, tanhan nnon Jesús na quinduiꞌ ntcüeꞌ jon quiiꞌ ntꞌanhan, ee tyue jndyihan ntyja ꞌnaanꞌ ꞌnan na tui. Ndoꞌ na nndaꞌ, tua nndaꞌ Jesús vꞌaandaa na vja ntcüeꞌ jon ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ndoꞌ juu tsanꞌñeen na jndë jnduiꞌ yotyia quiiꞌ tsꞌon, sꞌaa juu tyꞌoo Jesús na ncya jon jñꞌoon na chi ncja juu yohin, majoꞌ tataꞌngueeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Tso jon nnon juu: —Cja ntcüeꞌ na mꞌan nnꞌan vaꞌ. Ndoꞌ quitsuꞌ ndëëhan tsoñꞌen nnon naya na jndë itsꞌaa Tyoꞌtsꞌon yo ꞌuꞌ. Ya joꞌ tja ntcüeꞌ tsanꞌñeen, chen chen totsinin juu ndëë tsoñꞌen nnꞌan tsjoonꞌ juu ntyja ꞌnaanꞌ juu naya tꞌman na jndë sꞌaa Jesús yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Tejndya nndaꞌ Jesús ndaandue. Juu xjen na jnduiꞌ jon vꞌaandaa, mꞌan ncüii tmaanꞌ nnꞌan, nein jndyihan na tyjeeꞌ ntcüeꞌ jon, tyꞌonhan cüenta jon ngꞌe tsoñꞌenhan cominndooꞌhan na ncüjeeꞌ ntcüeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Majuu xjenꞌñeen tyjeeꞌnon ncüii tsꞌan na jndyu Jairo. Juu jon conintque ntyja ꞌnaanꞌ vatsꞌon ꞌnaan nnꞌan judíos juu tsjoonꞌñeen. Tconxtye juu tonnon Jesús, tcan juu na cja jon vaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ee mꞌaan jnda jon yuscu na ninncüii tsꞌonhin na tuihin, jndë nchoꞌve chuuꞌ juu, majoꞌ jndë vaveꞌ juu. Ndoꞌ viochen xjen na ñjon Jesús nato na vja jon vaaꞌ Jairoꞌñeen, sꞌaahanꞌ na tyen jndyi vja jon ngꞌe na jndye jndyi nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ndoꞌ quiiꞌ ntꞌan nanꞌñeen mꞌaan ncüii tsanscu na jndë nchoꞌve chu viiꞌ juu na cocꞌa neoonꞌ juu. Ndoꞌ jndë ntycüii xoquituꞌ ꞌnaanꞌ juu na contꞌa ndoto nasihin, majoꞌ minꞌncüiihan tajndëë jnanꞌnꞌmanhanhin. ");
INSERT INTO azgNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tatsindyooꞌhin toxenꞌ Jesús, joꞌ tꞌuii juu ꞌndyo ndiaatco na cüe jon. Ndoꞌ ninñoonꞌ tacüentyjeeꞌ na cocꞌa neoonꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ndoꞌ na tui na nndaꞌ, joꞌ taxeeꞌ Jesús, tso jon: —¿Nin juu tꞌuii ja? Tsoñꞌen nanꞌñeen jnduehan na tyíꞌquindiohan. Ndoꞌ joꞌ tso Pedro: —Nndaꞌ ta, jndye jndyi nnꞌan jndë condiquintoꞌ ngiaꞌ ata nchjehanꞌ ꞌuꞌ contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Majoꞌ tꞌa Jesús, tso jon: —Mꞌaan nin tsꞌan na viiꞌ na tꞌuii ja. Ee nchji ya na jndë tijntꞌue najndei na condui ja na jnꞌman tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ndoꞌ juu tsanscuꞌñeen, vi na jndë taaꞌ tsꞌon juu na ntyjii Jesús nchu vaa na sꞌaa juu, sindyooꞌcyahin nnon jon na coviquijntyꞌehin. Tcoꞌxtye juu na tonnon jon. Ndoꞌ tondëë tsoñꞌen nnꞌan, tjiꞌ jndyoyu juu nin ngꞌeꞌñeen na tꞌuii juu ndiaaꞌ jon, ndoꞌ ntyja na ninñoonꞌ na jnꞌman juu. ");
INSERT INTO azgNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ndoꞌ tso Jesús nnon juu: —ꞌUꞌ jnda, ngꞌe na mavantyja tsonꞌ ja, joꞌ na jndë jnꞌmanꞌ. Nanein cjaꞌ ntcüeꞌ vaꞌ na minꞌncüii tajñuaanꞌ tsꞌon ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ninvaa na itsinin Jesús ndoꞌ tyjeeꞌnon ncüii tsꞌan na jnan vaaꞌ juu Jairoꞌñeen, juu tsan na conintque vatsꞌon. Itso tsanꞌñeen nnon jon: —Jndë tueꞌ yuscuchjo jndaꞌ. Tavintsichjuntyiꞌchenꞌ tahaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Majoꞌ jndyii Jesús na nndaꞌ tso tsanꞌñeen. Joꞌ tso jon nnon Jairo: —Tyiꞌntyꞌueꞌ, xiaꞌntyi cantyja tsonꞌ ja, ya joꞌ ntjo ya ntcüeꞌ yuscuchjo jndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ndoꞌ vi na jndë tueeꞌ jon vaaꞌ Jairoꞌñeen, xiaꞌntyi nquii jon taqueeꞌ joꞌ yo Pedro yo Santiago yo ninꞌJuan, maninꞌ yo nnꞌan na nda yuscuchjoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Majoꞌ tsoñꞌen nnꞌan na mꞌan juu vꞌaaꞌñeen jndei conanꞌxuaahan, cotyueehan ntyja ꞌnaanꞌ juu tsꞌoochjoꞌñeen. Ndoꞌ tso Jesús ndëëhan: —Quitsacüentyjeeꞌhoꞌ na cotyueehoꞌ ee chito jndë tueꞌ juu, veꞌ itso juu. ");
INSERT INTO azgNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Majoꞌ joohan veꞌ toncohan Jesús ngꞌe ngio yahan na jndë tueꞌ juu yuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ndoꞌ tꞌuii jon ntꞌö juu, jndei sinin jon, tso jon: —ꞌUꞌ nian, quinanquintyjaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Maquintyjachen tandoꞌ nndaꞌ juu ndoꞌ ninñoonꞌ jnanquintyja juu. Ndoꞌ juu Jairo yo scuuꞌ jon, tꞌua Jesús tsꞌian ndëëhan na ncyahan ꞌnan na ntcüaꞌ yuscuchjoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ndoꞌ joo nanꞌñeen, teveeꞌ jndyi ngiohan na vandoꞌ nndaꞌ ndahan, majoꞌ tquen Jesús jñꞌoon ndëëhan na minꞌncüii nnon tsꞌan tyiꞌnduehan nchu vaa ꞌnan na sꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jndë na sincüi Jesús nnꞌan na nchoꞌve, juu najndei na condui jon, tyincyaa jon na quinanꞌxuanhinhanꞌ chaꞌ ndëë ntjiꞌhan ncüii cüii nnon yotyia, ndoꞌ na nndëë nnanꞌnꞌmanhan nnꞌan na conanꞌxuan ntycu. ");
INSERT INTO azgNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Tꞌua jon tsꞌian ndëëhan na cꞌoncyahan jñꞌoon ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan ndoꞌ na nnanꞌnꞌmanhan nnꞌan vꞌi. ");
INSERT INTO azgNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tso jon ndëëhan: —Minꞌncüii ꞌnan tyiꞌntsayꞌonhoꞌ na ncꞌohoꞌ nato, min tsꞌoon na ntyjahoꞌ na ncꞌohoꞌ, min tjanche na ngocue sꞌon, min ꞌnan na ntcüaꞌhoꞌ, min xoquituꞌ, min ve ntjo ndiaa tyiꞌntsayꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ndoꞌ minꞌcya ro vaaꞌ tsꞌan na ntsquehoꞌ, quintjohoꞌ joꞌ ata xjen na nnduiꞌ ntcüeꞌhoꞌ juu tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ndoꞌ minninchen tsjoon na tyiꞌninꞌcyꞌon nnꞌan cüenta ꞌoꞌ, juu xjen na conduiꞌhoꞌ joꞌ, quinanꞌcyaahoꞌ tsꞌojndë na chuuꞌ ngꞌehoꞌ. Ndöꞌ vaa quintꞌahoꞌ chaꞌ cüjiꞌ jndyoyuhanꞌ nacjo nanꞌñeen na tatyꞌonhan cüenta jñꞌoonꞌ nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ndoꞌ nque nnꞌan nchoꞌveꞌñeen jnduiꞌhan, tyꞌehan tsochen njoon quijndë, toninncyahan jñꞌoon naya ndoꞌ tonanꞌnꞌmanhan nnꞌan vꞌi na mꞌanhan ncüii cüii joo. ");
INSERT INTO azgNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Juu Herodes, tsan na tocoꞌxen ndyuaa Galilea, jndyii jon jñꞌoon ntyja ꞌnaanꞌ tsoñꞌen ꞌnan na totsꞌaa Jesús. Tꞌman totsiquijñꞌeenhanꞌhin ee minndyechen nnꞌan tonduehan na jndë vandoꞌ nndaꞌ Juan na tueꞌ juu, ngꞌe joꞌ na itsꞌaa Jesús joo tsꞌianminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ndoꞌ minndyechen nnꞌan tonduehan na nquii Elías jndë tityincyooꞌ nndaꞌhin. Ndoꞌ mañoon vendyehan tonduehan na jndë vandoꞌ nndaꞌ ncüii nque nanꞌñeen na toninncya jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nnguaa. ");
INSERT INTO azgNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Majoꞌ itso Herodes: —Nquii Juan jndë tueꞌ jon, ee ncö tꞌua tsꞌian na jnan xquen tsanꞌñeen. Nquii tsanvaꞌ, ¿Nin tsꞌan conduihin na tijndye jñꞌoon na mandyi ntyja ꞌnaanꞌ juu? Ngꞌe na nndaꞌ, tojooꞌ tsꞌon Herodes na nndyiaaꞌ jon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nnꞌan na nchoꞌve na tꞌua Jesús tsꞌian ndëëhan, vi jndë na sque ntcüeꞌhan, jnanꞌquindyiihan jon tsoñꞌen ꞌnan na jndë tontꞌahan. Ya joꞌ tachu jonhan ndoꞌ tyꞌehan na ninnquehan ncüii joo ndyooꞌ tsjoon Betsaida. ");
INSERT INTO azgNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Majoꞌ nque nnꞌan na jndye jndyiꞌhin, vi na jndë taaꞌ nꞌonhan na nndaꞌ, tentyjahan toxenꞌ jon. Tyꞌoon jon cüenta nanꞌñeen ndoꞌ totsinin jon ndëëhan ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. Ndoꞌ sinꞌman jon ntyjehan nanvꞌi. ");
INSERT INTO azgNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Xjen na vaman, nque nnꞌan na nchoꞌveꞌñeen, tentyjaaꞌhin nnon jon. Jnduehan: —Quijñonꞌ nanminꞌ na quinduiꞌ ntcüeꞌhan na ncꞌohan njoon quijndë yo rancho ꞌnaan nnꞌan na mꞌan xiꞌjndio na quijntꞌuehan yuu ya na ntsquehan ndoꞌ na nnanꞌjndahan ꞌnan na ntcüaꞌhan, ngꞌe ntjoohin naijon na mꞌan nein, veꞌ quiiꞌ jndëëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Majoꞌ tꞌa jon, tso jon ndëëhan: —ꞌOꞌ ncyahoꞌ ꞌnan ntcüaꞌhan. Tꞌa nanꞌñeen, jnduehan nnon jon: —Aa já xiaꞌntyi ninꞌon tanꞌ tyooꞌ na yꞌö́n yo ve quitscaa. Majoꞌ ¿Yuu xjenꞌñeenꞌ na nninnonhanꞌ? Taquintyja xe na aa ntsananꞌjndá ꞌnan na ntcüaꞌ tsoñꞌenhan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Joo nannonꞌñeen itsꞌaahanꞌ chaꞌna ꞌon minhan. Majoꞌ itso Jesús ndëë joo nchoꞌve nnꞌan na totsayꞌonhan jñꞌoon yohin: —Quintꞌahoꞌ na cüendyuaa nanminꞌ na vennꞌan vennꞌan nchoꞌnquihan na ncüii cüii tmaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ndoꞌ jntꞌahan na nndaꞌ, ndoꞌ tyecüendyuaa tsoñꞌen nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jndë joꞌ tyꞌoon Jesús cüenta joo ꞌon tanꞌ tyooꞌ yo ve quitscaaꞌñeen. Jnonndë jon quiñoonꞌndue, tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ. Jndë joꞌ tyjee jon xjen ntanꞌhanꞌ, tyincyaa jonhanꞌ ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon na ncyahinhanꞌ ndëë nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ndoꞌ tsoñꞌen nanꞌñeen tcüaꞌ tacjohan, ata jntyꞌichenhanꞌ ꞌnan na tcüaꞌhan. Ndoꞌ nque nnꞌan na tonanꞌjonhan yo Jesús, jnanꞌquitooꞌhan nchoꞌve ntque yo ntanꞌ na jntyꞌihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ncüii jon xjen na mꞌaan Jesús ncüii joo na ninnquii jon na itsinin jon nnon Tyoꞌtsꞌon, juu xjenꞌñeen nque nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, squenonhan na mꞌaan jon. Taxeeꞌ jon ndëëhan, itso jon: —¿Nin juu condue nnꞌan na condui ja? ");
INSERT INTO azgNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Tꞌahan ꞌndyo jon, jnduehan: —Mꞌan nnꞌan na conduehan na ꞌuꞌ Juan, tsan na totsiquindëëꞌ nnꞌan. Ndoꞌ vendyechen nnꞌan conduehan na ꞌuꞌ Elías. Ndoꞌ mantyi mꞌan nnꞌan na conduehan na ꞌuꞌ ncüii nque nnꞌan na ndyu na toxenꞌchen toninncyaa juu jñꞌoonꞌ Tyoꞌtsꞌon, na jndë vandoꞌ nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ya joꞌ taxeeꞌ Jesús ndëëhan, itso jon: —Ndoꞌ ꞌoꞌ jeꞌ, ¿Nin juu conduehoꞌ na condui ja? Tꞌa Pedro, itso jon: —ꞌUꞌ condui nquii Mesías na sijndaꞌ Tyoꞌtsꞌon na jndyoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ndoꞌ jaaꞌ jñꞌoon sinin jon ndëëhan na minꞌncüii nnon tsꞌan tyiꞌnduehan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ndoꞌ mantyi tsontyichen jon ndëëhan: —Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, mancüiixjen tsixuan na ngenön jndye nnon naviꞌ. Ee nnꞌan na conintque ndëë ntyjëëhë nnꞌan judíos, yo ntyee na conintque ndëëhan, yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, ncꞌonhan na tyiꞌcueeꞌ nꞌonhan ja. Majndaꞌ na nnanꞌcueeꞌhan ja. Majoꞌ juu xuee na jndë ndye na tꞌiö, ngüantꞌö xcö. ");
INSERT INTO azgNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ndoꞌ tsoñꞌen nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, tso jon ndëëhan: —Minꞌninchen tsꞌan na ninꞌquitsixuan juu ntyja njan, icanhanꞌ na cüjihin ntyja na itsitiu nquii juu, min xe na aa ntscueeꞌhanꞌhin chaꞌxjen na ntscueeꞌhanꞌ ja. Ndoꞌ mantyi quindyotsijonhin ntyja na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ee minninchen tsꞌan na incyaahin na quitjon juu minꞌcya nnon ꞌnan na ngenon juu ngꞌe na mꞌaan juu ntyja njan, ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ tsanꞌñeen. Majoꞌ minninchen tsꞌan na intꞌue nquii nchu vaa ntsꞌaa chaꞌ ntjo yahin tonnon jon, maveꞌ jnaanꞌ joꞌ ngitsu ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mangꞌe na nndaꞌ, ¿Yuu vaa na itejndeihanꞌ tsꞌan min xe na aa ninvaa tsonnangue cuaahanꞌ ꞌnaanꞌ juu ee xe na aa nndaꞌ na ntyja tsꞌon juu, itsityuiiꞌ nquiihin, oo itsiquitsu nquiihin? ");
INSERT INTO azgNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ndoꞌ minninchen tsꞌan na mꞌaan na jnaanꞌ juu ntyja njan ja, yo ntyja ꞌnaanꞌ jñꞌoon naya njan, ja na condui tsꞌan na jnan quiñoonꞌndue, ncꞌön na ngüejnꞌan ntyja ꞌnaanꞌ tsanꞌñeen. Ntsꞌaahanꞌ na nndaꞌ juu xjen na nndyö nntꞌa na ntcoꞌxën tsoñꞌen yo na conditꞌmaanꞌ ja, ndoꞌ yo na conditꞌmaanꞌ nquii Tyëhöꞌ yo ángeles na jiꞌua conduihan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, ñꞌen minndyehoꞌ na mꞌanhoꞌ ntjoohin xeꞌcüje tyuaaꞌhoꞌ ata njntyꞌia jndyeehoꞌ juu na ityeꞌntjon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Tëca chaꞌ nen xuee na sinin Jesús jñꞌoonminꞌ, ndoꞌ tayꞌoon jon Pedro yo Santiago yo ninꞌJuan, tëva jon ncüii tyoꞌ yohan na ntsinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndoꞌ viochen xjen na itsinin jon nnon Tyoꞌtsꞌon, ncüiichen nnon siñoonhanꞌ nnon jon, ndoꞌ sꞌaahanꞌ na quichiꞌtyen ndiaaꞌ jon chaꞌvijon condui nduiꞌ chon tsuee. ");
INSERT INTO azgNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ndoꞌ quitquenhoꞌ cüenta, tityincyooꞌ ve nannon na conanꞌneinhan yo jon, nquii Moisés yo Elías. ");
INSERT INTO azgNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Joohan sixueehanꞌ xiꞌjndio na ninvaahan, ndoꞌ jnanꞌneinhan yo jon ntyja ꞌnaanꞌ naviꞌ na ngenon jon na ngueꞌ jon Jerusalén chaꞌxjen na jndë sijndaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ndoꞌ Pedro yo nnꞌan na tomꞌan yohin, jaaꞌ jndyi nchje tsantsjonhan, majoꞌ xjen na tjiꞌhan tsantsjon ndëëhin, jntyꞌiahan na quixuee na tsixuan Jesús ndoꞌ mantyi jntyꞌiahan ve nannonꞌñeen na mꞌanhan ngiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Juu xjen na jnduiꞌ ntcüeꞌ nanꞌñeen na mꞌaan Jesús, itso Pedro nnon jon: —Nndaꞌ ta, ya jndyi vaa na mꞌan ntjoohin, cüa, nnanꞌyá ndye xqueꞌncüanꞌ, cüiihanꞌ cüentaꞌ, ncüiichen cüentaaꞌ nquii Moisés ndoꞌ ncüiichenhanꞌ cüentaaꞌ juu Elías. Nndaꞌ tso jon ngꞌe veꞌ sininto jon, taꞌnan sitiu jon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ninvaa na tsinin jon jñꞌoonminꞌ, ndoꞌ jndyocue ncüii chincyu na iscuꞌhanꞌhin. Mioon jndyi tyuehan xjen na tyioo chincyuꞌñeen xiꞌjndiohan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ndoꞌ quityquiiꞌ juu chincyuꞌñeen jeꞌ, ticꞌuaa jndyeeꞌ nquii Tyoꞌtsꞌon, itso jon: —Ndöhin jnda na venchji jndyihin. Quindyehoꞌ jñꞌoon na itsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jndë na ticꞌuaa jndyeeꞌ Tyoꞌtsꞌon, xjen na jntyꞌia nndaꞌhan, ninnquii Jesús vi mꞌaan. Ndoꞌ juu xjenꞌñeen minꞌncuii nnon tsꞌan taꞌnan jnduehan ntyja ꞌnaanꞌ juu nanꞌñeen na jntyꞌia ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ndoꞌ tonco ncüiichen xuee ya na jndë jndyocue ntcüeꞌhan juu tyoꞌñeen, tëquitjon ncüii tmaanꞌ nnꞌan na jndye jndyi joohan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Quiiꞌ juu tmaanꞌñeen, sixuaa ncüii tsꞌan, tso juu: —Nndaꞌ ta, quitsaꞌ vi nayaꞌñeen na quindyiaꞌ chjo nin ꞌnan iquenon yusꞌa chjo jnda, majuuñꞌen juu na tuihin. ");
INSERT INTO azgNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Ndoꞌ ncüii yutyia na nayꞌoonhin, ndoꞌ xjen na itsijaaꞌhanꞌ cjooꞌ juu, itsꞌaahanꞌ na jndei itsixuaa juu. Coquenhin ndoꞌ conduiꞌ chonꞌ ꞌndyo juu. Yo ncꞌua jndyi iꞌndyiihanꞌhin ndoꞌ itsintycüiihanꞌ najndei juu. ");
INSERT INTO azgNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ndoꞌ nque nnꞌan na cotsayꞌon jñꞌoon yo ꞌuꞌ, jndë sꞌaa tyꞌoohan na quitjiꞌhan juu yutyiavaꞌ, majoꞌ tajndëë ntꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tꞌa Jesús, tso jon ndëë nnꞌan na totsayꞌonhan jñꞌoon yo jon: —ꞌOꞌ nnꞌan na tyiꞌcantyja nꞌonhoꞌ min tyiꞌxoncüe na conanꞌtiuhoꞌ. ¿Tsaꞌnndaꞌ xjen vio na jndë jömꞌan yo ꞌoꞌ na matsiquii tsꞌön ꞌnan na contꞌahoꞌ? Ndoꞌ tso jon nnon tye lu chjoꞌñeen: —Quindyoyonꞌ lu jndaꞌhöꞌ ndöhin. ");
INSERT INTO azgNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ndoꞌ juu xjen na ndyotsindyooꞌhin, isquioo yutyiaꞌñeenhin, ndoꞌ jndei coquenhin, majoꞌ sityiaꞌ Jesús juu yutyiaꞌñeen. Sinꞌman jonhin ndoꞌ tyincyaa jonhin ntꞌö tye juu. ");
INSERT INTO azgNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ndoꞌ tsoñꞌen nnꞌan na jntyꞌia na nndaꞌ, vacue tꞌoon nꞌonhan ntyja ꞌnaanꞌ na tꞌman najndei na condui nquii Tyoꞌtsꞌon. Ndoꞌ viochen xjen na tsoñꞌen nnꞌan tovaveeꞌ ngiohan ntyja ꞌnaanꞌ ꞌnan na totsꞌaa jon, sinin jon ndëë joo nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon, tso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Ya ya quitquenhoꞌ cüenta jñꞌoon na matsjö ndëëhoꞌ. Ja na condui tsansꞌa na tꞌua Tyoꞌtsꞌon tsꞌian nnön na cöꞌxën tsoñꞌen nnꞌan, nninncyaa tsꞌan cüenta ja nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Majoꞌ tataaꞌ nꞌonhan nchu vaa itsiquindyi jñꞌoonvaꞌ ngꞌe iscuꞌ Tyoꞌtsꞌon na ncüaaꞌ nꞌonhinhanꞌ. Ndoꞌ mantyi ncyaahan na ntaꞌxeeꞌntyichenhan nnon jon nchu vaa itsiquindyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Xjenꞌñeen joo nnꞌan na nchoꞌve, tonanꞌjndyehan jndyuehan nin ncüii nquehan njonntyichen nduiꞌ quiiꞌ ntꞌan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ngꞌe na nchjii Jesús na nndaꞌ vaa na tondyiiꞌ nꞌonhan, joꞌ tyꞌoon jon ncüii yuchjo, sꞌaa jon na cüentyjeeꞌ juu na tongiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jndë joꞌ tso jon ndëëhan: —Yuchjova, min na chjohin ngiohoꞌ, majoꞌ chuhanꞌ na cüineinhoꞌhin, ngꞌe na conanꞌtꞌmaanꞌhoꞌ ja. Ee xe na aa njon ncüii yuchjo ngiohoꞌ chaꞌna juu, ya joꞌ itsiꞌmanhanꞌ na ja neinhoꞌ. Ndoꞌ xe neinhoꞌ ja, ya joꞌ mantyi neinhoꞌ nquii Tyoꞌtsꞌon na tꞌua jon tsꞌian nnön na jndyö. Minninchen ncüii ꞌoꞌ na ijuꞌcjehin quiiꞌ ntꞌanhoꞌ, ndoꞌ min tyiꞌquitsijñꞌoonꞌ juu na ntsiquinjon nquiihin, juu tsanꞌñeen tꞌman conduihin naijon na icoꞌxen Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ndoꞌ tꞌa Juan, tso jon nnon Jesús: —Nndaꞌ ta, jntyꞌiá ncüii tsꞌan na yo xueꞌ icüjiꞌ juu yotyia quiiꞌ nꞌon nnꞌan. Ndoꞌ jnduë́ nnon juu na tavintsꞌaa juu na nndaꞌ ngꞌe tyiꞌcayꞌoon juu jñꞌoon yo jaa. ");
INSERT INTO azgNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Majoꞌ tso Jesús nnon tsanꞌñeen: —Tyiꞌnduehoꞌ na tantsꞌaa juu na nndaꞌ, ngꞌe tsꞌan na tyiꞌtsuehin nacjoꞌ, itsijonhin ntyja ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Ya na jndë tindyo na ngüentyja xjen na ngava ntcüeꞌ Jesús quiñoonꞌndue, ya joꞌ ninncüii ntyjii jon na vja jon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Joꞌ jñon jndyee jon vendye nnꞌan na cꞌohan ncüii tsjoon chjo na mꞌan nnꞌan Samaritanos na nnanꞌjndaꞌhan na ngueeꞌ jon tsjoonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Majoꞌ joo nnꞌan tsjoonꞌñeen tyiꞌquintꞌue nꞌonhan na ntjo jon joꞌ ngꞌe taaꞌ nꞌonhan na vja jon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Majoꞌ juu Santiago yo ninꞌJuan na conanꞌjon yo jñꞌoon na toninncyaa jon, ya na jntyꞌiahan na nndaꞌ jntꞌa nnꞌan samaritanosꞌñeen, jnduehan: —Nndaꞌ ta, ¿Aa ngüangueꞌ na nntꞌá chaꞌna sꞌaa nquii Elías? ¿Na ngitán chon na nnanhanꞌ quiñoonꞌndue na quioohanꞌ cjo nanminꞌ na ntscohanꞌhin? ");
INSERT INTO azgNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Majoꞌ tequen Jesús, tꞌman jon ndëëhan, tso jon ndëëhan: —ꞌOꞌ min ndicüaaꞌ nꞌonhoꞌ nin ncüii nnon na nanꞌxuanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, chito jndyö na ncüjiꞌ na cotandoꞌ nnꞌan. Ja jndyö na ntsinꞌman ñuaanhin. Ya joꞌ tyꞌentyichenhan na ntsquehan ncüiichen tsjoon chjo. ");
INSERT INTO azgNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Viochen xjen na coꞌohan nato, tso ncüii tsꞌan nnon Jesús: —Ta, ncjö yo ꞌuꞌ, minyuuchen na vjaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ndoꞌ tꞌa Jesús ꞌndyo juu, itso jon: —Ndyondye min ndueꞌ na cotoꞌ oꞌ, ndoꞌ quintsahinꞌ min ntycyaa oꞌ, majoꞌ ja na condui tsꞌan na jnan quiñoonꞌndue, min yuu na ngüajndyëë, tyiꞌjndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndoꞌ tso Jesús nnon ncüiichen tsꞌan: —Quindyotsijon ꞌuꞌ yo jñꞌoon na mancya. Majoꞌ tꞌa tsanꞌñeen ꞌndyo jon, tso juu: —Nndaꞌ ta, ncyaꞌ chjo jñꞌoon na ndixꞌëntyëchën tyëhöꞌ, ndoꞌ ya na jndë tyꞌiu jahin, ya joꞌ yuuꞌ jeꞌ, ntsijon ja yo jñꞌoon na mancyaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Majoꞌ sintcüeꞌ Jesús jñꞌoon nnon juu, tso jon: —Mꞌaan nnꞌan na itsijonhanꞌhin chaꞌvijon ntꞌoohan. Quityꞌiu nquehan ntyjehan. Majoꞌ ꞌuꞌ cjaꞌ ncyaꞌ jñꞌoon ndëë nnꞌan na quitaꞌngueeꞌhan na ntyeꞌntjon Tyoꞌtsꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ndoꞌ tso ncüiichen tsꞌan nnon jon: —Ta, ntsijon ja yo jñꞌoon na mancyaꞌ ndoꞌ yo tsꞌian na matsaꞌ, majoꞌ ncyaꞌ chjo jñꞌoon na jöcüan jndyëë nnꞌan vꞌa, jndë joꞌ yuuꞌ ncjö yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tꞌa Jesús ꞌndyo juu, itso jon: —Minninchen tsꞌan na itaꞌ juu na vjatsijonhin ntyja njan ndoꞌ ninnquiiꞌchen ñjon tsꞌon juu naijon na jndë jntyꞌii juu, itsijonhanꞌ tsanꞌñeen chaꞌvijon tsꞌan na itꞌuii larao na itsitiuu juu tyuaa, ndoꞌ ninnquiiꞌchen vequen juu toxenꞌ juu. Jeꞌcüijntꞌuehin quityquiiꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jndë na tenon nanꞌminꞌ, tjintyichen Jesús ncüiichen vi ndyennꞌan nchoꞌnqui vantjoꞌ ve nnꞌan. Ndoꞌ tꞌua jon tsꞌian ndëëhan na ve vehan ncꞌo jndyeehan ncüii cüii tsjoon yo ncüii cüii joo naijon na ndëcya ncja nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Vitjachen na nnduiꞌ nanꞌñeen na tyꞌehan, itso jon ndëëhan: —Jndye nnꞌan mꞌan na tacondyehan jñꞌoon naya. Itsijonhanꞌhin chaꞌvijon ntjon na jndë tman. Majoꞌ nnꞌan na cotantjon na ntyjehan juuhanꞌ, minꞌchjo tyiꞌjndyehan. Veꞌ ngꞌe joꞌ, quitanhoꞌ nnon Tyoꞌtsꞌon na nquii jon ꞌnaanꞌ jon joo ntjonꞌñeen, na quijñonntyichen jon nnꞌan na cotantjon na ntejndeihinhoꞌ na ntjiꞌ jndyoyuhoꞌ jñꞌoon naya njan ndëë nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ndoꞌ tsontyichen jon ndëëhan: Cüa, cꞌohoꞌ naijon na jndë tsjö ndëëhoꞌ. Quitquenhoꞌ cüenta, ꞌoꞌ na conduihoꞌ na ya nnꞌanhoꞌ, maꞌua tsꞌian ndëëhoꞌ na ncꞌonhoꞌ quiiꞌ ntꞌan nnꞌan natyia nnꞌanhan. Itsijonhanꞌ ntyja ꞌnaanhoꞌ chaꞌvijon na mꞌan quinman quiiꞌ ntꞌan lobo. ");
INSERT INTO azgNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tyiꞌntsayꞌonhoꞌ che na ñjon xoquituꞌ, min chetsjaꞌ, min ntcoon. Ndoꞌ chito jndye jndyi jñꞌoon na nnanꞌneinhoꞌ yo nnꞌan na ntjonhoꞌ nato. ");
INSERT INTO azgNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ndoꞌ minninchen vꞌaa naijon na ntsquehoꞌ, ncya jndyeehoꞌ tsꞌon joo nnꞌan mꞌan juu vꞌaaꞌñeen. Quinduehoꞌ ndëëhan: “ꞌOꞌ ntyjë na mꞌanhoꞌ vꞌaavahin, ncya Tyoꞌtsꞌon na tajñꞌman tsꞌonhoꞌ na tonnon jon.” ");
INSERT INTO azgNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ndoꞌ joo nnꞌan na mꞌan joꞌ, xe nanꞌxuanhan na ncyꞌonhan cüenta juu naya na tajñꞌman tsꞌonhin, ya joꞌ nndui chaꞌxjen na cotanhoꞌ. Majoꞌ xe na aa tyiꞌquinanꞌxuanhan na ncyꞌonhan cüenta juu nayꞌñeen, tyiꞌxeꞌquintjohanꞌ yohan. ");
INSERT INTO azgNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ndoꞌ minninchen vꞌaa na ntsquehoꞌ, joꞌ quintjohoꞌ. Ndoꞌ minꞌcya ro ꞌnan na nninncyahan na ntcüaꞌhoꞌ, joꞌ cüaꞌhoꞌ ndoꞌ cüehoꞌhanꞌ. Ee chuhanꞌ na nndahoꞌ ꞌnan na icanhanꞌ ꞌoꞌ ntyja ꞌnaanꞌ na cotyentjonhoꞌ nnon Tyoꞌtsꞌon, chaꞌxjen juu tsan na ivantjon tsixuan juu na ncyꞌoon juu cüenta ꞌnan na ivantjon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Minꞌcya ro tsjoon na ntsquehoꞌ ndoꞌ ncyꞌon nanꞌñeen cüentahoꞌ, cüaꞌhoꞌ minninchen ꞌnan na nnincyahan ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ndoꞌ quinanꞌnꞌmanhoꞌ nnꞌanvꞌi na mꞌan joꞌ ndoꞌ quinduehoꞌ ndëë nnꞌan tsjoonꞌñeen: ꞌOꞌ ntyjë, jndë tentyja xjen na nninncyahoꞌ na ntcoꞌxen Tyoꞌtsꞌon ꞌoꞌ nchu vaa na cotsamꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Majoꞌ xe na aa ntsquehoꞌ ncüii tsjoon ndoꞌ min tyiꞌcyꞌon nanꞌñeen cüentahoꞌ, quinduiꞌ ntcüeꞌhoꞌ nata tsjoonhan na quitjiꞌ jndyoyuhoꞌ nacjohan. ");
INSERT INTO azgNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","Quinduehoꞌ ndëë nanꞌñeen: Juu tsꞌojndë tsjoonhoꞌ na chuuꞌ ngꞌë́, conanꞌcyáhanꞌ. Contꞌá na nndaꞌ chaꞌ cüaaꞌ nꞌonhoꞌ na tyiꞌninꞌcyꞌonhoꞌ cüenta juu jñꞌoonꞌ Tyoꞌtsꞌon. Majoꞌ quitquenhoꞌ cüenta na jndë tentyja xjen na ninncyahoꞌ na ntcoꞌxen jon ꞌoꞌ ntyja na cotsamꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, ya na ngüentyja xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan nchu vaa na jndë jnanꞌtjahan nnon jon, viꞌntyichen ntquenon nnꞌan na tyiꞌcyꞌonhan cüenta ꞌoꞌ, chintyi juu naviꞌ na tquenon joo nnꞌan tsjoon Sodoma. ");
INSERT INTO azgNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“ꞌOꞌ nnꞌan tsjoon Corazín, viꞌ jndyi ntquenonhoꞌ. Mantyi ꞌoꞌ nnꞌan tsjoon Betsaida, viꞌ jndyi ntquenonhoꞌ. Ee nque nnꞌan tsjoon Tiro yo Sidón, xe na aa siꞌman ndëëhan nchu vaa najndei na condui ja chaꞌxjen na jndë siꞌman ndëë nquehoꞌ, ya joꞌ cje ro jndë ntcüeꞌ nꞌonhan jnanhan. Ee joo nanꞌñeen, chaꞌ tsiꞌmanhanꞌ na contcüeꞌ nꞌonhan jnanhan tonnon Tyoꞌtsꞌon, tcüehan ndiaatsjaꞌ ndoꞌ tyiohan tsjaaꞌ nquenhan. ");
INSERT INTO azgNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mangꞌe joꞌ, juu xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ jnanhan, jantyichen ntꞌuiiviꞌhanꞌ ꞌoꞌ, chichen nque nnꞌan Tiro yo Sidónꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ndoꞌ mantyi ꞌoꞌ nnꞌan tsjoon Capernaum, ¿Aa ngꞌe jndye tsꞌian tꞌman na totsꞌa tyquiiꞌ ntꞌanhoꞌ, joꞌ cotjiꞌhoꞌ cüenta na ntsquehoꞌ quiñoonꞌndue? Jñꞌoon na mayuuꞌ, ncjuꞌ Tyoꞌtsꞌon ꞌoꞌ naijon na mꞌan ntꞌoo. Mana ngitsuñꞌen tsjoonhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ndoꞌ itsontyichen jon ndëë nanꞌñeen na tꞌua jon tsꞌian ndëëhan: “Minninchen tsꞌan na indyii jñꞌoon na coninncyahoꞌ, jñꞌoon njan indyii juu, ndoꞌ juu tsꞌan na vennoonꞌ juu jñꞌoon na concyahoꞌ, mantyi ivenoonꞌ tsanꞌñeen ja, ndoꞌ nquii tsꞌan na ivenoonꞌ juu ja, mantyi ivenoonꞌ juu nquii jon na tꞌua tsꞌian nnön na jndyö.” ");
INSERT INTO azgNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Joo ndyennꞌan nchoꞌnqui vantjoꞌ ve nanꞌñeen na tꞌua Jesús tsꞌian ndëëhan, sque ntcüeꞌhan na mꞌaan jon na nein jndyihan. Jnduehan: —Nndaꞌ ta, xjen na cotjíꞌ xueꞌ na cotoxë́n yotyia na quinduiꞌhan quiiꞌ nꞌon nnꞌan, cotaꞌngueeꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Majoꞌ tꞌa jon, tso jon ndëëhan: —Jntyꞌia na jnan Satanás quiñoonꞌndue na tyioohin chaꞌvijon chon tsuee na jndë tyuiiꞌ juu najndei na tsixuan juu. ");
INSERT INTO azgNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Quitquenhoꞌ cüenta, ja jndë tyincya na conanꞌxuanhoꞌ juu najndei na condui ja na cꞌoonhanꞌ yohoꞌ. Matsꞌa na nndaꞌ chaꞌ min na ndyuehoꞌ quindu, min quintjö, majoꞌ minꞌchjo tantjonhoꞌ. Ndoꞌ nnanhoꞌ yo tsoñꞌen najndei na tsixuan juu Satanás na mꞌaan juu nacjohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Majoꞌ min na nndaꞌ, tyiꞌncꞌonhoꞌ na neinhoꞌ veꞌ ntyja na cotjueꞌcje yotyia ndëëhoꞌ. ꞌOꞌ cꞌonhoꞌ na neinhoꞌ ngꞌe quiñoonꞌndue, joꞌ na jndë jndui nguehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Majuu xjenꞌñeen, tyincyaa Espíritu Santo na neiinꞌ tsꞌon Jesús. Tyeꞌ na itsinin jon nnon Tyoꞌtsꞌon, tso jon: —Tyeꞌhë, matsitꞌmanꞌ ja ꞌuꞌ na condui ꞌuꞌ na macoꞌxenꞌ quiñoonꞌndue yo tsonnangue. Ee joo jñꞌoonminꞌ, ꞌuꞌ jndë tyꞌiuꞌhanꞌ ndëë nnꞌan na cotjiꞌ nquehan cüenta na jndaꞌ jndyi nquenhan yo nnꞌan na jen tꞌman covaaꞌ nꞌonhan ngiohan. Majoꞌ nque nnꞌan na ntyꞌiachen, jndë siꞌmanꞌhanꞌ ndëëhan. Ncya ya ꞌuꞌ Tyeꞌ na nndaꞌ vaa na tëveeꞌ nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Sininntyichen Jesús ndëë nnꞌan, tso jon: “Nquii tyëhöꞌ Tyoꞌtsꞌon, tsoñꞌen jndë tyincyaa jon ntꞌö. Ndoꞌ tanin tsꞌan na ivaaꞌ tsꞌon nchu tsixuan na condui ja jnda jon, xiaꞌntyi nquii jon ntyjii. Min tanin tsꞌan na ivaaꞌ tsꞌon nchu vaa condui nquii Tyëhöꞌ, xiaꞌntyi ncö na condui ja jnda jon ntyjihanꞌ, ndoꞌ mantyi minninchen tsꞌan na ntꞌue tsꞌön na ncüaaꞌ tsꞌon nchu vaa na tsixuan jon.” ");
INSERT INTO azgNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Xjen na tomꞌaan Jesús yo nnꞌan na conanꞌjonhan yo jñꞌoon na toninncyaa jon na ninnquehin, tso jon ndëëhan: “Ityio Tyoꞌtsꞌon jnꞌaan ꞌoꞌ na mꞌanhoꞌ yo ja na cojntyꞌia ndëëhoꞌ tsꞌian na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Quindyehoꞌ na matsjö, jndye nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen yo ninꞌnnꞌan na tꞌman tonduihan na totoxenhan, joo nanꞌñeen tontyja jndyi nꞌonhan na ninꞌquijntyꞌia ndëëhan joo ꞌnan na cojntyꞌiahoꞌ naneinhin, ndoꞌ na ninꞌquindye jndyihan joo jñꞌoon na condyehoꞌ, majoꞌ taꞌnan jntyꞌia ndëëhan tsꞌian na matsꞌa min tana jndyehan jñꞌoon na mancya.” ");
INSERT INTO azgNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ya joꞌ ncüii tsꞌan na tsiꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, tyjeeꞌ juu na mꞌaan Jesús. Veꞌ ntꞌue juu nchu vaa ngitso Jesús chaꞌ quityiiꞌhanꞌ ngꞌeehanꞌhin. Taxeeꞌ juu nnon jon: —Nndaꞌ ta, ¿Nin ꞌnan chuhanꞌ na quitsꞌa chaꞌ ntsixuan na tyiꞌquintycüii na vandoꞌ ñuan njan? ");
INSERT INTO azgNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tꞌa Jesús ꞌndyo juu: —Juu jñꞌoon na tquen Moisés, ¿nchu vaa itsiquindyihanꞌ? ¿Nchu vaa na itsiꞌmanhanꞌ ya na matsijnanꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tꞌa tsanꞌñeen, itso jon: —Jñꞌoonꞌñeen, ndö vaa itsiquindyihanꞌ: Cüivenchjiꞌ nquii Tyoꞌtsꞌon na conduihin na icoꞌxen jon ꞌuꞌ yo na xoncüeeꞌ tsonꞌ, ndoꞌ yo ninvaa ñuan ꞌnanꞌ yo ninvaa na condëë matsaꞌ, ndoꞌ yo ninvaa na jndaꞌ xquenꞌ. Ndoꞌ mantyi itsiquindyichenhanꞌ: Cüivenchjiꞌ minninchen tsꞌan chaꞌxjen na viꞌntyjii nquii ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Tso Jesús nnon juu: —Jndyoyu jñꞌoon na tsuꞌ. Jñꞌoonminꞌ quitsiquindëꞌhanꞌ, ya joꞌ ntsixuanꞌ na tyiꞌquintycüii na vandoꞌ ñuan ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Majoꞌ juu tsanꞌñeen, ninꞌcüjiꞌ ya nquiihin, taxeeꞌntyi juu nnon Jesús: —Ndoꞌ ¿Nin juu tsꞌan na icanhanꞌ na cüivenchji jahin chaꞌxjen na viꞌntyjii nquii ja? ");
INSERT INTO azgNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tꞌa Jesús, itso jon: —Tomꞌaan ncüii tsꞌan. Jnan juu Jerusalén na vacue juu tsjoon Jericó, ndoꞌ tjonhin nanntyꞌuee. Tjiꞌ nanꞌñeen ꞌnaanꞌ juu, ndoꞌ jnanꞌqueeꞌhanhin, jntyꞌehanhin na vaveꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ndoꞌ sijonhanꞌ na ncüii tyee ꞌnaan nnꞌan judíos vacue jon juu natoꞌñeen. Majoꞌ ya na ntjii jon juu tsanꞌñeen, veꞌ tancyaa jon ntyeeꞌ, na tanon jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ndoꞌ ncüiichen ncüii tsꞌan na tuihin tsjan Leví, maninꞌ cüajon sꞌaa juu. Xjen na tueeꞌ juu naijon na vaquityen tsanꞌñeen, veꞌ tëncyaa juu ntyeeꞌ na tenon juu joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Majoꞌ ncüii tsꞌan ndyuaa Samaria na mantyi vja juu natoꞌñeen, tatsindyooꞌhin. Ndoꞌ ya na jndyiaaꞌ juu tsanꞌñeen, tyioo na ndyiaꞌ jndyi juu nchjii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tantyjaaꞌcya juu nnon tsanꞌñeen. Sꞌaa juu nasihin, tyio juu nchenꞌ yo vinon nquii naijon na jnanꞌqueeꞌ nanntyꞌueeꞌñeenhin. Jndë joꞌ sityen juu ndiaa joꞌ. Ndë joꞌ juu quiooꞌ na quintyjo juu, tyio juu tsanꞌñeen nacjooꞌ oꞌ. Tayꞌoon juuhin vꞌaa naijon na cotsque ya nnꞌan. Joꞌ tixeeꞌ juuhin. ");
INSERT INTO azgNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ndoꞌ ncüiichen xuee vi jndë mavja juu na tonnonchen, tyincyaa juu ve sꞌon denarios nnon nquii tsꞌan na vaaꞌ vꞌaaꞌñeen. Tso jon nnon tsanꞌñeen: “QuitiXeeꞌ yaꞌ tsanvahin ndoꞌ xe na aa vaa na ntsiquitsuꞌntyiꞌchenꞌ na matixeꞌhin, ya na ncüenön ntcüꞌë, ya joꞌ ndyiönhanꞌ.” Ndöꞌ jñꞌoon sinin Jesús na tyiꞌquitsiꞌman nquiiꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ndoꞌ taxeeꞌ jon nnon juu tsanꞌñeen, tsan na tsiꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés: —Joo ndye nanꞌñeen, ¿Nchu vaa na macüjiꞌ cuenta? ¿Nin ncüii joohan na siꞌman juu na conduihin ntyje juu tsan na tjon natëꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tꞌa tsanꞌñeen, tso juu: —Juu tsan na tꞌoon na ndyiaꞌ ro nchjii juu yo nquii tsan na tjon natëꞌ. Ndoꞌ tso Jesús nnon juu: —Mantyi ꞌuꞌ, cjaꞌ ndoꞌ majuuntyihanꞌ quitsaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Vi jndë sinin Jesús jñꞌoonminꞌ, tjantyichen jon yo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon. Squehan ncüii tsjoon chjo yuu jon na mꞌaan ncüii tsanscu na jndyu Marta. Sintjooꞌ juu jon vaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ndoꞌ mꞌaan tyje juu na jndyu María. Juu tsanscuꞌñeen tovaquityen juu ngiaaꞌ Jesús na indyii juu jñꞌoon na itsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Majoꞌ Marta tavijndei juu yo tsꞌian. Joꞌ tatsindyooꞌhin nnon Jesús, tso juu: —Nndaꞌ ta, ¿Aa mandyiaꞌ na iꞌndyii tyjöhöꞌ ja na ninncö matsijñꞌönꞌ? Quitsuꞌ nnon juu na quitejndei juu ja. ");
INSERT INTO azgNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tꞌa Jesús ꞌndyo juu, tso jon: —ꞌUꞌ ntyjë Marta, ꞌuꞌ jndye jñꞌoontiu mꞌanꞌ na itsiquijñꞌeenhanꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Majoꞌ ninncüii vaa na icanhanꞌ na quitsꞌaa tsꞌan. Juu María jndë tjii juu nayaꞌñeen na njonntyichen tsixuanhanꞌ. Ndoꞌ min tyiꞌxeꞌquityjë naya ꞌnaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ncüii jon tomꞌaan Jesús ncüii joo na itsinin jon nnon Tyoꞌtsꞌon. Ndoꞌ vi na jndë sinin jon, ncuii nque nanꞌñeen na totsayꞌonhan yo jñꞌoon na toninncyaa jon, tso juu nnon jon: —Ta, quitsiꞌmanꞌ ndë́ nchu vaa nnanꞌnë́n nnon Tyoꞌtsꞌon, chaꞌxjen nquii Juan totsiꞌman jon ndëë nnꞌan na totsayꞌon yo jñꞌoon na toninncyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tꞌa Jesús, tso jon ndëëhan: —Xjen na conanꞌneinhoꞌ nnon Tyoꞌtsꞌon, quinduehoꞌ: ꞌUꞌ Tyë́ na mꞌanꞌ quiñoonꞌndue, quitsꞌaahanꞌ na jiꞌua condui xueꞌ. Quitsaꞌ na majndyentyichen nnꞌan ncyahan na ntcoꞌxenꞌhan ntyja na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ncyaꞌ ꞌnan na ntcüꞌá tyiꞌcüii xuee yu. ");
INSERT INTO azgNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ndoꞌ quitsitꞌman tsonꞌ jnan na nanꞌxuán ee mantyi conanꞌtꞌman nꞌö́n tsoñꞌen nnꞌan na conanꞌtjahin ndë́. Ndoꞌ xjen na ninꞌquityiiꞌ yutyia ngꞌee juu já, quitsiquindyaꞌ já na ntꞌuí quityquiiꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mantyi itso Jesús ndëëhan: —Cüa, nduë xe ncüiihoꞌ mꞌaan ncüii tsꞌan na ya jñꞌoon juu yo ꞌuꞌ, ndoꞌ xoncüe tsjon ncjaꞌ na mꞌaan juu na ntsuꞌ nnon juu: “Nndaꞌ ntyjë, quiteꞌjndeiꞌ chjo vi ndye tanꞌ tyooꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ngꞌe ncüii tsꞌan na ya jñꞌoonhin yo ja jndë tyjeeꞌnon juu vꞌa na veꞌ ivenon ya juu. Ndoꞌ ja taꞌnan ꞌnan cuaa na nninncyaa na ntcüaꞌ juu.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Xe na aa nndaꞌ vaa jñꞌoon na ntsuꞌ nnon tsanꞌñeen na mꞌaan juu quiiꞌ vaaꞌ juu, tyiꞌjndyaaꞌ ntsintcüeꞌ juu jñꞌoon nnonꞌ na ngitso juu: “Tyiꞌninꞌquinaquintyja ja, ee jndë iscuꞌtyën ꞌndyo vꞌa. Jndë mava cjooꞌ jndu ndoꞌ jndë conda ntsinda. Joꞌ jeꞌquindëë na ntejndei ꞌnan na macanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ndoꞌ tsontyichen Jesús: —Quindyehoꞌ ntsjö ndëëhoꞌ, min xeꞌquinanquintyja juu na ntejndei juu ꞌuꞌ ngꞌe na ya jñꞌoonhin yo ꞌuꞌ, majoꞌ ngꞌe na tquen ya ꞌuꞌ na macanꞌhanꞌ, joꞌ na nnanquintyja juu na nninncyaa juu tsoñꞌen ꞌnan na icanhanꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ndoꞌ ngꞌe na nndaꞌ vaa, ndö vaa ꞌnan na matsjö ndëëhoꞌ: Quitanhoꞌ nnon Tyoꞌtsꞌon, ndoꞌ nninncyaa jon na ncyꞌonhoꞌ cüentahanꞌ. Yo manchaꞌchen nꞌonhoꞌ quijntꞌuehoꞌ na tonnon jon, ndoꞌ ndijndaꞌhanꞌ. Maveꞌ na quiꞌmanhoꞌ, ya joꞌ nnaan chaꞌvijon ncüii ꞌndyo vꞌaa tondëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ee minninchen tsꞌan na ican juu nnon Tyoꞌtsꞌon, ncyꞌoon juu cüentahanꞌ. Ndoꞌ nin juu na vaa na ntꞌue, minnchuchen nninjndaꞌhanꞌ. Ndoꞌ nin juu na itsicꞌuaa ꞌndyovꞌaa, mancüiixjen nnaanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Nin ncüiihoꞌ na mꞌaan jnda juu ndoꞌ xe na aa ntcan juu quitscaa nnonꞌ na ninjndoꞌ juu, ¿Aa nnincyaꞌ veꞌ quitsu nnon juu? ");
INSERT INTO azgNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oo xe na aa ntcan juu tsiꞌquitsjon nnonꞌ na ntquii juu, ¿Aa nninncyaꞌ veꞌ quitsjö nnon juu? ꞌOꞌ min tyiꞌxeꞌquintꞌahoꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Min na na tyia nnꞌan conduihoꞌ, majoꞌ covaaꞌ ya nꞌonhoꞌ na nninncyahoꞌ ꞌnan na ya ndëë ndahoꞌ. Majndeichen nquii Tyehoꞌ na mꞌaan jon quiñoonꞌndue, nninncyaa jon Espíritu Santo quiiꞌ nꞌonhoꞌ xjen na cotanhoꞌ nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ncüii jon tjiꞌ Jesús ncüii yutyia quiiꞌ tsꞌon tsꞌan na ndiquitsinin. Ndoꞌ vi na jndë jnduiꞌ juu yutyiaꞌñeen, tcoꞌ ya nndaꞌhanꞌ tsanꞌñeen, ya sinin juu. Ndoꞌ joo nnꞌan na jndye jndyiꞌhin, tëveeꞌ jndyi ngiohan na nndaꞌ vaa ꞌnan na sꞌaa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Majoꞌ vendyehan jnduehan: “Tsanvaꞌ, veꞌ yo ntyja ꞌnaanꞌ juu najndei na tsixuan Beelzebú, nquii yutyia tque, joꞌ na condëë icüjiꞌ juu yotyia quiiꞌ nꞌon nnꞌan.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Majoꞌ ñꞌen minndyechen nanꞌñeen na jnanꞌjndaꞌhan ncüii jñꞌoon na ntyja ꞌnaanꞌhanꞌ ntyja nꞌonhan na ntsitjahin. Tanhan na quitsꞌaa jon ncüii jnꞌaan chaꞌ quitsiꞌmanhanꞌ na nquii Tyoꞌtsꞌon incyaa najndei na condui jon. ");
INSERT INTO azgNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Majoꞌ ntyjii Jesús nchu vaa na ndyiiꞌ nꞌonhan, joꞌ tso jon ndëëhan: “Xe mꞌaan ncüii gobiernon na cotꞌon nnꞌan ndyuaa naijon na icoꞌxen jon, jñꞌoon na mayuuꞌ ndyuiiꞌ ntyja na icoꞌxen jon. Taxeꞌquindëë na ntjontyichenhin. Ndoꞌ majoꞌntyi ntyja ꞌnaan nnꞌan ncüii vꞌaa, xe tyiꞌtjonꞌ conanꞌneinhan yo ntyjehin, conanꞌtyuiiꞌ nquehan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ndoꞌ majoꞌntyi ntyja ꞌnaanꞌ juu Satanás. Xe na aa icꞌon nquii juu ntyje yotyia juu quiiꞌ nꞌon nnꞌan, ya joꞌ ¿Nchu ntsꞌaa juu na ntjontyichenhin ntyja na iquen juu xjen ꞌnaanꞌ juu quiiꞌ nꞌon nnꞌan? Nndaꞌ vaa matsjö ngꞌe conduehoꞌ na ja veꞌ yo ntyja ꞌnaanꞌ najndei na itsixuan juu Beelzebú, joꞌ na macüjiꞌ yotyia quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Majoꞌ xe na aa mayuuꞌ na ntyja ꞌnaanꞌ najndei na tsixuan juu Beelzebú, joꞌ na macüjiꞌ yotyia quiiꞌ nꞌon nnꞌan, ya joꞌ itsiquindyihanꞌ na mantyi nque ntyjehoꞌ cotjiꞌhan yotyiaꞌñeen quiiꞌ nꞌon nnꞌan yo maninjuu naijndei na tsixuan juu. Majoꞌ ngꞌe na tyiꞌyuuꞌ na nndaꞌ vaa ntyja ꞌnaan ntyjehoꞌ, joꞌ ntyja na nndaꞌ contꞌa nquehin icüjiꞌ jndyoyuhanꞌ na cochue nꞌonhoꞌ na cotjiꞌhoꞌ cüenta. ");
INSERT INTO azgNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ngꞌe na macüjiꞌ ja yotyia quiiꞌ nꞌon nnꞌan yo najndei na condui nquii Tyoꞌtsꞌon, joꞌ itsiꞌmanhanꞌ na juu na icoꞌxen jon nnꞌan ntyja na cotsamꞌanhan, jndë tyjeeꞌhanꞌ quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Juu Satanás, itsijonhanꞌhin chaꞌvijon ncüii tsꞌan na vaa najndei, majoꞌ ja condui tsꞌan na tꞌmanntyichen najndei. Mangiohoꞌ ncüii tsꞌan na min ntꞌö tsꞌian tyiaꞌ ꞌnaanꞌ, vaa naijndei na tsixuan juu. Ya jndyi iquen juu cüenta vaaꞌ juu. Taꞌnan ngenon ꞌnaanꞌ juu na min. ");
INSERT INTO azgNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Majoꞌ xjen na aa ncüjeeꞌ ncüiichen tsꞌan na jndeintyichen, chichen nquii juu, ya joꞌ xeꞌquindëë ntsꞌa juu yo tsanꞌñeen. Tsoñꞌen ntꞌö tsꞌian na itsiqui tsꞌon juu, ncüjiꞌ tsanꞌñeenhanꞌ ndoꞌ ꞌnaanꞌ juu nninncyaa jonhanꞌ ndëë nnꞌan na conanꞌjon jñꞌoon yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Nin juu na tyiꞌcꞌoon ntyja njan, mꞌaan tsanꞌñeen nacjö, ndoꞌ nin juu na tyiꞌquitsitjon nnꞌan yo ja, itsintcüeꞌ juu nnꞌan na tyiꞌcantyja nꞌonhan ja. ");
INSERT INTO azgNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Ncüii cüii yutyia, xjen na jndë tjiꞌhanꞌhin quiiꞌ tsꞌon tsꞌan, veꞌ inannonto juu ndyuaa na taꞌnan ndaa, intꞌue juu yuu jon ngüajndyee juu. Ndoꞌ ngꞌe taꞌnan ntjii juu, itso juu: Jö ntcüꞌë quiiꞌ tsꞌon juu tsꞌan naijon na jntꞌui. ");
INSERT INTO azgNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Majoꞌ ya na ngueeꞌ ntcüeꞌ juu joꞌ, ntjii juu quiiꞌ tsꞌon tsanꞌñeen chaꞌvijon ncüii vꞌaa na jndë ta ndoꞌ tijndaꞌ yahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ndoꞌ na nndaꞌ, ncja juu na ndyochu juu mañoon ntyqueꞌ yotyia na viꞌntyichen, chichen juu. Joꞌ ncꞌoqueꞌhanꞌ quityquiiꞌ tsꞌon tsanꞌñeen ndoꞌ ncꞌonhan joꞌ. Ndoꞌ matsꞌiañꞌen jen vaantyichen na ntquenon tsanꞌñeen, chito na toquenon jndyee juu.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Xjen na itsinin Jesús jñꞌoonminꞌ, ncüii tsanscu na mꞌaan quiiꞌ ntꞌan nnꞌan na jndye jndyiꞌhin, sue juu jndyeeꞌ, tso juu nnon Jesús: —Incyaa Tyoꞌtsꞌon na neiinꞌ juu tsꞌan na singui ꞌuꞌ ndo na siquiteiꞌ jon ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Majoꞌ tꞌa Jesús ꞌndyo tsanscuꞌñeen, itso jon: —Juu jñꞌoon na tsuꞌ, min na mayuuꞌhanꞌ, majoꞌ joo nnꞌan na condye jñꞌoonꞌ Tyoꞌtsꞌon ndoꞌ cotaꞌngueeꞌhinhanꞌ, conduihan nnꞌan na neinntyichen. ");
INSERT INTO azgNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ya na jndë tijndye nnꞌan tëncüii xiꞌjndio ngiaaꞌ Jesús, taꞌ jon sinin jon jñꞌoon ntyja ꞌnaanꞌ jon, itso jon: —Nnꞌan na mꞌan neinhin, tyia jndyi nnꞌanhin. Joꞌ na jeꞌncya na njntyꞌiahan jnꞌaan na cotanhan. Xiaꞌntyi juu jnꞌaan na totsixuan Jonás, joꞌ na nninncyaa Tyoꞌtsꞌon na njntyꞌiahan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ee nquii Jonásꞌñeen, totsixuan jon jnꞌaan ndëë nnꞌan tsjoon Nínive ngꞌe xuee na jndë ndye na tio quitscaa tꞌmanhin, joꞌ sinꞌman Tyoꞌtsꞌonhin. Manndaꞌ vaa itsijonhanꞌ ja na condui tsansꞌa na iꞌua jon tsꞌian nnꞌön na coxën tsoñꞌen nnꞌan, ntsixuan ja jnꞌaan ndëë nnꞌan na mꞌan naneinhin. ");
INSERT INTO azgNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nque nnꞌan na mꞌan nanein, ya na ngüentyja xjen na ntcoꞌxen Tyoꞌtsꞌonhan ntyja ꞌnaanꞌ jnanhan, juu tsanscu na tocoxen jon nnꞌan ndyuaa tontyja na conduiꞌ ncjuu tsonjnꞌaan, ntcüi nndaꞌ jon, ndoꞌ mantyi joo nnꞌan na mꞌan nanein na ngovjehan, ntcüi nndaꞌhan juu xjenꞌñeen. Ndoꞌ juu tsanscuꞌñeen nntsꞌaa jon jnan nnꞌan na mꞌan nanein, ee min na tycya jndyi ndyuaa na jnan jon, majoꞌ ninꞌquindyii jon jñꞌoon na sinin Salomón yo na jndaꞌ xquen jon. Ndoꞌ quitquenhoꞌ cüenta, ja na jndë tyjë quiiꞌtyquiiꞌ ntꞌanhoꞌ, tꞌmanntyichen condui ja, chichen nquii Salomón. Majoꞌ min tyiꞌninꞌquindyehoꞌ jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ndoꞌ mantyi juu xjen na ntcoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ jnanhan, nque nnꞌan tsjoon Nínive ntcüi nndaꞌhan. Ndoꞌ nntꞌahan jnan joo nnꞌan na mꞌan nanein. Ee juu xjen na toninncyaa Jonás jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan juu tsjoonꞌñeen, ntcüeꞌ nꞌonhan. Ndoꞌ quitquenhoꞌ cüenta, ja na jndë tyjë quiiꞌ ntꞌanhoꞌ, tꞌmanntyichen condui ja, chichen juu Jonás. Majoꞌ ꞌoꞌ min tyiꞌninꞌquintcüeꞌ nꞌonhoꞌ na condyehoꞌ jñꞌoon na mancya.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ndoꞌ tsochen Jesús: “Jñꞌoon na mancya itsijonhan juuhanꞌ chaꞌvijon lámpara na itsixueehanꞌ chon tyquii vꞌaa. Majoꞌ taꞌnan tsꞌan na ntscüꞌa chon lámpara, ndoꞌ vi jndë joꞌ ntyiiꞌ juuhanꞌ naijon na ntyꞌiuuꞌ oo nacjeeꞌ ncüii istjö. Mancüiixjen ndye ntsintyja tsꞌanhanꞌ chaꞌ ntsixueehanꞌ ndëë nnꞌan na cotsaqueꞌ quiiꞌ vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Juu jñꞌoon na mayuuꞌ conduihanꞌ chaꞌvijon chon lámpara, ee incyaahanꞌ naxuee quiiꞌ tsonꞌ. Xe na aa mavaaꞌ tsonꞌ jñꞌoon na mayuuꞌ, itsijonhanꞌ ꞌuꞌ chaꞌvijon tsꞌan na ya tënnon na quindë ya na tyincyooꞌ juu. Majoꞌ xe na aa tyiꞌninꞌcyonꞌ cüenta jñꞌoon na mayuuꞌ, itsijonhanꞌ ntyja ꞌnanꞌ chaꞌvijon tsꞌan na viꞌ tënnon na ninvaañꞌenhin mꞌaan juu najaan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Joꞌ quenꞌ cüenta jeꞌ na mandyiꞌ jñꞌoon na mayuuꞌ, tyiꞌntsaꞌ na chaꞌvijon na nchjanꞌ na ncꞌoonꞌ tsonꞌ na tayuu jntꞌuehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Xe na aa quityquiiꞌ tsonꞌ jndë tooꞌchen jñꞌoon na mayuuꞌ na tyiꞌcocüji ꞌuꞌ ntyja ꞌnaanꞌhanꞌ, ya joꞌ ninvaa quiiꞌ tsonꞌ ntsꞌaahanꞌ na itsixueehanꞌ chaꞌna itsixuee ncüii chon lámpara ndëë nnꞌan.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Vi na jndë sinin Jesús jñꞌoonminꞌ, ncüii tsꞌan na conduihin ntyja ꞌnaanꞌ tmaanꞌ fariseos, tꞌman juuhin na cja jon vaaꞌ juu, chi ntcüaꞌ jon yohin. Ndoꞌ joꞌ tja jon, taqueeꞌ jon vaaꞌ tsanꞌñeen, tyecüendyuaahan mesa. ");
INSERT INTO azgNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Majoꞌ juu fariseoꞌñeen xjen na tquen jon cüenta na tyiꞌquitsijñꞌoonꞌ Jesús costumbre na mman jon ntꞌö jon chaꞌxjen na contꞌa nanꞌñeen vitjachen na ntcüaꞌhan, tatëveeꞌ tsꞌon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ndoꞌ tso ta Jesús nnon juu: —ꞌOꞌ nnꞌan na conduihoꞌ tmaanꞌ fariseos, itsijonhanꞌ ntyja ꞌnaanhoꞌ chaꞌvijon tsꞌan na ya ya itsintjuꞌ juu naxenꞌ vaso yo ngio, majoꞌ quityquiiꞌhanꞌ ninvaa ji min jndyi. Manndaꞌ vaa na itsijonhanꞌhoꞌ. Ee tyquiiꞌ nꞌonhoꞌ tooꞌchenhanꞌ yo ꞌnan tyia, chaꞌnan na contyꞌueehoꞌ ꞌnan nnꞌan yo tsoñꞌen nnon natyia na contꞌahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ꞌOꞌ nanꞌ nquenhoꞌ. Mangiohoꞌ na nquii Tyoꞌtsꞌon sijndaꞌ jon ninvaa nacjooꞌ tsꞌan. Ngꞌe na nndaꞌ, ¿Aa tyiꞌcovaaꞌ nꞌonhoꞌ na mantyi nquii jon sijndaꞌ jon quiiꞌ tsꞌon tsꞌan? ");
INSERT INTO azgNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Quindyehoꞌ na matsjö, quintꞌahoꞌ naya nnꞌan ꞌnan na min ndueehoꞌ, ya joꞌ ntsiꞌmanhanꞌ na conduihoꞌ na ntjuꞌ quiiꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ꞌOꞌ nnꞌan tmaanꞌ fariseos, viꞌ jndyi ntquenonhoꞌ, min jen conanꞌquindëhoꞌ na coninncyahoꞌ diezmo cüentaaꞌ Tyoꞌtsꞌon ata veꞌ tscojñon tsonjndya yo tscoja yo tsochen nnon tsco na cocüaꞌhoꞌ, majoꞌ tonnon nquii jon tacotaꞌngueeꞌhoꞌ ꞌnan na chuhanꞌ na quintꞌahoꞌ tondëë nnꞌan, min tyiꞌvengiohoꞌ jon. Nanꞌminꞌ icanhanꞌ na quinanꞌquindëhoꞌ, tsoñꞌen ꞌnanhoꞌ na min, min tyiꞌntsacüentyjeeꞌhoꞌ na coninncyahoꞌ diezmo cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ꞌOꞌ nnꞌan na conduihoꞌ tmaanꞌ fariseos, viꞌ jndyi ntquenonhoꞌ ee joo silla na minntyjeeꞌ tyquiiꞌ ntꞌaanꞌon naijon na covendyuaa nnꞌan na tꞌman condui, joꞌ ninꞌcüendyuaahoꞌ chaꞌ ntyja ꞌnaanꞌ joꞌ ntjiꞌ nnꞌan cüenta na tꞌman conduihoꞌ. Ndoꞌ mantyi ntꞌue jndyi nꞌonhoꞌ na nninncya nnꞌan tsꞌon ꞌoꞌ nata chaꞌ quitquen nnꞌan cüenta na njon jndyi conduihoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Viꞌ jndyi ntquenonhoꞌ ee ve vaa na contꞌahoꞌ. Ee ntyja na cotsamꞌanhoꞌ, jndye nnꞌan ivjachuhanꞌ na minꞌchjo tyiꞌcovaaꞌ nꞌonhan na tyiꞌya contꞌahan. Itsijonhanꞌ ꞌoꞌ chaꞌvijon ndiꞌntꞌua na tavityincyo ee juu xjen na ivenon tsꞌan ndoꞌ indui juuhanꞌ, tyiꞌquintjii juu na ndyiiꞌ ꞌnan töꞌhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ndoꞌ ncüii tsꞌan na itsiꞌman juu nchu vaa itsiquindyi jñꞌoon na tquen Moisés, tꞌa juu, tso juu nnon Jesús: —Nndaꞌ ta, na matsuꞌ jñꞌoonvaꞌ, mantyi itscüejnaanꞌhanꞌ já chaꞌxjen nque nnꞌan na conduihan tmaanꞌ fariseos. ");
INSERT INTO azgNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ndoꞌ sintcüeꞌ Jesús jñꞌoon nnon tsanꞌñeen, tso jon: —ꞌOꞌ na conanꞌmanhoꞌ nchu vaa itsiquindyi jñꞌoon na tquen Moisés, mantyi viꞌ jndyi ntquenonhoꞌ, ee itsijonhanꞌ ntyja ꞌnaanhoꞌ chaꞌvijon na cotyiohoꞌ xu nacjo nnꞌan na cotquenhoꞌ jñꞌoon na quinanꞌquindëhinhanꞌ. Ndoꞌ min na ndiquinanhinhanꞌ, majoꞌ ꞌoꞌ min veꞌ ncüii ndëë ndueehoꞌ tyiꞌxeꞌquityiꞌhoꞌ na ntejndeihoꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Viꞌ jndyi ntquenonhoꞌ ee nque nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa, conanꞌtycüiꞌhoꞌ joo ndiꞌntꞌua ꞌnaanhin chaꞌ quijntyꞌia nnꞌan na njon ngiohoꞌ ntꞌooꞌñeen. Ndoꞌ nque ndochihoꞌ na tomꞌan ndyu tivio, joohin jnanꞌcüjehan nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ndoꞌ na nndaꞌ contꞌahoꞌ, cotjiꞌ jndyoyuhoꞌ na conanꞌjonhoꞌ ntyja ꞌnaan natyiaꞌñeen na tontꞌa ndochihoꞌ. Ee joohan jnanꞌcüjehan nanꞌñeen, ndoꞌ ꞌoꞌ conanꞌyahoꞌ ndiꞌntꞌua ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Ngꞌe na nndaꞌ vaa, yo juu na mꞌaan Tyoꞌtsꞌon na jndaꞌ xquen jon, itso jon: Njñön ja nnꞌan na nninncyahan jñꞌoon naya njan ndëë nnꞌan. Ndoꞌ mantyi njñön mañoon nnꞌan na conduihan nnꞌan na vejndyee ntyja ꞌnaanꞌ tsꞌian njan. Ñꞌen nanꞌñeen na nnanꞌcüje nnꞌanhin, ndoꞌ ñꞌenhan ntyꞌe nnꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Mangꞌe na nndaꞌ, nque nnꞌan na mꞌan naneinhan, joohan ndyionhan nꞌeon tsoñꞌen nnꞌan na tonanꞌcüje ndochihan na toninncya nanꞌñeen jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. Chojnanhan nꞌeon nanꞌñeen xjen na tyeꞌ tsonnangue ata xjen neinhin. ");
INSERT INTO azgNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Juu jñꞌoonꞌñeen itꞌuiihanꞌhin xjen ntyja na tyioo neoonꞌ Abel na iscueeꞌ Caín juu ata matsꞌia na tyioo neoonꞌ nquii Zacarías, tsan na jnanꞌcueeꞌ nnꞌan tyquiiꞌ ntꞌan nnontyiu tꞌman yo ta vatsꞌon tꞌman. Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, nnꞌan na mꞌan naneinhan, minnchuchen ndyionñꞌenhan nꞌeon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“ꞌOꞌ nnꞌan na conanꞌmanhoꞌ nchu vaa itsiquindyi jñꞌoon na tquen Moisés, viꞌ jndyi ntquenonhoꞌ. Ee juu jñꞌoon na ntsiquinaanhanꞌ na ngovaaꞌ nꞌon nnꞌan nchu vaa itsiquindyi juu jñꞌoonꞌ Tyoꞌtsꞌon, ꞌoꞌ jndë tjiꞌ ndyaꞌhoꞌhanꞌ. Nquehoꞌ tyiꞌcjooꞌ nꞌonhoꞌ na nnanꞌjonhoꞌ ntyja ꞌnaanꞌhanꞌ, ndoꞌ joo nnꞌan na ninꞌcüaaꞌ nꞌonhinhanꞌ, conanꞌntycüiiꞌhoꞌ na nnanꞌjonhan yohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jndë na sinin Jesús jñꞌoonminꞌ ndëëhan, ya joꞌ nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés yo nnꞌan tmaanꞌ fariseoꞌñeen, taꞌhin na tonanꞌjaaꞌhan cjooꞌ jon. Jndye jñꞌoon na taꞌxeeꞌhan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ee tojntꞌue nchu ya ntꞌahan chaꞌ quityiiꞌhanꞌ ngꞌeehanꞌhin chaꞌ ndëë ntꞌuehan jon ntyja ꞌnaanꞌ jñꞌoon na sinin jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Viochen xjen na toninncyaa jon jñꞌoonminꞌ, jndye jndyi nnꞌan tatjonhan, ata totsaquiñjonhan ntyjehan na tyen mꞌanhan. Ndoꞌ taꞌ jon na itsinin jon ndëë nnꞌan na totsayꞌonhan jñꞌoon yohin. Itso jon: —Quintꞌahoꞌ cüenta yo jñꞌoon na conanꞌman nnꞌan na conduihan tmaanꞌ fariseos, ee ve vaa na ndyiiꞌ nꞌonhan. Ndoꞌ joo jñꞌoonꞌñeen vjacyahanꞌ chaꞌna coviquindyiꞌ tsquentë quiiꞌ tsquen tyooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Ee taꞌnan ncüii nnon ꞌnan na veꞌ ntyꞌiu na ntsꞌaa tsꞌanhanꞌ, tyiꞌjeꞌquindëë na ngitëꞌhanꞌ, mancüiixjen nditincyooꞌhanꞌ Ndoꞌ mantyi taꞌnan ncüii nnon na veꞌ ntyꞌiu na sꞌaa tsꞌanhanꞌ na tyiꞌxeꞌcüentyja na ntquen nnꞌan cüenta ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Veꞌ ngꞌe joꞌ, tsoñꞌen ꞌnan na jndë jnduehoꞌ natsjon, mancüiixjen nnintyincyooꞌhanꞌ naxuee. Ndoꞌ jñꞌoon na jndë jnanꞌnein ninmaanꞌhoꞌ tyquiiꞌ ntꞌaa na tëꞌ jndyuehanꞌ, minnchuchen jndei nnincꞌuaa jñꞌoonꞌñeen quityquiiꞌ nata. ");
INSERT INTO azgNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“ꞌOꞌ ntyjë na ya jñꞌoonhoꞌ yo ja, matsjö ndëëhoꞌ tyiꞌncꞌonhoꞌ na ncyaahoꞌ joo nnꞌan na conanꞌcüjehan ntyjehan, majoꞌ ndë joꞌ, taꞌnan cüii nnon na nndëë ntꞌantyihan yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ja ntsiꞌman ndëëhoꞌ nin juu na cꞌonhoꞌ na ncyaahoꞌ: Cꞌonhoꞌ na ncyaahoꞌ nquii Tyoꞌtsꞌon. Ee vaa najndei jon na ncjuꞌ jon ꞌoꞌ quiiꞌ vꞌio xjen na jndë tjiꞌ jon juu na cotaꞌndoꞌhoꞌ nnon tsonnanguevahin. Mayuuꞌ, matsjö cꞌonhoꞌ na ncyaahoꞌ na tonnon nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ꞌOꞌ mangiohoꞌ na covijntꞌua ꞌon quintsa quijndë na ninve xoquituꞌ sꞌon ve. Min na tyiꞌnjon choꞌñeen, majoꞌ nquii Tyoꞌtsꞌon tyiꞌcotsuuꞌ tsꞌon jon minꞌncüii joo oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Majndeichen nquehoꞌ. Ntyjii jndaꞌ jon tsaꞌnndaꞌ sonquenhoꞌ. Mangꞌe joꞌ tyiꞌndyuehoꞌ, ee ꞌoꞌ njonntyichen conduihoꞌ na tonnon jon, chichen quintsa quijndë min na jndye oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minninchen tsꞌan na icüjiꞌ jndyoyu juu ntyja njan ndëë nnꞌan, mantyi ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, ncüjiꞌ jndyoyu ndëë ángeles cüentaaꞌ jon ntyja ꞌnaanꞌ juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Majoꞌ juu tsꞌan na icüjihin ntyja njan tondëë nnꞌan, mantyi ndëë ángeles cüentaaꞌ Tyoꞌtsꞌon, ncüjiꞌ jndyoyu ja na tyiꞌcüajnꞌan juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Minninchen tsꞌan na itsinin ncüii jñꞌoon na itscüejnaanꞌhanꞌ ja na condui ja tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, ndëë ntsitꞌman tsꞌon jon juu tsanꞌñeen. Majoꞌ minꞌncya ro tsꞌan na itsinin juu na juu tsꞌian na matsꞌa, conduihanꞌ ntyja ꞌnaanꞌ nquii yutyia, chito ntyja ꞌnaanꞌ nquii Espíritu Santo, tavi xuee na ntsitꞌman tsꞌon jonhin. ");
INSERT INTO azgNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Mancüii ntquen nnꞌan jñꞌoon nacjohoꞌ ndoꞌ ngochohan ꞌoꞌ ndëë nnꞌan quiiꞌ ntꞌaanꞌon ꞌnaan nnꞌan judíos, oo ndëë nque nnꞌan na conintque ndëëhoꞌ yo nanmꞌannꞌian na ndoxenhanhoꞌ. Majoꞌ ya na ndui na nndaꞌ, tyiꞌncꞌonhoꞌ jñꞌoontiu nin ꞌnan ntꞌahoꞌ oo nin jñꞌoon nnanꞌntcüeꞌhoꞌ, ");
INSERT INTO azgNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Ee juu xjenꞌñeen nquii Espíritu Santo ntsiꞌman jon ndëëhoꞌ nin jñꞌoon na nnanꞌntcüeꞌhoꞌ ndëëhan.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Xjenꞌñeen ncüii tsꞌan na mꞌaan quiiꞌ ntꞌan nnꞌan na jndye jndyiꞌhin, tso juu nnon Jesús: —Nndaꞌ ta, juu ꞌnan na jntyꞌii tsotyë na tsixuanhanꞌ cüenta, quitsuꞌ nnon xiöhöꞌ na nnincyaa juuhanꞌ nnön. ");
INSERT INTO azgNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Joꞌ tꞌa Jesús ꞌndyo juu, tso jon: —ꞌUꞌ ntyjë, chito condui ja jüe na ntcoꞌxën ja jñꞌoon ꞌnaanhoꞌ oo na nncꞌön ꞌnan na jntyꞌii tsotyehoꞌ ndueehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ndoꞌ tso jon ndëë tsoñꞌen nnꞌan: —Quitquenhoꞌ cüenta na tyiꞌjen ntsꞌaahanꞌ ngiohoꞌ yo ꞌnan. Ee nndëë ntsꞌaahanꞌ na jndye ꞌnaanꞌ tsꞌan min, majoꞌ chito ntyja ꞌnaanꞌhanꞌ na ninncyaahanꞌ na mavio ncꞌoon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ya joꞌ sinin Jesús jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ. Tso jon: —Tomꞌaan ncüii tsantya na ya tyuaa ꞌnaanꞌ jon, ndoꞌ ya jndyi toveꞌ ntjonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Sitiu jon quiiꞌ tsꞌon jon: “Nin ꞌnan chi ntsꞌa, ee tavi yuu ya na ntsivë ꞌnan na tueꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Itsontyichen jon: Ndö vaa ntsꞌa, ntsityꞌui ndëꞌ njan naijon na coñjon ꞌnan na coveꞌ ndoꞌ ntsia mañoonhanꞌ na tꞌmanntyichen. Joꞌ ntsuë tsoñꞌen ꞌnan na tueꞌ yo tsochen ꞌnan mana chö. ");
INSERT INTO azgNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndë joꞌ ntsjö ncö nnon ñuan njan: Jeꞌ yuuꞌ jeꞌ, jndye ꞌnan njan min na jndë sivë na ntejndeihanꞌ ja jndye chu. Naneinhin ngüajndyëë chjo, ntcüꞌa ndoꞌ ncꞌua. Ncꞌön na neiinꞌ tsꞌön. ");
INSERT INTO azgNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Majoꞌ nquii Tyoꞌtsꞌon itso jon nnon juu: Tsanꞌ ꞌuꞌ, tsjonvahin ncüꞌioꞌ, ya joꞌ tsoñꞌen ꞌnan na jndë sijndaꞌ, ¿Nin tsꞌan ntꞌö ntjohanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tsontyichen Jesús: “Manndaꞌ vaa itsijonhanꞌ na ntjon tsꞌan na itsue juu ꞌnan cüentaaꞌ nquii juu, majoꞌ na tonnon Tyoꞌtsꞌon, jñenꞌ jndyihin.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ndoꞌ tso Jesús ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon: —Mangꞌe na nndaꞌ vaa, ndö jñꞌoon matsjö ndëëhoꞌ: Taji ncꞌonhoꞌ na ji mꞌaanꞌ nꞌonhoꞌ vaa na mꞌanhoꞌ nnon tsonnangueva, na nin ꞌnan ntcüaꞌhoꞌ, ndoꞌ yuu nnan ndiaa na ntcüehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ee ntyjii Tyoꞌtsꞌon na juu na na vja na cotaꞌndoꞌhoꞌ, njonntyichenhanꞌ, chichen joo ꞌnan na icanhanꞌ ꞌoꞌ na ntcüaꞌhoꞌ. Ndoꞌ mantyi njonntyichen juu siꞌtsꞌo ꞌnaanhoꞌ, chichen ndiaa na icanhanꞌ ꞌoꞌ na ntcüehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Quitquenhoꞌ cüenta ntyja ꞌnaan quindyaa, joo oꞌ min tyiꞌquinon oꞌ, min tyiꞌquityje oꞌ, min taꞌnan ntꞌaa oꞌ, min ndëꞌ na coñjon ntquen taꞌnan, majoꞌ nquii Tyoꞌtsꞌon itixeeꞌ jon oꞌ. Ndoꞌ ꞌoꞌ jeꞌ, njonntyichen ꞌoꞌ nchjii jon, chichen quindyaahinꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿Nin ncüii ꞌoꞌ na veꞌ ntyja ꞌnaanꞌ jñꞌoontiu na mꞌaanꞌ tsonꞌ nndëë ntsaꞌ na nditco min veꞌ chjoviꞌ xeechuꞌ ꞌnanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Majoꞌ ngꞌe na xeꞌquindëë ntꞌahoꞌ nanꞌvaꞌ na chjontyichenhanꞌ, ya joꞌ veꞌ jnꞌaan na jndye jndyi jñꞌoontiu mꞌanhoꞌ ntyja ꞌnaan tsochen nanꞌminꞌ na majndeichen tyiꞌjeꞌquindëë nntꞌa nquehoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Quitquenhoꞌ cüenta ntyja ꞌnaan ntjaaꞌ jndëë. Tyiꞌcontꞌahanꞌ tsꞌian, min tyiꞌnanꞌyahanꞌ ndiaa na ntcüehanꞌ. Majoꞌ jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, nquii rey Salomón, min na taquintyja na tyahin, taꞌnan tuen ndiaaꞌ jon na nancooꞌhanꞌ chaꞌna nancooꞌ joo ntjaaꞌ jndëë. ");
INSERT INTO azgNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Xe ngꞌe na nndaꞌ itsꞌaa Tyoꞌtsꞌon, na nancooꞌ ntjaaꞌ jndëë na tyiꞌviooꞌhanꞌ, nanein minhanꞌ ndoꞌ ꞌio cha jndë ntcohanꞌ quiiꞌ tonꞌ, majndeichen nchjii jon nchu vaa ndui na ntcüehoꞌ ndiaa, ꞌoꞌ na chjo jndyi na vantyja nꞌonhoꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ngꞌe joꞌ, tyiꞌji jndye na ncꞌoonꞌ nꞌonhoꞌ na ninquiiꞌchen nin ꞌnan na ntcüaꞌhoꞌ yo ꞌnan na ntcüehoꞌ. Taninncyahoꞌ na nchje nanꞌminꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ee nque nnꞌan na tyiꞌcꞌonhan nacje ꞌnaanꞌ Tyoꞌtsꞌon, ninnquiiꞌchen nanꞌminꞌ cojntꞌuehan. Majoꞌ nquii Tyëhöꞌ Tyoꞌtsꞌon nchjii jon na tsoñꞌen nanꞌminꞌ itsitjahanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Majoꞌ juu ꞌnan na vejndyee na cꞌoonꞌ nꞌonhoꞌ, quijntꞌuehoꞌ na nquii jon coꞌxen jon ꞌoꞌ, ndoꞌ tsoñꞌen nanꞌminꞌ na itsitjahanꞌ ꞌoꞌ, nninncyaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“ꞌOꞌ nnꞌan tmaanꞌ chjo cüenta ja, tyiꞌndyuehoꞌ, ee nquii Tyehoꞌ neiinꞌ jon na ninncyaa jon na nnanꞌjonhoꞌ juu na icoꞌxen jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Quindëëhoꞌ ꞌnaanhoꞌ na min ndoꞌ sꞌon na ncyꞌonhoꞌ cüenta, ncyahoꞌhanꞌ ndëë naninñenꞌ. Xee na aa ntꞌahoꞌ na nndaꞌ, nninncyaa jon na mañoon nnon naya na tyiꞌjeꞌcüiꞌndaaꞌhanꞌ. Juuhanꞌ tsiꞌxuanhanꞌ ꞌnan na mꞌaan ndoꞌ mꞌaanhanꞌ quiñoonꞌndue naijon na jeꞌcueeꞌ tsanchꞌuee, min tyiꞌjeꞌquinanꞌndaaꞌ quindiuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ee naijon na conavehoꞌ naya ꞌnaanhoꞌ na njonhanꞌ, joꞌ vijon mꞌaan na ndyiiꞌ nꞌonhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Ya joꞌ sinin Jesús nchu vaa nguaa xjen na nndyo nndaꞌ jon. Tso jon: “Cꞌon cjehoꞌ na cominndooꞌhoꞌ ja, chaꞌvijon mꞌaan cje tsꞌan na cüe juu ndiaa. Cꞌonhoꞌ chaꞌvijon joo moso na ninnquiiꞌchen xuee chon lámpara ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Covendooꞌhan juu patrón ꞌnaanhan na nndyo ntcüeꞌ jon na tja jon naijon na toco tsꞌan. Juu xjen ya na ntsicꞌuaa jon ꞌndyo vaaꞌ jon, mamꞌan cje nanꞌñeen na nnanꞌquinaanhan na ngüenon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Tꞌman naya ꞌnaan joo mosoꞌñeen xe juu xjen na ncüjeeꞌ ntcüeꞌ jon ndoꞌ ntjii jon na ya cüenta contꞌahan. Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, ntsijndaꞌ jon ndoꞌ ntsijñꞌoonꞌ jon na ntcüaꞌhan. Ntsꞌaa jon na ngüendyuaahan mesa, ndoꞌ nquii jon ntyeꞌntjon jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Tanin min xe na aa ncüjeeꞌ ntcüeꞌ jon xoncüe tsjon oo min xe na aa ncüjeeꞌ jon na vanco ndoꞌ ntjii jon na mꞌan cjehan, tꞌman vaa na nninncyaahanꞌ na neinhan. ");
INSERT INTO azgNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ndoꞌ cañjoonꞌ nꞌonhoꞌ jñꞌoonva, juu tsꞌan na conintque vꞌaa, xe na aa ntyjii jon yuu xjen na ncüjeeꞌ tsanchꞌuee, ya joꞌ ncꞌoon cje jon ndoꞌ min tyiꞌxeꞌncyaa jon na ngaqueeꞌ tsanꞌñeen vaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mantyi ꞌoꞌ cꞌon cjehoꞌ, ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, majuuto xjen na tyiꞌquinanꞌtiuhoꞌ na ncüjë ntcüꞌë. Majuuto xjenꞌñeen ncüjë nntꞌa quiiꞌ ntꞌanhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Taxeeꞌ Pedro nnon Jesús, tso juu: —Nndaꞌ ta, juu jñꞌoonvaꞌ na tyiꞌquitsuꞌ nquiiꞌhanꞌ, ¿Aa xiaꞌntyi ndë́ já na matsininꞌhanꞌ, oo aa mantyi ndëë tsoñꞌen nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tꞌa ta Jesús, itso jon: —Minninchen tsꞌan na conduihin chaꞌna mosotque, quindyii juu jñꞌoonva. Ee juu mosotqueꞌñeen, xoncüeeꞌ tsꞌon jon ndoꞌ jndaꞌ xquen jon. Joꞌ na ncꞌua patrón tsꞌian nnon jon na nditquehin ndëë tsoñꞌen ntyje moso jon na ntcoꞌxen jon tsoñꞌenhin, ndoꞌ na ꞌio ꞌio nninncyaa jon ꞌnan na ntcüaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Tꞌman naya ꞌnaanꞌ tsanꞌñeen vaa, xe juu xjen na ncüjeeꞌ ntcüeꞌ patrónꞌñeen ndoꞌ ntjii jonhin na itsiquindë juu chaꞌxjen na sijndaꞌ nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, ntꞌö tsanꞌñeen nninncyaa patrón tsoñꞌen ꞌnaanꞌ jon na min na cüantyjeeꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Majoꞌ juu mosotqueꞌñeen xe na aa ntsitiu juu: Juu patrón njan, tyiꞌxeꞌcüjeeꞌ tyuaaꞌ jon. Ndoꞌ ngꞌe na nndaꞌ vaa na ndyiiꞌ tsꞌon juu, joꞌ ngitaꞌ juu na ncüjaꞌ juu minꞌndyechen ntyje moso juu nannon ndoꞌ nanntcu. Ndoꞌ ntcüaꞌ quitscu juu ndoꞌ ncꞌu juu ndoꞌ nndyi juu. ");
INSERT INTO azgNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ndoꞌ na nndaꞌ, juu xuee na tyiꞌcꞌoon cje juu ndoꞌ xjen na tyiꞌquen juu cüenta, ncüjeeꞌ ntcüeꞌ nquii patrón ꞌnaanꞌ juu. Jnaanꞌ joꞌ, ji vaa jndyi na ngichuꞌ tsanꞌñeen ata ntscueeꞌhanꞌhin, ndë joꞌ ncjuꞌ patrónhin naijon na mꞌan nnꞌan na tyiꞌcantyja nꞌon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Majoꞌ juu moso na ntyjii nin ꞌnan na ntꞌue tsꞌon patrón ꞌnaanꞌ na quitsꞌaa, majoꞌ tyiꞌquitsicjehin min tyiꞌcüangueeꞌ juu ꞌnan na ntꞌue tsꞌon tsanꞌñeen, ngichuꞌ jndyi juu. ");
INSERT INTO azgNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Majoꞌ ncüii moso na tyiꞌcovaaꞌ tsꞌon juu yo ꞌnan na itsꞌaa, ndoꞌ itsꞌaa juu ꞌnan na tsixuan juu na ngichuꞌ, mancüiixjen ngichuꞌ tsanꞌñeen, veꞌ tyiꞌcueeꞌchen. Majoꞌ minninchen tsꞌan na jndye ivaaꞌ tsꞌon, mantyi jndye ntcan Tyoꞌtsꞌon na quitsiquindë juu. Ee juu tsꞌan na jen ntyja nꞌon nnꞌan, matꞌmanntyichen ntcanhanꞌ na quitsꞌaa tsanꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Tsochen Jesús: “Ja jndë jndyö tsonnangue na ntscüꞌa chon quiiꞌ ntꞌan nnꞌan. Yo ninvaa ñuan njan ntꞌue tsꞌön na jndë tꞌahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Vaa ncüii naijndeiꞌhanꞌ na ngenön naviꞌ tꞌman na ntyja ꞌnaanꞌ joꞌ ntscueeꞌhanꞌ ja. Ndoꞌ inchjehanꞌ ja ata ngueeꞌ xjen na ntsiquindëñꞌenhanꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Aa conanꞌtiuhoꞌ na jndyö tsonnangue na ntsꞌa na nntjo ya nnꞌan yo ntyjehan? Min chito juu tsꞌian na jndyö. Ja jndyö na ncꞌonhanꞌ nnꞌan yo ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nanein na tonnonchen, ncꞌon ꞌon nnꞌan na ncüii vꞌaa, ndyehan ncꞌonhan nacjo ve nanꞌñeen, ndoꞌ ve nanꞌñeen ncꞌonhan nacjo ndye ntyjehan nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nquii tye tsꞌan vja jon nacjooꞌ tsansꞌa jnda jon, ndoꞌ juu juu vja juu nacjooꞌ jon. Mantyi nquii ndyee yuscu ncꞌoon jon nacjooꞌ jnda jon na yuscu, ndoꞌ ncꞌoon tsanꞌñeen nacjooꞌ jon. Ndoꞌ ncja jon nacjooꞌ tsanitsaaꞌ jon, ndoꞌ ncꞌoon tsanꞌñeen nacjooꞌ jon.” ");
INSERT INTO azgNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Ndoꞌ tso Jesús ndëë nnꞌan na jndye jndyiꞌhin: —Xjen na cojntyꞌiahoꞌ ntyja chincyu tontyja na vacue ndoꞌcüjioonꞌ, quintyjachen conduehoꞌ na nnguaꞌ, ndoꞌ mayuuꞌ itsꞌaahanꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ndoꞌ xjen na cojntyꞌiahoꞌ na nnan jndye tontyja na conduiꞌ ncjuu tsonjnꞌaan, conduehoꞌ: Nanein jminꞌ ntsꞌaahanꞌ, ndoꞌ mayuuꞌ itsꞌaahanꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ꞌOꞌ nnꞌan na ve vaa na contꞌahoꞌ, jndaꞌ jndyi nquenhoꞌ na covaaꞌ nꞌonhoꞌ ꞌnan na covejndyo na itsꞌaahanꞌ nnon tsonnangue yo tsjöꞌndue. Ndoꞌ na nndaꞌ, ¿Ndu na ndicüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ tsꞌian na matsꞌa quiiꞌ ntꞌanhoꞌ ngueemin?” ");
INSERT INTO azgNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Ndoꞌ sininntyichen Jesús ndëëhan, itso jon: “Joo ꞌnan na covitincyo ntyja njan, ¿Ndu na conanꞌqueꞌ nꞌonhoꞌ na ntjiꞌhoꞌ cüenta nin ꞌnan itsiꞌmanhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ya na vaa jñꞌoon na itꞌuiihanꞌ ꞌuꞌ na covancüihoꞌ nnon ta tsanmꞌaantsꞌian yo tsꞌan na matsitja ꞌuꞌ, ndö vaa quitsaꞌ. Viochen xjen na vjaꞌ nato yohin, cjooꞌ tsonꞌ na cüanꞌ yahin, chaꞌ tyiꞌntsꞌaahanꞌ na jaaꞌ jndyi ntꞌuii jñꞌoonꞌñeen ꞌuꞌ tonnon jüe. Ndoꞌ juu jon nninncyaa jon ꞌuꞌ nduee cominsión. Ndoꞌ joo nanꞌñeen ntyiꞌhan ꞌuꞌ vancjo. ");
INSERT INTO azgNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Jñꞌoon mayuuꞌ na matsjö taxeꞌquinduiꞌ joꞌ ata jndë tyionꞌñꞌenꞌ na matsitja ꞌuꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Juu xjenꞌñeen sque vendye nnꞌan na mꞌaan Jesús na jnduehan nnon jon nchu vaa na sꞌaa Pilato. Yo jñꞌoonꞌ tsanꞌñeen jnanꞌcüje sondaro ꞌnaanꞌ jon vendye nnꞌan ndyuaa Galilea quiiꞌ vatsꞌon tꞌman. Ndoꞌ nque sondaroꞌñeen jnanꞌtjonꞌhan nꞌeon nanꞌñeen yo nꞌeon quiooꞌ na jnanꞌcüje nanꞌñeen na tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tꞌa Jesús jndyuehan, itso jon: “Nanꞌñeen jeꞌ, ¿Aa cotjiꞌhoꞌ cüenta na nndaꞌ vaa na tquenonhan ee na tꞌmanntyi jnanhan vaa, chintyi tsoñꞌen nnꞌan ndyuaahan? ");
INSERT INTO azgNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minꞌchjo chitojoꞌ. Ee mantyi ꞌoꞌ xe na aa tyiꞌntcüeꞌ nꞌonhoꞌ jnanhoꞌ, manndaꞌ itsijonhanꞌ na ngitsu tsoñꞌenhoꞌ chaꞌxjen na tquenon nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ndoꞌ mantyi juu vꞌaandye na toventyjeeꞌhanꞌ ndyo pila Siloé tsjoon Jerusalén na iscueeꞌhanꞌ quinꞌon nchoꞌndye nnꞌan xjen na tyioohanꞌ nacjohan, ¿Aa cotjiꞌ ꞌoꞌ cüenta na tꞌmanntyi tonanꞌtjahan, chintyi tsoñꞌen ntyjehan nnꞌan na mꞌan tsjoonꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minꞌchjo chitojoꞌ. Ndoꞌ mantyi nquehoꞌ, xe na aa tyiꞌntcüeꞌ nꞌonhoꞌ jnanhoꞌ, manndaꞌ itsijonhanꞌ na ngitsu tsoñꞌenhoꞌ chaꞌxjen na tquenon joo nanꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ndö vaa jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ na sinin Jesús. Juuhanꞌ siꞌmanhanꞌ na icanhanꞌ na quintcüeꞌ nꞌon nnꞌan. Itso jon: —Tomꞌaan ncüii tsꞌan, tominntyjeeꞌ ncüii tsꞌoon higuera quityquiiꞌ ntjon ꞌnaanꞌ juu. Ndoꞌ tequintꞌue tsanꞌñeen të juu tsꞌoonꞌñeen, majoꞌ tatë ntjii jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Joꞌ tso jon nnon tsꞌan na ivantyjeeꞌ juu ntjonꞌñeen: Quenꞌ cüenta nanein jndë ndye chu na mandyöquintꞌuë të tsꞌoon higuerava, majoꞌ tatë contjihanꞌ. Cüa, cꞌuaꞌhanꞌ, veꞌ jnꞌaan na itsityenhanꞌ tyuaa. ");
INSERT INTO azgNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Majoꞌ juu tsan na ivantyjeeꞌ tyuaaꞌñeen, tꞌa juu ꞌndyo jon, tso juu: Nndaꞌ ta, quiꞌndyiꞌ yaꞌhanꞌ chuva ata na jndë jñꞌën xiꞌjndio ngꞌeehanꞌ ndoꞌ ndyiön tsꞌotoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xe na aa ntsꞌaahanꞌ të chuncyꞌönhöꞌ, ya, majoꞌ xe aa taꞌnan, yajoꞌ yuuꞌ jeꞌ, ncꞌuaꞌhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ncüii xuee na cotaꞌjndyee nnꞌan judíos, taqueeꞌ Jesús vatsꞌon ꞌnan nanꞌñeen, siꞌman jon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ndoꞌ joꞌ tomꞌaan ncüii tsanscu na jndë nginꞌon nchoꞌndye chu na tyꞌoon jndyevꞌiihin, ata siquixꞌenhanꞌ naxenꞌ juu. Jen ntyja tovaca juu, ndiquindëë ntsindiuuhin. ");
INSERT INTO azgNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Ndoꞌ ya na jndyiaaꞌ Jesús tsanꞌñeen, tꞌman jonhin, tso jon nnon juu: —ꞌUꞌ nan, jndë jnꞌmanꞌ tycu na maquenoonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ndoꞌ tyio jon ntꞌö jon nacjooꞌ juu ndoꞌ maquintyjachen tcoꞌyuhanꞌ naxenꞌ juu. Tyeꞌ totsitꞌmaanꞌ juu Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Majoꞌ nquii tsꞌan na conintquehin juu vatsꞌonꞌñeen, sivꞌii jon na sinꞌman Jesús juu tsanscuꞌñeen juu xuee na cotaꞌjndyeehan. Joꞌ tso jon ndëë nnꞌan na mꞌan joꞌ: —Mꞌaan yon xuee na coꞌxenhanꞌ na quintꞌahoꞌ tsꞌian. Ngueeminꞌ ncyohoꞌ na nnꞌmanhoꞌ, chito juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ndoꞌ tso Jesús nnon tsanꞌñeen: —ꞌOꞌ nnꞌan na ve vaa na contꞌahoꞌ, juu xuee na cotaꞌjndyëëhë, ꞌoꞌ mancüiixjen conanꞌquinanꞌhoꞌ juu toro oo snon njnuenꞌhoꞌ naijon na tyen choꞌñeen na icüaꞌ oꞌ ndoꞌ na ntsananꞌcꞌuhoꞌ ndaa oꞌ. ¿Aa tyiꞌyuuꞌ na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ndoꞌ ngꞌe na nndaꞌ vaa na contꞌahoꞌ, juu tsanscuvaꞌ na conduihin tsjan Abraham na jndyocahanꞌ, na jndë quinꞌon nchoꞌndye chu na itsꞌaaviꞌ Satanás jon, chuhanꞌ na quindyaahin yo ꞌnan na iquenon jon min na juu xuee na cotaꞌjndyëëhë. ");
INSERT INTO azgNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Xjen na sinin Jesús jñꞌoonminꞌ, nque nnꞌan na tyiꞌcueeꞌ nꞌonhan jon, tsoñꞌenhan sꞌaahanꞌ na tyia jndyi ngiohan. Majoꞌ nque nnꞌan na jndye jndyiꞌhin, na jntyꞌiahan tsoñꞌen tsꞌian na njon na totsꞌaa jon, tyincyaahanꞌ na nein jndyihan. ");
INSERT INTO azgNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jndë joꞌ tsontyichen Jesús ndëëhan: “Juu na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja ꞌnaanꞌ na cotsamꞌanhan, ¿Nin ncüii nnon na itsijonhanꞌ juuhanꞌ? Ndoꞌ ¿Nin ꞌnan na ntsijönꞌ na ntsiꞌmanhanꞌ nchu vaa na vavitꞌman juu na icoꞌxen jon nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Itsijonhanꞌ juuhanꞌ chaꞌna ntquen mostaza na juuhanꞌ quijndëviꞌhanꞌ. Juu nanꞌñeen jnonꞌ tsꞌanhanꞌ quiiꞌ ntjon ꞌnaanꞌ juu. Jndë na tꞌonhanꞌ, cje ro tëvindyehanꞌ, tꞌman tsꞌoon sꞌaahanꞌ ata tonanꞌya quintsahinꞌ ntycya oꞌ xquen juu tsꞌoonꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ndoꞌ tsontyichen Jesús: “¿Nin ncüiichen ꞌnan ntsijönꞌ ja juu na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan? ");
INSERT INTO azgNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Itsijonhanꞌ juuhanꞌ chaꞌna tsquentë na tijntꞌue ncüii tsanscu na sitjonꞌ jonhanꞌ quiityquiiꞌ ndye stotsuaꞌ jndë tyooꞌ. Ndoꞌ juu tsquentëꞌñeen siquindëhanꞌ ninvaa tsquen tyooꞌñeen.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Xjen na toquiñjon Jesús nato na vja jon Jerusalén, tacüenon jon njoon tꞌman yo njoon quijndë. Ndoꞌ totsiꞌman jon ndëë nnꞌan njoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ndoꞌ taxeeꞌ ncüii tsꞌan nnon jon, tso juu: —Nndaꞌ ta, ¿Aa tyiꞌjndye nnꞌan na ntsinꞌman Tyoꞌtsꞌon ñuaanhan? ");
INSERT INTO azgNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tꞌa jon, tso jon nnon tsanꞌñeen: —Juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan, itsijonhanꞌ juuhanꞌ chaꞌvijon ꞌndyo vꞌaa quintuviꞌ. Quinanꞌchonhoꞌ na nanꞌjonhoꞌ ntyja ꞌnaanꞌhanꞌ chaꞌxjen itsichon tsꞌan na nguenon juu ꞌndyo vꞌaaꞌñeen. Ngꞌe matsjö ndëëhoꞌ, jndye nnꞌan nnanꞌchonhan na nnanꞌjonhan ntyja ꞌnaanꞌ na icoꞌxen Tyoꞌtsꞌon nnꞌan, majoꞌ tyiꞌjeꞌquinanꞌxuanhan na ndëë ntꞌahinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ee nquii tsꞌan na conintque quiiꞌ juu vꞌaaꞌñeen, vi na jndë jnanquintyja jon mesa ndoꞌ ntscuꞌtyen jon ꞌndyo vꞌaa, yajoꞌ ꞌoꞌ na mꞌanhoꞌ chꞌen, ngitaꞌhoꞌ na nnanꞌcꞌuaahoꞌ ꞌndyo juu vꞌaaꞌñeen. Nnduehoꞌ: “Nndaꞌ ta, quitsiquinanꞌ ꞌndyo vꞌaa na ngüenö́n.” Majoꞌ ntsintcüeꞌ jon jñꞌoon ndëëhoꞌ, ngitso jon: “Tyiꞌcüajnꞌan ja ꞌoꞌ, min tyiꞌquintji yuu jon jnanhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Joꞌ ngitaꞌhoꞌ na nnduehoꞌ nnon jon: Já tovendyuá mesa na tocüꞌá yo ꞌuꞌ, ndoꞌ totsiꞌmanꞌ ndë́ xjen na tyjeꞌ tsjö́n. ");
INSERT INTO azgNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Majoꞌ ntsintcüeꞌ jon jñꞌoon ndëëhoꞌ: “Jndë tsjö ndëëhoꞌ na tyiꞌcüajnꞌan ꞌoꞌ min tyiꞌquintji yuu jon jnanhoꞌ. Quenaanhoꞌ ntjoohin, tsoñꞌenhoꞌ na contꞌahoꞌ ꞌnantyia.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ngüentyja xjen na njntyꞌiahoꞌ nquii Abraham yo Isaac yo Jacob yo ninꞌtsoñꞌen nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nnguaa na mꞌanhan naijon na icoꞌxen Tyoꞌtsꞌon. Ndoꞌ juu xjen na njntyꞌiahoꞌ na nndaꞌ, ndoꞌ nquehoꞌ jndë jntyꞌiihanꞌ ꞌoꞌ chꞌen, yajoꞌ ncꞌonhoꞌ na nnanꞌxuaahoꞌ na itsiꞌndaaꞌhanꞌ ngiohoꞌ, ndoꞌ ntcüaꞌhoꞌ ndiꞌnꞌonhoꞌ na quindyaꞌ jndyi ngiohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Majoꞌ ntsque nnꞌan na nnan ninvaa tsonnangue. Nanꞌñeen ncꞌonhan na neinhan na ngatjonhan naijon na icoꞌxen Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Quitquenhoꞌ cüenta, nnꞌan na mꞌan nanein na cotjiꞌhoꞌ cüenta na tyiꞌnjon conduihin, joohan ntcoꞌhanꞌhin na tonnon. Majoꞌ joo nnꞌan na mꞌan nanein na cotjiꞌ nquehoꞌ cüenta na njon jndyi conduihin, majoꞌ ngüentyja xjen na ncjuꞌcjehanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Majuuto xjenꞌñeen, squenon minndye nnꞌan tmaanꞌ fariseos na mꞌaan Jesús, jnduehan nnon jon: —Yantyi na quinduiꞌ ntjoohin, cjaꞌ ncüiichen joo ee ninꞌquitscueeꞌ Herodes ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tꞌa Jesús, itso jon ndëëhan: —Juu tsanꞌñeen itsijonhanꞌhin chaꞌvijon tyondye. Cüa, cꞌohoꞌ, quinduehoꞌ nnon jon: “Nanein na tonnonchen macüjintyë yotyia quiiꞌ nꞌon nnꞌan, ndoꞌ matsinꞌman jahin ntycu na coquenonhan ndoꞌ tajndye vitja na ntsiquindëë juu tsꞌian na matsixuan.” ");
INSERT INTO azgNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Majoꞌ juu nato na ñjön xeevahin, ꞌio ndoꞌ cha, icanhanꞌ na ncjö na tonnonchen, ee xiaꞌntyi Jerusalén chuhanꞌ na ngueꞌ tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nnguaa. ");
INSERT INTO azgNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“ꞌOꞌ nnꞌan Jerusalén, ꞌoꞌ na conanꞌcüjehoꞌ nnꞌan na coninncya jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nnguaa, ndoꞌ cotuenꞌhoꞌ ntjöꞌ nque nnꞌan na ijñon jonhan quiiꞌ ntꞌanhoꞌ yo jñꞌoonꞌ jon. Majndye jnda tontyja tsꞌön na ntsincüi ꞌoꞌ na ncꞌonhoꞌ ntyja njan, chaꞌxjen juu quitsjon xque itsincüi oꞌ ntsinda oꞌ quiiꞌ tsë ntsquii oꞌ, majoꞌ oꞌ tyiꞌquintꞌue nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Quitquenhoꞌ cüenta, taxeꞌcüantyjeeꞌntyi Tyoꞌtsꞌon tsjoonhoꞌ. Matsjö na tajeꞌquijntyꞌiantyichen ꞌoꞌ ja ata juu xjen na ngüentyja xuee na nnduehoꞌ: “Quityio Tyoꞌtsꞌon jnꞌaan nquii juu na ndyo juu yo xueeꞌ nquii jon.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Ncüii jon ncüii tsꞌan na conintquehin quiiꞌ tmaanꞌ nnꞌan na conduihan fariseos, tso juu nnon Jesús na ngacüaꞌ jon vaaꞌ juu, ndoꞌ juu xueeꞌñeen xuee na cotaꞌjndyee nnꞌan yajoꞌ. Joo nanꞌñeen totquenchenhan cüenta xe na aa vaa nchu ntsꞌaa Jesús na ntyja ꞌnaanꞌ joꞌ na ndëë ntꞌuehanhin. ");
INSERT INTO azgNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ndoꞌ joꞌ na tonnon jon tecüentyjeeꞌ ncüii tsanviiꞌ na ñjon juu ntcooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ndoꞌ taxeeꞌ jon ndëë nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, yo joo nnꞌan fariseosꞌñeen: —¿Aa chuhanꞌ na ntsinꞌman tsꞌan tsanviiꞌ juu xuee na cotaꞌjndyëëhë, oo aa tyiꞌquichuhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Majoꞌ joohan tatꞌahan. Joꞌ tyꞌoon jon cüenta juu tsanviiꞌñeen, sinꞌman jonhin, jndë joꞌ tso jon nnon juu ya cja ntcüeꞌ juu vaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ndoꞌ mantyi sinin jon ndëë joo fariseosꞌñeen: —Juu xuee na cotaꞌjndyëëhë, xe na aa mꞌaan ncüii ꞌoꞌ na ngioo jnda juu oo toro tsjuenꞌ juu quityquiiꞌ tsuiꞌ na njoon, ninꞌñoonꞌ ntsicje ꞌuꞌ na ncüjiꞌ juu yuꞌñeen oo choꞌñeen. ¿Aa tyiꞌyuuꞌ na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Majoꞌ joo nanꞌñeen tatꞌahan na nndaꞌ tso jon. ");
INSERT INTO azgNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ndoꞌ Jesús, tquen jon cüenta ꞌnan na jntꞌa nnꞌan na tqueenꞌ juu fariseoꞌñeen na ntcüaꞌhan yo jon. Nanꞌñeen tojooꞌ nꞌonhan na ngüendyuaahan silla naijon na ntsiquinjonhanꞌhin. Joꞌ jñꞌoonva sinin jon ndëëhan na tyiꞌquitso nquiiꞌ jonhanꞌ. Tso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Juu xjen ya na iqueenꞌ tsꞌan ꞌuꞌ na quitsijon ꞌuꞌ na icoco jnda jon, tyiꞌngaquijmanꞌ silla naijon na ntsiquinjonhanꞌ ꞌuꞌ. Ee xe na aa ntsaꞌ na nndaꞌ ndoꞌ ntsijonhanꞌ na tqueenꞌ tsanꞌñeen ncüiichen tsꞌan na tꞌmanntyichen conduihin, chichen ꞌuꞌ, ");
INSERT INTO azgNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yajoꞌ juu tsanꞌñeen na tqueenꞌ jon vehoꞌ, ngantyjaaꞌ jon nnonꞌ, ngitso jon: ꞌUꞌ ntyjë, quenanꞌ ndöhin, tsanvaꞌ ncjo juu naijon na vaquityenꞌ. Ndoꞌ na nndaꞌ na ngitso jon nnonꞌ, ncꞌonꞌ na jnanꞌ na ngaquijmanꞌ silla na matsꞌiañꞌen. ");
INSERT INTO azgNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Mangꞌe na nndaꞌ, xjen na ntqueenꞌ tsꞌan ꞌuꞌ, caquijmanꞌ silla na matsꞌiañꞌen, chaꞌ ya na ngantyjaaꞌ jon nnonꞌ ngitso jon: “ꞌUꞌ ntyjë, cüenoonꞌ na quiñoonꞌchen.” Ndoꞌ na nndaꞌ, nditꞌmaanꞌ ꞌuꞌ tondëë tsoñꞌen nnꞌan na minndyuaahan mesa yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ee minninchen tsꞌan na itsivendye nquiihin, mancüiixjen ntsquioo cjehanꞌhin. Majoꞌ minninchen tsꞌan na ijuꞌcjehin, majndaꞌ ntsive Tyoꞌtsꞌonhin. ");
INSERT INTO azgNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ndoꞌ mantyi tso Jesús nnon nquii tsanꞌñeen na tqueenꞌhin: —Xjen na maquenꞌ nnꞌan na quinanꞌjonhan na ntcüaꞌhan yohoꞌ cüenta yajminꞌ oo na tman, tyiꞌntquenꞌ nnꞌan na ya jñꞌoonhan yo ꞌuꞌ, min nnꞌan ꞌnanꞌ, min ntyꞌiuꞌtycyaꞌ, min nantya na ndyo mꞌanhan yo ꞌuꞌ. Ee xe aa matsaꞌ na nndaꞌ, ngueeꞌ xuee na majoꞌntyi ntꞌahin, chaꞌ juu nayaꞌñeen na saꞌ yohan njonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Majoꞌ ꞌuꞌ ya na matsijndaꞌ ꞌnan tꞌman na ntcüaꞌ nnꞌan, quenꞌ nanninñenꞌ yo nnꞌan na tyiꞌquindë nduee, yo ngꞌe, yo nnꞌan na ndiquitsacaꞌ, yo nannchjan. ");
INSERT INTO azgNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ee na ntsaꞌ na nndaꞌ yohan, ya joꞌ nquii Tyoꞌtsꞌon ndyio jon jnꞌaan ꞌuꞌ na matsaꞌhanꞌ, ee joo nanꞌñeen ꞌnan na saꞌ yohan, tyiꞌxeꞌquindëë ntꞌahin na njonhanꞌ. Majoꞌ nquii Tyoꞌtsꞌon ndyion jon ꞌuꞌ xjen na ntaꞌndoꞌ nndaꞌ nnꞌan na cotsamꞌan chaꞌxjen na chuhanꞌ na tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Ncüii tsꞌan yo na minndyuaahan mesa, ya na jndyii juu na nndaꞌ, tso juu nnon Jesús: —Tꞌman ityio Tyoꞌtsꞌon jnꞌaan minninchen tsꞌan na itsijonhin juu na icoꞌxen jon. Itsijonhanꞌ juuhanꞌ chaꞌvijon na nein nnꞌan na conanꞌjonhan na cocüaꞌhan yo ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tꞌa Jesús, sininntyichen jon ncüii jñꞌoon na tyiꞌquitso nquiiꞌ jonhanꞌ. Juu jñꞌoonꞌñeen tsiꞌmanhanꞌ na chito tsoñꞌen nnꞌan nnanꞌjonhan yo juu na icoꞌxen Tyoꞌtsꞌon nnꞌan ntyja na cotsamꞌanhan. Tso jon: —Tomꞌaan ncüii tsꞌan. Sijndaꞌ jon ncüii na tꞌman na ntcüaꞌ nnꞌan ndoꞌ jndye nnꞌan tqueenꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ya na tman, xjen na mincje tsoñꞌen ꞌnan na ntcüaꞌhan, jñon jon mosooꞌ jon na caquitso tsanꞌñeen ndëë nnꞌan na tqueenꞌ jon: “Nndaꞌhoꞌ ta, ncꞌohoꞌ jeꞌ ee tsoñꞌen jndë mavaa ya.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Majoꞌ tsoñꞌen nanꞌñeen, ncüii ro ncüiihan jñoonꞌhan. Tsan najndyee tso juu: “Quitsaꞌ vi nayaꞌñeen na quitsuꞌ nnon patrón ꞌnanꞌ na quitsitꞌman chjo tsꞌon jon ja. Ee jndë sijnda vi tanꞌ tyuaa ndoꞌ ijndeiꞌhanꞌ na ncjöquijntyꞌiahanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ndoꞌ mantyi ncüiichen tsꞌan tso juu nnon juu mosoꞌñeen: “Jndë sijnda ꞌon ntjo ndoro na nntꞌa oꞌ tsꞌian, ndoꞌ nein jöquintyꞌia aa ya nntꞌa oꞌ tsꞌian. Joꞌ quitsaꞌ vi nayaꞌñeen na quitsuꞌ nnon patrón ꞌnanꞌ na quitsitꞌman chjo tsꞌon jon ja.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ndoꞌ ncüiichen tsꞌan tso juu: “Ja xejnda xco na tomanꞌcö, joꞌ na jeꞌquindëë ncjö.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Joꞌ juu mosoꞌñeen tantcüeꞌ juu ndoꞌ siquindyii juu patrónꞌñeen tsoñꞌen jñꞌoonminꞌ, ndoꞌ joꞌ sivꞌii jon. Tso jon nnon mosooꞌ jon: “Cüa, quitsityuaꞌ, cjaꞌ na vaa tsꞌua ndoꞌ nata quiiꞌ tsjoon, ndoꞌ quindyochuꞌ nanninñenꞌ yo nnꞌan na tyiꞌquindë nduee yo ngꞌe, nnꞌan na nditsacaꞌ yo nnꞌan nchjan.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Ndoꞌ tyiꞌcovivioto xjen tyjeeꞌ ntcüeꞌ juu mosoꞌñeen, tso juu nnon patrón ꞌnaanꞌ juu: “Nndaꞌ ta, jndë sꞌa chaꞌxjen na tsuꞌ, majoꞌ ninvaa vanaanchen na ngüendyuaa nnꞌan.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Ndoꞌ tꞌa jon ꞌndyo mosoꞌñeen: “Cjaꞌ nato tꞌman yo nato jndëë. Ndoꞌ nnꞌan na ntjiꞌ joꞌ, quitsuꞌ ndëëhan na matsjö jndeiꞌhanꞌ na nninncyohan chaꞌ juu vꞌa ngitooꞌhan yo nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ee na matsjö ndëëhoꞌ, minꞌncüii joo nnꞌan na tquënꞌ jndyëë, tajeꞌncya na nnanꞌjonhan na ntcüaꞌhan ꞌnan tꞌman na sijntꞌa.” ");
INSERT INTO azgNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tꞌman tmaanꞌ nnꞌan jnanꞌjonhan yo Jesús. Yajoꞌ tequen jon ndëëhan ndoꞌ tso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Minꞌninchen tsꞌan na njonntyichen ntyjii juu tye juu, ndyee juu, scuuꞌ juu, ntsinda juu, nnꞌan chuuꞌhin, ntsinda tye juu yo ndyee juu, ndoꞌ mantyi njonntyichen nchjii juu nchu vaa na vandoꞌ nquii juu, chichen na njon nchjii juu yo ja, juu tsanꞌñeen tyiꞌjeꞌquindëë na ntsijonhin yo ja. ");
INSERT INTO azgNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ndoꞌ minninchen tsꞌan na itsijonhin yo ꞌnan na matsꞌa, xe na aa tyiꞌquintjo ya ntyjii tsanꞌñeen naviꞌ na iquenon juu ntyja njan, min xe na aa cueꞌ juu ntyja ꞌnaanꞌhanꞌ, jñꞌoon na mayuuꞌ tyiꞌjeꞌquindëë ntsijonhin ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xe na aa mꞌan ncüiihoꞌ na ninꞌquitsia juu vꞌaandye, aa chi ngacjo jndyee juu, ntsitiu ya juu tsaꞌnndaꞌ xoquituꞌ na ntcanhanꞌ chaꞌ ncüjiꞌ juu cüenta na aa nninjndeiꞌhanꞌ ata ntsiquindë juu vꞌaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Majoꞌ xe tyiꞌquitsꞌaa juu na nndaꞌ, jndë na sia juu tsjaanꞌ vꞌaa ndoꞌ nndyiaaꞌ juu na tyiꞌjeꞌquindëë ntsiquindë juuhanꞌ. Ndoꞌ na nndaꞌ, nque nnꞌan na njntyꞌia na nndaꞌ sꞌaa tsanꞌñeen, ngitaꞌhan na nnanꞌcüejnaanꞌhanhin. ");
INSERT INTO azgNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nnduehan: Tsanvaꞌ siquitaꞌ juu ncüii tsꞌian, majoꞌ veꞌ jnꞌaanhanꞌ, tatijntꞌuehanꞌ ngꞌe tasiquindë juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ncüii tsꞌan na tꞌman conduihin na coꞌxen jon na tsixuan jon nqui min sondaro, ¿Aa ntsꞌaahanꞌ na nduiꞌ jon na vjaquitsꞌaa jon tyiaꞌ yo ncüiichen tsꞌan na mantyi tꞌman conduihin na tsixuan jon ntcyu min sondaro? Juu tsan na minjndyee, ¿Aa chi ngacjo juu na ntsitiu ya juu ncüii, aa nndëë ngüantjon jon juu tyiaꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ndoꞌ xe na aa ncüjiꞌ juu cüenta na tyiꞌjeꞌquindëë ntsꞌaa juu, yajoꞌ vi xjen na ninvaa tcya mꞌaan ncüiichen tsanꞌñeen, njñon jndyee juu nnꞌan na mꞌaan tsanꞌñeen na ntsayꞌonhan jñꞌoon na ntcan juu na tyiꞌncꞌoon tyiaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Mangꞌe na nndaꞌ vaa, minninchen tsꞌan na ninꞌquitsijonhin yo jñꞌoon na mancya, icanhanꞌ na cüjiꞌñꞌenhin ntyja ꞌnaanꞌ tsoñꞌen na tsixuan nquii juu. ");
INSERT INTO azgNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Tsoñꞌenhoꞌ ngiohoꞌ na ya covijntꞌue tsjaanꞌ, majoꞌ xe na aa nduiꞌ na chjenꞌhanꞌ, tanchu ya na nninchjenꞌ nndaꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ndoꞌ na nndaꞌ, tayuu jntꞌuehanꞌ, min nnon tyuaa, min yo toꞌ. Veꞌ cotyqueꞌto nnꞌanhanꞌ. ꞌOꞌ na min ndöꞌnquihoꞌ, cüaaꞌ nꞌonhoꞌ jñꞌoonvaꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Ncüii jon joo nnꞌan na cotye sꞌon cüentaaꞌ gobiernon tsjoon Roma, jndyehan squehan na mꞌaan Jesús na ndyehan jñꞌoon na toninncyaa jon, ndoꞌ mantyi yo nnꞌan na cotjiꞌ nnꞌan judíos cüenta na conanꞌtja nanꞌñeen nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ndoꞌ nque nnꞌan tmaanꞌ fariseos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, tatëveeꞌ ngiohan na itsinin jon yo nanꞌñeen. Jaaꞌ jñꞌoon jnanꞌneinhan nacjooꞌ jon. Jnduehan: —Tsanva itsijonhin yo nnꞌan na conanꞌtjahan nnon Tyoꞌtsꞌon, ndoꞌ mantyi icüaꞌ juu yohan. ");
INSERT INTO azgNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Ndö vaa jñꞌoon na sinin Jesús ndëëhan na tyiꞌquitso nquiiꞌ jonhanꞌ. Itso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nin ncüii nquehoꞌ, xe na aa mꞌaan ncüii ciento quinman ntsjuenꞌ juu, ndoꞌ tsu ncüii ꞌo, ¿Aa chi nꞌndyii ya juu joo ninquennꞌan nchoꞌnqui vantjoꞌ ñjen choꞌñeen naijon na cocüaꞌ oꞌ ndoꞌ ngaquintꞌue juu quiooꞌ na tsu, ata xjen na ntjii ntcüeꞌ juu oꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ndoꞌ vi na jndë ntjii ntcüeꞌ juu oꞌ chi ntscüanjoonꞌ juu oꞌ quityaꞌ juu yo na neiinꞌ jndyi juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ndoꞌ ya na ngueeꞌ ntcüeꞌ juu vꞌaa, ntsitjon juu nnꞌan na ya jñꞌoon yohin yo nnꞌan na mꞌan ndyo vaaꞌ juu. Ngitso juu ndëëhan: Cüineiinꞌ nꞌonhoꞌ yo ja ee juu quitsman tsjuënꞌ na tsu oꞌ, jndë ntji ntcüꞌë oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Itsontyichen Jesús: Matsjö ndëëhoꞌ na nndaꞌ vaa na itsijonhanꞌ ntyja ꞌnaanꞌ nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue. Ncüii tsꞌan na itsitjahin nnon jon, neiinꞌntyichen jon ya na contcüeꞌ tsꞌon tsanꞌñeen jnaanꞌ juu, chichen ntyja ꞌnaan joo ninnquennꞌan nchoꞌnqui vantjoꞌ ñjen tsꞌan na cotsamꞌanhan chaꞌxjen na chuhanꞌ na cotjiꞌhan cüenta na tyiꞌicanhanꞌ na ntcüeꞌ nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ndoꞌ xe na aa mꞌaan ncüii tsanscu na yꞌoon juu nqui xen sꞌon xuee, ndoꞌ xe na aa tëtsu ncüiihanꞌ quiiꞌ vaaꞌ juu, ¿Nin ꞌnan ntsꞌaa juu? ¿Aa chi ntscüꞌa juu chon, ndoꞌ ntca juu, ndoꞌ chen chen ntꞌue juuhanꞌ ata xjen na ntjii ntcüeꞌ juuhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ndoꞌ vi na jndë ntjii juuhanꞌ, ntsitjon juu nnꞌan na ya jñꞌoon yohan yo nnꞌan na mꞌan ndyo vaaꞌ juu, ndoꞌ ngitso juu ndëëhan: Cüineiinꞌ nꞌonhoꞌ yo ja, ee juu xoquituꞌ na tëtsu, jndë ntji ntcüꞌëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Sininntyichen Jesús, tso jon: Matsjö ndëëhoꞌ na nndaꞌ vaa na itsijonhanꞌ na joo ángeles cüentaaꞌ Tyoꞌtsꞌon mꞌanhan na neiinꞌ nꞌonhan ntyja ꞌnaanꞌ ncüii tsanjnan na contcüeꞌ tsꞌon.” ");
INSERT INTO azgNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Sininntyichen Jesús, itso jon: “Tomꞌaan ncüii tsꞌan, tomꞌan ve ntsinda jon yonon. ");
INSERT INTO azgNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Nquii tsanche tso juu nnon tye juu: Nndaꞌ tyeꞌ, joo ꞌnan na tsixuanꞌ na ncyꞌön cüentahanꞌ, ncyahanꞌ nnön. Ndoꞌ joꞌ tꞌon jonhanꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ndoꞌ tyiꞌcovijndye xuee na tui na nndaꞌ, jndëë juu tsoñꞌen ꞌnan na tyincyaa tye juu, ndoꞌ xoquituꞌ na tyꞌoon juu, sitjonꞌ juuhanꞌ, ndë jnduiꞌ juu joꞌ, tja juu ncüiichen tsonnangue na tycya. Joꞌ siquitsu juu xoquituꞌ ꞌnaanꞌ juu na minncyantyi totsꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Majoꞌ vi na jndë jndyueñꞌenhanꞌ na siquitsu juu, jndyo ncüii jndoꞌ tꞌman na ninvaa ndyuaaꞌñeen. Ndoꞌ tyeꞌ na toquenon juu naviꞌ ngꞌe tanin ꞌnan ya na ninjntꞌuehin. ");
INSERT INTO azgNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Joꞌ tja juu, taqueeꞌto juu na ntsꞌaa juu moso ꞌnaanꞌ ncüii tsꞌan juu ndyuaaꞌñeen. Tsanꞌñeen tꞌua jon tsꞌian nnon juu na ngüantyjeeꞌ juu quintcu jndëë ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Tontꞌue jndyi tsꞌon juu na ntcüaꞌ juu min veꞌ nchuaaꞌ joo të na cocüaꞌ quintcuꞌñeen. Majoꞌ minꞌncüii tsꞌan taꞌnan tyincyaa ꞌnan na ntcüaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Yajoꞌ tyꞌoon juu na jndaꞌ xquen juu, sitiu ya juu ncüii: “Vaaꞌ tyëhöꞌ jndye mosooꞌ jon mꞌan. Cocüaꞌcjohin ata min ꞌnan na ꞌndyichenhanꞌ, ndoꞌ ntjoohin na mꞌan, maninꞌcüꞌiö na ninꞌjntꞌö. ");
INSERT INTO azgNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jeꞌ yuuꞌ nntꞌui ja ntjoohin, ncjö ntcüꞌë na mꞌaan tyëhöꞌ, ndoꞌ ntsjö nnon jon: Nndaꞌ tyeꞌ, jndë sitja ja tonnon Tyoꞌtsꞌon ndoꞌ mantyi yo nnonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nanein tyiꞌquitsixuan na ntsuꞌ jndaꞌ ja. Quitsaꞌ yo ja chaꞌvijon veꞌ ncüii mosoꞌ. Ndöꞌ vaa sitiu juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ndoꞌ tantcüeꞌ juu naijon mꞌaan tye juu. Majoꞌ ninvaa tycya na ndyo juu, ndoꞌ jndyiaaꞌ tye juuhin. Tyioo na tꞌman vaa na ndyiaꞌ juu nchjii jon, jnannon jon, tëtsitjon jonhin. Jndyotsꞌaa jonhin ndoꞌ tꞌu jon quinchooꞌ juu na tyincyaa jon tsꞌonhin. ");
INSERT INTO azgNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ndoꞌ tso juu nnon jon: ꞌUꞌ riiꞌ tyeꞌ, jndë sitja ja tonnon Tyoꞌtsꞌon ndoꞌ mantyi yo tonnonꞌ ncuꞌ. Tyiꞌquitsixuan na ntsuꞌ na jndaꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ndoꞌ vi na jndë sque ntcüeꞌhan vꞌaa, tso tye juu ndëë mosooꞌ jon: Cüa, quinanꞌcjehoꞌ na quindyoyꞌonhoꞌ ndiaa na yantyichen, chi ntcüe juuhanꞌ. Ndoꞌ quityionꞌ tsiꞌxꞌee ntꞌö juu, ndoꞌ quitjueꞌhoꞌ ntcoon ngꞌee juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ndoꞌ mantyi quitsacyꞌonhoꞌ toro chjo na tꞌuein, quinanꞌcueeꞌhoꞌ juu oꞌ. Cüa, nntꞌa nguee ndoꞌ na ntcüꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ee juu jndahöꞌ, itsijonhanꞌhin chaꞌvijon tsꞌan na jndë tueꞌ, ndoꞌ vandoꞌ nndaꞌ juu, chaꞌvijon tsꞌan na jndë tsu, majoꞌ tijndaꞌ ntcüeꞌhin. Yajoꞌ taꞌhan na tonanꞌtꞌmaanꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Majoꞌ jnda jon, tsantquechen, tyíꞌcꞌoonhin, tja juu jndëë. Ndoꞌ xjen na jndyo ntcüeꞌ juu, tindyooꞌ juu na mꞌaan vꞌaahan, ndoꞌ jndyii juu na cotjaꞌ ndoꞌ camꞌaan jnon. ");
INSERT INTO azgNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ndoꞌ tqueenꞌ juu ncüii mosohan, taxeeꞌ juu nin ꞌnan condui. ");
INSERT INTO azgNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tꞌa tsanꞌñeen, tso juu: “Juu tyꞌiuꞌ jndë tyjeeꞌ ntcüeꞌ juu ndoꞌ tyeꞌhoꞌ, jndë iscueeꞌ jon toro chjo na tꞌuein ee ya ro tyjeeꞌ ntcüeꞌ juu, tyiꞌviiꞌ juu.” ");
INSERT INTO azgNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Majoꞌ juu tsantquechen, sivꞌii jndyi juu, min tyiꞌjeꞌcaqueeꞌ juu quiiꞌ vꞌaa. Ndoꞌ na nndaꞌ, joꞌ jnduiꞌ tye juu, sꞌaa jndyi jon tyꞌoohin na caqueeꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Majoꞌ tꞌa juu ꞌndyo jon, tso juu: “Quenꞌ cüenta, tijndye chu na matyeꞌntjön ja nnonꞌ. Tacotsiqueꞌ tsꞌön yo tsꞌian na tjiꞌ nnön. Majoꞌ minꞌjon taconcyaꞌ min veꞌ quinchꞌiondyua na chi ntscüꞌë na ntsꞌa nguee na ntsitꞌmanꞌ chjo ja yo ntyjë na ya jñꞌoonhan yo ja. ");
INSERT INTO azgNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Majoꞌ nein na jndë tyjeeꞌ ntcüeꞌ juu jndaꞌhöꞌ na tatsiquitsu juu ꞌnanꞌ yo nanntcuntjaaꞌ, ata toro na tꞌuein jndë scueꞌ cüentaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ndoꞌ joꞌ tꞌa tye juu, itso jon: “ꞌUꞌ jnda, ninnquiiꞌchen mꞌanꞌ yo ja ndoꞌ tsoñꞌen ꞌnan njan, ꞌuꞌ maꞌnanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Majoꞌ chuhanꞌ na cꞌön jaa na nënhën ndoꞌ na quinanꞌtꞌmaanꞌ jaa ngꞌe juu tyꞌiuꞌhöꞌ, chaꞌvijon jndë tueꞌ juu ndoꞌ na vandoꞌ nndaꞌ juu, chaꞌvijon na jndë tsuhin, majoꞌ jndë tijndaꞌ ntcüeꞌhin.” ");
INSERT INTO azgNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mantyi sininntyichen Jesús ndëë nnꞌan na conanꞌjon yo jñꞌoon na toninncyaa jon, tso jon: —Tomꞌaan ncüii tsantya ndoꞌ mꞌaan ncüii mosotque ꞌnaanꞌ jon. Tyenanꞌquindyii nnꞌanhin na veꞌ itsꞌaa ya juu na tsiquitsu juu ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ndoꞌ na nndaꞌ, tqueenꞌ tsantyaꞌñeenhin, tso jon nnon juu: “¿Nchu vaa jñꞌoon na condue nnꞌan nacjoꞌ? Quitsiaꞌ ncüii lista, chen chen cüjiꞌ ntyja ꞌnaanꞌ xoquituꞌ na tyonꞌ cüenta yo tsaꞌnndaꞌ na siquitsuꞌ, ee taxeꞌcüitquentyichen ꞌuꞌ ndëë moso.” ");
INSERT INTO azgNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ndoꞌ juu mosotqueꞌñeen, sitiu ya juu ncüii: “¿Nchu ntsꞌa chaꞌ ngüantꞌö? Ee patrón njan icüjiꞌ jon ja na condui ja mosotque. Taꞌnan na jndö na ntsꞌa tsꞌian jndëë chaꞌ ngüantjön ꞌnan na icanhanꞌ ja, ndoꞌ jnꞌan jndyi na veꞌ ntcꞌan ꞌndyö ꞌnan ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nanein mavaaꞌ tsꞌön nchu vaa ntsꞌa chaꞌ ntixeeꞌ nnꞌan ja quiiꞌ ntꞌaahan vi na jndë jntyꞌiihanꞌ ja na condui ja mosotque.” ");
INSERT INTO azgNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Yajoꞌ tqueenꞌ jon ncüii ro ncüii nnꞌan na chojnan nnon patrón ꞌnaanꞌ juu. Taxeeꞌ juu nnon tsan na vejndyee: “¿Nchu xjen chuꞌjnanꞌ nnon patrón njan?” ");
INSERT INTO azgNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tꞌa tsanꞌñeen ꞌndyo juu: “Ja chöjnan ncüii ciento ncjo na tooꞌhanꞌ yo nchenꞌ nꞌoon olivos.” Ndoꞌ tso juu nnon tsanꞌñeen: “Ndö juu tson na chuuꞌ tsaꞌnndaꞌ na chuꞌjnanꞌ. Quijmanꞌ, cje ro cüjiꞌ xcoꞌhanꞌ na ninvennꞌan nchoꞌnqui ncjo nchenꞌ na chuꞌjnanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jndë joꞌ taxeeꞌ juu nnon ncüiichen mosoꞌñeen: “Ndoꞌ ꞌuꞌ jeꞌ, ¿Tsaꞌnndaꞌ chuꞌjnanꞌ?” Tꞌa tsanꞌñeen ꞌndyo juu: “Ja chöjnan ncüii ciento xu ntquen trigo.” Yajoꞌ tso juu nnon tsanꞌñeen: “Ndö tson na chuuꞌ nchu xjen na chuꞌjnanꞌ. Cyonꞌhanꞌ. Cüjiꞌ xcoꞌ na ninnenquennꞌan xu na chuꞌjnanꞌ.” Ndöꞌ vaa na tso tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ndoꞌ juu tsantyaꞌñeen tso jon na juu mosoꞌñeen tyꞌoon juu na jndaꞌ xquen juu min na siviꞌnnꞌan juu ntyja tsꞌian ꞌnaanꞌ jon na sꞌaa juu. Ee nnꞌan na mꞌan ntyja ꞌnaanꞌ tsonnanguevahin, jndaꞌntyichen nquenhan yo ntyjehan, chito nnꞌan na conanꞌjonhan ntyja ꞌnaanꞌ nquii jon na conduihin naxuee.” ");
INSERT INTO azgNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Itsontyichen Jesús: “Ndö vaa na matsiquiꞌmanꞌ jahoꞌ, joo ꞌnan na conanꞌchohoꞌ na nanꞌxuanhanꞌ ntyja ꞌnaanꞌ tsonnangue jnan, cüijntꞌuehoꞌhanꞌ na ntantjonhoꞌ jndye nnꞌan na ya jñꞌoonhan yo ꞌoꞌ. Yajoꞌ juu ꞌnan na nanꞌxuanhoꞌ, xjen na ntycüiihanꞌ, nque nanꞌñeen na tejndeihoꞌhin, ncyꞌonhan cüentahoꞌ naijon na tyiꞌquintycüii na ncꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Minninchen tsꞌan na conduihin na itsiquindë juu ncüii jñꞌoon na tyiꞌtꞌman, mantyi ntsiquindë juu ncüii jñꞌoon na tꞌman tsixuanhanꞌ. Majoꞌ minninchen tsꞌan na itsiviꞌnnꞌan juu ntyja ꞌnaanꞌ ncüii jñꞌoon na tyiꞌtꞌmanhanꞌ, mantyi ntsiviꞌnnꞌan juu ntyja ꞌnaanꞌ jñꞌoon na tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Joꞌ ntyja ꞌnaanꞌ na ndijntꞌue tsꞌan ꞌnan na nque nnꞌan tsonnangue cotjiꞌhan cüenta na njon jndyihanꞌ, xe na aa tyiꞌcüijntꞌuehoꞌhanꞌ chaꞌxjen na chuhanꞌ, yajoꞌ joo ꞌnan na mayuuꞌ na njon jndyi conduihanꞌ, min jeꞌquiꞌndyii Tyoꞌtsꞌonhanꞌ nduehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ndoꞌ joo ꞌnan ntyja ꞌnaanꞌ tsonnangue, xe na aa tyiꞌcovijntꞌuehoꞌhanꞌ chaꞌxjen na chuhanꞌ, yajoꞌ joo ꞌnan na njon jndyi, taꞌnan tsꞌan na ninncyaahanꞌ ndueehoꞌ na nanꞌxuanhanꞌ cüentahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Taꞌnan tsꞌan na nndëë ntyeꞌntjon nnon ve patrón. Ee ncꞌoon juu na jndooꞌ juu ncüiihan, ndoꞌ ncüiichenhan ncꞌoon na viꞌntyjii jndyi juuhin. Oo ngayꞌoon juu jñꞌoon yo ncüiihan ndoꞌ ncüiichenhin ncꞌoon juu na tyiꞌcueeꞌ tsꞌon juu. Tyiꞌjeꞌquindëë ntyeꞌntjonhoꞌ nnon Tyoꞌtsꞌon, ndoꞌ mantyi conanꞌchonhoꞌ na nintyahoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nnꞌan na conduihan tmaanꞌ fariseos na mꞌanhin joꞌ, tondyehan tsochen jñꞌoonminꞌ na sinin Jesús. Ngꞌe na viꞌ jndyi nꞌonhan yo xoquituꞌ, joꞌ tonanꞌcüejnaanꞌhin jon. ");
INSERT INTO azgNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Itso jon ndëëhan: “ꞌOꞌ ntꞌue nꞌonhoꞌ na quitjiꞌ nnꞌan cüenta na jeꞌ contꞌahoꞌ chaꞌxjen na chuhanꞌ, majoꞌ nquii Tyoꞌtsꞌon ivaaꞌ tsꞌon jon nchu vaa nanꞌxuanhoꞌ. Nnꞌan tsonnanngue, ꞌnan na cotjiꞌhin cüenta na njon jndyi nanꞌxuanhanꞌ, joohanꞌ indyiaaꞌ ndyaꞌ Tyoꞌtsꞌonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ata xjen na tomꞌaan Juan, juu jñꞌoon na tquen Moisés icoꞌxenhanꞌ, tonanꞌyꞌonhoꞌhanꞌ yo jñꞌoon jndyue nnꞌan na toninncya jñꞌoon nchu vaa ꞌnan na nnguaa. Juu xjen na tomꞌaan Juanꞌñeen, tyeꞌ na condinein jñꞌoon naya ntyja na ityeꞌntjon Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. Ndoꞌ icanhanꞌ na quitquen yantyihan ncüii chaꞌ ndëë nduihan nnꞌan na ntyeꞌntjon jonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Quitquenhoꞌ cüenta, quiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon min ntji naquijndëhanꞌ. Majoꞌ ntsiquindëñꞌenhanꞌ joohanꞌ. Ee tyiꞌjndyaaꞌchen na ngitsu tsjöꞌndue yo tsonnangue, chichen na nꞌndyihanꞌ ncüii ntji chjo na tꞌuiiꞌ quiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Minninchen tsꞌan na ntsityuiiꞌ tson na toco yo scuuꞌ ndoꞌ ngoco nndaꞌ juu yo ncüiichen tsanscu, itsijndaꞌhanꞌ ntyja ꞌnaanꞌ tsanꞌñeen na veꞌ ndöꞌ ro mꞌaan juu yo ncüiichen tsanscuꞌñeen. Ndoꞌ minꞌcya ro tsansꞌa na ngoco juu yo tsanscuꞌñeen na jndë tyuiiꞌ tson ꞌnaanꞌ juu yo saaꞌ juu, mantyi itsijndaꞌhanꞌ ntyja ꞌnaanꞌ tsanꞌñeen na conduihin tsꞌan na veꞌ ndöꞌ ro mꞌaan juu yo tsanscuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Ncüii jon tomꞌaan ncüii tsantya na ninnquiiꞌchen ndiaa na yantyi tocüe jon ndoꞌ njon jndyihanꞌ. Tincüii xee yu, ꞌnan na yantyichen contyjo nnon mesa na tocüaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ndoꞌ ndyo teon vaaꞌ tsanꞌñeen, tyequitquen nnꞌan ncüii tsanjñenꞌ, tovaa juu joꞌ, Lázaro jndyu juu. Nin vaa siꞌtsꞌo ꞌnaanꞌ juu min ntyjeꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ntyja jndyi tsꞌon juu min veꞌ ꞌnan quijndë na cocyaa tocjeeꞌ mesa ꞌnaanꞌ tsantyaꞌhin na ntcüaꞌ juu. Ndoꞌ sque quindueꞌ, jndyoquityue oꞌ ntyjeꞌ na chu juu. ");
INSERT INTO azgNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ndoꞌ tueeꞌ xjen na tueꞌ juu tsanjñenꞌñeen, ndoꞌ nque ángeles tyeyꞌonhan ñuan ꞌnaanꞌ juu naijon mꞌaan nquii Abraham. Mantyi tueꞌ tsantya ndoꞌ tëntyꞌiuhin. ");
INSERT INTO azgNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Viochen xjen na toquenon jon naviꞌ naijon na coꞌo nnꞌan na jndë tjë, jndondë jon, jndyiaaꞌ tycya jon na mꞌaan Lázaro ngiaaꞌ Abraham. ");
INSERT INTO azgNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ndoꞌ sixuaa jon, itso jon: ꞌUꞌ ta Abraham, cꞌonꞌ na ntyꞌia rö nchjiꞌ. Quitsaꞌ vi nayaꞌñeen, quijñonꞌ Lázaro na veꞌ ncüii ndëëntꞌö juu quinchje juu quiiꞌ ndaa chaꞌ ntsiquindaaꞌ juu tsa. Ee jaaꞌ jndyi naviꞌ na maquenön quiiꞌ juu chonvahin. ");
INSERT INTO azgNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Majoꞌ tꞌa Abraham, tso jon: ꞌUꞌ jnda, chen chen cañjoonꞌ tsonꞌ joo naya na tyonꞌ cüenta xjen na tovandoꞌ, ndoꞌ Lázaro viꞌ toquenon juu. Majoꞌ nein ivajndyee juu ntjoo ndoꞌ ꞌuꞌ jeꞌ, viꞌ maquenoonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ndoꞌ mantyi vaa ncüiichen ꞌnan. Quityquiiꞌ ntꞌán yo ꞌoꞌ, vaa ncüii tsëꞌtsjoon na tayuu ntycüii na njoonhanꞌ chaꞌ nin já na ninꞌquitsquë́ na mꞌanhoꞌ, jeꞌquindëë ngüenö́nhanꞌ. Ndoꞌ min nque nnꞌan na mꞌan naijon na mꞌanhoꞌ, jeꞌquindëë ngüenonhin ntyjava. ");
INSERT INTO azgNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ndoꞌ joꞌ tꞌa tsanꞌñeen, itso juu: Ngꞌe na nndaꞌ, ta, matsꞌa tyꞌoo ꞌuꞌ, cüa, cꞌuaꞌ tsꞌian nnon juu na cja juu na mꞌan nnꞌan vaaꞌ tsotyë, ");
INSERT INTO azgNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Ee joꞌ mꞌaan ꞌon ntyjö ncö. Cjancyaa juu jñꞌoon ndëëhan chaꞌ tyiꞌntsquehan ntjoohin naijon na ji va jndyi ꞌnan na maquenön. ");
INSERT INTO azgNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Majoꞌ sintcüeꞌ Abraham jñꞌoon nnon juu: Conanꞌyꞌonhan joo jñꞌoon na jndui na toninncyaa Moisés yo ninꞌjñꞌoon na toninncya nnꞌan na tonduehan nchu vaa ꞌnan na nguaa. Joo jñꞌoonꞌñeen quindyehinhanꞌ ndoꞌ quitaꞌngueeꞌhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Majoꞌ tꞌa tsantyaꞌñeen, itso juu: Tyiꞌyuuꞌ ta, xe ncüii joo nnꞌan na jndë tjë ncja na mꞌanhan, jñꞌoon na mayuuꞌ nntcüeꞌ nꞌonhan jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ndoꞌ tꞌa Abraham ꞌndyo juu: Xe tyiꞌquinanꞌjñꞌoonꞌhan joo jñꞌoon na toninncyaa Moisés yo mañoon nnꞌan na toninncyahan jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa, mantyi min xeꞌquindyehan jñꞌoon ꞌndyo ncꞌüii tsꞌan min na ngüandoꞌ xco juu.” ");
INSERT INTO azgNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ndoꞌ tso Jesús ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon: “Tyiꞌjeꞌcacüentyjeeꞌ na ninꞌcjachuhanꞌ nnꞌan na conanꞌtjahan nnon Tyoꞌtsꞌon, majoꞌ viꞌ jndyi ngenon juu tsꞌan na itsiquitaꞌ jñꞌoon na ntycyaa nnꞌan na nnanꞌtjahan. ");
INSERT INTO azgNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ntyja ꞌnaanꞌ juu tsanꞌñeen, yantyi xe na aa quinanꞌtyen nnꞌan ncüii tosu xtyoꞌ juu ndoꞌ quitjueꞌ nanꞌñeenhin quityquiiꞌ ndaandue. Ee viꞌntyi ngenon juu na ntsꞌaa juu ꞌnan na ntsquiooꞌhanꞌ minninchen nnꞌan na chjo vantyja nꞌonhan ja. ");
INSERT INTO azgNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Joꞌ quitquen nquehoꞌ cüenta ntyja nchu vaa na cotsamꞌanhoꞌ. “Xe ncüii ntyjehoꞌ na vantyja tsꞌon Tyoꞌtsꞌon itsitjahin nnonꞌ, quitsiquiꞌmanꞌhin. Ndoꞌ xe na aa contcüeꞌ tsꞌon juu, quitsitꞌman tsonꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ndoꞌ xe na aa ntyqueꞌ jnda na itsitjahin nnonꞌ na ncüii xuee, ndoꞌ ncüii cüii jon ngaquitso juu nnonꞌ: Quitsitꞌman tsonꞌ ja, contcüeꞌ tsꞌön na sitja ja nnonꞌ, chuhanꞌ na quitsitꞌman tsonꞌhin.” ");
INSERT INTO azgNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nnꞌan na nchoꞌve na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, jnduehan nnon jon: —Ncyaꞌ na nditꞌmanntyichen na covantyja nꞌö́n. ");
INSERT INTO azgNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Joꞌ tꞌa jon jndyuehan, tso jon: —Min xe na aa chjo na covantyja nꞌonhoꞌ, min veꞌ chaꞌxjen na chjo ncüii ntquen mostaza, majoꞌ tꞌman tsꞌian nndëë ntꞌahoꞌ. Ata nnon tsꞌoon tꞌmanva nndëë nnduehoꞌ: “Quenanꞌ ꞌuꞌ ntjoohin ndoꞌ cacüentyjeꞌ quiiꞌ ndaandue.” Ndoꞌ minchuchen ntsiquindëhanꞌ chaꞌxjen na conduehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Cüa, quinduë ncüiihoꞌ mꞌaan moso ꞌnaanꞌ na itsitiuu juu tyuaa oo ivantyjeeꞌ juu choꞌ ntsjuenꞌ tojndëë. Ndoꞌ vi na jndë tyjeeꞌ juu na jnan juu jndëë, ¿Aa ntsꞌaahanꞌ na ntsuꞌ nnon juu: “Cüa, cüenoonꞌ ndö, quijmanꞌ mesa na ntcüaꞌ?” ");
INSERT INTO azgNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Aa chi ngitso jndyee patrónꞌñeen nnon juu: “Cüa ra, quitsijndaꞌ ꞌuꞌ, quitsijñꞌonꞌ na ntcüꞌa? Ndoꞌ vi na jndë tcüꞌa ndoꞌ jndë tꞌua, yajoꞌ chi ntcüaꞌ ndoꞌ ncꞌüaꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Min tatyincyaa jon naya juu mosoꞌñeen na siquindë juu tsꞌian na tꞌua jon nnon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mantyi ꞌoꞌ ya na jndë jntꞌahoꞌ tsoñꞌen na icoꞌxen Tyoꞌtsꞌon na quintꞌahoꞌ, joꞌ quinduehoꞌ: “Aa jaa na cotyeꞌntjön, tyiꞌquinanꞌxuan na ngitso tsꞌan na taquinjonꞌ na contꞌa, ee xiaꞌntyi jndë jntꞌa chaꞌxjen na chuhanꞌ na quintꞌa.” ");
INSERT INTO azgNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Xjen na ñjon Jesús nato na vja jon Jerusalén, tenon jon tyonco ndyuaa Samaria yo Galilea. ");
INSERT INTO azgNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Juu xjen na vaqueeꞌ jon ncüii tsjoon chjo, tjonhin nqui nnꞌan na chohan tycu ndö cotöꞌ, tyecüentyjeeꞌ tycyahan. ");
INSERT INTO azgNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jndei jnanꞌxuaahan, jnduehan: —ꞌUꞌ Jesús na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, cꞌonꞌ na ntyꞌiá rö́ nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ya na jndyiaaꞌ Jesús joohan, tso jon ndëëhan: —Quitsananꞌman nquehoꞌ ndëë ntyee. Ndoꞌ viochen xjen na coꞌohan, jnꞌmanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Majoꞌ ncüii joo nanꞌñeen, xjen na tyincyaa juu cüenta na jndë jnꞌman juu, tantcüeꞌ juu. Jndei cꞌua ꞌndyo juu na totsitꞌmaanꞌ juu Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tcoꞌxtye juu tonnon Jesús, tyincyaa juu na ncya ya jon. Ndoꞌ juu tsanꞌñeen conduihin tsꞌan Samaria. ");
INSERT INTO azgNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ndoꞌ taxeeꞌ Jesús: —¿Aa chito nchaꞌvaa nqui nanꞌñeen jnꞌmanhan? Ndoꞌ ñjenchenhin jeꞌ, ¿Yuu mꞌanhan? ");
INSERT INTO azgNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Juu tsanvahin chito conduihin tsꞌan judío, majoꞌ jndyo ntcüeꞌ juu na itsitꞌmaanꞌ juu Tyoꞌtsꞌon. Majoꞌ ñjen nanꞌñeen veꞌ tyꞌetohan, taꞌnan sque ntcüeꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Yajoꞌ tso Jesús nnon tsanꞌñeen: —Quinaquintyjaꞌ, cja ntcüeꞌ vaꞌ. Ngꞌe na vantyja tsonꞌ ja, joꞌ na jndë jnꞌmanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ncüii jon joo nnꞌan na conduihan tmaanꞌ fariseos taxeeꞌhan nnon Jesús ntyja ꞌnaanꞌ juu na ityeꞌntjon Tyoꞌtsꞌon. Taꞌxeꞌhan ¿yuu xjen ngueꞌntyjahanꞌ? Tꞌa jon jndyuehan, tso jon: —Juu na condui Tyoꞌtsꞌon na ityeꞌntjon jon tsoñꞌen, chito ngꞌe ꞌnan na covityincyooꞌ, joꞌ tsiꞌmanhanꞌ na jndë tyjeeꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Min xeꞌquindue nnꞌan: “Ndö mꞌaan jon oo ndöꞌñeen mꞌaan jon na ityeꞌntjon jon nnꞌan”, ee juu na ityeꞌntjon jon, mꞌaanhanꞌ quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ndoꞌ tso ta Jesús ndëë nnꞌan na tonanꞌjon yo jñꞌoon na toninncyaa jon: —Mangueꞌntyja xjen ya na nnduehoꞌ: “Ntꞌue jndyi nnꞌön na ngueꞌntyja xuee na nndyo nndaꞌ nquii jon na conduihin tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na coꞌxen jon tsoñꞌen nnꞌan.” Majoꞌ xeꞌquijntyꞌiahoꞌ na nnguaa na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ñꞌen nnꞌan na nnduehan ndëëhoꞌ: “Ndöꞌ mꞌaan jon, oo nnduehan ntjoohin mꞌaan jon.” Majoꞌ tyiꞌntsantyjahoꞌ min tyiꞌnanꞌjonhoꞌ yo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ee chaꞌxjen na icoꞌ tsuee chon, itsixueehanꞌ vi ntyjaaꞌ tsjöꞌndue ata ncüiichen ntyja, manndaꞌ vaa ntsijonhanꞌ xjen na nndyö ntcüꞌë. Ninjonto njntyꞌia tsoñꞌen nnꞌan ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Majoꞌ na vejndyee icanhanꞌ na quenön naviꞌ tꞌman ndoꞌ mantyi nnꞌan na mꞌan nanein nntꞌahan na tayuu jntꞌue ja ngiohan. ");
INSERT INTO azgNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Joꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, chaꞌxjen na tomꞌan nnꞌan xjen na tomꞌaan nquii Noé, manndaꞌ vaa ntsijonhanꞌ na ncꞌon nnꞌan xjen na jndë tindyo na ndyö ntcüꞌë. ");
INSERT INTO azgNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Totsamꞌanhan chaꞌxjen na vja tontꞌahan. Tocüaꞌhan, tovehan, totoncohan, toninncyahan ndahan na ntonco joo ata tueeꞌ juu xuee na tua Noé quityquiiꞌ vꞌaandaa. Ndoꞌ tovaꞌtyꞌa, ndoꞌ joo nnꞌan na jntyꞌiihanꞌ, tjëñꞌen nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndoꞌ maninꞌncüii xjen tontꞌa nnꞌan xjen na tomꞌaan Lot. Tocüaꞌhan, tovehan. Tonanꞌjndahan ꞌnan ndoꞌ tondëëhinhanꞌ. Tononhin ntjon, tonanꞌyahan ntꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Majoꞌ juu xuee ya na tjiꞌ Tyoꞌtsꞌon Lot tsjoon Sodoma, tyioo ndaatsuaꞌ chon yo sufre na jnanhanꞌ tsjöꞌndue. Ndoꞌ iscüjeñꞌenhanꞌ nnꞌan na mꞌan juu tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, manndaꞌ itsijonhanꞌ na nnguaa juu xuee ya na njntyꞌia nndaꞌ nnꞌan ja. ");
INSERT INTO azgNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Juu xueeꞌñeen, tsꞌan na mꞌaan chꞌen, tyiꞌngaqueeꞌ nndaꞌ juu quiiꞌ vaaꞌ juu na ncüjiꞌ juu ꞌnaanꞌ juu. Tyiꞌnguaa ntyjii juu ntyja ꞌnaanhanꞌ. Ndoꞌ majoꞌntyi tsꞌan na mꞌaan tojndëë, tyiꞌndyo ntcüeꞌ juu chaꞌ ndyoquichu juu ꞌnaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cañjoonꞌ ya nꞌonhoꞌ nin ꞌnan na tquenon juu scuuꞌ Lot. ");
INSERT INTO azgNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Minninchen tsꞌan na intꞌue nquii juu nchu vaa ntsꞌaa juu chaꞌ tyiꞌquitsuhin, jñꞌoon na mayuuꞌ ngitsuhin. Majoꞌ minninchen tsꞌan na incyaa juu na quenon juu minꞌcya ro ꞌnan na ngenon juu, tsanꞌñeen ntsinꞌman Tyoꞌtsꞌon ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, juu tijaanꞌñeen, ya na nndyö nntꞌa, ve nnꞌan na manꞌhin condahan, ncüii tsanꞌñeen vjayꞌoonhanꞌhin na mꞌan, ndoꞌ ncüiichenhin nꞌndyiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ve nanntcu tojnaanꞌ cotuahan, ncüii tsanꞌñeen vjayꞌoonhanꞌhin na mꞌan, ndoꞌ ncüiichenhin nꞌndyiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ve nannon mꞌan jndëë na contꞌahan tsꞌian, ncüii tsanꞌñeen vjayꞌoonhanꞌhin na mꞌan, ndoꞌ ncüiichenhin nꞌndyiihanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ndoꞌ nnꞌan na tonanꞌjon yo jñꞌoon na toninncyaa jon, taxeeꞌhan nnon jon: —Ta, ¿Yuu vijon na nndui na nndaꞌ? Joꞌ tꞌa jon jndyuehan ncüii jñꞌoon na tyiꞌquitso nquiiꞌ jonhanꞌ na tsiꞌmanhanꞌ na ntcoꞌxenhanꞌ nnꞌan. Tso jon: —Navijon na vendyuaa ꞌnan töꞌ, joꞌ ngancüi ntꞌën. ");
INSERT INTO azgNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ndoꞌ sinin Jesús ncüiichen jñꞌoon na tyiꞌquitsiꞌman nquiiꞌhanꞌ na itsiꞌquindyihanꞌ na ninnquiiꞌchen quinanꞌnein nnꞌan nnon Tyoꞌtsꞌon, min tyiꞌnanꞌntyquenhan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tso jon ndëëhan: “Tomꞌaan ncüii jüe ncüii tsjoon tꞌman. Tyiꞌncyaaꞌ juu Tyoꞌtsꞌon min tyiꞌcꞌoonꞌ tsꞌon juu nchu vaa na conanꞌtiu nnꞌan yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ndoꞌ juu tsjoonꞌñeen mantyi tomꞌaan ncüii tsanscu ninnquii. Toca juu na mꞌaan jüeꞌñeen na totso juu nnon jon: Cüañonꞌ chjo ja ntyja ꞌnaanꞌ quintu na tjiꞌ tsꞌan cjö. ");
INSERT INTO azgNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ndoꞌ nquii jüeꞌñeen, majndye xuee tasijñꞌoonꞌ jon juu ꞌnan na ican tsanscuꞌñeen. Jndë joꞌ sitiu nquii jon ncüii, tso jon: Ja min na tyiꞌncya Tyoꞌtsꞌon ndoꞌ min taquitsꞌaahanꞌ ja nchu vaa cotjiꞌ nnꞌan cüenta yo ntyja njan, ");
INSERT INTO azgNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Majoꞌ veꞌ ngꞌe itscüetëꞌ jndyi tsanscuvaꞌ ja, joꞌ ngüañꞌöntöhin ncüii na tyiꞌcontycüii na tꞌman tsꞌönhin, ee xe tyiꞌntsꞌa na nndaꞌ, ntscüejndyaaꞌ juu ja na ninnquiiꞌchen ndyotsintyjaanꞌ juu ja.” ");
INSERT INTO azgNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ndoꞌ tsontyichen ta Jesús: “Nquii jüeꞌñeen, min na conduihin tsꞌan na itsꞌaa jon ꞌnan na tyiꞌquichuhanꞌ, majoꞌ ¿Aa cotquenhoꞌ cüenta na tso jon na ngüañoonꞌ jnan jon juu tsanscuꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ngꞌe na nndaꞌ, nquii Tyoꞌtsꞌon jeꞌ, ¿Aa chi majndeichen ngüañoonꞌ jon nque nnꞌan na jndë tji jonhin cüentaaꞌ nquii jon na contcüiiꞌhan jon naxuee ndoꞌ natsjon? Tyiꞌxeꞌquitsꞌaa jon na mavio xjen na ngüendooꞌhan na ntsijñꞌoonꞌ jon joo jñꞌoon na cotanhan na quitejndei jonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ na maquintyjachen ntsijñꞌoonꞌ jonhan. Majoꞌ min na nndaꞌ, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, ya na nndyö ntcüꞌë tsonnangue, ¿Aa nninjndaꞌ nnꞌan na vantyja nꞌonhan Jon?” ");
INSERT INTO azgNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mantyi ndö vaa ncüiichen jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ na sinin Jesús ndëë nnꞌan na tonanꞌtiuhan na xiaꞌntyi nquehan contꞌahan chaꞌxjen na chuhanꞌ, majoꞌ conduehan na tyiꞌquinjon mañoon nnꞌan, nquehan na njonchen. ");
INSERT INTO azgNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Tso jon: “Tomꞌaan ncuii tsꞌan na conduihin tmaanꞌ fariseos ndoꞌ mantyi tomꞌaan ncüii tsꞌan ique sꞌon cüentaaꞌ gobiernon tsjoon Roma. Tyꞌehan vatsꞌon tꞌman na nnanꞌneinhan nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ndoꞌ juu fariseoꞌñeen tacüentyjeeꞌ juu, sinin juu nnon Tyoꞌtsꞌon ntyja ꞌnaanꞌ nquii juu. Ndö vaa na tso juu: ꞌUꞌ Tyoꞌtsꞌon, ncya ya ꞌuꞌ ngꞌe tyiꞌquitsixuan chaꞌna minndyechen nnꞌan, na contyꞌueehan, nnꞌan na contꞌa ꞌnan na tyiꞌquichuhanꞌ, nnꞌan na veꞌ ndöꞌ ro mꞌanhan yo ntyjehan, ndoꞌ min chaꞌna tsanvaꞌ, tsan ique sꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ja matscüejndoꞌ ja ve jnda na ncüii soana, ndoꞌ mantyi mancya diezmo tsoñꞌen na mavantyjön. Ndöꞌ vaa jñꞌoon na sinin tsanꞌñeen nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Majoꞌ juu tsanꞌñeen tsan na ique sꞌon, toxenꞌchen tacüentyjeeꞌ juu, min na nndondë juu tsjöꞌndue, taꞌnan. Veꞌ tominꞌ juu ndaꞌ tsiꞌjndya juu na totsindyiaꞌhin. Tso juu: ꞌUꞌ Tyoꞌtsꞌon, cꞌonꞌ na ntyꞌia rö nchjiꞌ ngꞌe tsꞌan jnan ja. ");
INSERT INTO azgNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Tsontyichen Jesús: “Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, juu tsanꞌñeen tantcüeꞌ juu vaaꞌ juu na tquen Tyoꞌtsꞌonhin na jndyoyuhin na tonnon jon, chito juu fariseoꞌñeen. Ee minꞌcya ro tsꞌan na itsivendye nquiihin, mancüiixjen ntsquioo Tyoꞌtsꞌonhin. Ndoꞌ nin juu na ijuꞌcjehin, jñꞌoon na mayuuꞌ ntsivendye jonhin.” ");
INSERT INTO azgNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Jndyocho nnꞌan yotsca na mꞌaan Jesús, tanhan na quityio jon ntꞌö jon nacjo joo. Majoꞌ nque nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, xjen na jntyꞌiahan na nndaꞌ, jnduehan ndëë nanꞌñeen na tyiꞌnanꞌchjuhan jon. ");
INSERT INTO azgNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Joꞌ tꞌman Jesús nanꞌñeen, tso jon ndëëhan: —Ncyahoꞌ na ninncyo yotsca na mꞌan ja, tyiꞌnanꞌntcüeꞌhoꞌhin, ee quityquiiꞌ juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan, xiaꞌntyi nque nnꞌan na ntyja nꞌonhan ja chaꞌxjen contꞌa yotscamin, joo nanꞌñeen vanaan na conanꞌjonhan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minninchen tsꞌan na tyiꞌntyjaaꞌ juu Tyoꞌtsꞌon chaꞌna contyjaaꞌ yotsca tye joo yo ndyee joo, tyiꞌjeꞌquindëë ntsijon tsanꞌñeen ntyja na ityeꞌntjon Tyoꞌtsꞌon nnꞌan nchu vaa na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Ncüii tsꞌan judío na conintquehin, taxeeꞌ juu nnon Jesús: —ꞌUꞌ ta na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon na ya tsꞌan ꞌuꞌ, ¿Nin ꞌnan icanhanꞌ na quitsꞌa chaꞌ nninncyaa Tyoꞌtsꞌon na ntsixuan na tyiꞌquintycüii na vandoꞌ ñuan njan? ");
INSERT INTO azgNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tꞌa Jesús ꞌndyo juu, tso jon: —¿Ndu na matsuꞌ na condui ja tsꞌan na ya tsꞌanhin? Xiaꞌntyi nquii Tyoꞌtsꞌon conduihin na nndaꞌ, tanin ncüiichen. ");
INSERT INTO azgNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ꞌUꞌ manchjiꞌ juu jñꞌoon na icoꞌxenhanꞌ. Itsohanꞌ: “Tyiꞌncꞌonꞌ yo ncüiichen tsꞌan na veꞌ ndöꞌ ro. Tyiꞌntscueꞌ tsꞌan. Tyiꞌnchꞌueꞌ ꞌnaanꞌ tsꞌan. Tyiꞌntsininꞌ quintu cjooꞌ tsꞌan. Quitsaꞌ na njon nquii tyeꞌ yo ꞌndyoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ndoꞌ tsanꞌñeen jeꞌ, tꞌa juu, tso juu nnon jon: —Tsoñꞌen jñꞌoonminꞌ mavancꞌuëꞌhanꞌ ninvaa xjen na tichjo ja. ");
INSERT INTO azgNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Ndoꞌ vi na jndë jndyii Jesús jñꞌoonvaꞌ, itso jon: —Ncüii vaa na icanhanꞌ na quitsaꞌ. Quijndëꞌ tsoñꞌen ꞌnanꞌ na min, ndoꞌ xoquituꞌ na ngyonꞌ cüenta, ncyaꞌhanꞌ ndëë naninñenꞌ. Na ntsaꞌ na nndaꞌ, yajoꞌ ntsixuanꞌ na tya ꞌuꞌ quiñoonꞌndue. Ndë joꞌ quindyoꞌ na ntsijon ꞌuꞌ yo tsꞌian na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Majoꞌ ya na jndyii tsanꞌñeen jñꞌoonꞌvaꞌ, sichjooꞌ jndyihanꞌ tsꞌon juu, ee tya jndyihin. ");
INSERT INTO azgNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Ndoꞌ vi na jndë tquen Jesús cüenta na nndaꞌ sꞌaahanꞌ tsanꞌñeen, tso jon: —Joo nantya, jndyaaꞌ jndyi na ntaꞌngueeꞌhan na nquii Tyoꞌtsꞌon ntyeꞌntjon jonhan ntyja na cotsamꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Jndyaaꞌntyichen na ncjuꞌcje ncüii tsantya na ntyeꞌntjon Tyoꞌtsꞌonhin, chichen na ngüequindyiꞌ camello tsueꞌ xꞌee tsiꞌncya. ");
INSERT INTO azgNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ndoꞌ nnꞌan na jndyehan na tso jon jñꞌoonvaꞌ, jnduehan nnon jon: —Ndoꞌ na nndaꞌ, ¿Nin juu na nndëë ngitso Tyoꞌtsꞌon na tsixuan juu na jndyoyu conduihin na tonnon jon chaꞌ nndëë ngueeꞌ juu naijon na mꞌaan nquii jon? ");
INSERT INTO azgNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Joꞌ tꞌa Jesús jndyuehan, itso jon: —ꞌNan na ndiquindëë nntꞌa nnꞌan, nquii Tyoꞌtsꞌon condëë itsꞌaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tso Pedro: —Já jndë jntyꞌë́ tsoñꞌen ꞌnan nján chaꞌ condëë cotsayꞌö́n jñꞌoon yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tꞌa Jesús, tso jon ndëëhan: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, minninchen tsꞌan na iꞌndyii vaaꞌ, oo scuuꞌ, oo ntyje nquii, oo tye juu, ndyee juu, oo ntsinda juu ngꞌe na itsijonhin ntyja na ityeꞌntjon Tyoꞌtsꞌon nnꞌan, ");
INSERT INTO azgNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Nanꞌminꞌ jndye veeꞌ jnda ncyꞌoon tsanꞌñeen cüentahanꞌ xjenva, ndoꞌ xuee na tonnonchen, ncyꞌoon juu cüenta na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Tëchu Jesús nnꞌan nchoꞌve vi ntyja naijon na ninnquehan. Tso jon ndëëhan: “Quitquenhoꞌ cüenta, cotsava Jerusalén. Ndoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, juu tsjoonꞌñeen ntsiquindëñꞌenhanꞌ tsoñꞌen jñꞌoon ntyja njan na tji nque nnꞌan na tonanꞌneinhan nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ee ninncya nnꞌan cüenta ja nduee nnꞌan na tachito conduihin nnꞌan judíos, ndoꞌ joo nanꞌñeen nnanꞌcüejnaanꞌhin ja, ndoꞌ ntjueꞌhin ndaajndyuehin ja.” ");
INSERT INTO azgNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ndoꞌ ya na jndë tjaꞌhin ja, nnanꞌcueeꞌhan ja, majoꞌ xuee na jndë ndye ngüantꞌö xcö. ");
INSERT INTO azgNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Majoꞌ joo nnꞌan nchoꞌveꞌñeen, tataaꞌ nꞌonhan nchu vaa itsiquindyi joo jñꞌoonminꞌ na sinin Jesús ndëëhan ee vitjachen na ntsiꞌman Tyoꞌtsꞌon juuhanꞌ ndëëhan. Mangꞌe joꞌ tataaꞌ nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Tyꞌentyihan nato. Ya na tëvindyohan tsjoon Jericó, joꞌ vaquityen ncüii tsannchjaanꞌ ꞌndyo natoꞌñeen, ican juu ꞌnan na itsitjahanꞌhin ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ndoꞌ ya na jndyii juu na jndye jndyi nnꞌan cavenon, taxeeꞌ juu nin ꞌnan condui. ");
INSERT INTO azgNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jnduehan nnon juu: —Nquii Jesús, tsan na jnan Nazaret, jon venon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Xjen na jndyii juu na nndaꞌ, taꞌ juu na sixuaa juu, tso juu: —Nndaꞌ Jesús, ꞌuꞌ na condui ꞌuꞌ tsjan David na jndyocahanꞌ, cꞌonꞌ na ntyꞌia rö nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ndoꞌ joo nnꞌan na veꞌjndyee, jnanꞌtyiaꞌhanhin na quitsichen juu ꞌndyo juu, majoꞌ jndeintyichen sixuaa nndaꞌ juu: —ꞌUꞌ na condui tsjan David na jndyocahanꞌ, cꞌonꞌ na ntyꞌia rö nchjiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Joꞌ tacüentyjeeꞌ Jesús, tꞌua jon tsꞌian ndëë nnꞌan na quindyoyꞌonhan tsanꞌñeen na mꞌaan jon. Ndoꞌ vi na jndë tueeꞌ juu, taxeeꞌ jon nnon juu, tso jon: ");
INSERT INTO azgNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Nin ꞌnan ntꞌue tsonꞌ na quitsꞌa ꞌuꞌ? Tꞌa juu, tso juu: —Nndaꞌ ta, ncyaꞌ na ntyꞌia nntꞌa. ");
INSERT INTO azgNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tꞌa Jesús ꞌndyo juu: —Cꞌonꞌ na ya mandyiaꞌ nndaꞌ. Ngꞌe na mavantyja tsonꞌ ja, joꞌ na jndë jnꞌmanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ndoꞌ ninñoonꞌ tyincyaahanꞌ na jndyiaaꞌ nndaꞌ juu. Tantyja juu toxenꞌ Jesús, totsitꞌmaanꞌ juu Tyoꞌtsꞌon. Ndoꞌ mantyi nque nnꞌan na jndye jndyiꞌhin, ya na jntyꞌia nanꞌñeen na nndaꞌ tui, tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Xjen na tueeꞌ Jesús tsjoon Jericó, vavenon jon tyquiiꞌ tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Joꞌ tomꞌaan ncüii tsꞌan na jndyu Zaqueo. Conintquehin ndëë nnꞌan na cotye sꞌon cüentaaꞌ gobiernon tsjoon Roma. Ndoꞌ tyahin. ");
INSERT INTO azgNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ntꞌue jndyi tsꞌon juu na ndyiaaꞌ juu Jesús, majoꞌ ngꞌe na quilꞌëhin, joꞌ ndiquindëë ndyiaaꞌ juu jon ngꞌe jndye jndyi nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ngꞌe joꞌ jnannon juu, tja juu na tonnonchen, joꞌ tava juu ncüii tsꞌoon na ventyjeeꞌ ꞌndyo nato naijon na ngüenon Jesús, chaꞌ ya nndyiaaꞌ nnon juu jon. ");
INSERT INTO azgNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ndoꞌ xjen na tyjeeꞌ Jesús joꞌ, jndondë jon, tso jon: —ꞌUꞌ Zaqueo, quitsityuaꞌ, quindyoꞌcueeꞌ ee xeevahin icanhanꞌ na ntjo ya ja vaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Joꞌ quintyjachen tacue juu. Yo na neiinꞌ juu tayꞌoon juu Jesús vaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Majoꞌ ya na jntyꞌia nnꞌan na nndaꞌ sꞌaa jon, tsoñꞌenhan tonanꞌneinhan jñꞌoonꞌ jon, jnduehan: —Cüa nquii Jesús, jndë tatsijonhin yo tsꞌan na itsitjahin nnon Tyoꞌtsꞌon na ntixeeꞌ tsanꞌñeenhin. ");
INSERT INTO azgNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Jndë joꞌ, tëcüentyjeeꞌ Zaqueo, tso juu nnon Jesús: —Nndaꞌ ta, xoncüe ꞌnan njan na min, ninncyahanꞌ ndëë nanninñenꞌ, ndoꞌ mantyi minꞌcya ro tsꞌan na siviꞌnnꞌan ja juu na tenoonꞌ na tsjö tsaꞌnndaꞌ na quityion juu nnon gobiernon, nanein ntsintcüꞌëhanꞌ nnon tsanꞌñeen ninque veeꞌ jnda chaꞌxjen na tjiꞌ ja ntꞌö juu. ");
INSERT INTO azgNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Itso Jesús: —Xeevahin juu na itsinꞌman Tyoꞌtsꞌon ñuaan nnꞌan, nque nnꞌan na mꞌan vꞌaavahin, jndë nanꞌxuanhin juuhanꞌ, ee juu ntyjëëhë mantyi conduihin tsjan Abraham na jndyocahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ee ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, jndyoquintꞌuë nnꞌan na jndë cotsu ñuaanhan na ntsinꞌman jahan. ");
INSERT INTO azgNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Joo nnꞌan na tondye jñꞌoonminꞌ, jnanꞌtiuhan na macje njntyꞌia ndëëhan na ntyeꞌntjon Tyoꞌtsꞌon tsoñꞌen, ncüjeeꞌhanꞌ ee jndë mandyo na ngueꞌ Jesús Jerusalén. Mangꞌe joꞌ sininntyichen jon ncüiichen jñꞌoon na quindyehan na tyiꞌquitsiꞌman nquiiꞌhanꞌ juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tso jon ndëëhan: “Tomꞌaan ncüii tsꞌan na tꞌman tonduihin. Sijndaꞌ jon na nnduiꞌ jon ndyuaa ꞌnaanꞌ jon, ncja jon ncüiichen ndyuaa na tycya na ncyꞌoon jon cüenta tsꞌian na ntsixuan jon rey, ndoꞌ ndë joꞌ nndyo nntcüeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Majoꞌ vitjachen na nnduiꞌ jon na ncja jon joꞌ, tꞌman jon nqui nnꞌan na cotyeꞌntjonhan nnon jon. Tꞌman sꞌon tyincyaa jon nnon ncüii cüiihan na veꞌ tejndei ya jonhanꞌ joohan. Tso jon ndëëhan: Quijntꞌuehoꞌ nchu vaa nntꞌahoꞌ na ntantjonhoꞌ yo sꞌonminꞌ viochen xjen na ja tacꞌön. ");
INSERT INTO azgNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Majoꞌ joo nnꞌan ndyuaa tsjoonꞌ jon, jndohanhin. Tꞌuahan tsꞌian ndëë nnꞌan na tentyjahan toxenꞌ jon, jnduehan: Já tyiꞌquintꞌue nꞌö́n na nndui tsanvaꞌ tsꞌan na ityeꞌntjon jon já. ");
INSERT INTO azgNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ndoꞌ juu tsanꞌñeen, vi na jndë tyꞌoon jon cüenta tsꞌian na ntsixuan jon, jndyo ntcüeꞌ jon ndyuaa naijon na jnan jon. Yajoꞌ joo nanꞌñeen na cotyeꞌntjonhan nnon jon na tejndei jon sꞌonhan, tqueenꞌ jonhan. Ngꞌe ninꞌcüaaꞌ tsꞌon jon nchu xjen na tantjon ncüii cüiihan. ");
INSERT INTO azgNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Joꞌ tyjeeꞌ tsan navejndyee, tso juu nnon jon: Nndaꞌ ta, ¿Aa jndë tyjeꞌ? Ndö sꞌon ꞌnanꞌ, nqui veeꞌ jnda tantjön yo joo sꞌon na tyincyaꞌ nnön. ");
INSERT INTO azgNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ndoꞌ tso jon nnon juu: Ya jndyi saꞌ, ꞌuꞌ moso njan, ngꞌe na siquindëꞌ ꞌuꞌ ncüii tsꞌian min na chjohanꞌ, joꞌ na maꞌua tsꞌian nnonꞌ na ntcoꞌxenꞌ nqui njoon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Jndë joꞌ tyjeeꞌ juu tsan na jndë ve, tso juu nnon jon: ¿Aa jndë tyjeꞌ, ta? Ndö sꞌon ꞌnan, ꞌon veeꞌ na tantjön yohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ndoꞌ majoꞌntyi tso jon nnon juu: Naneinhin maꞌua tsꞌian nnonꞌ na ntcoꞌxenꞌ nnꞌan ꞌon njoon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Majoꞌ xjen na tyjeeꞌ ncüiichen tsanꞌñeen, tso juu nnon jon: ¿Aa jndë tyjeꞌ, ta? Ndö sꞌon ꞌnanꞌ, suëhanꞌ quiiꞌ peto. ");
INSERT INTO azgNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ee ncya jndyi ꞌuꞌ xengꞌe ꞌuꞌ tsꞌan na jndeiꞌ ꞌndyo. Ee ꞌuꞌ mayonꞌ cuenta yuu na chito cüentaꞌ. Min na tajnonꞌ ntjon, majoꞌ ꞌuꞌ mancüiixjen matyjeꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ndoꞌ nquii reyꞌñeen, vi na jndë jndyii jon na tso tsanꞌñeen na nndaꞌ, tꞌa jon, tso jon nnon juu: ꞌUꞌ moso njan na tayuu jntꞌue ꞌuꞌ, majuuto jñꞌoon na tsuꞌ ndöꞌ, ntsꞌa na juuhanꞌ quitꞌuiihanꞌ ꞌuꞌ ntyja ꞌnan na saꞌ. Jen mantyjiꞌ na ja tsꞌan na jndeiꞌ ꞌndyö na mayꞌön cüenta yuu na chito cüenta ndoꞌ na mancüiixjen matyjë yuu na chito ja jnꞌön. ");
INSERT INTO azgNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ngꞌe na nndaꞌ nchjiꞌ, ¿Ndu na tatëquityiꞌ joo sꞌon njan naijon na ngüantjonhanꞌ? Ee xe na saꞌ na nndaꞌ, yajoꞌ nein na jndë tyjë, ncyꞌön ntcüꞌë juu sꞌon njan yo jndahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ndoꞌ joꞌ tso jon ndëë minndye nnꞌan na mꞌanhan ngiaaꞌ juu: Cüa, quitjiꞌhoꞌ sꞌon njan ntꞌö tsanvahin ndoꞌ cyahoꞌhanꞌ nnon nquii tsꞌan na nqui veeꞌ jnda tantjon. ");
INSERT INTO azgNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tꞌa nanꞌñeen, jnduehan: Nndaꞌ ta, ¿Ndu na ncyꞌoonntyi jonhanꞌ ndoꞌ jndë yꞌoon jon nqui veeꞌ jnda na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ndoꞌ tꞌa reyꞌñeen, tso jon: Quindyehoꞌ ntsjö ndëëhoꞌ, minninchen tsꞌan na min ꞌnaanꞌ juu, ncyꞌoonntyichen juu cüenta. Majoꞌ juu tsꞌan na taꞌnan ꞌnaanꞌ cuen, nnduiꞌñꞌen chjo ꞌnan na itsitiu juu na tsixuan juu. ");
INSERT INTO azgNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ndoꞌ joo nanꞌñeen na jndohin ja, na tyiꞌquintꞌue nꞌonhan na nditque ja ntyja ꞌnaanhan, quindyochohoꞌhin ntjoohin, ndoꞌ quinanꞌcüjehoꞌhin na tonnön.” ");
INSERT INTO azgNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Vi na jndë sinin Jesús jñꞌoonvaꞌ, tjantyichen jon na vja jon Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Juu xjen na vavindyooꞌ na ngueeꞌ jon tsjoon Betfagé yo Betania, mandyooꞌ tyoꞌ na jndyu Olivos, tꞌua jon tsꞌian ndëë ve nnꞌan na totsayꞌon jñꞌoon yohin na cꞌohan ncüii ntꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tso jon ndëëhan: —Cꞌohoꞌ tsjoon chjo na mꞌaan jndyoyu na tondëëhoꞌ. Ndoꞌ xjen na ntsaqueꞌhoꞌ tyquiiꞌhanꞌ, joꞌ njntyꞌiahoꞌ ncüii snon chjo na tyen oꞌ. Minꞌncüii jnda tacontjo tsꞌan juu oꞌ. Quinanꞌquinanꞌhoꞌ juu oꞌ, ndoꞌ quindyoyꞌonhoꞌ choꞌñeen ntjoohin. ");
INSERT INTO azgNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ndoꞌ xe na aa ngüaxeeꞌ tsꞌan ndëëhoꞌ ndu na conanꞌquinanꞌhoꞌ juu quiooꞌñeen, quinduehoꞌ nnon juu: “Nquii tsꞌan na conduihin na icoꞌxen jon já, nquii jon nninjntꞌuehin juu oꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ndoꞌ tyꞌehan juu ntꞌaa na tꞌua jon ndëëhan, ndoꞌ tijndaꞌ juu snonꞌñeen chaꞌxjen na tso jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ndoꞌ viochen xjen na jnanꞌquinanꞌhin juu isnonꞌñeen, nque nnꞌan na njnuenꞌ oꞌ, jnduehan: —¿Ndu na conanꞌquinanꞌhoꞌ snonvaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Tꞌahan, jnduehan: —Nquii tsan na conduihin na ityeꞌntjon jon já, nquii jon nninjntꞌue yahin juu oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Jndë joꞌ tyeyꞌonhan juu choꞌñeen na mꞌaan Jesús. Ndoꞌ tyiohan ndiaahan naxenꞌ oꞌ, ndoꞌ tantjo jon quiooꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ndoꞌ viochen na venon jon nato, totjiꞌ nnꞌan ndia tonco na cüehan, tonanꞌnueinꞌhinhanꞌ nato na ngüenon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ndoꞌ naijon na tantyqueꞌ nato juu tyoꞌ na jndyu Olivos yuu jon na covityincyooꞌ Jerusalén, tsoñꞌen nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, yo na nein jndyihin taꞌhin jndei tonanꞌxuaahan, tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon ntyja tsoñꞌen tsꞌian tꞌman na jndë jntyꞌia ndëëhan na totsꞌaa Jesús na tyiꞌjeꞌquindëë nnduihanꞌ yo najndei na tsixuan nquii tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jnduehan: —Juu tsanvahin ityio Tyoꞌtsꞌon jnꞌaanhin. Nquii jon na taquintyja na tꞌman conduihin, icüjeeꞌnon jon yo xueeꞌ nquii Tyoꞌtsꞌon na ityeꞌntjon jon tsoñꞌen. Ntyja ꞌnaanꞌ jon, nquii Tyoꞌtsꞌon na mꞌaan quiñoonꞌndue ncyaa jon na tajñuaanꞌ tsꞌon cꞌön na tonnon jon. Conanꞌtꞌmaanꞌ jaa nquii jon na mꞌaan nandyentyichen. ");
INSERT INTO azgNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Majoꞌ minndye nnꞌan na conduihan tmaanꞌ fariseos na mꞌanhan quiiꞌ ntꞌan nnꞌan na jndye jndyiꞌhin, jnduehan nnon Jesús: —ꞌUꞌ na matsiꞌmanꞌ jñꞌoon ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndëë nnꞌan, joo nnꞌan na cotsayꞌon jñꞌoon yo ꞌuꞌ, cüanꞌ ndëëhan na tanduehan jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Majoꞌ tꞌa jon jndyuehan, itso jon: —Quindyehoꞌ ntsjö, xe nnanꞌchen nanminꞌ jndyuehan, yajoꞌ joo ntjöꞌhinꞌ nnanꞌtꞌmaanꞌhanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Xjen na tueeꞌ jon ꞌndyo tsjoon Jerusalén, ndoꞌ xjen jndyiaaꞌ jonhanꞌ, sitꞌioohanꞌhin ntyja ꞌnaan nnꞌan na mꞌan joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Chaꞌvijon ndëë nnꞌan tsjoonꞌñeen sinin jon, tso jon: “Juu xeevahin, xe veꞌ aa taaꞌ nꞌonhoꞌ nchu vaa na icanhanꞌ chaꞌ ntjo yahoꞌ na tonnon Tyoꞌtsꞌon, majoꞌ ndincyaahan na ncüaaꞌ nꞌonhoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ee mangüentyja xjen na joo nnꞌan na jndohan ꞌoꞌ, nnanꞌyahan teonntjöꞌ xiꞌjndio ꞌndyo tsjoonhoꞌ na ntꞌahan tyiaꞌ yohoꞌ ata jeꞌquindëë nnduiꞌhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nnanꞌtyuiiꞌñꞌenhan nnꞌan tsjoonhoꞌ ndoꞌ nnanꞌcüjehan nantque ndoꞌ mantyi yoquijndë ndahoꞌ. Nnanꞌtyuiiꞌhan ntjöꞌ na tijntꞌue na jndë tsjoonhoꞌ, minꞌncüiihanꞌ xeꞌquiꞌndyehan na vaquityenhanꞌ nacjooꞌ tyjehanꞌ. Nndaꞌ ngenonhoꞌ ngꞌe tataaꞌ nꞌonhoꞌ na jñon Tyoꞌtsꞌon ja na ntsinꞌman jon ñuaanhoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jndë na tso jon na nndaꞌ, taqueeꞌ jon juu vatsꞌon tꞌman, joꞌ taꞌ jon tjiꞌ jon nnꞌan chꞌen, joo nnꞌan na condëë ꞌnan quiiꞌ vꞌaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Ndoꞌ tso jon ndëëhan: —Vaa jñꞌoonꞌ Tyoꞌtsꞌon na jndui na itsohanꞌ: “Vꞌa njan conduihanꞌ vꞌaa naijon na conanꞌnein nnꞌan nnon Tyoꞌtsꞌon.” Majoꞌ ꞌoꞌ, itsijonhanꞌ na contꞌahoꞌ juuhanꞌ chaꞌvijon tsëꞌtsjöꞌ yuu jon na cotooꞌ nanntyꞌuee. ");
INSERT INTO azgNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndoꞌ ꞌio ꞌio totsiꞌman Jesús jñꞌoon ndëë nnꞌan quiiꞌ juu vatsꞌon tꞌmanꞌñeen. Majoꞌ nnꞌan na conintque ndëë ntyee ꞌnaan nnꞌan judíos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés yo ninꞌnnꞌan na conintque ndëë nnꞌan tsjoon, tojntꞌue vichen nꞌonhan nchu vaa nquii nntꞌahan chaꞌ nnanꞌcueeꞌhan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Majoꞌ taꞌtaaꞌ nꞌonhan nchu ya nntꞌahan ee tsoñꞌen nnꞌan chen chen totquenhan cüenta juu jñꞌoon na incyaa jon. Ntꞌue nꞌon jndyihan na nndyehan joo jñꞌoonꞌñeen na totsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ncüii xueeꞌñeen tacjuꞌhanꞌ na itsiꞌman Jesús ndëë nnꞌan tyquiiꞌ juu vatsꞌon tꞌmanꞌñeen. Tyincyaa jon jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon ntyja ꞌnaanꞌ na itsinꞌman jon ñuaan nnꞌan. Ndoꞌ nque ntyee na conintque ntyja ꞌnaanꞌ nnꞌan judíos, squenonhan na mꞌaan jon yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, yo ninꞌnnꞌan na conintque ndëë nnꞌan tsjoon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jnduehan nnon jon: —Quitsuꞌ ndë́, ¿Nin naijndei condui ꞌuꞌ na tjiꞌ nanminꞌ quiiꞌ vatsꞌon? Ndoꞌ ¿Nin juu tyincyaa na matsixuanꞌhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","Joꞌ sintcüeꞌ Jesús jñꞌoon ndëëhan, tso jon: —Mantyi ja ngüaxꞌë ncüii jñꞌoon ndëëhoꞌ. Tsꞌian na totsiquindëëꞌ Juan nnꞌan, juu najndei na tonduihin, ¿yuu jnanhanꞌ? ¿Aa nquii Tyoꞌtsꞌon tyincyaa na tonduihin na nndaꞌ, oo aa veꞌ nnꞌan jndue na quitsꞌaa jonhanꞌ? Cüa, quitꞌahoꞌ ndyi. ");
INSERT INTO azgNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Joꞌ joo nanꞌñeen jnanꞌnein nquehan yo ntyjehan, jnduehan: “Xe na aa nnduë nquii Tyoꞌtsꞌon tyincyaa na totsixuan Juan juu tsꞌianꞌñeen, yajoꞌ ngitso tsanvahin ndëë: ¿Ndu na tatëntyja nnꞌön jñꞌoon na toninncyaa jon? ");
INSERT INTO azgNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Majoꞌ xe na aa nnduë nnꞌan jndue na quitsiquindëëꞌ Juanꞌñeen nnꞌan, yajoꞌ tsoñꞌen nnꞌan ntuenꞌhan ntjöꞌ jaa na nnanꞌcüjehan jaa, ee jndë vantyja nꞌonhan na nquii Juan conduihin tsꞌan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nnguaa.” ");
INSERT INTO azgNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ngꞌe na nndaꞌ jnanꞌtiu nanꞌñeen, jnanꞌntcüeꞌhan jñꞌoon nnon Jesús: —Aa já ndicüaaꞌ nꞌö́n nin juu tyincyaa jñꞌoon na quitsiquindëëꞌ tsanꞌñeen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ndoꞌ na jnduehan na nndaꞌ, mantyi sintcüeꞌ ta Jesús jñꞌoon ndëëhan: —Tanin, min xeꞌquitsjö ndëëhoꞌ nin juu tyincyaa najndei na condui ja na matsꞌa nanꞌminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jndë joꞌ taꞌ Jesús, sinin jon jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ ndëë nnꞌan, tso jon: “Tomꞌaan ncüii tsꞌan, juu tsanꞌñeen jnonꞌ jon ntꞌöö tëndöndyooꞌ tsjan tyuaa ꞌnaanꞌ jon. Jndëcya tyincyaa jon cüenta juu ntjonꞌñeen nduee minndye nnꞌan, jndë joꞌ tja jon ncüiichen ndyuaa na majndye xuee. ");
INSERT INTO azgNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Ndoꞌ ya na tentyja xjen na tueꞌ juu ntjonꞌñeen, jñon jon ncüii moso ꞌnaanꞌ jon na mꞌan nanꞌñeen na nninncyahan cüenta ꞌnan na vacüjaꞌhanꞌ jon. Majoꞌ nanꞌñeen jeꞌ, tjaꞌhin juu, jñon ntcüeꞌhanhin na taꞌnan tachu juu. ");
INSERT INTO azgNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Joꞌ jñon nndaꞌ jon ncüiichen mosooꞌ jon. Mantyi tonanꞌcüejnaanꞌhan juu tsanꞌñeen ndoꞌ tjaꞌhanhin. Jndë joꞌ jñon ntcüeꞌhanhin na taꞌnan tachu juu. ");
INSERT INTO azgNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jndëcya nquii tsanꞌñeen jñon nndaꞌ jon ncüiichen moso ꞌnaanꞌ jon na jndë ndye. Juu tsanꞌñeen jnanꞌqueeꞌhanhin, tjiꞌhan juu quiiꞌ ntjonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Na matsꞌia nquii tsanꞌñeen na ꞌnaanꞌ ntjonꞌñeen, sitiu jon: ¿Nin ꞌnan chi ntsꞌa ja? Ndö vaa ntsꞌa, nquii tsansꞌa jnda na tꞌman vaa na venchjihin, njñönhin na mꞌan nanꞌñeen, tyiꞌnan ro na nntꞌa nanminꞌ na njonhin. ");
INSERT INTO azgNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Majoꞌ nque nanꞌñeen na contꞌa tsꞌian tyuaa ꞌnaanꞌ jon, xjen na jntyꞌiahan na jnda nquii jon na jndë tyjeeꞌ, jnduehan ndëë ntyjehan: Tsꞌian ya yuuꞌ nntjo ntjonvahin ntꞌö juu. Cüa, quinanꞌcuëëꞌhin chaꞌ ntjohanꞌ nduëë. ");
INSERT INTO azgNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ndoꞌ tjiꞌhanhin quiiꞌ ntjonꞌñeen, ndoꞌ jnanꞌcueeꞌhanhin.” Ndoꞌ taxeeꞌ Jesús ndëë nanꞌñeen, tso jon: “Nquii jon na ꞌnaanꞌ ntjonꞌñeen, ¿Nin ꞌnan mꞌaanꞌ nꞌonhoꞌ na ntsꞌaa jon? ");
INSERT INTO azgNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ncüjeeꞌ ntcüeꞌ jon ndoꞌ ntscüje jon nanꞌñeen. Ndoꞌ nninncyaa jon ntjon ꞌnaanꞌ jon ndëë mañoon nnꞌan.” Ndoꞌ nque nnꞌan na condye jñꞌoonminꞌ na sinin Jesús, jnduehan: —Tyiꞌjon ncyaa Tyoꞌtsꞌon na nndui na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Majoꞌ Jesús, quii jndyiaaꞌ jon ndëëhan. Tjiꞌ jon ncüii jñꞌoon na sijoonꞌ nquiihin na conduihin tsjöꞌ na ninjntꞌue. Tso jon: Vaa jñꞌoonꞌ Tyoꞌtsꞌon na jndui na itsohanꞌ: Nque albañin na conanꞌya vꞌaa, juu tsjöꞌ na conduehan na tyiꞌjeꞌcüijntꞌuehanꞌ, majuutohanꞌ vaquityen tyenhanꞌ nqui tsjaanꞌ vꞌaa. Na nndaꞌ vaa na tso jñꞌoonꞌñeen, ¿Nchu vaa na cotjiꞌhoꞌ cüenta na itsiquindyihanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Minninchen tsꞌan na ndicüaaꞌ tsꞌon ntyja njan, ijuꞌviꞌhanꞌhin chaꞌvijon tsꞌan na tonhin na tyioohin nacjooꞌ tsjöꞌ. Majoꞌ juu tsꞌan na tyiꞌninꞌcantyja tsꞌon ja, majndaꞌ na ntꞌuiiviꞌhanꞌhin. Juu ꞌnan na ngenon juu itsijonhanꞌ juuhanꞌ chaꞌvijon ꞌnan na ntjon tsꞌan na tyioo ncüii tsjöꞌ tꞌman nacjooꞌ, na sitiuu jndëhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ndoꞌ nnꞌan na conintque ndëë ntyee yo nnꞌan na conanꞌman nchu vaa itsiquindyi juu jñꞌoon na tquen Moisés, xjenꞌñeen tojntꞌuehin nchu vaa nquii ntꞌahan na nntꞌuehan Jesús, ee taaꞌ nꞌonhan na nacjo nquehan sinin jon juu jñꞌoonꞌñeen. Majoꞌ ncyaahan nnꞌan na jndye jndyiꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Mangꞌe na nndaꞌ, tojntꞌue yantyihan nchu vaa nquii nntꞌahan. Joo nanꞌñeen mꞌan ntyjehin na contꞌa nquehin na njon jndyi jñꞌoonꞌ Tyoꞌtsꞌon ngiohan. Jñonhin nanꞌñeen naijon na mꞌaan Jesús. Tꞌuahin tsꞌian ndëë nanꞌñeen na quitsaquindahin jñꞌoon na toninncyaa jon. Ndoꞌ vi na jndë joꞌ, nninncyahan cüenta jon ntꞌö gobernado chaꞌ coꞌxen tsanꞌñeenhin. ");
INSERT INTO azgNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Joꞌ taxeeꞌ nanꞌñeen nnon Jesús: —Nndaꞌ ta na matsiꞌmanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndëë nnꞌan, mangiö na jndyoyu matsininꞌ ndoꞌ matsiꞌmanꞌ chaꞌxjen chuhanꞌ, min tacotsaꞌ na njon nchjiꞌ yo ncüii tsꞌan, majoꞌ ncüiichen tsꞌan tyiꞌcueeꞌ tsonꞌhin. ꞌUꞌ ninnquiiꞌchen na matsiꞌmanꞌ na quitsꞌaa tsꞌan chaꞌxjen na ntꞌue tsꞌon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ndoꞌ nanein ta, ninꞌquindyë́, nquii César, tsan na conintque tsjoon Roma, ¿Aa chuhanꞌ na quityiö́n sꞌon na ique jon, ndoꞌ aa tyiꞌquichuhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Majoꞌ nquii Jesús, taaꞌ tsꞌon jon na conanꞌviꞌnnꞌanhan. Joꞌ tso jon ndëëhan: ");
INSERT INTO azgNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Quinanꞌmanhoꞌ ncüii xoquituꞌ denario nnön. ¿Nin tsꞌan xquen chuuꞌhanꞌ ndoꞌ nin tsꞌan xueeꞌ na chuuꞌhanꞌ? Tꞌa nanꞌñeen, jnduehan: —Nquii César chuuꞌhanꞌ, juu tsanmꞌaantsꞌian tꞌman tsjoon Roma. ");
INSERT INTO azgNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yajoꞌ tso jon ndëëhan: —Ngꞌe na nndaꞌ, quityionhoꞌ sꞌon na ique César na tsixuanhanꞌ cüentaaꞌ jon, ndoꞌ mantyi ncyahoꞌ cüentaaꞌ Tyoꞌtsꞌon na tsixuanhanꞌ cüentaaꞌ nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Joꞌ taꞌnan jndëë jntꞌahan na quitꞌuiihanꞌhin ntyja ꞌnaanꞌ jñꞌoon na totsinin jon quiiꞌ ntꞌan nnꞌan. Ndoꞌ nanꞌñeen na jntꞌuehan na quitꞌuiihanꞌhin ntyja ꞌnaan joo jñꞌoon na tꞌa jon, vacue mꞌaanꞌ nꞌonhan yo jñꞌoon na sintcüeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jndë joꞌ minndye nnꞌan judíos na conduihan tmaanꞌ saduceos, squenonhan na mꞌaan Jesús. Nanꞌñeen tyiꞌcantyja nꞌonhan na ngüandoꞌ xco tsꞌan na jndë tueꞌ. Veꞌ ngꞌe joꞌ, ndö vaa jñꞌoon na tyequinduehan nnon jon: ");
INSERT INTO azgNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—ꞌUꞌ ta na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, nquii Moisés tji jon jñꞌoon na icoꞌxenhanꞌ já xe ngueꞌ ncüii tsansꞌa ndoꞌ ntjo scuuꞌ juu, yajoꞌ juu tyje tsꞌooꞌñeen ngoco juu yo itsaaꞌ juu. Ncꞌon ntsinda juu yo tsanscuꞌñeen chaꞌ ntsinon juu na tantsinda tsoxio juu tꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Quindyiaꞌ, ndö vaa ꞌnan na tui. Tomꞌan ntyqueꞌ nannon na ninncüii tsꞌan ntsindahan. Juu tsantque toco juu, majoꞌ xjen na tueꞌ juu, tatꞌoon jnda juu yo scuuꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jndë joꞌ juu tsan na jndë ve, toco juu yo tsanscuꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Jndë joꞌ tsan na jndë ndye toco juu yo tsanscuꞌñeen. Ndoꞌ majoꞌntyi tsoñꞌen na ntyqueꞌ nanꞌñeen, ncüii ro ncüiihan toyꞌonhan juu na tondiscuhanhin ndoꞌ tjëhan. Minꞌncüii ndahan yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ndoꞌ na matsꞌia mantyi nquii tsanscuꞌñeen, tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ndö jñꞌoon na ninꞌquitaꞌxꞌë́ nnonꞌ, juu xjen na nntaꞌndoꞌ xco nnꞌan, ¿Nin ncüii joo na ntyqueꞌ nanꞌñeen na ndisaaꞌ juu? Ee tsoñꞌen na ntyqueꞌhan tondiscuhanhin. ");
INSERT INTO azgNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tꞌa Jesús, itso jon ndëëhan: —Nnꞌan tsonnangue na mꞌan nanein cotoncohan, ndoꞌ coninncyahan ndahan na cotonco joo. ");
INSERT INTO azgNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Majoꞌ mꞌan nnꞌan na nanꞌxuanhan na ntaꞌndoꞌ xcohan vi jndë na tjëhan, ndoꞌ mantyi nanꞌxuanhan na ncꞌonhan juu xjen na nnguaa tsonnangue xco. Majoꞌ juu xjenꞌñeen taxeꞌquitoncohan, min nannon, min nanntcu, ");
INSERT INTO azgNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ee taxeꞌcüje nndaꞌhan. Ntsijonhanꞌhin chaꞌna nque ángeles. Condui nanꞌñeen ntsinda Tyoꞌtsꞌon ngꞌe na jndë tyincyaa jon na cotaꞌndoꞌ xcohan. ");
INSERT INTO azgNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mancüiixjen itsohanꞌ na cotaꞌndoꞌ xco nnꞌan na jndë tjë ee nquiintyi Moisés siꞌman jon na nndaꞌ yo jñꞌoon na tji jon ntyja ꞌnaanꞌ tsꞌoon neon zarza na tꞌahanꞌ. Quityquiiꞌ juu jñꞌoonꞌñeen tso jon na nquii ta Tyoꞌtsꞌon conduihin Tyoꞌtsꞌon cüentaaꞌ Abraham, yo Isaac, yo ninꞌJacobo. ");
INSERT INTO azgNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Juu jñꞌoonꞌñeen tsiꞌmanhanꞌ na nquii Tyoꞌtsꞌon conduihin Tyoꞌtsꞌon cüenta nnꞌan na cotandoꞌ, chito cüenta ntꞌoo. Joꞌ tsiꞌmanhanꞌ na joo nnꞌan na vantyja nꞌon cotandoꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yajoꞌ minndye nnꞌan na conanꞌman nchu vaa tsiquindyi jñꞌoon na tquen Moisés, tꞌahan, jnduehan nnon jon: —Nndaꞌ ta, taquinjonꞌ jñꞌoon na tsuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ndoꞌ joo nnꞌan tmaanꞌ saduceosꞌñeen, tavi tꞌonhan na nanꞌxuanhan ñuaanhan na ntaꞌxeeꞌntyichenhan jñꞌoon nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Taxeeꞌ Jesús ndëë nnꞌan: —¿Nchu vaa na condue nnꞌan na nquii Mesías conduihin tsjan David na jndyocahanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ee nquii David tso jon na condui Mesías nquii ta na ityeꞌntjon jonhin. Juu jñꞌoonꞌñeen jnduihanꞌ cjooꞌ tson na chu salmos. Ndö vaa na itsohanꞌ: Nquii ta Tyoꞌtsꞌon itso jon nnon nquii jon na ityeꞌntjon jon jaa: Quijmanꞌ ncꞌia ntyjaya naijon na itsitꞌmaanꞌhanꞌ ꞌuꞌ ");
INSERT INTO azgNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ata xjen nque nnꞌan na jndohan ꞌuꞌ jndë sꞌa tmaanꞌhan na cꞌonhan nacje ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ngꞌe na nndaꞌ vaa tso juu jñꞌoonꞌñeen, ndö vaa jñꞌoon na mavaxꞌë ndëëhoꞌ. ¿Nchu vaa na conduehoꞌ na nquii Mesías conduihin tsjan David na jndyocahanꞌ, ndoꞌ nquii David tso juu na nquii Mesías conduihin nquii ta na icoꞌxen jonhin? ");
INSERT INTO azgNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Viochen xjen na nque nnꞌan na jndye jndyiꞌhin manin vaa condyehin, tso Jesús ndëë nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon: ");
INSERT INTO azgNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, nein jndyihan na ngondyiꞌhan na cüehan ndiaa tonco chaꞌ quitjiꞌ nnꞌan cüenta na tꞌman conduihan. Ndoꞌ ntꞌue nꞌonhan na nninncya nnꞌan tsꞌonhan nata. Mantyi quiiꞌ ntꞌaanꞌon ninꞌcüendyuaahan naijon na ntsiquinjonchenhanꞌhin. Ndoꞌ xjen na coveeꞌ nguee, mantyi ninꞌcüendyuaahan silla na tonnonchen. ");
INSERT INTO azgNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Majoꞌ ꞌnaan nanntcu ninnque, cotjiꞌ nanꞌñeenhanꞌ na nninꞌnaanhinhanꞌ. Ndoꞌ jndye jñꞌoon conanꞌneinhan nnon Tyoꞌtsꞌon chaꞌ quinanꞌtiu nnꞌan na jen conanꞌquindëhan tonnon jon. Jnaanꞌ na nndaꞌ vaa na contꞌahan, jaaꞌ jndyi ntꞌuiihanꞌhin. Tyiꞌntꞌahoꞌ chaꞌxjen ꞌnan na contꞌahan.” ");
INSERT INTO azgNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Sinin Jesús jñꞌoonminꞌ viochen xjen na mꞌaan jon vatsꞌon tꞌman. Joꞌ tquen jon cüenta na nque nantya, jndye sꞌon cotyionhan cüentaaꞌ Tyoꞌtsꞌon quiiꞌ quiton na min joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mantyi joꞌ jndyiaaꞌ jon ncüii tsanscu ninnquii, jñenꞌ jndyihin. Taquityion juu ve xoquituꞌ sꞌon ve ncüii joo quitonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Joꞌ tso Jesús: —Jñꞌoon mayuuꞌ na matsjö ndëëhoꞌ, juu tsanscuvaꞌ tsꞌan ninnquiihin na jñenꞌ jndyihin, jndyentyi tyincyaa juu cüentaaꞌ Tyoꞌtsꞌon, chichen na tyincya tsoñꞌen nantyaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ee joohan veꞌ sꞌon na vantjoꞌchen na min ndueehan, joohanꞌ na tjueꞌhin quiiꞌ quitonꞌñeen. Majoꞌ juu tsanscuvaꞌ na jñenꞌ jndyihin, tjuꞌñꞌen juu xoquituꞌ na yꞌoon juu, maninꞌ ntyja na ntcüaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Vendye nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, jnanꞌneinhan ntyja ꞌnaanꞌ juu vatsꞌon tꞌman ndoꞌ mantyi ntyja ꞌnaan joo ntjöꞌ na ya jndyi na tijntꞌue na tycüiꞌhanꞌ ndoꞌ ntyja ꞌnaanꞌ ꞌnan na njon jndyi na tyincyaa nnꞌan cüentaaꞌhanꞌ na tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. Xjenꞌñeen tso Jesús: ");
INSERT INTO azgNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Tsoñꞌen nanꞌmin na cojntyꞌiahoꞌ, mangüentyja xjen na nnanꞌtyuiiꞌ nnꞌanhanꞌ. Minꞌncüii tsjöꞌ jeꞌquintjohanꞌ nacjo ntyjehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Ndoꞌ taxeeꞌhan nnon jon, jnduehan: —ꞌUꞌ ta na matsiꞌmanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndëë nnꞌan, ¿Yuu xjen na nndui na nndaꞌ? Ndoꞌ ¿Nin jnꞌaan na ntsiꞌmanhanꞌ na jndë mavaa xjen na nndui nanꞌmin? ");
INSERT INTO azgNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tꞌa jon jndyuehan, tso jon: “Quitquenhoꞌ cüenta na tyiꞌnanꞌviꞌnnꞌan nnꞌan ꞌoꞌ ntyja ꞌnaan jñꞌoonminꞌ. Ee jndye nnꞌan nninncyo na nnduehan na maja conduihan. Nnduehan na nquehin conduihan Mesías. Ndoꞌ nnduehan: Jndë tentyja xjen na ntycüii tsoñꞌen. Majoꞌ tyiꞌnanꞌjonhoꞌ yo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Minꞌ tyiꞌndyuehoꞌ ya conincꞌuaa jñꞌoon na ncꞌoon ndyiaꞌ ndoꞌ na conanꞌve nnꞌan nacjo gobiernon ꞌnaanhan. Ee mancüiixjen jndeiꞌhanꞌ ngüenon jndyee nanꞌminꞌ, majoꞌ tyiꞌcoventyja xjen na ngitsu tsonnangue.” ");
INSERT INTO azgNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ndë joꞌ tsontyichen jon ndëëhan: “Nnꞌan ncüii tsonnangue, nnanꞌvehan nacjo nnꞌan ncüiichen tsonnangue. Ndoꞌ ncüii tsanmꞌaantsꞌian tꞌman ntsꞌaa jon tyiaꞌ yo ncüiichen tsanmꞌaantsꞌian tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ndoꞌvanjan jndei ngotsꞌii ndoꞌ ncꞌoon jndoꞌ tꞌman ndoꞌ ntycu chen jndyi ncyꞌoonhanꞌ nnꞌan. Ndoꞌ juu tsjöꞌndue nnintyincyooꞌ jnꞌaan tꞌman na mioon ntsityꞌuehanꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Majoꞌ vitjachen na nndui tsoñꞌen nanꞌminꞌ, ncyꞌon nnꞌan ꞌoꞌ na nntꞌaviꞌhan ꞌoꞌ ndoꞌ nntyꞌehin ꞌoꞌ. Ndoꞌ mantyi nninncyahan cüenta ꞌoꞌ ndëë nnꞌan quiiꞌ ntꞌaanꞌon ꞌnaanhan ndoꞌ ntyiꞌhan ꞌoꞌ ntꞌaancjo. Ndoꞌ ncꞌochohan ꞌoꞌ tondëë nnꞌan na conintque yo tondëë nanmꞌannꞌian tꞌman, veꞌ ngꞌe na conanꞌjonhoꞌ yo jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Xjen na ntquenonhoꞌ tsoñꞌen nanꞌminꞌ, ntsiquinaanhanꞌ na ntjiꞌ jndyoyuhoꞌ ntyja njan ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ngꞌe na nndaꞌ, quinanꞌjndaꞌhoꞌ na tyiꞌndyiiꞌ nꞌonhoꞌ nin jñꞌoon na nnanꞌntcüeꞌhoꞌ ndëë nanꞌñeen chaꞌ ngüañoonꞌhanꞌhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ee ncö ntsꞌa na ntsijndaꞌhanꞌ nquenhoꞌ chaꞌ nndëë nnanꞌntcüeꞌhoꞌ jñꞌoon ndëë nanꞌñeen, ata minꞌcya ro joohan na jndohan ꞌoꞌ, jeꞌquindëë nnduehan na juu jñꞌoon na coninncyahoꞌ tyiꞌquijntꞌuehanꞌ, min tyiꞌjeꞌncyaahanꞌ na nnduehan na tyiꞌyuuꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mantyi nque tyehoꞌ, ndyeehoꞌ nninncyahan cüenta ꞌoꞌ nduee nnꞌan na nnanꞌcüje nanꞌñeen minndye ꞌoꞌ. Majoꞌntyi nntꞌa ntyje nquehoꞌ yo ntyje tycyahoꞌ ndoꞌ mantyi nnꞌan na ya jñꞌoon yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ndoꞌ jndye jndyihan ncꞌonhan na tyiꞌcueeꞌ nꞌonhan ꞌoꞌ veꞌ ngꞌe na mꞌanhoꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Majoꞌ xeꞌquiꞌndyi na ngitsuhoꞌ. Chaꞌvijon na itsohanꞌ min veꞌ ncüii sonquenhoꞌ tyiꞌjeꞌquitsuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ngꞌe na ntjotyenhoꞌ yo ntyja njan, joꞌ na nninncyaa Tyoꞌtsꞌon na tyiꞌquintycüii na ntaꞌndoꞌhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Majoꞌ ya na njntyꞌiahoꞌ na minntyjeeꞌ sondaro xiꞌjndio Jerusalén, yajoꞌ cüaaꞌ nꞌonhoꞌ na mavaa xjen na nnanꞌtyuiiꞌhan juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Juu xjenꞌñeen joo nnꞌan na mꞌan ndyuaa Judea, quinanꞌnonhan na min ntyoꞌ na ntaꞌntyꞌiuhan joꞌ. Ndoꞌ nnꞌan na mꞌan Jerusalén quinduiꞌhan joꞌ, ndoꞌ nnꞌan na mꞌan jndëë tyiꞌncꞌo ntcüeꞌhan juu tsjoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ee joo ngueeꞌñeen nanꞌxuanhanꞌ xjen na ntꞌuiiviꞌ Tyoꞌtsꞌon nnꞌan judíos chaꞌ ntsiquindëhanꞌ tsoñꞌen jñꞌoonꞌ jon na tondui. ");
INSERT INTO azgNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ntyꞌia ro nanntcu na ñjon ndahan juu xjenꞌñeen yo ntyjentcuhan na ꞌndaa nda. Ee ngioo ncüii naviꞌ tꞌman nacjooꞌ ndyuaava, viꞌ jndyi ntsꞌaa Tyoꞌtsꞌon na ntquenon nnꞌan na mꞌan juu xjenꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nnanꞌcüje nnꞌan joohin yo xjo ndoꞌ jndyehan ncꞌocho nnꞌanhan chaꞌvijon preso ncüii ncüii tsonnangue. Ndoꞌ joo nnꞌan na tyiꞌquinjon Tyoꞌtsꞌon ngiohin, ntoꞌxenhin Jerusalén ata ngueeꞌ xjen ntyjii jon na ngacüentyjeeꞌ na contꞌahan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Juu xjenꞌñeen tꞌman jnꞌaan na nnintyincyooꞌ na njntyꞌia nnꞌan ntyja ꞌnaanꞌ ndoꞌcüjioonꞌ yo chiꞌ ndoꞌ yo ninꞌncjuu. Ndoꞌ nnon tsonnangue, ntsiꞌndaaꞌ jndyihanꞌ ngio nnꞌan. Ndoꞌ ngꞌe na nnincꞌuaa na iju ndaandue ntsiquijñꞌeenhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ntsꞌaahanꞌ na tajndeiꞌ nꞌonhan ngꞌe na coviquityuehan ntyja ꞌnaanꞌ na mꞌaanꞌ jndyi nꞌonhan nchu vaa vja na itsꞌaahanꞌ nnon tsonnangue. Ndoꞌ majuu xjenꞌñeen tsoñꞌen na condui najndë na cotoxenhanꞌ tsjöꞌndue, ntsitoncüiiꞌhanꞌ joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yajoꞌ juu xjenꞌñeen ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coꞌxën tsoñꞌen nnꞌan, njntyꞌia nnꞌan na ncüjënön nntꞌa tsonnangue. Tyquiiꞌ chincyu nndyö yo juu na nancooꞌ naquixuee na conditꞌman ja. ");
INSERT INTO azgNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Xjen na jndë tyeꞌ na condui nanꞌminꞌ, cüa, quityiiꞌyantyihoꞌ, tyindyuehoꞌ, cꞌon cjehoꞌ ee tajndye vitja na ntsiquindyaa Tyoꞌtsꞌon ꞌoꞌ na nduiꞌhoꞌ quityquiiꞌ naviꞌminꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Juu jñꞌoonva na tyiꞌquitso nquiiꞌhanꞌ, sinin Jesús juuhanꞌ ndëëhan, tso jon: “Cüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ tsꞌoon higuera oo minꞌcya ro tsꞌoon. ");
INSERT INTO azgNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Xjen na cojntyꞌiahoꞌ na jndë conduiꞌ tscoꞌndaahanꞌ, cotjiꞌhoꞌ cüenta na jndë tindyo ngueesuaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mantyi xjen na cojntyꞌiahoꞌ na condui nanꞌminꞌ na jndë tsjö, cüaaꞌ nꞌonhoꞌ na jndë tindyo juu xuee ya tsoñꞌen nnꞌan ntjiꞌ jndyoyuhan na condui Tyoꞌtsꞌon na ityeꞌntjon jon tsoñꞌen. ");
INSERT INTO azgNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, nque nnꞌan na mꞌan naneinhin, tyiꞌxeꞌcüjeñꞌenhan ata xjen na jndë siquindëñꞌenhanꞌ tsoñꞌen jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tsjöꞌndue yo tsonnangue ntycüiiñꞌenhanꞌ, majoꞌ joo jñꞌoon na mancya, tsoñꞌenhanꞌ ntsiquindëñꞌenhanꞌ joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Quitquenhoꞌ cüenta na tyiꞌninncyahoꞌ na ncjachuhanꞌ ꞌoꞌ na veꞌ conanꞌjontohoꞌ na cocüaꞌ quintcu nnꞌan yo na covehan na condyehan oo na ncꞌon jndyihoꞌ jñꞌoontiu ntyja ꞌnaanꞌ na nchu vaa nquii na ncꞌonhoꞌ ꞌio cha. Ee xe nanꞌminꞌ ncꞌoonꞌ nꞌonhoꞌ, ninjonto ncüjeeꞌnon juu xueeꞌñeen na ntꞌuiihanꞌ ꞌoꞌ chaꞌvijon itꞌuii xiuꞌ quiooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Manndaꞌ vaa na ngueeꞌnon juu xueeꞌñeen na mꞌan nnꞌan na ninvaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mangꞌe na nndaꞌ, ninnquiiꞌchen quitquenhoꞌ cüenta ninvaa xuee na cotsamꞌanhoꞌ. Ndoꞌ quitanhoꞌ nnon Tyoꞌtsꞌon na nninncyaa jon na ncꞌoon najndeiꞌ nꞌonhoꞌ chaꞌ ya ro nnduiꞌhoꞌ quiiꞌ juu naviꞌ na nndyo, ndoꞌ chaꞌ nndëë ngüentyjeeꞌtyenhoꞌ tonnön, ja na condui tsansꞌa na iꞌua jon tsꞌian nnön na coxën tsoñꞌen nnꞌan.” ");
INSERT INTO azgNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ndoꞌ nquii Jesús, tincüii xueeyu totsiꞌman jon ndëë nnꞌan quiiꞌ juu vatsꞌon tꞌmanꞌñeen. Ndoꞌ ya na tovaman, tonduiꞌ ntcüeꞌ jon quiiꞌ tsjoon, toca jon juu tyoꞌ na jndyu Olivos. ");
INSERT INTO azgNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndoꞌ tivinonnco, nnꞌan na jndye jndyihan totsquehan vatsꞌon tꞌmanꞌñeen na ndyehan jñꞌoon na toninncyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Majndë vavindyo na ngueeꞌ nguee na cocüaꞌ nnꞌan judíos tyooꞌ na tatsquentë taqueeꞌ. Juu ngueeꞌñeen conanꞌquijndyuhinhanꞌ pascua. ");
INSERT INTO azgNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ndoꞌ joo ntyee na conintque ndëë nnꞌan judíos yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, ngꞌe na ncyaahan nnꞌan na neinhan Jesús, veꞌ ntyꞌiu tojntꞌue ntyeeꞌñeen nchu vaa nquii ntꞌahan chaꞌ na cueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Juu xjenꞌñeen nquii Judas na mantyi jndyu juu Iscariote, tua Satanás quiiꞌ tsꞌon juu. Juu juu ncüii nque nnꞌan na nchoꞌve. ");
INSERT INTO azgNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tja tsanꞌñeen na mꞌan joo ntyee na conintqueꞌñeen yo nantque na cotoxen nanntꞌei cüentaaꞌ juu vatsꞌon tꞌman. Tatsijndaꞌ juu yohan nchu vaa nquii ntsꞌaa juu chaꞌ nninncyaa juu Jesús ndueehan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ndoꞌ nanꞌñeen, sineiinꞌhanꞌ nꞌonhan na nndaꞌ vaa na tso juu, ndoꞌ jnanꞌcüejonhan jñꞌoon na ndyionhanhin na ntsꞌaa juu na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ndoꞌ mantyi juu siuꞌ juu na nndaꞌ. Joꞌ taꞌ juu tontꞌue juu yuu xjen na ntsijonhanꞌ na nninncyaa juu cüenta Jesús ndueehan xjen na tyiꞌquijntyꞌia nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ndoꞌ tueeꞌ juu nguee na cocüaꞌ nnꞌan judíos tyooꞌ na tatsquentë taqueeꞌ. Juu ngueeꞌñeen na conanꞌcüje nanꞌñeen quinman ntyja ꞌnaanꞌ nguee pascua, ");
INSERT INTO azgNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ndoꞌ jñon Jesús Pedro yo ninꞌJuan ncüii ntꞌaa, tso jon ndëëhan: —Cüa, cꞌohoꞌ na nnanꞌjndaꞌhoꞌ na ntcüꞌa jaa ntyja ꞌnaanꞌ nguee pascüa. ");
INSERT INTO azgNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Taꞌxeeꞌhan nnon jon: —¿Yuu jon ntꞌue tsonꞌ na nnanꞌjntꞌáhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tꞌa jon jndyuehan, itso jon: —Quitquenhoꞌ cüenta, juu xjen na jndë tyequeꞌhoꞌ quiiꞌ tsjoon, joꞌ ntjonhoꞌ ncüii tsansꞌa na yꞌoon juu tsjö na ñjon ndaa. Quitsantyjahoꞌ xenꞌ tsanꞌñeen ata xjen ngueeꞌ juu vꞌaa na ngaqueeꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Joꞌ quinduehoꞌ nnon nquii tsꞌan na vaaꞌ juu vꞌaaꞌñeen: “Nndaꞌ ta, nquii tsan na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, ivaxeeꞌ jon: ¿Yuu vijon vaa cuarto na nninjntꞌue já na ntcüaꞌ jon cüentaaꞌ nguee pascua yo já nnꞌan na cotsayꞌö́n yo jñꞌoon na incyaa jon?” ");
INSERT INTO azgNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ndoꞌ juu tsanꞌñeen, ntsiꞌman jon ncüii cuarto ndëëhoꞌ, vꞌaa vequitoꞌ, majndë min quindë ꞌnan, joꞌ quinanꞌjndaꞌ yahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Joꞌ tyꞌehan ndoꞌ tijndaꞌ tsoñꞌen chaꞌxjen na tso Jesús ndëëhan. Ndoꞌ joꞌ jnanꞌjndaꞌhan na ntcüaꞌhan cüentaaꞌ juu pascüa. ");
INSERT INTO azgNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Vi jndë tman, tueeꞌnon Jesús joꞌ, tëcjo jon mesa yo nque nnꞌan nchoꞌve na conanꞌjonhan yo jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tso jon ndëëhan: —Juu nguee pascuavahin, ntꞌue jndyi tsꞌön na ninꞌquë quitsman chjo yo ꞌoꞌ vitjachen na ncüꞌiö. ");
INSERT INTO azgNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tajeꞌcüꞌa nntꞌahanꞌ ata juu xjen na covityincyo jndyoyu nchu vaa itsiꞌmanhanꞌ naijon na ityeꞌntjon Tyoꞌtsꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Juu xjenꞌñeen tyꞌoon jon ncüii vaso, jndë na tyincyaa jon na ncya ya Tyoꞌtsꞌon, tso jon ndëëhan: —Cyꞌonhoꞌ vasova, quinanꞌcüenonhoꞌhanꞌ ndëë ntyjehoꞌ, ncüii ro ncüii ro ꞌoꞌ cüehoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, nanein na tonnonchen taxeꞌcꞌua ndaa vinon ata juu xjen na ngityeꞌ na ityeꞌntjon Tyoꞌtsꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jndë joꞌ tyꞌoon jon tyooꞌ, mantyi tyincyaa jon na ncya ya Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ, ndoꞌ tyjee jon tanꞌhanꞌ, tyincyaa jonhanꞌ ndëëhan. Tso jon: —Juu tyooꞌva conduihanꞌ sꞌi na mancya na cüꞌiö cüentahoꞌ. Ndö vaa ngontꞌahoꞌ na covañjoonꞌ nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ndoꞌ jndë na tcüaꞌhan, majoꞌntyi sꞌaa jon, tyꞌoon nndaꞌ jon vaso. Tso jon: —Juu vinon na ñjon vasova, tsiꞌmanhanꞌ juu jñꞌoon xco na maquëntyën yo nꞌeön na ninncya na ntcüeꞌhanꞌ ntyja ꞌnaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Majoꞌ quitquenhoꞌ cüenta, juu tsꞌan na nninncyaa cüenta ja nduee nnꞌan, vaquityen juu mesava yo ja. ");
INSERT INTO azgNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Jñꞌoon na mayuuꞌ, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ngenön chaꞌxjen na jndë tijndaꞌ ntyja njan, majoꞌ ndyiaꞌ jndyi juu tsꞌan na ninncyaa cüenta ja nduee nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ndoꞌ joꞌ taꞌhan totaꞌxeeꞌhan ndëë ntyjehin nin ncüii joohan na ntsꞌaa na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mantyi nnꞌan na nchoꞌveꞌhin, jnanꞌjndyehan jndyuehan yo ntyjehan nin ncüii nquehan na ndiquinjonchenhin. ");
INSERT INTO azgNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Majoꞌ tso Jesús ndëëhan: “Nque nanmꞌannꞌian tꞌman tsonnangueva yo nque nnꞌan na cotsayꞌon jñꞌoon yo nnꞌan na cotoxen, conchjehan nnꞌan na cotyeꞌntjon ndëëhan, majoꞌ conanꞌquijndyu nanꞌñeen joohan nnꞌan na cotaꞌntyjeeꞌhinhan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Majoꞌ ꞌoꞌ tyiꞌquichuhanꞌ na ntsamꞌanhoꞌ chaꞌna na contꞌa nanꞌñeen. Ndö vaa na quintꞌahoꞌ, juu tsꞌan na conintꞌmanntyihin, cꞌoon juu chaꞌvijon tsꞌan na tyiꞌtꞌman condui. Ndoꞌ tsꞌan na icoꞌxen, cꞌoon juu chaꞌvijon tsꞌan na ityeꞌntjon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ee ¿Nin juu na njonchen conduihin, aa juu tsꞌan na vequityen mesa, oo aa juu tsꞌan na ityeꞌntjon joꞌ? ¿Aa chi majuu tsꞌan na vequityen mesa tꞌmanntyichen conduihin? Majoꞌ quitquenhoꞌ cüenta, ja mꞌan quiiꞌ ntꞌanhoꞌ na condui ja tsꞌan na ityeꞌntjon ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“ꞌOꞌ conduihoꞌ nnꞌan na jndë ntjotyen yo ja tsoñꞌen naviꞌ na jndë toquenön. ");
INSERT INTO azgNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mangꞌe na nndaꞌ, maꞌua tsꞌian ndëëhoꞌ na ntyeꞌntjonhoꞌ nnꞌan chaꞌxjen nquii tyëhöꞌ iꞌua jon tsꞌian nnön na ntyeꞌntjön nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Juu xjenꞌñeen ntsijntꞌa na ntcüaꞌ ꞌoꞌ ndoꞌ ncüehoꞌ yo ja ngiaaꞌ mesa naijon na ntcoꞌxën. Ndoꞌ ngüendyuaahoꞌ nnon silla na maninꞌ tsꞌiaanꞌ na nquehoꞌ ngotoxenhoꞌ joo nchoꞌve ntmaanꞌ ntyjë nnꞌan Israel.” ");
INSERT INTO azgNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ndoꞌ tsontyichen ta Jesús: —ꞌUꞌ Simón, quenꞌ cüenta na jndë jndaaꞌ Satanás jñꞌoon na tcan juu na ntyiiꞌ juu ngꞌee juu ꞌoꞌ, juu nanꞌñeen itsijonhanꞌ juuhanꞌ chaꞌvijon na ntscüeꞌndyi tsꞌan ntquen. ");
INSERT INTO azgNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Majoꞌ ja jndë tcꞌan nnon Tyoꞌtsꞌon ntyja ꞌnanꞌ na juu na mavantyja tsonꞌ tyiꞌntycüiihanꞌ, ndoꞌ vi jndë ntcüeꞌ tsonꞌ tonnön, quitejndeiꞌ joo ntyjë nanmin na ngaquehan ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Majoꞌ tꞌa Simón, tso juu: —Nndaꞌ ta, min xe na aa ntyiꞌ nnꞌan ꞌuꞌ vancjo ndoꞌ xe na aa nnanꞌcueeꞌhan ꞌuꞌ, mantyi ninncya na ntyiꞌhan ja vancjo ndoꞌ na ncüꞌiö yo ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tꞌa Jesús ꞌndyo juu, tso jon: —Pedro, nnonꞌ matsjö, vitjachen na ntsixuaa quilꞌö jeꞌntyi, majoꞌ juu xjenꞌñeen ꞌuꞌ jndë ndye jnda macüji ꞌuꞌ na mavajnanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jndë joꞌ taxeeꞌ Jesús ndëë joo nnꞌan nchoꞌveꞌñeen: —Juu xjen na tꞌua ja tsꞌian ndëëhoꞌ na totsancyahoꞌ jñꞌoon, tsjö na tyíꞌntsayꞌonhoꞌ xoquituꞌ, min chetsjaꞌ, min ntcon. Xjenꞌñeen, ¿Aa vaa ꞌnan na totsitjahanꞌ ꞌoꞌ? Tꞌahan, jnduehan nnon jon: —Taꞌnan yu ro. ");
INSERT INTO azgNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tsontyichen jon ndëëhan: —Majoꞌ nanein, nin juu na nayꞌoon ꞌnan na coñjon xoquituꞌ, cayꞌoon juuhanꞌ ndoꞌ mantyi chetsjaꞌ. Ndoꞌ nin juu na taꞌnan xjooꞌ, quijndëë juu ndiaatco ꞌnaanꞌ juu ndoꞌ quitsijnda juu xjooꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ee matsjö ndëëhoꞌ, vaa jñꞌoonꞌ Tyoꞌtsꞌon na jndui na itsohanꞌ: “Tjiꞌ nnꞌan cüenta na cüajon jnan tsixuan jon chaꞌxjen nque nnꞌan na tꞌman jnan vaa.” Nndaꞌ vaa na tso juu jñꞌoonꞌñeen. Jnduihanꞌ ntyja njan, ndoꞌ mayuuꞌ ntsiquindëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yajoꞌ jnduehan nnon jon: —Ta, quindyiaꞌ, ndö ve xjo yꞌö́n. Tꞌa jon, tso jon: —Mavaa ya jeꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Xjenꞌñeen jnduiꞌ Jesús vꞌaa yuujon na tcüaꞌhan. Tja jon tyoꞌ na jndyu Olivos naijon na mancüiixjen toca jon. Ndoꞌ nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa jon, tyꞌehan yohin. ");
INSERT INTO azgNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Jndë na tueeꞌ jon joꞌ yohan, tso jon ndëëhan: —Quinanꞌneinhoꞌ nnon Tyoꞌtsꞌon chaꞌ tyiꞌngüantjon yutyia ꞌoꞌ xjen na ityiiꞌ juu ngꞌee juu ꞌoꞌ na quinanꞌtjahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ndoꞌ tjantyi jon chjochen na tonnonchen, chaꞌna tycya na ncjuꞌ tsꞌan ncüii tsjöꞌ. Joꞌ tcoꞌxtye jon, tyeꞌ na sinin jon nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tso jon: “Tyeꞌ, juu jñꞌoon na macꞌan nnonꞌ, xe na aa tsijonhanꞌ juuhanꞌ chaꞌxjen na ntꞌue tsonꞌ, quitsiquindyaꞌ ja na tyiꞌngenön juu naviꞌva. Majoꞌ min na macꞌan na nndaꞌ, quindui ntyja na ntꞌue tsonꞌ ncuꞌ, chito chaꞌxjen na ntꞌue tsꞌön ja.” ");
INSERT INTO azgNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ndoꞌ juu xjenꞌñeen, ncüii ángel na jnan quiñoonꞌndue, tyjeeꞌnon juu na mꞌaan Jesús, tyincyaa juu najndeiꞌ tsꞌon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Ndoꞌ na tëtsijaaꞌntyichenhanꞌ na siꞌndaaꞌhanꞌ nchjii jon, totsinin jon nnon Tyoꞌtsꞌon yo ninvaa najndei jon. Ndoꞌ juu ndaatjuenꞌ na jnduiꞌhin, chaꞌvijon neonꞌhanꞌ, ninvindyiiꞌ savꞌiuuꞌhanꞌ xjen tyuaachen. ");
INSERT INTO azgNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Vi na jndë jnanquintyja jon na sinin jon nnon Tyoꞌtsꞌon, tja nndaꞌ jon naijon na jntyꞌii jon nanꞌñeen na totsayꞌonhan yo jñꞌoon na toninncyaa jon, majoꞌ ntjii jonhin condahin, ee tandiquinanhan veꞌ ngꞌe na sichjooꞌ jndyihanꞌ nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tso jon ndëëhan: —¿Nchu vaa sꞌaahanꞌ ngiohoꞌ na condahoꞌ? Quinanꞌquintyjahoꞌ, quinanꞌneinhoꞌ nnon Tyoꞌtsꞌon chaꞌ tyiꞌngüantjon yutyia ꞌoꞌ xjen na ityiiꞌ juu ngꞌee juu ꞌoꞌ na quinanꞌtjahoꞌ nnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ninvaa na itsinin Jesús, ndoꞌ squenon nnꞌan na jndye jndyiꞌhin. Tondëëhan vejndyee nquii Judas, majuu juu ncüii nque nnꞌan na nchoꞌve. Sindyooꞌhin nnon Jesús na tꞌu juu quinchoꞌ jon na tyincyaa juu tsꞌonhin. ");
INSERT INTO azgNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ndoꞌ taxeeꞌ Jesús nnon juu, itso jon: —ꞌUꞌ Judas, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën nnꞌan, ¿Aa yo na maꞌvaꞌ quinchꞌö, joꞌ na mancyaꞌ cüenta ja nndue nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ndoꞌ joo nanꞌñeen na tomꞌanhan yo Jesús, vi na jndë jntyꞌiahan ꞌnan na tui, jnduehan nnon jon: —Ta, ¿Aa nnanꞌtjáꞌ ncjo? ");
INSERT INTO azgNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ndoꞌ ncüii joohan ninñoonꞌ sꞌaa juu natëꞌ juu mosooꞌ nquii tyee na conintque. Tyjee juu tsöꞌnqui tsanꞌñeen tontyjaya. ");
INSERT INTO azgNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yajoꞌ tso Jesús ndëëhan: —Maya jeꞌ, quitsacüentyjeeꞌhoꞌ. Ndoꞌ tꞌuii jon tsöꞌnqui tsanꞌñeen, sinꞌman jonhin. ");
INSERT INTO azgNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ndoꞌ sinin Jesús ndëë ntyee na conditque, yo ndëë nanntꞌei na jnan vatsꞌon tꞌman, yo ninꞌnnꞌan na conditque quiiꞌ tsjoon na sacyꞌonhanhin, tso jon ndëëhan: —¿Aa cotjiꞌhoꞌ cüenta na tsanchꞌuee condui ja, joꞌ na jndyo cyꞌonhoꞌ ja yo ncjo yo nonnchꞌio? ");
INSERT INTO azgNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ꞌIo ꞌio tomꞌan quiiꞌ ntꞌanhoꞌ juu vatsꞌon tꞌman, ndoꞌ min tatꞌuehoꞌ ja. Majoꞌ naneinhin jndë tentyja xjen ꞌnaanhoꞌ na conanꞌjonhoꞌ yo nquii yutyia na icoꞌxen juu ntyja ꞌnaanꞌ najaan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ndoꞌ nanꞌñeen na tꞌuehan Jesús, tyeyꞌonhan jon vaaꞌ nquii tyee na conintque. Ndoꞌ juu Pedro, tycya tycya tantyja juu. ");
INSERT INTO azgNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nnꞌan na tyeyꞌonhan Jesús, jndë na jnanꞌntjonhan chon tochꞌen, xiꞌjndio tyecüendyuaahan nnon chonꞌñeen, ndoꞌ mantyi juu Pedro tacjo jon quiiꞌ ntꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ndoꞌ ncüii tsanscu na ityeꞌntjon ndëë nnꞌan vꞌaaꞌñeen, jndyiaaꞌ juu na vaquityen Pedro naijon naxuee chon. Quii jndyiaaꞌ juu nnon jon, ndoꞌ tso juu: —Mantyi tsansꞌavaꞌ vayꞌoon juu jñꞌoon yo juu Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Majoꞌ tji Pedro, tso jon: —ꞌUꞌ tsanscu, tyiꞌcüajnꞌan ja tsanvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tja ngue chjo xjen ndoꞌ jndyiaaꞌ ncüiichen tsꞌanhin, tso juu nnon jon: —Mantyi ꞌuꞌ vayonꞌ jñꞌoon yo Jesús. Majoꞌ tꞌa jon: —Aa xe ꞌuꞌ. Minꞌchjo chito aa joꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tëca chaꞌnan ncüii hora ndoꞌ ncüiichen tsꞌan sijndeiꞌ ꞌndyo juu, tso juu ndëë nnꞌan: —Jñꞌoon mayuuꞌ na toquiñꞌen tsanvaꞌ yo Jesús ee conduihin tsan na jnan ndyuaa Galileahin. ");
INSERT INTO azgNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tꞌa Pedro ꞌndyo tsanꞌñeen: —Ja, minꞌchjo tyiꞌquintji jñꞌoon na matsuꞌ. Ninvaa na itsinin jon yo tsanꞌñeen ndoꞌ sixuaa ro quilꞌö. ");
INSERT INTO azgNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ndoꞌ na nndaꞌ, tequen ta Jesús, jndyiaaꞌ jndyoyu jon nnon Pedro. Ndoꞌ ninñoonꞌ tañjoonꞌ tsꞌon juu jñꞌoon na jndë siquindyi Jesús juu: “Vitjachen na ntsixuaa quilꞌö jeꞌntyi, majoꞌ ꞌuꞌ jndë ndye jnda macüji ꞌuꞌ ntyja njan.” ");
INSERT INTO azgNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ndoꞌ jnduiꞌ Pedro joꞌ, taxjen vaa tꞌioo jndyi jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nque nanꞌñeen na totquenhan cüenta Jesús, tonanꞌcüejnaanꞌhanhin ndoꞌ totjaꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ndoꞌ mantyi jnanꞌtyenhan ndiaa nnon jon, jndë joꞌ taxeeꞌhan nnon jon: —Cüa, cüiyuuꞌ ꞌndyoꞌ nin juu icüjaꞌ ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ndoꞌ mantyi jndye mañoon jñꞌoon tsanꞌ na tonduehan cjooꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Vi na jndë tixuee, nque nnꞌan na conintque tondëë nnꞌan judíos, yo ntyjehan nque ntyee na conditque, ndoꞌ yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, tëncüihan yo ntyjehan. Ndoꞌ tyeyꞌonhan Jesús naijon na conanꞌjndaꞌhan jñꞌoon. Jndë na tëncüihan joꞌ, taꞌxeeꞌhan nnon jon, jnduehan: ");
INSERT INTO azgNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Quitsuꞌ ndë́, ¿Aa condui ꞌuꞌ nquii Mesías? Tꞌa jon jndyuehan: —Min xe na aa ntsjö ndëëhoꞌ, majoꞌ xeꞌcantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ndoꞌ min xe na aa ngüaxꞌë ndëëhoꞌ, majoꞌ ꞌoꞌ xeꞌquitꞌahoꞌ ꞌndyö, ");
INSERT INTO azgNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Majoꞌ nanein na tonnonchen, ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na coxën tsoñꞌen nnꞌan, ncjöquijman ngiaaꞌ jon tontyjaya naijon na itsitꞌmaanꞌntyichenhanꞌ ja. Nquii jon na taquintyja najndei na conduihin. ");
INSERT INTO azgNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ndoꞌ na tso jon na nndaꞌ, tsoñꞌen nanꞌñeen taꞌxeeꞌhan nnon jon, jnduehan: —Yajoꞌ ¿Aa condui ꞌuꞌ Jnda Tyoꞌtsꞌon? Tꞌa jon jndyuehan, tso jon: —Nquehoꞌ conduehoꞌ na jon condui ja. ");
INSERT INTO azgNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Joꞌ jnduehan ndëë ntyjehan: —Tyiꞌicanhanꞌ na ndyëë jñꞌoon jndyue mañoon nnꞌan nchu vaa na ngiohan ntyja ꞌnaanꞌ jnaanꞌ juu, ee manquëntyë jndë jndyëë jñꞌoon ꞌndyo nquii juu. ");
INSERT INTO azgNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ndoꞌ tsoñꞌen nanꞌñeen na tëncüihan joꞌ, jnanꞌquintyjahan, tyeyꞌonhan Jesús na mꞌaan Pilato. ");
INSERT INTO azgNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Taꞌhan tonduehan nnon tsanꞌñeen nchu vaa ngiohan na itsitjahin. Jnduehan: —Jndë jndiö́ na juu tsanvaꞌ itsiꞌndaaꞌ juu nꞌon nnꞌan ndyuaaminhin. Itso juu na joo sꞌon na coꞌxen César na quitye nnꞌan, tandyiönhanꞌ. Ndoꞌ mantyi manquiintyi juu tso juu na conduihin Mesías na taquintyja na tꞌman conduihin. ");
INSERT INTO azgNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ndoꞌ Pilato, vi na jndë jndyii jon na jnduehan na nndaꞌ, taxeeꞌ jon nnon Jesús, tso jon: —¿Aa mayuuꞌ condui ꞌuꞌ nquii tsan na taquintyja na tꞌman condui na coꞌxenꞌ ntyꞌiuꞌ nnꞌan judíos? Tꞌa Jesús ꞌndyo jon: —Majoꞌ ro chaꞌxjen na matsuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ndoꞌ tso Pilato ndëë ntyee na conintque yo ndëë nnꞌan na jndye jndyiꞌhin: —Juu tsanvaꞌ, minꞌncüii tacovijndaꞌ na aa itsitjahin. ");
INSERT INTO azgNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Majoꞌ tonanꞌjndeiꞌ jndyue nanꞌñeen, jnduehan: —Tsojnaanꞌ juu jñꞌoon na itsiꞌman juu, itsꞌaahanꞌ na joo nnꞌan ninvaa ndyuaa Judea conanꞌjmiinꞌhan na conanꞌvehan cjooꞌ tsamꞌaantsꞌian tꞌman. Taꞌ juu toninncyaa juu jñꞌoonꞌñeen ndyuaa Galilea ndoꞌ majoꞌntyi itsꞌaa juu tsjoonvahin. ");
INSERT INTO azgNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ndoꞌ juu Pilato, vi na jndë jndyii jon jñꞌoon ntyja ꞌnaanꞌ Galilea, taxeeꞌ jon ndëë nanꞌñeen xe na aa condui Jesús tsꞌan ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Ndoꞌ vi na jndë taaꞌ tsꞌon Pilato na jnan Jesús ndyuaa Galilea naijon na icoꞌxen Herodes, yajoꞌ scüenon jonhin na mꞌaan tsanꞌñeen na coꞌxen juu jon. Juu Herodes tyjeeꞌ ya jon Jerusalén ngꞌe na mꞌaan nguee. ");
INSERT INTO azgNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ndoꞌ ya na jndyiaaꞌ Herodes Jesús, tyincyaahanꞌ na neiinꞌ jndyi jon, ee tijndye xuee ninꞌcüajnaanꞌ jonhin. Ee jndë tondyii jon jñꞌoon na tovinein ntyja ꞌnaanꞌ Jesús ndoꞌ ntyja jndyi tsꞌon jon na ntsꞌaa Jesús jnꞌaan tꞌman na nndyiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Jndye jñꞌoon taxeeꞌ jon nnon Jesús, majoꞌ minꞌncüii jñꞌoon taꞌnan tꞌa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ndoꞌ nque ntyee na conintque yo nnꞌan na conanꞌman nchu vaa itsiquindyi jñꞌoon na tquen Moisés, mantyi tyꞌehan na mꞌaan Herodes. Tonanꞌxuaahan na tonduehan nchu vaa ngiohan na itsitja Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ndoꞌ juu Herodes ndoꞌ mantyi yo nque sondaro ꞌnaanꞌ jon, jntꞌahan na tyiꞌcueeꞌ nꞌonhan Jesús, jnanꞌcüejnaanꞌhan jon. Jnanꞌcüehan ncüii ndiaahin na njonhanꞌ chaꞌnan ndiaa cocüe rey, jndë joꞌ jnanꞌcüenon ntcüeꞌhanhin na mꞌaan juu Pilato. ");
INSERT INTO azgNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Ndoꞌ juu xjenꞌñeen, nquii Pilato yo Herodes, ntjo ya ntcüeꞌ ngiohan yo ntyjehan ee tijndye xuee tomꞌanhan na vjehan ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ndoꞌ Pilato tqueenꞌ jon ntyee na conintque yo nanmꞌannꞌian yo nnꞌan na jndye jndyiꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tso jon ndëë nanꞌñeen: —ꞌOꞌ jndyoyꞌonhoꞌ tsanvaꞌ na conduehoꞌ na ityiiꞌ juu jñꞌoon ndëë ntyjehoꞌ nnꞌan judíos na quinanꞌvehan nacjooꞌ nquii gobiernon. Majoꞌ quitquenhoꞌ cüenta, tondëë tsoñꞌenhoꞌ jndë tajndöhin ndoꞌ minꞌncüii jnaanꞌ juu tatijndaꞌ na tsoñꞌen jñꞌoon na conduehoꞌ cjooꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ndoꞌ min nquii Herodes taꞌnan ntjii jon jnaanꞌ juu, joꞌ na iscüenon ntcüeꞌ jonhin na mꞌan ja. Majoꞌ quitquenhoꞌ cüenta, minꞌncüii tyiꞌcotsitjahin na tsixuan juu na cueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ngꞌe na nndaꞌ, joꞌ na ncꞌua ja tsꞌian na ngichuꞌ juu, ndë joꞌ ntsiquindyahin. Manndaꞌ vaa jñꞌoon na sintcüeꞌ Pilato ndëë nnꞌan judíosꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ncüii ncüii chu, juu xjen na coveeꞌ nguee na conanꞌcüje nnꞌan judíos quinman, vaa costumbre na ncüii tsꞌan na mꞌaan naviꞌ ntꞌö Pilato, itsiquindyaa jon tsanꞌñeen ndueehan, nin juu na cotanhan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ngꞌe na nndaꞌ, tsoñꞌen nanꞌñeen tyeꞌ jnanꞌxuaahan, jnduehan: —Cüjiꞌ tsanvaꞌ, ndoꞌ quitsiquindyaꞌ juu Barrabás. ");
INSERT INTO azgNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ndoꞌ juu tsanꞌñeen jndë tjueꞌ sondarohin vancjo ngꞌe vaa jnaanꞌ juu na tejndyee juu ndëë nnꞌan quiiꞌ tsjoon na jnanꞌvehan cjooꞌ gobernado, ndoꞌ mantyi na iscueeꞌ juu tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ndoꞌ ngꞌe na ninꞌquitsiquindyaa Pilato Jesús, joꞌ na tꞌman nndaꞌ jon joo nnꞌan judíosꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Majoꞌ jnanꞌxuaa nndaꞌhan, jnduehan: —Cüa, maninjon ro quitꞌionꞌhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tꞌa jon jndyuehan na jndë ndye jnda: —¿Ndu? Quinduehoꞌ nnön, ¿Nin ꞌnan vaa na jen tꞌman sitjahin? Minꞌncüii jnaanꞌ juu taꞌnan ntji na tsixuan juu na cueꞌ juu. Yajoꞌ ntsꞌa na quichuꞌ jndyee juu, ndoꞌ ndëë joꞌ ntsiquindyahin. ");
INSERT INTO azgNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Majoꞌ ninvito tonanꞌjndeiꞌ jndyuehan. Jndei tonanꞌxuaahan, totanhan na quitꞌion jonhin tsonjnꞌaan. Yajoꞌ tangueeꞌ Pilato chaꞌxjen jñꞌoon na jnanꞌxuaahan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ndoꞌ tso jon na quindui chaꞌxjen na cotanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Joꞌ siquindyaa ntcüeꞌ jon juu tsanꞌñeen na tanhan na mꞌaan vancjo, na tejndyee juu ndëë nnꞌan na jnanꞌvehan cjooꞌ gobernado ndoꞌ na iscueeꞌ juu tsꞌan. Ndoꞌ mantyi tyincyaa jon Jesús ndueehan na quintꞌahan yo jon nchu vaa na ntꞌue nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Xjen na tyeyꞌon sondaro Jesús na ntꞌionhan jon tsonjnꞌaan, tꞌuehan ncüii tsꞌan na jnan jndëë, tsan na jndyu Simón, juu juu tsꞌan tsjoon Cirenehin. Nque sondaroꞌñeen jntꞌahan na quichu tsanꞌñeen tsonjnꞌaan na cantyja juu toxenꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Jndye jndyi nnꞌan tentyja toxenꞌ Jesús, quiiꞌ ntꞌanhan ñꞌen nanntcu na totyuee jndyihan ndoꞌ tonanꞌxuaahan na itsiꞌndaaꞌ jndyihanꞌ ngiohan na jntyꞌiahan ꞌnan na tquenon Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Joꞌ tequen jon ndëë nanntcuꞌñeen, tso jon ndëëhan: —ꞌOꞌ nanntcu Jerusalén, tandyueehoꞌ ntyja njan, quityueehoꞌ ntyja ꞌnaan nquehoꞌ yo ndahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ee quitquenhoꞌ cüenta, mangüentyja xuee na nndue nnꞌan: “Joo nanntcu nnꞌan ndueꞌ yo ntyjehan na tyiꞌquiñjon nda na tayoꞌndaa jnanꞌquiteiꞌhan, tꞌman jndë tyio Tyoꞌtsꞌon jnꞌaanhan.” ");
INSERT INTO azgNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Xjenꞌñeen ngitaꞌ nnꞌan na nnduehan ndëë ntyoꞌ tꞌman: “Quitjaꞌ ꞌoꞌ nacjö́,” ndoꞌ mantyi ndëë ntyoꞌ quijndë nnduehan: “Quityꞌiuhoꞌ já na ncüjë.” ");
INSERT INTO azgNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ee xe nanꞌmin contꞌa nnꞌan yo ja na tajnan tsixuan, matꞌmanntyichen naviꞌ ngenon nanꞌñeen na vaa jnanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ndoꞌ nque sondaroꞌñeen, mantyi tyechohan ve nnꞌan na tꞌuiityenhanꞌhin na tontꞌahan natyia na tojnaanꞌ jnanꞌcüjehan joo nanꞌñeen yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Xjen na squehan ncüii joo na conanꞌquijndyuhan juuhanꞌ Tyoꞌ Tsiꞌxquen Tsꞌoo, joꞌ tꞌionhan Jesús tsonjnꞌaan yo joo nanꞌñeen na tyia nnꞌanhin, ncüii tsanꞌñeen ngiaaꞌ jon tontyjaya ndoꞌ ncüiichenhin ngiaaꞌ jon tontyjatymaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tso Jesús: —ꞌUꞌ Tyeꞌ, nque nnꞌan na contꞌaviꞌ ja, quitsitꞌman tsonꞌhan ee tyiꞌcovaaꞌ nꞌonhan ꞌnan na contꞌahan ja. Ndoꞌ joo sondaroꞌñeen, tyꞌehan xꞌiaaꞌ na njntyꞌiahan nin joohan ninjnoonꞌ ncüii cüii ndiaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ndoꞌ nnꞌan na sque joꞌ, ninvito tojntyꞌiahan jon. Ndoꞌ nque nanmꞌannꞌian veꞌ tonanꞌcüejnaanꞌhin jon, tonduehan: —Juu tsanvahin, naviꞌ na toquenon nnꞌan, totsinꞌman juuhan, joꞌ nanein xe na aa mayuuꞌ conduihin nquii Mesías na tꞌion Tyoꞌtsꞌon tsꞌianhin na coꞌxen jon jaa, quitsinꞌman nquiihin naviꞌ na iquenon juu. ");
INSERT INTO azgNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ndoꞌ mantyi nque sondaroꞌñeen jnanꞌcüejnaanꞌhan Jesús. Tyentyjaaꞌhin na nninncyahan vinon të na ncꞌu jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jnduehan: —ꞌUꞌ xe na aa mayuuꞌ na taquintyja na tꞌman condui ꞌuꞌ na coꞌxenꞌ nnꞌan judíos, cüa quitsinꞌman nquii ꞌuꞌ naviꞌva na maquenoonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tondyeyu xquen tsonjnꞌaan tꞌionhan tscaaꞌ na nnonhanꞌ jndui jñꞌoon griego, yo jñꞌoon latyen, yo ninꞌjñꞌoon hebreo. Itsohanꞌ: “Ndö nquii tsꞌan na taquintyja na tꞌman conduihin na icoꞌxen jon nnꞌan judíos.” ");
INSERT INTO azgNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ndoꞌ ncüii joo nnꞌan naviꞌ nnꞌanhin, tsan na jñon sondaroꞌñeen tsonjnꞌaan na mintyjeeꞌ tongiaaꞌ jon, mantyi scüejnaanꞌ juuhin. Tso juu: —Condui ꞌuꞌ Mesías, ¿Aa tyiꞌyuuꞌ? Ngꞌe joꞌ, quitsinꞌman nquii ꞌuꞌ naviꞌ na maquenoonꞌ, ndoꞌ mantyi já. ");
INSERT INTO azgNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Majoꞌ tꞌa ncüiichen tyje tsanꞌñeen, sityiaꞌ juuhin, tso juu: —Cüa jen tyiꞌncyaꞌ ꞌuꞌ Tyoꞌtsꞌon, ndoꞌ cüejon itꞌuiiviꞌhanꞌ ꞌuꞌ chaꞌxjen na iquenon nquii Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ndoꞌ ve jaa mayuuꞌ chuhanꞌ na quenön na nndaꞌ, ee cotyiön na jndë jnanꞌtja jaa. Majoꞌ juu tahaꞌ, minꞌncüii natyia tacotsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ndë joꞌ tso juu nnon Jesús: —Nndaꞌ ta, cañjoonꞌ tsonꞌ ja ya na ngueꞌ naijon na matyentjonꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ndoꞌ tꞌa Jesús ꞌndyo tsanꞌñeen, tso jon: —Jñꞌoon na mayuuꞌ na matsjö nnonꞌ, xeevahin ncꞌonꞌ yo ja quityquiiꞌ juu paraíso naijon na mꞌaan nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Xjen na tueeꞌ yajminꞌ, sꞌaahanꞌ na tijaan ninvaa tsonnangue, ata xjen na ndye na matman. ");
INSERT INTO azgNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ee ndoꞌcüjioonꞌ sꞌaahanꞌ na tijaanhanꞌ. Ndoꞌ juu ndiaa tco na ntyja quityquiiꞌ vatsꞌon tꞌman, xoncüe yahanꞌ jndyiiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Majuu xjenꞌñeen jndei sixuaa Jesús, tso jon: —Tyeꞌ, ntꞌöꞌ maꞌndyi ntyja na vantꞌö. Ndoꞌ vi jndë tso jon na nndaꞌ, tueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ndoꞌ juu capitán, tsan na icoꞌxen sondaroꞌñeen, vi na jndë jndyiaaꞌ jon na nndaꞌ vaa ꞌnan na tui, sitꞌmaanꞌ jon Tyoꞌtsꞌon, tso jon: —Jñꞌoon na mayuuꞌ, juu tsanvaꞌ tajnan totsixuan jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndoꞌ tsoñꞌen nnꞌan na tëncüi joꞌ na jntyꞌiahan ꞌnan na tui, xjen na tyentcüeꞌhan ntꞌaahan, totuenꞌhan ndaꞌ ndeiꞌndyahan chaꞌ quitsiꞌmanhanꞌ na itsiꞌndaaꞌhanꞌ ngiohan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Majoꞌ tsoñꞌen nnꞌan na taꞌjnꞌaanhan Jesús yo joo nanntcu na tentyja toxenꞌ jon na jnanhan Galilea, matycyaaꞌ tintyjeeꞌhan, jntyꞌiahan na tquenon Jesús nanꞌminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tomꞌaan ncüii tsꞌan na toquijndyu José. Juu jon tsꞌan Tsjoon Arimateahin, ntꞌö Judea. Juu tsanꞌñeen ncüii nque nnꞌan na conduihan nanmꞌannꞌian ꞌnaan nnꞌan judíos. Ya tsꞌanhin ndoꞌ jndyoyu conduihin na tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mantyi tominndooꞌ jon na ngueeꞌ xjen na juu na ityentjon Tyoꞌtsꞌon tsoñꞌen, nnintyincyooꞌhanꞌ. Min taꞌnan sijon tsanꞌñeen yo jñꞌoon na jnanꞌjndaꞌ ntyje nanmꞌannꞌianhin na cueꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Juu José tja jon na mꞌan Pilato, tëcan jon siꞌtsꞌo ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jndë joꞌ taquityjee jonhanꞌ nnon tsonjnꞌaan. Ndoꞌ iscüetyjo jon ndiaa sábana tsan lino tsꞌoo Jesús, jndë joꞌ tjaquityiiꞌ jonhin quiiꞌ tsëꞌtsjöꞌ na jnanꞌya nnꞌan na minꞌjon tacovantyꞌiu tsꞌanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Juu xueeꞌñeen, xuee na conanꞌjndaꞌ nnꞌan judíos na ntaꞌjndyeehan na nnanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. Ndoꞌ ngꞌe na jndë tman juu xjenꞌñeen, joꞌ na mavaa xjen na ngityeꞌ juu xjen na quitaꞌjndyeehan. ");
INSERT INTO azgNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ndoꞌ joo nanntcu na jnan Galilea na tyincyohan yo Jesús, tentyjahan ndoꞌ jntyꞌia ndëëhan juu tsiꞌtsꞌuaꞌñeen yo nchu vaa na tantyꞌiu jon. ");
INSERT INTO azgNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jndë joꞌ tyentcüeꞌhan Jerusalén, tyenanꞌjndahan nasi quichi yo nchenꞌ na ntyeehinhanꞌ siꞌtsꞌo ꞌnaanꞌ Jesús. Joo nanntcuꞌñeen taꞌjndyeehan juu xuee na cotaꞌjndyee nnꞌan judíos chaꞌxjen na juu jñꞌoon na tquen Moisés na icoꞌxenhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Majoꞌ vanco xuee na vejndyee soana, tyꞌehan naijon na vaa tsiꞌtsꞌuaꞌñeen yo vendyechen ntyjentcuhan. Tyechohan nasi quichi na jndë jnanꞌjndaꞌhan na ntyeehinhanꞌ siꞌtsꞌo ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Majoꞌ vi na jndë squehan joꞌ, jntyꞌiahan na juu tsjöꞌ na tëꞌ ꞌndyo juu tsëꞌtsjöꞌñeen, jndë tquenaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ndoꞌ ya na tyequeꞌhan tyquiiꞌhanꞌ, tavi cuaa siꞌtsꞌo ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ndoꞌ viochen xjen na totsiquijñꞌeenhanꞌhin na nndaꞌ jndë tui, ya jntyꞌiahan, tityincyooꞌ ve tsꞌan ndyo ndëëhan, cüehan ndiaa quichiꞌ na quixuee jndyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Joꞌ tyue jndyi nanntcuꞌñeen, tyetangiohan xenꞌ tyuaachen. Jndue nanꞌñeen ndëëhan: —Juu tsꞌan na vandoꞌ, ¿Ndu na cojntꞌuehoꞌhin quiiꞌ ntꞌan ntꞌoo? ");
INSERT INTO azgNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tacꞌoonhin ntjoohin, jndë vandoꞌ xco jon na tueꞌ jon. Cañjoonꞌ nꞌonhoꞌ juu jñꞌoon na tso jon ndëëhoꞌ xjen na ninmꞌaan jon ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tso jon na nquii jon na conduihin tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na coꞌxen jon tsoñꞌen nnꞌan, mancüiixjen chuhanꞌ na nninncya nnꞌan cüentahin nduee nnꞌan na nanꞌxuan jnan, ndoꞌ njñonhin jon tsonjnꞌaan. Majoꞌ xee na jndë ndye, ngüandoꞌ xco jon. ");
INSERT INTO azgNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Yajoꞌ tañjoonꞌ nꞌonhan juu jñꞌoon na totso Jesús ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ndoꞌ joo nanntcuꞌñeen, jnanhan na vaa tsiꞌtsꞌua, tyꞌentcüeꞌhan na mꞌan nnꞌan quinchoꞌncüii yo minndyechen ntyjehan na conanꞌjonhan yo Jesús. Jnanꞌquindyiihan nanꞌñeen na nndaꞌ vaa ꞌnan na tui. ");
INSERT INTO azgNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Joo nanntcuꞌñeen na tyenanꞌquindyiihan nanꞌñeen, joꞌ María, tsan tsjoon Magadán, yo Juana, yo ncüiichen María ndyee juu Santiago, yo minndyechen ntyjentcuhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Majoꞌ joo nnꞌan quinchoꞌncüiiꞌñeen, juu jñꞌoon na jnanꞌnein nanntcuꞌñeen, tyꞌonhan cüentahanꞌ na veꞌ ninntyi jñꞌoonhanꞌ. Tatëntyja nꞌonhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Majoꞌ juu Pedro jeꞌ, jnanquintyja jon, jnannon jon, tja jon na vaa tsiꞌtsꞌuaꞌñeen. Ndoꞌ vi jndë na jndondyi jon quityquiiꞌhanꞌ, ntjii jon xiaꞌntyi ndiaa quichiꞌñeen minquintoꞌhanꞌ. Jndë joꞌ tëntcüeꞌ nndaꞌ jon vꞌaa, vacue tomꞌaanꞌ tsꞌon jon tsoñꞌen na jndë tui. ");
INSERT INTO azgNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Ndoꞌ quenꞌ cüenta, majuuntyi xueeꞌñeen, ve nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Jesús, tyꞌehan tsjoon chjo na jndyu Emaús, juuhanꞌ tycya mꞌaanhanꞌ yo Jerusalén chaꞌna quinchoꞌncüii kilómetros. ");
INSERT INTO azgNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Coꞌohan ndoꞌ tonanꞌnein nquehan tsoñꞌen nanꞌminꞌ na jndë tui. ");
INSERT INTO azgNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ndoꞌ viochen xjen na tyꞌehan, tonanꞌneinhan yo ntyjehan, ndoꞌ nquiintyi Jesús tentyja jonhan. Ninvixjen tja jon yo joohan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Majoꞌ min na jntyꞌia ndëëhan jon, tatyincyaahanꞌ na ntaꞌjnꞌaanhan nin tsꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ndoꞌ taxeeꞌ jon ndëëhan: —¿Nin jñꞌoon na conanꞌnein nquehoꞌ nato na coꞌohoꞌ? Ndoꞌ tyecüentyjeeꞌhan, tityincyooꞌ na chjooꞌ jndyi nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ndoꞌ ncüiihan, tsan na jndyu Cleofas, tꞌa juu ꞌndyo jon, tso juu: —¿Aa xiaꞌntyi ꞌuꞌ tsꞌan na veꞌ tyjeꞌ yaꞌ Jerusalén, ngꞌe joꞌ tyiꞌquintjiꞌ nchu vaa ꞌnan na tui vja ro ndoꞌ xee venjoonꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Joꞌ taxeeꞌ Jesús: —¿Nin ꞌnan tui? Joohan tꞌahan, jnduehan nnon jon: —Aa ntyja ꞌnaanꞌ Jesús, tsan tsjoon Nazaret na toninncyaa jon jñꞌoon naya ꞌnaanꞌ Tyoꞌtsꞌon. Ndoꞌ na tonnon Tyoꞌtsꞌon, jaaꞌ tsꞌian na totsꞌaa jon yo jñꞌoon na totsinin jon tondëë tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ndoꞌ nque ntyee na conintque yo nanmꞌannꞌian nján, tyincyahan cüenta jon na quitꞌuiityenhanꞌhin na cueꞌ jon. Joꞌ na jñon nnꞌanhin tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ndoꞌ já, jen tontyja nꞌö́n na nduihin na ntsiquindyaa jon jaa nnꞌan Israel. Ndoꞌ vandyaꞌ joꞌ, naneinhin jndë ndye xuee na tui nanꞌminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ndoꞌ chito xiaꞌntyi joꞌ, ñꞌen nanntcu tmaanꞌ na nanꞌxuán, jndyojnanꞌquindyiihan já jñꞌoon na siquijñꞌeenhanꞌ já. Ee vitsjoon tonco quiuuꞌ, tyꞌehan naijon na vaa juu tsiꞌtsꞌua, ");
INSERT INTO azgNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Majoꞌ tavi siꞌtsꞌo ꞌnaanꞌ jon cuaa. Ndoꞌ tyincyo ntcüeꞌhan, ndoꞌ tonduehan ndë́ na tityincyooꞌ ángeles ndëëhan, ndoꞌ na jndue nanꞌñeen ndëëhan na vandoꞌ xco jon. ");
INSERT INTO azgNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Jndë joꞌ tyꞌe minndye ntyjë́ naijon vaa juu tsiꞌtsꞌuaꞌñeen ndoꞌ jntyꞌiahan na mayuuꞌ chaꞌxjen na jndue nanntcuꞌñeen, majoꞌ nquii Jesús, taꞌnan jntyꞌiahanhin. ");
INSERT INTO azgNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yajoꞌ tso Jesús ndëëhan: —ꞌOꞌ nnꞌan na tyiꞌquitquenhoꞌ cüenta tsoñꞌen jñꞌoon na tondue nque nnꞌan na toninncyahan jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa, min tyiꞌcjooꞌ nꞌonhoꞌ na ngantyja nꞌonhoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mangiohoꞌ na nquii Mesías chuhanꞌ na ijndeiꞌhanꞌ na quitjon jon tsoñꞌen naviꞌminꞌ ndoꞌ jndëcya ngüentyja na ngityeꞌ na ntsitꞌmaanꞌ Tyoꞌtsꞌon jon. ");
INSERT INTO azgNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ndë joꞌ taꞌ Jesús na totsiꞌman jon ndëëhan tsoñꞌen jñꞌoon na chuuꞌ quiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon na itsininhanꞌ ntyja ꞌnaanꞌ nquii jon. Tyeꞌhanꞌ yo jñꞌoon na tquen Moisés ndoꞌ chen chen tꞌuiihanꞌ jñꞌoon na tquen tsoñꞌen nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon nchu vaa ꞌnan na nnguaa. ");
INSERT INTO azgNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Xjen na tëvindyohin tsjoon chjo naijon na coꞌohan, yajoꞌ sꞌaa jon na vjantyichen jon na tonnon. ");
INSERT INTO azgNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Majoꞌ jnanꞌjndeiꞌ jndyuehan nnon jon. Jnduehan: —Cüa ntyjë, quintjo ꞌuꞌ yo já ee jndë tman nanein, jndë vavinton. Joꞌ taqueeꞌ jon vꞌaaꞌñeen na ntjohin yo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ndoꞌ xjen na tecjo jon mesa yohin, tyꞌoon jon cüenta tyooꞌ, tyincyaa jon na ncya ya Tyoꞌtsꞌon, jndë joꞌ tyjee jon tanꞌhanꞌ, ndoꞌ tyincyaa jonhanꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Jndë na jntyꞌiahan na sꞌaa jon na nndaꞌ, yajoꞌ chaꞌvijon tyincyaahanꞌ na xuee jntyꞌiahan, ndoꞌ yajoꞌ taꞌjnꞌaanhan na nquii Jesús condui juu tsanꞌñeen. Majoꞌ ninjonto tsuhin tondëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ndoꞌ joꞌ taxeeꞌhan ndëë ntyjehan: —Aa tyiꞌyuuꞌ tyincyaahanꞌ na njon jndyi ngiö juu xjenꞌñeen na sinin jon ndëë na tincyö nato, na siꞌman jon nchu vaa itsiquindyi jñꞌoonꞌ Tyoꞌtsꞌon na tondui. ");
INSERT INTO azgNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ndoꞌ majuuntyi xjenꞌñeen jnanꞌquintyjahan, ndoꞌ tyentcüeꞌhan Jerusalén. Joꞌ squehan na mꞌan nque nnꞌan na quinchoꞌncüiiꞌñeen na tojnaanꞌ mꞌanhan yo minndyechen nnꞌan na totsayꞌonhan jñꞌoon yohan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ndoꞌ nque nnꞌan na quinchoꞌncüiiꞌñeen, jnduehan ndëë nanꞌñeen. —Jñꞌoon na mayuuꞌ na jndë vandoꞌ xco ta Jesús ee jndë tityincyooꞌ jon nnon Simón. ");
INSERT INTO azgNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ndoꞌ mantyi ve nanꞌñeen tonanꞌneinhan nchu vaa na tui xjen na njonhan nato ndoꞌ na taꞌjnꞌaanhan jon xjen na tyjee jon tanꞌ tyooꞌ yohan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ninvaa na conanꞌneinhan jñꞌoonminꞌ, ndoꞌ nquii Jesús tityincyooꞌ minntyjeeꞌ jon xoncüe quiiꞌ ntꞌanhan. Tso jon ndëëhan: —¿Aa tijaan yahoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Majoꞌ mioon tyuehan, sꞌaahanꞌ ngiohan na cojntyꞌiahan ncüaanꞌ tsꞌoo. ");
INSERT INTO azgNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ndoꞌ tso jon ndëëhan: —¿Ndu na jen itsiquijñꞌeenhanꞌ ꞌoꞌ ndoꞌ na ve vaa na mꞌaanꞌ nꞌonhoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Quijntyꞌiahoꞌ ntꞌö yo ngꞌë na mancöntyë ndö. Quitꞌuehoꞌ ja ndoꞌ quijntyꞌiahoꞌ ee ncüaanꞌ tsꞌoo min ndiꞌ min siiꞌ taꞌnan quichuhanꞌ, chaꞌxjen na cojntyꞌiahoꞌ na chö ja. ");
INSERT INTO azgNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ndoꞌ vi jndë na tso jon na nndaꞌ, siꞌman jon ntꞌö jon yo ngꞌee jon ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ndoꞌ sꞌaahanꞌ nꞌonhan na aa mayuuꞌ na nquii jon, majoꞌ mantyi tyincyaahanꞌ na neinhan ndoꞌ totsiquijñꞌeenhanꞌhin. Viochen xjen na tquenonhan na nndaꞌ, taxeeꞌ jon ndëëhan: —¿Aa vaa chjo ꞌnan na ya ntcüaꞌ tsꞌan? ");
INSERT INTO azgNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ndoꞌ tyincyahan ncüii tanꞌ quitscaa jnein. ");
INSERT INTO azgNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Tyꞌoon jonhanꞌ, ndoꞌ tquii jonhanꞌ na tondëëhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jndë joꞌ tso jon ndëëhan: —Viochen xjen na tomꞌan yohoꞌ, totsiꞌman ndëëhoꞌ nchu vaa itsiquindyi tsoñꞌen jñꞌoon na jndui ntyja njan na mꞌaanhanꞌ quiiꞌ juu jñꞌoon na tquen Moisés, ndoꞌ mantyi quiiꞌ jñꞌoon na toninncya nque nnꞌan na tonanꞌneinhan jñꞌoon ntyja ꞌnaan nchu vaa ꞌnan na nguaa. Jñꞌoonminꞌ majndaꞌ na quitsiquindëñꞌenhanꞌ joohanꞌ, ndoꞌ nanein jndë tui chaꞌxjen na totsjö ndëëhoꞌ ntyja ꞌnaanꞌ joo jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ndë joꞌ tyincyaa jon na jndaꞌ nquenhan na taaꞌ nꞌonhan nchu vaa itsiquindyi jñꞌoonꞌ Tyoꞌtsꞌon na tondui. ");
INSERT INTO azgNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ndoꞌ tso jon ndëëhan: —Jñꞌoon na jndui itsiquindyihanꞌ na nquii jon na conduihin Mesías, mancüiixjen ngenon jon naviꞌ tꞌman ndoꞌ xuee na jndë ndye na jndë tueꞌ jon, ngüandoꞌ xco jon. ");
INSERT INTO azgNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ndoꞌ yo xueeꞌ jon ninncya nnꞌan jñꞌoon na quintcüeꞌ nꞌon nnꞌan jnanhan chaꞌ na ntsitꞌman tsꞌon Tyoꞌtsꞌonhan. Juu tsꞌianꞌñeen, Jerusalén ngityeꞌhanꞌ, ngacyahanꞌ ninvaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Maꞌua tsꞌian ndëëhoꞌ na quitjiꞌ jndyoyuhoꞌ jñꞌoonminꞌ ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Mancöntyë njñön Espíritu Santo na ncꞌoon jon yohoꞌ. Nquii jon na jndë tcoꞌ Tyëhöꞌ ꞌndyo jon na nninncyaa jonhin quiiꞌ nꞌonhoꞌ. Majoꞌ quintjohoꞌ Jerusalén ata xjen na ncyꞌonhoꞌ cüentahin na nnan jon nandye, chaꞌ nnanꞌxuanhoꞌ najndei quiiꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ndoꞌ tachu Jesús joohan toꞌndyo tsjoon Jerusalén. Squehan ndyooꞌ tsjoon Betania. Juu xjenꞌñeen sintyja jon ntꞌö jon cjohan na ityio jon jnꞌaanhan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ndoꞌ juu xjen na ityio jon jnꞌaanhan, suehanꞌhin, tava ntcüeꞌ jon quiñoonꞌndue. ");
INSERT INTO azgNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ndoꞌ joohan jndë na jnanꞌtꞌmaanꞌhan jon, tyentcüeꞌhan Jerusalén na nein jndyihan. ");
INSERT INTO azgNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ninnquiiꞌchen toꞌohan vatsꞌon tꞌman na tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Xjen na taꞌ Tyoꞌtsꞌon na tquen jon tsoñꞌen, nquii jon na conduihin jñꞌoonꞌ Tyoꞌtsꞌon, mancüiixjen mꞌaan jon yohin. Ndoꞌ tsoñꞌen na condui nquii Tyoꞌtsꞌon, mantyi juu jon cüajon conduihin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Xjen na tyeꞌ tsoñꞌen, nquii jon na conduihin jñꞌoonꞌ Tyoꞌtsꞌon, mancüiixjen mꞌaan jon yo nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Tsoñꞌen ꞌnan na min na tquen Tyoꞌtsꞌon, nquii jon na condui jñꞌoonꞌ jon, ñꞌenhin xjen na tquenhan joohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Ntyja ꞌnaanꞌ nquii jon tsixuan jon na tyiꞌquintycüii na vandoꞌ jon. Juu na nndaꞌ tsixuan jon, itsijonhanꞌ juuhanꞌ chaꞌvijon chon na itsixueehanꞌ ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ndoꞌ juu naxuee na conduihin, itsiquinaanhanꞌ ncüii cüii nnon na coꞌnanꞌvehanꞌ nacjooꞌ Tyoꞌtsꞌon. Majoꞌ tsoñꞌenhanꞌ ndiquindëë na ngitoxenhanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nquii Tyoꞌtsꞌon tꞌua jon tsꞌian ncüii tsansꞌa na jndyu Juan na cjancyaa juu jñꞌoonꞌ jon quiiꞌ ntꞌan nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jndyo tsanꞌñeen na tꞌua Tyoꞌtsꞌon tsꞌian nnon jon na cüjiꞌ jndyoyu jon ntyja ꞌnaanꞌ nquii Cristo na conduihin naxuee. Tocüjiꞌ jndyoyu Juanꞌñeen chaꞌ tsoñꞌen nnꞌan ngantyja nꞌonhan Cristo. ");
INSERT INTO azgNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Majoꞌ chito aa juu Juan na conduihin juu naxueeꞌñeen, xiaꞌntyi jndyo jon na ncüjiꞌ jndyoyu jon ntyja ꞌnaanꞌ nquii jon na conduihin juu naxuee. ");
INSERT INTO azgNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nquii Cristo na conduihin juu naxuee na mayuuꞌ, tyjeeꞌ jon tsonnangue, ncyaa jon naxuee nnon ncüii cüii tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tomꞌaan jon yo nquii Tyoꞌtsꞌon xjen na tquenhan tsonnangue, ndoꞌ jndë joꞌ tyjeeꞌ jon quiiꞌ ntꞌan nnꞌan na mꞌanhanꞌ. Majoꞌ juu na tui Cristo na tsꞌanhin, tataaꞌ nꞌon nanꞌñeen nin conduihin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tui jon ndyuaa ꞌnaan nnꞌan judíos, majoꞌ tyíꞌcyꞌonhan cüenta jon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nincüanntyihan tyꞌonhan cüentahin, ndoꞌ tëntyja nꞌonhan jon. Ndëë joo nanꞌñeen tyincyaa jon na conduihan ntsinda nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Majoꞌ chito condui nanꞌñeen ntsinda jon chaꞌxjen na condui nda nnꞌan. Min chito conduihan ntsinda jon ngꞌe na tꞌman vaa na ntꞌue tsꞌon tsꞌan. Xiaꞌntyi icüjiꞌhanꞌ na condui nanꞌñeen ntsinda jon xengꞌe nquii jon ntꞌue tsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nquii jon na conduihin jñꞌoonꞌ Tyoꞌtsꞌon jnan jon naijon mꞌaan Tyëëhë Tyoꞌtsꞌon, tuihin na tsꞌanhin. Tꞌman vaa na venchjii jon nnꞌan ndoꞌ na conduihin na mayuuꞌ. Tomꞌaan jon quiiꞌ ntꞌán ndoꞌ jntyꞌiá ndë́ xjen na sitꞌmaanꞌ Tyoꞌtsꞌonhin. majuuhanꞌ na siquinjon Tyoꞌtsꞌonhin na conduihin jnda jon na ninncüii tsꞌonhin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juu tsanꞌñeen na jndyu Juan, tocüjiꞌ jndyoyu jon ntyja ꞌnaanꞌ jnda Tyoꞌtsꞌon xjen na sue juu jndyeeꞌ juu ndëë nnꞌan. Itso jon: “Mangiohoꞌ na jndë totsjö na ꞌio cha nnintyincyooꞌ ncüii tsꞌan quiiꞌ ntꞌanhoꞌ na minꞌchjo tyiꞌquitsijonhanꞌ ja yohin, ee mancüiixjen mꞌaan jon vitjachen na ndui ja. Majuu jon tsan na ndyovindyooꞌ ndö.” Ndöꞌ jñꞌoon na tso Juanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nquii Cristo tsoñꞌen naya condui jon. Ndoꞌ ntyja ꞌnaanꞌ jon, ityio Tyoꞌtsꞌon jnꞌaan tsoñꞌen jaa. Ncüii nnon naya na condui jon na jndë tyꞌön cüenta, ndë mañoon nnon na ndyontyja na ityio jon jnꞌaan jaa. ");
INSERT INTO azgNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nquii Tyoꞌtsꞌon tyincyaa jñꞌoon na coꞌxenhanꞌ nnon Moisés. Juu tsanꞌñeen tyincyaa jonhanꞌ ndëë nnꞌan. Majoꞌ ntyja ꞌnaanꞌ Jesucristo scüanon Tyoꞌtsꞌon jñꞌoon ntyja ꞌnaanꞌ juu naya na condui jon, ndoꞌ mantyi yo jñꞌoon na conduihanꞌ mayuuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nquii Tyoꞌtsꞌon, minꞌncüii tsꞌan tacondyiaaꞌhin. Xiaꞌntyi nquii Jnda jon na ninncüii tsꞌonhin na mantyi Tyoꞌtsꞌon conduihin, juu jon manchaꞌxjen mꞌaan jon yo tye jon, juu jon jndë siꞌman jon nchu vaa conduihin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nnꞌan na conintque ndëë nnꞌan Jerusalén, jñonhan ntyee ꞌnaanhan na mꞌaan Juanꞌñeen yo vendye nnꞌan tmaanꞌ levitas na cotyentjonhan quiiꞌ vatsꞌon tsjoonꞌñeen. Tꞌuahan tsꞌian ndëë nanꞌñeen na quitaꞌxeeꞌhan nnon Juan nin conduihin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Juu tsanꞌñeen tjiꞌ jndyoyu jon, itso jon: —Ja chito condui ja Mesías na ijñon Tyoꞌtsꞌon na coꞌxen jon ꞌoꞌ nchu vaa na cotsamꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ndoꞌ taxeeꞌntyichen nanꞌñeen nnon jon: —Yajoꞌ ¿Nin tsꞌan condui ꞌuꞌ? ¿Aa condui ꞌuꞌ nquii Elías, tsan na tomꞌaan ndyu na toxenꞌchen na toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa? Tꞌa jon, itso jon: —Min chitojoꞌ na condui ja. Majoꞌ tyíꞌquintjo ngiohan, taxeeꞌ nndaꞌhan nnon jon: —Tso Moisés na ncꞌoon ncüii tsꞌan na nninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndëë ntyja nchu vaa ꞌnan na nnguaa. ¿Aa condui ꞌuꞌ juu tsanꞌñeen? Majoꞌ tꞌa nndaꞌ jon, itso jon: —Min chito juu tsanꞌñeen condui ja. ");
INSERT INTO azgNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ndoꞌ jndue nndaꞌ nanꞌñeen nnon jon: —Yajoꞌ ¿Nin tsꞌan condui ꞌuꞌ? Cüa, quitsuꞌ ndë́ chaꞌ ya nnanꞌntcüꞌë́ jñꞌoon ndëë nnꞌan na tꞌuahan tsꞌian ndë́ na quitaꞌxꞌë́ nnonꞌ. ¿Nin matsuꞌ ntyja ꞌnaanꞌ juu tsꞌian na matsixuanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yajoꞌ sintcüeꞌ jon jñꞌoon ndëëhan, itso jon: —Ja matsꞌa chaꞌxjen na tso Isaías xjen na toninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen. Tso jon: “Mꞌaan ncüii tsꞌan na itsue jon jndyeeꞌ jon ndyuaa na tyiꞌjndye nnꞌan mꞌan. Quinanꞌjndaꞌhoꞌ na ncyꞌonhoꞌ cüenta nquii jon na tëquintyja na tꞌman conduihin na ntyeꞌntjon jonhoꞌ.” Nndaꞌ vaa jñꞌoon na sintcüeꞌ Juan ndëë nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nque nnꞌan na nanꞌxuan tmaanꞌ fariseos, joohan jñonhan nanꞌñeen na mꞌaan Juanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Yajoꞌ taxeeꞌntyichen nanꞌñeen nnon jon, jnduehan: —Matsuꞌ na chito condui ꞌuꞌ Cristo, min Elías, ndoꞌ min nquii tsan na itso Moisés na nninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ndëë jaa nnꞌan judíos ntyja nchu vaa ꞌnan na nguaa. Yajoꞌ ¿Ndu na matsiquindëꞌ nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Xjenꞌñeen tꞌa Juan jndyuehan, itso jon: —Ja matsiquintꞌë ꞌoꞌ yo ndaatioo, majoꞌ quiiꞌ ntꞌanhoꞌ mꞌaan ncüii tsꞌan na ninjoꞌ tyiꞌcovaaꞌ nꞌonhoꞌ nchu vaa conduihin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Manquii jon ntsꞌaa tsꞌian ꞌnaanꞌ Tyoꞌtsꞌon xjen na jndë jntyꞌiihanꞌ ja, ee mancüiixjen mꞌaan jon vitjachen na tui ja. Ndoꞌ min tsꞌian na tyiꞌnjon tsixuanhanꞌ, min tyiꞌquijntꞌue ja na ntyeꞌntjön nnon jon na ntsꞌahanꞌ. Ndöꞌ jñꞌoon sintcüeꞌ Juan. ");
INSERT INTO azgNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juu nanꞌvaꞌ tui ncüii joo na jndyu Betábara, ixndyaaꞌ jndaa Jordán naijon totsiquindëëꞌ Juan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tonco ncüiichen xuee, jndyiaaꞌ Juan na ndyovindyooꞌ Jesús na mꞌaan jon. Ndë́ já na tomꞌán yohin joꞌ, itso jon: “Quijntyꞌiahoꞌ, ndöꞌ ndyo nquii tsan na condui Quitsman Chjo tsjuenꞌ Tyoꞌtsꞌon na itsinduuꞌ jon jnan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mantyja ꞌnaanꞌ tsanvaꞌ na jndë totsjö ndëëhoꞌ na ꞌio cha nnintyincyooꞌ ncüii tsꞌan quiiꞌ ntꞌanhoꞌ na tꞌmanntyichen conduihin, chichen ja, ee mancüiixjen mꞌaan jon vitjachen na ndui ja. ");
INSERT INTO azgNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xjen na tꞌa na matsiquintꞌë nnꞌan yo ndaa, minꞌchjo tyiꞌcovaaꞌ tsꞌön na iꞌua Tyoꞌtsꞌon tsꞌian nnon jon na ntsinduuꞌ jon jnan nnꞌan. Majoꞌ matsꞌa tsꞌianva chaꞌ quitsiꞌman jndyoyuhanꞌ ndëë ꞌoꞌ ntyjë nnꞌan Israel na joꞌ conduihin.” ");
INSERT INTO azgNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ndoꞌ nquii Juanꞌñeen, tjiꞌ jndyoyuntyichen jon ndë́, itso jon: “Jntyꞌia nnön na nquii Espíritu Santo jnan jon quiñoonꞌndue, jndyocue jon na chaꞌvijon quituꞌ, ntjohin yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ndoꞌ juu xjenꞌñeen min tyíꞌcovaaꞌ tsꞌön nin juu na ndui na ntsinduuꞌ jnan nnꞌan. Majoꞌ tëñjoonꞌ tsꞌön xjen na tꞌua Tyoꞌtsꞌon tsꞌian nnön na quitsiquintꞌë nnꞌan, tso jon nnön: Nndyiaꞌ nnonꞌ na nndyocue Espíritu Santo cjooꞌ ncüii tsꞌan, ndoꞌ ntjohin yo jon. Juu tsanꞌñeen jndë tꞌua tsꞌian nnon jon na ntsiquindëëꞌ jon nnꞌan yo Espíritu Santo.” Ndoꞌ sininntyichen Juan, itso jon: ");
INSERT INTO azgNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","“Ndoꞌ mancö jndë jntyꞌia nnön na tui na nndaꞌ, mangꞌe joꞌ macüjiꞌ jndyoyu na nquii jon conduihin jnda Tyoꞌtsꞌon.” ");
INSERT INTO azgNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tonco ncüiichen xuee, ventyjeeꞌ nndaꞌ Juan yo ve já na totsayꞌö́n yo jñꞌoon na toninncyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ndoꞌ juu xjen na jndyiaaꞌ jon na venon Jesús joꞌ, itso jon ndë́: —Quijntyꞌiahoꞌ, tsanvaꞌ conduihin juu Quitsman Chjo tsjuenꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ndoꞌ ve já na tosayꞌö́n yo jñꞌoon na toninncyaa jon, vi na jndë jndyë́ jñꞌoonvaꞌ, santyjá toxenꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ndoꞌ tequen Jesús, jndyiaaꞌ jon na santyjá na toxenꞌ jon. Yajoꞌ taxeeꞌ jon ndë́, tso jon —¿Aa vaa ꞌnan na ntꞌahoꞌ ja? Joꞌ jnduë́ nnon jon: —Rabí, ¿Yuu vijon vaa vꞌaa na ntjo ꞌuꞌ neinhin? Juu jñꞌoon Rabíꞌñeen itsiquindyihanꞌ tsꞌan na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ndoꞌ tꞌa jon jndyuë́: —Ncyohoꞌ na njntyꞌiahoꞌ. Yajoꞌ sá yohin vꞌaa na tueeꞌ jon. Squë́ yohin joꞌ chaꞌna nenque na matman. ");
INSERT INTO azgNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ja Juan yo ninꞌAndrés, tyje juu Simón Pedro, já jndyë́ jñꞌoonꞌñeen na tso Juan, ndoꞌ sananꞌjö́n yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Jndë joꞌ tëquintꞌue Andrésꞌñeen xio jon Simón. Itso juu nnon jon: —Jndë jndiö́ nquii jon na conduihin Mesías. (Yo jñꞌoon na conanꞌnein nnꞌan judíos, juu jñꞌoonvaꞌ tsiꞌmanhanꞌ Cristo, nquii jon na iꞌua Tyoꞌtsꞌon tsꞌian nnon na ntsinꞌman jon ñuaan nnꞌan.) ");
INSERT INTO azgNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ndoꞌ tëyꞌoon Andrés xio jon na mꞌaan Jesús. Xjen na jndyiaaꞌ Jesús juu, itso jon: —ꞌUꞌ jndyuꞌ Simón, tyeꞌ jndyu jon Juan. Ja ntsiquijndyu ꞌuꞌ Cefas. (Jñꞌoonvaꞌ itsiquindyihanꞌ Pedro.) ");
INSERT INTO azgNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tonco ncüiichen xuee, sijndaꞌ Jesús na chi ncja jon ndyuaa Galilea. Joꞌ tjonhin Felipe. Tso jon nnon juu: —Quindyotsijon ꞌuꞌ yo jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ndoꞌ juu Felipeꞌñeen maninncüii tsjoonꞌ jon yo Andrés yo ninꞌPedro. Joohan nnꞌan tsjoon Betsaida. ");
INSERT INTO azgNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ndë joꞌ juu Felipe tëquintꞌue jon Natanael. Tso jon nnon juu: —Nnon tson na tji Moisés na chuhanꞌ jñꞌoonꞌ Tyoꞌtsꞌon na icoꞌxenhanꞌ, itsiquindyihanꞌ ntyja ꞌnaanꞌ nquii jon na conduihin na ntsinꞌman jon ñuaan nnꞌan. Jndë jndiö́hin. Mantyi nque nnꞌan na toninncya jñꞌoon nchu vaa ꞌnan na nguaa, vendyehan totjihan jñꞌoon ntyja ꞌnaanꞌ tsanvaꞌ, na majuu Jesús, tsan tsjoon Nazaret, na condue nnꞌan jnda Joséhin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tso Natanael: —Chaꞌna juu tsjoon Nazaret, ¿Aa nnintyincyooꞌ ncüii tsꞌan na tꞌman na ntejndei jon nnꞌan? Tꞌa Felipeꞌñeen, itso juu: —Quindyoꞌ ndo quindyiaꞌ nnonꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jndyiaaꞌ Jesús na ndyovindyooꞌ Natanael. Itso jon: —Quijntyꞌiahoꞌ, tsanvaꞌ conduihin tsꞌan tyiꞌquitsiviꞌnnꞌan jon nnꞌan. Juu jon mayuuꞌ conduihin tsꞌan tsjan Israel. ");
INSERT INTO azgNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ndoꞌ taxeeꞌ Natanael nnon Jesús: —Ta, ¿Nchu saꞌ na taaꞌ tsonꞌ na nndaꞌ tsixuan ja? Tꞌa Jesús, itso jon: —Vitjachen na ngaquiꞌman Felipe ꞌuꞌ, jntyꞌia na mꞌanꞌ vaꞌ, xꞌee tsꞌoon higuera ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ndoꞌ tꞌa Natanael, tso juu: —Condui ꞌuꞌ tsan na itsiꞌman jñꞌoon naya ndëë nnꞌan, ꞌuꞌ condui jnda Tyoꞌtsꞌon. Ndoꞌ taquintyja ꞌuꞌ tꞌman condui ntyja njan jaa nnꞌan Israel. ");
INSERT INTO azgNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tꞌa Jesús: —Aa veꞌ ngꞌe tsjö na jntyꞌia ꞌuꞌ xꞌee tsꞌoon higuera ꞌnanꞌ, ¿Aa veꞌ joꞌ na mavantyja tsonꞌ ja? ꞌNan na tꞌmanntyichen min ntyja njan na xejnda ndyiaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ndoꞌ sininntyichen Jesús, tso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, njntyꞌiahoꞌ na nnaan quiñoonꞌndue. Ndoꞌ ja na condui tsansꞌa na jñon Tyoꞌtsꞌon quiiꞌ ntꞌan nnꞌan, njntyꞌiahoꞌ ncyocue ángeles na mꞌan ndoꞌ na ngova nndaꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Xee na jndë ndye na tui na nndaꞌ, toco tsꞌan tsjoon Caná ndyuaa Galilea. Ndoꞌ joo nanꞌñeen na ntonco, jnanꞌquindyiihan ndyee Jesús na chi ncja jon chjo. ");
INSERT INTO azgNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ndoꞌ mantyi tꞌmanhan nquii Jesús yo já na ncꞌö́n yohan xjen na ntoncohan. ");
INSERT INTO azgNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ndoꞌ xjenꞌñeen, juu vinon na tijntꞌuehan, ntycüiihanꞌ. Joꞌ tso ndyee Jesús nnon jon: —Tyiꞌcüinon vinon, jndë ntycüiihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ndoꞌ tꞌa Jesús ꞌndyo jon: —Nndaꞌ ꞌndyoꞌ, tyiꞌquichuhanꞌ na ntsijndaꞌ tsꞌian na ntsꞌa. Tyiꞌcoventyja xjen na ntsꞌa ncüii nnon tsꞌian na tyiꞌjeꞌquindëë nduihanꞌ na veꞌ ntyja ꞌnaanꞌ juu najndei na tsixuan tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Majoꞌ itso ndyee jon ndëë nnꞌan na cotyentjon joꞌ: —Minꞌcya nnon ꞌnan na ngitso jon ndëëhoꞌ, quitaꞌngueeꞌhoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Min jñꞌoon na icoꞌxenhanꞌ jaa nnꞌan judíos ntyja nchu vaa na cotquën na jiꞌua ꞌnan na coninjntꞌue jaa na conanꞌtꞌmaanꞌ Tyoꞌtsꞌon. Juu vꞌaaꞌñeen min yon ntjö tꞌman na jndëhanꞌ yo ntjöꞌ na coninjntꞌuehanꞌ na conanꞌquindë costumbre na cotman ndueehan yo ꞌnan. Ncüii cüii ntjöꞌñeen coninnon chaꞌna ncüii ciento litros ndaahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Joꞌ tso Jesús ndëë nnꞌan na cotyentjon joꞌ: —Quinanꞌquitooꞌhoꞌ ntjömin yo ndaa. Ndoꞌ jnanꞌquitooꞌchenhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jndë joꞌ tso jon ndëëhan: —Neinhin quitjiꞌhoꞌ chjohanꞌ. Quitsayꞌonhoꞌhanꞌ na mꞌaan tsantque ꞌndyo vꞌaa. Ndoꞌ tyeyꞌonhan juuhanꞌ na mꞌaan tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ndoꞌ tꞌu tsanꞌñeen chjoviꞌ ndaaꞌñeen na scüaquen Jesús vinonhanꞌ. Tsanꞌñeen min tyiꞌquintjii jon yuu va jnanhanꞌ, majoꞌ nque nanꞌñeen na cotyentjon joꞌ, ngio yahan yuujon jnduiꞌhanꞌ. Ndoꞌ tꞌman jon juu novio. ");
INSERT INTO azgNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Itso jon nnon juu: —Tyiꞌncüii cüii joo na maca na cotonco nnꞌan, coninncya jndyeehan vinon na yantyichen na ncüe ntyjehan. Ndoꞌ vi na jndë vacjo nanꞌñeen na covehan, yajoꞌ coninncyahan vinon na tyiꞌcüentyjachen na ya. Majoꞌ ꞌuꞌ jeꞌ, sueꞌ vinon na yantyichen na nanein coninjntꞌuehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Juuhanꞌ jnꞌaan tꞌman na vejndyeengue na sꞌaa Jesús na tueeꞌ jon Caná ndyuaa Galilea. Juu tsꞌianꞌñeen siꞌman nquiiꞌhanꞌ na tꞌman jndyi conduihin. Ndoꞌ ngꞌe na nndaꞌ, já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, tyeꞌ na vantyja nꞌö́nhin. ");
INSERT INTO azgNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jndë na tui na nndaꞌ, já nnꞌan na cotsayꞌö́n yo jñꞌoon na toninncyaa jon, sá yohin tsjoon Capernaum, mantyi tja ndyee jon yo nque ntyje jon. Ndoꞌ ntjo já joꞌ yohin vendye xuee. Jndë joꞌ jntꞌuí ntcüꞌë́ yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juu xjenꞌñeen vavindyo na ngueeꞌ nguee pascua xjen jaa nnꞌan judíos conanꞌcüjë quinman na conanꞌtꞌmaanꞌ Tyoꞌtsꞌon. Yajoꞌ sá Jerusalén yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ndoꞌ tochꞌeenꞌ vatsꞌon tꞌman njan jaa nnꞌan judíos, joꞌ ntjii jon nnꞌan na condëë ndoro, quinman ndoꞌ yo ninꞌquintuꞌ. Ndoꞌ mantyi joꞌ minndyuaa nnꞌan na conanꞌjndyo sꞌon ꞌnaan nnꞌan na cotsque yahan juu vatsꞌonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndoꞌ ya jndyiaaꞌ jon na nndaꞌ vaa na tontꞌa nanꞌñeen, tijntꞌue jon tsꞌua, sia jon tjantsiꞌ. Ndë joꞌ jntyꞌe jon nanꞌñeen yohanꞌ. Tsoñꞌen nanꞌñeen tjiꞌ jonhan chꞌeenꞌ juu vatsꞌonꞌñeen. Majoꞌntyi sꞌaa jon yo quinman yo ninꞌndoroꞌñeen. Ndoꞌ mesa na conanꞌcho nnꞌan na conanꞌjndyo sꞌon, siquityeeꞌ jonhanꞌ. Iscyaa jon sꞌon ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ndoꞌ itso jon ndëë nnꞌan na condëë quintuꞌ: —Quitjiꞌhoꞌ choꞌminꞌ ntjoohin. Juu vaaꞌ Tyëhöꞌ, tantꞌahoꞌ juuhanꞌ chaꞌvijon tsꞌua. ");
INSERT INTO azgNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ndoꞌ na sꞌaa jon na nndaꞌ, já nnꞌan na tꞌman jon na totsayꞌö́n yo jñꞌoon na toninncyaa jon, tañjoonꞌ nꞌö́n juu jñꞌoon na chuuꞌ nnon tson Salmos. Itsiquindyihanꞌ: “Mancüiixjen nnanꞌcueeꞌ nnꞌan ja tsojnaanꞌ na ntꞌue tsꞌön na quintꞌa nnꞌan na njon vaaꞌ Tyëhöꞌ chaꞌxjen na chuhanꞌ.” Manndaꞌ itsiquindyi juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Yajoꞌ nnꞌan judíos na conintquehan quiiꞌ ntꞌan ntyjehan, taxeeꞌhan nnon jon, jnduehan: —¿Nin tsꞌian ntsaꞌ na tyiꞌjeꞌquinduihanꞌ na veꞌ yo najndei nquii tsꞌan na ntsiꞌmanhanꞌ ndë́ na vaa najndei na condui ꞌuꞌ na matsaꞌ na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tꞌa Jesús, itso jon: —Juu vꞌaavahin, quinanꞌtyuiiꞌhoꞌhanꞌ ndoꞌ ja ninndye xuee ntsuë ntcüꞌëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Nanꞌñeen jnanꞌntcüeꞌhan jñꞌoon nnon jon, jnduehan: —Tëca vennꞌan vantjoꞌ yon chu na jndë vatsꞌon tꞌman njan, ndoꞌ ꞌuꞌ aa veꞌ ninndye xuee na ntsueꞌ ntcüeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Majoꞌ sijoonꞌ jon juu siꞌtsꞌo ꞌnaanꞌ jon na conduihanꞌ chaꞌvijon vatsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Joꞌ vi na tyincyaa Tyoꞌtsꞌon na vandoꞌ xco jon na jndë jnanꞌcueeꞌ nnꞌan jon, já nnꞌan na tondyë́ jñꞌoon na toninncyaa jon, tëñjoonꞌ nꞌö́n na tso jon na nndaꞌ. Ndoꞌ mantyi tëntyja nꞌö́n jñꞌoon na sinin jon yo juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui ndyu na toxenꞌchen. ");
INSERT INTO azgNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Viochen xjen na tomꞌaan Jesús Jerusalén na tꞌoon nguee pascüa, juu xjenꞌñeen jaa nnꞌan judíos conanꞌcüjë quinman na conanꞌtꞌmaanꞌ jaa Tyoꞌtsꞌon. Joo nnꞌan na mꞌan ngueeꞌñeen tojntyꞌiahan jndye nnon tsꞌian na totsꞌaa Jesús na tyiꞌjeꞌquindëë nduihanꞌ na veꞌ ntyja ꞌnaanꞌ najndei na tsixuan nquii tsꞌan. Ngꞌe joꞌ jndye nanꞌñeen tëntyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Majoꞌ Jesús tyiꞌtque ntyjii jon yo joohan, ee ntyjii ya jon nchu vaa ꞌnan na ndyiiꞌ nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Min tyiꞌicanhanꞌ na ngitso jndyoyu tsꞌan nnon jon nchu vaa nanꞌxuan nnꞌan, ee ntyjii ya jon nchu min quiiꞌ nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Quiiꞌ juu tmaanꞌ nnꞌan fariseos, tomꞌaan ncüii tsꞌan jndyu Nicodemo. Tonintquehin quiiꞌ ntꞌan ntyje jon nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Tja jon na mꞌaan Jesús ncüii tijaan. Itso jon nnon Jesús: —Nndaꞌ ta, ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë nnꞌan, mangiö́ na condui ꞌuꞌ tsꞌan na jñon Tyoꞌtsꞌon na quitsiꞌmanꞌ jñꞌoon naya ꞌnaanꞌ jon ndë́. Ee xe na aa tyiꞌcꞌoonhin yo ꞌuꞌ, tyiꞌjeꞌquindëë ntsaꞌ tsꞌianminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Tꞌa Jesús, itso jon: —Jñꞌoon na mayuuꞌ na matsjö nnonꞌ, xe na aa tyiꞌndui xcohoꞌ, tyiꞌjeꞌquindëë ntsaqueꞌhoꞌ ntyja ꞌnaanꞌ na ityeꞌntjon Tyoꞌtsꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ndoꞌ joꞌ taxeeꞌ Nicodemo nnon jon, itso juu: —Juu tsꞌan na jndë tque, ¿Nchu vaa nquii ntsꞌaa jon na nndui nndaꞌhin? Ee tyiꞌxeꞌquindëë ngua nndaꞌ jon tsiaaꞌ ndyee jon ndoꞌ na nndui nndaꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Tꞌa Jesús, itso jon: —Jñꞌoon na mayuuꞌ matsjö nnonꞌ, xe na aa tyiꞌndui tsꞌan ntyja ꞌnaanꞌ ndaa yo ntyja ꞌnaanꞌ Espíritu, tyiꞌxeꞌquindëë ntsijonhin yo juu na ityeꞌntjon Tyoꞌtsꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ngꞌe na condui jaa nnꞌan, joꞌ mantyi nda mannꞌanhan. Manndaꞌ vaa itsijonhanꞌ tsꞌan na nnduihin ntyja ꞌnaanꞌ Espíritu. Tsꞌan na tui ntyja ꞌnaanꞌ jon condui tsanꞌñeen ntyja ꞌnaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tyiꞌninncyaꞌ na ntsiquijñꞌeenhanꞌ ꞌuꞌ yo juu jñꞌoon na matsjö: “Chuhanꞌ na quindui xcohoꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Juu xjen na mꞌan jndye, nndyiꞌ na cꞌuaa na camꞌaanhanꞌ, majoꞌ tyiꞌquintjiꞌ yuu jon jnanhanꞌ, min yuuva na vjahanꞌ. Manndaꞌ vaa itsijonhanꞌ na ndicüaaꞌ tsꞌon tsꞌan nchu vaa na nndui ncüiichen tyje juu ntyja ꞌnaanꞌ Espíritu. ");
INSERT INTO azgNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tꞌa nndaꞌ Nicodemo, itso juu nnon Jesús: —Ja ninjoꞌ ndicüaaꞌ tsꞌön. ");
INSERT INTO azgNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Itso Jesús: —Cüa joꞌ, ndoꞌ tꞌman tsꞌan condui ꞌuꞌ na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndëë ntyjëëhë nnꞌan Israel. Ngꞌe joꞌ tyiꞌquitsitiu na ndicüaaꞌ tsonꞌ jñꞌoonminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Jñꞌoon na mayuuꞌ matsjö nnonꞌ. Matsinën ntyja ꞌnaan ꞌnan na ntyji ndoꞌ macüjiꞌ jndyoyu ꞌnan jndë jntyꞌia nnön, majoꞌ ꞌoꞌ tyiꞌninꞌcantyja nꞌonhoꞌ juu jñꞌoon na macüjiꞌ jndyoyu. ");
INSERT INTO azgNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jndë matsinën ndëëhoꞌ ntyja ꞌnaan ꞌnan na min nnon tsonnangue chaꞌ cüaaꞌ nꞌonhoꞌ, majoꞌ tyiꞌninꞌcantyja nꞌonhoꞌ ntyja ꞌnaanhanꞌ. Ya joꞌ ¿Nchu vaa nquii ntsꞌa chaꞌ ngantyja nꞌonhoꞌ juu jñꞌoon na mancya ntyja ꞌnaanꞌ quiñoonꞌndue? ");
INSERT INTO azgNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","“Taꞌnan ncüii tsꞌan tsonnangue na jndë tëva quiñoonꞌndue chaꞌ nndëë ntsiquindyi juu nnꞌan nin ꞌnan na quintꞌahan chaꞌ ntjo ya ntyjii Tyoꞌtsꞌon yohan. Xiaꞌntyi ncö na condui tsansꞌa na jñon Tyoꞌtsꞌon quiiꞌ ntꞌan nnꞌan, mavaaꞌ ya tsꞌön nchu vaa ꞌnan ntyjii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Xjen na tomꞌan nnꞌan judíos ndyuaa naijon na tyiꞌjndye nnꞌan mꞌan, cjooꞌ ncüii tsꞌoon tꞌion Moisés ncüii xjo na sia jonhanꞌ chaꞌ vaa quitsu. Ja na condui tsansꞌa na jñon Tyoꞌtsꞌon ja quiiꞌ ntꞌanhoꞌ, manndaꞌ vaa ntꞌion nnꞌan ja tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nndaꞌ ngenön chaꞌ minꞌcya ro tsꞌan na vantyja tsꞌon juu ja, nninncyaa Tyoꞌtsꞌon na tyiꞌquintycüii na ngüandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Nquii Tyoꞌtson tꞌman jndyi vaa na viꞌnchjii jon nnꞌan tsonnangue, joꞌ nquii Jnda jon na nincüii tsꞌonhin, tyincyaa jonhin na ndyion jon jnan nnꞌan. Ndöꞌ vaa na itsꞌaa jon, chaꞌ minꞌcya ro tsꞌan na vantyja tsꞌon juuhin, tyiꞌxeꞌquitsu ñuaanꞌ juu, tsixuan juu na tyiꞌquintycüii na vandoꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ee chito jñon Tyoꞌtsꞌon Jnda jon ndëë nnꞌan tsonnangue, chaꞌ quitꞌuiiviꞌhanꞌhin tsojnaanꞌ jnanhan. Iꞌua Tyoꞌtson tsꞌianꞌñeen nnon Jnda jon na ntsinꞌman jon ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Minꞌninchen tsꞌan na vantyja tsꞌon juuhin, xeꞌquitꞌuii Tyoꞌtsꞌon tsanꞌñeen ntyja ꞌnaanꞌ jnaanꞌ juu. Majoꞌ juu tsꞌan na tyiꞌninꞌcantyja tsꞌon juuhin, itsijndaꞌhanꞌ ntyja ꞌnaanꞌ juu na itꞌuiiviꞌhanꞌhin ngꞌe nquii Jnda Tyoꞌtsꞌon na ninꞌncüii tsꞌonhin, tyiꞌninꞌcantyja tsꞌon juuhin. ");
INSERT INTO azgNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ndö vaa jñꞌoon na itꞌuiiviꞌhanꞌ nnꞌan: Nquii jon na conduihin naxuee, tyjeeꞌnon jon quiiꞌ ntꞌan nnꞌan tsonnangue, majoꞌ njonntyichen ngiohan ꞌnan natyia na contꞌahan, chichen nquii jon na conduihin naxuee. Nndaꞌ vaa ngꞌe joo ꞌnan na contꞌahan, tyia jndyi nanꞌxuanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ncüii cüii tsꞌan na itsꞌaa ꞌnan tyia, jndooꞌ jndyi tsanꞌñeen nquii jon na conduihin na naxuee. Tyiꞌninꞌquitsijonhin ntyja ꞌnaan jon ee ncyaaꞌ juu na ntsiquinan jon ntyja ꞌnaanꞌ natyia na itsꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Majoꞌ juu tsꞌan na itsijonhin yo ntyja ꞌnaanꞌ na mayuuꞌ, itsijon tsanꞌñeen yo nquii jon na conduihin naxuee. Ndoꞌ na nndaꞌ vaa, covityincyooꞌ ya na tsoñꞌen ꞌnan na itsꞌaa tsanꞌñeen, itsꞌaa jonhanꞌ ngꞌe na itsiquindëë jon tonnon Tyoꞌtsꞌon.” ");
INSERT INTO azgNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jndë na tui na nndaꞌ, jnduiꞌ Jesús Jerusalén, ndoꞌ já nnꞌan na tqueenꞌ jon na quitsayꞌö́n jñꞌoon yohin, mantyi sá yohin. Tomantyꞌí yohin ndyuaa Judea. Joꞌ ntjo já vendye xuee, ndoꞌ jndye nnꞌan squenon na mꞌaan jon na ninꞌquintꞌëhan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mantyi juu Juan totsiquindëëꞌ jon nnꞌan ncüii joo na jndyu Enón, ndyo Salim, ee joꞌ jndye ndaa mꞌaan. Ndoꞌ toꞌo nnꞌan na mꞌaan jon na totsiquindëëꞌ jonhan. ");
INSERT INTO azgNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ee juu xjenꞌñeen tacotyiiꞌ Herodes jon vancjo. ");
INSERT INTO azgNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nque nnꞌan na tonanꞌjonhan yo juu jñꞌoon na toninncyaa Juan, jnanꞌjndyehan jndyuehan yo ncüii ntyjehan tsꞌan judío. Conanꞌneinhan yuu vaa tsꞌian na yantyi na ntquenhanꞌ tsꞌan na jiꞌua conduihin tonnon Tyoꞌtsꞌon. ¿Aa ntyja ꞌnaanꞌ Jesús, ndoꞌ aa ntyja ꞌnaanꞌ Juan? ");
INSERT INTO azgNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ndoꞌ joo nnꞌan na totsayꞌonhan yo jñꞌoon na toninncyaa Juan, squenonhan na mꞌaan jon. Jnduehan nnon jon: —ꞌUꞌ ta na matsiꞌmanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndë́, juu tsan na toquiñꞌen yo ꞌuꞌ ixndya jndaa Jordán, manquiintyi juu tsan na tjiꞌ jndyoyuꞌ ntyja ꞌnaanꞌ jon ndë́, quindyiaꞌ, contꞌë nnꞌan ntyja ꞌnaanꞌ jon, ndoꞌ tsoñꞌen nnꞌan cotsantyja toxenꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ndoꞌ tꞌa Juan jndyuehan, itso jon: —Taꞌnan ncüii nnon tsꞌian na nndëë ntsꞌaa tsꞌan xe chito nquii Tyoꞌtsꞌon itsijndaꞌ jon na ntsixuan juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Manquehoꞌ ngiohoꞌ na tsjö ntyja njan na chito Mesías condui ja. Tyoꞌtsꞌon tꞌua jon tsꞌian nnön na jndyö jndyë na tonnon nquii Mesías, chaꞌ joo nnꞌan ncyꞌonhan cüenta nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ꞌOꞌ covaaꞌ nꞌonhoꞌ juu jñꞌoon na tyiꞌquitsiꞌman nquiiꞌ ntyja ꞌnaanꞌ juu tsansꞌa na ncyꞌoon juu cüenta yuscu yo na ngoco jon. Majoꞌ juu tsan na itsijonhin yo juu tsansꞌaꞌñeen, tyiꞌvajndyiꞌ tsꞌon juu tyje juu na ncyꞌoon tsanꞌñeen cüenta juu yuscuꞌñeen. Coquioo na neiinꞌ juu na ndyii juu jñꞌoon na itsinin tyje juu na ngoco tsanꞌñeen yo yuscuꞌñeen. Manndaꞌ ro incyaahanꞌ na nën na mantyꞌia na conanꞌjon nnꞌan ntyja ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ngꞌe na nndaꞌ, ꞌio ꞌio chuhanꞌ na nquii jon nganditꞌman ngio nnꞌan yohin, majoꞌ ja cantycüii ntyja na condui ja. ");
INSERT INTO azgNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ndoꞌ tsontyichen Juan: Tsanvaꞌ jnan jon quiñoonꞌndue, ngꞌe joꞌ njonntyichen conduihin, chito tsoñꞌen nnꞌan. Ja na veꞌ tsꞌan ja, matsixuan ntyja ꞌnaanꞌ tsonnangue ndoꞌ matsinën ntyja ꞌnaanꞌhanꞌ. Majoꞌ nquii tsanvaꞌ na jnan jon quiñoonꞌndue, njonntyichen conduihin na tsoñꞌen. ");
INSERT INTO azgNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ndoꞌ ntsinin jndyoyu jon ꞌnan na jndë jndyiaaꞌ jon yo na jndë jndyii jon, majoꞌ tanin juu ninꞌcyꞌoon cüenta juu jñꞌoon na icüjiꞌ jndyoyu jon. ");
INSERT INTO azgNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Minninchen tsꞌan na iyꞌoon juu cüenta jñꞌoon na icüjiꞌ jndyoyu jon ntyja ꞌnaanꞌ nquii jon, mantyi icüjiꞌ jndyoyu tsanꞌñeen na joo jñꞌoon itsiquindyii Tyoꞌtsꞌon ntyja ꞌnaanꞌ Jesús, tsoñꞌenhanꞌ conduihanꞌ na mayuuꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ee nquii tsan na jñon Tyoꞌtsꞌon quiiꞌ ntꞌan nnꞌan, itsinin juu jñꞌoonꞌ jon, tyiꞌcacuaa xjen incyaa jon Espíritu cüentaaꞌ jon quiiꞌ tsꞌon jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nquii Tyoꞌtsꞌon na conduihin Tyëëhë, venchjii jon nquii juu na conduihin jnda jon. Tsoñꞌen nnon na min, jndë tyincyaa jonhanꞌ ntꞌö juu. ");
INSERT INTO azgNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Minninchen tsꞌan na vantyja tsꞌon juu jnda Tyoꞌtsꞌon, itsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. Majoꞌ juu tsꞌan na tyiꞌquitsijñꞌoonꞌ na ngantyja tsꞌon jnda Tyoꞌtsꞌon, tyiꞌjeꞌquindaaꞌ tsanꞌñeen na ngüandoꞌ ñuaanꞌ juu. Ntyja ꞌnaanꞌhanꞌ ntꞌuiiviꞌ jonhin. ");
INSERT INTO azgNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nnꞌan tmaanꞌ fariseos tondyehan na majndyentyi nnꞌan totsayꞌonhan yo jñꞌoon na toninncyaa Jesús ndoꞌ na jntꞌëhan ntyja ꞌnaanꞌ jon, chintyi joo nnꞌan na tonanꞌjonhan ntyja ꞌnaanꞌ Juan. ");
INSERT INTO azgNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Majoꞌ chito nquii Jesús totsiquindëëꞌ jon nanꞌñeen. Xiaꞌntyi já nnꞌan na tꞌman jon na conanꞌjö́n yohin, já tontꞌá tsꞌianꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Vi na jndë jndyii Jesús na nndaꞌ tondue fariseosꞌñeen, jnduiꞌ jon ndyuaa Judea, tja ntcüeꞌ jon Galilea, sá yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ndoꞌ na sá joꞌ, tcanhanꞌ na ngüenö́n ndyuaa Samaria. ");
INSERT INTO azgNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Joꞌ squë́ ncüii tsjoon na jndyu Sicar na mꞌaanhanꞌ juu ndyuaaꞌñeen. Tsjoonꞌñeen ndyo mꞌaanhanꞌ naijon na vaa tyuaa na jndaaꞌ José nnon tsotye jon Jacob. ");
INSERT INTO azgNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Joꞌ vaa tsuiꞌ na sia nquii Jacobꞌñeen. Ngꞌe na tejndyaaꞌ Jesús na jndyo jon nato, joꞌ tëcjo jon naijon vaa juu tsuiꞌñeen. Xjenꞌñeen mandyo ngueeꞌ yajminꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Ndoꞌ juu xjenꞌñeen ncüii tsanscu Samaria tyjeeꞌnon juu na tacüjiꞌ juu ndaatioo. Itso jon nnon juu: —Ncyaꞌ chjo ndaa ncꞌua. ");
INSERT INTO azgNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Juu xjenꞌñeen, já nnꞌan na tꞌman jon na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, jndë sá tsjoonꞌñeen, sananꞌjndá chjo ꞌnan na chi ntcüꞌá yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Ndoꞌ tsanscuꞌñeen sintcüeꞌ juu jñꞌoon, itso juu: —ꞌUꞌ condui tsꞌan judío ndoꞌ ja condui tsꞌan ndyuaa Samaria. Joꞌ ndicüaaꞌ tsꞌön ndu nnön macanꞌ ndaa. Nndaꞌ jñꞌoon tso tsanscuꞌñeen ngꞌe joo nnꞌan judíos tyiꞌquijndooꞌhan nnꞌan Samaria. ");
INSERT INTO azgNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ndoꞌ tꞌa Jesús ꞌndyo juu, itso jon: —Xe mavaaꞌ tsonꞌ na njon jndyi tsixuan juu naya na ninꞌquitsiquindaaꞌ Tyoꞌtsꞌon ꞌuꞌ, ndoꞌ nin condui ja na macꞌan ndaatioo nnonꞌ, yajoꞌ ꞌuꞌ ntcanꞌ nnön na ninncya ndaa na ntyja ꞌnaanꞌhanꞌ ngüandoꞌ ñuan ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Joꞌ tꞌa tsanscuꞌñeen, itso juu nnon jon: —Nndaꞌ ta, taꞌnan ꞌnan cyonꞌ na ncüjiꞌhanꞌ ndoꞌ juu tsuivaꞌ njoon jndyihanꞌ. Yajoꞌ ¿Yuu va ngyonꞌ juu ndaatioo na nnincyaahanꞌ na ngüandoꞌ ñuan njan? ");
INSERT INTO azgNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nquii tsotachí Jacob, jntyꞌii jon tsuiꞌva ndë́. Nquii jon toꞌu ndaatioo juuhanꞌ, majoꞌntyi ntsinda jon yo ninꞌquiooꞌ ntsjuenꞌ jon. ꞌUꞌ jeꞌ, ¿Aa njonntyichen condui ꞌuꞌ, chichen nquii jon? ");
INSERT INTO azgNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tꞌa Jesús, itso jon: —Tsoñꞌen nnꞌan na cove ndaatioomin, ngioo na ninꞌcüe nndaꞌhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Majoꞌ minꞌcya ro tsꞌan na nninncyaahin ntꞌö, ngioo na tein quiiꞌ tsꞌon juu. Ntsꞌaahanꞌ quiiꞌ tsꞌon juu chaꞌvijon yuu na conduiꞌ tꞌman xtyoꞌ ndaa na tyiꞌjeꞌcanhanꞌ. Naya na matsixuan ja ntsꞌaahanꞌ na tyiꞌjon quintycüii na ngüandoꞌ ñuaanꞌ tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Tꞌa tsanscuꞌñeen, tso juu: —Ta, quitsaꞌ vi nayaꞌñeen, ncyaꞌ ndaatioova chaꞌ tancüjeeꞌ na ninꞌcꞌuantyëchënhanꞌ min tantsichju na ninnquiiꞌchen ndyocüjiꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ndoꞌ itso Jesús nnon juu: —Cjaꞌ, cüanꞌ saꞌ, ndë ncyohoꞌ ntjoohin. ");
INSERT INTO azgNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tꞌa tsanscuꞌñeen ꞌndyo jon: —Ja taꞌnan sꞌa. Joꞌ tso Jesús ꞌndyo juu: —Mayuuꞌ jñꞌoon na tsuꞌ na taꞌnan saꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ee jndë ꞌon nannon na jndë tomꞌanꞌ yohan, ndoꞌ juu tsꞌan na mꞌaan yo ꞌuꞌ neinhin, chito aa saꞌhin. Jñꞌoon mayuuꞌ na tsuꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Xjen na jndyii tsanscuꞌñeen jñꞌoonvaꞌ, itso juu: —ꞌUꞌ ta, mavaaꞌ tsꞌön na condui ꞌuꞌ tsꞌan na matsininꞌ jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nndui. ");
INSERT INTO azgNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nque ndochí já nnꞌan samaritanos tonanꞌtꞌmaanꞌhan Tyoꞌtsꞌon juu tyoꞌva. Majoꞌ ꞌoꞌ nnꞌan judíos conduehoꞌ na juu tsjoon Jerusalén, joꞌ chuꞌhanꞌ na quitsitꞌmaanꞌ tsꞌan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ndoꞌ tꞌa Jesús ꞌndyo tsanscuꞌñeen, tso jon: —ꞌUꞌ tsanscu, cantyja tsonꞌ jñꞌoon matsjö nnonꞌ na mangüentyja xjen na nnanꞌtꞌmaanꞌ nnꞌan tyëhöꞌ minꞌcya ro yuu jon, chito veꞌ xiaꞌntyi tyoꞌva ndoꞌ min aa Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ꞌOꞌ nnꞌan Samaria tyiꞌcovaaꞌ nꞌonhoꞌ nchu vaa na conanꞌtꞌmaanꞌhoꞌ. Majoꞌ já nnꞌan judíos conanꞌtꞌmánꞌ Tyoꞌtsꞌon yo na covaaꞌ nꞌö́n. Ee ntyja nján já nnꞌan judíos, joꞌ itsinꞌman jon ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Majoꞌ ngüentyja xjen, ndoꞌ nein jndë coventyjahanꞌ, na joo nnꞌan na conanꞌtꞌmaanꞌhan nquii tyëhöꞌ, quintꞌahinhanꞌ na cꞌonhan nacje ꞌnaanꞌ Espíritu ndoꞌ yo na xoncüeeꞌ nꞌonhan. Ee ntꞌue jon nnꞌan na nanꞌxuan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nquii Tyoꞌtsꞌon conduihin Espíritu. Mangꞌe joꞌ nque nnꞌan na ninꞌquinanꞌtꞌmaanꞌhan jon, icanhanꞌ na cꞌonhan nacje ꞌnaanꞌ Espíritu Santo, ndoꞌ mantyi quinanꞌtꞌmaanꞌhan jon yo na manchaꞌchen nꞌonhan. ");
INSERT INTO azgNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Ndoꞌ juu tsanscuꞌñeen, tꞌa juu, tso juu: —Ja mavaaꞌ ya tsꞌön na mancüjeeꞌ juu Mesías, nquii jon na conduihin Cristo. Ndoꞌ vi na jndë tyjeeꞌ jon, tsoñꞌen jñꞌoonminꞌ ntsinchuꞌ jonhanꞌ ndëë. ");
INSERT INTO azgNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Sintcüeꞌ Jesús jñꞌoon nnon juu: —Maja na matsinën yo ꞌuꞌ ndö, condui ja nquii tsanꞌñeen na matsuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Majuu xjenꞌñeen, já nnꞌan na tqueenꞌ jon na quinanꞌjö́n yo jñꞌoon na toninncyaa jon, squë́ ntcüꞌë na mꞌaan jon. Vacue tꞌoonꞌ nꞌö́n na tsinin jon yo cüii tsanscu. Majoꞌ min na nndaꞌ, tataꞌxꞌë́ nnon juu nin ꞌnan ntꞌue tsꞌon juu. Min taꞌnan jnduë́ nnon ta Jesús ndu na tsinin jon yo tsanscuvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Juu xjenꞌñeen jntyꞌii tsanscuꞌñeen tsjööꞌ juu, tja ntcüeꞌ juu tsjoonꞌ juu. Tëquitso juu ndëë nnꞌan na mꞌan joꞌ: ");
INSERT INTO azgNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Ncyohoꞌ na ntsaquijntyꞌiahoꞌ ncüii tsansꞌa na jndë tso jon nnön tsoñꞌen nnon ꞌnan na tyiꞌya na matsꞌa. ¿Aa xeꞌquitsꞌaahanꞌ na conduihin Cristo? ");
INSERT INTO azgNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ndoꞌ joo nanꞌñeen jnduiꞌhan, tyꞌehan naijon na mꞌán yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ndoꞌ vitjachen na ntsquehan, já nnꞌan na tqueenꞌ jon na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, jnduë́ nnon jon: —ꞌUꞌ ta na matsiꞌmanꞌ ndë́, cüa, cüaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Majoꞌ tꞌa jon jndyuë, tso jon: —Ja yꞌön ꞌnan na ntcüꞌa na tyiꞌcovaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Yajoꞌ já na tondyë́ jñꞌoon na tso jon, taꞌxꞌë́ nquë́ ndëë ntyjë́, jnduë́: —¿Aa ntsꞌaahanꞌ na jndyoyꞌoon tsꞌan ꞌnan na tcüaꞌ jon? ");
INSERT INTO azgNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Majoꞌ tꞌa Jesús jndyuë́, itso jon: —Xjen na matsꞌa ꞌnan na ntꞌue tsꞌon nquii jon na jñon ja quiiꞌ ntꞌan nnꞌan ndoꞌ na mavancꞌuë tsꞌian na iꞌua jon nnön, juu tsꞌianꞌñeen incyaahanꞌ najndö chaꞌxjen na incyaahanꞌ najndei tsꞌan na icüaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Vaa jñꞌoon itsiꞌmanhanꞌ ntyja ꞌnaanꞌ juu jñꞌoon na conanꞌneinhoꞌ. Ee conduehoꞌ na nenque chiꞌ vitja ndoꞌ ntyje nnꞌan ꞌnan na coveꞌ. Majoꞌ ja matsjö ndëëhoꞌ, quinanꞌvehoꞌ nquenhoꞌ, ndoꞌ quijntyꞌia ndëëhoꞌ xeꞌjndio na mꞌan nnꞌan na conduihan chaꞌvijon ntjon na jndë tman na ngüantjon tsꞌan joohan cüentaaꞌ Tyoꞌtsꞌon. Itsijonhanꞌhin chaꞌvijon ntjon na jndë tueeꞌ xjen na ntyjee tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ee chaꞌxjen tsꞌan na ityjee ntjon na tueꞌ, vantjon juu na itsꞌaa juu tsꞌian, mantyi juu tsꞌan na itsiꞌman juu ndëë nnꞌan na ntycyaahan ntꞌö Tyoꞌtsꞌon, cotantjon nanꞌñeen na nanꞌxuanhan na tyiꞌquintycüii na cotandoꞌ ñuaanhan. Ndoꞌ na nndaꞌ, juu tsꞌan na itsiꞌman juu jñꞌoonꞌ jon ndëë nnꞌan, itsicüajonhanꞌ na neiinꞌ tsanꞌñeen chaꞌxjen na neiinꞌ juu tsꞌan na vantjon nanꞌñeen na conduihan cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ndoꞌ na nndaꞌ, itsiꞌmanhanꞌ na mayuuꞌ juu jñꞌoon na condue nnꞌan na ncüii tsꞌan inonꞌ juu, majoꞌ mañoon tsꞌan ityjeehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na majñön ja ꞌoꞌ quiiꞌ tsꞌian njan, itsijonhanꞌ ntyja ꞌnaanhoꞌ chaꞌvijon na cotsaquityjehoꞌ yuu vijon na tajntꞌahoꞌ jndyaaꞌ. Mañoon nnꞌan jntꞌa jndyaaꞌ na ncꞌoon tsꞌian ꞌnaanꞌ Tyoꞌtsꞌon quiiꞌ nꞌon nnꞌan, ndoꞌ ꞌoꞌ jndë tyequeꞌhoꞌ quiiꞌ juu tsꞌianꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndoꞌ nque nnꞌan samaritanos na mꞌanhan juu tsjoonꞌñeen, jndyehan tëntyja nꞌonhan Jesús ngꞌe jñꞌoon ꞌndyo juu tsanscuꞌñeen na sinin jndyoyu juu ndëëhan na itso juu: “Jndë siꞌman jon nnön tsoñꞌen ꞌnan na tyiꞌya na jndë totsꞌa.” ");
INSERT INTO azgNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nnꞌan Samariaꞌñeen xjen na squehan naijon mꞌaan Jesús, tanhan nnon jon na quintjohin yohan, ndoꞌ ntjohin yo nanꞌñeen chaꞌ ve xuee. ");
INSERT INTO azgNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ndoꞌ xjen na tondye nanꞌñeen jñꞌoon na toninncyaa jon, jndyentyichenhan tëntyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ndoꞌ tonduehan nnon tsanscuꞌñeen: —Nanein chito veꞌ ntyja ꞌnaanꞌ juu jñꞌoon na tsuꞌ ndë́, joꞌ na vantyja nꞌö́n. Ee nquë́ntyë́ jndë jndyë́ jñꞌoon ꞌndyo jon. Ndoꞌ neinhin, covaaꞌ nꞌö́n na mayuuꞌ conduihin Cristo na itsinꞌman jon ñuaan nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jndë na tenon joo ve xueeꞌñeen, jnduiꞌ Jesús joꞌ, sá ntcüꞌë́ yohin ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ee nquiintyi jon tjiꞌ jndyoyu jon jñꞌoon na tyiꞌnanꞌtꞌmaanꞌ nnꞌan ncüii tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon na ninncüii tsjan tuihin yohan. ");
INSERT INTO azgNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ndoꞌ juu xjen na squë́ ntcüꞌë́ Galilea yohin, nnꞌan na mꞌan joꞌ nein jndyihan jon, jnanꞌntjooꞌhan jon. Ee juu xjen na tueeꞌ nguee pascua Jerusalén, mantyi tyꞌe nanꞌñeen joꞌ, ee jndë jntyꞌia ndëëhan tsoñꞌen jnꞌaan tꞌman na totsꞌaa jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jndë joꞌ sꞌá nntꞌá yohin Caná ndyuaa Galilea, naijon scüaquen jon ndaa na sꞌaahanꞌ vinonhanꞌ. Ndoꞌ juu tsjoon Capernaum tomꞌaan ncüii tsꞌan na tꞌman tonduihin ntyja ꞌnaanꞌ gobernado. Juu lu, jnda tsanꞌñeen, mꞌaan juu na viiꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ndoꞌ xjen na jndyii tsanꞌñeen na jndë squë́ ntcüꞌë́ ndyuaa Galilea yo Jesús na jnán ndyuaa Judea, yajoꞌ tja tsanꞌñeen na mꞌán. Tcan juu vi nayaꞌñeen nnon Jesús na cja jon vaaꞌ juu na quitsinꞌman jon lu chjoꞌñeen ee ninꞌcueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ndoꞌ itso Jesús nnon tsanꞌñeen: —ꞌOꞌ mancüiixjen tyiꞌxeꞌcantyja nꞌonhoꞌ na vaa najndö na condui ja xe na aa tyiꞌjntyꞌia ndëëhoꞌ ncüii nnon ꞌnan na matsꞌa na ndiquindëë na nduihanꞌ na veꞌ ntyja ꞌnaanꞌ naijndei nquii tsꞌan, ꞌnan na ndicüaaꞌ tsꞌon tsꞌan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Tꞌa tsanꞌñeen ꞌndyo Jesús, itso jon: —Nndaꞌ ta, maninñoonꞌ cjaꞌ vꞌa vitjachen na ngueꞌ jnda. ");
INSERT INTO azgNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tso Jesús nnon jon: —Cjaꞌ, ee ntcoꞌ ya ntcüeꞌhanꞌhin. Ndoꞌ juu tsansꞌaꞌñeen, tëntyja tsꞌon jon jñꞌoon na tso Jesús. Tëntcüeꞌ jon vaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndoꞌ viochen xjen na vja ntcüeꞌ jon tsjoonꞌ jon Capernaum, nque mosooꞌ jon saquitjonhin jon. Jnanꞌquindyiihanhin, jnduehan nnon jon: —Jndë vacoꞌ yahanꞌ lu jndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ndoꞌ taxeeꞌ jon ndëë nanꞌñeen yuu xjen tyeꞌ na tëcoꞌ yahanꞌhin. Tꞌa nanꞌñeen, jnduehan: —Vja vi na tenon chjo yajminꞌ jndya tjuenꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ndoꞌ juu tye luꞌñeen taaꞌ tsꞌon jon na maninjuu xjenꞌñeen na tso Jesús nnon jon na ntcoꞌ yantcüeꞌhanꞌ lu jnda jon. Ndoꞌ na nndaꞌ, tëntyja tsꞌon jon Jesús, juu jon ndoꞌ mantyi tsoñꞌen nnꞌan vaaꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Joꞌ tsꞌian na jndë ve na sꞌaa Jesús na tueeꞌ jon Galilea na jnan jon Judea, na tyiꞌxeꞌquinduihanꞌ na veꞌ ntyja ꞌnaanꞌ najndei nquii tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jndë na tui nanꞌvaꞌ, santcüꞌë́ Jerusalén yo Jesús ee juu tsjoonꞌñeen tueeꞌ nguee ntyja njan jaa nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ꞌNdyo tsjoon Jerusalén tovaa ncüii ꞌndyovꞌaa tꞌman na jnanꞌquijndyuhan juuhanꞌ ꞌNdyovꞌaa Quinman. Ndyo joꞌ tovaa ncüii pila tꞌman. Juu pilaꞌñeen, yo jñꞌoon hebreo, conanꞌquijndyu nnꞌanhanꞌ Betzata. Xiꞌjndio ngiaaꞌhanꞌ, joꞌ min ꞌon ntꞌaa na xiaꞌntyi nꞌoon ntꞌeiiꞌhanꞌ min. ");
INSERT INTO azgNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Quiiꞌ joo ntꞌaaꞌñeen manꞌ ncüii tmaanꞌ nnꞌan vꞌi, nnꞌan nchjan yo nnꞌan na jndë tatei nduee, yo ngꞌe, yo ninꞌnnꞌan na ndiquitsacaꞌ. Tominndooꞌhan na ntsijndei ndaa na ñjon pilaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ee tcya tcya xjen tondyocue ncüii ángel na totsitsꞌii jon juu ndaaꞌñeen. Ndoꞌ vi na jndë tui na nndaꞌ, juu tsꞌan na ngua jndyee quiiꞌ ndaaꞌñeen, nꞌman juu minꞌcya ro nnon tycu na iquenon juu. ");
INSERT INTO azgNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Juu vꞌaaꞌñeen tomꞌaan ncüii tsansꞌa na jndë ntcyu nchoꞌnqui vantjoꞌ nen chu na viiꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Joꞌ jndyiaaꞌ Jesús juu na vaa juu joꞌ. Ndoꞌ ngꞌe na ntyjii jon na jndë tijndye xuee na nndaꞌ vaa iquenon juu, joꞌ itso jon nnon juu: —¿Aa ninꞌquinꞌmanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ndoꞌ tꞌa tsanviiꞌñeen, itso juu: —Nndaꞌ ta, taꞌnan tsꞌan nchje ja quiiꞌ ndaahaꞌ xjen na tsijndeihanꞌ, joꞌ viochen xjen na matsichön na ngua, ncüiichen tsꞌan matyuaaꞌntyi venoonꞌ juu ja. ");
INSERT INTO azgNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ndoꞌ itso Jesús nnon juu: —Quinaquintyjaꞌ, quitsintcüiꞌ tsueꞌ, ndë cjaꞌ vaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Xjenꞌñeen ninꞌñoonꞌ tcoꞌyahanꞌ tsanꞌñeen, jnꞌman juu, jndë joꞌ sintcüi juu tsue ꞌnaanꞌ juu, taꞌ juu na tëca juu. Ndoꞌ juu xuee na sꞌaa Jesús na nndaꞌ, xuee na já nnꞌan judíos cotajndyë́. ");
INSERT INTO azgNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ngꞌe na nndaꞌ, vendye ntyjë nnꞌan judíos jnduehan nnon juu tsanꞌñeen: —Nanein xuee na cotajndyëë. Juu ntji na coꞌxenhanꞌ itsiquindyihanꞌ na tyiꞌcüanaan na ngayonꞌ tsue ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Majoꞌ tꞌa juu, itso juu: —Nquii tsan na sinꞌman ja itso jon nnön na quitsintcüihanꞌ ndoꞌ na quindyoyꞌönhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ndoꞌ taxeeꞌ nanꞌñeen nnon juu, jnduehan: —¿Nin nquii tsꞌan tsanꞌñeen na nndaꞌ vaa tso juu nnonꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Majoꞌ juu tsanꞌñeen na jndë jnꞌman, tyiꞌquintjii juu nin tsꞌan sinꞌmanhin, ngꞌe jndye nnꞌan na tomꞌan joꞌ. Ndoꞌ jndë jnduiꞌ ndyaꞌ Jesús joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ndoꞌ vi na jndë tui na nndaꞌ, ntjii nndaꞌ Jesús juu quiiꞌ vatsꞌon tꞌman. Itso jon nnon juu: —Ndyeeꞌ ra, quenꞌ cüenta, jndë jnꞌmanꞌ, cacüentyjeꞌ na matsitja ꞌuꞌ nnon Tyoꞌtsꞌon chaꞌ tyiꞌntjonꞌ ncüii nnon na majantyichen. ");
INSERT INTO azgNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndoꞌ taquitso tsanꞌñeen ndëë nnꞌan judíos na nquii Jesús sinꞌman jonhin. ");
INSERT INTO azgNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ngꞌe na nndaꞌ sꞌaa Jesús, joꞌ tentyja nnꞌan judíosꞌñeenhin. Tojooꞌ yantyi nꞌonhan na nnanꞌcueeꞌhanhin ee juu tsꞌianꞌñeen sꞌaa jonhanꞌ juu xuee na cotaꞌjndyeehan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Majoꞌ tso Jesús ndëëhan: —Nquii Tyëhöꞌ ninvaa itsꞌaa jon ncüii cüii nnon na itejndeihanꞌ tsꞌan, ndoꞌ mantyi ja, majoꞌ matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ndoꞌ tsojnaanꞌ juu jñꞌoonvaꞌ, nque nnꞌan judíosꞌñeen tojooꞌ yantyi nꞌonhan na ninꞌquinanꞌcueeꞌhan jon. Ee na cotjiꞌhan cüenta, sitjahin ntyja ꞌnaanꞌ juu xuee na cotaꞌjndyeehan ndoꞌ tꞌmanntyichen sitjahin na tso jon na nquii Tyoꞌtsꞌon conduihin Tye jon, ndoꞌ na nndaꞌ, itsꞌaahanꞌ na cüajon conduihin yo nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ndoꞌ itso Jesús ndëë nanꞌñeen: —Jñꞌoon na mayuuꞌ matsinën ndëëhoꞌ. Ja na condui jnda Tyoꞌtsꞌon, tyiꞌnanꞌtiuhoꞌ na matsꞌa ꞌnan na ntꞌue tsꞌön ncö. Ee xiaꞌntyi ꞌnan na mantyꞌia na itsꞌaa Tyëhöꞌ, majoo rohanꞌ matsꞌa. Ee ja na condui jnda jon, tsoñꞌen matsꞌa chaꞌxjen na mantyꞌia na itsꞌaa nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Tyëhöꞌ na condui ja jnda jon, mꞌaan jon na venchjii jon ja. Itsiꞌman jon nnön tsoñꞌen na itsꞌaa jon. Ndoꞌ tsꞌian na njonntyichen ntsiꞌman jonhanꞌ nnön na quitsꞌa chaꞌ ninncyaahanꞌ tꞌmanntyichen ncꞌoonꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nquii Tyëhöꞌ itsintcüi nndaꞌ jon nnꞌan na jndë tjë ndoꞌ incyaa jon na cotandoꞌ xcohan. Ndoꞌ chaꞌxjen na itsꞌaa jon, mantyi ncö na condui ja jnda jon, minꞌcya ro tsꞌan na ntꞌue tsꞌön, ninncya na ntsixuan tsanꞌñeen na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nquii Tyëhöꞌ minꞌncüii tsꞌan tyiꞌcoꞌxen jon jnaanꞌ juu. Majoꞌ ncö na condui ja jnda jon, jndë tyincyaa jon na vaa najndö na ntcoꞌxën tsoñꞌen nnꞌan tsojnaanꞌ na conanꞌtjahan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Jndë itsꞌaa jon na nndaꞌ chaꞌ ja na condui jnda jon, tsoñꞌen nnꞌan nnanꞌtꞌmaanꞌhan ja chaꞌxjen na conanꞌtꞌmaanꞌhan nquii jon. Ee minꞌninchen tsꞌan na tyiꞌninꞌquitsitꞌmaanꞌ juu ja na condui ja jnda jon na jñon jon ja quiiꞌ ntꞌanhoꞌ, min nquii jon tyiꞌninꞌquitsitꞌmaanꞌ juuhin. ");
INSERT INTO azgNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minninchen tsꞌan na indyii jñꞌoon ꞌndyö ndoꞌ vantyja tsꞌon juu yo nquii jon na jñon jon ja quiiꞌ ntꞌanhoꞌ, juu tsanꞌñeen tsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu, min tyiꞌxeꞌquitꞌuii Tyoꞌtsꞌonhin ntyja ꞌnaanꞌ jnaanꞌ juu. Totsixuan juu chaꞌvijon tsꞌoo, majoꞌ nein tsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Jñꞌoon na mayuuꞌ matsiquindyi ꞌoꞌ, ngüentyja xjen ndoꞌ naneinhin iventyjahanꞌ, na joo nnꞌan na jndë tjë, nndyehan jndyëë na condui ja jnda Tyoꞌtsꞌon. Ndoꞌ tsoñꞌen nnꞌan na vantyja nꞌonhan ja, ninncya na ntandoꞌ ñuaanhan ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ee chaꞌxjen nquii Tyëhöꞌ tsixuan jon na vandoꞌ jon ntyja ꞌnaanꞌ nquii jon, ja na condui ja jnda jon, manndaꞌ ro jndë tyincyaa jon na matsixuan na mavantꞌö ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ndoꞌ mantyi ntyja ꞌnaanꞌ juu najndei na itsixuan nquii jon, jndë tyincyaa jon na ja ntcoꞌxën nnꞌan ntyja ꞌnaanꞌ jnanhan ngꞌe na condui ja tsansꞌa na jñon jon ja quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tantꞌahoꞌ na jen caveeꞌ ngiohoꞌ na nndaꞌ tsjö, ee ngüentyja xjen na tsoñꞌen ntꞌoo na tooꞌ ndiꞌntꞌua nndyehan jndyëë. ");
INSERT INTO azgNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Nque nnꞌan na jndyoyu conduihan na tonnon Tyoꞌtsꞌon, ntcüi nndaꞌhan yo siꞌtsꞌo ꞌnaanhan na tyiꞌquintycüii na cotandoꞌ ñuaanhan. Majoꞌ ntyjehan na tontꞌa ꞌnan na tyiꞌquichuhanꞌ, ntcüi nndaꞌhan yo na ntꞌuiityenhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Tyiꞌnanꞌtiuhoꞌ na matsꞌa chaꞌxjen na ntꞌue tsꞌön ncö. Ntyjantyi na incyaa Tyoꞌtsꞌon na mavaaꞌ tsꞌön, ntyjantyi joꞌ na macoꞌxën chaꞌxjen na itsohanꞌ. Ee chito mantꞌuë na ndui ꞌnan na ntꞌue tsꞌön ncö. Mantꞌuë na ntsꞌa chaꞌxjen na ntꞌue tsꞌon nquii Tyëhöꞌ na tꞌua jon tsꞌian nnön na jndyö na mꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Xe na aa macüjiꞌ jndyoyu ntyja njan ncö, ninncyaahanꞌ na vanaan na nduehoꞌ na joo jñꞌoonminꞌ tyiꞌquinanꞌxuanhanꞌ jñꞌoon na mayuuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Majoꞌ mꞌaan ncüiichen na icüjiꞌ jndyoyu jon ntyja njan, manquii Juan. Ndoꞌ ntyji ja na juu jñꞌoon na tocüjiꞌ jndyoyu jon, conduihanꞌ jñꞌoon na mayuuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Manquehoꞌ jñonhoꞌ nnꞌan na mꞌaan jon, ndoꞌ tjiꞌ jndyoyu tsanꞌñeen jñꞌoon na mayuuꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Juu jñꞌoon na icüjiꞌ jndyoyuhanꞌ ntyja njan na mayꞌön cüentahanꞌ, chito conduihanꞌ jñꞌoon na cotjiꞌjndyoyu nnꞌanhanꞌ. Majoꞌ matsjö jñꞌoonminꞌ ndëëhoꞌ cha ndëë ntsinꞌman Tyoꞌtsꞌon ñuaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Nquii Juanꞌñeen tonduihin chaꞌvijon lámpara na itsixueehanꞌ chon tondëë nnꞌan. Ndoꞌ ꞌoꞌ viochen xjen na tomꞌaan jon, tꞌonhoꞌ na neinhoꞌ ngꞌe ngiohoꞌ jñꞌoon na toninncyaa jon totsijndaꞌhanꞌ nquenhoꞌ nchu vaa na ntꞌue tsꞌon Tyoꞌtsꞌon yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Majoꞌ vaa jñꞌoon na icüjiꞌ jndyoyuntyichenhanꞌ ntyja njan na tꞌmanntyichen conduihanꞌ, chito juu jñꞌoon na tjiꞌjndyoyu Juanꞌñeen. Joo tsꞌian na tyincyaa Tyëhöꞌ na quitsiquindëëhanꞌ, joohanꞌ cotjiꞌ jndyoyuhanꞌ na nquii jon tꞌua jon tsꞌian nnön na jndyö quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nquii Tyëhöꞌ na iꞌua jon tsꞌian nnön, juu jon icüjiꞌ jndyoyu jon ntyja njan quiiꞌ jñꞌoon ꞌnaanꞌ jon. ꞌOꞌ minjon tyiꞌcondyehoꞌ jndyeeꞌ jon, min na jntyꞌia ndëëhoꞌ nchu vaahin. ");
INSERT INTO azgNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Min tyiꞌcyꞌonhoꞌ cüenta jñꞌoon ꞌnaanꞌ jon quiiꞌ ñuan ꞌnaanhoꞌ ngꞌe tyiꞌcovantyja nꞌonhoꞌ ja na iꞌua jon tsꞌian na jndyö quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui ndyu na toxenꞌchen, chen jndyi conanꞌjnꞌaanhoꞌhanꞌ, ndoꞌ conanꞌtiuhoꞌ ngꞌe na nndaꞌ contꞌahoꞌ, joꞌ nndahoꞌ na tyiꞌquintycüii na cotandoꞌ ꞌoꞌ na tonnon jon. Joo jñꞌoonꞌñeen conanꞌnein jndyoyuhanꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Majoꞌ min na nndaꞌ, tyiꞌninꞌquitsayꞌonhoꞌ jñꞌoon yo ja chaꞌ nndëë nnanꞌxuanhoꞌ na tyiꞌquintycüii na cotandoꞌ ñuaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ja tyiꞌcotsichön na quinanꞌtꞌmaanꞌ nnꞌan ja. ");
INSERT INTO azgNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Nchji na tyiꞌqui nꞌonhoꞌ ja ee tyiꞌvengiohoꞌ nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mꞌan quiiꞌ ntꞌanhoꞌ yo juu naijndei na itsixuan nquii Tyëhöꞌ, majoꞌ ꞌoꞌ tyiꞌninꞌcyꞌonhoꞌ cüenta ja. Majoꞌ xe na aa ncüjeeꞌ ncüiichen tsꞌan ntyja ꞌnaanꞌ nquii juu, juu tsanꞌñeen ncyꞌonhoꞌ cüentahin. ");
INSERT INTO azgNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ꞌOꞌ cotquenhoꞌ na nque ntyjehoꞌ na quinanꞌtꞌmaanꞌhin ꞌoꞌ, majoꞌ tyiꞌquitquenhoꞌ na ntꞌahoꞌ ꞌnan na ntꞌue tsꞌon nquii Tyoꞌtsꞌon chaꞌ nndëë ntsitꞌmaanꞌ jonhoꞌ. Ndoꞌ na contꞌahoꞌ na nndaꞌ, ¿Yuu xjen ninncyaahanꞌ na ngantyja nꞌonhoꞌ nquii jon? ");
INSERT INTO azgNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Majoꞌ tyiꞌnanꞌtiuhoꞌ na mancöntyë na ninncya jnanhoꞌ nnon Tyëhöꞌ. Mꞌaan ncüiichen na ncyaa jon jnanhoꞌ, manquiintyi Moisés, nquii tsanꞌñeen na tꞌman conanꞌqui nꞌonhoꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Majoꞌ ngꞌe na tyiꞌninꞌcantyja nꞌonhoꞌ jñꞌoon na tji jon na itsininhanꞌ ntyja njan, mangꞌe joꞌ tyiꞌcantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ndoꞌ ngꞌe na tyiꞌninꞌcantyja nꞌonhoꞌ jñꞌoon na tji jon, yajoꞌ ¿Nchu ya ntꞌahoꞌ na ngantyja nꞌonhoꞌ jñꞌoon na mancya?” ");
INSERT INTO azgNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jndë tenon nanꞌminꞌ, tetꞌiö́ nntꞌá ndaandue Galilea yo Jesús. Xueeꞌhanꞌ na vjave jndyuhanꞌ ndaandue Tiberias. ");
INSERT INTO azgNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndoꞌ ncüii tmaanꞌ nnꞌan na jndye jndyiꞌhin tentyjahan toxenꞌ jon ngꞌe tovaveeꞌ ngiohan na tojntyꞌiahan na sinꞌman jon nnꞌan vꞌi. ");
INSERT INTO azgNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yajoꞌ já nnꞌan na tꞌman jon na quitsayꞌö́n jñꞌoon yohin, savá ncüii tyoꞌ yo jon. Joꞌ sacüendyuá. ");
INSERT INTO azgNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Juu xjenꞌñeen mandyo ngueeꞌ nguee pascua xjen na jaa nnꞌan judíos conanꞌcüjëëhë quinman na conanꞌtꞌmaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ndoꞌ tꞌion Jesús nnon jon, jndyiaaꞌ jon concyo ncüii tmaanꞌ nnꞌan na jndye jndyi. Ndoꞌ tso jon nnon Felipe: —¿Yuu vijon nninjndaꞌ ꞌnan na ntcüaꞌ tsoñꞌen nanminꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Majoꞌ nndaꞌ vaa na tso jon ngꞌe ninꞌquindyii jon nin jñꞌoon ntsintcüeꞌ Felipe, ee ntyjii jndaꞌ jon nchu vaa ntsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tꞌa Felipeꞌñeen, itso jon: —Min xe na aa nanꞌquitsu jaa ve ciento sꞌon denarios na nnanꞌjnda ꞌnan na ntcüaꞌ nanminꞌ, majoꞌ tyiꞌjeꞌcüinonhanꞌ min na veꞌ chjohanꞌ na ngacüjaꞌhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Joꞌ mꞌaan Andrés, jon tyje nquii Simón Pedro, conduihin ncüii ntyjë́ nquë́ já nnꞌan na totsayꞌö́n yo jñꞌoon na toninncyaa Jesús. Tso tsanꞌñeen nnon jon: ");
INSERT INTO azgNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ntjoo mꞌaan ncüii lu na yꞌoon ꞌon tyooꞌ na jndëhanꞌ yo jndë tyooꞌ ntquen cebada. Ndoꞌ mantyi yꞌoon juu ve quitscaa chjo na jndë jnein, majoꞌ ¿Yuxjenꞌñeen nninnonhanꞌ na jndye jndyi nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ndoꞌ tꞌa Jesús jndyuë́, tso jon: —Quinduehoꞌ ndëë nnꞌan na quitsacüendyuaahan. Ndoꞌ naijon na tꞌö́n, joꞌ jndye jndë quijndë min. Yajoꞌ tyecüendyuaahan. Ndoꞌ joo nanꞌñeen tueeꞌ chaꞌna ꞌon min nannon. ");
INSERT INTO azgNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yajoꞌ tyꞌoon Jesús cüenta joo tyooꞌñeen. Tyincyaa jon na ya Tyoꞌtsꞌon ntyja ꞌnaanhanꞌ. Ndë joꞌ tocꞌon jonhanꞌ ndë́ já nnꞌan na tqueenꞌ jon na quitsayꞌö́n jñꞌoon yohin. Ndoꞌ já totꞌö́nhanꞌ ndëë nanꞌñeen. Majoꞌntyi sꞌaa jon yo quintca quijndëꞌñeen, chuntyi xjen na ninꞌquitquiihan na ncüii cüiihan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ndoꞌ vi na jndë tacjohan, yajoꞌ itso jon ndë́: —Quinanꞌtjonhoꞌ ntanꞌ quijndë na jntyꞌiihanꞌ, cüan na tyiꞌntsꞌaahanꞌ na veꞌ jnꞌaan ntjoohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ndoꞌ jnanꞌtjö́n joo ntanꞌ quijndë na jntyꞌiihanꞌ na tcüaꞌ nanꞌñeen na jndëhanꞌ yo jndë tyooꞌ cebada. ");
INSERT INTO azgNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ndoꞌ joo nanꞌñeen, vi na jndë jntyꞌiahan jnꞌaan tꞌmanꞌñeen na sꞌaa Jesús na tyiꞌjeꞌquindëë nduihanꞌ na veꞌ naijndei nquii tsꞌan, jnduehan ndëë ntyjehan: —Jñꞌoon na mayuuꞌ juu tsanvaꞌ conduihin nquii tsꞌan na itsiquindyi ntji na ncüjeeꞌ jon tsonnangue na ninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Majoꞌ taaꞌ tsꞌon Jesús na mavaa xjen na ndyocyꞌon nanꞌñeenhin ndoꞌ yo naijndeiꞌhanꞌ na ntꞌionhan tsꞌian jon na nduihin rey na coꞌxen jon joohan. Ngꞌe na nndaꞌ, tja nndaꞌ jon jndëë naijon na ninnquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ndoꞌ vi na jndë tuatëꞌ ndoꞌcüjioonꞌ, já nnꞌan na tqueenꞌ Jesús na quitsayꞌö́n jñꞌoon yohin, sacuë́ ꞌndyo ndaandue. ");
INSERT INTO azgNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Joꞌ tuá ncüii vꞌaandaa, na ngüetꞌiö́ ndaandueꞌñeen na ntsquë́ Capernaum. Majoꞌ ya tueeꞌ na tijaan, ninjoꞌ tacocüjeeꞌ jon ndë́. ");
INSERT INTO azgNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ndoꞌ ngꞌe na tꞌman jndye tyioo, totsuehanꞌ juu ndaandueꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ngꞌe joꞌ na ninꞌon ninꞌyon kilómetros xejnda tëca juu vꞌaandaaꞌñeen na contyjá nꞌoon pala ꞌnaanꞌhanꞌ. Ndoꞌ juu xjenꞌñeen jntyꞌiá na ndyoca Jesús nnon ndaandue na ndyovindyooꞌ jon na mꞌán. Tyuë́ jndyí. ");
INSERT INTO azgNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Majoꞌ itso jon ndë́: —Maja ndö, tyiꞌndyuehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Joꞌ tyioo na në́n jndyí na tyꞌö́n nntꞌa cüentahin quityquiiꞌ vꞌaandaa. Ndoꞌ quintyjachen tueeꞌhanꞌ naijon na cotsá. ");
INSERT INTO azgNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Tonco ncüiichen xuee, nque nanꞌñeen na jndye jndyiꞌhin na ntjohan ixndya ndaandue naijon na tyincyaa Jesús na tcüaꞌhan, tquenhan cüenta na ninncüii vꞌaandaa chjo nintuaa. Ndoꞌ tëñjoonꞌ nꞌonhan na tyíꞌcua jon juu vꞌaandaaꞌñeen yo já nnꞌan na totsayꞌö́n jñꞌoon yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Ndoꞌ viochen xjen na nndaꞌ vaa, squenon vendye ntꞌaandaa quijndë na jnan Tiberias naijon na tcüaꞌ nanꞌñeen tyooꞌ na tyincyaa Jesús na ncya ya Tye jon. ");
INSERT INTO azgNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ndoꞌ tua nanꞌñeen joo ntꞌaandaa quijndëꞌñeen. Tyꞌehan, squehan Capernaum na tyequijntꞌuehan Jesús. Ee taaꞌ nꞌonhan na tacꞌoonhin yuu vijon na tyincyaa jon na tcüaꞌhan, min nquë́ nnꞌan na tqueenꞌ jon na quitsayꞌö́n jñꞌoon yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ndoꞌ vi na jndë jndiohan Jesús ncüiichen ixndya ndaandue, jnduehan nnon jon: —ꞌUꞌ ta na matsiꞌmanꞌ ndëë nnꞌan ntyja ꞌnaanꞌ Tyoꞌtsꞌon, ¿Yuu xjen jndyoꞌ ntjoohin? ");
INSERT INTO azgNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tꞌa jon jndyuehan, itso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, ꞌoꞌ chito cojntꞌuehoꞌ ja ngꞌe na jntyꞌiahoꞌ tsꞌian na sꞌa na tyiꞌjeꞌquindëë nduihanꞌ na veꞌ yo naijndei nquii tsꞌan. ꞌOꞌ cojntꞌuehoꞌ ja xengꞌe na tcüaꞌ tacjohoꞌ tyooꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ꞌOꞌ conanꞌchonhoꞌ na ninjndaꞌ ꞌnan na ntcüaꞌhoꞌ, ndoꞌ joohanꞌ ꞌnan na contycüiihanꞌ. Majoꞌ tyiꞌquichuhanꞌ na nndaꞌ contꞌahoꞌ. Quinanꞌchonhoꞌ na nndiohoꞌ ncüii na chaꞌvijon na ntcüaꞌ tsꞌan na ntyja ꞌnaanꞌhanꞌ nnanꞌxuanhoꞌ na tyiꞌquintycüii na cotandoꞌ ñuaanhoꞌ. Ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na jndyö quiiꞌ ntꞌanhoꞌ, ninncya quiiꞌ ñuan ꞌnaanhoꞌ juu na itsijonhanꞌ juuhanꞌ na ntcüaꞌ tsꞌan ee itsiꞌman tyëhöꞌ Tyoꞌtsꞌon na jndë tꞌua jon tsꞌianꞌñeen nnön. ");
INSERT INTO azgNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yajoꞌ taxeeꞌ nanꞌñeen nnon jon: —¿Nin ꞌnan icanhanꞌ na quintꞌá chaꞌ ngaveeꞌ nchjii Tyoꞌtsꞌon yo já? ");
INSERT INTO azgNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Joꞌ tꞌa Jesús jndyuehan, itso jon: —Ndö vaa na ntꞌue tsꞌon jon, na cantyja nꞌonhoꞌ ja na jñon jon ja quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ndoꞌ tꞌahan, jnduehan: —¿Nin ncüii nnon ꞌnan na ntsaꞌ na njntyꞌiá ndë́ na tyiꞌjeꞌquinduihanꞌ na veꞌ ntyja ꞌnaanꞌ naijndei nquii tsꞌan na ntsiꞌmanhanꞌ ndë́ na vaa na condui ꞌuꞌ, chaꞌ ntejndeihanꞌ na ngantyja nꞌö́n ꞌuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ndochiihi tocüaꞌhan maná xjen na tomꞌanhan ndyuaa naijon na tyiꞌjndye nnꞌan tomꞌan chaꞌxjen itsiquindyi juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui ndyu na toxenꞌchen: “Tyincyaa Moisés tyooꞌ na tocüaꞌhan na jnanhanꞌ quiñoonꞌndue.” ");
INSERT INTO azgNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ndoꞌ tꞌa Jesús jndyuehan, itso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, juu maná na tyincyaa tsanꞌñeen, chito conduihanꞌ tyooꞌ na jnan na mꞌaan Tyoꞌtsꞌon. Majoꞌ nquii Tyëhöꞌ incyaa jon juu na mayuuꞌ na jnan na mꞌaan jon quiñoonꞌndue na itsijonhanꞌhin chaꞌvijon tyooꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Juu na condui tyooꞌ na incyaa Tyoꞌtsꞌon, jnan jon quiñoonꞌndue na jndyocue jon. Nquii jon incyaa jon na nanꞌxuan nnꞌan na tyiꞌquintycüii na cotandoꞌ ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ndoꞌ jndue nanꞌñeen nnon jon: —Nndaꞌ ta, ninnquiiꞌchen ncyaꞌ tyooꞌminꞌ ndë́, riiꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ndoꞌ tꞌa Jesús jndyuehan, itso jon: —Ja condui tyooꞌ na mancya na nanꞌxuan nnꞌan na tyiꞌquintycüii na cotaꞌndoꞌ ñuaanhan. Minꞌcya ro tsꞌan na ninncyaahin ntꞌö, itsijonhanꞌhin chaꞌvijon tsꞌan na jndë tacjooꞌ na icüaꞌ. Ndoꞌ juu tsꞌan na vantyja tsꞌon ja, ngioo na tein quiiꞌ ñuaanꞌ juu chaꞌxjen ya na iꞌu tsꞌan ndaa. ");
INSERT INTO azgNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Majoꞌ chaꞌna jñꞌoon na jndë tsjö ndëëhoꞌ, min na jndë jntyꞌia ndëëhoꞌ joo tsꞌian na matsꞌa, majoꞌ tyiꞌcantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Majoꞌ min na nndaꞌ vaa, tsoñꞌen nnꞌan na incyaa Tyëhöꞌ ntꞌö, nndye nanꞌñeen ntyja njan. Min tyiꞌjeꞌquitsꞌa na jeꞌcyꞌön cüenta tsꞌan na nincyaahin ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ee ja na jnan quiñoonꞌndue, chito na jndyö na ntsꞌa ꞌnan na ntꞌue tsꞌön ncö. Ja jndyö na ntsꞌa chaꞌxjen na ntꞌue tsꞌon nquii jon na jñon jon ja quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nquii Tyëhöꞌ na jñon jon ja quiiꞌ ntꞌanhoꞌ, ndö vaa na ntꞌue tsꞌon jon na quitsꞌa, na juu tsꞌan na jndë tyincyaa jon ntꞌö, tyiꞌninncya na ngitsu ñuaanꞌ tsanꞌñeen. Ndoꞌ xuee na matsꞌiañꞌen, ninncya na ntaꞌndoꞌ xco tsoñꞌen nnꞌan na nanꞌxuanhan na tyiꞌquintycüii na cotaꞌndoꞌ ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee nquii Tyëhöꞌ ntꞌue tsꞌon jon na tsoñꞌen nnꞌan na cojntyꞌia ja na condui ja jnda jon, na cantyja nꞌonhan ja, cyꞌonhan cüenta na tyiꞌquintycüii na cotaꞌndoꞌ ñuaanhan. Ndoꞌ xuee na matsꞌiañꞌen majantyë ninncya na ntaꞌndoꞌ xco joo nnꞌan na jndë tjë. ");
INSERT INTO azgNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Ndoꞌ nque nnꞌan judíosꞌñeen, jnanꞌmanhan na tatëveeꞌ ngiohan yo Jesús jnaanꞌ jñꞌoon na tso jon: “Ja condui tyooꞌ na jnan quiñoonꞌndue.” ");
INSERT INTO azgNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ndoꞌ jnduehan: —Jesúsvaꞌ, ¿Aa chi jnda Joséhin? Cotaꞌjnꞌaan nnꞌan na ndahin. Ndoꞌ ngꞌe na nndaꞌ, ¿Ndu na itso jon na jndë jndyocue jon na jnan jon quiñoonꞌndue? ");
INSERT INTO azgNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tꞌa Jesús, itso jon ndëë nanꞌñeen: —Tananꞌncꞌuaaꞌhoꞌ yo ntyjehoꞌ ntyja ꞌnaanꞌ juu jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Chaꞌ na nndëë ngiooꞌ tsꞌon tsꞌan yo ntyja njan, icanhanꞌ na nquii tyëhöꞌ na iꞌua jon tsꞌianvahin nnön, ndyoyꞌoon jon tsanꞌñeen. Xe chito na nndaꞌ vaa, minncüii tsꞌan jeꞌquindëë ntsijonhin yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ee vaa jñꞌoon na jndui na sinin Isaías, tsan na toninncyaa jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. Juu jñꞌoonꞌñeen, ndö vaa na itsohanꞌ: “Ntsiꞌman Tyoꞌtsꞌon ndëë tsoñꞌen nnꞌan.” Juu jñꞌoonvaꞌ ninꞌquitsiquindyihanꞌ na ncüii cüii tsꞌan na jndë jndyii jñꞌoon na coninncya nnꞌan ntyja ꞌnaanꞌ jon, ndoꞌ jndë taaꞌ tsꞌon juuhanꞌ, ntsijon tsanꞌñeen yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","“Jñꞌoonvaꞌ tyiꞌtsiꞌmanhanꞌ na jndë jndyiaaꞌ tsꞌan Tyëhöꞌ Tyoꞌtsꞌon, xiaꞌntyi ja na iꞌua jon tsꞌian na jndyö quiiꞌ ntꞌanhoꞌ, ja jndë jntyꞌia nnönhin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Jñꞌoon na mayuuꞌ na matsjö ndëëhoꞌ, nin juu na vantyja tsꞌon ja, itsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja na condui tyooꞌ, tsꞌian na iꞌua Tyoꞌtsꞌon nnön na ncya na cotaꞌndoꞌ nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nque ndochihoꞌ tocüaꞌhan maná ndyuꞌñeen xjen na tomꞌanhan ndyuaa na xjen ro covaꞌ, ndoꞌ tjëhan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Majoꞌ ja matsinën ntyja ꞌnaanꞌ juu tyooꞌ na jnan quiñoonꞌndue na majoꞌ condui ja. Tsꞌan na ntcüaꞌ juu tyooꞌva, tyiꞌjeꞌquitsu ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja na jnan quiñoonꞌndue, condui ja tyooꞌ na mancya na cotaꞌndoꞌ ñuaan nnꞌan. Tsꞌan na ntcüaꞌ juu tyooꞌva itsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. Ndoꞌ juu tyooꞌ na mancya chaꞌ nnanꞌxuan nnꞌan na ntaꞌndoꞌhan tonnon Tyoꞌtsꞌon, conduihanꞌ sꞌei. ");
INSERT INTO azgNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ndoꞌ joo nnꞌan judíosꞌñeen, vi na jndë jndyehan jñꞌoonvaꞌ, jntꞌuehan jñꞌoon yo ntyjehan. Jnduehan: —Jaa mangiö tyiꞌjeꞌquindëë ninncyaa tsanvaꞌ seiiꞌ jon na ntquë. ");
INSERT INTO azgNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Joꞌ tsontyichen Jesús ndëëhan: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, ja na condui tsꞌan na jnan quiñoonꞌndue, chaꞌ na ntsixuan tsꞌan na tyiꞌquintycüii vandoꞌ ñuaanꞌ juu, chuhanꞌ na quii juu sꞌei ndoꞌ cꞌu juu nꞌeön. Xe tyiꞌntꞌahoꞌ na nndaꞌ, jeꞌquindëë nanꞌxuanhoꞌ na vandoꞌ ñuaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nquii tsꞌan na iquii sꞌei ndoꞌ na iꞌu juu nꞌeön, tsixuan juu na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. Ndoꞌ min na cueꞌ juu, majoꞌ xee na matsꞌiañꞌen ninncya na ngüandoꞌ xco juu. ");
INSERT INTO azgNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ee juu na ntcüaꞌ tsꞌan na ntyja ꞌnaanꞌhanꞌ na nninncyaahanꞌ na ngüandoꞌ ñuaanꞌ juu na tonnon Tyoꞌtsꞌon, juuhanꞌ conduihanꞌ sꞌei. Ndoꞌ juu na ncꞌu tsꞌan na ntyja ꞌnaanꞌhanꞌ ncꞌon tsꞌan na tein quiiꞌ ñuaanꞌ juu, joꞌ nꞌeön. ");
INSERT INTO azgNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Minꞌcya ro tsꞌan na iquii sꞌei ndoꞌ na iꞌu nꞌeön, contjo tsanꞌñeen ntyja njan, ndoꞌ mantyi contjo ja yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nquii Tyëhöꞌ na jñon jon ja quiiꞌ ntꞌanhoꞌ, vandoꞌ jon ndoꞌ mantyi ja vantꞌö ntyja ꞌnaanꞌ nquii jon. Manndaꞌ vaa itsijonhanꞌ ntyja ꞌnaanꞌ tsꞌan na iquii sꞌei, ngüandoꞌ ñuaanꞌ juu ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ja condui juu tyooꞌ na jnan quiñoonꞌndue. Ndochihoꞌ tocüaꞌhan maná ndoꞌ tjëhan. Majoꞌ tyiꞌitsijonhanꞌ ntyja njan chaꞌna juu manáꞌñeen. Ee minꞌcya ro tsꞌan na icüaꞌ juu tyooꞌ na condui ja, tyiꞌjon cueꞌ juu, mꞌaan juu xe mꞌaan juu na vandoꞌ juu ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jñꞌoonminꞌ sinin Jesús viochen xjen na siꞌman jon ndëë nnꞌan quiiꞌ vatsꞌon ꞌnaan nnꞌan judíos tsjoon Capernaum. ");
INSERT INTO azgNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Ndoꞌ majndye nnꞌan na tovaveeꞌ nꞌonhan jñꞌoon na toninncyaa Jesús, majoꞌ xjen na jndyehan jñꞌoonminꞌ jnduehan: —Tsanꞌ jñꞌoon itsinin tsanvaꞌ. Tyiꞌjeꞌquindëë ntsayꞌönntyëchën yo jñꞌoon na itsinin jon. ");
INSERT INTO azgNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Majoꞌ ntyjii tsꞌon Jesús, na jnanꞌncꞌuaaꞌ nꞌon nanꞌñeen yo ntyjehan ntyja ꞌnaanꞌ juu jñꞌoonꞌñeen na sinin jon ndëëhan. Mangꞌe joꞌ itso jon: —Jñꞌoonminꞌ, ¿Aa itsquioohanꞌ ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yajoꞌ quinanꞌtiu yahoꞌ nchu vaa ntsꞌaahanꞌ ꞌoꞌ juu xjen na njntyꞌiahoꞌ ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na jndyö quiiꞌ ntꞌanhoꞌ na ncjöva nntꞌa na tondye naijon na tomꞌan jndyëë. ");
INSERT INTO azgNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nquii Espíritu Santo conduihin na incyaa jon na nanꞌxuan nnꞌan na cotaꞌndoꞌ ñuaanhan tonnon Tyoꞌtsꞌon. Seiiꞌ tsꞌan ndincyaahanꞌ na ntsixuan tsꞌan na nndaꞌ. Jñꞌoon na mancya ndëëhoꞌ tsixuanhanꞌ ntyja ꞌnaanꞌ nquii Espíritu. Ndoꞌ ninnquiiꞌchen ntsixuan tsꞌan na vandoꞌ xco juu xengꞌe itsijonhin yo jñꞌoonmin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Majoꞌ tyiꞌtsoñꞌenhoꞌ vantyja nꞌonhoꞌ ja. Nndaꞌ ro jñꞌoon tso jon ndëë nanꞌñeen ee ntyjantyi xjen na taꞌ jon na toninncyaa jon jñꞌoon, ntyjii jndaꞌ jon nin joo na tyiꞌcantyja nꞌon jon, ndoꞌ nin juu na ninncyaa cüentahin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yajoꞌ tsontyichen jon: —Mangꞌe joꞌ na jndë tsjö ndëëhoꞌ, ninnquiiꞌ nndëë ntsijon tsꞌan yo ntyja njan xe na aa nquii Tyëhöꞌ Tyoꞌtsꞌon incyaa jon na ndui na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ndoꞌ ngꞌe jñꞌoonvaꞌ, jndye nnꞌan na tondye jndyee jñꞌoon na toninncyaa jon, tyentcüeꞌhan, tji ntcüeꞌhan ntyja ꞌnaanꞌ jon, tavijnanꞌjonntyichenhan yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mangꞌe joꞌ, taxeeꞌ jon ndë́ já nnꞌan na nchoꞌve na tꞌman jon, itso jon: —Ndoꞌ ꞌoꞌ jeꞌ, ¿Aa mantyi ninꞌquiꞌndyehoꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ndoꞌ tꞌa Simón Pedro, tso jon: —Tyiꞌntsuꞌ na nndaꞌ vaa, ta, tyiꞌquichuhanꞌ na ntsayꞌö́n jñꞌoon yo ncüiichen tsꞌan. Ee xiaꞌntyi juu jñꞌoon na matsininꞌ incyaahanꞌ na tyiꞌquintycüii na cotaꞌndoꞌ ñuan nján. ");
INSERT INTO azgNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ee já jndë vantyja nꞌö́n ꞌuꞌ ndoꞌ covaaꞌ nꞌö́n na condui ꞌuꞌ Cristo, jnda nquii Tyoꞌtsꞌon na vandoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ndoꞌ joꞌ tꞌa Jesús, itso jon: —Ja tji ꞌoꞌ na nchoꞌvehoꞌ, majoꞌ ncüiihoꞌ mꞌaan juu ntyja ꞌnaanꞌ juu yutyia. ");
INSERT INTO azgNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jñꞌoonvaꞌ itso jon na itsiꞌman jon Judas Iscariote, jnda ncüiichen Simón. Ee juu Judasꞌñeen na tyincyaa juu cüenta Jesús nduee nnꞌan. Mantyi juu conduihin ncüii já na nchoꞌve. ");
INSERT INTO azgNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jndë na tui nanꞌminꞌ, tomantyꞌí yo Jesús ndyuaa Galilea. Ee nque nnꞌan na conintque ndëë nnꞌan judíos, jnaanꞌ na tojooꞌ nꞌonhan na ninꞌquinanꞌcueeꞌhan jon, joꞌ na tavininꞌcja nndaꞌ jon ndyuaa Judea. ");
INSERT INTO azgNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ndoꞌ vavindyo na ngueeꞌ nguee na conanꞌtꞌmaanꞌ nnꞌan judíos xjen na conanꞌyahan xqueꞌncüanꞌ cüenta jndye na covañjoonꞌ nꞌonhan nchu vaa tomꞌan ndochiihan ndyuꞌñeenchen. ");
INSERT INTO azgNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ndoꞌ vi na mavaa xjen na ngueeꞌ juu ngueeꞌñeen, tondue ntyje nquii jon nnon jon: —Cüa, quinduiꞌ ntjoohin. Cjaꞌ ndyuaa Judea chaꞌ joo nnꞌan na cotsayꞌonhan yo jñꞌoon na mancyaꞌ na mꞌanhan joꞌ, mantyi ndëë njntyꞌia ndëëhan tsꞌian na matsaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ee tsꞌan na mantyja tsꞌon na cantyja nꞌon nnꞌan yohin, tyiꞌquichuhanꞌ na ntjohin na ninnquii juu. Tsoñꞌen nnꞌan ncyaꞌ jndyoyu na quindiohan ntyja ꞌnaanꞌ tsꞌian na matsaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ndöꞌ jñꞌoon na jnduehan nnon jon ngꞌe min nquehin tyíꞌcantyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ndoꞌ tso jon ndëëhan: —Tyiꞌcoventyja xjen na ntsiꞌman ja ndëë nnꞌan na condui ja nquii jon na itsinꞌman ñuaan nnꞌan. Majoꞌ ꞌoꞌ minꞌcya ro xjen na ninꞌcondyiꞌhoꞌ, taꞌnan na toncuuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Joo nnꞌan tsonnangue, tyiꞌcꞌonhan na tyiꞌcueeꞌ nꞌonhan ꞌoꞌ. Majoꞌ ninnquiiꞌchen mꞌanhan na tyiꞌcueeꞌ nꞌonhan ja, ngꞌe na macüjiꞌ jndyoyu ntyja ꞌnaanꞌ natyia na contꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Cüa, cꞌo nquehoꞌ ngueevaꞌ, ja yandëcya yajoꞌ chi ncjö. Ee tyiꞌcoventyja xjen na ntsiꞌman na condui ja nquii jon na itsinꞌman ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Vi jndë na tso jon na nndaꞌ ndëëhan, ntjontyichenhin ndyuaa Galilea vendye xuee. ");
INSERT INTO azgNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Majoꞌ ya na jndë tyꞌe ntyje jon na ngueeꞌ juu ngueeꞌñeen, yajoꞌ mantyi tantyja jon, majoꞌ tasiꞌman jndyoyuhin ndëë nnꞌan. Tja jon chaꞌvijon tsꞌan na tyiꞌquintꞌue tsꞌon na njntyꞌia nnꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ndoꞌ nnꞌan judíos na tyiꞌcueeꞌ nꞌonhan jon, tojntꞌuehan jon quiiꞌ ntꞌan nnꞌan na tyꞌe nguee. Totaꞌxeeꞌhan, tonduehan: —¿Yuu jon mꞌaan tsanꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndoꞌ nnꞌan na jndye jndyiꞌhin, tꞌman vaa na tyiꞌcüijon na jnanꞌneinhan ntyja ꞌnaanꞌ jon. Ee ñꞌen joohan na jnduehan: “Juu tsanvaꞌ, ya tsꞌanhin.” Majoꞌ mañoon ntyjehan jnduehan: “Tyiꞌyuuꞌhanꞌ ee itsiviꞌnnꞌan jon nnꞌan.” ");
INSERT INTO azgNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Majoꞌ tajnanꞌnein jndyoyuhan ntyja ꞌnaanꞌ jon ngꞌe ncyaahan ntyjehan nnꞌan judíos na conintque ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ya na tixoncüe na mꞌaan juu ngueeꞌñeen, yajoꞌ taqueeꞌ Jesús quiiꞌ vatsꞌon tꞌman ꞌnaan nnꞌan judíos ndoꞌ joꞌ totsiꞌman jon ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Majoꞌ nque nnꞌan judíos na conintque, tomꞌaanꞌ jndyi nꞌonhin ntyja ꞌnaanꞌ jñꞌoon na toninncyaa jon. Tonduehan: —Tsanvahin tatja juu scuela naijon na jnanꞌjnꞌaan. Yajoꞌ ¿Nchu vaa na condëë na itsitjonꞌ juu jñꞌoon? ");
INSERT INTO azgNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ndoꞌ na nndaꞌ jnduehan, tso Jesús ndëëhan: —Chito ncö sijntꞌa jñꞌoon na matsiꞌman. Nquii jon na iꞌua jon tsꞌian nnön na jndyö quiiꞌ ntꞌanhoꞌ, juu jon itsijndaꞌ joo jñꞌoonmin na matsiꞌman ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Majoꞌ minꞌcya ro tsꞌan na ninꞌquitsꞌaa juu ꞌnan na ntꞌue tsꞌon Tyoꞌtsꞌon, ncüaaꞌ tsꞌon juu na aa nquii jon sijndaꞌ jñꞌoon na matsiꞌman, ndoꞌ aa veꞌ jñꞌoon na sitiu ncö na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ee minꞌcya ro tsꞌan na icüjiꞌ jñꞌoon ntyja ꞌnaanꞌ nquii, itsichon tsanꞌñeen na quindui tꞌmanhin ndëë ntyje juu. Majoꞌ minninchen tsꞌan na itsichon na cüitꞌmaanꞌ nquii jon na jñonhin, jñꞌoon na itsinin tsanꞌñeen, conduihanꞌ na mayuuꞌ, tyiꞌquitsꞌaa juu ꞌnan na tyiꞌquichuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Tji Moisés jñꞌoon na tquen jon ndëëhoꞌ na icoꞌxenhanꞌ ꞌoꞌ. Majoꞌ min na nndaꞌ vaa, taꞌnan ncüiihoꞌ na ivangueeꞌ juuhanꞌ. Ee xe na aa cotaꞌngueeꞌhoꞌ juu jñꞌoonꞌñeen, tyiꞌjeꞌcjooꞌ nꞌonhoꞌ na ninꞌquinanꞌcueeꞌhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ndoꞌ tꞌa nanꞌñeen, jnduehan nnon jon: —ꞌUꞌ tsixuanꞌ yutyia. ¿Nin tsꞌan na ijooꞌ tsꞌon na ninꞌquitscueeꞌ ꞌuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ndoꞌ sintcüeꞌ Jesús jñꞌoon ndëëhan, itso jon: —Juu xuee na cotaꞌjndyëëhë, sinꞌman tsꞌan na ndicaca, ndoꞌ ngꞌe joꞌ tjonꞌ jñꞌoonhoꞌ na tyiꞌcaveeꞌ ngiohoꞌ yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Majoꞌ cüaaꞌ nꞌonhoꞌ jñꞌoon matsjö. Nquii Moisés tquen jon jñꞌoon na quintꞌahoꞌ yo yononꞌndaa ndahoꞌ chaꞌxjen na tontꞌa ndochihoꞌ na tomꞌan ndyu na toxenꞌ. Ndoꞌ juu tsꞌianꞌñeen conanꞌquindëhoꞌhanꞌ min juu xuee na cotaꞌjndyëëhë. Nque ndochiihoꞌ jnanꞌquitaꞌhin na contꞌahoꞌ na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ndoꞌ mangiohoꞌ juu jñꞌoon na tquen Moisés incyaahanꞌ na vanaan na quinanꞌquindëhoꞌ costumbreꞌñeen xee na cotaꞌjndyëëhë. Ndoꞌ na nndaꞌ vaa ¿Ndu na conanꞌvjeehoꞌ ja jnaanꞌ juu xuee na cotaꞌjndyëëhë na sinꞌman ncüii tsꞌan viiꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Joꞌ chito veꞌ xiaꞌntyi ntjiꞌhoꞌ cüenta ntyja ꞌnan na covityincyo. Quitjiꞌhoꞌ cüenta ntyja ꞌnaanꞌ ꞌnan na chuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Juu xjenꞌñeen, vendye nnꞌan Jerusalén taꞌhan taxeeꞌhan ndëë ntyjehan, jnduehan: —Tsansꞌava, ¿Aa chito jon tsꞌan na cojntꞌue nanmꞌannꞌian njanhan na nnanꞌcueeꞌhanhin? ");
INSERT INTO azgNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Majoꞌ quitquenhoꞌ cüenta, itsinin tyincyo jon ndëë nnꞌan, min tajñꞌoon quindue nanmꞌannꞌian nnon jon. ¿Aa ntsꞌaahanꞌ na nquehan conanꞌtiuhan na condui tsanvaꞌ nquii Mesías? ");
INSERT INTO azgNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Majoꞌ nquii tsanꞌñeen, xjen na ncüjeeꞌ jon, tanin tsꞌan quintjii yuu jon na nnan jon. Majoꞌ tsanvaꞌ jeꞌ, ngiö ya yuu jon jnan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Xjenꞌñeen siꞌman Jesús quiiꞌ vatsꞌon tꞌman ꞌnaan nnꞌan judíos. Ndoꞌ vi na jndë jndyii jon na nndaꞌ jndue nanꞌñeen, sue jon jndyeeꞌ jon. Itso jon: —ꞌOꞌ conduehoꞌ na cotaꞌjnꞌaanhoꞌ ja ndoꞌ ngiohoꞌ yuu jon jnan. Majoꞌ chito jndyö ntyja njan ncö, nquii jon na conduihin jñꞌoon na mayuuꞌ, iꞌua jon tsꞌian nnön na mꞌan quiiꞌ ntꞌanhoꞌ, majoꞌ ꞌoꞌ tyiꞌquitaꞌjnꞌaanhoꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ja mancüiixjen mavajnꞌanhin, ee na mꞌaan jon jnan, ndoꞌ nquii jon iꞌua jon tsꞌian nnön na jndyö na mꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ndoꞌ ngꞌe juu jñꞌoonvaꞌ na tso Jesús, tojooꞌ yantyi nꞌon nanmꞌannꞌianꞌñeen na ntꞌueviꞌhan jon. Majoꞌ ngꞌe na tyíꞌcoventyja xjen na ntyjii Tyoꞌtsꞌon na ngenon jon juu naviꞌ tꞌman, joꞌ minncüiihan tatꞌuehan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ndoꞌ nnꞌan na tomꞌan joꞌ, jndyehan tëntyja nꞌonhan jon. Tonduehan ndëë ntyjehan: —Nquii Cristo, xjen na ncüjeeꞌ jon, ¿Aa jndyentyichen tsꞌian na ntsꞌaa jon na tyiꞌjeꞌquindëë nduihanꞌ ntyja najndei nquii tsꞌan, chintyi na itsꞌaa tsanvaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nque nnꞌan na conduihan tmaanꞌ fariseos tondyehan na tonanꞌnein nnꞌan jñꞌoonminꞌ ntyja ꞌnaanꞌ Jesús. Yajoꞌ jnanꞌjonhan jñꞌoon yo ntyee na conintque ndëë ntyjehan nnꞌan judíos na tꞌuahan tsꞌian ndëë cominsión na quitsacyꞌon nanꞌñeen jon. ");
INSERT INTO azgNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Veꞌ jnaanꞌ joꞌ itso Jesús ndëë nnꞌan na jndye jndyiꞌhin: —Jndë titsiaaꞌviꞌ xuee na vi mꞌan yo ꞌoꞌ. Ndoꞌ ndë joꞌ ncjö ntcüꞌë na mꞌaan nquii jon na jñon jon ja quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Juu xjenꞌñeen njntꞌuehoꞌ ja, majoꞌ taxeꞌquindiohoꞌ ja ee yuu jon na nguë, ꞌoꞌ jeꞌquindëë ntsquehoꞌ joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ndoꞌ vendye nnꞌan judíosꞌñeen tonduehan ndëë ntyjehan: —¿Yuu vijon ncja tsanvaꞌ na tajeꞌquindëë ndiöhin? ¿Aa ntsꞌaahanꞌ na ncja jon quiiꞌ ntꞌan ntyjëëhë judíos na jndë tycyahan quiiꞌ ntꞌan nnꞌan na conanꞌnein jñꞌoon griego, chaꞌ ntsiꞌman jon ndëëhan ntyja ꞌnaanꞌ Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Nin ninꞌquitsiquindyi juu jñꞌoonvaꞌ na itsinin jon na njntꞌuëhin, majoꞌ jeꞌquindiöhin? Ndoꞌ na itso jon yuu jon na vja jon, tyiꞌjeꞌquindëë ntsquë na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Juu xuee na matsꞌiañꞌen na mꞌaan juu ngueeꞌñeen, nque nnꞌan judíos contꞌahan na tꞌmanntyichenhanꞌ na conanꞌtꞌmaanꞌhan. Juu xueeꞌñeen tëcüentyjeeꞌ Jesús, sue jon jndyeeꞌ jon. Itso jon: —Minꞌcya ro tsꞌan na ninꞌcꞌoon jndyi juu nacje ꞌnaanꞌ Tyoꞌtsꞌon, quindyotsijonhin yo ja ndoꞌ cantyja tsꞌon juu ja. ");
INSERT INTO azgNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Na ntsꞌaa tsꞌan na nndaꞌ, ntsꞌaahanꞌ yohin chaꞌxjen na tso jñꞌoonꞌ Tyoꞌtsꞌon na jndë jndui. Juu jñꞌoonꞌñeen itsiquindyihanꞌ na quityquiiꞌ tsꞌon tsꞌan nnanꞌ chaꞌvijon ndaa jndaa cüenta jndye na coninncyahanꞌ na tyiꞌquintycüii na cotaꞌndoꞌ ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jñꞌoonvaꞌ sinin jon na itsiꞌman jon ntyja ꞌnaanꞌ nquii Espíritu Santo na joo nnꞌan na vantyja nꞌonhan jon ncyꞌonhan cüentahin. Ee juu xjenꞌñeen tyíꞌcojñon Tyoꞌtsꞌon jon quiiꞌ ñuaan nnꞌan ngꞌe vitjachen na ngüentyja xjen na ntsitꞌmaanꞌ Tyoꞌtsꞌon juu Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ndoꞌ vendye nnꞌan na mꞌan quiiꞌ ntꞌan nnꞌan na jndye jndyiꞌhin, tondyehan jñꞌoonminꞌ na sinin jon. Joꞌ tonduehan: —Tsansꞌavaꞌ mayuuꞌ conduihin nquii tsꞌan na vaa jñꞌoon na ncüjeeꞌ jon tsonnangue na ninncyaa jon jñꞌoonꞌ Tyoꞌtsꞌon ndëë ntyja nchu vaa ꞌnan na nguaa. ");
INSERT INTO azgNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ndoꞌ ñꞌen vendye nnꞌan jnduehan: —Conduihin nquii Mesías. Majoꞌ vendyechen ntyjehan jnduehan: —Nchu tajnꞌaanhoꞌ, juu tsꞌan na conduihin Mesías chito conduihin tsꞌan ndyuaa Galilea. ");
INSERT INTO azgNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ee juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui tivio itsiquindyihanꞌ na juu Mesías conduihin tsjaan David na ndyocahanꞌ. Ndoꞌ mantyi tsꞌan tsjoon chjo Belénhin naijon na jnan nquii David. ");
INSERT INTO azgNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tsojnaanꞌ jñꞌoonminꞌ sꞌaahanꞌ na tyiꞌninncüii tondyiiꞌ nꞌon nnꞌan ntyja ꞌnaanꞌ Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ee ñꞌenhan na ninꞌcyꞌonhan jon, majoꞌ minꞌncüii tsꞌan tyíꞌquitsꞌaahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Yajoꞌ joo cominsiónꞌñeen na cotyentjonhan vatsꞌon, tyꞌe ntcüeꞌhan na mꞌaan ntyee na conintque yo nnꞌan tmaanꞌ fariseos. Ndoꞌ taxeeꞌ nanꞌñeen ndëëhan. Jnduehan: —¿Ndu na tajndyoyꞌonhoꞌhin? ");
INSERT INTO azgNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Yajoꞌ nque cominsiónꞌñeen tꞌahan. Jnduehan: —Minꞌjon tacondyë́ na ntsinin ncüii tsꞌan chaꞌxjen juu jñꞌoon na njon jndyi na incyaa tsanvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ndoꞌ joo nnꞌan tmaanꞌ fariseoꞌñeen tꞌahan, jnduehan: —¿Aa mantyi itsiviꞌnnꞌanhanꞌ ꞌoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Quitquenhoꞌ cüenta. Taꞌnan ncüii tsꞌan na mꞌaan tsꞌian na vantyja tsꞌon jon juu, ndoꞌ min nquë́ fariseos. ");
INSERT INTO azgNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Majoꞌ joo nnꞌan na jndye jndyiꞌhin na tyiꞌjndaꞌ nquenhan, juu ntji na tquen Tyoꞌtsꞌon na icoꞌxenhanꞌ, tyiꞌcovaaꞌ nꞌonhinhanꞌ. Mangꞌe joꞌ nanꞌxuanhan na quitsu ñuaanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Majoꞌ tꞌa Nicodemo, tsan na tja na mꞌaan Jesús ncüii tijaan, jon ncüii nque nanmꞌannꞌianꞌñeen. Tꞌa jon, ");
INSERT INTO azgNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Itso jon ndëë nanꞌñeen: —Juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui na icoꞌxenhanꞌ jaa, mangiö na itsiquindyihanꞌ na tyiꞌquichuhanꞌ na ngitoxën ncüii tsꞌan vitjachen na ndyëë jnaanꞌ juu, ndoꞌ na ninjndaꞌ nin ꞌnan sꞌaa juu. ");
INSERT INTO azgNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ndoꞌ nanꞌñeen jeꞌ, tꞌahan ꞌndyo jon, jnduehan: —Aa xe ꞌuꞌ, ¿Aa mantyi condui ꞌuꞌ tsꞌan Galilea? Cüa, chen chen quitsijnanꞌ jñꞌoonꞌ Tyoꞌtsꞌon na jndui, yajoꞌ ngavaaꞌ ya tsonꞌ na taꞌnan ncüii tsꞌan na nnan Galilea na ninncyaa juu jñꞌoonꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ndoꞌ ncüii cüii joo nanꞌñeen tyꞌehan ntꞌaahan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Majoꞌ Jesús tja jon tyoꞌ Olivos. ");
INSERT INTO azgNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ndoꞌ tonco ncüiichen xuee jndyo ntcüeꞌ jon, taqueeꞌ nndaꞌ jon vatsꞌon tꞌman ꞌnaanꞌ nnꞌan judíos. Xjenꞌñeen jndye jndyi nnꞌan squenon na mꞌaan jon. Ndoꞌ vi na jndë tëcjo jon na ntsiꞌman jon ndëëhan, ");
INSERT INTO azgNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Yajoꞌ joo nnꞌan na conanꞌman jñꞌoon na tquen Moisés na coꞌxenhanꞌ yo ninꞌjoo nnꞌan na conduihan tmaanꞌ fariseos, sayꞌonhan ncüii tsanscu na mꞌaan jon. Juu tsanꞌñeen tyꞌonhan juu maninꞌ juu xjen na itsitjahin yo ncüii tsansꞌa na veꞌ tjon yahin. Yajoꞌ taꞌhanhin xoncüe quiiꞌ ntꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ndoꞌ jnduehan nnon Jesús: —ꞌUꞌ na matsiꞌmanꞌ ndë́ ntyja ꞌnaanꞌ Tyoꞌtsꞌon, juu tsanscuva tyꞌönhin maninꞌ juu xjen na itsitjahin yo ncüii tsansꞌa. ");
INSERT INTO azgNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ndoꞌ juu ntji na tquen Moisés, icoꞌxenhanꞌ na quitmënꞌ ntjöꞌ nanntcu na contꞌa na nndaꞌ. Majoꞌ ꞌuꞌ jeꞌ, ¿Nchu vaa matsuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ndöꞌ vaa na jnduehan nnon jon ngꞌe ntꞌue nꞌonhan na quitꞌuiihanꞌhin. Majoꞌ tëcjo tyosu Jesús, taꞌ jon na icüji jon quiiꞌ tsꞌojndë yo nonntꞌö jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndoꞌ ngꞌe na tyíꞌcotsacüentyjeeꞌhan na cotaxeeꞌhan jñꞌoonvaꞌ nnon jon, tëcüentyjeeꞌ jon. Itso jon ndëëhan: —Nin ncüiihoꞌ na tajnan tsixuan, juu quiminꞌ jndyee tsjöꞌ tsanscuva. ");
INSERT INTO azgNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jndë joꞌ, tacjo tyosu nndaꞌ jon, tjintyichen jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Majoꞌ vi na jndë jndye nanꞌñeen jñꞌoonvaꞌ, sꞌaahanꞌ na tejnꞌaanhin. Yajoꞌ ncüii cüiihan tyeꞌ jnduiꞌhan joꞌ. Nque nantque, joohan jnduiꞌ jndyee, jndë joꞌ nnꞌan na cotsantyja. Matsꞌiañꞌen xiaꞌntyi ninnquii Jesús ntjohin yo juu tsanscuꞌñeen na minntyjeeꞌ juu tonnon jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yajoꞌ tacüentyjeeꞌ nndaꞌ Jesús. Ndoꞌ ngꞌe minꞌncüii joo nanꞌñeen na taviꞌcꞌon, ninnquii tsanscuꞌñeen vi mꞌaan, yajoꞌ itso jon nnon juu: —ꞌUꞌ tsanscu, joo nnꞌan na contꞌa jnanꞌ, ¿Yuu mꞌanhan? ¿Aa tyiꞌquitmeinꞌhan ntjöꞌ ꞌuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tꞌa tsanscuꞌñeen, tso juu: —Taꞌnan yu ro, ta. Itso Jesús nnon juu: —Min ja, jeꞌquitsꞌa na quitꞌuiihanꞌ ꞌuꞌ ntyja ꞌnaanꞌ jnanꞌ. Nanein cjaꞌ, tavintsaꞌtoꞌ na vaa nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ndoꞌ sinin nndaꞌ Jesús ndëë nnꞌan, itso jon: —Ja condui naxuee ndëë nnꞌan tsonnangue. Minninchen tsꞌan na itsijonhin yo ja, xeꞌcꞌoon juu nacje ꞌnaanꞌ najaan na conduihanꞌ natyia. Juu tsanꞌñeen ncꞌoon juu nacje njan na condui ja naxuee na mancya na tyiꞌquintycüii na vandoꞌ ñuaanꞌ tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Majoꞌ nnꞌan tmaanꞌ fariseos jnduehan nnon jon: —ꞌUꞌ macüjiꞌ jndyoyu nquii ꞌuꞌ ntyja ꞌnanꞌ. Ndoꞌ jñꞌoonꞌñeen min tyiꞌyuuꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yajoꞌ tꞌa Jesús jndyuehan: —Min na macüjiꞌ jndyoyu ntyja njan, majoꞌ jñꞌoon na mayuuꞌ tsixuanhanꞌ, ngꞌe ntyji yuu jon jnan, ndoꞌ nchji yuu jon jö. Majoꞌ ꞌoꞌ min tyiꞌquindiohoꞌ yuu jnan, min yuu na jö. ");
INSERT INTO azgNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ꞌOꞌ veꞌ xiaꞌntyi yo ꞌnan na covaaꞌ nꞌon nnꞌan, joꞌ cotjiꞌhoꞌ cüenta ntyja ꞌnaan ntyjehoꞌ, majoꞌ ja minꞌncüii tsꞌan tyiꞌquitꞌui jahin yo jnaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Majoꞌ ya na ngüentyja xjen na ntcoꞌxën nnꞌan, ntcoꞌxënhan chaꞌxjen na chuhanꞌ ee chito mꞌan na ninncö na ntsꞌahanꞌ. Nquii Tyëhöꞌ na jñon jon ja ntjoohin, mꞌaan jon yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Conanꞌyꞌonhoꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui na coꞌxenhanꞌ. Quiiꞌ jñꞌoonꞌñeen itsohanꞌ na cantyja nꞌonhoꞌ jñꞌoon na cotjiꞌ jndyoyu ve nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ja condui ncüii tsꞌan na macüjiꞌ jndyoyu ntyja njan, ndoꞌ nquii Tyëhöꞌ conduihin ncüiichen na ndë ve. ");
INSERT INTO azgNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ndoꞌ na nndaꞌ tso jon, jndue nanꞌñeen nnon jon: —¿Yuu vijon mꞌaan juu tyeꞌ? Tꞌa Jesús, itso jon: —ꞌOꞌ tyiꞌcovaaꞌ nꞌonhoꞌ ntyja njan min ntyja ꞌnaanꞌ nquii jon. Ee xe covaaꞌ nꞌonhoꞌ ntyja njan, yajoꞌ mantyi ncüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jñꞌoonminꞌ sinin Jesús viochen xjen na totsiꞌman jon quiiꞌ vatsꞌon tꞌman ꞌnaan nnꞌan judíos, ndyo naijon na cotjueꞌ nnꞌan sꞌon cüentaaꞌ Tyoꞌtsꞌon, majoꞌ min tanin tsꞌan na tꞌuiihin ee tyiꞌcoventyja xjen na ngenon jon naviꞌ tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ndoꞌ itsontyichen Jesús ndëëhan: —Ja jö, ndoꞌ ꞌoꞌ njntꞌuehoꞌ ja, majoꞌ ninvaa chohoꞌ jnanhoꞌ ndoꞌ ncüjehoꞌ. Ee naijon na jö, ꞌoꞌ jeꞌquindëë ntsquehoꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ngꞌe na tso jon jñꞌoonvaꞌ, taxeeꞌ nnꞌan judíos: —¿Aa ntsꞌaahanꞌ na ntscueeꞌ nquiihin, na itso juu yuu na vja juu jeꞌquindëë ntsquëhanꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Joꞌ tꞌa jon jndyuehan, itso jon: —ꞌOꞌ tyiꞌquinanꞌxuanhoꞌ ntyja ꞌnaanꞌ quiñoonꞌndue, majoꞌ ja mꞌan ntyja ꞌnaanꞌhanꞌ. ꞌOꞌ mꞌanhoꞌ ntyja ꞌnaanꞌ juu tsonnangue, majoꞌ ja tyiꞌquitsixuan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Mangꞌe joꞌ jndë tsjö jñꞌoonvaꞌ ndëëhoꞌ na ninvaa chohoꞌ jnanhoꞌ ndoꞌ ncüjehoꞌ. Ee xe na aa tyiꞌcovantyja nꞌonhoꞌ na condui ja nquii jon na tꞌua Tyoꞌtsꞌon tsꞌian nnön na jndyö quiiꞌ ntꞌanhoꞌ, yajoꞌ ninvaa chohoꞌ jnanhoꞌ ndoꞌ ncüjehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yajoꞌ taxeeꞌ nndaꞌhan nnon jon, jnduehan: —¿Nin condui ꞌuꞌ? Tꞌa Jesús jndyuehan: —Maninjuuntyi jñꞌoon chaꞌxjen na jndë totsjö ndëëhoꞌ ntyjantyi xjen na tꞌa na mancya jñꞌoon naya. ");
INSERT INTO azgNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nquii jon na conduihin na mayuuꞌ jñon jon ja na mꞌanhoꞌ, jndye jñꞌoon tso jon nnön na quitsiꞌmanhanꞌ ndëëhoꞌ. Ja ninnquiiꞌchen matscüenön joo jñꞌoonꞌñeen ndëë nnꞌan. Ndoꞌ jndye jñꞌoon min na ntyjii jon na chuhanꞌ na coꞌxën. ");
INSERT INTO azgNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Majoꞌ joo nanꞌñeen, tataaꞌ nꞌonhan na itsiꞌman jon na nquii Tyoꞌtsꞌon condui tye jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ndoꞌ tsontyichen Jesús ndëëhan: —Condui ja nquii tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na mꞌan quiiꞌ ntꞌanhoꞌ. Ndoꞌ vi na jndë tꞌionhoꞌ ja tsonjnꞌaan, juu xjenꞌñeen ncüaaꞌ nꞌonhoꞌ na juu jon condui ja ndoꞌ mantyi na taꞌnan ncüii nnon na matsꞌa ntyja nchu vaa na matsixuan ncö. Ntyjantyi na siꞌman Tyëhöꞌ nnön, xiaꞌntyi joohanꞌ na matsiꞌman ndëë nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndoꞌ nquii Tyëhöꞌ na jñon jon ja quiiꞌ ntꞌanhoꞌ, mꞌaan jon yo ja. Tyiꞌcoꞌndyii jon ja na ninncö, ngꞌe ninnquiiꞌchen matsꞌa ncüii cüii nnon na caveeꞌ ntyjii jon yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Ndoꞌ vi na jndë sinin Jesús jñꞌoonminꞌ, jndye nnꞌan tëntyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndoꞌ tso Jesús ndëë nnꞌan judíos na jndë vantyja nꞌonhan jon: —Xe na aa ntjotyenhoꞌ ntyja ꞌnaanꞌ juu jñꞌoon na mancya ndëëhoꞌ, yajoꞌ mayuuꞌ conduihoꞌ nnꞌan na cotsayꞌon yo jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ndoꞌ mantyi ncüaaꞌ nꞌonhoꞌ nin jñꞌoon conduihanꞌ na mayuuꞌ, ndoꞌ na nndaꞌ, ja na condui jñꞌoon na mayuuꞌ, ntsiquindya ꞌoꞌ ntyja ꞌnaanꞌ jnanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tꞌa nanꞌñeen, jnduehan: —Nquë́ condui já tsjaan ꞌnaanꞌ Abraham na jndyocahanꞌ. Minꞌjon tacondui já nnꞌan na totyeꞌntjontyen ndëë mañoon nnꞌan. ¿Ndu na matsuꞌ na ntsiquindyaꞌ já na mꞌán nacje ꞌnaanꞌ ncüiichen tsꞌan? ");
INSERT INTO azgNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ndoꞌ tꞌa Jesús, itso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minꞌcya ro tsꞌan na itsitjahin nnon Tyoꞌtsꞌon, juu jnaanꞌ tsanꞌñeen ityeꞌntjontyenhanꞌhin. Ndoꞌ na nndaꞌ, itsijonhanꞌhin chaꞌvijon tsꞌan na ityentjontyen nnon ncüiichen tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juu tsan na conduihin tsꞌan na ityeꞌntjontyen juu nnon patrón ꞌnaanꞌ juu, tyiꞌjndaꞌ na aa ntjotyenhin nacje ꞌnaanꞌ jon. Majoꞌ nquii jnda jon, manchaꞌ xjen mꞌaan juu yo jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ja na condui jnda Tyoꞌtsꞌon, ntsiquindyahoꞌ ntyja ꞌnaanꞌ jnanhoꞌ, ndoꞌ ngꞌe joꞌ, nanꞌxuanhoꞌ na mayuuꞌ conduihoꞌ nnꞌan na jndë jndyaahoꞌ ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ndoꞌ mantyji ya na conduihoꞌ tsjaan Abraham na jndyocahanꞌ, majoꞌ tsojnaanꞌ na ndiquioo jñꞌoon njan quiiꞌ ñuaanhoꞌ, joꞌ na cojooꞌ nꞌonhoꞌ na ninꞌquinanꞌcueeꞌhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ja matsinën ndëëhoꞌ ꞌnan na jndë jntyꞌia nnön xjen na tomꞌan yo Tyëhöꞌ. Majoꞌ ꞌoꞌ contꞌahoꞌ ꞌnan na jndë jndyehoꞌ na tso nquii juu na conduihin tyehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tꞌahan, jnduehan nnon jon: —Nquii Abraham conduihin tyë́. Ndoꞌ tꞌa Jesús, itso jon ndëëhan: —Xe na aa mayuuꞌ conduihoꞌ tsjaan ꞌnaanꞌ Abraham na jndyocahanꞌ, yajoꞌ ntꞌahoꞌ chaꞌxjen na totsꞌaa nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Majoꞌ ꞌoꞌ cojooꞌ nꞌonhoꞌ na ninꞌquinanꞌcueeꞌhoꞌ ja na condui ja tsꞌan na matsinën jñꞌoon mayuuꞌ ndëëhoꞌ, ndoꞌ joo jñꞌoonꞌñeen ninnquiiꞌchen jñꞌoon ꞌndyo Tyoꞌtsꞌonhanꞌ na jndyi ja. Nquii Abraham tyíꞌquitsꞌaa jon chaꞌxjen ꞌnan na contꞌahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Majoꞌ ꞌoꞌ contꞌahoꞌ chaꞌxjen na itsꞌaa nquii tyehoꞌ. Tꞌahan, jnduehan nnon jon: —Já chito na tui já na tyiꞌjndaꞌ nin tsꞌan tyë́. Ninncüii tyë́ mꞌaan, nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tꞌa Jesús, itso jon: —Xe na aa mayuuꞌ Tyoꞌtsꞌon conduihin tyehoꞌ, yajoꞌ mantyi nnanꞌvengiohoꞌ ja, ngꞌe ja na mꞌaan jon jnan ndoꞌ jndyö na mꞌanhoꞌ. Majoꞌ chito aa jndyö ntyja njan ncö, nquii jon iꞌua jon tsꞌian nnön na mꞌan quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Ndu na ndicüaaꞌ nꞌonhoꞌ jñꞌoon matsinën? Ndöꞌ va na coquenonhoꞌ ngꞌe tyiꞌninꞌquindyehoꞌ jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ꞌOꞌ nanꞌxuanhoꞌ ntyja ꞌnaanꞌ tyehoꞌ nquii yutyia, ndoꞌ ninꞌquinanꞌquindëhoꞌ ꞌnan na ntꞌue tsꞌon juu yohoꞌ. Ntyjantyi xjen na tui tsonnangue, juu conduihin na itscüje juu nnꞌan. Tyiꞌcꞌoon juu ntyja ꞌnaanꞌ jñꞌoon na mayuuꞌ ee ndiquitsixuan juuhanꞌ. Ya na itsinin juu quintu, itsinin juu ntyjantyi ꞌnan na itsixuan nquii juu ngꞌe tsanquintuhin ndoꞌ conduihin tye joo jñꞌoon quintu. ");
INSERT INTO azgNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Majoꞌ ngꞌe na matsinën jñꞌoon na mayuuꞌ ntyja njan, joꞌ tyiꞌninꞌcantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tanin ncüiihoꞌ na nndëë ntsiꞌman juu na matsitja ja nnon Tyoꞌtsꞌon. Jñꞌoon na matsjö ndëëhoꞌ conduihanꞌ jñꞌoon mayuuꞌ. Ngꞌe na nndaꞌ, ¿Ndu na tyiꞌninꞌcantyja nꞌonhoꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Minꞌcya ro tsꞌan na mꞌaan juu ntyja ꞌnaanꞌ Tyoꞌtsꞌon, nndyii juu jñꞌoon ꞌndyo jon. Majoꞌ ngꞌe na tyiꞌconduihoꞌ ntyja ꞌnaanꞌ jon, joꞌ na tyiꞌninꞌquindyehoꞌ jñꞌoon naya ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yajoꞌ nnꞌan judíosꞌñeen tꞌahan ꞌndyo jon, jnduehan: —Jñꞌoon na mayuuꞌ conduë́ na condui ꞌuꞌ tsꞌan ndyuaa Samaria. Mantyi tsixuanꞌ yutyia, joꞌ na tsitsanꞌhanꞌ xquenꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ndoꞌ tꞌa Jesús jndyuehan, itso jon: —Ja tyiꞌtsixuan yutyia. Ja nquii Tyëhöꞌ matsitꞌmanꞌ, majoꞌ ꞌoꞌ tyiꞌquinjon ja ngiohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ja chito mantꞌuë na quinanꞌquinjon ꞌoꞌ ja. Mꞌaan ncüiichen na itsiquinjon jon ja ndoꞌ nquii jon ntcoꞌxen jon na aa conduihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minꞌcya ro tsꞌan na tsijñꞌoonꞌ yo jñꞌoon na mancya, tyiꞌjeꞌquitsu ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Nque nnꞌan judíosꞌñeen, tꞌahan ꞌndyo jon, jnduehan: —Nanein covaaꞌ nꞌö́n na matsixuanꞌ yutyia. Abrahan tueꞌ jon, ndoꞌ mantyi nque nnꞌan na tomꞌan ndyu na toxenꞌchen na toninncyahan jñꞌoonꞌ Tyoꞌtsꞌon ntyja nchu vaa ꞌnan na nguaa. Majoꞌ ꞌuꞌ matsuꞌ: “Minꞌninchen tsꞌan na itsijñꞌoonꞌ yo jñꞌoon ꞌnanꞌ, tyiꞌjeꞌquitsuhin.” ");
INSERT INTO azgNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Aa matsaꞌ na tꞌmanntyi condui ꞌuꞌ, chichen tsochiihi Abraham, tsan na tueꞌ ndyu na toxenꞌchen? Ndoꞌ mantyi nnꞌan na toninncya jñꞌoonꞌ Tyoꞌtsꞌon ndyu na toxenꞌchen ntyja nchu vaa ꞌnan na nguaa, jndë tjëhan. ꞌUꞌ jeꞌ, ¿Nin tsꞌan na macüjiꞌ nquii ꞌu cüenta na condui ꞌuꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ndoꞌ tꞌa Jesús jndyuehan, itso jon: —Tyiꞌxeꞌcüijntꞌue xe na aa matsiquinjon nquii ja. Nquii Tyëhöꞌ conduihin na itsiquinjon jon ja, manquii jon na conduehoꞌ na conduihin Tyoꞌtsꞌon cüentahoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ꞌOꞌ tyiꞌcotajnꞌaanhoꞌ jon. Ja mayuuꞌ mavajnꞌanhin, ndoꞌ xe na aa matsjö na tyiꞌcüajnꞌanhin, yajoꞌ ntsꞌa na quintu ja chaꞌxjen ꞌoꞌ mꞌanhoꞌ na quintuhoꞌ. Majoꞌ ja mayuuꞌ mavajnꞌanhin, ndoꞌ matsuë jñꞌoon ꞌndyo jon. ");
INSERT INTO azgNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Nquii tsochiihoꞌ Abraham tyioo na neiinꞌ jon na taaꞌ tsꞌon jon na ngueeꞌ xjen na ndui ja na tsꞌan ja. Jndyiaaꞌ jon na nndaꞌ, ndoꞌ tyioo na neiinꞌ jndyi jon ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ndoꞌ tꞌa nanꞌñeen, jnduehan: —ꞌUꞌ min na tacondë vennꞌan nchoꞌnqui nchuꞌ. Tyiꞌya matsuꞌ na jndë jndyiaꞌ Abraham. ");
INSERT INTO azgNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ndoꞌ joꞌ tꞌa Jesús jndyuehan: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, vitjachen na nndui Abraham, majoꞌ ja macüiixjen mꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Yajoꞌ nanꞌñeen jnanꞌncüihan ntjöꞌ na ntmeinꞌhan jon. Majoꞌ tyiꞌquitquenhan cüenta na tenon jon xoncüe quiiꞌ ntꞌanhan. Jnduiꞌ jon vatsꞌon tꞌman. ");
INSERT INTO azgNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Já nnꞌan na nchoꞌve na tqueenꞌ Jesús na quinanꞌjö́n yo tsꞌian na totsꞌaa jon, tomantyꞌí yohin. Xjen na sacüenö́n ncüii joo, jntyꞌiá ncüii tsansꞌa na mancüiixjen nchjaanꞌ juu xjen na tuihin. ");
INSERT INTO azgNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Taxꞌë́ nnon Jesús, jnduë́: —ꞌUꞌ ta, na matsiꞌmanꞌ jñꞌoonꞌ Tyoꞌtsꞌon ndë́, ¿Nin juu sitjahin nnon Tyoꞌtsꞌon na tui tsanvaꞌ na nchjaanꞌ juu? ¿Aa nquii juu ndoꞌ aa nnꞌan na ndahin? ");
INSERT INTO azgNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Joꞌ tꞌa Jesús, itso jon: —Min chito jnaanꞌ nquii tsanvaꞌ na tuihin na nchjaanꞌ juu, min chito jnan nque nnꞌan na ndahin. Nndaꞌ vaa na iquenon juu chaꞌ ntyja ꞌnaanꞌhanꞌ ntsiꞌmanhanꞌ juu najndei na tsixuan nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Nquii jon na jñon jon ja, iꞌua jon tsꞌian nnön na quitsꞌa. Ndoꞌ tsixuan na quitsꞌa tsꞌianꞌñeen viochen xjen na ninvantꞌö. Majoꞌ mangüentyja xjen na ncüjë, yajoꞌ tajeꞌquindëë ntꞌantyëchën tsꞌian ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Viochen xjen na mꞌan ja quiiꞌ ntꞌan nnꞌan, itsijonhanꞌ ja chaꞌvijon chon na mancya naxuee ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Vi jndë tso Jesús na nndaꞌ, tjuꞌ jon ndaa ꞌndyo jon tyuaa. Sꞌaa jon ndooꞌ yohanꞌ, ndë joꞌ tyu jonhanꞌ ndöꞌnnon juu tsannchjaanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Jndë joꞌ itso jon nnon tsanꞌñeen: —Cjaꞌ pila Siloé, quimanꞌ ndöꞌnnonꞌ. (Jñꞌoon Siloé itsiquindyihanꞌ na jñon tsꞌan tyje juu ncüii ntꞌaa.) Ndoꞌ tsannchjaanꞌñeen tja juu joꞌ, tman juu ndöꞌnnon juu. Ndoꞌ ya na jndyo ntcüeꞌ juu, xuee jndyiaaꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndoꞌ nnꞌan na mꞌan ndyo vaaꞌ tsanꞌñeen yo nnꞌan na tojntyꞌia na tocan juu ꞌnan na totsitjahanꞌhin, jntyꞌiahan na ndyo ntcüeꞌ juu. Yajoꞌ taxeeꞌhan ndëë ntyjehan: —Tsanvaꞌ, ¿Aa chito majuu tsannchjaanꞌ na tovequityen na tocan ꞌnan na itsitjahanꞌhin ndëë? ");
INSERT INTO azgNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jndue vendyehan: —Majuu ndöꞌ. Majoꞌ mañoon ntyjehan jndue: —Chito juu, veꞌ manndaꞌ vaahin. Majoꞌ itso nquii juu: —Maja ndö. ");
INSERT INTO azgNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yajoꞌ taxeeꞌhan nnon juu: —¿Nchu tui na ya mandyiaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tꞌa juu jndyuehan, itso juu: —Juu tsan na jndyu Jesús sꞌaa jon ndooꞌ, tyu jonhanꞌ ndöꞌnnön. Jndë joꞌ tso jon na cjö Siloé quiman nnön. Ndoꞌ tyjë joꞌ, tman nnön, ndoꞌ tyincyaahanꞌ na ya mantyꞌia. ");
INSERT INTO azgNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ndoꞌ taxeeꞌntyichenhan nnon juu, jnduehan: —¿Yuu jon mꞌaan tsanꞌñeen? Tꞌa juu jndyuehan: —Tyiꞌquintji yuu jon mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ndoꞌ juu tsanꞌñeen na tomꞌaan juu na nchjaanꞌ, tyeyꞌon nnꞌanhin na tondëë ntyjehin nnꞌan judíos na conduihin tmaanꞌ fariseos. ");
INSERT INTO azgNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ndoꞌ juu xjen na sꞌaa Jesús ndooꞌ na tyincyaa jon na ya jndyiaaꞌ tsanꞌñeen, joꞌ xuee na cotajndyee nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ndoꞌ nque nnꞌan fariseosꞌñeen taxeeꞌntyihin nnon juu, jnduehan: —¿Nchu vaa ꞌnan na tui na ya mandyiaꞌ? Tꞌa juu, itso juu: —Tyu tsanꞌñeen ndooꞌ ndöꞌnnön, jndë joꞌ tmanhanꞌ, ndoꞌ nanein xuee mantyꞌia. ");
INSERT INTO azgNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ndoꞌ vendye fariseosꞌñeen, jnduehan: —Tsan na sinꞌman ꞌuꞌ, tacꞌoon juu ntyja ꞌnaanꞌ Tyoꞌtsꞌon, ee tyiꞌcueeꞌ tsꞌon juu juu xuee na cotajndyëë. Majoꞌ vendye ntyjehan tꞌahan, jnduehan: —Tsꞌan na tsixuan jnan, tyiꞌjeꞌquindëë ntsꞌaa juu ncüii tsꞌian tꞌman chaꞌna tui ndöꞌ. Ndoꞌ na nndaꞌ jnanꞌtiuhan, tyiꞌcüijon jñꞌoon na jnanꞌneinhan. ");
INSERT INTO azgNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ndoꞌ taxeeꞌ nndaꞌhan nnon juu tsanꞌñeen na tomꞌaan na nchjaanꞌ, jnduehan: —Ndoꞌ ꞌuꞌ jeꞌ, ¿Nin ꞌnan matsuꞌ ntyja ꞌnaanꞌ na ya mandyiaꞌ na sꞌaa juu? Tꞌa tsanꞌñeen: —Condui jon tsꞌan na incyaa jñꞌoonꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Majoꞌ joo nanꞌñeen na conintque ndëë jaa nnꞌan judíos, mancüiixjen tyiꞌninꞌcantyja nꞌonhan na tomꞌaan tsanꞌñeen na nchjaanꞌ juu, ndoꞌ naneinhin jndë ntjo ya ndyiaaꞌ juu. Ngꞌe joꞌ tqueenꞌhan nnꞌan na ndahin. ");
INSERT INTO azgNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ndoꞌ taxeeꞌhan ndëë nanꞌñeen, jnduehan: —Tsanvaꞌ, ¿Aa ndahoꞌhin? Nin jñꞌoon conduehoꞌ, ¿Aa mayuuꞌ na tuihin na nchjaanꞌ juu? Xe na aa mayuuꞌ na nndaꞌ, nchu tui na ya ndyiaaꞌ juu? ");
INSERT INTO azgNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ndoꞌ nque nanꞌñeen na ndahin, tꞌahan, jnduehan: —Mangiö́ na ndahin ndoꞌ mantyi mangiö́ na tuihin na nchjaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Majoꞌ ntyja ꞌnaanꞌ na nchu vaa ꞌnan tui na ya ndyiaaꞌ juu, joꞌ tyiꞌquindiö́. Ndoꞌ min tyiꞌquindiö́ nin tsꞌan sꞌaa na ya ndyiaaꞌ juu. Majoꞌ jndë tueeꞌ ndyuuꞌ juu, ngꞌe joꞌ quitaxeeꞌ nquehoꞌ nnon juu nchu vaa ꞌnan tui. Nquii juu ngitso. ");
INSERT INTO azgNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nndaꞌ vaa jñꞌoon na jnanꞌntcüeꞌ nanꞌñeen ngꞌe ncyaahan ntyjehan nnꞌan judíos na conintque ndëëhan. Ee nanꞌñeen jndë jnanꞌjonhan jñꞌoon yo ntyjehan xe na aa minꞌcya ro tsꞌan na ncüjiꞌ jndyoyu na juu Jesús conduihin nquii Mesías, tyiꞌjeꞌncyahan na ngacantyichen na ntsijon tsanꞌñeen xjen na covancüihan vatsꞌon na nnanꞌtꞌmaanꞌhan Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ndoꞌ na nndaꞌ vaa, joꞌ na jndue nnꞌan na ndahin: “Jndë tueeꞌ ndyuuꞌ juu. Quitaxeeꞌ nquehoꞌ nnon juu nchu vaa ꞌnan na tui.” ");
INSERT INTO azgNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ndoꞌ juu tsanꞌñeen na tomꞌaan na nchjaanꞌ, tqueenꞌ nndaꞌ nnꞌan fariseoꞌñeenhin. Jnduehan nnon juu: —Quitsaꞌ na njon nquii Tyoꞌtsꞌon. Já mangiö́ na juu tsansꞌavaꞌ itsixuan juu jnan. ");
INSERT INTO azgNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Joꞌ tꞌa juu, itso juu: —Aa ja tyiꞌquintji na aa condui tsanvaꞌ tsꞌan jnan. Ninncüii vaa na mavaaꞌ tsꞌön, min na tomꞌan na nchjan, majoꞌ nein xuee mantyꞌia. ");
INSERT INTO azgNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ndoꞌ taxeeꞌ nndaꞌhan nnon juu, jnduehan: —¿Nin ꞌnan sꞌaa juu ꞌuꞌ? ¿Nchu vaa sꞌaa juu na ya mandyiaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Yajoꞌ tꞌa tsanꞌñeen, itso juu: —Majndë tsjö ndëëhoꞌ, majoꞌ tyiꞌninꞌquindyehoꞌ. Ndoꞌ nanein, ¿Nchu vaa na ninꞌquindye nndaꞌhoꞌ? ¿Aa mantyi ꞌoꞌ ninꞌquitsayꞌonhoꞌ yo jñꞌoon na incyaa jon? ");
INSERT INTO azgNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yajoꞌ taꞌhan na jnanꞌcüejnaanꞌhan juu, jnduehan: —ꞌUꞌ condui ꞌuꞌ tsꞌan na vayꞌoon yo jñꞌoon na incyaa tsanvaꞌ, majoꞌ já cotsayꞌö́n yo jñꞌoon na toninncyaa Moisés, ");
INSERT INTO azgNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Já mangiö́ na sinin Tyoꞌtsꞌon yo Moisés, majoꞌ juu tsanvaꞌ, min tyiꞌquindiö́ yuuto jnan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ndoꞌ tꞌa tsanꞌñeen, itso juu ndëëhan: —Caveeꞌ jndyi ntyji na nndaꞌ na ꞌoꞌ min tyiꞌquindiohoꞌ yuu jon jnan jon, ndoꞌ ja, jndë tyincyaa jon na ya mantyꞌia. ");
INSERT INTO azgNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ndoꞌ tsoñꞌen jaa mangiö na nque nnꞌan na tyia ꞌnan contꞌa, tyiꞌjeꞌquindyii Tyoꞌtsꞌon jñꞌoon jndyuehan. Majoꞌ minꞌcya ro tsꞌan na itsitꞌmaanꞌ juu jon ndoꞌ itsꞌaa juu ꞌnan na ntꞌue tsꞌon jon, ndyii jon jñꞌoon ꞌndyo tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ntyjantyi xjen na tui tsonnangue, minjon tacondye nnꞌan na aa nintomꞌaan ncüii tsꞌan na sꞌaa jon na ya ndyiaaꞌ ncüii tsꞌan na tuihin na nchjaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Juu tsansꞌavaꞌ xe na aa tyiꞌcꞌoon Tyoꞌtsꞌon yohin, taꞌnan ꞌnan nndëë ntsꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Majoꞌ tꞌa nanꞌñeen ꞌndyo juu, jnduehan: —ꞌUꞌ ntyjantyi xjen na tui ꞌuꞌ, matsixuanꞌ jnan. Ndoꞌ ¿Aa matsichonꞌ na ntsiꞌmanꞌ ndë́? Jndë na tso juu na nndaꞌ, yajoꞌ tavityincyahan na vintyja ntsijonchenhin yohan xjen na covancüihan vatsꞌon ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jndyii Jesús na tjiꞌhan tsanꞌñeen quiiꞌ ntꞌanhan. Xjen na tjon nndaꞌ jonhin, tso jon nnon juu: —¿Aa vantyja tsonꞌ jnda Tyoꞌtsꞌon? ");
INSERT INTO azgNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tꞌa juu: —Nndaꞌ ta, quitsuꞌ nnön nin tsꞌanhin chaꞌ ngantyja tsꞌönhin. ");
INSERT INTO azgNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Itso Jesús nnon juu: —Majndë jndyiaꞌhin. Mancö na matsinën nnonꞌ condui ja nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ndoꞌ tëcoꞌxtye juu na tonnon jon na itsitꞌmaanꞌ juuhin, itso juu: —ꞌUꞌ ta, mavantyja tsꞌön ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ndë joꞌ, tsontyichen Jesús nnon tsanꞌñeen: —Ja jndyö tsonnangue na ntcoꞌxën nnꞌan ntyja ꞌnaanꞌ jnanhan. Ngꞌe na nndaꞌ, joo nnꞌan na conanꞌtiu na chaꞌvijon na cojntyꞌia nchu vaa ntyja ꞌnaanꞌ Tyoꞌtsꞌon, ja ntsꞌaa na nꞌndyiihanꞌ joohan na itsijonhanꞌhin chaꞌvijon tsꞌan nchjaanꞌ. Majoꞌ nque nnꞌan na cotjiꞌhan cüenta na nanꞌxuanhan na nchjanhan na tonnon jon, ninncya na ncüaaꞌ ya nꞌonhan ntyja ꞌnaanꞌ jon. Itsijonhanꞌ ntyja ꞌnaanhan na conduihan chaꞌvijon tsꞌan na xuee indyiaaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ndyo joꞌ ventyjeeꞌ vendye nnꞌan tmaanꞌ fariseos, jndyehan na nndaꞌ vaa itso Jesús. Ya joꞌ taxeeꞌhan nnon jon: —¿Aa mantyi condui já nnꞌan nchján? ");
INSERT INTO azgNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tꞌa Jesús, itso jon ndëëhan: —Xe na aa conduihoꞌ chaꞌvijon nnꞌan na tyiꞌngüicüaaꞌ nꞌon ntyja ꞌnaanꞌ Tyoꞌtsꞌon, yajoꞌ tavijnan nanꞌxuanhoꞌ. Majoꞌ ngꞌe na conduehoꞌ na conduihoꞌ nnꞌan na covaaꞌ ya nꞌon ntyja ꞌnaanꞌ jon, tsojnaanꞌ joꞌ nanꞌxuanhoꞌ na chohoꞌ jnanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tsꞌan na tyiꞌvaqueeꞌ ꞌndyotsëꞌ teon yuu jon na tooꞌ quinman, veꞌ ncüiichen joo iva juu teonꞌñeen na ngüantyqueꞌ juuhanꞌ, conduihin tsanchꞌuee yo tsan ichꞌuee tyincyo. ");
INSERT INTO azgNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Majoꞌ juu tsꞌan na vantyjeeꞌ quinmanꞌñeen, vaqueeꞌ jon ꞌndyotsëꞌ teon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ndoꞌ tsan na iquen cüenta ꞌndyo juu teonꞌñeen, itsiquinaan jon na ngüenon nquii tsan na vantyjeeꞌ joo choꞌñeen. Ndoꞌ choꞌñeen condye oꞌ jndyeeꞌ jon, icüjiꞌ jon nguee oꞌ na vachu jon joo oꞌ na ntcüaꞌ oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ndoꞌ vi na jndë tjiꞌ jon tsoñꞌen quinmanꞌñeen quiiꞌ teonꞌñeen, yajoꞌ ivejndyee jon tondëë oꞌ. Ndoꞌ cotsantyja oꞌ toxenꞌ jon ngꞌe cotaꞌjnꞌaan oꞌ jndyeeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Majoꞌ juu tsꞌan na chito conduihin tyꞌoo oꞌ na tyiꞌquitaꞌjnꞌaan oꞌ jndyeeꞌ, xeꞌquitsantyja oꞌ toxenꞌ juu, veꞌ nnanꞌnon oꞌhin. Ee tyiꞌquitaꞌjnꞌaan oꞌ jndyeeꞌ ncüiichen tsꞌan na chito tyꞌoo oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Juu jñꞌoonꞌñeen na tyiꞌquitsinin nquiiꞌ Jesús juuhanꞌ ndëëhan, majoꞌ tataaꞌ nꞌonhan nin jñꞌoon ninꞌquitsiquindyihanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ndoꞌ sinin nndaꞌ Jesús ndëë nanꞌñeen. Itso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ na ja condui juu ꞌndyotsëꞌ teon na cotsaqueꞌ quinman. ");
INSERT INTO azgNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tsoñꞌen nnꞌan na jndë jndyoquindue na conduihan na ntaꞌntyjeeꞌhan quinman vitjachen na ndyö, conduihan nanntyꞌuee ndoꞌ nnꞌan na contyꞌuee tyincyo. Majoꞌ joo quinman, choꞌ na mayuuꞌ condui oꞌ cüenta ja, tyíꞌquinanꞌjñꞌoonꞌhan jñꞌoon na condue nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja condui ꞌndyotsëꞌ teon. Minꞌcya ro tsꞌan na ngaqueeꞌ ntyja njan, ntsinꞌman ja ñuaanꞌ tsanꞌñeen. Itsijonhanꞌ tsanꞌñeen chaꞌvijon ncüii quitsman na quinduiꞌ oꞌ teonꞌñeen na nntjii oꞌ na ntcüaꞌ oꞌ ndoꞌ ndë joꞌ icüjeeꞌ nndaꞌ oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","“Tsanchꞌuee ninnquiiꞌchen icüjeeꞌ juu na nchꞌuee juu ndoꞌ na ntscüje juu ndoꞌ na ntsiꞌndaaꞌ juu. Majoꞌ ja jndyö na ninncya na tyiꞌquintycüii na cotandoꞌ ñuaan nnꞌan, ndoꞌ chaꞌ tyiꞌvacuaa xjen na nanꞌxuanhan juuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ja condui tsan na ya mavantyjëꞌ quinman. Juu tsan na ya ivantyjeeꞌ quinman ntsjuenꞌ, ncyaa juu na cueꞌ juu ntyja ꞌnaan oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Majoꞌ juu tsan na veꞌ conduihin moso na chito tyꞌoo oꞌ juu ee veꞌ na vantyjeeꞌ ya juu oꞌ, ndyiaaꞌ juu na nndyo lobo. Yajoꞌ nꞌndyii juu quinmanꞌñeen, nnannon juu. Ndoꞌ juu loboꞌñeen vantyja oꞌ joo quiooꞌñeen ndoꞌ ntꞌuii oꞌ choꞌñeen ndoꞌ joo choꞌñeen cocya oꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inannon tsanꞌñeen ee veꞌ tsꞌan vantjonhin, taꞌnan itsꞌaahanꞌhin yo ꞌnan na coquenon joo quinmanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Ja condui nquii tsꞌan na ya jndyi mavantyjëꞌ quinman. Vajnꞌan ja quinman ntsjuënꞌ ndoꞌ joo oꞌ cotaꞌjnꞌaan oꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Chaꞌxjen nquii tyëhöꞌ vajnaanꞌ jon ja, mantyi ja mavajnꞌanhin. Ndoꞌ nninncya na nnanꞌcueeꞌ nnꞌan ja ntyja ꞌnaan quinman na condui oꞌ cüenta. ");
INSERT INTO azgNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndoꞌ mantyi mꞌan nnꞌan na conduihan quinman ntsjuënꞌ na tyiꞌcꞌonhan juu tmaanꞌva. Mantyi condui ja na cjöquichöhan, ndoꞌ ndyontyjahan na ncüanhan. Ndoꞌ ntsꞌaahanꞌ na ninncüii tmaanꞌ conduihan ndoꞌ ninncüii tsꞌan na ivantyjeeꞌhan. ");
INSERT INTO azgNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Ngꞌe na nndaꞌ vaa, nquii Tyëhöꞌ tꞌman vaa na venchjii jon ja ee mancya na cüꞌiö cüenta nnꞌan na conduihan quinman ntsjuënꞌ chaꞌ ninncyaa jon na nngüantꞌö xcö. ");
INSERT INTO azgNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tanin juu na nndëë ncüjiꞌ na vantꞌö na chito yo jñꞌoon njan. Mancöntyë mancya na ngenön na nndaꞌ. Ee vaa najndö na condui ja na quitsꞌahanꞌ, ndoꞌ mantyi vaa najndö na condui ja na ncꞌön na ngüantꞌö xcö. Ndöꞌ vaa jñꞌoon na tquen tyëhöꞌ nnön na quitsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jñꞌoonminꞌ sꞌaahanꞌ na tyiꞌquitjonꞌ nndaꞌ na jnanꞌnein nnꞌan judíos ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ee jndye nanꞌñeen jnduehan: —Juu tsanvaꞌ, tsixuan juu yutyia, ndoꞌ jndë titsanꞌ xquen juu. ¿Ndu na cotyiꞌhoꞌ nquenhoꞌ jñꞌoon na itsinin juu? ");
INSERT INTO azgNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Majoꞌ ñꞌen nnꞌan na jnduehan: —Jñꞌoonminꞌ tyiꞌnanꞌxuanhanꞌ jñꞌoon na itsinin tsꞌan na mꞌaan nacje ꞌnaanꞌ yutyia. Ee ncüii tsꞌan na mꞌaan nacje ꞌnaanꞌ yutyia, tyiꞌjeꞌquindëë ntsꞌaa tsanꞌñeen na ndyiaaꞌ tsannchjaanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tueeꞌ nguee tsjoon Jerusalén xjen joo nnꞌan judíos tonanꞌtꞌmaanꞌhan na covañjoonꞌ nꞌonhan juu xjen ya na nque ndochihan tquen xco nndaꞌhan vatsꞌon tꞌman cüentaaꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ndoꞌ xoncüe ngueesuaꞌ xjen tueeꞌ juu ngueeꞌñeen. Mꞌaan Jesús vatsꞌon tꞌman ꞌnaanhan. Ivandyiꞌ jon quiiꞌ ncüii corredor ꞌndyo juu vatsꞌonꞌñeen na xiaꞌntyi nonntꞌeiiꞌhanꞌ min. Juu Salomón tꞌua jon tsꞌian na jndëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ndoꞌ nque nnꞌan na conintque ndëë nnꞌan judíos, xiꞌjndio sacüentyjeeꞌhan ngiaaꞌ Jesús. Taxeeꞌhan nnon jon, jnduehan: —¿Tsaꞌnndaꞌto xuee na mana chuꞌ já na matsiquijñꞌenꞌ já? Xe na aa mayuuꞌ condui ꞌuꞌ Mesías quitsuꞌ jndyoyuꞌ ndë́. ");
INSERT INTO azgNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yajoꞌ itso ta Jesús ndëëhan: —Jndë tsjö ndëëhoꞌ na majuu jon condui ja, majoꞌ mancüiixjen tacovantyja nꞌonhoꞌ ja. Majoo tsꞌian na matsꞌa yo najndei na tsixuan nquii Tyëhöꞌ, joohanꞌ na cotjiꞌ jndyoyuhanꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Majoꞌ ꞌoꞌ tyiꞌninꞌcantyja nꞌonhoꞌ ja ngꞌe chito conduihoꞌ tmaanꞌ quinman ntsjuënꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nque nnꞌan na condui quinman ntsjuënꞌ, condyehan jndyëë, ndoꞌ mavajnꞌanhin, ndoꞌ condyontyjahan na xꞌën. ");
INSERT INTO azgNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ja mancya na tyiꞌquintycüii na cotandoꞌ ñuaanhan, min tajon ngitsu ñuaanhan. Ndoꞌ minꞌncüii tsꞌan tyiꞌjeꞌquindëë ncüjiꞌhan ntꞌö. ");
INSERT INTO azgNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ee nquii Tyëhöꞌ na tyincyaa jon joohan ntꞌö, tꞌmanntyichen conduihin na tsoñꞌen, ndoꞌ tanin juu na nndëë ncüjiꞌhan ntꞌö nquii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ja yo Tyëhöꞌ ninncüii condui já. ");
INSERT INTO azgNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ndoꞌ joo nnꞌan judíosꞌñeen, vi na jndë jndyehan na nndaꞌ tso Jesús, yajoꞌ jnanꞌncüi nndaꞌhan ntjöꞌ na ntuenꞌhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Joꞌ tso jon ndëëhan: —Cojntyꞌiahoꞌ na matsꞌa jndye nnon tsꞌian njon yo ntyja ꞌnaanꞌ juu najndei na itsixuan Tyëhöꞌ. ¿Nin ncüii joo tsꞌianꞌñeen na itsꞌaahanꞌ na ninꞌquituenꞌhoꞌ ntjöꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ndoꞌ tꞌa nnꞌan judíosꞌñeen, jnduehan: —Chito ngꞌe ncüii nnon tsꞌian na njon na matsaꞌ, joꞌ na ninꞌquituë́nꞌ ntjöꞌ ꞌuꞌ. Ntꞌá na nndaꞌ ngꞌe na matsininꞌ jñꞌoon tsanꞌ cjooꞌ nquii Tyoꞌtsꞌon. Ee ꞌuꞌ na veꞌ tsꞌan ꞌuꞌ, majoꞌ macüjiꞌ nquii ꞌuꞌ cüenta na condui ꞌuꞌ nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Tꞌa Jesús, itso jon ndëëhan: —Quiiꞌ jñꞌoonꞌ Tyoꞌtsꞌon na jndui na conanꞌyꞌonhoꞌ, mangiohoꞌ juu jñꞌoon na sinin jon, itso jon: “ꞌOꞌ na conintquehoꞌ ndëë nnꞌan, matsjö na itsijonhanꞌ ntyja ꞌnaanhoꞌ chaꞌnan ncö.” Manndaꞌ itsiquindyi jñꞌoonꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ndoꞌ itsontyichen Jesús: —Tso Tyoꞌtsꞌon ndëë nnꞌan na tyꞌon cüenta jñꞌoonꞌ jon na conintquehan quiiꞌ ntꞌan nnꞌan judíos na itsijonhanꞌ ntyja ꞌnaanhan chaꞌna nquii jon. Ndoꞌ mangiö na juu jñꞌoon na tso jon, chito quintuhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ndoꞌ na nndaꞌ, ja na jñon tyëhöꞌ quiiꞌ ntꞌan nnꞌan tsonnangue, ncö na iꞌua jon tsꞌian nnön na ntsinꞌman ñuaan nnꞌan, tyiꞌquichuhanꞌ na conduehoꞌ na majuꞌ jñꞌoon tsanꞌ na cjooꞌ jon xengꞌe tsjö na condui ja jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Joꞌ xe na aa chito tsꞌian ꞌnaanꞌ Tyëhöꞌ matsꞌa, tyiꞌquichuhanꞌ na ngantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Majoꞌ ngꞌe matsꞌa tsꞌian ꞌnaanꞌ jon, min na tyiꞌninꞌcantyja nꞌonhoꞌ ja, joꞌ cantyja nꞌonhoꞌ ntyja ꞌnaan joo tsꞌianꞌñeen, Ee ntyja ꞌnaanhanꞌ ncüaaꞌ nꞌonhoꞌ na nquii Tyëhöꞌ ninncüii conduihin yo ja ndoꞌ ninncüii condui ja yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ndoꞌ nnꞌan judíosꞌñeen, jnanꞌjndaꞌ nndaꞌhan na ntꞌuehan jon, majoꞌ tja jon, taꞌnan jndë jntꞌahan. ");
INSERT INTO azgNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ndoꞌ tetꞌiö́ nntꞌá jndaa Jordán yo Jesús, squë́ naijon na nintomꞌaan jndyee Juan na totsiquindëëꞌ jon nnꞌan. Jndye xuee tomꞌán joꞌ yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndoꞌ juu xjenꞌñeen jndye nnꞌan squenon na mꞌán na ninꞌquindyehan jñꞌoon na toninncyaa jon. Tonduehan ndëë ntyjehan: —Juu Juan taꞌnan sꞌaa jon ncüii nnon tsꞌian na tyiꞌjeꞌquindëë nduihanꞌ ntyja ꞌnaan najndei nquii tsꞌan. Majoꞌ sinin jon ntyja ꞌnaanꞌ tsanvaꞌ, ndoꞌ jñꞌoonꞌñeen covityincyo na mayuuꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ndoꞌ na vijon na mꞌanhin joꞌ, jndye nnꞌan tantyja nꞌonhan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tꞌoon ncüii tsanviiꞌ, tsan na jndyu Lázaro. Mꞌaan jon tsjoon Betania yo María yo xjo jon Marta. ");
INSERT INTO azgNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Majuu Maríaꞌñeen xjo Lazaro, iscongio juu nchenꞌ ngꞌee Jesús ndoꞌ tueꞌ juu ngꞌee jon yo soxquen juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Joꞌ joo nanntcuꞌñeen jnanꞌcüanonhan jñꞌoon na mꞌaan Jesús. Jnduehan: —Nndaꞌ ta, juu tsan na venchjiꞌ jndyiꞌ, mioon jndyi viiꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Xjen na jndyii Jesús jñꞌoonvaꞌ, itso jon ndë́: —Juu tycuvaꞌ chito veꞌ xiaꞌntyi tsꞌian na ntscueeꞌhanꞌhin. Jndaꞌ ndu na nndaꞌ vaa na itjon juu chaꞌ nquii Tyoꞌtsꞌon nditꞌmaanꞌhin ntyja ꞌnaanꞌhanꞌ. Ndoꞌ mantyi chaꞌ ntsitꞌmaanꞌ jon ja na condui ja jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Nquii Jesús, venchjii jndyi jon Marta, mantyi tyje juu yo nquii Lázaroꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Majoꞌ xjen na jndyii Jesús na viiꞌ tsanꞌñeen, ntjontyichenhin ve xuee naijon na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ndë joꞌ itso jon ndë́ já nnꞌan na tꞌman jon na quinanꞌjö́n yohin juu tsꞌian na itsꞌaa jon: —Cüa, ncꞌö nntꞌa ndyuaa Judea. ");
INSERT INTO azgNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Majoꞌ jnduë́ nnon jon: —ꞌUꞌ ta na matsiꞌmanꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon ndë́, tyiꞌcovijndye xuee na nque ntyjë nnꞌan judíos na mꞌan joꞌ jnanꞌchonhan na ntueinꞌhan ntjöꞌ ꞌuꞌ, ndoꞌ ¿Aa joꞌ vjaꞌ nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Sinin Jesús jñꞌoon na itsiꞌmanhanꞌ na tyiꞌcoventyja xjen na nnanꞌcueeꞌ nnꞌanhin. Itso jon: —Ndyiaaꞌ ndoꞌcüjioonꞌ na nchoꞌve horas na ncüii xuee chaꞌ nndëë ntsꞌaa tsꞌan tsꞌian. Ndoꞌ ngꞌe na nndaꞌ, xe na mandyiꞌ tsꞌan naxuee, jeꞌcacüaaꞌ tsjöꞌ ngꞌee juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Majoꞌ xe na aa natsjon mandyiꞌ tsꞌan, ngacüaaꞌhin, ee tyiꞌxuee. ");
INSERT INTO azgNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ndoꞌ vi na jndë tso jon na nndaꞌ ndë́, tsontyichen jon: —Juu tsanntyjëëhë Lázaro, itso jon, majoꞌ jö na ntsintcüihin. ");
INSERT INTO azgNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Yajoꞌ jnduë́ nnon jon: —Nndaꞌ ta, xe na aa veꞌ itso juu, majndaꞌ na ntcoꞌyahanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ndoꞌ yo juu jñꞌoonvaꞌ na sinin Jesús, siꞌman jon na tsꞌoo Lázaro. Majoꞌ já jnanꞌtiú na tso jon na nndaꞌ na mayuuꞌ na itso tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndoꞌ tso jndyoyu jon ndë́: —Juu Lázaro, jndë tueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ndoꞌ ya nchji na tyíꞌcꞌoon ja joꞌ xjen na tueꞌ juu chaꞌ ngantyja nꞌonhoꞌ ja. Cja na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Xjenꞌñeen mꞌaan Tomás. Juu jon ncüii já na nchoꞌve na tꞌman Jesús na quinanꞌjö́n yo jñꞌoon na toninncyaa jon. Conanꞌquijndyuhin Tsanñꞌein. Tso tsanꞌñeen ndë́: —Cüa, ncꞌö yo Jesús chaꞌ na aa nnanꞌcueeꞌ nnꞌanhin, mantyi jaa ncüjë. ");
INSERT INTO azgNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yajoꞌ sá, squë́ Betania. Ndoꞌ nnꞌan na mꞌan joꞌ jnduehan nnon Jesús na jndë ninque xuee na ndyiiꞌ tsoLázaro quityquiiꞌ tsiꞌtsꞌua. ");
INSERT INTO azgNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Juu Betania chaꞌna ndye kilómetros na tycya mꞌaanhanꞌ yo Jerusalén. ");
INSERT INTO azgNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ndoꞌ jndye nnꞌan judíos jndë squenon na mꞌaan Marta yo María na conanꞌnjoonꞌhan nanntcuꞌñeen na chjooꞌ nꞌonhan na tueꞌ Lázaro. ");
INSERT INTO azgNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ndoꞌ juu Marta, vi na jndë jndyii jon na mavaa xjen ntsquë́ yo Jesús, jnduiꞌ juu na jndyoquitjonhin Jesús yuu jon na mꞌán. Majoꞌ María ntjohin vꞌaa. ");
INSERT INTO azgNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ndoꞌ tso Marta nnon Jesús: —Ta, xe na juuhanꞌ aa mꞌanꞌ ntjoohin, jeꞌcueꞌ tyjö. ");
INSERT INTO azgNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Majoꞌ min na jndë tueꞌ juu, ntyji ya na minꞌncya ro jñꞌoon na ntcanꞌ nnon Tyoꞌtsꞌon, ninncyaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Joꞌ tꞌa Jesús, itso jon nnon juu: —Ngüandoꞌ xco tyꞌiuꞌ min na jndë tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ndoꞌ tꞌa Marta, itso juu: —Ntyji na ngüandoꞌ xco tyjö juu xuee na matsꞌiañꞌen ya na ntsintcüi Tyoꞌtsꞌon nnꞌan na jndë tjë. ");
INSERT INTO azgNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ndoꞌ joꞌ tso Jesús nnon juu: —Ncö condui na vandoꞌ xco tsꞌan vi na jndë tueꞌ juu, ndoꞌ mantyi ntyja njan itsixuan tsꞌan na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. Minninchen tsꞌan na vantyja tsꞌon ja, min na cueꞌ juu, mancüiixjen ngüandoꞌ xco juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ndoꞌ ncüii ncüii tsꞌan na vandoꞌ juu ntyja njan ndoꞌ na vantyja tsꞌon juu ja, tyiꞌjon cueeꞌ xuee ngitsu ñuaanꞌ tsanꞌñeen. ¿Aa vantyja tsonꞌ na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ndoꞌ tꞌa juu, itso juu nnon Jesús: —Mayuuꞌ ta, vantyja tsꞌön na condui ꞌuꞌ nquii Mesías jnda Tyoꞌtsꞌon. Maꞌuꞌ na tsixuanꞌ na jndyoꞌ nnon tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ndë joꞌ tja ntcüeꞌ Marta, tëquiꞌman juu tyje juu María. Veꞌ ninmaanꞌ tso juu nnon tsanꞌñeen: —Nquii tahaꞌ na itsiꞌman jñꞌoonꞌ Tyoꞌtsꞌon ndëë, jndë tyjeeꞌ jon ndoꞌ iqueenꞌ jon ꞌuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Xjen na jndyii María na nndaꞌ, sityuaaꞌ juu, taquitjonhin Jesús naijon na mꞌán. ");
INSERT INTO azgNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ee xjenꞌñeen tyíꞌcotsacꞌë́ quiiꞌ tsjoon yo Jesús. Ninmꞌán yohin naijon na taquitjon Marta já. ");
INSERT INTO azgNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndoꞌ nque nnꞌan judíosꞌñeen na conanꞌnjoonꞌhan María na chjooꞌ tsꞌon juu na tueꞌ Lázaro, na jntyꞌiahan na jnanquintyja juu na sityuaaꞌ juu, jnduiꞌ juu quiiꞌ vꞌaa, tentyja nanꞌñeen toxenꞌ juu. Ee jnanꞌtiuhan na vaquitꞌioo juu nnon tsiꞌtsꞌua. ");
INSERT INTO azgNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Vi na jndë na tueeꞌ juu na mꞌán yo Jesús, tëcoꞌxtye juu nnon jon. Itso juu: —ꞌUꞌ ta, xe na juuhanꞌ aa mꞌanꞌ ntjoohin, jeꞌcueꞌ tyjö. ");
INSERT INTO azgNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ndoꞌ ya na jndyiaaꞌ Jesús na itꞌioo jndyi María, ndoꞌ mantyi joo nnꞌan judíos na jndyontyjahan toxenꞌ juu, cotyuee nanꞌñeen, yajoꞌ tꞌman jndyi sichjooꞌhanꞌ tsꞌon jon, ata siꞌndaaꞌhanꞌ ntyjii jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Taxeeꞌ jon ndëëhan: —¿Yuu nquii jon na tyꞌiuhoꞌhin? Jnduehan nnon jon: —Nndaꞌ ta, quindyoquindyiaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ndoꞌ tꞌioo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ndoꞌ nque nnꞌan judíosꞌñeen, ya na jntyꞌiahan na nndaꞌ sꞌaa jon, jnduehan ndëë ntyjehan: —Quitquenhoꞌ cüenta na venchjii jndyi jon juu tsꞌooꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Majoꞌ vendye nnanꞌñeen jnduehan: —Tsansꞌavaꞌ na tyincyaa jon na jndyiaaꞌ tsannchjaanꞌ, ¿Aa chi mantyi vaa najndei na conduihin na tyiꞌngueꞌ Lázaro? ");
INSERT INTO azgNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ncüiichen jon siꞌndaaꞌhanꞌ ntyjii Jesús. Sá yohin naijon na vaa tsëꞌtsjöꞌ na jnanꞌya nnꞌan tsiꞌtsꞌua. Tëꞌ ncüii tsjöꞌ ꞌndyohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ndoꞌ tso Jesús ndëëhan: —Quenaanꞌhoꞌ tsjöꞌvaꞌ. Majoꞌ juu Marta, xjo tsꞌooꞌñeen, tso jon: —Ta, jndë ticꞌeehin ee neinhin jndë nenque xuee na tueꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ndoꞌ tso Jesús nnon juu: —¿Aa chito jndë tsjö nnonꞌ xe na aa ngantyja tsonꞌ Tyoꞌtsꞌon, ndyiaꞌ nnonꞌ na nditꞌmaanꞌhin? ");
INSERT INTO azgNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Joꞌ teꞌndyaaꞌhan juu tsjöꞌ natëꞌ ꞌndyo tsiꞌtsꞌuaꞌñeen. Ndë jndondë jon, sinin jon nnon Tyoꞌtsꞌon, itso jon: —Ncya ya jndyi ꞌUꞌ tyeꞌ na mandyiꞌ jñꞌoon ꞌndyö. ");
INSERT INTO azgNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ee mantyji na ninnquiiꞌchen mandyiꞌ jñꞌoon na matsinën nnonꞌ. Majoꞌ nndaꞌ jñꞌoon tsjö chaꞌ nque nnꞌan na mꞌan xiꞌjndio na mꞌan, ngantyja nꞌonhan na ꞌUꞌ tꞌuaꞌ tsꞌianmin nnön. ");
INSERT INTO azgNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ndoꞌ vi na jndë tso jon na nndaꞌ, sue jon jndyeeꞌ jon, itso jon: —ꞌUꞌ Lázaro, quinduiꞌ joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ndoꞌ juu xjenꞌñeen jnduiꞌ tsoLázaro vetyjo ndiaa na tyiꞌntuein ngꞌee juu yo ntꞌö juu, ndiaaꞌñeen jnanꞌcüetyjo nnꞌanhanꞌhin na tantyꞌiuhin. Mantyi tëꞌ nnon juu yo ncüii ndiaa. Itso Jesús ndëë nanꞌñeen: —Quinanꞌquinanꞌhoꞌ ndiaaminꞌhin chaꞌ ya ncja juu. ");
INSERT INTO azgNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndoꞌ jndye nnꞌan judíosꞌñeen na tyꞌehan yo María, ya na jntyꞌiahan na nndaꞌ sꞌaa Jesús, tëntyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Majoꞌ vendye ntyjehan tyenanꞌquindyiihan nnꞌan tmaanꞌ fariseos. Tonduehan na jntyꞌiahan na nndaꞌ sꞌaa Jesús jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ndoꞌ nque ntyee na conintque, tatjonhan yo fariseos yo vendye ntyjehan na conduihan nanmꞌannꞌian. Jnduehan ndëë ntyjehan: —¿Nchu vaa nquii ntꞌaha? Ee tsanvaꞌ jndë tijndye tsꞌian itsꞌaa juu na tyiꞌjeꞌquinduihanꞌ na veꞌ yo ntyja ꞌnaanꞌ naijndei nquii tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Xe na aa veꞌto nꞌndyëë na quitsꞌaachen jon na nndaꞌ, ya joꞌ tsoñꞌen nnꞌan ngantyja nꞌonhanhin. Ndoꞌ na nndaꞌ, joo nnꞌan romanos nnanꞌtyuiiꞌhan vatsꞌon njan jaa nnꞌan judíos yo ninvaa ntꞌö tsjöönhön. ");
INSERT INTO azgNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Cüii joo nanꞌñeen jndyu jon Caifás. Juu chuꞌñeen juu jon conintquehin ndëë ntyee cüenta jaa nnꞌan judíos. Itso jon ndëë ntyjehin nanꞌñeen: —ꞌOꞌ minꞌchjo tyiꞌjndaꞌ nquenhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Min tyiꞌquitjiꞌhoꞌ cüenta na yantyichen na cueꞌ ncüii tsansꞌa ntyja ꞌnaan tsoñꞌen joo nnꞌan ndyuaa na nanꞌxuan jaa, chaꞌ nquii ta tsanmꞌaantsꞌian tꞌman tyiꞌntscüje jon tsoñꞌen jaa. ");
INSERT INTO azgNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Majoꞌ chito na tso jon jñꞌoonꞌñeen ngꞌe na ivaaꞌ tsꞌon nquii jon. Nndaꞌ tso jon ngꞌe juu chuꞌñeen conduihin tyee na conintque ndëë jaa nnꞌan judíos. Joꞌ na tyincyaa Tyoꞌtsꞌon na tyuaaꞌchen sinin jon ꞌnan na xejnda ngüentyja na nguaahanꞌ na nnanꞌcueeꞌ nnꞌan Jesús. Nguaa na nndaꞌ chaꞌ nquii tsanmꞌaantsꞌian tꞌman, tyiꞌntscüje jon nque ntyjehan nnꞌan na mꞌanhin juu ndyuaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ndoꞌ chito xiaꞌntyi ntyja ꞌnaan nque nnꞌan judíos na ngueꞌ Jesús. Mantyi ngueꞌ jon ntyja ꞌnaan tsoñꞌen nnꞌan na minꞌcya ro joo na mꞌanhan na tꞌman qui nꞌonhan jon, ntsitjon Tyoꞌtsꞌon nanꞌñeen ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ngꞌe na nndaꞌ tso Caifás, majuuntyi xeeꞌñeen jntꞌa nnꞌan judíosꞌñeen jñꞌoon na nnanꞌcueeꞌhan juu Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ngꞌe joꞌ, tavi tondyiꞌ tyincyo Jesús quiiꞌ ntꞌan nnꞌan judíos. Joꞌ jntꞌuí ndyuaa Judea yohin, sá ncüii tsjoon chjo na jndyu Efraín. Juu tsjoonꞌñeen ndyo mꞌaanhanꞌ ndyuaa naijon na tyiꞌjndye nnꞌan mꞌan. Joꞌ tomꞌán yohin cüanntyi ro xuee. ");
INSERT INTO azgNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xjenꞌñeen vavindyo na ngueeꞌ nguee pascua na jaa nnꞌan judíos conanꞌcüjë quinman na conanꞌtꞌmaanꞌ Tyoꞌtsꞌon. Vitjachen na ngueeꞌ juu ngueeꞌñeen, jndye nanꞌñeen jnduiꞌhan njoonhan, tyꞌehan Jerusalén chaꞌ ndëë nnanꞌquindëhan tsoñꞌen na ican jñꞌoon na tquen Moisés, na ntyja ꞌnaanꞌ joꞌ ntquenhanꞌhin na jiꞌua conduihan tonnon Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Joo nanꞌñeen tojntꞌuehan Jesús. Ndoꞌ viochen xjen na tomꞌanhan vatsꞌon tꞌman, tonduehan ndëë ntyjehan: —¿Nchu vaa mꞌaanꞌ nꞌonhoꞌ, aa ntsꞌaahanꞌ na tyiꞌxeꞌquindyo jon nguee? ");
INSERT INTO azgNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ndoꞌ joo ntyee na conintque ndëë jaa nnꞌan judíos yo ninꞌnnꞌan tmaanꞌ fariseos, tquenhan jñꞌoon naijndeiꞌhanꞌ. Jnduehan minꞌcya ro tsꞌan na aa ntyjii yujon mꞌaan Jesús, quitsiquindyii tsanꞌñeenhan, chaꞌ nndëë ncueeꞌ ndueehan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yon xuee vitja na ngueeꞌ nguee pascua ya na jaa nnꞌan judíos conanꞌcüjë quinman na conanꞌtꞌmaanꞌ Tyoꞌtsꞌon, juu xjenꞌñeen squë́ tsjoon Betania yo Jesús. Squë́ vaaꞌ Lázaro, juu tsan na tyincyaa jon na vandoꞌ xco. ");
INSERT INTO azgNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ndoꞌ jnanꞌtꞌmaanꞌ nanꞌñeen Jesús, jnanꞌjndaꞌhan na tcüꞌá. Juu Marta tyentjon juu ndë́ ndoꞌ mantyi tacüetyen nquii Lázaroꞌñeen yo já na tendyuá mesa yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Juu Maríaꞌñeen na yꞌoon juu xoncüe litro nchenꞌ ninnquiiꞌchen nardo jnda jndyi njonhanꞌ. Scongio juu nchenꞌñeen ngꞌee Jesús, ndë joꞌ toveeꞌ juu ngꞌee jon yo soxquen juu. Ndoꞌ na sꞌaa juu na nndaꞌ, ninvaa quiiꞌ vꞌaaꞌñeen tycya jndye quichi. ");
INSERT INTO azgNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Juu xjenꞌñeen juu Judas Iscariote, jnda Simón, mꞌaan juu joꞌ, juu juu na jndë tindyoviꞌ na nninncyaa juu cüenta Jesús. Condui tsanꞌñeen ncüii já na tqueenꞌ Jesús na quinanꞌjö́n yo jñꞌoon na toninncyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Tyiꞌcuaa ya ntyjii juu ndu na sꞌaa María na nndaꞌ, itso juu: —Cüa chito tijntꞌua nchenꞌvaꞌ na ncüii ndye ciento sꞌon denarios. Juu sꞌonꞌñeen nndëë ntejndeihanꞌ nanninñenꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Majoꞌ chito tso juu na nndaꞌ ngꞌe na venchjii juu joo nanninñenꞌ. Tso juu na nndaꞌ ngꞌe tsanchꞌueehin, ee juu tonayꞌoon tjanche na toquiñjon sꞌon na toninjntꞌue tsoñꞌen já, ndoꞌ tocoꞌxen nquiihin na tocüjiꞌ juu sꞌon na ñjonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ndoꞌ na nndaꞌ tso juu, joꞌ tꞌa Jesús, tso jon: —Quiꞌndyiꞌ tsanscuvaꞌ na itsꞌaa juu na nndaꞌ. Ee itsijndaꞌ juu ntyja ꞌnaanꞌ xuee na ntsaquityꞌiu nnꞌan ja. ");
INSERT INTO azgNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ee nanninñenꞌ tsoñꞌen xuee mꞌanhan quiiꞌ ntꞌanhoꞌ. Majoꞌ ja chito ninnquiiꞌchen nndaꞌ na ncꞌön yo ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ticꞌuaa jñꞌoon na mꞌaan Jesús Betania yo já, ngꞌe joꞌ, jndye nnꞌan squenonhan na mꞌán. Majoꞌ chito xiaaꞌntyi na ninꞌquijntyꞌiahan Jesús, mantyi ninꞌquijntyꞌiahan juu Lázaroꞌñeen, tsꞌan na tueꞌ na tyincyaa Jesús na tandoꞌ xco. ");
INSERT INTO azgNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ngꞌe na nndaꞌ vaa, nque ntyee na conintque ndëë jaa nnꞌan judíos, jnanꞌjndaꞌhan na mantyi nnanꞌcueeꞌhan Lázaro. ");
INSERT INTO azgNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ee ntyja ꞌnaanꞌ jon jndye ntyjehan nnꞌan judíos tjihan ntyja ꞌnaan ntyee, tëntyja nꞌonhan Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tonco ncüiichen xuee, nnꞌan na jndye jndyiꞌhin jndyehan na mandyo ntsquë́ Jerusalén yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Yajoꞌ tyechohan njon ntsquii nnontëncyꞌa, tyequitjonhan juu jon. Tonanꞌxuaahan, tonduehan: —Cüitꞌmaanꞌ nquii Tyoꞌtsꞌon. Quityio jon jnꞌaan nquii tsan na ndyo yo xueeꞌ nquii jon na taquintyja jon tꞌman tsꞌan conduihin na coꞌxen jon jaa nnꞌan Israel. Nndaꞌ ro jñꞌoon tonanꞌxuaa nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ndoꞌ tijndaꞌ ncüii snon na tantjo Jesús. Na sꞌaa jon na nndaꞌ, siquindëhanꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui tivio. ");
INSERT INTO azgNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Itsohanꞌ: ꞌOꞌ nnꞌan Jerusalén, tyiꞌndyuehoꞌ. Quitquenhoꞌ cüenta, indyo nquii jon na taquintyja juu jon tꞌman tsꞌan conduihin na coꞌxen jon ꞌoꞌ na ntjo jon snon chjo. ");
INSERT INTO azgNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Majoꞌ já nnꞌan na tqueenꞌ Jesús na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, tataaꞌ nꞌö́n jñꞌoonminꞌ na vejndyee. Majoꞌ vi na jndë sitꞌmaanꞌ Tyoꞌtsꞌonhin, yajoꞌ tëñjoonꞌ nꞌö́n na nndaꞌ vaa jñꞌoon na jndui ntyja ꞌnaanꞌ jon, ndoꞌ tui chaꞌxjen juu jñꞌoonꞌñeen na jndui. ");
INSERT INTO azgNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mꞌan ncüii tmaanꞌ nnꞌan judíos xjen na tꞌman Jesús Lázaro na toquindyiiꞌ jon quiiꞌ tsiꞌtsꞌua. Ndoꞌ joo nanꞌñeen, vi na jndë tyincyaa jon na vandoꞌ xco Lázaro, yajoꞌ totjiꞌ jndyoyuhan ntyja ꞌnaanꞌ na nndaꞌ vaa na jntyꞌia ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Mangꞌe juu tsꞌianꞌñeen na sꞌaa Jesús na tyiꞌjeꞌquindëë nduihanꞌ na veꞌ najndei nquii tsꞌan, joꞌ na tyequitjon nanꞌñeen jon na jndë jndyehan na nndaꞌ sꞌaa jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ndoꞌ na nndaꞌ, joꞌ jndue fariseosꞌñeen ndëë ntyjehan: —¿Aa cotquenhoꞌ cüenta jeꞌ? Tajeꞌquindëë nntꞌaha. Tsoñꞌen nnꞌan conanjonhan ntyja ꞌnaanꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Quiiꞌ ntꞌan nnꞌan na tyꞌe nguee xjen na conanꞌcüje nnꞌan judíos quinman, tomꞌan vendye nnꞌan na conanꞌnein jñꞌoon griego. ");
INSERT INTO azgNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Squenon nanꞌñeen na mꞌaan Felipe, juu jon tsꞌan tsjoon Betsaida, ndyuaa Galilea. Tanhan vi nayaꞌñeen nnon jon, jnduehan: —Nndaꞌ ta, ntꞌue nꞌö́n na nnanꞌnë́n yo nquii Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ndoꞌ tëquitso Felipe juu jñꞌoonꞌñeen nnon Andrés, jndë joꞌ vehan tyequinduehan nnon Jesús na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ndoꞌ tꞌa Jesús jndyuehan, itso jon: —Ja na condui tsansꞌa na jñon Tyoꞌtsꞌon quiiꞌ ntꞌanhoꞌ, naneinhin jndë tentyja xjen na ngenön naviꞌ tꞌman na ntyja ꞌnaanꞌhanꞌ ntsitꞌmaanꞌ Tyoꞌtsꞌon ja. ");
INSERT INTO azgNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, ncüii ntquen tsjaan, icanhanꞌ na nnonꞌ tsꞌanhanꞌ nnon tyuaa. Na ntsꞌaa juu na nndaꞌ, itsijonhanꞌ juuhanꞌ chaꞌvijon na jndë tueꞌhanꞌ. Ee xe na tyiꞌndui na nndaꞌ, contjohanꞌ na ninjoꞌ ninncüiihanꞌ. Majoꞌ vi na jndë jnonꞌ tsꞌanhanꞌ, jndye ntquen ngueꞌ ntsꞌaahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Minninchen tsꞌan na veꞌnchjii nquiihin yo na ntsijndaꞌ nquii juu na ngüandoꞌ ñuaanꞌ juu, jnaanꞌ joꞌ ngitsuhin. Majoꞌ minꞌcya ro tsꞌan na tyiꞌnjon ntyjii juu nchu vaa na vamꞌaan juu, nndaaꞌ juu na tyiꞌjon quintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Xe na aa mꞌaan ncüii tsꞌan na ninꞌquityentjon nnön, quitsue juu jñꞌoon na mancya. Ee na ntsꞌaa juu na nndaꞌ, ncꞌoon juu naijon na mꞌan ja. Ndoꞌ nquii Tyëhöꞌ ntsiquinjon jon juu tsanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Nein itsiꞌndaaꞌhanꞌ ntyji na ngenön naviꞌ, ndoꞌ ¿Nchu vaa ntsjö ntyja ꞌnaanꞌhanꞌ? ¿Aa ntsjö: “Tyeꞌ, cüjiꞌ ja juu xjen na ngenön naviꞌvahin”? Majoꞌ xeꞌquitsjö na nndaꞌ ee majuu tsꞌian na jndyö na ncüꞌiö cüenta nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ꞌUꞌ tyeꞌ, ncyaꞌ na nditꞌmaanꞌ ꞌUꞌ ntyja njan. Juu xjenꞌñeen ticꞌuaa jndyeeꞌ tye jon quiñoonꞌndue. Tꞌa jon: —Jndë tyincya na covitꞌmaanꞌ ja, ndoꞌ nditꞌmaanꞌntyichen ja. ");
INSERT INTO azgNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ndoꞌ nque nnꞌan na ventyjeeꞌ ncꞌiá, jndyehan na nndaꞌ. Joꞌ jnduehan ndëë ntyjehan na coꞌman ntsuee. Majoꞌ vendye ntyjehan jnduehan: —Ncüii ángel sinin nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Majoꞌ tꞌa Jesús jndyuehan, itso jon: —Ticꞌuaa na jndyehoꞌ na sinin jon chaꞌ quitejndeihanꞌ ꞌoꞌ, chito chaꞌ ntejndeihanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nein covijndaꞌ jnan na nanꞌxuan nnꞌan tsonnangue. Nanein ndyuiiꞌ ntyja na tsixuan juu yutyia na icoꞌxen juu quiiꞌ nꞌon nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ndoꞌ vi na jndë jnanꞌve nnꞌan ja nnon tsonjnꞌaan na nnanꞌcueeꞌhanꞌ ja, yajoꞌ joo nnꞌan na ninvaa tsonnangue ndyontyjahan ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jñꞌoonvaꞌ itso jon chaꞌ quitsiꞌmanhanꞌ nchu vaa na ngenon jon na ngueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Majoꞌ tꞌa nanꞌñeen, jnduehan: —Majndë jndyë́ na juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui itsiquindyihanꞌ na nquii Cristo tyiꞌjeꞌquintycüii na ncꞌoon jon. Ndoꞌ na nndaꞌ, ¿Ndu na matsuꞌ na nquii jon na conduihin tsansꞌa na jñon Tyoꞌtsꞌonhin quiiꞌ ntꞌan nnꞌan, nnanꞌvehanhin na nnanꞌcueeꞌhan jon? ¿Nin juu na nndaꞌ na matsuꞌ na conduihin tsansꞌa na jñon Tyoꞌtsꞌon quiiꞌ ntꞌan nnꞌan? ");
INSERT INTO azgNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ndoꞌ tꞌa Jesús jndyuehan, itso jon: —Ja na condui naxuee quiiꞌ ntꞌan nnꞌan, chjo ro xjen na vi mꞌan quiiꞌ ntꞌanhoꞌ. Ngꞌe joꞌ ninnquiiꞌchen cꞌonhoꞌ ntyja njan viochen xjen na mꞌanntyëchën yo ꞌoꞌ, chaꞌ juu na condui natyia tyiꞌncjuꞌ cjehanꞌ ꞌoꞌ. Ee tsꞌan na mꞌaan nacje ꞌnaanꞌ natyia, tyiꞌquintjii juu yuu jon vjayꞌoonhanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Majoꞌ ja na condui naxuee, viochen xjen na mꞌan quiiꞌ ntꞌanhoꞌ, cantyja nꞌonhoꞌ na condui ja nquii naxueeꞌñeen. Xe na aa nntꞌahoꞌ na nndaꞌ, nnanꞌxuanhoꞌ ntyja ꞌnaanꞌ Tyoꞌtsꞌon na nquii jon conduihin naxuee. Ndoꞌ vi na jndë sinin Jesús jñꞌoonminꞌ, tja jon ncüii joo naijon ntyꞌiuuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ee min na jndye nnon tsꞌian totsꞌaa Jesús tondëëhan na tyiꞌjeꞌquinduihanꞌ yo najndei nquii tsꞌan, mancüiixjen tyiꞌninꞌcantyja nꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Nndaꞌ tui chaꞌ quitsiquindëhanꞌ jñꞌoon na toninncyaa juu Isaías, tsan na totsinin nchu vaa ꞌnan na nguaa. Tso jon: Ta, ¿Nin juu na vantyja tsꞌon jñꞌoon na conincyá? Ndoꞌ juu Isaíasꞌñeen tsontyichen jon ncüiichen jñꞌoon: ¿Nin juu na jndë siꞌman Tyoꞌtsꞌon nnon ntyja najndei na condui nquii jon? ");
INSERT INTO azgNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Siꞌman Isaíasꞌñeen nchu vaa na ndiquindëë na ngantyja nꞌon nnꞌan judíos Tyoꞌtsꞌon, ee vaa ncüiichen jñꞌoon na tso tsanꞌñeen: ");
INSERT INTO azgNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Chaꞌxjen tsꞌan na nchjaanꞌ, ndiquindyiaaꞌ juu, manndaꞌ sꞌaa Tyoꞌtsꞌon quiiꞌ nꞌon nnꞌan, ndoꞌ tyincyaa jon na jnanꞌqueꞌ nꞌonhan tonnon jon. Nanꞌminꞌ tui chaꞌ tyiꞌjeꞌquitquenhan cüenta nchu vaa na ntꞌue tsꞌon jon yohan min na jeꞌcüaaꞌ nꞌonhan yo ntyja ꞌnaanꞌ tsꞌian na itsꞌaa jon. Ndoꞌ tsontyichen Tyoꞌtsꞌon nnon Isaíasꞌñeen: Ee xe na aa ntquenhan cüenta nchu vaa ntꞌue tsꞌön yohan ndoꞌ ncüaaꞌ nꞌonhan juuhanꞌ, ndoꞌ ngꞌe na nndaꞌ ntcüeꞌ nꞌonhan jnanhan, ndoꞌ ngꞌe joꞌ ntsinꞌman ja ñuaanhan. Ndöꞌ vaa jñꞌoon na tso Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Sinin Isaíasꞌñeen ntyja ꞌnaanꞌ nquii Jesús ya sinin jon jñꞌoonvaꞌ xjen na tityincyooꞌ nnon jon na titꞌmaanꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Majoꞌ min na nndaꞌ tso Isaíasꞌñeen, jndye nnꞌan na mꞌan nꞌian quiiꞌ ntꞌan nnꞌan judíos, tëntyja nꞌonhan Jesús. Majoꞌ jnaanꞌ na ncyaahan nnꞌan tmaanꞌ fariseos, joꞌ tyiꞌquitjiꞌ jndyoyuhan na nndaꞌ. Ee xe na aa ntjiꞌ jndyoyuhan ntyja ꞌnaanꞌ jon, nque fariseosꞌñeen tyiꞌjeꞌncyahan na vanaan na nnanꞌjon nanꞌñeen xjen na covancüihan vatsꞌon na conanꞌtꞌmaanꞌ nnꞌan Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ee joo nanmꞌannꞌianꞌñeen, neinntyichenhan na quindue ntyjehan na ya jndyi contꞌahan, chichen na ntyja nꞌonhan na juu Tyoꞌtsꞌon ngitso na ya ntyjii jon yohan. ");
INSERT INTO azgNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yajoꞌ jndei ticꞌuaa ꞌndyo Jesús. Tso jon: —Minninchen tsꞌan na vantyja tsꞌon ja, tsanꞌñeen chito xiaꞌntyi ja vantyja tsꞌon juu. Mantyi vantyja tsꞌon juu nquii Tyëhöꞌ na jñon jon ja. ");
INSERT INTO azgNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ndoꞌ minninchen tsꞌan na jndë jndyiaaꞌ juu ja, mantyi jndë jndyiaaꞌ juu nquii jon na jñon ja quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ja na condui naxuee jndë jndyö tsonnangue na mancya naxuee quiiꞌ ñuaan nnꞌan, chaꞌ minninchen tsꞌan na vantyja tsꞌon ja, ncüjiꞌhanꞌhin ntyja ꞌnaanꞌ natyia. ");
INSERT INTO azgNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Majoꞌ minꞌcya ro tsꞌan na nndyii jñꞌoon na mancya, min tyiꞌquitsiquindë juuhanꞌ, chito ja tsixuan na ntcoꞌxën tsanꞌñeen ꞌnan na itsitjahin. Ee chito tꞌion Tyëhöꞌ tsꞌian ja na ntcoꞌxën nnꞌan yo ꞌnan na conanꞌtjahin. Tꞌion jon tsꞌian ja na quitsinꞌman ñuaan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Juu tsan na tyiꞌcueeꞌ tsꞌon ja ndoꞌ min tyiꞌcyꞌoon juu cüenta jñꞌoon na mancya, vaa ncüii na ntcoꞌxenhanꞌhin. Juu xuee na matsꞌiañꞌen, manquentyi jñꞌoon na jndë sinën, joohanꞌ ngitoꞌxenhanꞌ tsanꞌñeen ntyja ꞌnaanꞌ na jndë sitjahin. ");
INSERT INTO azgNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tyiꞌnanꞌtiuhoꞌ na veꞌ na jndeiꞌ nquii ꞌndyö na matsinën jñꞌoonminꞌ. Ee nquii Tyëhöꞌ na jñon ja quiiꞌ ntꞌan nnꞌan, nquii jon tꞌion tsꞌian ja na quitsinënhanꞌ, ndoꞌ na quitsiꞌmanhanꞌ ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ndoꞌ juu jñꞌoon na tquen jon, mavaaꞌ tsꞌön na incyaahanꞌ na tsixuan tsꞌan na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. Ngꞌe joꞌ ninnquiiꞌchen matsinën chaꞌxjen joo jñꞌoon na ndë siꞌman jon nnön.” ");
INSERT INTO azgNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ntyjantyi xjen na tyeꞌ na tqueenꞌ Jesús já nnꞌan na quitsayꞌö́n yo jñꞌoon na toninncyaa jon, siꞌman jon na venchjii jndyi jon já. Ntyjii jon na jndë vaventyja xjen na nnduiꞌ jon nnon tsonnangue na ncja ntcüeꞌ jon na mꞌaan tye jon. Joꞌ xjen na vavindyo na ngityeꞌ nguee pascua ya na conanꞌcüjë́ quinman na conanꞌtꞌmánꞌ Tyoꞌtsꞌon, siꞌmanntyichen jon na tꞌman jndyi vaa na venchjii jon já. ");
INSERT INTO azgNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Tcüꞌá yo Jesús cüenta matman. Juu xjenꞌñeen jndë sꞌaa yutyia quiiꞌ tsꞌon juu ntyjë́ Judas Iscariote, jnda Simón, na ncyaa juu cüenta Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Majndaꞌ ntyjii jon na nquii tye jon jndë tyincyaa jon na minꞌncüii ꞌnan tyiꞌngenon jon na chito jñꞌoonꞌ jon. Ntyjii Jesús na jnan jon na mꞌaan Tyoꞌtsꞌon ndoꞌ majoꞌ vja ntcüeꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Juu tmanꞌñeen, viochen xjen na tcüꞌá, jnanquintyja Jesús, tjiꞌ jon ndiaatco na cüe jon. Sityen jon tsiaaꞌ jon yo ncüii ndiaa na cotꞌuë́ nduë́. ");
INSERT INTO azgNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ndë joꞌ tyion jon ndaatioo quiiꞌ ꞌnan na cotmán nduë́. Taꞌ jon na iman jon ngꞌë́, ndë iveꞌ jon ngꞌë́ yo ndiaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Majoꞌ ya na tueeꞌ jon nnon Simón Pedro, itso juu nnon jon: —Ta, ¿Aa ja mmanꞌ ngꞌë? ");
INSERT INTO azgNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tꞌa Jesús, itso jon: —Ndicüaaꞌ tsonꞌ tsꞌian na matsꞌa naneinhin, majoꞌ ya ndëcya ncüaaꞌ tsonꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Majoꞌ itso Pedro: —Tyiꞌxeꞌncya na mmanꞌ ngꞌë. Tꞌa Jesús, itso jon: —Xe na aa tyiꞌman ꞌuꞌ, tyiꞌjeꞌquindëë ntsixuanꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Itso Simón Pedro nnon Jesús: —Ta, xe na aa nndaꞌ, yajoꞌ chito veꞌ xiaꞌntyi ngꞌë, mantyi quimanꞌ ntꞌö yo xquën. ");
INSERT INTO azgNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Majoꞌ sinin Jesús ncüii jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ nnon Pedro: —Minninchen tsꞌan na jndë jndëëꞌ, tyiꞌicanhanꞌ na mman na ninvaañꞌenhin ee jndë ntjuꞌhin, veꞌ xiaꞌntyi ngꞌee ro juu icanhanꞌ na mman. Ndoꞌ ꞌoꞌ conduihoꞌ na ntjuꞌ nꞌonhoꞌ, majoꞌ tyiꞌtsoñꞌenhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Nndaꞌ tso jon ee ntyjii ya jon nin juu na ninncyaa cüentahin nduee ntyee ꞌnaan nnꞌan judíos. Ngꞌe joꞌ na tso jon: —Majoꞌ tyiꞌtsoñꞌenhoꞌ na conduihoꞌ na ntjuꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ndoꞌ vi na jndë jndë tman jon ngꞌë́, tcüe nndaꞌ jon ndiaatco ꞌnaanꞌ jon, ndë joꞌ tëcjo nndaꞌ jon mesa. Itso jon ndë́: —¿Aa covaaꞌ nꞌonhoꞌ nin ꞌnan itsiquindyihanꞌ na nndaꞌ sꞌa? ");
INSERT INTO azgNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ꞌOꞌ conanꞌquijndyuhoꞌ ja tsan na tsiꞌman jñꞌoon naya ndëëhoꞌ ndoꞌ mantyi na condui ja tsꞌan na icoꞌxeenhoꞌ. Ndoꞌ majoꞌ ro na conduehoꞌ ee mancüiixjen joꞌ condui ja. ");
INSERT INTO azgNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ngꞌe ja na condui tsan na tsiꞌman ndëëhoꞌ ndoꞌ na matyeꞌntjönhoꞌ, jndë tman ngꞌehoꞌ, mantyi chuhanꞌ na ꞌoꞌ quitjueꞌcjehoꞌ na ntyentjonhoꞌ ndëë ntyjehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ee ja jndë sꞌa ncüii nnon na tsiꞌmanhanꞌ ndëëhoꞌ chaꞌ mantyi ꞌoꞌ quintꞌahoꞌ na nndaꞌ yo nnꞌan chaꞌxjen jndë sꞌa yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, juu moso tyiꞌtꞌman conduihin chaꞌxjen tꞌman condui nquii tsꞌan na ityentjon juu nnon. Ndoꞌ mantyi nquii tsꞌan na conduihin tsꞌan na incyaa juu jñꞌoon, tyiꞌtsijonhanꞌhin yo nquii tsꞌan na tꞌua tsꞌianꞌñeen nnon juu. ");
INSERT INTO azgNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xe covaaꞌ nꞌonhoꞌ jñꞌoonminꞌ ndoꞌ xe na aa ntꞌahoꞌhanꞌ, ndyio Tyoꞌtsꞌon jnꞌaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Majoꞌ chito matsjö jñꞌoonvaꞌ ntyja ꞌnaan tsoñꞌenhoꞌ. Ee mantyji nchu xjen nnꞌanhoꞌ, ꞌoꞌ na jndë tjihoꞌ na quinanꞌjonhoꞌ tsꞌian na matsꞌa. Ee mancüiixjen ijndeiꞌhanꞌ na quitsiquindëhanꞌ juu jñꞌoon na chu salmo na itsohanꞌ: “Manquii tsꞌan na icüaꞌ yo ja, itsuehin na cjö.” Nndaꞌ vaa itsiquindyi juu salmoꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Matsjö jñꞌoonvaꞌ ndëëhoꞌ vitjachen na nndui na nndaꞌ, chaꞌ juu xjen na ntsiquindëhanꞌ juuhanꞌ, ngantyja nꞌonhoꞌ na condui ja manquiintyi jon na jndë totsjö ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minninchen tsꞌan na ncyꞌoon juu cüenta tsꞌan na maꞌua tsꞌian njan nnon juu, ja iyꞌoon tsanꞌñeen cüenta. Ndoꞌ minninchen tsꞌan na iyꞌoon juu cüenta ja, mantyi iyꞌoon tsanꞌñeen cüenta nquii jon na jñon ja quiiꞌ ntꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jndë na sinin Jesús jñꞌoonvaꞌ, tꞌman jndyi vaa na siꞌndaaꞌhanꞌ ntyjii jon, yajoꞌ tjiꞌ jndyoyu jon ndë́. Itso jon: —Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, ncüii nquehoꞌ nninncyaa juu cüenta ja. ");
INSERT INTO azgNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Xjenꞌñeen tojntyꞌia ndëë ntyjë́ ngꞌe ndicüaaꞌ nꞌö́n nin ncüii já na itso jon na ntsꞌaa na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Juu xjenꞌñeen ja Juan na vequityën ngiaaꞌ Jesús na cocüꞌá. Tꞌman vaa na venchjii jon ja. ");
INSERT INTO azgNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Joꞌ juu Simón Pedro sꞌaa jon ntꞌö jon nnön na cüaxꞌë nnon Jesús nin ncüii já na nninncyaa juu cüentahin. ");
INSERT INTO azgNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Joꞌ sindyooꞌntyichen ja ngiaaꞌ Jesús, taxꞌë nnon jon, tsjö: —Ta, ¿Nin ncüii já na ntsꞌaa na nndaꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ndoꞌ tꞌa jon ꞌndyö, tso jon: —Majuu tsan na nninncya tanꞌ tyooꞌ nnon ya na jndë siquintꞌahanꞌ. Ndoꞌ vi na jndë siquindaaꞌ jon tyooꞌñeen, tyincyaa jonhanꞌ nnon Judas Iscariote, jnda ncüii tsꞌan na jndyu Simón. ");
INSERT INTO azgNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ndoꞌ xjenꞌñeen vi na jndë tyꞌoon juu cüenta tyooꞌñeen, tëqueeꞌ yutyia Satanás quiiꞌ tsꞌon juu. Yajoꞌ tso Jesús nnon juu: —Quitsicje ꞌuꞌ yo tsꞌian na ntsaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Majoꞌ já na minndyuá mesa yohin, minꞌncüii já tyíꞌcüaaꞌ nꞌö́n ndu na nndaꞌ tso jon. ");
INSERT INTO azgNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndoꞌ ngꞌe na mangiö́ na juu Judas na yꞌoon tjanche na ñjon xoquituꞌ, joꞌ vendye já jnanꞌtiú na tꞌua Jesús tsꞌian nnon juu na quitsijnda juu ꞌnan na icanhanꞌ na ninjntꞌue já juu ngueeꞌñeen, ndoꞌ aa quitsꞌaa juu naya naninñenꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ndoꞌ vi na jndë tcüaꞌ Judas juu tanꞌ tyooꞌñeen, maninꞌñoonꞌ jnduiꞌ juu. Ndoꞌ juu xjenꞌñeen jndë tijaanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Vi na jndë jnduiꞌ Judas quiiꞌ ntꞌán, itso Jesús ndë́: —Neinhin ja na condui tsansꞌa na iꞌua Tyoꞌtsꞌon tsꞌian nnön na jndyö quiiꞌ ntꞌan nnꞌan, conditꞌmaanꞌ ja. Ndoꞌ juu ꞌnan na ngenön nditꞌmaanꞌ jon ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ndoꞌ ngꞌe juu ꞌnan na ngenön, nditꞌmaanꞌ jon ntyja ꞌnaanꞌhanꞌ, yajoꞌ mantyi ja na condui tsansꞌa na jñon jon ja quiiꞌ ntꞌan nnꞌan, ntsitꞌmaanꞌ jon ja ntyja ꞌnaanꞌhanꞌ ndoꞌ cje ntsꞌaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ꞌOꞌ na conduihoꞌ ntsinda na venchjihoꞌ, matavivio vi mꞌan yo ꞌoꞌ. Njntꞌuehoꞌ ja, ndoꞌ chaꞌxjen jndë totsjö ndëë ntyjëëhë nnꞌan judíos, nein majuuntyihanꞌ matsjö ndëëhoꞌ: ꞌOꞌ jeꞌquindëë ntsquehoꞌ naijon na ncjö. ");
INSERT INTO azgNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ncüii jñꞌoon xco na mancya ndëëhoꞌ na icoꞌxenhanꞌ ꞌoꞌ, na quinanꞌvengiohoꞌ ntyjehoꞌ. Chaꞌxjen mꞌan ja na ventjihoꞌ, manndaꞌ vaa quinanꞌvengiohoꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ee na nntꞌahoꞌ na nndaꞌ, tsoñꞌen nnꞌan ncüaaꞌ nꞌonhan na conduihoꞌ nnꞌan na tcꞌën na quitsayꞌonhoꞌ yo jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ndoꞌ taxeeꞌ Simón Pedro nnon Jesús: —Ta, ¿Yuu vijon vjaꞌ? Tꞌa Jesús, tso jon: —Ntyja na ngenön naneinhin, jeꞌquindëë ntsijon ꞌuꞌ ntyja ꞌnaanꞌhanꞌ, majoꞌ ngüentyja xjen na ngenoonꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Joꞌ taxeeꞌ Pedro nnon jon: —Ta, ¿Ndu na jeꞌquindëë na ntsijon ja naneinhin yo ꞌnan na ngenoonꞌ? Tanin min xe na aa ncüꞌiö yo ntyja ꞌnanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ndoꞌ tꞌa Jesús, tso jon: —ꞌUꞌ matsitiuꞌ na nninncyaꞌ na nncüꞌioꞌ ntyja njan. Jñꞌoon na mayuuꞌ matsjö nnonꞌ, vitjachen na ntsixuaa quilꞌö na vanco ꞌio, majoꞌ juu xjenꞌñeen ꞌuꞌ jndë ndye jnda jndë tji ꞌuꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Tyiꞌninncyahoꞌ na ntsiꞌndaaꞌhanꞌ ngiohoꞌ. Covantyja nꞌonhoꞌ Tyoꞌtsꞌon, mantyi cantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Vaaꞌ tyëhöꞌ jndye joo min yuu jon na ncꞌon nnꞌan. Xe na aa chi nndaꞌ vaa, jndë tsjö ndëëhoꞌ. Mancjö na ntsijntꞌa joohanꞌ na ninjntꞌuehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndoꞌ na jö ntsijntꞌa naijon na ncꞌonhoꞌ, majoꞌ nndyö ntcüꞌë. Ndoꞌ joꞌ ncjöchöhoꞌ naijon na mꞌan, chaꞌ naijon na mꞌan, mantyi ꞌoꞌ nndëë ncꞌonhoꞌ joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ndoꞌ ꞌoꞌ mangiohoꞌ yuu jon tja nato na ngueeꞌhanꞌ naijon na jö. ");
INSERT INTO azgNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ndoꞌ itso Tomás nnon Jesús: —Nndaꞌ ta, já tyiꞌquindiö́ yuujon vjaꞌ, ndoꞌ ¿Nchu vaa ntꞌá na ncüaaꞌ nꞌö́n yuujon tja juu natoꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tꞌa Jesús, tso jon nnon juu: —Ja condui nato, ndoꞌ condui ja jñꞌoon na mayuuꞌ, ndoꞌ condui ja na tyiꞌjon quintycüii na vandoꞌ ñuaanꞌ tsꞌan. Ninnquiiꞌchen ntyja njan na nndëë ngueeꞌ tsꞌan na mꞌaan Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xe na aa covaaꞌ nꞌonhoꞌ nin condui ja, yajoꞌ mantyi ncüaaꞌ nꞌonhoꞌ ntyja ꞌnaanꞌ nquii Tyëhöꞌ. Majoꞌ nanein na tonnon ngꞌe na cotaꞌjnꞌaanhoꞌ ja, mantyi cotaꞌjnꞌaanhoꞌhin, ndoꞌ chaꞌvijon na jndë jntyꞌia ndëëhoꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ndoꞌ tso Felipe nnon Jesús: —Nndaꞌ ta, quitsiꞌmanꞌ Tyeꞌhöꞌ ndë́, yajoꞌ ntjo ya ngiö́. ");
INSERT INTO azgNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tꞌa Jesús ꞌndyo juu: —ꞌUꞌ Felipe, jndë tijndye xuee na mꞌan yo ꞌoꞌ, ¿Aa manin joꞌ tyiꞌcüajnanꞌ ja? Juu tsꞌan na jndë jndyiaaꞌ ja, mantyi jndë jndyiaaꞌ juu nquii tyëhöꞌ. ¿Ndu na tsuꞌ: Quitsiꞌmanꞌ tyeꞌhöꞌ ndë́? ");
INSERT INTO azgNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Aa tyiꞌcantyja tsonꞌ na jndyoyu condui ja yo tyëhöꞌ, ndoꞌ jndyoyu conduihin yo ja? Majoo jñꞌoon na matsinën ndëëhoꞌ, chito chaꞌxjen na mavaaꞌ tsꞌön ncö na matsinënhanꞌ. Nquii Tyëhöꞌ na ninnquiiꞌchen mꞌaan jon yo ja, nquii jon itsꞌaa jon tsꞌian ꞌnaanꞌ jon yo ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ngꞌe na nndaꞌ, cantyja nꞌonhoꞌ na ninncüii condui ja yo Tyëhöꞌ, ndoꞌ ninncüii conduihin yo ja. Xe na aa ndicantyja nꞌonhoꞌ na nndaꞌ, majoꞌ ncyahoꞌ na ngantyja nꞌonhoꞌ ja xengꞌe ntyja ꞌnaan joo tsꞌian na matsꞌa. ");
INSERT INTO azgNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, minꞌcya ro tsꞌan na vantyja tsꞌon juu ja, maninjoo tsꞌian na matsꞌa, joꞌ ntsꞌaa juu. Ata njonntyichen tsꞌian na ntsꞌaa juu, ngꞌe jö na mꞌan Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ndoꞌ minninchen jñꞌoon na ngitanhoꞌ nnon Tyëhöꞌ yo xuë, joꞌ na ninncyahanꞌ chaꞌ cüitꞌmaanꞌhin ntyja njan na condui ja jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Tsoñꞌen na ngitanhoꞌ yo xuë, ninncyahanꞌ ngꞌe na mꞌanhoꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Xe na aa vengiohoꞌ ja, yajoꞌ quitaꞌngueeꞌhoꞌ jñꞌoon njan na icoꞌxenhanꞌ ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ndoꞌ ja ntcꞌan nnon Tyëhöꞌ na nncyaa jon ncüiichen na ntejndei jon ꞌoꞌ, manquii Espíritu Santo na conduihin jñꞌoon na mayuuꞌ. Ninnquiiꞌchen ncꞌoon jon yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nnꞌan na mꞌan ntyja ꞌnaanꞌ tsonnangue, jeꞌquindëë na ncyꞌonhan cüenta jon ee tyiꞌcojntyꞌiahin jon, min tyiꞌquitaꞌjnꞌaanhan jon. Majoꞌ ꞌoꞌ cotaꞌjnꞌaanhoꞌhin, ee mꞌaan jon quiiꞌ nꞌonhoꞌ, ndoꞌ ninnquiiꞌchen ncꞌoon jon yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Tyiꞌjeꞌquiꞌndyi ꞌoꞌ na ntjotohoꞌ, majndaꞌ na nndyö nntꞌa na mꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nnꞌan na tyiꞌcantyja nꞌonhan ja, mavaa xjen na nnanꞌcueeꞌhan ja, ndoꞌ ndë joꞌ taxeꞌquijntyꞌiantyichenhan ja. Majoꞌ ꞌoꞌ njntyꞌia nndaꞌhoꞌ ja, ee na ngüantꞌö xcö. Mangꞌe joꞌ mantyi ꞌoꞌ nnanꞌxuanhoꞌ na tyiꞌquintycüii na ntaꞌndoꞌ xco ñuaanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Juu xjenꞌñeen, vi na jndë tentyjahanꞌ, ncüaaꞌ nꞌonhoꞌ na mꞌan ja yo Tyëhöꞌ, ndoꞌ mantyi ꞌoꞌ mꞌanhoꞌ yo ja, ndoꞌ ja mꞌan yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Juu tsan na itsue jñꞌoon na macoꞌxën ndoꞌ na itsiquindëë juuhanꞌ, tsanꞌñeen viꞌnchjii juu ja. Mantyi nquii Tyëhöꞌ ntsiviꞌnchjii jon tsꞌan na viꞌnchjii ja. Ndoꞌ mantyi ja ntsiviꞌnchji tsanꞌñeen, ndoꞌ ntsiꞌman nnon jon ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yajoꞌ itso juu tsan na jndyu Judas, majoꞌ chito Judas Iscariote: —Nndaꞌ ta, ¿Ndu na xiaꞌntyi ndë́ na ntsiꞌmanꞌ ntyja na condui ꞌuꞌ, majoꞌ tyiꞌjeꞌquitsaꞌhanꞌ ndëë nnꞌan tsonnangue? ");
INSERT INTO azgNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ndoꞌ tꞌa Jesús ꞌndyo jon: —Juu tsꞌan na venchjii ja, ntsiquindëë jon jñꞌoon na maquën. Ndoꞌ Tyëhöꞌ ncꞌoon jon na venchjii jon tsanꞌñeen ndoꞌ ntsquënö́n na mꞌaan juu na ncꞌö́n yohin. ");
INSERT INTO azgNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Majoꞌ juu tsꞌan na tyiꞌvenchjii ja, tyiꞌninꞌcüangueeꞌ tsanꞌñeen jñꞌoon na mancya. Ee jñꞌoon na mancya ndëëhoꞌ tsixuanhanꞌ jñꞌoon ꞌndyo Tyëhöꞌ na tꞌua jon tsꞌian nnön na jndyö quiiꞌ ntꞌan nnꞌan, chito jñꞌoon ꞌndyö ncöhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Matsinën jñꞌoonmin ndëëhoꞌ viochen xjen na ninmꞌan yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Majoꞌ ja ntcꞌan nnon Tyëhöꞌ na quijñon jon Espíritu Santo yohoꞌ na nquii jon ngüañoonꞌ jon ꞌoꞌ. Ntsiꞌmanntyichen jon ndëëhoꞌ jñꞌoon na icanhanꞌ na quindyehoꞌ. Ndoꞌ ntsꞌaa jon na ngañjoonꞌ nꞌonhoꞌ tsoñꞌen jñꞌoon na jndë nintotsjö ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Juu na condui ja na tajñuaanꞌ tsꞌon ja, maꞌndyihanꞌ na cꞌoonhanꞌ yohoꞌ. Juuhanꞌ mancya na cyꞌonhoꞌ cüentahanꞌ, juuhanꞌ njonntyichen tsixuanhanꞌ, chito juu na tajñuaanꞌ tsꞌon na nanꞌxuan nnꞌan tsonnangue. Tyiꞌninꞌncyahoꞌ na ntsiꞌndaaꞌhanꞌ ngiohoꞌ nin ncüii nnon na ntjonhoꞌ min tyiꞌntyuehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jndë jndyehoꞌ na tsjö ndëëhoꞌ na ncjö, majoꞌ nndyö nntꞌa na mꞌanhoꞌ. Xe na aa vengiohoꞌ ja, yajoꞌ nninncyaahanꞌ na neinhoꞌ min na tsjö na jö, ee jö naijon na mꞌaan Tyëhöꞌ. Jon tꞌmanntyichen conduihin, chintyi ja. ");
INSERT INTO azgNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndoꞌ jñꞌoonminꞌ matsiquindyi ja ꞌoꞌ vitjachen na ngüentyjahanꞌ, chaꞌ vi na jndë tentyjahanꞌ, ngantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","“Mataviviochen na ntsinën yo ꞌoꞌ, ee nquii juu na ityeꞌntjon nnꞌan tsonnangueva, jndë ndyontyja juu. Majoꞌ ntyja njan taꞌnan minꞌncüii nnon na nndëë ninjntꞌuehin na quitꞌuiihanꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ee tsoñꞌen jñꞌoon na icoꞌxen Tyëhöꞌ ja, mavancꞌuëhanꞌ. Ntyja ꞌnaanꞌhanꞌ ncüaaꞌ nꞌon nnꞌan tsonnangue na venchji ja jon. Cüa jeꞌ, quinanꞌquintyjahoꞌ, cja, nntꞌui ntjoohin. ");
INSERT INTO azgNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Ja condui tsꞌöö ntjon na mayuuꞌ, ndoꞌ nquii Tyëhöꞌ conduihin tsꞌan na vantyjeeꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Minꞌcya ro ntꞌö juu tsꞌööꞌñeen na mꞌaanhanꞌ ntyja njan na tyiꞌquintꞌahanꞌ të, ityjee jonhanꞌ, ndoꞌ itscyaa jonhanꞌ. Majoꞌ ncüii cüii ntꞌö tsꞌööꞌñeen na contꞌahanꞌ të, ityjee jon ndëëhanꞌ chaꞌ jndyentyi të quintꞌahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Joo jñꞌoon na jndë tyincya ndëëhoꞌ, iquen ntjuꞌhanꞌ ñuaanhoꞌ chaꞌ ya nntꞌahoꞌ tsꞌian njan. ");
INSERT INTO azgNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mangꞌe joꞌ quintjotyenhoꞌ ntyja njan chaꞌxjen contjotyen ja ntyja ꞌnaanhoꞌ. Ee chaꞌxjen ntꞌö tsꞌöö, jeꞌquindëë ntsꞌaa nquiihanꞌ të vi na jndë tꞌiooꞌhanꞌ yo nquii tsꞌöö, min ꞌoꞌ jeꞌquindëë ntꞌahoꞌ tsꞌian na nditꞌmaanꞌ Tyoꞌtsꞌon ntyja ꞌnaanhanꞌ xe na aa tyiꞌquintjohoꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ja condui chaꞌvijon xꞌee tsꞌöö, ndoꞌ ꞌoꞌ conduihoꞌ ntꞌöhanꞌ. Nin ncüiihoꞌ na contjotyenhin ntyja njan, mantyi ntjotyen ja yohin. Ndoꞌ ngꞌe na nndaꞌ, ndëë ntꞌahoꞌ tsꞌian njan. Majoꞌ xe na aa ntꞌiooꞌ tsꞌan ntyja njan, taꞌnan ncüii nnon na ndëë ntsꞌaa juu na nditꞌmaanꞌ Tyoꞌtsꞌon ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ndoꞌ juu tsꞌan na tyiꞌquintjotyenhin ntyja njan, ntyqueꞌhanꞌ juu chaꞌxjen na conanꞌcyaa nnꞌan ntꞌö tsꞌöö, ndoꞌ joꞌ cocanhanꞌ. Ndë joꞌ conanꞌncüi nnꞌan ntꞌööꞌñeen na ndyionhinhanꞌ nnon chon na nntcohanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Xe na aa contjotyenhoꞌ ntyja njan ndoꞌ cotaꞌngueeꞌhoꞌ jñꞌoon na mancya, yajoꞌ quitanhoꞌ nnon Tyoꞌtsꞌon tsoñꞌen na ntꞌue nꞌonhoꞌ ndoꞌ ninncyaa jonhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ndö vaa na itsitꞌmaanꞌhanꞌ Tyëhöꞌ, na ntꞌahoꞌ jndye nnon na ntyja ꞌnaanꞌ joꞌ nditꞌmaanꞌhin. Na nntꞌahoꞌ na nndaꞌ, ntsiꞌmanhanꞌ na mayuuꞌ conduihoꞌ nnꞌan na macꞌën na quinanꞌjonhoꞌ yo juu jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Chaꞌxjen nquii Tyëhöꞌ venchjii jon ja, manndaꞌ ro venchji jahin. Joꞌ quintjotyenhoꞌ ntyja ꞌnaanꞌ juu na mꞌan na venchjihoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ja matsiquindëë jñꞌoon na icoꞌxen Tyëhöꞌ ja, ndoꞌ contjo ja quiiꞌ na venchjii jon ja. Mantyi ꞌoꞌ ninnquiiꞌchen quitaꞌngueeꞌhoꞌ jñꞌoon na macoꞌxënhoꞌ. Ee na nntꞌahoꞌ na nndaꞌ, ntjotyenhoꞌ ntyja ꞌnaanꞌ juu na venchji ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Jñꞌoonminꞌ matsinën ndëëhoꞌ chaꞌ juu na incyaa Tyoꞌtsꞌon na nën rö, nnanꞌxuanhoꞌhanꞌ, ata vantjoꞌchen ninncyaahanꞌ na neinhoꞌ ngꞌe na cotaꞌngueeꞌhoꞌ ꞌnan na matsjö. ");
INSERT INTO azgNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ndö ro jñꞌoon na macoꞌxën ja ꞌoꞌ na quinanꞌvengiohoꞌ ntyjehoꞌ chaꞌxjen na venchji ja ꞌoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Juu tsan na ninncyaa na cueꞌ ntyja ꞌnaan ntyje, tꞌmanntyi tsixuan juu na venchjii juu tsoñꞌen nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ꞌOꞌ conduihoꞌ nnꞌan na ya jñꞌoon yo ja xe na aa cotaꞌngueeꞌhoꞌ jñꞌoon na macoꞌxënhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Tyiꞌquitsjö na ꞌoꞌ conduihoꞌ moso, ee tsꞌan na mꞌaan moso tyiꞌquintjii juu nin ꞌnan itsijndaꞌ nquii tsan na ityeꞌntjonhin. Nein matsjö na ꞌoꞌ conduihoꞌ nnꞌan na ya jñꞌoon yo ja, ee tsoñꞌen jñꞌoon na jndyi ꞌndyo Tyëhöꞌ, jndë tsjö ncꞌihanꞌ ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Chito ꞌoꞌ jntꞌuehoꞌ ja, ncö tji ja ꞌoꞌ ndoꞌ maꞌua tsꞌian ndëëhoꞌ na ntsaquintꞌahoꞌ ncüii cüii nnon na jeꞌcamintyjeeꞌ na nditꞌmaanꞌ nquii Tyëhöꞌ ntyja ꞌnaanhanꞌ. Ee na nntꞌahoꞌ na nndaꞌ, nninncyaa jon minꞌcya ro jñꞌoon na ngitanhoꞌ nnon jon yo xuë ngꞌe na vantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ndoꞌ ndö vaa jñꞌoon na macoꞌxën ꞌoꞌ: Quinanꞌvengiohoꞌ ntyjehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Vaa xjen na nque nnꞌan tsonnangue, tyiꞌcueeꞌ nꞌonhanhoꞌ. Ya na nndaꞌ vaa, cüaaꞌ nꞌonhoꞌ na tyuaaꞌntyichen tꞌonhan na tyiꞌcueeꞌ nꞌonhan ja, chito ninnquehoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xe na aa cotsayꞌonhoꞌ jñꞌoon yo nnꞌan tsonnangue, yajoꞌ ncꞌonhan na vengiohan ꞌoꞌ. Majoꞌ ngꞌe na tyiꞌquinanꞌjonhoꞌ yohan, joꞌ na tyiꞌcueeꞌ nꞌonhan ꞌoꞌ, ee ja jndë tji ja ꞌoꞌ quiiꞌ ntꞌan nanꞌñeen na nanꞌxuanhoꞌ cüentaaꞌ nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cañjoonꞌ nꞌonhoꞌ joo jñꞌoon na jndë totsjö ndëëhoꞌ. Juu moso tyiꞌtꞌman conduihin chaꞌxjen nquii tsꞌan na icoꞌxenhin. Ngꞌe na contyꞌe nnꞌan ja, majoꞌntyi ntyꞌehin ꞌoꞌ. Ndoꞌ xe na aa cotaꞌngueeꞌhoꞌ jñꞌoon na mancya, yajoꞌ mantyi nnanꞌvehan jñꞌoon na ninncyahoꞌ ndëëhan. ");
INSERT INTO azgNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ee mancüiixjen nntꞌaviꞌ nnꞌanhoꞌ ngꞌe na conduihoꞌ cüenta. Nntꞌahan na nndaꞌ ngꞌe na tyiꞌquitaꞌjnꞌaanhan nquii jon na jñon ja quiiꞌ ntꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Xe na ja tyiꞌquindyö na matsinën ndëëhan, yajoꞌ tyiꞌjeꞌquitsijndaꞌhanꞌ na nanꞌxuanhan jnan tonnon Tyoꞌtsꞌon. Majoꞌ neinhin tyiꞌjeꞌquindëë nnduehan na tyiꞌquindiohan na aa conanꞌtjahan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ee juu tsan na tyiꞌcueeꞌ tsꞌon ja, mantyi tyiꞌcueeꞌ tsꞌon tsanꞌñeen nquii Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Minꞌncüii tsꞌan tyíꞌcotsꞌaa tsꞌian quiiꞌ ntꞌan nnꞌan chaꞌxjen joo tsꞌian na matsꞌa. Xe na aa tacotsꞌahanꞌ, yajoꞌ tyiꞌjeꞌcüijndaꞌ na conanꞌtjahan nnon jon. Majoꞌ min na jndë jntyꞌiahan tsꞌianꞌñeen na matsꞌa ntyjantyi xjen na tꞌa jahanꞌ, mancüiixjen mꞌanhan na tyiꞌcueeꞌ nꞌonhan ja yo nquii Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Majoꞌ nndaꞌ vaa chaꞌ quitsiquindëhanꞌ juu jñꞌoon na jndui na conanꞌyꞌonhan na icoꞌxen na itsohanꞌ: Tꞌon nnꞌan na tyíꞌcueeꞌ nꞌonhan ja min na tacotsꞌa minꞌncüii nnon na ninncyaahanꞌ na contꞌahan na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Majoꞌ nquii jon conduihin na ngüañoonꞌ jonhoꞌ, nquii Espíritu na conduihin na mayuuꞌ, nnan jon na mꞌaan Tyëhöꞌ na ncüjeeꞌ jon na mꞌanhoꞌ. Xjen na nnguë ntcüꞌë na mꞌan Tyëhöꞌ, ncꞌua tsꞌian na nndyo Espíritu Santo na mꞌanhoꞌ. Ndoꞌ vi na jndë tyjeeꞌ jon, ncüjiꞌ jndyoyu jon ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ndoꞌ mantyi ꞌoꞌ ntyjiꞌ jndyoyuhoꞌ ntyja njan, ee xjen na tꞌa tsꞌianminꞌ mꞌanhoꞌ yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Itsontyichen Jesús: —Jndë sinën jñꞌoonminꞌ ndëëhoꞌ ntyja njan chaꞌ tyiꞌntscyaahanꞌ ꞌoꞌ na vantyja nꞌonhoꞌ Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ee nque nnꞌan judíos, ntjiꞌhan ꞌoꞌ quityquiiꞌ ntꞌaanꞌon ꞌnaanhan. Ndoꞌ mangüentyja xjen na minꞌcya ro tsꞌan na ntscueeꞌ juu ꞌoꞌ tsojnaanꞌ na vantyja nꞌonhoꞌ ja, ntsitiuto juu na ityeꞌntjon juu nnon Tyoꞌtsꞌon na ntsꞌaa juu na nndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nntꞌahan nanꞌminꞌ ngꞌe ndicüaaꞌ nꞌonhan ntyja ꞌnaanꞌ nquii Tyëhöꞌ min ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Majoꞌ jndë tsjö jñꞌoonminꞌ ndëëhoꞌ chaꞌ ya na ngüentyjahanꞌ, ngañjoonꞌ nꞌonhoꞌ na jndë tsjöhanꞌ. “Tyíꞌquitsjö jñꞌoonmin ndëëhoꞌ xjen na tꞌa tsꞌian na chö ngꞌe na ninmꞌan yohoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Majoꞌ nquii jon na jñon jon ja quiiꞌ ntꞌanhoꞌ, jö ntcüꞌë na mꞌaan jon, ndoꞌ minꞌncüiihoꞌ tacotaꞌxeeꞌhoꞌ yuu vijon jö. ");
INSERT INTO azgNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Majoꞌ veꞌ ee na tsjö jñꞌoonminꞌ ndëëhoꞌ, joꞌ tꞌman jndyi itsichjooꞌhanꞌ nꞌonhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Ndoꞌ min na nndaꞌ vaa, majoꞌ jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, mancüiixjen ntejndeihanꞌ ꞌoꞌ na ncjö. Ee xe na aa tyiꞌncjö, nquii jon na ngüañoonꞌ jon ꞌoꞌ tyiꞌxeꞌcüjeeꞌ jon. Ndoꞌ na ncjö, ncꞌua tsꞌian nnon jon na quindyo jon na mꞌanhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ndoꞌ vi na jndë tyjeeꞌ jon, joo nnꞌan na conanꞌtjahan, ntsꞌaa jon na ngiooꞌ nꞌonhan yo nquii jon, yo na quintꞌahan ꞌnan na chuhanꞌ ndoꞌ mantyi yo na ntcoꞌxen Tyoꞌtsꞌonhan tsojnaanꞌ na conanꞌtjahan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Joo nnꞌan na tyiꞌninꞌcantyja nꞌonhan ja, nquii Espíritu Santo ntsꞌaa jon na ngiooꞌ nꞌonhan na conduihan nnꞌan jnan. ");
INSERT INTO azgNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mantyi ntsꞌaa jon na ngiooꞌ nꞌon nnꞌan tsonnangue na quintꞌahan ꞌnan na jndyoyu ngꞌe na jö ntcüꞌë na mꞌaan Tyëhöꞌ, ndoꞌ taxeꞌquijntyꞌiantyichenhan ja. ");
INSERT INTO azgNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ntsꞌaa jon na ngiooꞌ nꞌon nnꞌan na mayuuꞌ na ntcoꞌxen Tyoꞌtsꞌonhan tsojnaanꞌ na tonanꞌtjahan nnon jon ee na jndë tcoꞌxen jon nquii yutyia na conintque quiiꞌ nꞌon nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Min jndyechen jñꞌoon na ninꞌquitsinën ndëëhoꞌ, majoꞌ ndiquindëë ncüaaꞌ nꞌonhoꞌhanꞌ nanein. ");
INSERT INTO azgNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Majoꞌ nquii Espíritu na conduihin na mayuuꞌ, juu xjen na ncüjeeꞌ jon, ngotsiꞌmanntyichen jon ndëëhoꞌ tsoñꞌen jñꞌoon na conduihanꞌ na mayuuꞌ. Tyiꞌxeꞌquitsinin jon ntyja nchu vaa tsixuan nquii jon, xiaꞌntyi ntsinin jon ntyja ꞌnaanꞌ ncüii cüii jñꞌoon na indyii jon na itsinin nquii Tyoꞌtsꞌon. Ndoꞌ ntsiꞌman jon ndëëhoꞌ ꞌnan na ndëcya nndui. ");
INSERT INTO azgNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ntsitꞌmaanꞌ jon ja ee tsoñꞌen jñꞌoon na ninꞌquitsiquindyi ja ꞌoꞌ ncyꞌoon jon cüentahanꞌ, ndoꞌ jñꞌoonꞌñeen ntsiꞌman jonhanꞌ ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tsoñꞌen na tsixuanhanꞌ cüentaaꞌ nquii Tyëhöꞌ, macüentahanꞌ. Ngꞌe joꞌ na tsjö na nquii Espíritu Santo ncyꞌoon jon cüenta jñꞌoon na ninꞌquitsiquindyihoꞌ ndoꞌ na ntsiꞌman jonhanꞌ ndëëhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Taviviochen vi ncꞌön yohoꞌ ndoꞌ ndë joꞌ tajeꞌquijntyꞌiantyichenhoꞌ ja. Ndoꞌ ya ndëcya, chjoviꞌ xjen, vi njntyꞌia nndaꞌhoꞌ ja, ngꞌe jö na mꞌaan Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jndë na sinin jon jñꞌoonminꞌ, vendye já na tqueenꞌ jon na quitsayꞌö́n jñꞌoon yohin, jnduë́ ndëë ntyjë́: —¿Nin ꞌnan ninꞌquitsiquindyi jñꞌoonvaꞌ na itso jon ndëë: Taviviochen vi ncꞌön yohoꞌ, ndoꞌ ya ndë tajeꞌquijntyꞌiantyichenhoꞌ ja? Ndoꞌ ya jndëcya, chjoviꞌ xjen vi njntyꞌia nndaꞌhoꞌ ja? Ndoꞌ mantyi na itso jon: Ngꞌe na ncjö na mꞌaan Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Jnduëntyëchë́n: “¿Nin ninꞌquitsiꞌman jñꞌoonvaꞌ na itso jon na chjoviꞌ xjen? Ndicüaaꞌ nnꞌön ntyja ꞌnaanꞌhanꞌ.” ");
INSERT INTO azgNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ndoꞌ Jesús, taaꞌ tsꞌon jon na ninꞌquitaꞌxꞌëntyëchë́n jñꞌoonꞌñeen nnon jon. Joꞌ tso jon: —¿Aa cotaꞌxeeꞌhoꞌ ndëë ntyjehoꞌ ntyja ꞌnaanꞌ jñꞌoonminꞌ na tsjö na taviviochen vi na ncꞌönntyë yohoꞌ, ndoꞌ ndë joꞌ taxeꞌquijntyꞌiantyichen ꞌoꞌ ja, ndoꞌ ndëcya na chjoviꞌ xjen, yajoꞌ njntyꞌia nndaꞌhoꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, nque nnꞌan na mꞌan ntyja ꞌnaanꞌ tsonnangue ncꞌonhan na nein jndyihan na njntyꞌiahan ꞌnan na ngenön. Majoꞌ juuhanꞌ nntsꞌaahanꞌ na nndyuee jndyihoꞌ. Majoꞌ juu na itsichjooꞌhanꞌ nꞌonhoꞌ, ntscüaquenhanꞌ na ncꞌonhoꞌ na neinhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ncüii tsanscu, iquiihanꞌhin xjen na mandyo ntsingui jon, ngꞌe jndë tentyja xjen. Majoꞌ vi na jndë tui yujntꞌa, cotsuuꞌ tycya tsꞌon jon na tquiihanꞌhin ee mꞌaan jon na neiinꞌ jon na jndë tui jnda jon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Manndaꞌ vaa itsijonhanꞌ ntyja ꞌnaanhoꞌ. Nein mꞌanhoꞌ na chjooꞌ nꞌonhoꞌ na matsjö na ncjö, majoꞌ ninncyaahanꞌ na neinhoꞌ ya na njntyꞌia nndaꞌhoꞌ ja. Ndoꞌ juu xjenꞌñeen juu na neinhoꞌ, taꞌnan tsꞌan na nndëë ntyjeehanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Juu xeeꞌñeen taxeꞌcanhanꞌ na ntaꞌxeeꞌntyichenhoꞌ jñꞌoon nnön. Jñꞌoon na mayuuꞌ matsjö ndëëhoꞌ, tsoñꞌen na ngitanhoꞌ nnon Tyëhöꞌ yo xuë ngꞌe na vantyja nꞌonhoꞌ ja, joꞌ na ninncyaa jon na ncyꞌonhoꞌ cüentahanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ata xjen nein taꞌnan tcanhanꞌ na ninjntꞌuehoꞌ xuë na ngitanhoꞌ jñꞌoon nnon tyëhöꞌ. Nein cüijntꞌuehoꞌ xuë na ngitanhoꞌ nnon jon chaꞌ ncyꞌonhoꞌ cüenta ꞌnan na cotanhoꞌ. Ngꞌe na nndaꞌ, ntsꞌaahanꞌ na nein jndyihoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Joo jñꞌoonminꞌ na jndë sinën ndëëhoꞌ, tyiꞌquitsinën ncꞌihanꞌ. Majoꞌ mangüentyja xjen na tajeꞌquitsinën na nndaꞌ, ee ntsinën jñꞌoon jndyoyu ndëëhoꞌ ntyja ꞌnaanꞌ nquii Tyëhöꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ndoꞌ vi na jndë mꞌan nntꞌa na mꞌaan Tyëhöꞌ yajoꞌ ngitanhoꞌ jñꞌoon nnon jon yo xuë chaꞌ ntyja ꞌnaanhanꞌ nditꞌmaanꞌ ja. Yajoꞌ min tyiꞌxeꞌcanhanꞌ na ja ntcꞌan nnon jon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ee nquiintyi jon venchjii jon ꞌoꞌ ngꞌe vengiohoꞌ ja, ndoꞌ jndë vantyja nꞌonhoꞌ na jnan na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ja jnan na mꞌaan jon, tyjë tsonnangueva, ndoꞌ nein maꞌndyihanꞌ na ncjö ntcüꞌë na mꞌaan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yajoꞌ já nnꞌan na tqueenꞌ jon na quinanꞌjö́n yohin, jnduë́ nnon jon: —Nein tavimatsininꞌ jñꞌoon na tyiꞌquitso nquiiꞌhanꞌ, matsininꞌ jndyoyuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ndoꞌ nanein covaaꞌ nꞌö́n na tsoñꞌen ntyjiꞌ, min tyiꞌcanhanꞌ na ntaꞌxꞌëntyë́ jñꞌoon nnonꞌ. Ngꞌe joꞌ vantyja nꞌö́n na mayuuꞌ jnanꞌ na mꞌaan nquii Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yajoꞌ tꞌa Jesús jndyuë́: —Nein itsꞌaahanꞌ ngiohoꞌ na vantyja nꞌonhoꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Majoꞌ ngüentyja xjen, ndoꞌ nein jndë ventyjahanꞌ na ntycyahoꞌ na mꞌanhoꞌ yo ja. Ncüii cüiihoꞌ ncꞌohoꞌ vꞌaahoꞌ, nꞌndyehoꞌ ja na ninncö. Majoꞌ tanin, ee chito ninncö mꞌan, nquii Tyëhöꞌ mꞌaan jon yo ja. ");
INSERT INTO azgNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jndë sinën jñꞌoonminꞌ ndëëhoꞌ chaꞌ ntyja njan, juu na tajñuaanꞌ tsꞌon mꞌan ja, nnanꞌxuanhoꞌhanꞌ. Ninnquiiꞌchen ngenonhoꞌ naviꞌ na mꞌanhoꞌ tsonnangue, majoꞌ tyiꞌndyuehoꞌ ee ja jndë tantjön juu yutyia na icoꞌxen juu nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Vi na jndë sinin Jesús jñꞌoonminꞌ ndë́, jndondë jon quiñoonꞌndue. Itso jon: —Tyeꞌ, jndë tentyja xjen na ndui tsoñꞌen ꞌnan na tijndaꞌ ntyja njan. Nanein quitsitꞌmanꞌ ja na condui ja jndaꞌ, chaꞌ mantyi ja na condui jndaꞌ nditꞌmaanꞌ ꞌuꞌ ntyja njan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ee ninncö jndë tquenꞌ na conintque ja ndëë tsoñꞌen nnꞌan chaꞌ ncüii cüii tsꞌan na mancyaꞌ ntꞌö nndëë ninncya na tyiꞌquintycüii na vandoꞌ ñuaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ee ndö vaa na ntsixuan tsꞌan na tyiꞌjon quintycüii na vandoꞌ ñuaanꞌ juu, na cüaaꞌ tsꞌon tsanꞌñeen na ninncuꞌ condui ꞌuꞌ Tyoꞌtsꞌon na mayuuꞌ, ndoꞌ ja condui Cristo na jñonꞌ ja quiiꞌ ntꞌan nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","“Xjen na tꞌa juu tsꞌian ꞌnanꞌ, matsitꞌmaanꞌ ꞌuꞌ tondëë nnꞌan tsonnangue. Ndoꞌ jndë siquindëë juu tsꞌian na tꞌionꞌ ja na cüꞌiö cüentahan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndoꞌ nanein Tyeꞌ, quitsitꞌmanꞌ ja chaꞌxjen na covitꞌmaanꞌ ꞌuꞌ naijon na mꞌanꞌ, na ninncüiixjen matsixuan ja yo ꞌuꞌ vitjachen na nguaa tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Joo nnꞌan na tyincyaꞌ ntꞌö, ja jndë siꞌman ndëëhin ntyja ꞌnanꞌ. Tomꞌanhan cüentaꞌ ndoꞌ tyincyaꞌhan na conduihan cüenta ja. Conanꞌvehan jñꞌoon naya ꞌnanꞌ ndoꞌ cotaꞌngueeꞌhinhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndoꞌ nanein, covaaꞌ nꞌonhan na tsoñꞌen na tyincyaꞌ na matsꞌa, ninncuꞌ tyincyaꞌ na matsixuanhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Joo jñꞌoon na tsuꞌ nnön, jndë tyincyahanꞌ ndëëhan, ndoꞌ jndë tyꞌonhan cüentahanꞌ. Covaaꞌ nꞌonhan na mayuuꞌ na jnan na mꞌanꞌ, ndoꞌ vantyja nꞌonhan na ꞌuꞌ tꞌuaꞌ tsꞌian nnön na jndyö quiiꞌ ntꞌan nnꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ntyja ꞌnaan joohan macꞌan vi nayaꞌñeen nnonꞌ, chito ntyja ꞌnaan nnꞌan tsonnangue. Quitejndeiꞌ joo nanminꞌ na jndë tyincyaꞌhan ntꞌö ee conanꞌxuanhan cüentaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tsoñꞌen joohan na nanꞌxuanhan cüenta, mantyi conanꞌxuanhan cüentaꞌ. Ndoꞌ joohan na nanꞌxuanhan cüentaꞌ, mantyi conanꞌxuanhan cüenta. Ndoꞌ vanditꞌmaanꞌ ja ntyja ꞌnaanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","“Nein taxeꞌcꞌönntyëchën quiiꞌ ntꞌan nnꞌan tsonnangue, ee jö ntcüꞌë na mꞌanꞌ, majoꞌ joo nanminꞌ contjohin. ꞌUꞌ Tyeꞌ na ñuan nquiiꞌ condui ꞌuꞌ, joo nanminꞌ na jndë tyincyaꞌhan ntꞌö, macꞌan vi nayaꞌñeen nnonꞌ ntyja ꞌnaanhan na quenꞌ cüentahan yo juu najndei na matsixuanꞌ chaꞌ ntsꞌaahanꞌ ninncüii nnanꞌxuanhan chaꞌxjen ninncüii condui jaa. ");
INSERT INTO azgNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Nque nnꞌan na jndë tyincyaꞌ ntꞌö, xjen na tomꞌan quiiꞌ ntꞌanhan, toquën cüentahan yo juu najndei na matsixuanꞌ. Ndoꞌ xiaꞌntyi nquii tsan na itsixuan na ngitsu, tsuhin, tanin ncüiichen joohan na tsu. Nndaꞌ tui chaꞌ juu jñꞌonꞌ na jndui, quitsiquindëhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Majoꞌ nein mavaa xjen na ncjö ntcüꞌë na mꞌanꞌ. Ndoꞌ matsinën jñꞌoonmin viochen xjen na ninvaa mꞌan tsonnangue chaꞌ juu na condui na nën, ntsiquindëhanꞌ juuhanꞌ quiiꞌ nꞌon nanminꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jndë tyincya jñꞌoon naya ꞌnanꞌ ndëëhan, majoꞌ nnꞌan tsonnangue tyiꞌcueeꞌ nꞌonhin nanꞌñeen. Nndaꞌ vaa ngꞌe tyiꞌquinanꞌxuanhan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Chito macꞌan nnonꞌ na cüjiꞌ joohan quiꞌntꞌan nnꞌan tsonnangue, majoꞌ quitsiquindyaꞌ joohan nin ꞌnan na ninꞌquitsꞌaa juu yutyia yohan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Juu na tsixuan tsonnangue, tavicotsamꞌanhin tyquiiꞌhanꞌ chaꞌxjen min ncö tyiꞌjö mꞌan ntyja ꞌnaanꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Juu jñꞌonꞌ conduihanꞌ na mayuuꞌ. Macꞌan nnonꞌ na quitsijiꞌuaꞌhan yo maninjuuntyi jñꞌoonꞌñeen. Juu jñꞌoon naya ꞌnanꞌ conduihanꞌ na mayuuꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ndoꞌ chaꞌxjen na jñonꞌ nnön na jndyö tsonnangue, mantyi maꞌua ja tsꞌian ndëëhan na coquitjiꞌ jndyoyuhan ntyja ꞌnanꞌ ndëë nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Maquën ncö na jiꞌua condui ja ntyja ꞌnaanhan chaꞌ ntyja ꞌnaanꞌ jñꞌoon na mayuuꞌ, ntquenhanꞌhin na jiꞌua conduihan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ndoꞌ chito xiaꞌntyi ntyja ꞌnaan nanminꞌ na macꞌan vi naya nnonꞌ. Mantyi macꞌan na quitejndeiꞌ nque nnꞌan na xejnda ngantyja nꞌonhan ja yo jñꞌoon na ntjiꞌ jndyoyu nanminꞌ, ");
INSERT INTO azgNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Cha na ninncüii nanꞌxuanhan, chaꞌxjen ꞌuꞌ Tyeꞌ ninncüii condui ꞌuꞌ yo ja, ndoꞌ ja ninncüii condui ja yo ꞌuꞌ, ee na nndui na nndaꞌ, mantyi joohan nndëë nnanꞌxuanhan na ninncüii conduihan yo jaa. Ndoꞌ vi na jndë na condui na nndaꞌ, yajoꞌ joo nnꞌan tsonnangue ngantyja nꞌonhan na ncuꞌ jñonꞌ ja nquiiꞌ ntꞌan nnꞌan tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ntyja na tyincyaꞌ na tsiquinjonhanꞌ ja, mantyi jndë tyincya na nanꞌxuanhan juuhanꞌ chaꞌ na ninncüii nnanꞌxuanhan chaꞌxjen jaa ninncüii condui jaa. ");
INSERT INTO azgNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ja mꞌan yohan, ndoꞌ ꞌuꞌ mꞌanꞌ yo ja. Manndaꞌ vaa ntsꞌaahanꞌ na ninncüii conduihan. Ndoꞌ na nndaꞌ, ncüaaꞌ nꞌon nnꞌan na ncuꞌ jñonꞌ ja ndoꞌ na venchjiꞌ joohan chaꞌxjen na ventyjiꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ꞌUꞌ Tyeꞌ, nque nnꞌan na mancyaꞌ ntꞌö, ntꞌue tsꞌön na ninncyaꞌ na ncꞌonhan naijon na mꞌan, chaꞌ nndëë ntyꞌia ndëëhan juu na itsiquinjonhanꞌ ja. Ngꞌe vitjachen na tquenꞌ tsonnangue, ꞌuꞌ viꞌntyjiꞌ ja. ");
INSERT INTO azgNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ꞌUꞌ Tyeꞌ na jndyoyu condui ꞌuꞌ, nnꞌan tsonnangue tyiꞌndicüaaꞌ nꞌonhan ntyja ꞌnanꞌ, majoꞌ ja mavajnꞌan ꞌuꞌ ndoꞌ nanminꞌ na cotsayꞌonhan yo jñꞌoon na mancyaꞌ, covaaꞌ nꞌonhan na ncuꞌ jñonꞌ ja quiiꞌ ntꞌanhan. ");
INSERT INTO azgNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jndë siꞌman ntyja ꞌnanꞌ ndëëhan, ndoꞌ ntsiꞌmanntyëchën ndëëhan chaꞌ juu na venchjiꞌ ja, mantyi ncꞌoonhanꞌ quiiꞌ nꞌonhan. Ntyja ꞌnaanꞌ juuhanꞌ mantyi ja ncꞌön quiiꞌ nꞌonhan.” ");
INSERT INTO azgNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Vi na jndë sinin Jesús jñꞌoonminꞌ nnon Tyoꞌtsꞌon, mana jnduiꞌ jon naijon na tomꞌaan jon yo já nnꞌan na tꞌman jon na quitsayꞌö́n jñꞌoon yohin. Tetꞌiö́ tsjoꞌ Cedrón. Squë́ ncüii joo naijon min ntjon, joꞌ santyjá na tëqueeꞌ jon joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ndoꞌ mantyi juu ntyjë́ Judas, tsan na tyincyaa cüenta jon, ntyjii juu yuujon vaa ntjonꞌñeen ee jndye jnda totsá joꞌ yo Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Juu Judasꞌñeen, tyꞌoon juu cüenta ncüii tmaanꞌ sondaro yo vendye nanntꞌei ꞌnaan ntyee na conintque, ndoꞌ yo nnꞌan tmaanꞌ fariseos. Tachu juu nanꞌñeen joꞌ. Tyechohan lámpara na covixuee chon yo chon ntca quindu yo ntꞌö tsꞌian tyiaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ndoꞌ Jesús, ntyjii jndaꞌ jon tsoñꞌen na mavaa xjen na ngenon jon, mangꞌe joꞌ jnduiꞌ jon, taquitjonhin nanꞌñeen. Taxeeꞌ jon ndëëhan, tso jon: —¿Nin tsꞌan cojntꞌuehoꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tꞌa nanꞌñeen, jnduehan: —Já cojntꞌuë́ Jesús, tsan na jnan Nazaret. Tso jon: —Maja ndö. Ndoꞌ mantyi juu ntyjë́ Judas na tyincyaa juu cüentahin, ñꞌenhin yo nanꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ndoꞌ juu xjen na tso Jesús: “Maja ndö”, quintyjachen sanon tonquenꞌhan, tycyaahan tyuaa. ");
INSERT INTO azgNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ndoꞌ taxeeꞌ nndaꞌ Jesús ndëëhan: —¿Nin nquii tsꞌan cojntꞌuehoꞌ? Tꞌa nndaꞌhan ꞌndyo jon: —Juu Jesús tsan na jnan Nazaret. ");
INSERT INTO azgNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tꞌa nndaꞌ Jesús jndyuehan: —Jndë tsjö na maja ndö. Yajoꞌ xe na aa ja cojntꞌuehoꞌ, quiꞌndyehoꞌ na chi ncꞌo nanmin. ");
INSERT INTO azgNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nndaꞌ tui chaꞌ quitsiquindëhanꞌ juu jñꞌoonꞌñeen na tso jon xjen na sinin jon nnon tye jon. Ee tso jon: “Tacotsiquitsu minꞌncüii joo nnꞌan na tyincyaꞌ ntꞌö.” ");
INSERT INTO azgNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Juu xjen na nndaꞌ tꞌa Jesús, juu Simón Pedro, tjiꞌ jon xjo na yꞌoon jon. Ndoꞌ juu tsan na jndyu Malco, tyjee jon tsöꞌnqui tsanꞌñeen ntyjaya. Juu Malcoꞌñeen ityentjon juu nnon nquii tyee na conintque ndëë nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ndoꞌ na nndaꞌ sꞌaa Pedro, tso Jesús nnon jon: —Quityionꞌ ntcüeꞌ juu xjoꞌ quiiꞌ tjanvaaꞌhanꞌ. ¿Aa matsitiuꞌ na tyiꞌquichuhanꞌ na ngenön naviꞌ tꞌman na sijndaꞌ Tyëhöꞌ na quitjön? ");
INSERT INTO azgNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ndoꞌ nque sondaroꞌñeen yo capitán na conintque ndëëhan yo ninꞌnanntꞌei ꞌnaan ntyee na conintque ndëë nnꞌan judíos, tꞌuehan Jesús, jnanꞌtyenhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ndoꞌ tyeyꞌon jndyeehan jon na mꞌaan nquii Anás, xeenꞌ juu tyee na jndyu Caifás na juu chuꞌñeen conintquehin ndëë tsoñꞌen ntyee. ");
INSERT INTO azgNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Manquiintyi Caifásꞌñeen siquiꞌmaanꞌ jon nnꞌan judíos na yantyichen na cueꞌ ncüii tsꞌan cüenta tsoñꞌen ntyjehan. ");
INSERT INTO azgNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ve já, nquii Simón Pedro yo ja Juan, santyjá na tonquenꞌ nanꞌñeen. Juu tyee na conintque vajnaanꞌ jon ja. Mangꞌe joꞌ tyjëcꞌë tochꞌen vaaꞌ jon xjen na tyeyꞌonhan Jesús joꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Majoꞌ juu Pedro tacüentyjeeꞌ jon ꞌndyo teon. Ndoꞌ ngꞌe juu tyee na conintque, vajnaanꞌ ya jon ja, joꞌ jntꞌui chꞌen, sinën yo tsanscu na iquen cüenta ꞌndyo teonꞌñeen. Ndoꞌ tyincyaa juu jñꞌoon na taqueeꞌ Pedro chꞌeenꞌ juu vꞌaaꞌñeen. ");
INSERT INTO azgNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yajoꞌ juu tsanscu na iquen cüenta ꞌndyo teonꞌñeen, itso juu nnon Pedro: —¿Aa chito ꞌuꞌ ncüii joo nnꞌan na tqueenꞌ tsanvaꞌ na quitsayꞌon jñꞌoon yohin? Tꞌa Pedro, itso jon nnon juu: —Minꞌchjo chito aa ja. ");
INSERT INTO azgNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ndoꞌ joo nnꞌan na cotyentjon joꞌ, yo vendye nanntꞌei ꞌnaan nnꞌan judíos na cotyeꞌntjonhan vatsꞌon tꞌman, jndë jnanꞌcüꞌahan ñon. Minntyjeeꞌ nanꞌñeen na cotꞌonhan chon ee tein jndyi. Ndoꞌ mantyi nquii Pedro, majoꞌ minntyjeeꞌ jon quiiꞌ ntꞌanhan na toonꞌ jon chon. ");
INSERT INTO azgNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Juu tyeeꞌñeen na conintque ndëë ntyee, taꞌ jon na taxeeꞌ jon nnon Jesús nin já nnꞌan na tqueenꞌ jon na quitsayꞌö́n jñꞌoon yohin, ndoꞌ mantyi ntyja ꞌnaanꞌ juu jñꞌoon na toninncyaa jon. ");
INSERT INTO azgNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ndoꞌ tꞌa Jesús ꞌndyo jon: —Tacotsinën ndëë nnꞌan na veꞌ vantyꞌiuuꞌ. Totsiꞌman ndëë ntyjëëhë nnꞌan judíos quiiꞌ ntꞌaanꞌon ꞌnaanhan yo vatsꞌon tꞌman naijon na covatjonhan. Tyíꞌcotsinën jñꞌoon na veꞌ cüanntyi tsꞌan na ndyii. ");
INSERT INTO azgNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ngꞌe na nndaꞌ, ¿ndu na mavaxeeꞌ nnön? Nque nnꞌan na jndë jndye jñꞌoon na toninncya, ndëë joohan cuaxeꞌ nchu vaa jñꞌoon na totsjö. Nanꞌñeen ngio jndaꞌhan jñꞌoon na totsiꞌman. ");
INSERT INTO azgNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ndoꞌ vi na jndë tso Jesús jñꞌoonvaꞌ, ncüii tsanjntꞌei na conintque na ityentjon juu ndëë ntyee na mꞌan vatsꞌon tꞌman, tyincyaa juu ncüii ndaꞌchcya ꞌndyo jon. Tso juu nnon jon: —¿Aa nndaꞌ vaa ncüꞌaꞌ ꞌndyo nquii jon na conintque ndëë ntyee cüenta jaa? ");
INSERT INTO azgNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tꞌa Jesús, itso jon: —Juu jñꞌoon na tsjö, xe na aa tyiahanꞌ, cüjiꞌ jndyoyuꞌ ntyja ꞌnaanꞌhanꞌ. Majoꞌ xe matsinën chaꞌxjen na chuhanꞌ, yajoꞌ ¿Ndu macüjaꞌ ja? ");
INSERT INTO azgNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ndë joꞌ ninvaa tyen Jesús, scüanon Anásꞌñeenhin ntꞌö Caifás, tyee na conintque ndëë nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ndoꞌ viochen xjen na minntyjeeꞌ Pedro na itoonꞌ jon chon, nnꞌan na mꞌan joꞌ, taxeeꞌhan nnon jon: —¿Aa chito maꞌuꞌ ncüii nque nnꞌan na cotsayꞌon jñꞌoon yo Jesús? Majoꞌ tjihin, itso jon: —Minꞌchjo chito aa ja. ");
INSERT INTO azgNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ndoꞌ joꞌ mꞌaan ncüii tsꞌan na ityentjon juu nnon nquii tyee na conintque. Mannꞌan chuuꞌhin yo juu tsan na tyjee Pedro tsöꞌnqui. Itso tsanꞌñeen nnon Pedro: —¿Aa chi maꞌuꞌ na jntyꞌia na mꞌanꞌ yo Jesús quityquiiꞌ juu ntjonꞌñeen? ");
INSERT INTO azgNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Majoꞌ tji nndaꞌ Pedro, ndoꞌ ninñoonꞌ sixuaa quilꞌö. ");
INSERT INTO azgNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Yajoꞌ nnꞌan judíosꞌñeen jnduiꞌhan vaaꞌ Caifás, tyeyꞌonhan Jesús, squehan vatsꞌian naijon mꞌaan gobernado yo sondaro ꞌnaanꞌ jon. Xjenꞌñeen ninvaa vitsjoonhanꞌ. Majoꞌ taꞌnan tyequeꞌhan joꞌ, ee xe na aa ntsaqueꞌhan, juu na tyiꞌjiꞌua na nanꞌxuan nanꞌñeen, ncüꞌahanꞌ joohan ndoꞌ tsojnaanꞌ joꞌ, tajeꞌncyaahanꞌ na nnanꞌjonhan na ntcüaꞌhan quitsman chjo yo ntyjehan nnꞌan judíos. ");
INSERT INTO azgNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ngꞌe na nndaꞌ, nquii Pilato jnduiꞌ jon quiiꞌ vꞌaaꞌñeen, tatsinin jon ndëëhan. Taxeeꞌ jon: —¿Nin jnaanꞌ tsanvaꞌ na ndyoquitquenhoꞌ nnön? ");
INSERT INTO azgNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Tꞌahan, jnduehan nnon jon: —Xeꞌquindyoyꞌönhin na mꞌanꞌ xe na aa tsꞌan ya tsꞌanhin. ");
INSERT INTO azgNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Yajoꞌ tso Pilato ndëë joo judíosꞌñeen: —Quitsayꞌon nquehoꞌ juu. Quitoxenhoꞌ jnaanꞌ juu yo ntyja ꞌnaanꞌ juu ntji na conanꞌyꞌonhoꞌ na icoꞌxenhanꞌ. Majoꞌ tꞌa nanꞌñeen ꞌndyo jon: —Taꞌnan najndei nanꞌxuán na nnanꞌcuë́ꞌ tsꞌan. ");
INSERT INTO azgNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Nndaꞌ tui chaꞌ quitsiquindëhanꞌ juu jñꞌoon na sinin Jesús na siꞌman jon nin ncüii nnon na ngueꞌ jon. ");
INSERT INTO azgNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ndoꞌ ya na jndyii Pilato na nndaꞌ, tëqueeꞌ nndaꞌ jon quii vatsꞌian ꞌnaanꞌ jon. Ndoꞌ taxeeꞌ jon nnon Jesús: —ꞌUꞌ jeꞌ, ¿Aa ꞌuꞌ nquii tsan na taquintyja tꞌman conduihin na ntcoꞌxenꞌ ntyꞌiuꞌ nnꞌan judíos? ");
INSERT INTO azgNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tꞌa Jesús: —Juu jñꞌoon na mavaxeꞌ, ¿Aa matsuꞌhanꞌ ngꞌe na mavaaꞌ nquii tsonꞌ? Ndoꞌ ¿Aa mꞌaan nin juu na tso nnonꞌ na joꞌ condui ja? ");
INSERT INTO azgNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tꞌa Pilato ꞌndyo Jesús: —Ja aa veꞌ tsꞌan judío condui ja ntyjiꞌ. Nque nnꞌan ndyuaa na mꞌanhoꞌ yo joo nnꞌan na conintque ndëë ntyee cüentahoꞌ, joohan tyincyahan cüenta ꞌuꞌ ntꞌö. ¿Nin nquii ꞌnan saꞌ? ");
INSERT INTO azgNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tꞌa Jesús: —Juu na condui ja na macoꞌxën, tyiꞌcꞌoonhanꞌ ntyja ꞌnaanꞌ tsonnangue. Xe na aa ntyja ꞌnaanꞌ tsonnangueva macoꞌxën, yajoꞌ joo nnꞌan na cotsayꞌon jñꞌoon yo ja, ntꞌahan tyiaꞌ chaꞌ na tyiꞌninncyaa tsꞌan cüenta ja nduee ntyjë́ nnꞌan judíos, majoꞌ juu na condui ja na macoꞌxën, tyiꞌtsixuanhanꞌ ntyja ꞌnaanꞌ tsonnangue. ");
INSERT INTO azgNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ndoꞌ tso Pilato nnon Jesús: —¿Aa ncuꞌ condui tsꞌan na taquintyja tꞌman na macoꞌxenꞌ nnꞌan? Tꞌa Jesús ꞌndyo jon: —Mancüiixjen majoꞌ condui ja. Ngꞌe joꞌ tui ja na jndyö tsonnangue chaꞌ ncüjiꞌ jndyoyu ntyja ꞌnaanꞌ juu jñꞌoon na conduihanꞌ mayuuꞌ. Ncüii cüii tsꞌan na itsijonhin yo jñꞌoonꞌñeen, indyii tsanꞌñeen jñꞌoon na mancya. ");
INSERT INTO azgNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ndoꞌ tꞌa Pilato, tso jon nnon Jesús: —Juu na matsuꞌ na conduihanꞌ jñꞌoon na mayuuꞌ, jeꞌcüaaꞌ tsꞌon tsꞌan nin ꞌnan ninꞌquitsiquindyihanꞌ. Ndoꞌ vi na jndë tso Pilato na nndaꞌ, jnduiꞌ nndaꞌ jon tondëë nnꞌan judíosꞌñeen. Itso jon ndëëhan: —Taꞌnan jnaanꞌ tsanvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Majoꞌ ꞌoꞌ nnꞌan judíos, nguee na cotquiihoꞌ quitsman chjo, vaa costumbre quiiꞌ ntꞌanhoꞌ na quitsiquindya ja ncüii tsꞌan na mꞌaan naviꞌ na ninncyahin ndueehoꞌ. Yajoꞌ juu tsan na taquintyja tꞌman conduihin na coꞌxen juuhoꞌ, ¿Aa ntꞌue nꞌonhoꞌ na quitsiquindyahin? ");
INSERT INTO azgNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ndoꞌ joo nanꞌñeen, jnanꞌxuaahan, jnduehan: —Chito tsanvaꞌ ntsiquindyaꞌ. Quitsiquindyaꞌ Barrabás. Nndaꞌ vaa jñꞌoon na tan nanꞌñeen. Ndoꞌ juu Barrabásꞌñeen, tsanchꞌueehin. ");
INSERT INTO azgNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Yajoꞌ tꞌua Pilato tsꞌian na quitjaꞌ sondaro Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ndoꞌ nque sondaroꞌñeen jeꞌ, jnanꞌyahan tseineon, jndë joꞌ tyionhinhanꞌ xquen Jesús, ndoꞌ jnanꞌcüehan ncüii ndiaatcohin colo venton, chaꞌ vaa ndiaa cocüe nnꞌan na tëquintyja na cotoꞌxen. ");
INSERT INTO azgNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ndë joꞌ jnanꞌndyooꞌhan nnon jon. Veꞌ toncohan, jnduehan: —ꞌUꞌ na coꞌxenꞌ joo nnꞌan judíos, vaa tꞌman condui ꞌuꞌ. Ndoꞌ totueinꞌhan ndaꞌ ꞌndyo jon. ");
INSERT INTO azgNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Yajoꞌ jnduiꞌ nndaꞌ Pilato tondëë nnꞌan judíosꞌñeen. Itso jon: —Quijntyꞌiahoꞌ, macüjiꞌhin chꞌen tondëëhoꞌ chaꞌ cüaaꞌ ya nꞌonhoꞌ na minꞌncüii jnan na tatijndaꞌ ntyja ꞌnaanꞌ juu. ");
INSERT INTO azgNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Xjenꞌñeen jnduiꞌ Jesús tondëëhan na ñjon juu tseineonꞌñeen xquen jon, ndoꞌ cüe jon ndiaatco colo venton. Tso Pilato ndëëhan: —Quijntyꞌiahoꞌ, ndö juu. ");
INSERT INTO azgNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ndoꞌ joo ntyee na conintque yo nanntꞌei ꞌnaanhan, xjen na jntyꞌiahin Jesús, tyeꞌ jnanꞌxuaahan: —Quitꞌionꞌhin tsonjnꞌaan, quitꞌionꞌhin tsonjnꞌaan. Tꞌa Pilato jndyuehan: —Nquehoꞌ cyꞌonhoꞌ cüentahin ndoꞌ quitꞌionhoꞌhin tsonjnꞌaan ee ja chen chen jndë tajndöhin ndoꞌ minꞌncüii jnan tyiꞌtsixuan juu. ");
INSERT INTO azgNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Majoꞌ joo nnꞌan judíosꞌñeen, tꞌa nndaꞌhan, jnduehan: —Min ntji na conanꞌyꞌö́n na icoꞌxenhanꞌ, ndoꞌ ntyja ꞌnaanꞌhanꞌ tsixuan juu na cueꞌ juu ee itsꞌaa nquii juu na conduihin jnda Tyoꞌtsꞌon. ");
INSERT INTO azgNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ndoꞌ juu Pilato, vi na jndë jndyii jon jñꞌoonvaꞌ, sityꞌuehanꞌhin. ");
INSERT INTO azgNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Taqueeꞌ nndaꞌ jon vatsꞌian ꞌnaanꞌ jon. Joꞌ taxeeꞌ nndaꞌ jon nnon Jesús: —ꞌUꞌ ¿Yuu jon jnanꞌ? Majoꞌ minꞌncüii jñꞌoon tyíꞌcüꞌa Jesús. ");
INSERT INTO azgNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ndoꞌ tso Pilato nnon jon: —¿Ndu na tyiꞌcüꞌaꞌ ꞌndyö? Ja vaa najndö na ntsiquindya ꞌuꞌ, ndoꞌ na aa ntꞌiön ꞌuꞌ tsonjnꞌaan. ");
INSERT INTO azgNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ndoꞌ joꞌ tꞌa Jesús: —Xe chito nquii Tyoꞌtsꞌon tyincyaa na vaa najnduꞌ, minꞌncüii nnon ꞌnan jeꞌquindëë ntsaꞌ yo ja. Ngꞌe joꞌ juu tsan na tyincyaa ja ntꞌöꞌ, tꞌmanntyichen jnan tsixuan juu, chichen jnan na tsixuanꞌ ncuꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Ndoꞌ vi na jndë jndyii Pilato jñꞌoonvaꞌ, sichon jon na ninꞌquitsiquindyaa jon Jesús. Majoꞌ nque nnꞌan na conintque ndëë nnꞌan judíos jnanꞌxuaahan, jnduehan: —Xe na aa ntsiquindyaꞌ tsanvaꞌ, tyiꞌya jñꞌoon ꞌuꞌ yo César, nquii tsanmꞌaantsꞌian tꞌman. Ee minꞌcya ro tsꞌan na ninꞌcꞌoon juu tsꞌian na taquintyja tꞌman, vja tsanꞌñeen nacjooꞌ nquii César. ");
INSERT INTO azgNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ndoꞌ juu Pilato jeꞌ, vi na jndë jndyii jon jñꞌoonminꞌ, tjiꞌ jon Jesús tondëëhan. Joꞌ tëcjo jon silla na maninꞌ tsꞌiaanꞌ ꞌnaanꞌ jon ncüii joo na jndyu Nata Ntjöꞌ yuu naijon na icoꞌxen jon jñꞌoon. Majoꞌ yo jñꞌoon na conanꞌnein nnꞌan judíos jndyu nataꞌñeen Gabata. ");
INSERT INTO azgNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Juu xuee na tui nanꞌvaꞌ, majuu xuee na jaa nnꞌan judíos conanꞌjntꞌa na ntquë quitsman chjo. ꞌNanꞌ vaa tuihanꞌ chaꞌ na yajminꞌ. Yajoꞌ tso Pilato ndëë nnꞌan judíosꞌñeen: —Quijntyꞌiahoꞌ, ndö juu tsꞌan na taquintyja tꞌman conduihin na coꞌxen juuhoꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Majoꞌ nanꞌñeen jnanꞌxuaahan: —Quitscueꞌhin. Quitscueꞌhin. Quitꞌionꞌhin tsonjnꞌaan. Tso Pilato ndëëhan: —Nquii tsꞌan na taquintyja tꞌman conduihin na icoꞌxen juuhoꞌ, tyiꞌquichuhanꞌ na quitꞌiönhin tsonjnꞌaan. Joo ntyee na conintqueꞌñeen, tꞌahan, jnduehan: —Aa já taꞌnan ncüiichen tsꞌan na conintꞌman tondë́ na coꞌxen jon já, xiaꞌntyi nquii César. ");
INSERT INTO azgNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ndoꞌ vi matsꞌiañꞌen tyincyaa Pilato Jesús nduee nanꞌñeen na ntꞌionhan jon tsonjnꞌaan. Ndoꞌ tyꞌon nanꞌñeen cüentahin, tyeyꞌonhan jon. ");
INSERT INTO azgNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ndoꞌ juu tsonjnꞌaan na jñon sondaro Jesús, tayꞌoon jonhanꞌ ncüii tyoꞌ na jndyu Tsiꞌ Xquentsꞌoo. Majoꞌ yo jñꞌoon na conanꞌnein nnꞌan judíos jndyuhanꞌ Gólgota. ");
INSERT INTO azgNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Joꞌ tꞌion sondaroꞌñeen jon tsonjnꞌaan. Ndoꞌ mantyi joꞌ ncüiichen ve nnꞌan, tꞌionhan nanꞌñeen nonjnꞌaan, ncüii cüii tsanꞌñeen na vi ntyjaaꞌ jon, ndoꞌ jon xoncüe ya. ");
INSERT INTO azgNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ndoꞌ juu Pilato tꞌua jon tsꞌian na jndui jñꞌoon na tꞌionhan xquen juu tsonjnꞌaanꞌñeen. Itso jñꞌoonꞌñeen: “Ndö Jesús tsan na jnan Nazaret. Juu jon tsꞌan na taquintyja tꞌman conduihin na icoꞌxen jon nnꞌan judíos.” ");
INSERT INTO azgNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ndoꞌ jndye nnꞌan judíos jnanꞌjnꞌaanhan juu jñꞌoonꞌñeen ee yuu naijon tꞌion sondaroꞌñeen Jesús tsonjnꞌaan, ndyo ꞌndyo tsjoonhanꞌ. Juu jñꞌoonꞌñeen jnduihanꞌ yo jñꞌoon hebreo na conanꞌnein nnꞌan judíos, mantyi yo jñꞌoon latyen na conanꞌnein nnꞌan romanos ndoꞌ yo ninꞌjñꞌoon griego na conanꞌnein nnꞌan griegos. ");
INSERT INTO azgNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Majoꞌ ntyee na conintque cüenta nnꞌan judíos, tanhan vi nayaꞌñeen nnon Pilato. Jnduehan: —Nndaꞌ ta, juu tsanvaꞌ, tyiꞌncüjiꞌ na condui tꞌmanhin na icoꞌxen juu já nnꞌan judíos. Xiaꞌntyi cüjiꞌ: Itso tsanvaꞌ: “Ja condui tꞌman na macoxën nnꞌan judíos.” ");
INSERT INTO azgNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Majoꞌ tꞌa Pilato jndyuehan, itso jon: —Jñꞌoon na jndë jndui, tajeꞌquitscüejndyöhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ndoꞌ vi na jndë tꞌion sondaroꞌñeen Jesús tsonjnꞌaan, yajoꞌ ninnquehan tyꞌonhan cüenta ncüii cüii ndiaaꞌ jon. Mantyi tyꞌonhan cüenta juu ndiaatco ꞌnaanꞌ jon na tayuu ñjonꞌhanꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ndoꞌ jnduehan ndëë ntyjehan: —Tyiꞌnanꞌtiuutöhanꞌ, cüa, ncꞌö xꞌiaaꞌ chaꞌ njntyꞌia nin ncüii jaa na ndijnoonꞌhanꞌ. Nndaꞌ vaa jntꞌahan chaꞌ quitsiquindëhanꞌ juu jñꞌoonꞌ Tyoꞌtsꞌon na jndui tivio nnon tson Salmos na itsohanꞌ: “Tꞌonhan ncüii cüii ndiaa ndëë ntyjehan, ndoꞌ tyꞌehan xꞌiaaꞌ na tantjonhan juu ndiaatco njan.” Ndoꞌ jntꞌa sondaroꞌñeen chaꞌxjen itsiquindyi jñꞌoonvaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ndoꞌ ngiaaꞌ juu tsonjnꞌaan na ñoon Jesús, joꞌ minntyjeeꞌ ndyee jon yo tyje ndyee jon, juu María scuuꞌ Cleofas, yo ninꞌncüiichen María na jnan tsjoon Magadán. ");
INSERT INTO azgNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ndoꞌ mantyi ja na jen venchjii Jesús na tqueenꞌ jon na quitsijön yo jñꞌoon na toninncyaa jon, ventyjëꞌ ja joꞌ. Vi na jndë jndyiaaꞌ jon na ventyjeeꞌ ndyee jon ncꞌia, tso jon nnon juu: —ꞌUꞌ ꞌndyoꞌ, tsanvahin conduihin jndaꞌ. ");
INSERT INTO azgNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jndë joꞌ tso Jesús nnön: —Juu ndyöhöꞌ na mꞌaan ndö, cyonꞌ cüentahin chaꞌvijon na conduihin ꞌndyoꞌ ncuꞌ. Ndoꞌ majuu xjenꞌñeen tyꞌön cüenta ndyee jon, tyjëyꞌönhin vꞌa. Totixëꞌhin chaꞌvijon na conduihin ndyö ncö. ");
INSERT INTO azgNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ndoꞌ vi na jndë tui na nndaꞌ, ntyjii Jesús na tsoñꞌen jñꞌoonꞌ Tyoꞌtsꞌon na jndë tondui ntyja ꞌnaanꞌ jon, jndë siquindëhanꞌ joohanꞌ. Yajoꞌ itso jon: —Ninꞌcꞌ